
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  132 ( 1042),  selected  132 , name 2dwy_C
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 2dwy_C.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    I   507_C      E     267           -
LGA    K   508_C      D     268           -
LGA    P   509_C      L     269           -
LGA    S   510_C      L     270           -
LGA    I   512_C      -       -           -
LGA    L   513_C      -       -           -
LGA    P   514_C      -       -           -
LGA    V   515_C      -       -           -
LGA    T   516_C      -       -           -
LGA    V   517_C      -       -           -
LGA    Y   518_C      R     271           #
LGA    D   519_C      P     272          3.080
LGA    Q   520_C      F     273          1.284
LGA    H   521_C      -       -           -
LGA    G   522_C      F     274           #
LGA    F   523_C      E     275           #
LGA    R   524_C      K     276          1.727
LGA    -       -      C     277           -
LGA    I   525_C      V     278          1.581
LGA    L   526_C      K     279          2.886
LGA    F   527_C      I     280          1.991
LGA    H   528_C      E     281          1.158
LGA    F   529_C      E     282          1.252
LGA    A   530_C      V     283          2.151
LGA    R   531_C      S     284          2.596
LGA    -       -      R     285           -
LGA    D   532_C      N     286           #
LGA    P   533_C      -       -           -
LGA    L   534_C      -       -           -
LGA    P   535_C      -       -           -
LGA    G   536_C      -       -           -
LGA    R   537_C      -       -           -
LGA    S   538_C      E     287          2.390
LGA    D   539_C      Q     288          0.504
LGA    V   540_C      G     289          2.327
LGA    L   541_C      V     290          1.115
LGA    V   542_C      T     291          1.067
LGA    V   543_C      L     292          1.309
LGA    V   544_C      S     293          1.245
LGA    V   545_C      I     294          1.092
LGA    S   546_C      T     295          1.296
LGA    M   547_C      N     296          1.940
LGA    L   548_C      V     297          1.810
LGA    S   549_C      T     298          3.377
LGA    T   550_C      -       -           -
LGA    A   551_C      -       -           -
LGA    P   552_C      -       -           -
LGA    Q   553_C      -       -           -
LGA    P   554_C      D     299          5.128
LGA    I   555_C      L     300          2.873
LGA    R   556_C      -       -           -
LGA    N   557_C      V     301          4.344
LGA    I   558_C      L     302          2.165
LGA    V   559_C      K     303          0.762
LGA    F   560_C      L     304          2.326
LGA    Q   561_C      K     305          2.848
LGA    S   562_C      K     306          3.328
LGA    A   563_C      T     307          4.167
LGA    -       -      A     308           -
LGA    V   564_C      H     309          3.076
LGA    P   565_C      D     310          0.867
LGA    K   566_C      T     311          1.401
LGA    V   567_C      L     312          2.277
LGA    M   568_C      L     313          2.464
LGA    K   569_C      V     314          1.361
LGA    V   570_C      Y     315          0.674
LGA    K   571_C      F     316          2.313
LGA    -       -      R     317           -
LGA    L   572_C      D     318          6.026
LGA    Q   573_C      M     319          5.968
LGA    P   574_C      T     320          5.523
LGA    P   575_C      L     321          3.890
LGA    S   576_C      -       -           -
LGA    G   577_C      -       -           -
LGA    T   578_C      K     322          2.976
LGA    E   579_C      P     323          4.017
LGA    L   580_C      -       -           -
LGA    P   581_C      -       -           -
LGA    A   582_C      -       -           -
LGA    F   583_C      -       -           -
LGA    N   584_C      -       -           -
LGA    P   585_C      -       -           -
LGA    I   586_C      -       -           -
LGA    V   587_C      -       -           -
LGA    H   588_C      -       -           -
LGA    P   589_C      -       -           -
LGA    S   590_C      -       -           -
LGA    A   591_C      H     324          1.889
LGA    I   592_C      T     325          2.663
LGA    T   593_C      R     326          2.121
LGA    Q   594_C      Y     327          2.411
LGA    V   595_C      T     328          2.594
LGA    L   596_C      V     329          1.957
LGA    L   597_C      R     330          1.478
LGA    L   598_C      I     331          0.796
LGA    A   599_C      G     332          0.876
LGA    N   600_C      F     333          0.563
LGA    P   601_C      K     334          2.745
LGA    Q   602_C      Q     335          2.100
LGA    K   603_C      G     336          3.237
LGA    E   604_C      I     337          2.014
LGA    -       -      K     338           -
LGA    K   605_C      G     339          3.538
LGA    V   606_C      G     340          0.650
LGA    R   607_C      D     341          1.322
LGA    L   608_C      V     342          1.811
LGA    R   609_C      N     343          1.293
LGA    Y   610_C      F     344          1.914
LGA    K   611_C      E     345          1.161
LGA    L   612_C      V     346          1.372
LGA    T   613_C      T     347          3.323
LGA    F   614_C      N     348          3.556
LGA    T   615_C      -       -           -
LGA    M   616_C      -       -           -
LGA    G   617_C      -       -           -
LGA    D   618_C      -       -           -
LGA    Q   619_C      -       -           -
LGA    T   620_C      F     349           #
LGA    Y   621_C      I     350          2.555
LGA    N   622_C      V     351          5.587
LGA    -       -      A     352           -
LGA    -       -      P     353           -
LGA    -       -      D     354           -
LGA    -       -      K     355           -
LGA    -       -      G     356           -
LGA    E   623_C      L     357          1.035
LGA    M   624_C      K     358          0.848
LGA    G   625_C      Y     359          1.894
LGA    D   626_C      T     360          2.333
LGA    V   627_C      I     361          2.800
LGA    D   628_C      S     362          1.854
LGA    Q   629_C      -       -           -
LGA    F   630_C      L     363          2.137
LGA    P   631_C      -       -           -
LGA    P   632_C      -       -           -
LGA    P   633_C      -       -           -
LGA    E   634_C      -       -           -
LGA    T   635_C      -       -           -
LGA    W   636_C      -       -           -
LGA    G   637_C      -       -           -
LGA    S   638_C      -       -           -
LGA    L   639_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  132   97    5.0     78    2.61     2.56     52.835     2.876

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.417995 * X  +  -0.784510 * Y  +  -0.458066 * Z  +  49.704815
  Y_new =   0.471987 * X  +  -0.243290 * Y  +   0.847371 * Z  +  61.450066
  Z_new =  -0.776214 * X  +  -0.570398 * Y  +   0.268585 * Z  +  71.357224 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.130721    2.010871  [ DEG:   -64.7856    115.2144 ]
  Theta =   0.888638    2.252954  [ DEG:    50.9152    129.0848 ]
  Phi   =   0.845991   -2.295602  [ DEG:    48.4717   -131.5283 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dwy_C                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dwy_C.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  132   97   5.0   78   2.61    2.56  52.835
REMARK  ---------------------------------------------------------- 
MOLECULE 2dwy_C
HEADER    PROTEIN TRANSPORT                       21-AUG-06   2DWY              
TITLE     CRYSTAL STRUCTURE ANALYSIS OF GGA1-GAE                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ADP-RIBOSYLATION FACTOR BINDING PROTEIN GGA1;              
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: GAE DOMAIN, RESIDUES 507-639;                              
COMPND   5 SYNONYM: GOLGI-LOCALIZED, GAMMA EAR-CONTAINING, ARF-                 
COMPND   6 BINDING PROTEIN 1, GAMMA-ADAPTIN RELATED PROTEIN 1;                  
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PGEX4T-2                                  
KEYWDS    IG FOLD, ADAPTIN                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.INOUE,T.SHIBA,Y.YAMADA,K.IHARA,M.KAWASAKI,R.KATO,                   
AUTHOR   2 K.NAKAYAMA,S.WAKATSUKI                                               
REVDAT   3   03-JUL-07 2DWY    1       JRNL                                     
REVDAT   2   26-JUN-07 2DWY    1       REMARK                                   
REVDAT   1   17-APR-07 2DWY    0                                                
JRNL        AUTH   M.INOUE,T.SHIBA,K.IHARA,Y.YAMADA,S.HIRANO,                   
JRNL        AUTH 2 H.KAMIKUBO,M.KATAOKA,M.KAWASAKI,R.KATO,K.NAKAYAMA,           
JRNL        AUTH 3 S.WAKATSUKI                                                  
JRNL        TITL   MOLECULAR BASIS FOR AUTOREGULATORY INTERACTION               
JRNL        TITL 2 BETWEEN GAE DOMAIN AND HINGE REGION OF GGA1                  
JRNL        REF    TRAFFIC                       V.   8   904 2007              
JRNL        REFN                DK ISSN 1398-9219                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2DWY A  507   639  UNP    Q9UJY5   GGA1_HUMAN     507    639             
DBREF  2DWY B  507   639  UNP    Q9UJY5   GGA1_HUMAN     507    639             
DBREF  2DWY C  507   639  UNP    Q9UJY5   GGA1_HUMAN     507    639             
DBREF  2DWY D  507   639  UNP    Q9UJY5   GGA1_HUMAN     507    639             
SEQRES   1 A  133  ILE LYS PRO SER ASN ILE LEU PRO VAL THR VAL TYR ASP          
SEQRES   2 A  133  GLN HIS GLY PHE ARG ILE LEU PHE HIS PHE ALA ARG ASP          
SEQRES   3 A  133  PRO LEU PRO GLY ARG SER ASP VAL LEU VAL VAL VAL VAL          
SEQRES   4 A  133  SER MET LEU SER THR ALA PRO GLN PRO ILE ARG ASN ILE          
SEQRES   5 A  133  VAL PHE GLN SER ALA VAL PRO LYS VAL MET LYS VAL LYS          
SEQRES   6 A  133  LEU GLN PRO PRO SER GLY THR GLU LEU PRO ALA PHE ASN          
SEQRES   7 A  133  PRO ILE VAL HIS PRO SER ALA ILE THR GLN VAL LEU LEU          
SEQRES   8 A  133  LEU ALA ASN PRO GLN LYS GLU LYS VAL ARG LEU ARG TYR          
SEQRES   9 A  133  LYS LEU THR PHE THR MET GLY ASP GLN THR TYR ASN GLU          
SEQRES  10 A  133  MET GLY ASP VAL ASP GLN PHE PRO PRO PRO GLU THR TRP          
SEQRES  11 A  133  GLY SER LEU                                                  
SEQRES   1 B  133  ILE LYS PRO SER ASN ILE LEU PRO VAL THR VAL TYR ASP          
SEQRES   2 B  133  GLN HIS GLY PHE ARG ILE LEU PHE HIS PHE ALA ARG ASP          
SEQRES   3 B  133  PRO LEU PRO GLY ARG SER ASP VAL LEU VAL VAL VAL VAL          
SEQRES   4 B  133  SER MET LEU SER THR ALA PRO GLN PRO ILE ARG ASN ILE          
SEQRES   5 B  133  VAL PHE GLN SER ALA VAL PRO LYS VAL MET LYS VAL LYS          
SEQRES   6 B  133  LEU GLN PRO PRO SER GLY THR GLU LEU PRO ALA PHE ASN          
SEQRES   7 B  133  PRO ILE VAL HIS PRO SER ALA ILE THR GLN VAL LEU LEU          
SEQRES   8 B  133  LEU ALA ASN PRO GLN LYS GLU LYS VAL ARG LEU ARG TYR          
SEQRES   9 B  133  LYS LEU THR PHE THR MET GLY ASP GLN THR TYR ASN GLU          
SEQRES  10 B  133  MET GLY ASP VAL ASP GLN PHE PRO PRO PRO GLU THR TRP          
SEQRES  11 B  133  GLY SER LEU                                                  
SEQRES   1 C  133  ILE LYS PRO SER ASN ILE LEU PRO VAL THR VAL TYR ASP          
SEQRES   2 C  133  GLN HIS GLY PHE ARG ILE LEU PHE HIS PHE ALA ARG ASP          
SEQRES   3 C  133  PRO LEU PRO GLY ARG SER ASP VAL LEU VAL VAL VAL VAL          
SEQRES   4 C  133  SER MET LEU SER THR ALA PRO GLN PRO ILE ARG ASN ILE          
SEQRES   5 C  133  VAL PHE GLN SER ALA VAL PRO LYS VAL MET LYS VAL LYS          
SEQRES   6 C  133  LEU GLN PRO PRO SER GLY THR GLU LEU PRO ALA PHE ASN          
SEQRES   7 C  133  PRO ILE VAL HIS PRO SER ALA ILE THR GLN VAL LEU LEU          
SEQRES   8 C  133  LEU ALA ASN PRO GLN LYS GLU LYS VAL ARG LEU ARG TYR          
SEQRES   9 C  133  LYS LEU THR PHE THR MET GLY ASP GLN THR TYR ASN GLU          
SEQRES  10 C  133  MET GLY ASP VAL ASP GLN PHE PRO PRO PRO GLU THR TRP          
SEQRES  11 C  133  GLY SER LEU                                                  
SEQRES   1 D  133  ILE LYS PRO SER ASN ILE LEU PRO VAL THR VAL TYR ASP          
SEQRES   2 D  133  GLN HIS GLY PHE ARG ILE LEU PHE HIS PHE ALA ARG ASP          
SEQRES   3 D  133  PRO LEU PRO GLY ARG SER ASP VAL LEU VAL VAL VAL VAL          
SEQRES   4 D  133  SER MET LEU SER THR ALA PRO GLN PRO ILE ARG ASN ILE          
SEQRES   5 D  133  VAL PHE GLN SER ALA VAL PRO LYS VAL MET LYS VAL LYS          
SEQRES   6 D  133  LEU GLN PRO PRO SER GLY THR GLU LEU PRO ALA PHE ASN          
SEQRES   7 D  133  PRO ILE VAL HIS PRO SER ALA ILE THR GLN VAL LEU LEU          
SEQRES   8 D  133  LEU ALA ASN PRO GLN LYS GLU LYS VAL ARG LEU ARG TYR          
SEQRES   9 D  133  LYS LEU THR PHE THR MET GLY ASP GLN THR TYR ASN GLU          
SEQRES  10 D  133  MET GLY ASP VAL ASP GLN PHE PRO PRO PRO GLU THR TRP          
SEQRES  11 D  133  GLY SER LEU                                                  
FORMUL   5  HOH   *148(H2 O)                                                    
CRYST1   47.482   88.238   67.224  90.00  96.10  90.00 P 1 21 1      8          
ATOM   2024  N   ILE C 507       4.603  71.221  33.807  1.00 78.41           N  
ATOM   2025  CA  ILE C 507       5.861  71.965  34.118  1.00 78.51           C  
ATOM   2026  C   ILE C 507       6.465  71.514  35.448  1.00 78.84           C  
ATOM   2027  O   ILE C 507       7.662  71.689  35.686  1.00 78.46           O  
ATOM   2028  CB  ILE C 507       5.619  73.520  34.131  1.00 78.39           C  
ATOM   2029  CG1 ILE C 507       6.958  74.283  34.075  1.00 78.01           C  
ATOM   2030  CG2 ILE C 507       4.804  73.949  35.365  1.00 78.07           C  
ATOM   2031  CD1 ILE C 507       6.831  75.753  33.665  1.00 77.34           C  
ATOM   2032  N   LYS C 508       5.621  70.930  36.298  1.00 79.51           N  
ATOM   2033  CA  LYS C 508       5.939  70.681  37.708  1.00 80.26           C  
ATOM   2034  C   LYS C 508       6.209  69.213  38.113  1.00 80.75           C  
ATOM   2035  O   LYS C 508       7.087  68.969  38.938  1.00 80.42           O  
ATOM   2036  CB  LYS C 508       4.811  71.255  38.569  1.00 80.45           C  
ATOM   2037  CG  LYS C 508       5.068  72.671  39.031  1.00 80.49           C  
ATOM   2038  CD  LYS C 508       5.961  72.676  40.249  1.00 80.69           C  
ATOM   2039  CE  LYS C 508       5.370  71.847  41.390  1.00 80.20           C  
ATOM   2040  NZ  LYS C 508       3.879  71.769  41.380  1.00 78.68           N  
ATOM   2041  N   PRO C 509       5.427  68.249  37.611  1.00 81.59           N  
ATOM   2042  CA  PRO C 509       5.801  66.830  37.720  1.00 81.99           C  
ATOM   2043  C   PRO C 509       6.924  66.444  36.731  1.00 82.25           C  
ATOM   2044  O   PRO C 509       7.826  67.249  36.498  1.00 82.40           O  
ATOM   2045  CB  PRO C 509       4.474  66.084  37.438  1.00 82.01           C  
ATOM   2046  CG  PRO C 509       3.410  67.134  37.462  1.00 82.14           C  
ATOM   2047  CD  PRO C 509       4.094  68.400  36.992  1.00 81.88           C  
ATOM   2048  N   SER C 510       6.881  65.235  36.177  1.00 82.51           N  
ATOM   2049  CA  SER C 510       7.982  64.726  35.371  1.00 82.68           C  
ATOM   2050  C   SER C 510       7.480  64.148  34.056  1.00 82.66           C  
ATOM   2051  O   SER C 510       6.536  63.362  34.039  1.00 82.75           O  
ATOM   2052  CB  SER C 510       8.741  63.657  36.169  1.00 82.79           C  
ATOM   2053  OG  SER C 510       8.949  64.061  37.520  1.00 83.08           O  
ATOM   2054  N   ILE C 512      10.424  59.144  32.487  1.00 58.57           N  
ATOM   2055  CA  ILE C 512      11.133  58.590  31.329  1.00 58.75           C  
ATOM   2056  C   ILE C 512      12.291  57.686  31.723  1.00 58.14           C  
ATOM   2057  O   ILE C 512      13.104  58.040  32.592  1.00 57.64           O  
ATOM   2058  CB  ILE C 512      11.652  59.714  30.410  1.00 59.03           C  
ATOM   2059  CG1 ILE C 512      10.527  60.172  29.483  1.00 60.32           C  
ATOM   2060  CG2 ILE C 512      12.884  59.248  29.588  1.00 59.29           C  
ATOM   2061  CD1 ILE C 512      11.008  61.011  28.320  1.00 61.56           C  
ATOM   2062  N   LEU C 513      12.369  56.544  31.032  1.00 57.33           N  
ATOM   2063  CA  LEU C 513      13.325  55.489  31.337  1.00 56.73           C  
ATOM   2064  C   LEU C 513      14.734  55.773  30.809  1.00 55.65           C  
ATOM   2065  O   LEU C 513      14.897  56.375  29.754  1.00 55.57           O  
ATOM   2066  CB  LEU C 513      12.837  54.154  30.743  1.00 57.12           C  
ATOM   2067  CG  LEU C 513      11.568  53.522  31.334  1.00 58.05           C  
ATOM   2068  CD1 LEU C 513      11.245  52.258  30.582  1.00 58.83           C  
ATOM   2069  CD2 LEU C 513      11.726  53.226  32.823  1.00 58.32           C  
ATOM   2070  N   PRO C 514      15.749  55.290  31.518  1.00 54.52           N  
ATOM   2071  CA  PRO C 514      17.130  55.426  31.065  1.00 53.88           C  
ATOM   2072  C   PRO C 514      17.426  54.437  29.947  1.00 52.97           C  
ATOM   2073  O   PRO C 514      16.678  53.493  29.747  1.00 53.23           O  
ATOM   2074  CB  PRO C 514      17.930  55.068  32.310  1.00 53.93           C  
ATOM   2075  CG  PRO C 514      17.074  54.045  32.975  1.00 54.22           C  
ATOM   2076  CD  PRO C 514      15.674  54.552  32.791  1.00 54.56           C  
ATOM   2077  N   VAL C 515      18.522  54.657  29.231  1.00 51.87           N  
ATOM   2078  CA  VAL C 515      18.870  53.852  28.073  1.00 50.42           C  
ATOM   2079  C   VAL C 515      20.310  53.353  28.211  1.00 49.30           C  
ATOM   2080  O   VAL C 515      21.258  54.141  28.308  1.00 48.68           O  
ATOM   2081  CB  VAL C 515      18.668  54.668  26.781  1.00 50.44           C  
ATOM   2082  CG1 VAL C 515      19.296  53.976  25.583  1.00 50.74           C  
ATOM   2083  CG2 VAL C 515      17.152  54.933  26.527  1.00 50.43           C  
ATOM   2084  N   THR C 516      20.465  52.035  28.229  1.00 47.96           N  
ATOM   2085  CA  THR C 516      21.784  51.442  28.180  1.00 47.27           C  
ATOM   2086  C   THR C 516      22.409  51.731  26.808  1.00 46.59           C  
ATOM   2087  O   THR C 516      21.783  51.491  25.773  1.00 46.04           O  
ATOM   2088  CB  THR C 516      21.705  49.944  28.472  1.00 47.22           C  
ATOM   2089  OG1 THR C 516      21.469  49.752  29.864  1.00 47.05           O  
ATOM   2090  CG2 THR C 516      23.049  49.257  28.267  1.00 47.70           C  
ATOM   2091  N   VAL C 517      23.615  52.309  26.818  1.00 45.27           N  
ATOM   2092  CA  VAL C 517      24.345  52.604  25.591  1.00 44.14           C  
ATOM   2093  C   VAL C 517      25.493  51.619  25.381  1.00 43.63           C  
ATOM   2094  O   VAL C 517      25.860  51.320  24.246  1.00 43.50           O  
ATOM   2095  CB  VAL C 517      24.869  54.071  25.554  1.00 44.31           C  
ATOM   2096  CG1 VAL C 517      23.760  55.040  25.869  1.00 43.74           C  
ATOM   2097  CG2 VAL C 517      26.085  54.286  26.480  1.00 43.30           C  
ATOM   2098  N   TYR C 518      26.043  51.109  26.474  1.00 43.00           N  
ATOM   2099  CA  TYR C 518      27.121  50.131  26.408  1.00 42.94           C  
ATOM   2100  C   TYR C 518      26.991  49.174  27.577  1.00 44.19           C  
ATOM   2101  O   TYR C 518      26.481  49.560  28.638  1.00 44.52           O  
ATOM   2102  CB  TYR C 518      28.479  50.841  26.454  1.00 42.32           C  
ATOM   2103  CG  TYR C 518      29.662  49.936  26.389  1.00 38.92           C  
ATOM   2104  CD1 TYR C 518      30.272  49.639  25.178  1.00 38.95           C  
ATOM   2105  CD2 TYR C 518      30.169  49.367  27.524  1.00 37.70           C  
ATOM   2106  CE1 TYR C 518      31.366  48.800  25.111  1.00 37.26           C  
ATOM   2107  CE2 TYR C 518      31.255  48.523  27.485  1.00 38.16           C  
ATOM   2108  CZ  TYR C 518      31.861  48.244  26.273  1.00 38.46           C  
ATOM   2109  OH  TYR C 518      32.952  47.394  26.236  1.00 36.44           O  
ATOM   2110  N   ASP C 519      27.455  47.931  27.386  1.00 45.29           N  
ATOM   2111  CA  ASP C 519      27.332  46.878  28.397  1.00 46.22           C  
ATOM   2112  C   ASP C 519      28.135  45.638  28.012  1.00 47.10           C  
ATOM   2113  O   ASP C 519      27.582  44.706  27.411  1.00 47.56           O  
ATOM   2114  CB  ASP C 519      25.850  46.500  28.566  1.00 46.52           C  
ATOM   2115  CG  ASP C 519      25.609  45.579  29.744  1.00 47.19           C  
ATOM   2116  OD1 ASP C 519      24.463  45.127  29.904  1.00 50.35           O  
ATOM   2117  OD2 ASP C 519      26.475  45.247  30.566  1.00 47.33           O  
ATOM   2118  N   GLN C 520      29.427  45.628  28.364  1.00 47.57           N  
ATOM   2119  CA  GLN C 520      30.331  44.505  28.083  1.00 47.99           C  
ATOM   2120  C   GLN C 520      31.476  44.487  29.093  1.00 48.00           C  
ATOM   2121  O   GLN C 520      31.872  45.528  29.620  1.00 47.78           O  
ATOM   2122  CB  GLN C 520      30.927  44.591  26.662  1.00 48.48           C  
ATOM   2123  CG  GLN C 520      30.009  44.145  25.499  1.00 50.19           C  
ATOM   2124  CD  GLN C 520      30.126  45.043  24.253  1.00 52.37           C  
ATOM   2125  OE1 GLN C 520      30.967  44.808  23.374  1.00 53.36           O  
ATOM   2126  NE2 GLN C 520      29.272  46.061  24.178  1.00 52.98           N  
ATOM   2127  N   HIS C 521      32.027  43.300  29.345  1.00 48.02           N  
ATOM   2128  CA  HIS C 521      33.055  43.102  30.372  1.00 48.00           C  
ATOM   2129  C   HIS C 521      32.560  43.516  31.766  1.00 48.30           C  
ATOM   2130  O   HIS C 521      33.357  43.788  32.666  1.00 48.65           O  
ATOM   2131  CB  HIS C 521      34.344  43.840  29.989  1.00 47.85           C  
ATOM   2132  CG  HIS C 521      34.784  43.584  28.579  1.00 48.82           C  
ATOM   2133  ND1 HIS C 521      34.238  44.241  27.494  1.00 48.95           N  
ATOM   2134  CD2 HIS C 521      35.701  42.721  28.077  1.00 48.42           C  
ATOM   2135  CE1 HIS C 521      34.802  43.788  26.388  1.00 49.43           C  
ATOM   2136  NE2 HIS C 521      35.697  42.873  26.717  1.00 47.61           N  
ATOM   2137  N   GLY C 522      31.245  43.524  31.953  1.00 48.68           N  
ATOM   2138  CA  GLY C 522      30.651  44.060  33.168  1.00 49.61           C  
ATOM   2139  C   GLY C 522      30.512  45.594  33.258  1.00 50.19           C  
ATOM   2140  O   GLY C 522      29.904  46.122  34.202  1.00 50.30           O  
ATOM   2141  N   PHE C 523      31.066  46.314  32.284  1.00 50.09           N  
ATOM   2142  CA  PHE C 523      31.070  47.769  32.303  1.00 49.89           C  
ATOM   2143  C   PHE C 523      29.793  48.236  31.646  1.00 49.57           C  
ATOM   2144  O   PHE C 523      29.645  48.078  30.436  1.00 49.54           O  
ATOM   2145  CB  PHE C 523      32.293  48.286  31.535  1.00 49.82           C  
ATOM   2146  CG  PHE C 523      32.645  49.717  31.796  1.00 49.94           C  
ATOM   2147  CD1 PHE C 523      33.500  50.378  30.918  1.00 49.56           C  
ATOM   2148  CD2 PHE C 523      32.153  50.411  32.900  1.00 49.04           C  
ATOM   2149  CE1 PHE C 523      33.850  51.694  31.127  1.00 48.60           C  
ATOM   2150  CE2 PHE C 523      32.511  51.722  33.113  1.00 48.97           C  
ATOM   2151  CZ  PHE C 523      33.371  52.362  32.232  1.00 49.09           C  
ATOM   2152  N   ARG C 524      28.880  48.797  32.448  1.00 49.15           N  
ATOM   2153  CA  ARG C 524      27.600  49.345  31.970  1.00 49.00           C  
ATOM   2154  C   ARG C 524      27.595  50.868  31.972  1.00 47.17           C  
ATOM   2155  O   ARG C 524      28.105  51.490  32.890  1.00 46.86           O  
ATOM   2156  CB  ARG C 524      26.446  48.902  32.871  1.00 49.84           C  
ATOM   2157  CG  ARG C 524      25.890  47.540  32.562  1.00 53.88           C  
ATOM   2158  CD  ARG C 524      25.370  46.777  33.781  1.00 58.69           C  
ATOM   2159  NE  ARG C 524      25.193  45.341  33.498  1.00 62.01           N  
ATOM   2160  CZ  ARG C 524      26.179  44.444  33.450  1.00 64.05           C  
ATOM   2161  NH1 ARG C 524      27.428  44.810  33.688  1.00 65.57           N  
ATOM   2162  NH2 ARG C 524      25.917  43.171  33.161  1.00 65.37           N  
ATOM   2163  N   ILE C 525      26.942  51.449  30.973  1.00 45.65           N  
ATOM   2164  CA  ILE C 525      26.849  52.893  30.809  1.00 44.31           C  
ATOM   2165  C   ILE C 525      25.437  53.233  30.338  1.00 43.66           C  
ATOM   2166  O   ILE C 525      24.982  52.698  29.343  1.00 43.87           O  
ATOM   2167  CB  ILE C 525      27.915  53.380  29.798  1.00 44.13           C  
ATOM   2168  CG1 ILE C 525      29.307  53.317  30.447  1.00 43.36           C  
ATOM   2169  CG2 ILE C 525      27.605  54.802  29.311  1.00 43.52           C  
ATOM   2170  CD1 ILE C 525      30.439  53.654  29.525  1.00 43.55           C  
ATOM   2171  N   LEU C 526      24.746  54.102  31.071  1.00 42.68           N  
ATOM   2172  CA  LEU C 526      23.373  54.486  30.762  1.00 42.39           C  
ATOM   2173  C   LEU C 526      23.266  56.007  30.542  1.00 42.29           C  
ATOM   2174  O   LEU C 526      24.070  56.783  31.055  1.00 41.27           O  
ATOM   2175  CB  LEU C 526      22.442  54.087  31.917  1.00 41.85           C  
ATOM   2176  CG  LEU C 526      21.952  52.632  32.013  1.00 42.33           C  
ATOM   2177  CD1 LEU C 526      23.083  51.637  32.252  1.00 41.21           C  
ATOM   2178  CD2 LEU C 526      20.894  52.475  33.116  1.00 42.23           C  
ATOM   2179  N   PHE C 527      22.248  56.398  29.788  1.00 41.82           N  
ATOM   2180  CA  PHE C 527      21.882  57.775  29.598  1.00 42.15           C  
ATOM   2181  C   PHE C 527      20.603  57.987  30.395  1.00 42.33           C  
ATOM   2182  O   PHE C 527      19.617  57.291  30.189  1.00 42.39           O  
ATOM   2183  CB  PHE C 527      21.621  58.062  28.109  1.00 41.98           C  
ATOM   2184  CG  PHE C 527      22.868  58.320  27.276  1.00 42.76           C  
ATOM   2185  CD1 PHE C 527      24.154  58.085  27.761  1.00 43.14           C  
ATOM   2186  CD2 PHE C 527      22.736  58.816  25.978  1.00 43.76           C  
ATOM   2187  CE1 PHE C 527      25.278  58.336  26.957  1.00 44.20           C  
ATOM   2188  CE2 PHE C 527      23.838  59.065  25.179  1.00 43.03           C  
ATOM   2189  CZ  PHE C 527      25.118  58.827  25.666  1.00 44.00           C  
ATOM   2190  N   HIS C 528      20.640  58.930  31.324  1.00 42.88           N  
ATOM   2191  CA  HIS C 528      19.475  59.362  32.081  1.00 43.02           C  
ATOM   2192  C   HIS C 528      19.121  60.751  31.576  1.00 43.60           C  
ATOM   2193  O   HIS C 528      19.995  61.657  31.523  1.00 43.71           O  
ATOM   2194  CB  HIS C 528      19.809  59.445  33.567  1.00 43.24           C  
ATOM   2195  CG  HIS C 528      20.363  58.178  34.147  1.00 43.47           C  
ATOM   2196  ND1 HIS C 528      19.569  57.222  34.742  1.00 42.99           N  
ATOM   2197  CD2 HIS C 528      21.636  57.731  34.259  1.00 44.25           C  
ATOM   2198  CE1 HIS C 528      20.324  56.235  35.180  1.00 44.02           C  
ATOM   2199  NE2 HIS C 528      21.585  56.522  34.902  1.00 44.60           N  
ATOM   2200  N   PHE C 529      17.856  60.937  31.221  1.00 43.62           N  
ATOM   2201  CA  PHE C 529      17.410  62.154  30.565  1.00 44.20           C  
ATOM   2202  C   PHE C 529      16.810  63.161  31.525  1.00 44.06           C  
ATOM   2203  O   PHE C 529      16.241  62.800  32.543  1.00 43.87           O  
ATOM   2204  CB  PHE C 529      16.415  61.818  29.456  1.00 44.62           C  
ATOM   2205  CG  PHE C 529      16.933  60.808  28.477  1.00 45.56           C  
ATOM   2206  CD1 PHE C 529      16.401  59.527  28.434  1.00 46.99           C  
ATOM   2207  CD2 PHE C 529      17.974  61.129  27.626  1.00 46.98           C  
ATOM   2208  CE1 PHE C 529      16.883  58.588  27.533  1.00 46.57           C  
ATOM   2209  CE2 PHE C 529      18.469  60.197  26.728  1.00 47.31           C  
ATOM   2210  CZ  PHE C 529      17.917  58.921  26.679  1.00 47.42           C  
ATOM   2211  N   ALA C 530      16.957  64.433  31.164  1.00 44.45           N  
ATOM   2212  CA  ALA C 530      16.504  65.574  31.971  1.00 44.46           C  
ATOM   2213  C   ALA C 530      16.172  66.712  31.016  1.00 44.89           C  
ATOM   2214  O   ALA C 530      16.635  66.717  29.876  1.00 44.52           O  
ATOM   2215  CB  ALA C 530      17.576  65.995  32.934  1.00 44.21           C  
ATOM   2216  N   ARG C 531      15.394  67.682  31.475  1.00 45.31           N  
ATOM   2217  CA  ARG C 531      14.874  68.686  30.564  1.00 46.09           C  
ATOM   2218  C   ARG C 531      15.759  69.901  30.378  1.00 46.16           C  
ATOM   2219  O   ARG C 531      16.679  70.171  31.149  1.00 45.87           O  
ATOM   2220  CB  ARG C 531      13.469  69.128  30.965  1.00 46.68           C  
ATOM   2221  CG  ARG C 531      13.388  69.968  32.215  1.00 48.60           C  
ATOM   2222  CD  ARG C 531      12.230  69.585  33.107  1.00 51.85           C  
ATOM   2223  NE  ARG C 531      11.166  70.578  33.124  1.00 53.72           N  
ATOM   2224  CZ  ARG C 531       9.864  70.293  33.228  1.00 55.13           C  
ATOM   2225  NH1 ARG C 531       8.998  71.293  33.247  1.00 55.56           N  
ATOM   2226  NH2 ARG C 531       9.412  69.033  33.289  1.00 54.87           N  
ATOM   2227  N   ASP C 532      15.452  70.626  29.314  1.00 46.59           N  
ATOM   2228  CA  ASP C 532      16.126  71.851  28.983  1.00 46.69           C  
ATOM   2229  C   ASP C 532      16.172  72.740  30.230  1.00 47.35           C  
ATOM   2230  O   ASP C 532      15.125  73.052  30.786  1.00 47.21           O  
ATOM   2231  CB  ASP C 532      15.376  72.534  27.843  1.00 46.25           C  
ATOM   2232  CG  ASP C 532      16.132  73.688  27.276  1.00 45.51           C  
ATOM   2233  OD1 ASP C 532      16.031  73.914  26.059  1.00 45.28           O  
ATOM   2234  OD2 ASP C 532      16.867  74.422  27.966  1.00 45.25           O  
ATOM   2235  N   PRO C 533      17.374  73.099  30.694  1.00 48.58           N  
ATOM   2236  CA  PRO C 533      17.535  73.972  31.873  1.00 49.81           C  
ATOM   2237  C   PRO C 533      16.817  75.333  31.789  1.00 51.33           C  
ATOM   2238  O   PRO C 533      16.458  75.889  32.834  1.00 51.06           O  
ATOM   2239  CB  PRO C 533      19.055  74.187  31.959  1.00 49.65           C  
ATOM   2240  CG  PRO C 533      19.641  73.615  30.717  1.00 48.37           C  
ATOM   2241  CD  PRO C 533      18.674  72.663  30.160  1.00 48.34           C  
ATOM   2242  N   LEU C 534      16.635  75.867  30.578  1.00 53.33           N  
ATOM   2243  CA  LEU C 534      15.817  77.076  30.391  1.00 55.05           C  
ATOM   2244  C   LEU C 534      14.329  76.701  30.423  1.00 55.97           C  
ATOM   2245  O   LEU C 534      13.852  75.944  29.567  1.00 55.90           O  
ATOM   2246  CB  LEU C 534      16.169  77.831  29.088  1.00 55.18           C  
ATOM   2247  CG  LEU C 534      16.803  79.230  29.232  1.00 56.46           C  
ATOM   2248  CD1 LEU C 534      16.797  79.997  27.885  1.00 57.36           C  
ATOM   2249  CD2 LEU C 534      16.132  80.073  30.332  1.00 56.91           C  
ATOM   2250  N   PRO C 535      13.595  77.183  31.425  1.00 57.42           N  
ATOM   2251  CA  PRO C 535      12.157  76.905  31.470  1.00 58.03           C  
ATOM   2252  C   PRO C 535      11.468  77.599  30.295  1.00 58.04           C  
ATOM   2253  O   PRO C 535      11.811  78.739  29.974  1.00 57.20           O  
ATOM   2254  CB  PRO C 535      11.716  77.485  32.829  1.00 58.33           C  
ATOM   2255  CG  PRO C 535      12.753  78.508  33.182  1.00 57.89           C  
ATOM   2256  CD  PRO C 535      14.031  78.003  32.573  1.00 57.79           C  
ATOM   2257  N   GLY C 536      10.549  76.882  29.649  1.00 58.51           N  
ATOM   2258  CA  GLY C 536       9.827  77.384  28.489  1.00 58.83           C  
ATOM   2259  C   GLY C 536      10.396  76.899  27.166  1.00 58.81           C  
ATOM   2260  O   GLY C 536       9.654  76.726  26.192  1.00 59.51           O  
ATOM   2261  N   ARG C 537      11.711  76.688  27.126  1.00 58.49           N  
ATOM   2262  CA  ARG C 537      12.405  76.226  25.918  1.00 58.01           C  
ATOM   2263  C   ARG C 537      12.479  74.691  25.838  1.00 57.24           C  
ATOM   2264  O   ARG C 537      12.413  73.994  26.846  1.00 57.07           O  
ATOM   2265  CB  ARG C 537      13.815  76.829  25.883  1.00 58.09           C  
ATOM   2266  CG  ARG C 537      14.488  76.821  24.519  1.00 58.31           C  
ATOM   2267  CD  ARG C 537      15.908  77.368  24.544  1.00 59.04           C  
ATOM   2268  NE  ARG C 537      16.823  76.442  25.216  1.00 59.68           N  
ATOM   2269  CZ  ARG C 537      17.983  76.787  25.782  1.00 60.39           C  
ATOM   2270  NH1 ARG C 537      18.724  75.856  26.364  1.00 61.24           N  
ATOM   2271  NH2 ARG C 537      18.430  78.038  25.759  1.00 59.70           N  
ATOM   2272  N   SER C 538      12.613  74.178  24.625  1.00 56.72           N  
ATOM   2273  CA  SER C 538      12.780  72.743  24.402  1.00 56.63           C  
ATOM   2274  C   SER C 538      13.887  72.429  23.354  1.00 55.92           C  
ATOM   2275  O   SER C 538      13.788  71.465  22.584  1.00 56.06           O  
ATOM   2276  CB  SER C 538      11.438  72.144  23.990  1.00 56.44           C  
ATOM   2277  OG  SER C 538      11.539  70.746  23.825  1.00 58.26           O  
ATOM   2278  N   ASP C 539      14.950  73.233  23.358  1.00 55.00           N  
ATOM   2279  CA  ASP C 539      16.026  73.112  22.378  1.00 54.46           C  
ATOM   2280  C   ASP C 539      17.190  72.232  22.825  1.00 53.38           C  
ATOM   2281  O   ASP C 539      17.879  71.685  21.962  1.00 53.08           O  
ATOM   2282  CB  ASP C 539      16.537  74.496  21.959  1.00 54.63           C  
ATOM   2283  CG  ASP C 539      15.540  75.238  21.088  1.00 55.92           C  
ATOM   2284  OD1 ASP C 539      15.535  76.490  21.106  1.00 58.54           O  
ATOM   2285  OD2 ASP C 539      14.716  74.642  20.355  1.00 57.34           O  
ATOM   2286  N   VAL C 540      17.404  72.077  24.140  1.00 51.58           N  
ATOM   2287  CA  VAL C 540      18.452  71.176  24.642  1.00 50.54           C  
ATOM   2288  C   VAL C 540      17.951  70.026  25.533  1.00 48.51           C  
ATOM   2289  O   VAL C 540      17.124  70.214  26.423  1.00 47.94           O  
ATOM   2290  CB  VAL C 540      19.624  71.930  25.364  1.00 50.77           C  
ATOM   2291  CG1 VAL C 540      19.970  73.258  24.663  1.00 51.10           C  
ATOM   2292  CG2 VAL C 540      19.325  72.152  26.811  1.00 52.53           C  
ATOM   2293  N   LEU C 541      18.465  68.837  25.252  1.00 46.61           N  
ATOM   2294  CA  LEU C 541      18.333  67.675  26.118  1.00 45.40           C  
ATOM   2295  C   LEU C 541      19.522  67.614  27.078  1.00 44.05           C  
ATOM   2296  O   LEU C 541      20.661  67.737  26.663  1.00 43.24           O  
ATOM   2297  CB  LEU C 541      18.319  66.395  25.276  1.00 45.63           C  
ATOM   2298  CG  LEU C 541      18.113  65.062  26.012  1.00 45.93           C  
ATOM   2299  CD1 LEU C 541      16.695  64.952  26.529  1.00 47.11           C  
ATOM   2300  CD2 LEU C 541      18.413  63.901  25.099  1.00 46.72           C  
ATOM   2301  N   VAL C 542      19.236  67.432  28.360  1.00 42.83           N  
ATOM   2302  CA  VAL C 542      20.249  67.167  29.369  1.00 41.92           C  
ATOM   2303  C   VAL C 542      20.373  65.649  29.564  1.00 40.80           C  
ATOM   2304  O   VAL C 542      19.389  64.944  29.714  1.00 40.44           O  
ATOM   2305  CB  VAL C 542      19.896  67.848  30.711  1.00 41.87           C  
ATOM   2306  CG1 VAL C 542      20.751  67.323  31.838  1.00 41.84           C  
ATOM   2307  CG2 VAL C 542      20.064  69.346  30.609  1.00 42.49           C  
ATOM   2308  N   VAL C 543      21.602  65.163  29.550  1.00 39.93           N  
ATOM   2309  CA  VAL C 543      21.876  63.746  29.722  1.00 39.54           C  
ATOM   2310  C   VAL C 543      22.884  63.585  30.834  1.00 38.63           C  
ATOM   2311  O   VAL C 543      23.937  64.185  30.803  1.00 38.89           O  
ATOM   2312  CB  VAL C 543      22.445  63.087  28.443  1.00 39.47           C  
ATOM   2313  CG1 VAL C 543      22.852  61.657  28.716  1.00 39.06           C  
ATOM   2314  CG2 VAL C 543      21.436  63.141  27.317  1.00 39.29           C  
ATOM   2315  N   VAL C 544      22.521  62.811  31.844  1.00 37.90           N  
ATOM   2316  CA  VAL C 544      23.471  62.303  32.801  1.00 36.68           C  
ATOM   2317  C   VAL C 544      23.867  60.918  32.309  1.00 36.51           C  
ATOM   2318  O   VAL C 544      23.015  60.004  32.195  1.00 36.54           O  
ATOM   2319  CB  VAL C 544      22.867  62.224  34.216  1.00 36.57           C  
ATOM   2320  CG1 VAL C 544      23.843  61.609  35.166  1.00 35.47           C  
ATOM   2321  CG2 VAL C 544      22.448  63.614  34.693  1.00 36.36           C  
ATOM   2322  N   VAL C 545      25.149  60.784  31.987  1.00 35.62           N  
ATOM   2323  CA  VAL C 545      25.765  59.504  31.698  1.00 35.45           C  
ATOM   2324  C   VAL C 545      26.288  58.930  33.022  1.00 35.98           C  
ATOM   2325  O   VAL C 545      27.084  59.583  33.705  1.00 35.37           O  
ATOM   2326  CB  VAL C 545      26.969  59.652  30.751  1.00 35.01           C  
ATOM   2327  CG1 VAL C 545      27.456  58.315  30.306  1.00 36.05           C  
ATOM   2328  CG2 VAL C 545      26.622  60.486  29.571  1.00 34.36           C  
ATOM   2329  N   SER C 546      25.830  57.729  33.374  1.00 36.31           N  
ATOM   2330  CA  SER C 546      26.333  56.982  34.538  1.00 36.97           C  
ATOM   2331  C   SER C 546      27.066  55.738  34.089  1.00 37.25           C  
ATOM   2332  O   SER C 546      26.670  55.116  33.126  1.00 37.59           O  
ATOM   2333  CB  SER C 546      25.190  56.544  35.450  1.00 36.72           C  
ATOM   2334  OG  SER C 546      24.302  55.708  34.735  1.00 37.16           O  
ATOM   2335  N   MET C 547      28.115  55.366  34.810  1.00 37.83           N  
ATOM   2336  CA  MET C 547      28.950  54.249  34.456  1.00 38.67           C  
ATOM   2337  C   MET C 547      29.300  53.486  35.729  1.00 40.17           C  
ATOM   2338  O   MET C 547      29.886  54.045  36.663  1.00 39.24           O  
ATOM   2339  CB  MET C 547      30.258  54.712  33.784  1.00 38.47           C  
ATOM   2340  CG  MET C 547      30.180  56.027  33.045  1.00 37.41           C  
ATOM   2341  SD  MET C 547      31.713  56.424  32.213  1.00 34.73           S  
ATOM   2342  CE  MET C 547      31.377  58.182  31.765  1.00 34.75           C  
ATOM   2343  N   LEU C 548      28.954  52.201  35.730  1.00 42.35           N  
ATOM   2344  CA  LEU C 548      29.219  51.308  36.844  1.00 44.27           C  
ATOM   2345  C   LEU C 548      29.819  49.982  36.351  1.00 44.94           C  
ATOM   2346  O   LEU C 548      29.442  49.496  35.296  1.00 44.91           O  
ATOM   2347  CB  LEU C 548      27.915  51.075  37.623  1.00 44.90           C  
ATOM   2348  CG  LEU C 548      28.108  51.020  39.154  1.00 47.74           C  
ATOM   2349  CD1 LEU C 548      26.773  51.137  39.895  1.00 48.86           C  
ATOM   2350  CD2 LEU C 548      28.863  49.740  39.584  1.00 49.30           C  
ATOM   2351  N   SER C 549      30.740  49.418  37.135  1.00 46.00           N  
ATOM   2352  CA  SER C 549      31.495  48.203  36.792  1.00 47.05           C  
ATOM   2353  C   SER C 549      31.145  47.001  37.708  1.00 48.38           C  
ATOM   2354  O   SER C 549      31.576  46.951  38.860  1.00 47.46           O  
ATOM   2355  CB  SER C 549      32.989  48.529  36.906  1.00 46.83           C  
ATOM   2356  OG  SER C 549      33.840  47.387  36.909  1.00 46.83           O  
ATOM   2357  N   THR C 550      30.364  46.045  37.186  1.00 50.04           N  
ATOM   2358  CA  THR C 550      30.078  44.780  37.898  1.00 51.32           C  
ATOM   2359  C   THR C 550      31.166  43.742  37.682  1.00 52.03           C  
ATOM   2360  O   THR C 550      30.845  42.565  37.573  1.00 51.76           O  
ATOM   2361  CB  THR C 550      28.708  44.129  37.453  1.00 51.40           C  
ATOM   2362  OG1 THR C 550      28.259  44.635  36.183  1.00 52.73           O  
ATOM   2363  CG2 THR C 550      27.583  44.506  38.391  1.00 51.72           C  
ATOM   2364  N   ALA C 551      32.444  44.149  37.635  1.00 53.30           N  
ATOM   2365  CA  ALA C 551      33.500  43.272  37.079  1.00 53.59           C  
ATOM   2366  C   ALA C 551      34.719  43.064  37.976  1.00 54.03           C  
ATOM   2367  O   ALA C 551      35.153  43.993  38.654  1.00 54.53           O  
ATOM   2368  CB  ALA C 551      33.949  43.779  35.735  1.00 53.23           C  
ATOM   2369  N   PRO C 552      35.303  41.855  37.927  1.00 54.18           N  
ATOM   2370  CA  PRO C 552      36.411  41.462  38.822  1.00 53.57           C  
ATOM   2371  C   PRO C 552      37.714  42.253  38.762  1.00 53.02           C  
ATOM   2372  O   PRO C 552      38.593  41.972  39.585  1.00 53.32           O  
ATOM   2373  CB  PRO C 552      36.693  40.004  38.421  1.00 53.84           C  
ATOM   2374  CG  PRO C 552      35.430  39.514  37.745  1.00 54.64           C  
ATOM   2375  CD  PRO C 552      34.897  40.744  37.031  1.00 54.61           C  
ATOM   2376  N   GLN C 553      37.864  43.202  37.842  1.00 52.49           N  
ATOM   2377  CA  GLN C 553      39.119  43.990  37.751  1.00 51.91           C  
ATOM   2378  C   GLN C 553      38.822  45.490  37.791  1.00 49.92           C  
ATOM   2379  O   GLN C 553      37.747  45.904  37.382  1.00 49.73           O  
ATOM   2380  CB  GLN C 553      39.876  43.622  36.461  1.00 52.56           C  
ATOM   2381  CG  GLN C 553      41.426  43.697  36.536  1.00 54.68           C  
ATOM   2382  CD  GLN C 553      42.139  42.802  35.506  1.00 55.95           C  
ATOM   2383  OE1 GLN C 553      43.338  42.530  35.639  1.00 58.07           O  
ATOM   2384  NE2 GLN C 553      41.412  42.349  34.497  1.00 55.60           N  
ATOM   2385  N   PRO C 554      39.736  46.296  38.312  1.00 47.77           N  
ATOM   2386  CA  PRO C 554      39.566  47.749  38.254  1.00 46.96           C  
ATOM   2387  C   PRO C 554      39.763  48.290  36.831  1.00 45.55           C  
ATOM   2388  O   PRO C 554      40.645  47.823  36.094  1.00 45.57           O  
ATOM   2389  CB  PRO C 554      40.662  48.270  39.181  1.00 46.65           C  
ATOM   2390  CG  PRO C 554      41.698  47.230  39.131  1.00 47.42           C  
ATOM   2391  CD  PRO C 554      40.977  45.934  39.013  1.00 47.76           C  
ATOM   2392  N   ILE C 555      38.924  49.257  36.473  1.00 43.83           N  
ATOM   2393  CA  ILE C 555      38.972  49.952  35.202  1.00 42.27           C  
ATOM   2394  C   ILE C 555      39.616  51.314  35.411  1.00 41.99           C  
ATOM   2395  O   ILE C 555      39.298  52.008  36.344  1.00 42.00           O  
ATOM   2396  CB  ILE C 555      37.550  50.093  34.653  1.00 41.64           C  
ATOM   2397  CG1 ILE C 555      36.898  48.725  34.546  1.00 39.63           C  
ATOM   2398  CG2 ILE C 555      37.538  50.775  33.297  1.00 40.63           C  
ATOM   2399  CD1 ILE C 555      35.417  48.816  34.327  1.00 40.45           C  
ATOM   2400  N   ARG C 556      40.544  51.684  34.547  1.00 42.09           N  
ATOM   2401  CA  ARG C 556      41.137  53.008  34.600  1.00 42.62           C  
ATOM   2402  C   ARG C 556      41.121  53.666  33.229  1.00 41.22           C  
ATOM   2403  O   ARG C 556      40.648  53.074  32.271  1.00 41.15           O  
ATOM   2404  CB  ARG C 556      42.560  52.926  35.173  1.00 43.51           C  
ATOM   2405  CG  ARG C 556      43.550  52.139  34.337  1.00 47.54           C  
ATOM   2406  CD  ARG C 556      44.836  51.736  35.102  1.00 52.33           C  
ATOM   2407  NE  ARG C 556      45.341  50.440  34.631  1.00 54.49           N  
ATOM   2408  CZ  ARG C 556      46.288  50.265  33.708  1.00 56.48           C  
ATOM   2409  NH1 ARG C 556      46.900  51.301  33.126  1.00 55.82           N  
ATOM   2410  NH2 ARG C 556      46.628  49.022  33.374  1.00 57.43           N  
ATOM   2411  N   ASN C 557      41.618  54.900  33.156  1.00 40.47           N  
ATOM   2412  CA  ASN C 557      41.658  55.682  31.924  1.00 39.74           C  
ATOM   2413  C   ASN C 557      40.337  55.643  31.157  1.00 38.45           C  
ATOM   2414  O   ASN C 557      40.329  55.411  29.953  1.00 38.91           O  
ATOM   2415  CB  ASN C 557      42.781  55.177  30.998  1.00 40.27           C  
ATOM   2416  CG  ASN C 557      44.117  55.037  31.699  1.00 41.54           C  
ATOM   2417  OD1 ASN C 557      44.682  53.942  31.767  1.00 46.42           O  
ATOM   2418  ND2 ASN C 557      44.655  56.146  32.179  1.00 42.61           N  
ATOM   2419  N   ILE C 558      39.221  55.847  31.842  1.00 37.21           N  
ATOM   2420  CA  ILE C 558      37.923  55.857  31.176  1.00 36.52           C  
ATOM   2421  C   ILE C 558      37.671  57.226  30.536  1.00 35.70           C  
ATOM   2422  O   ILE C 558      37.716  58.243  31.209  1.00 35.76           O  
ATOM   2423  CB  ILE C 558      36.793  55.527  32.142  1.00 36.44           C  
ATOM   2424  CG1 ILE C 558      36.987  54.145  32.760  1.00 35.57           C  
ATOM   2425  CG2 ILE C 558      35.442  55.596  31.427  1.00 35.98           C  
ATOM   2426  CD1 ILE C 558      36.310  54.022  34.112  1.00 35.74           C  
ATOM   2427  N   VAL C 559      37.423  57.234  29.232  1.00 34.79           N  
ATOM   2428  CA  VAL C 559      37.069  58.451  28.512  1.00 34.41           C  
ATOM   2429  C   VAL C 559      35.879  58.121  27.680  1.00 33.77           C  
ATOM   2430  O   VAL C 559      35.915  57.166  26.942  1.00 33.71           O  
ATOM   2431  CB  VAL C 559      38.203  58.968  27.590  1.00 34.61           C  
ATOM   2432  CG1 VAL C 559      37.870  60.368  27.044  1.00 33.50           C  
ATOM   2433  CG2 VAL C 559      39.534  58.998  28.346  1.00 35.01           C  
ATOM   2434  N   PHE C 560      34.823  58.910  27.813  1.00 33.60           N  
ATOM   2435  CA  PHE C 560      33.610  58.723  27.048  1.00 33.96           C  
ATOM   2436  C   PHE C 560      33.468  59.918  26.126  1.00 35.20           C  
ATOM   2437  O   PHE C 560      33.451  61.036  26.597  1.00 35.78           O  
ATOM   2438  CB  PHE C 560      32.396  58.621  27.970  1.00 33.42           C  
ATOM   2439  CG  PHE C 560      31.141  58.364  27.235  1.00 32.11           C  
ATOM   2440  CD1 PHE C 560      30.826  57.088  26.816  1.00 32.21           C  
ATOM   2441  CD2 PHE C 560      30.303  59.401  26.894  1.00 30.88           C  
ATOM   2442  CE1 PHE C 560      29.655  56.846  26.077  1.00 33.49           C  
ATOM   2443  CE2 PHE C 560      29.141  59.176  26.144  1.00 32.54           C  
ATOM   2444  CZ  PHE C 560      28.805  57.908  25.745  1.00 31.35           C  
ATOM   2445  N   GLN C 561      33.382  59.695  24.819  1.00 36.69           N  
ATOM   2446  CA  GLN C 561      33.252  60.809  23.855  1.00 38.03           C  
ATOM   2447  C   GLN C 561      31.982  60.651  23.070  1.00 38.39           C  
ATOM   2448  O   GLN C 561      31.423  59.555  23.017  1.00 38.33           O  
ATOM   2449  CB  GLN C 561      34.450  60.857  22.888  1.00 38.44           C  
ATOM   2450  CG  GLN C 561      35.745  61.351  23.562  1.00 39.40           C  
ATOM   2451  CD  GLN C 561      36.982  61.151  22.699  1.00 41.22           C  
ATOM   2452  OE1 GLN C 561      37.637  60.116  22.777  1.00 44.48           O  
ATOM   2453  NE2 GLN C 561      37.306  62.139  21.894  1.00 39.65           N  
ATOM   2454  N   SER C 562      31.503  61.740  22.481  1.00 39.01           N  
ATOM   2455  CA  SER C 562      30.319  61.647  21.622  1.00 40.00           C  
ATOM   2456  C   SER C 562      30.385  62.589  20.429  1.00 41.01           C  
ATOM   2457  O   SER C 562      31.027  63.633  20.494  1.00 40.51           O  
ATOM   2458  CB  SER C 562      29.050  61.908  22.425  1.00 39.96           C  
ATOM   2459  OG  SER C 562      28.682  60.745  23.148  1.00 41.14           O  
ATOM   2460  N   ALA C 563      29.721  62.196  19.343  1.00 42.36           N  
ATOM   2461  CA  ALA C 563      29.559  63.051  18.173  1.00 43.68           C  
ATOM   2462  C   ALA C 563      28.106  63.026  17.768  1.00 45.23           C  
ATOM   2463  O   ALA C 563      27.378  62.091  18.114  1.00 45.38           O  
ATOM   2464  CB  ALA C 563      30.433  62.574  17.029  1.00 43.39           C  
ATOM   2465  N   VAL C 564      27.685  64.065  17.047  1.00 47.06           N  
ATOM   2466  CA  VAL C 564      26.321  64.166  16.528  1.00 48.53           C  
ATOM   2467  C   VAL C 564      26.332  64.842  15.135  1.00 49.98           C  
ATOM   2468  O   VAL C 564      27.263  65.614  14.836  1.00 49.87           O  
ATOM   2469  CB  VAL C 564      25.401  64.956  17.507  1.00 48.58           C  
ATOM   2470  CG1 VAL C 564      25.204  64.176  18.809  1.00 48.86           C  
ATOM   2471  CG2 VAL C 564      25.951  66.349  17.799  1.00 48.45           C  
ATOM   2472  N   PRO C 565      25.327  64.564  14.287  1.00 51.24           N  
ATOM   2473  CA  PRO C 565      25.229  65.211  12.967  1.00 52.31           C  
ATOM   2474  C   PRO C 565      25.428  66.717  13.050  1.00 53.42           C  
ATOM   2475  O   PRO C 565      25.156  67.322  14.094  1.00 53.90           O  
ATOM   2476  CB  PRO C 565      23.805  64.875  12.503  1.00 52.31           C  
ATOM   2477  CG  PRO C 565      23.123  64.259  13.696  1.00 52.07           C  
ATOM   2478  CD  PRO C 565      24.209  63.639  14.506  1.00 51.28           C  
ATOM   2479  N   LYS C 566      25.898  67.318  11.964  1.00 54.97           N  
ATOM   2480  CA  LYS C 566      26.370  68.723  11.989  1.00 55.99           C  
ATOM   2481  C   LYS C 566      25.223  69.719  12.228  1.00 56.00           C  
ATOM   2482  O   LYS C 566      25.446  70.869  12.642  1.00 55.68           O  
ATOM   2483  CB  LYS C 566      27.169  69.119  10.713  1.00 56.60           C  
ATOM   2484  CG  LYS C 566      27.512  67.993   9.681  1.00 59.23           C  
ATOM   2485  CD  LYS C 566      28.514  66.941  10.209  1.00 62.36           C  
ATOM   2486  CE  LYS C 566      28.501  65.647   9.366  1.00 63.77           C  
ATOM   2487  NZ  LYS C 566      27.346  64.735   9.678  1.00 63.89           N  
ATOM   2488  N   VAL C 567      24.000  69.276  11.953  1.00 55.97           N  
ATOM   2489  CA  VAL C 567      22.832  70.102  12.210  1.00 56.37           C  
ATOM   2490  C   VAL C 567      22.704  70.512  13.681  1.00 56.20           C  
ATOM   2491  O   VAL C 567      22.234  71.619  13.986  1.00 56.34           O  
ATOM   2492  CB  VAL C 567      21.517  69.407  11.735  1.00 56.50           C  
ATOM   2493  CG1 VAL C 567      21.256  68.109  12.494  1.00 56.90           C  
ATOM   2494  CG2 VAL C 567      20.337  70.375  11.846  1.00 56.54           C  
ATOM   2495  N   MET C 568      23.108  69.610  14.578  1.00 55.86           N  
ATOM   2496  CA  MET C 568      23.078  69.858  16.025  1.00 55.21           C  
ATOM   2497  C   MET C 568      24.477  69.864  16.623  1.00 54.21           C  
ATOM   2498  O   MET C 568      25.469  69.774  15.895  1.00 54.52           O  
ATOM   2499  CB  MET C 568      22.169  68.843  16.736  1.00 55.27           C  
ATOM   2500  CG  MET C 568      22.560  67.393  16.641  1.00 54.93           C  
ATOM   2501  SD  MET C 568      21.116  66.396  16.232  1.00 55.42           S  
ATOM   2502  CE  MET C 568      20.283  66.426  17.633  1.00 56.41           C  
ATOM   2503  N   LYS C 569      24.554  70.029  17.939  1.00 52.83           N  
ATOM   2504  CA  LYS C 569      25.826  69.929  18.645  1.00 51.84           C  
ATOM   2505  C   LYS C 569      25.677  69.155  19.949  1.00 49.54           C  
ATOM   2506  O   LYS C 569      24.592  69.053  20.490  1.00 49.51           O  
ATOM   2507  CB  LYS C 569      26.432  71.323  18.879  1.00 52.37           C  
ATOM   2508  CG  LYS C 569      25.706  72.186  19.902  1.00 54.82           C  
ATOM   2509  CD  LYS C 569      26.642  73.155  20.616  1.00 58.04           C  
ATOM   2510  CE  LYS C 569      26.839  74.449  19.816  1.00 60.74           C  
ATOM   2511  NZ  LYS C 569      25.616  75.321  19.781  1.00 61.66           N  
ATOM   2512  N   VAL C 570      26.779  68.594  20.428  1.00 47.17           N  
ATOM   2513  CA  VAL C 570      26.813  67.875  21.698  1.00 45.17           C  
ATOM   2514  C   VAL C 570      28.011  68.372  22.517  1.00 43.62           C  
ATOM   2515  O   VAL C 570      29.086  68.628  21.973  1.00 43.12           O  
ATOM   2516  CB  VAL C 570      26.851  66.330  21.481  1.00 45.28           C  
ATOM   2517  CG1 VAL C 570      28.100  65.893  20.712  1.00 45.21           C  
ATOM   2518  CG2 VAL C 570      26.727  65.566  22.806  1.00 43.96           C  
ATOM   2519  N   LYS C 571      27.809  68.537  23.817  1.00 41.62           N  
ATOM   2520  CA  LYS C 571      28.845  69.033  24.714  1.00 41.02           C  
ATOM   2521  C   LYS C 571      28.947  68.121  25.946  1.00 39.70           C  
ATOM   2522  O   LYS C 571      27.938  67.789  26.578  1.00 39.80           O  
ATOM   2523  CB  LYS C 571      28.507  70.466  25.118  1.00 41.17           C  
ATOM   2524  CG  LYS C 571      29.455  71.119  26.066  1.00 42.52           C  
ATOM   2525  CD  LYS C 571      30.655  71.727  25.372  1.00 45.03           C  
ATOM   2526  CE  LYS C 571      31.526  72.527  26.378  1.00 46.18           C  
ATOM   2527  NZ  LYS C 571      32.277  71.682  27.366  1.00 47.36           N  
ATOM   2528  N   LEU C 572      30.163  67.695  26.260  1.00 37.55           N  
ATOM   2529  CA  LEU C 572      30.411  66.796  27.383  1.00 35.80           C  
ATOM   2530  C   LEU C 572      31.268  67.542  28.398  1.00 34.30           C  
ATOM   2531  O   LEU C 572      32.328  68.121  28.034  1.00 33.07           O  
ATOM   2532  CB  LEU C 572      31.146  65.549  26.911  1.00 36.00           C  
ATOM   2533  CG  LEU C 572      30.322  64.312  26.541  1.00 37.67           C  
ATOM   2534  CD1 LEU C 572      31.250  63.293  25.906  1.00 39.11           C  
ATOM   2535  CD2 LEU C 572      29.647  63.694  27.747  1.00 38.35           C  
ATOM   2536  N   GLN C 573      30.795  67.554  29.649  1.00 32.59           N  
ATOM   2537  CA  GLN C 573      31.514  68.185  30.755  1.00 31.88           C  
ATOM   2538  C   GLN C 573      32.443  67.150  31.339  1.00 31.06           C  
ATOM   2539  O   GLN C 573      32.221  65.969  31.141  1.00 30.46           O  
ATOM   2540  CB  GLN C 573      30.560  68.675  31.829  1.00 31.84           C  
ATOM   2541  CG  GLN C 573      29.468  69.605  31.295  1.00 33.36           C  
ATOM   2542  CD  GLN C 573      30.075  70.812  30.601  1.00 32.94           C  
ATOM   2543  OE1 GLN C 573      29.738  71.114  29.462  1.00 31.63           O  
ATOM   2544  NE2 GLN C 573      30.998  71.478  31.288  1.00 33.55           N  
ATOM   2545  N   PRO C 574      33.508  67.585  32.004  1.00 30.85           N  
ATOM   2546  CA  PRO C 574      34.414  66.648  32.672  1.00 30.60           C  
ATOM   2547  C   PRO C 574      33.658  65.688  33.581  1.00 30.83           C  
ATOM   2548  O   PRO C 574      32.684  66.102  34.222  1.00 29.94           O  
ATOM   2549  CB  PRO C 574      35.323  67.559  33.485  1.00 30.38           C  
ATOM   2550  CG  PRO C 574      35.332  68.865  32.698  1.00 30.83           C  
ATOM   2551  CD  PRO C 574      33.949  68.990  32.165  1.00 30.66           C  
ATOM   2552  N   PRO C 575      34.089  64.426  33.620  1.00 31.58           N  
ATOM   2553  CA  PRO C 575      33.402  63.384  34.405  1.00 32.68           C  
ATOM   2554  C   PRO C 575      33.769  63.403  35.913  1.00 33.15           C  
ATOM   2555  O   PRO C 575      34.751  64.032  36.328  1.00 33.23           O  
ATOM   2556  CB  PRO C 575      33.870  62.086  33.739  1.00 31.99           C  
ATOM   2557  CG  PRO C 575      35.264  62.413  33.231  1.00 31.71           C  
ATOM   2558  CD  PRO C 575      35.286  63.891  32.937  1.00 31.63           C  
ATOM   2559  N   SER C 576      32.959  62.736  36.722  1.00 33.99           N  
ATOM   2560  CA  SER C 576      33.205  62.698  38.162  1.00 35.05           C  
ATOM   2561  C   SER C 576      34.538  62.022  38.451  1.00 36.17           C  
ATOM   2562  O   SER C 576      35.172  62.259  39.470  1.00 36.85           O  
ATOM   2563  CB  SER C 576      32.065  61.983  38.893  1.00 35.15           C  
ATOM   2564  OG  SER C 576      32.000  60.577  38.587  1.00 35.39           O  
ATOM   2565  N   GLY C 577      34.947  61.156  37.540  1.00 37.54           N  
ATOM   2566  CA  GLY C 577      36.160  60.400  37.699  1.00 37.96           C  
ATOM   2567  C   GLY C 577      36.551  59.683  36.433  1.00 38.96           C  
ATOM   2568  O   GLY C 577      35.834  59.659  35.432  1.00 38.48           O  
ATOM   2569  N   THR C 578      37.726  59.096  36.507  1.00 40.88           N  
ATOM   2570  CA  THR C 578      38.320  58.378  35.402  1.00 42.69           C  
ATOM   2571  C   THR C 578      38.572  56.891  35.743  1.00 43.74           C  
ATOM   2572  O   THR C 578      38.940  56.100  34.876  1.00 43.79           O  
ATOM   2573  CB  THR C 578      39.586  59.155  35.026  1.00 42.72           C  
ATOM   2574  OG1 THR C 578      39.240  60.124  34.016  1.00 43.98           O  
ATOM   2575  CG2 THR C 578      40.601  58.303  34.393  1.00 43.99           C  
ATOM   2576  N   GLU C 579      38.319  56.512  36.995  1.00 44.80           N  
ATOM   2577  CA  GLU C 579      38.610  55.165  37.489  1.00 45.81           C  
ATOM   2578  C   GLU C 579      37.426  54.561  38.222  1.00 45.55           C  
ATOM   2579  O   GLU C 579      36.579  55.268  38.764  1.00 45.24           O  
ATOM   2580  CB  GLU C 579      39.812  55.185  38.435  1.00 45.84           C  
ATOM   2581  CG  GLU C 579      41.054  55.751  37.784  1.00 48.62           C  
ATOM   2582  CD  GLU C 579      42.290  55.650  38.665  1.00 52.47           C  
ATOM   2583  OE1 GLU C 579      42.143  55.308  39.862  1.00 52.47           O  
ATOM   2584  OE2 GLU C 579      43.408  55.916  38.141  1.00 54.42           O  
ATOM   2585  N   LEU C 580      37.390  53.235  38.208  1.00 45.60           N  
ATOM   2586  CA  LEU C 580      36.416  52.450  38.937  1.00 45.43           C  
ATOM   2587  C   LEU C 580      37.156  51.259  39.546  1.00 46.46           C  
ATOM   2588  O   LEU C 580      37.980  50.633  38.876  1.00 46.14           O  
ATOM   2589  CB  LEU C 580      35.320  51.955  38.014  1.00 44.57           C  
ATOM   2590  CG  LEU C 580      34.262  52.972  37.607  1.00 43.34           C  
ATOM   2591  CD1 LEU C 580      33.267  52.363  36.633  1.00 41.37           C  
ATOM   2592  CD2 LEU C 580      33.532  53.488  38.794  1.00 43.89           C  
ATOM   2593  N   PRO C 581      36.882  50.942  40.812  1.00 47.65           N  
ATOM   2594  CA  PRO C 581      37.517  49.775  41.431  1.00 48.15           C  
ATOM   2595  C   PRO C 581      36.791  48.501  40.983  1.00 48.73           C  
ATOM   2596  O   PRO C 581      35.672  48.548  40.447  1.00 48.02           O  
ATOM   2597  CB  PRO C 581      37.340  50.024  42.940  1.00 48.12           C  
ATOM   2598  CG  PRO C 581      36.559  51.325  43.073  1.00 48.43           C  
ATOM   2599  CD  PRO C 581      35.934  51.599  41.734  1.00 47.69           C  
ATOM   2600  N   ALA C 582      37.457  47.375  41.188  1.00 50.10           N  
ATOM   2601  CA  ALA C 582      36.864  46.058  40.984  1.00 51.36           C  
ATOM   2602  C   ALA C 582      35.608  45.898  41.840  1.00 52.14           C  
ATOM   2603  O   ALA C 582      35.597  46.284  43.005  1.00 51.77           O  
ATOM   2604  CB  ALA C 582      37.890  44.982  41.358  1.00 51.51           C  
ATOM   2605  N   PHE C 583      34.554  45.348  41.259  1.00 53.68           N  
ATOM   2606  CA  PHE C 583      33.305  45.158  41.975  1.00 55.67           C  
ATOM   2607  C   PHE C 583      33.504  44.260  43.189  1.00 57.06           C  
ATOM   2608  O   PHE C 583      33.629  43.039  43.035  1.00 57.04           O  
ATOM   2609  CB  PHE C 583      32.267  44.525  41.067  1.00 56.01           C  
ATOM   2610  CG  PHE C 583      30.951  44.273  41.744  1.00 57.99           C  
ATOM   2611  CD1 PHE C 583      30.545  42.979  42.039  1.00 59.16           C  
ATOM   2612  CD2 PHE C 583      30.117  45.329  42.080  1.00 59.71           C  
ATOM   2613  CE1 PHE C 583      29.327  42.739  42.658  1.00 59.62           C  
ATOM   2614  CE2 PHE C 583      28.891  45.098  42.709  1.00 61.03           C  
ATOM   2615  CZ  PHE C 583      28.501  43.795  42.999  1.00 60.87           C  
ATOM   2616  N   ASN C 584      33.545  44.884  44.376  1.00 58.44           N  
ATOM   2617  CA  ASN C 584      33.723  44.203  45.666  1.00 59.33           C  
ATOM   2618  C   ASN C 584      32.363  44.029  46.350  1.00 60.28           C  
ATOM   2619  O   ASN C 584      31.771  45.028  46.744  1.00 60.01           O  
ATOM   2620  CB  ASN C 584      34.677  45.015  46.568  1.00 59.34           C  
ATOM   2621  CG  ASN C 584      34.866  44.394  47.967  1.00 59.35           C  
ATOM   2622  OD1 ASN C 584      34.023  43.629  48.440  1.00 60.12           O  
ATOM   2623  ND2 ASN C 584      35.969  44.738  48.629  1.00 57.72           N  
ATOM   2624  N   PRO C 585      31.870  42.781  46.464  1.00 61.79           N  
ATOM   2625  CA  PRO C 585      30.535  42.469  47.027  1.00 62.51           C  
ATOM   2626  C   PRO C 585      30.161  43.113  48.373  1.00 63.37           C  
ATOM   2627  O   PRO C 585      28.967  43.248  48.662  1.00 63.29           O  
ATOM   2628  CB  PRO C 585      30.579  40.943  47.210  1.00 62.50           C  
ATOM   2629  CG  PRO C 585      31.556  40.449  46.209  1.00 62.16           C  
ATOM   2630  CD  PRO C 585      32.551  41.555  46.004  1.00 61.94           C  
ATOM   2631  N   ILE C 586      31.157  43.457  49.191  1.00 64.00           N  
ATOM   2632  CA  ILE C 586      30.915  44.143  50.453  1.00 64.31           C  
ATOM   2633  C   ILE C 586      30.652  45.598  50.153  1.00 64.18           C  
ATOM   2634  O   ILE C 586      29.517  46.051  50.251  1.00 64.61           O  
ATOM   2635  CB  ILE C 586      32.140  43.999  51.414  1.00 64.78           C  
ATOM   2636  CG1 ILE C 586      32.276  42.547  51.923  1.00 65.20           C  
ATOM   2637  CG2 ILE C 586      32.054  45.017  52.572  1.00 65.20           C  
ATOM   2638  CD1 ILE C 586      31.176  42.081  52.880  1.00 65.74           C  
ATOM   2639  N   VAL C 587      31.710  46.305  49.749  1.00 63.83           N  
ATOM   2640  CA  VAL C 587      31.731  47.769  49.708  1.00 63.35           C  
ATOM   2641  C   VAL C 587      30.647  48.323  48.789  1.00 62.36           C  
ATOM   2642  O   VAL C 587      30.186  47.636  47.868  1.00 62.28           O  
ATOM   2643  CB  VAL C 587      33.124  48.312  49.271  1.00 63.80           C  
ATOM   2644  CG1 VAL C 587      33.178  49.846  49.345  1.00 64.26           C  
ATOM   2645  CG2 VAL C 587      34.244  47.700  50.133  1.00 64.10           C  
ATOM   2646  N   HIS C 588      30.207  49.548  49.089  1.00 61.29           N  
ATOM   2647  CA  HIS C 588      29.298  50.301  48.210  1.00 60.20           C  
ATOM   2648  C   HIS C 588      30.011  50.586  46.889  1.00 58.33           C  
ATOM   2649  O   HIS C 588      31.010  51.310  46.874  1.00 58.24           O  
ATOM   2650  CB  HIS C 588      28.881  51.638  48.855  1.00 60.58           C  
ATOM   2651  CG  HIS C 588      27.870  51.487  49.944  1.00 61.35           C  
ATOM   2652  ND1 HIS C 588      26.687  50.802  49.768  1.00 62.88           N  
ATOM   2653  CD2 HIS C 588      27.873  51.914  51.228  1.00 62.25           C  
ATOM   2654  CE1 HIS C 588      26.002  50.815  50.897  1.00 62.84           C  
ATOM   2655  NE2 HIS C 588      26.698  51.486  51.799  1.00 63.30           N  
ATOM   2656  N   PRO C 589      29.555  50.004  45.788  1.00 56.28           N  
ATOM   2657  CA  PRO C 589      30.192  50.302  44.497  1.00 55.24           C  
ATOM   2658  C   PRO C 589      30.271  51.800  44.152  1.00 53.42           C  
ATOM   2659  O   PRO C 589      29.267  52.500  44.247  1.00 53.44           O  
ATOM   2660  CB  PRO C 589      29.341  49.538  43.467  1.00 55.38           C  
ATOM   2661  CG  PRO C 589      28.231  48.857  44.222  1.00 55.98           C  
ATOM   2662  CD  PRO C 589      28.510  48.972  45.681  1.00 56.27           C  
ATOM   2663  N   SER C 590      31.465  52.264  43.785  1.00 51.15           N  
ATOM   2664  CA  SER C 590      31.635  53.566  43.155  1.00 49.69           C  
ATOM   2665  C   SER C 590      30.836  53.691  41.826  1.00 48.22           C  
ATOM   2666  O   SER C 590      30.319  52.696  41.265  1.00 47.72           O  
ATOM   2667  CB  SER C 590      33.115  53.816  42.849  1.00 49.95           C  
ATOM   2668  OG  SER C 590      33.907  53.794  44.013  1.00 49.76           O  
ATOM   2669  N   ALA C 591      30.746  54.924  41.332  1.00 45.88           N  
ATOM   2670  CA  ALA C 591      30.058  55.196  40.070  1.00 44.41           C  
ATOM   2671  C   ALA C 591      30.544  56.502  39.437  1.00 42.57           C  
ATOM   2672  O   ALA C 591      30.707  57.493  40.129  1.00 42.32           O  
ATOM   2673  CB  ALA C 591      28.562  55.230  40.280  1.00 44.25           C  
ATOM   2674  N   ILE C 592      30.797  56.479  38.132  1.00 40.42           N  
ATOM   2675  CA  ILE C 592      31.153  57.681  37.397  1.00 38.59           C  
ATOM   2676  C   ILE C 592      29.914  58.338  36.826  1.00 37.60           C  
ATOM   2677  O   ILE C 592      29.061  57.691  36.244  1.00 36.57           O  
ATOM   2678  CB  ILE C 592      32.111  57.374  36.252  1.00 38.56           C  
ATOM   2679  CG1 ILE C 592      33.478  56.990  36.817  1.00 37.22           C  
ATOM   2680  CG2 ILE C 592      32.224  58.592  35.318  1.00 38.27           C  
ATOM   2681  CD1 ILE C 592      34.442  56.498  35.792  1.00 36.31           C  
ATOM   2682  N   THR C 593      29.848  59.645  36.979  1.00 36.83           N  
ATOM   2683  CA  THR C 593      28.813  60.443  36.371  1.00 37.14           C  
ATOM   2684  C   THR C 593      29.408  61.558  35.496  1.00 35.85           C  
ATOM   2685  O   THR C 593      30.419  62.176  35.848  1.00 34.72           O  
ATOM   2686  CB  THR C 593      27.941  60.996  37.477  1.00 36.98           C  
ATOM   2687  OG1 THR C 593      27.176  59.909  37.996  1.00 42.16           O  
ATOM   2688  CG2 THR C 593      26.866  61.859  36.924  1.00 39.45           C  
ATOM   2689  N   GLN C 594      28.751  61.813  34.369  1.00 34.89           N  
ATOM   2690  CA  GLN C 594      29.212  62.805  33.389  1.00 34.41           C  
ATOM   2691  C   GLN C 594      27.993  63.426  32.724  1.00 34.56           C  
ATOM   2692  O   GLN C 594      27.124  62.723  32.244  1.00 34.81           O  
ATOM   2693  CB  GLN C 594      30.136  62.182  32.332  1.00 33.27           C  
ATOM   2694  CG  GLN C 594      31.000  63.216  31.603  1.00 32.06           C  
ATOM   2695  CD  GLN C 594      32.008  62.613  30.613  1.00 30.27           C  
ATOM   2696  OE1 GLN C 594      31.998  61.416  30.368  1.00 31.50           O  
ATOM   2697  NE2 GLN C 594      32.869  63.448  30.050  1.00 29.53           N  
ATOM   2698  N   VAL C 595      27.917  64.744  32.704  1.00 35.09           N  
ATOM   2699  CA  VAL C 595      26.787  65.382  32.073  1.00 36.44           C  
ATOM   2700  C   VAL C 595      27.119  65.621  30.599  1.00 36.63           C  
ATOM   2701  O   VAL C 595      28.249  65.962  30.233  1.00 36.74           O  
ATOM   2702  CB  VAL C 595      26.314  66.675  32.811  1.00 36.69           C  
ATOM   2703  CG1 VAL C 595      25.818  66.332  34.194  1.00 37.87           C  
ATOM   2704  CG2 VAL C 595      27.390  67.660  32.948  1.00 38.43           C  
ATOM   2705  N   LEU C 596      26.110  65.394  29.780  1.00 36.62           N  
ATOM   2706  CA  LEU C 596      26.155  65.577  28.355  1.00 37.73           C  
ATOM   2707  C   LEU C 596      24.974  66.453  27.968  1.00 38.46           C  
ATOM   2708  O   LEU C 596      23.862  66.245  28.445  1.00 37.51           O  
ATOM   2709  CB  LEU C 596      26.028  64.200  27.704  1.00 37.98           C  
ATOM   2710  CG  LEU C 596      26.005  64.028  26.188  1.00 38.91           C  
ATOM   2711  CD1 LEU C 596      26.773  62.788  25.786  1.00 38.58           C  
ATOM   2712  CD2 LEU C 596      24.567  63.968  25.657  1.00 39.34           C  
ATOM   2713  N   LEU C 597      25.213  67.429  27.099  1.00 40.40           N  
ATOM   2714  CA  LEU C 597      24.161  68.326  26.610  1.00 41.76           C  
ATOM   2715  C   LEU C 597      24.030  68.265  25.097  1.00 43.23           C  
ATOM   2716  O   LEU C 597      24.989  68.479  24.381  1.00 42.64           O  
ATOM   2717  CB  LEU C 597      24.465  69.756  27.034  1.00 41.73           C  
ATOM   2718  CG  LEU C 597      24.678  69.889  28.547  1.00 41.54           C  
ATOM   2719  CD1 LEU C 597      25.684  70.962  28.893  1.00 43.33           C  
ATOM   2720  CD2 LEU C 597      23.372  70.171  29.228  1.00 41.52           C  
ATOM   2721  N   LEU C 598      22.815  68.013  24.636  1.00 45.69           N  
ATOM   2722  CA  LEU C 598      22.495  67.891  23.232  1.00 47.91           C  
ATOM   2723  C   LEU C 598      21.672  69.117  22.774  1.00 49.67           C  
ATOM   2724  O   LEU C 598      20.502  69.237  23.079  1.00 49.81           O  
ATOM   2725  CB  LEU C 598      21.706  66.594  23.048  1.00 48.55           C  
ATOM   2726  CG  LEU C 598      22.050  65.647  21.896  1.00 50.31           C  
ATOM   2727  CD1 LEU C 598      21.500  66.188  20.590  1.00 50.68           C  
ATOM   2728  CD2 LEU C 598      23.549  65.441  21.798  1.00 51.74           C  
ATOM   2729  N   ALA C 599      22.293  70.042  22.053  1.00 51.75           N  
ATOM   2730  CA  ALA C 599      21.599  71.240  21.566  1.00 53.20           C  
ATOM   2731  C   ALA C 599      21.075  71.033  20.149  1.00 54.64           C  
ATOM   2732  O   ALA C 599      21.853  71.049  19.197  1.00 55.17           O  
ATOM   2733  CB  ALA C 599      22.531  72.444  21.618  1.00 53.09           C  
ATOM   2734  N   ASN C 600      19.763  70.836  20.024  1.00 56.35           N  
ATOM   2735  CA  ASN C 600      19.092  70.614  18.741  1.00 57.70           C  
ATOM   2736  C   ASN C 600      17.960  71.612  18.471  1.00 59.14           C  
ATOM   2737  O   ASN C 600      16.788  71.243  18.539  1.00 59.15           O  
ATOM   2738  CB  ASN C 600      18.515  69.199  18.720  1.00 57.66           C  
ATOM   2739  CG  ASN C 600      17.966  68.798  17.354  1.00 57.85           C  
ATOM   2740  OD1 ASN C 600      18.277  69.415  16.319  1.00 56.26           O  
ATOM   2741  ND2 ASN C 600      17.148  67.749  17.347  1.00 56.95           N  
ATOM   2742  N   PRO C 601      18.295  72.865  18.168  1.00 61.21           N  
ATOM   2743  CA  PRO C 601      17.274  73.898  17.920  1.00 62.92           C  
ATOM   2744  C   PRO C 601      16.429  73.693  16.664  1.00 64.49           C  
ATOM   2745  O   PRO C 601      15.300  74.187  16.632  1.00 65.01           O  
ATOM   2746  CB  PRO C 601      18.086  75.206  17.823  1.00 62.92           C  
ATOM   2747  CG  PRO C 601      19.474  74.803  17.529  1.00 62.41           C  
ATOM   2748  CD  PRO C 601      19.660  73.408  18.074  1.00 61.48           C  
ATOM   2749  N   GLN C 602      16.946  72.967  15.673  1.00 66.25           N  
ATOM   2750  CA  GLN C 602      16.205  72.697  14.438  1.00 67.60           C  
ATOM   2751  C   GLN C 602      15.279  71.477  14.557  1.00 68.50           C  
ATOM   2752  O   GLN C 602      14.651  71.079  13.577  1.00 68.60           O  
ATOM   2753  CB  GLN C 602      17.176  72.541  13.252  1.00 67.84           C  
ATOM   2754  CG  GLN C 602      17.379  73.826  12.423  1.00 68.90           C  
ATOM   2755  CD  GLN C 602      18.311  74.832  13.093  1.00 70.07           C  
ATOM   2756  OE1 GLN C 602      19.503  74.570  13.245  1.00 70.55           O  
ATOM   2757  NE2 GLN C 602      17.768  75.983  13.489  1.00 70.50           N  
ATOM   2758  N   LYS C 603      15.203  70.903  15.758  1.00 69.71           N  
ATOM   2759  CA  LYS C 603      14.319  69.770  16.088  1.00 70.72           C  
ATOM   2760  C   LYS C 603      14.431  68.563  15.152  1.00 71.30           C  
ATOM   2761  O   LYS C 603      13.449  67.857  14.904  1.00 71.43           O  
ATOM   2762  CB  LYS C 603      12.858  70.236  16.215  1.00 70.95           C  
ATOM   2763  CG  LYS C 603      12.622  71.320  17.304  1.00 71.64           C  
ATOM   2764  CD  LYS C 603      12.678  70.755  18.743  1.00 71.89           C  
ATOM   2765  CE  LYS C 603      11.827  71.571  19.740  1.00 71.76           C  
ATOM   2766  NZ  LYS C 603      12.407  72.901  20.074  1.00 70.40           N  
ATOM   2767  N   GLU C 604      15.648  68.308  14.678  1.00 72.12           N  
ATOM   2768  CA  GLU C 604      15.950  67.141  13.842  1.00 72.72           C  
ATOM   2769  C   GLU C 604      15.993  65.840  14.643  1.00 72.59           C  
ATOM   2770  O   GLU C 604      16.015  65.862  15.872  1.00 72.79           O  
ATOM   2771  CB  GLU C 604      17.300  67.337  13.141  1.00 73.04           C  
ATOM   2772  CG  GLU C 604      17.257  68.337  11.994  1.00 74.64           C  
ATOM   2773  CD  GLU C 604      17.102  67.682  10.634  1.00 76.54           C  
ATOM   2774  OE1 GLU C 604      16.427  66.627  10.546  1.00 77.62           O  
ATOM   2775  OE2 GLU C 604      17.649  68.233   9.654  1.00 77.52           O  
ATOM   2776  N   LYS C 605      16.021  64.710  13.934  1.00 72.45           N  
ATOM   2777  CA  LYS C 605      16.194  63.398  14.563  1.00 72.45           C  
ATOM   2778  C   LYS C 605      17.576  63.322  15.219  1.00 71.28           C  
ATOM   2779  O   LYS C 605      18.511  64.021  14.822  1.00 71.44           O  
ATOM   2780  CB  LYS C 605      16.048  62.251  13.548  1.00 73.11           C  
ATOM   2781  CG  LYS C 605      14.726  62.225  12.773  1.00 75.43           C  
ATOM   2782  CD  LYS C 605      14.896  61.623  11.360  1.00 78.11           C  
ATOM   2783  CE  LYS C 605      13.657  61.854  10.483  1.00 79.63           C  
ATOM   2784  NZ  LYS C 605      13.407  63.312  10.224  1.00 80.22           N  
ATOM   2785  N   VAL C 606      17.697  62.442  16.204  1.00 69.73           N  
ATOM   2786  CA  VAL C 606      18.841  62.431  17.104  1.00 68.31           C  
ATOM   2787  C   VAL C 606      19.617  61.160  16.873  1.00 66.64           C  
ATOM   2788  O   VAL C 606      19.103  60.060  17.078  1.00 66.34           O  
ATOM   2789  CB  VAL C 606      18.418  62.505  18.581  1.00 68.58           C  
ATOM   2790  CG1 VAL C 606      18.564  63.924  19.106  1.00 68.54           C  
ATOM   2791  CG2 VAL C 606      16.975  62.008  18.773  1.00 69.40           C  
ATOM   2792  N   ARG C 607      20.861  61.326  16.443  1.00 64.56           N  
ATOM   2793  CA  ARG C 607      21.679  60.214  15.993  1.00 63.17           C  
ATOM   2794  C   ARG C 607      23.075  60.415  16.559  1.00 60.28           C  
ATOM   2795  O   ARG C 607      23.862  61.170  16.001  1.00 60.05           O  
ATOM   2796  CB  ARG C 607      21.699  60.166  14.449  1.00 63.76           C  
ATOM   2797  CG  ARG C 607      21.148  58.873  13.826  1.00 66.52           C  
ATOM   2798  CD  ARG C 607      19.855  59.033  12.983  1.00 69.64           C  
ATOM   2799  NE  ARG C 607      18.922  57.915  13.195  1.00 72.54           N  
ATOM   2800  CZ  ARG C 607      19.154  56.638  12.860  1.00 74.93           C  
ATOM   2801  NH1 ARG C 607      18.233  55.717  13.115  1.00 75.78           N  
ATOM   2802  NH2 ARG C 607      20.289  56.267  12.265  1.00 76.32           N  
ATOM   2803  N   LEU C 608      23.371  59.749  17.672  1.00 56.70           N  
ATOM   2804  CA  LEU C 608      24.619  59.986  18.396  1.00 53.83           C  
ATOM   2805  C   LEU C 608      25.595  58.808  18.300  1.00 51.86           C  
ATOM   2806  O   LEU C 608      25.225  57.644  18.455  1.00 51.38           O  
ATOM   2807  CB  LEU C 608      24.325  60.341  19.865  1.00 53.28           C  
ATOM   2808  CG  LEU C 608      25.531  60.618  20.779  1.00 51.33           C  
ATOM   2809  CD1 LEU C 608      25.214  61.691  21.815  1.00 50.42           C  
ATOM   2810  CD2 LEU C 608      26.026  59.339  21.466  1.00 49.33           C  
ATOM   2811  N   ARG C 609      26.857  59.138  18.064  1.00 49.62           N  
ATOM   2812  CA  ARG C 609      27.925  58.154  17.985  1.00 48.06           C  
ATOM   2813  C   ARG C 609      28.906  58.407  19.099  1.00 45.91           C  
ATOM   2814  O   ARG C 609      29.476  59.493  19.195  1.00 46.05           O  
ATOM   2815  CB  ARG C 609      28.661  58.296  16.662  1.00 48.12           C  
ATOM   2816  CG  ARG C 609      29.734  57.263  16.447  1.00 50.02           C  
ATOM   2817  CD  ARG C 609      30.753  57.688  15.435  1.00 53.01           C  
ATOM   2818  NE  ARG C 609      31.801  58.522  16.019  1.00 56.00           N  
ATOM   2819  CZ  ARG C 609      32.555  59.364  15.319  1.00 57.64           C  
ATOM   2820  NH1 ARG C 609      32.385  59.491  14.006  1.00 58.93           N  
ATOM   2821  NH2 ARG C 609      33.486  60.076  15.931  1.00 57.68           N  
ATOM   2822  N   TYR C 610      29.139  57.398  19.913  1.00 43.48           N  
ATOM   2823  CA  TYR C 610      30.064  57.536  21.014  1.00 41.84           C  
ATOM   2824  C   TYR C 610      31.344  56.761  20.782  1.00 40.84           C  
ATOM   2825  O   TYR C 610      31.395  55.851  19.971  1.00 40.28           O  
ATOM   2826  CB  TYR C 610      29.399  57.078  22.307  1.00 41.90           C  
ATOM   2827  CG  TYR C 610      29.230  55.588  22.451  1.00 40.80           C  
ATOM   2828  CD1 TYR C 610      28.042  54.967  22.099  1.00 41.26           C  
ATOM   2829  CD2 TYR C 610      30.248  54.807  22.954  1.00 41.30           C  
ATOM   2830  CE1 TYR C 610      27.879  53.611  22.234  1.00 41.66           C  
ATOM   2831  CE2 TYR C 610      30.100  53.437  23.081  1.00 43.16           C  
ATOM   2832  CZ  TYR C 610      28.912  52.852  22.735  1.00 42.89           C  
ATOM   2833  OH  TYR C 610      28.769  51.491  22.884  1.00 46.69           O  
ATOM   2834  N   LYS C 611      32.378  57.150  21.510  1.00 39.98           N  
ATOM   2835  CA  LYS C 611      33.600  56.387  21.622  1.00 39.61           C  
ATOM   2836  C   LYS C 611      33.907  56.195  23.107  1.00 38.64           C  
ATOM   2837  O   LYS C 611      33.954  57.165  23.871  1.00 37.88           O  
ATOM   2838  CB  LYS C 611      34.726  57.142  20.930  1.00 39.70           C  
ATOM   2839  CG  LYS C 611      36.096  56.472  20.950  1.00 40.74           C  
ATOM   2840  CD  LYS C 611      37.100  57.342  20.205  1.00 42.88           C  
ATOM   2841  CE  LYS C 611      38.535  56.830  20.280  1.00 44.66           C  
ATOM   2842  NZ  LYS C 611      39.479  57.952  19.938  1.00 46.77           N  
ATOM   2843  N   LEU C 612      34.097  54.946  23.509  1.00 38.03           N  
ATOM   2844  CA  LEU C 612      34.392  54.617  24.908  1.00 38.00           C  
ATOM   2845  C   LEU C 612      35.808  54.037  25.026  1.00 38.40           C  
ATOM   2846  O   LEU C 612      36.163  53.063  24.370  1.00 37.81           O  
ATOM   2847  CB  LEU C 612      33.347  53.645  25.450  1.00 37.61           C  
ATOM   2848  CG  LEU C 612      33.050  53.529  26.953  1.00 38.26           C  
ATOM   2849  CD1 LEU C 612      32.685  52.093  27.310  1.00 38.64           C  
ATOM   2850  CD2 LEU C 612      34.170  54.005  27.855  1.00 38.95           C  
ATOM   2851  N   THR C 613      36.616  54.641  25.884  1.00 38.99           N  
ATOM   2852  CA  THR C 613      37.980  54.202  26.086  1.00 39.55           C  
ATOM   2853  C   THR C 613      38.161  53.800  27.537  1.00 39.90           C  
ATOM   2854  O   THR C 613      37.779  54.531  28.421  1.00 40.40           O  
ATOM   2855  CB  THR C 613      38.936  55.341  25.744  1.00 39.54           C  
ATOM   2856  OG1 THR C 613      38.777  55.710  24.371  1.00 40.11           O  
ATOM   2857  CG2 THR C 613      40.395  54.903  25.865  1.00 39.20           C  
ATOM   2858  N   PHE C 614      38.745  52.638  27.780  1.00 40.99           N  
ATOM   2859  CA  PHE C 614      39.081  52.209  29.146  1.00 41.72           C  
ATOM   2860  C   PHE C 614      40.120  51.089  29.155  1.00 43.70           C  
ATOM   2861  O   PHE C 614      40.257  50.361  28.183  1.00 43.70           O  
ATOM   2862  CB  PHE C 614      37.824  51.814  29.933  1.00 40.54           C  
ATOM   2863  CG  PHE C 614      37.108  50.618  29.403  1.00 39.49           C  
ATOM   2864  CD1 PHE C 614      36.098  50.754  28.449  1.00 38.49           C  
ATOM   2865  CD2 PHE C 614      37.400  49.341  29.890  1.00 39.24           C  
ATOM   2866  CE1 PHE C 614      35.411  49.656  27.963  1.00 36.97           C  
ATOM   2867  CE2 PHE C 614      36.703  48.214  29.415  1.00 38.50           C  
ATOM   2868  CZ  PHE C 614      35.699  48.379  28.443  1.00 38.69           C  
ATOM   2869  N   THR C 615      40.858  50.988  30.258  1.00 46.12           N  
ATOM   2870  CA  THR C 615      41.830  49.923  30.478  1.00 47.78           C  
ATOM   2871  C   THR C 615      41.410  49.003  31.642  1.00 48.98           C  
ATOM   2872  O   THR C 615      41.340  49.427  32.804  1.00 48.98           O  
ATOM   2873  CB  THR C 615      43.186  50.532  30.764  1.00 47.99           C  
ATOM   2874  OG1 THR C 615      43.624  51.281  29.619  1.00 50.00           O  
ATOM   2875  CG2 THR C 615      44.263  49.447  30.924  1.00 48.80           C  
ATOM   2876  N   MET C 616      41.125  47.747  31.301  1.00 50.29           N  
ATOM   2877  CA  MET C 616      40.829  46.679  32.261  1.00 51.18           C  
ATOM   2878  C   MET C 616      41.992  45.686  32.283  1.00 51.36           C  
ATOM   2879  O   MET C 616      41.976  44.681  31.571  1.00 51.55           O  
ATOM   2880  CB  MET C 616      39.529  45.972  31.856  1.00 51.31           C  
ATOM   2881  CG  MET C 616      38.838  45.272  32.991  1.00 52.93           C  
ATOM   2882  SD  MET C 616      37.382  44.465  32.398  1.00 55.94           S  
ATOM   2883  CE  MET C 616      36.182  45.804  32.400  1.00 56.77           C  
ATOM   2884  N   GLY C 617      43.023  46.010  33.058  1.00 51.91           N  
ATOM   2885  CA  GLY C 617      44.172  45.138  33.252  1.00 52.00           C  
ATOM   2886  C   GLY C 617      45.129  45.033  32.071  1.00 52.34           C  
ATOM   2887  O   GLY C 617      45.757  46.016  31.662  1.00 52.62           O  
ATOM   2888  N   ASP C 618      45.242  43.816  31.544  1.00 52.31           N  
ATOM   2889  CA  ASP C 618      46.082  43.484  30.385  1.00 52.50           C  
ATOM   2890  C   ASP C 618      45.557  44.129  29.084  1.00 51.36           C  
ATOM   2891  O   ASP C 618      46.298  44.274  28.116  1.00 50.99           O  
ATOM   2892  CB  ASP C 618      46.079  41.950  30.197  1.00 52.79           C  
ATOM   2893  CG  ASP C 618      47.360  41.422  29.579  1.00 55.77           C  
ATOM   2894  OD1 ASP C 618      47.820  41.966  28.534  1.00 60.46           O  
ATOM   2895  OD2 ASP C 618      47.978  40.442  30.059  1.00 58.33           O  
ATOM   2896  N   GLN C 619      44.270  44.480  29.084  1.00 49.70           N  
ATOM   2897  CA  GLN C 619      43.530  44.851  27.901  1.00 48.50           C  
ATOM   2898  C   GLN C 619      43.231  46.330  27.902  1.00 47.32           C  
ATOM   2899  O   GLN C 619      43.069  46.918  28.951  1.00 47.56           O  
ATOM   2900  CB  GLN C 619      42.204  44.091  27.893  1.00 48.74           C  
ATOM   2901  CG  GLN C 619      42.351  42.607  28.104  1.00 48.98           C  
ATOM   2902  CD  GLN C 619      43.120  41.968  26.969  1.00 51.17           C  
ATOM   2903  OE1 GLN C 619      42.737  42.129  25.795  1.00 51.68           O  
ATOM   2904  NE2 GLN C 619      44.215  41.262  27.297  1.00 50.46           N  
ATOM   2905  N   THR C 620      43.164  46.921  26.714  1.00 46.16           N  
ATOM   2906  CA  THR C 620      42.688  48.299  26.502  1.00 44.18           C  
ATOM   2907  C   THR C 620      41.603  48.245  25.417  1.00 43.41           C  
ATOM   2908  O   THR C 620      41.707  47.467  24.482  1.00 43.30           O  
ATOM   2909  CB  THR C 620      43.835  49.200  26.068  1.00 44.39           C  
ATOM   2910  OG1 THR C 620      44.775  49.375  27.145  1.00 40.20           O  
ATOM   2911  CG2 THR C 620      43.317  50.632  25.744  1.00 44.54           C  
ATOM   2912  N   TYR C 621      40.544  49.025  25.569  1.00 42.24           N  
ATOM   2913  CA  TYR C 621      39.442  49.032  24.621  1.00 41.64           C  
ATOM   2914  C   TYR C 621      39.190  50.445  24.120  1.00 40.98           C  
ATOM   2915  O   TYR C 621      39.313  51.396  24.859  1.00 40.14           O  
ATOM   2916  CB  TYR C 621      38.160  48.467  25.262  1.00 41.97           C  
ATOM   2917  CG  TYR C 621      38.350  47.067  25.833  1.00 42.25           C  
ATOM   2918  CD1 TYR C 621      38.063  45.934  25.069  1.00 42.45           C  
ATOM   2919  CD2 TYR C 621      38.833  46.883  27.122  1.00 42.69           C  
ATOM   2920  CE1 TYR C 621      38.251  44.653  25.593  1.00 44.45           C  
ATOM   2921  CE2 TYR C 621      39.024  45.609  27.653  1.00 43.43           C  
ATOM   2922  CZ  TYR C 621      38.746  44.505  26.880  1.00 43.76           C  
ATOM   2923  OH  TYR C 621      38.963  43.260  27.394  1.00 45.59           O  
ATOM   2924  N   ASN C 622      38.901  50.568  22.833  1.00 40.81           N  
ATOM   2925  CA  ASN C 622      38.319  51.766  22.265  1.00 40.66           C  
ATOM   2926  C   ASN C 622      37.094  51.265  21.526  1.00 41.44           C  
ATOM   2927  O   ASN C 622      37.204  50.661  20.468  1.00 41.91           O  
ATOM   2928  CB  ASN C 622      39.299  52.498  21.347  1.00 40.13           C  
ATOM   2929  CG  ASN C 622      40.259  53.384  22.122  1.00 39.04           C  
ATOM   2930  OD1 ASN C 622      41.396  52.990  22.424  1.00 37.17           O  
ATOM   2931  ND2 ASN C 622      39.808  54.590  22.460  1.00 36.26           N  
ATOM   2932  N   GLU C 623      35.935  51.442  22.138  1.00 42.12           N  
ATOM   2933  CA  GLU C 623      34.693  50.965  21.589  1.00 43.01           C  
ATOM   2934  C   GLU C 623      34.007  52.113  20.886  1.00 44.26           C  
ATOM   2935  O   GLU C 623      34.098  53.275  21.296  1.00 45.26           O  
ATOM   2936  CB  GLU C 623      33.809  50.404  22.698  1.00 43.23           C  
ATOM   2937  CG  GLU C 623      34.525  49.376  23.574  1.00 43.95           C  
ATOM   2938  CD  GLU C 623      34.322  47.929  23.135  1.00 45.01           C  
ATOM   2939  OE1 GLU C 623      34.073  47.679  21.928  1.00 46.58           O  
ATOM   2940  OE2 GLU C 623      34.416  47.032  24.011  1.00 44.01           O  
ATOM   2941  N   MET C 624      33.366  51.780  19.783  1.00 45.35           N  
ATOM   2942  CA  MET C 624      32.539  52.684  19.028  1.00 46.25           C  
ATOM   2943  C   MET C 624      31.157  52.079  19.083  1.00 46.16           C  
ATOM   2944  O   MET C 624      31.003  50.872  19.022  1.00 45.30           O  
ATOM   2945  CB  MET C 624      33.020  52.715  17.565  1.00 47.30           C  
ATOM   2946  CG  MET C 624      32.691  53.978  16.800  1.00 49.37           C  
ATOM   2947  SD  MET C 624      33.949  55.300  16.844  1.00 53.78           S  
ATOM   2948  CE  MET C 624      34.988  54.891  18.130  1.00 51.63           C  
ATOM   2949  N   GLY C 625      30.149  52.922  19.198  1.00 46.89           N  
ATOM   2950  CA  GLY C 625      28.776  52.464  19.158  1.00 47.27           C  
ATOM   2951  C   GLY C 625      27.861  53.594  18.771  1.00 48.07           C  
ATOM   2952  O   GLY C 625      28.267  54.760  18.740  1.00 47.95           O  
ATOM   2953  N   ASP C 626      26.623  53.248  18.455  1.00 48.86           N  
ATOM   2954  CA  ASP C 626      25.639  54.247  18.100  1.00 49.85           C  
ATOM   2955  C   ASP C 626      24.438  54.140  19.030  1.00 50.78           C  
ATOM   2956  O   ASP C 626      24.185  53.086  19.629  1.00 50.52           O  
ATOM   2957  CB  ASP C 626      25.252  54.119  16.618  1.00 49.94           C  
ATOM   2958  CG  ASP C 626      26.481  54.070  15.697  1.00 50.30           C  
ATOM   2959  OD1 ASP C 626      26.979  55.142  15.288  1.00 52.05           O  
ATOM   2960  OD2 ASP C 626      27.045  53.010  15.360  1.00 50.93           O  
ATOM   2961  N   VAL C 627      23.750  55.276  19.165  1.00 52.08           N  
ATOM   2962  CA  VAL C 627      22.594  55.463  20.032  1.00 53.06           C  
ATOM   2963  C   VAL C 627      21.563  56.309  19.277  1.00 54.52           C  
ATOM   2964  O   VAL C 627      21.891  57.365  18.736  1.00 54.39           O  
ATOM   2965  CB  VAL C 627      22.960  56.222  21.337  1.00 52.95           C  
ATOM   2966  CG1 VAL C 627      21.776  56.219  22.309  1.00 53.06           C  
ATOM   2967  CG2 VAL C 627      24.170  55.624  21.993  1.00 52.67           C  
ATOM   2968  N   ASP C 628      20.325  55.841  19.231  1.00 56.38           N  
ATOM   2969  CA  ASP C 628      19.244  56.618  18.641  1.00 58.11           C  
ATOM   2970  C   ASP C 628      17.963  56.656  19.496  1.00 58.83           C  
ATOM   2971  O   ASP C 628      17.012  57.354  19.135  1.00 59.08           O  
ATOM   2972  CB  ASP C 628      18.938  56.078  17.232  1.00 58.75           C  
ATOM   2973  CG  ASP C 628      18.098  54.805  17.258  1.00 60.75           C  
ATOM   2974  OD1 ASP C 628      18.606  53.735  17.713  1.00 61.56           O  
ATOM   2975  OD2 ASP C 628      16.903  54.798  16.852  1.00 63.38           O  
ATOM   2976  N   GLN C 629      17.939  55.925  20.613  1.00 59.78           N  
ATOM   2977  CA  GLN C 629      16.784  55.911  21.518  1.00 60.60           C  
ATOM   2978  C   GLN C 629      16.785  57.148  22.428  1.00 60.86           C  
ATOM   2979  O   GLN C 629      17.058  57.053  23.628  1.00 61.07           O  
ATOM   2980  CB  GLN C 629      16.784  54.651  22.391  1.00 60.91           C  
ATOM   2981  CG  GLN C 629      16.593  53.349  21.657  1.00 62.39           C  
ATOM   2982  CD  GLN C 629      16.958  52.149  22.513  1.00 64.99           C  
ATOM   2983  OE1 GLN C 629      17.725  51.275  22.082  1.00 67.39           O  
ATOM   2984  NE2 GLN C 629      16.420  52.101  23.732  1.00 65.62           N  
ATOM   2985  N   PHE C 630      16.498  58.302  21.840  1.00 61.02           N  
ATOM   2986  CA  PHE C 630      16.319  59.537  22.572  1.00 61.44           C  
ATOM   2987  C   PHE C 630      14.828  59.902  22.551  1.00 62.36           C  
ATOM   2988  O   PHE C 630      14.099  59.522  21.625  1.00 61.95           O  
ATOM   2989  CB  PHE C 630      17.122  60.661  21.914  1.00 61.23           C  
ATOM   2990  CG  PHE C 630      18.600  60.430  21.907  1.00 60.60           C  
ATOM   2991  CD1 PHE C 630      19.211  59.811  20.830  1.00 60.76           C  
ATOM   2992  CD2 PHE C 630      19.385  60.833  22.976  1.00 59.83           C  
ATOM   2993  CE1 PHE C 630      20.592  59.593  20.826  1.00 60.83           C  
ATOM   2994  CE2 PHE C 630      20.764  60.620  22.982  1.00 59.53           C  
ATOM   2995  CZ  PHE C 630      21.366  60.001  21.906  1.00 60.09           C  
ATOM   2996  N   PRO C 631      14.375  60.662  23.550  1.00 63.33           N  
ATOM   2997  CA  PRO C 631      12.991  61.153  23.558  1.00 63.79           C  
ATOM   2998  C   PRO C 631      12.752  62.133  22.406  1.00 64.21           C  
ATOM   2999  O   PRO C 631      13.719  62.773  21.972  1.00 64.16           O  
ATOM   3000  CB  PRO C 631      12.884  61.874  24.903  1.00 63.91           C  
ATOM   3001  CG  PRO C 631      14.279  62.241  25.252  1.00 63.86           C  
ATOM   3002  CD  PRO C 631      15.127  61.121  24.731  1.00 63.25           C  
ATOM   3003  N   PRO C 632      11.516  62.232  21.905  1.00 64.56           N  
ATOM   3004  CA  PRO C 632      11.180  63.221  20.871  1.00 65.07           C  
ATOM   3005  C   PRO C 632      11.644  64.646  21.237  1.00 65.46           C  
ATOM   3006  O   PRO C 632      11.513  65.025  22.401  1.00 65.69           O  
ATOM   3007  CB  PRO C 632       9.650  63.145  20.801  1.00 65.10           C  
ATOM   3008  CG  PRO C 632       9.332  61.747  21.218  1.00 64.83           C  
ATOM   3009  CD  PRO C 632      10.356  61.395  22.260  1.00 64.43           C  
ATOM   3010  N   PRO C 633      12.226  65.385  20.293  1.00 65.78           N  
ATOM   3011  CA  PRO C 633      12.674  66.768  20.539  1.00 66.09           C  
ATOM   3012  C   PRO C 633      11.628  67.762  21.082  1.00 66.26           C  
ATOM   3013  O   PRO C 633      11.998  68.670  21.842  1.00 66.09           O  
ATOM   3014  CB  PRO C 633      13.156  67.223  19.160  1.00 66.00           C  
ATOM   3015  CG  PRO C 633      13.555  65.982  18.490  1.00 65.97           C  
ATOM   3016  CD  PRO C 633      12.577  64.938  18.935  1.00 65.72           C  
ATOM   3017  N   GLU C 634      10.358  67.611  20.709  1.00 66.45           N  
ATOM   3018  CA  GLU C 634       9.324  68.531  21.212  1.00 66.80           C  
ATOM   3019  C   GLU C 634       8.897  68.184  22.647  1.00 66.02           C  
ATOM   3020  O   GLU C 634       7.918  68.703  23.162  1.00 66.11           O  
ATOM   3021  CB  GLU C 634       8.103  68.586  20.278  1.00 67.23           C  
ATOM   3022  CG  GLU C 634       7.765  69.992  19.772  1.00 69.46           C  
ATOM   3023  CD  GLU C 634       7.530  71.021  20.884  1.00 72.65           C  
ATOM   3024  OE1 GLU C 634       8.423  71.231  21.749  1.00 73.92           O  
ATOM   3025  OE2 GLU C 634       6.442  71.648  20.887  1.00 75.12           O  
ATOM   3026  N   THR C 635       9.666  67.312  23.278  1.00 65.18           N  
ATOM   3027  CA  THR C 635       9.392  66.798  24.605  1.00 64.37           C  
ATOM   3028  C   THR C 635      10.516  67.204  25.574  1.00 63.34           C  
ATOM   3029  O   THR C 635      10.388  67.028  26.782  1.00 63.22           O  
ATOM   3030  CB  THR C 635       9.249  65.258  24.477  1.00 64.31           C  
ATOM   3031  OG1 THR C 635       7.914  64.929  24.094  1.00 64.31           O  
ATOM   3032  CG2 THR C 635       9.418  64.551  25.754  1.00 64.96           C  
ATOM   3033  N   TRP C 636      11.593  67.786  25.041  1.00 62.29           N  
ATOM   3034  CA  TRP C 636      12.796  68.104  25.832  1.00 61.25           C  
ATOM   3035  C   TRP C 636      12.588  69.213  26.858  1.00 61.30           C  
ATOM   3036  O   TRP C 636      13.375  69.325  27.795  1.00 60.96           O  
ATOM   3037  CB  TRP C 636      13.952  68.499  24.915  1.00 60.56           C  
ATOM   3038  CG  TRP C 636      14.509  67.368  24.135  1.00 57.72           C  
ATOM   3039  CD1 TRP C 636      14.075  66.069  24.129  1.00 55.57           C  
ATOM   3040  CD2 TRP C 636      15.608  67.427  23.228  1.00 54.48           C  
ATOM   3041  NE1 TRP C 636      14.850  65.314  23.282  1.00 54.57           N  
ATOM   3042  CE2 TRP C 636      15.804  66.120  22.718  1.00 54.29           C  
ATOM   3043  CE3 TRP C 636      16.469  68.447  22.805  1.00 53.26           C  
ATOM   3044  CZ2 TRP C 636      16.816  65.813  21.800  1.00 52.05           C  
ATOM   3045  CZ3 TRP C 636      17.468  68.144  21.889  1.00 52.04           C  
ATOM   3046  CH2 TRP C 636      17.626  66.836  21.392  1.00 51.72           C  
ATOM   3047  N   GLY C 637      11.538  70.018  26.662  1.00 61.17           N  
ATOM   3048  CA  GLY C 637      11.193  71.109  27.547  1.00 61.21           C  
ATOM   3049  C   GLY C 637      10.159  70.732  28.590  1.00 61.31           C  
ATOM   3050  O   GLY C 637       9.850  71.536  29.453  1.00 61.39           O  
ATOM   3051  N   SER C 638       9.631  69.515  28.517  1.00 61.82           N  
ATOM   3052  CA  SER C 638       8.667  69.027  29.507  1.00 62.12           C  
ATOM   3053  C   SER C 638       9.023  67.644  30.070  1.00 62.37           C  
ATOM   3054  O   SER C 638       8.169  66.965  30.636  1.00 62.06           O  
ATOM   3055  CB  SER C 638       7.250  69.028  28.910  1.00 62.11           C  
ATOM   3056  OG  SER C 638       7.227  68.453  27.617  1.00 61.83           O  
ATOM   3057  N   LEU C 639      10.289  67.248  29.945  1.00 63.00           N  
ATOM   3058  CA  LEU C 639      10.782  65.986  30.521  1.00 63.54           C  
ATOM   3059  C   LEU C 639      10.857  66.063  32.037  1.00 63.29           C  
ATOM   3060  O   LEU C 639      11.625  66.909  32.532  1.00 47.32           O  
ATOM   3061  CB  LEU C 639      12.186  65.631  29.979  1.00 63.89           C  
ATOM   3062  CG  LEU C 639      12.282  65.213  28.515  1.00 64.28           C  
ATOM   3063  CD1 LEU C 639      13.650  64.643  28.170  1.00 64.93           C  
ATOM   3064  CD2 LEU C 639      11.217  64.210  28.257  1.00 65.07           C  
ATOM   3065  OXT LEU C 639      10.182  65.293  32.723  1.00 63.97           O  
TER    3066      LEU C 639                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
