
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 ( 1007),  selected  126 , name 1z9l_A
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 1z9l_A.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     0_A      -       -           -
LGA    X     1_A      E     267          4.277
LGA    A     2_A      D     268          2.741
LGA    K     3_A      L     269          3.194
LGA    H     4_A      L     270          1.654
LGA    E     5_A      R     271          2.939
LGA    -       -      P     272           -
LGA    -       -      F     273           -
LGA    -       -      F     274           -
LGA    Q     6_A      E     275          2.213
LGA    I     7_A      K     276          3.845
LGA    -       -      C     277           -
LGA    L     8_A      V     278          1.687
LGA    V     9_A      K     279          1.633
LGA    L    10_A      I     280          1.082
LGA    D    11_A      E     281          1.165
LGA    P    12_A      E     282          2.269
LGA    P    13_A      V     283           -
LGA    S    14_A      -       -           -
LGA    D    15_A      -       -           -
LGA    L    16_A      S     284           #
LGA    K    17_A      R     285          4.533
LGA    F    18_A      N     286          3.730
LGA    K    19_A      E     287          3.329
LGA    G    20_A      -       -           -
LGA    P    21_A      -       -           -
LGA    F    22_A      -       -           -
LGA    T    23_A      -       -           -
LGA    D    24_A      -       -           -
LGA    V    25_A      -       -           -
LGA    V    26_A      Q     288          0.956
LGA    T    27_A      G     289          3.177
LGA    T    28_A      V     290          1.960
LGA    N    29_A      T     291          1.028
LGA    L    30_A      L     292          1.756
LGA    K    31_A      S     293          1.718
LGA    L    32_A      I     294          1.496
LGA    Q    33_A      T     295          1.069
LGA    N    34_A      N     296          0.631
LGA    P    35_A      V     297          0.729
LGA    S    36_A      T     298          1.064
LGA    D    37_A      D     299          0.646
LGA    R    38_A      L     300          0.967
LGA    K    39_A      V     301          0.658
LGA    V    40_A      L     302          0.604
LGA    C    41_A      K     303          0.588
LGA    F    42_A      L     304          1.225
LGA    K    43_A      K     305          2.573
LGA    V    44_A      K     306          3.945
LGA    K    45_A      T     307          4.730
LGA    T    46_A      A     308           #
LGA    T    47_A      H     309          3.789
LGA    A    48_A      D     310          1.529
LGA    P    49_A      T     311          0.788
LGA    R    50_A      L     312          3.591
LGA    R    51_A      -       -           -
LGA    Y    52_A      L     313          2.645
LGA    C    53_A      V     314          2.097
LGA    V    54_A      Y     315          1.480
LGA    R    55_A      F     316          3.555
LGA    P    56_A      -       -           -
LGA    N    57_A      R     317          2.890
LGA    S    58_A      D     318          1.547
LGA    G    59_A      M     319          1.492
LGA    V    60_A      T     320          1.079
LGA    I    61_A      L     321          0.993
LGA    D    62_A      K     322          0.952
LGA    P    63_A      P     323          0.659
LGA    G    64_A      H     324          0.285
LGA    S    65_A      T     325          0.895
LGA    I    66_A      R     326          1.789
LGA    V    67_A      Y     327          1.691
LGA    T    68_A      T     328          1.704
LGA    V    69_A      V     329          1.683
LGA    S    70_A      R     330          1.516
LGA    V    71_A      I     331          1.157
LGA    X    72_A      G     332          1.348
LGA    L    73_A      F     333          1.203
LGA    Q    74_A      K     334          1.754
LGA    P    75_A      Q     335          3.592
LGA    F    76_A      G     336          4.069
LGA    D    77_A      -       -           -
LGA    Y    78_A      -       -           -
LGA    D    79_A      -       -           -
LGA    P    80_A      -       -           -
LGA    N    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    K    83_A      -       -           -
LGA    S    84_A      I     337           #
LGA    K    85_A      K     338           #
LGA    H    86_A      G     339          4.909
LGA    K    87_A      G     340          2.432
LGA    F    88_A      D     341          1.883
LGA    X    89_A      V     342          3.007
LGA    -       -      N     343           -
LGA    V    90_A      F     344          4.351
LGA    Q    91_A      E     345          3.356
LGA    T    92_A      V     346          2.214
LGA    I    93_A      T     347          4.192
LGA    F    94_A      N     348          3.752
LGA    A    95_A      F     349           #
LGA    P    96_A      -       -           -
LGA    P    97_A      -       -           -
LGA    N    98_A      -       -           -
LGA    I    99_A      -       -           -
LGA    S   100_A      -       -           -
LGA    D   101_A      -       -           -
LGA    X   102_A      -       -           -
LGA    E   103_A      -       -           -
LGA    A   104_A      -       -           -
LGA    V   105_A      -       -           -
LGA    W   106_A      -       -           -
LGA    K   107_A      -       -           -
LGA    E   108_A      -       -           -
LGA    A   109_A      I     350          4.267
LGA    K   110_A      V     351          3.914
LGA    P   111_A      A     352          4.309
LGA    D   112_A      P     353           -
LGA    -       -      D     354           -
LGA    -       -      K     355           -
LGA    E   113_A      G     356          4.887
LGA    L   114_A      L     357          1.036
LGA    X   115_A      K     358          5.157
LGA    D   116_A      Y     359          1.812
LGA    S   117_A      T     360          3.513
LGA    K   118_A      I     361          2.739
LGA    L   119_A      S     362          1.104
LGA    R   120_A      L     363          2.960
LGA    C   121_A      -       -           -
LGA    V   122_A      -       -           -
LGA    F   123_A      -       -           -
LGA    E   124_A      -       -           -
LGA    X   125_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126   97    5.0     83    2.63     9.64     57.872     3.044

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.253370 * X  +   0.434082 * Y  +   0.864510 * Z  +   8.425019
  Y_new =   0.967329 * X  +  -0.121881 * Y  +  -0.222306 * Z  +  54.693901
  Z_new =   0.008868 * X  +   0.892591 * Y  +  -0.450781 * Z  +  27.462187 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.038456   -1.103137  [ DEG:   116.7949    -63.2051 ]
  Theta =  -0.008868   -3.132724  [ DEG:    -0.5081   -179.4919 ]
  Phi   =   1.314624   -1.826969  [ DEG:    75.3224   -104.6776 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1z9l_A                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1z9l_A.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126   97   5.0   83   2.63    9.64  57.872
REMARK  ---------------------------------------------------------- 
MOLECULE 1z9l_A
HEADER    PROTEIN BINDING                         03-APR-05   1Z9L              
TITLE     1.7 ANGSTROM CRYSTAL STRUCTURE OF THE RAT VAP-A MSP                   
TITLE    2 HOMOLOGY DOMAIN                                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: VESICLE-ASSOCIATED MEMBRANE PROTEIN-ASSOCIATED             
COMPND   3 PROTEIN A;                                                           
COMPND   4 CHAIN: A;                                                            
COMPND   5 SYNONYM: VAMP- ASSOCIATED PROTEIN A, VAMP-A, VAP-A, 33 KDA           
COMPND   6 VAMP-ASSOCIATED PROTEIN, VAP-33;                                     
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 GENE: VAPA, VAP33;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PGEX-4T                                   
KEYWDS    VAP-A, CYTOPLASMIC DOMAIN                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.E.KAISER,J.H.BRICKNER,A.R.REILEIN,T.D.FENN,P.WALTER,                
AUTHOR   2 A.T.BRUNGER                                                          
REVDAT   2   13-DEC-05 1Z9L    1       JRNL                                     
REVDAT   1   19-JUL-05 1Z9L    0                                                
JRNL        AUTH   S.E.KAISER,J.H.BRICKNER,A.R.REILEIN,T.D.FENN,                
JRNL        AUTH 2 P.WALTER,A.T.BRUNGER                                         
JRNL        TITL   STRUCTURAL BASIS OF FFAT MOTIF-MEDIATED ER                   
JRNL        TITL 2 TARGETING                                                    
JRNL        REF    STRUCTURE                     V.  13  1035 2005              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1Z9L A    1   125  UNP    Q9Z270   VAPA_RAT         1    125             
SEQRES   1 A  128  GLY SER HIS MSE ALA LYS HIS GLU GLN ILE LEU VAL LEU          
SEQRES   2 A  128  ASP PRO PRO SER ASP LEU LYS PHE LYS GLY PRO PHE THR          
SEQRES   3 A  128  ASP VAL VAL THR THR ASN LEU LYS LEU GLN ASN PRO SER          
SEQRES   4 A  128  ASP ARG LYS VAL CYS PHE LYS VAL LYS THR THR ALA PRO          
SEQRES   5 A  128  ARG ARG TYR CYS VAL ARG PRO ASN SER GLY VAL ILE ASP          
SEQRES   6 A  128  PRO GLY SER ILE VAL THR VAL SER VAL MSE LEU GLN PRO          
SEQRES   7 A  128  PHE ASP TYR ASP PRO ASN GLU LYS SER LYS HIS LYS PHE          
SEQRES   8 A  128  MSE VAL GLN THR ILE PHE ALA PRO PRO ASN ILE SER ASP          
SEQRES   9 A  128  MSE GLU ALA VAL TRP LYS GLU ALA LYS PRO ASP GLU LEU          
SEQRES  10 A  128  MSE ASP SER LYS LEU ARG CYS VAL PHE GLU MSE                  
HET    MSE  A   1       8                                                       
HET    MSE  A  72      16                                                       
HET    MSE  A  89       8                                                       
HET    MSE  A 102       8                                                       
HET    MSE  A 115       8                                                       
HET    MSE  A 125       9                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *131(H2 O)                                                    
CRYST1   48.200   48.200  112.390  90.00  90.00  90.00 P 42 21 2     8          
ATOM      1  N   HIS A   0      34.705  41.887  13.546  1.00 36.90           N  
ATOM      2  CA  HIS A   0      35.243  41.190  14.747  1.00 36.31           C  
ATOM      3  C   HIS A   0      34.268  41.237  15.919  1.00 36.30           C  
ATOM      4  O   HIS A   0      33.211  41.862  15.844  1.00 36.66           O  
ATOM      5  CB  HIS A   0      36.576  41.812  15.170  1.00 36.07           C  
ATOM      6  CG  HIS A   0      37.699  41.542  14.217  0.00 36.06           C  
ATOM      7  ND1 HIS A   0      37.637  41.870  12.881  0.00 35.98           N  
ATOM      8  CD2 HIS A   0      38.914  40.975  14.411  0.00 35.98           C  
ATOM      9  CE1 HIS A   0      38.765  41.517  12.290  0.00 35.93           C  
ATOM     10  NE2 HIS A   0      39.557  40.972  13.197  0.00 35.93           N  
HETATM   11  N   MSE A   1      34.644  40.571  17.003  1.00 35.35           N  
HETATM   12  CA  MSE A   1      33.824  40.510  18.205  1.00 34.62           C  
HETATM   13  C   MSE A   1      34.171  41.663  19.144  1.00 31.82           C  
HETATM   14  O   MSE A   1      35.335  41.871  19.472  1.00 32.35           O  
HETATM   15  CB  MSE A   1      34.064  39.169  18.909  1.00 36.79           C  
HETATM   16  CG  MSE A   1      33.239  38.927  20.161  1.00 39.59           C  
HETATM   17 SE   MSE A   1      33.680  37.217  20.980  1.00 43.36          SE  
HETATM   18  CE  MSE A   1      32.387  36.110  20.062  1.00 42.32           C  
ATOM     19  N   ALA A   2      33.162  42.420  19.564  1.00 29.89           N  
ATOM     20  CA  ALA A   2      33.396  43.531  20.484  1.00 26.62           C  
ATOM     21  C   ALA A   2      33.834  42.937  21.817  1.00 25.37           C  
ATOM     22  O   ALA A   2      33.306  41.912  22.243  1.00 24.10           O  
ATOM     23  CB  ALA A   2      32.121  44.348  20.665  1.00 28.48           C  
ATOM     24  N   LYS A   3      34.803  43.569  22.469  1.00 22.52           N  
ATOM     25  CA  LYS A   3      35.299  43.076  23.747  1.00 21.48           C  
ATOM     26  C   LYS A   3      34.333  43.288  24.904  1.00 19.79           C  
ATOM     27  O   LYS A   3      34.278  42.469  25.818  1.00 19.04           O  
ATOM     28  CB  LYS A   3      36.633  43.741  24.096  1.00 23.90           C  
ATOM     29  CG  LYS A   3      37.788  43.343  23.192  1.00 27.46           C  
ATOM     30  CD  LYS A   3      39.084  44.000  23.644  1.00 30.59           C  
ATOM     31  CE  LYS A   3      40.261  43.560  22.785  1.00 33.77           C  
ATOM     32  NZ  LYS A   3      41.522  44.232  23.203  1.00 36.23           N  
ATOM     33  N   HIS A   4      33.571  44.378  24.862  1.00 18.73           N  
ATOM     34  CA  HIS A   4      32.637  44.698  25.945  1.00 18.27           C  
ATOM     35  C   HIS A   4      31.338  45.322  25.465  1.00 16.43           C  
ATOM     36  O   HIS A   4      31.262  45.865  24.367  1.00 16.81           O  
ATOM     37  CB  HIS A   4      33.249  45.726  26.908  1.00 21.41           C  
ATOM     38  CG  HIS A   4      34.608  45.375  27.420  1.00 24.15           C  
ATOM     39  ND1 HIS A   4      34.824  44.367  28.335  1.00 27.21           N  
ATOM     40  CD2 HIS A   4      35.818  45.935  27.185  1.00 25.72           C  
ATOM     41  CE1 HIS A   4      36.108  44.324  28.643  1.00 27.50           C  
ATOM     42  NE2 HIS A   4      36.733  45.264  27.959  1.00 26.13           N  
ATOM     43  N   GLU A   5      30.318  45.243  26.312  1.00 14.48           N  
ATOM     44  CA  GLU A   5      29.044  45.890  26.035  1.00 14.99           C  
ATOM     45  C   GLU A   5      29.252  47.257  26.706  1.00 13.38           C  
ATOM     46  O   GLU A   5      30.198  47.421  27.470  1.00 14.07           O  
ATOM     47  CB  GLU A   5      27.893  45.138  26.711  1.00 18.01           C  
ATOM     48  CG  GLU A   5      27.950  45.144  28.229  1.00 20.25           C  
ATOM     49  CD  GLU A   5      26.713  44.532  28.861  0.00 20.52           C  
ATOM     50  OE1 GLU A   5      26.632  44.506  30.107  0.00 21.05           O  
ATOM     51  OE2 GLU A   5      25.823  44.077  28.113  0.00 21.05           O  
ATOM     52  N   GLN A   6      28.388  48.226  26.420  1.00 12.02           N  
ATOM     53  CA  GLN A   6      28.498  49.568  27.009  1.00 11.13           C  
ATOM     54  C   GLN A   6      28.520  49.551  28.538  1.00 11.04           C  
ATOM     55  O   GLN A   6      27.633  48.976  29.176  1.00 11.45           O  
ATOM     56  CB  GLN A   6      27.324  50.424  26.539  1.00  9.51           C  
ATOM     57  CG  GLN A   6      27.298  51.829  27.118  1.00 10.71           C  
ATOM     58  CD  GLN A   6      28.496  52.647  26.691  1.00 11.10           C  
ATOM     59  OE1 GLN A   6      29.462  52.779  27.435  1.00 14.05           O  
ATOM     60  NE2 GLN A   6      28.439  53.192  25.482  1.00 16.10           N  
ATOM     61  N   ILE A   7      29.523  50.205  29.121  1.00 10.52           N  
ATOM     62  CA  ILE A   7      29.677  50.257  30.571  1.00 13.24           C  
ATOM     63  C   ILE A   7      28.967  51.457  31.198  1.00 11.89           C  
ATOM     64  O   ILE A   7      28.481  51.380  32.327  1.00 12.56           O  
ATOM     65  CB  ILE A   7      31.191  50.278  30.958  1.00 14.00           C  
ATOM     66  CG1 ILE A   7      31.357  50.228  32.480  1.00 15.92           C  
ATOM     67  CG2 ILE A   7      31.866  51.519  30.386  1.00 15.02           C  
ATOM     68  CD1 ILE A   7      30.873  48.937  33.103  1.00 17.28           C  
ATOM     69  N   LEU A   8      28.886  52.558  30.461  1.00 11.60           N  
ATOM     70  CA  LEU A   8      28.231  53.754  30.979  1.00 12.16           C  
ATOM     71  C   LEU A   8      26.725  53.597  31.058  1.00 13.80           C  
ATOM     72  O   LEU A   8      26.122  52.890  30.250  1.00 13.65           O  
ATOM     73  CB  LEU A   8      28.549  54.967  30.099  1.00 12.98           C  
ATOM     74  CG  LEU A   8      29.996  55.464  30.089  1.00 13.49           C  
ATOM     75  CD1 LEU A   8      30.070  56.774  29.315  1.00 14.40           C  
ATOM     76  CD2 LEU A   8      30.482  55.666  31.514  1.00 15.41           C  
ATOM     77  N   VAL A   9      26.132  54.257  32.047  1.00 13.98           N  
ATOM     78  CA  VAL A   9      24.690  54.254  32.241  1.00 14.28           C  
ATOM     79  C   VAL A   9      24.219  55.617  31.738  1.00 13.62           C  
ATOM     80  O   VAL A   9      24.741  56.651  32.157  1.00 14.72           O  
ATOM     81  CB  VAL A   9      24.315  54.116  33.727  1.00 13.83           C  
ATOM     82  CG1 VAL A   9      22.798  54.123  33.873  1.00 16.33           C  
ATOM     83  CG2 VAL A   9      24.903  52.829  34.302  1.00 17.14           C  
ATOM     84  N   LEU A  10      23.241  55.612  30.838  1.00 13.34           N  
ATOM     85  CA  LEU A  10      22.717  56.842  30.261  1.00 13.65           C  
ATOM     86  C   LEU A  10      21.326  57.182  30.769  1.00 14.46           C  
ATOM     87  O   LEU A  10      20.485  56.299  30.938  1.00 15.03           O  
ATOM     88  CB  LEU A  10      22.646  56.720  28.738  1.00 14.20           C  
ATOM     89  CG  LEU A  10      23.923  56.737  27.901  1.00 15.15           C  
ATOM     90  CD1 LEU A  10      24.891  55.676  28.381  1.00 17.11           C  
ATOM     91  CD2 LEU A  10      23.554  56.513  26.437  1.00 17.18           C  
ATOM     92  N   ASP A  11      21.092  58.472  30.996  1.00 13.45           N  
ATOM     93  CA  ASP A  11      19.791  58.959  31.443  1.00 16.05           C  
ATOM     94  C   ASP A  11      19.503  60.265  30.707  1.00 15.77           C  
ATOM     95  O   ASP A  11      20.123  61.286  30.991  1.00 15.57           O  
ATOM     96  CB  ASP A  11      19.789  59.219  32.954  1.00 18.70           C  
ATOM     97  CG  ASP A  11      18.417  59.613  33.473  1.00 23.51           C  
ATOM     98  OD1 ASP A  11      18.299  59.966  34.669  1.00 23.18           O  
ATOM     99  OD2 ASP A  11      17.452  59.565  32.682  1.00 24.54           O  
ATOM    100  N   PRO A  12      18.550  60.254  29.759  1.00 15.08           N  
ATOM    101  CA  PRO A  12      17.721  59.120  29.333  1.00 15.49           C  
ATOM    102  C   PRO A  12      18.500  58.027  28.611  1.00 14.52           C  
ATOM    103  O   PRO A  12      19.490  58.293  27.936  1.00 15.82           O  
ATOM    104  CB  PRO A  12      16.674  59.779  28.442  1.00 16.13           C  
ATOM    105  CG  PRO A  12      17.445  60.892  27.815  1.00 16.52           C  
ATOM    106  CD  PRO A  12      18.203  61.464  28.992  1.00 17.49           C  
ATOM    107  N   PRO A  13      18.041  56.773  28.732  1.00 15.17           N  
ATOM    108  CA  PRO A  13      18.694  55.627  28.103  1.00 15.37           C  
ATOM    109  C   PRO A  13      18.494  55.416  26.609  1.00 15.99           C  
ATOM    110  O   PRO A  13      19.357  54.834  25.954  1.00 18.45           O  
ATOM    111  CB  PRO A  13      18.151  54.451  28.908  1.00 15.37           C  
ATOM    112  CG  PRO A  13      16.754  54.875  29.173  1.00 15.07           C  
ATOM    113  CD  PRO A  13      16.922  56.331  29.585  1.00 16.48           C  
ATOM    114  N   SER A  14      17.376  55.883  26.060  1.00 15.43           N  
ATOM    115  CA  SER A  14      17.108  55.639  24.651  1.00 16.76           C  
ATOM    116  C   SER A  14      16.632  56.802  23.796  1.00 15.76           C  
ATOM    117  O   SER A  14      16.978  56.883  22.619  1.00 17.20           O  
ATOM    118  CB  SER A  14      16.092  54.503  24.530  1.00 17.93           C  
ATOM    119  OG  SER A  14      16.460  53.415  25.361  1.00 24.84           O  
ATOM    120  N   ASP A  15      15.834  57.696  24.370  1.00 16.07           N  
ATOM    121  CA  ASP A  15      15.315  58.810  23.589  1.00 16.20           C  
ATOM    122  C   ASP A  15      15.580  60.189  24.174  1.00 14.34           C  
ATOM    123  O   ASP A  15      15.425  60.408  25.373  1.00 16.15           O  
ATOM    124  CB  ASP A  15      13.803  58.650  23.392  1.00 20.21           C  
ATOM    125  CG  ASP A  15      13.433  57.328  22.740  1.00 26.10           C  
ATOM    126  OD1 ASP A  15      13.952  57.027  21.647  1.00 29.07           O  
ATOM    127  OD2 ASP A  15      12.611  56.592  23.325  1.00 32.42           O  
ATOM    128  N   LEU A  16      15.996  61.111  23.312  1.00 13.05           N  
ATOM    129  CA  LEU A  16      16.231  62.492  23.718  1.00 12.48           C  
ATOM    130  C   LEU A  16      15.046  63.286  23.176  1.00 12.33           C  
ATOM    131  O   LEU A  16      14.896  63.423  21.961  1.00 15.59           O  
ATOM    132  CB  LEU A  16      17.524  63.037  23.103  1.00 14.13           C  
ATOM    133  CG  LEU A  16      18.862  62.502  23.613  1.00 16.49           C  
ATOM    134  CD1 LEU A  16      19.983  63.134  22.792  1.00 19.52           C  
ATOM    135  CD2 LEU A  16      19.036  62.823  25.088  1.00 17.28           C  
ATOM    136  N   LYS A  17      14.218  63.819  24.069  1.00 12.10           N  
ATOM    137  CA  LYS A  17      13.044  64.573  23.648  1.00 12.64           C  
ATOM    138  C   LYS A  17      13.243  66.083  23.696  1.00 11.74           C  
ATOM    139  O   LYS A  17      13.723  66.623  24.693  1.00 14.35           O  
ATOM    140  CB  LYS A  17      11.843  64.211  24.527  1.00 16.80           C  
ATOM    141  CG  LYS A  17      11.530  62.724  24.620  1.00 23.38           C  
ATOM    142  CD  LYS A  17      11.016  62.156  23.308  1.00 29.95           C  
ATOM    143  CE  LYS A  17      10.587  60.707  23.478  1.00 32.74           C  
ATOM    144  NZ  LYS A  17      10.052  60.115  22.219  1.00 37.21           N  
ATOM    145  N   PHE A  18      12.870  66.749  22.611  1.00 11.71           N  
ATOM    146  CA  PHE A  18      12.962  68.203  22.522  1.00 12.38           C  
ATOM    147  C   PHE A  18      11.548  68.734  22.335  1.00 11.14           C  
ATOM    148  O   PHE A  18      10.880  68.398  21.359  1.00 13.68           O  
ATOM    149  CB  PHE A  18      13.834  68.627  21.340  1.00 11.88           C  
ATOM    150  CG  PHE A  18      15.240  68.106  21.406  1.00 11.67           C  
ATOM    151  CD1 PHE A  18      15.534  66.815  20.988  1.00 11.83           C  
ATOM    152  CD2 PHE A  18      16.269  68.902  21.907  1.00 13.46           C  
ATOM    153  CE1 PHE A  18      16.833  66.319  21.066  1.00 11.84           C  
ATOM    154  CE2 PHE A  18      17.575  68.411  21.988  1.00 11.11           C  
ATOM    155  CZ  PHE A  18      17.853  67.121  21.567  1.00 12.83           C  
ATOM    156  N   LYS A  19      11.099  69.551  23.285  1.00 13.53           N  
ATOM    157  CA  LYS A  19       9.761  70.132  23.247  1.00 15.82           C  
ATOM    158  C   LYS A  19       9.756  71.516  22.612  1.00 15.29           C  
ATOM    159  O   LYS A  19      10.555  72.379  22.979  1.00 17.04           O  
ATOM    160  CB  LYS A  19       9.203  70.227  24.670  1.00 19.16           C  
ATOM    161  CG  LYS A  19       7.849  70.914  24.778  1.00 20.51           C  
ATOM    162  CD  LYS A  19       6.742  70.080  24.158  1.00 22.25           C  
ATOM    163  CE  LYS A  19       5.376  70.676  24.468  1.00 23.04           C  
ATOM    164  NZ  LYS A  19       4.268  69.760  24.061  1.00 26.02           N  
ATOM    165  N   GLY A  20       8.841  71.725  21.668  1.00 13.99           N  
ATOM    166  CA  GLY A  20       8.740  73.007  20.994  1.00 15.16           C  
ATOM    167  C   GLY A  20       8.080  74.078  21.842  1.00 16.27           C  
ATOM    168  O   GLY A  20       7.647  73.803  22.965  1.00 16.55           O  
ATOM    169  N   PRO A  21       7.956  75.310  21.320  1.00 16.71           N  
ATOM    170  CA  PRO A  21       8.384  75.759  19.991  1.00 16.50           C  
ATOM    171  C   PRO A  21       9.892  75.766  19.773  1.00 15.82           C  
ATOM    172  O   PRO A  21      10.672  75.845  20.722  1.00 16.26           O  
ATOM    173  CB  PRO A  21       7.778  77.154  19.892  1.00 17.30           C  
ATOM    174  CG  PRO A  21       7.852  77.631  21.293  1.00 17.29           C  
ATOM    175  CD  PRO A  21       7.381  76.432  22.082  1.00 18.24           C  
ATOM    176  N   PHE A  22      10.289  75.706  18.507  1.00 15.31           N  
ATOM    177  CA  PHE A  22      11.699  75.681  18.145  1.00 16.64           C  
ATOM    178  C   PHE A  22      12.159  76.995  17.527  1.00 16.46           C  
ATOM    179  O   PHE A  22      13.011  77.018  16.640  1.00 16.27           O  
ATOM    180  CB  PHE A  22      11.929  74.504  17.196  1.00 14.93           C  
ATOM    181  CG  PHE A  22      11.485  73.193  17.774  1.00 15.93           C  
ATOM    182  CD1 PHE A  22      12.247  72.559  18.750  1.00 16.01           C  
ATOM    183  CD2 PHE A  22      10.267  72.633  17.405  1.00 16.53           C  
ATOM    184  CE1 PHE A  22      11.797  71.384  19.353  1.00 15.88           C  
ATOM    185  CE2 PHE A  22       9.810  71.463  18.004  1.00 17.18           C  
ATOM    186  CZ  PHE A  22      10.578  70.839  18.979  1.00 16.97           C  
ATOM    187  N   THR A  23      11.588  78.091  18.015  1.00 18.22           N  
ATOM    188  CA  THR A  23      11.931  79.419  17.524  1.00 20.18           C  
ATOM    189  C   THR A  23      13.259  79.857  18.128  1.00 18.91           C  
ATOM    190  O   THR A  23      13.936  80.741  17.606  1.00 22.88           O  
ATOM    191  CB  THR A  23      10.816  80.426  17.867  1.00 23.07           C  
ATOM    192  OG1 THR A  23      10.526  80.373  19.269  1.00 25.23           O  
ATOM    193  CG2 THR A  23       9.555  80.085  17.096  1.00 25.64           C  
ATOM    194  N   ASP A  24      13.625  79.232  19.240  1.00 17.14           N  
ATOM    195  CA  ASP A  24      14.893  79.513  19.892  1.00 16.45           C  
ATOM    196  C   ASP A  24      15.531  78.166  20.197  1.00 14.90           C  
ATOM    197  O   ASP A  24      14.923  77.122  19.952  1.00 13.16           O  
ATOM    198  CB  ASP A  24      14.693  80.298  21.188  1.00 20.11           C  
ATOM    199  CG  ASP A  24      15.995  80.517  21.940  1.00 23.92           C  
ATOM    200  OD1 ASP A  24      17.020  80.843  21.293  1.00 23.97           O  
ATOM    201  OD2 ASP A  24      15.998  80.367  23.180  0.00 23.06           O  
ATOM    202  N   VAL A  25      16.756  78.194  20.707  1.00 14.11           N  
ATOM    203  CA  VAL A  25      17.473  76.970  21.054  1.00 12.07           C  
ATOM    204  C   VAL A  25      16.730  76.184  22.133  1.00 14.00           C  
ATOM    205  O   VAL A  25      16.309  76.746  23.145  1.00 13.50           O  
ATOM    206  CB  VAL A  25      18.900  77.293  21.565  1.00 11.43           C  
ATOM    207  CG1 VAL A  25      19.553  76.034  22.136  1.00 12.58           C  
ATOM    208  CG2 VAL A  25      19.736  77.855  20.424  1.00 13.71           C  
ATOM    209  N   VAL A  26      16.559  74.884  21.904  1.00 10.98           N  
ATOM    210  CA  VAL A  26      15.894  74.010  22.869  1.00 12.79           C  
ATOM    211  C   VAL A  26      16.944  73.020  23.360  1.00 11.26           C  
ATOM    212  O   VAL A  26      17.572  72.337  22.557  1.00 12.10           O  
ATOM    213  CB  VAL A  26      14.731  73.228  22.224  1.00 12.96           C  
ATOM    214  CG1 VAL A  26      14.164  72.229  23.227  1.00 13.05           C  
ATOM    215  CG2 VAL A  26      13.641  74.184  21.776  1.00 16.17           C  
ATOM    216  N   THR A  27      17.141  72.949  24.675  1.00 11.99           N  
ATOM    217  CA  THR A  27      18.149  72.058  25.236  1.00 12.41           C  
ATOM    218  C   THR A  27      17.581  70.915  26.069  1.00 14.03           C  
ATOM    219  O   THR A  27      16.587  71.073  26.776  1.00 14.68           O  
ATOM    220  CB  THR A  27      19.145  72.830  26.145  1.00 13.85           C  
ATOM    221  OG1 THR A  27      19.677  73.958  25.439  1.00 15.59           O  
ATOM    222  CG2 THR A  27      20.300  71.929  26.560  1.00 15.74           C  
ATOM    223  N   THR A  28      18.219  69.759  25.974  1.00 12.62           N  
ATOM    224  CA  THR A  28      17.811  68.608  26.764  1.00 14.90           C  
ATOM    225  C   THR A  28      19.111  68.010  27.291  1.00 15.88           C  
ATOM    226  O   THR A  28      20.135  68.051  26.612  1.00 18.49           O  
ATOM    227  CB  THR A  28      17.023  67.575  25.927  1.00 17.98           C  
ATOM    228  OG1 THR A  28      16.390  66.641  26.814  1.00 24.02           O  
ATOM    229  CG2 THR A  28      17.932  66.831  24.980  1.00 21.36           C  
ATOM    230  N   ASN A  29      19.086  67.478  28.506  1.00 14.21           N  
ATOM    231  CA  ASN A  29      20.305  66.928  29.080  1.00 15.34           C  
ATOM    232  C   ASN A  29      20.408  65.426  28.941  1.00 15.27           C  
ATOM    233  O   ASN A  29      19.405  64.723  28.831  1.00 16.00           O  
ATOM    234  CB  ASN A  29      20.410  67.285  30.564  1.00 19.12           C  
ATOM    235  CG  ASN A  29      20.381  68.775  30.806  1.00 22.33           C  
ATOM    236  OD1 ASN A  29      20.974  69.547  30.053  1.00 25.05           O  
ATOM    237  ND2 ASN A  29      19.695  69.190  31.866  1.00 25.82           N  
ATOM    238  N   LEU A  30      21.647  64.955  28.950  1.00 14.50           N  
ATOM    239  CA  LEU A  30      21.956  63.535  28.875  1.00 14.73           C  
ATOM    240  C   LEU A  30      22.997  63.287  29.959  1.00 15.08           C  
ATOM    241  O   LEU A  30      24.110  63.811  29.881  1.00 14.89           O  
ATOM    242  CB  LEU A  30      22.544  63.179  27.510  1.00 14.92           C  
ATOM    243  CG  LEU A  30      23.124  61.764  27.400  1.00 15.05           C  
ATOM    244  CD1 LEU A  30      22.058  60.737  27.769  1.00 15.46           C  
ATOM    245  CD2 LEU A  30      23.624  61.524  25.986  1.00 17.40           C  
ATOM    246  N   LYS A  31      22.640  62.503  30.968  1.00 13.46           N  
ATOM    247  CA  LYS A  31      23.578  62.205  32.043  1.00 14.49           C  
ATOM    248  C   LYS A  31      24.292  60.884  31.784  1.00 13.19           C  
ATOM    249  O   LYS A  31      23.666  59.886  31.422  1.00 13.57           O  
ATOM    250  CB  LYS A  31      22.849  62.164  33.385  1.00 16.33           C  
ATOM    251  CG  LYS A  31      22.334  63.528  33.824  1.00 22.73           C  
ATOM    252  CD  LYS A  31      21.510  63.433  35.096  1.00 26.90           C  
ATOM    253  CE  LYS A  31      21.090  64.814  35.582  1.00 30.14           C  
ATOM    254  NZ  LYS A  31      20.285  65.543  34.563  1.00 33.55           N  
ATOM    255  N   LEU A  32      25.611  60.894  31.955  1.00 13.76           N  
ATOM    256  CA  LEU A  32      26.426  59.699  31.751  1.00 12.94           C  
ATOM    257  C   LEU A  32      27.065  59.325  33.079  1.00 13.51           C  
ATOM    258  O   LEU A  32      27.783  60.127  33.672  1.00 16.84           O  
ATOM    259  CB  LEU A  32      27.521  59.969  30.722  1.00 10.55           C  
ATOM    260  CG  LEU A  32      27.073  60.483  29.353  1.00 12.57           C  
ATOM    261  CD1 LEU A  32      28.288  60.730  28.481  1.00 13.51           C  
ATOM    262  CD2 LEU A  32      26.130  59.470  28.708  1.00 12.18           C  
ATOM    263  N   GLN A  33      26.808  58.105  33.534  1.00 14.13           N  
ATOM    264  CA  GLN A  33      27.346  57.635  34.804  1.00 15.69           C  
ATOM    265  C   GLN A  33      28.266  56.440  34.583  1.00 14.72           C  
ATOM    266  O   GLN A  33      27.962  55.557  33.784  1.00 15.61           O  
ATOM    267  CB  GLN A  33      26.185  57.253  35.724  1.00 17.63           C  
ATOM    268  CG  GLN A  33      26.514  57.148  37.213  1.00 18.60           C  
ATOM    269  CD  GLN A  33      27.210  55.853  37.594  1.00 22.56           C  
ATOM    270  OE1 GLN A  33      26.833  54.770  37.138  1.00 22.42           O  
ATOM    271  NE2 GLN A  33      28.215  55.957  38.456  1.00 21.62           N  
ATOM    272  N   ASN A  34      29.393  56.420  35.295  1.00 15.39           N  
ATOM    273  CA  ASN A  34      30.365  55.332  35.186  1.00 15.81           C  
ATOM    274  C   ASN A  34      30.363  54.493  36.463  1.00 17.74           C  
ATOM    275  O   ASN A  34      30.942  54.887  37.472  1.00 19.58           O  
ATOM    276  CB  ASN A  34      31.761  55.914  34.939  1.00 14.97           C  
ATOM    277  CG  ASN A  34      32.847  54.848  34.885  1.00 15.97           C  
ATOM    278  OD1 ASN A  34      32.564  53.653  34.811  1.00 15.30           O  
ATOM    279  ND2 ASN A  34      34.101  55.288  34.908  1.00 16.25           N  
ATOM    280  N   PRO A  35      29.711  53.317  36.427  1.00 16.96           N  
ATOM    281  CA  PRO A  35      29.631  52.426  37.589  1.00 19.33           C  
ATOM    282  C   PRO A  35      30.828  51.500  37.779  1.00 20.31           C  
ATOM    283  O   PRO A  35      30.888  50.759  38.761  1.00 23.65           O  
ATOM    284  CB  PRO A  35      28.360  51.642  37.317  1.00 18.36           C  
ATOM    285  CG  PRO A  35      28.453  51.426  35.843  1.00 18.43           C  
ATOM    286  CD  PRO A  35      28.872  52.805  35.327  1.00 16.03           C  
ATOM    287  N   SER A  36      31.776  51.534  36.852  1.00 20.25           N  
ATOM    288  CA  SER A  36      32.938  50.659  36.956  1.00 21.09           C  
ATOM    289  C   SER A  36      34.023  51.244  37.847  1.00 21.96           C  
ATOM    290  O   SER A  36      33.898  52.360  38.350  1.00 22.13           O  
ATOM    291  CB  SER A  36      33.527  50.388  35.572  1.00 20.74           C  
ATOM    292  OG  SER A  36      34.278  51.502  35.122  1.00 18.43           O  
ATOM    293  N   ASP A  37      35.091  50.478  38.038  1.00 23.36           N  
ATOM    294  CA  ASP A  37      36.208  50.936  38.848  1.00 24.41           C  
ATOM    295  C   ASP A  37      37.354  51.381  37.946  1.00 24.43           C  
ATOM    296  O   ASP A  37      38.485  51.548  38.402  1.00 24.86           O  
ATOM    297  CB  ASP A  37      36.682  49.823  39.790  1.00 26.51           C  
ATOM    298  CG  ASP A  37      35.664  49.499  40.864  0.00 26.80           C  
ATOM    299  OD1 ASP A  37      35.310  50.409  41.643  0.00 27.42           O  
ATOM    300  OD2 ASP A  37      35.221  48.333  40.932  0.00 27.42           O  
ATOM    301  N   ARG A  38      37.051  51.574  36.663  1.00 23.45           N  
ATOM    302  CA  ARG A  38      38.042  52.007  35.678  1.00 22.45           C  
ATOM    303  C   ARG A  38      37.636  53.345  35.061  1.00 20.58           C  
ATOM    304  O   ARG A  38      36.457  53.684  35.026  1.00 19.79           O  
ATOM    305  CB  ARG A  38      38.164  50.983  34.546  1.00 24.57           C  
ATOM    306  CG  ARG A  38      38.609  49.590  34.959  1.00 27.64           C  
ATOM    307  CD  ARG A  38      38.800  48.719  33.729  1.00 28.77           C  
ATOM    308  NE  ARG A  38      39.808  49.277  32.829  1.00 30.06           N  
ATOM    309  CZ  ARG A  38      40.134  48.757  31.649  1.00 30.83           C  
ATOM    310  NH1 ARG A  38      39.532  47.656  31.213  1.00 29.94           N  
ATOM    311  NH2 ARG A  38      41.062  49.340  30.902  1.00 31.21           N  
ATOM    312  N   LYS A  39      38.614  54.102  34.575  1.00 18.65           N  
ATOM    313  CA  LYS A  39      38.318  55.378  33.934  1.00 16.79           C  
ATOM    314  C   LYS A  39      37.770  55.076  32.548  1.00 15.13           C  
ATOM    315  O   LYS A  39      38.256  54.172  31.868  1.00 17.32           O  
ATOM    316  CB  LYS A  39      39.576  56.234  33.809  1.00 19.36           C  
ATOM    317  CG  LYS A  39      39.998  56.906  35.100  1.00 23.03           C  
ATOM    318  CD  LYS A  39      41.224  57.778  34.890  1.00 26.22           C  
ATOM    319  CE  LYS A  39      41.548  58.564  36.150  1.00 29.38           C  
ATOM    320  NZ  LYS A  39      41.597  57.678  37.344  1.00 30.85           N  
ATOM    321  N   VAL A  40      36.762  55.834  32.136  1.00 12.92           N  
ATOM    322  CA  VAL A  40      36.140  55.634  30.834  1.00 12.87           C  
ATOM    323  C   VAL A  40      36.103  56.923  30.034  1.00 13.16           C  
ATOM    324  O   VAL A  40      35.616  57.942  30.521  1.00 14.83           O  
ATOM    325  CB  VAL A  40      34.689  55.116  30.993  1.00 13.41           C  
ATOM    326  CG1 VAL A  40      34.006  55.050  29.630  1.00 12.13           C  
ATOM    327  CG2 VAL A  40      34.699  53.745  31.649  1.00 14.10           C  
ATOM    328  N   CYS A  41      36.617  56.875  28.807  1.00 13.26           N  
ATOM    329  CA  CYS A  41      36.616  58.043  27.928  1.00 13.62           C  
ATOM    330  C   CYS A  41      35.388  57.996  27.024  1.00 12.92           C  
ATOM    331  O   CYS A  41      34.940  56.915  26.633  1.00 13.14           O  
ATOM    332  CB  CYS A  41      37.874  58.061  27.062  1.00 14.68           C  
ATOM    333  SG  CYS A  41      39.413  58.230  27.993  1.00 19.97           S  
ATOM    334  N   PHE A  42      34.845  59.164  26.684  1.00 10.50           N  
ATOM    335  CA  PHE A  42      33.659  59.213  25.826  1.00 10.08           C  
ATOM    336  C   PHE A  42      33.713  60.315  24.777  1.00  9.89           C  
ATOM    337  O   PHE A  42      34.447  61.291  24.909  1.00 11.67           O  
ATOM    338  CB  PHE A  42      32.393  59.405  26.680  1.00 10.01           C  
ATOM    339  CG  PHE A  42      32.266  60.783  27.290  1.00  9.27           C  
ATOM    340  CD1 PHE A  42      31.704  61.833  26.570  1.00 12.29           C  
ATOM    341  CD2 PHE A  42      32.737  61.032  28.578  1.00 10.90           C  
ATOM    342  CE1 PHE A  42      31.616  63.117  27.121  1.00 13.52           C  
ATOM    343  CE2 PHE A  42      32.654  62.309  29.136  1.00 13.69           C  
ATOM    344  CZ  PHE A  42      32.093  63.351  28.405  1.00 13.48           C  
ATOM    345  N   LYS A  43      32.939  60.124  23.718  1.00  9.84           N  
ATOM    346  CA  LYS A  43      32.810  61.096  22.647  1.00 12.17           C  
ATOM    347  C   LYS A  43      31.348  61.047  22.244  1.00 13.82           C  
ATOM    348  O   LYS A  43      30.766  59.969  22.151  1.00 12.09           O  
ATOM    349  CB  LYS A  43      33.703  60.743  21.454  1.00 14.49           C  
ATOM    350  CG  LYS A  43      35.183  61.057  21.691  1.00 16.15           C  
ATOM    351  CD  LYS A  43      36.034  60.775  20.462  1.00 21.53           C  
ATOM    352  CE  LYS A  43      37.487  61.170  20.712  1.00 23.08           C  
ATOM    353  NZ  LYS A  43      38.367  60.951  19.527  1.00 25.41           N  
ATOM    354  N   VAL A  44      30.746  62.214  22.046  1.00 11.07           N  
ATOM    355  CA  VAL A  44      29.351  62.276  21.645  1.00 12.05           C  
ATOM    356  C   VAL A  44      29.299  62.701  20.185  1.00 13.50           C  
ATOM    357  O   VAL A  44      29.925  63.691  19.782  1.00 15.03           O  
ATOM    358  CB  VAL A  44      28.552  63.272  22.504  1.00 12.22           C  
ATOM    359  CG1 VAL A  44      27.074  63.229  22.107  1.00 12.82           C  
ATOM    360  CG2 VAL A  44      28.712  62.929  23.982  1.00 13.35           C  
ATOM    361  N   LYS A  45      28.567  61.935  19.390  1.00 12.59           N  
ATOM    362  CA  LYS A  45      28.435  62.214  17.972  1.00 14.29           C  
ATOM    363  C   LYS A  45      26.964  62.247  17.580  1.00 14.38           C  
ATOM    364  O   LYS A  45      26.108  61.764  18.312  1.00 12.20           O  
ATOM    365  CB  LYS A  45      29.185  61.149  17.167  1.00 16.58           C  
ATOM    366  CG  LYS A  45      30.656  61.058  17.557  1.00 20.74           C  
ATOM    367  CD  LYS A  45      31.437  60.111  16.674  1.00 24.60           C  
ATOM    368  CE  LYS A  45      32.896  60.071  17.095  1.00 27.61           C  
ATOM    369  NZ  LYS A  45      33.516  61.428  17.041  1.00 29.83           N  
ATOM    370  N   THR A  46      26.683  62.839  16.424  0.50 16.66           N  
ATOM    372  CA  THR A  46      25.313  62.967  15.933  0.50 17.18           C  
ATOM    374  C   THR A  46      25.253  62.826  14.414  0.50 17.04           C  
ATOM    376  O   THR A  46      26.266  62.959  13.729  0.50 16.93           O  
ATOM    378  CB  THR A  46      24.728  64.350  16.303  0.50 19.34           C  
ATOM    380  OG1 THR A  46      24.819  64.551  17.718  0.50 21.46           O  
ATOM    382  CG2 THR A  46      23.277  64.450  15.868  0.50 20.99           C  
ATOM    384  N   THR A  47      24.059  62.559  13.892  1.00 15.39           N  
ATOM    385  CA  THR A  47      23.879  62.431  12.454  1.00 14.76           C  
ATOM    386  C   THR A  47      23.601  63.797  11.816  1.00 14.51           C  
ATOM    387  O   THR A  47      23.479  63.898  10.598  1.00 13.95           O  
ATOM    388  CB  THR A  47      22.710  61.485  12.128  1.00 14.17           C  
ATOM    389  OG1 THR A  47      21.512  61.989  12.729  1.00 13.07           O  
ATOM    390  CG2 THR A  47      22.989  60.083  12.668  1.00 13.73           C  
ATOM    391  N   ALA A  48      23.505  64.847  12.632  1.00 12.72           N  
ATOM    392  CA  ALA A  48      23.236  66.190  12.112  1.00 13.88           C  
ATOM    393  C   ALA A  48      23.933  67.253  12.964  1.00 14.44           C  
ATOM    394  O   ALA A  48      23.281  68.037  13.651  1.00 13.43           O  
ATOM    395  CB  ALA A  48      21.726  66.443  12.080  1.00 13.96           C  
ATOM    396  N   PRO A  49      25.272  67.298  12.911  1.00 14.92           N  
ATOM    397  CA  PRO A  49      26.093  68.245  13.672  1.00 16.82           C  
ATOM    398  C   PRO A  49      25.721  69.722  13.559  1.00 17.74           C  
ATOM    399  O   PRO A  49      25.855  70.470  14.529  1.00 19.09           O  
ATOM    400  CB  PRO A  49      27.507  67.970  13.158  1.00 19.16           C  
ATOM    401  CG  PRO A  49      27.445  66.547  12.737  1.00 19.35           C  
ATOM    402  CD  PRO A  49      26.121  66.459  12.047  1.00 17.01           C  
ATOM    403  N   ARG A  50      25.264  70.143  12.383  1.00 17.75           N  
ATOM    404  CA  ARG A  50      24.901  71.541  12.174  1.00 18.10           C  
ATOM    405  C   ARG A  50      23.643  71.935  12.941  1.00 17.15           C  
ATOM    406  O   ARG A  50      23.415  73.117  13.211  1.00 18.92           O  
ATOM    407  CB  ARG A  50      24.692  71.820  10.681  1.00 20.59           C  
ATOM    408  CG  ARG A  50      24.577  73.302  10.349  1.00 23.06           C  
ATOM    409  CD  ARG A  50      24.256  73.567   8.879  1.00 26.33           C  
ATOM    410  NE  ARG A  50      25.234  72.987   7.962  1.00 27.61           N  
ATOM    411  CZ  ARG A  50      25.149  71.760   7.458  1.00 28.15           C  
ATOM    412  NH1 ARG A  50      24.128  70.979   7.779  1.00 29.39           N  
ATOM    413  NH2 ARG A  50      26.087  71.314   6.633  1.00 27.16           N  
ATOM    414  N   ARG A  51      22.828  70.952  13.309  1.00 15.41           N  
ATOM    415  CA  ARG A  51      21.591  71.258  14.018  1.00 14.17           C  
ATOM    416  C   ARG A  51      21.696  71.130  15.525  1.00 14.80           C  
ATOM    417  O   ARG A  51      20.770  71.500  16.258  1.00 14.19           O  
ATOM    418  CB  ARG A  51      20.473  70.374  13.483  1.00 16.04           C  
ATOM    419  CG  ARG A  51      20.317  70.520  11.989  1.00 18.70           C  
ATOM    420  CD  ARG A  51      19.059  69.883  11.487  1.00 21.10           C  
ATOM    421  NE  ARG A  51      17.871  70.406  12.154  1.00 19.43           N  
ATOM    422  CZ  ARG A  51      16.636  70.171  11.727  1.00 19.88           C  
ATOM    423  NH1 ARG A  51      16.452  69.432  10.641  1.00 20.22           N  
ATOM    424  NH2 ARG A  51      15.592  70.658  12.383  1.00 18.95           N  
ATOM    425  N   TYR A  52      22.831  70.623  15.984  1.00 15.24           N  
ATOM    426  CA  TYR A  52      23.052  70.447  17.408  1.00 16.74           C  
ATOM    427  C   TYR A  52      24.403  70.923  17.898  1.00 19.70           C  
ATOM    428  O   TYR A  52      25.398  70.903  17.173  1.00 22.58           O  
ATOM    429  CB  TYR A  52      22.963  68.968  17.785  1.00 13.76           C  
ATOM    430  CG  TYR A  52      21.647  68.311  17.486  1.00 13.11           C  
ATOM    431  CD1 TYR A  52      20.585  68.392  18.390  1.00 12.83           C  
ATOM    432  CD2 TYR A  52      21.453  67.614  16.290  1.00 14.36           C  
ATOM    433  CE1 TYR A  52      19.371  67.798  18.113  1.00 12.04           C  
ATOM    434  CE2 TYR A  52      20.232  67.015  16.003  1.00 13.57           C  
ATOM    435  CZ  TYR A  52      19.198  67.113  16.920  1.00 12.77           C  
ATOM    436  OH  TYR A  52      17.987  66.533  16.645  1.00 10.48           O  
ATOM    437  N   CYS A  53      24.428  71.357  19.150  0.50 19.72           N  
ATOM    439  CA  CYS A  53      25.662  71.770  19.791  0.50 19.74           C  
ATOM    441  C   CYS A  53      25.667  70.920  21.048  0.50 18.34           C  
ATOM    443  O   CYS A  53      24.669  70.868  21.769  0.50 18.35           O  
ATOM    445  CB  CYS A  53      25.649  73.250  20.161  0.50 20.58           C  
ATOM    447  SG  CYS A  53      27.254  73.795  20.790  0.50 26.31           S  
ATOM    449  N   VAL A  54      26.783  70.246  21.299  1.00 15.35           N  
ATOM    450  CA  VAL A  54      26.891  69.366  22.451  1.00 14.87           C  
ATOM    451  C   VAL A  54      28.051  69.765  23.343  1.00 15.22           C  
ATOM    452  O   VAL A  54      29.165  69.967  22.861  1.00 15.02           O  
ATOM    453  CB  VAL A  54      27.095  67.902  21.996  1.00 13.57           C  
ATOM    454  CG1 VAL A  54      27.185  66.992  23.199  1.00 14.94           C  
ATOM    455  CG2 VAL A  54      25.948  67.475  21.097  1.00 15.82           C  
ATOM    456  N   ARG A  55      27.786  69.869  24.644  1.00 14.19           N  
ATOM    457  CA  ARG A  55      28.821  70.246  25.604  1.00 15.41           C  
ATOM    458  C   ARG A  55      28.651  69.561  26.951  1.00 15.39           C  
ATOM    459  O   ARG A  55      27.596  69.667  27.580  1.00 16.07           O  
ATOM    460  CB  ARG A  55      28.810  71.759  25.833  1.00 16.81           C  
ATOM    461  CG  ARG A  55      29.317  72.587  24.670  1.00 22.42           C  
ATOM    462  CD  ARG A  55      30.820  72.415  24.461  1.00 25.91           C  
ATOM    463  NE  ARG A  55      31.348  73.402  23.524  1.00 29.46           N  
ATOM    464  CZ  ARG A  55      31.571  74.680  23.823  1.00 29.05           C  
ATOM    465  NH1 ARG A  55      32.047  75.502  22.899  1.00 31.26           N  
ATOM    466  NH2 ARG A  55      31.340  75.132  25.047  1.00 29.49           N  
ATOM    467  N   PRO A  56      29.670  68.809  27.393  1.00 15.75           N  
ATOM    468  CA  PRO A  56      30.927  68.596  26.670  1.00 16.63           C  
ATOM    469  C   PRO A  56      30.685  67.511  25.636  1.00 17.62           C  
ATOM    470  O   PRO A  56      29.813  66.667  25.833  1.00 20.11           O  
ATOM    471  CB  PRO A  56      31.877  68.132  27.766  1.00 17.25           C  
ATOM    472  CG  PRO A  56      30.978  67.366  28.670  1.00 17.65           C  
ATOM    473  CD  PRO A  56      29.755  68.254  28.756  1.00 16.54           C  
ATOM    474  N   ASN A  57      31.442  67.525  24.545  1.00 17.43           N  
ATOM    475  CA  ASN A  57      31.260  66.508  23.510  1.00 18.66           C  
ATOM    476  C   ASN A  57      32.244  65.355  23.660  1.00 16.93           C  
ATOM    477  O   ASN A  57      32.211  64.397  22.889  1.00 17.27           O  
ATOM    478  CB  ASN A  57      31.395  67.120  22.116  1.00 23.46           C  
ATOM    479  CG  ASN A  57      32.749  67.759  21.884  1.00 25.26           C  
ATOM    480  OD1 ASN A  57      33.782  67.205  22.257  1.00 29.11           O  
ATOM    481  ND2 ASN A  57      32.751  68.928  21.246  1.00 29.78           N  
ATOM    482  N   SER A  58      33.119  65.450  24.652  1.00 15.38           N  
ATOM    483  CA  SER A  58      34.107  64.405  24.912  1.00 14.60           C  
ATOM    484  C   SER A  58      34.705  64.634  26.286  1.00 15.14           C  
ATOM    485  O   SER A  58      34.650  65.745  26.828  1.00 15.29           O  
ATOM    486  CB  SER A  58      35.224  64.433  23.863  1.00 17.36           C  
ATOM    487  OG  SER A  58      36.076  65.551  24.066  1.00 20.47           O  
ATOM    488  N   GLY A  59      35.283  63.583  26.850  1.00 13.19           N  
ATOM    489  CA  GLY A  59      35.889  63.706  28.158  1.00 15.62           C  
ATOM    490  C   GLY A  59      36.184  62.357  28.772  1.00 15.81           C  
ATOM    491  O   GLY A  59      36.088  61.323  28.110  1.00 15.39           O  
ATOM    492  N   VAL A  60      36.553  62.377  30.045  1.00 16.43           N  
ATOM    493  CA  VAL A  60      36.857  61.162  30.782  1.00 17.61           C  
ATOM    494  C   VAL A  60      36.010  61.181  32.039  1.00 17.32           C  
ATOM    495  O   VAL A  60      35.880  62.214  32.696  1.00 19.13           O  
ATOM    496  CB  VAL A  60      38.354  61.091  31.172  1.00 18.73           C  
ATOM    497  CG1 VAL A  60      38.720  62.265  32.064  1.00 24.03           C  
ATOM    498  CG2 VAL A  60      38.646  59.772  31.882  1.00 20.60           C  
ATOM    499  N   ILE A  61      35.414  60.042  32.361  1.00 14.98           N  
ATOM    500  CA  ILE A  61      34.576  59.937  33.538  1.00 16.39           C  
ATOM    501  C   ILE A  61      35.267  58.993  34.512  1.00 17.73           C  
ATOM    502  O   ILE A  61      35.535  57.838  34.180  1.00 15.64           O  
ATOM    503  CB  ILE A  61      33.183  59.387  33.175  1.00 14.29           C  
ATOM    504  CG1 ILE A  61      32.583  60.219  32.038  1.00 14.96           C  
ATOM    505  CG2 ILE A  61      32.264  59.437  34.389  1.00 17.20           C  
ATOM    506  CD1 ILE A  61      31.231  59.724  31.545  1.00 18.91           C  
ATOM    507  N   ASP A  62      35.567  59.495  35.705  1.00 18.97           N  
ATOM    508  CA  ASP A  62      36.236  58.692  36.721  1.00 21.81           C  
ATOM    509  C   ASP A  62      35.295  57.640  37.288  1.00 20.91           C  
ATOM    510  O   ASP A  62      34.075  57.743  37.161  1.00 20.42           O  
ATOM    511  CB  ASP A  62      36.751  59.588  37.855  1.00 24.91           C  
ATOM    512  CG  ASP A  62      37.708  60.658  37.364  1.00 28.21           C  
ATOM    513  OD1 ASP A  62      38.635  60.327  36.592  1.00 31.08           O  
ATOM    514  OD2 ASP A  62      37.542  61.830  37.758  1.00 31.90           O  
ATOM    515  N   PRO A  63      35.853  56.597  37.916  1.00 22.32           N  
ATOM    516  CA  PRO A  63      35.013  55.545  38.490  1.00 22.26           C  
ATOM    517  C   PRO A  63      33.958  56.120  39.437  1.00 23.90           C  
ATOM    518  O   PRO A  63      34.275  56.914  40.323  1.00 23.87           O  
ATOM    519  CB  PRO A  63      36.022  54.666  39.219  1.00 24.69           C  
ATOM    520  CG  PRO A  63      37.254  54.806  38.383  1.00 22.61           C  
ATOM    521  CD  PRO A  63      37.283  56.288  38.096  1.00 22.92           C  
ATOM    522  N   GLY A  64      32.705  55.731  39.230  1.00 24.15           N  
ATOM    523  CA  GLY A  64      31.626  56.204  40.080  1.00 24.33           C  
ATOM    524  C   GLY A  64      31.142  57.624  39.843  1.00 24.93           C  
ATOM    525  O   GLY A  64      30.195  58.067  40.493  1.00 27.00           O  
ATOM    526  N   SER A  65      31.775  58.348  38.926  1.00 24.18           N  
ATOM    527  CA  SER A  65      31.364  59.722  38.657  1.00 23.30           C  
ATOM    528  C   SER A  65      30.254  59.811  37.622  1.00 22.85           C  
ATOM    529  O   SER A  65      29.941  58.838  36.931  1.00 20.07           O  
ATOM    530  CB  SER A  65      32.555  60.561  38.187  1.00 24.02           C  
ATOM    531  OG  SER A  65      33.527  60.696  39.209  1.00 26.02           O  
ATOM    532  N   ILE A  66      29.666  60.997  37.523  1.00 22.79           N  
ATOM    533  CA  ILE A  66      28.593  61.246  36.575  1.00 23.30           C  
ATOM    534  C   ILE A  66      28.815  62.609  35.924  1.00 23.41           C  
ATOM    535  O   ILE A  66      29.283  63.551  36.570  1.00 23.72           O  
ATOM    536  CB  ILE A  66      27.220  61.214  37.287  1.00 24.66           C  
ATOM    537  CG1 ILE A  66      26.092  61.366  36.267  1.00 26.11           C  
ATOM    538  CG2 ILE A  66      27.146  62.316  38.333  1.00 25.85           C  
ATOM    539  CD1 ILE A  66      24.718  61.077  36.836  1.00 26.94           C  
ATOM    540  N   VAL A  67      28.490  62.707  34.640  0.50 22.67           N  
ATOM    542  CA  VAL A  67      28.655  63.956  33.905  0.50 22.59           C  
ATOM    544  C   VAL A  67      27.383  64.294  33.141  0.50 21.55           C  
ATOM    546  O   VAL A  67      26.715  63.407  32.606  0.50 22.06           O  
ATOM    548  CB  VAL A  67      29.824  63.863  32.899  0.50 23.10           C  
ATOM    550  CG1 VAL A  67      30.010  65.197  32.190  0.50 22.45           C  
ATOM    552  CG2 VAL A  67      31.101  63.461  33.621  0.50 24.20           C  
ATOM    554  N   THR A  68      27.050  65.581  33.095  1.00 20.75           N  
ATOM    555  CA  THR A  68      25.860  66.034  32.393  1.00 17.95           C  
ATOM    556  C   THR A  68      26.259  66.653  31.059  1.00 17.37           C  
ATOM    557  O   THR A  68      27.068  67.584  31.004  1.00 18.14           O  
ATOM    558  CB  THR A  68      25.077  67.086  33.212  1.00 17.96           C  
ATOM    559  OG1 THR A  68      24.577  66.484  34.414  1.00 19.84           O  
ATOM    560  CG2 THR A  68      23.908  67.634  32.397  1.00 18.97           C  
ATOM    561  N   VAL A  69      25.687  66.122  29.985  1.00 14.38           N  
ATOM    562  CA  VAL A  69      25.945  66.609  28.639  1.00 13.97           C  
ATOM    563  C   VAL A  69      24.738  67.427  28.195  1.00 13.34           C  
ATOM    564  O   VAL A  69      23.609  66.942  28.228  1.00 14.63           O  
ATOM    565  CB  VAL A  69      26.138  65.430  27.645  1.00 13.33           C  
ATOM    566  CG1 VAL A  69      26.347  65.955  26.240  1.00 11.54           C  
ATOM    567  CG2 VAL A  69      27.335  64.588  28.063  1.00 14.03           C  
ATOM    568  N   SER A  70      24.975  68.675  27.805  1.00 12.93           N  
ATOM    569  CA  SER A  70      23.901  69.535  27.330  1.00 13.36           C  
ATOM    570  C   SER A  70      23.804  69.373  25.818  1.00 12.44           C  
ATOM    571  O   SER A  70      24.794  69.546  25.108  1.00 12.93           O  
ATOM    572  CB  SER A  70      24.194  71.000  27.669  1.00 12.28           C  
ATOM    573  OG  SER A  70      24.269  71.205  29.066  1.00 16.59           O  
ATOM    574  N   VAL A  71      22.615  69.031  25.329  1.00 11.02           N  
ATOM    575  CA  VAL A  71      22.402  68.848  23.895  1.00 12.44           C  
ATOM    576  C   VAL A  71      21.481  69.976  23.475  1.00 13.60           C  
ATOM    577  O   VAL A  71      20.312  70.006  23.858  1.00 13.76           O  
ATOM    578  CB  VAL A  71      21.725  67.497  23.600  1.00 12.22           C  
ATOM    579  CG1 VAL A  71      21.583  67.300  22.108  1.00 14.13           C  
ATOM    580  CG2 VAL A  71      22.540  66.373  24.224  1.00 14.30           C  
HETATM  581  N   MSE A  72      22.006  70.892  22.670  0.50 14.56           N  
HETATM  583  CA  MSE A  72      21.245  72.049  22.229  0.50 13.92           C  
HETATM  585  C   MSE A  72      20.798  71.987  20.769  0.50 14.14           C  
HETATM  587  O   MSE A  72      21.615  72.018  19.847  0.50 15.57           O  
HETATM  589  CB  MSE A  72      22.083  73.301  22.514  0.50 15.79           C  
HETATM  591  CG  MSE A  72      22.449  73.388  24.001  0.50 14.29           C  
HETATM  593 SE   MSE A  72      23.957  74.480  24.517  0.50 22.15          SE  
HETATM  595  CE  MSE A  72      25.353  73.157  24.284  0.50 19.67           C  
ATOM    597  N   LEU A  73      19.485  71.892  20.575  1.00 12.45           N  
ATOM    598  CA  LEU A  73      18.903  71.829  19.239  1.00 11.78           C  
ATOM    599  C   LEU A  73      18.776  73.254  18.727  1.00 11.04           C  
ATOM    600  O   LEU A  73      18.167  74.099  19.376  1.00 10.23           O  
ATOM    601  CB  LEU A  73      17.516  71.184  19.301  1.00 10.87           C  
ATOM    602  CG  LEU A  73      16.704  71.197  18.005  1.00 10.59           C  
ATOM    603  CD1 LEU A  73      17.439  70.414  16.934  1.00 11.76           C  
ATOM    604  CD2 LEU A  73      15.327  70.600  18.259  1.00 11.67           C  
ATOM    605  N   GLN A  74      19.341  73.520  17.559  1.00 10.64           N  
ATOM    606  CA  GLN A  74      19.286  74.865  17.005  1.00 12.07           C  
ATOM    607  C   GLN A  74      17.895  75.246  16.501  1.00 12.50           C  
ATOM    608  O   GLN A  74      17.121  74.402  16.052  1.00 10.77           O  
ATOM    609  CB  GLN A  74      20.332  75.005  15.899  1.00 13.59           C  
ATOM    610  CG  GLN A  74      21.747  74.792  16.421  1.00 15.81           C  
ATOM    611  CD  GLN A  74      22.043  75.680  17.621  1.00 15.38           C  
ATOM    612  OE1 GLN A  74      22.089  76.901  17.502  1.00 15.64           O  
ATOM    613  NE2 GLN A  74      22.229  75.066  18.785  1.00 15.46           N  
ATOM    614  N   PRO A  75      17.555  76.537  16.576  1.00 13.12           N  
ATOM    615  CA  PRO A  75      16.237  76.971  16.111  1.00 13.15           C  
ATOM    616  C   PRO A  75      16.032  76.644  14.636  1.00 13.90           C  
ATOM    617  O   PRO A  75      16.986  76.602  13.856  1.00 13.01           O  
ATOM    618  CB  PRO A  75      16.253  78.470  16.392  1.00 14.97           C  
ATOM    619  CG  PRO A  75      17.704  78.823  16.242  1.00 15.01           C  
ATOM    620  CD  PRO A  75      18.391  77.687  16.956  1.00 14.62           C  
ATOM    621  N   PHE A  76      14.788  76.387  14.257  1.00 12.40           N  
ATOM    622  CA  PHE A  76      14.487  76.076  12.866  1.00 15.22           C  
ATOM    623  C   PHE A  76      13.011  76.266  12.590  1.00 16.30           C  
ATOM    624  O   PHE A  76      12.185  76.210  13.500  1.00 17.62           O  
ATOM    625  CB  PHE A  76      14.905  74.637  12.537  1.00 14.25           C  
ATOM    626  CG  PHE A  76      14.077  73.591  13.227  1.00 16.35           C  
ATOM    627  CD1 PHE A  76      12.926  73.089  12.628  1.00 17.00           C  
ATOM    628  CD2 PHE A  76      14.443  73.114  14.479  1.00 15.28           C  
ATOM    629  CE1 PHE A  76      12.151  72.125  13.264  1.00 16.86           C  
ATOM    630  CE2 PHE A  76      13.677  72.151  15.128  1.00 15.89           C  
ATOM    631  CZ  PHE A  76      12.528  71.653  14.517  1.00 15.87           C  
ATOM    632  N   ASP A  77      12.686  76.506  11.327  1.00 19.11           N  
ATOM    633  CA  ASP A  77      11.302  76.687  10.930  1.00 20.99           C  
ATOM    634  C   ASP A  77      10.754  75.335  10.507  1.00 19.68           C  
ATOM    635  O   ASP A  77      11.323  74.661   9.651  1.00 20.63           O  
ATOM    636  CB  ASP A  77      11.202  77.683   9.773  1.00 24.65           C  
ATOM    637  CG  ASP A  77      11.571  79.093  10.186  1.00 29.49           C  
ATOM    638  OD1 ASP A  77      11.025  79.577  11.201  1.00 31.74           O  
ATOM    639  OD2 ASP A  77      12.401  79.719   9.493  1.00 31.85           O  
ATOM    640  N   TYR A  78       9.653  74.933  11.122  1.00 20.54           N  
ATOM    641  CA  TYR A  78       9.043  73.653  10.803  1.00 20.11           C  
ATOM    642  C   TYR A  78       8.682  73.533   9.330  1.00 20.48           C  
ATOM    643  O   TYR A  78       8.049  74.419   8.755  1.00 21.44           O  
ATOM    644  CB  TYR A  78       7.791  73.447  11.655  1.00 20.85           C  
ATOM    645  CG  TYR A  78       7.024  72.192  11.317  1.00 20.21           C  
ATOM    646  CD1 TYR A  78       7.617  70.935  11.434  1.00 18.97           C  
ATOM    647  CD2 TYR A  78       5.700  72.257  10.888  1.00 22.04           C  
ATOM    648  CE1 TYR A  78       6.910  69.774  11.134  1.00 19.25           C  
ATOM    649  CE2 TYR A  78       4.982  71.100  10.582  1.00 21.10           C  
ATOM    650  CZ  TYR A  78       5.593  69.865  10.710  1.00 21.11           C  
ATOM    651  OH  TYR A  78       4.890  68.718  10.421  1.00 19.33           O  
ATOM    652  N   ASP A  79       9.102  72.430   8.723  1.00 19.70           N  
ATOM    653  CA  ASP A  79       8.807  72.157   7.325  1.00 21.72           C  
ATOM    654  C   ASP A  79       8.103  70.808   7.240  1.00 19.72           C  
ATOM    655  O   ASP A  79       8.720  69.763   7.432  1.00 18.46           O  
ATOM    656  CB  ASP A  79      10.093  72.129   6.496  1.00 24.60           C  
ATOM    657  CG  ASP A  79       9.874  71.568   5.104  1.00 26.67           C  
ATOM    658  OD1 ASP A  79       8.761  71.739   4.564  1.00 24.49           O  
ATOM    659  OD2 ASP A  79      10.819  70.966   4.549  1.00 31.49           O  
ATOM    660  N   PRO A  80       6.791  70.818   6.960  1.00 21.82           N  
ATOM    661  CA  PRO A  80       6.017  69.575   6.859  1.00 21.42           C  
ATOM    662  C   PRO A  80       6.541  68.602   5.805  1.00 23.01           C  
ATOM    663  O   PRO A  80       6.175  67.427   5.800  1.00 21.23           O  
ATOM    664  CB  PRO A  80       4.605  70.073   6.549  1.00 22.96           C  
ATOM    665  CG  PRO A  80       4.854  71.364   5.823  1.00 24.15           C  
ATOM    666  CD  PRO A  80       5.952  71.985   6.639  1.00 22.67           C  
ATOM    667  N   ASN A  81       7.412  69.086   4.924  1.00 25.35           N  
ATOM    668  CA  ASN A  81       7.967  68.245   3.871  1.00 29.41           C  
ATOM    669  C   ASN A  81       9.281  67.585   4.276  1.00 31.50           C  
ATOM    670  O   ASN A  81       9.844  66.796   3.517  1.00 31.78           O  
ATOM    671  CB  ASN A  81       8.185  69.065   2.595  1.00 30.77           C  
ATOM    672  CG  ASN A  81       6.886  69.566   1.991  1.00 33.27           C  
ATOM    673  OD1 ASN A  81       6.001  68.780   1.652  1.00 34.35           O  
ATOM    674  ND2 ASN A  81       6.766  70.882   1.851  1.00 36.92           N  
ATOM    675  N   GLU A  82       9.765  67.904   5.471  1.00 33.05           N  
ATOM    676  CA  GLU A  82      11.018  67.337   5.953  1.00 35.26           C  
ATOM    677  C   GLU A  82      10.781  66.091   6.797  1.00 35.71           C  
ATOM    678  O   GLU A  82       9.828  66.027   7.570  1.00 36.53           O  
ATOM    679  CB  GLU A  82      11.790  68.377   6.771  1.00 37.20           C  
ATOM    680  CG  GLU A  82      13.123  67.877   7.307  1.00 40.82           C  
ATOM    681  CD  GLU A  82      13.945  68.977   7.950  1.00 44.15           C  
ATOM    682  OE1 GLU A  82      14.273  69.959   7.250  1.00 46.75           O  
ATOM    683  OE2 GLU A  82      14.265  68.859   9.152  1.00 45.64           O  
ATOM    684  N   LYS A  83      11.657  65.105   6.641  1.00 35.09           N  
ATOM    685  CA  LYS A  83      11.552  63.860   7.388  1.00 35.69           C  
ATOM    686  C   LYS A  83      12.865  63.577   8.110  1.00 34.59           C  
ATOM    687  O   LYS A  83      13.640  62.714   7.699  1.00 35.16           O  
ATOM    688  CB  LYS A  83      11.213  62.709   6.437  1.00 37.90           C  
ATOM    689  CG  LYS A  83       9.959  62.961   5.612  1.00 40.26           C  
ATOM    690  CD  LYS A  83       9.609  61.783   4.721  1.00 42.36           C  
ATOM    691  CE  LYS A  83       8.335  62.064   3.936  1.00 43.58           C  
ATOM    692  NZ  LYS A  83       7.905  60.899   3.113  1.00 45.34           N  
ATOM    693  N   SER A  84      13.105  64.311   9.191  1.00 32.86           N  
ATOM    694  CA  SER A  84      14.324  64.150   9.971  1.00 31.75           C  
ATOM    695  C   SER A  84      14.207  63.063  11.033  1.00 29.27           C  
ATOM    696  O   SER A  84      13.257  63.038  11.813  1.00 29.70           O  
ATOM    697  CB  SER A  84      14.694  65.473  10.650  1.00 32.25           C  
ATOM    698  OG  SER A  84      14.905  66.496   9.696  1.00 36.44           O  
ATOM    699  N   LYS A  85      15.189  62.170  11.052  1.00 26.88           N  
ATOM    700  CA  LYS A  85      15.242  61.085  12.023  1.00 23.57           C  
ATOM    701  C   LYS A  85      16.650  61.116  12.598  1.00 19.63           C  
ATOM    702  O   LYS A  85      17.438  60.202  12.382  1.00 20.27           O  
ATOM    703  CB  LYS A  85      14.990  59.734  11.345  1.00 26.28           C  
ATOM    704  CG  LYS A  85      13.588  59.567  10.779  0.00 26.08           C  
ATOM    705  CD  LYS A  85      13.391  58.167  10.219  0.00 26.82           C  
ATOM    706  CE  LYS A  85      11.973  57.967   9.708  0.00 27.07           C  
ATOM    707  NZ  LYS A  85      11.761  56.590   9.183  0.00 27.35           N  
ATOM    708  N   HIS A  86      16.963  62.184  13.324  1.00 14.90           N  
ATOM    709  CA  HIS A  86      18.295  62.343  13.900  1.00 13.71           C  
ATOM    710  C   HIS A  86      18.597  61.341  14.998  1.00 13.59           C  
ATOM    711  O   HIS A  86      17.706  60.930  15.746  1.00 13.05           O  
ATOM    712  CB  HIS A  86      18.464  63.744  14.487  1.00 13.48           C  
ATOM    713  CG  HIS A  86      18.269  64.847  13.500  1.00 16.22           C  
ATOM    714  ND1 HIS A  86      17.860  66.110  13.875  1.00 15.96           N  
ATOM    715  CD2 HIS A  86      18.445  64.893  12.158  1.00 15.92           C  
ATOM    716  CE1 HIS A  86      17.789  66.883  12.807  1.00 17.23           C  
ATOM    717  NE2 HIS A  86      18.141  66.167  11.751  1.00 16.11           N  
ATOM    718  N   LYS A  87      19.869  60.967  15.090  1.00 12.59           N  
ATOM    719  CA  LYS A  87      20.326  60.037  16.111  1.00 15.18           C  
ATOM    720  C   LYS A  87      21.579  60.595  16.778  1.00 14.30           C  
ATOM    721  O   LYS A  87      22.347  61.336  16.164  1.00 13.09           O  
ATOM    722  CB  LYS A  87      20.677  58.679  15.495  1.00 16.29           C  
ATOM    723  CG  LYS A  87      19.629  58.108  14.561  1.00 21.47           C  
ATOM    724  CD  LYS A  87      18.297  57.896  15.252  1.00 25.56           C  
ATOM    725  CE  LYS A  87      17.285  57.292  14.289  1.00 28.44           C  
ATOM    726  NZ  LYS A  87      15.932  57.147  14.899  1.00 29.53           N  
ATOM    727  N   PHE A  88      21.765  60.246  18.044  1.00 13.13           N  
ATOM    728  CA  PHE A  88      22.950  60.648  18.787  1.00 13.68           C  
ATOM    729  C   PHE A  88      23.689  59.375  19.168  1.00 14.15           C  
ATOM    730  O   PHE A  88      23.080  58.318  19.330  1.00 12.58           O  
ATOM    731  CB  PHE A  88      22.586  61.428  20.052  1.00 17.75           C  
ATOM    732  CG  PHE A  88      22.712  62.913  19.896  1.00 20.33           C  
ATOM    733  CD1 PHE A  88      21.861  63.609  19.049  1.00 20.97           C  
ATOM    734  CD2 PHE A  88      23.704  63.613  20.575  1.00 21.69           C  
ATOM    735  CE1 PHE A  88      21.993  64.986  18.876  1.00 20.69           C  
ATOM    736  CE2 PHE A  88      23.847  64.993  20.410  1.00 24.24           C  
ATOM    737  CZ  PHE A  88      22.986  65.678  19.555  1.00 22.32           C  
HETATM  738  N   MSE A  89      25.005  59.470  19.292  1.00 12.88           N  
HETATM  739  CA  MSE A  89      25.797  58.309  19.660  1.00 12.97           C  
HETATM  740  C   MSE A  89      26.761  58.654  20.771  1.00 13.44           C  
HETATM  741  O   MSE A  89      27.390  59.712  20.754  1.00 13.87           O  
HETATM  742  CB  MSE A  89      26.594  57.790  18.458  1.00 16.79           C  
HETATM  743  CG  MSE A  89      27.507  56.618  18.787  1.00 23.87           C  
HETATM  744 SE   MSE A  89      28.589  56.061  17.270  1.00 39.42          SE  
HETATM  745  CE  MSE A  89      30.030  57.312  17.470  1.00 34.51           C  
ATOM    746  N   VAL A  90      26.839  57.779  21.765  1.00  9.36           N  
ATOM    747  CA  VAL A  90      27.790  57.972  22.840  1.00 10.90           C  
ATOM    748  C   VAL A  90      28.783  56.833  22.651  1.00 10.27           C  
ATOM    749  O   VAL A  90      28.453  55.662  22.864  1.00 12.71           O  
ATOM    750  CB  VAL A  90      27.134  57.872  24.229  1.00 12.01           C  
ATOM    751  CG1 VAL A  90      28.195  58.030  25.301  1.00 13.30           C  
ATOM    752  CG2 VAL A  90      26.062  58.956  24.380  1.00 12.19           C  
ATOM    753  N   GLN A  91      29.989  57.177  22.211  1.00  8.61           N  
ATOM    754  CA  GLN A  91      31.027  56.179  21.981  1.00 10.38           C  
ATOM    755  C   GLN A  91      31.992  56.199  23.154  1.00 10.95           C  
ATOM    756  O   GLN A  91      32.469  57.257  23.564  1.00  9.89           O  
ATOM    757  CB  GLN A  91      31.748  56.477  20.666  1.00 13.55           C  
ATOM    758  CG  GLN A  91      32.916  55.565  20.372  1.00 17.98           C  
ATOM    759  CD  GLN A  91      33.308  55.608  18.911  1.00 21.77           C  
ATOM    760  OE1 GLN A  91      32.750  54.882  18.085  1.00 25.15           O  
ATOM    761  NE2 GLN A  91      34.251  56.474  18.580  1.00 21.75           N  
ATOM    762  N   THR A  92      32.279  55.030  23.709  1.00  7.92           N  
ATOM    763  CA  THR A  92      33.148  54.993  24.864  1.00 10.34           C  
ATOM    764  C   THR A  92      34.261  53.970  24.765  1.00  9.98           C  
ATOM    765  O   THR A  92      34.227  53.062  23.931  1.00 10.47           O  
ATOM    766  CB  THR A  92      32.329  54.704  26.127  1.00 10.03           C  
ATOM    767  OG1 THR A  92      31.728  53.404  26.015  1.00 11.43           O  
ATOM    768  CG2 THR A  92      31.223  55.732  26.283  1.00 10.60           C  
ATOM    769  N   ILE A  93      35.258  54.133  25.624  1.00  9.47           N  
ATOM    770  CA  ILE A  93      36.386  53.214  25.651  1.00 10.34           C  
ATOM    771  C   ILE A  93      37.028  53.266  27.028  1.00 11.33           C  
ATOM    772  O   ILE A  93      37.086  54.321  27.661  1.00 12.18           O  
ATOM    773  CB  ILE A  93      37.420  53.586  24.566  1.00 11.92           C  
ATOM    774  CG1 ILE A  93      38.579  52.590  24.573  1.00 12.68           C  
ATOM    775  CG2 ILE A  93      37.933  55.002  24.799  1.00 14.83           C  
ATOM    776  CD1 ILE A  93      39.488  52.711  23.365  1.00 15.53           C  
ATOM    777  N   PHE A  94      37.474  52.114  27.517  1.00 11.65           N  
ATOM    778  CA  PHE A  94      38.129  52.068  28.815  1.00 12.66           C  
ATOM    779  C   PHE A  94      39.526  52.650  28.650  1.00 12.32           C  
ATOM    780  O   PHE A  94      40.208  52.354  27.680  1.00 13.10           O  
ATOM    781  CB  PHE A  94      38.254  50.628  29.308  1.00 13.04           C  
ATOM    782  CG  PHE A  94      36.982  50.056  29.860  1.00 14.93           C  
ATOM    783  CD1 PHE A  94      36.260  49.108  29.140  1.00 16.86           C  
ATOM    784  CD2 PHE A  94      36.521  50.442  31.114  1.00 16.41           C  
ATOM    785  CE1 PHE A  94      35.091  48.548  29.669  1.00 16.47           C  
ATOM    786  CE2 PHE A  94      35.354  49.888  31.650  1.00 16.91           C  
ATOM    787  CZ  PHE A  94      34.644  48.940  30.924  1.00 18.75           C  
ATOM    788  N   ALA A  95      39.955  53.489  29.584  1.00 13.60           N  
ATOM    789  CA  ALA A  95      41.300  54.041  29.480  1.00 16.25           C  
ATOM    790  C   ALA A  95      42.283  53.017  30.035  1.00 18.62           C  
ATOM    791  O   ALA A  95      42.071  52.475  31.121  1.00 20.47           O  
ATOM    792  CB  ALA A  95      41.401  55.348  30.272  1.00 18.80           C  
ATOM    793  N   PRO A  96      43.349  52.697  29.280  1.00 18.13           N  
ATOM    794  CA  PRO A  96      44.304  51.723  29.821  1.00 20.86           C  
ATOM    795  C   PRO A  96      44.808  52.321  31.138  1.00 21.81           C  
ATOM    796  O   PRO A  96      45.030  53.528  31.234  1.00 22.58           O  
ATOM    797  CB  PRO A  96      45.384  51.668  28.746  1.00 20.22           C  
ATOM    798  CG  PRO A  96      44.600  51.923  27.484  1.00 21.29           C  
ATOM    799  CD  PRO A  96      43.681  53.054  27.890  1.00 18.99           C  
ATOM    800  N   PRO A  97      44.997  51.488  32.168  1.00 22.88           N  
ATOM    801  CA  PRO A  97      45.466  51.985  33.464  1.00 23.83           C  
ATOM    802  C   PRO A  97      46.841  52.649  33.477  1.00 24.13           C  
ATOM    803  O   PRO A  97      47.145  53.439  34.373  1.00 24.03           O  
ATOM    804  CB  PRO A  97      45.435  50.731  34.333  1.00 24.48           C  
ATOM    805  CG  PRO A  97      45.811  49.663  33.360  1.00 24.05           C  
ATOM    806  CD  PRO A  97      44.956  50.016  32.156  1.00 24.13           C  
ATOM    807  N   ASN A  98      47.660  52.323  32.481  0.50 24.33           N  
ATOM    809  CA  ASN A  98      49.013  52.863  32.390  0.50 24.25           C  
ATOM    811  C   ASN A  98      49.229  53.836  31.230  0.50 23.77           C  
ATOM    813  O   ASN A  98      50.372  54.095  30.845  0.50 24.46           O  
ATOM    815  CB  ASN A  98      50.024  51.717  32.270  0.50 25.67           C  
ATOM    817  CG  ASN A  98      49.816  50.640  33.319  0.50 26.16           C  
ATOM    819  OD1 ASN A  98      49.774  50.920  34.516  0.50 27.74           O  
ATOM    821  ND2 ASN A  98      49.690  49.395  32.871  0.50 27.83           N  
ATOM    823  N   ILE A  99      48.151  54.372  30.669  1.00 21.09           N  
ATOM    824  CA  ILE A  99      48.284  55.316  29.567  1.00 18.83           C  
ATOM    825  C   ILE A  99      48.553  56.725  30.123  1.00 18.19           C  
ATOM    826  O   ILE A  99      48.011  57.104  31.162  1.00 17.14           O  
ATOM    827  CB  ILE A  99      47.033  55.280  28.665  1.00 17.90           C  
ATOM    828  CG1 ILE A  99      47.376  55.866  27.293  1.00 19.03           C  
ATOM    829  CG2 ILE A  99      45.885  56.019  29.332  1.00 18.28           C  
ATOM    830  CD1 ILE A  99      46.549  55.296  26.157  1.00 20.32           C  
ATOM    831  N   SER A 100      49.396  57.493  29.432  1.00 17.65           N  
ATOM    832  CA  SER A 100      49.771  58.826  29.909  1.00 18.57           C  
ATOM    833  C   SER A 100      48.916  60.038  29.520  1.00 18.59           C  
ATOM    834  O   SER A 100      49.082  61.116  30.101  1.00 21.78           O  
ATOM    835  CB  SER A 100      51.242  59.096  29.553  1.00 18.38           C  
ATOM    836  OG  SER A 100      51.452  59.084  28.152  1.00 19.27           O  
ATOM    837  N   ASP A 101      48.015  59.886  28.553  1.00 16.88           N  
ATOM    838  CA  ASP A 101      47.149  60.995  28.154  1.00 18.53           C  
ATOM    839  C   ASP A 101      45.917  60.515  27.394  1.00 18.98           C  
ATOM    840  O   ASP A 101      45.926  59.449  26.773  1.00 16.74           O  
ATOM    841  CB  ASP A 101      47.932  62.035  27.329  1.00 18.76           C  
ATOM    842  CG  ASP A 101      48.234  61.574  25.918  1.00 19.52           C  
ATOM    843  OD1 ASP A 101      47.312  61.567  25.080  1.00 20.54           O  
ATOM    844  OD2 ASP A 101      49.404  61.225  25.645  1.00 23.54           O  
HETATM  845  N   MSE A 102      44.854  61.314  27.448  1.00 19.02           N  
HETATM  846  CA  MSE A 102      43.587  60.975  26.808  1.00 19.72           C  
HETATM  847  C   MSE A 102      43.639  60.815  25.297  1.00 19.51           C  
HETATM  848  O   MSE A 102      42.963  59.949  24.737  1.00 19.22           O  
HETATM  849  CB  MSE A 102      42.526  62.019  27.174  1.00 24.80           C  
HETATM  850  CG  MSE A 102      41.130  61.685  26.687  1.00 30.15           C  
HETATM  851 SE   MSE A 102      39.823  62.958  27.333  1.00 40.13          SE  
HETATM  852  CE  MSE A 102      39.544  63.962  25.706  1.00 36.24           C  
ATOM    853  N   GLU A 103      44.432  61.643  24.626  1.00 16.30           N  
ATOM    854  CA  GLU A 103      44.521  61.542  23.181  1.00 16.65           C  
ATOM    855  C   GLU A 103      45.031  60.158  22.793  1.00 15.63           C  
ATOM    856  O   GLU A 103      44.547  59.561  21.830  1.00 15.82           O  
ATOM    857  CB  GLU A 103      45.467  62.608  22.619  1.00 20.19           C  
ATOM    858  CG  GLU A 103      45.362  62.788  21.114  1.00 26.10           C  
ATOM    859  CD  GLU A 103      46.371  63.786  20.573  1.00 30.44           C  
ATOM    860  OE1 GLU A 103      46.537  64.858  21.191  1.00 33.36           O  
ATOM    861  OE2 GLU A 103      46.990  63.503  19.525  1.00 33.36           O  
ATOM    862  N   ALA A 104      46.003  59.653  23.547  1.00 14.17           N  
ATOM    863  CA  ALA A 104      46.573  58.345  23.246  1.00 13.10           C  
ATOM    864  C   ALA A 104      45.550  57.228  23.388  1.00 13.23           C  
ATOM    865  O   ALA A 104      45.661  56.205  22.719  1.00 12.86           O  
ATOM    866  CB  ALA A 104      47.777  58.068  24.137  1.00 10.83           C  
ATOM    867  N   VAL A 105      44.554  57.417  24.251  1.00 11.76           N  
ATOM    868  CA  VAL A 105      43.537  56.377  24.436  1.00 12.84           C  
ATOM    869  C   VAL A 105      42.839  56.110  23.102  1.00 12.07           C  
ATOM    870  O   VAL A 105      42.680  54.962  22.691  1.00 12.63           O  
ATOM    871  CB  VAL A 105      42.475  56.785  25.495  1.00 12.16           C  
ATOM    872  CG1 VAL A 105      41.327  55.787  25.494  1.00 13.42           C  
ATOM    873  CG2 VAL A 105      43.102  56.836  26.880  1.00 11.59           C  
ATOM    874  N   TRP A 106      42.443  57.175  22.414  1.00 14.15           N  
ATOM    875  CA  TRP A 106      41.756  57.020  21.140  1.00 14.71           C  
ATOM    876  C   TRP A 106      42.684  56.707  19.967  1.00 15.16           C  
ATOM    877  O   TRP A 106      42.312  55.966  19.054  1.00 16.22           O  
ATOM    878  CB  TRP A 106      40.937  58.279  20.826  1.00 14.07           C  
ATOM    879  CG  TRP A 106      39.887  58.588  21.859  1.00 13.93           C  
ATOM    880  CD1 TRP A 106      39.999  59.446  22.916  1.00 13.47           C  
ATOM    881  CD2 TRP A 106      38.568  58.032  21.934  1.00 14.68           C  
ATOM    882  NE1 TRP A 106      38.832  59.461  23.642  1.00 13.55           N  
ATOM    883  CE2 TRP A 106      37.937  58.602  23.062  1.00 12.38           C  
ATOM    884  CE3 TRP A 106      37.858  57.105  21.159  1.00 16.85           C  
ATOM    885  CZ2 TRP A 106      36.626  58.278  23.435  1.00 13.72           C  
ATOM    886  CZ3 TRP A 106      36.553  56.782  21.531  1.00 16.68           C  
ATOM    887  CH2 TRP A 106      35.955  57.368  22.658  1.00 15.19           C  
ATOM    888  N   LYS A 107      43.892  57.260  19.994  1.00 16.45           N  
ATOM    889  CA  LYS A 107      44.838  57.035  18.908  1.00 17.73           C  
ATOM    890  C   LYS A 107      45.246  55.573  18.764  1.00 17.70           C  
ATOM    891  O   LYS A 107      45.363  55.061  17.649  1.00 19.42           O  
ATOM    892  CB  LYS A 107      46.092  57.887  19.112  1.00 22.09           C  
ATOM    893  CG  LYS A 107      47.101  57.768  17.979  1.00 26.73           C  
ATOM    894  CD  LYS A 107      46.496  58.221  16.662  1.00 30.53           C  
ATOM    895  CE  LYS A 107      47.494  58.100  15.518  1.00 32.94           C  
ATOM    896  NZ  LYS A 107      48.705  58.935  15.750  1.00 35.87           N  
ATOM    897  N   GLU A 108      45.466  54.909  19.890  1.00 16.74           N  
ATOM    898  CA  GLU A 108      45.887  53.512  19.886  1.00 17.59           C  
ATOM    899  C   GLU A 108      44.715  52.537  19.974  1.00 18.94           C  
ATOM    900  O   GLU A 108      44.915  51.324  19.977  1.00 19.47           O  
ATOM    901  CB  GLU A 108      46.841  53.252  21.055  1.00 19.60           C  
ATOM    902  CG  GLU A 108      48.077  54.154  21.097  1.00 21.39           C  
ATOM    903  CD  GLU A 108      48.896  54.110  19.812  1.00 25.55           C  
ATOM    904  OE1 GLU A 108      49.056  53.013  19.238  1.00 26.57           O  
ATOM    905  OE2 GLU A 108      49.391  55.173  19.381  1.00 25.95           O  
ATOM    906  N   ALA A 109      43.495  53.063  20.038  1.00 17.86           N  
ATOM    907  CA  ALA A 109      42.312  52.212  20.154  1.00 19.38           C  
ATOM    908  C   ALA A 109      42.066  51.293  18.964  1.00 20.56           C  
ATOM    909  O   ALA A 109      42.313  51.656  17.814  1.00 20.94           O  
ATOM    910  CB  ALA A 109      41.075  53.068  20.387  1.00 18.49           C  
ATOM    911  N   LYS A 110      41.576  50.096  19.262  1.00 21.97           N  
ATOM    912  CA  LYS A 110      41.232  49.113  18.239  1.00 23.23           C  
ATOM    913  C   LYS A 110      39.710  49.108  18.193  1.00 21.63           C  
ATOM    914  O   LYS A 110      39.061  49.339  19.209  1.00 20.64           O  
ATOM    915  CB  LYS A 110      41.732  47.721  18.626  1.00 27.09           C  
ATOM    916  CG  LYS A 110      43.222  47.490  18.428  1.00 31.32           C  
ATOM    917  CD  LYS A 110      43.614  46.089  18.879  1.00 35.30           C  
ATOM    918  CE  LYS A 110      42.775  45.022  18.178  1.00 38.01           C  
ATOM    919  NZ  LYS A 110      43.058  43.647  18.679  1.00 40.72           N  
ATOM    920  N   PRO A 111      39.121  48.843  17.018  1.00 21.39           N  
ATOM    921  CA  PRO A 111      37.663  48.813  16.844  1.00 21.11           C  
ATOM    922  C   PRO A 111      36.908  47.993  17.893  1.00 20.93           C  
ATOM    923  O   PRO A 111      35.850  48.408  18.374  1.00 19.92           O  
ATOM    924  CB  PRO A 111      37.500  48.235  15.444  1.00 21.98           C  
ATOM    925  CG  PRO A 111      38.703  48.766  14.731  1.00 23.02           C  
ATOM    926  CD  PRO A 111      39.803  48.549  15.744  1.00 23.04           C  
ATOM    927  N   ASP A 112      37.452  46.832  18.238  1.00 21.33           N  
ATOM    928  CA  ASP A 112      36.822  45.947  19.211  1.00 20.84           C  
ATOM    929  C   ASP A 112      36.836  46.466  20.645  1.00 20.44           C  
ATOM    930  O   ASP A 112      36.232  45.862  21.531  1.00 21.61           O  
ATOM    931  CB  ASP A 112      37.481  44.565  19.161  1.00 23.51           C  
ATOM    932  CG  ASP A 112      38.991  44.634  19.260  1.00 24.64           C  
ATOM    933  OD1 ASP A 112      39.505  45.169  20.266  1.00 26.93           O  
ATOM    934  OD2 ASP A 112      39.668  44.151  18.328  0.00 25.17           O  
ATOM    935  N   GLU A 113      37.521  47.581  20.880  1.00 16.96           N  
ATOM    936  CA  GLU A 113      37.601  48.144  22.221  1.00 17.28           C  
ATOM    937  C   GLU A 113      36.571  49.247  22.416  1.00 14.51           C  
ATOM    938  O   GLU A 113      36.367  49.733  23.525  1.00 16.24           O  
ATOM    939  CB  GLU A 113      39.012  48.686  22.476  1.00 19.00           C  
ATOM    940  CG  GLU A 113      40.078  47.591  22.447  1.00 24.72           C  
ATOM    941  CD  GLU A 113      41.501  48.125  22.407  1.00 28.56           C  
ATOM    942  OE1 GLU A 113      42.437  47.310  22.569  1.00 31.39           O  
ATOM    943  OE2 GLU A 113      41.688  49.343  22.206  1.00 28.41           O  
ATOM    944  N   LEU A 114      35.911  49.626  21.332  1.00 15.35           N  
ATOM    945  CA  LEU A 114      34.904  50.675  21.399  1.00 14.78           C  
ATOM    946  C   LEU A 114      33.541  50.139  21.841  1.00 15.82           C  
ATOM    947  O   LEU A 114      33.172  49.006  21.535  1.00 16.13           O  
ATOM    948  CB  LEU A 114      34.767  51.342  20.033  1.00 16.54           C  
ATOM    949  CG  LEU A 114      36.060  51.914  19.444  1.00 19.03           C  
ATOM    950  CD1 LEU A 114      35.799  52.438  18.038  1.00 20.18           C  
ATOM    951  CD2 LEU A 114      36.568  53.022  20.350  1.00 21.50           C  
HETATM  952  N   MSE A 115      32.801  50.966  22.571  1.00 12.28           N  
HETATM  953  CA  MSE A 115      31.457  50.617  23.032  1.00 13.85           C  
HETATM  954  C   MSE A 115      30.579  51.763  22.561  1.00 15.20           C  
HETATM  955  O   MSE A 115      30.932  52.926  22.742  1.00 16.43           O  
HETATM  956  CB  MSE A 115      31.407  50.527  24.555  1.00 11.85           C  
HETATM  957  CG  MSE A 115      32.240  49.387  25.137  1.00 13.96           C  
HETATM  958 SE   MSE A 115      32.508  49.550  27.030  1.00 15.78          SE  
HETATM  959  CE  MSE A 115      33.913  50.902  27.009  1.00 12.99           C  
ATOM    960  N   ASP A 116      29.445  51.445  21.948  1.00 16.33           N  
ATOM    961  CA  ASP A 116      28.559  52.489  21.447  1.00 18.39           C  
ATOM    962  C   ASP A 116      27.139  52.368  21.979  1.00 18.63           C  
ATOM    963  O   ASP A 116      26.648  51.267  22.228  1.00 18.66           O  
ATOM    964  CB  ASP A 116      28.512  52.457  19.913  1.00 23.57           C  
ATOM    965  CG  ASP A 116      29.847  52.819  19.265  1.00 28.43           C  
ATOM    966  OD1 ASP A 116      29.922  52.822  18.017  1.00 32.41           O  
ATOM    967  OD2 ASP A 116      30.818  53.100  19.995  1.00 33.49           O  
ATOM    968  N   SER A 117      26.493  53.517  22.150  1.00 16.04           N  
ATOM    969  CA  SER A 117      25.105  53.591  22.599  1.00 15.08           C  
ATOM    970  C   SER A 117      24.448  54.620  21.695  1.00 14.42           C  
ATOM    971  O   SER A 117      25.027  55.674  21.436  1.00 13.03           O  
ATOM    972  CB  SER A 117      25.006  54.061  24.053  1.00 17.40           C  
ATOM    973  OG  SER A 117      25.489  53.078  24.948  1.00 20.39           O  
ATOM    974  N   LYS A 118      23.251  54.314  21.199  1.00 11.33           N  
ATOM    975  CA  LYS A 118      22.544  55.243  20.321  1.00 11.59           C  
ATOM    976  C   LYS A 118      21.259  55.748  20.962  1.00 11.87           C  
ATOM    977  O   LYS A 118      20.587  55.019  21.692  1.00 12.93           O  
ATOM    978  CB  LYS A 118      22.203  54.564  18.993  1.00 13.81           C  
ATOM    979  CG  LYS A 118      23.396  54.163  18.154  1.00 19.70           C  
ATOM    980  CD  LYS A 118      24.045  55.370  17.506  1.00 22.86           C  
ATOM    981  CE  LYS A 118      25.209  54.952  16.620  1.00 26.08           C  
ATOM    982  NZ  LYS A 118      24.791  53.998  15.554  1.00 27.83           N  
ATOM    983  N   LEU A 119      20.934  57.006  20.681  1.00 10.03           N  
ATOM    984  CA  LEU A 119      19.726  57.638  21.192  1.00 11.91           C  
ATOM    985  C   LEU A 119      18.968  58.238  20.018  1.00 11.49           C  
ATOM    986  O   LEU A 119      19.569  58.760  19.079  1.00 14.14           O  
ATOM    987  CB  LEU A 119      20.071  58.757  22.185  1.00 14.31           C  
ATOM    988  CG  LEU A 119      20.786  58.426  23.499  1.00 17.44           C  
ATOM    989  CD1 LEU A 119      20.014  57.359  24.247  1.00 20.85           C  
ATOM    990  CD2 LEU A 119      22.206  57.969  23.222  1.00 21.53           C  
ATOM    991  N   ARG A 120      17.645  58.165  20.071  1.00 11.84           N  
ATOM    992  CA  ARG A 120      16.821  58.719  19.012  1.00 13.51           C  
ATOM    993  C   ARG A 120      16.379  60.125  19.413  1.00 13.32           C  
ATOM    994  O   ARG A 120      16.014  60.357  20.563  1.00 13.83           O  
ATOM    995  CB  ARG A 120      15.603  57.810  18.791  1.00 17.39           C  
ATOM    996  CG  ARG A 120      14.632  58.289  17.744  1.00 21.46           C  
ATOM    997  CD  ARG A 120      13.608  57.209  17.434  0.00 21.60           C  
ATOM    998  NE  ARG A 120      12.920  56.742  18.635  0.00 22.99           N  
ATOM    999  CZ  ARG A 120      12.052  55.736  18.656  0.00 23.51           C  
ATOM   1000  NH1 ARG A 120      11.759  55.087  17.538  0.00 23.99           N  
ATOM   1001  NH2 ARG A 120      11.475  55.380  19.795  0.00 23.99           N  
ATOM   1002  N   CYS A 121      16.437  61.073  18.481  1.00 12.85           N  
ATOM   1003  CA  CYS A 121      16.002  62.431  18.785  1.00 15.78           C  
ATOM   1004  C   CYS A 121      14.534  62.561  18.408  1.00 16.29           C  
ATOM   1005  O   CYS A 121      14.147  62.255  17.279  1.00 19.68           O  
ATOM   1006  CB  CYS A 121      16.837  63.448  18.005  1.00 15.67           C  
ATOM   1007  SG  CYS A 121      18.544  63.527  18.539  1.00 18.24           S  
ATOM   1008  N   VAL A 122      13.714  63.004  19.351  1.00 14.10           N  
ATOM   1009  CA  VAL A 122      12.286  63.162  19.087  1.00 15.33           C  
ATOM   1010  C   VAL A 122      11.874  64.619  19.255  1.00 13.67           C  
ATOM   1011  O   VAL A 122      12.166  65.230  20.282  1.00 14.94           O  
ATOM   1012  CB  VAL A 122      11.459  62.294  20.048  1.00 16.39           C  
ATOM   1013  CG1 VAL A 122       9.986  62.346  19.668  1.00 17.52           C  
ATOM   1014  CG2 VAL A 122      11.973  60.868  20.024  1.00 19.38           C  
ATOM   1015  N   PHE A 123      11.220  65.177  18.238  1.00 13.85           N  
ATOM   1016  CA  PHE A 123      10.761  66.565  18.295  1.00 14.15           C  
ATOM   1017  C   PHE A 123       9.264  66.560  18.565  1.00 14.05           C  
ATOM   1018  O   PHE A 123       8.480  66.108  17.729  1.00 17.09           O  
ATOM   1019  CB  PHE A 123      11.003  67.295  16.966  1.00 15.46           C  
ATOM   1020  CG  PHE A 123      12.450  67.404  16.566  1.00 15.72           C  
ATOM   1021  CD1 PHE A 123      13.472  67.146  17.473  1.00 16.97           C  
ATOM   1022  CD2 PHE A 123      12.786  67.795  15.273  1.00 18.30           C  
ATOM   1023  CE1 PHE A 123      14.809  67.273  17.095  1.00 16.52           C  
ATOM   1024  CE2 PHE A 123      14.118  67.927  14.883  1.00 18.27           C  
ATOM   1025  CZ  PHE A 123      15.129  67.667  15.794  1.00 16.58           C  
ATOM   1026  N   GLU A 124       8.864  67.053  19.729  1.00 14.62           N  
ATOM   1027  CA  GLU A 124       7.451  67.097  20.063  1.00 16.85           C  
ATOM   1028  C   GLU A 124       6.951  68.527  19.979  1.00 18.27           C  
ATOM   1029  O   GLU A 124       7.580  69.450  20.504  1.00 18.48           O  
ATOM   1030  CB  GLU A 124       7.220  66.537  21.468  1.00 19.93           C  
ATOM   1031  CG  GLU A 124       7.574  65.063  21.588  1.00 25.01           C  
ATOM   1032  CD  GLU A 124       7.236  64.478  22.948  1.00 28.35           C  
ATOM   1033  OE1 GLU A 124       7.468  63.265  23.138  1.00 30.61           O  
ATOM   1034  OE2 GLU A 124       6.740  65.224  23.821  1.00 31.72           O  
HETATM 1035  N   MSE A 125       5.828  68.710  19.298  1.00 18.37           N  
HETATM 1036  CA  MSE A 125       5.242  70.035  19.158  1.00 19.22           C  
HETATM 1037  C   MSE A 125       4.791  70.525  20.530  1.00 21.78           C  
HETATM 1038  O   MSE A 125       5.009  71.719  20.833  1.00 23.20           O  
HETATM 1039  OXT MSE A 125       4.215  69.708  21.281  1.00 21.03           O  
HETATM 1040  CB  MSE A 125       4.049  69.993  18.200  1.00 20.05           C  
HETATM 1041  CG  MSE A 125       4.399  69.513  16.800  1.00 20.05           C  
HETATM 1042 SE   MSE A 125       2.902  69.660  15.584  1.00 24.21          SE  
HETATM 1043  CE  MSE A 125       3.848  70.234  13.997  1.00 21.89           C  
TER    1044      MSE A 125                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
