
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 ( 1990),  selected  126 , name 3msp_A
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 3msp_A.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      E     267           -
LGA    Q     2_A      D     268           -
LGA    S     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    P     5_A      L     269           #
LGA    P     6_A      L     270          6.216
LGA    -       -      R     271           -
LGA    -       -      P     272           -
LGA    -       -      F     273           -
LGA    G     7_A      F     274          4.338
LGA    D     8_A      E     275          3.188
LGA    -       -      K     276           -
LGA    I     9_A      C     277          3.621
LGA    N    10_A      V     278          2.310
LGA    -       -      K     279           -
LGA    T    11_A      I     280          1.272
LGA    Q    12_A      E     281          1.350
LGA    P    13_A      E     282          3.723
LGA    S    14_A      V     283           -
LGA    Q    15_A      S     284           -
LGA    K    16_A      -       -           -
LGA    I    17_A      -       -           -
LGA    V    18_A      -       -           -
LGA    F    19_A      R     285          5.045
LGA    N    20_A      N     286          3.929
LGA    A    21_A      E     287          3.918
LGA    P    22_A      -       -           -
LGA    Y    23_A      -       -           -
LGA    D    24_A      -       -           -
LGA    D    25_A      -       -           -
LGA    K    26_A      -       -           -
LGA    H    27_A      Q     288          1.276
LGA    T    28_A      G     289          3.848
LGA    Y    29_A      V     290          2.060
LGA    H    30_A      T     291          1.385
LGA    I    31_A      L     292          1.094
LGA    K    32_A      S     293          0.872
LGA    I    33_A      I     294          0.919
LGA    T    34_A      T     295          1.721
LGA    N    35_A      N     296          1.670
LGA    A    36_A      V     297          2.966
LGA    G    37_A      T     298          2.991
LGA    G    38_A      D     299          1.997
LGA    R    39_A      L     300          2.003
LGA    R    40_A      V     301          0.926
LGA    I    41_A      L     302          1.476
LGA    G    42_A      K     303          0.937
LGA    W    43_A      L     304          0.804
LGA    A    44_A      K     305          2.065
LGA    I    45_A      K     306          3.024
LGA    K    46_A      T     307          3.939
LGA    T    47_A      A     308           #
LGA    T    48_A      H     309          3.294
LGA    N    49_A      D     310          1.898
LGA    M    50_A      T     311          1.696
LGA    R    51_A      -       -           -
LGA    R    52_A      L     312          1.985
LGA    L    53_A      L     313          2.153
LGA    S    54_A      V     314          1.176
LGA    V    55_A      Y     315          0.493
LGA    D    56_A      F     316          2.651
LGA    P    57_A      -       -           -
LGA    P    58_A      R     317          2.420
LGA    C    59_A      D     318          1.006
LGA    G    60_A      M     319          1.736
LGA    V    61_A      T     320          1.676
LGA    L    62_A      L     321          1.406
LGA    D    63_A      K     322          1.055
LGA    P    64_A      P     323          1.128
LGA    K    65_A      H     324          1.442
LGA    E    66_A      T     325          1.464
LGA    K    67_A      R     326          1.443
LGA    V    68_A      Y     327          1.308
LGA    L    69_A      T     328          1.540
LGA    M    70_A      V     329          1.118
LGA    A    71_A      R     330          1.375
LGA    V    72_A      I     331          0.894
LGA    S    73_A      G     332          1.130
LGA    C    74_A      F     333          1.207
LGA    D    75_A      K     334          2.216
LGA    T    76_A      Q     335          3.924
LGA    F    77_A      G     336          3.244
LGA    N    78_A      I     337           #
LGA    A    79_A      -       -           -
LGA    A    80_A      -       -           -
LGA    T    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    D    83_A      -       -           -
LGA    L    84_A      K     338           #
LGA    N    85_A      -       -           -
LGA    N    86_A      -       -           -
LGA    D    87_A      G     339          5.412
LGA    R    88_A      G     340          3.025
LGA    I    89_A      D     341          1.831
LGA    -       -      V     342           -
LGA    T    90_A      N     343          1.612
LGA    I    91_A      F     344          3.591
LGA    E    92_A      E     345          3.199
LGA    W    93_A      V     346          1.612
LGA    T    94_A      T     347          4.038
LGA    N    95_A      N     348          3.393
LGA    T    96_A      F     349           #
LGA    P    97_A      -       -           -
LGA    D    98_A      -       -           -
LGA    G    99_A      -       -           -
LGA    A   100_A      -       -           -
LGA    A   101_A      -       -           -
LGA    K   102_A      -       -           -
LGA    Q   103_A      -       -           -
LGA    F   104_A      -       -           -
LGA    R   105_A      -       -           -
LGA    R   106_A      -       -           -
LGA    E   107_A      -       -           -
LGA    W   108_A      I     350           #
LGA    F   109_A      V     351           #
LGA    -       -      A     352           -
LGA    -       -      P     353           -
LGA    Q   110_A      D     354          0.885
LGA    G   111_A      K     355           #
LGA    D   112_A      -       -           -
LGA    G   113_A      -       -           -
LGA    M   114_A      G     356           #
LGA    V   115_A      L     357          2.497
LGA    R   116_A      K     358          5.287
LGA    R   117_A      Y     359          1.932
LGA    K   118_A      -       -           -
LGA    N   119_A      T     360          2.219
LGA    L   120_A      I     361          2.702
LGA    P   121_A      S     362          2.715
LGA    I   122_A      L     363          3.183
LGA    E   123_A      -       -           -
LGA    Y   124_A      -       -           -
LGA    N   125_A      -       -           -
LGA    L   126_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126   97    5.0     76    2.61    13.16     55.941     2.809

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.872816 * X  +  -0.211195 * Y  +   0.439988 * Z  +  12.415033
  Y_new =   0.470440 * X  +  -0.604052 * Y  +   0.643278 * Z  +  66.426117
  Z_new =   0.129918 * X  +   0.768451 * Y  +   0.626581 * Z  +  28.552622 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.886746   -2.254846  [ DEG:    50.8068   -129.1932 ]
  Theta =  -0.130287   -3.011306  [ DEG:    -7.4649   -172.5351 ]
  Phi   =   2.647241   -0.494352  [ DEG:   151.6757    -28.3243 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3msp_A                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3msp_A.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126   97   5.0   76   2.61   13.16  55.941
REMARK  ---------------------------------------------------------- 
MOLECULE 3msp_A
HEADER    CELL MOTILITY PROTEIN                   10-SEP-98   3MSP              
TITLE     MOTILE MAJOR SPERM PROTEIN (MSP) OF ASCARIS SUUM, NMR, 20             
TITLE    2 STRUCTURES                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MAJOR SPERM PROTEIN;                                       
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: MSP;                                                        
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 OTHER_DETAILS: EXPRESSED MATERIAL LACKS THE N-TERMINAL               
COMPND   7 ACETYL GROUP THAT IS PRESENT IN WILD-TYPE MSP                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ASCARIS SUUM;                                   
SOURCE   3 ORGANISM_COMMON: PIG ROUNDWORM;                                      
SOURCE   4 CELL_LINE: BL21;                                                     
SOURCE   5 CELL: SPERM CELL;                                                    
SOURCE   6 GENE: ALPHA MSP;                                                     
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_VECTOR: PET11D;                                    
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: BL21;                                     
SOURCE  12 EXPRESSION_SYSTEM_GENE: ALPHA MSP                                    
KEYWDS    CELL MOTILITY PROTEIN, MAJOR SPERM PROTEIN, AMOEBOID                  
KEYWDS   2 MOTILITY, NMR STRUCTURE, FILAMENTS, POLYMERIZATION                   
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.HAAF,L.LECLAIRE III,G.ROBERTS,H.M.KENT,T.M.ROBERTS,                 
AUTHOR   2 M.STEWART,D.NEUHAUS                                                  
REVDAT   2   01-APR-03 3MSP    1       JRNL                                     
REVDAT   1   20-APR-99 3MSP    0                                                
JRNL        AUTH   A.HAAF,L.LECLAIRE 3RD.,G.ROBERTS,H.M.KENT,                   
JRNL        AUTH 2 T.M.ROBERTS,M.STEWART,D.NEUHAUS                              
JRNL        TITL   SOLUTION STRUCTURE OF THE MOTILE MAJOR SPERM                 
JRNL        TITL 2 PROTEIN (MSP) OF ASCARIS SUUM - EVIDENCE FOR TWO             
JRNL        TITL 3 MANGANESE BINDING SITES AND THE POSSIBLE ROLE OF             
JRNL        TITL 4 DIVALENT CATIONS IN FILAMENT FORMATION.                      
JRNL        REF    J.MOL.BIOL.                   V. 284  1611 1998              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  3MSP A    1   126  UNP    P27439   MSP1_ASCSU       1    126             
DBREF  3MSP B    1   126  UNP    P27439   MSP1_ASCSU       1    126             
SEQRES   1 A  126  ALA GLN SER VAL PRO PRO GLY ASP ILE ASN THR GLN PRO          
SEQRES   2 A  126  SER GLN LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 A  126  HIS THR TYR HIS ILE LYS ILE THR ASN ALA GLY GLY ARG          
SEQRES   4 A  126  ARG ILE GLY TRP ALA ILE LYS THR THR ASN MET ARG ARG          
SEQRES   5 A  126  LEU SER VAL ASP PRO PRO CYS GLY VAL LEU ASP PRO LYS          
SEQRES   6 A  126  GLU LYS VAL LEU MET ALA VAL SER CYS ASP THR PHE ASN          
SEQRES   7 A  126  ALA ALA THR GLU ASP LEU ASN ASN ASP ARG ILE THR ILE          
SEQRES   8 A  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 A  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 A  126  LYS ASN LEU PRO ILE GLU TYR ASN LEU                          
SEQRES   1 B  126  ALA GLN SER VAL PRO PRO GLY ASP ILE ASN THR GLN PRO          
SEQRES   2 B  126  SER GLN LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 B  126  HIS THR TYR HIS ILE LYS ILE THR ASN ALA GLY GLY ARG          
SEQRES   4 B  126  ARG ILE GLY TRP ALA ILE LYS THR THR ASN MET ARG ARG          
SEQRES   5 B  126  LEU SER VAL ASP PRO PRO CYS GLY VAL LEU ASP PRO LYS          
SEQRES   6 B  126  GLU LYS VAL LEU MET ALA VAL SER CYS ASP THR PHE ASN          
SEQRES   7 B  126  ALA ALA THR GLU ASP LEU ASN ASN ASP ARG ILE THR ILE          
SEQRES   8 B  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 B  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 B  126  LYS ASN LEU PRO ILE GLU TYR ASN LEU                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ALA A   1      43.902  44.597  39.642  1.00  0.00           N  
ATOM      2  CA  ALA A   1      44.956  43.549  39.631  1.00  0.00           C  
ATOM      3  C   ALA A   1      45.045  42.877  38.265  1.00  0.00           C  
ATOM      4  O   ALA A   1      46.127  42.762  37.689  1.00  0.00           O  
ATOM      5  CB  ALA A   1      44.680  42.514  40.711  1.00  0.00           C  
ATOM      6  HA  ALA A   1      45.904  44.019  39.851  1.00  0.00           H  
ATOM      7  HB1 ALA A   1      44.058  42.951  41.479  1.00  0.00           H  
ATOM      8  HB2 ALA A   1      44.172  41.666  40.276  1.00  0.00           H  
ATOM      9  HB3 ALA A   1      45.614  42.190  41.146  1.00  0.00           H  
ATOM     10  H1  ALA A   1      44.040  45.194  38.801  1.00  0.00           H  
ATOM     11  H2  ALA A   1      42.980  44.117  39.616  1.00  0.00           H  
ATOM     12  H3  ALA A   1      44.014  45.150  40.515  1.00  0.00           H  
ATOM     13  N   GLN A   2      43.902  42.434  37.752  1.00  0.00           N  
ATOM     14  CA  GLN A   2      43.852  41.773  36.453  1.00  0.00           C  
ATOM     15  C   GLN A   2      43.201  42.674  35.408  1.00  0.00           C  
ATOM     16  O   GLN A   2      42.813  43.804  35.705  1.00  0.00           O  
ATOM     17  CB  GLN A   2      43.081  40.455  36.558  1.00  0.00           C  
ATOM     18  CG  GLN A   2      41.635  40.628  36.992  1.00  0.00           C  
ATOM     19  CD  GLN A   2      41.208  39.595  38.016  1.00  0.00           C  
ATOM     20  OE1 GLN A   2      41.758  39.528  39.116  1.00  0.00           O  
ATOM     21  NE2 GLN A   2      40.222  38.780  37.659  1.00  0.00           N  
ATOM     22  H   GLN A   2      43.072  42.555  38.259  1.00  0.00           H  
ATOM     23  HA  GLN A   2      44.866  41.563  36.149  1.00  0.00           H  
ATOM     24  HB2 GLN A   2      43.089  39.969  35.593  1.00  0.00           H  
ATOM     25  HB3 GLN A   2      43.577  39.818  37.274  1.00  0.00           H  
ATOM     26  HG2 GLN A   2      41.518  41.610  37.424  1.00  0.00           H  
ATOM     27  HG3 GLN A   2      40.998  40.538  36.125  1.00  0.00           H  
ATOM     28 HE21 GLN A   2      39.830  38.891  36.768  1.00  0.00           H  
ATOM     29 HE22 GLN A   2      39.926  38.102  38.302  1.00  0.00           H  
ATOM     30  N   SER A   3      43.086  42.166  34.186  1.00  0.00           N  
ATOM     31  CA  SER A   3      42.482  42.925  33.098  1.00  0.00           C  
ATOM     32  C   SER A   3      41.102  43.441  33.495  1.00  0.00           C  
ATOM     33  O   SER A   3      40.411  42.830  34.310  1.00  0.00           O  
ATOM     34  CB  SER A   3      42.373  42.058  31.841  1.00  0.00           C  
ATOM     35  OG  SER A   3      41.261  41.183  31.920  1.00  0.00           O  
ATOM     36  H   SER A   3      43.413  41.259  34.012  1.00  0.00           H  
ATOM     37  HA  SER A   3      43.122  43.769  32.887  1.00  0.00           H  
ATOM     38  HB2 SER A   3      42.253  42.694  30.977  1.00  0.00           H  
ATOM     39  HB3 SER A   3      43.271  41.469  31.735  1.00  0.00           H  
ATOM     40  HG  SER A   3      41.292  40.559  31.191  1.00  0.00           H  
ATOM     41  N   VAL A   4      40.708  44.570  32.915  1.00  0.00           N  
ATOM     42  CA  VAL A   4      39.412  45.170  33.211  1.00  0.00           C  
ATOM     43  C   VAL A   4      38.790  45.785  31.957  1.00  0.00           C  
ATOM     44  O   VAL A   4      39.244  46.826  31.482  1.00  0.00           O  
ATOM     45  CB  VAL A   4      39.533  46.259  34.292  1.00  0.00           C  
ATOM     46  CG1 VAL A   4      39.691  45.631  35.669  1.00  0.00           C  
ATOM     47  CG2 VAL A   4      40.698  47.187  33.985  1.00  0.00           C  
ATOM     48  H   VAL A   4      41.304  45.012  32.274  1.00  0.00           H  
ATOM     49  HA  VAL A   4      38.763  44.392  33.586  1.00  0.00           H  
ATOM     50  HB  VAL A   4      38.625  46.843  34.289  1.00  0.00           H  
ATOM     51 HG11 VAL A   4      39.820  44.564  35.564  1.00  0.00           H  
ATOM     52 HG12 VAL A   4      40.555  46.053  36.160  1.00  0.00           H  
ATOM     53 HG13 VAL A   4      38.808  45.831  36.257  1.00  0.00           H  
ATOM     54 HG21 VAL A   4      40.919  47.151  32.927  1.00  0.00           H  
ATOM     55 HG22 VAL A   4      40.435  48.198  34.262  1.00  0.00           H  
ATOM     56 HG23 VAL A   4      41.566  46.874  34.544  1.00  0.00           H  
ATOM     57  N   PRO A   5      37.741  45.153  31.402  1.00  0.00           N  
ATOM     58  CA  PRO A   5      37.066  45.656  30.199  1.00  0.00           C  
ATOM     59  C   PRO A   5      36.360  46.988  30.445  1.00  0.00           C  
ATOM     60  O   PRO A   5      36.175  47.399  31.591  1.00  0.00           O  
ATOM     61  CB  PRO A   5      36.044  44.562  29.873  1.00  0.00           C  
ATOM     62  CG  PRO A   5      35.815  43.857  31.164  1.00  0.00           C  
ATOM     63  CD  PRO A   5      37.126  43.908  31.897  1.00  0.00           C  
ATOM     64  HA  PRO A   5      37.757  45.765  29.376  1.00  0.00           H  
ATOM     65  HB2 PRO A   5      35.136  45.014  29.502  1.00  0.00           H  
ATOM     66  HB3 PRO A   5      36.453  43.896  29.127  1.00  0.00           H  
ATOM     67  HG2 PRO A   5      35.049  44.366  31.730  1.00  0.00           H  
ATOM     68  HG3 PRO A   5      35.530  42.833  30.978  1.00  0.00           H  
ATOM     69  HD2 PRO A   5      36.962  43.955  32.963  1.00  0.00           H  
ATOM     70  HD3 PRO A   5      37.735  43.051  31.644  1.00  0.00           H  
ATOM     71  N   PRO A   6      35.955  47.681  29.368  1.00  0.00           N  
ATOM     72  CA  PRO A   6      35.266  48.971  29.472  1.00  0.00           C  
ATOM     73  C   PRO A   6      33.853  48.831  30.027  1.00  0.00           C  
ATOM     74  O   PRO A   6      32.914  48.525  29.292  1.00  0.00           O  
ATOM     75  CB  PRO A   6      35.225  49.472  28.027  1.00  0.00           C  
ATOM     76  CG  PRO A   6      35.288  48.237  27.196  1.00  0.00           C  
ATOM     77  CD  PRO A   6      36.136  47.263  27.964  1.00  0.00           C  
ATOM     78  HA  PRO A   6      35.823  49.668  30.081  1.00  0.00           H  
ATOM     79  HB2 PRO A   6      34.308  50.017  27.857  1.00  0.00           H  
ATOM     80  HB3 PRO A   6      36.072  50.115  27.840  1.00  0.00           H  
ATOM     81  HG2 PRO A   6      34.294  47.839  27.055  1.00  0.00           H  
ATOM     82  HG3 PRO A   6      35.744  48.459  26.243  1.00  0.00           H  
ATOM     83  HD2 PRO A   6      35.781  46.253  27.815  1.00  0.00           H  
ATOM     84  HD3 PRO A   6      37.172  47.347  27.669  1.00  0.00           H  
ATOM     85  N   GLY A   7      33.708  49.056  31.329  1.00  0.00           N  
ATOM     86  CA  GLY A   7      32.406  48.950  31.962  1.00  0.00           C  
ATOM     87  C   GLY A   7      31.334  49.721  31.216  1.00  0.00           C  
ATOM     88  O   GLY A   7      31.525  50.886  30.870  1.00  0.00           O  
ATOM     89  H   GLY A   7      34.492  49.298  31.865  1.00  0.00           H  
ATOM     90  HA2 GLY A   7      32.123  47.909  32.002  1.00  0.00           H  
ATOM     91  HA3 GLY A   7      32.475  49.333  32.969  1.00  0.00           H  
ATOM     92  N   ASP A   8      30.202  49.068  30.969  1.00  0.00           N  
ATOM     93  CA  ASP A   8      29.096  49.700  30.259  1.00  0.00           C  
ATOM     94  C   ASP A   8      28.637  50.961  30.983  1.00  0.00           C  
ATOM     95  O   ASP A   8      28.037  50.890  32.055  1.00  0.00           O  
ATOM     96  CB  ASP A   8      27.927  48.723  30.121  1.00  0.00           C  
ATOM     97  CG  ASP A   8      28.332  47.426  29.451  1.00  0.00           C  
ATOM     98  OD1 ASP A   8      29.534  47.262  29.153  1.00  0.00           O  
ATOM     99  OD2 ASP A   8      27.447  46.573  29.225  1.00  0.00           O  
ATOM    100  H   ASP A   8      30.110  48.140  31.269  1.00  0.00           H  
ATOM    101  HA  ASP A   8      29.445  49.971  29.275  1.00  0.00           H  
ATOM    102  HB2 ASP A   8      27.540  48.493  31.103  1.00  0.00           H  
ATOM    103  HB3 ASP A   8      27.148  49.185  29.531  1.00  0.00           H  
ATOM    104  N   ILE A   9      28.921  52.116  30.390  1.00  0.00           N  
ATOM    105  CA  ILE A   9      28.536  53.392  30.980  1.00  0.00           C  
ATOM    106  C   ILE A   9      27.024  53.576  30.952  1.00  0.00           C  
ATOM    107  O   ILE A   9      26.400  53.520  29.892  1.00  0.00           O  
ATOM    108  CB  ILE A   9      29.199  54.575  30.249  1.00  0.00           C  
ATOM    109  CG1 ILE A   9      28.859  54.539  28.758  1.00  0.00           C  
ATOM    110  CG2 ILE A   9      30.706  54.549  30.454  1.00  0.00           C  
ATOM    111  CD1 ILE A   9      28.288  55.839  28.236  1.00  0.00           C  
ATOM    112  H   ILE A   9      29.402  52.109  29.535  1.00  0.00           H  
ATOM    113  HA  ILE A   9      28.870  53.398  32.007  1.00  0.00           H  
ATOM    114  HB  ILE A   9      28.818  55.491  30.675  1.00  0.00           H  
ATOM    115 HG12 ILE A   9      29.754  54.321  28.197  1.00  0.00           H  
ATOM    116 HG13 ILE A   9      28.131  53.762  28.581  1.00  0.00           H  
ATOM    117 HG21 ILE A   9      31.062  53.532  30.375  1.00  0.00           H  
ATOM    118 HG22 ILE A   9      31.183  55.158  29.700  1.00  0.00           H  
ATOM    119 HG23 ILE A   9      30.942  54.937  31.433  1.00  0.00           H  
ATOM    120 HD11 ILE A   9      28.954  56.651  28.488  1.00  0.00           H  
ATOM    121 HD12 ILE A   9      28.182  55.780  27.163  1.00  0.00           H  
ATOM    122 HD13 ILE A   9      27.322  56.014  28.684  1.00  0.00           H  
ATOM    123  N   ASN A  10      26.438  53.797  32.124  1.00  0.00           N  
ATOM    124  CA  ASN A  10      24.999  53.992  32.231  1.00  0.00           C  
ATOM    125  C   ASN A  10      24.566  55.238  31.466  1.00  0.00           C  
ATOM    126  O   ASN A  10      25.297  56.227  31.408  1.00  0.00           O  
ATOM    127  CB  ASN A  10      24.589  54.109  33.701  1.00  0.00           C  
ATOM    128  CG  ASN A  10      23.702  52.964  34.147  1.00  0.00           C  
ATOM    129  OD1 ASN A  10      22.727  52.621  33.478  1.00  0.00           O  
ATOM    130  ND2 ASN A  10      24.037  52.366  35.285  1.00  0.00           N  
ATOM    131  H   ASN A  10      26.989  53.833  32.934  1.00  0.00           H  
ATOM    132  HA  ASN A  10      24.513  53.130  31.799  1.00  0.00           H  
ATOM    133  HB2 ASN A  10      25.477  54.112  34.316  1.00  0.00           H  
ATOM    134  HB3 ASN A  10      24.052  55.035  33.844  1.00  0.00           H  
ATOM    135 HD21 ASN A  10      24.826  52.692  35.765  1.00  0.00           H  
ATOM    136 HD22 ASN A  10      23.482  51.621  35.597  1.00  0.00           H  
ATOM    137  N   THR A  11      23.376  55.184  30.877  1.00  0.00           N  
ATOM    138  CA  THR A  11      22.853  56.309  30.111  1.00  0.00           C  
ATOM    139  C   THR A  11      21.357  56.494  30.351  1.00  0.00           C  
ATOM    140  O   THR A  11      20.596  55.527  30.367  1.00  0.00           O  
ATOM    141  CB  THR A  11      23.120  56.105  28.619  1.00  0.00           C  
ATOM    142  OG1 THR A  11      23.210  54.725  28.311  1.00  0.00           O  
ATOM    143  CG2 THR A  11      24.395  56.766  28.141  1.00  0.00           C  
ATOM    144  H   THR A  11      22.839  54.369  30.956  1.00  0.00           H  
ATOM    145  HA  THR A  11      23.369  57.200  30.438  1.00  0.00           H  
ATOM    146  HB  THR A  11      22.298  56.525  28.056  1.00  0.00           H  
ATOM    147  HG1 THR A  11      22.407  54.281  28.594  1.00  0.00           H  
ATOM    148 HG21 THR A  11      24.820  57.350  28.943  1.00  0.00           H  
ATOM    149 HG22 THR A  11      25.100  56.008  27.834  1.00  0.00           H  
ATOM    150 HG23 THR A  11      24.173  57.412  27.303  1.00  0.00           H  
ATOM    151  N   GLN A  12      20.946  57.744  30.536  1.00  0.00           N  
ATOM    152  CA  GLN A  12      19.545  58.066  30.774  1.00  0.00           C  
ATOM    153  C   GLN A  12      19.157  59.352  30.040  1.00  0.00           C  
ATOM    154  O   GLN A  12      19.535  60.446  30.463  1.00  0.00           O  
ATOM    155  CB  GLN A  12      19.286  58.230  32.273  1.00  0.00           C  
ATOM    156  CG  GLN A  12      19.959  57.170  33.131  1.00  0.00           C  
ATOM    157  CD  GLN A  12      20.169  57.626  34.562  1.00  0.00           C  
ATOM    158  OE1 GLN A  12      20.916  58.568  34.822  1.00  0.00           O  
ATOM    159  NE2 GLN A  12      19.508  56.957  35.499  1.00  0.00           N  
ATOM    160  H   GLN A  12      21.604  58.469  30.510  1.00  0.00           H  
ATOM    161  HA  GLN A  12      18.948  57.249  30.403  1.00  0.00           H  
ATOM    162  HB2 GLN A  12      19.648  59.199  32.585  1.00  0.00           H  
ATOM    163  HB3 GLN A  12      18.221  58.181  32.450  1.00  0.00           H  
ATOM    164  HG2 GLN A  12      19.341  56.286  33.139  1.00  0.00           H  
ATOM    165  HG3 GLN A  12      20.920  56.935  32.700  1.00  0.00           H  
ATOM    166 HE21 GLN A  12      18.930  56.217  35.219  1.00  0.00           H  
ATOM    167 HE22 GLN A  12      19.626  57.231  36.433  1.00  0.00           H  
ATOM    168  N   PRO A  13      18.400  59.255  28.926  1.00  0.00           N  
ATOM    169  CA  PRO A  13      17.919  57.980  28.371  1.00  0.00           C  
ATOM    170  C   PRO A  13      19.059  57.048  27.979  1.00  0.00           C  
ATOM    171  O   PRO A  13      20.200  57.479  27.813  1.00  0.00           O  
ATOM    172  CB  PRO A  13      17.118  58.397  27.132  1.00  0.00           C  
ATOM    173  CG  PRO A  13      17.597  59.770  26.805  1.00  0.00           C  
ATOM    174  CD  PRO A  13      17.955  60.401  28.120  1.00  0.00           C  
ATOM    175  HA  PRO A  13      17.268  57.470  29.067  1.00  0.00           H  
ATOM    176  HB2 PRO A  13      17.317  57.707  26.324  1.00  0.00           H  
ATOM    177  HB3 PRO A  13      16.064  58.393  27.364  1.00  0.00           H  
ATOM    178  HG2 PRO A  13      18.465  59.714  26.166  1.00  0.00           H  
ATOM    179  HG3 PRO A  13      16.809  60.329  26.323  1.00  0.00           H  
ATOM    180  HD2 PRO A  13      18.753  61.117  27.990  1.00  0.00           H  
ATOM    181  HD3 PRO A  13      17.090  60.871  28.562  1.00  0.00           H  
ATOM    182  N   SER A  14      18.737  55.767  27.836  1.00  0.00           N  
ATOM    183  CA  SER A  14      19.730  54.765  27.466  1.00  0.00           C  
ATOM    184  C   SER A  14      19.776  54.571  25.953  1.00  0.00           C  
ATOM    185  O   SER A  14      20.801  54.169  25.401  1.00  0.00           O  
ATOM    186  CB  SER A  14      19.418  53.434  28.152  1.00  0.00           C  
ATOM    187  OG  SER A  14      20.272  52.405  27.683  1.00  0.00           O  
ATOM    188  H   SER A  14      17.810  55.489  27.986  1.00  0.00           H  
ATOM    189  HA  SER A  14      20.695  55.114  27.802  1.00  0.00           H  
ATOM    190  HB2 SER A  14      19.555  53.540  29.218  1.00  0.00           H  
ATOM    191  HB3 SER A  14      18.394  53.157  27.946  1.00  0.00           H  
ATOM    192  HG  SER A  14      21.172  52.581  27.970  1.00  0.00           H  
ATOM    193  N   GLN A  15      18.662  54.857  25.288  1.00  0.00           N  
ATOM    194  CA  GLN A  15      18.581  54.711  23.839  1.00  0.00           C  
ATOM    195  C   GLN A  15      17.236  55.202  23.313  1.00  0.00           C  
ATOM    196  O   GLN A  15      16.568  54.508  22.547  1.00  0.00           O  
ATOM    197  CB  GLN A  15      18.790  53.248  23.443  1.00  0.00           C  
ATOM    198  CG  GLN A  15      19.699  53.067  22.238  1.00  0.00           C  
ATOM    199  CD  GLN A  15      19.886  51.611  21.862  1.00  0.00           C  
ATOM    200  OE1 GLN A  15      20.791  50.940  22.359  1.00  0.00           O  
ATOM    201  NE2 GLN A  15      19.029  51.112  20.978  1.00  0.00           N  
ATOM    202  H   GLN A  15      17.877  55.173  25.782  1.00  0.00           H  
ATOM    203  HA  GLN A  15      19.365  55.308  23.401  1.00  0.00           H  
ATOM    204  HB2 GLN A  15      19.226  52.720  24.278  1.00  0.00           H  
ATOM    205  HB3 GLN A  15      17.831  52.809  23.212  1.00  0.00           H  
ATOM    206  HG2 GLN A  15      19.268  53.587  21.396  1.00  0.00           H  
ATOM    207  HG3 GLN A  15      20.666  53.492  22.466  1.00  0.00           H  
ATOM    208 HE21 GLN A  15      18.333  51.705  20.623  1.00  0.00           H  
ATOM    209 HE22 GLN A  15      19.125  50.173  20.718  1.00  0.00           H  
ATOM    210  N   LYS A  16      16.846  56.404  23.726  1.00  0.00           N  
ATOM    211  CA  LYS A  16      15.581  56.985  23.292  1.00  0.00           C  
ATOM    212  C   LYS A  16      15.368  58.360  23.918  1.00  0.00           C  
ATOM    213  O   LYS A  16      15.080  58.473  25.109  1.00  0.00           O  
ATOM    214  CB  LYS A  16      14.418  56.059  23.657  1.00  0.00           C  
ATOM    215  CG  LYS A  16      13.684  55.497  22.451  1.00  0.00           C  
ATOM    216  CD  LYS A  16      12.746  54.369  22.846  1.00  0.00           C  
ATOM    217  CE  LYS A  16      12.948  53.143  21.971  1.00  0.00           C  
ATOM    218  NZ  LYS A  16      12.669  53.433  20.537  1.00  0.00           N  
ATOM    219  H   LYS A  16      17.421  56.910  24.335  1.00  0.00           H  
ATOM    220  HA  LYS A  16      15.617  57.094  22.218  1.00  0.00           H  
ATOM    221  HB2 LYS A  16      14.800  55.232  24.236  1.00  0.00           H  
ATOM    222  HB3 LYS A  16      13.709  56.610  24.258  1.00  0.00           H  
ATOM    223  HG2 LYS A  16      13.109  56.286  21.991  1.00  0.00           H  
ATOM    224  HG3 LYS A  16      14.409  55.120  21.745  1.00  0.00           H  
ATOM    225  HD2 LYS A  16      12.935  54.100  23.874  1.00  0.00           H  
ATOM    226  HD3 LYS A  16      11.725  54.710  22.744  1.00  0.00           H  
ATOM    227  HE2 LYS A  16      13.970  52.810  22.069  1.00  0.00           H  
ATOM    228  HE3 LYS A  16      12.281  52.362  22.308  1.00  0.00           H  
ATOM    229  HZ1 LYS A  16      12.380  54.425  20.422  1.00  0.00           H  
ATOM    230  HZ2 LYS A  16      13.523  53.265  19.966  1.00  0.00           H  
ATOM    231  HZ3 LYS A  16      11.906  52.818  20.190  1.00  0.00           H  
ATOM    232  N   ILE A  17      15.508  59.402  23.104  1.00  0.00           N  
ATOM    233  CA  ILE A  17      15.329  60.769  23.577  1.00  0.00           C  
ATOM    234  C   ILE A  17      14.377  61.540  22.667  1.00  0.00           C  
ATOM    235  O   ILE A  17      14.634  61.692  21.472  1.00  0.00           O  
ATOM    236  CB  ILE A  17      16.674  61.517  23.655  1.00  0.00           C  
ATOM    237  CG1 ILE A  17      16.491  62.873  24.340  1.00  0.00           C  
ATOM    238  CG2 ILE A  17      17.265  61.695  22.264  1.00  0.00           C  
ATOM    239  CD1 ILE A  17      17.764  63.418  24.950  1.00  0.00           C  
ATOM    240  H   ILE A  17      15.736  59.247  22.163  1.00  0.00           H  
ATOM    241  HA  ILE A  17      14.906  60.727  24.570  1.00  0.00           H  
ATOM    242  HB  ILE A  17      17.359  60.919  24.236  1.00  0.00           H  
ATOM    243 HG12 ILE A  17      16.137  63.591  23.615  1.00  0.00           H  
ATOM    244 HG13 ILE A  17      15.759  62.774  25.129  1.00  0.00           H  
ATOM    245 HG21 ILE A  17      16.929  60.892  21.625  1.00  0.00           H  
ATOM    246 HG22 ILE A  17      16.943  62.641  21.855  1.00  0.00           H  
ATOM    247 HG23 ILE A  17      18.343  61.677  22.326  1.00  0.00           H  
ATOM    248 HD11 ILE A  17      18.195  62.677  25.606  1.00  0.00           H  
ATOM    249 HD12 ILE A  17      18.466  63.655  24.165  1.00  0.00           H  
ATOM    250 HD13 ILE A  17      17.539  64.311  25.514  1.00  0.00           H  
ATOM    251  N   VAL A  18      13.276  62.018  23.237  1.00  0.00           N  
ATOM    252  CA  VAL A  18      12.284  62.765  22.472  1.00  0.00           C  
ATOM    253  C   VAL A  18      12.284  64.243  22.847  1.00  0.00           C  
ATOM    254  O   VAL A  18      11.593  64.657  23.777  1.00  0.00           O  
ATOM    255  CB  VAL A  18      10.868  62.200  22.688  1.00  0.00           C  
ATOM    256  CG1 VAL A  18       9.861  62.935  21.818  1.00  0.00           C  
ATOM    257  CG2 VAL A  18      10.840  60.706  22.404  1.00  0.00           C  
ATOM    258  H   VAL A  18      13.124  61.859  24.192  1.00  0.00           H  
ATOM    259  HA  VAL A  18      12.529  62.669  21.425  1.00  0.00           H  
ATOM    260  HB  VAL A  18      10.595  62.353  23.722  1.00  0.00           H  
ATOM    261 HG11 VAL A  18      10.268  63.892  21.525  1.00  0.00           H  
ATOM    262 HG12 VAL A  18       9.652  62.348  20.935  1.00  0.00           H  
ATOM    263 HG13 VAL A  18       8.947  63.087  22.373  1.00  0.00           H  
ATOM    264 HG21 VAL A  18      11.828  60.294  22.544  1.00  0.00           H  
ATOM    265 HG22 VAL A  18      10.150  60.222  23.081  1.00  0.00           H  
ATOM    266 HG23 VAL A  18      10.521  60.539  21.386  1.00  0.00           H  
ATOM    267  N   PHE A  19      13.058  65.036  22.112  1.00  0.00           N  
ATOM    268  CA  PHE A  19      13.138  66.469  22.363  1.00  0.00           C  
ATOM    269  C   PHE A  19      11.744  67.088  22.388  1.00  0.00           C  
ATOM    270  O   PHE A  19      11.176  67.407  21.344  1.00  0.00           O  
ATOM    271  CB  PHE A  19      13.994  67.147  21.291  1.00  0.00           C  
ATOM    272  CG  PHE A  19      15.398  66.619  21.225  1.00  0.00           C  
ATOM    273  CD1 PHE A  19      16.048  66.198  22.375  1.00  0.00           C  
ATOM    274  CD2 PHE A  19      16.067  66.540  20.014  1.00  0.00           C  
ATOM    275  CE1 PHE A  19      17.340  65.710  22.317  1.00  0.00           C  
ATOM    276  CE2 PHE A  19      17.359  66.054  19.951  1.00  0.00           C  
ATOM    277  CZ  PHE A  19      17.996  65.637  21.104  1.00  0.00           C  
ATOM    278  H   PHE A  19      13.581  64.649  21.381  1.00  0.00           H  
ATOM    279  HA  PHE A  19      13.601  66.613  23.329  1.00  0.00           H  
ATOM    280  HB2 PHE A  19      13.535  66.997  20.326  1.00  0.00           H  
ATOM    281  HB3 PHE A  19      14.046  68.206  21.499  1.00  0.00           H  
ATOM    282  HD1 PHE A  19      15.536  66.253  23.324  1.00  0.00           H  
ATOM    283  HD2 PHE A  19      15.570  66.866  19.113  1.00  0.00           H  
ATOM    284  HE1 PHE A  19      17.836  65.386  23.220  1.00  0.00           H  
ATOM    285  HE2 PHE A  19      17.870  65.998  19.001  1.00  0.00           H  
ATOM    286  HZ  PHE A  19      19.005  65.256  21.057  1.00  0.00           H  
ATOM    287  N   ASN A  20      11.195  67.244  23.587  1.00  0.00           N  
ATOM    288  CA  ASN A  20       9.862  67.812  23.752  1.00  0.00           C  
ATOM    289  C   ASN A  20       9.829  69.285  23.351  1.00  0.00           C  
ATOM    290  O   ASN A  20      10.764  70.037  23.625  1.00  0.00           O  
ATOM    291  CB  ASN A  20       9.396  67.660  25.201  1.00  0.00           C  
ATOM    292  CG  ASN A  20       8.916  66.256  25.511  1.00  0.00           C  
ATOM    293  OD1 ASN A  20       7.942  65.778  24.928  1.00  0.00           O  
ATOM    294  ND2 ASN A  20       9.598  65.587  26.433  1.00  0.00           N  
ATOM    295  H   ASN A  20      11.695  66.963  24.382  1.00  0.00           H  
ATOM    296  HA  ASN A  20       9.189  67.264  23.110  1.00  0.00           H  
ATOM    297  HB2 ASN A  20      10.218  67.892  25.862  1.00  0.00           H  
ATOM    298  HB3 ASN A  20       8.584  68.348  25.385  1.00  0.00           H  
ATOM    299 HD21 ASN A  20      10.362  66.032  26.856  1.00  0.00           H  
ATOM    300 HD22 ASN A  20       9.310  64.677  26.654  1.00  0.00           H  
ATOM    301  N   ALA A  21       8.736  69.685  22.708  1.00  0.00           N  
ATOM    302  CA  ALA A  21       8.558  71.067  22.273  1.00  0.00           C  
ATOM    303  C   ALA A  21       8.858  72.039  23.416  1.00  0.00           C  
ATOM    304  O   ALA A  21       9.010  71.619  24.562  1.00  0.00           O  
ATOM    305  CB  ALA A  21       7.137  71.262  21.764  1.00  0.00           C  
ATOM    306  H   ALA A  21       8.025  69.035  22.528  1.00  0.00           H  
ATOM    307  HA  ALA A  21       9.240  71.255  21.457  1.00  0.00           H  
ATOM    308  HB1 ALA A  21       6.616  70.315  21.780  1.00  0.00           H  
ATOM    309  HB2 ALA A  21       6.620  71.968  22.398  1.00  0.00           H  
ATOM    310  HB3 ALA A  21       7.166  71.639  20.753  1.00  0.00           H  
ATOM    311  N   PRO A  22       8.954  73.356  23.131  1.00  0.00           N  
ATOM    312  CA  PRO A  22       8.784  73.927  21.794  1.00  0.00           C  
ATOM    313  C   PRO A  22      10.093  74.033  21.022  1.00  0.00           C  
ATOM    314  O   PRO A  22      11.177  73.896  21.589  1.00  0.00           O  
ATOM    315  CB  PRO A  22       8.249  75.319  22.112  1.00  0.00           C  
ATOM    316  CG  PRO A  22       8.925  75.697  23.390  1.00  0.00           C  
ATOM    317  CD  PRO A  22       9.235  74.410  24.123  1.00  0.00           C  
ATOM    318  HA  PRO A  22       8.062  73.389  21.205  1.00  0.00           H  
ATOM    319  HB2 PRO A  22       8.506  75.998  21.311  1.00  0.00           H  
ATOM    320  HB3 PRO A  22       7.177  75.279  22.230  1.00  0.00           H  
ATOM    321  HG2 PRO A  22       9.839  76.230  23.174  1.00  0.00           H  
ATOM    322  HG3 PRO A  22       8.265  76.313  23.982  1.00  0.00           H  
ATOM    323  HD2 PRO A  22      10.272  74.387  24.422  1.00  0.00           H  
ATOM    324  HD3 PRO A  22       8.593  74.306  24.985  1.00  0.00           H  
ATOM    325  N   TYR A  23       9.977  74.285  19.724  1.00  0.00           N  
ATOM    326  CA  TYR A  23      11.143  74.423  18.860  1.00  0.00           C  
ATOM    327  C   TYR A  23      11.331  75.874  18.433  1.00  0.00           C  
ATOM    328  O   TYR A  23      11.828  76.153  17.342  1.00  0.00           O  
ATOM    329  CB  TYR A  23      10.999  73.531  17.626  1.00  0.00           C  
ATOM    330  CG  TYR A  23      10.895  72.061  17.957  1.00  0.00           C  
ATOM    331  CD1 TYR A  23      11.596  71.524  19.028  1.00  0.00           C  
ATOM    332  CD2 TYR A  23      10.095  71.213  17.203  1.00  0.00           C  
ATOM    333  CE1 TYR A  23      11.504  70.182  19.339  1.00  0.00           C  
ATOM    334  CE2 TYR A  23       9.997  69.868  17.508  1.00  0.00           C  
ATOM    335  CZ  TYR A  23      10.703  69.359  18.576  1.00  0.00           C  
ATOM    336  OH  TYR A  23      10.607  68.022  18.884  1.00  0.00           O  
ATOM    337  H   TYR A  23       9.081  74.387  19.339  1.00  0.00           H  
ATOM    338  HA  TYR A  23      12.010  74.109  19.420  1.00  0.00           H  
ATOM    339  HB2 TYR A  23      10.107  73.814  17.087  1.00  0.00           H  
ATOM    340  HB3 TYR A  23      11.859  73.669  16.987  1.00  0.00           H  
ATOM    341  HD1 TYR A  23      12.221  72.172  19.625  1.00  0.00           H  
ATOM    342  HD2 TYR A  23       9.544  71.615  16.366  1.00  0.00           H  
ATOM    343  HE1 TYR A  23      12.057  69.783  20.177  1.00  0.00           H  
ATOM    344  HE2 TYR A  23       9.370  69.224  16.910  1.00  0.00           H  
ATOM    345  HH  TYR A  23       9.702  67.730  18.755  1.00  0.00           H  
ATOM    346  N   ASP A  24      10.932  76.795  19.304  1.00  0.00           N  
ATOM    347  CA  ASP A  24      11.056  78.220  19.023  1.00  0.00           C  
ATOM    348  C   ASP A  24      12.315  78.808  19.665  1.00  0.00           C  
ATOM    349  O   ASP A  24      12.549  80.014  19.587  1.00  0.00           O  
ATOM    350  CB  ASP A  24       9.820  78.968  19.527  1.00  0.00           C  
ATOM    351  CG  ASP A  24       9.631  80.306  18.839  1.00  0.00           C  
ATOM    352  OD1 ASP A  24      10.375  81.253  19.168  1.00  0.00           O  
ATOM    353  OD2 ASP A  24       8.738  80.406  17.971  1.00  0.00           O  
ATOM    354  H   ASP A  24      10.547  76.509  20.158  1.00  0.00           H  
ATOM    355  HA  ASP A  24      11.124  78.341  17.953  1.00  0.00           H  
ATOM    356  HB2 ASP A  24       8.943  78.364  19.346  1.00  0.00           H  
ATOM    357  HB3 ASP A  24       9.919  79.141  20.589  1.00  0.00           H  
ATOM    358  N   ASP A  25      13.124  77.957  20.296  1.00  0.00           N  
ATOM    359  CA  ASP A  25      14.350  78.410  20.939  1.00  0.00           C  
ATOM    360  C   ASP A  25      15.270  77.232  21.241  1.00  0.00           C  
ATOM    361  O   ASP A  25      14.810  76.109  21.447  1.00  0.00           O  
ATOM    362  CB  ASP A  25      14.028  79.165  22.229  1.00  0.00           C  
ATOM    363  CG  ASP A  25      15.068  80.219  22.556  1.00  0.00           C  
ATOM    364  OD1 ASP A  25      15.204  81.183  21.774  1.00  0.00           O  
ATOM    365  OD2 ASP A  25      15.748  80.080  23.595  1.00  0.00           O  
ATOM    366  H   ASP A  25      12.895  77.006  20.329  1.00  0.00           H  
ATOM    367  HA  ASP A  25      14.853  79.079  20.257  1.00  0.00           H  
ATOM    368  HB2 ASP A  25      13.070  79.653  22.124  1.00  0.00           H  
ATOM    369  HB3 ASP A  25      13.982  78.464  23.048  1.00  0.00           H  
ATOM    370  N   LYS A  26      16.572  77.495  21.264  1.00  0.00           N  
ATOM    371  CA  LYS A  26      17.556  76.455  21.539  1.00  0.00           C  
ATOM    372  C   LYS A  26      17.222  75.718  22.832  1.00  0.00           C  
ATOM    373  O   LYS A  26      17.354  76.270  23.925  1.00  0.00           O  
ATOM    374  CB  LYS A  26      18.957  77.062  21.630  1.00  0.00           C  
ATOM    375  CG  LYS A  26      19.290  77.999  20.480  1.00  0.00           C  
ATOM    376  CD  LYS A  26      20.791  78.132  20.285  1.00  0.00           C  
ATOM    377  CE  LYS A  26      21.277  79.530  20.631  1.00  0.00           C  
ATOM    378  NZ  LYS A  26      22.171  80.085  19.579  1.00  0.00           N  
ATOM    379  H   LYS A  26      16.878  78.410  21.091  1.00  0.00           H  
ATOM    380  HA  LYS A  26      17.530  75.750  20.722  1.00  0.00           H  
ATOM    381  HB2 LYS A  26      19.038  77.616  22.553  1.00  0.00           H  
ATOM    382  HB3 LYS A  26      19.683  76.262  21.635  1.00  0.00           H  
ATOM    383  HG2 LYS A  26      18.852  77.609  19.573  1.00  0.00           H  
ATOM    384  HG3 LYS A  26      18.875  78.973  20.692  1.00  0.00           H  
ATOM    385  HD2 LYS A  26      21.292  77.420  20.923  1.00  0.00           H  
ATOM    386  HD3 LYS A  26      21.030  77.922  19.252  1.00  0.00           H  
ATOM    387  HE2 LYS A  26      20.419  80.177  20.741  1.00  0.00           H  
ATOM    388  HE3 LYS A  26      21.816  79.488  21.566  1.00  0.00           H  
ATOM    389  HZ1 LYS A  26      22.151  79.478  18.735  1.00  0.00           H  
ATOM    390  HZ2 LYS A  26      21.859  81.040  19.312  1.00  0.00           H  
ATOM    391  HZ3 LYS A  26      23.148  80.138  19.932  1.00  0.00           H  
ATOM    392  N   HIS A  27      16.789  74.469  22.702  1.00  0.00           N  
ATOM    393  CA  HIS A  27      16.436  73.657  23.860  1.00  0.00           C  
ATOM    394  C   HIS A  27      17.533  72.641  24.164  1.00  0.00           C  
ATOM    395  O   HIS A  27      17.742  71.693  23.408  1.00  0.00           O  
ATOM    396  CB  HIS A  27      15.109  72.935  23.619  1.00  0.00           C  
ATOM    397  CG  HIS A  27      14.382  72.578  24.879  1.00  0.00           C  
ATOM    398  ND1 HIS A  27      14.940  72.656  26.135  1.00  0.00           N  
ATOM    399  CD2 HIS A  27      13.113  72.133  25.059  1.00  0.00           C  
ATOM    400  CE1 HIS A  27      14.013  72.264  27.021  1.00  0.00           C  
ATOM    401  NE2 HIS A  27      12.886  71.937  26.419  1.00  0.00           N  
ATOM    402  H   HIS A  27      16.704  74.084  21.805  1.00  0.00           H  
ATOM    403  HA  HIS A  27      16.328  74.317  24.707  1.00  0.00           H  
ATOM    404  HB2 HIS A  27      14.462  73.572  23.033  1.00  0.00           H  
ATOM    405  HB3 HIS A  27      15.296  72.023  23.072  1.00  0.00           H  
ATOM    406  HD1 HIS A  27      15.852  72.945  26.345  1.00  0.00           H  
ATOM    407  HD2 HIS A  27      12.386  71.955  24.280  1.00  0.00           H  
ATOM    408  HE1 HIS A  27      14.169  72.224  28.089  1.00  0.00           H  
ATOM    409  N   THR A  28      18.231  72.848  25.276  1.00  0.00           N  
ATOM    410  CA  THR A  28      19.308  71.953  25.680  1.00  0.00           C  
ATOM    411  C   THR A  28      18.799  70.877  26.631  1.00  0.00           C  
ATOM    412  O   THR A  28      18.442  71.163  27.774  1.00  0.00           O  
ATOM    413  CB  THR A  28      20.435  72.745  26.344  1.00  0.00           C  
ATOM    414  OG1 THR A  28      20.922  73.751  25.474  1.00  0.00           O  
ATOM    415  CG2 THR A  28      21.609  71.883  26.754  1.00  0.00           C  
ATOM    416  H   THR A  28      18.018  73.623  25.836  1.00  0.00           H  
ATOM    417  HA  THR A  28      19.692  71.476  24.791  1.00  0.00           H  
ATOM    418  HB  THR A  28      20.049  73.223  27.233  1.00  0.00           H  
ATOM    419  HG1 THR A  28      20.185  74.261  25.130  1.00  0.00           H  
ATOM    420 HG21 THR A  28      21.906  71.260  25.923  1.00  0.00           H  
ATOM    421 HG22 THR A  28      22.436  72.515  27.043  1.00  0.00           H  
ATOM    422 HG23 THR A  28      21.324  71.259  27.588  1.00  0.00           H  
ATOM    423  N   TYR A  29      18.770  69.637  26.152  1.00  0.00           N  
ATOM    424  CA  TYR A  29      18.308  68.515  26.962  1.00  0.00           C  
ATOM    425  C   TYR A  29      19.463  67.903  27.747  1.00  0.00           C  
ATOM    426  O   TYR A  29      20.460  67.470  27.169  1.00  0.00           O  
ATOM    427  CB  TYR A  29      17.652  67.455  26.077  1.00  0.00           C  
ATOM    428  CG  TYR A  29      16.453  67.968  25.311  1.00  0.00           C  
ATOM    429  CD1 TYR A  29      16.612  68.653  24.114  1.00  0.00           C  
ATOM    430  CD2 TYR A  29      15.163  67.769  25.787  1.00  0.00           C  
ATOM    431  CE1 TYR A  29      15.520  69.126  23.412  1.00  0.00           C  
ATOM    432  CE2 TYR A  29      14.065  68.238  25.090  1.00  0.00           C  
ATOM    433  CZ  TYR A  29      14.249  68.916  23.904  1.00  0.00           C  
ATOM    434  OH  TYR A  29      13.160  69.386  23.207  1.00  0.00           O  
ATOM    435  H   TYR A  29      19.069  69.471  25.234  1.00  0.00           H  
ATOM    436  HA  TYR A  29      17.574  68.892  27.660  1.00  0.00           H  
ATOM    437  HB2 TYR A  29      18.375  67.097  25.359  1.00  0.00           H  
ATOM    438  HB3 TYR A  29      17.326  66.631  26.694  1.00  0.00           H  
ATOM    439  HD1 TYR A  29      17.608  68.816  23.731  1.00  0.00           H  
ATOM    440  HD2 TYR A  29      15.022  67.238  26.717  1.00  0.00           H  
ATOM    441  HE1 TYR A  29      15.665  69.657  22.482  1.00  0.00           H  
ATOM    442  HE2 TYR A  29      13.070  68.074  25.476  1.00  0.00           H  
ATOM    443  HH  TYR A  29      13.283  70.317  23.009  1.00  0.00           H  
ATOM    444  N   HIS A  30      19.325  67.880  29.067  1.00  0.00           N  
ATOM    445  CA  HIS A  30      20.358  67.331  29.936  1.00  0.00           C  
ATOM    446  C   HIS A  30      20.326  65.806  29.946  1.00  0.00           C  
ATOM    447  O   HIS A  30      19.272  65.196  30.126  1.00  0.00           O  
ATOM    448  CB  HIS A  30      20.189  67.862  31.361  1.00  0.00           C  
ATOM    449  CG  HIS A  30      20.426  69.335  31.484  1.00  0.00           C  
ATOM    450  ND1 HIS A  30      19.500  70.222  31.985  1.00  0.00           N  
ATOM    451  CD2 HIS A  30      21.517  70.075  31.162  1.00  0.00           C  
ATOM    452  CE1 HIS A  30      20.043  71.446  31.951  1.00  0.00           C  
ATOM    453  NE2 HIS A  30      21.267  71.411  31.461  1.00  0.00           N  
ATOM    454  H   HIS A  30      18.510  68.247  29.467  1.00  0.00           H  
ATOM    455  HA  HIS A  30      21.313  67.655  29.555  1.00  0.00           H  
ATOM    456  HB2 HIS A  30      19.183  67.660  31.696  1.00  0.00           H  
ATOM    457  HB3 HIS A  30      20.887  67.356  32.011  1.00  0.00           H  
ATOM    458  HD1 HIS A  30      18.602  69.998  32.308  1.00  0.00           H  
ATOM    459  HD2 HIS A  30      22.438  69.698  30.741  1.00  0.00           H  
ATOM    460  HE1 HIS A  30      19.544  72.345  32.282  1.00  0.00           H  
ATOM    461  N   ILE A  31      21.494  65.198  29.765  1.00  0.00           N  
ATOM    462  CA  ILE A  31      21.613  63.745  29.763  1.00  0.00           C  
ATOM    463  C   ILE A  31      22.434  63.275  30.959  1.00  0.00           C  
ATOM    464  O   ILE A  31      23.290  64.005  31.459  1.00  0.00           O  
ATOM    465  CB  ILE A  31      22.269  63.232  28.467  1.00  0.00           C  
ATOM    466  CG1 ILE A  31      21.643  63.915  27.249  1.00  0.00           C  
ATOM    467  CG2 ILE A  31      22.130  61.721  28.363  1.00  0.00           C  
ATOM    468  CD1 ILE A  31      22.227  63.456  25.930  1.00  0.00           C  
ATOM    469  H   ILE A  31      22.299  65.741  29.636  1.00  0.00           H  
ATOM    470  HA  ILE A  31      20.620  63.327  29.832  1.00  0.00           H  
ATOM    471  HB  ILE A  31      23.321  63.471  28.502  1.00  0.00           H  
ATOM    472 HG12 ILE A  31      20.584  63.706  27.232  1.00  0.00           H  
ATOM    473 HG13 ILE A  31      21.793  64.982  27.325  1.00  0.00           H  
ATOM    474 HG21 ILE A  31      21.082  61.454  28.375  1.00  0.00           H  
ATOM    475 HG22 ILE A  31      22.578  61.380  27.443  1.00  0.00           H  
ATOM    476 HG23 ILE A  31      22.628  61.256  29.201  1.00  0.00           H  
ATOM    477 HD11 ILE A  31      22.485  62.409  25.997  1.00  0.00           H  
ATOM    478 HD12 ILE A  31      21.498  63.598  25.145  1.00  0.00           H  
ATOM    479 HD13 ILE A  31      23.113  64.032  25.709  1.00  0.00           H  
ATOM    480  N   LYS A  32      22.166  62.059  31.421  1.00  0.00           N  
ATOM    481  CA  LYS A  32      22.881  61.508  32.566  1.00  0.00           C  
ATOM    482  C   LYS A  32      23.759  60.328  32.162  1.00  0.00           C  
ATOM    483  O   LYS A  32      23.272  59.329  31.634  1.00  0.00           O  
ATOM    484  CB  LYS A  32      21.891  61.073  33.648  1.00  0.00           C  
ATOM    485  CG  LYS A  32      21.211  62.237  34.352  1.00  0.00           C  
ATOM    486  CD  LYS A  32      20.088  62.817  33.508  1.00  0.00           C  
ATOM    487  CE  LYS A  32      18.985  63.404  34.375  1.00  0.00           C  
ATOM    488  NZ  LYS A  32      18.332  64.573  33.725  1.00  0.00           N  
ATOM    489  H   LYS A  32      21.469  61.523  30.987  1.00  0.00           H  
ATOM    490  HA  LYS A  32      23.513  62.287  32.965  1.00  0.00           H  
ATOM    491  HB2 LYS A  32      21.128  60.458  33.196  1.00  0.00           H  
ATOM    492  HB3 LYS A  32      22.419  60.491  34.390  1.00  0.00           H  
ATOM    493  HG2 LYS A  32      20.801  61.889  35.289  1.00  0.00           H  
ATOM    494  HG3 LYS A  32      21.943  63.008  34.541  1.00  0.00           H  
ATOM    495  HD2 LYS A  32      20.489  63.596  32.878  1.00  0.00           H  
ATOM    496  HD3 LYS A  32      19.671  62.033  32.893  1.00  0.00           H  
ATOM    497  HE2 LYS A  32      18.243  62.642  34.555  1.00  0.00           H  
ATOM    498  HE3 LYS A  32      19.414  63.719  35.315  1.00  0.00           H  
ATOM    499  HZ1 LYS A  32      17.918  64.291  32.814  1.00  0.00           H  
ATOM    500  HZ2 LYS A  32      17.575  64.944  34.335  1.00  0.00           H  
ATOM    501  HZ3 LYS A  32      19.029  65.326  33.558  1.00  0.00           H  
ATOM    502  N   ILE A  33      25.055  60.449  32.428  1.00  0.00           N  
ATOM    503  CA  ILE A  33      26.009  59.394  32.108  1.00  0.00           C  
ATOM    504  C   ILE A  33      26.802  58.997  33.347  1.00  0.00           C  
ATOM    505  O   ILE A  33      27.025  59.818  34.238  1.00  0.00           O  
ATOM    506  CB  ILE A  33      26.990  59.832  31.004  1.00  0.00           C  
ATOM    507  CG1 ILE A  33      26.224  60.345  29.783  1.00  0.00           C  
ATOM    508  CG2 ILE A  33      27.901  58.677  30.618  1.00  0.00           C  
ATOM    509  CD1 ILE A  33      27.082  61.144  28.826  1.00  0.00           C  
ATOM    510  H   ILE A  33      25.378  61.269  32.859  1.00  0.00           H  
ATOM    511  HA  ILE A  33      25.455  58.536  31.754  1.00  0.00           H  
ATOM    512  HB  ILE A  33      27.605  60.628  31.396  1.00  0.00           H  
ATOM    513 HG12 ILE A  33      25.820  59.504  29.241  1.00  0.00           H  
ATOM    514 HG13 ILE A  33      25.415  60.979  30.114  1.00  0.00           H  
ATOM    515 HG21 ILE A  33      27.305  57.799  30.419  1.00  0.00           H  
ATOM    516 HG22 ILE A  33      28.462  58.941  29.733  1.00  0.00           H  
ATOM    517 HG23 ILE A  33      28.584  58.472  31.430  1.00  0.00           H  
ATOM    518 HD11 ILE A  33      28.100  61.167  29.187  1.00  0.00           H  
ATOM    519 HD12 ILE A  33      27.056  60.685  27.849  1.00  0.00           H  
ATOM    520 HD13 ILE A  33      26.702  62.154  28.759  1.00  0.00           H  
ATOM    521  N   THR A  34      27.224  57.739  33.408  1.00  0.00           N  
ATOM    522  CA  THR A  34      27.988  57.255  34.552  1.00  0.00           C  
ATOM    523  C   THR A  34      28.970  56.165  34.143  1.00  0.00           C  
ATOM    524  O   THR A  34      28.686  55.354  33.261  1.00  0.00           O  
ATOM    525  CB  THR A  34      27.044  56.724  35.635  1.00  0.00           C  
ATOM    526  OG1 THR A  34      26.250  57.772  36.165  1.00  0.00           O  
ATOM    527  CG2 THR A  34      27.765  56.065  36.791  1.00  0.00           C  
ATOM    528  H   THR A  34      27.015  57.124  32.672  1.00  0.00           H  
ATOM    529  HA  THR A  34      28.543  58.090  34.953  1.00  0.00           H  
ATOM    530  HB  THR A  34      26.385  55.990  35.193  1.00  0.00           H  
ATOM    531  HG1 THR A  34      25.618  58.061  35.503  1.00  0.00           H  
ATOM    532 HG21 THR A  34      28.502  55.372  36.409  1.00  0.00           H  
ATOM    533 HG22 THR A  34      28.256  56.819  37.388  1.00  0.00           H  
ATOM    534 HG23 THR A  34      27.053  55.531  37.403  1.00  0.00           H  
ATOM    535  N   ASN A  35      30.123  56.147  34.803  1.00  0.00           N  
ATOM    536  CA  ASN A  35      31.147  55.152  34.524  1.00  0.00           C  
ATOM    537  C   ASN A  35      30.932  53.915  35.389  1.00  0.00           C  
ATOM    538  O   ASN A  35      31.181  53.937  36.594  1.00  0.00           O  
ATOM    539  CB  ASN A  35      32.540  55.732  34.778  1.00  0.00           C  
ATOM    540  CG  ASN A  35      33.629  54.959  34.059  1.00  0.00           C  
ATOM    541  OD1 ASN A  35      33.386  53.880  33.518  1.00  0.00           O  
ATOM    542  ND2 ASN A  35      34.838  55.510  34.050  1.00  0.00           N  
ATOM    543  H   ASN A  35      30.283  56.816  35.501  1.00  0.00           H  
ATOM    544  HA  ASN A  35      31.066  54.871  33.484  1.00  0.00           H  
ATOM    545  HB2 ASN A  35      32.565  56.756  34.436  1.00  0.00           H  
ATOM    546  HB3 ASN A  35      32.744  55.707  35.838  1.00  0.00           H  
ATOM    547 HD21 ASN A  35      34.958  56.371  34.500  1.00  0.00           H  
ATOM    548 HD22 ASN A  35      35.560  55.032  33.592  1.00  0.00           H  
ATOM    549  N   ALA A  36      30.463  52.841  34.768  1.00  0.00           N  
ATOM    550  CA  ALA A  36      30.207  51.596  35.481  1.00  0.00           C  
ATOM    551  C   ALA A  36      31.427  50.678  35.456  1.00  0.00           C  
ATOM    552  O   ALA A  36      31.310  49.470  35.658  1.00  0.00           O  
ATOM    553  CB  ALA A  36      29.002  50.890  34.883  1.00  0.00           C  
ATOM    554  H   ALA A  36      30.280  52.887  33.807  1.00  0.00           H  
ATOM    555  HA  ALA A  36      29.977  51.842  36.508  1.00  0.00           H  
ATOM    556  HB1 ALA A  36      28.225  51.613  34.682  1.00  0.00           H  
ATOM    557  HB2 ALA A  36      29.291  50.405  33.962  1.00  0.00           H  
ATOM    558  HB3 ALA A  36      28.636  50.150  35.579  1.00  0.00           H  
ATOM    559  N   GLY A  37      32.597  51.259  35.208  1.00  0.00           N  
ATOM    560  CA  GLY A  37      33.819  50.476  35.163  1.00  0.00           C  
ATOM    561  C   GLY A  37      34.676  50.671  36.397  1.00  0.00           C  
ATOM    562  O   GLY A  37      34.245  51.288  37.371  1.00  0.00           O  
ATOM    563  H   GLY A  37      32.632  52.224  35.055  1.00  0.00           H  
ATOM    564  HA2 GLY A  37      33.561  49.431  35.078  1.00  0.00           H  
ATOM    565  HA3 GLY A  37      34.387  50.769  34.292  1.00  0.00           H  
ATOM    566  N   GLY A  38      35.896  50.144  36.359  1.00  0.00           N  
ATOM    567  CA  GLY A  38      36.797  50.275  37.489  1.00  0.00           C  
ATOM    568  C   GLY A  38      37.758  51.436  37.333  1.00  0.00           C  
ATOM    569  O   GLY A  38      38.203  52.019  38.322  1.00  0.00           O  
ATOM    570  H   GLY A  38      36.187  49.663  35.556  1.00  0.00           H  
ATOM    571  HA2 GLY A  38      36.212  50.423  38.386  1.00  0.00           H  
ATOM    572  HA3 GLY A  38      37.365  49.362  37.590  1.00  0.00           H  
ATOM    573  N   ARG A  39      38.080  51.772  36.088  1.00  0.00           N  
ATOM    574  CA  ARG A  39      38.996  52.871  35.806  1.00  0.00           C  
ATOM    575  C   ARG A  39      38.335  53.915  34.911  1.00  0.00           C  
ATOM    576  O   ARG A  39      37.186  53.756  34.498  1.00  0.00           O  
ATOM    577  CB  ARG A  39      40.268  52.343  35.140  1.00  0.00           C  
ATOM    578  CG  ARG A  39      40.746  51.016  35.711  1.00  0.00           C  
ATOM    579  CD  ARG A  39      42.159  51.119  36.262  1.00  0.00           C  
ATOM    580  NE  ARG A  39      43.076  50.199  35.592  1.00  0.00           N  
ATOM    581  CZ  ARG A  39      44.300  49.927  36.035  1.00  0.00           C  
ATOM    582  NH1 ARG A  39      44.751  50.507  37.139  1.00  0.00           N  
ATOM    583  NH2 ARG A  39      45.073  49.078  35.373  1.00  0.00           N  
ATOM    584  H   ARG A  39      37.693  51.269  35.343  1.00  0.00           H  
ATOM    585  HA  ARG A  39      39.258  53.334  36.745  1.00  0.00           H  
ATOM    586  HB2 ARG A  39      40.079  52.209  34.085  1.00  0.00           H  
ATOM    587  HB3 ARG A  39      41.056  53.070  35.267  1.00  0.00           H  
ATOM    588  HG2 ARG A  39      40.082  50.718  36.508  1.00  0.00           H  
ATOM    589  HG3 ARG A  39      40.727  50.272  34.928  1.00  0.00           H  
ATOM    590  HD2 ARG A  39      42.515  52.129  36.125  1.00  0.00           H  
ATOM    591  HD3 ARG A  39      42.139  50.886  37.317  1.00  0.00           H  
ATOM    592  HE  ARG A  39      42.764  49.762  34.773  1.00  0.00           H  
ATOM    593 HH11 ARG A  39      44.172  51.149  37.640  1.00  0.00           H  
ATOM    594 HH12 ARG A  39      45.671  50.301  37.471  1.00  0.00           H  
ATOM    595 HH21 ARG A  39      44.736  48.641  34.540  1.00  0.00           H  
ATOM    596 HH22 ARG A  39      45.993  48.875  35.708  1.00  0.00           H  
ATOM    597  N   ARG A  40      39.068  54.984  34.615  1.00  0.00           N  
ATOM    598  CA  ARG A  40      38.551  56.053  33.768  1.00  0.00           C  
ATOM    599  C   ARG A  40      38.294  55.549  32.352  1.00  0.00           C  
ATOM    600  O   ARG A  40      38.675  54.433  32.003  1.00  0.00           O  
ATOM    601  CB  ARG A  40      39.531  57.227  33.736  1.00  0.00           C  
ATOM    602  CG  ARG A  40      40.938  56.836  33.317  1.00  0.00           C  
ATOM    603  CD  ARG A  40      41.988  57.591  34.118  1.00  0.00           C  
ATOM    604  NE  ARG A  40      42.250  56.961  35.407  1.00  0.00           N  
ATOM    605  CZ  ARG A  40      43.259  57.303  36.202  1.00  0.00           C  
ATOM    606  NH1 ARG A  40      44.093  58.267  35.839  1.00  0.00           N  
ATOM    607  NH2 ARG A  40      43.434  56.682  37.360  1.00  0.00           N  
ATOM    608  H   ARG A  40      39.977  55.055  34.973  1.00  0.00           H  
ATOM    609  HA  ARG A  40      37.616  56.387  34.194  1.00  0.00           H  
ATOM    610  HB2 ARG A  40      39.164  57.968  33.041  1.00  0.00           H  
ATOM    611  HB3 ARG A  40      39.581  57.667  34.723  1.00  0.00           H  
ATOM    612  HG2 ARG A  40      41.071  55.777  33.478  1.00  0.00           H  
ATOM    613  HG3 ARG A  40      41.067  57.062  32.269  1.00  0.00           H  
ATOM    614  HD2 ARG A  40      42.904  57.618  33.548  1.00  0.00           H  
ATOM    615  HD3 ARG A  40      41.638  58.599  34.284  1.00  0.00           H  
ATOM    616  HE  ARG A  40      41.645  56.245  35.695  1.00  0.00           H  
ATOM    617 HH11 ARG A  40      43.964  58.739  34.966  1.00  0.00           H  
ATOM    618 HH12 ARG A  40      44.852  58.525  36.438  1.00  0.00           H  
ATOM    619 HH21 ARG A  40      42.807  55.953  37.637  1.00  0.00           H  
ATOM    620 HH22 ARG A  40      44.194  56.940  37.957  1.00  0.00           H  
ATOM    621  N   ILE A  41      37.643  56.377  31.541  1.00  0.00           N  
ATOM    622  CA  ILE A  41      37.336  56.006  30.165  1.00  0.00           C  
ATOM    623  C   ILE A  41      37.216  57.231  29.266  1.00  0.00           C  
ATOM    624  O   ILE A  41      36.586  58.223  29.631  1.00  0.00           O  
ATOM    625  CB  ILE A  41      36.022  55.206  30.077  1.00  0.00           C  
ATOM    626  CG1 ILE A  41      34.862  56.022  30.653  1.00  0.00           C  
ATOM    627  CG2 ILE A  41      36.155  53.878  30.805  1.00  0.00           C  
ATOM    628  CD1 ILE A  41      33.570  55.243  30.759  1.00  0.00           C  
ATOM    629  H   ILE A  41      37.361  57.255  31.875  1.00  0.00           H  
ATOM    630  HA  ILE A  41      38.137  55.380  29.801  1.00  0.00           H  
ATOM    631  HB  ILE A  41      35.823  54.998  29.037  1.00  0.00           H  
ATOM    632 HG12 ILE A  41      35.127  56.363  31.643  1.00  0.00           H  
ATOM    633 HG13 ILE A  41      34.684  56.878  30.019  1.00  0.00           H  
ATOM    634 HG21 ILE A  41      37.157  53.495  30.677  1.00  0.00           H  
ATOM    635 HG22 ILE A  41      35.957  54.023  31.857  1.00  0.00           H  
ATOM    636 HG23 ILE A  41      35.444  53.174  30.398  1.00  0.00           H  
ATOM    637 HD11 ILE A  41      33.750  54.319  31.288  1.00  0.00           H  
ATOM    638 HD12 ILE A  41      32.839  55.829  31.296  1.00  0.00           H  
ATOM    639 HD13 ILE A  41      33.199  55.025  29.770  1.00  0.00           H  
ATOM    640  N   GLY A  42      37.810  57.145  28.080  1.00  0.00           N  
ATOM    641  CA  GLY A  42      37.743  58.243  27.136  1.00  0.00           C  
ATOM    642  C   GLY A  42      36.580  58.082  26.180  1.00  0.00           C  
ATOM    643  O   GLY A  42      36.567  57.166  25.358  1.00  0.00           O  
ATOM    644  H   GLY A  42      38.286  56.323  27.840  1.00  0.00           H  
ATOM    645  HA2 GLY A  42      37.629  59.169  27.680  1.00  0.00           H  
ATOM    646  HA3 GLY A  42      38.661  58.277  26.569  1.00  0.00           H  
ATOM    647  N   TRP A  43      35.589  58.961  26.296  1.00  0.00           N  
ATOM    648  CA  TRP A  43      34.410  58.889  25.440  1.00  0.00           C  
ATOM    649  C   TRP A  43      34.271  60.128  24.563  1.00  0.00           C  
ATOM    650  O   TRP A  43      34.791  61.197  24.882  1.00  0.00           O  
ATOM    651  CB  TRP A  43      33.154  58.713  26.294  1.00  0.00           C  
ATOM    652  CG  TRP A  43      32.925  59.839  27.256  1.00  0.00           C  
ATOM    653  CD1 TRP A  43      33.561  60.040  28.448  1.00  0.00           C  
ATOM    654  CD2 TRP A  43      31.995  60.917  27.109  1.00  0.00           C  
ATOM    655  NE1 TRP A  43      33.083  61.178  29.051  1.00  0.00           N  
ATOM    656  CE2 TRP A  43      32.122  61.734  28.249  1.00  0.00           C  
ATOM    657  CE3 TRP A  43      31.069  61.272  26.125  1.00  0.00           C  
ATOM    658  CZ2 TRP A  43      31.355  62.883  28.430  1.00  0.00           C  
ATOM    659  CZ3 TRP A  43      30.309  62.413  26.306  1.00  0.00           C  
ATOM    660  CH2 TRP A  43      30.457  63.207  27.450  1.00  0.00           C  
ATOM    661  H   TRP A  43      35.646  59.661  26.978  1.00  0.00           H  
ATOM    662  HA  TRP A  43      34.520  58.025  24.803  1.00  0.00           H  
ATOM    663  HB2 TRP A  43      32.292  58.650  25.646  1.00  0.00           H  
ATOM    664  HB3 TRP A  43      33.239  57.800  26.862  1.00  0.00           H  
ATOM    665  HD1 TRP A  43      34.326  59.390  28.846  1.00  0.00           H  
ATOM    666  HE1 TRP A  43      33.382  61.532  29.914  1.00  0.00           H  
ATOM    667  HE3 TRP A  43      30.941  60.673  25.235  1.00  0.00           H  
ATOM    668  HZ2 TRP A  43      31.458  63.507  29.307  1.00  0.00           H  
ATOM    669  HZ3 TRP A  43      29.589  62.704  25.556  1.00  0.00           H  
ATOM    670  HH2 TRP A  43      29.842  64.089  27.550  1.00  0.00           H  
ATOM    671  N   ALA A  44      33.552  59.966  23.457  1.00  0.00           N  
ATOM    672  CA  ALA A  44      33.317  61.053  22.517  1.00  0.00           C  
ATOM    673  C   ALA A  44      31.933  60.920  21.891  1.00  0.00           C  
ATOM    674  O   ALA A  44      31.387  59.819  21.801  1.00  0.00           O  
ATOM    675  CB  ALA A  44      34.390  61.062  21.438  1.00  0.00           C  
ATOM    676  H   ALA A  44      33.163  59.088  23.269  1.00  0.00           H  
ATOM    677  HA  ALA A  44      33.371  61.986  23.059  1.00  0.00           H  
ATOM    678  HB1 ALA A  44      35.152  60.337  21.682  1.00  0.00           H  
ATOM    679  HB2 ALA A  44      33.946  60.812  20.485  1.00  0.00           H  
ATOM    680  HB3 ALA A  44      34.835  62.045  21.380  1.00  0.00           H  
ATOM    681  N   ILE A  45      31.364  62.045  21.471  1.00  0.00           N  
ATOM    682  CA  ILE A  45      30.038  62.045  20.866  1.00  0.00           C  
ATOM    683  C   ILE A  45      30.087  62.485  19.406  1.00  0.00           C  
ATOM    684  O   ILE A  45      30.955  63.260  19.008  1.00  0.00           O  
ATOM    685  CB  ILE A  45      29.072  62.967  21.633  1.00  0.00           C  
ATOM    686  CG1 ILE A  45      29.153  62.690  23.135  1.00  0.00           C  
ATOM    687  CG2 ILE A  45      27.649  62.779  21.130  1.00  0.00           C  
ATOM    688  CD1 ILE A  45      28.583  61.346  23.534  1.00  0.00           C  
ATOM    689  H   ILE A  45      31.844  62.892  21.576  1.00  0.00           H  
ATOM    690  HA  ILE A  45      29.650  61.037  20.913  1.00  0.00           H  
ATOM    691  HB  ILE A  45      29.362  63.990  21.447  1.00  0.00           H  
ATOM    692 HG12 ILE A  45      30.188  62.714  23.444  1.00  0.00           H  
ATOM    693 HG13 ILE A  45      28.607  63.455  23.666  1.00  0.00           H  
ATOM    694 HG21 ILE A  45      27.362  61.745  21.242  1.00  0.00           H  
ATOM    695 HG22 ILE A  45      26.979  63.402  21.704  1.00  0.00           H  
ATOM    696 HG23 ILE A  45      27.596  63.058  20.088  1.00  0.00           H  
ATOM    697 HD11 ILE A  45      28.953  60.584  22.864  1.00  0.00           H  
ATOM    698 HD12 ILE A  45      28.881  61.113  24.545  1.00  0.00           H  
ATOM    699 HD13 ILE A  45      27.504  61.383  23.476  1.00  0.00           H  
ATOM    700  N   LYS A  46      29.140  61.986  18.617  1.00  0.00           N  
ATOM    701  CA  LYS A  46      29.061  62.324  17.200  1.00  0.00           C  
ATOM    702  C   LYS A  46      27.610  62.337  16.734  1.00  0.00           C  
ATOM    703  O   LYS A  46      26.857  61.398  16.989  1.00  0.00           O  
ATOM    704  CB  LYS A  46      29.865  61.327  16.366  1.00  0.00           C  
ATOM    705  CG  LYS A  46      31.340  61.272  16.733  1.00  0.00           C  
ATOM    706  CD  LYS A  46      32.208  61.025  15.510  1.00  0.00           C  
ATOM    707  CE  LYS A  46      33.320  62.055  15.399  1.00  0.00           C  
ATOM    708  NZ  LYS A  46      34.354  61.651  14.406  1.00  0.00           N  
ATOM    709  H   LYS A  46      28.475  61.376  18.998  1.00  0.00           H  
ATOM    710  HA  LYS A  46      29.479  63.311  17.071  1.00  0.00           H  
ATOM    711  HB2 LYS A  46      29.447  60.341  16.501  1.00  0.00           H  
ATOM    712  HB3 LYS A  46      29.787  61.602  15.325  1.00  0.00           H  
ATOM    713  HG2 LYS A  46      31.625  62.213  17.180  1.00  0.00           H  
ATOM    714  HG3 LYS A  46      31.494  60.472  17.442  1.00  0.00           H  
ATOM    715  HD2 LYS A  46      32.650  60.042  15.587  1.00  0.00           H  
ATOM    716  HD3 LYS A  46      31.591  61.076  14.625  1.00  0.00           H  
ATOM    717  HE2 LYS A  46      32.891  62.997  15.093  1.00  0.00           H  
ATOM    718  HE3 LYS A  46      33.786  62.169  16.366  1.00  0.00           H  
ATOM    719  HZ1 LYS A  46      33.933  61.033  13.682  1.00  0.00           H  
ATOM    720  HZ2 LYS A  46      34.749  62.492  13.939  1.00  0.00           H  
ATOM    721  HZ3 LYS A  46      35.123  61.136  14.880  1.00  0.00           H  
ATOM    722  N   THR A  47      27.221  63.409  16.054  1.00  0.00           N  
ATOM    723  CA  THR A  47      25.856  63.541  15.556  1.00  0.00           C  
ATOM    724  C   THR A  47      25.836  63.687  14.040  1.00  0.00           C  
ATOM    725  O   THR A  47      26.808  64.137  13.434  1.00  0.00           O  
ATOM    726  CB  THR A  47      25.171  64.744  16.206  1.00  0.00           C  
ATOM    727  OG1 THR A  47      25.755  65.955  15.760  1.00  0.00           O  
ATOM    728  CG2 THR A  47      25.241  64.729  17.718  1.00  0.00           C  
ATOM    729  H   THR A  47      27.865  64.127  15.882  1.00  0.00           H  
ATOM    730  HA  THR A  47      25.318  62.645  15.826  1.00  0.00           H  
ATOM    731  HB  THR A  47      24.128  64.747  15.924  1.00  0.00           H  
ATOM    732  HG1 THR A  47      26.712  65.884  15.802  1.00  0.00           H  
ATOM    733 HG21 THR A  47      26.273  64.657  18.029  1.00  0.00           H  
ATOM    734 HG22 THR A  47      24.810  65.639  18.108  1.00  0.00           H  
ATOM    735 HG23 THR A  47      24.691  63.880  18.095  1.00  0.00           H  
ATOM    736  N   THR A  48      24.718  63.300  13.432  1.00  0.00           N  
ATOM    737  CA  THR A  48      24.563  63.385  11.987  1.00  0.00           C  
ATOM    738  C   THR A  48      24.899  64.786  11.486  1.00  0.00           C  
ATOM    739  O   THR A  48      25.364  64.958  10.359  1.00  0.00           O  
ATOM    740  CB  THR A  48      23.136  63.015  11.585  1.00  0.00           C  
ATOM    741  OG1 THR A  48      22.201  63.517  12.525  1.00  0.00           O  
ATOM    742  CG2 THR A  48      22.914  61.522  11.461  1.00  0.00           C  
ATOM    743  H   THR A  48      23.978  62.950  13.969  1.00  0.00           H  
ATOM    744  HA  THR A  48      25.248  62.681  11.539  1.00  0.00           H  
ATOM    745  HB  THR A  48      22.920  63.461  10.626  1.00  0.00           H  
ATOM    746  HG1 THR A  48      22.161  62.932  13.285  1.00  0.00           H  
ATOM    747 HG21 THR A  48      23.831  61.001  11.696  1.00  0.00           H  
ATOM    748 HG22 THR A  48      22.140  61.216  12.150  1.00  0.00           H  
ATOM    749 HG23 THR A  48      22.612  61.286  10.452  1.00  0.00           H  
ATOM    750  N   ASN A  49      24.657  65.784  12.329  1.00  0.00           N  
ATOM    751  CA  ASN A  49      24.932  67.172  11.972  1.00  0.00           C  
ATOM    752  C   ASN A  49      25.543  67.925  13.149  1.00  0.00           C  
ATOM    753  O   ASN A  49      24.916  68.071  14.198  1.00  0.00           O  
ATOM    754  CB  ASN A  49      23.648  67.868  11.517  1.00  0.00           C  
ATOM    755  CG  ASN A  49      22.905  67.077  10.457  1.00  0.00           C  
ATOM    756  OD1 ASN A  49      22.908  67.440   9.281  1.00  0.00           O  
ATOM    757  ND2 ASN A  49      22.266  65.989  10.869  1.00  0.00           N  
ATOM    758  H   ASN A  49      24.284  65.583  13.214  1.00  0.00           H  
ATOM    759  HA  ASN A  49      25.638  67.171  11.156  1.00  0.00           H  
ATOM    760  HB2 ASN A  49      22.995  67.995  12.368  1.00  0.00           H  
ATOM    761  HB3 ASN A  49      23.895  68.837  11.111  1.00  0.00           H  
ATOM    762 HD21 ASN A  49      22.308  65.760  11.822  1.00  0.00           H  
ATOM    763 HD22 ASN A  49      21.777  65.460  10.205  1.00  0.00           H  
ATOM    764  N   MET A  50      26.771  68.402  12.967  1.00  0.00           N  
ATOM    765  CA  MET A  50      27.465  69.142  14.015  1.00  0.00           C  
ATOM    766  C   MET A  50      27.196  70.641  13.906  1.00  0.00           C  
ATOM    767  O   MET A  50      27.922  71.451  14.486  1.00  0.00           O  
ATOM    768  CB  MET A  50      28.969  68.877  13.942  1.00  0.00           C  
ATOM    769  CG  MET A  50      29.415  67.662  14.739  1.00  0.00           C  
ATOM    770  SD  MET A  50      30.065  68.096  16.363  1.00  0.00           S  
ATOM    771  CE  MET A  50      28.572  68.034  17.352  1.00  0.00           C  
ATOM    772  H   MET A  50      27.219  68.254  12.109  1.00  0.00           H  
ATOM    773  HA  MET A  50      27.094  68.791  14.966  1.00  0.00           H  
ATOM    774  HB2 MET A  50      29.248  68.726  12.910  1.00  0.00           H  
ATOM    775  HB3 MET A  50      29.494  69.741  14.323  1.00  0.00           H  
ATOM    776  HG2 MET A  50      28.568  67.004  14.870  1.00  0.00           H  
ATOM    777  HG3 MET A  50      30.184  67.147  14.184  1.00  0.00           H  
ATOM    778  HE1 MET A  50      28.039  67.118  17.141  1.00  0.00           H  
ATOM    779  HE2 MET A  50      28.832  68.066  18.399  1.00  0.00           H  
ATOM    780  HE3 MET A  50      27.945  68.880  17.110  1.00  0.00           H  
ATOM    781  N   ARG A  51      26.155  71.010  13.165  1.00  0.00           N  
ATOM    782  CA  ARG A  51      25.802  72.415  12.991  1.00  0.00           C  
ATOM    783  C   ARG A  51      24.522  72.751  13.748  1.00  0.00           C  
ATOM    784  O   ARG A  51      24.468  73.728  14.493  1.00  0.00           O  
ATOM    785  CB  ARG A  51      25.631  72.743  11.507  1.00  0.00           C  
ATOM    786  CG  ARG A  51      26.587  71.985  10.600  1.00  0.00           C  
ATOM    787  CD  ARG A  51      28.037  72.262  10.962  1.00  0.00           C  
ATOM    788  NE  ARG A  51      28.964  71.561  10.079  1.00  0.00           N  
ATOM    789  CZ  ARG A  51      30.282  71.727  10.112  1.00  0.00           C  
ATOM    790  NH1 ARG A  51      30.824  72.568  10.983  1.00  0.00           N  
ATOM    791  NH2 ARG A  51      31.058  71.053   9.275  1.00  0.00           N  
ATOM    792  H   ARG A  51      25.609  70.324  12.726  1.00  0.00           H  
ATOM    793  HA  ARG A  51      26.609  73.010  13.392  1.00  0.00           H  
ATOM    794  HB2 ARG A  51      24.621  72.500  11.211  1.00  0.00           H  
ATOM    795  HB3 ARG A  51      25.795  73.801  11.363  1.00  0.00           H  
ATOM    796  HG2 ARG A  51      26.398  70.927  10.699  1.00  0.00           H  
ATOM    797  HG3 ARG A  51      26.416  72.290   9.579  1.00  0.00           H  
ATOM    798  HD2 ARG A  51      28.218  73.325  10.887  1.00  0.00           H  
ATOM    799  HD3 ARG A  51      28.210  71.940  11.980  1.00  0.00           H  
ATOM    800  HE  ARG A  51      28.584  70.935   9.428  1.00  0.00           H  
ATOM    801 HH11 ARG A  51      30.242  73.079  11.614  1.00  0.00           H  
ATOM    802 HH12 ARG A  51      31.817  72.691  11.007  1.00  0.00           H  
ATOM    803 HH21 ARG A  51      30.652  70.419   8.617  1.00  0.00           H  
ATOM    804 HH22 ARG A  51      32.051  71.178   9.302  1.00  0.00           H  
ATOM    805  N   ARG A  52      23.493  71.934  13.549  1.00  0.00           N  
ATOM    806  CA  ARG A  52      22.212  72.143  14.213  1.00  0.00           C  
ATOM    807  C   ARG A  52      22.277  71.708  15.673  1.00  0.00           C  
ATOM    808  O   ARG A  52      21.894  72.457  16.571  1.00  0.00           O  
ATOM    809  CB  ARG A  52      21.107  71.372  13.489  1.00  0.00           C  
ATOM    810  CG  ARG A  52      20.647  72.031  12.199  1.00  0.00           C  
ATOM    811  CD  ARG A  52      19.623  73.123  12.465  1.00  0.00           C  
ATOM    812  NE  ARG A  52      20.206  74.457  12.360  1.00  0.00           N  
ATOM    813  CZ  ARG A  52      19.486  75.570  12.258  1.00  0.00           C  
ATOM    814  NH1 ARG A  52      18.162  75.504  12.245  1.00  0.00           N  
ATOM    815  NH2 ARG A  52      20.089  76.747  12.169  1.00  0.00           N  
ATOM    816  H   ARG A  52      23.598  71.171  12.943  1.00  0.00           H  
ATOM    817  HA  ARG A  52      21.987  73.199  14.173  1.00  0.00           H  
ATOM    818  HB2 ARG A  52      21.469  70.382  13.253  1.00  0.00           H  
ATOM    819  HB3 ARG A  52      20.255  71.286  14.147  1.00  0.00           H  
ATOM    820  HG2 ARG A  52      21.502  72.466  11.704  1.00  0.00           H  
ATOM    821  HG3 ARG A  52      20.203  71.281  11.561  1.00  0.00           H  
ATOM    822  HD2 ARG A  52      18.824  73.032  11.745  1.00  0.00           H  
ATOM    823  HD3 ARG A  52      19.227  72.991  13.461  1.00  0.00           H  
ATOM    824  HE  ARG A  52      21.184  74.528  12.365  1.00  0.00           H  
ATOM    825 HH11 ARG A  52      17.704  74.617  12.312  1.00  0.00           H  
ATOM    826 HH12 ARG A  52      17.620  76.342  12.169  1.00  0.00           H  
ATOM    827 HH21 ARG A  52      21.087  76.799  12.177  1.00  0.00           H  
ATOM    828 HH22 ARG A  52      19.545  77.583  12.092  1.00  0.00           H  
ATOM    829  N   LEU A  53      22.765  70.493  15.902  1.00  0.00           N  
ATOM    830  CA  LEU A  53      22.878  69.958  17.254  1.00  0.00           C  
ATOM    831  C   LEU A  53      24.217  70.334  17.881  1.00  0.00           C  
ATOM    832  O   LEU A  53      25.226  70.461  17.188  1.00  0.00           O  
ATOM    833  CB  LEU A  53      22.724  68.436  17.238  1.00  0.00           C  
ATOM    834  CG  LEU A  53      21.512  67.916  16.463  1.00  0.00           C  
ATOM    835  CD1 LEU A  53      21.858  66.627  15.734  1.00  0.00           C  
ATOM    836  CD2 LEU A  53      20.334  67.699  17.401  1.00  0.00           C  
ATOM    837  H   LEU A  53      23.054  69.943  15.144  1.00  0.00           H  
ATOM    838  HA  LEU A  53      22.084  70.385  17.846  1.00  0.00           H  
ATOM    839  HB2 LEU A  53      23.615  68.010  16.801  1.00  0.00           H  
ATOM    840  HB3 LEU A  53      22.644  68.093  18.258  1.00  0.00           H  
ATOM    841  HG  LEU A  53      21.223  68.650  15.725  1.00  0.00           H  
ATOM    842 HD11 LEU A  53      22.926  66.579  15.575  1.00  0.00           H  
ATOM    843 HD12 LEU A  53      21.545  65.782  16.330  1.00  0.00           H  
ATOM    844 HD13 LEU A  53      21.350  66.604  14.781  1.00  0.00           H  
ATOM    845 HD21 LEU A  53      20.661  67.823  18.424  1.00  0.00           H  
ATOM    846 HD22 LEU A  53      19.561  68.419  17.181  1.00  0.00           H  
ATOM    847 HD23 LEU A  53      19.946  66.700  17.266  1.00  0.00           H  
ATOM    848  N   SER A  54      24.217  70.506  19.199  1.00  0.00           N  
ATOM    849  CA  SER A  54      25.430  70.862  19.924  1.00  0.00           C  
ATOM    850  C   SER A  54      25.553  70.044  21.204  1.00  0.00           C  
ATOM    851  O   SER A  54      24.825  70.268  22.169  1.00  0.00           O  
ATOM    852  CB  SER A  54      25.435  72.354  20.258  1.00  0.00           C  
ATOM    853  OG  SER A  54      24.211  72.748  20.852  1.00  0.00           O  
ATOM    854  H   SER A  54      23.381  70.388  19.696  1.00  0.00           H  
ATOM    855  HA  SER A  54      26.273  70.642  19.287  1.00  0.00           H  
ATOM    856  HB2 SER A  54      26.239  72.563  20.947  1.00  0.00           H  
ATOM    857  HB3 SER A  54      25.582  72.923  19.351  1.00  0.00           H  
ATOM    858  HG  SER A  54      23.554  72.892  20.167  1.00  0.00           H  
ATOM    859  N   VAL A  55      26.481  69.093  21.202  1.00  0.00           N  
ATOM    860  CA  VAL A  55      26.703  68.240  22.358  1.00  0.00           C  
ATOM    861  C   VAL A  55      27.984  68.624  23.086  1.00  0.00           C  
ATOM    862  O   VAL A  55      29.076  68.559  22.519  1.00  0.00           O  
ATOM    863  CB  VAL A  55      26.784  66.755  21.955  1.00  0.00           C  
ATOM    864  CG1 VAL A  55      25.395  66.138  21.902  1.00  0.00           C  
ATOM    865  CG2 VAL A  55      27.500  66.591  20.622  1.00  0.00           C  
ATOM    866  H   VAL A  55      27.029  68.963  20.404  1.00  0.00           H  
ATOM    867  HA  VAL A  55      25.867  68.363  23.031  1.00  0.00           H  
ATOM    868  HB  VAL A  55      27.354  66.235  22.708  1.00  0.00           H  
ATOM    869 HG11 VAL A  55      24.860  66.378  22.809  1.00  0.00           H  
ATOM    870 HG12 VAL A  55      24.858  66.534  21.052  1.00  0.00           H  
ATOM    871 HG13 VAL A  55      25.481  65.066  21.807  1.00  0.00           H  
ATOM    872 HG21 VAL A  55      28.225  67.382  20.504  1.00  0.00           H  
ATOM    873 HG22 VAL A  55      28.003  65.635  20.598  1.00  0.00           H  
ATOM    874 HG23 VAL A  55      26.780  66.639  19.819  1.00  0.00           H  
ATOM    875  N   ASP A  56      27.848  69.028  24.344  1.00  0.00           N  
ATOM    876  CA  ASP A  56      28.999  69.425  25.146  1.00  0.00           C  
ATOM    877  C   ASP A  56      28.840  68.959  26.595  1.00  0.00           C  
ATOM    878  O   ASP A  56      27.762  69.088  27.176  1.00  0.00           O  
ATOM    879  CB  ASP A  56      29.177  70.944  25.103  1.00  0.00           C  
ATOM    880  CG  ASP A  56      28.887  71.525  23.732  1.00  0.00           C  
ATOM    881  OD1 ASP A  56      29.632  71.204  22.782  1.00  0.00           O  
ATOM    882  OD2 ASP A  56      27.916  72.301  23.609  1.00  0.00           O  
ATOM    883  H   ASP A  56      26.953  69.060  24.742  1.00  0.00           H  
ATOM    884  HA  ASP A  56      29.872  68.957  24.716  1.00  0.00           H  
ATOM    885  HB2 ASP A  56      28.504  71.399  25.814  1.00  0.00           H  
ATOM    886  HB3 ASP A  56      30.194  71.188  25.370  1.00  0.00           H  
ATOM    887  N   PRO A  57      29.911  68.410  27.210  1.00  0.00           N  
ATOM    888  CA  PRO A  57      31.218  68.233  26.562  1.00  0.00           C  
ATOM    889  C   PRO A  57      31.204  67.092  25.546  1.00  0.00           C  
ATOM    890  O   PRO A  57      30.716  66.000  25.838  1.00  0.00           O  
ATOM    891  CB  PRO A  57      32.144  67.896  27.730  1.00  0.00           C  
ATOM    892  CG  PRO A  57      31.258  67.241  28.730  1.00  0.00           C  
ATOM    893  CD  PRO A  57      29.917  67.914  28.599  1.00  0.00           C  
ATOM    894  HA  PRO A  57      31.548  69.144  26.086  1.00  0.00           H  
ATOM    895  HB2 PRO A  57      32.925  67.229  27.394  1.00  0.00           H  
ATOM    896  HB3 PRO A  57      32.580  68.802  28.122  1.00  0.00           H  
ATOM    897  HG2 PRO A  57      31.172  66.187  28.510  1.00  0.00           H  
ATOM    898  HG3 PRO A  57      31.655  67.387  29.723  1.00  0.00           H  
ATOM    899  HD2 PRO A  57      29.122  67.200  28.757  1.00  0.00           H  
ATOM    900  HD3 PRO A  57      29.837  68.732  29.300  1.00  0.00           H  
ATOM    901  N   PRO A  58      31.742  67.323  24.334  1.00  0.00           N  
ATOM    902  CA  PRO A  58      31.783  66.299  23.284  1.00  0.00           C  
ATOM    903  C   PRO A  58      32.654  65.110  23.673  1.00  0.00           C  
ATOM    904  O   PRO A  58      32.264  63.957  23.492  1.00  0.00           O  
ATOM    905  CB  PRO A  58      32.386  67.033  22.083  1.00  0.00           C  
ATOM    906  CG  PRO A  58      33.119  68.190  22.666  1.00  0.00           C  
ATOM    907  CD  PRO A  58      32.351  68.589  23.893  1.00  0.00           C  
ATOM    908  HA  PRO A  58      30.791  65.949  23.036  1.00  0.00           H  
ATOM    909  HB2 PRO A  58      33.053  66.370  21.551  1.00  0.00           H  
ATOM    910  HB3 PRO A  58      31.596  67.360  21.424  1.00  0.00           H  
ATOM    911  HG2 PRO A  58      34.124  67.893  22.931  1.00  0.00           H  
ATOM    912  HG3 PRO A  58      33.144  69.005  21.957  1.00  0.00           H  
ATOM    913  HD2 PRO A  58      33.019  68.980  24.647  1.00  0.00           H  
ATOM    914  HD3 PRO A  58      31.592  69.316  23.644  1.00  0.00           H  
ATOM    915  N   CYS A  59      33.834  65.401  24.208  1.00  0.00           N  
ATOM    916  CA  CYS A  59      34.763  64.358  24.623  1.00  0.00           C  
ATOM    917  C   CYS A  59      35.318  64.651  26.013  1.00  0.00           C  
ATOM    918  O   CYS A  59      35.470  65.809  26.400  1.00  0.00           O  
ATOM    919  CB  CYS A  59      35.910  64.237  23.619  1.00  0.00           C  
ATOM    920  SG  CYS A  59      36.999  65.679  23.567  1.00  0.00           S  
ATOM    921  H   CYS A  59      34.087  66.340  24.326  1.00  0.00           H  
ATOM    922  HA  CYS A  59      34.221  63.424  24.654  1.00  0.00           H  
ATOM    923  HB2 CYS A  59      36.514  63.379  23.873  1.00  0.00           H  
ATOM    924  HB3 CYS A  59      35.497  64.100  22.629  1.00  0.00           H  
ATOM    925  HG  CYS A  59      37.906  65.365  23.550  1.00  0.00           H  
ATOM    926  N   GLY A  60      35.618  63.594  26.760  1.00  0.00           N  
ATOM    927  CA  GLY A  60      36.152  63.760  28.099  1.00  0.00           C  
ATOM    928  C   GLY A  60      36.567  62.444  28.726  1.00  0.00           C  
ATOM    929  O   GLY A  60      36.358  61.379  28.145  1.00  0.00           O  
ATOM    930  H   GLY A  60      35.475  62.693  26.400  1.00  0.00           H  
ATOM    931  HA2 GLY A  60      37.013  64.411  28.053  1.00  0.00           H  
ATOM    932  HA3 GLY A  60      35.399  64.221  28.720  1.00  0.00           H  
ATOM    933  N   VAL A  61      37.156  62.517  29.914  1.00  0.00           N  
ATOM    934  CA  VAL A  61      37.600  61.323  30.620  1.00  0.00           C  
ATOM    935  C   VAL A  61      36.839  61.143  31.928  1.00  0.00           C  
ATOM    936  O   VAL A  61      37.043  61.891  32.885  1.00  0.00           O  
ATOM    937  CB  VAL A  61      39.110  61.379  30.921  1.00  0.00           C  
ATOM    938  CG1 VAL A  61      39.628  60.006  31.317  1.00  0.00           C  
ATOM    939  CG2 VAL A  61      39.872  61.919  29.720  1.00  0.00           C  
ATOM    940  H   VAL A  61      37.294  63.396  30.326  1.00  0.00           H  
ATOM    941  HA  VAL A  61      37.413  60.470  29.985  1.00  0.00           H  
ATOM    942  HB  VAL A  61      39.267  62.052  31.752  1.00  0.00           H  
ATOM    943 HG11 VAL A  61      38.954  59.247  30.949  1.00  0.00           H  
ATOM    944 HG12 VAL A  61      40.609  59.853  30.891  1.00  0.00           H  
ATOM    945 HG13 VAL A  61      39.689  59.941  32.394  1.00  0.00           H  
ATOM    946 HG21 VAL A  61      39.446  61.516  28.813  1.00  0.00           H  
ATOM    947 HG22 VAL A  61      39.802  62.996  29.704  1.00  0.00           H  
ATOM    948 HG23 VAL A  61      40.910  61.626  29.791  1.00  0.00           H  
ATOM    949  N   LEU A  62      35.960  60.147  31.964  1.00  0.00           N  
ATOM    950  CA  LEU A  62      35.168  59.869  33.156  1.00  0.00           C  
ATOM    951  C   LEU A  62      35.984  59.082  34.176  1.00  0.00           C  
ATOM    952  O   LEU A  62      36.972  58.437  33.828  1.00  0.00           O  
ATOM    953  CB  LEU A  62      33.902  59.094  32.784  1.00  0.00           C  
ATOM    954  CG  LEU A  62      32.588  59.808  33.106  1.00  0.00           C  
ATOM    955  CD1 LEU A  62      32.493  61.119  32.340  1.00  0.00           C  
ATOM    956  CD2 LEU A  62      31.403  58.912  32.784  1.00  0.00           C  
ATOM    957  H   LEU A  62      35.842  59.584  31.170  1.00  0.00           H  
ATOM    958  HA  LEU A  62      34.886  60.816  33.593  1.00  0.00           H  
ATOM    959  HB2 LEU A  62      33.928  58.893  31.723  1.00  0.00           H  
ATOM    960  HB3 LEU A  62      33.911  58.152  33.313  1.00  0.00           H  
ATOM    961  HG  LEU A  62      32.560  60.037  34.162  1.00  0.00           H  
ATOM    962 HD11 LEU A  62      33.463  61.374  31.941  1.00  0.00           H  
ATOM    963 HD12 LEU A  62      31.788  61.011  31.529  1.00  0.00           H  
ATOM    964 HD13 LEU A  62      32.160  61.902  33.005  1.00  0.00           H  
ATOM    965 HD21 LEU A  62      31.604  58.360  31.879  1.00  0.00           H  
ATOM    966 HD22 LEU A  62      31.242  58.222  33.599  1.00  0.00           H  
ATOM    967 HD23 LEU A  62      30.519  59.519  32.648  1.00  0.00           H  
ATOM    968  N   ASP A  63      35.562  59.139  35.435  1.00  0.00           N  
ATOM    969  CA  ASP A  63      36.254  58.429  36.505  1.00  0.00           C  
ATOM    970  C   ASP A  63      35.443  57.223  36.970  1.00  0.00           C  
ATOM    971  O   ASP A  63      34.285  57.059  36.587  1.00  0.00           O  
ATOM    972  CB  ASP A  63      36.515  59.369  37.685  1.00  0.00           C  
ATOM    973  CG  ASP A  63      37.993  59.635  37.895  1.00  0.00           C  
ATOM    974  OD1 ASP A  63      38.703  59.864  36.893  1.00  0.00           O  
ATOM    975  OD2 ASP A  63      38.440  59.613  39.061  1.00  0.00           O  
ATOM    976  H   ASP A  63      34.768  59.670  35.650  1.00  0.00           H  
ATOM    977  HA  ASP A  63      37.200  58.084  36.116  1.00  0.00           H  
ATOM    978  HB2 ASP A  63      36.022  60.312  37.502  1.00  0.00           H  
ATOM    979  HB3 ASP A  63      36.115  58.925  38.585  1.00  0.00           H  
ATOM    980  N   PRO A  64      36.042  56.358  37.806  1.00  0.00           N  
ATOM    981  CA  PRO A  64      35.368  55.161  38.323  1.00  0.00           C  
ATOM    982  C   PRO A  64      34.096  55.500  39.091  1.00  0.00           C  
ATOM    983  O   PRO A  64      34.151  56.067  40.183  1.00  0.00           O  
ATOM    984  CB  PRO A  64      36.406  54.535  39.261  1.00  0.00           C  
ATOM    985  CG  PRO A  64      37.715  55.095  38.819  1.00  0.00           C  
ATOM    986  CD  PRO A  64      37.419  56.477  38.314  1.00  0.00           C  
ATOM    987  HA  PRO A  64      35.132  54.468  37.528  1.00  0.00           H  
ATOM    988  HB2 PRO A  64      36.183  54.808  40.282  1.00  0.00           H  
ATOM    989  HB3 PRO A  64      36.384  53.459  39.159  1.00  0.00           H  
ATOM    990  HG2 PRO A  64      38.397  55.139  39.656  1.00  0.00           H  
ATOM    991  HG3 PRO A  64      38.128  54.487  38.028  1.00  0.00           H  
ATOM    992  HD2 PRO A  64      37.474  57.195  39.121  1.00  0.00           H  
ATOM    993  HD3 PRO A  64      38.101  56.744  37.520  1.00  0.00           H  
ATOM    994  N   LYS A  65      32.949  55.149  38.517  1.00  0.00           N  
ATOM    995  CA  LYS A  65      31.665  55.418  39.153  1.00  0.00           C  
ATOM    996  C   LYS A  65      31.432  56.920  39.294  1.00  0.00           C  
ATOM    997  O   LYS A  65      30.870  57.380  40.288  1.00  0.00           O  
ATOM    998  CB  LYS A  65      31.607  54.751  40.529  1.00  0.00           C  
ATOM    999  CG  LYS A  65      30.194  54.550  41.049  1.00  0.00           C  
ATOM   1000  CD  LYS A  65      30.165  53.580  42.220  1.00  0.00           C  
ATOM   1001  CE  LYS A  65      28.775  53.005  42.435  1.00  0.00           C  
ATOM   1002  NZ  LYS A  65      28.819  51.549  42.748  1.00  0.00           N  
ATOM   1003  H   LYS A  65      32.966  54.699  37.646  1.00  0.00           H  
ATOM   1004  HA  LYS A  65      30.890  55.002  38.527  1.00  0.00           H  
ATOM   1005  HB2 LYS A  65      32.086  53.785  40.467  1.00  0.00           H  
ATOM   1006  HB3 LYS A  65      32.145  55.365  41.236  1.00  0.00           H  
ATOM   1007  HG2 LYS A  65      29.801  55.502  41.374  1.00  0.00           H  
ATOM   1008  HG3 LYS A  65      29.580  54.157  40.253  1.00  0.00           H  
ATOM   1009  HD2 LYS A  65      30.852  52.771  42.021  1.00  0.00           H  
ATOM   1010  HD3 LYS A  65      30.472  54.102  43.114  1.00  0.00           H  
ATOM   1011  HE2 LYS A  65      28.306  53.526  43.256  1.00  0.00           H  
ATOM   1012  HE3 LYS A  65      28.195  53.154  41.535  1.00  0.00           H  
ATOM   1013  HZ1 LYS A  65      29.331  51.038  42.002  1.00  0.00           H  
ATOM   1014  HZ2 LYS A  65      29.303  51.394  43.655  1.00  0.00           H  
ATOM   1015  HZ3 LYS A  65      27.853  51.169  42.813  1.00  0.00           H  
ATOM   1016  N   GLU A  66      31.867  57.678  38.293  1.00  0.00           N  
ATOM   1017  CA  GLU A  66      31.709  59.123  38.302  1.00  0.00           C  
ATOM   1018  C   GLU A  66      30.515  59.531  37.432  1.00  0.00           C  
ATOM   1019  O   GLU A  66      30.271  58.942  36.379  1.00  0.00           O  
ATOM   1020  CB  GLU A  66      33.022  59.780  37.829  1.00  0.00           C  
ATOM   1021  CG  GLU A  66      32.856  61.046  36.998  1.00  0.00           C  
ATOM   1022  CD  GLU A  66      34.044  61.981  37.113  1.00  0.00           C  
ATOM   1023  OE1 GLU A  66      34.631  62.063  38.213  1.00  0.00           O  
ATOM   1024  OE2 GLU A  66      34.387  62.633  36.104  1.00  0.00           O  
ATOM   1025  H   GLU A  66      32.308  57.256  37.526  1.00  0.00           H  
ATOM   1026  HA  GLU A  66      31.513  59.424  39.321  1.00  0.00           H  
ATOM   1027  HB2 GLU A  66      33.612  60.030  38.697  1.00  0.00           H  
ATOM   1028  HB3 GLU A  66      33.570  59.060  37.237  1.00  0.00           H  
ATOM   1029  HG2 GLU A  66      32.736  60.763  35.964  1.00  0.00           H  
ATOM   1030  HG3 GLU A  66      31.971  61.565  37.334  1.00  0.00           H  
ATOM   1031  N   LYS A  67      29.779  60.542  37.883  1.00  0.00           N  
ATOM   1032  CA  LYS A  67      28.617  61.028  37.149  1.00  0.00           C  
ATOM   1033  C   LYS A  67      28.943  62.318  36.405  1.00  0.00           C  
ATOM   1034  O   LYS A  67      29.689  63.163  36.903  1.00  0.00           O  
ATOM   1035  CB  LYS A  67      27.444  61.257  38.104  1.00  0.00           C  
ATOM   1036  CG  LYS A  67      27.247  60.133  39.107  1.00  0.00           C  
ATOM   1037  CD  LYS A  67      25.924  60.265  39.843  1.00  0.00           C  
ATOM   1038  CE  LYS A  67      25.837  59.296  41.011  1.00  0.00           C  
ATOM   1039  NZ  LYS A  67      24.942  59.801  42.088  1.00  0.00           N  
ATOM   1040  H   LYS A  67      30.025  60.972  38.729  1.00  0.00           H  
ATOM   1041  HA  LYS A  67      28.341  60.273  36.429  1.00  0.00           H  
ATOM   1042  HB2 LYS A  67      27.613  62.174  38.650  1.00  0.00           H  
ATOM   1043  HB3 LYS A  67      26.537  61.357  37.524  1.00  0.00           H  
ATOM   1044  HG2 LYS A  67      27.263  59.189  38.583  1.00  0.00           H  
ATOM   1045  HG3 LYS A  67      28.053  60.161  39.825  1.00  0.00           H  
ATOM   1046  HD2 LYS A  67      25.830  61.274  40.218  1.00  0.00           H  
ATOM   1047  HD3 LYS A  67      25.117  60.058  39.154  1.00  0.00           H  
ATOM   1048  HE2 LYS A  67      25.455  58.352  40.651  1.00  0.00           H  
ATOM   1049  HE3 LYS A  67      26.828  59.151  41.415  1.00  0.00           H  
ATOM   1050  HZ1 LYS A  67      24.651  60.778  41.884  1.00  0.00           H  
ATOM   1051  HZ2 LYS A  67      24.093  59.205  42.157  1.00  0.00           H  
ATOM   1052  HZ3 LYS A  67      25.438  59.783  43.003  1.00  0.00           H  
ATOM   1053  N   VAL A  68      28.378  62.467  35.212  1.00  0.00           N  
ATOM   1054  CA  VAL A  68      28.604  63.654  34.399  1.00  0.00           C  
ATOM   1055  C   VAL A  68      27.330  64.074  33.676  1.00  0.00           C  
ATOM   1056  O   VAL A  68      26.499  63.236  33.323  1.00  0.00           O  
ATOM   1057  CB  VAL A  68      29.717  63.421  33.361  1.00  0.00           C  
ATOM   1058  CG1 VAL A  68      29.346  62.282  32.424  1.00  0.00           C  
ATOM   1059  CG2 VAL A  68      29.992  64.697  32.579  1.00  0.00           C  
ATOM   1060  H   VAL A  68      27.791  61.760  34.871  1.00  0.00           H  
ATOM   1061  HA  VAL A  68      28.915  64.454  35.057  1.00  0.00           H  
ATOM   1062  HB  VAL A  68      30.621  63.145  33.885  1.00  0.00           H  
ATOM   1063 HG11 VAL A  68      28.340  62.430  32.059  1.00  0.00           H  
ATOM   1064 HG12 VAL A  68      30.031  62.262  31.590  1.00  0.00           H  
ATOM   1065 HG13 VAL A  68      29.401  61.345  32.958  1.00  0.00           H  
ATOM   1066 HG21 VAL A  68      29.952  65.545  33.247  1.00  0.00           H  
ATOM   1067 HG22 VAL A  68      30.971  64.640  32.129  1.00  0.00           H  
ATOM   1068 HG23 VAL A  68      29.246  64.813  31.805  1.00  0.00           H  
ATOM   1069  N   LEU A  69      27.182  65.376  33.459  1.00  0.00           N  
ATOM   1070  CA  LEU A  69      26.006  65.908  32.779  1.00  0.00           C  
ATOM   1071  C   LEU A  69      26.341  66.309  31.346  1.00  0.00           C  
ATOM   1072  O   LEU A  69      27.434  66.803  31.066  1.00  0.00           O  
ATOM   1073  CB  LEU A  69      25.451  67.113  33.542  1.00  0.00           C  
ATOM   1074  CG  LEU A  69      24.176  66.843  34.341  1.00  0.00           C  
ATOM   1075  CD1 LEU A  69      23.085  66.295  33.434  1.00  0.00           C  
ATOM   1076  CD2 LEU A  69      24.456  65.879  35.483  1.00  0.00           C  
ATOM   1077  H   LEU A  69      27.878  65.994  33.766  1.00  0.00           H  
ATOM   1078  HA  LEU A  69      25.257  65.132  32.757  1.00  0.00           H  
ATOM   1079  HB2 LEU A  69      26.214  67.461  34.225  1.00  0.00           H  
ATOM   1080  HB3 LEU A  69      25.245  67.899  32.831  1.00  0.00           H  
ATOM   1081  HG  LEU A  69      23.822  67.772  34.765  1.00  0.00           H  
ATOM   1082 HD11 LEU A  69      23.335  66.501  32.404  1.00  0.00           H  
ATOM   1083 HD12 LEU A  69      22.999  65.228  33.578  1.00  0.00           H  
ATOM   1084 HD13 LEU A  69      22.144  66.769  33.677  1.00  0.00           H  
ATOM   1085 HD21 LEU A  69      25.029  65.041  35.113  1.00  0.00           H  
ATOM   1086 HD22 LEU A  69      25.018  66.387  36.254  1.00  0.00           H  
ATOM   1087 HD23 LEU A  69      23.523  65.523  35.892  1.00  0.00           H  
ATOM   1088  N   MET A  70      25.390  66.093  30.442  1.00  0.00           N  
ATOM   1089  CA  MET A  70      25.575  66.432  29.036  1.00  0.00           C  
ATOM   1090  C   MET A  70      24.526  67.439  28.584  1.00  0.00           C  
ATOM   1091  O   MET A  70      23.454  67.540  29.176  1.00  0.00           O  
ATOM   1092  CB  MET A  70      25.496  65.170  28.174  1.00  0.00           C  
ATOM   1093  CG  MET A  70      26.329  65.246  26.906  1.00  0.00           C  
ATOM   1094  SD  MET A  70      26.940  63.633  26.380  1.00  0.00           S  
ATOM   1095  CE  MET A  70      25.425  62.678  26.382  1.00  0.00           C  
ATOM   1096  H   MET A  70      24.541  65.698  30.730  1.00  0.00           H  
ATOM   1097  HA  MET A  70      26.553  66.874  28.924  1.00  0.00           H  
ATOM   1098  HB2 MET A  70      25.840  64.329  28.756  1.00  0.00           H  
ATOM   1099  HB3 MET A  70      24.465  65.004  27.893  1.00  0.00           H  
ATOM   1100  HG2 MET A  70      25.719  65.659  26.116  1.00  0.00           H  
ATOM   1101  HG3 MET A  70      27.174  65.895  27.084  1.00  0.00           H  
ATOM   1102  HE1 MET A  70      24.616  63.287  26.759  1.00  0.00           H  
ATOM   1103  HE2 MET A  70      25.198  62.363  25.374  1.00  0.00           H  
ATOM   1104  HE3 MET A  70      25.546  61.810  27.012  1.00  0.00           H  
ATOM   1105  N   ALA A  71      24.843  68.184  27.532  1.00  0.00           N  
ATOM   1106  CA  ALA A  71      23.925  69.186  27.004  1.00  0.00           C  
ATOM   1107  C   ALA A  71      23.765  69.048  25.494  1.00  0.00           C  
ATOM   1108  O   ALA A  71      24.709  69.271  24.736  1.00  0.00           O  
ATOM   1109  CB  ALA A  71      24.409  70.584  27.359  1.00  0.00           C  
ATOM   1110  H   ALA A  71      25.716  68.060  27.103  1.00  0.00           H  
ATOM   1111  HA  ALA A  71      22.963  69.036  27.473  1.00  0.00           H  
ATOM   1112  HB1 ALA A  71      25.475  70.565  27.529  1.00  0.00           H  
ATOM   1113  HB2 ALA A  71      24.186  71.260  26.546  1.00  0.00           H  
ATOM   1114  HB3 ALA A  71      23.908  70.922  28.254  1.00  0.00           H  
ATOM   1115  N   VAL A  72      22.561  68.684  25.063  1.00  0.00           N  
ATOM   1116  CA  VAL A  72      22.275  68.521  23.642  1.00  0.00           C  
ATOM   1117  C   VAL A  72      21.267  69.561  23.167  1.00  0.00           C  
ATOM   1118  O   VAL A  72      20.060  69.322  23.178  1.00  0.00           O  
ATOM   1119  CB  VAL A  72      21.732  67.112  23.334  1.00  0.00           C  
ATOM   1120  CG1 VAL A  72      20.461  66.845  24.126  1.00  0.00           C  
ATOM   1121  CG2 VAL A  72      21.483  66.950  21.842  1.00  0.00           C  
ATOM   1122  H   VAL A  72      21.847  68.523  25.717  1.00  0.00           H  
ATOM   1123  HA  VAL A  72      23.199  68.654  23.099  1.00  0.00           H  
ATOM   1124  HB  VAL A  72      22.475  66.388  23.634  1.00  0.00           H  
ATOM   1125 HG11 VAL A  72      20.297  67.650  24.826  1.00  0.00           H  
ATOM   1126 HG12 VAL A  72      19.622  66.779  23.449  1.00  0.00           H  
ATOM   1127 HG13 VAL A  72      20.563  65.913  24.664  1.00  0.00           H  
ATOM   1128 HG21 VAL A  72      22.164  67.582  21.293  1.00  0.00           H  
ATOM   1129 HG22 VAL A  72      21.642  65.918  21.561  1.00  0.00           H  
ATOM   1130 HG23 VAL A  72      20.466  67.233  21.613  1.00  0.00           H  
ATOM   1131  N   SER A  73      21.773  70.720  22.755  1.00  0.00           N  
ATOM   1132  CA  SER A  73      20.919  71.803  22.281  1.00  0.00           C  
ATOM   1133  C   SER A  73      20.463  71.560  20.847  1.00  0.00           C  
ATOM   1134  O   SER A  73      21.194  70.989  20.038  1.00  0.00           O  
ATOM   1135  CB  SER A  73      21.660  73.138  22.370  1.00  0.00           C  
ATOM   1136  OG  SER A  73      20.827  74.150  22.911  1.00  0.00           O  
ATOM   1137  H   SER A  73      22.743  70.850  22.775  1.00  0.00           H  
ATOM   1138  HA  SER A  73      20.050  71.842  22.920  1.00  0.00           H  
ATOM   1139  HB2 SER A  73      22.526  73.026  23.005  1.00  0.00           H  
ATOM   1140  HB3 SER A  73      21.976  73.439  21.382  1.00  0.00           H  
ATOM   1141  HG  SER A  73      21.360  74.915  23.139  1.00  0.00           H  
ATOM   1142  N   CYS A  74      19.247  72.002  20.540  1.00  0.00           N  
ATOM   1143  CA  CYS A  74      18.687  71.840  19.204  1.00  0.00           C  
ATOM   1144  C   CYS A  74      18.145  73.166  18.681  1.00  0.00           C  
ATOM   1145  O   CYS A  74      17.109  73.648  19.140  1.00  0.00           O  
ATOM   1146  CB  CYS A  74      17.574  70.789  19.217  1.00  0.00           C  
ATOM   1147  SG  CYS A  74      16.196  71.190  20.316  1.00  0.00           S  
ATOM   1148  H   CYS A  74      18.715  72.451  21.230  1.00  0.00           H  
ATOM   1149  HA  CYS A  74      19.479  71.505  18.550  1.00  0.00           H  
ATOM   1150  HB2 CYS A  74      17.177  70.684  18.218  1.00  0.00           H  
ATOM   1151  HB3 CYS A  74      17.987  69.843  19.536  1.00  0.00           H  
ATOM   1152  HG  CYS A  74      15.772  71.983  19.982  1.00  0.00           H  
ATOM   1153  N   ASP A  75      18.852  73.753  17.721  1.00  0.00           N  
ATOM   1154  CA  ASP A  75      18.443  75.025  17.138  1.00  0.00           C  
ATOM   1155  C   ASP A  75      16.989  74.977  16.682  1.00  0.00           C  
ATOM   1156  O   ASP A  75      16.502  73.937  16.235  1.00  0.00           O  
ATOM   1157  CB  ASP A  75      19.349  75.384  15.957  1.00  0.00           C  
ATOM   1158  CG  ASP A  75      20.524  76.247  16.371  1.00  0.00           C  
ATOM   1159  OD1 ASP A  75      20.314  77.450  16.638  1.00  0.00           O  
ATOM   1160  OD2 ASP A  75      21.655  75.721  16.430  1.00  0.00           O  
ATOM   1161  H   ASP A  75      19.671  73.320  17.398  1.00  0.00           H  
ATOM   1162  HA  ASP A  75      18.543  75.784  17.900  1.00  0.00           H  
ATOM   1163  HB2 ASP A  75      19.731  74.476  15.517  1.00  0.00           H  
ATOM   1164  HB3 ASP A  75      18.771  75.923  15.221  1.00  0.00           H  
ATOM   1165  N   THR A  76      16.301  76.108  16.795  1.00  0.00           N  
ATOM   1166  CA  THR A  76      14.904  76.200  16.392  1.00  0.00           C  
ATOM   1167  C   THR A  76      14.732  75.798  14.932  1.00  0.00           C  
ATOM   1168  O   THR A  76      15.704  75.735  14.178  1.00  0.00           O  
ATOM   1169  CB  THR A  76      14.384  77.620  16.605  1.00  0.00           C  
ATOM   1170  OG1 THR A  76      14.781  78.465  15.539  1.00  0.00           O  
ATOM   1171  CG2 THR A  76      14.865  78.250  17.895  1.00  0.00           C  
ATOM   1172  H   THR A  76      16.745  76.903  17.157  1.00  0.00           H  
ATOM   1173  HA  THR A  76      14.332  75.523  17.011  1.00  0.00           H  
ATOM   1174  HB  THR A  76      13.307  77.593  16.634  1.00  0.00           H  
ATOM   1175  HG1 THR A  76      15.720  78.358  15.378  1.00  0.00           H  
ATOM   1176 HG21 THR A  76      14.838  77.517  18.686  1.00  0.00           H  
ATOM   1177 HG22 THR A  76      15.877  78.605  17.767  1.00  0.00           H  
ATOM   1178 HG23 THR A  76      14.221  79.080  18.151  1.00  0.00           H  
ATOM   1179  N   PHE A  77      13.492  75.528  14.538  1.00  0.00           N  
ATOM   1180  CA  PHE A  77      13.195  75.134  13.165  1.00  0.00           C  
ATOM   1181  C   PHE A  77      11.697  74.916  12.975  1.00  0.00           C  
ATOM   1182  O   PHE A  77      10.901  75.190  13.873  1.00  0.00           O  
ATOM   1183  CB  PHE A  77      13.958  73.858  12.801  1.00  0.00           C  
ATOM   1184  CG  PHE A  77      13.448  72.632  13.502  1.00  0.00           C  
ATOM   1185  CD1 PHE A  77      13.707  72.428  14.848  1.00  0.00           C  
ATOM   1186  CD2 PHE A  77      12.708  71.682  12.814  1.00  0.00           C  
ATOM   1187  CE1 PHE A  77      13.240  71.301  15.495  1.00  0.00           C  
ATOM   1188  CE2 PHE A  77      12.238  70.553  13.457  1.00  0.00           C  
ATOM   1189  CZ  PHE A  77      12.504  70.362  14.798  1.00  0.00           C  
ATOM   1190  H   PHE A  77      12.759  75.596  15.184  1.00  0.00           H  
ATOM   1191  HA  PHE A  77      13.516  75.933  12.514  1.00  0.00           H  
ATOM   1192  HB2 PHE A  77      13.878  73.690  11.738  1.00  0.00           H  
ATOM   1193  HB3 PHE A  77      14.999  73.983  13.064  1.00  0.00           H  
ATOM   1194  HD1 PHE A  77      14.283  73.162  15.393  1.00  0.00           H  
ATOM   1195  HD2 PHE A  77      12.500  71.831  11.764  1.00  0.00           H  
ATOM   1196  HE1 PHE A  77      13.449  71.153  16.544  1.00  0.00           H  
ATOM   1197  HE2 PHE A  77      11.663  69.821  12.909  1.00  0.00           H  
ATOM   1198  HZ  PHE A  77      12.137  69.479  15.302  1.00  0.00           H  
ATOM   1199  N   ASN A  78      11.319  74.422  11.800  1.00  0.00           N  
ATOM   1200  CA  ASN A  78       9.916  74.169  11.493  1.00  0.00           C  
ATOM   1201  C   ASN A  78       9.667  72.681  11.269  1.00  0.00           C  
ATOM   1202  O   ASN A  78      10.098  72.113  10.266  1.00  0.00           O  
ATOM   1203  CB  ASN A  78       9.492  74.959  10.253  1.00  0.00           C  
ATOM   1204  CG  ASN A  78       8.933  76.325  10.601  1.00  0.00           C  
ATOM   1205  OD1 ASN A  78       8.132  76.464  11.526  1.00  0.00           O  
ATOM   1206  ND2 ASN A  78       9.352  77.343   9.857  1.00  0.00           N  
ATOM   1207  H   ASN A  78      12.000  74.224  11.124  1.00  0.00           H  
ATOM   1208  HA  ASN A  78       9.328  74.498  12.336  1.00  0.00           H  
ATOM   1209  HB2 ASN A  78      10.350  75.095   9.610  1.00  0.00           H  
ATOM   1210  HB3 ASN A  78       8.733  74.403   9.723  1.00  0.00           H  
ATOM   1211 HD21 ASN A  78       9.991  77.158   9.138  1.00  0.00           H  
ATOM   1212 HD22 ASN A  78       9.006  78.237  10.060  1.00  0.00           H  
ATOM   1213  N   ALA A  79       8.967  72.055  12.212  1.00  0.00           N  
ATOM   1214  CA  ALA A  79       8.660  70.632  12.115  1.00  0.00           C  
ATOM   1215  C   ALA A  79       7.293  70.397  11.476  1.00  0.00           C  
ATOM   1216  O   ALA A  79       6.728  69.309  11.585  1.00  0.00           O  
ATOM   1217  CB  ALA A  79       8.713  69.991  13.493  1.00  0.00           C  
ATOM   1218  H   ALA A  79       8.650  72.561  12.989  1.00  0.00           H  
ATOM   1219  HA  ALA A  79       9.418  70.168  11.501  1.00  0.00           H  
ATOM   1220  HB1 ALA A  79       8.144  70.588  14.190  1.00  0.00           H  
ATOM   1221  HB2 ALA A  79       8.292  68.997  13.443  1.00  0.00           H  
ATOM   1222  HB3 ALA A  79       9.739  69.931  13.824  1.00  0.00           H  
ATOM   1223  N   ALA A  80       6.765  71.420  10.807  1.00  0.00           N  
ATOM   1224  CA  ALA A  80       5.466  71.314  10.152  1.00  0.00           C  
ATOM   1225  C   ALA A  80       5.599  70.698   8.766  1.00  0.00           C  
ATOM   1226  O   ALA A  80       4.649  70.117   8.241  1.00  0.00           O  
ATOM   1227  CB  ALA A  80       4.812  72.684  10.057  1.00  0.00           C  
ATOM   1228  H   ALA A  80       7.259  72.262  10.750  1.00  0.00           H  
ATOM   1229  HA  ALA A  80       4.836  70.681  10.760  1.00  0.00           H  
ATOM   1230  HB1 ALA A  80       5.470  73.428  10.481  1.00  0.00           H  
ATOM   1231  HB2 ALA A  80       4.623  72.919   9.019  1.00  0.00           H  
ATOM   1232  HB3 ALA A  80       3.879  72.675  10.601  1.00  0.00           H  
ATOM   1233  N   THR A  81       6.781  70.833   8.174  1.00  0.00           N  
ATOM   1234  CA  THR A  81       7.035  70.294   6.844  1.00  0.00           C  
ATOM   1235  C   THR A  81       8.484  69.838   6.707  1.00  0.00           C  
ATOM   1236  O   THR A  81       9.140  70.116   5.703  1.00  0.00           O  
ATOM   1237  CB  THR A  81       6.712  71.345   5.786  1.00  0.00           C  
ATOM   1238  OG1 THR A  81       7.590  72.453   5.892  1.00  0.00           O  
ATOM   1239  CG2 THR A  81       5.296  71.865   5.890  1.00  0.00           C  
ATOM   1240  H   THR A  81       7.497  71.310   8.641  1.00  0.00           H  
ATOM   1241  HA  THR A  81       6.384  69.445   6.702  1.00  0.00           H  
ATOM   1242  HB  THR A  81       6.833  70.907   4.806  1.00  0.00           H  
ATOM   1243  HG1 THR A  81       7.641  72.904   5.045  1.00  0.00           H  
ATOM   1244 HG21 THR A  81       4.632  71.045   6.118  1.00  0.00           H  
ATOM   1245 HG22 THR A  81       5.240  72.602   6.679  1.00  0.00           H  
ATOM   1246 HG23 THR A  81       5.006  72.316   4.953  1.00  0.00           H  
ATOM   1247  N   GLU A  82       8.976  69.136   7.723  1.00  0.00           N  
ATOM   1248  CA  GLU A  82      10.347  68.641   7.717  1.00  0.00           C  
ATOM   1249  C   GLU A  82      10.425  67.246   8.332  1.00  0.00           C  
ATOM   1250  O   GLU A  82       9.918  67.011   9.429  1.00  0.00           O  
ATOM   1251  CB  GLU A  82      11.261  69.600   8.483  1.00  0.00           C  
ATOM   1252  CG  GLU A  82      11.504  70.915   7.761  1.00  0.00           C  
ATOM   1253  CD  GLU A  82      12.822  71.557   8.145  1.00  0.00           C  
ATOM   1254  OE1 GLU A  82      12.932  72.050   9.287  1.00  0.00           O  
ATOM   1255  OE2 GLU A  82      13.745  71.569   7.304  1.00  0.00           O  
ATOM   1256  H   GLU A  82       8.403  68.947   8.495  1.00  0.00           H  
ATOM   1257  HA  GLU A  82      10.676  68.587   6.691  1.00  0.00           H  
ATOM   1258  HB2 GLU A  82      10.812  69.818   9.441  1.00  0.00           H  
ATOM   1259  HB3 GLU A  82      12.215  69.120   8.643  1.00  0.00           H  
ATOM   1260  HG2 GLU A  82      11.508  70.732   6.696  1.00  0.00           H  
ATOM   1261  HG3 GLU A  82      10.703  71.598   8.004  1.00  0.00           H  
ATOM   1262  N   ASP A  83      11.062  66.325   7.617  1.00  0.00           N  
ATOM   1263  CA  ASP A  83      11.207  64.954   8.093  1.00  0.00           C  
ATOM   1264  C   ASP A  83      12.042  64.905   9.369  1.00  0.00           C  
ATOM   1265  O   ASP A  83      13.089  65.547   9.462  1.00  0.00           O  
ATOM   1266  CB  ASP A  83      11.852  64.083   7.014  1.00  0.00           C  
ATOM   1267  CG  ASP A  83      13.141  64.680   6.485  1.00  0.00           C  
ATOM   1268  OD1 ASP A  83      13.496  65.800   6.910  1.00  0.00           O  
ATOM   1269  OD2 ASP A  83      13.796  64.028   5.644  1.00  0.00           O  
ATOM   1270  H   ASP A  83      11.446  66.573   6.750  1.00  0.00           H  
ATOM   1271  HA  ASP A  83      10.220  64.572   8.309  1.00  0.00           H  
ATOM   1272  HB2 ASP A  83      12.072  63.111   7.428  1.00  0.00           H  
ATOM   1273  HB3 ASP A  83      11.163  63.972   6.190  1.00  0.00           H  
ATOM   1274  N   LEU A  84      11.573  64.139  10.348  1.00  0.00           N  
ATOM   1275  CA  LEU A  84      12.278  64.006  11.619  1.00  0.00           C  
ATOM   1276  C   LEU A  84      12.496  62.538  11.968  1.00  0.00           C  
ATOM   1277  O   LEU A  84      11.886  62.014  12.899  1.00  0.00           O  
ATOM   1278  CB  LEU A  84      11.493  64.696  12.737  1.00  0.00           C  
ATOM   1279  CG  LEU A  84      11.391  66.218  12.614  1.00  0.00           C  
ATOM   1280  CD1 LEU A  84      10.405  66.770  13.631  1.00  0.00           C  
ATOM   1281  CD2 LEU A  84      12.759  66.859  12.795  1.00  0.00           C  
ATOM   1282  H   LEU A  84      10.733  63.652  10.214  1.00  0.00           H  
ATOM   1283  HA  LEU A  84      13.239  64.487  11.515  1.00  0.00           H  
ATOM   1284  HB2 LEU A  84      10.493  64.289  12.750  1.00  0.00           H  
ATOM   1285  HB3 LEU A  84      11.970  64.465  13.678  1.00  0.00           H  
ATOM   1286  HG  LEU A  84      11.031  66.470  11.628  1.00  0.00           H  
ATOM   1287 HD11 LEU A  84       9.740  65.982  13.952  1.00  0.00           H  
ATOM   1288 HD12 LEU A  84      10.943  67.157  14.484  1.00  0.00           H  
ATOM   1289 HD13 LEU A  84       9.828  67.565  13.178  1.00  0.00           H  
ATOM   1290 HD21 LEU A  84      13.529  66.132  12.587  1.00  0.00           H  
ATOM   1291 HD22 LEU A  84      12.858  67.693  12.116  1.00  0.00           H  
ATOM   1292 HD23 LEU A  84      12.861  67.210  13.812  1.00  0.00           H  
ATOM   1293  N   ASN A  85      13.368  61.878  11.212  1.00  0.00           N  
ATOM   1294  CA  ASN A  85      13.663  60.469  11.442  1.00  0.00           C  
ATOM   1295  C   ASN A  85      15.043  60.106  10.903  1.00  0.00           C  
ATOM   1296  O   ASN A  85      15.286  58.966  10.510  1.00  0.00           O  
ATOM   1297  CB  ASN A  85      12.599  59.590  10.785  1.00  0.00           C  
ATOM   1298  CG  ASN A  85      12.569  58.189  11.363  1.00  0.00           C  
ATOM   1299  OD1 ASN A  85      12.026  57.962  12.443  1.00  0.00           O  
ATOM   1300  ND2 ASN A  85      13.155  57.239  10.643  1.00  0.00           N  
ATOM   1301  H   ASN A  85      13.821  62.349  10.483  1.00  0.00           H  
ATOM   1302  HA  ASN A  85      13.651  60.298  12.508  1.00  0.00           H  
ATOM   1303  HB2 ASN A  85      11.628  60.039  10.931  1.00  0.00           H  
ATOM   1304  HB3 ASN A  85      12.802  59.519   9.726  1.00  0.00           H  
ATOM   1305 HD21 ASN A  85      13.568  57.491   9.791  1.00  0.00           H  
ATOM   1306 HD22 ASN A  85      13.152  56.324  10.993  1.00  0.00           H  
ATOM   1307  N   ASN A  86      15.944  61.084  10.889  1.00  0.00           N  
ATOM   1308  CA  ASN A  86      17.300  60.866  10.398  1.00  0.00           C  
ATOM   1309  C   ASN A  86      18.348  61.385  11.386  1.00  0.00           C  
ATOM   1310  O   ASN A  86      19.541  61.391  11.083  1.00  0.00           O  
ATOM   1311  CB  ASN A  86      17.484  61.550   9.043  1.00  0.00           C  
ATOM   1312  CG  ASN A  86      16.466  61.086   8.019  1.00  0.00           C  
ATOM   1313  OD1 ASN A  86      15.836  61.897   7.341  1.00  0.00           O  
ATOM   1314  ND2 ASN A  86      16.301  59.773   7.901  1.00  0.00           N  
ATOM   1315  H   ASN A  86      15.690  61.972  11.216  1.00  0.00           H  
ATOM   1316  HA  ASN A  86      17.438  59.803  10.273  1.00  0.00           H  
ATOM   1317  HB2 ASN A  86      17.380  62.617   9.169  1.00  0.00           H  
ATOM   1318  HB3 ASN A  86      18.472  61.330   8.667  1.00  0.00           H  
ATOM   1319 HD21 ASN A  86      16.838  59.186   8.473  1.00  0.00           H  
ATOM   1320 HD22 ASN A  86      15.650  59.445   7.245  1.00  0.00           H  
ATOM   1321  N   ASP A  87      17.903  61.818  12.565  1.00  0.00           N  
ATOM   1322  CA  ASP A  87      18.816  62.332  13.580  1.00  0.00           C  
ATOM   1323  C   ASP A  87      19.186  61.244  14.582  1.00  0.00           C  
ATOM   1324  O   ASP A  87      18.322  60.694  15.267  1.00  0.00           O  
ATOM   1325  CB  ASP A  87      18.184  63.518  14.311  1.00  0.00           C  
ATOM   1326  CG  ASP A  87      18.492  64.841  13.640  1.00  0.00           C  
ATOM   1327  OD1 ASP A  87      19.638  65.321  13.771  1.00  0.00           O  
ATOM   1328  OD2 ASP A  87      17.588  65.399  12.983  1.00  0.00           O  
ATOM   1329  H   ASP A  87      16.945  61.792  12.758  1.00  0.00           H  
ATOM   1330  HA  ASP A  87      19.713  62.666  13.081  1.00  0.00           H  
ATOM   1331  HB2 ASP A  87      17.111  63.389  14.333  1.00  0.00           H  
ATOM   1332  HB3 ASP A  87      18.560  63.552  15.323  1.00  0.00           H  
ATOM   1333  N   ARG A  88      20.477  60.935  14.663  1.00  0.00           N  
ATOM   1334  CA  ARG A  88      20.961  59.911  15.581  1.00  0.00           C  
ATOM   1335  C   ARG A  88      22.327  60.284  16.149  1.00  0.00           C  
ATOM   1336  O   ARG A  88      23.211  60.732  15.419  1.00  0.00           O  
ATOM   1337  CB  ARG A  88      21.045  58.560  14.868  1.00  0.00           C  
ATOM   1338  CG  ARG A  88      22.015  58.553  13.699  1.00  0.00           C  
ATOM   1339  CD  ARG A  88      21.708  57.426  12.725  1.00  0.00           C  
ATOM   1340  NE  ARG A  88      22.877  56.590  12.471  1.00  0.00           N  
ATOM   1341  CZ  ARG A  88      23.876  56.945  11.670  1.00  0.00           C  
ATOM   1342  NH1 ARG A  88      23.848  58.117  11.049  1.00  0.00           N  
ATOM   1343  NH2 ARG A  88      24.906  56.130  11.488  1.00  0.00           N  
ATOM   1344  H   ARG A  88      21.119  61.407  14.092  1.00  0.00           H  
ATOM   1345  HA  ARG A  88      20.254  59.834  16.394  1.00  0.00           H  
ATOM   1346  HB2 ARG A  88      21.365  57.811  15.578  1.00  0.00           H  
ATOM   1347  HB3 ARG A  88      20.065  58.298  14.498  1.00  0.00           H  
ATOM   1348  HG2 ARG A  88      21.941  59.495  13.176  1.00  0.00           H  
ATOM   1349  HG3 ARG A  88      23.018  58.426  14.077  1.00  0.00           H  
ATOM   1350  HD2 ARG A  88      20.921  56.813  13.141  1.00  0.00           H  
ATOM   1351  HD3 ARG A  88      21.374  57.855  11.792  1.00  0.00           H  
ATOM   1352  HE  ARG A  88      22.918  55.720  12.920  1.00  0.00           H  
ATOM   1353 HH11 ARG A  88      23.074  58.735  11.185  1.00  0.00           H  
ATOM   1354 HH12 ARG A  88      24.601  58.382  10.448  1.00  0.00           H  
ATOM   1355 HH21 ARG A  88      24.931  55.245  11.954  1.00  0.00           H  
ATOM   1356 HH22 ARG A  88      25.656  56.399  10.884  1.00  0.00           H  
ATOM   1357  N   ILE A  89      22.492  60.092  17.453  1.00  0.00           N  
ATOM   1358  CA  ILE A  89      23.751  60.402  18.120  1.00  0.00           C  
ATOM   1359  C   ILE A  89      24.592  59.143  18.305  1.00  0.00           C  
ATOM   1360  O   ILE A  89      24.095  58.027  18.159  1.00  0.00           O  
ATOM   1361  CB  ILE A  89      23.510  61.056  19.497  1.00  0.00           C  
ATOM   1362  CG1 ILE A  89      22.360  62.061  19.417  1.00  0.00           C  
ATOM   1363  CG2 ILE A  89      24.778  61.735  19.992  1.00  0.00           C  
ATOM   1364  CD1 ILE A  89      22.042  62.721  20.740  1.00  0.00           C  
ATOM   1365  H   ILE A  89      21.750  59.728  17.980  1.00  0.00           H  
ATOM   1366  HA  ILE A  89      24.294  61.100  17.501  1.00  0.00           H  
ATOM   1367  HB  ILE A  89      23.250  60.278  20.199  1.00  0.00           H  
ATOM   1368 HG12 ILE A  89      22.618  62.838  18.712  1.00  0.00           H  
ATOM   1369 HG13 ILE A  89      21.469  61.552  19.075  1.00  0.00           H  
ATOM   1370 HG21 ILE A  89      25.395  62.006  19.147  1.00  0.00           H  
ATOM   1371 HG22 ILE A  89      24.519  62.624  20.546  1.00  0.00           H  
ATOM   1372 HG23 ILE A  89      25.323  61.057  20.633  1.00  0.00           H  
ATOM   1373 HD11 ILE A  89      22.960  62.907  21.279  1.00  0.00           H  
ATOM   1374 HD12 ILE A  89      21.533  63.657  20.562  1.00  0.00           H  
ATOM   1375 HD13 ILE A  89      21.408  62.071  21.324  1.00  0.00           H  
ATOM   1376  N   THR A  90      25.869  59.327  18.624  1.00  0.00           N  
ATOM   1377  CA  THR A  90      26.775  58.202  18.825  1.00  0.00           C  
ATOM   1378  C   THR A  90      27.670  58.436  20.038  1.00  0.00           C  
ATOM   1379  O   THR A  90      28.387  59.434  20.110  1.00  0.00           O  
ATOM   1380  CB  THR A  90      27.632  57.981  17.578  1.00  0.00           C  
ATOM   1381  OG1 THR A  90      26.813  57.799  16.435  1.00  0.00           O  
ATOM   1382  CG2 THR A  90      28.546  56.780  17.684  1.00  0.00           C  
ATOM   1383  H   THR A  90      26.212  60.240  18.725  1.00  0.00           H  
ATOM   1384  HA  THR A  90      26.174  57.322  19.000  1.00  0.00           H  
ATOM   1385  HB  THR A  90      28.248  58.853  17.418  1.00  0.00           H  
ATOM   1386  HG1 THR A  90      27.367  57.628  15.670  1.00  0.00           H  
ATOM   1387 HG21 THR A  90      28.322  56.235  18.589  1.00  0.00           H  
ATOM   1388 HG22 THR A  90      28.394  56.136  16.830  1.00  0.00           H  
ATOM   1389 HG23 THR A  90      29.574  57.110  17.707  1.00  0.00           H  
ATOM   1390  N   ILE A  91      27.622  57.508  20.989  1.00  0.00           N  
ATOM   1391  CA  ILE A  91      28.429  57.614  22.199  1.00  0.00           C  
ATOM   1392  C   ILE A  91      29.341  56.402  22.358  1.00  0.00           C  
ATOM   1393  O   ILE A  91      28.874  55.288  22.594  1.00  0.00           O  
ATOM   1394  CB  ILE A  91      27.544  57.742  23.455  1.00  0.00           C  
ATOM   1395  CG1 ILE A  91      26.442  58.777  23.226  1.00  0.00           C  
ATOM   1396  CG2 ILE A  91      28.392  58.118  24.661  1.00  0.00           C  
ATOM   1397  CD1 ILE A  91      25.214  58.212  22.546  1.00  0.00           C  
ATOM   1398  H   ILE A  91      27.032  56.735  20.874  1.00  0.00           H  
ATOM   1399  HA  ILE A  91      29.037  58.502  22.119  1.00  0.00           H  
ATOM   1400  HB  ILE A  91      27.092  56.781  23.649  1.00  0.00           H  
ATOM   1401 HG12 ILE A  91      26.135  59.182  24.179  1.00  0.00           H  
ATOM   1402 HG13 ILE A  91      26.828  59.575  22.609  1.00  0.00           H  
ATOM   1403 HG21 ILE A  91      29.417  57.828  24.486  1.00  0.00           H  
ATOM   1404 HG22 ILE A  91      28.342  59.186  24.817  1.00  0.00           H  
ATOM   1405 HG23 ILE A  91      28.017  57.608  25.537  1.00  0.00           H  
ATOM   1406 HD11 ILE A  91      25.485  57.324  21.993  1.00  0.00           H  
ATOM   1407 HD12 ILE A  91      24.473  57.961  23.291  1.00  0.00           H  
ATOM   1408 HD13 ILE A  91      24.809  58.948  21.868  1.00  0.00           H  
ATOM   1409  N   GLU A  92      30.645  56.628  22.231  1.00  0.00           N  
ATOM   1410  CA  GLU A  92      31.621  55.551  22.364  1.00  0.00           C  
ATOM   1411  C   GLU A  92      32.614  55.854  23.480  1.00  0.00           C  
ATOM   1412  O   GLU A  92      32.841  57.013  23.824  1.00  0.00           O  
ATOM   1413  CB  GLU A  92      32.366  55.341  21.044  1.00  0.00           C  
ATOM   1414  CG  GLU A  92      32.613  56.627  20.272  1.00  0.00           C  
ATOM   1415  CD  GLU A  92      33.331  56.389  18.957  1.00  0.00           C  
ATOM   1416  OE1 GLU A  92      33.231  55.265  18.421  1.00  0.00           O  
ATOM   1417  OE2 GLU A  92      33.994  57.327  18.465  1.00  0.00           O  
ATOM   1418  H   GLU A  92      30.957  57.539  22.045  1.00  0.00           H  
ATOM   1419  HA  GLU A  92      31.086  54.648  22.612  1.00  0.00           H  
ATOM   1420  HB2 GLU A  92      33.322  54.884  21.253  1.00  0.00           H  
ATOM   1421  HB3 GLU A  92      31.788  54.677  20.420  1.00  0.00           H  
ATOM   1422  HG2 GLU A  92      31.663  57.096  20.065  1.00  0.00           H  
ATOM   1423  HG3 GLU A  92      33.214  57.288  20.879  1.00  0.00           H  
ATOM   1424  N   TRP A  93      33.201  54.805  24.045  1.00  0.00           N  
ATOM   1425  CA  TRP A  93      34.170  54.965  25.124  1.00  0.00           C  
ATOM   1426  C   TRP A  93      35.082  53.747  25.226  1.00  0.00           C  
ATOM   1427  O   TRP A  93      34.667  52.622  24.951  1.00  0.00           O  
ATOM   1428  CB  TRP A  93      33.450  55.192  26.455  1.00  0.00           C  
ATOM   1429  CG  TRP A  93      32.700  53.989  26.940  1.00  0.00           C  
ATOM   1430  CD1 TRP A  93      33.045  53.168  27.976  1.00  0.00           C  
ATOM   1431  CD2 TRP A  93      31.475  53.472  26.407  1.00  0.00           C  
ATOM   1432  NE1 TRP A  93      32.109  52.173  28.118  1.00  0.00           N  
ATOM   1433  CE2 TRP A  93      31.136  52.337  27.168  1.00  0.00           C  
ATOM   1434  CE3 TRP A  93      30.633  53.860  25.361  1.00  0.00           C  
ATOM   1435  CZ2 TRP A  93      29.990  51.586  26.914  1.00  0.00           C  
ATOM   1436  CZ3 TRP A  93      29.495  53.113  25.111  1.00  0.00           C  
ATOM   1437  CH2 TRP A  93      29.183  51.988  25.885  1.00  0.00           C  
ATOM   1438  H   TRP A  93      32.978  53.905  23.729  1.00  0.00           H  
ATOM   1439  HA  TRP A  93      34.772  55.832  24.901  1.00  0.00           H  
ATOM   1440  HB2 TRP A  93      34.175  55.458  27.208  1.00  0.00           H  
ATOM   1441  HB3 TRP A  93      32.743  56.000  26.340  1.00  0.00           H  
ATOM   1442  HD1 TRP A  93      33.929  53.295  28.585  1.00  0.00           H  
ATOM   1443  HE1 TRP A  93      32.135  51.460  28.792  1.00  0.00           H  
ATOM   1444  HE3 TRP A  93      30.857  54.724  24.754  1.00  0.00           H  
ATOM   1445  HZ2 TRP A  93      29.734  50.718  27.501  1.00  0.00           H  
ATOM   1446  HZ3 TRP A  93      28.832  53.398  24.307  1.00  0.00           H  
ATOM   1447  HH2 TRP A  93      28.285  51.436  25.654  1.00  0.00           H  
ATOM   1448  N   THR A  94      36.329  53.983  25.623  1.00  0.00           N  
ATOM   1449  CA  THR A  94      37.305  52.907  25.762  1.00  0.00           C  
ATOM   1450  C   THR A  94      38.185  53.128  26.988  1.00  0.00           C  
ATOM   1451  O   THR A  94      38.676  54.232  27.221  1.00  0.00           O  
ATOM   1452  CB  THR A  94      38.174  52.813  24.507  1.00  0.00           C  
ATOM   1453  OG1 THR A  94      39.346  52.062  24.763  1.00  0.00           O  
ATOM   1454  CG2 THR A  94      38.601  54.164  23.973  1.00  0.00           C  
ATOM   1455  H   THR A  94      36.600  54.903  25.828  1.00  0.00           H  
ATOM   1456  HA  THR A  94      36.763  51.981  25.885  1.00  0.00           H  
ATOM   1457  HB  THR A  94      37.613  52.314  23.730  1.00  0.00           H  
ATOM   1458  HG1 THR A  94      39.110  51.149  24.946  1.00  0.00           H  
ATOM   1459 HG21 THR A  94      39.027  54.750  24.775  1.00  0.00           H  
ATOM   1460 HG22 THR A  94      39.340  54.027  23.197  1.00  0.00           H  
ATOM   1461 HG23 THR A  94      37.743  54.679  23.568  1.00  0.00           H  
ATOM   1462  N   ASN A  95      38.381  52.070  27.769  1.00  0.00           N  
ATOM   1463  CA  ASN A  95      39.203  52.150  28.971  1.00  0.00           C  
ATOM   1464  C   ASN A  95      40.573  52.739  28.656  1.00  0.00           C  
ATOM   1465  O   ASN A  95      41.287  52.246  27.782  1.00  0.00           O  
ATOM   1466  CB  ASN A  95      39.364  50.764  29.598  1.00  0.00           C  
ATOM   1467  CG  ASN A  95      39.711  49.703  28.572  1.00  0.00           C  
ATOM   1468  OD1 ASN A  95      40.587  49.899  27.731  1.00  0.00           O  
ATOM   1469  ND2 ASN A  95      39.022  48.570  28.637  1.00  0.00           N  
ATOM   1470  H   ASN A  95      37.962  51.216  27.532  1.00  0.00           H  
ATOM   1471  HA  ASN A  95      38.700  52.796  29.675  1.00  0.00           H  
ATOM   1472  HB2 ASN A  95      40.154  50.797  30.334  1.00  0.00           H  
ATOM   1473  HB3 ASN A  95      38.439  50.483  30.080  1.00  0.00           H  
ATOM   1474 HD21 ASN A  95      38.337  48.484  29.334  1.00  0.00           H  
ATOM   1475 HD22 ASN A  95      39.225  47.866  27.986  1.00  0.00           H  
ATOM   1476  N   THR A  96      40.934  53.800  29.372  1.00  0.00           N  
ATOM   1477  CA  THR A  96      42.219  54.459  29.169  1.00  0.00           C  
ATOM   1478  C   THR A  96      43.373  53.546  29.576  1.00  0.00           C  
ATOM   1479  O   THR A  96      43.222  52.693  30.451  1.00  0.00           O  
ATOM   1480  CB  THR A  96      42.282  55.760  29.971  1.00  0.00           C  
ATOM   1481  OG1 THR A  96      42.289  55.491  31.360  1.00  0.00           O  
ATOM   1482  CG2 THR A  96      41.127  56.696  29.690  1.00  0.00           C  
ATOM   1483  H   THR A  96      40.320  54.147  30.053  1.00  0.00           H  
ATOM   1484  HA  THR A  96      42.311  54.689  28.118  1.00  0.00           H  
ATOM   1485  HB  THR A  96      43.196  56.279  29.721  1.00  0.00           H  
ATOM   1486  HG1 THR A  96      43.190  55.521  31.689  1.00  0.00           H  
ATOM   1487 HG21 THR A  96      40.195  56.191  29.897  1.00  0.00           H  
ATOM   1488 HG22 THR A  96      41.211  57.569  30.320  1.00  0.00           H  
ATOM   1489 HG23 THR A  96      41.151  56.997  28.653  1.00  0.00           H  
ATOM   1490  N   PRO A  97      44.550  53.719  28.948  1.00  0.00           N  
ATOM   1491  CA  PRO A  97      45.735  52.910  29.255  1.00  0.00           C  
ATOM   1492  C   PRO A  97      46.275  53.190  30.650  1.00  0.00           C  
ATOM   1493  O   PRO A  97      45.918  54.185  31.279  1.00  0.00           O  
ATOM   1494  CB  PRO A  97      46.748  53.342  28.191  1.00  0.00           C  
ATOM   1495  CG  PRO A  97      46.316  54.708  27.785  1.00  0.00           C  
ATOM   1496  CD  PRO A  97      44.818  54.718  27.897  1.00  0.00           C  
ATOM   1497  HA  PRO A  97      45.532  51.854  29.157  1.00  0.00           H  
ATOM   1498  HB2 PRO A  97      47.741  53.351  28.620  1.00  0.00           H  
ATOM   1499  HB3 PRO A  97      46.716  52.655  27.360  1.00  0.00           H  
ATOM   1500  HG2 PRO A  97      46.747  55.443  28.449  1.00  0.00           H  
ATOM   1501  HG3 PRO A  97      46.617  54.900  26.766  1.00  0.00           H  
ATOM   1502  HD2 PRO A  97      44.468  55.695  28.195  1.00  0.00           H  
ATOM   1503  HD3 PRO A  97      44.367  54.422  26.961  1.00  0.00           H  
ATOM   1504  N   ASP A  98      47.140  52.303  31.129  1.00  0.00           N  
ATOM   1505  CA  ASP A  98      47.737  52.448  32.454  1.00  0.00           C  
ATOM   1506  C   ASP A  98      48.249  53.869  32.675  1.00  0.00           C  
ATOM   1507  O   ASP A  98      49.141  54.335  31.968  1.00  0.00           O  
ATOM   1508  CB  ASP A  98      48.885  51.452  32.627  1.00  0.00           C  
ATOM   1509  CG  ASP A  98      48.395  50.064  32.992  1.00  0.00           C  
ATOM   1510  OD1 ASP A  98      47.285  49.693  32.556  1.00  0.00           O  
ATOM   1511  OD2 ASP A  98      49.123  49.347  33.710  1.00  0.00           O  
ATOM   1512  H   ASP A  98      47.382  51.531  30.576  1.00  0.00           H  
ATOM   1513  HA  ASP A  98      46.974  52.234  33.188  1.00  0.00           H  
ATOM   1514  HB2 ASP A  98      49.438  51.388  31.703  1.00  0.00           H  
ATOM   1515  HB3 ASP A  98      49.540  51.801  33.412  1.00  0.00           H  
ATOM   1516  N   GLY A  99      47.673  54.555  33.659  1.00  0.00           N  
ATOM   1517  CA  GLY A  99      48.084  55.917  33.948  1.00  0.00           C  
ATOM   1518  C   GLY A  99      48.079  56.792  32.711  1.00  0.00           C  
ATOM   1519  O   GLY A  99      49.042  57.514  32.448  1.00  0.00           O  
ATOM   1520  H   GLY A  99      46.965  54.134  34.189  1.00  0.00           H  
ATOM   1521  HA2 GLY A  99      47.409  56.338  34.678  1.00  0.00           H  
ATOM   1522  HA3 GLY A  99      49.082  55.901  34.362  1.00  0.00           H  
ATOM   1523  N   ALA A 100      46.994  56.724  31.947  1.00  0.00           N  
ATOM   1524  CA  ALA A 100      46.864  57.512  30.728  1.00  0.00           C  
ATOM   1525  C   ALA A 100      47.083  58.996  31.001  1.00  0.00           C  
ATOM   1526  O   ALA A 100      47.080  59.434  32.151  1.00  0.00           O  
ATOM   1527  CB  ALA A 100      45.498  57.285  30.098  1.00  0.00           C  
ATOM   1528  H   ALA A 100      46.263  56.127  32.210  1.00  0.00           H  
ATOM   1529  HA  ALA A 100      47.615  57.169  30.030  1.00  0.00           H  
ATOM   1530  HB1 ALA A 100      45.152  56.290  30.337  1.00  0.00           H  
ATOM   1531  HB2 ALA A 100      44.799  58.012  30.484  1.00  0.00           H  
ATOM   1532  HB3 ALA A 100      45.574  57.392  29.026  1.00  0.00           H  
ATOM   1533  N   ALA A 101      47.272  59.763  29.932  1.00  0.00           N  
ATOM   1534  CA  ALA A 101      47.491  61.200  30.049  1.00  0.00           C  
ATOM   1535  C   ALA A 101      46.190  61.937  30.321  1.00  0.00           C  
ATOM   1536  O   ALA A 101      45.102  61.393  30.134  1.00  0.00           O  
ATOM   1537  CB  ALA A 101      48.139  61.742  28.786  1.00  0.00           C  
ATOM   1538  H   ALA A 101      47.263  59.354  29.043  1.00  0.00           H  
ATOM   1539  HA  ALA A 101      48.167  61.375  30.873  1.00  0.00           H  
ATOM   1540  HB1 ALA A 101      47.581  61.408  27.923  1.00  0.00           H  
ATOM   1541  HB2 ALA A 101      48.138  62.822  28.817  1.00  0.00           H  
ATOM   1542  HB3 ALA A 101      49.156  61.385  28.718  1.00  0.00           H  
ATOM   1543  N   LYS A 102      46.316  63.179  30.760  1.00  0.00           N  
ATOM   1544  CA  LYS A 102      45.153  64.005  31.056  1.00  0.00           C  
ATOM   1545  C   LYS A 102      44.690  64.744  29.809  1.00  0.00           C  
ATOM   1546  O   LYS A 102      44.816  65.965  29.707  1.00  0.00           O  
ATOM   1547  CB  LYS A 102      45.469  65.000  32.174  1.00  0.00           C  
ATOM   1548  CG  LYS A 102      45.106  64.494  33.561  1.00  0.00           C  
ATOM   1549  CD  LYS A 102      44.310  65.526  34.342  1.00  0.00           C  
ATOM   1550  CE  LYS A 102      45.207  66.624  34.889  1.00  0.00           C  
ATOM   1551  NZ  LYS A 102      44.664  67.981  34.602  1.00  0.00           N  
ATOM   1552  H   LYS A 102      47.214  63.551  30.884  1.00  0.00           H  
ATOM   1553  HA  LYS A 102      44.359  63.350  31.378  1.00  0.00           H  
ATOM   1554  HB2 LYS A 102      46.527  65.217  32.158  1.00  0.00           H  
ATOM   1555  HB3 LYS A 102      44.921  65.914  31.993  1.00  0.00           H  
ATOM   1556  HG2 LYS A 102      44.514  63.596  33.462  1.00  0.00           H  
ATOM   1557  HG3 LYS A 102      46.015  64.269  34.100  1.00  0.00           H  
ATOM   1558  HD2 LYS A 102      43.574  65.968  33.689  1.00  0.00           H  
ATOM   1559  HD3 LYS A 102      43.814  65.034  35.167  1.00  0.00           H  
ATOM   1560  HE2 LYS A 102      45.296  66.501  35.958  1.00  0.00           H  
ATOM   1561  HE3 LYS A 102      46.183  66.534  34.434  1.00  0.00           H  
ATOM   1562  HZ1 LYS A 102      44.432  68.068  33.592  1.00  0.00           H  
ATOM   1563  HZ2 LYS A 102      43.801  68.145  35.159  1.00  0.00           H  
ATOM   1564  HZ3 LYS A 102      45.366  68.707  34.851  1.00  0.00           H  
ATOM   1565  N   GLN A 103      44.154  63.986  28.864  1.00  0.00           N  
ATOM   1566  CA  GLN A 103      43.664  64.547  27.610  1.00  0.00           C  
ATOM   1567  C   GLN A 103      43.212  63.443  26.659  1.00  0.00           C  
ATOM   1568  O   GLN A 103      43.986  62.546  26.322  1.00  0.00           O  
ATOM   1569  CB  GLN A 103      44.750  65.397  26.946  1.00  0.00           C  
ATOM   1570  CG  GLN A 103      44.490  66.892  27.030  1.00  0.00           C  
ATOM   1571  CD  GLN A 103      44.545  67.570  25.675  1.00  0.00           C  
ATOM   1572  OE1 GLN A 103      44.223  66.967  24.652  1.00  0.00           O  
ATOM   1573  NE2 GLN A 103      44.956  68.834  25.662  1.00  0.00           N  
ATOM   1574  H   GLN A 103      44.088  63.020  29.015  1.00  0.00           H  
ATOM   1575  HA  GLN A 103      42.817  65.177  27.838  1.00  0.00           H  
ATOM   1576  HB2 GLN A 103      45.696  65.190  27.424  1.00  0.00           H  
ATOM   1577  HB3 GLN A 103      44.817  65.123  25.903  1.00  0.00           H  
ATOM   1578  HG2 GLN A 103      43.510  67.050  27.455  1.00  0.00           H  
ATOM   1579  HG3 GLN A 103      45.236  67.338  27.671  1.00  0.00           H  
ATOM   1580 HE21 GLN A 103      45.196  69.251  26.516  1.00  0.00           H  
ATOM   1581 HE22 GLN A 103      45.002  69.297  24.800  1.00  0.00           H  
ATOM   1582  N   PHE A 104      41.955  63.513  26.235  1.00  0.00           N  
ATOM   1583  CA  PHE A 104      41.397  62.518  25.324  1.00  0.00           C  
ATOM   1584  C   PHE A 104      42.308  62.306  24.119  1.00  0.00           C  
ATOM   1585  O   PHE A 104      42.610  63.247  23.383  1.00  0.00           O  
ATOM   1586  CB  PHE A 104      40.007  62.950  24.856  1.00  0.00           C  
ATOM   1587  CG  PHE A 104      39.379  61.996  23.881  1.00  0.00           C  
ATOM   1588  CD1 PHE A 104      39.627  62.112  22.522  1.00  0.00           C  
ATOM   1589  CD2 PHE A 104      38.542  60.984  24.322  1.00  0.00           C  
ATOM   1590  CE1 PHE A 104      39.051  61.235  21.621  1.00  0.00           C  
ATOM   1591  CE2 PHE A 104      37.964  60.104  23.427  1.00  0.00           C  
ATOM   1592  CZ  PHE A 104      38.219  60.230  22.076  1.00  0.00           C  
ATOM   1593  H   PHE A 104      41.388  64.251  26.541  1.00  0.00           H  
ATOM   1594  HA  PHE A 104      41.313  61.587  25.864  1.00  0.00           H  
ATOM   1595  HB2 PHE A 104      39.354  63.025  25.713  1.00  0.00           H  
ATOM   1596  HB3 PHE A 104      40.079  63.917  24.379  1.00  0.00           H  
ATOM   1597  HD1 PHE A 104      40.278  62.897  22.167  1.00  0.00           H  
ATOM   1598  HD2 PHE A 104      38.343  60.886  25.379  1.00  0.00           H  
ATOM   1599  HE1 PHE A 104      39.252  61.335  20.565  1.00  0.00           H  
ATOM   1600  HE2 PHE A 104      37.314  59.319  23.784  1.00  0.00           H  
ATOM   1601  HZ  PHE A 104      37.768  59.543  21.374  1.00  0.00           H  
ATOM   1602  N   ARG A 105      42.739  61.064  23.919  1.00  0.00           N  
ATOM   1603  CA  ARG A 105      43.612  60.729  22.800  1.00  0.00           C  
ATOM   1604  C   ARG A 105      42.930  59.744  21.856  1.00  0.00           C  
ATOM   1605  O   ARG A 105      42.096  58.942  22.277  1.00  0.00           O  
ATOM   1606  CB  ARG A 105      44.929  60.138  23.309  1.00  0.00           C  
ATOM   1607  CG  ARG A 105      46.139  60.556  22.491  1.00  0.00           C  
ATOM   1608  CD  ARG A 105      47.436  60.255  23.222  1.00  0.00           C  
ATOM   1609  NE  ARG A 105      48.595  60.322  22.335  1.00  0.00           N  
ATOM   1610  CZ  ARG A 105      49.090  61.458  21.854  1.00  0.00           C  
ATOM   1611  NH1 ARG A 105      48.529  62.616  22.173  1.00  0.00           N  
ATOM   1612  NH2 ARG A 105      50.147  61.436  21.055  1.00  0.00           N  
ATOM   1613  H   ARG A 105      42.462  60.357  24.538  1.00  0.00           H  
ATOM   1614  HA  ARG A 105      43.822  61.640  22.260  1.00  0.00           H  
ATOM   1615  HB2 ARG A 105      45.082  60.457  24.329  1.00  0.00           H  
ATOM   1616  HB3 ARG A 105      44.859  59.061  23.285  1.00  0.00           H  
ATOM   1617  HG2 ARG A 105      46.132  60.018  21.554  1.00  0.00           H  
ATOM   1618  HG3 ARG A 105      46.081  61.618  22.298  1.00  0.00           H  
ATOM   1619  HD2 ARG A 105      47.562  60.975  24.016  1.00  0.00           H  
ATOM   1620  HD3 ARG A 105      47.374  59.262  23.644  1.00  0.00           H  
ATOM   1621  HE  ARG A 105      49.025  59.477  22.086  1.00  0.00           H  
ATOM   1622 HH11 ARG A 105      47.732  62.636  22.777  1.00  0.00           H  
ATOM   1623 HH12 ARG A 105      48.904  63.469  21.811  1.00  0.00           H  
ATOM   1624 HH21 ARG A 105      50.574  60.564  20.813  1.00  0.00           H  
ATOM   1625 HH22 ARG A 105      50.519  62.291  20.693  1.00  0.00           H  
ATOM   1626  N   ARG A 106      43.286  59.813  20.578  1.00  0.00           N  
ATOM   1627  CA  ARG A 106      42.706  58.929  19.573  1.00  0.00           C  
ATOM   1628  C   ARG A 106      43.378  57.557  19.581  1.00  0.00           C  
ATOM   1629  O   ARG A 106      42.824  56.585  19.069  1.00  0.00           O  
ATOM   1630  CB  ARG A 106      42.825  59.557  18.183  1.00  0.00           C  
ATOM   1631  CG  ARG A 106      41.974  58.867  17.128  1.00  0.00           C  
ATOM   1632  CD  ARG A 106      42.801  58.477  15.915  1.00  0.00           C  
ATOM   1633  NE  ARG A 106      42.012  58.492  14.686  1.00  0.00           N  
ATOM   1634  CZ  ARG A 106      41.145  57.541  14.355  1.00  0.00           C  
ATOM   1635  NH1 ARG A 106      40.954  56.506  15.161  1.00  0.00           N  
ATOM   1636  NH2 ARG A 106      40.466  57.626  13.218  1.00  0.00           N  
ATOM   1637  H   ARG A 106      43.955  60.475  20.303  1.00  0.00           H  
ATOM   1638  HA  ARG A 106      41.660  58.803  19.810  1.00  0.00           H  
ATOM   1639  HB2 ARG A 106      42.519  60.592  18.240  1.00  0.00           H  
ATOM   1640  HB3 ARG A 106      43.857  59.514  17.867  1.00  0.00           H  
ATOM   1641  HG2 ARG A 106      41.539  57.977  17.557  1.00  0.00           H  
ATOM   1642  HG3 ARG A 106      41.189  59.540  16.817  1.00  0.00           H  
ATOM   1643  HD2 ARG A 106      43.620  59.174  15.813  1.00  0.00           H  
ATOM   1644  HD3 ARG A 106      43.194  57.482  16.067  1.00  0.00           H  
ATOM   1645  HE  ARG A 106      42.136  59.249  14.075  1.00  0.00           H  
ATOM   1646 HH11 ARG A 106      41.464  56.439  16.019  1.00  0.00           H  
ATOM   1647 HH12 ARG A 106      40.301  55.790  14.911  1.00  0.00           H  
ATOM   1648 HH21 ARG A 106      40.607  58.406  12.609  1.00  0.00           H  
ATOM   1649 HH22 ARG A 106      39.814  56.909  12.971  1.00  0.00           H  
ATOM   1650  N   GLU A 107      44.574  57.484  20.160  1.00  0.00           N  
ATOM   1651  CA  GLU A 107      45.314  56.228  20.225  1.00  0.00           C  
ATOM   1652  C   GLU A 107      44.595  55.209  21.104  1.00  0.00           C  
ATOM   1653  O   GLU A 107      44.789  54.003  20.957  1.00  0.00           O  
ATOM   1654  CB  GLU A 107      46.725  56.471  20.760  1.00  0.00           C  
ATOM   1655  CG  GLU A 107      47.815  55.973  19.829  1.00  0.00           C  
ATOM   1656  CD  GLU A 107      49.208  56.249  20.359  1.00  0.00           C  
ATOM   1657  OE1 GLU A 107      49.660  55.506  21.256  1.00  0.00           O  
ATOM   1658  OE2 GLU A 107      49.847  57.208  19.879  1.00  0.00           O  
ATOM   1659  H   GLU A 107      44.971  58.290  20.547  1.00  0.00           H  
ATOM   1660  HA  GLU A 107      45.383  55.833  19.224  1.00  0.00           H  
ATOM   1661  HB2 GLU A 107      46.864  57.531  20.909  1.00  0.00           H  
ATOM   1662  HB3 GLU A 107      46.831  55.965  21.709  1.00  0.00           H  
ATOM   1663  HG2 GLU A 107      47.699  54.906  19.700  1.00  0.00           H  
ATOM   1664  HG3 GLU A 107      47.704  56.463  18.873  1.00  0.00           H  
ATOM   1665  N   TRP A 108      43.764  55.701  22.016  1.00  0.00           N  
ATOM   1666  CA  TRP A 108      43.018  54.830  22.917  1.00  0.00           C  
ATOM   1667  C   TRP A 108      42.049  53.929  22.149  1.00  0.00           C  
ATOM   1668  O   TRP A 108      41.524  52.962  22.701  1.00  0.00           O  
ATOM   1669  CB  TRP A 108      42.249  55.666  23.942  1.00  0.00           C  
ATOM   1670  CG  TRP A 108      43.142  56.403  24.892  1.00  0.00           C  
ATOM   1671  CD1 TRP A 108      44.467  56.167  25.119  1.00  0.00           C  
ATOM   1672  CD2 TRP A 108      42.775  57.494  25.743  1.00  0.00           C  
ATOM   1673  NE1 TRP A 108      44.947  57.047  26.059  1.00  0.00           N  
ATOM   1674  CE2 TRP A 108      43.929  57.872  26.458  1.00  0.00           C  
ATOM   1675  CE3 TRP A 108      41.585  58.191  25.969  1.00  0.00           C  
ATOM   1676  CZ2 TRP A 108      43.924  58.913  27.383  1.00  0.00           C  
ATOM   1677  CZ3 TRP A 108      41.582  59.224  26.888  1.00  0.00           C  
ATOM   1678  CH2 TRP A 108      42.744  59.577  27.583  1.00  0.00           C  
ATOM   1679  H   TRP A 108      43.650  56.671  22.086  1.00  0.00           H  
ATOM   1680  HA  TRP A 108      43.729  54.208  23.439  1.00  0.00           H  
ATOM   1681  HB2 TRP A 108      41.642  56.391  23.423  1.00  0.00           H  
ATOM   1682  HB3 TRP A 108      41.610  55.014  24.521  1.00  0.00           H  
ATOM   1683  HD1 TRP A 108      45.041  55.399  24.624  1.00  0.00           H  
ATOM   1684  HE1 TRP A 108      45.869  57.078  26.390  1.00  0.00           H  
ATOM   1685  HE3 TRP A 108      40.678  57.933  25.442  1.00  0.00           H  
ATOM   1686  HZ2 TRP A 108      44.812  59.198  27.926  1.00  0.00           H  
ATOM   1687  HZ3 TRP A 108      40.671  59.773  27.076  1.00  0.00           H  
ATOM   1688  HH2 TRP A 108      42.696  60.390  28.292  1.00  0.00           H  
ATOM   1689  N   PHE A 109      41.812  54.248  20.878  1.00  0.00           N  
ATOM   1690  CA  PHE A 109      40.904  53.460  20.051  1.00  0.00           C  
ATOM   1691  C   PHE A 109      41.674  52.548  19.101  1.00  0.00           C  
ATOM   1692  O   PHE A 109      41.148  51.537  18.635  1.00  0.00           O  
ATOM   1693  CB  PHE A 109      39.978  54.380  19.254  1.00  0.00           C  
ATOM   1694  CG  PHE A 109      38.926  55.048  20.095  1.00  0.00           C  
ATOM   1695  CD1 PHE A 109      39.285  55.833  21.178  1.00  0.00           C  
ATOM   1696  CD2 PHE A 109      37.581  54.894  19.800  1.00  0.00           C  
ATOM   1697  CE1 PHE A 109      38.322  56.451  21.953  1.00  0.00           C  
ATOM   1698  CE2 PHE A 109      36.614  55.508  20.571  1.00  0.00           C  
ATOM   1699  CZ  PHE A 109      36.985  56.289  21.650  1.00  0.00           C  
ATOM   1700  H   PHE A 109      42.254  55.029  20.486  1.00  0.00           H  
ATOM   1701  HA  PHE A 109      40.306  52.848  20.710  1.00  0.00           H  
ATOM   1702  HB2 PHE A 109      40.568  55.152  18.783  1.00  0.00           H  
ATOM   1703  HB3 PHE A 109      39.476  53.801  18.492  1.00  0.00           H  
ATOM   1704  HD1 PHE A 109      40.331  55.961  21.417  1.00  0.00           H  
ATOM   1705  HD2 PHE A 109      37.291  54.284  18.957  1.00  0.00           H  
ATOM   1706  HE1 PHE A 109      38.615  57.059  22.797  1.00  0.00           H  
ATOM   1707  HE2 PHE A 109      35.569  55.379  20.331  1.00  0.00           H  
ATOM   1708  HZ  PHE A 109      36.230  56.770  22.254  1.00  0.00           H  
ATOM   1709  N   GLN A 110      42.922  52.909  18.818  1.00  0.00           N  
ATOM   1710  CA  GLN A 110      43.760  52.119  17.922  1.00  0.00           C  
ATOM   1711  C   GLN A 110      44.849  51.388  18.699  1.00  0.00           C  
ATOM   1712  O   GLN A 110      45.958  51.195  18.200  1.00  0.00           O  
ATOM   1713  CB  GLN A 110      44.392  53.017  16.857  1.00  0.00           C  
ATOM   1714  CG  GLN A 110      43.377  53.695  15.952  1.00  0.00           C  
ATOM   1715  CD  GLN A 110      42.695  52.722  15.010  1.00  0.00           C  
ATOM   1716  OE1 GLN A 110      42.110  51.728  15.442  1.00  0.00           O  
ATOM   1717  NE2 GLN A 110      42.766  53.003  13.715  1.00  0.00           N  
ATOM   1718  H   GLN A 110      43.288  53.725  19.219  1.00  0.00           H  
ATOM   1719  HA  GLN A 110      43.130  51.389  17.438  1.00  0.00           H  
ATOM   1720  HB2 GLN A 110      44.975  53.783  17.346  1.00  0.00           H  
ATOM   1721  HB3 GLN A 110      45.046  52.417  16.240  1.00  0.00           H  
ATOM   1722  HG2 GLN A 110      42.623  54.166  16.566  1.00  0.00           H  
ATOM   1723  HG3 GLN A 110      43.883  54.448  15.365  1.00  0.00           H  
ATOM   1724 HE21 GLN A 110      43.248  53.812  13.442  1.00  0.00           H  
ATOM   1725 HE22 GLN A 110      42.333  52.390  13.083  1.00  0.00           H  
ATOM   1726  N   GLY A 111      44.527  50.982  19.923  1.00  0.00           N  
ATOM   1727  CA  GLY A 111      45.489  50.276  20.748  1.00  0.00           C  
ATOM   1728  C   GLY A 111      45.006  48.896  21.149  1.00  0.00           C  
ATOM   1729  O   GLY A 111      44.398  48.187  20.347  1.00  0.00           O  
ATOM   1730  H   GLY A 111      43.628  51.164  20.269  1.00  0.00           H  
ATOM   1731  HA2 GLY A 111      46.413  50.176  20.199  1.00  0.00           H  
ATOM   1732  HA3 GLY A 111      45.673  50.854  21.642  1.00  0.00           H  
ATOM   1733  N   ASP A 112      45.279  48.513  22.393  1.00  0.00           N  
ATOM   1734  CA  ASP A 112      44.868  47.209  22.898  1.00  0.00           C  
ATOM   1735  C   ASP A 112      43.513  47.296  23.592  1.00  0.00           C  
ATOM   1736  O   ASP A 112      43.162  48.327  24.164  1.00  0.00           O  
ATOM   1737  CB  ASP A 112      45.916  46.662  23.870  1.00  0.00           C  
ATOM   1738  CG  ASP A 112      46.418  45.290  23.466  1.00  0.00           C  
ATOM   1739  OD1 ASP A 112      45.581  44.423  23.142  1.00  0.00           O  
ATOM   1740  OD2 ASP A 112      47.651  45.083  23.473  1.00  0.00           O  
ATOM   1741  H   ASP A 112      45.767  49.124  22.984  1.00  0.00           H  
ATOM   1742  HA  ASP A 112      44.786  46.538  22.057  1.00  0.00           H  
ATOM   1743  HB2 ASP A 112      46.758  47.338  23.900  1.00  0.00           H  
ATOM   1744  HB3 ASP A 112      45.481  46.591  24.857  1.00  0.00           H  
ATOM   1745  N   GLY A 113      42.754  46.206  23.534  1.00  0.00           N  
ATOM   1746  CA  GLY A 113      41.446  46.179  24.161  1.00  0.00           C  
ATOM   1747  C   GLY A 113      40.319  46.335  23.158  1.00  0.00           C  
ATOM   1748  O   GLY A 113      40.532  46.210  21.951  1.00  0.00           O  
ATOM   1749  H   GLY A 113      43.085  45.413  23.063  1.00  0.00           H  
ATOM   1750  HA2 GLY A 113      41.325  45.239  24.678  1.00  0.00           H  
ATOM   1751  HA3 GLY A 113      41.387  46.983  24.879  1.00  0.00           H  
ATOM   1752  N   MET A 114      39.119  46.610  23.656  1.00  0.00           N  
ATOM   1753  CA  MET A 114      37.955  46.782  22.794  1.00  0.00           C  
ATOM   1754  C   MET A 114      37.237  48.091  23.106  1.00  0.00           C  
ATOM   1755  O   MET A 114      37.293  48.589  24.231  1.00  0.00           O  
ATOM   1756  CB  MET A 114      36.991  45.606  22.961  1.00  0.00           C  
ATOM   1757  CG  MET A 114      36.850  45.131  24.398  1.00  0.00           C  
ATOM   1758  SD  MET A 114      38.142  43.967  24.875  1.00  0.00           S  
ATOM   1759  CE  MET A 114      38.609  44.619  26.477  1.00  0.00           C  
ATOM   1760  H   MET A 114      39.012  46.698  24.627  1.00  0.00           H  
ATOM   1761  HA  MET A 114      38.301  46.810  21.773  1.00  0.00           H  
ATOM   1762  HB2 MET A 114      36.015  45.903  22.606  1.00  0.00           H  
ATOM   1763  HB3 MET A 114      37.345  44.778  22.365  1.00  0.00           H  
ATOM   1764  HG2 MET A 114      36.897  45.988  25.053  1.00  0.00           H  
ATOM   1765  HG3 MET A 114      35.891  44.647  24.510  1.00  0.00           H  
ATOM   1766  HE1 MET A 114      37.808  45.231  26.864  1.00  0.00           H  
ATOM   1767  HE2 MET A 114      38.796  43.801  27.157  1.00  0.00           H  
ATOM   1768  HE3 MET A 114      39.503  45.216  26.377  1.00  0.00           H  
ATOM   1769  N   VAL A 115      36.560  48.643  22.104  1.00  0.00           N  
ATOM   1770  CA  VAL A 115      35.831  49.894  22.273  1.00  0.00           C  
ATOM   1771  C   VAL A 115      34.331  49.684  22.101  1.00  0.00           C  
ATOM   1772  O   VAL A 115      33.891  48.989  21.185  1.00  0.00           O  
ATOM   1773  CB  VAL A 115      36.305  50.962  21.269  1.00  0.00           C  
ATOM   1774  CG1 VAL A 115      35.743  52.327  21.635  1.00  0.00           C  
ATOM   1775  CG2 VAL A 115      37.826  51.002  21.210  1.00  0.00           C  
ATOM   1776  H   VAL A 115      36.553  48.199  21.231  1.00  0.00           H  
ATOM   1777  HA  VAL A 115      36.023  50.259  23.271  1.00  0.00           H  
ATOM   1778  HB  VAL A 115      35.936  50.697  20.289  1.00  0.00           H  
ATOM   1779 HG11 VAL A 115      35.375  52.304  22.650  1.00  0.00           H  
ATOM   1780 HG12 VAL A 115      36.522  53.071  21.552  1.00  0.00           H  
ATOM   1781 HG13 VAL A 115      34.934  52.575  20.964  1.00  0.00           H  
ATOM   1782 HG21 VAL A 115      38.231  50.718  22.171  1.00  0.00           H  
ATOM   1783 HG22 VAL A 115      38.174  50.314  20.454  1.00  0.00           H  
ATOM   1784 HG23 VAL A 115      38.150  52.003  20.964  1.00  0.00           H  
ATOM   1785  N   ARG A 116      33.549  50.290  22.989  1.00  0.00           N  
ATOM   1786  CA  ARG A 116      32.097  50.171  22.936  1.00  0.00           C  
ATOM   1787  C   ARG A 116      31.476  51.398  22.274  1.00  0.00           C  
ATOM   1788  O   ARG A 116      32.043  52.489  22.312  1.00  0.00           O  
ATOM   1789  CB  ARG A 116      31.526  49.995  24.345  1.00  0.00           C  
ATOM   1790  CG  ARG A 116      30.070  49.557  24.362  1.00  0.00           C  
ATOM   1791  CD  ARG A 116      29.911  48.126  23.874  1.00  0.00           C  
ATOM   1792  NE  ARG A 116      28.515  47.789  23.610  1.00  0.00           N  
ATOM   1793  CZ  ARG A 116      27.638  47.483  24.562  1.00  0.00           C  
ATOM   1794  NH1 ARG A 116      28.012  47.477  25.834  1.00  0.00           N  
ATOM   1795  NH2 ARG A 116      26.386  47.185  24.241  1.00  0.00           N  
ATOM   1796  H   ARG A 116      33.958  50.832  23.695  1.00  0.00           H  
ATOM   1797  HA  ARG A 116      31.857  49.299  22.347  1.00  0.00           H  
ATOM   1798  HB2 ARG A 116      32.109  49.249  24.865  1.00  0.00           H  
ATOM   1799  HB3 ARG A 116      31.604  50.933  24.873  1.00  0.00           H  
ATOM   1800  HG2 ARG A 116      29.695  49.626  25.372  1.00  0.00           H  
ATOM   1801  HG3 ARG A 116      29.501  50.213  23.719  1.00  0.00           H  
ATOM   1802  HD2 ARG A 116      30.479  48.004  22.964  1.00  0.00           H  
ATOM   1803  HD3 ARG A 116      30.297  47.458  24.630  1.00  0.00           H  
ATOM   1804  HE  ARG A 116      28.217  47.788  22.677  1.00  0.00           H  
ATOM   1805 HH11 ARG A 116      28.955  47.701  26.079  1.00  0.00           H  
ATOM   1806 HH12 ARG A 116      27.351  47.246  26.548  1.00  0.00           H  
ATOM   1807 HH21 ARG A 116      26.100  47.189  23.284  1.00  0.00           H  
ATOM   1808 HH22 ARG A 116      25.728  46.955  24.958  1.00  0.00           H  
ATOM   1809  N   ARG A 117      30.308  51.210  21.668  1.00  0.00           N  
ATOM   1810  CA  ARG A 117      29.615  52.304  20.999  1.00  0.00           C  
ATOM   1811  C   ARG A 117      28.133  51.988  20.823  1.00  0.00           C  
ATOM   1812  O   ARG A 117      27.762  50.869  20.469  1.00  0.00           O  
ATOM   1813  CB  ARG A 117      30.252  52.582  19.637  1.00  0.00           C  
ATOM   1814  CG  ARG A 117      29.621  53.749  18.896  1.00  0.00           C  
ATOM   1815  CD  ARG A 117      29.881  53.666  17.399  1.00  0.00           C  
ATOM   1816  NE  ARG A 117      31.223  53.176  17.102  1.00  0.00           N  
ATOM   1817  CZ  ARG A 117      31.640  52.867  15.879  1.00  0.00           C  
ATOM   1818  NH1 ARG A 117      30.820  52.995  14.845  1.00  0.00           N  
ATOM   1819  NH2 ARG A 117      32.877  52.428  15.687  1.00  0.00           N  
ATOM   1820  H   ARG A 117      29.905  50.317  21.670  1.00  0.00           H  
ATOM   1821  HA  ARG A 117      29.711  53.184  21.617  1.00  0.00           H  
ATOM   1822  HB2 ARG A 117      31.301  52.800  19.781  1.00  0.00           H  
ATOM   1823  HB3 ARG A 117      30.160  51.699  19.022  1.00  0.00           H  
ATOM   1824  HG2 ARG A 117      28.555  53.737  19.068  1.00  0.00           H  
ATOM   1825  HG3 ARG A 117      30.039  54.670  19.274  1.00  0.00           H  
ATOM   1826  HD2 ARG A 117      29.157  52.996  16.958  1.00  0.00           H  
ATOM   1827  HD3 ARG A 117      29.763  54.651  16.972  1.00  0.00           H  
ATOM   1828  HE  ARG A 117      31.845  53.072  17.852  1.00  0.00           H  
ATOM   1829 HH11 ARG A 117      29.886  53.325  14.985  1.00  0.00           H  
ATOM   1830 HH12 ARG A 117      31.134  52.763  13.924  1.00  0.00           H  
ATOM   1831 HH21 ARG A 117      33.498  52.330  16.464  1.00  0.00           H  
ATOM   1832 HH22 ARG A 117      33.187  52.196  14.766  1.00  0.00           H  
ATOM   1833  N   LYS A 118      27.289  52.985  21.073  1.00  0.00           N  
ATOM   1834  CA  LYS A 118      25.846  52.820  20.942  1.00  0.00           C  
ATOM   1835  C   LYS A 118      25.199  54.106  20.438  1.00  0.00           C  
ATOM   1836  O   LYS A 118      25.475  55.192  20.948  1.00  0.00           O  
ATOM   1837  CB  LYS A 118      25.232  52.417  22.283  1.00  0.00           C  
ATOM   1838  CG  LYS A 118      25.617  51.017  22.732  1.00  0.00           C  
ATOM   1839  CD  LYS A 118      24.511  50.372  23.553  1.00  0.00           C  
ATOM   1840  CE  LYS A 118      24.186  51.192  24.790  1.00  0.00           C  
ATOM   1841  NZ  LYS A 118      23.563  50.363  25.858  1.00  0.00           N  
ATOM   1842  H   LYS A 118      27.646  53.854  21.350  1.00  0.00           H  
ATOM   1843  HA  LYS A 118      25.666  52.034  20.223  1.00  0.00           H  
ATOM   1844  HB2 LYS A 118      25.557  53.116  23.040  1.00  0.00           H  
ATOM   1845  HB3 LYS A 118      24.157  52.463  22.202  1.00  0.00           H  
ATOM   1846  HG2 LYS A 118      25.804  50.409  21.860  1.00  0.00           H  
ATOM   1847  HG3 LYS A 118      26.512  51.075  23.333  1.00  0.00           H  
ATOM   1848  HD2 LYS A 118      23.624  50.291  22.944  1.00  0.00           H  
ATOM   1849  HD3 LYS A 118      24.832  49.387  23.859  1.00  0.00           H  
ATOM   1850  HE2 LYS A 118      25.099  51.626  25.170  1.00  0.00           H  
ATOM   1851  HE3 LYS A 118      23.501  51.981  24.514  1.00  0.00           H  
ATOM   1852  HZ1 LYS A 118      24.102  49.482  25.987  1.00  0.00           H  
ATOM   1853  HZ2 LYS A 118      23.556  50.885  26.758  1.00  0.00           H  
ATOM   1854  HZ3 LYS A 118      22.585  50.123  25.600  1.00  0.00           H  
ATOM   1855  N   ASN A 119      24.337  53.976  19.435  1.00  0.00           N  
ATOM   1856  CA  ASN A 119      23.653  55.131  18.862  1.00  0.00           C  
ATOM   1857  C   ASN A 119      22.316  55.374  19.557  1.00  0.00           C  
ATOM   1858  O   ASN A 119      21.539  54.444  19.773  1.00  0.00           O  
ATOM   1859  CB  ASN A 119      23.431  54.926  17.363  1.00  0.00           C  
ATOM   1860  CG  ASN A 119      24.696  54.497  16.644  1.00  0.00           C  
ATOM   1861  OD1 ASN A 119      24.713  53.484  15.946  1.00  0.00           O  
ATOM   1862  ND2 ASN A 119      25.764  55.269  16.813  1.00  0.00           N  
ATOM   1863  H   ASN A 119      24.158  53.086  19.069  1.00  0.00           H  
ATOM   1864  HA  ASN A 119      24.284  55.995  19.009  1.00  0.00           H  
ATOM   1865  HB2 ASN A 119      22.681  54.164  17.217  1.00  0.00           H  
ATOM   1866  HB3 ASN A 119      23.088  55.852  16.926  1.00  0.00           H  
ATOM   1867 HD21 ASN A 119      25.677  56.061  17.383  1.00  0.00           H  
ATOM   1868 HD22 ASN A 119      26.594  55.014  16.359  1.00  0.00           H  
ATOM   1869  N   LEU A 120      22.056  56.631  19.901  1.00  0.00           N  
ATOM   1870  CA  LEU A 120      20.813  56.999  20.568  1.00  0.00           C  
ATOM   1871  C   LEU A 120      19.825  57.609  19.571  1.00  0.00           C  
ATOM   1872  O   LEU A 120      20.102  58.652  18.978  1.00  0.00           O  
ATOM   1873  CB  LEU A 120      21.095  57.996  21.695  1.00  0.00           C  
ATOM   1874  CG  LEU A 120      21.238  57.377  23.086  1.00  0.00           C  
ATOM   1875  CD1 LEU A 120      22.172  56.178  23.043  1.00  0.00           C  
ATOM   1876  CD2 LEU A 120      21.742  58.414  24.078  1.00  0.00           C  
ATOM   1877  H   LEU A 120      22.715  57.328  19.700  1.00  0.00           H  
ATOM   1878  HA  LEU A 120      20.388  56.104  20.991  1.00  0.00           H  
ATOM   1879  HB2 LEU A 120      22.009  58.522  21.460  1.00  0.00           H  
ATOM   1880  HB3 LEU A 120      20.286  58.710  21.725  1.00  0.00           H  
ATOM   1881  HG  LEU A 120      20.270  57.033  23.422  1.00  0.00           H  
ATOM   1882 HD11 LEU A 120      22.751  56.205  22.133  1.00  0.00           H  
ATOM   1883 HD12 LEU A 120      22.839  56.211  23.894  1.00  0.00           H  
ATOM   1884 HD13 LEU A 120      21.593  55.268  23.076  1.00  0.00           H  
ATOM   1885 HD21 LEU A 120      22.678  58.823  23.728  1.00  0.00           H  
ATOM   1886 HD22 LEU A 120      21.014  59.207  24.171  1.00  0.00           H  
ATOM   1887 HD23 LEU A 120      21.890  57.948  25.041  1.00  0.00           H  
ATOM   1888  N   PRO A 121      18.658  56.971  19.369  1.00  0.00           N  
ATOM   1889  CA  PRO A 121      17.641  57.469  18.435  1.00  0.00           C  
ATOM   1890  C   PRO A 121      17.032  58.791  18.891  1.00  0.00           C  
ATOM   1891  O   PRO A 121      16.584  58.919  20.031  1.00  0.00           O  
ATOM   1892  CB  PRO A 121      16.581  56.364  18.432  1.00  0.00           C  
ATOM   1893  CG  PRO A 121      16.765  55.654  19.728  1.00  0.00           C  
ATOM   1894  CD  PRO A 121      18.236  55.723  20.029  1.00  0.00           C  
ATOM   1895  HA  PRO A 121      18.045  57.587  17.440  1.00  0.00           H  
ATOM   1896  HB2 PRO A 121      15.597  56.806  18.360  1.00  0.00           H  
ATOM   1897  HB3 PRO A 121      16.746  55.705  17.593  1.00  0.00           H  
ATOM   1898  HG2 PRO A 121      16.199  56.150  20.502  1.00  0.00           H  
ATOM   1899  HG3 PRO A 121      16.451  54.625  19.631  1.00  0.00           H  
ATOM   1900  HD2 PRO A 121      18.400  55.774  21.096  1.00  0.00           H  
ATOM   1901  HD3 PRO A 121      18.748  54.871  19.607  1.00  0.00           H  
ATOM   1902  N   ILE A 122      17.019  59.772  17.993  1.00  0.00           N  
ATOM   1903  CA  ILE A 122      16.467  61.083  18.305  1.00  0.00           C  
ATOM   1904  C   ILE A 122      14.994  61.170  17.913  1.00  0.00           C  
ATOM   1905  O   ILE A 122      14.558  60.537  16.952  1.00  0.00           O  
ATOM   1906  CB  ILE A 122      17.244  62.205  17.591  1.00  0.00           C  
ATOM   1907  CG1 ILE A 122      18.743  62.069  17.864  1.00  0.00           C  
ATOM   1908  CG2 ILE A 122      16.740  63.568  18.042  1.00  0.00           C  
ATOM   1909  CD1 ILE A 122      19.112  62.249  19.321  1.00  0.00           C  
ATOM   1910  H   ILE A 122      17.392  59.609  17.100  1.00  0.00           H  
ATOM   1911  HA  ILE A 122      16.553  61.236  19.371  1.00  0.00           H  
ATOM   1912  HB  ILE A 122      17.068  62.116  16.530  1.00  0.00           H  
ATOM   1913 HG12 ILE A 122      19.070  61.085  17.559  1.00  0.00           H  
ATOM   1914 HG13 ILE A 122      19.276  62.814  17.291  1.00  0.00           H  
ATOM   1915 HG21 ILE A 122      16.535  63.543  19.102  1.00  0.00           H  
ATOM   1916 HG22 ILE A 122      17.493  64.315  17.838  1.00  0.00           H  
ATOM   1917 HG23 ILE A 122      15.835  63.812  17.506  1.00  0.00           H  
ATOM   1918 HD11 ILE A 122      18.241  62.567  19.876  1.00  0.00           H  
ATOM   1919 HD12 ILE A 122      19.471  61.311  19.720  1.00  0.00           H  
ATOM   1920 HD13 ILE A 122      19.886  62.997  19.406  1.00  0.00           H  
ATOM   1921  N   GLU A 123      14.236  61.962  18.665  1.00  0.00           N  
ATOM   1922  CA  GLU A 123      12.812  62.138  18.402  1.00  0.00           C  
ATOM   1923  C   GLU A 123      12.404  63.591  18.607  1.00  0.00           C  
ATOM   1924  O   GLU A 123      13.099  64.355  19.274  1.00  0.00           O  
ATOM   1925  CB  GLU A 123      11.985  61.229  19.314  1.00  0.00           C  
ATOM   1926  CG  GLU A 123      11.480  59.974  18.625  1.00  0.00           C  
ATOM   1927  CD  GLU A 123      11.796  58.712  19.405  1.00  0.00           C  
ATOM   1928  OE1 GLU A 123      12.951  58.571  19.860  1.00  0.00           O  
ATOM   1929  OE2 GLU A 123      10.890  57.868  19.562  1.00  0.00           O  
ATOM   1930  H   GLU A 123      14.645  62.440  19.416  1.00  0.00           H  
ATOM   1931  HA  GLU A 123      12.624  61.868  17.374  1.00  0.00           H  
ATOM   1932  HB2 GLU A 123      12.594  60.932  20.155  1.00  0.00           H  
ATOM   1933  HB3 GLU A 123      11.131  61.783  19.677  1.00  0.00           H  
ATOM   1934  HG2 GLU A 123      10.409  60.047  18.509  1.00  0.00           H  
ATOM   1935  HG3 GLU A 123      11.942  59.902  17.650  1.00  0.00           H  
ATOM   1936  N   TYR A 124      11.272  63.965  18.024  1.00  0.00           N  
ATOM   1937  CA  TYR A 124      10.773  65.330  18.140  1.00  0.00           C  
ATOM   1938  C   TYR A 124       9.294  65.347  18.513  1.00  0.00           C  
ATOM   1939  O   TYR A 124       8.436  64.977  17.712  1.00  0.00           O  
ATOM   1940  CB  TYR A 124      10.989  66.085  16.826  1.00  0.00           C  
ATOM   1941  CG  TYR A 124      12.444  66.237  16.450  1.00  0.00           C  
ATOM   1942  CD1 TYR A 124      13.132  65.201  15.829  1.00  0.00           C  
ATOM   1943  CD2 TYR A 124      13.133  67.413  16.718  1.00  0.00           C  
ATOM   1944  CE1 TYR A 124      14.463  65.334  15.485  1.00  0.00           C  
ATOM   1945  CE2 TYR A 124      14.464  67.554  16.376  1.00  0.00           C  
ATOM   1946  CZ  TYR A 124      15.125  66.512  15.760  1.00  0.00           C  
ATOM   1947  OH  TYR A 124      16.450  66.648  15.419  1.00  0.00           O  
ATOM   1948  H   TYR A 124      10.765  63.311  17.501  1.00  0.00           H  
ATOM   1949  HA  TYR A 124      11.334  65.821  18.921  1.00  0.00           H  
ATOM   1950  HB2 TYR A 124      10.494  65.553  16.028  1.00  0.00           H  
ATOM   1951  HB3 TYR A 124      10.561  67.074  16.912  1.00  0.00           H  
ATOM   1952  HD1 TYR A 124      12.610  64.280  15.614  1.00  0.00           H  
ATOM   1953  HD2 TYR A 124      12.613  68.227  17.201  1.00  0.00           H  
ATOM   1954  HE1 TYR A 124      14.979  64.519  15.002  1.00  0.00           H  
ATOM   1955  HE2 TYR A 124      14.983  68.477  16.592  1.00  0.00           H  
ATOM   1956  HH  TYR A 124      17.001  66.324  16.136  1.00  0.00           H  
ATOM   1957  N   ASN A 125       9.005  65.784  19.735  1.00  0.00           N  
ATOM   1958  CA  ASN A 125       7.631  65.859  20.216  1.00  0.00           C  
ATOM   1959  C   ASN A 125       7.098  67.283  20.101  1.00  0.00           C  
ATOM   1960  O   ASN A 125       7.762  68.239  20.503  1.00  0.00           O  
ATOM   1961  CB  ASN A 125       7.547  65.388  21.670  1.00  0.00           C  
ATOM   1962  CG  ASN A 125       6.446  64.368  21.885  1.00  0.00           C  
ATOM   1963  OD1 ASN A 125       6.150  63.562  21.003  1.00  0.00           O  
ATOM   1964  ND2 ASN A 125       5.831  64.399  23.062  1.00  0.00           N  
ATOM   1965  H   ASN A 125       9.734  66.070  20.325  1.00  0.00           H  
ATOM   1966  HA  ASN A 125       7.027  65.209  19.600  1.00  0.00           H  
ATOM   1967  HB2 ASN A 125       8.487  64.940  21.951  1.00  0.00           H  
ATOM   1968  HB3 ASN A 125       7.354  66.240  22.306  1.00  0.00           H  
ATOM   1969 HD21 ASN A 125       6.118  65.068  23.718  1.00  0.00           H  
ATOM   1970 HD22 ASN A 125       5.116  63.750  23.228  1.00  0.00           H  
ATOM   1971  N   LEU A 126       5.897  67.420  19.550  1.00  0.00           N  
ATOM   1972  CA  LEU A 126       5.280  68.729  19.382  1.00  0.00           C  
ATOM   1973  C   LEU A 126       4.205  68.964  20.439  1.00  0.00           C  
ATOM   1974  O   LEU A 126       3.404  69.907  20.268  1.00  0.00           O  
ATOM   1975  CB  LEU A 126       4.672  68.856  17.984  1.00  0.00           C  
ATOM   1976  CG  LEU A 126       5.492  68.217  16.862  1.00  0.00           C  
ATOM   1977  CD1 LEU A 126       4.797  68.402  15.522  1.00  0.00           C  
ATOM   1978  CD2 LEU A 126       6.893  68.810  16.822  1.00  0.00           C  
ATOM   1979  OXT LEU A 126       4.173  68.202  21.428  1.00  0.00           O  
ATOM   1980  H   LEU A 126       5.415  66.621  19.247  1.00  0.00           H  
ATOM   1981  HA  LEU A 126       6.050  69.476  19.498  1.00  0.00           H  
ATOM   1982  HB2 LEU A 126       3.695  68.394  17.995  1.00  0.00           H  
ATOM   1983  HB3 LEU A 126       4.553  69.905  17.760  1.00  0.00           H  
ATOM   1984  HG  LEU A 126       5.582  67.157  17.048  1.00  0.00           H  
ATOM   1985 HD11 LEU A 126       4.029  69.155  15.617  1.00  0.00           H  
ATOM   1986 HD12 LEU A 126       5.518  68.716  14.782  1.00  0.00           H  
ATOM   1987 HD13 LEU A 126       4.350  67.467  15.217  1.00  0.00           H  
ATOM   1988 HD21 LEU A 126       7.024  69.482  17.657  1.00  0.00           H  
ATOM   1989 HD22 LEU A 126       7.622  68.016  16.882  1.00  0.00           H  
ATOM   1990 HD23 LEU A 126       7.028  69.354  15.898  1.00  0.00           H  
TER    1991      LEU A 126                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
