
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  135 ( 1039),  selected  135 , name 3cfu_B
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 3cfu_B.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X    63_B      E     267           -
LGA    H    64_B      D     268           -
LGA    K    65_B      L     269           -
LGA    I    66_B      L     270           -
LGA    G    67_B      R     271           -
LGA    E    68_B      -       -           -
LGA    T    69_B      -       -           -
LGA    F    70_B      -       -           -
LGA    K    71_B      -       -           -
LGA    A    72_B      P     272           #
LGA    -       -      F     273           -
LGA    -       -      F     274           -
LGA    G    73_B      E     275          2.349
LGA    -       -      K     276           -
LGA    H    74_B      C     277          2.628
LGA    T    75_B      V     278          1.228
LGA    N    76_B      K     279          1.402
LGA    F    77_B      I     280          1.348
LGA    T    78_B      E     281          2.109
LGA    V    79_B      E     282          2.435
LGA    N    80_B      V     283          1.832
LGA    K    81_B      S     284          1.460
LGA    V    82_B      R     285          1.738
LGA    D    83_B      N     286          2.341
LGA    R    84_B      E     287          2.302
LGA    V    85_B      -       -           -
LGA    E    89_B      -       -           -
LGA    Y    90_B      -       -           -
LGA    X    91_B      -       -           -
LGA    N    92_B      -       -           -
LGA    V    93_B      -       -           -
LGA    G    94_B      -       -           -
LGA    K   102_B      -       -           -
LGA    T   103_B      -       -           -
LGA    I   104_B      -       -           -
LGA    K   105_B      -       -           -
LGA    D   106_B      -       -           -
LGA    R   110_B      -       -           -
LGA    L   111_B      Q     288          2.009
LGA    I   112_B      G     289          2.836
LGA    I   113_B      V     290          1.932
LGA    E   114_B      T     291          1.267
LGA    V   115_B      L     292          1.740
LGA    T   116_B      S     293          1.819
LGA    X   117_B      I     294          1.492
LGA    E   118_B      T     295          1.267
LGA    N   119_B      N     296          1.315
LGA    I   120_B      V     297          2.650
LGA    G   121_B      T     298          3.604
LGA    E   122_B      D     299          3.570
LGA    D   123_B      L     300          2.253
LGA    S   124_B      V     301          0.418
LGA    I   125_B      L     302          1.006
LGA    S   126_B      K     303          1.900
LGA    Y   127_B      L     304          3.006
LGA    N   128_B      K     305          3.503
LGA    F   129_B      K     306          4.010
LGA    I   130_B      T     307          3.666
LGA    G   131_B      A     308           -
LGA    F   132_B      -       -           -
LGA    D   133_B      H     309          4.582
LGA    L   134_B      -       -           -
LGA    R   135_B      -       -           -
LGA    D   136_B      -       -           -
LGA    K   137_B      -       -           -
LGA    N   138_B      -       -           -
LGA    D   139_B      -       -           -
LGA    Q   140_B      -       -           -
LGA    S   141_B      D     310          3.100
LGA    V   142_B      T     311          4.376
LGA    R   143_B      L     312          2.898
LGA    P   144_B      L     313          3.576
LGA    V   145_B      V     314          4.335
LGA    F   146_B      -       -           -
LGA    S   147_B      -       -           -
LGA    I   148_B      -       -           -
LGA    E   149_B      -       -           -
LGA    E   150_B      -       -           -
LGA    K   151_B      -       -           -
LGA    G   152_B      -       -           -
LGA    R   153_B      -       -           -
LGA    I   154_B      Y     315           #
LGA    L   155_B      F     316          3.576
LGA    X   156_B      R     317          4.021
LGA    G   157_B      D     318          2.861
LGA    G   158_B      M     319          3.281
LGA    T   159_B      T     320          2.367
LGA    L   160_B      L     321          1.465
LGA    V   161_B      K     322          1.511
LGA    S   162_B      P     323          1.665
LGA    G   163_B      H     324          1.511
LGA    K   164_B      T     325          1.114
LGA    K   165_B      R     326          1.298
LGA    V   166_B      Y     327          1.106
LGA    T   167_B      T     328          0.753
LGA    G   168_B      V     329          2.427
LGA    V   169_B      R     330          1.435
LGA    L   170_B      I     331          2.005
LGA    S   171_B      G     332          1.397
LGA    Y   172_B      F     333          2.573
LGA    V   173_B      K     334          1.470
LGA    I   174_B      Q     335          2.520
LGA    P   175_B      G     336          2.711
LGA    Q   179_B      I     337           #
LGA    K   180_B      K     338          3.184
LGA    H   181_B      -       -           -
LGA    Y   182_B      -       -           -
LGA    T   183_B      G     339          3.116
LGA    L   184_B      G     340          3.108
LGA    V   185_B      D     341          2.322
LGA    Y   186_B      V     342          3.823
LGA    N   187_B      N     343          4.625
LGA    P   188_B      -       -           -
LGA    F   189_B      -       -           -
LGA    L   190_B      F     344          2.614
LGA    A   191_B      E     345          4.240
LGA    D   192_B      V     346          2.624
LGA    T   193_B      T     347          3.000
LGA    N   194_B      N     348          2.885
LGA    S   195_B      -       -           -
LGA    S   196_B      -       -           -
LGA    N   197_B      F     349          3.584
LGA    T   198_B      I     350          1.569
LGA    E   199_B      V     351          2.199
LGA    E   200_B      A     352           -
LGA    -       -      P     353           -
LGA    -       -      D     354           -
LGA    -       -      K     355           -
LGA    R   201_B      G     356          6.484
LGA    V   202_B      L     357          3.681
LGA    K   203_B      -       -           -
LGA    D   204_B      -       -           -
LGA    D   205_B      K     358          3.592
LGA    I   206_B      Y     359          4.469
LGA    D   207_B      T     360          3.467
LGA    Y   208_B      I     361          3.987
LGA    L   209_B      S     362          2.371
LGA    V   210_B      L     363          3.023
LGA    K   211_B      -       -           -
LGA    L   212_B      -       -           -
LGA    D   213_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  135   97    5.0     81    2.80    11.11     53.589     2.793

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.853572 * X  +   0.379051 * Y  +   0.357400 * Z  + -16.897940
  Y_new =   0.399292 * X  +  -0.035338 * Y  +  -0.916143 * Z  +  67.126755
  Z_new =  -0.334635 * X  +   0.924701 * Y  +  -0.181515 * Z  +  24.968117 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.764628   -1.376964  [ DEG:   101.1058    -78.8942 ]
  Theta =   0.341218    2.800375  [ DEG:    19.5504    160.4496 ]
  Phi   =   0.437548   -2.704044  [ DEG:    25.0697   -154.9303 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cfu_B                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cfu_B.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  135   97   5.0   81   2.80   11.11  53.589
REMARK  ---------------------------------------------------------- 
MOLECULE 3cfu_B
HEADER    LIPOPROTEIN                             04-MAR-08   3CFU              
TITLE     CRYSTAL STRUCTURE OF THE YJHA PROTEIN FROM BACILLUS                   
TITLE    2 SUBTILIS. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM TARGET            
TITLE    3 SR562                                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED LIPOPROTEIN YJHA;                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: RESIDUES 64-213;                                           
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 GENE: YJHA, BSU12180;                                                
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    YJHA_BACSU, YJHA, LIPOPROTEIN, SR562, NESG, STRUCTURAL                
KEYWDS   2 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, NORTHEAST             
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, MEMBRANE, PALMITATE                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.M.VOROBIEV,Y.CHEN,A.P.KUZIN,J.SEETHARAMAN,F.FOROUHAR,               
AUTHOR   2 L.ZHAO,L.MAO,M.MAGLAQUI,R.XIAO,J.LIU,G.SWAPNA,J.Y.HUANG,             
AUTHOR   3 T.B.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST                   
AUTHOR   4 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   1   18-MAR-08 3CFU    0                                                
JRNL        AUTH   S.M.VOROBIEV,Y.CHEN,A.P.KUZIN,J.SEETHARAMAN,                 
JRNL        AUTH 2 F.FOROUHAR,L.ZHAO,L.MAO,M.MAGLAQUI,R.XIAO,J.LIU,             
JRNL        AUTH 3 G.SWAPNA,J.Y.HUANG,T.B.ACTON,G.T.MONTELIONE,                 
JRNL        AUTH 4 J.F.HUNT,L.TONG                                              
JRNL        TITL   CRYSTAL STRUCTURE OF THE YJHA PROTEIN FROM                   
JRNL        TITL 2 BACILLUS SUBTILIS.                                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  3CFU A   64   213  UNP    O34725   YJHA_BACSU      64    213             
DBREF  3CFU B   64   213  UNP    O34725   YJHA_BACSU      64    213             
SEQRES   1 A  159  MSE HIS LYS ILE GLY GLU THR PHE LYS ALA GLY HIS THR          
SEQRES   2 A  159  ASN PHE THR VAL ASN LYS VAL ASP ARG VAL GLN LYS GLY          
SEQRES   3 A  159  GLU TYR MSE ASN VAL GLY GLY ALA VAL ASN GLU GLU THR          
SEQRES   4 A  159  LYS THR ILE LYS ASP ASP GLU GLU ARG LEU ILE ILE GLU          
SEQRES   5 A  159  VAL THR MSE GLU ASN ILE GLY GLU ASP SER ILE SER TYR          
SEQRES   6 A  159  ASN PHE ILE GLY PHE ASP LEU ARG ASP LYS ASN ASP GLN          
SEQRES   7 A  159  SER VAL ARG PRO VAL PHE SER ILE GLU GLU LYS GLY ARG          
SEQRES   8 A  159  ILE LEU MSE GLY GLY THR LEU VAL SER GLY LYS LYS VAL          
SEQRES   9 A  159  THR GLY VAL LEU SER TYR VAL ILE PRO LYS GLY GLU GLN          
SEQRES  10 A  159  LYS HIS TYR THR LEU VAL TYR ASN PRO PHE LEU ALA ASP          
SEQRES  11 A  159  THR ASN SER SER ASN THR GLU GLU ARG VAL LYS ASP ASP          
SEQRES  12 A  159  ILE ASP TYR LEU VAL LYS LEU ASP LEU GLU HIS HIS HIS          
SEQRES  13 A  159  HIS HIS HIS                                                  
SEQRES   1 B  159  MSE HIS LYS ILE GLY GLU THR PHE LYS ALA GLY HIS THR          
SEQRES   2 B  159  ASN PHE THR VAL ASN LYS VAL ASP ARG VAL GLN LYS GLY          
SEQRES   3 B  159  GLU TYR MSE ASN VAL GLY GLY ALA VAL ASN GLU GLU THR          
SEQRES   4 B  159  LYS THR ILE LYS ASP ASP GLU GLU ARG LEU ILE ILE GLU          
SEQRES   5 B  159  VAL THR MSE GLU ASN ILE GLY GLU ASP SER ILE SER TYR          
SEQRES   6 B  159  ASN PHE ILE GLY PHE ASP LEU ARG ASP LYS ASN ASP GLN          
SEQRES   7 B  159  SER VAL ARG PRO VAL PHE SER ILE GLU GLU LYS GLY ARG          
SEQRES   8 B  159  ILE LEU MSE GLY GLY THR LEU VAL SER GLY LYS LYS VAL          
SEQRES   9 B  159  THR GLY VAL LEU SER TYR VAL ILE PRO LYS GLY GLU GLN          
SEQRES  10 B  159  LYS HIS TYR THR LEU VAL TYR ASN PRO PHE LEU ALA ASP          
SEQRES  11 B  159  THR ASN SER SER ASN THR GLU GLU ARG VAL LYS ASP ASP          
SEQRES  12 B  159  ILE ASP TYR LEU VAL LYS LEU ASP LEU GLU HIS HIS HIS          
SEQRES  13 B  159  HIS HIS HIS                                                  
HET    MSE  A  63       8                                                       
HET    MSE  A  91       8                                                       
HET    MSE  A 117       8                                                       
HET    MSE  A 156       8                                                       
HET    MSE  B  63       8                                                       
HET    MSE  B  91       8                                                       
HET    MSE  B 117       8                                                       
HET    MSE  B 156       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *89(H2 O)                                                     
CRYST1   62.678   41.687   65.656  90.00  91.74  90.00 P 1 21 1      4          
HETATM 1111  N   MSE B  63      11.986  50.853  21.616  1.00 60.71           N  
HETATM 1112  CA  MSE B  63      13.043  51.908  21.528  1.00 60.67           C  
HETATM 1113  C   MSE B  63      13.326  52.487  22.920  1.00 55.55           C  
HETATM 1114  O   MSE B  63      12.984  51.871  23.933  1.00 55.75           O  
HETATM 1115  CB  MSE B  63      12.571  53.013  20.574  1.00 63.95           C  
HETATM 1116  CG  MSE B  63      13.670  53.927  20.050  1.00 71.08           C  
HETATM 1117 SE   MSE B  63      13.329  54.559  18.234  1.00 94.86          SE  
HETATM 1118  CE  MSE B  63      11.457  55.017  18.392  1.00 98.85           C  
ATOM   1119  N   HIS B  64      13.973  53.649  22.969  1.00 48.04           N  
ATOM   1120  CA  HIS B  64      14.268  54.318  24.235  1.00 42.94           C  
ATOM   1121  C   HIS B  64      13.593  55.688  24.206  1.00 40.34           C  
ATOM   1122  O   HIS B  64      13.583  56.374  23.178  1.00 37.50           O  
ATOM   1123  CB  HIS B  64      15.786  54.472  24.454  1.00 43.06           C  
ATOM   1124  CG  HIS B  64      16.494  53.172  24.681  1.00 41.32           C  
ATOM   1125  ND1 HIS B  64      16.340  52.429  25.833  1.00 33.34           N  
ATOM   1126  CD2 HIS B  64      17.295  52.444  23.869  1.00 41.68           C  
ATOM   1127  CE1 HIS B  64      17.011  51.295  25.716  1.00 35.36           C  
ATOM   1128  NE2 HIS B  64      17.598  51.278  24.534  1.00 32.73           N  
ATOM   1129  N   LYS B  65      13.028  56.084  25.339  1.00 41.42           N  
ATOM   1130  CA  LYS B  65      12.318  57.356  25.455  1.00 43.10           C  
ATOM   1131  C   LYS B  65      12.973  58.342  26.418  1.00 41.94           C  
ATOM   1132  O   LYS B  65      13.866  57.974  27.178  1.00 43.72           O  
ATOM   1133  CB  LYS B  65      10.884  57.089  25.935  1.00 43.89           C  
ATOM   1134  CG  LYS B  65      10.023  56.302  24.954  1.00 54.05           C  
ATOM   1135  CD  LYS B  65       8.582  56.125  25.459  1.00 59.80           C  
ATOM   1136  CE  LYS B  65       8.480  55.120  26.599  1.00 63.07           C  
ATOM   1137  NZ  LYS B  65       7.078  54.991  27.104  1.00 65.27           N  
ATOM   1138  N   ILE B  66      12.504  59.589  26.393  1.00 42.05           N  
ATOM   1139  CA  ILE B  66      13.006  60.647  27.271  1.00 43.18           C  
ATOM   1140  C   ILE B  66      12.728  60.300  28.739  1.00 44.39           C  
ATOM   1141  O   ILE B  66      11.669  59.773  29.077  1.00 44.36           O  
ATOM   1142  CB  ILE B  66      12.328  62.008  26.963  1.00 43.34           C  
ATOM   1143  CG1 ILE B  66      12.552  62.389  25.497  1.00 47.83           C  
ATOM   1144  CG2 ILE B  66      12.900  63.084  27.864  1.00 46.22           C  
ATOM   1145  CD1 ILE B  66      11.693  63.550  25.009  1.00 41.66           C  
ATOM   1146  N   GLY B  67      13.690  60.599  29.603  1.00 43.93           N  
ATOM   1147  CA  GLY B  67      13.537  60.317  31.018  1.00 43.10           C  
ATOM   1148  C   GLY B  67      13.919  58.901  31.404  1.00 42.76           C  
ATOM   1149  O   GLY B  67      13.970  58.577  32.587  1.00 47.12           O  
ATOM   1150  N   GLU B  68      14.205  58.054  30.424  1.00 42.60           N  
ATOM   1151  CA  GLU B  68      14.563  56.667  30.717  1.00 45.61           C  
ATOM   1152  C   GLU B  68      16.082  56.442  30.851  1.00 45.34           C  
ATOM   1153  O   GLU B  68      16.885  57.082  30.169  1.00 47.49           O  
ATOM   1154  CB  GLU B  68      13.976  55.754  29.630  1.00 48.64           C  
ATOM   1155  CG  GLU B  68      13.471  54.404  30.138  1.00 57.76           C  
ATOM   1156  CD  GLU B  68      12.352  53.825  29.271  1.00 66.70           C  
ATOM   1157  OE1 GLU B  68      12.430  53.954  28.028  1.00 64.48           O  
ATOM   1158  OE2 GLU B  68      11.399  53.233  29.833  1.00 70.37           O  
ATOM   1159  N   THR B  69      16.466  55.537  31.746  1.00 41.18           N  
ATOM   1160  CA  THR B  69      17.863  55.217  31.979  1.00 37.70           C  
ATOM   1161  C   THR B  69      18.076  53.767  31.576  1.00 39.20           C  
ATOM   1162  O   THR B  69      17.355  52.876  32.030  1.00 39.74           O  
ATOM   1163  CB  THR B  69      18.237  55.413  33.471  1.00 39.04           C  
ATOM   1164  OG1 THR B  69      18.108  56.800  33.814  1.00 40.28           O  
ATOM   1165  CG2 THR B  69      19.676  54.975  33.738  1.00 30.82           C  
ATOM   1166  N   PHE B  70      19.062  53.533  30.716  1.00 35.38           N  
ATOM   1167  CA  PHE B  70      19.348  52.183  30.241  1.00 30.81           C  
ATOM   1168  C   PHE B  70      20.851  51.938  30.139  1.00 28.12           C  
ATOM   1169  O   PHE B  70      21.641  52.870  30.170  1.00 27.36           O  
ATOM   1170  CB  PHE B  70      18.673  51.958  28.870  1.00 32.13           C  
ATOM   1171  CG  PHE B  70      19.004  53.010  27.833  1.00 32.82           C  
ATOM   1172  CD1 PHE B  70      18.356  54.248  27.833  1.00 20.53           C  
ATOM   1173  CD2 PHE B  70      19.984  52.769  26.872  1.00 27.49           C  
ATOM   1174  CE1 PHE B  70      18.686  55.236  26.883  1.00 24.82           C  
ATOM   1175  CE2 PHE B  70      20.324  53.737  25.923  1.00 25.48           C  
ATOM   1176  CZ  PHE B  70      19.675  54.979  25.926  1.00 30.20           C  
ATOM   1177  N   LYS B  71      21.240  50.677  30.024  1.00 32.34           N  
ATOM   1178  CA  LYS B  71      22.644  50.312  29.919  1.00 32.49           C  
ATOM   1179  C   LYS B  71      23.128  50.356  28.470  1.00 35.19           C  
ATOM   1180  O   LYS B  71      22.503  49.784  27.574  1.00 37.22           O  
ATOM   1181  CB  LYS B  71      22.859  48.918  30.484  1.00 34.22           C  
ATOM   1182  CG  LYS B  71      24.290  48.448  30.413  1.00 33.05           C  
ATOM   1183  CD  LYS B  71      24.437  47.058  30.981  1.00 40.82           C  
ATOM   1184  CE  LYS B  71      25.839  46.567  30.770  1.00 38.72           C  
ATOM   1185  NZ  LYS B  71      26.153  46.576  29.318  1.00 48.96           N  
ATOM   1186  N   ALA B  72      24.243  51.047  28.253  1.00 34.23           N  
ATOM   1187  CA  ALA B  72      24.836  51.191  26.928  1.00 31.08           C  
ATOM   1188  C   ALA B  72      26.350  51.224  27.130  1.00 31.29           C  
ATOM   1189  O   ALA B  72      26.900  52.204  27.639  1.00 29.84           O  
ATOM   1190  CB  ALA B  72      24.357  52.472  26.285  1.00 30.52           C  
ATOM   1191  N   GLY B  73      27.011  50.143  26.725  1.00 31.51           N  
ATOM   1192  CA  GLY B  73      28.442  50.045  26.903  1.00 32.40           C  
ATOM   1193  C   GLY B  73      28.732  49.963  28.390  1.00 34.46           C  
ATOM   1194  O   GLY B  73      28.034  49.261  29.130  1.00 35.82           O  
ATOM   1195  N   HIS B  74      29.752  50.697  28.830  1.00 34.87           N  
ATOM   1196  CA  HIS B  74      30.138  50.724  30.237  1.00 32.58           C  
ATOM   1197  C   HIS B  74      29.535  51.921  30.964  1.00 30.37           C  
ATOM   1198  O   HIS B  74      30.126  52.453  31.904  1.00 27.23           O  
ATOM   1199  CB  HIS B  74      31.662  50.771  30.369  1.00 35.16           C  
ATOM   1200  CG  HIS B  74      32.336  49.509  29.938  1.00 36.58           C  
ATOM   1201  ND1 HIS B  74      32.533  49.185  28.613  1.00 42.80           N  
ATOM   1202  CD2 HIS B  74      32.813  48.465  30.657  1.00 41.86           C  
ATOM   1203  CE1 HIS B  74      33.101  47.994  28.534  1.00 48.25           C  
ATOM   1204  NE2 HIS B  74      33.281  47.535  29.761  1.00 47.10           N  
ATOM   1205  N   THR B  75      28.348  52.327  30.532  1.00 30.48           N  
ATOM   1206  CA  THR B  75      27.667  53.466  31.133  1.00 27.59           C  
ATOM   1207  C   THR B  75      26.173  53.247  31.243  1.00 27.64           C  
ATOM   1208  O   THR B  75      25.602  52.468  30.481  1.00 21.79           O  
ATOM   1209  CB  THR B  75      27.773  54.744  30.243  1.00 27.39           C  
ATOM   1210  OG1 THR B  75      27.256  54.451  28.937  1.00 31.35           O  
ATOM   1211  CG2 THR B  75      29.185  55.223  30.114  1.00 31.91           C  
ATOM   1212  N   ASN B  76      25.540  53.907  32.211  1.00 27.81           N  
ATOM   1213  CA  ASN B  76      24.085  53.871  32.250  1.00 31.05           C  
ATOM   1214  C   ASN B  76      23.878  55.218  31.590  1.00 30.68           C  
ATOM   1215  O   ASN B  76      24.561  56.184  31.947  1.00 31.29           O  
ATOM   1216  CB  ASN B  76      23.490  53.917  33.649  1.00 31.93           C  
ATOM   1217  CG  ASN B  76      23.423  52.559  34.280  1.00 33.95           C  
ATOM   1218  OD1 ASN B  76      23.223  51.561  33.593  1.00 36.53           O  
ATOM   1219  ND2 ASN B  76      23.582  52.504  35.595  1.00 32.31           N  
ATOM   1220  N   PHE B  77      22.966  55.293  30.631  1.00 29.52           N  
ATOM   1221  CA  PHE B  77      22.733  56.539  29.929  1.00 33.28           C  
ATOM   1222  C   PHE B  77      21.289  56.985  29.991  1.00 34.40           C  
ATOM   1223  O   PHE B  77      20.366  56.162  29.999  1.00 34.30           O  
ATOM   1224  CB  PHE B  77      23.119  56.404  28.455  1.00 31.29           C  
ATOM   1225  CG  PHE B  77      22.892  57.656  27.653  1.00 26.62           C  
ATOM   1226  CD1 PHE B  77      23.723  58.752  27.814  1.00 20.89           C  
ATOM   1227  CD2 PHE B  77      21.838  57.747  26.750  1.00 22.14           C  
ATOM   1228  CE1 PHE B  77      23.512  59.927  27.088  1.00 26.82           C  
ATOM   1229  CE2 PHE B  77      21.617  58.911  26.021  1.00 31.63           C  
ATOM   1230  CZ  PHE B  77      22.454  60.005  26.191  1.00 21.75           C  
ATOM   1231  N   THR B  78      21.081  58.293  30.018  1.00 39.70           N  
ATOM   1232  CA  THR B  78      19.721  58.775  30.037  1.00 42.47           C  
ATOM   1233  C   THR B  78      19.568  60.201  29.505  1.00 42.59           C  
ATOM   1234  O   THR B  78      20.435  61.062  29.690  1.00 40.83           O  
ATOM   1235  CB  THR B  78      19.099  58.619  31.480  1.00 43.22           C  
ATOM   1236  OG1 THR B  78      17.801  59.229  31.517  1.00 54.25           O  
ATOM   1237  CG2 THR B  78      19.984  59.230  32.533  1.00 39.12           C  
ATOM   1238  N   VAL B  79      18.474  60.418  28.783  1.00 44.49           N  
ATOM   1239  CA  VAL B  79      18.152  61.735  28.254  1.00 46.49           C  
ATOM   1240  C   VAL B  79      17.154  62.285  29.276  1.00 48.42           C  
ATOM   1241  O   VAL B  79      16.002  61.851  29.329  1.00 49.41           O  
ATOM   1242  CB  VAL B  79      17.481  61.650  26.877  1.00 45.71           C  
ATOM   1243  CG1 VAL B  79      17.147  63.053  26.390  1.00 45.31           C  
ATOM   1244  CG2 VAL B  79      18.397  60.936  25.891  1.00 46.95           C  
ATOM   1245  N   ASN B  80      17.599  63.226  30.099  1.00 50.92           N  
ATOM   1246  CA  ASN B  80      16.734  63.774  31.137  1.00 53.12           C  
ATOM   1247  C   ASN B  80      15.673  64.741  30.603  1.00 56.94           C  
ATOM   1248  O   ASN B  80      14.502  64.377  30.483  1.00 57.53           O  
ATOM   1249  CB  ASN B  80      17.597  64.429  32.219  1.00 51.82           C  
ATOM   1250  CG  ASN B  80      18.800  63.566  32.602  1.00 49.00           C  
ATOM   1251  OD1 ASN B  80      19.941  63.876  32.240  1.00 51.38           O  
ATOM   1252  ND2 ASN B  80      18.547  62.472  33.319  1.00 47.94           N  
ATOM   1253  N   LYS B  81      16.071  65.963  30.282  1.00 61.49           N  
ATOM   1254  CA  LYS B  81      15.122  66.931  29.749  1.00 64.64           C  
ATOM   1255  C   LYS B  81      15.417  67.217  28.285  1.00 65.92           C  
ATOM   1256  O   LYS B  81      16.560  67.123  27.845  1.00 66.69           O  
ATOM   1257  CB  LYS B  81      15.197  68.243  30.548  1.00 64.93           C  
ATOM   1258  N   VAL B  82      14.375  67.529  27.524  1.00 69.84           N  
ATOM   1259  CA  VAL B  82      14.544  67.903  26.125  1.00 71.58           C  
ATOM   1260  C   VAL B  82      13.838  69.251  26.020  1.00 75.13           C  
ATOM   1261  O   VAL B  82      12.671  69.332  25.633  1.00 77.22           O  
ATOM   1262  CB  VAL B  82      13.896  66.909  25.132  1.00 70.82           C  
ATOM   1263  CG1 VAL B  82      14.248  67.321  23.705  1.00 69.04           C  
ATOM   1264  CG2 VAL B  82      14.386  65.494  25.402  1.00 68.67           C  
ATOM   1265  N   ASP B  83      14.554  70.305  26.406  1.00 79.20           N  
ATOM   1266  CA  ASP B  83      14.025  71.666  26.379  1.00 80.45           C  
ATOM   1267  C   ASP B  83      13.879  72.132  24.937  1.00 80.24           C  
ATOM   1268  O   ASP B  83      14.401  71.500  24.019  1.00 79.96           O  
ATOM   1269  CB  ASP B  83      14.967  72.612  27.127  1.00 81.42           C  
ATOM   1270  CG  ASP B  83      14.246  73.480  28.136  1.00 86.77           C  
ATOM   1271  OD1 ASP B  83      13.327  74.227  27.738  1.00 94.38           O  
ATOM   1272  OD2 ASP B  83      14.603  73.414  29.333  1.00 88.69           O  
ATOM   1273  N   ARG B  84      13.172  73.240  24.740  1.00 80.76           N  
ATOM   1274  CA  ARG B  84      12.964  73.771  23.400  1.00 81.44           C  
ATOM   1275  C   ARG B  84      13.218  75.282  23.344  1.00 80.87           C  
ATOM   1276  O   ARG B  84      13.190  75.889  22.270  1.00 80.96           O  
ATOM   1277  CB  ARG B  84      11.549  73.418  22.922  1.00 82.58           C  
ATOM   1278  CG  ARG B  84      11.271  71.905  22.926  1.00 84.32           C  
ATOM   1279  CD  ARG B  84       9.985  71.551  22.190  1.00 89.46           C  
ATOM   1280  NE  ARG B  84       9.916  72.216  20.890  1.00 96.46           N  
ATOM   1281  CZ  ARG B  84       9.006  71.956  19.955  1.00 99.01           C  
ATOM   1282  NH1 ARG B  84       8.076  71.033  20.162  1.00 99.01           N  
ATOM   1283  NH2 ARG B  84       9.019  72.630  18.811  1.00 99.01           N  
ATOM   1284  N   VAL B  85      13.476  75.874  24.509  1.00 80.22           N  
ATOM   1285  CA  VAL B  85      13.771  77.298  24.613  1.00 79.82           C  
ATOM   1286  C   VAL B  85      14.860  77.639  23.593  1.00 79.32           C  
ATOM   1287  O   VAL B  85      15.435  78.727  23.601  1.00 76.73           O  
ATOM   1288  CB  VAL B  85      14.255  77.621  26.016  1.00 80.78           C  
ATOM   1289  N   GLU B  89      21.140  83.532  18.504  1.00 42.64           N  
ATOM   1290  CA  GLU B  89      21.692  83.731  19.844  1.00 42.43           C  
ATOM   1291  C   GLU B  89      22.553  82.533  20.225  1.00 46.16           C  
ATOM   1292  O   GLU B  89      22.650  82.193  21.408  1.00 43.47           O  
ATOM   1293  CB  GLU B  89      20.550  83.884  20.850  1.00 36.15           C  
ATOM   1294  N   TYR B  90      23.197  81.918  19.227  1.00 54.82           N  
ATOM   1295  CA  TYR B  90      24.005  80.711  19.446  1.00 61.15           C  
ATOM   1296  C   TYR B  90      25.210  80.546  18.507  1.00 64.02           C  
ATOM   1297  O   TYR B  90      25.423  81.349  17.604  1.00 64.68           O  
ATOM   1298  CB  TYR B  90      23.109  79.493  19.256  1.00 61.51           C  
ATOM   1299  CG  TYR B  90      22.711  79.291  17.806  1.00 64.88           C  
ATOM   1300  CD1 TYR B  90      21.624  79.970  17.246  1.00 66.53           C  
ATOM   1301  CD2 TYR B  90      23.436  78.425  16.987  1.00 66.45           C  
ATOM   1302  CE1 TYR B  90      21.276  79.787  15.902  1.00 66.08           C  
ATOM   1303  CE2 TYR B  90      23.096  78.239  15.648  1.00 66.95           C  
ATOM   1304  CZ  TYR B  90      22.015  78.919  15.114  1.00 71.05           C  
ATOM   1305  OH  TYR B  90      21.676  78.728  13.794  1.00 78.25           O  
HETATM 1306  N   MSE B  91      25.968  79.466  18.705  1.00 68.35           N  
HETATM 1307  CA  MSE B  91      27.148  79.183  17.881  1.00 72.53           C  
HETATM 1308  C   MSE B  91      27.214  77.735  17.388  1.00 72.32           C  
HETATM 1309  O   MSE B  91      26.361  76.916  17.719  1.00 72.90           O  
HETATM 1310  CB  MSE B  91      28.424  79.493  18.666  1.00 74.84           C  
HETATM 1311  CG  MSE B  91      28.562  80.937  19.116  1.00 83.43           C  
HETATM 1312 SE   MSE B  91      30.131  81.195  20.222  1.00 99.01          SE  
HETATM 1313  CE  MSE B  91      29.314  81.017  21.973  1.00 99.01           C  
ATOM   1314  N   ASN B  92      28.242  77.424  16.603  1.00 71.82           N  
ATOM   1315  CA  ASN B  92      28.417  76.074  16.069  1.00 71.98           C  
ATOM   1316  C   ASN B  92      29.632  75.325  16.634  1.00 71.80           C  
ATOM   1317  O   ASN B  92      30.574  75.940  17.138  1.00 70.62           O  
ATOM   1318  CB  ASN B  92      28.511  76.131  14.544  1.00 71.70           C  
ATOM   1319  CG  ASN B  92      27.170  75.951  13.876  1.00 74.08           C  
ATOM   1320  OD1 ASN B  92      26.219  76.682  14.154  1.00 80.67           O  
ATOM   1321  ND2 ASN B  92      27.084  74.969  12.985  1.00 74.70           N  
ATOM   1322  N   VAL B  93      29.597  73.994  16.552  1.00 71.39           N  
ATOM   1323  CA  VAL B  93      30.693  73.153  17.045  1.00 71.28           C  
ATOM   1324  C   VAL B  93      31.714  72.893  15.928  1.00 71.65           C  
ATOM   1325  O   VAL B  93      31.405  72.276  14.906  1.00 69.95           O  
ATOM   1326  CB  VAL B  93      30.155  71.804  17.594  1.00 70.37           C  
ATOM   1327  CG1 VAL B  93      31.311  70.892  17.970  1.00 69.57           C  
ATOM   1328  CG2 VAL B  93      29.264  72.055  18.813  1.00 68.56           C  
ATOM   1329  N   GLY B  94      32.935  73.372  16.129  1.00 72.73           N  
ATOM   1330  CA  GLY B  94      33.956  73.192  15.116  1.00 75.70           C  
ATOM   1331  C   GLY B  94      33.554  73.945  13.857  1.00 76.10           C  
ATOM   1332  O   GLY B  94      33.915  73.581  12.734  1.00 76.45           O  
ATOM   1333  N   LYS B 102      30.259  87.252  13.165  1.00 98.96           N  
ATOM   1334  CA  LYS B 102      29.677  86.254  12.275  1.00 99.01           C  
ATOM   1335  C   LYS B 102      28.655  85.400  13.024  1.00 99.01           C  
ATOM   1336  O   LYS B 102      28.618  84.178  12.871  1.00 99.01           O  
ATOM   1337  CB  LYS B 102      30.778  85.372  11.696  1.00 99.01           C  
ATOM   1338  N   THR B 103      27.822  86.057  13.826  1.00 98.45           N  
ATOM   1339  CA  THR B 103      26.800  85.377  14.619  1.00 97.85           C  
ATOM   1340  C   THR B 103      25.685  84.756  13.779  1.00 97.19           C  
ATOM   1341  O   THR B 103      25.458  85.159  12.640  1.00 96.71           O  
ATOM   1342  CB  THR B 103      26.198  86.360  15.620  1.00 98.26           C  
ATOM   1343  N   ILE B 104      24.991  83.771  14.344  1.00 96.79           N  
ATOM   1344  CA  ILE B 104      23.884  83.126  13.639  1.00 95.63           C  
ATOM   1345  C   ILE B 104      22.592  83.219  14.461  1.00 95.12           C  
ATOM   1346  O   ILE B 104      22.624  83.473  15.670  1.00 94.85           O  
ATOM   1347  CB  ILE B 104      24.151  81.614  13.367  1.00 95.66           C  
ATOM   1348  CG1 ILE B 104      25.559  81.399  12.806  1.00 95.14           C  
ATOM   1349  CG2 ILE B 104      23.125  81.092  12.357  1.00 95.78           C  
ATOM   1350  CD1 ILE B 104      26.081  79.984  13.001  1.00 89.70           C  
ATOM   1351  N   LYS B 105      21.458  83.031  13.785  1.00 94.42           N  
ATOM   1352  CA  LYS B 105      20.142  83.043  14.428  1.00 93.01           C  
ATOM   1353  C   LYS B 105      19.342  81.835  13.914  1.00 92.22           C  
ATOM   1354  O   LYS B 105      19.555  81.366  12.792  1.00 92.12           O  
ATOM   1355  CB  LYS B 105      19.406  84.352  14.147  1.00 93.27           C  
ATOM   1356  N   ASP B 106      18.426  81.338  14.743  1.00 91.61           N  
ATOM   1357  CA  ASP B 106      17.625  80.156  14.420  1.00 90.89           C  
ATOM   1358  C   ASP B 106      17.324  79.921  12.945  1.00 90.67           C  
ATOM   1359  O   ASP B 106      16.808  78.864  12.579  1.00 88.64           O  
ATOM   1360  CB  ASP B 106      16.322  80.169  15.218  1.00 91.00           C  
ATOM   1361  N   ARG B 110      15.418  76.177  19.140  1.00 64.17           N  
ATOM   1362  CA  ARG B 110      16.652  75.438  19.378  1.00 64.66           C  
ATOM   1363  C   ARG B 110      16.517  74.461  20.539  1.00 64.93           C  
ATOM   1364  O   ARG B 110      16.179  74.851  21.659  1.00 66.44           O  
ATOM   1365  CB  ARG B 110      17.809  76.406  19.662  1.00 65.39           C  
ATOM   1366  CG  ARG B 110      19.172  75.723  19.815  1.00 64.87           C  
ATOM   1367  CD  ARG B 110      20.312  76.735  19.914  1.00 64.47           C  
ATOM   1368  NE  ARG B 110      20.222  77.561  21.114  1.00 67.41           N  
ATOM   1369  CZ  ARG B 110      20.440  77.121  22.350  1.00 66.55           C  
ATOM   1370  NH1 ARG B 110      20.769  75.854  22.563  1.00 73.11           N  
ATOM   1371  NH2 ARG B 110      20.318  77.953  23.376  1.00 64.59           N  
ATOM   1372  N   LEU B 111      16.793  73.191  20.264  1.00 64.65           N  
ATOM   1373  CA  LEU B 111      16.715  72.137  21.270  1.00 62.03           C  
ATOM   1374  C   LEU B 111      17.869  72.170  22.262  1.00 59.00           C  
ATOM   1375  O   LEU B 111      19.013  72.435  21.890  1.00 57.78           O  
ATOM   1376  CB  LEU B 111      16.727  70.757  20.597  1.00 61.33           C  
ATOM   1377  CG  LEU B 111      15.467  70.244  19.898  1.00 64.27           C  
ATOM   1378  CD1 LEU B 111      14.815  71.391  19.158  1.00 64.94           C  
ATOM   1379  CD2 LEU B 111      15.819  69.087  18.950  1.00 59.44           C  
ATOM   1380  N   ILE B 112      17.551  71.911  23.527  1.00 58.17           N  
ATOM   1381  CA  ILE B 112      18.556  71.823  24.577  1.00 57.33           C  
ATOM   1382  C   ILE B 112      18.279  70.491  25.259  1.00 56.50           C  
ATOM   1383  O   ILE B 112      17.389  70.382  26.109  1.00 56.18           O  
ATOM   1384  CB  ILE B 112      18.448  72.929  25.632  1.00 58.81           C  
ATOM   1385  CG1 ILE B 112      18.537  74.304  24.970  1.00 60.33           C  
ATOM   1386  CG2 ILE B 112      19.584  72.760  26.648  1.00 59.88           C  
ATOM   1387  CD1 ILE B 112      18.341  75.446  25.937  1.00 65.63           C  
ATOM   1388  N   ILE B 113      19.039  69.478  24.860  1.00 54.81           N  
ATOM   1389  CA  ILE B 113      18.896  68.129  25.398  1.00 53.30           C  
ATOM   1390  C   ILE B 113      19.874  67.924  26.554  1.00 52.01           C  
ATOM   1391  O   ILE B 113      21.088  68.053  26.377  1.00 52.10           O  
ATOM   1392  CB  ILE B 113      19.184  67.074  24.282  1.00 53.31           C  
ATOM   1393  CG1 ILE B 113      18.250  67.315  23.092  1.00 50.55           C  
ATOM   1394  CG2 ILE B 113      18.987  65.656  24.808  1.00 49.83           C  
ATOM   1395  CD1 ILE B 113      18.615  66.533  21.861  1.00 48.57           C  
ATOM   1396  N   GLU B 114      19.347  67.637  27.741  1.00 50.49           N  
ATOM   1397  CA  GLU B 114      20.202  67.392  28.897  1.00 51.09           C  
ATOM   1398  C   GLU B 114      20.365  65.889  29.022  1.00 49.09           C  
ATOM   1399  O   GLU B 114      19.374  65.157  29.108  1.00 48.89           O  
ATOM   1400  CB  GLU B 114      19.603  67.941  30.202  1.00 50.56           C  
ATOM   1401  CG  GLU B 114      20.494  67.609  31.409  1.00 57.13           C  
ATOM   1402  CD  GLU B 114      19.984  68.145  32.731  1.00 65.33           C  
ATOM   1403  OE1 GLU B 114      20.095  69.366  32.967  1.00 66.77           O  
ATOM   1404  OE2 GLU B 114      19.470  67.338  33.538  1.00 72.17           O  
ATOM   1405  N   VAL B 115      21.615  65.432  29.023  1.00 47.54           N  
ATOM   1406  CA  VAL B 115      21.901  64.005  29.127  1.00 44.05           C  
ATOM   1407  C   VAL B 115      22.790  63.688  30.321  1.00 42.66           C  
ATOM   1408  O   VAL B 115      23.468  64.569  30.856  1.00 42.89           O  
ATOM   1409  CB  VAL B 115      22.578  63.472  27.827  1.00 44.54           C  
ATOM   1410  CG1 VAL B 115      21.790  63.936  26.610  1.00 41.91           C  
ATOM   1411  CG2 VAL B 115      24.024  63.943  27.735  1.00 40.89           C  
ATOM   1412  N   THR B 116      22.763  62.430  30.752  1.00 39.54           N  
ATOM   1413  CA  THR B 116      23.590  61.992  31.867  1.00 39.78           C  
ATOM   1414  C   THR B 116      24.257  60.660  31.541  1.00 37.54           C  
ATOM   1415  O   THR B 116      23.615  59.738  31.039  1.00 39.77           O  
ATOM   1416  CB  THR B 116      22.774  61.804  33.185  1.00 41.21           C  
ATOM   1417  OG1 THR B 116      22.207  63.055  33.595  1.00 46.05           O  
ATOM   1418  CG2 THR B 116      23.690  61.302  34.298  1.00 32.46           C  
HETATM 1419  N   MSE B 117      25.550  60.576  31.820  1.00 37.19           N  
HETATM 1420  CA  MSE B 117      26.318  59.360  31.599  1.00 36.83           C  
HETATM 1421  C   MSE B 117      26.880  58.955  32.935  1.00 36.16           C  
HETATM 1422  O   MSE B 117      27.515  59.761  33.621  1.00 36.95           O  
HETATM 1423  CB  MSE B 117      27.512  59.578  30.661  1.00 38.32           C  
HETATM 1424  CG  MSE B 117      27.196  59.748  29.201  1.00 42.55           C  
HETATM 1425 SE   MSE B 117      28.742  60.433  28.203  1.00 59.19          SE  
HETATM 1426  CE  MSE B 117      29.929  58.890  28.340  1.00 32.46           C  
ATOM   1427  N   GLU B 118      26.665  57.699  33.291  1.00 37.91           N  
ATOM   1428  CA  GLU B 118      27.166  57.155  34.539  1.00 36.13           C  
ATOM   1429  C   GLU B 118      28.107  55.993  34.196  1.00 37.77           C  
ATOM   1430  O   GLU B 118      27.725  55.061  33.489  1.00 37.61           O  
ATOM   1431  CB  GLU B 118      25.979  56.689  35.385  1.00 39.00           C  
ATOM   1432  CG  GLU B 118      26.305  55.796  36.556  1.00 38.84           C  
ATOM   1433  CD  GLU B 118      25.049  55.367  37.298  1.00 51.60           C  
ATOM   1434  OE1 GLU B 118      24.035  55.073  36.627  1.00 46.24           O  
ATOM   1435  OE2 GLU B 118      25.077  55.315  38.543  1.00 53.93           O  
ATOM   1436  N   ASN B 119      29.342  56.068  34.686  1.00 34.42           N  
ATOM   1437  CA  ASN B 119      30.346  55.039  34.436  1.00 31.08           C  
ATOM   1438  C   ASN B 119      30.189  53.879  35.414  1.00 33.76           C  
ATOM   1439  O   ASN B 119      30.436  54.029  36.612  1.00 32.11           O  
ATOM   1440  CB  ASN B 119      31.748  55.646  34.570  1.00 28.81           C  
ATOM   1441  CG  ASN B 119      32.843  54.723  34.057  1.00 28.53           C  
ATOM   1442  OD1 ASN B 119      34.022  55.079  34.062  1.00 45.22           O  
ATOM   1443  ND2 ASN B 119      32.461  53.535  33.617  1.00 27.72           N  
ATOM   1444  N   ILE B 120      29.787  52.726  34.889  1.00 34.92           N  
ATOM   1445  CA  ILE B 120      29.578  51.511  35.680  1.00 35.33           C  
ATOM   1446  C   ILE B 120      30.661  50.466  35.399  1.00 35.16           C  
ATOM   1447  O   ILE B 120      30.509  49.294  35.753  1.00 37.13           O  
ATOM   1448  CB  ILE B 120      28.231  50.867  35.334  1.00 34.62           C  
ATOM   1449  CG1 ILE B 120      28.219  50.516  33.838  1.00 34.40           C  
ATOM   1450  CG2 ILE B 120      27.080  51.821  35.691  1.00 27.36           C  
ATOM   1451  CD1 ILE B 120      27.016  49.689  33.382  1.00 35.48           C  
ATOM   1452  N   GLY B 121      31.735  50.885  34.739  1.00 36.20           N  
ATOM   1453  CA  GLY B 121      32.812  49.965  34.425  1.00 35.50           C  
ATOM   1454  C   GLY B 121      34.037  50.248  35.276  1.00 35.09           C  
ATOM   1455  O   GLY B 121      34.012  51.141  36.117  1.00 35.27           O  
ATOM   1456  N   GLU B 122      35.116  49.502  35.060  1.00 37.94           N  
ATOM   1457  CA  GLU B 122      36.327  49.705  35.848  1.00 39.60           C  
ATOM   1458  C   GLU B 122      37.218  50.818  35.303  1.00 37.50           C  
ATOM   1459  O   GLU B 122      37.622  51.722  36.044  1.00 39.86           O  
ATOM   1460  CB  GLU B 122      37.152  48.417  35.927  1.00 40.34           C  
ATOM   1461  CG  GLU B 122      38.269  48.497  36.973  1.00 40.68           C  
ATOM   1462  CD  GLU B 122      39.246  47.336  36.896  1.00 44.55           C  
ATOM   1463  OE1 GLU B 122      38.878  46.280  36.334  1.00 54.52           O  
ATOM   1464  OE2 GLU B 122      40.375  47.475  37.409  1.00 52.31           O  
ATOM   1465  N   ASP B 123      37.539  50.744  34.018  1.00 36.95           N  
ATOM   1466  CA  ASP B 123      38.388  51.759  33.422  1.00 35.84           C  
ATOM   1467  C   ASP B 123      37.719  53.128  33.431  1.00 35.65           C  
ATOM   1468  O   ASP B 123      36.498  53.243  33.346  1.00 37.17           O  
ATOM   1469  CB  ASP B 123      38.741  51.404  31.969  1.00 37.57           C  
ATOM   1470  CG  ASP B 123      39.534  50.119  31.851  1.00 39.85           C  
ATOM   1471  OD1 ASP B 123      40.387  49.877  32.726  1.00 48.78           O  
ATOM   1472  OD2 ASP B 123      39.321  49.360  30.878  1.00 44.55           O  
ATOM   1473  N   SER B 124      38.537  54.165  33.540  1.00 35.43           N  
ATOM   1474  CA  SER B 124      38.041  55.525  33.517  1.00 29.53           C  
ATOM   1475  C   SER B 124      37.550  55.772  32.086  1.00 28.94           C  
ATOM   1476  O   SER B 124      38.034  55.149  31.140  1.00 25.08           O  
ATOM   1477  CB  SER B 124      39.172  56.505  33.850  1.00 28.68           C  
ATOM   1478  OG  SER B 124      38.667  57.823  33.978  1.00 30.86           O  
ATOM   1479  N   ILE B 125      36.585  56.674  31.945  1.00 27.55           N  
ATOM   1480  CA  ILE B 125      36.026  57.010  30.643  1.00 28.83           C  
ATOM   1481  C   ILE B 125      36.306  58.485  30.309  1.00 27.36           C  
ATOM   1482  O   ILE B 125      36.229  59.357  31.178  1.00 26.68           O  
ATOM   1483  CB  ILE B 125      34.478  56.811  30.611  1.00 28.24           C  
ATOM   1484  CG1 ILE B 125      34.112  55.328  30.708  1.00 22.91           C  
ATOM   1485  CG2 ILE B 125      33.897  57.429  29.337  1.00 16.41           C  
ATOM   1486  CD1 ILE B 125      32.575  55.093  30.741  1.00 27.46           C  
ATOM   1487  N   SER B 126      36.654  58.744  29.055  1.00 28.03           N  
ATOM   1488  CA  SER B 126      36.898  60.099  28.578  1.00 30.12           C  
ATOM   1489  C   SER B 126      35.743  60.389  27.627  1.00 30.26           C  
ATOM   1490  O   SER B 126      35.812  60.066  26.440  1.00 30.13           O  
ATOM   1491  CB  SER B 126      38.221  60.198  27.815  1.00 27.50           C  
ATOM   1492  OG  SER B 126      39.334  59.986  28.672  1.00 33.58           O  
ATOM   1493  N   TYR B 127      34.680  60.983  28.161  1.00 30.49           N  
ATOM   1494  CA  TYR B 127      33.501  61.301  27.367  1.00 31.22           C  
ATOM   1495  C   TYR B 127      33.796  62.419  26.388  1.00 31.20           C  
ATOM   1496  O   TYR B 127      34.629  63.294  26.650  1.00 28.76           O  
ATOM   1497  CB  TYR B 127      32.319  61.651  28.285  1.00 31.79           C  
ATOM   1498  CG  TYR B 127      32.483  62.907  29.103  1.00 37.88           C  
ATOM   1499  CD1 TYR B 127      31.970  64.123  28.654  1.00 39.85           C  
ATOM   1500  CD2 TYR B 127      33.133  62.878  30.338  1.00 42.56           C  
ATOM   1501  CE1 TYR B 127      32.084  65.272  29.415  1.00 39.56           C  
ATOM   1502  CE2 TYR B 127      33.253  64.016  31.108  1.00 34.11           C  
ATOM   1503  CZ  TYR B 127      32.731  65.215  30.643  1.00 39.29           C  
ATOM   1504  OH  TYR B 127      32.856  66.353  31.409  1.00 45.87           O  
ATOM   1505  N   ASN B 128      33.119  62.382  25.247  1.00 31.43           N  
ATOM   1506  CA  ASN B 128      33.361  63.372  24.206  1.00 29.88           C  
ATOM   1507  C   ASN B 128      32.100  63.581  23.387  1.00 30.91           C  
ATOM   1508  O   ASN B 128      31.338  62.646  23.165  1.00 25.72           O  
ATOM   1509  CB  ASN B 128      34.510  62.873  23.325  1.00 23.91           C  
ATOM   1510  CG  ASN B 128      35.133  63.966  22.484  1.00 24.94           C  
ATOM   1511  OD1 ASN B 128      34.524  64.454  21.543  1.00 32.04           O  
ATOM   1512  ND2 ASN B 128      36.357  64.355  22.819  1.00 19.61           N  
ATOM   1513  N   PHE B 129      31.892  64.813  22.933  1.00 31.54           N  
ATOM   1514  CA  PHE B 129      30.699  65.135  22.163  1.00 30.41           C  
ATOM   1515  C   PHE B 129      30.548  64.310  20.888  1.00 29.70           C  
ATOM   1516  O   PHE B 129      29.431  64.148  20.400  1.00 31.14           O  
ATOM   1517  CB  PHE B 129      30.658  66.644  21.847  1.00 31.54           C  
ATOM   1518  CG  PHE B 129      31.605  67.077  20.770  1.00 31.11           C  
ATOM   1519  CD1 PHE B 129      31.206  67.073  19.437  1.00 29.25           C  
ATOM   1520  CD2 PHE B 129      32.890  67.506  21.086  1.00 27.65           C  
ATOM   1521  CE1 PHE B 129      32.071  67.497  18.428  1.00 34.59           C  
ATOM   1522  CE2 PHE B 129      33.767  67.929  20.083  1.00 30.35           C  
ATOM   1523  CZ  PHE B 129      33.355  67.926  18.754  1.00 30.71           C  
ATOM   1524  N   ILE B 130      31.643  63.751  20.376  1.00 26.93           N  
ATOM   1525  CA  ILE B 130      31.557  62.966  19.144  1.00 29.16           C  
ATOM   1526  C   ILE B 130      30.707  61.711  19.247  1.00 29.33           C  
ATOM   1527  O   ILE B 130      30.241  61.186  18.237  1.00 31.61           O  
ATOM   1528  CB  ILE B 130      32.959  62.571  18.583  1.00 27.11           C  
ATOM   1529  CG1 ILE B 130      33.809  61.888  19.662  1.00 25.87           C  
ATOM   1530  CG2 ILE B 130      33.652  63.813  18.024  1.00 26.13           C  
ATOM   1531  CD1 ILE B 130      35.034  61.145  19.106  1.00 20.78           C  
ATOM   1532  N   GLY B 131      30.485  61.239  20.463  1.00 28.36           N  
ATOM   1533  CA  GLY B 131      29.682  60.046  20.640  1.00 30.73           C  
ATOM   1534  C   GLY B 131      28.195  60.284  20.432  1.00 29.09           C  
ATOM   1535  O   GLY B 131      27.419  59.340  20.434  1.00 31.74           O  
ATOM   1536  N   PHE B 132      27.795  61.536  20.245  1.00 34.05           N  
ATOM   1537  CA  PHE B 132      26.383  61.859  20.058  1.00 35.65           C  
ATOM   1538  C   PHE B 132      26.002  62.273  18.630  1.00 36.72           C  
ATOM   1539  O   PHE B 132      26.861  62.547  17.793  1.00 32.75           O  
ATOM   1540  CB  PHE B 132      25.976  62.976  21.029  1.00 33.85           C  
ATOM   1541  CG  PHE B 132      26.269  62.656  22.463  1.00 35.13           C  
ATOM   1542  CD1 PHE B 132      27.478  63.028  23.042  1.00 21.89           C  
ATOM   1543  CD2 PHE B 132      25.368  61.910  23.211  1.00 28.34           C  
ATOM   1544  CE1 PHE B 132      27.790  62.654  24.342  1.00 28.25           C  
ATOM   1545  CE2 PHE B 132      25.674  61.527  24.520  1.00 37.72           C  
ATOM   1546  CZ  PHE B 132      26.890  61.901  25.082  1.00 24.46           C  
ATOM   1547  N   ASP B 133      24.702  62.305  18.364  1.00 40.10           N  
ATOM   1548  CA  ASP B 133      24.198  62.707  17.059  1.00 44.57           C  
ATOM   1549  C   ASP B 133      22.674  62.786  17.058  1.00 44.32           C  
ATOM   1550  O   ASP B 133      22.003  61.994  17.723  1.00 45.40           O  
ATOM   1551  CB  ASP B 133      24.659  61.725  15.971  1.00 43.88           C  
ATOM   1552  CG  ASP B 133      24.465  62.281  14.566  1.00 46.92           C  
ATOM   1553  OD1 ASP B 133      24.169  63.490  14.446  1.00 47.51           O  
ATOM   1554  OD2 ASP B 133      24.614  61.516  13.584  1.00 44.74           O  
ATOM   1555  N   LEU B 134      22.130  63.765  16.340  1.00 47.86           N  
ATOM   1556  CA  LEU B 134      20.679  63.902  16.236  1.00 50.63           C  
ATOM   1557  C   LEU B 134      20.336  63.534  14.794  1.00 53.23           C  
ATOM   1558  O   LEU B 134      21.088  63.851  13.866  1.00 53.12           O  
ATOM   1559  CB  LEU B 134      20.220  65.337  16.541  1.00 50.36           C  
ATOM   1560  CG  LEU B 134      18.709  65.623  16.679  1.00 51.99           C  
ATOM   1561  CD1 LEU B 134      18.161  65.132  18.027  1.00 43.11           C  
ATOM   1562  CD2 LEU B 134      18.489  67.129  16.554  1.00 47.91           C  
ATOM   1563  N   ARG B 135      19.221  62.834  14.611  1.00 56.25           N  
ATOM   1564  CA  ARG B 135      18.792  62.434  13.277  1.00 60.02           C  
ATOM   1565  C   ARG B 135      17.317  62.760  13.053  1.00 62.65           C  
ATOM   1566  O   ARG B 135      16.626  63.215  13.968  1.00 63.60           O  
ATOM   1567  CB  ARG B 135      19.050  60.934  13.058  1.00 58.38           C  
ATOM   1568  CG  ARG B 135      20.529  60.601  12.927  1.00 58.71           C  
ATOM   1569  CD  ARG B 135      20.807  59.107  12.887  1.00 54.71           C  
ATOM   1570  NE  ARG B 135      22.204  58.834  13.220  1.00 51.27           N  
ATOM   1571  CZ  ARG B 135      22.726  57.619  13.363  1.00 51.05           C  
ATOM   1572  NH1 ARG B 135      21.968  56.542  13.196  1.00 51.41           N  
ATOM   1573  NH2 ARG B 135      24.007  57.484  13.689  1.00 44.46           N  
ATOM   1574  N   ASP B 136      16.851  62.538  11.827  1.00 66.90           N  
ATOM   1575  CA  ASP B 136      15.462  62.797  11.464  1.00 70.84           C  
ATOM   1576  C   ASP B 136      14.855  61.560  10.819  1.00 73.37           C  
ATOM   1577  O   ASP B 136      15.479  60.497  10.794  1.00 73.81           O  
ATOM   1578  CB  ASP B 136      15.374  63.998  10.516  1.00 70.42           C  
ATOM   1579  CG  ASP B 136      16.241  63.837   9.280  1.00 71.44           C  
ATOM   1580  OD1 ASP B 136      16.750  64.865   8.782  1.00 68.08           O  
ATOM   1581  OD2 ASP B 136      16.407  62.693   8.802  1.00 71.48           O  
ATOM   1582  N   LYS B 137      13.643  61.703  10.293  1.00 75.80           N  
ATOM   1583  CA  LYS B 137      12.933  60.586   9.677  1.00 78.05           C  
ATOM   1584  C   LYS B 137      13.800  59.775   8.713  1.00 78.68           C  
ATOM   1585  O   LYS B 137      13.765  58.543   8.723  1.00 77.91           O  
ATOM   1586  CB  LYS B 137      11.686  61.113   8.952  1.00 78.87           C  
ATOM   1587  CG  LYS B 137      10.449  60.207   9.022  1.00 79.39           C  
ATOM   1588  CD  LYS B 137      10.521  59.041   8.045  1.00 81.70           C  
ATOM   1589  CE  LYS B 137       9.173  58.339   7.901  1.00 84.52           C  
ATOM   1590  NZ  LYS B 137       8.211  59.094   7.047  1.00 81.71           N  
ATOM   1591  N   ASN B 138      14.591  60.474   7.902  1.00 79.36           N  
ATOM   1592  CA  ASN B 138      15.448  59.827   6.915  1.00 80.14           C  
ATOM   1593  C   ASN B 138      16.826  59.384   7.415  1.00 80.89           C  
ATOM   1594  O   ASN B 138      17.639  58.892   6.626  1.00 81.53           O  
ATOM   1595  CB  ASN B 138      15.607  60.748   5.699  1.00 80.48           C  
ATOM   1596  CG  ASN B 138      16.372  60.092   4.561  1.00 81.82           C  
ATOM   1597  OD1 ASN B 138      17.430  60.570   4.155  1.00 85.15           O  
ATOM   1598  ND2 ASN B 138      15.837  58.991   4.041  1.00 81.29           N  
ATOM   1599  N   ASP B 139      17.092  59.550   8.711  1.00 79.26           N  
ATOM   1600  CA  ASP B 139      18.378  59.133   9.270  1.00 77.84           C  
ATOM   1601  C   ASP B 139      19.446  60.101   8.772  1.00 75.95           C  
ATOM   1602  O   ASP B 139      20.506  59.696   8.292  1.00 74.78           O  
ATOM   1603  CB  ASP B 139      18.671  57.699   8.807  1.00 78.75           C  
ATOM   1604  CG  ASP B 139      19.992  57.170   9.313  1.00 83.55           C  
ATOM   1605  OD1 ASP B 139      20.249  57.290  10.531  1.00 88.06           O  
ATOM   1606  OD2 ASP B 139      20.765  56.621   8.497  1.00 83.70           O  
ATOM   1607  N   GLN B 140      19.152  61.389   8.910  1.00 73.86           N  
ATOM   1608  CA  GLN B 140      20.031  62.454   8.445  1.00 72.57           C  
ATOM   1609  C   GLN B 140      20.578  63.271   9.616  1.00 69.50           C  
ATOM   1610  O   GLN B 140      19.821  63.920  10.336  1.00 67.44           O  
ATOM   1611  CB  GLN B 140      19.226  63.335   7.485  1.00 74.55           C  
ATOM   1612  CG  GLN B 140      20.012  64.426   6.789  1.00 80.37           C  
ATOM   1613  CD  GLN B 140      21.098  63.880   5.885  1.00 84.77           C  
ATOM   1614  OE1 GLN B 140      20.823  63.313   4.826  1.00 87.11           O  
ATOM   1615  NE2 GLN B 140      22.347  64.046   6.304  1.00 89.17           N  
ATOM   1616  N   SER B 141      21.895  63.254   9.789  1.00 67.03           N  
ATOM   1617  CA  SER B 141      22.523  63.960  10.904  1.00 65.61           C  
ATOM   1618  C   SER B 141      22.297  65.464  10.927  1.00 64.44           C  
ATOM   1619  O   SER B 141      22.259  66.114   9.888  1.00 65.81           O  
ATOM   1620  CB  SER B 141      24.034  63.681  10.925  1.00 66.08           C  
ATOM   1621  OG  SER B 141      24.311  62.289  10.938  1.00 67.70           O  
ATOM   1622  N   VAL B 142      22.130  66.010  12.126  1.00 63.40           N  
ATOM   1623  CA  VAL B 142      21.948  67.445  12.291  1.00 61.80           C  
ATOM   1624  C   VAL B 142      23.067  68.005  13.170  1.00 62.59           C  
ATOM   1625  O   VAL B 142      23.186  67.672  14.350  1.00 61.30           O  
ATOM   1626  CB  VAL B 142      20.580  67.795  12.927  1.00 61.52           C  
ATOM   1627  CG1 VAL B 142      20.535  69.284  13.277  1.00 57.88           C  
ATOM   1628  CG2 VAL B 142      19.457  67.458  11.957  1.00 59.99           C  
ATOM   1629  N   ARG B 143      23.893  68.850  12.566  1.00 62.98           N  
ATOM   1630  CA  ARG B 143      25.014  69.488  13.241  1.00 63.39           C  
ATOM   1631  C   ARG B 143      24.675  69.972  14.646  1.00 63.66           C  
ATOM   1632  O   ARG B 143      23.566  70.445  14.900  1.00 65.77           O  
ATOM   1633  CB  ARG B 143      25.500  70.683  12.418  1.00 64.45           C  
ATOM   1634  CG  ARG B 143      26.161  70.321  11.091  1.00 68.17           C  
ATOM   1635  CD  ARG B 143      26.352  71.552  10.199  1.00 78.00           C  
ATOM   1636  NE  ARG B 143      27.176  72.575  10.834  1.00 79.34           N  
ATOM   1637  CZ  ARG B 143      28.454  72.405  11.155  1.00 78.60           C  
ATOM   1638  NH1 ARG B 143      29.133  73.388  11.736  1.00 76.40           N  
ATOM   1639  NH2 ARG B 143      29.054  71.252  10.885  1.00 74.24           N  
ATOM   1640  N   PRO B 144      25.624  69.839  15.588  1.00 61.98           N  
ATOM   1641  CA  PRO B 144      25.403  70.284  16.966  1.00 60.98           C  
ATOM   1642  C   PRO B 144      25.822  71.744  17.106  1.00 61.62           C  
ATOM   1643  O   PRO B 144      26.628  72.244  16.319  1.00 61.06           O  
ATOM   1644  CB  PRO B 144      26.273  69.331  17.782  1.00 59.93           C  
ATOM   1645  CG  PRO B 144      27.406  69.060  16.876  1.00 57.03           C  
ATOM   1646  CD  PRO B 144      26.770  68.916  15.510  1.00 61.01           C  
ATOM   1647  N   VAL B 145      25.272  72.424  18.106  1.00 62.75           N  
ATOM   1648  CA  VAL B 145      25.574  73.832  18.334  1.00 64.70           C  
ATOM   1649  C   VAL B 145      25.627  74.117  19.829  1.00 66.32           C  
ATOM   1650  O   VAL B 145      25.164  73.314  20.630  1.00 69.58           O  
ATOM   1651  CB  VAL B 145      24.478  74.737  17.699  1.00 63.84           C  
ATOM   1652  CG1 VAL B 145      24.438  74.539  16.194  1.00 61.02           C  
ATOM   1653  CG2 VAL B 145      23.119  74.410  18.301  1.00 62.42           C  
ATOM   1654  N   PHE B 146      26.195  75.256  20.207  1.00 68.96           N  
ATOM   1655  CA  PHE B 146      26.260  75.622  21.618  1.00 72.06           C  
ATOM   1656  C   PHE B 146      25.980  77.109  21.837  1.00 74.25           C  
ATOM   1657  O   PHE B 146      25.911  77.884  20.882  1.00 74.05           O  
ATOM   1658  CB  PHE B 146      27.635  75.269  22.220  1.00 72.45           C  
ATOM   1659  CG  PHE B 146      28.777  76.122  21.714  1.00 73.99           C  
ATOM   1660  CD1 PHE B 146      29.258  75.978  20.419  1.00 72.69           C  
ATOM   1661  CD2 PHE B 146      29.390  77.054  22.551  1.00 75.69           C  
ATOM   1662  CE1 PHE B 146      30.332  76.742  19.965  1.00 74.76           C  
ATOM   1663  CE2 PHE B 146      30.464  77.824  22.104  1.00 73.86           C  
ATOM   1664  CZ  PHE B 146      30.936  77.666  20.810  1.00 72.59           C  
ATOM   1665  N   SER B 147      25.785  77.490  23.099  1.00 77.10           N  
ATOM   1666  CA  SER B 147      25.567  78.890  23.461  1.00 78.98           C  
ATOM   1667  C   SER B 147      25.792  79.122  24.949  1.00 80.11           C  
ATOM   1668  O   SER B 147      25.643  78.211  25.767  1.00 80.42           O  
ATOM   1669  CB  SER B 147      24.162  79.376  23.066  1.00 79.49           C  
ATOM   1670  OG  SER B 147      23.139  78.681  23.754  1.00 82.15           O  
ATOM   1671  N   ILE B 148      26.168  80.351  25.284  1.00 82.00           N  
ATOM   1672  CA  ILE B 148      26.430  80.745  26.664  1.00 83.84           C  
ATOM   1673  C   ILE B 148      25.094  80.772  27.405  1.00 84.68           C  
ATOM   1674  O   ILE B 148      25.022  81.079  28.596  1.00 83.67           O  
ATOM   1675  CB  ILE B 148      27.088  82.147  26.723  1.00 85.27           C  
ATOM   1676  CG1 ILE B 148      27.989  82.354  25.496  1.00 87.26           C  
ATOM   1677  CG2 ILE B 148      27.897  82.292  28.015  1.00 82.59           C  
ATOM   1678  CD1 ILE B 148      27.239  82.473  24.163  1.00 92.93           C  
ATOM   1679  N   GLU B 149      24.035  80.438  26.671  1.00 85.48           N  
ATOM   1680  CA  GLU B 149      22.690  80.395  27.223  1.00 85.02           C  
ATOM   1681  C   GLU B 149      22.537  79.046  27.947  1.00 84.32           C  
ATOM   1682  O   GLU B 149      21.446  78.667  28.382  1.00 83.56           O  
ATOM   1683  CB  GLU B 149      21.663  80.571  26.101  1.00 85.26           C  
ATOM   1684  CG  GLU B 149      22.162  81.449  24.956  1.00 89.48           C  
ATOM   1685  CD  GLU B 149      21.072  81.853  23.985  1.00 94.33           C  
ATOM   1686  OE1 GLU B 149      20.740  81.064  23.074  1.00 94.72           O  
ATOM   1687  OE2 GLU B 149      20.532  82.968  24.148  1.00 94.55           O  
ATOM   1688  N   GLU B 150      23.651  78.313  28.030  1.00 83.99           N  
ATOM   1689  CA  GLU B 150      23.729  77.045  28.766  1.00 83.14           C  
ATOM   1690  C   GLU B 150      25.152  76.933  29.312  1.00 82.40           C  
ATOM   1691  O   GLU B 150      25.615  75.849  29.667  1.00 81.94           O  
ATOM   1692  CB  GLU B 150      23.410  75.811  27.913  1.00 82.30           C  
ATOM   1693  CG  GLU B 150      22.017  75.768  27.327  1.00 82.53           C  
ATOM   1694  CD  GLU B 150      22.001  76.311  25.923  1.00 82.32           C  
ATOM   1695  OE1 GLU B 150      23.023  76.144  25.225  1.00 82.69           O  
ATOM   1696  OE2 GLU B 150      20.982  76.886  25.508  1.00 81.99           O  
ATOM   1697  N   LYS B 151      25.834  78.074  29.380  1.00 81.08           N  
ATOM   1698  CA  LYS B 151      27.200  78.148  29.882  1.00 80.28           C  
ATOM   1699  C   LYS B 151      27.443  77.218  31.070  1.00 79.70           C  
ATOM   1700  O   LYS B 151      26.541  76.967  31.871  1.00 79.33           O  
ATOM   1701  CB  LYS B 151      27.526  79.585  30.293  1.00 80.97           C  
ATOM   1702  N   GLY B 152      28.674  76.715  31.159  1.00 78.74           N  
ATOM   1703  CA  GLY B 152      29.079  75.835  32.244  1.00 75.80           C  
ATOM   1704  C   GLY B 152      28.494  74.442  32.248  1.00 73.76           C  
ATOM   1705  O   GLY B 152      28.922  73.586  33.026  1.00 74.02           O  
ATOM   1706  N   ARG B 153      27.535  74.208  31.360  1.00 71.24           N  
ATOM   1707  CA  ARG B 153      26.857  72.923  31.292  1.00 68.20           C  
ATOM   1708  C   ARG B 153      26.907  72.261  29.904  1.00 64.88           C  
ATOM   1709  O   ARG B 153      26.418  71.146  29.729  1.00 62.70           O  
ATOM   1710  CB  ARG B 153      25.405  73.136  31.745  1.00 69.48           C  
ATOM   1711  CG  ARG B 153      24.738  71.908  32.340  1.00 70.28           C  
ATOM   1712  CD  ARG B 153      23.497  72.254  33.179  1.00 79.18           C  
ATOM   1713  NE  ARG B 153      22.270  72.350  32.389  1.00 78.29           N  
ATOM   1714  CZ  ARG B 153      21.800  73.472  31.852  1.00 77.77           C  
ATOM   1715  NH1 ARG B 153      22.449  74.616  32.019  1.00 76.19           N  
ATOM   1716  NH2 ARG B 153      20.680  73.447  31.138  1.00 76.68           N  
ATOM   1717  N   ILE B 154      27.497  72.949  28.929  1.00 61.65           N  
ATOM   1718  CA  ILE B 154      27.621  72.425  27.568  1.00 58.43           C  
ATOM   1719  C   ILE B 154      28.521  71.195  27.571  1.00 54.62           C  
ATOM   1720  O   ILE B 154      29.613  71.224  28.133  1.00 55.09           O  
ATOM   1721  CB  ILE B 154      28.247  73.471  26.624  1.00 59.94           C  
ATOM   1722  CG1 ILE B 154      27.334  74.697  26.525  1.00 59.40           C  
ATOM   1723  CG2 ILE B 154      28.507  72.848  25.255  1.00 59.33           C  
ATOM   1724  CD1 ILE B 154      27.923  75.838  25.716  1.00 59.00           C  
ATOM   1725  N   LEU B 155      28.072  70.123  26.930  1.00 51.77           N  
ATOM   1726  CA  LEU B 155      28.858  68.894  26.900  1.00 49.75           C  
ATOM   1727  C   LEU B 155      29.957  68.928  25.843  1.00 46.89           C  
ATOM   1728  O   LEU B 155      29.697  69.083  24.652  1.00 45.96           O  
ATOM   1729  CB  LEU B 155      27.945  67.682  26.673  1.00 48.47           C  
ATOM   1730  CG  LEU B 155      28.402  66.389  27.362  1.00 50.76           C  
ATOM   1731  CD1 LEU B 155      27.283  65.358  27.334  1.00 52.32           C  
ATOM   1732  CD2 LEU B 155      29.646  65.854  26.683  1.00 51.54           C  
HETATM 1733  N   MSE B 156      31.193  68.781  26.299  1.00 43.61           N  
HETATM 1734  CA  MSE B 156      32.336  68.793  25.404  1.00 43.07           C  
HETATM 1735  C   MSE B 156      33.187  67.539  25.549  1.00 38.47           C  
HETATM 1736  O   MSE B 156      33.269  66.717  24.634  1.00 36.36           O  
HETATM 1737  CB  MSE B 156      33.196  70.032  25.666  1.00 41.64           C  
HETATM 1738  CG  MSE B 156      32.638  71.310  25.053  1.00 55.77           C  
HETATM 1739 SE   MSE B 156      32.264  71.085  23.151  1.00 82.91          SE  
HETATM 1740  CE  MSE B 156      34.016  70.488  22.624  1.00 80.13           C  
ATOM   1741  N   GLY B 157      33.816  67.403  26.708  1.00 38.86           N  
ATOM   1742  CA  GLY B 157      34.660  66.259  26.970  1.00 38.73           C  
ATOM   1743  C   GLY B 157      35.237  66.368  28.364  1.00 38.84           C  
ATOM   1744  O   GLY B 157      35.318  67.461  28.922  1.00 40.24           O  
ATOM   1745  N   GLY B 158      35.633  65.235  28.930  1.00 41.28           N  
ATOM   1746  CA  GLY B 158      36.200  65.234  30.262  1.00 40.85           C  
ATOM   1747  C   GLY B 158      36.516  63.827  30.718  1.00 39.20           C  
ATOM   1748  O   GLY B 158      36.518  62.892  29.919  1.00 38.85           O  
ATOM   1749  N   THR B 159      36.794  63.686  32.006  1.00 43.25           N  
ATOM   1750  CA  THR B 159      37.103  62.394  32.598  1.00 42.38           C  
ATOM   1751  C   THR B 159      35.922  61.995  33.471  1.00 39.90           C  
ATOM   1752  O   THR B 159      35.356  62.828  34.173  1.00 35.23           O  
ATOM   1753  CB  THR B 159      38.340  62.475  33.506  1.00 44.37           C  
ATOM   1754  OG1 THR B 159      38.218  63.632  34.344  1.00 55.68           O  
ATOM   1755  CG2 THR B 159      39.628  62.574  32.686  1.00 41.09           C  
ATOM   1756  N   LEU B 160      35.543  60.723  33.399  1.00 37.04           N  
ATOM   1757  CA  LEU B 160      34.457  60.184  34.204  1.00 36.97           C  
ATOM   1758  C   LEU B 160      35.017  58.908  34.814  1.00 39.42           C  
ATOM   1759  O   LEU B 160      35.045  57.858  34.164  1.00 40.40           O  
ATOM   1760  CB  LEU B 160      33.242  59.860  33.337  1.00 37.99           C  
ATOM   1761  CG  LEU B 160      31.931  59.527  34.066  1.00 39.72           C  
ATOM   1762  CD1 LEU B 160      31.389  60.768  34.775  1.00 33.49           C  
ATOM   1763  CD2 LEU B 160      30.913  59.014  33.062  1.00 34.40           C  
ATOM   1764  N   VAL B 161      35.492  59.012  36.055  1.00 40.32           N  
ATOM   1765  CA  VAL B 161      36.065  57.869  36.764  1.00 43.06           C  
ATOM   1766  C   VAL B 161      34.964  56.895  37.172  1.00 41.23           C  
ATOM   1767  O   VAL B 161      33.794  57.278  37.294  1.00 39.66           O  
ATOM   1768  CB  VAL B 161      36.837  58.326  38.032  1.00 45.35           C  
ATOM   1769  CG1 VAL B 161      35.878  58.944  39.044  1.00 44.56           C  
ATOM   1770  CG2 VAL B 161      37.568  57.144  38.647  1.00 51.32           C  
ATOM   1771  N   SER B 162      35.338  55.637  37.384  1.00 42.39           N  
ATOM   1772  CA  SER B 162      34.386  54.594  37.771  1.00 45.06           C  
ATOM   1773  C   SER B 162      33.397  55.005  38.858  1.00 42.77           C  
ATOM   1774  O   SER B 162      33.780  55.512  39.915  1.00 42.92           O  
ATOM   1775  CB  SER B 162      35.122  53.340  38.233  1.00 45.62           C  
ATOM   1776  OG  SER B 162      34.198  52.312  38.540  1.00 49.95           O  
ATOM   1777  N   GLY B 163      32.117  54.777  38.572  1.00 44.23           N  
ATOM   1778  CA  GLY B 163      31.051  55.104  39.500  1.00 42.62           C  
ATOM   1779  C   GLY B 163      30.554  56.532  39.408  1.00 43.24           C  
ATOM   1780  O   GLY B 163      29.575  56.888  40.060  1.00 45.20           O  
ATOM   1781  N   LYS B 164      31.204  57.352  38.595  1.00 43.21           N  
ATOM   1782  CA  LYS B 164      30.799  58.747  38.475  1.00 44.75           C  
ATOM   1783  C   LYS B 164      29.765  59.118  37.407  1.00 44.95           C  
ATOM   1784  O   LYS B 164      29.598  58.427  36.398  1.00 43.74           O  
ATOM   1785  CB  LYS B 164      32.040  59.626  38.294  1.00 43.84           C  
ATOM   1786  CG  LYS B 164      32.675  60.071  39.605  1.00 50.84           C  
ATOM   1787  CD  LYS B 164      31.712  60.945  40.402  1.00 63.69           C  
ATOM   1788  CE  LYS B 164      31.378  62.242  39.672  1.00 66.41           C  
ATOM   1789  NZ  LYS B 164      32.538  63.179  39.610  1.00 62.76           N  
ATOM   1790  N   LYS B 165      29.069  60.225  37.661  1.00 45.14           N  
ATOM   1791  CA  LYS B 165      28.062  60.745  36.752  1.00 44.25           C  
ATOM   1792  C   LYS B 165      28.475  62.115  36.258  1.00 43.54           C  
ATOM   1793  O   LYS B 165      29.144  62.867  36.959  1.00 44.05           O  
ATOM   1794  CB  LYS B 165      26.697  60.864  37.444  1.00 45.29           C  
ATOM   1795  CG  LYS B 165      25.979  59.537  37.649  1.00 46.00           C  
ATOM   1796  CD  LYS B 165      24.598  59.724  38.266  1.00 49.41           C  
ATOM   1797  CE  LYS B 165      24.002  58.387  38.695  1.00 49.42           C  
ATOM   1798  NZ  LYS B 165      22.570  58.513  39.083  1.00 52.75           N  
ATOM   1799  N   VAL B 166      28.094  62.418  35.027  1.00 44.98           N  
ATOM   1800  CA  VAL B 166      28.368  63.715  34.432  1.00 45.43           C  
ATOM   1801  C   VAL B 166      27.075  64.088  33.710  1.00 43.56           C  
ATOM   1802  O   VAL B 166      26.474  63.262  33.033  1.00 43.46           O  
ATOM   1803  CB  VAL B 166      29.588  63.675  33.447  1.00 46.93           C  
ATOM   1804  CG1 VAL B 166      29.315  62.733  32.267  1.00 50.11           C  
ATOM   1805  CG2 VAL B 166      29.904  65.085  32.952  1.00 48.86           C  
ATOM   1806  N   THR B 167      26.618  65.318  33.914  1.00 46.19           N  
ATOM   1807  CA  THR B 167      25.398  65.800  33.275  1.00 43.82           C  
ATOM   1808  C   THR B 167      25.821  67.004  32.453  1.00 42.44           C  
ATOM   1809  O   THR B 167      26.702  67.755  32.862  1.00 43.16           O  
ATOM   1810  CB  THR B 167      24.331  66.205  34.320  1.00 44.53           C  
ATOM   1811  OG1 THR B 167      24.055  65.089  35.171  1.00 48.59           O  
ATOM   1812  CG2 THR B 167      23.038  66.613  33.640  1.00 41.69           C  
ATOM   1813  N   GLY B 168      25.215  67.169  31.285  1.00 41.79           N  
ATOM   1814  CA  GLY B 168      25.579  68.277  30.425  1.00 41.15           C  
ATOM   1815  C   GLY B 168      24.543  68.423  29.340  1.00 37.75           C  
ATOM   1816  O   GLY B 168      23.548  67.702  29.357  1.00 39.71           O  
ATOM   1817  N   VAL B 169      24.765  69.323  28.387  1.00 39.88           N  
ATOM   1818  CA  VAL B 169      23.774  69.516  27.334  1.00 43.34           C  
ATOM   1819  C   VAL B 169      24.274  69.540  25.894  1.00 43.87           C  
ATOM   1820  O   VAL B 169      25.395  69.965  25.606  1.00 40.79           O  
ATOM   1821  CB  VAL B 169      22.959  70.854  27.548  1.00 42.90           C  
ATOM   1822  CG1 VAL B 169      22.811  71.161  29.031  1.00 46.32           C  
ATOM   1823  CG2 VAL B 169      23.633  72.025  26.831  1.00 47.21           C  
ATOM   1824  N   LEU B 170      23.423  69.054  24.994  1.00 45.03           N  
ATOM   1825  CA  LEU B 170      23.710  69.087  23.564  1.00 46.44           C  
ATOM   1826  C   LEU B 170      22.624  70.034  23.037  1.00 48.71           C  
ATOM   1827  O   LEU B 170      21.555  70.164  23.643  1.00 47.89           O  
ATOM   1828  CB  LEU B 170      23.554  67.715  22.879  1.00 46.81           C  
ATOM   1829  CG  LEU B 170      24.428  66.486  23.172  1.00 47.30           C  
ATOM   1830  CD1 LEU B 170      25.902  66.877  23.281  1.00 38.76           C  
ATOM   1831  CD2 LEU B 170      23.954  65.845  24.444  1.00 45.59           C  
ATOM   1832  N   SER B 171      22.893  70.707  21.926  1.00 50.82           N  
ATOM   1833  CA  SER B 171      21.911  71.615  21.357  1.00 54.71           C  
ATOM   1834  C   SER B 171      21.969  71.538  19.844  1.00 55.44           C  
ATOM   1835  O   SER B 171      23.047  71.414  19.264  1.00 56.55           O  
ATOM   1836  CB  SER B 171      22.169  73.054  21.830  1.00 55.81           C  
ATOM   1837  N   TYR B 172      20.800  71.596  19.215  1.00 58.39           N  
ATOM   1838  CA  TYR B 172      20.703  71.532  17.766  1.00 61.51           C  
ATOM   1839  C   TYR B 172      19.640  72.499  17.245  1.00 64.60           C  
ATOM   1840  O   TYR B 172      18.600  72.698  17.883  1.00 64.72           O  
ATOM   1841  CB  TYR B 172      20.336  70.114  17.314  1.00 62.12           C  
ATOM   1842  CG  TYR B 172      21.168  69.013  17.925  1.00 59.20           C  
ATOM   1843  CD1 TYR B 172      20.957  68.603  19.239  1.00 57.79           C  
ATOM   1844  CD2 TYR B 172      22.166  68.383  17.188  1.00 54.40           C  
ATOM   1845  CE1 TYR B 172      21.721  67.587  19.806  1.00 56.34           C  
ATOM   1846  CE2 TYR B 172      22.935  67.368  17.742  1.00 54.29           C  
ATOM   1847  CZ  TYR B 172      22.711  66.975  19.051  1.00 52.44           C  
ATOM   1848  OH  TYR B 172      23.491  65.994  19.619  1.00 45.76           O  
ATOM   1849  N   VAL B 173      19.907  73.088  16.080  1.00 67.55           N  
ATOM   1850  CA  VAL B 173      18.986  74.031  15.448  1.00 70.29           C  
ATOM   1851  C   VAL B 173      17.966  73.250  14.622  1.00 71.07           C  
ATOM   1852  O   VAL B 173      18.300  72.627  13.612  1.00 69.13           O  
ATOM   1853  CB  VAL B 173      19.762  75.005  14.573  1.00 71.02           C  
ATOM   1854  N   ILE B 174      16.713  73.309  15.060  1.00 73.28           N  
ATOM   1855  CA  ILE B 174      15.637  72.571  14.420  1.00 75.17           C  
ATOM   1856  C   ILE B 174      14.415  73.407  14.064  1.00 76.48           C  
ATOM   1857  O   ILE B 174      14.098  74.387  14.747  1.00 75.92           O  
ATOM   1858  CB  ILE B 174      15.213  71.424  15.341  1.00 74.18           C  
ATOM   1859  N   PRO B 175      13.718  73.032  12.974  1.00 77.43           N  
ATOM   1860  CA  PRO B 175      12.514  73.726  12.511  1.00 78.51           C  
ATOM   1861  C   PRO B 175      11.501  73.805  13.651  1.00 79.62           C  
ATOM   1862  O   PRO B 175      10.968  72.781  14.083  1.00 80.38           O  
ATOM   1863  CB  PRO B 175      12.018  72.833  11.382  1.00 77.79           C  
ATOM   1864  CG  PRO B 175      13.278  72.362  10.762  1.00 77.67           C  
ATOM   1865  CD  PRO B 175      14.214  72.107  11.938  1.00 77.64           C  
ATOM   1866  N   GLN B 179       8.301  71.287  15.397  1.00 79.63           N  
ATOM   1867  CA  GLN B 179       8.353  70.238  16.406  1.00 78.64           C  
ATOM   1868  C   GLN B 179       9.477  69.268  16.091  1.00 79.26           C  
ATOM   1869  O   GLN B 179      10.215  69.445  15.118  1.00 80.39           O  
ATOM   1870  CB  GLN B 179       7.020  69.494  16.474  1.00 78.06           C  
ATOM   1871  N   LYS B 180       9.577  68.226  16.905  1.00 77.80           N  
ATOM   1872  CA  LYS B 180      10.625  67.239  16.743  1.00 76.04           C  
ATOM   1873  C   LYS B 180      10.255  65.795  16.414  1.00 75.14           C  
ATOM   1874  O   LYS B 180       9.698  65.092  17.254  1.00 73.41           O  
ATOM   1875  CB  LYS B 180      11.487  67.230  18.014  1.00 75.06           C  
ATOM   1876  CG  LYS B 180      10.673  67.340  19.299  1.00 70.50           C  
ATOM   1877  CD  LYS B 180      11.022  68.599  20.075  1.00 61.76           C  
ATOM   1878  CE  LYS B 180      11.873  68.271  21.279  1.00 55.63           C  
ATOM   1879  NZ  LYS B 180      11.193  67.277  22.155  1.00 55.14           N  
ATOM   1880  N   HIS B 181      10.546  65.362  15.191  1.00 74.23           N  
ATOM   1881  CA  HIS B 181      10.347  63.959  14.808  1.00 73.58           C  
ATOM   1882  C   HIS B 181      11.823  63.569  14.744  1.00 71.52           C  
ATOM   1883  O   HIS B 181      12.275  62.932  13.793  1.00 70.89           O  
ATOM   1884  CB  HIS B 181       9.748  63.801  13.409  1.00 74.56           C  
ATOM   1885  CG  HIS B 181       8.509  64.604  13.183  1.00 78.60           C  
ATOM   1886  ND1 HIS B 181       8.028  64.882  11.922  1.00 76.54           N  
ATOM   1887  CD2 HIS B 181       7.660  65.204  14.050  1.00 79.02           C  
ATOM   1888  CE1 HIS B 181       6.940  65.624  12.021  1.00 77.59           C  
ATOM   1889  NE2 HIS B 181       6.695  65.834  13.303  1.00 82.26           N  
ATOM   1890  N   TYR B 182      12.565  63.991  15.763  1.00 68.09           N  
ATOM   1891  CA  TYR B 182      14.002  63.753  15.842  1.00 67.03           C  
ATOM   1892  C   TYR B 182      14.440  62.663  16.814  1.00 63.01           C  
ATOM   1893  O   TYR B 182      13.789  62.409  17.834  1.00 62.66           O  
ATOM   1894  CB  TYR B 182      14.706  65.070  16.197  1.00 67.14           C  
ATOM   1895  CG  TYR B 182      14.664  66.089  15.079  1.00 71.16           C  
ATOM   1896  CD1 TYR B 182      15.420  65.903  13.919  1.00 77.08           C  
ATOM   1897  CD2 TYR B 182      13.848  67.223  15.160  1.00 72.32           C  
ATOM   1898  CE1 TYR B 182      15.363  66.815  12.862  1.00 77.65           C  
ATOM   1899  CE2 TYR B 182      13.782  68.142  14.104  1.00 72.37           C  
ATOM   1900  CZ  TYR B 182      14.544  67.931  12.962  1.00 75.25           C  
ATOM   1901  OH  TYR B 182      14.485  68.828  11.920  1.00 77.27           O  
ATOM   1902  N   THR B 183      15.562  62.029  16.499  1.00 60.13           N  
ATOM   1903  CA  THR B 183      16.084  60.962  17.342  1.00 54.75           C  
ATOM   1904  C   THR B 183      17.491  61.267  17.839  1.00 51.17           C  
ATOM   1905  O   THR B 183      18.382  61.575  17.047  1.00 47.97           O  
ATOM   1906  CB  THR B 183      16.098  59.623  16.562  1.00 53.86           C  
ATOM   1907  OG1 THR B 183      14.751  59.262  16.234  1.00 53.21           O  
ATOM   1908  CG2 THR B 183      16.735  58.508  17.390  1.00 53.19           C  
ATOM   1909  N   LEU B 184      17.688  61.217  19.153  1.00 47.87           N  
ATOM   1910  CA  LEU B 184      19.028  61.439  19.686  1.00 43.93           C  
ATOM   1911  C   LEU B 184      19.701  60.062  19.645  1.00 40.35           C  
ATOM   1912  O   LEU B 184      19.076  59.039  19.947  1.00 35.72           O  
ATOM   1913  CB  LEU B 184      19.015  61.977  21.124  1.00 42.86           C  
ATOM   1914  CG  LEU B 184      20.462  62.170  21.619  1.00 40.56           C  
ATOM   1915  CD1 LEU B 184      21.045  63.457  21.047  1.00 38.55           C  
ATOM   1916  CD2 LEU B 184      20.513  62.201  23.130  1.00 32.90           C  
ATOM   1917  N   VAL B 185      20.968  60.055  19.240  1.00 37.16           N  
ATOM   1918  CA  VAL B 185      21.758  58.835  19.122  1.00 35.24           C  
ATOM   1919  C   VAL B 185      23.006  58.909  19.999  1.00 34.67           C  
ATOM   1920  O   VAL B 185      23.726  59.913  20.002  1.00 32.33           O  
ATOM   1921  CB  VAL B 185      22.220  58.611  17.667  1.00 38.71           C  
ATOM   1922  CG1 VAL B 185      22.817  57.211  17.519  1.00 38.36           C  
ATOM   1923  CG2 VAL B 185      21.044  58.809  16.699  1.00 35.63           C  
ATOM   1924  N   TYR B 186      23.259  57.834  20.734  1.00 35.26           N  
ATOM   1925  CA  TYR B 186      24.405  57.748  21.617  1.00 33.00           C  
ATOM   1926  C   TYR B 186      25.200  56.491  21.282  1.00 32.03           C  
ATOM   1927  O   TYR B 186      24.635  55.403  21.207  1.00 33.85           O  
ATOM   1928  CB  TYR B 186      23.921  57.694  23.078  1.00 34.08           C  
ATOM   1929  CG  TYR B 186      24.973  57.336  24.111  1.00 29.49           C  
ATOM   1930  CD1 TYR B 186      26.133  58.107  24.260  1.00 20.71           C  
ATOM   1931  CD2 TYR B 186      24.798  56.245  24.959  1.00 29.70           C  
ATOM   1932  CE1 TYR B 186      27.089  57.807  25.238  1.00 20.30           C  
ATOM   1933  CE2 TYR B 186      25.746  55.935  25.948  1.00 28.49           C  
ATOM   1934  CZ  TYR B 186      26.888  56.723  26.079  1.00 24.78           C  
ATOM   1935  OH  TYR B 186      27.801  56.450  27.080  1.00 27.96           O  
ATOM   1936  N   ASN B 187      26.498  56.635  21.042  1.00 27.73           N  
ATOM   1937  CA  ASN B 187      27.344  55.472  20.781  1.00 28.89           C  
ATOM   1938  C   ASN B 187      28.381  55.500  21.908  1.00 26.97           C  
ATOM   1939  O   ASN B 187      29.282  56.344  21.929  1.00 30.28           O  
ATOM   1940  CB  ASN B 187      28.016  55.552  19.403  1.00 24.01           C  
ATOM   1941  CG  ASN B 187      28.632  54.209  18.975  1.00 29.81           C  
ATOM   1942  OD1 ASN B 187      29.508  53.654  19.661  1.00 30.83           O  
ATOM   1943  ND2 ASN B 187      28.165  53.677  17.844  1.00 39.93           N  
ATOM   1944  N   PRO B 188      28.259  54.582  22.873  1.00 28.00           N  
ATOM   1945  CA  PRO B 188      29.211  54.552  23.996  1.00 25.72           C  
ATOM   1946  C   PRO B 188      30.659  54.312  23.590  1.00 25.85           C  
ATOM   1947  O   PRO B 188      31.578  54.787  24.255  1.00 30.95           O  
ATOM   1948  CB  PRO B 188      28.634  53.481  24.929  1.00 26.40           C  
ATOM   1949  CG  PRO B 188      27.893  52.552  23.998  1.00 27.48           C  
ATOM   1950  CD  PRO B 188      27.312  53.454  22.916  1.00 25.08           C  
ATOM   1951  N   PHE B 189      30.868  53.592  22.498  1.00 26.25           N  
ATOM   1952  CA  PHE B 189      32.224  53.351  22.020  1.00 27.09           C  
ATOM   1953  C   PHE B 189      32.804  54.689  21.534  1.00 27.67           C  
ATOM   1954  O   PHE B 189      33.914  55.047  21.885  1.00 29.37           O  
ATOM   1955  CB  PHE B 189      32.219  52.331  20.871  1.00 26.26           C  
ATOM   1956  CG  PHE B 189      33.587  52.031  20.321  1.00 29.62           C  
ATOM   1957  CD1 PHE B 189      34.512  51.298  21.069  1.00 26.02           C  
ATOM   1958  CD2 PHE B 189      33.968  52.506  19.066  1.00 32.13           C  
ATOM   1959  CE1 PHE B 189      35.794  51.042  20.582  1.00 25.33           C  
ATOM   1960  CE2 PHE B 189      35.258  52.255  18.566  1.00 26.53           C  
ATOM   1961  CZ  PHE B 189      36.174  51.523  19.324  1.00 22.22           C  
ATOM   1962  N   LEU B 190      32.040  55.427  20.737  1.00 31.21           N  
ATOM   1963  CA  LEU B 190      32.488  56.723  20.228  1.00 32.42           C  
ATOM   1964  C   LEU B 190      32.522  57.794  21.323  1.00 30.81           C  
ATOM   1965  O   LEU B 190      33.339  58.713  21.279  1.00 32.81           O  
ATOM   1966  CB  LEU B 190      31.552  57.191  19.106  1.00 31.84           C  
ATOM   1967  CG  LEU B 190      31.971  56.971  17.651  1.00 39.08           C  
ATOM   1968  CD1 LEU B 190      32.839  58.151  17.180  1.00 44.27           C  
ATOM   1969  CD2 LEU B 190      32.709  55.650  17.526  1.00 41.13           C  
ATOM   1970  N   ALA B 191      31.624  57.678  22.294  1.00 29.35           N  
ATOM   1971  CA  ALA B 191      31.559  58.641  23.380  1.00 27.22           C  
ATOM   1972  C   ALA B 191      32.785  58.583  24.273  1.00 24.67           C  
ATOM   1973  O   ALA B 191      33.138  59.576  24.909  1.00 27.12           O  
ATOM   1974  CB  ALA B 191      30.322  58.395  24.224  1.00 22.54           C  
ATOM   1975  N   ASP B 192      33.425  57.420  24.320  1.00 27.73           N  
ATOM   1976  CA  ASP B 192      34.605  57.223  25.160  1.00 28.15           C  
ATOM   1977  C   ASP B 192      35.858  57.296  24.312  1.00 30.81           C  
ATOM   1978  O   ASP B 192      36.093  56.449  23.453  1.00 32.08           O  
ATOM   1979  CB  ASP B 192      34.518  55.867  25.870  1.00 31.65           C  
ATOM   1980  CG  ASP B 192      35.700  55.599  26.782  1.00 32.32           C  
ATOM   1981  OD1 ASP B 192      36.527  56.519  27.014  1.00 22.07           O  
ATOM   1982  OD2 ASP B 192      35.789  54.455  27.280  1.00 38.86           O  
ATOM   1983  N   THR B 193      36.673  58.302  24.586  1.00 30.83           N  
ATOM   1984  CA  THR B 193      37.879  58.521  23.812  1.00 33.87           C  
ATOM   1985  C   THR B 193      39.177  57.917  24.383  1.00 34.01           C  
ATOM   1986  O   THR B 193      40.258  58.152  23.851  1.00 37.00           O  
ATOM   1987  CB  THR B 193      38.021  60.040  23.551  1.00 28.38           C  
ATOM   1988  OG1 THR B 193      38.763  60.255  22.352  1.00 46.82           O  
ATOM   1989  CG2 THR B 193      38.700  60.711  24.669  1.00 25.95           C  
ATOM   1990  N   ASN B 194      39.056  57.129  25.451  1.00 32.75           N  
ATOM   1991  CA  ASN B 194      40.193  56.464  26.096  1.00 35.23           C  
ATOM   1992  C   ASN B 194      40.910  55.518  25.118  1.00 37.46           C  
ATOM   1993  O   ASN B 194      40.350  54.498  24.689  1.00 36.73           O  
ATOM   1994  CB  ASN B 194      39.695  55.658  27.293  1.00 38.07           C  
ATOM   1995  CG  ASN B 194      40.809  55.293  28.261  1.00 42.87           C  
ATOM   1996  OD1 ASN B 194      41.966  55.118  27.872  1.00 41.33           O  
ATOM   1997  ND2 ASN B 194      40.453  55.158  29.531  1.00 38.53           N  
ATOM   1998  N   SER B 195      42.157  55.852  24.795  1.00 39.05           N  
ATOM   1999  CA  SER B 195      42.969  55.087  23.853  1.00 41.39           C  
ATOM   2000  C   SER B 195      43.699  53.856  24.400  1.00 43.61           C  
ATOM   2001  O   SER B 195      44.243  53.057  23.637  1.00 42.08           O  
ATOM   2002  CB  SER B 195      43.990  56.022  23.200  1.00 44.45           C  
ATOM   2003  OG  SER B 195      44.777  56.694  24.173  1.00 50.58           O  
ATOM   2004  N   SER B 196      43.710  53.686  25.711  1.00 44.17           N  
ATOM   2005  CA  SER B 196      44.407  52.542  26.278  1.00 44.45           C  
ATOM   2006  C   SER B 196      43.610  51.241  26.283  1.00 43.87           C  
ATOM   2007  O   SER B 196      44.182  50.169  26.496  1.00 44.87           O  
ATOM   2008  CB  SER B 196      44.872  52.871  27.705  1.00 44.27           C  
ATOM   2009  OG  SER B 196      43.796  53.269  28.536  1.00 50.28           O  
ATOM   2010  N   ASN B 197      42.308  51.326  26.022  1.00 43.76           N  
ATOM   2011  CA  ASN B 197      41.452  50.140  26.050  1.00 43.19           C  
ATOM   2012  C   ASN B 197      40.415  50.070  24.951  1.00 45.38           C  
ATOM   2013  O   ASN B 197      39.305  49.606  25.188  1.00 44.89           O  
ATOM   2014  CB  ASN B 197      40.721  50.069  27.392  1.00 42.16           C  
ATOM   2015  CG  ASN B 197      39.890  51.326  27.689  1.00 42.25           C  
ATOM   2016  OD1 ASN B 197      39.548  52.104  26.788  1.00 34.87           O  
ATOM   2017  ND2 ASN B 197      39.551  51.513  28.960  1.00 39.91           N  
ATOM   2018  N   THR B 198      40.780  50.512  23.755  1.00 46.75           N  
ATOM   2019  CA  THR B 198      39.870  50.513  22.619  1.00 49.09           C  
ATOM   2020  C   THR B 198      39.426  49.121  22.149  1.00 50.86           C  
ATOM   2021  O   THR B 198      38.228  48.864  22.000  1.00 52.30           O  
ATOM   2022  CB  THR B 198      40.508  51.249  21.420  1.00 49.49           C  
ATOM   2023  OG1 THR B 198      40.895  52.569  21.820  1.00 53.62           O  
ATOM   2024  CG2 THR B 198      39.530  51.353  20.280  1.00 50.51           C  
ATOM   2025  N   GLU B 199      40.382  48.223  21.921  1.00 50.54           N  
ATOM   2026  CA  GLU B 199      40.054  46.882  21.438  1.00 52.16           C  
ATOM   2027  C   GLU B 199      39.252  46.061  22.439  1.00 51.25           C  
ATOM   2028  O   GLU B 199      38.619  45.069  22.077  1.00 51.92           O  
ATOM   2029  CB  GLU B 199      41.323  46.125  21.041  1.00 51.67           C  
ATOM   2030  CG  GLU B 199      42.093  46.733  19.861  1.00 57.64           C  
ATOM   2031  CD  GLU B 199      41.242  46.917  18.615  1.00 62.33           C  
ATOM   2032  OE1 GLU B 199      40.455  46.001  18.282  1.00 64.27           O  
ATOM   2033  OE2 GLU B 199      41.370  47.977  17.957  1.00 65.05           O  
ATOM   2034  N   GLU B 200      39.277  46.476  23.697  1.00 50.26           N  
ATOM   2035  CA  GLU B 200      38.528  45.774  24.730  1.00 47.98           C  
ATOM   2036  C   GLU B 200      37.114  46.346  24.767  1.00 47.01           C  
ATOM   2037  O   GLU B 200      36.192  45.703  25.267  1.00 47.01           O  
ATOM   2038  CB  GLU B 200      39.201  45.979  26.086  1.00 49.09           C  
ATOM   2039  CG  GLU B 200      40.683  45.661  26.091  1.00 51.38           C  
ATOM   2040  CD  GLU B 200      41.461  46.554  27.041  1.00 57.49           C  
ATOM   2041  OE1 GLU B 200      40.950  46.832  28.151  1.00 58.93           O  
ATOM   2042  OE2 GLU B 200      42.587  46.966  26.680  1.00 59.87           O  
ATOM   2043  N   ARG B 201      36.942  47.546  24.221  1.00 43.36           N  
ATOM   2044  CA  ARG B 201      35.638  48.203  24.226  1.00 40.57           C  
ATOM   2045  C   ARG B 201      34.905  48.183  22.887  1.00 36.59           C  
ATOM   2046  O   ARG B 201      33.814  48.733  22.782  1.00 38.41           O  
ATOM   2047  CB  ARG B 201      35.813  49.666  24.656  1.00 39.08           C  
ATOM   2048  CG  ARG B 201      36.347  49.875  26.077  1.00 39.37           C  
ATOM   2049  CD  ARG B 201      36.788  51.328  26.304  1.00 33.24           C  
ATOM   2050  NE  ARG B 201      36.090  52.229  25.401  1.00 44.33           N  
ATOM   2051  CZ  ARG B 201      36.694  53.039  24.541  1.00 38.29           C  
ATOM   2052  NH1 ARG B 201      38.016  53.072  24.473  1.00 38.45           N  
ATOM   2053  NH2 ARG B 201      35.972  53.787  23.717  1.00 42.79           N  
ATOM   2054  N   VAL B 202      35.478  47.544  21.874  1.00 37.37           N  
ATOM   2055  CA  VAL B 202      34.861  47.556  20.547  1.00 38.15           C  
ATOM   2056  C   VAL B 202      33.477  46.918  20.433  1.00 40.45           C  
ATOM   2057  O   VAL B 202      32.721  47.235  19.514  1.00 38.83           O  
ATOM   2058  CB  VAL B 202      35.831  46.965  19.463  1.00 39.40           C  
ATOM   2059  CG1 VAL B 202      35.998  45.479  19.636  1.00 35.31           C  
ATOM   2060  CG2 VAL B 202      35.307  47.274  18.079  1.00 42.28           C  
ATOM   2061  N   LYS B 203      33.133  46.044  21.372  1.00 38.41           N  
ATOM   2062  CA  LYS B 203      31.825  45.400  21.364  1.00 41.26           C  
ATOM   2063  C   LYS B 203      30.752  46.435  21.703  1.00 40.20           C  
ATOM   2064  O   LYS B 203      29.558  46.186  21.527  1.00 40.73           O  
ATOM   2065  CB  LYS B 203      31.750  44.303  22.429  1.00 41.75           C  
ATOM   2066  CG  LYS B 203      33.046  43.574  22.733  1.00 52.58           C  
ATOM   2067  CD  LYS B 203      32.852  42.630  23.922  1.00 57.10           C  
ATOM   2068  CE  LYS B 203      33.982  41.614  24.032  1.00 57.46           C  
ATOM   2069  NZ  LYS B 203      35.301  42.237  24.294  1.00 63.00           N  
ATOM   2070  N   ASP B 204      31.183  47.583  22.221  1.00 35.94           N  
ATOM   2071  CA  ASP B 204      30.264  48.643  22.615  1.00 33.63           C  
ATOM   2072  C   ASP B 204      29.897  49.546  21.457  1.00 32.72           C  
ATOM   2073  O   ASP B 204      29.086  50.453  21.609  1.00 32.01           O  
ATOM   2074  CB  ASP B 204      30.879  49.485  23.745  1.00 35.36           C  
ATOM   2075  CG  ASP B 204      31.242  48.651  24.976  1.00 41.81           C  
ATOM   2076  OD1 ASP B 204      30.837  47.468  25.035  1.00 51.28           O  
ATOM   2077  OD2 ASP B 204      31.923  49.182  25.892  1.00 32.44           O  
ATOM   2078  N   ASP B 205      30.494  49.295  20.297  1.00 34.10           N  
ATOM   2079  CA  ASP B 205      30.247  50.110  19.109  1.00 32.38           C  
ATOM   2080  C   ASP B 205      28.829  49.861  18.618  1.00 33.63           C  
ATOM   2081  O   ASP B 205      28.601  49.070  17.710  1.00 34.36           O  
ATOM   2082  CB  ASP B 205      31.261  49.752  18.022  1.00 34.23           C  
ATOM   2083  CG  ASP B 205      31.345  50.794  16.930  1.00 34.88           C  
ATOM   2084  OD1 ASP B 205      30.392  51.598  16.777  1.00 30.05           O  
ATOM   2085  OD2 ASP B 205      32.369  50.800  16.216  1.00 40.57           O  
ATOM   2086  N   ILE B 206      27.878  50.550  19.231  1.00 35.19           N  
ATOM   2087  CA  ILE B 206      26.475  50.389  18.890  1.00 33.70           C  
ATOM   2088  C   ILE B 206      25.731  51.695  19.034  1.00 33.63           C  
ATOM   2089  O   ILE B 206      25.965  52.453  19.974  1.00 38.52           O  
ATOM   2090  CB  ILE B 206      25.785  49.366  19.832  1.00 35.54           C  
ATOM   2091  CG1 ILE B 206      26.420  47.984  19.656  1.00 28.01           C  
ATOM   2092  CG2 ILE B 206      24.276  49.316  19.544  1.00 34.58           C  
ATOM   2093  CD1 ILE B 206      25.770  46.908  20.518  1.00 42.12           C  
ATOM   2094  N   ASP B 207      24.825  51.954  18.102  1.00 32.20           N  
ATOM   2095  CA  ASP B 207      24.017  53.160  18.146  1.00 33.31           C  
ATOM   2096  C   ASP B 207      22.835  52.901  19.090  1.00 36.41           C  
ATOM   2097  O   ASP B 207      22.191  51.859  19.000  1.00 39.13           O  
ATOM   2098  CB  ASP B 207      23.486  53.488  16.745  1.00 33.07           C  
ATOM   2099  CG  ASP B 207      24.534  54.139  15.849  1.00 40.14           C  
ATOM   2100  OD1 ASP B 207      25.739  54.080  16.186  1.00 42.66           O  
ATOM   2101  OD2 ASP B 207      24.151  54.703  14.802  1.00 41.76           O  
ATOM   2102  N   TYR B 208      22.576  53.829  20.010  1.00 37.06           N  
ATOM   2103  CA  TYR B 208      21.441  53.722  20.928  1.00 36.41           C  
ATOM   2104  C   TYR B 208      20.558  54.922  20.635  1.00 39.10           C  
ATOM   2105  O   TYR B 208      20.953  56.068  20.868  1.00 40.70           O  
ATOM   2106  CB  TYR B 208      21.887  53.751  22.386  1.00 32.79           C  
ATOM   2107  CG  TYR B 208      22.573  52.480  22.811  1.00 31.50           C  
ATOM   2108  CD1 TYR B 208      23.903  52.243  22.482  1.00 31.00           C  
ATOM   2109  CD2 TYR B 208      21.879  51.493  23.516  1.00 26.95           C  
ATOM   2110  CE1 TYR B 208      24.524  51.060  22.839  1.00 25.88           C  
ATOM   2111  CE2 TYR B 208      22.489  50.300  23.876  1.00 29.94           C  
ATOM   2112  CZ  TYR B 208      23.812  50.090  23.538  1.00 31.40           C  
ATOM   2113  OH  TYR B 208      24.420  48.906  23.889  1.00 32.14           O  
ATOM   2114  N   LEU B 209      19.359  54.653  20.129  1.00 40.03           N  
ATOM   2115  CA  LEU B 209      18.445  55.714  19.750  1.00 41.06           C  
ATOM   2116  C   LEU B 209      17.419  56.110  20.797  1.00 40.03           C  
ATOM   2117  O   LEU B 209      16.820  55.262  21.458  1.00 36.94           O  
ATOM   2118  CB  LEU B 209      17.709  55.306  18.471  1.00 43.00           C  
ATOM   2119  CG  LEU B 209      18.525  54.587  17.390  1.00 51.21           C  
ATOM   2120  CD1 LEU B 209      17.605  54.198  16.234  1.00 58.83           C  
ATOM   2121  CD2 LEU B 209      19.652  55.478  16.901  1.00 47.75           C  
ATOM   2122  N   VAL B 210      17.208  57.414  20.927  1.00 41.40           N  
ATOM   2123  CA  VAL B 210      16.225  57.932  21.864  1.00 43.60           C  
ATOM   2124  C   VAL B 210      15.336  58.941  21.149  1.00 48.64           C  
ATOM   2125  O   VAL B 210      15.751  60.072  20.888  1.00 48.38           O  
ATOM   2126  CB  VAL B 210      16.893  58.618  23.055  1.00 40.18           C  
ATOM   2127  CG1 VAL B 210      15.848  58.947  24.101  1.00 36.96           C  
ATOM   2128  CG2 VAL B 210      17.976  57.723  23.619  1.00 36.09           C  
ATOM   2129  N   LYS B 211      14.114  58.521  20.824  1.00 54.96           N  
ATOM   2130  CA  LYS B 211      13.167  59.392  20.134  1.00 58.44           C  
ATOM   2131  C   LYS B 211      12.756  60.525  21.077  1.00 61.54           C  
ATOM   2132  O   LYS B 211      12.510  60.293  22.262  1.00 61.88           O  
ATOM   2133  CB  LYS B 211      11.950  58.584  19.684  1.00 59.49           C  
ATOM   2134  N   LEU B 212      12.697  61.746  20.551  1.00 66.42           N  
ATOM   2135  CA  LEU B 212      12.338  62.923  21.350  1.00 70.54           C  
ATOM   2136  C   LEU B 212      10.839  63.238  21.305  1.00 72.94           C  
ATOM   2137  O   LEU B 212      10.443  64.403  21.312  1.00 72.04           O  
ATOM   2138  CB  LEU B 212      13.139  64.141  20.860  1.00 71.47           C  
ATOM   2139  CG  LEU B 212      14.676  64.065  20.925  1.00 74.49           C  
ATOM   2140  CD1 LEU B 212      15.295  65.286  20.248  1.00 68.86           C  
ATOM   2141  CD2 LEU B 212      15.124  63.978  22.381  1.00 71.57           C  
ATOM   2142  N   ASP B 213      10.018  62.190  21.284  1.00 75.46           N  
ATOM   2143  CA  ASP B 213       8.559  62.311  21.216  1.00 78.97           C  
ATOM   2144  C   ASP B 213       7.859  62.555  22.562  1.00 79.92           C  
ATOM   2145  O   ASP B 213       8.522  62.432  23.615  1.00 81.67           O  
ATOM   2146  CB  ASP B 213       8.006  61.048  20.535  1.00 80.60           C  
ATOM   2147  CG  ASP B 213       6.494  60.943  20.600  1.00 84.41           C  
ATOM   2148  OD1 ASP B 213       5.969  60.524  21.654  1.00 87.28           O  
ATOM   2149  OD2 ASP B 213       5.829  61.279  19.596  1.00 85.97           O  
TER    2150      ASP B 213                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
