
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  145 ( 1109),  selected  145 , name 3cfu_A
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 3cfu_A.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X    63_A      E     267           -
LGA    H    64_A      D     268           -
LGA    K    65_A      L     269           -
LGA    I    66_A      L     270           -
LGA    G    67_A      R     271           -
LGA    E    68_A      -       -           -
LGA    T    69_A      -       -           -
LGA    F    70_A      -       -           -
LGA    K    71_A      -       -           -
LGA    A    72_A      P     272           #
LGA    -       -      F     273           -
LGA    -       -      F     274           -
LGA    G    73_A      E     275          2.266
LGA    -       -      K     276           -
LGA    H    74_A      C     277          2.643
LGA    T    75_A      V     278          1.383
LGA    N    76_A      K     279          1.602
LGA    F    77_A      I     280          1.469
LGA    T    78_A      E     281          2.198
LGA    V    79_A      E     282          2.537
LGA    N    80_A      V     283          2.129
LGA    K    81_A      S     284          1.703
LGA    V    82_A      R     285          1.976
LGA    D    83_A      N     286          2.360
LGA    R    84_A      E     287          2.741
LGA    V    85_A      Q     288          5.233
LGA    Q    86_A      -       -           -
LGA    K    87_A      -       -           -
LGA    G    88_A      -       -           -
LGA    E    89_A      -       -           -
LGA    Y    90_A      -       -           -
LGA    X    91_A      -       -           -
LGA    N    92_A      -       -           -
LGA    V    93_A      -       -           -
LGA    G    94_A      -       -           -
LGA    G    95_A      -       -           -
LGA    A    96_A      -       -           -
LGA    T   103_A      -       -           -
LGA    I   104_A      -       -           -
LGA    K   105_A      -       -           -
LGA    D   106_A      -       -           -
LGA    D   107_A      -       -           -
LGA    E   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    R   110_A      -       -           -
LGA    L   111_A      -       -           -
LGA    I   112_A      G     289          2.365
LGA    I   113_A      V     290          1.745
LGA    E   114_A      T     291          1.183
LGA    V   115_A      L     292          1.553
LGA    T   116_A      S     293          1.814
LGA    X   117_A      I     294          1.536
LGA    E   118_A      T     295          1.399
LGA    N   119_A      N     296          1.360
LGA    I   120_A      V     297          2.600
LGA    G   121_A      T     298          3.459
LGA    E   122_A      D     299          3.127
LGA    D   123_A      L     300          2.014
LGA    S   124_A      V     301          0.465
LGA    I   125_A      L     302          1.238
LGA    S   126_A      K     303          2.020
LGA    Y   127_A      L     304          2.918
LGA    N   128_A      K     305          3.535
LGA    F   129_A      K     306          4.056
LGA    I   130_A      T     307          3.678
LGA    G   131_A      A     308           -
LGA    F   132_A      -       -           -
LGA    D   133_A      H     309          4.466
LGA    L   134_A      -       -           -
LGA    R   135_A      -       -           -
LGA    D   136_A      -       -           -
LGA    K   137_A      -       -           -
LGA    N   138_A      -       -           -
LGA    D   139_A      -       -           -
LGA    Q   140_A      -       -           -
LGA    S   141_A      D     310          3.140
LGA    V   142_A      T     311          4.566
LGA    R   143_A      L     312          2.846
LGA    P   144_A      L     313          3.412
LGA    V   145_A      V     314          4.029
LGA    F   146_A      -       -           -
LGA    S   147_A      -       -           -
LGA    I   148_A      -       -           -
LGA    E   149_A      -       -           -
LGA    E   150_A      -       -           -
LGA    K   151_A      -       -           -
LGA    G   152_A      -       -           -
LGA    R   153_A      -       -           -
LGA    I   154_A      Y     315           #
LGA    L   155_A      F     316          3.681
LGA    X   156_A      R     317          4.167
LGA    G   157_A      D     318          2.860
LGA    G   158_A      M     319          3.260
LGA    T   159_A      T     320          2.200
LGA    L   160_A      L     321          1.522
LGA    V   161_A      K     322          1.357
LGA    S   162_A      P     323          1.540
LGA    G   163_A      H     324          1.448
LGA    K   164_A      T     325          1.002
LGA    K   165_A      R     326          1.409
LGA    V   166_A      Y     327          0.953
LGA    T   167_A      T     328          0.706
LGA    G   168_A      V     329          2.060
LGA    V   169_A      R     330          1.200
LGA    L   170_A      I     331          1.655
LGA    S   171_A      G     332          1.390
LGA    Y   172_A      F     333          2.453
LGA    -       -      K     334           -
LGA    V   173_A      Q     335          1.979
LGA    I   174_A      G     336          1.089
LGA    P   175_A      I     337           #
LGA    K   176_A      -       -           -
LGA    G   177_A      -       -           -
LGA    E   178_A      -       -           -
LGA    Q   179_A      K     338          3.194
LGA    K   180_A      -       -           -
LGA    H   181_A      -       -           -
LGA    Y   182_A      -       -           -
LGA    T   183_A      G     339          3.682
LGA    L   184_A      G     340          3.172
LGA    V   185_A      D     341          2.400
LGA    Y   186_A      V     342          4.100
LGA    N   187_A      N     343          4.874
LGA    P   188_A      -       -           -
LGA    F   189_A      -       -           -
LGA    L   190_A      F     344          2.742
LGA    A   191_A      E     345          4.131
LGA    D   192_A      V     346          2.647
LGA    T   193_A      T     347          2.997
LGA    N   194_A      N     348          3.196
LGA    S   195_A      -       -           -
LGA    S   196_A      -       -           -
LGA    N   197_A      -       -           -
LGA    T   198_A      F     349          3.086
LGA    E   199_A      I     350          1.853
LGA    E   200_A      V     351          5.405
LGA    -       -      A     352           -
LGA    -       -      P     353           -
LGA    -       -      D     354           -
LGA    -       -      K     355           -
LGA    R   201_A      G     356           #
LGA    V   202_A      -       -           -
LGA    K   203_A      -       -           -
LGA    D   204_A      L     357          5.259
LGA    D   205_A      K     358          3.694
LGA    I   206_A      Y     359          4.655
LGA    D   207_A      T     360          3.595
LGA    Y   208_A      I     361          4.292
LGA    L   209_A      S     362          2.693
LGA    V   210_A      L     363          3.430
LGA    K   211_A      -       -           -
LGA    L   212_A      -       -           -
LGA    D   213_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  145   97    5.0     79    2.88    10.13     52.579     2.651

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.840186 * X  +  -0.359358 * Y  +   0.406140 * Z  +  72.236450
  Y_new =  -0.428615 * X  +  -0.018776 * Y  +  -0.903292 * Z  + 104.679726
  Z_new =   0.332231 * X  +  -0.933011 * Y  +  -0.138251 * Z  +  24.680990 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.717903    1.423690  [ DEG:   -98.4286     81.5714 ]
  Theta =  -0.338668   -2.802925  [ DEG:   -19.4042   -160.5958 ]
  Phi   =  -2.669864    0.471729  [ DEG:  -152.9719     27.0281 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cfu_A                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cfu_A.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  145   97   5.0   79   2.88   10.13  52.579
REMARK  ---------------------------------------------------------- 
MOLECULE 3cfu_A
HEADER    LIPOPROTEIN                             04-MAR-08   3CFU              
TITLE     CRYSTAL STRUCTURE OF THE YJHA PROTEIN FROM BACILLUS                   
TITLE    2 SUBTILIS. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM TARGET            
TITLE    3 SR562                                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED LIPOPROTEIN YJHA;                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: RESIDUES 64-213;                                           
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 GENE: YJHA, BSU12180;                                                
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    YJHA_BACSU, YJHA, LIPOPROTEIN, SR562, NESG, STRUCTURAL                
KEYWDS   2 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, NORTHEAST             
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, MEMBRANE, PALMITATE                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.M.VOROBIEV,Y.CHEN,A.P.KUZIN,J.SEETHARAMAN,F.FOROUHAR,               
AUTHOR   2 L.ZHAO,L.MAO,M.MAGLAQUI,R.XIAO,J.LIU,G.SWAPNA,J.Y.HUANG,             
AUTHOR   3 T.B.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST                   
AUTHOR   4 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   1   18-MAR-08 3CFU    0                                                
JRNL        AUTH   S.M.VOROBIEV,Y.CHEN,A.P.KUZIN,J.SEETHARAMAN,                 
JRNL        AUTH 2 F.FOROUHAR,L.ZHAO,L.MAO,M.MAGLAQUI,R.XIAO,J.LIU,             
JRNL        AUTH 3 G.SWAPNA,J.Y.HUANG,T.B.ACTON,G.T.MONTELIONE,                 
JRNL        AUTH 4 J.F.HUNT,L.TONG                                              
JRNL        TITL   CRYSTAL STRUCTURE OF THE YJHA PROTEIN FROM                   
JRNL        TITL 2 BACILLUS SUBTILIS.                                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  3CFU A   64   213  UNP    O34725   YJHA_BACSU      64    213             
DBREF  3CFU B   64   213  UNP    O34725   YJHA_BACSU      64    213             
SEQRES   1 A  159  MSE HIS LYS ILE GLY GLU THR PHE LYS ALA GLY HIS THR          
SEQRES   2 A  159  ASN PHE THR VAL ASN LYS VAL ASP ARG VAL GLN LYS GLY          
SEQRES   3 A  159  GLU TYR MSE ASN VAL GLY GLY ALA VAL ASN GLU GLU THR          
SEQRES   4 A  159  LYS THR ILE LYS ASP ASP GLU GLU ARG LEU ILE ILE GLU          
SEQRES   5 A  159  VAL THR MSE GLU ASN ILE GLY GLU ASP SER ILE SER TYR          
SEQRES   6 A  159  ASN PHE ILE GLY PHE ASP LEU ARG ASP LYS ASN ASP GLN          
SEQRES   7 A  159  SER VAL ARG PRO VAL PHE SER ILE GLU GLU LYS GLY ARG          
SEQRES   8 A  159  ILE LEU MSE GLY GLY THR LEU VAL SER GLY LYS LYS VAL          
SEQRES   9 A  159  THR GLY VAL LEU SER TYR VAL ILE PRO LYS GLY GLU GLN          
SEQRES  10 A  159  LYS HIS TYR THR LEU VAL TYR ASN PRO PHE LEU ALA ASP          
SEQRES  11 A  159  THR ASN SER SER ASN THR GLU GLU ARG VAL LYS ASP ASP          
SEQRES  12 A  159  ILE ASP TYR LEU VAL LYS LEU ASP LEU GLU HIS HIS HIS          
SEQRES  13 A  159  HIS HIS HIS                                                  
SEQRES   1 B  159  MSE HIS LYS ILE GLY GLU THR PHE LYS ALA GLY HIS THR          
SEQRES   2 B  159  ASN PHE THR VAL ASN LYS VAL ASP ARG VAL GLN LYS GLY          
SEQRES   3 B  159  GLU TYR MSE ASN VAL GLY GLY ALA VAL ASN GLU GLU THR          
SEQRES   4 B  159  LYS THR ILE LYS ASP ASP GLU GLU ARG LEU ILE ILE GLU          
SEQRES   5 B  159  VAL THR MSE GLU ASN ILE GLY GLU ASP SER ILE SER TYR          
SEQRES   6 B  159  ASN PHE ILE GLY PHE ASP LEU ARG ASP LYS ASN ASP GLN          
SEQRES   7 B  159  SER VAL ARG PRO VAL PHE SER ILE GLU GLU LYS GLY ARG          
SEQRES   8 B  159  ILE LEU MSE GLY GLY THR LEU VAL SER GLY LYS LYS VAL          
SEQRES   9 B  159  THR GLY VAL LEU SER TYR VAL ILE PRO LYS GLY GLU GLN          
SEQRES  10 B  159  LYS HIS TYR THR LEU VAL TYR ASN PRO PHE LEU ALA ASP          
SEQRES  11 B  159  THR ASN SER SER ASN THR GLU GLU ARG VAL LYS ASP ASP          
SEQRES  12 B  159  ILE ASP TYR LEU VAL LYS LEU ASP LEU GLU HIS HIS HIS          
SEQRES  13 B  159  HIS HIS HIS                                                  
HET    MSE  A  63       8                                                       
HET    MSE  A  91       8                                                       
HET    MSE  A 117       8                                                       
HET    MSE  A 156       8                                                       
HET    MSE  B  63       8                                                       
HET    MSE  B  91       8                                                       
HET    MSE  B 117       8                                                       
HET    MSE  B 156       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *89(H2 O)                                                     
CRYST1   62.678   41.687   65.656  90.00  91.74  90.00 P 1 21 1      4          
HETATM    1  N   MSE A  63      12.415  51.275  21.083  1.00 68.50           N  
HETATM    2  CA  MSE A  63      13.827  51.745  21.238  1.00 68.35           C  
HETATM    3  C   MSE A  63      14.040  52.185  22.681  1.00 63.69           C  
HETATM    4  O   MSE A  63      14.078  51.360  23.589  1.00 65.37           O  
HETATM    5  CB  MSE A  63      14.095  52.922  20.293  1.00 69.74           C  
HETATM    6  CG  MSE A  63      13.895  52.608  18.813  1.00 78.40           C  
HETATM    7 SE   MSE A  63      13.741  54.228  17.759  1.00 94.86          SE  
HETATM    8  CE  MSE A  63      14.776  53.724  16.204  1.00 90.91           C  
ATOM      9  N   HIS A  64      14.206  53.484  22.885  1.00 58.07           N  
ATOM     10  CA  HIS A  64      14.369  54.032  24.224  1.00 52.70           C  
ATOM     11  C   HIS A  64      13.615  55.353  24.233  1.00 49.30           C  
ATOM     12  O   HIS A  64      13.537  56.049  23.224  1.00 49.42           O  
ATOM     13  CB  HIS A  64      15.854  54.228  24.583  1.00 53.40           C  
ATOM     14  CG  HIS A  64      16.627  52.944  24.675  1.00 45.05           C  
ATOM     15  ND1 HIS A  64      16.414  52.009  25.665  1.00 45.19           N  
ATOM     16  CD2 HIS A  64      17.581  52.421  23.867  1.00 46.68           C  
ATOM     17  CE1 HIS A  64      17.201  50.967  25.464  1.00 36.34           C  
ATOM     18  NE2 HIS A  64      17.920  51.191  24.380  1.00 36.63           N  
ATOM     19  N   LYS A  65      13.037  55.677  25.378  1.00 48.97           N  
ATOM     20  CA  LYS A  65      12.253  56.887  25.530  1.00 48.38           C  
ATOM     21  C   LYS A  65      12.978  57.918  26.373  1.00 46.80           C  
ATOM     22  O   LYS A  65      13.961  57.604  27.041  1.00 48.21           O  
ATOM     23  CB  LYS A  65      10.911  56.532  26.189  1.00 49.62           C  
ATOM     24  N   ILE A  66      12.488  59.153  26.336  1.00 46.85           N  
ATOM     25  CA  ILE A  66      13.053  60.231  27.136  1.00 47.25           C  
ATOM     26  C   ILE A  66      12.734  59.917  28.604  1.00 48.18           C  
ATOM     27  O   ILE A  66      11.609  59.552  28.928  1.00 52.09           O  
ATOM     28  CB  ILE A  66      12.401  61.579  26.791  1.00 47.78           C  
ATOM     29  CG1 ILE A  66      12.547  61.862  25.298  1.00 49.24           C  
ATOM     30  CG2 ILE A  66      13.038  62.692  27.600  1.00 50.84           C  
ATOM     31  CD1 ILE A  66      12.109  63.258  24.904  1.00 41.40           C  
ATOM     32  N   GLY A  67      13.726  60.053  29.479  1.00 46.97           N  
ATOM     33  CA  GLY A  67      13.522  59.790  30.892  1.00 44.43           C  
ATOM     34  C   GLY A  67      14.029  58.441  31.374  1.00 45.64           C  
ATOM     35  O   GLY A  67      14.358  58.269  32.553  1.00 47.39           O  
ATOM     36  N   GLU A  68      14.104  57.482  30.462  1.00 44.64           N  
ATOM     37  CA  GLU A  68      14.556  56.138  30.799  1.00 44.54           C  
ATOM     38  C   GLU A  68      16.080  55.964  30.823  1.00 44.79           C  
ATOM     39  O   GLU A  68      16.798  56.466  29.946  1.00 48.88           O  
ATOM     40  CB  GLU A  68      13.928  55.146  29.809  1.00 45.94           C  
ATOM     41  CG  GLU A  68      14.484  53.717  29.843  1.00 48.72           C  
ATOM     42  CD  GLU A  68      14.116  52.921  28.582  1.00 60.97           C  
ATOM     43  OE1 GLU A  68      14.840  51.958  28.239  1.00 55.95           O  
ATOM     44  OE2 GLU A  68      13.100  53.259  27.933  1.00 63.65           O  
ATOM     45  N   THR A  69      16.559  55.258  31.843  1.00 39.15           N  
ATOM     46  CA  THR A  69      17.977  54.957  32.009  1.00 35.91           C  
ATOM     47  C   THR A  69      18.188  53.522  31.504  1.00 37.85           C  
ATOM     48  O   THR A  69      17.373  52.636  31.784  1.00 36.13           O  
ATOM     49  CB  THR A  69      18.402  55.026  33.508  1.00 38.45           C  
ATOM     50  OG1 THR A  69      18.206  56.359  33.999  1.00 32.31           O  
ATOM     51  CG2 THR A  69      19.878  54.646  33.687  1.00 32.17           C  
ATOM     52  N   PHE A  70      19.261  53.294  30.749  1.00 34.21           N  
ATOM     53  CA  PHE A  70      19.546  51.954  30.246  1.00 32.42           C  
ATOM     54  C   PHE A  70      21.052  51.697  30.163  1.00 31.40           C  
ATOM     55  O   PHE A  70      21.836  52.635  30.143  1.00 32.79           O  
ATOM     56  CB  PHE A  70      18.885  51.733  28.862  1.00 31.80           C  
ATOM     57  CG  PHE A  70      19.272  52.753  27.814  1.00 34.39           C  
ATOM     58  CD1 PHE A  70      18.652  53.997  27.764  1.00 32.56           C  
ATOM     59  CD2 PHE A  70      20.257  52.464  26.882  1.00 31.75           C  
ATOM     60  CE1 PHE A  70      19.010  54.942  26.799  1.00 29.21           C  
ATOM     61  CE2 PHE A  70      20.622  53.394  25.918  1.00 27.25           C  
ATOM     62  CZ  PHE A  70      19.998  54.638  25.875  1.00 34.10           C  
ATOM     63  N   LYS A  71      21.452  50.429  30.134  1.00 31.32           N  
ATOM     64  CA  LYS A  71      22.866  50.070  30.039  1.00 35.64           C  
ATOM     65  C   LYS A  71      23.342  50.138  28.586  1.00 37.76           C  
ATOM     66  O   LYS A  71      22.742  49.533  27.693  1.00 35.91           O  
ATOM     67  CB  LYS A  71      23.102  48.655  30.578  1.00 35.36           C  
ATOM     68  CG  LYS A  71      24.573  48.281  30.757  1.00 32.84           C  
ATOM     69  CD  LYS A  71      24.699  46.866  31.304  1.00 41.77           C  
ATOM     70  CE  LYS A  71      26.048  46.258  30.975  1.00 42.37           C  
ATOM     71  NZ  LYS A  71      26.310  46.357  29.515  1.00 52.56           N  
ATOM     72  N   ALA A  72      24.428  50.873  28.363  1.00 33.92           N  
ATOM     73  CA  ALA A  72      24.998  51.036  27.028  1.00 34.04           C  
ATOM     74  C   ALA A  72      26.520  51.010  27.171  1.00 31.78           C  
ATOM     75  O   ALA A  72      27.145  52.006  27.540  1.00 30.62           O  
ATOM     76  CB  ALA A  72      24.528  52.355  26.435  1.00 35.67           C  
ATOM     77  N   GLY A  73      27.108  49.857  26.885  1.00 32.58           N  
ATOM     78  CA  GLY A  73      28.542  49.714  27.026  1.00 34.95           C  
ATOM     79  C   GLY A  73      28.889  49.680  28.504  1.00 35.01           C  
ATOM     80  O   GLY A  73      28.250  48.961  29.285  1.00 35.86           O  
ATOM     81  N   HIS A  74      29.896  50.468  28.883  1.00 34.30           N  
ATOM     82  CA  HIS A  74      30.352  50.564  30.269  1.00 31.91           C  
ATOM     83  C   HIS A  74      29.728  51.750  30.989  1.00 31.56           C  
ATOM     84  O   HIS A  74      30.255  52.226  31.995  1.00 30.08           O  
ATOM     85  CB  HIS A  74      31.874  50.676  30.314  1.00 31.31           C  
ATOM     86  CG  HIS A  74      32.571  49.416  29.913  1.00 33.95           C  
ATOM     87  ND1 HIS A  74      32.654  48.319  30.744  1.00 40.19           N  
ATOM     88  CD2 HIS A  74      33.170  49.058  28.754  1.00 34.47           C  
ATOM     89  CE1 HIS A  74      33.273  47.338  30.112  1.00 45.93           C  
ATOM     90  NE2 HIS A  74      33.596  47.760  28.902  1.00 46.48           N  
ATOM     91  N   THR A  75      28.597  52.212  30.474  1.00 32.99           N  
ATOM     92  CA  THR A  75      27.894  53.343  31.064  1.00 31.94           C  
ATOM     93  C   THR A  75      26.393  53.072  31.176  1.00 32.68           C  
ATOM     94  O   THR A  75      25.881  52.166  30.531  1.00 29.44           O  
ATOM     95  CB  THR A  75      28.009  54.616  30.169  1.00 30.95           C  
ATOM     96  OG1 THR A  75      27.332  54.382  28.924  1.00 31.77           O  
ATOM     97  CG2 THR A  75      29.460  54.961  29.879  1.00 32.87           C  
ATOM     98  N   ASN A  76      25.704  53.835  32.032  1.00 30.07           N  
ATOM     99  CA  ASN A  76      24.239  53.769  32.101  1.00 30.43           C  
ATOM    100  C   ASN A  76      24.006  55.136  31.487  1.00 29.59           C  
ATOM    101  O   ASN A  76      24.647  56.104  31.886  1.00 29.68           O  
ATOM    102  CB  ASN A  76      23.663  53.788  33.517  1.00 31.18           C  
ATOM    103  CG  ASN A  76      23.644  52.425  34.172  1.00 28.16           C  
ATOM    104  OD1 ASN A  76      23.660  52.332  35.397  1.00 36.64           O  
ATOM    105  ND2 ASN A  76      23.595  51.365  33.371  1.00 35.82           N  
ATOM    106  N   PHE A  77      23.092  55.227  30.540  1.00 32.48           N  
ATOM    107  CA  PHE A  77      22.849  56.479  29.853  1.00 31.54           C  
ATOM    108  C   PHE A  77      21.398  56.917  29.872  1.00 30.26           C  
ATOM    109  O   PHE A  77      20.488  56.091  29.782  1.00 29.60           O  
ATOM    110  CB  PHE A  77      23.292  56.335  28.397  1.00 29.53           C  
ATOM    111  CG  PHE A  77      22.998  57.531  27.557  1.00 29.68           C  
ATOM    112  CD1 PHE A  77      23.815  58.646  27.616  1.00 25.94           C  
ATOM    113  CD2 PHE A  77      21.882  57.555  26.732  1.00 28.51           C  
ATOM    114  CE1 PHE A  77      23.534  59.765  26.871  1.00 26.77           C  
ATOM    115  CE2 PHE A  77      21.591  58.669  25.980  1.00 26.50           C  
ATOM    116  CZ  PHE A  77      22.419  59.785  26.052  1.00 29.78           C  
ATOM    117  N   THR A  78      21.173  58.219  29.946  1.00 32.89           N  
ATOM    118  CA  THR A  78      19.807  58.690  29.958  1.00 37.98           C  
ATOM    119  C   THR A  78      19.619  60.068  29.350  1.00 37.11           C  
ATOM    120  O   THR A  78      20.478  60.942  29.477  1.00 39.53           O  
ATOM    121  CB  THR A  78      19.229  58.688  31.418  1.00 37.80           C  
ATOM    122  OG1 THR A  78      18.019  59.459  31.465  1.00 47.06           O  
ATOM    123  CG2 THR A  78      20.216  59.263  32.385  1.00 33.93           C  
ATOM    124  N   VAL A  79      18.503  60.232  28.647  1.00 41.99           N  
ATOM    125  CA  VAL A  79      18.152  61.519  28.072  1.00 42.87           C  
ATOM    126  C   VAL A  79      17.144  62.058  29.093  1.00 46.26           C  
ATOM    127  O   VAL A  79      16.059  61.496  29.260  1.00 45.59           O  
ATOM    128  CB  VAL A  79      17.471  61.389  26.689  1.00 41.50           C  
ATOM    129  CG1 VAL A  79      17.151  62.779  26.152  1.00 40.53           C  
ATOM    130  CG2 VAL A  79      18.380  60.652  25.715  1.00 41.53           C  
ATOM    131  N   ASN A  80      17.513  63.130  29.787  1.00 49.28           N  
ATOM    132  CA  ASN A  80      16.654  63.719  30.815  1.00 51.17           C  
ATOM    133  C   ASN A  80      15.454  64.469  30.251  1.00 53.84           C  
ATOM    134  O   ASN A  80      14.330  63.971  30.306  1.00 54.22           O  
ATOM    135  CB  ASN A  80      17.484  64.640  31.705  1.00 50.36           C  
ATOM    136  CG  ASN A  80      18.598  63.901  32.424  1.00 52.77           C  
ATOM    137  OD1 ASN A  80      19.652  64.471  32.723  1.00 56.10           O  
ATOM    138  ND2 ASN A  80      18.366  62.627  32.712  1.00 49.28           N  
ATOM    139  N   LYS A  81      15.683  65.665  29.718  1.00 56.65           N  
ATOM    140  CA  LYS A  81      14.595  66.449  29.146  1.00 57.06           C  
ATOM    141  C   LYS A  81      14.982  67.084  27.826  1.00 57.12           C  
ATOM    142  O   LYS A  81      16.155  67.089  27.439  1.00 55.15           O  
ATOM    143  CB  LYS A  81      14.179  67.597  30.076  1.00 58.88           C  
ATOM    144  CG  LYS A  81      14.576  67.441  31.524  1.00 64.29           C  
ATOM    145  CD  LYS A  81      15.734  68.357  31.881  1.00 67.99           C  
ATOM    146  CE  LYS A  81      15.306  69.817  31.925  1.00 62.34           C  
ATOM    147  NZ  LYS A  81      16.475  70.694  32.189  1.00 67.87           N  
ATOM    148  N   VAL A  82      13.975  67.613  27.137  1.00 56.68           N  
ATOM    149  CA  VAL A  82      14.204  68.332  25.900  1.00 55.70           C  
ATOM    150  C   VAL A  82      13.496  69.681  25.998  1.00 58.27           C  
ATOM    151  O   VAL A  82      12.272  69.769  25.888  1.00 59.41           O  
ATOM    152  CB  VAL A  82      13.671  67.615  24.642  1.00 53.71           C  
ATOM    153  CG1 VAL A  82      13.970  68.478  23.413  1.00 50.96           C  
ATOM    154  CG2 VAL A  82      14.324  66.259  24.486  1.00 54.80           C  
ATOM    155  N   ASP A  83      14.260  70.736  26.243  1.00 59.22           N  
ATOM    156  CA  ASP A  83      13.663  72.059  26.302  1.00 62.23           C  
ATOM    157  C   ASP A  83      13.856  72.657  24.895  1.00 61.65           C  
ATOM    158  O   ASP A  83      14.701  72.189  24.129  1.00 62.18           O  
ATOM    159  CB  ASP A  83      14.346  72.924  27.378  1.00 61.92           C  
ATOM    160  CG  ASP A  83      14.331  72.265  28.764  1.00 67.15           C  
ATOM    161  OD1 ASP A  83      13.276  71.712  29.147  1.00 70.96           O  
ATOM    162  OD2 ASP A  83      15.369  72.308  29.472  1.00 62.10           O  
ATOM    163  N   ARG A  84      13.048  73.653  24.544  1.00 61.81           N  
ATOM    164  CA  ARG A  84      13.151  74.310  23.243  1.00 61.91           C  
ATOM    165  C   ARG A  84      13.194  75.812  23.494  1.00 62.69           C  
ATOM    166  O   ARG A  84      12.476  76.317  24.357  1.00 64.44           O  
ATOM    167  CB  ARG A  84      11.926  73.996  22.363  1.00 63.04           C  
ATOM    168  CG  ARG A  84      11.681  72.521  22.052  1.00 58.79           C  
ATOM    169  CD  ARG A  84      10.185  72.241  21.958  1.00 58.98           C  
ATOM    170  NE  ARG A  84       9.508  72.511  23.229  1.00 65.58           N  
ATOM    171  CZ  ARG A  84       8.205  72.764  23.355  1.00 64.80           C  
ATOM    172  NH1 ARG A  84       7.425  72.790  22.281  1.00 61.15           N  
ATOM    173  NH2 ARG A  84       7.679  72.984  24.558  1.00 62.83           N  
ATOM    174  N   VAL A  85      14.048  76.523  22.764  1.00 63.33           N  
ATOM    175  CA  VAL A  85      14.126  77.975  22.903  1.00 63.86           C  
ATOM    176  C   VAL A  85      13.880  78.566  21.518  1.00 64.54           C  
ATOM    177  O   VAL A  85      13.942  77.846  20.516  1.00 64.23           O  
ATOM    178  CB  VAL A  85      15.518  78.463  23.402  1.00 63.40           C  
ATOM    179  CG1 VAL A  85      16.544  78.428  22.268  1.00 67.25           C  
ATOM    180  CG2 VAL A  85      15.399  79.882  23.951  1.00 66.16           C  
ATOM    181  N   GLN A  86      13.572  79.859  21.456  1.00 64.56           N  
ATOM    182  CA  GLN A  86      13.370  80.517  20.168  1.00 65.37           C  
ATOM    183  C   GLN A  86      14.393  81.648  20.041  1.00 65.67           C  
ATOM    184  O   GLN A  86      15.530  81.409  19.630  1.00 64.86           O  
ATOM    185  CB  GLN A  86      11.943  81.061  20.023  1.00 68.09           C  
ATOM    186  CG  GLN A  86      10.857  79.991  19.981  1.00 64.06           C  
ATOM    187  CD  GLN A  86      10.552  79.426  21.352  1.00 56.97           C  
ATOM    188  OE1 GLN A  86      10.916  80.019  22.370  1.00 63.41           O  
ATOM    189  NE2 GLN A  86       9.868  78.285  21.391  1.00 54.25           N  
ATOM    190  N   LYS A  87      14.010  82.869  20.402  1.00 65.40           N  
ATOM    191  CA  LYS A  87      14.934  83.995  20.313  1.00 65.54           C  
ATOM    192  C   LYS A  87      16.288  83.647  20.932  1.00 66.21           C  
ATOM    193  O   LYS A  87      16.363  83.093  22.037  1.00 65.70           O  
ATOM    194  CB  LYS A  87      14.344  85.223  21.013  1.00 64.79           C  
ATOM    195  N   GLY A  88      17.356  83.969  20.207  1.00 64.85           N  
ATOM    196  CA  GLY A  88      18.695  83.705  20.700  1.00 62.31           C  
ATOM    197  C   GLY A  88      19.697  83.397  19.608  1.00 60.83           C  
ATOM    198  O   GLY A  88      19.322  82.968  18.516  1.00 55.75           O  
ATOM    199  N   GLU A  89      20.971  83.641  19.899  1.00 62.71           N  
ATOM    200  CA  GLU A  89      22.039  83.354  18.955  1.00 63.88           C  
ATOM    201  C   GLU A  89      22.586  81.989  19.329  1.00 65.06           C  
ATOM    202  O   GLU A  89      22.768  81.684  20.510  1.00 65.16           O  
ATOM    203  CB  GLU A  89      23.153  84.393  19.052  1.00 64.79           C  
ATOM    204  N   TYR A  90      22.825  81.163  18.319  1.00 66.56           N  
ATOM    205  CA  TYR A  90      23.370  79.835  18.538  1.00 66.62           C  
ATOM    206  C   TYR A  90      24.619  79.678  17.669  1.00 68.42           C  
ATOM    207  O   TYR A  90      24.899  80.511  16.803  1.00 67.09           O  
ATOM    208  CB  TYR A  90      22.340  78.756  18.210  1.00 64.00           C  
ATOM    209  CG  TYR A  90      22.054  78.646  16.748  1.00 64.18           C  
ATOM    210  CD1 TYR A  90      20.994  79.334  16.169  1.00 54.69           C  
ATOM    211  CD2 TYR A  90      22.875  77.881  15.926  1.00 62.44           C  
ATOM    212  CE1 TYR A  90      20.766  79.261  14.806  1.00 56.18           C  
ATOM    213  CE2 TYR A  90      22.657  77.807  14.569  1.00 60.35           C  
ATOM    214  CZ  TYR A  90      21.602  78.498  14.012  1.00 59.69           C  
ATOM    215  OH  TYR A  90      21.394  78.421  12.656  1.00 67.92           O  
HETATM  216  N   MSE A  91      25.348  78.588  17.881  1.00 70.45           N  
HETATM  217  CA  MSE A  91      26.604  78.361  17.179  1.00 71.56           C  
HETATM  218  C   MSE A  91      26.866  76.903  16.851  1.00 69.85           C  
HETATM  219  O   MSE A  91      26.550  76.019  17.646  1.00 71.05           O  
HETATM  220  CB  MSE A  91      27.737  78.826  18.076  1.00 73.83           C  
HETATM  221  CG  MSE A  91      28.413  80.110  17.723  1.00 81.78           C  
HETATM  222 SE   MSE A  91      29.833  80.358  19.006  1.00 99.01          SE  
HETATM  223  CE  MSE A  91      28.761  80.570  20.608  1.00 97.80           C  
ATOM    224  N   ASN A  92      27.482  76.654  15.701  1.00 67.72           N  
ATOM    225  CA  ASN A  92      27.798  75.289  15.317  1.00 66.70           C  
ATOM    226  C   ASN A  92      28.987  74.776  16.130  1.00 65.82           C  
ATOM    227  O   ASN A  92      30.005  75.460  16.270  1.00 61.32           O  
ATOM    228  CB  ASN A  92      28.074  75.217  13.817  1.00 67.30           C  
ATOM    229  CG  ASN A  92      26.796  75.131  13.006  1.00 71.64           C  
ATOM    230  OD1 ASN A  92      25.888  75.944  13.174  1.00 82.72           O  
ATOM    231  ND2 ASN A  92      26.714  74.140  12.126  1.00 78.36           N  
ATOM    232  N   VAL A  93      28.829  73.575  16.682  1.00 64.52           N  
ATOM    233  CA  VAL A  93      29.866  72.957  17.497  1.00 64.04           C  
ATOM    234  C   VAL A  93      30.965  72.312  16.670  1.00 62.54           C  
ATOM    235  O   VAL A  93      31.236  71.118  16.810  1.00 63.96           O  
ATOM    236  CB  VAL A  93      29.299  71.880  18.469  1.00 64.32           C  
ATOM    237  CG1 VAL A  93      30.432  71.287  19.327  1.00 64.53           C  
ATOM    238  CG2 VAL A  93      28.248  72.495  19.372  1.00 63.09           C  
ATOM    239  N   GLY A  94      31.578  73.101  15.792  1.00 60.57           N  
ATOM    240  CA  GLY A  94      32.676  72.589  14.997  1.00 57.33           C  
ATOM    241  C   GLY A  94      32.623  72.600  13.483  1.00 56.57           C  
ATOM    242  O   GLY A  94      31.586  72.318  12.887  1.00 59.81           O  
ATOM    243  N   GLY A  95      33.766  72.930  12.871  1.00 48.88           N  
ATOM    244  CA  GLY A  95      33.918  72.947  11.419  1.00 45.35           C  
ATOM    245  C   GLY A  95      33.190  74.012  10.626  1.00 41.31           C  
ATOM    246  O   GLY A  95      32.492  73.692   9.659  1.00 38.95           O  
ATOM    247  N   ALA A  96      33.391  75.276  10.998  1.00 43.57           N  
ATOM    248  CA  ALA A  96      32.722  76.406  10.347  1.00 41.42           C  
ATOM    249  C   ALA A  96      33.609  77.659  10.256  1.00 42.96           C  
ATOM    250  O   ALA A  96      33.871  78.191   9.164  1.00 39.00           O  
ATOM    251  CB  ALA A  96      31.441  76.756  11.133  1.00 39.06           C  
ATOM    252  N   THR A 103      27.948  85.383  13.124  1.00 73.30           N  
ATOM    253  CA  THR A 103      26.834  85.316  14.051  1.00 73.56           C  
ATOM    254  C   THR A 103      25.517  84.986  13.360  1.00 72.72           C  
ATOM    255  O   THR A 103      25.045  85.741  12.513  1.00 73.96           O  
ATOM    256  CB  THR A 103      26.691  86.654  14.800  1.00 73.01           C  
ATOM    257  N   ILE A 104      24.952  83.830  13.704  1.00 71.78           N  
ATOM    258  CA  ILE A 104      23.657  83.407  13.156  1.00 72.05           C  
ATOM    259  C   ILE A 104      22.622  83.426  14.290  1.00 69.86           C  
ATOM    260  O   ILE A 104      22.935  83.121  15.445  1.00 66.99           O  
ATOM    261  CB  ILE A 104      23.716  82.038  12.488  1.00 72.82           C  
ATOM    262  CG1 ILE A 104      22.327  81.674  11.954  1.00 76.09           C  
ATOM    263  CG2 ILE A 104      24.210  80.996  13.474  1.00 71.19           C  
ATOM    264  CD1 ILE A 104      22.374  80.751  10.752  1.00 77.01           C  
ATOM    265  N   LYS A 105      21.381  83.745  13.941  1.00 67.89           N  
ATOM    266  CA  LYS A 105      20.326  83.896  14.943  1.00 63.75           C  
ATOM    267  C   LYS A 105      19.333  82.768  14.946  1.00 60.57           C  
ATOM    268  O   LYS A 105      19.681  81.640  14.636  1.00 61.51           O  
ATOM    269  CB  LYS A 105      19.599  85.233  14.645  1.00 63.85           C  
ATOM    270  N   ASP A 106      18.100  83.069  15.334  1.00 52.67           N  
ATOM    271  CA  ASP A 106      17.041  82.065  15.333  1.00 51.23           C  
ATOM    272  C   ASP A 106      16.867  81.517  13.902  1.00 53.35           C  
ATOM    273  O   ASP A 106      16.916  82.266  12.917  1.00 55.42           O  
ATOM    274  CB  ASP A 106      15.712  82.701  15.764  1.00 48.34           C  
ATOM    275  CG  ASP A 106      15.908  84.018  16.494  1.00 44.58           C  
ATOM    276  OD1 ASP A 106      16.697  84.051  17.471  1.00 39.54           O  
ATOM    277  OD2 ASP A 106      15.283  85.022  16.093  1.00 42.42           O  
ATOM    278  N   ASP A 107      16.684  80.197  13.790  1.00 55.03           N  
ATOM    279  CA  ASP A 107      16.493  79.527  12.461  1.00 54.09           C  
ATOM    280  C   ASP A 107      15.011  79.124  12.443  1.00 55.17           C  
ATOM    281  O   ASP A 107      14.244  79.606  11.578  1.00 56.23           O  
ATOM    282  CB  ASP A 107      17.418  78.378  12.332  1.00 56.51           C  
ATOM    283  N   GLU A 108      14.673  78.153  13.291  1.00 51.00           N  
ATOM    284  CA  GLU A 108      13.245  77.884  13.547  1.00 51.13           C  
ATOM    285  C   GLU A 108      13.133  77.609  15.078  1.00 51.37           C  
ATOM    286  O   GLU A 108      12.568  78.410  15.844  1.00 53.71           O  
ATOM    287  CB  GLU A 108      12.634  76.781  12.776  1.00 45.58           C  
ATOM    288  N   GLU A 109      13.672  76.476  15.512  1.00 51.31           N  
ATOM    289  CA  GLU A 109      13.627  76.086  16.919  1.00 53.64           C  
ATOM    290  C   GLU A 109      14.870  75.286  17.305  1.00 54.98           C  
ATOM    291  O   GLU A 109      15.365  74.462  16.528  1.00 53.71           O  
ATOM    292  CB  GLU A 109      12.369  75.269  17.185  1.00 51.97           C  
ATOM    293  N   ARG A 110      15.368  75.535  18.508  1.00 54.96           N  
ATOM    294  CA  ARG A 110      16.553  74.859  18.986  1.00 55.64           C  
ATOM    295  C   ARG A 110      16.271  73.878  20.112  1.00 56.73           C  
ATOM    296  O   ARG A 110      15.697  74.244  21.139  1.00 57.39           O  
ATOM    297  CB  ARG A 110      17.584  75.899  19.482  1.00 54.88           C  
ATOM    298  CG  ARG A 110      18.963  75.327  19.784  1.00 55.92           C  
ATOM    299  CD  ARG A 110      20.013  76.427  19.856  1.00 61.32           C  
ATOM    300  NE  ARG A 110      19.743  77.379  20.929  1.00 60.84           N  
ATOM    301  CZ  ARG A 110      19.917  77.118  22.220  1.00 64.78           C  
ATOM    302  NH1 ARG A 110      20.366  75.931  22.608  1.00 71.27           N  
ATOM    303  NH2 ARG A 110      19.641  78.044  23.129  1.00 66.59           N  
ATOM    304  N   LEU A 111      16.642  72.622  19.896  1.00 54.88           N  
ATOM    305  CA  LEU A 111      16.482  71.603  20.920  1.00 52.48           C  
ATOM    306  C   LEU A 111      17.636  71.722  21.934  1.00 50.60           C  
ATOM    307  O   LEU A 111      18.773  72.039  21.574  1.00 50.12           O  
ATOM    308  CB  LEU A 111      16.529  70.200  20.294  1.00 52.27           C  
ATOM    309  CG  LEU A 111      15.267  69.777  19.532  1.00 53.53           C  
ATOM    310  CD1 LEU A 111      14.761  70.924  18.679  1.00 58.54           C  
ATOM    311  CD2 LEU A 111      15.558  68.555  18.675  1.00 53.04           C  
ATOM    312  N   ILE A 112      17.317  71.495  23.204  1.00 48.80           N  
ATOM    313  CA  ILE A 112      18.316  71.516  24.264  1.00 48.46           C  
ATOM    314  C   ILE A 112      18.143  70.211  25.013  1.00 48.32           C  
ATOM    315  O   ILE A 112      17.404  70.147  25.993  1.00 49.84           O  
ATOM    316  CB  ILE A 112      18.128  72.657  25.274  1.00 50.71           C  
ATOM    317  CG1 ILE A 112      18.247  74.010  24.573  1.00 50.21           C  
ATOM    318  CG2 ILE A 112      19.170  72.535  26.380  1.00 48.39           C  
ATOM    319  CD1 ILE A 112      17.073  74.328  23.678  1.00 61.71           C  
ATOM    320  N   ILE A 113      18.819  69.167  24.544  1.00 48.72           N  
ATOM    321  CA  ILE A 113      18.730  67.860  25.172  1.00 47.07           C  
ATOM    322  C   ILE A 113      19.732  67.733  26.305  1.00 46.58           C  
ATOM    323  O   ILE A 113      20.926  67.978  26.122  1.00 47.29           O  
ATOM    324  CB  ILE A 113      18.990  66.734  24.144  1.00 46.42           C  
ATOM    325  CG1 ILE A 113      17.958  66.819  23.013  1.00 44.78           C  
ATOM    326  CG2 ILE A 113      18.900  65.378  24.820  1.00 45.46           C  
ATOM    327  CD1 ILE A 113      18.305  66.009  21.789  1.00 45.13           C  
ATOM    328  N   GLU A 114      19.230  67.383  27.486  1.00 46.26           N  
ATOM    329  CA  GLU A 114      20.083  67.185  28.647  1.00 45.37           C  
ATOM    330  C   GLU A 114      20.208  65.678  28.795  1.00 45.02           C  
ATOM    331  O   GLU A 114      19.201  64.962  28.775  1.00 45.62           O  
ATOM    332  CB  GLU A 114      19.461  67.780  29.916  1.00 43.61           C  
ATOM    333  CG  GLU A 114      20.351  67.626  31.132  1.00 48.88           C  
ATOM    334  CD  GLU A 114      19.703  68.120  32.408  1.00 64.19           C  
ATOM    335  OE1 GLU A 114      18.746  67.473  32.885  1.00 67.11           O  
ATOM    336  OE2 GLU A 114      20.153  69.163  32.933  1.00 71.97           O  
ATOM    337  N   VAL A 115      21.444  65.202  28.925  1.00 44.70           N  
ATOM    338  CA  VAL A 115      21.710  63.773  29.066  1.00 41.35           C  
ATOM    339  C   VAL A 115      22.644  63.512  30.250  1.00 42.80           C  
ATOM    340  O   VAL A 115      23.308  64.425  30.749  1.00 38.40           O  
ATOM    341  CB  VAL A 115      22.352  63.183  27.759  1.00 42.38           C  
ATOM    342  CG1 VAL A 115      21.449  63.441  26.560  1.00 39.01           C  
ATOM    343  CG2 VAL A 115      23.715  63.800  27.505  1.00 41.19           C  
ATOM    344  N   THR A 116      22.684  62.260  30.700  1.00 42.88           N  
ATOM    345  CA  THR A 116      23.532  61.869  31.814  1.00 42.77           C  
ATOM    346  C   THR A 116      24.256  60.578  31.478  1.00 39.88           C  
ATOM    347  O   THR A 116      23.663  59.655  30.928  1.00 37.29           O  
ATOM    348  CB  THR A 116      22.712  61.619  33.106  1.00 45.03           C  
ATOM    349  OG1 THR A 116      22.199  62.863  33.595  1.00 52.36           O  
ATOM    350  CG2 THR A 116      23.589  60.972  34.190  1.00 40.29           C  
HETATM  351  N   MSE A 117      25.542  60.535  31.812  1.00 39.07           N  
HETATM  352  CA  MSE A 117      26.381  59.365  31.599  1.00 38.73           C  
HETATM  353  C   MSE A 117      26.906  58.885  32.943  1.00 37.12           C  
HETATM  354  O   MSE A 117      27.462  59.665  33.719  1.00 36.26           O  
HETATM  355  CB  MSE A 117      27.588  59.688  30.707  1.00 37.35           C  
HETATM  356  CG  MSE A 117      27.265  59.822  29.238  1.00 45.15           C  
HETATM  357 SE   MSE A 117      28.786  60.294  28.124  1.00 57.00          SE  
HETATM  358  CE  MSE A 117      29.877  58.712  28.336  1.00 26.63           C  
ATOM    359  N   GLU A 118      26.732  57.600  33.218  1.00 36.02           N  
ATOM    360  CA  GLU A 118      27.226  57.037  34.458  1.00 35.22           C  
ATOM    361  C   GLU A 118      28.213  55.925  34.159  1.00 36.12           C  
ATOM    362  O   GLU A 118      27.871  54.925  33.512  1.00 38.58           O  
ATOM    363  CB  GLU A 118      26.077  56.481  35.301  1.00 35.98           C  
ATOM    364  CG  GLU A 118      26.516  55.664  36.514  1.00 34.80           C  
ATOM    365  CD  GLU A 118      25.321  55.173  37.332  1.00 51.27           C  
ATOM    366  OE1 GLU A 118      24.195  55.652  37.067  1.00 55.03           O  
ATOM    367  OE2 GLU A 118      25.502  54.322  38.235  1.00 43.47           O  
ATOM    368  N   ASN A 119      29.443  56.101  34.625  1.00 32.44           N  
ATOM    369  CA  ASN A 119      30.469  55.096  34.416  1.00 32.71           C  
ATOM    370  C   ASN A 119      30.273  53.980  35.436  1.00 32.86           C  
ATOM    371  O   ASN A 119      30.334  54.216  36.641  1.00 34.61           O  
ATOM    372  CB  ASN A 119      31.861  55.717  34.563  1.00 29.41           C  
ATOM    373  CG  ASN A 119      32.954  54.752  34.199  1.00 25.66           C  
ATOM    374  OD1 ASN A 119      34.136  55.102  34.171  1.00 40.80           O  
ATOM    375  ND2 ASN A 119      32.566  53.513  33.923  1.00 31.33           N  
ATOM    376  N   ILE A 120      30.024  52.771  34.934  1.00 35.96           N  
ATOM    377  CA  ILE A 120      29.804  51.585  35.760  1.00 30.40           C  
ATOM    378  C   ILE A 120      30.880  50.546  35.476  1.00 30.65           C  
ATOM    379  O   ILE A 120      30.737  49.369  35.799  1.00 31.15           O  
ATOM    380  CB  ILE A 120      28.409  50.956  35.497  1.00 33.01           C  
ATOM    381  CG1 ILE A 120      28.231  50.675  34.005  1.00 32.20           C  
ATOM    382  CG2 ILE A 120      27.300  51.896  35.990  1.00 22.19           C  
ATOM    383  CD1 ILE A 120      26.950  49.931  33.697  1.00 33.62           C  
ATOM    384  N   GLY A 121      31.954  50.990  34.839  1.00 31.70           N  
ATOM    385  CA  GLY A 121      33.059  50.096  34.556  1.00 29.37           C  
ATOM    386  C   GLY A 121      34.227  50.474  35.462  1.00 29.50           C  
ATOM    387  O   GLY A 121      34.150  51.458  36.203  1.00 28.84           O  
ATOM    388  N   GLU A 122      35.302  49.693  35.411  1.00 31.40           N  
ATOM    389  CA  GLU A 122      36.485  49.958  36.224  1.00 37.43           C  
ATOM    390  C   GLU A 122      37.354  51.073  35.639  1.00 37.30           C  
ATOM    391  O   GLU A 122      37.833  51.942  36.372  1.00 41.39           O  
ATOM    392  CB  GLU A 122      37.347  48.698  36.362  1.00 37.25           C  
ATOM    393  CG  GLU A 122      38.641  48.958  37.133  1.00 39.98           C  
ATOM    394  CD  GLU A 122      39.555  47.744  37.217  1.00 48.98           C  
ATOM    395  OE1 GLU A 122      39.365  46.786  36.431  1.00 52.23           O  
ATOM    396  OE2 GLU A 122      40.476  47.758  38.067  1.00 54.12           O  
ATOM    397  N   ASP A 123      37.568  51.042  34.326  1.00 38.86           N  
ATOM    398  CA  ASP A 123      38.387  52.058  33.665  1.00 38.98           C  
ATOM    399  C   ASP A 123      37.753  53.435  33.636  1.00 34.78           C  
ATOM    400  O   ASP A 123      36.533  53.569  33.572  1.00 36.76           O  
ATOM    401  CB  ASP A 123      38.670  51.687  32.211  1.00 40.57           C  
ATOM    402  CG  ASP A 123      39.293  50.334  32.062  1.00 48.75           C  
ATOM    403  OD1 ASP A 123      40.195  50.007  32.858  1.00 54.61           O  
ATOM    404  OD2 ASP A 123      38.886  49.607  31.138  1.00 63.81           O  
ATOM    405  N   SER A 124      38.596  54.461  33.655  1.00 33.25           N  
ATOM    406  CA  SER A 124      38.104  55.824  33.584  1.00 29.00           C  
ATOM    407  C   SER A 124      37.594  56.012  32.159  1.00 29.92           C  
ATOM    408  O   SER A 124      38.029  55.319  31.238  1.00 29.09           O  
ATOM    409  CB  SER A 124      39.226  56.819  33.869  1.00 30.71           C  
ATOM    410  OG  SER A 124      38.718  58.142  33.911  1.00 31.65           O  
ATOM    411  N   ILE A 125      36.668  56.945  31.991  1.00 30.10           N  
ATOM    412  CA  ILE A 125      36.089  57.230  30.695  1.00 29.68           C  
ATOM    413  C   ILE A 125      36.331  58.690  30.325  1.00 32.08           C  
ATOM    414  O   ILE A 125      36.101  59.592  31.139  1.00 31.11           O  
ATOM    415  CB  ILE A 125      34.549  56.969  30.688  1.00 31.50           C  
ATOM    416  CG1 ILE A 125      34.266  55.455  30.680  1.00 29.04           C  
ATOM    417  CG2 ILE A 125      33.893  57.676  29.470  1.00 27.36           C  
ATOM    418  CD1 ILE A 125      32.757  55.090  30.750  1.00 16.71           C  
ATOM    419  N   SER A 126      36.824  58.903  29.107  1.00 32.28           N  
ATOM    420  CA  SER A 126      37.059  60.241  28.571  1.00 33.77           C  
ATOM    421  C   SER A 126      35.897  60.447  27.605  1.00 33.98           C  
ATOM    422  O   SER A 126      35.990  60.091  26.421  1.00 37.71           O  
ATOM    423  CB  SER A 126      38.385  60.304  27.810  1.00 30.27           C  
ATOM    424  OG  SER A 126      39.484  60.105  28.676  1.00 31.19           O  
ATOM    425  N   TYR A 127      34.804  60.998  28.126  1.00 32.46           N  
ATOM    426  CA  TYR A 127      33.595  61.239  27.341  1.00 31.87           C  
ATOM    427  C   TYR A 127      33.798  62.383  26.372  1.00 32.35           C  
ATOM    428  O   TYR A 127      34.559  63.306  26.651  1.00 28.95           O  
ATOM    429  CB  TYR A 127      32.396  61.505  28.267  1.00 30.56           C  
ATOM    430  CG  TYR A 127      32.444  62.797  29.053  1.00 30.68           C  
ATOM    431  CD1 TYR A 127      31.920  63.978  28.519  1.00 34.50           C  
ATOM    432  CD2 TYR A 127      32.990  62.837  30.338  1.00 30.75           C  
ATOM    433  CE1 TYR A 127      31.916  65.166  29.258  1.00 35.06           C  
ATOM    434  CE2 TYR A 127      32.996  64.013  31.085  1.00 26.90           C  
ATOM    435  CZ  TYR A 127      32.464  65.181  30.541  1.00 35.89           C  
ATOM    436  OH  TYR A 127      32.467  66.353  31.275  1.00 40.00           O  
ATOM    437  N   ASN A 128      33.102  62.327  25.241  1.00 33.22           N  
ATOM    438  CA  ASN A 128      33.273  63.338  24.209  1.00 30.19           C  
ATOM    439  C   ASN A 128      32.004  63.572  23.387  1.00 29.98           C  
ATOM    440  O   ASN A 128      31.240  62.645  23.137  1.00 28.42           O  
ATOM    441  CB  ASN A 128      34.411  62.864  23.309  1.00 28.37           C  
ATOM    442  CG  ASN A 128      35.041  63.970  22.520  1.00 25.87           C  
ATOM    443  OD1 ASN A 128      34.450  64.495  21.575  1.00 26.98           O  
ATOM    444  ND2 ASN A 128      36.266  64.330  22.893  1.00 20.28           N  
ATOM    445  N   PHE A 129      31.797  64.811  22.944  1.00 32.70           N  
ATOM    446  CA  PHE A 129      30.613  65.145  22.159  1.00 30.49           C  
ATOM    447  C   PHE A 129      30.476  64.329  20.871  1.00 30.20           C  
ATOM    448  O   PHE A 129      29.358  64.083  20.422  1.00 31.91           O  
ATOM    449  CB  PHE A 129      30.572  66.659  21.857  1.00 31.74           C  
ATOM    450  CG  PHE A 129      31.470  67.099  20.730  1.00 27.95           C  
ATOM    451  CD1 PHE A 129      30.984  67.170  19.428  1.00 32.22           C  
ATOM    452  CD2 PHE A 129      32.800  67.446  20.967  1.00 27.08           C  
ATOM    453  CE1 PHE A 129      31.809  67.583  18.369  1.00 29.12           C  
ATOM    454  CE2 PHE A 129      33.637  67.857  19.918  1.00 23.20           C  
ATOM    455  CZ  PHE A 129      33.138  67.926  18.616  1.00 29.67           C  
ATOM    456  N   ILE A 130      31.586  63.874  20.296  1.00 28.04           N  
ATOM    457  CA  ILE A 130      31.506  63.100  19.053  1.00 30.66           C  
ATOM    458  C   ILE A 130      30.713  61.804  19.180  1.00 27.96           C  
ATOM    459  O   ILE A 130      30.352  61.188  18.180  1.00 28.15           O  
ATOM    460  CB  ILE A 130      32.910  62.738  18.486  1.00 28.81           C  
ATOM    461  CG1 ILE A 130      33.695  61.905  19.509  1.00 26.94           C  
ATOM    462  CG2 ILE A 130      33.659  64.028  18.092  1.00 26.35           C  
ATOM    463  CD1 ILE A 130      34.945  61.248  18.939  1.00 17.64           C  
ATOM    464  N   GLY A 131      30.433  61.392  20.406  1.00 27.72           N  
ATOM    465  CA  GLY A 131      29.697  60.161  20.591  1.00 30.73           C  
ATOM    466  C   GLY A 131      28.210  60.358  20.412  1.00 26.25           C  
ATOM    467  O   GLY A 131      27.433  59.421  20.577  1.00 30.66           O  
ATOM    468  N   PHE A 132      27.814  61.570  20.057  1.00 31.98           N  
ATOM    469  CA  PHE A 132      26.408  61.885  19.896  1.00 34.78           C  
ATOM    470  C   PHE A 132      25.992  62.333  18.507  1.00 34.25           C  
ATOM    471  O   PHE A 132      26.782  62.910  17.762  1.00 37.34           O  
ATOM    472  CB  PHE A 132      26.016  62.961  20.904  1.00 31.08           C  
ATOM    473  CG  PHE A 132      26.173  62.525  22.321  1.00 32.47           C  
ATOM    474  CD1 PHE A 132      27.339  62.798  23.025  1.00 29.52           C  
ATOM    475  CD2 PHE A 132      25.173  61.787  22.933  1.00 27.58           C  
ATOM    476  CE1 PHE A 132      27.514  62.339  24.321  1.00 36.64           C  
ATOM    477  CE2 PHE A 132      25.334  61.319  24.234  1.00 35.44           C  
ATOM    478  CZ  PHE A 132      26.507  61.595  24.932  1.00 37.48           C  
ATOM    479  N   ASP A 133      24.737  62.080  18.169  1.00 36.09           N  
ATOM    480  CA  ASP A 133      24.225  62.457  16.867  1.00 41.09           C  
ATOM    481  C   ASP A 133      22.703  62.460  16.862  1.00 42.47           C  
ATOM    482  O   ASP A 133      22.069  61.638  17.527  1.00 43.39           O  
ATOM    483  CB  ASP A 133      24.763  61.493  15.807  1.00 40.16           C  
ATOM    484  CG  ASP A 133      24.386  61.899  14.403  1.00 44.46           C  
ATOM    485  OD1 ASP A 133      24.223  63.114  14.165  1.00 53.90           O  
ATOM    486  OD2 ASP A 133      24.270  61.013  13.530  1.00 43.17           O  
ATOM    487  N   LEU A 134      22.130  63.408  16.128  1.00 45.17           N  
ATOM    488  CA  LEU A 134      20.681  63.539  16.007  1.00 44.97           C  
ATOM    489  C   LEU A 134      20.303  63.220  14.565  1.00 47.64           C  
ATOM    490  O   LEU A 134      20.877  63.773  13.625  1.00 48.05           O  
ATOM    491  CB  LEU A 134      20.242  64.964  16.349  1.00 43.66           C  
ATOM    492  CG  LEU A 134      18.773  65.177  16.724  1.00 48.31           C  
ATOM    493  CD1 LEU A 134      18.511  64.597  18.117  1.00 45.01           C  
ATOM    494  CD2 LEU A 134      18.457  66.670  16.700  1.00 43.92           C  
ATOM    495  N   ARG A 135      19.342  62.323  14.390  1.00 50.01           N  
ATOM    496  CA  ARG A 135      18.912  61.936  13.056  1.00 54.27           C  
ATOM    497  C   ARG A 135      17.447  62.311  12.770  1.00 56.22           C  
ATOM    498  O   ARG A 135      16.641  62.465  13.692  1.00 54.44           O  
ATOM    499  CB  ARG A 135      19.141  60.425  12.874  1.00 53.15           C  
ATOM    500  CG  ARG A 135      20.622  60.041  12.898  1.00 54.02           C  
ATOM    501  CD  ARG A 135      20.863  58.534  12.898  1.00 56.10           C  
ATOM    502  NE  ARG A 135      22.279  58.236  13.111  1.00 59.42           N  
ATOM    503  CZ  ARG A 135      22.750  57.069  13.548  1.00 62.02           C  
ATOM    504  NH1 ARG A 135      21.912  56.077  13.818  1.00 62.00           N  
ATOM    505  NH2 ARG A 135      24.057  56.902  13.738  1.00 50.16           N  
ATOM    506  N   ASP A 136      17.126  62.468  11.484  1.00 61.38           N  
ATOM    507  CA  ASP A 136      15.775  62.815  11.009  1.00 63.04           C  
ATOM    508  C   ASP A 136      14.934  61.559  10.842  1.00 64.81           C  
ATOM    509  O   ASP A 136      15.354  60.458  11.194  1.00 64.59           O  
ATOM    510  CB  ASP A 136      15.823  63.459   9.613  1.00 63.74           C  
ATOM    511  CG  ASP A 136      16.412  64.845   9.611  1.00 66.30           C  
ATOM    512  OD1 ASP A 136      16.273  65.541  10.639  1.00 71.21           O  
ATOM    513  OD2 ASP A 136      16.989  65.247   8.575  1.00 65.58           O  
ATOM    514  N   LYS A 137      13.739  61.743  10.280  1.00 68.79           N  
ATOM    515  CA  LYS A 137      12.866  60.619   9.983  1.00 71.00           C  
ATOM    516  C   LYS A 137      13.582  59.968   8.792  1.00 72.48           C  
ATOM    517  O   LYS A 137      13.491  58.757   8.591  1.00 74.59           O  
ATOM    518  CB  LYS A 137      11.467  61.097   9.574  1.00 72.55           C  
ATOM    519  CG  LYS A 137      10.420  59.987   9.418  1.00 71.19           C  
ATOM    520  CD  LYS A 137      10.552  59.237   8.098  1.00 76.91           C  
ATOM    521  CE  LYS A 137       9.286  58.439   7.791  1.00 78.51           C  
ATOM    522  NZ  LYS A 137       9.330  57.813   6.440  1.00 77.58           N  
ATOM    523  N   ASN A 138      14.307  60.775   8.011  1.00 72.23           N  
ATOM    524  CA  ASN A 138      15.054  60.246   6.866  1.00 73.83           C  
ATOM    525  C   ASN A 138      16.458  59.796   7.320  1.00 74.42           C  
ATOM    526  O   ASN A 138      17.365  59.604   6.502  1.00 76.57           O  
ATOM    527  CB  ASN A 138      15.177  61.288   5.743  1.00 73.37           C  
ATOM    528  CG  ASN A 138      13.900  62.086   5.536  1.00 75.53           C  
ATOM    529  OD1 ASN A 138      12.799  61.537   5.522  1.00 66.89           O  
ATOM    530  ND2 ASN A 138      14.049  63.392   5.364  1.00 79.18           N  
ATOM    531  N   ASP A 139      16.621  59.648   8.637  1.00 72.40           N  
ATOM    532  CA  ASP A 139      17.870  59.201   9.262  1.00 69.87           C  
ATOM    533  C   ASP A 139      19.125  59.980   8.869  1.00 66.56           C  
ATOM    534  O   ASP A 139      20.172  59.396   8.577  1.00 63.41           O  
ATOM    535  CB  ASP A 139      18.083  57.712   8.971  1.00 70.78           C  
ATOM    536  CG  ASP A 139      19.083  57.069   9.916  1.00 79.15           C  
ATOM    537  OD1 ASP A 139      18.873  57.161  11.146  1.00 87.44           O  
ATOM    538  OD2 ASP A 139      20.071  56.467   9.438  1.00 84.55           O  
ATOM    539  N   GLN A 140      19.019  61.304   8.884  1.00 65.56           N  
ATOM    540  CA  GLN A 140      20.140  62.158   8.529  1.00 64.42           C  
ATOM    541  C   GLN A 140      20.604  62.980   9.722  1.00 61.25           C  
ATOM    542  O   GLN A 140      19.797  63.494  10.493  1.00 60.04           O  
ATOM    543  CB  GLN A 140      19.756  63.082   7.372  1.00 67.20           C  
ATOM    544  CG  GLN A 140      20.950  63.806   6.787  1.00 71.53           C  
ATOM    545  CD  GLN A 140      20.610  64.597   5.548  1.00 77.60           C  
ATOM    546  OE1 GLN A 140      19.755  65.483   5.580  1.00 81.80           O  
ATOM    547  NE2 GLN A 140      21.282  64.285   4.445  1.00 77.54           N  
ATOM    548  N   SER A 141      21.916  63.106   9.862  1.00 57.88           N  
ATOM    549  CA  SER A 141      22.495  63.840  10.972  1.00 55.44           C  
ATOM    550  C   SER A 141      22.191  65.330  10.951  1.00 54.54           C  
ATOM    551  O   SER A 141      22.094  65.944   9.891  1.00 57.30           O  
ATOM    552  CB  SER A 141      24.013  63.643  10.993  1.00 54.31           C  
ATOM    553  OG  SER A 141      24.353  62.268  10.991  1.00 55.92           O  
ATOM    554  N   VAL A 142      22.036  65.897  12.142  1.00 52.69           N  
ATOM    555  CA  VAL A 142      21.787  67.318  12.295  1.00 52.75           C  
ATOM    556  C   VAL A 142      22.982  67.881  13.059  1.00 54.57           C  
ATOM    557  O   VAL A 142      23.278  67.447  14.168  1.00 56.56           O  
ATOM    558  CB  VAL A 142      20.492  67.595  13.098  1.00 55.43           C  
ATOM    559  CG1 VAL A 142      20.278  69.104  13.238  1.00 47.41           C  
ATOM    560  CG2 VAL A 142      19.299  66.945  12.408  1.00 49.59           C  
ATOM    561  N   ARG A 143      23.674  68.835  12.450  1.00 56.35           N  
ATOM    562  CA  ARG A 143      24.846  69.462  13.055  1.00 57.00           C  
ATOM    563  C   ARG A 143      24.621  69.865  14.515  1.00 55.35           C  
ATOM    564  O   ARG A 143      23.579  70.413  14.852  1.00 56.57           O  
ATOM    565  CB  ARG A 143      25.243  70.716  12.266  1.00 56.07           C  
ATOM    566  CG  ARG A 143      25.728  70.496  10.819  1.00 65.61           C  
ATOM    567  CD  ARG A 143      24.588  70.165   9.846  1.00 68.81           C  
ATOM    568  NE  ARG A 143      23.399  70.960  10.138  1.00 69.08           N  
ATOM    569  CZ  ARG A 143      22.154  70.514  10.014  1.00 65.80           C  
ATOM    570  NH1 ARG A 143      21.131  71.305  10.308  1.00 65.57           N  
ATOM    571  NH2 ARG A 143      21.928  69.277   9.591  1.00 68.73           N  
ATOM    572  N   PRO A 144      25.595  69.596  15.402  1.00 54.43           N  
ATOM    573  CA  PRO A 144      25.436  69.969  16.813  1.00 54.49           C  
ATOM    574  C   PRO A 144      25.636  71.475  16.985  1.00 54.91           C  
ATOM    575  O   PRO A 144      26.388  72.100  16.240  1.00 52.79           O  
ATOM    576  CB  PRO A 144      26.509  69.143  17.514  1.00 52.50           C  
ATOM    577  CG  PRO A 144      27.579  69.054  16.485  1.00 50.24           C  
ATOM    578  CD  PRO A 144      26.813  68.789  15.208  1.00 53.95           C  
ATOM    579  N   VAL A 145      24.977  72.055  17.974  1.00 56.54           N  
ATOM    580  CA  VAL A 145      25.062  73.492  18.208  1.00 58.92           C  
ATOM    581  C   VAL A 145      25.228  73.780  19.695  1.00 61.16           C  
ATOM    582  O   VAL A 145      25.067  72.887  20.521  1.00 63.28           O  
ATOM    583  CB  VAL A 145      23.733  74.183  17.719  1.00 58.97           C  
ATOM    584  CG1 VAL A 145      23.393  75.377  18.594  1.00 58.51           C  
ATOM    585  CG2 VAL A 145      23.854  74.606  16.259  1.00 53.67           C  
ATOM    586  N   PHE A 146      25.588  75.015  20.034  1.00 65.63           N  
ATOM    587  CA  PHE A 146      25.659  75.411  21.436  1.00 69.49           C  
ATOM    588  C   PHE A 146      25.295  76.877  21.631  1.00 71.05           C  
ATOM    589  O   PHE A 146      25.618  77.733  20.804  1.00 71.04           O  
ATOM    590  CB  PHE A 146      27.023  75.123  22.082  1.00 69.71           C  
ATOM    591  CG  PHE A 146      28.162  75.920  21.527  1.00 71.15           C  
ATOM    592  CD1 PHE A 146      28.652  75.651  20.258  1.00 70.73           C  
ATOM    593  CD2 PHE A 146      28.792  76.894  22.300  1.00 70.34           C  
ATOM    594  CE1 PHE A 146      29.755  76.329  19.761  1.00 69.70           C  
ATOM    595  CE2 PHE A 146      29.899  77.582  21.812  1.00 74.42           C  
ATOM    596  CZ  PHE A 146      30.382  77.296  20.538  1.00 73.28           C  
ATOM    597  N   SER A 147      24.581  77.155  22.715  1.00 73.80           N  
ATOM    598  CA  SER A 147      24.197  78.524  23.015  1.00 76.03           C  
ATOM    599  C   SER A 147      24.925  78.984  24.263  1.00 76.73           C  
ATOM    600  O   SER A 147      25.220  78.190  25.157  1.00 77.57           O  
ATOM    601  CB  SER A 147      22.684  78.657  23.225  1.00 77.36           C  
ATOM    602  OG  SER A 147      22.315  80.028  23.319  1.00 79.98           O  
ATOM    603  N   ILE A 148      25.214  80.279  24.305  1.00 78.37           N  
ATOM    604  CA  ILE A 148      25.917  80.901  25.415  1.00 79.88           C  
ATOM    605  C   ILE A 148      25.081  80.791  26.690  1.00 80.19           C  
ATOM    606  O   ILE A 148      25.596  80.942  27.799  1.00 79.72           O  
ATOM    607  CB  ILE A 148      26.177  82.403  25.114  1.00 81.45           C  
ATOM    608  CG1 ILE A 148      26.727  82.563  23.690  1.00 84.00           C  
ATOM    609  CG2 ILE A 148      27.134  82.994  26.139  1.00 78.46           C  
ATOM    610  CD1 ILE A 148      25.655  82.561  22.600  1.00 83.39           C  
ATOM    611  N   GLU A 149      23.790  80.522  26.521  1.00 80.09           N  
ATOM    612  CA  GLU A 149      22.879  80.409  27.652  1.00 81.31           C  
ATOM    613  C   GLU A 149      23.199  79.229  28.564  1.00 81.59           C  
ATOM    614  O   GLU A 149      23.435  79.415  29.760  1.00 82.46           O  
ATOM    615  CB  GLU A 149      21.435  80.323  27.151  1.00 82.20           C  
ATOM    616  CG  GLU A 149      20.975  81.564  26.392  1.00 83.31           C  
ATOM    617  CD  GLU A 149      19.572  81.425  25.839  1.00 83.85           C  
ATOM    618  OE1 GLU A 149      18.617  81.366  26.642  1.00 87.72           O  
ATOM    619  OE2 GLU A 149      19.425  81.366  24.601  1.00 83.33           O  
ATOM    620  N   GLU A 150      23.218  78.020  28.012  1.00 82.08           N  
ATOM    621  CA  GLU A 150      23.519  76.838  28.813  1.00 81.54           C  
ATOM    622  C   GLU A 150      25.019  76.795  29.132  1.00 80.79           C  
ATOM    623  O   GLU A 150      25.667  75.755  28.988  1.00 80.89           O  
ATOM    624  CB  GLU A 150      23.103  75.563  28.068  1.00 82.11           C  
ATOM    625  CG  GLU A 150      21.840  75.695  27.228  1.00 79.89           C  
ATOM    626  CD  GLU A 150      22.091  76.449  25.937  1.00 83.86           C  
ATOM    627  OE1 GLU A 150      22.949  76.000  25.148  1.00 88.46           O  
ATOM    628  OE2 GLU A 150      21.434  77.486  25.710  1.00 87.83           O  
ATOM    629  N   LYS A 151      25.563  77.934  29.555  1.00 79.70           N  
ATOM    630  CA  LYS A 151      26.978  78.043  29.905  1.00 79.29           C  
ATOM    631  C   LYS A 151      27.262  77.154  31.116  1.00 78.33           C  
ATOM    632  O   LYS A 151      26.565  77.230  32.131  1.00 78.58           O  
ATOM    633  CB  LYS A 151      27.331  79.499  30.211  1.00 80.64           C  
ATOM    634  N   GLY A 152      28.286  76.311  30.994  1.00 77.11           N  
ATOM    635  CA  GLY A 152      28.643  75.398  32.065  1.00 74.10           C  
ATOM    636  C   GLY A 152      27.929  74.060  31.933  1.00 71.28           C  
ATOM    637  O   GLY A 152      28.281  73.091  32.608  1.00 71.21           O  
ATOM    638  N   ARG A 153      26.929  73.998  31.058  1.00 67.98           N  
ATOM    639  CA  ARG A 153      26.160  72.769  30.859  1.00 64.87           C  
ATOM    640  C   ARG A 153      26.478  72.079  29.533  1.00 62.04           C  
ATOM    641  O   ARG A 153      26.223  70.884  29.371  1.00 59.67           O  
ATOM    642  CB  ARG A 153      24.656  73.071  30.915  1.00 65.03           C  
ATOM    643  CG  ARG A 153      24.163  73.677  32.227  1.00 66.71           C  
ATOM    644  CD  ARG A 153      22.708  74.133  32.102  1.00 69.83           C  
ATOM    645  NE  ARG A 153      21.783  73.008  31.988  1.00 63.98           N  
ATOM    646  CZ  ARG A 153      20.666  73.018  31.263  1.00 64.21           C  
ATOM    647  NH1 ARG A 153      20.325  74.097  30.569  1.00 65.43           N  
ATOM    648  NH2 ARG A 153      19.885  71.946  31.233  1.00 63.50           N  
ATOM    649  N   ILE A 154      27.025  72.838  28.589  1.00 59.54           N  
ATOM    650  CA  ILE A 154      27.373  72.311  27.274  1.00 58.71           C  
ATOM    651  C   ILE A 154      28.273  71.082  27.391  1.00 55.51           C  
ATOM    652  O   ILE A 154      29.380  71.169  27.925  1.00 56.78           O  
ATOM    653  CB  ILE A 154      28.109  73.375  26.429  1.00 58.32           C  
ATOM    654  CG1 ILE A 154      27.263  74.651  26.330  1.00 64.59           C  
ATOM    655  CG2 ILE A 154      28.400  72.822  25.044  1.00 62.77           C  
ATOM    656  CD1 ILE A 154      25.901  74.460  25.676  1.00 67.94           C  
ATOM    657  N   LEU A 155      27.797  69.942  26.892  1.00 49.40           N  
ATOM    658  CA  LEU A 155      28.568  68.701  26.946  1.00 50.42           C  
ATOM    659  C   LEU A 155      29.701  68.745  25.922  1.00 49.93           C  
ATOM    660  O   LEU A 155      29.457  68.789  24.717  1.00 53.71           O  
ATOM    661  CB  LEU A 155      27.655  67.502  26.660  1.00 49.99           C  
ATOM    662  CG  LEU A 155      28.230  66.091  26.830  1.00 47.05           C  
ATOM    663  CD1 LEU A 155      27.103  65.078  26.715  1.00 45.65           C  
ATOM    664  CD2 LEU A 155      29.294  65.818  25.782  1.00 45.89           C  
HETATM  665  N   MSE A 156      30.940  68.711  26.393  1.00 47.40           N  
HETATM  666  CA  MSE A 156      32.066  68.775  25.476  1.00 46.74           C  
HETATM  667  C   MSE A 156      32.968  67.549  25.566  1.00 43.23           C  
HETATM  668  O   MSE A 156      33.025  66.737  24.637  1.00 42.42           O  
HETATM  669  CB  MSE A 156      32.866  70.042  25.765  1.00 48.85           C  
HETATM  670  CG  MSE A 156      33.266  70.811  24.539  1.00 62.01           C  
HETATM  671 SE   MSE A 156      31.745  71.340  23.429  1.00 98.38          SE  
HETATM  672  CE  MSE A 156      31.506  73.121  24.137  1.00 88.51           C  
ATOM    673  N   GLY A 157      33.670  67.431  26.687  1.00 40.50           N  
ATOM    674  CA  GLY A 157      34.562  66.313  26.913  1.00 38.03           C  
ATOM    675  C   GLY A 157      35.106  66.400  28.323  1.00 37.82           C  
ATOM    676  O   GLY A 157      34.985  67.439  28.967  1.00 38.80           O  
ATOM    677  N   GLY A 158      35.694  65.313  28.808  1.00 39.74           N  
ATOM    678  CA  GLY A 158      36.260  65.308  30.141  1.00 38.12           C  
ATOM    679  C   GLY A 158      36.447  63.885  30.629  1.00 37.74           C  
ATOM    680  O   GLY A 158      36.209  62.937  29.879  1.00 38.79           O  
ATOM    681  N   THR A 159      36.884  63.724  31.876  1.00 38.26           N  
ATOM    682  CA  THR A 159      37.069  62.395  32.418  1.00 40.91           C  
ATOM    683  C   THR A 159      35.930  62.101  33.399  1.00 39.56           C  
ATOM    684  O   THR A 159      35.437  62.988  34.098  1.00 35.91           O  
ATOM    685  CB  THR A 159      38.479  62.229  33.094  1.00 42.87           C  
ATOM    686  OG1 THR A 159      38.398  62.494  34.499  1.00 48.04           O  
ATOM    687  CG2 THR A 159      39.489  63.187  32.460  1.00 42.87           C  
ATOM    688  N   LEU A 160      35.500  60.844  33.393  1.00 40.36           N  
ATOM    689  CA  LEU A 160      34.421  60.336  34.234  1.00 39.37           C  
ATOM    690  C   LEU A 160      34.974  59.063  34.860  1.00 41.04           C  
ATOM    691  O   LEU A 160      34.961  57.992  34.251  1.00 36.04           O  
ATOM    692  CB  LEU A 160      33.194  60.020  33.368  1.00 41.04           C  
ATOM    693  CG  LEU A 160      31.884  59.626  34.065  1.00 44.86           C  
ATOM    694  CD1 LEU A 160      31.422  60.755  34.991  1.00 42.20           C  
ATOM    695  CD2 LEU A 160      30.814  59.329  33.021  1.00 37.32           C  
ATOM    696  N   VAL A 161      35.489  59.187  36.076  1.00 41.71           N  
ATOM    697  CA  VAL A 161      36.062  58.043  36.762  1.00 42.48           C  
ATOM    698  C   VAL A 161      34.976  57.054  37.159  1.00 41.42           C  
ATOM    699  O   VAL A 161      33.803  57.410  37.265  1.00 40.54           O  
ATOM    700  CB  VAL A 161      36.870  58.513  37.982  1.00 46.81           C  
ATOM    701  CG1 VAL A 161      37.449  57.316  38.740  1.00 47.77           C  
ATOM    702  CG2 VAL A 161      37.996  59.426  37.505  1.00 43.90           C  
ATOM    703  N   SER A 162      35.376  55.804  37.359  1.00 42.05           N  
ATOM    704  CA  SER A 162      34.450  54.732  37.721  1.00 44.02           C  
ATOM    705  C   SER A 162      33.461  55.116  38.807  1.00 44.46           C  
ATOM    706  O   SER A 162      33.837  55.698  39.817  1.00 47.00           O  
ATOM    707  CB  SER A 162      35.231  53.506  38.173  1.00 45.98           C  
ATOM    708  OG  SER A 162      34.361  52.548  38.726  1.00 53.12           O  
ATOM    709  N   GLY A 163      32.192  54.788  38.586  1.00 43.54           N  
ATOM    710  CA  GLY A 163      31.158  55.097  39.554  1.00 40.81           C  
ATOM    711  C   GLY A 163      30.575  56.496  39.478  1.00 44.59           C  
ATOM    712  O   GLY A 163      29.539  56.766  40.086  1.00 43.58           O  
ATOM    713  N   LYS A 164      31.204  57.389  38.724  1.00 45.13           N  
ATOM    714  CA  LYS A 164      30.703  58.755  38.644  1.00 48.49           C  
ATOM    715  C   LYS A 164      29.782  59.089  37.472  1.00 49.85           C  
ATOM    716  O   LYS A 164      29.801  58.434  36.430  1.00 50.12           O  
ATOM    717  CB  LYS A 164      31.887  59.728  38.658  1.00 51.02           C  
ATOM    718  CG  LYS A 164      31.815  60.761  39.770  1.00 55.23           C  
ATOM    719  CD  LYS A 164      33.183  61.036  40.398  1.00 59.99           C  
ATOM    720  CE  LYS A 164      33.635  59.891  41.304  1.00 60.66           C  
ATOM    721  NZ  LYS A 164      34.662  60.349  42.283  1.00 58.64           N  
ATOM    722  N   LYS A 165      28.972  60.126  37.665  1.00 49.41           N  
ATOM    723  CA  LYS A 165      28.042  60.577  36.646  1.00 46.61           C  
ATOM    724  C   LYS A 165      28.440  61.955  36.156  1.00 47.44           C  
ATOM    725  O   LYS A 165      29.174  62.684  36.827  1.00 51.53           O  
ATOM    726  CB  LYS A 165      26.623  60.680  37.205  1.00 49.01           C  
ATOM    727  CG  LYS A 165      26.001  59.381  37.674  1.00 47.56           C  
ATOM    728  CD  LYS A 165      24.553  59.626  38.088  1.00 52.99           C  
ATOM    729  CE  LYS A 165      23.861  58.350  38.518  1.00 56.38           C  
ATOM    730  NZ  LYS A 165      22.463  58.631  38.955  1.00 62.63           N  
ATOM    731  N   VAL A 166      27.950  62.303  34.972  1.00 45.81           N  
ATOM    732  CA  VAL A 166      28.193  63.609  34.390  1.00 43.89           C  
ATOM    733  C   VAL A 166      26.913  63.964  33.628  1.00 42.08           C  
ATOM    734  O   VAL A 166      26.332  63.124  32.941  1.00 42.55           O  
ATOM    735  CB  VAL A 166      29.464  63.609  33.475  1.00 44.56           C  
ATOM    736  CG1 VAL A 166      29.346  62.563  32.381  1.00 47.24           C  
ATOM    737  CG2 VAL A 166      29.682  64.998  32.884  1.00 44.15           C  
ATOM    738  N   THR A 167      26.441  65.193  33.797  1.00 42.94           N  
ATOM    739  CA  THR A 167      25.222  65.626  33.126  1.00 43.50           C  
ATOM    740  C   THR A 167      25.537  66.863  32.300  1.00 44.11           C  
ATOM    741  O   THR A 167      26.247  67.761  32.758  1.00 41.52           O  
ATOM    742  CB  THR A 167      24.086  65.924  34.151  1.00 43.79           C  
ATOM    743  OG1 THR A 167      23.888  64.781  34.997  1.00 46.91           O  
ATOM    744  CG2 THR A 167      22.775  66.216  33.431  1.00 46.03           C  
ATOM    745  N   GLY A 168      25.020  66.891  31.074  1.00 42.71           N  
ATOM    746  CA  GLY A 168      25.278  68.002  30.177  1.00 42.33           C  
ATOM    747  C   GLY A 168      24.249  68.122  29.071  1.00 42.74           C  
ATOM    748  O   GLY A 168      23.326  67.311  28.972  1.00 42.43           O  
ATOM    749  N   VAL A 169      24.412  69.122  28.214  1.00 43.07           N  
ATOM    750  CA  VAL A 169      23.444  69.335  27.157  1.00 45.67           C  
ATOM    751  C   VAL A 169      23.990  69.281  25.730  1.00 44.74           C  
ATOM    752  O   VAL A 169      25.160  69.574  25.486  1.00 43.19           O  
ATOM    753  CB  VAL A 169      22.705  70.701  27.383  1.00 46.82           C  
ATOM    754  CG1 VAL A 169      21.925  70.658  28.711  1.00 48.24           C  
ATOM    755  CG2 VAL A 169      23.712  71.855  27.417  1.00 50.30           C  
ATOM    756  N   LEU A 170      23.122  68.866  24.806  1.00 44.66           N  
ATOM    757  CA  LEU A 170      23.416  68.784  23.375  1.00 44.79           C  
ATOM    758  C   LEU A 170      22.396  69.737  22.763  1.00 47.01           C  
ATOM    759  O   LEU A 170      21.294  69.872  23.291  1.00 48.10           O  
ATOM    760  CB  LEU A 170      23.166  67.369  22.828  1.00 42.10           C  
ATOM    761  CG  LEU A 170      24.209  66.254  22.931  1.00 38.61           C  
ATOM    762  CD1 LEU A 170      25.165  66.522  24.068  1.00 42.82           C  
ATOM    763  CD2 LEU A 170      23.491  64.921  23.126  1.00 32.42           C  
ATOM    764  N   SER A 171      22.740  70.393  21.659  1.00 51.26           N  
ATOM    765  CA  SER A 171      21.808  71.330  21.043  1.00 53.11           C  
ATOM    766  C   SER A 171      21.782  71.247  19.521  1.00 54.70           C  
ATOM    767  O   SER A 171      22.813  71.036  18.878  1.00 55.95           O  
ATOM    768  CB  SER A 171      22.146  72.758  21.484  1.00 53.07           C  
ATOM    769  OG  SER A 171      20.993  73.585  21.467  1.00 56.07           O  
ATOM    770  N   TYR A 172      20.590  71.420  18.955  1.00 55.31           N  
ATOM    771  CA  TYR A 172      20.395  71.345  17.510  1.00 56.69           C  
ATOM    772  C   TYR A 172      19.281  72.279  17.054  1.00 57.89           C  
ATOM    773  O   TYR A 172      18.350  72.566  17.805  1.00 57.76           O  
ATOM    774  CB  TYR A 172      20.010  69.921  17.118  1.00 57.30           C  
ATOM    775  CG  TYR A 172      20.950  68.860  17.622  1.00 56.22           C  
ATOM    776  CD1 TYR A 172      22.026  68.431  16.847  1.00 54.11           C  
ATOM    777  CD2 TYR A 172      20.767  68.285  18.880  1.00 53.71           C  
ATOM    778  CE1 TYR A 172      22.900  67.455  17.312  1.00 44.41           C  
ATOM    779  CE2 TYR A 172      21.638  67.306  19.357  1.00 55.46           C  
ATOM    780  CZ  TYR A 172      22.702  66.898  18.568  1.00 47.88           C  
ATOM    781  OH  TYR A 172      23.581  65.958  19.041  1.00 41.06           O  
ATOM    782  N   VAL A 173      19.375  72.736  15.811  1.00 61.32           N  
ATOM    783  CA  VAL A 173      18.372  73.619  15.239  1.00 62.53           C  
ATOM    784  C   VAL A 173      17.520  72.826  14.259  1.00 65.18           C  
ATOM    785  O   VAL A 173      18.036  72.191  13.337  1.00 65.08           O  
ATOM    786  CB  VAL A 173      19.030  74.802  14.526  1.00 61.79           C  
ATOM    787  CG1 VAL A 173      19.670  75.721  15.557  1.00 62.48           C  
ATOM    788  CG2 VAL A 173      20.081  74.302  13.544  1.00 60.76           C  
ATOM    789  N   ILE A 174      16.209  72.856  14.474  1.00 67.56           N  
ATOM    790  CA  ILE A 174      15.286  72.122  13.624  1.00 70.27           C  
ATOM    791  C   ILE A 174      13.998  72.910  13.370  1.00 71.17           C  
ATOM    792  O   ILE A 174      13.758  73.947  13.991  1.00 72.37           O  
ATOM    793  CB  ILE A 174      14.905  70.752  14.265  1.00 71.18           C  
ATOM    794  CG1 ILE A 174      14.034  70.969  15.507  1.00 69.41           C  
ATOM    795  CG2 ILE A 174      16.166  69.977  14.622  1.00 68.95           C  
ATOM    796  CD1 ILE A 174      13.181  69.761  15.880  1.00 65.43           C  
ATOM    797  N   PRO A 175      13.156  72.423  12.443  1.00 71.60           N  
ATOM    798  CA  PRO A 175      11.880  73.052  12.080  1.00 71.43           C  
ATOM    799  C   PRO A 175      10.944  73.187  13.286  1.00 70.52           C  
ATOM    800  O   PRO A 175      10.880  72.294  14.130  1.00 71.62           O  
ATOM    801  CB  PRO A 175      11.307  72.097  11.039  1.00 71.43           C  
ATOM    802  CG  PRO A 175      12.515  71.476  10.425  1.00 72.08           C  
ATOM    803  CD  PRO A 175      13.428  71.251  11.591  1.00 70.75           C  
ATOM    804  N   LYS A 176      10.207  74.290  13.352  1.00 69.73           N  
ATOM    805  CA  LYS A 176       9.282  74.529  14.457  1.00 69.42           C  
ATOM    806  C   LYS A 176       8.394  73.325  14.782  1.00 69.26           C  
ATOM    807  O   LYS A 176       7.843  72.683  13.885  1.00 67.64           O  
ATOM    808  CB  LYS A 176       8.410  75.745  14.152  1.00 69.55           C  
ATOM    809  N   GLY A 177       8.267  73.034  16.077  1.00 70.23           N  
ATOM    810  CA  GLY A 177       7.449  71.926  16.546  1.00 70.09           C  
ATOM    811  C   GLY A 177       7.572  70.636  15.758  1.00 70.26           C  
ATOM    812  O   GLY A 177       6.591  69.914  15.575  1.00 69.70           O  
ATOM    813  N   GLU A 178       8.781  70.335  15.303  1.00 70.20           N  
ATOM    814  CA  GLU A 178       9.033  69.131  14.522  1.00 68.14           C  
ATOM    815  C   GLU A 178       9.781  68.109  15.380  1.00 66.77           C  
ATOM    816  O   GLU A 178      10.266  67.100  14.868  1.00 65.50           O  
ATOM    817  CB  GLU A 178       9.911  69.501  13.323  1.00 67.40           C  
ATOM    818  CG  GLU A 178       9.761  68.597  12.119  1.00 70.66           C  
ATOM    819  CD  GLU A 178       8.850  69.198  11.065  1.00 70.93           C  
ATOM    820  OE1 GLU A 178       7.795  69.755  11.435  1.00 75.65           O  
ATOM    821  OE2 GLU A 178       9.182  69.108   9.865  1.00 73.10           O  
ATOM    822  N   GLN A 179       9.854  68.360  16.682  1.00 65.94           N  
ATOM    823  CA  GLN A 179      10.616  67.496  17.578  1.00 66.16           C  
ATOM    824  C   GLN A 179      10.407  65.998  17.573  1.00 66.03           C  
ATOM    825  O   GLN A 179      11.369  65.245  17.724  1.00 67.63           O  
ATOM    826  CB  GLN A 179      10.482  67.966  19.027  1.00 65.18           C  
ATOM    827  CG  GLN A 179      11.172  67.030  20.026  1.00 61.13           C  
ATOM    828  CD  GLN A 179      10.979  67.458  21.468  1.00 54.06           C  
ATOM    829  OE1 GLN A 179      11.105  68.639  21.793  1.00 64.18           O  
ATOM    830  NE2 GLN A 179      10.685  66.500  22.344  1.00 46.17           N  
ATOM    831  N   LYS A 180       9.167  65.569  17.411  1.00 66.01           N  
ATOM    832  CA  LYS A 180       8.844  64.155  17.446  1.00 65.63           C  
ATOM    833  C   LYS A 180       9.458  63.306  16.345  1.00 64.69           C  
ATOM    834  O   LYS A 180       9.465  62.083  16.445  1.00 66.61           O  
ATOM    835  CB  LYS A 180       7.336  63.983  17.457  1.00 65.88           C  
ATOM    836  N   HIS A 181       9.980  63.941  15.305  1.00 64.22           N  
ATOM    837  CA  HIS A 181      10.581  63.206  14.197  1.00 63.85           C  
ATOM    838  C   HIS A 181      12.070  62.956  14.421  1.00 61.94           C  
ATOM    839  O   HIS A 181      12.766  62.478  13.525  1.00 62.09           O  
ATOM    840  CB  HIS A 181      10.387  64.000  12.903  1.00 64.80           C  
ATOM    841  CG  HIS A 181       8.952  64.190  12.523  1.00 67.70           C  
ATOM    842  ND1 HIS A 181       8.520  65.233  11.733  1.00 75.29           N  
ATOM    843  CD2 HIS A 181       7.846  63.467  12.828  1.00 70.87           C  
ATOM    844  CE1 HIS A 181       7.211  65.149  11.573  1.00 76.66           C  
ATOM    845  NE2 HIS A 181       6.777  64.087  12.228  1.00 72.68           N  
ATOM    846  N   TYR A 182      12.552  63.252  15.623  1.00 58.42           N  
ATOM    847  CA  TYR A 182      13.972  63.103  15.921  1.00 56.92           C  
ATOM    848  C   TYR A 182      14.398  62.051  16.942  1.00 54.52           C  
ATOM    849  O   TYR A 182      13.767  61.853  17.983  1.00 52.31           O  
ATOM    850  CB  TYR A 182      14.524  64.472  16.329  1.00 55.52           C  
ATOM    851  CG  TYR A 182      14.524  65.465  15.192  1.00 57.07           C  
ATOM    852  CD1 TYR A 182      15.682  65.703  14.452  1.00 63.05           C  
ATOM    853  CD2 TYR A 182      13.358  66.145  14.831  1.00 60.74           C  
ATOM    854  CE1 TYR A 182      15.683  66.596  13.380  1.00 65.54           C  
ATOM    855  CE2 TYR A 182      13.347  67.039  13.757  1.00 62.94           C  
ATOM    856  CZ  TYR A 182      14.514  67.260  13.041  1.00 65.47           C  
ATOM    857  OH  TYR A 182      14.517  68.158  11.998  1.00 74.27           O  
ATOM    858  N   THR A 183      15.504  61.393  16.625  1.00 50.44           N  
ATOM    859  CA  THR A 183      16.057  60.361  17.473  1.00 47.77           C  
ATOM    860  C   THR A 183      17.478  60.731  17.869  1.00 45.94           C  
ATOM    861  O   THR A 183      18.292  61.101  17.025  1.00 41.31           O  
ATOM    862  CB  THR A 183      16.095  59.017  16.727  1.00 48.90           C  
ATOM    863  OG1 THR A 183      14.819  58.777  16.124  1.00 54.77           O  
ATOM    864  CG2 THR A 183      16.423  57.876  17.688  1.00 44.35           C  
ATOM    865  N   LEU A 184      17.773  60.658  19.161  1.00 45.17           N  
ATOM    866  CA  LEU A 184      19.122  60.950  19.605  1.00 43.06           C  
ATOM    867  C   LEU A 184      19.827  59.604  19.532  1.00 40.91           C  
ATOM    868  O   LEU A 184      19.235  58.562  19.845  1.00 37.67           O  
ATOM    869  CB  LEU A 184      19.152  61.488  21.037  1.00 44.24           C  
ATOM    870  CG  LEU A 184      20.584  61.828  21.481  1.00 45.53           C  
ATOM    871  CD1 LEU A 184      21.079  63.037  20.703  1.00 42.74           C  
ATOM    872  CD2 LEU A 184      20.638  62.090  22.971  1.00 42.65           C  
ATOM    873  N   VAL A 185      21.077  59.631  19.080  1.00 38.90           N  
ATOM    874  CA  VAL A 185      21.877  58.424  18.947  1.00 35.97           C  
ATOM    875  C   VAL A 185      23.047  58.520  19.910  1.00 35.94           C  
ATOM    876  O   VAL A 185      23.674  59.579  20.048  1.00 33.23           O  
ATOM    877  CB  VAL A 185      22.447  58.270  17.521  1.00 39.02           C  
ATOM    878  CG1 VAL A 185      23.363  57.053  17.467  1.00 35.39           C  
ATOM    879  CG2 VAL A 185      21.300  58.154  16.488  1.00 38.52           C  
ATOM    880  N   TYR A 186      23.343  57.413  20.575  1.00 34.55           N  
ATOM    881  CA  TYR A 186      24.437  57.386  21.517  1.00 33.46           C  
ATOM    882  C   TYR A 186      25.263  56.137  21.282  1.00 31.59           C  
ATOM    883  O   TYR A 186      24.728  55.031  21.331  1.00 31.89           O  
ATOM    884  CB  TYR A 186      23.893  57.390  22.956  1.00 31.62           C  
ATOM    885  CG  TYR A 186      24.940  57.135  24.013  1.00 28.86           C  
ATOM    886  CD1 TYR A 186      26.048  57.965  24.129  1.00 16.43           C  
ATOM    887  CD2 TYR A 186      24.833  56.056  24.889  1.00 32.30           C  
ATOM    888  CE1 TYR A 186      27.031  57.732  25.086  1.00 21.19           C  
ATOM    889  CE2 TYR A 186      25.808  55.817  25.860  1.00 31.83           C  
ATOM    890  CZ  TYR A 186      26.908  56.665  25.947  1.00 28.54           C  
ATOM    891  OH  TYR A 186      27.889  56.463  26.887  1.00 23.92           O  
ATOM    892  N   ASN A 187      26.552  56.314  20.995  1.00 28.90           N  
ATOM    893  CA  ASN A 187      27.453  55.183  20.802  1.00 30.81           C  
ATOM    894  C   ASN A 187      28.516  55.310  21.898  1.00 28.43           C  
ATOM    895  O   ASN A 187      29.385  56.191  21.845  1.00 31.82           O  
ATOM    896  CB  ASN A 187      28.108  55.208  19.412  1.00 27.49           C  
ATOM    897  CG  ASN A 187      28.870  53.918  19.105  1.00 30.99           C  
ATOM    898  OD1 ASN A 187      29.738  53.488  19.879  1.00 28.62           O  
ATOM    899  ND2 ASN A 187      28.542  53.290  17.979  1.00 38.79           N  
ATOM    900  N   PRO A 188      28.455  54.434  22.912  1.00 25.74           N  
ATOM    901  CA  PRO A 188      29.414  54.455  24.033  1.00 25.07           C  
ATOM    902  C   PRO A 188      30.878  54.255  23.649  1.00 23.56           C  
ATOM    903  O   PRO A 188      31.771  54.795  24.293  1.00 24.68           O  
ATOM    904  CB  PRO A 188      28.870  53.393  24.997  1.00 22.78           C  
ATOM    905  CG  PRO A 188      28.107  52.452  24.108  1.00 25.86           C  
ATOM    906  CD  PRO A 188      27.468  53.352  23.057  1.00 25.32           C  
ATOM    907  N   PHE A 189      31.133  53.495  22.597  1.00 26.31           N  
ATOM    908  CA  PHE A 189      32.509  53.299  22.157  1.00 28.03           C  
ATOM    909  C   PHE A 189      33.000  54.645  21.584  1.00 28.01           C  
ATOM    910  O   PHE A 189      34.099  55.090  21.888  1.00 28.04           O  
ATOM    911  CB  PHE A 189      32.575  52.196  21.096  1.00 27.44           C  
ATOM    912  CG  PHE A 189      33.960  51.930  20.583  1.00 30.26           C  
ATOM    913  CD1 PHE A 189      34.936  51.404  21.415  1.00 26.96           C  
ATOM    914  CD2 PHE A 189      34.291  52.216  19.256  1.00 32.87           C  
ATOM    915  CE1 PHE A 189      36.223  51.161  20.938  1.00 32.14           C  
ATOM    916  CE2 PHE A 189      35.578  51.980  18.771  1.00 21.73           C  
ATOM    917  CZ  PHE A 189      36.542  51.452  19.612  1.00 27.37           C  
ATOM    918  N   LEU A 190      32.168  55.290  20.770  1.00 28.08           N  
ATOM    919  CA  LEU A 190      32.511  56.584  20.183  1.00 28.64           C  
ATOM    920  C   LEU A 190      32.614  57.667  21.260  1.00 28.06           C  
ATOM    921  O   LEU A 190      33.503  58.512  21.198  1.00 30.67           O  
ATOM    922  CB  LEU A 190      31.449  57.001  19.153  1.00 30.02           C  
ATOM    923  CG  LEU A 190      31.669  56.784  17.643  1.00 39.00           C  
ATOM    924  CD1 LEU A 190      32.583  57.877  17.072  1.00 40.98           C  
ATOM    925  CD2 LEU A 190      32.254  55.397  17.404  1.00 39.89           C  
ATOM    926  N   ALA A 191      31.705  57.631  22.238  1.00 28.34           N  
ATOM    927  CA  ALA A 191      31.661  58.614  23.324  1.00 26.99           C  
ATOM    928  C   ALA A 191      32.842  58.554  24.256  1.00 25.47           C  
ATOM    929  O   ALA A 191      33.148  59.529  24.939  1.00 28.58           O  
ATOM    930  CB  ALA A 191      30.384  58.441  24.155  1.00 24.49           C  
ATOM    931  N   ASP A 192      33.490  57.401  24.309  1.00 31.04           N  
ATOM    932  CA  ASP A 192      34.634  57.237  25.193  1.00 31.83           C  
ATOM    933  C   ASP A 192      35.910  57.278  24.362  1.00 32.15           C  
ATOM    934  O   ASP A 192      36.177  56.393  23.556  1.00 28.91           O  
ATOM    935  CB  ASP A 192      34.524  55.927  25.957  1.00 28.36           C  
ATOM    936  CG  ASP A 192      35.641  55.739  26.958  1.00 34.08           C  
ATOM    937  OD1 ASP A 192      36.560  56.590  27.008  1.00 27.51           O  
ATOM    938  OD2 ASP A 192      35.599  54.732  27.696  1.00 41.84           O  
ATOM    939  N   THR A 193      36.704  58.316  24.596  1.00 36.43           N  
ATOM    940  CA  THR A 193      37.918  58.524  23.838  1.00 37.03           C  
ATOM    941  C   THR A 193      39.236  58.092  24.503  1.00 38.83           C  
ATOM    942  O   THR A 193      40.327  58.450  24.050  1.00 39.44           O  
ATOM    943  CB  THR A 193      37.949  59.994  23.397  1.00 36.44           C  
ATOM    944  OG1 THR A 193      38.719  60.113  22.199  1.00 52.45           O  
ATOM    945  CG2 THR A 193      38.499  60.875  24.491  1.00 29.63           C  
ATOM    946  N   ASN A 194      39.118  57.304  25.569  1.00 39.60           N  
ATOM    947  CA  ASN A 194      40.263  56.765  26.288  1.00 39.40           C  
ATOM    948  C   ASN A 194      41.045  55.928  25.281  1.00 41.11           C  
ATOM    949  O   ASN A 194      40.521  54.945  24.760  1.00 40.15           O  
ATOM    950  CB  ASN A 194      39.770  55.859  27.414  1.00 41.83           C  
ATOM    951  CG  ASN A 194      40.883  55.404  28.336  1.00 40.52           C  
ATOM    952  OD1 ASN A 194      42.053  55.363  27.952  1.00 41.79           O  
ATOM    953  ND2 ASN A 194      40.519  55.043  29.561  1.00 39.56           N  
ATOM    954  N   SER A 195      42.293  56.306  25.011  1.00 43.16           N  
ATOM    955  CA  SER A 195      43.119  55.579  24.044  1.00 44.45           C  
ATOM    956  C   SER A 195      43.902  54.383  24.615  1.00 44.03           C  
ATOM    957  O   SER A 195      44.451  53.578  23.866  1.00 42.34           O  
ATOM    958  CB  SER A 195      44.092  56.555  23.351  1.00 46.26           C  
ATOM    959  OG  SER A 195      44.979  57.181  24.268  1.00 48.89           O  
ATOM    960  N   SER A 196      43.931  54.254  25.933  1.00 44.13           N  
ATOM    961  CA  SER A 196      44.671  53.167  26.576  1.00 44.57           C  
ATOM    962  C   SER A 196      44.010  51.794  26.569  1.00 44.40           C  
ATOM    963  O   SER A 196      44.697  50.783  26.712  1.00 42.18           O  
ATOM    964  CB  SER A 196      44.964  53.538  28.027  1.00 45.17           C  
ATOM    965  OG  SER A 196      43.761  53.582  28.775  1.00 51.24           O  
ATOM    966  N   ASN A 197      42.692  51.759  26.391  1.00 45.74           N  
ATOM    967  CA  ASN A 197      41.932  50.512  26.426  1.00 42.56           C  
ATOM    968  C   ASN A 197      40.939  50.390  25.290  1.00 44.33           C  
ATOM    969  O   ASN A 197      39.873  49.803  25.458  1.00 42.70           O  
ATOM    970  CB  ASN A 197      41.167  50.436  27.749  1.00 40.84           C  
ATOM    971  CG  ASN A 197      40.147  51.576  27.914  1.00 43.95           C  
ATOM    972  OD1 ASN A 197      40.065  52.493  27.089  1.00 38.84           O  
ATOM    973  ND2 ASN A 197      39.367  51.517  28.993  1.00 42.78           N  
ATOM    974  N   THR A 198      41.296  50.941  24.139  1.00 46.62           N  
ATOM    975  CA  THR A 198      40.430  50.927  22.969  1.00 47.51           C  
ATOM    976  C   THR A 198      40.093  49.540  22.439  1.00 48.36           C  
ATOM    977  O   THR A 198      38.926  49.226  22.223  1.00 50.78           O  
ATOM    978  CB  THR A 198      41.052  51.749  21.846  1.00 46.67           C  
ATOM    979  OG1 THR A 198      41.422  53.036  22.362  1.00 50.60           O  
ATOM    980  CG2 THR A 198      40.057  51.931  20.719  1.00 45.92           C  
ATOM    981  N   GLU A 199      41.105  48.709  22.218  1.00 50.81           N  
ATOM    982  CA  GLU A 199      40.849  47.359  21.722  1.00 51.49           C  
ATOM    983  C   GLU A 199      40.041  46.586  22.752  1.00 51.19           C  
ATOM    984  O   GLU A 199      39.230  45.732  22.403  1.00 54.47           O  
ATOM    985  CB  GLU A 199      42.163  46.613  21.447  1.00 50.57           C  
ATOM    986  CG  GLU A 199      42.846  46.988  20.142  1.00 52.34           C  
ATOM    987  CD  GLU A 199      42.048  46.561  18.915  1.00 63.44           C  
ATOM    988  OE1 GLU A 199      40.837  46.874  18.844  1.00 64.98           O  
ATOM    989  OE2 GLU A 199      42.633  45.916  18.016  1.00 69.30           O  
ATOM    990  N   GLU A 200      40.265  46.899  24.024  1.00 51.69           N  
ATOM    991  CA  GLU A 200      39.578  46.216  25.115  1.00 51.60           C  
ATOM    992  C   GLU A 200      38.105  46.575  25.252  1.00 49.56           C  
ATOM    993  O   GLU A 200      37.451  46.159  26.210  1.00 52.32           O  
ATOM    994  CB  GLU A 200      40.299  46.497  26.434  1.00 52.99           C  
ATOM    995  CG  GLU A 200      41.747  46.023  26.448  1.00 61.97           C  
ATOM    996  CD  GLU A 200      42.543  46.598  27.609  1.00 69.69           C  
ATOM    997  OE1 GLU A 200      42.001  46.634  28.736  1.00 71.51           O  
ATOM    998  OE2 GLU A 200      43.710  47.005  27.397  1.00 69.01           O  
ATOM    999  N   ARG A 201      37.574  47.332  24.297  1.00 42.62           N  
ATOM   1000  CA  ARG A 201      36.172  47.720  24.366  1.00 42.73           C  
ATOM   1001  C   ARG A 201      35.475  47.911  23.016  1.00 40.97           C  
ATOM   1002  O   ARG A 201      34.448  48.586  22.927  1.00 41.92           O  
ATOM   1003  CB  ARG A 201      36.029  48.980  25.242  1.00 42.51           C  
ATOM   1004  CG  ARG A 201      36.946  50.141  24.890  1.00 39.09           C  
ATOM   1005  CD  ARG A 201      36.901  51.255  25.957  1.00 34.38           C  
ATOM   1006  NE  ARG A 201      37.632  52.449  25.518  1.00 32.25           N  
ATOM   1007  CZ  ARG A 201      37.146  53.352  24.668  1.00 27.49           C  
ATOM   1008  NH1 ARG A 201      35.923  53.213  24.168  1.00 30.29           N  
ATOM   1009  NH2 ARG A 201      37.891  54.386  24.289  1.00 28.42           N  
ATOM   1010  N   VAL A 202      36.024  47.298  21.972  1.00 41.98           N  
ATOM   1011  CA  VAL A 202      35.428  47.390  20.647  1.00 43.15           C  
ATOM   1012  C   VAL A 202      34.009  46.813  20.635  1.00 42.13           C  
ATOM   1013  O   VAL A 202      33.192  47.181  19.797  1.00 42.68           O  
ATOM   1014  CB  VAL A 202      36.271  46.637  19.593  1.00 42.41           C  
ATOM   1015  CG1 VAL A 202      37.539  47.420  19.280  1.00 46.94           C  
ATOM   1016  CG2 VAL A 202      36.633  45.257  20.114  1.00 42.32           C  
ATOM   1017  N   LYS A 203      33.715  45.913  21.566  1.00 41.51           N  
ATOM   1018  CA  LYS A 203      32.388  45.313  21.627  1.00 41.74           C  
ATOM   1019  C   LYS A 203      31.287  46.327  21.959  1.00 40.52           C  
ATOM   1020  O   LYS A 203      30.114  46.103  21.657  1.00 42.29           O  
ATOM   1021  CB  LYS A 203      32.376  44.168  22.642  1.00 40.31           C  
ATOM   1022  CG  LYS A 203      33.180  42.946  22.204  1.00 48.46           C  
ATOM   1023  CD  LYS A 203      32.992  41.783  23.179  1.00 60.87           C  
ATOM   1024  CE  LYS A 203      33.562  40.473  22.643  1.00 64.52           C  
ATOM   1025  NZ  LYS A 203      34.961  40.236  23.093  1.00 69.05           N  
ATOM   1026  N   ASP A 204      31.666  47.441  22.573  1.00 38.31           N  
ATOM   1027  CA  ASP A 204      30.705  48.481  22.933  1.00 36.05           C  
ATOM   1028  C   ASP A 204      30.262  49.300  21.728  1.00 33.95           C  
ATOM   1029  O   ASP A 204      29.331  50.093  21.823  1.00 31.93           O  
ATOM   1030  CB  ASP A 204      31.312  49.439  23.971  1.00 37.14           C  
ATOM   1031  CG  ASP A 204      31.615  48.761  25.294  1.00 42.22           C  
ATOM   1032  OD1 ASP A 204      31.016  47.698  25.572  1.00 46.53           O  
ATOM   1033  OD2 ASP A 204      32.439  49.301  26.062  1.00 41.59           O  
ATOM   1034  N   ASP A 205      30.940  49.114  20.601  1.00 35.41           N  
ATOM   1035  CA  ASP A 205      30.640  49.854  19.376  1.00 34.35           C  
ATOM   1036  C   ASP A 205      29.253  49.498  18.845  1.00 34.31           C  
ATOM   1037  O   ASP A 205      29.123  48.665  17.945  1.00 35.53           O  
ATOM   1038  CB  ASP A 205      31.710  49.539  18.321  1.00 37.90           C  
ATOM   1039  CG  ASP A 205      31.732  50.535  17.175  1.00 37.15           C  
ATOM   1040  OD1 ASP A 205      30.788  51.344  17.042  1.00 34.64           O  
ATOM   1041  OD2 ASP A 205      32.710  50.496  16.396  1.00 49.65           O  
ATOM   1042  N   ILE A 206      28.228  50.135  19.410  1.00 34.67           N  
ATOM   1043  CA  ILE A 206      26.834  49.916  19.016  1.00 33.35           C  
ATOM   1044  C   ILE A 206      26.031  51.203  19.230  1.00 32.35           C  
ATOM   1045  O   ILE A 206      26.236  51.906  20.224  1.00 34.31           O  
ATOM   1046  CB  ILE A 206      26.203  48.747  19.834  1.00 35.28           C  
ATOM   1047  CG1 ILE A 206      26.758  47.415  19.324  1.00 32.82           C  
ATOM   1048  CG2 ILE A 206      24.680  48.765  19.725  1.00 30.04           C  
ATOM   1049  CD1 ILE A 206      26.035  46.217  19.834  1.00 41.84           C  
ATOM   1050  N   ASP A 207      25.140  51.523  18.288  1.00 32.56           N  
ATOM   1051  CA  ASP A 207      24.305  52.730  18.373  1.00 32.71           C  
ATOM   1052  C   ASP A 207      23.067  52.474  19.249  1.00 35.42           C  
ATOM   1053  O   ASP A 207      22.459  51.409  19.170  1.00 35.49           O  
ATOM   1054  CB  ASP A 207      23.798  53.162  16.986  1.00 34.10           C  
ATOM   1055  CG  ASP A 207      24.878  53.748  16.091  1.00 38.91           C  
ATOM   1056  OD1 ASP A 207      25.883  54.287  16.594  1.00 50.18           O  
ATOM   1057  OD2 ASP A 207      24.695  53.690  14.858  1.00 41.18           O  
ATOM   1058  N   TYR A 208      22.690  53.454  20.066  1.00 35.21           N  
ATOM   1059  CA  TYR A 208      21.512  53.347  20.931  1.00 36.03           C  
ATOM   1060  C   TYR A 208      20.626  54.519  20.591  1.00 34.24           C  
ATOM   1061  O   TYR A 208      21.041  55.668  20.721  1.00 34.08           O  
ATOM   1062  CB  TYR A 208      21.893  53.407  22.414  1.00 30.87           C  
ATOM   1063  CG  TYR A 208      22.654  52.193  22.885  1.00 34.20           C  
ATOM   1064  CD1 TYR A 208      24.035  52.107  22.734  1.00 27.27           C  
ATOM   1065  CD2 TYR A 208      21.979  51.103  23.441  1.00 30.28           C  
ATOM   1066  CE1 TYR A 208      24.721  50.972  23.132  1.00 28.93           C  
ATOM   1067  CE2 TYR A 208      22.652  49.963  23.839  1.00 30.55           C  
ATOM   1068  CZ  TYR A 208      24.023  49.900  23.682  1.00 26.83           C  
ATOM   1069  OH  TYR A 208      24.683  48.767  24.090  1.00 35.03           O  
ATOM   1070  N   LEU A 209      19.405  54.235  20.161  1.00 34.76           N  
ATOM   1071  CA  LEU A 209      18.497  55.296  19.775  1.00 35.41           C  
ATOM   1072  C   LEU A 209      17.479  55.659  20.839  1.00 32.86           C  
ATOM   1073  O   LEU A 209      16.908  54.789  21.485  1.00 30.18           O  
ATOM   1074  CB  LEU A 209      17.751  54.913  18.488  1.00 35.92           C  
ATOM   1075  CG  LEU A 209      18.563  54.470  17.268  1.00 36.55           C  
ATOM   1076  CD1 LEU A 209      17.779  54.761  15.994  1.00 38.39           C  
ATOM   1077  CD2 LEU A 209      19.875  55.202  17.229  1.00 36.21           C  
ATOM   1078  N   VAL A 210      17.269  56.959  21.016  1.00 37.04           N  
ATOM   1079  CA  VAL A 210      16.279  57.464  21.957  1.00 39.03           C  
ATOM   1080  C   VAL A 210      15.369  58.372  21.149  1.00 42.77           C  
ATOM   1081  O   VAL A 210      15.796  59.429  20.681  1.00 40.89           O  
ATOM   1082  CB  VAL A 210      16.890  58.297  23.093  1.00 38.54           C  
ATOM   1083  CG1 VAL A 210      15.880  58.407  24.226  1.00 34.19           C  
ATOM   1084  CG2 VAL A 210      18.183  57.669  23.585  1.00 39.88           C  
ATOM   1085  N   LYS A 211      14.121  57.949  20.968  1.00 48.94           N  
ATOM   1086  CA  LYS A 211      13.151  58.732  20.209  1.00 50.84           C  
ATOM   1087  C   LYS A 211      12.715  59.898  21.084  1.00 51.13           C  
ATOM   1088  O   LYS A 211      12.459  59.725  22.275  1.00 51.01           O  
ATOM   1089  CB  LYS A 211      11.946  57.873  19.849  1.00 53.00           C  
ATOM   1090  CG  LYS A 211      11.125  58.397  18.685  1.00 57.43           C  
ATOM   1091  CD  LYS A 211      11.700  57.960  17.350  1.00 64.81           C  
ATOM   1092  CE  LYS A 211      10.714  58.239  16.225  1.00 72.33           C  
ATOM   1093  NZ  LYS A 211      11.256  57.846  14.894  1.00 70.86           N  
ATOM   1094  N   LEU A 212      12.629  61.086  20.498  1.00 53.07           N  
ATOM   1095  CA  LEU A 212      12.252  62.262  21.264  1.00 54.91           C  
ATOM   1096  C   LEU A 212      10.773  62.655  21.136  1.00 59.17           C  
ATOM   1097  O   LEU A 212      10.426  63.554  20.369  1.00 60.52           O  
ATOM   1098  CB  LEU A 212      13.146  63.445  20.863  1.00 51.53           C  
ATOM   1099  CG  LEU A 212      14.661  63.185  20.773  1.00 50.43           C  
ATOM   1100  CD1 LEU A 212      15.350  64.394  20.138  1.00 47.63           C  
ATOM   1101  CD2 LEU A 212      15.253  62.911  22.155  1.00 36.87           C  
ATOM   1102  N   ASP A 213       9.909  61.962  21.875  1.00 62.46           N  
ATOM   1103  CA  ASP A 213       8.476  62.265  21.898  1.00 65.06           C  
ATOM   1104  C   ASP A 213       7.783  61.689  23.134  1.00 64.88           C  
ATOM   1105  O   ASP A 213       7.163  62.486  23.880  1.00 65.74           O  
ATOM   1106  CB  ASP A 213       7.749  61.803  20.614  1.00 66.67           C  
ATOM   1107  CG  ASP A 213       8.191  60.437  20.124  1.00 68.10           C  
ATOM   1108  OD1 ASP A 213       8.541  59.573  20.952  1.00 70.70           O  
ATOM   1109  OD2 ASP A 213       8.165  60.227  18.890  1.00 68.15           O  
TER    1110      ASP A 213                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
