
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  122 ( 1879),  selected  122 , name 2ys4_A
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 2ys4_A.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E     267           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    E     9_A      -       -           -
LGA    R    10_A      -       -           -
LGA    E    11_A      -       -           -
LGA    K    12_A      -       -           -
LGA    F    13_A      D     268          4.421
LGA    I    14_A      -       -           -
LGA    V    15_A      L     269          3.769
LGA    P    16_A      -       -           -
LGA    I    17_A      -       -           -
LGA    K    18_A      -       -           -
LGA    A    19_A      -       -           -
LGA    R    20_A      -       -           -
LGA    G    21_A      -       -           -
LGA    A    22_A      -       -           -
LGA    R    23_A      L     270           #
LGA    -       -      R     271           -
LGA    -       -      P     272           -
LGA    A    24_A      F     273           #
LGA    I    25_A      F     274          3.877
LGA    -       -      E     275           -
LGA    -       -      K     276           -
LGA    -       -      C     277           -
LGA    L    26_A      V     278          2.665
LGA    D    27_A      K     279          2.654
LGA    F    28_A      I     280          2.831
LGA    P    29_A      E     281          4.706
LGA    D    30_A      -       -           -
LGA    K    31_A      -       -           -
LGA    L    32_A      E     282          6.066
LGA    -       -      V     283           -
LGA    N    33_A      S     284           #
LGA    F    34_A      R     285          4.086
LGA    S    35_A      -       -           -
LGA    T    36_A      N     286          6.260
LGA    C    37_A      E     287          2.705
LGA    P    38_A      -       -           -
LGA    V    39_A      -       -           -
LGA    K    40_A      -       -           -
LGA    Y    41_A      -       -           -
LGA    S    42_A      -       -           -
LGA    T    43_A      Q     288          0.405
LGA    Q    44_A      G     289          3.293
LGA    K    45_A      V     290          3.295
LGA    I    46_A      T     291          2.383
LGA    L    47_A      L     292          1.713
LGA    L    48_A      S     293          1.632
LGA    V    49_A      I     294          1.600
LGA    R    50_A      T     295          1.466
LGA    N    51_A      N     296          1.194
LGA    I    52_A      V     297          1.967
LGA    G    53_A      T     298          2.968
LGA    N    54_A      D     299          2.569
LGA    K    55_A      L     300          1.763
LGA    N    56_A      V     301          1.295
LGA    A    57_A      L     302          1.078
LGA    V    58_A      K     303          0.630
LGA    F    59_A      L     304          1.337
LGA    H    60_A      K     305          1.560
LGA    I    61_A      K     306          2.697
LGA    K    62_A      T     307          3.374
LGA    -       -      A     308           -
LGA    T    63_A      H     309          3.124
LGA    C    64_A      D     310          3.626
LGA    R    65_A      T     311          2.699
LGA    P    66_A      L     312          1.511
LGA    F    67_A      L     313          0.880
LGA    S    68_A      V     314          0.813
LGA    I    69_A      Y     315          1.193
LGA    E    70_A      F     316          2.528
LGA    P    71_A      -       -           -
LGA    A    72_A      R     317          2.213
LGA    I    73_A      D     318          1.412
LGA    G    74_A      M     319          1.261
LGA    T    75_A      T     320          1.139
LGA    L    76_A      L     321          1.766
LGA    N    77_A      K     322          1.465
LGA    V    78_A      P     323          1.147
LGA    G    79_A      H     324          1.741
LGA    E    80_A      T     325          1.567
LGA    S    81_A      R     326          1.465
LGA    M    82_A      Y     327          1.593
LGA    Q    83_A      T     328          1.509
LGA    L    84_A      V     329          1.273
LGA    E    85_A      R     330          1.654
LGA    V    86_A      I     331          1.156
LGA    E    87_A      G     332          0.957
LGA    F    88_A      F     333          0.710
LGA    E    89_A      K     334          2.253
LGA    P    90_A      Q     335          3.307
LGA    Q    91_A      G     336          3.316
LGA    S    92_A      I     337           #
LGA    V    93_A      -       -           -
LGA    G    94_A      -       -           -
LGA    D    95_A      -       -           -
LGA    H    96_A      K     338          3.853
LGA    S    97_A      G     339          3.892
LGA    G    98_A      G     340          2.040
LGA    R    99_A      D     341          1.208
LGA    L   100_A      V     342          1.487
LGA    I   101_A      N     343          1.665
LGA    V   102_A      F     344          1.876
LGA    C   103_A      E     345          0.333
LGA    Y   104_A      V     346          0.765
LGA    D   105_A      T     347          1.429
LGA    T   106_A      N     348          2.942
LGA    G   107_A      F     349          3.995
LGA    -       -      I     350           -
LGA    -       -      V     351           -
LGA    -       -      A     352           -
LGA    -       -      P     353           -
LGA    -       -      D     354           -
LGA    -       -      K     355           -
LGA    -       -      G     356           -
LGA    E   108_A      L     357          1.188
LGA    K   109_A      K     358          1.979
LGA    V   110_A      Y     359          1.652
LGA    F   111_A      T     360          2.046
LGA    V   112_A      I     361          1.612
LGA    S   113_A      S     362          1.407
LGA    L   114_A      L     363          2.183
LGA    Y   115_A      -       -           -
LGA    G   116_A      -       -           -
LGA    A   117_A      -       -           -
LGA    A   118_A      -       -           -
LGA    I   119_A      -       -           -
LGA    D   120_A      -       -           -
LGA    M   121_A      -       -           -
LGA    N   122_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  122   97    5.0     78    2.48    11.54     57.795     3.027

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.183393 * X  +  -0.843859 * Y  +  -0.504251 * Z  +  21.296827
  Y_new =   0.934999 * X  +   0.008659 * Y  +  -0.354544 * Z  +  61.697170
  Z_new =   0.303552 * X  +  -0.536496 * Y  +   0.787419 * Z  +  22.649969 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.598088    2.543504  [ DEG:   -34.2679    145.7321 ]
  Theta =  -0.308418   -2.833175  [ DEG:   -17.6710   -162.3289 ]
  Phi   =   1.764480   -1.377113  [ DEG:   101.0973    -78.9027 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ys4_A                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ys4_A.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  122   97   5.0   78   2.48   11.54  57.795
REMARK  ---------------------------------------------------------- 
MOLECULE 2ys4_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   03-APR-07   2YS4              
TITLE     SOLUTION STRUCTURE OF THE N-TERMINAL PAPD-LIKE DOMAIN OF              
TITLE    2 HYDIN PROTEIN FROM HUMAN                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYDROCEPHALUS-INDUCING PROTEIN HOMOLOG;                    
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PAPD-LIKE, UNP RESIDUES 182-296;                           
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: HYDIN;                                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060327-16;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    HYDIN, PAPD-LIKE, NPPSFA, NATIONAL PROJECT ON PROTEIN                 
KEYWDS   2 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   3 GENOMICS/PROTEOMICS INITIATIVE, RSGI, STRUCTURAL GENOMICS,           
KEYWDS   4 UNKNOWN FUNCTION                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,T.TOMIZAWA,S.KOSHIBA,S.WATANABE,T.HARADA,T.KIGAWA,               
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   08-APR-08 2YS4    0                                                
JRNL        AUTH   H.LI,T.TOMIZAWA,S.KOSHIBA,S.WATANABE,T.HARADA,               
JRNL        AUTH 2 T.KIGAWA,S.YOKOYAMA                                          
JRNL        TITL   SOLUTION STRUCTURE OF THE N-TERMINAL PAPD-LIKE               
JRNL        TITL 2 DOMAIN OF HYDIN PROTEIN FROM HUMAN                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2YS4 A    8   122  UNP    Q4G0P3   HYDIN_HUMAN    182    296             
SEQRES   1 A  122  GLY SER SER GLY SER SER GLY THR GLU ARG GLU LYS PHE          
SEQRES   2 A  122  ILE VAL PRO ILE LYS ALA ARG GLY ALA ARG ALA ILE LEU          
SEQRES   3 A  122  ASP PHE PRO ASP LYS LEU ASN PHE SER THR CYS PRO VAL          
SEQRES   4 A  122  LYS TYR SER THR GLN LYS ILE LEU LEU VAL ARG ASN ILE          
SEQRES   5 A  122  GLY ASN LYS ASN ALA VAL PHE HIS ILE LYS THR CYS ARG          
SEQRES   6 A  122  PRO PHE SER ILE GLU PRO ALA ILE GLY THR LEU ASN VAL          
SEQRES   7 A  122  GLY GLU SER MET GLN LEU GLU VAL GLU PHE GLU PRO GLN          
SEQRES   8 A  122  SER VAL GLY ASP HIS SER GLY ARG LEU ILE VAL CYS TYR          
SEQRES   9 A  122  ASP THR GLY GLU LYS VAL PHE VAL SER LEU TYR GLY ALA          
SEQRES  10 A  122  ALA ILE ASP MET ASN                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      31.439  42.903  -3.541  1.00  0.00           N  
ATOM      2  CA  GLY A   1      32.105  42.218  -2.448  1.00  0.00           C  
ATOM      3  C   GLY A   1      32.814  43.174  -1.511  1.00  0.00           C  
ATOM      4  O   GLY A   1      32.270  43.558  -0.475  1.00  0.00           O  
ATOM      5  H1  GLY A   1      30.908  43.706  -3.362  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      31.371  41.660  -1.888  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      32.830  41.529  -2.858  1.00  0.00           H  
ATOM      8  N   SER A   2      34.033  43.560  -1.872  1.00  0.00           N  
ATOM      9  CA  SER A   2      34.822  44.473  -1.053  1.00  0.00           C  
ATOM     10  C   SER A   2      33.944  45.582  -0.478  1.00  0.00           C  
ATOM     11  O   SER A   2      33.887  45.776   0.735  1.00  0.00           O  
ATOM     12  CB  SER A   2      35.957  45.081  -1.878  1.00  0.00           C  
ATOM     13  OG  SER A   2      36.534  46.192  -1.211  1.00  0.00           O  
ATOM     14  H   SER A   2      34.414  43.218  -2.709  1.00  0.00           H  
ATOM     15  HA  SER A   2      35.244  43.906  -0.237  1.00  0.00           H  
ATOM     16  HB2 SER A   2      36.722  44.336  -2.037  1.00  0.00           H  
ATOM     17  HB3 SER A   2      35.570  45.411  -2.831  1.00  0.00           H  
ATOM     18  HG  SER A   2      35.858  46.856  -1.052  1.00  0.00           H  
ATOM     19  N   SER A   3      33.263  46.305  -1.361  1.00  0.00           N  
ATOM     20  CA  SER A   3      32.391  47.396  -0.943  1.00  0.00           C  
ATOM     21  C   SER A   3      30.939  47.104  -1.313  1.00  0.00           C  
ATOM     22  O   SER A   3      30.624  46.833  -2.471  1.00  0.00           O  
ATOM     23  CB  SER A   3      32.838  48.710  -1.588  1.00  0.00           C  
ATOM     24  OG  SER A   3      33.927  49.279  -0.881  1.00  0.00           O  
ATOM     25  H   SER A   3      33.350  46.100  -2.315  1.00  0.00           H  
ATOM     26  HA  SER A   3      32.464  47.488   0.130  1.00  0.00           H  
ATOM     27  HB2 SER A   3      33.144  48.522  -2.606  1.00  0.00           H  
ATOM     28  HB3 SER A   3      32.015  49.409  -1.581  1.00  0.00           H  
ATOM     29  HG  SER A   3      34.752  48.959  -1.253  1.00  0.00           H  
ATOM     30  N   GLY A   4      30.058  47.161  -0.318  1.00  0.00           N  
ATOM     31  CA  GLY A   4      28.651  46.901  -0.558  1.00  0.00           C  
ATOM     32  C   GLY A   4      28.065  45.922   0.439  1.00  0.00           C  
ATOM     33  O   GLY A   4      28.163  44.708   0.260  1.00  0.00           O  
ATOM     34  H   GLY A   4      30.367  47.383   0.585  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      28.108  47.832  -0.496  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      28.536  46.495  -1.552  1.00  0.00           H  
ATOM     37  N   SER A   5      27.453  46.451   1.496  1.00  0.00           N  
ATOM     38  CA  SER A   5      26.854  45.615   2.529  1.00  0.00           C  
ATOM     39  C   SER A   5      25.332  45.728   2.503  1.00  0.00           C  
ATOM     40  O   SER A   5      24.780  46.827   2.540  1.00  0.00           O  
ATOM     41  CB  SER A   5      27.383  46.013   3.908  1.00  0.00           C  
ATOM     42  OG  SER A   5      26.976  47.327   4.251  1.00  0.00           O  
ATOM     43  H   SER A   5      27.408  47.425   1.582  1.00  0.00           H  
ATOM     44  HA  SER A   5      27.130  44.591   2.328  1.00  0.00           H  
ATOM     45  HB2 SER A   5      27.003  45.327   4.648  1.00  0.00           H  
ATOM     46  HB3 SER A   5      28.463  45.973   3.901  1.00  0.00           H  
ATOM     47  HG  SER A   5      26.971  47.876   3.463  1.00  0.00           H  
ATOM     48  N   SER A   6      24.661  44.582   2.441  1.00  0.00           N  
ATOM     49  CA  SER A   6      23.203  44.551   2.407  1.00  0.00           C  
ATOM     50  C   SER A   6      22.616  45.303   3.598  1.00  0.00           C  
ATOM     51  O   SER A   6      21.858  46.256   3.431  1.00  0.00           O  
ATOM     52  CB  SER A   6      22.704  43.105   2.405  1.00  0.00           C  
ATOM     53  OG  SER A   6      23.222  42.387   1.299  1.00  0.00           O  
ATOM     54  H   SER A   6      25.159  43.738   2.414  1.00  0.00           H  
ATOM     55  HA  SER A   6      22.883  45.035   1.497  1.00  0.00           H  
ATOM     56  HB2 SER A   6      23.018  42.617   3.315  1.00  0.00           H  
ATOM     57  HB3 SER A   6      21.625  43.101   2.348  1.00  0.00           H  
ATOM     58  HG  SER A   6      23.344  41.467   1.543  1.00  0.00           H  
ATOM     59  N   GLY A   7      22.974  44.865   4.801  1.00  0.00           N  
ATOM     60  CA  GLY A   7      22.474  45.507   6.002  1.00  0.00           C  
ATOM     61  C   GLY A   7      21.904  44.514   6.996  1.00  0.00           C  
ATOM     62  O   GLY A   7      21.074  43.676   6.642  1.00  0.00           O  
ATOM     63  H   GLY A   7      23.582  44.100   4.873  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      23.283  46.047   6.472  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      21.698  46.207   5.727  1.00  0.00           H  
ATOM     66  N   THR A   8      22.352  44.605   8.245  1.00  0.00           N  
ATOM     67  CA  THR A   8      21.884  43.706   9.292  1.00  0.00           C  
ATOM     68  C   THR A   8      21.526  44.476  10.558  1.00  0.00           C  
ATOM     69  O   THR A   8      22.201  45.440  10.920  1.00  0.00           O  
ATOM     70  CB  THR A   8      22.944  42.643   9.634  1.00  0.00           C  
ATOM     71  OG1 THR A   8      22.443  41.760  10.644  1.00  0.00           O  
ATOM     72  CG2 THR A   8      24.230  43.296  10.116  1.00  0.00           C  
ATOM     73  H   THR A   8      23.013  45.293   8.465  1.00  0.00           H  
ATOM     74  HA  THR A   8      21.001  43.201   8.928  1.00  0.00           H  
ATOM     75  HB  THR A   8      23.159  42.072   8.742  1.00  0.00           H  
ATOM     76  HG1 THR A   8      22.706  42.082  11.510  1.00  0.00           H  
ATOM     77 HG21 THR A   8      24.817  43.606   9.265  1.00  0.00           H  
ATOM     78 HG22 THR A   8      24.796  42.587  10.703  1.00  0.00           H  
ATOM     79 HG23 THR A   8      23.992  44.157  10.723  1.00  0.00           H  
ATOM     80  N   GLU A   9      20.462  44.045  11.227  1.00  0.00           N  
ATOM     81  CA  GLU A   9      20.016  44.695  12.454  1.00  0.00           C  
ATOM     82  C   GLU A   9      21.085  44.603  13.539  1.00  0.00           C  
ATOM     83  O   GLU A   9      21.746  43.575  13.688  1.00  0.00           O  
ATOM     84  CB  GLU A   9      18.715  44.060  12.950  1.00  0.00           C  
ATOM     85  CG  GLU A   9      17.853  45.002  13.772  1.00  0.00           C  
ATOM     86  CD  GLU A   9      16.379  44.647  13.713  1.00  0.00           C  
ATOM     87  OE1 GLU A   9      16.060  43.440  13.727  1.00  0.00           O  
ATOM     88  OE2 GLU A   9      15.547  45.575  13.654  1.00  0.00           O  
ATOM     89  H   GLU A   9      19.964  43.271  10.888  1.00  0.00           H  
ATOM     90  HA  GLU A   9      19.834  45.735  12.230  1.00  0.00           H  
ATOM     91  HB2 GLU A   9      18.141  43.731  12.096  1.00  0.00           H  
ATOM     92  HB3 GLU A   9      18.957  43.203  13.561  1.00  0.00           H  
ATOM     93  HG2 GLU A   9      18.176  44.960  14.802  1.00  0.00           H  
ATOM     94  HG3 GLU A   9      17.980  46.007  13.397  1.00  0.00           H  
ATOM     95  N   ARG A  10      21.250  45.686  14.292  1.00  0.00           N  
ATOM     96  CA  ARG A  10      22.240  45.729  15.360  1.00  0.00           C  
ATOM     97  C   ARG A  10      21.891  44.736  16.465  1.00  0.00           C  
ATOM     98  O   ARG A  10      20.727  44.592  16.838  1.00  0.00           O  
ATOM     99  CB  ARG A  10      22.334  47.142  15.941  1.00  0.00           C  
ATOM    100  CG  ARG A  10      21.030  47.641  16.541  1.00  0.00           C  
ATOM    101  CD  ARG A  10      20.945  47.330  18.027  1.00  0.00           C  
ATOM    102  NE  ARG A  10      21.900  48.114  18.806  1.00  0.00           N  
ATOM    103  CZ  ARG A  10      21.944  48.109  20.134  1.00  0.00           C  
ATOM    104  NH1 ARG A  10      21.094  47.365  20.827  1.00  0.00           N  
ATOM    105  NH2 ARG A  10      22.843  48.850  20.771  1.00  0.00           N  
ATOM    106  H   ARG A  10      20.693  46.475  14.124  1.00  0.00           H  
ATOM    107  HA  ARG A  10      23.196  45.459  14.939  1.00  0.00           H  
ATOM    108  HB2 ARG A  10      23.088  47.151  16.715  1.00  0.00           H  
ATOM    109  HB3 ARG A  10      22.627  47.821  15.156  1.00  0.00           H  
ATOM    110  HG2 ARG A  10      20.967  48.710  16.405  1.00  0.00           H  
ATOM    111  HG3 ARG A  10      20.205  47.163  16.034  1.00  0.00           H  
ATOM    112  HD2 ARG A  10      19.946  47.551  18.372  1.00  0.00           H  
ATOM    113  HD3 ARG A  10      21.151  46.280  18.174  1.00  0.00           H  
ATOM    114  HE  ARG A  10      22.538  48.671  18.315  1.00  0.00           H  
ATOM    115 HH11 ARG A  10      20.417  46.804  20.349  1.00  0.00           H  
ATOM    116 HH12 ARG A  10      21.130  47.362  21.827  1.00  0.00           H  
ATOM    117 HH21 ARG A  10      23.486  49.412  20.252  1.00  0.00           H  
ATOM    118 HH22 ARG A  10      22.875  48.846  21.769  1.00  0.00           H  
ATOM    119  N   GLU A  11      22.908  44.054  16.983  1.00  0.00           N  
ATOM    120  CA  GLU A  11      22.707  43.073  18.044  1.00  0.00           C  
ATOM    121  C   GLU A  11      23.562  43.407  19.262  1.00  0.00           C  
ATOM    122  O   GLU A  11      24.777  43.577  19.156  1.00  0.00           O  
ATOM    123  CB  GLU A  11      23.044  41.668  17.540  1.00  0.00           C  
ATOM    124  CG  GLU A  11      21.951  41.050  16.684  1.00  0.00           C  
ATOM    125  CD  GLU A  11      22.054  39.539  16.607  1.00  0.00           C  
ATOM    126  OE1 GLU A  11      23.182  39.029  16.442  1.00  0.00           O  
ATOM    127  OE2 GLU A  11      21.007  38.867  16.713  1.00  0.00           O  
ATOM    128  H   GLU A  11      23.813  44.212  16.644  1.00  0.00           H  
ATOM    129  HA  GLU A  11      21.666  43.102  18.330  1.00  0.00           H  
ATOM    130  HB2 GLU A  11      23.949  41.716  16.954  1.00  0.00           H  
ATOM    131  HB3 GLU A  11      23.211  41.025  18.392  1.00  0.00           H  
ATOM    132  HG2 GLU A  11      20.991  41.309  17.106  1.00  0.00           H  
ATOM    133  HG3 GLU A  11      22.024  41.452  15.684  1.00  0.00           H  
ATOM    134  N   LYS A  12      22.919  43.501  20.422  1.00  0.00           N  
ATOM    135  CA  LYS A  12      23.618  43.814  21.662  1.00  0.00           C  
ATOM    136  C   LYS A  12      24.773  42.845  21.896  1.00  0.00           C  
ATOM    137  O   LYS A  12      24.560  41.660  22.153  1.00  0.00           O  
ATOM    138  CB  LYS A  12      22.649  43.763  22.846  1.00  0.00           C  
ATOM    139  CG  LYS A  12      23.032  44.689  23.987  1.00  0.00           C  
ATOM    140  CD  LYS A  12      21.918  44.799  25.014  1.00  0.00           C  
ATOM    141  CE  LYS A  12      21.941  46.146  25.719  1.00  0.00           C  
ATOM    142  NZ  LYS A  12      20.758  46.329  26.605  1.00  0.00           N  
ATOM    143  H   LYS A  12      21.949  43.355  20.444  1.00  0.00           H  
ATOM    144  HA  LYS A  12      24.015  44.814  21.576  1.00  0.00           H  
ATOM    145  HB2 LYS A  12      21.664  44.040  22.500  1.00  0.00           H  
ATOM    146  HB3 LYS A  12      22.616  42.752  23.226  1.00  0.00           H  
ATOM    147  HG2 LYS A  12      23.917  44.301  24.470  1.00  0.00           H  
ATOM    148  HG3 LYS A  12      23.240  45.671  23.587  1.00  0.00           H  
ATOM    149  HD2 LYS A  12      20.967  44.682  24.516  1.00  0.00           H  
ATOM    150  HD3 LYS A  12      22.040  44.015  25.750  1.00  0.00           H  
ATOM    151  HE2 LYS A  12      22.839  46.211  26.314  1.00  0.00           H  
ATOM    152  HE3 LYS A  12      21.946  46.928  24.974  1.00  0.00           H  
ATOM    153  HZ1 LYS A  12      19.909  46.513  26.034  1.00  0.00           H  
ATOM    154  HZ2 LYS A  12      20.913  47.133  27.247  1.00  0.00           H  
ATOM    155  HZ3 LYS A  12      20.601  45.472  27.173  1.00  0.00           H  
ATOM    156  N   PHE A  13      25.996  43.356  21.805  1.00  0.00           N  
ATOM    157  CA  PHE A  13      27.184  42.536  22.006  1.00  0.00           C  
ATOM    158  C   PHE A  13      27.144  41.846  23.366  1.00  0.00           C  
ATOM    159  O   PHE A  13      26.380  42.235  24.250  1.00  0.00           O  
ATOM    160  CB  PHE A  13      28.447  43.394  21.895  1.00  0.00           C  
ATOM    161  CG  PHE A  13      28.916  43.588  20.481  1.00  0.00           C  
ATOM    162  CD1 PHE A  13      28.095  44.189  19.540  1.00  0.00           C  
ATOM    163  CD2 PHE A  13      30.178  43.169  20.093  1.00  0.00           C  
ATOM    164  CE1 PHE A  13      28.524  44.368  18.239  1.00  0.00           C  
ATOM    165  CE2 PHE A  13      30.613  43.347  18.793  1.00  0.00           C  
ATOM    166  CZ  PHE A  13      29.785  43.947  17.864  1.00  0.00           C  
ATOM    167  H   PHE A  13      26.101  44.309  21.597  1.00  0.00           H  
ATOM    168  HA  PHE A  13      27.201  41.783  21.234  1.00  0.00           H  
ATOM    169  HB2 PHE A  13      28.250  44.369  22.315  1.00  0.00           H  
ATOM    170  HB3 PHE A  13      29.244  42.921  22.449  1.00  0.00           H  
ATOM    171  HD1 PHE A  13      27.108  44.518  19.833  1.00  0.00           H  
ATOM    172  HD2 PHE A  13      30.828  42.698  20.817  1.00  0.00           H  
ATOM    173  HE1 PHE A  13      27.873  44.838  17.516  1.00  0.00           H  
ATOM    174  HE2 PHE A  13      31.599  43.015  18.502  1.00  0.00           H  
ATOM    175  HZ  PHE A  13      30.122  44.087  16.848  1.00  0.00           H  
ATOM    176  N   ILE A  14      27.972  40.818  23.527  1.00  0.00           N  
ATOM    177  CA  ILE A  14      28.032  40.074  24.778  1.00  0.00           C  
ATOM    178  C   ILE A  14      29.453  39.609  25.073  1.00  0.00           C  
ATOM    179  O   ILE A  14      30.182  39.194  24.173  1.00  0.00           O  
ATOM    180  CB  ILE A  14      27.098  38.849  24.749  1.00  0.00           C  
ATOM    181  CG1 ILE A  14      25.635  39.296  24.748  1.00  0.00           C  
ATOM    182  CG2 ILE A  14      27.379  37.941  25.937  1.00  0.00           C  
ATOM    183  CD1 ILE A  14      24.656  38.158  24.939  1.00  0.00           C  
ATOM    184  H   ILE A  14      28.556  40.556  22.786  1.00  0.00           H  
ATOM    185  HA  ILE A  14      27.706  40.731  25.573  1.00  0.00           H  
ATOM    186  HB  ILE A  14      27.298  38.292  23.847  1.00  0.00           H  
ATOM    187 HG12 ILE A  14      25.479  40.003  25.546  1.00  0.00           H  
ATOM    188 HG13 ILE A  14      25.412  39.771  23.802  1.00  0.00           H  
ATOM    189 HG21 ILE A  14      27.120  38.454  26.851  1.00  0.00           H  
ATOM    190 HG22 ILE A  14      26.787  37.042  25.851  1.00  0.00           H  
ATOM    191 HG23 ILE A  14      28.427  37.683  25.953  1.00  0.00           H  
ATOM    192 HD11 ILE A  14      24.742  37.466  24.113  1.00  0.00           H  
ATOM    193 HD12 ILE A  14      24.876  37.644  25.862  1.00  0.00           H  
ATOM    194 HD13 ILE A  14      23.650  38.550  24.974  1.00  0.00           H  
ATOM    195  N   VAL A  15      29.841  39.680  26.343  1.00  0.00           N  
ATOM    196  CA  VAL A  15      31.174  39.263  26.759  1.00  0.00           C  
ATOM    197  C   VAL A  15      31.326  37.748  26.682  1.00  0.00           C  
ATOM    198  O   VAL A  15      30.359  36.995  26.799  1.00  0.00           O  
ATOM    199  CB  VAL A  15      31.486  39.726  28.195  1.00  0.00           C  
ATOM    200  CG1 VAL A  15      31.581  41.244  28.257  1.00  0.00           C  
ATOM    201  CG2 VAL A  15      30.429  39.211  29.161  1.00  0.00           C  
ATOM    202  H   VAL A  15      29.215  40.019  27.016  1.00  0.00           H  
ATOM    203  HA  VAL A  15      31.891  39.722  26.093  1.00  0.00           H  
ATOM    204  HB  VAL A  15      32.440  39.316  28.485  1.00  0.00           H  
ATOM    205 HG11 VAL A  15      32.028  41.537  29.196  1.00  0.00           H  
ATOM    206 HG12 VAL A  15      32.191  41.600  27.440  1.00  0.00           H  
ATOM    207 HG13 VAL A  15      30.592  41.670  28.182  1.00  0.00           H  
ATOM    208 HG21 VAL A  15      29.457  39.569  28.857  1.00  0.00           H  
ATOM    209 HG22 VAL A  15      30.434  38.131  29.155  1.00  0.00           H  
ATOM    210 HG23 VAL A  15      30.648  39.566  30.158  1.00  0.00           H  
ATOM    211  N   PRO A  16      32.570  37.287  26.481  1.00  0.00           N  
ATOM    212  CA  PRO A  16      32.879  35.858  26.385  1.00  0.00           C  
ATOM    213  C   PRO A  16      32.723  35.140  27.721  1.00  0.00           C  
ATOM    214  O   PRO A  16      32.467  35.769  28.748  1.00  0.00           O  
ATOM    215  CB  PRO A  16      34.342  35.839  25.936  1.00  0.00           C  
ATOM    216  CG  PRO A  16      34.899  37.137  26.411  1.00  0.00           C  
ATOM    217  CD  PRO A  16      33.770  38.127  26.333  1.00  0.00           C  
ATOM    218  HA  PRO A  16      32.266  35.368  25.643  1.00  0.00           H  
ATOM    219  HB2 PRO A  16      34.850  35.000  26.389  1.00  0.00           H  
ATOM    220  HB3 PRO A  16      34.391  35.760  24.861  1.00  0.00           H  
ATOM    221  HG2 PRO A  16      35.242  37.038  27.430  1.00  0.00           H  
ATOM    222  HG3 PRO A  16      35.712  37.444  25.769  1.00  0.00           H  
ATOM    223  HD2 PRO A  16      33.841  38.844  27.137  1.00  0.00           H  
ATOM    224  HD3 PRO A  16      33.775  38.628  25.377  1.00  0.00           H  
ATOM    225  N   ILE A  17      32.880  33.820  27.701  1.00  0.00           N  
ATOM    226  CA  ILE A  17      32.760  33.018  28.912  1.00  0.00           C  
ATOM    227  C   ILE A  17      33.267  33.782  30.131  1.00  0.00           C  
ATOM    228  O   ILE A  17      32.546  33.953  31.114  1.00  0.00           O  
ATOM    229  CB  ILE A  17      33.536  31.694  28.790  1.00  0.00           C  
ATOM    230  CG1 ILE A  17      32.986  30.859  27.632  1.00  0.00           C  
ATOM    231  CG2 ILE A  17      33.461  30.914  30.094  1.00  0.00           C  
ATOM    232  CD1 ILE A  17      33.813  29.631  27.326  1.00  0.00           C  
ATOM    233  H   ILE A  17      33.084  33.376  26.852  1.00  0.00           H  
ATOM    234  HA  ILE A  17      31.714  32.787  29.055  1.00  0.00           H  
ATOM    235  HB  ILE A  17      34.572  31.926  28.597  1.00  0.00           H  
ATOM    236 HG12 ILE A  17      31.987  30.535  27.873  1.00  0.00           H  
ATOM    237 HG13 ILE A  17      32.956  31.470  26.741  1.00  0.00           H  
ATOM    238 HG21 ILE A  17      32.456  30.544  30.235  1.00  0.00           H  
ATOM    239 HG22 ILE A  17      34.148  30.082  30.055  1.00  0.00           H  
ATOM    240 HG23 ILE A  17      33.724  31.562  30.917  1.00  0.00           H  
ATOM    241 HD11 ILE A  17      33.213  28.921  26.775  1.00  0.00           H  
ATOM    242 HD12 ILE A  17      34.671  29.911  26.734  1.00  0.00           H  
ATOM    243 HD13 ILE A  17      34.144  29.180  28.250  1.00  0.00           H  
ATOM    244  N   LYS A  18      34.511  34.241  30.058  1.00  0.00           N  
ATOM    245  CA  LYS A  18      35.116  34.990  31.153  1.00  0.00           C  
ATOM    246  C   LYS A  18      35.872  36.207  30.628  1.00  0.00           C  
ATOM    247  O   LYS A  18      36.419  36.181  29.525  1.00  0.00           O  
ATOM    248  CB  LYS A  18      36.064  34.092  31.950  1.00  0.00           C  
ATOM    249  CG  LYS A  18      37.374  33.804  31.236  1.00  0.00           C  
ATOM    250  CD  LYS A  18      37.262  32.586  30.334  1.00  0.00           C  
ATOM    251  CE  LYS A  18      37.444  31.295  31.117  1.00  0.00           C  
ATOM    252  NZ  LYS A  18      37.568  30.115  30.218  1.00  0.00           N  
ATOM    253  H   LYS A  18      35.036  34.073  29.248  1.00  0.00           H  
ATOM    254  HA  LYS A  18      34.322  35.328  31.802  1.00  0.00           H  
ATOM    255  HB2 LYS A  18      36.290  34.572  32.891  1.00  0.00           H  
ATOM    256  HB3 LYS A  18      35.571  33.150  32.144  1.00  0.00           H  
ATOM    257  HG2 LYS A  18      37.641  34.661  30.634  1.00  0.00           H  
ATOM    258  HG3 LYS A  18      38.145  33.626  31.973  1.00  0.00           H  
ATOM    259  HD2 LYS A  18      36.286  32.580  29.873  1.00  0.00           H  
ATOM    260  HD3 LYS A  18      38.024  32.645  29.569  1.00  0.00           H  
ATOM    261  HE2 LYS A  18      38.338  31.376  31.717  1.00  0.00           H  
ATOM    262  HE3 LYS A  18      36.589  31.157  31.763  1.00  0.00           H  
ATOM    263  HZ1 LYS A  18      37.460  29.236  30.764  1.00  0.00           H  
ATOM    264  HZ2 LYS A  18      38.501  30.113  29.758  1.00  0.00           H  
ATOM    265  HZ3 LYS A  18      36.832  30.146  29.483  1.00  0.00           H  
ATOM    266  N   ALA A  19      35.901  37.269  31.425  1.00  0.00           N  
ATOM    267  CA  ALA A  19      36.593  38.494  31.042  1.00  0.00           C  
ATOM    268  C   ALA A  19      37.011  39.295  32.269  1.00  0.00           C  
ATOM    269  O   ALA A  19      36.170  39.863  32.968  1.00  0.00           O  
ATOM    270  CB  ALA A  19      35.711  39.336  30.134  1.00  0.00           C  
ATOM    271  H   ALA A  19      35.447  37.229  32.293  1.00  0.00           H  
ATOM    272  HA  ALA A  19      37.478  38.217  30.486  1.00  0.00           H  
ATOM    273  HB1 ALA A  19      34.701  38.954  30.156  1.00  0.00           H  
ATOM    274  HB2 ALA A  19      35.714  40.361  30.479  1.00  0.00           H  
ATOM    275  HB3 ALA A  19      36.089  39.295  29.124  1.00  0.00           H  
ATOM    276  N   ARG A  20      38.314  39.337  32.527  1.00  0.00           N  
ATOM    277  CA  ARG A  20      38.843  40.069  33.671  1.00  0.00           C  
ATOM    278  C   ARG A  20      39.895  41.082  33.232  1.00  0.00           C  
ATOM    279  O   ARG A  20      40.256  41.147  32.057  1.00  0.00           O  
ATOM    280  CB  ARG A  20      39.448  39.099  34.689  1.00  0.00           C  
ATOM    281  CG  ARG A  20      40.449  38.128  34.082  1.00  0.00           C  
ATOM    282  CD  ARG A  20      40.456  36.800  34.824  1.00  0.00           C  
ATOM    283  NE  ARG A  20      41.431  36.784  35.911  1.00  0.00           N  
ATOM    284  CZ  ARG A  20      41.977  35.673  36.392  1.00  0.00           C  
ATOM    285  NH1 ARG A  20      41.645  34.494  35.885  1.00  0.00           N  
ATOM    286  NH2 ARG A  20      42.858  35.740  37.382  1.00  0.00           N  
ATOM    287  H   ARG A  20      38.935  38.866  31.934  1.00  0.00           H  
ATOM    288  HA  ARG A  20      38.023  40.597  34.136  1.00  0.00           H  
ATOM    289  HB2 ARG A  20      39.952  39.667  35.457  1.00  0.00           H  
ATOM    290  HB3 ARG A  20      38.652  38.527  35.140  1.00  0.00           H  
ATOM    291  HG2 ARG A  20      40.184  37.950  33.051  1.00  0.00           H  
ATOM    292  HG3 ARG A  20      41.435  38.564  34.134  1.00  0.00           H  
ATOM    293  HD2 ARG A  20      39.471  36.627  35.234  1.00  0.00           H  
ATOM    294  HD3 ARG A  20      40.697  36.014  34.124  1.00  0.00           H  
ATOM    295  HE  ARG A  20      41.690  37.644  36.299  1.00  0.00           H  
ATOM    296 HH11 ARG A  20      40.982  34.440  35.138  1.00  0.00           H  
ATOM    297 HH12 ARG A  20      42.058  33.658  36.249  1.00  0.00           H  
ATOM    298 HH21 ARG A  20      43.111  36.627  37.767  1.00  0.00           H  
ATOM    299 HH22 ARG A  20      43.267  34.904  37.744  1.00  0.00           H  
ATOM    300  N   GLY A  21      40.384  41.873  34.183  1.00  0.00           N  
ATOM    301  CA  GLY A  21      41.389  42.873  33.873  1.00  0.00           C  
ATOM    302  C   GLY A  21      40.922  44.280  34.188  1.00  0.00           C  
ATOM    303  O   GLY A  21      40.527  44.572  35.316  1.00  0.00           O  
ATOM    304  H   GLY A  21      40.058  41.776  35.102  1.00  0.00           H  
ATOM    305  HA2 GLY A  21      42.280  42.662  34.446  1.00  0.00           H  
ATOM    306  HA3 GLY A  21      41.628  42.813  32.822  1.00  0.00           H  
ATOM    307  N   ALA A  22      40.972  45.156  33.189  1.00  0.00           N  
ATOM    308  CA  ALA A  22      40.551  46.540  33.366  1.00  0.00           C  
ATOM    309  C   ALA A  22      39.730  47.021  32.174  1.00  0.00           C  
ATOM    310  O   ALA A  22      40.197  46.994  31.035  1.00  0.00           O  
ATOM    311  CB  ALA A  22      41.762  47.438  33.570  1.00  0.00           C  
ATOM    312  H   ALA A  22      41.298  44.863  32.313  1.00  0.00           H  
ATOM    313  HA  ALA A  22      39.941  46.592  34.256  1.00  0.00           H  
ATOM    314  HB1 ALA A  22      42.639  46.828  33.730  1.00  0.00           H  
ATOM    315  HB2 ALA A  22      41.906  48.053  32.694  1.00  0.00           H  
ATOM    316  HB3 ALA A  22      41.601  48.069  34.431  1.00  0.00           H  
ATOM    317  N   ARG A  23      38.504  47.457  32.444  1.00  0.00           N  
ATOM    318  CA  ARG A  23      37.618  47.941  31.392  1.00  0.00           C  
ATOM    319  C   ARG A  23      36.837  49.167  31.861  1.00  0.00           C  
ATOM    320  O   ARG A  23      36.594  49.340  33.054  1.00  0.00           O  
ATOM    321  CB  ARG A  23      36.647  46.838  30.966  1.00  0.00           C  
ATOM    322  CG  ARG A  23      37.337  45.579  30.467  1.00  0.00           C  
ATOM    323  CD  ARG A  23      36.391  44.711  29.652  1.00  0.00           C  
ATOM    324  NE  ARG A  23      35.532  43.892  30.502  1.00  0.00           N  
ATOM    325  CZ  ARG A  23      34.319  44.264  30.898  1.00  0.00           C  
ATOM    326  NH1 ARG A  23      33.827  45.436  30.521  1.00  0.00           N  
ATOM    327  NH2 ARG A  23      33.596  43.463  31.670  1.00  0.00           N  
ATOM    328  H   ARG A  23      38.188  47.453  33.371  1.00  0.00           H  
ATOM    329  HA  ARG A  23      38.227  48.219  30.546  1.00  0.00           H  
ATOM    330  HB2 ARG A  23      36.029  46.572  31.810  1.00  0.00           H  
ATOM    331  HB3 ARG A  23      36.017  47.216  30.174  1.00  0.00           H  
ATOM    332  HG2 ARG A  23      38.174  45.860  29.846  1.00  0.00           H  
ATOM    333  HG3 ARG A  23      37.690  45.013  31.317  1.00  0.00           H  
ATOM    334  HD2 ARG A  23      35.772  45.351  29.042  1.00  0.00           H  
ATOM    335  HD3 ARG A  23      36.977  44.063  29.017  1.00  0.00           H  
ATOM    336  HE  ARG A  23      35.875  43.021  30.792  1.00  0.00           H  
ATOM    337 HH11 ARG A  23      34.368  46.041  29.939  1.00  0.00           H  
ATOM    338 HH12 ARG A  23      32.913  45.714  30.819  1.00  0.00           H  
ATOM    339 HH21 ARG A  23      33.965  42.579  31.956  1.00  0.00           H  
ATOM    340 HH22 ARG A  23      32.685  43.745  31.967  1.00  0.00           H  
ATOM    341  N   ALA A  24      36.450  50.012  30.913  1.00  0.00           N  
ATOM    342  CA  ALA A  24      35.697  51.220  31.227  1.00  0.00           C  
ATOM    343  C   ALA A  24      34.289  51.157  30.645  1.00  0.00           C  
ATOM    344  O   ALA A  24      34.103  50.781  29.487  1.00  0.00           O  
ATOM    345  CB  ALA A  24      36.430  52.449  30.709  1.00  0.00           C  
ATOM    346  H   ALA A  24      36.674  49.819  29.979  1.00  0.00           H  
ATOM    347  HA  ALA A  24      35.627  51.299  32.302  1.00  0.00           H  
ATOM    348  HB1 ALA A  24      37.184  52.145  30.000  1.00  0.00           H  
ATOM    349  HB2 ALA A  24      35.725  53.110  30.226  1.00  0.00           H  
ATOM    350  HB3 ALA A  24      36.898  52.963  31.535  1.00  0.00           H  
ATOM    351  N   ILE A  25      33.301  51.525  31.453  1.00  0.00           N  
ATOM    352  CA  ILE A  25      31.911  51.511  31.017  1.00  0.00           C  
ATOM    353  C   ILE A  25      31.123  52.650  31.654  1.00  0.00           C  
ATOM    354  O   ILE A  25      31.260  52.922  32.847  1.00  0.00           O  
ATOM    355  CB  ILE A  25      31.228  50.174  31.360  1.00  0.00           C  
ATOM    356  CG1 ILE A  25      31.974  49.012  30.701  1.00  0.00           C  
ATOM    357  CG2 ILE A  25      29.772  50.194  30.918  1.00  0.00           C  
ATOM    358  CD1 ILE A  25      31.547  47.653  31.211  1.00  0.00           C  
ATOM    359  H   ILE A  25      33.514  51.815  32.365  1.00  0.00           H  
ATOM    360  HA  ILE A  25      31.898  51.634  29.943  1.00  0.00           H  
ATOM    361  HB  ILE A  25      31.252  50.047  32.431  1.00  0.00           H  
ATOM    362 HG12 ILE A  25      31.798  49.036  29.638  1.00  0.00           H  
ATOM    363 HG13 ILE A  25      33.032  49.120  30.890  1.00  0.00           H  
ATOM    364 HG21 ILE A  25      29.146  49.845  31.725  1.00  0.00           H  
ATOM    365 HG22 ILE A  25      29.490  51.203  30.656  1.00  0.00           H  
ATOM    366 HG23 ILE A  25      29.647  49.552  30.060  1.00  0.00           H  
ATOM    367 HD11 ILE A  25      30.658  47.759  31.818  1.00  0.00           H  
ATOM    368 HD12 ILE A  25      31.334  47.004  30.374  1.00  0.00           H  
ATOM    369 HD13 ILE A  25      32.339  47.226  31.807  1.00  0.00           H  
ATOM    370  N   LEU A  26      30.296  53.312  30.852  1.00  0.00           N  
ATOM    371  CA  LEU A  26      29.482  54.420  31.337  1.00  0.00           C  
ATOM    372  C   LEU A  26      28.004  54.046  31.352  1.00  0.00           C  
ATOM    373  O   LEU A  26      27.627  52.949  30.940  1.00  0.00           O  
ATOM    374  CB  LEU A  26      29.698  55.657  30.464  1.00  0.00           C  
ATOM    375  CG  LEU A  26      30.993  56.434  30.708  1.00  0.00           C  
ATOM    376  CD1 LEU A  26      31.031  56.975  32.128  1.00  0.00           C  
ATOM    377  CD2 LEU A  26      32.203  55.551  30.439  1.00  0.00           C  
ATOM    378  H   LEU A  26      30.230  53.048  29.910  1.00  0.00           H  
ATOM    379  HA  LEU A  26      29.795  54.644  32.347  1.00  0.00           H  
ATOM    380  HB2 LEU A  26      29.692  55.339  29.433  1.00  0.00           H  
ATOM    381  HB3 LEU A  26      28.870  56.331  30.636  1.00  0.00           H  
ATOM    382  HG  LEU A  26      31.034  57.274  30.029  1.00  0.00           H  
ATOM    383 HD11 LEU A  26      30.182  57.624  32.290  1.00  0.00           H  
ATOM    384 HD12 LEU A  26      31.944  57.534  32.276  1.00  0.00           H  
ATOM    385 HD13 LEU A  26      30.995  56.154  32.829  1.00  0.00           H  
ATOM    386 HD21 LEU A  26      32.700  55.328  31.372  1.00  0.00           H  
ATOM    387 HD22 LEU A  26      32.886  56.067  29.781  1.00  0.00           H  
ATOM    388 HD23 LEU A  26      31.880  54.631  29.973  1.00  0.00           H  
ATOM    389  N   ASP A  27      27.172  54.965  31.829  1.00  0.00           N  
ATOM    390  CA  ASP A  27      25.733  54.733  31.894  1.00  0.00           C  
ATOM    391  C   ASP A  27      24.983  55.719  31.004  1.00  0.00           C  
ATOM    392  O   ASP A  27      24.805  56.883  31.361  1.00  0.00           O  
ATOM    393  CB  ASP A  27      25.241  54.853  33.337  1.00  0.00           C  
ATOM    394  CG  ASP A  27      23.827  54.335  33.511  1.00  0.00           C  
ATOM    395  OD1 ASP A  27      23.593  53.141  33.225  1.00  0.00           O  
ATOM    396  OD2 ASP A  27      22.954  55.120  33.935  1.00  0.00           O  
ATOM    397  H   ASP A  27      27.533  55.821  32.143  1.00  0.00           H  
ATOM    398  HA  ASP A  27      25.542  53.731  31.540  1.00  0.00           H  
ATOM    399  HB2 ASP A  27      25.895  54.285  33.982  1.00  0.00           H  
ATOM    400  HB3 ASP A  27      25.262  55.891  33.633  1.00  0.00           H  
ATOM    401  N   PHE A  28      24.544  55.244  29.843  1.00  0.00           N  
ATOM    402  CA  PHE A  28      23.814  56.084  28.900  1.00  0.00           C  
ATOM    403  C   PHE A  28      22.460  55.471  28.560  1.00  0.00           C  
ATOM    404  O   PHE A  28      22.316  54.255  28.426  1.00  0.00           O  
ATOM    405  CB  PHE A  28      24.632  56.282  27.622  1.00  0.00           C  
ATOM    406  CG  PHE A  28      25.772  57.247  27.783  1.00  0.00           C  
ATOM    407  CD1 PHE A  28      27.015  56.805  28.208  1.00  0.00           C  
ATOM    408  CD2 PHE A  28      25.602  58.593  27.508  1.00  0.00           C  
ATOM    409  CE1 PHE A  28      28.066  57.690  28.358  1.00  0.00           C  
ATOM    410  CE2 PHE A  28      26.649  59.484  27.655  1.00  0.00           C  
ATOM    411  CZ  PHE A  28      27.883  59.031  28.080  1.00  0.00           C  
ATOM    412  H   PHE A  28      24.715  54.307  29.614  1.00  0.00           H  
ATOM    413  HA  PHE A  28      23.654  57.043  29.366  1.00  0.00           H  
ATOM    414  HB2 PHE A  28      25.043  55.331  27.315  1.00  0.00           H  
ATOM    415  HB3 PHE A  28      23.985  56.658  26.843  1.00  0.00           H  
ATOM    416  HD1 PHE A  28      27.160  55.757  28.425  1.00  0.00           H  
ATOM    417  HD2 PHE A  28      24.637  58.948  27.175  1.00  0.00           H  
ATOM    418  HE1 PHE A  28      29.029  57.334  28.690  1.00  0.00           H  
ATOM    419  HE2 PHE A  28      26.502  60.531  27.437  1.00  0.00           H  
ATOM    420  HZ  PHE A  28      28.702  59.724  28.197  1.00  0.00           H  
ATOM    421  N   PRO A  29      21.440  56.330  28.418  1.00  0.00           N  
ATOM    422  CA  PRO A  29      20.078  55.896  28.094  1.00  0.00           C  
ATOM    423  C   PRO A  29      19.962  55.371  26.666  1.00  0.00           C  
ATOM    424  O   PRO A  29      20.874  55.540  25.857  1.00  0.00           O  
ATOM    425  CB  PRO A  29      19.249  57.172  28.263  1.00  0.00           C  
ATOM    426  CG  PRO A  29      20.216  58.284  28.043  1.00  0.00           C  
ATOM    427  CD  PRO A  29      21.538  57.792  28.564  1.00  0.00           C  
ATOM    428  HA  PRO A  29      19.726  55.142  28.782  1.00  0.00           H  
ATOM    429  HB2 PRO A  29      18.454  57.187  27.530  1.00  0.00           H  
ATOM    430  HB3 PRO A  29      18.830  57.204  29.258  1.00  0.00           H  
ATOM    431  HG2 PRO A  29      20.288  58.506  26.989  1.00  0.00           H  
ATOM    432  HG3 PRO A  29      19.899  59.158  28.591  1.00  0.00           H  
ATOM    433  HD2 PRO A  29      22.348  58.185  27.969  1.00  0.00           H  
ATOM    434  HD3 PRO A  29      21.661  58.068  29.601  1.00  0.00           H  
ATOM    435  N   ASP A  30      18.835  54.736  26.364  1.00  0.00           N  
ATOM    436  CA  ASP A  30      18.600  54.187  25.034  1.00  0.00           C  
ATOM    437  C   ASP A  30      18.500  55.302  23.997  1.00  0.00           C  
ATOM    438  O   ASP A  30      19.083  55.211  22.915  1.00  0.00           O  
ATOM    439  CB  ASP A  30      17.320  53.349  25.023  1.00  0.00           C  
ATOM    440  CG  ASP A  30      17.282  52.337  26.151  1.00  0.00           C  
ATOM    441  OD1 ASP A  30      16.989  52.737  27.297  1.00  0.00           O  
ATOM    442  OD2 ASP A  30      17.545  51.144  25.888  1.00  0.00           O  
ATOM    443  H   ASP A  30      18.145  54.632  27.053  1.00  0.00           H  
ATOM    444  HA  ASP A  30      19.437  53.553  24.783  1.00  0.00           H  
ATOM    445  HB2 ASP A  30      16.468  54.004  25.124  1.00  0.00           H  
ATOM    446  HB3 ASP A  30      17.253  52.819  24.085  1.00  0.00           H  
ATOM    447  N   LYS A  31      17.760  56.352  24.333  1.00  0.00           N  
ATOM    448  CA  LYS A  31      17.584  57.485  23.432  1.00  0.00           C  
ATOM    449  C   LYS A  31      17.145  58.727  24.200  1.00  0.00           C  
ATOM    450  O   LYS A  31      16.711  58.638  25.349  1.00  0.00           O  
ATOM    451  CB  LYS A  31      16.553  57.149  22.352  1.00  0.00           C  
ATOM    452  CG  LYS A  31      15.133  57.040  22.880  1.00  0.00           C  
ATOM    453  CD  LYS A  31      14.110  57.316  21.790  1.00  0.00           C  
ATOM    454  CE  LYS A  31      12.846  56.496  21.993  1.00  0.00           C  
ATOM    455  NZ  LYS A  31      11.927  57.129  22.978  1.00  0.00           N  
ATOM    456  H   LYS A  31      17.321  56.366  25.209  1.00  0.00           H  
ATOM    457  HA  LYS A  31      18.535  57.685  22.961  1.00  0.00           H  
ATOM    458  HB2 LYS A  31      16.576  57.920  21.596  1.00  0.00           H  
ATOM    459  HB3 LYS A  31      16.819  56.205  21.898  1.00  0.00           H  
ATOM    460  HG2 LYS A  31      14.976  56.043  23.262  1.00  0.00           H  
ATOM    461  HG3 LYS A  31      14.999  57.759  23.676  1.00  0.00           H  
ATOM    462  HD2 LYS A  31      13.853  58.364  21.805  1.00  0.00           H  
ATOM    463  HD3 LYS A  31      14.543  57.063  20.832  1.00  0.00           H  
ATOM    464  HE2 LYS A  31      12.336  56.404  21.045  1.00  0.00           H  
ATOM    465  HE3 LYS A  31      13.121  55.514  22.349  1.00  0.00           H  
ATOM    466  HZ1 LYS A  31      11.247  57.746  22.488  1.00  0.00           H  
ATOM    467  HZ2 LYS A  31      12.471  57.700  23.657  1.00  0.00           H  
ATOM    468  HZ3 LYS A  31      11.402  56.398  23.499  1.00  0.00           H  
ATOM    469  N   LEU A  32      17.258  59.885  23.558  1.00  0.00           N  
ATOM    470  CA  LEU A  32      16.871  61.146  24.180  1.00  0.00           C  
ATOM    471  C   LEU A  32      15.509  61.607  23.674  1.00  0.00           C  
ATOM    472  O   LEU A  32      15.356  61.960  22.506  1.00  0.00           O  
ATOM    473  CB  LEU A  32      17.923  62.221  23.898  1.00  0.00           C  
ATOM    474  CG  LEU A  32      17.933  63.417  24.850  1.00  0.00           C  
ATOM    475  CD1 LEU A  32      16.586  64.123  24.835  1.00  0.00           C  
ATOM    476  CD2 LEU A  32      18.288  62.972  26.262  1.00  0.00           C  
ATOM    477  H   LEU A  32      17.611  59.893  22.644  1.00  0.00           H  
ATOM    478  HA  LEU A  32      16.810  60.985  25.246  1.00  0.00           H  
ATOM    479  HB2 LEU A  32      18.895  61.753  23.945  1.00  0.00           H  
ATOM    480  HB3 LEU A  32      17.752  62.594  22.897  1.00  0.00           H  
ATOM    481  HG  LEU A  32      18.683  64.123  24.522  1.00  0.00           H  
ATOM    482 HD11 LEU A  32      16.739  65.190  24.888  1.00  0.00           H  
ATOM    483 HD12 LEU A  32      16.001  63.800  25.684  1.00  0.00           H  
ATOM    484 HD13 LEU A  32      16.061  63.877  23.923  1.00  0.00           H  
ATOM    485 HD21 LEU A  32      19.195  63.467  26.577  1.00  0.00           H  
ATOM    486 HD22 LEU A  32      18.439  61.902  26.274  1.00  0.00           H  
ATOM    487 HD23 LEU A  32      17.482  63.230  26.934  1.00  0.00           H  
ATOM    488  N   ASN A  33      14.520  61.603  24.563  1.00  0.00           N  
ATOM    489  CA  ASN A  33      13.170  62.023  24.208  1.00  0.00           C  
ATOM    490  C   ASN A  33      12.961  63.503  24.518  1.00  0.00           C  
ATOM    491  O   ASN A  33      12.928  63.906  25.681  1.00  0.00           O  
ATOM    492  CB  ASN A  33      12.138  61.182  24.960  1.00  0.00           C  
ATOM    493  CG  ASN A  33      12.413  61.125  26.450  1.00  0.00           C  
ATOM    494  OD1 ASN A  33      13.414  60.557  26.887  1.00  0.00           O  
ATOM    495  ND2 ASN A  33      11.522  61.716  27.239  1.00  0.00           N  
ATOM    496  H   ASN A  33      14.704  61.312  25.481  1.00  0.00           H  
ATOM    497  HA  ASN A  33      13.044  61.868  23.147  1.00  0.00           H  
ATOM    498  HB2 ASN A  33      11.156  61.610  24.811  1.00  0.00           H  
ATOM    499  HB3 ASN A  33      12.150  60.175  24.571  1.00  0.00           H  
ATOM    500 HD21 ASN A  33      10.748  62.149  26.821  1.00  0.00           H  
ATOM    501 HD22 ASN A  33      11.675  61.695  28.207  1.00  0.00           H  
ATOM    502  N   PHE A  34      12.818  64.306  23.470  1.00  0.00           N  
ATOM    503  CA  PHE A  34      12.612  65.741  23.628  1.00  0.00           C  
ATOM    504  C   PHE A  34      11.143  66.105  23.430  1.00  0.00           C  
ATOM    505  O   PHE A  34      10.625  66.057  22.315  1.00  0.00           O  
ATOM    506  CB  PHE A  34      13.478  66.517  22.634  1.00  0.00           C  
ATOM    507  CG  PHE A  34      14.783  66.984  23.214  1.00  0.00           C  
ATOM    508  CD1 PHE A  34      14.808  67.965  24.192  1.00  0.00           C  
ATOM    509  CD2 PHE A  34      15.983  66.443  22.781  1.00  0.00           C  
ATOM    510  CE1 PHE A  34      16.007  68.398  24.727  1.00  0.00           C  
ATOM    511  CE2 PHE A  34      17.184  66.872  23.313  1.00  0.00           C  
ATOM    512  CZ  PHE A  34      17.197  67.850  24.287  1.00  0.00           C  
ATOM    513  H   PHE A  34      12.853  63.926  22.566  1.00  0.00           H  
ATOM    514  HA  PHE A  34      12.903  66.007  24.632  1.00  0.00           H  
ATOM    515  HB2 PHE A  34      13.700  65.881  21.790  1.00  0.00           H  
ATOM    516  HB3 PHE A  34      12.934  67.384  22.294  1.00  0.00           H  
ATOM    517  HD1 PHE A  34      13.879  68.394  24.539  1.00  0.00           H  
ATOM    518  HD2 PHE A  34      15.974  65.677  22.019  1.00  0.00           H  
ATOM    519  HE1 PHE A  34      16.014  69.163  25.490  1.00  0.00           H  
ATOM    520  HE2 PHE A  34      18.112  66.441  22.966  1.00  0.00           H  
ATOM    521  HZ  PHE A  34      18.134  68.187  24.704  1.00  0.00           H  
ATOM    522  N   SER A  35      10.477  66.468  24.523  1.00  0.00           N  
ATOM    523  CA  SER A  35       9.067  66.836  24.471  1.00  0.00           C  
ATOM    524  C   SER A  35       8.821  67.898  23.404  1.00  0.00           C  
ATOM    525  O   SER A  35       9.758  68.397  22.779  1.00  0.00           O  
ATOM    526  CB  SER A  35       8.602  67.349  25.834  1.00  0.00           C  
ATOM    527  OG  SER A  35       9.386  68.450  26.259  1.00  0.00           O  
ATOM    528  H   SER A  35      10.945  66.486  25.383  1.00  0.00           H  
ATOM    529  HA  SER A  35       8.502  65.950  24.217  1.00  0.00           H  
ATOM    530  HB2 SER A  35       7.570  67.661  25.766  1.00  0.00           H  
ATOM    531  HB3 SER A  35       8.690  66.556  26.563  1.00  0.00           H  
ATOM    532  HG  SER A  35      10.266  68.146  26.489  1.00  0.00           H  
ATOM    533  N   THR A  36       7.553  68.240  23.199  1.00  0.00           N  
ATOM    534  CA  THR A  36       7.181  69.242  22.208  1.00  0.00           C  
ATOM    535  C   THR A  36       7.961  70.535  22.415  1.00  0.00           C  
ATOM    536  O   THR A  36       7.693  71.292  23.349  1.00  0.00           O  
ATOM    537  CB  THR A  36       5.674  69.552  22.260  1.00  0.00           C  
ATOM    538  OG1 THR A  36       4.927  68.335  22.356  1.00  0.00           O  
ATOM    539  CG2 THR A  36       5.237  70.324  21.024  1.00  0.00           C  
ATOM    540  H   THR A  36       6.850  67.807  23.729  1.00  0.00           H  
ATOM    541  HA  THR A  36       7.413  68.845  21.231  1.00  0.00           H  
ATOM    542  HB  THR A  36       5.476  70.157  23.133  1.00  0.00           H  
ATOM    543  HG1 THR A  36       4.206  68.450  22.980  1.00  0.00           H  
ATOM    544 HG21 THR A  36       5.715  71.292  21.017  1.00  0.00           H  
ATOM    545 HG22 THR A  36       4.165  70.452  21.039  1.00  0.00           H  
ATOM    546 HG23 THR A  36       5.521  69.776  20.138  1.00  0.00           H  
ATOM    547  N   CYS A  37       8.928  70.785  21.538  1.00  0.00           N  
ATOM    548  CA  CYS A  37       9.748  71.988  21.625  1.00  0.00           C  
ATOM    549  C   CYS A  37       9.544  72.873  20.400  1.00  0.00           C  
ATOM    550  O   CYS A  37       9.022  72.443  19.371  1.00  0.00           O  
ATOM    551  CB  CYS A  37      11.224  71.615  21.760  1.00  0.00           C  
ATOM    552  SG  CYS A  37      11.807  71.518  23.468  1.00  0.00           S  
ATOM    553  H   CYS A  37       9.094  70.145  20.815  1.00  0.00           H  
ATOM    554  HA  CYS A  37       9.441  72.535  22.504  1.00  0.00           H  
ATOM    555  HB2 CYS A  37      11.388  70.651  21.303  1.00  0.00           H  
ATOM    556  HB3 CYS A  37      11.823  72.355  21.248  1.00  0.00           H  
ATOM    557  HG  CYS A  37      11.084  70.603  24.096  1.00  0.00           H  
ATOM    558  N   PRO A  38       9.965  74.142  20.510  1.00  0.00           N  
ATOM    559  CA  PRO A  38       9.839  75.116  19.422  1.00  0.00           C  
ATOM    560  C   PRO A  38      10.770  74.806  18.255  1.00  0.00           C  
ATOM    561  O   PRO A  38      11.908  74.381  18.453  1.00  0.00           O  
ATOM    562  CB  PRO A  38      10.231  76.440  20.082  1.00  0.00           C  
ATOM    563  CG  PRO A  38      11.113  76.049  21.218  1.00  0.00           C  
ATOM    564  CD  PRO A  38      10.596  74.724  21.706  1.00  0.00           C  
ATOM    565  HA  PRO A  38       8.822  75.179  19.062  1.00  0.00           H  
ATOM    566  HB2 PRO A  38      10.756  77.060  19.369  1.00  0.00           H  
ATOM    567  HB3 PRO A  38       9.345  76.951  20.428  1.00  0.00           H  
ATOM    568  HG2 PRO A  38      12.131  75.951  20.876  1.00  0.00           H  
ATOM    569  HG3 PRO A  38      11.048  76.789  22.003  1.00  0.00           H  
ATOM    570  HD2 PRO A  38      11.412  74.106  22.052  1.00  0.00           H  
ATOM    571  HD3 PRO A  38       9.871  74.869  22.493  1.00  0.00           H  
ATOM    572  N   VAL A  39      10.280  75.021  17.039  1.00  0.00           N  
ATOM    573  CA  VAL A  39      11.070  74.766  15.840  1.00  0.00           C  
ATOM    574  C   VAL A  39      12.230  75.748  15.727  1.00  0.00           C  
ATOM    575  O   VAL A  39      13.396  75.353  15.731  1.00  0.00           O  
ATOM    576  CB  VAL A  39      10.206  74.860  14.568  1.00  0.00           C  
ATOM    577  CG1 VAL A  39       9.391  76.144  14.570  1.00  0.00           C  
ATOM    578  CG2 VAL A  39      11.079  74.774  13.324  1.00  0.00           C  
ATOM    579  H   VAL A  39       9.366  75.361  16.945  1.00  0.00           H  
ATOM    580  HA  VAL A  39      11.465  73.763  15.908  1.00  0.00           H  
ATOM    581  HB  VAL A  39       9.521  74.025  14.560  1.00  0.00           H  
ATOM    582 HG11 VAL A  39       9.262  76.487  15.586  1.00  0.00           H  
ATOM    583 HG12 VAL A  39       9.908  76.899  13.996  1.00  0.00           H  
ATOM    584 HG13 VAL A  39       8.423  75.956  14.129  1.00  0.00           H  
ATOM    585 HG21 VAL A  39      10.461  74.870  12.444  1.00  0.00           H  
ATOM    586 HG22 VAL A  39      11.808  75.570  13.342  1.00  0.00           H  
ATOM    587 HG23 VAL A  39      11.587  73.821  13.306  1.00  0.00           H  
ATOM    588  N   LYS A  40      11.904  77.032  15.627  1.00  0.00           N  
ATOM    589  CA  LYS A  40      12.917  78.074  15.515  1.00  0.00           C  
ATOM    590  C   LYS A  40      13.832  78.078  16.736  1.00  0.00           C  
ATOM    591  O   LYS A  40      15.033  77.828  16.625  1.00  0.00           O  
ATOM    592  CB  LYS A  40      12.255  79.445  15.356  1.00  0.00           C  
ATOM    593  CG  LYS A  40      12.140  79.901  13.913  1.00  0.00           C  
ATOM    594  CD  LYS A  40      11.100  79.095  13.154  1.00  0.00           C  
ATOM    595  CE  LYS A  40       9.701  79.333  13.701  1.00  0.00           C  
ATOM    596  NZ  LYS A  40       8.648  78.919  12.734  1.00  0.00           N  
ATOM    597  H   LYS A  40      10.956  77.286  15.630  1.00  0.00           H  
ATOM    598  HA  LYS A  40      13.510  77.867  14.637  1.00  0.00           H  
ATOM    599  HB2 LYS A  40      11.262  79.403  15.778  1.00  0.00           H  
ATOM    600  HB3 LYS A  40      12.836  80.177  15.898  1.00  0.00           H  
ATOM    601  HG2 LYS A  40      11.855  80.943  13.895  1.00  0.00           H  
ATOM    602  HG3 LYS A  40      13.100  79.780  13.429  1.00  0.00           H  
ATOM    603  HD2 LYS A  40      11.121  79.384  12.113  1.00  0.00           H  
ATOM    604  HD3 LYS A  40      11.337  78.044  13.241  1.00  0.00           H  
ATOM    605  HE2 LYS A  40       9.584  78.767  14.612  1.00  0.00           H  
ATOM    606  HE3 LYS A  40       9.588  80.386  13.915  1.00  0.00           H  
ATOM    607  HZ1 LYS A  40       8.230  79.756  12.279  1.00  0.00           H  
ATOM    608  HZ2 LYS A  40       7.897  78.394  13.226  1.00  0.00           H  
ATOM    609  HZ3 LYS A  40       9.059  78.307  12.000  1.00  0.00           H  
ATOM    610  N   TYR A  41      13.257  78.362  17.899  1.00  0.00           N  
ATOM    611  CA  TYR A  41      14.020  78.398  19.141  1.00  0.00           C  
ATOM    612  C   TYR A  41      14.823  77.114  19.324  1.00  0.00           C  
ATOM    613  O   TYR A  41      14.463  76.063  18.796  1.00  0.00           O  
ATOM    614  CB  TYR A  41      13.084  78.602  20.333  1.00  0.00           C  
ATOM    615  CG  TYR A  41      12.443  79.972  20.372  1.00  0.00           C  
ATOM    616  CD1 TYR A  41      13.124  81.065  20.891  1.00  0.00           C  
ATOM    617  CD2 TYR A  41      11.154  80.170  19.892  1.00  0.00           C  
ATOM    618  CE1 TYR A  41      12.542  82.317  20.930  1.00  0.00           C  
ATOM    619  CE2 TYR A  41      10.565  81.419  19.924  1.00  0.00           C  
ATOM    620  CZ  TYR A  41      11.263  82.489  20.444  1.00  0.00           C  
ATOM    621  OH  TYR A  41      10.678  83.735  20.481  1.00  0.00           O  
ATOM    622  H   TYR A  41      12.295  78.553  17.923  1.00  0.00           H  
ATOM    623  HA  TYR A  41      14.703  79.233  19.085  1.00  0.00           H  
ATOM    624  HB2 TYR A  41      12.294  77.868  20.292  1.00  0.00           H  
ATOM    625  HB3 TYR A  41      13.643  78.472  21.248  1.00  0.00           H  
ATOM    626  HD1 TYR A  41      14.127  80.927  21.270  1.00  0.00           H  
ATOM    627  HD2 TYR A  41      10.610  79.330  19.485  1.00  0.00           H  
ATOM    628  HE1 TYR A  41      13.089  83.155  21.337  1.00  0.00           H  
ATOM    629  HE2 TYR A  41       9.562  81.554  19.545  1.00  0.00           H  
ATOM    630  HH  TYR A  41      11.275  84.380  20.093  1.00  0.00           H  
ATOM    631  N   SER A  42      15.913  77.210  20.078  1.00  0.00           N  
ATOM    632  CA  SER A  42      16.771  76.057  20.331  1.00  0.00           C  
ATOM    633  C   SER A  42      16.340  75.326  21.598  1.00  0.00           C  
ATOM    634  O   SER A  42      15.756  75.921  22.506  1.00  0.00           O  
ATOM    635  CB  SER A  42      18.231  76.499  20.454  1.00  0.00           C  
ATOM    636  OG  SER A  42      19.058  75.420  20.855  1.00  0.00           O  
ATOM    637  H   SER A  42      16.148  78.076  20.473  1.00  0.00           H  
ATOM    638  HA  SER A  42      16.677  75.384  19.492  1.00  0.00           H  
ATOM    639  HB2 SER A  42      18.575  76.865  19.498  1.00  0.00           H  
ATOM    640  HB3 SER A  42      18.304  77.287  21.190  1.00  0.00           H  
ATOM    641  HG  SER A  42      18.640  74.949  21.579  1.00  0.00           H  
ATOM    642  N   THR A  43      16.633  74.031  21.656  1.00  0.00           N  
ATOM    643  CA  THR A  43      16.276  73.217  22.811  1.00  0.00           C  
ATOM    644  C   THR A  43      17.514  72.609  23.460  1.00  0.00           C  
ATOM    645  O   THR A  43      18.512  72.348  22.788  1.00  0.00           O  
ATOM    646  CB  THR A  43      15.305  72.086  22.423  1.00  0.00           C  
ATOM    647  OG1 THR A  43      14.026  72.632  22.086  1.00  0.00           O  
ATOM    648  CG2 THR A  43      15.153  71.088  23.561  1.00  0.00           C  
ATOM    649  H   THR A  43      17.100  73.614  20.902  1.00  0.00           H  
ATOM    650  HA  THR A  43      15.783  73.855  23.529  1.00  0.00           H  
ATOM    651  HB  THR A  43      15.706  71.569  21.562  1.00  0.00           H  
ATOM    652  HG1 THR A  43      14.095  73.131  21.269  1.00  0.00           H  
ATOM    653 HG21 THR A  43      15.063  71.621  24.495  1.00  0.00           H  
ATOM    654 HG22 THR A  43      16.021  70.446  23.595  1.00  0.00           H  
ATOM    655 HG23 THR A  43      14.268  70.491  23.400  1.00  0.00           H  
ATOM    656  N   GLN A  44      17.443  72.385  24.767  1.00  0.00           N  
ATOM    657  CA  GLN A  44      18.559  71.807  25.506  1.00  0.00           C  
ATOM    658  C   GLN A  44      18.060  70.884  26.612  1.00  0.00           C  
ATOM    659  O   GLN A  44      16.892  70.934  26.998  1.00  0.00           O  
ATOM    660  CB  GLN A  44      19.431  72.914  26.102  1.00  0.00           C  
ATOM    661  CG  GLN A  44      20.552  73.369  25.182  1.00  0.00           C  
ATOM    662  CD  GLN A  44      20.851  74.849  25.313  1.00  0.00           C  
ATOM    663  OE1 GLN A  44      21.419  75.293  26.311  1.00  0.00           O  
ATOM    664  NE2 GLN A  44      20.471  75.622  24.303  1.00  0.00           N  
ATOM    665  H   GLN A  44      16.620  72.615  25.247  1.00  0.00           H  
ATOM    666  HA  GLN A  44      19.152  71.230  24.812  1.00  0.00           H  
ATOM    667  HB2 GLN A  44      18.807  73.767  26.323  1.00  0.00           H  
ATOM    668  HB3 GLN A  44      19.872  72.553  27.019  1.00  0.00           H  
ATOM    669  HG2 GLN A  44      21.447  72.813  25.423  1.00  0.00           H  
ATOM    670  HG3 GLN A  44      20.267  73.163  24.161  1.00  0.00           H  
ATOM    671 HE21 GLN A  44      20.022  75.199  23.540  1.00  0.00           H  
ATOM    672 HE22 GLN A  44      20.651  76.583  24.362  1.00  0.00           H  
ATOM    673  N   LYS A  45      18.953  70.041  27.120  1.00  0.00           N  
ATOM    674  CA  LYS A  45      18.606  69.107  28.183  1.00  0.00           C  
ATOM    675  C   LYS A  45      19.857  68.608  28.900  1.00  0.00           C  
ATOM    676  O   LYS A  45      20.955  68.640  28.345  1.00  0.00           O  
ATOM    677  CB  LYS A  45      17.825  67.921  27.613  1.00  0.00           C  
ATOM    678  CG  LYS A  45      16.928  67.236  28.630  1.00  0.00           C  
ATOM    679  CD  LYS A  45      15.936  66.302  27.959  1.00  0.00           C  
ATOM    680  CE  LYS A  45      14.712  67.054  27.459  1.00  0.00           C  
ATOM    681  NZ  LYS A  45      13.757  67.355  28.562  1.00  0.00           N  
ATOM    682  H   LYS A  45      19.870  70.049  26.770  1.00  0.00           H  
ATOM    683  HA  LYS A  45      17.983  69.629  28.893  1.00  0.00           H  
ATOM    684  HB2 LYS A  45      17.208  68.270  26.797  1.00  0.00           H  
ATOM    685  HB3 LYS A  45      18.527  67.191  27.235  1.00  0.00           H  
ATOM    686  HG2 LYS A  45      17.541  66.665  29.310  1.00  0.00           H  
ATOM    687  HG3 LYS A  45      16.383  67.990  29.181  1.00  0.00           H  
ATOM    688  HD2 LYS A  45      16.417  65.822  27.120  1.00  0.00           H  
ATOM    689  HD3 LYS A  45      15.621  65.553  28.672  1.00  0.00           H  
ATOM    690  HE2 LYS A  45      15.034  67.981  27.010  1.00  0.00           H  
ATOM    691  HE3 LYS A  45      14.213  66.449  26.717  1.00  0.00           H  
ATOM    692  HZ1 LYS A  45      12.795  67.462  28.182  1.00  0.00           H  
ATOM    693  HZ2 LYS A  45      14.031  68.237  29.039  1.00  0.00           H  
ATOM    694  HZ3 LYS A  45      13.761  66.582  29.257  1.00  0.00           H  
ATOM    695  N   ILE A  46      19.681  68.146  30.134  1.00  0.00           N  
ATOM    696  CA  ILE A  46      20.796  67.639  30.924  1.00  0.00           C  
ATOM    697  C   ILE A  46      20.755  66.118  31.019  1.00  0.00           C  
ATOM    698  O   ILE A  46      19.695  65.526  31.228  1.00  0.00           O  
ATOM    699  CB  ILE A  46      20.794  68.232  32.345  1.00  0.00           C  
ATOM    700  CG1 ILE A  46      20.945  69.753  32.287  1.00  0.00           C  
ATOM    701  CG2 ILE A  46      21.909  67.615  33.178  1.00  0.00           C  
ATOM    702  CD1 ILE A  46      22.269  70.208  31.715  1.00  0.00           C  
ATOM    703  H   ILE A  46      18.782  68.147  30.521  1.00  0.00           H  
ATOM    704  HA  ILE A  46      21.714  67.933  30.434  1.00  0.00           H  
ATOM    705  HB  ILE A  46      19.853  67.987  32.812  1.00  0.00           H  
ATOM    706 HG12 ILE A  46      20.160  70.163  31.673  1.00  0.00           H  
ATOM    707 HG13 ILE A  46      20.861  70.154  33.288  1.00  0.00           H  
ATOM    708 HG21 ILE A  46      22.119  68.251  34.025  1.00  0.00           H  
ATOM    709 HG22 ILE A  46      21.600  66.641  33.528  1.00  0.00           H  
ATOM    710 HG23 ILE A  46      22.797  67.515  32.572  1.00  0.00           H  
ATOM    711 HD11 ILE A  46      22.435  71.244  31.971  1.00  0.00           H  
ATOM    712 HD12 ILE A  46      23.065  69.605  32.124  1.00  0.00           H  
ATOM    713 HD13 ILE A  46      22.252  70.102  30.640  1.00  0.00           H  
ATOM    714  N   LEU A  47      21.915  65.489  30.867  1.00  0.00           N  
ATOM    715  CA  LEU A  47      22.013  64.035  30.937  1.00  0.00           C  
ATOM    716  C   LEU A  47      23.067  63.609  31.954  1.00  0.00           C  
ATOM    717  O   LEU A  47      24.267  63.756  31.719  1.00  0.00           O  
ATOM    718  CB  LEU A  47      22.353  63.459  29.562  1.00  0.00           C  
ATOM    719  CG  LEU A  47      23.054  62.101  29.557  1.00  0.00           C  
ATOM    720  CD1 LEU A  47      22.116  61.014  30.057  1.00  0.00           C  
ATOM    721  CD2 LEU A  47      23.563  61.768  28.163  1.00  0.00           C  
ATOM    722  H   LEU A  47      22.726  66.013  30.703  1.00  0.00           H  
ATOM    723  HA  LEU A  47      21.052  63.654  31.251  1.00  0.00           H  
ATOM    724  HB2 LEU A  47      21.431  63.357  29.009  1.00  0.00           H  
ATOM    725  HB3 LEU A  47      22.997  64.167  29.058  1.00  0.00           H  
ATOM    726  HG  LEU A  47      23.904  62.140  30.224  1.00  0.00           H  
ATOM    727 HD11 LEU A  47      22.202  60.931  31.130  1.00  0.00           H  
ATOM    728 HD12 LEU A  47      22.380  60.072  29.601  1.00  0.00           H  
ATOM    729 HD13 LEU A  47      21.099  61.268  29.796  1.00  0.00           H  
ATOM    730 HD21 LEU A  47      24.245  62.539  27.835  1.00  0.00           H  
ATOM    731 HD22 LEU A  47      22.729  61.711  27.479  1.00  0.00           H  
ATOM    732 HD23 LEU A  47      24.076  60.817  28.184  1.00  0.00           H  
ATOM    733  N   LEU A  48      22.611  63.080  33.084  1.00  0.00           N  
ATOM    734  CA  LEU A  48      23.515  62.629  34.136  1.00  0.00           C  
ATOM    735  C   LEU A  48      24.199  61.323  33.745  1.00  0.00           C  
ATOM    736  O   LEU A  48      23.600  60.465  33.097  1.00  0.00           O  
ATOM    737  CB  LEU A  48      22.750  62.443  35.449  1.00  0.00           C  
ATOM    738  CG  LEU A  48      23.593  62.443  36.724  1.00  0.00           C  
ATOM    739  CD1 LEU A  48      23.705  63.849  37.291  1.00  0.00           C  
ATOM    740  CD2 LEU A  48      22.999  61.496  37.756  1.00  0.00           C  
ATOM    741  H   LEU A  48      21.644  62.988  33.215  1.00  0.00           H  
ATOM    742  HA  LEU A  48      24.269  63.389  34.275  1.00  0.00           H  
ATOM    743  HB2 LEU A  48      22.031  63.244  35.528  1.00  0.00           H  
ATOM    744  HB3 LEU A  48      22.228  61.498  35.395  1.00  0.00           H  
ATOM    745  HG  LEU A  48      24.591  62.098  36.488  1.00  0.00           H  
ATOM    746 HD11 LEU A  48      24.514  63.887  38.003  1.00  0.00           H  
ATOM    747 HD12 LEU A  48      22.780  64.114  37.782  1.00  0.00           H  
ATOM    748 HD13 LEU A  48      23.899  64.546  36.488  1.00  0.00           H  
ATOM    749 HD21 LEU A  48      22.244  60.880  37.288  1.00  0.00           H  
ATOM    750 HD22 LEU A  48      22.550  62.070  38.554  1.00  0.00           H  
ATOM    751 HD23 LEU A  48      23.779  60.867  38.159  1.00  0.00           H  
ATOM    752  N   VAL A  49      25.459  61.179  34.145  1.00  0.00           N  
ATOM    753  CA  VAL A  49      26.225  59.977  33.838  1.00  0.00           C  
ATOM    754  C   VAL A  49      27.123  59.586  35.006  1.00  0.00           C  
ATOM    755  O   VAL A  49      27.905  60.398  35.501  1.00  0.00           O  
ATOM    756  CB  VAL A  49      27.092  60.169  32.579  1.00  0.00           C  
ATOM    757  CG1 VAL A  49      27.666  58.838  32.119  1.00  0.00           C  
ATOM    758  CG2 VAL A  49      26.282  60.822  31.470  1.00  0.00           C  
ATOM    759  H   VAL A  49      25.884  61.898  34.658  1.00  0.00           H  
ATOM    760  HA  VAL A  49      25.526  59.175  33.650  1.00  0.00           H  
ATOM    761  HB  VAL A  49      27.914  60.823  32.830  1.00  0.00           H  
ATOM    762 HG11 VAL A  49      27.562  58.108  32.908  1.00  0.00           H  
ATOM    763 HG12 VAL A  49      27.134  58.500  31.241  1.00  0.00           H  
ATOM    764 HG13 VAL A  49      28.712  58.961  31.880  1.00  0.00           H  
ATOM    765 HG21 VAL A  49      25.378  60.256  31.301  1.00  0.00           H  
ATOM    766 HG22 VAL A  49      26.027  61.831  31.759  1.00  0.00           H  
ATOM    767 HG23 VAL A  49      26.867  60.846  30.562  1.00  0.00           H  
ATOM    768  N   ARG A  50      27.008  58.335  35.441  1.00  0.00           N  
ATOM    769  CA  ARG A  50      27.810  57.835  36.551  1.00  0.00           C  
ATOM    770  C   ARG A  50      28.722  56.699  36.097  1.00  0.00           C  
ATOM    771  O   ARG A  50      28.252  55.668  35.616  1.00  0.00           O  
ATOM    772  CB  ARG A  50      26.904  57.353  37.686  1.00  0.00           C  
ATOM    773  CG  ARG A  50      27.665  56.888  38.917  1.00  0.00           C  
ATOM    774  CD  ARG A  50      26.901  55.812  39.671  1.00  0.00           C  
ATOM    775  NE  ARG A  50      26.015  56.377  40.685  1.00  0.00           N  
ATOM    776  CZ  ARG A  50      24.936  55.754  41.148  1.00  0.00           C  
ATOM    777  NH1 ARG A  50      24.614  54.552  40.691  1.00  0.00           N  
ATOM    778  NH2 ARG A  50      24.179  56.333  42.071  1.00  0.00           N  
ATOM    779  H   ARG A  50      26.369  57.734  35.006  1.00  0.00           H  
ATOM    780  HA  ARG A  50      28.421  58.649  36.912  1.00  0.00           H  
ATOM    781  HB2 ARG A  50      26.250  58.162  37.978  1.00  0.00           H  
ATOM    782  HB3 ARG A  50      26.306  56.529  37.327  1.00  0.00           H  
ATOM    783  HG2 ARG A  50      28.620  56.489  38.610  1.00  0.00           H  
ATOM    784  HG3 ARG A  50      27.820  57.733  39.572  1.00  0.00           H  
ATOM    785  HD2 ARG A  50      26.310  55.247  38.964  1.00  0.00           H  
ATOM    786  HD3 ARG A  50      27.610  55.155  40.152  1.00  0.00           H  
ATOM    787  HE  ARG A  50      26.235  57.265  41.036  1.00  0.00           H  
ATOM    788 HH11 ARG A  50      25.183  54.112  39.997  1.00  0.00           H  
ATOM    789 HH12 ARG A  50      23.802  54.084  41.043  1.00  0.00           H  
ATOM    790 HH21 ARG A  50      24.420  57.240  42.417  1.00  0.00           H  
ATOM    791 HH22 ARG A  50      23.369  55.864  42.419  1.00  0.00           H  
ATOM    792  N   ASN A  51      30.027  56.897  36.250  1.00  0.00           N  
ATOM    793  CA  ASN A  51      31.005  55.890  35.853  1.00  0.00           C  
ATOM    794  C   ASN A  51      30.756  54.574  36.585  1.00  0.00           C  
ATOM    795  O   ASN A  51      30.883  54.497  37.807  1.00  0.00           O  
ATOM    796  CB  ASN A  51      32.424  56.385  36.140  1.00  0.00           C  
ATOM    797  CG  ASN A  51      33.468  55.308  35.921  1.00  0.00           C  
ATOM    798  OD1 ASN A  51      33.286  54.161  36.330  1.00  0.00           O  
ATOM    799  ND2 ASN A  51      34.569  55.673  35.275  1.00  0.00           N  
ATOM    800  H   ASN A  51      30.341  57.740  36.639  1.00  0.00           H  
ATOM    801  HA  ASN A  51      30.898  55.725  34.792  1.00  0.00           H  
ATOM    802  HB2 ASN A  51      32.647  57.215  35.485  1.00  0.00           H  
ATOM    803  HB3 ASN A  51      32.482  56.716  37.166  1.00  0.00           H  
ATOM    804 HD21 ASN A  51      34.644  56.605  34.979  1.00  0.00           H  
ATOM    805 HD22 ASN A  51      35.260  54.996  35.119  1.00  0.00           H  
ATOM    806  N   ILE A  52      30.403  53.541  35.828  1.00  0.00           N  
ATOM    807  CA  ILE A  52      30.140  52.228  36.402  1.00  0.00           C  
ATOM    808  C   ILE A  52      31.327  51.292  36.204  1.00  0.00           C  
ATOM    809  O   ILE A  52      31.481  50.306  36.924  1.00  0.00           O  
ATOM    810  CB  ILE A  52      28.885  51.584  35.784  1.00  0.00           C  
ATOM    811  CG1 ILE A  52      29.031  51.487  34.264  1.00  0.00           C  
ATOM    812  CG2 ILE A  52      27.644  52.383  36.151  1.00  0.00           C  
ATOM    813  CD1 ILE A  52      27.924  50.699  33.599  1.00  0.00           C  
ATOM    814  H   ILE A  52      30.320  53.664  34.859  1.00  0.00           H  
ATOM    815  HA  ILE A  52      29.969  52.356  37.462  1.00  0.00           H  
ATOM    816  HB  ILE A  52      28.778  50.590  36.193  1.00  0.00           H  
ATOM    817 HG12 ILE A  52      29.028  52.480  33.843  1.00  0.00           H  
ATOM    818 HG13 ILE A  52      29.969  51.004  34.030  1.00  0.00           H  
ATOM    819 HG21 ILE A  52      26.986  52.440  35.297  1.00  0.00           H  
ATOM    820 HG22 ILE A  52      27.132  51.896  36.968  1.00  0.00           H  
ATOM    821 HG23 ILE A  52      27.932  53.379  36.450  1.00  0.00           H  
ATOM    822 HD11 ILE A  52      27.019  50.786  34.184  1.00  0.00           H  
ATOM    823 HD12 ILE A  52      27.749  51.088  32.607  1.00  0.00           H  
ATOM    824 HD13 ILE A  52      28.210  49.660  33.534  1.00  0.00           H  
ATOM    825  N   GLY A  53      32.167  51.610  35.224  1.00  0.00           N  
ATOM    826  CA  GLY A  53      33.332  50.789  34.949  1.00  0.00           C  
ATOM    827  C   GLY A  53      34.200  50.586  36.175  1.00  0.00           C  
ATOM    828  O   GLY A  53      33.808  50.938  37.287  1.00  0.00           O  
ATOM    829  H   GLY A  53      31.995  52.409  34.682  1.00  0.00           H  
ATOM    830  HA2 GLY A  53      33.003  49.825  34.590  1.00  0.00           H  
ATOM    831  HA3 GLY A  53      33.922  51.267  34.180  1.00  0.00           H  
ATOM    832  N   ASN A  54      35.382  50.013  35.973  1.00  0.00           N  
ATOM    833  CA  ASN A  54      36.308  49.761  37.072  1.00  0.00           C  
ATOM    834  C   ASN A  54      37.456  50.765  37.057  1.00  0.00           C  
ATOM    835  O   ASN A  54      38.008  51.109  38.103  1.00  0.00           O  
ATOM    836  CB  ASN A  54      36.859  48.336  36.986  1.00  0.00           C  
ATOM    837  CG  ASN A  54      38.148  48.167  37.766  1.00  0.00           C  
ATOM    838  OD1 ASN A  54      38.250  48.591  38.917  1.00  0.00           O  
ATOM    839  ND2 ASN A  54      39.140  47.544  37.141  1.00  0.00           N  
ATOM    840  H   ASN A  54      35.639  49.754  35.064  1.00  0.00           H  
ATOM    841  HA  ASN A  54      35.761  49.870  37.997  1.00  0.00           H  
ATOM    842  HB2 ASN A  54      36.127  47.648  37.383  1.00  0.00           H  
ATOM    843  HB3 ASN A  54      37.051  48.092  35.951  1.00  0.00           H  
ATOM    844 HD21 ASN A  54      38.987  47.232  36.224  1.00  0.00           H  
ATOM    845 HD22 ASN A  54      39.985  47.420  37.622  1.00  0.00           H  
ATOM    846  N   LYS A  55      37.812  51.231  35.865  1.00  0.00           N  
ATOM    847  CA  LYS A  55      38.893  52.197  35.712  1.00  0.00           C  
ATOM    848  C   LYS A  55      38.403  53.455  35.003  1.00  0.00           C  
ATOM    849  O   LYS A  55      37.258  53.521  34.558  1.00  0.00           O  
ATOM    850  CB  LYS A  55      40.052  51.576  34.929  1.00  0.00           C  
ATOM    851  CG  LYS A  55      41.421  52.016  35.418  1.00  0.00           C  
ATOM    852  CD  LYS A  55      42.429  52.068  34.283  1.00  0.00           C  
ATOM    853  CE  LYS A  55      43.087  50.714  34.059  1.00  0.00           C  
ATOM    854  NZ  LYS A  55      43.928  50.702  32.831  1.00  0.00           N  
ATOM    855  H   LYS A  55      37.333  50.918  35.068  1.00  0.00           H  
ATOM    856  HA  LYS A  55      39.240  52.466  36.698  1.00  0.00           H  
ATOM    857  HB2 LYS A  55      39.992  50.501  35.012  1.00  0.00           H  
ATOM    858  HB3 LYS A  55      39.958  51.855  33.890  1.00  0.00           H  
ATOM    859  HG2 LYS A  55      41.339  53.000  35.856  1.00  0.00           H  
ATOM    860  HG3 LYS A  55      41.769  51.316  36.164  1.00  0.00           H  
ATOM    861  HD2 LYS A  55      41.922  52.362  33.376  1.00  0.00           H  
ATOM    862  HD3 LYS A  55      43.192  52.794  34.522  1.00  0.00           H  
ATOM    863  HE2 LYS A  55      43.707  50.485  34.912  1.00  0.00           H  
ATOM    864  HE3 LYS A  55      42.315  49.965  33.964  1.00  0.00           H  
ATOM    865  HZ1 LYS A  55      43.545  50.027  32.141  1.00  0.00           H  
ATOM    866  HZ2 LYS A  55      44.903  50.424  33.068  1.00  0.00           H  
ATOM    867  HZ3 LYS A  55      43.946  51.649  32.400  1.00  0.00           H  
ATOM    868  N   ASN A  56      39.278  54.451  34.901  1.00  0.00           N  
ATOM    869  CA  ASN A  56      38.934  55.707  34.244  1.00  0.00           C  
ATOM    870  C   ASN A  56      38.373  55.454  32.848  1.00  0.00           C  
ATOM    871  O   ASN A  56      38.999  54.785  32.028  1.00  0.00           O  
ATOM    872  CB  ASN A  56      40.162  56.614  34.157  1.00  0.00           C  
ATOM    873  CG  ASN A  56      41.028  56.301  32.951  1.00  0.00           C  
ATOM    874  OD1 ASN A  56      41.486  55.171  32.779  1.00  0.00           O  
ATOM    875  ND2 ASN A  56      41.254  57.302  32.109  1.00  0.00           N  
ATOM    876  H   ASN A  56      40.176  54.339  35.276  1.00  0.00           H  
ATOM    877  HA  ASN A  56      38.178  56.196  34.840  1.00  0.00           H  
ATOM    878  HB2 ASN A  56      39.839  57.642  34.086  1.00  0.00           H  
ATOM    879  HB3 ASN A  56      40.759  56.489  35.048  1.00  0.00           H  
ATOM    880 HD21 ASN A  56      40.858  58.176  32.311  1.00  0.00           H  
ATOM    881 HD22 ASN A  56      41.810  57.128  31.321  1.00  0.00           H  
ATOM    882  N   ALA A  57      37.188  55.997  32.586  1.00  0.00           N  
ATOM    883  CA  ALA A  57      36.543  55.833  31.288  1.00  0.00           C  
ATOM    884  C   ALA A  57      36.646  57.109  30.460  1.00  0.00           C  
ATOM    885  O   ALA A  57      36.386  58.206  30.955  1.00  0.00           O  
ATOM    886  CB  ALA A  57      35.086  55.435  31.469  1.00  0.00           C  
ATOM    887  H   ALA A  57      36.738  56.521  33.281  1.00  0.00           H  
ATOM    888  HA  ALA A  57      37.047  55.035  30.764  1.00  0.00           H  
ATOM    889  HB1 ALA A  57      34.472  56.322  31.501  1.00  0.00           H  
ATOM    890  HB2 ALA A  57      34.778  54.813  30.641  1.00  0.00           H  
ATOM    891  HB3 ALA A  57      34.976  54.886  32.393  1.00  0.00           H  
ATOM    892  N   VAL A  58      37.027  56.960  29.196  1.00  0.00           N  
ATOM    893  CA  VAL A  58      37.163  58.101  28.298  1.00  0.00           C  
ATOM    894  C   VAL A  58      36.259  57.953  27.080  1.00  0.00           C  
ATOM    895  O   VAL A  58      36.555  57.187  26.162  1.00  0.00           O  
ATOM    896  CB  VAL A  58      38.619  58.272  27.824  1.00  0.00           C  
ATOM    897  CG1 VAL A  58      38.732  59.438  26.855  1.00  0.00           C  
ATOM    898  CG2 VAL A  58      39.547  58.465  29.015  1.00  0.00           C  
ATOM    899  H   VAL A  58      37.221  56.061  28.858  1.00  0.00           H  
ATOM    900  HA  VAL A  58      36.877  58.989  28.842  1.00  0.00           H  
ATOM    901  HB  VAL A  58      38.916  57.372  27.306  1.00  0.00           H  
ATOM    902 HG11 VAL A  58      39.722  59.866  26.920  1.00  0.00           H  
ATOM    903 HG12 VAL A  58      38.556  59.088  25.848  1.00  0.00           H  
ATOM    904 HG13 VAL A  58      37.998  60.190  27.109  1.00  0.00           H  
ATOM    905 HG21 VAL A  58      39.879  57.503  29.373  1.00  0.00           H  
ATOM    906 HG22 VAL A  58      40.402  59.052  28.712  1.00  0.00           H  
ATOM    907 HG23 VAL A  58      39.019  58.980  29.804  1.00  0.00           H  
ATOM    908  N   PHE A  59      35.154  58.691  27.078  1.00  0.00           N  
ATOM    909  CA  PHE A  59      34.204  58.642  25.971  1.00  0.00           C  
ATOM    910  C   PHE A  59      34.272  59.919  25.140  1.00  0.00           C  
ATOM    911  O   PHE A  59      34.449  61.015  25.675  1.00  0.00           O  
ATOM    912  CB  PHE A  59      32.782  58.441  26.502  1.00  0.00           C  
ATOM    913  CG  PHE A  59      32.388  59.435  27.556  1.00  0.00           C  
ATOM    914  CD1 PHE A  59      32.866  59.318  28.851  1.00  0.00           C  
ATOM    915  CD2 PHE A  59      31.540  60.487  27.251  1.00  0.00           C  
ATOM    916  CE1 PHE A  59      32.506  60.231  29.823  1.00  0.00           C  
ATOM    917  CE2 PHE A  59      31.177  61.405  28.219  1.00  0.00           C  
ATOM    918  CZ  PHE A  59      31.659  61.276  29.507  1.00  0.00           C  
ATOM    919  H   PHE A  59      34.973  59.283  27.838  1.00  0.00           H  
ATOM    920  HA  PHE A  59      34.469  57.804  25.346  1.00  0.00           H  
ATOM    921  HB2 PHE A  59      32.085  58.532  25.683  1.00  0.00           H  
ATOM    922  HB3 PHE A  59      32.702  57.452  26.929  1.00  0.00           H  
ATOM    923  HD1 PHE A  59      33.529  58.500  29.099  1.00  0.00           H  
ATOM    924  HD2 PHE A  59      31.162  60.590  26.245  1.00  0.00           H  
ATOM    925  HE1 PHE A  59      32.884  60.127  30.829  1.00  0.00           H  
ATOM    926  HE2 PHE A  59      30.515  62.221  27.970  1.00  0.00           H  
ATOM    927  HZ  PHE A  59      31.378  61.991  30.265  1.00  0.00           H  
ATOM    928  N   HIS A  60      34.131  59.771  23.826  1.00  0.00           N  
ATOM    929  CA  HIS A  60      34.177  60.912  22.918  1.00  0.00           C  
ATOM    930  C   HIS A  60      33.001  60.880  21.946  1.00  0.00           C  
ATOM    931  O   HIS A  60      32.973  60.072  21.017  1.00  0.00           O  
ATOM    932  CB  HIS A  60      35.494  60.920  22.143  1.00  0.00           C  
ATOM    933  CG  HIS A  60      35.685  62.145  21.301  1.00  0.00           C  
ATOM    934  ND1 HIS A  60      36.917  62.552  20.833  1.00  0.00           N  
ATOM    935  CD2 HIS A  60      34.792  63.053  20.843  1.00  0.00           C  
ATOM    936  CE1 HIS A  60      36.773  63.657  20.125  1.00  0.00           C  
ATOM    937  NE2 HIS A  60      35.493  63.982  20.114  1.00  0.00           N  
ATOM    938  H   HIS A  60      33.993  58.873  23.459  1.00  0.00           H  
ATOM    939  HA  HIS A  60      34.112  61.811  23.513  1.00  0.00           H  
ATOM    940  HB2 HIS A  60      36.316  60.868  22.841  1.00  0.00           H  
ATOM    941  HB3 HIS A  60      35.526  60.060  21.490  1.00  0.00           H  
ATOM    942  HD1 HIS A  60      37.769  62.098  20.997  1.00  0.00           H  
ATOM    943  HD2 HIS A  60      33.725  63.048  21.018  1.00  0.00           H  
ATOM    944  HE1 HIS A  60      37.566  64.203  19.635  1.00  0.00           H  
ATOM    945  HE2 HIS A  60      35.122  64.805  19.733  1.00  0.00           H  
ATOM    946  N   ILE A  61      32.032  61.763  22.168  1.00  0.00           N  
ATOM    947  CA  ILE A  61      30.855  61.835  21.312  1.00  0.00           C  
ATOM    948  C   ILE A  61      31.089  62.773  20.133  1.00  0.00           C  
ATOM    949  O   ILE A  61      31.807  63.767  20.249  1.00  0.00           O  
ATOM    950  CB  ILE A  61      29.618  62.314  22.096  1.00  0.00           C  
ATOM    951  CG1 ILE A  61      29.414  61.453  23.344  1.00  0.00           C  
ATOM    952  CG2 ILE A  61      28.382  62.273  21.210  1.00  0.00           C  
ATOM    953  CD1 ILE A  61      28.748  62.191  24.484  1.00  0.00           C  
ATOM    954  H   ILE A  61      32.112  62.379  22.925  1.00  0.00           H  
ATOM    955  HA  ILE A  61      30.655  60.842  20.936  1.00  0.00           H  
ATOM    956  HB  ILE A  61      29.783  63.337  22.395  1.00  0.00           H  
ATOM    957 HG12 ILE A  61      28.796  60.605  23.092  1.00  0.00           H  
ATOM    958 HG13 ILE A  61      30.376  61.102  23.691  1.00  0.00           H  
ATOM    959 HG21 ILE A  61      27.542  61.908  21.781  1.00  0.00           H  
ATOM    960 HG22 ILE A  61      28.166  63.267  20.848  1.00  0.00           H  
ATOM    961 HG23 ILE A  61      28.561  61.616  20.372  1.00  0.00           H  
ATOM    962 HD11 ILE A  61      27.905  61.616  24.841  1.00  0.00           H  
ATOM    963 HD12 ILE A  61      29.456  62.328  25.288  1.00  0.00           H  
ATOM    964 HD13 ILE A  61      28.403  63.154  24.139  1.00  0.00           H  
ATOM    965  N   LYS A  62      30.479  62.451  18.998  1.00  0.00           N  
ATOM    966  CA  LYS A  62      30.618  63.265  17.796  1.00  0.00           C  
ATOM    967  C   LYS A  62      29.264  63.487  17.130  1.00  0.00           C  
ATOM    968  O   LYS A  62      28.547  62.534  16.823  1.00  0.00           O  
ATOM    969  CB  LYS A  62      31.580  62.597  16.811  1.00  0.00           C  
ATOM    970  CG  LYS A  62      33.030  63.000  17.008  1.00  0.00           C  
ATOM    971  CD  LYS A  62      33.798  62.980  15.697  1.00  0.00           C  
ATOM    972  CE  LYS A  62      35.033  63.865  15.761  1.00  0.00           C  
ATOM    973  NZ  LYS A  62      34.676  65.308  15.863  1.00  0.00           N  
ATOM    974  H   LYS A  62      29.920  61.646  18.968  1.00  0.00           H  
ATOM    975  HA  LYS A  62      31.023  64.222  18.089  1.00  0.00           H  
ATOM    976  HB2 LYS A  62      31.507  61.525  16.925  1.00  0.00           H  
ATOM    977  HB3 LYS A  62      31.287  62.863  15.805  1.00  0.00           H  
ATOM    978  HG2 LYS A  62      33.065  64.000  17.417  1.00  0.00           H  
ATOM    979  HG3 LYS A  62      33.495  62.311  17.698  1.00  0.00           H  
ATOM    980  HD2 LYS A  62      34.107  61.966  15.487  1.00  0.00           H  
ATOM    981  HD3 LYS A  62      33.153  63.332  14.906  1.00  0.00           H  
ATOM    982  HE2 LYS A  62      35.617  63.586  16.624  1.00  0.00           H  
ATOM    983  HE3 LYS A  62      35.617  63.710  14.865  1.00  0.00           H  
ATOM    984  HZ1 LYS A  62      33.644  65.424  15.830  1.00  0.00           H  
ATOM    985  HZ2 LYS A  62      35.099  65.837  15.074  1.00  0.00           H  
ATOM    986  HZ3 LYS A  62      35.030  65.700  16.759  1.00  0.00           H  
ATOM    987  N   THR A  63      28.920  64.752  16.907  1.00  0.00           N  
ATOM    988  CA  THR A  63      27.652  65.099  16.277  1.00  0.00           C  
ATOM    989  C   THR A  63      27.723  66.473  15.620  1.00  0.00           C  
ATOM    990  O   THR A  63      28.637  67.252  15.887  1.00  0.00           O  
ATOM    991  CB  THR A  63      26.496  65.088  17.296  1.00  0.00           C  
ATOM    992  OG1 THR A  63      25.243  65.212  16.616  1.00  0.00           O  
ATOM    993  CG2 THR A  63      26.649  66.223  18.298  1.00  0.00           C  
ATOM    994  H   THR A  63      29.533  65.468  17.174  1.00  0.00           H  
ATOM    995  HA  THR A  63      27.442  64.358  15.519  1.00  0.00           H  
ATOM    996  HB  THR A  63      26.517  64.150  17.830  1.00  0.00           H  
ATOM    997  HG1 THR A  63      25.229  64.619  15.860  1.00  0.00           H  
ATOM    998 HG21 THR A  63      27.257  67.004  17.867  1.00  0.00           H  
ATOM    999 HG22 THR A  63      27.124  65.850  19.194  1.00  0.00           H  
ATOM   1000 HG23 THR A  63      25.675  66.618  18.545  1.00  0.00           H  
ATOM   1001  N   CYS A  64      26.752  66.763  14.761  1.00  0.00           N  
ATOM   1002  CA  CYS A  64      26.704  68.043  14.065  1.00  0.00           C  
ATOM   1003  C   CYS A  64      25.291  68.616  14.074  1.00  0.00           C  
ATOM   1004  O   CYS A  64      24.317  67.885  14.259  1.00  0.00           O  
ATOM   1005  CB  CYS A  64      27.194  67.884  12.625  1.00  0.00           C  
ATOM   1006  SG  CYS A  64      26.184  66.769  11.621  1.00  0.00           S  
ATOM   1007  H   CYS A  64      26.051  66.100  14.589  1.00  0.00           H  
ATOM   1008  HA  CYS A  64      27.359  68.726  14.585  1.00  0.00           H  
ATOM   1009  HB2 CYS A  64      27.193  68.850  12.142  1.00  0.00           H  
ATOM   1010  HB3 CYS A  64      28.202  67.495  12.636  1.00  0.00           H  
ATOM   1011  HG  CYS A  64      26.887  65.668  11.400  1.00  0.00           H  
ATOM   1012  N   ARG A  65      25.187  69.925  13.874  1.00  0.00           N  
ATOM   1013  CA  ARG A  65      23.892  70.595  13.862  1.00  0.00           C  
ATOM   1014  C   ARG A  65      22.930  69.903  12.902  1.00  0.00           C  
ATOM   1015  O   ARG A  65      23.337  69.241  11.947  1.00  0.00           O  
ATOM   1016  CB  ARG A  65      24.057  72.063  13.466  1.00  0.00           C  
ATOM   1017  CG  ARG A  65      24.334  72.267  11.985  1.00  0.00           C  
ATOM   1018  CD  ARG A  65      24.776  73.691  11.691  1.00  0.00           C  
ATOM   1019  NE  ARG A  65      25.170  73.867  10.295  1.00  0.00           N  
ATOM   1020  CZ  ARG A  65      25.559  75.027   9.782  1.00  0.00           C  
ATOM   1021  NH1 ARG A  65      25.604  76.112  10.543  1.00  0.00           N  
ATOM   1022  NH2 ARG A  65      25.902  75.107   8.502  1.00  0.00           N  
ATOM   1023  H   ARG A  65      25.999  70.454  13.732  1.00  0.00           H  
ATOM   1024  HA  ARG A  65      23.483  70.546  14.861  1.00  0.00           H  
ATOM   1025  HB2 ARG A  65      23.152  72.597  13.716  1.00  0.00           H  
ATOM   1026  HB3 ARG A  65      24.879  72.485  14.024  1.00  0.00           H  
ATOM   1027  HG2 ARG A  65      25.118  71.589  11.679  1.00  0.00           H  
ATOM   1028  HG3 ARG A  65      23.434  72.055  11.427  1.00  0.00           H  
ATOM   1029  HD2 ARG A  65      23.957  74.360  11.910  1.00  0.00           H  
ATOM   1030  HD3 ARG A  65      25.616  73.932  12.326  1.00  0.00           H  
ATOM   1031  HE  ARG A  65      25.144  73.078   9.715  1.00  0.00           H  
ATOM   1032 HH11 ARG A  65      25.347  76.055  11.508  1.00  0.00           H  
ATOM   1033 HH12 ARG A  65      25.899  76.985  10.154  1.00  0.00           H  
ATOM   1034 HH21 ARG A  65      25.869  74.291   7.924  1.00  0.00           H  
ATOM   1035 HH22 ARG A  65      26.194  75.982   8.116  1.00  0.00           H  
ATOM   1036  N   PRO A  66      21.622  70.057  13.158  1.00  0.00           N  
ATOM   1037  CA  PRO A  66      21.126  70.842  14.293  1.00  0.00           C  
ATOM   1038  C   PRO A  66      21.410  70.170  15.631  1.00  0.00           C  
ATOM   1039  O   PRO A  66      21.060  70.696  16.689  1.00  0.00           O  
ATOM   1040  CB  PRO A  66      19.618  70.916  14.041  1.00  0.00           C  
ATOM   1041  CG  PRO A  66      19.314  69.713  13.217  1.00  0.00           C  
ATOM   1042  CD  PRO A  66      20.528  69.477  12.363  1.00  0.00           C  
ATOM   1043  HA  PRO A  66      21.541  71.840  14.297  1.00  0.00           H  
ATOM   1044  HB2 PRO A  66      19.091  70.893  14.985  1.00  0.00           H  
ATOM   1045  HB3 PRO A  66      19.382  71.827  13.512  1.00  0.00           H  
ATOM   1046  HG2 PRO A  66      19.135  68.863  13.859  1.00  0.00           H  
ATOM   1047  HG3 PRO A  66      18.450  69.904  12.596  1.00  0.00           H  
ATOM   1048  HD2 PRO A  66      20.681  68.419  12.209  1.00  0.00           H  
ATOM   1049  HD3 PRO A  66      20.428  69.987  11.416  1.00  0.00           H  
ATOM   1050  N   PHE A  67      22.048  69.006  15.580  1.00  0.00           N  
ATOM   1051  CA  PHE A  67      22.379  68.261  16.790  1.00  0.00           C  
ATOM   1052  C   PHE A  67      23.801  68.574  17.250  1.00  0.00           C  
ATOM   1053  O   PHE A  67      24.767  68.311  16.535  1.00  0.00           O  
ATOM   1054  CB  PHE A  67      22.229  66.758  16.546  1.00  0.00           C  
ATOM   1055  CG  PHE A  67      20.842  66.244  16.807  1.00  0.00           C  
ATOM   1056  CD1 PHE A  67      20.242  66.427  18.041  1.00  0.00           C  
ATOM   1057  CD2 PHE A  67      20.139  65.577  15.816  1.00  0.00           C  
ATOM   1058  CE1 PHE A  67      18.965  65.956  18.284  1.00  0.00           C  
ATOM   1059  CE2 PHE A  67      18.862  65.105  16.053  1.00  0.00           C  
ATOM   1060  CZ  PHE A  67      18.275  65.293  17.290  1.00  0.00           C  
ATOM   1061  H   PHE A  67      22.302  68.637  14.708  1.00  0.00           H  
ATOM   1062  HA  PHE A  67      21.690  68.563  17.563  1.00  0.00           H  
ATOM   1063  HB2 PHE A  67      22.475  66.541  15.517  1.00  0.00           H  
ATOM   1064  HB3 PHE A  67      22.908  66.226  17.195  1.00  0.00           H  
ATOM   1065  HD1 PHE A  67      20.782  66.946  18.821  1.00  0.00           H  
ATOM   1066  HD2 PHE A  67      20.597  65.428  14.850  1.00  0.00           H  
ATOM   1067  HE1 PHE A  67      18.509  66.105  19.252  1.00  0.00           H  
ATOM   1068  HE2 PHE A  67      18.324  64.586  15.273  1.00  0.00           H  
ATOM   1069  HZ  PHE A  67      17.277  64.924  17.476  1.00  0.00           H  
ATOM   1070  N   SER A  68      23.919  69.138  18.446  1.00  0.00           N  
ATOM   1071  CA  SER A  68      25.220  69.491  19.001  1.00  0.00           C  
ATOM   1072  C   SER A  68      25.185  69.474  20.526  1.00  0.00           C  
ATOM   1073  O   SER A  68      24.264  70.013  21.142  1.00  0.00           O  
ATOM   1074  CB  SER A  68      25.651  70.873  18.504  1.00  0.00           C  
ATOM   1075  OG  SER A  68      25.640  70.933  17.090  1.00  0.00           O  
ATOM   1076  H   SER A  68      23.110  69.323  18.969  1.00  0.00           H  
ATOM   1077  HA  SER A  68      25.935  68.757  18.661  1.00  0.00           H  
ATOM   1078  HB2 SER A  68      24.972  71.619  18.889  1.00  0.00           H  
ATOM   1079  HB3 SER A  68      26.652  71.082  18.855  1.00  0.00           H  
ATOM   1080  HG  SER A  68      24.786  70.644  16.763  1.00  0.00           H  
ATOM   1081  N   ILE A  69      26.193  68.852  21.128  1.00  0.00           N  
ATOM   1082  CA  ILE A  69      26.277  68.765  22.580  1.00  0.00           C  
ATOM   1083  C   ILE A  69      27.690  69.068  23.068  1.00  0.00           C  
ATOM   1084  O   ILE A  69      28.616  69.204  22.269  1.00  0.00           O  
ATOM   1085  CB  ILE A  69      25.860  67.372  23.087  1.00  0.00           C  
ATOM   1086  CG1 ILE A  69      27.073  66.440  23.142  1.00  0.00           C  
ATOM   1087  CG2 ILE A  69      24.776  66.787  22.193  1.00  0.00           C  
ATOM   1088  CD1 ILE A  69      27.698  66.182  21.789  1.00  0.00           C  
ATOM   1089  H   ILE A  69      26.896  68.443  20.582  1.00  0.00           H  
ATOM   1090  HA  ILE A  69      25.600  69.496  22.998  1.00  0.00           H  
ATOM   1091  HB  ILE A  69      25.453  67.481  24.081  1.00  0.00           H  
ATOM   1092 HG12 ILE A  69      27.827  66.880  23.777  1.00  0.00           H  
ATOM   1093 HG13 ILE A  69      26.768  65.490  23.555  1.00  0.00           H  
ATOM   1094 HG21 ILE A  69      24.016  66.324  22.806  1.00  0.00           H  
ATOM   1095 HG22 ILE A  69      24.333  67.574  21.603  1.00  0.00           H  
ATOM   1096 HG23 ILE A  69      25.211  66.046  21.538  1.00  0.00           H  
ATOM   1097 HD11 ILE A  69      28.692  66.607  21.765  1.00  0.00           H  
ATOM   1098 HD12 ILE A  69      27.760  65.118  21.619  1.00  0.00           H  
ATOM   1099 HD13 ILE A  69      27.093  66.637  21.020  1.00  0.00           H  
ATOM   1100  N   GLU A  70      27.847  69.172  24.384  1.00  0.00           N  
ATOM   1101  CA  GLU A  70      29.149  69.458  24.977  1.00  0.00           C  
ATOM   1102  C   GLU A  70      29.115  69.248  26.488  1.00  0.00           C  
ATOM   1103  O   GLU A  70      28.078  69.387  27.137  1.00  0.00           O  
ATOM   1104  CB  GLU A  70      29.573  70.893  24.660  1.00  0.00           C  
ATOM   1105  CG  GLU A  70      28.695  71.947  25.313  1.00  0.00           C  
ATOM   1106  CD  GLU A  70      27.470  72.280  24.485  1.00  0.00           C  
ATOM   1107  OE1 GLU A  70      26.595  71.401  24.339  1.00  0.00           O  
ATOM   1108  OE2 GLU A  70      27.385  73.421  23.984  1.00  0.00           O  
ATOM   1109  H   GLU A  70      27.070  69.053  24.968  1.00  0.00           H  
ATOM   1110  HA  GLU A  70      29.866  68.776  24.546  1.00  0.00           H  
ATOM   1111  HB2 GLU A  70      30.589  71.038  25.000  1.00  0.00           H  
ATOM   1112  HB3 GLU A  70      29.538  71.038  23.590  1.00  0.00           H  
ATOM   1113  HG2 GLU A  70      28.372  71.580  26.276  1.00  0.00           H  
ATOM   1114  HG3 GLU A  70      29.276  72.848  25.449  1.00  0.00           H  
ATOM   1115  N   PRO A  71      30.277  68.903  27.062  1.00  0.00           N  
ATOM   1116  CA  PRO A  71      31.518  68.734  26.300  1.00  0.00           C  
ATOM   1117  C   PRO A  71      31.484  67.501  25.403  1.00  0.00           C  
ATOM   1118  O   PRO A  71      31.138  66.407  25.848  1.00  0.00           O  
ATOM   1119  CB  PRO A  71      32.583  68.575  27.387  1.00  0.00           C  
ATOM   1120  CG  PRO A  71      31.845  68.046  28.568  1.00  0.00           C  
ATOM   1121  CD  PRO A  71      30.470  68.653  28.500  1.00  0.00           C  
ATOM   1122  HA  PRO A  71      31.738  69.607  25.702  1.00  0.00           H  
ATOM   1123  HB2 PRO A  71      33.342  67.881  27.052  1.00  0.00           H  
ATOM   1124  HB3 PRO A  71      33.033  69.533  27.599  1.00  0.00           H  
ATOM   1125  HG2 PRO A  71      31.783  66.970  28.511  1.00  0.00           H  
ATOM   1126  HG3 PRO A  71      32.342  68.348  29.477  1.00  0.00           H  
ATOM   1127  HD2 PRO A  71      29.733  67.956  28.873  1.00  0.00           H  
ATOM   1128  HD3 PRO A  71      30.437  69.576  29.060  1.00  0.00           H  
ATOM   1129  N   ALA A  72      31.844  67.686  24.137  1.00  0.00           N  
ATOM   1130  CA  ALA A  72      31.855  66.588  23.178  1.00  0.00           C  
ATOM   1131  C   ALA A  72      32.642  65.397  23.717  1.00  0.00           C  
ATOM   1132  O   ALA A  72      32.439  64.262  23.287  1.00  0.00           O  
ATOM   1133  CB  ALA A  72      32.440  67.052  21.852  1.00  0.00           C  
ATOM   1134  H   ALA A  72      32.109  68.582  23.841  1.00  0.00           H  
ATOM   1135  HA  ALA A  72      30.833  66.284  23.007  1.00  0.00           H  
ATOM   1136  HB1 ALA A  72      31.652  67.132  21.120  1.00  0.00           H  
ATOM   1137  HB2 ALA A  72      32.909  68.017  21.984  1.00  0.00           H  
ATOM   1138  HB3 ALA A  72      33.176  66.337  21.513  1.00  0.00           H  
ATOM   1139  N   ILE A  73      33.539  65.665  24.661  1.00  0.00           N  
ATOM   1140  CA  ILE A  73      34.354  64.615  25.258  1.00  0.00           C  
ATOM   1141  C   ILE A  73      34.629  64.903  26.730  1.00  0.00           C  
ATOM   1142  O   ILE A  73      34.667  66.059  27.150  1.00  0.00           O  
ATOM   1143  CB  ILE A  73      35.695  64.453  24.517  1.00  0.00           C  
ATOM   1144  CG1 ILE A  73      36.583  63.438  25.241  1.00  0.00           C  
ATOM   1145  CG2 ILE A  73      36.401  65.795  24.403  1.00  0.00           C  
ATOM   1146  CD1 ILE A  73      37.757  62.965  24.413  1.00  0.00           C  
ATOM   1147  H   ILE A  73      33.654  66.590  24.962  1.00  0.00           H  
ATOM   1148  HA  ILE A  73      33.809  63.685  25.181  1.00  0.00           H  
ATOM   1149  HB  ILE A  73      35.489  64.095  23.521  1.00  0.00           H  
ATOM   1150 HG12 ILE A  73      36.971  63.886  26.141  1.00  0.00           H  
ATOM   1151 HG13 ILE A  73      35.989  62.573  25.501  1.00  0.00           H  
ATOM   1152 HG21 ILE A  73      36.314  66.329  25.338  1.00  0.00           H  
ATOM   1153 HG22 ILE A  73      37.445  65.635  24.179  1.00  0.00           H  
ATOM   1154 HG23 ILE A  73      35.948  66.376  23.613  1.00  0.00           H  
ATOM   1155 HD11 ILE A  73      37.469  62.924  23.372  1.00  0.00           H  
ATOM   1156 HD12 ILE A  73      38.581  63.652  24.530  1.00  0.00           H  
ATOM   1157 HD13 ILE A  73      38.057  61.981  24.742  1.00  0.00           H  
ATOM   1158  N   GLY A  74      34.825  63.844  27.509  1.00  0.00           N  
ATOM   1159  CA  GLY A  74      35.097  64.004  28.926  1.00  0.00           C  
ATOM   1160  C   GLY A  74      35.655  62.743  29.555  1.00  0.00           C  
ATOM   1161  O   GLY A  74      35.682  61.684  28.926  1.00  0.00           O  
ATOM   1162  H   GLY A  74      34.783  62.945  27.118  1.00  0.00           H  
ATOM   1163  HA2 GLY A  74      35.809  64.805  29.055  1.00  0.00           H  
ATOM   1164  HA3 GLY A  74      34.179  64.267  29.429  1.00  0.00           H  
ATOM   1165  N   THR A  75      36.107  62.856  30.800  1.00  0.00           N  
ATOM   1166  CA  THR A  75      36.671  61.716  31.514  1.00  0.00           C  
ATOM   1167  C   THR A  75      36.075  61.595  32.912  1.00  0.00           C  
ATOM   1168  O   THR A  75      36.334  62.425  33.783  1.00  0.00           O  
ATOM   1169  CB  THR A  75      38.203  61.828  31.630  1.00  0.00           C  
ATOM   1170  OG1 THR A  75      38.564  63.125  32.120  1.00  0.00           O  
ATOM   1171  CG2 THR A  75      38.867  61.587  30.282  1.00  0.00           C  
ATOM   1172  H   THR A  75      36.060  63.725  31.248  1.00  0.00           H  
ATOM   1173  HA  THR A  75      36.437  60.823  30.954  1.00  0.00           H  
ATOM   1174  HB  THR A  75      38.552  61.078  32.325  1.00  0.00           H  
ATOM   1175  HG1 THR A  75      37.788  63.555  32.489  1.00  0.00           H  
ATOM   1176 HG21 THR A  75      38.912  62.516  29.734  1.00  0.00           H  
ATOM   1177 HG22 THR A  75      38.291  60.866  29.722  1.00  0.00           H  
ATOM   1178 HG23 THR A  75      39.866  61.210  30.436  1.00  0.00           H  
ATOM   1179  N   LEU A  76      35.275  60.554  33.120  1.00  0.00           N  
ATOM   1180  CA  LEU A  76      34.642  60.321  34.413  1.00  0.00           C  
ATOM   1181  C   LEU A  76      35.404  59.269  35.212  1.00  0.00           C  
ATOM   1182  O   LEU A  76      36.040  58.384  34.641  1.00  0.00           O  
ATOM   1183  CB  LEU A  76      33.190  59.881  34.221  1.00  0.00           C  
ATOM   1184  CG  LEU A  76      32.231  60.211  35.365  1.00  0.00           C  
ATOM   1185  CD1 LEU A  76      32.245  61.702  35.660  1.00  0.00           C  
ATOM   1186  CD2 LEU A  76      30.821  59.745  35.030  1.00  0.00           C  
ATOM   1187  H   LEU A  76      35.106  59.926  32.386  1.00  0.00           H  
ATOM   1188  HA  LEU A  76      34.657  61.252  34.961  1.00  0.00           H  
ATOM   1189  HB2 LEU A  76      32.815  60.356  33.328  1.00  0.00           H  
ATOM   1190  HB3 LEU A  76      33.186  58.808  34.083  1.00  0.00           H  
ATOM   1191  HG  LEU A  76      32.553  59.692  36.257  1.00  0.00           H  
ATOM   1192 HD11 LEU A  76      33.086  61.935  36.296  1.00  0.00           H  
ATOM   1193 HD12 LEU A  76      31.328  61.980  36.158  1.00  0.00           H  
ATOM   1194 HD13 LEU A  76      32.331  62.252  34.733  1.00  0.00           H  
ATOM   1195 HD21 LEU A  76      30.871  58.837  34.449  1.00  0.00           H  
ATOM   1196 HD22 LEU A  76      30.316  60.510  34.460  1.00  0.00           H  
ATOM   1197 HD23 LEU A  76      30.278  59.558  35.946  1.00  0.00           H  
ATOM   1198  N   ASN A  77      35.333  59.371  36.535  1.00  0.00           N  
ATOM   1199  CA  ASN A  77      36.015  58.427  37.412  1.00  0.00           C  
ATOM   1200  C   ASN A  77      35.011  57.546  38.150  1.00  0.00           C  
ATOM   1201  O   ASN A  77      33.920  57.994  38.504  1.00  0.00           O  
ATOM   1202  CB  ASN A  77      36.891  59.174  38.419  1.00  0.00           C  
ATOM   1203  CG  ASN A  77      37.836  60.152  37.749  1.00  0.00           C  
ATOM   1204  OD1 ASN A  77      38.311  59.911  36.638  1.00  0.00           O  
ATOM   1205  ND2 ASN A  77      38.114  61.263  38.422  1.00  0.00           N  
ATOM   1206  H   ASN A  77      34.810  60.099  36.931  1.00  0.00           H  
ATOM   1207  HA  ASN A  77      36.644  57.799  36.798  1.00  0.00           H  
ATOM   1208  HB2 ASN A  77      36.257  59.725  39.099  1.00  0.00           H  
ATOM   1209  HB3 ASN A  77      37.477  58.461  38.978  1.00  0.00           H  
ATOM   1210 HD21 ASN A  77      37.700  61.386  39.302  1.00  0.00           H  
ATOM   1211 HD22 ASN A  77      38.723  61.912  38.012  1.00  0.00           H  
ATOM   1212  N   VAL A  78      35.386  56.292  38.377  1.00  0.00           N  
ATOM   1213  CA  VAL A  78      34.520  55.349  39.074  1.00  0.00           C  
ATOM   1214  C   VAL A  78      34.098  55.893  40.435  1.00  0.00           C  
ATOM   1215  O   VAL A  78      34.931  56.340  41.221  1.00  0.00           O  
ATOM   1216  CB  VAL A  78      35.214  53.988  39.271  1.00  0.00           C  
ATOM   1217  CG1 VAL A  78      34.315  53.036  40.044  1.00  0.00           C  
ATOM   1218  CG2 VAL A  78      35.607  53.392  37.928  1.00  0.00           C  
ATOM   1219  H   VAL A  78      36.268  55.994  38.070  1.00  0.00           H  
ATOM   1220  HA  VAL A  78      33.639  55.196  38.469  1.00  0.00           H  
ATOM   1221  HB  VAL A  78      36.114  54.146  39.847  1.00  0.00           H  
ATOM   1222 HG11 VAL A  78      34.078  53.466  41.006  1.00  0.00           H  
ATOM   1223 HG12 VAL A  78      33.403  52.871  39.488  1.00  0.00           H  
ATOM   1224 HG13 VAL A  78      34.826  52.095  40.186  1.00  0.00           H  
ATOM   1225 HG21 VAL A  78      34.743  52.932  37.471  1.00  0.00           H  
ATOM   1226 HG22 VAL A  78      35.982  54.173  37.283  1.00  0.00           H  
ATOM   1227 HG23 VAL A  78      36.375  52.647  38.074  1.00  0.00           H  
ATOM   1228  N   GLY A  79      32.797  55.849  40.706  1.00  0.00           N  
ATOM   1229  CA  GLY A  79      32.286  56.340  41.972  1.00  0.00           C  
ATOM   1230  C   GLY A  79      31.949  57.818  41.928  1.00  0.00           C  
ATOM   1231  O   GLY A  79      32.020  58.507  42.944  1.00  0.00           O  
ATOM   1232  H   GLY A  79      32.178  55.481  40.040  1.00  0.00           H  
ATOM   1233  HA2 GLY A  79      31.395  55.786  42.227  1.00  0.00           H  
ATOM   1234  HA3 GLY A  79      33.031  56.176  42.736  1.00  0.00           H  
ATOM   1235  N   GLU A  80      31.582  58.305  40.746  1.00  0.00           N  
ATOM   1236  CA  GLU A  80      31.236  59.710  40.573  1.00  0.00           C  
ATOM   1237  C   GLU A  80      30.257  59.892  39.417  1.00  0.00           C  
ATOM   1238  O   GLU A  80      30.086  58.999  38.588  1.00  0.00           O  
ATOM   1239  CB  GLU A  80      32.496  60.543  40.325  1.00  0.00           C  
ATOM   1240  CG  GLU A  80      33.508  60.466  41.455  1.00  0.00           C  
ATOM   1241  CD  GLU A  80      32.996  61.088  42.740  1.00  0.00           C  
ATOM   1242  OE1 GLU A  80      32.059  61.910  42.670  1.00  0.00           O  
ATOM   1243  OE2 GLU A  80      33.532  60.749  43.816  1.00  0.00           O  
ATOM   1244  H   GLU A  80      31.545  57.704  39.972  1.00  0.00           H  
ATOM   1245  HA  GLU A  80      30.765  60.050  41.484  1.00  0.00           H  
ATOM   1246  HB2 GLU A  80      32.969  60.194  39.420  1.00  0.00           H  
ATOM   1247  HB3 GLU A  80      32.210  61.576  40.196  1.00  0.00           H  
ATOM   1248  HG2 GLU A  80      33.742  59.429  41.643  1.00  0.00           H  
ATOM   1249  HG3 GLU A  80      34.405  60.987  41.154  1.00  0.00           H  
ATOM   1250  N   SER A  81      29.615  61.055  39.370  1.00  0.00           N  
ATOM   1251  CA  SER A  81      28.649  61.353  38.319  1.00  0.00           C  
ATOM   1252  C   SER A  81      28.996  62.663  37.618  1.00  0.00           C  
ATOM   1253  O   SER A  81      29.912  63.375  38.028  1.00  0.00           O  
ATOM   1254  CB  SER A  81      27.237  61.432  38.902  1.00  0.00           C  
ATOM   1255  OG  SER A  81      27.014  60.393  39.840  1.00  0.00           O  
ATOM   1256  H   SER A  81      29.794  61.727  40.061  1.00  0.00           H  
ATOM   1257  HA  SER A  81      28.687  60.551  37.596  1.00  0.00           H  
ATOM   1258  HB2 SER A  81      27.108  62.381  39.398  1.00  0.00           H  
ATOM   1259  HB3 SER A  81      26.515  61.341  38.103  1.00  0.00           H  
ATOM   1260  HG  SER A  81      26.581  59.655  39.403  1.00  0.00           H  
ATOM   1261  N   MET A  82      28.257  62.973  36.559  1.00  0.00           N  
ATOM   1262  CA  MET A  82      28.485  64.198  35.801  1.00  0.00           C  
ATOM   1263  C   MET A  82      27.218  64.628  35.068  1.00  0.00           C  
ATOM   1264  O   MET A  82      26.226  63.900  35.046  1.00  0.00           O  
ATOM   1265  CB  MET A  82      29.625  63.999  34.799  1.00  0.00           C  
ATOM   1266  CG  MET A  82      29.268  63.071  33.650  1.00  0.00           C  
ATOM   1267  SD  MET A  82      30.717  62.511  32.735  1.00  0.00           S  
ATOM   1268  CE  MET A  82      31.014  63.923  31.673  1.00  0.00           C  
ATOM   1269  H   MET A  82      27.540  62.366  36.280  1.00  0.00           H  
ATOM   1270  HA  MET A  82      28.763  64.973  36.499  1.00  0.00           H  
ATOM   1271  HB2 MET A  82      29.898  64.960  34.388  1.00  0.00           H  
ATOM   1272  HB3 MET A  82      30.476  63.584  35.318  1.00  0.00           H  
ATOM   1273  HG2 MET A  82      28.756  62.208  34.047  1.00  0.00           H  
ATOM   1274  HG3 MET A  82      28.612  63.596  32.972  1.00  0.00           H  
ATOM   1275  HE1 MET A  82      30.541  63.758  30.716  1.00  0.00           H  
ATOM   1276  HE2 MET A  82      30.601  64.810  32.129  1.00  0.00           H  
ATOM   1277  HE3 MET A  82      32.077  64.051  31.533  1.00  0.00           H  
ATOM   1278  N   GLN A  83      27.259  65.814  34.470  1.00  0.00           N  
ATOM   1279  CA  GLN A  83      26.113  66.340  33.736  1.00  0.00           C  
ATOM   1280  C   GLN A  83      26.519  66.777  32.332  1.00  0.00           C  
ATOM   1281  O   GLN A  83      27.416  67.603  32.164  1.00  0.00           O  
ATOM   1282  CB  GLN A  83      25.494  67.516  34.492  1.00  0.00           C  
ATOM   1283  CG  GLN A  83      24.693  67.101  35.715  1.00  0.00           C  
ATOM   1284  CD  GLN A  83      24.409  68.261  36.648  1.00  0.00           C  
ATOM   1285  OE1 GLN A  83      24.907  68.305  37.774  1.00  0.00           O  
ATOM   1286  NE2 GLN A  83      23.605  69.212  36.184  1.00  0.00           N  
ATOM   1287  H   GLN A  83      28.078  66.348  34.522  1.00  0.00           H  
ATOM   1288  HA  GLN A  83      25.381  65.551  33.656  1.00  0.00           H  
ATOM   1289  HB2 GLN A  83      26.285  68.178  34.813  1.00  0.00           H  
ATOM   1290  HB3 GLN A  83      24.837  68.053  33.823  1.00  0.00           H  
ATOM   1291  HG2 GLN A  83      23.752  66.684  35.389  1.00  0.00           H  
ATOM   1292  HG3 GLN A  83      25.250  66.351  36.256  1.00  0.00           H  
ATOM   1293 HE21 GLN A  83      23.245  69.111  35.278  1.00  0.00           H  
ATOM   1294 HE22 GLN A  83      23.404  69.972  36.766  1.00  0.00           H  
ATOM   1295  N   LEU A  84      25.852  66.218  31.329  1.00  0.00           N  
ATOM   1296  CA  LEU A  84      26.144  66.551  29.938  1.00  0.00           C  
ATOM   1297  C   LEU A  84      24.997  67.339  29.315  1.00  0.00           C  
ATOM   1298  O   LEU A  84      23.836  66.940  29.404  1.00  0.00           O  
ATOM   1299  CB  LEU A  84      26.399  65.276  29.132  1.00  0.00           C  
ATOM   1300  CG  LEU A  84      27.541  64.387  29.625  1.00  0.00           C  
ATOM   1301  CD1 LEU A  84      27.427  62.992  29.029  1.00  0.00           C  
ATOM   1302  CD2 LEU A  84      28.887  65.007  29.282  1.00  0.00           C  
ATOM   1303  H   LEU A  84      25.148  65.567  31.526  1.00  0.00           H  
ATOM   1304  HA  LEU A  84      27.035  67.161  29.924  1.00  0.00           H  
ATOM   1305  HB2 LEU A  84      25.494  64.690  29.145  1.00  0.00           H  
ATOM   1306  HB3 LEU A  84      26.622  65.568  28.115  1.00  0.00           H  
ATOM   1307  HG  LEU A  84      27.478  64.296  30.701  1.00  0.00           H  
ATOM   1308 HD11 LEU A  84      28.040  62.308  29.595  1.00  0.00           H  
ATOM   1309 HD12 LEU A  84      27.762  63.011  28.003  1.00  0.00           H  
ATOM   1310 HD13 LEU A  84      26.397  62.669  29.065  1.00  0.00           H  
ATOM   1311 HD21 LEU A  84      29.388  65.306  30.190  1.00  0.00           H  
ATOM   1312 HD22 LEU A  84      28.734  65.872  28.654  1.00  0.00           H  
ATOM   1313 HD23 LEU A  84      29.493  64.284  28.756  1.00  0.00           H  
ATOM   1314  N   GLU A  85      25.330  68.460  28.683  1.00  0.00           N  
ATOM   1315  CA  GLU A  85      24.327  69.304  28.044  1.00  0.00           C  
ATOM   1316  C   GLU A  85      24.221  68.989  26.555  1.00  0.00           C  
ATOM   1317  O   GLU A  85      25.229  68.891  25.855  1.00  0.00           O  
ATOM   1318  CB  GLU A  85      24.671  70.782  28.240  1.00  0.00           C  
ATOM   1319  CG  GLU A  85      24.154  71.358  29.547  1.00  0.00           C  
ATOM   1320  CD  GLU A  85      24.845  72.654  29.927  1.00  0.00           C  
ATOM   1321  OE1 GLU A  85      24.993  73.527  29.047  1.00  0.00           O  
ATOM   1322  OE2 GLU A  85      25.236  72.793  31.105  1.00  0.00           O  
ATOM   1323  H   GLU A  85      26.273  68.726  28.646  1.00  0.00           H  
ATOM   1324  HA  GLU A  85      23.376  69.101  28.511  1.00  0.00           H  
ATOM   1325  HB2 GLU A  85      25.746  70.895  28.220  1.00  0.00           H  
ATOM   1326  HB3 GLU A  85      24.244  71.349  27.427  1.00  0.00           H  
ATOM   1327  HG2 GLU A  85      23.096  71.549  29.448  1.00  0.00           H  
ATOM   1328  HG3 GLU A  85      24.317  70.637  30.334  1.00  0.00           H  
ATOM   1329  N   VAL A  86      22.991  68.829  26.076  1.00  0.00           N  
ATOM   1330  CA  VAL A  86      22.750  68.527  24.670  1.00  0.00           C  
ATOM   1331  C   VAL A  86      21.891  69.602  24.014  1.00  0.00           C  
ATOM   1332  O   VAL A  86      20.722  69.769  24.358  1.00  0.00           O  
ATOM   1333  CB  VAL A  86      22.060  67.159  24.501  1.00  0.00           C  
ATOM   1334  CG1 VAL A  86      21.644  66.947  23.053  1.00  0.00           C  
ATOM   1335  CG2 VAL A  86      22.976  66.040  24.972  1.00  0.00           C  
ATOM   1336  H   VAL A  86      22.226  68.920  26.683  1.00  0.00           H  
ATOM   1337  HA  VAL A  86      23.707  68.488  24.169  1.00  0.00           H  
ATOM   1338  HB  VAL A  86      21.171  67.150  25.113  1.00  0.00           H  
ATOM   1339 HG11 VAL A  86      20.680  67.403  22.886  1.00  0.00           H  
ATOM   1340 HG12 VAL A  86      22.376  67.397  22.398  1.00  0.00           H  
ATOM   1341 HG13 VAL A  86      21.580  65.888  22.849  1.00  0.00           H  
ATOM   1342 HG21 VAL A  86      24.005  66.323  24.811  1.00  0.00           H  
ATOM   1343 HG22 VAL A  86      22.811  65.858  26.023  1.00  0.00           H  
ATOM   1344 HG23 VAL A  86      22.760  65.139  24.413  1.00  0.00           H  
ATOM   1345  N   GLU A  87      22.480  70.328  23.070  1.00  0.00           N  
ATOM   1346  CA  GLU A  87      21.768  71.388  22.366  1.00  0.00           C  
ATOM   1347  C   GLU A  87      21.266  70.898  21.010  1.00  0.00           C  
ATOM   1348  O   GLU A  87      21.999  70.253  20.261  1.00  0.00           O  
ATOM   1349  CB  GLU A  87      22.676  72.604  22.178  1.00  0.00           C  
ATOM   1350  CG  GLU A  87      21.916  73.902  21.955  1.00  0.00           C  
ATOM   1351  CD  GLU A  87      22.766  74.969  21.295  1.00  0.00           C  
ATOM   1352  OE1 GLU A  87      23.989  74.995  21.549  1.00  0.00           O  
ATOM   1353  OE2 GLU A  87      22.210  75.781  20.526  1.00  0.00           O  
ATOM   1354  H   GLU A  87      23.416  70.146  22.840  1.00  0.00           H  
ATOM   1355  HA  GLU A  87      20.919  71.672  22.969  1.00  0.00           H  
ATOM   1356  HB2 GLU A  87      23.292  72.719  23.057  1.00  0.00           H  
ATOM   1357  HB3 GLU A  87      23.313  72.435  21.322  1.00  0.00           H  
ATOM   1358  HG2 GLU A  87      21.063  73.701  21.324  1.00  0.00           H  
ATOM   1359  HG3 GLU A  87      21.576  74.274  22.911  1.00  0.00           H  
ATOM   1360  N   PHE A  88      20.012  71.211  20.702  1.00  0.00           N  
ATOM   1361  CA  PHE A  88      19.410  70.803  19.438  1.00  0.00           C  
ATOM   1362  C   PHE A  88      18.284  71.753  19.041  1.00  0.00           C  
ATOM   1363  O   PHE A  88      17.234  71.788  19.679  1.00  0.00           O  
ATOM   1364  CB  PHE A  88      18.875  69.374  19.541  1.00  0.00           C  
ATOM   1365  CG  PHE A  88      17.745  69.087  18.595  1.00  0.00           C  
ATOM   1366  CD1 PHE A  88      17.992  68.843  17.254  1.00  0.00           C  
ATOM   1367  CD2 PHE A  88      16.435  69.063  19.047  1.00  0.00           C  
ATOM   1368  CE1 PHE A  88      16.954  68.578  16.381  1.00  0.00           C  
ATOM   1369  CE2 PHE A  88      15.393  68.799  18.177  1.00  0.00           C  
ATOM   1370  CZ  PHE A  88      15.653  68.557  16.842  1.00  0.00           C  
ATOM   1371  H   PHE A  88      19.477  71.728  21.342  1.00  0.00           H  
ATOM   1372  HA  PHE A  88      20.179  70.837  18.681  1.00  0.00           H  
ATOM   1373  HB2 PHE A  88      19.674  68.681  19.323  1.00  0.00           H  
ATOM   1374  HB3 PHE A  88      18.520  69.202  20.546  1.00  0.00           H  
ATOM   1375  HD1 PHE A  88      19.010  68.859  16.890  1.00  0.00           H  
ATOM   1376  HD2 PHE A  88      16.230  69.253  20.090  1.00  0.00           H  
ATOM   1377  HE1 PHE A  88      17.160  68.389  15.337  1.00  0.00           H  
ATOM   1378  HE2 PHE A  88      14.377  68.784  18.542  1.00  0.00           H  
ATOM   1379  HZ  PHE A  88      14.840  68.350  16.162  1.00  0.00           H  
ATOM   1380  N   GLU A  89      18.513  72.521  17.980  1.00  0.00           N  
ATOM   1381  CA  GLU A  89      17.518  73.472  17.497  1.00  0.00           C  
ATOM   1382  C   GLU A  89      17.008  73.073  16.116  1.00  0.00           C  
ATOM   1383  O   GLU A  89      17.668  73.285  15.098  1.00  0.00           O  
ATOM   1384  CB  GLU A  89      18.111  74.882  17.447  1.00  0.00           C  
ATOM   1385  CG  GLU A  89      17.169  75.917  16.856  1.00  0.00           C  
ATOM   1386  CD  GLU A  89      17.185  75.922  15.338  1.00  0.00           C  
ATOM   1387  OE1 GLU A  89      18.280  76.077  14.758  1.00  0.00           O  
ATOM   1388  OE2 GLU A  89      16.103  75.771  14.733  1.00  0.00           O  
ATOM   1389  H   GLU A  89      19.371  72.447  17.512  1.00  0.00           H  
ATOM   1390  HA  GLU A  89      16.690  73.464  18.189  1.00  0.00           H  
ATOM   1391  HB2 GLU A  89      18.366  75.189  18.450  1.00  0.00           H  
ATOM   1392  HB3 GLU A  89      19.010  74.860  16.848  1.00  0.00           H  
ATOM   1393  HG2 GLU A  89      16.165  75.703  17.189  1.00  0.00           H  
ATOM   1394  HG3 GLU A  89      17.463  76.895  17.207  1.00  0.00           H  
ATOM   1395  N   PRO A  90      15.807  72.478  16.078  1.00  0.00           N  
ATOM   1396  CA  PRO A  90      15.182  72.036  14.828  1.00  0.00           C  
ATOM   1397  C   PRO A  90      14.739  73.205  13.955  1.00  0.00           C  
ATOM   1398  O   PRO A  90      13.613  73.687  14.073  1.00  0.00           O  
ATOM   1399  CB  PRO A  90      13.967  71.234  15.304  1.00  0.00           C  
ATOM   1400  CG  PRO A  90      13.649  71.791  16.648  1.00  0.00           C  
ATOM   1401  CD  PRO A  90      14.966  72.193  17.252  1.00  0.00           C  
ATOM   1402  HA  PRO A  90      15.840  71.393  14.260  1.00  0.00           H  
ATOM   1403  HB2 PRO A  90      13.148  71.374  14.613  1.00  0.00           H  
ATOM   1404  HB3 PRO A  90      14.223  70.187  15.360  1.00  0.00           H  
ATOM   1405  HG2 PRO A  90      13.004  72.650  16.546  1.00  0.00           H  
ATOM   1406  HG3 PRO A  90      13.174  71.034  17.255  1.00  0.00           H  
ATOM   1407  HD2 PRO A  90      14.846  73.074  17.865  1.00  0.00           H  
ATOM   1408  HD3 PRO A  90      15.379  71.380  17.833  1.00  0.00           H  
ATOM   1409  N   GLN A  91      15.633  73.657  13.081  1.00  0.00           N  
ATOM   1410  CA  GLN A  91      15.333  74.770  12.189  1.00  0.00           C  
ATOM   1411  C   GLN A  91      14.091  74.479  11.354  1.00  0.00           C  
ATOM   1412  O   GLN A  91      13.352  75.391  10.984  1.00  0.00           O  
ATOM   1413  CB  GLN A  91      16.525  75.051  11.271  1.00  0.00           C  
ATOM   1414  CG  GLN A  91      16.616  76.499  10.820  1.00  0.00           C  
ATOM   1415  CD  GLN A  91      17.519  77.332  11.709  1.00  0.00           C  
ATOM   1416  OE1 GLN A  91      18.501  77.914  11.246  1.00  0.00           O  
ATOM   1417  NE2 GLN A  91      17.191  77.394  12.994  1.00  0.00           N  
ATOM   1418  H   GLN A  91      16.513  73.230  13.035  1.00  0.00           H  
ATOM   1419  HA  GLN A  91      15.147  75.641  12.798  1.00  0.00           H  
ATOM   1420  HB2 GLN A  91      17.435  74.801  11.796  1.00  0.00           H  
ATOM   1421  HB3 GLN A  91      16.443  74.428  10.393  1.00  0.00           H  
ATOM   1422  HG2 GLN A  91      17.006  76.526   9.813  1.00  0.00           H  
ATOM   1423  HG3 GLN A  91      15.627  76.930  10.832  1.00  0.00           H  
ATOM   1424 HE21 GLN A  91      16.396  76.904  13.292  1.00  0.00           H  
ATOM   1425 HE22 GLN A  91      17.757  77.925  13.591  1.00  0.00           H  
ATOM   1426  N   SER A  92      13.867  73.202  11.058  1.00  0.00           N  
ATOM   1427  CA  SER A  92      12.717  72.792  10.263  1.00  0.00           C  
ATOM   1428  C   SER A  92      11.636  72.178  11.147  1.00  0.00           C  
ATOM   1429  O   SER A  92      11.933  71.533  12.153  1.00  0.00           O  
ATOM   1430  CB  SER A  92      13.144  71.789   9.189  1.00  0.00           C  
ATOM   1431  OG  SER A  92      14.189  72.313   8.388  1.00  0.00           O  
ATOM   1432  H   SER A  92      14.494  72.521  11.381  1.00  0.00           H  
ATOM   1433  HA  SER A  92      12.316  73.671   9.782  1.00  0.00           H  
ATOM   1434  HB2 SER A  92      13.490  70.884   9.664  1.00  0.00           H  
ATOM   1435  HB3 SER A  92      12.299  71.563   8.555  1.00  0.00           H  
ATOM   1436  HG  SER A  92      13.814  72.740   7.613  1.00  0.00           H  
ATOM   1437  N   VAL A  93      10.380  72.384  10.766  1.00  0.00           N  
ATOM   1438  CA  VAL A  93       9.254  71.852  11.522  1.00  0.00           C  
ATOM   1439  C   VAL A  93       8.984  70.397  11.155  1.00  0.00           C  
ATOM   1440  O   VAL A  93       8.954  70.037   9.978  1.00  0.00           O  
ATOM   1441  CB  VAL A  93       7.974  72.676  11.281  1.00  0.00           C  
ATOM   1442  CG1 VAL A  93       6.838  72.167  12.154  1.00  0.00           C  
ATOM   1443  CG2 VAL A  93       8.236  74.152  11.537  1.00  0.00           C  
ATOM   1444  H   VAL A  93      10.206  72.908   9.954  1.00  0.00           H  
ATOM   1445  HA  VAL A  93       9.499  71.909  12.572  1.00  0.00           H  
ATOM   1446  HB  VAL A  93       7.684  72.558  10.246  1.00  0.00           H  
ATOM   1447 HG11 VAL A  93       6.318  71.372  11.642  1.00  0.00           H  
ATOM   1448 HG12 VAL A  93       7.238  71.795  13.086  1.00  0.00           H  
ATOM   1449 HG13 VAL A  93       6.150  72.974  12.355  1.00  0.00           H  
ATOM   1450 HG21 VAL A  93       7.371  74.728  11.244  1.00  0.00           H  
ATOM   1451 HG22 VAL A  93       8.431  74.304  12.588  1.00  0.00           H  
ATOM   1452 HG23 VAL A  93       9.093  74.471  10.961  1.00  0.00           H  
ATOM   1453  N   GLY A  94       8.788  69.562  12.171  1.00  0.00           N  
ATOM   1454  CA  GLY A  94       8.523  68.155  11.935  1.00  0.00           C  
ATOM   1455  C   GLY A  94       9.195  67.259  12.956  1.00  0.00           C  
ATOM   1456  O   GLY A  94       9.543  67.704  14.048  1.00  0.00           O  
ATOM   1457  H   GLY A  94       8.823  69.904  13.089  1.00  0.00           H  
ATOM   1458  HA2 GLY A  94       7.456  67.989  11.973  1.00  0.00           H  
ATOM   1459  HA3 GLY A  94       8.883  67.893  10.951  1.00  0.00           H  
ATOM   1460  N   ASP A  95       9.377  65.992  12.600  1.00  0.00           N  
ATOM   1461  CA  ASP A  95      10.012  65.030  13.493  1.00  0.00           C  
ATOM   1462  C   ASP A  95      11.486  64.852  13.141  1.00  0.00           C  
ATOM   1463  O   ASP A  95      11.824  64.457  12.024  1.00  0.00           O  
ATOM   1464  CB  ASP A  95       9.292  63.683  13.423  1.00  0.00           C  
ATOM   1465  CG  ASP A  95       9.080  63.214  11.997  1.00  0.00           C  
ATOM   1466  OD1 ASP A  95       8.478  63.970  11.206  1.00  0.00           O  
ATOM   1467  OD2 ASP A  95       9.517  62.091  11.672  1.00  0.00           O  
ATOM   1468  H   ASP A  95       9.078  65.697  11.714  1.00  0.00           H  
ATOM   1469  HA  ASP A  95       9.940  65.414  14.499  1.00  0.00           H  
ATOM   1470  HB2 ASP A  95       9.879  62.940  13.943  1.00  0.00           H  
ATOM   1471  HB3 ASP A  95       8.327  63.772  13.901  1.00  0.00           H  
ATOM   1472  N   HIS A  96      12.358  65.146  14.100  1.00  0.00           N  
ATOM   1473  CA  HIS A  96      13.796  65.019  13.890  1.00  0.00           C  
ATOM   1474  C   HIS A  96      14.378  63.919  14.772  1.00  0.00           C  
ATOM   1475  O   HIS A  96      14.237  63.951  15.996  1.00  0.00           O  
ATOM   1476  CB  HIS A  96      14.495  66.347  14.183  1.00  0.00           C  
ATOM   1477  CG  HIS A  96      13.946  67.499  13.397  1.00  0.00           C  
ATOM   1478  ND1 HIS A  96      14.727  68.301  12.594  1.00  0.00           N  
ATOM   1479  CD2 HIS A  96      12.685  67.979  13.295  1.00  0.00           C  
ATOM   1480  CE1 HIS A  96      13.971  69.227  12.031  1.00  0.00           C  
ATOM   1481  NE2 HIS A  96      12.728  69.054  12.441  1.00  0.00           N  
ATOM   1482  H   HIS A  96      12.027  65.456  14.968  1.00  0.00           H  
ATOM   1483  HA  HIS A  96      13.959  64.757  12.856  1.00  0.00           H  
ATOM   1484  HB2 HIS A  96      14.387  66.580  15.232  1.00  0.00           H  
ATOM   1485  HB3 HIS A  96      15.545  66.253  13.947  1.00  0.00           H  
ATOM   1486  HD1 HIS A  96      15.693  68.207  12.456  1.00  0.00           H  
ATOM   1487  HD2 HIS A  96      11.808  67.591  13.793  1.00  0.00           H  
ATOM   1488  HE1 HIS A  96      14.311  69.996  11.353  1.00  0.00           H  
ATOM   1489  HE2 HIS A  96      11.979  69.654  12.243  1.00  0.00           H  
ATOM   1490  N   SER A  97      15.032  62.946  14.144  1.00  0.00           N  
ATOM   1491  CA  SER A  97      15.631  61.834  14.872  1.00  0.00           C  
ATOM   1492  C   SER A  97      17.055  61.573  14.390  1.00  0.00           C  
ATOM   1493  O   SER A  97      17.347  61.675  13.199  1.00  0.00           O  
ATOM   1494  CB  SER A  97      14.784  60.571  14.703  1.00  0.00           C  
ATOM   1495  OG  SER A  97      14.758  60.152  13.350  1.00  0.00           O  
ATOM   1496  H   SER A  97      15.110  62.977  13.168  1.00  0.00           H  
ATOM   1497  HA  SER A  97      15.661  62.100  15.919  1.00  0.00           H  
ATOM   1498  HB2 SER A  97      15.201  59.778  15.305  1.00  0.00           H  
ATOM   1499  HB3 SER A  97      13.773  60.774  15.025  1.00  0.00           H  
ATOM   1500  HG  SER A  97      14.291  59.316  13.283  1.00  0.00           H  
ATOM   1501  N   GLY A  98      17.938  61.237  15.326  1.00  0.00           N  
ATOM   1502  CA  GLY A  98      19.320  60.967  14.977  1.00  0.00           C  
ATOM   1503  C   GLY A  98      19.928  59.869  15.828  1.00  0.00           C  
ATOM   1504  O   GLY A  98      19.216  59.008  16.344  1.00  0.00           O  
ATOM   1505  H   GLY A  98      17.647  61.171  16.260  1.00  0.00           H  
ATOM   1506  HA2 GLY A  98      19.369  60.674  13.940  1.00  0.00           H  
ATOM   1507  HA3 GLY A  98      19.896  61.871  15.113  1.00  0.00           H  
ATOM   1508  N   ARG A  99      21.249  59.897  15.972  1.00  0.00           N  
ATOM   1509  CA  ARG A  99      21.953  58.894  16.762  1.00  0.00           C  
ATOM   1510  C   ARG A  99      23.307  59.421  17.227  1.00  0.00           C  
ATOM   1511  O   ARG A  99      24.111  59.893  16.423  1.00  0.00           O  
ATOM   1512  CB  ARG A  99      22.144  57.614  15.949  1.00  0.00           C  
ATOM   1513  CG  ARG A  99      22.254  56.360  16.801  1.00  0.00           C  
ATOM   1514  CD  ARG A  99      22.508  55.127  15.949  1.00  0.00           C  
ATOM   1515  NE  ARG A  99      21.265  54.489  15.525  1.00  0.00           N  
ATOM   1516  CZ  ARG A  99      21.171  53.204  15.202  1.00  0.00           C  
ATOM   1517  NH1 ARG A  99      22.243  52.424  15.257  1.00  0.00           N  
ATOM   1518  NH2 ARG A  99      20.005  52.696  14.826  1.00  0.00           N  
ATOM   1519  H   ARG A  99      21.763  60.609  15.536  1.00  0.00           H  
ATOM   1520  HA  ARG A  99      21.349  58.673  17.630  1.00  0.00           H  
ATOM   1521  HB2 ARG A  99      21.302  57.496  15.282  1.00  0.00           H  
ATOM   1522  HB3 ARG A  99      23.046  57.706  15.363  1.00  0.00           H  
ATOM   1523  HG2 ARG A  99      23.072  56.479  17.495  1.00  0.00           H  
ATOM   1524  HG3 ARG A  99      21.332  56.226  17.348  1.00  0.00           H  
ATOM   1525  HD2 ARG A  99      23.068  55.421  15.073  1.00  0.00           H  
ATOM   1526  HD3 ARG A  99      23.087  54.421  16.524  1.00  0.00           H  
ATOM   1527  HE  ARG A  99      20.461  55.047  15.478  1.00  0.00           H  
ATOM   1528 HH11 ARG A  99      23.123  52.803  15.540  1.00  0.00           H  
ATOM   1529 HH12 ARG A  99      22.169  51.456  15.015  1.00  0.00           H  
ATOM   1530 HH21 ARG A  99      19.195  53.280  14.785  1.00  0.00           H  
ATOM   1531 HH22 ARG A  99      19.936  51.728  14.583  1.00  0.00           H  
ATOM   1532  N   LEU A 100      23.553  59.338  18.530  1.00  0.00           N  
ATOM   1533  CA  LEU A 100      24.811  59.806  19.104  1.00  0.00           C  
ATOM   1534  C   LEU A 100      25.835  58.678  19.165  1.00  0.00           C  
ATOM   1535  O   LEU A 100      25.725  57.771  19.991  1.00  0.00           O  
ATOM   1536  CB  LEU A 100      24.576  60.374  20.504  1.00  0.00           C  
ATOM   1537  CG  LEU A 100      23.563  61.516  20.604  1.00  0.00           C  
ATOM   1538  CD1 LEU A 100      23.212  61.792  22.058  1.00  0.00           C  
ATOM   1539  CD2 LEU A 100      24.107  62.771  19.937  1.00  0.00           C  
ATOM   1540  H   LEU A 100      22.874  58.952  19.122  1.00  0.00           H  
ATOM   1541  HA  LEU A 100      25.194  60.589  18.466  1.00  0.00           H  
ATOM   1542  HB2 LEU A 100      24.229  59.569  21.133  1.00  0.00           H  
ATOM   1543  HB3 LEU A 100      25.523  60.737  20.876  1.00  0.00           H  
ATOM   1544  HG  LEU A 100      22.655  61.230  20.091  1.00  0.00           H  
ATOM   1545 HD11 LEU A 100      22.153  61.650  22.207  1.00  0.00           H  
ATOM   1546 HD12 LEU A 100      23.477  62.810  22.305  1.00  0.00           H  
ATOM   1547 HD13 LEU A 100      23.760  61.114  22.695  1.00  0.00           H  
ATOM   1548 HD21 LEU A 100      24.490  62.521  18.958  1.00  0.00           H  
ATOM   1549 HD22 LEU A 100      24.900  63.184  20.541  1.00  0.00           H  
ATOM   1550 HD23 LEU A 100      23.314  63.498  19.838  1.00  0.00           H  
ATOM   1551  N   ILE A 101      26.832  58.741  18.288  1.00  0.00           N  
ATOM   1552  CA  ILE A 101      27.877  57.727  18.246  1.00  0.00           C  
ATOM   1553  C   ILE A 101      29.041  58.099  19.157  1.00  0.00           C  
ATOM   1554  O   ILE A 101      29.820  59.000  18.851  1.00  0.00           O  
ATOM   1555  CB  ILE A 101      28.406  57.523  16.813  1.00  0.00           C  
ATOM   1556  CG1 ILE A 101      27.246  57.253  15.852  1.00  0.00           C  
ATOM   1557  CG2 ILE A 101      29.409  56.380  16.777  1.00  0.00           C  
ATOM   1558  CD1 ILE A 101      26.386  56.077  16.259  1.00  0.00           C  
ATOM   1559  H   ILE A 101      26.864  59.489  17.656  1.00  0.00           H  
ATOM   1560  HA  ILE A 101      27.449  56.794  18.586  1.00  0.00           H  
ATOM   1561  HB  ILE A 101      28.913  58.425  16.509  1.00  0.00           H  
ATOM   1562 HG12 ILE A 101      26.615  58.125  15.805  1.00  0.00           H  
ATOM   1563 HG13 ILE A 101      27.645  57.048  14.869  1.00  0.00           H  
ATOM   1564 HG21 ILE A 101      30.250  56.619  17.412  1.00  0.00           H  
ATOM   1565 HG22 ILE A 101      28.937  55.476  17.132  1.00  0.00           H  
ATOM   1566 HG23 ILE A 101      29.752  56.234  15.764  1.00  0.00           H  
ATOM   1567 HD11 ILE A 101      25.776  56.355  17.107  1.00  0.00           H  
ATOM   1568 HD12 ILE A 101      25.747  55.796  15.434  1.00  0.00           H  
ATOM   1569 HD13 ILE A 101      27.017  55.244  16.528  1.00  0.00           H  
ATOM   1570  N   VAL A 102      29.154  57.396  20.280  1.00  0.00           N  
ATOM   1571  CA  VAL A 102      30.225  57.650  21.237  1.00  0.00           C  
ATOM   1572  C   VAL A 102      31.454  56.805  20.921  1.00  0.00           C  
ATOM   1573  O   VAL A 102      31.337  55.654  20.498  1.00  0.00           O  
ATOM   1574  CB  VAL A 102      29.770  57.357  22.679  1.00  0.00           C  
ATOM   1575  CG1 VAL A 102      30.844  57.773  23.672  1.00  0.00           C  
ATOM   1576  CG2 VAL A 102      28.455  58.062  22.976  1.00  0.00           C  
ATOM   1577  H   VAL A 102      28.501  56.690  20.470  1.00  0.00           H  
ATOM   1578  HA  VAL A 102      30.491  58.694  21.170  1.00  0.00           H  
ATOM   1579  HB  VAL A 102      29.614  56.293  22.777  1.00  0.00           H  
ATOM   1580 HG11 VAL A 102      31.129  56.920  24.272  1.00  0.00           H  
ATOM   1581 HG12 VAL A 102      31.707  58.143  23.136  1.00  0.00           H  
ATOM   1582 HG13 VAL A 102      30.458  58.551  24.314  1.00  0.00           H  
ATOM   1583 HG21 VAL A 102      28.256  58.792  22.206  1.00  0.00           H  
ATOM   1584 HG22 VAL A 102      27.657  57.336  23.001  1.00  0.00           H  
ATOM   1585 HG23 VAL A 102      28.521  58.558  23.934  1.00  0.00           H  
ATOM   1586  N   CYS A 103      32.632  57.382  21.132  1.00  0.00           N  
ATOM   1587  CA  CYS A 103      33.885  56.683  20.870  1.00  0.00           C  
ATOM   1588  C   CYS A 103      34.697  56.526  22.151  1.00  0.00           C  
ATOM   1589  O   CYS A 103      34.983  57.505  22.841  1.00  0.00           O  
ATOM   1590  CB  CYS A 103      34.703  57.436  19.821  1.00  0.00           C  
ATOM   1591  SG  CYS A 103      34.352  56.941  18.117  1.00  0.00           S  
ATOM   1592  H   CYS A 103      32.660  58.301  21.471  1.00  0.00           H  
ATOM   1593  HA  CYS A 103      33.642  55.702  20.490  1.00  0.00           H  
ATOM   1594  HB2 CYS A 103      34.497  58.492  19.904  1.00  0.00           H  
ATOM   1595  HB3 CYS A 103      35.754  57.264  20.005  1.00  0.00           H  
ATOM   1596  HG  CYS A 103      33.442  55.980  18.150  1.00  0.00           H  
ATOM   1597  N   TYR A 104      35.065  55.288  22.464  1.00  0.00           N  
ATOM   1598  CA  TYR A 104      35.842  55.003  23.664  1.00  0.00           C  
ATOM   1599  C   TYR A 104      37.325  54.869  23.334  1.00  0.00           C  
ATOM   1600  O   TYR A 104      37.694  54.509  22.217  1.00  0.00           O  
ATOM   1601  CB  TYR A 104      35.339  53.720  24.330  1.00  0.00           C  
ATOM   1602  CG  TYR A 104      34.140  53.933  25.226  1.00  0.00           C  
ATOM   1603  CD1 TYR A 104      32.870  54.107  24.690  1.00  0.00           C  
ATOM   1604  CD2 TYR A 104      34.277  53.958  26.608  1.00  0.00           C  
ATOM   1605  CE1 TYR A 104      31.772  54.303  25.506  1.00  0.00           C  
ATOM   1606  CE2 TYR A 104      33.184  54.151  27.431  1.00  0.00           C  
ATOM   1607  CZ  TYR A 104      31.934  54.323  26.875  1.00  0.00           C  
ATOM   1608  OH  TYR A 104      30.843  54.517  27.690  1.00  0.00           O  
ATOM   1609  H   TYR A 104      34.808  54.549  21.874  1.00  0.00           H  
ATOM   1610  HA  TYR A 104      35.710  55.827  24.350  1.00  0.00           H  
ATOM   1611  HB2 TYR A 104      35.059  53.012  23.565  1.00  0.00           H  
ATOM   1612  HB3 TYR A 104      36.132  53.299  24.930  1.00  0.00           H  
ATOM   1613  HD1 TYR A 104      32.746  54.090  23.617  1.00  0.00           H  
ATOM   1614  HD2 TYR A 104      35.258  53.823  27.041  1.00  0.00           H  
ATOM   1615  HE1 TYR A 104      30.793  54.437  25.071  1.00  0.00           H  
ATOM   1616  HE2 TYR A 104      33.311  54.168  28.503  1.00  0.00           H  
ATOM   1617  HH  TYR A 104      30.457  55.378  27.511  1.00  0.00           H  
ATOM   1618  N   ASP A 105      38.171  55.164  24.316  1.00  0.00           N  
ATOM   1619  CA  ASP A 105      39.615  55.075  24.133  1.00  0.00           C  
ATOM   1620  C   ASP A 105      40.039  53.641  23.831  1.00  0.00           C  
ATOM   1621  O   ASP A 105      40.944  53.405  23.031  1.00  0.00           O  
ATOM   1622  CB  ASP A 105      40.342  55.583  25.379  1.00  0.00           C  
ATOM   1623  CG  ASP A 105      41.821  55.810  25.136  1.00  0.00           C  
ATOM   1624  OD1 ASP A 105      42.173  56.315  24.049  1.00  0.00           O  
ATOM   1625  OD2 ASP A 105      42.626  55.482  26.033  1.00  0.00           O  
ATOM   1626  H   ASP A 105      37.816  55.446  25.185  1.00  0.00           H  
ATOM   1627  HA  ASP A 105      39.882  55.700  23.293  1.00  0.00           H  
ATOM   1628  HB2 ASP A 105      39.899  56.519  25.689  1.00  0.00           H  
ATOM   1629  HB3 ASP A 105      40.232  54.857  26.172  1.00  0.00           H  
ATOM   1630  N   THR A 106      39.378  52.686  24.477  1.00  0.00           N  
ATOM   1631  CA  THR A 106      39.686  51.275  24.280  1.00  0.00           C  
ATOM   1632  C   THR A 106      39.359  50.834  22.859  1.00  0.00           C  
ATOM   1633  O   THR A 106      40.076  50.028  22.268  1.00  0.00           O  
ATOM   1634  CB  THR A 106      38.912  50.388  25.272  1.00  0.00           C  
ATOM   1635  OG1 THR A 106      39.212  49.008  25.032  1.00  0.00           O  
ATOM   1636  CG2 THR A 106      37.413  50.615  25.148  1.00  0.00           C  
ATOM   1637  H   THR A 106      38.666  52.938  25.102  1.00  0.00           H  
ATOM   1638  HA  THR A 106      40.744  51.137  24.455  1.00  0.00           H  
ATOM   1639  HB  THR A 106      39.218  50.644  26.277  1.00  0.00           H  
ATOM   1640  HG1 THR A 106      39.978  48.751  25.552  1.00  0.00           H  
ATOM   1641 HG21 THR A 106      36.972  50.651  26.132  1.00  0.00           H  
ATOM   1642 HG22 THR A 106      36.972  49.806  24.584  1.00  0.00           H  
ATOM   1643 HG23 THR A 106      37.233  51.550  24.638  1.00  0.00           H  
ATOM   1644  N   GLY A 107      38.270  51.369  22.313  1.00  0.00           N  
ATOM   1645  CA  GLY A 107      37.867  51.017  20.965  1.00  0.00           C  
ATOM   1646  C   GLY A 107      36.443  50.504  20.900  1.00  0.00           C  
ATOM   1647  O   GLY A 107      36.164  49.513  20.226  1.00  0.00           O  
ATOM   1648  H   GLY A 107      37.736  52.007  22.832  1.00  0.00           H  
ATOM   1649  HA2 GLY A 107      37.952  51.893  20.336  1.00  0.00           H  
ATOM   1650  HA3 GLY A 107      38.531  50.252  20.590  1.00  0.00           H  
ATOM   1651  N   GLU A 108      35.539  51.178  21.605  1.00  0.00           N  
ATOM   1652  CA  GLU A 108      34.137  50.779  21.626  1.00  0.00           C  
ATOM   1653  C   GLU A 108      33.254  51.863  21.013  1.00  0.00           C  
ATOM   1654  O   GLU A 108      33.701  52.987  20.781  1.00  0.00           O  
ATOM   1655  CB  GLU A 108      33.687  50.492  23.060  1.00  0.00           C  
ATOM   1656  CG  GLU A 108      34.031  49.091  23.536  1.00  0.00           C  
ATOM   1657  CD  GLU A 108      33.730  48.029  22.497  1.00  0.00           C  
ATOM   1658  OE1 GLU A 108      32.536  47.729  22.286  1.00  0.00           O  
ATOM   1659  OE2 GLU A 108      34.687  47.500  21.893  1.00  0.00           O  
ATOM   1660  H   GLU A 108      35.822  51.959  22.123  1.00  0.00           H  
ATOM   1661  HA  GLU A 108      34.038  49.878  21.040  1.00  0.00           H  
ATOM   1662  HB2 GLU A 108      34.159  51.202  23.723  1.00  0.00           H  
ATOM   1663  HB3 GLU A 108      32.615  50.615  23.120  1.00  0.00           H  
ATOM   1664  HG2 GLU A 108      35.085  49.054  23.770  1.00  0.00           H  
ATOM   1665  HG3 GLU A 108      33.459  48.875  24.426  1.00  0.00           H  
ATOM   1666  N   LYS A 109      31.998  51.517  20.750  1.00  0.00           N  
ATOM   1667  CA  LYS A 109      31.052  52.458  20.164  1.00  0.00           C  
ATOM   1668  C   LYS A 109      29.691  52.358  20.847  1.00  0.00           C  
ATOM   1669  O   LYS A 109      29.310  51.297  21.342  1.00  0.00           O  
ATOM   1670  CB  LYS A 109      30.901  52.195  18.663  1.00  0.00           C  
ATOM   1671  CG  LYS A 109      30.539  53.433  17.862  1.00  0.00           C  
ATOM   1672  CD  LYS A 109      30.704  53.199  16.370  1.00  0.00           C  
ATOM   1673  CE  LYS A 109      29.525  52.432  15.792  1.00  0.00           C  
ATOM   1674  NZ  LYS A 109      29.901  51.679  14.564  1.00  0.00           N  
ATOM   1675  H   LYS A 109      31.701  50.605  20.957  1.00  0.00           H  
ATOM   1676  HA  LYS A 109      31.441  53.454  20.309  1.00  0.00           H  
ATOM   1677  HB2 LYS A 109      31.834  51.805  18.284  1.00  0.00           H  
ATOM   1678  HB3 LYS A 109      30.125  51.456  18.516  1.00  0.00           H  
ATOM   1679  HG2 LYS A 109      29.511  53.694  18.063  1.00  0.00           H  
ATOM   1680  HG3 LYS A 109      31.184  54.247  18.164  1.00  0.00           H  
ATOM   1681  HD2 LYS A 109      30.777  54.154  15.871  1.00  0.00           H  
ATOM   1682  HD3 LYS A 109      31.609  52.633  16.201  1.00  0.00           H  
ATOM   1683  HE2 LYS A 109      29.167  51.735  16.536  1.00  0.00           H  
ATOM   1684  HE3 LYS A 109      28.740  53.133  15.550  1.00  0.00           H  
ATOM   1685  HZ1 LYS A 109      30.550  50.903  14.804  1.00  0.00           H  
ATOM   1686  HZ2 LYS A 109      30.371  52.313  13.887  1.00  0.00           H  
ATOM   1687  HZ3 LYS A 109      29.052  51.280  14.116  1.00  0.00           H  
ATOM   1688  N   VAL A 110      28.962  53.470  20.869  1.00  0.00           N  
ATOM   1689  CA  VAL A 110      27.643  53.506  21.489  1.00  0.00           C  
ATOM   1690  C   VAL A 110      26.597  54.052  20.524  1.00  0.00           C  
ATOM   1691  O   VAL A 110      26.924  54.762  19.574  1.00  0.00           O  
ATOM   1692  CB  VAL A 110      27.646  54.367  22.766  1.00  0.00           C  
ATOM   1693  CG1 VAL A 110      26.285  54.325  23.442  1.00  0.00           C  
ATOM   1694  CG2 VAL A 110      28.738  53.903  23.718  1.00  0.00           C  
ATOM   1695  H   VAL A 110      29.319  54.284  20.458  1.00  0.00           H  
ATOM   1696  HA  VAL A 110      27.374  52.495  21.762  1.00  0.00           H  
ATOM   1697  HB  VAL A 110      27.853  55.389  22.486  1.00  0.00           H  
ATOM   1698 HG11 VAL A 110      26.318  54.903  24.354  1.00  0.00           H  
ATOM   1699 HG12 VAL A 110      25.540  54.740  22.779  1.00  0.00           H  
ATOM   1700 HG13 VAL A 110      26.029  53.301  23.674  1.00  0.00           H  
ATOM   1701 HG21 VAL A 110      28.792  52.824  23.707  1.00  0.00           H  
ATOM   1702 HG22 VAL A 110      29.686  54.315  23.406  1.00  0.00           H  
ATOM   1703 HG23 VAL A 110      28.511  54.241  24.720  1.00  0.00           H  
ATOM   1704  N   PHE A 111      25.335  53.715  20.775  1.00  0.00           N  
ATOM   1705  CA  PHE A 111      24.240  54.171  19.927  1.00  0.00           C  
ATOM   1706  C   PHE A 111      23.095  54.724  20.770  1.00  0.00           C  
ATOM   1707  O   PHE A 111      22.501  54.010  21.577  1.00  0.00           O  
ATOM   1708  CB  PHE A 111      23.734  53.024  19.050  1.00  0.00           C  
ATOM   1709  CG  PHE A 111      24.772  52.488  18.107  1.00  0.00           C  
ATOM   1710  CD1 PHE A 111      25.322  53.300  17.128  1.00  0.00           C  
ATOM   1711  CD2 PHE A 111      25.199  51.173  18.198  1.00  0.00           C  
ATOM   1712  CE1 PHE A 111      26.278  52.808  16.257  1.00  0.00           C  
ATOM   1713  CE2 PHE A 111      26.153  50.676  17.331  1.00  0.00           C  
ATOM   1714  CZ  PHE A 111      26.695  51.496  16.360  1.00  0.00           C  
ATOM   1715  H   PHE A 111      25.138  53.145  21.548  1.00  0.00           H  
ATOM   1716  HA  PHE A 111      24.618  54.958  19.293  1.00  0.00           H  
ATOM   1717  HB2 PHE A 111      23.411  52.211  19.683  1.00  0.00           H  
ATOM   1718  HB3 PHE A 111      22.897  53.372  18.462  1.00  0.00           H  
ATOM   1719  HD1 PHE A 111      24.999  54.327  17.047  1.00  0.00           H  
ATOM   1720  HD2 PHE A 111      24.776  50.531  18.959  1.00  0.00           H  
ATOM   1721  HE1 PHE A 111      26.700  53.452  15.499  1.00  0.00           H  
ATOM   1722  HE2 PHE A 111      26.477  49.649  17.415  1.00  0.00           H  
ATOM   1723  HZ  PHE A 111      27.440  51.110  15.681  1.00  0.00           H  
ATOM   1724  N   VAL A 112      22.790  56.005  20.576  1.00  0.00           N  
ATOM   1725  CA  VAL A 112      21.716  56.655  21.318  1.00  0.00           C  
ATOM   1726  C   VAL A 112      20.826  57.473  20.389  1.00  0.00           C  
ATOM   1727  O   VAL A 112      21.184  58.578  19.982  1.00  0.00           O  
ATOM   1728  CB  VAL A 112      22.273  57.576  22.419  1.00  0.00           C  
ATOM   1729  CG1 VAL A 112      21.139  58.263  23.165  1.00  0.00           C  
ATOM   1730  CG2 VAL A 112      23.154  56.789  23.378  1.00  0.00           C  
ATOM   1731  H   VAL A 112      23.300  56.522  19.919  1.00  0.00           H  
ATOM   1732  HA  VAL A 112      21.122  55.886  21.788  1.00  0.00           H  
ATOM   1733  HB  VAL A 112      22.880  58.338  21.951  1.00  0.00           H  
ATOM   1734 HG11 VAL A 112      21.540  58.797  24.014  1.00  0.00           H  
ATOM   1735 HG12 VAL A 112      20.641  58.956  22.504  1.00  0.00           H  
ATOM   1736 HG13 VAL A 112      20.434  57.520  23.508  1.00  0.00           H  
ATOM   1737 HG21 VAL A 112      24.107  56.590  22.911  1.00  0.00           H  
ATOM   1738 HG22 VAL A 112      23.305  57.362  24.280  1.00  0.00           H  
ATOM   1739 HG23 VAL A 112      22.672  55.853  23.623  1.00  0.00           H  
ATOM   1740  N   SER A 113      19.662  56.922  20.058  1.00  0.00           N  
ATOM   1741  CA  SER A 113      18.719  57.599  19.175  1.00  0.00           C  
ATOM   1742  C   SER A 113      18.374  58.986  19.709  1.00  0.00           C  
ATOM   1743  O   SER A 113      18.319  59.202  20.920  1.00  0.00           O  
ATOM   1744  CB  SER A 113      17.444  56.766  19.022  1.00  0.00           C  
ATOM   1745  OG  SER A 113      17.739  55.465  18.547  1.00  0.00           O  
ATOM   1746  H   SER A 113      19.433  56.038  20.416  1.00  0.00           H  
ATOM   1747  HA  SER A 113      19.189  57.704  18.209  1.00  0.00           H  
ATOM   1748  HB2 SER A 113      16.955  56.684  19.981  1.00  0.00           H  
ATOM   1749  HB3 SER A 113      16.783  57.253  18.320  1.00  0.00           H  
ATOM   1750  HG  SER A 113      18.109  55.523  17.662  1.00  0.00           H  
ATOM   1751  N   LEU A 114      18.143  59.922  18.796  1.00  0.00           N  
ATOM   1752  CA  LEU A 114      17.802  61.290  19.173  1.00  0.00           C  
ATOM   1753  C   LEU A 114      16.367  61.622  18.779  1.00  0.00           C  
ATOM   1754  O   LEU A 114      15.802  61.007  17.874  1.00  0.00           O  
ATOM   1755  CB  LEU A 114      18.767  62.277  18.512  1.00  0.00           C  
ATOM   1756  CG  LEU A 114      20.183  62.316  19.085  1.00  0.00           C  
ATOM   1757  CD1 LEU A 114      21.073  63.222  18.246  1.00  0.00           C  
ATOM   1758  CD2 LEU A 114      20.160  62.782  20.533  1.00  0.00           C  
ATOM   1759  H   LEU A 114      18.201  59.690  17.846  1.00  0.00           H  
ATOM   1760  HA  LEU A 114      17.897  61.371  20.246  1.00  0.00           H  
ATOM   1761  HB2 LEU A 114      18.840  62.018  17.467  1.00  0.00           H  
ATOM   1762  HB3 LEU A 114      18.342  63.267  18.607  1.00  0.00           H  
ATOM   1763  HG  LEU A 114      20.604  61.320  19.060  1.00  0.00           H  
ATOM   1764 HD11 LEU A 114      21.837  62.630  17.766  1.00  0.00           H  
ATOM   1765 HD12 LEU A 114      21.535  63.961  18.883  1.00  0.00           H  
ATOM   1766 HD13 LEU A 114      20.476  63.718  17.495  1.00  0.00           H  
ATOM   1767 HD21 LEU A 114      19.642  63.727  20.599  1.00  0.00           H  
ATOM   1768 HD22 LEU A 114      21.174  62.900  20.889  1.00  0.00           H  
ATOM   1769 HD23 LEU A 114      19.650  62.046  21.139  1.00  0.00           H  
ATOM   1770  N   TYR A 115      15.783  62.600  19.462  1.00  0.00           N  
ATOM   1771  CA  TYR A 115      14.413  63.015  19.184  1.00  0.00           C  
ATOM   1772  C   TYR A 115      14.220  64.498  19.487  1.00  0.00           C  
ATOM   1773  O   TYR A 115      15.077  65.134  20.099  1.00  0.00           O  
ATOM   1774  CB  TYR A 115      13.429  62.183  20.008  1.00  0.00           C  
ATOM   1775  CG  TYR A 115      12.777  61.066  19.224  1.00  0.00           C  
ATOM   1776  CD1 TYR A 115      11.750  61.328  18.325  1.00  0.00           C  
ATOM   1777  CD2 TYR A 115      13.189  59.749  19.382  1.00  0.00           C  
ATOM   1778  CE1 TYR A 115      11.151  60.310  17.609  1.00  0.00           C  
ATOM   1779  CE2 TYR A 115      12.597  58.724  18.668  1.00  0.00           C  
ATOM   1780  CZ  TYR A 115      11.578  59.010  17.783  1.00  0.00           C  
ATOM   1781  OH  TYR A 115      10.986  57.994  17.069  1.00  0.00           O  
ATOM   1782  H   TYR A 115      16.284  63.054  20.172  1.00  0.00           H  
ATOM   1783  HA  TYR A 115      14.222  62.846  18.134  1.00  0.00           H  
ATOM   1784  HB2 TYR A 115      13.952  61.741  20.841  1.00  0.00           H  
ATOM   1785  HB3 TYR A 115      12.646  62.827  20.380  1.00  0.00           H  
ATOM   1786  HD1 TYR A 115      11.419  62.348  18.190  1.00  0.00           H  
ATOM   1787  HD2 TYR A 115      13.986  59.528  20.076  1.00  0.00           H  
ATOM   1788  HE1 TYR A 115      10.355  60.534  16.915  1.00  0.00           H  
ATOM   1789  HE2 TYR A 115      12.931  57.706  18.805  1.00  0.00           H  
ATOM   1790  HH  TYR A 115      10.031  58.064  17.146  1.00  0.00           H  
ATOM   1791  N   GLY A 116      13.087  65.041  19.054  1.00  0.00           N  
ATOM   1792  CA  GLY A 116      12.800  66.445  19.288  1.00  0.00           C  
ATOM   1793  C   GLY A 116      11.740  66.984  18.349  1.00  0.00           C  
ATOM   1794  O   GLY A 116      12.009  67.875  17.543  1.00  0.00           O  
ATOM   1795  H   GLY A 116      12.440  64.485  18.571  1.00  0.00           H  
ATOM   1796  HA2 GLY A 116      12.461  66.567  20.306  1.00  0.00           H  
ATOM   1797  HA3 GLY A 116      13.708  67.013  19.151  1.00  0.00           H  
ATOM   1798  N   ALA A 117      10.530  66.443  18.450  1.00  0.00           N  
ATOM   1799  CA  ALA A 117       9.426  66.876  17.603  1.00  0.00           C  
ATOM   1800  C   ALA A 117       9.255  68.390  17.655  1.00  0.00           C  
ATOM   1801  O   ALA A 117       8.910  68.951  18.694  1.00  0.00           O  
ATOM   1802  CB  ALA A 117       8.137  66.183  18.022  1.00  0.00           C  
ATOM   1803  H   ALA A 117      10.377  65.736  19.112  1.00  0.00           H  
ATOM   1804  HA  ALA A 117       9.650  66.583  16.588  1.00  0.00           H  
ATOM   1805  HB1 ALA A 117       8.364  65.193  18.389  1.00  0.00           H  
ATOM   1806  HB2 ALA A 117       7.659  66.757  18.803  1.00  0.00           H  
ATOM   1807  HB3 ALA A 117       7.475  66.110  17.171  1.00  0.00           H  
ATOM   1808  N   ALA A 118       9.501  69.048  16.526  1.00  0.00           N  
ATOM   1809  CA  ALA A 118       9.373  70.497  16.443  1.00  0.00           C  
ATOM   1810  C   ALA A 118       8.017  70.896  15.875  1.00  0.00           C  
ATOM   1811  O   ALA A 118       7.430  70.169  15.073  1.00  0.00           O  
ATOM   1812  CB  ALA A 118      10.496  71.078  15.595  1.00  0.00           C  
ATOM   1813  H   ALA A 118       9.774  68.545  15.730  1.00  0.00           H  
ATOM   1814  HA  ALA A 118       9.467  70.898  17.441  1.00  0.00           H  
ATOM   1815  HB1 ALA A 118      10.110  71.889  14.995  1.00  0.00           H  
ATOM   1816  HB2 ALA A 118      11.279  71.447  16.239  1.00  0.00           H  
ATOM   1817  HB3 ALA A 118      10.893  70.309  14.949  1.00  0.00           H  
ATOM   1818  N   ILE A 119       7.523  72.057  16.294  1.00  0.00           N  
ATOM   1819  CA  ILE A 119       6.235  72.553  15.826  1.00  0.00           C  
ATOM   1820  C   ILE A 119       6.325  74.021  15.422  1.00  0.00           C  
ATOM   1821  O   ILE A 119       7.187  74.756  15.902  1.00  0.00           O  
ATOM   1822  CB  ILE A 119       5.146  72.394  16.903  1.00  0.00           C  
ATOM   1823  CG1 ILE A 119       5.574  73.084  18.199  1.00  0.00           C  
ATOM   1824  CG2 ILE A 119       4.857  70.921  17.151  1.00  0.00           C  
ATOM   1825  CD1 ILE A 119       4.504  73.082  19.268  1.00  0.00           C  
ATOM   1826  H   ILE A 119       8.038  72.592  16.934  1.00  0.00           H  
ATOM   1827  HA  ILE A 119       5.947  71.969  14.963  1.00  0.00           H  
ATOM   1828  HB  ILE A 119       4.241  72.857  16.539  1.00  0.00           H  
ATOM   1829 HG12 ILE A 119       6.442  72.581  18.598  1.00  0.00           H  
ATOM   1830 HG13 ILE A 119       5.828  74.113  17.983  1.00  0.00           H  
ATOM   1831 HG21 ILE A 119       4.079  70.827  17.895  1.00  0.00           H  
ATOM   1832 HG22 ILE A 119       4.531  70.458  16.232  1.00  0.00           H  
ATOM   1833 HG23 ILE A 119       5.752  70.432  17.504  1.00  0.00           H  
ATOM   1834 HD11 ILE A 119       3.575  73.438  18.847  1.00  0.00           H  
ATOM   1835 HD12 ILE A 119       4.369  72.078  19.641  1.00  0.00           H  
ATOM   1836 HD13 ILE A 119       4.802  73.731  20.078  1.00  0.00           H  
ATOM   1837  N   ASP A 120       5.426  74.439  14.537  1.00  0.00           N  
ATOM   1838  CA  ASP A 120       5.402  75.822  14.070  1.00  0.00           C  
ATOM   1839  C   ASP A 120       4.642  76.712  15.048  1.00  0.00           C  
ATOM   1840  O   ASP A 120       4.232  77.820  14.703  1.00  0.00           O  
ATOM   1841  CB  ASP A 120       4.762  75.901  12.684  1.00  0.00           C  
ATOM   1842  CG  ASP A 120       4.553  77.331  12.225  1.00  0.00           C  
ATOM   1843  OD1 ASP A 120       5.421  78.181  12.515  1.00  0.00           O  
ATOM   1844  OD2 ASP A 120       3.522  77.601  11.573  1.00  0.00           O  
ATOM   1845  H   ASP A 120       4.765  73.806  14.191  1.00  0.00           H  
ATOM   1846  HA  ASP A 120       6.422  76.168  14.005  1.00  0.00           H  
ATOM   1847  HB2 ASP A 120       5.402  75.404  11.969  1.00  0.00           H  
ATOM   1848  HB3 ASP A 120       3.803  75.406  12.708  1.00  0.00           H  
ATOM   1849  N   MET A 121       4.455  76.219  16.267  1.00  0.00           N  
ATOM   1850  CA  MET A 121       3.744  76.971  17.294  1.00  0.00           C  
ATOM   1851  C   MET A 121       4.073  78.457  17.206  1.00  0.00           C  
ATOM   1852  O   MET A 121       3.263  79.305  17.581  1.00  0.00           O  
ATOM   1853  CB  MET A 121       4.100  76.439  18.684  1.00  0.00           C  
ATOM   1854  CG  MET A 121       5.473  76.877  19.169  1.00  0.00           C  
ATOM   1855  SD  MET A 121       5.896  76.181  20.777  1.00  0.00           S  
ATOM   1856  CE  MET A 121       4.507  76.736  21.762  1.00  0.00           C  
ATOM   1857  H   MET A 121       4.804  75.329  16.483  1.00  0.00           H  
ATOM   1858  HA  MET A 121       2.685  76.838  17.128  1.00  0.00           H  
ATOM   1859  HB2 MET A 121       3.364  76.793  19.391  1.00  0.00           H  
ATOM   1860  HB3 MET A 121       4.077  75.360  18.661  1.00  0.00           H  
ATOM   1861  HG2 MET A 121       6.212  76.557  18.449  1.00  0.00           H  
ATOM   1862  HG3 MET A 121       5.487  77.954  19.242  1.00  0.00           H  
ATOM   1863  HE1 MET A 121       4.146  77.677  21.375  1.00  0.00           H  
ATOM   1864  HE2 MET A 121       3.717  76.001  21.717  1.00  0.00           H  
ATOM   1865  HE3 MET A 121       4.822  76.864  22.788  1.00  0.00           H  
ATOM   1866  N   ASN A 122       5.267  78.766  16.710  1.00  0.00           N  
ATOM   1867  CA  ASN A 122       5.702  80.152  16.572  1.00  0.00           C  
ATOM   1868  C   ASN A 122       6.762  80.283  15.484  1.00  0.00           C  
ATOM   1869  O   ASN A 122       7.831  79.679  15.568  1.00  0.00           O  
ATOM   1870  CB  ASN A 122       6.255  80.668  17.903  1.00  0.00           C  
ATOM   1871  CG  ASN A 122       6.124  82.172  18.039  1.00  0.00           C  
ATOM   1872  OD1 ASN A 122       5.064  82.684  18.400  1.00  0.00           O  
ATOM   1873  ND2 ASN A 122       7.204  82.888  17.749  1.00  0.00           N  
ATOM   1874  H   ASN A 122       5.868  78.046  16.428  1.00  0.00           H  
ATOM   1875  HA  ASN A 122       4.843  80.743  16.296  1.00  0.00           H  
ATOM   1876  HB2 ASN A 122       5.713  80.204  18.715  1.00  0.00           H  
ATOM   1877  HB3 ASN A 122       7.300  80.406  17.978  1.00  0.00           H  
ATOM   1878 HD21 ASN A 122       8.014  82.413  17.467  1.00  0.00           H  
ATOM   1879 HD22 ASN A 122       7.147  83.864  17.828  1.00  0.00           H  
TER    1880      ASN A 122                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
