
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  112 ( 1656),  selected  112 , name 2e6j_A
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 2e6j_A.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E     267           #
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      D     268          5.562
LGA    S     5_A      L     269          2.164
LGA    S     6_A      L     270          3.515
LGA    -       -      R     271           -
LGA    G     7_A      P     272          2.556
LGA    -       -      F     273           -
LGA    P     8_A      F     274          1.513
LGA    -       -      E     275           -
LGA    -       -      K     276           -
LGA    K     9_A      C     277          2.941
LGA    I    10_A      V     278          2.984
LGA    H    11_A      K     279          4.062
LGA    F    12_A      I     280          1.800
LGA    N    13_A      E     281          1.854
LGA    F    14_A      E     282           #
LGA    E    15_A      V     283           -
LGA    L    16_A      -       -           -
LGA    L    17_A      S     284           #
LGA    D    18_A      R     285           #
LGA    I    19_A      N     286          5.137
LGA    G    20_A      E     287           #
LGA    K    21_A      -       -           -
LGA    V    22_A      -       -           -
LGA    F    23_A      -       -           -
LGA    T    24_A      -       -           -
LGA    G    25_A      -       -           -
LGA    S    26_A      -       -           -
LGA    A    27_A      -       -           -
LGA    H    28_A      Q     288          0.691
LGA    C    29_A      G     289           #
LGA    Y    30_A      V     290          2.780
LGA    E    31_A      T     291          1.220
LGA    A    32_A      L     292          1.179
LGA    I    33_A      S     293          1.324
LGA    L    34_A      I     294          1.219
LGA    Y    35_A      T     295          1.359
LGA    N    36_A      N     296          1.430
LGA    K    37_A      V     297          3.206
LGA    G    38_A      T     298          3.307
LGA    S    39_A      D     299          1.414
LGA    I    40_A      L     300          3.078
LGA    D    41_A      V     301          2.177
LGA    A    42_A      L     302          1.721
LGA    L    43_A      K     303          1.152
LGA    F    44_A      L     304          1.366
LGA    N    45_A      K     305          1.792
LGA    M    46_A      K     306          2.301
LGA    T    47_A      T     307          2.338
LGA    P    48_A      A     308          3.789
LGA    P    49_A      H     309          1.141
LGA    T    50_A      -       -           -
LGA    S    51_A      -       -           -
LGA    A    52_A      -       -           -
LGA    L    53_A      -       -           -
LGA    G    54_A      D     310          2.830
LGA    A    55_A      T     311          1.457
LGA    C    56_A      L     312          1.367
LGA    F    57_A      L     313          1.904
LGA    V    58_A      V     314          1.014
LGA    F    59_A      Y     315          0.641
LGA    S    60_A      F     316          2.370
LGA    P    61_A      -       -           -
LGA    K    62_A      R     317          1.654
LGA    E    63_A      D     318          1.072
LGA    G    64_A      M     319          2.581
LGA    I    65_A      T     320          1.211
LGA    I    66_A      L     321          1.035
LGA    E    67_A      K     322          1.078
LGA    P    68_A      P     323          0.355
LGA    S    69_A      H     324          1.328
LGA    G    70_A      T     325          1.494
LGA    V    71_A      R     326          1.574
LGA    Q    72_A      Y     327          1.462
LGA    A    73_A      T     328          1.490
LGA    I    74_A      V     329          1.025
LGA    Q    75_A      R     330          2.075
LGA    I    76_A      I     331          1.674
LGA    S    77_A      G     332          1.393
LGA    F    78_A      F     333          1.103
LGA    S    79_A      K     334          2.082
LGA    S    80_A      Q     335          0.371
LGA    I    81_A      G     336          4.620
LGA    I    82_A      -       -           -
LGA    L    83_A      -       -           -
LGA    G    84_A      -       -           -
LGA    N    85_A      I     337           #
LGA    F    86_A      K     338          5.899
LGA    E    87_A      G     339          5.599
LGA    E    88_A      G     340          2.621
LGA    E    89_A      D     341          1.541
LGA    F    90_A      V     342          1.946
LGA    L    91_A      N     343          1.753
LGA    V    92_A      F     344          2.202
LGA    N    93_A      E     345          1.020
LGA    V    94_A      V     346          0.804
LGA    N    95_A      T     347          2.039
LGA    -       -      N     348           -
LGA    G    96_A      F     349          1.145
LGA    S    97_A      I     350          5.493
LGA    -       -      V     351           -
LGA    -       -      A     352           -
LGA    -       -      P     353           -
LGA    -       -      D     354           -
LGA    -       -      K     355           -
LGA    P    98_A      G     356          6.208
LGA    E    99_A      L     357          3.377
LGA    P   100_A      K     358          3.387
LGA    V   101_A      Y     359          3.471
LGA    K   102_A      T     360          1.471
LGA    L   103_A      I     361          1.172
LGA    T   104_A      S     362          1.144
LGA    I   105_A      L     363          1.664
LGA    R   106_A      -       -           -
LGA    G   107_A      -       -           -
LGA    C   108_A      -       -           -
LGA    V   109_A      -       -           -
LGA    I   110_A      -       -           -
LGA    G   111_A      -       -           -
LGA    P   112_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  112   97    5.0     79    2.53     8.86     57.745     3.003

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.015772 * X  +  -0.573470 * Y  +   0.819074 * Z  +  22.035690
  Y_new =  -0.995914 * X  +  -0.063838 * Y  +  -0.063873 * Z  +  58.826038
  Z_new =   0.088917 * X  +  -0.816735 * Y  +  -0.570121 * Z  +  25.588917 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.180211    0.961381  [ DEG:  -124.9169     55.0831 ]
  Theta =  -0.089035   -3.052558  [ DEG:    -5.1013   -174.8987 ]
  Phi   =  -1.586631    1.554961  [ DEG:   -90.9073     89.0927 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2e6j_A                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2e6j_A.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  112   97   5.0   79   2.53    8.86  57.745
REMARK  ---------------------------------------------------------- 
MOLECULE 2e6j_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   27-DEC-06   2E6J              
TITLE     SOLUTION STRUCTURE OF THE C-TERMINAL PAPD-LIKE DOMAIN FROM            
TITLE    2 HUMAN HYDIN PROTEIN                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYDIN PROTEIN;                                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PAPD DOMAIN;                                               
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: IOH11753;                                                      
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060327-17;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    PAPD, HYDIN, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT            
KEYWDS   2 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,M.SATO,S.KOSHIBA,S.WATANABE,T.HARADA,T.KIGAWA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   03-JUL-07 2E6J    0                                                
JRNL        AUTH   H.LI,M.SATO,S.KOSHIBA,S.WATANABE,T.HARADA,T.KIGAWA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE C-TERMINAL PAPD-LIKE               
JRNL        TITL 2 DOMAIN FROM HUMAN HYDIN PROTEIN                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2E6J A    8   112  UNP    Q8TC08   Q8TC08_HUMAN   480    584             
SEQRES   1 A  112  GLY SER SER GLY SER SER GLY PRO LYS ILE HIS PHE ASN          
SEQRES   2 A  112  PHE GLU LEU LEU ASP ILE GLY LYS VAL PHE THR GLY SER          
SEQRES   3 A  112  ALA HIS CYS TYR GLU ALA ILE LEU TYR ASN LYS GLY SER          
SEQRES   4 A  112  ILE ASP ALA LEU PHE ASN MET THR PRO PRO THR SER ALA          
SEQRES   5 A  112  LEU GLY ALA CYS PHE VAL PHE SER PRO LYS GLU GLY ILE          
SEQRES   6 A  112  ILE GLU PRO SER GLY VAL GLN ALA ILE GLN ILE SER PHE          
SEQRES   7 A  112  SER SER ILE ILE LEU GLY ASN PHE GLU GLU GLU PHE LEU          
SEQRES   8 A  112  VAL ASN VAL ASN GLY SER PRO GLU PRO VAL LYS LEU THR          
SEQRES   9 A  112  ILE ARG GLY CYS VAL ILE GLY PRO                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      36.984  42.831  26.924  1.00  0.00           N  
ATOM      2  CA  GLY A   1      36.983  41.380  26.891  1.00  0.00           C  
ATOM      3  C   GLY A   1      37.039  40.832  25.478  1.00  0.00           C  
ATOM      4  O   GLY A   1      36.010  40.696  24.817  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      37.839  41.018  27.440  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      36.082  41.020  27.368  1.00  0.00           H  
ATOM      7  H1  GLY A   1      37.667  43.307  27.441  1.00  0.00           H  
ATOM      8  N   SER A   2      38.245  40.519  25.015  1.00  0.00           N  
ATOM      9  CA  SER A   2      38.431  39.988  23.669  1.00  0.00           C  
ATOM     10  C   SER A   2      37.259  39.096  23.269  1.00  0.00           C  
ATOM     11  O   SER A   2      36.582  39.352  22.274  1.00  0.00           O  
ATOM     12  CB  SER A   2      39.739  39.198  23.587  1.00  0.00           C  
ATOM     13  OG  SER A   2      40.241  39.180  22.262  1.00  0.00           O  
ATOM     14  H   SER A   2      39.027  40.650  25.591  1.00  0.00           H  
ATOM     15  HA  SER A   2      38.482  40.824  22.988  1.00  0.00           H  
ATOM     16  HB2 SER A   2      40.474  39.654  24.233  1.00  0.00           H  
ATOM     17  HB3 SER A   2      39.563  38.181  23.906  1.00  0.00           H  
ATOM     18  HG  SER A   2      41.180  39.381  22.273  1.00  0.00           H  
ATOM     19  N   SER A   3      37.027  38.048  24.053  1.00  0.00           N  
ATOM     20  CA  SER A   3      35.940  37.115  23.780  1.00  0.00           C  
ATOM     21  C   SER A   3      34.598  37.710  24.194  1.00  0.00           C  
ATOM     22  O   SER A   3      34.543  38.743  24.859  1.00  0.00           O  
ATOM     23  CB  SER A   3      36.175  35.794  24.515  1.00  0.00           C  
ATOM     24  OG  SER A   3      36.382  36.012  25.900  1.00  0.00           O  
ATOM     25  H   SER A   3      37.603  37.897  24.832  1.00  0.00           H  
ATOM     26  HA  SER A   3      35.924  36.927  22.716  1.00  0.00           H  
ATOM     27  HB2 SER A   3      35.315  35.156  24.388  1.00  0.00           H  
ATOM     28  HB3 SER A   3      37.049  35.308  24.105  1.00  0.00           H  
ATOM     29  HG  SER A   3      36.264  35.187  26.374  1.00  0.00           H  
ATOM     30  N   GLY A   4      33.516  37.047  23.796  1.00  0.00           N  
ATOM     31  CA  GLY A   4      32.187  37.523  24.135  1.00  0.00           C  
ATOM     32  C   GLY A   4      32.049  39.023  23.970  1.00  0.00           C  
ATOM     33  O   GLY A   4      32.110  39.770  24.946  1.00  0.00           O  
ATOM     34  H   GLY A   4      33.620  36.228  23.268  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      31.467  37.033  23.497  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      31.976  37.265  25.163  1.00  0.00           H  
ATOM     37  N   SER A   5      31.867  39.467  22.730  1.00  0.00           N  
ATOM     38  CA  SER A   5      31.727  40.888  22.439  1.00  0.00           C  
ATOM     39  C   SER A   5      30.877  41.579  23.502  1.00  0.00           C  
ATOM     40  O   SER A   5      29.683  41.309  23.631  1.00  0.00           O  
ATOM     41  CB  SER A   5      31.097  41.088  21.058  1.00  0.00           C  
ATOM     42  OG  SER A   5      32.079  41.031  20.038  1.00  0.00           O  
ATOM     43  H   SER A   5      31.829  38.821  21.993  1.00  0.00           H  
ATOM     44  HA  SER A   5      32.713  41.326  22.442  1.00  0.00           H  
ATOM     45  HB2 SER A   5      30.368  40.313  20.883  1.00  0.00           H  
ATOM     46  HB3 SER A   5      30.614  42.053  21.024  1.00  0.00           H  
ATOM     47  HG  SER A   5      31.654  41.106  19.181  1.00  0.00           H  
ATOM     48  N   SER A   6      31.503  42.472  24.263  1.00  0.00           N  
ATOM     49  CA  SER A   6      30.807  43.199  25.318  1.00  0.00           C  
ATOM     50  C   SER A   6      30.543  44.642  24.900  1.00  0.00           C  
ATOM     51  O   SER A   6      30.872  45.048  23.785  1.00  0.00           O  
ATOM     52  CB  SER A   6      31.626  43.173  26.610  1.00  0.00           C  
ATOM     53  OG  SER A   6      32.806  43.947  26.482  1.00  0.00           O  
ATOM     54  H   SER A   6      32.456  42.643  24.111  1.00  0.00           H  
ATOM     55  HA  SER A   6      29.861  42.708  25.491  1.00  0.00           H  
ATOM     56  HB2 SER A   6      31.033  43.573  27.417  1.00  0.00           H  
ATOM     57  HB3 SER A   6      31.901  42.152  26.837  1.00  0.00           H  
ATOM     58  HG  SER A   6      33.167  43.837  25.599  1.00  0.00           H  
ATOM     59  N   GLY A   7      29.944  45.413  25.802  1.00  0.00           N  
ATOM     60  CA  GLY A   7      29.645  46.803  25.509  1.00  0.00           C  
ATOM     61  C   GLY A   7      30.506  47.762  26.306  1.00  0.00           C  
ATOM     62  O   GLY A   7      31.414  47.358  27.032  1.00  0.00           O  
ATOM     63  H   GLY A   7      29.704  45.035  26.674  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      29.806  46.980  24.456  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      28.606  46.992  25.741  1.00  0.00           H  
ATOM     66  N   PRO A   8      30.226  49.067  26.172  1.00  0.00           N  
ATOM     67  CA  PRO A   8      30.971  50.113  26.877  1.00  0.00           C  
ATOM     68  C   PRO A   8      30.700  50.109  28.377  1.00  0.00           C  
ATOM     69  O   PRO A   8      29.716  49.529  28.838  1.00  0.00           O  
ATOM     70  CB  PRO A   8      30.452  51.407  26.243  1.00  0.00           C  
ATOM     71  CG  PRO A   8      29.093  51.064  25.741  1.00  0.00           C  
ATOM     72  CD  PRO A   8      29.158  49.620  25.322  1.00  0.00           C  
ATOM     73  HA  PRO A   8      32.034  50.028  26.704  1.00  0.00           H  
ATOM     74  HB2 PRO A   8      30.412  52.186  26.991  1.00  0.00           H  
ATOM     75  HB3 PRO A   8      31.106  51.705  25.438  1.00  0.00           H  
ATOM     76  HG2 PRO A   8      28.366  51.193  26.529  1.00  0.00           H  
ATOM     77  HG3 PRO A   8      28.845  51.688  24.895  1.00  0.00           H  
ATOM     78  HD2 PRO A   8      28.216  49.128  25.516  1.00  0.00           H  
ATOM     79  HD3 PRO A   8      29.418  49.543  24.276  1.00  0.00           H  
ATOM     80  N   LYS A   9      31.576  50.759  29.135  1.00  0.00           N  
ATOM     81  CA  LYS A   9      31.431  50.831  30.583  1.00  0.00           C  
ATOM     82  C   LYS A   9      30.428  51.911  30.976  1.00  0.00           C  
ATOM     83  O   LYS A   9      29.696  51.765  31.954  1.00  0.00           O  
ATOM     84  CB  LYS A   9      32.784  51.114  31.239  1.00  0.00           C  
ATOM     85  CG  LYS A   9      33.740  49.935  31.196  1.00  0.00           C  
ATOM     86  CD  LYS A   9      34.407  49.808  29.836  1.00  0.00           C  
ATOM     87  CE  LYS A   9      35.642  48.921  29.902  1.00  0.00           C  
ATOM     88  NZ  LYS A   9      36.785  49.612  30.560  1.00  0.00           N  
ATOM     89  H   LYS A   9      32.340  51.202  28.708  1.00  0.00           H  
ATOM     90  HA  LYS A   9      31.066  49.876  30.928  1.00  0.00           H  
ATOM     91  HB2 LYS A   9      33.249  51.947  30.732  1.00  0.00           H  
ATOM     92  HB3 LYS A   9      32.621  51.381  32.274  1.00  0.00           H  
ATOM     93  HG2 LYS A   9      34.503  50.073  31.947  1.00  0.00           H  
ATOM     94  HG3 LYS A   9      33.188  49.029  31.402  1.00  0.00           H  
ATOM     95  HD2 LYS A   9      33.704  49.375  29.139  1.00  0.00           H  
ATOM     96  HD3 LYS A   9      34.698  50.791  29.494  1.00  0.00           H  
ATOM     97  HE2 LYS A   9      35.400  48.030  30.461  1.00  0.00           H  
ATOM     98  HE3 LYS A   9      35.927  48.648  28.897  1.00  0.00           H  
ATOM     99  HZ1 LYS A   9      36.876  50.581  30.193  1.00  0.00           H  
ATOM    100  HZ2 LYS A   9      37.669  49.097  30.371  1.00  0.00           H  
ATOM    101  HZ3 LYS A   9      36.634  49.654  31.588  1.00  0.00           H  
ATOM    102  N   ILE A  10      30.400  52.995  30.207  1.00  0.00           N  
ATOM    103  CA  ILE A  10      29.485  54.098  30.473  1.00  0.00           C  
ATOM    104  C   ILE A  10      28.112  53.832  29.863  1.00  0.00           C  
ATOM    105  O   ILE A  10      27.995  53.159  28.840  1.00  0.00           O  
ATOM    106  CB  ILE A  10      30.031  55.427  29.922  1.00  0.00           C  
ATOM    107  CG1 ILE A  10      30.791  55.190  28.615  1.00  0.00           C  
ATOM    108  CG2 ILE A  10      30.930  56.098  30.950  1.00  0.00           C  
ATOM    109  CD1 ILE A  10      32.257  54.878  28.817  1.00  0.00           C  
ATOM    110  H   ILE A  10      31.008  53.052  29.441  1.00  0.00           H  
ATOM    111  HA  ILE A  10      29.380  54.191  31.545  1.00  0.00           H  
ATOM    112  HB  ILE A  10      29.194  56.082  29.730  1.00  0.00           H  
ATOM    113 HG12 ILE A  10      30.345  54.358  28.093  1.00  0.00           H  
ATOM    114 HG13 ILE A  10      30.721  56.076  28.001  1.00  0.00           H  
ATOM    115 HG21 ILE A  10      30.324  56.648  31.654  1.00  0.00           H  
ATOM    116 HG22 ILE A  10      31.498  55.345  31.475  1.00  0.00           H  
ATOM    117 HG23 ILE A  10      31.605  56.776  30.450  1.00  0.00           H  
ATOM    118 HD11 ILE A  10      32.558  54.099  28.133  1.00  0.00           H  
ATOM    119 HD12 ILE A  10      32.843  55.766  28.633  1.00  0.00           H  
ATOM    120 HD13 ILE A  10      32.418  54.545  29.832  1.00  0.00           H  
ATOM    121  N   HIS A  11      27.075  54.368  30.499  1.00  0.00           N  
ATOM    122  CA  HIS A  11      25.710  54.192  30.019  1.00  0.00           C  
ATOM    123  C   HIS A  11      24.847  55.399  30.375  1.00  0.00           C  
ATOM    124  O   HIS A  11      24.962  55.956  31.467  1.00  0.00           O  
ATOM    125  CB  HIS A  11      25.098  52.922  30.610  1.00  0.00           C  
ATOM    126  CG  HIS A  11      24.704  53.061  32.049  1.00  0.00           C  
ATOM    127  ND1 HIS A  11      23.445  53.455  32.450  1.00  0.00           N  
ATOM    128  CD2 HIS A  11      25.412  52.853  33.184  1.00  0.00           C  
ATOM    129  CE1 HIS A  11      23.395  53.485  33.769  1.00  0.00           C  
ATOM    130  NE2 HIS A  11      24.576  53.124  34.240  1.00  0.00           N  
ATOM    131  H   HIS A  11      27.233  54.895  31.310  1.00  0.00           H  
ATOM    132  HA  HIS A  11      25.746  54.097  28.944  1.00  0.00           H  
ATOM    133  HB2 HIS A  11      24.213  52.661  30.048  1.00  0.00           H  
ATOM    134  HB3 HIS A  11      25.815  52.117  30.538  1.00  0.00           H  
ATOM    135  HD2 HIS A  11      26.442  52.534  33.249  1.00  0.00           H  
ATOM    136  HE1 HIS A  11      22.536  53.759  34.363  1.00  0.00           H  
ATOM    137  HE2 HIS A  11      24.838  53.144  35.183  1.00  0.00           H  
ATOM    138  N   PHE A  12      23.986  55.800  29.447  1.00  0.00           N  
ATOM    139  CA  PHE A  12      23.105  56.943  29.662  1.00  0.00           C  
ATOM    140  C   PHE A  12      21.945  56.570  30.581  1.00  0.00           C  
ATOM    141  O   PHE A  12      21.449  55.444  30.545  1.00  0.00           O  
ATOM    142  CB  PHE A  12      22.568  57.458  28.326  1.00  0.00           C  
ATOM    143  CG  PHE A  12      23.520  58.373  27.610  1.00  0.00           C  
ATOM    144  CD1 PHE A  12      23.816  59.626  28.121  1.00  0.00           C  
ATOM    145  CD2 PHE A  12      24.120  57.979  26.425  1.00  0.00           C  
ATOM    146  CE1 PHE A  12      24.692  60.470  27.465  1.00  0.00           C  
ATOM    147  CE2 PHE A  12      24.998  58.818  25.764  1.00  0.00           C  
ATOM    148  CZ  PHE A  12      25.283  60.066  26.284  1.00  0.00           C  
ATOM    149  H   PHE A  12      23.940  55.316  28.596  1.00  0.00           H  
ATOM    150  HA  PHE A  12      23.685  57.722  30.133  1.00  0.00           H  
ATOM    151  HB2 PHE A  12      22.365  56.619  27.679  1.00  0.00           H  
ATOM    152  HB3 PHE A  12      21.652  58.003  28.501  1.00  0.00           H  
ATOM    153  HD1 PHE A  12      23.353  59.944  29.045  1.00  0.00           H  
ATOM    154  HD2 PHE A  12      23.898  57.004  26.017  1.00  0.00           H  
ATOM    155  HE1 PHE A  12      24.912  61.445  27.874  1.00  0.00           H  
ATOM    156  HE2 PHE A  12      25.459  58.499  24.841  1.00  0.00           H  
ATOM    157  HZ  PHE A  12      25.968  60.723  25.770  1.00  0.00           H  
ATOM    158  N   ASN A  13      21.518  57.524  31.402  1.00  0.00           N  
ATOM    159  CA  ASN A  13      20.418  57.296  32.331  1.00  0.00           C  
ATOM    160  C   ASN A  13      19.232  56.649  31.622  1.00  0.00           C  
ATOM    161  O   ASN A  13      18.413  55.974  32.245  1.00  0.00           O  
ATOM    162  CB  ASN A  13      19.984  58.615  32.973  1.00  0.00           C  
ATOM    163  CG  ASN A  13      19.553  59.644  31.946  1.00  0.00           C  
ATOM    164  OD1 ASN A  13      19.620  59.401  30.741  1.00  0.00           O  
ATOM    165  ND2 ASN A  13      19.109  60.803  32.420  1.00  0.00           N  
ATOM    166  H   ASN A  13      21.954  58.401  31.384  1.00  0.00           H  
ATOM    167  HA  ASN A  13      20.767  56.627  33.103  1.00  0.00           H  
ATOM    168  HB2 ASN A  13      19.152  58.429  33.638  1.00  0.00           H  
ATOM    169  HB3 ASN A  13      20.808  59.021  33.540  1.00  0.00           H  
ATOM    170 HD21 ASN A  13      19.085  60.927  33.392  1.00  0.00           H  
ATOM    171 HD22 ASN A  13      18.824  61.486  31.778  1.00  0.00           H  
ATOM    172  N   PHE A  14      19.147  56.859  30.312  1.00  0.00           N  
ATOM    173  CA  PHE A  14      18.061  56.298  29.516  1.00  0.00           C  
ATOM    174  C   PHE A  14      18.566  55.849  28.148  1.00  0.00           C  
ATOM    175  O   PHE A  14      19.682  56.178  27.749  1.00  0.00           O  
ATOM    176  CB  PHE A  14      16.939  57.324  29.347  1.00  0.00           C  
ATOM    177  CG  PHE A  14      17.437  58.726  29.132  1.00  0.00           C  
ATOM    178  CD1 PHE A  14      18.261  59.025  28.059  1.00  0.00           C  
ATOM    179  CD2 PHE A  14      17.080  59.743  30.003  1.00  0.00           C  
ATOM    180  CE1 PHE A  14      18.720  60.313  27.859  1.00  0.00           C  
ATOM    181  CE2 PHE A  14      17.537  61.033  29.807  1.00  0.00           C  
ATOM    182  CZ  PHE A  14      18.356  61.319  28.734  1.00  0.00           C  
ATOM    183  H   PHE A  14      19.830  57.407  29.870  1.00  0.00           H  
ATOM    184  HA  PHE A  14      17.675  55.439  30.043  1.00  0.00           H  
ATOM    185  HB2 PHE A  14      16.337  57.053  28.493  1.00  0.00           H  
ATOM    186  HB3 PHE A  14      16.323  57.323  30.233  1.00  0.00           H  
ATOM    187  HD1 PHE A  14      18.545  58.240  27.373  1.00  0.00           H  
ATOM    188  HD2 PHE A  14      16.438  59.520  30.843  1.00  0.00           H  
ATOM    189  HE1 PHE A  14      19.361  60.534  27.019  1.00  0.00           H  
ATOM    190  HE2 PHE A  14      17.250  61.817  30.493  1.00  0.00           H  
ATOM    191  HZ  PHE A  14      18.715  62.326  28.580  1.00  0.00           H  
ATOM    192  N   GLU A  15      17.734  55.096  27.434  1.00  0.00           N  
ATOM    193  CA  GLU A  15      18.096  54.601  26.112  1.00  0.00           C  
ATOM    194  C   GLU A  15      17.777  55.637  25.038  1.00  0.00           C  
ATOM    195  O   GLU A  15      18.662  56.083  24.305  1.00  0.00           O  
ATOM    196  CB  GLU A  15      17.359  53.295  25.812  1.00  0.00           C  
ATOM    197  CG  GLU A  15      17.506  52.830  24.373  1.00  0.00           C  
ATOM    198  CD  GLU A  15      18.955  52.679  23.953  1.00  0.00           C  
ATOM    199  OE1 GLU A  15      19.727  52.046  24.702  1.00  0.00           O  
ATOM    200  OE2 GLU A  15      19.317  53.197  22.875  1.00  0.00           O  
ATOM    201  H   GLU A  15      16.857  54.868  27.807  1.00  0.00           H  
ATOM    202  HA  GLU A  15      19.159  54.413  26.108  1.00  0.00           H  
ATOM    203  HB2 GLU A  15      17.743  52.521  26.460  1.00  0.00           H  
ATOM    204  HB3 GLU A  15      16.308  53.434  26.016  1.00  0.00           H  
ATOM    205  HG2 GLU A  15      17.016  51.874  24.265  1.00  0.00           H  
ATOM    206  HG3 GLU A  15      17.031  53.552  23.724  1.00  0.00           H  
ATOM    207  N   LEU A  16      16.507  56.015  24.947  1.00  0.00           N  
ATOM    208  CA  LEU A  16      16.069  56.998  23.962  1.00  0.00           C  
ATOM    209  C   LEU A  16      15.511  58.242  24.645  1.00  0.00           C  
ATOM    210  O   LEU A  16      14.848  58.151  25.680  1.00  0.00           O  
ATOM    211  CB  LEU A  16      15.010  56.389  23.042  1.00  0.00           C  
ATOM    212  CG  LEU A  16      14.173  57.381  22.233  1.00  0.00           C  
ATOM    213  CD1 LEU A  16      13.660  56.732  20.957  1.00  0.00           C  
ATOM    214  CD2 LEU A  16      13.014  57.906  23.069  1.00  0.00           C  
ATOM    215  H   LEU A  16      15.848  55.625  25.557  1.00  0.00           H  
ATOM    216  HA  LEU A  16      16.928  57.281  23.372  1.00  0.00           H  
ATOM    217  HB2 LEU A  16      15.514  55.737  22.345  1.00  0.00           H  
ATOM    218  HB3 LEU A  16      14.335  55.807  23.654  1.00  0.00           H  
ATOM    219  HG  LEU A  16      14.792  58.222  21.954  1.00  0.00           H  
ATOM    220 HD11 LEU A  16      13.112  57.460  20.378  1.00  0.00           H  
ATOM    221 HD12 LEU A  16      13.008  55.908  21.210  1.00  0.00           H  
ATOM    222 HD13 LEU A  16      14.495  56.366  20.379  1.00  0.00           H  
ATOM    223 HD21 LEU A  16      13.270  58.877  23.468  1.00  0.00           H  
ATOM    224 HD22 LEU A  16      12.820  57.223  23.884  1.00  0.00           H  
ATOM    225 HD23 LEU A  16      12.134  57.991  22.451  1.00  0.00           H  
ATOM    226  N   LEU A  17      15.780  59.403  24.060  1.00  0.00           N  
ATOM    227  CA  LEU A  17      15.304  60.667  24.611  1.00  0.00           C  
ATOM    228  C   LEU A  17      14.320  61.339  23.659  1.00  0.00           C  
ATOM    229  O   LEU A  17      14.693  61.773  22.569  1.00  0.00           O  
ATOM    230  CB  LEU A  17      16.481  61.603  24.889  1.00  0.00           C  
ATOM    231  CG  LEU A  17      16.127  63.063  25.173  1.00  0.00           C  
ATOM    232  CD1 LEU A  17      15.566  63.211  26.579  1.00  0.00           C  
ATOM    233  CD2 LEU A  17      17.346  63.953  24.986  1.00  0.00           C  
ATOM    234  H   LEU A  17      16.314  59.413  23.238  1.00  0.00           H  
ATOM    235  HA  LEU A  17      14.797  60.454  25.540  1.00  0.00           H  
ATOM    236  HB2 LEU A  17      17.013  61.219  25.745  1.00  0.00           H  
ATOM    237  HB3 LEU A  17      17.131  61.581  24.025  1.00  0.00           H  
ATOM    238  HG  LEU A  17      15.366  63.385  24.475  1.00  0.00           H  
ATOM    239 HD11 LEU A  17      14.581  63.653  26.528  1.00  0.00           H  
ATOM    240 HD12 LEU A  17      16.216  63.847  27.161  1.00  0.00           H  
ATOM    241 HD13 LEU A  17      15.502  62.240  27.045  1.00  0.00           H  
ATOM    242 HD21 LEU A  17      17.038  64.902  24.573  1.00  0.00           H  
ATOM    243 HD22 LEU A  17      18.041  63.475  24.313  1.00  0.00           H  
ATOM    244 HD23 LEU A  17      17.823  64.115  25.942  1.00  0.00           H  
ATOM    245  N   ASP A  18      13.061  61.423  24.078  1.00  0.00           N  
ATOM    246  CA  ASP A  18      12.024  62.045  23.264  1.00  0.00           C  
ATOM    247  C   ASP A  18      11.812  63.499  23.672  1.00  0.00           C  
ATOM    248  O   ASP A  18      11.484  63.789  24.824  1.00  0.00           O  
ATOM    249  CB  ASP A  18      10.712  61.269  23.391  1.00  0.00           C  
ATOM    250  CG  ASP A  18      10.394  60.902  24.827  1.00  0.00           C  
ATOM    251  OD1 ASP A  18      10.938  61.557  25.741  1.00  0.00           O  
ATOM    252  OD2 ASP A  18       9.601  59.960  25.037  1.00  0.00           O  
ATOM    253  H   ASP A  18      12.825  61.058  24.956  1.00  0.00           H  
ATOM    254  HA  ASP A  18      12.349  62.018  22.235  1.00  0.00           H  
ATOM    255  HB2 ASP A  18       9.905  61.875  23.007  1.00  0.00           H  
ATOM    256  HB3 ASP A  18      10.781  60.360  22.812  1.00  0.00           H  
ATOM    257  N   ILE A  19      12.001  64.409  22.724  1.00  0.00           N  
ATOM    258  CA  ILE A  19      11.830  65.833  22.986  1.00  0.00           C  
ATOM    259  C   ILE A  19      10.475  66.324  22.489  1.00  0.00           C  
ATOM    260  O   ILE A  19      10.146  67.504  22.614  1.00  0.00           O  
ATOM    261  CB  ILE A  19      12.941  66.666  22.319  1.00  0.00           C  
ATOM    262  CG1 ILE A  19      12.870  66.525  20.797  1.00  0.00           C  
ATOM    263  CG2 ILE A  19      14.307  66.235  22.833  1.00  0.00           C  
ATOM    264  CD1 ILE A  19      13.700  67.550  20.057  1.00  0.00           C  
ATOM    265  H   ILE A  19      12.262  64.116  21.826  1.00  0.00           H  
ATOM    266  HA  ILE A  19      11.887  65.984  24.054  1.00  0.00           H  
ATOM    267  HB  ILE A  19      12.793  67.701  22.585  1.00  0.00           H  
ATOM    268 HG12 ILE A  19      13.225  65.546  20.515  1.00  0.00           H  
ATOM    269 HG13 ILE A  19      11.843  66.636  20.480  1.00  0.00           H  
ATOM    270 HG21 ILE A  19      15.023  66.271  22.025  1.00  0.00           H  
ATOM    271 HG22 ILE A  19      14.621  66.902  23.622  1.00  0.00           H  
ATOM    272 HG23 ILE A  19      14.246  65.227  23.215  1.00  0.00           H  
ATOM    273 HD11 ILE A  19      14.735  67.244  20.055  1.00  0.00           H  
ATOM    274 HD12 ILE A  19      13.346  67.634  19.040  1.00  0.00           H  
ATOM    275 HD13 ILE A  19      13.610  68.509  20.548  1.00  0.00           H  
ATOM    276  N   GLY A  20       9.690  65.411  21.925  1.00  0.00           N  
ATOM    277  CA  GLY A  20       8.377  65.770  21.420  1.00  0.00           C  
ATOM    278  C   GLY A  20       8.439  66.866  20.376  1.00  0.00           C  
ATOM    279  O   GLY A  20       9.390  66.941  19.598  1.00  0.00           O  
ATOM    280  H   GLY A  20      10.004  64.486  21.853  1.00  0.00           H  
ATOM    281  HA2 GLY A  20       7.921  64.895  20.983  1.00  0.00           H  
ATOM    282  HA3 GLY A  20       7.768  66.108  22.244  1.00  0.00           H  
ATOM    283  N   LYS A  21       7.421  67.719  20.354  1.00  0.00           N  
ATOM    284  CA  LYS A  21       7.361  68.817  19.397  1.00  0.00           C  
ATOM    285  C   LYS A  21       8.139  70.026  19.907  1.00  0.00           C  
ATOM    286  O   LYS A  21       8.235  70.252  21.113  1.00  0.00           O  
ATOM    287  CB  LYS A  21       5.906  69.209  19.129  1.00  0.00           C  
ATOM    288  CG  LYS A  21       5.159  68.217  18.256  1.00  0.00           C  
ATOM    289  CD  LYS A  21       3.656  68.414  18.348  1.00  0.00           C  
ATOM    290  CE  LYS A  21       2.954  67.948  17.081  1.00  0.00           C  
ATOM    291  NZ  LYS A  21       2.622  66.497  17.134  1.00  0.00           N  
ATOM    292  H   LYS A  21       6.691  67.608  21.000  1.00  0.00           H  
ATOM    293  HA  LYS A  21       7.809  68.478  18.474  1.00  0.00           H  
ATOM    294  HB2 LYS A  21       5.387  69.288  20.074  1.00  0.00           H  
ATOM    295  HB3 LYS A  21       5.891  70.172  18.638  1.00  0.00           H  
ATOM    296  HG2 LYS A  21       5.467  68.351  17.230  1.00  0.00           H  
ATOM    297  HG3 LYS A  21       5.402  67.214  18.578  1.00  0.00           H  
ATOM    298  HD2 LYS A  21       3.277  67.847  19.185  1.00  0.00           H  
ATOM    299  HD3 LYS A  21       3.447  69.464  18.498  1.00  0.00           H  
ATOM    300  HE2 LYS A  21       2.042  68.512  16.963  1.00  0.00           H  
ATOM    301  HE3 LYS A  21       3.603  68.130  16.238  1.00  0.00           H  
ATOM    302  HZ1 LYS A  21       3.445  65.954  17.468  1.00  0.00           H  
ATOM    303  HZ2 LYS A  21       2.358  66.156  16.188  1.00  0.00           H  
ATOM    304  HZ3 LYS A  21       1.827  66.334  17.784  1.00  0.00           H  
ATOM    305  N   VAL A  22       8.694  70.801  18.979  1.00  0.00           N  
ATOM    306  CA  VAL A  22       9.462  71.988  19.334  1.00  0.00           C  
ATOM    307  C   VAL A  22       9.261  73.100  18.311  1.00  0.00           C  
ATOM    308  O   VAL A  22       9.389  72.880  17.107  1.00  0.00           O  
ATOM    309  CB  VAL A  22      10.966  71.673  19.444  1.00  0.00           C  
ATOM    310  CG1 VAL A  22      11.213  70.615  20.509  1.00  0.00           C  
ATOM    311  CG2 VAL A  22      11.514  71.225  18.098  1.00  0.00           C  
ATOM    312  H   VAL A  22       8.584  70.568  18.034  1.00  0.00           H  
ATOM    313  HA  VAL A  22       9.117  72.333  20.299  1.00  0.00           H  
ATOM    314  HB  VAL A  22      11.481  72.574  19.738  1.00  0.00           H  
ATOM    315 HG11 VAL A  22      12.254  70.633  20.799  1.00  0.00           H  
ATOM    316 HG12 VAL A  22      10.595  70.819  21.370  1.00  0.00           H  
ATOM    317 HG13 VAL A  22      10.968  69.641  20.112  1.00  0.00           H  
ATOM    318 HG21 VAL A  22      12.504  70.811  18.233  1.00  0.00           H  
ATOM    319 HG22 VAL A  22      10.865  70.471  17.675  1.00  0.00           H  
ATOM    320 HG23 VAL A  22      11.565  72.071  17.429  1.00  0.00           H  
ATOM    321  N   PHE A  23       8.943  74.295  18.798  1.00  0.00           N  
ATOM    322  CA  PHE A  23       8.723  75.442  17.925  1.00  0.00           C  
ATOM    323  C   PHE A  23       9.946  75.704  17.051  1.00  0.00           C  
ATOM    324  O   PHE A  23      11.083  75.489  17.473  1.00  0.00           O  
ATOM    325  CB  PHE A  23       8.400  76.686  18.755  1.00  0.00           C  
ATOM    326  CG  PHE A  23       7.621  77.725  17.999  1.00  0.00           C  
ATOM    327  CD1 PHE A  23       6.441  77.393  17.355  1.00  0.00           C  
ATOM    328  CD2 PHE A  23       8.070  79.034  17.934  1.00  0.00           C  
ATOM    329  CE1 PHE A  23       5.722  78.346  16.658  1.00  0.00           C  
ATOM    330  CE2 PHE A  23       7.356  79.993  17.239  1.00  0.00           C  
ATOM    331  CZ  PHE A  23       6.180  79.648  16.601  1.00  0.00           C  
ATOM    332  H   PHE A  23       8.854  74.408  19.768  1.00  0.00           H  
ATOM    333  HA  PHE A  23       7.882  75.216  17.288  1.00  0.00           H  
ATOM    334  HB2 PHE A  23       7.815  76.395  19.615  1.00  0.00           H  
ATOM    335  HB3 PHE A  23       9.322  77.137  19.087  1.00  0.00           H  
ATOM    336  HD1 PHE A  23       6.081  76.375  17.399  1.00  0.00           H  
ATOM    337  HD2 PHE A  23       8.989  79.305  18.433  1.00  0.00           H  
ATOM    338  HE1 PHE A  23       4.804  78.074  16.162  1.00  0.00           H  
ATOM    339  HE2 PHE A  23       7.717  81.009  17.196  1.00  0.00           H  
ATOM    340  HZ  PHE A  23       5.621  80.395  16.057  1.00  0.00           H  
ATOM    341  N   THR A  24       9.705  76.169  15.829  1.00  0.00           N  
ATOM    342  CA  THR A  24      10.785  76.458  14.894  1.00  0.00           C  
ATOM    343  C   THR A  24      11.516  77.739  15.278  1.00  0.00           C  
ATOM    344  O   THR A  24      10.936  78.636  15.890  1.00  0.00           O  
ATOM    345  CB  THR A  24      10.260  76.591  13.453  1.00  0.00           C  
ATOM    346  OG1 THR A  24      11.357  76.707  12.540  1.00  0.00           O  
ATOM    347  CG2 THR A  24       9.351  77.804  13.318  1.00  0.00           C  
ATOM    348  H   THR A  24       8.777  76.319  15.551  1.00  0.00           H  
ATOM    349  HA  THR A  24      11.483  75.633  14.926  1.00  0.00           H  
ATOM    350  HB  THR A  24       9.690  75.705  13.209  1.00  0.00           H  
ATOM    351  HG1 THR A  24      11.865  77.495  12.749  1.00  0.00           H  
ATOM    352 HG21 THR A  24       9.951  78.701  13.290  1.00  0.00           H  
ATOM    353 HG22 THR A  24       8.679  77.845  14.162  1.00  0.00           H  
ATOM    354 HG23 THR A  24       8.779  77.725  12.406  1.00  0.00           H  
ATOM    355  N   GLY A  25      12.792  77.820  14.913  1.00  0.00           N  
ATOM    356  CA  GLY A  25      13.581  78.996  15.227  1.00  0.00           C  
ATOM    357  C   GLY A  25      13.648  79.269  16.717  1.00  0.00           C  
ATOM    358  O   GLY A  25      13.459  80.403  17.157  1.00  0.00           O  
ATOM    359  H   GLY A  25      13.200  77.073  14.426  1.00  0.00           H  
ATOM    360  HA2 GLY A  25      14.582  78.856  14.851  1.00  0.00           H  
ATOM    361  HA3 GLY A  25      13.140  79.852  14.736  1.00  0.00           H  
ATOM    362  N   SER A  26      13.917  78.226  17.495  1.00  0.00           N  
ATOM    363  CA  SER A  26      14.003  78.356  18.945  1.00  0.00           C  
ATOM    364  C   SER A  26      15.021  77.374  19.519  1.00  0.00           C  
ATOM    365  O   SER A  26      15.193  76.270  19.004  1.00  0.00           O  
ATOM    366  CB  SER A  26      12.633  78.118  19.583  1.00  0.00           C  
ATOM    367  OG  SER A  26      11.678  79.048  19.101  1.00  0.00           O  
ATOM    368  H   SER A  26      14.057  77.346  17.084  1.00  0.00           H  
ATOM    369  HA  SER A  26      14.326  79.362  19.169  1.00  0.00           H  
ATOM    370  HB2 SER A  26      12.297  77.120  19.346  1.00  0.00           H  
ATOM    371  HB3 SER A  26      12.714  78.227  20.655  1.00  0.00           H  
ATOM    372  HG  SER A  26      10.945  78.576  18.700  1.00  0.00           H  
ATOM    373  N   ALA A  27      15.692  77.786  20.589  1.00  0.00           N  
ATOM    374  CA  ALA A  27      16.692  76.944  21.235  1.00  0.00           C  
ATOM    375  C   ALA A  27      16.039  75.967  22.207  1.00  0.00           C  
ATOM    376  O   ALA A  27      15.113  76.324  22.935  1.00  0.00           O  
ATOM    377  CB  ALA A  27      17.719  77.803  21.957  1.00  0.00           C  
ATOM    378  H   ALA A  27      15.511  78.678  20.953  1.00  0.00           H  
ATOM    379  HA  ALA A  27      17.204  76.383  20.465  1.00  0.00           H  
ATOM    380  HB1 ALA A  27      18.470  78.134  21.253  1.00  0.00           H  
ATOM    381  HB2 ALA A  27      17.229  78.662  22.391  1.00  0.00           H  
ATOM    382  HB3 ALA A  27      18.189  77.222  22.737  1.00  0.00           H  
ATOM    383  N   HIS A  28      16.529  74.731  22.213  1.00  0.00           N  
ATOM    384  CA  HIS A  28      15.994  73.700  23.097  1.00  0.00           C  
ATOM    385  C   HIS A  28      17.005  73.331  24.176  1.00  0.00           C  
ATOM    386  O   HIS A  28      18.184  73.118  23.889  1.00  0.00           O  
ATOM    387  CB  HIS A  28      15.610  72.458  22.292  1.00  0.00           C  
ATOM    388  CG  HIS A  28      15.184  72.760  20.888  1.00  0.00           C  
ATOM    389  ND1 HIS A  28      15.273  71.846  19.861  1.00  0.00           N  
ATOM    390  CD2 HIS A  28      14.661  73.885  20.345  1.00  0.00           C  
ATOM    391  CE1 HIS A  28      14.825  72.394  18.746  1.00  0.00           C  
ATOM    392  NE2 HIS A  28      14.447  73.631  19.012  1.00  0.00           N  
ATOM    393  H   HIS A  28      17.268  74.505  21.610  1.00  0.00           H  
ATOM    394  HA  HIS A  28      15.109  74.098  23.570  1.00  0.00           H  
ATOM    395  HB2 HIS A  28      16.460  71.793  22.244  1.00  0.00           H  
ATOM    396  HB3 HIS A  28      14.792  71.954  22.787  1.00  0.00           H  
ATOM    397  HD2 HIS A  28      14.450  74.810  20.864  1.00  0.00           H  
ATOM    398  HE1 HIS A  28      14.776  71.914  17.780  1.00  0.00           H  
ATOM    399  HE2 HIS A  28      14.157  74.289  18.347  1.00  0.00           H  
ATOM    400  N   CYS A  29      16.539  73.255  25.417  1.00  0.00           N  
ATOM    401  CA  CYS A  29      17.404  72.913  26.540  1.00  0.00           C  
ATOM    402  C   CYS A  29      17.178  71.470  26.979  1.00  0.00           C  
ATOM    403  O   CYS A  29      16.084  71.104  27.408  1.00  0.00           O  
ATOM    404  CB  CYS A  29      17.151  73.860  27.714  1.00  0.00           C  
ATOM    405  SG  CYS A  29      15.459  73.813  28.350  1.00  0.00           S  
ATOM    406  H   CYS A  29      15.589  73.436  25.583  1.00  0.00           H  
ATOM    407  HA  CYS A  29      18.427  73.022  26.215  1.00  0.00           H  
ATOM    408  HB2 CYS A  29      17.814  73.601  28.526  1.00  0.00           H  
ATOM    409  HB3 CYS A  29      17.357  74.873  27.399  1.00  0.00           H  
ATOM    410  HG  CYS A  29      15.050  72.554  28.328  1.00  0.00           H  
ATOM    411  N   TYR A  30      18.220  70.653  26.868  1.00  0.00           N  
ATOM    412  CA  TYR A  30      18.136  69.249  27.250  1.00  0.00           C  
ATOM    413  C   TYR A  30      19.397  68.807  27.985  1.00  0.00           C  
ATOM    414  O   TYR A  30      20.443  69.447  27.884  1.00  0.00           O  
ATOM    415  CB  TYR A  30      17.921  68.375  26.013  1.00  0.00           C  
ATOM    416  CG  TYR A  30      16.708  68.767  25.198  1.00  0.00           C  
ATOM    417  CD1 TYR A  30      15.464  68.920  25.796  1.00  0.00           C  
ATOM    418  CD2 TYR A  30      16.809  68.985  23.829  1.00  0.00           C  
ATOM    419  CE1 TYR A  30      14.355  69.277  25.056  1.00  0.00           C  
ATOM    420  CE2 TYR A  30      15.704  69.344  23.081  1.00  0.00           C  
ATOM    421  CZ  TYR A  30      14.479  69.488  23.699  1.00  0.00           C  
ATOM    422  OH  TYR A  30      13.376  69.846  22.957  1.00  0.00           O  
ATOM    423  H   TYR A  30      19.067  71.003  26.520  1.00  0.00           H  
ATOM    424  HA  TYR A  30      17.289  69.135  27.910  1.00  0.00           H  
ATOM    425  HB2 TYR A  30      18.787  68.448  25.373  1.00  0.00           H  
ATOM    426  HB3 TYR A  30      17.793  67.348  26.323  1.00  0.00           H  
ATOM    427  HD1 TYR A  30      15.369  68.755  26.860  1.00  0.00           H  
ATOM    428  HD2 TYR A  30      17.769  68.871  23.348  1.00  0.00           H  
ATOM    429  HE1 TYR A  30      13.395  69.391  25.540  1.00  0.00           H  
ATOM    430  HE2 TYR A  30      15.801  69.508  22.018  1.00  0.00           H  
ATOM    431  HH  TYR A  30      12.605  69.883  23.529  1.00  0.00           H  
ATOM    432  N   GLU A  31      19.288  67.708  28.725  1.00  0.00           N  
ATOM    433  CA  GLU A  31      20.419  67.180  29.478  1.00  0.00           C  
ATOM    434  C   GLU A  31      20.450  65.655  29.417  1.00  0.00           C  
ATOM    435  O   GLU A  31      19.446  65.016  29.104  1.00  0.00           O  
ATOM    436  CB  GLU A  31      20.351  67.640  30.935  1.00  0.00           C  
ATOM    437  CG  GLU A  31      21.563  67.239  31.759  1.00  0.00           C  
ATOM    438  CD  GLU A  31      21.470  67.705  33.199  1.00  0.00           C  
ATOM    439  OE1 GLU A  31      20.750  67.057  33.986  1.00  0.00           O  
ATOM    440  OE2 GLU A  31      22.117  68.717  33.538  1.00  0.00           O  
ATOM    441  H   GLU A  31      18.427  67.242  28.767  1.00  0.00           H  
ATOM    442  HA  GLU A  31      21.324  67.564  29.031  1.00  0.00           H  
ATOM    443  HB2 GLU A  31      20.267  68.717  30.957  1.00  0.00           H  
ATOM    444  HB3 GLU A  31      19.472  67.211  31.395  1.00  0.00           H  
ATOM    445  HG2 GLU A  31      21.649  66.163  31.750  1.00  0.00           H  
ATOM    446  HG3 GLU A  31      22.446  67.673  31.312  1.00  0.00           H  
ATOM    447  N   ALA A  32      21.610  65.080  29.716  1.00  0.00           N  
ATOM    448  CA  ALA A  32      21.772  63.631  29.696  1.00  0.00           C  
ATOM    449  C   ALA A  32      22.911  63.194  30.611  1.00  0.00           C  
ATOM    450  O   ALA A  32      24.073  63.532  30.377  1.00  0.00           O  
ATOM    451  CB  ALA A  32      22.018  63.147  28.275  1.00  0.00           C  
ATOM    452  H   ALA A  32      22.374  65.643  29.958  1.00  0.00           H  
ATOM    453  HA  ALA A  32      20.852  63.188  30.047  1.00  0.00           H  
ATOM    454  HB1 ALA A  32      22.027  62.067  28.260  1.00  0.00           H  
ATOM    455  HB2 ALA A  32      21.231  63.510  27.630  1.00  0.00           H  
ATOM    456  HB3 ALA A  32      22.970  63.520  27.928  1.00  0.00           H  
ATOM    457  N   ILE A  33      22.573  62.441  31.652  1.00  0.00           N  
ATOM    458  CA  ILE A  33      23.567  61.958  32.601  1.00  0.00           C  
ATOM    459  C   ILE A  33      24.202  60.658  32.118  1.00  0.00           C  
ATOM    460  O   ILE A  33      23.522  59.789  31.569  1.00  0.00           O  
ATOM    461  CB  ILE A  33      22.952  61.729  33.995  1.00  0.00           C  
ATOM    462  CG1 ILE A  33      21.802  62.707  34.235  1.00  0.00           C  
ATOM    463  CG2 ILE A  33      24.015  61.877  35.073  1.00  0.00           C  
ATOM    464  CD1 ILE A  33      22.111  64.123  33.800  1.00  0.00           C  
ATOM    465  H   ILE A  33      21.631  62.205  31.785  1.00  0.00           H  
ATOM    466  HA  ILE A  33      24.337  62.711  32.689  1.00  0.00           H  
ATOM    467  HB  ILE A  33      22.572  60.720  34.033  1.00  0.00           H  
ATOM    468 HG12 ILE A  33      20.934  62.375  33.686  1.00  0.00           H  
ATOM    469 HG13 ILE A  33      21.569  62.727  35.290  1.00  0.00           H  
ATOM    470 HG21 ILE A  33      24.642  60.998  35.084  1.00  0.00           H  
ATOM    471 HG22 ILE A  33      24.620  62.747  34.865  1.00  0.00           H  
ATOM    472 HG23 ILE A  33      23.538  61.991  36.035  1.00  0.00           H  
ATOM    473 HD11 ILE A  33      21.787  64.264  32.779  1.00  0.00           H  
ATOM    474 HD12 ILE A  33      21.593  64.819  34.442  1.00  0.00           H  
ATOM    475 HD13 ILE A  33      23.175  64.295  33.866  1.00  0.00           H  
ATOM    476  N   LEU A  34      25.507  60.530  32.327  1.00  0.00           N  
ATOM    477  CA  LEU A  34      26.235  59.335  31.914  1.00  0.00           C  
ATOM    478  C   LEU A  34      26.977  58.715  33.094  1.00  0.00           C  
ATOM    479  O   LEU A  34      27.915  59.306  33.631  1.00  0.00           O  
ATOM    480  CB  LEU A  34      27.222  59.675  30.797  1.00  0.00           C  
ATOM    481  CG  LEU A  34      27.730  58.495  29.967  1.00  0.00           C  
ATOM    482  CD1 LEU A  34      26.667  58.041  28.978  1.00  0.00           C  
ATOM    483  CD2 LEU A  34      29.013  58.868  29.240  1.00  0.00           C  
ATOM    484  H   LEU A  34      25.995  61.256  32.769  1.00  0.00           H  
ATOM    485  HA  LEU A  34      25.515  58.621  31.543  1.00  0.00           H  
ATOM    486  HB2 LEU A  34      26.737  60.367  30.125  1.00  0.00           H  
ATOM    487  HB3 LEU A  34      28.079  60.155  31.249  1.00  0.00           H  
ATOM    488  HG  LEU A  34      27.946  57.666  30.627  1.00  0.00           H  
ATOM    489 HD11 LEU A  34      26.725  58.644  28.086  1.00  0.00           H  
ATOM    490 HD12 LEU A  34      25.689  58.153  29.424  1.00  0.00           H  
ATOM    491 HD13 LEU A  34      26.831  57.004  28.725  1.00  0.00           H  
ATOM    492 HD21 LEU A  34      29.839  58.313  29.661  1.00  0.00           H  
ATOM    493 HD22 LEU A  34      29.197  59.926  29.352  1.00  0.00           H  
ATOM    494 HD23 LEU A  34      28.915  58.627  28.191  1.00  0.00           H  
ATOM    495  N   TYR A  35      26.554  57.521  33.491  1.00  0.00           N  
ATOM    496  CA  TYR A  35      27.179  56.821  34.607  1.00  0.00           C  
ATOM    497  C   TYR A  35      28.357  55.976  34.130  1.00  0.00           C  
ATOM    498  O   TYR A  35      28.224  55.170  33.210  1.00  0.00           O  
ATOM    499  CB  TYR A  35      26.155  55.933  35.317  1.00  0.00           C  
ATOM    500  CG  TYR A  35      25.019  56.706  35.950  1.00  0.00           C  
ATOM    501  CD1 TYR A  35      24.075  57.357  35.166  1.00  0.00           C  
ATOM    502  CD2 TYR A  35      24.892  56.785  37.331  1.00  0.00           C  
ATOM    503  CE1 TYR A  35      23.036  58.065  35.740  1.00  0.00           C  
ATOM    504  CE2 TYR A  35      23.855  57.489  37.914  1.00  0.00           C  
ATOM    505  CZ  TYR A  35      22.930  58.128  37.113  1.00  0.00           C  
ATOM    506  OH  TYR A  35      21.898  58.831  37.689  1.00  0.00           O  
ATOM    507  H   TYR A  35      25.802  57.100  33.024  1.00  0.00           H  
ATOM    508  HA  TYR A  35      27.542  57.563  35.303  1.00  0.00           H  
ATOM    509  HB2 TYR A  35      25.730  55.245  34.603  1.00  0.00           H  
ATOM    510  HB3 TYR A  35      26.652  55.375  36.096  1.00  0.00           H  
ATOM    511  HD1 TYR A  35      24.161  57.307  34.090  1.00  0.00           H  
ATOM    512  HD2 TYR A  35      25.619  56.284  37.955  1.00  0.00           H  
ATOM    513  HE1 TYR A  35      22.311  58.566  35.114  1.00  0.00           H  
ATOM    514  HE2 TYR A  35      23.772  57.538  38.989  1.00  0.00           H  
ATOM    515  HH  TYR A  35      22.104  59.769  37.677  1.00  0.00           H  
ATOM    516  N   ASN A  36      29.509  56.168  34.764  1.00  0.00           N  
ATOM    517  CA  ASN A  36      30.711  55.424  34.406  1.00  0.00           C  
ATOM    518  C   ASN A  36      30.868  54.188  35.285  1.00  0.00           C  
ATOM    519  O   ASN A  36      31.190  54.291  36.469  1.00  0.00           O  
ATOM    520  CB  ASN A  36      31.946  56.317  34.537  1.00  0.00           C  
ATOM    521  CG  ASN A  36      33.229  55.585  34.190  1.00  0.00           C  
ATOM    522  OD1 ASN A  36      33.278  54.817  33.230  1.00  0.00           O  
ATOM    523  ND2 ASN A  36      34.275  55.821  34.974  1.00  0.00           N  
ATOM    524  H   ASN A  36      29.552  56.825  35.490  1.00  0.00           H  
ATOM    525  HA  ASN A  36      30.612  55.110  33.377  1.00  0.00           H  
ATOM    526  HB2 ASN A  36      31.845  57.161  33.869  1.00  0.00           H  
ATOM    527  HB3 ASN A  36      32.019  56.674  35.553  1.00  0.00           H  
ATOM    528 HD21 ASN A  36      34.162  56.446  35.721  1.00  0.00           H  
ATOM    529 HD22 ASN A  36      35.116  55.362  34.773  1.00  0.00           H  
ATOM    530  N   LYS A  37      30.640  53.018  34.698  1.00  0.00           N  
ATOM    531  CA  LYS A  37      30.757  51.759  35.425  1.00  0.00           C  
ATOM    532  C   LYS A  37      32.176  51.207  35.331  1.00  0.00           C  
ATOM    533  O   LYS A  37      32.383  49.995  35.343  1.00  0.00           O  
ATOM    534  CB  LYS A  37      29.762  50.734  34.877  1.00  0.00           C  
ATOM    535  CG  LYS A  37      28.310  51.122  35.090  1.00  0.00           C  
ATOM    536  CD  LYS A  37      27.882  50.915  36.533  1.00  0.00           C  
ATOM    537  CE  LYS A  37      26.731  51.834  36.912  1.00  0.00           C  
ATOM    538  NZ  LYS A  37      26.631  52.019  38.386  1.00  0.00           N  
ATOM    539  H   LYS A  37      30.387  53.000  33.751  1.00  0.00           H  
ATOM    540  HA  LYS A  37      30.527  51.953  36.463  1.00  0.00           H  
ATOM    541  HB2 LYS A  37      29.930  50.619  33.816  1.00  0.00           H  
ATOM    542  HB3 LYS A  37      29.935  49.786  35.366  1.00  0.00           H  
ATOM    543  HG2 LYS A  37      28.184  52.165  34.836  1.00  0.00           H  
ATOM    544  HG3 LYS A  37      27.686  50.516  34.449  1.00  0.00           H  
ATOM    545  HD2 LYS A  37      27.567  49.890  36.662  1.00  0.00           H  
ATOM    546  HD3 LYS A  37      28.723  51.118  37.181  1.00  0.00           H  
ATOM    547  HE2 LYS A  37      26.888  52.795  36.447  1.00  0.00           H  
ATOM    548  HE3 LYS A  37      25.810  51.404  36.549  1.00  0.00           H  
ATOM    549  HZ1 LYS A  37      25.846  51.451  38.764  1.00  0.00           H  
ATOM    550  HZ2 LYS A  37      26.461  53.019  38.610  1.00  0.00           H  
ATOM    551  HZ3 LYS A  37      27.515  51.717  38.845  1.00  0.00           H  
ATOM    552  N   GLY A  38      33.152  52.106  35.238  1.00  0.00           N  
ATOM    553  CA  GLY A  38      34.539  51.689  35.146  1.00  0.00           C  
ATOM    554  C   GLY A  38      35.269  51.803  36.470  1.00  0.00           C  
ATOM    555  O   GLY A  38      34.952  52.666  37.288  1.00  0.00           O  
ATOM    556  H   GLY A  38      32.928  53.060  35.233  1.00  0.00           H  
ATOM    557  HA2 GLY A  38      34.573  50.662  34.815  1.00  0.00           H  
ATOM    558  HA3 GLY A  38      35.040  52.308  34.417  1.00  0.00           H  
ATOM    559  N   SER A  39      36.247  50.930  36.681  1.00  0.00           N  
ATOM    560  CA  SER A  39      37.021  50.933  37.917  1.00  0.00           C  
ATOM    561  C   SER A  39      37.874  52.194  38.021  1.00  0.00           C  
ATOM    562  O   SER A  39      38.010  52.776  39.097  1.00  0.00           O  
ATOM    563  CB  SER A  39      37.914  49.692  37.988  1.00  0.00           C  
ATOM    564  OG  SER A  39      38.287  49.409  39.326  1.00  0.00           O  
ATOM    565  H   SER A  39      36.453  50.265  35.990  1.00  0.00           H  
ATOM    566  HA  SER A  39      36.326  50.914  38.743  1.00  0.00           H  
ATOM    567  HB2 SER A  39      37.378  48.844  37.589  1.00  0.00           H  
ATOM    568  HB3 SER A  39      38.807  49.862  37.405  1.00  0.00           H  
ATOM    569  HG  SER A  39      39.068  48.849  39.328  1.00  0.00           H  
ATOM    570  N   ILE A  40      38.446  52.607  36.895  1.00  0.00           N  
ATOM    571  CA  ILE A  40      39.286  53.799  36.859  1.00  0.00           C  
ATOM    572  C   ILE A  40      38.739  54.826  35.873  1.00  0.00           C  
ATOM    573  O   ILE A  40      37.712  54.601  35.231  1.00  0.00           O  
ATOM    574  CB  ILE A  40      40.736  53.455  36.472  1.00  0.00           C  
ATOM    575  CG1 ILE A  40      40.786  52.879  35.055  1.00  0.00           C  
ATOM    576  CG2 ILE A  40      41.331  52.473  37.471  1.00  0.00           C  
ATOM    577  CD1 ILE A  40      40.210  51.484  34.950  1.00  0.00           C  
ATOM    578  H   ILE A  40      38.300  52.100  36.070  1.00  0.00           H  
ATOM    579  HA  ILE A  40      39.291  54.233  37.849  1.00  0.00           H  
ATOM    580  HB  ILE A  40      41.319  54.362  36.505  1.00  0.00           H  
ATOM    581 HG12 ILE A  40      40.226  53.519  34.393  1.00  0.00           H  
ATOM    582 HG13 ILE A  40      41.815  52.839  34.727  1.00  0.00           H  
ATOM    583 HG21 ILE A  40      41.642  51.578  36.953  1.00  0.00           H  
ATOM    584 HG22 ILE A  40      42.185  52.924  37.952  1.00  0.00           H  
ATOM    585 HG23 ILE A  40      40.590  52.220  38.213  1.00  0.00           H  
ATOM    586 HD11 ILE A  40      39.305  51.512  34.361  1.00  0.00           H  
ATOM    587 HD12 ILE A  40      40.928  50.832  34.477  1.00  0.00           H  
ATOM    588 HD13 ILE A  40      39.983  51.112  35.939  1.00  0.00           H  
ATOM    589  N   ASP A  41      39.431  55.954  35.757  1.00  0.00           N  
ATOM    590  CA  ASP A  41      39.017  57.015  34.848  1.00  0.00           C  
ATOM    591  C   ASP A  41      38.615  56.443  33.491  1.00  0.00           C  
ATOM    592  O   ASP A  41      39.269  55.540  32.970  1.00  0.00           O  
ATOM    593  CB  ASP A  41      40.144  58.034  34.671  1.00  0.00           C  
ATOM    594  CG  ASP A  41      40.398  58.841  35.930  1.00  0.00           C  
ATOM    595  OD1 ASP A  41      39.414  59.282  36.560  1.00  0.00           O  
ATOM    596  OD2 ASP A  41      41.580  59.032  36.285  1.00  0.00           O  
ATOM    597  H   ASP A  41      40.241  56.075  36.296  1.00  0.00           H  
ATOM    598  HA  ASP A  41      38.162  57.510  35.283  1.00  0.00           H  
ATOM    599  HB2 ASP A  41      41.055  57.513  34.412  1.00  0.00           H  
ATOM    600  HB3 ASP A  41      39.885  58.715  33.875  1.00  0.00           H  
ATOM    601  N   ALA A  42      37.536  56.975  32.927  1.00  0.00           N  
ATOM    602  CA  ALA A  42      37.047  56.517  31.632  1.00  0.00           C  
ATOM    603  C   ALA A  42      37.004  57.663  30.627  1.00  0.00           C  
ATOM    604  O   ALA A  42      36.253  58.624  30.797  1.00  0.00           O  
ATOM    605  CB  ALA A  42      35.670  55.888  31.779  1.00  0.00           C  
ATOM    606  H   ALA A  42      37.057  57.691  33.392  1.00  0.00           H  
ATOM    607  HA  ALA A  42      37.726  55.758  31.269  1.00  0.00           H  
ATOM    608  HB1 ALA A  42      34.928  56.543  31.344  1.00  0.00           H  
ATOM    609  HB2 ALA A  42      35.653  54.936  31.272  1.00  0.00           H  
ATOM    610  HB3 ALA A  42      35.451  55.742  32.827  1.00  0.00           H  
ATOM    611  N   LEU A  43      37.813  57.555  29.578  1.00  0.00           N  
ATOM    612  CA  LEU A  43      37.868  58.582  28.545  1.00  0.00           C  
ATOM    613  C   LEU A  43      36.694  58.447  27.580  1.00  0.00           C  
ATOM    614  O   LEU A  43      36.447  57.372  27.033  1.00  0.00           O  
ATOM    615  CB  LEU A  43      39.187  58.492  27.776  1.00  0.00           C  
ATOM    616  CG  LEU A  43      40.420  59.044  28.492  1.00  0.00           C  
ATOM    617  CD1 LEU A  43      41.003  58.001  29.433  1.00  0.00           C  
ATOM    618  CD2 LEU A  43      41.464  59.498  27.482  1.00  0.00           C  
ATOM    619  H   LEU A  43      38.388  56.766  29.497  1.00  0.00           H  
ATOM    620  HA  LEU A  43      37.809  59.545  29.031  1.00  0.00           H  
ATOM    621  HB2 LEU A  43      39.370  57.451  27.557  1.00  0.00           H  
ATOM    622  HB3 LEU A  43      39.068  59.037  26.851  1.00  0.00           H  
ATOM    623  HG  LEU A  43      40.131  59.902  29.084  1.00  0.00           H  
ATOM    624 HD11 LEU A  43      40.744  57.014  29.081  1.00  0.00           H  
ATOM    625 HD12 LEU A  43      40.603  58.147  30.425  1.00  0.00           H  
ATOM    626 HD13 LEU A  43      42.079  58.103  29.460  1.00  0.00           H  
ATOM    627 HD21 LEU A  43      40.970  59.915  26.617  1.00  0.00           H  
ATOM    628 HD22 LEU A  43      42.065  58.652  27.181  1.00  0.00           H  
ATOM    629 HD23 LEU A  43      42.098  60.248  27.932  1.00  0.00           H  
ATOM    630  N   PHE A  44      35.974  59.545  27.375  1.00  0.00           N  
ATOM    631  CA  PHE A  44      34.826  59.549  26.475  1.00  0.00           C  
ATOM    632  C   PHE A  44      34.914  60.710  25.488  1.00  0.00           C  
ATOM    633  O   PHE A  44      35.634  61.680  25.717  1.00  0.00           O  
ATOM    634  CB  PHE A  44      33.524  59.643  27.274  1.00  0.00           C  
ATOM    635  CG  PHE A  44      33.262  61.013  27.834  1.00  0.00           C  
ATOM    636  CD1 PHE A  44      33.919  61.447  28.973  1.00  0.00           C  
ATOM    637  CD2 PHE A  44      32.358  61.864  27.219  1.00  0.00           C  
ATOM    638  CE1 PHE A  44      33.679  62.706  29.490  1.00  0.00           C  
ATOM    639  CE2 PHE A  44      32.114  63.124  27.731  1.00  0.00           C  
ATOM    640  CZ  PHE A  44      32.775  63.546  28.869  1.00  0.00           C  
ATOM    641  H   PHE A  44      36.220  60.372  27.841  1.00  0.00           H  
ATOM    642  HA  PHE A  44      34.834  58.622  25.924  1.00  0.00           H  
ATOM    643  HB2 PHE A  44      32.697  59.383  26.632  1.00  0.00           H  
ATOM    644  HB3 PHE A  44      33.567  58.948  28.099  1.00  0.00           H  
ATOM    645  HD1 PHE A  44      34.626  60.791  29.461  1.00  0.00           H  
ATOM    646  HD2 PHE A  44      31.839  61.535  26.331  1.00  0.00           H  
ATOM    647  HE1 PHE A  44      34.197  63.032  30.380  1.00  0.00           H  
ATOM    648  HE2 PHE A  44      31.407  63.778  27.244  1.00  0.00           H  
ATOM    649  HZ  PHE A  44      32.587  64.530  29.271  1.00  0.00           H  
ATOM    650  N   ASN A  45      34.176  60.599  24.388  1.00  0.00           N  
ATOM    651  CA  ASN A  45      34.170  61.637  23.364  1.00  0.00           C  
ATOM    652  C   ASN A  45      32.918  61.542  22.498  1.00  0.00           C  
ATOM    653  O   ASN A  45      32.463  60.448  22.165  1.00  0.00           O  
ATOM    654  CB  ASN A  45      35.419  61.525  22.487  1.00  0.00           C  
ATOM    655  CG  ASN A  45      35.444  62.559  21.379  1.00  0.00           C  
ATOM    656  OD1 ASN A  45      35.548  62.221  20.200  1.00  0.00           O  
ATOM    657  ND2 ASN A  45      35.347  63.830  21.753  1.00  0.00           N  
ATOM    658  H   ASN A  45      33.621  59.801  24.261  1.00  0.00           H  
ATOM    659  HA  ASN A  45      34.177  62.595  23.862  1.00  0.00           H  
ATOM    660  HB2 ASN A  45      36.298  61.665  23.102  1.00  0.00           H  
ATOM    661  HB3 ASN A  45      35.451  60.543  22.040  1.00  0.00           H  
ATOM    662 HD21 ASN A  45      35.265  64.026  22.711  1.00  0.00           H  
ATOM    663 HD22 ASN A  45      35.358  64.519  21.057  1.00  0.00           H  
ATOM    664  N   MET A  46      32.365  62.695  22.136  1.00  0.00           N  
ATOM    665  CA  MET A  46      31.167  62.741  21.307  1.00  0.00           C  
ATOM    666  C   MET A  46      31.529  62.909  19.836  1.00  0.00           C  
ATOM    667  O   MET A  46      32.396  63.712  19.486  1.00  0.00           O  
ATOM    668  CB  MET A  46      30.255  63.885  21.755  1.00  0.00           C  
ATOM    669  CG  MET A  46      29.792  63.765  23.197  1.00  0.00           C  
ATOM    670  SD  MET A  46      28.468  62.559  23.403  1.00  0.00           S  
ATOM    671  CE  MET A  46      27.318  63.099  22.141  1.00  0.00           C  
ATOM    672  H   MET A  46      32.774  63.535  22.433  1.00  0.00           H  
ATOM    673  HA  MET A  46      30.642  61.806  21.432  1.00  0.00           H  
ATOM    674  HB2 MET A  46      30.788  64.818  21.647  1.00  0.00           H  
ATOM    675  HB3 MET A  46      29.381  63.904  21.120  1.00  0.00           H  
ATOM    676  HG2 MET A  46      30.630  63.464  23.808  1.00  0.00           H  
ATOM    677  HG3 MET A  46      29.437  64.729  23.528  1.00  0.00           H  
ATOM    678  HE1 MET A  46      27.595  62.665  21.192  1.00  0.00           H  
ATOM    679  HE2 MET A  46      26.320  62.782  22.405  1.00  0.00           H  
ATOM    680  HE3 MET A  46      27.345  64.176  22.067  1.00  0.00           H  
ATOM    681  N   THR A  47      30.861  62.148  18.975  1.00  0.00           N  
ATOM    682  CA  THR A  47      31.114  62.213  17.541  1.00  0.00           C  
ATOM    683  C   THR A  47      30.042  63.031  16.830  1.00  0.00           C  
ATOM    684  O   THR A  47      28.848  62.898  17.095  1.00  0.00           O  
ATOM    685  CB  THR A  47      31.168  60.806  16.916  1.00  0.00           C  
ATOM    686  OG1 THR A  47      32.208  60.037  17.532  1.00  0.00           O  
ATOM    687  CG2 THR A  47      31.411  60.889  15.416  1.00  0.00           C  
ATOM    688  H   THR A  47      30.182  61.529  19.314  1.00  0.00           H  
ATOM    689  HA  THR A  47      32.073  62.688  17.392  1.00  0.00           H  
ATOM    690  HB  THR A  47      30.219  60.317  17.085  1.00  0.00           H  
ATOM    691  HG1 THR A  47      33.044  60.224  17.099  1.00  0.00           H  
ATOM    692 HG21 THR A  47      31.226  59.924  14.968  1.00  0.00           H  
ATOM    693 HG22 THR A  47      32.435  61.180  15.234  1.00  0.00           H  
ATOM    694 HG23 THR A  47      30.746  61.621  14.984  1.00  0.00           H  
ATOM    695  N   PRO A  48      30.476  63.899  15.904  1.00  0.00           N  
ATOM    696  CA  PRO A  48      29.568  64.755  15.134  1.00  0.00           C  
ATOM    697  C   PRO A  48      28.728  63.962  14.138  1.00  0.00           C  
ATOM    698  O   PRO A  48      29.202  63.022  13.500  1.00  0.00           O  
ATOM    699  CB  PRO A  48      30.516  65.704  14.396  1.00  0.00           C  
ATOM    700  CG  PRO A  48      31.800  64.955  14.295  1.00  0.00           C  
ATOM    701  CD  PRO A  48      31.886  64.110  15.536  1.00  0.00           C  
ATOM    702  HA  PRO A  48      28.917  65.325  15.780  1.00  0.00           H  
ATOM    703  HB2 PRO A  48      30.112  65.934  13.420  1.00  0.00           H  
ATOM    704  HB3 PRO A  48      30.636  66.614  14.966  1.00  0.00           H  
ATOM    705  HG2 PRO A  48      31.790  64.328  13.415  1.00  0.00           H  
ATOM    706  HG3 PRO A  48      32.627  65.647  14.254  1.00  0.00           H  
ATOM    707  HD2 PRO A  48      32.373  63.172  15.320  1.00  0.00           H  
ATOM    708  HD3 PRO A  48      32.412  64.641  16.316  1.00  0.00           H  
ATOM    709  N   PRO A  49      27.451  64.349  14.001  1.00  0.00           N  
ATOM    710  CA  PRO A  49      26.518  63.687  13.084  1.00  0.00           C  
ATOM    711  C   PRO A  49      26.858  63.952  11.622  1.00  0.00           C  
ATOM    712  O   PRO A  49      27.784  64.703  11.314  1.00  0.00           O  
ATOM    713  CB  PRO A  49      25.167  64.312  13.442  1.00  0.00           C  
ATOM    714  CG  PRO A  49      25.505  65.642  14.022  1.00  0.00           C  
ATOM    715  CD  PRO A  49      26.820  65.461  14.731  1.00  0.00           C  
ATOM    716  HA  PRO A  49      26.480  62.622  13.257  1.00  0.00           H  
ATOM    717  HB2 PRO A  49      24.566  64.411  12.548  1.00  0.00           H  
ATOM    718  HB3 PRO A  49      24.655  63.687  14.158  1.00  0.00           H  
ATOM    719  HG2 PRO A  49      25.602  66.372  13.234  1.00  0.00           H  
ATOM    720  HG3 PRO A  49      24.740  65.941  14.722  1.00  0.00           H  
ATOM    721  HD2 PRO A  49      27.415  66.359  14.656  1.00  0.00           H  
ATOM    722  HD3 PRO A  49      26.657  65.199  15.766  1.00  0.00           H  
ATOM    723  N   THR A  50      26.101  63.331  10.721  1.00  0.00           N  
ATOM    724  CA  THR A  50      26.322  63.500   9.291  1.00  0.00           C  
ATOM    725  C   THR A  50      25.178  64.274   8.645  1.00  0.00           C  
ATOM    726  O   THR A  50      25.386  65.032   7.698  1.00  0.00           O  
ATOM    727  CB  THR A  50      26.472  62.140   8.582  1.00  0.00           C  
ATOM    728  OG1 THR A  50      25.366  61.293   8.910  1.00  0.00           O  
ATOM    729  CG2 THR A  50      27.774  61.463   8.981  1.00  0.00           C  
ATOM    730  H   THR A  50      25.378  62.747  11.029  1.00  0.00           H  
ATOM    731  HA  THR A  50      27.239  64.055   9.158  1.00  0.00           H  
ATOM    732  HB  THR A  50      26.483  62.308   7.515  1.00  0.00           H  
ATOM    733  HG1 THR A  50      25.115  60.781   8.137  1.00  0.00           H  
ATOM    734 HG21 THR A  50      27.846  61.428  10.059  1.00  0.00           H  
ATOM    735 HG22 THR A  50      28.608  62.021   8.582  1.00  0.00           H  
ATOM    736 HG23 THR A  50      27.791  60.458   8.587  1.00  0.00           H  
ATOM    737  N   SER A  51      23.970  64.078   9.164  1.00  0.00           N  
ATOM    738  CA  SER A  51      22.793  64.755   8.635  1.00  0.00           C  
ATOM    739  C   SER A  51      22.757  66.213   9.084  1.00  0.00           C  
ATOM    740  O   SER A  51      23.562  66.639   9.912  1.00  0.00           O  
ATOM    741  CB  SER A  51      21.520  64.039   9.089  1.00  0.00           C  
ATOM    742  OG  SER A  51      21.523  62.682   8.680  1.00  0.00           O  
ATOM    743  H   SER A  51      23.869  63.461   9.919  1.00  0.00           H  
ATOM    744  HA  SER A  51      22.848  64.724   7.557  1.00  0.00           H  
ATOM    745  HB2 SER A  51      21.452  64.077  10.166  1.00  0.00           H  
ATOM    746  HB3 SER A  51      20.659  64.531   8.657  1.00  0.00           H  
ATOM    747  HG  SER A  51      20.745  62.241   9.027  1.00  0.00           H  
ATOM    748  N   ALA A  52      21.818  66.973   8.530  1.00  0.00           N  
ATOM    749  CA  ALA A  52      21.675  68.382   8.873  1.00  0.00           C  
ATOM    750  C   ALA A  52      21.004  68.552  10.232  1.00  0.00           C  
ATOM    751  O   ALA A  52      21.534  69.222  11.119  1.00  0.00           O  
ATOM    752  CB  ALA A  52      20.883  69.110   7.798  1.00  0.00           C  
ATOM    753  H   ALA A  52      21.205  66.577   7.876  1.00  0.00           H  
ATOM    754  HA  ALA A  52      22.663  68.818   8.914  1.00  0.00           H  
ATOM    755  HB1 ALA A  52      21.083  68.658   6.837  1.00  0.00           H  
ATOM    756  HB2 ALA A  52      19.828  69.039   8.018  1.00  0.00           H  
ATOM    757  HB3 ALA A  52      21.176  70.149   7.775  1.00  0.00           H  
ATOM    758  N   LEU A  53      19.836  67.940  10.390  1.00  0.00           N  
ATOM    759  CA  LEU A  53      19.091  68.022  11.643  1.00  0.00           C  
ATOM    760  C   LEU A  53      19.936  67.523  12.811  1.00  0.00           C  
ATOM    761  O   LEU A  53      19.689  67.876  13.963  1.00  0.00           O  
ATOM    762  CB  LEU A  53      17.801  67.208  11.546  1.00  0.00           C  
ATOM    763  CG  LEU A  53      16.569  67.960  11.041  1.00  0.00           C  
ATOM    764  CD1 LEU A  53      16.038  68.898  12.114  1.00  0.00           C  
ATOM    765  CD2 LEU A  53      16.899  68.733   9.771  1.00  0.00           C  
ATOM    766  H   LEU A  53      19.464  67.419   9.649  1.00  0.00           H  
ATOM    767  HA  LEU A  53      18.842  69.059  11.811  1.00  0.00           H  
ATOM    768  HB2 LEU A  53      17.980  66.382  10.876  1.00  0.00           H  
ATOM    769  HB3 LEU A  53      17.576  66.828  12.532  1.00  0.00           H  
ATOM    770  HG  LEU A  53      15.790  67.248  10.806  1.00  0.00           H  
ATOM    771 HD11 LEU A  53      16.126  69.918  11.776  1.00  0.00           H  
ATOM    772 HD12 LEU A  53      16.611  68.768  13.021  1.00  0.00           H  
ATOM    773 HD13 LEU A  53      15.001  68.670  12.309  1.00  0.00           H  
ATOM    774 HD21 LEU A  53      17.582  68.155   9.166  1.00  0.00           H  
ATOM    775 HD22 LEU A  53      17.359  69.675  10.033  1.00  0.00           H  
ATOM    776 HD23 LEU A  53      15.991  68.917   9.216  1.00  0.00           H  
ATOM    777  N   GLY A  54      20.933  66.699  12.505  1.00  0.00           N  
ATOM    778  CA  GLY A  54      21.798  66.165  13.540  1.00  0.00           C  
ATOM    779  C   GLY A  54      22.844  67.165  13.994  1.00  0.00           C  
ATOM    780  O   GLY A  54      23.091  67.316  15.190  1.00  0.00           O  
ATOM    781  H   GLY A  54      21.082  66.451  11.569  1.00  0.00           H  
ATOM    782  HA2 GLY A  54      21.194  65.882  14.390  1.00  0.00           H  
ATOM    783  HA3 GLY A  54      22.299  65.288  13.158  1.00  0.00           H  
ATOM    784  N   ALA A  55      23.461  67.850  13.036  1.00  0.00           N  
ATOM    785  CA  ALA A  55      24.485  68.840  13.343  1.00  0.00           C  
ATOM    786  C   ALA A  55      23.952  69.903  14.299  1.00  0.00           C  
ATOM    787  O   ALA A  55      24.589  70.222  15.304  1.00  0.00           O  
ATOM    788  CB  ALA A  55      24.994  69.487  12.063  1.00  0.00           C  
ATOM    789  H   ALA A  55      23.220  67.685  12.100  1.00  0.00           H  
ATOM    790  HA  ALA A  55      25.313  68.330  13.813  1.00  0.00           H  
ATOM    791  HB1 ALA A  55      26.068  69.376  12.007  1.00  0.00           H  
ATOM    792  HB2 ALA A  55      24.537  69.007  11.210  1.00  0.00           H  
ATOM    793  HB3 ALA A  55      24.740  70.537  12.064  1.00  0.00           H  
ATOM    794  N   CYS A  56      22.784  70.447  13.978  1.00  0.00           N  
ATOM    795  CA  CYS A  56      22.166  71.475  14.809  1.00  0.00           C  
ATOM    796  C   CYS A  56      22.404  71.195  16.289  1.00  0.00           C  
ATOM    797  O   CYS A  56      22.722  72.100  17.060  1.00  0.00           O  
ATOM    798  CB  CYS A  56      20.665  71.554  14.527  1.00  0.00           C  
ATOM    799  SG  CYS A  56      20.253  72.220  12.897  1.00  0.00           S  
ATOM    800  H   CYS A  56      22.324  70.151  13.165  1.00  0.00           H  
ATOM    801  HA  CYS A  56      22.621  72.420  14.557  1.00  0.00           H  
ATOM    802  HB2 CYS A  56      20.241  70.563  14.592  1.00  0.00           H  
ATOM    803  HB3 CYS A  56      20.200  72.186  15.270  1.00  0.00           H  
ATOM    804  HG  CYS A  56      20.350  71.236  12.017  1.00  0.00           H  
ATOM    805  N   PHE A  57      22.247  69.934  16.680  1.00  0.00           N  
ATOM    806  CA  PHE A  57      22.442  69.534  18.068  1.00  0.00           C  
ATOM    807  C   PHE A  57      23.871  69.821  18.521  1.00  0.00           C  
ATOM    808  O   PHE A  57      24.821  69.672  17.751  1.00  0.00           O  
ATOM    809  CB  PHE A  57      22.129  68.046  18.241  1.00  0.00           C  
ATOM    810  CG  PHE A  57      20.669  67.722  18.109  1.00  0.00           C  
ATOM    811  CD1 PHE A  57      20.060  67.700  16.865  1.00  0.00           C  
ATOM    812  CD2 PHE A  57      19.905  67.439  19.230  1.00  0.00           C  
ATOM    813  CE1 PHE A  57      18.717  67.402  16.741  1.00  0.00           C  
ATOM    814  CE2 PHE A  57      18.560  67.141  19.112  1.00  0.00           C  
ATOM    815  CZ  PHE A  57      17.966  67.121  17.866  1.00  0.00           C  
ATOM    816  H   PHE A  57      21.993  69.256  16.017  1.00  0.00           H  
ATOM    817  HA  PHE A  57      21.763  70.110  18.676  1.00  0.00           H  
ATOM    818  HB2 PHE A  57      22.663  67.483  17.490  1.00  0.00           H  
ATOM    819  HB3 PHE A  57      22.454  67.730  19.220  1.00  0.00           H  
ATOM    820  HD1 PHE A  57      20.646  67.918  15.984  1.00  0.00           H  
ATOM    821  HD2 PHE A  57      20.370  67.454  20.206  1.00  0.00           H  
ATOM    822  HE1 PHE A  57      18.254  67.387  15.766  1.00  0.00           H  
ATOM    823  HE2 PHE A  57      17.976  66.922  19.994  1.00  0.00           H  
ATOM    824  HZ  PHE A  57      16.916  66.889  17.772  1.00  0.00           H  
ATOM    825  N   VAL A  58      24.017  70.234  19.776  1.00  0.00           N  
ATOM    826  CA  VAL A  58      25.329  70.541  20.332  1.00  0.00           C  
ATOM    827  C   VAL A  58      25.551  69.809  21.651  1.00  0.00           C  
ATOM    828  O   VAL A  58      25.027  70.210  22.692  1.00  0.00           O  
ATOM    829  CB  VAL A  58      25.501  72.054  20.562  1.00  0.00           C  
ATOM    830  CG1 VAL A  58      26.868  72.352  21.160  1.00  0.00           C  
ATOM    831  CG2 VAL A  58      25.302  72.816  19.260  1.00  0.00           C  
ATOM    832  H   VAL A  58      23.222  70.334  20.341  1.00  0.00           H  
ATOM    833  HA  VAL A  58      26.077  70.218  19.623  1.00  0.00           H  
ATOM    834  HB  VAL A  58      24.747  72.379  21.263  1.00  0.00           H  
ATOM    835 HG11 VAL A  58      27.512  72.765  20.397  1.00  0.00           H  
ATOM    836 HG12 VAL A  58      26.761  73.063  21.967  1.00  0.00           H  
ATOM    837 HG13 VAL A  58      27.300  71.438  21.540  1.00  0.00           H  
ATOM    838 HG21 VAL A  58      24.425  73.440  19.340  1.00  0.00           H  
ATOM    839 HG22 VAL A  58      26.167  73.434  19.068  1.00  0.00           H  
ATOM    840 HG23 VAL A  58      25.173  72.115  18.449  1.00  0.00           H  
ATOM    841  N   PHE A  59      26.332  68.735  21.602  1.00  0.00           N  
ATOM    842  CA  PHE A  59      26.623  67.946  22.793  1.00  0.00           C  
ATOM    843  C   PHE A  59      27.941  68.385  23.427  1.00  0.00           C  
ATOM    844  O   PHE A  59      28.914  68.664  22.728  1.00  0.00           O  
ATOM    845  CB  PHE A  59      26.683  66.458  22.444  1.00  0.00           C  
ATOM    846  CG  PHE A  59      25.355  65.882  22.046  1.00  0.00           C  
ATOM    847  CD1 PHE A  59      24.862  66.065  20.764  1.00  0.00           C  
ATOM    848  CD2 PHE A  59      24.598  65.158  22.953  1.00  0.00           C  
ATOM    849  CE1 PHE A  59      23.638  65.536  20.396  1.00  0.00           C  
ATOM    850  CE2 PHE A  59      23.375  64.627  22.591  1.00  0.00           C  
ATOM    851  CZ  PHE A  59      22.895  64.815  21.310  1.00  0.00           C  
ATOM    852  H   PHE A  59      26.720  68.466  20.743  1.00  0.00           H  
ATOM    853  HA  PHE A  59      25.825  68.110  23.502  1.00  0.00           H  
ATOM    854  HB2 PHE A  59      27.366  66.317  21.620  1.00  0.00           H  
ATOM    855  HB3 PHE A  59      27.041  65.909  23.301  1.00  0.00           H  
ATOM    856  HD1 PHE A  59      25.442  66.627  20.047  1.00  0.00           H  
ATOM    857  HD2 PHE A  59      24.973  65.010  23.956  1.00  0.00           H  
ATOM    858  HE1 PHE A  59      23.266  65.685  19.393  1.00  0.00           H  
ATOM    859  HE2 PHE A  59      22.797  64.064  23.308  1.00  0.00           H  
ATOM    860  HZ  PHE A  59      21.939  64.402  21.024  1.00  0.00           H  
ATOM    861  N   SER A  60      27.962  68.444  24.755  1.00  0.00           N  
ATOM    862  CA  SER A  60      29.157  68.852  25.483  1.00  0.00           C  
ATOM    863  C   SER A  60      29.185  68.229  26.875  1.00  0.00           C  
ATOM    864  O   SER A  60      28.158  67.827  27.423  1.00  0.00           O  
ATOM    865  CB  SER A  60      29.217  70.377  25.593  1.00  0.00           C  
ATOM    866  OG  SER A  60      29.805  70.949  24.437  1.00  0.00           O  
ATOM    867  H   SER A  60      27.153  68.209  25.255  1.00  0.00           H  
ATOM    868  HA  SER A  60      30.017  68.506  24.929  1.00  0.00           H  
ATOM    869  HB2 SER A  60      28.216  70.766  25.702  1.00  0.00           H  
ATOM    870  HB3 SER A  60      29.806  70.650  26.456  1.00  0.00           H  
ATOM    871  HG  SER A  60      30.683  71.273  24.652  1.00  0.00           H  
ATOM    872  N   PRO A  61      30.388  68.146  27.462  1.00  0.00           N  
ATOM    873  CA  PRO A  61      31.617  68.621  26.818  1.00  0.00           C  
ATOM    874  C   PRO A  61      32.025  67.750  25.635  1.00  0.00           C  
ATOM    875  O   PRO A  61      31.859  66.531  25.661  1.00  0.00           O  
ATOM    876  CB  PRO A  61      32.660  68.529  27.935  1.00  0.00           C  
ATOM    877  CG  PRO A  61      32.140  67.477  28.853  1.00  0.00           C  
ATOM    878  CD  PRO A  61      30.641  67.582  28.798  1.00  0.00           C  
ATOM    879  HA  PRO A  61      31.523  69.647  26.494  1.00  0.00           H  
ATOM    880  HB2 PRO A  61      33.616  68.252  27.515  1.00  0.00           H  
ATOM    881  HB3 PRO A  61      32.743  69.483  28.434  1.00  0.00           H  
ATOM    882  HG2 PRO A  61      32.461  66.503  28.513  1.00  0.00           H  
ATOM    883  HG3 PRO A  61      32.493  67.660  29.858  1.00  0.00           H  
ATOM    884  HD2 PRO A  61      30.191  66.606  28.897  1.00  0.00           H  
ATOM    885  HD3 PRO A  61      30.281  68.246  29.571  1.00  0.00           H  
ATOM    886  N   LYS A  62      32.560  68.384  24.598  1.00  0.00           N  
ATOM    887  CA  LYS A  62      32.994  67.668  23.404  1.00  0.00           C  
ATOM    888  C   LYS A  62      33.915  66.507  23.770  1.00  0.00           C  
ATOM    889  O   LYS A  62      34.129  65.598  22.970  1.00  0.00           O  
ATOM    890  CB  LYS A  62      33.714  68.620  22.445  1.00  0.00           C  
ATOM    891  CG  LYS A  62      34.901  69.330  23.072  1.00  0.00           C  
ATOM    892  CD  LYS A  62      35.160  70.674  22.412  1.00  0.00           C  
ATOM    893  CE  LYS A  62      36.014  70.526  21.162  1.00  0.00           C  
ATOM    894  NZ  LYS A  62      37.425  70.186  21.493  1.00  0.00           N  
ATOM    895  H   LYS A  62      32.667  69.359  24.635  1.00  0.00           H  
ATOM    896  HA  LYS A  62      32.116  67.275  22.914  1.00  0.00           H  
ATOM    897  HB2 LYS A  62      34.067  68.057  21.594  1.00  0.00           H  
ATOM    898  HB3 LYS A  62      33.012  69.368  22.106  1.00  0.00           H  
ATOM    899  HG2 LYS A  62      34.702  69.489  24.122  1.00  0.00           H  
ATOM    900  HG3 LYS A  62      35.780  68.710  22.962  1.00  0.00           H  
ATOM    901  HD2 LYS A  62      34.215  71.118  22.137  1.00  0.00           H  
ATOM    902  HD3 LYS A  62      35.671  71.318  23.113  1.00  0.00           H  
ATOM    903  HE2 LYS A  62      35.598  69.743  20.548  1.00  0.00           H  
ATOM    904  HE3 LYS A  62      35.995  71.458  20.617  1.00  0.00           H  
ATOM    905  HZ1 LYS A  62      37.485  69.208  21.841  1.00  0.00           H  
ATOM    906  HZ2 LYS A  62      37.785  70.827  22.228  1.00  0.00           H  
ATOM    907  HZ3 LYS A  62      38.023  70.278  20.646  1.00  0.00           H  
ATOM    908  N   GLU A  63      34.453  66.546  24.984  1.00  0.00           N  
ATOM    909  CA  GLU A  63      35.349  65.497  25.456  1.00  0.00           C  
ATOM    910  C   GLU A  63      35.732  65.722  26.916  1.00  0.00           C  
ATOM    911  O   GLU A  63      35.610  66.830  27.436  1.00  0.00           O  
ATOM    912  CB  GLU A  63      36.609  65.443  24.589  1.00  0.00           C  
ATOM    913  CG  GLU A  63      37.719  66.362  25.074  1.00  0.00           C  
ATOM    914  CD  GLU A  63      38.551  65.740  26.177  1.00  0.00           C  
ATOM    915  OE1 GLU A  63      38.952  64.567  26.028  1.00  0.00           O  
ATOM    916  OE2 GLU A  63      38.801  66.425  27.191  1.00  0.00           O  
ATOM    917  H   GLU A  63      34.244  67.298  25.577  1.00  0.00           H  
ATOM    918  HA  GLU A  63      34.827  64.555  25.374  1.00  0.00           H  
ATOM    919  HB2 GLU A  63      36.984  64.432  24.582  1.00  0.00           H  
ATOM    920  HB3 GLU A  63      36.349  65.729  23.581  1.00  0.00           H  
ATOM    921  HG2 GLU A  63      38.367  66.591  24.242  1.00  0.00           H  
ATOM    922  HG3 GLU A  63      37.277  67.274  25.446  1.00  0.00           H  
ATOM    923  N   GLY A  64      36.193  64.661  27.572  1.00  0.00           N  
ATOM    924  CA  GLY A  64      36.586  64.764  28.964  1.00  0.00           C  
ATOM    925  C   GLY A  64      36.834  63.409  29.597  1.00  0.00           C  
ATOM    926  O   GLY A  64      37.354  62.499  28.950  1.00  0.00           O  
ATOM    927  H   GLY A  64      36.269  63.803  27.105  1.00  0.00           H  
ATOM    928  HA2 GLY A  64      37.489  65.352  29.031  1.00  0.00           H  
ATOM    929  HA3 GLY A  64      35.801  65.265  29.512  1.00  0.00           H  
ATOM    930  N   ILE A  65      36.465  63.274  30.868  1.00  0.00           N  
ATOM    931  CA  ILE A  65      36.652  62.021  31.587  1.00  0.00           C  
ATOM    932  C   ILE A  65      35.607  61.857  32.686  1.00  0.00           C  
ATOM    933  O   ILE A  65      35.329  62.793  33.436  1.00  0.00           O  
ATOM    934  CB  ILE A  65      38.056  61.935  32.213  1.00  0.00           C  
ATOM    935  CG1 ILE A  65      39.130  62.108  31.137  1.00  0.00           C  
ATOM    936  CG2 ILE A  65      38.235  60.609  32.937  1.00  0.00           C  
ATOM    937  CD1 ILE A  65      40.540  62.130  31.686  1.00  0.00           C  
ATOM    938  H   ILE A  65      36.057  64.035  31.330  1.00  0.00           H  
ATOM    939  HA  ILE A  65      36.545  61.211  30.880  1.00  0.00           H  
ATOM    940  HB  ILE A  65      38.153  62.729  32.938  1.00  0.00           H  
ATOM    941 HG12 ILE A  65      39.061  61.293  30.434  1.00  0.00           H  
ATOM    942 HG13 ILE A  65      38.961  63.041  30.618  1.00  0.00           H  
ATOM    943 HG21 ILE A  65      39.170  60.615  33.476  1.00  0.00           H  
ATOM    944 HG22 ILE A  65      37.420  60.467  33.631  1.00  0.00           H  
ATOM    945 HG23 ILE A  65      38.239  59.804  32.218  1.00  0.00           H  
ATOM    946 HD11 ILE A  65      40.737  61.204  32.206  1.00  0.00           H  
ATOM    947 HD12 ILE A  65      41.241  62.244  30.875  1.00  0.00           H  
ATOM    948 HD13 ILE A  65      40.645  62.958  32.373  1.00  0.00           H  
ATOM    949  N   ILE A  66      35.035  60.662  32.777  1.00  0.00           N  
ATOM    950  CA  ILE A  66      34.023  60.374  33.786  1.00  0.00           C  
ATOM    951  C   ILE A  66      34.597  59.524  34.914  1.00  0.00           C  
ATOM    952  O   ILE A  66      34.915  58.351  34.719  1.00  0.00           O  
ATOM    953  CB  ILE A  66      32.809  59.647  33.177  1.00  0.00           C  
ATOM    954  CG1 ILE A  66      32.336  60.371  31.914  1.00  0.00           C  
ATOM    955  CG2 ILE A  66      31.682  59.553  34.194  1.00  0.00           C  
ATOM    956  CD1 ILE A  66      31.136  59.721  31.261  1.00  0.00           C  
ATOM    957  H   ILE A  66      35.298  59.956  32.151  1.00  0.00           H  
ATOM    958  HA  ILE A  66      33.684  61.316  34.196  1.00  0.00           H  
ATOM    959  HB  ILE A  66      33.113  58.645  32.916  1.00  0.00           H  
ATOM    960 HG12 ILE A  66      32.066  61.384  32.167  1.00  0.00           H  
ATOM    961 HG13 ILE A  66      33.141  60.386  31.193  1.00  0.00           H  
ATOM    962 HG21 ILE A  66      31.384  60.546  34.494  1.00  0.00           H  
ATOM    963 HG22 ILE A  66      30.840  59.043  33.751  1.00  0.00           H  
ATOM    964 HG23 ILE A  66      32.022  59.002  35.058  1.00  0.00           H  
ATOM    965 HD11 ILE A  66      31.163  58.656  31.433  1.00  0.00           H  
ATOM    966 HD12 ILE A  66      30.230  60.133  31.679  1.00  0.00           H  
ATOM    967 HD13 ILE A  66      31.158  59.912  30.196  1.00  0.00           H  
ATOM    968  N   GLU A  67      34.726  60.123  36.093  1.00  0.00           N  
ATOM    969  CA  GLU A  67      35.261  59.419  37.252  1.00  0.00           C  
ATOM    970  C   GLU A  67      34.545  58.087  37.459  1.00  0.00           C  
ATOM    971  O   GLU A  67      33.380  57.918  37.099  1.00  0.00           O  
ATOM    972  CB  GLU A  67      35.126  60.282  38.509  1.00  0.00           C  
ATOM    973  CG  GLU A  67      33.692  60.663  38.834  1.00  0.00           C  
ATOM    974  CD  GLU A  67      33.564  61.367  40.171  1.00  0.00           C  
ATOM    975  OE1 GLU A  67      34.395  61.098  41.064  1.00  0.00           O  
ATOM    976  OE2 GLU A  67      32.635  62.187  40.324  1.00  0.00           O  
ATOM    977  H   GLU A  67      34.455  61.061  36.186  1.00  0.00           H  
ATOM    978  HA  GLU A  67      36.308  59.226  37.070  1.00  0.00           H  
ATOM    979  HB2 GLU A  67      35.533  59.740  39.349  1.00  0.00           H  
ATOM    980  HB3 GLU A  67      35.695  61.191  38.369  1.00  0.00           H  
ATOM    981  HG2 GLU A  67      33.324  61.322  38.062  1.00  0.00           H  
ATOM    982  HG3 GLU A  67      33.091  59.766  38.858  1.00  0.00           H  
ATOM    983  N   PRO A  68      35.258  57.119  38.052  1.00  0.00           N  
ATOM    984  CA  PRO A  68      34.712  55.785  38.320  1.00  0.00           C  
ATOM    985  C   PRO A  68      33.646  55.802  39.410  1.00  0.00           C  
ATOM    986  O   PRO A  68      33.742  56.563  40.372  1.00  0.00           O  
ATOM    987  CB  PRO A  68      35.935  54.987  38.780  1.00  0.00           C  
ATOM    988  CG  PRO A  68      36.869  56.009  39.328  1.00  0.00           C  
ATOM    989  CD  PRO A  68      36.652  57.251  38.508  1.00  0.00           C  
ATOM    990  HA  PRO A  68      34.304  55.337  37.426  1.00  0.00           H  
ATOM    991  HB2 PRO A  68      35.639  54.275  39.538  1.00  0.00           H  
ATOM    992  HB3 PRO A  68      36.367  54.466  37.939  1.00  0.00           H  
ATOM    993  HG2 PRO A  68      36.640  56.200  40.364  1.00  0.00           H  
ATOM    994  HG3 PRO A  68      37.889  55.667  39.224  1.00  0.00           H  
ATOM    995  HD2 PRO A  68      36.777  58.133  39.118  1.00  0.00           H  
ATOM    996  HD3 PRO A  68      37.331  57.272  37.668  1.00  0.00           H  
ATOM    997  N   SER A  69      32.630  54.960  39.251  1.00  0.00           N  
ATOM    998  CA  SER A  69      31.544  54.882  40.221  1.00  0.00           C  
ATOM    999  C   SER A  69      30.889  56.246  40.414  1.00  0.00           C  
ATOM   1000  O   SER A  69      30.591  56.651  41.537  1.00  0.00           O  
ATOM   1001  CB  SER A  69      32.065  54.359  41.561  1.00  0.00           C  
ATOM   1002  OG  SER A  69      32.164  52.946  41.554  1.00  0.00           O  
ATOM   1003  H   SER A  69      32.610  54.379  38.462  1.00  0.00           H  
ATOM   1004  HA  SER A  69      30.806  54.193  39.837  1.00  0.00           H  
ATOM   1005  HB2 SER A  69      33.042  54.775  41.752  1.00  0.00           H  
ATOM   1006  HB3 SER A  69      31.387  54.657  42.349  1.00  0.00           H  
ATOM   1007  HG  SER A  69      32.796  52.672  40.885  1.00  0.00           H  
ATOM   1008  N   GLY A  70      30.668  56.951  39.309  1.00  0.00           N  
ATOM   1009  CA  GLY A  70      30.050  58.262  39.377  1.00  0.00           C  
ATOM   1010  C   GLY A  70      29.168  58.551  38.178  1.00  0.00           C  
ATOM   1011  O   GLY A  70      28.617  57.635  37.570  1.00  0.00           O  
ATOM   1012  H   GLY A  70      30.926  56.578  38.441  1.00  0.00           H  
ATOM   1013  HA2 GLY A  70      29.451  58.321  40.274  1.00  0.00           H  
ATOM   1014  HA3 GLY A  70      30.827  59.012  39.426  1.00  0.00           H  
ATOM   1015  N   VAL A  71      29.033  59.829  37.839  1.00  0.00           N  
ATOM   1016  CA  VAL A  71      28.211  60.237  36.706  1.00  0.00           C  
ATOM   1017  C   VAL A  71      28.813  61.444  35.997  1.00  0.00           C  
ATOM   1018  O   VAL A  71      29.842  61.972  36.415  1.00  0.00           O  
ATOM   1019  CB  VAL A  71      26.776  60.577  37.147  1.00  0.00           C  
ATOM   1020  CG1 VAL A  71      25.984  59.306  37.417  1.00  0.00           C  
ATOM   1021  CG2 VAL A  71      26.795  61.474  38.376  1.00  0.00           C  
ATOM   1022  H   VAL A  71      29.497  60.515  38.363  1.00  0.00           H  
ATOM   1023  HA  VAL A  71      28.165  59.410  36.012  1.00  0.00           H  
ATOM   1024  HB  VAL A  71      26.290  61.113  36.344  1.00  0.00           H  
ATOM   1025 HG11 VAL A  71      25.078  59.316  36.829  1.00  0.00           H  
ATOM   1026 HG12 VAL A  71      26.579  58.447  37.148  1.00  0.00           H  
ATOM   1027 HG13 VAL A  71      25.731  59.256  38.466  1.00  0.00           H  
ATOM   1028 HG21 VAL A  71      25.963  61.223  39.017  1.00  0.00           H  
ATOM   1029 HG22 VAL A  71      27.720  61.327  38.914  1.00  0.00           H  
ATOM   1030 HG23 VAL A  71      26.715  62.506  38.070  1.00  0.00           H  
ATOM   1031  N   GLN A  72      28.162  61.877  34.921  1.00  0.00           N  
ATOM   1032  CA  GLN A  72      28.634  63.023  34.153  1.00  0.00           C  
ATOM   1033  C   GLN A  72      27.488  63.671  33.383  1.00  0.00           C  
ATOM   1034  O   GLN A  72      26.889  63.052  32.506  1.00  0.00           O  
ATOM   1035  CB  GLN A  72      29.738  62.595  33.184  1.00  0.00           C  
ATOM   1036  CG  GLN A  72      30.091  63.659  32.156  1.00  0.00           C  
ATOM   1037  CD  GLN A  72      30.899  64.796  32.749  1.00  0.00           C  
ATOM   1038  OE1 GLN A  72      32.007  64.594  33.246  1.00  0.00           O  
ATOM   1039  NE2 GLN A  72      30.346  66.003  32.699  1.00  0.00           N  
ATOM   1040  H   GLN A  72      27.347  61.414  34.637  1.00  0.00           H  
ATOM   1041  HA  GLN A  72      29.038  63.744  34.848  1.00  0.00           H  
ATOM   1042  HB2 GLN A  72      30.628  62.362  33.750  1.00  0.00           H  
ATOM   1043  HB3 GLN A  72      29.414  61.710  32.657  1.00  0.00           H  
ATOM   1044  HG2 GLN A  72      30.670  63.201  31.367  1.00  0.00           H  
ATOM   1045  HG3 GLN A  72      29.177  64.060  31.746  1.00  0.00           H  
ATOM   1046 HE21 GLN A  72      29.459  66.089  32.289  1.00  0.00           H  
ATOM   1047 HE22 GLN A  72      30.846  66.757  33.075  1.00  0.00           H  
ATOM   1048  N   ALA A  73      27.190  64.922  33.719  1.00  0.00           N  
ATOM   1049  CA  ALA A  73      26.117  65.655  33.059  1.00  0.00           C  
ATOM   1050  C   ALA A  73      26.506  66.030  31.632  1.00  0.00           C  
ATOM   1051  O   ALA A  73      27.618  66.496  31.384  1.00  0.00           O  
ATOM   1052  CB  ALA A  73      25.760  66.900  33.855  1.00  0.00           C  
ATOM   1053  H   ALA A  73      27.703  65.362  34.427  1.00  0.00           H  
ATOM   1054  HA  ALA A  73      25.246  65.016  33.027  1.00  0.00           H  
ATOM   1055  HB1 ALA A  73      25.966  66.728  34.901  1.00  0.00           H  
ATOM   1056  HB2 ALA A  73      26.351  67.734  33.504  1.00  0.00           H  
ATOM   1057  HB3 ALA A  73      24.711  67.122  33.725  1.00  0.00           H  
ATOM   1058  N   ILE A  74      25.583  65.823  30.699  1.00  0.00           N  
ATOM   1059  CA  ILE A  74      25.830  66.141  29.298  1.00  0.00           C  
ATOM   1060  C   ILE A  74      24.908  67.255  28.815  1.00  0.00           C  
ATOM   1061  O   ILE A  74      23.688  67.100  28.800  1.00  0.00           O  
ATOM   1062  CB  ILE A  74      25.637  64.905  28.398  1.00  0.00           C  
ATOM   1063  CG1 ILE A  74      26.554  63.768  28.854  1.00  0.00           C  
ATOM   1064  CG2 ILE A  74      25.908  65.262  26.944  1.00  0.00           C  
ATOM   1065  CD1 ILE A  74      28.020  64.030  28.586  1.00  0.00           C  
ATOM   1066  H   ILE A  74      24.716  65.449  30.958  1.00  0.00           H  
ATOM   1067  HA  ILE A  74      26.854  66.471  29.207  1.00  0.00           H  
ATOM   1068  HB  ILE A  74      24.610  64.585  28.480  1.00  0.00           H  
ATOM   1069 HG12 ILE A  74      26.432  63.618  29.914  1.00  0.00           H  
ATOM   1070 HG13 ILE A  74      26.278  62.863  28.332  1.00  0.00           H  
ATOM   1071 HG21 ILE A  74      26.416  64.440  26.460  1.00  0.00           H  
ATOM   1072 HG22 ILE A  74      24.971  65.451  26.441  1.00  0.00           H  
ATOM   1073 HG23 ILE A  74      26.526  66.145  26.899  1.00  0.00           H  
ATOM   1074 HD11 ILE A  74      28.496  64.372  29.494  1.00  0.00           H  
ATOM   1075 HD12 ILE A  74      28.493  63.120  28.251  1.00  0.00           H  
ATOM   1076 HD13 ILE A  74      28.116  64.788  27.823  1.00  0.00           H  
ATOM   1077  N   GLN A  75      25.501  68.377  28.421  1.00  0.00           N  
ATOM   1078  CA  GLN A  75      24.732  69.518  27.937  1.00  0.00           C  
ATOM   1079  C   GLN A  75      24.333  69.325  26.478  1.00  0.00           C  
ATOM   1080  O   GLN A  75      25.188  69.219  25.598  1.00  0.00           O  
ATOM   1081  CB  GLN A  75      25.542  70.807  28.090  1.00  0.00           C  
ATOM   1082  CG  GLN A  75      25.653  71.289  29.528  1.00  0.00           C  
ATOM   1083  CD  GLN A  75      24.310  71.673  30.120  1.00  0.00           C  
ATOM   1084  OE1 GLN A  75      23.828  72.788  29.924  1.00  0.00           O  
ATOM   1085  NE2 GLN A  75      23.698  70.746  30.848  1.00  0.00           N  
ATOM   1086  H   GLN A  75      26.478  68.440  28.457  1.00  0.00           H  
ATOM   1087  HA  GLN A  75      23.838  69.593  28.536  1.00  0.00           H  
ATOM   1088  HB2 GLN A  75      26.539  70.639  27.711  1.00  0.00           H  
ATOM   1089  HB3 GLN A  75      25.071  71.585  27.508  1.00  0.00           H  
ATOM   1090  HG2 GLN A  75      26.080  70.499  30.127  1.00  0.00           H  
ATOM   1091  HG3 GLN A  75      26.301  72.152  29.555  1.00  0.00           H  
ATOM   1092 HE21 GLN A  75      24.142  69.879  30.961  1.00  0.00           H  
ATOM   1093 HE22 GLN A  75      22.830  70.967  31.242  1.00  0.00           H  
ATOM   1094  N   ILE A  76      23.029  69.281  26.228  1.00  0.00           N  
ATOM   1095  CA  ILE A  76      22.515  69.101  24.876  1.00  0.00           C  
ATOM   1096  C   ILE A  76      21.698  70.309  24.433  1.00  0.00           C  
ATOM   1097  O   ILE A  76      20.824  70.781  25.160  1.00  0.00           O  
ATOM   1098  CB  ILE A  76      21.642  67.837  24.768  1.00  0.00           C  
ATOM   1099  CG1 ILE A  76      22.448  66.599  25.166  1.00  0.00           C  
ATOM   1100  CG2 ILE A  76      21.096  67.689  23.355  1.00  0.00           C  
ATOM   1101  CD1 ILE A  76      21.587  65.414  25.542  1.00  0.00           C  
ATOM   1102  H   ILE A  76      22.397  69.371  26.971  1.00  0.00           H  
ATOM   1103  HA  ILE A  76      23.361  68.989  24.212  1.00  0.00           H  
ATOM   1104  HB  ILE A  76      20.807  67.946  25.441  1.00  0.00           H  
ATOM   1105 HG12 ILE A  76      23.075  66.304  24.340  1.00  0.00           H  
ATOM   1106 HG13 ILE A  76      23.070  66.841  26.015  1.00  0.00           H  
ATOM   1107 HG21 ILE A  76      21.370  66.720  22.964  1.00  0.00           H  
ATOM   1108 HG22 ILE A  76      20.022  67.779  23.374  1.00  0.00           H  
ATOM   1109 HG23 ILE A  76      21.512  68.462  22.726  1.00  0.00           H  
ATOM   1110 HD11 ILE A  76      20.744  65.351  24.869  1.00  0.00           H  
ATOM   1111 HD12 ILE A  76      22.171  64.508  25.475  1.00  0.00           H  
ATOM   1112 HD13 ILE A  76      21.229  65.536  26.554  1.00  0.00           H  
ATOM   1113  N   SER A  77      21.988  70.806  23.235  1.00  0.00           N  
ATOM   1114  CA  SER A  77      21.281  71.962  22.695  1.00  0.00           C  
ATOM   1115  C   SER A  77      20.907  71.735  21.233  1.00  0.00           C  
ATOM   1116  O   SER A  77      21.770  71.505  20.388  1.00  0.00           O  
ATOM   1117  CB  SER A  77      22.142  73.219  22.823  1.00  0.00           C  
ATOM   1118  OG  SER A  77      21.466  74.356  22.314  1.00  0.00           O  
ATOM   1119  H   SER A  77      22.696  70.387  22.702  1.00  0.00           H  
ATOM   1120  HA  SER A  77      20.377  72.095  23.269  1.00  0.00           H  
ATOM   1121  HB2 SER A  77      22.375  73.390  23.864  1.00  0.00           H  
ATOM   1122  HB3 SER A  77      23.059  73.083  22.267  1.00  0.00           H  
ATOM   1123  HG  SER A  77      21.303  74.978  23.028  1.00  0.00           H  
ATOM   1124  N   PHE A  78      19.611  71.803  20.944  1.00  0.00           N  
ATOM   1125  CA  PHE A  78      19.119  71.604  19.585  1.00  0.00           C  
ATOM   1126  C   PHE A  78      18.372  72.839  19.092  1.00  0.00           C  
ATOM   1127  O   PHE A  78      17.563  73.420  19.816  1.00  0.00           O  
ATOM   1128  CB  PHE A  78      18.203  70.381  19.525  1.00  0.00           C  
ATOM   1129  CG  PHE A  78      17.516  70.211  18.200  1.00  0.00           C  
ATOM   1130  CD1 PHE A  78      18.195  70.452  17.017  1.00  0.00           C  
ATOM   1131  CD2 PHE A  78      16.191  69.812  18.138  1.00  0.00           C  
ATOM   1132  CE1 PHE A  78      17.567  70.296  15.796  1.00  0.00           C  
ATOM   1133  CE2 PHE A  78      15.557  69.654  16.920  1.00  0.00           C  
ATOM   1134  CZ  PHE A  78      16.245  69.897  15.749  1.00  0.00           C  
ATOM   1135  H   PHE A  78      18.970  71.991  21.662  1.00  0.00           H  
ATOM   1136  HA  PHE A  78      19.973  71.436  18.946  1.00  0.00           H  
ATOM   1137  HB2 PHE A  78      18.788  69.493  19.712  1.00  0.00           H  
ATOM   1138  HB3 PHE A  78      17.442  70.474  20.286  1.00  0.00           H  
ATOM   1139  HD1 PHE A  78      19.230  70.764  17.054  1.00  0.00           H  
ATOM   1140  HD2 PHE A  78      15.651  69.622  19.055  1.00  0.00           H  
ATOM   1141  HE1 PHE A  78      18.107  70.488  14.881  1.00  0.00           H  
ATOM   1142  HE2 PHE A  78      14.523  69.342  16.886  1.00  0.00           H  
ATOM   1143  HZ  PHE A  78      15.752  69.774  14.796  1.00  0.00           H  
ATOM   1144  N   SER A  79      18.649  73.235  17.853  1.00  0.00           N  
ATOM   1145  CA  SER A  79      18.006  74.404  17.263  1.00  0.00           C  
ATOM   1146  C   SER A  79      18.123  74.378  15.741  1.00  0.00           C  
ATOM   1147  O   SER A  79      19.224  74.375  15.193  1.00  0.00           O  
ATOM   1148  CB  SER A  79      18.631  75.688  17.812  1.00  0.00           C  
ATOM   1149  OG  SER A  79      19.919  75.904  17.263  1.00  0.00           O  
ATOM   1150  H   SER A  79      19.303  72.731  17.325  1.00  0.00           H  
ATOM   1151  HA  SER A  79      16.960  74.378  17.532  1.00  0.00           H  
ATOM   1152  HB2 SER A  79      18.000  76.528  17.561  1.00  0.00           H  
ATOM   1153  HB3 SER A  79      18.718  75.612  18.886  1.00  0.00           H  
ATOM   1154  HG  SER A  79      19.855  76.519  16.530  1.00  0.00           H  
ATOM   1155  N   SER A  80      16.978  74.360  15.067  1.00  0.00           N  
ATOM   1156  CA  SER A  80      16.951  74.330  13.609  1.00  0.00           C  
ATOM   1157  C   SER A  80      15.637  74.898  13.079  1.00  0.00           C  
ATOM   1158  O   SER A  80      14.637  74.946  13.793  1.00  0.00           O  
ATOM   1159  CB  SER A  80      17.142  72.899  13.102  1.00  0.00           C  
ATOM   1160  OG  SER A  80      17.697  72.889  11.799  1.00  0.00           O  
ATOM   1161  H   SER A  80      16.132  74.364  15.561  1.00  0.00           H  
ATOM   1162  HA  SER A  80      17.766  74.942  13.250  1.00  0.00           H  
ATOM   1163  HB2 SER A  80      17.808  72.371  13.769  1.00  0.00           H  
ATOM   1164  HB3 SER A  80      16.186  72.398  13.079  1.00  0.00           H  
ATOM   1165  HG  SER A  80      17.699  71.992  11.459  1.00  0.00           H  
ATOM   1166  N   ILE A  81      15.651  75.327  11.821  1.00  0.00           N  
ATOM   1167  CA  ILE A  81      14.461  75.890  11.194  1.00  0.00           C  
ATOM   1168  C   ILE A  81      13.751  74.853  10.332  1.00  0.00           C  
ATOM   1169  O   ILE A  81      12.597  75.038   9.945  1.00  0.00           O  
ATOM   1170  CB  ILE A  81      14.810  77.112  10.323  1.00  0.00           C  
ATOM   1171  CG1 ILE A  81      15.982  76.787   9.395  1.00  0.00           C  
ATOM   1172  CG2 ILE A  81      15.138  78.311  11.201  1.00  0.00           C  
ATOM   1173  CD1 ILE A  81      16.129  77.759   8.245  1.00  0.00           C  
ATOM   1174  H   ILE A  81      16.479  75.262  11.303  1.00  0.00           H  
ATOM   1175  HA  ILE A  81      13.792  76.211  11.978  1.00  0.00           H  
ATOM   1176  HB  ILE A  81      13.944  77.359   9.727  1.00  0.00           H  
ATOM   1177 HG12 ILE A  81      16.899  76.805   9.962  1.00  0.00           H  
ATOM   1178 HG13 ILE A  81      15.840  75.800   8.980  1.00  0.00           H  
ATOM   1179 HG21 ILE A  81      14.222  78.753  11.562  1.00  0.00           H  
ATOM   1180 HG22 ILE A  81      15.736  77.989  12.040  1.00  0.00           H  
ATOM   1181 HG23 ILE A  81      15.688  79.039  10.624  1.00  0.00           H  
ATOM   1182 HD11 ILE A  81      17.056  77.565   7.726  1.00  0.00           H  
ATOM   1183 HD12 ILE A  81      15.300  77.639   7.564  1.00  0.00           H  
ATOM   1184 HD13 ILE A  81      16.137  78.770   8.627  1.00  0.00           H  
ATOM   1185  N   ILE A  82      14.446  73.759  10.038  1.00  0.00           N  
ATOM   1186  CA  ILE A  82      13.880  72.690   9.225  1.00  0.00           C  
ATOM   1187  C   ILE A  82      12.702  72.027   9.931  1.00  0.00           C  
ATOM   1188  O   ILE A  82      12.877  71.330  10.932  1.00  0.00           O  
ATOM   1189  CB  ILE A  82      14.934  71.618   8.891  1.00  0.00           C  
ATOM   1190  CG1 ILE A  82      16.008  72.197   7.968  1.00  0.00           C  
ATOM   1191  CG2 ILE A  82      14.273  70.407   8.249  1.00  0.00           C  
ATOM   1192  CD1 ILE A  82      17.340  71.487   8.070  1.00  0.00           C  
ATOM   1193  H   ILE A  82      15.362  73.669  10.376  1.00  0.00           H  
ATOM   1194  HA  ILE A  82      13.532  73.125   8.298  1.00  0.00           H  
ATOM   1195  HB  ILE A  82      15.396  71.300   9.813  1.00  0.00           H  
ATOM   1196 HG12 ILE A  82      15.672  72.125   6.946  1.00  0.00           H  
ATOM   1197 HG13 ILE A  82      16.165  73.236   8.218  1.00  0.00           H  
ATOM   1198 HG21 ILE A  82      13.966  69.715   9.020  1.00  0.00           H  
ATOM   1199 HG22 ILE A  82      13.409  70.725   7.687  1.00  0.00           H  
ATOM   1200 HG23 ILE A  82      14.976  69.921   7.589  1.00  0.00           H  
ATOM   1201 HD11 ILE A  82      17.217  70.449   7.798  1.00  0.00           H  
ATOM   1202 HD12 ILE A  82      18.049  71.953   7.403  1.00  0.00           H  
ATOM   1203 HD13 ILE A  82      17.704  71.551   9.085  1.00  0.00           H  
ATOM   1204  N   LEU A  83      11.503  72.246   9.403  1.00  0.00           N  
ATOM   1205  CA  LEU A  83      10.295  71.668   9.981  1.00  0.00           C  
ATOM   1206  C   LEU A  83      10.187  70.185   9.644  1.00  0.00           C  
ATOM   1207  O   LEU A  83      10.971  69.657   8.856  1.00  0.00           O  
ATOM   1208  CB  LEU A  83       9.058  72.410   9.474  1.00  0.00           C  
ATOM   1209  CG  LEU A  83       9.072  73.931   9.639  1.00  0.00           C  
ATOM   1210  CD1 LEU A  83       7.863  74.553   8.959  1.00  0.00           C  
ATOM   1211  CD2 LEU A  83       9.109  74.306  11.113  1.00  0.00           C  
ATOM   1212  H   LEU A  83      11.428  72.809   8.605  1.00  0.00           H  
ATOM   1213  HA  LEU A  83      10.357  71.778  11.053  1.00  0.00           H  
ATOM   1214  HB2 LEU A  83       8.950  72.194   8.422  1.00  0.00           H  
ATOM   1215  HB3 LEU A  83       8.201  72.027  10.008  1.00  0.00           H  
ATOM   1216  HG  LEU A  83       9.961  74.329   9.169  1.00  0.00           H  
ATOM   1217 HD11 LEU A  83       7.263  75.069   9.692  1.00  0.00           H  
ATOM   1218 HD12 LEU A  83       7.273  73.778   8.492  1.00  0.00           H  
ATOM   1219 HD13 LEU A  83       8.194  75.254   8.206  1.00  0.00           H  
ATOM   1220 HD21 LEU A  83       9.576  73.511  11.676  1.00  0.00           H  
ATOM   1221 HD22 LEU A  83       8.101  74.455  11.472  1.00  0.00           H  
ATOM   1222 HD23 LEU A  83       9.675  75.217  11.239  1.00  0.00           H  
ATOM   1223  N   GLY A  84       9.206  69.517  10.244  1.00  0.00           N  
ATOM   1224  CA  GLY A  84       9.010  68.101   9.994  1.00  0.00           C  
ATOM   1225  C   GLY A  84       9.787  67.228  10.959  1.00  0.00           C  
ATOM   1226  O   GLY A  84      10.780  67.664  11.538  1.00  0.00           O  
ATOM   1227  H   GLY A  84       8.610  69.990  10.863  1.00  0.00           H  
ATOM   1228  HA2 GLY A  84       7.959  67.872  10.084  1.00  0.00           H  
ATOM   1229  HA3 GLY A  84       9.332  67.878   8.986  1.00  0.00           H  
ATOM   1230  N   ASN A  85       9.333  65.991  11.133  1.00  0.00           N  
ATOM   1231  CA  ASN A  85       9.991  65.056  12.038  1.00  0.00           C  
ATOM   1232  C   ASN A  85      11.404  64.740  11.559  1.00  0.00           C  
ATOM   1233  O   ASN A  85      11.730  64.922  10.386  1.00  0.00           O  
ATOM   1234  CB  ASN A  85       9.178  63.764  12.149  1.00  0.00           C  
ATOM   1235  CG  ASN A  85       9.112  63.007  10.837  1.00  0.00           C  
ATOM   1236  OD1 ASN A  85       9.089  63.607   9.762  1.00  0.00           O  
ATOM   1237  ND2 ASN A  85       9.082  61.683  10.919  1.00  0.00           N  
ATOM   1238  H   ASN A  85       8.535  65.701  10.643  1.00  0.00           H  
ATOM   1239  HA  ASN A  85      10.048  65.520  13.011  1.00  0.00           H  
ATOM   1240  HB2 ASN A  85       9.633  63.123  12.890  1.00  0.00           H  
ATOM   1241  HB3 ASN A  85       8.172  64.004  12.456  1.00  0.00           H  
ATOM   1242 HD21 ASN A  85       9.103  61.273  11.809  1.00  0.00           H  
ATOM   1243 HD22 ASN A  85       9.039  61.168  10.085  1.00  0.00           H  
ATOM   1244  N   PHE A  86      12.242  64.267  12.476  1.00  0.00           N  
ATOM   1245  CA  PHE A  86      13.621  63.926  12.149  1.00  0.00           C  
ATOM   1246  C   PHE A  86      14.168  62.881  13.116  1.00  0.00           C  
ATOM   1247  O   PHE A  86      13.850  62.895  14.306  1.00  0.00           O  
ATOM   1248  CB  PHE A  86      14.500  65.178  12.182  1.00  0.00           C  
ATOM   1249  CG  PHE A  86      14.648  65.769  13.555  1.00  0.00           C  
ATOM   1250  CD1 PHE A  86      15.502  65.196  14.482  1.00  0.00           C  
ATOM   1251  CD2 PHE A  86      13.933  66.899  13.917  1.00  0.00           C  
ATOM   1252  CE1 PHE A  86      15.640  65.738  15.747  1.00  0.00           C  
ATOM   1253  CE2 PHE A  86      14.066  67.446  15.179  1.00  0.00           C  
ATOM   1254  CZ  PHE A  86      14.921  66.865  16.095  1.00  0.00           C  
ATOM   1255  H   PHE A  86      11.924  64.143  13.396  1.00  0.00           H  
ATOM   1256  HA  PHE A  86      13.632  63.515  11.151  1.00  0.00           H  
ATOM   1257  HB2 PHE A  86      15.487  64.926  11.822  1.00  0.00           H  
ATOM   1258  HB3 PHE A  86      14.067  65.930  11.540  1.00  0.00           H  
ATOM   1259  HD1 PHE A  86      16.065  64.315  14.211  1.00  0.00           H  
ATOM   1260  HD2 PHE A  86      13.264  67.356  13.201  1.00  0.00           H  
ATOM   1261  HE1 PHE A  86      16.308  65.282  16.460  1.00  0.00           H  
ATOM   1262  HE2 PHE A  86      13.503  68.328  15.448  1.00  0.00           H  
ATOM   1263  HZ  PHE A  86      15.026  67.291  17.082  1.00  0.00           H  
ATOM   1264  N   GLU A  87      14.992  61.975  12.598  1.00  0.00           N  
ATOM   1265  CA  GLU A  87      15.582  60.922  13.416  1.00  0.00           C  
ATOM   1266  C   GLU A  87      17.094  60.867  13.223  1.00  0.00           C  
ATOM   1267  O   GLU A  87      17.580  60.625  12.120  1.00  0.00           O  
ATOM   1268  CB  GLU A  87      14.962  59.567  13.068  1.00  0.00           C  
ATOM   1269  CG  GLU A  87      15.222  58.492  14.109  1.00  0.00           C  
ATOM   1270  CD  GLU A  87      14.493  57.198  13.806  1.00  0.00           C  
ATOM   1271  OE1 GLU A  87      13.261  57.243  13.612  1.00  0.00           O  
ATOM   1272  OE2 GLU A  87      15.156  56.140  13.764  1.00  0.00           O  
ATOM   1273  H   GLU A  87      15.207  62.017  11.643  1.00  0.00           H  
ATOM   1274  HA  GLU A  87      15.371  61.148  14.450  1.00  0.00           H  
ATOM   1275  HB2 GLU A  87      13.893  59.689  12.965  1.00  0.00           H  
ATOM   1276  HB3 GLU A  87      15.369  59.232  12.125  1.00  0.00           H  
ATOM   1277  HG2 GLU A  87      16.282  58.291  14.143  1.00  0.00           H  
ATOM   1278  HG3 GLU A  87      14.895  58.856  15.072  1.00  0.00           H  
ATOM   1279  N   GLU A  88      17.831  61.092  14.307  1.00  0.00           N  
ATOM   1280  CA  GLU A  88      19.288  61.069  14.257  1.00  0.00           C  
ATOM   1281  C   GLU A  88      19.854  60.121  15.309  1.00  0.00           C  
ATOM   1282  O   GLU A  88      19.136  59.666  16.200  1.00  0.00           O  
ATOM   1283  CB  GLU A  88      19.851  62.477  14.468  1.00  0.00           C  
ATOM   1284  CG  GLU A  88      19.326  63.497  13.472  1.00  0.00           C  
ATOM   1285  CD  GLU A  88      20.003  63.395  12.119  1.00  0.00           C  
ATOM   1286  OE1 GLU A  88      21.050  62.720  12.031  1.00  0.00           O  
ATOM   1287  OE2 GLU A  88      19.486  63.988  11.150  1.00  0.00           O  
ATOM   1288  H   GLU A  88      17.385  61.279  15.159  1.00  0.00           H  
ATOM   1289  HA  GLU A  88      19.581  60.718  13.279  1.00  0.00           H  
ATOM   1290  HB2 GLU A  88      19.593  62.808  15.463  1.00  0.00           H  
ATOM   1291  HB3 GLU A  88      20.926  62.437  14.378  1.00  0.00           H  
ATOM   1292  HG2 GLU A  88      18.266  63.340  13.339  1.00  0.00           H  
ATOM   1293  HG3 GLU A  88      19.493  64.487  13.869  1.00  0.00           H  
ATOM   1294  N   GLU A  89      21.146  59.826  15.200  1.00  0.00           N  
ATOM   1295  CA  GLU A  89      21.807  58.931  16.142  1.00  0.00           C  
ATOM   1296  C   GLU A  89      23.213  59.427  16.469  1.00  0.00           C  
ATOM   1297  O   GLU A  89      24.014  59.694  15.574  1.00  0.00           O  
ATOM   1298  CB  GLU A  89      21.876  57.513  15.570  1.00  0.00           C  
ATOM   1299  CG  GLU A  89      20.525  56.823  15.490  1.00  0.00           C  
ATOM   1300  CD  GLU A  89      20.476  55.760  14.409  1.00  0.00           C  
ATOM   1301  OE1 GLU A  89      21.219  54.763  14.522  1.00  0.00           O  
ATOM   1302  OE2 GLU A  89      19.692  55.926  13.451  1.00  0.00           O  
ATOM   1303  H   GLU A  89      21.666  60.220  14.469  1.00  0.00           H  
ATOM   1304  HA  GLU A  89      21.224  58.914  17.050  1.00  0.00           H  
ATOM   1305  HB2 GLU A  89      22.293  57.559  14.575  1.00  0.00           H  
ATOM   1306  HB3 GLU A  89      22.525  56.917  16.194  1.00  0.00           H  
ATOM   1307  HG2 GLU A  89      20.317  56.356  16.442  1.00  0.00           H  
ATOM   1308  HG3 GLU A  89      19.768  57.564  15.281  1.00  0.00           H  
ATOM   1309  N   PHE A  90      23.504  59.551  17.760  1.00  0.00           N  
ATOM   1310  CA  PHE A  90      24.811  60.017  18.208  1.00  0.00           C  
ATOM   1311  C   PHE A  90      25.598  58.884  18.861  1.00  0.00           C  
ATOM   1312  O   PHE A  90      25.020  57.974  19.457  1.00  0.00           O  
ATOM   1313  CB  PHE A  90      24.653  61.178  19.193  1.00  0.00           C  
ATOM   1314  CG  PHE A  90      23.807  62.301  18.664  1.00  0.00           C  
ATOM   1315  CD1 PHE A  90      24.381  63.345  17.957  1.00  0.00           C  
ATOM   1316  CD2 PHE A  90      22.437  62.312  18.873  1.00  0.00           C  
ATOM   1317  CE1 PHE A  90      23.606  64.379  17.470  1.00  0.00           C  
ATOM   1318  CE2 PHE A  90      21.656  63.344  18.388  1.00  0.00           C  
ATOM   1319  CZ  PHE A  90      22.241  64.379  17.685  1.00  0.00           C  
ATOM   1320  H   PHE A  90      22.823  59.323  18.428  1.00  0.00           H  
ATOM   1321  HA  PHE A  90      25.353  60.363  17.342  1.00  0.00           H  
ATOM   1322  HB2 PHE A  90      24.190  60.812  20.097  1.00  0.00           H  
ATOM   1323  HB3 PHE A  90      25.628  61.577  19.427  1.00  0.00           H  
ATOM   1324  HD1 PHE A  90      25.448  63.346  17.786  1.00  0.00           H  
ATOM   1325  HD2 PHE A  90      21.979  61.503  19.424  1.00  0.00           H  
ATOM   1326  HE1 PHE A  90      24.065  65.187  16.920  1.00  0.00           H  
ATOM   1327  HE2 PHE A  90      20.590  63.340  18.560  1.00  0.00           H  
ATOM   1328  HZ  PHE A  90      21.633  65.187  17.307  1.00  0.00           H  
ATOM   1329  N   LEU A  91      26.920  58.947  18.746  1.00  0.00           N  
ATOM   1330  CA  LEU A  91      27.788  57.928  19.325  1.00  0.00           C  
ATOM   1331  C   LEU A  91      28.835  58.558  20.237  1.00  0.00           C  
ATOM   1332  O   LEU A  91      29.166  59.735  20.100  1.00  0.00           O  
ATOM   1333  CB  LEU A  91      28.476  57.127  18.217  1.00  0.00           C  
ATOM   1334  CG  LEU A  91      27.551  56.438  17.214  1.00  0.00           C  
ATOM   1335  CD1 LEU A  91      28.362  55.753  16.124  1.00  0.00           C  
ATOM   1336  CD2 LEU A  91      26.651  55.435  17.920  1.00  0.00           C  
ATOM   1337  H   LEU A  91      27.323  59.697  18.260  1.00  0.00           H  
ATOM   1338  HA  LEU A  91      27.172  57.261  19.909  1.00  0.00           H  
ATOM   1339  HB2 LEU A  91      29.114  57.803  17.669  1.00  0.00           H  
ATOM   1340  HB3 LEU A  91      29.081  56.365  18.689  1.00  0.00           H  
ATOM   1341  HG  LEU A  91      26.922  57.181  16.744  1.00  0.00           H  
ATOM   1342 HD11 LEU A  91      27.938  54.783  15.914  1.00  0.00           H  
ATOM   1343 HD12 LEU A  91      29.383  55.637  16.454  1.00  0.00           H  
ATOM   1344 HD13 LEU A  91      28.341  56.356  15.228  1.00  0.00           H  
ATOM   1345 HD21 LEU A  91      25.736  55.923  18.220  1.00  0.00           H  
ATOM   1346 HD22 LEU A  91      27.157  55.050  18.794  1.00  0.00           H  
ATOM   1347 HD23 LEU A  91      26.422  54.621  17.249  1.00  0.00           H  
ATOM   1348  N   VAL A  92      29.354  57.764  21.170  1.00  0.00           N  
ATOM   1349  CA  VAL A  92      30.365  58.243  22.103  1.00  0.00           C  
ATOM   1350  C   VAL A  92      31.627  57.390  22.033  1.00  0.00           C  
ATOM   1351  O   VAL A  92      31.628  56.230  22.443  1.00  0.00           O  
ATOM   1352  CB  VAL A  92      29.838  58.242  23.551  1.00  0.00           C  
ATOM   1353  CG1 VAL A  92      30.893  58.787  24.503  1.00  0.00           C  
ATOM   1354  CG2 VAL A  92      28.552  59.048  23.649  1.00  0.00           C  
ATOM   1355  H   VAL A  92      29.049  56.835  21.230  1.00  0.00           H  
ATOM   1356  HA  VAL A  92      30.615  59.260  21.834  1.00  0.00           H  
ATOM   1357  HB  VAL A  92      29.623  57.222  23.833  1.00  0.00           H  
ATOM   1358 HG11 VAL A  92      31.870  58.686  24.054  1.00  0.00           H  
ATOM   1359 HG12 VAL A  92      30.693  59.829  24.704  1.00  0.00           H  
ATOM   1360 HG13 VAL A  92      30.863  58.229  25.428  1.00  0.00           H  
ATOM   1361 HG21 VAL A  92      28.085  59.098  22.678  1.00  0.00           H  
ATOM   1362 HG22 VAL A  92      27.880  58.569  24.348  1.00  0.00           H  
ATOM   1363 HG23 VAL A  92      28.777  60.046  23.995  1.00  0.00           H  
ATOM   1364  N   ASN A  93      32.701  57.973  21.510  1.00  0.00           N  
ATOM   1365  CA  ASN A  93      33.970  57.266  21.385  1.00  0.00           C  
ATOM   1366  C   ASN A  93      34.606  57.043  22.754  1.00  0.00           C  
ATOM   1367  O   ASN A  93      34.814  57.990  23.514  1.00  0.00           O  
ATOM   1368  CB  ASN A  93      34.928  58.049  20.486  1.00  0.00           C  
ATOM   1369  CG  ASN A  93      34.206  58.782  19.372  1.00  0.00           C  
ATOM   1370  OD1 ASN A  93      34.091  58.278  18.254  1.00  0.00           O  
ATOM   1371  ND2 ASN A  93      33.715  59.979  19.672  1.00  0.00           N  
ATOM   1372  H   ASN A  93      32.638  58.901  21.199  1.00  0.00           H  
ATOM   1373  HA  ASN A  93      33.771  56.306  20.934  1.00  0.00           H  
ATOM   1374  HB2 ASN A  93      35.459  58.775  21.083  1.00  0.00           H  
ATOM   1375  HB3 ASN A  93      35.637  57.366  20.042  1.00  0.00           H  
ATOM   1376 HD21 ASN A  93      33.845  60.318  20.583  1.00  0.00           H  
ATOM   1377 HD22 ASN A  93      33.243  60.475  18.970  1.00  0.00           H  
ATOM   1378  N   VAL A  94      34.914  55.788  23.060  1.00  0.00           N  
ATOM   1379  CA  VAL A  94      35.528  55.441  24.337  1.00  0.00           C  
ATOM   1380  C   VAL A  94      36.797  54.621  24.131  1.00  0.00           C  
ATOM   1381  O   VAL A  94      36.797  53.631  23.400  1.00  0.00           O  
ATOM   1382  CB  VAL A  94      34.557  54.648  25.230  1.00  0.00           C  
ATOM   1383  CG1 VAL A  94      35.206  54.322  26.567  1.00  0.00           C  
ATOM   1384  CG2 VAL A  94      33.264  55.424  25.431  1.00  0.00           C  
ATOM   1385  H   VAL A  94      34.724  55.077  22.413  1.00  0.00           H  
ATOM   1386  HA  VAL A  94      35.783  56.360  24.845  1.00  0.00           H  
ATOM   1387  HB  VAL A  94      34.320  53.718  24.733  1.00  0.00           H  
ATOM   1388 HG11 VAL A  94      34.735  54.904  27.347  1.00  0.00           H  
ATOM   1389 HG12 VAL A  94      35.084  53.269  26.779  1.00  0.00           H  
ATOM   1390 HG13 VAL A  94      36.257  54.563  26.524  1.00  0.00           H  
ATOM   1391 HG21 VAL A  94      33.472  56.335  25.970  1.00  0.00           H  
ATOM   1392 HG22 VAL A  94      32.834  55.664  24.469  1.00  0.00           H  
ATOM   1393 HG23 VAL A  94      32.566  54.823  25.995  1.00  0.00           H  
ATOM   1394  N   ASN A  95      37.877  55.040  24.782  1.00  0.00           N  
ATOM   1395  CA  ASN A  95      39.154  54.344  24.671  1.00  0.00           C  
ATOM   1396  C   ASN A  95      39.060  52.939  25.258  1.00  0.00           C  
ATOM   1397  O   ASN A  95      38.796  52.767  26.447  1.00  0.00           O  
ATOM   1398  CB  ASN A  95      40.253  55.134  25.384  1.00  0.00           C  
ATOM   1399  CG  ASN A  95      41.558  54.366  25.464  1.00  0.00           C  
ATOM   1400  OD1 ASN A  95      42.189  54.084  24.446  1.00  0.00           O  
ATOM   1401  ND2 ASN A  95      41.969  54.023  26.681  1.00  0.00           N  
ATOM   1402  H   ASN A  95      37.815  55.836  25.351  1.00  0.00           H  
ATOM   1403  HA  ASN A  95      39.400  54.268  23.623  1.00  0.00           H  
ATOM   1404  HB2 ASN A  95      40.433  56.055  24.847  1.00  0.00           H  
ATOM   1405  HB3 ASN A  95      39.929  55.366  26.388  1.00  0.00           H  
ATOM   1406 HD21 ASN A  95      41.414  54.282  27.446  1.00  0.00           H  
ATOM   1407 HD22 ASN A  95      42.809  53.527  26.761  1.00  0.00           H  
ATOM   1408  N   GLY A  96      39.281  51.934  24.415  1.00  0.00           N  
ATOM   1409  CA  GLY A  96      39.218  50.557  24.867  1.00  0.00           C  
ATOM   1410  C   GLY A  96      37.912  49.884  24.495  1.00  0.00           C  
ATOM   1411  O   GLY A  96      37.902  48.904  23.751  1.00  0.00           O  
ATOM   1412  H   GLY A  96      39.488  52.131  23.477  1.00  0.00           H  
ATOM   1413  HA2 GLY A  96      40.034  50.007  24.425  1.00  0.00           H  
ATOM   1414  HA3 GLY A  96      39.325  50.539  25.942  1.00  0.00           H  
ATOM   1415  N   SER A  97      36.807  50.410  25.015  1.00  0.00           N  
ATOM   1416  CA  SER A  97      35.490  49.848  24.737  1.00  0.00           C  
ATOM   1417  C   SER A  97      35.383  49.410  23.279  1.00  0.00           C  
ATOM   1418  O   SER A  97      35.880  50.070  22.367  1.00  0.00           O  
ATOM   1419  CB  SER A  97      34.399  50.874  25.053  1.00  0.00           C  
ATOM   1420  OG  SER A  97      34.064  51.633  23.906  1.00  0.00           O  
ATOM   1421  H   SER A  97      36.880  51.191  25.602  1.00  0.00           H  
ATOM   1422  HA  SER A  97      35.356  48.985  25.371  1.00  0.00           H  
ATOM   1423  HB2 SER A  97      33.516  50.360  25.401  1.00  0.00           H  
ATOM   1424  HB3 SER A  97      34.752  51.544  25.824  1.00  0.00           H  
ATOM   1425  HG  SER A  97      34.867  51.898  23.451  1.00  0.00           H  
ATOM   1426  N   PRO A  98      34.719  48.266  23.054  1.00  0.00           N  
ATOM   1427  CA  PRO A  98      34.529  47.713  21.711  1.00  0.00           C  
ATOM   1428  C   PRO A  98      33.573  48.549  20.867  1.00  0.00           C  
ATOM   1429  O   PRO A  98      33.823  48.793  19.688  1.00  0.00           O  
ATOM   1430  CB  PRO A  98      33.935  46.327  21.978  1.00  0.00           C  
ATOM   1431  CG  PRO A  98      33.272  46.450  23.306  1.00  0.00           C  
ATOM   1432  CD  PRO A  98      34.100  47.427  24.094  1.00  0.00           C  
ATOM   1433  HA  PRO A  98      35.470  47.608  21.188  1.00  0.00           H  
ATOM   1434  HB2 PRO A  98      33.224  46.082  21.201  1.00  0.00           H  
ATOM   1435  HB3 PRO A  98      34.723  45.591  21.998  1.00  0.00           H  
ATOM   1436  HG2 PRO A  98      32.267  46.826  23.182  1.00  0.00           H  
ATOM   1437  HG3 PRO A  98      33.257  45.489  23.799  1.00  0.00           H  
ATOM   1438  HD2 PRO A  98      33.471  48.018  24.743  1.00  0.00           H  
ATOM   1439  HD3 PRO A  98      34.853  46.907  24.668  1.00  0.00           H  
ATOM   1440  N   GLU A  99      32.477  48.985  21.481  1.00  0.00           N  
ATOM   1441  CA  GLU A  99      31.484  49.794  20.786  1.00  0.00           C  
ATOM   1442  C   GLU A  99      31.087  51.008  21.622  1.00  0.00           C  
ATOM   1443  O   GLU A  99      30.987  50.942  22.848  1.00  0.00           O  
ATOM   1444  CB  GLU A  99      30.245  48.956  20.465  1.00  0.00           C  
ATOM   1445  CG  GLU A  99      29.075  49.773  19.942  1.00  0.00           C  
ATOM   1446  CD  GLU A  99      27.735  49.132  20.243  1.00  0.00           C  
ATOM   1447  OE1 GLU A  99      27.607  48.497  21.311  1.00  0.00           O  
ATOM   1448  OE2 GLU A  99      26.813  49.263  19.411  1.00  0.00           O  
ATOM   1449  H   GLU A  99      32.334  48.757  22.424  1.00  0.00           H  
ATOM   1450  HA  GLU A  99      31.923  50.137  19.862  1.00  0.00           H  
ATOM   1451  HB2 GLU A  99      30.505  48.221  19.718  1.00  0.00           H  
ATOM   1452  HB3 GLU A  99      29.928  48.446  21.363  1.00  0.00           H  
ATOM   1453  HG2 GLU A  99      29.100  50.749  20.403  1.00  0.00           H  
ATOM   1454  HG3 GLU A  99      29.176  49.879  18.873  1.00  0.00           H  
ATOM   1455  N   PRO A 100      30.858  52.143  20.946  1.00  0.00           N  
ATOM   1456  CA  PRO A 100      30.470  53.393  21.606  1.00  0.00           C  
ATOM   1457  C   PRO A 100      29.057  53.331  22.177  1.00  0.00           C  
ATOM   1458  O   PRO A 100      28.341  52.348  21.987  1.00  0.00           O  
ATOM   1459  CB  PRO A 100      30.547  54.428  20.480  1.00  0.00           C  
ATOM   1460  CG  PRO A 100      30.346  53.642  19.231  1.00  0.00           C  
ATOM   1461  CD  PRO A 100      30.960  52.294  19.484  1.00  0.00           C  
ATOM   1462  HA  PRO A 100      31.163  53.660  22.391  1.00  0.00           H  
ATOM   1463  HB2 PRO A 100      29.770  55.167  20.614  1.00  0.00           H  
ATOM   1464  HB3 PRO A 100      31.514  54.907  20.494  1.00  0.00           H  
ATOM   1465  HG2 PRO A 100      29.291  53.542  19.026  1.00  0.00           H  
ATOM   1466  HG3 PRO A 100      30.845  54.131  18.407  1.00  0.00           H  
ATOM   1467  HD2 PRO A 100      30.399  51.522  18.977  1.00  0.00           H  
ATOM   1468  HD3 PRO A 100      31.992  52.282  19.168  1.00  0.00           H  
ATOM   1469  N   VAL A 101      28.660  54.390  22.877  1.00  0.00           N  
ATOM   1470  CA  VAL A 101      27.333  54.458  23.475  1.00  0.00           C  
ATOM   1471  C   VAL A 101      26.341  55.135  22.535  1.00  0.00           C  
ATOM   1472  O   VAL A 101      26.149  56.349  22.587  1.00  0.00           O  
ATOM   1473  CB  VAL A 101      27.357  55.219  24.813  1.00  0.00           C  
ATOM   1474  CG1 VAL A 101      25.941  55.459  25.317  1.00  0.00           C  
ATOM   1475  CG2 VAL A 101      28.177  54.459  25.843  1.00  0.00           C  
ATOM   1476  H   VAL A 101      29.276  55.143  22.994  1.00  0.00           H  
ATOM   1477  HA  VAL A 101      27.000  53.447  23.666  1.00  0.00           H  
ATOM   1478  HB  VAL A 101      27.824  56.179  24.649  1.00  0.00           H  
ATOM   1479 HG11 VAL A 101      25.977  55.771  26.350  1.00  0.00           H  
ATOM   1480 HG12 VAL A 101      25.473  56.228  24.723  1.00  0.00           H  
ATOM   1481 HG13 VAL A 101      25.372  54.545  25.238  1.00  0.00           H  
ATOM   1482 HG21 VAL A 101      29.226  54.537  25.596  1.00  0.00           H  
ATOM   1483 HG22 VAL A 101      28.007  54.882  26.824  1.00  0.00           H  
ATOM   1484 HG23 VAL A 101      27.883  53.420  25.844  1.00  0.00           H  
ATOM   1485  N   LYS A 102      25.712  54.340  21.676  1.00  0.00           N  
ATOM   1486  CA  LYS A 102      24.738  54.861  20.724  1.00  0.00           C  
ATOM   1487  C   LYS A 102      23.550  55.487  21.449  1.00  0.00           C  
ATOM   1488  O   LYS A 102      23.041  54.933  22.423  1.00  0.00           O  
ATOM   1489  CB  LYS A 102      24.251  53.743  19.798  1.00  0.00           C  
ATOM   1490  CG  LYS A 102      23.133  54.172  18.863  1.00  0.00           C  
ATOM   1491  CD  LYS A 102      22.644  53.013  18.012  1.00  0.00           C  
ATOM   1492  CE  LYS A 102      23.637  52.669  16.914  1.00  0.00           C  
ATOM   1493  NZ  LYS A 102      23.212  51.474  16.134  1.00  0.00           N  
ATOM   1494  H   LYS A 102      25.907  53.379  21.683  1.00  0.00           H  
ATOM   1495  HA  LYS A 102      25.225  55.620  20.133  1.00  0.00           H  
ATOM   1496  HB2 LYS A 102      25.082  53.403  19.198  1.00  0.00           H  
ATOM   1497  HB3 LYS A 102      23.892  52.922  20.402  1.00  0.00           H  
ATOM   1498  HG2 LYS A 102      22.307  54.546  19.452  1.00  0.00           H  
ATOM   1499  HG3 LYS A 102      23.499  54.954  18.215  1.00  0.00           H  
ATOM   1500  HD2 LYS A 102      22.507  52.147  18.642  1.00  0.00           H  
ATOM   1501  HD3 LYS A 102      21.700  53.284  17.559  1.00  0.00           H  
ATOM   1502  HE2 LYS A 102      23.723  53.512  16.246  1.00  0.00           H  
ATOM   1503  HE3 LYS A 102      24.598  52.470  17.366  1.00  0.00           H  
ATOM   1504  HZ1 LYS A 102      23.561  51.543  15.156  1.00  0.00           H  
ATOM   1505  HZ2 LYS A 102      22.174  51.411  16.116  1.00  0.00           H  
ATOM   1506  HZ3 LYS A 102      23.593  50.610  16.567  1.00  0.00           H  
ATOM   1507  N   LEU A 103      23.113  56.646  20.966  1.00  0.00           N  
ATOM   1508  CA  LEU A 103      21.984  57.347  21.568  1.00  0.00           C  
ATOM   1509  C   LEU A 103      21.036  57.873  20.494  1.00  0.00           C  
ATOM   1510  O   LEU A 103      21.416  58.700  19.665  1.00  0.00           O  
ATOM   1511  CB  LEU A 103      22.481  58.504  22.436  1.00  0.00           C  
ATOM   1512  CG  LEU A 103      21.401  59.386  23.062  1.00  0.00           C  
ATOM   1513  CD1 LEU A 103      20.866  58.750  24.336  1.00  0.00           C  
ATOM   1514  CD2 LEU A 103      21.946  60.777  23.348  1.00  0.00           C  
ATOM   1515  H   LEU A 103      23.559  57.039  20.189  1.00  0.00           H  
ATOM   1516  HA  LEU A 103      21.451  56.645  22.190  1.00  0.00           H  
ATOM   1517  HB2 LEU A 103      23.073  58.086  23.236  1.00  0.00           H  
ATOM   1518  HB3 LEU A 103      23.107  59.134  21.820  1.00  0.00           H  
ATOM   1519  HG  LEU A 103      20.577  59.484  22.368  1.00  0.00           H  
ATOM   1520 HD11 LEU A 103      21.464  57.888  24.587  1.00  0.00           H  
ATOM   1521 HD12 LEU A 103      19.841  58.444  24.182  1.00  0.00           H  
ATOM   1522 HD13 LEU A 103      20.909  59.468  25.142  1.00  0.00           H  
ATOM   1523 HD21 LEU A 103      22.580  60.743  24.222  1.00  0.00           H  
ATOM   1524 HD22 LEU A 103      21.126  61.457  23.526  1.00  0.00           H  
ATOM   1525 HD23 LEU A 103      22.520  61.120  22.499  1.00  0.00           H  
ATOM   1526  N   THR A 104      19.798  57.390  20.518  1.00  0.00           N  
ATOM   1527  CA  THR A 104      18.795  57.811  19.548  1.00  0.00           C  
ATOM   1528  C   THR A 104      17.891  58.892  20.128  1.00  0.00           C  
ATOM   1529  O   THR A 104      17.340  58.735  21.219  1.00  0.00           O  
ATOM   1530  CB  THR A 104      17.927  56.625  19.086  1.00  0.00           C  
ATOM   1531  OG1 THR A 104      18.752  55.479  18.845  1.00  0.00           O  
ATOM   1532  CG2 THR A 104      17.157  56.977  17.822  1.00  0.00           C  
ATOM   1533  H   THR A 104      19.555  56.733  21.204  1.00  0.00           H  
ATOM   1534  HA  THR A 104      19.310  58.210  18.686  1.00  0.00           H  
ATOM   1535  HB  THR A 104      17.219  56.390  19.868  1.00  0.00           H  
ATOM   1536  HG1 THR A 104      19.268  55.285  19.631  1.00  0.00           H  
ATOM   1537 HG21 THR A 104      17.325  58.016  17.577  1.00  0.00           H  
ATOM   1538 HG22 THR A 104      16.103  56.810  17.986  1.00  0.00           H  
ATOM   1539 HG23 THR A 104      17.499  56.356  17.009  1.00  0.00           H  
ATOM   1540  N   ILE A 105      17.739  59.989  19.392  1.00  0.00           N  
ATOM   1541  CA  ILE A 105      16.899  61.095  19.834  1.00  0.00           C  
ATOM   1542  C   ILE A 105      15.825  61.415  18.800  1.00  0.00           C  
ATOM   1543  O   ILE A 105      16.131  61.743  17.654  1.00  0.00           O  
ATOM   1544  CB  ILE A 105      17.732  62.361  20.101  1.00  0.00           C  
ATOM   1545  CG1 ILE A 105      18.696  62.128  21.268  1.00  0.00           C  
ATOM   1546  CG2 ILE A 105      16.819  63.544  20.390  1.00  0.00           C  
ATOM   1547  CD1 ILE A 105      19.758  63.197  21.397  1.00  0.00           C  
ATOM   1548  H   ILE A 105      18.204  60.054  18.533  1.00  0.00           H  
ATOM   1549  HA  ILE A 105      16.420  60.801  20.757  1.00  0.00           H  
ATOM   1550  HB  ILE A 105      18.302  62.586  19.212  1.00  0.00           H  
ATOM   1551 HG12 ILE A 105      18.136  62.104  22.189  1.00  0.00           H  
ATOM   1552 HG13 ILE A 105      19.194  61.180  21.128  1.00  0.00           H  
ATOM   1553 HG21 ILE A 105      17.386  64.326  20.874  1.00  0.00           H  
ATOM   1554 HG22 ILE A 105      16.412  63.919  19.463  1.00  0.00           H  
ATOM   1555 HG23 ILE A 105      16.015  63.229  21.036  1.00  0.00           H  
ATOM   1556 HD11 ILE A 105      19.421  64.101  20.912  1.00  0.00           H  
ATOM   1557 HD12 ILE A 105      19.943  63.397  22.442  1.00  0.00           H  
ATOM   1558 HD13 ILE A 105      20.670  62.857  20.929  1.00  0.00           H  
ATOM   1559  N   ARG A 106      14.566  61.320  19.214  1.00  0.00           N  
ATOM   1560  CA  ARG A 106      13.445  61.601  18.325  1.00  0.00           C  
ATOM   1561  C   ARG A 106      12.807  62.944  18.662  1.00  0.00           C  
ATOM   1562  O   ARG A 106      12.594  63.267  19.831  1.00  0.00           O  
ATOM   1563  CB  ARG A 106      12.399  60.488  18.420  1.00  0.00           C  
ATOM   1564  CG  ARG A 106      11.457  60.640  19.603  1.00  0.00           C  
ATOM   1565  CD  ARG A 106      10.549  59.428  19.750  1.00  0.00           C  
ATOM   1566  NE  ARG A 106       9.423  59.693  20.641  1.00  0.00           N  
ATOM   1567  CZ  ARG A 106       8.537  58.770  20.999  1.00  0.00           C  
ATOM   1568  NH1 ARG A 106       8.646  57.530  20.546  1.00  0.00           N  
ATOM   1569  NH2 ARG A 106       7.539  59.088  21.815  1.00  0.00           N  
ATOM   1570  H   ARG A 106      14.386  61.054  20.140  1.00  0.00           H  
ATOM   1571  HA  ARG A 106      13.825  61.639  17.314  1.00  0.00           H  
ATOM   1572  HB2 ARG A 106      11.810  60.486  17.516  1.00  0.00           H  
ATOM   1573  HB3 ARG A 106      12.908  59.541  18.512  1.00  0.00           H  
ATOM   1574  HG2 ARG A 106      12.040  60.750  20.505  1.00  0.00           H  
ATOM   1575  HG3 ARG A 106      10.847  61.519  19.455  1.00  0.00           H  
ATOM   1576  HD2 ARG A 106      10.169  59.159  18.775  1.00  0.00           H  
ATOM   1577  HD3 ARG A 106      11.128  58.608  20.149  1.00  0.00           H  
ATOM   1578  HE  ARG A 106       9.323  60.603  20.988  1.00  0.00           H  
ATOM   1579 HH11 ARG A 106       9.398  57.286  19.933  1.00  0.00           H  
ATOM   1580 HH12 ARG A 106       7.979  56.835  20.819  1.00  0.00           H  
ATOM   1581 HH21 ARG A 106       7.454  60.022  22.159  1.00  0.00           H  
ATOM   1582 HH22 ARG A 106       6.874  58.393  22.084  1.00  0.00           H  
ATOM   1583  N   GLY A 107      12.503  63.726  17.631  1.00  0.00           N  
ATOM   1584  CA  GLY A 107      11.892  65.026  17.838  1.00  0.00           C  
ATOM   1585  C   GLY A 107      11.093  65.491  16.636  1.00  0.00           C  
ATOM   1586  O   GLY A 107      11.172  64.893  15.562  1.00  0.00           O  
ATOM   1587  H   GLY A 107      12.695  63.417  16.720  1.00  0.00           H  
ATOM   1588  HA2 GLY A 107      11.236  64.970  18.693  1.00  0.00           H  
ATOM   1589  HA3 GLY A 107      12.670  65.748  18.039  1.00  0.00           H  
ATOM   1590  N   CYS A 108      10.323  66.557  16.817  1.00  0.00           N  
ATOM   1591  CA  CYS A 108       9.505  67.100  15.738  1.00  0.00           C  
ATOM   1592  C   CYS A 108       9.539  68.625  15.744  1.00  0.00           C  
ATOM   1593  O   CYS A 108       9.272  69.258  16.765  1.00  0.00           O  
ATOM   1594  CB  CYS A 108       8.062  66.610  15.868  1.00  0.00           C  
ATOM   1595  SG  CYS A 108       7.791  64.936  15.241  1.00  0.00           S  
ATOM   1596  H   CYS A 108      10.303  66.991  17.695  1.00  0.00           H  
ATOM   1597  HA  CYS A 108       9.912  66.747  14.803  1.00  0.00           H  
ATOM   1598  HB2 CYS A 108       7.780  66.619  16.911  1.00  0.00           H  
ATOM   1599  HB3 CYS A 108       7.412  67.277  15.321  1.00  0.00           H  
ATOM   1600  HG  CYS A 108       8.761  64.164  15.707  1.00  0.00           H  
ATOM   1601  N   VAL A 109       9.872  69.209  14.596  1.00  0.00           N  
ATOM   1602  CA  VAL A 109       9.942  70.659  14.470  1.00  0.00           C  
ATOM   1603  C   VAL A 109       8.756  71.200  13.680  1.00  0.00           C  
ATOM   1604  O   VAL A 109       8.525  70.804  12.537  1.00  0.00           O  
ATOM   1605  CB  VAL A 109      11.247  71.099  13.779  1.00  0.00           C  
ATOM   1606  CG1 VAL A 109      11.399  72.611  13.839  1.00  0.00           C  
ATOM   1607  CG2 VAL A 109      12.444  70.410  14.416  1.00  0.00           C  
ATOM   1608  H   VAL A 109      10.074  68.650  13.817  1.00  0.00           H  
ATOM   1609  HA  VAL A 109       9.924  71.083  15.463  1.00  0.00           H  
ATOM   1610  HB  VAL A 109      11.199  70.805  12.742  1.00  0.00           H  
ATOM   1611 HG11 VAL A 109      11.795  72.970  12.899  1.00  0.00           H  
ATOM   1612 HG12 VAL A 109      10.435  73.064  14.021  1.00  0.00           H  
ATOM   1613 HG13 VAL A 109      12.076  72.874  14.637  1.00  0.00           H  
ATOM   1614 HG21 VAL A 109      13.344  70.957  14.175  1.00  0.00           H  
ATOM   1615 HG22 VAL A 109      12.317  70.381  15.489  1.00  0.00           H  
ATOM   1616 HG23 VAL A 109      12.523  69.402  14.037  1.00  0.00           H  
ATOM   1617  N   ILE A 110       8.005  72.106  14.297  1.00  0.00           N  
ATOM   1618  CA  ILE A 110       6.843  72.704  13.651  1.00  0.00           C  
ATOM   1619  C   ILE A 110       6.903  74.226  13.707  1.00  0.00           C  
ATOM   1620  O   ILE A 110       7.690  74.799  14.459  1.00  0.00           O  
ATOM   1621  CB  ILE A 110       5.531  72.229  14.303  1.00  0.00           C  
ATOM   1622  CG1 ILE A 110       5.567  72.476  15.812  1.00  0.00           C  
ATOM   1623  CG2 ILE A 110       5.297  70.754  14.008  1.00  0.00           C  
ATOM   1624  CD1 ILE A 110       4.217  72.333  16.480  1.00  0.00           C  
ATOM   1625  H   ILE A 110       8.240  72.382  15.207  1.00  0.00           H  
ATOM   1626  HA  ILE A 110       6.841  72.393  12.616  1.00  0.00           H  
ATOM   1627  HB  ILE A 110       4.717  72.790  13.872  1.00  0.00           H  
ATOM   1628 HG12 ILE A 110       6.240  71.769  16.270  1.00  0.00           H  
ATOM   1629 HG13 ILE A 110       5.924  73.479  15.996  1.00  0.00           H  
ATOM   1630 HG21 ILE A 110       6.247  70.263  13.851  1.00  0.00           H  
ATOM   1631 HG22 ILE A 110       4.790  70.296  14.844  1.00  0.00           H  
ATOM   1632 HG23 ILE A 110       4.690  70.655  13.121  1.00  0.00           H  
ATOM   1633 HD11 ILE A 110       4.213  72.890  17.405  1.00  0.00           H  
ATOM   1634 HD12 ILE A 110       3.448  72.716  15.825  1.00  0.00           H  
ATOM   1635 HD13 ILE A 110       4.027  71.291  16.688  1.00  0.00           H  
ATOM   1636  N   GLY A 111       6.063  74.877  12.908  1.00  0.00           N  
ATOM   1637  CA  GLY A 111       6.036  76.327  12.883  1.00  0.00           C  
ATOM   1638  C   GLY A 111       4.648  76.877  12.622  1.00  0.00           C  
ATOM   1639  O   GLY A 111       3.705  76.134  12.344  1.00  0.00           O  
ATOM   1640  H   GLY A 111       5.459  74.367  12.329  1.00  0.00           H  
ATOM   1641  HA2 GLY A 111       6.385  76.699  13.835  1.00  0.00           H  
ATOM   1642  HA3 GLY A 111       6.700  76.675  12.106  1.00  0.00           H  
ATOM   1643  N   PRO A 112       4.507  78.208  12.712  1.00  0.00           N  
ATOM   1644  CA  PRO A 112       3.227  78.885  12.488  1.00  0.00           C  
ATOM   1645  C   PRO A 112       2.795  78.840  11.026  1.00  0.00           C  
ATOM   1646  O   PRO A 112       1.957  78.026  10.640  1.00  0.00           O  
ATOM   1647  CB  PRO A 112       3.508  80.326  12.918  1.00  0.00           C  
ATOM   1648  CG  PRO A 112       4.978  80.495  12.741  1.00  0.00           C  
ATOM   1649  CD  PRO A 112       5.587  79.154  13.040  1.00  0.00           C  
ATOM   1650  HA  PRO A 112       2.444  78.469  13.106  1.00  0.00           H  
ATOM   1651  HB2 PRO A 112       2.952  81.008  12.289  1.00  0.00           H  
ATOM   1652  HB3 PRO A 112       3.217  80.461  13.950  1.00  0.00           H  
ATOM   1653  HG2 PRO A 112       5.194  80.788  11.726  1.00  0.00           H  
ATOM   1654  HG3 PRO A 112       5.348  81.237  13.434  1.00  0.00           H  
ATOM   1655  HD2 PRO A 112       6.451  78.984  12.415  1.00  0.00           H  
ATOM   1656  HD3 PRO A 112       5.855  79.084  14.084  1.00  0.00           H  
TER    1657      PRO A 112                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
