
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  107 (  757),  selected  107 , name 1row_A
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 1row_A.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E     267           -
LGA    -       -      D     268           -
LGA    -       -      L     269           -
LGA    -       -      L     270           -
LGA    -       -      R     271           -
LGA    -       -      P     272           -
LGA    -       -      F     273           -
LGA    -       -      F     274           -
LGA    -       -      E     275           -
LGA    -       -      K     276           -
LGA    -       -      C     277           -
LGA    L     3_A      V     278          1.926
LGA    T     4_A      K     279          2.831
LGA    A     5_A      I     280          1.787
LGA    D     6_A      E     281          1.698
LGA    P     7_A      E     282          2.100
LGA    P     8_A      V     283           -
LGA    A     9_A      -       -           -
LGA    C    10_A      S     284           #
LGA    T    11_A      R     285          4.958
LGA    V    12_A      N     286          3.926
LGA    P    13_A      E     287          2.305
LGA    A    14_A      -       -           -
LGA    A    15_A      -       -           -
LGA    G    16_A      -       -           -
LGA    V    17_A      Q     288          0.824
LGA    S    18_A      G     289          3.309
LGA    S    19_A      V     290          2.136
LGA    T    20_A      T     291          1.764
LGA    H    21_A      L     292          1.405
LGA    K    22_A      S     293          1.975
LGA    L    23_A      I     294          1.951
LGA    V    24_A      T     295          1.473
LGA    N    25_A      N     296          1.153
LGA    G    26_A      V     297          1.357
LGA    G    27_A      T     298          1.954
LGA    A    28_A      D     299          1.686
LGA    E    29_A      L     300          1.375
LGA    K    30_A      V     301          0.838
LGA    I    31_A      L     302          1.000
LGA    V    32_A      K     303          0.567
LGA    F    33_A      L     304          0.614
LGA    K    34_A      K     305          1.256
LGA    I    35_A      K     306          2.580
LGA    K    36_A      T     307          3.724
LGA    S    37_A      A     308           #
LGA    S    38_A      H     309          3.252
LGA    N    39_A      D     310          1.588
LGA    N    40_A      T     311          0.510
LGA    N    41_A      L     312          2.869
LGA    E    42_A      -       -           -
LGA    Y    43_A      L     313          2.618
LGA    R    44_A      V     314          1.774
LGA    I    45_A      Y     315          1.227
LGA    A    46_A      F     316          3.336
LGA    P    47_A      -       -           -
LGA    V    48_A      R     317          1.709
LGA    F    49_A      D     318          0.334
LGA    G    50_A      M     319          1.392
LGA    F    51_A      T     320          0.735
LGA    V    52_A      L     321          0.666
LGA    D    53_A      K     322          0.928
LGA    P    54_A      P     323          1.132
LGA    S    55_A      H     324          1.056
LGA    G    56_A      T     325          1.276
LGA    S    57_A      R     326          2.549
LGA    K    58_A      Y     327          2.635
LGA    D    59_A      T     328          2.545
LGA    V    60_A      V     329          1.934
LGA    V    61_A      R     330          1.360
LGA    I    62_A      I     331          1.029
LGA    T    63_A      G     332          1.608
LGA    R    64_A      F     333          1.719
LGA    T    65_A      K     334          2.552
LGA    A    66_A      Q     335          2.825
LGA    G    67_A      G     336          1.670
LGA    A    68_A      I     337          5.356
LGA    P    69_A      -       -           -
LGA    K    70_A      K     338          4.944
LGA    E    71_A      G     339          4.500
LGA    D    72_A      G     340          1.766
LGA    K    73_A      D     341          0.890
LGA    L    74_A      V     342          0.746
LGA    V    75_A      N     343          1.746
LGA    V    76_A      F     344          3.044
LGA    H    77_A      E     345          1.858
LGA    F    78_A      V     346          1.203
LGA    A    79_A      T     347          3.778
LGA    S    80_A      N     348          3.062
LGA    A    81_A      F     349           -
LGA    P    82_A      I     350           -
LGA    A    83_A      V     351           -
LGA    D    84_A      A     352           -
LGA    A    85_A      -       -           -
LGA    T    86_A      -       -           -
LGA    D    87_A      -       -           -
LGA    A    88_A      -       -           -
LGA    Q    89_A      -       -           -
LGA    A    90_A      -       -           -
LGA    A    91_A      -       -           -
LGA    F    92_A      -       -           -
LGA    V    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    V    95_A      P     353           #
LGA    -       -      D     354           -
LGA    A    96_A      K     355          2.895
LGA    P    97_A      G     356          1.447
LGA    A    98_A      L     357          3.179
LGA    G    99_A      K     358          4.867
LGA    T   100_A      Y     359          2.094
LGA    V   101_A      -       -           -
LGA    T   102_A      T     360          2.260
LGA    I   103_A      I     361          1.910
LGA    P   104_A      S     362          1.715
LGA    M   105_A      L     363          2.300
LGA    S   106_A      -       -           -
LGA    A   107_A      -       -           -
LGA    T   108_A      -       -           -
LGA    A   109_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  107   97    5.0     77    2.35    12.99     57.763     3.148

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.235237 * X  +  -0.617415 * Y  +   0.750641 * Z  +  20.706392
  Y_new =  -0.962063 * X  +  -0.257726 * Y  +   0.089508 * Z  +  75.880508
  Z_new =   0.138196 * X  +  -0.743220 * Y  +  -0.654619 * Z  +  25.763073 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.292895    0.848698  [ DEG:  -131.3732     48.6268 ]
  Theta =  -0.138639   -3.002953  [ DEG:    -7.9435   -172.0565 ]
  Phi   =  -1.330989    1.810604  [ DEG:   -76.2600    103.7400 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1row_A                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1row_A.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  107   97   5.0   77   2.35   12.99  57.763
REMARK  ---------------------------------------------------------- 
MOLECULE 1row_A
HEADER    STRUCTURAL PROTEIN                      02-DEC-03   1ROW              
TITLE     STRUCTURE OF SSP-19, AN MSP-DOMAIN PROTEIN LIKE FAMILY                
TITLE    2 MEMBER IN CAENORHABDITIS ELEGANS                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MSP-DOMAIN PROTEIN LIKE FAMILY MEMBER;                     
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: SSP-19; SPERM-SPECIFIC FAMILY, CLASS P SSP-19;              
COMPND   5 HYPOTHETICAL PROTEIN C55C2.2;                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CAENORHABDITIS ELEGANS;                         
SOURCE   3 ORGANISM_COMMON: WORM;                                               
SOURCE   4 STRAIN: BRISTOL N2 (CLONE C55C2);                                    
SOURCE   5 CELL: SPERM;                                                         
SOURCE   6 GENE: SSP-19;                                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET28B                                    
KEYWDS    BETA BARREL, STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE              
KEYWDS   2 INITIATIVE, SOUTHEAST COLLABORATORY FOR STRUCTURAL GENOMICS,         
KEYWDS   3 SECSG                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.SCHORMANN,J.SYMERSKY,M.CARSON,M.LUO,G.LIN,S.LI,S.QIU,               
AUTHOR   2 A.ARABASHI,B.BUNZEL,D.LUO,L.NAGY,R.GRAY,C.-H.LUAN,J.ZHANG,           
AUTHOR   3 S.LU,L.DELUCAS,SOUTHEAST COLLABORATORY FOR STRUCTURAL                
AUTHOR   4 GENOMICS (SECSG)                                                     
REVDAT   3   01-FEB-05 1ROW    1       AUTHOR KEYWDS REMARK                     
REVDAT   2   28-SEP-04 1ROW    1       JRNL   HEADER REMARK                     
REVDAT   1   23-DEC-03 1ROW    0                                                
JRNL        AUTH   N.SCHORMANN,J.SYMERSKY,M.LUO                                 
JRNL        TITL   STRUCTURE OF SPERM-SPECIFIC PROTEIN SSP-19 FROM              
JRNL        TITL 2 CAENORHABDITIS ELEGANS.                                      
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  60  1840 2004              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1ROW A    1   109  UNP    O01829   O01829_CAEEL     1    109             
DBREF  1ROW B    1   109  UNP    O01829   O01829_CAEEL     1    109             
SEQRES   1 A  109  MET SER LEU THR ALA ASP PRO PRO ALA CYS THR VAL PRO          
SEQRES   2 A  109  ALA ALA GLY VAL SER SER THR HIS LYS LEU VAL ASN GLY          
SEQRES   3 A  109  GLY ALA GLU LYS ILE VAL PHE LYS ILE LYS SER SER ASN          
SEQRES   4 A  109  ASN ASN GLU TYR ARG ILE ALA PRO VAL PHE GLY PHE VAL          
SEQRES   5 A  109  ASP PRO SER GLY SER LYS ASP VAL VAL ILE THR ARG THR          
SEQRES   6 A  109  ALA GLY ALA PRO LYS GLU ASP LYS LEU VAL VAL HIS PHE          
SEQRES   7 A  109  ALA SER ALA PRO ALA ASP ALA THR ASP ALA GLN ALA ALA          
SEQRES   8 A  109  PHE VAL ALA VAL ALA PRO ALA GLY THR VAL THR ILE PRO          
SEQRES   9 A  109  MET SER ALA THR ALA                                          
SEQRES   1 B  109  MET SER LEU THR ALA ASP PRO PRO ALA CYS THR VAL PRO          
SEQRES   2 B  109  ALA ALA GLY VAL SER SER THR HIS LYS LEU VAL ASN GLY          
SEQRES   3 B  109  GLY ALA GLU LYS ILE VAL PHE LYS ILE LYS SER SER ASN          
SEQRES   4 B  109  ASN ASN GLU TYR ARG ILE ALA PRO VAL PHE GLY PHE VAL          
SEQRES   5 B  109  ASP PRO SER GLY SER LYS ASP VAL VAL ILE THR ARG THR          
SEQRES   6 B  109  ALA GLY ALA PRO LYS GLU ASP LYS LEU VAL VAL HIS PHE          
SEQRES   7 B  109  ALA SER ALA PRO ALA ASP ALA THR ASP ALA GLN ALA ALA          
SEQRES   8 B  109  PHE VAL ALA VAL ALA PRO ALA GLY THR VAL THR ILE PRO          
SEQRES   9 B  109  MET SER ALA THR ALA                                          
FORMUL   3  HOH   *157(H2 O)                                                    
CRYST1   52.354   31.848   55.577  90.00  97.67  90.00 P 1 21 1      4          
ATOM      1  N   LEU A   3      28.841  51.498  31.410  1.00 31.92           N  
ATOM      2  CA  LEU A   3      28.608  52.918  31.011  1.00 29.67           C  
ATOM      3  C   LEU A   3      27.162  53.168  30.598  1.00 28.27           C  
ATOM      4  O   LEU A   3      26.698  52.645  29.591  1.00 28.82           O  
ATOM      5  CB  LEU A   3      29.523  53.301  29.852  1.00 31.13           C  
ATOM      6  CG  LEU A   3      29.357  54.738  29.354  1.00 29.48           C  
ATOM      7  CD1 LEU A   3      29.536  55.710  30.507  1.00 30.51           C  
ATOM      8  CD2 LEU A   3      30.374  55.008  28.261  1.00 33.31           C  
ATOM      9  N   THR A   4      26.457  53.979  31.376  1.00 25.26           N  
ATOM     10  CA  THR A   4      25.071  54.286  31.077  1.00 23.21           C  
ATOM     11  C   THR A   4      24.851  55.785  30.891  1.00 22.74           C  
ATOM     12  O   THR A   4      25.719  56.597  31.188  1.00 21.27           O  
ATOM     13  CB  THR A   4      24.139  53.786  32.205  1.00 22.02           C  
ATOM     14  OG1 THR A   4      24.562  54.342  33.453  1.00 21.46           O  
ATOM     15  CG2 THR A   4      24.184  52.273  32.308  1.00 22.52           C  
ATOM     16  N   ALA A   5      23.681  56.139  30.376  1.00 22.68           N  
ATOM     17  CA  ALA A   5      23.318  57.531  30.179  1.00 22.09           C  
ATOM     18  C   ALA A   5      21.917  57.689  30.750  1.00 23.14           C  
ATOM     19  O   ALA A   5      20.995  56.966  30.373  1.00 23.12           O  
ATOM     20  CB  ALA A   5      23.328  57.887  28.708  1.00 21.27           C  
ATOM     21  N   ASP A   6      21.775  58.632  31.672  1.00 23.11           N  
ATOM     22  CA  ASP A   6      20.500  58.900  32.317  1.00 25.67           C  
ATOM     23  C   ASP A   6      20.039  60.316  31.989  1.00 23.65           C  
ATOM     24  O   ASP A   6      20.620  61.287  32.468  1.00 23.00           O  
ATOM     25  CB  ASP A   6      20.648  58.732  33.828  1.00 28.68           C  
ATOM     26  CG  ASP A   6      19.408  59.158  34.586  1.00 34.30           C  
ATOM     27  OD1 ASP A   6      18.308  58.652  34.270  1.00 32.97           O  
ATOM     28  OD2 ASP A   6      19.542  59.998  35.502  1.00 37.23           O  
ATOM     29  N   PRO A   7      18.988  60.452  31.164  1.00 22.41           N  
ATOM     30  CA  PRO A   7      18.206  59.395  30.519  1.00 22.68           C  
ATOM     31  C   PRO A   7      18.920  58.834  29.302  1.00 23.79           C  
ATOM     32  O   PRO A   7      19.818  59.470  28.747  1.00 22.54           O  
ATOM     33  CB  PRO A   7      16.915  60.104  30.098  1.00 23.92           C  
ATOM     34  CG  PRO A   7      16.954  61.420  30.787  1.00 26.36           C  
ATOM     35  CD  PRO A   7      18.416  61.757  30.831  1.00 22.41           C  
ATOM     36  N   PRO A   8      18.509  57.638  28.862  1.00 24.13           N  
ATOM     37  CA  PRO A   8      19.053  56.916  27.712  1.00 24.42           C  
ATOM     38  C   PRO A   8      18.506  57.400  26.367  1.00 23.70           C  
ATOM     39  O   PRO A   8      18.954  56.949  25.315  1.00 23.28           O  
ATOM     40  CB  PRO A   8      18.654  55.479  28.006  1.00 24.70           C  
ATOM     41  CG  PRO A   8      17.299  55.664  28.617  1.00 23.72           C  
ATOM     42  CD  PRO A   8      17.546  56.791  29.593  1.00 24.11           C  
ATOM     43  N   ALA A   9      17.527  58.301  26.403  1.00 23.34           N  
ATOM     44  CA  ALA A   9      16.950  58.848  25.175  1.00 22.69           C  
ATOM     45  C   ALA A   9      16.675  60.337  25.338  1.00 22.52           C  
ATOM     46  O   ALA A   9      16.397  60.802  26.439  1.00 23.31           O  
ATOM     47  CB  ALA A   9      15.664  58.114  24.814  1.00 20.99           C  
ATOM     48  N   CYS A  10      16.762  61.078  24.235  1.00 21.94           N  
ATOM     49  CA  CYS A  10      16.529  62.521  24.244  1.00 19.97           C  
ATOM     50  C   CYS A  10      15.290  62.912  23.442  1.00 20.30           C  
ATOM     51  O   CYS A  10      15.061  62.393  22.350  1.00 21.29           O  
ATOM     52  CB  CYS A  10      17.749  63.250  23.667  1.00 20.61           C  
ATOM     53  SG  CYS A  10      17.453  64.995  23.230  1.00 23.59           S  
ATOM     54  N   THR A  11      14.486  63.823  23.986  1.00 20.92           N  
ATOM     55  CA  THR A  11      13.285  64.302  23.291  1.00 21.59           C  
ATOM     56  C   THR A  11      13.214  65.810  23.488  1.00 21.99           C  
ATOM     57  O   THR A  11      13.020  66.288  24.603  1.00 22.80           O  
ATOM     58  CB  THR A  11      11.984  63.674  23.857  1.00 23.00           C  
ATOM     59  OG1 THR A  11      11.834  64.039  25.236  1.00 26.01           O  
ATOM     60  CG2 THR A  11      12.017  62.159  23.729  1.00 23.33           C  
ATOM     61  N   VAL A  12      13.375  66.563  22.408  1.00 23.72           N  
ATOM     62  CA  VAL A  12      13.344  68.016  22.505  1.00 21.69           C  
ATOM     63  C   VAL A  12      12.390  68.658  21.514  1.00 22.07           C  
ATOM     64  O   VAL A  12      12.004  68.049  20.518  1.00 23.42           O  
ATOM     65  CB  VAL A  12      14.732  68.617  22.243  1.00 23.28           C  
ATOM     66  CG1 VAL A  12      15.685  68.268  23.379  1.00 23.83           C  
ATOM     67  CG2 VAL A  12      15.265  68.101  20.907  1.00 22.26           C  
ATOM     68  N   PRO A  13      11.979  69.901  21.788  1.00 22.10           N  
ATOM     69  CA  PRO A  13      11.072  70.566  20.852  1.00 21.41           C  
ATOM     70  C   PRO A  13      11.881  70.876  19.584  1.00 21.96           C  
ATOM     71  O   PRO A  13      13.023  71.330  19.669  1.00 19.38           O  
ATOM     72  CB  PRO A  13      10.668  71.833  21.601  1.00 22.63           C  
ATOM     73  CG  PRO A  13      10.803  71.428  23.074  1.00 22.56           C  
ATOM     74  CD  PRO A  13      12.098  70.658  23.049  1.00 20.62           C  
ATOM     75  N   ALA A  14      11.293  70.610  18.424  1.00 20.15           N  
ATOM     76  CA  ALA A  14      11.956  70.858  17.153  1.00 21.43           C  
ATOM     77  C   ALA A  14      12.311  72.330  16.991  1.00 21.46           C  
ATOM     78  O   ALA A  14      13.307  72.667  16.350  1.00 20.42           O  
ATOM     79  CB  ALA A  14      11.064  70.406  16.003  1.00 21.58           C  
ATOM     80  N   ALA A  15      11.497  73.206  17.576  1.00 20.51           N  
ATOM     81  CA  ALA A  15      11.734  74.645  17.491  1.00 20.75           C  
ATOM     82  C   ALA A  15      12.907  75.115  18.350  1.00 20.59           C  
ATOM     83  O   ALA A  15      13.397  76.230  18.176  1.00 23.57           O  
ATOM     84  CB  ALA A  15      10.468  75.413  17.880  1.00 21.39           C  
ATOM     85  N   GLY A  16      13.359  74.274  19.271  1.00 20.64           N  
ATOM     86  CA  GLY A  16      14.470  74.664  20.120  1.00 19.88           C  
ATOM     87  C   GLY A  16      14.371  74.144  21.537  1.00 20.80           C  
ATOM     88  O   GLY A  16      13.269  73.979  22.071  1.00 19.94           O  
ATOM     89  N   VAL A  17      15.523  73.885  22.151  1.00 20.17           N  
ATOM     90  CA  VAL A  17      15.522  73.388  23.511  1.00 20.21           C  
ATOM     91  C   VAL A  17      16.875  72.932  24.017  1.00 20.91           C  
ATOM     92  O   VAL A  17      17.911  73.158  23.382  1.00 17.90           O  
ATOM     93  N   SER A  18      16.856  72.280  25.174  1.00 17.82           N  
ATOM     94  CA  SER A  18      18.071  71.784  25.804  1.00 16.61           C  
ATOM     95  C   SER A  18      17.748  70.509  26.582  1.00 18.22           C  
ATOM     96  O   SER A  18      16.657  70.378  27.163  1.00 18.16           O  
ATOM     97  CB  SER A  18      18.642  72.858  26.736  1.00 15.76           C  
ATOM     98  OG  SER A  18      19.755  72.377  27.468  1.00 17.87           O  
ATOM     99  N   SER A  19      18.695  69.572  26.587  1.00 17.36           N  
ATOM    100  CA  SER A  19      18.524  68.299  27.280  1.00 19.10           C  
ATOM    101  C   SER A  19      19.841  67.876  27.927  1.00 19.83           C  
ATOM    102  O   SER A  19      20.897  67.897  27.286  1.00 18.47           O  
ATOM    103  CB  SER A  19      18.051  67.227  26.285  1.00 19.81           C  
ATOM    104  OG  SER A  19      17.823  65.978  26.917  1.00 21.50           O  
ATOM    105  N   THR A  20      19.774  67.503  29.202  1.00 19.15           N  
ATOM    106  CA  THR A  20      20.957  67.091  29.951  1.00 19.11           C  
ATOM    107  C   THR A  20      20.953  65.604  30.264  1.00 20.85           C  
ATOM    108  O   THR A  20      19.999  65.069  30.834  1.00 20.31           O  
ATOM    109  CB  THR A  20      21.066  67.851  31.278  1.00 18.64           C  
ATOM    110  OG1 THR A  20      21.034  69.257  31.022  1.00 21.77           O  
ATOM    111  CG2 THR A  20      22.361  67.489  31.997  1.00 20.21           C  
ATOM    112  N   HIS A  21      22.041  64.938  29.903  1.00 19.79           N  
ATOM    113  CA  HIS A  21      22.166  63.512  30.136  1.00 21.07           C  
ATOM    114  C   HIS A  21      23.405  63.238  30.975  1.00 22.19           C  
ATOM    115  O   HIS A  21      24.486  63.760  30.696  1.00 22.70           O  
ATOM    116  CB  HIS A  21      22.228  62.797  28.786  1.00 19.98           C  
ATOM    117  CG  HIS A  21      21.030  63.063  27.929  1.00 19.73           C  
ATOM    118  ND1 HIS A  21      19.993  62.165  27.798  1.00 18.80           N  
ATOM    119  CD2 HIS A  21      20.656  64.169  27.244  1.00 19.36           C  
ATOM    120  CE1 HIS A  21      19.031  62.708  27.073  1.00 20.60           C  
ATOM    121  NE2 HIS A  21      19.408  63.925  26.726  1.00 20.74           N  
ATOM    122  N   LYS A  22      23.237  62.432  32.019  1.00 23.69           N  
ATOM    123  CA  LYS A  22      24.346  62.103  32.907  1.00 26.71           C  
ATOM    124  C   LYS A  22      25.001  60.782  32.531  1.00 26.87           C  
ATOM    125  O   LYS A  22      24.384  59.722  32.662  1.00 26.06           O  
ATOM    126  CB  LYS A  22      23.866  62.011  34.363  1.00 30.00           C  
ATOM    127  CG  LYS A  22      23.164  63.247  34.895  1.00 36.73           C  
ATOM    128  CD  LYS A  22      22.625  63.003  36.310  1.00 40.92           C  
ATOM    129  CE  LYS A  22      21.774  64.173  36.804  1.00 43.25           C  
ATOM    130  NZ  LYS A  22      21.192  63.921  38.164  1.00 44.71           N  
ATOM    131  N   LEU A  23      26.245  60.844  32.056  1.00 24.97           N  
ATOM    132  CA  LEU A  23      26.969  59.626  31.711  1.00 24.63           C  
ATOM    133  C   LEU A  23      27.426  59.017  33.034  1.00 24.90           C  
ATOM    134  O   LEU A  23      28.050  59.692  33.858  1.00 24.48           O  
ATOM    135  CB  LEU A  23      28.182  59.940  30.830  1.00 26.64           C  
ATOM    136  CG  LEU A  23      27.887  60.485  29.428  1.00 27.56           C  
ATOM    137  CD1 LEU A  23      29.186  60.605  28.644  1.00 27.29           C  
ATOM    138  CD2 LEU A  23      26.923  59.554  28.707  1.00 27.69           C  
ATOM    139  N   VAL A  24      27.098  57.749  33.248  1.00 22.75           N  
ATOM    140  CA  VAL A  24      27.472  57.086  34.485  1.00 21.56           C  
ATOM    141  C   VAL A  24      28.406  55.918  34.249  1.00 19.93           C  
ATOM    142  O   VAL A  24      28.113  55.027  33.447  1.00 19.12           O  
ATOM    143  CB  VAL A  24      26.231  56.572  35.236  1.00 23.18           C  
ATOM    144  CG1 VAL A  24      26.655  55.862  36.521  1.00 23.33           C  
ATOM    145  CG2 VAL A  24      25.303  57.734  35.547  1.00 24.38           C  
ATOM    146  N   ASN A  25      29.533  55.933  34.950  1.00 18.44           N  
ATOM    147  CA  ASN A  25      30.517  54.868  34.839  1.00 20.70           C  
ATOM    148  C   ASN A  25      30.500  54.032  36.112  1.00 19.66           C  
ATOM    149  O   ASN A  25      30.996  54.458  37.160  1.00 18.39           O  
ATOM    150  CB  ASN A  25      31.919  55.450  34.616  1.00 17.55           C  
ATOM    151  CG  ASN A  25      32.999  54.380  34.591  1.00 20.05           C  
ATOM    152  OD1 ASN A  25      32.707  53.182  34.586  1.00 19.69           O  
ATOM    153  ND2 ASN A  25      34.264  54.811  34.559  1.00 20.20           N  
ATOM    154  N   GLY A  26      29.925  52.838  36.010  1.00 20.44           N  
ATOM    155  CA  GLY A  26      29.851  51.951  37.155  1.00 22.67           C  
ATOM    156  C   GLY A  26      30.997  50.960  37.191  1.00 23.92           C  
ATOM    157  O   GLY A  26      31.026  50.072  38.050  1.00 21.30           O  
ATOM    158  N   GLY A  27      31.941  51.118  36.260  1.00 23.35           N  
ATOM    159  CA  GLY A  27      33.091  50.234  36.182  1.00 22.09           C  
ATOM    160  C   GLY A  27      34.166  50.602  37.182  1.00 23.52           C  
ATOM    161  O   GLY A  27      34.007  51.564  37.931  1.00 25.22           O  
ATOM    162  N   ALA A  28      35.271  49.855  37.179  1.00 22.73           N  
ATOM    163  CA  ALA A  28      36.364  50.085  38.120  1.00 22.42           C  
ATOM    164  C   ALA A  28      37.565  50.823  37.546  1.00 23.45           C  
ATOM    165  O   ALA A  28      38.631  50.846  38.162  1.00 23.56           O  
ATOM    166  CB  ALA A  28      36.814  48.760  38.713  1.00 23.66           C  
ATOM    167  N   GLU A  29      37.398  51.415  36.367  1.00 23.08           N  
ATOM    168  CA  GLU A  29      38.478  52.178  35.742  1.00 24.94           C  
ATOM    169  C   GLU A  29      37.905  53.440  35.106  1.00 24.57           C  
ATOM    170  O   GLU A  29      36.732  53.490  34.752  1.00 22.87           O  
ATOM    171  CB  GLU A  29      39.214  51.335  34.682  1.00 25.03           C  
ATOM    172  CG  GLU A  29      38.395  50.976  33.441  1.00 28.91           C  
ATOM    173  CD  GLU A  29      39.209  50.202  32.404  1.00 32.44           C  
ATOM    174  OE1 GLU A  29      40.346  50.620  32.103  1.00 30.85           O  
ATOM    175  OE2 GLU A  29      38.709  49.182  31.884  1.00 34.60           O  
ATOM    176  N   LYS A  30      38.734  54.470  34.986  1.00 25.56           N  
ATOM    177  CA  LYS A  30      38.299  55.721  34.383  1.00 25.59           C  
ATOM    178  C   LYS A  30      38.043  55.469  32.906  1.00 27.45           C  
ATOM    179  O   LYS A  30      38.721  54.658  32.280  1.00 26.76           O  
ATOM    180  CB  LYS A  30      39.387  56.786  34.539  1.00 26.12           C  
ATOM    181  CG  LYS A  30      39.027  58.161  33.987  1.00 27.91           C  
ATOM    182  CD  LYS A  30      40.200  59.144  34.128  1.00 31.69           C  
ATOM    183  CE  LYS A  30      40.631  59.298  35.585  1.00 34.04           C  
ATOM    184  NZ  LYS A  30      41.877  60.107  35.731  1.00 34.70           N  
ATOM    185  N   ILE A  31      37.052  56.150  32.347  1.00 27.79           N  
ATOM    186  CA  ILE A  31      36.768  55.991  30.929  1.00 29.13           C  
ATOM    187  C   ILE A  31      36.929  57.326  30.215  1.00 27.49           C  
ATOM    188  O   ILE A  31      36.727  58.389  30.803  1.00 27.07           O  
ATOM    189  CB  ILE A  31      35.334  55.466  30.681  1.00 30.66           C  
ATOM    190  CG1 ILE A  31      34.316  56.431  31.284  1.00 34.34           C  
ATOM    191  CG2 ILE A  31      35.184  54.064  31.264  1.00 32.27           C  
ATOM    192  CD1 ILE A  31      32.877  55.948  31.209  1.00 38.50           C  
ATOM    193  N   VAL A  32      37.329  57.254  28.951  1.00 26.88           N  
ATOM    194  CA  VAL A  32      37.488  58.431  28.115  1.00 24.68           C  
ATOM    195  C   VAL A  32      36.382  58.279  27.071  1.00 24.22           C  
ATOM    196  O   VAL A  32      36.073  57.158  26.664  1.00 23.45           O  
ATOM    197  CB  VAL A  32      38.878  58.446  27.414  1.00 25.31           C  
ATOM    198  CG1 VAL A  32      38.996  57.276  26.455  1.00 25.19           C  
ATOM    199  CG2 VAL A  32      39.083  59.756  26.679  1.00 26.49           C  
ATOM    200  N   PHE A  33      35.776  59.386  26.650  1.00 22.91           N  
ATOM    201  CA  PHE A  33      34.711  59.315  25.656  1.00 23.11           C  
ATOM    202  C   PHE A  33      34.786  60.455  24.642  1.00 23.29           C  
ATOM    203  O   PHE A  33      35.379  61.501  24.913  1.00 20.20           O  
ATOM    204  CB  PHE A  33      33.342  59.336  26.351  1.00 20.80           C  
ATOM    205  CG  PHE A  33      33.000  60.655  26.991  1.00 20.33           C  
ATOM    206  CD1 PHE A  33      32.529  61.721  26.224  1.00 22.64           C  
ATOM    207  CD2 PHE A  33      33.153  60.838  28.359  1.00 21.05           C  
ATOM    208  CE1 PHE A  33      32.214  62.947  26.812  1.00 22.51           C  
ATOM    209  CE2 PHE A  33      32.840  62.065  28.960  1.00 21.29           C  
ATOM    210  CZ  PHE A  33      32.371  63.119  28.184  1.00 20.34           C  
ATOM    211  N   LYS A  34      34.188  60.225  23.475  1.00 24.07           N  
ATOM    212  CA  LYS A  34      34.115  61.204  22.394  1.00 24.16           C  
ATOM    213  C   LYS A  34      32.707  61.108  21.813  1.00 25.62           C  
ATOM    214  O   LYS A  34      32.227  60.017  21.509  1.00 25.24           O  
ATOM    215  CB  LYS A  34      35.128  60.902  21.290  1.00 26.45           C  
ATOM    216  CG  LYS A  34      35.032  61.894  20.140  1.00 29.73           C  
ATOM    217  CD  LYS A  34      35.956  61.542  18.977  1.00 34.31           C  
ATOM    218  CE  LYS A  34      35.991  62.683  17.968  1.00 36.86           C  
ATOM    219  NZ  LYS A  34      34.624  63.106  17.528  1.00 38.09           N  
ATOM    220  N   ILE A  35      32.055  62.246  21.629  1.00 23.72           N  
ATOM    221  CA  ILE A  35      30.692  62.227  21.126  1.00 25.62           C  
ATOM    222  C   ILE A  35      30.514  62.788  19.726  1.00 24.34           C  
ATOM    223  O   ILE A  35      31.031  63.847  19.401  1.00 23.17           O  
ATOM    224  CB  ILE A  35      29.760  62.994  22.084  1.00 23.80           C  
ATOM    225  CG1 ILE A  35      29.935  62.450  23.502  1.00 23.97           C  
ATOM    226  CG2 ILE A  35      28.319  62.861  21.626  1.00 26.26           C  
ATOM    227  CD1 ILE A  35      29.028  63.081  24.536  1.00 25.47           C  
ATOM    228  N   LYS A  36      29.772  62.056  18.905  1.00 25.79           N  
ATOM    229  CA  LYS A  36      29.481  62.478  17.543  1.00 27.59           C  
ATOM    230  C   LYS A  36      27.966  62.472  17.345  1.00 27.23           C  
ATOM    231  O   LYS A  36      27.284  61.533  17.746  1.00 27.06           O  
ATOM    232  CB  LYS A  36      30.145  61.545  16.529  1.00 29.54           C  
ATOM    233  CG  LYS A  36      31.551  61.971  16.117  1.00 35.41           C  
ATOM    234  CD  LYS A  36      31.931  61.366  14.765  1.00 39.40           C  
ATOM    235  CE  LYS A  36      33.220  61.973  14.216  1.00 42.80           C  
ATOM    236  NZ  LYS A  36      33.527  61.495  12.832  1.00 43.43           N  
ATOM    237  N   SER A  37      27.453  63.536  16.739  1.00 25.86           N  
ATOM    238  CA  SER A  37      26.026  63.683  16.478  1.00 25.07           C  
ATOM    239  C   SER A  37      25.719  63.430  15.006  1.00 26.38           C  
ATOM    240  O   SER A  37      26.490  63.821  14.132  1.00 24.69           O  
ATOM    241  CB  SER A  37      25.569  65.101  16.849  1.00 24.55           C  
ATOM    242  OG  SER A  37      24.263  65.368  16.357  1.00 19.60           O  
ATOM    243  N   SER A  38      24.592  62.780  14.733  1.00 23.61           N  
ATOM    244  CA  SER A  38      24.198  62.507  13.356  1.00 24.05           C  
ATOM    245  C   SER A  38      23.682  63.792  12.715  1.00 23.22           C  
ATOM    246  O   SER A  38      23.438  63.834  11.519  1.00 24.03           O  
ATOM    247  CB  SER A  38      23.086  61.454  13.312  1.00 24.44           C  
ATOM    248  OG  SER A  38      21.884  61.965  13.880  1.00 25.43           O  
ATOM    249  N   ASN A  39      23.511  64.834  13.521  1.00 23.55           N  
ATOM    250  CA  ASN A  39      22.996  66.117  13.035  1.00 25.79           C  
ATOM    251  C   ASN A  39      23.762  67.269  13.691  1.00 25.64           C  
ATOM    252  O   ASN A  39      23.534  67.587  14.860  1.00 24.48           O  
ATOM    253  CB  ASN A  39      21.496  66.238  13.373  1.00 23.47           C  
ATOM    254  CG  ASN A  39      20.872  67.537  12.865  1.00 25.06           C  
ATOM    255  OD1 ASN A  39      21.558  68.538  12.648  1.00 23.96           O  
ATOM    256  ND2 ASN A  39      19.558  67.525  12.691  1.00 25.40           N  
ATOM    257  N   ASN A  40      24.665  67.886  12.938  1.00 26.26           N  
ATOM    258  CA  ASN A  40      25.454  69.001  13.444  1.00 25.69           C  
ATOM    259  C   ASN A  40      24.879  70.337  12.988  1.00 27.51           C  
ATOM    260  O   ASN A  40      25.508  71.387  13.145  1.00 27.44           O  
ATOM    261  CB  ASN A  40      26.905  68.867  12.982  1.00 27.33           C  
ATOM    262  CG  ASN A  40      27.602  67.682  13.615  1.00 27.49           C  
ATOM    263  OD1 ASN A  40      27.694  67.588  14.836  1.00 28.47           O  
ATOM    264  ND2 ASN A  40      28.095  66.768  12.788  1.00 28.55           N  
ATOM    265  N   ASN A  41      23.678  70.288  12.419  1.00 27.19           N  
ATOM    266  CA  ASN A  41      22.991  71.486  11.949  1.00 26.03           C  
ATOM    267  C   ASN A  41      22.137  72.115  13.058  1.00 25.90           C  
ATOM    268  O   ASN A  41      22.301  73.289  13.386  1.00 25.07           O  
ATOM    269  CB  ASN A  41      22.097  71.148  10.752  1.00 25.72           C  
ATOM    270  CG  ASN A  41      22.890  70.835   9.501  1.00 29.12           C  
ATOM    271  OD1 ASN A  41      23.821  71.566   9.144  1.00 26.82           O  
ATOM    272  ND2 ASN A  41      22.522  69.752   8.816  1.00 26.90           N  
ATOM    273  N   GLU A  42      21.228  71.330  13.631  1.00 25.36           N  
ATOM    274  CA  GLU A  42      20.351  71.824  14.688  1.00 25.08           C  
ATOM    275  C   GLU A  42      20.764  71.394  16.098  1.00 25.35           C  
ATOM    276  O   GLU A  42      19.997  71.567  17.045  1.00 25.07           O  
ATOM    277  CB  GLU A  42      18.907  71.365  14.444  1.00 26.43           C  
ATOM    278  CG  GLU A  42      18.220  71.957  13.218  1.00 27.32           C  
ATOM    279  CD  GLU A  42      18.466  71.160  11.947  1.00 28.57           C  
ATOM    280  OE1 GLU A  42      18.398  69.912  11.998  1.00 24.79           O  
ATOM    281  OE2 GLU A  42      18.713  71.784  10.893  1.00 32.18           O  
ATOM    282  N   TYR A  43      21.960  70.835  16.241  1.00 23.96           N  
ATOM    283  CA  TYR A  43      22.436  70.388  17.549  1.00 22.85           C  
ATOM    284  C   TYR A  43      23.858  70.825  17.895  1.00 25.01           C  
ATOM    285  O   TYR A  43      24.755  70.860  17.039  1.00 22.15           O  
ATOM    286  CB  TYR A  43      22.393  68.861  17.645  1.00 21.51           C  
ATOM    287  CG  TYR A  43      21.016  68.258  17.745  1.00 19.16           C  
ATOM    288  CD1 TYR A  43      20.327  68.231  18.958  1.00 18.29           C  
ATOM    289  CD2 TYR A  43      20.412  67.677  16.630  1.00 17.41           C  
ATOM    290  CE1 TYR A  43      19.068  67.628  19.059  1.00 16.68           C  
ATOM    291  CE2 TYR A  43      19.159  67.078  16.722  1.00 17.55           C  
ATOM    292  CZ  TYR A  43      18.496  67.056  17.939  1.00 17.10           C  
ATOM    293  OH  TYR A  43      17.270  66.444  18.021  1.00 19.87           O  
ATOM    294  N   ARG A  44      24.048  71.135  19.171  1.00 24.04           N  
ATOM    295  CA  ARG A  44      25.343  71.515  19.712  1.00 25.41           C  
ATOM    296  C   ARG A  44      25.504  70.660  20.965  1.00 25.17           C  
ATOM    297  O   ARG A  44      24.605  70.610  21.815  1.00 24.45           O  
ATOM    298  CB  ARG A  44      25.368  73.005  20.062  1.00 27.59           C  
ATOM    299  CG  ARG A  44      25.372  73.922  18.838  1.00 30.80           C  
ATOM    300  CD  ARG A  44      26.658  73.767  18.036  1.00 34.62           C  
ATOM    301  NE  ARG A  44      26.704  74.668  16.883  1.00 38.35           N  
ATOM    302  CZ  ARG A  44      26.022  74.486  15.756  1.00 39.45           C  
ATOM    303  NH1 ARG A  44      26.124  75.366  14.766  1.00 39.57           N  
ATOM    304  NH2 ARG A  44      25.250  73.418  15.608  1.00 39.45           N  
ATOM    305  N   ILE A  45      26.638  69.977  21.075  1.00 23.25           N  
ATOM    306  CA  ILE A  45      26.881  69.110  22.219  1.00 25.03           C  
ATOM    307  C   ILE A  45      28.028  69.614  23.086  1.00 25.55           C  
ATOM    308  O   ILE A  45      29.095  69.986  22.585  1.00 24.43           O  
ATOM    309  CB  ILE A  45      27.179  67.661  21.758  1.00 28.02           C  
ATOM    310  CG1 ILE A  45      27.309  66.747  22.972  1.00 27.97           C  
ATOM    311  CG2 ILE A  45      28.444  67.618  20.920  1.00 31.29           C  
ATOM    312  CD1 ILE A  45      26.011  66.587  23.727  1.00 35.02           C  
ATOM    313  N   ALA A  46      27.797  69.626  24.395  1.00 21.82           N  
ATOM    314  CA  ALA A  46      28.796  70.086  25.348  1.00 21.77           C  
ATOM    315  C   ALA A  46      28.875  69.162  26.558  1.00 21.96           C  
ATOM    316  O   ALA A  46      27.919  69.049  27.325  1.00 24.12           O  
ATOM    317  CB  ALA A  46      28.457  71.503  25.800  1.00 20.47           C  
ATOM    318  N   PRO A  47      30.022  68.493  26.752  1.00 23.78           N  
ATOM    319  CA  PRO A  47      31.232  68.548  25.917  1.00 22.93           C  
ATOM    320  C   PRO A  47      31.281  67.421  24.878  1.00 24.48           C  
ATOM    321  O   PRO A  47      30.489  66.481  24.929  1.00 24.72           O  
ATOM    322  CB  PRO A  47      32.344  68.411  26.941  1.00 24.05           C  
ATOM    323  CG  PRO A  47      31.755  67.380  27.880  1.00 23.35           C  
ATOM    324  CD  PRO A  47      30.320  67.869  28.056  1.00 20.78           C  
ATOM    325  N   VAL A  48      32.215  67.518  23.938  1.00 24.58           N  
ATOM    326  CA  VAL A  48      32.363  66.496  22.909  1.00 26.37           C  
ATOM    327  C   VAL A  48      33.375  65.451  23.380  1.00 26.24           C  
ATOM    328  O   VAL A  48      33.295  64.281  23.003  1.00 26.76           O  
ATOM    329  CB  VAL A  48      32.828  67.116  21.560  1.00 25.34           C  
ATOM    330  CG1 VAL A  48      34.082  67.925  21.766  1.00 29.16           C  
ATOM    331  CG2 VAL A  48      33.078  66.018  20.535  1.00 29.36           C  
ATOM    332  N   PHE A  49      34.328  65.881  24.202  1.00 25.94           N  
ATOM    333  CA  PHE A  49      35.344  64.981  24.756  1.00 26.58           C  
ATOM    334  C   PHE A  49      35.305  65.066  26.274  1.00 25.42           C  
ATOM    335  O   PHE A  49      34.937  66.100  26.833  1.00 24.90           O  
ATOM    336  CB  PHE A  49      36.756  65.371  24.315  1.00 27.55           C  
ATOM    337  CG  PHE A  49      37.050  65.107  22.871  1.00 27.42           C  
ATOM    338  CD1 PHE A  49      36.771  66.064  21.902  1.00 28.55           C  
ATOM    339  CD2 PHE A  49      37.631  63.906  22.480  1.00 28.15           C  
ATOM    340  CE1 PHE A  49      37.074  65.829  20.558  1.00 27.31           C  
ATOM    341  CE2 PHE A  49      37.937  63.658  21.139  1.00 27.23           C  
ATOM    342  CZ  PHE A  49      37.658  64.624  20.179  1.00 27.01           C  
ATOM    343  N   GLY A  50      35.702  63.990  26.943  1.00 24.34           N  
ATOM    344  CA  GLY A  50      35.712  64.019  28.392  1.00 25.65           C  
ATOM    345  C   GLY A  50      36.071  62.708  29.057  1.00 25.38           C  
ATOM    346  O   GLY A  50      36.351  61.714  28.393  1.00 23.83           O  
ATOM    347  N   PHE A  51      36.057  62.725  30.386  1.00 26.00           N  
ATOM    348  CA  PHE A  51      36.364  61.554  31.197  1.00 26.56           C  
ATOM    349  C   PHE A  51      35.184  61.266  32.119  1.00 25.35           C  
ATOM    350  O   PHE A  51      34.370  62.146  32.390  1.00 24.98           O  
ATOM    351  CB  PHE A  51      37.574  61.822  32.102  1.00 27.74           C  
ATOM    352  CG  PHE A  51      38.858  62.077  31.366  1.00 31.73           C  
ATOM    353  CD1 PHE A  51      39.484  61.060  30.653  1.00 32.52           C  
ATOM    354  CD2 PHE A  51      39.473  63.324  31.436  1.00 31.76           C  
ATOM    355  CE1 PHE A  51      40.707  61.278  30.023  1.00 34.36           C  
ATOM    356  CE2 PHE A  51      40.700  63.554  30.809  1.00 33.64           C  
ATOM    357  CZ  PHE A  51      41.317  62.529  30.103  1.00 34.02           C  
ATOM    358  N   VAL A  52      35.090  60.028  32.587  1.00 23.95           N  
ATOM    359  CA  VAL A  52      34.064  59.657  33.555  1.00 23.04           C  
ATOM    360  C   VAL A  52      34.807  58.751  34.532  1.00 24.18           C  
ATOM    361  O   VAL A  52      35.263  57.671  34.164  1.00 24.97           O  
ATOM    362  CB  VAL A  52      32.879  58.887  32.937  1.00 22.18           C  
ATOM    363  CG1 VAL A  52      31.750  58.809  33.956  1.00 24.49           C  
ATOM    364  CG2 VAL A  52      32.390  59.565  31.663  1.00 22.53           C  
ATOM    365  N   ASP A  53      34.955  59.212  35.769  1.00 23.79           N  
ATOM    366  CA  ASP A  53      35.664  58.458  36.792  1.00 25.17           C  
ATOM    367  C   ASP A  53      34.921  57.206  37.241  1.00 25.50           C  
ATOM    368  O   ASP A  53      33.715  57.085  37.046  1.00 24.73           O  
ATOM    369  CB  ASP A  53      35.916  59.348  38.014  1.00 27.06           C  
ATOM    370  CG  ASP A  53      36.743  60.568  37.687  1.00 28.34           C  
ATOM    371  OD1 ASP A  53      37.781  60.415  37.011  1.00 30.22           O  
ATOM    372  OD2 ASP A  53      36.360  61.676  38.114  1.00 30.45           O  
ATOM    373  N   PRO A  54      35.643  56.246  37.837  1.00 26.26           N  
ATOM    374  CA  PRO A  54      35.002  55.017  38.310  1.00 25.98           C  
ATOM    375  C   PRO A  54      33.912  55.433  39.300  1.00 25.71           C  
ATOM    376  O   PRO A  54      34.163  56.251  40.187  1.00 25.39           O  
ATOM    377  CB  PRO A  54      36.146  54.274  38.998  1.00 25.86           C  
ATOM    378  CG  PRO A  54      37.347  54.730  38.240  1.00 27.43           C  
ATOM    379  CD  PRO A  54      37.099  56.202  38.058  1.00 26.58           C  
ATOM    380  N   SER A  55      32.715  54.879  39.142  1.00 26.25           N  
ATOM    381  CA  SER A  55      31.568  55.212  39.995  1.00 27.37           C  
ATOM    382  C   SER A  55      31.295  56.718  39.982  1.00 26.06           C  
ATOM    383  O   SER A  55      30.696  57.270  40.906  1.00 26.42           O  
ATOM    384  CB  SER A  55      31.789  54.731  41.436  1.00 28.36           C  
ATOM    385  OG  SER A  55      32.766  55.503  42.106  1.00 35.45           O  
ATOM    386  N   GLY A  56      31.735  57.376  38.917  1.00 23.75           N  
ATOM    387  CA  GLY A  56      31.530  58.802  38.797  1.00 22.95           C  
ATOM    388  C   GLY A  56      30.603  59.115  37.642  1.00 21.04           C  
ATOM    389  O   GLY A  56      30.160  58.212  36.931  1.00 21.97           O  
ATOM    390  N   SER A  57      30.321  60.395  37.438  1.00 21.33           N  
ATOM    391  CA  SER A  57      29.429  60.800  36.359  1.00 22.88           C  
ATOM    392  C   SER A  57      29.884  62.065  35.651  1.00 23.06           C  
ATOM    393  O   SER A  57      30.647  62.863  36.196  1.00 24.76           O  
ATOM    394  CB  SER A  57      28.012  61.002  36.910  1.00 23.02           C  
ATOM    395  OG  SER A  57      28.030  61.910  37.998  1.00 22.46           O  
ATOM    396  N   LYS A  58      29.403  62.241  34.428  1.00 23.45           N  
ATOM    397  CA  LYS A  58      29.739  63.414  33.633  1.00 24.65           C  
ATOM    398  C   LYS A  58      28.493  63.893  32.910  1.00 24.08           C  
ATOM    399  O   LYS A  58      27.845  63.125  32.202  1.00 22.51           O  
ATOM    400  CB  LYS A  58      30.815  63.070  32.604  1.00 26.64           C  
ATOM    401  CG  LYS A  58      31.171  64.205  31.654  1.00 30.40           C  
ATOM    402  CD  LYS A  58      31.933  65.323  32.350  1.00 32.60           C  
ATOM    403  CE  LYS A  58      32.447  66.339  31.336  1.00 34.91           C  
ATOM    404  NZ  LYS A  58      33.260  67.425  31.965  1.00 36.09           N  
ATOM    405  N   ASP A  59      28.154  65.162  33.096  1.00 24.28           N  
ATOM    406  CA  ASP A  59      26.989  65.733  32.440  1.00 25.56           C  
ATOM    407  C   ASP A  59      27.300  66.136  31.015  1.00 24.99           C  
ATOM    408  O   ASP A  59      28.332  66.740  30.746  1.00 25.98           O  
ATOM    409  CB  ASP A  59      26.484  66.962  33.196  1.00 26.29           C  
ATOM    410  CG  ASP A  59      25.571  66.598  34.340  1.00 28.07           C  
ATOM    411  OD1 ASP A  59      25.316  65.390  34.529  1.00 28.24           O  
ATOM    412  OD2 ASP A  59      25.109  67.517  35.043  1.00 27.58           O  
ATOM    413  N   VAL A  60      26.393  65.790  30.110  1.00 24.51           N  
ATOM    414  CA  VAL A  60      26.529  66.125  28.705  1.00 26.79           C  
ATOM    415  C   VAL A  60      25.258  66.876  28.309  1.00 25.73           C  
ATOM    416  O   VAL A  60      24.151  66.340  28.391  1.00 27.02           O  
ATOM    417  CB  VAL A  60      26.699  64.845  27.845  1.00 28.54           C  
ATOM    418  CG1 VAL A  60      25.534  63.897  28.081  1.00 31.66           C  
ATOM    419  CG2 VAL A  60      26.788  65.208  26.384  1.00 26.98           C  
ATOM    420  N   VAL A  61      25.417  68.133  27.911  1.00 23.48           N  
ATOM    421  CA  VAL A  61      24.276  68.948  27.531  1.00 20.64           C  
ATOM    422  C   VAL A  61      24.069  68.988  26.027  1.00 21.87           C  
ATOM    423  O   VAL A  61      24.998  69.286  25.262  1.00 19.54           O  
ATOM    424  CB  VAL A  61      24.427  70.403  28.031  1.00 20.07           C  
ATOM    425  CG1 VAL A  61      23.231  71.238  27.587  1.00 20.45           C  
ATOM    426  CG2 VAL A  61      24.545  70.422  29.545  1.00 21.44           C  
ATOM    427  N   ILE A  62      22.841  68.682  25.625  1.00 19.00           N  
ATOM    428  CA  ILE A  62      22.436  68.690  24.230  1.00 20.36           C  
ATOM    429  C   ILE A  62      21.616  69.954  24.022  1.00 20.14           C  
ATOM    430  O   ILE A  62      20.548  70.116  24.630  1.00 20.09           O  
ATOM    431  CB  ILE A  62      21.525  67.481  23.891  1.00 21.52           C  
ATOM    432  CG1 ILE A  62      22.264  66.167  24.122  1.00 21.01           C  
ATOM    433  CG2 ILE A  62      21.071  67.554  22.440  1.00 22.52           C  
ATOM    434  CD1 ILE A  62      21.355  64.948  24.002  1.00 22.80           C  
ATOM    435  N   THR A  63      22.122  70.860  23.192  1.00 17.05           N  
ATOM    436  CA  THR A  63      21.403  72.088  22.887  1.00 17.14           C  
ATOM    437  C   THR A  63      20.835  71.956  21.482  1.00 18.48           C  
ATOM    438  O   THR A  63      21.567  71.628  20.534  1.00 16.19           O  
ATOM    439  CB  THR A  63      22.321  73.333  22.931  1.00 17.25           C  
ATOM    440  OG1 THR A  63      22.972  73.409  24.203  1.00 20.40           O  
ATOM    441  CG2 THR A  63      21.502  74.602  22.727  1.00 17.61           C  
ATOM    442  N   ARG A  64      19.532  72.209  21.349  1.00 17.81           N  
ATOM    443  CA  ARG A  64      18.844  72.122  20.056  1.00 19.24           C  
ATOM    444  C   ARG A  64      18.342  73.471  19.544  1.00 20.21           C  
ATOM    445  O   ARG A  64      17.693  74.218  20.282  1.00 21.33           O  
ATOM    446  CB  ARG A  64      17.649  71.166  20.168  1.00 19.59           C  
ATOM    447  CG  ARG A  64      16.555  71.370  19.115  1.00 20.13           C  
ATOM    448  CD  ARG A  64      16.799  70.548  17.861  1.00 20.97           C  
ATOM    449  NE  ARG A  64      15.829  70.852  16.814  1.00 18.97           N  
ATOM    450  CZ  ARG A  64      15.648  70.120  15.718  1.00 18.82           C  
ATOM    451  NH1 ARG A  64      16.376  69.024  15.522  1.00 17.52           N  
ATOM    452  NH2 ARG A  64      14.740  70.488  14.817  1.00 16.11           N  
ATOM    453  N   THR A  65      18.633  73.778  18.277  1.00 20.35           N  
ATOM    454  CA  THR A  65      18.159  75.014  17.673  1.00 18.57           C  
ATOM    455  C   THR A  65      17.016  74.674  16.727  1.00 21.05           C  
ATOM    456  O   THR A  65      16.753  73.502  16.458  1.00 22.05           O  
ATOM    457  CB  THR A  65      19.273  75.786  16.910  1.00 21.33           C  
ATOM    458  OG1 THR A  65      19.915  74.924  15.961  1.00 20.99           O  
ATOM    459  CG2 THR A  65      20.295  76.347  17.897  1.00 21.50           C  
ATOM    460  N   ALA A  66      16.336  75.701  16.233  1.00 21.92           N  
ATOM    461  CA  ALA A  66      15.177  75.526  15.366  1.00 22.13           C  
ATOM    462  C   ALA A  66      15.427  74.806  14.050  1.00 23.67           C  
ATOM    463  O   ALA A  66      16.355  75.130  13.309  1.00 22.78           O  
ATOM    464  CB  ALA A  66      14.523  76.881  15.103  1.00 20.52           C  
ATOM    465  N   GLY A  67      14.567  73.830  13.774  1.00 23.49           N  
ATOM    466  CA  GLY A  67      14.656  73.050  12.553  1.00 23.33           C  
ATOM    467  C   GLY A  67      13.444  72.145  12.417  1.00 22.44           C  
ATOM    468  O   GLY A  67      12.547  72.170  13.254  1.00 21.63           O  
ATOM    469  N   ALA A  68      13.426  71.330  11.368  1.00 22.15           N  
ATOM    470  CA  ALA A  68      12.321  70.423  11.127  1.00 21.67           C  
ATOM    471  C   ALA A  68      12.342  69.247  12.087  1.00 22.92           C  
ATOM    472  O   ALA A  68      13.407  68.758  12.464  1.00 23.57           O  
ATOM    473  CB  ALA A  68      12.375  69.915   9.694  1.00 23.18           C  
ATOM    474  N   PRO A  69      11.159  68.801  12.535  1.00 23.86           N  
ATOM    475  CA  PRO A  69      11.177  67.659  13.447  1.00 23.48           C  
ATOM    476  C   PRO A  69      11.877  66.521  12.726  1.00 24.63           C  
ATOM    477  O   PRO A  69      11.745  66.370  11.504  1.00 24.64           O  
ATOM    478  CB  PRO A  69       9.692  67.385  13.717  1.00 25.01           C  
ATOM    479  CG  PRO A  69       8.950  68.219  12.715  1.00 24.47           C  
ATOM    480  CD  PRO A  69       9.821  69.403  12.463  1.00 22.84           C  
ATOM    481  N   LYS A  70      12.639  65.734  13.472  1.00 23.55           N  
ATOM    482  CA  LYS A  70      13.384  64.644  12.871  1.00 23.77           C  
ATOM    483  C   LYS A  70      13.995  63.766  13.945  1.00 22.26           C  
ATOM    484  O   LYS A  70      14.169  64.189  15.091  1.00 21.18           O  
ATOM    485  CB  LYS A  70      14.496  65.221  11.984  1.00 23.89           C  
ATOM    486  CG  LYS A  70      15.383  64.192  11.305  1.00 25.74           C  
ATOM    487  CD  LYS A  70      16.432  64.871  10.433  1.00 28.26           C  
ATOM    488  CE  LYS A  70      17.288  63.846   9.711  1.00 30.64           C  
ATOM    489  NZ  LYS A  70      18.151  64.471   8.672  1.00 33.08           N  
ATOM    490  N   GLU A  71      14.308  62.535  13.566  1.00 21.59           N  
ATOM    491  CA  GLU A  71      14.924  61.591  14.484  1.00 22.69           C  
ATOM    492  C   GLU A  71      16.407  61.576  14.153  1.00 23.09           C  
ATOM    493  O   GLU A  71      16.780  61.440  12.988  1.00 22.41           O  
ATOM    494  CB  GLU A  71      14.328  60.194  14.298  1.00 22.69           C  
ATOM    495  CG  GLU A  71      12.844  60.093  14.632  1.00 24.95           C  
ATOM    496  CD  GLU A  71      12.544  60.388  16.097  1.00 26.98           C  
ATOM    497  OE1 GLU A  71      13.193  59.784  16.972  1.00 25.64           O  
ATOM    498  OE2 GLU A  71      11.654  61.219  16.375  1.00 28.73           O  
ATOM    499  N   ASP A  72      17.242  61.751  15.175  1.00 22.11           N  
ATOM    500  CA  ASP A  72      18.684  61.752  15.007  1.00 21.62           C  
ATOM    501  C   ASP A  72      19.329  60.879  16.074  1.00 22.85           C  
ATOM    502  O   ASP A  72      18.633  60.273  16.885  1.00 21.42           O  
ATOM    503  CB  ASP A  72      19.232  63.180  15.078  1.00 20.60           C  
ATOM    504  CG  ASP A  72      19.080  63.927  13.764  1.00 19.89           C  
ATOM    505  OD1 ASP A  72      19.603  63.427  12.748  1.00 20.90           O  
ATOM    506  OD2 ASP A  72      18.449  65.007  13.738  1.00 18.81           O  
ATOM    507  N   LYS A  73      20.656  60.806  16.068  1.00 22.10           N  
ATOM    508  CA  LYS A  73      21.360  59.977  17.038  1.00 23.88           C  
ATOM    509  C   LYS A  73      22.619  60.622  17.571  1.00 24.54           C  
ATOM    510  O   LYS A  73      23.331  61.325  16.850  1.00 23.43           O  
ATOM    511  CB  LYS A  73      21.747  58.624  16.418  1.00 26.64           C  
ATOM    512  CG  LYS A  73      20.573  57.786  15.929  1.00 31.27           C  
ATOM    513  CD  LYS A  73      21.040  56.440  15.397  1.00 34.03           C  
ATOM    514  CE  LYS A  73      19.855  55.565  15.014  1.00 35.91           C  
ATOM    515  NZ  LYS A  73      20.298  54.209  14.595  1.00 38.80           N  
ATOM    516  N   LEU A  74      22.882  60.373  18.846  1.00 23.29           N  
ATOM    517  CA  LEU A  74      24.073  60.878  19.499  1.00 24.54           C  
ATOM    518  C   LEU A  74      24.873  59.626  19.816  1.00 23.98           C  
ATOM    519  O   LEU A  74      24.428  58.769  20.577  1.00 24.28           O  
ATOM    520  CB  LEU A  74      23.711  61.618  20.786  1.00 25.85           C  
ATOM    521  CG  LEU A  74      24.818  62.462  21.418  1.00 24.17           C  
ATOM    522  CD1 LEU A  74      25.207  63.596  20.467  1.00 25.54           C  
ATOM    523  CD2 LEU A  74      24.330  63.020  22.746  1.00 23.46           C  
ATOM    524  N   VAL A  75      26.043  59.503  19.205  1.00 24.26           N  
ATOM    525  CA  VAL A  75      26.877  58.336  19.430  1.00 23.31           C  
ATOM    526  C   VAL A  75      28.037  58.669  20.349  1.00 22.83           C  
ATOM    527  O   VAL A  75      28.811  59.602  20.100  1.00 20.30           O  
ATOM    528  CB  VAL A  75      27.423  57.776  18.103  1.00 24.89           C  
ATOM    529  CG1 VAL A  75      28.249  56.524  18.364  1.00 23.52           C  
ATOM    530  CG2 VAL A  75      26.266  57.461  17.166  1.00 26.66           C  
ATOM    531  N   VAL A  76      28.145  57.896  21.419  1.00 19.61           N  
ATOM    532  CA  VAL A  76      29.199  58.087  22.389  1.00 21.16           C  
ATOM    533  C   VAL A  76      30.231  56.969  22.268  1.00 23.26           C  
ATOM    534  O   VAL A  76      29.959  55.811  22.587  1.00 23.79           O  
ATOM    535  CB  VAL A  76      28.626  58.119  23.820  1.00 21.42           C  
ATOM    536  CG1 VAL A  76      29.732  58.433  24.810  1.00 22.83           C  
ATOM    537  CG2 VAL A  76      27.520  59.170  23.914  1.00 20.80           C  
ATOM    538  N   HIS A  77      31.408  57.325  21.768  1.00 23.84           N  
ATOM    539  CA  HIS A  77      32.512  56.385  21.605  1.00 23.61           C  
ATOM    540  C   HIS A  77      33.336  56.456  22.888  1.00 24.31           C  
ATOM    541  O   HIS A  77      33.710  57.546  23.330  1.00 24.86           O  
ATOM    542  CB  HIS A  77      33.366  56.800  20.400  1.00 22.77           C  
ATOM    543  CG  HIS A  77      32.624  56.772  19.100  1.00 22.32           C  
ATOM    544  ND1 HIS A  77      32.573  55.654  18.297  1.00 24.19           N  
ATOM    545  CD2 HIS A  77      31.841  57.699  18.499  1.00 21.86           C  
ATOM    546  CE1 HIS A  77      31.790  55.890  17.261  1.00 21.08           C  
ATOM    547  NE2 HIS A  77      31.331  57.124  17.361  1.00 24.44           N  
ATOM    548  N   PHE A  78      33.619  55.308  23.492  1.00 23.46           N  
ATOM    549  CA  PHE A  78      34.380  55.305  24.733  1.00 25.16           C  
ATOM    550  C   PHE A  78      35.457  54.234  24.787  1.00 24.59           C  
ATOM    551  O   PHE A  78      35.479  53.303  23.979  1.00 23.22           O  
ATOM    552  CB  PHE A  78      33.426  55.130  25.918  1.00 25.10           C  
ATOM    553  CG  PHE A  78      32.627  53.870  25.857  1.00 26.49           C  
ATOM    554  CD1 PHE A  78      33.171  52.664  26.287  1.00 27.93           C  
ATOM    555  CD2 PHE A  78      31.342  53.876  25.326  1.00 27.14           C  
ATOM    556  CE1 PHE A  78      32.445  51.477  26.192  1.00 28.50           C  
ATOM    557  CE2 PHE A  78      30.604  52.697  25.224  1.00 25.78           C  
ATOM    558  CZ  PHE A  78      31.156  51.496  25.657  1.00 28.19           C  
ATOM    559  N   ALA A  79      36.347  54.380  25.761  1.00 25.28           N  
ATOM    560  CA  ALA A  79      37.439  53.443  25.958  1.00 27.36           C  
ATOM    561  C   ALA A  79      38.084  53.653  27.315  1.00 28.96           C  
ATOM    562  O   ALA A  79      37.847  54.652  27.994  1.00 28.30           O  
ATOM    563  CB  ALA A  79      38.491  53.618  24.859  1.00 27.70           C  
ATOM    564  N   SER A  80      38.917  52.696  27.699  1.00 32.40           N  
ATOM    565  CA  SER A  80      39.629  52.782  28.955  1.00 33.47           C  
ATOM    566  C   SER A  80      40.495  54.033  28.907  1.00 33.53           C  
ATOM    567  O   SER A  80      41.170  54.290  27.911  1.00 32.45           O  
ATOM    568  CB  SER A  80      40.508  51.545  29.128  1.00 34.28           C  
ATOM    569  OG  SER A  80      41.405  51.719  30.206  1.00 39.12           O  
ATOM    570  N   ALA A  81      40.470  54.819  29.978  1.00 33.76           N  
ATOM    571  CA  ALA A  81      41.275  56.032  30.035  1.00 34.83           C  
ATOM    572  C   ALA A  81      42.731  55.650  30.257  1.00 37.49           C  
ATOM    573  O   ALA A  81      43.056  54.917  31.194  1.00 35.77           O  
ATOM    574  CB  ALA A  81      40.791  56.925  31.155  1.00 35.35           C  
ATOM    575  N   PRO A  82      43.632  56.145  29.396  1.00 39.45           N  
ATOM    576  CA  PRO A  82      45.052  55.820  29.541  1.00 41.77           C  
ATOM    577  C   PRO A  82      45.806  56.435  30.728  1.00 43.98           C  
ATOM    578  O   PRO A  82      45.523  57.549  31.174  1.00 45.03           O  
ATOM    579  CB  PRO A  82      45.636  56.236  28.192  1.00 41.50           C  
ATOM    580  CG  PRO A  82      44.764  57.374  27.791  1.00 41.75           C  
ATOM    581  CD  PRO A  82      43.386  56.845  28.124  1.00 39.91           C  
ATOM    582  N   ALA A  83      46.770  55.660  31.217  1.00 46.34           N  
ATOM    583  CA  ALA A  83      47.658  55.994  32.329  1.00 47.52           C  
ATOM    584  C   ALA A  83      47.308  57.221  33.160  1.00 47.94           C  
ATOM    585  O   ALA A  83      46.582  57.128  34.151  1.00 48.91           O  
ATOM    586  CB  ALA A  83      49.098  56.115  31.805  1.00 49.20           C  
ATOM    587  N   ASP A  84      47.823  58.373  32.756  1.00 47.02           N  
ATOM    588  CA  ASP A  84      47.575  59.609  33.493  1.00 46.80           C  
ATOM    589  C   ASP A  84      47.039  60.745  32.630  1.00 44.69           C  
ATOM    590  O   ASP A  84      47.399  61.898  32.847  1.00 44.72           O  
ATOM    591  CB  ASP A  84      48.867  60.081  34.158  1.00 49.25           C  
ATOM    592  CG  ASP A  84      49.152  59.368  35.458  1.00 52.52           C  
ATOM    593  OD1 ASP A  84      50.335  59.088  35.726  1.00 53.76           O  
ATOM    594  OD2 ASP A  84      48.203  59.102  36.228  1.00 54.88           O  
ATOM    595  N   ALA A  85      46.176  60.432  31.671  1.00 42.92           N  
ATOM    596  CA  ALA A  85      45.616  61.459  30.796  1.00 42.60           C  
ATOM    597  C   ALA A  85      44.916  62.557  31.593  1.00 41.96           C  
ATOM    598  O   ALA A  85      44.167  62.267  32.529  1.00 42.23           O  
ATOM    599  CB  ALA A  85      44.636  60.824  29.814  1.00 43.01           C  
ATOM    600  N   THR A  86      45.164  63.812  31.223  1.00 40.61           N  
ATOM    601  CA  THR A  86      44.537  64.949  31.899  1.00 40.31           C  
ATOM    602  C   THR A  86      43.494  65.611  31.009  1.00 39.76           C  
ATOM    603  O   THR A  86      42.661  66.380  31.486  1.00 41.93           O  
ATOM    604  CB  THR A  86      45.567  66.003  32.339  1.00 39.69           C  
ATOM    605  OG1 THR A  86      46.476  66.267  31.264  1.00 38.89           O  
ATOM    606  CG2 THR A  86      46.336  65.512  33.550  1.00 40.67           C  
ATOM    607  N   ASP A  87      43.550  65.334  29.709  1.00 38.87           N  
ATOM    608  CA  ASP A  87      42.543  65.863  28.799  1.00 38.75           C  
ATOM    609  C   ASP A  87      42.242  64.812  27.739  1.00 37.50           C  
ATOM    610  O   ASP A  87      43.112  64.401  26.959  1.00 35.77           O  
ATOM    611  CB  ASP A  87      42.975  67.190  28.174  1.00 40.29           C  
ATOM    612  CG  ASP A  87      44.075  67.035  27.178  1.00 40.03           C  
ATOM    613  OD1 ASP A  87      45.128  66.484  27.550  1.00 43.59           O  
ATOM    614  OD2 ASP A  87      43.885  67.472  26.024  1.00 42.44           O  
ATOM    615  N   ALA A  88      40.986  64.374  27.755  1.00 36.05           N  
ATOM    616  CA  ALA A  88      40.459  63.339  26.876  1.00 35.17           C  
ATOM    617  C   ALA A  88      40.727  63.471  25.382  1.00 33.96           C  
ATOM    618  O   ALA A  88      41.069  62.490  24.725  1.00 33.16           O  
ATOM    619  CB  ALA A  88      38.952  63.197  27.113  1.00 34.18           C  
ATOM    620  N   GLN A  89      40.565  64.667  24.834  1.00 33.93           N  
ATOM    621  CA  GLN A  89      40.777  64.831  23.406  1.00 34.07           C  
ATOM    622  C   GLN A  89      42.211  64.501  23.034  1.00 33.01           C  
ATOM    623  O   GLN A  89      42.463  63.811  22.049  1.00 34.17           O  
ATOM    624  CB  GLN A  89      40.430  66.252  22.963  1.00 36.08           C  
ATOM    625  CG  GLN A  89      40.319  66.387  21.448  1.00 37.95           C  
ATOM    626  CD  GLN A  89      39.692  67.696  21.015  1.00 39.70           C  
ATOM    627  OE1 GLN A  89      39.457  67.921  19.827  1.00 41.38           O  
ATOM    628  NE2 GLN A  89      39.419  68.569  21.977  1.00 39.41           N  
ATOM    629  N   ALA A  90      43.149  64.993  23.830  1.00 32.32           N  
ATOM    630  CA  ALA A  90      44.556  64.733  23.582  1.00 31.05           C  
ATOM    631  C   ALA A  90      44.813  63.233  23.656  1.00 31.13           C  
ATOM    632  O   ALA A  90      45.486  62.668  22.793  1.00 31.42           O  
ATOM    633  CB  ALA A  90      45.407  65.456  24.607  1.00 29.75           C  
ATOM    634  N   ALA A  91      44.262  62.591  24.683  1.00 28.37           N  
ATOM    635  CA  ALA A  91      44.448  61.160  24.883  1.00 28.35           C  
ATOM    636  C   ALA A  91      43.697  60.303  23.865  1.00 28.93           C  
ATOM    637  O   ALA A  91      44.182  59.244  23.463  1.00 27.37           O  
ATOM    638  CB  ALA A  91      44.028  60.776  26.297  1.00 27.95           C  
ATOM    639  N   PHE A  92      42.515  60.758  23.452  1.00 29.33           N  
ATOM    640  CA  PHE A  92      41.712  60.018  22.484  1.00 30.15           C  
ATOM    641  C   PHE A  92      42.466  59.892  21.163  1.00 30.30           C  
ATOM    642  O   PHE A  92      42.124  59.083  20.298  1.00 29.13           O  
ATOM    643  CB  PHE A  92      40.383  60.734  22.257  1.00 32.56           C  
ATOM    644  CG  PHE A  92      39.214  59.804  22.130  1.00 35.55           C  
ATOM    645  CD1 PHE A  92      38.955  59.146  20.934  1.00 37.03           C  
ATOM    646  CD2 PHE A  92      38.386  59.564  23.223  1.00 36.12           C  
ATOM    647  CE1 PHE A  92      37.883  58.259  20.826  1.00 38.99           C  
ATOM    648  CE2 PHE A  92      37.315  58.682  23.129  1.00 36.62           C  
ATOM    649  CZ  PHE A  92      37.061  58.026  21.928  1.00 39.44           C  
ATOM    650  N   VAL A  93      43.506  60.700  21.026  1.00 29.65           N  
ATOM    651  CA  VAL A  93      44.328  60.710  19.829  1.00 30.42           C  
ATOM    652  C   VAL A  93      45.114  59.412  19.624  1.00 30.37           C  
ATOM    653  O   VAL A  93      45.510  59.091  18.497  1.00 30.25           O  
ATOM    654  CB  VAL A  93      45.316  61.893  19.883  1.00 29.91           C  
ATOM    655  CG1 VAL A  93      46.252  61.853  18.699  1.00 34.64           C  
ATOM    656  CG2 VAL A  93      44.546  63.204  19.909  1.00 34.48           C  
ATOM    657  N   ALA A  94      45.339  58.665  20.700  1.00 29.69           N  
ATOM    658  CA  ALA A  94      46.106  57.425  20.600  1.00 32.02           C  
ATOM    659  C   ALA A  94      45.314  56.172  20.944  1.00 33.07           C  
ATOM    660  O   ALA A  94      45.834  55.062  20.850  1.00 35.95           O  
ATOM    661  CB  ALA A  94      47.344  57.505  21.491  1.00 31.90           C  
ATOM    662  N   VAL A  95      44.060  56.342  21.338  1.00 32.12           N  
ATOM    663  CA  VAL A  95      43.248  55.191  21.695  1.00 31.90           C  
ATOM    664  C   VAL A  95      42.124  54.904  20.716  1.00 28.71           C  
ATOM    665  O   VAL A  95      41.461  55.815  20.225  1.00 28.75           O  
ATOM    666  CB  VAL A  95      42.650  55.360  23.108  1.00 33.23           C  
ATOM    667  CG1 VAL A  95      41.634  54.261  23.386  1.00 35.42           C  
ATOM    668  CG2 VAL A  95      43.764  55.313  24.140  1.00 35.85           C  
ATOM    669  N   ALA A  96      41.937  53.624  20.422  1.00 26.55           N  
ATOM    670  CA  ALA A  96      40.874  53.186  19.538  1.00 26.87           C  
ATOM    671  C   ALA A  96      39.700  52.865  20.469  1.00 26.77           C  
ATOM    672  O   ALA A  96      39.854  52.126  21.441  1.00 23.48           O  
ATOM    673  CB  ALA A  96      41.307  51.946  18.766  1.00 26.79           C  
ATOM    674  N   PRO A  97      38.518  53.439  20.196  1.00 26.46           N  
ATOM    675  CA  PRO A  97      37.345  53.187  21.040  1.00 27.44           C  
ATOM    676  C   PRO A  97      37.109  51.700  21.310  1.00 28.87           C  
ATOM    677  O   PRO A  97      37.338  50.860  20.440  1.00 29.21           O  
ATOM    678  CB  PRO A  97      36.212  53.816  20.238  1.00 27.59           C  
ATOM    679  CG  PRO A  97      36.886  54.981  19.577  1.00 26.74           C  
ATOM    680  CD  PRO A  97      38.195  54.381  19.110  1.00 27.35           C  
ATOM    681  N   ALA A  98      36.656  51.375  22.518  1.00 29.34           N  
ATOM    682  CA  ALA A  98      36.390  49.980  22.865  1.00 29.88           C  
ATOM    683  C   ALA A  98      34.916  49.650  22.661  1.00 28.98           C  
ATOM    684  O   ALA A  98      34.559  48.497  22.430  1.00 30.32           O  
ATOM    685  CB  ALA A  98      36.787  49.704  24.314  1.00 28.31           C  
ATOM    686  N   GLY A  99      34.065  50.669  22.755  1.00 29.24           N  
ATOM    687  CA  GLY A  99      32.639  50.461  22.577  1.00 26.38           C  
ATOM    688  C   GLY A  99      31.878  51.755  22.362  1.00 26.18           C  
ATOM    689  O   GLY A  99      32.444  52.846  22.450  1.00 25.24           O  
ATOM    690  N   THR A 100      30.589  51.642  22.062  1.00 26.03           N  
ATOM    691  CA  THR A 100      29.767  52.825  21.845  1.00 25.28           C  
ATOM    692  C   THR A 100      28.351  52.635  22.376  1.00 24.42           C  
ATOM    693  O   THR A 100      27.815  51.526  22.364  1.00 22.85           O  
ATOM    694  CB  THR A 100      29.642  53.181  20.340  1.00 26.21           C  
ATOM    695  OG1 THR A 100      28.711  52.289  19.714  1.00 29.62           O  
ATOM    696  CG2 THR A 100      30.995  53.061  19.632  1.00 27.69           C  
ATOM    697  N   VAL A 101      27.764  53.727  22.856  1.00 22.97           N  
ATOM    698  CA  VAL A 101      26.388  53.723  23.332  1.00 26.43           C  
ATOM    699  C   VAL A 101      25.693  54.827  22.547  1.00 27.06           C  
ATOM    700  O   VAL A 101      26.238  55.920  22.380  1.00 26.48           O  
ATOM    701  CB  VAL A 101      26.271  54.014  24.846  1.00 25.73           C  
ATOM    702  CG1 VAL A 101      26.800  52.837  25.639  1.00 25.19           C  
ATOM    703  CG2 VAL A 101      27.022  55.276  25.197  1.00 27.71           C  
ATOM    704  N   THR A 102      24.501  54.535  22.046  1.00 26.34           N  
ATOM    705  CA  THR A 102      23.762  55.506  21.259  1.00 26.07           C  
ATOM    706  C   THR A 102      22.535  56.028  21.987  1.00 25.96           C  
ATOM    707  O   THR A 102      21.743  55.256  22.536  1.00 25.13           O  
ATOM    708  CB  THR A 102      23.339  54.898  19.914  1.00 27.46           C  
ATOM    709  OG1 THR A 102      24.514  54.527  19.180  1.00 28.71           O  
ATOM    710  CG2 THR A 102      22.532  55.894  19.099  1.00 28.31           C  
ATOM    711  N   ILE A 103      22.411  57.350  22.004  1.00 24.92           N  
ATOM    712  CA  ILE A 103      21.294  58.036  22.638  1.00 23.72           C  
ATOM    713  C   ILE A 103      20.472  58.619  21.495  1.00 24.30           C  
ATOM    714  O   ILE A 103      20.957  59.478  20.746  1.00 23.21           O  
ATOM    715  CB  ILE A 103      21.778  59.204  23.538  1.00 22.57           C  
ATOM    716  CG1 ILE A 103      22.600  58.666  24.708  1.00 22.19           C  
ATOM    717  CG2 ILE A 103      20.588  60.008  24.051  1.00 22.96           C  
ATOM    718  CD1 ILE A 103      23.107  59.749  25.635  1.00 22.89           C  
ATOM    719  N   PRO A 104      19.235  58.132  21.310  1.00 23.36           N  
ATOM    720  CA  PRO A 104      18.448  58.703  20.214  1.00 23.25           C  
ATOM    721  C   PRO A 104      17.973  60.110  20.575  1.00 23.05           C  
ATOM    722  O   PRO A 104      17.730  60.416  21.743  1.00 24.04           O  
ATOM    723  CB  PRO A 104      17.296  57.707  20.058  1.00 24.08           C  
ATOM    724  CG  PRO A 104      17.114  57.177  21.448  1.00 24.81           C  
ATOM    725  CD  PRO A 104      18.549  56.976  21.913  1.00 23.85           C  
ATOM    726  N   MET A 105      17.870  60.974  19.576  1.00 22.92           N  
ATOM    727  CA  MET A 105      17.413  62.335  19.812  1.00 23.84           C  
ATOM    728  C   MET A 105      16.175  62.576  18.961  1.00 23.57           C  
ATOM    729  O   MET A 105      16.245  62.573  17.735  1.00 21.80           O  
ATOM    730  CB  MET A 105      18.499  63.346  19.439  1.00 24.15           C  
ATOM    731  CG  MET A 105      19.803  63.190  20.197  1.00 24.91           C  
ATOM    732  SD  MET A 105      20.940  64.511  19.741  1.00 24.15           S  
ATOM    733  CE  MET A 105      22.031  64.511  21.062  1.00 29.22           C  
ATOM    734  N   SER A 106      15.036  62.774  19.618  1.00 24.35           N  
ATOM    735  CA  SER A 106      13.784  63.013  18.911  1.00 22.12           C  
ATOM    736  C   SER A 106      13.351  64.471  18.998  1.00 23.00           C  
ATOM    737  O   SER A 106      12.943  64.939  20.057  1.00 21.31           O  
ATOM    738  CB  SER A 106      12.672  62.137  19.491  1.00 21.92           C  
ATOM    739  OG  SER A 106      12.958  60.766  19.315  1.00 22.86           O  
ATOM    740  N   ALA A 107      13.456  65.190  17.883  1.00 22.58           N  
ATOM    741  CA  ALA A 107      13.036  66.585  17.836  1.00 21.17           C  
ATOM    742  C   ALA A 107      11.605  66.525  17.314  1.00 22.60           C  
ATOM    743  O   ALA A 107      11.375  66.143  16.160  1.00 18.12           O  
ATOM    744  CB  ALA A 107      13.926  67.376  16.880  1.00 23.75           C  
ATOM    745  N   THR A 108      10.647  66.878  18.170  1.00 21.96           N  
ATOM    746  CA  THR A 108       9.236  66.825  17.805  1.00 24.00           C  
ATOM    747  C   THR A 108       8.563  68.182  17.710  1.00 23.73           C  
ATOM    748  O   THR A 108       8.974  69.146  18.355  1.00 23.37           O  
ATOM    749  CB  THR A 108       8.435  65.961  18.811  1.00 25.41           C  
ATOM    750  OG1 THR A 108       8.561  66.511  20.125  1.00 26.04           O  
ATOM    751  CG2 THR A 108       8.958  64.535  18.818  1.00 28.08           C  
ATOM    752  N   ALA A 109       7.511  68.252  16.905  1.00 25.60           N  
ATOM    753  CA  ALA A 109       6.785  69.503  16.736  1.00 28.77           C  
ATOM    754  C   ALA A 109       5.933  69.789  17.966  1.00 30.32           C  
ATOM    755  O   ALA A 109       5.565  68.814  18.658  1.00 30.82           O  
ATOM    756  CB  ALA A 109       5.909  69.432  15.496  1.00 28.84           C  
ATOM    757  OXT ALA A 109       5.634  70.980  18.214  1.00 32.11           O  
TER     758      ALA A 109                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
