
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  124 (  978),  selected  124 , name 1grw_A
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 1grw_A.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     3_A      E     267           -
LGA    V     4_A      D     268           -
LGA    P     5_A      L     269          5.581
LGA    P     6_A      L     270          4.587
LGA    -       -      R     271           -
LGA    -       -      P     272           -
LGA    -       -      F     273           -
LGA    G     7_A      F     274          3.085
LGA    D     8_A      E     275          3.005
LGA    -       -      K     276           -
LGA    -       -      C     277           -
LGA    I     9_A      V     278          1.215
LGA    Q    10_A      K     279          1.404
LGA    T    11_A      I     280          0.950
LGA    Q    12_A      E     281          1.452
LGA    P    13_A      E     282          1.577
LGA    G    14_A      V     283           -
LGA    T    15_A      -       -           -
LGA    K    16_A      -       -           -
LGA    I    17_A      S     284           #
LGA    V    18_A      R     285          5.089
LGA    F    19_A      N     286          4.259
LGA    N    20_A      E     287          3.580
LGA    A    21_A      -       -           -
LGA    P    22_A      -       -           -
LGA    Y    23_A      -       -           -
LGA    D    24_A      -       -           -
LGA    D    25_A      -       -           -
LGA    K    26_A      -       -           -
LGA    H    27_A      Q     288          1.970
LGA    T    28_A      G     289           #
LGA    Y    29_A      V     290          3.359
LGA    H    30_A      T     291          2.001
LGA    I    31_A      L     292          1.737
LGA    K    32_A      S     293          1.656
LGA    V    33_A      I     294          1.692
LGA    I    34_A      T     295          1.587
LGA    N    35_A      N     296          1.614
LGA    S    36_A      V     297          2.147
LGA    S    37_A      T     298          3.033
LGA    A    38_A      D     299          3.134
LGA    R    39_A      L     300          1.392
LGA    R    40_A      V     301          1.350
LGA    I    41_A      L     302          1.275
LGA    G    42_A      K     303          0.589
LGA    Y    43_A      L     304          0.961
LGA    G    44_A      K     305          2.110
LGA    I    45_A      K     306          3.478
LGA    K    46_A      T     307          4.664
LGA    T    47_A      A     308           #
LGA    T    48_A      H     309          3.682
LGA    N    49_A      D     310          1.884
LGA    M    50_A      T     311          0.332
LGA    K    51_A      L     312          3.742
LGA    R    52_A      -       -           -
LGA    L    53_A      L     313          2.009
LGA    G    54_A      V     314          0.991
LGA    V    55_A      Y     315          0.678
LGA    D    56_A      F     316          2.881
LGA    P    57_A      -       -           -
LGA    P    58_A      R     317          2.116
LGA    C    59_A      D     318          1.322
LGA    G    60_A      M     319          1.612
LGA    V    61_A      T     320          1.505
LGA    L    62_A      L     321          1.592
LGA    D    63_A      K     322          2.098
LGA    P    64_A      P     323          1.839
LGA    K    65_A      H     324          1.484
LGA    E    66_A      T     325          1.844
LGA    A    67_A      R     326          2.637
LGA    V    68_A      Y     327          2.296
LGA    L    69_A      T     328          1.941
LGA    L    70_A      V     329          1.905
LGA    A    71_A      R     330          2.186
LGA    V    72_A      I     331          1.357
LGA    S    73_A      G     332          1.444
LGA    C    74_A      F     333          1.566
LGA    D    75_A      K     334          2.261
LGA    A    76_A      Q     335          3.671
LGA    F    77_A      G     336          3.497
LGA    A    78_A      -       -           -
LGA    F    79_A      -       -           -
LGA    G    80_A      -       -           -
LGA    Q    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    D    83_A      -       -           -
LGA    T    84_A      I     337          5.606
LGA    N    85_A      K     338           #
LGA    N    86_A      G     339           #
LGA    D    87_A      G     340          2.315
LGA    R    88_A      D     341          1.929
LGA    I    89_A      V     342          1.607
LGA    T    90_A      N     343          2.523
LGA    V    91_A      F     344          4.289
LGA    E    92_A      E     345          3.264
LGA    W    93_A      V     346          1.682
LGA    T    94_A      T     347          4.245
LGA    N    95_A      N     348          3.352
LGA    T    96_A      F     349           #
LGA    P    97_A      -       -           -
LGA    D    98_A      -       -           -
LGA    G    99_A      -       -           -
LGA    A   100_A      -       -           -
LGA    A   101_A      -       -           -
LGA    K   102_A      -       -           -
LGA    Q   103_A      -       -           -
LGA    F   104_A      -       -           -
LGA    R   105_A      -       -           -
LGA    R   106_A      -       -           -
LGA    E   107_A      -       -           -
LGA    W   108_A      -       -           -
LGA    F   109_A      I     350           #
LGA    Q   110_A      V     351           -
LGA    G   111_A      A     352          6.155
LGA    D   112_A      P     353          1.729
LGA    G   113_A      D     354           #
LGA    M   114_A      K     355           #
LGA    -       -      G     356           -
LGA    V   115_A      L     357          0.796
LGA    R   116_A      K     358          4.714
LGA    R   117_A      Y     359          1.684
LGA    K   118_A      T     360          3.549
LGA    N   119_A      I     361          2.436
LGA    L   120_A      S     362          1.866
LGA    P   121_A      L     363          2.767
LGA    I   122_A      -       -           -
LGA    E   123_A      -       -           -
LGA    Y   124_A      -       -           -
LGA    N   125_A      -       -           -
LGA    P   126_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  124   97    5.0     78    2.72     8.97     56.222     2.763

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.419936 * X  +   0.150215 * Y  +   0.895036 * Z  + -38.918610
  Y_new =   0.832492 * X  +  -0.456480 * Y  +  -0.313980 * Z  +  58.724838
  Z_new =   0.361402 * X  +   0.876962 * Y  +  -0.316745 * Z  +  25.518755 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.917400   -1.224193  [ DEG:   109.8589    -70.1411 ]
  Theta =  -0.369771   -2.771822  [ DEG:   -21.1863   -158.8137 ]
  Phi   =   1.103609   -2.037983  [ DEG:    63.2321   -116.7679 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1grw_A                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1grw_A.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  124   97   5.0   78   2.72    8.97  56.222
REMARK  ---------------------------------------------------------- 
MOLECULE 1grw_A
HEADER    CYTOSKETAL PROTEIN                      18-DEC-01   1GRW              
TITLE     C. ELEGANS MAJOR SPERM PROTEIN                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MAJOR SPERM PROTEIN 31/40/142;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: MSP;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CAENORHABDITIS ELEGANS;                         
SOURCE   3 ORGANISM_COMMON: C.ELEGANS;                                          
SOURCE   4 CELL: SPERM;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VARIANT: PLYSS;                                    
SOURCE   8 EXPRESSION_SYSTEM_VECTOR: PET15B                                     
KEYWDS    CYTOSKETAL PROTEIN, CYTOSKELETON, SPERM, CELL MOTILITY                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.M.E.BAKER,T.M.ROBERTS,M.STEWART                                     
REVDAT   2   01-APR-03 1GRW    1       JRNL                                     
REVDAT   1   13-JUN-02 1GRW    0                                                
JRNL        AUTH   A.M.BAKER,T.M.ROBERTS,M.STEWART                              
JRNL        TITL   2.6 A RESOLUTION CRYSTAL STRUCTURE OF HELICES OF             
JRNL        TITL 2 THE MOTILE MAJOR SPERM PROTEIN (MSP) OF                      
JRNL        TITL 3 CAENORHABDITIS ELEGANS.                                      
JRNL        REF    J.MOL.BIOL.                   V. 319   491 2002              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  1GRW A    1   126  UNP    P53017   MSP19_CAEEL      1    126             
DBREF  1GRW B    1   126  UNP    P53017   MSP19_CAEEL      1    126             
DBREF  1GRW C    1   126  UNP    P53017   MSP19_CAEEL      1    126             
DBREF  1GRW D    1   126  UNP    P53017   MSP19_CAEEL      1    126             
SEQRES   1 A  126  ALA GLN SER VAL PRO PRO GLY ASP ILE GLN THR GLN PRO          
SEQRES   2 A  126  GLY THR LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 A  126  HIS THR TYR HIS ILE LYS VAL ILE ASN SER SER ALA ARG          
SEQRES   4 A  126  ARG ILE GLY TYR GLY ILE LYS THR THR ASN MET LYS ARG          
SEQRES   5 A  126  LEU GLY VAL ASP PRO PRO CYS GLY VAL LEU ASP PRO LYS          
SEQRES   6 A  126  GLU ALA VAL LEU LEU ALA VAL SER CYS ASP ALA PHE ALA          
SEQRES   7 A  126  PHE GLY GLN GLU ASP THR ASN ASN ASP ARG ILE THR VAL          
SEQRES   8 A  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 A  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 A  126  LYS ASN LEU PRO ILE GLU TYR ASN PRO                          
SEQRES   1 B  126  ALA GLN SER VAL PRO PRO GLY ASP ILE GLN THR GLN PRO          
SEQRES   2 B  126  GLY THR LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 B  126  HIS THR TYR HIS ILE LYS VAL ILE ASN SER SER ALA ARG          
SEQRES   4 B  126  ARG ILE GLY TYR GLY ILE LYS THR THR ASN MET LYS ARG          
SEQRES   5 B  126  LEU GLY VAL ASP PRO PRO CYS GLY VAL LEU ASP PRO LYS          
SEQRES   6 B  126  GLU ALA VAL LEU LEU ALA VAL SER CYS ASP ALA PHE ALA          
SEQRES   7 B  126  PHE GLY GLN GLU ASP THR ASN ASN ASP ARG ILE THR VAL          
SEQRES   8 B  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 B  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 B  126  LYS ASN LEU PRO ILE GLU TYR ASN PRO                          
SEQRES   1 C  126  ALA GLN SER VAL PRO PRO GLY ASP ILE GLN THR GLN PRO          
SEQRES   2 C  126  GLY THR LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 C  126  HIS THR TYR HIS ILE LYS VAL ILE ASN SER SER ALA ARG          
SEQRES   4 C  126  ARG ILE GLY TYR GLY ILE LYS THR THR ASN MET LYS ARG          
SEQRES   5 C  126  LEU GLY VAL ASP PRO PRO CYS GLY VAL LEU ASP PRO LYS          
SEQRES   6 C  126  GLU ALA VAL LEU LEU ALA VAL SER CYS ASP ALA PHE ALA          
SEQRES   7 C  126  PHE GLY GLN GLU ASP THR ASN ASN ASP ARG ILE THR VAL          
SEQRES   8 C  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 C  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 C  126  LYS ASN LEU PRO ILE GLU TYR ASN PRO                          
SEQRES   1 D  126  ALA GLN SER VAL PRO PRO GLY ASP ILE GLN THR GLN PRO          
SEQRES   2 D  126  GLY THR LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 D  126  HIS THR TYR HIS ILE LYS VAL ILE ASN SER SER ALA ARG          
SEQRES   4 D  126  ARG ILE GLY TYR GLY ILE LYS THR THR ASN MET LYS ARG          
SEQRES   5 D  126  LEU GLY VAL ASP PRO PRO CYS GLY VAL LEU ASP PRO LYS          
SEQRES   6 D  126  GLU ALA VAL LEU LEU ALA VAL SER CYS ASP ALA PHE ALA          
SEQRES   7 D  126  PHE GLY GLN GLU ASP THR ASN ASN ASP ARG ILE THR VAL          
SEQRES   8 D  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 D  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 D  126  LYS ASN LEU PRO ILE GLU TYR ASN PRO                          
FORMUL   5  HOH   *74(H2 O)                                                     
CRYST1   53.478   53.478  457.203  90.00  90.00  90.00 P 41 21 2    32          
ATOM      1  N   SER A   3      44.727  44.394  27.126  0.00102.62           N  
ATOM      2  CA  SER A   3      43.749  45.284  26.513  0.00101.93           C  
ATOM      3  C   SER A   3      42.200  44.530  26.760  0.00101.19           C  
ATOM      4  O   SER A   3      41.823  43.551  26.093  0.00102.62           O  
ATOM      5  CB  SER A   3      43.879  45.302  24.987  0.00102.62           C  
ATOM      6  OG  SER A   3      43.533  44.032  24.455  0.00102.62           O  
ATOM      7  N   VAL A   4      40.763  44.219  27.592  1.00 62.31           N  
ATOM      8  CA  VAL A   4      39.419  44.004  28.153  1.00 60.92           C  
ATOM      9  C   VAL A   4      38.388  44.942  27.562  1.00 56.92           C  
ATOM     10  O   VAL A   4      38.669  46.134  27.353  1.00 56.56           O  
ATOM     11  CB  VAL A   4      39.424  44.184  29.681  1.00 59.68           C  
ATOM     12  CG1 VAL A   4      40.170  43.007  30.295  1.00 58.01           C  
ATOM     13  CG2 VAL A   4      40.103  45.496  30.024  1.00 60.93           C  
ATOM     14  N   PRO A   5      37.235  44.390  27.220  1.00 55.35           N  
ATOM     15  CA  PRO A   5      36.184  45.203  26.601  1.00 52.76           C  
ATOM     16  C   PRO A   5      35.771  46.317  27.549  1.00 48.50           C  
ATOM     17  O   PRO A   5      35.886  46.243  28.785  1.00 46.20           O  
ATOM     18  CB  PRO A   5      35.066  44.225  26.335  1.00 53.11           C  
ATOM     19  CG  PRO A   5      35.339  43.007  27.129  1.00 53.57           C  
ATOM     20  CD  PRO A   5      36.788  43.016  27.479  1.00 53.78           C  
ATOM     21  N   PRO A   6      35.361  47.428  26.972  1.00 45.61           N  
ATOM     22  CA  PRO A   6      34.836  48.524  27.783  1.00 44.51           C  
ATOM     23  C   PRO A   6      33.536  48.048  28.454  1.00 41.83           C  
ATOM     24  O   PRO A   6      32.823  47.181  27.946  1.00 41.74           O  
ATOM     25  CB  PRO A   6      34.503  49.619  26.800  1.00 43.19           C  
ATOM     26  CG  PRO A   6      34.906  49.140  25.454  1.00 43.63           C  
ATOM     27  CD  PRO A   6      35.162  47.659  25.529  1.00 43.08           C  
ATOM     28  N   GLY A   7      33.319  48.463  29.691  1.00 37.28           N  
ATOM     29  CA  GLY A   7      32.109  48.152  30.403  1.00 41.72           C  
ATOM     30  C   GLY A   7      30.928  49.023  29.941  1.00 46.05           C  
ATOM     31  O   GLY A   7      30.785  49.767  28.964  1.00 46.21           O  
ATOM     32  N   ASP A   8      29.875  48.919  30.721  1.00 50.94           N  
ATOM     33  CA  ASP A   8      28.603  49.568  30.516  1.00 56.12           C  
ATOM     34  C   ASP A   8      28.514  50.906  31.242  1.00 50.51           C  
ATOM     35  O   ASP A   8      29.105  51.141  32.272  1.00 48.26           O  
ATOM     36  CB  ASP A   8      27.439  48.730  31.014  1.00 65.94           C  
ATOM     37  CG  ASP A   8      27.784  47.285  31.251  1.00 79.33           C  
ATOM     38  OD1 ASP A   8      28.848  46.882  31.788  1.00 88.66           O  
ATOM     39  OD2 ASP A   8      26.899  46.474  30.881  1.00 87.66           O  
ATOM     40  N   ILE A   9      27.792  51.767  30.539  1.00 48.74           N  
ATOM     41  CA  ILE A   9      27.508  53.077  31.127  1.00 46.70           C  
ATOM     42  C   ILE A   9      26.000  53.106  31.359  1.00 42.86           C  
ATOM     43  O   ILE A   9      25.245  52.221  30.964  1.00 43.26           O  
ATOM     44  CB  ILE A   9      27.862  54.214  30.165  1.00 43.88           C  
ATOM     45  CG1 ILE A   9      27.161  53.943  28.818  1.00 34.80           C  
ATOM     46  CG2 ILE A   9      29.360  54.336  30.041  1.00 38.65           C  
ATOM     47  CD1 ILE A   9      27.138  55.198  27.938  1.00 32.71           C  
ATOM     48  N   GLN A  10      25.589  54.124  32.050  1.00 46.35           N  
ATOM     49  CA  GLN A  10      24.154  54.356  32.260  1.00 46.24           C  
ATOM     50  C   GLN A  10      23.913  55.788  31.775  1.00 43.86           C  
ATOM     51  O   GLN A  10      24.790  56.642  31.914  1.00 41.81           O  
ATOM     52  CB  GLN A  10      23.648  54.181  33.653  1.00 45.33           C  
ATOM     53  CG  GLN A  10      23.773  52.803  34.264  1.00 58.76           C  
ATOM     54  CD  GLN A  10      23.708  52.820  35.793  1.00 64.98           C  
ATOM     55  OE1 GLN A  10      23.445  53.869  36.412  1.00 55.69           O  
ATOM     56  NE2 GLN A  10      23.962  51.675  36.440  1.00 66.23           N  
ATOM     57  N   THR A  11      22.785  55.938  31.076  1.00 43.89           N  
ATOM     58  CA  THR A  11      22.486  57.298  30.636  1.00 40.69           C  
ATOM     59  C   THR A  11      21.131  57.699  31.183  1.00 44.82           C  
ATOM     60  O   THR A  11      20.214  56.894  31.415  1.00 45.69           O  
ATOM     61  CB  THR A  11      22.554  57.490  29.123  1.00 39.67           C  
ATOM     62  OG1 THR A  11      21.534  56.698  28.499  1.00 36.90           O  
ATOM     63  CG2 THR A  11      23.922  57.131  28.556  1.00 38.61           C  
ATOM     64  N   GLN A  12      20.917  59.013  31.314  1.00 45.19           N  
ATOM     65  CA  GLN A  12      19.646  59.596  31.745  1.00 38.01           C  
ATOM     66  C   GLN A  12      19.449  60.797  30.818  1.00 38.17           C  
ATOM     67  O   GLN A  12      20.236  61.749  30.865  1.00 40.15           O  
ATOM     68  CB  GLN A  12      19.688  60.070  33.166  1.00 40.23           C  
ATOM     69  CG  GLN A  12      19.684  59.065  34.286  1.00 48.49           C  
ATOM     70  CD  GLN A  12      19.928  59.759  35.616  1.00 55.51           C  
ATOM     71  OE1 GLN A  12      20.706  60.714  35.714  1.00 63.47           O  
ATOM     72  NE2 GLN A  12      19.228  59.329  36.644  1.00 58.01           N  
ATOM     73  N   PRO A  13      18.449  60.722  29.956  1.00 38.34           N  
ATOM     74  CA  PRO A  13      17.511  59.639  29.818  1.00 38.61           C  
ATOM     75  C   PRO A  13      18.125  58.370  29.278  1.00 41.36           C  
ATOM     76  O   PRO A  13      19.173  58.429  28.603  1.00 43.01           O  
ATOM     77  CB  PRO A  13      16.481  60.150  28.832  1.00 39.57           C  
ATOM     78  CG  PRO A  13      16.866  61.503  28.451  1.00 43.30           C  
ATOM     79  CD  PRO A  13      18.256  61.762  28.918  1.00 38.89           C  
ATOM     80  N   GLY A  14      17.574  57.183  29.534  1.00 41.51           N  
ATOM     81  CA  GLY A  14      18.157  55.953  29.094  1.00 38.09           C  
ATOM     82  C   GLY A  14      17.954  55.425  27.703  1.00 41.64           C  
ATOM     83  O   GLY A  14      18.789  54.572  27.269  1.00 41.47           O  
ATOM     84  N   THR A  15      16.951  55.841  26.900  1.00 40.26           N  
ATOM     85  CA  THR A  15      16.708  55.205  25.604  1.00 40.48           C  
ATOM     86  C   THR A  15      16.551  56.175  24.458  1.00 41.06           C  
ATOM     87  O   THR A  15      16.598  55.771  23.286  1.00 42.19           O  
ATOM     88  CB  THR A  15      15.472  54.272  25.497  1.00 37.25           C  
ATOM     89  OG1 THR A  15      14.227  54.960  25.706  1.00 41.16           O  
ATOM     90  CG2 THR A  15      15.603  53.135  26.496  1.00 22.55           C  
ATOM     91  N   LYS A  16      16.239  57.404  24.841  1.00 39.57           N  
ATOM     92  CA  LYS A  16      16.091  58.456  23.830  1.00 40.66           C  
ATOM     93  C   LYS A  16      15.957  59.793  24.543  1.00 36.86           C  
ATOM     94  O   LYS A  16      15.890  59.831  25.757  1.00 37.34           O  
ATOM     95  CB  LYS A  16      14.797  58.247  23.025  1.00 45.05           C  
ATOM     96  CG  LYS A  16      13.588  58.206  23.929  1.00 41.78           C  
ATOM     97  CD  LYS A  16      12.297  57.861  23.221  1.00 49.53           C  
ATOM     98  CE  LYS A  16      11.115  57.837  24.235  1.00 48.27           C  
ATOM     99  NZ  LYS A  16       9.842  58.202  23.526  1.00 41.67           N  
ATOM    100  N   ILE A  17      15.923  60.839  23.753  1.00 38.01           N  
ATOM    101  CA  ILE A  17      15.735  62.183  24.293  1.00 37.07           C  
ATOM    102  C   ILE A  17      14.683  62.878  23.458  1.00 34.14           C  
ATOM    103  O   ILE A  17      14.659  62.796  22.220  1.00 30.88           O  
ATOM    104  CB  ILE A  17      17.067  62.937  24.420  1.00 41.74           C  
ATOM    105  CG1 ILE A  17      16.805  64.256  25.125  1.00 44.37           C  
ATOM    106  CG2 ILE A  17      17.726  63.164  23.087  1.00 41.72           C  
ATOM    107  CD1 ILE A  17      17.882  64.890  25.908  1.00 44.41           C  
ATOM    108  N   VAL A  18      13.695  63.463  24.133  1.00 35.69           N  
ATOM    109  CA  VAL A  18      12.615  64.100  23.379  1.00 37.63           C  
ATOM    110  C   VAL A  18      12.776  65.608  23.383  1.00 36.20           C  
ATOM    111  O   VAL A  18      12.956  66.112  24.479  1.00 39.34           O  
ATOM    112  CB  VAL A  18      11.231  63.774  23.995  1.00 38.20           C  
ATOM    113  CG1 VAL A  18      10.133  64.543  23.244  1.00 42.11           C  
ATOM    114  CG2 VAL A  18      10.990  62.293  23.937  1.00 36.26           C  
ATOM    115  N   PHE A  19      12.778  66.251  22.236  1.00 36.19           N  
ATOM    116  CA  PHE A  19      12.815  67.705  22.195  1.00 37.44           C  
ATOM    117  C   PHE A  19      11.406  68.235  21.910  1.00 38.68           C  
ATOM    118  O   PHE A  19      10.876  67.886  20.842  1.00 42.71           O  
ATOM    119  CB  PHE A  19      13.697  68.243  21.071  1.00 39.52           C  
ATOM    120  CG  PHE A  19      15.143  67.946  21.210  1.00 42.95           C  
ATOM    121  CD1 PHE A  19      15.670  67.544  22.425  1.00 48.15           C  
ATOM    122  CD2 PHE A  19      16.014  68.036  20.138  1.00 47.74           C  
ATOM    123  CE1 PHE A  19      17.006  67.264  22.576  1.00 47.41           C  
ATOM    124  CE2 PHE A  19      17.355  67.783  20.285  1.00 44.52           C  
ATOM    125  CZ  PHE A  19      17.843  67.392  21.502  1.00 45.71           C  
ATOM    126  N   ASN A  20      10.936  69.094  22.761  1.00 38.05           N  
ATOM    127  CA  ASN A  20       9.608  69.678  22.642  1.00 37.72           C  
ATOM    128  C   ASN A  20       9.594  70.965  21.833  1.00 36.41           C  
ATOM    129  O   ASN A  20      10.453  71.838  22.066  1.00 37.31           O  
ATOM    130  CB  ASN A  20       9.183  70.012  24.104  1.00 32.15           C  
ATOM    131  CG  ASN A  20       9.091  68.828  25.012  1.00 36.43           C  
ATOM    132  OD1 ASN A  20       8.155  67.998  24.906  1.00 43.09           O  
ATOM    133  ND2 ASN A  20      10.047  68.783  25.963  1.00 33.67           N  
ATOM    134  N   ALA A  21       8.648  71.172  20.950  1.00 35.87           N  
ATOM    135  CA  ALA A  21       8.498  72.493  20.284  1.00 33.67           C  
ATOM    136  C   ALA A  21       8.134  73.483  21.386  1.00 34.54           C  
ATOM    137  O   ALA A  21       7.712  73.071  22.490  1.00 33.92           O  
ATOM    138  CB  ALA A  21       7.265  72.374  19.383  1.00 27.72           C  
ATOM    139  N   PRO A  22       8.148  74.777  21.138  1.00 37.95           N  
ATOM    140  CA  PRO A  22       8.515  75.451  19.912  1.00 40.11           C  
ATOM    141  C   PRO A  22       9.951  75.317  19.432  1.00 44.69           C  
ATOM    142  O   PRO A  22      10.933  75.308  20.179  1.00 44.17           O  
ATOM    143  CB  PRO A  22       8.334  76.959  20.231  1.00 32.49           C  
ATOM    144  CG  PRO A  22       8.419  77.010  21.716  1.00 34.09           C  
ATOM    145  CD  PRO A  22       7.716  75.777  22.203  1.00 35.27           C  
ATOM    146  N   TYR A  23      10.171  75.287  18.119  1.00 46.12           N  
ATOM    147  CA  TYR A  23      11.510  75.131  17.569  1.00 47.81           C  
ATOM    148  C   TYR A  23      12.023  76.398  16.883  1.00 52.65           C  
ATOM    149  O   TYR A  23      12.780  76.381  15.910  1.00 52.69           O  
ATOM    150  CB  TYR A  23      11.542  74.022  16.500  1.00 40.79           C  
ATOM    151  CG  TYR A  23      11.085  72.705  17.049  1.00 37.69           C  
ATOM    152  CD1 TYR A  23      11.736  72.098  18.110  1.00 39.57           C  
ATOM    153  CD2 TYR A  23       9.928  72.125  16.560  1.00 36.00           C  
ATOM    154  CE1 TYR A  23      11.285  70.897  18.638  1.00 41.29           C  
ATOM    155  CE2 TYR A  23       9.452  70.946  17.073  1.00 36.22           C  
ATOM    156  CZ  TYR A  23      10.140  70.335  18.099  1.00 41.56           C  
ATOM    157  OH  TYR A  23       9.690  69.123  18.574  1.00 43.39           O  
ATOM    158  N   ASP A  24      11.666  77.525  17.435  1.00 54.31           N  
ATOM    159  CA  ASP A  24      12.000  78.831  16.885  1.00 54.80           C  
ATOM    160  C   ASP A  24      13.002  79.498  17.808  1.00 54.30           C  
ATOM    161  O   ASP A  24      13.416  80.642  17.645  1.00 55.43           O  
ATOM    162  CB  ASP A  24      10.687  79.587  16.703  1.00 53.34           C  
ATOM    163  CG  ASP A  24       9.865  79.692  17.957  1.00 59.97           C  
ATOM    164  OD1 ASP A  24      10.126  79.085  19.018  1.00 72.43           O  
ATOM    165  OD2 ASP A  24       8.883  80.453  17.912  1.00 63.49           O  
ATOM    166  N   ASP A  25      13.572  78.694  18.689  1.00 53.36           N  
ATOM    167  CA  ASP A  25      14.546  79.208  19.670  1.00 54.13           C  
ATOM    168  C   ASP A  25      15.544  78.072  19.885  1.00 51.24           C  
ATOM    169  O   ASP A  25      15.233  76.931  19.557  1.00 50.67           O  
ATOM    170  CB  ASP A  25      13.742  79.513  20.945  1.00 55.37           C  
ATOM    171  CG  ASP A  25      14.317  80.645  21.754  1.00 58.32           C  
ATOM    172  OD1 ASP A  25      15.493  80.890  21.443  1.00 55.98           O  
ATOM    173  OD2 ASP A  25      13.614  81.215  22.635  1.00 65.44           O  
ATOM    174  N   LYS A  26      16.704  78.342  20.398  1.00 48.97           N  
ATOM    175  CA  LYS A  26      17.633  77.244  20.626  1.00 47.26           C  
ATOM    176  C   LYS A  26      17.281  76.633  21.955  1.00 45.91           C  
ATOM    177  O   LYS A  26      17.131  77.308  22.973  1.00 47.17           O  
ATOM    178  CB  LYS A  26      19.053  77.782  20.557  1.00 45.69           C  
ATOM    179  CG  LYS A  26      20.014  76.810  21.257  1.00 56.40           C  
ATOM    180  CD  LYS A  26      21.383  77.484  21.284  1.00 70.31           C  
ATOM    181  CE  LYS A  26      22.434  76.613  20.611  1.00 77.20           C  
ATOM    182  NZ  LYS A  26      23.330  77.440  19.734  1.00 74.97           N  
ATOM    183  N   HIS A  27      17.141  75.346  22.035  1.00 45.05           N  
ATOM    184  CA  HIS A  27      16.791  74.749  23.349  1.00 50.37           C  
ATOM    185  C   HIS A  27      18.008  73.927  23.753  1.00 48.57           C  
ATOM    186  O   HIS A  27      18.539  73.204  22.910  1.00 49.17           O  
ATOM    187  CB  HIS A  27      15.529  73.906  23.289  1.00 55.91           C  
ATOM    188  CG  HIS A  27      14.228  74.610  23.136  1.00 65.65           C  
ATOM    189  ND1 HIS A  27      14.125  75.983  23.053  1.00 70.50           N  
ATOM    190  CD2 HIS A  27      12.958  74.126  23.020  1.00 72.39           C  
ATOM    191  CE1 HIS A  27      12.859  76.319  22.888  1.00 76.77           C  
ATOM    192  NE2 HIS A  27      12.111  75.207  22.876  1.00 75.23           N  
ATOM    193  N   THR A  28      18.422  73.980  24.998  1.00 45.99           N  
ATOM    194  CA  THR A  28      19.559  73.233  25.501  1.00 40.13           C  
ATOM    195  C   THR A  28      19.071  72.157  26.459  1.00 46.89           C  
ATOM    196  O   THR A  28      18.391  72.421  27.454  1.00 44.90           O  
ATOM    197  CB  THR A  28      20.638  74.109  26.132  1.00 40.44           C  
ATOM    198  OG1 THR A  28      21.251  74.986  25.125  1.00 41.60           O  
ATOM    199  CG2 THR A  28      21.782  73.258  26.683  1.00 37.69           C  
ATOM    200  N   TYR A  29      19.350  70.882  26.103  1.00 49.56           N  
ATOM    201  CA  TYR A  29      18.909  69.774  26.950  1.00 49.31           C  
ATOM    202  C   TYR A  29      20.128  69.167  27.611  1.00 49.56           C  
ATOM    203  O   TYR A  29      21.271  69.488  27.286  1.00 55.46           O  
ATOM    204  CB  TYR A  29      18.147  68.708  26.180  1.00 50.43           C  
ATOM    205  CG  TYR A  29      16.834  69.206  25.621  1.00 52.29           C  
ATOM    206  CD1 TYR A  29      16.778  69.947  24.422  1.00 53.66           C  
ATOM    207  CD2 TYR A  29      15.664  68.933  26.309  1.00 47.04           C  
ATOM    208  CE1 TYR A  29      15.539  70.395  23.966  1.00 55.32           C  
ATOM    209  CE2 TYR A  29      14.439  69.365  25.846  1.00 47.56           C  
ATOM    210  CZ  TYR A  29      14.376  70.086  24.680  1.00 52.28           C  
ATOM    211  OH  TYR A  29      13.141  70.512  24.264  1.00 52.64           O  
ATOM    212  N   HIS A  30      19.915  68.302  28.582  1.00 50.45           N  
ATOM    213  CA  HIS A  30      21.023  67.692  29.313  1.00 49.75           C  
ATOM    214  C   HIS A  30      20.902  66.190  29.380  1.00 50.08           C  
ATOM    215  O   HIS A  30      19.830  65.565  29.347  1.00 57.40           O  
ATOM    216  CB  HIS A  30      21.184  68.318  30.699  1.00 46.94           C  
ATOM    217  CG  HIS A  30      21.622  69.749  30.677  1.00 50.14           C  
ATOM    218  ND1 HIS A  30      20.752  70.793  30.479  1.00 57.40           N  
ATOM    219  CD2 HIS A  30      22.842  70.317  30.763  1.00 55.81           C  
ATOM    220  CE1 HIS A  30      21.410  71.950  30.460  1.00 58.45           C  
ATOM    221  NE2 HIS A  30      22.697  71.694  30.649  1.00 58.21           N  
ATOM    222  N   ILE A  31      22.025  65.511  29.267  1.00 45.80           N  
ATOM    223  CA  ILE A  31      22.020  64.045  29.322  1.00 41.56           C  
ATOM    224  C   ILE A  31      23.036  63.698  30.388  1.00 42.88           C  
ATOM    225  O   ILE A  31      24.102  64.326  30.468  1.00 45.46           O  
ATOM    226  CB  ILE A  31      22.412  63.469  27.954  1.00 43.45           C  
ATOM    227  CG1 ILE A  31      21.261  63.671  26.965  1.00 51.07           C  
ATOM    228  CG2 ILE A  31      22.777  62.018  27.997  1.00 44.94           C  
ATOM    229  CD1 ILE A  31      21.417  63.129  25.579  1.00 46.98           C  
ATOM    230  N   LYS A  32      22.684  62.783  31.266  1.00 40.51           N  
ATOM    231  CA  LYS A  32      23.644  62.382  32.292  1.00 42.04           C  
ATOM    232  C   LYS A  32      24.336  61.078  31.847  1.00 44.36           C  
ATOM    233  O   LYS A  32      23.659  60.112  31.509  1.00 42.99           O  
ATOM    234  CB  LYS A  32      22.931  62.181  33.606  1.00 38.51           C  
ATOM    235  CG  LYS A  32      23.929  61.930  34.754  1.00 43.38           C  
ATOM    236  CD  LYS A  32      23.139  62.276  36.036  1.00 51.55           C  
ATOM    237  CE  LYS A  32      23.980  61.934  37.250  1.00 58.38           C  
ATOM    238  NZ  LYS A  32      23.122  61.629  38.424  1.00 61.12           N  
ATOM    239  N   VAL A  33      25.665  61.060  31.799  1.00 41.60           N  
ATOM    240  CA  VAL A  33      26.372  59.837  31.449  1.00 41.68           C  
ATOM    241  C   VAL A  33      27.142  59.374  32.689  1.00 40.52           C  
ATOM    242  O   VAL A  33      27.829  60.203  33.272  1.00 41.90           O  
ATOM    243  CB  VAL A  33      27.364  60.018  30.292  1.00 40.01           C  
ATOM    244  CG1 VAL A  33      28.048  58.705  29.996  1.00 37.77           C  
ATOM    245  CG2 VAL A  33      26.737  60.547  29.027  1.00 35.93           C  
ATOM    246  N   ILE A  34      26.881  58.163  33.122  1.00 40.67           N  
ATOM    247  CA  ILE A  34      27.520  57.587  34.292  1.00 41.88           C  
ATOM    248  C   ILE A  34      28.354  56.359  33.891  1.00 40.98           C  
ATOM    249  O   ILE A  34      27.933  55.505  33.119  1.00 41.15           O  
ATOM    250  CB  ILE A  34      26.499  57.142  35.349  1.00 46.20           C  
ATOM    251  CG1 ILE A  34      25.557  58.304  35.707  1.00 48.50           C  
ATOM    252  CG2 ILE A  34      27.164  56.616  36.631  1.00 43.13           C  
ATOM    253  CD1 ILE A  34      24.137  57.841  36.022  1.00 41.69           C  
ATOM    254  N   ASN A  35      29.573  56.324  34.384  1.00 42.21           N  
ATOM    255  CA  ASN A  35      30.492  55.226  34.108  1.00 43.52           C  
ATOM    256  C   ASN A  35      30.248  54.180  35.195  1.00 46.65           C  
ATOM    257  O   ASN A  35      30.792  54.254  36.293  1.00 48.76           O  
ATOM    258  CB  ASN A  35      31.940  55.727  34.100  1.00 37.59           C  
ATOM    259  CG  ASN A  35      32.893  54.565  33.977  1.00 44.34           C  
ATOM    260  OD1 ASN A  35      32.495  53.422  33.699  1.00 44.64           O  
ATOM    261  ND2 ASN A  35      34.180  54.777  34.215  1.00 48.58           N  
ATOM    262  N   SER A  36      29.382  53.214  34.936  1.00 46.69           N  
ATOM    263  CA  SER A  36      29.055  52.203  35.913  1.00 51.03           C  
ATOM    264  C   SER A  36      30.159  51.130  36.040  1.00 52.80           C  
ATOM    265  O   SER A  36      30.032  50.254  36.909  1.00 53.69           O  
ATOM    266  CB  SER A  36      27.786  51.425  35.527  1.00 48.82           C  
ATOM    267  OG  SER A  36      26.775  52.078  34.854  1.00 53.86           O  
ATOM    268  N   SER A  37      31.101  51.096  35.113  1.00 49.83           N  
ATOM    269  CA  SER A  37      32.060  49.989  35.082  1.00 48.99           C  
ATOM    270  C   SER A  37      33.136  50.109  36.133  1.00 49.39           C  
ATOM    271  O   SER A  37      33.248  51.130  36.826  1.00 50.76           O  
ATOM    272  CB  SER A  37      32.685  49.970  33.675  1.00 48.59           C  
ATOM    273  OG  SER A  37      33.592  51.088  33.608  1.00 50.62           O  
ATOM    274  N   ALA A  38      34.014  49.089  36.196  1.00 47.53           N  
ATOM    275  CA  ALA A  38      35.086  49.194  37.195  1.00 45.34           C  
ATOM    276  C   ALA A  38      36.318  49.887  36.642  1.00 49.11           C  
ATOM    277  O   ALA A  38      37.323  50.030  37.366  1.00 52.14           O  
ATOM    278  CB  ALA A  38      35.415  47.834  37.742  1.00 39.49           C  
ATOM    279  N   ARG A  39      36.348  50.310  35.375  1.00 46.55           N  
ATOM    280  CA  ARG A  39      37.542  50.931  34.829  1.00 45.72           C  
ATOM    281  C   ARG A  39      37.332  52.326  34.290  1.00 45.01           C  
ATOM    282  O   ARG A  39      36.231  52.786  33.987  1.00 46.28           O  
ATOM    283  CB  ARG A  39      38.173  50.054  33.698  1.00 43.26           C  
ATOM    284  CG  ARG A  39      38.765  48.806  34.355  1.00 50.46           C  
ATOM    285  CD  ARG A  39      39.397  47.872  33.356  1.00 64.98           C  
ATOM    286  NE  ARG A  39      39.798  46.578  33.926  1.00 70.35           N  
ATOM    287  CZ  ARG A  39      38.998  45.545  34.177  1.00 69.49           C  
ATOM    288  NH1 ARG A  39      37.544  45.875  34.072  0.00 20.00           N  
ATOM    289  NH2 ARG A  39      39.264  44.376  34.338  0.00 20.00           N  
ATOM    290  N   ARG A  40      38.419  53.104  34.218  1.00 43.37           N  
ATOM    291  CA  ARG A  40      38.374  54.446  33.665  1.00 41.70           C  
ATOM    292  C   ARG A  40      38.073  54.368  32.166  1.00 41.82           C  
ATOM    293  O   ARG A  40      38.593  53.512  31.460  1.00 39.27           O  
ATOM    294  CB  ARG A  40      39.647  55.229  33.924  1.00 38.52           C  
ATOM    295  CG  ARG A  40      39.617  56.624  33.276  1.00 45.21           C  
ATOM    296  CD  ARG A  40      40.986  57.263  33.405  1.00 52.60           C  
ATOM    297  NE  ARG A  40      41.165  57.737  34.771  1.00 64.08           N  
ATOM    298  CZ  ARG A  40      42.222  58.465  35.158  1.00 63.28           C  
ATOM    299  NH1 ARG A  40      43.150  58.771  34.263  1.00 58.53           N  
ATOM    300  NH2 ARG A  40      42.249  58.867  36.428  1.00 57.20           N  
ATOM    301  N   ILE A  41      37.204  55.257  31.681  1.00 42.62           N  
ATOM    302  CA  ILE A  41      36.836  55.199  30.272  1.00 38.69           C  
ATOM    303  C   ILE A  41      36.934  56.595  29.675  1.00 39.31           C  
ATOM    304  O   ILE A  41      36.714  57.549  30.406  1.00 42.20           O  
ATOM    305  CB  ILE A  41      35.377  54.732  30.065  1.00 35.54           C  
ATOM    306  CG1 ILE A  41      34.430  55.726  30.782  1.00 35.53           C  
ATOM    307  CG2 ILE A  41      35.145  53.306  30.529  1.00 27.97           C  
ATOM    308  CD1 ILE A  41      32.961  55.438  30.566  1.00 29.98           C  
ATOM    309  N   GLY A  42      37.211  56.658  28.399  1.00 39.09           N  
ATOM    310  CA  GLY A  42      37.325  57.892  27.611  1.00 33.24           C  
ATOM    311  C   GLY A  42      36.078  57.817  26.722  1.00 39.29           C  
ATOM    312  O   GLY A  42      35.634  56.725  26.372  1.00 41.18           O  
ATOM    313  N   TYR A  43      35.461  58.952  26.430  1.00 40.86           N  
ATOM    314  CA  TYR A  43      34.225  58.896  25.665  1.00 37.79           C  
ATOM    315  C   TYR A  43      34.203  60.018  24.645  1.00 38.95           C  
ATOM    316  O   TYR A  43      34.764  61.094  24.863  1.00 41.07           O  
ATOM    317  CB  TYR A  43      33.007  59.013  26.622  1.00 39.83           C  
ATOM    318  CG  TYR A  43      32.834  60.366  27.276  1.00 42.25           C  
ATOM    319  CD1 TYR A  43      32.254  61.438  26.610  1.00 39.71           C  
ATOM    320  CD2 TYR A  43      33.290  60.585  28.583  1.00 43.29           C  
ATOM    321  CE1 TYR A  43      32.136  62.681  27.202  1.00 38.62           C  
ATOM    322  CE2 TYR A  43      33.158  61.821  29.198  1.00 43.79           C  
ATOM    323  CZ  TYR A  43      32.608  62.873  28.477  1.00 43.50           C  
ATOM    324  OH  TYR A  43      32.489  64.115  29.052  1.00 47.83           O  
ATOM    325  N   GLY A  44      33.502  59.759  23.551  1.00 37.80           N  
ATOM    326  CA  GLY A  44      33.336  60.838  22.542  1.00 34.98           C  
ATOM    327  C   GLY A  44      31.829  60.833  22.216  1.00 38.32           C  
ATOM    328  O   GLY A  44      31.177  59.796  22.327  1.00 42.02           O  
ATOM    329  N   ILE A  45      31.284  62.004  21.945  1.00 35.28           N  
ATOM    330  CA  ILE A  45      29.911  62.163  21.594  1.00 37.32           C  
ATOM    331  C   ILE A  45      29.812  62.597  20.139  1.00 39.47           C  
ATOM    332  O   ILE A  45      30.618  63.413  19.715  1.00 41.46           O  
ATOM    333  CB  ILE A  45      29.222  63.254  22.435  1.00 39.06           C  
ATOM    334  CG1 ILE A  45      29.421  63.001  23.931  1.00 37.34           C  
ATOM    335  CG2 ILE A  45      27.731  63.243  22.061  1.00 32.14           C  
ATOM    336  CD1 ILE A  45      28.852  61.667  24.382  1.00 39.81           C  
ATOM    337  N   LYS A  46      28.851  62.089  19.409  1.00 40.60           N  
ATOM    338  CA  LYS A  46      28.609  62.470  18.029  1.00 44.24           C  
ATOM    339  C   LYS A  46      27.138  62.696  17.771  1.00 44.18           C  
ATOM    340  O   LYS A  46      26.283  62.135  18.467  1.00 43.37           O  
ATOM    341  CB  LYS A  46      29.092  61.406  17.012  1.00 45.73           C  
ATOM    342  CG  LYS A  46      30.611  61.264  17.068  1.00 59.69           C  
ATOM    343  CD  LYS A  46      31.227  60.782  15.782  1.00 66.68           C  
ATOM    344  CE  LYS A  46      32.724  60.514  15.945  1.00 78.19           C  
ATOM    345  NZ  LYS A  46      33.134  59.237  15.269  1.00 82.94           N  
ATOM    346  N   THR A  47      26.812  63.557  16.802  1.00 48.56           N  
ATOM    347  CA  THR A  47      25.414  63.765  16.451  1.00 49.98           C  
ATOM    348  C   THR A  47      25.264  63.629  14.931  1.00 46.85           C  
ATOM    349  O   THR A  47      26.236  63.836  14.219  1.00 44.64           O  
ATOM    350  CB  THR A  47      24.741  65.060  16.888  1.00 49.58           C  
ATOM    351  OG1 THR A  47      24.758  65.951  15.760  1.00 43.65           O  
ATOM    352  CG2 THR A  47      25.364  65.644  18.127  1.00 47.56           C  
ATOM    353  N   THR A  48      24.061  63.350  14.492  1.00 47.07           N  
ATOM    354  CA  THR A  48      23.715  63.210  13.084  1.00 44.86           C  
ATOM    355  C   THR A  48      23.451  64.552  12.431  1.00 45.01           C  
ATOM    356  O   THR A  48      23.202  64.606  11.219  1.00 46.48           O  
ATOM    357  CB  THR A  48      22.436  62.353  12.946  1.00 44.69           C  
ATOM    358  OG1 THR A  48      21.510  62.735  13.998  1.00 51.53           O  
ATOM    359  CG2 THR A  48      22.804  60.901  13.088  1.00 35.27           C  
ATOM    360  N   ASN A  49      23.505  65.629  13.210  1.00 44.23           N  
ATOM    361  CA  ASN A  49      23.206  66.919  12.515  1.00 48.41           C  
ATOM    362  C   ASN A  49      24.034  67.996  13.170  1.00 53.95           C  
ATOM    363  O   ASN A  49      23.618  68.623  14.145  1.00 54.04           O  
ATOM    364  CB  ASN A  49      21.712  67.099  12.657  1.00 52.43           C  
ATOM    365  CG  ASN A  49      21.051  67.991  11.650  1.00 58.45           C  
ATOM    366  OD1 ASN A  49      21.625  68.990  11.202  1.00 63.39           O  
ATOM    367  ND2 ASN A  49      19.823  67.608  11.298  1.00 61.62           N  
ATOM    368  N   MET A  50      25.284  68.147  12.691  1.00 57.09           N  
ATOM    369  CA  MET A  50      26.181  69.147  13.253  1.00 57.02           C  
ATOM    370  C   MET A  50      25.585  70.550  13.140  1.00 55.27           C  
ATOM    371  O   MET A  50      25.680  71.353  14.107  1.00 55.46           O  
ATOM    372  CB  MET A  50      27.539  69.029  12.573  1.00 67.47           C  
ATOM    373  CG  MET A  50      28.239  67.680  12.811  1.00 78.61           C  
ATOM    374  SD  MET A  50      29.948  67.685  12.182  1.00 84.40           S  
ATOM    375  CE  MET A  50      29.629  68.135  10.444  1.00 75.91           C  
ATOM    376  N   LYS A  51      24.878  70.874  12.056  1.00 48.01           N  
ATOM    377  CA  LYS A  51      24.313  72.208  11.894  1.00 53.95           C  
ATOM    378  C   LYS A  51      23.310  72.600  12.981  1.00 56.36           C  
ATOM    379  O   LYS A  51      23.389  73.702  13.516  1.00 54.58           O  
ATOM    380  CB  LYS A  51      23.649  72.416  10.526  1.00 51.93           C  
ATOM    381  CG  LYS A  51      24.884  72.559   9.672  0.00 20.00           C  
ATOM    382  CD  LYS A  51      24.279  73.014   8.357  0.00 20.00           C  
ATOM    383  CE  LYS A  51      25.295  72.937   7.227  0.00 20.00           C  
ATOM    384  NZ  LYS A  51      24.718  73.384   5.930  0.00 20.00           N  
ATOM    385  N   ARG A  52      22.376  71.727  13.296  1.00 56.00           N  
ATOM    386  CA  ARG A  52      21.334  71.920  14.277  1.00 51.87           C  
ATOM    387  C   ARG A  52      21.766  71.434  15.648  1.00 52.83           C  
ATOM    388  O   ARG A  52      21.450  72.060  16.675  1.00 53.48           O  
ATOM    389  CB  ARG A  52      20.076  71.155  13.793  1.00 48.06           C  
ATOM    390  CG  ARG A  52      18.993  70.913  14.773  1.00 59.26           C  
ATOM    391  CD  ARG A  52      17.821  70.059  14.369  1.00 57.22           C  
ATOM    392  NE  ARG A  52      17.397  70.171  12.986  1.00 57.82           N  
ATOM    393  CZ  ARG A  52      16.917  69.108  12.339  1.00 63.03           C  
ATOM    394  NH1 ARG A  52      16.865  67.980  13.049  1.00 67.60           N  
ATOM    395  NH2 ARG A  52      16.492  69.021  11.093  1.00 62.84           N  
ATOM    396  N   LEU A  53      22.527  70.321  15.731  1.00 47.73           N  
ATOM    397  CA  LEU A  53      22.828  69.791  17.050  1.00 45.48           C  
ATOM    398  C   LEU A  53      24.238  69.974  17.523  1.00 45.70           C  
ATOM    399  O   LEU A  53      25.193  69.703  16.801  1.00 54.20           O  
ATOM    400  CB  LEU A  53      22.456  68.304  17.156  1.00 45.54           C  
ATOM    401  CG  LEU A  53      21.046  67.926  16.683  1.00 41.16           C  
ATOM    402  CD1 LEU A  53      21.021  66.414  16.562  1.00 38.06           C  
ATOM    403  CD2 LEU A  53      19.999  68.469  17.650  1.00 44.71           C  
ATOM    404  N   GLY A  54      24.414  70.215  18.803  1.00 43.73           N  
ATOM    405  CA  GLY A  54      25.689  70.451  19.435  1.00 39.32           C  
ATOM    406  C   GLY A  54      25.715  69.815  20.818  1.00 45.56           C  
ATOM    407  O   GLY A  54      24.693  69.763  21.524  1.00 49.71           O  
ATOM    408  N   VAL A  55      26.839  69.208  21.159  1.00 47.39           N  
ATOM    409  CA  VAL A  55      27.060  68.571  22.430  1.00 48.64           C  
ATOM    410  C   VAL A  55      28.328  69.168  23.073  1.00 48.80           C  
ATOM    411  O   VAL A  55      29.302  69.488  22.414  1.00 47.36           O  
ATOM    412  CB  VAL A  55      27.219  67.057  22.356  1.00 49.16           C  
ATOM    413  CG1 VAL A  55      27.222  66.417  23.748  1.00 44.92           C  
ATOM    414  CG2 VAL A  55      26.140  66.431  21.471  1.00 49.73           C  
ATOM    415  N   ASP A  56      28.228  69.312  24.388  1.00 47.28           N  
ATOM    416  CA  ASP A  56      29.293  69.885  25.170  1.00 48.18           C  
ATOM    417  C   ASP A  56      29.299  69.409  26.601  1.00 45.95           C  
ATOM    418  O   ASP A  56      28.321  69.653  27.292  1.00 46.98           O  
ATOM    419  CB  ASP A  56      29.007  71.404  25.174  1.00 54.45           C  
ATOM    420  CG  ASP A  56      30.198  72.204  25.670  1.00 65.17           C  
ATOM    421  OD1 ASP A  56      31.087  71.625  26.340  1.00 63.34           O  
ATOM    422  OD2 ASP A  56      30.227  73.428  25.366  1.00 70.96           O  
ATOM    423  N   PRO A  57      30.366  68.816  27.090  1.00 45.21           N  
ATOM    424  CA  PRO A  57      31.568  68.540  26.335  1.00 48.46           C  
ATOM    425  C   PRO A  57      31.347  67.416  25.318  1.00 49.85           C  
ATOM    426  O   PRO A  57      30.632  66.458  25.606  1.00 52.09           O  
ATOM    427  CB  PRO A  57      32.564  68.035  27.392  1.00 47.51           C  
ATOM    428  CG  PRO A  57      31.692  67.452  28.457  1.00 47.57           C  
ATOM    429  CD  PRO A  57      30.469  68.324  28.484  1.00 43.56           C  
ATOM    430  N   PRO A  58      32.077  67.478  24.225  1.00 49.00           N  
ATOM    431  CA  PRO A  58      31.991  66.508  23.150  1.00 47.61           C  
ATOM    432  C   PRO A  58      32.869  65.304  23.401  1.00 47.21           C  
ATOM    433  O   PRO A  58      32.801  64.318  22.667  1.00 48.25           O  
ATOM    434  CB  PRO A  58      32.377  67.333  21.927  1.00 47.50           C  
ATOM    435  CG  PRO A  58      33.373  68.324  22.447  1.00 48.90           C  
ATOM    436  CD  PRO A  58      33.006  68.585  23.881  1.00 48.87           C  
ATOM    437  N   CYS A  59      33.682  65.307  24.455  1.00 44.35           N  
ATOM    438  CA  CYS A  59      34.535  64.162  24.748  1.00 42.59           C  
ATOM    439  C   CYS A  59      35.059  64.382  26.160  1.00 41.54           C  
ATOM    440  O   CYS A  59      35.050  65.531  26.575  1.00 42.84           O  
ATOM    441  CB  CYS A  59      35.701  64.026  23.780  1.00 49.04           C  
ATOM    442  SG  CYS A  59      36.818  65.450  23.588  1.00 52.19           S  
ATOM    443  N   GLY A  60      35.430  63.328  26.847  1.00 41.99           N  
ATOM    444  CA  GLY A  60      35.964  63.471  28.192  1.00 42.53           C  
ATOM    445  C   GLY A  60      36.481  62.125  28.721  1.00 42.07           C  
ATOM    446  O   GLY A  60      36.515  61.166  27.952  1.00 40.26           O  
ATOM    447  N   VAL A  61      36.722  62.094  30.032  1.00 40.16           N  
ATOM    448  CA  VAL A  61      37.197  60.887  30.714  1.00 41.21           C  
ATOM    449  C   VAL A  61      36.345  60.726  31.963  1.00 43.96           C  
ATOM    450  O   VAL A  61      35.958  61.722  32.561  1.00 50.28           O  
ATOM    451  CB  VAL A  61      38.685  60.950  31.078  1.00 40.24           C  
ATOM    452  CG1 VAL A  61      39.247  59.755  31.839  1.00 34.36           C  
ATOM    453  CG2 VAL A  61      39.522  61.048  29.791  1.00 39.26           C  
ATOM    454  N   LEU A  62      36.043  59.523  32.370  1.00 43.28           N  
ATOM    455  CA  LEU A  62      35.174  59.249  33.508  1.00 42.60           C  
ATOM    456  C   LEU A  62      35.754  58.115  34.352  1.00 46.44           C  
ATOM    457  O   LEU A  62      35.987  56.992  33.870  1.00 43.46           O  
ATOM    458  CB  LEU A  62      33.814  58.897  32.947  1.00 41.27           C  
ATOM    459  CG  LEU A  62      32.579  59.744  33.048  1.00 44.26           C  
ATOM    460  CD1 LEU A  62      32.734  61.186  33.502  1.00 39.65           C  
ATOM    461  CD2 LEU A  62      31.781  59.716  31.752  1.00 37.71           C  
ATOM    462  N   ASP A  63      36.100  58.473  35.614  1.00 45.63           N  
ATOM    463  CA  ASP A  63      36.670  57.422  36.461  1.00 47.25           C  
ATOM    464  C   ASP A  63      35.542  56.457  36.781  1.00 47.53           C  
ATOM    465  O   ASP A  63      34.393  56.772  36.530  1.00 47.86           O  
ATOM    466  CB  ASP A  63      37.294  57.921  37.754  1.00 48.66           C  
ATOM    467  CG  ASP A  63      38.708  58.450  37.500  1.00 59.34           C  
ATOM    468  OD1 ASP A  63      39.609  57.648  37.120  1.00 60.37           O  
ATOM    469  OD2 ASP A  63      38.776  59.701  37.665  1.00 54.41           O  
ATOM    470  N   PRO A  64      35.852  55.307  37.351  1.00 47.81           N  
ATOM    471  CA  PRO A  64      34.787  54.375  37.720  1.00 48.50           C  
ATOM    472  C   PRO A  64      33.799  55.136  38.592  1.00 51.06           C  
ATOM    473  O   PRO A  64      34.264  55.908  39.443  1.00 50.28           O  
ATOM    474  CB  PRO A  64      35.500  53.267  38.510  1.00 43.30           C  
ATOM    475  CG  PRO A  64      36.929  53.383  38.149  1.00 35.17           C  
ATOM    476  CD  PRO A  64      37.196  54.792  37.690  1.00 40.20           C  
ATOM    477  N   LYS A  65      32.515  54.956  38.368  1.00 52.45           N  
ATOM    478  CA  LYS A  65      31.396  55.520  39.067  1.00 47.93           C  
ATOM    479  C   LYS A  65      31.217  57.012  38.946  1.00 47.17           C  
ATOM    480  O   LYS A  65      30.249  57.577  39.497  1.00 53.89           O  
ATOM    481  CB  LYS A  65      31.326  55.053  40.529  1.00 53.37           C  
ATOM    482  CG  LYS A  65      31.094  53.535  40.656  1.00 56.44           C  
ATOM    483  CD  LYS A  65      31.240  53.202  42.259  0.00 61.11           C  
ATOM    484  CE  LYS A  65      31.210  51.694  42.516  0.00 71.17           C  
ATOM    485  NZ  LYS A  65      31.073  51.356  43.940  0.00 69.79           N  
ATOM    486  N   GLU A  66      32.023  57.713  38.166  1.00 43.42           N  
ATOM    487  CA  GLU A  66      31.922  59.133  37.932  1.00 42.51           C  
ATOM    488  C   GLU A  66      30.913  59.386  36.807  1.00 48.53           C  
ATOM    489  O   GLU A  66      30.784  58.637  35.846  1.00 50.31           O  
ATOM    490  CB  GLU A  66      33.242  59.806  37.617  1.00 41.13           C  
ATOM    491  CG  GLU A  66      33.298  61.229  37.113  1.00 38.40           C  
ATOM    492  CD  GLU A  66      34.720  61.683  36.808  1.00 53.20           C  
ATOM    493  OE1 GLU A  66      35.678  60.866  36.946  1.00 56.92           O  
ATOM    494  OE2 GLU A  66      34.943  62.849  36.384  1.00 55.60           O  
ATOM    495  N   ALA A  67      30.230  60.522  36.898  1.00 50.29           N  
ATOM    496  CA  ALA A  67      29.231  60.975  35.976  1.00 45.23           C  
ATOM    497  C   ALA A  67      29.555  62.332  35.384  1.00 41.80           C  
ATOM    498  O   ALA A  67      30.250  63.118  35.998  1.00 47.43           O  
ATOM    499  CB  ALA A  67      27.889  61.137  36.715  1.00 47.42           C  
ATOM    500  N   VAL A  68      29.045  62.588  34.214  1.00 40.67           N  
ATOM    501  CA  VAL A  68      29.222  63.882  33.569  1.00 40.23           C  
ATOM    502  C   VAL A  68      27.859  64.325  32.988  1.00 43.75           C  
ATOM    503  O   VAL A  68      27.034  63.467  32.639  1.00 48.20           O  
ATOM    504  CB  VAL A  68      30.261  63.887  32.474  1.00 40.89           C  
ATOM    505  CG1 VAL A  68      29.923  62.871  31.386  1.00 36.34           C  
ATOM    506  CG2 VAL A  68      30.370  65.297  31.868  1.00 37.31           C  
ATOM    507  N   LEU A  69      27.570  65.599  33.031  1.00 41.39           N  
ATOM    508  CA  LEU A  69      26.293  66.127  32.545  1.00 46.50           C  
ATOM    509  C   LEU A  69      26.560  66.930  31.273  1.00 47.89           C  
ATOM    510  O   LEU A  69      27.300  67.902  31.214  1.00 49.08           O  
ATOM    511  CB  LEU A  69      25.571  66.913  33.614  1.00 45.04           C  
ATOM    512  CG  LEU A  69      24.108  67.280  33.396  1.00 49.17           C  
ATOM    513  CD1 LEU A  69      23.156  66.108  33.495  1.00 39.50           C  
ATOM    514  CD2 LEU A  69      23.716  68.368  34.388  1.00 45.72           C  
ATOM    515  N   LEU A  70      26.041  66.399  30.164  1.00 48.34           N  
ATOM    516  CA  LEU A  70      26.285  66.943  28.854  1.00 41.62           C  
ATOM    517  C   LEU A  70      25.176  67.858  28.436  1.00 42.27           C  
ATOM    518  O   LEU A  70      24.009  67.561  28.682  1.00 41.52           O  
ATOM    519  CB  LEU A  70      26.347  65.777  27.838  1.00 41.35           C  
ATOM    520  CG  LEU A  70      27.465  64.792  28.191  1.00 41.90           C  
ATOM    521  CD1 LEU A  70      27.302  63.565  27.305  1.00 45.04           C  
ATOM    522  CD2 LEU A  70      28.833  65.445  28.101  1.00 39.69           C  
ATOM    523  N   ALA A  71      25.607  68.849  27.675  1.00 41.53           N  
ATOM    524  CA  ALA A  71      24.601  69.808  27.191  1.00 42.88           C  
ATOM    525  C   ALA A  71      24.447  69.577  25.693  1.00 42.25           C  
ATOM    526  O   ALA A  71      25.347  69.706  24.851  1.00 42.03           O  
ATOM    527  CB  ALA A  71      24.993  71.199  27.603  1.00 38.12           C  
ATOM    528  N   VAL A  72      23.220  69.214  25.361  1.00 41.23           N  
ATOM    529  CA  VAL A  72      22.820  68.961  23.995  1.00 44.39           C  
ATOM    530  C   VAL A  72      21.937  70.101  23.505  1.00 46.74           C  
ATOM    531  O   VAL A  72      20.787  70.173  23.948  1.00 47.54           O  
ATOM    532  CB  VAL A  72      22.003  67.650  23.905  1.00 44.24           C  
ATOM    533  CG1 VAL A  72      21.731  67.324  22.439  1.00 46.15           C  
ATOM    534  CG2 VAL A  72      22.788  66.547  24.601  1.00 43.16           C  
ATOM    535  N   SER A  73      22.491  70.935  22.652  1.00 47.12           N  
ATOM    536  CA  SER A  73      21.695  72.046  22.140  1.00 48.83           C  
ATOM    537  C   SER A  73      21.064  71.688  20.799  1.00 50.49           C  
ATOM    538  O   SER A  73      21.601  70.936  19.978  1.00 51.81           O  
ATOM    539  CB  SER A  73      22.589  73.278  22.041  1.00 49.20           C  
ATOM    540  OG  SER A  73      23.935  72.919  21.946  1.00 57.73           O  
ATOM    541  N   CYS A  74      19.901  72.268  20.571  1.00 48.58           N  
ATOM    542  CA  CYS A  74      19.123  72.151  19.348  1.00 44.59           C  
ATOM    543  C   CYS A  74      18.737  73.539  18.851  1.00 45.93           C  
ATOM    544  O   CYS A  74      17.933  74.291  19.405  1.00 47.12           O  
ATOM    545  CB  CYS A  74      17.921  71.249  19.618  1.00 39.68           C  
ATOM    546  SG  CYS A  74      16.971  70.922  18.113  1.00 45.43           S  
ATOM    547  N   ASP A  75      19.405  74.000  17.795  1.00 49.07           N  
ATOM    548  CA  ASP A  75      19.157  75.307  17.241  1.00 50.45           C  
ATOM    549  C   ASP A  75      17.675  75.458  16.848  1.00 50.99           C  
ATOM    550  O   ASP A  75      16.947  74.483  16.735  1.00 51.40           O  
ATOM    551  CB  ASP A  75      19.988  75.500  15.963  1.00 47.86           C  
ATOM    552  CG  ASP A  75      20.458  76.949  15.832  1.00 53.46           C  
ATOM    553  OD1 ASP A  75      20.085  77.773  16.700  1.00 45.71           O  
ATOM    554  OD2 ASP A  75      21.223  77.205  14.876  1.00 55.09           O  
ATOM    555  N   ALA A  76      17.285  76.706  16.652  1.00 46.76           N  
ATOM    556  CA  ALA A  76      15.982  77.010  16.065  1.00 42.82           C  
ATOM    557  C   ALA A  76      16.037  76.408  14.651  1.00 40.50           C  
ATOM    558  O   ALA A  76      17.158  76.404  14.086  1.00 39.47           O  
ATOM    559  CB  ALA A  76      15.922  78.542  15.984  1.00 44.50           C  
ATOM    560  N   PHE A  77      14.950  75.951  14.089  1.00 40.31           N  
ATOM    561  CA  PHE A  77      14.919  75.377  12.742  1.00 42.92           C  
ATOM    562  C   PHE A  77      13.443  75.292  12.349  1.00 45.36           C  
ATOM    563  O   PHE A  77      12.606  75.374  13.240  1.00 43.47           O  
ATOM    564  CB  PHE A  77      15.580  73.994  12.708  1.00 46.42           C  
ATOM    565  CG  PHE A  77      14.943  72.892  13.503  1.00 46.24           C  
ATOM    566  CD1 PHE A  77      14.889  72.959  14.880  1.00 48.03           C  
ATOM    567  CD2 PHE A  77      14.377  71.786  12.905  1.00 48.98           C  
ATOM    568  CE1 PHE A  77      14.290  71.971  15.630  1.00 54.12           C  
ATOM    569  CE2 PHE A  77      13.798  70.774  13.653  1.00 50.19           C  
ATOM    570  CZ  PHE A  77      13.738  70.864  15.014  1.00 50.97           C  
ATOM    571  N   ALA A  78      13.175  75.089  11.071  1.00 52.51           N  
ATOM    572  CA  ALA A  78      11.797  74.980  10.578  1.00 53.45           C  
ATOM    573  C   ALA A  78      11.457  73.486  10.437  1.00 53.96           C  
ATOM    574  O   ALA A  78      11.639  72.773   9.456  1.00 50.53           O  
ATOM    575  CB  ALA A  78      11.516  75.709   9.295  1.00 53.65           C  
ATOM    576  N   PHE A  79      10.945  73.023  11.569  1.00 52.99           N  
ATOM    577  CA  PHE A  79      10.452  71.686  11.789  1.00 50.85           C  
ATOM    578  C   PHE A  79       9.396  71.308  10.739  1.00 50.94           C  
ATOM    579  O   PHE A  79       9.370  70.203  10.176  1.00 49.95           O  
ATOM    580  CB  PHE A  79       9.762  71.665  13.169  1.00 43.12           C  
ATOM    581  CG  PHE A  79       9.130  70.330  13.460  1.00 40.88           C  
ATOM    582  CD1 PHE A  79       9.843  69.305  14.047  1.00 33.76           C  
ATOM    583  CD2 PHE A  79       7.831  70.069  13.053  1.00 36.41           C  
ATOM    584  CE1 PHE A  79       9.242  68.093  14.298  1.00 36.72           C  
ATOM    585  CE2 PHE A  79       7.258  68.834  13.223  1.00 30.85           C  
ATOM    586  CZ  PHE A  79       7.933  67.836  13.882  1.00 29.68           C  
ATOM    587  N   GLY A  80       8.487  72.262  10.496  1.00 44.41           N  
ATOM    588  CA  GLY A  80       7.434  72.118   9.542  1.00 50.66           C  
ATOM    589  C   GLY A  80       7.853  71.836   8.119  1.00 57.18           C  
ATOM    590  O   GLY A  80       6.965  71.555   7.304  1.00 60.70           O  
ATOM    591  N   GLN A  81       9.126  72.036   7.760  1.00 58.88           N  
ATOM    592  CA  GLN A  81       9.586  71.790   6.417  1.00 59.59           C  
ATOM    593  C   GLN A  81      10.779  70.868   6.282  1.00 63.27           C  
ATOM    594  O   GLN A  81      11.175  70.755   5.118  1.00 63.97           O  
ATOM    595  CB  GLN A  81      10.028  73.100   5.763  1.00 58.94           C  
ATOM    596  CG  GLN A  81       9.027  74.204   5.887  1.00 59.01           C  
ATOM    597  CD  GLN A  81       9.543  75.586   5.592  1.00 57.70           C  
ATOM    598  OE1 GLN A  81       8.873  76.528   6.010  1.00 58.21           O  
ATOM    599  NE2 GLN A  81      10.664  75.753   4.916  1.00 59.05           N  
ATOM    600  N   GLU A  82      11.327  70.368   7.371  1.00 67.91           N  
ATOM    601  CA  GLU A  82      12.505  69.522   7.319  1.00 69.75           C  
ATOM    602  C   GLU A  82      12.277  68.084   7.738  1.00 69.74           C  
ATOM    603  O   GLU A  82      11.208  67.590   8.030  1.00 68.31           O  
ATOM    604  CB  GLU A  82      13.648  70.147   8.137  1.00 75.36           C  
ATOM    605  CG  GLU A  82      14.214  71.465   7.588  1.00 76.21           C  
ATOM    606  CD  GLU A  82      15.070  72.176   8.619  1.00 79.97           C  
ATOM    607  OE1 GLU A  82      15.510  71.465   9.567  1.00 81.98           O  
ATOM    608  OE2 GLU A  82      15.293  73.403   8.538  1.00 80.88           O  
ATOM    609  N   ASP A  83      13.361  67.320   7.654  1.00 74.61           N  
ATOM    610  CA  ASP A  83      13.447  65.920   8.005  1.00 72.01           C  
ATOM    611  C   ASP A  83      13.744  65.886   9.500  1.00 68.24           C  
ATOM    612  O   ASP A  83      14.594  66.694   9.904  1.00 70.54           O  
ATOM    613  CB  ASP A  83      14.690  65.282   7.335  1.00 76.62           C  
ATOM    614  CG  ASP A  83      14.319  65.430   5.733  0.00 99.68           C  
ATOM    615  OD1 ASP A  83      13.119  65.652   5.312  0.00102.62           O  
ATOM    616  OD2 ASP A  83      15.294  65.350   4.898  0.00102.62           O  
ATOM    617  N   THR A  84      12.953  65.125  10.243  1.00 62.52           N  
ATOM    618  CA  THR A  84      13.249  64.996  11.661  1.00 54.15           C  
ATOM    619  C   THR A  84      13.133  63.553  12.128  1.00 52.22           C  
ATOM    620  O   THR A  84      13.194  63.286  13.337  1.00 50.54           O  
ATOM    621  CB  THR A  84      12.466  65.862  12.616  1.00 52.54           C  
ATOM    622  OG1 THR A  84      11.083  65.570  12.639  1.00 53.46           O  
ATOM    623  CG2 THR A  84      12.734  67.342  12.379  1.00 62.30           C  
ATOM    624  N   ASN A  85      12.984  62.593  11.212  1.00 49.43           N  
ATOM    625  CA  ASN A  85      12.890  61.221  11.752  1.00 57.07           C  
ATOM    626  C   ASN A  85      14.272  60.597  11.836  1.00 59.89           C  
ATOM    627  O   ASN A  85      14.407  59.403  12.134  1.00 59.92           O  
ATOM    628  CB  ASN A  85      11.881  60.408  10.953  1.00 59.39           C  
ATOM    629  CG  ASN A  85      12.365  60.244   9.517  1.00 75.02           C  
ATOM    630  OD1 ASN A  85      12.960  61.142   8.884  1.00 74.19           O  
ATOM    631  ND2 ASN A  85      12.086  59.041   9.010  1.00 78.85           N  
ATOM    632  N   ASN A  86      15.380  61.337  11.612  1.00 58.48           N  
ATOM    633  CA  ASN A  86      16.687  60.748  11.667  1.00 61.79           C  
ATOM    634  C   ASN A  86      17.754  61.345  12.532  1.00 57.83           C  
ATOM    635  O   ASN A  86      18.954  61.208  12.273  1.00 55.62           O  
ATOM    636  CB  ASN A  86      17.240  60.576  10.228  1.00 72.34           C  
ATOM    637  CG  ASN A  86      16.619  59.303   9.640  1.00 82.54           C  
ATOM    638  OD1 ASN A  86      16.373  58.316  10.341  1.00 89.97           O  
ATOM    639  ND2 ASN A  86      16.317  59.432   8.363  1.00 86.26           N  
ATOM    640  N   ASP A  87      17.430  61.959  13.655  1.00 54.00           N  
ATOM    641  CA  ASP A  87      18.491  62.499  14.484  1.00 48.89           C  
ATOM    642  C   ASP A  87      18.780  61.553  15.642  1.00 46.57           C  
ATOM    643  O   ASP A  87      17.861  60.939  16.180  1.00 45.38           O  
ATOM    644  CB  ASP A  87      18.178  63.896  14.971  1.00 46.12           C  
ATOM    645  CG  ASP A  87      18.122  64.919  13.850  1.00 50.63           C  
ATOM    646  OD1 ASP A  87      18.697  64.635  12.781  1.00 53.46           O  
ATOM    647  OD2 ASP A  87      17.520  66.001  14.046  1.00 52.07           O  
ATOM    648  N   ARG A  88      20.070  61.482  15.966  1.00 43.35           N  
ATOM    649  CA  ARG A  88      20.450  60.712  17.137  1.00 45.47           C  
ATOM    650  C   ARG A  88      21.730  61.244  17.749  1.00 42.79           C  
ATOM    651  O   ARG A  88      22.463  62.004  17.113  1.00 46.79           O  
ATOM    652  CB  ARG A  88      20.597  59.226  16.868  1.00 48.62           C  
ATOM    653  CG  ARG A  88      21.638  58.827  15.896  1.00 57.25           C  
ATOM    654  CD  ARG A  88      21.294  57.524  15.155  1.00 60.72           C  
ATOM    655  NE  ARG A  88      22.556  56.947  14.616  1.00 59.76           N  
ATOM    656  CZ  ARG A  88      22.460  55.764  14.361  0.00 83.85           C  
ATOM    657  NH1 ARG A  88      21.440  54.900  14.521  0.00 88.29           N  
ATOM    658  NH2 ARG A  88      23.559  55.403  13.747  0.00 87.37           N  
ATOM    659  N   ILE A  89      21.898  60.978  19.018  1.00 37.54           N  
ATOM    660  CA  ILE A  89      23.127  61.375  19.710  1.00 36.84           C  
ATOM    661  C   ILE A  89      23.855  60.049  19.936  1.00 39.75           C  
ATOM    662  O   ILE A  89      23.137  59.078  20.231  1.00 40.33           O  
ATOM    663  CB  ILE A  89      22.764  62.071  21.007  1.00 36.70           C  
ATOM    664  CG1 ILE A  89      22.363  63.518  20.636  1.00 34.73           C  
ATOM    665  CG2 ILE A  89      23.861  62.098  22.050  1.00 28.43           C  
ATOM    666  CD1 ILE A  89      21.469  64.098  21.705  1.00 47.82           C  
ATOM    667  N   THR A  90      25.143  59.976  19.683  1.00 35.94           N  
ATOM    668  CA  THR A  90      25.878  58.741  19.900  1.00 35.38           C  
ATOM    669  C   THR A  90      26.993  58.924  20.939  1.00 36.58           C  
ATOM    670  O   THR A  90      27.858  59.823  20.827  1.00 33.35           O  
ATOM    671  CB  THR A  90      26.582  58.308  18.582  1.00 39.28           C  
ATOM    672  OG1 THR A  90      25.584  58.168  17.546  1.00 43.57           O  
ATOM    673  CG2 THR A  90      27.257  56.956  18.789  1.00 34.20           C  
ATOM    674  N   VAL A  91      26.955  58.056  21.940  1.00 36.13           N  
ATOM    675  CA  VAL A  91      27.981  58.003  22.971  1.00 37.04           C  
ATOM    676  C   VAL A  91      28.920  56.844  22.638  1.00 38.98           C  
ATOM    677  O   VAL A  91      28.465  55.683  22.692  1.00 35.51           O  
ATOM    678  CB  VAL A  91      27.375  57.669  24.354  1.00 38.92           C  
ATOM    679  CG1 VAL A  91      28.439  57.781  25.464  1.00 38.88           C  
ATOM    680  CG2 VAL A  91      26.231  58.603  24.678  1.00 38.70           C  
ATOM    681  N   GLU A  92      30.166  57.169  22.378  1.00 45.78           N  
ATOM    682  CA  GLU A  92      31.195  56.148  22.102  1.00 44.83           C  
ATOM    683  C   GLU A  92      32.189  56.174  23.277  1.00 44.91           C  
ATOM    684  O   GLU A  92      32.497  57.272  23.741  1.00 42.89           O  
ATOM    685  CB  GLU A  92      31.965  56.361  20.827  1.00 46.00           C  
ATOM    686  CG  GLU A  92      31.200  56.228  19.543  1.00 57.24           C  
ATOM    687  CD  GLU A  92      31.932  56.418  18.233  1.00 60.47           C  
ATOM    688  OE1 GLU A  92      33.106  56.868  18.171  1.00 61.83           O  
ATOM    689  OE2 GLU A  92      31.313  56.057  17.195  1.00 56.85           O  
ATOM    690  N   TRP A  93      32.680  54.989  23.649  1.00 43.68           N  
ATOM    691  CA  TRP A  93      33.675  54.921  24.706  1.00 40.60           C  
ATOM    692  C   TRP A  93      34.564  53.683  24.688  1.00 40.19           C  
ATOM    693  O   TRP A  93      34.265  52.589  24.195  1.00 38.04           O  
ATOM    694  CB  TRP A  93      32.969  55.062  26.046  1.00 33.82           C  
ATOM    695  CG  TRP A  93      32.189  53.888  26.514  1.00 38.42           C  
ATOM    696  CD1 TRP A  93      32.606  52.967  27.428  1.00 36.98           C  
ATOM    697  CD2 TRP A  93      30.834  53.534  26.172  1.00 36.62           C  
ATOM    698  NE1 TRP A  93      31.592  52.065  27.673  1.00 36.72           N  
ATOM    699  CE2 TRP A  93      30.509  52.386  26.908  1.00 36.26           C  
ATOM    700  CE3 TRP A  93      29.893  54.069  25.287  1.00 34.18           C  
ATOM    701  CZ2 TRP A  93      29.273  51.744  26.795  1.00 39.93           C  
ATOM    702  CZ3 TRP A  93      28.661  53.432  25.184  1.00 39.94           C  
ATOM    703  CH2 TRP A  93      28.360  52.283  25.927  1.00 33.91           C  
ATOM    704  N   THR A  94      35.741  53.857  25.331  1.00 34.52           N  
ATOM    705  CA  THR A  94      36.661  52.758  25.474  1.00 36.43           C  
ATOM    706  C   THR A  94      37.438  52.839  26.776  1.00 35.71           C  
ATOM    707  O   THR A  94      37.463  53.887  27.370  1.00 38.79           O  
ATOM    708  CB  THR A  94      37.682  52.677  24.298  1.00 37.59           C  
ATOM    709  OG1 THR A  94      38.450  51.492  24.541  1.00 37.74           O  
ATOM    710  CG2 THR A  94      38.552  53.905  24.296  1.00 30.22           C  
ATOM    711  N   ASN A  95      37.945  51.750  27.320  1.00 42.73           N  
ATOM    712  CA  ASN A  95      38.790  51.743  28.494  1.00 41.32           C  
ATOM    713  C   ASN A  95      40.058  52.550  28.106  1.00 42.87           C  
ATOM    714  O   ASN A  95      40.511  52.511  26.982  1.00 42.88           O  
ATOM    715  CB  ASN A  95      39.250  50.349  28.922  1.00 33.98           C  
ATOM    716  CG  ASN A  95      38.092  49.630  29.586  1.00 42.40           C  
ATOM    717  OD1 ASN A  95      37.149  50.339  29.951  1.00 46.71           O  
ATOM    718  ND2 ASN A  95      38.068  48.317  29.702  1.00 44.34           N  
ATOM    719  N   THR A  96      40.472  53.372  29.007  1.00 46.54           N  
ATOM    720  CA  THR A  96      41.611  54.278  28.915  1.00 47.31           C  
ATOM    721  C   THR A  96      42.842  53.420  29.094  1.00 47.97           C  
ATOM    722  O   THR A  96      42.834  52.472  29.879  1.00 45.42           O  
ATOM    723  CB  THR A  96      41.301  55.290  30.052  1.00 45.93           C  
ATOM    724  OG1 THR A  96      41.235  56.631  29.541  1.00 46.37           O  
ATOM    725  CG2 THR A  96      42.212  55.142  31.229  1.00 42.30           C  
ATOM    726  N   PRO A  97      43.834  53.546  28.226  1.00 53.17           N  
ATOM    727  CA  PRO A  97      45.055  52.761  28.322  1.00 56.37           C  
ATOM    728  C   PRO A  97      45.839  53.079  29.592  1.00 60.73           C  
ATOM    729  O   PRO A  97      45.879  54.193  30.091  1.00 59.99           O  
ATOM    730  CB  PRO A  97      45.870  53.161  27.119  1.00 48.59           C  
ATOM    731  CG  PRO A  97      45.319  54.464  26.688  1.00 48.67           C  
ATOM    732  CD  PRO A  97      43.917  54.583  27.173  1.00 51.46           C  
ATOM    733  N   ASP A  98      46.488  52.050  30.070  1.00 70.15           N  
ATOM    734  CA  ASP A  98      47.380  52.101  31.200  1.00 79.12           C  
ATOM    735  C   ASP A  98      48.233  53.340  31.337  1.00 79.20           C  
ATOM    736  O   ASP A  98      48.939  53.740  30.399  1.00 77.85           O  
ATOM    737  CB  ASP A  98      48.349  50.868  31.051  1.00 88.38           C  
ATOM    738  CG  ASP A  98      47.872  49.951  32.192  1.00 99.30           C  
ATOM    739  OD1 ASP A  98      48.326  50.260  33.312  1.00106.73           O  
ATOM    740  OD2 ASP A  98      47.027  49.078  31.949  1.00104.27           O  
ATOM    741  N   GLY A  99      48.172  53.951  32.532  1.00 77.66           N  
ATOM    742  CA  GLY A  99      48.976  55.151  32.769  1.00 78.37           C  
ATOM    743  C   GLY A  99      48.861  56.139  31.614  1.00 79.24           C  
ATOM    744  O   GLY A  99      49.758  56.410  30.812  1.00 80.27           O  
ATOM    745  N   ALA A 100      47.620  56.611  31.485  1.00 76.43           N  
ATOM    746  CA  ALA A 100      47.350  57.659  30.492  1.00 71.92           C  
ATOM    747  C   ALA A 100      46.705  58.740  31.377  1.00 69.66           C  
ATOM    748  O   ALA A 100      46.220  58.423  32.476  1.00 70.81           O  
ATOM    749  CB  ALA A 100      46.574  57.232  29.304  1.00 68.68           C  
ATOM    750  N   ALA A 101      46.851  59.951  30.922  1.00 65.28           N  
ATOM    751  CA  ALA A 101      46.352  61.118  31.635  1.00 66.36           C  
ATOM    752  C   ALA A 101      44.841  61.209  31.596  1.00 64.34           C  
ATOM    753  O   ALA A 101      44.276  60.553  30.732  1.00 64.01           O  
ATOM    754  CB  ALA A 101      46.983  62.311  30.907  1.00 63.08           C  
ATOM    755  N   LYS A 102      44.196  61.987  32.463  1.00 63.22           N  
ATOM    756  CA  LYS A 102      42.742  62.154  32.439  1.00 58.57           C  
ATOM    757  C   LYS A 102      42.449  63.251  31.421  1.00 58.50           C  
ATOM    758  O   LYS A 102      41.903  64.290  31.751  1.00 67.23           O  
ATOM    759  CB  LYS A 102      42.147  62.452  33.797  1.00 59.58           C  
ATOM    760  CG  LYS A 102      40.664  62.763  33.849  1.00 65.19           C  
ATOM    761  CD  LYS A 102      40.195  63.384  35.150  1.00 67.33           C  
ATOM    762  CE  LYS A 102      38.675  63.222  35.294  1.00 67.59           C  
ATOM    763  NZ  LYS A 102      38.357  62.604  36.617  1.00 71.00           N  
ATOM    764  N   GLN A 103      42.884  63.122  30.190  1.00 56.64           N  
ATOM    765  CA  GLN A 103      42.713  64.025  29.077  1.00 55.82           C  
ATOM    766  C   GLN A 103      42.605  63.216  27.771  1.00 58.88           C  
ATOM    767  O   GLN A 103      43.417  62.409  27.307  1.00 60.74           O  
ATOM    768  CB  GLN A 103      43.773  65.089  28.960  1.00 57.48           C  
ATOM    769  CG  GLN A 103      43.519  66.066  27.821  1.00 57.34           C  
ATOM    770  CD  GLN A 103      44.709  67.141  27.872  0.00 62.75           C  
ATOM    771  OE1 GLN A 103      45.697  67.036  28.596  0.00 67.26           O  
ATOM    772  NE2 GLN A 103      44.623  68.149  27.026  0.00 61.53           N  
ATOM    773  N   PHE A 104      41.460  63.393  27.136  1.00 58.18           N  
ATOM    774  CA  PHE A 104      41.009  62.644  26.004  1.00 58.80           C  
ATOM    775  C   PHE A 104      41.870  62.643  24.762  1.00 58.79           C  
ATOM    776  O   PHE A 104      42.128  63.720  24.241  1.00 58.47           O  
ATOM    777  CB  PHE A 104      39.584  63.079  25.611  1.00 57.34           C  
ATOM    778  CG  PHE A 104      38.975  62.182  24.565  1.00 54.00           C  
ATOM    779  CD1 PHE A 104      38.336  61.005  24.929  1.00 55.46           C  
ATOM    780  CD2 PHE A 104      39.090  62.478  23.222  1.00 55.39           C  
ATOM    781  CE1 PHE A 104      37.815  60.144  23.981  1.00 53.77           C  
ATOM    782  CE2 PHE A 104      38.560  61.651  22.259  1.00 57.23           C  
ATOM    783  CZ  PHE A 104      37.920  60.473  22.645  1.00 57.53           C  
ATOM    784  N   ARG A 105      42.190  61.458  24.238  1.00 58.75           N  
ATOM    785  CA  ARG A 105      43.007  61.456  23.000  1.00 60.72           C  
ATOM    786  C   ARG A 105      42.228  60.655  21.985  1.00 58.64           C  
ATOM    787  O   ARG A 105      41.825  59.515  22.204  1.00 56.31           O  
ATOM    788  CB  ARG A 105      44.434  60.964  23.200  1.00 58.32           C  
ATOM    789  CG  ARG A 105      45.057  61.712  24.367  0.00 58.27           C  
ATOM    790  CD  ARG A 105      46.512  61.275  24.522  0.00102.62           C  
ATOM    791  NE  ARG A 105      47.462  62.168  23.840  0.00102.62           N  
ATOM    792  CZ  ARG A 105      48.303  61.763  22.882  0.00102.62           C  
ATOM    793  NH1 ARG A 105      48.324  60.485  22.481  0.00100.23           N  
ATOM    794  NH2 ARG A 105      49.172  62.568  22.256  0.00102.62           N  
ATOM    795  N   ARG A 106      42.020  61.274  20.827  1.00 59.07           N  
ATOM    796  CA  ARG A 106      41.300  60.616  19.732  1.00 57.92           C  
ATOM    797  C   ARG A 106      41.947  59.298  19.352  1.00 61.27           C  
ATOM    798  O   ARG A 106      41.315  58.387  18.790  1.00 62.69           O  
ATOM    799  CB  ARG A 106      41.219  61.562  18.538  1.00 59.28           C  
ATOM    800  CG  ARG A 106      40.482  62.732  18.809  0.00 20.00           C  
ATOM    801  CD  ARG A 106      39.986  63.304  17.489  0.00 20.00           C  
ATOM    802  NE  ARG A 106      39.288  64.578  17.661  0.00 20.00           N  
ATOM    803  CZ  ARG A 106      38.951  65.382  16.653  0.00 20.00           C  
ATOM    804  NH1 ARG A 106      39.241  65.057  15.387  0.00 20.00           N  
ATOM    805  NH2 ARG A 106      38.312  66.548  16.810  0.00 20.00           N  
ATOM    806  N   GLU A 107      43.213  59.108  19.672  1.00 62.37           N  
ATOM    807  CA  GLU A 107      43.993  57.931  19.465  1.00 63.86           C  
ATOM    808  C   GLU A 107      43.454  56.719  20.190  1.00 61.15           C  
ATOM    809  O   GLU A 107      43.472  55.595  19.638  1.00 61.51           O  
ATOM    810  CB  GLU A 107      45.451  58.169  19.920  1.00 75.45           C  
ATOM    811  CG  GLU A 107      46.364  57.068  19.406  1.00 97.14           C  
ATOM    812  CD  GLU A 107      46.514  57.071  17.889  1.00110.44           C  
ATOM    813  OE1 GLU A 107      45.916  57.954  17.217  1.00116.42           O  
ATOM    814  OE2 GLU A 107      47.240  56.184  17.360  1.00116.49           O  
ATOM    815  N   TRP A 108      42.886  56.914  21.376  1.00 53.88           N  
ATOM    816  CA  TRP A 108      42.333  55.761  22.084  1.00 52.60           C  
ATOM    817  C   TRP A 108      41.343  54.998  21.221  1.00 53.87           C  
ATOM    818  O   TRP A 108      41.174  53.789  21.411  1.00 56.50           O  
ATOM    819  CB  TRP A 108      41.697  56.253  23.371  1.00 58.27           C  
ATOM    820  CG  TRP A 108      42.658  56.831  24.369  1.00 60.19           C  
ATOM    821  CD1 TRP A 108      43.995  56.605  24.453  1.00 63.22           C  
ATOM    822  CD2 TRP A 108      42.326  57.686  25.469  1.00 58.29           C  
ATOM    823  NE1 TRP A 108      44.519  57.263  25.542  1.00 65.71           N  
ATOM    824  CE2 TRP A 108      43.512  57.940  26.178  1.00 60.13           C  
ATOM    825  CE3 TRP A 108      41.132  58.283  25.900  1.00 53.06           C  
ATOM    826  CZ2 TRP A 108      43.567  58.752  27.309  1.00 55.45           C  
ATOM    827  CZ3 TRP A 108      41.194  59.090  27.012  1.00 54.17           C  
ATOM    828  CH2 TRP A 108      42.388  59.322  27.699  1.00 55.32           C  
ATOM    829  N   PHE A 109      40.660  55.631  20.276  1.00 50.39           N  
ATOM    830  CA  PHE A 109      39.711  55.009  19.404  1.00 53.40           C  
ATOM    831  C   PHE A 109      40.267  54.545  18.067  1.00 56.19           C  
ATOM    832  O   PHE A 109      39.505  54.063  17.221  1.00 53.83           O  
ATOM    833  CB  PHE A 109      38.611  56.046  19.071  1.00 55.38           C  
ATOM    834  CG  PHE A 109      37.649  56.328  20.186  1.00 57.37           C  
ATOM    835  CD1 PHE A 109      37.786  55.783  21.437  1.00 55.52           C  
ATOM    836  CD2 PHE A 109      36.590  57.215  19.976  1.00 63.28           C  
ATOM    837  CE1 PHE A 109      36.929  56.089  22.448  1.00 57.12           C  
ATOM    838  CE2 PHE A 109      35.692  57.519  20.987  1.00 61.83           C  
ATOM    839  CZ  PHE A 109      35.876  56.944  22.234  1.00 59.98           C  
ATOM    840  N   GLN A 110      41.550  54.807  17.818  1.00 57.96           N  
ATOM    841  CA  GLN A 110      42.111  54.415  16.534  1.00 57.95           C  
ATOM    842  C   GLN A 110      43.102  53.257  16.651  1.00 57.01           C  
ATOM    843  O   GLN A 110      43.192  52.534  15.661  1.00 60.38           O  
ATOM    844  CB  GLN A 110      42.795  55.541  15.842  1.00 61.37           C  
ATOM    845  CG  GLN A 110      41.995  56.768  15.487  1.00 63.28           C  
ATOM    846  CD  GLN A 110      42.986  57.881  15.101  1.00 73.17           C  
ATOM    847  OE1 GLN A 110      44.217  57.680  15.068  1.00 78.94           O  
ATOM    848  NE2 GLN A 110      42.401  59.031  14.804  1.00 68.69           N  
ATOM    849  N   GLY A 111      43.827  53.128  17.731  1.00 49.46           N  
ATOM    850  CA  GLY A 111      44.714  52.009  17.915  1.00 49.10           C  
ATOM    851  C   GLY A 111      43.967  50.726  18.263  1.00 50.37           C  
ATOM    852  O   GLY A 111      42.735  50.673  18.416  1.00 53.48           O  
ATOM    853  N   ASP A 112      44.755  49.664  18.303  1.00 47.92           N  
ATOM    854  CA  ASP A 112      44.232  48.347  18.600  1.00 48.10           C  
ATOM    855  C   ASP A 112      43.302  48.443  19.778  1.00 50.31           C  
ATOM    856  O   ASP A 112      43.648  49.080  20.783  1.00 52.55           O  
ATOM    857  CB  ASP A 112      45.427  47.412  18.845  1.00 49.25           C  
ATOM    858  CG  ASP A 112      46.214  47.191  17.564  1.00 50.69           C  
ATOM    859  OD1 ASP A 112      45.970  47.948  16.604  1.00 49.21           O  
ATOM    860  OD2 ASP A 112      47.050  46.265  17.542  1.00 55.21           O  
ATOM    861  N   GLY A 113      42.093  47.907  19.684  1.00 50.85           N  
ATOM    862  CA  GLY A 113      41.211  47.949  20.830  1.00 45.12           C  
ATOM    863  C   GLY A 113      39.742  47.859  20.418  1.00 46.63           C  
ATOM    864  O   GLY A 113      39.428  47.621  19.266  1.00 42.67           O  
ATOM    865  N   MET A 114      38.913  48.040  21.458  1.00 46.37           N  
ATOM    866  CA  MET A 114      37.493  47.951  21.410  1.00 43.29           C  
ATOM    867  C   MET A 114      36.794  49.262  21.712  1.00 43.31           C  
ATOM    868  O   MET A 114      37.143  49.995  22.628  1.00 41.47           O  
ATOM    869  CB  MET A 114      36.992  46.853  22.330  1.00 41.73           C  
ATOM    870  CG  MET A 114      36.799  45.540  21.584  1.00 48.81           C  
ATOM    871  SD  MET A 114      37.020  44.135  22.677  1.00 57.87           S  
ATOM    872  CE  MET A 114      38.385  44.633  23.701  1.00 55.96           C  
ATOM    873  N   VAL A 115      35.873  49.636  20.830  1.00 41.88           N  
ATOM    874  CA  VAL A 115      35.082  50.840  21.036  1.00 40.62           C  
ATOM    875  C   VAL A 115      33.623  50.429  21.242  1.00 41.42           C  
ATOM    876  O   VAL A 115      33.099  49.569  20.544  1.00 45.38           O  
ATOM    877  CB  VAL A 115      35.213  51.878  19.941  1.00 38.71           C  
ATOM    878  CG1 VAL A 115      34.191  53.033  20.107  1.00 41.35           C  
ATOM    879  CG2 VAL A 115      36.606  52.489  20.009  1.00 35.58           C  
ATOM    880  N   ARG A 116      32.993  50.947  22.281  1.00 39.30           N  
ATOM    881  CA  ARG A 116      31.593  50.580  22.500  1.00 38.69           C  
ATOM    882  C   ARG A 116      30.719  51.798  22.200  1.00 38.54           C  
ATOM    883  O   ARG A 116      31.142  52.949  22.308  1.00 32.55           O  
ATOM    884  CB  ARG A 116      31.462  49.988  23.881  1.00 39.15           C  
ATOM    885  CG  ARG A 116      30.253  49.121  24.081  1.00 43.23           C  
ATOM    886  CD  ARG A 116      29.955  48.836  25.535  1.00 43.47           C  
ATOM    887  NE  ARG A 116      28.802  47.945  25.630  1.00 51.86           N  
ATOM    888  CZ  ARG A 116      28.351  47.465  26.780  1.00 52.61           C  
ATOM    889  NH1 ARG A 116      29.006  47.851  27.856  1.00 57.85           N  
ATOM    890  NH2 ARG A 116      27.318  46.669  26.864  1.00 55.25           N  
ATOM    891  N   ARG A 117      29.472  51.551  21.775  1.00 39.51           N  
ATOM    892  CA  ARG A 117      28.611  52.678  21.483  1.00 41.67           C  
ATOM    893  C   ARG A 117      27.168  52.478  21.934  1.00 41.30           C  
ATOM    894  O   ARG A 117      26.641  51.387  22.014  1.00 36.49           O  
ATOM    895  CB  ARG A 117      28.701  53.018  20.015  1.00 39.96           C  
ATOM    896  CG  ARG A 117      28.287  51.860  19.147  1.00 62.46           C  
ATOM    897  CD  ARG A 117      27.609  52.445  17.913  1.00 76.89           C  
ATOM    898  NE  ARG A 117      28.358  53.478  17.284  1.00 89.80           N  
ATOM    899  CZ  ARG A 117      28.233  54.305  16.279  1.00 96.29           C  
ATOM    900  NH1 ARG A 117      27.261  54.509  15.398  1.00 96.98           N  
ATOM    901  NH2 ARG A 117      29.313  55.111  16.113  1.00 99.06           N  
ATOM    902  N   LYS A 118      26.560  53.599  22.326  1.00 39.53           N  
ATOM    903  CA  LYS A 118      25.171  53.649  22.700  1.00 38.04           C  
ATOM    904  C   LYS A 118      24.480  54.787  21.954  1.00 40.04           C  
ATOM    905  O   LYS A 118      24.953  55.923  21.907  1.00 39.17           O  
ATOM    906  CB  LYS A 118      24.990  53.878  24.207  1.00 41.80           C  
ATOM    907  CG  LYS A 118      23.530  53.957  24.608  1.00 40.19           C  
ATOM    908  CD  LYS A 118      23.311  53.957  26.107  1.00 37.44           C  
ATOM    909  CE  LYS A 118      21.852  53.636  26.395  1.00 42.12           C  
ATOM    910  NZ  LYS A 118      21.464  53.770  27.824  1.00 40.79           N  
ATOM    911  N   ASN A 119      23.444  54.421  21.196  1.00 42.54           N  
ATOM    912  CA  ASN A 119      22.670  55.463  20.510  1.00 41.20           C  
ATOM    913  C   ASN A 119      21.507  55.928  21.390  1.00 38.69           C  
ATOM    914  O   ASN A 119      20.937  55.170  22.172  1.00 37.68           O  
ATOM    915  CB  ASN A 119      22.121  54.958  19.172  1.00 43.24           C  
ATOM    916  CG  ASN A 119      23.302  54.814  18.198  1.00 45.07           C  
ATOM    917  OD1 ASN A 119      23.884  55.782  17.703  1.00 41.77           O  
ATOM    918  ND2 ASN A 119      23.649  53.577  17.926  1.00 48.57           N  
ATOM    919  N   LEU A 120      21.220  57.192  21.279  1.00 38.06           N  
ATOM    920  CA  LEU A 120      20.132  57.893  21.906  1.00 34.85           C  
ATOM    921  C   LEU A 120      19.418  58.709  20.826  1.00 32.26           C  
ATOM    922  O   LEU A 120      19.816  59.824  20.511  1.00 35.57           O  
ATOM    923  CB  LEU A 120      20.638  58.874  22.958  1.00 35.75           C  
ATOM    924  CG  LEU A 120      21.064  58.278  24.278  1.00 39.53           C  
ATOM    925  CD1 LEU A 120      21.481  59.378  25.237  1.00 36.15           C  
ATOM    926  CD2 LEU A 120      19.949  57.402  24.831  1.00 38.13           C  
ATOM    927  N   PRO A 121      18.479  58.104  20.130  1.00 33.87           N  
ATOM    928  CA  PRO A 121      17.725  58.764  19.077  1.00 33.31           C  
ATOM    929  C   PRO A 121      16.992  59.987  19.612  1.00 37.71           C  
ATOM    930  O   PRO A 121      16.601  59.997  20.794  1.00 39.67           O  
ATOM    931  CB  PRO A 121      16.698  57.747  18.619  1.00 34.92           C  
ATOM    932  CG  PRO A 121      16.993  56.490  19.313  1.00 35.23           C  
ATOM    933  CD  PRO A 121      17.985  56.744  20.432  1.00 35.37           C  
ATOM    934  N   ILE A 122      16.887  60.993  18.759  1.00 39.40           N  
ATOM    935  CA  ILE A 122      16.203  62.221  19.145  1.00 40.48           C  
ATOM    936  C   ILE A 122      14.758  62.092  18.637  1.00 42.61           C  
ATOM    937  O   ILE A 122      14.500  61.713  17.511  1.00 43.34           O  
ATOM    938  CB  ILE A 122      16.790  63.465  18.485  1.00 42.40           C  
ATOM    939  CG1 ILE A 122      18.278  63.632  18.736  1.00 46.54           C  
ATOM    940  CG2 ILE A 122      15.966  64.692  18.892  1.00 42.50           C  
ATOM    941  CD1 ILE A 122      18.734  64.058  20.081  1.00 50.53           C  
ATOM    942  N   GLU A 123      13.806  62.405  19.474  1.00 45.63           N  
ATOM    943  CA  GLU A 123      12.392  62.333  19.075  1.00 41.97           C  
ATOM    944  C   GLU A 123      11.827  63.729  19.249  1.00 38.55           C  
ATOM    945  O   GLU A 123      12.082  64.443  20.208  1.00 36.41           O  
ATOM    946  CB  GLU A 123      11.729  61.299  19.931  1.00 46.25           C  
ATOM    947  CG  GLU A 123      10.274  61.040  19.741  1.00 54.61           C  
ATOM    948  CD  GLU A 123       9.825  59.882  20.664  1.00 61.81           C  
ATOM    949  OE1 GLU A 123      10.444  58.800  20.476  1.00 58.83           O  
ATOM    950  OE2 GLU A 123       8.916  60.170  21.474  1.00 57.21           O  
ATOM    951  N   TYR A 124      11.115  64.155  18.226  1.00 39.48           N  
ATOM    952  CA  TYR A 124      10.555  65.489  18.216  1.00 39.94           C  
ATOM    953  C   TYR A 124       9.086  65.468  18.592  1.00 42.46           C  
ATOM    954  O   TYR A 124       8.303  64.767  17.971  1.00 42.65           O  
ATOM    955  CB  TYR A 124      10.779  66.146  16.845  1.00 36.67           C  
ATOM    956  CG  TYR A 124      12.275  66.374  16.568  1.00 41.98           C  
ATOM    957  CD1 TYR A 124      12.931  67.494  17.071  1.00 40.93           C  
ATOM    958  CD2 TYR A 124      13.034  65.482  15.837  1.00 38.03           C  
ATOM    959  CE1 TYR A 124      14.258  67.698  16.853  1.00 45.24           C  
ATOM    960  CE2 TYR A 124      14.372  65.708  15.571  1.00 40.01           C  
ATOM    961  CZ  TYR A 124      14.992  66.819  16.079  1.00 45.81           C  
ATOM    962  OH  TYR A 124      16.330  67.048  15.827  1.00 45.72           O  
ATOM    963  N   ASN A 125       8.728  66.268  19.591  1.00 43.12           N  
ATOM    964  CA  ASN A 125       7.364  66.474  20.053  1.00 40.33           C  
ATOM    965  C   ASN A 125       6.886  67.902  19.735  1.00 38.13           C  
ATOM    966  O   ASN A 125       7.080  68.859  20.403  1.00 33.89           O  
ATOM    967  CB  ASN A 125       7.258  66.175  21.527  1.00 34.70           C  
ATOM    968  CG  ASN A 125       5.882  66.451  22.067  1.00 35.20           C  
ATOM    969  OD1 ASN A 125       4.904  66.014  21.496  1.00 45.36           O  
ATOM    970  ND2 ASN A 125       5.841  67.210  23.150  1.00 34.53           N  
ATOM    971  N   PRO A 126       6.197  67.927  18.511  1.00 40.25           N  
ATOM    972  CA  PRO A 126       5.737  69.227  18.017  1.00 40.58           C  
ATOM    973  C   PRO A 126       4.469  69.807  18.574  1.00 42.79           C  
ATOM    974  O   PRO A 126       4.245  71.013  18.268  1.00 45.51           O  
ATOM    975  CB  PRO A 126       5.518  69.042  16.499  1.00 37.46           C  
ATOM    976  CG  PRO A 126       5.166  67.610  16.351  1.00 35.41           C  
ATOM    977  CD  PRO A 126       5.860  66.874  17.435  1.00 35.25           C  
ATOM    978  OXT PRO A 126       3.667  69.078  19.206  1.00 49.52           O  
TER     979      PRO A 126                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
