
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  170 ( 1361),  selected  170 , name 3cex_A
# Molecule2: number of CA atoms  150 ( 1146),  selected  150 , name T0406.pdb
# PARAMETERS: 3cex_A.T0406.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     0_A      M       1           -
LGA    X     1_A      Y       2           -
LGA    -       -      Q       3           -
LGA    K     2_A      T       4          5.113
LGA    V     3_A      I       5          3.605
LGA    T     4_A      E       6          3.718
LGA    Q     5_A      G       7          4.119
LGA    -       -      F       8           -
LGA    -       -      L       9           -
LGA    L     6_A      Q      10          1.662
LGA    S     7_A      S      11          2.406
LGA    S     8_A      W      12          2.311
LGA    E     9_A      T      13          1.645
LGA    T    10_A      Y      14          2.660
LGA    L    11_A      E      15          2.519
LGA    D    12_A      T      16          2.260
LGA    -       -      E      17           -
LGA    R    13_A      S      18          2.080
LGA    A    14_A      T      19          2.328
LGA    H    15_A      Q      20          2.348
LGA    E    16_A      K      21          2.238
LGA    R    17_A      M      22          2.860
LGA    F    18_A      L      23          2.816
LGA    E    19_A      D      24          2.201
LGA    E    20_A      V      25          3.402
LGA    T    21_A      -       -           -
LGA    L    22_A      L      26          1.119
LGA    A    23_A      -       -           -
LGA    Q    24_A      -       -           -
LGA    X    25_A      -       -           -
LGA    T    26_A      T      27          3.371
LGA    V    27_A      D      28          0.999
LGA    A    28_A      E      29          2.480
LGA    E    29_A      S      30          2.222
LGA    A    30_A      L      31          1.375
LGA    N    31_A      S      32          2.380
LGA    T    32_A      Q      33          2.537
LGA    X    33_A      E      34          1.739
LGA    P    34_A      I      35          3.336
LGA    A    35_A      A      36          0.721
LGA    P    36_A      P      37          4.844
LGA    L    37_A      G      38           #
LGA    I    38_A      H      39          5.620
LGA    K    39_A      W      40          3.293
LGA    S    40_A      T      41          2.186
LGA    V    41_A      L      42          2.117
LGA    T    42_A      G      43          1.077
LGA    W    43_A      R      44          0.909
LGA    L    44_A      V      45          1.616
LGA    X    45_A      A      46          1.557
LGA    W    46_A      W      47          0.664
LGA    H    47_A      H      48          0.560
LGA    T    48_A      I      49          0.686
LGA    A    49_A      V      50          0.844
LGA    R    50_A      T      51          0.306
LGA    E    51_A      A      52          0.734
LGA    L    52_A      I      53          0.348
LGA    D    53_A      P      54          2.202
LGA    L    54_A      V      55          2.451
LGA    Q    55_A      I      56          2.764
LGA    I    56_A      L      57          3.012
LGA    S    57_A      S      58          4.557
LGA    A    58_A      G      59          4.308
LGA    L    59_A      T      60          2.471
LGA    N    60_A      G      61          3.584
LGA    H    61_A      L      62          4.930
LGA    S    62_A      K      63          3.238
LGA    D    63_A      F      64           #
LGA    P    64_A      E      65          4.841
LGA    L    65_A      G      66          2.153
LGA    W    66_A      E      67          1.695
LGA    L    67_A      T      68           #
LGA    S    68_A      -       -           -
LGA    Q    69_A      -       -           -
LGA    H    70_A      -       -           -
LGA    W    71_A      -       -           -
LGA    T    72_A      K      69           #
LGA    E    73_A      D      70           -
LGA    K    74_A      Y      71           -
LGA    F    75_A      -       -           -
LGA    A    76_A      -       -           -
LGA    L    77_A      -       -           -
LGA    D    78_A      P      72          4.832
LGA    L    79_A      -       -           -
LGA    P    80_A      -       -           -
LGA    D    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    T    83_A      -       -           -
LGA    E    84_A      -       -           -
LGA    D    85_A      -       -           -
LGA    W    86_A      -       -           -
LGA    H    87_A      -       -           -
LGA    H    88_A      -       -           -
LGA    T    89_A      -       -           -
LGA    P    90_A      -       -           -
LGA    E    91_A      -       -           -
LGA    E    92_A      -       -           -
LGA    A    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    K    95_A      -       -           -
LGA    V    96_A      -       -           -
LGA    V    97_A      V      73          3.969
LGA    V    98_A      P      74          2.846
LGA    A    99_A      T      75          2.790
LGA    E   100_A      S      76          1.735
LGA    K   101_A      A      77          1.441
LGA    Q   102_A      K      78          0.931
LGA    L   103_A      T      79          0.611
LGA    L   104_A      I      80          0.507
LGA    S   105_A      A      81          1.245
LGA    D   106_A      D      82          1.487
LGA    Y   107_A      G      83          0.944
LGA    L   108_A      Y      84          0.818
LGA    A   109_A      R      85          0.831
LGA    A   110_A      K      86          1.312
LGA    S   111_A      V      87          1.718
LGA    V   112_A      N      88          1.296
LGA    A   113_A      T      89          0.998
LGA    L   114_A      A      90          2.225
LGA    T   115_A      F      91          2.612
LGA    K   116_A      V      92          1.852
LGA    S   117_A      E      93          1.883
LGA    Y   118_A      A      94          3.401
LGA    L   119_A      L      95          3.621
LGA    D   120_A      Q      96          2.655
LGA    Q   121_A      S      97          3.693
LGA    -       -      E      98           -
LGA    I   122_A      W      99          1.970
LGA    K   123_A      T     100          1.225
LGA    E   124_A      D     101          1.049
LGA    E   125_A      K     102          0.799
LGA    Q   126_A      D     103          1.018
LGA    L   127_A      L     104          0.855
LGA    S   128_A      T     105          1.122
LGA    D   129_A      T     106          1.175
LGA    V   130_A      I     107          1.121
LGA    I   131_A      N     108          0.567
LGA    D   132_A      D     109          1.980
LGA    K   133_A      F     110           -
LGA    -       -      F     111           -
LGA    N   134_A      G     112          4.769
LGA    W   135_A      R     113          3.155
LGA    T   136_A      -       -           -
LGA    P   137_A      -       -           -
LGA    P   138_A      P     114          3.264
LGA    V   139_A      M     115          1.522
LGA    T   140_A      P     116          1.510
LGA    R   141_A      N     117          0.718
LGA    Q   142_A      S     118          0.723
LGA    V   143_A      I     119          0.508
LGA    R   144_A      F     120          0.556
LGA    L   145_A      L     121          0.795
LGA    V   146_A      M     122          0.863
LGA    S   147_A      T     123          0.545
LGA    A   148_A      L     124          0.691
LGA    I   149_A      I     125          1.579
LGA    D   150_A      N     126          1.575
LGA    D   151_A      H     127          1.554
LGA    A   152_A      Q     128          1.706
LGA    V   153_A      N     129          2.441
LGA    X   154_A      H     130          2.504
LGA    H   155_A      H     131          1.699
LGA    S   156_A      R     132          1.697
LGA    G   157_A      G     133          1.995
LGA    Q   158_A      Q     134          1.313
LGA    A   159_A      M     135          0.702
LGA    V   160_A      T     136          0.963
LGA    Y   161_A      V     137          0.494
LGA    T   162_A      L     138          0.920
LGA    R   163_A      M     139          1.400
LGA    R   164_A      R     140          1.760
LGA    L   165_A      Q     141          2.409
LGA    V   166_A      A     142          3.113
LGA    I   167_A      G     143          2.903
LGA    G   168_A      L     144           -
LGA    K   169_A      T     145           #
LGA    -       -      V     146           -
LGA    -       -      P     147           -
LGA    -       -      G     148           -
LGA    -       -      V     149           -
LGA    -       -      Y     150           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  170  150    5.0    128    2.37    15.62     58.362     5.175

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.183358 * X  +   0.969319 * Y  +   0.163707 * Z  +  13.318787
  Y_new =   0.342541 * X  +  -0.219092 * Y  +   0.913600 * Z  +  -6.241094
  Z_new =   0.921437 * X  +  -0.111439 * Y  +  -0.372204 * Z  +   1.803721 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.850682    0.290910  [ DEG:  -163.3321     16.6679 ]
  Theta =  -1.171762   -1.969831  [ DEG:   -67.1370   -112.8630 ]
  Phi   =   1.079319   -2.062274  [ DEG:    61.8404   -118.1596 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cex_A                                        
REMARK     2: T0406.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cex_A.T0406.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  170  150   5.0  128   2.37   15.62  58.362
REMARK  ---------------------------------------------------------- 
MOLECULE 3cex_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   29-FEB-08   3CEX              
TITLE     CRYSTAL STRUCTURE OF THE CONSERVED PROTEIN OF LOCUS EF_3021           
TITLE    2 FROM ENTEROCOCCUS FAECALIS                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ENTEROCOCCUS FAECALIS V583;                     
SOURCE   3 STRAIN: V583;                                                        
SOURCE   4 ATCC: 700802;                                                        
SOURCE   5 GENE: EF_3021;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    ENTEROCOCCUS FAECALIS, STRUCTURAL GENOMICS, EF_3021, PSI-2,           
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG, STRUCTURAL GENOMICS, UNKNOWN FUNCTION                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.CUFF,R.WU,S.MOY,A.JOACHIMIAK,MIDWEST CENTER FOR                   
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   13-MAY-08 3CEX    0                                                
JRNL        AUTH   M.E.CUFF,R.WU,S.MOY,A.JOACHIMIAK                             
JRNL        TITL   STRUCTURE OF THE CONSERVED PROTEIN OF LOCUS                  
JRNL        TITL 2 EF_3021 FROM ENTEROCOCCUS FAECALIS.                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  3CEX A    1   169  UNP    Q82ZN0   Q82ZN0_ENTFA     1    169             
DBREF  3CEX B    1   169  UNP    Q82ZN0   Q82ZN0_ENTFA     1    169             
SEQRES   1 A  172  SER ASN ALA MSE LYS VAL THR GLN LEU SER SER GLU THR          
SEQRES   2 A  172  LEU ASP ARG ALA HIS GLU ARG PHE GLU GLU THR LEU ALA          
SEQRES   3 A  172  GLN MSE THR VAL ALA GLU ALA ASN THR MSE PRO ALA PRO          
SEQRES   4 A  172  LEU ILE LYS SER VAL THR TRP LEU MSE TRP HIS THR ALA          
SEQRES   5 A  172  ARG GLU LEU ASP LEU GLN ILE SER ALA LEU ASN HIS SER          
SEQRES   6 A  172  ASP PRO LEU TRP LEU SER GLN HIS TRP THR GLU LYS PHE          
SEQRES   7 A  172  ALA LEU ASP LEU PRO ASP GLU THR GLU ASP TRP HIS HIS          
SEQRES   8 A  172  THR PRO GLU GLU ALA ALA LYS VAL VAL VAL ALA GLU LYS          
SEQRES   9 A  172  GLN LEU LEU SER ASP TYR LEU ALA ALA SER VAL ALA LEU          
SEQRES  10 A  172  THR LYS SER TYR LEU ASP GLN ILE LYS GLU GLU GLN LEU          
SEQRES  11 A  172  SER ASP VAL ILE ASP LYS ASN TRP THR PRO PRO VAL THR          
SEQRES  12 A  172  ARG GLN VAL ARG LEU VAL SER ALA ILE ASP ASP ALA VAL          
SEQRES  13 A  172  MSE HIS SER GLY GLN ALA VAL TYR THR ARG ARG LEU VAL          
SEQRES  14 A  172  ILE GLY LYS                                                  
SEQRES   1 B  172  SER ASN ALA MSE LYS VAL THR GLN LEU SER SER GLU THR          
SEQRES   2 B  172  LEU ASP ARG ALA HIS GLU ARG PHE GLU GLU THR LEU ALA          
SEQRES   3 B  172  GLN MSE THR VAL ALA GLU ALA ASN THR MSE PRO ALA PRO          
SEQRES   4 B  172  LEU ILE LYS SER VAL THR TRP LEU MSE TRP HIS THR ALA          
SEQRES   5 B  172  ARG GLU LEU ASP LEU GLN ILE SER ALA LEU ASN HIS SER          
SEQRES   6 B  172  ASP PRO LEU TRP LEU SER GLN HIS TRP THR GLU LYS PHE          
SEQRES   7 B  172  ALA LEU ASP LEU PRO ASP GLU THR GLU ASP TRP HIS HIS          
SEQRES   8 B  172  THR PRO GLU GLU ALA ALA LYS VAL VAL VAL ALA GLU LYS          
SEQRES   9 B  172  GLN LEU LEU SER ASP TYR LEU ALA ALA SER VAL ALA LEU          
SEQRES  10 B  172  THR LYS SER TYR LEU ASP GLN ILE LYS GLU GLU GLN LEU          
SEQRES  11 B  172  SER ASP VAL ILE ASP LYS ASN TRP THR PRO PRO VAL THR          
SEQRES  12 B  172  ARG GLN VAL ARG LEU VAL SER ALA ILE ASP ASP ALA VAL          
SEQRES  13 B  172  MSE HIS SER GLY GLN ALA VAL TYR THR ARG ARG LEU VAL          
SEQRES  14 B  172  ILE GLY LYS                                                  
HET    MSE  A   1       8                                                       
HET    MSE  A  25       8                                                       
HET    MSE  A  33       8                                                       
HET    MSE  A  45       8                                                       
HET    MSE  A 154       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  25       8                                                       
HET    MSE  B  33       8                                                       
HET    MSE  B  45       8                                                       
HET    MSE  B 154       8                                                       
HET    ACY  A 301       4                                                       
HET    GOL  A 302       6                                                       
HET    ACY  B 301       4                                                       
HET    GOL  B 302       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACY ACETIC ACID                                                      
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   3  ACY    2(C2 H4 O2)                                                  
FORMUL   4  GOL    2(C3 H8 O3)                                                  
FORMUL   7  HOH   *188(H2 O)                                                    
CRYST1   55.191   55.137   62.429  90.00 108.20  90.00 P 1 2 1       4          
ATOM      1  N   ALA A   0      -1.832  11.305  32.792  1.00 39.42           N  
ATOM      2  CA  ALA A   0      -1.197  12.596  33.233  1.00 39.22           C  
ATOM      3  C   ALA A   0       0.251  12.635  32.724  1.00 39.12           C  
ATOM      4  O   ALA A   0       0.716  13.642  32.169  1.00 38.05           O  
ATOM      5  CB  ALA A   0      -1.233  12.734  34.754  1.00 39.36           C  
HETATM    6  N   MSE A   1       0.952  11.522  32.885  1.00 38.70           N  
HETATM    7  CA  MSE A   1       2.304  11.446  32.389  1.00 39.78           C  
HETATM    8  C   MSE A   1       2.322  11.112  30.894  1.00 36.67           C  
HETATM    9  O   MSE A   1       1.575  10.273  30.428  1.00 35.86           O  
HETATM   10  CB  MSE A   1       3.078  10.402  33.162  1.00 39.57           C  
HETATM   11  CG  MSE A   1       4.556  10.465  32.870  1.00 42.54           C  
HETATM   12 SE   MSE A   1       5.569   9.165  33.924  0.80 49.07          SE  
HETATM   13  CE  MSE A   1       4.249   8.830  35.276  1.00 39.28           C  
ATOM     14  N   LYS A   2       3.216  11.761  30.169  1.00 34.81           N  
ATOM     15  CA  LYS A   2       3.458  11.431  28.789  1.00 33.23           C  
ATOM     16  C   LYS A   2       4.100  10.034  28.660  1.00 31.98           C  
ATOM     17  O   LYS A   2       4.924   9.643  29.509  1.00 29.51           O  
ATOM     18  CB  LYS A   2       4.376  12.485  28.153  1.00 34.88           C  
ATOM     19  CG  LYS A   2       3.658  13.533  27.323  1.00 37.55           C  
ATOM     20  CD  LYS A   2       3.790  14.936  27.850  1.00 40.64           C  
ATOM     21  CE  LYS A   2       3.237  15.903  26.797  1.00 41.60           C  
ATOM     22  NZ  LYS A   2       3.465  17.307  27.200  1.00 42.38           N  
ATOM     23  N   VAL A   3       3.725   9.308  27.597  1.00 29.75           N  
ATOM     24  CA  VAL A   3       4.267   7.972  27.328  1.00 29.50           C  
ATOM     25  C   VAL A   3       5.779   8.005  26.948  1.00 28.01           C  
ATOM     26  O   VAL A   3       6.479   6.987  27.000  1.00 28.71           O  
ATOM     27  CB  VAL A   3       3.394   7.189  26.285  1.00 29.29           C  
ATOM     28  CG1 VAL A   3       1.908   7.127  26.738  1.00 29.26           C  
ATOM     29  CG2 VAL A   3       3.510   7.800  24.900  1.00 29.49           C  
ATOM     30  N   THR A   4       6.268   9.181  26.590  1.00 27.36           N  
ATOM     31  CA  THR A   4       7.658   9.402  26.249  1.00 28.24           C  
ATOM     32  C   THR A   4       8.510   9.959  27.421  1.00 28.05           C  
ATOM     33  O   THR A   4       9.713  10.167  27.256  1.00 26.96           O  
ATOM     34  CB  THR A   4       7.747  10.405  25.068  1.00 28.93           C  
ATOM     35  OG1 THR A   4       7.127  11.641  25.450  1.00 29.25           O  
ATOM     36  CG2 THR A   4       7.055   9.830  23.755  1.00 27.71           C  
ATOM     37  N   GLN A   5       7.910  10.237  28.579  1.00 27.84           N  
ATOM     38  CA  GLN A   5       8.667  10.897  29.672  0.50 27.89           C  
ATOM     40  C   GLN A   5       9.830  10.028  30.182  1.00 28.08           C  
ATOM     41  O   GLN A   5      10.966  10.523  30.356  1.00 26.98           O  
ATOM     42  CB  GLN A   5       7.768  11.316  30.851  0.50 27.80           C  
ATOM     44  CG  GLN A   5       8.575  11.661  32.135  0.50 27.98           C  
ATOM     46  CD  GLN A   5       7.774  12.397  33.202  0.50 28.03           C  
ATOM     48  OE1 GLN A   5       6.650  12.836  32.966  0.50 29.93           O  
ATOM     50  NE2 GLN A   5       8.354  12.518  34.393  0.50 27.73           N  
ATOM     52  N   LEU A   6       9.576   8.758  30.442  1.00 27.85           N  
ATOM     53  CA  LEU A   6      10.674   7.889  30.894  1.00 28.12           C  
ATOM     54  C   LEU A   6      11.831   7.760  29.866  1.00 28.10           C  
ATOM     55  O   LEU A   6      13.004   7.742  30.273  1.00 26.80           O  
ATOM     56  CB  LEU A   6      10.178   6.519  31.387  1.00 28.18           C  
ATOM     57  CG  LEU A   6       9.256   6.452  32.619  1.00 30.18           C  
ATOM     58  CD1 LEU A   6       8.890   5.009  32.980  1.00 29.27           C  
ATOM     59  CD2 LEU A   6       9.899   7.137  33.786  1.00 31.01           C  
ATOM     60  N   SER A   7      11.518   7.696  28.570  1.00 27.73           N  
ATOM     61  CA  SER A   7      12.564   7.706  27.509  1.00 28.14           C  
ATOM     62  C   SER A   7      13.388   8.971  27.543  1.00 28.90           C  
ATOM     63  O   SER A   7      14.615   8.942  27.362  1.00 28.48           O  
ATOM     64  CB  SER A   7      11.947   7.562  26.104  1.00 28.65           C  
ATOM     65  OG  SER A   7      11.230   6.347  25.991  1.00 29.97           O  
ATOM     66  N   SER A   8      12.716  10.088  27.812  1.00 29.20           N  
ATOM     67  CA  SER A   8      13.358  11.379  27.957  1.00 29.86           C  
ATOM     68  C   SER A   8      14.341  11.435  29.151  1.00 29.51           C  
ATOM     69  O   SER A   8      15.462  11.978  29.054  1.00 29.02           O  
ATOM     70  CB  SER A   8      12.268  12.448  28.092  1.00 31.30           C  
ATOM     71  OG  SER A   8      12.803  13.699  27.843  1.00 35.97           O  
ATOM     72  N   GLU A   9      13.927  10.884  30.280  1.00 28.68           N  
ATOM     73  CA  GLU A   9      14.794  10.812  31.442  1.00 29.21           C  
ATOM     74  C   GLU A   9      15.960   9.841  31.195  1.00 28.18           C  
ATOM     75  O   GLU A   9      17.072  10.051  31.687  1.00 27.77           O  
ATOM     76  CB  GLU A   9      13.962  10.454  32.678  1.00 30.11           C  
ATOM     77  CG  GLU A   9      12.948  11.567  32.970  1.00 30.62           C  
ATOM     78  CD  GLU A   9      11.995  11.285  34.098  1.00 33.23           C  
ATOM     79  OE1 GLU A   9      12.066  10.193  34.709  1.00 39.88           O  
ATOM     80  OE2 GLU A   9      11.136  12.181  34.367  1.00 37.44           O  
ATOM     81  N   THR A  10      15.731   8.803  30.405  1.00 28.36           N  
ATOM     82  CA  THR A  10      16.804   7.861  30.041  1.00 28.34           C  
ATOM     83  C   THR A  10      17.882   8.513  29.144  1.00 28.78           C  
ATOM     84  O   THR A  10      19.130   8.251  29.312  1.00 28.72           O  
ATOM     85  CB  THR A  10      16.212   6.588  29.347  1.00 28.99           C  
ATOM     86  OG1 THR A  10      15.235   5.996  30.216  1.00 30.15           O  
ATOM     87  CG2 THR A  10      17.290   5.540  29.032  1.00 29.24           C  
ATOM     88  N   LEU A  11      17.429   9.299  28.160  1.00 28.42           N  
ATOM     89  CA  LEU A  11      18.344  10.111  27.357  1.00 29.05           C  
ATOM     90  C   LEU A  11      19.196  11.078  28.205  1.00 29.45           C  
ATOM     91  O   LEU A  11      20.420  11.240  27.952  1.00 29.75           O  
ATOM     92  CB  LEU A  11      17.555  10.846  26.250  1.00 28.94           C  
ATOM     93  CG  LEU A  11      18.366  11.696  25.262  1.00 29.69           C  
ATOM     94  CD1 LEU A  11      19.360  10.828  24.478  1.00 29.95           C  
ATOM     95  CD2 LEU A  11      17.438  12.446  24.269  1.00 28.90           C  
ATOM     96  N   ASP A  12      18.595  11.677  29.235  1.00 29.28           N  
ATOM     97  CA  ASP A  12      19.344  12.547  30.147  1.00 29.97           C  
ATOM     98  C   ASP A  12      20.514  11.810  30.818  1.00 29.44           C  
ATOM     99  O   ASP A  12      21.582  12.378  30.980  1.00 28.57           O  
ATOM    100  CB  ASP A  12      18.437  13.119  31.251  1.00 31.46           C  
ATOM    101  CG  ASP A  12      17.489  14.210  30.745  1.00 36.70           C  
ATOM    102  OD1 ASP A  12      17.824  14.861  29.718  1.00 42.92           O  
ATOM    103  OD2 ASP A  12      16.448  14.452  31.423  1.00 39.89           O  
ATOM    104  N   ARG A  13      20.335  10.540  31.165  1.00 28.94           N  
ATOM    105  CA  ARG A  13      21.447   9.770  31.737  1.00 28.96           C  
ATOM    106  C   ARG A  13      22.573   9.580  30.728  1.00 28.95           C  
ATOM    107  O   ARG A  13      23.736   9.671  31.116  1.00 30.13           O  
ATOM    108  CB  ARG A  13      21.026   8.393  32.285  1.00 28.94           C  
ATOM    109  CG  ARG A  13      19.822   8.366  33.209  1.00 30.76           C  
ATOM    110  CD  ARG A  13      20.096   9.137  34.484  1.00 31.80           C  
ATOM    111  NE  ARG A  13      19.024   8.825  35.400  1.00 33.90           N  
ATOM    112  CZ  ARG A  13      19.025   7.802  36.253  1.00 34.09           C  
ATOM    113  NH1 ARG A  13      20.085   7.015  36.379  1.00 32.72           N  
ATOM    114  NH2 ARG A  13      17.959   7.597  36.995  1.00 29.86           N  
ATOM    115  N   ALA A  14      22.257   9.317  29.463  1.00 28.10           N  
ATOM    116  CA  ALA A  14      23.283   9.233  28.395  1.00 28.67           C  
ATOM    117  C   ALA A  14      24.052  10.570  28.297  1.00 28.80           C  
ATOM    118  O   ALA A  14      25.301  10.615  28.274  1.00 27.98           O  
ATOM    119  CB  ALA A  14      22.657   8.903  27.056  1.00 28.18           C  
ATOM    120  N   HIS A  15      23.291  11.657  28.279  1.00 27.98           N  
ATOM    121  CA  HIS A  15      23.846  12.996  28.154  1.00 28.95           C  
ATOM    122  C   HIS A  15      24.827  13.286  29.285  1.00 28.79           C  
ATOM    123  O   HIS A  15      25.974  13.709  29.051  1.00 29.14           O  
ATOM    124  CB  HIS A  15      22.684  13.998  28.156  1.00 29.50           C  
ATOM    125  CG  HIS A  15      23.065  15.397  27.785  1.00 29.73           C  
ATOM    126  ND1 HIS A  15      22.176  16.445  27.883  1.00 30.06           N  
ATOM    127  CD2 HIS A  15      24.213  15.921  27.295  1.00 30.18           C  
ATOM    128  CE1 HIS A  15      22.769  17.561  27.484  1.00 31.05           C  
ATOM    129  NE2 HIS A  15      24.003  17.270  27.115  1.00 29.33           N  
ATOM    130  N   GLU A  16      24.371  13.056  30.511  1.00 29.78           N  
ATOM    131  CA  GLU A  16      25.195  13.202  31.724  1.00 31.08           C  
ATOM    132  C   GLU A  16      26.456  12.324  31.700  1.00 29.84           C  
ATOM    133  O   GLU A  16      27.556  12.767  32.078  1.00 28.44           O  
ATOM    134  CB  GLU A  16      24.326  12.913  32.991  1.00 31.06           C  
ATOM    135  CG  GLU A  16      23.232  13.967  33.143  1.00 36.38           C  
ATOM    136  CD  GLU A  16      22.033  13.629  34.082  1.00 39.74           C  
ATOM    137  OE1 GLU A  16      21.855  12.459  34.529  1.00 48.52           O  
ATOM    138  OE2 GLU A  16      21.247  14.595  34.389  1.00 49.95           O  
ATOM    139  N   ARG A  17      26.323  11.084  31.252  1.00 28.95           N  
ATOM    140  CA  ARG A  17      27.493  10.202  31.189  1.00 29.17           C  
ATOM    141  C   ARG A  17      28.570  10.706  30.203  1.00 28.57           C  
ATOM    142  O   ARG A  17      29.731  10.688  30.517  1.00 28.48           O  
ATOM    143  CB  ARG A  17      27.068   8.794  30.806  1.00 29.45           C  
ATOM    144  CG  ARG A  17      28.203   7.768  30.683  1.00 28.89           C  
ATOM    145  CD  ARG A  17      27.671   6.360  30.553  1.00 29.02           C  
ATOM    146  NE  ARG A  17      26.944   5.970  31.757  1.00 27.61           N  
ATOM    147  CZ  ARG A  17      25.629   5.739  31.833  1.00 29.12           C  
ATOM    148  NH1 ARG A  17      24.845   5.804  30.772  1.00 28.98           N  
ATOM    149  NH2 ARG A  17      25.112   5.394  32.978  1.00 31.39           N  
ATOM    150  N   PHE A  18      28.165  11.139  29.015  1.00 27.57           N  
ATOM    151  CA  PHE A  18      29.101  11.708  28.050  1.00 28.69           C  
ATOM    152  C   PHE A  18      29.835  12.941  28.658  1.00 28.42           C  
ATOM    153  O   PHE A  18      31.056  13.066  28.534  1.00 29.68           O  
ATOM    154  CB  PHE A  18      28.355  12.125  26.781  1.00 28.52           C  
ATOM    155  CG  PHE A  18      28.213  11.045  25.740  1.00 29.81           C  
ATOM    156  CD1 PHE A  18      29.322  10.530  25.104  1.00 29.83           C  
ATOM    157  CD2 PHE A  18      26.973  10.632  25.314  1.00 28.71           C  
ATOM    158  CE1 PHE A  18      29.194   9.539  24.123  1.00 31.00           C  
ATOM    159  CE2 PHE A  18      26.865   9.676  24.349  1.00 30.64           C  
ATOM    160  CZ  PHE A  18      27.999   9.136  23.756  1.00 29.27           C  
ATOM    161  N   GLU A  19      29.091  13.846  29.293  1.00 28.07           N  
ATOM    162  CA  GLU A  19      29.713  15.005  29.922  1.00 30.12           C  
ATOM    163  C   GLU A  19      30.696  14.641  31.067  1.00 29.74           C  
ATOM    164  O   GLU A  19      31.754  15.241  31.159  1.00 30.13           O  
ATOM    165  CB  GLU A  19      28.653  16.002  30.411  1.00 29.99           C  
ATOM    166  CG  GLU A  19      27.890  16.749  29.316  1.00 34.14           C  
ATOM    167  CD  GLU A  19      28.765  17.471  28.243  1.00 40.66           C  
ATOM    168  OE1 GLU A  19      29.809  18.069  28.567  1.00 43.32           O  
ATOM    169  OE2 GLU A  19      28.379  17.423  27.058  1.00 46.01           O  
ATOM    170  N   GLU A  20      30.364  13.678  31.923  1.00 29.91           N  
ATOM    171  CA  GLU A  20      31.256  13.264  33.010  1.00 31.91           C  
ATOM    172  C   GLU A  20      32.534  12.636  32.465  1.00 30.02           C  
ATOM    173  O   GLU A  20      33.600  12.800  33.041  1.00 30.60           O  
ATOM    174  CB  GLU A  20      30.602  12.229  33.939  1.00 32.40           C  
ATOM    175  CG  GLU A  20      29.402  12.723  34.683  1.00 38.00           C  
ATOM    176  CD  GLU A  20      28.582  11.621  35.398  1.00 39.49           C  
ATOM    177  OE1 GLU A  20      28.675  10.407  35.035  1.00 50.86           O  
ATOM    178  OE2 GLU A  20      27.832  11.993  36.328  1.00 48.66           O  
ATOM    179  N   THR A  21      32.418  11.880  31.382  1.00 29.45           N  
ATOM    180  CA  THR A  21      33.580  11.286  30.738  1.00 30.22           C  
ATOM    181  C   THR A  21      34.492  12.349  30.094  1.00 30.11           C  
ATOM    182  O   THR A  21      35.692  12.379  30.358  1.00 30.57           O  
ATOM    183  CB  THR A  21      33.128  10.168  29.735  1.00 30.47           C  
ATOM    184  OG1 THR A  21      32.954   8.957  30.462  1.00 33.16           O  
ATOM    185  CG2 THR A  21      34.128   9.929  28.642  1.00 30.50           C  
ATOM    186  N   LEU A  22      33.906  13.226  29.282  1.00 29.73           N  
ATOM    187  CA  LEU A  22      34.636  14.304  28.630  1.00 30.36           C  
ATOM    188  C   LEU A  22      35.374  15.219  29.610  1.00 30.14           C  
ATOM    189  O   LEU A  22      36.471  15.629  29.328  1.00 28.95           O  
ATOM    190  CB  LEU A  22      33.694  15.149  27.769  1.00 29.89           C  
ATOM    191  CG  LEU A  22      34.353  16.089  26.776  1.00 30.63           C  
ATOM    192  CD1 LEU A  22      35.182  15.322  25.718  1.00 29.80           C  
ATOM    193  CD2 LEU A  22      33.237  16.936  26.117  1.00 30.63           C  
ATOM    194  N   ALA A  23      34.753  15.515  30.746  1.00 30.29           N  
ATOM    195  CA  ALA A  23      35.356  16.328  31.794  1.00 31.26           C  
ATOM    196  C   ALA A  23      36.678  15.743  32.306  1.00 31.81           C  
ATOM    197  O   ALA A  23      37.474  16.480  32.866  1.00 32.86           O  
ATOM    198  CB  ALA A  23      34.366  16.561  33.001  1.00 30.69           C  
ATOM    199  N   GLN A  24      36.922  14.440  32.141  1.00 31.76           N  
ATOM    200  CA  GLN A  24      38.182  13.852  32.627  1.00 32.19           C  
ATOM    201  C   GLN A  24      39.291  13.909  31.602  1.00 30.92           C  
ATOM    202  O   GLN A  24      40.405  13.493  31.907  1.00 31.75           O  
ATOM    203  CB  GLN A  24      37.979  12.408  33.087  1.00 32.31           C  
ATOM    204  CG  GLN A  24      36.969  12.296  34.231  1.00 35.02           C  
ATOM    205  CD  GLN A  24      36.667  10.864  34.583  1.00 35.85           C  
ATOM    206  OE1 GLN A  24      37.566  10.105  35.013  1.00 41.02           O  
ATOM    207  NE2 GLN A  24      35.399  10.466  34.400  1.00 39.69           N  
HETATM  208  N   MSE A  25      39.025  14.427  30.405  1.00 29.30           N  
HETATM  209  CA  MSE A  25      39.991  14.311  29.320  1.00 30.41           C  
HETATM  210  C   MSE A  25      40.430  15.661  28.788  1.00 29.36           C  
HETATM  211  O   MSE A  25      39.668  16.602  28.814  1.00 30.72           O  
HETATM  212  CB  MSE A  25      39.370  13.512  28.157  1.00 29.85           C  
HETATM  213  CG  MSE A  25      38.810  12.203  28.645  1.00 31.38           C  
HETATM  214 SE   MSE A  25      37.860  11.175  27.299  0.80 35.37          SE  
HETATM  215  CE  MSE A  25      39.359  10.122  26.514  1.00 27.15           C  
ATOM    216  N   THR A  26      41.647  15.727  28.274  1.00 27.73           N  
ATOM    217  CA  THR A  26      42.063  16.835  27.406  1.00 27.85           C  
ATOM    218  C   THR A  26      41.441  16.602  26.027  1.00 27.51           C  
ATOM    219  O   THR A  26      40.964  15.503  25.747  1.00 26.64           O  
ATOM    220  CB  THR A  26      43.601  16.888  27.257  1.00 27.92           C  
ATOM    221  OG1 THR A  26      44.039  15.705  26.562  1.00 27.20           O  
ATOM    222  CG2 THR A  26      44.284  16.988  28.644  1.00 26.36           C  
ATOM    223  N   VAL A  27      41.411  17.632  25.184  1.00 27.47           N  
ATOM    224  CA  VAL A  27      40.872  17.479  23.839  1.00 27.99           C  
ATOM    225  C   VAL A  27      41.722  16.481  23.034  1.00 27.44           C  
ATOM    226  O   VAL A  27      41.172  15.704  22.280  1.00 27.23           O  
ATOM    227  CB  VAL A  27      40.701  18.847  23.075  1.00 29.13           C  
ATOM    228  CG1 VAL A  27      41.981  19.529  22.896  1.00 29.21           C  
ATOM    229  CG2 VAL A  27      40.059  18.636  21.706  1.00 29.17           C  
ATOM    230  N   ALA A  28      43.046  16.480  23.209  1.00 27.11           N  
ATOM    231  CA  ALA A  28      43.911  15.498  22.523  1.00 27.08           C  
ATOM    232  C   ALA A  28      43.535  14.061  22.881  1.00 26.78           C  
ATOM    233  O   ALA A  28      43.448  13.180  22.008  1.00 25.76           O  
ATOM    234  CB  ALA A  28      45.411  15.767  22.819  1.00 27.27           C  
ATOM    235  N   GLU A  29      43.249  13.836  24.156  1.00 26.69           N  
ATOM    236  CA  GLU A  29      42.802  12.524  24.633  1.00 26.78           C  
ATOM    237  C   GLU A  29      41.446  12.158  24.060  1.00 26.36           C  
ATOM    238  O   GLU A  29      41.241  11.016  23.627  1.00 26.50           O  
ATOM    239  CB  GLU A  29      42.740  12.487  26.160  1.00 26.55           C  
ATOM    240  CG  GLU A  29      44.137  12.285  26.790  1.00 27.58           C  
ATOM    241  CD  GLU A  29      44.234  12.716  28.238  1.00 28.77           C  
ATOM    242  OE1 GLU A  29      43.219  13.194  28.818  1.00 28.49           O  
ATOM    243  OE2 GLU A  29      45.353  12.564  28.808  1.00 29.51           O  
ATOM    244  N   ALA A  30      40.526  13.110  24.074  1.00 26.21           N  
ATOM    245  CA  ALA A  30      39.178  12.905  23.530  1.00 26.46           C  
ATOM    246  C   ALA A  30      39.224  12.537  22.054  1.00 26.59           C  
ATOM    247  O   ALA A  30      38.390  11.768  21.583  1.00 26.68           O  
ATOM    248  CB  ALA A  30      38.334  14.171  23.707  1.00 25.77           C  
ATOM    249  N   ASN A  31      40.165  13.133  21.323  1.00 26.30           N  
ATOM    250  CA  ASN A  31      40.355  12.851  19.892  1.00 27.05           C  
ATOM    251  C   ASN A  31      41.055  11.518  19.588  1.00 27.43           C  
ATOM    252  O   ASN A  31      41.223  11.163  18.430  1.00 27.12           O  
ATOM    253  CB  ASN A  31      41.202  13.974  19.262  1.00 27.04           C  
ATOM    254  CG  ASN A  31      40.438  15.264  19.095  1.00 26.59           C  
ATOM    255  OD1 ASN A  31      39.219  15.263  19.013  1.00 26.38           O  
ATOM    256  ND2 ASN A  31      41.160  16.365  18.998  1.00 25.19           N  
ATOM    257  N   THR A  32      41.515  10.811  20.616  1.00 27.83           N  
ATOM    258  CA  THR A  32      42.352   9.649  20.421  1.00 28.30           C  
ATOM    259  C   THR A  32      41.528   8.397  20.221  1.00 30.46           C  
ATOM    260  O   THR A  32      40.706   8.027  21.090  1.00 28.41           O  
ATOM    261  CB  THR A  32      43.296   9.447  21.597  1.00 28.35           C  
ATOM    262  OG1 THR A  32      44.175  10.576  21.659  1.00 29.20           O  
ATOM    263  CG2 THR A  32      44.138   8.145  21.435  1.00 27.32           C  
HETATM  264  N   MSE A  33      41.759   7.714  19.096  1.00 32.02           N  
HETATM  265  CA  MSE A  33      41.074   6.431  18.903  1.00 35.70           C  
HETATM  266  C   MSE A  33      42.044   5.305  19.211  1.00 35.14           C  
HETATM  267  O   MSE A  33      43.097   5.203  18.575  1.00 35.08           O  
HETATM  268  CB  MSE A  33      40.313   6.357  17.562  1.00 35.13           C  
HETATM  269  CG  MSE A  33      41.018   6.022  16.336  1.00 39.65           C  
HETATM  270 SE   MSE A  33      39.644   5.839  14.904  0.80 44.88          SE  
HETATM  271  CE  MSE A  33      39.063   4.000  15.135  1.00 40.88           C  
ATOM    272  N   PRO A  34      41.767   4.533  20.285  1.00 35.38           N  
ATOM    273  CA  PRO A  34      42.748   3.550  20.742  1.00 35.75           C  
ATOM    274  C   PRO A  34      42.965   2.296  19.861  1.00 36.21           C  
ATOM    275  O   PRO A  34      43.936   1.575  20.080  1.00 36.80           O  
ATOM    276  CB  PRO A  34      42.264   3.174  22.164  1.00 35.97           C  
ATOM    277  CG  PRO A  34      40.876   3.584  22.262  1.00 34.56           C  
ATOM    278  CD  PRO A  34      40.586   4.586  21.165  1.00 35.28           C  
ATOM    279  N   ALA A  35      42.117   2.062  18.865  1.00 36.38           N  
ATOM    280  CA  ALA A  35      42.227   0.865  18.016  1.00 36.16           C  
ATOM    281  C   ALA A  35      41.317   1.040  16.814  1.00 36.41           C  
ATOM    282  O   ALA A  35      40.385   1.839  16.858  1.00 36.06           O  
ATOM    283  CB  ALA A  35      41.837  -0.412  18.800  1.00 35.83           C  
ATOM    284  N   PRO A  36      41.581   0.295  15.722  1.00 36.24           N  
ATOM    285  CA  PRO A  36      40.737   0.421  14.523  1.00 35.86           C  
ATOM    286  C   PRO A  36      39.227   0.373  14.745  1.00 35.45           C  
ATOM    287  O   PRO A  36      38.494   1.098  14.061  1.00 36.72           O  
ATOM    288  CB  PRO A  36      41.220  -0.743  13.639  1.00 36.67           C  
ATOM    289  CG  PRO A  36      42.646  -0.905  14.023  1.00 36.39           C  
ATOM    290  CD  PRO A  36      42.725  -0.613  15.498  1.00 36.39           C  
ATOM    291  N   LEU A  37      38.771  -0.440  15.711  1.00 34.48           N  
ATOM    292  CA  LEU A  37      37.349  -0.688  15.943  1.00 33.38           C  
ATOM    293  C   LEU A  37      36.841  -0.061  17.239  1.00 31.35           C  
ATOM    294  O   LEU A  37      35.697  -0.271  17.601  1.00 31.74           O  
ATOM    295  CB  LEU A  37      37.055  -2.208  15.972  1.00 34.00           C  
ATOM    296  CG  LEU A  37      37.565  -3.036  14.779  1.00 34.10           C  
ATOM    297  CD1 LEU A  37      37.332  -4.535  14.931  1.00 35.17           C  
ATOM    298  CD2 LEU A  37      36.915  -2.514  13.505  1.00 33.34           C  
ATOM    299  N   ILE A  38      37.704   0.676  17.931  1.00 29.43           N  
ATOM    300  CA  ILE A  38      37.360   1.379  19.131  1.00 28.23           C  
ATOM    301  C   ILE A  38      37.395   2.880  18.810  1.00 27.71           C  
ATOM    302  O   ILE A  38      38.474   3.457  18.579  1.00 29.22           O  
ATOM    303  CB  ILE A  38      38.337   1.048  20.269  1.00 27.95           C  
ATOM    304  CG1 ILE A  38      38.406  -0.460  20.507  1.00 28.82           C  
ATOM    305  CG2 ILE A  38      37.954   1.836  21.533  1.00 25.93           C  
ATOM    306  CD1 ILE A  38      37.063  -1.106  20.898  1.00 28.47           C  
ATOM    307  N   LYS A  39      36.227   3.479  18.723  1.00 26.46           N  
ATOM    308  CA  LYS A  39      36.057   4.902  18.437  1.00 26.01           C  
ATOM    309  C   LYS A  39      36.549   5.812  19.580  1.00 25.90           C  
ATOM    310  O   LYS A  39      36.511   5.452  20.768  1.00 25.64           O  
ATOM    311  CB  LYS A  39      34.582   5.213  18.099  1.00 26.45           C  
ATOM    312  CG  LYS A  39      33.941   4.395  16.928  1.00 27.18           C  
ATOM    313  CD  LYS A  39      34.561   4.775  15.558  1.00 30.28           C  
ATOM    314  CE  LYS A  39      33.628   4.362  14.409  1.00 32.90           C  
ATOM    315  NZ  LYS A  39      33.668   2.891  14.088  1.00 31.71           N  
ATOM    316  N   SER A  40      37.050   6.983  19.209  1.00 25.63           N  
ATOM    317  CA  SER A  40      37.387   8.038  20.163  1.00 25.41           C  
ATOM    318  C   SER A  40      36.152   8.548  20.853  1.00 25.32           C  
ATOM    319  O   SER A  40      35.038   8.398  20.333  1.00 25.37           O  
ATOM    320  CB  SER A  40      38.077   9.207  19.450  1.00 25.88           C  
ATOM    321  OG  SER A  40      37.219   9.917  18.576  1.00 24.91           O  
ATOM    322  N   VAL A  41      36.341   9.150  22.019  1.00 25.00           N  
ATOM    323  CA  VAL A  41      35.230   9.832  22.707  1.00 25.32           C  
ATOM    324  C   VAL A  41      34.694  10.965  21.838  1.00 24.91           C  
ATOM    325  O   VAL A  41      33.491  11.143  21.743  1.00 25.55           O  
ATOM    326  CB  VAL A  41      35.615  10.311  24.129  1.00 24.83           C  
ATOM    327  CG1 VAL A  41      34.521  11.182  24.765  1.00 25.77           C  
ATOM    328  CG2 VAL A  41      35.896   9.105  25.011  1.00 25.76           C  
ATOM    329  N   THR A  42      35.567  11.682  21.147  1.00 24.76           N  
ATOM    330  CA  THR A  42      35.110  12.728  20.217  1.00 24.95           C  
ATOM    331  C   THR A  42      34.184  12.135  19.145  1.00 24.97           C  
ATOM    332  O   THR A  42      33.077  12.665  18.915  1.00 23.89           O  
ATOM    333  CB  THR A  42      36.262  13.442  19.525  1.00 24.00           C  
ATOM    334  OG1 THR A  42      36.994  14.208  20.477  1.00 24.98           O  
ATOM    335  CG2 THR A  42      35.738  14.392  18.415  1.00 24.64           C  
ATOM    336  N   TRP A  43      34.593  11.026  18.520  1.00 25.51           N  
ATOM    337  CA  TRP A  43      33.712  10.377  17.505  1.00 25.85           C  
ATOM    338  C   TRP A  43      32.363   9.946  18.101  1.00 26.33           C  
ATOM    339  O   TRP A  43      31.312  10.164  17.507  1.00 24.04           O  
ATOM    340  CB  TRP A  43      34.401   9.182  16.867  1.00 26.97           C  
ATOM    341  CG  TRP A  43      33.664   8.612  15.650  1.00 27.08           C  
ATOM    342  CD1 TRP A  43      33.970   8.851  14.343  1.00 29.10           C  
ATOM    343  CD2 TRP A  43      32.518   7.737  15.637  1.00 27.25           C  
ATOM    344  NE1 TRP A  43      33.113   8.189  13.523  1.00 28.64           N  
ATOM    345  CE2 TRP A  43      32.198   7.501  14.278  1.00 29.20           C  
ATOM    346  CE3 TRP A  43      31.739   7.123  16.631  1.00 29.16           C  
ATOM    347  CZ2 TRP A  43      31.127   6.666  13.880  1.00 29.22           C  
ATOM    348  CZ3 TRP A  43      30.656   6.306  16.238  1.00 29.38           C  
ATOM    349  CH2 TRP A  43      30.357   6.100  14.874  1.00 28.13           C  
ATOM    350  N   LEU A  44      32.409   9.322  19.286  1.00 26.95           N  
ATOM    351  CA  LEU A  44      31.193   8.821  19.952  1.00 27.62           C  
ATOM    352  C   LEU A  44      30.204   9.926  20.291  1.00 28.23           C  
ATOM    353  O   LEU A  44      29.000   9.778  20.085  1.00 28.91           O  
ATOM    354  CB  LEU A  44      31.566   8.036  21.223  1.00 27.03           C  
ATOM    355  CG  LEU A  44      32.238   6.702  20.906  1.00 25.79           C  
ATOM    356  CD1 LEU A  44      32.968   6.120  22.112  1.00 27.37           C  
ATOM    357  CD2 LEU A  44      31.159   5.686  20.360  1.00 26.28           C  
HETATM  358  N   MSE A  45      30.706  11.031  20.820  1.00 28.91           N  
HETATM  359  CA  MSE A  45      29.838  12.176  21.163  1.00 30.32           C  
HETATM  360  C   MSE A  45      29.319  12.892  19.934  1.00 28.84           C  
HETATM  361  O   MSE A  45      28.173  13.228  19.879  1.00 28.89           O  
HETATM  362  CB  MSE A  45      30.587  13.188  22.020  1.00 29.61           C  
HETATM  363  CG  MSE A  45      30.540  12.875  23.410  1.00 35.01           C  
HETATM  364 SE   MSE A  45      31.236  14.248  24.599  0.80 39.17          SE  
HETATM  365  CE  MSE A  45      29.775  15.445  24.932  1.00 32.43           C  
ATOM    366  N   TRP A  46      30.172  13.124  18.947  1.00 29.10           N  
ATOM    367  CA  TRP A  46      29.723  13.711  17.683  1.00 28.91           C  
ATOM    368  C   TRP A  46      28.678  12.809  17.023  1.00 28.75           C  
ATOM    369  O   TRP A  46      27.614  13.269  16.580  1.00 26.91           O  
ATOM    370  CB  TRP A  46      30.916  13.875  16.744  1.00 28.69           C  
ATOM    371  CG  TRP A  46      30.508  14.131  15.345  1.00 29.12           C  
ATOM    372  CD1 TRP A  46      30.127  15.335  14.819  1.00 29.15           C  
ATOM    373  CD2 TRP A  46      30.411  13.176  14.271  1.00 28.42           C  
ATOM    374  NE1 TRP A  46      29.819  15.180  13.514  1.00 28.83           N  
ATOM    375  CE2 TRP A  46      29.984  13.872  13.149  1.00 28.50           C  
ATOM    376  CE3 TRP A  46      30.651  11.794  14.166  1.00 28.93           C  
ATOM    377  CZ2 TRP A  46      29.804  13.252  11.903  1.00 29.34           C  
ATOM    378  CZ3 TRP A  46      30.471  11.186  12.975  1.00 28.54           C  
ATOM    379  CH2 TRP A  46      30.039  11.906  11.842  1.00 30.33           C  
ATOM    380  N   HIS A  47      28.963  11.501  16.988  1.00 28.13           N  
ATOM    381  CA  HIS A  47      28.046  10.567  16.347  1.00 29.04           C  
ATOM    382  C   HIS A  47      26.693  10.507  17.037  1.00 28.72           C  
ATOM    383  O   HIS A  47      25.687  10.465  16.371  1.00 28.43           O  
ATOM    384  CB  HIS A  47      28.599   9.150  16.269  1.00 30.84           C  
ATOM    385  CG  HIS A  47      27.543   8.121  15.994  1.00 32.93           C  
ATOM    386  ND1 HIS A  47      27.096   7.843  14.725  1.00 34.37           N  
ATOM    387  CD2 HIS A  47      26.817   7.336  16.830  1.00 37.34           C  
ATOM    388  CE1 HIS A  47      26.155   6.915  14.785  1.00 35.48           C  
ATOM    389  NE2 HIS A  47      25.956   6.597  16.050  1.00 37.74           N  
ATOM    390  N   THR A  48      26.688  10.493  18.370  1.00 28.43           N  
ATOM    391  CA  THR A  48      25.446  10.488  19.136  1.00 28.21           C  
ATOM    392  C   THR A  48      24.647  11.762  18.860  1.00 28.88           C  
ATOM    393  O   THR A  48      23.457  11.680  18.604  1.00 28.47           O  
ATOM    394  CB  THR A  48      25.727  10.288  20.628  1.00 28.89           C  
ATOM    395  OG1 THR A  48      26.365   9.000  20.775  1.00 29.57           O  
ATOM    396  CG2 THR A  48      24.412  10.346  21.501  1.00 28.24           C  
ATOM    397  N   ALA A  49      25.290  12.928  18.917  1.00 28.15           N  
ATOM    398  CA  ALA A  49      24.612  14.190  18.611  1.00 28.74           C  
ATOM    399  C   ALA A  49      24.110  14.161  17.166  1.00 29.45           C  
ATOM    400  O   ALA A  49      22.978  14.568  16.894  1.00 29.52           O  
ATOM    401  CB  ALA A  49      25.531  15.368  18.840  1.00 27.71           C  
ATOM    402  N   ARG A  50      24.931  13.666  16.257  1.00 30.50           N  
ATOM    403  CA  ARG A  50      24.589  13.633  14.840  1.00 31.61           C  
ATOM    404  C   ARG A  50      23.401  12.704  14.547  1.00 32.45           C  
ATOM    405  O   ARG A  50      22.517  13.043  13.745  1.00 33.03           O  
ATOM    406  CB  ARG A  50      25.845  13.258  14.029  1.00 32.61           C  
ATOM    407  CG  ARG A  50      25.780  13.392  12.546  1.00 35.12           C  
ATOM    408  CD  ARG A  50      25.970  14.800  12.054  1.00 41.19           C  
ATOM    409  NE  ARG A  50      26.368  14.722  10.646  1.00 46.31           N  
ATOM    410  CZ  ARG A  50      25.558  14.826   9.592  1.00 48.28           C  
ATOM    411  NH1 ARG A  50      24.260  15.068   9.735  1.00 51.62           N  
ATOM    412  NH2 ARG A  50      26.060  14.710   8.370  1.00 50.79           N  
ATOM    413  N   GLU A  51      23.355  11.550  15.207  1.00 32.40           N  
ATOM    414  CA  GLU A  51      22.303  10.604  14.941  1.00 33.76           C  
ATOM    415  C   GLU A  51      20.941  11.036  15.533  1.00 33.32           C  
ATOM    416  O   GLU A  51      19.908  10.804  14.906  1.00 32.91           O  
ATOM    417  CB  GLU A  51      22.716   9.214  15.450  1.00 34.59           C  
ATOM    418  CG  GLU A  51      21.742   8.135  15.131  1.00 40.83           C  
ATOM    419  CD  GLU A  51      21.792   7.645  13.688  1.00 45.94           C  
ATOM    420  OE1 GLU A  51      22.264   8.364  12.778  1.00 52.58           O  
ATOM    421  OE2 GLU A  51      21.339   6.510  13.464  1.00 52.67           O  
ATOM    422  N   LEU A  52      20.936  11.581  16.751  1.00 32.47           N  
ATOM    423  CA  LEU A  52      19.724  12.227  17.306  1.00 32.50           C  
ATOM    424  C   LEU A  52      19.215  13.343  16.387  1.00 32.49           C  
ATOM    425  O   LEU A  52      18.020  13.424  16.052  1.00 32.06           O  
ATOM    426  CB  LEU A  52      20.005  12.793  18.703  1.00 31.82           C  
ATOM    427  CG  LEU A  52      20.321  11.774  19.834  1.00 32.17           C  
ATOM    428  CD1 LEU A  52      20.769  12.470  21.130  1.00 30.56           C  
ATOM    429  CD2 LEU A  52      19.108  10.861  20.088  1.00 31.84           C  
ATOM    430  N   ASP A  53      20.117  14.253  16.039  1.00 31.68           N  
ATOM    431  CA  ASP A  53      19.821  15.329  15.108  1.00 32.33           C  
ATOM    432  C   ASP A  53      19.179  14.790  13.807  1.00 31.49           C  
ATOM    433  O   ASP A  53      18.019  15.074  13.508  1.00 31.73           O  
ATOM    434  CB  ASP A  53      21.127  16.103  14.807  1.00 31.53           C  
ATOM    435  CG  ASP A  53      20.918  17.342  13.943  1.00 32.70           C  
ATOM    436  OD1 ASP A  53      19.767  17.818  13.793  1.00 30.34           O  
ATOM    437  OD2 ASP A  53      21.948  17.865  13.443  1.00 30.69           O  
ATOM    438  N   LEU A  54      19.923  13.994  13.058  1.00 31.59           N  
ATOM    439  CA  LEU A  54      19.417  13.472  11.777  1.00 32.73           C  
ATOM    440  C   LEU A  54      18.093  12.706  11.889  1.00 31.95           C  
ATOM    441  O   LEU A  54      17.187  12.896  11.084  1.00 29.84           O  
ATOM    442  CB  LEU A  54      20.454  12.577  11.109  1.00 34.12           C  
ATOM    443  CG  LEU A  54      21.603  13.331  10.435  1.00 38.00           C  
ATOM    444  CD1 LEU A  54      22.596  12.305   9.878  1.00 42.17           C  
ATOM    445  CD2 LEU A  54      21.106  14.275   9.348  1.00 41.93           C  
ATOM    446  N   GLN A  55      17.977  11.838  12.878  1.00 32.14           N  
ATOM    447  CA  GLN A  55      16.765  11.017  12.970  1.00 33.13           C  
ATOM    448  C   GLN A  55      15.528  11.802  13.404  1.00 33.38           C  
ATOM    449  O   GLN A  55      14.434  11.597  12.850  1.00 32.87           O  
ATOM    450  CB  GLN A  55      16.957   9.854  13.924  1.00 33.48           C  
ATOM    451  CG  GLN A  55      17.999   8.820  13.479  1.00 36.24           C  
ATOM    452  CD  GLN A  55      17.617   8.011  12.262  1.00 41.99           C  
ATOM    453  OE1 GLN A  55      16.661   8.325  11.528  1.00 44.50           O  
ATOM    454  NE2 GLN A  55      18.391   6.968  12.019  1.00 45.63           N  
ATOM    455  N   ILE A  56      15.697  12.655  14.414  1.00 32.81           N  
ATOM    456  CA  ILE A  56      14.602  13.470  14.903  1.00 33.86           C  
ATOM    457  C   ILE A  56      14.265  14.523  13.875  1.00 34.04           C  
ATOM    458  O   ILE A  56      13.100  14.790  13.653  1.00 34.99           O  
ATOM    459  CB  ILE A  56      14.897  14.160  16.278  1.00 33.29           C  
ATOM    460  CG1 ILE A  56      15.089  13.122  17.379  1.00 33.23           C  
ATOM    461  CG2 ILE A  56      13.757  15.148  16.638  1.00 33.11           C  
ATOM    462  CD1 ILE A  56      13.831  12.370  17.757  1.00 31.03           C  
ATOM    463  N   SER A  57      15.260  15.103  13.218  1.00 34.57           N  
ATOM    464  CA  SER A  57      14.956  16.114  12.183  1.00 35.24           C  
ATOM    465  C   SER A  57      14.188  15.494  11.005  1.00 35.94           C  
ATOM    466  O   SER A  57      13.287  16.124  10.478  1.00 36.64           O  
ATOM    467  CB  SER A  57      16.219  16.826  11.701  1.00 34.22           C  
ATOM    468  OG  SER A  57      16.770  17.595  12.758  1.00 34.34           O  
ATOM    469  N   ALA A  58      14.546  14.271  10.616  1.00 36.93           N  
ATOM    470  CA  ALA A  58      13.812  13.502   9.597  1.00 37.78           C  
ATOM    471  C   ALA A  58      12.346  13.180   9.998  1.00 38.90           C  
ATOM    472  O   ALA A  58      11.446  13.334   9.196  1.00 39.32           O  
ATOM    473  CB  ALA A  58      14.576  12.215   9.249  1.00 37.07           C  
ATOM    474  N   LEU A  59      12.102  12.756  11.235  1.00 39.96           N  
ATOM    475  CA  LEU A  59      10.724  12.601  11.742  1.00 41.21           C  
ATOM    476  C   LEU A  59       9.948  13.923  11.787  1.00 42.62           C  
ATOM    477  O   LEU A  59       8.724  13.937  11.697  1.00 43.22           O  
ATOM    478  CB  LEU A  59      10.724  12.014  13.153  1.00 40.71           C  
ATOM    479  CG  LEU A  59      11.207  10.575  13.289  1.00 39.91           C  
ATOM    480  CD1 LEU A  59      11.281  10.225  14.750  1.00 38.12           C  
ATOM    481  CD2 LEU A  59      10.301   9.584  12.517  1.00 38.75           C  
ATOM    482  N   ASN A  60      10.677  15.023  11.963  1.00 44.07           N  
ATOM    483  CA  ASN A  60      10.096  16.348  12.106  1.00 44.88           C  
ATOM    484  C   ASN A  60      10.038  17.081  10.771  1.00 45.46           C  
ATOM    485  O   ASN A  60       9.676  18.249  10.730  1.00 46.43           O  
ATOM    486  CB  ASN A  60      10.939  17.139  13.101  1.00 45.31           C  
ATOM    487  CG  ASN A  60      10.156  18.173  13.832  1.00 47.42           C  
ATOM    488  OD1 ASN A  60       9.153  17.861  14.463  1.00 51.17           O  
ATOM    489  ND2 ASN A  60      10.612  19.428  13.768  1.00 48.90           N  
ATOM    490  N   HIS A  61      10.424  16.398   9.692  1.00 45.76           N  
ATOM    491  CA  HIS A  61      10.495  16.973   8.352  1.00 46.16           C  
ATOM    492  C   HIS A  61      11.276  18.292   8.286  1.00 45.91           C  
ATOM    493  O   HIS A  61      11.000  19.130   7.423  1.00 46.28           O  
ATOM    494  CB  HIS A  61       9.069  17.133   7.758  1.00 47.52           C  
ATOM    495  CG  HIS A  61       8.319  15.838   7.670  1.00 50.53           C  
ATOM    496  ND1 HIS A  61       8.379  15.014   6.564  1.00 53.21           N  
ATOM    497  CD2 HIS A  61       7.548  15.189   8.579  1.00 54.06           C  
ATOM    498  CE1 HIS A  61       7.662  13.926   6.785  1.00 53.43           C  
ATOM    499  NE2 HIS A  61       7.149  14.004   8.002  1.00 54.27           N  
ATOM    500  N   SER A  62      12.252  18.469   9.182  1.00 44.84           N  
ATOM    501  CA  SER A  62      13.049  19.700   9.233  1.00 43.54           C  
ATOM    502  C   SER A  62      14.481  19.375   8.818  1.00 42.38           C  
ATOM    503  O   SER A  62      14.906  18.211   8.860  1.00 42.02           O  
ATOM    504  CB  SER A  62      12.986  20.362  10.634  1.00 43.87           C  
ATOM    505  OG  SER A  62      13.318  19.474  11.729  1.00 46.39           O  
ATOM    506  N   ASP A  63      15.210  20.399   8.381  1.00 40.66           N  
ATOM    507  CA  ASP A  63      16.632  20.256   8.054  1.00 39.48           C  
ATOM    508  C   ASP A  63      17.366  19.969   9.369  1.00 37.18           C  
ATOM    509  O   ASP A  63      17.025  20.552  10.389  1.00 37.71           O  
ATOM    510  CB  ASP A  63      17.204  21.552   7.431  1.00 39.86           C  
ATOM    511  CG  ASP A  63      17.179  21.560   5.884  1.00 43.18           C  
ATOM    512  OD1 ASP A  63      16.730  20.569   5.240  1.00 46.90           O  
ATOM    513  OD2 ASP A  63      17.621  22.580   5.299  1.00 44.74           O  
ATOM    514  N   PRO A  64      18.377  19.099   9.352  1.00 34.74           N  
ATOM    515  CA  PRO A  64      19.105  18.859  10.596  1.00 33.81           C  
ATOM    516  C   PRO A  64      19.881  20.081  11.087  1.00 31.93           C  
ATOM    517  O   PRO A  64      20.278  20.916  10.286  1.00 30.66           O  
ATOM    518  CB  PRO A  64      20.064  17.722  10.221  1.00 34.12           C  
ATOM    519  CG  PRO A  64      20.230  17.825   8.782  1.00 34.85           C  
ATOM    520  CD  PRO A  64      18.915  18.294   8.242  1.00 35.67           C  
ATOM    521  N   LEU A  65      20.072  20.187  12.397  1.00 30.80           N  
ATOM    522  CA  LEU A  65      20.792  21.312  13.001  1.00 30.62           C  
ATOM    523  C   LEU A  65      22.231  21.393  12.517  1.00 30.02           C  
ATOM    524  O   LEU A  65      22.793  22.494  12.430  1.00 29.27           O  
ATOM    525  CB  LEU A  65      20.795  21.207  14.530  1.00 29.80           C  
ATOM    526  CG  LEU A  65      19.456  21.030  15.229  1.00 30.34           C  
ATOM    527  CD1 LEU A  65      19.723  20.757  16.696  1.00 30.04           C  
ATOM    528  CD2 LEU A  65      18.523  22.219  15.036  1.00 30.30           C  
ATOM    529  N   TRP A  66      22.816  20.229  12.210  1.00 29.14           N  
ATOM    530  CA  TRP A  66      24.166  20.128  11.644  1.00 29.64           C  
ATOM    531  C   TRP A  66      24.377  21.188  10.561  1.00 29.99           C  
ATOM    532  O   TRP A  66      25.427  21.847  10.519  1.00 29.65           O  
ATOM    533  CB  TRP A  66      24.371  18.729  11.047  1.00 28.59           C  
ATOM    534  CG  TRP A  66      25.736  18.444  10.487  1.00 28.24           C  
ATOM    535  CD1 TRP A  66      26.046  18.200   9.183  1.00 26.72           C  
ATOM    536  CD2 TRP A  66      26.971  18.358  11.210  1.00 27.28           C  
ATOM    537  NE1 TRP A  66      27.387  17.945   9.050  1.00 26.78           N  
ATOM    538  CE2 TRP A  66      27.990  18.061  10.266  1.00 26.41           C  
ATOM    539  CE3 TRP A  66      27.324  18.526  12.547  1.00 26.23           C  
ATOM    540  CZ2 TRP A  66      29.329  17.897  10.628  1.00 27.45           C  
ATOM    541  CZ3 TRP A  66      28.651  18.348  12.916  1.00 26.17           C  
ATOM    542  CH2 TRP A  66      29.641  18.055  11.963  1.00 28.18           C  
ATOM    543  N   LEU A  67      23.367  21.304   9.696  1.00 30.22           N  
ATOM    544  CA  LEU A  67      23.279  22.300   8.641  1.00 31.32           C  
ATOM    545  C   LEU A  67      22.564  23.588   9.080  1.00 31.58           C  
ATOM    546  O   LEU A  67      23.106  24.682   8.962  1.00 31.68           O  
ATOM    547  CB  LEU A  67      22.529  21.711   7.443  1.00 31.75           C  
ATOM    548  CG  LEU A  67      23.195  20.537   6.721  1.00 33.18           C  
ATOM    549  CD1 LEU A  67      22.312  20.138   5.519  1.00 36.67           C  
ATOM    550  CD2 LEU A  67      24.627  20.868   6.262  1.00 32.52           C  
ATOM    551  N   SER A  68      21.343  23.452   9.580  1.00 31.95           N  
ATOM    552  CA  SER A  68      20.508  24.616   9.894  1.00 32.33           C  
ATOM    553  C   SER A  68      21.088  25.567  10.961  1.00 32.22           C  
ATOM    554  O   SER A  68      20.851  26.764  10.913  1.00 32.24           O  
ATOM    555  CB  SER A  68      19.100  24.173  10.306  1.00 32.86           C  
ATOM    556  OG  SER A  68      19.041  23.854  11.690  1.00 32.55           O  
ATOM    557  N   GLN A  69      21.839  25.036  11.916  1.00 32.03           N  
ATOM    558  CA  GLN A  69      22.550  25.867  12.916  1.00 31.93           C  
ATOM    559  C   GLN A  69      24.053  25.970  12.603  1.00 31.30           C  
ATOM    560  O   GLN A  69      24.817  26.528  13.377  1.00 31.36           O  
ATOM    561  CB  GLN A  69      22.350  25.312  14.320  1.00 31.96           C  
ATOM    562  CG  GLN A  69      20.975  25.557  14.905  1.00 33.10           C  
ATOM    563  CD  GLN A  69      20.785  24.931  16.268  1.00 34.30           C  
ATOM    564  OE1 GLN A  69      21.672  24.287  16.808  1.00 35.93           O  
ATOM    565  NE2 GLN A  69      19.597  25.097  16.822  1.00 39.95           N  
ATOM    566  N   HIS A  70      24.470  25.425  11.466  1.00 30.47           N  
ATOM    567  CA  HIS A  70      25.845  25.551  10.999  1.00 30.67           C  
ATOM    568  C   HIS A  70      26.906  24.894  11.881  1.00 29.87           C  
ATOM    569  O   HIS A  70      28.049  25.307  11.887  1.00 29.14           O  
ATOM    570  CB  HIS A  70      26.143  27.035  10.714  1.00 31.25           C  
ATOM    571  CG  HIS A  70      25.150  27.626   9.775  1.00 32.33           C  
ATOM    572  ND1 HIS A  70      25.070  27.229   8.456  1.00 34.22           N  
ATOM    573  CD2 HIS A  70      24.128  28.490   9.978  1.00 33.16           C  
ATOM    574  CE1 HIS A  70      24.071  27.866   7.875  1.00 33.68           C  
ATOM    575  NE2 HIS A  70      23.482  28.636   8.777  1.00 34.01           N  
ATOM    576  N   TRP A  71      26.542  23.816  12.558  1.00 29.44           N  
ATOM    577  CA  TRP A  71      27.553  23.049  13.291  1.00 30.24           C  
ATOM    578  C   TRP A  71      28.628  22.486  12.369  1.00 30.22           C  
ATOM    579  O   TRP A  71      29.786  22.404  12.747  1.00 30.34           O  
ATOM    580  CB  TRP A  71      26.920  21.935  14.121  1.00 30.05           C  
ATOM    581  CG  TRP A  71      26.001  22.427  15.186  1.00 29.55           C  
ATOM    582  CD1 TRP A  71      24.641  22.425  15.150  1.00 30.09           C  
ATOM    583  CD2 TRP A  71      26.365  23.007  16.435  1.00 29.82           C  
ATOM    584  NE1 TRP A  71      24.134  22.941  16.305  1.00 30.12           N  
ATOM    585  CE2 TRP A  71      25.171  23.315  17.114  1.00 30.52           C  
ATOM    586  CE3 TRP A  71      27.579  23.275  17.061  1.00 29.65           C  
ATOM    587  CZ2 TRP A  71      25.158  23.895  18.378  1.00 30.27           C  
ATOM    588  CZ3 TRP A  71      27.565  23.862  18.310  1.00 30.67           C  
ATOM    589  CH2 TRP A  71      26.365  24.162  18.958  1.00 30.55           C  
ATOM    590  N   THR A  72      28.258  22.120  11.150  1.00 30.75           N  
ATOM    591  CA  THR A  72      29.248  21.619  10.197  1.00 31.06           C  
ATOM    592  C   THR A  72      30.447  22.564  10.000  1.00 30.72           C  
ATOM    593  O   THR A  72      31.561  22.107   9.872  1.00 30.15           O  
ATOM    594  CB  THR A  72      28.627  21.246   8.838  1.00 30.95           C  
ATOM    595  OG1 THR A  72      29.629  20.596   8.047  1.00 32.54           O  
ATOM    596  CG2 THR A  72      28.113  22.472   8.088  1.00 32.73           C  
ATOM    597  N   GLU A  73      30.208  23.871   9.983  1.00 31.84           N  
ATOM    598  CA  GLU A  73      31.295  24.877   9.873  1.00 31.97           C  
ATOM    599  C   GLU A  73      32.153  25.009  11.135  1.00 31.41           C  
ATOM    600  O   GLU A  73      33.330  25.294  11.049  1.00 31.11           O  
ATOM    601  CB  GLU A  73      30.728  26.252   9.529  1.00 32.98           C  
ATOM    602  CG  GLU A  73      30.115  26.344   8.128  1.00 38.08           C  
ATOM    603  CD  GLU A  73      28.618  26.093   8.107  1.00 43.91           C  
ATOM    604  OE1 GLU A  73      28.102  25.411   9.016  1.00 50.69           O  
ATOM    605  OE2 GLU A  73      27.947  26.571   7.171  1.00 50.40           O  
ATOM    606  N   LYS A  74      31.570  24.781  12.306  1.00 31.59           N  
ATOM    607  CA  LYS A  74      32.318  24.819  13.574  1.00 32.00           C  
ATOM    608  C   LYS A  74      33.234  23.629  13.728  1.00 30.87           C  
ATOM    609  O   LYS A  74      34.340  23.750  14.253  1.00 30.60           O  
ATOM    610  CB  LYS A  74      31.363  24.821  14.763  1.00 33.63           C  
ATOM    611  CG  LYS A  74      30.336  25.947  14.776  1.00 36.72           C  
ATOM    612  CD  LYS A  74      30.965  27.283  14.675  1.00 43.08           C  
ATOM    613  CE  LYS A  74      31.823  27.621  15.860  1.00 45.13           C  
ATOM    614  NZ  LYS A  74      32.168  29.077  15.740  1.00 47.84           N  
ATOM    615  N   PHE A  75      32.743  22.466  13.288  1.00 29.57           N  
ATOM    616  CA  PHE A  75      33.484  21.230  13.363  1.00 28.91           C  
ATOM    617  C   PHE A  75      34.578  21.209  12.290  1.00 28.80           C  
ATOM    618  O   PHE A  75      35.682  20.727  12.543  1.00 30.00           O  
ATOM    619  CB  PHE A  75      32.536  20.027  13.232  1.00 27.80           C  
ATOM    620  CG  PHE A  75      31.919  19.600  14.531  1.00 28.12           C  
ATOM    621  CD1 PHE A  75      30.763  20.188  15.001  1.00 26.32           C  
ATOM    622  CD2 PHE A  75      32.499  18.591  15.279  1.00 27.67           C  
ATOM    623  CE1 PHE A  75      30.195  19.764  16.197  1.00 29.54           C  
ATOM    624  CE2 PHE A  75      31.948  18.192  16.472  1.00 28.62           C  
ATOM    625  CZ  PHE A  75      30.795  18.768  16.927  1.00 26.98           C  
ATOM    626  N   ALA A  76      34.253  21.714  11.102  1.00 28.40           N  
ATOM    627  CA  ALA A  76      35.156  21.715   9.928  1.00 29.21           C  
ATOM    628  C   ALA A  76      35.842  20.368   9.690  1.00 29.20           C  
ATOM    629  O   ALA A  76      37.064  20.289   9.510  1.00 28.59           O  
ATOM    630  CB  ALA A  76      36.183  22.864  10.006  1.00 28.07           C  
ATOM    631  N   LEU A  77      35.040  19.314   9.668  1.00 29.60           N  
ATOM    632  CA  LEU A  77      35.553  17.955   9.482  1.00 31.21           C  
ATOM    633  C   LEU A  77      36.114  17.762   8.071  1.00 32.09           C  
ATOM    634  O   LEU A  77      35.573  18.297   7.115  1.00 31.56           O  
ATOM    635  CB  LEU A  77      34.452  16.925   9.757  1.00 30.31           C  
ATOM    636  CG  LEU A  77      33.850  16.830  11.168  1.00 30.78           C  
ATOM    637  CD1 LEU A  77      32.889  15.648  11.244  1.00 31.84           C  
ATOM    638  CD2 LEU A  77      34.941  16.716  12.197  1.00 30.34           C  
ATOM    639  N   ASP A  78      37.203  17.004   7.951  1.00 34.24           N  
ATOM    640  CA  ASP A  78      37.702  16.612   6.624  1.00 35.09           C  
ATOM    641  C   ASP A  78      36.903  15.413   6.100  1.00 35.87           C  
ATOM    642  O   ASP A  78      37.457  14.410   5.678  1.00 36.80           O  
ATOM    643  CB  ASP A  78      39.207  16.324   6.670  1.00 35.70           C  
ATOM    644  CG  ASP A  78      39.878  16.356   5.273  1.00 37.96           C  
ATOM    645  OD1 ASP A  78      39.297  16.870   4.238  1.00 41.25           O  
ATOM    646  OD2 ASP A  78      41.041  15.865   5.239  1.00 44.80           O  
ATOM    647  N   LEU A  79      35.584  15.558   6.109  1.00 36.32           N  
ATOM    648  CA  LEU A  79      34.653  14.570   5.604  1.00 36.55           C  
ATOM    649  C   LEU A  79      33.556  15.315   4.850  1.00 37.09           C  
ATOM    650  O   LEU A  79      33.103  16.385   5.288  1.00 37.00           O  
ATOM    651  CB  LEU A  79      34.008  13.796   6.742  1.00 36.47           C  
ATOM    652  CG  LEU A  79      34.859  12.840   7.570  1.00 37.43           C  
ATOM    653  CD1 LEU A  79      33.961  12.262   8.649  1.00 35.26           C  
ATOM    654  CD2 LEU A  79      35.530  11.728   6.722  1.00 37.88           C  
ATOM    655  N   PRO A  80      33.115  14.766   3.712  1.00 36.79           N  
ATOM    656  CA  PRO A  80      32.102  15.469   2.935  1.00 37.30           C  
ATOM    657  C   PRO A  80      30.719  15.360   3.587  1.00 37.86           C  
ATOM    658  O   PRO A  80      30.426  14.358   4.243  1.00 36.83           O  
ATOM    659  CB  PRO A  80      32.136  14.734   1.583  1.00 37.22           C  
ATOM    660  CG  PRO A  80      32.568  13.339   1.929  1.00 36.40           C  
ATOM    661  CD  PRO A  80      33.508  13.482   3.103  1.00 37.20           C  
ATOM    662  N   ASP A  81      29.896  16.400   3.449  1.00 38.85           N  
ATOM    663  CA  ASP A  81      28.481  16.292   3.799  1.00 40.22           C  
ATOM    664  C   ASP A  81      27.789  15.759   2.552  1.00 40.83           C  
ATOM    665  O   ASP A  81      27.890  16.352   1.488  1.00 41.75           O  
ATOM    666  CB  ASP A  81      27.886  17.650   4.220  1.00 40.63           C  
ATOM    667  CG  ASP A  81      28.364  18.106   5.594  1.00 41.38           C  
ATOM    668  OD1 ASP A  81      28.435  17.265   6.518  1.00 42.22           O  
ATOM    669  OD2 ASP A  81      28.667  19.303   5.763  1.00 42.23           O  
ATOM    670  N   GLU A  82      27.111  14.631   2.690  1.00 41.96           N  
ATOM    671  CA  GLU A  82      26.506  13.934   1.561  1.00 43.03           C  
ATOM    672  C   GLU A  82      25.024  13.708   1.806  1.00 44.62           C  
ATOM    673  O   GLU A  82      24.570  13.751   2.960  1.00 45.74           O  
ATOM    674  CB  GLU A  82      27.234  12.598   1.354  1.00 42.84           C  
ATOM    675  CG  GLU A  82      28.691  12.807   0.965  1.00 41.34           C  
ATOM    676  CD  GLU A  82      29.436  11.548   0.579  1.00 40.58           C  
ATOM    677  OE1 GLU A  82      28.908  10.447   0.740  1.00 37.57           O  
ATOM    678  OE2 GLU A  82      30.582  11.668   0.110  1.00 38.12           O  
ATOM    679  N   THR A  83      24.274  13.447   0.735  1.00 46.54           N  
ATOM    680  CA  THR A  83      22.833  13.189   0.855  1.00 47.27           C  
ATOM    681  C   THR A  83      22.567  12.121   1.894  1.00 48.29           C  
ATOM    682  O   THR A  83      21.815  12.373   2.828  1.00 49.59           O  
ATOM    683  CB  THR A  83      22.164  12.758  -0.476  1.00 47.69           C  
ATOM    684  OG1 THR A  83      22.527  13.656  -1.521  1.00 48.55           O  
ATOM    685  CG2 THR A  83      20.636  12.760  -0.327  1.00 47.85           C  
ATOM    686  N   GLU A  84      23.218  10.960   1.762  1.00 48.68           N  
ATOM    687  CA  GLU A  84      23.006   9.827   2.674  1.00 49.20           C  
ATOM    688  C   GLU A  84      24.158   9.626   3.664  1.00 48.92           C  
ATOM    689  O   GLU A  84      25.320   9.859   3.349  1.00 49.12           O  
ATOM    690  CB  GLU A  84      22.783   8.542   1.870  1.00 49.73           C  
ATOM    691  CG  GLU A  84      21.428   8.516   1.166  1.00 51.44           C  
ATOM    692  CD  GLU A  84      21.339   7.466   0.077  1.00 52.17           C  
ATOM    693  OE1 GLU A  84      21.341   7.854  -1.119  1.00 56.65           O  
ATOM    694  OE2 GLU A  84      21.254   6.251   0.414  1.00 57.14           O  
ATOM    695  N   ASP A  85      23.827   9.205   4.882  1.00 48.85           N  
ATOM    696  CA  ASP A  85      24.850   8.922   5.883  1.00 47.48           C  
ATOM    697  C   ASP A  85      25.435   7.551   5.537  1.00 46.63           C  
ATOM    698  O   ASP A  85      24.783   6.749   4.876  1.00 46.66           O  
ATOM    699  CB  ASP A  85      24.268   8.940   7.298  1.00 48.88           C  
ATOM    700  CG  ASP A  85      25.350   8.866   8.378  1.00 50.46           C  
ATOM    701  OD1 ASP A  85      26.508   9.289   8.105  1.00 54.27           O  
ATOM    702  OD2 ASP A  85      25.044   8.371   9.494  1.00 55.48           O  
ATOM    703  N   TRP A  86      26.675   7.296   5.945  1.00 44.18           N  
ATOM    704  CA  TRP A  86      27.309   6.031   5.618  1.00 41.66           C  
ATOM    705  C   TRP A  86      28.073   5.516   6.844  1.00 40.37           C  
ATOM    706  O   TRP A  86      28.239   6.227   7.815  1.00 38.74           O  
ATOM    707  CB  TRP A  86      28.213   6.215   4.402  1.00 39.53           C  
ATOM    708  CG  TRP A  86      29.495   6.900   4.703  1.00 36.95           C  
ATOM    709  CD1 TRP A  86      30.660   6.301   5.030  1.00 35.36           C  
ATOM    710  CD2 TRP A  86      29.749   8.315   4.724  1.00 36.09           C  
ATOM    711  NE1 TRP A  86      31.639   7.234   5.246  1.00 34.79           N  
ATOM    712  CE2 TRP A  86      31.107   8.485   5.082  1.00 36.16           C  
ATOM    713  CE3 TRP A  86      28.970   9.457   4.467  1.00 37.00           C  
ATOM    714  CZ2 TRP A  86      31.718   9.762   5.176  1.00 37.52           C  
ATOM    715  CZ3 TRP A  86      29.573  10.728   4.582  1.00 36.75           C  
ATOM    716  CH2 TRP A  86      30.938  10.861   4.918  1.00 36.42           C  
ATOM    717  N   HIS A  87      28.521   4.266   6.782  1.00 39.81           N  
ATOM    718  CA  HIS A  87      29.293   3.664   7.848  1.00 39.41           C  
ATOM    719  C   HIS A  87      30.769   4.055   7.670  1.00 38.08           C  
ATOM    720  O   HIS A  87      31.399   3.739   6.657  1.00 34.88           O  
ATOM    721  CB  HIS A  87      29.111   2.139   7.850  1.00 41.34           C  
ATOM    722  CG  HIS A  87      29.839   1.455   8.963  1.00 46.09           C  
ATOM    723  ND1 HIS A  87      31.001   0.735   8.758  1.00 49.66           N  
ATOM    724  CD2 HIS A  87      29.607   1.429  10.301  1.00 50.49           C  
ATOM    725  CE1 HIS A  87      31.444   0.283   9.921  1.00 50.19           C  
ATOM    726  NE2 HIS A  87      30.623   0.695  10.873  1.00 53.06           N  
ATOM    727  N   HIS A  88      31.312   4.773   8.651  1.00 35.54           N  
ATOM    728  CA  HIS A  88      32.690   5.230   8.557  1.00 35.98           C  
ATOM    729  C   HIS A  88      33.655   4.084   8.531  1.00 35.63           C  
ATOM    730  O   HIS A  88      33.550   3.174   9.320  1.00 35.33           O  
ATOM    731  CB  HIS A  88      33.066   6.124   9.745  1.00 35.64           C  
ATOM    732  CG  HIS A  88      32.503   7.499   9.656  1.00 36.34           C  
ATOM    733  ND1 HIS A  88      32.846   8.505  10.536  1.00 34.57           N  
ATOM    734  CD2 HIS A  88      31.619   8.039   8.782  1.00 34.95           C  
ATOM    735  CE1 HIS A  88      32.185   9.599  10.209  1.00 34.66           C  
ATOM    736  NE2 HIS A  88      31.441   9.345   9.145  1.00 34.50           N  
ATOM    737  N   THR A  89      34.614   4.158   7.622  1.00 36.12           N  
ATOM    738  CA  THR A  89      35.835   3.371   7.721  1.00 36.30           C  
ATOM    739  C   THR A  89      36.670   3.868   8.922  1.00 36.45           C  
ATOM    740  O   THR A  89      36.457   4.993   9.415  1.00 34.46           O  
ATOM    741  CB  THR A  89      36.631   3.458   6.403  1.00 37.18           C  
ATOM    742  OG1 THR A  89      37.030   4.811   6.168  1.00 37.47           O  
ATOM    743  CG2 THR A  89      35.757   2.986   5.239  1.00 37.75           C  
ATOM    744  N   PRO A  90      37.580   3.015   9.440  1.00 36.54           N  
ATOM    745  CA  PRO A  90      38.451   3.442  10.527  1.00 36.60           C  
ATOM    746  C   PRO A  90      39.218   4.722  10.210  1.00 36.67           C  
ATOM    747  O   PRO A  90      39.411   5.559  11.068  1.00 37.38           O  
ATOM    748  CB  PRO A  90      39.434   2.271  10.682  1.00 36.94           C  
ATOM    749  CG  PRO A  90      38.703   1.101  10.174  1.00 37.58           C  
ATOM    750  CD  PRO A  90      37.821   1.608   9.064  1.00 37.26           C  
ATOM    751  N   GLU A  91      39.655   4.859   8.970  1.00 36.51           N  
ATOM    752  CA  GLU A  91      40.426   6.010   8.562  1.00 35.98           C  
ATOM    753  C   GLU A  91      39.568   7.266   8.467  1.00 34.45           C  
ATOM    754  O   GLU A  91      40.036   8.350   8.798  1.00 34.46           O  
ATOM    755  CB  GLU A  91      41.140   5.686   7.249  1.00 36.79           C  
ATOM    756  CG  GLU A  91      42.173   4.522   7.408  1.00 40.66           C  
ATOM    757  CD  GLU A  91      41.644   3.083   7.107  1.00 44.96           C  
ATOM    758  OE1 GLU A  91      40.404   2.819   7.129  1.00 46.29           O  
ATOM    759  OE2 GLU A  91      42.516   2.208   6.832  1.00 48.03           O  
ATOM    760  N   GLU A  92      38.305   7.114   8.073  1.00 33.45           N  
ATOM    761  CA  GLU A  92      37.336   8.217   8.114  1.00 32.95           C  
ATOM    762  C   GLU A  92      36.977   8.618   9.544  1.00 32.38           C  
ATOM    763  O   GLU A  92      36.868   9.819   9.841  1.00 31.58           O  
ATOM    764  CB  GLU A  92      36.067   7.867   7.340  1.00 33.22           C  
ATOM    765  CG  GLU A  92      36.248   7.902   5.819  1.00 34.01           C  
ATOM    766  CD  GLU A  92      35.021   7.421   5.043  1.00 33.48           C  
ATOM    767  OE1 GLU A  92      34.246   6.601   5.566  1.00 34.86           O  
ATOM    768  OE2 GLU A  92      34.865   7.822   3.875  1.00 34.61           O  
ATOM    769  N   ALA A  93      36.808   7.624  10.428  1.00 31.34           N  
ATOM    770  CA  ALA A  93      36.486   7.873  11.839  1.00 31.26           C  
ATOM    771  C   ALA A  93      37.591   8.664  12.554  1.00 30.28           C  
ATOM    772  O   ALA A  93      37.297   9.486  13.396  1.00 30.33           O  
ATOM    773  CB  ALA A  93      36.182   6.534  12.589  1.00 29.94           C  
ATOM    774  N   ALA A  94      38.858   8.399  12.233  1.00 30.76           N  
ATOM    775  CA  ALA A  94      39.983   9.145  12.807  1.00 31.11           C  
ATOM    776  C   ALA A  94      39.973  10.625  12.432  1.00 31.26           C  
ATOM    777  O   ALA A  94      40.668  11.407  13.049  1.00 32.18           O  
ATOM    778  CB  ALA A  94      41.311   8.522  12.368  1.00 30.94           C  
ATOM    779  N   LYS A  95      39.209  10.995  11.408  1.00 30.74           N  
ATOM    780  CA  LYS A  95      39.107  12.372  10.983  1.00 30.94           C  
ATOM    781  C   LYS A  95      38.052  13.144  11.766  1.00 30.37           C  
ATOM    782  O   LYS A  95      37.925  14.360  11.592  1.00 29.76           O  
ATOM    783  CB  LYS A  95      38.786  12.452   9.484  1.00 30.70           C  
ATOM    784  CG  LYS A  95      39.944  11.996   8.610  1.00 31.91           C  
ATOM    785  CD  LYS A  95      39.684  12.345   7.155  1.00 33.25           C  
ATOM    786  CE  LYS A  95      40.248  11.317   6.169  1.00 36.14           C  
ATOM    787  NZ  LYS A  95      41.326  11.868   5.350  1.00 38.44           N  
ATOM    788  N   VAL A  96      37.279  12.456  12.607  1.00 29.39           N  
ATOM    789  CA  VAL A  96      36.336  13.170  13.448  1.00 28.63           C  
ATOM    790  C   VAL A  96      37.102  13.584  14.705  1.00 28.73           C  
ATOM    791  O   VAL A  96      37.261  12.812  15.646  1.00 27.87           O  
ATOM    792  CB  VAL A  96      35.086  12.361  13.763  1.00 28.29           C  
ATOM    793  CG1 VAL A  96      34.162  13.190  14.679  1.00 28.11           C  
ATOM    794  CG2 VAL A  96      34.353  11.940  12.444  1.00 26.42           C  
ATOM    795  N   VAL A  97      37.639  14.803  14.659  1.00 29.43           N  
ATOM    796  CA  VAL A  97      38.414  15.386  15.738  1.00 29.02           C  
ATOM    797  C   VAL A  97      37.965  16.837  15.890  1.00 29.65           C  
ATOM    798  O   VAL A  97      37.471  17.432  14.933  1.00 29.49           O  
ATOM    799  CB  VAL A  97      39.954  15.307  15.473  1.00 29.49           C  
ATOM    800  CG1 VAL A  97      40.402  13.856  15.440  1.00 28.39           C  
ATOM    801  CG2 VAL A  97      40.359  16.044  14.162  1.00 29.57           C  
ATOM    802  N   VAL A  98      38.117  17.388  17.095  1.00 29.37           N  
ATOM    803  CA  VAL A  98      37.719  18.772  17.368  1.00 29.32           C  
ATOM    804  C   VAL A  98      38.879  19.571  17.960  1.00 29.26           C  
ATOM    805  O   VAL A  98      39.798  19.013  18.591  1.00 28.45           O  
ATOM    806  CB  VAL A  98      36.512  18.857  18.344  1.00 29.71           C  
ATOM    807  CG1 VAL A  98      35.222  18.348  17.691  1.00 29.81           C  
ATOM    808  CG2 VAL A  98      36.814  18.100  19.644  1.00 28.82           C  
ATOM    809  N   ALA A  99      38.814  20.891  17.774  1.00 29.30           N  
ATOM    810  CA  ALA A  99      39.816  21.806  18.327  1.00 29.09           C  
ATOM    811  C   ALA A  99      39.626  22.040  19.835  1.00 28.94           C  
ATOM    812  O   ALA A  99      40.604  22.231  20.560  1.00 28.63           O  
ATOM    813  CB  ALA A  99      39.801  23.135  17.553  1.00 28.10           C  
ATOM    814  N   GLU A 100      38.374  22.036  20.297  1.00 28.89           N  
ATOM    815  CA  GLU A 100      38.054  22.226  21.709  1.00 29.08           C  
ATOM    816  C   GLU A 100      36.872  21.360  22.140  1.00 29.23           C  
ATOM    817  O   GLU A 100      35.918  21.171  21.376  1.00 28.75           O  
ATOM    818  CB  GLU A 100      37.723  23.692  22.015  1.00 28.74           C  
ATOM    819  CG  GLU A 100      38.803  24.699  21.678  1.00 31.15           C  
ATOM    820  CD  GLU A 100      39.966  24.735  22.673  1.00 32.70           C  
ATOM    821  OE1 GLU A 100      39.928  24.029  23.712  1.00 34.55           O  
ATOM    822  OE2 GLU A 100      40.913  25.514  22.411  1.00 35.85           O  
ATOM    823  N   LYS A 101      36.923  20.868  23.382  1.00 29.39           N  
ATOM    824  CA  LYS A 101      35.876  19.986  23.932  1.00 29.95           C  
ATOM    825  C   LYS A 101      34.478  20.633  23.965  1.00 29.77           C  
ATOM    826  O   LYS A 101      33.487  19.967  23.717  1.00 29.40           O  
ATOM    827  CB  LYS A 101      36.214  19.568  25.361  1.00 30.95           C  
ATOM    828  CG  LYS A 101      37.350  18.603  25.489  1.00 31.58           C  
ATOM    829  CD  LYS A 101      37.470  18.066  26.901  1.00 30.39           C  
ATOM    830  CE  LYS A 101      37.751  19.117  27.932  1.00 31.92           C  
ATOM    831  NZ  LYS A 101      37.696  18.497  29.270  1.00 30.62           N  
ATOM    832  N   GLN A 102      34.419  21.926  24.255  1.00 29.40           N  
ATOM    833  CA  GLN A 102      33.141  22.649  24.343  1.00 29.71           C  
ATOM    834  C   GLN A 102      32.234  22.424  23.129  1.00 29.21           C  
ATOM    835  O   GLN A 102      31.017  22.337  23.280  1.00 28.28           O  
ATOM    836  CB  GLN A 102      33.365  24.161  24.575  1.00 30.66           C  
ATOM    837  CG  GLN A 102      32.143  24.977  25.066  1.00 31.73           C  
ATOM    838  CD  GLN A 102      31.584  24.420  26.376  1.00 36.80           C  
ATOM    839  OE1 GLN A 102      32.333  24.200  27.323  1.00 41.83           O  
ATOM    840  NE2 GLN A 102      30.285  24.162  26.425  1.00 35.91           N  
ATOM    841  N   LEU A 103      32.809  22.304  21.937  1.00 29.13           N  
ATOM    842  CA  LEU A 103      31.995  22.102  20.738  1.00 29.53           C  
ATOM    843  C   LEU A 103      31.147  20.834  20.807  1.00 29.26           C  
ATOM    844  O   LEU A 103      29.976  20.819  20.404  1.00 29.87           O  
ATOM    845  CB  LEU A 103      32.875  22.068  19.487  1.00 30.04           C  
ATOM    846  CG  LEU A 103      32.129  21.971  18.164  1.00 29.45           C  
ATOM    847  CD1 LEU A 103      31.150  23.102  18.002  1.00 30.08           C  
ATOM    848  CD2 LEU A 103      33.137  21.942  17.011  1.00 30.27           C  
ATOM    849  N   LEU A 104      31.757  19.766  21.318  1.00 28.86           N  
ATOM    850  CA  LEU A 104      31.075  18.488  21.482  1.00 28.26           C  
ATOM    851  C   LEU A 104      29.923  18.632  22.461  1.00 28.30           C  
ATOM    852  O   LEU A 104      28.854  18.143  22.201  1.00 27.44           O  
ATOM    853  CB  LEU A 104      32.042  17.422  22.013  1.00 28.49           C  
ATOM    854  CG  LEU A 104      33.181  16.952  21.087  1.00 26.86           C  
ATOM    855  CD1 LEU A 104      34.242  16.197  21.865  1.00 27.10           C  
ATOM    856  CD2 LEU A 104      32.645  16.138  19.905  1.00 26.38           C  
ATOM    857  N   SER A 105      30.163  19.322  23.581  1.00 27.92           N  
ATOM    858  CA  SER A 105      29.149  19.536  24.586  1.00 28.17           C  
ATOM    859  C   SER A 105      27.981  20.333  24.036  1.00 28.13           C  
ATOM    860  O   SER A 105      26.806  20.044  24.350  1.00 27.50           O  
ATOM    861  CB  SER A 105      29.708  20.305  25.772  1.00 28.64           C  
ATOM    862  OG  SER A 105      30.600  19.512  26.481  1.00 31.71           O  
ATOM    863  N   ASP A 106      28.314  21.381  23.277  1.00 28.22           N  
ATOM    864  CA  ASP A 106      27.297  22.288  22.714  1.00 28.06           C  
ATOM    865  C   ASP A 106      26.421  21.610  21.660  1.00 27.41           C  
ATOM    866  O   ASP A 106      25.168  21.759  21.661  1.00 27.26           O  
ATOM    867  CB  ASP A 106      27.966  23.544  22.139  1.00 28.51           C  
ATOM    868  CG  ASP A 106      28.565  24.442  23.197  1.00 32.02           C  
ATOM    869  OD1 ASP A 106      28.293  24.256  24.410  1.00 33.99           O  
ATOM    870  OD2 ASP A 106      29.324  25.358  22.802  1.00 33.60           O  
ATOM    871  N   TYR A 107      27.034  20.841  20.768  1.00 26.60           N  
ATOM    872  CA  TYR A 107      26.244  20.181  19.736  1.00 26.46           C  
ATOM    873  C   TYR A 107      25.394  19.043  20.346  1.00 26.75           C  
ATOM    874  O   TYR A 107      24.223  18.868  20.002  1.00 25.52           O  
ATOM    875  CB  TYR A 107      27.135  19.680  18.585  1.00 26.71           C  
ATOM    876  CG  TYR A 107      26.387  18.993  17.451  1.00 26.37           C  
ATOM    877  CD1 TYR A 107      25.166  19.485  16.974  1.00 27.48           C  
ATOM    878  CD2 TYR A 107      26.903  17.881  16.844  1.00 25.48           C  
ATOM    879  CE1 TYR A 107      24.478  18.828  15.904  1.00 27.52           C  
ATOM    880  CE2 TYR A 107      26.233  17.243  15.804  1.00 26.36           C  
ATOM    881  CZ  TYR A 107      25.022  17.708  15.341  1.00 26.84           C  
ATOM    882  OH  TYR A 107      24.391  17.036  14.298  1.00 27.45           O  
ATOM    883  N   LEU A 108      25.961  18.292  21.282  1.00 27.13           N  
ATOM    884  CA  LEU A 108      25.165  17.275  21.972  1.00 27.72           C  
ATOM    885  C   LEU A 108      23.984  17.884  22.750  1.00 28.05           C  
ATOM    886  O   LEU A 108      22.870  17.365  22.696  1.00 27.88           O  
ATOM    887  CB  LEU A 108      26.030  16.410  22.910  1.00 27.56           C  
ATOM    888  CG  LEU A 108      25.353  15.199  23.576  1.00 26.84           C  
ATOM    889  CD1 LEU A 108      24.783  14.223  22.515  1.00 27.54           C  
ATOM    890  CD2 LEU A 108      26.396  14.445  24.483  1.00 28.18           C  
ATOM    891  N   ALA A 109      24.225  18.983  23.452  1.00 27.91           N  
ATOM    892  CA  ALA A 109      23.150  19.665  24.195  1.00 27.95           C  
ATOM    893  C   ALA A 109      22.032  20.132  23.262  1.00 28.23           C  
ATOM    894  O   ALA A 109      20.840  20.012  23.598  1.00 27.77           O  
ATOM    895  CB  ALA A 109      23.707  20.875  25.004  1.00 28.35           C  
ATOM    896  N   ALA A 110      22.412  20.673  22.094  1.00 28.42           N  
ATOM    897  CA  ALA A 110      21.440  21.068  21.087  1.00 28.00           C  
ATOM    898  C   ALA A 110      20.664  19.860  20.573  1.00 28.19           C  
ATOM    899  O   ALA A 110      19.452  19.949  20.385  1.00 27.65           O  
ATOM    900  CB  ALA A 110      22.096  21.818  19.929  1.00 27.78           C  
ATOM    901  N   SER A 111      21.347  18.752  20.285  1.00 28.10           N  
ATOM    902  CA  SER A 111      20.632  17.574  19.766  1.00 29.14           C  
ATOM    903  C   SER A 111      19.733  16.896  20.803  1.00 29.15           C  
ATOM    904  O   SER A 111      18.677  16.391  20.463  1.00 29.57           O  
ATOM    905  CB  SER A 111      21.602  16.565  19.165  1.00 28.47           C  
ATOM    906  OG  SER A 111      22.342  17.211  18.153  1.00 32.92           O  
ATOM    907  N   VAL A 112      20.167  16.864  22.060  1.00 30.52           N  
ATOM    908  CA  VAL A 112      19.322  16.361  23.144  1.00 30.22           C  
ATOM    909  C   VAL A 112      18.092  17.237  23.323  1.00 30.43           C  
ATOM    910  O   VAL A 112      16.988  16.708  23.465  1.00 30.78           O  
ATOM    911  CB  VAL A 112      20.131  16.211  24.472  1.00 30.90           C  
ATOM    912  CG1 VAL A 112      19.199  15.917  25.660  1.00 30.69           C  
ATOM    913  CG2 VAL A 112      21.177  15.097  24.301  1.00 29.35           C  
ATOM    914  N   ALA A 113      18.261  18.557  23.285  1.00 30.72           N  
ATOM    915  CA  ALA A 113      17.130  19.486  23.405  1.00 31.15           C  
ATOM    916  C   ALA A 113      16.078  19.250  22.329  1.00 30.77           C  
ATOM    917  O   ALA A 113      14.887  19.211  22.616  1.00 31.29           O  
ATOM    918  CB  ALA A 113      17.592  20.950  23.339  1.00 30.98           C  
ATOM    919  N   LEU A 114      16.534  19.152  21.092  1.00 30.48           N  
ATOM    920  CA  LEU A 114      15.680  18.860  19.950  1.00 30.38           C  
ATOM    921  C   LEU A 114      14.884  17.564  20.172  1.00 29.54           C  
ATOM    922  O   LEU A 114      13.663  17.508  19.936  1.00 28.83           O  
ATOM    923  CB  LEU A 114      16.541  18.721  18.684  1.00 30.16           C  
ATOM    924  CG  LEU A 114      15.794  18.410  17.374  1.00 31.54           C  
ATOM    925  CD1 LEU A 114      15.029  19.655  16.835  1.00 33.25           C  
ATOM    926  CD2 LEU A 114      16.776  17.833  16.312  1.00 31.18           C  
ATOM    927  N   THR A 115      15.591  16.532  20.622  1.00 29.66           N  
ATOM    928  CA  THR A 115      14.997  15.209  20.849  1.00 29.93           C  
ATOM    929  C   THR A 115      13.908  15.339  21.910  1.00 29.86           C  
ATOM    930  O   THR A 115      12.786  14.891  21.716  1.00 27.67           O  
ATOM    931  CB  THR A 115      16.068  14.176  21.237  1.00 29.57           C  
ATOM    932  OG1 THR A 115      17.066  14.128  20.204  1.00 30.84           O  
ATOM    933  CG2 THR A 115      15.459  12.772  21.429  1.00 29.24           C  
ATOM    934  N   LYS A 116      14.231  16.001  23.012  1.00 30.86           N  
ATOM    935  CA  LYS A 116      13.276  16.123  24.120  1.00 32.09           C  
ATOM    936  C   LYS A 116      12.052  16.941  23.741  1.00 32.31           C  
ATOM    937  O   LYS A 116      10.948  16.660  24.215  1.00 33.28           O  
ATOM    938  CB  LYS A 116      13.950  16.736  25.340  1.00 32.95           C  
ATOM    939  CG  LYS A 116      14.977  15.816  25.985  1.00 34.96           C  
ATOM    940  CD  LYS A 116      15.818  16.564  27.049  1.00 35.62           C  
ATOM    941  CE  LYS A 116      15.321  16.324  28.407  1.00 38.42           C  
ATOM    942  NZ  LYS A 116      16.077  17.121  29.446  1.00 40.62           N  
ATOM    943  N   SER A 117      12.255  17.968  22.917  1.00 31.61           N  
ATOM    944  CA  SER A 117      11.177  18.753  22.363  1.00 32.14           C  
ATOM    945  C   SER A 117      10.265  17.892  21.505  1.00 31.04           C  
ATOM    946  O   SER A 117       9.065  17.968  21.644  1.00 30.13           O  
ATOM    947  CB  SER A 117      11.715  19.903  21.514  1.00 32.32           C  
ATOM    948  OG  SER A 117      10.643  20.619  20.911  1.00 36.45           O  
ATOM    949  N   TYR A 118      10.841  17.054  20.656  1.00 30.44           N  
ATOM    950  CA  TYR A 118      10.034  16.186  19.811  1.00 30.25           C  
ATOM    951  C   TYR A 118       9.231  15.221  20.687  1.00 29.95           C  
ATOM    952  O   TYR A 118       8.014  15.063  20.493  1.00 28.59           O  
ATOM    953  CB  TYR A 118      10.892  15.421  18.784  1.00 30.25           C  
ATOM    954  CG  TYR A 118      10.057  14.629  17.791  1.00 30.58           C  
ATOM    955  CD1 TYR A 118       9.534  15.231  16.656  1.00 32.04           C  
ATOM    956  CD2 TYR A 118       9.778  13.294  17.996  1.00 32.43           C  
ATOM    957  CE1 TYR A 118       8.746  14.511  15.755  1.00 31.96           C  
ATOM    958  CE2 TYR A 118       8.987  12.569  17.097  1.00 30.56           C  
ATOM    959  CZ  TYR A 118       8.483  13.187  15.993  1.00 31.53           C  
ATOM    960  OH  TYR A 118       7.695  12.473  15.142  1.00 32.58           O  
ATOM    961  N   LEU A 119       9.903  14.614  21.664  1.00 29.44           N  
ATOM    962  CA  LEU A 119       9.278  13.636  22.545  1.00 30.62           C  
ATOM    963  C   LEU A 119       8.116  14.254  23.318  1.00 31.51           C  
ATOM    964  O   LEU A 119       7.107  13.600  23.575  1.00 30.67           O  
ATOM    965  CB  LEU A 119      10.289  13.029  23.544  1.00 29.72           C  
ATOM    966  CG  LEU A 119      11.221  11.969  22.933  1.00 31.41           C  
ATOM    967  CD1 LEU A 119      12.224  11.480  23.959  1.00 32.28           C  
ATOM    968  CD2 LEU A 119      10.429  10.824  22.405  1.00 31.55           C  
ATOM    969  N   ASP A 120       8.292  15.500  23.719  1.00 33.48           N  
ATOM    970  CA  ASP A 120       7.268  16.205  24.478  1.00 36.25           C  
ATOM    971  C   ASP A 120       6.057  16.595  23.637  1.00 36.33           C  
ATOM    972  O   ASP A 120       4.988  16.876  24.189  1.00 37.15           O  
ATOM    973  CB  ASP A 120       7.876  17.445  25.112  1.00 37.04           C  
ATOM    974  CG  ASP A 120       8.782  17.114  26.281  1.00 43.47           C  
ATOM    975  OD1 ASP A 120       8.551  16.041  26.917  1.00 50.27           O  
ATOM    976  OD2 ASP A 120       9.737  17.913  26.559  1.00 49.42           O  
ATOM    977  N   GLN A 121       6.224  16.645  22.318  1.00 36.76           N  
ATOM    978  CA  GLN A 121       5.151  17.108  21.435  1.00 37.92           C  
ATOM    979  C   GLN A 121       4.515  15.997  20.597  1.00 37.36           C  
ATOM    980  O   GLN A 121       3.411  16.168  20.094  1.00 36.92           O  
ATOM    981  CB  GLN A 121       5.644  18.257  20.550  1.00 38.25           C  
ATOM    982  CG  GLN A 121       6.045  19.490  21.363  1.00 40.33           C  
ATOM    983  CD  GLN A 121       6.625  20.606  20.506  1.00 41.27           C  
ATOM    984  OE1 GLN A 121       7.788  20.991  20.675  1.00 46.78           O  
ATOM    985  NE2 GLN A 121       5.821  21.133  19.589  1.00 44.13           N  
ATOM    986  N   ILE A 122       5.181  14.857  20.466  1.00 37.46           N  
ATOM    987  CA  ILE A 122       4.597  13.749  19.732  1.00 37.67           C  
ATOM    988  C   ILE A 122       3.302  13.307  20.439  1.00 37.77           C  
ATOM    989  O   ILE A 122       3.279  13.191  21.661  1.00 37.28           O  
ATOM    990  CB  ILE A 122       5.601  12.575  19.576  1.00 38.28           C  
ATOM    991  CG1 ILE A 122       5.162  11.619  18.458  1.00 39.92           C  
ATOM    992  CG2 ILE A 122       5.782  11.843  20.866  1.00 35.47           C  
ATOM    993  CD1 ILE A 122       5.020  12.303  17.086  1.00 42.72           C  
ATOM    994  N   LYS A 123       2.227  13.114  19.665  1.00 37.83           N  
ATOM    995  CA  LYS A 123       0.970  12.533  20.158  1.00 38.46           C  
ATOM    996  C   LYS A 123       1.029  11.017  20.101  1.00 38.51           C  
ATOM    997  O   LYS A 123       1.654  10.432  19.212  1.00 37.64           O  
ATOM    998  CB  LYS A 123      -0.246  13.069  19.369  1.00 38.90           C  
ATOM    999  CG  LYS A 123      -0.723  14.427  19.882  1.00 39.59           C  
ATOM   1000  CD  LYS A 123      -1.487  15.244  18.838  1.00 41.48           C  
ATOM   1001  CE  LYS A 123      -0.561  16.139  17.979  1.00 45.15           C  
ATOM   1002  NZ  LYS A 123       0.620  16.736  18.744  1.00 47.07           N  
ATOM   1003  N   GLU A 124       0.395  10.391  21.077  1.00 38.34           N  
ATOM   1004  CA  GLU A 124       0.493   8.962  21.274  1.00 39.59           C  
ATOM   1005  C   GLU A 124      -0.059   8.177  20.070  1.00 39.31           C  
ATOM   1006  O   GLU A 124       0.391   7.079  19.773  1.00 39.33           O  
ATOM   1007  CB  GLU A 124      -0.256   8.621  22.557  1.00 39.54           C  
ATOM   1008  CG  GLU A 124      -0.140   7.191  23.048  1.00 42.19           C  
ATOM   1009  CD  GLU A 124      -1.261   6.845  24.022  1.00 42.69           C  
ATOM   1010  OE1 GLU A 124      -1.953   5.808  23.802  1.00 44.99           O  
ATOM   1011  OE2 GLU A 124      -1.456   7.640  24.985  1.00 46.49           O  
ATOM   1012  N   GLU A 125      -1.044   8.753  19.390  1.00 39.74           N  
ATOM   1013  CA  GLU A 125      -1.632   8.150  18.198  1.00 39.89           C  
ATOM   1014  C   GLU A 125      -0.633   8.093  17.020  1.00 39.39           C  
ATOM   1015  O   GLU A 125      -0.714   7.208  16.166  1.00 39.29           O  
ATOM   1016  CB  GLU A 125      -2.891   8.917  17.794  1.00 40.35           C  
ATOM   1017  CG  GLU A 125      -4.073   8.708  18.753  1.00 44.14           C  
ATOM   1018  CD  GLU A 125      -3.949   9.428  20.131  1.00 48.27           C  
ATOM   1019  OE1 GLU A 125      -2.978  10.210  20.358  1.00 50.48           O  
ATOM   1020  OE2 GLU A 125      -4.838   9.194  20.991  1.00 50.10           O  
ATOM   1021  N   GLN A 126       0.310   9.035  17.000  1.00 38.72           N  
ATOM   1022  CA  GLN A 126       1.329   9.105  15.952  1.00 37.77           C  
ATOM   1023  C   GLN A 126       2.405   8.023  16.077  1.00 36.56           C  
ATOM   1024  O   GLN A 126       3.112   7.760  15.112  1.00 35.08           O  
ATOM   1025  CB  GLN A 126       2.007  10.466  15.955  1.00 37.31           C  
ATOM   1026  CG  GLN A 126       1.118  11.622  15.620  1.00 38.55           C  
ATOM   1027  CD  GLN A 126       1.796  12.953  15.894  1.00 39.62           C  
ATOM   1028  OE1 GLN A 126       2.120  13.282  17.044  1.00 41.65           O  
ATOM   1029  NE2 GLN A 126       2.008  13.735  14.836  1.00 43.17           N  
ATOM   1030  N   LEU A 127       2.543   7.422  17.258  1.00 35.54           N  
ATOM   1031  CA  LEU A 127       3.611   6.446  17.470  1.00 35.58           C  
ATOM   1032  C   LEU A 127       3.475   5.182  16.606  1.00 34.79           C  
ATOM   1033  O   LEU A 127       4.469   4.547  16.287  1.00 33.57           O  
ATOM   1034  CB  LEU A 127       3.729   6.058  18.950  1.00 35.62           C  
ATOM   1035  CG  LEU A 127       4.264   7.129  19.906  1.00 35.48           C  
ATOM   1036  CD1 LEU A 127       4.134   6.599  21.335  1.00 36.16           C  
ATOM   1037  CD2 LEU A 127       5.723   7.527  19.567  1.00 35.72           C  
ATOM   1038  N   SER A 128       2.249   4.838  16.214  1.00 34.63           N  
ATOM   1039  CA  SER A 128       2.027   3.658  15.380  1.00 34.56           C  
ATOM   1040  C   SER A 128       2.226   3.934  13.886  1.00 33.92           C  
ATOM   1041  O   SER A 128       2.122   3.017  13.075  1.00 34.09           O  
ATOM   1042  CB  SER A 128       0.616   3.087  15.611  1.00 34.28           C  
ATOM   1043  OG  SER A 128      -0.367   4.005  15.195  1.00 35.50           O  
ATOM   1044  N   ASP A 129       2.472   5.184  13.510  1.00 33.34           N  
ATOM   1045  CA  ASP A 129       2.635   5.526  12.092  1.00 33.11           C  
ATOM   1046  C   ASP A 129       3.806   4.773  11.449  1.00 32.30           C  
ATOM   1047  O   ASP A 129       4.901   4.816  11.972  1.00 29.61           O  
ATOM   1048  CB  ASP A 129       2.934   7.013  11.954  1.00 33.30           C  
ATOM   1049  CG  ASP A 129       1.719   7.899  12.229  1.00 37.36           C  
ATOM   1050  OD1 ASP A 129       0.575   7.369  12.298  1.00 41.88           O  
ATOM   1051  OD2 ASP A 129       1.916   9.137  12.335  1.00 40.18           O  
ATOM   1052  N   VAL A 130       3.579   4.154  10.292  1.00 31.70           N  
ATOM   1053  CA  VAL A 130       4.663   3.550   9.508  1.00 32.31           C  
ATOM   1054  C   VAL A 130       5.483   4.629   8.775  1.00 32.24           C  
ATOM   1055  O   VAL A 130       4.966   5.381   7.946  1.00 31.62           O  
ATOM   1056  CB  VAL A 130       4.111   2.462   8.525  1.00 32.14           C  
ATOM   1057  CG1 VAL A 130       5.191   1.959   7.553  1.00 29.99           C  
ATOM   1058  CG2 VAL A 130       3.527   1.301   9.312  1.00 30.83           C  
ATOM   1059  N   ILE A 131       6.769   4.695   9.078  1.00 32.72           N  
ATOM   1060  CA  ILE A 131       7.663   5.661   8.445  1.00 34.11           C  
ATOM   1061  C   ILE A 131       8.544   5.034   7.357  1.00 34.75           C  
ATOM   1062  O   ILE A 131       9.030   5.752   6.472  1.00 34.77           O  
ATOM   1063  CB  ILE A 131       8.533   6.469   9.465  1.00 34.74           C  
ATOM   1064  CG1 ILE A 131       9.451   5.582  10.281  1.00 35.04           C  
ATOM   1065  CG2 ILE A 131       7.654   7.314  10.431  1.00 34.11           C  
ATOM   1066  CD1 ILE A 131      10.425   6.360  11.081  1.00 35.77           C  
ATOM   1067  N   ASP A 132       8.733   3.709   7.402  1.00 35.38           N  
ATOM   1068  CA  ASP A 132       9.421   2.995   6.314  1.00 35.57           C  
ATOM   1069  C   ASP A 132       8.818   1.624   6.112  1.00 36.04           C  
ATOM   1070  O   ASP A 132       9.058   0.727   6.898  1.00 35.22           O  
ATOM   1071  CB  ASP A 132      10.933   2.859   6.580  1.00 35.81           C  
ATOM   1072  CG  ASP A 132      11.713   2.392   5.331  1.00 37.00           C  
ATOM   1073  OD1 ASP A 132      11.114   1.819   4.388  1.00 36.29           O  
ATOM   1074  OD2 ASP A 132      12.941   2.598   5.300  1.00 40.33           O  
ATOM   1075  N   LYS A 133       8.076   1.460   5.023  1.00 37.20           N  
ATOM   1076  CA  LYS A 133       7.340   0.229   4.776  1.00 38.72           C  
ATOM   1077  C   LYS A 133       8.242  -0.871   4.229  1.00 40.12           C  
ATOM   1078  O   LYS A 133       7.849  -2.028   4.223  1.00 41.21           O  
ATOM   1079  CB  LYS A 133       6.150   0.459   3.821  1.00 38.42           C  
ATOM   1080  CG  LYS A 133       6.510   0.979   2.396  1.00 37.18           C  
ATOM   1081  CD  LYS A 133       5.278   1.514   1.601  1.00 37.09           C  
ATOM   1082  CE  LYS A 133       4.263   0.425   1.298  1.00 35.29           C  
ATOM   1083  NZ  LYS A 133       2.997   0.920   0.647  1.00 32.87           N  
ATOM   1084  N   ASN A 134       9.455  -0.533   3.795  1.00 41.55           N  
ATOM   1085  CA  ASN A 134      10.288  -1.485   3.034  1.00 42.58           C  
ATOM   1086  C   ASN A 134      11.187  -2.373   3.913  1.00 43.69           C  
ATOM   1087  O   ASN A 134      12.289  -2.761   3.507  1.00 43.77           O  
ATOM   1088  CB  ASN A 134      11.090  -0.719   1.976  1.00 42.82           C  
ATOM   1089  CG  ASN A 134      10.187  -0.061   0.940  1.00 42.15           C  
ATOM   1090  OD1 ASN A 134       9.259  -0.676   0.424  1.00 42.30           O  
ATOM   1091  ND2 ASN A 134      10.452   1.195   0.644  1.00 44.73           N  
ATOM   1092  N   TRP A 135      10.688  -2.676   5.111  1.00 44.68           N  
ATOM   1093  CA  TRP A 135      11.313  -3.581   6.070  1.00 45.48           C  
ATOM   1094  C   TRP A 135      10.240  -4.525   6.546  1.00 45.30           C  
ATOM   1095  O   TRP A 135       9.061  -4.213   6.424  1.00 44.99           O  
ATOM   1096  CB  TRP A 135      11.837  -2.805   7.268  1.00 47.70           C  
ATOM   1097  CG  TRP A 135      12.896  -1.865   6.876  1.00 50.55           C  
ATOM   1098  CD1 TRP A 135      12.723  -0.610   6.372  1.00 52.22           C  
ATOM   1099  CD2 TRP A 135      14.310  -2.102   6.899  1.00 53.20           C  
ATOM   1100  NE1 TRP A 135      13.945  -0.041   6.096  1.00 53.34           N  
ATOM   1101  CE2 TRP A 135      14.934  -0.938   6.399  1.00 53.73           C  
ATOM   1102  CE3 TRP A 135      15.111  -3.186   7.293  1.00 53.97           C  
ATOM   1103  CZ2 TRP A 135      16.328  -0.817   6.288  1.00 52.70           C  
ATOM   1104  CZ3 TRP A 135      16.503  -3.064   7.181  1.00 52.43           C  
ATOM   1105  CH2 TRP A 135      17.088  -1.888   6.680  1.00 51.84           C  
ATOM   1106  N   THR A 136      10.651  -5.673   7.081  1.00 45.03           N  
ATOM   1107  CA  THR A 136       9.741  -6.606   7.747  1.00 44.57           C  
ATOM   1108  C   THR A 136      10.196  -6.730   9.180  1.00 43.80           C  
ATOM   1109  O   THR A 136      11.313  -7.196   9.420  1.00 44.91           O  
ATOM   1110  CB  THR A 136       9.777  -8.020   7.146  1.00 44.59           C  
ATOM   1111  OG1 THR A 136       9.800  -7.937   5.725  1.00 45.35           O  
ATOM   1112  CG2 THR A 136       8.553  -8.841   7.611  1.00 44.95           C  
ATOM   1113  N   PRO A 137       9.367  -6.279  10.139  1.00 42.31           N  
ATOM   1114  CA  PRO A 137       8.089  -5.615   9.913  1.00 40.96           C  
ATOM   1115  C   PRO A 137       8.416  -4.157   9.607  1.00 40.12           C  
ATOM   1116  O   PRO A 137       9.572  -3.742   9.798  1.00 39.52           O  
ATOM   1117  CB  PRO A 137       7.376  -5.761  11.260  1.00 41.30           C  
ATOM   1118  CG  PRO A 137       8.460  -5.722  12.256  1.00 41.80           C  
ATOM   1119  CD  PRO A 137       9.709  -6.317  11.570  1.00 42.57           C  
ATOM   1120  N   PRO A 138       7.421  -3.384   9.142  1.00 39.13           N  
ATOM   1121  CA  PRO A 138       7.662  -1.973   8.854  1.00 38.06           C  
ATOM   1122  C   PRO A 138       8.244  -1.211  10.045  1.00 36.41           C  
ATOM   1123  O   PRO A 138       8.026  -1.573  11.217  1.00 36.06           O  
ATOM   1124  CB  PRO A 138       6.273  -1.441   8.528  1.00 37.86           C  
ATOM   1125  CG  PRO A 138       5.511  -2.617   8.063  1.00 39.16           C  
ATOM   1126  CD  PRO A 138       6.028  -3.784   8.830  1.00 38.87           C  
ATOM   1127  N   VAL A 139       9.008  -0.172   9.739  1.00 33.26           N  
ATOM   1128  CA  VAL A 139       9.504   0.703  10.767  1.00 31.64           C  
ATOM   1129  C   VAL A 139       8.448   1.776  11.048  1.00 30.28           C  
ATOM   1130  O   VAL A 139       8.003   2.476  10.134  1.00 28.41           O  
ATOM   1131  CB  VAL A 139      10.802   1.375  10.320  1.00 31.80           C  
ATOM   1132  CG1 VAL A 139      11.310   2.325  11.405  1.00 30.04           C  
ATOM   1133  CG2 VAL A 139      11.842   0.310   9.937  1.00 32.67           C  
ATOM   1134  N   THR A 140       8.083   1.898  12.315  1.00 28.79           N  
ATOM   1135  CA  THR A 140       7.149   2.894  12.786  1.00 28.62           C  
ATOM   1136  C   THR A 140       7.892   3.999  13.499  1.00 29.02           C  
ATOM   1137  O   THR A 140       9.079   3.872  13.804  1.00 27.44           O  
ATOM   1138  CB  THR A 140       6.215   2.268  13.821  1.00 29.22           C  
ATOM   1139  OG1 THR A 140       7.004   1.757  14.922  1.00 28.48           O  
ATOM   1140  CG2 THR A 140       5.364   1.136  13.199  1.00 28.18           C  
ATOM   1141  N   ARG A 141       7.179   5.077  13.806  1.00 29.42           N  
ATOM   1142  CA  ARG A 141       7.758   6.182  14.546  1.00 30.10           C  
ATOM   1143  C   ARG A 141       8.368   5.665  15.868  1.00 30.25           C  
ATOM   1144  O   ARG A 141       9.461   6.070  16.269  1.00 28.83           O  
ATOM   1145  CB  ARG A 141       6.686   7.222  14.816  1.00 30.20           C  
ATOM   1146  CG  ARG A 141       7.167   8.581  15.218  1.00 30.98           C  
ATOM   1147  CD  ARG A 141       5.998   9.570  15.203  1.00 32.59           C  
ATOM   1148  NE  ARG A 141       5.280   9.554  13.933  1.00 32.19           N  
ATOM   1149  CZ  ARG A 141       5.624  10.247  12.857  1.00 34.05           C  
ATOM   1150  NH1 ARG A 141       6.669  11.056  12.859  1.00 37.83           N  
ATOM   1151  NH2 ARG A 141       4.903  10.145  11.771  1.00 36.07           N  
ATOM   1152  N   GLN A 142       7.630   4.767  16.513  1.00 30.67           N  
ATOM   1153  CA  GLN A 142       7.979   4.245  17.814  1.00 31.89           C  
ATOM   1154  C   GLN A 142       9.301   3.498  17.778  1.00 30.73           C  
ATOM   1155  O   GLN A 142      10.167   3.734  18.625  1.00 31.11           O  
ATOM   1156  CB  GLN A 142       6.872   3.315  18.295  1.00 31.57           C  
ATOM   1157  CG  GLN A 142       7.130   2.748  19.670  1.00 35.57           C  
ATOM   1158  CD  GLN A 142       5.851   2.282  20.326  1.00 36.08           C  
ATOM   1159  OE1 GLN A 142       4.850   3.002  20.303  1.00 42.52           O  
ATOM   1160  NE2 GLN A 142       5.880   1.093  20.937  1.00 40.71           N  
ATOM   1161  N   VAL A 143       9.464   2.642  16.766  1.00 30.69           N  
ATOM   1162  CA  VAL A 143      10.693   1.862  16.576  1.00 30.75           C  
ATOM   1163  C   VAL A 143      11.896   2.802  16.388  1.00 30.99           C  
ATOM   1164  O   VAL A 143      12.967   2.615  16.974  1.00 29.72           O  
ATOM   1165  CB  VAL A 143      10.523   0.868  15.401  1.00 31.28           C  
ATOM   1166  CG1 VAL A 143      11.870   0.314  14.938  1.00 30.48           C  
ATOM   1167  CG2 VAL A 143       9.594  -0.294  15.820  1.00 31.20           C  
ATOM   1168  N   ARG A 144      11.690   3.874  15.628  1.00 30.87           N  
ATOM   1169  CA  ARG A 144      12.770   4.800  15.333  1.00 30.55           C  
ATOM   1170  C   ARG A 144      13.174   5.574  16.593  1.00 29.82           C  
ATOM   1171  O   ARG A 144      14.368   5.761  16.845  1.00 30.09           O  
ATOM   1172  CB  ARG A 144      12.315   5.706  14.211  1.00 31.94           C  
ATOM   1173  CG  ARG A 144      13.176   6.815  13.831  1.00 35.84           C  
ATOM   1174  CD  ARG A 144      14.464   6.373  13.170  1.00 41.32           C  
ATOM   1175  NE  ARG A 144      14.426   5.179  12.322  1.00 43.54           N  
ATOM   1176  CZ  ARG A 144      14.256   5.161  11.001  1.00 43.16           C  
ATOM   1177  NH1 ARG A 144      13.998   6.255  10.314  1.00 46.57           N  
ATOM   1178  NH2 ARG A 144      14.323   4.009  10.361  1.00 44.11           N  
ATOM   1179  N   LEU A 145      12.187   6.002  17.375  1.00 29.97           N  
ATOM   1180  CA  LEU A 145      12.421   6.662  18.652  1.00 29.93           C  
ATOM   1181  C   LEU A 145      13.154   5.778  19.656  1.00 29.36           C  
ATOM   1182  O   LEU A 145      14.045   6.247  20.335  1.00 29.40           O  
ATOM   1183  CB  LEU A 145      11.102   7.147  19.269  1.00 29.92           C  
ATOM   1184  CG  LEU A 145      10.454   8.339  18.524  1.00 31.15           C  
ATOM   1185  CD1 LEU A 145       9.039   8.666  19.040  1.00 31.86           C  
ATOM   1186  CD2 LEU A 145      11.387   9.580  18.595  1.00 29.65           C  
ATOM   1187  N   VAL A 146      12.760   4.522  19.770  1.00 29.60           N  
ATOM   1188  CA  VAL A 146      13.442   3.585  20.661  1.00 29.78           C  
ATOM   1189  C   VAL A 146      14.903   3.347  20.206  1.00 30.05           C  
ATOM   1190  O   VAL A 146      15.836   3.267  21.033  1.00 30.14           O  
ATOM   1191  CB  VAL A 146      12.671   2.259  20.761  1.00 30.23           C  
ATOM   1192  CG1 VAL A 146      13.508   1.195  21.483  1.00 29.31           C  
ATOM   1193  CG2 VAL A 146      11.335   2.435  21.462  1.00 29.88           C  
ATOM   1194  N   SER A 147      15.093   3.227  18.885  1.00 29.64           N  
ATOM   1195  CA  SER A 147      16.407   3.069  18.307  1.00 30.50           C  
ATOM   1196  C   SER A 147      17.288   4.261  18.629  1.00 30.76           C  
ATOM   1197  O   SER A 147      18.477   4.087  18.957  1.00 31.04           O  
ATOM   1198  CB  SER A 147      16.340   2.896  16.774  1.00 31.03           C  
ATOM   1199  OG  SER A 147      15.796   1.635  16.476  1.00 30.55           O  
ATOM   1200  N   ALA A 148      16.718   5.468  18.543  1.00 31.99           N  
ATOM   1201  CA  ALA A 148      17.498   6.687  18.828  1.00 31.79           C  
ATOM   1202  C   ALA A 148      17.927   6.780  20.282  1.00 32.31           C  
ATOM   1203  O   ALA A 148      19.087   7.099  20.562  1.00 32.39           O  
ATOM   1204  CB  ALA A 148      16.783   7.906  18.392  1.00 32.91           C  
ATOM   1205  N   ILE A 149      17.047   6.433  21.213  1.00 32.42           N  
ATOM   1206  CA  ILE A 149      17.397   6.438  22.634  1.00 32.26           C  
ATOM   1207  C   ILE A 149      18.415   5.327  22.929  1.00 32.02           C  
ATOM   1208  O   ILE A 149      19.417   5.570  23.610  1.00 30.55           O  
ATOM   1209  CB  ILE A 149      16.161   6.215  23.553  1.00 32.56           C  
ATOM   1210  CG1 ILE A 149      15.118   7.339  23.406  1.00 34.29           C  
ATOM   1211  CG2 ILE A 149      16.568   6.088  25.016  1.00 32.35           C  
ATOM   1212  CD1 ILE A 149      15.637   8.733  23.677  1.00 34.61           C  
ATOM   1213  N   ASP A 150      18.180   4.123  22.393  1.00 32.29           N  
ATOM   1214  CA  ASP A 150      19.115   2.972  22.553  1.00 31.62           C  
ATOM   1215  C   ASP A 150      20.557   3.303  22.095  1.00 32.00           C  
ATOM   1216  O   ASP A 150      21.537   2.990  22.774  1.00 29.24           O  
ATOM   1217  CB  ASP A 150      18.542   1.744  21.812  1.00 32.31           C  
ATOM   1218  CG  ASP A 150      19.525   0.592  21.676  1.00 33.13           C  
ATOM   1219  OD1 ASP A 150      19.912   0.053  22.728  1.00 32.70           O  
ATOM   1220  OD2 ASP A 150      19.898   0.214  20.512  1.00 33.19           O  
ATOM   1221  N   ASP A 151      20.654   3.920  20.929  1.00 32.34           N  
ATOM   1222  CA  ASP A 151      21.909   4.321  20.327  1.00 32.69           C  
ATOM   1223  C   ASP A 151      22.670   5.279  21.222  1.00 31.76           C  
ATOM   1224  O   ASP A 151      23.859   5.070  21.446  1.00 30.62           O  
ATOM   1225  CB  ASP A 151      21.650   5.013  18.971  1.00 33.66           C  
ATOM   1226  CG  ASP A 151      22.926   5.614  18.352  1.00 38.06           C  
ATOM   1227  OD1 ASP A 151      23.484   4.927  17.481  1.00 46.07           O  
ATOM   1228  OD2 ASP A 151      23.365   6.759  18.739  1.00 48.08           O  
ATOM   1229  N   ALA A 152      21.991   6.328  21.700  1.00 29.78           N  
ATOM   1230  CA  ALA A 152      22.638   7.310  22.555  1.00 29.57           C  
ATOM   1231  C   ALA A 152      23.131   6.655  23.838  1.00 29.48           C  
ATOM   1232  O   ALA A 152      24.306   6.865  24.221  1.00 28.68           O  
ATOM   1233  CB  ALA A 152      21.729   8.519  22.867  1.00 28.72           C  
ATOM   1234  N   VAL A 153      22.273   5.871  24.501  1.00 28.76           N  
ATOM   1235  CA  VAL A 153      22.660   5.300  25.794  1.00 28.87           C  
ATOM   1236  C   VAL A 153      23.805   4.316  25.603  1.00 28.20           C  
ATOM   1237  O   VAL A 153      24.798   4.333  26.328  1.00 28.83           O  
ATOM   1238  CB  VAL A 153      21.473   4.691  26.550  1.00 28.77           C  
ATOM   1239  CG1 VAL A 153      21.903   4.032  27.872  1.00 26.68           C  
ATOM   1240  CG2 VAL A 153      20.415   5.774  26.839  1.00 32.04           C  
HETATM 1241  N   MSE A 154      23.670   3.437  24.624  1.00 27.87           N  
HETATM 1242  CA  MSE A 154      24.694   2.437  24.404  1.00 29.22           C  
HETATM 1243  C   MSE A 154      26.072   3.066  24.041  1.00 27.95           C  
HETATM 1244  O   MSE A 154      27.121   2.601  24.494  1.00 25.76           O  
HETATM 1245  CB  MSE A 154      24.176   1.497  23.309  1.00 30.90           C  
HETATM 1246  CG  MSE A 154      25.164   0.647  22.779  1.00 37.82           C  
HETATM 1247 SE   MSE A 154      26.120   1.305  21.170  0.80 42.77          SE  
HETATM 1248  CE  MSE A 154      26.033  -0.490  20.496  1.00 34.48           C  
ATOM   1249  N   HIS A 155      26.070   4.100  23.209  1.00 27.31           N  
ATOM   1250  CA  HIS A 155      27.312   4.840  22.926  1.00 28.18           C  
ATOM   1251  C   HIS A 155      27.940   5.529  24.127  1.00 26.91           C  
ATOM   1252  O   HIS A 155      29.160   5.617  24.201  1.00 26.30           O  
ATOM   1253  CB  HIS A 155      27.149   5.823  21.732  1.00 27.90           C  
ATOM   1254  CG  HIS A 155      27.118   5.115  20.417  1.00 28.33           C  
ATOM   1255  ND1 HIS A 155      25.982   5.043  19.644  1.00 32.73           N  
ATOM   1256  CD2 HIS A 155      28.036   4.318  19.812  1.00 31.38           C  
ATOM   1257  CE1 HIS A 155      26.231   4.303  18.568  1.00 33.63           C  
ATOM   1258  NE2 HIS A 155      27.466   3.841  18.651  1.00 30.08           N  
ATOM   1259  N   SER A 156      27.119   5.964  25.070  1.00 27.32           N  
ATOM   1260  CA  SER A 156      27.630   6.594  26.310  1.00 26.93           C  
ATOM   1261  C   SER A 156      28.409   5.562  27.144  1.00 27.42           C  
ATOM   1262  O   SER A 156      29.467   5.868  27.693  1.00 27.85           O  
ATOM   1263  CB  SER A 156      26.488   7.289  27.083  1.00 27.22           C  
ATOM   1264  OG  SER A 156      25.638   6.375  27.759  1.00 26.67           O  
ATOM   1265  N   GLY A 157      27.945   4.301  27.150  1.00 27.51           N  
ATOM   1266  CA  GLY A 157      28.680   3.216  27.763  1.00 27.04           C  
ATOM   1267  C   GLY A 157      29.993   2.958  27.079  1.00 27.06           C  
ATOM   1268  O   GLY A 157      31.018   2.761  27.743  1.00 26.34           O  
ATOM   1269  N   GLN A 158      29.978   2.950  25.746  1.00 26.20           N  
ATOM   1270  CA  GLN A 158      31.243   2.745  25.004  1.00 26.35           C  
ATOM   1271  C   GLN A 158      32.240   3.855  25.299  1.00 25.50           C  
ATOM   1272  O   GLN A 158      33.438   3.623  25.377  1.00 25.11           O  
ATOM   1273  CB  GLN A 158      30.947   2.617  23.486  1.00 27.24           C  
ATOM   1274  CG  GLN A 158      30.249   1.321  23.129  1.00 26.06           C  
ATOM   1275  CD  GLN A 158      29.805   1.218  21.667  1.00 26.94           C  
ATOM   1276  OE1 GLN A 158      29.850   2.207  20.933  1.00 28.14           O  
ATOM   1277  NE2 GLN A 158      29.412   0.003  21.239  1.00 22.15           N  
ATOM   1278  N   ALA A 159      31.762   5.081  25.457  1.00 25.77           N  
ATOM   1279  CA  ALA A 159      32.669   6.227  25.760  1.00 25.49           C  
ATOM   1280  C   ALA A 159      33.447   6.040  27.049  1.00 24.56           C  
ATOM   1281  O   ALA A 159      34.609   6.424  27.132  1.00 24.93           O  
ATOM   1282  CB  ALA A 159      31.889   7.541  25.809  1.00 24.87           C  
ATOM   1283  N   VAL A 160      32.812   5.442  28.051  1.00 24.45           N  
ATOM   1284  CA  VAL A 160      33.498   5.100  29.307  1.00 23.46           C  
ATOM   1285  C   VAL A 160      34.674   4.162  29.083  1.00 23.34           C  
ATOM   1286  O   VAL A 160      35.757   4.361  29.636  1.00 22.05           O  
ATOM   1287  CB  VAL A 160      32.525   4.453  30.277  1.00 24.35           C  
ATOM   1288  CG1 VAL A 160      33.260   3.907  31.488  1.00 22.36           C  
ATOM   1289  CG2 VAL A 160      31.427   5.465  30.680  1.00 22.97           C  
ATOM   1290  N   TYR A 161      34.457   3.147  28.248  1.00 23.66           N  
ATOM   1291  CA  TYR A 161      35.499   2.178  27.898  1.00 23.17           C  
ATOM   1292  C   TYR A 161      36.651   2.803  27.113  1.00 23.90           C  
ATOM   1293  O   TYR A 161      37.805   2.552  27.415  1.00 22.86           O  
ATOM   1294  CB  TYR A 161      34.853   0.938  27.213  1.00 23.56           C  
ATOM   1295  CG  TYR A 161      34.465  -0.165  28.194  1.00 23.55           C  
ATOM   1296  CD1 TYR A 161      34.217   0.103  29.531  1.00 26.73           C  
ATOM   1297  CD2 TYR A 161      34.356  -1.479  27.789  1.00 24.21           C  
ATOM   1298  CE1 TYR A 161      33.904  -0.911  30.443  1.00 23.96           C  
ATOM   1299  CE2 TYR A 161      34.057  -2.479  28.689  1.00 21.79           C  
ATOM   1300  CZ  TYR A 161      33.823  -2.180  30.020  1.00 22.35           C  
ATOM   1301  OH  TYR A 161      33.513  -3.177  30.932  1.00 24.49           O  
ATOM   1302  N   THR A 162      36.346   3.591  26.092  1.00 24.32           N  
ATOM   1303  CA  THR A 162      37.398   4.279  25.364  1.00 24.31           C  
ATOM   1304  C   THR A 162      38.223   5.162  26.309  1.00 24.73           C  
ATOM   1305  O   THR A 162      39.446   5.226  26.212  1.00 25.39           O  
ATOM   1306  CB  THR A 162      36.818   5.184  24.291  1.00 23.70           C  
ATOM   1307  OG1 THR A 162      36.216   4.382  23.275  1.00 23.33           O  
ATOM   1308  CG2 THR A 162      37.943   6.051  23.666  1.00 23.57           C  
ATOM   1309  N   ARG A 163      37.550   5.876  27.201  1.00 26.05           N  
ATOM   1310  CA  ARG A 163      38.232   6.709  28.202  1.00 25.73           C  
ATOM   1311  C   ARG A 163      39.202   5.877  29.018  1.00 25.75           C  
ATOM   1312  O   ARG A 163      40.370   6.260  29.188  1.00 24.98           O  
ATOM   1313  CB  ARG A 163      37.219   7.388  29.137  1.00 26.55           C  
ATOM   1314  CG  ARG A 163      37.815   8.389  30.155  1.00 26.72           C  
ATOM   1315  CD  ARG A 163      36.906   8.561  31.374  1.00 29.24           C  
ATOM   1316  NE  ARG A 163      36.900   7.406  32.269  1.00 34.16           N  
ATOM   1317  CZ  ARG A 163      35.823   6.902  32.890  1.00 34.76           C  
ATOM   1318  NH1 ARG A 163      35.966   5.856  33.690  1.00 34.84           N  
ATOM   1319  NH2 ARG A 163      34.610   7.420  32.721  1.00 37.09           N  
ATOM   1320  N   ARG A 164      38.737   4.741  29.522  1.00 25.27           N  
ATOM   1321  CA  ARG A 164      39.584   3.834  30.287  1.00 26.18           C  
ATOM   1322  C   ARG A 164      40.802   3.362  29.510  1.00 27.03           C  
ATOM   1323  O   ARG A 164      41.903   3.319  30.052  1.00 24.71           O  
ATOM   1324  CB  ARG A 164      38.784   2.648  30.851  1.00 26.58           C  
ATOM   1325  CG  ARG A 164      37.759   3.077  31.912  1.00 27.01           C  
ATOM   1326  CD  ARG A 164      36.823   1.961  32.301  1.00 27.60           C  
ATOM   1327  NE  ARG A 164      35.863   2.366  33.329  1.00 29.28           N  
ATOM   1328  CZ  ARG A 164      35.019   1.532  33.949  1.00 30.97           C  
ATOM   1329  NH1 ARG A 164      35.035   0.226  33.695  1.00 31.87           N  
ATOM   1330  NH2 ARG A 164      34.166   1.995  34.854  1.00 31.65           N  
ATOM   1331  N   LEU A 165      40.610   3.050  28.233  1.00 27.39           N  
ATOM   1332  CA  LEU A 165      41.719   2.616  27.386  1.00 27.52           C  
ATOM   1333  C   LEU A 165      42.688   3.737  27.094  1.00 28.80           C  
ATOM   1334  O   LEU A 165      43.892   3.505  26.977  1.00 28.29           O  
ATOM   1335  CB  LEU A 165      41.174   2.067  26.057  1.00 28.12           C  
ATOM   1336  CG  LEU A 165      40.314   0.819  26.150  1.00 28.96           C  
ATOM   1337  CD1 LEU A 165      39.622   0.531  24.848  1.00 27.77           C  
ATOM   1338  CD2 LEU A 165      41.202  -0.353  26.586  1.00 31.72           C  
ATOM   1339  N   VAL A 166      42.186   4.964  27.009  1.00 28.75           N  
ATOM   1340  CA  VAL A 166      43.020   6.081  26.587  1.00 30.22           C  
ATOM   1341  C   VAL A 166      43.778   6.702  27.757  1.00 30.77           C  
ATOM   1342  O   VAL A 166      44.972   7.015  27.637  1.00 30.32           O  
ATOM   1343  CB  VAL A 166      42.189   7.168  25.835  1.00 29.49           C  
ATOM   1344  CG1 VAL A 166      43.043   8.408  25.563  1.00 31.53           C  
ATOM   1345  CG2 VAL A 166      41.609   6.590  24.527  1.00 28.77           C  
ATOM   1346  N   ILE A 167      43.102   6.880  28.881  1.00 31.51           N  
ATOM   1347  CA  ILE A 167      43.726   7.527  30.043  1.00 32.98           C  
ATOM   1348  C   ILE A 167      43.939   6.622  31.259  1.00 33.09           C  
ATOM   1349  O   ILE A 167      44.379   7.099  32.288  1.00 33.57           O  
ATOM   1350  CB  ILE A 167      42.946   8.828  30.461  1.00 33.79           C  
ATOM   1351  CG1 ILE A 167      41.666   8.526  31.231  1.00 33.38           C  
ATOM   1352  CG2 ILE A 167      42.589   9.669  29.235  1.00 34.69           C  
ATOM   1353  CD1 ILE A 167      40.985   9.794  31.789  1.00 33.68           C  
ATOM   1354  N   GLY A 168      43.601   5.340  31.155  1.00 33.74           N  
ATOM   1355  CA  GLY A 168      43.847   4.371  32.226  1.00 34.08           C  
ATOM   1356  C   GLY A 168      42.994   4.519  33.475  1.00 35.11           C  
ATOM   1357  O   GLY A 168      43.319   3.982  34.532  1.00 34.71           O  
ATOM   1358  N   LYS A 169      41.904   5.251  33.382  1.00 36.00           N  
ATOM   1359  CA  LYS A 169      41.038   5.411  34.537  1.00 37.67           C  
ATOM   1360  C   LYS A 169      39.644   5.788  34.096  1.00 37.36           C  
ATOM   1361  O   LYS A 169      39.384   6.195  32.955  1.00 37.07           O  
ATOM   1362  CB  LYS A 169      41.601   6.467  35.521  1.00 38.23           C  
ATOM   1363  CG  LYS A 169      41.636   7.892  34.968  1.00 39.26           C  
ATOM   1364  CD  LYS A 169      42.374   8.867  35.885  1.00 40.06           C  
ATOM   1365  CE  LYS A 169      41.961  10.321  35.589  1.00 42.19           C  
ATOM   1366  NZ  LYS A 169      40.505  10.616  35.886  1.00 42.80           N  
ATOM   1367  OXT LYS A 169      38.746   5.644  34.908  1.00 38.58           O  
TER    1368      LYS A 169                                                      
END
MOLECULE T0406.pdb
ATOM      1  N   MET     1       7.297  -1.140  21.855  1.00 67.48           N  
ATOM      2  CA  MET     1       6.466   0.089  21.680  1.00 67.38           C  
ATOM      3  C   MET     1       6.624   1.036  22.879  1.00 67.17           C  
ATOM      4  O   MET     1       7.261   0.680  23.880  1.00 67.51           O  
ATOM      5  CB  MET     1       4.991  -0.288  21.493  1.00 67.14           C  
ATOM      6  N   TYR     2       6.087   2.252  22.731  1.00 66.54           N  
ATOM      7  CA  TYR     2       5.887   3.206  23.831  1.00 65.82           C  
ATOM      8  C   TYR     2       4.455   3.692  23.727  1.00 64.83           C  
ATOM      9  O   TYR     2       4.090   4.306  22.724  1.00 65.23           O  
ATOM     10  CB  TYR     2       6.815   4.425  23.724  1.00 66.09           C  
ATOM     11  CG  TYR     2       8.272   4.144  23.994  1.00 66.72           C  
ATOM     12  CD1 TYR     2       9.114   3.721  22.966  1.00 67.06           C  
ATOM     13  CD2 TYR     2       8.819   4.310  25.272  1.00 66.81           C  
ATOM     14  CE1 TYR     2      10.460   3.462  23.197  1.00 67.20           C  
ATOM     15  CE2 TYR     2      10.181   4.049  25.515  1.00 66.68           C  
ATOM     16  CZ  TYR     2      10.987   3.627  24.464  1.00 66.65           C  
ATOM     17  OH  TYR     2      12.319   3.352  24.649  1.00 67.31           O  
ATOM     18  N   GLN     3       3.643   3.428  24.747  1.00 63.41           N  
ATOM     19  CA  GLN     3       2.236   3.824  24.719  1.00 62.14           C  
ATOM     20  C   GLN     3       2.079   5.346  24.698  1.00 60.68           C  
ATOM     21  O   GLN     3       1.188   5.860  24.035  1.00 60.60           O  
ATOM     22  CB  GLN     3       1.478   3.230  25.914  1.00 62.10           C  
ATOM     23  N   THR     4       2.957   6.064  25.395  1.00 59.24           N  
ATOM     24  CA  THR     4       2.775   7.504  25.588  1.00 57.91           C  
ATOM     25  C   THR     4       4.038   8.348  25.382  1.00 56.62           C  
ATOM     26  O   THR     4       5.159   7.870  25.551  1.00 56.20           O  
ATOM     27  CB  THR     4       2.215   7.788  27.012  1.00 58.17           C  
ATOM     28  OG1 THR     4       2.177   9.207  27.252  1.00 59.26           O  
ATOM     29  CG2 THR     4       3.069   7.108  28.092  1.00 57.72           C  
ATOM     30  N   ILE     5       3.824   9.617  25.047  1.00 55.05           N  
ATOM     31  CA  ILE     5       4.896  10.604  24.947  1.00 54.14           C  
ATOM     32  C   ILE     5       5.613  10.811  26.281  1.00 53.68           C  
ATOM     33  O   ILE     5       6.835  10.814  26.328  1.00 53.74           O  
ATOM     34  CB  ILE     5       4.373  11.978  24.469  1.00 53.85           C  
ATOM     35  CG1 ILE     5       3.799  11.886  23.058  1.00 53.39           C  
ATOM     36  CG2 ILE     5       5.488  13.034  24.513  1.00 54.49           C  
ATOM     37  CD1 ILE     5       4.763  11.369  22.022  1.00 53.23           C  
ATOM     38  N   GLU     6       4.863  10.994  27.366  1.00 52.98           N  
ATOM     39  CA  GLU     6       5.484  11.191  28.676  1.00 52.29           C  
ATOM     40  C   GLU     6       6.222   9.939  29.121  1.00 50.67           C  
ATOM     41  O   GLU     6       7.255  10.034  29.758  1.00 51.06           O  
ATOM     42  CB  GLU     6       4.453  11.603  29.741  1.00 52.96           C  
ATOM     43  CG  GLU     6       3.816  12.982  29.509  1.00 55.77           C  
ATOM     44  CD  GLU     6       4.832  14.097  29.249  1.00 59.09           C  
ATOM     45  OE1 GLU     6       5.838  14.193  30.007  1.00 61.36           O  
ATOM     46  OE2 GLU     6       4.607  14.883  28.288  1.00 60.81           O  
ATOM     47  N   GLY     7       5.707   8.772  28.767  1.00 48.43           N  
ATOM     48  CA  GLY     7       6.382   7.523  29.073  1.00 47.15           C  
ATOM     49  C   GLY     7       7.752   7.447  28.424  1.00 46.15           C  
ATOM     50  O   GLY     7       8.710   6.970  29.040  1.00 45.59           O  
ATOM     51  N   PHE     8       7.846   7.915  27.178  1.00 44.90           N  
ATOM     52  CA  PHE     8       9.119   7.948  26.461  1.00 43.84           C  
ATOM     53  C   PHE     8      10.069   8.942  27.100  1.00 43.34           C  
ATOM     54  O   PHE     8      11.256   8.666  27.213  1.00 43.35           O  
ATOM     55  CB  PHE     8       8.948   8.285  24.972  1.00 43.21           C  
ATOM     56  CG  PHE     8      10.256   8.601  24.277  1.00 43.07           C  
ATOM     57  CD1 PHE     8      11.165   7.598  23.993  1.00 42.55           C  
ATOM     58  CD2 PHE     8      10.587   9.903  23.942  1.00 41.66           C  
ATOM     59  CE1 PHE     8      12.376   7.888  23.385  1.00 42.21           C  
ATOM     60  CE2 PHE     8      11.798  10.194  23.342  1.00 41.83           C  
ATOM     61  CZ  PHE     8      12.690   9.176  23.063  1.00 41.14           C  
ATOM     62  N   LEU     9       9.551  10.098  27.512  1.00 43.00           N  
ATOM     63  CA  LEU     9      10.393  11.163  28.053  1.00 42.69           C  
ATOM     64  C   LEU     9      10.978  10.813  29.428  1.00 42.59           C  
ATOM     65  O   LEU     9      12.059  11.278  29.773  1.00 42.28           O  
ATOM     66  CB  LEU     9       9.636  12.499  28.078  1.00 42.45           C  
ATOM     67  CG  LEU     9       9.320  13.024  26.671  1.00 41.60           C  
ATOM     68  CD1 LEU     9       8.392  14.227  26.690  1.00 40.52           C  
ATOM     69  CD2 LEU     9      10.596  13.343  25.926  1.00 42.49           C  
ATOM     70  N   GLN    10      10.282   9.969  30.191  1.00 42.38           N  
ATOM     71  CA  GLN    10      10.823   9.446  31.457  1.00 41.96           C  
ATOM     72  C   GLN    10      12.030   8.536  31.190  1.00 41.70           C  
ATOM     73  O   GLN    10      13.037   8.608  31.896  1.00 41.65           O  
ATOM     74  CB  GLN    10       9.747   8.703  32.267  1.00 41.95           C  
ATOM     75  N   SER    11      11.925   7.681  30.174  1.00 41.31           N  
ATOM     76  CA  SER    11      13.063   6.887  29.716  1.00 41.21           C  
ATOM     77  C   SER    11      14.146   7.795  29.103  1.00 40.77           C  
ATOM     78  O   SER    11      15.311   7.716  29.479  1.00 40.67           O  
ATOM     79  CB  SER    11      12.602   5.835  28.696  1.00 41.13           C  
ATOM     80  N   TRP    12      13.750   8.667  28.183  1.00 40.55           N  
ATOM     81  CA  TRP    12      14.686   9.549  27.479  1.00 40.77           C  
ATOM     82  C   TRP    12      15.453  10.500  28.402  1.00 41.18           C  
ATOM     83  O   TRP    12      16.632  10.774  28.176  1.00 41.09           O  
ATOM     84  CB  TRP    12      13.942  10.362  26.406  1.00 40.37           C  
ATOM     85  CG  TRP    12      14.840  11.191  25.536  1.00 39.72           C  
ATOM     86  CD1 TRP    12      14.843  12.546  25.427  1.00 38.90           C  
ATOM     87  CD2 TRP    12      15.869  10.710  24.662  1.00 37.40           C  
ATOM     88  NE1 TRP    12      15.822  12.941  24.537  1.00 39.94           N  
ATOM     89  CE2 TRP    12      16.457  11.832  24.052  1.00 36.37           C  
ATOM     90  CE3 TRP    12      16.354   9.434  24.345  1.00 38.39           C  
ATOM     91  CZ2 TRP    12      17.512  11.727  23.155  1.00 39.00           C  
ATOM     92  CZ3 TRP    12      17.408   9.325  23.448  1.00 39.08           C  
ATOM     93  CH2 TRP    12      17.968  10.471  22.855  1.00 39.11           C  
ATOM     94  N   THR    13      14.788  11.006  29.437  1.00 41.85           N  
ATOM     95  CA  THR    13      15.415  11.922  30.398  1.00 41.85           C  
ATOM     96  C   THR    13      16.573  11.248  31.140  1.00 42.11           C  
ATOM     97  O   THR    13      17.616  11.854  31.303  1.00 41.71           O  
ATOM     98  CB  THR    13      14.371  12.488  31.404  1.00 42.21           C  
ATOM     99  OG1 THR    13      13.365  13.207  30.682  1.00 42.84           O  
ATOM    100  CG2 THR    13      15.012  13.441  32.434  1.00 41.66           C  
ATOM    101  N   TYR    14      16.398   9.995  31.567  1.00 42.84           N  
ATOM    102  CA  TYR    14      17.488   9.241  32.209  1.00 43.23           C  
ATOM    103  C   TYR    14      18.650   9.016  31.226  1.00 42.43           C  
ATOM    104  O   TYR    14      19.816   9.103  31.603  1.00 42.22           O  
ATOM    105  CB  TYR    14      16.999   7.884  32.757  1.00 44.38           C  
ATOM    106  CG  TYR    14      18.107   7.055  33.401  1.00 45.95           C  
ATOM    107  CD1 TYR    14      18.950   6.246  32.622  1.00 47.52           C  
ATOM    108  CD2 TYR    14      18.330   7.091  34.785  1.00 47.51           C  
ATOM    109  CE1 TYR    14      19.987   5.494  33.202  1.00 47.80           C  
ATOM    110  CE2 TYR    14      19.367   6.339  35.375  1.00 47.55           C  
ATOM    111  CZ  TYR    14      20.189   5.546  34.574  1.00 47.61           C  
ATOM    112  OH  TYR    14      21.210   4.803  35.136  1.00 47.57           O  
ATOM    113  N   GLU    15      18.328   8.702  29.976  1.00 41.66           N  
ATOM    114  CA  GLU    15      19.349   8.445  28.956  1.00 41.25           C  
ATOM    115  C   GLU    15      20.147   9.701  28.626  1.00 40.71           C  
ATOM    116  O   GLU    15      21.375   9.657  28.545  1.00 41.46           O  
ATOM    117  CB  GLU    15      18.713   7.888  27.685  1.00 41.21           C  
ATOM    118  CG  GLU    15      18.068   6.507  27.849  1.00 40.06           C  
ATOM    119  CD  GLU    15      19.015   5.466  28.398  1.00 40.80           C  
ATOM    120  OE1 GLU    15      20.183   5.434  27.981  1.00 43.05           O  
ATOM    121  OE2 GLU    15      18.606   4.655  29.244  1.00 40.70           O  
ATOM    122  N   THR    16      19.460  10.818  28.437  1.00 40.48           N  
ATOM    123  CA  THR    16      20.137  12.067  28.086  1.00 40.67           C  
ATOM    124  C   THR    16      20.956  12.631  29.241  1.00 40.57           C  
ATOM    125  O   THR    16      22.086  13.087  29.021  1.00 40.78           O  
ATOM    126  CB  THR    16      19.166  13.156  27.586  1.00 40.47           C  
ATOM    127  OG1 THR    16      18.230  13.485  28.611  1.00 43.09           O  
ATOM    128  CG2 THR    16      18.414  12.697  26.352  1.00 40.12           C  
ATOM    129  N   GLU    17      20.400  12.609  30.460  1.00 39.86           N  
ATOM    130  CA  GLU    17      21.137  13.073  31.639  1.00 39.51           C  
ATOM    131  C   GLU    17      22.447  12.300  31.772  1.00 39.87           C  
ATOM    132  O   GLU    17      23.517  12.891  31.948  1.00 39.64           O  
ATOM    133  CB  GLU    17      20.291  12.941  32.938  1.00 39.19           C  
ATOM    134  CG  GLU    17      19.182  14.019  33.096  1.00 40.37           C  
ATOM    135  CD  GLU    17      18.399  13.942  34.433  1.00 38.16           C  
ATOM    136  N   SER    18      22.346  10.977  31.677  1.00 40.25           N  
ATOM    137  CA  SER    18      23.503  10.084  31.744  1.00 40.99           C  
ATOM    138  C   SER    18      24.538  10.358  30.638  1.00 40.55           C  
ATOM    139  O   SER    18      25.725  10.377  30.893  1.00 41.38           O  
ATOM    140  CB  SER    18      23.028   8.621  31.691  1.00 41.43           C  
ATOM    141  OG  SER    18      24.085   7.743  31.306  1.00 44.83           O  
ATOM    142  N   THR    19      24.083  10.581  29.413  1.00 40.09           N  
ATOM    143  CA  THR    19      24.981  10.822  28.294  1.00 39.40           C  
ATOM    144  C   THR    19      25.668  12.169  28.440  1.00 40.16           C  
ATOM    145  O   THR    19      26.867  12.277  28.222  1.00 39.94           O  
ATOM    146  CB  THR    19      24.226  10.716  26.941  1.00 39.05           C  
ATOM    147  OG1 THR    19      23.608   9.429  26.875  1.00 38.12           O  
ATOM    148  CG2 THR    19      25.167  10.872  25.755  1.00 38.05           C  
ATOM    149  N   GLN    20      24.900  13.179  28.839  1.00 40.47           N  
ATOM    150  CA  GLN    20      25.405  14.537  28.995  1.00 40.77           C  
ATOM    151  C   GLN    20      26.471  14.626  30.083  1.00 41.36           C  
ATOM    152  O   GLN    20      27.433  15.382  29.931  1.00 41.53           O  
ATOM    153  CB  GLN    20      24.249  15.489  29.312  1.00 40.66           C  
ATOM    154  CG  GLN    20      24.633  16.965  29.386  1.00 40.31           C  
ATOM    155  CD  GLN    20      24.916  17.559  28.025  1.00 40.59           C  
ATOM    156  OE1 GLN    20      24.019  17.678  27.197  1.00 39.78           O  
ATOM    157  NE2 GLN    20      26.159  17.973  27.799  1.00 40.39           N  
ATOM    158  N   LYS    21      26.294  13.871  31.170  1.00 41.97           N  
ATOM    159  CA  LYS    21      27.275  13.825  32.266  1.00 42.84           C  
ATOM    160  C   LYS    21      28.624  13.299  31.779  1.00 42.30           C  
ATOM    161  O   LYS    21      29.674  13.815  32.154  1.00 41.33           O  
ATOM    162  CB  LYS    21      26.799  12.926  33.412  1.00 42.87           C  
ATOM    163  CG  LYS    21      25.691  13.497  34.281  1.00 44.80           C  
ATOM    164  CD  LYS    21      25.392  12.603  35.518  1.00 45.52           C  
ATOM    165  CE  LYS    21      25.198  11.125  35.110  1.00 47.96           C  
ATOM    166  NZ  LYS    21      24.594  10.313  36.197  1.00 50.07           N  
ATOM    167  N   MET    22      28.582  12.250  30.957  1.00 41.83           N  
ATOM    168  CA  MET    22      29.792  11.702  30.386  1.00 42.13           C  
ATOM    169  C   MET    22      30.464  12.678  29.418  1.00 41.34           C  
ATOM    170  O   MET    22      31.661  12.951  29.532  1.00 41.70           O  
ATOM    171  CB  MET    22      29.499  10.357  29.752  1.00 41.41           C  
ATOM    172  CG  MET    22      29.212   9.331  30.816  1.00 41.76           C  
ATOM    173  SD  MET    22      29.053   7.714  29.928  0.75 46.00          SE  
ATOM    174  CE  MET    22      28.062   6.697  31.258  1.00 42.97           C  
ATOM    175  N   LEU    23      29.683  13.257  28.525  1.00 41.06           N  
ATOM    176  CA  LEU    23      30.180  14.268  27.589  1.00 40.50           C  
ATOM    177  C   LEU    23      30.793  15.430  28.306  1.00 40.38           C  
ATOM    178  O   LEU    23      31.763  15.992  27.827  1.00 40.99           O  
ATOM    179  CB  LEU    23      29.057  14.765  26.647  1.00 40.12           C  
ATOM    180  CG  LEU    23      28.669  13.786  25.523  1.00 38.27           C  
ATOM    181  CD1 LEU    23      27.561  14.345  24.656  1.00 35.14           C  
ATOM    182  CD2 LEU    23      29.861  13.455  24.660  1.00 36.73           C  
ATOM    183  N   ASP    24      30.232  15.791  29.461  1.00 40.31           N  
ATOM    184  CA  ASP    24      30.712  16.941  30.237  1.00 40.03           C  
ATOM    185  C   ASP    24      32.090  16.701  30.870  1.00 39.37           C  
ATOM    186  O   ASP    24      32.787  17.655  31.197  1.00 38.85           O  
ATOM    187  CB  ASP    24      29.687  17.346  31.325  1.00 40.24           C  
ATOM    188  CG  ASP    24      28.461  18.090  30.757  1.00 40.77           C  
ATOM    189  OD1 ASP    24      28.486  18.507  29.579  1.00 42.10           O  
ATOM    190  OD2 ASP    24      27.463  18.268  31.498  1.00 43.46           O  
ATOM    191  N   VAL    25      32.480  15.438  31.027  1.00 38.26           N  
ATOM    192  CA  VAL    25      33.777  15.086  31.632  1.00 38.17           C  
ATOM    193  C   VAL    25      34.928  15.046  30.614  1.00 37.59           C  
ATOM    194  O   VAL    25      36.101  15.050  30.988  1.00 36.68           O  
ATOM    195  CB  VAL    25      33.684  13.702  32.309  1.00 38.15           C  
ATOM    196  CG1 VAL    25      35.032  13.258  32.835  1.00 38.34           C  
ATOM    197  CG2 VAL    25      32.656  13.739  33.431  1.00 39.21           C  
ATOM    198  N   LEU    26      34.587  14.997  29.328  1.00 37.24           N  
ATOM    199  CA  LEU    26      35.586  14.778  28.276  1.00 37.75           C  
ATOM    200  C   LEU    26      36.463  16.017  28.180  1.00 37.41           C  
ATOM    201  O   LEU    26      36.004  17.143  28.403  1.00 37.48           O  
ATOM    202  CB  LEU    26      34.914  14.437  26.920  1.00 37.39           C  
ATOM    203  CG  LEU    26      34.684  12.958  26.533  1.00 38.57           C  
ATOM    204  CD1 LEU    26      34.222  12.049  27.652  1.00 41.47           C  
ATOM    205  CD2 LEU    26      33.704  12.858  25.355  1.00 38.55           C  
ATOM    206  N   THR    27      37.741  15.788  27.904  1.00 37.39           N  
ATOM    207  CA  THR    27      38.704  16.852  27.689  1.00 36.78           C  
ATOM    208  C   THR    27      39.095  16.792  26.227  1.00 36.71           C  
ATOM    209  O   THR    27      38.852  15.779  25.560  1.00 36.22           O  
ATOM    210  CB  THR    27      39.959  16.643  28.545  1.00 36.70           C  
ATOM    211  OG1 THR    27      40.584  15.407  28.170  1.00 35.79           O  
ATOM    212  CG2 THR    27      39.596  16.593  30.025  1.00 36.04           C  
ATOM    213  N   ASP    28      39.698  17.876  25.746  1.00 36.48           N  
ATOM    214  CA  ASP    28      40.181  17.965  24.373  1.00 36.48           C  
ATOM    215  C   ASP    28      41.176  16.861  24.059  1.00 36.24           C  
ATOM    216  O   ASP    28      41.126  16.267  22.986  1.00 35.36           O  
ATOM    217  CB  ASP    28      40.835  19.318  24.122  1.00 36.48           C  
ATOM    218  CG  ASP    28      39.838  20.462  24.108  1.00 36.42           C  
ATOM    219  OD1 ASP    28      38.623  20.221  24.269  1.00 37.35           O  
ATOM    220  OD2 ASP    28      40.270  21.616  23.927  1.00 37.41           O  
ATOM    221  N   GLU    29      42.050  16.575  25.013  1.00 36.42           N  
ATOM    222  CA  GLU    29      43.073  15.539  24.856  1.00 36.73           C  
ATOM    223  C   GLU    29      42.464  14.161  24.700  1.00 36.58           C  
ATOM    224  O   GLU    29      42.914  13.376  23.859  1.00 36.92           O  
ATOM    225  CB  GLU    29      44.019  15.533  26.067  1.00 36.94           C  
ATOM    226  CG  GLU    29      45.252  14.631  25.896  1.00 37.22           C  
ATOM    227  N   SER    30      41.444  13.873  25.515  1.00 36.43           N  
ATOM    228  CA  SER    30      40.774  12.551  25.541  1.00 36.31           C  
ATOM    229  C   SER    30      40.136  12.169  24.224  1.00 36.16           C  
ATOM    230  O   SER    30      40.007  10.982  23.911  1.00 37.55           O  
ATOM    231  CB  SER    30      39.707  12.495  26.643  1.00 36.25           C  
ATOM    232  OG  SER    30      38.616  13.360  26.369  1.00 36.58           O  
ATOM    233  N   LEU    31      39.752  13.170  23.451  1.00 35.91           N  
ATOM    234  CA  LEU    31      39.124  12.969  22.157  1.00 35.90           C  
ATOM    235  C   LEU    31      39.992  12.163  21.201  1.00 35.76           C  
ATOM    236  O   LEU    31      39.459  11.472  20.327  1.00 36.37           O  
ATOM    237  CB  LEU    31      38.772  14.326  21.516  1.00 35.53           C  
ATOM    238  CG  LEU    31      37.787  15.200  22.289  1.00 35.42           C  
ATOM    239  CD1 LEU    31      37.398  16.345  21.392  1.00 34.66           C  
ATOM    240  CD2 LEU    31      36.543  14.418  22.807  1.00 36.79           C  
ATOM    241  N   SER    32      41.316  12.224  21.368  1.00 35.50           N  
ATOM    242  CA  SER    32      42.212  11.485  20.484  1.00 35.38           C  
ATOM    243  C   SER    32      42.359  10.021  20.909  1.00 35.55           C  
ATOM    244  O   SER    32      42.958   9.244  20.192  1.00 35.03           O  
ATOM    245  CB  SER    32      43.575  12.170  20.369  1.00 35.21           C  
ATOM    246  OG  SER    32      44.276  12.175  21.595  1.00 36.76           O  
ATOM    247  N   GLN    33      41.741   9.642  22.008  1.00 35.94           N  
ATOM    248  CA  GLN    33      41.856   8.283  22.500  1.00 36.42           C  
ATOM    249  C   GLN    33      41.259   7.240  21.573  1.00 37.94           C  
ATOM    250  O   GLN    33      40.153   7.338  21.218  1.00 37.84           O  
ATOM    251  CB  GLN    33      41.266   8.168  23.896  1.00 36.12           C  
ATOM    252  CG  GLN    33      41.620   6.877  24.606  1.00 34.98           C  
ATOM    253  CD  GLN    33      43.026   6.863  25.196  1.00 34.24           C  
ATOM    254  OE1 GLN    33      43.564   7.870  25.593  1.00 31.29           O  
ATOM    255  NE2 GLN    33      43.602   5.718  25.234  1.00 29.63           N  
ATOM    256  N   GLU    34      41.998   6.210  21.231  1.00 40.01           N  
ATOM    257  CA  GLU    34      41.603   5.337  20.148  1.00 41.29           C  
ATOM    258  C   GLU    34      41.154   3.975  20.575  1.00 41.72           C  
ATOM    259  O   GLU    34      41.708   3.386  21.435  1.00 42.17           O  
ATOM    260  CB  GLU    34      42.736   5.204  19.131  1.00 41.31           C  
ATOM    261  N   ILE    35      40.178   3.436  19.902  1.00 42.30           N  
ATOM    262  CA  ILE    35      39.851   2.039  20.071  1.00 42.71           C  
ATOM    263  C   ILE    35      40.975   1.099  19.779  1.00 43.11           C  
ATOM    264  O   ILE    35      41.143   0.149  20.462  1.00 44.11           O  
ATOM    265  CB  ILE    35      38.723   1.629  19.221  1.00 42.57           C  
ATOM    266  CG1 ILE    35      37.485   2.371  19.608  1.00 43.35           C  
ATOM    267  CG2 ILE    35      38.571   0.141  19.222  1.00 42.92           C  
ATOM    268  CD1 ILE    35      36.345   2.021  18.840  1.00 46.42           C  
ATOM    269  N   ALA    36      41.701   1.355  18.711  1.00 42.78           N  
ATOM    270  CA  ALA    36      42.827   0.550  18.264  1.00 42.55           C  
ATOM    271  C   ALA    36      43.504   1.282  17.104  1.00 42.14           C  
ATOM    272  O   ALA    36      42.954   2.237  16.560  1.00 42.00           O  
ATOM    273  CB  ALA    36      42.359  -0.839  17.829  1.00 42.64           C  
ATOM    274  N   PRO    37      44.724   0.879  16.751  1.00 42.20           N  
ATOM    275  CA  PRO    37      45.335   1.512  15.588  1.00 41.84           C  
ATOM    276  C   PRO    37      44.471   1.331  14.347  1.00 41.06           C  
ATOM    277  O   PRO    37      44.054   0.212  14.037  1.00 41.34           O  
ATOM    278  CB  PRO    37      46.663   0.783  15.470  1.00 42.16           C  
ATOM    279  CG  PRO    37      46.938   0.351  16.879  1.00 42.26           C  
ATOM    280  CD  PRO    37      45.628  -0.105  17.364  1.00 41.99           C  
ATOM    281  N   GLY    38      44.156   2.436  13.681  1.00 40.27           N  
ATOM    282  CA  GLY    38      43.343   2.382  12.469  1.00 39.62           C  
ATOM    283  C   GLY    38      41.853   2.425  12.730  1.00 39.24           C  
ATOM    284  O   GLY    38      41.060   2.278  11.805  1.00 38.25           O  
ATOM    285  N   HIS    39      41.470   2.652  13.987  1.00 38.72           N  
ATOM    286  CA  HIS    39      40.072   2.666  14.380  1.00 38.82           C  
ATOM    287  C   HIS    39      39.623   4.045  14.866  1.00 38.20           C  
ATOM    288  O   HIS    39      40.415   4.973  15.001  1.00 38.13           O  
ATOM    289  CB  HIS    39      39.827   1.611  15.462  1.00 39.68           C  
ATOM    290  CG  HIS    39      39.769   0.215  14.936  1.00 40.52           C  
ATOM    291  ND1 HIS    39      40.868  -0.614  14.897  1.00 43.17           N  
ATOM    292  CD2 HIS    39      38.738  -0.495  14.420  1.00 42.67           C  
ATOM    293  CE1 HIS    39      40.521  -1.776  14.373  1.00 44.25           C  
ATOM    294  NE2 HIS    39      39.233  -1.730  14.074  1.00 44.78           N  
ATOM    295  N   TRP    40      38.334   4.163  15.134  1.00 38.25           N  
ATOM    296  CA  TRP    40      37.750   5.394  15.655  1.00 37.81           C  
ATOM    297  C   TRP    40      38.341   5.859  16.983  1.00 36.50           C  
ATOM    298  O   TRP    40      38.780   5.054  17.798  1.00 35.36           O  
ATOM    299  CB  TRP    40      36.252   5.207  15.873  1.00 39.04           C  
ATOM    300  CG  TRP    40      35.405   5.473  14.689  1.00 39.44           C  
ATOM    301  CD1 TRP    40      35.781   5.484  13.367  1.00 39.64           C  
ATOM    302  CD2 TRP    40      34.006   5.731  14.715  1.00 40.61           C  
ATOM    303  NE1 TRP    40      34.677   5.738  12.573  1.00 40.54           N  
ATOM    304  CE2 TRP    40      33.580   5.900  13.380  1.00 40.48           C  
ATOM    305  CE3 TRP    40      33.064   5.835  15.740  1.00 40.53           C  
ATOM    306  CZ2 TRP    40      32.248   6.176  13.053  1.00 41.21           C  
ATOM    307  CZ3 TRP    40      31.741   6.103  15.413  1.00 40.49           C  
ATOM    308  CH2 TRP    40      31.348   6.276  14.084  1.00 40.47           C  
ATOM    309  N   THR    41      38.336   7.182  17.158  1.00 35.70           N  
ATOM    310  CA  THR    41      38.672   7.816  18.409  1.00 35.60           C  
ATOM    311  C   THR    41      37.418   8.109  19.248  1.00 35.89           C  
ATOM    312  O   THR    41      36.267   8.033  18.774  1.00 35.61           O  
ATOM    313  CB  THR    41      39.425   9.146  18.198  1.00 35.61           C  
ATOM    314  OG1 THR    41      38.543  10.090  17.607  1.00 36.06           O  
ATOM    315  CG2 THR    41      40.640   8.968  17.296  1.00 35.36           C  
ATOM    316  N   LEU    42      37.667   8.442  20.506  1.00 36.16           N  
ATOM    317  CA  LEU    42      36.612   8.834  21.451  1.00 36.54           C  
ATOM    318  C   LEU    42      35.827  10.047  20.984  1.00 37.06           C  
ATOM    319  O   LEU    42      34.606  10.095  21.148  1.00 38.12           O  
ATOM    320  CB  LEU    42      37.238   9.078  22.829  1.00 35.87           C  
ATOM    321  CG  LEU    42      36.388   9.581  24.000  1.00 36.67           C  
ATOM    322  CD1 LEU    42      35.058   8.861  24.109  1.00 34.62           C  
ATOM    323  CD2 LEU    42      37.232   9.459  25.299  1.00 35.25           C  
ATOM    324  N   GLY    43      36.539  11.019  20.418  1.00 37.44           N  
ATOM    325  CA  GLY    43      35.949  12.194  19.804  1.00 37.53           C  
ATOM    326  C   GLY    43      34.952  11.844  18.715  1.00 38.35           C  
ATOM    327  O   GLY    43      33.885  12.465  18.640  1.00 38.03           O  
ATOM    328  N   ARG    44      35.263  10.832  17.897  1.00 38.28           N  
ATOM    329  CA  ARG    44      34.332  10.408  16.841  1.00 37.97           C  
ATOM    330  C   ARG    44      33.141   9.619  17.383  1.00 37.69           C  
ATOM    331  O   ARG    44      32.031   9.812  16.929  1.00 36.92           O  
ATOM    332  CB  ARG    44      35.015   9.586  15.748  1.00 38.16           C  
ATOM    333  CG  ARG    44      34.049   9.332  14.580  1.00 41.71           C  
ATOM    334  CD  ARG    44      34.689   9.418  13.191  1.00 45.92           C  
ATOM    335  NE  ARG    44      33.666   9.473  12.141  1.00 46.95           N  
ATOM    336  CZ  ARG    44      33.845   9.080  10.882  1.00 47.95           C  
ATOM    337  NH1 ARG    44      35.001   8.556  10.479  1.00 49.31           N  
ATOM    338  NH2 ARG    44      32.846   9.191  10.017  1.00 47.85           N  
ATOM    339  N   VAL    45      33.379   8.700  18.320  1.00 38.02           N  
ATOM    340  CA  VAL    45      32.286   8.059  19.038  1.00 38.22           C  
ATOM    341  C   VAL    45      31.309   9.088  19.607  1.00 39.42           C  
ATOM    342  O   VAL    45      30.098   8.946  19.408  1.00 41.06           O  
ATOM    343  CB  VAL    45      32.786   7.065  20.129  1.00 38.71           C  
ATOM    344  CG1 VAL    45      31.578   6.411  20.878  1.00 37.23           C  
ATOM    345  CG2 VAL    45      33.651   6.016  19.498  1.00 35.38           C  
ATOM    346  N   ALA    46      31.824  10.160  20.224  1.00 39.15           N  
ATOM    347  CA  ALA    46      30.990  11.162  20.902  1.00 38.95           C  
ATOM    348  C   ALA    46      30.202  12.044  19.919  1.00 38.71           C  
ATOM    349  O   ALA    46      29.030  12.365  20.134  1.00 37.60           O  
ATOM    350  CB  ALA    46      31.858  12.048  21.800  1.00 38.55           C  
ATOM    351  N   TRP    47      30.862  12.484  18.863  1.00 38.76           N  
ATOM    352  CA  TRP    47      30.171  13.244  17.833  1.00 38.83           C  
ATOM    353  C   TRP    47      29.138  12.385  17.064  1.00 38.47           C  
ATOM    354  O   TRP    47      28.131  12.884  16.634  1.00 38.14           O  
ATOM    355  CB  TRP    47      31.189  13.859  16.887  1.00 38.98           C  
ATOM    356  CG  TRP    47      30.676  14.933  16.005  1.00 38.62           C  
ATOM    357  CD1 TRP    47      30.772  14.970  14.660  1.00 38.41           C  
ATOM    358  CD2 TRP    47      30.038  16.160  16.403  1.00 38.34           C  
ATOM    359  NE1 TRP    47      30.228  16.143  14.177  1.00 39.87           N  
ATOM    360  CE2 TRP    47      29.762  16.883  15.229  1.00 37.93           C  
ATOM    361  CE3 TRP    47      29.671  16.712  17.638  1.00 39.22           C  
ATOM    362  CZ2 TRP    47      29.136  18.125  15.244  1.00 39.28           C  
ATOM    363  CZ3 TRP    47      29.052  17.932  17.659  1.00 38.88           C  
ATOM    364  CH2 TRP    47      28.785  18.638  16.466  1.00 39.61           C  
ATOM    365  N   HIS    48      29.393  11.087  16.917  1.00 37.89           N  
ATOM    366  CA  HIS    48      28.448  10.186  16.269  1.00 37.24           C  
ATOM    367  C   HIS    48      27.122  10.134  17.067  1.00 37.41           C  
ATOM    368  O   HIS    48      26.037  10.100  16.486  1.00 36.57           O  
ATOM    369  CB  HIS    48      29.104   8.795  16.145  1.00 37.50           C  
ATOM    370  CG  HIS    48      28.246   7.750  15.500  1.00 37.08           C  
ATOM    371  ND1 HIS    48      27.851   7.817  14.184  1.00 37.73           N  
ATOM    372  CD2 HIS    48      27.805   6.556  15.962  1.00 38.81           C  
ATOM    373  CE1 HIS    48      27.150   6.737  13.881  1.00 38.77           C  
ATOM    374  NE2 HIS    48      27.102   5.956  14.944  1.00 37.37           N  
ATOM    375  N   ILE    49      27.220  10.172  18.395  1.00 36.74           N  
ATOM    376  CA  ILE    49      26.046  10.202  19.304  1.00 36.60           C  
ATOM    377  C   ILE    49      25.247  11.479  19.139  1.00 36.58           C  
ATOM    378  O   ILE    49      24.000  11.486  19.074  1.00 37.69           O  
ATOM    379  CB  ILE    49      26.522  10.076  20.780  1.00 36.62           C  
ATOM    380  CG1 ILE    49      26.917   8.633  21.055  1.00 35.34           C  
ATOM    381  CG2 ILE    49      25.416  10.507  21.821  1.00 36.42           C  
ATOM    382  CD1 ILE    49      27.867   8.474  22.217  1.00 34.26           C  
ATOM    383  N   VAL    50      25.968  12.571  19.059  1.00 36.48           N  
ATOM    384  CA  VAL    50      25.336  13.842  18.869  1.00 35.50           C  
ATOM    385  C   VAL    50      24.554  13.869  17.553  1.00 35.98           C  
ATOM    386  O   VAL    50      23.355  14.204  17.533  1.00 34.52           O  
ATOM    387  CB  VAL    50      26.370  14.959  18.949  1.00 36.20           C  
ATOM    388  CG1 VAL    50      25.698  16.298  18.728  1.00 33.19           C  
ATOM    389  CG2 VAL    50      27.100  14.929  20.338  1.00 33.82           C  
ATOM    390  N   THR    51      25.223  13.474  16.466  1.00 37.01           N  
ATOM    391  CA  THR    51      24.664  13.566  15.129  1.00 37.55           C  
ATOM    392  C   THR    51      23.593  12.530  14.882  1.00 38.58           C  
ATOM    393  O   THR    51      22.703  12.759  14.043  1.00 38.83           O  
ATOM    394  CB  THR    51      25.741  13.435  14.009  1.00 38.09           C  
ATOM    395  OG1 THR    51      26.371  12.143  14.073  1.00 37.78           O  
ATOM    396  CG2 THR    51      26.774  14.468  14.152  1.00 35.80           C  
ATOM    397  N   ALA    52      23.663  11.406  15.611  1.00 39.48           N  
ATOM    398  CA  ALA    52      22.683  10.339  15.510  1.00 39.44           C  
ATOM    399  C   ALA    52      21.254  10.764  15.832  1.00 40.87           C  
ATOM    400  O   ALA    52      20.318  10.121  15.351  1.00 39.51           O  
ATOM    401  CB  ALA    52      23.100   9.112  16.376  1.00 40.12           C  
ATOM    402  N   ILE    53      21.062  11.888  16.559  1.00 41.91           N  
ATOM    403  CA  ILE    53      19.704  12.284  16.963  1.00 42.87           C  
ATOM    404  C   ILE    53      18.884  12.714  15.724  1.00 43.37           C  
ATOM    405  O   ILE    53      17.848  12.093  15.434  1.00 42.52           O  
ATOM    406  CB  ILE    53      19.686  13.334  18.129  1.00 43.00           C  
ATOM    407  CG1 ILE    53      20.106  12.664  19.441  1.00 44.60           C  
ATOM    408  CG2 ILE    53      18.311  13.920  18.328  1.00 43.32           C  
ATOM    409  CD1 ILE    53      20.584  13.644  20.534  1.00 42.31           C  
ATOM    410  N   PRO    54      19.330  13.763  14.994  1.00 43.64           N  
ATOM    411  CA  PRO    54      18.670  14.065  13.720  1.00 43.62           C  
ATOM    412  C   PRO    54      18.713  12.972  12.637  1.00 44.27           C  
ATOM    413  O   PRO    54      17.808  12.945  11.816  1.00 44.52           O  
ATOM    414  CB  PRO    54      19.353  15.357  13.247  1.00 44.47           C  
ATOM    415  CG  PRO    54      20.619  15.465  14.045  1.00 43.73           C  
ATOM    416  CD  PRO    54      20.382  14.742  15.328  1.00 43.31           C  
ATOM    417  N   VAL    55      19.687  12.054  12.647  1.00 43.45           N  
ATOM    418  CA  VAL    55      19.785  11.057  11.578  1.00 43.07           C  
ATOM    419  C   VAL    55      18.745   9.948  11.775  1.00 42.92           C  
ATOM    420  O   VAL    55      18.032   9.547  10.840  1.00 42.72           O  
ATOM    421  CB  VAL    55      21.217  10.481  11.471  1.00 43.39           C  
ATOM    422  CG1 VAL    55      21.263   9.270  10.506  1.00 43.13           C  
ATOM    423  CG2 VAL    55      22.195  11.597  11.039  1.00 41.78           C  
ATOM    424  N   ILE    56      18.646   9.455  13.000  1.00 42.45           N  
ATOM    425  CA  ILE    56      17.669   8.426  13.298  1.00 42.54           C  
ATOM    426  C   ILE    56      16.236   9.016  13.196  1.00 42.86           C  
ATOM    427  O   ILE    56      15.333   8.365  12.701  1.00 43.17           O  
ATOM    428  CB  ILE    56      17.972   7.749  14.665  1.00 42.17           C  
ATOM    429  CG1 ILE    56      19.186   6.815  14.532  1.00 41.57           C  
ATOM    430  CG2 ILE    56      16.740   7.055  15.210  1.00 40.86           C  
ATOM    431  CD1 ILE    56      19.632   6.168  15.866  1.00 40.57           C  
ATOM    432  N   LEU    57      16.016  10.263  13.599  1.00 42.81           N  
ATOM    433  CA  LEU    57      14.644  10.757  13.596  1.00 42.59           C  
ATOM    434  C   LEU    57      14.171  11.323  12.230  1.00 43.44           C  
ATOM    435  O   LEU    57      12.980  11.681  12.073  1.00 42.65           O  
ATOM    436  CB  LEU    57      14.435  11.746  14.755  1.00 43.42           C  
ATOM    437  CG  LEU    57      14.682  11.079  16.128  1.00 42.68           C  
ATOM    438  CD1 LEU    57      14.283  11.922  17.199  1.00 42.04           C  
ATOM    439  CD2 LEU    57      13.925   9.749  16.268  1.00 45.34           C  
ATOM    440  N   SER    58      15.066  11.369  11.237  1.00 43.29           N  
ATOM    441  CA  SER    58      14.771  12.116  10.003  1.00 43.78           C  
ATOM    442  C   SER    58      13.557  11.583   9.256  1.00 43.27           C  
ATOM    443  O   SER    58      12.747  12.355   8.762  1.00 43.22           O  
ATOM    444  CB  SER    58      15.989  12.175   9.065  1.00 44.30           C  
ATOM    445  OG  SER    58      16.311  10.897   8.546  1.00 44.43           O  
ATOM    446  N   GLY    59      13.431  10.262   9.205  1.00 42.77           N  
ATOM    447  CA  GLY    59      12.336   9.607   8.495  1.00 43.05           C  
ATOM    448  C   GLY    59      10.983   9.740   9.166  1.00 42.87           C  
ATOM    449  O   GLY    59       9.965   9.439   8.558  1.00 42.27           O  
ATOM    450  N   THR    60      10.963  10.171  10.425  1.00 43.30           N  
ATOM    451  CA  THR    60       9.695  10.439  11.129  1.00 43.91           C  
ATOM    452  C   THR    60       9.060  11.764  10.654  1.00 44.53           C  
ATOM    453  O   THR    60       7.873  12.014  10.863  1.00 44.89           O  
ATOM    454  CB  THR    60       9.878  10.557  12.660  1.00 43.17           C  
ATOM    455  OG1 THR    60      10.446  11.834  12.957  1.00 41.99           O  
ATOM    456  CG2 THR    60      10.755   9.449  13.213  1.00 44.70           C  
ATOM    457  N   GLY    61       9.863  12.633  10.064  1.00 45.44           N  
ATOM    458  CA  GLY    61       9.346  13.908   9.591  1.00 45.80           C  
ATOM    459  C   GLY    61       9.321  14.978  10.671  1.00 46.83           C  
ATOM    460  O   GLY    61       9.039  16.143  10.380  1.00 46.08           O  
ATOM    461  N   LEU    62       9.626  14.594  11.912  1.00 47.33           N  
ATOM    462  CA  LEU    62       9.760  15.550  13.015  1.00 48.30           C  
ATOM    463  C   LEU    62      11.003  16.407  12.778  1.00 48.48           C  
ATOM    464  O   LEU    62      12.118  15.913  12.828  1.00 49.91           O  
ATOM    465  CB  LEU    62       9.879  14.777  14.327  1.00 48.16           C  
ATOM    466  CG  LEU    62       9.823  15.488  15.671  1.00 48.99           C  
ATOM    467  CD1 LEU    62       8.480  16.168  15.895  1.00 47.52           C  
ATOM    468  CD2 LEU    62      10.100  14.436  16.754  1.00 48.02           C  
ATOM    469  N   LYS    63      10.818  17.693  12.517  1.00 48.89           N  
ATOM    470  CA  LYS    63      11.905  18.530  12.028  1.00 48.59           C  
ATOM    471  C   LYS    63      12.464  19.441  13.137  1.00 48.24           C  
ATOM    472  O   LYS    63      11.704  20.076  13.879  1.00 48.07           O  
ATOM    473  CB  LYS    63      11.418  19.342  10.814  1.00 49.26           C  
ATOM    474  CG  LYS    63      10.922  18.449   9.641  1.00 48.40           C  
ATOM    475  N   PHE    64      13.792  19.478  13.259  1.00 47.14           N  
ATOM    476  CA  PHE    64      14.447  20.338  14.243  1.00 46.77           C  
ATOM    477  C   PHE    64      15.926  20.524  13.913  1.00 47.14           C  
ATOM    478  O   PHE    64      16.523  19.708  13.222  1.00 46.93           O  
ATOM    479  CB  PHE    64      14.293  19.750  15.646  1.00 45.79           C  
ATOM    480  CG  PHE    64      14.836  18.351  15.780  1.00 43.79           C  
ATOM    481  CD1 PHE    64      16.161  18.132  16.138  1.00 40.87           C  
ATOM    482  CD2 PHE    64      14.030  17.265  15.520  1.00 42.88           C  
ATOM    483  CE1 PHE    64      16.660  16.848  16.251  1.00 42.93           C  
ATOM    484  CE2 PHE    64      14.518  15.994  15.641  1.00 41.21           C  
ATOM    485  CZ  PHE    64      15.847  15.787  16.000  1.00 42.35           C  
ATOM    486  N   GLU    65      16.508  21.596  14.427  1.00 47.28           N  
ATOM    487  CA  GLU    65      17.889  21.962  14.106  1.00 47.91           C  
ATOM    488  C   GLU    65      18.893  20.968  14.727  1.00 47.50           C  
ATOM    489  O   GLU    65      18.722  20.540  15.871  1.00 47.17           O  
ATOM    490  CB  GLU    65      18.162  23.386  14.584  1.00 47.85           C  
ATOM    491  CG  GLU    65      19.431  24.043  14.032  1.00 49.87           C  
ATOM    492  N   GLY    66      19.917  20.599  13.953  1.00 46.99           N  
ATOM    493  CA  GLY    66      20.978  19.708  14.426  1.00 46.66           C  
ATOM    494  C   GLY    66      21.882  19.204  13.317  1.00 46.16           C  
ATOM    495  O   GLY    66      21.399  18.713  12.295  1.00 46.83           O  
ATOM    496  N   GLU    67      23.193  19.306  13.526  1.00 45.14           N  
ATOM    497  CA  GLU    67      24.190  18.735  12.609  1.00 44.58           C  
ATOM    498  C   GLU    67      23.947  17.241  12.433  1.00 43.64           C  
ATOM    499  O   GLU    67      23.686  16.576  13.408  1.00 43.39           O  
ATOM    500  CB  GLU    67      25.602  18.935  13.171  1.00 44.62           C  
ATOM    501  CG  GLU    67      26.722  18.414  12.286  1.00 45.82           C  
ATOM    502  CD  GLU    67      26.649  18.981  10.883  1.00 48.02           C  
ATOM    503  OE1 GLU    67      26.896  20.205  10.749  1.00 49.57           O  
ATOM    504  OE2 GLU    67      26.331  18.211   9.936  1.00 47.88           O  
ATOM    505  N   THR    68      24.057  16.754  11.196  1.00 43.40           N  
ATOM    506  CA  THR    68      23.815  15.353  10.828  1.00 43.81           C  
ATOM    507  C   THR    68      25.062  14.608  10.292  1.00 43.32           C  
ATOM    508  O   THR    68      25.062  13.375  10.193  1.00 43.61           O  
ATOM    509  CB  THR    68      22.682  15.260   9.760  1.00 44.60           C  
ATOM    510  OG1 THR    68      23.040  16.030   8.608  1.00 44.60           O  
ATOM    511  CG2 THR    68      21.339  15.782  10.317  1.00 44.27           C  
ATOM    512  N   LYS    69      26.113  15.346   9.937  1.00 42.95           N  
ATOM    513  CA  LYS    69      27.360  14.748   9.426  1.00 42.71           C  
ATOM    514  C   LYS    69      28.367  14.499  10.552  1.00 42.24           C  
ATOM    515  O   LYS    69      28.805  15.432  11.222  1.00 41.49           O  
ATOM    516  CB  LYS    69      27.982  15.665   8.365  1.00 43.12           C  
ATOM    517  N   ASP    70      28.754  13.242  10.751  1.00 42.33           N  
ATOM    518  CA  ASP    70      29.666  12.900  11.844  1.00 42.59           C  
ATOM    519  C   ASP    70      31.152  13.014  11.461  1.00 42.55           C  
ATOM    520  O   ASP    70      32.018  12.600  12.225  1.00 42.47           O  
ATOM    521  CB  ASP    70      29.300  11.531  12.500  1.00 42.89           C  
ATOM    522  CG  ASP    70      29.642  10.330  11.638  1.00 44.57           C  
ATOM    523  OD1 ASP    70      30.098  10.523  10.493  1.00 47.83           O  
ATOM    524  OD2 ASP    70      29.440   9.183  12.099  1.00 44.97           O  
ATOM    525  N   TYR    71      31.428  13.594  10.290  1.00 42.85           N  
ATOM    526  CA  TYR    71      32.783  13.917   9.856  1.00 42.91           C  
ATOM    527  C   TYR    71      32.710  15.258   9.139  1.00 42.56           C  
ATOM    528  O   TYR    71      31.804  15.477   8.342  1.00 43.39           O  
ATOM    529  CB  TYR    71      33.366  12.843   8.914  1.00 43.24           C  
ATOM    530  CG  TYR    71      34.905  12.846   8.805  1.00 42.94           C  
ATOM    531  CD1 TYR    71      35.697  12.097   9.698  1.00 43.93           C  
ATOM    532  CD2 TYR    71      35.557  13.579   7.817  1.00 42.74           C  
ATOM    533  CE1 TYR    71      37.104  12.091   9.606  1.00 43.63           C  
ATOM    534  CE2 TYR    71      36.954  13.576   7.706  1.00 43.03           C  
ATOM    535  CZ  TYR    71      37.730  12.831   8.600  1.00 44.06           C  
ATOM    536  OH  TYR    71      39.125  12.835   8.488  1.00 43.45           O  
ATOM    537  N   PRO    72      33.625  16.189   9.455  1.00 41.60           N  
ATOM    538  CA  PRO    72      34.725  16.088  10.394  1.00 40.90           C  
ATOM    539  C   PRO    72      34.244  16.180  11.843  1.00 40.00           C  
ATOM    540  O   PRO    72      33.101  16.563  12.113  1.00 39.44           O  
ATOM    541  CB  PRO    72      35.598  17.290  10.021  1.00 40.75           C  
ATOM    542  CG  PRO    72      34.642  18.284   9.584  1.00 41.25           C  
ATOM    543  CD  PRO    72      33.563  17.535   8.860  1.00 41.61           C  
ATOM    544  N   VAL    73      35.116  15.796  12.758  1.00 39.25           N  
ATOM    545  CA  VAL    73      34.790  15.771  14.166  1.00 38.70           C  
ATOM    546  C   VAL    73      35.314  17.074  14.791  1.00 38.13           C  
ATOM    547  O   VAL    73      36.446  17.478  14.519  1.00 38.73           O  
ATOM    548  CB  VAL    73      35.452  14.569  14.854  1.00 38.74           C  
ATOM    549  CG1 VAL    73      35.151  14.567  16.354  1.00 38.20           C  
ATOM    550  CG2 VAL    73      35.013  13.269  14.191  1.00 39.08           C  
ATOM    551  N   PRO    74      34.517  17.727  15.655  1.00 37.44           N  
ATOM    552  CA  PRO    74      35.051  18.883  16.382  1.00 36.76           C  
ATOM    553  C   PRO    74      36.312  18.587  17.184  1.00 36.56           C  
ATOM    554  O   PRO    74      36.464  17.485  17.707  1.00 35.92           O  
ATOM    555  CB  PRO    74      33.907  19.239  17.334  1.00 36.40           C  
ATOM    556  CG  PRO    74      32.712  18.794  16.639  1.00 35.99           C  
ATOM    557  CD  PRO    74      33.106  17.491  16.010  1.00 37.63           C  
ATOM    558  N   THR    75      37.197  19.577  17.308  1.00 37.11           N  
ATOM    559  CA  THR    75      38.420  19.400  18.104  1.00 37.55           C  
ATOM    560  C   THR    75      38.298  19.809  19.582  1.00 38.15           C  
ATOM    561  O   THR    75      39.186  19.506  20.388  1.00 37.83           O  
ATOM    562  CB  THR    75      39.637  20.078  17.456  1.00 37.85           C  
ATOM    563  OG1 THR    75      39.406  21.479  17.284  1.00 36.14           O  
ATOM    564  CG2 THR    75      39.914  19.428  16.094  1.00 38.81           C  
ATOM    565  N   SER    76      37.189  20.449  19.949  1.00 37.93           N  
ATOM    566  CA  SER    76      36.993  20.911  21.313  1.00 37.91           C  
ATOM    567  C   SER    76      35.887  20.136  21.959  1.00 37.58           C  
ATOM    568  O   SER    76      34.809  20.014  21.382  1.00 37.85           O  
ATOM    569  CB  SER    76      36.635  22.399  21.320  1.00 38.14           C  
ATOM    570  OG  SER    76      35.824  22.693  22.444  1.00 39.20           O  
ATOM    571  N   ALA    77      36.133  19.606  23.156  1.00 37.95           N  
ATOM    572  CA  ALA    77      35.137  18.753  23.821  1.00 38.33           C  
ATOM    573  C   ALA    77      33.931  19.597  24.265  1.00 38.87           C  
ATOM    574  O   ALA    77      32.819  19.078  24.436  1.00 38.94           O  
ATOM    575  CB  ALA    77      35.742  17.988  24.990  1.00 38.12           C  
ATOM    576  N   LYS    78      34.130  20.907  24.370  1.00 39.08           N  
ATOM    577  CA  LYS    78      33.032  21.806  24.723  1.00 39.75           C  
ATOM    578  C   LYS    78      32.038  21.915  23.581  1.00 39.51           C  
ATOM    579  O   LYS    78      30.839  21.982  23.819  1.00 40.22           O  
ATOM    580  CB  LYS    78      33.523  23.197  25.118  1.00 39.29           C  
ATOM    581  CG  LYS    78      32.574  23.869  26.098  1.00 40.21           C  
ATOM    582  CD  LYS    78      33.048  25.265  26.529  1.00 40.61           C  
ATOM    583  CE  LYS    78      32.139  26.352  25.985  1.00 42.02           C  
ATOM    584  NZ  LYS    78      30.808  26.307  26.638  1.00 42.42           N  
ATOM    585  N   THR    79      32.529  21.930  22.345  1.00 39.41           N  
ATOM    586  CA  THR    79      31.637  21.886  21.184  1.00 39.10           C  
ATOM    587  C   THR    79      30.776  20.638  21.160  1.00 38.89           C  
ATOM    588  O   THR    79      29.597  20.711  20.832  1.00 40.76           O  
ATOM    589  CB  THR    79      32.399  22.005  19.859  1.00 38.85           C  
ATOM    590  OG1 THR    79      33.154  23.214  19.869  1.00 38.67           O  
ATOM    591  CG2 THR    79      31.429  22.065  18.683  1.00 39.84           C  
ATOM    592  N   ILE    80      31.358  19.496  21.500  1.00 37.87           N  
ATOM    593  CA  ILE    80      30.642  18.224  21.465  1.00 37.23           C  
ATOM    594  C   ILE    80      29.556  18.137  22.544  1.00 36.97           C  
ATOM    595  O   ILE    80      28.392  17.854  22.253  1.00 37.19           O  
ATOM    596  CB  ILE    80      31.627  17.027  21.568  1.00 36.96           C  
ATOM    597  CG1 ILE    80      32.624  17.060  20.379  1.00 36.88           C  
ATOM    598  CG2 ILE    80      30.864  15.675  21.647  1.00 35.26           C  
ATOM    599  CD1 ILE    80      33.641  15.932  20.348  1.00 37.46           C  
ATOM    600  N   ALA    81      29.937  18.377  23.789  1.00 36.74           N  
ATOM    601  CA  ALA    81      29.006  18.343  24.910  1.00 36.66           C  
ATOM    602  C   ALA    81      27.873  19.378  24.744  1.00 37.19           C  
ATOM    603  O   ALA    81      26.700  19.092  25.046  1.00 36.55           O  
ATOM    604  CB  ALA    81      29.777  18.567  26.224  1.00 37.06           C  
ATOM    605  N   ASP    82      28.219  20.572  24.259  1.00 37.79           N  
ATOM    606  CA  ASP    82      27.231  21.625  24.043  1.00 38.43           C  
ATOM    607  C   ASP    82      26.311  21.309  22.875  1.00 38.88           C  
ATOM    608  O   ASP    82      25.102  21.470  22.976  1.00 38.28           O  
ATOM    609  CB  ASP    82      27.900  22.979  23.835  1.00 38.51           C  
ATOM    610  CG  ASP    82      28.488  23.539  25.127  1.00 40.46           C  
ATOM    611  OD1 ASP    82      28.625  22.771  26.119  1.00 42.63           O  
ATOM    612  OD2 ASP    82      28.834  24.734  25.154  1.00 33.97           O  
ATOM    613  N   GLY    83      26.895  20.847  21.772  1.00 40.13           N  
ATOM    614  CA  GLY    83      26.137  20.242  20.672  1.00 40.53           C  
ATOM    615  C   GLY    83      25.089  19.235  21.105  1.00 40.91           C  
ATOM    616  O   GLY    83      23.944  19.333  20.687  1.00 41.21           O  
ATOM    617  N   TYR    84      25.469  18.265  21.928  1.00 41.63           N  
ATOM    618  CA  TYR    84      24.503  17.292  22.452  1.00 41.56           C  
ATOM    619  C   TYR    84      23.374  17.990  23.233  1.00 42.71           C  
ATOM    620  O   TYR    84      22.211  17.671  23.042  1.00 42.92           O  
ATOM    621  CB  TYR    84      25.180  16.286  23.363  1.00 41.30           C  
ATOM    622  CG  TYR    84      24.276  15.137  23.762  1.00 40.64           C  
ATOM    623  CD1 TYR    84      23.985  14.118  22.877  1.00 41.04           C  
ATOM    624  CD2 TYR    84      23.696  15.092  25.018  1.00 40.97           C  
ATOM    625  CE1 TYR    84      23.169  13.065  23.241  1.00 40.97           C  
ATOM    626  CE2 TYR    84      22.863  14.073  25.382  1.00 39.98           C  
ATOM    627  CZ  TYR    84      22.604  13.057  24.499  1.00 40.99           C  
ATOM    628  OH  TYR    84      21.786  12.029  24.880  1.00 40.71           O  
ATOM    629  N   ARG    85      23.725  18.935  24.101  1.00 43.13           N  
ATOM    630  CA  ARG    85      22.735  19.630  24.915  1.00 44.43           C  
ATOM    631  C   ARG    85      21.742  20.346  24.009  1.00 44.49           C  
ATOM    632  O   ARG    85      20.531  20.215  24.184  1.00 45.40           O  
ATOM    633  CB  ARG    85      23.402  20.640  25.857  1.00 44.20           C  
ATOM    634  CG  ARG    85      22.413  21.416  26.727  1.00 45.42           C  
ATOM    635  CD  ARG    85      23.081  22.302  27.766  1.00 46.23           C  
ATOM    636  NE  ARG    85      23.894  21.513  28.691  1.00 47.92           N  
ATOM    637  CZ  ARG    85      25.228  21.473  28.711  1.00 49.12           C  
ATOM    638  NH1 ARG    85      25.963  22.210  27.870  1.00 49.26           N  
ATOM    639  NH2 ARG    85      25.838  20.690  29.603  1.00 49.86           N  
ATOM    640  N   LYS    86      22.285  21.078  23.038  1.00 44.41           N  
ATOM    641  CA  LYS    86      21.524  21.907  22.092  1.00 44.22           C  
ATOM    642  C   LYS    86      20.519  21.090  21.292  1.00 44.21           C  
ATOM    643  O   LYS    86      19.328  21.437  21.238  1.00 44.20           O  
ATOM    644  CB  LYS    86      22.497  22.582  21.113  1.00 44.43           C  
ATOM    645  CG  LYS    86      22.184  24.005  20.742  1.00 44.56           C  
ATOM    646  CD  LYS    86      23.377  24.630  20.012  1.00 44.07           C  
ATOM    647  N   VAL    87      20.999  20.014  20.670  1.00 43.34           N  
ATOM    648  CA  VAL    87      20.168  19.228  19.768  1.00 43.89           C  
ATOM    649  C   VAL    87      19.150  18.360  20.517  1.00 43.64           C  
ATOM    650  O   VAL    87      18.048  18.135  20.023  1.00 43.37           O  
ATOM    651  CB  VAL    87      21.004  18.366  18.782  1.00 43.25           C  
ATOM    652  CG1 VAL    87      21.605  17.148  19.465  1.00 44.08           C  
ATOM    653  CG2 VAL    87      20.137  17.958  17.625  1.00 44.87           C  
ATOM    654  N   ASN    88      19.508  17.892  21.712  1.00 43.54           N  
ATOM    655  CA  ASN    88      18.537  17.209  22.557  1.00 43.84           C  
ATOM    656  C   ASN    88      17.379  18.147  22.921  1.00 42.62           C  
ATOM    657  O   ASN    88      16.228  17.764  22.876  1.00 42.64           O  
ATOM    658  CB  ASN    88      19.175  16.635  23.827  1.00 44.30           C  
ATOM    659  CG  ASN    88      18.201  15.759  24.605  1.00 46.95           C  
ATOM    660  OD1 ASN    88      17.648  14.805  24.059  1.00 53.28           O  
ATOM    661  ND2 ASN    88      17.948  16.106  25.857  1.00 48.55           N  
ATOM    662  N   THR    89      17.692  19.388  23.261  1.00 41.84           N  
ATOM    663  CA  THR    89      16.667  20.354  23.578  1.00 40.67           C  
ATOM    664  C   THR    89      15.751  20.638  22.388  1.00 39.96           C  
ATOM    665  O   THR    89      14.524  20.697  22.544  1.00 39.37           O  
ATOM    666  CB  THR    89      17.290  21.647  24.091  1.00 40.97           C  
ATOM    667  OG1 THR    89      17.883  21.385  25.363  1.00 41.62           O  
ATOM    668  CG2 THR    89      16.244  22.742  24.251  1.00 40.72           C  
ATOM    669  N   ALA    90      16.338  20.816  21.208  1.00 38.61           N  
ATOM    670  CA  ALA    90      15.552  21.081  20.004  1.00 37.69           C  
ATOM    671  C   ALA    90      14.692  19.851  19.685  1.00 36.75           C  
ATOM    672  O   ALA    90      13.558  19.938  19.240  1.00 35.66           O  
ATOM    673  CB  ALA    90      16.476  21.405  18.846  1.00 37.51           C  
ATOM    674  N   PHE    91      15.236  18.688  19.940  1.00 36.98           N  
ATOM    675  CA  PHE    91      14.496  17.474  19.649  1.00 36.00           C  
ATOM    676  C   PHE    91      13.246  17.372  20.529  1.00 36.57           C  
ATOM    677  O   PHE    91      12.120  17.292  20.032  1.00 34.89           O  
ATOM    678  CB  PHE    91      15.387  16.256  19.855  1.00 36.99           C  
ATOM    679  CG  PHE    91      14.620  14.973  19.985  1.00 35.67           C  
ATOM    680  CD1 PHE    91      13.551  14.704  19.143  1.00 38.06           C  
ATOM    681  CD2 PHE    91      14.934  14.059  20.977  1.00 36.48           C  
ATOM    682  CE1 PHE    91      12.827  13.483  19.261  1.00 36.10           C  
ATOM    683  CE2 PHE    91      14.205  12.875  21.113  1.00 37.37           C  
ATOM    684  CZ  PHE    91      13.151  12.607  20.255  1.00 36.55           C  
ATOM    685  N   VAL    92      13.476  17.404  21.841  1.00 37.94           N  
ATOM    686  CA  VAL    92      12.452  17.205  22.863  1.00 38.72           C  
ATOM    687  C   VAL    92      11.400  18.314  22.786  1.00 40.34           C  
ATOM    688  O   VAL    92      10.218  18.099  23.079  1.00 40.64           O  
ATOM    689  CB  VAL    92      13.129  17.126  24.261  1.00 38.71           C  
ATOM    690  CG1 VAL    92      12.144  17.330  25.406  1.00 38.25           C  
ATOM    691  CG2 VAL    92      13.867  15.772  24.400  1.00 38.04           C  
ATOM    692  N   GLU    93      11.837  19.492  22.366  1.00 41.44           N  
ATOM    693  CA  GLU    93      10.924  20.605  22.132  1.00 42.47           C  
ATOM    694  C   GLU    93      10.005  20.329  20.947  1.00 42.47           C  
ATOM    695  O   GLU    93       8.831  20.693  20.976  1.00 42.48           O  
ATOM    696  CB  GLU    93      11.703  21.891  21.919  1.00 42.35           C  
ATOM    697  CG  GLU    93      12.082  22.588  23.222  1.00 43.35           C  
ATOM    698  CD  GLU    93      12.877  23.865  22.983  1.00 44.62           C  
ATOM    699  OE1 GLU    93      13.485  23.974  21.886  1.00 48.71           O  
ATOM    700  OE2 GLU    93      12.904  24.749  23.879  1.00 44.16           O  
ATOM    701  N   ALA    94      10.529  19.659  19.923  1.00 42.55           N  
ATOM    702  CA  ALA    94       9.744  19.392  18.716  1.00 42.83           C  
ATOM    703  C   ALA    94       8.751  18.265  18.979  1.00 42.87           C  
ATOM    704  O   ALA    94       7.604  18.324  18.549  1.00 42.78           O  
ATOM    705  CB  ALA    94      10.647  19.072  17.533  1.00 42.51           C  
ATOM    706  N   LEU    95       9.197  17.259  19.719  1.00 43.07           N  
ATOM    707  CA  LEU    95       8.347  16.140  20.101  1.00 43.63           C  
ATOM    708  C   LEU    95       7.153  16.647  20.912  1.00 44.22           C  
ATOM    709  O   LEU    95       6.023  16.252  20.655  1.00 44.02           O  
ATOM    710  CB  LEU    95       9.150  15.113  20.916  1.00 43.35           C  
ATOM    711  CG  LEU    95       8.613  13.678  20.961  1.00 44.47           C  
ATOM    712  CD1 LEU    95       9.029  12.945  19.715  1.00 44.85           C  
ATOM    713  CD2 LEU    95       9.125  12.934  22.177  1.00 44.58           C  
ATOM    714  N   GLN    96       7.405  17.523  21.884  1.00 44.66           N  
ATOM    715  CA  GLN    96       6.337  18.010  22.767  1.00 45.73           C  
ATOM    716  C   GLN    96       5.367  18.947  22.041  1.00 45.50           C  
ATOM    717  O   GLN    96       4.181  18.988  22.371  1.00 44.91           O  
ATOM    718  CB  GLN    96       6.910  18.696  24.018  1.00 45.79           C  
ATOM    719  CG  GLN    96       7.446  17.716  25.079  1.00 47.48           C  
ATOM    720  CD  GLN    96       8.238  18.399  26.191  1.00 47.89           C  
ATOM    721  OE1 GLN    96       9.012  17.752  26.904  1.00 52.61           O  
ATOM    722  NE2 GLN    96       8.066  19.708  26.330  1.00 50.79           N  
ATOM    723  N   SER    97       5.879  19.689  21.058  1.00 45.59           N  
ATOM    724  CA  SER    97       5.062  20.610  20.267  1.00 45.39           C  
ATOM    725  C   SER    97       4.186  19.882  19.268  1.00 44.94           C  
ATOM    726  O   SER    97       2.999  20.197  19.144  1.00 44.29           O  
ATOM    727  CB  SER    97       5.946  21.573  19.489  1.00 45.21           C  
ATOM    728  OG  SER    97       6.738  22.327  20.376  1.00 47.85           O  
ATOM    729  N   GLU    98       4.770  18.909  18.563  1.00 44.39           N  
ATOM    730  CA  GLU    98       4.132  18.339  17.376  1.00 44.11           C  
ATOM    731  C   GLU    98       3.443  16.988  17.566  1.00 44.04           C  
ATOM    732  O   GLU    98       2.494  16.690  16.845  1.00 44.30           O  
ATOM    733  CB  GLU    98       5.128  18.292  16.212  1.00 43.90           C  
ATOM    734  CG  GLU    98       5.685  19.691  15.814  1.00 44.83           C  
ATOM    735  CD  GLU    98       4.638  20.610  15.166  1.00 43.08           C  
ATOM    736  N   TRP    99       3.888  16.174  18.519  1.00 43.90           N  
ATOM    737  CA  TRP    99       3.322  14.836  18.696  1.00 43.46           C  
ATOM    738  C   TRP    99       2.442  14.735  19.934  1.00 42.97           C  
ATOM    739  O   TRP    99       2.682  15.429  20.933  1.00 42.89           O  
ATOM    740  CB  TRP    99       4.432  13.775  18.781  1.00 44.11           C  
ATOM    741  CG  TRP    99       5.109  13.464  17.469  1.00 44.44           C  
ATOM    742  CD1 TRP    99       4.946  14.119  16.279  1.00 45.11           C  
ATOM    743  CD2 TRP    99       6.097  12.448  17.233  1.00 44.70           C  
ATOM    744  NE1 TRP    99       5.755  13.557  15.316  1.00 45.68           N  
ATOM    745  CE2 TRP    99       6.474  12.536  15.876  1.00 44.29           C  
ATOM    746  CE3 TRP    99       6.698  11.480  18.034  1.00 43.74           C  
ATOM    747  CZ2 TRP    99       7.421  11.695  15.306  1.00 44.86           C  
ATOM    748  CZ3 TRP    99       7.644  10.629  17.460  1.00 45.39           C  
ATOM    749  CH2 TRP    99       7.989  10.741  16.109  1.00 44.90           C  
ATOM    750  N   THR   100       1.425  13.871  19.839  1.00 41.65           N  
ATOM    751  CA  THR   100       0.652  13.383  20.981  1.00 41.00           C  
ATOM    752  C   THR   100       0.813  11.852  20.992  1.00 40.50           C  
ATOM    753  O   THR   100       1.514  11.314  20.141  1.00 40.72           O  
ATOM    754  CB  THR   100      -0.846  13.812  20.897  1.00 40.77           C  
ATOM    755  OG1 THR   100      -1.404  13.441  19.629  1.00 40.49           O  
ATOM    756  CG2 THR   100      -0.992  15.327  21.057  1.00 40.81           C  
ATOM    757  N   ASP   101       0.187  11.146  21.929  1.00 39.96           N  
ATOM    758  CA  ASP   101       0.385   9.675  22.036  1.00 40.12           C  
ATOM    759  C   ASP   101       0.125   8.875  20.757  1.00 39.90           C  
ATOM    760  O   ASP   101       0.769   7.839  20.539  1.00 39.45           O  
ATOM    761  CB  ASP   101      -0.492   9.063  23.133  1.00 40.35           C  
ATOM    762  CG  ASP   101      -0.235   9.655  24.507  1.00 41.58           C  
ATOM    763  OD1 ASP   101       0.874  10.173  24.753  1.00 43.38           O  
ATOM    764  OD2 ASP   101      -1.165   9.602  25.344  1.00 43.32           O  
ATOM    765  N   LYS   102      -0.849   9.317  19.950  1.00 39.81           N  
ATOM    766  CA  LYS   102      -1.244   8.609  18.724  1.00 39.58           C  
ATOM    767  C   LYS   102      -0.172   8.589  17.628  1.00 39.56           C  
ATOM    768  O   LYS   102      -0.036   7.594  16.897  1.00 40.62           O  
ATOM    769  CB  LYS   102      -2.572   9.146  18.167  1.00 39.80           C  
ATOM    770  CG  LYS   102      -2.571  10.528  17.525  1.00 39.75           C  
ATOM    771  CD  LYS   102      -4.014  10.963  17.217  1.00 40.05           C  
ATOM    772  CE  LYS   102      -4.091  12.418  16.750  1.00 41.68           C  
ATOM    773  NZ  LYS   102      -5.506  12.928  16.619  1.00 42.03           N  
ATOM    774  N   ASP   103       0.599   9.667  17.552  1.00 39.64           N  
ATOM    775  CA  ASP   103       1.687   9.806  16.598  1.00 39.19           C  
ATOM    776  C   ASP   103       2.753   8.704  16.736  1.00 38.64           C  
ATOM    777  O   ASP   103       3.510   8.433  15.799  1.00 38.48           O  
ATOM    778  CB  ASP   103       2.345  11.167  16.772  1.00 39.27           C  
ATOM    779  CG  ASP   103       1.439  12.312  16.386  1.00 39.58           C  
ATOM    780  OD1 ASP   103       1.247  12.555  15.174  1.00 40.37           O  
ATOM    781  OD2 ASP   103       0.932  13.000  17.297  1.00 40.06           O  
ATOM    782  N   LEU   104       2.825   8.086  17.909  1.00 37.92           N  
ATOM    783  CA  LEU   104       3.742   6.980  18.125  1.00 37.58           C  
ATOM    784  C   LEU   104       3.402   5.768  17.262  1.00 36.67           C  
ATOM    785  O   LEU   104       4.255   4.897  17.073  1.00 37.21           O  
ATOM    786  CB  LEU   104       3.771   6.579  19.598  1.00 37.60           C  
ATOM    787  CG  LEU   104       4.409   7.599  20.533  1.00 38.72           C  
ATOM    788  CD1 LEU   104       4.135   7.239  21.987  1.00 38.99           C  
ATOM    789  CD2 LEU   104       5.902   7.686  20.264  1.00 38.50           C  
ATOM    790  N   THR   105       2.158   5.698  16.767  1.00 35.51           N  
ATOM    791  CA  THR   105       1.721   4.617  15.876  1.00 34.57           C  
ATOM    792  C   THR   105       1.897   4.923  14.386  1.00 33.86           C  
ATOM    793  O   THR   105       1.828   4.030  13.565  1.00 32.73           O  
ATOM    794  CB  THR   105       0.226   4.240  16.105  1.00 34.44           C  
ATOM    795  OG1 THR   105      -0.630   5.312  15.676  1.00 34.26           O  
ATOM    796  CG2 THR   105      -0.032   3.932  17.572  1.00 35.11           C  
ATOM    797  N   THR   106       2.078   6.184  14.009  1.00 33.40           N  
ATOM    798  CA  THR   106       2.235   6.511  12.594  1.00 33.85           C  
ATOM    799  C   THR   106       3.410   5.787  11.976  1.00 35.81           C  
ATOM    800  O   THR   106       4.544   5.879  12.469  1.00 36.15           O  
ATOM    801  CB  THR   106       2.433   8.013  12.428  1.00 34.10           C  
ATOM    802  OG1 THR   106       1.414   8.638  13.188  1.00 31.30           O  
ATOM    803  CG2 THR   106       2.327   8.420  10.959  1.00 34.03           C  
ATOM    804  N   ILE   107       3.132   5.025  10.920  1.00 38.13           N  
ATOM    805  CA  ILE   107       4.158   4.261  10.213  1.00 39.30           C  
ATOM    806  C   ILE   107       4.981   5.173   9.307  1.00 40.57           C  
ATOM    807  O   ILE   107       4.429   5.895   8.477  1.00 40.68           O  
ATOM    808  CB  ILE   107       3.529   3.114   9.412  1.00 39.46           C  
ATOM    809  CG1 ILE   107       3.043   2.027  10.371  1.00 39.21           C  
ATOM    810  CG2 ILE   107       4.549   2.512   8.452  1.00 41.13           C  
ATOM    811  CD1 ILE   107       2.244   0.962   9.685  1.00 38.98           C  
ATOM    812  N   ASN   108       6.302   5.183   9.514  1.00 41.61           N  
ATOM    813  CA  ASN   108       7.226   5.941   8.673  1.00 42.13           C  
ATOM    814  C   ASN   108       8.345   5.016   8.148  1.00 43.07           C  
ATOM    815  O   ASN   108       8.456   3.821   8.511  1.00 43.07           O  
ATOM    816  CB  ASN   108       7.791   7.132   9.443  1.00 42.42           C  
ATOM    817  CG  ASN   108       6.890   8.360   9.402  1.00 43.28           C  
ATOM    818  OD1 ASN   108       6.703   8.971   8.351  1.00 42.03           O  
ATOM    819  ND2 ASN   108       6.370   8.759  10.563  1.00 45.25           N  
ATOM    820  N   ASP   109       9.155   5.564   7.259  1.00 44.42           N  
ATOM    821  CA  ASP   109      10.191   4.796   6.604  1.00 45.61           C  
ATOM    822  C   ASP   109      11.493   4.922   7.361  1.00 45.73           C  
ATOM    823  O   ASP   109      12.034   6.025   7.476  1.00 44.24           O  
ATOM    824  CB  ASP   109      10.394   5.295   5.178  1.00 46.20           C  
ATOM    825  CG  ASP   109      11.490   4.541   4.457  1.00 48.35           C  
ATOM    826  OD1 ASP   109      11.393   3.292   4.368  1.00 54.39           O  
ATOM    827  OD2 ASP   109      12.451   5.188   3.989  1.00 51.03           O  
ATOM    828  N   PHE   110      12.011   3.805   7.872  1.00 46.52           N  
ATOM    829  CA  PHE   110      13.354   3.834   8.470  1.00 47.64           C  
ATOM    830  C   PHE   110      14.370   3.250   7.512  1.00 48.40           C  
ATOM    831  O   PHE   110      14.465   2.031   7.360  1.00 46.87           O  
ATOM    832  CB  PHE   110      13.432   3.133   9.827  1.00 48.31           C  
ATOM    833  CG  PHE   110      14.798   3.279  10.495  1.00 49.63           C  
ATOM    834  CD1 PHE   110      15.256   4.535  10.910  1.00 49.78           C  
ATOM    835  CD2 PHE   110      15.640   2.190  10.660  1.00 51.36           C  
ATOM    836  CE1 PHE   110      16.530   4.685  11.507  1.00 50.52           C  
ATOM    837  CE2 PHE   110      16.911   2.336  11.254  1.00 50.54           C  
ATOM    838  CZ  PHE   110      17.346   3.587  11.685  1.00 51.58           C  
ATOM    839  N   PHE   111      15.103   4.133   6.839  1.00 49.53           N  
ATOM    840  CA  PHE   111      16.111   3.712   5.870  1.00 51.07           C  
ATOM    841  C   PHE   111      15.669   2.458   5.100  1.00 51.26           C  
ATOM    842  O   PHE   111      16.360   1.437   5.113  1.00 51.68           O  
ATOM    843  CB  PHE   111      17.452   3.440   6.570  1.00 51.89           C  
ATOM    844  CG  PHE   111      17.985   4.614   7.351  1.00 52.62           C  
ATOM    845  CD1 PHE   111      18.174   5.854   6.733  1.00 54.80           C  
ATOM    846  CD2 PHE   111      18.287   4.487   8.692  1.00 52.93           C  
ATOM    847  CE1 PHE   111      18.658   6.948   7.451  1.00 53.82           C  
ATOM    848  CE2 PHE   111      18.773   5.575   9.419  1.00 54.61           C  
ATOM    849  CZ  PHE   111      18.955   6.808   8.787  1.00 53.77           C  
ATOM    850  N   GLY   112      14.504   2.524   4.466  1.00 51.34           N  
ATOM    851  CA  GLY   112      14.030   1.412   3.625  1.00 51.36           C  
ATOM    852  C   GLY   112      12.917   0.541   4.188  1.00 51.10           C  
ATOM    853  O   GLY   112      12.110   0.033   3.426  1.00 51.41           O  
ATOM    854  N   ARG   113      12.864   0.349   5.506  1.00 50.84           N  
ATOM    855  CA  ARG   113      11.790  -0.462   6.103  1.00 50.80           C  
ATOM    856  C   ARG   113      10.723   0.413   6.788  1.00 49.66           C  
ATOM    857  O   ARG   113      11.048   1.428   7.389  1.00 49.62           O  
ATOM    858  CB  ARG   113      12.348  -1.553   7.040  1.00 51.29           C  
ATOM    859  CG  ARG   113      13.239  -1.084   8.214  1.00 52.28           C  
ATOM    860  CD  ARG   113      14.124  -2.262   8.714  1.00 52.16           C  
ATOM    861  N   PRO   114       9.435   0.047   6.649  1.00 48.76           N  
ATOM    862  CA  PRO   114       8.375   0.810   7.306  1.00 47.97           C  
ATOM    863  C   PRO   114       8.189   0.360   8.759  1.00 46.80           C  
ATOM    864  O   PRO   114       8.054  -0.825   9.027  1.00 47.46           O  
ATOM    865  CB  PRO   114       7.140   0.506   6.449  1.00 47.96           C  
ATOM    866  CG  PRO   114       7.379  -0.877   5.941  1.00 48.86           C  
ATOM    867  CD  PRO   114       8.887  -1.082   5.872  1.00 49.07           C  
ATOM    868  N   MET   115       8.177   1.318   9.678  0.50 46.47           N  
ATOM    870  CA  MET   115       8.056   1.030  11.103  0.50 45.86           C  
ATOM    872  C   MET   115       7.291   2.168  11.788  0.50 44.88           C  
ATOM    874  O   MET   115       7.359   3.309  11.343  0.50 44.01           O  
ATOM    876  CB  MET   115       9.451   0.898  11.739  0.50 46.26           C  
ATOM    878  CG  MET   115      10.313  -0.248  11.193  0.50 47.41           C  
ATOM    880  SD  MET   115       9.615  -1.997  11.588  0.38 50.15          SE  
ATOM    882  CE  MET   115      10.573  -2.363  13.234  0.50 47.61           C  
ATOM    884  N   PRO   116       6.549   1.854  12.864  1.00 43.99           N  
ATOM    885  CA  PRO   116       5.908   2.915  13.646  1.00 43.79           C  
ATOM    886  C   PRO   116       6.908   3.920  14.251  1.00 43.02           C  
ATOM    887  O   PRO   116       8.073   3.608  14.453  1.00 43.43           O  
ATOM    888  CB  PRO   116       5.140   2.150  14.737  1.00 43.24           C  
ATOM    889  CG  PRO   116       5.546   0.747  14.654  1.00 43.88           C  
ATOM    890  CD  PRO   116       6.238   0.505  13.371  1.00 43.91           C  
ATOM    891  N   ASN   117       6.469   5.128  14.529  1.00 43.16           N  
ATOM    892  CA  ASN   117       7.364   6.096  15.140  1.00 42.24           C  
ATOM    893  C   ASN   117       8.000   5.609  16.448  1.00 42.64           C  
ATOM    894  O   ASN   117       9.145   5.941  16.721  1.00 41.88           O  
ATOM    895  CB  ASN   117       6.677   7.436  15.340  1.00 42.23           C  
ATOM    896  CG  ASN   117       6.544   8.202  14.055  1.00 40.47           C  
ATOM    897  OD1 ASN   117       7.400   8.099  13.181  1.00 38.78           O  
ATOM    898  ND2 ASN   117       5.470   8.955  13.918  1.00 38.60           N  
ATOM    899  N   SER   118       7.285   4.802  17.231  1.00 42.46           N  
ATOM    900  CA  SER   118       7.817   4.322  18.514  1.00 42.93           C  
ATOM    901  C   SER   118       9.114   3.502  18.368  1.00 43.27           C  
ATOM    902  O   SER   118       9.988   3.534  19.238  1.00 43.99           O  
ATOM    903  CB  SER   118       6.773   3.497  19.258  1.00 42.42           C  
ATOM    904  OG  SER   118       6.295   2.479  18.432  1.00 41.62           O  
ATOM    905  N   ILE   119       9.237   2.797  17.258  1.00 43.05           N  
ATOM    906  CA  ILE   119      10.407   1.994  16.975  1.00 42.90           C  
ATOM    907  C   ILE   119      11.566   2.922  16.605  1.00 41.18           C  
ATOM    908  O   ILE   119      12.708   2.727  17.031  1.00 40.63           O  
ATOM    909  CB  ILE   119      10.119   0.981  15.854  1.00 42.76           C  
ATOM    910  CG1 ILE   119       9.021  -0.010  16.269  1.00 44.12           C  
ATOM    911  CG2 ILE   119      11.356   0.189  15.505  1.00 44.93           C  
ATOM    912  CD1 ILE   119       9.352  -0.890  17.475  1.00 45.27           C  
ATOM    913  N   PHE   120      11.295   3.973  15.853  1.00 40.62           N  
ATOM    914  CA  PHE   120      12.348   4.973  15.652  1.00 39.21           C  
ATOM    915  C   PHE   120      12.948   5.328  17.000  1.00 39.52           C  
ATOM    916  O   PHE   120      14.185   5.420  17.164  1.00 37.20           O  
ATOM    917  CB  PHE   120      11.821   6.234  15.001  1.00 39.58           C  
ATOM    918  CG  PHE   120      11.571   6.107  13.531  1.00 39.72           C  
ATOM    919  CD1 PHE   120      10.412   5.516  13.048  1.00 39.04           C  
ATOM    920  CD2 PHE   120      12.487   6.596  12.623  1.00 38.89           C  
ATOM    921  CE1 PHE   120      10.182   5.415  11.703  1.00 37.81           C  
ATOM    922  CE2 PHE   120      12.241   6.509  11.278  1.00 39.88           C  
ATOM    923  CZ  PHE   120      11.099   5.880  10.817  1.00 38.14           C  
ATOM    924  N   LEU   121      12.060   5.568  17.965  1.00 40.36           N  
ATOM    925  CA  LEU   121      12.462   6.141  19.252  1.00 40.88           C  
ATOM    926  C   LEU   121      13.201   5.076  20.060  1.00 41.08           C  
ATOM    927  O   LEU   121      14.167   5.373  20.736  1.00 41.03           O  
ATOM    928  CB  LEU   121      11.251   6.666  20.044  1.00 39.89           C  
ATOM    929  CG  LEU   121      10.589   7.958  19.555  1.00 40.55           C  
ATOM    930  CD1 LEU   121       9.500   8.383  20.498  1.00 36.76           C  
ATOM    931  CD2 LEU   121      11.587   9.034  19.411  1.00 37.03           C  
ATOM    932  N   MET   122      12.732   3.839  19.983  1.00 42.59           N  
ATOM    933  CA  MET   122      13.398   2.724  20.632  1.00 44.24           C  
ATOM    934  C   MET   122      14.806   2.595  20.071  1.00 43.62           C  
ATOM    935  O   MET   122      15.748   2.275  20.792  1.00 43.80           O  
ATOM    936  CB  MET   122      12.626   1.429  20.368  1.00 44.26           C  
ATOM    937  CG  MET   122      13.187   0.214  21.018  1.00 45.86           C  
ATOM    938  SD  MET   122      12.557  -1.437  20.132  0.75 51.63          SE  
ATOM    939  CE  MET   122      13.554  -1.285  18.357  1.00 45.57           C  
ATOM    940  N   THR   123      14.928   2.831  18.769  1.00 43.14           N  
ATOM    941  CA  THR   123      16.176   2.644  18.056  1.00 42.91           C  
ATOM    942  C   THR   123      17.158   3.733  18.461  1.00 42.21           C  
ATOM    943  O   THR   123      18.335   3.460  18.652  1.00 41.89           O  
ATOM    944  CB  THR   123      15.935   2.539  16.496  1.00 43.39           C  
ATOM    945  OG1 THR   123      15.197   1.332  16.211  1.00 42.69           O  
ATOM    946  CG2 THR   123      17.277   2.521  15.712  1.00 43.20           C  
ATOM    947  N   LEU   124      16.659   4.957  18.632  1.00 41.77           N  
ATOM    948  CA  LEU   124      17.475   6.046  19.083  1.00 41.19           C  
ATOM    949  C   LEU   124      18.160   5.732  20.419  1.00 40.75           C  
ATOM    950  O   LEU   124      19.355   5.996  20.581  1.00 41.36           O  
ATOM    951  CB  LEU   124      16.623   7.307  19.230  1.00 40.93           C  
ATOM    952  CG  LEU   124      17.272   8.604  19.668  1.00 42.46           C  
ATOM    953  CD1 LEU   124      18.157   9.190  18.567  1.00 43.77           C  
ATOM    954  CD2 LEU   124      16.209   9.596  20.074  1.00 40.62           C  
ATOM    955  N   ILE   125      17.390   5.216  21.370  1.00 39.88           N  
ATOM    956  CA  ILE   125      17.882   4.938  22.718  1.00 39.12           C  
ATOM    957  C   ILE   125      18.893   3.817  22.712  1.00 38.38           C  
ATOM    958  O   ILE   125      19.932   3.928  23.361  1.00 37.70           O  
ATOM    959  CB  ILE   125      16.723   4.572  23.708  1.00 39.09           C  
ATOM    960  CG1 ILE   125      15.852   5.792  23.978  1.00 39.79           C  
ATOM    961  CG2 ILE   125      17.271   4.080  25.043  1.00 38.31           C  
ATOM    962  CD1 ILE   125      14.656   5.520  24.864  1.00 39.65           C  
ATOM    963  N   ASN   126      18.573   2.744  21.993  1.00 37.52           N  
ATOM    964  CA  ASN   126      19.421   1.576  21.890  1.00 37.33           C  
ATOM    965  C   ASN   126      20.784   1.868  21.247  1.00 37.26           C  
ATOM    966  O   ASN   126      21.834   1.440  21.754  1.00 34.80           O  
ATOM    967  CB  ASN   126      18.731   0.501  21.061  1.00 38.33           C  
ATOM    968  CG  ASN   126      17.650  -0.227  21.809  1.00 40.70           C  
ATOM    969  OD1 ASN   126      17.448  -0.023  23.011  1.00 44.17           O  
ATOM    970  ND2 ASN   126      16.942  -1.105  21.098  1.00 40.57           N  
ATOM    971  N   HIS   127      20.745   2.631  20.149  1.00 37.71           N  
ATOM    972  CA  HIS   127      21.946   3.060  19.420  1.00 37.67           C  
ATOM    973  C   HIS   127      22.850   3.873  20.342  1.00 38.98           C  
ATOM    974  O   HIS   127      24.033   3.565  20.464  1.00 39.22           O  
ATOM    975  CB  HIS   127      21.545   3.859  18.163  1.00 37.87           C  
ATOM    976  CG  HIS   127      22.698   4.444  17.394  1.00 35.17           C  
ATOM    977  ND1 HIS   127      23.003   5.788  17.416  1.00 36.73           N  
ATOM    978  CD2 HIS   127      23.596   3.870  16.561  1.00 31.82           C  
ATOM    979  CE1 HIS   127      24.052   6.011  16.635  1.00 36.20           C  
ATOM    980  NE2 HIS   127      24.431   4.859  16.110  1.00 36.17           N  
ATOM    981  N   GLN   128      22.284   4.910  20.959  1.00 39.54           N  
ATOM    982  CA  GLN   128      22.991   5.785  21.878  1.00 39.52           C  
ATOM    983  C   GLN   128      23.639   5.025  23.041  1.00 40.57           C  
ATOM    984  O   GLN   128      24.742   5.354  23.454  1.00 40.88           O  
ATOM    985  CB  GLN   128      22.031   6.804  22.432  1.00 39.57           C  
ATOM    986  CG  GLN   128      22.707   7.895  23.259  1.00 39.96           C  
ATOM    987  CD  GLN   128      21.758   8.933  23.719  1.00 41.12           C  
ATOM    988  OE1 GLN   128      21.881  10.106  23.351  1.00 40.43           O  
ATOM    989  NE2 GLN   128      20.781   8.525  24.537  1.00 40.41           N  
ATOM    990  N   ASN   129      22.938   4.011  23.545  1.00 39.82           N  
ATOM    991  CA  ASN   129      23.372   3.238  24.700  1.00 40.21           C  
ATOM    992  C   ASN   129      24.546   2.321  24.330  1.00 39.31           C  
ATOM    993  O   ASN   129      25.484   2.146  25.103  1.00 37.84           O  
ATOM    994  CB  ASN   129      22.177   2.428  25.230  1.00 40.29           C  
ATOM    995  CG  ASN   129      22.493   1.635  26.501  1.00 43.51           C  
ATOM    996  OD1 ASN   129      23.480   1.893  27.194  1.00 47.46           O  
ATOM    997  ND2 ASN   129      21.635   0.670  26.813  1.00 42.77           N  
ATOM    998  N   HIS   130      24.484   1.738  23.139  1.00 39.10           N  
ATOM    999  CA  HIS   130      25.593   0.936  22.613  1.00 39.02           C  
ATOM   1000  C   HIS   130      26.897   1.733  22.570  1.00 38.12           C  
ATOM   1001  O   HIS   130      27.934   1.271  23.066  1.00 38.39           O  
ATOM   1002  CB  HIS   130      25.256   0.453  21.204  1.00 39.29           C  
ATOM   1003  CG  HIS   130      26.436  -0.046  20.435  1.00 39.26           C  
ATOM   1004  ND1 HIS   130      27.062  -1.242  20.720  1.00 38.14           N  
ATOM   1005  CD2 HIS   130      27.077   0.472  19.358  1.00 38.78           C  
ATOM   1006  CE1 HIS   130      28.049  -1.429  19.861  1.00 39.64           C  
ATOM   1007  NE2 HIS   130      28.076  -0.408  19.022  1.00 37.62           N  
ATOM   1008  N   HIS   131      26.827   2.903  21.955  1.00 37.71           N  
ATOM   1009  CA  HIS   131      27.988   3.785  21.779  1.00 37.24           C  
ATOM   1010  C   HIS   131      28.470   4.463  23.054  1.00 36.58           C  
ATOM   1011  O   HIS   131      29.678   4.713  23.234  1.00 35.94           O  
ATOM   1012  CB  HIS   131      27.678   4.853  20.735  1.00 36.93           C  
ATOM   1013  CG  HIS   131      27.717   4.354  19.332  1.00 37.60           C  
ATOM   1014  ND1 HIS   131      28.868   3.884  18.747  1.00 36.87           N  
ATOM   1015  CD2 HIS   131      26.747   4.253  18.390  1.00 37.91           C  
ATOM   1016  CE1 HIS   131      28.609   3.523  17.505  1.00 37.78           C  
ATOM   1017  NE2 HIS   131      27.336   3.754  17.261  1.00 34.19           N  
ATOM   1018  N   ARG   132      27.543   4.804  23.941  1.00 35.76           N  
ATOM   1019  CA  ARG   132      27.938   5.285  25.276  1.00 34.80           C  
ATOM   1020  C   ARG   132      28.688   4.161  26.034  1.00 33.64           C  
ATOM   1021  O   ARG   132      29.653   4.410  26.732  1.00 34.61           O  
ATOM   1022  CB  ARG   132      26.708   5.777  26.034  1.00 34.99           C  
ATOM   1023  CG  ARG   132      26.991   6.320  27.405  1.00 35.58           C  
ATOM   1024  CD  ARG   132      25.714   6.783  28.055  1.00 36.45           C  
ATOM   1025  NE  ARG   132      24.850   5.641  28.286  1.00 37.68           N  
ATOM   1026  CZ  ARG   132      23.521   5.686  28.360  1.00 38.30           C  
ATOM   1027  NH1 ARG   132      22.846   6.823  28.219  1.00 39.14           N  
ATOM   1028  NH2 ARG   132      22.870   4.562  28.571  1.00 39.80           N  
ATOM   1029  N   GLY   133      28.280   2.922  25.844  1.00 32.34           N  
ATOM   1030  CA  GLY   133      28.989   1.783  26.409  1.00 31.59           C  
ATOM   1031  C   GLY   133      30.444   1.793  25.950  1.00 32.06           C  
ATOM   1032  O   GLY   133      31.351   1.540  26.737  1.00 30.70           O  
ATOM   1033  N   GLN   134      30.653   2.096  24.657  1.00 31.73           N  
ATOM   1034  CA  GLN   134      31.993   2.201  24.073  1.00 31.14           C  
ATOM   1035  C   GLN   134      32.742   3.366  24.677  1.00 31.57           C  
ATOM   1036  O   GLN   134      33.901   3.248  25.057  1.00 31.15           O  
ATOM   1037  CB  GLN   134      31.891   2.422  22.556  1.00 31.55           C  
ATOM   1038  CG  GLN   134      31.237   1.280  21.816  1.00 30.22           C  
ATOM   1039  CD  GLN   134      31.205   1.457  20.280  1.00 30.87           C  
ATOM   1040  OE1 GLN   134      31.000   2.551  19.773  1.00 31.06           O  
ATOM   1041  NE2 GLN   134      31.352   0.342  19.553  1.00 30.25           N  
ATOM   1042  N   MET   135      32.076   4.505  24.775  1.00 32.32           N  
ATOM   1043  CA  MET   135      32.726   5.670  25.337  1.00 32.89           C  
ATOM   1044  C   MET   135      33.338   5.397  26.707  1.00 33.44           C  
ATOM   1045  O   MET   135      34.440   5.908  27.011  1.00 35.37           O  
ATOM   1046  CB  MET   135      31.764   6.835  25.458  1.00 32.64           C  
ATOM   1047  CG  MET   135      31.184   7.333  24.230  1.00 32.39           C  
ATOM   1048  SD  MET   135      30.930   9.293  24.527  0.75 35.42          SE  
ATOM   1049  CE  MET   135      29.463   9.275  25.594  1.00 34.05           C  
ATOM   1050  N   THR   136      32.638   4.614  27.540  1.00 33.67           N  
ATOM   1051  CA  THR   136      33.069   4.336  28.906  1.00 33.46           C  
ATOM   1052  C   THR   136      34.411   3.620  28.966  1.00 33.57           C  
ATOM   1053  O   THR   136      35.226   3.956  29.827  1.00 33.18           O  
ATOM   1054  CB  THR   136      31.974   3.629  29.797  1.00 34.12           C  
ATOM   1055  OG1 THR   136      31.679   2.298  29.339  1.00 33.45           O  
ATOM   1056  CG2 THR   136      30.694   4.480  29.887  1.00 34.20           C  
ATOM   1057  N   VAL   137      34.650   2.652  28.073  1.00 33.16           N  
ATOM   1058  CA  VAL   137      35.947   1.999  28.004  1.00 31.90           C  
ATOM   1059  C   VAL   137      37.024   3.017  27.608  1.00 32.75           C  
ATOM   1060  O   VAL   137      38.055   3.151  28.290  1.00 32.42           O  
ATOM   1061  CB  VAL   137      35.924   0.763  27.088  1.00 32.54           C  
ATOM   1062  CG1 VAL   137      37.310   0.088  27.014  1.00 30.39           C  
ATOM   1063  CG2 VAL   137      34.897  -0.219  27.585  1.00 30.37           C  
ATOM   1064  N   LEU   138      36.754   3.790  26.567  1.00 32.99           N  
ATOM   1065  CA  LEU   138      37.733   4.764  26.071  1.00 33.03           C  
ATOM   1066  C   LEU   138      38.023   5.878  27.082  1.00 33.16           C  
ATOM   1067  O   LEU   138      39.178   6.293  27.240  1.00 33.13           O  
ATOM   1068  CB  LEU   138      37.270   5.365  24.730  1.00 33.09           C  
ATOM   1069  CG  LEU   138      37.161   4.361  23.591  1.00 31.63           C  
ATOM   1070  CD1 LEU   138      36.442   4.958  22.359  1.00 31.53           C  
ATOM   1071  CD2 LEU   138      38.529   3.851  23.223  1.00 28.96           C  
ATOM   1072  N   MET   139      36.987   6.357  27.760  1.00 33.22           N  
ATOM   1073  CA  MET   139      37.166   7.366  28.827  1.00 32.98           C  
ATOM   1074  C   MET   139      38.103   6.866  29.938  1.00 33.25           C  
ATOM   1075  O   MET   139      39.005   7.570  30.356  1.00 32.78           O  
ATOM   1076  CB  MET   139      35.820   7.780  29.415  1.00 33.36           C  
ATOM   1077  CG  MET   139      34.918   8.630  28.492  1.00 32.73           C  
ATOM   1078  SD  MET   139      33.085   8.665  29.128  0.75 30.52          SE  
ATOM   1079  CE  MET   139      32.541   7.010  28.489  1.00 37.70           C  
ATOM   1080  N   ARG   140      37.892   5.632  30.376  1.00 33.99           N  
ATOM   1081  CA  ARG   140      38.755   4.960  31.357  1.00 34.31           C  
ATOM   1082  C   ARG   140      40.199   4.928  30.866  1.00 34.39           C  
ATOM   1083  O   ARG   140      41.151   5.218  31.601  1.00 34.22           O  
ATOM   1084  CB  ARG   140      38.296   3.497  31.528  1.00 35.08           C  
ATOM   1085  CG  ARG   140      37.921   3.085  32.923  1.00 36.93           C  
ATOM   1086  CD  ARG   140      36.405   3.172  33.147  1.00 39.40           C  
ATOM   1087  N   GLN   141      40.353   4.543  29.606  1.00 34.09           N  
ATOM   1088  CA  GLN   141      41.661   4.424  28.977  1.00 33.28           C  
ATOM   1089  C   GLN   141      42.325   5.785  28.806  1.00 33.33           C  
ATOM   1090  O   GLN   141      43.552   5.878  28.835  1.00 33.32           O  
ATOM   1091  CB  GLN   141      41.520   3.683  27.657  1.00 32.82           C  
ATOM   1092  CG  GLN   141      41.363   2.197  27.917  1.00 31.72           C  
ATOM   1093  CD  GLN   141      40.902   1.407  26.735  1.00 29.68           C  
ATOM   1094  OE1 GLN   141      40.531   1.974  25.712  1.00 30.80           O  
ATOM   1095  NE2 GLN   141      40.907   0.076  26.868  1.00 24.28           N  
ATOM   1096  N   ALA   142      41.527   6.837  28.693  1.00 32.84           N  
ATOM   1097  CA  ALA   142      42.065   8.191  28.666  1.00 33.41           C  
ATOM   1098  C   ALA   142      42.404   8.762  30.041  1.00 34.75           C  
ATOM   1099  O   ALA   142      42.844   9.900  30.119  1.00 35.04           O  
ATOM   1100  CB  ALA   142      41.107   9.111  27.974  1.00 33.31           C  
ATOM   1101  N   GLY   143      42.182   7.997  31.107  1.00 35.67           N  
ATOM   1102  CA  GLY   143      42.444   8.465  32.473  1.00 36.87           C  
ATOM   1103  C   GLY   143      41.377   9.378  33.058  1.00 37.96           C  
ATOM   1104  O   GLY   143      41.661  10.162  33.986  1.00 37.88           O  
ATOM   1105  N   LEU   144      40.153   9.293  32.531  1.00 38.67           N  
ATOM   1106  CA  LEU   144      39.039  10.087  33.046  1.00 39.74           C  
ATOM   1107  C   LEU   144      38.243   9.266  34.055  1.00 41.04           C  
ATOM   1108  O   LEU   144      38.272   8.033  34.042  1.00 41.16           O  
ATOM   1109  CB  LEU   144      38.115  10.554  31.904  1.00 39.79           C  
ATOM   1110  CG  LEU   144      38.750  11.388  30.784  1.00 39.05           C  
ATOM   1111  CD1 LEU   144      37.741  11.652  29.658  1.00 37.45           C  
ATOM   1112  CD2 LEU   144      39.326  12.691  31.324  1.00 37.24           C  
ATOM   1113  N   THR   145      37.532   9.955  34.939  1.00 42.81           N  
ATOM   1114  CA  THR   145      36.675   9.292  35.916  1.00 43.91           C  
ATOM   1115  C   THR   145      35.292   9.190  35.292  1.00 44.95           C  
ATOM   1116  O   THR   145      34.691  10.213  34.976  1.00 45.22           O  
ATOM   1117  CB  THR   145      36.637  10.071  37.272  1.00 43.99           C  
ATOM   1118  N   VAL   146      34.804   7.967  35.078  1.00 46.59           N  
ATOM   1119  CA  VAL   146      33.513   7.753  34.406  1.00 47.92           C  
ATOM   1120  C   VAL   146      32.374   7.775  35.425  1.00 49.33           C  
ATOM   1121  O   VAL   146      32.372   6.954  36.348  1.00 49.23           O  
ATOM   1122  CB  VAL   146      33.440   6.392  33.644  1.00 47.94           C  
ATOM   1123  CG1 VAL   146      32.086   6.219  32.986  1.00 47.64           C  
ATOM   1124  CG2 VAL   146      34.524   6.286  32.608  1.00 47.28           C  
ATOM   1125  N   PRO   147      31.418   8.721  35.280  1.00 50.94           N  
ATOM   1126  CA  PRO   147      30.191   8.590  36.084  1.00 52.30           C  
ATOM   1127  C   PRO   147      29.379   7.337  35.681  1.00 53.55           C  
ATOM   1128  O   PRO   147      29.364   6.959  34.504  1.00 54.31           O  
ATOM   1129  CB  PRO   147      29.432   9.895  35.801  1.00 52.10           C  
ATOM   1130  CG  PRO   147      30.019  10.431  34.537  1.00 51.92           C  
ATOM   1131  CD  PRO   147      31.418   9.940  34.447  1.00 50.72           C  
ATOM   1132  N   GLY   148      28.741   6.691  36.653  1.00 54.81           N  
ATOM   1133  CA  GLY   148      28.048   5.415  36.423  1.00 55.64           C  
ATOM   1134  C   GLY   148      26.796   5.497  35.556  1.00 56.25           C  
ATOM   1135  O   GLY   148      26.265   6.585  35.318  1.00 56.77           O  
ATOM   1136  N   VAL   149      26.355   4.333  35.066  1.00 56.83           N  
ATOM   1137  CA  VAL   149      25.069   4.165  34.366  1.00 57.00           C  
ATOM   1138  C   VAL   149      24.507   2.753  34.644  1.00 57.36           C  
ATOM   1139  O   VAL   149      25.260   1.768  34.683  1.00 57.45           O  
ATOM   1140  CB  VAL   149      25.194   4.411  32.825  1.00 56.97           C  
ATOM   1141  CG1 VAL   149      25.952   3.287  32.158  1.00 56.88           C  
ATOM   1142  CG2 VAL   149      23.807   4.585  32.169  1.00 56.07           C  
ATOM   1143  N   TYR   150      23.187   2.668  34.834  1.00 57.52           N  
ATOM   1144  CA  TYR   150      22.495   1.406  35.158  1.00 57.45           C  
ATOM   1145  C   TYR   150      23.080   0.739  36.395  1.00 57.47           C  
ATOM   1146  O   TYR   150      23.301   1.402  37.405  1.00 57.84           O  
ATOM   1147  CB  TYR   150      22.503   0.438  33.960  1.00 57.31           C  
ATOM   1148  CG  TYR   150      21.973   1.059  32.682  1.00 57.19           C  
ATOM   1149  CD1 TYR   150      20.797   1.825  32.692  1.00 57.44           C  
ATOM   1150  CD2 TYR   150      22.638   0.897  31.466  1.00 57.06           C  
ATOM   1151  CE1 TYR   150      20.301   2.411  31.534  1.00 56.37           C  
ATOM   1152  CE2 TYR   150      22.142   1.491  30.290  1.00 56.34           C  
ATOM   1153  CZ  TYR   150      20.975   2.243  30.345  1.00 56.39           C  
ATOM   1154  OH  TYR   150      20.455   2.825  29.223  1.00 56.70           O  
END
