
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 (  967),  selected  126 , name 2yqy_A
# Molecule2: number of CA atoms  150 ( 1146),  selected  150 , name T0406.pdb
# PARAMETERS: 2yqy_A.T0406.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    T     9_A      Y       2          2.125
LGA    -       -      Q       3           -
LGA    -       -      T       4           -
LGA    W    10_A      I       5          4.371
LGA    D    11_A      E       6          3.563
LGA    E    12_A      G       7          3.886
LGA    A    13_A      F       8          3.496
LGA    L    14_A      L       9          2.641
LGA    K    15_A      Q      10          2.311
LGA    R    16_A      S      11          2.595
LGA    L    17_A      W      12          2.363
LGA    E    18_A      T      13          1.807
LGA    A    19_A      Y      14          1.659
LGA    S    20_A      E      15          2.161
LGA    R    21_A      T      16          1.988
LGA    K    22_A      E      17          1.853
LGA    A    23_A      S      18          1.851
LGA    L    24_A      T      19          1.979
LGA    L    25_A      Q      20          2.059
LGA    A    26_A      K      21          1.814
LGA    L    27_A      M      22          1.753
LGA    L    28_A      L      23          2.524
LGA    R    29_A      D      24          2.406
LGA    E    30_A      V      25          2.128
LGA    A    31_A      L      26          3.598
LGA    D    32_A      T      27          4.943
LGA    P    33_A      D      28          3.950
LGA    A    34_A      E      29          2.722
LGA    W    35_A      S      30          2.407
LGA    L    36_A      L      31          2.239
LGA    S    37_A      S      32          1.963
LGA    A    38_A      Q      33          1.654
LGA    P    39_A      E      34          1.531
LGA    L    40_A      I      35          2.170
LGA    R    41_A      A      36          2.086
LGA    E    42_A      P      37          2.267
LGA    G    43_A      G      38          1.817
LGA    A    44_A      H      39          1.833
LGA    W    45_A      W      40          1.415
LGA    T    46_A      T      41          1.669
LGA    P    47_A      L      42          1.811
LGA    L    48_A      G      43          1.880
LGA    M    49_A      R      44          1.332
LGA    V    50_A      V      45          1.450
LGA    A    51_A      A      46          1.788
LGA    E    52_A      W      47          1.369
LGA    H    53_A      H      48          1.137
LGA    V    54_A      I      49          1.326
LGA    A    55_A      V      50          1.613
LGA    L    56_A      T      51          1.396
LGA    V    57_A      A      52          1.574
LGA    E    58_A      I      53          0.651
LGA    D    59_A      P      54          1.664
LGA    S    60_A      V      55          2.582
LGA    T    61_A      I      56          3.728
LGA    A    62_A      L      57          4.210
LGA    R    63_A      S      58          3.638
LGA    V    64_A      G      59          3.121
LGA    L    65_A      T      60          3.183
LGA    R    66_A      G      61          3.048
LGA    R    67_A      L      62          5.173
LGA    L    68_A      K      63           -
LGA    R    69_A      F      64           -
LGA    R    70_A      E      65           -
LGA    L    71_A      G      66           -
LGA    A    72_A      E      67           -
LGA    -       -      T      68           -
LGA    -       -      K      69           -
LGA    -       -      D      70           -
LGA    -       -      Y      71           -
LGA    -       -      P      72           -
LGA    -       -      V      73           -
LGA    L   104_A      P      74          1.598
LGA    S   105_A      T      75          2.842
LGA    -       -      S      76           -
LGA    L   106_A      A      77          0.914
LGA    E   107_A      K      78          1.827
LGA    E   108_A      T      79          1.705
LGA    V   109_A      I      80          1.243
LGA    L   110_A      A      81          2.028
LGA    A   111_A      D      82          2.772
LGA    L   112_A      G      83          2.038
LGA    L   113_A      Y      84          1.221
LGA    D   114_A      R      85          2.180
LGA    R   115_A      K      86          2.527
LGA    A   116_A      V      87          1.812
LGA    R   117_A      N      88          0.973
LGA    A   118_A      T      89          1.792
LGA    F   119_A      A      90          2.189
LGA    L   120_A      F      91          1.402
LGA    L   121_A      V      92          0.679
LGA    E   122_A      E      93          2.039
LGA    E   123_A      A      94          2.456
LGA    V   124_A      L      95          1.648
LGA    A   125_A      Q      96          1.040
LGA    K   126_A      S      97          3.450
LGA    -       -      E      98           -
LGA    A   127_A      W      99          1.689
LGA    D   128_A      T     100          3.515
LGA    P   129_A      D     101          3.737
LGA    Q   130_A      K     102          2.925
LGA    N   131_A      D     103          3.046
LGA    -       -      L     104           -
LGA    -       -      T     105           -
LGA    P   132_A      T     106          2.484
LGA    A   133_A      I     107          2.567
LGA    T   134_A      N     108          1.561
LGA    F   135_A      D     109          1.647
LGA    P   136_A      F     110          1.787
LGA    H   137_A      F     111          3.819
LGA    P   138_A      G     112           #
LGA    F   139_A      -       -           -
LGA    F   140_A      -       -           -
LGA    G   141_A      R     113          3.221
LGA    E   142_A      P     114          2.076
LGA    L   143_A      M     115          2.119
LGA    N   144_A      P     116          1.981
LGA    P   145_A      N     117          1.646
LGA    L   146_A      S     118          1.242
LGA    G   147_A      I     119          1.266
LGA    W   148_A      F     120          1.216
LGA    L   149_A      L     121          1.354
LGA    R   150_A      M     122          1.312
LGA    -       -      T     123           -
LGA    A   152_A      L     124          1.098
LGA    A   153_A      I     125          1.324
LGA    Y   154_A      N     126          1.187
LGA    H   155_A      H     127          1.634
LGA    E   156_A      Q     128          1.406
LGA    A   157_A      N     129          1.254
LGA    H   158_A      H     130          1.346
LGA    H   159_A      H     131          1.202
LGA    L   160_A      R     132          0.966
LGA    K   161_A      G     133          1.123
LGA    A   162_A      Q     134          1.329
LGA    L   163_A      M     135          0.968
LGA    Q   164_A      T     136          1.271
LGA    A   165_A      V     137          2.806
LGA    S   166_A      L     138          2.752
LGA    -       -      M     139           -
LGA    -       -      R     140           -
LGA    -       -      Q     141           -
LGA    -       -      A     142           -
LGA    -       -      G     143           -
LGA    -       -      L     144           -
LGA    -       -      T     145           -
LGA    -       -      V     146           -
LGA    -       -      P     147           -
LGA    -       -      G     148           -
LGA    -       -      V     149           -
LGA    -       -      Y     150           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126  150    5.0    118    2.30    12.71     56.575     4.917

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.287248 * X  +   0.381237 * Y  +   0.878719 * Z  +  -8.910643
  Y_new =  -0.119239 * X  +   0.896013 * Y  +  -0.427718 * Z  + -49.369289
  Z_new =  -0.950406 * X  +  -0.227639 * Y  +  -0.211920 * Z  + 110.736313 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.320449    0.821143  [ DEG:  -132.9520     47.0480 ]
  Theta =   1.254537    1.887055  [ DEG:    71.8797    108.1203 ]
  Phi   =  -2.748131    0.393462  [ DEG:  -157.4563     22.5437 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2yqy_A                                        
REMARK     2: T0406.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2yqy_A.T0406.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126  150   5.0  118   2.30   12.71  56.575
REMARK  ---------------------------------------------------------- 
MOLECULE 2yqy_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   31-MAR-07   2YQY              
TITLE     CRYSTAL STRUCTURE OF TT2238, A FOUR-HELIX BUNDLE PROTEIN              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN TTHA0303;                             
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: TT2238;                                                     
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 STRAIN: HB8;                                                         
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: B834(DE3)PLYSS;                            
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-11A-TT2238                            
KEYWDS    FOUR-HELIX-BUNDLE, NPPSFA, NATIONAL PROJECT ON PROTEIN                
KEYWDS   2 STRUCTURAL AND FUNCTIONAL ANALYSES, STRUCTURAL GENOMICS,             
KEYWDS   3 UNKNOWN FUNCTION                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.NAGATA,J.OHTSUKA,H.IINO,A.EBIHARA,S.YOKOYAMA,S.KURAMITSU,           
AUTHOR   2 M.TANOKURA                                                           
REVDAT   2   11-MAR-08 2YQY    1       REMARK                                   
REVDAT   1   04-MAR-08 2YQY    0                                                
JRNL        AUTH   K.NAGATA,J.OHTSUKA,M.TAKAHASHI,A.ASANO,H.IINO,               
JRNL        AUTH 2 A.EBIHARA,M.TANOKURA                                         
JRNL        TITL   CRYSTAL STRUCTURE OF TTHA0303 (TT2238), A                    
JRNL        TITL 2 FOUR-HELIX BUNDLE PROTEIN WITH AN EXPOSED                    
JRNL        TITL 3 HISTIDINE TRIAD FROM THERMUS THERMOPHILUS HB8 AT             
JRNL        TITL 4 2.0 A                                                        
JRNL        REF    PROTEINS                      V.  70  1103 2008              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2YQY A    1   169  UNP    Q5SLJ0   Q5SLJ0_THET8     1    169             
DBREF  2YQY B    1   169  UNP    Q5SLJ0   Q5SLJ0_THET8     1    169             
SEQRES   1 A  169  MET VAL ARG LEU GLU ASP TYR GLY THR TRP ASP GLU ALA          
SEQRES   2 A  169  LEU LYS ARG LEU GLU ALA SER ARG LYS ALA LEU LEU ALA          
SEQRES   3 A  169  LEU LEU ARG GLU ALA ASP PRO ALA TRP LEU SER ALA PRO          
SEQRES   4 A  169  LEU ARG GLU GLY ALA TRP THR PRO LEU MET VAL ALA GLU          
SEQRES   5 A  169  HIS VAL ALA LEU VAL GLU ASP SER THR ALA ARG VAL LEU          
SEQRES   6 A  169  ARG ARG LEU ARG ARG LEU ALA ALA GLY GLU ASN LEU PRO          
SEQRES   7 A  169  PRO VAL PRO VAL LYS PRO GLY GLU PHE LYS ASP GLY LYS          
SEQRES   8 A  169  PRO GLN ALA PRO GLU GLY VAL ARG PRO LYS GLY GLY LEU          
SEQRES   9 A  169  SER LEU GLU GLU VAL LEU ALA LEU LEU ASP ARG ALA ARG          
SEQRES  10 A  169  ALA PHE LEU LEU GLU GLU VAL ALA LYS ALA ASP PRO GLN          
SEQRES  11 A  169  ASN PRO ALA THR PHE PRO HIS PRO PHE PHE GLY GLU LEU          
SEQRES  12 A  169  ASN PRO LEU GLY TRP LEU ARG ALA ALA ALA TYR HIS GLU          
SEQRES  13 A  169  ALA HIS HIS LEU LYS ALA LEU GLN ALA SER LEU PRO ARG          
SEQRES   1 B  169  MET VAL ARG LEU GLU ASP TYR GLY THR TRP ASP GLU ALA          
SEQRES   2 B  169  LEU LYS ARG LEU GLU ALA SER ARG LYS ALA LEU LEU ALA          
SEQRES   3 B  169  LEU LEU ARG GLU ALA ASP PRO ALA TRP LEU SER ALA PRO          
SEQRES   4 B  169  LEU ARG GLU GLY ALA TRP THR PRO LEU MET VAL ALA GLU          
SEQRES   5 B  169  HIS VAL ALA LEU VAL GLU ASP SER THR ALA ARG VAL LEU          
SEQRES   6 B  169  ARG ARG LEU ARG ARG LEU ALA ALA GLY GLU ASN LEU PRO          
SEQRES   7 B  169  PRO VAL PRO VAL LYS PRO GLY GLU PHE LYS ASP GLY LYS          
SEQRES   8 B  169  PRO GLN ALA PRO GLU GLY VAL ARG PRO LYS GLY GLY LEU          
SEQRES   9 B  169  SER LEU GLU GLU VAL LEU ALA LEU LEU ASP ARG ALA ARG          
SEQRES  10 B  169  ALA PHE LEU LEU GLU GLU VAL ALA LYS ALA ASP PRO GLN          
SEQRES  11 B  169  ASN PRO ALA THR PHE PRO HIS PRO PHE PHE GLY GLU LEU          
SEQRES  12 B  169  ASN PRO LEU GLY TRP LEU ARG ALA ALA ALA TYR HIS GLU          
SEQRES  13 B  169  ALA HIS HIS LEU LYS ALA LEU GLN ALA SER LEU PRO ARG          
FORMUL   3  HOH   *73(H2 O)                                                     
CRYST1  104.846  104.846   51.254  90.00  90.00  90.00 P 41 21 2    16          
ATOM      1  N   THR A   9       7.262   2.109  26.321  1.00 17.22           N  
ATOM      2  CA  THR A   9       6.221   3.098  25.927  1.00 17.40           C  
ATOM      3  C   THR A   9       6.903   4.403  25.563  1.00 17.07           C  
ATOM      4  O   THR A   9       8.122   4.591  25.775  1.00 17.40           O  
ATOM      5  CB  THR A   9       5.167   3.402  27.063  1.00 17.60           C  
ATOM      6  OG1 THR A   9       5.814   4.085  28.150  1.00 17.54           O  
ATOM      7  CG2 THR A   9       4.484   2.144  27.567  1.00 18.31           C  
ATOM      8  N   TRP A  10       6.123   5.319  25.012  1.00 16.72           N  
ATOM      9  CA  TRP A  10       6.657   6.618  24.602  1.00 17.07           C  
ATOM     10  C   TRP A  10       7.337   7.355  25.758  1.00 16.65           C  
ATOM     11  O   TRP A  10       8.468   7.848  25.625  1.00 17.08           O  
ATOM     12  CB  TRP A  10       5.494   7.438  24.099  1.00 16.66           C  
ATOM     13  CG  TRP A  10       5.847   8.746  23.571  1.00 18.29           C  
ATOM     14  CD1 TRP A  10       5.764   9.945  24.217  1.00 20.52           C  
ATOM     15  CD2 TRP A  10       6.301   9.024  22.246  1.00 17.05           C  
ATOM     16  NE1 TRP A  10       6.134  10.962  23.368  1.00 20.83           N  
ATOM     17  CE2 TRP A  10       6.466  10.419  22.148  1.00 19.62           C  
ATOM     18  CE3 TRP A  10       6.550   8.228  21.118  1.00 16.26           C  
ATOM     19  CZ2 TRP A  10       6.895  11.036  20.970  1.00 16.59           C  
ATOM     20  CZ3 TRP A  10       6.984   8.851  19.939  1.00 16.56           C  
ATOM     21  CH2 TRP A  10       7.136  10.233  19.877  1.00 16.15           C  
ATOM     22  N   ASP A  11       6.664   7.424  26.899  1.00 15.25           N  
ATOM     23  CA  ASP A  11       7.189   8.122  28.066  1.00 16.08           C  
ATOM     24  C   ASP A  11       8.430   7.462  28.649  1.00 16.72           C  
ATOM     25  O   ASP A  11       9.356   8.160  29.100  1.00 17.33           O  
ATOM     26  CB  ASP A  11       6.121   8.227  29.161  1.00 15.82           C  
ATOM     27  CG  ASP A  11       5.025   9.175  28.795  1.00 16.92           C  
ATOM     28  OD1 ASP A  11       5.313  10.102  28.010  1.00 19.75           O  
ATOM     29  OD2 ASP A  11       3.875   9.024  29.296  1.00 21.65           O  
ATOM     30  N   GLU A  12       8.450   6.131  28.640  1.00 16.38           N  
ATOM     31  CA  GLU A  12       9.610   5.359  29.082  1.00 17.11           C  
ATOM     32  C   GLU A  12      10.860   5.603  28.239  1.00 18.11           C  
ATOM     33  O   GLU A  12      11.935   5.838  28.806  1.00 19.12           O  
ATOM     34  CB  GLU A  12       9.268   3.877  29.163  1.00 16.86           C  
ATOM     35  CG  GLU A  12       8.322   3.578  30.329  1.00 16.69           C  
ATOM     36  CD  GLU A  12       7.682   2.197  30.257  1.00 20.01           C  
ATOM     37  OE1 GLU A  12       7.860   1.499  29.236  1.00 21.33           O  
ATOM     38  OE2 GLU A  12       6.991   1.805  31.230  1.00 17.41           O  
ATOM     39  N   ALA A  13      10.725   5.570  26.906  1.00 18.31           N  
ATOM     40  CA  ALA A  13      11.853   5.814  26.019  1.00 17.85           C  
ATOM     41  C   ALA A  13      12.410   7.216  26.245  1.00 18.38           C  
ATOM     42  O   ALA A  13      13.629   7.410  26.286  1.00 17.23           O  
ATOM     43  CB  ALA A  13      11.475   5.602  24.557  1.00 18.71           C  
ATOM     44  N   LEU A  14      11.532   8.188  26.341  1.00 17.09           N  
ATOM     45  CA  LEU A  14      11.900   9.540  26.613  1.00 17.57           C  
ATOM     46  C   LEU A  14      12.626   9.710  27.940  1.00 17.41           C  
ATOM     47  O   LEU A  14      13.657  10.293  27.987  1.00 17.32           O  
ATOM     48  CB  LEU A  14      10.695  10.432  26.479  1.00 16.92           C  
ATOM     49  CG  LEU A  14      10.900  11.889  26.811  1.00 17.96           C  
ATOM     50  CD1 LEU A  14      11.766  12.562  25.807  1.00 16.62           C  
ATOM     51  CD2 LEU A  14       9.605  12.549  26.911  1.00 17.70           C  
ATOM     52  N   LYS A  15      12.100   9.155  29.022  1.00 17.68           N  
ATOM     53  CA  LYS A  15      12.814   9.194  30.310  1.00 17.15           C  
ATOM     54  C   LYS A  15      14.196   8.505  30.227  1.00 17.03           C  
ATOM     55  O   LYS A  15      15.168   8.997  30.827  1.00 17.18           O  
ATOM     56  CB  LYS A  15      11.958   8.646  31.446  1.00 17.22           C  
ATOM     57  CG  LYS A  15      10.869   9.632  31.944  1.00 18.99           C  
ATOM     58  N   ARG A  16      14.301   7.401  29.484  1.00 13.71           N  
ATOM     59  CA  ARG A  16      15.607   6.787  29.216  1.00 13.62           C  
ATOM     60  C   ARG A  16      16.574   7.738  28.475  1.00 14.96           C  
ATOM     61  O   ARG A  16      17.773   7.803  28.812  1.00 14.46           O  
ATOM     62  CB  ARG A  16      15.460   5.457  28.455  1.00 12.93           C  
ATOM     63  CG  ARG A  16      15.037   4.273  29.310  1.00 15.03           C  
ATOM     64  CD  ARG A  16      14.910   3.034  28.460  1.00 16.38           C  
ATOM     65  NE  ARG A  16      14.262   1.935  29.165  1.00 19.60           N  
ATOM     66  CZ  ARG A  16      14.828   0.751  29.428  1.00 20.21           C  
ATOM     67  NH1 ARG A  16      14.133  -0.199  30.068  1.00 17.82           N  
ATOM     68  NH2 ARG A  16      16.087   0.513  29.050  1.00 21.04           N  
ATOM     69  N   LEU A  17      16.072   8.460  27.477  1.00 14.56           N  
ATOM     70  CA  LEU A  17      16.900   9.349  26.680  1.00 15.72           C  
ATOM     71  C   LEU A  17      17.406  10.493  27.566  1.00 16.09           C  
ATOM     72  O   LEU A  17      18.552  10.941  27.447  1.00 15.80           O  
ATOM     73  CB  LEU A  17      16.083   9.917  25.507  1.00 15.61           C  
ATOM     74  CG  LEU A  17      16.077   9.142  24.214  1.00 16.86           C  
ATOM     75  CD1 LEU A  17      14.921   9.598  23.353  1.00 19.72           C  
ATOM     76  CD2 LEU A  17      17.435   9.351  23.491  1.00 16.16           C  
ATOM     77  N   GLU A  18      16.540  10.967  28.456  1.00 15.46           N  
ATOM     78  CA  GLU A  18      16.923  12.007  29.406  1.00 15.30           C  
ATOM     79  C   GLU A  18      18.057  11.580  30.343  1.00 16.37           C  
ATOM     80  O   GLU A  18      19.017  12.363  30.520  1.00 15.82           O  
ATOM     81  CB  GLU A  18      15.670  12.581  30.103  1.00 15.92           C  
ATOM     82  CG  GLU A  18      14.739  13.110  28.980  1.00 16.65           C  
ATOM     83  CD  GLU A  18      13.555  13.892  29.439  1.00 18.37           C  
ATOM     84  OE1 GLU A  18      12.789  13.366  30.280  1.00 17.36           O  
ATOM     85  OE2 GLU A  18      13.370  15.021  28.919  1.00 19.45           O  
ATOM     86  N   ALA A  19      17.984  10.344  30.859  1.00 14.98           N  
ATOM     87  CA  ALA A  19      18.994   9.745  31.729  1.00 15.16           C  
ATOM     88  C   ALA A  19      20.323   9.474  31.023  1.00 15.93           C  
ATOM     89  O   ALA A  19      21.390   9.770  31.572  1.00 17.57           O  
ATOM     90  CB  ALA A  19      18.445   8.424  32.378  1.00 13.99           C  
ATOM     91  N   SER A  20      20.282   8.883  29.829  1.00 16.96           N  
ATOM     92  CA  SER A  20      21.502   8.519  29.126  1.00 15.88           C  
ATOM     93  C   SER A  20      22.253   9.797  28.694  1.00 16.84           C  
ATOM     94  O   SER A  20      23.476   9.810  28.637  1.00 15.25           O  
ATOM     95  CB  SER A  20      21.221   7.549  27.947  1.00 16.51           C  
ATOM     96  OG  SER A  20      20.271   8.080  27.013  1.00 14.88           O  
ATOM     97  N   ARG A  21      21.515  10.867  28.403  1.00 17.26           N  
ATOM     98  CA  ARG A  21      22.123  12.138  28.069  1.00 16.96           C  
ATOM     99  C   ARG A  21      22.860  12.772  29.250  1.00 16.21           C  
ATOM    100  O   ARG A  21      23.991  13.262  29.089  1.00 17.30           O  
ATOM    101  CB  ARG A  21      21.118  13.105  27.420  1.00 16.80           C  
ATOM    102  CG  ARG A  21      21.704  14.492  27.062  1.00 15.15           C  
ATOM    103  CD  ARG A  21      22.956  14.385  26.140  1.00 14.46           C  
ATOM    104  NE  ARG A  21      22.692  13.633  24.909  1.00 14.49           N  
ATOM    105  CZ  ARG A  21      22.445  14.204  23.738  1.00 13.75           C  
ATOM    106  NH1 ARG A  21      22.434  15.539  23.641  1.00 13.43           N  
ATOM    107  NH2 ARG A  21      22.217  13.449  22.659  1.00 14.32           N  
ATOM    108  N   LYS A  22      22.258  12.759  30.432  1.00 19.36           N  
ATOM    109  CA  LYS A  22      22.986  13.198  31.626  1.00 19.26           C  
ATOM    110  C   LYS A  22      24.302  12.396  31.796  1.00 19.61           C  
ATOM    111  O   LYS A  22      25.356  12.962  32.055  1.00 19.24           O  
ATOM    112  CB  LYS A  22      22.095  13.084  32.869  1.00 19.20           C  
ATOM    113  CG  LYS A  22      20.828  13.921  32.761  1.00 19.10           C  
ATOM    114  CD  LYS A  22      19.844  13.681  33.892  1.00 20.46           C  
ATOM    115  CE  LYS A  22      18.602  14.554  33.739  1.00 19.07           C  
ATOM    116  NZ  LYS A  22      17.478  14.017  34.551  1.00 20.33           N  
ATOM    117  N   ALA A  23      24.213  11.073  31.638  1.00 20.46           N  
ATOM    118  CA  ALA A  23      25.351  10.164  31.786  1.00 20.65           C  
ATOM    119  C   ALA A  23      26.433  10.498  30.737  1.00 20.75           C  
ATOM    120  O   ALA A  23      27.613  10.609  31.056  1.00 20.62           O  
ATOM    121  CB  ALA A  23      24.878   8.706  31.683  1.00 20.79           C  
ATOM    122  N   LEU A  24      26.017  10.677  29.485  1.00 20.63           N  
ATOM    123  CA  LEU A  24      26.946  11.021  28.412  1.00 20.88           C  
ATOM    124  C   LEU A  24      27.637  12.363  28.651  1.00 20.04           C  
ATOM    125  O   LEU A  24      28.853  12.470  28.490  1.00 20.76           O  
ATOM    126  CB  LEU A  24      26.222  11.047  27.032  1.00 20.00           C  
ATOM    127  CG  LEU A  24      27.116  11.513  25.860  1.00 20.35           C  
ATOM    128  CD1 LEU A  24      28.301  10.568  25.682  1.00 22.33           C  
ATOM    129  CD2 LEU A  24      26.324  11.584  24.542  1.00 21.90           C  
ATOM    130  N   LEU A  25      26.860  13.399  28.961  1.00 20.26           N  
ATOM    131  CA  LEU A  25      27.451  14.731  29.132  1.00 20.12           C  
ATOM    132  C   LEU A  25      28.469  14.744  30.264  1.00 20.22           C  
ATOM    133  O   LEU A  25      29.523  15.380  30.128  1.00 20.82           O  
ATOM    134  CB  LEU A  25      26.391  15.802  29.364  1.00 19.18           C  
ATOM    135  CG  LEU A  25      25.438  16.082  28.215  1.00 19.46           C  
ATOM    136  CD1 LEU A  25      24.478  17.184  28.644  1.00 18.70           C  
ATOM    137  CD2 LEU A  25      26.191  16.474  26.949  1.00 19.67           C  
ATOM    138  N   ALA A  26      28.166  14.023  31.357  1.00 20.32           N  
ATOM    139  CA  ALA A  26      29.064  13.960  32.537  1.00 19.94           C  
ATOM    140  C   ALA A  26      30.378  13.208  32.214  1.00 20.36           C  
ATOM    141  O   ALA A  26      31.476  13.653  32.572  1.00 19.13           O  
ATOM    142  CB  ALA A  26      28.334  13.312  33.729  1.00 20.23           C  
ATOM    143  N   LEU A  27      30.246  12.071  31.535  1.00 20.52           N  
ATOM    144  CA  LEU A  27      31.386  11.325  31.012  1.00 20.90           C  
ATOM    145  C   LEU A  27      32.302  12.210  30.160  1.00 20.33           C  
ATOM    146  O   LEU A  27      33.534  12.239  30.384  1.00 19.65           O  
ATOM    147  CB  LEU A  27      30.907  10.097  30.221  1.00 20.92           C  
ATOM    148  CG  LEU A  27      31.994   9.241  29.579  1.00 21.60           C  
ATOM    149  CD1 LEU A  27      31.535   7.772  29.335  1.00 20.01           C  
ATOM    150  CD2 LEU A  27      32.501   9.884  28.272  1.00 21.43           C  
ATOM    151  N   LEU A  28      31.720  12.944  29.196  1.00 19.40           N  
ATOM    152  CA  LEU A  28      32.549  13.821  28.336  1.00 19.40           C  
ATOM    153  C   LEU A  28      33.256  14.937  29.125  1.00 18.56           C  
ATOM    154  O   LEU A  28      34.444  15.197  28.895  1.00 18.48           O  
ATOM    155  CB  LEU A  28      31.737  14.429  27.201  1.00 19.23           C  
ATOM    156  CG  LEU A  28      31.151  13.460  26.159  1.00 18.48           C  
ATOM    157  CD1 LEU A  28      30.097  14.190  25.311  1.00 18.00           C  
ATOM    158  CD2 LEU A  28      32.254  12.817  25.284  1.00 20.33           C  
ATOM    159  N   ARG A  29      32.518  15.598  30.023  1.00 31.15           N  
ATOM    160  CA  ARG A  29      33.037  16.718  30.815  1.00 31.00           C  
ATOM    161  C   ARG A  29      34.081  16.299  31.857  1.00 30.99           C  
ATOM    162  O   ARG A  29      34.904  17.104  32.264  1.00 29.85           O  
ATOM    163  CB  ARG A  29      31.900  17.465  31.510  1.00 30.26           C  
ATOM    164  CG  ARG A  29      31.117  18.386  30.608  1.00 30.45           C  
ATOM    165  CD  ARG A  29      29.828  18.828  31.292  1.00 32.41           C  
ATOM    166  NE  ARG A  29      28.991  19.655  30.421  1.00 33.32           N  
ATOM    167  CZ  ARG A  29      27.658  19.696  30.456  1.00 32.82           C  
ATOM    168  NH1 ARG A  29      26.972  18.947  31.321  1.00 31.67           N  
ATOM    169  NH2 ARG A  29      27.003  20.479  29.611  1.00 32.94           N  
ATOM    170  N   GLU A  30      34.033  15.047  32.299  1.00 31.70           N  
ATOM    171  CA  GLU A  30      34.954  14.567  33.326  1.00 31.59           C  
ATOM    172  C   GLU A  30      36.147  13.812  32.743  1.00 31.19           C  
ATOM    173  O   GLU A  30      37.118  13.565  33.440  1.00 29.73           O  
ATOM    174  CB  GLU A  30      34.207  13.725  34.366  1.00 30.75           C  
ATOM    175  CG  GLU A  30      33.130  14.517  35.104  1.00 32.75           C  
ATOM    176  CD  GLU A  30      32.166  13.646  35.908  1.00 34.25           C  
ATOM    177  OE1 GLU A  30      32.421  12.437  36.064  1.00 36.72           O  
ATOM    178  OE2 GLU A  30      31.148  14.174  36.392  1.00 34.66           O  
ATOM    179  N   ALA A  31      36.074  13.466  31.458  1.00 31.98           N  
ATOM    180  CA  ALA A  31      37.140  12.720  30.786  1.00 32.20           C  
ATOM    181  C   ALA A  31      38.429  13.520  30.659  1.00 32.60           C  
ATOM    182  O   ALA A  31      38.411  14.733  30.454  1.00 32.15           O  
ATOM    183  CB  ALA A  31      36.692  12.270  29.394  1.00 32.61           C  
ATOM    184  N   ASP A  32      39.542  12.803  30.752  1.00 32.86           N  
ATOM    185  CA  ASP A  32      40.845  13.339  30.428  1.00 33.30           C  
ATOM    186  C   ASP A  32      40.846  13.779  28.955  1.00 33.40           C  
ATOM    187  O   ASP A  32      40.468  12.987  28.079  1.00 32.45           O  
ATOM    188  CB  ASP A  32      41.896  12.255  30.704  1.00 32.88           C  
ATOM    189  CG  ASP A  32      43.272  12.613  30.186  1.00 33.21           C  
ATOM    190  OD1 ASP A  32      43.608  13.809  30.121  1.00 36.71           O  
ATOM    191  OD2 ASP A  32      44.029  11.682  29.855  1.00 34.52           O  
ATOM    192  N   PRO A  33      41.237  15.051  28.682  1.00 33.29           N  
ATOM    193  CA  PRO A  33      41.351  15.608  27.319  1.00 32.74           C  
ATOM    194  C   PRO A  33      42.068  14.704  26.292  1.00 31.67           C  
ATOM    195  O   PRO A  33      41.660  14.646  25.129  1.00 31.18           O  
ATOM    196  CB  PRO A  33      42.154  16.897  27.540  1.00 32.41           C  
ATOM    197  CG  PRO A  33      41.798  17.321  28.922  1.00 32.90           C  
ATOM    198  CD  PRO A  33      41.569  16.060  29.709  1.00 33.16           C  
ATOM    199  N   ALA A  34      43.130  14.026  26.725  1.00 29.19           N  
ATOM    200  CA  ALA A  34      43.927  13.156  25.857  1.00 29.41           C  
ATOM    201  C   ALA A  34      43.119  11.940  25.396  1.00 28.89           C  
ATOM    202  O   ALA A  34      43.260  11.503  24.275  1.00 28.78           O  
ATOM    203  N   TRP A  35      42.284  11.404  26.282  1.00 28.73           N  
ATOM    204  CA  TRP A  35      41.406  10.269  25.975  1.00 28.92           C  
ATOM    205  C   TRP A  35      40.274  10.616  25.003  1.00 29.01           C  
ATOM    206  O   TRP A  35      39.878   9.778  24.174  1.00 30.49           O  
ATOM    207  CB  TRP A  35      40.836   9.673  27.271  1.00 29.11           C  
ATOM    208  CG  TRP A  35      39.885   8.535  27.059  1.00 29.31           C  
ATOM    209  CD1 TRP A  35      40.198   7.206  26.918  1.00 28.92           C  
ATOM    210  CD2 TRP A  35      38.462   8.622  26.972  1.00 29.18           C  
ATOM    211  NE1 TRP A  35      39.046   6.462  26.739  1.00 27.30           N  
ATOM    212  CE2 TRP A  35      37.970   7.310  26.765  1.00 28.36           C  
ATOM    213  CE3 TRP A  35      37.551   9.683  27.026  1.00 29.60           C  
ATOM    214  CZ2 TRP A  35      36.614   7.039  26.635  1.00 27.80           C  
ATOM    215  CZ3 TRP A  35      36.204   9.402  26.893  1.00 28.57           C  
ATOM    216  CH2 TRP A  35      35.752   8.093  26.706  1.00 26.64           C  
ATOM    217  N   LEU A  36      39.742  11.834  25.125  1.00 28.55           N  
ATOM    218  CA  LEU A  36      38.668  12.347  24.259  1.00 27.62           C  
ATOM    219  C   LEU A  36      39.010  12.327  22.774  1.00 27.05           C  
ATOM    220  O   LEU A  36      38.146  12.065  21.927  1.00 25.10           O  
ATOM    221  CB  LEU A  36      38.285  13.774  24.669  1.00 27.50           C  
ATOM    222  CG  LEU A  36      37.427  13.944  25.932  1.00 27.62           C  
ATOM    223  CD1 LEU A  36      37.110  15.432  26.105  1.00 29.21           C  
ATOM    224  CD2 LEU A  36      36.137  13.117  25.875  1.00 27.51           C  
ATOM    225  N   SER A  37      40.275  12.629  22.489  1.00 26.95           N  
ATOM    226  CA  SER A  37      40.824  12.707  21.143  1.00 27.61           C  
ATOM    227  C   SER A  37      41.648  11.487  20.737  1.00 27.14           C  
ATOM    228  O   SER A  37      42.271  11.509  19.693  1.00 27.08           O  
ATOM    229  CB  SER A  37      41.715  13.950  21.028  1.00 27.27           C  
ATOM    230  OG  SER A  37      40.947  15.121  21.163  1.00 29.43           O  
ATOM    231  N   ALA A  38      41.663  10.439  21.555  1.00 27.67           N  
ATOM    232  CA  ALA A  38      42.371   9.197  21.221  1.00 27.84           C  
ATOM    233  C   ALA A  38      41.427   8.157  20.597  1.00 28.04           C  
ATOM    234  O   ALA A  38      40.280   8.042  21.021  1.00 28.26           O  
ATOM    235  CB  ALA A  38      43.080   8.614  22.470  1.00 27.99           C  
ATOM    236  N   PRO A  39      41.906   7.400  19.586  1.00 28.37           N  
ATOM    237  CA  PRO A  39      41.133   6.278  19.036  1.00 28.10           C  
ATOM    238  C   PRO A  39      40.761   5.271  20.140  1.00 28.19           C  
ATOM    239  O   PRO A  39      41.600   4.965  20.990  1.00 27.30           O  
ATOM    240  CB  PRO A  39      42.112   5.627  18.048  1.00 27.83           C  
ATOM    241  CG  PRO A  39      43.068   6.702  17.683  1.00 28.42           C  
ATOM    242  CD  PRO A  39      43.209   7.560  18.903  1.00 27.80           C  
ATOM    243  N   LEU A  40      39.526   4.768  20.133  1.00 27.90           N  
ATOM    244  CA  LEU A  40      39.102   3.776  21.134  1.00 28.74           C  
ATOM    245  C   LEU A  40      39.930   2.477  21.078  1.00 28.53           C  
ATOM    246  O   LEU A  40      40.153   1.840  22.107  1.00 28.64           O  
ATOM    247  CB  LEU A  40      37.605   3.471  21.029  1.00 28.40           C  
ATOM    248  CG  LEU A  40      36.630   4.640  21.225  1.00 29.62           C  
ATOM    249  CD1 LEU A  40      35.215   4.203  20.861  1.00 31.22           C  
ATOM    250  CD2 LEU A  40      36.685   5.207  22.632  1.00 29.65           C  
ATOM    251  N   ARG A  41      40.349   2.102  19.870  1.00 29.06           N  
ATOM    252  CA  ARG A  41      41.305   1.018  19.611  1.00 29.13           C  
ATOM    253  C   ARG A  41      41.961   1.315  18.247  1.00 29.67           C  
ATOM    254  O   ARG A  41      41.707   2.366  17.648  1.00 30.09           O  
ATOM    255  N   GLU A  42      42.804   0.397  17.762  1.00 20.86           N  
ATOM    256  CA  GLU A  42      43.477   0.548  16.458  1.00 20.52           C  
ATOM    257  C   GLU A  42      42.474   0.784  15.314  1.00 20.73           C  
ATOM    258  O   GLU A  42      41.536   0.004  15.128  1.00 20.83           O  
ATOM    259  N   GLY A  43      42.669   1.872  14.572  1.00 20.66           N  
ATOM    260  CA  GLY A  43      41.814   2.230  13.438  1.00 20.36           C  
ATOM    261  C   GLY A  43      40.457   2.785  13.856  1.00 20.63           C  
ATOM    262  O   GLY A  43      39.655   3.154  13.015  1.00 20.76           O  
ATOM    263  N   ALA A  44      40.197   2.868  15.155  1.00 20.24           N  
ATOM    264  CA  ALA A  44      38.862   3.280  15.612  1.00 20.33           C  
ATOM    265  C   ALA A  44      38.677   4.803  15.690  1.00 20.14           C  
ATOM    266  O   ALA A  44      39.624   5.564  15.812  1.00 19.81           O  
ATOM    267  CB  ALA A  44      38.494   2.588  16.961  1.00 19.93           C  
ATOM    268  N   TRP A  45      37.426   5.232  15.648  1.00 19.71           N  
ATOM    269  CA  TRP A  45      37.098   6.626  15.896  1.00 19.73           C  
ATOM    270  C   TRP A  45      37.337   6.992  17.377  1.00 19.50           C  
ATOM    271  O   TRP A  45      37.569   6.109  18.217  1.00 18.15           O  
ATOM    272  CB  TRP A  45      35.644   6.868  15.461  1.00 18.95           C  
ATOM    273  CG  TRP A  45      34.579   6.093  16.155  1.00 19.44           C  
ATOM    274  CD1 TRP A  45      34.718   5.069  17.069  1.00 19.19           C  
ATOM    275  CD2 TRP A  45      33.174   6.272  15.969  1.00 19.18           C  
ATOM    276  NE1 TRP A  45      33.477   4.631  17.475  1.00 20.52           N  
ATOM    277  CE2 TRP A  45      32.514   5.348  16.813  1.00 19.05           C  
ATOM    278  CE3 TRP A  45      32.407   7.128  15.163  1.00 20.27           C  
ATOM    279  CZ2 TRP A  45      31.103   5.260  16.885  1.00 23.27           C  
ATOM    280  CZ3 TRP A  45      30.992   7.055  15.248  1.00 19.76           C  
ATOM    281  CH2 TRP A  45      30.370   6.127  16.105  1.00 21.63           C  
ATOM    282  N   THR A  46      37.255   8.290  17.697  1.00 20.73           N  
ATOM    283  CA  THR A  46      37.484   8.787  19.068  1.00 20.19           C  
ATOM    284  C   THR A  46      36.164   8.993  19.819  1.00 20.11           C  
ATOM    285  O   THR A  46      35.125   8.973  19.197  1.00 18.98           O  
ATOM    286  CB  THR A  46      38.197  10.124  19.042  1.00 20.65           C  
ATOM    287  OG1 THR A  46      37.276  11.089  18.530  1.00 19.61           O  
ATOM    288  CG2 THR A  46      39.509  10.054  18.168  1.00 21.35           C  
ATOM    289  N   PRO A  47      36.202   9.145  21.175  1.00 19.70           N  
ATOM    290  CA  PRO A  47      34.997   9.486  21.948  1.00 19.04           C  
ATOM    291  C   PRO A  47      34.262  10.726  21.452  1.00 20.17           C  
ATOM    292  O   PRO A  47      33.043  10.755  21.452  1.00 19.60           O  
ATOM    293  CB  PRO A  47      35.536   9.726  23.349  1.00 19.12           C  
ATOM    294  CG  PRO A  47      36.730   8.830  23.435  1.00 18.87           C  
ATOM    295  CD  PRO A  47      37.361   8.906  22.061  1.00 19.81           C  
ATOM    296  N   LEU A  48      34.997  11.753  21.032  1.00 20.53           N  
ATOM    297  CA  LEU A  48      34.352  12.937  20.462  1.00 20.15           C  
ATOM    298  C   LEU A  48      33.607  12.691  19.125  1.00 19.69           C  
ATOM    299  O   LEU A  48      32.610  13.330  18.841  1.00 19.50           O  
ATOM    300  CB  LEU A  48      35.381  14.069  20.313  1.00 19.91           C  
ATOM    301  CG  LEU A  48      35.849  14.675  21.636  1.00 20.02           C  
ATOM    302  CD1 LEU A  48      37.100  15.556  21.406  1.00 20.84           C  
ATOM    303  CD2 LEU A  48      34.713  15.468  22.331  1.00 19.74           C  
ATOM    304  N   MET A  49      34.125  11.794  18.302  1.00 20.01           N  
ATOM    305  CA  MET A  49      33.437  11.368  17.071  1.00 20.35           C  
ATOM    306  C   MET A  49      32.206  10.558  17.434  1.00 19.71           C  
ATOM    307  O   MET A  49      31.164  10.715  16.814  1.00 18.84           O  
ATOM    308  CB  MET A  49      34.374  10.543  16.203  1.00 21.01           C  
ATOM    309  CG  MET A  49      35.531  11.337  15.618  1.00 21.52           C  
ATOM    310  SD  MET A  49      36.866  10.421  14.797  1.00 12.60           S  
ATOM    311  CE  MET A  49      38.136  11.585  15.183  1.00 21.10           C  
ATOM    312  N   VAL A  50      32.316   9.707  18.460  1.00 16.83           N  
ATOM    313  CA  VAL A  50      31.157   8.957  18.893  1.00 17.71           C  
ATOM    314  C   VAL A  50      30.051   9.958  19.277  1.00 17.71           C  
ATOM    315  O   VAL A  50      28.921   9.821  18.844  1.00 19.47           O  
ATOM    316  CB  VAL A  50      31.476   8.029  20.103  1.00 17.86           C  
ATOM    317  CG1 VAL A  50      30.205   7.402  20.648  1.00 17.04           C  
ATOM    318  CG2 VAL A  50      32.494   6.949  19.701  1.00 18.44           C  
ATOM    319  N   ALA A  51      30.390  10.945  20.103  1.00 17.81           N  
ATOM    320  CA  ALA A  51      29.411  11.940  20.586  1.00 18.31           C  
ATOM    321  C   ALA A  51      28.775  12.738  19.432  1.00 17.92           C  
ATOM    322  O   ALA A  51      27.580  12.966  19.423  1.00 17.31           O  
ATOM    323  CB  ALA A  51      30.068  12.881  21.605  1.00 17.59           C  
ATOM    324  N   GLU A  52      29.591  13.170  18.469  1.00 17.92           N  
ATOM    325  CA  GLU A  52      29.083  13.859  17.274  1.00 18.22           C  
ATOM    326  C   GLU A  52      28.110  12.949  16.516  1.00 18.75           C  
ATOM    327  O   GLU A  52      27.042  13.409  16.087  1.00 17.94           O  
ATOM    328  CB  GLU A  52      30.250  14.335  16.375  1.00 18.46           C  
ATOM    329  CG  GLU A  52      29.810  14.678  14.985  1.00 19.89           C  
ATOM    330  CD  GLU A  52      30.929  14.800  13.968  1.00 19.37           C  
ATOM    331  OE1 GLU A  52      32.050  14.260  14.171  1.00 18.68           O  
ATOM    332  OE2 GLU A  52      30.669  15.452  12.928  1.00 19.10           O  
ATOM    333  N   HIS A  53      28.437  11.656  16.412  1.00 18.22           N  
ATOM    334  CA  HIS A  53      27.531  10.669  15.799  1.00 18.13           C  
ATOM    335  C   HIS A  53      26.163  10.602  16.499  1.00 18.50           C  
ATOM    336  O   HIS A  53      25.132  10.625  15.854  1.00 17.44           O  
ATOM    337  CB  HIS A  53      28.175   9.275  15.806  1.00 18.36           C  
ATOM    338  CG  HIS A  53      27.287   8.187  15.262  1.00 17.00           C  
ATOM    339  ND1 HIS A  53      26.934   8.102  13.934  1.00 17.64           N  
ATOM    340  CD2 HIS A  53      26.687   7.140  15.877  1.00 15.37           C  
ATOM    341  CE1 HIS A  53      26.133   7.064  13.754  1.00 18.05           C  
ATOM    342  NE2 HIS A  53      25.983   6.452  14.919  1.00 17.36           N  
ATOM    343  N   VAL A  54      26.177  10.505  17.823  1.00 18.58           N  
ATOM    344  CA  VAL A  54      24.972  10.546  18.607  1.00 18.68           C  
ATOM    345  C   VAL A  54      24.114  11.792  18.277  1.00 19.09           C  
ATOM    346  O   VAL A  54      22.908  11.664  18.059  1.00 18.74           O  
ATOM    347  CB  VAL A  54      25.291  10.476  20.142  1.00 18.12           C  
ATOM    348  CG1 VAL A  54      24.059  10.890  20.976  1.00 17.88           C  
ATOM    349  CG2 VAL A  54      25.800   9.049  20.513  1.00 18.61           C  
ATOM    350  N   ALA A  55      24.730  12.982  18.303  1.00 18.82           N  
ATOM    351  CA  ALA A  55      24.071  14.215  17.940  1.00 18.34           C  
ATOM    352  C   ALA A  55      23.471  14.166  16.514  1.00 19.02           C  
ATOM    353  O   ALA A  55      22.321  14.588  16.309  1.00 16.05           O  
ATOM    354  CB  ALA A  55      25.049  15.408  18.078  1.00 18.55           C  
ATOM    355  N   LEU A  56      24.230  13.690  15.524  1.00 18.13           N  
ATOM    356  CA  LEU A  56      23.709  13.702  14.119  1.00 17.85           C  
ATOM    357  C   LEU A  56      22.468  12.765  14.010  1.00 17.96           C  
ATOM    358  O   LEU A  56      21.459  13.097  13.347  1.00 16.43           O  
ATOM    359  CB  LEU A  56      24.792  13.309  13.113  1.00 17.01           C  
ATOM    360  CG  LEU A  56      25.960  14.309  13.088  1.00 18.87           C  
ATOM    361  CD1 LEU A  56      27.145  13.839  12.186  1.00 20.85           C  
ATOM    362  CD2 LEU A  56      25.460  15.718  12.692  1.00 20.83           C  
ATOM    363  N   VAL A  57      22.530  11.626  14.689  1.00 17.54           N  
ATOM    364  CA  VAL A  57      21.426  10.684  14.628  1.00 17.45           C  
ATOM    365  C   VAL A  57      20.183  11.280  15.312  1.00 18.01           C  
ATOM    366  O   VAL A  57      19.059  11.051  14.844  1.00 18.82           O  
ATOM    367  CB  VAL A  57      21.822   9.290  15.171  1.00 18.59           C  
ATOM    368  CG1 VAL A  57      20.586   8.373  15.339  1.00 16.90           C  
ATOM    369  CG2 VAL A  57      22.893   8.619  14.222  1.00 18.32           C  
ATOM    370  N   GLU A  58      20.356  12.040  16.387  1.00 17.58           N  
ATOM    371  CA  GLU A  58      19.196  12.685  17.031  1.00 18.61           C  
ATOM    372  C   GLU A  58      18.624  13.777  16.145  1.00 18.82           C  
ATOM    373  O   GLU A  58      17.431  13.955  16.078  1.00 18.89           O  
ATOM    374  CB  GLU A  58      19.564  13.339  18.355  1.00 19.11           C  
ATOM    375  CG  GLU A  58      20.012  12.336  19.377  1.00 21.10           C  
ATOM    376  CD  GLU A  58      19.627  12.669  20.810  1.00 20.15           C  
ATOM    377  OE1 GLU A  58      19.373  13.858  21.154  1.00 17.58           O  
ATOM    378  OE2 GLU A  58      19.621  11.707  21.596  1.00 18.35           O  
ATOM    379  N   ASP A  59      19.495  14.496  15.446  1.00 18.24           N  
ATOM    380  CA  ASP A  59      19.024  15.498  14.488  1.00 19.06           C  
ATOM    381  C   ASP A  59      18.190  14.851  13.380  1.00 19.43           C  
ATOM    382  O   ASP A  59      17.104  15.301  13.065  1.00 17.93           O  
ATOM    383  CB  ASP A  59      20.191  16.298  13.907  1.00 17.44           C  
ATOM    384  CG  ASP A  59      19.733  17.326  12.904  1.00 19.72           C  
ATOM    385  OD1 ASP A  59      19.392  18.443  13.330  1.00 18.84           O  
ATOM    386  OD2 ASP A  59      19.698  17.022  11.691  1.00 18.69           O  
ATOM    387  N   SER A  60      18.724  13.769  12.829  1.00 19.41           N  
ATOM    388  CA  SER A  60      18.119  13.023  11.749  1.00 19.86           C  
ATOM    389  C   SER A  60      16.745  12.460  12.225  1.00 19.34           C  
ATOM    390  O   SER A  60      15.687  12.628  11.539  1.00 17.87           O  
ATOM    391  CB  SER A  60      19.110  11.922  11.384  1.00 19.28           C  
ATOM    392  OG  SER A  60      18.606  11.154  10.348  1.00 24.23           O  
ATOM    393  N   THR A  61      16.740  11.877  13.427  1.00 18.52           N  
ATOM    394  CA  THR A  61      15.486  11.353  14.048  1.00 19.03           C  
ATOM    395  C   THR A  61      14.420  12.420  14.165  1.00 19.76           C  
ATOM    396  O   THR A  61      13.225  12.208  13.832  1.00 19.66           O  
ATOM    397  CB  THR A  61      15.770  10.788  15.455  1.00 18.51           C  
ATOM    398  OG1 THR A  61      16.733   9.731  15.330  1.00 17.17           O  
ATOM    399  CG2 THR A  61      14.456  10.234  16.109  1.00 18.13           C  
ATOM    400  N   ALA A  62      14.849  13.589  14.638  1.00 20.08           N  
ATOM    401  CA  ALA A  62      13.937  14.737  14.770  1.00 18.86           C  
ATOM    402  C   ALA A  62      13.315  15.121  13.422  1.00 19.33           C  
ATOM    403  O   ALA A  62      12.126  15.419  13.344  1.00 17.51           O  
ATOM    404  CB  ALA A  62      14.658  15.897  15.374  1.00 18.98           C  
ATOM    405  N   ARG A  63      14.104  15.107  12.348  1.00 18.31           N  
ATOM    406  CA  ARG A  63      13.552  15.392  11.011  1.00 18.27           C  
ATOM    407  C   ARG A  63      12.585  14.301  10.528  1.00 17.72           C  
ATOM    408  O   ARG A  63      11.625  14.588   9.825  1.00 17.50           O  
ATOM    409  CB  ARG A  63      14.687  15.555   9.991  1.00 16.98           C  
ATOM    410  CG  ARG A  63      15.641  16.672  10.365  1.00 17.90           C  
ATOM    411  CD  ARG A  63      16.773  16.884   9.334  1.00 17.49           C  
ATOM    412  NE  ARG A  63      17.789  17.701   9.975  1.00 19.95           N  
ATOM    413  CZ  ARG A  63      17.713  19.024  10.086  1.00 21.73           C  
ATOM    414  NH1 ARG A  63      16.712  19.688   9.521  1.00 25.33           N  
ATOM    415  NH2 ARG A  63      18.665  19.696  10.722  1.00 23.25           N  
ATOM    416  N   VAL A  64      12.857  13.046  10.875  1.00 13.77           N  
ATOM    417  CA  VAL A  64      11.941  11.941  10.529  1.00 14.73           C  
ATOM    418  C   VAL A  64      10.633  12.169  11.239  1.00 15.42           C  
ATOM    419  O   VAL A  64       9.548  12.067  10.626  1.00 15.01           O  
ATOM    420  CB  VAL A  64      12.536  10.539  10.893  1.00 15.03           C  
ATOM    421  CG1 VAL A  64      11.435   9.451  10.793  1.00 16.78           C  
ATOM    422  CG2 VAL A  64      13.748  10.203   9.980  1.00 14.12           C  
ATOM    423  N   LEU A  65      10.713  12.500  12.540  1.00 16.25           N  
ATOM    424  CA  LEU A  65       9.491  12.767  13.291  1.00 15.75           C  
ATOM    425  C   LEU A  65       8.735  13.923  12.687  1.00 15.70           C  
ATOM    426  O   LEU A  65       7.499  13.905  12.648  1.00 17.37           O  
ATOM    427  CB  LEU A  65       9.801  13.049  14.769  1.00 17.12           C  
ATOM    428  CG  LEU A  65      10.356  11.857  15.606  1.00 14.56           C  
ATOM    429  CD1 LEU A  65      10.683  12.236  17.069  1.00 16.31           C  
ATOM    430  CD2 LEU A  65       9.387  10.707  15.571  1.00 14.73           C  
ATOM    431  N   ARG A  66       9.435  14.968  12.264  1.00 15.10           N  
ATOM    432  CA  ARG A  66       8.756  16.099  11.626  1.00 15.18           C  
ATOM    433  C   ARG A  66       8.065  15.648  10.338  1.00 14.93           C  
ATOM    434  O   ARG A  66       6.955  16.055  10.069  1.00 14.15           O  
ATOM    435  CB  ARG A  66       9.738  17.227  11.334  1.00 14.41           C  
ATOM    436  CG  ARG A  66       9.107  18.502  10.705  1.00 14.21           C  
ATOM    437  CD  ARG A  66      10.158  19.624  10.559  1.00 13.74           C  
ATOM    438  NE  ARG A  66      11.242  19.187   9.681  1.00 15.32           N  
ATOM    439  CZ  ARG A  66      12.374  19.849   9.457  1.00 18.65           C  
ATOM    440  NH1 ARG A  66      12.609  21.010  10.039  1.00 18.99           N  
ATOM    441  NH2 ARG A  66      13.276  19.349   8.622  1.00 19.31           N  
ATOM    442  N   ARG A  67       8.729  14.848   9.519  1.00 14.42           N  
ATOM    443  CA  ARG A  67       8.050  14.333   8.287  1.00 15.09           C  
ATOM    444  C   ARG A  67       6.818  13.449   8.626  1.00 15.96           C  
ATOM    445  O   ARG A  67       5.736  13.591   8.024  1.00 15.63           O  
ATOM    446  CB  ARG A  67       9.038  13.535   7.452  1.00 15.07           C  
ATOM    447  CG  ARG A  67       8.615  13.302   6.012  1.00 14.95           C  
ATOM    448  CD  ARG A  67       9.623  12.349   5.295  1.00 16.42           C  
ATOM    449  NE  ARG A  67       9.358  12.462   3.841  1.00 16.72           N  
ATOM    450  CZ  ARG A  67       8.518  11.683   3.176  1.00 16.54           C  
ATOM    451  NH1 ARG A  67       7.894  10.694   3.803  1.00 18.40           N  
ATOM    452  NH2 ARG A  67       8.302  11.879   1.877  1.00 16.48           N  
ATOM    453  N   LEU A  68       6.954  12.585   9.632  1.00 14.93           N  
ATOM    454  CA  LEU A  68       5.828  11.711  10.018  1.00 15.51           C  
ATOM    455  C   LEU A  68       4.620  12.519  10.538  1.00 14.80           C  
ATOM    456  O   LEU A  68       3.457  12.130  10.327  1.00 14.34           O  
ATOM    457  CB  LEU A  68       6.292  10.662  11.041  1.00 14.76           C  
ATOM    458  CG  LEU A  68       7.188   9.590  10.373  1.00 16.21           C  
ATOM    459  CD1 LEU A  68       7.772   8.625  11.408  1.00 13.65           C  
ATOM    460  CD2 LEU A  68       6.397   8.813   9.281  1.00 15.77           C  
ATOM    461  N   ARG A  69       4.911  13.658  11.159  1.00  4.20           N  
ATOM    462  CA  ARG A  69       3.878  14.545  11.683  1.00  4.43           C  
ATOM    463  C   ARG A  69       3.176  15.226  10.520  1.00  4.14           C  
ATOM    464  O   ARG A  69       1.948  15.307  10.498  1.00  3.50           O  
ATOM    465  CB  ARG A  69       4.486  15.565  12.640  1.00  4.78           C  
ATOM    466  CG  ARG A  69       3.477  16.360  13.391  1.00  5.26           C  
ATOM    467  CD  ARG A  69       4.082  17.450  14.296  1.00  3.57           C  
ATOM    468  NE  ARG A  69       5.349  18.089  13.854  1.00  3.71           N  
ATOM    469  CZ  ARG A  69       5.440  19.301  13.293  1.00  4.50           C  
ATOM    470  NH1 ARG A  69       4.350  20.009  13.031  1.00  2.00           N  
ATOM    471  NH2 ARG A  69       6.626  19.837  12.992  1.00  5.69           N  
ATOM    472  N   ARG A  70       3.950  15.672   9.540  1.00  4.46           N  
ATOM    473  CA  ARG A  70       3.384  16.347   8.372  1.00  5.51           C  
ATOM    474  C   ARG A  70       2.524  15.402   7.530  1.00  5.46           C  
ATOM    475  O   ARG A  70       1.456  15.792   7.084  1.00  4.87           O  
ATOM    476  CB  ARG A  70       4.478  17.038   7.559  1.00  5.60           C  
ATOM    477  CG  ARG A  70       5.128  18.184   8.349  1.00  8.00           C  
ATOM    478  CD  ARG A  70       6.389  18.695   7.677  1.00 11.22           C  
ATOM    479  NE  ARG A  70       6.245  20.116   7.397  1.00 12.92           N  
ATOM    480  CZ  ARG A  70       5.892  20.628   6.222  1.00 12.93           C  
ATOM    481  NH1 ARG A  70       5.782  21.938   6.081  1.00 12.72           N  
ATOM    482  NH2 ARG A  70       5.661  19.841   5.180  1.00 14.15           N  
ATOM    483  N   LEU A  71       2.981  14.162   7.351  1.00  6.60           N  
ATOM    484  CA  LEU A  71       2.189  13.076   6.739  1.00  7.21           C  
ATOM    485  C   LEU A  71       0.890  12.738   7.502  1.00  7.86           C  
ATOM    486  O   LEU A  71      -0.098  12.307   6.894  1.00  7.62           O  
ATOM    487  CB  LEU A  71       3.044  11.805   6.588  1.00  7.10           C  
ATOM    488  CG  LEU A  71       4.278  11.798   5.660  1.00  7.55           C  
ATOM    489  CD1 LEU A  71       5.223  10.632   6.000  1.00  8.39           C  
ATOM    490  CD2 LEU A  71       3.932  11.767   4.168  1.00  7.01           C  
ATOM    491  N   ALA A  72       0.903  12.914   8.823  1.00  9.08           N  
ATOM    492  CA  ALA A  72      -0.308  12.806   9.655  1.00  9.42           C  
ATOM    493  C   ALA A  72      -1.254  13.973   9.341  1.00  9.27           C  
ATOM    494  O   ALA A  72      -2.471  13.786   9.235  1.00  9.22           O  
ATOM    495  N   LEU A 104      35.066  18.144  16.542  1.00 11.05           N  
ATOM    496  CA  LEU A 104      36.501  18.331  16.765  1.00 10.03           C  
ATOM    497  C   LEU A 104      36.877  18.636  18.228  1.00  9.36           C  
ATOM    498  O   LEU A 104      37.711  17.940  18.819  1.00  9.41           O  
ATOM    499  N   SER A 105      36.300  19.696  18.793  1.00  8.86           N  
ATOM    500  CA  SER A 105      36.595  20.092  20.170  1.00  7.99           C  
ATOM    501  C   SER A 105      35.424  19.729  21.062  1.00  7.86           C  
ATOM    502  O   SER A 105      34.304  19.485  20.568  1.00  8.94           O  
ATOM    503  CB  SER A 105      36.973  21.597  20.277  1.00  7.93           C  
ATOM    504  OG  SER A 105      35.895  22.499  19.881  1.00  9.93           O  
ATOM    505  N   LEU A 106      35.679  19.630  22.369  1.00 27.25           N  
ATOM    506  CA  LEU A 106      34.612  19.289  23.300  1.00 26.00           C  
ATOM    507  C   LEU A 106      33.498  20.330  23.210  1.00 25.88           C  
ATOM    508  O   LEU A 106      32.331  19.982  23.055  1.00 24.37           O  
ATOM    509  CB  LEU A 106      35.126  19.154  24.735  1.00 25.00           C  
ATOM    510  CG  LEU A 106      34.037  18.867  25.774  1.00 23.66           C  
ATOM    511  CD1 LEU A 106      33.324  17.524  25.512  1.00 20.41           C  
ATOM    512  CD2 LEU A 106      34.636  18.923  27.177  1.00 24.32           C  
ATOM    513  N   GLU A 107      33.888  21.605  23.284  1.00 24.94           N  
ATOM    514  CA  GLU A 107      32.960  22.717  23.141  1.00 24.92           C  
ATOM    515  C   GLU A 107      32.058  22.558  21.920  1.00 24.44           C  
ATOM    516  O   GLU A 107      30.848  22.736  22.027  1.00 24.26           O  
ATOM    517  N   GLU A 108      32.658  22.260  20.764  1.00 24.01           N  
ATOM    518  CA  GLU A 108      31.912  22.076  19.512  1.00 23.47           C  
ATOM    519  C   GLU A 108      30.932  20.884  19.628  1.00 22.70           C  
ATOM    520  O   GLU A 108      29.763  20.988  19.263  1.00 21.40           O  
ATOM    521  N   VAL A 109      31.429  19.750  20.119  1.00 22.87           N  
ATOM    522  CA  VAL A 109      30.612  18.522  20.258  1.00 23.31           C  
ATOM    523  C   VAL A 109      29.447  18.725  21.236  1.00 23.83           C  
ATOM    524  O   VAL A 109      28.326  18.305  20.941  1.00 24.37           O  
ATOM    525  CB  VAL A 109      31.472  17.294  20.671  1.00 23.31           C  
ATOM    526  CG1 VAL A 109      30.618  16.092  20.883  1.00 24.57           C  
ATOM    527  CG2 VAL A 109      32.541  16.989  19.595  1.00 23.29           C  
ATOM    528  N   LEU A 110      29.711  19.374  22.377  1.00 23.32           N  
ATOM    529  CA  LEU A 110      28.684  19.654  23.396  1.00 23.54           C  
ATOM    530  C   LEU A 110      27.578  20.545  22.847  1.00 23.25           C  
ATOM    531  O   LEU A 110      26.404  20.364  23.180  1.00 23.87           O  
ATOM    532  CB  LEU A 110      29.297  20.338  24.627  1.00 23.02           C  
ATOM    533  CG  LEU A 110      30.159  19.530  25.605  1.00 23.02           C  
ATOM    534  CD1 LEU A 110      30.561  20.413  26.767  1.00 24.19           C  
ATOM    535  CD2 LEU A 110      29.470  18.251  26.117  1.00 24.37           C  
ATOM    536  N   ALA A 111      27.968  21.510  22.018  1.00 22.85           N  
ATOM    537  CA  ALA A 111      27.030  22.436  21.400  1.00 22.87           C  
ATOM    538  C   ALA A 111      26.163  21.679  20.384  1.00 22.90           C  
ATOM    539  O   ALA A 111      24.960  21.907  20.300  1.00 21.06           O  
ATOM    540  CB  ALA A 111      27.780  23.627  20.748  1.00 22.31           C  
ATOM    541  N   LEU A 112      26.780  20.761  19.634  1.00 25.74           N  
ATOM    542  CA  LEU A 112      26.046  19.941  18.658  1.00 25.10           C  
ATOM    543  C   LEU A 112      25.031  19.032  19.365  1.00 22.32           C  
ATOM    544  O   LEU A 112      23.877  18.872  18.910  1.00 19.25           O  
ATOM    545  CB  LEU A 112      27.021  19.099  17.807  1.00 24.79           C  
ATOM    546  CG  LEU A 112      26.506  18.484  16.492  1.00 26.50           C  
ATOM    547  CD1 LEU A 112      26.064  19.546  15.468  1.00 26.72           C  
ATOM    548  CD2 LEU A 112      27.560  17.585  15.878  1.00 24.87           C  
ATOM    549  N   LEU A 113      25.458  18.454  20.479  1.00 19.94           N  
ATOM    550  CA  LEU A 113      24.561  17.622  21.278  1.00 19.99           C  
ATOM    551  C   LEU A 113      23.338  18.416  21.773  1.00 20.71           C  
ATOM    552  O   LEU A 113      22.210  17.938  21.642  1.00 21.00           O  
ATOM    553  CB  LEU A 113      25.329  16.982  22.438  1.00 19.17           C  
ATOM    554  CG  LEU A 113      26.287  15.843  22.045  1.00 18.44           C  
ATOM    555  CD1 LEU A 113      27.319  15.605  23.165  1.00 19.43           C  
ATOM    556  CD2 LEU A 113      25.499  14.567  21.761  1.00 21.18           C  
ATOM    557  N   ASP A 114      23.562  19.619  22.302  1.00 19.87           N  
ATOM    558  CA  ASP A 114      22.480  20.404  22.893  1.00 20.85           C  
ATOM    559  C   ASP A 114      21.462  20.793  21.844  1.00 21.02           C  
ATOM    560  O   ASP A 114      20.261  20.706  22.078  1.00 20.83           O  
ATOM    561  CB  ASP A 114      23.007  21.656  23.593  1.00 21.54           C  
ATOM    562  CG  ASP A 114      23.674  21.339  24.926  1.00 24.79           C  
ATOM    563  OD1 ASP A 114      23.562  20.186  25.392  1.00 28.49           O  
ATOM    564  OD2 ASP A 114      24.322  22.231  25.506  1.00 25.33           O  
ATOM    565  N   ARG A 115      21.953  21.245  20.699  1.00 20.44           N  
ATOM    566  CA  ARG A 115      21.083  21.698  19.613  1.00 20.77           C  
ATOM    567  C   ARG A 115      20.192  20.566  19.091  1.00 20.47           C  
ATOM    568  O   ARG A 115      18.986  20.734  18.962  1.00 19.68           O  
ATOM    569  CB  ARG A 115      21.921  22.267  18.470  1.00 20.74           C  
ATOM    570  CG  ARG A 115      21.093  22.945  17.405  1.00 22.60           C  
ATOM    571  N   ALA A 116      20.796  19.426  18.775  1.00 20.21           N  
ATOM    572  CA  ALA A 116      20.041  18.293  18.221  1.00 21.78           C  
ATOM    573  C   ALA A 116      19.028  17.764  19.233  1.00 22.25           C  
ATOM    574  O   ALA A 116      17.892  17.409  18.882  1.00 23.13           O  
ATOM    575  CB  ALA A 116      21.013  17.188  17.748  1.00 22.39           C  
ATOM    576  N   ARG A 117      19.431  17.737  20.507  1.00 22.61           N  
ATOM    577  CA  ARG A 117      18.555  17.273  21.586  1.00 22.57           C  
ATOM    578  C   ARG A 117      17.382  18.239  21.794  1.00 22.52           C  
ATOM    579  O   ARG A 117      16.259  17.776  21.968  1.00 21.94           O  
ATOM    580  CB  ARG A 117      19.331  17.038  22.906  1.00 23.06           C  
ATOM    581  CG  ARG A 117      18.422  16.700  24.123  1.00 23.22           C  
ATOM    582  CD  ARG A 117      17.546  15.440  23.911  1.00 21.71           C  
ATOM    583  NE  ARG A 117      18.342  14.228  23.699  1.00 20.21           N  
ATOM    584  CZ  ARG A 117      18.609  13.316  24.639  1.00 19.04           C  
ATOM    585  NH1 ARG A 117      18.161  13.483  25.894  1.00 21.00           N  
ATOM    586  NH2 ARG A 117      19.320  12.228  24.325  1.00 20.37           N  
ATOM    587  N   ALA A 118      17.620  19.559  21.744  1.00 21.15           N  
ATOM    588  CA  ALA A 118      16.494  20.530  21.803  1.00 21.18           C  
ATOM    589  C   ALA A 118      15.504  20.290  20.651  1.00 20.94           C  
ATOM    590  O   ALA A 118      14.299  20.284  20.860  1.00 20.01           O  
ATOM    591  CB  ALA A 118      17.000  22.004  21.799  1.00 21.52           C  
ATOM    592  N   PHE A 119      16.032  20.061  19.446  1.00 21.43           N  
ATOM    593  CA  PHE A 119      15.239  19.835  18.232  1.00 21.24           C  
ATOM    594  C   PHE A 119      14.451  18.535  18.394  1.00 22.28           C  
ATOM    595  O   PHE A 119      13.248  18.489  18.170  1.00 21.15           O  
ATOM    596  CB  PHE A 119      16.193  19.748  17.020  1.00 21.18           C  
ATOM    597  CG  PHE A 119      15.500  19.552  15.697  1.00 22.31           C  
ATOM    598  CD1 PHE A 119      14.153  19.878  15.531  1.00 22.45           C  
ATOM    599  CD2 PHE A 119      16.202  19.056  14.601  1.00 20.64           C  
ATOM    600  CE1 PHE A 119      13.513  19.682  14.291  1.00 22.26           C  
ATOM    601  CE2 PHE A 119      15.570  18.883  13.373  1.00 20.75           C  
ATOM    602  CZ  PHE A 119      14.227  19.197  13.223  1.00 22.11           C  
ATOM    603  N   LEU A 120      15.140  17.462  18.779  1.00 21.21           N  
ATOM    604  CA  LEU A 120      14.443  16.215  19.035  1.00 21.27           C  
ATOM    605  C   LEU A 120      13.286  16.340  20.048  1.00 21.85           C  
ATOM    606  O   LEU A 120      12.185  15.816  19.801  1.00 22.36           O  
ATOM    607  CB  LEU A 120      15.426  15.126  19.466  1.00 20.91           C  
ATOM    608  CG  LEU A 120      14.828  13.741  19.757  1.00 20.82           C  
ATOM    609  CD1 LEU A 120      14.047  13.177  18.535  1.00 21.04           C  
ATOM    610  CD2 LEU A 120      15.933  12.798  20.193  1.00 19.95           C  
ATOM    611  N   LEU A 121      13.533  17.010  21.173  1.00 20.79           N  
ATOM    612  CA  LEU A 121      12.540  17.129  22.194  1.00 21.10           C  
ATOM    613  C   LEU A 121      11.318  17.952  21.706  1.00 22.12           C  
ATOM    614  O   LEU A 121      10.177  17.702  22.132  1.00 21.25           O  
ATOM    615  CB  LEU A 121      13.141  17.748  23.469  1.00 20.63           C  
ATOM    616  CG  LEU A 121      14.066  16.905  24.361  1.00 21.47           C  
ATOM    617  CD1 LEU A 121      14.592  17.730  25.552  1.00 22.13           C  
ATOM    618  CD2 LEU A 121      13.463  15.604  24.861  1.00 21.89           C  
ATOM    619  N   GLU A 122      11.581  18.978  20.888  1.00 22.51           N  
ATOM    620  CA  GLU A 122      10.512  19.782  20.312  1.00 22.55           C  
ATOM    621  C   GLU A 122       9.604  18.897  19.447  1.00 22.14           C  
ATOM    622  O   GLU A 122       8.381  19.016  19.496  1.00 20.10           O  
ATOM    623  CB  GLU A 122      11.066  20.978  19.505  1.00 23.34           C  
ATOM    624  N   GLU A 123      10.207  18.014  18.654  1.00 21.17           N  
ATOM    625  CA  GLU A 123       9.425  17.146  17.776  1.00 21.15           C  
ATOM    626  C   GLU A 123       8.711  16.035  18.564  1.00 21.81           C  
ATOM    627  O   GLU A 123       7.601  15.604  18.207  1.00 21.33           O  
ATOM    628  CB  GLU A 123      10.313  16.545  16.671  1.00 21.13           C  
ATOM    629  CG  GLU A 123      10.565  17.524  15.490  1.00 20.58           C  
ATOM    630  CD  GLU A 123       9.268  17.998  14.820  1.00 22.71           C  
ATOM    631  OE1 GLU A 123       8.298  17.194  14.669  1.00 21.50           O  
ATOM    632  OE2 GLU A 123       9.219  19.204  14.454  1.00 22.71           O  
ATOM    633  N   VAL A 124       9.371  15.545  19.607  1.00 22.00           N  
ATOM    634  CA  VAL A 124       8.730  14.599  20.541  1.00 22.30           C  
ATOM    635  C   VAL A 124       7.456  15.231  21.128  1.00 21.36           C  
ATOM    636  O   VAL A 124       6.429  14.561  21.206  1.00 19.35           O  
ATOM    637  CB  VAL A 124       9.704  14.144  21.668  1.00 22.31           C  
ATOM    638  CG1 VAL A 124       8.975  13.292  22.742  1.00 24.57           C  
ATOM    639  CG2 VAL A 124      10.886  13.415  21.085  1.00 24.10           C  
ATOM    640  N   ALA A 125       7.538  16.497  21.539  1.00 19.39           N  
ATOM    641  CA  ALA A 125       6.396  17.204  22.112  1.00 19.90           C  
ATOM    642  C   ALA A 125       5.251  17.323  21.134  1.00 20.34           C  
ATOM    643  O   ALA A 125       4.108  17.349  21.544  1.00 20.13           O  
ATOM    644  CB  ALA A 125       6.783  18.571  22.611  1.00 19.16           C  
ATOM    645  N   LYS A 126       5.568  17.406  19.844  1.00 20.66           N  
ATOM    646  CA  LYS A 126       4.569  17.534  18.785  1.00 20.72           C  
ATOM    647  C   LYS A 126       4.094  16.214  18.189  1.00 21.04           C  
ATOM    648  O   LYS A 126       3.193  16.213  17.369  1.00 20.46           O  
ATOM    649  CB  LYS A 126       5.111  18.431  17.665  1.00 20.54           C  
ATOM    650  CG  LYS A 126       5.376  19.857  18.111  1.00 21.27           C  
ATOM    651  CD  LYS A 126       6.145  20.596  17.066  1.00 22.03           C  
ATOM    652  CE  LYS A 126       6.067  22.073  17.323  1.00 21.67           C  
ATOM    653  NZ  LYS A 126       6.815  22.779  16.270  1.00 21.76           N  
ATOM    654  N   ALA A 127       4.706  15.098  18.576  1.00 21.29           N  
ATOM    655  CA  ALA A 127       4.428  13.812  17.935  1.00 21.42           C  
ATOM    656  C   ALA A 127       3.201  13.178  18.513  1.00 21.34           C  
ATOM    657  O   ALA A 127       2.810  13.467  19.640  1.00 20.69           O  
ATOM    658  CB  ALA A 127       5.612  12.858  18.057  1.00 21.62           C  
ATOM    659  N   ASP A 128       2.600  12.294  17.725  1.00 21.47           N  
ATOM    660  CA  ASP A 128       1.527  11.422  18.198  1.00 21.64           C  
ATOM    661  C   ASP A 128       2.160  10.022  18.326  1.00 21.22           C  
ATOM    662  O   ASP A 128       2.438   9.372  17.300  1.00 20.51           O  
ATOM    663  CB  ASP A 128       0.396  11.436  17.172  1.00 21.11           C  
ATOM    664  CG  ASP A 128      -0.591  10.301  17.352  1.00 21.92           C  
ATOM    665  OD1 ASP A 128      -0.486   9.539  18.333  1.00 20.92           O  
ATOM    666  OD2 ASP A 128      -1.490  10.188  16.490  1.00 21.37           O  
ATOM    667  N   PRO A 129       2.380   9.548  19.575  1.00 20.73           N  
ATOM    668  CA  PRO A 129       3.016   8.240  19.802  1.00 20.25           C  
ATOM    669  C   PRO A 129       2.367   7.107  19.012  1.00 19.72           C  
ATOM    670  O   PRO A 129       3.047   6.160  18.629  1.00 20.81           O  
ATOM    671  CB  PRO A 129       2.840   8.018  21.308  1.00 19.84           C  
ATOM    672  CG  PRO A 129       2.731   9.382  21.878  1.00 20.39           C  
ATOM    673  CD  PRO A 129       2.032  10.215  20.846  1.00 21.01           C  
ATOM    674  N   GLN A 130       1.065   7.230  18.754  1.00 18.71           N  
ATOM    675  CA  GLN A 130       0.267   6.178  18.121  1.00 18.23           C  
ATOM    676  C   GLN A 130       0.100   6.396  16.621  1.00 18.03           C  
ATOM    677  O   GLN A 130      -0.663   5.672  15.969  1.00 16.86           O  
ATOM    678  CB  GLN A 130      -1.139   6.125  18.735  1.00 17.56           C  
ATOM    679  CG  GLN A 130      -1.286   6.715  20.126  1.00 19.44           C  
ATOM    680  CD  GLN A 130      -0.604   5.887  21.201  1.00 23.48           C  
ATOM    681  OE1 GLN A 130      -0.468   4.666  21.068  1.00 25.58           O  
ATOM    682  NE2 GLN A 130      -0.188   6.547  22.291  1.00 25.95           N  
ATOM    683  N   ASN A 131       0.757   7.424  16.085  1.00 16.31           N  
ATOM    684  CA  ASN A 131       0.764   7.671  14.630  1.00 16.23           C  
ATOM    685  C   ASN A 131       1.186   6.370  13.921  1.00 16.25           C  
ATOM    686  O   ASN A 131       2.265   5.856  14.212  1.00 17.52           O  
ATOM    687  CB  ASN A 131       1.730   8.830  14.324  1.00 16.70           C  
ATOM    688  CG  ASN A 131       1.775   9.222  12.825  1.00 18.01           C  
ATOM    689  OD1 ASN A 131       1.096   8.624  11.981  1.00 18.61           O  
ATOM    690  ND2 ASN A 131       2.562  10.252  12.508  1.00 20.42           N  
ATOM    691  N   PRO A 132       0.311   5.783  13.071  1.00 16.84           N  
ATOM    692  CA  PRO A 132       0.701   4.573  12.349  1.00 17.60           C  
ATOM    693  C   PRO A 132       1.653   4.760  11.170  1.00 17.92           C  
ATOM    694  O   PRO A 132       2.182   3.759  10.662  1.00 19.45           O  
ATOM    695  CB  PRO A 132      -0.644   3.974  11.884  1.00 17.25           C  
ATOM    696  CG  PRO A 132      -1.601   5.128  11.833  1.00 16.78           C  
ATOM    697  CD  PRO A 132      -1.113   6.146  12.830  1.00 16.75           C  
ATOM    698  N   ALA A 133       1.885   6.006  10.743  1.00 17.56           N  
ATOM    699  CA  ALA A 133       2.719   6.286   9.565  1.00 17.37           C  
ATOM    700  C   ALA A 133       4.161   5.871   9.845  1.00 17.29           C  
ATOM    701  O   ALA A 133       4.631   6.035  10.979  1.00 16.50           O  
ATOM    702  CB  ALA A 133       2.632   7.765   9.178  1.00 17.46           C  
ATOM    703  N   THR A 134       4.862   5.371   8.819  1.00 17.28           N  
ATOM    704  CA  THR A 134       6.201   4.819   9.028  1.00 17.19           C  
ATOM    705  C   THR A 134       7.238   5.445   8.090  1.00 16.61           C  
ATOM    706  O   THR A 134       6.909   5.963   6.999  1.00 16.08           O  
ATOM    707  CB  THR A 134       6.274   3.261   8.922  1.00 16.83           C  
ATOM    708  OG1 THR A 134       6.075   2.860   7.573  1.00 16.94           O  
ATOM    709  CG2 THR A 134       5.279   2.537   9.847  1.00 18.68           C  
ATOM    710  N   PHE A 135       8.481   5.425   8.530  1.00 16.36           N  
ATOM    711  CA  PHE A 135       9.562   5.889   7.663  1.00 16.86           C  
ATOM    712  C   PHE A 135      10.708   4.884   7.870  1.00 17.36           C  
ATOM    713  O   PHE A 135      10.889   4.404   8.999  1.00 18.15           O  
ATOM    714  CB  PHE A 135       9.950   7.353   7.984  1.00 17.02           C  
ATOM    715  CG  PHE A 135      10.965   7.934   7.029  1.00 16.23           C  
ATOM    716  CD1 PHE A 135      10.567   8.559   5.855  1.00 16.68           C  
ATOM    717  CD2 PHE A 135      12.328   7.780   7.269  1.00 16.58           C  
ATOM    718  CE1 PHE A 135      11.515   9.063   4.945  1.00 19.56           C  
ATOM    719  CE2 PHE A 135      13.274   8.258   6.347  1.00 17.11           C  
ATOM    720  CZ  PHE A 135      12.880   8.894   5.200  1.00 18.07           C  
ATOM    721  N   PRO A 136      11.437   4.524   6.791  1.00 17.75           N  
ATOM    722  CA  PRO A 136      12.484   3.496   6.947  1.00 18.01           C  
ATOM    723  C   PRO A 136      13.702   3.894   7.782  1.00 17.54           C  
ATOM    724  O   PRO A 136      14.315   4.959   7.544  1.00 14.74           O  
ATOM    725  CB  PRO A 136      12.872   3.114   5.505  1.00 18.02           C  
ATOM    726  CG  PRO A 136      12.456   4.312   4.668  1.00 20.08           C  
ATOM    727  CD  PRO A 136      11.253   4.936   5.382  1.00 17.88           C  
ATOM    728  N   HIS A 137      14.029   3.033   8.752  1.00 17.36           N  
ATOM    729  CA  HIS A 137      15.245   3.178   9.551  1.00 17.79           C  
ATOM    730  C   HIS A 137      16.258   2.222   8.914  1.00 17.78           C  
ATOM    731  O   HIS A 137      15.920   1.097   8.603  1.00 17.81           O  
ATOM    732  CB  HIS A 137      14.994   2.819  11.034  1.00 16.81           C  
ATOM    733  CG  HIS A 137      16.204   2.995  11.914  1.00 17.62           C  
ATOM    734  ND1 HIS A 137      16.294   3.970  12.895  1.00 19.33           N  
ATOM    735  CD2 HIS A 137      17.392   2.345  11.922  1.00 14.20           C  
ATOM    736  CE1 HIS A 137      17.479   3.896  13.482  1.00 13.54           C  
ATOM    737  NE2 HIS A 137      18.168   2.923  12.904  1.00 18.32           N  
ATOM    738  N   PRO A 138      17.483   2.693   8.649  1.00 17.91           N  
ATOM    739  CA  PRO A 138      18.489   1.820   8.014  1.00 17.65           C  
ATOM    740  C   PRO A 138      18.735   0.403   8.653  1.00 18.28           C  
ATOM    741  O   PRO A 138      19.110  -0.580   7.967  1.00 17.98           O  
ATOM    742  CB  PRO A 138      19.773   2.679   8.074  1.00 19.38           C  
ATOM    743  CG  PRO A 138      19.452   3.873   8.977  1.00 19.82           C  
ATOM    744  CD  PRO A 138      17.970   4.082   8.821  1.00 17.67           C  
ATOM    745  N   PHE A 139      18.586   0.316   9.962  1.00 18.27           N  
ATOM    746  CA  PHE A 139      18.815  -0.929  10.696  1.00 18.07           C  
ATOM    747  C   PHE A 139      17.439  -1.545  11.107  1.00 17.25           C  
ATOM    748  O   PHE A 139      17.208  -2.747  10.990  1.00 17.87           O  
ATOM    749  CB  PHE A 139      19.702  -0.646  11.919  1.00 18.00           C  
ATOM    750  CG  PHE A 139      20.115  -1.883  12.665  1.00 19.10           C  
ATOM    751  CD1 PHE A 139      21.159  -2.665  12.210  1.00 18.02           C  
ATOM    752  CD2 PHE A 139      19.406  -2.306  13.783  1.00 19.33           C  
ATOM    753  CE1 PHE A 139      21.503  -3.828  12.870  1.00 19.06           C  
ATOM    754  CE2 PHE A 139      19.760  -3.492  14.450  1.00 22.28           C  
ATOM    755  CZ  PHE A 139      20.808  -4.229  13.996  1.00 19.04           C  
ATOM    756  N   PHE A 140      16.523  -0.728  11.590  1.00 24.89           N  
ATOM    757  CA  PHE A 140      15.279  -1.291  12.137  1.00 23.04           C  
ATOM    758  C   PHE A 140      14.108  -1.474  11.151  1.00 23.06           C  
ATOM    759  O   PHE A 140      13.046  -2.016  11.517  1.00 21.98           O  
ATOM    760  CB  PHE A 140      14.893  -0.523  13.398  1.00 21.10           C  
ATOM    761  CG  PHE A 140      15.909  -0.676  14.509  1.00 21.91           C  
ATOM    762  CD1 PHE A 140      16.129  -1.928  15.098  1.00 22.95           C  
ATOM    763  CD2 PHE A 140      16.683   0.402  14.919  1.00 22.07           C  
ATOM    764  CE1 PHE A 140      17.089  -2.085  16.107  1.00 24.42           C  
ATOM    765  CE2 PHE A 140      17.648   0.259  15.926  1.00 20.87           C  
ATOM    766  CZ  PHE A 140      17.850  -0.977  16.526  1.00 21.37           C  
ATOM    767  N   GLY A 141      14.307  -1.036   9.907  1.00 22.87           N  
ATOM    768  CA  GLY A 141      13.240  -1.084   8.911  1.00 22.54           C  
ATOM    769  C   GLY A 141      12.151  -0.032   9.127  1.00 20.75           C  
ATOM    770  O   GLY A 141      12.415   1.038   9.646  1.00 19.93           O  
ATOM    771  N   GLU A 142      10.922  -0.342   8.729  1.00 19.77           N  
ATOM    772  CA  GLU A 142       9.840   0.652   8.768  1.00 18.95           C  
ATOM    773  C   GLU A 142       9.419   0.890  10.196  1.00 18.87           C  
ATOM    774  O   GLU A 142       8.937  -0.011  10.865  1.00 19.12           O  
ATOM    775  CB  GLU A 142       8.624   0.192   7.934  1.00 18.23           C  
ATOM    776  CG  GLU A 142       8.841   0.194   6.433  1.00 19.79           C  
ATOM    777  CD  GLU A 142       9.042   1.591   5.836  1.00 22.82           C  
ATOM    778  OE1 GLU A 142       8.267   2.534   6.145  1.00 20.38           O  
ATOM    779  OE2 GLU A 142       9.976   1.731   5.037  1.00 25.25           O  
ATOM    780  N   LEU A 143       9.637   2.101  10.676  1.00 19.29           N  
ATOM    781  CA  LEU A 143       9.291   2.465  12.054  1.00 18.77           C  
ATOM    782  C   LEU A 143       8.336   3.637  12.077  1.00 18.38           C  
ATOM    783  O   LEU A 143       8.491   4.583  11.290  1.00 17.17           O  
ATOM    784  CB  LEU A 143      10.562   2.837  12.850  1.00 19.00           C  
ATOM    785  CG  LEU A 143      11.645   1.786  13.128  1.00 18.89           C  
ATOM    786  CD1 LEU A 143      12.766   2.412  13.936  1.00 20.53           C  
ATOM    787  CD2 LEU A 143      11.087   0.576  13.861  1.00 20.43           C  
ATOM    788  N   ASN A 144       7.380   3.603  13.014  1.00 16.77           N  
ATOM    789  CA  ASN A 144       6.483   4.759  13.206  1.00 17.38           C  
ATOM    790  C   ASN A 144       7.172   5.669  14.209  1.00 17.94           C  
ATOM    791  O   ASN A 144       8.268   5.355  14.636  1.00 17.61           O  
ATOM    792  CB  ASN A 144       5.096   4.320  13.694  1.00 17.63           C  
ATOM    793  CG  ASN A 144       5.152   3.462  14.955  1.00 19.11           C  
ATOM    794  OD1 ASN A 144       5.956   3.683  15.877  1.00 17.75           O  
ATOM    795  ND2 ASN A 144       4.274   2.455  14.996  1.00 21.22           N  
ATOM    796  N   PRO A 145       6.550   6.804  14.588  1.00 18.26           N  
ATOM    797  CA  PRO A 145       7.245   7.689  15.538  1.00 17.97           C  
ATOM    798  C   PRO A 145       7.709   7.012  16.861  1.00 18.35           C  
ATOM    799  O   PRO A 145       8.816   7.323  17.347  1.00 18.56           O  
ATOM    800  CB  PRO A 145       6.196   8.786  15.821  1.00 17.96           C  
ATOM    801  CG  PRO A 145       5.324   8.814  14.562  1.00 18.92           C  
ATOM    802  CD  PRO A 145       5.240   7.358  14.163  1.00 17.39           C  
ATOM    803  N   LEU A 146       6.869   6.148  17.469  1.00 17.90           N  
ATOM    804  CA  LEU A 146       7.286   5.429  18.703  1.00 18.21           C  
ATOM    805  C   LEU A 146       8.566   4.616  18.445  1.00 18.84           C  
ATOM    806  O   LEU A 146       9.486   4.614  19.280  1.00 19.01           O  
ATOM    807  CB  LEU A 146       6.180   4.472  19.228  1.00 18.17           C  
ATOM    808  CG  LEU A 146       6.499   3.546  20.429  1.00 19.01           C  
ATOM    809  CD1 LEU A 146       6.798   4.336  21.671  1.00 18.07           C  
ATOM    810  CD2 LEU A 146       5.376   2.525  20.728  1.00 18.42           C  
ATOM    811  N   GLY A 147       8.590   3.891  17.319  1.00 17.64           N  
ATOM    812  CA  GLY A 147       9.753   3.076  16.911  1.00 16.72           C  
ATOM    813  C   GLY A 147      11.003   3.951  16.775  1.00 17.02           C  
ATOM    814  O   GLY A 147      12.089   3.563  17.243  1.00 16.44           O  
ATOM    815  N   TRP A 148      10.867   5.094  16.102  1.00 20.70           N  
ATOM    816  CA  TRP A 148      11.953   6.074  15.986  1.00 19.86           C  
ATOM    817  C   TRP A 148      12.443   6.597  17.343  1.00 19.98           C  
ATOM    818  O   TRP A 148      13.628   6.765  17.516  1.00 19.92           O  
ATOM    819  CB  TRP A 148      11.578   7.246  15.053  1.00 20.10           C  
ATOM    820  CG  TRP A 148      11.780   6.853  13.600  1.00 20.41           C  
ATOM    821  CD1 TRP A 148      10.844   6.323  12.747  1.00 21.68           C  
ATOM    822  CD2 TRP A 148      13.018   6.880  12.866  1.00 18.29           C  
ATOM    823  NE1 TRP A 148      11.422   6.039  11.517  1.00 19.71           N  
ATOM    824  CE2 TRP A 148      12.749   6.375  11.566  1.00 19.27           C  
ATOM    825  CE3 TRP A 148      14.317   7.327  13.165  1.00 21.47           C  
ATOM    826  CZ2 TRP A 148      13.730   6.301  10.571  1.00 20.55           C  
ATOM    827  CZ3 TRP A 148      15.302   7.235  12.170  1.00 18.80           C  
ATOM    828  CH2 TRP A 148      14.999   6.724  10.893  1.00 20.19           C  
ATOM    829  N   LEU A 149      11.538   6.865  18.292  1.00 17.65           N  
ATOM    830  CA  LEU A 149      11.984   7.355  19.614  1.00 17.81           C  
ATOM    831  C   LEU A 149      12.713   6.239  20.362  1.00 18.16           C  
ATOM    832  O   LEU A 149      13.776   6.455  20.969  1.00 18.36           O  
ATOM    833  CB  LEU A 149      10.794   7.877  20.428  1.00 16.39           C  
ATOM    834  CG  LEU A 149      11.116   8.485  21.793  1.00 17.59           C  
ATOM    835  CD1 LEU A 149      12.075   9.681  21.632  1.00 17.47           C  
ATOM    836  CD2 LEU A 149       9.839   8.907  22.531  1.00 16.38           C  
ATOM    837  N   ARG A 150      12.152   5.032  20.333  1.00 17.34           N  
ATOM    838  CA  ARG A 150      12.858   3.884  20.924  1.00 17.67           C  
ATOM    839  C   ARG A 150      14.276   3.610  20.337  1.00 17.74           C  
ATOM    840  O   ARG A 150      15.236   3.309  21.090  1.00 17.22           O  
ATOM    841  CB  ARG A 150      11.986   2.625  20.845  1.00 16.58           C  
ATOM    842  CG  ARG A 150      10.745   2.658  21.750  1.00 18.01           C  
ATOM    843  CD  ARG A 150      10.194   1.240  22.007  1.00 22.75           C  
ATOM    844  NE  ARG A 150       9.248   0.820  20.991  1.00 21.66           N  
ATOM    845  CZ  ARG A 150       8.182   0.029  21.185  1.00 25.86           C  
ATOM    846  NH1 ARG A 150       7.864  -0.465  22.391  1.00 27.70           N  
ATOM    847  NH2 ARG A 150       7.410  -0.279  20.149  1.00 22.83           N  
ATOM    848  N   ALA A 151      14.413   3.676  19.009  1.00 16.89           N  
ATOM    849  C   ALA A 151      16.680   4.605  18.937  1.00 20.18           C  
ATOM    850  O   ALA A 151      17.865   4.273  18.922  1.00 20.29           O  
ATOM    851  CB  ALA A 151      15.423   3.510  16.823  1.00 14.08           C  
ATOM    852  N   ALA A 152      16.290   5.876  18.900  1.00 20.04           N  
ATOM    853  CA  ALA A 152      17.056   6.967  19.511  1.00 20.06           C  
ATOM    854  C   ALA A 152      17.521   6.643  20.933  1.00 20.06           C  
ATOM    855  O   ALA A 152      18.686   6.836  21.262  1.00 19.98           O  
ATOM    856  CB  ALA A 152      16.231   8.230  19.524  1.00 19.35           C  
ATOM    857  N   ALA A 153      16.612   6.195  21.778  1.00 19.68           N  
ATOM    858  CA  ALA A 153      16.972   5.791  23.161  1.00 18.99           C  
ATOM    859  C   ALA A 153      18.032   4.664  23.149  1.00 18.59           C  
ATOM    860  O   ALA A 153      19.021   4.755  23.863  1.00 17.97           O  
ATOM    861  CB  ALA A 153      15.751   5.379  23.944  1.00 17.87           C  
ATOM    862  N   TYR A 154      17.807   3.612  22.373  1.00 18.26           N  
ATOM    863  CA  TYR A 154      18.753   2.486  22.256  1.00 17.76           C  
ATOM    864  C   TYR A 154      20.078   2.980  21.681  1.00 16.56           C  
ATOM    865  O   TYR A 154      21.144   2.549  22.096  1.00 16.80           O  
ATOM    866  CB  TYR A 154      18.150   1.350  21.404  1.00 17.35           C  
ATOM    867  CG  TYR A 154      19.077   0.149  21.207  1.00 18.51           C  
ATOM    868  CD1 TYR A 154      19.830  -0.366  22.250  1.00 23.91           C  
ATOM    869  CD2 TYR A 154      19.178  -0.476  19.970  1.00 22.80           C  
ATOM    870  CE1 TYR A 154      20.688  -1.468  22.055  1.00 23.50           C  
ATOM    871  CE2 TYR A 154      20.025  -1.566  19.766  1.00 22.64           C  
ATOM    872  CZ  TYR A 154      20.767  -2.052  20.799  1.00 21.16           C  
ATOM    873  OH  TYR A 154      21.597  -3.138  20.587  1.00 21.89           O  
ATOM    874  N   HIS A 155      19.998   3.886  20.719  1.00 14.73           N  
ATOM    875  CA  HIS A 155      21.214   4.378  20.050  1.00 16.05           C  
ATOM    876  C   HIS A 155      22.158   5.076  21.043  1.00 16.32           C  
ATOM    877  O   HIS A 155      23.341   4.783  21.093  1.00 16.79           O  
ATOM    878  CB  HIS A 155      20.853   5.361  18.915  1.00 14.21           C  
ATOM    879  CG  HIS A 155      22.032   5.786  18.105  1.00 14.20           C  
ATOM    880  ND1 HIS A 155      22.470   7.092  18.047  1.00 14.49           N  
ATOM    881  CD2 HIS A 155      22.859   5.078  17.308  1.00 18.21           C  
ATOM    882  CE1 HIS A 155      23.528   7.164  17.260  1.00 18.85           C  
ATOM    883  NE2 HIS A 155      23.781   5.958  16.791  1.00 18.29           N  
ATOM    884  N   GLU A 156      21.630   6.036  21.789  1.00 15.34           N  
ATOM    885  CA  GLU A 156      22.436   6.697  22.792  1.00 15.79           C  
ATOM    886  C   GLU A 156      22.903   5.736  23.878  1.00 16.33           C  
ATOM    887  O   GLU A 156      24.079   5.841  24.310  1.00 16.59           O  
ATOM    888  CB  GLU A 156      21.728   7.880  23.422  1.00 15.99           C  
ATOM    889  CG  GLU A 156      22.680   8.655  24.349  1.00 15.16           C  
ATOM    890  CD  GLU A 156      22.105   9.965  24.772  1.00 17.49           C  
ATOM    891  OE1 GLU A 156      21.053   9.977  25.459  1.00 16.45           O  
ATOM    892  OE2 GLU A 156      22.710  10.994  24.411  1.00 19.23           O  
ATOM    893  N   ALA A 157      22.042   4.787  24.301  1.00 15.12           N  
ATOM    894  CA  ALA A 157      22.462   3.826  25.331  1.00 15.20           C  
ATOM    895  C   ALA A 157      23.642   2.978  24.819  1.00 16.48           C  
ATOM    896  O   ALA A 157      24.640   2.751  25.505  1.00 16.66           O  
ATOM    897  CB  ALA A 157      21.274   2.933  25.803  1.00 16.19           C  
ATOM    898  N   HIS A 158      23.527   2.533  23.583  1.00 16.67           N  
ATOM    899  CA  HIS A 158      24.565   1.727  22.971  1.00 16.59           C  
ATOM    900  C   HIS A 158      25.931   2.475  22.932  1.00 17.63           C  
ATOM    901  O   HIS A 158      26.992   1.916  23.316  1.00 16.73           O  
ATOM    902  CB  HIS A 158      24.150   1.335  21.556  1.00 16.67           C  
ATOM    903  CG  HIS A 158      25.266   0.711  20.786  1.00 14.93           C  
ATOM    904  ND1 HIS A 158      25.491  -0.649  20.773  1.00 18.05           N  
ATOM    905  CD2 HIS A 158      26.261   1.269  20.056  1.00 18.51           C  
ATOM    906  CE1 HIS A 158      26.572  -0.907  20.057  1.00 17.23           C  
ATOM    907  NE2 HIS A 158      27.067   0.240  19.621  1.00 16.81           N  
ATOM    908  N   HIS A 159      25.908   3.739  22.495  1.00 17.25           N  
ATOM    909  CA  HIS A 159      27.186   4.485  22.337  1.00 17.71           C  
ATOM    910  C   HIS A 159      27.762   4.911  23.676  1.00 17.61           C  
ATOM    911  O   HIS A 159      28.961   4.868  23.877  1.00 18.49           O  
ATOM    912  CB  HIS A 159      27.033   5.637  21.341  1.00 15.88           C  
ATOM    913  CG  HIS A 159      26.911   5.140  19.924  1.00 16.45           C  
ATOM    914  ND1 HIS A 159      27.963   4.558  19.257  1.00 14.37           N  
ATOM    915  CD2 HIS A 159      25.835   5.002  19.113  1.00 15.93           C  
ATOM    916  CE1 HIS A 159      27.555   4.123  18.077  1.00 13.47           C  
ATOM    917  NE2 HIS A 159      26.266   4.401  17.960  1.00 14.36           N  
ATOM    918  N   LEU A 160      26.894   5.283  24.605  1.00 24.35           N  
ATOM    919  CA  LEU A 160      27.324   5.514  25.985  1.00 24.72           C  
ATOM    920  C   LEU A 160      28.024   4.279  26.592  1.00 25.13           C  
ATOM    921  O   LEU A 160      29.101   4.378  27.155  1.00 23.84           O  
ATOM    922  CB  LEU A 160      26.109   5.920  26.838  1.00 24.69           C  
ATOM    923  CG  LEU A 160      26.318   6.090  28.350  1.00 23.54           C  
ATOM    924  CD1 LEU A 160      27.334   7.234  28.623  1.00 24.05           C  
ATOM    925  CD2 LEU A 160      24.954   6.304  29.031  1.00 23.04           C  
ATOM    926  N   LYS A 161      27.393   3.116  26.475  1.00 25.50           N  
ATOM    927  CA  LYS A 161      27.992   1.857  26.919  1.00 26.28           C  
ATOM    928  C   LYS A 161      29.381   1.575  26.306  1.00 26.20           C  
ATOM    929  O   LYS A 161      30.303   1.103  27.012  1.00 25.70           O  
ATOM    930  CB  LYS A 161      27.035   0.714  26.609  1.00 25.81           C  
ATOM    931  CG  LYS A 161      27.094  -0.423  27.546  1.00 28.68           C  
ATOM    932  CD  LYS A 161      25.970  -1.384  27.213  1.00 30.71           C  
ATOM    933  CE  LYS A 161      24.606  -0.833  27.610  1.00 30.50           C  
ATOM    934  NZ  LYS A 161      24.021  -1.647  28.719  1.00 28.99           N  
ATOM    935  N   ALA A 162      29.523   1.832  25.006  1.00 25.56           N  
ATOM    936  CA  ALA A 162      30.804   1.655  24.307  1.00 25.92           C  
ATOM    937  C   ALA A 162      31.899   2.594  24.853  1.00 25.13           C  
ATOM    938  O   ALA A 162      33.025   2.172  25.094  1.00 25.40           O  
ATOM    939  CB  ALA A 162      30.622   1.853  22.813  1.00 25.77           C  
ATOM    940  N   LEU A 163      31.543   3.858  25.060  1.00 25.09           N  
ATOM    941  CA  LEU A 163      32.424   4.829  25.709  1.00 24.48           C  
ATOM    942  C   LEU A 163      32.792   4.421  27.139  1.00 24.04           C  
ATOM    943  O   LEU A 163      33.968   4.392  27.465  1.00 23.79           O  
ATOM    944  CB  LEU A 163      31.799   6.217  25.685  1.00 25.25           C  
ATOM    945  CG  LEU A 163      31.642   6.897  24.322  1.00 25.75           C  
ATOM    946  CD1 LEU A 163      31.118   8.271  24.568  1.00 27.15           C  
ATOM    947  CD2 LEU A 163      32.984   6.949  23.609  1.00 25.59           C  
ATOM    948  N   GLN A 164      31.812   4.078  27.988  1.00 24.13           N  
ATOM    949  CA  GLN A 164      32.144   3.579  29.339  1.00 24.19           C  
ATOM    950  C   GLN A 164      33.085   2.366  29.292  1.00 24.74           C  
ATOM    951  O   GLN A 164      34.017   2.256  30.113  1.00 23.94           O  
ATOM    952  CB  GLN A 164      30.890   3.217  30.105  1.00 24.89           C  
ATOM    953  CG  GLN A 164      30.001   4.408  30.395  1.00 23.79           C  
ATOM    954  CD  GLN A 164      28.597   4.004  30.778  1.00 26.27           C  
ATOM    955  OE1 GLN A 164      28.065   2.983  30.320  1.00 21.24           O  
ATOM    956  NE2 GLN A 164      27.974   4.830  31.613  1.00 22.62           N  
ATOM    957  N   ALA A 165      32.883   1.472  28.324  1.00 23.98           N  
ATOM    958  CA  ALA A 165      33.737   0.283  28.211  1.00 25.03           C  
ATOM    959  C   ALA A 165      35.194   0.650  27.864  1.00 25.41           C  
ATOM    960  O   ALA A 165      36.106  -0.131  28.092  1.00 23.89           O  
ATOM    961  CB  ALA A 165      33.173  -0.674  27.188  1.00 24.67           C  
ATOM    962  N   SER A 166      35.385   1.844  27.307  1.00 26.71           N  
ATOM    963  CA  SER A 166      36.696   2.366  26.936  1.00 27.40           C  
ATOM    964  C   SER A 166      37.365   3.159  28.043  1.00 27.08           C  
ATOM    965  O   SER A 166      38.424   3.739  27.793  1.00 25.89           O  
ATOM    966  CB  SER A 166      36.558   3.279  25.723  1.00 27.09           C  
ATOM    967  OG  SER A 166      36.355   2.508  24.557  1.00 30.67           O  
TER     968      SER A 166                                                      
END
MOLECULE T0406.pdb
ATOM      1  N   MET     1       7.297  -1.140  21.855  1.00 67.48           N  
ATOM      2  CA  MET     1       6.466   0.089  21.680  1.00 67.38           C  
ATOM      3  C   MET     1       6.624   1.036  22.879  1.00 67.17           C  
ATOM      4  O   MET     1       7.261   0.680  23.880  1.00 67.51           O  
ATOM      5  CB  MET     1       4.991  -0.288  21.493  1.00 67.14           C  
ATOM      6  N   TYR     2       6.087   2.252  22.731  1.00 66.54           N  
ATOM      7  CA  TYR     2       5.887   3.206  23.831  1.00 65.82           C  
ATOM      8  C   TYR     2       4.455   3.692  23.727  1.00 64.83           C  
ATOM      9  O   TYR     2       4.090   4.306  22.724  1.00 65.23           O  
ATOM     10  CB  TYR     2       6.815   4.425  23.724  1.00 66.09           C  
ATOM     11  CG  TYR     2       8.272   4.144  23.994  1.00 66.72           C  
ATOM     12  CD1 TYR     2       9.114   3.721  22.966  1.00 67.06           C  
ATOM     13  CD2 TYR     2       8.819   4.310  25.272  1.00 66.81           C  
ATOM     14  CE1 TYR     2      10.460   3.462  23.197  1.00 67.20           C  
ATOM     15  CE2 TYR     2      10.181   4.049  25.515  1.00 66.68           C  
ATOM     16  CZ  TYR     2      10.987   3.627  24.464  1.00 66.65           C  
ATOM     17  OH  TYR     2      12.319   3.352  24.649  1.00 67.31           O  
ATOM     18  N   GLN     3       3.643   3.428  24.747  1.00 63.41           N  
ATOM     19  CA  GLN     3       2.236   3.824  24.719  1.00 62.14           C  
ATOM     20  C   GLN     3       2.079   5.346  24.698  1.00 60.68           C  
ATOM     21  O   GLN     3       1.188   5.860  24.035  1.00 60.60           O  
ATOM     22  CB  GLN     3       1.478   3.230  25.914  1.00 62.10           C  
ATOM     23  N   THR     4       2.957   6.064  25.395  1.00 59.24           N  
ATOM     24  CA  THR     4       2.775   7.504  25.588  1.00 57.91           C  
ATOM     25  C   THR     4       4.038   8.348  25.382  1.00 56.62           C  
ATOM     26  O   THR     4       5.159   7.870  25.551  1.00 56.20           O  
ATOM     27  CB  THR     4       2.215   7.788  27.012  1.00 58.17           C  
ATOM     28  OG1 THR     4       2.177   9.207  27.252  1.00 59.26           O  
ATOM     29  CG2 THR     4       3.069   7.108  28.092  1.00 57.72           C  
ATOM     30  N   ILE     5       3.824   9.617  25.047  1.00 55.05           N  
ATOM     31  CA  ILE     5       4.896  10.604  24.947  1.00 54.14           C  
ATOM     32  C   ILE     5       5.613  10.811  26.281  1.00 53.68           C  
ATOM     33  O   ILE     5       6.835  10.814  26.328  1.00 53.74           O  
ATOM     34  CB  ILE     5       4.373  11.978  24.469  1.00 53.85           C  
ATOM     35  CG1 ILE     5       3.799  11.886  23.058  1.00 53.39           C  
ATOM     36  CG2 ILE     5       5.488  13.034  24.513  1.00 54.49           C  
ATOM     37  CD1 ILE     5       4.763  11.369  22.022  1.00 53.23           C  
ATOM     38  N   GLU     6       4.863  10.994  27.366  1.00 52.98           N  
ATOM     39  CA  GLU     6       5.484  11.191  28.676  1.00 52.29           C  
ATOM     40  C   GLU     6       6.222   9.939  29.121  1.00 50.67           C  
ATOM     41  O   GLU     6       7.255  10.034  29.758  1.00 51.06           O  
ATOM     42  CB  GLU     6       4.453  11.603  29.741  1.00 52.96           C  
ATOM     43  CG  GLU     6       3.816  12.982  29.509  1.00 55.77           C  
ATOM     44  CD  GLU     6       4.832  14.097  29.249  1.00 59.09           C  
ATOM     45  OE1 GLU     6       5.838  14.193  30.007  1.00 61.36           O  
ATOM     46  OE2 GLU     6       4.607  14.883  28.288  1.00 60.81           O  
ATOM     47  N   GLY     7       5.707   8.772  28.767  1.00 48.43           N  
ATOM     48  CA  GLY     7       6.382   7.523  29.073  1.00 47.15           C  
ATOM     49  C   GLY     7       7.752   7.447  28.424  1.00 46.15           C  
ATOM     50  O   GLY     7       8.710   6.970  29.040  1.00 45.59           O  
ATOM     51  N   PHE     8       7.846   7.915  27.178  1.00 44.90           N  
ATOM     52  CA  PHE     8       9.119   7.948  26.461  1.00 43.84           C  
ATOM     53  C   PHE     8      10.069   8.942  27.100  1.00 43.34           C  
ATOM     54  O   PHE     8      11.256   8.666  27.213  1.00 43.35           O  
ATOM     55  CB  PHE     8       8.948   8.285  24.972  1.00 43.21           C  
ATOM     56  CG  PHE     8      10.256   8.601  24.277  1.00 43.07           C  
ATOM     57  CD1 PHE     8      11.165   7.598  23.993  1.00 42.55           C  
ATOM     58  CD2 PHE     8      10.587   9.903  23.942  1.00 41.66           C  
ATOM     59  CE1 PHE     8      12.376   7.888  23.385  1.00 42.21           C  
ATOM     60  CE2 PHE     8      11.798  10.194  23.342  1.00 41.83           C  
ATOM     61  CZ  PHE     8      12.690   9.176  23.063  1.00 41.14           C  
ATOM     62  N   LEU     9       9.551  10.098  27.512  1.00 43.00           N  
ATOM     63  CA  LEU     9      10.393  11.163  28.053  1.00 42.69           C  
ATOM     64  C   LEU     9      10.978  10.813  29.428  1.00 42.59           C  
ATOM     65  O   LEU     9      12.059  11.278  29.773  1.00 42.28           O  
ATOM     66  CB  LEU     9       9.636  12.499  28.078  1.00 42.45           C  
ATOM     67  CG  LEU     9       9.320  13.024  26.671  1.00 41.60           C  
ATOM     68  CD1 LEU     9       8.392  14.227  26.690  1.00 40.52           C  
ATOM     69  CD2 LEU     9      10.596  13.343  25.926  1.00 42.49           C  
ATOM     70  N   GLN    10      10.282   9.969  30.191  1.00 42.38           N  
ATOM     71  CA  GLN    10      10.823   9.446  31.457  1.00 41.96           C  
ATOM     72  C   GLN    10      12.030   8.536  31.190  1.00 41.70           C  
ATOM     73  O   GLN    10      13.037   8.608  31.896  1.00 41.65           O  
ATOM     74  CB  GLN    10       9.747   8.703  32.267  1.00 41.95           C  
ATOM     75  N   SER    11      11.925   7.681  30.174  1.00 41.31           N  
ATOM     76  CA  SER    11      13.063   6.887  29.716  1.00 41.21           C  
ATOM     77  C   SER    11      14.146   7.795  29.103  1.00 40.77           C  
ATOM     78  O   SER    11      15.311   7.716  29.479  1.00 40.67           O  
ATOM     79  CB  SER    11      12.602   5.835  28.696  1.00 41.13           C  
ATOM     80  N   TRP    12      13.750   8.667  28.183  1.00 40.55           N  
ATOM     81  CA  TRP    12      14.686   9.549  27.479  1.00 40.77           C  
ATOM     82  C   TRP    12      15.453  10.500  28.402  1.00 41.18           C  
ATOM     83  O   TRP    12      16.632  10.774  28.176  1.00 41.09           O  
ATOM     84  CB  TRP    12      13.942  10.362  26.406  1.00 40.37           C  
ATOM     85  CG  TRP    12      14.840  11.191  25.536  1.00 39.72           C  
ATOM     86  CD1 TRP    12      14.843  12.546  25.427  1.00 38.90           C  
ATOM     87  CD2 TRP    12      15.869  10.710  24.662  1.00 37.40           C  
ATOM     88  NE1 TRP    12      15.822  12.941  24.537  1.00 39.94           N  
ATOM     89  CE2 TRP    12      16.457  11.832  24.052  1.00 36.37           C  
ATOM     90  CE3 TRP    12      16.354   9.434  24.345  1.00 38.39           C  
ATOM     91  CZ2 TRP    12      17.512  11.727  23.155  1.00 39.00           C  
ATOM     92  CZ3 TRP    12      17.408   9.325  23.448  1.00 39.08           C  
ATOM     93  CH2 TRP    12      17.968  10.471  22.855  1.00 39.11           C  
ATOM     94  N   THR    13      14.788  11.006  29.437  1.00 41.85           N  
ATOM     95  CA  THR    13      15.415  11.922  30.398  1.00 41.85           C  
ATOM     96  C   THR    13      16.573  11.248  31.140  1.00 42.11           C  
ATOM     97  O   THR    13      17.616  11.854  31.303  1.00 41.71           O  
ATOM     98  CB  THR    13      14.371  12.488  31.404  1.00 42.21           C  
ATOM     99  OG1 THR    13      13.365  13.207  30.682  1.00 42.84           O  
ATOM    100  CG2 THR    13      15.012  13.441  32.434  1.00 41.66           C  
ATOM    101  N   TYR    14      16.398   9.995  31.567  1.00 42.84           N  
ATOM    102  CA  TYR    14      17.488   9.241  32.209  1.00 43.23           C  
ATOM    103  C   TYR    14      18.650   9.016  31.226  1.00 42.43           C  
ATOM    104  O   TYR    14      19.816   9.103  31.603  1.00 42.22           O  
ATOM    105  CB  TYR    14      16.999   7.884  32.757  1.00 44.38           C  
ATOM    106  CG  TYR    14      18.107   7.055  33.401  1.00 45.95           C  
ATOM    107  CD1 TYR    14      18.950   6.246  32.622  1.00 47.52           C  
ATOM    108  CD2 TYR    14      18.330   7.091  34.785  1.00 47.51           C  
ATOM    109  CE1 TYR    14      19.987   5.494  33.202  1.00 47.80           C  
ATOM    110  CE2 TYR    14      19.367   6.339  35.375  1.00 47.55           C  
ATOM    111  CZ  TYR    14      20.189   5.546  34.574  1.00 47.61           C  
ATOM    112  OH  TYR    14      21.210   4.803  35.136  1.00 47.57           O  
ATOM    113  N   GLU    15      18.328   8.702  29.976  1.00 41.66           N  
ATOM    114  CA  GLU    15      19.349   8.445  28.956  1.00 41.25           C  
ATOM    115  C   GLU    15      20.147   9.701  28.626  1.00 40.71           C  
ATOM    116  O   GLU    15      21.375   9.657  28.545  1.00 41.46           O  
ATOM    117  CB  GLU    15      18.713   7.888  27.685  1.00 41.21           C  
ATOM    118  CG  GLU    15      18.068   6.507  27.849  1.00 40.06           C  
ATOM    119  CD  GLU    15      19.015   5.466  28.398  1.00 40.80           C  
ATOM    120  OE1 GLU    15      20.183   5.434  27.981  1.00 43.05           O  
ATOM    121  OE2 GLU    15      18.606   4.655  29.244  1.00 40.70           O  
ATOM    122  N   THR    16      19.460  10.818  28.437  1.00 40.48           N  
ATOM    123  CA  THR    16      20.137  12.067  28.086  1.00 40.67           C  
ATOM    124  C   THR    16      20.956  12.631  29.241  1.00 40.57           C  
ATOM    125  O   THR    16      22.086  13.087  29.021  1.00 40.78           O  
ATOM    126  CB  THR    16      19.166  13.156  27.586  1.00 40.47           C  
ATOM    127  OG1 THR    16      18.230  13.485  28.611  1.00 43.09           O  
ATOM    128  CG2 THR    16      18.414  12.697  26.352  1.00 40.12           C  
ATOM    129  N   GLU    17      20.400  12.609  30.460  1.00 39.86           N  
ATOM    130  CA  GLU    17      21.137  13.073  31.639  1.00 39.51           C  
ATOM    131  C   GLU    17      22.447  12.300  31.772  1.00 39.87           C  
ATOM    132  O   GLU    17      23.517  12.891  31.948  1.00 39.64           O  
ATOM    133  CB  GLU    17      20.291  12.941  32.938  1.00 39.19           C  
ATOM    134  CG  GLU    17      19.182  14.019  33.096  1.00 40.37           C  
ATOM    135  CD  GLU    17      18.399  13.942  34.433  1.00 38.16           C  
ATOM    136  N   SER    18      22.346  10.977  31.677  1.00 40.25           N  
ATOM    137  CA  SER    18      23.503  10.084  31.744  1.00 40.99           C  
ATOM    138  C   SER    18      24.538  10.358  30.638  1.00 40.55           C  
ATOM    139  O   SER    18      25.725  10.377  30.893  1.00 41.38           O  
ATOM    140  CB  SER    18      23.028   8.621  31.691  1.00 41.43           C  
ATOM    141  OG  SER    18      24.085   7.743  31.306  1.00 44.83           O  
ATOM    142  N   THR    19      24.083  10.581  29.413  1.00 40.09           N  
ATOM    143  CA  THR    19      24.981  10.822  28.294  1.00 39.40           C  
ATOM    144  C   THR    19      25.668  12.169  28.440  1.00 40.16           C  
ATOM    145  O   THR    19      26.867  12.277  28.222  1.00 39.94           O  
ATOM    146  CB  THR    19      24.226  10.716  26.941  1.00 39.05           C  
ATOM    147  OG1 THR    19      23.608   9.429  26.875  1.00 38.12           O  
ATOM    148  CG2 THR    19      25.167  10.872  25.755  1.00 38.05           C  
ATOM    149  N   GLN    20      24.900  13.179  28.839  1.00 40.47           N  
ATOM    150  CA  GLN    20      25.405  14.537  28.995  1.00 40.77           C  
ATOM    151  C   GLN    20      26.471  14.626  30.083  1.00 41.36           C  
ATOM    152  O   GLN    20      27.433  15.382  29.931  1.00 41.53           O  
ATOM    153  CB  GLN    20      24.249  15.489  29.312  1.00 40.66           C  
ATOM    154  CG  GLN    20      24.633  16.965  29.386  1.00 40.31           C  
ATOM    155  CD  GLN    20      24.916  17.559  28.025  1.00 40.59           C  
ATOM    156  OE1 GLN    20      24.019  17.678  27.197  1.00 39.78           O  
ATOM    157  NE2 GLN    20      26.159  17.973  27.799  1.00 40.39           N  
ATOM    158  N   LYS    21      26.294  13.871  31.170  1.00 41.97           N  
ATOM    159  CA  LYS    21      27.275  13.825  32.266  1.00 42.84           C  
ATOM    160  C   LYS    21      28.624  13.299  31.779  1.00 42.30           C  
ATOM    161  O   LYS    21      29.674  13.815  32.154  1.00 41.33           O  
ATOM    162  CB  LYS    21      26.799  12.926  33.412  1.00 42.87           C  
ATOM    163  CG  LYS    21      25.691  13.497  34.281  1.00 44.80           C  
ATOM    164  CD  LYS    21      25.392  12.603  35.518  1.00 45.52           C  
ATOM    165  CE  LYS    21      25.198  11.125  35.110  1.00 47.96           C  
ATOM    166  NZ  LYS    21      24.594  10.313  36.197  1.00 50.07           N  
ATOM    167  N   MET    22      28.582  12.250  30.957  1.00 41.83           N  
ATOM    168  CA  MET    22      29.792  11.702  30.386  1.00 42.13           C  
ATOM    169  C   MET    22      30.464  12.678  29.418  1.00 41.34           C  
ATOM    170  O   MET    22      31.661  12.951  29.532  1.00 41.70           O  
ATOM    171  CB  MET    22      29.499  10.357  29.752  1.00 41.41           C  
ATOM    172  CG  MET    22      29.212   9.331  30.816  1.00 41.76           C  
ATOM    173  SD  MET    22      29.053   7.714  29.928  0.75 46.00          SE  
ATOM    174  CE  MET    22      28.062   6.697  31.258  1.00 42.97           C  
ATOM    175  N   LEU    23      29.683  13.257  28.525  1.00 41.06           N  
ATOM    176  CA  LEU    23      30.180  14.268  27.589  1.00 40.50           C  
ATOM    177  C   LEU    23      30.793  15.430  28.306  1.00 40.38           C  
ATOM    178  O   LEU    23      31.763  15.992  27.827  1.00 40.99           O  
ATOM    179  CB  LEU    23      29.057  14.765  26.647  1.00 40.12           C  
ATOM    180  CG  LEU    23      28.669  13.786  25.523  1.00 38.27           C  
ATOM    181  CD1 LEU    23      27.561  14.345  24.656  1.00 35.14           C  
ATOM    182  CD2 LEU    23      29.861  13.455  24.660  1.00 36.73           C  
ATOM    183  N   ASP    24      30.232  15.791  29.461  1.00 40.31           N  
ATOM    184  CA  ASP    24      30.712  16.941  30.237  1.00 40.03           C  
ATOM    185  C   ASP    24      32.090  16.701  30.870  1.00 39.37           C  
ATOM    186  O   ASP    24      32.787  17.655  31.197  1.00 38.85           O  
ATOM    187  CB  ASP    24      29.687  17.346  31.325  1.00 40.24           C  
ATOM    188  CG  ASP    24      28.461  18.090  30.757  1.00 40.77           C  
ATOM    189  OD1 ASP    24      28.486  18.507  29.579  1.00 42.10           O  
ATOM    190  OD2 ASP    24      27.463  18.268  31.498  1.00 43.46           O  
ATOM    191  N   VAL    25      32.480  15.438  31.027  1.00 38.26           N  
ATOM    192  CA  VAL    25      33.777  15.086  31.632  1.00 38.17           C  
ATOM    193  C   VAL    25      34.928  15.046  30.614  1.00 37.59           C  
ATOM    194  O   VAL    25      36.101  15.050  30.988  1.00 36.68           O  
ATOM    195  CB  VAL    25      33.684  13.702  32.309  1.00 38.15           C  
ATOM    196  CG1 VAL    25      35.032  13.258  32.835  1.00 38.34           C  
ATOM    197  CG2 VAL    25      32.656  13.739  33.431  1.00 39.21           C  
ATOM    198  N   LEU    26      34.587  14.997  29.328  1.00 37.24           N  
ATOM    199  CA  LEU    26      35.586  14.778  28.276  1.00 37.75           C  
ATOM    200  C   LEU    26      36.463  16.017  28.180  1.00 37.41           C  
ATOM    201  O   LEU    26      36.004  17.143  28.403  1.00 37.48           O  
ATOM    202  CB  LEU    26      34.914  14.437  26.920  1.00 37.39           C  
ATOM    203  CG  LEU    26      34.684  12.958  26.533  1.00 38.57           C  
ATOM    204  CD1 LEU    26      34.222  12.049  27.652  1.00 41.47           C  
ATOM    205  CD2 LEU    26      33.704  12.858  25.355  1.00 38.55           C  
ATOM    206  N   THR    27      37.741  15.788  27.904  1.00 37.39           N  
ATOM    207  CA  THR    27      38.704  16.852  27.689  1.00 36.78           C  
ATOM    208  C   THR    27      39.095  16.792  26.227  1.00 36.71           C  
ATOM    209  O   THR    27      38.852  15.779  25.560  1.00 36.22           O  
ATOM    210  CB  THR    27      39.959  16.643  28.545  1.00 36.70           C  
ATOM    211  OG1 THR    27      40.584  15.407  28.170  1.00 35.79           O  
ATOM    212  CG2 THR    27      39.596  16.593  30.025  1.00 36.04           C  
ATOM    213  N   ASP    28      39.698  17.876  25.746  1.00 36.48           N  
ATOM    214  CA  ASP    28      40.181  17.965  24.373  1.00 36.48           C  
ATOM    215  C   ASP    28      41.176  16.861  24.059  1.00 36.24           C  
ATOM    216  O   ASP    28      41.126  16.267  22.986  1.00 35.36           O  
ATOM    217  CB  ASP    28      40.835  19.318  24.122  1.00 36.48           C  
ATOM    218  CG  ASP    28      39.838  20.462  24.108  1.00 36.42           C  
ATOM    219  OD1 ASP    28      38.623  20.221  24.269  1.00 37.35           O  
ATOM    220  OD2 ASP    28      40.270  21.616  23.927  1.00 37.41           O  
ATOM    221  N   GLU    29      42.050  16.575  25.013  1.00 36.42           N  
ATOM    222  CA  GLU    29      43.073  15.539  24.856  1.00 36.73           C  
ATOM    223  C   GLU    29      42.464  14.161  24.700  1.00 36.58           C  
ATOM    224  O   GLU    29      42.914  13.376  23.859  1.00 36.92           O  
ATOM    225  CB  GLU    29      44.019  15.533  26.067  1.00 36.94           C  
ATOM    226  CG  GLU    29      45.252  14.631  25.896  1.00 37.22           C  
ATOM    227  N   SER    30      41.444  13.873  25.515  1.00 36.43           N  
ATOM    228  CA  SER    30      40.774  12.551  25.541  1.00 36.31           C  
ATOM    229  C   SER    30      40.136  12.169  24.224  1.00 36.16           C  
ATOM    230  O   SER    30      40.007  10.982  23.911  1.00 37.55           O  
ATOM    231  CB  SER    30      39.707  12.495  26.643  1.00 36.25           C  
ATOM    232  OG  SER    30      38.616  13.360  26.369  1.00 36.58           O  
ATOM    233  N   LEU    31      39.752  13.170  23.451  1.00 35.91           N  
ATOM    234  CA  LEU    31      39.124  12.969  22.157  1.00 35.90           C  
ATOM    235  C   LEU    31      39.992  12.163  21.201  1.00 35.76           C  
ATOM    236  O   LEU    31      39.459  11.472  20.327  1.00 36.37           O  
ATOM    237  CB  LEU    31      38.772  14.326  21.516  1.00 35.53           C  
ATOM    238  CG  LEU    31      37.787  15.200  22.289  1.00 35.42           C  
ATOM    239  CD1 LEU    31      37.398  16.345  21.392  1.00 34.66           C  
ATOM    240  CD2 LEU    31      36.543  14.418  22.807  1.00 36.79           C  
ATOM    241  N   SER    32      41.316  12.224  21.368  1.00 35.50           N  
ATOM    242  CA  SER    32      42.212  11.485  20.484  1.00 35.38           C  
ATOM    243  C   SER    32      42.359  10.021  20.909  1.00 35.55           C  
ATOM    244  O   SER    32      42.958   9.244  20.192  1.00 35.03           O  
ATOM    245  CB  SER    32      43.575  12.170  20.369  1.00 35.21           C  
ATOM    246  OG  SER    32      44.276  12.175  21.595  1.00 36.76           O  
ATOM    247  N   GLN    33      41.741   9.642  22.008  1.00 35.94           N  
ATOM    248  CA  GLN    33      41.856   8.283  22.500  1.00 36.42           C  
ATOM    249  C   GLN    33      41.259   7.240  21.573  1.00 37.94           C  
ATOM    250  O   GLN    33      40.153   7.338  21.218  1.00 37.84           O  
ATOM    251  CB  GLN    33      41.266   8.168  23.896  1.00 36.12           C  
ATOM    252  CG  GLN    33      41.620   6.877  24.606  1.00 34.98           C  
ATOM    253  CD  GLN    33      43.026   6.863  25.196  1.00 34.24           C  
ATOM    254  OE1 GLN    33      43.564   7.870  25.593  1.00 31.29           O  
ATOM    255  NE2 GLN    33      43.602   5.718  25.234  1.00 29.63           N  
ATOM    256  N   GLU    34      41.998   6.210  21.231  1.00 40.01           N  
ATOM    257  CA  GLU    34      41.603   5.337  20.148  1.00 41.29           C  
ATOM    258  C   GLU    34      41.154   3.975  20.575  1.00 41.72           C  
ATOM    259  O   GLU    34      41.708   3.386  21.435  1.00 42.17           O  
ATOM    260  CB  GLU    34      42.736   5.204  19.131  1.00 41.31           C  
ATOM    261  N   ILE    35      40.178   3.436  19.902  1.00 42.30           N  
ATOM    262  CA  ILE    35      39.851   2.039  20.071  1.00 42.71           C  
ATOM    263  C   ILE    35      40.975   1.099  19.779  1.00 43.11           C  
ATOM    264  O   ILE    35      41.143   0.149  20.462  1.00 44.11           O  
ATOM    265  CB  ILE    35      38.723   1.629  19.221  1.00 42.57           C  
ATOM    266  CG1 ILE    35      37.485   2.371  19.608  1.00 43.35           C  
ATOM    267  CG2 ILE    35      38.571   0.141  19.222  1.00 42.92           C  
ATOM    268  CD1 ILE    35      36.345   2.021  18.840  1.00 46.42           C  
ATOM    269  N   ALA    36      41.701   1.355  18.711  1.00 42.78           N  
ATOM    270  CA  ALA    36      42.827   0.550  18.264  1.00 42.55           C  
ATOM    271  C   ALA    36      43.504   1.282  17.104  1.00 42.14           C  
ATOM    272  O   ALA    36      42.954   2.237  16.560  1.00 42.00           O  
ATOM    273  CB  ALA    36      42.359  -0.839  17.829  1.00 42.64           C  
ATOM    274  N   PRO    37      44.724   0.879  16.751  1.00 42.20           N  
ATOM    275  CA  PRO    37      45.335   1.512  15.588  1.00 41.84           C  
ATOM    276  C   PRO    37      44.471   1.331  14.347  1.00 41.06           C  
ATOM    277  O   PRO    37      44.054   0.212  14.037  1.00 41.34           O  
ATOM    278  CB  PRO    37      46.663   0.783  15.470  1.00 42.16           C  
ATOM    279  CG  PRO    37      46.938   0.351  16.879  1.00 42.26           C  
ATOM    280  CD  PRO    37      45.628  -0.105  17.364  1.00 41.99           C  
ATOM    281  N   GLY    38      44.156   2.436  13.681  1.00 40.27           N  
ATOM    282  CA  GLY    38      43.343   2.382  12.469  1.00 39.62           C  
ATOM    283  C   GLY    38      41.853   2.425  12.730  1.00 39.24           C  
ATOM    284  O   GLY    38      41.060   2.278  11.805  1.00 38.25           O  
ATOM    285  N   HIS    39      41.470   2.652  13.987  1.00 38.72           N  
ATOM    286  CA  HIS    39      40.072   2.666  14.380  1.00 38.82           C  
ATOM    287  C   HIS    39      39.623   4.045  14.866  1.00 38.20           C  
ATOM    288  O   HIS    39      40.415   4.973  15.001  1.00 38.13           O  
ATOM    289  CB  HIS    39      39.827   1.611  15.462  1.00 39.68           C  
ATOM    290  CG  HIS    39      39.769   0.215  14.936  1.00 40.52           C  
ATOM    291  ND1 HIS    39      40.868  -0.614  14.897  1.00 43.17           N  
ATOM    292  CD2 HIS    39      38.738  -0.495  14.420  1.00 42.67           C  
ATOM    293  CE1 HIS    39      40.521  -1.776  14.373  1.00 44.25           C  
ATOM    294  NE2 HIS    39      39.233  -1.730  14.074  1.00 44.78           N  
ATOM    295  N   TRP    40      38.334   4.163  15.134  1.00 38.25           N  
ATOM    296  CA  TRP    40      37.750   5.394  15.655  1.00 37.81           C  
ATOM    297  C   TRP    40      38.341   5.859  16.983  1.00 36.50           C  
ATOM    298  O   TRP    40      38.780   5.054  17.798  1.00 35.36           O  
ATOM    299  CB  TRP    40      36.252   5.207  15.873  1.00 39.04           C  
ATOM    300  CG  TRP    40      35.405   5.473  14.689  1.00 39.44           C  
ATOM    301  CD1 TRP    40      35.781   5.484  13.367  1.00 39.64           C  
ATOM    302  CD2 TRP    40      34.006   5.731  14.715  1.00 40.61           C  
ATOM    303  NE1 TRP    40      34.677   5.738  12.573  1.00 40.54           N  
ATOM    304  CE2 TRP    40      33.580   5.900  13.380  1.00 40.48           C  
ATOM    305  CE3 TRP    40      33.064   5.835  15.740  1.00 40.53           C  
ATOM    306  CZ2 TRP    40      32.248   6.176  13.053  1.00 41.21           C  
ATOM    307  CZ3 TRP    40      31.741   6.103  15.413  1.00 40.49           C  
ATOM    308  CH2 TRP    40      31.348   6.276  14.084  1.00 40.47           C  
ATOM    309  N   THR    41      38.336   7.182  17.158  1.00 35.70           N  
ATOM    310  CA  THR    41      38.672   7.816  18.409  1.00 35.60           C  
ATOM    311  C   THR    41      37.418   8.109  19.248  1.00 35.89           C  
ATOM    312  O   THR    41      36.267   8.033  18.774  1.00 35.61           O  
ATOM    313  CB  THR    41      39.425   9.146  18.198  1.00 35.61           C  
ATOM    314  OG1 THR    41      38.543  10.090  17.607  1.00 36.06           O  
ATOM    315  CG2 THR    41      40.640   8.968  17.296  1.00 35.36           C  
ATOM    316  N   LEU    42      37.667   8.442  20.506  1.00 36.16           N  
ATOM    317  CA  LEU    42      36.612   8.834  21.451  1.00 36.54           C  
ATOM    318  C   LEU    42      35.827  10.047  20.984  1.00 37.06           C  
ATOM    319  O   LEU    42      34.606  10.095  21.148  1.00 38.12           O  
ATOM    320  CB  LEU    42      37.238   9.078  22.829  1.00 35.87           C  
ATOM    321  CG  LEU    42      36.388   9.581  24.000  1.00 36.67           C  
ATOM    322  CD1 LEU    42      35.058   8.861  24.109  1.00 34.62           C  
ATOM    323  CD2 LEU    42      37.232   9.459  25.299  1.00 35.25           C  
ATOM    324  N   GLY    43      36.539  11.019  20.418  1.00 37.44           N  
ATOM    325  CA  GLY    43      35.949  12.194  19.804  1.00 37.53           C  
ATOM    326  C   GLY    43      34.952  11.844  18.715  1.00 38.35           C  
ATOM    327  O   GLY    43      33.885  12.465  18.640  1.00 38.03           O  
ATOM    328  N   ARG    44      35.263  10.832  17.897  1.00 38.28           N  
ATOM    329  CA  ARG    44      34.332  10.408  16.841  1.00 37.97           C  
ATOM    330  C   ARG    44      33.141   9.619  17.383  1.00 37.69           C  
ATOM    331  O   ARG    44      32.031   9.812  16.929  1.00 36.92           O  
ATOM    332  CB  ARG    44      35.015   9.586  15.748  1.00 38.16           C  
ATOM    333  CG  ARG    44      34.049   9.332  14.580  1.00 41.71           C  
ATOM    334  CD  ARG    44      34.689   9.418  13.191  1.00 45.92           C  
ATOM    335  NE  ARG    44      33.666   9.473  12.141  1.00 46.95           N  
ATOM    336  CZ  ARG    44      33.845   9.080  10.882  1.00 47.95           C  
ATOM    337  NH1 ARG    44      35.001   8.556  10.479  1.00 49.31           N  
ATOM    338  NH2 ARG    44      32.846   9.191  10.017  1.00 47.85           N  
ATOM    339  N   VAL    45      33.379   8.700  18.320  1.00 38.02           N  
ATOM    340  CA  VAL    45      32.286   8.059  19.038  1.00 38.22           C  
ATOM    341  C   VAL    45      31.309   9.088  19.607  1.00 39.42           C  
ATOM    342  O   VAL    45      30.098   8.946  19.408  1.00 41.06           O  
ATOM    343  CB  VAL    45      32.786   7.065  20.129  1.00 38.71           C  
ATOM    344  CG1 VAL    45      31.578   6.411  20.878  1.00 37.23           C  
ATOM    345  CG2 VAL    45      33.651   6.016  19.498  1.00 35.38           C  
ATOM    346  N   ALA    46      31.824  10.160  20.224  1.00 39.15           N  
ATOM    347  CA  ALA    46      30.990  11.162  20.902  1.00 38.95           C  
ATOM    348  C   ALA    46      30.202  12.044  19.919  1.00 38.71           C  
ATOM    349  O   ALA    46      29.030  12.365  20.134  1.00 37.60           O  
ATOM    350  CB  ALA    46      31.858  12.048  21.800  1.00 38.55           C  
ATOM    351  N   TRP    47      30.862  12.484  18.863  1.00 38.76           N  
ATOM    352  CA  TRP    47      30.171  13.244  17.833  1.00 38.83           C  
ATOM    353  C   TRP    47      29.138  12.385  17.064  1.00 38.47           C  
ATOM    354  O   TRP    47      28.131  12.884  16.634  1.00 38.14           O  
ATOM    355  CB  TRP    47      31.189  13.859  16.887  1.00 38.98           C  
ATOM    356  CG  TRP    47      30.676  14.933  16.005  1.00 38.62           C  
ATOM    357  CD1 TRP    47      30.772  14.970  14.660  1.00 38.41           C  
ATOM    358  CD2 TRP    47      30.038  16.160  16.403  1.00 38.34           C  
ATOM    359  NE1 TRP    47      30.228  16.143  14.177  1.00 39.87           N  
ATOM    360  CE2 TRP    47      29.762  16.883  15.229  1.00 37.93           C  
ATOM    361  CE3 TRP    47      29.671  16.712  17.638  1.00 39.22           C  
ATOM    362  CZ2 TRP    47      29.136  18.125  15.244  1.00 39.28           C  
ATOM    363  CZ3 TRP    47      29.052  17.932  17.659  1.00 38.88           C  
ATOM    364  CH2 TRP    47      28.785  18.638  16.466  1.00 39.61           C  
ATOM    365  N   HIS    48      29.393  11.087  16.917  1.00 37.89           N  
ATOM    366  CA  HIS    48      28.448  10.186  16.269  1.00 37.24           C  
ATOM    367  C   HIS    48      27.122  10.134  17.067  1.00 37.41           C  
ATOM    368  O   HIS    48      26.037  10.100  16.486  1.00 36.57           O  
ATOM    369  CB  HIS    48      29.104   8.795  16.145  1.00 37.50           C  
ATOM    370  CG  HIS    48      28.246   7.750  15.500  1.00 37.08           C  
ATOM    371  ND1 HIS    48      27.851   7.817  14.184  1.00 37.73           N  
ATOM    372  CD2 HIS    48      27.805   6.556  15.962  1.00 38.81           C  
ATOM    373  CE1 HIS    48      27.150   6.737  13.881  1.00 38.77           C  
ATOM    374  NE2 HIS    48      27.102   5.956  14.944  1.00 37.37           N  
ATOM    375  N   ILE    49      27.220  10.172  18.395  1.00 36.74           N  
ATOM    376  CA  ILE    49      26.046  10.202  19.304  1.00 36.60           C  
ATOM    377  C   ILE    49      25.247  11.479  19.139  1.00 36.58           C  
ATOM    378  O   ILE    49      24.000  11.486  19.074  1.00 37.69           O  
ATOM    379  CB  ILE    49      26.522  10.076  20.780  1.00 36.62           C  
ATOM    380  CG1 ILE    49      26.917   8.633  21.055  1.00 35.34           C  
ATOM    381  CG2 ILE    49      25.416  10.507  21.821  1.00 36.42           C  
ATOM    382  CD1 ILE    49      27.867   8.474  22.217  1.00 34.26           C  
ATOM    383  N   VAL    50      25.968  12.571  19.059  1.00 36.48           N  
ATOM    384  CA  VAL    50      25.336  13.842  18.869  1.00 35.50           C  
ATOM    385  C   VAL    50      24.554  13.869  17.553  1.00 35.98           C  
ATOM    386  O   VAL    50      23.355  14.204  17.533  1.00 34.52           O  
ATOM    387  CB  VAL    50      26.370  14.959  18.949  1.00 36.20           C  
ATOM    388  CG1 VAL    50      25.698  16.298  18.728  1.00 33.19           C  
ATOM    389  CG2 VAL    50      27.100  14.929  20.338  1.00 33.82           C  
ATOM    390  N   THR    51      25.223  13.474  16.466  1.00 37.01           N  
ATOM    391  CA  THR    51      24.664  13.566  15.129  1.00 37.55           C  
ATOM    392  C   THR    51      23.593  12.530  14.882  1.00 38.58           C  
ATOM    393  O   THR    51      22.703  12.759  14.043  1.00 38.83           O  
ATOM    394  CB  THR    51      25.741  13.435  14.009  1.00 38.09           C  
ATOM    395  OG1 THR    51      26.371  12.143  14.073  1.00 37.78           O  
ATOM    396  CG2 THR    51      26.774  14.468  14.152  1.00 35.80           C  
ATOM    397  N   ALA    52      23.663  11.406  15.611  1.00 39.48           N  
ATOM    398  CA  ALA    52      22.683  10.339  15.510  1.00 39.44           C  
ATOM    399  C   ALA    52      21.254  10.764  15.832  1.00 40.87           C  
ATOM    400  O   ALA    52      20.318  10.121  15.351  1.00 39.51           O  
ATOM    401  CB  ALA    52      23.100   9.112  16.376  1.00 40.12           C  
ATOM    402  N   ILE    53      21.062  11.888  16.559  1.00 41.91           N  
ATOM    403  CA  ILE    53      19.704  12.284  16.963  1.00 42.87           C  
ATOM    404  C   ILE    53      18.884  12.714  15.724  1.00 43.37           C  
ATOM    405  O   ILE    53      17.848  12.093  15.434  1.00 42.52           O  
ATOM    406  CB  ILE    53      19.686  13.334  18.129  1.00 43.00           C  
ATOM    407  CG1 ILE    53      20.106  12.664  19.441  1.00 44.60           C  
ATOM    408  CG2 ILE    53      18.311  13.920  18.328  1.00 43.32           C  
ATOM    409  CD1 ILE    53      20.584  13.644  20.534  1.00 42.31           C  
ATOM    410  N   PRO    54      19.330  13.763  14.994  1.00 43.64           N  
ATOM    411  CA  PRO    54      18.670  14.065  13.720  1.00 43.62           C  
ATOM    412  C   PRO    54      18.713  12.972  12.637  1.00 44.27           C  
ATOM    413  O   PRO    54      17.808  12.945  11.816  1.00 44.52           O  
ATOM    414  CB  PRO    54      19.353  15.357  13.247  1.00 44.47           C  
ATOM    415  CG  PRO    54      20.619  15.465  14.045  1.00 43.73           C  
ATOM    416  CD  PRO    54      20.382  14.742  15.328  1.00 43.31           C  
ATOM    417  N   VAL    55      19.687  12.054  12.647  1.00 43.45           N  
ATOM    418  CA  VAL    55      19.785  11.057  11.578  1.00 43.07           C  
ATOM    419  C   VAL    55      18.745   9.948  11.775  1.00 42.92           C  
ATOM    420  O   VAL    55      18.032   9.547  10.840  1.00 42.72           O  
ATOM    421  CB  VAL    55      21.217  10.481  11.471  1.00 43.39           C  
ATOM    422  CG1 VAL    55      21.263   9.270  10.506  1.00 43.13           C  
ATOM    423  CG2 VAL    55      22.195  11.597  11.039  1.00 41.78           C  
ATOM    424  N   ILE    56      18.646   9.455  13.000  1.00 42.45           N  
ATOM    425  CA  ILE    56      17.669   8.426  13.298  1.00 42.54           C  
ATOM    426  C   ILE    56      16.236   9.016  13.196  1.00 42.86           C  
ATOM    427  O   ILE    56      15.333   8.365  12.701  1.00 43.17           O  
ATOM    428  CB  ILE    56      17.972   7.749  14.665  1.00 42.17           C  
ATOM    429  CG1 ILE    56      19.186   6.815  14.532  1.00 41.57           C  
ATOM    430  CG2 ILE    56      16.740   7.055  15.210  1.00 40.86           C  
ATOM    431  CD1 ILE    56      19.632   6.168  15.866  1.00 40.57           C  
ATOM    432  N   LEU    57      16.016  10.263  13.599  1.00 42.81           N  
ATOM    433  CA  LEU    57      14.644  10.757  13.596  1.00 42.59           C  
ATOM    434  C   LEU    57      14.171  11.323  12.230  1.00 43.44           C  
ATOM    435  O   LEU    57      12.980  11.681  12.073  1.00 42.65           O  
ATOM    436  CB  LEU    57      14.435  11.746  14.755  1.00 43.42           C  
ATOM    437  CG  LEU    57      14.682  11.079  16.128  1.00 42.68           C  
ATOM    438  CD1 LEU    57      14.283  11.922  17.199  1.00 42.04           C  
ATOM    439  CD2 LEU    57      13.925   9.749  16.268  1.00 45.34           C  
ATOM    440  N   SER    58      15.066  11.369  11.237  1.00 43.29           N  
ATOM    441  CA  SER    58      14.771  12.116  10.003  1.00 43.78           C  
ATOM    442  C   SER    58      13.557  11.583   9.256  1.00 43.27           C  
ATOM    443  O   SER    58      12.747  12.355   8.762  1.00 43.22           O  
ATOM    444  CB  SER    58      15.989  12.175   9.065  1.00 44.30           C  
ATOM    445  OG  SER    58      16.311  10.897   8.546  1.00 44.43           O  
ATOM    446  N   GLY    59      13.431  10.262   9.205  1.00 42.77           N  
ATOM    447  CA  GLY    59      12.336   9.607   8.495  1.00 43.05           C  
ATOM    448  C   GLY    59      10.983   9.740   9.166  1.00 42.87           C  
ATOM    449  O   GLY    59       9.965   9.439   8.558  1.00 42.27           O  
ATOM    450  N   THR    60      10.963  10.171  10.425  1.00 43.30           N  
ATOM    451  CA  THR    60       9.695  10.439  11.129  1.00 43.91           C  
ATOM    452  C   THR    60       9.060  11.764  10.654  1.00 44.53           C  
ATOM    453  O   THR    60       7.873  12.014  10.863  1.00 44.89           O  
ATOM    454  CB  THR    60       9.878  10.557  12.660  1.00 43.17           C  
ATOM    455  OG1 THR    60      10.446  11.834  12.957  1.00 41.99           O  
ATOM    456  CG2 THR    60      10.755   9.449  13.213  1.00 44.70           C  
ATOM    457  N   GLY    61       9.863  12.633  10.064  1.00 45.44           N  
ATOM    458  CA  GLY    61       9.346  13.908   9.591  1.00 45.80           C  
ATOM    459  C   GLY    61       9.321  14.978  10.671  1.00 46.83           C  
ATOM    460  O   GLY    61       9.039  16.143  10.380  1.00 46.08           O  
ATOM    461  N   LEU    62       9.626  14.594  11.912  1.00 47.33           N  
ATOM    462  CA  LEU    62       9.760  15.550  13.015  1.00 48.30           C  
ATOM    463  C   LEU    62      11.003  16.407  12.778  1.00 48.48           C  
ATOM    464  O   LEU    62      12.118  15.913  12.828  1.00 49.91           O  
ATOM    465  CB  LEU    62       9.879  14.777  14.327  1.00 48.16           C  
ATOM    466  CG  LEU    62       9.823  15.488  15.671  1.00 48.99           C  
ATOM    467  CD1 LEU    62       8.480  16.168  15.895  1.00 47.52           C  
ATOM    468  CD2 LEU    62      10.100  14.436  16.754  1.00 48.02           C  
ATOM    469  N   LYS    63      10.818  17.693  12.517  1.00 48.89           N  
ATOM    470  CA  LYS    63      11.905  18.530  12.028  1.00 48.59           C  
ATOM    471  C   LYS    63      12.464  19.441  13.137  1.00 48.24           C  
ATOM    472  O   LYS    63      11.704  20.076  13.879  1.00 48.07           O  
ATOM    473  CB  LYS    63      11.418  19.342  10.814  1.00 49.26           C  
ATOM    474  CG  LYS    63      10.922  18.449   9.641  1.00 48.40           C  
ATOM    475  N   PHE    64      13.792  19.478  13.259  1.00 47.14           N  
ATOM    476  CA  PHE    64      14.447  20.338  14.243  1.00 46.77           C  
ATOM    477  C   PHE    64      15.926  20.524  13.913  1.00 47.14           C  
ATOM    478  O   PHE    64      16.523  19.708  13.222  1.00 46.93           O  
ATOM    479  CB  PHE    64      14.293  19.750  15.646  1.00 45.79           C  
ATOM    480  CG  PHE    64      14.836  18.351  15.780  1.00 43.79           C  
ATOM    481  CD1 PHE    64      16.161  18.132  16.138  1.00 40.87           C  
ATOM    482  CD2 PHE    64      14.030  17.265  15.520  1.00 42.88           C  
ATOM    483  CE1 PHE    64      16.660  16.848  16.251  1.00 42.93           C  
ATOM    484  CE2 PHE    64      14.518  15.994  15.641  1.00 41.21           C  
ATOM    485  CZ  PHE    64      15.847  15.787  16.000  1.00 42.35           C  
ATOM    486  N   GLU    65      16.508  21.596  14.427  1.00 47.28           N  
ATOM    487  CA  GLU    65      17.889  21.962  14.106  1.00 47.91           C  
ATOM    488  C   GLU    65      18.893  20.968  14.727  1.00 47.50           C  
ATOM    489  O   GLU    65      18.722  20.540  15.871  1.00 47.17           O  
ATOM    490  CB  GLU    65      18.162  23.386  14.584  1.00 47.85           C  
ATOM    491  CG  GLU    65      19.431  24.043  14.032  1.00 49.87           C  
ATOM    492  N   GLY    66      19.917  20.599  13.953  1.00 46.99           N  
ATOM    493  CA  GLY    66      20.978  19.708  14.426  1.00 46.66           C  
ATOM    494  C   GLY    66      21.882  19.204  13.317  1.00 46.16           C  
ATOM    495  O   GLY    66      21.399  18.713  12.295  1.00 46.83           O  
ATOM    496  N   GLU    67      23.193  19.306  13.526  1.00 45.14           N  
ATOM    497  CA  GLU    67      24.190  18.735  12.609  1.00 44.58           C  
ATOM    498  C   GLU    67      23.947  17.241  12.433  1.00 43.64           C  
ATOM    499  O   GLU    67      23.686  16.576  13.408  1.00 43.39           O  
ATOM    500  CB  GLU    67      25.602  18.935  13.171  1.00 44.62           C  
ATOM    501  CG  GLU    67      26.722  18.414  12.286  1.00 45.82           C  
ATOM    502  CD  GLU    67      26.649  18.981  10.883  1.00 48.02           C  
ATOM    503  OE1 GLU    67      26.896  20.205  10.749  1.00 49.57           O  
ATOM    504  OE2 GLU    67      26.331  18.211   9.936  1.00 47.88           O  
ATOM    505  N   THR    68      24.057  16.754  11.196  1.00 43.40           N  
ATOM    506  CA  THR    68      23.815  15.353  10.828  1.00 43.81           C  
ATOM    507  C   THR    68      25.062  14.608  10.292  1.00 43.32           C  
ATOM    508  O   THR    68      25.062  13.375  10.193  1.00 43.61           O  
ATOM    509  CB  THR    68      22.682  15.260   9.760  1.00 44.60           C  
ATOM    510  OG1 THR    68      23.040  16.030   8.608  1.00 44.60           O  
ATOM    511  CG2 THR    68      21.339  15.782  10.317  1.00 44.27           C  
ATOM    512  N   LYS    69      26.113  15.346   9.937  1.00 42.95           N  
ATOM    513  CA  LYS    69      27.360  14.748   9.426  1.00 42.71           C  
ATOM    514  C   LYS    69      28.367  14.499  10.552  1.00 42.24           C  
ATOM    515  O   LYS    69      28.805  15.432  11.222  1.00 41.49           O  
ATOM    516  CB  LYS    69      27.982  15.665   8.365  1.00 43.12           C  
ATOM    517  N   ASP    70      28.754  13.242  10.751  1.00 42.33           N  
ATOM    518  CA  ASP    70      29.666  12.900  11.844  1.00 42.59           C  
ATOM    519  C   ASP    70      31.152  13.014  11.461  1.00 42.55           C  
ATOM    520  O   ASP    70      32.018  12.600  12.225  1.00 42.47           O  
ATOM    521  CB  ASP    70      29.300  11.531  12.500  1.00 42.89           C  
ATOM    522  CG  ASP    70      29.642  10.330  11.638  1.00 44.57           C  
ATOM    523  OD1 ASP    70      30.098  10.523  10.493  1.00 47.83           O  
ATOM    524  OD2 ASP    70      29.440   9.183  12.099  1.00 44.97           O  
ATOM    525  N   TYR    71      31.428  13.594  10.290  1.00 42.85           N  
ATOM    526  CA  TYR    71      32.783  13.917   9.856  1.00 42.91           C  
ATOM    527  C   TYR    71      32.710  15.258   9.139  1.00 42.56           C  
ATOM    528  O   TYR    71      31.804  15.477   8.342  1.00 43.39           O  
ATOM    529  CB  TYR    71      33.366  12.843   8.914  1.00 43.24           C  
ATOM    530  CG  TYR    71      34.905  12.846   8.805  1.00 42.94           C  
ATOM    531  CD1 TYR    71      35.697  12.097   9.698  1.00 43.93           C  
ATOM    532  CD2 TYR    71      35.557  13.579   7.817  1.00 42.74           C  
ATOM    533  CE1 TYR    71      37.104  12.091   9.606  1.00 43.63           C  
ATOM    534  CE2 TYR    71      36.954  13.576   7.706  1.00 43.03           C  
ATOM    535  CZ  TYR    71      37.730  12.831   8.600  1.00 44.06           C  
ATOM    536  OH  TYR    71      39.125  12.835   8.488  1.00 43.45           O  
ATOM    537  N   PRO    72      33.625  16.189   9.455  1.00 41.60           N  
ATOM    538  CA  PRO    72      34.725  16.088  10.394  1.00 40.90           C  
ATOM    539  C   PRO    72      34.244  16.180  11.843  1.00 40.00           C  
ATOM    540  O   PRO    72      33.101  16.563  12.113  1.00 39.44           O  
ATOM    541  CB  PRO    72      35.598  17.290  10.021  1.00 40.75           C  
ATOM    542  CG  PRO    72      34.642  18.284   9.584  1.00 41.25           C  
ATOM    543  CD  PRO    72      33.563  17.535   8.860  1.00 41.61           C  
ATOM    544  N   VAL    73      35.116  15.796  12.758  1.00 39.25           N  
ATOM    545  CA  VAL    73      34.790  15.771  14.166  1.00 38.70           C  
ATOM    546  C   VAL    73      35.314  17.074  14.791  1.00 38.13           C  
ATOM    547  O   VAL    73      36.446  17.478  14.519  1.00 38.73           O  
ATOM    548  CB  VAL    73      35.452  14.569  14.854  1.00 38.74           C  
ATOM    549  CG1 VAL    73      35.151  14.567  16.354  1.00 38.20           C  
ATOM    550  CG2 VAL    73      35.013  13.269  14.191  1.00 39.08           C  
ATOM    551  N   PRO    74      34.517  17.727  15.655  1.00 37.44           N  
ATOM    552  CA  PRO    74      35.051  18.883  16.382  1.00 36.76           C  
ATOM    553  C   PRO    74      36.312  18.587  17.184  1.00 36.56           C  
ATOM    554  O   PRO    74      36.464  17.485  17.707  1.00 35.92           O  
ATOM    555  CB  PRO    74      33.907  19.239  17.334  1.00 36.40           C  
ATOM    556  CG  PRO    74      32.712  18.794  16.639  1.00 35.99           C  
ATOM    557  CD  PRO    74      33.106  17.491  16.010  1.00 37.63           C  
ATOM    558  N   THR    75      37.197  19.577  17.308  1.00 37.11           N  
ATOM    559  CA  THR    75      38.420  19.400  18.104  1.00 37.55           C  
ATOM    560  C   THR    75      38.298  19.809  19.582  1.00 38.15           C  
ATOM    561  O   THR    75      39.186  19.506  20.388  1.00 37.83           O  
ATOM    562  CB  THR    75      39.637  20.078  17.456  1.00 37.85           C  
ATOM    563  OG1 THR    75      39.406  21.479  17.284  1.00 36.14           O  
ATOM    564  CG2 THR    75      39.914  19.428  16.094  1.00 38.81           C  
ATOM    565  N   SER    76      37.189  20.449  19.949  1.00 37.93           N  
ATOM    566  CA  SER    76      36.993  20.911  21.313  1.00 37.91           C  
ATOM    567  C   SER    76      35.887  20.136  21.959  1.00 37.58           C  
ATOM    568  O   SER    76      34.809  20.014  21.382  1.00 37.85           O  
ATOM    569  CB  SER    76      36.635  22.399  21.320  1.00 38.14           C  
ATOM    570  OG  SER    76      35.824  22.693  22.444  1.00 39.20           O  
ATOM    571  N   ALA    77      36.133  19.606  23.156  1.00 37.95           N  
ATOM    572  CA  ALA    77      35.137  18.753  23.821  1.00 38.33           C  
ATOM    573  C   ALA    77      33.931  19.597  24.265  1.00 38.87           C  
ATOM    574  O   ALA    77      32.819  19.078  24.436  1.00 38.94           O  
ATOM    575  CB  ALA    77      35.742  17.988  24.990  1.00 38.12           C  
ATOM    576  N   LYS    78      34.130  20.907  24.370  1.00 39.08           N  
ATOM    577  CA  LYS    78      33.032  21.806  24.723  1.00 39.75           C  
ATOM    578  C   LYS    78      32.038  21.915  23.581  1.00 39.51           C  
ATOM    579  O   LYS    78      30.839  21.982  23.819  1.00 40.22           O  
ATOM    580  CB  LYS    78      33.523  23.197  25.118  1.00 39.29           C  
ATOM    581  CG  LYS    78      32.574  23.869  26.098  1.00 40.21           C  
ATOM    582  CD  LYS    78      33.048  25.265  26.529  1.00 40.61           C  
ATOM    583  CE  LYS    78      32.139  26.352  25.985  1.00 42.02           C  
ATOM    584  NZ  LYS    78      30.808  26.307  26.638  1.00 42.42           N  
ATOM    585  N   THR    79      32.529  21.930  22.345  1.00 39.41           N  
ATOM    586  CA  THR    79      31.637  21.886  21.184  1.00 39.10           C  
ATOM    587  C   THR    79      30.776  20.638  21.160  1.00 38.89           C  
ATOM    588  O   THR    79      29.597  20.711  20.832  1.00 40.76           O  
ATOM    589  CB  THR    79      32.399  22.005  19.859  1.00 38.85           C  
ATOM    590  OG1 THR    79      33.154  23.214  19.869  1.00 38.67           O  
ATOM    591  CG2 THR    79      31.429  22.065  18.683  1.00 39.84           C  
ATOM    592  N   ILE    80      31.358  19.496  21.500  1.00 37.87           N  
ATOM    593  CA  ILE    80      30.642  18.224  21.465  1.00 37.23           C  
ATOM    594  C   ILE    80      29.556  18.137  22.544  1.00 36.97           C  
ATOM    595  O   ILE    80      28.392  17.854  22.253  1.00 37.19           O  
ATOM    596  CB  ILE    80      31.627  17.027  21.568  1.00 36.96           C  
ATOM    597  CG1 ILE    80      32.624  17.060  20.379  1.00 36.88           C  
ATOM    598  CG2 ILE    80      30.864  15.675  21.647  1.00 35.26           C  
ATOM    599  CD1 ILE    80      33.641  15.932  20.348  1.00 37.46           C  
ATOM    600  N   ALA    81      29.937  18.377  23.789  1.00 36.74           N  
ATOM    601  CA  ALA    81      29.006  18.343  24.910  1.00 36.66           C  
ATOM    602  C   ALA    81      27.873  19.378  24.744  1.00 37.19           C  
ATOM    603  O   ALA    81      26.700  19.092  25.046  1.00 36.55           O  
ATOM    604  CB  ALA    81      29.777  18.567  26.224  1.00 37.06           C  
ATOM    605  N   ASP    82      28.219  20.572  24.259  1.00 37.79           N  
ATOM    606  CA  ASP    82      27.231  21.625  24.043  1.00 38.43           C  
ATOM    607  C   ASP    82      26.311  21.309  22.875  1.00 38.88           C  
ATOM    608  O   ASP    82      25.102  21.470  22.976  1.00 38.28           O  
ATOM    609  CB  ASP    82      27.900  22.979  23.835  1.00 38.51           C  
ATOM    610  CG  ASP    82      28.488  23.539  25.127  1.00 40.46           C  
ATOM    611  OD1 ASP    82      28.625  22.771  26.119  1.00 42.63           O  
ATOM    612  OD2 ASP    82      28.834  24.734  25.154  1.00 33.97           O  
ATOM    613  N   GLY    83      26.895  20.847  21.772  1.00 40.13           N  
ATOM    614  CA  GLY    83      26.137  20.242  20.672  1.00 40.53           C  
ATOM    615  C   GLY    83      25.089  19.235  21.105  1.00 40.91           C  
ATOM    616  O   GLY    83      23.944  19.333  20.687  1.00 41.21           O  
ATOM    617  N   TYR    84      25.469  18.265  21.928  1.00 41.63           N  
ATOM    618  CA  TYR    84      24.503  17.292  22.452  1.00 41.56           C  
ATOM    619  C   TYR    84      23.374  17.990  23.233  1.00 42.71           C  
ATOM    620  O   TYR    84      22.211  17.671  23.042  1.00 42.92           O  
ATOM    621  CB  TYR    84      25.180  16.286  23.363  1.00 41.30           C  
ATOM    622  CG  TYR    84      24.276  15.137  23.762  1.00 40.64           C  
ATOM    623  CD1 TYR    84      23.985  14.118  22.877  1.00 41.04           C  
ATOM    624  CD2 TYR    84      23.696  15.092  25.018  1.00 40.97           C  
ATOM    625  CE1 TYR    84      23.169  13.065  23.241  1.00 40.97           C  
ATOM    626  CE2 TYR    84      22.863  14.073  25.382  1.00 39.98           C  
ATOM    627  CZ  TYR    84      22.604  13.057  24.499  1.00 40.99           C  
ATOM    628  OH  TYR    84      21.786  12.029  24.880  1.00 40.71           O  
ATOM    629  N   ARG    85      23.725  18.935  24.101  1.00 43.13           N  
ATOM    630  CA  ARG    85      22.735  19.630  24.915  1.00 44.43           C  
ATOM    631  C   ARG    85      21.742  20.346  24.009  1.00 44.49           C  
ATOM    632  O   ARG    85      20.531  20.215  24.184  1.00 45.40           O  
ATOM    633  CB  ARG    85      23.402  20.640  25.857  1.00 44.20           C  
ATOM    634  CG  ARG    85      22.413  21.416  26.727  1.00 45.42           C  
ATOM    635  CD  ARG    85      23.081  22.302  27.766  1.00 46.23           C  
ATOM    636  NE  ARG    85      23.894  21.513  28.691  1.00 47.92           N  
ATOM    637  CZ  ARG    85      25.228  21.473  28.711  1.00 49.12           C  
ATOM    638  NH1 ARG    85      25.963  22.210  27.870  1.00 49.26           N  
ATOM    639  NH2 ARG    85      25.838  20.690  29.603  1.00 49.86           N  
ATOM    640  N   LYS    86      22.285  21.078  23.038  1.00 44.41           N  
ATOM    641  CA  LYS    86      21.524  21.907  22.092  1.00 44.22           C  
ATOM    642  C   LYS    86      20.519  21.090  21.292  1.00 44.21           C  
ATOM    643  O   LYS    86      19.328  21.437  21.238  1.00 44.20           O  
ATOM    644  CB  LYS    86      22.497  22.582  21.113  1.00 44.43           C  
ATOM    645  CG  LYS    86      22.184  24.005  20.742  1.00 44.56           C  
ATOM    646  CD  LYS    86      23.377  24.630  20.012  1.00 44.07           C  
ATOM    647  N   VAL    87      20.999  20.014  20.670  1.00 43.34           N  
ATOM    648  CA  VAL    87      20.168  19.228  19.768  1.00 43.89           C  
ATOM    649  C   VAL    87      19.150  18.360  20.517  1.00 43.64           C  
ATOM    650  O   VAL    87      18.048  18.135  20.023  1.00 43.37           O  
ATOM    651  CB  VAL    87      21.004  18.366  18.782  1.00 43.25           C  
ATOM    652  CG1 VAL    87      21.605  17.148  19.465  1.00 44.08           C  
ATOM    653  CG2 VAL    87      20.137  17.958  17.625  1.00 44.87           C  
ATOM    654  N   ASN    88      19.508  17.892  21.712  1.00 43.54           N  
ATOM    655  CA  ASN    88      18.537  17.209  22.557  1.00 43.84           C  
ATOM    656  C   ASN    88      17.379  18.147  22.921  1.00 42.62           C  
ATOM    657  O   ASN    88      16.228  17.764  22.876  1.00 42.64           O  
ATOM    658  CB  ASN    88      19.175  16.635  23.827  1.00 44.30           C  
ATOM    659  CG  ASN    88      18.201  15.759  24.605  1.00 46.95           C  
ATOM    660  OD1 ASN    88      17.648  14.805  24.059  1.00 53.28           O  
ATOM    661  ND2 ASN    88      17.948  16.106  25.857  1.00 48.55           N  
ATOM    662  N   THR    89      17.692  19.388  23.261  1.00 41.84           N  
ATOM    663  CA  THR    89      16.667  20.354  23.578  1.00 40.67           C  
ATOM    664  C   THR    89      15.751  20.638  22.388  1.00 39.96           C  
ATOM    665  O   THR    89      14.524  20.697  22.544  1.00 39.37           O  
ATOM    666  CB  THR    89      17.290  21.647  24.091  1.00 40.97           C  
ATOM    667  OG1 THR    89      17.883  21.385  25.363  1.00 41.62           O  
ATOM    668  CG2 THR    89      16.244  22.742  24.251  1.00 40.72           C  
ATOM    669  N   ALA    90      16.338  20.816  21.208  1.00 38.61           N  
ATOM    670  CA  ALA    90      15.552  21.081  20.004  1.00 37.69           C  
ATOM    671  C   ALA    90      14.692  19.851  19.685  1.00 36.75           C  
ATOM    672  O   ALA    90      13.558  19.938  19.240  1.00 35.66           O  
ATOM    673  CB  ALA    90      16.476  21.405  18.846  1.00 37.51           C  
ATOM    674  N   PHE    91      15.236  18.688  19.940  1.00 36.98           N  
ATOM    675  CA  PHE    91      14.496  17.474  19.649  1.00 36.00           C  
ATOM    676  C   PHE    91      13.246  17.372  20.529  1.00 36.57           C  
ATOM    677  O   PHE    91      12.120  17.292  20.032  1.00 34.89           O  
ATOM    678  CB  PHE    91      15.387  16.256  19.855  1.00 36.99           C  
ATOM    679  CG  PHE    91      14.620  14.973  19.985  1.00 35.67           C  
ATOM    680  CD1 PHE    91      13.551  14.704  19.143  1.00 38.06           C  
ATOM    681  CD2 PHE    91      14.934  14.059  20.977  1.00 36.48           C  
ATOM    682  CE1 PHE    91      12.827  13.483  19.261  1.00 36.10           C  
ATOM    683  CE2 PHE    91      14.205  12.875  21.113  1.00 37.37           C  
ATOM    684  CZ  PHE    91      13.151  12.607  20.255  1.00 36.55           C  
ATOM    685  N   VAL    92      13.476  17.404  21.841  1.00 37.94           N  
ATOM    686  CA  VAL    92      12.452  17.205  22.863  1.00 38.72           C  
ATOM    687  C   VAL    92      11.400  18.314  22.786  1.00 40.34           C  
ATOM    688  O   VAL    92      10.218  18.099  23.079  1.00 40.64           O  
ATOM    689  CB  VAL    92      13.129  17.126  24.261  1.00 38.71           C  
ATOM    690  CG1 VAL    92      12.144  17.330  25.406  1.00 38.25           C  
ATOM    691  CG2 VAL    92      13.867  15.772  24.400  1.00 38.04           C  
ATOM    692  N   GLU    93      11.837  19.492  22.366  1.00 41.44           N  
ATOM    693  CA  GLU    93      10.924  20.605  22.132  1.00 42.47           C  
ATOM    694  C   GLU    93      10.005  20.329  20.947  1.00 42.47           C  
ATOM    695  O   GLU    93       8.831  20.693  20.976  1.00 42.48           O  
ATOM    696  CB  GLU    93      11.703  21.891  21.919  1.00 42.35           C  
ATOM    697  CG  GLU    93      12.082  22.588  23.222  1.00 43.35           C  
ATOM    698  CD  GLU    93      12.877  23.865  22.983  1.00 44.62           C  
ATOM    699  OE1 GLU    93      13.485  23.974  21.886  1.00 48.71           O  
ATOM    700  OE2 GLU    93      12.904  24.749  23.879  1.00 44.16           O  
ATOM    701  N   ALA    94      10.529  19.659  19.923  1.00 42.55           N  
ATOM    702  CA  ALA    94       9.744  19.392  18.716  1.00 42.83           C  
ATOM    703  C   ALA    94       8.751  18.265  18.979  1.00 42.87           C  
ATOM    704  O   ALA    94       7.604  18.324  18.549  1.00 42.78           O  
ATOM    705  CB  ALA    94      10.647  19.072  17.533  1.00 42.51           C  
ATOM    706  N   LEU    95       9.197  17.259  19.719  1.00 43.07           N  
ATOM    707  CA  LEU    95       8.347  16.140  20.101  1.00 43.63           C  
ATOM    708  C   LEU    95       7.153  16.647  20.912  1.00 44.22           C  
ATOM    709  O   LEU    95       6.023  16.252  20.655  1.00 44.02           O  
ATOM    710  CB  LEU    95       9.150  15.113  20.916  1.00 43.35           C  
ATOM    711  CG  LEU    95       8.613  13.678  20.961  1.00 44.47           C  
ATOM    712  CD1 LEU    95       9.029  12.945  19.715  1.00 44.85           C  
ATOM    713  CD2 LEU    95       9.125  12.934  22.177  1.00 44.58           C  
ATOM    714  N   GLN    96       7.405  17.523  21.884  1.00 44.66           N  
ATOM    715  CA  GLN    96       6.337  18.010  22.767  1.00 45.73           C  
ATOM    716  C   GLN    96       5.367  18.947  22.041  1.00 45.50           C  
ATOM    717  O   GLN    96       4.181  18.988  22.371  1.00 44.91           O  
ATOM    718  CB  GLN    96       6.910  18.696  24.018  1.00 45.79           C  
ATOM    719  CG  GLN    96       7.446  17.716  25.079  1.00 47.48           C  
ATOM    720  CD  GLN    96       8.238  18.399  26.191  1.00 47.89           C  
ATOM    721  OE1 GLN    96       9.012  17.752  26.904  1.00 52.61           O  
ATOM    722  NE2 GLN    96       8.066  19.708  26.330  1.00 50.79           N  
ATOM    723  N   SER    97       5.879  19.689  21.058  1.00 45.59           N  
ATOM    724  CA  SER    97       5.062  20.610  20.267  1.00 45.39           C  
ATOM    725  C   SER    97       4.186  19.882  19.268  1.00 44.94           C  
ATOM    726  O   SER    97       2.999  20.197  19.144  1.00 44.29           O  
ATOM    727  CB  SER    97       5.946  21.573  19.489  1.00 45.21           C  
ATOM    728  OG  SER    97       6.738  22.327  20.376  1.00 47.85           O  
ATOM    729  N   GLU    98       4.770  18.909  18.563  1.00 44.39           N  
ATOM    730  CA  GLU    98       4.132  18.339  17.376  1.00 44.11           C  
ATOM    731  C   GLU    98       3.443  16.988  17.566  1.00 44.04           C  
ATOM    732  O   GLU    98       2.494  16.690  16.845  1.00 44.30           O  
ATOM    733  CB  GLU    98       5.128  18.292  16.212  1.00 43.90           C  
ATOM    734  CG  GLU    98       5.685  19.691  15.814  1.00 44.83           C  
ATOM    735  CD  GLU    98       4.638  20.610  15.166  1.00 43.08           C  
ATOM    736  N   TRP    99       3.888  16.174  18.519  1.00 43.90           N  
ATOM    737  CA  TRP    99       3.322  14.836  18.696  1.00 43.46           C  
ATOM    738  C   TRP    99       2.442  14.735  19.934  1.00 42.97           C  
ATOM    739  O   TRP    99       2.682  15.429  20.933  1.00 42.89           O  
ATOM    740  CB  TRP    99       4.432  13.775  18.781  1.00 44.11           C  
ATOM    741  CG  TRP    99       5.109  13.464  17.469  1.00 44.44           C  
ATOM    742  CD1 TRP    99       4.946  14.119  16.279  1.00 45.11           C  
ATOM    743  CD2 TRP    99       6.097  12.448  17.233  1.00 44.70           C  
ATOM    744  NE1 TRP    99       5.755  13.557  15.316  1.00 45.68           N  
ATOM    745  CE2 TRP    99       6.474  12.536  15.876  1.00 44.29           C  
ATOM    746  CE3 TRP    99       6.698  11.480  18.034  1.00 43.74           C  
ATOM    747  CZ2 TRP    99       7.421  11.695  15.306  1.00 44.86           C  
ATOM    748  CZ3 TRP    99       7.644  10.629  17.460  1.00 45.39           C  
ATOM    749  CH2 TRP    99       7.989  10.741  16.109  1.00 44.90           C  
ATOM    750  N   THR   100       1.425  13.871  19.839  1.00 41.65           N  
ATOM    751  CA  THR   100       0.652  13.383  20.981  1.00 41.00           C  
ATOM    752  C   THR   100       0.813  11.852  20.992  1.00 40.50           C  
ATOM    753  O   THR   100       1.514  11.314  20.141  1.00 40.72           O  
ATOM    754  CB  THR   100      -0.846  13.812  20.897  1.00 40.77           C  
ATOM    755  OG1 THR   100      -1.404  13.441  19.629  1.00 40.49           O  
ATOM    756  CG2 THR   100      -0.992  15.327  21.057  1.00 40.81           C  
ATOM    757  N   ASP   101       0.187  11.146  21.929  1.00 39.96           N  
ATOM    758  CA  ASP   101       0.385   9.675  22.036  1.00 40.12           C  
ATOM    759  C   ASP   101       0.125   8.875  20.757  1.00 39.90           C  
ATOM    760  O   ASP   101       0.769   7.839  20.539  1.00 39.45           O  
ATOM    761  CB  ASP   101      -0.492   9.063  23.133  1.00 40.35           C  
ATOM    762  CG  ASP   101      -0.235   9.655  24.507  1.00 41.58           C  
ATOM    763  OD1 ASP   101       0.874  10.173  24.753  1.00 43.38           O  
ATOM    764  OD2 ASP   101      -1.165   9.602  25.344  1.00 43.32           O  
ATOM    765  N   LYS   102      -0.849   9.317  19.950  1.00 39.81           N  
ATOM    766  CA  LYS   102      -1.244   8.609  18.724  1.00 39.58           C  
ATOM    767  C   LYS   102      -0.172   8.589  17.628  1.00 39.56           C  
ATOM    768  O   LYS   102      -0.036   7.594  16.897  1.00 40.62           O  
ATOM    769  CB  LYS   102      -2.572   9.146  18.167  1.00 39.80           C  
ATOM    770  CG  LYS   102      -2.571  10.528  17.525  1.00 39.75           C  
ATOM    771  CD  LYS   102      -4.014  10.963  17.217  1.00 40.05           C  
ATOM    772  CE  LYS   102      -4.091  12.418  16.750  1.00 41.68           C  
ATOM    773  NZ  LYS   102      -5.506  12.928  16.619  1.00 42.03           N  
ATOM    774  N   ASP   103       0.599   9.667  17.552  1.00 39.64           N  
ATOM    775  CA  ASP   103       1.687   9.806  16.598  1.00 39.19           C  
ATOM    776  C   ASP   103       2.753   8.704  16.736  1.00 38.64           C  
ATOM    777  O   ASP   103       3.510   8.433  15.799  1.00 38.48           O  
ATOM    778  CB  ASP   103       2.345  11.167  16.772  1.00 39.27           C  
ATOM    779  CG  ASP   103       1.439  12.312  16.386  1.00 39.58           C  
ATOM    780  OD1 ASP   103       1.247  12.555  15.174  1.00 40.37           O  
ATOM    781  OD2 ASP   103       0.932  13.000  17.297  1.00 40.06           O  
ATOM    782  N   LEU   104       2.825   8.086  17.909  1.00 37.92           N  
ATOM    783  CA  LEU   104       3.742   6.980  18.125  1.00 37.58           C  
ATOM    784  C   LEU   104       3.402   5.768  17.262  1.00 36.67           C  
ATOM    785  O   LEU   104       4.255   4.897  17.073  1.00 37.21           O  
ATOM    786  CB  LEU   104       3.771   6.579  19.598  1.00 37.60           C  
ATOM    787  CG  LEU   104       4.409   7.599  20.533  1.00 38.72           C  
ATOM    788  CD1 LEU   104       4.135   7.239  21.987  1.00 38.99           C  
ATOM    789  CD2 LEU   104       5.902   7.686  20.264  1.00 38.50           C  
ATOM    790  N   THR   105       2.158   5.698  16.767  1.00 35.51           N  
ATOM    791  CA  THR   105       1.721   4.617  15.876  1.00 34.57           C  
ATOM    792  C   THR   105       1.897   4.923  14.386  1.00 33.86           C  
ATOM    793  O   THR   105       1.828   4.030  13.565  1.00 32.73           O  
ATOM    794  CB  THR   105       0.226   4.240  16.105  1.00 34.44           C  
ATOM    795  OG1 THR   105      -0.630   5.312  15.676  1.00 34.26           O  
ATOM    796  CG2 THR   105      -0.032   3.932  17.572  1.00 35.11           C  
ATOM    797  N   THR   106       2.078   6.184  14.009  1.00 33.40           N  
ATOM    798  CA  THR   106       2.235   6.511  12.594  1.00 33.85           C  
ATOM    799  C   THR   106       3.410   5.787  11.976  1.00 35.81           C  
ATOM    800  O   THR   106       4.544   5.879  12.469  1.00 36.15           O  
ATOM    801  CB  THR   106       2.433   8.013  12.428  1.00 34.10           C  
ATOM    802  OG1 THR   106       1.414   8.638  13.188  1.00 31.30           O  
ATOM    803  CG2 THR   106       2.327   8.420  10.959  1.00 34.03           C  
ATOM    804  N   ILE   107       3.132   5.025  10.920  1.00 38.13           N  
ATOM    805  CA  ILE   107       4.158   4.261  10.213  1.00 39.30           C  
ATOM    806  C   ILE   107       4.981   5.173   9.307  1.00 40.57           C  
ATOM    807  O   ILE   107       4.429   5.895   8.477  1.00 40.68           O  
ATOM    808  CB  ILE   107       3.529   3.114   9.412  1.00 39.46           C  
ATOM    809  CG1 ILE   107       3.043   2.027  10.371  1.00 39.21           C  
ATOM    810  CG2 ILE   107       4.549   2.512   8.452  1.00 41.13           C  
ATOM    811  CD1 ILE   107       2.244   0.962   9.685  1.00 38.98           C  
ATOM    812  N   ASN   108       6.302   5.183   9.514  1.00 41.61           N  
ATOM    813  CA  ASN   108       7.226   5.941   8.673  1.00 42.13           C  
ATOM    814  C   ASN   108       8.345   5.016   8.148  1.00 43.07           C  
ATOM    815  O   ASN   108       8.456   3.821   8.511  1.00 43.07           O  
ATOM    816  CB  ASN   108       7.791   7.132   9.443  1.00 42.42           C  
ATOM    817  CG  ASN   108       6.890   8.360   9.402  1.00 43.28           C  
ATOM    818  OD1 ASN   108       6.703   8.971   8.351  1.00 42.03           O  
ATOM    819  ND2 ASN   108       6.370   8.759  10.563  1.00 45.25           N  
ATOM    820  N   ASP   109       9.155   5.564   7.259  1.00 44.42           N  
ATOM    821  CA  ASP   109      10.191   4.796   6.604  1.00 45.61           C  
ATOM    822  C   ASP   109      11.493   4.922   7.361  1.00 45.73           C  
ATOM    823  O   ASP   109      12.034   6.025   7.476  1.00 44.24           O  
ATOM    824  CB  ASP   109      10.394   5.295   5.178  1.00 46.20           C  
ATOM    825  CG  ASP   109      11.490   4.541   4.457  1.00 48.35           C  
ATOM    826  OD1 ASP   109      11.393   3.292   4.368  1.00 54.39           O  
ATOM    827  OD2 ASP   109      12.451   5.188   3.989  1.00 51.03           O  
ATOM    828  N   PHE   110      12.011   3.805   7.872  1.00 46.52           N  
ATOM    829  CA  PHE   110      13.354   3.834   8.470  1.00 47.64           C  
ATOM    830  C   PHE   110      14.370   3.250   7.512  1.00 48.40           C  
ATOM    831  O   PHE   110      14.465   2.031   7.360  1.00 46.87           O  
ATOM    832  CB  PHE   110      13.432   3.133   9.827  1.00 48.31           C  
ATOM    833  CG  PHE   110      14.798   3.279  10.495  1.00 49.63           C  
ATOM    834  CD1 PHE   110      15.256   4.535  10.910  1.00 49.78           C  
ATOM    835  CD2 PHE   110      15.640   2.190  10.660  1.00 51.36           C  
ATOM    836  CE1 PHE   110      16.530   4.685  11.507  1.00 50.52           C  
ATOM    837  CE2 PHE   110      16.911   2.336  11.254  1.00 50.54           C  
ATOM    838  CZ  PHE   110      17.346   3.587  11.685  1.00 51.58           C  
ATOM    839  N   PHE   111      15.103   4.133   6.839  1.00 49.53           N  
ATOM    840  CA  PHE   111      16.111   3.712   5.870  1.00 51.07           C  
ATOM    841  C   PHE   111      15.669   2.458   5.100  1.00 51.26           C  
ATOM    842  O   PHE   111      16.360   1.437   5.113  1.00 51.68           O  
ATOM    843  CB  PHE   111      17.452   3.440   6.570  1.00 51.89           C  
ATOM    844  CG  PHE   111      17.985   4.614   7.351  1.00 52.62           C  
ATOM    845  CD1 PHE   111      18.174   5.854   6.733  1.00 54.80           C  
ATOM    846  CD2 PHE   111      18.287   4.487   8.692  1.00 52.93           C  
ATOM    847  CE1 PHE   111      18.658   6.948   7.451  1.00 53.82           C  
ATOM    848  CE2 PHE   111      18.773   5.575   9.419  1.00 54.61           C  
ATOM    849  CZ  PHE   111      18.955   6.808   8.787  1.00 53.77           C  
ATOM    850  N   GLY   112      14.504   2.524   4.466  1.00 51.34           N  
ATOM    851  CA  GLY   112      14.030   1.412   3.625  1.00 51.36           C  
ATOM    852  C   GLY   112      12.917   0.541   4.188  1.00 51.10           C  
ATOM    853  O   GLY   112      12.110   0.033   3.426  1.00 51.41           O  
ATOM    854  N   ARG   113      12.864   0.349   5.506  1.00 50.84           N  
ATOM    855  CA  ARG   113      11.790  -0.462   6.103  1.00 50.80           C  
ATOM    856  C   ARG   113      10.723   0.413   6.788  1.00 49.66           C  
ATOM    857  O   ARG   113      11.048   1.428   7.389  1.00 49.62           O  
ATOM    858  CB  ARG   113      12.348  -1.553   7.040  1.00 51.29           C  
ATOM    859  CG  ARG   113      13.239  -1.084   8.214  1.00 52.28           C  
ATOM    860  CD  ARG   113      14.124  -2.262   8.714  1.00 52.16           C  
ATOM    861  N   PRO   114       9.435   0.047   6.649  1.00 48.76           N  
ATOM    862  CA  PRO   114       8.375   0.810   7.306  1.00 47.97           C  
ATOM    863  C   PRO   114       8.189   0.360   8.759  1.00 46.80           C  
ATOM    864  O   PRO   114       8.054  -0.825   9.027  1.00 47.46           O  
ATOM    865  CB  PRO   114       7.140   0.506   6.449  1.00 47.96           C  
ATOM    866  CG  PRO   114       7.379  -0.877   5.941  1.00 48.86           C  
ATOM    867  CD  PRO   114       8.887  -1.082   5.872  1.00 49.07           C  
ATOM    868  N   MET   115       8.177   1.318   9.678  0.50 46.47           N  
ATOM    870  CA  MET   115       8.056   1.030  11.103  0.50 45.86           C  
ATOM    872  C   MET   115       7.291   2.168  11.788  0.50 44.88           C  
ATOM    874  O   MET   115       7.359   3.309  11.343  0.50 44.01           O  
ATOM    876  CB  MET   115       9.451   0.898  11.739  0.50 46.26           C  
ATOM    878  CG  MET   115      10.313  -0.248  11.193  0.50 47.41           C  
ATOM    880  SD  MET   115       9.615  -1.997  11.588  0.38 50.15          SE  
ATOM    882  CE  MET   115      10.573  -2.363  13.234  0.50 47.61           C  
ATOM    884  N   PRO   116       6.549   1.854  12.864  1.00 43.99           N  
ATOM    885  CA  PRO   116       5.908   2.915  13.646  1.00 43.79           C  
ATOM    886  C   PRO   116       6.908   3.920  14.251  1.00 43.02           C  
ATOM    887  O   PRO   116       8.073   3.608  14.453  1.00 43.43           O  
ATOM    888  CB  PRO   116       5.140   2.150  14.737  1.00 43.24           C  
ATOM    889  CG  PRO   116       5.546   0.747  14.654  1.00 43.88           C  
ATOM    890  CD  PRO   116       6.238   0.505  13.371  1.00 43.91           C  
ATOM    891  N   ASN   117       6.469   5.128  14.529  1.00 43.16           N  
ATOM    892  CA  ASN   117       7.364   6.096  15.140  1.00 42.24           C  
ATOM    893  C   ASN   117       8.000   5.609  16.448  1.00 42.64           C  
ATOM    894  O   ASN   117       9.145   5.941  16.721  1.00 41.88           O  
ATOM    895  CB  ASN   117       6.677   7.436  15.340  1.00 42.23           C  
ATOM    896  CG  ASN   117       6.544   8.202  14.055  1.00 40.47           C  
ATOM    897  OD1 ASN   117       7.400   8.099  13.181  1.00 38.78           O  
ATOM    898  ND2 ASN   117       5.470   8.955  13.918  1.00 38.60           N  
ATOM    899  N   SER   118       7.285   4.802  17.231  1.00 42.46           N  
ATOM    900  CA  SER   118       7.817   4.322  18.514  1.00 42.93           C  
ATOM    901  C   SER   118       9.114   3.502  18.368  1.00 43.27           C  
ATOM    902  O   SER   118       9.988   3.534  19.238  1.00 43.99           O  
ATOM    903  CB  SER   118       6.773   3.497  19.258  1.00 42.42           C  
ATOM    904  OG  SER   118       6.295   2.479  18.432  1.00 41.62           O  
ATOM    905  N   ILE   119       9.237   2.797  17.258  1.00 43.05           N  
ATOM    906  CA  ILE   119      10.407   1.994  16.975  1.00 42.90           C  
ATOM    907  C   ILE   119      11.566   2.922  16.605  1.00 41.18           C  
ATOM    908  O   ILE   119      12.708   2.727  17.031  1.00 40.63           O  
ATOM    909  CB  ILE   119      10.119   0.981  15.854  1.00 42.76           C  
ATOM    910  CG1 ILE   119       9.021  -0.010  16.269  1.00 44.12           C  
ATOM    911  CG2 ILE   119      11.356   0.189  15.505  1.00 44.93           C  
ATOM    912  CD1 ILE   119       9.352  -0.890  17.475  1.00 45.27           C  
ATOM    913  N   PHE   120      11.295   3.973  15.853  1.00 40.62           N  
ATOM    914  CA  PHE   120      12.348   4.973  15.652  1.00 39.21           C  
ATOM    915  C   PHE   120      12.948   5.328  17.000  1.00 39.52           C  
ATOM    916  O   PHE   120      14.185   5.420  17.164  1.00 37.20           O  
ATOM    917  CB  PHE   120      11.821   6.234  15.001  1.00 39.58           C  
ATOM    918  CG  PHE   120      11.571   6.107  13.531  1.00 39.72           C  
ATOM    919  CD1 PHE   120      10.412   5.516  13.048  1.00 39.04           C  
ATOM    920  CD2 PHE   120      12.487   6.596  12.623  1.00 38.89           C  
ATOM    921  CE1 PHE   120      10.182   5.415  11.703  1.00 37.81           C  
ATOM    922  CE2 PHE   120      12.241   6.509  11.278  1.00 39.88           C  
ATOM    923  CZ  PHE   120      11.099   5.880  10.817  1.00 38.14           C  
ATOM    924  N   LEU   121      12.060   5.568  17.965  1.00 40.36           N  
ATOM    925  CA  LEU   121      12.462   6.141  19.252  1.00 40.88           C  
ATOM    926  C   LEU   121      13.201   5.076  20.060  1.00 41.08           C  
ATOM    927  O   LEU   121      14.167   5.373  20.736  1.00 41.03           O  
ATOM    928  CB  LEU   121      11.251   6.666  20.044  1.00 39.89           C  
ATOM    929  CG  LEU   121      10.589   7.958  19.555  1.00 40.55           C  
ATOM    930  CD1 LEU   121       9.500   8.383  20.498  1.00 36.76           C  
ATOM    931  CD2 LEU   121      11.587   9.034  19.411  1.00 37.03           C  
ATOM    932  N   MET   122      12.732   3.839  19.983  1.00 42.59           N  
ATOM    933  CA  MET   122      13.398   2.724  20.632  1.00 44.24           C  
ATOM    934  C   MET   122      14.806   2.595  20.071  1.00 43.62           C  
ATOM    935  O   MET   122      15.748   2.275  20.792  1.00 43.80           O  
ATOM    936  CB  MET   122      12.626   1.429  20.368  1.00 44.26           C  
ATOM    937  CG  MET   122      13.187   0.214  21.018  1.00 45.86           C  
ATOM    938  SD  MET   122      12.557  -1.437  20.132  0.75 51.63          SE  
ATOM    939  CE  MET   122      13.554  -1.285  18.357  1.00 45.57           C  
ATOM    940  N   THR   123      14.928   2.831  18.769  1.00 43.14           N  
ATOM    941  CA  THR   123      16.176   2.644  18.056  1.00 42.91           C  
ATOM    942  C   THR   123      17.158   3.733  18.461  1.00 42.21           C  
ATOM    943  O   THR   123      18.335   3.460  18.652  1.00 41.89           O  
ATOM    944  CB  THR   123      15.935   2.539  16.496  1.00 43.39           C  
ATOM    945  OG1 THR   123      15.197   1.332  16.211  1.00 42.69           O  
ATOM    946  CG2 THR   123      17.277   2.521  15.712  1.00 43.20           C  
ATOM    947  N   LEU   124      16.659   4.957  18.632  1.00 41.77           N  
ATOM    948  CA  LEU   124      17.475   6.046  19.083  1.00 41.19           C  
ATOM    949  C   LEU   124      18.160   5.732  20.419  1.00 40.75           C  
ATOM    950  O   LEU   124      19.355   5.996  20.581  1.00 41.36           O  
ATOM    951  CB  LEU   124      16.623   7.307  19.230  1.00 40.93           C  
ATOM    952  CG  LEU   124      17.272   8.604  19.668  1.00 42.46           C  
ATOM    953  CD1 LEU   124      18.157   9.190  18.567  1.00 43.77           C  
ATOM    954  CD2 LEU   124      16.209   9.596  20.074  1.00 40.62           C  
ATOM    955  N   ILE   125      17.390   5.216  21.370  1.00 39.88           N  
ATOM    956  CA  ILE   125      17.882   4.938  22.718  1.00 39.12           C  
ATOM    957  C   ILE   125      18.893   3.817  22.712  1.00 38.38           C  
ATOM    958  O   ILE   125      19.932   3.928  23.361  1.00 37.70           O  
ATOM    959  CB  ILE   125      16.723   4.572  23.708  1.00 39.09           C  
ATOM    960  CG1 ILE   125      15.852   5.792  23.978  1.00 39.79           C  
ATOM    961  CG2 ILE   125      17.271   4.080  25.043  1.00 38.31           C  
ATOM    962  CD1 ILE   125      14.656   5.520  24.864  1.00 39.65           C  
ATOM    963  N   ASN   126      18.573   2.744  21.993  1.00 37.52           N  
ATOM    964  CA  ASN   126      19.421   1.576  21.890  1.00 37.33           C  
ATOM    965  C   ASN   126      20.784   1.868  21.247  1.00 37.26           C  
ATOM    966  O   ASN   126      21.834   1.440  21.754  1.00 34.80           O  
ATOM    967  CB  ASN   126      18.731   0.501  21.061  1.00 38.33           C  
ATOM    968  CG  ASN   126      17.650  -0.227  21.809  1.00 40.70           C  
ATOM    969  OD1 ASN   126      17.448  -0.023  23.011  1.00 44.17           O  
ATOM    970  ND2 ASN   126      16.942  -1.105  21.098  1.00 40.57           N  
ATOM    971  N   HIS   127      20.745   2.631  20.149  1.00 37.71           N  
ATOM    972  CA  HIS   127      21.946   3.060  19.420  1.00 37.67           C  
ATOM    973  C   HIS   127      22.850   3.873  20.342  1.00 38.98           C  
ATOM    974  O   HIS   127      24.033   3.565  20.464  1.00 39.22           O  
ATOM    975  CB  HIS   127      21.545   3.859  18.163  1.00 37.87           C  
ATOM    976  CG  HIS   127      22.698   4.444  17.394  1.00 35.17           C  
ATOM    977  ND1 HIS   127      23.003   5.788  17.416  1.00 36.73           N  
ATOM    978  CD2 HIS   127      23.596   3.870  16.561  1.00 31.82           C  
ATOM    979  CE1 HIS   127      24.052   6.011  16.635  1.00 36.20           C  
ATOM    980  NE2 HIS   127      24.431   4.859  16.110  1.00 36.17           N  
ATOM    981  N   GLN   128      22.284   4.910  20.959  1.00 39.54           N  
ATOM    982  CA  GLN   128      22.991   5.785  21.878  1.00 39.52           C  
ATOM    983  C   GLN   128      23.639   5.025  23.041  1.00 40.57           C  
ATOM    984  O   GLN   128      24.742   5.354  23.454  1.00 40.88           O  
ATOM    985  CB  GLN   128      22.031   6.804  22.432  1.00 39.57           C  
ATOM    986  CG  GLN   128      22.707   7.895  23.259  1.00 39.96           C  
ATOM    987  CD  GLN   128      21.758   8.933  23.719  1.00 41.12           C  
ATOM    988  OE1 GLN   128      21.881  10.106  23.351  1.00 40.43           O  
ATOM    989  NE2 GLN   128      20.781   8.525  24.537  1.00 40.41           N  
ATOM    990  N   ASN   129      22.938   4.011  23.545  1.00 39.82           N  
ATOM    991  CA  ASN   129      23.372   3.238  24.700  1.00 40.21           C  
ATOM    992  C   ASN   129      24.546   2.321  24.330  1.00 39.31           C  
ATOM    993  O   ASN   129      25.484   2.146  25.103  1.00 37.84           O  
ATOM    994  CB  ASN   129      22.177   2.428  25.230  1.00 40.29           C  
ATOM    995  CG  ASN   129      22.493   1.635  26.501  1.00 43.51           C  
ATOM    996  OD1 ASN   129      23.480   1.893  27.194  1.00 47.46           O  
ATOM    997  ND2 ASN   129      21.635   0.670  26.813  1.00 42.77           N  
ATOM    998  N   HIS   130      24.484   1.738  23.139  1.00 39.10           N  
ATOM    999  CA  HIS   130      25.593   0.936  22.613  1.00 39.02           C  
ATOM   1000  C   HIS   130      26.897   1.733  22.570  1.00 38.12           C  
ATOM   1001  O   HIS   130      27.934   1.271  23.066  1.00 38.39           O  
ATOM   1002  CB  HIS   130      25.256   0.453  21.204  1.00 39.29           C  
ATOM   1003  CG  HIS   130      26.436  -0.046  20.435  1.00 39.26           C  
ATOM   1004  ND1 HIS   130      27.062  -1.242  20.720  1.00 38.14           N  
ATOM   1005  CD2 HIS   130      27.077   0.472  19.358  1.00 38.78           C  
ATOM   1006  CE1 HIS   130      28.049  -1.429  19.861  1.00 39.64           C  
ATOM   1007  NE2 HIS   130      28.076  -0.408  19.022  1.00 37.62           N  
ATOM   1008  N   HIS   131      26.827   2.903  21.955  1.00 37.71           N  
ATOM   1009  CA  HIS   131      27.988   3.785  21.779  1.00 37.24           C  
ATOM   1010  C   HIS   131      28.470   4.463  23.054  1.00 36.58           C  
ATOM   1011  O   HIS   131      29.678   4.713  23.234  1.00 35.94           O  
ATOM   1012  CB  HIS   131      27.678   4.853  20.735  1.00 36.93           C  
ATOM   1013  CG  HIS   131      27.717   4.354  19.332  1.00 37.60           C  
ATOM   1014  ND1 HIS   131      28.868   3.884  18.747  1.00 36.87           N  
ATOM   1015  CD2 HIS   131      26.747   4.253  18.390  1.00 37.91           C  
ATOM   1016  CE1 HIS   131      28.609   3.523  17.505  1.00 37.78           C  
ATOM   1017  NE2 HIS   131      27.336   3.754  17.261  1.00 34.19           N  
ATOM   1018  N   ARG   132      27.543   4.804  23.941  1.00 35.76           N  
ATOM   1019  CA  ARG   132      27.938   5.285  25.276  1.00 34.80           C  
ATOM   1020  C   ARG   132      28.688   4.161  26.034  1.00 33.64           C  
ATOM   1021  O   ARG   132      29.653   4.410  26.732  1.00 34.61           O  
ATOM   1022  CB  ARG   132      26.708   5.777  26.034  1.00 34.99           C  
ATOM   1023  CG  ARG   132      26.991   6.320  27.405  1.00 35.58           C  
ATOM   1024  CD  ARG   132      25.714   6.783  28.055  1.00 36.45           C  
ATOM   1025  NE  ARG   132      24.850   5.641  28.286  1.00 37.68           N  
ATOM   1026  CZ  ARG   132      23.521   5.686  28.360  1.00 38.30           C  
ATOM   1027  NH1 ARG   132      22.846   6.823  28.219  1.00 39.14           N  
ATOM   1028  NH2 ARG   132      22.870   4.562  28.571  1.00 39.80           N  
ATOM   1029  N   GLY   133      28.280   2.922  25.844  1.00 32.34           N  
ATOM   1030  CA  GLY   133      28.989   1.783  26.409  1.00 31.59           C  
ATOM   1031  C   GLY   133      30.444   1.793  25.950  1.00 32.06           C  
ATOM   1032  O   GLY   133      31.351   1.540  26.737  1.00 30.70           O  
ATOM   1033  N   GLN   134      30.653   2.096  24.657  1.00 31.73           N  
ATOM   1034  CA  GLN   134      31.993   2.201  24.073  1.00 31.14           C  
ATOM   1035  C   GLN   134      32.742   3.366  24.677  1.00 31.57           C  
ATOM   1036  O   GLN   134      33.901   3.248  25.057  1.00 31.15           O  
ATOM   1037  CB  GLN   134      31.891   2.422  22.556  1.00 31.55           C  
ATOM   1038  CG  GLN   134      31.237   1.280  21.816  1.00 30.22           C  
ATOM   1039  CD  GLN   134      31.205   1.457  20.280  1.00 30.87           C  
ATOM   1040  OE1 GLN   134      31.000   2.551  19.773  1.00 31.06           O  
ATOM   1041  NE2 GLN   134      31.352   0.342  19.553  1.00 30.25           N  
ATOM   1042  N   MET   135      32.076   4.505  24.775  1.00 32.32           N  
ATOM   1043  CA  MET   135      32.726   5.670  25.337  1.00 32.89           C  
ATOM   1044  C   MET   135      33.338   5.397  26.707  1.00 33.44           C  
ATOM   1045  O   MET   135      34.440   5.908  27.011  1.00 35.37           O  
ATOM   1046  CB  MET   135      31.764   6.835  25.458  1.00 32.64           C  
ATOM   1047  CG  MET   135      31.184   7.333  24.230  1.00 32.39           C  
ATOM   1048  SD  MET   135      30.930   9.293  24.527  0.75 35.42          SE  
ATOM   1049  CE  MET   135      29.463   9.275  25.594  1.00 34.05           C  
ATOM   1050  N   THR   136      32.638   4.614  27.540  1.00 33.67           N  
ATOM   1051  CA  THR   136      33.069   4.336  28.906  1.00 33.46           C  
ATOM   1052  C   THR   136      34.411   3.620  28.966  1.00 33.57           C  
ATOM   1053  O   THR   136      35.226   3.956  29.827  1.00 33.18           O  
ATOM   1054  CB  THR   136      31.974   3.629  29.797  1.00 34.12           C  
ATOM   1055  OG1 THR   136      31.679   2.298  29.339  1.00 33.45           O  
ATOM   1056  CG2 THR   136      30.694   4.480  29.887  1.00 34.20           C  
ATOM   1057  N   VAL   137      34.650   2.652  28.073  1.00 33.16           N  
ATOM   1058  CA  VAL   137      35.947   1.999  28.004  1.00 31.90           C  
ATOM   1059  C   VAL   137      37.024   3.017  27.608  1.00 32.75           C  
ATOM   1060  O   VAL   137      38.055   3.151  28.290  1.00 32.42           O  
ATOM   1061  CB  VAL   137      35.924   0.763  27.088  1.00 32.54           C  
ATOM   1062  CG1 VAL   137      37.310   0.088  27.014  1.00 30.39           C  
ATOM   1063  CG2 VAL   137      34.897  -0.219  27.585  1.00 30.37           C  
ATOM   1064  N   LEU   138      36.754   3.790  26.567  1.00 32.99           N  
ATOM   1065  CA  LEU   138      37.733   4.764  26.071  1.00 33.03           C  
ATOM   1066  C   LEU   138      38.023   5.878  27.082  1.00 33.16           C  
ATOM   1067  O   LEU   138      39.178   6.293  27.240  1.00 33.13           O  
ATOM   1068  CB  LEU   138      37.270   5.365  24.730  1.00 33.09           C  
ATOM   1069  CG  LEU   138      37.161   4.361  23.591  1.00 31.63           C  
ATOM   1070  CD1 LEU   138      36.442   4.958  22.359  1.00 31.53           C  
ATOM   1071  CD2 LEU   138      38.529   3.851  23.223  1.00 28.96           C  
ATOM   1072  N   MET   139      36.987   6.357  27.760  1.00 33.22           N  
ATOM   1073  CA  MET   139      37.166   7.366  28.827  1.00 32.98           C  
ATOM   1074  C   MET   139      38.103   6.866  29.938  1.00 33.25           C  
ATOM   1075  O   MET   139      39.005   7.570  30.356  1.00 32.78           O  
ATOM   1076  CB  MET   139      35.820   7.780  29.415  1.00 33.36           C  
ATOM   1077  CG  MET   139      34.918   8.630  28.492  1.00 32.73           C  
ATOM   1078  SD  MET   139      33.085   8.665  29.128  0.75 30.52          SE  
ATOM   1079  CE  MET   139      32.541   7.010  28.489  1.00 37.70           C  
ATOM   1080  N   ARG   140      37.892   5.632  30.376  1.00 33.99           N  
ATOM   1081  CA  ARG   140      38.755   4.960  31.357  1.00 34.31           C  
ATOM   1082  C   ARG   140      40.199   4.928  30.866  1.00 34.39           C  
ATOM   1083  O   ARG   140      41.151   5.218  31.601  1.00 34.22           O  
ATOM   1084  CB  ARG   140      38.296   3.497  31.528  1.00 35.08           C  
ATOM   1085  CG  ARG   140      37.921   3.085  32.923  1.00 36.93           C  
ATOM   1086  CD  ARG   140      36.405   3.172  33.147  1.00 39.40           C  
ATOM   1087  N   GLN   141      40.353   4.543  29.606  1.00 34.09           N  
ATOM   1088  CA  GLN   141      41.661   4.424  28.977  1.00 33.28           C  
ATOM   1089  C   GLN   141      42.325   5.785  28.806  1.00 33.33           C  
ATOM   1090  O   GLN   141      43.552   5.878  28.835  1.00 33.32           O  
ATOM   1091  CB  GLN   141      41.520   3.683  27.657  1.00 32.82           C  
ATOM   1092  CG  GLN   141      41.363   2.197  27.917  1.00 31.72           C  
ATOM   1093  CD  GLN   141      40.902   1.407  26.735  1.00 29.68           C  
ATOM   1094  OE1 GLN   141      40.531   1.974  25.712  1.00 30.80           O  
ATOM   1095  NE2 GLN   141      40.907   0.076  26.868  1.00 24.28           N  
ATOM   1096  N   ALA   142      41.527   6.837  28.693  1.00 32.84           N  
ATOM   1097  CA  ALA   142      42.065   8.191  28.666  1.00 33.41           C  
ATOM   1098  C   ALA   142      42.404   8.762  30.041  1.00 34.75           C  
ATOM   1099  O   ALA   142      42.844   9.900  30.119  1.00 35.04           O  
ATOM   1100  CB  ALA   142      41.107   9.111  27.974  1.00 33.31           C  
ATOM   1101  N   GLY   143      42.182   7.997  31.107  1.00 35.67           N  
ATOM   1102  CA  GLY   143      42.444   8.465  32.473  1.00 36.87           C  
ATOM   1103  C   GLY   143      41.377   9.378  33.058  1.00 37.96           C  
ATOM   1104  O   GLY   143      41.661  10.162  33.986  1.00 37.88           O  
ATOM   1105  N   LEU   144      40.153   9.293  32.531  1.00 38.67           N  
ATOM   1106  CA  LEU   144      39.039  10.087  33.046  1.00 39.74           C  
ATOM   1107  C   LEU   144      38.243   9.266  34.055  1.00 41.04           C  
ATOM   1108  O   LEU   144      38.272   8.033  34.042  1.00 41.16           O  
ATOM   1109  CB  LEU   144      38.115  10.554  31.904  1.00 39.79           C  
ATOM   1110  CG  LEU   144      38.750  11.388  30.784  1.00 39.05           C  
ATOM   1111  CD1 LEU   144      37.741  11.652  29.658  1.00 37.45           C  
ATOM   1112  CD2 LEU   144      39.326  12.691  31.324  1.00 37.24           C  
ATOM   1113  N   THR   145      37.532   9.955  34.939  1.00 42.81           N  
ATOM   1114  CA  THR   145      36.675   9.292  35.916  1.00 43.91           C  
ATOM   1115  C   THR   145      35.292   9.190  35.292  1.00 44.95           C  
ATOM   1116  O   THR   145      34.691  10.213  34.976  1.00 45.22           O  
ATOM   1117  CB  THR   145      36.637  10.071  37.272  1.00 43.99           C  
ATOM   1118  N   VAL   146      34.804   7.967  35.078  1.00 46.59           N  
ATOM   1119  CA  VAL   146      33.513   7.753  34.406  1.00 47.92           C  
ATOM   1120  C   VAL   146      32.374   7.775  35.425  1.00 49.33           C  
ATOM   1121  O   VAL   146      32.372   6.954  36.348  1.00 49.23           O  
ATOM   1122  CB  VAL   146      33.440   6.392  33.644  1.00 47.94           C  
ATOM   1123  CG1 VAL   146      32.086   6.219  32.986  1.00 47.64           C  
ATOM   1124  CG2 VAL   146      34.524   6.286  32.608  1.00 47.28           C  
ATOM   1125  N   PRO   147      31.418   8.721  35.280  1.00 50.94           N  
ATOM   1126  CA  PRO   147      30.191   8.590  36.084  1.00 52.30           C  
ATOM   1127  C   PRO   147      29.379   7.337  35.681  1.00 53.55           C  
ATOM   1128  O   PRO   147      29.364   6.959  34.504  1.00 54.31           O  
ATOM   1129  CB  PRO   147      29.432   9.895  35.801  1.00 52.10           C  
ATOM   1130  CG  PRO   147      30.019  10.431  34.537  1.00 51.92           C  
ATOM   1131  CD  PRO   147      31.418   9.940  34.447  1.00 50.72           C  
ATOM   1132  N   GLY   148      28.741   6.691  36.653  1.00 54.81           N  
ATOM   1133  CA  GLY   148      28.048   5.415  36.423  1.00 55.64           C  
ATOM   1134  C   GLY   148      26.796   5.497  35.556  1.00 56.25           C  
ATOM   1135  O   GLY   148      26.265   6.585  35.318  1.00 56.77           O  
ATOM   1136  N   VAL   149      26.355   4.333  35.066  1.00 56.83           N  
ATOM   1137  CA  VAL   149      25.069   4.165  34.366  1.00 57.00           C  
ATOM   1138  C   VAL   149      24.507   2.753  34.644  1.00 57.36           C  
ATOM   1139  O   VAL   149      25.260   1.768  34.683  1.00 57.45           O  
ATOM   1140  CB  VAL   149      25.194   4.411  32.825  1.00 56.97           C  
ATOM   1141  CG1 VAL   149      25.952   3.287  32.158  1.00 56.88           C  
ATOM   1142  CG2 VAL   149      23.807   4.585  32.169  1.00 56.07           C  
ATOM   1143  N   TYR   150      23.187   2.668  34.834  1.00 57.52           N  
ATOM   1144  CA  TYR   150      22.495   1.406  35.158  1.00 57.45           C  
ATOM   1145  C   TYR   150      23.080   0.739  36.395  1.00 57.47           C  
ATOM   1146  O   TYR   150      23.301   1.402  37.405  1.00 57.84           O  
ATOM   1147  CB  TYR   150      22.503   0.438  33.960  1.00 57.31           C  
ATOM   1148  CG  TYR   150      21.973   1.059  32.682  1.00 57.19           C  
ATOM   1149  CD1 TYR   150      20.797   1.825  32.692  1.00 57.44           C  
ATOM   1150  CD2 TYR   150      22.638   0.897  31.466  1.00 57.06           C  
ATOM   1151  CE1 TYR   150      20.301   2.411  31.534  1.00 56.37           C  
ATOM   1152  CE2 TYR   150      22.142   1.491  30.290  1.00 56.34           C  
ATOM   1153  CZ  TYR   150      20.975   2.243  30.345  1.00 56.39           C  
ATOM   1154  OH  TYR   150      20.455   2.825  29.223  1.00 56.70           O  
END
