
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  189 ( 1576),  selected  189 , name 2rd9_A
# Molecule2: number of CA atoms  150 ( 1146),  selected  150 , name T0406.pdb
# PARAMETERS: 2rd9_A.T0406.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K   -14_A      -       -           -
LGA    I   -13_A      -       -           -
LGA    H   -12_A      -       -           -
LGA    H   -11_A      -       -           -
LGA    H   -10_A      -       -           -
LGA    H    -9_A      -       -           -
LGA    H    -8_A      -       -           -
LGA    H    -7_A      -       -           -
LGA    E    -6_A      -       -           -
LGA    N    -5_A      -       -           -
LGA    L    -4_A      -       -           -
LGA    Y    -3_A      -       -           -
LGA    F    -2_A      -       -           -
LGA    Q    -1_A      -       -           -
LGA    G     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    N     2_A      M       1           #
LGA    F     3_A      Y       2          4.281
LGA    Q     4_A      Q       3           #
LGA    -       -      T       4           -
LGA    -       -      I       5           -
LGA    -       -      E       6           -
LGA    -       -      G       7           -
LGA    X     5_A      F       8          1.590
LGA    N     6_A      L       9          3.235
LGA    E     7_A      Q      10          2.717
LGA    A     8_A      S      11          2.617
LGA    I     9_A      W      12          2.426
LGA    Q    10_A      T      13          1.677
LGA    L    11_A      Y      14          2.805
LGA    L    12_A      E      15          4.270
LGA    E    13_A      T      16          3.560
LGA    R    14_A      E      17          1.391
LGA    T    15_A      S      18          4.367
LGA    P    16_A      T      19          4.727
LGA    K    17_A      Q      20          2.553
LGA    T    18_A      K      21          1.543
LGA    L    19_A      M      22          2.183
LGA    E    20_A      L      23          3.068
LGA    V    21_A      D      24          3.564
LGA    F    22_A      V      25          3.231
LGA    L    23_A      L      26          2.182
LGA    E    24_A      T      27          4.715
LGA    G    25_A      D      28           -
LGA    L    26_A      -       -           -
LGA    S    27_A      -       -           -
LGA    D    28_A      E      29          1.174
LGA    S    29_A      -       -           -
LGA    W    30_A      S      30          3.111
LGA    H    31_A      L      31          2.640
LGA    Q    32_A      S      32          1.799
LGA    C    33_A      Q      33          1.614
LGA    N    34_A      E      34          2.298
LGA    E    35_A      I      35          1.902
LGA    G    36_A      A      36          1.034
LGA    Y    37_A      P      37          2.982
LGA    E    38_A      G      38          3.364
LGA    T    39_A      H      39          2.609
LGA    W    40_A      W      40          1.557
LGA    T    41_A      T      41          1.065
LGA    V    42_A      L      42          1.078
LGA    Y    43_A      G      43          0.975
LGA    E    44_A      R      44          1.063
LGA    V    45_A      V      45          1.438
LGA    V    46_A      A      46          1.631
LGA    V    47_A      W      47          1.658
LGA    H    48_A      H      48          1.543
LGA    L    49_A      I      49          1.959
LGA    I    50_A      V      50          2.395
LGA    E    51_A      T      51          1.921
LGA    A    52_A      A      52          1.927
LGA    E    53_A      I      53          3.109
LGA    K    54_A      P      54          3.868
LGA    T    55_A      -       -           -
LGA    N    56_A      V      55          0.936
LGA    W    57_A      I      56          3.075
LGA    I    58_A      L      57          3.225
LGA    P    59_A      S      58          2.162
LGA    R    60_A      G      59          2.132
LGA    L    61_A      T      60          1.911
LGA    R    62_A      G      61          1.249
LGA    F    63_A      L      62           #
LGA    I    64_A      K      63           -
LGA    L    65_A      F      64           -
LGA    Q    66_A      E      65           -
LGA    E    67_A      G      66           -
LGA    G    68_A      E      67           -
LGA    E    69_A      -       -           -
LGA    H    70_A      -       -           -
LGA    K    71_A      -       -           -
LGA    P    72_A      -       -           -
LGA    F    73_A      -       -           -
LGA    P    74_A      -       -           -
LGA    A    75_A      -       -           -
LGA    F    76_A      -       -           -
LGA    D    77_A      -       -           -
LGA    R    78_A      -       -           -
LGA    F    79_A      -       -           -
LGA    S    80_A      T      68           #
LGA    H    81_A      K      69          4.461
LGA    L    82_A      D      70           -
LGA    N    83_A      Y      71          3.038
LGA    Q    84_A      P      72          1.768
LGA    S    85_A      V      73          4.930
LGA    N    86_A      P      74          4.630
LGA    A    87_A      T      75          3.111
LGA    V    88_A      S      76          3.649
LGA    P    89_A      -       -           -
LGA    I    90_A      A      77          0.938
LGA    S    91_A      K      78          1.139
LGA    E    92_A      T      79          1.955
LGA    R    93_A      I      80          1.760
LGA    F    94_A      A      81          1.095
LGA    K    95_A      D      82          1.206
LGA    E    96_A      G      83          1.764
LGA    F    97_A      Y      84          1.517
LGA    Q    98_A      R      85          0.489
LGA    Q    99_A      K      86          0.855
LGA    L   100_A      V      87          1.094
LGA    R   101_A      N      88          0.900
LGA    K   102_A      T      89          0.789
LGA    E   103_A      A      90          0.875
LGA    N   104_A      F      91          0.711
LGA    L   105_A      V      92          0.838
LGA    N   106_A      E      93          0.739
LGA    T   107_A      A      94          0.700
LGA    L   108_A      L      95          1.550
LGA    R   109_A      Q      96          1.762
LGA    S   110_A      S      97          2.159
LGA    L   111_A      E      98          2.820
LGA    V   112_A      W      99          2.470
LGA    Q   113_A      T     100          1.196
LGA    S   114_A      D     101          1.141
LGA    E   115_A      -       -           -
LGA    A   116_A      K     102          2.184
LGA    D   117_A      D     103          1.669
LGA    L   118_A      L     104          1.277
LGA    E   119_A      T     105          1.711
LGA    R   120_A      T     106          1.643
LGA    T   121_A      I     107          1.025
LGA    G   122_A      N     108          1.702
LGA    A   123_A      D     109          2.646
LGA    H   124_A      F     110          2.959
LGA    P   125_A      F     111          4.039
LGA    A   126_A      G     112          3.649
LGA    F   127_A      -       -           -
LGA    G   128_A      R     113          2.432
LGA    V   129_A      P     114          2.289
LGA    V   130_A      M     115          0.865
LGA    K   131_A      P     116          1.279
LGA    V   132_A      N     117          0.906
LGA    R   133_A      S     118          0.957
LGA    E   134_A      I     119          0.672
LGA    L   135_A      F     120          0.540
LGA    L   136_A      L     121          0.344
LGA    S   137_A      M     122          0.686
LGA    A   138_A      T     123          0.726
LGA    W   139_A      L     124          0.691
LGA    V   140_A      I     125          0.967
LGA    V   141_A      N     126          1.299
LGA    H   142_A      H     127          1.705
LGA    D   143_A      Q     128          1.643
LGA    L   144_A      N     129          1.089
LGA    T   145_A      H     130          1.112
LGA    H   146_A      H     131          1.272
LGA    I   147_A      R     132          0.809
LGA    A   148_A      G     133          0.637
LGA    Q   149_A      Q     134          0.955
LGA    I   150_A      M     135          0.729
LGA    V   151_A      T     136          1.099
LGA    R   152_A      V     137          2.081
LGA    S   153_A      L     138          2.435
LGA    X   154_A      M     139          3.569
LGA    A   155_A      R     140          4.312
LGA    K   156_A      Q     141          5.307
LGA    R   157_A      A     142           #
LGA    Y   158_A      G     143           -
LGA    D   159_A      L     144           -
LGA    T   160_A      T     145           -
LGA    D   161_A      V     146           -
LGA    V   162_A      P     147           -
LGA    G   163_A      G     148           -
LGA    P   164_A      V     149           -
LGA    W   165_A      Y     150           -
LGA    K   166_A      -       -           -
LGA    E   167_A      -       -           -
LGA    Y   168_A      -       -           -
LGA    L   169_A      -       -           -
LGA    G   170_A      -       -           -
LGA    I   171_A      -       -           -
LGA    L   172_A      -       -           -
LGA    N   173_A      -       -           -
LGA    D   174_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  189  150    5.0    126    2.33    11.11     59.573     5.189

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.279239 * X  +  -0.932505 * Y  +  -0.229040 * Z  +  29.990000
  Y_new =   0.471141 * X  +  -0.074786 * Y  +   0.878882 * Z  + -150.445007
  Z_new =  -0.836691 * X  +  -0.353328 * Y  +   0.418459 * Z  +  54.132095 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.701209    2.440384  [ DEG:   -40.1763    139.8237 ]
  Theta =   0.991213    2.150380  [ DEG:    56.7923    123.2077 ]
  Phi   =   1.035772   -2.105820  [ DEG:    59.3454   -120.6546 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rd9_A                                        
REMARK     2: T0406.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rd9_A.T0406.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  189  150   5.0  126   2.33   11.11  59.573
REMARK  ---------------------------------------------------------- 
MOLECULE 2rd9_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   21-SEP-07   2RD9              
TITLE     CRYSTAL STRUCTURE OF YFIT-LIKE PUTATIVE METAL-DEPENDENT               
TITLE    2 HYDROLASE (NP_241052.1) FROM BACILLUS HALODURANS AT 2.30 A           
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BH0186 PROTEIN;                                            
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS HALODURANS C-125;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C-125, DSM 18197, FERM 7344, JCM 9153;                       
SOURCE   5 ATCC: BAA-125;                                                       
SOURCE   6 GENE: NP_241052.1, BH0186;                                           
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_241052.1, YFIT-LIKE PUTATIVE METAL-DEPENDENT HYDROLASE,            
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2, STRUCTURAL                
KEYWDS   4 GENOMICS, UNKNOWN FUNCTION                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   09-OCT-07 2RD9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF YFIT-LIKE PUTATIVE                      
JRNL        TITL 2 METAL-DEPENDENT HYDROLASE (NP_241052.1) FROM                 
JRNL        TITL 3 BACILLUS HALODURANS AT 2.30 A RESOLUTION                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2RD9 A    1   174  UNP    Q9KGB8   Q9KGB8_BACHD     1    174             
DBREF  2RD9 B    1   174  UNP    Q9KGB8   Q9KGB8_BACHD     1    174             
DBREF  2RD9 C    1   174  UNP    Q9KGB8   Q9KGB8_BACHD     1    174             
DBREF  2RD9 D    1   174  UNP    Q9KGB8   Q9KGB8_BACHD     1    174             
SEQRES   1 A  193  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  193  ASN LEU TYR PHE GLN GLY MSE ASN PHE GLN MSE ASN GLU          
SEQRES   3 A  193  ALA ILE GLN LEU LEU GLU ARG THR PRO LYS THR LEU GLU          
SEQRES   4 A  193  VAL PHE LEU GLU GLY LEU SER ASP SER TRP HIS GLN CYS          
SEQRES   5 A  193  ASN GLU GLY TYR GLU THR TRP THR VAL TYR GLU VAL VAL          
SEQRES   6 A  193  VAL HIS LEU ILE GLU ALA GLU LYS THR ASN TRP ILE PRO          
SEQRES   7 A  193  ARG LEU ARG PHE ILE LEU GLN GLU GLY GLU HIS LYS PRO          
SEQRES   8 A  193  PHE PRO ALA PHE ASP ARG PHE SER HIS LEU ASN GLN SER          
SEQRES   9 A  193  ASN ALA VAL PRO ILE SER GLU ARG PHE LYS GLU PHE GLN          
SEQRES  10 A  193  GLN LEU ARG LYS GLU ASN LEU ASN THR LEU ARG SER LEU          
SEQRES  11 A  193  VAL GLN SER GLU ALA ASP LEU GLU ARG THR GLY ALA HIS          
SEQRES  12 A  193  PRO ALA PHE GLY VAL VAL LYS VAL ARG GLU LEU LEU SER          
SEQRES  13 A  193  ALA TRP VAL VAL HIS ASP LEU THR HIS ILE ALA GLN ILE          
SEQRES  14 A  193  VAL ARG SER MSE ALA LYS ARG TYR ASP THR ASP VAL GLY          
SEQRES  15 A  193  PRO TRP LYS GLU TYR LEU GLY ILE LEU ASN ASP                  
SEQRES   1 B  193  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  193  ASN LEU TYR PHE GLN GLY MSE ASN PHE GLN MSE ASN GLU          
SEQRES   3 B  193  ALA ILE GLN LEU LEU GLU ARG THR PRO LYS THR LEU GLU          
SEQRES   4 B  193  VAL PHE LEU GLU GLY LEU SER ASP SER TRP HIS GLN CYS          
SEQRES   5 B  193  ASN GLU GLY TYR GLU THR TRP THR VAL TYR GLU VAL VAL          
SEQRES   6 B  193  VAL HIS LEU ILE GLU ALA GLU LYS THR ASN TRP ILE PRO          
SEQRES   7 B  193  ARG LEU ARG PHE ILE LEU GLN GLU GLY GLU HIS LYS PRO          
SEQRES   8 B  193  PHE PRO ALA PHE ASP ARG PHE SER HIS LEU ASN GLN SER          
SEQRES   9 B  193  ASN ALA VAL PRO ILE SER GLU ARG PHE LYS GLU PHE GLN          
SEQRES  10 B  193  GLN LEU ARG LYS GLU ASN LEU ASN THR LEU ARG SER LEU          
SEQRES  11 B  193  VAL GLN SER GLU ALA ASP LEU GLU ARG THR GLY ALA HIS          
SEQRES  12 B  193  PRO ALA PHE GLY VAL VAL LYS VAL ARG GLU LEU LEU SER          
SEQRES  13 B  193  ALA TRP VAL VAL HIS ASP LEU THR HIS ILE ALA GLN ILE          
SEQRES  14 B  193  VAL ARG SER MSE ALA LYS ARG TYR ASP THR ASP VAL GLY          
SEQRES  15 B  193  PRO TRP LYS GLU TYR LEU GLY ILE LEU ASN ASP                  
SEQRES   1 C  193  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 C  193  ASN LEU TYR PHE GLN GLY MSE ASN PHE GLN MSE ASN GLU          
SEQRES   3 C  193  ALA ILE GLN LEU LEU GLU ARG THR PRO LYS THR LEU GLU          
SEQRES   4 C  193  VAL PHE LEU GLU GLY LEU SER ASP SER TRP HIS GLN CYS          
SEQRES   5 C  193  ASN GLU GLY TYR GLU THR TRP THR VAL TYR GLU VAL VAL          
SEQRES   6 C  193  VAL HIS LEU ILE GLU ALA GLU LYS THR ASN TRP ILE PRO          
SEQRES   7 C  193  ARG LEU ARG PHE ILE LEU GLN GLU GLY GLU HIS LYS PRO          
SEQRES   8 C  193  PHE PRO ALA PHE ASP ARG PHE SER HIS LEU ASN GLN SER          
SEQRES   9 C  193  ASN ALA VAL PRO ILE SER GLU ARG PHE LYS GLU PHE GLN          
SEQRES  10 C  193  GLN LEU ARG LYS GLU ASN LEU ASN THR LEU ARG SER LEU          
SEQRES  11 C  193  VAL GLN SER GLU ALA ASP LEU GLU ARG THR GLY ALA HIS          
SEQRES  12 C  193  PRO ALA PHE GLY VAL VAL LYS VAL ARG GLU LEU LEU SER          
SEQRES  13 C  193  ALA TRP VAL VAL HIS ASP LEU THR HIS ILE ALA GLN ILE          
SEQRES  14 C  193  VAL ARG SER MSE ALA LYS ARG TYR ASP THR ASP VAL GLY          
SEQRES  15 C  193  PRO TRP LYS GLU TYR LEU GLY ILE LEU ASN ASP                  
SEQRES   1 D  193  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 D  193  ASN LEU TYR PHE GLN GLY MSE ASN PHE GLN MSE ASN GLU          
SEQRES   3 D  193  ALA ILE GLN LEU LEU GLU ARG THR PRO LYS THR LEU GLU          
SEQRES   4 D  193  VAL PHE LEU GLU GLY LEU SER ASP SER TRP HIS GLN CYS          
SEQRES   5 D  193  ASN GLU GLY TYR GLU THR TRP THR VAL TYR GLU VAL VAL          
SEQRES   6 D  193  VAL HIS LEU ILE GLU ALA GLU LYS THR ASN TRP ILE PRO          
SEQRES   7 D  193  ARG LEU ARG PHE ILE LEU GLN GLU GLY GLU HIS LYS PRO          
SEQRES   8 D  193  PHE PRO ALA PHE ASP ARG PHE SER HIS LEU ASN GLN SER          
SEQRES   9 D  193  ASN ALA VAL PRO ILE SER GLU ARG PHE LYS GLU PHE GLN          
SEQRES  10 D  193  GLN LEU ARG LYS GLU ASN LEU ASN THR LEU ARG SER LEU          
SEQRES  11 D  193  VAL GLN SER GLU ALA ASP LEU GLU ARG THR GLY ALA HIS          
SEQRES  12 D  193  PRO ALA PHE GLY VAL VAL LYS VAL ARG GLU LEU LEU SER          
SEQRES  13 D  193  ALA TRP VAL VAL HIS ASP LEU THR HIS ILE ALA GLN ILE          
SEQRES  14 D  193  VAL ARG SER MSE ALA LYS ARG TYR ASP THR ASP VAL GLY          
SEQRES  15 D  193  PRO TRP LYS GLU TYR LEU GLY ILE LEU ASN ASP                  
HET    MSE  A   1      16                                                       
HET    MSE  A   5       8                                                       
HET    MSE  A 154       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B   5       8                                                       
HET    MSE  B 154       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C   5       8                                                       
HET    MSE  C 154       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D   5       8                                                       
HET    MSE  D 154       8                                                       
HET     NI  A 300       1                                                       
HET     NI  C 300       1                                                       
HET     NI  B 300       1                                                       
HET     NI  D 300       1                                                       
HET    IMD  A 301       5                                                       
HET    IMD  C 301       5                                                       
HET    IMD  C 302       5                                                       
HET    IMD  A 302       5                                                       
HET    IMD  A 303       5                                                       
HET    GOL  A 304       6                                                       
HET    GOL  A 305       6                                                       
HET    GOL  D 301       6                                                       
HET    GOL  B 301       6                                                       
HET    GOL  D 302       6                                                       
HET    GOL  C 303       6                                                       
HET    GOL  A 306       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     IMD IMIDAZOLE                                                        
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    12(C5 H11 N O2 SE)                                           
FORMUL   5   NI    4(NI 2+)                                                     
FORMUL   9  IMD    5(C3 H5 N2 1+)                                               
FORMUL  14  GOL    7(C3 H8 O3)                                                  
FORMUL  21  HOH   *555(H2 O)                                                    
CRYST1  147.330  147.330  147.330  90.00  90.00  90.00 P 21 3       48          
ATOM      1  N   LYS A -14      19.450 -37.995  41.710  1.00 56.67           N  
ATOM      2  CA  LYS A -14      19.831 -36.601  41.297  1.00 56.49           C  
ATOM      3  C   LYS A -14      19.845 -36.452  39.747  1.00 54.48           C  
ATOM      4  O   LYS A -14      20.608 -37.122  39.022  1.00 55.34           O  
ATOM      5  CB  LYS A -14      21.166 -36.190  41.964  1.00 56.11           C  
ATOM      6  CG  LYS A -14      21.495 -34.675  42.060  1.00 59.74           C  
ATOM      7  CD  LYS A -14      20.301 -33.704  41.902  1.00 65.41           C  
ATOM      8  CE  LYS A -14      19.250 -33.828  43.017  1.00 65.71           C  
ATOM      9  NZ  LYS A -14      19.759 -33.319  44.304  1.00 68.23           N  
ATOM     10  N   ILE A -13      18.945 -35.598  39.261  1.00 50.61           N  
ATOM     11  CA  ILE A -13      18.711 -35.404  37.831  1.00 47.51           C  
ATOM     12  C   ILE A -13      19.010 -33.960  37.454  1.00 45.17           C  
ATOM     13  O   ILE A -13      18.952 -33.066  38.307  1.00 44.29           O  
ATOM     14  CB  ILE A -13      17.247 -35.799  37.382  1.00 46.72           C  
ATOM     15  CG1 ILE A -13      16.175 -34.949  38.076  1.00 45.70           C  
ATOM     16  CG2 ILE A -13      16.986 -37.290  37.616  1.00 41.42           C  
ATOM     17  CD1 ILE A -13      14.835 -35.714  38.304  1.00 48.50           C  
ATOM     18  N   HIS A -12      19.376 -33.756  36.186  1.00 41.47           N  
ATOM     19  CA  HIS A -12      19.499 -32.421  35.618  1.00 38.56           C  
ATOM     20  C   HIS A -12      18.450 -32.145  34.530  1.00 35.21           C  
ATOM     21  O   HIS A -12      17.904 -33.071  33.912  1.00 31.11           O  
ATOM     22  CB  HIS A -12      20.937 -32.147  35.102  1.00 42.09           C  
ATOM     23  CG  HIS A -12      21.460 -33.143  34.109  1.00 41.39           C  
ATOM     24  ND1 HIS A -12      22.135 -34.282  34.485  1.00 46.52           N  
ATOM     25  CD2 HIS A -12      21.471 -33.136  32.755  1.00 46.94           C  
ATOM     26  CE1 HIS A -12      22.507 -34.954  33.406  1.00 46.58           C  
ATOM     27  NE2 HIS A -12      22.115 -34.280  32.343  1.00 47.42           N  
ATOM     28  N   HIS A -11      18.174 -30.861  34.312  1.00 32.74           N  
ATOM     29  CA  HIS A -11      17.218 -30.426  33.286  1.00 33.61           C  
ATOM     30  C   HIS A -11      17.875 -30.121  31.920  1.00 31.28           C  
ATOM     31  O   HIS A -11      19.026 -29.641  31.846  1.00 30.50           O  
ATOM     32  CB  HIS A -11      16.469 -29.166  33.739  1.00 34.73           C  
ATOM     33  CG  HIS A -11      15.562 -29.384  34.897  1.00 40.03           C  
ATOM     34  ND1 HIS A -11      16.031 -29.563  36.180  1.00 43.91           N  
ATOM     35  CD2 HIS A -11      14.212 -29.424  34.977  1.00 42.45           C  
ATOM     36  CE1 HIS A -11      15.006 -29.724  37.000  1.00 43.26           C  
ATOM     37  NE2 HIS A -11      13.892 -29.637  36.296  1.00 43.25           N  
ATOM     38  N   HIS A -10      17.106 -30.366  30.859  1.00 27.24           N  
ATOM     39  CA  HIS A -10      17.476 -29.960  29.517  1.00 27.02           C  
ATOM     40  C   HIS A -10      16.995 -28.505  29.256  1.00 27.02           C  
ATOM     41  O   HIS A -10      15.832 -28.180  29.464  1.00 26.78           O  
ATOM     42  CB  HIS A -10      16.883 -30.953  28.512  1.00 26.77           C  
ATOM     43  CG  HIS A -10      17.350 -30.751  27.103  1.00 25.96           C  
ATOM     44  ND1 HIS A -10      18.624 -31.064  26.693  1.00 21.70           N  
ATOM     45  CD2 HIS A -10      16.698 -30.308  26.001  1.00 26.33           C  
ATOM     46  CE1 HIS A -10      18.749 -30.777  25.407  1.00 26.50           C  
ATOM     47  NE2 HIS A -10      17.590 -30.337  24.958  1.00 23.33           N  
ATOM     48  N   HIS A  -9      17.910 -27.636  28.838  1.00 25.23           N  
ATOM     49  CA  HIS A  -9      17.576 -26.261  28.473  1.00 25.73           C  
ATOM     50  C   HIS A  -9      16.685 -25.621  29.554  1.00 26.95           C  
ATOM     51  O   HIS A  -9      15.573 -25.119  29.285  1.00 27.04           O  
ATOM     52  CB  HIS A  -9      16.948 -26.207  27.053  1.00 24.26           C  
ATOM     53  CG  HIS A  -9      17.961 -26.304  25.941  1.00 26.92           C  
ATOM     54  ND1 HIS A  -9      17.614 -26.538  24.625  1.00 23.01           N  
ATOM     55  CD2 HIS A  -9      19.312 -26.185  25.955  1.00 23.48           C  
ATOM     56  CE1 HIS A  -9      18.705 -26.557  23.879  1.00 22.40           C  
ATOM     57  NE2 HIS A  -9      19.750 -26.346  24.661  1.00 21.24           N  
ATOM     58  N   HIS A  -8      17.212 -25.655  30.781  1.00 27.62           N  
ATOM     59  CA  HIS A  -8      16.447 -25.396  32.015  1.00 26.57           C  
ATOM     60  C   HIS A  -8      15.653 -24.058  31.950  1.00 26.27           C  
ATOM     61  O   HIS A  -8      14.470 -24.013  32.246  1.00 25.32           O  
ATOM     62  CB  HIS A  -8      17.435 -25.418  33.181  1.00 29.78           C  
ATOM     63  CG  HIS A  -8      16.825 -25.588  34.538  1.00 30.92           C  
ATOM     64  ND1 HIS A  -8      15.484 -25.421  34.797  1.00 38.37           N  
ATOM     65  CD2 HIS A  -8      17.405 -25.845  35.733  1.00 35.85           C  
ATOM     66  CE1 HIS A  -8      15.255 -25.620  36.079  1.00 36.55           C  
ATOM     67  NE2 HIS A  -8      16.406 -25.868  36.671  1.00 35.31           N  
ATOM     68  N   HIS A  -7      16.280 -22.992  31.472  1.00 25.30           N  
ATOM     69  CA  HIS A  -7      15.651 -21.686  31.496  1.00 24.43           C  
ATOM     70  C   HIS A  -7      15.339 -21.144  30.124  1.00 24.18           C  
ATOM     71  O   HIS A  -7      15.213 -19.949  29.968  1.00 25.82           O  
ATOM     72  CB  HIS A  -7      16.545 -20.703  32.265  1.00 24.64           C  
ATOM     73  CG  HIS A  -7      16.874 -21.179  33.639  1.00 24.38           C  
ATOM     74  ND1 HIS A  -7      18.059 -21.815  33.938  1.00 28.45           N  
ATOM     75  CD2 HIS A  -7      16.143 -21.187  34.776  1.00 25.91           C  
ATOM     76  CE1 HIS A  -7      18.064 -22.165  35.212  1.00 28.31           C  
ATOM     77  NE2 HIS A  -7      16.909 -21.804  35.741  1.00 30.11           N  
ATOM     78  N   GLU A  -6      15.203 -22.011  29.128  1.00 25.85           N  
ATOM     79  CA  GLU A  -6      14.720 -21.588  27.806  1.00 24.73           C  
ATOM     80  C   GLU A  -6      13.567 -20.574  27.877  1.00 25.13           C  
ATOM     81  O   GLU A  -6      13.603 -19.531  27.202  1.00 24.07           O  
ATOM     82  CB  GLU A  -6      14.276 -22.809  26.996  1.00 25.95           C  
ATOM     83  CG  GLU A  -6      13.835 -22.484  25.585  1.00 22.32           C  
ATOM     84  CD  GLU A  -6      13.690 -23.700  24.725  1.00 26.01           C  
ATOM     85  OE1 GLU A  -6      14.475 -24.667  24.933  1.00 31.38           O  
ATOM     86  OE2 GLU A  -6      12.788 -23.699  23.840  1.00 24.02           O  
ATOM     87  N   ASN A  -5      12.569 -20.881  28.714  1.00 25.89           N  
ATOM     88  CA  ASN A  -5      11.316 -20.115  28.771  1.00 26.75           C  
ATOM     89  C   ASN A  -5      11.469 -18.714  29.380  1.00 28.43           C  
ATOM     90  O   ASN A  -5      10.549 -17.892  29.290  1.00 29.53           O  
ATOM     91  CB  ASN A  -5      10.239 -20.901  29.519  1.00 26.24           C  
ATOM     92  CG  ASN A  -5       9.848 -22.215  28.816  1.00 28.59           C  
ATOM     93  OD1 ASN A  -5      10.179 -22.442  27.647  1.00 24.03           O  
ATOM     94  ND2 ASN A  -5       9.128 -23.087  29.540  1.00 21.72           N  
ATOM     95  N   LEU A  -4      12.641 -18.428  29.958  1.00 27.93           N  
ATOM     96  CA  LEU A  -4      12.924 -17.129  30.531  1.00 27.32           C  
ATOM     97  C   LEU A  -4      13.441 -16.153  29.491  1.00 28.17           C  
ATOM     98  O   LEU A  -4      13.607 -14.971  29.792  1.00 28.58           O  
ATOM     99  CB  LEU A  -4      13.941 -17.238  31.683  1.00 27.84           C  
ATOM    100  CG  LEU A  -4      13.522 -18.121  32.874  1.00 29.92           C  
ATOM    101  CD1 LEU A  -4      14.570 -18.110  33.975  1.00 27.04           C  
ATOM    102  CD2 LEU A  -4      12.175 -17.696  33.456  1.00 31.63           C  
ATOM    103  N   TYR A  -3      13.683 -16.625  28.270  1.00 27.38           N  
ATOM    104  CA  TYR A  -3      14.370 -15.823  27.292  1.00 27.52           C  
ATOM    105  C   TYR A  -3      13.485 -15.383  26.138  1.00 29.39           C  
ATOM    106  O   TYR A  -3      13.799 -15.629  24.989  1.00 32.31           O  
ATOM    107  CB  TYR A  -3      15.642 -16.549  26.824  1.00 26.49           C  
ATOM    108  CG  TYR A  -3      16.683 -16.596  27.924  1.00 25.84           C  
ATOM    109  CD1 TYR A  -3      17.532 -15.524  28.160  1.00 25.02           C  
ATOM    110  CD2 TYR A  -3      16.756 -17.691  28.779  1.00 25.35           C  
ATOM    111  CE1 TYR A  -3      18.486 -15.572  29.204  1.00 29.75           C  
ATOM    112  CE2 TYR A  -3      17.671 -17.758  29.791  1.00 29.09           C  
ATOM    113  CZ  TYR A  -3      18.542 -16.702  30.011  1.00 26.55           C  
ATOM    114  OH  TYR A  -3      19.458 -16.818  31.037  1.00 28.87           O  
ATOM    115  N   PHE A  -2      12.415 -14.682  26.461  1.00 31.11           N  
ATOM    116  CA  PHE A  -2      11.482 -14.163  25.478  1.00 34.18           C  
ATOM    117  C   PHE A  -2      10.944 -12.809  25.948  1.00 36.19           C  
ATOM    118  O   PHE A  -2       9.893 -12.730  26.614  1.00 40.81           O  
ATOM    119  CB  PHE A  -2      10.310 -15.120  25.275  1.00 34.80           C  
ATOM    120  CG  PHE A  -2       9.408 -14.741  24.100  1.00 38.81           C  
ATOM    121  CD1 PHE A  -2       9.878 -14.810  22.796  1.00 36.49           C  
ATOM    122  CD2 PHE A  -2       8.093 -14.319  24.316  1.00 44.27           C  
ATOM    123  CE1 PHE A  -2       9.072 -14.475  21.728  1.00 42.54           C  
ATOM    124  CE2 PHE A  -2       7.266 -13.971  23.243  1.00 43.63           C  
ATOM    125  CZ  PHE A  -2       7.762 -14.058  21.938  1.00 40.73           C  
ATOM    126  N   GLN A  -1      11.651 -11.762  25.576  1.00 36.86           N  
ATOM    127  CA  GLN A  -1      11.412 -10.418  26.077  1.00 39.75           C  
ATOM    128  C   GLN A  -1      10.323  -9.689  25.269  1.00 37.56           C  
ATOM    129  O   GLN A  -1      10.265  -9.792  24.022  1.00 36.56           O  
ATOM    130  CB  GLN A  -1      12.733  -9.627  26.017  1.00 42.40           C  
ATOM    131  CG  GLN A  -1      12.776  -8.383  26.892  1.00 46.12           C  
ATOM    132  CD  GLN A  -1      14.163  -7.790  26.960  1.00 40.01           C  
ATOM    133  OE1 GLN A  -1      15.077  -8.372  27.543  1.00 46.81           O  
ATOM    134  NE2 GLN A  -1      14.320  -6.629  26.389  1.00 34.58           N  
ATOM    135  N   GLY A   0       9.481  -8.956  26.003  1.00 35.41           N  
ATOM    136  CA  GLY A   0       8.421  -8.125  25.435  1.00 33.88           C  
ATOM    137  C   GLY A   0       8.869  -6.685  25.265  1.00 32.71           C  
ATOM    138  O   GLY A   0      10.041  -6.398  25.326  1.00 30.44           O  
HETATM  139  N   MSE A   1       7.893  -5.803  25.048  0.50 33.16           N  
HETATM  141  CA  MSE A   1       8.103  -4.368  24.831  0.50 33.05           C  
HETATM  143  C   MSE A   1       8.224  -3.643  26.164  0.50 31.64           C  
HETATM  145  O   MSE A   1       7.371  -3.820  27.021  0.50 30.58           O  
HETATM  147  CB  MSE A   1       6.893  -3.772  24.097  0.50 33.58           C  
HETATM  149  CG  MSE A   1       6.554  -4.431  22.784  0.50 36.29           C  
HETATM  151 SE   MSE A   1       7.992  -4.218  21.521  0.37 37.12          SE  
HETATM  153  CE  MSE A   1       7.336  -5.449  20.125  0.50 35.27           C  
ATOM    155  N   ASN A   2       9.265  -2.834  26.349  1.00 31.62           N  
ATOM    156  CA  ASN A   2       9.402  -2.052  27.589  1.00 30.73           C  
ATOM    157  C   ASN A   2       9.350  -0.534  27.394  1.00 30.36           C  
ATOM    158  O   ASN A   2       9.427   0.206  28.383  1.00 30.23           O  
ATOM    159  CB  ASN A   2      10.709  -2.435  28.308  1.00 31.11           C  
ATOM    160  CG  ASN A   2      10.698  -3.861  28.833  1.00 30.30           C  
ATOM    161  OD1 ASN A   2       9.759  -4.259  29.492  1.00 32.80           O  
ATOM    162  ND2 ASN A   2      11.766  -4.628  28.556  1.00 26.73           N  
ATOM    163  N   PHE A   3       9.235  -0.066  26.144  1.00 30.99           N  
ATOM    164  CA  PHE A   3       9.186   1.382  25.858  1.00 29.17           C  
ATOM    165  C   PHE A   3       8.043   2.070  26.567  1.00 29.31           C  
ATOM    166  O   PHE A   3       6.897   1.628  26.479  1.00 27.53           O  
ATOM    167  CB  PHE A   3       9.063   1.655  24.363  1.00 28.51           C  
ATOM    168  CG  PHE A   3       9.081   3.141  24.011  1.00 31.06           C  
ATOM    169  CD1 PHE A   3      10.269   3.807  23.809  1.00 27.06           C  
ATOM    170  CD2 PHE A   3       7.891   3.875  23.911  1.00 30.49           C  
ATOM    171  CE1 PHE A   3      10.265   5.177  23.489  1.00 30.15           C  
ATOM    172  CE2 PHE A   3       7.901   5.230  23.603  1.00 29.26           C  
ATOM    173  CZ  PHE A   3       9.066   5.865  23.375  1.00 24.95           C  
ATOM    174  N   GLN A   4       8.380   3.118  27.320  1.00 31.81           N  
ATOM    175  CA  GLN A   4       7.423   4.101  27.837  1.00 30.93           C  
ATOM    176  C   GLN A   4       8.003   5.445  27.441  1.00 31.25           C  
ATOM    177  O   GLN A   4       9.224   5.644  27.531  1.00 32.82           O  
ATOM    178  CB  GLN A   4       7.308   4.078  29.372  1.00 33.96           C  
ATOM    179  CG  GLN A   4       6.892   2.783  30.010  1.00 41.50           C  
ATOM    180  CD  GLN A   4       5.523   2.291  29.546  1.00 53.63           C  
ATOM    181  OE1 GLN A   4       4.614   3.092  29.294  1.00 60.90           O  
ATOM    182  NE2 GLN A   4       5.371   0.958  29.433  1.00 55.12           N  
HETATM  183  N   MSE A   5       7.140   6.377  27.045  1.00 30.43           N  
HETATM  184  CA  MSE A   5       7.554   7.670  26.499  1.00 29.88           C  
HETATM  185  C   MSE A   5       8.271   8.543  27.524  1.00 30.21           C  
HETATM  186  O   MSE A   5       9.329   9.090  27.240  1.00 30.96           O  
HETATM  187  CB  MSE A   5       6.335   8.406  25.964  1.00 29.61           C  
HETATM  188  CG  MSE A   5       6.617   9.729  25.351  1.00 33.22           C  
HETATM  189 SE   MSE A   5       7.626   9.709  23.690  0.75 24.92          SE  
HETATM  190  CE  MSE A   5       6.852  11.457  23.224  1.00 25.52           C  
ATOM    191  N   ASN A   6       7.704   8.658  28.715  1.00 30.45           N  
ATOM    192  CA  ASN A   6       8.335   9.388  29.808  1.00 30.93           C  
ATOM    193  C   ASN A   6       9.705   8.838  30.185  1.00 29.95           C  
ATOM    194  O   ASN A   6      10.635   9.611  30.416  1.00 31.39           O  
ATOM    195  CB  ASN A   6       7.403   9.445  31.054  1.00 32.04           C  
ATOM    196  CG  ASN A   6       7.335   8.109  31.831  1.00 39.92           C  
ATOM    197  OD1 ASN A   6       7.236   7.015  31.229  1.00 45.42           O  
ATOM    198  ND2 ASN A   6       7.387   8.196  33.185  1.00 40.98           N  
ATOM    199  N   GLU A   7       9.822   7.509  30.250  1.00 28.42           N  
ATOM    200  CA  GLU A   7      11.060   6.861  30.655  1.00 26.85           C  
ATOM    201  C   GLU A   7      12.124   7.038  29.568  1.00 28.45           C  
ATOM    202  O   GLU A   7      13.322   7.136  29.865  1.00 27.86           O  
ATOM    203  CB  GLU A   7      10.830   5.369  30.942  1.00 27.15           C  
ATOM    204  CG  GLU A   7       9.951   5.049  32.198  1.00 26.94           C  
ATOM    205  CD  GLU A   7       9.739   3.542  32.410  1.00 30.02           C  
ATOM    206  OE1 GLU A   7      10.195   2.739  31.557  1.00 34.20           O  
ATOM    207  OE2 GLU A   7       9.111   3.146  33.424  1.00 35.17           O  
ATOM    208  N   ALA A   8      11.682   7.037  28.308  1.00 27.85           N  
ATOM    209  CA  ALA A   8      12.579   7.219  27.165  1.00 26.77           C  
ATOM    210  C   ALA A   8      13.194   8.613  27.214  1.00 28.76           C  
ATOM    211  O   ALA A   8      14.406   8.780  27.043  1.00 29.71           O  
ATOM    212  CB  ALA A   8      11.822   7.031  25.867  1.00 26.43           C  
ATOM    213  N   ILE A   9      12.339   9.602  27.462  1.00 28.49           N  
ATOM    214  CA  ILE A   9      12.738  10.996  27.500  1.00 27.95           C  
ATOM    215  C   ILE A   9      13.642  11.329  28.656  1.00 27.77           C  
ATOM    216  O   ILE A   9      14.485  12.196  28.504  1.00 28.34           O  
ATOM    217  CB  ILE A   9      11.519  11.931  27.558  1.00 27.62           C  
ATOM    218  CG1 ILE A   9      10.768  11.889  26.234  1.00 27.78           C  
ATOM    219  CG2 ILE A   9      11.972  13.385  27.867  1.00 27.40           C  
ATOM    220  CD1 ILE A   9       9.375  12.608  26.273  1.00 29.15           C  
ATOM    221  N   GLN A  10      13.436  10.683  29.808  1.00 29.45           N  
ATOM    222  CA  GLN A  10      14.342  10.767  30.970  1.00 28.34           C  
ATOM    223  C   GLN A  10      15.779  10.483  30.582  1.00 28.24           C  
ATOM    224  O   GLN A  10      16.686  11.251  30.906  1.00 29.55           O  
ATOM    225  CB  GLN A  10      13.964   9.753  32.057  1.00 29.91           C  
ATOM    226  CG  GLN A  10      12.828  10.132  33.005  1.00 31.87           C  
ATOM    227  CD  GLN A  10      12.299   8.928  33.825  1.00 30.51           C  
ATOM    228  OE1 GLN A  10      12.811   7.796  33.759  1.00 32.81           O  
ATOM    229  NE2 GLN A  10      11.245   9.173  34.564  1.00 33.86           N  
ATOM    230  N   LEU A  11      15.996   9.381  29.878  1.00 29.56           N  
ATOM    231  CA  LEU A  11      17.342   9.056  29.414  1.00 30.41           C  
ATOM    232  C   LEU A  11      17.877  10.044  28.362  1.00 28.93           C  
ATOM    233  O   LEU A  11      19.011  10.534  28.473  1.00 29.35           O  
ATOM    234  CB  LEU A  11      17.394   7.638  28.841  1.00 31.45           C  
ATOM    235  CG  LEU A  11      17.494   6.443  29.773  1.00 41.73           C  
ATOM    236  CD1 LEU A  11      17.879   5.238  28.931  1.00 44.70           C  
ATOM    237  CD2 LEU A  11      18.517   6.641  30.880  1.00 48.81           C  
ATOM    238  N   LEU A  12      17.091  10.312  27.329  1.00 26.60           N  
ATOM    239  CA  LEU A  12      17.549  11.189  26.225  1.00 27.23           C  
ATOM    240  C   LEU A  12      17.892  12.579  26.728  1.00 26.62           C  
ATOM    241  O   LEU A  12      18.785  13.236  26.203  1.00 27.36           O  
ATOM    242  CB  LEU A  12      16.481  11.310  25.115  1.00 26.86           C  
ATOM    243  CG  LEU A  12      16.037  10.058  24.335  1.00 28.23           C  
ATOM    244  CD1 LEU A  12      14.780  10.342  23.508  1.00 21.11           C  
ATOM    245  CD2 LEU A  12      17.138   9.542  23.490  1.00 18.34           C  
ATOM    246  N   GLU A  13      17.185  13.044  27.752  1.00 28.10           N  
ATOM    247  CA  GLU A  13      17.440  14.381  28.300  1.00 29.19           C  
ATOM    248  C   GLU A  13      18.713  14.454  29.146  1.00 29.97           C  
ATOM    249  O   GLU A  13      19.273  15.525  29.313  1.00 30.46           O  
ATOM    250  CB  GLU A  13      16.211  14.905  29.054  1.00 27.93           C  
ATOM    251  CG  GLU A  13      15.948  14.333  30.415  1.00 34.20           C  
ATOM    252  CD  GLU A  13      14.564  14.739  30.970  1.00 32.98           C  
ATOM    253  OE1 GLU A  13      13.888  15.589  30.351  1.00 35.27           O  
ATOM    254  OE2 GLU A  13      14.148  14.191  32.015  1.00 37.30           O  
ATOM    255  N   ARG A  14      19.189  13.300  29.618  1.00 31.29           N  
ATOM    256  CA  ARG A  14      20.343  13.189  30.503  1.00 30.71           C  
ATOM    257  C   ARG A  14      21.656  12.961  29.777  1.00 29.03           C  
ATOM    258  O   ARG A  14      22.702  13.185  30.361  1.00 30.65           O  
ATOM    259  CB  ARG A  14      20.141  12.014  31.477  1.00 29.54           C  
ATOM    260  CG  ARG A  14      19.320  12.412  32.671  1.00 35.11           C  
ATOM    261  CD  ARG A  14      18.813  11.224  33.473  1.00 35.78           C  
ATOM    262  NE  ARG A  14      18.170  11.687  34.698  1.00 43.97           N  
ATOM    263  CZ  ARG A  14      17.030  12.382  34.752  1.00 48.97           C  
ATOM    264  NH1 ARG A  14      16.341  12.722  33.647  1.00 46.07           N  
ATOM    265  NH2 ARG A  14      16.566  12.754  35.934  1.00 50.18           N  
ATOM    266  N   THR A  15      21.622  12.471  28.540  1.00 27.89           N  
ATOM    267  CA  THR A  15      22.849  12.008  27.879  1.00 29.41           C  
ATOM    268  C   THR A  15      23.910  13.103  27.736  1.00 30.08           C  
ATOM    269  O   THR A  15      25.078  12.862  28.071  1.00 30.14           O  
ATOM    270  CB  THR A  15      22.554  11.321  26.530  1.00 28.26           C  
ATOM    271  OG1 THR A  15      21.675  10.215  26.781  1.00 29.56           O  
ATOM    272  CG2 THR A  15      23.876  10.838  25.814  1.00 25.01           C  
ATOM    273  N   PRO A  16      23.513  14.307  27.253  1.00 31.01           N  
ATOM    274  CA  PRO A  16      24.536  15.373  27.098  1.00 30.38           C  
ATOM    275  C   PRO A  16      25.249  15.762  28.408  1.00 28.83           C  
ATOM    276  O   PRO A  16      26.469  15.800  28.463  1.00 30.37           O  
ATOM    277  CB  PRO A  16      23.744  16.539  26.481  1.00 30.27           C  
ATOM    278  CG  PRO A  16      22.566  15.880  25.807  1.00 29.40           C  
ATOM    279  CD  PRO A  16      22.193  14.763  26.773  1.00 30.67           C  
ATOM    280  N   LYS A  17      24.502  16.008  29.458  1.00 29.72           N  
ATOM    281  CA  LYS A  17      25.084  16.388  30.724  1.00 30.66           C  
ATOM    282  C   LYS A  17      25.917  15.270  31.345  1.00 29.50           C  
ATOM    283  O   LYS A  17      26.954  15.556  31.938  1.00 27.06           O  
ATOM    284  CB  LYS A  17      23.991  16.829  31.704  1.00 34.26           C  
ATOM    285  CG  LYS A  17      24.521  17.435  33.031  1.00 40.55           C  
ATOM    286  CD  LYS A  17      25.661  18.508  32.833  1.00 53.63           C  
ATOM    287  CE  LYS A  17      25.666  19.566  33.957  1.00 56.94           C  
ATOM    288  NZ  LYS A  17      26.826  19.398  34.912  1.00 64.39           N  
ATOM    289  N   THR A  18      25.478  14.018  31.192  1.00 27.81           N  
ATOM    290  CA  THR A  18      26.282  12.841  31.613  1.00 28.32           C  
ATOM    291  C   THR A  18      27.639  12.783  30.881  1.00 29.10           C  
ATOM    292  O   THR A  18      28.684  12.561  31.498  1.00 27.15           O  
ATOM    293  CB  THR A  18      25.485  11.481  31.408  1.00 30.58           C  
ATOM    294  OG1 THR A  18      24.190  11.563  32.027  1.00 25.98           O  
ATOM    295  CG2 THR A  18      26.231  10.280  31.987  1.00 24.06           C  
ATOM    296  N   LEU A  19      27.634  12.983  29.565  1.00 28.96           N  
ATOM    297  CA  LEU A  19      28.887  12.911  28.810  1.00 30.29           C  
ATOM    298  C   LEU A  19      29.823  14.081  29.169  1.00 30.03           C  
ATOM    299  O   LEU A  19      31.048  13.918  29.331  1.00 30.30           O  
ATOM    300  CB  LEU A  19      28.622  12.812  27.286  1.00 32.10           C  
ATOM    301  CG  LEU A  19      28.150  11.450  26.682  1.00 29.87           C  
ATOM    302  CD1 LEU A  19      28.116  11.550  25.182  1.00 31.78           C  
ATOM    303  CD2 LEU A  19      29.004  10.258  27.073  1.00 24.56           C  
ATOM    304  N   GLU A  20      29.243  15.254  29.342  1.00 29.27           N  
ATOM    305  CA  GLU A  20      29.997  16.398  29.789  1.00 29.73           C  
ATOM    306  C   GLU A  20      30.608  16.256  31.224  1.00 29.45           C  
ATOM    307  O   GLU A  20      31.782  16.580  31.432  1.00 28.63           O  
ATOM    308  CB  GLU A  20      29.142  17.657  29.693  1.00 29.56           C  
ATOM    309  CG  GLU A  20      29.979  18.921  29.815  1.00 39.35           C  
ATOM    310  CD  GLU A  20      29.256  20.038  30.496  1.00 48.74           C  
ATOM    311  OE1 GLU A  20      28.094  20.322  30.078  1.00 53.64           O  
ATOM    312  OE2 GLU A  20      29.862  20.607  31.437  1.00 60.00           O  
ATOM    313  N   VAL A  21      29.853  15.778  32.205  1.00 29.18           N  
ATOM    314  CA  VAL A  21      30.410  15.655  33.547  1.00 31.27           C  
ATOM    315  C   VAL A  21      31.479  14.546  33.587  1.00 30.36           C  
ATOM    316  O   VAL A  21      32.432  14.617  34.330  1.00 31.02           O  
ATOM    317  CB  VAL A  21      29.298  15.440  34.609  1.00 33.79           C  
ATOM    318  CG1 VAL A  21      29.074  13.972  34.857  1.00 38.46           C  
ATOM    319  CG2 VAL A  21      29.661  16.136  35.900  1.00 40.25           C  
ATOM    320  N   PHE A  22      31.317  13.545  32.738  1.00 30.70           N  
ATOM    321  CA  PHE A  22      32.250  12.415  32.618  1.00 30.18           C  
ATOM    322  C   PHE A  22      33.561  12.802  31.929  1.00 29.12           C  
ATOM    323  O   PHE A  22      34.626  12.426  32.384  1.00 28.95           O  
ATOM    324  CB  PHE A  22      31.556  11.275  31.823  1.00 28.92           C  
ATOM    325  CG  PHE A  22      32.300   9.977  31.809  1.00 31.21           C  
ATOM    326  CD1 PHE A  22      32.864   9.465  32.962  1.00 35.99           C  
ATOM    327  CD2 PHE A  22      32.393   9.236  30.636  1.00 36.10           C  
ATOM    328  CE1 PHE A  22      33.534   8.248  32.949  1.00 34.67           C  
ATOM    329  CE2 PHE A  22      33.048   8.034  30.622  1.00 39.30           C  
ATOM    330  CZ  PHE A  22      33.625   7.542  31.792  1.00 36.69           C  
ATOM    331  N   LEU A  23      33.471  13.559  30.840  1.00 28.35           N  
ATOM    332  CA  LEU A  23      34.602  13.782  29.950  1.00 27.82           C  
ATOM    333  C   LEU A  23      35.234  15.172  29.971  1.00 29.89           C  
ATOM    334  O   LEU A  23      36.360  15.329  29.490  1.00 30.04           O  
ATOM    335  CB  LEU A  23      34.162  13.509  28.510  1.00 28.19           C  
ATOM    336  CG  LEU A  23      33.646  12.118  28.175  1.00 25.44           C  
ATOM    337  CD1 LEU A  23      33.129  12.112  26.724  1.00 23.49           C  
ATOM    338  CD2 LEU A  23      34.734  11.107  28.392  1.00 21.91           C  
ATOM    339  N   GLU A  24      34.506  16.168  30.469  1.00 33.56           N  
ATOM    340  CA  GLU A  24      34.976  17.564  30.487  1.00 36.73           C  
ATOM    341  C   GLU A  24      36.133  17.714  31.471  1.00 36.75           C  
ATOM    342  O   GLU A  24      36.015  17.342  32.644  1.00 35.45           O  
ATOM    343  CB  GLU A  24      33.843  18.535  30.875  1.00 36.50           C  
ATOM    344  CG  GLU A  24      34.211  20.046  30.884  1.00 41.75           C  
ATOM    345  CD  GLU A  24      33.900  20.754  29.556  1.00 56.42           C  
ATOM    346  OE1 GLU A  24      34.627  20.434  28.579  1.00 61.46           O  
ATOM    347  OE2 GLU A  24      32.959  21.613  29.494  1.00 57.56           O  
ATOM    348  N   GLY A  25      37.246  18.234  30.954  1.00 36.98           N  
ATOM    349  CA  GLY A  25      38.430  18.488  31.744  1.00 37.10           C  
ATOM    350  C   GLY A  25      39.314  17.280  31.960  1.00 36.75           C  
ATOM    351  O   GLY A  25      40.326  17.391  32.625  1.00 37.87           O  
ATOM    352  N   LEU A  26      38.943  16.116  31.423  1.00 36.19           N  
ATOM    353  CA  LEU A  26      39.882  14.992  31.363  1.00 34.07           C  
ATOM    354  C   LEU A  26      41.020  15.393  30.427  1.00 31.91           C  
ATOM    355  O   LEU A  26      40.847  16.248  29.574  1.00 32.64           O  
ATOM    356  CB  LEU A  26      39.211  13.733  30.803  1.00 33.98           C  
ATOM    357  CG  LEU A  26      38.118  13.019  31.591  1.00 30.77           C  
ATOM    358  CD1 LEU A  26      37.558  11.873  30.746  1.00 22.04           C  
ATOM    359  CD2 LEU A  26      38.648  12.511  32.915  1.00 26.18           C  
ATOM    360  N   SER A  27      42.178  14.762  30.596  0.50 32.26           N  
ATOM    362  CA  SER A  27      43.298  14.902  29.653  0.50 31.23           C  
ATOM    364  C   SER A  27      42.863  14.561  28.224  0.50 31.59           C  
ATOM    366  O   SER A  27      41.965  13.739  28.018  0.50 30.96           O  
ATOM    368  CB  SER A  27      44.456  13.991  30.064  0.50 30.35           C  
ATOM    370  OG  SER A  27      45.372  13.825  29.000  0.50 31.52           O  
ATOM    372  N   ASP A  28      43.510  15.187  27.241  1.00 31.32           N  
ATOM    373  CA  ASP A  28      43.214  14.913  25.839  1.00 32.77           C  
ATOM    374  C   ASP A  28      43.460  13.438  25.493  1.00 31.63           C  
ATOM    375  O   ASP A  28      42.845  12.906  24.573  1.00 33.04           O  
ATOM    376  CB  ASP A  28      44.029  15.835  24.901  1.00 34.22           C  
ATOM    377  CG  ASP A  28      43.672  15.624  23.440  1.00 37.82           C  
ATOM    378  OD1 ASP A  28      42.484  15.809  23.121  1.00 38.27           O  
ATOM    379  OD2 ASP A  28      44.542  15.212  22.625  1.00 45.06           O  
ATOM    380  N   SER A  29      44.356  12.791  26.235  1.00 31.09           N  
ATOM    381  CA  SER A  29      44.632  11.363  26.102  1.00 30.19           C  
ATOM    382  C   SER A  29      43.411  10.494  26.224  1.00 29.08           C  
ATOM    383  O   SER A  29      43.305   9.468  25.562  1.00 29.20           O  
ATOM    384  CB  SER A  29      45.551  10.921  27.217  1.00 29.47           C  
ATOM    385  OG  SER A  29      46.826  11.454  27.013  1.00 42.50           O  
ATOM    386  N   TRP A  30      42.546  10.846  27.163  1.00 28.64           N  
ATOM    387  CA  TRP A  30      41.321  10.092  27.367  1.00 29.27           C  
ATOM    388  C   TRP A  30      40.376  10.317  26.177  1.00 29.30           C  
ATOM    389  O   TRP A  30      39.686   9.389  25.758  1.00 31.79           O  
ATOM    390  CB  TRP A  30      40.624  10.497  28.661  1.00 29.25           C  
ATOM    391  CG  TRP A  30      41.274  10.028  29.897  1.00 27.17           C  
ATOM    392  CD1 TRP A  30      41.764  10.804  30.906  1.00 28.29           C  
ATOM    393  CD2 TRP A  30      41.504   8.675  30.282  1.00 30.73           C  
ATOM    394  NE1 TRP A  30      42.268  10.026  31.898  1.00 28.39           N  
ATOM    395  CE2 TRP A  30      42.131   8.709  31.546  1.00 34.48           C  
ATOM    396  CE3 TRP A  30      41.245   7.432  29.681  1.00 28.42           C  
ATOM    397  CZ2 TRP A  30      42.511   7.552  32.220  1.00 30.10           C  
ATOM    398  CZ3 TRP A  30      41.610   6.291  30.342  1.00 29.34           C  
ATOM    399  CH2 TRP A  30      42.240   6.353  31.606  1.00 32.41           C  
ATOM    400  N   HIS A  31      40.368  11.539  25.636  1.00 27.57           N  
ATOM    401  CA  HIS A  31      39.495  11.897  24.541  1.00 27.98           C  
ATOM    402  C   HIS A  31      39.949  11.243  23.211  1.00 28.08           C  
ATOM    403  O   HIS A  31      39.139  11.017  22.341  1.00 26.25           O  
ATOM    404  CB  HIS A  31      39.431  13.433  24.402  1.00 28.50           C  
ATOM    405  CG  HIS A  31      38.878  14.148  25.603  1.00 26.30           C  
ATOM    406  ND1 HIS A  31      39.177  15.466  25.884  1.00 28.20           N  
ATOM    407  CD2 HIS A  31      38.012  13.750  26.568  1.00 29.25           C  
ATOM    408  CE1 HIS A  31      38.536  15.842  26.980  1.00 29.52           C  
ATOM    409  NE2 HIS A  31      37.821  14.822  27.416  1.00 24.77           N  
ATOM    410  N   GLN A  32      41.252  10.961  23.057  1.00 29.86           N  
ATOM    411  CA  GLN A  32      41.790  10.358  21.821  1.00 30.74           C  
ATOM    412  C   GLN A  32      41.888   8.807  21.872  1.00 31.41           C  
ATOM    413  O   GLN A  32      42.399   8.171  20.964  1.00 31.45           O  
ATOM    414  CB  GLN A  32      43.175  10.952  21.487  1.00 32.24           C  
ATOM    415  CG  GLN A  32      43.255  12.476  21.417  1.00 30.48           C  
ATOM    416  CD  GLN A  32      42.196  13.079  20.541  1.00 35.62           C  
ATOM    417  OE1 GLN A  32      41.768  12.468  19.566  1.00 34.88           O  
ATOM    418  NE2 GLN A  32      41.725  14.272  20.907  1.00 32.97           N  
ATOM    419  N   CYS A  33      41.423   8.189  22.934  0.50 31.90           N  
ATOM    421  CA  CYS A  33      41.555   6.772  22.979  0.50 31.53           C  
ATOM    423  C   CYS A  33      40.389   6.142  22.225  0.50 32.61           C  
ATOM    425  O   CYS A  33      39.286   6.702  22.145  0.50 30.50           O  
ATOM    427  CB  CYS A  33      41.678   6.279  24.416  0.50 31.92           C  
ATOM    429  SG  CYS A  33      40.185   6.272  25.343  0.50 31.18           S  
ATOM    431  N   ASN A  34      40.680   4.971  21.658  1.00 32.52           N  
ATOM    432  CA  ASN A  34      39.750   4.199  20.891  1.00 31.15           C  
ATOM    433  C   ASN A  34      39.831   2.750  21.306  1.00 31.59           C  
ATOM    434  O   ASN A  34      40.487   2.434  22.288  1.00 32.44           O  
ATOM    435  CB  ASN A  34      39.981   4.440  19.407  1.00 31.76           C  
ATOM    436  CG  ASN A  34      41.288   3.891  18.887  1.00 35.43           C  
ATOM    437  OD1 ASN A  34      42.010   3.160  19.568  1.00 30.71           O  
ATOM    438  ND2 ASN A  34      41.568   4.199  17.618  1.00 34.86           N  
ATOM    439  N   GLU A  35      39.130   1.883  20.599  1.00 31.17           N  
ATOM    440  CA  GLU A  35      39.172   0.443  20.853  1.00 31.86           C  
ATOM    441  C   GLU A  35      40.115  -0.281  19.875  1.00 32.32           C  
ATOM    442  O   GLU A  35      39.977  -1.463  19.680  1.00 34.90           O  
ATOM    443  CB  GLU A  35      37.765  -0.157  20.711  1.00 32.06           C  
ATOM    444  CG  GLU A  35      36.856   0.128  21.878  1.00 32.37           C  
ATOM    445  CD  GLU A  35      35.613  -0.725  21.869  1.00 31.97           C  
ATOM    446  OE1 GLU A  35      34.633  -0.303  21.213  1.00 30.68           O  
ATOM    447  OE2 GLU A  35      35.610  -1.795  22.538  1.00 29.02           O  
ATOM    448  N   GLY A  36      41.050   0.444  19.257  1.00 32.01           N  
ATOM    449  CA  GLY A  36      42.043  -0.117  18.363  1.00 29.65           C  
ATOM    450  C   GLY A  36      41.899   0.401  16.952  1.00 29.90           C  
ATOM    451  O   GLY A  36      41.076   1.250  16.671  1.00 31.92           O  
ATOM    452  N   TYR A  37      42.721  -0.131  16.066  1.00 30.38           N  
ATOM    453  CA  TYR A  37      42.780   0.276  14.675  1.00 31.64           C  
ATOM    454  C   TYR A  37      41.436   0.356  14.018  1.00 32.89           C  
ATOM    455  O   TYR A  37      40.621  -0.575  14.124  1.00 30.13           O  
ATOM    456  CB  TYR A  37      43.633  -0.707  13.890  1.00 33.32           C  
ATOM    457  CG  TYR A  37      43.852  -0.369  12.438  1.00 32.34           C  
ATOM    458  CD1 TYR A  37      44.575   0.745  12.079  1.00 36.66           C  
ATOM    459  CD2 TYR A  37      43.360  -1.194  11.419  1.00 34.03           C  
ATOM    460  CE1 TYR A  37      44.810   1.041  10.749  1.00 34.81           C  
ATOM    461  CE2 TYR A  37      43.584  -0.894  10.094  1.00 33.16           C  
ATOM    462  CZ  TYR A  37      44.315   0.221   9.768  1.00 37.00           C  
ATOM    463  OH  TYR A  37      44.574   0.536   8.448  1.00 40.77           O  
ATOM    464  N   GLU A  38      41.252   1.473  13.305  1.00 33.72           N  
ATOM    465  CA  GLU A  38      40.029   1.811  12.581  1.00 36.16           C  
ATOM    466  C   GLU A  38      38.759   1.894  13.411  1.00 34.37           C  
ATOM    467  O   GLU A  38      37.666   1.732  12.887  1.00 36.80           O  
ATOM    468  CB  GLU A  38      39.836   0.894  11.394  1.00 34.36           C  
ATOM    469  CG  GLU A  38      40.565   1.392  10.150  1.00 41.98           C  
ATOM    470  CD  GLU A  38      40.520   0.390   9.030  1.00 42.68           C  
ATOM    471  OE1 GLU A  38      39.952  -0.720   9.220  1.00 49.22           O  
ATOM    472  OE2 GLU A  38      41.068   0.706   7.955  1.00 59.46           O  
ATOM    473  N   THR A  39      38.894   2.182  14.695  1.00 31.82           N  
ATOM    474  CA  THR A  39      37.727   2.472  15.506  1.00 29.87           C  
ATOM    475  C   THR A  39      37.830   3.919  15.920  1.00 28.74           C  
ATOM    476  O   THR A  39      38.913   4.488  15.923  1.00 27.74           O  
ATOM    477  CB  THR A  39      37.629   1.566  16.730  1.00 30.63           C  
ATOM    478  OG1 THR A  39      38.684   1.884  17.634  1.00 27.24           O  
ATOM    479  CG2 THR A  39      37.681   0.062  16.310  1.00 25.55           C  
ATOM    480  N   TRP A  40      36.695   4.510  16.271  1.00 28.86           N  
ATOM    481  CA  TRP A  40      36.600   5.942  16.551  1.00 26.35           C  
ATOM    482  C   TRP A  40      37.132   6.302  17.916  1.00 26.61           C  
ATOM    483  O   TRP A  40      36.995   5.520  18.863  1.00 25.41           O  
ATOM    484  CB  TRP A  40      35.156   6.409  16.463  1.00 25.89           C  
ATOM    485  CG  TRP A  40      34.533   6.294  15.101  1.00 28.99           C  
ATOM    486  CD1 TRP A  40      35.162   6.031  13.923  1.00 30.08           C  
ATOM    487  CD2 TRP A  40      33.158   6.496  14.776  1.00 28.23           C  
ATOM    488  NE1 TRP A  40      34.263   6.038  12.886  1.00 29.52           N  
ATOM    489  CE2 TRP A  40      33.023   6.322  13.383  1.00 27.28           C  
ATOM    490  CE3 TRP A  40      32.021   6.807  15.527  1.00 33.87           C  
ATOM    491  CZ2 TRP A  40      31.800   6.426  12.729  1.00 28.66           C  
ATOM    492  CZ3 TRP A  40      30.810   6.907  14.869  1.00 31.66           C  
ATOM    493  CH2 TRP A  40      30.708   6.711  13.496  1.00 29.71           C  
ATOM    494  N   THR A  41      37.702   7.512  18.011  1.00 26.24           N  
ATOM    495  CA  THR A  41      38.122   8.081  19.281  1.00 25.45           C  
ATOM    496  C   THR A  41      36.888   8.548  20.093  1.00 26.87           C  
ATOM    497  O   THR A  41      35.819   8.777  19.548  1.00 27.28           O  
ATOM    498  CB  THR A  41      39.008   9.297  19.092  1.00 25.48           C  
ATOM    499  OG1 THR A  41      38.231  10.368  18.497  1.00 25.23           O  
ATOM    500  CG2 THR A  41      40.251   8.953  18.228  1.00 22.52           C  
ATOM    501  N   VAL A  42      37.065   8.714  21.391  1.00 26.04           N  
ATOM    502  CA  VAL A  42      36.013   9.241  22.249  1.00 25.34           C  
ATOM    503  C   VAL A  42      35.451  10.542  21.654  1.00 25.65           C  
ATOM    504  O   VAL A  42      34.246  10.701  21.497  1.00 20.98           O  
ATOM    505  CB  VAL A  42      36.546   9.427  23.690  1.00 25.52           C  
ATOM    506  CG1 VAL A  42      35.639  10.317  24.505  1.00 25.38           C  
ATOM    507  CG2 VAL A  42      36.750   8.047  24.362  1.00 22.17           C  
ATOM    508  N   TYR A  43      36.358  11.434  21.267  1.00 26.53           N  
ATOM    509  CA  TYR A  43      36.031  12.706  20.630  1.00 24.55           C  
ATOM    510  C   TYR A  43      35.101  12.495  19.440  1.00 26.08           C  
ATOM    511  O   TYR A  43      34.030  13.144  19.350  1.00 28.00           O  
ATOM    512  CB  TYR A  43      37.330  13.395  20.191  1.00 24.97           C  
ATOM    513  CG  TYR A  43      37.141  14.770  19.631  1.00 26.11           C  
ATOM    514  CD1 TYR A  43      36.768  14.955  18.319  1.00 28.02           C  
ATOM    515  CD2 TYR A  43      37.342  15.890  20.416  1.00 27.33           C  
ATOM    516  CE1 TYR A  43      36.564  16.235  17.805  1.00 28.30           C  
ATOM    517  CE2 TYR A  43      37.147  17.156  19.914  1.00 30.05           C  
ATOM    518  CZ  TYR A  43      36.754  17.323  18.605  1.00 26.70           C  
ATOM    519  OH  TYR A  43      36.563  18.585  18.107  1.00 28.03           O  
ATOM    520  N   GLU A  44      35.513  11.591  18.537  1.00 25.76           N  
ATOM    521  CA  GLU A  44      34.755  11.262  17.311  1.00 25.42           C  
ATOM    522  C   GLU A  44      33.366  10.682  17.580  1.00 26.27           C  
ATOM    523  O   GLU A  44      32.439  10.889  16.798  1.00 29.01           O  
ATOM    524  CB  GLU A  44      35.556  10.327  16.413  1.00 26.42           C  
ATOM    525  CG  GLU A  44      36.691  11.056  15.653  1.00 26.37           C  
ATOM    526  CD  GLU A  44      37.709  10.122  14.954  1.00 30.02           C  
ATOM    527  OE1 GLU A  44      37.787   8.888  15.274  1.00 29.76           O  
ATOM    528  OE2 GLU A  44      38.485  10.665  14.110  1.00 37.90           O  
ATOM    529  N   VAL A  45      33.215   9.961  18.681  1.00 25.70           N  
ATOM    530  CA  VAL A  45      31.903   9.444  19.078  1.00 26.28           C  
ATOM    531  C   VAL A  45      30.980  10.604  19.496  1.00 26.40           C  
ATOM    532  O   VAL A  45      29.826  10.641  19.114  1.00 24.75           O  
ATOM    533  CB  VAL A  45      32.036   8.362  20.172  1.00 27.10           C  
ATOM    534  CG1 VAL A  45      30.672   7.923  20.675  1.00 23.73           C  
ATOM    535  CG2 VAL A  45      32.842   7.164  19.625  1.00 21.21           C  
ATOM    536  N   VAL A  46      31.515  11.551  20.258  1.00 25.48           N  
ATOM    537  CA  VAL A  46      30.784  12.753  20.606  1.00 26.58           C  
ATOM    538  C   VAL A  46      30.410  13.576  19.307  1.00 26.98           C  
ATOM    539  O   VAL A  46      29.272  13.989  19.143  1.00 26.69           O  
ATOM    540  CB  VAL A  46      31.570  13.592  21.637  1.00 25.78           C  
ATOM    541  CG1 VAL A  46      30.883  14.917  21.874  1.00 25.76           C  
ATOM    542  CG2 VAL A  46      31.754  12.818  22.970  1.00 22.75           C  
ATOM    543  N   VAL A  47      31.356  13.762  18.389  1.00 27.17           N  
ATOM    544  CA  VAL A  47      31.070  14.437  17.114  1.00 26.35           C  
ATOM    545  C   VAL A  47      29.912  13.711  16.383  1.00 26.55           C  
ATOM    546  O   VAL A  47      28.999  14.352  15.879  1.00 27.64           O  
ATOM    547  CB  VAL A  47      32.360  14.575  16.260  1.00 25.15           C  
ATOM    548  CG1 VAL A  47      32.088  15.060  14.805  1.00 23.16           C  
ATOM    549  CG2 VAL A  47      33.317  15.536  16.946  1.00 24.41           C  
ATOM    550  N   HIS A  48      29.937  12.381  16.377  1.00 27.23           N  
ATOM    551  CA  HIS A  48      28.909  11.547  15.709  1.00 26.79           C  
ATOM    552  C   HIS A  48      27.538  11.663  16.340  1.00 26.25           C  
ATOM    553  O   HIS A  48      26.532  11.720  15.623  1.00 27.24           O  
ATOM    554  CB  HIS A  48      29.353  10.084  15.713  1.00 28.64           C  
ATOM    555  CG  HIS A  48      28.276   9.095  15.383  1.00 25.85           C  
ATOM    556  ND1 HIS A  48      27.842   8.872  14.098  1.00 26.45           N  
ATOM    557  CD2 HIS A  48      27.593   8.227  16.170  1.00 24.62           C  
ATOM    558  CE1 HIS A  48      26.926   7.919  14.104  1.00 29.78           C  
ATOM    559  NE2 HIS A  48      26.749   7.516  15.351  1.00 26.74           N  
ATOM    560  N   LEU A  49      27.494  11.736  17.665  1.00 24.48           N  
ATOM    561  CA  LEU A  49      26.230  11.909  18.360  1.00 26.86           C  
ATOM    562  C   LEU A  49      25.604  13.263  18.009  1.00 26.67           C  
ATOM    563  O   LEU A  49      24.399  13.371  17.882  1.00 27.80           O  
ATOM    564  CB  LEU A  49      26.400  11.763  19.871  1.00 25.55           C  
ATOM    565  CG  LEU A  49      26.588  10.355  20.415  1.00 27.38           C  
ATOM    566  CD1 LEU A  49      26.977  10.478  21.893  1.00 24.07           C  
ATOM    567  CD2 LEU A  49      25.326   9.440  20.210  1.00 22.95           C  
ATOM    568  N   ILE A  50      26.437  14.280  17.831  1.00 27.44           N  
ATOM    569  CA  ILE A  50      25.985  15.577  17.351  1.00 27.50           C  
ATOM    570  C   ILE A  50      25.363  15.456  15.956  1.00 28.13           C  
ATOM    571  O   ILE A  50      24.262  15.951  15.728  1.00 29.89           O  
ATOM    572  CB  ILE A  50      27.121  16.615  17.367  1.00 28.05           C  
ATOM    573  CG1 ILE A  50      27.516  16.926  18.825  1.00 28.18           C  
ATOM    574  CG2 ILE A  50      26.695  17.907  16.642  1.00 24.85           C  
ATOM    575  CD1 ILE A  50      28.781  17.739  18.961  1.00 24.59           C  
ATOM    576  N   GLU A  51      26.038  14.750  15.063  1.00 26.47           N  
ATOM    577  CA  GLU A  51      25.543  14.519  13.711  1.00 26.83           C  
ATOM    578  C   GLU A  51      24.186  13.811  13.686  1.00 26.40           C  
ATOM    579  O   GLU A  51      23.316  14.185  12.908  1.00 27.75           O  
ATOM    580  CB  GLU A  51      26.559  13.669  12.946  1.00 26.31           C  
ATOM    581  CG  GLU A  51      26.302  13.590  11.454  1.00 28.89           C  
ATOM    582  CD  GLU A  51      27.418  12.886  10.725  1.00 27.76           C  
ATOM    583  OE1 GLU A  51      28.352  13.591  10.282  1.00 31.78           O  
ATOM    584  OE2 GLU A  51      27.383  11.630  10.616  1.00 32.31           O  
ATOM    585  N   ALA A  52      24.010  12.805  14.551  1.00 25.86           N  
ATOM    586  CA  ALA A  52      22.745  12.078  14.682  1.00 25.34           C  
ATOM    587  C   ALA A  52      21.623  13.005  15.071  1.00 26.85           C  
ATOM    588  O   ALA A  52      20.482  12.809  14.659  1.00 25.86           O  
ATOM    589  CB  ALA A  52      22.864  10.965  15.695  1.00 23.55           C  
ATOM    590  N   GLU A  53      21.953  14.022  15.876  1.00 27.83           N  
ATOM    591  CA  GLU A  53      20.969  15.038  16.268  1.00 27.30           C  
ATOM    592  C   GLU A  53      20.529  15.948  15.105  1.00 27.07           C  
ATOM    593  O   GLU A  53      19.423  16.461  15.121  1.00 26.98           O  
ATOM    594  CB  GLU A  53      21.489  15.882  17.453  1.00 25.89           C  
ATOM    595  CG  GLU A  53      21.717  15.090  18.713  1.00 26.41           C  
ATOM    596  CD  GLU A  53      20.451  14.439  19.233  1.00 27.07           C  
ATOM    597  OE1 GLU A  53      19.527  15.194  19.593  1.00 24.89           O  
ATOM    598  OE2 GLU A  53      20.376  13.180  19.289  1.00 25.13           O  
ATOM    599  N   LYS A  54      21.398  16.143  14.123  1.00 26.72           N  
ATOM    600  CA  LYS A  54      21.106  16.962  12.923  1.00 27.05           C  
ATOM    601  C   LYS A  54      20.452  16.167  11.782  1.00 26.28           C  
ATOM    602  O   LYS A  54      19.591  16.681  11.065  1.00 24.92           O  
ATOM    603  CB  LYS A  54      22.409  17.619  12.401  1.00 26.89           C  
ATOM    604  CG  LYS A  54      23.128  18.435  13.458  1.00 26.00           C  
ATOM    605  CD  LYS A  54      24.383  18.999  12.925  1.00 29.56           C  
ATOM    606  CE  LYS A  54      25.072  19.927  13.910  1.00 37.17           C  
ATOM    607  NZ  LYS A  54      26.359  20.402  13.371  1.00 33.89           N  
ATOM    608  N   THR A  55      20.839  14.899  11.658  1.00 28.22           N  
ATOM    609  CA  THR A  55      20.600  14.122  10.444  1.00 28.61           C  
ATOM    610  C   THR A  55      19.683  12.920  10.559  1.00 27.83           C  
ATOM    611  O   THR A  55      19.121  12.495   9.572  1.00 28.52           O  
ATOM    612  CB  THR A  55      21.944  13.649   9.842  1.00 31.00           C  
ATOM    613  OG1 THR A  55      21.785  13.457   8.421  1.00 36.44           O  
ATOM    614  CG2 THR A  55      22.433  12.383  10.526  1.00 26.55           C  
ATOM    615  N   ASN A  56      19.499  12.394  11.765  1.00 28.75           N  
ATOM    616  CA  ASN A  56      18.923  11.052  11.943  1.00 28.40           C  
ATOM    617  C   ASN A  56      17.517  11.039  12.591  1.00 26.32           C  
ATOM    618  O   ASN A  56      16.514  10.953  11.884  1.00 26.62           O  
ATOM    619  CB  ASN A  56      19.947  10.187  12.715  1.00 27.31           C  
ATOM    620  CG  ASN A  56      19.593   8.741  12.764  1.00 23.98           C  
ATOM    621  OD1 ASN A  56      18.413   8.355  12.686  1.00 27.41           O  
ATOM    622  ND2 ASN A  56      20.628   7.896  12.888  1.00 24.69           N  
ATOM    623  N   TRP A  57      17.446  11.152  13.912  1.00 26.00           N  
ATOM    624  CA  TRP A  57      16.226  10.768  14.672  1.00 27.59           C  
ATOM    625  C   TRP A  57      14.979  11.616  14.379  1.00 26.71           C  
ATOM    626  O   TRP A  57      13.921  11.103  14.011  1.00 28.40           O  
ATOM    627  CB  TRP A  57      16.529  10.754  16.169  1.00 28.58           C  
ATOM    628  CG  TRP A  57      17.729   9.922  16.464  1.00 24.29           C  
ATOM    629  CD1 TRP A  57      18.938  10.364  16.879  1.00 28.33           C  
ATOM    630  CD2 TRP A  57      17.860   8.502  16.274  1.00 27.50           C  
ATOM    631  NE1 TRP A  57      19.824   9.322  16.952  1.00 28.53           N  
ATOM    632  CE2 TRP A  57      19.180   8.163  16.605  1.00 24.21           C  
ATOM    633  CE3 TRP A  57      16.987   7.490  15.836  1.00 26.22           C  
ATOM    634  CZ2 TRP A  57      19.651   6.857  16.543  1.00 29.43           C  
ATOM    635  CZ3 TRP A  57      17.444   6.197  15.775  1.00 26.85           C  
ATOM    636  CH2 TRP A  57      18.763   5.882  16.133  1.00 28.28           C  
ATOM    637  N   ILE A  58      15.127  12.919  14.507  1.00 27.34           N  
ATOM    638  CA  ILE A  58      14.008  13.840  14.296  1.00 26.74           C  
ATOM    639  C   ILE A  58      13.621  13.983  12.814  1.00 25.81           C  
ATOM    640  O   ILE A  58      12.433  13.983  12.480  1.00 27.91           O  
ATOM    641  CB  ILE A  58      14.309  15.223  14.967  1.00 25.28           C  
ATOM    642  CG1 ILE A  58      14.137  15.098  16.488  1.00 27.60           C  
ATOM    643  CG2 ILE A  58      13.454  16.330  14.412  1.00 21.25           C  
ATOM    644  CD1 ILE A  58      12.774  14.594  16.966  1.00 24.44           C  
ATOM    645  N   PRO A  59      14.604  14.137  11.918  1.00 26.68           N  
ATOM    646  CA  PRO A  59      14.242  14.154  10.497  1.00 26.18           C  
ATOM    647  C   PRO A  59      13.510  12.892  10.024  1.00 27.29           C  
ATOM    648  O   PRO A  59      12.650  12.981   9.137  1.00 28.85           O  
ATOM    649  CB  PRO A  59      15.606  14.267   9.797  1.00 26.85           C  
ATOM    650  CG  PRO A  59      16.488  14.904  10.812  1.00 26.21           C  
ATOM    651  CD  PRO A  59      16.052  14.357  12.113  1.00 27.57           C  
ATOM    652  N   ARG A  60      13.859  11.727  10.577  1.00 26.62           N  
ATOM    653  CA  ARG A  60      13.132  10.492  10.264  1.00 26.02           C  
ATOM    654  C   ARG A  60      11.745  10.421  10.923  1.00 24.30           C  
ATOM    655  O   ARG A  60      10.766   9.971  10.311  1.00 22.95           O  
ATOM    656  CB  ARG A  60      13.965   9.267  10.590  1.00 25.32           C  
ATOM    657  CG  ARG A  60      15.025   9.039   9.568  1.00 25.14           C  
ATOM    658  CD  ARG A  60      15.846   7.807   9.861  1.00 27.78           C  
ATOM    659  NE  ARG A  60      16.525   7.359   8.650  1.00 29.32           N  
ATOM    660  CZ  ARG A  60      17.189   6.219   8.510  1.00 26.22           C  
ATOM    661  NH1 ARG A  60      17.335   5.381   9.521  1.00 27.61           N  
ATOM    662  NH2 ARG A  60      17.733   5.927   7.328  1.00 27.95           N  
ATOM    663  N   LEU A  61      11.665  10.876  12.156  1.00 24.79           N  
ATOM    664  CA  LEU A  61      10.376  11.007  12.822  1.00 25.91           C  
ATOM    665  C   LEU A  61       9.395  11.882  12.033  1.00 25.74           C  
ATOM    666  O   LEU A  61       8.262  11.486  11.799  1.00 28.68           O  
ATOM    667  CB  LEU A  61      10.583  11.572  14.229  1.00 26.01           C  
ATOM    668  CG  LEU A  61       9.363  11.806  15.107  1.00 26.95           C  
ATOM    669  CD1 LEU A  61       8.601  10.445  15.305  1.00 21.92           C  
ATOM    670  CD2 LEU A  61       9.790  12.513  16.433  1.00 24.72           C  
ATOM    671  N   ARG A  62       9.828  13.066  11.633  1.00 25.95           N  
ATOM    672  CA  ARG A  62       9.003  13.945  10.792  1.00 27.42           C  
ATOM    673  C   ARG A  62       8.510  13.272   9.513  1.00 27.15           C  
ATOM    674  O   ARG A  62       7.350  13.408   9.117  1.00 27.88           O  
ATOM    675  CB  ARG A  62       9.803  15.179  10.384  1.00 28.06           C  
ATOM    676  CG  ARG A  62      10.126  16.135  11.498  1.00 30.90           C  
ATOM    677  CD  ARG A  62      10.832  17.324  10.935  1.00 31.71           C  
ATOM    678  NE  ARG A  62      11.283  18.276  11.940  1.00 33.57           N  
ATOM    679  CZ  ARG A  62      10.508  19.185  12.526  1.00 37.52           C  
ATOM    680  NH1 ARG A  62       9.209  19.256  12.264  1.00 38.56           N  
ATOM    681  NH2 ARG A  62      11.034  20.011  13.403  1.00 43.29           N  
ATOM    682  N   PHE A  63       9.415  12.562   8.849  1.00 28.97           N  
ATOM    683  CA  PHE A  63       9.117  11.858   7.601  1.00 26.82           C  
ATOM    684  C   PHE A  63       8.082  10.775   7.831  1.00 26.81           C  
ATOM    685  O   PHE A  63       7.157  10.598   7.012  1.00 27.61           O  
ATOM    686  CB  PHE A  63      10.397  11.245   7.042  1.00 27.42           C  
ATOM    687  CG  PHE A  63      10.324  10.895   5.587  1.00 27.56           C  
ATOM    688  CD1 PHE A  63       9.660   9.750   5.166  1.00 24.71           C  
ATOM    689  CD2 PHE A  63      10.956  11.691   4.641  1.00 27.86           C  
ATOM    690  CE1 PHE A  63       9.609   9.417   3.836  1.00 26.94           C  
ATOM    691  CE2 PHE A  63      10.921  11.359   3.295  1.00 26.66           C  
ATOM    692  CZ  PHE A  63      10.242  10.226   2.883  1.00 27.07           C  
ATOM    693  N   ILE A  64       8.227  10.052   8.936  1.00 26.24           N  
ATOM    694  CA  ILE A  64       7.299   8.959   9.261  1.00 26.47           C  
ATOM    695  C   ILE A  64       5.900   9.536   9.463  1.00 27.86           C  
ATOM    696  O   ILE A  64       4.926   9.031   8.887  1.00 27.49           O  
ATOM    697  CB  ILE A  64       7.771   8.152  10.517  1.00 27.58           C  
ATOM    698  CG1 ILE A  64       8.930   7.212  10.151  1.00 25.07           C  
ATOM    699  CG2 ILE A  64       6.622   7.374  11.167  1.00 26.13           C  
ATOM    700  CD1 ILE A  64       9.755   6.700  11.415  1.00 26.69           C  
ATOM    701  N   LEU A  65       5.814  10.613  10.252  1.00 27.86           N  
ATOM    702  CA  LEU A  65       4.529  11.207  10.612  1.00 28.92           C  
ATOM    703  C   LEU A  65       3.845  11.887   9.420  1.00 28.10           C  
ATOM    704  O   LEU A  65       2.653  11.789   9.270  1.00 28.13           O  
ATOM    705  CB  LEU A  65       4.673  12.165  11.806  1.00 28.84           C  
ATOM    706  CG  LEU A  65       5.045  11.542  13.166  1.00 29.16           C  
ATOM    707  CD1 LEU A  65       5.457  12.628  14.142  1.00 25.45           C  
ATOM    708  CD2 LEU A  65       3.938  10.696  13.788  1.00 23.43           C  
ATOM    709  N   GLN A  66       4.622  12.507   8.550  1.00 30.58           N  
ATOM    710  CA  GLN A  66       4.112  13.151   7.355  1.00 32.23           C  
ATOM    711  C   GLN A  66       3.835  12.191   6.172  1.00 31.06           C  
ATOM    712  O   GLN A  66       2.804  12.285   5.533  1.00 28.54           O  
ATOM    713  CB  GLN A  66       5.092  14.245   6.927  1.00 30.80           C  
ATOM    714  CG  GLN A  66       4.521  15.217   5.904  1.00 40.29           C  
ATOM    715  CD  GLN A  66       5.545  16.242   5.461  1.00 40.59           C  
ATOM    716  OE1 GLN A  66       5.768  17.238   6.148  1.00 49.08           O  
ATOM    717  NE2 GLN A  66       6.179  16.000   4.293  1.00 48.33           N  
ATOM    718  N   GLU A  67       4.768  11.299   5.861  1.00 31.52           N  
ATOM    719  CA  GLU A  67       4.670  10.485   4.654  1.00 30.55           C  
ATOM    720  C   GLU A  67       4.053   9.098   4.908  1.00 30.74           C  
ATOM    721  O   GLU A  67       3.543   8.466   3.975  1.00 29.46           O  
ATOM    722  CB  GLU A  67       6.052  10.339   3.985  1.00 30.97           C  
ATOM    723  CG  GLU A  67       6.780  11.678   3.687  1.00 32.47           C  
ATOM    724  CD  GLU A  67       6.095  12.522   2.637  1.00 29.64           C  
ATOM    725  OE1 GLU A  67       5.425  11.948   1.772  1.00 35.59           O  
ATOM    726  OE2 GLU A  67       6.238  13.759   2.661  1.00 38.63           O  
ATOM    727  N   GLY A  68       4.097   8.621   6.155  1.00 31.39           N  
ATOM    728  CA  GLY A  68       3.677   7.246   6.455  1.00 30.84           C  
ATOM    729  C   GLY A  68       4.439   6.178   5.659  1.00 32.14           C  
ATOM    730  O   GLY A  68       5.609   6.370   5.321  1.00 32.67           O  
ATOM    731  N   GLU A  69       3.763   5.064   5.351  1.00 32.45           N  
ATOM    732  CA  GLU A  69       4.357   3.925   4.657  1.00 34.51           C  
ATOM    733  C   GLU A  69       4.362   4.052   3.139  1.00 37.04           C  
ATOM    734  O   GLU A  69       4.965   3.218   2.462  1.00 38.56           O  
ATOM    735  CB  GLU A  69       3.583   2.650   4.964  1.00 34.14           C  
ATOM    736  CG  GLU A  69       3.564   2.220   6.400  1.00 34.45           C  
ATOM    737  CD  GLU A  69       2.774   0.921   6.590  1.00 35.75           C  
ATOM    738  OE1 GLU A  69       2.674   0.114   5.629  1.00 38.62           O  
ATOM    739  OE2 GLU A  69       2.255   0.702   7.708  1.00 37.20           O  
ATOM    740  N   HIS A  70       3.668   5.057   2.607  1.00 38.35           N  
ATOM    741  CA  HIS A  70       3.640   5.322   1.166  1.00 41.30           C  
ATOM    742  C   HIS A  70       5.018   5.380   0.540  1.00 39.18           C  
ATOM    743  O   HIS A  70       5.186   5.010  -0.600  1.00 40.19           O  
ATOM    744  CB  HIS A  70       2.977   6.681   0.876  1.00 43.03           C  
ATOM    745  CG  HIS A  70       1.568   6.791   1.366  1.00 51.17           C  
ATOM    746  ND1 HIS A  70       1.233   7.468   2.522  1.00 61.13           N  
ATOM    747  CD2 HIS A  70       0.411   6.294   0.870  1.00 56.08           C  
ATOM    748  CE1 HIS A  70      -0.074   7.394   2.710  1.00 60.44           C  
ATOM    749  NE2 HIS A  70      -0.595   6.686   1.723  1.00 60.58           N  
ATOM    750  N   LYS A  71       5.981   5.879   1.296  1.00 38.16           N  
ATOM    751  CA  LYS A  71       7.254   6.325   0.779  1.00 38.77           C  
ATOM    752  C   LYS A  71       8.291   6.007   1.858  1.00 36.38           C  
ATOM    753  O   LYS A  71       8.110   6.364   3.037  1.00 35.39           O  
ATOM    754  CB  LYS A  71       7.136   7.836   0.565  1.00 40.42           C  
ATOM    755  CG  LYS A  71       8.263   8.526  -0.144  1.00 46.45           C  
ATOM    756  CD  LYS A  71       8.134  10.082  -0.038  1.00 44.57           C  
ATOM    757  CE  LYS A  71       7.187  10.683  -1.080  1.00 49.73           C  
ATOM    758  NZ  LYS A  71       7.168  12.186  -1.036  1.00 52.60           N  
ATOM    759  N   PRO A  72       9.361   5.289   1.493  1.00 35.25           N  
ATOM    760  CA  PRO A  72      10.363   5.019   2.511  1.00 32.67           C  
ATOM    761  C   PRO A  72      11.222   6.243   2.754  1.00 30.55           C  
ATOM    762  O   PRO A  72      11.435   7.025   1.825  1.00 31.79           O  
ATOM    763  CB  PRO A  72      11.169   3.852   1.918  1.00 32.97           C  
ATOM    764  CG  PRO A  72      11.031   3.992   0.476  1.00 33.32           C  
ATOM    765  CD  PRO A  72       9.698   4.655   0.203  1.00 35.69           C  
ATOM    766  N   PHE A  73      11.656   6.444   3.998  1.00 28.42           N  
ATOM    767  CA  PHE A  73      12.572   7.543   4.287  1.00 29.22           C  
ATOM    768  C   PHE A  73      13.934   7.190   3.696  1.00 29.99           C  
ATOM    769  O   PHE A  73      14.264   6.026   3.531  1.00 30.45           O  
ATOM    770  CB  PHE A  73      12.659   7.928   5.773  1.00 27.91           C  
ATOM    771  CG  PHE A  73      12.761   6.761   6.736  1.00 31.42           C  
ATOM    772  CD1 PHE A  73      13.981   6.132   6.971  1.00 27.68           C  
ATOM    773  CD2 PHE A  73      11.648   6.329   7.451  1.00 27.64           C  
ATOM    774  CE1 PHE A  73      14.081   5.108   7.873  1.00 27.03           C  
ATOM    775  CE2 PHE A  73      11.750   5.287   8.344  1.00 30.19           C  
ATOM    776  CZ  PHE A  73      12.948   4.669   8.546  1.00 29.44           C  
ATOM    777  N   PRO A  74      14.705   8.192   3.322  1.00 29.70           N  
ATOM    778  CA  PRO A  74      15.996   7.938   2.681  1.00 30.32           C  
ATOM    779  C   PRO A  74      17.000   7.145   3.539  1.00 29.69           C  
ATOM    780  O   PRO A  74      17.036   7.287   4.760  1.00 30.10           O  
ATOM    781  CB  PRO A  74      16.539   9.351   2.408  1.00 31.53           C  
ATOM    782  CG  PRO A  74      15.418  10.270   2.605  1.00 30.79           C  
ATOM    783  CD  PRO A  74      14.421   9.622   3.486  1.00 31.45           C  
ATOM    784  N   ALA A  75      17.790   6.293   2.893  1.00 31.81           N  
ATOM    785  CA  ALA A  75      19.023   5.766   3.503  1.00 31.95           C  
ATOM    786  C   ALA A  75      20.012   6.907   3.634  1.00 31.78           C  
ATOM    787  O   ALA A  75      19.921   7.926   2.925  1.00 33.77           O  
ATOM    788  CB  ALA A  75      19.634   4.653   2.653  1.00 27.58           C  
ATOM    789  N   PHE A  76      21.005   6.712   4.480  1.00 29.48           N  
ATOM    790  CA  PHE A  76      21.989   7.766   4.728  1.00 29.49           C  
ATOM    791  C   PHE A  76      23.140   7.854   3.723  1.00 31.66           C  
ATOM    792  O   PHE A  76      23.912   8.824   3.714  1.00 31.56           O  
ATOM    793  CB  PHE A  76      22.580   7.568   6.097  1.00 27.53           C  
ATOM    794  CG  PHE A  76      21.617   7.760   7.214  1.00 26.28           C  
ATOM    795  CD1 PHE A  76      21.038   9.012   7.437  1.00 27.47           C  
ATOM    796  CD2 PHE A  76      21.337   6.712   8.094  1.00 20.18           C  
ATOM    797  CE1 PHE A  76      20.154   9.206   8.491  1.00 25.36           C  
ATOM    798  CE2 PHE A  76      20.489   6.902   9.156  1.00 25.05           C  
ATOM    799  CZ  PHE A  76      19.878   8.161   9.346  1.00 25.95           C  
ATOM    800  N   ASP A  77      23.254   6.843   2.875  1.00 34.51           N  
ATOM    801  CA  ASP A  77      24.419   6.686   2.026  1.00 35.63           C  
ATOM    802  C   ASP A  77      24.420   7.542   0.762  1.00 35.64           C  
ATOM    803  O   ASP A  77      25.287   7.404  -0.060  1.00 37.99           O  
ATOM    804  CB  ASP A  77      24.619   5.209   1.698  1.00 35.72           C  
ATOM    805  CG  ASP A  77      23.453   4.603   0.931  1.00 38.75           C  
ATOM    806  OD1 ASP A  77      22.537   5.329   0.504  1.00 37.72           O  
ATOM    807  OD2 ASP A  77      23.468   3.371   0.761  1.00 53.43           O  
ATOM    808  N   ARG A  78      23.452   8.433   0.615  0.50 38.82           N  
ATOM    810  CA  ARG A  78      23.380   9.294  -0.568  0.50 40.28           C  
ATOM    812  C   ARG A  78      23.526  10.779  -0.228  0.50 38.88           C  
ATOM    814  O   ARG A  78      23.383  11.630  -1.107  0.50 39.45           O  
ATOM    816  CB  ARG A  78      22.061   9.034  -1.313  0.50 41.16           C  
ATOM    818  CG  ARG A  78      22.169   8.042  -2.475  0.50 43.28           C  
ATOM    820  CD  ARG A  78      20.864   7.255  -2.674  0.50 44.01           C  
ATOM    822  NE  ARG A  78      19.673   8.106  -2.736  0.50 41.93           N  
ATOM    824  CZ  ARG A  78      19.303   8.822  -3.793  0.50 44.90           C  
ATOM    826  NH1 ARG A  78      20.039   8.823  -4.904  0.50 47.38           N  
ATOM    828  NH2 ARG A  78      18.192   9.551  -3.736  0.50 41.45           N  
ATOM    830  N   PHE A  79      23.809  11.083   1.039  1.00 37.18           N  
ATOM    831  CA  PHE A  79      23.929  12.458   1.513  1.00 35.90           C  
ATOM    832  C   PHE A  79      25.188  12.566   2.373  1.00 33.94           C  
ATOM    833  O   PHE A  79      25.206  12.097   3.490  1.00 35.24           O  
ATOM    834  CB  PHE A  79      22.675  12.756   2.349  1.00 36.90           C  
ATOM    835  CG  PHE A  79      22.359  14.213   2.522  1.00 30.74           C  
ATOM    836  CD1 PHE A  79      22.918  14.923   3.548  1.00 26.26           C  
ATOM    837  CD2 PHE A  79      21.440  14.840   1.687  1.00 30.49           C  
ATOM    838  CE1 PHE A  79      22.608  16.253   3.737  1.00 33.38           C  
ATOM    839  CE2 PHE A  79      21.110  16.178   1.878  1.00 31.96           C  
ATOM    840  CZ  PHE A  79      21.692  16.880   2.907  1.00 27.11           C  
ATOM    841  N   SER A  80      26.245  13.149   1.841  1.00 33.02           N  
ATOM    842  CA  SER A  80      27.543  13.126   2.500  1.00 33.33           C  
ATOM    843  C   SER A  80      27.696  14.274   3.490  1.00 33.01           C  
ATOM    844  O   SER A  80      26.968  15.250   3.402  1.00 31.09           O  
ATOM    845  CB  SER A  80      28.641  13.245   1.456  1.00 34.16           C  
ATOM    846  OG  SER A  80      28.497  14.463   0.743  1.00 36.58           O  
ATOM    847  N   HIS A  81      28.669  14.164   4.403  1.00 31.29           N  
ATOM    848  CA  HIS A  81      28.992  15.258   5.306  1.00 31.17           C  
ATOM    849  C   HIS A  81      30.475  15.491   5.329  1.00 32.84           C  
ATOM    850  O   HIS A  81      31.249  14.539   5.212  1.00 36.30           O  
ATOM    851  CB  HIS A  81      28.524  14.966   6.746  1.00 29.20           C  
ATOM    852  CG  HIS A  81      27.118  14.481   6.837  1.00 30.44           C  
ATOM    853  ND1 HIS A  81      26.047  15.332   6.956  1.00 30.98           N  
ATOM    854  CD2 HIS A  81      26.601  13.230   6.761  1.00 41.60           C  
ATOM    855  CE1 HIS A  81      24.932  14.625   6.986  1.00 34.84           C  
ATOM    856  NE2 HIS A  81      25.239  13.348   6.860  1.00 31.63           N  
ATOM    857  N   LEU A  82      30.872  16.744   5.541  1.00 32.29           N  
ATOM    858  CA  LEU A  82      32.284  17.064   5.666  1.00 34.24           C  
ATOM    859  C   LEU A  82      32.818  16.446   6.935  1.00 34.38           C  
ATOM    860  O   LEU A  82      32.186  16.553   7.988  1.00 36.03           O  
ATOM    861  CB  LEU A  82      32.515  18.585   5.680  1.00 33.98           C  
ATOM    862  CG  LEU A  82      32.351  19.336   4.354  1.00 38.48           C  
ATOM    863  CD1 LEU A  82      32.406  20.859   4.557  1.00 36.36           C  
ATOM    864  CD2 LEU A  82      33.406  18.904   3.368  1.00 41.46           C  
ATOM    865  N   ASN A  83      33.970  15.788   6.831  1.00 34.91           N  
ATOM    866  CA  ASN A  83      34.720  15.357   8.011  1.00 37.31           C  
ATOM    867  C   ASN A  83      35.071  16.586   8.789  1.00 39.61           C  
ATOM    868  O   ASN A  83      35.463  17.575   8.192  1.00 44.14           O  
ATOM    869  CB  ASN A  83      36.021  14.660   7.630  1.00 36.92           C  
ATOM    870  CG  ASN A  83      35.789  13.321   7.004  1.00 36.04           C  
ATOM    871  OD1 ASN A  83      34.646  12.919   6.802  1.00 37.97           O  
ATOM    872  ND2 ASN A  83      36.863  12.621   6.679  1.00 41.14           N  
ATOM    873  N   GLN A  84      34.938  16.537  10.110  1.00 40.78           N  
ATOM    874  CA  GLN A  84      35.210  17.697  10.944  1.00 41.39           C  
ATOM    875  C   GLN A  84      36.534  17.610  11.636  1.00 41.62           C  
ATOM    876  O   GLN A  84      37.127  16.543  11.759  1.00 45.06           O  
ATOM    877  CB  GLN A  84      34.117  17.882  11.978  1.00 41.46           C  
ATOM    878  CG  GLN A  84      32.777  17.967  11.345  1.00 48.16           C  
ATOM    879  CD  GLN A  84      31.781  18.514  12.261  1.00 53.33           C  
ATOM    880  OE1 GLN A  84      30.874  17.801  12.698  1.00 61.82           O  
ATOM    881  NE2 GLN A  84      31.940  19.789  12.608  1.00 58.52           N  
ATOM    882  N   SER A  85      36.976  18.769  12.100  1.00 43.12           N  
ATOM    883  CA  SER A  85      38.273  18.947  12.722  1.00 43.34           C  
ATOM    884  C   SER A  85      38.188  18.418  14.137  1.00 39.63           C  
ATOM    885  O   SER A  85      37.277  18.795  14.853  1.00 38.44           O  
ATOM    886  CB  SER A  85      38.619  20.459  12.717  1.00 43.98           C  
ATOM    887  OG  SER A  85      39.937  20.723  13.186  1.00 48.95           O  
ATOM    888  N   ASN A  86      39.112  17.540  14.521  1.00 37.39           N  
ATOM    889  CA  ASN A  86      39.373  17.284  15.939  1.00 39.60           C  
ATOM    890  C   ASN A  86      39.929  18.485  16.721  1.00 40.83           C  
ATOM    891  O   ASN A  86      40.089  18.408  17.931  1.00 41.01           O  
ATOM    892  CB  ASN A  86      40.312  16.079  16.158  1.00 44.15           C  
ATOM    893  CG  ASN A  86      41.295  15.841  15.001  1.00 45.60           C  
ATOM    894  N   ALA A  87      40.236  19.586  16.041  1.00 42.48           N  
ATOM    895  CA  ALA A  87      40.853  20.737  16.700  1.00 41.83           C  
ATOM    896  C   ALA A  87      39.863  21.610  17.495  1.00 39.97           C  
ATOM    897  O   ALA A  87      40.294  22.355  18.374  1.00 38.96           O  
ATOM    898  CB  ALA A  87      41.621  21.596  15.676  1.00 42.50           C  
ATOM    899  N   VAL A  88      38.563  21.532  17.173  1.00 37.21           N  
ATOM    900  CA  VAL A  88      37.528  22.221  17.949  1.00 36.18           C  
ATOM    901  C   VAL A  88      37.534  21.671  19.380  1.00 34.33           C  
ATOM    902  O   VAL A  88      37.463  20.477  19.597  1.00 35.12           O  
ATOM    903  CB  VAL A  88      36.102  22.104  17.303  1.00 36.50           C  
ATOM    904  CG1 VAL A  88      35.019  22.741  18.207  1.00 29.26           C  
ATOM    905  CG2 VAL A  88      36.084  22.768  15.905  1.00 32.30           C  
ATOM    906  N   PRO A  89      37.643  22.547  20.370  1.00 32.78           N  
ATOM    907  CA  PRO A  89      37.691  22.016  21.715  1.00 32.24           C  
ATOM    908  C   PRO A  89      36.451  21.212  22.075  1.00 31.76           C  
ATOM    909  O   PRO A  89      35.317  21.627  21.760  1.00 29.66           O  
ATOM    910  CB  PRO A  89      37.780  23.280  22.598  1.00 33.20           C  
ATOM    911  CG  PRO A  89      38.289  24.359  21.701  1.00 32.70           C  
ATOM    912  CD  PRO A  89      37.749  24.018  20.341  1.00 33.73           C  
ATOM    913  N   ILE A  90      36.668  20.082  22.748  1.00 29.51           N  
ATOM    914  CA  ILE A  90      35.565  19.193  23.111  1.00 27.95           C  
ATOM    915  C   ILE A  90      34.489  19.939  23.932  1.00 28.52           C  
ATOM    916  O   ILE A  90      33.312  19.649  23.814  1.00 29.82           O  
ATOM    917  CB  ILE A  90      36.063  17.893  23.818  1.00 26.62           C  
ATOM    918  CG1 ILE A  90      35.032  16.769  23.671  1.00 27.96           C  
ATOM    919  CG2 ILE A  90      36.409  18.163  25.266  1.00 25.82           C  
ATOM    920  CD1 ILE A  90      35.444  15.460  24.214  1.00 25.32           C  
ATOM    921  N   SER A  91      34.872  20.929  24.719  1.00 29.00           N  
ATOM    922  CA  SER A  91      33.885  21.725  25.473  1.00 29.21           C  
ATOM    923  C   SER A  91      32.812  22.342  24.561  1.00 28.90           C  
ATOM    924  O   SER A  91      31.629  22.447  24.942  1.00 26.57           O  
ATOM    925  CB  SER A  91      34.607  22.832  26.271  1.00 30.11           C  
ATOM    926  OG  SER A  91      35.419  23.641  25.414  1.00 38.43           O  
ATOM    927  N   GLU A  92      33.230  22.743  23.356  1.00 28.09           N  
ATOM    928  CA  GLU A  92      32.311  23.291  22.364  1.00 30.51           C  
ATOM    929  C   GLU A  92      31.323  22.250  21.824  1.00 28.39           C  
ATOM    930  O   GLU A  92      30.149  22.552  21.603  1.00 27.89           O  
ATOM    931  CB  GLU A  92      33.078  23.939  21.213  1.00 29.37           C  
ATOM    932  CG  GLU A  92      33.794  25.208  21.619  1.00 35.10           C  
ATOM    933  CD  GLU A  92      34.370  25.964  20.425  1.00 38.17           C  
ATOM    934  OE1 GLU A  92      33.791  25.925  19.293  1.00 41.90           O  
ATOM    935  OE2 GLU A  92      35.419  26.619  20.635  1.00 56.07           O  
ATOM    936  N   ARG A  93      31.810  21.034  21.656  1.00 25.68           N  
ATOM    937  CA  ARG A  93      30.995  19.926  21.192  1.00 27.43           C  
ATOM    938  C   ARG A  93      29.916  19.604  22.181  1.00 26.03           C  
ATOM    939  O   ARG A  93      28.808  19.337  21.781  1.00 27.05           O  
ATOM    940  CB  ARG A  93      31.830  18.652  21.013  1.00 26.86           C  
ATOM    941  CG  ARG A  93      33.026  18.796  20.130  1.00 27.78           C  
ATOM    942  CD  ARG A  93      32.604  19.222  18.781  1.00 27.77           C  
ATOM    943  NE  ARG A  93      33.671  19.126  17.792  1.00 29.80           N  
ATOM    944  CZ  ARG A  93      33.504  19.498  16.523  1.00 31.50           C  
ATOM    945  NH1 ARG A  93      32.330  19.951  16.123  1.00 33.89           N  
ATOM    946  NH2 ARG A  93      34.481  19.371  15.638  1.00 33.56           N  
ATOM    947  N   PHE A  94      30.256  19.618  23.467  1.00 26.53           N  
ATOM    948  CA  PHE A  94      29.281  19.334  24.533  1.00 30.13           C  
ATOM    949  C   PHE A  94      28.180  20.380  24.592  1.00 30.58           C  
ATOM    950  O   PHE A  94      27.022  20.079  24.858  1.00 31.07           O  
ATOM    951  CB  PHE A  94      29.961  19.309  25.906  1.00 29.00           C  
ATOM    952  CG  PHE A  94      30.956  18.212  26.076  1.00 30.34           C  
ATOM    953  CD1 PHE A  94      30.671  16.929  25.673  1.00 34.34           C  
ATOM    954  CD2 PHE A  94      32.158  18.463  26.677  1.00 29.98           C  
ATOM    955  CE1 PHE A  94      31.584  15.924  25.852  1.00 34.14           C  
ATOM    956  CE2 PHE A  94      33.072  17.464  26.856  1.00 35.51           C  
ATOM    957  CZ  PHE A  94      32.791  16.194  26.444  1.00 28.02           C  
ATOM    958  N   LYS A  95      28.571  21.628  24.385  1.00 32.49           N  
ATOM    959  CA  LYS A  95      27.616  22.720  24.373  1.00 33.77           C  
ATOM    960  C   LYS A  95      26.650  22.532  23.187  1.00 31.26           C  
ATOM    961  O   LYS A  95      25.440  22.651  23.345  1.00 30.42           O  
ATOM    962  CB  LYS A  95      28.362  24.046  24.290  1.00 32.07           C  
ATOM    963  CG  LYS A  95      27.515  25.235  24.496  1.00 39.75           C  
ATOM    964  CD  LYS A  95      28.264  26.514  24.188  1.00 40.81           C  
ATOM    965  CE  LYS A  95      27.356  27.741  24.412  1.00 48.04           C  
ATOM    966  NZ  LYS A  95      27.966  28.988  23.826  1.00 56.62           N  
ATOM    967  N   GLU A  96      27.202  22.223  22.013  1.00 29.31           N  
ATOM    968  CA  GLU A  96      26.405  21.978  20.827  1.00 31.10           C  
ATOM    969  C   GLU A  96      25.460  20.785  21.001  1.00 29.97           C  
ATOM    970  O   GLU A  96      24.286  20.868  20.635  1.00 31.17           O  
ATOM    971  CB  GLU A  96      27.279  21.771  19.580  1.00 30.04           C  
ATOM    972  CG  GLU A  96      26.446  21.751  18.328  1.00 32.14           C  
ATOM    973  CD  GLU A  96      27.249  21.621  17.043  1.00 35.40           C  
ATOM    974  OE1 GLU A  96      28.377  21.081  17.073  1.00 35.11           O  
ATOM    975  OE2 GLU A  96      26.723  22.051  15.989  1.00 41.16           O  
ATOM    976  N   PHE A  97      25.966  19.689  21.557  1.00 28.58           N  
ATOM    977  CA  PHE A  97      25.158  18.466  21.750  1.00 28.46           C  
ATOM    978  C   PHE A  97      23.962  18.703  22.697  1.00 28.26           C  
ATOM    979  O   PHE A  97      22.840  18.227  22.457  1.00 27.88           O  
ATOM    980  CB  PHE A  97      26.067  17.307  22.238  1.00 26.31           C  
ATOM    981  CG  PHE A  97      25.340  15.981  22.439  1.00 26.44           C  
ATOM    982  CD1 PHE A  97      24.399  15.526  21.522  1.00 26.11           C  
ATOM    983  CD2 PHE A  97      25.638  15.176  23.531  1.00 26.93           C  
ATOM    984  CE1 PHE A  97      23.730  14.325  21.708  1.00 26.62           C  
ATOM    985  CE2 PHE A  97      24.964  13.948  23.740  1.00 31.32           C  
ATOM    986  CZ  PHE A  97      24.012  13.516  22.823  1.00 25.16           C  
ATOM    987  N   GLN A  98      24.212  19.445  23.770  1.00 29.04           N  
ATOM    988  CA  GLN A  98      23.176  19.756  24.745  1.00 28.94           C  
ATOM    989  C   GLN A  98      22.119  20.664  24.118  1.00 28.15           C  
ATOM    990  O   GLN A  98      20.916  20.489  24.339  1.00 28.60           O  
ATOM    991  CB  GLN A  98      23.799  20.410  26.009  1.00 28.76           C  
ATOM    992  CG  GLN A  98      22.781  20.937  27.043  1.00 33.58           C  
ATOM    993  CD  GLN A  98      21.863  19.817  27.648  1.00 52.55           C  
ATOM    994  OE1 GLN A  98      22.062  19.403  28.817  1.00 44.70           O  
ATOM    995  NE2 GLN A  98      20.850  19.333  26.849  1.00 35.28           N  
ATOM    996  N   GLN A  99      22.561  21.637  23.340  1.00 28.67           N  
ATOM    997  CA  GLN A  99      21.626  22.528  22.670  1.00 29.36           C  
ATOM    998  C   GLN A  99      20.748  21.778  21.679  1.00 28.20           C  
ATOM    999  O   GLN A  99      19.512  21.989  21.637  1.00 28.72           O  
ATOM   1000  CB  GLN A  99      22.357  23.697  21.982  1.00 29.90           C  
ATOM   1001  CG  GLN A  99      21.437  24.656  21.205  1.00 34.73           C  
ATOM   1002  CD  GLN A  99      20.329  25.304  22.097  1.00 51.74           C  
ATOM   1003  OE1 GLN A  99      20.577  25.652  23.257  1.00 55.21           O  
ATOM   1004  NE2 GLN A  99      19.111  25.449  21.549  1.00 50.15           N  
ATOM   1005  N   LEU A 100      21.368  20.926  20.863  1.00 25.94           N  
ATOM   1006  CA  LEU A 100      20.638  20.214  19.823  1.00 26.03           C  
ATOM   1007  C   LEU A 100      19.686  19.191  20.425  1.00 28.16           C  
ATOM   1008  O   LEU A 100      18.564  18.992  19.924  1.00 27.67           O  
ATOM   1009  CB  LEU A 100      21.595  19.515  18.874  1.00 27.64           C  
ATOM   1010  CG  LEU A 100      22.365  20.396  17.889  1.00 29.22           C  
ATOM   1011  CD1 LEU A 100      23.516  19.615  17.273  1.00 22.52           C  
ATOM   1012  CD2 LEU A 100      21.419  20.956  16.817  1.00 22.15           C  
ATOM   1013  N   ARG A 101      20.128  18.539  21.504  1.00 28.54           N  
ATOM   1014  CA  ARG A 101      19.274  17.562  22.181  1.00 28.48           C  
ATOM   1015  C   ARG A 101      18.055  18.257  22.822  1.00 27.89           C  
ATOM   1016  O   ARG A 101      16.927  17.764  22.761  1.00 26.38           O  
ATOM   1017  CB  ARG A 101      20.091  16.749  23.198  1.00 27.26           C  
ATOM   1018  CG  ARG A 101      19.285  15.715  23.962  1.00 26.30           C  
ATOM   1019  CD  ARG A 101      18.549  14.733  23.063  1.00 24.94           C  
ATOM   1020  NE  ARG A 101      19.472  13.943  22.266  1.00 23.02           N  
ATOM   1021  CZ  ARG A 101      20.059  12.819  22.666  1.00 27.06           C  
ATOM   1022  NH1 ARG A 101      19.849  12.325  23.875  1.00 23.68           N  
ATOM   1023  NH2 ARG A 101      20.871  12.166  21.836  1.00 29.54           N  
ATOM   1024  N   LYS A 102      18.291  19.405  23.435  1.00 27.35           N  
ATOM   1025  CA  LYS A 102      17.242  20.137  24.073  1.00 29.95           C  
ATOM   1026  C   LYS A 102      16.164  20.514  23.050  1.00 29.33           C  
ATOM   1027  O   LYS A 102      14.978  20.249  23.277  1.00 31.48           O  
ATOM   1028  CB  LYS A 102      17.837  21.373  24.771  1.00 31.28           C  
ATOM   1029  CG  LYS A 102      16.812  22.368  25.324  1.00 36.92           C  
ATOM   1030  CD  LYS A 102      17.476  23.505  26.140  1.00 35.40           C  
ATOM   1031  CE  LYS A 102      16.425  24.494  26.691  1.00 45.23           C  
ATOM   1032  NZ  LYS A 102      16.181  25.683  25.785  1.00 52.30           N  
ATOM   1033  N   GLU A 103      16.576  21.134  21.941  1.00 29.14           N  
ATOM   1034  CA  GLU A 103      15.693  21.425  20.796  1.00 30.31           C  
ATOM   1035  C   GLU A 103      14.929  20.206  20.275  1.00 28.68           C  
ATOM   1036  O   GLU A 103      13.720  20.252  20.081  1.00 27.31           O  
ATOM   1037  CB  GLU A 103      16.507  21.991  19.642  1.00 30.08           C  
ATOM   1038  CG  GLU A 103      16.977  23.434  19.819  1.00 39.16           C  
ATOM   1039  CD  GLU A 103      18.062  23.871  18.807  1.00 38.83           C  
ATOM   1040  OE1 GLU A 103      18.319  23.147  17.807  1.00 50.76           O  
ATOM   1041  OE2 GLU A 103      18.660  24.952  19.029  1.00 47.51           O  
ATOM   1042  N   ASN A 104      15.647  19.100  20.087  1.00 28.00           N  
ATOM   1043  CA  ASN A 104      15.077  17.872  19.547  1.00 26.48           C  
ATOM   1044  C   ASN A 104      14.023  17.202  20.435  1.00 26.40           C  
ATOM   1045  O   ASN A 104      13.061  16.565  19.938  1.00 25.30           O  
ATOM   1046  CB  ASN A 104      16.213  16.884  19.231  1.00 28.35           C  
ATOM   1047  CG  ASN A 104      16.896  17.190  17.933  1.00 27.83           C  
ATOM   1048  OD1 ASN A 104      16.359  17.923  17.114  1.00 27.00           O  
ATOM   1049  ND2 ASN A 104      18.076  16.620  17.722  1.00 26.86           N  
ATOM   1050  N   LEU A 105      14.195  17.337  21.743  1.00 25.22           N  
ATOM   1051  CA  LEU A 105      13.190  16.845  22.699  1.00 26.51           C  
ATOM   1052  C   LEU A 105      11.901  17.724  22.732  1.00 25.33           C  
ATOM   1053  O   LEU A 105      10.797  17.217  22.888  1.00 22.77           O  
ATOM   1054  CB  LEU A 105      13.830  16.687  24.088  1.00 27.22           C  
ATOM   1055  CG  LEU A 105      14.880  15.590  24.252  1.00 27.65           C  
ATOM   1056  CD1 LEU A 105      15.424  15.580  25.702  1.00 22.92           C  
ATOM   1057  CD2 LEU A 105      14.245  14.244  23.882  1.00 23.51           C  
ATOM   1058  N   ASN A 106      12.041  19.032  22.550  1.00 26.57           N  
ATOM   1059  CA  ASN A 106      10.873  19.885  22.289  1.00 26.43           C  
ATOM   1060  C   ASN A 106      10.113  19.478  21.033  1.00 27.02           C  
ATOM   1061  O   ASN A 106       8.921  19.241  21.090  1.00 27.40           O  
ATOM   1062  CB  ASN A 106      11.282  21.354  22.189  1.00 27.65           C  
ATOM   1063  CG  ASN A 106      11.668  21.948  23.535  1.00 28.18           C  
ATOM   1064  OD1 ASN A 106      11.339  21.412  24.594  1.00 36.22           O  
ATOM   1065  ND2 ASN A 106      12.365  23.057  23.495  1.00 27.77           N  
ATOM   1066  N   THR A 107      10.806  19.382  19.898  1.00 27.73           N  
ATOM   1067  CA  THR A 107      10.196  18.859  18.681  1.00 26.10           C  
ATOM   1068  C   THR A 107       9.502  17.499  18.894  1.00 27.56           C  
ATOM   1069  O   THR A 107       8.387  17.280  18.398  1.00 27.42           O  
ATOM   1070  CB  THR A 107      11.221  18.705  17.563  1.00 26.16           C  
ATOM   1071  OG1 THR A 107      11.930  19.933  17.413  1.00 21.34           O  
ATOM   1072  CG2 THR A 107      10.517  18.337  16.252  1.00 22.23           C  
ATOM   1073  N   LEU A 108      10.160  16.580  19.602  1.00 27.28           N  
ATOM   1074  CA  LEU A 108       9.580  15.241  19.827  1.00 27.27           C  
ATOM   1075  C   LEU A 108       8.219  15.370  20.497  1.00 28.31           C  
ATOM   1076  O   LEU A 108       7.243  14.729  20.083  1.00 27.67           O  
ATOM   1077  CB  LEU A 108      10.522  14.357  20.676  1.00 28.26           C  
ATOM   1078  CG  LEU A 108      10.025  13.067  21.332  1.00 25.38           C  
ATOM   1079  CD1 LEU A 108       9.501  12.142  20.255  1.00 24.87           C  
ATOM   1080  CD2 LEU A 108      11.215  12.435  22.096  1.00 20.44           C  
ATOM   1081  N   ARG A 109       8.157  16.212  21.527  1.00 29.56           N  
ATOM   1082  CA  ARG A 109       6.910  16.420  22.267  1.00 29.52           C  
ATOM   1083  C   ARG A 109       5.832  17.120  21.440  1.00 29.80           C  
ATOM   1084  O   ARG A 109       4.661  16.914  21.698  1.00 35.24           O  
ATOM   1085  CB  ARG A 109       7.165  17.229  23.520  1.00 28.13           C  
ATOM   1086  CG  ARG A 109       7.981  16.518  24.570  1.00 30.59           C  
ATOM   1087  CD  ARG A 109       8.309  17.512  25.719  1.00 32.22           C  
ATOM   1088  NE  ARG A 109       9.436  16.992  26.459  1.00 40.89           N  
ATOM   1089  CZ  ARG A 109      10.635  17.553  26.575  1.00 35.86           C  
ATOM   1090  NH1 ARG A 109      10.922  18.749  26.053  1.00 31.64           N  
ATOM   1091  NH2 ARG A 109      11.557  16.890  27.265  1.00 41.54           N  
ATOM   1092  N   SER A 110       6.226  17.956  20.481  1.00 28.18           N  
ATOM   1093  CA  SER A 110       5.301  18.589  19.547  1.00 29.38           C  
ATOM   1094  C   SER A 110       4.708  17.576  18.624  1.00 27.96           C  
ATOM   1095  O   SER A 110       3.508  17.592  18.386  1.00 29.40           O  
ATOM   1096  CB  SER A 110       6.006  19.662  18.690  1.00 29.67           C  
ATOM   1097  OG  SER A 110       6.388  20.765  19.503  1.00 39.46           O  
ATOM   1098  N   LEU A 111       5.556  16.689  18.108  1.00 29.41           N  
ATOM   1099  CA  LEU A 111       5.140  15.723  17.073  1.00 29.68           C  
ATOM   1100  C   LEU A 111       4.461  14.482  17.631  1.00 29.02           C  
ATOM   1101  O   LEU A 111       3.480  14.023  17.062  1.00 29.88           O  
ATOM   1102  CB  LEU A 111       6.318  15.291  16.206  1.00 28.42           C  
ATOM   1103  CG  LEU A 111       7.012  16.421  15.466  1.00 31.22           C  
ATOM   1104  CD1 LEU A 111       8.307  15.900  14.854  1.00 26.11           C  
ATOM   1105  CD2 LEU A 111       6.117  17.066  14.420  1.00 29.55           C  
ATOM   1106  N   VAL A 112       5.006  13.921  18.712  1.00 28.84           N  
ATOM   1107  CA  VAL A 112       4.450  12.730  19.323  1.00 27.53           C  
ATOM   1108  C   VAL A 112       3.730  13.093  20.619  1.00 28.75           C  
ATOM   1109  O   VAL A 112       4.353  13.271  21.660  1.00 29.24           O  
ATOM   1110  CB  VAL A 112       5.533  11.686  19.619  1.00 28.73           C  
ATOM   1111  CG1 VAL A 112       4.894  10.430  20.298  1.00 22.57           C  
ATOM   1112  CG2 VAL A 112       6.266  11.317  18.336  1.00 22.73           C  
ATOM   1113  N   GLN A 113       2.406  13.166  20.547  1.00 29.65           N  
ATOM   1114  CA  GLN A 113       1.592  13.703  21.648  1.00 31.39           C  
ATOM   1115  C   GLN A 113       0.702  12.681  22.328  1.00 32.17           C  
ATOM   1116  O   GLN A 113       0.274  12.897  23.461  1.00 32.79           O  
ATOM   1117  CB  GLN A 113       0.716  14.836  21.130  1.00 31.95           C  
ATOM   1118  CG  GLN A 113       1.492  16.003  20.500  1.00 34.18           C  
ATOM   1119  CD  GLN A 113       0.704  17.292  20.557  1.00 35.37           C  
ATOM   1120  OE1 GLN A 113      -0.503  17.294  20.326  1.00 45.26           O  
ATOM   1121  NE2 GLN A 113       1.374  18.396  20.893  1.00 41.05           N  
ATOM   1122  N   SER A 114       0.436  11.565  21.644  1.00 33.82           N  
ATOM   1123  CA  SER A 114      -0.400  10.490  22.180  1.00 32.83           C  
ATOM   1124  C   SER A 114       0.260   9.146  21.982  1.00 31.19           C  
ATOM   1125  O   SER A 114       1.127   8.995  21.138  1.00 30.60           O  
ATOM   1126  CB  SER A 114      -1.755  10.466  21.470  1.00 33.17           C  
ATOM   1127  OG  SER A 114      -1.611  10.048  20.119  1.00 37.72           O  
ATOM   1128  N   GLU A 115      -0.176   8.176  22.771  1.00 29.64           N  
ATOM   1129  CA  GLU A 115       0.131   6.780  22.545  1.00 30.45           C  
ATOM   1130  C   GLU A 115      -0.188   6.325  21.109  1.00 30.66           C  
ATOM   1131  O   GLU A 115       0.515   5.487  20.550  1.00 30.59           O  
ATOM   1132  CB  GLU A 115      -0.739   5.950  23.475  1.00 32.11           C  
ATOM   1133  CG  GLU A 115      -0.448   6.094  24.949  1.00 39.35           C  
ATOM   1134  CD  GLU A 115       0.284   4.893  25.485  1.00 46.57           C  
ATOM   1135  OE1 GLU A 115       1.398   4.612  24.954  1.00 43.24           O  
ATOM   1136  OE2 GLU A 115      -0.271   4.250  26.420  1.00 51.26           O  
ATOM   1137  N   ALA A 116      -1.286   6.822  20.533  1.00 29.43           N  
ATOM   1138  CA  ALA A 116      -1.612   6.499  19.147  1.00 30.05           C  
ATOM   1139  C   ALA A 116      -0.474   6.918  18.194  1.00 29.05           C  
ATOM   1140  O   ALA A 116      -0.195   6.219  17.239  1.00 29.65           O  
ATOM   1141  CB  ALA A 116      -2.940   7.126  18.726  1.00 29.08           C  
ATOM   1142  N   ASP A 117       0.199   8.030  18.474  1.00 29.49           N  
ATOM   1143  CA  ASP A 117       1.287   8.527  17.592  1.00 30.82           C  
ATOM   1144  C   ASP A 117       2.526   7.603  17.567  1.00 30.70           C  
ATOM   1145  O   ASP A 117       3.269   7.556  16.581  1.00 28.48           O  
ATOM   1146  CB  ASP A 117       1.706   9.962  17.972  1.00 30.99           C  
ATOM   1147  CG  ASP A 117       0.598  11.000  17.727  1.00 34.71           C  
ATOM   1148  OD1 ASP A 117      -0.252  10.816  16.807  1.00 39.61           O  
ATOM   1149  OD2 ASP A 117       0.604  12.022  18.443  1.00 38.97           O  
ATOM   1150  N   LEU A 118       2.718   6.880  18.667  1.00 29.95           N  
ATOM   1151  CA  LEU A 118       3.760   5.888  18.788  1.00 29.65           C  
ATOM   1152  C   LEU A 118       3.552   4.660  17.858  1.00 30.15           C  
ATOM   1153  O   LEU A 118       4.522   4.011  17.440  1.00 28.68           O  
ATOM   1154  CB  LEU A 118       3.852   5.448  20.258  1.00 29.17           C  
ATOM   1155  CG  LEU A 118       4.346   6.503  21.257  1.00 29.52           C  
ATOM   1156  CD1 LEU A 118       4.182   5.990  22.660  1.00 25.25           C  
ATOM   1157  CD2 LEU A 118       5.824   6.845  21.023  1.00 30.13           C  
ATOM   1158  N   GLU A 119       2.291   4.338  17.554  1.00 29.68           N  
ATOM   1159  CA  GLU A 119       1.938   3.158  16.743  1.00 29.60           C  
ATOM   1160  C   GLU A 119       1.906   3.482  15.245  1.00 29.77           C  
ATOM   1161  O   GLU A 119       1.619   2.612  14.403  1.00 30.49           O  
ATOM   1162  CB  GLU A 119       0.574   2.594  17.193  1.00 29.98           C  
ATOM   1163  CG  GLU A 119       0.544   2.066  18.658  1.00 32.79           C  
ATOM   1164  CD  GLU A 119       1.678   1.073  18.982  1.00 35.95           C  
ATOM   1165  OE1 GLU A 119       1.863   0.073  18.241  1.00 36.16           O  
ATOM   1166  OE2 GLU A 119       2.380   1.304  20.003  1.00 46.69           O  
ATOM   1167  N   ARG A 120       2.218   4.732  14.928  1.00 29.05           N  
ATOM   1168  CA  ARG A 120       2.331   5.185  13.560  1.00 28.72           C  
ATOM   1169  C   ARG A 120       3.533   4.614  12.853  1.00 28.84           C  
ATOM   1170  O   ARG A 120       4.631   4.507  13.417  1.00 28.99           O  
ATOM   1171  CB  ARG A 120       2.279   6.704  13.497  1.00 29.20           C  
ATOM   1172  CG  ARG A 120       0.853   7.099  13.922  1.00 35.82           C  
ATOM   1173  CD  ARG A 120       0.583   8.525  13.901  1.00 40.50           C  
ATOM   1174  NE  ARG A 120       0.782   9.081  12.584  1.00 42.20           N  
ATOM   1175  CZ  ARG A 120       0.540  10.348  12.299  1.00 41.58           C  
ATOM   1176  NH1 ARG A 120       0.061  11.166  13.233  1.00 42.95           N  
ATOM   1177  NH2 ARG A 120       0.780  10.786  11.077  1.00 43.22           N  
ATOM   1178  N   THR A 121       3.277   4.210  11.616  1.00 27.42           N  
ATOM   1179  CA  THR A 121       4.197   3.446  10.833  1.00 28.22           C  
ATOM   1180  C   THR A 121       4.681   4.239   9.616  1.00 27.84           C  
ATOM   1181  O   THR A 121       3.932   4.998   8.980  1.00 24.28           O  
ATOM   1182  CB  THR A 121       3.542   2.142  10.338  1.00 31.07           C  
ATOM   1183  OG1 THR A 121       2.394   2.466   9.537  1.00 33.98           O  
ATOM   1184  CG2 THR A 121       3.114   1.246  11.513  1.00 26.51           C  
ATOM   1185  N   GLY A 122       5.972   4.056   9.355  1.00 27.91           N  
ATOM   1186  CA  GLY A 122       6.616   4.446   8.133  1.00 27.93           C  
ATOM   1187  C   GLY A 122       7.382   3.269   7.564  1.00 27.24           C  
ATOM   1188  O   GLY A 122       7.148   2.118   7.961  1.00 25.35           O  
ATOM   1189  N   ALA A 123       8.300   3.579   6.643  1.00 26.70           N  
ATOM   1190  CA  ALA A 123       8.981   2.578   5.817  1.00 26.74           C  
ATOM   1191  C   ALA A 123      10.475   2.843   5.778  1.00 27.97           C  
ATOM   1192  O   ALA A 123      10.937   3.840   5.207  1.00 29.70           O  
ATOM   1193  CB  ALA A 123       8.413   2.565   4.400  1.00 23.94           C  
ATOM   1194  N   HIS A 124      11.226   1.946   6.410  1.00 28.07           N  
ATOM   1195  CA  HIS A 124      12.679   1.930   6.307  1.00 27.75           C  
ATOM   1196  C   HIS A 124      13.059   1.407   4.929  1.00 27.36           C  
ATOM   1197  O   HIS A 124      12.484   0.440   4.460  1.00 27.54           O  
ATOM   1198  CB  HIS A 124      13.277   1.050   7.391  1.00 27.67           C  
ATOM   1199  CG  HIS A 124      14.766   1.168   7.521  1.00 26.63           C  
ATOM   1200  ND1 HIS A 124      15.641   0.608   6.617  1.00 24.48           N  
ATOM   1201  CD2 HIS A 124      15.529   1.782   8.459  1.00 26.51           C  
ATOM   1202  CE1 HIS A 124      16.880   0.877   6.990  1.00 30.56           C  
ATOM   1203  NE2 HIS A 124      16.839   1.580   8.110  1.00 27.69           N  
ATOM   1204  N   PRO A 125      14.027   2.066   4.259  1.00 29.28           N  
ATOM   1205  CA  PRO A 125      14.336   1.677   2.867  1.00 27.92           C  
ATOM   1206  C   PRO A 125      14.855   0.228   2.694  1.00 27.42           C  
ATOM   1207  O   PRO A 125      14.796  -0.298   1.607  1.00 31.88           O  
ATOM   1208  CB  PRO A 125      15.379   2.713   2.437  1.00 28.52           C  
ATOM   1209  CG  PRO A 125      16.006   3.202   3.762  1.00 26.63           C  
ATOM   1210  CD  PRO A 125      14.871   3.183   4.736  1.00 26.06           C  
ATOM   1211  N   ALA A 126      15.310  -0.415   3.760  1.00 28.55           N  
ATOM   1212  CA  ALA A 126      15.731  -1.815   3.719  1.00 27.91           C  
ATOM   1213  C   ALA A 126      14.908  -2.722   4.667  1.00 27.80           C  
ATOM   1214  O   ALA A 126      14.546  -3.838   4.311  1.00 28.40           O  
ATOM   1215  CB  ALA A 126      17.225  -1.893   4.063  1.00 26.75           C  
ATOM   1216  N   PHE A 127      14.597  -2.241   5.863  1.00 27.14           N  
ATOM   1217  CA  PHE A 127      13.937  -3.072   6.864  1.00 26.99           C  
ATOM   1218  C   PHE A 127      12.422  -3.180   6.706  1.00 27.47           C  
ATOM   1219  O   PHE A 127      11.816  -4.025   7.341  1.00 31.35           O  
ATOM   1220  CB  PHE A 127      14.186  -2.547   8.279  1.00 28.40           C  
ATOM   1221  CG  PHE A 127      15.630  -2.255   8.603  1.00 29.55           C  
ATOM   1222  CD1 PHE A 127      16.670  -2.796   7.850  1.00 24.00           C  
ATOM   1223  CD2 PHE A 127      15.936  -1.459   9.712  1.00 25.64           C  
ATOM   1224  CE1 PHE A 127      17.981  -2.522   8.160  1.00 27.72           C  
ATOM   1225  CE2 PHE A 127      17.231  -1.199  10.030  1.00 27.30           C  
ATOM   1226  CZ  PHE A 127      18.271  -1.731   9.244  1.00 26.09           C  
ATOM   1227  N   GLY A 128      11.792  -2.321   5.922  1.00 27.91           N  
ATOM   1228  CA  GLY A 128      10.330  -2.378   5.772  1.00 27.96           C  
ATOM   1229  C   GLY A 128       9.613  -1.562   6.838  1.00 27.46           C  
ATOM   1230  O   GLY A 128      10.161  -0.588   7.324  1.00 27.86           O  
ATOM   1231  N   VAL A 129       8.382  -1.945   7.180  1.00 27.31           N  
ATOM   1232  CA  VAL A 129       7.547  -1.165   8.115  1.00 29.32           C  
ATOM   1233  C   VAL A 129       8.216  -1.001   9.488  1.00 29.58           C  
ATOM   1234  O   VAL A 129       8.711  -1.959  10.079  1.00 31.26           O  
ATOM   1235  CB  VAL A 129       6.111  -1.747   8.306  1.00 30.16           C  
ATOM   1236  CG1 VAL A 129       5.231  -0.764   9.100  1.00 26.45           C  
ATOM   1237  CG2 VAL A 129       5.457  -2.046   6.939  1.00 29.74           C  
ATOM   1238  N   VAL A 130       8.260   0.238   9.959  1.00 28.49           N  
ATOM   1239  CA  VAL A 130       8.757   0.554  11.274  1.00 27.24           C  
ATOM   1240  C   VAL A 130       7.730   1.458  11.951  1.00 28.42           C  
ATOM   1241  O   VAL A 130       7.033   2.248  11.283  1.00 25.80           O  
ATOM   1242  CB  VAL A 130      10.160   1.244  11.217  1.00 27.88           C  
ATOM   1243  CG1 VAL A 130      11.227   0.273  10.655  1.00 24.99           C  
ATOM   1244  CG2 VAL A 130      10.121   2.531  10.396  1.00 22.79           C  
ATOM   1245  N   LYS A 131       7.654   1.329  13.278  1.00 28.51           N  
ATOM   1246  CA  LYS A 131       6.830   2.167  14.120  1.00 27.95           C  
ATOM   1247  C   LYS A 131       7.629   3.295  14.744  1.00 29.07           C  
ATOM   1248  O   LYS A 131       8.853   3.201  14.898  1.00 27.76           O  
ATOM   1249  CB  LYS A 131       6.221   1.341  15.244  1.00 30.37           C  
ATOM   1250  CG  LYS A 131       5.094   0.465  14.772  1.00 33.35           C  
ATOM   1251  CD  LYS A 131       4.796  -0.628  15.749  1.00 40.39           C  
ATOM   1252  CE  LYS A 131       4.090  -1.803  15.028  1.00 52.62           C  
ATOM   1253  NZ  LYS A 131       4.908  -2.381  13.863  1.00 53.88           N  
ATOM   1254  N   VAL A 132       6.913   4.355  15.115  1.00 27.89           N  
ATOM   1255  CA  VAL A 132       7.496   5.491  15.801  1.00 26.47           C  
ATOM   1256  C   VAL A 132       8.204   5.041  17.080  1.00 27.51           C  
ATOM   1257  O   VAL A 132       9.351   5.459  17.323  1.00 27.77           O  
ATOM   1258  CB  VAL A 132       6.434   6.627  16.036  1.00 27.91           C  
ATOM   1259  CG1 VAL A 132       6.913   7.659  17.050  1.00 21.90           C  
ATOM   1260  CG2 VAL A 132       6.071   7.300  14.688  1.00 20.11           C  
ATOM   1261  N   ARG A 133       7.556   4.171  17.862  0.50 25.38           N  
ATOM   1263  CA  ARG A 133       8.151   3.653  19.112  0.50 24.95           C  
ATOM   1265  C   ARG A 133       9.472   2.916  18.866  0.50 25.29           C  
ATOM   1267  O   ARG A 133      10.371   2.946  19.709  0.50 24.37           O  
ATOM   1269  CB  ARG A 133       7.171   2.767  19.926  0.50 24.24           C  
ATOM   1271  CG  ARG A 133       6.480   1.589  19.195  0.50 22.98           C  
ATOM   1273  CD  ARG A 133       5.672   0.717  20.182  0.50 22.65           C  
ATOM   1275  NE  ARG A 133       4.814  -0.301  19.559  0.50 24.78           N  
ATOM   1277  CZ  ARG A 133       5.221  -1.383  18.881  0.50 23.96           C  
ATOM   1279  NH1 ARG A 133       6.507  -1.660  18.683  0.50 26.61           N  
ATOM   1281  NH2 ARG A 133       4.314  -2.208  18.382  0.50 22.87           N  
ATOM   1283  N   GLU A 134       9.589   2.277  17.706  1.00 26.15           N  
ATOM   1284  CA  GLU A 134      10.812   1.587  17.324  1.00 26.18           C  
ATOM   1285  C   GLU A 134      11.944   2.566  16.970  1.00 26.85           C  
ATOM   1286  O   GLU A 134      13.089   2.323  17.363  1.00 31.58           O  
ATOM   1287  CB  GLU A 134      10.547   0.591  16.202  1.00 23.99           C  
ATOM   1288  CG  GLU A 134       9.711  -0.572  16.620  1.00 28.50           C  
ATOM   1289  CD  GLU A 134       9.336  -1.523  15.484  1.00 29.56           C  
ATOM   1290  OE1 GLU A 134       9.078  -1.044  14.372  1.00 28.20           O  
ATOM   1291  OE2 GLU A 134       9.280  -2.754  15.722  1.00 33.88           O  
ATOM   1292  N   LEU A 135      11.639   3.671  16.283  1.00 27.35           N  
ATOM   1293  CA  LEU A 135      12.630   4.764  16.063  1.00 27.49           C  
ATOM   1294  C   LEU A 135      13.063   5.414  17.366  1.00 27.39           C  
ATOM   1295  O   LEU A 135      14.249   5.686  17.556  1.00 28.48           O  
ATOM   1296  CB  LEU A 135      12.078   5.884  15.155  1.00 26.94           C  
ATOM   1297  CG  LEU A 135      13.054   7.004  14.670  1.00 27.68           C  
ATOM   1298  CD1 LEU A 135      14.127   6.474  13.792  1.00 24.37           C  
ATOM   1299  CD2 LEU A 135      12.354   8.115  13.925  1.00 27.16           C  
ATOM   1300  N   LEU A 136      12.096   5.681  18.249  1.00 26.17           N  
ATOM   1301  CA  LEU A 136      12.394   6.336  19.527  1.00 25.55           C  
ATOM   1302  C   LEU A 136      13.194   5.409  20.408  1.00 25.10           C  
ATOM   1303  O   LEU A 136      14.110   5.858  21.078  1.00 24.13           O  
ATOM   1304  CB  LEU A 136      11.132   6.851  20.236  1.00 24.05           C  
ATOM   1305  CG  LEU A 136      10.316   7.879  19.422  1.00 26.18           C  
ATOM   1306  CD1 LEU A 136       9.080   8.421  20.220  1.00 21.12           C  
ATOM   1307  CD2 LEU A 136      11.209   9.014  18.940  1.00 20.03           C  
ATOM   1308  N   SER A 137      12.873   4.117  20.368  1.00 24.02           N  
ATOM   1309  CA  SER A 137      13.605   3.128  21.145  1.00 23.81           C  
ATOM   1310  C   SER A 137      15.038   2.989  20.604  1.00 25.18           C  
ATOM   1311  O   SER A 137      15.987   2.931  21.377  1.00 25.97           O  
ATOM   1312  CB  SER A 137      12.889   1.769  21.118  1.00 24.76           C  
ATOM   1313  OG  SER A 137      11.618   1.831  21.738  1.00 23.17           O  
ATOM   1314  N   ALA A 138      15.182   2.953  19.280  1.00 22.11           N  
ATOM   1315  CA  ALA A 138      16.488   2.883  18.666  1.00 23.44           C  
ATOM   1316  C   ALA A 138      17.377   4.100  19.052  1.00 24.50           C  
ATOM   1317  O   ALA A 138      18.584   3.971  19.255  1.00 27.84           O  
ATOM   1318  CB  ALA A 138      16.336   2.725  17.110  1.00 19.56           C  
ATOM   1319  N   TRP A 139      16.751   5.266  19.164  1.00 25.54           N  
ATOM   1320  CA  TRP A 139      17.385   6.522  19.576  1.00 24.70           C  
ATOM   1321  C   TRP A 139      18.004   6.395  20.967  1.00 26.06           C  
ATOM   1322  O   TRP A 139      19.159   6.760  21.163  1.00 25.45           O  
ATOM   1323  CB  TRP A 139      16.312   7.647  19.591  1.00 25.36           C  
ATOM   1324  CG  TRP A 139      16.824   9.063  19.724  1.00 24.72           C  
ATOM   1325  CD1 TRP A 139      18.109   9.454  19.918  1.00 27.56           C  
ATOM   1326  CD2 TRP A 139      16.050  10.259  19.704  1.00 26.30           C  
ATOM   1327  NE1 TRP A 139      18.190  10.798  19.986  1.00 27.38           N  
ATOM   1328  CE2 TRP A 139      16.942  11.328  19.868  1.00 26.67           C  
ATOM   1329  CE3 TRP A 139      14.689  10.533  19.581  1.00 28.50           C  
ATOM   1330  CZ2 TRP A 139      16.529  12.647  19.914  1.00 26.73           C  
ATOM   1331  CZ3 TRP A 139      14.277  11.849  19.607  1.00 27.48           C  
ATOM   1332  CH2 TRP A 139      15.192  12.886  19.762  1.00 26.48           C  
ATOM   1333  N   VAL A 140      17.215   5.890  21.924  1.00 25.93           N  
ATOM   1334  CA  VAL A 140      17.684   5.687  23.297  1.00 24.73           C  
ATOM   1335  C   VAL A 140      18.865   4.739  23.368  1.00 25.46           C  
ATOM   1336  O   VAL A 140      19.867   5.035  23.999  1.00 26.32           O  
ATOM   1337  CB  VAL A 140      16.542   5.181  24.210  1.00 25.34           C  
ATOM   1338  CG1 VAL A 140      17.088   4.718  25.570  1.00 22.00           C  
ATOM   1339  CG2 VAL A 140      15.496   6.289  24.398  1.00 21.73           C  
ATOM   1340  N   VAL A 141      18.741   3.615  22.678  1.00 26.68           N  
ATOM   1341  CA  VAL A 141      19.762   2.619  22.586  1.00 26.32           C  
ATOM   1342  C   VAL A 141      20.986   3.119  21.880  1.00 26.44           C  
ATOM   1343  O   VAL A 141      22.090   2.727  22.230  1.00 28.33           O  
ATOM   1344  CB  VAL A 141      19.237   1.331  21.837  1.00 28.39           C  
ATOM   1345  CG1 VAL A 141      20.357   0.286  21.704  1.00 23.70           C  
ATOM   1346  CG2 VAL A 141      18.039   0.726  22.570  1.00 26.42           C  
ATOM   1347  N   HIS A 142      20.809   3.926  20.839  1.00 27.90           N  
ATOM   1348  CA  HIS A 142      21.948   4.583  20.186  1.00 27.69           C  
ATOM   1349  C   HIS A 142      22.821   5.333  21.200  1.00 27.64           C  
ATOM   1350  O   HIS A 142      24.037   5.182  21.235  1.00 27.28           O  
ATOM   1351  CB  HIS A 142      21.463   5.581  19.114  1.00 27.62           C  
ATOM   1352  CG  HIS A 142      22.538   6.002  18.165  1.00 27.05           C  
ATOM   1353  ND1 HIS A 142      22.974   7.305  18.058  1.00 22.98           N  
ATOM   1354  CD2 HIS A 142      23.271   5.278  17.282  1.00 25.52           C  
ATOM   1355  CE1 HIS A 142      23.951   7.356  17.168  1.00 24.32           C  
ATOM   1356  NE2 HIS A 142      24.151   6.141  16.682  1.00 22.76           N  
ATOM   1357  N   ASP A 143      22.178   6.193  21.995  1.00 28.36           N  
ATOM   1358  CA  ASP A 143      22.861   6.928  23.052  1.00 27.28           C  
ATOM   1359  C   ASP A 143      23.649   5.966  23.914  1.00 26.73           C  
ATOM   1360  O   ASP A 143      24.824   6.124  24.122  1.00 29.16           O  
ATOM   1361  CB  ASP A 143      21.826   7.676  23.923  1.00 27.18           C  
ATOM   1362  CG  ASP A 143      21.539   9.057  23.416  1.00 30.20           C  
ATOM   1363  OD1 ASP A 143      21.821   9.343  22.212  1.00 30.82           O  
ATOM   1364  OD2 ASP A 143      20.998   9.851  24.226  1.00 30.03           O  
ATOM   1365  N   LEU A 144      22.974   4.955  24.428  1.00 28.92           N  
ATOM   1366  CA  LEU A 144      23.580   4.054  25.390  1.00 27.72           C  
ATOM   1367  C   LEU A 144      24.741   3.256  24.764  1.00 27.04           C  
ATOM   1368  O   LEU A 144      25.789   3.032  25.393  1.00 29.08           O  
ATOM   1369  CB  LEU A 144      22.492   3.138  25.969  1.00 26.88           C  
ATOM   1370  CG  LEU A 144      21.418   3.756  26.895  1.00 29.12           C  
ATOM   1371  CD1 LEU A 144      20.245   2.782  27.132  1.00 24.82           C  
ATOM   1372  CD2 LEU A 144      22.017   4.163  28.237  1.00 26.71           C  
ATOM   1373  N   THR A 145      24.550   2.821  23.532  1.00 27.14           N  
ATOM   1374  CA  THR A 145      25.549   2.033  22.791  1.00 26.08           C  
ATOM   1375  C   THR A 145      26.833   2.847  22.577  1.00 27.43           C  
ATOM   1376  O   THR A 145      27.948   2.339  22.713  1.00 27.56           O  
ATOM   1377  CB  THR A 145      24.969   1.646  21.440  1.00 25.25           C  
ATOM   1378  OG1 THR A 145      23.756   0.886  21.646  1.00 27.06           O  
ATOM   1379  CG2 THR A 145      25.972   0.875  20.593  1.00 25.48           C  
ATOM   1380  N   HIS A 146      26.663   4.118  22.258  1.00 27.31           N  
ATOM   1381  CA  HIS A 146      27.803   5.002  22.100  1.00 28.06           C  
ATOM   1382  C   HIS A 146      28.479   5.434  23.416  1.00 26.13           C  
ATOM   1383  O   HIS A 146      29.689   5.551  23.442  1.00 25.60           O  
ATOM   1384  CB  HIS A 146      27.435   6.184  21.211  1.00 28.68           C  
ATOM   1385  CG  HIS A 146      27.409   5.829  19.753  1.00 26.90           C  
ATOM   1386  ND1 HIS A 146      28.514   5.348  19.085  1.00 29.15           N  
ATOM   1387  CD2 HIS A 146      26.420   5.899  18.834  1.00 26.81           C  
ATOM   1388  CE1 HIS A 146      28.196   5.114  17.823  1.00 27.14           C  
ATOM   1389  NE2 HIS A 146      26.938   5.455  17.642  1.00 25.28           N  
ATOM   1390  N   ILE A 147      27.713   5.628  24.485  1.00 26.32           N  
ATOM   1391  CA  ILE A 147      28.265   5.758  25.845  1.00 26.66           C  
ATOM   1392  C   ILE A 147      29.188   4.577  26.158  1.00 27.70           C  
ATOM   1393  O   ILE A 147      30.321   4.773  26.631  1.00 29.08           O  
ATOM   1394  CB  ILE A 147      27.145   5.888  26.953  1.00 26.70           C  
ATOM   1395  CG1 ILE A 147      26.428   7.233  26.861  1.00 26.68           C  
ATOM   1396  CG2 ILE A 147      27.719   5.739  28.411  1.00 24.13           C  
ATOM   1397  CD1 ILE A 147      25.079   7.265  27.537  1.00 25.89           C  
ATOM   1398  N   ALA A 148      28.711   3.363  25.873  1.00 27.95           N  
ATOM   1399  CA  ALA A 148      29.459   2.129  26.154  1.00 26.84           C  
ATOM   1400  C   ALA A 148      30.718   2.059  25.320  1.00 26.72           C  
ATOM   1401  O   ALA A 148      31.740   1.552  25.775  1.00 23.76           O  
ATOM   1402  CB  ALA A 148      28.572   0.881  25.902  1.00 25.88           C  
ATOM   1403  N   GLN A 149      30.633   2.544  24.074  1.00 25.04           N  
ATOM   1404  CA  GLN A 149      31.800   2.596  23.225  1.00 24.97           C  
ATOM   1405  C   GLN A 149      32.858   3.535  23.817  1.00 26.49           C  
ATOM   1406  O   GLN A 149      34.047   3.234  23.795  1.00 29.10           O  
ATOM   1407  CB  GLN A 149      31.400   3.014  21.793  1.00 26.33           C  
ATOM   1408  CG  GLN A 149      32.527   3.019  20.789  1.00 25.91           C  
ATOM   1409  CD  GLN A 149      32.131   3.571  19.399  1.00 26.59           C  
ATOM   1410  OE1 GLN A 149      31.031   4.107  19.207  1.00 24.30           O  
ATOM   1411  NE2 GLN A 149      33.039   3.424  18.436  1.00 18.60           N  
ATOM   1412  N   ILE A 150      32.431   4.685  24.326  1.00 26.75           N  
ATOM   1413  CA  ILE A 150      33.337   5.661  24.941  1.00 26.25           C  
ATOM   1414  C   ILE A 150      34.020   5.017  26.155  1.00 25.78           C  
ATOM   1415  O   ILE A 150      35.228   5.013  26.242  1.00 26.04           O  
ATOM   1416  CB  ILE A 150      32.576   7.003  25.338  1.00 26.33           C  
ATOM   1417  CG1 ILE A 150      32.310   7.847  24.074  1.00 26.99           C  
ATOM   1418  CG2 ILE A 150      33.357   7.779  26.315  1.00 19.31           C  
ATOM   1419  CD1 ILE A 150      31.379   9.005  24.253  1.00 24.60           C  
ATOM   1420  N   VAL A 151      33.228   4.430  27.052  1.00 27.96           N  
ATOM   1421  CA  VAL A 151      33.736   3.748  28.260  1.00 26.36           C  
ATOM   1422  C   VAL A 151      34.720   2.611  27.941  1.00 27.30           C  
ATOM   1423  O   VAL A 151      35.767   2.509  28.582  1.00 28.75           O  
ATOM   1424  CB  VAL A 151      32.545   3.239  29.104  1.00 27.74           C  
ATOM   1425  CG1 VAL A 151      33.004   2.430  30.303  1.00 25.16           C  
ATOM   1426  CG2 VAL A 151      31.667   4.443  29.550  1.00 28.84           C  
ATOM   1427  N   ARG A 152      34.398   1.775  26.955  1.00 23.83           N  
ATOM   1428  CA  ARG A 152      35.276   0.677  26.543  1.00 26.29           C  
ATOM   1429  C   ARG A 152      36.610   1.146  25.957  1.00 26.44           C  
ATOM   1430  O   ARG A 152      37.657   0.509  26.178  1.00 26.88           O  
ATOM   1431  CB  ARG A 152      34.585  -0.238  25.517  1.00 26.72           C  
ATOM   1432  CG  ARG A 152      33.618  -1.308  26.121  1.00 28.51           C  
ATOM   1433  CD  ARG A 152      33.446  -2.464  25.124  1.00 28.84           C  
ATOM   1434  NE  ARG A 152      33.195  -1.937  23.764  1.00 28.58           N  
ATOM   1435  CZ  ARG A 152      32.032  -1.424  23.365  1.00 28.56           C  
ATOM   1436  NH1 ARG A 152      30.956  -1.410  24.166  1.00 29.81           N  
ATOM   1437  NH2 ARG A 152      31.936  -0.943  22.135  1.00 30.95           N  
ATOM   1438  N   SER A 153      36.563   2.231  25.189  1.00 24.14           N  
ATOM   1439  CA  SER A 153      37.759   2.817  24.609  1.00 24.85           C  
ATOM   1440  C   SER A 153      38.726   3.317  25.700  1.00 27.09           C  
ATOM   1441  O   SER A 153      39.952   3.114  25.648  1.00 27.56           O  
ATOM   1442  CB  SER A 153      37.361   3.985  23.722  1.00 26.58           C  
ATOM   1443  OG  SER A 153      36.487   3.582  22.666  1.00 26.58           O  
HETATM 1444  N   MSE A 154      38.158   3.974  26.705  1.00 27.86           N  
HETATM 1445  CA  MSE A 154      38.934   4.424  27.850  1.00 26.41           C  
HETATM 1446  C   MSE A 154      39.518   3.247  28.646  1.00 25.34           C  
HETATM 1447  O   MSE A 154      40.701   3.244  28.933  1.00 25.45           O  
HETATM 1448  CB  MSE A 154      38.089   5.348  28.716  1.00 25.80           C  
HETATM 1449  CG  MSE A 154      37.731   6.639  27.992  1.00 30.84           C  
HETATM 1450 SE   MSE A 154      36.396   7.697  28.874  0.75 24.58          SE  
HETATM 1451  CE  MSE A 154      37.277   8.169  30.448  1.00 21.03           C  
ATOM   1452  N   ALA A 155      38.706   2.237  28.953  1.00 25.00           N  
ATOM   1453  CA  ALA A 155      39.193   1.030  29.637  1.00 24.63           C  
ATOM   1454  C   ALA A 155      40.379   0.369  28.921  1.00 26.46           C  
ATOM   1455  O   ALA A 155      41.333  -0.106  29.561  1.00 26.58           O  
ATOM   1456  CB  ALA A 155      38.038   0.015  29.843  1.00 21.45           C  
ATOM   1457  N   LYS A 156      40.303   0.342  27.595  1.00 28.44           N  
ATOM   1458  CA  LYS A 156      41.250  -0.375  26.749  1.00 28.56           C  
ATOM   1459  C   LYS A 156      42.661   0.199  26.887  1.00 27.95           C  
ATOM   1460  O   LYS A 156      43.664  -0.498  26.871  1.00 27.40           O  
ATOM   1461  CB  LYS A 156      40.768  -0.336  25.283  1.00 29.57           C  
ATOM   1462  CG  LYS A 156      41.714  -1.014  24.324  1.00 30.48           C  
ATOM   1463  CD  LYS A 156      41.050  -1.708  23.157  1.00 35.35           C  
ATOM   1464  CE  LYS A 156      41.821  -3.012  22.767  1.00 39.16           C  
ATOM   1465  NZ  LYS A 156      43.256  -2.724  22.526  1.00 38.31           N  
ATOM   1466  N   ARG A 157      42.729   1.485  27.109  1.00 27.75           N  
ATOM   1467  CA  ARG A 157      44.003   2.132  27.387  1.00 26.19           C  
ATOM   1468  C   ARG A 157      44.904   1.422  28.432  1.00 25.66           C  
ATOM   1469  O   ARG A 157      46.142   1.541  28.368  1.00 24.66           O  
ATOM   1470  CB  ARG A 157      43.650   3.508  27.862  1.00 27.20           C  
ATOM   1471  CG  ARG A 157      44.751   4.421  28.044  1.00 37.07           C  
ATOM   1472  CD  ARG A 157      44.370   5.824  27.596  1.00 39.98           C  
ATOM   1473  NE  ARG A 157      45.620   6.554  27.560  1.00 43.57           N  
ATOM   1474  CZ  ARG A 157      45.979   7.507  28.390  1.00 41.10           C  
ATOM   1475  NH1 ARG A 157      45.132   7.957  29.311  1.00 51.92           N  
ATOM   1476  NH2 ARG A 157      47.183   8.039  28.250  1.00 43.40           N  
ATOM   1477  N   TYR A 158      44.289   0.716  29.399  1.00 24.49           N  
ATOM   1478  CA  TYR A 158      45.012   0.095  30.506  1.00 23.09           C  
ATOM   1479  C   TYR A 158      45.059  -1.419  30.400  1.00 23.72           C  
ATOM   1480  O   TYR A 158      45.374  -2.077  31.384  1.00 25.13           O  
ATOM   1481  CB  TYR A 158      44.433   0.528  31.889  1.00 24.67           C  
ATOM   1482  CG  TYR A 158      44.710   1.970  32.377  1.00 19.70           C  
ATOM   1483  CD1 TYR A 158      45.343   2.906  31.573  1.00 24.37           C  
ATOM   1484  CD2 TYR A 158      44.274   2.390  33.630  1.00 22.85           C  
ATOM   1485  CE1 TYR A 158      45.580   4.208  32.010  1.00 26.10           C  
ATOM   1486  CE2 TYR A 158      44.466   3.699  34.072  1.00 23.87           C  
ATOM   1487  CZ  TYR A 158      45.129   4.615  33.261  1.00 24.19           C  
ATOM   1488  OH  TYR A 158      45.355   5.933  33.676  1.00 20.13           O  
ATOM   1489  N   ASP A 159      44.825  -1.965  29.202  1.00 25.02           N  
ATOM   1490  CA  ASP A 159      44.893  -3.418  28.963  1.00 26.32           C  
ATOM   1491  C   ASP A 159      46.160  -4.046  29.515  1.00 24.26           C  
ATOM   1492  O   ASP A 159      46.092  -5.062  30.208  1.00 26.72           O  
ATOM   1493  CB  ASP A 159      44.807  -3.787  27.459  1.00 27.44           C  
ATOM   1494  CG  ASP A 159      43.379  -3.770  26.899  1.00 30.90           C  
ATOM   1495  OD1 ASP A 159      42.415  -3.476  27.637  1.00 30.66           O  
ATOM   1496  OD2 ASP A 159      43.241  -4.065  25.690  1.00 37.43           O  
ATOM   1497  N   THR A 160      47.307  -3.458  29.198  1.00 24.85           N  
ATOM   1498  CA  THR A 160      48.601  -3.978  29.681  1.00 23.36           C  
ATOM   1499  C   THR A 160      48.822  -3.554  31.128  1.00 24.31           C  
ATOM   1500  O   THR A 160      49.291  -4.341  31.955  1.00 26.43           O  
ATOM   1501  CB  THR A 160      49.768  -3.481  28.799  1.00 25.46           C  
ATOM   1502  OG1 THR A 160      49.528  -3.872  27.437  1.00 29.25           O  
ATOM   1503  CG2 THR A 160      51.148  -4.043  29.278  1.00 21.05           C  
ATOM   1504  N   ASP A 161      48.454  -2.315  31.442  1.00 24.25           N  
ATOM   1505  CA  ASP A 161      48.601  -1.758  32.797  1.00 24.54           C  
ATOM   1506  C   ASP A 161      47.967  -2.576  33.942  1.00 23.36           C  
ATOM   1507  O   ASP A 161      48.538  -2.639  35.016  1.00 26.58           O  
ATOM   1508  CB  ASP A 161      48.027  -0.336  32.857  1.00 24.89           C  
ATOM   1509  CG  ASP A 161      48.706   0.604  31.906  1.00 21.05           C  
ATOM   1510  OD1 ASP A 161      49.724   1.204  32.296  1.00 23.94           O  
ATOM   1511  OD2 ASP A 161      48.204   0.766  30.768  1.00 25.93           O  
ATOM   1512  N   VAL A 162      46.810  -3.189  33.714  1.00 22.04           N  
ATOM   1513  CA  VAL A 162      46.118  -3.928  34.753  1.00 22.64           C  
ATOM   1514  C   VAL A 162      46.842  -5.235  35.098  1.00 23.43           C  
ATOM   1515  O   VAL A 162      46.542  -5.868  36.115  1.00 25.19           O  
ATOM   1516  CB  VAL A 162      44.636  -4.210  34.402  1.00 24.06           C  
ATOM   1517  CG1 VAL A 162      43.881  -2.908  34.147  1.00 20.97           C  
ATOM   1518  CG2 VAL A 162      44.499  -5.201  33.177  1.00 25.48           C  
ATOM   1519  N   GLY A 163      47.796  -5.634  34.262  1.00 24.24           N  
ATOM   1520  CA  GLY A 163      48.598  -6.836  34.509  1.00 23.21           C  
ATOM   1521  C   GLY A 163      47.733  -8.073  34.746  1.00 23.28           C  
ATOM   1522  O   GLY A 163      46.899  -8.377  33.915  1.00 25.90           O  
ATOM   1523  N   PRO A 164      47.929  -8.803  35.868  1.00 22.03           N  
ATOM   1524  CA  PRO A 164      47.210 -10.070  36.066  1.00 22.58           C  
ATOM   1525  C   PRO A 164      45.680  -9.961  36.309  1.00 24.39           C  
ATOM   1526  O   PRO A 164      44.955 -10.993  36.268  1.00 22.46           O  
ATOM   1527  CB  PRO A 164      47.924 -10.697  37.261  1.00 24.57           C  
ATOM   1528  CG  PRO A 164      48.553  -9.568  38.025  1.00 23.78           C  
ATOM   1529  CD  PRO A 164      48.859  -8.510  36.977  1.00 23.87           C  
ATOM   1530  N   TRP A 165      45.199  -8.730  36.495  1.00 25.56           N  
ATOM   1531  CA  TRP A 165      43.770  -8.474  36.646  1.00 26.21           C  
ATOM   1532  C   TRP A 165      42.976  -8.539  35.332  1.00 27.02           C  
ATOM   1533  O   TRP A 165      41.728  -8.586  35.349  1.00 27.82           O  
ATOM   1534  CB  TRP A 165      43.508  -7.138  37.361  1.00 25.33           C  
ATOM   1535  CG  TRP A 165      43.494  -7.227  38.881  1.00 25.58           C  
ATOM   1536  CD1 TRP A 165      42.485  -7.723  39.660  1.00 22.11           C  
ATOM   1537  CD2 TRP A 165      44.540  -6.823  39.784  1.00 23.40           C  
ATOM   1538  NE1 TRP A 165      42.839  -7.661  40.989  1.00 25.11           N  
ATOM   1539  CE2 TRP A 165      44.089  -7.108  41.099  1.00 23.35           C  
ATOM   1540  CE3 TRP A 165      45.811  -6.255  39.612  1.00 24.66           C  
ATOM   1541  CZ2 TRP A 165      44.854  -6.827  42.235  1.00 19.29           C  
ATOM   1542  CZ3 TRP A 165      46.575  -5.956  40.760  1.00 22.32           C  
ATOM   1543  CH2 TRP A 165      46.093  -6.251  42.044  1.00 21.41           C  
ATOM   1544  N   LYS A 166      43.680  -8.546  34.202  1.00 27.89           N  
ATOM   1545  CA  LYS A 166      43.028  -8.491  32.896  1.00 26.27           C  
ATOM   1546  C   LYS A 166      41.907  -9.537  32.733  1.00 27.38           C  
ATOM   1547  O   LYS A 166      40.772  -9.221  32.348  1.00 27.03           O  
ATOM   1548  CB  LYS A 166      44.090  -8.703  31.807  1.00 27.66           C  
ATOM   1549  CG  LYS A 166      43.556  -8.707  30.331  1.00 27.39           C  
ATOM   1550  CD  LYS A 166      43.181  -7.285  29.873  1.00 35.29           C  
ATOM   1551  CE  LYS A 166      42.846  -7.216  28.396  1.00 34.22           C  
ATOM   1552  NZ  LYS A 166      41.530  -7.862  28.123  1.00 36.82           N  
ATOM   1553  N   GLU A 167      42.221 -10.804  32.981  1.00 29.04           N  
ATOM   1554  CA  GLU A 167      41.203 -11.850  32.794  1.00 28.85           C  
ATOM   1555  C   GLU A 167      39.985 -11.629  33.693  1.00 26.28           C  
ATOM   1556  O   GLU A 167      38.845 -11.637  33.219  1.00 26.71           O  
ATOM   1557  CB  GLU A 167      41.774 -13.272  32.995  1.00 27.75           C  
ATOM   1558  CG  GLU A 167      40.839 -14.319  32.400  1.00 33.97           C  
ATOM   1559  CD  GLU A 167      41.124 -15.757  32.808  1.00 35.25           C  
ATOM   1560  OE1 GLU A 167      42.178 -16.052  33.466  1.00 37.84           O  
ATOM   1561  OE2 GLU A 167      40.253 -16.597  32.420  1.00 47.77           O  
ATOM   1562  N   TYR A 168      40.199 -11.437  34.992  1.00 26.85           N  
ATOM   1563  CA  TYR A 168      39.048 -11.299  35.892  1.00 26.26           C  
ATOM   1564  C   TYR A 168      38.175 -10.049  35.600  1.00 28.09           C  
ATOM   1565  O   TYR A 168      36.983 -10.059  35.860  1.00 28.55           O  
ATOM   1566  CB  TYR A 168      39.497 -11.351  37.349  1.00 27.67           C  
ATOM   1567  CG  TYR A 168      38.326 -11.381  38.292  1.00 26.48           C  
ATOM   1568  CD1 TYR A 168      37.440 -12.465  38.269  1.00 21.15           C  
ATOM   1569  CD2 TYR A 168      38.065 -10.312  39.163  1.00 23.05           C  
ATOM   1570  CE1 TYR A 168      36.328 -12.502  39.091  1.00 25.81           C  
ATOM   1571  CE2 TYR A 168      36.962 -10.338  40.000  1.00 26.31           C  
ATOM   1572  CZ  TYR A 168      36.099 -11.449  39.966  1.00 29.88           C  
ATOM   1573  OH  TYR A 168      34.986 -11.516  40.770  1.00 30.19           O  
ATOM   1574  N   LEU A 169      38.756  -8.997  35.015  1.00 28.16           N  
ATOM   1575  CA  LEU A 169      38.019  -7.759  34.712  1.00 26.77           C  
ATOM   1576  C   LEU A 169      37.068  -7.956  33.548  1.00 28.84           C  
ATOM   1577  O   LEU A 169      36.183  -7.133  33.296  1.00 28.97           O  
ATOM   1578  CB  LEU A 169      38.993  -6.599  34.430  1.00 25.44           C  
ATOM   1579  CG  LEU A 169      39.618  -5.962  35.684  1.00 25.03           C  
ATOM   1580  CD1 LEU A 169      40.806  -5.077  35.292  1.00 21.11           C  
ATOM   1581  CD2 LEU A 169      38.578  -5.188  36.497  1.00 21.59           C  
ATOM   1582  N   GLY A 170      37.257  -9.056  32.825  1.00 30.80           N  
ATOM   1583  CA  GLY A 170      36.252  -9.527  31.868  1.00 30.52           C  
ATOM   1584  C   GLY A 170      35.130 -10.382  32.453  1.00 29.62           C  
ATOM   1585  O   GLY A 170      34.264 -10.765  31.730  1.00 31.53           O  
ATOM   1586  N   ILE A 171      35.150 -10.680  33.749  1.00 30.83           N  
ATOM   1587  CA  ILE A 171      34.162 -11.573  34.400  1.00 29.53           C  
ATOM   1588  C   ILE A 171      33.221 -10.774  35.281  1.00 28.97           C  
ATOM   1589  O   ILE A 171      33.638 -10.222  36.295  1.00 30.78           O  
ATOM   1590  CB  ILE A 171      34.871 -12.628  35.306  1.00 28.00           C  
ATOM   1591  CG1 ILE A 171      35.774 -13.524  34.474  1.00 29.48           C  
ATOM   1592  CG2 ILE A 171      33.868 -13.464  36.076  1.00 25.94           C  
ATOM   1593  CD1 ILE A 171      35.074 -14.286  33.381  1.00 23.40           C  
ATOM   1594  N   LEU A 172      31.944 -10.737  34.931  1.00 29.83           N  
ATOM   1595  CA  LEU A 172      30.965  -9.945  35.668  1.00 28.11           C  
ATOM   1596  C   LEU A 172      30.061 -10.793  36.560  1.00 30.11           C  
ATOM   1597  O   LEU A 172      30.081 -12.023  36.523  1.00 28.79           O  
ATOM   1598  CB  LEU A 172      30.118  -9.143  34.700  1.00 31.37           C  
ATOM   1599  CG  LEU A 172      30.849  -8.234  33.710  1.00 29.48           C  
ATOM   1600  CD1 LEU A 172      29.808  -7.762  32.695  1.00 29.37           C  
ATOM   1601  CD2 LEU A 172      31.472  -7.074  34.436  1.00 26.37           C  
ATOM   1602  N   ASN A 173      29.294 -10.105  37.399  1.00 31.32           N  
ATOM   1603  CA  ASN A 173      28.266 -10.736  38.235  1.00 31.64           C  
ATOM   1604  C   ASN A 173      28.850 -11.775  39.166  1.00 32.11           C  
ATOM   1605  O   ASN A 173      28.312 -12.870  39.293  1.00 33.05           O  
ATOM   1606  CB  ASN A 173      27.156 -11.348  37.367  1.00 31.03           C  
ATOM   1607  CG  ASN A 173      26.569 -10.347  36.424  1.00 29.86           C  
ATOM   1608  OD1 ASN A 173      26.036  -9.337  36.862  1.00 32.25           O  
ATOM   1609  ND2 ASN A 173      26.712 -10.588  35.115  1.00 28.39           N  
ATOM   1610  N   ASP A 174      29.968 -11.413  39.799  1.00 34.75           N  
ATOM   1611  CA  ASP A 174      30.751 -12.314  40.670  1.00 33.21           C  
ATOM   1612  C   ASP A 174      31.428 -11.556  41.801  1.00 34.35           C  
ATOM   1613  O   ASP A 174      31.611 -12.096  42.903  1.00 36.29           O  
ATOM   1614  CB  ASP A 174      31.822 -13.079  39.878  1.00 31.44           C  
ATOM   1615  CG  ASP A 174      32.538 -14.090  40.746  1.00 33.55           C  
ATOM   1616  OD1 ASP A 174      31.896 -15.108  41.092  1.00 33.55           O  
ATOM   1617  OD2 ASP A 174      33.713 -13.857  41.120  1.00 30.30           O  
ATOM   1618  OXT ASP A 174      31.799 -10.395  41.634  1.00 34.34           O  
TER    1619      ASP A 174                                                      
END
MOLECULE T0406.pdb
ATOM      1  N   MET     1       7.297  -1.140  21.855  1.00 67.48           N  
ATOM      2  CA  MET     1       6.466   0.089  21.680  1.00 67.38           C  
ATOM      3  C   MET     1       6.624   1.036  22.879  1.00 67.17           C  
ATOM      4  O   MET     1       7.261   0.680  23.880  1.00 67.51           O  
ATOM      5  CB  MET     1       4.991  -0.288  21.493  1.00 67.14           C  
ATOM      6  N   TYR     2       6.087   2.252  22.731  1.00 66.54           N  
ATOM      7  CA  TYR     2       5.887   3.206  23.831  1.00 65.82           C  
ATOM      8  C   TYR     2       4.455   3.692  23.727  1.00 64.83           C  
ATOM      9  O   TYR     2       4.090   4.306  22.724  1.00 65.23           O  
ATOM     10  CB  TYR     2       6.815   4.425  23.724  1.00 66.09           C  
ATOM     11  CG  TYR     2       8.272   4.144  23.994  1.00 66.72           C  
ATOM     12  CD1 TYR     2       9.114   3.721  22.966  1.00 67.06           C  
ATOM     13  CD2 TYR     2       8.819   4.310  25.272  1.00 66.81           C  
ATOM     14  CE1 TYR     2      10.460   3.462  23.197  1.00 67.20           C  
ATOM     15  CE2 TYR     2      10.181   4.049  25.515  1.00 66.68           C  
ATOM     16  CZ  TYR     2      10.987   3.627  24.464  1.00 66.65           C  
ATOM     17  OH  TYR     2      12.319   3.352  24.649  1.00 67.31           O  
ATOM     18  N   GLN     3       3.643   3.428  24.747  1.00 63.41           N  
ATOM     19  CA  GLN     3       2.236   3.824  24.719  1.00 62.14           C  
ATOM     20  C   GLN     3       2.079   5.346  24.698  1.00 60.68           C  
ATOM     21  O   GLN     3       1.188   5.860  24.035  1.00 60.60           O  
ATOM     22  CB  GLN     3       1.478   3.230  25.914  1.00 62.10           C  
ATOM     23  N   THR     4       2.957   6.064  25.395  1.00 59.24           N  
ATOM     24  CA  THR     4       2.775   7.504  25.588  1.00 57.91           C  
ATOM     25  C   THR     4       4.038   8.348  25.382  1.00 56.62           C  
ATOM     26  O   THR     4       5.159   7.870  25.551  1.00 56.20           O  
ATOM     27  CB  THR     4       2.215   7.788  27.012  1.00 58.17           C  
ATOM     28  OG1 THR     4       2.177   9.207  27.252  1.00 59.26           O  
ATOM     29  CG2 THR     4       3.069   7.108  28.092  1.00 57.72           C  
ATOM     30  N   ILE     5       3.824   9.617  25.047  1.00 55.05           N  
ATOM     31  CA  ILE     5       4.896  10.604  24.947  1.00 54.14           C  
ATOM     32  C   ILE     5       5.613  10.811  26.281  1.00 53.68           C  
ATOM     33  O   ILE     5       6.835  10.814  26.328  1.00 53.74           O  
ATOM     34  CB  ILE     5       4.373  11.978  24.469  1.00 53.85           C  
ATOM     35  CG1 ILE     5       3.799  11.886  23.058  1.00 53.39           C  
ATOM     36  CG2 ILE     5       5.488  13.034  24.513  1.00 54.49           C  
ATOM     37  CD1 ILE     5       4.763  11.369  22.022  1.00 53.23           C  
ATOM     38  N   GLU     6       4.863  10.994  27.366  1.00 52.98           N  
ATOM     39  CA  GLU     6       5.484  11.191  28.676  1.00 52.29           C  
ATOM     40  C   GLU     6       6.222   9.939  29.121  1.00 50.67           C  
ATOM     41  O   GLU     6       7.255  10.034  29.758  1.00 51.06           O  
ATOM     42  CB  GLU     6       4.453  11.603  29.741  1.00 52.96           C  
ATOM     43  CG  GLU     6       3.816  12.982  29.509  1.00 55.77           C  
ATOM     44  CD  GLU     6       4.832  14.097  29.249  1.00 59.09           C  
ATOM     45  OE1 GLU     6       5.838  14.193  30.007  1.00 61.36           O  
ATOM     46  OE2 GLU     6       4.607  14.883  28.288  1.00 60.81           O  
ATOM     47  N   GLY     7       5.707   8.772  28.767  1.00 48.43           N  
ATOM     48  CA  GLY     7       6.382   7.523  29.073  1.00 47.15           C  
ATOM     49  C   GLY     7       7.752   7.447  28.424  1.00 46.15           C  
ATOM     50  O   GLY     7       8.710   6.970  29.040  1.00 45.59           O  
ATOM     51  N   PHE     8       7.846   7.915  27.178  1.00 44.90           N  
ATOM     52  CA  PHE     8       9.119   7.948  26.461  1.00 43.84           C  
ATOM     53  C   PHE     8      10.069   8.942  27.100  1.00 43.34           C  
ATOM     54  O   PHE     8      11.256   8.666  27.213  1.00 43.35           O  
ATOM     55  CB  PHE     8       8.948   8.285  24.972  1.00 43.21           C  
ATOM     56  CG  PHE     8      10.256   8.601  24.277  1.00 43.07           C  
ATOM     57  CD1 PHE     8      11.165   7.598  23.993  1.00 42.55           C  
ATOM     58  CD2 PHE     8      10.587   9.903  23.942  1.00 41.66           C  
ATOM     59  CE1 PHE     8      12.376   7.888  23.385  1.00 42.21           C  
ATOM     60  CE2 PHE     8      11.798  10.194  23.342  1.00 41.83           C  
ATOM     61  CZ  PHE     8      12.690   9.176  23.063  1.00 41.14           C  
ATOM     62  N   LEU     9       9.551  10.098  27.512  1.00 43.00           N  
ATOM     63  CA  LEU     9      10.393  11.163  28.053  1.00 42.69           C  
ATOM     64  C   LEU     9      10.978  10.813  29.428  1.00 42.59           C  
ATOM     65  O   LEU     9      12.059  11.278  29.773  1.00 42.28           O  
ATOM     66  CB  LEU     9       9.636  12.499  28.078  1.00 42.45           C  
ATOM     67  CG  LEU     9       9.320  13.024  26.671  1.00 41.60           C  
ATOM     68  CD1 LEU     9       8.392  14.227  26.690  1.00 40.52           C  
ATOM     69  CD2 LEU     9      10.596  13.343  25.926  1.00 42.49           C  
ATOM     70  N   GLN    10      10.282   9.969  30.191  1.00 42.38           N  
ATOM     71  CA  GLN    10      10.823   9.446  31.457  1.00 41.96           C  
ATOM     72  C   GLN    10      12.030   8.536  31.190  1.00 41.70           C  
ATOM     73  O   GLN    10      13.037   8.608  31.896  1.00 41.65           O  
ATOM     74  CB  GLN    10       9.747   8.703  32.267  1.00 41.95           C  
ATOM     75  N   SER    11      11.925   7.681  30.174  1.00 41.31           N  
ATOM     76  CA  SER    11      13.063   6.887  29.716  1.00 41.21           C  
ATOM     77  C   SER    11      14.146   7.795  29.103  1.00 40.77           C  
ATOM     78  O   SER    11      15.311   7.716  29.479  1.00 40.67           O  
ATOM     79  CB  SER    11      12.602   5.835  28.696  1.00 41.13           C  
ATOM     80  N   TRP    12      13.750   8.667  28.183  1.00 40.55           N  
ATOM     81  CA  TRP    12      14.686   9.549  27.479  1.00 40.77           C  
ATOM     82  C   TRP    12      15.453  10.500  28.402  1.00 41.18           C  
ATOM     83  O   TRP    12      16.632  10.774  28.176  1.00 41.09           O  
ATOM     84  CB  TRP    12      13.942  10.362  26.406  1.00 40.37           C  
ATOM     85  CG  TRP    12      14.840  11.191  25.536  1.00 39.72           C  
ATOM     86  CD1 TRP    12      14.843  12.546  25.427  1.00 38.90           C  
ATOM     87  CD2 TRP    12      15.869  10.710  24.662  1.00 37.40           C  
ATOM     88  NE1 TRP    12      15.822  12.941  24.537  1.00 39.94           N  
ATOM     89  CE2 TRP    12      16.457  11.832  24.052  1.00 36.37           C  
ATOM     90  CE3 TRP    12      16.354   9.434  24.345  1.00 38.39           C  
ATOM     91  CZ2 TRP    12      17.512  11.727  23.155  1.00 39.00           C  
ATOM     92  CZ3 TRP    12      17.408   9.325  23.448  1.00 39.08           C  
ATOM     93  CH2 TRP    12      17.968  10.471  22.855  1.00 39.11           C  
ATOM     94  N   THR    13      14.788  11.006  29.437  1.00 41.85           N  
ATOM     95  CA  THR    13      15.415  11.922  30.398  1.00 41.85           C  
ATOM     96  C   THR    13      16.573  11.248  31.140  1.00 42.11           C  
ATOM     97  O   THR    13      17.616  11.854  31.303  1.00 41.71           O  
ATOM     98  CB  THR    13      14.371  12.488  31.404  1.00 42.21           C  
ATOM     99  OG1 THR    13      13.365  13.207  30.682  1.00 42.84           O  
ATOM    100  CG2 THR    13      15.012  13.441  32.434  1.00 41.66           C  
ATOM    101  N   TYR    14      16.398   9.995  31.567  1.00 42.84           N  
ATOM    102  CA  TYR    14      17.488   9.241  32.209  1.00 43.23           C  
ATOM    103  C   TYR    14      18.650   9.016  31.226  1.00 42.43           C  
ATOM    104  O   TYR    14      19.816   9.103  31.603  1.00 42.22           O  
ATOM    105  CB  TYR    14      16.999   7.884  32.757  1.00 44.38           C  
ATOM    106  CG  TYR    14      18.107   7.055  33.401  1.00 45.95           C  
ATOM    107  CD1 TYR    14      18.950   6.246  32.622  1.00 47.52           C  
ATOM    108  CD2 TYR    14      18.330   7.091  34.785  1.00 47.51           C  
ATOM    109  CE1 TYR    14      19.987   5.494  33.202  1.00 47.80           C  
ATOM    110  CE2 TYR    14      19.367   6.339  35.375  1.00 47.55           C  
ATOM    111  CZ  TYR    14      20.189   5.546  34.574  1.00 47.61           C  
ATOM    112  OH  TYR    14      21.210   4.803  35.136  1.00 47.57           O  
ATOM    113  N   GLU    15      18.328   8.702  29.976  1.00 41.66           N  
ATOM    114  CA  GLU    15      19.349   8.445  28.956  1.00 41.25           C  
ATOM    115  C   GLU    15      20.147   9.701  28.626  1.00 40.71           C  
ATOM    116  O   GLU    15      21.375   9.657  28.545  1.00 41.46           O  
ATOM    117  CB  GLU    15      18.713   7.888  27.685  1.00 41.21           C  
ATOM    118  CG  GLU    15      18.068   6.507  27.849  1.00 40.06           C  
ATOM    119  CD  GLU    15      19.015   5.466  28.398  1.00 40.80           C  
ATOM    120  OE1 GLU    15      20.183   5.434  27.981  1.00 43.05           O  
ATOM    121  OE2 GLU    15      18.606   4.655  29.244  1.00 40.70           O  
ATOM    122  N   THR    16      19.460  10.818  28.437  1.00 40.48           N  
ATOM    123  CA  THR    16      20.137  12.067  28.086  1.00 40.67           C  
ATOM    124  C   THR    16      20.956  12.631  29.241  1.00 40.57           C  
ATOM    125  O   THR    16      22.086  13.087  29.021  1.00 40.78           O  
ATOM    126  CB  THR    16      19.166  13.156  27.586  1.00 40.47           C  
ATOM    127  OG1 THR    16      18.230  13.485  28.611  1.00 43.09           O  
ATOM    128  CG2 THR    16      18.414  12.697  26.352  1.00 40.12           C  
ATOM    129  N   GLU    17      20.400  12.609  30.460  1.00 39.86           N  
ATOM    130  CA  GLU    17      21.137  13.073  31.639  1.00 39.51           C  
ATOM    131  C   GLU    17      22.447  12.300  31.772  1.00 39.87           C  
ATOM    132  O   GLU    17      23.517  12.891  31.948  1.00 39.64           O  
ATOM    133  CB  GLU    17      20.291  12.941  32.938  1.00 39.19           C  
ATOM    134  CG  GLU    17      19.182  14.019  33.096  1.00 40.37           C  
ATOM    135  CD  GLU    17      18.399  13.942  34.433  1.00 38.16           C  
ATOM    136  N   SER    18      22.346  10.977  31.677  1.00 40.25           N  
ATOM    137  CA  SER    18      23.503  10.084  31.744  1.00 40.99           C  
ATOM    138  C   SER    18      24.538  10.358  30.638  1.00 40.55           C  
ATOM    139  O   SER    18      25.725  10.377  30.893  1.00 41.38           O  
ATOM    140  CB  SER    18      23.028   8.621  31.691  1.00 41.43           C  
ATOM    141  OG  SER    18      24.085   7.743  31.306  1.00 44.83           O  
ATOM    142  N   THR    19      24.083  10.581  29.413  1.00 40.09           N  
ATOM    143  CA  THR    19      24.981  10.822  28.294  1.00 39.40           C  
ATOM    144  C   THR    19      25.668  12.169  28.440  1.00 40.16           C  
ATOM    145  O   THR    19      26.867  12.277  28.222  1.00 39.94           O  
ATOM    146  CB  THR    19      24.226  10.716  26.941  1.00 39.05           C  
ATOM    147  OG1 THR    19      23.608   9.429  26.875  1.00 38.12           O  
ATOM    148  CG2 THR    19      25.167  10.872  25.755  1.00 38.05           C  
ATOM    149  N   GLN    20      24.900  13.179  28.839  1.00 40.47           N  
ATOM    150  CA  GLN    20      25.405  14.537  28.995  1.00 40.77           C  
ATOM    151  C   GLN    20      26.471  14.626  30.083  1.00 41.36           C  
ATOM    152  O   GLN    20      27.433  15.382  29.931  1.00 41.53           O  
ATOM    153  CB  GLN    20      24.249  15.489  29.312  1.00 40.66           C  
ATOM    154  CG  GLN    20      24.633  16.965  29.386  1.00 40.31           C  
ATOM    155  CD  GLN    20      24.916  17.559  28.025  1.00 40.59           C  
ATOM    156  OE1 GLN    20      24.019  17.678  27.197  1.00 39.78           O  
ATOM    157  NE2 GLN    20      26.159  17.973  27.799  1.00 40.39           N  
ATOM    158  N   LYS    21      26.294  13.871  31.170  1.00 41.97           N  
ATOM    159  CA  LYS    21      27.275  13.825  32.266  1.00 42.84           C  
ATOM    160  C   LYS    21      28.624  13.299  31.779  1.00 42.30           C  
ATOM    161  O   LYS    21      29.674  13.815  32.154  1.00 41.33           O  
ATOM    162  CB  LYS    21      26.799  12.926  33.412  1.00 42.87           C  
ATOM    163  CG  LYS    21      25.691  13.497  34.281  1.00 44.80           C  
ATOM    164  CD  LYS    21      25.392  12.603  35.518  1.00 45.52           C  
ATOM    165  CE  LYS    21      25.198  11.125  35.110  1.00 47.96           C  
ATOM    166  NZ  LYS    21      24.594  10.313  36.197  1.00 50.07           N  
ATOM    167  N   MET    22      28.582  12.250  30.957  1.00 41.83           N  
ATOM    168  CA  MET    22      29.792  11.702  30.386  1.00 42.13           C  
ATOM    169  C   MET    22      30.464  12.678  29.418  1.00 41.34           C  
ATOM    170  O   MET    22      31.661  12.951  29.532  1.00 41.70           O  
ATOM    171  CB  MET    22      29.499  10.357  29.752  1.00 41.41           C  
ATOM    172  CG  MET    22      29.212   9.331  30.816  1.00 41.76           C  
ATOM    173  SD  MET    22      29.053   7.714  29.928  0.75 46.00          SE  
ATOM    174  CE  MET    22      28.062   6.697  31.258  1.00 42.97           C  
ATOM    175  N   LEU    23      29.683  13.257  28.525  1.00 41.06           N  
ATOM    176  CA  LEU    23      30.180  14.268  27.589  1.00 40.50           C  
ATOM    177  C   LEU    23      30.793  15.430  28.306  1.00 40.38           C  
ATOM    178  O   LEU    23      31.763  15.992  27.827  1.00 40.99           O  
ATOM    179  CB  LEU    23      29.057  14.765  26.647  1.00 40.12           C  
ATOM    180  CG  LEU    23      28.669  13.786  25.523  1.00 38.27           C  
ATOM    181  CD1 LEU    23      27.561  14.345  24.656  1.00 35.14           C  
ATOM    182  CD2 LEU    23      29.861  13.455  24.660  1.00 36.73           C  
ATOM    183  N   ASP    24      30.232  15.791  29.461  1.00 40.31           N  
ATOM    184  CA  ASP    24      30.712  16.941  30.237  1.00 40.03           C  
ATOM    185  C   ASP    24      32.090  16.701  30.870  1.00 39.37           C  
ATOM    186  O   ASP    24      32.787  17.655  31.197  1.00 38.85           O  
ATOM    187  CB  ASP    24      29.687  17.346  31.325  1.00 40.24           C  
ATOM    188  CG  ASP    24      28.461  18.090  30.757  1.00 40.77           C  
ATOM    189  OD1 ASP    24      28.486  18.507  29.579  1.00 42.10           O  
ATOM    190  OD2 ASP    24      27.463  18.268  31.498  1.00 43.46           O  
ATOM    191  N   VAL    25      32.480  15.438  31.027  1.00 38.26           N  
ATOM    192  CA  VAL    25      33.777  15.086  31.632  1.00 38.17           C  
ATOM    193  C   VAL    25      34.928  15.046  30.614  1.00 37.59           C  
ATOM    194  O   VAL    25      36.101  15.050  30.988  1.00 36.68           O  
ATOM    195  CB  VAL    25      33.684  13.702  32.309  1.00 38.15           C  
ATOM    196  CG1 VAL    25      35.032  13.258  32.835  1.00 38.34           C  
ATOM    197  CG2 VAL    25      32.656  13.739  33.431  1.00 39.21           C  
ATOM    198  N   LEU    26      34.587  14.997  29.328  1.00 37.24           N  
ATOM    199  CA  LEU    26      35.586  14.778  28.276  1.00 37.75           C  
ATOM    200  C   LEU    26      36.463  16.017  28.180  1.00 37.41           C  
ATOM    201  O   LEU    26      36.004  17.143  28.403  1.00 37.48           O  
ATOM    202  CB  LEU    26      34.914  14.437  26.920  1.00 37.39           C  
ATOM    203  CG  LEU    26      34.684  12.958  26.533  1.00 38.57           C  
ATOM    204  CD1 LEU    26      34.222  12.049  27.652  1.00 41.47           C  
ATOM    205  CD2 LEU    26      33.704  12.858  25.355  1.00 38.55           C  
ATOM    206  N   THR    27      37.741  15.788  27.904  1.00 37.39           N  
ATOM    207  CA  THR    27      38.704  16.852  27.689  1.00 36.78           C  
ATOM    208  C   THR    27      39.095  16.792  26.227  1.00 36.71           C  
ATOM    209  O   THR    27      38.852  15.779  25.560  1.00 36.22           O  
ATOM    210  CB  THR    27      39.959  16.643  28.545  1.00 36.70           C  
ATOM    211  OG1 THR    27      40.584  15.407  28.170  1.00 35.79           O  
ATOM    212  CG2 THR    27      39.596  16.593  30.025  1.00 36.04           C  
ATOM    213  N   ASP    28      39.698  17.876  25.746  1.00 36.48           N  
ATOM    214  CA  ASP    28      40.181  17.965  24.373  1.00 36.48           C  
ATOM    215  C   ASP    28      41.176  16.861  24.059  1.00 36.24           C  
ATOM    216  O   ASP    28      41.126  16.267  22.986  1.00 35.36           O  
ATOM    217  CB  ASP    28      40.835  19.318  24.122  1.00 36.48           C  
ATOM    218  CG  ASP    28      39.838  20.462  24.108  1.00 36.42           C  
ATOM    219  OD1 ASP    28      38.623  20.221  24.269  1.00 37.35           O  
ATOM    220  OD2 ASP    28      40.270  21.616  23.927  1.00 37.41           O  
ATOM    221  N   GLU    29      42.050  16.575  25.013  1.00 36.42           N  
ATOM    222  CA  GLU    29      43.073  15.539  24.856  1.00 36.73           C  
ATOM    223  C   GLU    29      42.464  14.161  24.700  1.00 36.58           C  
ATOM    224  O   GLU    29      42.914  13.376  23.859  1.00 36.92           O  
ATOM    225  CB  GLU    29      44.019  15.533  26.067  1.00 36.94           C  
ATOM    226  CG  GLU    29      45.252  14.631  25.896  1.00 37.22           C  
ATOM    227  N   SER    30      41.444  13.873  25.515  1.00 36.43           N  
ATOM    228  CA  SER    30      40.774  12.551  25.541  1.00 36.31           C  
ATOM    229  C   SER    30      40.136  12.169  24.224  1.00 36.16           C  
ATOM    230  O   SER    30      40.007  10.982  23.911  1.00 37.55           O  
ATOM    231  CB  SER    30      39.707  12.495  26.643  1.00 36.25           C  
ATOM    232  OG  SER    30      38.616  13.360  26.369  1.00 36.58           O  
ATOM    233  N   LEU    31      39.752  13.170  23.451  1.00 35.91           N  
ATOM    234  CA  LEU    31      39.124  12.969  22.157  1.00 35.90           C  
ATOM    235  C   LEU    31      39.992  12.163  21.201  1.00 35.76           C  
ATOM    236  O   LEU    31      39.459  11.472  20.327  1.00 36.37           O  
ATOM    237  CB  LEU    31      38.772  14.326  21.516  1.00 35.53           C  
ATOM    238  CG  LEU    31      37.787  15.200  22.289  1.00 35.42           C  
ATOM    239  CD1 LEU    31      37.398  16.345  21.392  1.00 34.66           C  
ATOM    240  CD2 LEU    31      36.543  14.418  22.807  1.00 36.79           C  
ATOM    241  N   SER    32      41.316  12.224  21.368  1.00 35.50           N  
ATOM    242  CA  SER    32      42.212  11.485  20.484  1.00 35.38           C  
ATOM    243  C   SER    32      42.359  10.021  20.909  1.00 35.55           C  
ATOM    244  O   SER    32      42.958   9.244  20.192  1.00 35.03           O  
ATOM    245  CB  SER    32      43.575  12.170  20.369  1.00 35.21           C  
ATOM    246  OG  SER    32      44.276  12.175  21.595  1.00 36.76           O  
ATOM    247  N   GLN    33      41.741   9.642  22.008  1.00 35.94           N  
ATOM    248  CA  GLN    33      41.856   8.283  22.500  1.00 36.42           C  
ATOM    249  C   GLN    33      41.259   7.240  21.573  1.00 37.94           C  
ATOM    250  O   GLN    33      40.153   7.338  21.218  1.00 37.84           O  
ATOM    251  CB  GLN    33      41.266   8.168  23.896  1.00 36.12           C  
ATOM    252  CG  GLN    33      41.620   6.877  24.606  1.00 34.98           C  
ATOM    253  CD  GLN    33      43.026   6.863  25.196  1.00 34.24           C  
ATOM    254  OE1 GLN    33      43.564   7.870  25.593  1.00 31.29           O  
ATOM    255  NE2 GLN    33      43.602   5.718  25.234  1.00 29.63           N  
ATOM    256  N   GLU    34      41.998   6.210  21.231  1.00 40.01           N  
ATOM    257  CA  GLU    34      41.603   5.337  20.148  1.00 41.29           C  
ATOM    258  C   GLU    34      41.154   3.975  20.575  1.00 41.72           C  
ATOM    259  O   GLU    34      41.708   3.386  21.435  1.00 42.17           O  
ATOM    260  CB  GLU    34      42.736   5.204  19.131  1.00 41.31           C  
ATOM    261  N   ILE    35      40.178   3.436  19.902  1.00 42.30           N  
ATOM    262  CA  ILE    35      39.851   2.039  20.071  1.00 42.71           C  
ATOM    263  C   ILE    35      40.975   1.099  19.779  1.00 43.11           C  
ATOM    264  O   ILE    35      41.143   0.149  20.462  1.00 44.11           O  
ATOM    265  CB  ILE    35      38.723   1.629  19.221  1.00 42.57           C  
ATOM    266  CG1 ILE    35      37.485   2.371  19.608  1.00 43.35           C  
ATOM    267  CG2 ILE    35      38.571   0.141  19.222  1.00 42.92           C  
ATOM    268  CD1 ILE    35      36.345   2.021  18.840  1.00 46.42           C  
ATOM    269  N   ALA    36      41.701   1.355  18.711  1.00 42.78           N  
ATOM    270  CA  ALA    36      42.827   0.550  18.264  1.00 42.55           C  
ATOM    271  C   ALA    36      43.504   1.282  17.104  1.00 42.14           C  
ATOM    272  O   ALA    36      42.954   2.237  16.560  1.00 42.00           O  
ATOM    273  CB  ALA    36      42.359  -0.839  17.829  1.00 42.64           C  
ATOM    274  N   PRO    37      44.724   0.879  16.751  1.00 42.20           N  
ATOM    275  CA  PRO    37      45.335   1.512  15.588  1.00 41.84           C  
ATOM    276  C   PRO    37      44.471   1.331  14.347  1.00 41.06           C  
ATOM    277  O   PRO    37      44.054   0.212  14.037  1.00 41.34           O  
ATOM    278  CB  PRO    37      46.663   0.783  15.470  1.00 42.16           C  
ATOM    279  CG  PRO    37      46.938   0.351  16.879  1.00 42.26           C  
ATOM    280  CD  PRO    37      45.628  -0.105  17.364  1.00 41.99           C  
ATOM    281  N   GLY    38      44.156   2.436  13.681  1.00 40.27           N  
ATOM    282  CA  GLY    38      43.343   2.382  12.469  1.00 39.62           C  
ATOM    283  C   GLY    38      41.853   2.425  12.730  1.00 39.24           C  
ATOM    284  O   GLY    38      41.060   2.278  11.805  1.00 38.25           O  
ATOM    285  N   HIS    39      41.470   2.652  13.987  1.00 38.72           N  
ATOM    286  CA  HIS    39      40.072   2.666  14.380  1.00 38.82           C  
ATOM    287  C   HIS    39      39.623   4.045  14.866  1.00 38.20           C  
ATOM    288  O   HIS    39      40.415   4.973  15.001  1.00 38.13           O  
ATOM    289  CB  HIS    39      39.827   1.611  15.462  1.00 39.68           C  
ATOM    290  CG  HIS    39      39.769   0.215  14.936  1.00 40.52           C  
ATOM    291  ND1 HIS    39      40.868  -0.614  14.897  1.00 43.17           N  
ATOM    292  CD2 HIS    39      38.738  -0.495  14.420  1.00 42.67           C  
ATOM    293  CE1 HIS    39      40.521  -1.776  14.373  1.00 44.25           C  
ATOM    294  NE2 HIS    39      39.233  -1.730  14.074  1.00 44.78           N  
ATOM    295  N   TRP    40      38.334   4.163  15.134  1.00 38.25           N  
ATOM    296  CA  TRP    40      37.750   5.394  15.655  1.00 37.81           C  
ATOM    297  C   TRP    40      38.341   5.859  16.983  1.00 36.50           C  
ATOM    298  O   TRP    40      38.780   5.054  17.798  1.00 35.36           O  
ATOM    299  CB  TRP    40      36.252   5.207  15.873  1.00 39.04           C  
ATOM    300  CG  TRP    40      35.405   5.473  14.689  1.00 39.44           C  
ATOM    301  CD1 TRP    40      35.781   5.484  13.367  1.00 39.64           C  
ATOM    302  CD2 TRP    40      34.006   5.731  14.715  1.00 40.61           C  
ATOM    303  NE1 TRP    40      34.677   5.738  12.573  1.00 40.54           N  
ATOM    304  CE2 TRP    40      33.580   5.900  13.380  1.00 40.48           C  
ATOM    305  CE3 TRP    40      33.064   5.835  15.740  1.00 40.53           C  
ATOM    306  CZ2 TRP    40      32.248   6.176  13.053  1.00 41.21           C  
ATOM    307  CZ3 TRP    40      31.741   6.103  15.413  1.00 40.49           C  
ATOM    308  CH2 TRP    40      31.348   6.276  14.084  1.00 40.47           C  
ATOM    309  N   THR    41      38.336   7.182  17.158  1.00 35.70           N  
ATOM    310  CA  THR    41      38.672   7.816  18.409  1.00 35.60           C  
ATOM    311  C   THR    41      37.418   8.109  19.248  1.00 35.89           C  
ATOM    312  O   THR    41      36.267   8.033  18.774  1.00 35.61           O  
ATOM    313  CB  THR    41      39.425   9.146  18.198  1.00 35.61           C  
ATOM    314  OG1 THR    41      38.543  10.090  17.607  1.00 36.06           O  
ATOM    315  CG2 THR    41      40.640   8.968  17.296  1.00 35.36           C  
ATOM    316  N   LEU    42      37.667   8.442  20.506  1.00 36.16           N  
ATOM    317  CA  LEU    42      36.612   8.834  21.451  1.00 36.54           C  
ATOM    318  C   LEU    42      35.827  10.047  20.984  1.00 37.06           C  
ATOM    319  O   LEU    42      34.606  10.095  21.148  1.00 38.12           O  
ATOM    320  CB  LEU    42      37.238   9.078  22.829  1.00 35.87           C  
ATOM    321  CG  LEU    42      36.388   9.581  24.000  1.00 36.67           C  
ATOM    322  CD1 LEU    42      35.058   8.861  24.109  1.00 34.62           C  
ATOM    323  CD2 LEU    42      37.232   9.459  25.299  1.00 35.25           C  
ATOM    324  N   GLY    43      36.539  11.019  20.418  1.00 37.44           N  
ATOM    325  CA  GLY    43      35.949  12.194  19.804  1.00 37.53           C  
ATOM    326  C   GLY    43      34.952  11.844  18.715  1.00 38.35           C  
ATOM    327  O   GLY    43      33.885  12.465  18.640  1.00 38.03           O  
ATOM    328  N   ARG    44      35.263  10.832  17.897  1.00 38.28           N  
ATOM    329  CA  ARG    44      34.332  10.408  16.841  1.00 37.97           C  
ATOM    330  C   ARG    44      33.141   9.619  17.383  1.00 37.69           C  
ATOM    331  O   ARG    44      32.031   9.812  16.929  1.00 36.92           O  
ATOM    332  CB  ARG    44      35.015   9.586  15.748  1.00 38.16           C  
ATOM    333  CG  ARG    44      34.049   9.332  14.580  1.00 41.71           C  
ATOM    334  CD  ARG    44      34.689   9.418  13.191  1.00 45.92           C  
ATOM    335  NE  ARG    44      33.666   9.473  12.141  1.00 46.95           N  
ATOM    336  CZ  ARG    44      33.845   9.080  10.882  1.00 47.95           C  
ATOM    337  NH1 ARG    44      35.001   8.556  10.479  1.00 49.31           N  
ATOM    338  NH2 ARG    44      32.846   9.191  10.017  1.00 47.85           N  
ATOM    339  N   VAL    45      33.379   8.700  18.320  1.00 38.02           N  
ATOM    340  CA  VAL    45      32.286   8.059  19.038  1.00 38.22           C  
ATOM    341  C   VAL    45      31.309   9.088  19.607  1.00 39.42           C  
ATOM    342  O   VAL    45      30.098   8.946  19.408  1.00 41.06           O  
ATOM    343  CB  VAL    45      32.786   7.065  20.129  1.00 38.71           C  
ATOM    344  CG1 VAL    45      31.578   6.411  20.878  1.00 37.23           C  
ATOM    345  CG2 VAL    45      33.651   6.016  19.498  1.00 35.38           C  
ATOM    346  N   ALA    46      31.824  10.160  20.224  1.00 39.15           N  
ATOM    347  CA  ALA    46      30.990  11.162  20.902  1.00 38.95           C  
ATOM    348  C   ALA    46      30.202  12.044  19.919  1.00 38.71           C  
ATOM    349  O   ALA    46      29.030  12.365  20.134  1.00 37.60           O  
ATOM    350  CB  ALA    46      31.858  12.048  21.800  1.00 38.55           C  
ATOM    351  N   TRP    47      30.862  12.484  18.863  1.00 38.76           N  
ATOM    352  CA  TRP    47      30.171  13.244  17.833  1.00 38.83           C  
ATOM    353  C   TRP    47      29.138  12.385  17.064  1.00 38.47           C  
ATOM    354  O   TRP    47      28.131  12.884  16.634  1.00 38.14           O  
ATOM    355  CB  TRP    47      31.189  13.859  16.887  1.00 38.98           C  
ATOM    356  CG  TRP    47      30.676  14.933  16.005  1.00 38.62           C  
ATOM    357  CD1 TRP    47      30.772  14.970  14.660  1.00 38.41           C  
ATOM    358  CD2 TRP    47      30.038  16.160  16.403  1.00 38.34           C  
ATOM    359  NE1 TRP    47      30.228  16.143  14.177  1.00 39.87           N  
ATOM    360  CE2 TRP    47      29.762  16.883  15.229  1.00 37.93           C  
ATOM    361  CE3 TRP    47      29.671  16.712  17.638  1.00 39.22           C  
ATOM    362  CZ2 TRP    47      29.136  18.125  15.244  1.00 39.28           C  
ATOM    363  CZ3 TRP    47      29.052  17.932  17.659  1.00 38.88           C  
ATOM    364  CH2 TRP    47      28.785  18.638  16.466  1.00 39.61           C  
ATOM    365  N   HIS    48      29.393  11.087  16.917  1.00 37.89           N  
ATOM    366  CA  HIS    48      28.448  10.186  16.269  1.00 37.24           C  
ATOM    367  C   HIS    48      27.122  10.134  17.067  1.00 37.41           C  
ATOM    368  O   HIS    48      26.037  10.100  16.486  1.00 36.57           O  
ATOM    369  CB  HIS    48      29.104   8.795  16.145  1.00 37.50           C  
ATOM    370  CG  HIS    48      28.246   7.750  15.500  1.00 37.08           C  
ATOM    371  ND1 HIS    48      27.851   7.817  14.184  1.00 37.73           N  
ATOM    372  CD2 HIS    48      27.805   6.556  15.962  1.00 38.81           C  
ATOM    373  CE1 HIS    48      27.150   6.737  13.881  1.00 38.77           C  
ATOM    374  NE2 HIS    48      27.102   5.956  14.944  1.00 37.37           N  
ATOM    375  N   ILE    49      27.220  10.172  18.395  1.00 36.74           N  
ATOM    376  CA  ILE    49      26.046  10.202  19.304  1.00 36.60           C  
ATOM    377  C   ILE    49      25.247  11.479  19.139  1.00 36.58           C  
ATOM    378  O   ILE    49      24.000  11.486  19.074  1.00 37.69           O  
ATOM    379  CB  ILE    49      26.522  10.076  20.780  1.00 36.62           C  
ATOM    380  CG1 ILE    49      26.917   8.633  21.055  1.00 35.34           C  
ATOM    381  CG2 ILE    49      25.416  10.507  21.821  1.00 36.42           C  
ATOM    382  CD1 ILE    49      27.867   8.474  22.217  1.00 34.26           C  
ATOM    383  N   VAL    50      25.968  12.571  19.059  1.00 36.48           N  
ATOM    384  CA  VAL    50      25.336  13.842  18.869  1.00 35.50           C  
ATOM    385  C   VAL    50      24.554  13.869  17.553  1.00 35.98           C  
ATOM    386  O   VAL    50      23.355  14.204  17.533  1.00 34.52           O  
ATOM    387  CB  VAL    50      26.370  14.959  18.949  1.00 36.20           C  
ATOM    388  CG1 VAL    50      25.698  16.298  18.728  1.00 33.19           C  
ATOM    389  CG2 VAL    50      27.100  14.929  20.338  1.00 33.82           C  
ATOM    390  N   THR    51      25.223  13.474  16.466  1.00 37.01           N  
ATOM    391  CA  THR    51      24.664  13.566  15.129  1.00 37.55           C  
ATOM    392  C   THR    51      23.593  12.530  14.882  1.00 38.58           C  
ATOM    393  O   THR    51      22.703  12.759  14.043  1.00 38.83           O  
ATOM    394  CB  THR    51      25.741  13.435  14.009  1.00 38.09           C  
ATOM    395  OG1 THR    51      26.371  12.143  14.073  1.00 37.78           O  
ATOM    396  CG2 THR    51      26.774  14.468  14.152  1.00 35.80           C  
ATOM    397  N   ALA    52      23.663  11.406  15.611  1.00 39.48           N  
ATOM    398  CA  ALA    52      22.683  10.339  15.510  1.00 39.44           C  
ATOM    399  C   ALA    52      21.254  10.764  15.832  1.00 40.87           C  
ATOM    400  O   ALA    52      20.318  10.121  15.351  1.00 39.51           O  
ATOM    401  CB  ALA    52      23.100   9.112  16.376  1.00 40.12           C  
ATOM    402  N   ILE    53      21.062  11.888  16.559  1.00 41.91           N  
ATOM    403  CA  ILE    53      19.704  12.284  16.963  1.00 42.87           C  
ATOM    404  C   ILE    53      18.884  12.714  15.724  1.00 43.37           C  
ATOM    405  O   ILE    53      17.848  12.093  15.434  1.00 42.52           O  
ATOM    406  CB  ILE    53      19.686  13.334  18.129  1.00 43.00           C  
ATOM    407  CG1 ILE    53      20.106  12.664  19.441  1.00 44.60           C  
ATOM    408  CG2 ILE    53      18.311  13.920  18.328  1.00 43.32           C  
ATOM    409  CD1 ILE    53      20.584  13.644  20.534  1.00 42.31           C  
ATOM    410  N   PRO    54      19.330  13.763  14.994  1.00 43.64           N  
ATOM    411  CA  PRO    54      18.670  14.065  13.720  1.00 43.62           C  
ATOM    412  C   PRO    54      18.713  12.972  12.637  1.00 44.27           C  
ATOM    413  O   PRO    54      17.808  12.945  11.816  1.00 44.52           O  
ATOM    414  CB  PRO    54      19.353  15.357  13.247  1.00 44.47           C  
ATOM    415  CG  PRO    54      20.619  15.465  14.045  1.00 43.73           C  
ATOM    416  CD  PRO    54      20.382  14.742  15.328  1.00 43.31           C  
ATOM    417  N   VAL    55      19.687  12.054  12.647  1.00 43.45           N  
ATOM    418  CA  VAL    55      19.785  11.057  11.578  1.00 43.07           C  
ATOM    419  C   VAL    55      18.745   9.948  11.775  1.00 42.92           C  
ATOM    420  O   VAL    55      18.032   9.547  10.840  1.00 42.72           O  
ATOM    421  CB  VAL    55      21.217  10.481  11.471  1.00 43.39           C  
ATOM    422  CG1 VAL    55      21.263   9.270  10.506  1.00 43.13           C  
ATOM    423  CG2 VAL    55      22.195  11.597  11.039  1.00 41.78           C  
ATOM    424  N   ILE    56      18.646   9.455  13.000  1.00 42.45           N  
ATOM    425  CA  ILE    56      17.669   8.426  13.298  1.00 42.54           C  
ATOM    426  C   ILE    56      16.236   9.016  13.196  1.00 42.86           C  
ATOM    427  O   ILE    56      15.333   8.365  12.701  1.00 43.17           O  
ATOM    428  CB  ILE    56      17.972   7.749  14.665  1.00 42.17           C  
ATOM    429  CG1 ILE    56      19.186   6.815  14.532  1.00 41.57           C  
ATOM    430  CG2 ILE    56      16.740   7.055  15.210  1.00 40.86           C  
ATOM    431  CD1 ILE    56      19.632   6.168  15.866  1.00 40.57           C  
ATOM    432  N   LEU    57      16.016  10.263  13.599  1.00 42.81           N  
ATOM    433  CA  LEU    57      14.644  10.757  13.596  1.00 42.59           C  
ATOM    434  C   LEU    57      14.171  11.323  12.230  1.00 43.44           C  
ATOM    435  O   LEU    57      12.980  11.681  12.073  1.00 42.65           O  
ATOM    436  CB  LEU    57      14.435  11.746  14.755  1.00 43.42           C  
ATOM    437  CG  LEU    57      14.682  11.079  16.128  1.00 42.68           C  
ATOM    438  CD1 LEU    57      14.283  11.922  17.199  1.00 42.04           C  
ATOM    439  CD2 LEU    57      13.925   9.749  16.268  1.00 45.34           C  
ATOM    440  N   SER    58      15.066  11.369  11.237  1.00 43.29           N  
ATOM    441  CA  SER    58      14.771  12.116  10.003  1.00 43.78           C  
ATOM    442  C   SER    58      13.557  11.583   9.256  1.00 43.27           C  
ATOM    443  O   SER    58      12.747  12.355   8.762  1.00 43.22           O  
ATOM    444  CB  SER    58      15.989  12.175   9.065  1.00 44.30           C  
ATOM    445  OG  SER    58      16.311  10.897   8.546  1.00 44.43           O  
ATOM    446  N   GLY    59      13.431  10.262   9.205  1.00 42.77           N  
ATOM    447  CA  GLY    59      12.336   9.607   8.495  1.00 43.05           C  
ATOM    448  C   GLY    59      10.983   9.740   9.166  1.00 42.87           C  
ATOM    449  O   GLY    59       9.965   9.439   8.558  1.00 42.27           O  
ATOM    450  N   THR    60      10.963  10.171  10.425  1.00 43.30           N  
ATOM    451  CA  THR    60       9.695  10.439  11.129  1.00 43.91           C  
ATOM    452  C   THR    60       9.060  11.764  10.654  1.00 44.53           C  
ATOM    453  O   THR    60       7.873  12.014  10.863  1.00 44.89           O  
ATOM    454  CB  THR    60       9.878  10.557  12.660  1.00 43.17           C  
ATOM    455  OG1 THR    60      10.446  11.834  12.957  1.00 41.99           O  
ATOM    456  CG2 THR    60      10.755   9.449  13.213  1.00 44.70           C  
ATOM    457  N   GLY    61       9.863  12.633  10.064  1.00 45.44           N  
ATOM    458  CA  GLY    61       9.346  13.908   9.591  1.00 45.80           C  
ATOM    459  C   GLY    61       9.321  14.978  10.671  1.00 46.83           C  
ATOM    460  O   GLY    61       9.039  16.143  10.380  1.00 46.08           O  
ATOM    461  N   LEU    62       9.626  14.594  11.912  1.00 47.33           N  
ATOM    462  CA  LEU    62       9.760  15.550  13.015  1.00 48.30           C  
ATOM    463  C   LEU    62      11.003  16.407  12.778  1.00 48.48           C  
ATOM    464  O   LEU    62      12.118  15.913  12.828  1.00 49.91           O  
ATOM    465  CB  LEU    62       9.879  14.777  14.327  1.00 48.16           C  
ATOM    466  CG  LEU    62       9.823  15.488  15.671  1.00 48.99           C  
ATOM    467  CD1 LEU    62       8.480  16.168  15.895  1.00 47.52           C  
ATOM    468  CD2 LEU    62      10.100  14.436  16.754  1.00 48.02           C  
ATOM    469  N   LYS    63      10.818  17.693  12.517  1.00 48.89           N  
ATOM    470  CA  LYS    63      11.905  18.530  12.028  1.00 48.59           C  
ATOM    471  C   LYS    63      12.464  19.441  13.137  1.00 48.24           C  
ATOM    472  O   LYS    63      11.704  20.076  13.879  1.00 48.07           O  
ATOM    473  CB  LYS    63      11.418  19.342  10.814  1.00 49.26           C  
ATOM    474  CG  LYS    63      10.922  18.449   9.641  1.00 48.40           C  
ATOM    475  N   PHE    64      13.792  19.478  13.259  1.00 47.14           N  
ATOM    476  CA  PHE    64      14.447  20.338  14.243  1.00 46.77           C  
ATOM    477  C   PHE    64      15.926  20.524  13.913  1.00 47.14           C  
ATOM    478  O   PHE    64      16.523  19.708  13.222  1.00 46.93           O  
ATOM    479  CB  PHE    64      14.293  19.750  15.646  1.00 45.79           C  
ATOM    480  CG  PHE    64      14.836  18.351  15.780  1.00 43.79           C  
ATOM    481  CD1 PHE    64      16.161  18.132  16.138  1.00 40.87           C  
ATOM    482  CD2 PHE    64      14.030  17.265  15.520  1.00 42.88           C  
ATOM    483  CE1 PHE    64      16.660  16.848  16.251  1.00 42.93           C  
ATOM    484  CE2 PHE    64      14.518  15.994  15.641  1.00 41.21           C  
ATOM    485  CZ  PHE    64      15.847  15.787  16.000  1.00 42.35           C  
ATOM    486  N   GLU    65      16.508  21.596  14.427  1.00 47.28           N  
ATOM    487  CA  GLU    65      17.889  21.962  14.106  1.00 47.91           C  
ATOM    488  C   GLU    65      18.893  20.968  14.727  1.00 47.50           C  
ATOM    489  O   GLU    65      18.722  20.540  15.871  1.00 47.17           O  
ATOM    490  CB  GLU    65      18.162  23.386  14.584  1.00 47.85           C  
ATOM    491  CG  GLU    65      19.431  24.043  14.032  1.00 49.87           C  
ATOM    492  N   GLY    66      19.917  20.599  13.953  1.00 46.99           N  
ATOM    493  CA  GLY    66      20.978  19.708  14.426  1.00 46.66           C  
ATOM    494  C   GLY    66      21.882  19.204  13.317  1.00 46.16           C  
ATOM    495  O   GLY    66      21.399  18.713  12.295  1.00 46.83           O  
ATOM    496  N   GLU    67      23.193  19.306  13.526  1.00 45.14           N  
ATOM    497  CA  GLU    67      24.190  18.735  12.609  1.00 44.58           C  
ATOM    498  C   GLU    67      23.947  17.241  12.433  1.00 43.64           C  
ATOM    499  O   GLU    67      23.686  16.576  13.408  1.00 43.39           O  
ATOM    500  CB  GLU    67      25.602  18.935  13.171  1.00 44.62           C  
ATOM    501  CG  GLU    67      26.722  18.414  12.286  1.00 45.82           C  
ATOM    502  CD  GLU    67      26.649  18.981  10.883  1.00 48.02           C  
ATOM    503  OE1 GLU    67      26.896  20.205  10.749  1.00 49.57           O  
ATOM    504  OE2 GLU    67      26.331  18.211   9.936  1.00 47.88           O  
ATOM    505  N   THR    68      24.057  16.754  11.196  1.00 43.40           N  
ATOM    506  CA  THR    68      23.815  15.353  10.828  1.00 43.81           C  
ATOM    507  C   THR    68      25.062  14.608  10.292  1.00 43.32           C  
ATOM    508  O   THR    68      25.062  13.375  10.193  1.00 43.61           O  
ATOM    509  CB  THR    68      22.682  15.260   9.760  1.00 44.60           C  
ATOM    510  OG1 THR    68      23.040  16.030   8.608  1.00 44.60           O  
ATOM    511  CG2 THR    68      21.339  15.782  10.317  1.00 44.27           C  
ATOM    512  N   LYS    69      26.113  15.346   9.937  1.00 42.95           N  
ATOM    513  CA  LYS    69      27.360  14.748   9.426  1.00 42.71           C  
ATOM    514  C   LYS    69      28.367  14.499  10.552  1.00 42.24           C  
ATOM    515  O   LYS    69      28.805  15.432  11.222  1.00 41.49           O  
ATOM    516  CB  LYS    69      27.982  15.665   8.365  1.00 43.12           C  
ATOM    517  N   ASP    70      28.754  13.242  10.751  1.00 42.33           N  
ATOM    518  CA  ASP    70      29.666  12.900  11.844  1.00 42.59           C  
ATOM    519  C   ASP    70      31.152  13.014  11.461  1.00 42.55           C  
ATOM    520  O   ASP    70      32.018  12.600  12.225  1.00 42.47           O  
ATOM    521  CB  ASP    70      29.300  11.531  12.500  1.00 42.89           C  
ATOM    522  CG  ASP    70      29.642  10.330  11.638  1.00 44.57           C  
ATOM    523  OD1 ASP    70      30.098  10.523  10.493  1.00 47.83           O  
ATOM    524  OD2 ASP    70      29.440   9.183  12.099  1.00 44.97           O  
ATOM    525  N   TYR    71      31.428  13.594  10.290  1.00 42.85           N  
ATOM    526  CA  TYR    71      32.783  13.917   9.856  1.00 42.91           C  
ATOM    527  C   TYR    71      32.710  15.258   9.139  1.00 42.56           C  
ATOM    528  O   TYR    71      31.804  15.477   8.342  1.00 43.39           O  
ATOM    529  CB  TYR    71      33.366  12.843   8.914  1.00 43.24           C  
ATOM    530  CG  TYR    71      34.905  12.846   8.805  1.00 42.94           C  
ATOM    531  CD1 TYR    71      35.697  12.097   9.698  1.00 43.93           C  
ATOM    532  CD2 TYR    71      35.557  13.579   7.817  1.00 42.74           C  
ATOM    533  CE1 TYR    71      37.104  12.091   9.606  1.00 43.63           C  
ATOM    534  CE2 TYR    71      36.954  13.576   7.706  1.00 43.03           C  
ATOM    535  CZ  TYR    71      37.730  12.831   8.600  1.00 44.06           C  
ATOM    536  OH  TYR    71      39.125  12.835   8.488  1.00 43.45           O  
ATOM    537  N   PRO    72      33.625  16.189   9.455  1.00 41.60           N  
ATOM    538  CA  PRO    72      34.725  16.088  10.394  1.00 40.90           C  
ATOM    539  C   PRO    72      34.244  16.180  11.843  1.00 40.00           C  
ATOM    540  O   PRO    72      33.101  16.563  12.113  1.00 39.44           O  
ATOM    541  CB  PRO    72      35.598  17.290  10.021  1.00 40.75           C  
ATOM    542  CG  PRO    72      34.642  18.284   9.584  1.00 41.25           C  
ATOM    543  CD  PRO    72      33.563  17.535   8.860  1.00 41.61           C  
ATOM    544  N   VAL    73      35.116  15.796  12.758  1.00 39.25           N  
ATOM    545  CA  VAL    73      34.790  15.771  14.166  1.00 38.70           C  
ATOM    546  C   VAL    73      35.314  17.074  14.791  1.00 38.13           C  
ATOM    547  O   VAL    73      36.446  17.478  14.519  1.00 38.73           O  
ATOM    548  CB  VAL    73      35.452  14.569  14.854  1.00 38.74           C  
ATOM    549  CG1 VAL    73      35.151  14.567  16.354  1.00 38.20           C  
ATOM    550  CG2 VAL    73      35.013  13.269  14.191  1.00 39.08           C  
ATOM    551  N   PRO    74      34.517  17.727  15.655  1.00 37.44           N  
ATOM    552  CA  PRO    74      35.051  18.883  16.382  1.00 36.76           C  
ATOM    553  C   PRO    74      36.312  18.587  17.184  1.00 36.56           C  
ATOM    554  O   PRO    74      36.464  17.485  17.707  1.00 35.92           O  
ATOM    555  CB  PRO    74      33.907  19.239  17.334  1.00 36.40           C  
ATOM    556  CG  PRO    74      32.712  18.794  16.639  1.00 35.99           C  
ATOM    557  CD  PRO    74      33.106  17.491  16.010  1.00 37.63           C  
ATOM    558  N   THR    75      37.197  19.577  17.308  1.00 37.11           N  
ATOM    559  CA  THR    75      38.420  19.400  18.104  1.00 37.55           C  
ATOM    560  C   THR    75      38.298  19.809  19.582  1.00 38.15           C  
ATOM    561  O   THR    75      39.186  19.506  20.388  1.00 37.83           O  
ATOM    562  CB  THR    75      39.637  20.078  17.456  1.00 37.85           C  
ATOM    563  OG1 THR    75      39.406  21.479  17.284  1.00 36.14           O  
ATOM    564  CG2 THR    75      39.914  19.428  16.094  1.00 38.81           C  
ATOM    565  N   SER    76      37.189  20.449  19.949  1.00 37.93           N  
ATOM    566  CA  SER    76      36.993  20.911  21.313  1.00 37.91           C  
ATOM    567  C   SER    76      35.887  20.136  21.959  1.00 37.58           C  
ATOM    568  O   SER    76      34.809  20.014  21.382  1.00 37.85           O  
ATOM    569  CB  SER    76      36.635  22.399  21.320  1.00 38.14           C  
ATOM    570  OG  SER    76      35.824  22.693  22.444  1.00 39.20           O  
ATOM    571  N   ALA    77      36.133  19.606  23.156  1.00 37.95           N  
ATOM    572  CA  ALA    77      35.137  18.753  23.821  1.00 38.33           C  
ATOM    573  C   ALA    77      33.931  19.597  24.265  1.00 38.87           C  
ATOM    574  O   ALA    77      32.819  19.078  24.436  1.00 38.94           O  
ATOM    575  CB  ALA    77      35.742  17.988  24.990  1.00 38.12           C  
ATOM    576  N   LYS    78      34.130  20.907  24.370  1.00 39.08           N  
ATOM    577  CA  LYS    78      33.032  21.806  24.723  1.00 39.75           C  
ATOM    578  C   LYS    78      32.038  21.915  23.581  1.00 39.51           C  
ATOM    579  O   LYS    78      30.839  21.982  23.819  1.00 40.22           O  
ATOM    580  CB  LYS    78      33.523  23.197  25.118  1.00 39.29           C  
ATOM    581  CG  LYS    78      32.574  23.869  26.098  1.00 40.21           C  
ATOM    582  CD  LYS    78      33.048  25.265  26.529  1.00 40.61           C  
ATOM    583  CE  LYS    78      32.139  26.352  25.985  1.00 42.02           C  
ATOM    584  NZ  LYS    78      30.808  26.307  26.638  1.00 42.42           N  
ATOM    585  N   THR    79      32.529  21.930  22.345  1.00 39.41           N  
ATOM    586  CA  THR    79      31.637  21.886  21.184  1.00 39.10           C  
ATOM    587  C   THR    79      30.776  20.638  21.160  1.00 38.89           C  
ATOM    588  O   THR    79      29.597  20.711  20.832  1.00 40.76           O  
ATOM    589  CB  THR    79      32.399  22.005  19.859  1.00 38.85           C  
ATOM    590  OG1 THR    79      33.154  23.214  19.869  1.00 38.67           O  
ATOM    591  CG2 THR    79      31.429  22.065  18.683  1.00 39.84           C  
ATOM    592  N   ILE    80      31.358  19.496  21.500  1.00 37.87           N  
ATOM    593  CA  ILE    80      30.642  18.224  21.465  1.00 37.23           C  
ATOM    594  C   ILE    80      29.556  18.137  22.544  1.00 36.97           C  
ATOM    595  O   ILE    80      28.392  17.854  22.253  1.00 37.19           O  
ATOM    596  CB  ILE    80      31.627  17.027  21.568  1.00 36.96           C  
ATOM    597  CG1 ILE    80      32.624  17.060  20.379  1.00 36.88           C  
ATOM    598  CG2 ILE    80      30.864  15.675  21.647  1.00 35.26           C  
ATOM    599  CD1 ILE    80      33.641  15.932  20.348  1.00 37.46           C  
ATOM    600  N   ALA    81      29.937  18.377  23.789  1.00 36.74           N  
ATOM    601  CA  ALA    81      29.006  18.343  24.910  1.00 36.66           C  
ATOM    602  C   ALA    81      27.873  19.378  24.744  1.00 37.19           C  
ATOM    603  O   ALA    81      26.700  19.092  25.046  1.00 36.55           O  
ATOM    604  CB  ALA    81      29.777  18.567  26.224  1.00 37.06           C  
ATOM    605  N   ASP    82      28.219  20.572  24.259  1.00 37.79           N  
ATOM    606  CA  ASP    82      27.231  21.625  24.043  1.00 38.43           C  
ATOM    607  C   ASP    82      26.311  21.309  22.875  1.00 38.88           C  
ATOM    608  O   ASP    82      25.102  21.470  22.976  1.00 38.28           O  
ATOM    609  CB  ASP    82      27.900  22.979  23.835  1.00 38.51           C  
ATOM    610  CG  ASP    82      28.488  23.539  25.127  1.00 40.46           C  
ATOM    611  OD1 ASP    82      28.625  22.771  26.119  1.00 42.63           O  
ATOM    612  OD2 ASP    82      28.834  24.734  25.154  1.00 33.97           O  
ATOM    613  N   GLY    83      26.895  20.847  21.772  1.00 40.13           N  
ATOM    614  CA  GLY    83      26.137  20.242  20.672  1.00 40.53           C  
ATOM    615  C   GLY    83      25.089  19.235  21.105  1.00 40.91           C  
ATOM    616  O   GLY    83      23.944  19.333  20.687  1.00 41.21           O  
ATOM    617  N   TYR    84      25.469  18.265  21.928  1.00 41.63           N  
ATOM    618  CA  TYR    84      24.503  17.292  22.452  1.00 41.56           C  
ATOM    619  C   TYR    84      23.374  17.990  23.233  1.00 42.71           C  
ATOM    620  O   TYR    84      22.211  17.671  23.042  1.00 42.92           O  
ATOM    621  CB  TYR    84      25.180  16.286  23.363  1.00 41.30           C  
ATOM    622  CG  TYR    84      24.276  15.137  23.762  1.00 40.64           C  
ATOM    623  CD1 TYR    84      23.985  14.118  22.877  1.00 41.04           C  
ATOM    624  CD2 TYR    84      23.696  15.092  25.018  1.00 40.97           C  
ATOM    625  CE1 TYR    84      23.169  13.065  23.241  1.00 40.97           C  
ATOM    626  CE2 TYR    84      22.863  14.073  25.382  1.00 39.98           C  
ATOM    627  CZ  TYR    84      22.604  13.057  24.499  1.00 40.99           C  
ATOM    628  OH  TYR    84      21.786  12.029  24.880  1.00 40.71           O  
ATOM    629  N   ARG    85      23.725  18.935  24.101  1.00 43.13           N  
ATOM    630  CA  ARG    85      22.735  19.630  24.915  1.00 44.43           C  
ATOM    631  C   ARG    85      21.742  20.346  24.009  1.00 44.49           C  
ATOM    632  O   ARG    85      20.531  20.215  24.184  1.00 45.40           O  
ATOM    633  CB  ARG    85      23.402  20.640  25.857  1.00 44.20           C  
ATOM    634  CG  ARG    85      22.413  21.416  26.727  1.00 45.42           C  
ATOM    635  CD  ARG    85      23.081  22.302  27.766  1.00 46.23           C  
ATOM    636  NE  ARG    85      23.894  21.513  28.691  1.00 47.92           N  
ATOM    637  CZ  ARG    85      25.228  21.473  28.711  1.00 49.12           C  
ATOM    638  NH1 ARG    85      25.963  22.210  27.870  1.00 49.26           N  
ATOM    639  NH2 ARG    85      25.838  20.690  29.603  1.00 49.86           N  
ATOM    640  N   LYS    86      22.285  21.078  23.038  1.00 44.41           N  
ATOM    641  CA  LYS    86      21.524  21.907  22.092  1.00 44.22           C  
ATOM    642  C   LYS    86      20.519  21.090  21.292  1.00 44.21           C  
ATOM    643  O   LYS    86      19.328  21.437  21.238  1.00 44.20           O  
ATOM    644  CB  LYS    86      22.497  22.582  21.113  1.00 44.43           C  
ATOM    645  CG  LYS    86      22.184  24.005  20.742  1.00 44.56           C  
ATOM    646  CD  LYS    86      23.377  24.630  20.012  1.00 44.07           C  
ATOM    647  N   VAL    87      20.999  20.014  20.670  1.00 43.34           N  
ATOM    648  CA  VAL    87      20.168  19.228  19.768  1.00 43.89           C  
ATOM    649  C   VAL    87      19.150  18.360  20.517  1.00 43.64           C  
ATOM    650  O   VAL    87      18.048  18.135  20.023  1.00 43.37           O  
ATOM    651  CB  VAL    87      21.004  18.366  18.782  1.00 43.25           C  
ATOM    652  CG1 VAL    87      21.605  17.148  19.465  1.00 44.08           C  
ATOM    653  CG2 VAL    87      20.137  17.958  17.625  1.00 44.87           C  
ATOM    654  N   ASN    88      19.508  17.892  21.712  1.00 43.54           N  
ATOM    655  CA  ASN    88      18.537  17.209  22.557  1.00 43.84           C  
ATOM    656  C   ASN    88      17.379  18.147  22.921  1.00 42.62           C  
ATOM    657  O   ASN    88      16.228  17.764  22.876  1.00 42.64           O  
ATOM    658  CB  ASN    88      19.175  16.635  23.827  1.00 44.30           C  
ATOM    659  CG  ASN    88      18.201  15.759  24.605  1.00 46.95           C  
ATOM    660  OD1 ASN    88      17.648  14.805  24.059  1.00 53.28           O  
ATOM    661  ND2 ASN    88      17.948  16.106  25.857  1.00 48.55           N  
ATOM    662  N   THR    89      17.692  19.388  23.261  1.00 41.84           N  
ATOM    663  CA  THR    89      16.667  20.354  23.578  1.00 40.67           C  
ATOM    664  C   THR    89      15.751  20.638  22.388  1.00 39.96           C  
ATOM    665  O   THR    89      14.524  20.697  22.544  1.00 39.37           O  
ATOM    666  CB  THR    89      17.290  21.647  24.091  1.00 40.97           C  
ATOM    667  OG1 THR    89      17.883  21.385  25.363  1.00 41.62           O  
ATOM    668  CG2 THR    89      16.244  22.742  24.251  1.00 40.72           C  
ATOM    669  N   ALA    90      16.338  20.816  21.208  1.00 38.61           N  
ATOM    670  CA  ALA    90      15.552  21.081  20.004  1.00 37.69           C  
ATOM    671  C   ALA    90      14.692  19.851  19.685  1.00 36.75           C  
ATOM    672  O   ALA    90      13.558  19.938  19.240  1.00 35.66           O  
ATOM    673  CB  ALA    90      16.476  21.405  18.846  1.00 37.51           C  
ATOM    674  N   PHE    91      15.236  18.688  19.940  1.00 36.98           N  
ATOM    675  CA  PHE    91      14.496  17.474  19.649  1.00 36.00           C  
ATOM    676  C   PHE    91      13.246  17.372  20.529  1.00 36.57           C  
ATOM    677  O   PHE    91      12.120  17.292  20.032  1.00 34.89           O  
ATOM    678  CB  PHE    91      15.387  16.256  19.855  1.00 36.99           C  
ATOM    679  CG  PHE    91      14.620  14.973  19.985  1.00 35.67           C  
ATOM    680  CD1 PHE    91      13.551  14.704  19.143  1.00 38.06           C  
ATOM    681  CD2 PHE    91      14.934  14.059  20.977  1.00 36.48           C  
ATOM    682  CE1 PHE    91      12.827  13.483  19.261  1.00 36.10           C  
ATOM    683  CE2 PHE    91      14.205  12.875  21.113  1.00 37.37           C  
ATOM    684  CZ  PHE    91      13.151  12.607  20.255  1.00 36.55           C  
ATOM    685  N   VAL    92      13.476  17.404  21.841  1.00 37.94           N  
ATOM    686  CA  VAL    92      12.452  17.205  22.863  1.00 38.72           C  
ATOM    687  C   VAL    92      11.400  18.314  22.786  1.00 40.34           C  
ATOM    688  O   VAL    92      10.218  18.099  23.079  1.00 40.64           O  
ATOM    689  CB  VAL    92      13.129  17.126  24.261  1.00 38.71           C  
ATOM    690  CG1 VAL    92      12.144  17.330  25.406  1.00 38.25           C  
ATOM    691  CG2 VAL    92      13.867  15.772  24.400  1.00 38.04           C  
ATOM    692  N   GLU    93      11.837  19.492  22.366  1.00 41.44           N  
ATOM    693  CA  GLU    93      10.924  20.605  22.132  1.00 42.47           C  
ATOM    694  C   GLU    93      10.005  20.329  20.947  1.00 42.47           C  
ATOM    695  O   GLU    93       8.831  20.693  20.976  1.00 42.48           O  
ATOM    696  CB  GLU    93      11.703  21.891  21.919  1.00 42.35           C  
ATOM    697  CG  GLU    93      12.082  22.588  23.222  1.00 43.35           C  
ATOM    698  CD  GLU    93      12.877  23.865  22.983  1.00 44.62           C  
ATOM    699  OE1 GLU    93      13.485  23.974  21.886  1.00 48.71           O  
ATOM    700  OE2 GLU    93      12.904  24.749  23.879  1.00 44.16           O  
ATOM    701  N   ALA    94      10.529  19.659  19.923  1.00 42.55           N  
ATOM    702  CA  ALA    94       9.744  19.392  18.716  1.00 42.83           C  
ATOM    703  C   ALA    94       8.751  18.265  18.979  1.00 42.87           C  
ATOM    704  O   ALA    94       7.604  18.324  18.549  1.00 42.78           O  
ATOM    705  CB  ALA    94      10.647  19.072  17.533  1.00 42.51           C  
ATOM    706  N   LEU    95       9.197  17.259  19.719  1.00 43.07           N  
ATOM    707  CA  LEU    95       8.347  16.140  20.101  1.00 43.63           C  
ATOM    708  C   LEU    95       7.153  16.647  20.912  1.00 44.22           C  
ATOM    709  O   LEU    95       6.023  16.252  20.655  1.00 44.02           O  
ATOM    710  CB  LEU    95       9.150  15.113  20.916  1.00 43.35           C  
ATOM    711  CG  LEU    95       8.613  13.678  20.961  1.00 44.47           C  
ATOM    712  CD1 LEU    95       9.029  12.945  19.715  1.00 44.85           C  
ATOM    713  CD2 LEU    95       9.125  12.934  22.177  1.00 44.58           C  
ATOM    714  N   GLN    96       7.405  17.523  21.884  1.00 44.66           N  
ATOM    715  CA  GLN    96       6.337  18.010  22.767  1.00 45.73           C  
ATOM    716  C   GLN    96       5.367  18.947  22.041  1.00 45.50           C  
ATOM    717  O   GLN    96       4.181  18.988  22.371  1.00 44.91           O  
ATOM    718  CB  GLN    96       6.910  18.696  24.018  1.00 45.79           C  
ATOM    719  CG  GLN    96       7.446  17.716  25.079  1.00 47.48           C  
ATOM    720  CD  GLN    96       8.238  18.399  26.191  1.00 47.89           C  
ATOM    721  OE1 GLN    96       9.012  17.752  26.904  1.00 52.61           O  
ATOM    722  NE2 GLN    96       8.066  19.708  26.330  1.00 50.79           N  
ATOM    723  N   SER    97       5.879  19.689  21.058  1.00 45.59           N  
ATOM    724  CA  SER    97       5.062  20.610  20.267  1.00 45.39           C  
ATOM    725  C   SER    97       4.186  19.882  19.268  1.00 44.94           C  
ATOM    726  O   SER    97       2.999  20.197  19.144  1.00 44.29           O  
ATOM    727  CB  SER    97       5.946  21.573  19.489  1.00 45.21           C  
ATOM    728  OG  SER    97       6.738  22.327  20.376  1.00 47.85           O  
ATOM    729  N   GLU    98       4.770  18.909  18.563  1.00 44.39           N  
ATOM    730  CA  GLU    98       4.132  18.339  17.376  1.00 44.11           C  
ATOM    731  C   GLU    98       3.443  16.988  17.566  1.00 44.04           C  
ATOM    732  O   GLU    98       2.494  16.690  16.845  1.00 44.30           O  
ATOM    733  CB  GLU    98       5.128  18.292  16.212  1.00 43.90           C  
ATOM    734  CG  GLU    98       5.685  19.691  15.814  1.00 44.83           C  
ATOM    735  CD  GLU    98       4.638  20.610  15.166  1.00 43.08           C  
ATOM    736  N   TRP    99       3.888  16.174  18.519  1.00 43.90           N  
ATOM    737  CA  TRP    99       3.322  14.836  18.696  1.00 43.46           C  
ATOM    738  C   TRP    99       2.442  14.735  19.934  1.00 42.97           C  
ATOM    739  O   TRP    99       2.682  15.429  20.933  1.00 42.89           O  
ATOM    740  CB  TRP    99       4.432  13.775  18.781  1.00 44.11           C  
ATOM    741  CG  TRP    99       5.109  13.464  17.469  1.00 44.44           C  
ATOM    742  CD1 TRP    99       4.946  14.119  16.279  1.00 45.11           C  
ATOM    743  CD2 TRP    99       6.097  12.448  17.233  1.00 44.70           C  
ATOM    744  NE1 TRP    99       5.755  13.557  15.316  1.00 45.68           N  
ATOM    745  CE2 TRP    99       6.474  12.536  15.876  1.00 44.29           C  
ATOM    746  CE3 TRP    99       6.698  11.480  18.034  1.00 43.74           C  
ATOM    747  CZ2 TRP    99       7.421  11.695  15.306  1.00 44.86           C  
ATOM    748  CZ3 TRP    99       7.644  10.629  17.460  1.00 45.39           C  
ATOM    749  CH2 TRP    99       7.989  10.741  16.109  1.00 44.90           C  
ATOM    750  N   THR   100       1.425  13.871  19.839  1.00 41.65           N  
ATOM    751  CA  THR   100       0.652  13.383  20.981  1.00 41.00           C  
ATOM    752  C   THR   100       0.813  11.852  20.992  1.00 40.50           C  
ATOM    753  O   THR   100       1.514  11.314  20.141  1.00 40.72           O  
ATOM    754  CB  THR   100      -0.846  13.812  20.897  1.00 40.77           C  
ATOM    755  OG1 THR   100      -1.404  13.441  19.629  1.00 40.49           O  
ATOM    756  CG2 THR   100      -0.992  15.327  21.057  1.00 40.81           C  
ATOM    757  N   ASP   101       0.187  11.146  21.929  1.00 39.96           N  
ATOM    758  CA  ASP   101       0.385   9.675  22.036  1.00 40.12           C  
ATOM    759  C   ASP   101       0.125   8.875  20.757  1.00 39.90           C  
ATOM    760  O   ASP   101       0.769   7.839  20.539  1.00 39.45           O  
ATOM    761  CB  ASP   101      -0.492   9.063  23.133  1.00 40.35           C  
ATOM    762  CG  ASP   101      -0.235   9.655  24.507  1.00 41.58           C  
ATOM    763  OD1 ASP   101       0.874  10.173  24.753  1.00 43.38           O  
ATOM    764  OD2 ASP   101      -1.165   9.602  25.344  1.00 43.32           O  
ATOM    765  N   LYS   102      -0.849   9.317  19.950  1.00 39.81           N  
ATOM    766  CA  LYS   102      -1.244   8.609  18.724  1.00 39.58           C  
ATOM    767  C   LYS   102      -0.172   8.589  17.628  1.00 39.56           C  
ATOM    768  O   LYS   102      -0.036   7.594  16.897  1.00 40.62           O  
ATOM    769  CB  LYS   102      -2.572   9.146  18.167  1.00 39.80           C  
ATOM    770  CG  LYS   102      -2.571  10.528  17.525  1.00 39.75           C  
ATOM    771  CD  LYS   102      -4.014  10.963  17.217  1.00 40.05           C  
ATOM    772  CE  LYS   102      -4.091  12.418  16.750  1.00 41.68           C  
ATOM    773  NZ  LYS   102      -5.506  12.928  16.619  1.00 42.03           N  
ATOM    774  N   ASP   103       0.599   9.667  17.552  1.00 39.64           N  
ATOM    775  CA  ASP   103       1.687   9.806  16.598  1.00 39.19           C  
ATOM    776  C   ASP   103       2.753   8.704  16.736  1.00 38.64           C  
ATOM    777  O   ASP   103       3.510   8.433  15.799  1.00 38.48           O  
ATOM    778  CB  ASP   103       2.345  11.167  16.772  1.00 39.27           C  
ATOM    779  CG  ASP   103       1.439  12.312  16.386  1.00 39.58           C  
ATOM    780  OD1 ASP   103       1.247  12.555  15.174  1.00 40.37           O  
ATOM    781  OD2 ASP   103       0.932  13.000  17.297  1.00 40.06           O  
ATOM    782  N   LEU   104       2.825   8.086  17.909  1.00 37.92           N  
ATOM    783  CA  LEU   104       3.742   6.980  18.125  1.00 37.58           C  
ATOM    784  C   LEU   104       3.402   5.768  17.262  1.00 36.67           C  
ATOM    785  O   LEU   104       4.255   4.897  17.073  1.00 37.21           O  
ATOM    786  CB  LEU   104       3.771   6.579  19.598  1.00 37.60           C  
ATOM    787  CG  LEU   104       4.409   7.599  20.533  1.00 38.72           C  
ATOM    788  CD1 LEU   104       4.135   7.239  21.987  1.00 38.99           C  
ATOM    789  CD2 LEU   104       5.902   7.686  20.264  1.00 38.50           C  
ATOM    790  N   THR   105       2.158   5.698  16.767  1.00 35.51           N  
ATOM    791  CA  THR   105       1.721   4.617  15.876  1.00 34.57           C  
ATOM    792  C   THR   105       1.897   4.923  14.386  1.00 33.86           C  
ATOM    793  O   THR   105       1.828   4.030  13.565  1.00 32.73           O  
ATOM    794  CB  THR   105       0.226   4.240  16.105  1.00 34.44           C  
ATOM    795  OG1 THR   105      -0.630   5.312  15.676  1.00 34.26           O  
ATOM    796  CG2 THR   105      -0.032   3.932  17.572  1.00 35.11           C  
ATOM    797  N   THR   106       2.078   6.184  14.009  1.00 33.40           N  
ATOM    798  CA  THR   106       2.235   6.511  12.594  1.00 33.85           C  
ATOM    799  C   THR   106       3.410   5.787  11.976  1.00 35.81           C  
ATOM    800  O   THR   106       4.544   5.879  12.469  1.00 36.15           O  
ATOM    801  CB  THR   106       2.433   8.013  12.428  1.00 34.10           C  
ATOM    802  OG1 THR   106       1.414   8.638  13.188  1.00 31.30           O  
ATOM    803  CG2 THR   106       2.327   8.420  10.959  1.00 34.03           C  
ATOM    804  N   ILE   107       3.132   5.025  10.920  1.00 38.13           N  
ATOM    805  CA  ILE   107       4.158   4.261  10.213  1.00 39.30           C  
ATOM    806  C   ILE   107       4.981   5.173   9.307  1.00 40.57           C  
ATOM    807  O   ILE   107       4.429   5.895   8.477  1.00 40.68           O  
ATOM    808  CB  ILE   107       3.529   3.114   9.412  1.00 39.46           C  
ATOM    809  CG1 ILE   107       3.043   2.027  10.371  1.00 39.21           C  
ATOM    810  CG2 ILE   107       4.549   2.512   8.452  1.00 41.13           C  
ATOM    811  CD1 ILE   107       2.244   0.962   9.685  1.00 38.98           C  
ATOM    812  N   ASN   108       6.302   5.183   9.514  1.00 41.61           N  
ATOM    813  CA  ASN   108       7.226   5.941   8.673  1.00 42.13           C  
ATOM    814  C   ASN   108       8.345   5.016   8.148  1.00 43.07           C  
ATOM    815  O   ASN   108       8.456   3.821   8.511  1.00 43.07           O  
ATOM    816  CB  ASN   108       7.791   7.132   9.443  1.00 42.42           C  
ATOM    817  CG  ASN   108       6.890   8.360   9.402  1.00 43.28           C  
ATOM    818  OD1 ASN   108       6.703   8.971   8.351  1.00 42.03           O  
ATOM    819  ND2 ASN   108       6.370   8.759  10.563  1.00 45.25           N  
ATOM    820  N   ASP   109       9.155   5.564   7.259  1.00 44.42           N  
ATOM    821  CA  ASP   109      10.191   4.796   6.604  1.00 45.61           C  
ATOM    822  C   ASP   109      11.493   4.922   7.361  1.00 45.73           C  
ATOM    823  O   ASP   109      12.034   6.025   7.476  1.00 44.24           O  
ATOM    824  CB  ASP   109      10.394   5.295   5.178  1.00 46.20           C  
ATOM    825  CG  ASP   109      11.490   4.541   4.457  1.00 48.35           C  
ATOM    826  OD1 ASP   109      11.393   3.292   4.368  1.00 54.39           O  
ATOM    827  OD2 ASP   109      12.451   5.188   3.989  1.00 51.03           O  
ATOM    828  N   PHE   110      12.011   3.805   7.872  1.00 46.52           N  
ATOM    829  CA  PHE   110      13.354   3.834   8.470  1.00 47.64           C  
ATOM    830  C   PHE   110      14.370   3.250   7.512  1.00 48.40           C  
ATOM    831  O   PHE   110      14.465   2.031   7.360  1.00 46.87           O  
ATOM    832  CB  PHE   110      13.432   3.133   9.827  1.00 48.31           C  
ATOM    833  CG  PHE   110      14.798   3.279  10.495  1.00 49.63           C  
ATOM    834  CD1 PHE   110      15.256   4.535  10.910  1.00 49.78           C  
ATOM    835  CD2 PHE   110      15.640   2.190  10.660  1.00 51.36           C  
ATOM    836  CE1 PHE   110      16.530   4.685  11.507  1.00 50.52           C  
ATOM    837  CE2 PHE   110      16.911   2.336  11.254  1.00 50.54           C  
ATOM    838  CZ  PHE   110      17.346   3.587  11.685  1.00 51.58           C  
ATOM    839  N   PHE   111      15.103   4.133   6.839  1.00 49.53           N  
ATOM    840  CA  PHE   111      16.111   3.712   5.870  1.00 51.07           C  
ATOM    841  C   PHE   111      15.669   2.458   5.100  1.00 51.26           C  
ATOM    842  O   PHE   111      16.360   1.437   5.113  1.00 51.68           O  
ATOM    843  CB  PHE   111      17.452   3.440   6.570  1.00 51.89           C  
ATOM    844  CG  PHE   111      17.985   4.614   7.351  1.00 52.62           C  
ATOM    845  CD1 PHE   111      18.174   5.854   6.733  1.00 54.80           C  
ATOM    846  CD2 PHE   111      18.287   4.487   8.692  1.00 52.93           C  
ATOM    847  CE1 PHE   111      18.658   6.948   7.451  1.00 53.82           C  
ATOM    848  CE2 PHE   111      18.773   5.575   9.419  1.00 54.61           C  
ATOM    849  CZ  PHE   111      18.955   6.808   8.787  1.00 53.77           C  
ATOM    850  N   GLY   112      14.504   2.524   4.466  1.00 51.34           N  
ATOM    851  CA  GLY   112      14.030   1.412   3.625  1.00 51.36           C  
ATOM    852  C   GLY   112      12.917   0.541   4.188  1.00 51.10           C  
ATOM    853  O   GLY   112      12.110   0.033   3.426  1.00 51.41           O  
ATOM    854  N   ARG   113      12.864   0.349   5.506  1.00 50.84           N  
ATOM    855  CA  ARG   113      11.790  -0.462   6.103  1.00 50.80           C  
ATOM    856  C   ARG   113      10.723   0.413   6.788  1.00 49.66           C  
ATOM    857  O   ARG   113      11.048   1.428   7.389  1.00 49.62           O  
ATOM    858  CB  ARG   113      12.348  -1.553   7.040  1.00 51.29           C  
ATOM    859  CG  ARG   113      13.239  -1.084   8.214  1.00 52.28           C  
ATOM    860  CD  ARG   113      14.124  -2.262   8.714  1.00 52.16           C  
ATOM    861  N   PRO   114       9.435   0.047   6.649  1.00 48.76           N  
ATOM    862  CA  PRO   114       8.375   0.810   7.306  1.00 47.97           C  
ATOM    863  C   PRO   114       8.189   0.360   8.759  1.00 46.80           C  
ATOM    864  O   PRO   114       8.054  -0.825   9.027  1.00 47.46           O  
ATOM    865  CB  PRO   114       7.140   0.506   6.449  1.00 47.96           C  
ATOM    866  CG  PRO   114       7.379  -0.877   5.941  1.00 48.86           C  
ATOM    867  CD  PRO   114       8.887  -1.082   5.872  1.00 49.07           C  
ATOM    868  N   MET   115       8.177   1.318   9.678  0.50 46.47           N  
ATOM    870  CA  MET   115       8.056   1.030  11.103  0.50 45.86           C  
ATOM    872  C   MET   115       7.291   2.168  11.788  0.50 44.88           C  
ATOM    874  O   MET   115       7.359   3.309  11.343  0.50 44.01           O  
ATOM    876  CB  MET   115       9.451   0.898  11.739  0.50 46.26           C  
ATOM    878  CG  MET   115      10.313  -0.248  11.193  0.50 47.41           C  
ATOM    880  SD  MET   115       9.615  -1.997  11.588  0.38 50.15          SE  
ATOM    882  CE  MET   115      10.573  -2.363  13.234  0.50 47.61           C  
ATOM    884  N   PRO   116       6.549   1.854  12.864  1.00 43.99           N  
ATOM    885  CA  PRO   116       5.908   2.915  13.646  1.00 43.79           C  
ATOM    886  C   PRO   116       6.908   3.920  14.251  1.00 43.02           C  
ATOM    887  O   PRO   116       8.073   3.608  14.453  1.00 43.43           O  
ATOM    888  CB  PRO   116       5.140   2.150  14.737  1.00 43.24           C  
ATOM    889  CG  PRO   116       5.546   0.747  14.654  1.00 43.88           C  
ATOM    890  CD  PRO   116       6.238   0.505  13.371  1.00 43.91           C  
ATOM    891  N   ASN   117       6.469   5.128  14.529  1.00 43.16           N  
ATOM    892  CA  ASN   117       7.364   6.096  15.140  1.00 42.24           C  
ATOM    893  C   ASN   117       8.000   5.609  16.448  1.00 42.64           C  
ATOM    894  O   ASN   117       9.145   5.941  16.721  1.00 41.88           O  
ATOM    895  CB  ASN   117       6.677   7.436  15.340  1.00 42.23           C  
ATOM    896  CG  ASN   117       6.544   8.202  14.055  1.00 40.47           C  
ATOM    897  OD1 ASN   117       7.400   8.099  13.181  1.00 38.78           O  
ATOM    898  ND2 ASN   117       5.470   8.955  13.918  1.00 38.60           N  
ATOM    899  N   SER   118       7.285   4.802  17.231  1.00 42.46           N  
ATOM    900  CA  SER   118       7.817   4.322  18.514  1.00 42.93           C  
ATOM    901  C   SER   118       9.114   3.502  18.368  1.00 43.27           C  
ATOM    902  O   SER   118       9.988   3.534  19.238  1.00 43.99           O  
ATOM    903  CB  SER   118       6.773   3.497  19.258  1.00 42.42           C  
ATOM    904  OG  SER   118       6.295   2.479  18.432  1.00 41.62           O  
ATOM    905  N   ILE   119       9.237   2.797  17.258  1.00 43.05           N  
ATOM    906  CA  ILE   119      10.407   1.994  16.975  1.00 42.90           C  
ATOM    907  C   ILE   119      11.566   2.922  16.605  1.00 41.18           C  
ATOM    908  O   ILE   119      12.708   2.727  17.031  1.00 40.63           O  
ATOM    909  CB  ILE   119      10.119   0.981  15.854  1.00 42.76           C  
ATOM    910  CG1 ILE   119       9.021  -0.010  16.269  1.00 44.12           C  
ATOM    911  CG2 ILE   119      11.356   0.189  15.505  1.00 44.93           C  
ATOM    912  CD1 ILE   119       9.352  -0.890  17.475  1.00 45.27           C  
ATOM    913  N   PHE   120      11.295   3.973  15.853  1.00 40.62           N  
ATOM    914  CA  PHE   120      12.348   4.973  15.652  1.00 39.21           C  
ATOM    915  C   PHE   120      12.948   5.328  17.000  1.00 39.52           C  
ATOM    916  O   PHE   120      14.185   5.420  17.164  1.00 37.20           O  
ATOM    917  CB  PHE   120      11.821   6.234  15.001  1.00 39.58           C  
ATOM    918  CG  PHE   120      11.571   6.107  13.531  1.00 39.72           C  
ATOM    919  CD1 PHE   120      10.412   5.516  13.048  1.00 39.04           C  
ATOM    920  CD2 PHE   120      12.487   6.596  12.623  1.00 38.89           C  
ATOM    921  CE1 PHE   120      10.182   5.415  11.703  1.00 37.81           C  
ATOM    922  CE2 PHE   120      12.241   6.509  11.278  1.00 39.88           C  
ATOM    923  CZ  PHE   120      11.099   5.880  10.817  1.00 38.14           C  
ATOM    924  N   LEU   121      12.060   5.568  17.965  1.00 40.36           N  
ATOM    925  CA  LEU   121      12.462   6.141  19.252  1.00 40.88           C  
ATOM    926  C   LEU   121      13.201   5.076  20.060  1.00 41.08           C  
ATOM    927  O   LEU   121      14.167   5.373  20.736  1.00 41.03           O  
ATOM    928  CB  LEU   121      11.251   6.666  20.044  1.00 39.89           C  
ATOM    929  CG  LEU   121      10.589   7.958  19.555  1.00 40.55           C  
ATOM    930  CD1 LEU   121       9.500   8.383  20.498  1.00 36.76           C  
ATOM    931  CD2 LEU   121      11.587   9.034  19.411  1.00 37.03           C  
ATOM    932  N   MET   122      12.732   3.839  19.983  1.00 42.59           N  
ATOM    933  CA  MET   122      13.398   2.724  20.632  1.00 44.24           C  
ATOM    934  C   MET   122      14.806   2.595  20.071  1.00 43.62           C  
ATOM    935  O   MET   122      15.748   2.275  20.792  1.00 43.80           O  
ATOM    936  CB  MET   122      12.626   1.429  20.368  1.00 44.26           C  
ATOM    937  CG  MET   122      13.187   0.214  21.018  1.00 45.86           C  
ATOM    938  SD  MET   122      12.557  -1.437  20.132  0.75 51.63          SE  
ATOM    939  CE  MET   122      13.554  -1.285  18.357  1.00 45.57           C  
ATOM    940  N   THR   123      14.928   2.831  18.769  1.00 43.14           N  
ATOM    941  CA  THR   123      16.176   2.644  18.056  1.00 42.91           C  
ATOM    942  C   THR   123      17.158   3.733  18.461  1.00 42.21           C  
ATOM    943  O   THR   123      18.335   3.460  18.652  1.00 41.89           O  
ATOM    944  CB  THR   123      15.935   2.539  16.496  1.00 43.39           C  
ATOM    945  OG1 THR   123      15.197   1.332  16.211  1.00 42.69           O  
ATOM    946  CG2 THR   123      17.277   2.521  15.712  1.00 43.20           C  
ATOM    947  N   LEU   124      16.659   4.957  18.632  1.00 41.77           N  
ATOM    948  CA  LEU   124      17.475   6.046  19.083  1.00 41.19           C  
ATOM    949  C   LEU   124      18.160   5.732  20.419  1.00 40.75           C  
ATOM    950  O   LEU   124      19.355   5.996  20.581  1.00 41.36           O  
ATOM    951  CB  LEU   124      16.623   7.307  19.230  1.00 40.93           C  
ATOM    952  CG  LEU   124      17.272   8.604  19.668  1.00 42.46           C  
ATOM    953  CD1 LEU   124      18.157   9.190  18.567  1.00 43.77           C  
ATOM    954  CD2 LEU   124      16.209   9.596  20.074  1.00 40.62           C  
ATOM    955  N   ILE   125      17.390   5.216  21.370  1.00 39.88           N  
ATOM    956  CA  ILE   125      17.882   4.938  22.718  1.00 39.12           C  
ATOM    957  C   ILE   125      18.893   3.817  22.712  1.00 38.38           C  
ATOM    958  O   ILE   125      19.932   3.928  23.361  1.00 37.70           O  
ATOM    959  CB  ILE   125      16.723   4.572  23.708  1.00 39.09           C  
ATOM    960  CG1 ILE   125      15.852   5.792  23.978  1.00 39.79           C  
ATOM    961  CG2 ILE   125      17.271   4.080  25.043  1.00 38.31           C  
ATOM    962  CD1 ILE   125      14.656   5.520  24.864  1.00 39.65           C  
ATOM    963  N   ASN   126      18.573   2.744  21.993  1.00 37.52           N  
ATOM    964  CA  ASN   126      19.421   1.576  21.890  1.00 37.33           C  
ATOM    965  C   ASN   126      20.784   1.868  21.247  1.00 37.26           C  
ATOM    966  O   ASN   126      21.834   1.440  21.754  1.00 34.80           O  
ATOM    967  CB  ASN   126      18.731   0.501  21.061  1.00 38.33           C  
ATOM    968  CG  ASN   126      17.650  -0.227  21.809  1.00 40.70           C  
ATOM    969  OD1 ASN   126      17.448  -0.023  23.011  1.00 44.17           O  
ATOM    970  ND2 ASN   126      16.942  -1.105  21.098  1.00 40.57           N  
ATOM    971  N   HIS   127      20.745   2.631  20.149  1.00 37.71           N  
ATOM    972  CA  HIS   127      21.946   3.060  19.420  1.00 37.67           C  
ATOM    973  C   HIS   127      22.850   3.873  20.342  1.00 38.98           C  
ATOM    974  O   HIS   127      24.033   3.565  20.464  1.00 39.22           O  
ATOM    975  CB  HIS   127      21.545   3.859  18.163  1.00 37.87           C  
ATOM    976  CG  HIS   127      22.698   4.444  17.394  1.00 35.17           C  
ATOM    977  ND1 HIS   127      23.003   5.788  17.416  1.00 36.73           N  
ATOM    978  CD2 HIS   127      23.596   3.870  16.561  1.00 31.82           C  
ATOM    979  CE1 HIS   127      24.052   6.011  16.635  1.00 36.20           C  
ATOM    980  NE2 HIS   127      24.431   4.859  16.110  1.00 36.17           N  
ATOM    981  N   GLN   128      22.284   4.910  20.959  1.00 39.54           N  
ATOM    982  CA  GLN   128      22.991   5.785  21.878  1.00 39.52           C  
ATOM    983  C   GLN   128      23.639   5.025  23.041  1.00 40.57           C  
ATOM    984  O   GLN   128      24.742   5.354  23.454  1.00 40.88           O  
ATOM    985  CB  GLN   128      22.031   6.804  22.432  1.00 39.57           C  
ATOM    986  CG  GLN   128      22.707   7.895  23.259  1.00 39.96           C  
ATOM    987  CD  GLN   128      21.758   8.933  23.719  1.00 41.12           C  
ATOM    988  OE1 GLN   128      21.881  10.106  23.351  1.00 40.43           O  
ATOM    989  NE2 GLN   128      20.781   8.525  24.537  1.00 40.41           N  
ATOM    990  N   ASN   129      22.938   4.011  23.545  1.00 39.82           N  
ATOM    991  CA  ASN   129      23.372   3.238  24.700  1.00 40.21           C  
ATOM    992  C   ASN   129      24.546   2.321  24.330  1.00 39.31           C  
ATOM    993  O   ASN   129      25.484   2.146  25.103  1.00 37.84           O  
ATOM    994  CB  ASN   129      22.177   2.428  25.230  1.00 40.29           C  
ATOM    995  CG  ASN   129      22.493   1.635  26.501  1.00 43.51           C  
ATOM    996  OD1 ASN   129      23.480   1.893  27.194  1.00 47.46           O  
ATOM    997  ND2 ASN   129      21.635   0.670  26.813  1.00 42.77           N  
ATOM    998  N   HIS   130      24.484   1.738  23.139  1.00 39.10           N  
ATOM    999  CA  HIS   130      25.593   0.936  22.613  1.00 39.02           C  
ATOM   1000  C   HIS   130      26.897   1.733  22.570  1.00 38.12           C  
ATOM   1001  O   HIS   130      27.934   1.271  23.066  1.00 38.39           O  
ATOM   1002  CB  HIS   130      25.256   0.453  21.204  1.00 39.29           C  
ATOM   1003  CG  HIS   130      26.436  -0.046  20.435  1.00 39.26           C  
ATOM   1004  ND1 HIS   130      27.062  -1.242  20.720  1.00 38.14           N  
ATOM   1005  CD2 HIS   130      27.077   0.472  19.358  1.00 38.78           C  
ATOM   1006  CE1 HIS   130      28.049  -1.429  19.861  1.00 39.64           C  
ATOM   1007  NE2 HIS   130      28.076  -0.408  19.022  1.00 37.62           N  
ATOM   1008  N   HIS   131      26.827   2.903  21.955  1.00 37.71           N  
ATOM   1009  CA  HIS   131      27.988   3.785  21.779  1.00 37.24           C  
ATOM   1010  C   HIS   131      28.470   4.463  23.054  1.00 36.58           C  
ATOM   1011  O   HIS   131      29.678   4.713  23.234  1.00 35.94           O  
ATOM   1012  CB  HIS   131      27.678   4.853  20.735  1.00 36.93           C  
ATOM   1013  CG  HIS   131      27.717   4.354  19.332  1.00 37.60           C  
ATOM   1014  ND1 HIS   131      28.868   3.884  18.747  1.00 36.87           N  
ATOM   1015  CD2 HIS   131      26.747   4.253  18.390  1.00 37.91           C  
ATOM   1016  CE1 HIS   131      28.609   3.523  17.505  1.00 37.78           C  
ATOM   1017  NE2 HIS   131      27.336   3.754  17.261  1.00 34.19           N  
ATOM   1018  N   ARG   132      27.543   4.804  23.941  1.00 35.76           N  
ATOM   1019  CA  ARG   132      27.938   5.285  25.276  1.00 34.80           C  
ATOM   1020  C   ARG   132      28.688   4.161  26.034  1.00 33.64           C  
ATOM   1021  O   ARG   132      29.653   4.410  26.732  1.00 34.61           O  
ATOM   1022  CB  ARG   132      26.708   5.777  26.034  1.00 34.99           C  
ATOM   1023  CG  ARG   132      26.991   6.320  27.405  1.00 35.58           C  
ATOM   1024  CD  ARG   132      25.714   6.783  28.055  1.00 36.45           C  
ATOM   1025  NE  ARG   132      24.850   5.641  28.286  1.00 37.68           N  
ATOM   1026  CZ  ARG   132      23.521   5.686  28.360  1.00 38.30           C  
ATOM   1027  NH1 ARG   132      22.846   6.823  28.219  1.00 39.14           N  
ATOM   1028  NH2 ARG   132      22.870   4.562  28.571  1.00 39.80           N  
ATOM   1029  N   GLY   133      28.280   2.922  25.844  1.00 32.34           N  
ATOM   1030  CA  GLY   133      28.989   1.783  26.409  1.00 31.59           C  
ATOM   1031  C   GLY   133      30.444   1.793  25.950  1.00 32.06           C  
ATOM   1032  O   GLY   133      31.351   1.540  26.737  1.00 30.70           O  
ATOM   1033  N   GLN   134      30.653   2.096  24.657  1.00 31.73           N  
ATOM   1034  CA  GLN   134      31.993   2.201  24.073  1.00 31.14           C  
ATOM   1035  C   GLN   134      32.742   3.366  24.677  1.00 31.57           C  
ATOM   1036  O   GLN   134      33.901   3.248  25.057  1.00 31.15           O  
ATOM   1037  CB  GLN   134      31.891   2.422  22.556  1.00 31.55           C  
ATOM   1038  CG  GLN   134      31.237   1.280  21.816  1.00 30.22           C  
ATOM   1039  CD  GLN   134      31.205   1.457  20.280  1.00 30.87           C  
ATOM   1040  OE1 GLN   134      31.000   2.551  19.773  1.00 31.06           O  
ATOM   1041  NE2 GLN   134      31.352   0.342  19.553  1.00 30.25           N  
ATOM   1042  N   MET   135      32.076   4.505  24.775  1.00 32.32           N  
ATOM   1043  CA  MET   135      32.726   5.670  25.337  1.00 32.89           C  
ATOM   1044  C   MET   135      33.338   5.397  26.707  1.00 33.44           C  
ATOM   1045  O   MET   135      34.440   5.908  27.011  1.00 35.37           O  
ATOM   1046  CB  MET   135      31.764   6.835  25.458  1.00 32.64           C  
ATOM   1047  CG  MET   135      31.184   7.333  24.230  1.00 32.39           C  
ATOM   1048  SD  MET   135      30.930   9.293  24.527  0.75 35.42          SE  
ATOM   1049  CE  MET   135      29.463   9.275  25.594  1.00 34.05           C  
ATOM   1050  N   THR   136      32.638   4.614  27.540  1.00 33.67           N  
ATOM   1051  CA  THR   136      33.069   4.336  28.906  1.00 33.46           C  
ATOM   1052  C   THR   136      34.411   3.620  28.966  1.00 33.57           C  
ATOM   1053  O   THR   136      35.226   3.956  29.827  1.00 33.18           O  
ATOM   1054  CB  THR   136      31.974   3.629  29.797  1.00 34.12           C  
ATOM   1055  OG1 THR   136      31.679   2.298  29.339  1.00 33.45           O  
ATOM   1056  CG2 THR   136      30.694   4.480  29.887  1.00 34.20           C  
ATOM   1057  N   VAL   137      34.650   2.652  28.073  1.00 33.16           N  
ATOM   1058  CA  VAL   137      35.947   1.999  28.004  1.00 31.90           C  
ATOM   1059  C   VAL   137      37.024   3.017  27.608  1.00 32.75           C  
ATOM   1060  O   VAL   137      38.055   3.151  28.290  1.00 32.42           O  
ATOM   1061  CB  VAL   137      35.924   0.763  27.088  1.00 32.54           C  
ATOM   1062  CG1 VAL   137      37.310   0.088  27.014  1.00 30.39           C  
ATOM   1063  CG2 VAL   137      34.897  -0.219  27.585  1.00 30.37           C  
ATOM   1064  N   LEU   138      36.754   3.790  26.567  1.00 32.99           N  
ATOM   1065  CA  LEU   138      37.733   4.764  26.071  1.00 33.03           C  
ATOM   1066  C   LEU   138      38.023   5.878  27.082  1.00 33.16           C  
ATOM   1067  O   LEU   138      39.178   6.293  27.240  1.00 33.13           O  
ATOM   1068  CB  LEU   138      37.270   5.365  24.730  1.00 33.09           C  
ATOM   1069  CG  LEU   138      37.161   4.361  23.591  1.00 31.63           C  
ATOM   1070  CD1 LEU   138      36.442   4.958  22.359  1.00 31.53           C  
ATOM   1071  CD2 LEU   138      38.529   3.851  23.223  1.00 28.96           C  
ATOM   1072  N   MET   139      36.987   6.357  27.760  1.00 33.22           N  
ATOM   1073  CA  MET   139      37.166   7.366  28.827  1.00 32.98           C  
ATOM   1074  C   MET   139      38.103   6.866  29.938  1.00 33.25           C  
ATOM   1075  O   MET   139      39.005   7.570  30.356  1.00 32.78           O  
ATOM   1076  CB  MET   139      35.820   7.780  29.415  1.00 33.36           C  
ATOM   1077  CG  MET   139      34.918   8.630  28.492  1.00 32.73           C  
ATOM   1078  SD  MET   139      33.085   8.665  29.128  0.75 30.52          SE  
ATOM   1079  CE  MET   139      32.541   7.010  28.489  1.00 37.70           C  
ATOM   1080  N   ARG   140      37.892   5.632  30.376  1.00 33.99           N  
ATOM   1081  CA  ARG   140      38.755   4.960  31.357  1.00 34.31           C  
ATOM   1082  C   ARG   140      40.199   4.928  30.866  1.00 34.39           C  
ATOM   1083  O   ARG   140      41.151   5.218  31.601  1.00 34.22           O  
ATOM   1084  CB  ARG   140      38.296   3.497  31.528  1.00 35.08           C  
ATOM   1085  CG  ARG   140      37.921   3.085  32.923  1.00 36.93           C  
ATOM   1086  CD  ARG   140      36.405   3.172  33.147  1.00 39.40           C  
ATOM   1087  N   GLN   141      40.353   4.543  29.606  1.00 34.09           N  
ATOM   1088  CA  GLN   141      41.661   4.424  28.977  1.00 33.28           C  
ATOM   1089  C   GLN   141      42.325   5.785  28.806  1.00 33.33           C  
ATOM   1090  O   GLN   141      43.552   5.878  28.835  1.00 33.32           O  
ATOM   1091  CB  GLN   141      41.520   3.683  27.657  1.00 32.82           C  
ATOM   1092  CG  GLN   141      41.363   2.197  27.917  1.00 31.72           C  
ATOM   1093  CD  GLN   141      40.902   1.407  26.735  1.00 29.68           C  
ATOM   1094  OE1 GLN   141      40.531   1.974  25.712  1.00 30.80           O  
ATOM   1095  NE2 GLN   141      40.907   0.076  26.868  1.00 24.28           N  
ATOM   1096  N   ALA   142      41.527   6.837  28.693  1.00 32.84           N  
ATOM   1097  CA  ALA   142      42.065   8.191  28.666  1.00 33.41           C  
ATOM   1098  C   ALA   142      42.404   8.762  30.041  1.00 34.75           C  
ATOM   1099  O   ALA   142      42.844   9.900  30.119  1.00 35.04           O  
ATOM   1100  CB  ALA   142      41.107   9.111  27.974  1.00 33.31           C  
ATOM   1101  N   GLY   143      42.182   7.997  31.107  1.00 35.67           N  
ATOM   1102  CA  GLY   143      42.444   8.465  32.473  1.00 36.87           C  
ATOM   1103  C   GLY   143      41.377   9.378  33.058  1.00 37.96           C  
ATOM   1104  O   GLY   143      41.661  10.162  33.986  1.00 37.88           O  
ATOM   1105  N   LEU   144      40.153   9.293  32.531  1.00 38.67           N  
ATOM   1106  CA  LEU   144      39.039  10.087  33.046  1.00 39.74           C  
ATOM   1107  C   LEU   144      38.243   9.266  34.055  1.00 41.04           C  
ATOM   1108  O   LEU   144      38.272   8.033  34.042  1.00 41.16           O  
ATOM   1109  CB  LEU   144      38.115  10.554  31.904  1.00 39.79           C  
ATOM   1110  CG  LEU   144      38.750  11.388  30.784  1.00 39.05           C  
ATOM   1111  CD1 LEU   144      37.741  11.652  29.658  1.00 37.45           C  
ATOM   1112  CD2 LEU   144      39.326  12.691  31.324  1.00 37.24           C  
ATOM   1113  N   THR   145      37.532   9.955  34.939  1.00 42.81           N  
ATOM   1114  CA  THR   145      36.675   9.292  35.916  1.00 43.91           C  
ATOM   1115  C   THR   145      35.292   9.190  35.292  1.00 44.95           C  
ATOM   1116  O   THR   145      34.691  10.213  34.976  1.00 45.22           O  
ATOM   1117  CB  THR   145      36.637  10.071  37.272  1.00 43.99           C  
ATOM   1118  N   VAL   146      34.804   7.967  35.078  1.00 46.59           N  
ATOM   1119  CA  VAL   146      33.513   7.753  34.406  1.00 47.92           C  
ATOM   1120  C   VAL   146      32.374   7.775  35.425  1.00 49.33           C  
ATOM   1121  O   VAL   146      32.372   6.954  36.348  1.00 49.23           O  
ATOM   1122  CB  VAL   146      33.440   6.392  33.644  1.00 47.94           C  
ATOM   1123  CG1 VAL   146      32.086   6.219  32.986  1.00 47.64           C  
ATOM   1124  CG2 VAL   146      34.524   6.286  32.608  1.00 47.28           C  
ATOM   1125  N   PRO   147      31.418   8.721  35.280  1.00 50.94           N  
ATOM   1126  CA  PRO   147      30.191   8.590  36.084  1.00 52.30           C  
ATOM   1127  C   PRO   147      29.379   7.337  35.681  1.00 53.55           C  
ATOM   1128  O   PRO   147      29.364   6.959  34.504  1.00 54.31           O  
ATOM   1129  CB  PRO   147      29.432   9.895  35.801  1.00 52.10           C  
ATOM   1130  CG  PRO   147      30.019  10.431  34.537  1.00 51.92           C  
ATOM   1131  CD  PRO   147      31.418   9.940  34.447  1.00 50.72           C  
ATOM   1132  N   GLY   148      28.741   6.691  36.653  1.00 54.81           N  
ATOM   1133  CA  GLY   148      28.048   5.415  36.423  1.00 55.64           C  
ATOM   1134  C   GLY   148      26.796   5.497  35.556  1.00 56.25           C  
ATOM   1135  O   GLY   148      26.265   6.585  35.318  1.00 56.77           O  
ATOM   1136  N   VAL   149      26.355   4.333  35.066  1.00 56.83           N  
ATOM   1137  CA  VAL   149      25.069   4.165  34.366  1.00 57.00           C  
ATOM   1138  C   VAL   149      24.507   2.753  34.644  1.00 57.36           C  
ATOM   1139  O   VAL   149      25.260   1.768  34.683  1.00 57.45           O  
ATOM   1140  CB  VAL   149      25.194   4.411  32.825  1.00 56.97           C  
ATOM   1141  CG1 VAL   149      25.952   3.287  32.158  1.00 56.88           C  
ATOM   1142  CG2 VAL   149      23.807   4.585  32.169  1.00 56.07           C  
ATOM   1143  N   TYR   150      23.187   2.668  34.834  1.00 57.52           N  
ATOM   1144  CA  TYR   150      22.495   1.406  35.158  1.00 57.45           C  
ATOM   1145  C   TYR   150      23.080   0.739  36.395  1.00 57.47           C  
ATOM   1146  O   TYR   150      23.301   1.402  37.405  1.00 57.84           O  
ATOM   1147  CB  TYR   150      22.503   0.438  33.960  1.00 57.31           C  
ATOM   1148  CG  TYR   150      21.973   1.059  32.682  1.00 57.19           C  
ATOM   1149  CD1 TYR   150      20.797   1.825  32.692  1.00 57.44           C  
ATOM   1150  CD2 TYR   150      22.638   0.897  31.466  1.00 57.06           C  
ATOM   1151  CE1 TYR   150      20.301   2.411  31.534  1.00 56.37           C  
ATOM   1152  CE2 TYR   150      22.142   1.491  30.290  1.00 56.34           C  
ATOM   1153  CZ  TYR   150      20.975   2.243  30.345  1.00 56.39           C  
ATOM   1154  OH  TYR   150      20.455   2.825  29.223  1.00 56.70           O  
END
