
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  789),  selected   98 , name 2dcl_B
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 2dcl_B.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     2_B      -       -           -
LGA    E     3_B      M       1          0.502
LGA    V     4_B      S       2          0.974
LGA    E     5_B      K       3          3.272
LGA    H     6_B      R       4          3.402
LGA    W     7_B      -       -           -
LGA    N     8_B      -       -           -
LGA    T     9_B      A       5          0.830
LGA    L    10_B      N       6          0.938
LGA    R    11_B      K       7          1.021
LGA    L    12_B      L       8          0.979
LGA    R    13_B      V       9          0.943
LGA    I    14_B      I      10          0.806
LGA    Y    15_B      V      11          0.940
LGA    I    16_B      T      12          0.967
LGA    G    17_B      E      13          1.477
LGA    E    18_B      K      14          1.533
LGA    N    19_B      V      15          3.202
LGA    D    20_B      -       -           -
LGA    K    21_B      -       -           -
LGA    W    22_B      -       -           -
LGA    E    23_B      -       -           -
LGA    G    24_B      -       -           -
LGA    R    25_B      -       -           -
LGA    P    26_B      -       -           -
LGA    L    27_B      L      16          1.597
LGA    Y    28_B      L      17          1.763
LGA    K    29_B      K      18          0.709
LGA    V    30_B      K      19          0.965
LGA    I    31_B      V      20          1.075
LGA    V    32_B      A      21          0.477
LGA    E    33_B      K      22          1.173
LGA    K    34_B      I      23          2.065
LGA    L    35_B      I      24          1.589
LGA    R    36_B      E      25          1.399
LGA    E    37_B      E      26          2.356
LGA    M    38_B      A      27          2.330
LGA    G    39_B      G      28          1.387
LGA    I    40_B      A      29          1.052
LGA    A    41_B      T      30          2.326
LGA    G    42_B      G      31          1.207
LGA    A    43_B      Y      32          0.660
LGA    T    44_B      T      33          0.641
LGA    V    45_B      V      34          0.642
LGA    Y    46_B      V      35          0.440
LGA    R    47_B      D      36          0.338
LGA    G    48_B      T      37          1.496
LGA    I    49_B      -       -           -
LGA    Y    50_B      G      38          2.238
LGA    G    51_B      G      39          1.126
LGA    F    52_B      -       -           -
LGA    G    53_B      -       -           -
LGA    K    54_B      -       -           -
LGA    K    55_B      -       -           -
LGA    S    67_B      -       -           -
LGA    T    68_B      -       -           -
LGA    D    69_B      -       -           -
LGA    L    70_B      S      58          1.178
LGA    P    71_B      N      59          1.318
LGA    I    72_B      V      60          0.473
LGA    I    73_B      K      61          0.605
LGA    V    74_B      F      62          1.103
LGA    E    75_B      E      63          1.068
LGA    V    76_B      V      64          0.692
LGA    V    77_B      L      65          0.918
LGA    D    78_B      T      66          1.287
LGA    R    79_B      E      67          2.908
LGA    G    80_B      N      68          3.212
LGA    -       -      R      69           -
LGA    H    81_B      E      70          1.840
LGA    N    82_B      M      71          1.408
LGA    I    83_B      A      72          0.604
LGA    E    84_B      E      73          1.461
LGA    K    85_B      K      74          1.454
LGA    V    86_B      I      75          0.997
LGA    V    87_B      A      76          1.312
LGA    N    88_B      D      77          1.935
LGA    V    89_B      Q      78          1.503
LGA    I    90_B      V      79          1.373
LGA    K    91_B      A      80          1.392
LGA    P    92_B      I      81          1.274
LGA    M    93_B      K      82          2.282
LGA    I    94_B      F      83          2.608
LGA    K    95_B      F      84          2.037
LGA    -       -      T      85           -
LGA    -       -      D      86           -
LGA    D    96_B      Y      87          3.138
LGA    G    97_B      A      88          2.949
LGA    -       -      G      89           -
LGA    M    98_B      I      90          0.827
LGA    I    99_B      I      91          0.808
LGA    T   100_B      Y      92          1.372
LGA    V   101_B      I      93          1.148
LGA    E   102_B      C      94          1.633
LGA    P   103_B      E      95          0.858
LGA    T   104_B      A      96          1.044
LGA    I   105_B      E      97          0.618
LGA    V   106_B      V      98          0.659
LGA    L   107_B      L      99          0.699
LGA    W   108_B      Y     100          0.725
LGA    V   109_B      G     101          1.091
LGA    G   110_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   83    5.0     79    1.56    21.52     87.751     4.745

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.645583 * X  +   0.386971 * Y  +  -0.658389 * Z  + -64.541313
  Y_new =   0.560729 * X  +  -0.825472 * Y  +   0.064648 * Z  + -16.150080
  Z_new =  -0.518464 * X  +  -0.410913 * Y  +  -0.749897 * Z  + -32.435516 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.640317    0.501275  [ DEG:  -151.2790     28.7210 ]
  Theta =   0.545054    2.596539  [ DEG:    31.2293    148.7707 ]
  Phi   =   0.715172   -2.426420  [ DEG:    40.9764   -139.0237 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dcl_B                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dcl_B.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   83   5.0   79   1.56   21.52  87.751
REMARK  ---------------------------------------------------------- 
MOLECULE 2dcl_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   08-JAN-06   2DCL              
TITLE     STRUCTURE OF PH1503 PROTEIN FROM PYROCOCCUS HORIKOSHII OT3            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL UPF0166 PROTEIN PH1503;                       
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 GENE: PH1503;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    HEXAMER, X-RAY DIFFRACTION, STRUCTURAL GENOMICS, NPPSFA,              
KEYWDS   2 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   3 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   4 RSGI                                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.BAGAUTDINOV,N.KUNISHIMA,RIKEN STRUCTURAL                            
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   08-JUL-06 2DCL    0                                                
JRNL        AUTH   B.BAGAUTDINOV,N.KUNISHIMA                                    
JRNL        TITL   CRYSTAL STRUCTURE OF PH1503 PROTEIN FROM                     
JRNL        TITL 2 PYROCOCCUS HORIKOSHII OT3                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.28 ANGSTROMS.                                          
DBREF  2DCL A    1   127  UNP    O59172   Y1503_PYRHO      1    127             
DBREF  2DCL B    1   127  UNP    O59172   Y1503_PYRHO      1    127             
DBREF  2DCL C    1   127  UNP    O59172   Y1503_PYRHO      1    127             
SEQRES   1 A  127  MET VAL GLU VAL GLU HIS TRP ASN THR LEU ARG LEU ARG          
SEQRES   2 A  127  ILE TYR ILE GLY GLU ASN ASP LYS TRP GLU GLY ARG PRO          
SEQRES   3 A  127  LEU TYR LYS VAL ILE VAL GLU LYS LEU ARG GLU MET GLY          
SEQRES   4 A  127  ILE ALA GLY ALA THR VAL TYR ARG GLY ILE TYR GLY PHE          
SEQRES   5 A  127  GLY LYS LYS SER ARG VAL HIS SER SER ASP VAL ILE ARG          
SEQRES   6 A  127  LEU SER THR ASP LEU PRO ILE ILE VAL GLU VAL VAL ASP          
SEQRES   7 A  127  ARG GLY HIS ASN ILE GLU LYS VAL VAL ASN VAL ILE LYS          
SEQRES   8 A  127  PRO MET ILE LYS ASP GLY MET ILE THR VAL GLU PRO THR          
SEQRES   9 A  127  ILE VAL LEU TRP VAL GLY THR GLN GLU GLU ILE LYS LYS          
SEQRES  10 A  127  PHE GLU GLU ASP ALA ILE ALA GLU ARG GLN                      
SEQRES   1 B  127  MET VAL GLU VAL GLU HIS TRP ASN THR LEU ARG LEU ARG          
SEQRES   2 B  127  ILE TYR ILE GLY GLU ASN ASP LYS TRP GLU GLY ARG PRO          
SEQRES   3 B  127  LEU TYR LYS VAL ILE VAL GLU LYS LEU ARG GLU MET GLY          
SEQRES   4 B  127  ILE ALA GLY ALA THR VAL TYR ARG GLY ILE TYR GLY PHE          
SEQRES   5 B  127  GLY LYS LYS SER ARG VAL HIS SER SER ASP VAL ILE ARG          
SEQRES   6 B  127  LEU SER THR ASP LEU PRO ILE ILE VAL GLU VAL VAL ASP          
SEQRES   7 B  127  ARG GLY HIS ASN ILE GLU LYS VAL VAL ASN VAL ILE LYS          
SEQRES   8 B  127  PRO MET ILE LYS ASP GLY MET ILE THR VAL GLU PRO THR          
SEQRES   9 B  127  ILE VAL LEU TRP VAL GLY THR GLN GLU GLU ILE LYS LYS          
SEQRES  10 B  127  PHE GLU GLU ASP ALA ILE ALA GLU ARG GLN                      
SEQRES   1 C  127  MET VAL GLU VAL GLU HIS TRP ASN THR LEU ARG LEU ARG          
SEQRES   2 C  127  ILE TYR ILE GLY GLU ASN ASP LYS TRP GLU GLY ARG PRO          
SEQRES   3 C  127  LEU TYR LYS VAL ILE VAL GLU LYS LEU ARG GLU MET GLY          
SEQRES   4 C  127  ILE ALA GLY ALA THR VAL TYR ARG GLY ILE TYR GLY PHE          
SEQRES   5 C  127  GLY LYS LYS SER ARG VAL HIS SER SER ASP VAL ILE ARG          
SEQRES   6 C  127  LEU SER THR ASP LEU PRO ILE ILE VAL GLU VAL VAL ASP          
SEQRES   7 C  127  ARG GLY HIS ASN ILE GLU LYS VAL VAL ASN VAL ILE LYS          
SEQRES   8 C  127  PRO MET ILE LYS ASP GLY MET ILE THR VAL GLU PRO THR          
SEQRES   9 C  127  ILE VAL LEU TRP VAL GLY THR GLN GLU GLU ILE LYS LYS          
SEQRES  10 C  127  PHE GLU GLU ASP ALA ILE ALA GLU ARG GLN                      
HET    AMP    901      23                                                       
HET    AMP    902      23                                                       
HET    AMP    903      23                                                       
HETNAM     AMP ADENOSINE MONOPHOSPHATE                                          
FORMUL   4  AMP    3(C10 H14 N5 O7 P)                                           
FORMUL   7  HOH   *123(H2 O)                                                    
CRYST1  107.562   59.647   66.738  90.00 122.47  90.00 C 1 2 1      12          
ATOM    801  N   VAL B   2     -51.571   4.333   4.073  1.00 85.67           N  
ATOM    802  CA  VAL B   2     -50.173   3.840   4.101  1.00 85.70           C  
ATOM    803  C   VAL B   2     -49.956   2.899   2.910  1.00 85.44           C  
ATOM    804  O   VAL B   2     -48.969   3.028   2.183  1.00 85.38           O  
ATOM    805  CB  VAL B   2     -49.848   3.238   5.504  1.00 86.07           C  
ATOM    806  CG1 VAL B   2     -50.671   1.981   5.764  1.00 86.41           C  
ATOM    807  CG2 VAL B   2     -48.388   2.964   5.691  1.00 86.58           C  
ATOM    808  N   GLU B   3     -50.897   1.989   2.680  1.00 85.00           N  
ATOM    809  CA  GLU B   3     -50.819   1.044   1.569  1.00 84.74           C  
ATOM    810  C   GLU B   3     -51.074   1.724   0.210  1.00 83.63           C  
ATOM    811  O   GLU B   3     -52.120   2.341  -0.001  1.00 82.88           O  
ATOM    812  CB  GLU B   3     -51.842  -0.071   1.774  1.00 85.77           C  
ATOM    813  CG  GLU B   3     -53.280   0.416   1.846  1.00 88.70           C  
ATOM    814  CD  GLU B   3     -54.062  -0.173   3.004  1.00 90.54           C  
ATOM    815  OE1 GLU B   3     -53.704   0.081   4.167  1.00 91.40           O  
ATOM    816  OE2 GLU B   3     -55.054  -0.884   2.738  1.00 90.46           O  
ATOM    817  N   VAL B   4     -50.126   1.596  -0.717  1.00 82.55           N  
ATOM    818  CA  VAL B   4     -50.261   2.191  -2.047  1.00 82.83           C  
ATOM    819  C   VAL B   4     -49.686   1.279  -3.130  1.00 83.70           C  
ATOM    820  O   VAL B   4     -48.619   0.694  -2.949  1.00 83.10           O  
ATOM    821  CB  VAL B   4     -49.544   3.566  -2.140  1.00 81.68           C  
ATOM    822  CG1 VAL B   4     -50.115   4.525  -1.110  1.00 81.11           C  
ATOM    823  CG2 VAL B   4     -48.049   3.397  -1.935  1.00 80.92           C  
ATOM    824  N   GLU B   5     -50.391   1.163  -4.253  1.00 85.05           N  
ATOM    825  CA  GLU B   5     -49.919   0.324  -5.349  1.00 86.95           C  
ATOM    826  C   GLU B   5     -48.562   0.820  -5.838  1.00 87.12           C  
ATOM    827  O   GLU B   5     -47.615   0.041  -5.949  1.00 87.93           O  
ATOM    828  CB  GLU B   5     -50.922   0.330  -6.506  1.00 88.38           C  
ATOM    829  CG  GLU B   5     -52.254  -0.329  -6.185  1.00 90.74           C  
ATOM    830  CD  GLU B   5     -52.106  -1.774  -5.732  1.00 93.18           C  
ATOM    831  OE1 GLU B   5     -51.409  -2.555  -6.419  1.00 93.92           O  
ATOM    832  OE2 GLU B   5     -52.700  -2.128  -4.687  1.00 93.83           O  
ATOM    833  N   HIS B   6     -48.472   2.116  -6.124  1.00 85.94           N  
ATOM    834  CA  HIS B   6     -47.220   2.712  -6.583  1.00 85.29           C  
ATOM    835  C   HIS B   6     -47.135   4.195  -6.273  1.00 83.66           C  
ATOM    836  O   HIS B   6     -48.153   4.876  -6.124  1.00 83.77           O  
ATOM    837  CB  HIS B   6     -47.039   2.524  -8.092  1.00 87.15           C  
ATOM    838  CG  HIS B   6     -46.623   1.142  -8.487  1.00 88.64           C  
ATOM    839  ND1 HIS B   6     -47.521   0.112  -8.652  1.00 89.26           N  
ATOM    840  CD2 HIS B   6     -45.397   0.621  -8.730  1.00 88.73           C  
ATOM    841  CE1 HIS B   6     -46.865  -0.990  -8.981  1.00 89.50           C  
ATOM    842  NE2 HIS B   6     -45.578  -0.707  -9.035  1.00 89.74           N  
ATOM    843  N   TRP B   7     -45.906   4.692  -6.185  1.00 81.26           N  
ATOM    844  CA  TRP B   7     -45.684   6.102  -5.912  1.00 78.92           C  
ATOM    845  C   TRP B   7     -45.067   6.820  -7.111  1.00 77.03           C  
ATOM    846  O   TRP B   7     -44.773   8.014  -7.038  1.00 78.39           O  
ATOM    847  CB  TRP B   7     -44.801   6.287  -4.674  1.00 78.53           C  
ATOM    848  CG  TRP B   7     -43.594   5.409  -4.625  1.00 77.82           C  
ATOM    849  CD1 TRP B   7     -43.501   4.175  -4.047  1.00 78.12           C  
ATOM    850  CD2 TRP B   7     -42.295   5.702  -5.158  1.00 77.90           C  
ATOM    851  NE1 TRP B   7     -42.223   3.682  -4.183  1.00 77.81           N  
ATOM    852  CE2 TRP B   7     -41.462   4.598  -4.861  1.00 77.27           C  
ATOM    853  CE3 TRP B   7     -41.753   6.789  -5.856  1.00 76.97           C  
ATOM    854  CZ2 TRP B   7     -40.117   4.549  -5.238  1.00 77.16           C  
ATOM    855  CZ3 TRP B   7     -40.412   6.740  -6.232  1.00 76.86           C  
ATOM    856  CH2 TRP B   7     -39.611   5.627  -5.920  1.00 76.66           C  
ATOM    857  N   ASN B   8     -44.854   6.092  -8.206  1.00 72.92           N  
ATOM    858  CA  ASN B   8     -44.324   6.716  -9.411  1.00 68.82           C  
ATOM    859  C   ASN B   8     -45.318   6.513 -10.540  1.00 66.07           C  
ATOM    860  O   ASN B   8     -44.954   6.244 -11.687  1.00 64.79           O  
ATOM    861  CB  ASN B   8     -42.972   6.146  -9.820  1.00 68.90           C  
ATOM    862  CG  ASN B   8     -42.285   7.005 -10.876  1.00 69.46           C  
ATOM    863  OD1 ASN B   8     -42.618   8.172 -11.058  1.00 70.10           O  
ATOM    864  ND2 ASN B   8     -41.324   6.418 -11.585  1.00 70.74           N  
ATOM    865  N   THR B   9     -46.588   6.632 -10.189  1.00 63.04           N  
ATOM    866  CA  THR B   9     -47.656   6.502 -11.156  1.00 60.80           C  
ATOM    867  C   THR B   9     -47.837   7.867 -11.813  1.00 56.94           C  
ATOM    868  O   THR B   9     -47.579   8.899 -11.193  1.00 56.46           O  
ATOM    869  CB  THR B   9     -48.958   6.091 -10.463  1.00 61.91           C  
ATOM    870  OG1 THR B   9     -48.805   4.774  -9.917  1.00 64.60           O  
ATOM    871  CG2 THR B   9     -50.115   6.102 -11.441  1.00 63.10           C  
ATOM    872  N   LEU B  10     -48.258   7.870 -13.071  1.00 53.82           N  
ATOM    873  CA  LEU B  10     -48.482   9.118 -13.795  1.00 48.64           C  
ATOM    874  C   LEU B  10     -49.861   9.117 -14.418  1.00 46.75           C  
ATOM    875  O   LEU B  10     -50.366   8.073 -14.826  1.00 45.07           O  
ATOM    876  CB  LEU B  10     -47.444   9.291 -14.903  1.00 47.41           C  
ATOM    877  CG  LEU B  10     -45.981   9.544 -14.520  1.00 46.78           C  
ATOM    878  CD1 LEU B  10     -45.110   9.344 -15.756  1.00 46.47           C  
ATOM    879  CD2 LEU B  10     -45.808  10.961 -13.960  1.00 44.30           C  
ATOM    880  N   ARG B  11     -50.478  10.292 -14.473  1.00 46.20           N  
ATOM    881  CA  ARG B  11     -51.788  10.436 -15.099  1.00 44.08           C  
ATOM    882  C   ARG B  11     -51.552  11.095 -16.466  1.00 44.10           C  
ATOM    883  O   ARG B  11     -51.098  12.248 -16.557  1.00 42.06           O  
ATOM    884  CB  ARG B  11     -52.708  11.308 -14.236  1.00 43.51           C  
ATOM    885  CG  ARG B  11     -54.010  11.695 -14.929  1.00 45.67           C  
ATOM    886  CD  ARG B  11     -55.045  12.234 -13.957  1.00 45.80           C  
ATOM    887  NE  ARG B  11     -55.830  11.168 -13.340  1.00 47.35           N  
ATOM    888  CZ  ARG B  11     -55.855  10.900 -12.040  1.00 42.05           C  
ATOM    889  NH1 ARG B  11     -55.125  11.621 -11.204  1.00 42.52           N  
ATOM    890  NH2 ARG B  11     -56.637   9.933 -11.581  1.00 40.01           N  
ATOM    891  N   LEU B  12     -51.823  10.343 -17.526  1.00 43.24           N  
ATOM    892  CA  LEU B  12     -51.644  10.857 -18.879  1.00 42.50           C  
ATOM    893  C   LEU B  12     -53.005  11.244 -19.441  1.00 41.10           C  
ATOM    894  O   LEU B  12     -53.973  10.491 -19.327  1.00 38.74           O  
ATOM    895  CB  LEU B  12     -51.010   9.796 -19.782  1.00 43.28           C  
ATOM    896  CG  LEU B  12     -50.851  10.146 -21.271  1.00 44.03           C  
ATOM    897  CD1 LEU B  12     -49.626  11.036 -21.472  1.00 40.17           C  
ATOM    898  CD2 LEU B  12     -50.700   8.869 -22.073  1.00 44.48           C  
ATOM    899  N   ARG B  13     -53.084  12.433 -20.027  1.00 40.57           N  
ATOM    900  CA  ARG B  13     -54.340  12.888 -20.621  1.00 41.14           C  
ATOM    901  C   ARG B  13     -54.113  13.316 -22.073  1.00 40.03           C  
ATOM    902  O   ARG B  13     -53.240  14.132 -22.374  1.00 38.75           O  
ATOM    903  CB  ARG B  13     -54.950  14.023 -19.791  1.00 42.18           C  
ATOM    904  CG  ARG B  13     -55.912  13.513 -18.708  1.00 43.64           C  
ATOM    905  CD  ARG B  13     -56.492  14.611 -17.820  1.00 42.84           C  
ATOM    906  NE  ARG B  13     -55.548  14.991 -16.766  1.00 48.58           N  
ATOM    907  CZ  ARG B  13     -55.903  15.406 -15.549  1.00 47.79           C  
ATOM    908  NH1 ARG B  13     -57.188  15.496 -15.226  1.00 46.95           N  
ATOM    909  NH2 ARG B  13     -54.976  15.723 -14.653  1.00 47.96           N  
ATOM    910  N   ILE B  14     -54.904  12.721 -22.958  1.00 40.97           N  
ATOM    911  CA  ILE B  14     -54.831  12.957 -24.395  1.00 41.50           C  
ATOM    912  C   ILE B  14     -56.093  13.671 -24.847  1.00 39.28           C  
ATOM    913  O   ILE B  14     -57.178  13.110 -24.787  1.00 38.51           O  
ATOM    914  CB  ILE B  14     -54.733  11.608 -25.152  1.00 43.70           C  
ATOM    915  CG1 ILE B  14     -53.603  10.766 -24.547  1.00 43.71           C  
ATOM    916  CG2 ILE B  14     -54.489  11.845 -26.642  1.00 43.79           C  
ATOM    917  CD1 ILE B  14     -53.783   9.280 -24.738  1.00 44.45           C  
ATOM    918  N   TYR B  15     -55.942  14.908 -25.298  1.00 38.38           N  
ATOM    919  CA  TYR B  15     -57.081  15.692 -25.755  1.00 39.06           C  
ATOM    920  C   TYR B  15     -57.149  15.788 -27.289  1.00 39.89           C  
ATOM    921  O   TYR B  15     -56.243  16.332 -27.928  1.00 39.23           O  
ATOM    922  CB  TYR B  15     -57.002  17.111 -25.191  1.00 41.05           C  
ATOM    923  CG  TYR B  15     -57.002  17.219 -23.679  1.00 43.46           C  
ATOM    924  CD1 TYR B  15     -55.892  16.828 -22.927  1.00 41.75           C  
ATOM    925  CD2 TYR B  15     -58.103  17.759 -23.003  1.00 43.66           C  
ATOM    926  CE1 TYR B  15     -55.879  16.976 -21.548  1.00 43.79           C  
ATOM    927  CE2 TYR B  15     -58.099  17.913 -21.620  1.00 42.79           C  
ATOM    928  CZ  TYR B  15     -56.983  17.520 -20.897  1.00 44.90           C  
ATOM    929  OH  TYR B  15     -56.980  17.681 -19.533  1.00 41.85           O  
ATOM    930  N   ILE B  16     -58.228  15.274 -27.867  1.00 40.06           N  
ATOM    931  CA  ILE B  16     -58.433  15.337 -29.314  1.00 42.26           C  
ATOM    932  C   ILE B  16     -59.896  15.627 -29.618  1.00 42.92           C  
ATOM    933  O   ILE B  16     -60.733  15.619 -28.714  1.00 44.31           O  
ATOM    934  CB  ILE B  16     -58.066  14.010 -30.004  1.00 42.65           C  
ATOM    935  CG1 ILE B  16     -58.599  12.842 -29.172  1.00 43.01           C  
ATOM    936  CG2 ILE B  16     -56.568  13.947 -30.241  1.00 40.81           C  
ATOM    937  CD1 ILE B  16     -58.331  11.501 -29.762  1.00 47.45           C  
ATOM    938  N   GLY B  17     -60.193  15.882 -30.892  1.00 42.83           N  
ATOM    939  CA  GLY B  17     -61.550  16.149 -31.301  1.00 39.52           C  
ATOM    940  C   GLY B  17     -62.216  14.843 -31.612  1.00 40.82           C  
ATOM    941  O   GLY B  17     -61.571  13.867 -31.998  1.00 43.02           O  
ATOM    942  N   GLU B  18     -63.526  14.812 -31.463  1.00 43.41           N  
ATOM    943  CA  GLU B  18     -64.254  13.588 -31.727  1.00 45.90           C  
ATOM    944  C   GLU B  18     -64.251  13.188 -33.198  1.00 49.67           C  
ATOM    945  O   GLU B  18     -64.395  12.022 -33.537  1.00 50.97           O  
ATOM    946  CB  GLU B  18     -65.691  13.733 -31.252  1.00 43.82           C  
ATOM    947  CG  GLU B  18     -66.468  12.451 -31.262  1.00 44.30           C  
ATOM    948  CD  GLU B  18     -67.868  12.714 -30.792  1.00 43.98           C  
ATOM    949  OE1 GLU B  18     -68.212  13.849 -30.467  1.00 47.82           O  
ATOM    950  OE2 GLU B  18     -68.644  11.736 -30.760  1.00 46.04           O  
ATOM    951  N   ASN B  19     -64.080  14.157 -34.084  1.00 51.98           N  
ATOM    952  CA  ASN B  19     -64.087  13.846 -35.509  1.00 54.09           C  
ATOM    953  C   ASN B  19     -62.701  13.621 -36.067  1.00 53.74           C  
ATOM    954  O   ASN B  19     -62.544  13.247 -37.228  1.00 54.55           O  
ATOM    955  CB  ASN B  19     -64.796  14.944 -36.237  1.00 56.21           C  
ATOM    956  CG  ASN B  19     -66.220  15.035 -35.817  1.00 58.80           C  
ATOM    957  OD1 ASN B  19     -66.981  14.056 -35.754  1.00 64.06           O  
ATOM    958  ND2 ASN B  19     -66.603  16.255 -35.486  1.00 61.23           N  
ATOM    959  N   ASP B  20     -61.686  13.857 -35.241  1.00 52.58           N  
ATOM    960  CA  ASP B  20     -60.325  13.643 -35.693  1.00 52.33           C  
ATOM    961  C   ASP B  20     -60.285  12.216 -36.211  1.00 52.21           C  
ATOM    962  O   ASP B  20     -60.948  11.334 -35.660  1.00 50.23           O  
ATOM    963  CB  ASP B  20     -59.345  13.819 -34.534  1.00 53.55           C  
ATOM    964  CG  ASP B  20     -59.256  15.257 -34.065  1.00 54.12           C  
ATOM    965  OD1 ASP B  20     -58.412  15.556 -33.208  1.00 55.29           O  
ATOM    966  OD2 ASP B  20     -60.040  16.087 -34.559  1.00 52.50           O  
ATOM    967  N   LYS B  21     -59.534  11.987 -37.286  1.00 52.40           N  
ATOM    968  CA  LYS B  21     -59.467  10.648 -37.853  1.00 52.11           C  
ATOM    969  C   LYS B  21     -58.065  10.153 -38.147  1.00 51.16           C  
ATOM    970  O   LYS B  21     -57.121  10.926 -38.255  1.00 49.71           O  
ATOM    971  CB  LYS B  21     -60.364  10.585 -39.104  1.00 53.93           C  
ATOM    972  CG  LYS B  21     -61.836  10.587 -38.699  1.00 56.80           C  
ATOM    973  CD  LYS B  21     -62.899  10.785 -39.782  1.00 60.24           C  
ATOM    974  CE  LYS B  21     -64.232  11.057 -39.056  1.00 61.65           C  
ATOM    975  NZ  LYS B  21     -65.497  11.141 -39.836  1.00 65.90           N  
ATOM    976  N   TRP B  22     -57.939   8.834 -38.232  1.00 52.70           N  
ATOM    977  CA  TRP B  22     -56.672   8.185 -38.540  1.00 54.00           C  
ATOM    978  C   TRP B  22     -57.009   7.066 -39.506  1.00 53.70           C  
ATOM    979  O   TRP B  22     -57.722   6.123 -39.155  1.00 53.31           O  
ATOM    980  CB  TRP B  22     -56.019   7.616 -37.278  1.00 56.06           C  
ATOM    981  CG  TRP B  22     -54.658   7.035 -37.542  1.00 59.78           C  
ATOM    982  CD1 TRP B  22     -54.326   5.713 -37.606  1.00 60.08           C  
ATOM    983  CD2 TRP B  22     -53.457   7.766 -37.829  1.00 61.70           C  
ATOM    984  NE1 TRP B  22     -52.992   5.574 -37.919  1.00 62.33           N  
ATOM    985  CE2 TRP B  22     -52.437   6.819 -38.064  1.00 62.28           C  
ATOM    986  CE3 TRP B  22     -53.145   9.133 -37.917  1.00 63.23           C  
ATOM    987  CZ2 TRP B  22     -51.123   7.189 -38.377  1.00 64.34           C  
ATOM    988  CZ3 TRP B  22     -51.839   9.504 -38.228  1.00 63.97           C  
ATOM    989  CH2 TRP B  22     -50.843   8.532 -38.456  1.00 65.48           C  
ATOM    990  N   GLU B  23     -56.517   7.180 -40.735  1.00 54.86           N  
ATOM    991  CA  GLU B  23     -56.796   6.179 -41.763  1.00 53.78           C  
ATOM    992  C   GLU B  23     -58.302   5.934 -41.874  1.00 51.59           C  
ATOM    993  O   GLU B  23     -58.745   4.803 -42.034  1.00 52.66           O  
ATOM    994  CB  GLU B  23     -56.022   4.873 -41.466  1.00 57.12           C  
ATOM    995  CG  GLU B  23     -54.481   5.074 -41.539  1.00 62.21           C  
ATOM    996  CD  GLU B  23     -53.624   3.886 -41.111  1.00 67.06           C  
ATOM    997  OE1 GLU B  23     -54.084   2.981 -40.385  1.00 69.65           O  
ATOM    998  OE2 GLU B  23     -52.433   3.892 -41.489  1.00 68.49           O  
ATOM    999  N   GLY B  24     -59.094   7.001 -41.779  1.00 50.46           N  
ATOM   1000  CA  GLY B  24     -60.536   6.845 -41.900  1.00 50.12           C  
ATOM   1001  C   GLY B  24     -61.342   6.464 -40.669  1.00 51.79           C  
ATOM   1002  O   GLY B  24     -62.572   6.586 -40.677  1.00 53.27           O  
ATOM   1003  N   ARG B  25     -60.673   5.993 -39.617  1.00 51.75           N  
ATOM   1004  CA  ARG B  25     -61.359   5.611 -38.370  1.00 50.28           C  
ATOM   1005  C   ARG B  25     -61.231   6.744 -37.334  1.00 45.86           C  
ATOM   1006  O   ARG B  25     -60.318   7.568 -37.411  1.00 43.76           O  
ATOM   1007  CB  ARG B  25     -60.729   4.352 -37.735  1.00 54.75           C  
ATOM   1008  CG  ARG B  25     -60.802   3.014 -38.467  1.00 57.84           C  
ATOM   1009  CD  ARG B  25     -60.525   1.847 -37.494  1.00 64.29           C  
ATOM   1010  NE  ARG B  25     -61.690   1.581 -36.664  1.00 68.68           N  
ATOM   1011  CZ  ARG B  25     -61.689   1.299 -35.361  1.00 70.75           C  
ATOM   1012  NH1 ARG B  25     -60.563   1.227 -34.654  1.00 73.06           N  
ATOM   1013  NH2 ARG B  25     -62.846   1.084 -34.752  1.00 70.94           N  
ATOM   1014  N   PRO B  26     -62.150   6.807 -36.354  1.00 45.34           N  
ATOM   1015  CA  PRO B  26     -62.106   7.845 -35.302  1.00 44.29           C  
ATOM   1016  C   PRO B  26     -60.784   7.700 -34.541  1.00 43.19           C  
ATOM   1017  O   PRO B  26     -60.488   6.638 -34.019  1.00 42.63           O  
ATOM   1018  CB  PRO B  26     -63.311   7.501 -34.434  1.00 44.81           C  
ATOM   1019  CG  PRO B  26     -64.293   6.940 -35.472  1.00 44.77           C  
ATOM   1020  CD  PRO B  26     -63.414   6.050 -36.297  1.00 43.92           C  
ATOM   1021  N   LEU B  27     -59.989   8.761 -34.504  1.00 42.68           N  
ATOM   1022  CA  LEU B  27     -58.686   8.728 -33.852  1.00 45.03           C  
ATOM   1023  C   LEU B  27     -58.683   8.197 -32.417  1.00 45.91           C  
ATOM   1024  O   LEU B  27     -57.758   7.485 -32.017  1.00 45.24           O  
ATOM   1025  CB  LEU B  27     -58.081  10.129 -33.858  1.00 44.31           C  
ATOM   1026  CG  LEU B  27     -56.703  10.440 -33.266  1.00 46.80           C  
ATOM   1027  CD1 LEU B  27     -55.709   9.444 -33.884  1.00 47.39           C  
ATOM   1028  CD2 LEU B  27     -56.226  11.854 -33.499  1.00 47.81           C  
ATOM   1029  N   TYR B  28     -59.704   8.538 -31.638  1.00 46.14           N  
ATOM   1030  CA  TYR B  28     -59.713   8.101 -30.257  1.00 47.12           C  
ATOM   1031  C   TYR B  28     -59.926   6.614 -30.142  1.00 48.31           C  
ATOM   1032  O   TYR B  28     -59.363   5.978 -29.263  1.00 49.13           O  
ATOM   1033  CB  TYR B  28     -60.753   8.876 -29.433  1.00 43.96           C  
ATOM   1034  CG  TYR B  28     -62.190   8.480 -29.623  1.00 42.18           C  
ATOM   1035  CD1 TYR B  28     -62.742   7.422 -28.899  1.00 43.53           C  
ATOM   1036  CD2 TYR B  28     -63.022   9.203 -30.466  1.00 41.99           C  
ATOM   1037  CE1 TYR B  28     -64.086   7.105 -29.002  1.00 40.32           C  
ATOM   1038  CE2 TYR B  28     -64.376   8.888 -30.576  1.00 42.57           C  
ATOM   1039  CZ  TYR B  28     -64.899   7.839 -29.834  1.00 41.44           C  
ATOM   1040  OH  TYR B  28     -66.242   7.555 -29.909  1.00 40.37           O  
ATOM   1041  N   LYS B  29     -60.725   6.049 -31.039  1.00 50.20           N  
ATOM   1042  CA  LYS B  29     -60.952   4.618 -30.984  1.00 51.17           C  
ATOM   1043  C   LYS B  29     -59.636   3.892 -31.328  1.00 53.03           C  
ATOM   1044  O   LYS B  29     -59.286   2.927 -30.663  1.00 53.74           O  
ATOM   1045  CB  LYS B  29     -62.065   4.212 -31.936  1.00 52.32           C  
ATOM   1046  CG  LYS B  29     -63.422   4.807 -31.578  1.00 53.69           C  
ATOM   1047  CD  LYS B  29     -64.502   4.303 -32.516  1.00 57.68           C  
ATOM   1048  CE  LYS B  29     -65.838   4.991 -32.263  1.00 58.82           C  
ATOM   1049  NZ  LYS B  29     -66.940   4.356 -33.050  1.00 61.23           N  
ATOM   1050  N   VAL B  30     -58.911   4.367 -32.350  1.00 53.96           N  
ATOM   1051  CA  VAL B  30     -57.642   3.738 -32.699  1.00 54.45           C  
ATOM   1052  C   VAL B  30     -56.693   3.819 -31.523  1.00 54.18           C  
ATOM   1053  O   VAL B  30     -55.980   2.869 -31.210  1.00 53.83           O  
ATOM   1054  CB  VAL B  30     -56.871   4.397 -33.869  1.00 53.79           C  
ATOM   1055  CG1 VAL B  30     -55.585   3.635 -34.150  1.00 55.01           C  
ATOM   1056  CG2 VAL B  30     -57.731   4.460 -35.116  1.00 55.38           C  
ATOM   1057  N   ILE B  31     -56.657   4.983 -30.889  1.00 55.24           N  
ATOM   1058  CA  ILE B  31     -55.781   5.182 -29.751  1.00 55.39           C  
ATOM   1059  C   ILE B  31     -56.101   4.190 -28.639  1.00 55.73           C  
ATOM   1060  O   ILE B  31     -55.203   3.524 -28.113  1.00 54.67           O  
ATOM   1061  CB  ILE B  31     -55.878   6.613 -29.203  1.00 54.36           C  
ATOM   1062  CG1 ILE B  31     -55.247   7.586 -30.198  1.00 55.73           C  
ATOM   1063  CG2 ILE B  31     -55.163   6.715 -27.875  1.00 54.38           C  
ATOM   1064  CD1 ILE B  31     -55.212   9.028 -29.718  1.00 56.30           C  
ATOM   1065  N   VAL B  32     -57.379   4.082 -28.297  1.00 56.06           N  
ATOM   1066  CA  VAL B  32     -57.824   3.177 -27.247  1.00 59.93           C  
ATOM   1067  C   VAL B  32     -57.558   1.735 -27.640  1.00 62.79           C  
ATOM   1068  O   VAL B  32     -57.321   0.872 -26.790  1.00 63.87           O  
ATOM   1069  CB  VAL B  32     -59.329   3.355 -26.967  1.00 58.66           C  
ATOM   1070  CG1 VAL B  32     -59.853   2.182 -26.167  1.00 60.58           C  
ATOM   1071  CG2 VAL B  32     -59.550   4.641 -26.201  1.00 57.90           C  
ATOM   1072  N   GLU B  33     -57.597   1.489 -28.944  1.00 66.40           N  
ATOM   1073  CA  GLU B  33     -57.369   0.160 -29.503  1.00 68.19           C  
ATOM   1074  C   GLU B  33     -55.920  -0.263 -29.279  1.00 68.42           C  
ATOM   1075  O   GLU B  33     -55.653  -1.397 -28.879  1.00 69.89           O  
ATOM   1076  CB  GLU B  33     -57.668   0.170 -31.001  1.00 71.20           C  
ATOM   1077  CG  GLU B  33     -58.511  -0.989 -31.510  1.00 74.50           C  
ATOM   1078  CD  GLU B  33     -58.493  -1.030 -33.020  1.00 77.25           C  
ATOM   1079  OE1 GLU B  33     -58.517   0.023 -33.665  1.00 77.52           O  
ATOM   1080  OE2 GLU B  33     -58.448  -2.157 -33.563  1.00 78.01           O  
ATOM   1081  N   LYS B  34     -54.999   0.665 -29.537  1.00 68.17           N  
ATOM   1082  CA  LYS B  34     -53.572   0.416 -29.379  1.00 69.46           C  
ATOM   1083  C   LYS B  34     -53.228   0.162 -27.903  1.00 70.25           C  
ATOM   1084  O   LYS B  34     -52.499  -0.774 -27.579  1.00 70.25           O  
ATOM   1085  CB  LYS B  34     -52.773   1.618 -29.906  1.00 71.09           C  
ATOM   1086  CG  LYS B  34     -52.147   1.464 -31.299  1.00 73.39           C  
ATOM   1087  CD  LYS B  34     -50.781   0.805 -31.196  1.00 74.73           C  
ATOM   1088  CE  LYS B  34     -50.106   0.449 -32.514  1.00 76.10           C  
ATOM   1089  NZ  LYS B  34     -48.752  -0.061 -32.158  1.00 77.30           N  
ATOM   1090  N   LEU B  35     -53.771   0.993 -27.014  1.00 70.85           N  
ATOM   1091  CA  LEU B  35     -53.533   0.860 -25.576  1.00 71.14           C  
ATOM   1092  C   LEU B  35     -53.904  -0.542 -25.108  1.00 72.34           C  
ATOM   1093  O   LEU B  35     -53.243  -1.120 -24.253  1.00 70.65           O  
ATOM   1094  CB  LEU B  35     -54.367   1.884 -24.802  1.00 69.20           C  
ATOM   1095  CG  LEU B  35     -54.184   3.364 -25.158  1.00 67.99           C  
ATOM   1096  CD1 LEU B  35     -55.171   4.213 -24.366  1.00 65.75           C  
ATOM   1097  CD2 LEU B  35     -52.757   3.790 -24.875  1.00 65.68           C  
ATOM   1098  N   ARG B  36     -54.975  -1.071 -25.683  1.00 74.99           N  
ATOM   1099  CA  ARG B  36     -55.468  -2.395 -25.346  1.00 78.71           C  
ATOM   1100  C   ARG B  36     -54.471  -3.491 -25.738  1.00 80.25           C  
ATOM   1101  O   ARG B  36     -54.144  -4.365 -24.933  1.00 80.68           O  
ATOM   1102  CB  ARG B  36     -56.803  -2.624 -26.051  1.00 79.84           C  
ATOM   1103  CG  ARG B  36     -57.926  -3.079 -25.140  1.00 84.02           C  
ATOM   1104  CD  ARG B  36     -59.265  -2.976 -25.853  1.00 87.30           C  
ATOM   1105  NE  ARG B  36     -60.387  -3.397 -25.015  1.00 90.38           N  
ATOM   1106  CZ  ARG B  36     -60.769  -4.660 -24.841  1.00 92.24           C  
ATOM   1107  NH1 ARG B  36     -60.119  -5.645 -25.449  1.00 93.37           N  
ATOM   1108  NH2 ARG B  36     -61.808  -4.938 -24.065  1.00 93.32           N  
ATOM   1109  N   GLU B  37     -53.982  -3.438 -26.973  1.00 81.55           N  
ATOM   1110  CA  GLU B  37     -53.042  -4.443 -27.454  1.00 82.89           C  
ATOM   1111  C   GLU B  37     -51.621  -4.153 -26.986  1.00 83.10           C  
ATOM   1112  O   GLU B  37     -50.681  -4.853 -27.362  1.00 83.58           O  
ATOM   1113  CB  GLU B  37     -53.077  -4.522 -28.982  1.00 83.46           C  
ATOM   1114  CG  GLU B  37     -52.244  -3.466 -29.681  1.00 84.46           C  
ATOM   1115  CD  GLU B  37     -52.279  -3.605 -31.186  1.00 85.33           C  
ATOM   1116  OE1 GLU B  37     -53.334  -3.311 -31.790  1.00 84.94           O  
ATOM   1117  OE2 GLU B  37     -51.250  -4.015 -31.764  1.00 86.03           O  
ATOM   1118  N   MET B  38     -51.465  -3.113 -26.176  1.00 82.72           N  
ATOM   1119  CA  MET B  38     -50.154  -2.755 -25.651  1.00 82.13           C  
ATOM   1120  C   MET B  38     -49.993  -3.261 -24.226  1.00 81.23           C  
ATOM   1121  O   MET B  38     -48.895  -3.240 -23.670  1.00 81.34           O  
ATOM   1122  CB  MET B  38     -49.958  -1.241 -25.676  1.00 83.30           C  
ATOM   1123  CG  MET B  38     -49.419  -0.696 -26.977  1.00 85.15           C  
ATOM   1124  SD  MET B  38     -48.924   1.177 -26.826  1.00 86.47           S  
ATOM   1125  CE  MET B  38     -49.406   1.714 -28.606  1.00 88.22           C  
ATOM   1126  N   GLY B  39     -51.094  -3.711 -23.632  1.00 80.26           N  
ATOM   1127  CA  GLY B  39     -51.048  -4.222 -22.274  1.00 78.59           C  
ATOM   1128  C   GLY B  39     -50.956  -3.145 -21.207  1.00 77.79           C  
ATOM   1129  O   GLY B  39     -50.331  -3.346 -20.161  1.00 76.76           O  
ATOM   1130  N   ILE B  40     -51.574  -1.998 -21.476  1.00 76.37           N  
ATOM   1131  CA  ILE B  40     -51.579  -0.887 -20.533  1.00 74.03           C  
ATOM   1132  C   ILE B  40     -52.601  -1.147 -19.429  1.00 72.15           C  
ATOM   1133  O   ILE B  40     -53.632  -1.775 -19.658  1.00 71.40           O  
ATOM   1134  CB  ILE B  40     -51.890   0.457 -21.255  1.00 75.20           C  
ATOM   1135  CG1 ILE B  40     -50.599   1.049 -21.831  1.00 75.48           C  
ATOM   1136  CG2 ILE B  40     -52.505   1.463 -20.290  1.00 75.67           C  
ATOM   1137  CD1 ILE B  40     -49.880   0.152 -22.802  1.00 74.49           C  
ATOM   1138  N   ALA B  41     -52.298  -0.661 -18.230  1.00 70.89           N  
ATOM   1139  CA  ALA B  41     -53.161  -0.846 -17.068  1.00 70.26           C  
ATOM   1140  C   ALA B  41     -54.644  -0.667 -17.364  1.00 69.31           C  
ATOM   1141  O   ALA B  41     -55.453  -1.545 -17.062  1.00 71.19           O  
ATOM   1142  CB  ALA B  41     -52.733   0.105 -15.949  1.00 69.51           C  
ATOM   1143  N   GLY B  42     -55.002   0.471 -17.947  1.00 66.96           N  
ATOM   1144  CA  GLY B  42     -56.396   0.729 -18.260  1.00 62.93           C  
ATOM   1145  C   GLY B  42     -56.565   2.120 -18.829  1.00 59.15           C  
ATOM   1146  O   GLY B  42     -55.579   2.814 -19.063  1.00 59.24           O  
ATOM   1147  N   ALA B  43     -57.806   2.538 -19.049  1.00 55.92           N  
ATOM   1148  CA  ALA B  43     -58.054   3.865 -19.599  1.00 52.42           C  
ATOM   1149  C   ALA B  43     -59.502   4.291 -19.460  1.00 50.59           C  
ATOM   1150  O   ALA B  43     -60.407   3.459 -19.425  1.00 50.70           O  
ATOM   1151  CB  ALA B  43     -57.654   3.902 -21.074  1.00 52.57           C  
ATOM   1152  N   THR B  44     -59.717   5.599 -19.370  1.00 48.51           N  
ATOM   1153  CA  THR B  44     -61.070   6.130 -19.281  1.00 46.36           C  
ATOM   1154  C   THR B  44     -61.198   7.223 -20.334  1.00 44.87           C  
ATOM   1155  O   THR B  44     -60.328   8.090 -20.455  1.00 44.19           O  
ATOM   1156  CB  THR B  44     -61.370   6.693 -17.873  1.00 46.60           C  
ATOM   1157  OG1 THR B  44     -61.135   5.667 -16.900  1.00 48.76           O  
ATOM   1158  CG2 THR B  44     -62.841   7.119 -17.761  1.00 44.11           C  
ATOM   1159  N   VAL B  45     -62.274   7.163 -21.114  1.00 45.21           N  
ATOM   1160  CA  VAL B  45     -62.503   8.144 -22.168  1.00 44.43           C  
ATOM   1161  C   VAL B  45     -63.677   9.029 -21.812  1.00 43.66           C  
ATOM   1162  O   VAL B  45     -64.761   8.541 -21.491  1.00 41.09           O  
ATOM   1163  CB  VAL B  45     -62.827   7.474 -23.528  1.00 44.68           C  
ATOM   1164  CG1 VAL B  45     -62.866   8.542 -24.631  1.00 44.87           C  
ATOM   1165  CG2 VAL B  45     -61.790   6.403 -23.856  1.00 41.75           C  
ATOM   1166  N   TYR B  46     -63.460  10.336 -21.875  1.00 43.52           N  
ATOM   1167  CA  TYR B  46     -64.528  11.269 -21.568  1.00 43.97           C  
ATOM   1168  C   TYR B  46     -64.805  12.106 -22.795  1.00 44.00           C  
ATOM   1169  O   TYR B  46     -63.909  12.343 -23.609  1.00 43.68           O  
ATOM   1170  CB  TYR B  46     -64.131  12.246 -20.456  1.00 46.49           C  
ATOM   1171  CG  TYR B  46     -63.513  11.655 -19.218  1.00 46.59           C  
ATOM   1172  CD1 TYR B  46     -62.133  11.524 -19.105  1.00 48.01           C  
ATOM   1173  CD2 TYR B  46     -64.304  11.290 -18.129  1.00 47.44           C  
ATOM   1174  CE1 TYR B  46     -61.551  11.057 -17.928  1.00 49.69           C  
ATOM   1175  CE2 TYR B  46     -63.732  10.818 -16.950  1.00 50.38           C  
ATOM   1176  CZ  TYR B  46     -62.355  10.710 -16.856  1.00 49.54           C  
ATOM   1177  OH  TYR B  46     -61.783  10.293 -15.679  1.00 51.84           O  
ATOM   1178  N   ARG B  47     -66.045  12.565 -22.912  1.00 43.62           N  
ATOM   1179  CA  ARG B  47     -66.420  13.439 -24.008  1.00 42.84           C  
ATOM   1180  C   ARG B  47     -66.899  14.766 -23.431  1.00 40.95           C  
ATOM   1181  O   ARG B  47     -67.885  14.803 -22.702  1.00 39.24           O  
ATOM   1182  CB  ARG B  47     -67.547  12.843 -24.848  1.00 44.64           C  
ATOM   1183  CG  ARG B  47     -68.093  13.842 -25.879  1.00 46.93           C  
ATOM   1184  CD  ARG B  47     -69.418  13.376 -26.452  1.00 50.21           C  
ATOM   1185  NE  ARG B  47     -69.238  12.211 -27.301  1.00 53.38           N  
ATOM   1186  CZ  ARG B  47     -70.113  11.223 -27.393  1.00 54.55           C  
ATOM   1187  NH1 ARG B  47     -71.234  11.263 -26.686  1.00 55.65           N  
ATOM   1188  NH2 ARG B  47     -69.859  10.194 -28.190  1.00 56.53           N  
ATOM   1189  N   GLY B  48     -66.209  15.850 -23.762  1.00 38.92           N  
ATOM   1190  CA  GLY B  48     -66.631  17.151 -23.275  1.00 40.98           C  
ATOM   1191  C   GLY B  48     -67.897  17.637 -23.972  1.00 39.85           C  
ATOM   1192  O   GLY B  48     -68.408  16.964 -24.863  1.00 40.43           O  
ATOM   1193  N   ILE B  49     -68.429  18.786 -23.565  1.00 39.03           N  
ATOM   1194  CA  ILE B  49     -69.624  19.303 -24.214  1.00 40.71           C  
ATOM   1195  C   ILE B  49     -69.201  20.487 -25.056  1.00 41.64           C  
ATOM   1196  O   ILE B  49     -69.961  20.988 -25.865  1.00 42.86           O  
ATOM   1197  CB  ILE B  49     -70.719  19.756 -23.212  1.00 39.03           C  
ATOM   1198  CG1 ILE B  49     -70.161  20.820 -22.269  1.00 40.47           C  
ATOM   1199  CG2 ILE B  49     -71.251  18.558 -22.440  1.00 38.04           C  
ATOM   1200  CD1 ILE B  49     -71.231  21.447 -21.365  1.00 41.40           C  
ATOM   1201  N   TYR B  50     -67.966  20.915 -24.852  1.00 43.20           N  
ATOM   1202  CA  TYR B  50     -67.388  22.009 -25.600  1.00 44.90           C  
ATOM   1203  C   TYR B  50     -65.905  22.093 -25.301  1.00 45.82           C  
ATOM   1204  O   TYR B  50     -65.459  21.676 -24.236  1.00 46.74           O  
ATOM   1205  CB  TYR B  50     -68.032  23.341 -25.235  1.00 48.11           C  
ATOM   1206  CG  TYR B  50     -67.421  24.478 -26.015  1.00 49.93           C  
ATOM   1207  CD1 TYR B  50     -67.725  24.664 -27.363  1.00 53.05           C  
ATOM   1208  CD2 TYR B  50     -66.495  25.329 -25.427  1.00 53.41           C  
ATOM   1209  CE1 TYR B  50     -67.118  25.673 -28.108  1.00 56.18           C  
ATOM   1210  CE2 TYR B  50     -65.880  26.342 -26.162  1.00 56.32           C  
ATOM   1211  CZ  TYR B  50     -66.195  26.509 -27.501  1.00 57.09           C  
ATOM   1212  OH  TYR B  50     -65.587  27.510 -28.228  1.00 60.66           O  
ATOM   1213  N   GLY B  51     -65.146  22.630 -26.253  1.00 47.05           N  
ATOM   1214  CA  GLY B  51     -63.717  22.792 -26.079  1.00 46.91           C  
ATOM   1215  C   GLY B  51     -63.136  23.656 -27.181  1.00 46.92           C  
ATOM   1216  O   GLY B  51     -63.788  23.910 -28.190  1.00 46.89           O  
ATOM   1217  N   PHE B  52     -61.911  24.127 -26.984  1.00 47.07           N  
ATOM   1218  CA  PHE B  52     -61.232  24.938 -27.983  1.00 48.07           C  
ATOM   1219  C   PHE B  52     -59.762  24.939 -27.626  1.00 51.81           C  
ATOM   1220  O   PHE B  52     -59.405  24.909 -26.445  1.00 52.25           O  
ATOM   1221  CB  PHE B  52     -61.795  26.377 -28.012  1.00 45.32           C  
ATOM   1222  CG  PHE B  52     -61.033  27.364 -27.145  1.00 44.18           C  
ATOM   1223  CD1 PHE B  52     -59.810  27.884 -27.561  1.00 40.97           C  
ATOM   1224  CD2 PHE B  52     -61.552  27.780 -25.916  1.00 43.92           C  
ATOM   1225  CE1 PHE B  52     -59.106  28.776 -26.763  1.00 43.94           C  
ATOM   1226  CE2 PHE B  52     -60.856  28.678 -25.108  1.00 42.45           C  
ATOM   1227  CZ  PHE B  52     -59.636  29.184 -25.531  1.00 44.01           C  
ATOM   1228  N   GLY B  53     -58.909  24.954 -28.645  1.00 55.77           N  
ATOM   1229  CA  GLY B  53     -57.481  24.983 -28.410  1.00 60.28           C  
ATOM   1230  C   GLY B  53     -56.897  25.990 -29.384  1.00 65.25           C  
ATOM   1231  O   GLY B  53     -57.076  25.848 -30.596  1.00 66.80           O  
ATOM   1232  N   LYS B  54     -56.220  27.014 -28.862  1.00 69.11           N  
ATOM   1233  CA  LYS B  54     -55.596  28.023 -29.718  1.00 72.62           C  
ATOM   1234  C   LYS B  54     -54.773  27.243 -30.744  1.00 75.22           C  
ATOM   1235  O   LYS B  54     -54.665  27.633 -31.910  1.00 76.69           O  
ATOM   1236  CB  LYS B  54     -54.645  28.926 -28.909  1.00 73.02           C  
ATOM   1237  CG  LYS B  54     -53.313  28.262 -28.537  1.00 74.33           C  
ATOM   1238  CD  LYS B  54     -52.303  29.269 -27.992  1.00 74.68           C  
ATOM   1239  CE  LYS B  54     -51.019  28.600 -27.493  1.00 73.99           C  
ATOM   1240  NZ  LYS B  54     -49.957  28.473 -28.533  1.00 74.77           N  
ATOM   1241  N   LYS B  55     -54.205  26.131 -30.281  1.00 77.55           N  
ATOM   1242  CA  LYS B  55     -53.406  25.237 -31.113  1.00 79.18           C  
ATOM   1243  C   LYS B  55     -53.458  23.826 -30.527  1.00 78.72           C  
ATOM   1244  O   LYS B  55     -52.962  22.871 -31.124  1.00 79.21           O  
ATOM   1245  CB  LYS B  55     -51.952  25.716 -31.179  1.00 80.32           C  
ATOM   1246  CG  LYS B  55     -51.070  24.875 -32.099  1.00 80.89           C  
ATOM   1247  CD  LYS B  55     -49.629  25.360 -32.115  1.00 81.23           C  
ATOM   1248  CE  LYS B  55     -48.755  24.431 -32.956  1.00 82.11           C  
ATOM   1249  NZ  LYS B  55     -47.332  24.877 -33.016  1.00 81.16           N  
ATOM   1250  N   SER B  67     -68.571  24.859 -32.515  1.00 82.78           N  
ATOM   1251  CA  SER B  67     -67.786  23.650 -32.294  1.00 83.08           C  
ATOM   1252  C   SER B  67     -68.589  22.380 -32.573  1.00 82.69           C  
ATOM   1253  O   SER B  67     -69.295  21.867 -31.695  1.00 82.77           O  
ATOM   1254  CB  SER B  67     -67.262  23.615 -30.855  1.00 84.15           C  
ATOM   1255  OG  SER B  67     -66.499  22.441 -30.617  1.00 86.10           O  
ATOM   1256  N   THR B  68     -68.477  21.886 -33.802  1.00 80.53           N  
ATOM   1257  CA  THR B  68     -69.164  20.669 -34.223  1.00 77.72           C  
ATOM   1258  C   THR B  68     -68.296  19.467 -33.848  1.00 75.84           C  
ATOM   1259  O   THR B  68     -68.665  18.317 -34.091  1.00 76.46           O  
ATOM   1260  CB  THR B  68     -69.368  20.654 -35.751  1.00 77.86           C  
ATOM   1261  OG1 THR B  68     -70.004  19.430 -36.146  1.00 77.80           O  
ATOM   1262  CG2 THR B  68     -68.027  20.767 -36.456  1.00 77.10           C  
ATOM   1263  N   ASP B  69     -67.143  19.745 -33.251  1.00 71.71           N  
ATOM   1264  CA  ASP B  69     -66.202  18.701 -32.872  1.00 67.56           C  
ATOM   1265  C   ASP B  69     -65.982  18.668 -31.355  1.00 63.83           C  
ATOM   1266  O   ASP B  69     -65.065  19.300 -30.827  1.00 63.14           O  
ATOM   1267  CB  ASP B  69     -64.880  18.937 -33.620  1.00 66.91           C  
ATOM   1268  CG  ASP B  69     -63.922  17.773 -33.514  1.00 67.26           C  
ATOM   1269  OD1 ASP B  69     -64.400  16.636 -33.314  1.00 66.48           O  
ATOM   1270  OD2 ASP B  69     -62.696  17.995 -33.647  1.00 66.52           O  
ATOM   1271  N   LEU B  70     -66.839  17.931 -30.658  1.00 58.90           N  
ATOM   1272  CA  LEU B  70     -66.745  17.800 -29.206  1.00 53.11           C  
ATOM   1273  C   LEU B  70     -65.387  17.242 -28.792  1.00 50.35           C  
ATOM   1274  O   LEU B  70     -64.790  16.433 -29.507  1.00 47.85           O  
ATOM   1275  CB  LEU B  70     -67.865  16.874 -28.684  1.00 51.71           C  
ATOM   1276  CG  LEU B  70     -69.342  17.307 -28.653  1.00 50.93           C  
ATOM   1277  CD1 LEU B  70     -70.160  16.354 -27.807  1.00 51.01           C  
ATOM   1278  CD2 LEU B  70     -69.508  18.730 -28.139  1.00 50.72           C  
ATOM   1279  N   PRO B  71     -64.887  17.659 -27.615  1.00 47.38           N  
ATOM   1280  CA  PRO B  71     -63.591  17.178 -27.123  1.00 44.30           C  
ATOM   1281  C   PRO B  71     -63.695  15.754 -26.584  1.00 42.82           C  
ATOM   1282  O   PRO B  71     -64.690  15.411 -25.974  1.00 42.29           O  
ATOM   1283  CB  PRO B  71     -63.259  18.150 -25.989  1.00 43.21           C  
ATOM   1284  CG  PRO B  71     -64.249  19.298 -26.157  1.00 42.61           C  
ATOM   1285  CD  PRO B  71     -65.467  18.633 -26.676  1.00 44.05           C  
ATOM   1286  N   ILE B  72     -62.690  14.918 -26.848  1.00 44.68           N  
ATOM   1287  CA  ILE B  72     -62.667  13.562 -26.282  1.00 44.14           C  
ATOM   1288  C   ILE B  72     -61.362  13.541 -25.524  1.00 43.03           C  
ATOM   1289  O   ILE B  72     -60.337  14.002 -26.018  1.00 40.12           O  
ATOM   1290  CB  ILE B  72     -62.652  12.344 -27.260  1.00 45.68           C  
ATOM   1291  CG1 ILE B  72     -64.044  12.076 -27.862  1.00 46.20           C  
ATOM   1292  CG2 ILE B  72     -62.220  11.084 -26.469  1.00 46.88           C  
ATOM   1293  CD1 ILE B  72     -64.723  10.781 -27.456  1.00 50.81           C  
ATOM   1294  N   ILE B  73     -61.404  13.027 -24.304  1.00 43.50           N  
ATOM   1295  CA  ILE B  73     -60.197  12.961 -23.513  1.00 43.18           C  
ATOM   1296  C   ILE B  73     -59.946  11.511 -23.131  1.00 43.82           C  
ATOM   1297  O   ILE B  73     -60.817  10.834 -22.569  1.00 43.25           O  
ATOM   1298  CB  ILE B  73     -60.311  13.848 -22.240  1.00 42.02           C  
ATOM   1299  CG1 ILE B  73     -60.603  15.302 -22.632  1.00 41.13           C  
ATOM   1300  CG2 ILE B  73     -59.009  13.814 -21.460  1.00 39.94           C  
ATOM   1301  CD1 ILE B  73     -62.047  15.573 -23.063  1.00 39.11           C  
ATOM   1302  N   VAL B  74     -58.767  11.025 -23.496  1.00 43.14           N  
ATOM   1303  CA  VAL B  74     -58.386   9.664 -23.171  1.00 42.85           C  
ATOM   1304  C   VAL B  74     -57.419   9.806 -22.009  1.00 41.84           C  
ATOM   1305  O   VAL B  74     -56.395  10.488 -22.114  1.00 37.22           O  
ATOM   1306  CB  VAL B  74     -57.679   8.949 -24.359  1.00 43.98           C  
ATOM   1307  CG1 VAL B  74     -57.238   7.556 -23.921  1.00 43.01           C  
ATOM   1308  CG2 VAL B  74     -58.620   8.850 -25.559  1.00 42.53           C  
ATOM   1309  N   GLU B  75     -57.766   9.177 -20.893  1.00 42.35           N  
ATOM   1310  CA  GLU B  75     -56.951   9.251 -19.682  1.00 42.32           C  
ATOM   1311  C   GLU B  75     -56.379   7.891 -19.318  1.00 40.20           C  
ATOM   1312  O   GLU B  75     -57.087   6.887 -19.318  1.00 38.17           O  
ATOM   1313  CB  GLU B  75     -57.808   9.781 -18.521  1.00 42.71           C  
ATOM   1314  CG  GLU B  75     -57.147   9.665 -17.154  1.00 44.11           C  
ATOM   1315  CD  GLU B  75     -58.066  10.094 -16.031  1.00 44.32           C  
ATOM   1316  OE1 GLU B  75     -59.147   9.501 -15.877  1.00 42.75           O  
ATOM   1317  OE2 GLU B  75     -57.695  11.030 -15.301  1.00 46.81           O  
ATOM   1318  N   VAL B  76     -55.095   7.861 -19.007  1.00 41.32           N  
ATOM   1319  CA  VAL B  76     -54.471   6.608 -18.620  1.00 44.52           C  
ATOM   1320  C   VAL B  76     -53.577   6.773 -17.397  1.00 45.30           C  
ATOM   1321  O   VAL B  76     -52.681   7.618 -17.374  1.00 45.56           O  
ATOM   1322  CB  VAL B  76     -53.632   6.038 -19.770  1.00 45.15           C  
ATOM   1323  CG1 VAL B  76     -54.494   5.891 -21.025  1.00 46.11           C  
ATOM   1324  CG2 VAL B  76     -52.450   6.935 -20.040  1.00 47.23           C  
ATOM   1325  N   VAL B  77     -53.826   5.965 -16.375  1.00 45.79           N  
ATOM   1326  CA  VAL B  77     -53.012   6.013 -15.166  1.00 47.02           C  
ATOM   1327  C   VAL B  77     -52.129   4.767 -15.157  1.00 49.04           C  
ATOM   1328  O   VAL B  77     -52.633   3.647 -15.179  1.00 48.82           O  
ATOM   1329  CB  VAL B  77     -53.898   6.041 -13.899  1.00 44.38           C  
ATOM   1330  CG1 VAL B  77     -53.032   6.056 -12.669  1.00 43.02           C  
ATOM   1331  CG2 VAL B  77     -54.795   7.275 -13.914  1.00 45.05           C  
ATOM   1332  N   ASP B  78     -50.815   4.957 -15.135  1.00 51.84           N  
ATOM   1333  CA  ASP B  78     -49.911   3.816 -15.142  1.00 57.39           C  
ATOM   1334  C   ASP B  78     -48.515   4.200 -14.663  1.00 60.32           C  
ATOM   1335  O   ASP B  78     -48.256   5.350 -14.299  1.00 60.46           O  
ATOM   1336  CB  ASP B  78     -49.821   3.242 -16.562  1.00 59.12           C  
ATOM   1337  CG  ASP B  78     -49.492   1.757 -16.580  1.00 60.26           C  
ATOM   1338  OD1 ASP B  78     -48.498   1.351 -15.951  1.00 63.35           O  
ATOM   1339  OD2 ASP B  78     -50.226   0.988 -17.234  1.00 60.99           O  
ATOM   1340  N   ARG B  79     -47.621   3.219 -14.663  1.00 62.88           N  
ATOM   1341  CA  ARG B  79     -46.239   3.430 -14.257  1.00 66.19           C  
ATOM   1342  C   ARG B  79     -45.606   4.364 -15.282  1.00 66.34           C  
ATOM   1343  O   ARG B  79     -46.046   4.427 -16.427  1.00 65.73           O  
ATOM   1344  CB  ARG B  79     -45.487   2.099 -14.247  1.00 68.91           C  
ATOM   1345  CG  ARG B  79     -46.002   1.060 -13.259  1.00 71.78           C  
ATOM   1346  CD  ARG B  79     -45.573  -0.339 -13.706  1.00 76.32           C  
ATOM   1347  NE  ARG B  79     -45.321  -1.260 -12.601  1.00 78.88           N  
ATOM   1348  CZ  ARG B  79     -44.251  -1.206 -11.812  1.00 81.33           C  
ATOM   1349  NH1 ARG B  79     -43.328  -0.270 -12.004  1.00 82.10           N  
ATOM   1350  NH2 ARG B  79     -44.092  -2.097 -10.840  1.00 82.75           N  
ATOM   1351  N   GLY B  80     -44.565   5.074 -14.869  1.00 68.01           N  
ATOM   1352  CA  GLY B  80     -43.900   6.004 -15.758  1.00 70.33           C  
ATOM   1353  C   GLY B  80     -43.443   5.453 -17.095  1.00 73.29           C  
ATOM   1354  O   GLY B  80     -43.751   6.031 -18.139  1.00 73.08           O  
ATOM   1355  N   HIS B  81     -42.708   4.344 -17.076  1.00 75.59           N  
ATOM   1356  CA  HIS B  81     -42.199   3.753 -18.310  1.00 77.20           C  
ATOM   1357  C   HIS B  81     -43.313   3.404 -19.293  1.00 76.75           C  
ATOM   1358  O   HIS B  81     -43.211   3.704 -20.483  1.00 77.07           O  
ATOM   1359  CB  HIS B  81     -41.369   2.500 -18.008  1.00 80.11           C  
ATOM   1360  CG  HIS B  81     -40.348   2.190 -19.059  1.00 82.46           C  
ATOM   1361  ND1 HIS B  81     -39.240   2.983 -19.275  1.00 83.53           N  
ATOM   1362  CD2 HIS B  81     -40.274   1.187 -19.965  1.00 83.29           C  
ATOM   1363  CE1 HIS B  81     -38.529   2.481 -20.268  1.00 84.05           C  
ATOM   1364  NE2 HIS B  81     -39.135   1.391 -20.706  1.00 84.37           N  
ATOM   1365  N   ASN B  82     -44.369   2.764 -18.798  1.00 75.77           N  
ATOM   1366  CA  ASN B  82     -45.500   2.400 -19.647  1.00 75.53           C  
ATOM   1367  C   ASN B  82     -46.060   3.636 -20.354  1.00 74.83           C  
ATOM   1368  O   ASN B  82     -46.299   3.619 -21.565  1.00 74.66           O  
ATOM   1369  CB  ASN B  82     -46.604   1.744 -18.815  1.00 76.51           C  
ATOM   1370  CG  ASN B  82     -46.298   0.296 -18.471  1.00 77.30           C  
ATOM   1371  OD1 ASN B  82     -45.239  -0.017 -17.930  1.00 79.56           O  
ATOM   1372  ND2 ASN B  82     -47.234  -0.595 -18.778  1.00 77.49           N  
ATOM   1373  N   ILE B  83     -46.265   4.708 -19.591  1.00 73.70           N  
ATOM   1374  CA  ILE B  83     -46.791   5.952 -20.142  1.00 72.67           C  
ATOM   1375  C   ILE B  83     -45.831   6.569 -21.165  1.00 72.82           C  
ATOM   1376  O   ILE B  83     -46.269   7.216 -22.115  1.00 72.25           O  
ATOM   1377  CB  ILE B  83     -47.091   6.976 -19.013  1.00 71.35           C  
ATOM   1378  CG1 ILE B  83     -48.186   6.437 -18.086  1.00 70.75           C  
ATOM   1379  CG2 ILE B  83     -47.522   8.306 -19.604  1.00 70.13           C  
ATOM   1380  CD1 ILE B  83     -49.520   6.124 -18.722  1.00 70.67           C  
ATOM   1381  N   GLU B  84     -44.528   6.360 -20.985  1.00 73.90           N  
ATOM   1382  CA  GLU B  84     -43.558   6.894 -21.940  1.00 74.98           C  
ATOM   1383  C   GLU B  84     -43.723   6.165 -23.273  1.00 75.51           C  
ATOM   1384  O   GLU B  84     -43.642   6.772 -24.342  1.00 76.35           O  
ATOM   1385  CB  GLU B  84     -42.121   6.710 -21.444  1.00 75.50           C  
ATOM   1386  CG  GLU B  84     -41.081   7.154 -22.475  1.00 77.73           C  
ATOM   1387  CD  GLU B  84     -39.665   6.737 -22.127  1.00 79.05           C  
ATOM   1388  OE1 GLU B  84     -39.433   5.528 -21.910  1.00 79.67           O  
ATOM   1389  OE2 GLU B  84     -38.782   7.621 -22.083  1.00 79.85           O  
ATOM   1390  N   LYS B  85     -43.947   4.854 -23.199  1.00 75.16           N  
ATOM   1391  CA  LYS B  85     -44.140   4.036 -24.391  1.00 74.55           C  
ATOM   1392  C   LYS B  85     -45.311   4.609 -25.176  1.00 72.80           C  
ATOM   1393  O   LYS B  85     -45.191   4.939 -26.355  1.00 72.31           O  
ATOM   1394  CB  LYS B  85     -44.462   2.579 -24.009  1.00 77.24           C  
ATOM   1395  CG  LYS B  85     -43.310   1.754 -23.419  1.00 79.59           C  
ATOM   1396  CD  LYS B  85     -43.806   0.396 -22.916  1.00 81.10           C  
ATOM   1397  CE  LYS B  85     -44.349  -0.510 -24.000  1.00 82.55           C  
ATOM   1398  NZ  LYS B  85     -45.677  -1.101 -23.723  1.00 84.18           N  
ATOM   1399  N   VAL B  86     -46.443   4.722 -24.487  1.00 71.20           N  
ATOM   1400  CA  VAL B  86     -47.684   5.230 -25.055  1.00 69.37           C  
ATOM   1401  C   VAL B  86     -47.540   6.558 -25.790  1.00 69.22           C  
ATOM   1402  O   VAL B  86     -48.043   6.720 -26.897  1.00 68.11           O  
ATOM   1403  CB  VAL B  86     -48.744   5.384 -23.956  1.00 68.58           C  
ATOM   1404  CG1 VAL B  86     -50.006   6.001 -24.532  1.00 69.25           C  
ATOM   1405  CG2 VAL B  86     -49.048   4.028 -23.345  1.00 66.27           C  
ATOM   1406  N   VAL B  87     -46.865   7.511 -25.159  1.00 69.98           N  
ATOM   1407  CA  VAL B  87     -46.661   8.818 -25.764  1.00 70.63           C  
ATOM   1408  C   VAL B  87     -45.901   8.668 -27.070  1.00 71.36           C  
ATOM   1409  O   VAL B  87     -46.249   9.288 -28.076  1.00 71.34           O  
ATOM   1410  CB  VAL B  87     -45.846   9.739 -24.848  1.00 70.27           C  
ATOM   1411  CG1 VAL B  87     -45.723  11.117 -25.484  1.00 70.16           C  
ATOM   1412  CG2 VAL B  87     -46.493   9.823 -23.482  1.00 71.49           C  
ATOM   1413  N   ASN B  88     -44.856   7.846 -27.034  1.00 72.35           N  
ATOM   1414  CA  ASN B  88     -44.016   7.589 -28.200  1.00 73.82           C  
ATOM   1415  C   ASN B  88     -44.795   6.958 -29.354  1.00 73.71           C  
ATOM   1416  O   ASN B  88     -44.467   7.187 -30.515  1.00 74.49           O  
ATOM   1417  CB  ASN B  88     -42.832   6.694 -27.803  1.00 74.77           C  
ATOM   1418  CG  ASN B  88     -41.773   7.444 -27.005  1.00 75.70           C  
ATOM   1419  OD1 ASN B  88     -41.707   8.674 -27.045  1.00 75.99           O  
ATOM   1420  ND2 ASN B  88     -40.947   6.703 -26.269  1.00 74.81           N  
ATOM   1421  N   VAL B  89     -45.832   6.186 -29.038  1.00 73.38           N  
ATOM   1422  CA  VAL B  89     -46.660   5.540 -30.066  1.00 73.39           C  
ATOM   1423  C   VAL B  89     -47.695   6.486 -30.626  1.00 74.23           C  
ATOM   1424  O   VAL B  89     -47.942   6.518 -31.830  1.00 74.76           O  
ATOM   1425  CB  VAL B  89     -47.541   4.399 -29.535  1.00 72.43           C  
ATOM   1426  CG1 VAL B  89     -48.656   4.117 -30.569  1.00 72.84           C  
ATOM   1427  CG2 VAL B  89     -46.748   3.177 -29.278  1.00 72.56           C  
ATOM   1428  N   ILE B  90     -48.319   7.236 -29.724  1.00 73.85           N  
ATOM   1429  CA  ILE B  90     -49.410   8.128 -30.079  1.00 73.11           C  
ATOM   1430  C   ILE B  90     -49.054   9.519 -30.589  1.00 73.38           C  
ATOM   1431  O   ILE B  90     -49.865  10.143 -31.263  1.00 71.38           O  
ATOM   1432  CB  ILE B  90     -50.374   8.226 -28.879  1.00 72.74           C  
ATOM   1433  CG1 ILE B  90     -50.715   6.811 -28.392  1.00 71.84           C  
ATOM   1434  CG2 ILE B  90     -51.648   8.928 -29.286  1.00 73.14           C  
ATOM   1435  CD1 ILE B  90     -51.705   6.763 -27.263  1.00 73.23           C  
ATOM   1436  N   LYS B  91     -47.852  10.001 -30.291  1.00 74.80           N  
ATOM   1437  CA  LYS B  91     -47.455  11.330 -30.742  1.00 77.35           C  
ATOM   1438  C   LYS B  91     -47.641  11.545 -32.245  1.00 79.29           C  
ATOM   1439  O   LYS B  91     -48.149  12.583 -32.666  1.00 79.74           O  
ATOM   1440  CB  LYS B  91     -46.001  11.614 -30.347  1.00 78.27           C  
ATOM   1441  CG  LYS B  91     -45.865  12.732 -29.323  1.00 79.45           C  
ATOM   1442  CD  LYS B  91     -44.549  12.671 -28.569  1.00 80.99           C  
ATOM   1443  CE  LYS B  91     -43.445  13.515 -29.156  1.00 81.67           C  
ATOM   1444  NZ  LYS B  91     -42.336  13.520 -28.181  1.00 82.96           N  
ATOM   1445  N   PRO B  92     -47.246  10.564 -33.073  1.00 80.51           N  
ATOM   1446  CA  PRO B  92     -47.388  10.694 -34.528  1.00 80.91           C  
ATOM   1447  C   PRO B  92     -48.833  10.834 -34.999  1.00 80.55           C  
ATOM   1448  O   PRO B  92     -49.123  11.600 -35.922  1.00 81.24           O  
ATOM   1449  CB  PRO B  92     -46.749   9.410 -35.053  1.00 82.17           C  
ATOM   1450  CG  PRO B  92     -45.743   9.066 -33.993  1.00 82.07           C  
ATOM   1451  CD  PRO B  92     -46.526   9.324 -32.734  1.00 81.21           C  
ATOM   1452  N   MET B  93     -49.730  10.088 -34.362  1.00 79.34           N  
ATOM   1453  CA  MET B  93     -51.148  10.092 -34.714  1.00 78.59           C  
ATOM   1454  C   MET B  93     -51.902  11.368 -34.364  1.00 77.73           C  
ATOM   1455  O   MET B  93     -53.015  11.581 -34.840  1.00 78.11           O  
ATOM   1456  CB  MET B  93     -51.866   8.931 -34.028  1.00 78.43           C  
ATOM   1457  CG  MET B  93     -51.382   7.551 -34.405  1.00 79.12           C  
ATOM   1458  SD  MET B  93     -52.410   6.211 -33.469  1.00 79.81           S  
ATOM   1459  CE  MET B  93     -51.101   5.702 -32.150  1.00 78.36           C  
ATOM   1460  N   ILE B  94     -51.310  12.220 -33.540  1.00 76.86           N  
ATOM   1461  CA  ILE B  94     -51.997  13.435 -33.127  1.00 76.44           C  
ATOM   1462  C   ILE B  94     -51.389  14.730 -33.656  1.00 76.18           C  
ATOM   1463  O   ILE B  94     -50.334  15.159 -33.197  1.00 76.73           O  
ATOM   1464  CB  ILE B  94     -52.084  13.479 -31.581  1.00 76.58           C  
ATOM   1465  CG1 ILE B  94     -52.838  12.236 -31.090  1.00 76.34           C  
ATOM   1466  CG2 ILE B  94     -52.763  14.769 -31.119  1.00 75.60           C  
ATOM   1467  CD1 ILE B  94     -52.874  12.049 -29.597  1.00 77.35           C  
ATOM   1468  N   LYS B  95     -52.063  15.348 -34.623  1.00 76.01           N  
ATOM   1469  CA  LYS B  95     -51.583  16.603 -35.189  1.00 75.94           C  
ATOM   1470  C   LYS B  95     -52.344  17.789 -34.600  1.00 74.89           C  
ATOM   1471  O   LYS B  95     -51.911  18.931 -34.723  1.00 74.61           O  
ATOM   1472  CB  LYS B  95     -51.715  16.627 -36.722  1.00 77.45           C  
ATOM   1473  CG  LYS B  95     -50.660  15.842 -37.510  1.00 78.66           C  
ATOM   1474  CD  LYS B  95     -49.246  15.941 -36.953  1.00 80.29           C  
ATOM   1475  CE  LYS B  95     -48.575  17.291 -37.080  1.00 81.63           C  
ATOM   1476  NZ  LYS B  95     -47.413  17.233 -36.157  1.00 81.94           N  
ATOM   1477  N   ASP B  96     -53.476  17.521 -33.959  1.00 73.75           N  
ATOM   1478  CA  ASP B  96     -54.247  18.593 -33.351  1.00 72.92           C  
ATOM   1479  C   ASP B  96     -54.925  18.127 -32.061  1.00 71.08           C  
ATOM   1480  O   ASP B  96     -55.881  17.342 -32.081  1.00 71.28           O  
ATOM   1481  CB  ASP B  96     -55.278  19.136 -34.347  1.00 75.08           C  
ATOM   1482  CG  ASP B  96     -55.289  20.664 -34.403  1.00 77.49           C  
ATOM   1483  OD1 ASP B  96     -54.197  21.271 -34.493  1.00 78.48           O  
ATOM   1484  OD2 ASP B  96     -56.388  21.259 -34.368  1.00 78.78           O  
ATOM   1485  N   GLY B  97     -54.403  18.628 -30.944  1.00 66.49           N  
ATOM   1486  CA  GLY B  97     -54.910  18.290 -29.626  1.00 61.30           C  
ATOM   1487  C   GLY B  97     -53.801  18.544 -28.619  1.00 57.42           C  
ATOM   1488  O   GLY B  97     -52.911  19.359 -28.873  1.00 57.73           O  
ATOM   1489  N   MET B  98     -53.835  17.872 -27.475  1.00 52.93           N  
ATOM   1490  CA  MET B  98     -52.774  18.075 -26.492  1.00 49.11           C  
ATOM   1491  C   MET B  98     -52.559  16.878 -25.580  1.00 47.25           C  
ATOM   1492  O   MET B  98     -53.460  16.068 -25.352  1.00 45.73           O  
ATOM   1493  CB  MET B  98     -53.010  19.370 -25.681  1.00 46.93           C  
ATOM   1494  CG  MET B  98     -53.574  19.249 -24.263  1.00 45.62           C  
ATOM   1495  SD  MET B  98     -53.433  20.974 -23.255  1.00 34.45           S  
ATOM   1496  CE  MET B  98     -54.822  20.690 -22.031  1.00 39.27           C  
ATOM   1497  N   ILE B  99     -51.332  16.762 -25.088  1.00 47.46           N  
ATOM   1498  CA  ILE B  99     -50.952  15.664 -24.213  1.00 45.77           C  
ATOM   1499  C   ILE B  99     -50.349  16.211 -22.927  1.00 41.99           C  
ATOM   1500  O   ILE B  99     -49.316  16.875 -22.947  1.00 39.53           O  
ATOM   1501  CB  ILE B  99     -49.923  14.727 -24.917  1.00 45.78           C  
ATOM   1502  CG1 ILE B  99     -50.505  14.226 -26.245  1.00 48.06           C  
ATOM   1503  CG2 ILE B  99     -49.609  13.537 -24.037  1.00 41.91           C  
ATOM   1504  CD1 ILE B  99     -49.560  13.332 -27.042  1.00 48.33           C  
ATOM   1505  N   THR B 100     -51.012  15.941 -21.808  1.00 42.28           N  
ATOM   1506  CA  THR B 100     -50.502  16.405 -20.523  1.00 40.69           C  
ATOM   1507  C   THR B 100     -50.201  15.205 -19.639  1.00 42.68           C  
ATOM   1508  O   THR B 100     -50.720  14.102 -19.846  1.00 42.32           O  
ATOM   1509  CB  THR B 100     -51.505  17.341 -19.786  1.00 37.86           C  
ATOM   1510  OG1 THR B 100     -52.616  16.581 -19.284  1.00 32.29           O  
ATOM   1511  CG2 THR B 100     -52.025  18.428 -20.745  1.00 35.37           C  
ATOM   1512  N   VAL B 101     -49.348  15.433 -18.654  1.00 44.34           N  
ATOM   1513  CA  VAL B 101     -48.970  14.380 -17.737  1.00 44.56           C  
ATOM   1514  C   VAL B 101     -48.495  15.000 -16.429  1.00 43.35           C  
ATOM   1515  O   VAL B 101     -47.794  16.016 -16.426  1.00 40.59           O  
ATOM   1516  CB  VAL B 101     -47.833  13.497 -18.353  1.00 44.91           C  
ATOM   1517  CG1 VAL B 101     -46.538  14.287 -18.418  1.00 41.78           C  
ATOM   1518  CG2 VAL B 101     -47.648  12.223 -17.543  1.00 46.45           C  
ATOM   1519  N   GLU B 102     -48.930  14.403 -15.321  1.00 44.51           N  
ATOM   1520  CA  GLU B 102     -48.508  14.825 -13.984  1.00 44.81           C  
ATOM   1521  C   GLU B 102     -48.613  13.605 -13.066  1.00 43.46           C  
ATOM   1522  O   GLU B 102     -49.355  12.660 -13.353  1.00 43.05           O  
ATOM   1523  CB  GLU B 102     -49.349  16.004 -13.446  1.00 43.26           C  
ATOM   1524  CG  GLU B 102     -50.760  15.700 -12.977  1.00 43.30           C  
ATOM   1525  CD  GLU B 102     -51.707  15.433 -14.124  1.00 44.87           C  
ATOM   1526  OE1 GLU B 102     -51.451  15.953 -15.224  1.00 44.26           O  
ATOM   1527  OE2 GLU B 102     -52.712  14.713 -13.926  1.00 46.81           O  
ATOM   1528  N   PRO B 103     -47.849  13.594 -11.964  1.00 44.10           N  
ATOM   1529  CA  PRO B 103     -47.882  12.459 -11.035  1.00 43.43           C  
ATOM   1530  C   PRO B 103     -49.194  12.279 -10.297  1.00 44.05           C  
ATOM   1531  O   PRO B 103     -49.992  13.205 -10.153  1.00 45.64           O  
ATOM   1532  CB  PRO B 103     -46.739  12.764 -10.068  1.00 41.93           C  
ATOM   1533  CG  PRO B 103     -45.791  13.583 -10.897  1.00 43.85           C  
ATOM   1534  CD  PRO B 103     -46.742  14.507 -11.630  1.00 43.39           C  
ATOM   1535  N   THR B 104     -49.416  11.064  -9.834  1.00 43.96           N  
ATOM   1536  CA  THR B 104     -50.604  10.785  -9.053  1.00 44.33           C  
ATOM   1537  C   THR B 104     -50.328   9.538  -8.224  1.00 45.88           C  
ATOM   1538  O   THR B 104     -49.424   8.763  -8.545  1.00 45.02           O  
ATOM   1539  CB  THR B 104     -51.840  10.575  -9.940  1.00 43.16           C  
ATOM   1540  OG1 THR B 104     -53.004  10.554  -9.114  1.00 38.58           O  
ATOM   1541  CG2 THR B 104     -51.752   9.256 -10.713  1.00 44.06           C  
ATOM   1542  N   ILE B 105     -51.089   9.351  -7.152  1.00 47.23           N  
ATOM   1543  CA  ILE B 105     -50.900   8.182  -6.304  1.00 49.29           C  
ATOM   1544  C   ILE B 105     -52.084   7.236  -6.421  1.00 49.53           C  
ATOM   1545  O   ILE B 105     -53.230   7.632  -6.218  1.00 49.55           O  
ATOM   1546  CB  ILE B 105     -50.689   8.600  -4.832  1.00 49.05           C  
ATOM   1547  CG1 ILE B 105     -49.363   9.347  -4.708  1.00 49.32           C  
ATOM   1548  CG2 ILE B 105     -50.708   7.374  -3.924  1.00 50.15           C  
ATOM   1549  CD1 ILE B 105     -49.111   9.953  -3.351  1.00 49.68           C  
ATOM   1550  N   VAL B 106     -51.789   5.993  -6.781  1.00 51.54           N  
ATOM   1551  CA  VAL B 106     -52.807   4.962  -6.914  1.00 53.69           C  
ATOM   1552  C   VAL B 106     -52.916   4.239  -5.572  1.00 55.98           C  
ATOM   1553  O   VAL B 106     -51.933   3.713  -5.067  1.00 55.12           O  
ATOM   1554  CB  VAL B 106     -52.407   3.938  -8.002  1.00 53.35           C  
ATOM   1555  CG1 VAL B 106     -53.452   2.851  -8.117  1.00 50.64           C  
ATOM   1556  CG2 VAL B 106     -52.229   4.649  -9.320  1.00 53.99           C  
ATOM   1557  N   LEU B 107     -54.105   4.219  -4.991  1.00 60.26           N  
ATOM   1558  CA  LEU B 107     -54.279   3.571  -3.700  1.00 66.15           C  
ATOM   1559  C   LEU B 107     -54.762   2.126  -3.778  1.00 69.73           C  
ATOM   1560  O   LEU B 107     -54.243   1.265  -3.065  1.00 69.78           O  
ATOM   1561  CB  LEU B 107     -55.231   4.396  -2.823  1.00 64.63           C  
ATOM   1562  CG  LEU B 107     -54.870   5.869  -2.581  1.00 64.42           C  
ATOM   1563  CD1 LEU B 107     -55.829   6.507  -1.605  1.00 64.71           C  
ATOM   1564  CD2 LEU B 107     -53.443   5.962  -2.064  1.00 63.97           C  
ATOM   1565  N   TRP B 108     -55.735   1.857  -4.650  1.00 74.55           N  
ATOM   1566  CA  TRP B 108     -56.298   0.512  -4.792  1.00 79.65           C  
ATOM   1567  C   TRP B 108     -56.381  -0.026  -6.225  1.00 81.50           C  
ATOM   1568  O   TRP B 108     -55.993   0.638  -7.185  1.00 80.95           O  
ATOM   1569  CB  TRP B 108     -57.704   0.471  -4.171  1.00 82.53           C  
ATOM   1570  CG  TRP B 108     -57.917  -0.595  -3.122  1.00 86.45           C  
ATOM   1571  CD1 TRP B 108     -58.908  -0.624  -2.182  1.00 87.73           C  
ATOM   1572  CD2 TRP B 108     -57.106  -1.756  -2.882  1.00 87.62           C  
ATOM   1573  NE1 TRP B 108     -58.760  -1.720  -1.366  1.00 88.94           N  
ATOM   1574  CE2 TRP B 108     -57.663  -2.433  -1.772  1.00 88.60           C  
ATOM   1575  CE3 TRP B 108     -55.966  -2.291  -3.497  1.00 87.83           C  
ATOM   1576  CZ2 TRP B 108     -57.115  -3.614  -1.264  1.00 88.76           C  
ATOM   1577  CZ3 TRP B 108     -55.425  -3.462  -2.995  1.00 89.16           C  
ATOM   1578  CH2 TRP B 108     -55.999  -4.112  -1.887  1.00 89.26           C  
ATOM   1579  N   VAL B 109     -56.906  -1.246  -6.335  1.00 83.94           N  
ATOM   1580  CA  VAL B 109     -57.084  -1.949  -7.605  1.00 86.02           C  
ATOM   1581  C   VAL B 109     -58.122  -3.051  -7.391  1.00 87.66           C  
ATOM   1582  O   VAL B 109     -59.105  -2.852  -6.679  1.00 87.93           O  
ATOM   1583  CB  VAL B 109     -55.764  -2.599  -8.087  1.00 85.99           C  
ATOM   1584  CG1 VAL B 109     -54.801  -1.526  -8.573  1.00 85.55           C  
ATOM   1585  CG2 VAL B 109     -55.139  -3.413  -6.953  1.00 86.32           C  
ATOM   1586  N   GLY B 110     -57.910  -4.216  -7.995  1.00 89.43           N  
ATOM   1587  CA  GLY B 110     -58.871  -5.287  -7.803  1.00 90.57           C  
ATOM   1588  C   GLY B 110     -58.284  -6.648  -7.487  1.00 90.92           C  
ATOM   1589  O   GLY B 110     -57.076  -6.852  -7.729  1.00 90.75           O  
TER    1590      GLY B 110                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
