
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   93 (  758),  selected   93 , name 2cz4_B
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 2cz4_B.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      -       -           -
LGA    D     2_B      M       1          2.842
LGA    L     3_B      S       2          1.050
LGA    V     4_B      K       3          0.576
LGA    P     5_B      R       4          0.626
LGA    L     6_B      A       5          0.675
LGA    K     7_B      N       6          0.498
LGA    L     8_B      K       7          0.494
LGA    V     9_B      L       8          0.611
LGA    T    10_B      V       9          0.553
LGA    I    11_B      I      10          0.717
LGA    V    12_B      V      11          0.792
LGA    A    13_B      T      12          1.077
LGA    E    14_B      E      13          1.375
LGA    S    15_B      K      14          1.181
LGA    L    16_B      V      15          1.550
LGA    L    17_B      L      16          0.953
LGA    E    18_B      L      17          0.577
LGA    K    19_B      K      18          0.611
LGA    R    20_B      K      19          0.592
LGA    L    21_B      V      20          0.586
LGA    V    22_B      A      21          0.552
LGA    E    23_B      K      22          0.597
LGA    E    24_B      I      23          0.509
LGA    V    25_B      I      24          0.476
LGA    K    26_B      E      25          0.642
LGA    R    27_B      E      26          0.361
LGA    L    28_B      A      27          0.526
LGA    G    29_B      G      28          1.438
LGA    A    30_B      A      29          0.791
LGA    K    31_B      T      30          1.031
LGA    G    32_B      G      31          0.781
LGA    Y    33_B      Y      32          0.872
LGA    T    34_B      T      33          0.747
LGA    I    35_B      V      34          1.352
LGA    T    36_B      V      35          1.593
LGA    P    37_B      D      36          1.316
LGA    A    38_B      T      37          0.518
LGA    R    39_B      G      38          0.933
LGA    G    40_B      G      39          1.279
LGA    E    41_B      -       -           -
LGA    G    42_B      -       -           -
LGA    D    50_B      -       -           -
LGA    W    51_B      -       -           -
LGA    E    52_B      -       -           -
LGA    G    53_B      -       -           -
LGA    Q    54_B      S      58          1.319
LGA    N    55_B      N      59          0.743
LGA    I    56_B      V      60          1.019
LGA    R    57_B      K      61          0.933
LGA    L    58_B      F      62          0.902
LGA    E    59_B      E      63          0.651
LGA    T    60_B      V      64          0.820
LGA    I    61_B      L      65          0.743
LGA    V    62_B      T      66          0.516
LGA    S    63_B      E      67          2.093
LGA    E    64_B      N      68          2.467
LGA    -       -      R      69           -
LGA    E    65_B      E      70          1.670
LGA    V    66_B      M      71          0.761
LGA    A    67_B      A      72          0.427
LGA    L    68_B      E      73          0.938
LGA    R    69_B      K      74          0.694
LGA    I    70_B      I      75          0.786
LGA    L    71_B      A      76          1.216
LGA    Q    72_B      D      77          1.277
LGA    R    73_B      Q      78          0.942
LGA    L    74_B      V      79          1.832
LGA    Q    75_B      A      80          2.282
LGA    E    76_B      I      81          1.343
LGA    E    77_B      K      82          0.984
LGA    Y    78_B      F      83          1.525
LGA    F    79_B      F      84          1.205
LGA    P    80_B      T      85          1.199
LGA    H    81_B      D      86          1.543
LGA    Y    82_B      Y      87          0.800
LGA    A    83_B      A      88          0.486
LGA    V    84_B      G      89          1.381
LGA    I    85_B      I      90          0.931
LGA    A    86_B      I      91          0.619
LGA    Y    87_B      Y      92          0.605
LGA    V    88_B      I      93          0.730
LGA    E    89_B      C      94          0.922
LGA    N    90_B      E      95          0.848
LGA    V    91_B      A      96          0.620
LGA    W    92_B      E      97          0.554
LGA    V    93_B      V      98          0.507
LGA    V    94_B      L      99          1.591
LGA    R    95_B      Y     100          3.102
LGA    G    96_B      G     101          4.912
LGA    E    97_B      -       -           -
LGA    K    98_B      -       -           -
LGA    Y    99_B      -       -           -
LGA    V   100_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   93   83    5.0     82    1.25    28.05     94.964     6.078

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.300231 * X  +  -0.229684 * Y  +  -0.925801 * Z  +  -9.756889
  Y_new =  -0.587796 * X  +  -0.808947 * Y  +   0.010075 * Z  +  48.253826
  Z_new =  -0.751237 * X  +   0.541157 * Y  +  -0.377878 * Z  + -18.497375 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.180366   -0.961227  [ DEG:   124.9258    -55.0742 ]
  Theta =   0.849935    2.291658  [ DEG:    48.6977    131.3023 ]
  Phi   =  -1.098567    2.043026  [ DEG:   -62.9432    117.0568 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cz4_B                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cz4_B.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   93   83   5.0   82   1.25   28.05  94.964
REMARK  ---------------------------------------------------------- 
MOLECULE 2cz4_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   10-JUL-05   2CZ4              
TITLE     CRYSTAL STRUCTURE OF A PUTATIVE PII-LIKE SIGNALING PROTEIN            
TITLE    2 (TTHA0516) FROM THERMUS THERMOPHILUS HB8                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN TTHA0516;                             
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 GENE: TTHA0516;                                                      
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: B834(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PHCEH                                     
KEYWDS    CONSERVED HYPOTHETICAL PROTEIN, PII-LIKE SIGNALING PROTEIN,           
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ARAI,E.FUSATOMI,M.KUKIMOTO-NIINO,S.KAWAGUCHI,T.TERADA,              
AUTHOR   2 M.SHIROUZU,S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS           
AUTHOR   3 INITIATIVE (RSGI)                                                    
REVDAT   1   10-JAN-06 2CZ4    0                                                
JRNL        AUTH   R.ARAI,E.FUSATOMI,M.KUKIMOTO-NIINO,S.KAWAGUCHI,              
JRNL        AUTH 2 T.TERADA,M.SHIROUZU,S.YOKOYAMA                               
JRNL        TITL   CRYSTAL STRUCTURE OF A PUTATIVE PII-LIKE SIGNALING           
JRNL        TITL 2 PROTEIN (TTHA0516) FROM THERMUS THERMOPHILUS HB8             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.93 ANGSTROMS.                                          
DBREF  2CZ4 A    1   100  GB     55980485 YP_143782        1    100             
DBREF  2CZ4 B    1   100  GB     55980485 YP_143782        1    100             
DBREF  2CZ4 C    1   100  GB     55980485 YP_143782        1    100             
SEQRES   1 A  119  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY LEU          
SEQRES   2 A  119  VAL PRO ARG GLY SER HIS MSE ASP LEU VAL PRO LEU LYS          
SEQRES   3 A  119  LEU VAL THR ILE VAL ALA GLU SER LEU LEU GLU LYS ARG          
SEQRES   4 A  119  LEU VAL GLU GLU VAL LYS ARG LEU GLY ALA LYS GLY TYR          
SEQRES   5 A  119  THR ILE THR PRO ALA ARG GLY GLU GLY SER ARG GLY ILE          
SEQRES   6 A  119  ARG SER VAL ASP TRP GLU GLY GLN ASN ILE ARG LEU GLU          
SEQRES   7 A  119  THR ILE VAL SER GLU GLU VAL ALA LEU ARG ILE LEU GLN          
SEQRES   8 A  119  ARG LEU GLN GLU GLU TYR PHE PRO HIS TYR ALA VAL ILE          
SEQRES   9 A  119  ALA TYR VAL GLU ASN VAL TRP VAL VAL ARG GLY GLU LYS          
SEQRES  10 A  119  TYR VAL                                                      
SEQRES   1 B  119  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY LEU          
SEQRES   2 B  119  VAL PRO ARG GLY SER HIS MSE ASP LEU VAL PRO LEU LYS          
SEQRES   3 B  119  LEU VAL THR ILE VAL ALA GLU SER LEU LEU GLU LYS ARG          
SEQRES   4 B  119  LEU VAL GLU GLU VAL LYS ARG LEU GLY ALA LYS GLY TYR          
SEQRES   5 B  119  THR ILE THR PRO ALA ARG GLY GLU GLY SER ARG GLY ILE          
SEQRES   6 B  119  ARG SER VAL ASP TRP GLU GLY GLN ASN ILE ARG LEU GLU          
SEQRES   7 B  119  THR ILE VAL SER GLU GLU VAL ALA LEU ARG ILE LEU GLN          
SEQRES   8 B  119  ARG LEU GLN GLU GLU TYR PHE PRO HIS TYR ALA VAL ILE          
SEQRES   9 B  119  ALA TYR VAL GLU ASN VAL TRP VAL VAL ARG GLY GLU LYS          
SEQRES  10 B  119  TYR VAL                                                      
SEQRES   1 C  119  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY LEU          
SEQRES   2 C  119  VAL PRO ARG GLY SER HIS MSE ASP LEU VAL PRO LEU LYS          
SEQRES   3 C  119  LEU VAL THR ILE VAL ALA GLU SER LEU LEU GLU LYS ARG          
SEQRES   4 C  119  LEU VAL GLU GLU VAL LYS ARG LEU GLY ALA LYS GLY TYR          
SEQRES   5 C  119  THR ILE THR PRO ALA ARG GLY GLU GLY SER ARG GLY ILE          
SEQRES   6 C  119  ARG SER VAL ASP TRP GLU GLY GLN ASN ILE ARG LEU GLU          
SEQRES   7 C  119  THR ILE VAL SER GLU GLU VAL ALA LEU ARG ILE LEU GLN          
SEQRES   8 C  119  ARG LEU GLN GLU GLU TYR PHE PRO HIS TYR ALA VAL ILE          
SEQRES   9 C  119  ALA TYR VAL GLU ASN VAL TRP VAL VAL ARG GLY GLU LYS          
SEQRES  10 C  119  TYR VAL                                                      
HET    MSE  A   1       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  C   1       8                                                       
HET     CL    201       1                                                       
HET     CL    202       1                                                       
HET     CL    203       1                                                       
HET    ACT    301       4                                                       
HET    ACT    302       4                                                       
HET    ACT    303       4                                                       
HET    ACT    304       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     ACT ACETATE ION                                                      
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   4   CL    3(CL 1-)                                                     
FORMUL   7  ACT    4(C2 H3 O2 1-)                                               
FORMUL  11  HOH   *178(H2 O)                                                    
CRYST1   61.345  117.699  114.114  90.00  90.00  90.00 C 2 2 21     24          
HETATM  813  N   MSE B   1     -53.391   0.181   4.040  1.00 51.63           N  
HETATM  814  CA  MSE B   1     -53.342   1.098   2.856  1.00 52.36           C  
HETATM  815  C   MSE B   1     -52.423   0.624   1.748  1.00 49.79           C  
HETATM  816  O   MSE B   1     -51.200   0.695   1.860  1.00 53.79           O  
HETATM  817  CB  MSE B   1     -52.913   2.509   3.269  1.00 53.50           C  
HETATM  818  CG  MSE B   1     -54.072   3.445   3.563  1.00 58.01           C  
HETATM  819 SE   MSE B   1     -54.956   4.223   1.992  1.00 52.44          SE  
HETATM  820  CE  MSE B   1     -55.363   2.648   0.936  1.00 33.61           C  
ATOM    821  N   ASP B   2     -53.031   0.147   0.671  1.00 43.08           N  
ATOM    822  CA  ASP B   2     -52.297  -0.322  -0.488  1.00 40.92           C  
ATOM    823  C   ASP B   2     -52.390   0.819  -1.513  1.00 39.53           C  
ATOM    824  O   ASP B   2     -53.378   0.934  -2.246  1.00 29.98           O  
ATOM    825  CB  ASP B   2     -52.941  -1.605  -1.013  1.00 35.13           C  
ATOM    826  CG  ASP B   2     -52.177  -2.213  -2.152  1.00 41.54           C  
ATOM    827  OD1 ASP B   2     -51.034  -1.770  -2.405  1.00 41.53           O  
ATOM    828  OD2 ASP B   2     -52.714  -3.143  -2.792  1.00 44.51           O  
ATOM    829  N   LEU B   3     -51.361   1.668  -1.508  1.00 34.51           N  
ATOM    830  CA  LEU B   3     -51.247   2.840  -2.385  1.00 35.39           C  
ATOM    831  C   LEU B   3     -49.907   2.805  -3.094  1.00 34.08           C  
ATOM    832  O   LEU B   3     -48.876   2.772  -2.434  1.00 33.82           O  
ATOM    833  CB  LEU B   3     -51.289   4.131  -1.562  1.00 35.31           C  
ATOM    834  CG  LEU B   3     -52.606   4.806  -1.233  1.00 40.93           C  
ATOM    835  CD1 LEU B   3     -52.315   6.074  -0.447  1.00 34.13           C  
ATOM    836  CD2 LEU B   3     -53.346   5.143  -2.528  1.00 40.02           C  
ATOM    837  N   VAL B   4     -49.914   2.827  -4.425  1.00 25.13           N  
ATOM    838  CA  VAL B   4     -48.665   2.794  -5.177  1.00 28.29           C  
ATOM    839  C   VAL B   4     -48.596   3.927  -6.190  1.00 23.67           C  
ATOM    840  O   VAL B   4     -49.626   4.338  -6.739  1.00 19.60           O  
ATOM    841  CB  VAL B   4     -48.494   1.457  -5.925  1.00 35.35           C  
ATOM    842  CG1 VAL B   4     -48.589   0.278  -4.925  1.00 37.46           C  
ATOM    843  CG2 VAL B   4     -49.535   1.345  -7.013  1.00 26.83           C  
ATOM    844  N   PRO B   5     -47.374   4.432  -6.463  1.00 25.95           N  
ATOM    845  CA  PRO B   5     -47.148   5.528  -7.422  1.00 18.11           C  
ATOM    846  C   PRO B   5     -47.222   5.034  -8.862  1.00 26.37           C  
ATOM    847  O   PRO B   5     -46.627   4.009  -9.204  1.00 21.47           O  
ATOM    848  CB  PRO B   5     -45.734   6.021  -7.079  1.00 20.13           C  
ATOM    849  CG  PRO B   5     -45.024   4.726  -6.646  1.00 18.32           C  
ATOM    850  CD  PRO B   5     -46.117   4.044  -5.788  1.00 21.71           C  
ATOM    851  N   LEU B   6     -47.943   5.777  -9.700  1.00 20.07           N  
ATOM    852  CA  LEU B   6     -48.089   5.449 -11.117  1.00 20.84           C  
ATOM    853  C   LEU B   6     -48.201   6.792 -11.848  1.00 18.88           C  
ATOM    854  O   LEU B   6     -48.006   7.852 -11.248  1.00 18.98           O  
ATOM    855  CB  LEU B   6     -49.370   4.609 -11.346  1.00 20.48           C  
ATOM    856  CG  LEU B   6     -49.345   3.185 -10.752  1.00 27.91           C  
ATOM    857  CD1 LEU B   6     -50.757   2.558 -10.715  1.00 21.07           C  
ATOM    858  CD2 LEU B   6     -48.399   2.350 -11.608  1.00 25.01           C  
ATOM    859  N   LYS B   7     -48.524   6.738 -13.132  1.00 18.54           N  
ATOM    860  CA  LYS B   7     -48.677   7.948 -13.923  1.00 21.06           C  
ATOM    861  C   LYS B   7     -50.079   7.981 -14.484  1.00 23.21           C  
ATOM    862  O   LYS B   7     -50.698   6.930 -14.746  1.00 22.05           O  
ATOM    863  CB  LYS B   7     -47.679   7.989 -15.088  1.00 17.77           C  
ATOM    864  CG  LYS B   7     -46.216   7.963 -14.682  1.00 19.13           C  
ATOM    865  CD  LYS B   7     -45.887   9.087 -13.701  1.00 18.95           C  
ATOM    866  CE  LYS B   7     -44.410   9.061 -13.313  1.00 19.86           C  
ATOM    867  NZ  LYS B   7     -44.095  10.077 -12.256  1.00 19.50           N  
ATOM    868  N   LEU B   8     -50.600   9.193 -14.637  1.00 21.16           N  
ATOM    869  CA  LEU B   8     -51.923   9.367 -15.215  1.00 17.33           C  
ATOM    870  C   LEU B   8     -51.650  10.098 -16.524  1.00 18.01           C  
ATOM    871  O   LEU B   8     -51.115  11.206 -16.527  1.00 17.94           O  
ATOM    872  CB  LEU B   8     -52.803  10.230 -14.307  1.00 14.69           C  
ATOM    873  CG  LEU B   8     -54.229  10.475 -14.811  1.00 27.44           C  
ATOM    874  CD1 LEU B   8     -55.059   9.202 -14.641  1.00 28.06           C  
ATOM    875  CD2 LEU B   8     -54.861  11.600 -14.008  1.00 30.39           C  
ATOM    876  N   VAL B   9     -51.993   9.472 -17.636  1.00 17.50           N  
ATOM    877  CA  VAL B   9     -51.773  10.085 -18.931  1.00 14.67           C  
ATOM    878  C   VAL B   9     -53.116  10.610 -19.386  1.00 22.89           C  
ATOM    879  O   VAL B   9     -54.116   9.895 -19.328  1.00 22.21           O  
ATOM    880  CB  VAL B   9     -51.264   9.059 -19.956  1.00 21.48           C  
ATOM    881  CG1 VAL B   9     -51.299   9.652 -21.361  1.00 15.64           C  
ATOM    882  CG2 VAL B   9     -49.833   8.651 -19.608  1.00 25.31           C  
ATOM    883  N   THR B  10     -53.145  11.866 -19.812  1.00 17.14           N  
ATOM    884  CA  THR B  10     -54.381  12.477 -20.282  1.00 15.58           C  
ATOM    885  C   THR B  10     -54.241  12.846 -21.756  1.00 15.82           C  
ATOM    886  O   THR B  10     -53.231  13.402 -22.172  1.00 23.90           O  
ATOM    887  CB  THR B  10     -54.720  13.767 -19.488  1.00 18.63           C  
ATOM    888  OG1 THR B  10     -54.822  13.453 -18.096  1.00 20.50           O  
ATOM    889  CG2 THR B  10     -56.049  14.360 -19.959  1.00 17.52           C  
ATOM    890  N   ILE B  11     -55.280  12.552 -22.528  1.00 17.28           N  
ATOM    891  CA  ILE B  11     -55.275  12.861 -23.951  1.00 16.80           C  
ATOM    892  C   ILE B  11     -56.573  13.569 -24.311  1.00 14.22           C  
ATOM    893  O   ILE B  11     -57.656  13.122 -23.923  1.00 22.10           O  
ATOM    894  CB  ILE B  11     -55.195  11.566 -24.798  1.00 22.36           C  
ATOM    895  CG1 ILE B  11     -53.993  10.723 -24.363  1.00 21.32           C  
ATOM    896  CG2 ILE B  11     -55.077  11.923 -26.281  1.00 19.92           C  
ATOM    897  CD1 ILE B  11     -54.055   9.288 -24.880  1.00 23.95           C  
ATOM    898  N   VAL B  12     -56.470  14.680 -25.024  1.00 19.46           N  
ATOM    899  CA  VAL B  12     -57.671  15.375 -25.466  1.00 19.25           C  
ATOM    900  C   VAL B  12     -57.609  15.410 -26.989  1.00 19.89           C  
ATOM    901  O   VAL B  12     -56.588  15.756 -27.557  1.00 20.52           O  
ATOM    902  CB  VAL B  12     -57.755  16.830 -24.905  1.00 18.16           C  
ATOM    903  CG1 VAL B  12     -59.017  17.525 -25.394  1.00 17.10           C  
ATOM    904  CG2 VAL B  12     -57.805  16.794 -23.359  1.00 18.36           C  
ATOM    905  N   ALA B  13     -58.708  15.034 -27.638  1.00 19.38           N  
ATOM    906  CA  ALA B  13     -58.783  15.043 -29.086  1.00 23.22           C  
ATOM    907  C   ALA B  13     -60.249  14.883 -29.485  1.00 24.67           C  
ATOM    908  O   ALA B  13     -61.108  14.645 -28.626  1.00 21.66           O  
ATOM    909  CB  ALA B  13     -57.963  13.901 -29.654  1.00 23.55           C  
ATOM    910  N   GLU B  14     -60.533  15.042 -30.778  1.00 24.64           N  
ATOM    911  CA  GLU B  14     -61.907  14.884 -31.294  1.00 21.19           C  
ATOM    912  C   GLU B  14     -62.460  13.530 -30.900  1.00 24.44           C  
ATOM    913  O   GLU B  14     -61.751  12.519 -30.952  1.00 23.15           O  
ATOM    914  CB  GLU B  14     -61.918  14.988 -32.823  1.00 32.08           C  
ATOM    915  CG  GLU B  14     -61.804  16.394 -33.346  1.00 44.11           C  
ATOM    916  CD  GLU B  14     -62.785  16.656 -34.478  1.00 62.39           C  
ATOM    917  OE1 GLU B  14     -62.691  17.731 -35.118  1.00 63.13           O  
ATOM    918  OE2 GLU B  14     -63.657  15.784 -34.718  1.00 59.17           O  
ATOM    919  N   SER B  15     -63.730  13.497 -30.517  1.00 22.59           N  
ATOM    920  CA  SER B  15     -64.360  12.251 -30.102  1.00 26.35           C  
ATOM    921  C   SER B  15     -64.301  11.173 -31.175  1.00 25.10           C  
ATOM    922  O   SER B  15     -64.323   9.981 -30.869  1.00 23.67           O  
ATOM    923  CB  SER B  15     -65.817  12.508 -29.704  1.00 26.69           C  
ATOM    924  OG  SER B  15     -66.523  13.103 -30.774  1.00 38.23           O  
ATOM    925  N   LEU B  16     -64.219  11.587 -32.432  1.00 25.04           N  
ATOM    926  CA  LEU B  16     -64.166  10.618 -33.526  1.00 29.76           C  
ATOM    927  C   LEU B  16     -62.889   9.776 -33.517  1.00 29.53           C  
ATOM    928  O   LEU B  16     -62.826   8.738 -34.168  1.00 30.37           O  
ATOM    929  CB  LEU B  16     -64.328  11.337 -34.864  1.00 25.84           C  
ATOM    930  CG  LEU B  16     -65.734  11.939 -35.003  1.00 27.08           C  
ATOM    931  CD1 LEU B  16     -65.799  12.878 -36.206  1.00 27.89           C  
ATOM    932  CD2 LEU B  16     -66.756  10.811 -35.114  1.00 28.30           C  
ATOM    933  N   LEU B  17     -61.874  10.213 -32.769  1.00 26.36           N  
ATOM    934  CA  LEU B  17     -60.622   9.464 -32.686  1.00 24.92           C  
ATOM    935  C   LEU B  17     -60.607   8.455 -31.543  1.00 28.48           C  
ATOM    936  O   LEU B  17     -59.613   7.763 -31.340  1.00 30.86           O  
ATOM    937  CB  LEU B  17     -59.443  10.420 -32.526  1.00 28.71           C  
ATOM    938  CG  LEU B  17     -58.954  11.111 -33.799  1.00 25.36           C  
ATOM    939  CD1 LEU B  17     -57.894  12.151 -33.439  1.00 28.21           C  
ATOM    940  CD2 LEU B  17     -58.350  10.072 -34.743  1.00 27.56           C  
ATOM    941  N   GLU B  18     -61.716   8.350 -30.815  1.00 26.53           N  
ATOM    942  CA  GLU B  18     -61.796   7.441 -29.675  1.00 29.46           C  
ATOM    943  C   GLU B  18     -61.380   5.995 -29.906  1.00 34.54           C  
ATOM    944  O   GLU B  18     -60.541   5.470 -29.179  1.00 28.13           O  
ATOM    945  CB  GLU B  18     -63.204   7.434 -29.088  1.00 31.07           C  
ATOM    946  CG  GLU B  18     -63.306   6.653 -27.777  1.00 34.59           C  
ATOM    947  CD  GLU B  18     -64.721   6.596 -27.208  1.00 42.83           C  
ATOM    948  OE1 GLU B  18     -65.432   7.622 -27.242  1.00 44.40           O  
ATOM    949  OE2 GLU B  18     -65.120   5.521 -26.702  1.00 36.95           O  
ATOM    950  N   LYS B  19     -61.979   5.336 -30.894  1.00 32.81           N  
ATOM    951  CA  LYS B  19     -61.646   3.939 -31.130  1.00 35.22           C  
ATOM    952  C   LYS B  19     -60.158   3.746 -31.370  1.00 26.60           C  
ATOM    953  O   LYS B  19     -59.530   2.859 -30.787  1.00 34.67           O  
ATOM    954  CB  LYS B  19     -62.446   3.377 -32.312  1.00 39.45           C  
ATOM    955  CG  LYS B  19     -62.065   1.938 -32.653  1.00 47.81           C  
ATOM    956  CD  LYS B  19     -62.983   1.317 -33.695  1.00 56.57           C  
ATOM    957  CE  LYS B  19     -62.616  -0.148 -33.924  1.00 63.15           C  
ATOM    958  NZ  LYS B  19     -63.649  -0.893 -34.695  1.00 71.39           N  
ATOM    959  N   ARG B  20     -59.590   4.585 -32.223  1.00 24.79           N  
ATOM    960  CA  ARG B  20     -58.173   4.501 -32.536  1.00 28.54           C  
ATOM    961  C   ARG B  20     -57.321   4.692 -31.266  1.00 32.49           C  
ATOM    962  O   ARG B  20     -56.436   3.879 -30.960  1.00 31.00           O  
ATOM    963  CB  ARG B  20     -57.831   5.575 -33.563  1.00 33.09           C  
ATOM    964  CG  ARG B  20     -57.048   5.075 -34.763  1.00 54.68           C  
ATOM    965  CD  ARG B  20     -56.938   6.165 -35.818  1.00 56.49           C  
ATOM    966  NE  ARG B  20     -58.258   6.613 -36.261  1.00 65.25           N  
ATOM    967  CZ  ARG B  20     -58.468   7.551 -37.184  1.00 68.81           C  
ATOM    968  NH1 ARG B  20     -57.438   8.156 -37.770  1.00 60.95           N  
ATOM    969  NH2 ARG B  20     -59.712   7.883 -37.523  1.00 64.05           N  
ATOM    970  N   LEU B  21     -57.599   5.758 -30.516  1.00 25.87           N  
ATOM    971  CA  LEU B  21     -56.823   6.037 -29.299  1.00 27.67           C  
ATOM    972  C   LEU B  21     -56.949   4.962 -28.236  1.00 27.28           C  
ATOM    973  O   LEU B  21     -55.948   4.570 -27.629  1.00 27.83           O  
ATOM    974  CB  LEU B  21     -57.211   7.391 -28.710  1.00 21.21           C  
ATOM    975  CG  LEU B  21     -56.839   8.606 -29.550  1.00 28.50           C  
ATOM    976  CD1 LEU B  21     -57.459   9.868 -28.952  1.00 31.68           C  
ATOM    977  CD2 LEU B  21     -55.307   8.722 -29.627  1.00 28.89           C  
ATOM    978  N   VAL B  22     -58.166   4.482 -28.000  1.00 28.31           N  
ATOM    979  CA  VAL B  22     -58.371   3.438 -27.004  1.00 27.57           C  
ATOM    980  C   VAL B  22     -57.564   2.213 -27.425  1.00 35.55           C  
ATOM    981  O   VAL B  22     -56.944   1.554 -26.593  1.00 38.45           O  
ATOM    982  CB  VAL B  22     -59.879   3.070 -26.863  1.00 31.28           C  
ATOM    983  CG1 VAL B  22     -60.032   1.689 -26.257  1.00 28.47           C  
ATOM    984  CG2 VAL B  22     -60.591   4.104 -25.975  1.00 26.69           C  
ATOM    985  N   GLU B  23     -57.567   1.910 -28.717  1.00 38.09           N  
ATOM    986  CA  GLU B  23     -56.812   0.766 -29.227  1.00 40.56           C  
ATOM    987  C   GLU B  23     -55.320   0.984 -29.025  1.00 36.60           C  
ATOM    988  O   GLU B  23     -54.604   0.068 -28.633  1.00 37.92           O  
ATOM    989  CB  GLU B  23     -57.099   0.546 -30.715  1.00 47.31           C  
ATOM    990  CG  GLU B  23     -58.470  -0.035 -31.013  1.00 60.17           C  
ATOM    991  CD  GLU B  23     -58.763  -0.103 -32.509  1.00 69.40           C  
ATOM    992  OE1 GLU B  23     -59.819  -0.659 -32.887  1.00 73.14           O  
ATOM    993  OE2 GLU B  23     -57.941   0.404 -33.307  1.00 72.65           O  
ATOM    994  N   GLU B  24     -54.841   2.190 -29.306  1.00 35.27           N  
ATOM    995  CA  GLU B  24     -53.429   2.487 -29.112  1.00 36.02           C  
ATOM    996  C   GLU B  24     -52.975   2.271 -27.663  1.00 37.88           C  
ATOM    997  O   GLU B  24     -51.987   1.573 -27.426  1.00 35.22           O  
ATOM    998  CB  GLU B  24     -53.114   3.934 -29.496  1.00 35.11           C  
ATOM    999  CG  GLU B  24     -52.904   4.177 -30.969  1.00 52.27           C  
ATOM   1000  CD  GLU B  24     -51.638   3.538 -31.507  1.00 50.10           C  
ATOM   1001  OE1 GLU B  24     -51.300   3.816 -32.673  1.00 52.68           O  
ATOM   1002  OE2 GLU B  24     -50.986   2.757 -30.779  1.00 57.87           O  
ATOM   1003  N   VAL B  25     -53.684   2.849 -26.688  1.00 33.47           N  
ATOM   1004  CA  VAL B  25     -53.215   2.685 -25.319  1.00 31.79           C  
ATOM   1005  C   VAL B  25     -53.279   1.258 -24.821  1.00 34.69           C  
ATOM   1006  O   VAL B  25     -52.376   0.828 -24.115  1.00 32.48           O  
ATOM   1007  CB  VAL B  25     -53.916   3.653 -24.305  1.00 29.71           C  
ATOM   1008  CG1 VAL B  25     -53.727   5.097 -24.778  1.00 32.46           C  
ATOM   1009  CG2 VAL B  25     -55.384   3.314 -24.130  1.00 27.81           C  
ATOM   1010  N   LYS B  26     -54.312   0.512 -25.198  1.00 31.56           N  
ATOM   1011  CA  LYS B  26     -54.401  -0.879 -24.760  1.00 36.62           C  
ATOM   1012  C   LYS B  26     -53.225  -1.664 -25.339  1.00 37.39           C  
ATOM   1013  O   LYS B  26     -52.557  -2.438 -24.646  1.00 39.15           O  
ATOM   1014  CB  LYS B  26     -55.716  -1.503 -25.219  1.00 39.50           C  
ATOM   1015  CG  LYS B  26     -56.933  -1.094 -24.396  1.00 38.62           C  
ATOM   1016  CD  LYS B  26     -58.140  -1.902 -24.827  1.00 54.73           C  
ATOM   1017  CE  LYS B  26     -59.334  -1.673 -23.915  1.00 65.41           C  
ATOM   1018  NZ  LYS B  26     -60.495  -2.502 -24.348  1.00 64.78           N  
ATOM   1019  N   ARG B  27     -52.989  -1.436 -26.621  1.00 31.25           N  
ATOM   1020  CA  ARG B  27     -51.906  -2.059 -27.374  1.00 38.40           C  
ATOM   1021  C   ARG B  27     -50.553  -1.793 -26.716  1.00 39.22           C  
ATOM   1022  O   ARG B  27     -49.682  -2.663 -26.708  1.00 34.46           O  
ATOM   1023  CB  ARG B  27     -51.924  -1.490 -28.794  1.00 39.25           C  
ATOM   1024  CG  ARG B  27     -50.734  -1.777 -29.684  1.00 47.34           C  
ATOM   1025  CD  ARG B  27     -50.960  -1.057 -31.022  1.00 51.75           C  
ATOM   1026  NE  ARG B  27     -52.310  -1.327 -31.523  1.00 58.48           N  
ATOM   1027  CZ  ARG B  27     -53.060  -0.472 -32.219  1.00 54.34           C  
ATOM   1028  NH1 ARG B  27     -52.610   0.738 -32.518  1.00 50.68           N  
ATOM   1029  NH2 ARG B  27     -54.274  -0.833 -32.614  1.00 61.18           N  
ATOM   1030  N   LEU B  28     -50.383  -0.598 -26.156  1.00 30.76           N  
ATOM   1031  CA  LEU B  28     -49.120  -0.242 -25.518  1.00 31.19           C  
ATOM   1032  C   LEU B  28     -48.991  -0.637 -24.048  1.00 31.86           C  
ATOM   1033  O   LEU B  28     -47.970  -0.358 -23.417  1.00 37.04           O  
ATOM   1034  CB  LEU B  28     -48.862   1.256 -25.692  1.00 31.77           C  
ATOM   1035  CG  LEU B  28     -48.727   1.662 -27.162  1.00 32.65           C  
ATOM   1036  CD1 LEU B  28     -48.556   3.172 -27.270  1.00 43.34           C  
ATOM   1037  CD2 LEU B  28     -47.548   0.949 -27.792  1.00 35.80           C  
ATOM   1038  N   GLY B  29     -50.013  -1.273 -23.486  1.00 34.72           N  
ATOM   1039  CA  GLY B  29     -49.888  -1.702 -22.103  1.00 34.98           C  
ATOM   1040  C   GLY B  29     -50.922  -1.229 -21.115  1.00 30.85           C  
ATOM   1041  O   GLY B  29     -51.021  -1.784 -20.028  1.00 28.94           O  
ATOM   1042  N   ALA B  30     -51.701  -0.211 -21.472  1.00 29.74           N  
ATOM   1043  CA  ALA B  30     -52.717   0.290 -20.551  1.00 26.04           C  
ATOM   1044  C   ALA B  30     -53.780  -0.766 -20.269  1.00 29.62           C  
ATOM   1045  O   ALA B  30     -54.279  -1.411 -21.177  1.00 29.61           O  
ATOM   1046  CB  ALA B  30     -53.368   1.537 -21.132  1.00 31.68           C  
ATOM   1047  N   LYS B  31     -54.160  -0.903 -19.010  1.00 27.84           N  
ATOM   1048  CA  LYS B  31     -55.153  -1.885 -18.631  1.00 34.94           C  
ATOM   1049  C   LYS B  31     -56.557  -1.329 -18.425  1.00 43.21           C  
ATOM   1050  O   LYS B  31     -57.482  -2.071 -18.085  1.00 48.31           O  
ATOM   1051  CB  LYS B  31     -54.666  -2.614 -17.386  1.00 41.57           C  
ATOM   1052  CG  LYS B  31     -53.365  -3.369 -17.640  1.00 45.45           C  
ATOM   1053  CD  LYS B  31     -52.941  -4.144 -16.414  1.00 64.14           C  
ATOM   1054  CE  LYS B  31     -51.738  -5.035 -16.687  1.00 70.24           C  
ATOM   1055  NZ  LYS B  31     -51.456  -5.914 -15.508  1.00 76.87           N  
ATOM   1056  N   GLY B  32     -56.722  -0.026 -18.643  1.00 37.00           N  
ATOM   1057  CA  GLY B  32     -58.026   0.600 -18.481  1.00 31.58           C  
ATOM   1058  C   GLY B  32     -57.999   2.030 -19.006  1.00 30.72           C  
ATOM   1059  O   GLY B  32     -56.976   2.484 -19.515  1.00 30.92           O  
ATOM   1060  N   TYR B  33     -59.124   2.728 -18.911  1.00 28.53           N  
ATOM   1061  CA  TYR B  33     -59.208   4.111 -19.353  1.00 24.42           C  
ATOM   1062  C   TYR B  33     -60.543   4.700 -18.949  1.00 26.55           C  
ATOM   1063  O   TYR B  33     -61.515   3.983 -18.696  1.00 26.32           O  
ATOM   1064  CB  TYR B  33     -59.039   4.254 -20.872  1.00 26.59           C  
ATOM   1065  CG  TYR B  33     -60.159   3.653 -21.698  1.00 32.58           C  
ATOM   1066  CD1 TYR B  33     -60.080   2.337 -22.160  1.00 36.62           C  
ATOM   1067  CD2 TYR B  33     -61.291   4.393 -22.014  1.00 27.31           C  
ATOM   1068  CE1 TYR B  33     -61.103   1.775 -22.925  1.00 28.24           C  
ATOM   1069  CE2 TYR B  33     -62.328   3.836 -22.774  1.00 33.76           C  
ATOM   1070  CZ  TYR B  33     -62.218   2.525 -23.226  1.00 31.33           C  
ATOM   1071  OH  TYR B  33     -63.215   1.967 -23.996  1.00 36.12           O  
ATOM   1072  N   THR B  34     -60.577   6.021 -18.874  1.00 25.53           N  
ATOM   1073  CA  THR B  34     -61.788   6.729 -18.519  1.00 24.89           C  
ATOM   1074  C   THR B  34     -61.987   7.842 -19.528  1.00 24.06           C  
ATOM   1075  O   THR B  34     -61.043   8.511 -19.910  1.00 26.32           O  
ATOM   1076  CB  THR B  34     -61.675   7.363 -17.125  1.00 27.22           C  
ATOM   1077  OG1 THR B  34     -61.267   6.368 -16.182  1.00 37.47           O  
ATOM   1078  CG2 THR B  34     -63.019   7.924 -16.696  1.00 26.17           C  
ATOM   1079  N   ILE B  35     -63.221   8.041 -19.965  1.00 25.59           N  
ATOM   1080  CA  ILE B  35     -63.484   9.111 -20.902  1.00 20.56           C  
ATOM   1081  C   ILE B  35     -64.499  10.093 -20.352  1.00 25.89           C  
ATOM   1082  O   ILE B  35     -65.488   9.696 -19.725  1.00 22.58           O  
ATOM   1083  CB  ILE B  35     -64.012   8.567 -22.252  1.00 26.46           C  
ATOM   1084  CG1 ILE B  35     -62.894   7.813 -22.973  1.00 32.17           C  
ATOM   1085  CG2 ILE B  35     -64.529   9.720 -23.132  1.00 21.96           C  
ATOM   1086  CD1 ILE B  35     -63.319   7.230 -24.302  1.00 39.57           C  
ATOM   1087  N   THR B  36     -64.225  11.373 -20.585  1.00 21.23           N  
ATOM   1088  CA  THR B  36     -65.116  12.457 -20.201  1.00 22.58           C  
ATOM   1089  C   THR B  36     -65.355  13.302 -21.468  1.00 22.44           C  
ATOM   1090  O   THR B  36     -64.424  13.542 -22.242  1.00 19.13           O  
ATOM   1091  CB  THR B  36     -64.462  13.393 -19.136  1.00 31.99           C  
ATOM   1092  OG1 THR B  36     -63.997  12.620 -18.025  1.00 38.38           O  
ATOM   1093  CG2 THR B  36     -65.473  14.425 -18.651  1.00 28.53           C  
ATOM   1094  N   PRO B  37     -66.600  13.744 -21.711  1.00 22.64           N  
ATOM   1095  CA  PRO B  37     -66.812  14.564 -22.913  1.00 21.61           C  
ATOM   1096  C   PRO B  37     -66.167  15.922 -22.693  1.00 21.74           C  
ATOM   1097  O   PRO B  37     -66.066  16.401 -21.565  1.00 22.65           O  
ATOM   1098  CB  PRO B  37     -68.338  14.630 -23.045  1.00 25.71           C  
ATOM   1099  CG  PRO B  37     -68.833  14.356 -21.677  1.00 29.38           C  
ATOM   1100  CD  PRO B  37     -67.881  13.328 -21.118  1.00 26.47           C  
ATOM   1101  N   ALA B  38     -65.706  16.545 -23.764  1.00 18.26           N  
ATOM   1102  CA  ALA B  38     -65.031  17.819 -23.614  1.00 18.47           C  
ATOM   1103  C   ALA B  38     -65.231  18.697 -24.832  1.00 21.46           C  
ATOM   1104  O   ALA B  38     -65.648  18.222 -25.889  1.00 23.62           O  
ATOM   1105  CB  ALA B  38     -63.550  17.574 -23.417  1.00 17.64           C  
ATOM   1106  N   ARG B  39     -64.963  19.985 -24.681  1.00 21.31           N  
ATOM   1107  CA  ARG B  39     -65.058  20.877 -25.826  1.00 23.97           C  
ATOM   1108  C   ARG B  39     -63.978  21.938 -25.743  1.00 28.91           C  
ATOM   1109  O   ARG B  39     -63.328  22.109 -24.709  1.00 21.77           O  
ATOM   1110  CB  ARG B  39     -66.456  21.485 -25.963  1.00 28.38           C  
ATOM   1111  CG  ARG B  39     -67.083  21.971 -24.718  1.00 33.01           C  
ATOM   1112  CD  ARG B  39     -68.559  22.171 -24.961  1.00 35.51           C  
ATOM   1113  NE  ARG B  39     -69.175  22.846 -23.833  1.00 28.28           N  
ATOM   1114  CZ  ARG B  39     -68.957  24.115 -23.525  1.00 36.64           C  
ATOM   1115  NH1 ARG B  39     -68.134  24.853 -24.273  1.00 28.17           N  
ATOM   1116  NH2 ARG B  39     -69.566  24.646 -22.475  1.00 34.32           N  
ATOM   1117  N   GLY B  40     -63.728  22.604 -26.859  1.00 28.48           N  
ATOM   1118  CA  GLY B  40     -62.694  23.615 -26.859  1.00 35.85           C  
ATOM   1119  C   GLY B  40     -63.163  24.802 -27.652  1.00 39.15           C  
ATOM   1120  O   GLY B  40     -64.369  24.987 -27.816  1.00 38.67           O  
ATOM   1121  N   GLU B  41     -62.218  25.602 -28.137  1.00 46.33           N  
ATOM   1122  CA  GLU B  41     -62.552  26.781 -28.929  1.00 57.61           C  
ATOM   1123  C   GLU B  41     -63.597  26.391 -29.980  1.00 61.13           C  
ATOM   1124  O   GLU B  41     -63.316  25.602 -30.885  1.00 60.74           O  
ATOM   1125  CB  GLU B  41     -61.298  27.324 -29.621  1.00 61.30           C  
ATOM   1126  CG  GLU B  41     -61.398  28.791 -30.016  1.00 77.36           C  
ATOM   1127  CD  GLU B  41     -61.074  29.736 -28.865  1.00 85.99           C  
ATOM   1128  OE1 GLU B  41     -59.875  29.864 -28.522  1.00 91.95           O  
ATOM   1129  OE2 GLU B  41     -62.010  30.346 -28.300  1.00 83.19           O  
ATOM   1130  N   GLY B  42     -64.806  26.929 -29.845  1.00 67.91           N  
ATOM   1131  CA  GLY B  42     -65.867  26.616 -30.787  1.00 71.70           C  
ATOM   1132  C   GLY B  42     -66.422  25.216 -30.603  1.00 75.24           C  
ATOM   1133  O   GLY B  42     -66.176  24.326 -31.422  1.00 78.31           O  
ATOM   1134  N   ASP B  50     -74.156  20.424 -26.421  1.00 87.61           N  
ATOM   1135  CA  ASP B  50     -72.932  20.597 -27.192  1.00 87.24           C  
ATOM   1136  C   ASP B  50     -71.899  19.527 -26.853  1.00 80.06           C  
ATOM   1137  O   ASP B  50     -70.869  19.424 -27.513  1.00 83.35           O  
ATOM   1138  CB  ASP B  50     -72.339  21.989 -26.929  1.00 96.55           C  
ATOM   1139  CG  ASP B  50     -71.020  22.220 -27.660  1.00102.38           C  
ATOM   1140  OD1 ASP B  50     -70.020  21.538 -27.344  1.00102.58           O  
ATOM   1141  OD2 ASP B  50     -70.980  23.091 -28.554  1.00107.26           O  
ATOM   1142  N   TRP B  51     -72.177  18.713 -25.841  1.00 68.61           N  
ATOM   1143  CA  TRP B  51     -71.226  17.682 -25.443  1.00 60.03           C  
ATOM   1144  C   TRP B  51     -71.061  16.508 -26.410  1.00 56.65           C  
ATOM   1145  O   TRP B  51     -70.161  15.688 -26.237  1.00 59.55           O  
ATOM   1146  CB  TRP B  51     -71.567  17.173 -24.043  1.00 49.39           C  
ATOM   1147  CG  TRP B  51     -71.516  18.265 -23.032  1.00 45.50           C  
ATOM   1148  CD1 TRP B  51     -72.573  18.813 -22.371  1.00 45.60           C  
ATOM   1149  CD2 TRP B  51     -70.350  18.974 -22.585  1.00 35.06           C  
ATOM   1150  NE1 TRP B  51     -72.144  19.817 -21.538  1.00 42.76           N  
ATOM   1151  CE2 TRP B  51     -70.784  19.941 -21.648  1.00 37.75           C  
ATOM   1152  CE3 TRP B  51     -68.987  18.890 -22.888  1.00 24.10           C  
ATOM   1153  CZ2 TRP B  51     -69.898  20.820 -21.002  1.00 25.44           C  
ATOM   1154  CZ3 TRP B  51     -68.103  19.762 -22.247  1.00 26.55           C  
ATOM   1155  CH2 TRP B  51     -68.568  20.714 -21.314  1.00 26.55           C  
ATOM   1156  N   GLU B  52     -71.920  16.425 -27.424  1.00 54.00           N  
ATOM   1157  CA  GLU B  52     -71.822  15.349 -28.418  1.00 49.52           C  
ATOM   1158  C   GLU B  52     -71.178  15.900 -29.684  1.00 39.08           C  
ATOM   1159  O   GLU B  52     -71.437  17.037 -30.068  1.00 39.79           O  
ATOM   1160  CB  GLU B  52     -73.210  14.797 -28.762  1.00 60.99           C  
ATOM   1161  CG  GLU B  52     -73.919  14.095 -27.608  1.00 83.05           C  
ATOM   1162  CD  GLU B  52     -75.331  13.658 -27.969  1.00 93.82           C  
ATOM   1163  OE1 GLU B  52     -76.187  14.538 -28.214  1.00100.04           O  
ATOM   1164  OE2 GLU B  52     -75.584  12.434 -28.012  1.00 99.11           O  
ATOM   1165  N   GLY B  53     -70.328  15.112 -30.332  1.00 36.28           N  
ATOM   1166  CA  GLY B  53     -69.712  15.595 -31.553  1.00 31.87           C  
ATOM   1167  C   GLY B  53     -68.587  16.582 -31.348  1.00 35.37           C  
ATOM   1168  O   GLY B  53     -68.196  17.307 -32.261  1.00 35.59           O  
ATOM   1169  N   GLN B  54     -68.051  16.617 -30.136  1.00 32.30           N  
ATOM   1170  CA  GLN B  54     -66.956  17.517 -29.858  1.00 30.89           C  
ATOM   1171  C   GLN B  54     -65.694  16.701 -29.594  1.00 29.47           C  
ATOM   1172  O   GLN B  54     -65.285  15.884 -30.425  1.00 23.04           O  
ATOM   1173  CB  GLN B  54     -67.287  18.391 -28.646  1.00 38.39           C  
ATOM   1174  CG  GLN B  54     -68.450  19.345 -28.879  1.00 48.92           C  
ATOM   1175  CD  GLN B  54     -68.240  20.224 -30.091  1.00 53.61           C  
ATOM   1176  OE1 GLN B  54     -68.773  19.952 -31.172  1.00 63.45           O  
ATOM   1177  NE2 GLN B  54     -67.443  21.279 -29.927  1.00 57.99           N  
ATOM   1178  N   ASN B  55     -65.092  16.915 -28.430  1.00 19.26           N  
ATOM   1179  CA  ASN B  55     -63.873  16.211 -28.059  1.00 18.35           C  
ATOM   1180  C   ASN B  55     -64.117  15.249 -26.900  1.00 19.05           C  
ATOM   1181  O   ASN B  55     -65.202  15.182 -26.335  1.00 19.53           O  
ATOM   1182  CB  ASN B  55     -62.810  17.210 -27.578  1.00 24.95           C  
ATOM   1183  CG  ASN B  55     -62.379  18.203 -28.650  1.00 31.52           C  
ATOM   1184  OD1 ASN B  55     -62.032  19.350 -28.337  1.00 33.96           O  
ATOM   1185  ND2 ASN B  55     -62.365  17.772 -29.896  1.00 22.25           N  
ATOM   1186  N   ILE B  56     -63.075  14.511 -26.546  1.00 20.89           N  
ATOM   1187  CA  ILE B  56     -63.137  13.633 -25.389  1.00 23.36           C  
ATOM   1188  C   ILE B  56     -61.839  13.853 -24.635  1.00 24.63           C  
ATOM   1189  O   ILE B  56     -60.835  14.276 -25.217  1.00 20.29           O  
ATOM   1190  CB  ILE B  56     -63.209  12.130 -25.741  1.00 25.39           C  
ATOM   1191  CG1 ILE B  56     -62.067  11.769 -26.689  1.00 26.81           C  
ATOM   1192  CG2 ILE B  56     -64.597  11.785 -26.303  1.00 25.48           C  
ATOM   1193  CD1 ILE B  56     -61.796  10.305 -26.755  1.00 26.04           C  
ATOM   1194  N   ARG B  57     -61.870  13.613 -23.332  1.00 23.51           N  
ATOM   1195  CA  ARG B  57     -60.655  13.705 -22.535  1.00 22.94           C  
ATOM   1196  C   ARG B  57     -60.520  12.239 -22.130  1.00 23.94           C  
ATOM   1197  O   ARG B  57     -61.385  11.703 -21.452  1.00 20.47           O  
ATOM   1198  CB  ARG B  57     -60.849  14.597 -21.298  1.00 23.49           C  
ATOM   1199  CG  ARG B  57     -59.617  14.655 -20.376  1.00 17.27           C  
ATOM   1200  CD  ARG B  57     -59.849  15.588 -19.185  1.00 18.74           C  
ATOM   1201  NE  ARG B  57     -60.827  15.018 -18.264  1.00 25.23           N  
ATOM   1202  CZ  ARG B  57     -61.239  15.594 -17.136  1.00 34.38           C  
ATOM   1203  NH1 ARG B  57     -60.769  16.790 -16.763  1.00 29.18           N  
ATOM   1204  NH2 ARG B  57     -62.110  14.957 -16.363  1.00 30.01           N  
ATOM   1205  N   LEU B  58     -59.465  11.585 -22.607  1.00 22.41           N  
ATOM   1206  CA  LEU B  58     -59.217  10.176 -22.313  1.00 22.72           C  
ATOM   1207  C   LEU B  58     -58.115  10.115 -21.268  1.00 24.63           C  
ATOM   1208  O   LEU B  58     -57.067  10.701 -21.459  1.00 23.42           O  
ATOM   1209  CB  LEU B  58     -58.751   9.460 -23.590  1.00 23.22           C  
ATOM   1210  CG  LEU B  58     -58.318   7.991 -23.629  1.00 30.65           C  
ATOM   1211  CD1 LEU B  58     -57.111   7.739 -22.720  1.00 35.55           C  
ATOM   1212  CD2 LEU B  58     -59.485   7.132 -23.201  1.00 43.20           C  
ATOM   1213  N   GLU B  59     -58.349   9.395 -20.178  1.00 23.02           N  
ATOM   1214  CA  GLU B  59     -57.345   9.280 -19.132  1.00 23.71           C  
ATOM   1215  C   GLU B  59     -57.054   7.836 -18.836  1.00 25.00           C  
ATOM   1216  O   GLU B  59     -57.971   7.012 -18.767  1.00 21.94           O  
ATOM   1217  CB  GLU B  59     -57.846   9.911 -17.845  1.00 23.71           C  
ATOM   1218  CG  GLU B  59     -57.860  11.402 -17.831  1.00 33.55           C  
ATOM   1219  CD  GLU B  59     -58.606  11.890 -16.625  1.00 44.41           C  
ATOM   1220  OE1 GLU B  59     -58.463  13.062 -16.234  1.00 51.72           O  
ATOM   1221  OE2 GLU B  59     -59.355  11.071 -16.065  1.00 57.71           O  
ATOM   1222  N   THR B  60     -55.784   7.528 -18.611  1.00 22.15           N  
ATOM   1223  CA  THR B  60     -55.436   6.163 -18.298  1.00 21.62           C  
ATOM   1224  C   THR B  60     -54.309   6.103 -17.267  1.00 22.99           C  
ATOM   1225  O   THR B  60     -53.371   6.893 -17.309  1.00 19.65           O  
ATOM   1226  CB  THR B  60     -55.073   5.385 -19.600  1.00 27.93           C  
ATOM   1227  OG1 THR B  60     -54.823   4.018 -19.278  1.00 35.66           O  
ATOM   1228  CG2 THR B  60     -53.850   5.975 -20.289  1.00 28.14           C  
ATOM   1229  N   ILE B  61     -54.431   5.185 -16.317  1.00 20.28           N  
ATOM   1230  CA  ILE B  61     -53.408   5.012 -15.284  1.00 21.93           C  
ATOM   1231  C   ILE B  61     -52.437   3.917 -15.719  1.00 23.42           C  
ATOM   1232  O   ILE B  61     -52.840   2.775 -15.922  1.00 23.84           O  
ATOM   1233  CB  ILE B  61     -54.051   4.639 -13.949  1.00 24.44           C  
ATOM   1234  CG1 ILE B  61     -54.911   5.810 -13.459  1.00 29.49           C  
ATOM   1235  CG2 ILE B  61     -52.981   4.262 -12.939  1.00 20.07           C  
ATOM   1236  CD1 ILE B  61     -55.802   5.456 -12.307  1.00 36.37           C  
ATOM   1237  N   VAL B  62     -51.160   4.268 -15.848  1.00 20.53           N  
ATOM   1238  CA  VAL B  62     -50.144   3.328 -16.311  1.00 21.12           C  
ATOM   1239  C   VAL B  62     -48.845   3.527 -15.552  1.00 25.25           C  
ATOM   1240  O   VAL B  62     -48.714   4.467 -14.760  1.00 20.10           O  
ATOM   1241  CB  VAL B  62     -49.848   3.546 -17.819  1.00 25.42           C  
ATOM   1242  CG1 VAL B  62     -51.098   3.238 -18.650  1.00 27.19           C  
ATOM   1243  CG2 VAL B  62     -49.414   5.021 -18.059  1.00 20.94           C  
ATOM   1244  N   SER B  63     -47.890   2.631 -15.803  1.00 21.10           N  
ATOM   1245  CA  SER B  63     -46.557   2.682 -15.193  1.00 28.95           C  
ATOM   1246  C   SER B  63     -45.745   3.747 -15.941  1.00 25.86           C  
ATOM   1247  O   SER B  63     -46.142   4.183 -17.024  1.00 25.76           O  
ATOM   1248  CB  SER B  63     -45.851   1.333 -15.357  1.00 27.64           C  
ATOM   1249  OG  SER B  63     -45.488   1.162 -16.715  1.00 27.36           O  
ATOM   1250  N   GLU B  64     -44.607   4.147 -15.367  1.00 23.85           N  
ATOM   1251  CA  GLU B  64     -43.723   5.166 -15.966  1.00 31.42           C  
ATOM   1252  C   GLU B  64     -43.321   4.854 -17.393  1.00 35.39           C  
ATOM   1253  O   GLU B  64     -43.344   5.719 -18.268  1.00 32.30           O  
ATOM   1254  CB  GLU B  64     -42.432   5.309 -15.150  1.00 33.79           C  
ATOM   1255  CG  GLU B  64     -42.640   5.684 -13.711  1.00 44.88           C  
ATOM   1256  CD  GLU B  64     -41.383   5.498 -12.863  1.00 43.39           C  
ATOM   1257  OE1 GLU B  64     -40.698   4.458 -13.014  1.00 42.02           O  
ATOM   1258  OE2 GLU B  64     -41.097   6.387 -12.036  1.00 36.72           O  
ATOM   1259  N   GLU B  65     -42.914   3.609 -17.610  1.00 24.99           N  
ATOM   1260  CA  GLU B  65     -42.478   3.153 -18.920  1.00 36.62           C  
ATOM   1261  C   GLU B  65     -43.604   3.175 -19.966  1.00 29.92           C  
ATOM   1262  O   GLU B  65     -43.417   3.638 -21.093  1.00 28.12           O  
ATOM   1263  CB  GLU B  65     -41.894   1.737 -18.786  1.00 42.81           C  
ATOM   1264  CG  GLU B  65     -40.728   1.639 -17.772  1.00 63.24           C  
ATOM   1265  CD  GLU B  65     -41.140   1.082 -16.397  1.00 75.10           C  
ATOM   1266  OE1 GLU B  65     -42.037   1.661 -15.737  1.00 70.81           O  
ATOM   1267  OE2 GLU B  65     -40.556   0.057 -15.972  1.00 83.92           O  
ATOM   1268  N   VAL B  66     -44.763   2.649 -19.599  1.00 27.16           N  
ATOM   1269  CA  VAL B  66     -45.894   2.638 -20.507  1.00 32.22           C  
ATOM   1270  C   VAL B  66     -46.335   4.070 -20.819  1.00 31.77           C  
ATOM   1271  O   VAL B  66     -46.731   4.372 -21.950  1.00 28.03           O  
ATOM   1272  CB  VAL B  66     -47.079   1.852 -19.912  1.00 34.30           C  
ATOM   1273  CG1 VAL B  66     -48.322   2.046 -20.771  1.00 30.88           C  
ATOM   1274  CG2 VAL B  66     -46.717   0.362 -19.832  1.00 39.33           C  
ATOM   1275  N   ALA B  67     -46.246   4.958 -19.830  1.00 25.29           N  
ATOM   1276  CA  ALA B  67     -46.648   6.344 -20.062  1.00 26.40           C  
ATOM   1277  C   ALA B  67     -45.846   6.955 -21.194  1.00 21.62           C  
ATOM   1278  O   ALA B  67     -46.416   7.553 -22.109  1.00 23.10           O  
ATOM   1279  CB  ALA B  67     -46.470   7.192 -18.776  1.00 21.33           C  
ATOM   1280  N   LEU B  68     -44.523   6.805 -21.152  1.00 23.79           N  
ATOM   1281  CA  LEU B  68     -43.685   7.400 -22.186  1.00 24.37           C  
ATOM   1282  C   LEU B  68     -43.871   6.700 -23.533  1.00 23.47           C  
ATOM   1283  O   LEU B  68     -43.685   7.318 -24.572  1.00 23.15           O  
ATOM   1284  CB  LEU B  68     -42.197   7.400 -21.768  1.00 28.21           C  
ATOM   1285  CG  LEU B  68     -41.688   8.360 -20.663  1.00 38.54           C  
ATOM   1286  CD1 LEU B  68     -40.564   9.212 -21.216  1.00 38.36           C  
ATOM   1287  CD2 LEU B  68     -42.787   9.279 -20.139  1.00 30.92           C  
ATOM   1288  N   ARG B  69     -44.238   5.425 -23.514  1.00 24.26           N  
ATOM   1289  CA  ARG B  69     -44.477   4.690 -24.754  1.00 29.33           C  
ATOM   1290  C   ARG B  69     -45.684   5.300 -25.429  1.00 26.64           C  
ATOM   1291  O   ARG B  69     -45.699   5.538 -26.640  1.00 25.44           O  
ATOM   1292  CB  ARG B  69     -44.771   3.217 -24.476  1.00 35.31           C  
ATOM   1293  CG  ARG B  69     -43.536   2.348 -24.477  1.00 51.95           C  
ATOM   1294  CD  ARG B  69     -43.771   1.086 -25.293  1.00 63.18           C  
ATOM   1295  NE  ARG B  69     -44.743   0.191 -24.669  1.00 74.84           N  
ATOM   1296  CZ  ARG B  69     -44.573  -0.394 -23.485  1.00 77.85           C  
ATOM   1297  NH1 ARG B  69     -43.465  -0.178 -22.781  1.00 80.28           N  
ATOM   1298  NH2 ARG B  69     -45.504  -1.210 -23.006  1.00 71.14           N  
ATOM   1299  N   ILE B  70     -46.709   5.560 -24.629  1.00 25.24           N  
ATOM   1300  CA  ILE B  70     -47.923   6.160 -25.147  1.00 22.60           C  
ATOM   1301  C   ILE B  70     -47.667   7.569 -25.662  1.00 22.17           C  
ATOM   1302  O   ILE B  70     -48.089   7.930 -26.760  1.00 26.01           O  
ATOM   1303  CB  ILE B  70     -49.011   6.225 -24.055  1.00 21.27           C  
ATOM   1304  CG1 ILE B  70     -49.440   4.806 -23.683  1.00 25.33           C  
ATOM   1305  CG2 ILE B  70     -50.215   7.068 -24.554  1.00 18.89           C  
ATOM   1306  CD1 ILE B  70     -50.383   4.732 -22.508  1.00 25.26           C  
ATOM   1307  N   LEU B  71     -46.977   8.379 -24.871  1.00 19.60           N  
ATOM   1308  CA  LEU B  71     -46.735   9.755 -25.281  1.00 21.45           C  
ATOM   1309  C   LEU B  71     -45.909   9.816 -26.552  1.00 21.66           C  
ATOM   1310  O   LEU B  71     -46.179  10.635 -27.433  1.00 21.83           O  
ATOM   1311  CB  LEU B  71     -46.043  10.534 -24.145  1.00 18.75           C  
ATOM   1312  CG  LEU B  71     -46.903  10.595 -22.870  1.00 23.15           C  
ATOM   1313  CD1 LEU B  71     -46.075  11.200 -21.761  1.00 25.52           C  
ATOM   1314  CD2 LEU B  71     -48.177  11.407 -23.093  1.00 24.02           C  
ATOM   1315  N   GLN B  72     -44.894   8.963 -26.640  1.00 22.15           N  
ATOM   1316  CA  GLN B  72     -44.058   8.944 -27.838  1.00 27.37           C  
ATOM   1317  C   GLN B  72     -44.879   8.530 -29.071  1.00 21.61           C  
ATOM   1318  O   GLN B  72     -44.724   9.101 -30.148  1.00 27.99           O  
ATOM   1319  CB  GLN B  72     -42.895   7.980 -27.642  1.00 29.96           C  
ATOM   1320  CG  GLN B  72     -42.006   7.861 -28.862  1.00 39.94           C  
ATOM   1321  CD  GLN B  72     -40.742   7.072 -28.565  1.00 58.85           C  
ATOM   1322  OE1 GLN B  72     -39.637   7.626 -28.570  1.00 62.80           O  
ATOM   1323  NE2 GLN B  72     -40.899   5.776 -28.288  1.00 53.62           N  
ATOM   1324  N   ARG B  73     -45.733   7.526 -28.908  1.00 24.31           N  
ATOM   1325  CA  ARG B  73     -46.590   7.058 -30.002  1.00 26.91           C  
ATOM   1326  C   ARG B  73     -47.527   8.197 -30.445  1.00 27.55           C  
ATOM   1327  O   ARG B  73     -47.695   8.436 -31.643  1.00 25.45           O  
ATOM   1328  CB  ARG B  73     -47.385   5.832 -29.538  1.00 29.86           C  
ATOM   1329  CG  ARG B  73     -48.426   5.300 -30.518  1.00 37.06           C  
ATOM   1330  CD  ARG B  73     -47.793   4.870 -31.827  1.00 47.11           C  
ATOM   1331  NE  ARG B  73     -46.682   3.934 -31.657  1.00 51.36           N  
ATOM   1332  CZ  ARG B  73     -46.810   2.631 -31.408  1.00 59.04           C  
ATOM   1333  NH1 ARG B  73     -48.018   2.084 -31.299  1.00 54.59           N  
ATOM   1334  NH2 ARG B  73     -45.725   1.872 -31.272  1.00 50.40           N  
ATOM   1335  N   LEU B  74     -48.124   8.921 -29.493  1.00 25.21           N  
ATOM   1336  CA  LEU B  74     -48.996  10.051 -29.856  1.00 26.33           C  
ATOM   1337  C   LEU B  74     -48.214  11.150 -30.589  1.00 25.90           C  
ATOM   1338  O   LEU B  74     -48.676  11.701 -31.601  1.00 26.18           O  
ATOM   1339  CB  LEU B  74     -49.674  10.657 -28.603  1.00 26.43           C  
ATOM   1340  CG  LEU B  74     -50.703   9.773 -27.888  1.00 28.37           C  
ATOM   1341  CD1 LEU B  74     -51.018  10.349 -26.508  1.00 26.76           C  
ATOM   1342  CD2 LEU B  74     -51.980   9.668 -28.747  1.00 28.14           C  
ATOM   1343  N   GLN B  75     -47.039  11.496 -30.076  1.00 21.04           N  
ATOM   1344  CA  GLN B  75     -46.230  12.537 -30.712  1.00 23.15           C  
ATOM   1345  C   GLN B  75     -45.855  12.170 -32.163  1.00 27.89           C  
ATOM   1346  O   GLN B  75     -45.849  13.008 -33.074  1.00 30.19           O  
ATOM   1347  CB  GLN B  75     -44.925  12.752 -29.938  1.00 26.38           C  
ATOM   1348  CG  GLN B  75     -44.003  13.800 -30.583  1.00 25.88           C  
ATOM   1349  CD  GLN B  75     -42.665  13.897 -29.876  1.00 37.27           C  
ATOM   1350  OE1 GLN B  75     -42.607  14.034 -28.661  1.00 36.63           O  
ATOM   1351  NE2 GLN B  75     -41.583  13.824 -30.637  1.00 32.76           N  
ATOM   1352  N   GLU B  76     -45.515  10.905 -32.338  1.00 25.12           N  
ATOM   1353  CA  GLU B  76     -45.104  10.376 -33.627  1.00 40.18           C  
ATOM   1354  C   GLU B  76     -46.234  10.175 -34.629  1.00 36.52           C  
ATOM   1355  O   GLU B  76     -46.146  10.648 -35.758  1.00 33.32           O  
ATOM   1356  CB  GLU B  76     -44.383   9.039 -33.412  1.00 45.55           C  
ATOM   1357  CG  GLU B  76     -44.119   8.251 -34.681  1.00 74.38           C  
ATOM   1358  CD  GLU B  76     -43.724   6.802 -34.407  1.00 88.03           C  
ATOM   1359  OE1 GLU B  76     -44.542   6.060 -33.815  1.00 93.01           O  
ATOM   1360  OE2 GLU B  76     -42.598   6.407 -34.787  1.00 94.25           O  
ATOM   1361  N   GLU B  77     -47.291   9.487 -34.203  1.00 38.74           N  
ATOM   1362  CA  GLU B  77     -48.405   9.148 -35.085  1.00 39.76           C  
ATOM   1363  C   GLU B  77     -49.641  10.038 -35.123  1.00 37.87           C  
ATOM   1364  O   GLU B  77     -50.331  10.075 -36.137  1.00 38.79           O  
ATOM   1365  CB  GLU B  77     -48.870   7.721 -34.784  1.00 45.19           C  
ATOM   1366  CG  GLU B  77     -47.791   6.657 -34.924  1.00 65.10           C  
ATOM   1367  CD  GLU B  77     -48.308   5.251 -34.630  1.00 75.27           C  
ATOM   1368  OE1 GLU B  77     -47.535   4.274 -34.773  1.00 75.71           O  
ATOM   1369  OE2 GLU B  77     -49.492   5.122 -34.246  1.00 82.13           O  
ATOM   1370  N   TYR B  78     -49.928  10.754 -34.042  1.00 29.43           N  
ATOM   1371  CA  TYR B  78     -51.138  11.571 -34.007  1.00 28.01           C  
ATOM   1372  C   TYR B  78     -50.947  13.060 -34.051  1.00 26.84           C  
ATOM   1373  O   TYR B  78     -51.672  13.762 -34.761  1.00 26.65           O  
ATOM   1374  CB  TYR B  78     -51.964  11.205 -32.776  1.00 28.13           C  
ATOM   1375  CG  TYR B  78     -52.478   9.799 -32.823  1.00 27.30           C  
ATOM   1376  CD1 TYR B  78     -51.630   8.717 -32.598  1.00 28.55           C  
ATOM   1377  CD2 TYR B  78     -53.811   9.541 -33.126  1.00 34.23           C  
ATOM   1378  CE1 TYR B  78     -52.099   7.410 -32.671  1.00 35.32           C  
ATOM   1379  CE2 TYR B  78     -54.288   8.240 -33.206  1.00 37.06           C  
ATOM   1380  CZ  TYR B  78     -53.432   7.181 -32.976  1.00 39.16           C  
ATOM   1381  OH  TYR B  78     -53.925   5.898 -33.048  1.00 46.49           O  
ATOM   1382  N   PHE B  79     -49.972  13.553 -33.298  1.00 24.60           N  
ATOM   1383  CA  PHE B  79     -49.714  14.975 -33.260  1.00 22.89           C  
ATOM   1384  C   PHE B  79     -49.504  15.665 -34.620  1.00 29.19           C  
ATOM   1385  O   PHE B  79     -49.970  16.778 -34.832  1.00 26.31           O  
ATOM   1386  CB  PHE B  79     -48.507  15.263 -32.356  1.00 28.22           C  
ATOM   1387  CG  PHE B  79     -48.879  15.535 -30.916  1.00 24.13           C  
ATOM   1388  CD1 PHE B  79     -49.381  14.522 -30.103  1.00 22.97           C  
ATOM   1389  CD2 PHE B  79     -48.767  16.822 -30.395  1.00 26.76           C  
ATOM   1390  CE1 PHE B  79     -49.773  14.787 -28.782  1.00 25.44           C  
ATOM   1391  CE2 PHE B  79     -49.154  17.101 -29.086  1.00 26.89           C  
ATOM   1392  CZ  PHE B  79     -49.658  16.081 -28.280  1.00 18.64           C  
ATOM   1393  N   PRO B  80     -48.808  15.019 -35.565  1.00 25.51           N  
ATOM   1394  CA  PRO B  80     -48.651  15.766 -36.816  1.00 29.20           C  
ATOM   1395  C   PRO B  80     -49.936  15.970 -37.623  1.00 29.15           C  
ATOM   1396  O   PRO B  80     -50.103  16.992 -38.285  1.00 34.39           O  
ATOM   1397  CB  PRO B  80     -47.613  14.941 -37.588  1.00 29.57           C  
ATOM   1398  CG  PRO B  80     -46.848  14.210 -36.477  1.00 29.03           C  
ATOM   1399  CD  PRO B  80     -47.973  13.805 -35.557  1.00 25.78           C  
ATOM   1400  N   HIS B  81     -50.854  15.014 -37.533  1.00 27.02           N  
ATOM   1401  CA  HIS B  81     -52.084  15.059 -38.322  1.00 24.32           C  
ATOM   1402  C   HIS B  81     -53.383  15.504 -37.659  1.00 31.48           C  
ATOM   1403  O   HIS B  81     -54.367  15.761 -38.362  1.00 26.19           O  
ATOM   1404  CB  HIS B  81     -52.302  13.677 -38.932  1.00 29.55           C  
ATOM   1405  CG  HIS B  81     -51.065  13.112 -39.548  1.00 31.97           C  
ATOM   1406  ND1 HIS B  81     -50.449  11.976 -39.070  1.00 38.41           N  
ATOM   1407  CD2 HIS B  81     -50.295  13.562 -40.565  1.00 34.26           C  
ATOM   1408  CE1 HIS B  81     -49.350  11.751 -39.768  1.00 34.65           C  
ATOM   1409  NE2 HIS B  81     -49.233  12.698 -40.680  1.00 39.43           N  
ATOM   1410  N   TYR B  82     -53.396  15.587 -36.328  1.00 22.44           N  
ATOM   1411  CA  TYR B  82     -54.601  15.973 -35.596  1.00 24.05           C  
ATOM   1412  C   TYR B  82     -54.336  16.979 -34.490  1.00 26.64           C  
ATOM   1413  O   TYR B  82     -53.192  17.181 -34.093  1.00 26.16           O  
ATOM   1414  CB  TYR B  82     -55.226  14.724 -34.988  1.00 24.23           C  
ATOM   1415  CG  TYR B  82     -55.605  13.698 -36.011  1.00 31.51           C  
ATOM   1416  CD1 TYR B  82     -56.732  13.879 -36.807  1.00 37.55           C  
ATOM   1417  CD2 TYR B  82     -54.833  12.552 -36.211  1.00 39.52           C  
ATOM   1418  CE1 TYR B  82     -57.087  12.960 -37.772  1.00 35.32           C  
ATOM   1419  CE2 TYR B  82     -55.183  11.613 -37.187  1.00 38.83           C  
ATOM   1420  CZ  TYR B  82     -56.317  11.832 -37.964  1.00 38.71           C  
ATOM   1421  OH  TYR B  82     -56.699  10.946 -38.950  1.00 41.03           O  
ATOM   1422  N   ALA B  83     -55.400  17.619 -34.008  1.00 26.25           N  
ATOM   1423  CA  ALA B  83     -55.293  18.570 -32.907  1.00 29.46           C  
ATOM   1424  C   ALA B  83     -55.391  17.656 -31.677  1.00 25.57           C  
ATOM   1425  O   ALA B  83     -56.454  17.141 -31.357  1.00 26.39           O  
ATOM   1426  CB  ALA B  83     -56.459  19.558 -32.934  1.00 24.46           C  
ATOM   1427  N   VAL B  84     -54.264  17.443 -31.014  1.00 22.82           N  
ATOM   1428  CA  VAL B  84     -54.221  16.560 -29.852  1.00 19.95           C  
ATOM   1429  C   VAL B  84     -53.492  17.240 -28.712  1.00 22.36           C  
ATOM   1430  O   VAL B  84     -52.552  17.994 -28.939  1.00 21.86           O  
ATOM   1431  CB  VAL B  84     -53.429  15.253 -30.168  1.00 23.14           C  
ATOM   1432  CG1 VAL B  84     -53.455  14.317 -28.969  1.00 26.53           C  
ATOM   1433  CG2 VAL B  84     -54.020  14.562 -31.384  1.00 29.25           C  
ATOM   1434  N   ILE B  85     -53.927  16.964 -27.488  1.00 21.29           N  
ATOM   1435  CA  ILE B  85     -53.252  17.501 -26.314  1.00 21.20           C  
ATOM   1436  C   ILE B  85     -52.894  16.252 -25.530  1.00 19.92           C  
ATOM   1437  O   ILE B  85     -53.721  15.358 -25.400  1.00 17.03           O  
ATOM   1438  CB  ILE B  85     -54.188  18.344 -25.460  1.00 24.37           C  
ATOM   1439  CG1 ILE B  85     -54.672  19.551 -26.265  1.00 27.79           C  
ATOM   1440  CG2 ILE B  85     -53.473  18.760 -24.159  1.00 26.74           C  
ATOM   1441  CD1 ILE B  85     -55.758  20.334 -25.535  1.00 33.65           C  
ATOM   1442  N   ALA B  86     -51.671  16.170 -25.023  1.00 17.20           N  
ATOM   1443  CA  ALA B  86     -51.304  14.994 -24.253  1.00 19.40           C  
ATOM   1444  C   ALA B  86     -50.339  15.375 -23.166  1.00 16.00           C  
ATOM   1445  O   ALA B  86     -49.367  16.095 -23.398  1.00 16.80           O  
ATOM   1446  CB  ALA B  86     -50.682  13.933 -25.158  1.00 15.14           C  
ATOM   1447  N   TYR B  87     -50.606  14.896 -21.958  1.00 18.18           N  
ATOM   1448  CA  TYR B  87     -49.734  15.215 -20.859  1.00 16.83           C  
ATOM   1449  C   TYR B  87     -49.801  14.129 -19.805  1.00 18.41           C  
ATOM   1450  O   TYR B  87     -50.656  13.228 -19.858  1.00 20.37           O  
ATOM   1451  CB  TYR B  87     -50.079  16.598 -20.266  1.00 13.16           C  
ATOM   1452  CG  TYR B  87     -51.510  16.774 -19.811  1.00 16.91           C  
ATOM   1453  CD1 TYR B  87     -52.479  17.299 -20.672  1.00 19.09           C  
ATOM   1454  CD2 TYR B  87     -51.885  16.461 -18.507  1.00 19.72           C  
ATOM   1455  CE1 TYR B  87     -53.797  17.510 -20.237  1.00 21.47           C  
ATOM   1456  CE2 TYR B  87     -53.193  16.673 -18.058  1.00 21.26           C  
ATOM   1457  CZ  TYR B  87     -54.140  17.196 -18.929  1.00 25.67           C  
ATOM   1458  OH  TYR B  87     -55.419  17.401 -18.480  1.00 25.46           O  
ATOM   1459  N   VAL B  88     -48.897  14.207 -18.840  1.00 18.03           N  
ATOM   1460  CA  VAL B  88     -48.833  13.166 -17.825  1.00 19.04           C  
ATOM   1461  C   VAL B  88     -48.643  13.754 -16.437  1.00 20.88           C  
ATOM   1462  O   VAL B  88     -47.951  14.762 -16.268  1.00 17.01           O  
ATOM   1463  CB  VAL B  88     -47.688  12.156 -18.179  1.00 18.22           C  
ATOM   1464  CG1 VAL B  88     -46.348  12.879 -18.248  1.00 20.37           C  
ATOM   1465  CG2 VAL B  88     -47.628  11.030 -17.144  1.00 17.25           C  
ATOM   1466  N   GLU B  89     -49.289  13.129 -15.450  1.00 18.16           N  
ATOM   1467  CA  GLU B  89     -49.226  13.584 -14.058  1.00 21.99           C  
ATOM   1468  C   GLU B  89     -48.826  12.426 -13.164  1.00 25.03           C  
ATOM   1469  O   GLU B  89     -49.017  11.261 -13.517  1.00 17.48           O  
ATOM   1470  CB  GLU B  89     -50.607  14.075 -13.589  1.00 22.59           C  
ATOM   1471  CG  GLU B  89     -51.073  15.372 -14.196  1.00 37.64           C  
ATOM   1472  CD  GLU B  89     -52.549  15.639 -13.931  1.00 44.98           C  
ATOM   1473  OE1 GLU B  89     -53.390  14.911 -14.494  1.00 44.24           O  
ATOM   1474  OE2 GLU B  89     -52.867  16.572 -13.159  1.00 56.66           O  
ATOM   1475  N   ASN B  90     -48.289  12.758 -11.995  1.00 19.29           N  
ATOM   1476  CA  ASN B  90     -47.891  11.755 -11.007  1.00 19.11           C  
ATOM   1477  C   ASN B  90     -49.094  11.493 -10.082  1.00 19.41           C  
ATOM   1478  O   ASN B  90     -49.745  12.430  -9.614  1.00 20.20           O  
ATOM   1479  CB  ASN B  90     -46.715  12.287 -10.182  1.00 22.50           C  
ATOM   1480  CG  ASN B  90     -46.089  11.227  -9.320  1.00 24.43           C  
ATOM   1481  OD1 ASN B  90     -45.705  10.165  -9.814  1.00 20.07           O  
ATOM   1482  ND2 ASN B  90     -45.965  11.506  -8.025  1.00 22.06           N  
ATOM   1483  N   VAL B  91     -49.405  10.219  -9.837  1.00 20.31           N  
ATOM   1484  CA  VAL B  91     -50.520   9.878  -8.964  1.00 17.74           C  
ATOM   1485  C   VAL B  91     -50.197   8.666  -8.092  1.00 19.46           C  
ATOM   1486  O   VAL B  91     -49.351   7.869  -8.436  1.00 21.09           O  
ATOM   1487  CB  VAL B  91     -51.818   9.527  -9.759  1.00 19.49           C  
ATOM   1488  CG1 VAL B  91     -52.385  10.777 -10.442  1.00 22.74           C  
ATOM   1489  CG2 VAL B  91     -51.516   8.425 -10.795  1.00 14.65           C  
ATOM   1490  N   TRP B  92     -50.887   8.557  -6.960  1.00 15.49           N  
ATOM   1491  CA  TRP B  92     -50.736   7.403  -6.084  1.00 21.74           C  
ATOM   1492  C   TRP B  92     -52.113   6.759  -6.146  1.00 19.93           C  
ATOM   1493  O   TRP B  92     -53.126   7.404  -5.883  1.00 18.80           O  
ATOM   1494  CB  TRP B  92     -50.362   7.840  -4.679  1.00 19.39           C  
ATOM   1495  CG  TRP B  92     -48.911   8.132  -4.607  1.00 18.64           C  
ATOM   1496  CD1 TRP B  92     -48.252   9.192  -5.193  1.00 17.96           C  
ATOM   1497  CD2 TRP B  92     -47.906   7.338  -3.959  1.00 21.71           C  
ATOM   1498  NE1 TRP B  92     -46.890   9.090  -4.942  1.00 20.89           N  
ATOM   1499  CE2 TRP B  92     -46.657   7.969  -4.188  1.00 20.51           C  
ATOM   1500  CE3 TRP B  92     -47.934   6.149  -3.203  1.00 17.97           C  
ATOM   1501  CZ2 TRP B  92     -45.453   7.455  -3.691  1.00 23.40           C  
ATOM   1502  CZ3 TRP B  92     -46.730   5.642  -2.712  1.00 24.41           C  
ATOM   1503  CH2 TRP B  92     -45.510   6.297  -2.956  1.00 25.00           C  
ATOM   1504  N   VAL B  93     -52.129   5.481  -6.498  1.00 20.89           N  
ATOM   1505  CA  VAL B  93     -53.375   4.749  -6.749  1.00 20.72           C  
ATOM   1506  C   VAL B  93     -53.680   3.588  -5.799  1.00 21.76           C  
ATOM   1507  O   VAL B  93     -52.798   2.787  -5.483  1.00 23.17           O  
ATOM   1508  CB  VAL B  93     -53.298   4.212  -8.203  1.00 23.92           C  
ATOM   1509  CG1 VAL B  93     -54.616   3.561  -8.639  1.00 21.85           C  
ATOM   1510  CG2 VAL B  93     -52.867   5.365  -9.130  1.00 19.74           C  
ATOM   1511  N   VAL B  94     -54.930   3.498  -5.359  1.00 23.82           N  
ATOM   1512  CA  VAL B  94     -55.354   2.405  -4.472  1.00 30.31           C  
ATOM   1513  C   VAL B  94     -55.351   1.108  -5.285  1.00 30.52           C  
ATOM   1514  O   VAL B  94     -55.930   1.050  -6.378  1.00 29.72           O  
ATOM   1515  CB  VAL B  94     -56.767   2.659  -3.903  1.00 29.10           C  
ATOM   1516  CG1 VAL B  94     -57.268   1.419  -3.114  1.00 25.83           C  
ATOM   1517  CG2 VAL B  94     -56.738   3.874  -2.982  1.00 24.09           C  
ATOM   1518  N   ARG B  95     -54.679   0.079  -4.761  1.00 29.99           N  
ATOM   1519  CA  ARG B  95     -54.578  -1.228  -5.430  1.00 32.08           C  
ATOM   1520  C   ARG B  95     -54.065  -1.044  -6.844  1.00 33.05           C  
ATOM   1521  O   ARG B  95     -54.424  -1.792  -7.760  1.00 29.86           O  
ATOM   1522  CB  ARG B  95     -55.943  -1.938  -5.480  1.00 29.82           C  
ATOM   1523  CG  ARG B  95     -56.592  -2.205  -4.124  1.00 40.96           C  
ATOM   1524  CD  ARG B  95     -55.842  -3.254  -3.300  1.00 48.76           C  
ATOM   1525  NE  ARG B  95     -56.609  -3.658  -2.120  1.00 53.36           N  
ATOM   1526  CZ  ARG B  95     -56.102  -4.300  -1.066  1.00 57.16           C  
ATOM   1527  NH1 ARG B  95     -54.812  -4.618  -1.027  1.00 50.70           N  
ATOM   1528  NH2 ARG B  95     -56.890  -4.627  -0.046  1.00 52.77           N  
ATOM   1529  N   GLY B  96     -53.205  -0.051  -7.024  1.00 29.87           N  
ATOM   1530  CA  GLY B  96     -52.687   0.220  -8.351  1.00 26.60           C  
ATOM   1531  C   GLY B  96     -51.839  -0.866  -8.971  1.00 31.43           C  
ATOM   1532  O   GLY B  96     -51.601  -0.829 -10.172  1.00 25.27           O  
ATOM   1533  N   GLU B  97     -51.372  -1.824  -8.170  1.00 32.54           N  
ATOM   1534  CA  GLU B  97     -50.541  -2.913  -8.692  1.00 34.65           C  
ATOM   1535  C   GLU B  97     -51.124  -3.495  -9.970  1.00 36.62           C  
ATOM   1536  O   GLU B  97     -50.393  -3.849 -10.905  1.00 38.29           O  
ATOM   1537  CB  GLU B  97     -50.396  -4.034  -7.656  1.00 37.21           C  
ATOM   1538  CG  GLU B  97     -49.610  -3.665  -6.397  1.00 36.26           C  
ATOM   1539  CD  GLU B  97     -50.462  -2.969  -5.345  1.00 50.50           C  
ATOM   1540  OE1 GLU B  97     -49.970  -2.800  -4.208  1.00 48.80           O  
ATOM   1541  OE2 GLU B  97     -51.621  -2.594  -5.644  1.00 49.03           O  
ATOM   1542  N   LYS B  98     -52.449  -3.574 -10.011  1.00 35.86           N  
ATOM   1543  CA  LYS B  98     -53.162  -4.116 -11.170  1.00 37.98           C  
ATOM   1544  C   LYS B  98     -52.892  -3.376 -12.495  1.00 41.36           C  
ATOM   1545  O   LYS B  98     -52.924  -3.995 -13.560  1.00 38.62           O  
ATOM   1546  CB  LYS B  98     -54.673  -4.108 -10.896  1.00 38.38           C  
ATOM   1547  CG  LYS B  98     -55.309  -2.727 -10.976  1.00 41.77           C  
ATOM   1548  CD  LYS B  98     -56.812  -2.761 -10.735  1.00 41.38           C  
ATOM   1549  CE  LYS B  98     -57.131  -2.801  -9.257  1.00 49.74           C  
ATOM   1550  NZ  LYS B  98     -58.592  -2.626  -9.018  1.00 49.42           N  
ATOM   1551  N   TYR B  99     -52.617  -2.069 -12.442  1.00 32.25           N  
ATOM   1552  CA  TYR B  99     -52.397  -1.310 -13.677  1.00 36.07           C  
ATOM   1553  C   TYR B  99     -51.004  -1.454 -14.253  1.00 35.85           C  
ATOM   1554  O   TYR B  99     -50.743  -1.004 -15.367  1.00 35.20           O  
ATOM   1555  CB  TYR B  99     -52.677   0.174 -13.438  1.00 32.08           C  
ATOM   1556  CG  TYR B  99     -54.104   0.452 -13.075  1.00 29.77           C  
ATOM   1557  CD1 TYR B  99     -55.110   0.373 -14.036  1.00 33.92           C  
ATOM   1558  CD2 TYR B  99     -54.458   0.763 -11.765  1.00 30.10           C  
ATOM   1559  CE1 TYR B  99     -56.444   0.600 -13.704  1.00 35.82           C  
ATOM   1560  CE2 TYR B  99     -55.796   0.990 -11.416  1.00 34.57           C  
ATOM   1561  CZ  TYR B  99     -56.780   0.907 -12.396  1.00 44.08           C  
ATOM   1562  OH  TYR B  99     -58.104   1.141 -12.074  1.00 45.38           O  
ATOM   1563  N   VAL B 100     -50.106  -2.058 -13.487  1.00 38.10           N  
ATOM   1564  CA  VAL B 100     -48.743  -2.245 -13.938  1.00 48.65           C  
ATOM   1565  C   VAL B 100     -48.680  -3.375 -14.951  1.00 57.81           C  
ATOM   1566  O   VAL B 100     -48.175  -3.122 -16.069  1.00 67.41           O  
ATOM   1567  CB  VAL B 100     -47.813  -2.562 -12.761  1.00 49.19           C  
ATOM   1568  CG1 VAL B 100     -46.431  -2.908 -13.270  1.00 55.63           C  
ATOM   1569  CG2 VAL B 100     -47.740  -1.364 -11.833  1.00 51.71           C  
ATOM   1570  OXT VAL B 100     -49.140  -4.491 -14.617  1.00 63.12           O  
TER    1571      VAL B 100                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
