
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   96 (  750),  selected   96 , name 1ufl_B
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 1ufl_B.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      K       3           -
LGA    -       -      R       4           -
LGA    M     1_B      A       5          1.493
LGA    K     2_B      N       6          0.473
LGA    L     3_B      K       7          0.382
LGA    I     4_B      L       8          0.725
LGA    V     5_B      V       9          1.005
LGA    A     6_B      I      10          0.862
LGA    I     7_B      V      11          0.297
LGA    V     8_B      T      12          1.008
LGA    R     9_B      E      13          0.712
LGA    P    10_B      K      14          0.943
LGA    E    11_B      V      15          0.961
LGA    K    12_B      L      16          1.189
LGA    L    13_B      L      17          1.255
LGA    N    14_B      K      18          0.871
LGA    E    15_B      K      19          0.912
LGA    V    16_B      V      20          0.829
LGA    L    17_B      A      21          0.839
LGA    K    18_B      K      22          1.076
LGA    A    19_B      I      23          1.161
LGA    L    20_B      I      24          1.216
LGA    F    21_B      E      25          1.438
LGA    Q    22_B      E      26          1.134
LGA    A    23_B      A      27          0.780
LGA    E    24_B      G      28          0.858
LGA    V    25_B      A      29          1.042
LGA    R    26_B      T      30          1.940
LGA    G    27_B      G      31          0.475
LGA    L    28_B      Y      32          0.356
LGA    T    29_B      T      33          0.360
LGA    L    30_B      V      34          0.462
LGA    S    31_B      V      35          0.640
LGA    R    32_B      D      36          0.284
LGA    V    33_B      T      37          0.313
LGA    Q    34_B      G      38          0.550
LGA    G    35_B      G      39          1.846
LGA    H    36_B      -       -           -
LGA    E    54_B      -       -           -
LGA    L    55_B      -       -           -
LGA    H    56_B      -       -           -
LGA    E    57_B      S      58          0.252
LGA    K    58_B      N      59          0.158
LGA    V    59_B      V      60          0.154
LGA    R    60_B      K      61          0.638
LGA    L    61_B      F      62          0.574
LGA    E    62_B      E      63          0.425
LGA    I    63_B      V      64          0.313
LGA    G    64_B      L      65          0.378
LGA    V    65_B      T      66          0.548
LGA    S    66_B      E      67          2.393
LGA    E    67_B      N      68          2.177
LGA    -       -      R      69           -
LGA    P    68_B      E      70          3.240
LGA    F    69_B      M      71          1.204
LGA    V    70_B      A      72          1.772
LGA    K    71_B      E      73          1.582
LGA    P    72_B      K      74          0.949
LGA    T    73_B      I      75          1.636
LGA    V    74_B      A      76          1.084
LGA    E    75_B      D      77          1.218
LGA    A    76_B      Q      78          2.115
LGA    I    77_B      V      79          1.980
LGA    L    78_B      A      80          1.283
LGA    K    79_B      I      81          2.983
LGA    A    80_B      K      82          3.902
LGA    A    81_B      F      83          3.171
LGA    R    82_B      F      84          2.031
LGA    T    83_B      T      85          4.361
LGA    G    84_B      D      86          2.547
LGA    E    85_B      Y      87          5.097
LGA    V    86_B      -       -           -
LGA    G    87_B      -       -           -
LGA    D    88_B      A      88          0.971
LGA    G    89_B      G      89          1.040
LGA    K    90_B      I      90          0.370
LGA    I    91_B      I      91          0.620
LGA    F    92_B      Y      92          1.114
LGA    V    93_B      I      93          0.584
LGA    L    94_B      C      94          0.810
LGA    P    95_B      E      95          1.147
LGA    V    96_B      A      96          1.530
LGA    E    97_B      E      97          2.584
LGA    K    98_B      V      98          2.863
LGA    V    99_B      -       -           -
LGA    Y   100_B      L      99          3.519
LGA    R   101_B      Y     100          3.760
LGA    I   102_B      G     101          3.949
LGA    R   103_B      -       -           -
LGA    T   104_B      -       -           -
LGA    G   105_B      -       -           -
LGA    E   106_B      -       -           -
LGA    E   107_B      -       -           -
LGA    D   108_B      -       -           -
LGA    E   109_B      -       -           -
LGA    A   110_B      -       -           -
LGA    A   111_B      -       -           -
LGA    V   112_B      -       -           -
LGA    T   113_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   96   83    5.0     78    1.73    17.95     86.842     4.258

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.974472 * X  +  -0.221111 * Y  +   0.038928 * Z  + -82.504730
  Y_new =   0.158330 * X  +   0.799739 * Y  +   0.579093 * Z  +  -8.015865
  Z_new =  -0.159176 * X  +  -0.558146 * Y  +   0.814332 * Z  +  -2.275086 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.600863    2.540730  [ DEG:   -34.4269    145.5731 ]
  Theta =   0.159856    2.981737  [ DEG:     9.1591    170.8409 ]
  Phi   =   0.161070   -2.980523  [ DEG:     9.2286   -170.7714 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ufl_B                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ufl_B.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   96   83   5.0   78   1.73   17.95  86.842
REMARK  ---------------------------------------------------------- 
MOLECULE 1ufl_B
HEADER    SIGNALING PROTEIN                       31-MAY-03   1UFL              
TITLE     CRYSTAL STRUCTURE OF TT1020 FROM THERMUS THERMOPHILUS HB8             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NITROGEN REGULATORY PROTEIN P-II;                          
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET26B                                    
KEYWDS    STRUCTURAL GENOMICS, SIGNAL TRANSDUCING PROTEIN, RIKEN                
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI, NPPSFA,             
KEYWDS   3 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   4 ANALYSES                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.WANG,H.SAKAI,C.HORI-TAKEMOTO,T.KAMINISHI,T.TERADA,                  
AUTHOR   2 S.KURAMITSU,M.SHIROUZU,S.YOKOYAMA,RIKEN STRUCTURAL                   
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   4   14-NOV-06 1UFL    1       KEYWDS DBREF  SEQADV REMARK              
REVDAT   3   11-JAN-05 1UFL    1       JRNL                                     
REVDAT   2   10-FEB-04 1UFL    1       SHEET                                    
REVDAT   1   30-NOV-03 1UFL    0                                                
JRNL        AUTH   H.SAKAI,H.WANG,C.TAKEMOTO-HORI,T.KAMINISHI,                  
JRNL        AUTH 2 H.YAMAGUCHI,Y.KAMEWARI,T.TERADA,S.KURAMITSU,                 
JRNL        AUTH 3 M.SHIROUZU,S.YOKOYAMA                                        
JRNL        TITL   CRYSTAL STRUCTURES OF THE SIGNAL TRANSDUCING                 
JRNL        TITL 2 PROTEIN GLNK FROM THERMUS THERMOPHILUS HB8.                  
JRNL        REF    J.STRUCT.BIOL.                V. 149    99 2005              
JRNL        REFN   ASTM JSBIEM  US ISSN 1047-8477                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1UFL A    1   116  UNP    P83820   P83820_THETH     1    116             
DBREF  1UFL B    1   116  UNP    P83820   P83820_THETH     1    116             
DBREF  1UFL C    1   116  UNP    P83820   P83820_THETH     1    116             
SEQRES   1 A  116  MET LYS LEU ILE VAL ALA ILE VAL ARG PRO GLU LYS LEU          
SEQRES   2 A  116  ASN GLU VAL LEU LYS ALA LEU PHE GLN ALA GLU VAL ARG          
SEQRES   3 A  116  GLY LEU THR LEU SER ARG VAL GLN GLY HIS GLY GLY GLU          
SEQRES   4 A  116  THR GLU ARG VAL GLU THR TYR ARG GLY THR THR VAL LYS          
SEQRES   5 A  116  MET GLU LEU HIS GLU LYS VAL ARG LEU GLU ILE GLY VAL          
SEQRES   6 A  116  SER GLU PRO PHE VAL LYS PRO THR VAL GLU ALA ILE LEU          
SEQRES   7 A  116  LYS ALA ALA ARG THR GLY GLU VAL GLY ASP GLY LYS ILE          
SEQRES   8 A  116  PHE VAL LEU PRO VAL GLU LYS VAL TYR ARG ILE ARG THR          
SEQRES   9 A  116  GLY GLU GLU ASP GLU ALA ALA VAL THR PRO VAL GLN              
SEQRES   1 B  116  MET LYS LEU ILE VAL ALA ILE VAL ARG PRO GLU LYS LEU          
SEQRES   2 B  116  ASN GLU VAL LEU LYS ALA LEU PHE GLN ALA GLU VAL ARG          
SEQRES   3 B  116  GLY LEU THR LEU SER ARG VAL GLN GLY HIS GLY GLY GLU          
SEQRES   4 B  116  THR GLU ARG VAL GLU THR TYR ARG GLY THR THR VAL LYS          
SEQRES   5 B  116  MET GLU LEU HIS GLU LYS VAL ARG LEU GLU ILE GLY VAL          
SEQRES   6 B  116  SER GLU PRO PHE VAL LYS PRO THR VAL GLU ALA ILE LEU          
SEQRES   7 B  116  LYS ALA ALA ARG THR GLY GLU VAL GLY ASP GLY LYS ILE          
SEQRES   8 B  116  PHE VAL LEU PRO VAL GLU LYS VAL TYR ARG ILE ARG THR          
SEQRES   9 B  116  GLY GLU GLU ASP GLU ALA ALA VAL THR PRO VAL GLN              
SEQRES   1 C  116  MET LYS LEU ILE VAL ALA ILE VAL ARG PRO GLU LYS LEU          
SEQRES   2 C  116  ASN GLU VAL LEU LYS ALA LEU PHE GLN ALA GLU VAL ARG          
SEQRES   3 C  116  GLY LEU THR LEU SER ARG VAL GLN GLY HIS GLY GLY GLU          
SEQRES   4 C  116  THR GLU ARG VAL GLU THR TYR ARG GLY THR THR VAL LYS          
SEQRES   5 C  116  MET GLU LEU HIS GLU LYS VAL ARG LEU GLU ILE GLY VAL          
SEQRES   6 C  116  SER GLU PRO PHE VAL LYS PRO THR VAL GLU ALA ILE LEU          
SEQRES   7 C  116  LYS ALA ALA ARG THR GLY GLU VAL GLY ASP GLY LYS ILE          
SEQRES   8 C  116  PHE VAL LEU PRO VAL GLU LYS VAL TYR ARG ILE ARG THR          
SEQRES   9 C  116  GLY GLU GLU ASP GLU ALA ALA VAL THR PRO VAL GLN              
FORMUL   4  HOH   *35(H2 O)                                                     
CRYST1   97.070   97.070   56.560  90.00  90.00 120.00 P 31 2 1     18          
ATOM    851  N   MET B   1     -45.519   5.702 -10.554  1.00 39.65           N  
ATOM    852  CA  MET B   1     -46.836   5.580 -11.248  1.00 39.68           C  
ATOM    853  C   MET B   1     -47.312   6.974 -11.671  1.00 37.32           C  
ATOM    854  O   MET B   1     -47.319   7.916 -10.873  1.00 36.22           O  
ATOM    855  CB  MET B   1     -47.854   4.915 -10.311  1.00 41.60           C  
ATOM    856  CG  MET B   1     -48.408   5.829  -9.185  1.00 48.83           C  
ATOM    857  SD  MET B   1     -47.232   6.654  -8.009  1.00 52.47           S  
ATOM    858  CE  MET B   1     -47.233   5.481  -6.598  1.00 51.25           C  
ATOM    859  N   LYS B   2     -47.686   7.119 -12.933  1.00 35.46           N  
ATOM    860  CA  LYS B   2     -48.152   8.419 -13.412  1.00 35.74           C  
ATOM    861  C   LYS B   2     -49.587   8.412 -13.918  1.00 34.63           C  
ATOM    862  O   LYS B   2     -50.180   7.365 -14.128  1.00 33.94           O  
ATOM    863  CB  LYS B   2     -47.236   8.954 -14.522  1.00 35.67           C  
ATOM    864  CG  LYS B   2     -46.070   9.809 -14.041  1.00 33.57           C  
ATOM    865  CD  LYS B   2     -44.854   8.980 -13.742  1.00 34.20           C  
ATOM    866  CE  LYS B   2     -43.718   9.848 -13.232  1.00 35.67           C  
ATOM    867  NZ  LYS B   2     -44.007  10.489 -11.909  1.00 36.73           N  
ATOM    868  N   LEU B   3     -50.144   9.603 -14.091  1.00 35.16           N  
ATOM    869  CA  LEU B   3     -51.501   9.742 -14.597  1.00 35.75           C  
ATOM    870  C   LEU B   3     -51.413  10.527 -15.889  1.00 36.53           C  
ATOM    871  O   LEU B   3     -51.021  11.688 -15.894  1.00 37.59           O  
ATOM    872  CB  LEU B   3     -52.395  10.490 -13.603  1.00 34.47           C  
ATOM    873  CG  LEU B   3     -53.866  10.672 -14.006  1.00 34.37           C  
ATOM    874  CD1 LEU B   3     -54.475   9.327 -14.356  1.00 32.54           C  
ATOM    875  CD2 LEU B   3     -54.634  11.320 -12.864  1.00 32.71           C  
ATOM    876  N   ILE B   4     -51.765   9.883 -16.990  1.00 36.85           N  
ATOM    877  CA  ILE B   4     -51.716  10.541 -18.274  1.00 37.52           C  
ATOM    878  C   ILE B   4     -53.109  10.972 -18.723  1.00 37.21           C  
ATOM    879  O   ILE B   4     -53.999  10.146 -18.915  1.00 38.83           O  
ATOM    880  CB  ILE B   4     -51.111   9.612 -19.335  1.00 39.05           C  
ATOM    881  CG1 ILE B   4     -49.777   9.058 -18.818  1.00 39.56           C  
ATOM    882  CG2 ILE B   4     -50.946  10.366 -20.660  1.00 38.36           C  
ATOM    883  CD1 ILE B   4     -49.099   8.066 -19.746  1.00 38.46           C  
ATOM    884  N   VAL B   5     -53.292  12.276 -18.875  1.00 35.18           N  
ATOM    885  CA  VAL B   5     -54.557  12.822 -19.324  1.00 32.91           C  
ATOM    886  C   VAL B   5     -54.361  13.344 -20.742  1.00 32.61           C  
ATOM    887  O   VAL B   5     -53.614  14.290 -20.970  1.00 31.35           O  
ATOM    888  CB  VAL B   5     -55.018  13.959 -18.398  1.00 33.06           C  
ATOM    889  CG1 VAL B   5     -56.315  14.563 -18.918  1.00 33.39           C  
ATOM    890  CG2 VAL B   5     -55.190  13.423 -16.974  1.00 30.84           C  
ATOM    891  N   ALA B   6     -55.029  12.712 -21.698  1.00 33.05           N  
ATOM    892  CA  ALA B   6     -54.910  13.104 -23.092  1.00 33.00           C  
ATOM    893  C   ALA B   6     -56.237  13.570 -23.691  1.00 33.55           C  
ATOM    894  O   ALA B   6     -57.261  12.914 -23.524  1.00 33.63           O  
ATOM    895  CB  ALA B   6     -54.344  11.944 -23.894  1.00 30.51           C  
ATOM    896  N   ILE B   7     -56.201  14.715 -24.375  1.00 34.88           N  
ATOM    897  CA  ILE B   7     -57.375  15.290 -25.039  1.00 35.68           C  
ATOM    898  C   ILE B   7     -57.178  15.067 -26.544  1.00 36.78           C  
ATOM    899  O   ILE B   7     -56.225  15.577 -27.138  1.00 37.29           O  
ATOM    900  CB  ILE B   7     -57.499  16.827 -24.797  1.00 35.51           C  
ATOM    901  CG1 ILE B   7     -57.396  17.154 -23.310  1.00 34.93           C  
ATOM    902  CG2 ILE B   7     -58.833  17.332 -25.335  1.00 33.43           C  
ATOM    903  CD1 ILE B   7     -58.551  16.631 -22.488  1.00 36.59           C  
ATOM    904  N   VAL B   8     -58.078  14.311 -27.160  1.00 37.48           N  
ATOM    905  CA  VAL B   8     -57.963  14.016 -28.583  1.00 38.04           C  
ATOM    906  C   VAL B   8     -59.266  14.246 -29.358  1.00 39.83           C  
ATOM    907  O   VAL B   8     -60.337  14.413 -28.767  1.00 38.97           O  
ATOM    908  CB  VAL B   8     -57.479  12.552 -28.801  1.00 37.05           C  
ATOM    909  CG1 VAL B   8     -56.109  12.367 -28.180  1.00 35.86           C  
ATOM    910  CG2 VAL B   8     -58.461  11.562 -28.177  1.00 36.72           C  
ATOM    911  N   ARG B   9     -59.150  14.260 -30.686  1.00 41.80           N  
ATOM    912  CA  ARG B   9     -60.282  14.477 -31.582  1.00 42.32           C  
ATOM    913  C   ARG B   9     -61.180  13.261 -31.565  1.00 43.06           C  
ATOM    914  O   ARG B   9     -60.696  12.134 -31.467  1.00 42.70           O  
ATOM    915  CB  ARG B   9     -59.813  14.671 -33.029  1.00 42.40           C  
ATOM    916  CG  ARG B   9     -58.919  15.870 -33.317  1.00 42.32           C  
ATOM    917  CD  ARG B   9     -58.374  15.792 -34.753  1.00 42.27           C  
ATOM    918  NE  ARG B   9     -57.418  16.860 -35.035  1.00 44.01           N  
ATOM    919  CZ  ARG B   9     -57.756  18.132 -35.232  1.00 45.26           C  
ATOM    920  NH1 ARG B   9     -59.031  18.499 -35.188  1.00 45.00           N  
ATOM    921  NH2 ARG B   9     -56.818  19.044 -35.449  1.00 44.33           N  
ATOM    922  N   PRO B  10     -62.505  13.474 -31.663  1.00 43.97           N  
ATOM    923  CA  PRO B  10     -63.474  12.374 -31.674  1.00 43.61           C  
ATOM    924  C   PRO B  10     -63.132  11.409 -32.813  1.00 43.93           C  
ATOM    925  O   PRO B  10     -63.015  10.196 -32.616  1.00 42.37           O  
ATOM    926  CB  PRO B  10     -64.799  13.090 -31.917  1.00 44.27           C  
ATOM    927  CG  PRO B  10     -64.605  14.395 -31.214  1.00 43.04           C  
ATOM    928  CD  PRO B  10     -63.193  14.779 -31.611  1.00 43.86           C  
ATOM    929  N   GLU B  11     -62.953  11.969 -34.007  1.00 44.56           N  
ATOM    930  CA  GLU B  11     -62.634  11.173 -35.181  1.00 44.91           C  
ATOM    931  C   GLU B  11     -61.394  10.296 -35.012  1.00 44.02           C  
ATOM    932  O   GLU B  11     -61.301   9.248 -35.644  1.00 44.88           O  
ATOM    933  CB  GLU B  11     -62.476  12.068 -36.418  1.00 46.13           C  
ATOM    934  CG  GLU B  11     -61.397  13.125 -36.312  1.00 51.31           C  
ATOM    935  CD  GLU B  11     -61.873  14.382 -35.615  1.00 54.85           C  
ATOM    936  OE1 GLU B  11     -62.887  14.311 -34.887  1.00 57.21           O  
ATOM    937  OE2 GLU B  11     -61.226  15.441 -35.787  1.00 56.41           O  
ATOM    938  N   LYS B  12     -60.453  10.703 -34.160  1.00 42.80           N  
ATOM    939  CA  LYS B  12     -59.229   9.920 -33.938  1.00 41.27           C  
ATOM    940  C   LYS B  12     -59.232   9.090 -32.639  1.00 40.95           C  
ATOM    941  O   LYS B  12     -58.202   8.559 -32.235  1.00 40.31           O  
ATOM    942  CB  LYS B  12     -58.011  10.850 -33.945  1.00 41.46           C  
ATOM    943  CG  LYS B  12     -57.819  11.612 -35.241  1.00 40.87           C  
ATOM    944  CD  LYS B  12     -57.147  10.758 -36.299  1.00 38.59           C  
ATOM    945  CE  LYS B  12     -55.659  10.627 -36.028  1.00 37.92           C  
ATOM    946  NZ  LYS B  12     -54.973   9.735 -37.004  1.00 35.62           N  
ATOM    947  N   LEU B  13     -60.394   8.976 -32.000  1.00 40.91           N  
ATOM    948  CA  LEU B  13     -60.543   8.217 -30.759  1.00 39.91           C  
ATOM    949  C   LEU B  13     -60.154   6.744 -30.891  1.00 41.46           C  
ATOM    950  O   LEU B  13     -59.228   6.278 -30.224  1.00 41.36           O  
ATOM    951  CB  LEU B  13     -61.989   8.312 -30.270  1.00 38.83           C  
ATOM    952  CG  LEU B  13     -62.360   7.607 -28.962  1.00 38.89           C  
ATOM    953  CD1 LEU B  13     -61.417   8.057 -27.847  1.00 38.01           C  
ATOM    954  CD2 LEU B  13     -63.818   7.911 -28.608  1.00 36.15           C  
ATOM    955  N   ASN B  14     -60.869   6.013 -31.741  1.00 42.70           N  
ATOM    956  CA  ASN B  14     -60.597   4.592 -31.946  1.00 44.16           C  
ATOM    957  C   ASN B  14     -59.155   4.274 -32.305  1.00 44.55           C  
ATOM    958  O   ASN B  14     -58.605   3.275 -31.850  1.00 45.74           O  
ATOM    959  CB  ASN B  14     -61.494   4.027 -33.041  1.00 45.96           C  
ATOM    960  CG  ASN B  14     -62.930   3.891 -32.605  1.00 49.05           C  
ATOM    961  OD1 ASN B  14     -63.588   4.875 -32.267  1.00 49.98           O  
ATOM    962  ND2 ASN B  14     -63.431   2.661 -32.611  1.00 51.17           N  
ATOM    963  N   GLU B  15     -58.547   5.109 -33.138  1.00 44.60           N  
ATOM    964  CA  GLU B  15     -57.169   4.884 -33.553  1.00 44.92           C  
ATOM    965  C   GLU B  15     -56.247   4.899 -32.344  1.00 43.56           C  
ATOM    966  O   GLU B  15     -55.270   4.166 -32.290  1.00 43.91           O  
ATOM    967  CB  GLU B  15     -56.757   5.952 -34.560  1.00 47.12           C  
ATOM    968  CG  GLU B  15     -57.871   6.271 -35.552  1.00 50.44           C  
ATOM    969  CD  GLU B  15     -57.427   7.194 -36.669  1.00 53.17           C  
ATOM    970  OE1 GLU B  15     -58.317   7.652 -37.427  1.00 53.57           O  
ATOM    971  OE2 GLU B  15     -56.201   7.454 -36.796  1.00 53.31           O  
ATOM    972  N   VAL B  16     -56.577   5.734 -31.370  1.00 42.51           N  
ATOM    973  CA  VAL B  16     -55.794   5.829 -30.154  1.00 40.72           C  
ATOM    974  C   VAL B  16     -56.111   4.628 -29.262  1.00 40.86           C  
ATOM    975  O   VAL B  16     -55.196   3.953 -28.795  1.00 42.29           O  
ATOM    976  CB  VAL B  16     -56.085   7.164 -29.419  1.00 40.55           C  
ATOM    977  CG1 VAL B  16     -55.338   7.219 -28.101  1.00 39.13           C  
ATOM    978  CG2 VAL B  16     -55.660   8.340 -30.302  1.00 38.60           C  
ATOM    979  N   LEU B  17     -57.395   4.347 -29.034  1.00 39.72           N  
ATOM    980  CA  LEU B  17     -57.777   3.194 -28.217  1.00 38.05           C  
ATOM    981  C   LEU B  17     -57.052   1.957 -28.743  1.00 38.52           C  
ATOM    982  O   LEU B  17     -56.698   1.062 -27.979  1.00 37.75           O  
ATOM    983  CB  LEU B  17     -59.292   2.968 -28.267  1.00 37.99           C  
ATOM    984  CG  LEU B  17     -60.197   4.054 -27.664  1.00 37.29           C  
ATOM    985  CD1 LEU B  17     -61.645   3.762 -28.000  1.00 34.79           C  
ATOM    986  CD2 LEU B  17     -60.004   4.126 -26.161  1.00 35.57           C  
ATOM    987  N   LYS B  18     -56.838   1.909 -30.057  1.00 40.50           N  
ATOM    988  CA  LYS B  18     -56.119   0.796 -30.685  1.00 42.85           C  
ATOM    989  C   LYS B  18     -54.652   0.848 -30.244  1.00 42.93           C  
ATOM    990  O   LYS B  18     -54.100  -0.145 -29.760  1.00 42.32           O  
ATOM    991  CB  LYS B  18     -56.182   0.893 -32.222  1.00 44.60           C  
ATOM    992  CG  LYS B  18     -57.510   0.466 -32.854  1.00 49.38           C  
ATOM    993  CD  LYS B  18     -57.511   0.522 -34.411  1.00 50.34           C  
ATOM    994  CE  LYS B  18     -57.490   1.967 -34.945  1.00 51.19           C  
ATOM    995  NZ  LYS B  18     -57.702   2.117 -36.427  1.00 46.92           N  
ATOM    996  N   ALA B  19     -54.046   2.025 -30.414  1.00 41.92           N  
ATOM    997  CA  ALA B  19     -52.649   2.277 -30.076  1.00 41.79           C  
ATOM    998  C   ALA B  19     -52.354   2.064 -28.601  1.00 43.10           C  
ATOM    999  O   ALA B  19     -51.245   1.683 -28.232  1.00 43.78           O  
ATOM   1000  CB  ALA B  19     -52.268   3.699 -30.477  1.00 39.78           C  
ATOM   1001  N   LEU B  20     -53.346   2.330 -27.759  1.00 44.18           N  
ATOM   1002  CA  LEU B  20     -53.193   2.153 -26.323  1.00 45.25           C  
ATOM   1003  C   LEU B  20     -53.289   0.675 -26.010  1.00 48.91           C  
ATOM   1004  O   LEU B  20     -52.604   0.177 -25.126  1.00 50.63           O  
ATOM   1005  CB  LEU B  20     -54.285   2.915 -25.576  1.00 41.31           C  
ATOM   1006  CG  LEU B  20     -54.092   4.423 -25.555  1.00 37.56           C  
ATOM   1007  CD1 LEU B  20     -55.333   5.102 -25.028  1.00 34.24           C  
ATOM   1008  CD2 LEU B  20     -52.875   4.741 -24.705  1.00 37.47           C  
ATOM   1009  N   PHE B  21     -54.161  -0.017 -26.735  1.00 53.58           N  
ATOM   1010  CA  PHE B  21     -54.348  -1.452 -26.574  1.00 56.39           C  
ATOM   1011  C   PHE B  21     -53.002  -2.119 -26.822  1.00 56.87           C  
ATOM   1012  O   PHE B  21     -52.599  -3.038 -26.104  1.00 56.74           O  
ATOM   1013  CB  PHE B  21     -55.373  -1.946 -27.594  1.00 60.49           C  
ATOM   1014  CG  PHE B  21     -55.013  -3.261 -28.242  1.00 65.02           C  
ATOM   1015  CD1 PHE B  21     -55.049  -4.452 -27.512  1.00 66.10           C  
ATOM   1016  CD2 PHE B  21     -54.638  -3.308 -29.591  1.00 67.21           C  
ATOM   1017  CE1 PHE B  21     -54.720  -5.671 -28.114  1.00 67.35           C  
ATOM   1018  CE2 PHE B  21     -54.304  -4.524 -30.211  1.00 68.36           C  
ATOM   1019  CZ  PHE B  21     -54.347  -5.708 -29.469  1.00 68.49           C  
ATOM   1020  N   GLN B  22     -52.311  -1.649 -27.852  1.00 57.53           N  
ATOM   1021  CA  GLN B  22     -51.009  -2.198 -28.190  1.00 59.27           C  
ATOM   1022  C   GLN B  22     -49.944  -1.739 -27.199  1.00 58.14           C  
ATOM   1023  O   GLN B  22     -48.993  -2.469 -26.926  1.00 58.67           O  
ATOM   1024  CB  GLN B  22     -50.625  -1.804 -29.619  1.00 61.62           C  
ATOM   1025  CG  GLN B  22     -51.436  -2.539 -30.684  1.00 64.96           C  
ATOM   1026  CD  GLN B  22     -51.154  -2.043 -32.091  1.00 66.89           C  
ATOM   1027  OE1 GLN B  22     -51.671  -2.594 -33.061  1.00 68.16           O  
ATOM   1028  NE2 GLN B  22     -50.338  -0.996 -32.208  1.00 67.27           N  
ATOM   1029  N   ALA B  23     -50.110  -0.538 -26.654  1.00 56.82           N  
ATOM   1030  CA  ALA B  23     -49.162  -0.010 -25.679  1.00 55.87           C  
ATOM   1031  C   ALA B  23     -49.276  -0.810 -24.387  1.00 55.54           C  
ATOM   1032  O   ALA B  23     -48.598  -0.527 -23.405  1.00 55.77           O  
ATOM   1033  CB  ALA B  23     -49.443   1.466 -25.408  1.00 55.99           C  
ATOM   1034  N   GLU B  24     -50.148  -1.808 -24.394  1.00 55.51           N  
ATOM   1035  CA  GLU B  24     -50.345  -2.662 -23.232  1.00 56.71           C  
ATOM   1036  C   GLU B  24     -51.137  -2.016 -22.090  1.00 56.12           C  
ATOM   1037  O   GLU B  24     -50.999  -2.394 -20.923  1.00 56.11           O  
ATOM   1038  CB  GLU B  24     -48.993  -3.159 -22.730  1.00 57.17           C  
ATOM   1039  CG  GLU B  24     -48.298  -4.091 -23.706  1.00 58.99           C  
ATOM   1040  CD  GLU B  24     -46.875  -4.391 -23.289  1.00 61.22           C  
ATOM   1041  OE1 GLU B  24     -46.657  -4.644 -22.084  1.00 62.79           O  
ATOM   1042  OE2 GLU B  24     -45.978  -4.379 -24.162  1.00 61.34           O  
ATOM   1043  N   VAL B  25     -51.967  -1.039 -22.437  1.00 54.93           N  
ATOM   1044  CA  VAL B  25     -52.817  -0.370 -21.466  1.00 53.54           C  
ATOM   1045  C   VAL B  25     -53.985  -1.322 -21.226  1.00 54.10           C  
ATOM   1046  O   VAL B  25     -54.516  -1.899 -22.177  1.00 54.22           O  
ATOM   1047  CB  VAL B  25     -53.364   0.961 -22.031  1.00 52.63           C  
ATOM   1048  CG1 VAL B  25     -54.449   1.519 -21.118  1.00 52.77           C  
ATOM   1049  CG2 VAL B  25     -52.239   1.958 -22.178  1.00 52.13           C  
ATOM   1050  N   ARG B  26     -54.379  -1.505 -19.971  1.00 53.80           N  
ATOM   1051  CA  ARG B  26     -55.496  -2.397 -19.670  1.00 54.16           C  
ATOM   1052  C   ARG B  26     -56.559  -1.740 -18.798  1.00 53.96           C  
ATOM   1053  O   ARG B  26     -57.472  -2.413 -18.303  1.00 56.03           O  
ATOM   1054  CB  ARG B  26     -55.001  -3.673 -18.989  1.00 55.96           C  
ATOM   1055  CG  ARG B  26     -55.170  -4.934 -19.835  1.00 58.34           C  
ATOM   1056  CD  ARG B  26     -54.101  -5.046 -20.903  1.00 57.91           C  
ATOM   1057  NE  ARG B  26     -52.789  -5.280 -20.309  1.00 60.56           N  
ATOM   1058  CZ  ARG B  26     -51.658  -5.355 -21.002  1.00 61.67           C  
ATOM   1059  NH1 ARG B  26     -51.683  -5.210 -22.322  1.00 62.09           N  
ATOM   1060  NH2 ARG B  26     -50.506  -5.582 -20.376  1.00 60.08           N  
ATOM   1061  N   GLY B  27     -56.435  -0.427 -18.614  1.00 50.94           N  
ATOM   1062  CA  GLY B  27     -57.389   0.311 -17.810  1.00 45.97           C  
ATOM   1063  C   GLY B  27     -57.310   1.776 -18.173  1.00 44.36           C  
ATOM   1064  O   GLY B  27     -56.221   2.347 -18.208  1.00 43.89           O  
ATOM   1065  N   LEU B  28     -58.457   2.381 -18.465  1.00 41.87           N  
ATOM   1066  CA  LEU B  28     -58.523   3.796 -18.821  1.00 39.19           C  
ATOM   1067  C   LEU B  28     -59.969   4.268 -18.853  1.00 39.53           C  
ATOM   1068  O   LEU B  28     -60.889   3.475 -19.057  1.00 40.59           O  
ATOM   1069  CB  LEU B  28     -57.889   4.037 -20.189  1.00 36.23           C  
ATOM   1070  CG  LEU B  28     -58.562   3.427 -21.427  1.00 34.87           C  
ATOM   1071  CD1 LEU B  28     -59.887   4.097 -21.669  1.00 34.38           C  
ATOM   1072  CD2 LEU B  28     -57.675   3.610 -22.659  1.00 32.36           C  
ATOM   1073  N   THR B  29     -60.176   5.560 -18.649  1.00 38.86           N  
ATOM   1074  CA  THR B  29     -61.522   6.104 -18.701  1.00 37.32           C  
ATOM   1075  C   THR B  29     -61.584   7.209 -19.735  1.00 37.13           C  
ATOM   1076  O   THR B  29     -60.578   7.841 -20.061  1.00 37.69           O  
ATOM   1077  CB  THR B  29     -61.984   6.674 -17.352  1.00 36.45           C  
ATOM   1078  OG1 THR B  29     -61.142   7.768 -16.969  1.00 36.61           O  
ATOM   1079  CG2 THR B  29     -61.958   5.605 -16.301  1.00 35.91           C  
ATOM   1080  N   LEU B  30     -62.776   7.442 -20.255  1.00 36.43           N  
ATOM   1081  CA  LEU B  30     -62.939   8.464 -21.257  1.00 35.37           C  
ATOM   1082  C   LEU B  30     -64.281   9.142 -21.071  1.00 34.54           C  
ATOM   1083  O   LEU B  30     -65.230   8.542 -20.566  1.00 33.62           O  
ATOM   1084  CB  LEU B  30     -62.833   7.843 -22.651  1.00 36.24           C  
ATOM   1085  CG  LEU B  30     -64.072   7.132 -23.193  1.00 36.87           C  
ATOM   1086  CD1 LEU B  30     -65.028   8.165 -23.817  1.00 35.86           C  
ATOM   1087  CD2 LEU B  30     -63.649   6.110 -24.228  1.00 34.84           C  
ATOM   1088  N   SER B  31     -64.329  10.406 -21.479  1.00 33.84           N  
ATOM   1089  CA  SER B  31     -65.518  11.230 -21.391  1.00 31.28           C  
ATOM   1090  C   SER B  31     -65.402  12.331 -22.437  1.00 33.27           C  
ATOM   1091  O   SER B  31     -64.308  12.633 -22.915  1.00 35.24           O  
ATOM   1092  CB  SER B  31     -65.610  11.853 -20.014  1.00 29.03           C  
ATOM   1093  OG  SER B  31     -64.512  12.710 -19.802  1.00 28.04           O  
ATOM   1094  N   ARG B  32     -66.532  12.937 -22.782  1.00 33.30           N  
ATOM   1095  CA  ARG B  32     -66.553  13.995 -23.772  1.00 31.95           C  
ATOM   1096  C   ARG B  32     -66.374  15.358 -23.131  1.00 32.21           C  
ATOM   1097  O   ARG B  32     -66.939  15.639 -22.076  1.00 32.08           O  
ATOM   1098  CB  ARG B  32     -67.865  13.942 -24.560  1.00 32.85           C  
ATOM   1099  CG  ARG B  32     -68.140  12.575 -25.194  1.00 34.35           C  
ATOM   1100  CD  ARG B  32     -66.857  11.988 -25.781  1.00 34.21           C  
ATOM   1101  NE  ARG B  32     -67.036  10.669 -26.378  1.00 35.72           N  
ATOM   1102  CZ  ARG B  32     -67.302  10.446 -27.663  1.00 35.39           C  
ATOM   1103  NH1 ARG B  32     -67.428  11.462 -28.513  1.00 36.61           N  
ATOM   1104  NH2 ARG B  32     -67.417   9.197 -28.102  1.00 33.21           N  
ATOM   1105  N   VAL B  33     -65.562  16.192 -23.773  1.00 32.07           N  
ATOM   1106  CA  VAL B  33     -65.292  17.542 -23.299  1.00 31.84           C  
ATOM   1107  C   VAL B  33     -65.279  18.470 -24.497  1.00 33.49           C  
ATOM   1108  O   VAL B  33     -65.388  18.015 -25.630  1.00 33.51           O  
ATOM   1109  CB  VAL B  33     -63.924  17.636 -22.579  1.00 30.84           C  
ATOM   1110  CG1 VAL B  33     -63.932  16.732 -21.384  1.00 28.32           C  
ATOM   1111  CG2 VAL B  33     -62.769  17.288 -23.535  1.00 25.20           C  
ATOM   1112  N   GLN B  34     -65.151  19.768 -24.246  1.00 35.66           N  
ATOM   1113  CA  GLN B  34     -65.108  20.755 -25.326  1.00 38.73           C  
ATOM   1114  C   GLN B  34     -63.876  21.635 -25.242  1.00 40.43           C  
ATOM   1115  O   GLN B  34     -63.720  22.402 -24.289  1.00 40.95           O  
ATOM   1116  CB  GLN B  34     -66.326  21.658 -25.280  1.00 38.13           C  
ATOM   1117  CG  GLN B  34     -67.613  20.989 -25.620  1.00 39.42           C  
ATOM   1118  CD  GLN B  34     -68.772  21.910 -25.369  1.00 41.44           C  
ATOM   1119  OE1 GLN B  34     -69.193  22.098 -24.222  1.00 38.89           O  
ATOM   1120  NE2 GLN B  34     -69.285  22.519 -26.439  1.00 42.34           N  
ATOM   1121  N   GLY B  35     -63.011  21.536 -26.246  1.00 41.81           N  
ATOM   1122  CA  GLY B  35     -61.812  22.353 -26.255  1.00 46.63           C  
ATOM   1123  C   GLY B  35     -62.106  23.799 -26.619  1.00 49.72           C  
ATOM   1124  O   GLY B  35     -63.236  24.155 -26.966  1.00 50.21           O  
ATOM   1125  N   HIS B  36     -61.090  24.647 -26.538  1.00 52.20           N  
ATOM   1126  CA  HIS B  36     -61.268  26.044 -26.883  1.00 54.22           C  
ATOM   1127  C   HIS B  36     -59.961  26.734 -27.247  1.00 54.88           C  
ATOM   1128  O   HIS B  36     -58.880  26.240 -26.936  1.00 55.93           O  
ATOM   1129  CB  HIS B  36     -61.933  26.782 -25.737  1.00 56.14           C  
ATOM   1130  CG  HIS B  36     -62.116  28.237 -26.007  1.00 60.68           C  
ATOM   1131  ND1 HIS B  36     -61.052  29.096 -26.173  1.00 63.24           N  
ATOM   1132  CD2 HIS B  36     -63.235  28.975 -26.199  1.00 62.90           C  
ATOM   1133  CE1 HIS B  36     -61.508  30.302 -26.463  1.00 65.20           C  
ATOM   1134  NE2 HIS B  36     -62.828  30.256 -26.484  1.00 65.14           N  
ATOM   1135  N   GLU B  54     -65.642  29.888 -28.749  1.00 51.66           N  
ATOM   1136  CA  GLU B  54     -65.540  28.926 -29.843  1.00 52.05           C  
ATOM   1137  C   GLU B  54     -65.179  27.523 -29.344  1.00 51.37           C  
ATOM   1138  O   GLU B  54     -64.000  27.174 -29.219  1.00 50.89           O  
ATOM   1139  CB  GLU B  54     -64.502  29.404 -30.860  1.00 53.00           C  
ATOM   1140  CG  GLU B  54     -64.337  28.496 -32.087  1.00 54.63           C  
ATOM   1141  CD  GLU B  54     -65.627  28.280 -32.873  1.00 53.70           C  
ATOM   1142  OE1 GLU B  54     -65.535  27.881 -34.057  1.00 51.37           O  
ATOM   1143  OE2 GLU B  54     -66.724  28.499 -32.309  1.00 53.73           O  
ATOM   1144  N   LEU B  55     -66.209  26.721 -29.083  1.00 50.10           N  
ATOM   1145  CA  LEU B  55     -66.037  25.365 -28.575  1.00 48.66           C  
ATOM   1146  C   LEU B  55     -65.910  24.293 -29.652  1.00 47.10           C  
ATOM   1147  O   LEU B  55     -66.455  24.412 -30.751  1.00 46.31           O  
ATOM   1148  CB  LEU B  55     -67.197  25.001 -27.634  1.00 48.36           C  
ATOM   1149  CG  LEU B  55     -67.392  25.879 -26.392  1.00 48.48           C  
ATOM   1150  CD1 LEU B  55     -66.108  25.930 -25.584  1.00 47.87           C  
ATOM   1151  CD2 LEU B  55     -67.787  27.281 -26.819  1.00 49.80           C  
ATOM   1152  N   HIS B  56     -65.175  23.241 -29.310  1.00 45.59           N  
ATOM   1153  CA  HIS B  56     -64.961  22.119 -30.204  1.00 44.49           C  
ATOM   1154  C   HIS B  56     -65.128  20.799 -29.467  1.00 42.88           C  
ATOM   1155  O   HIS B  56     -64.910  20.713 -28.260  1.00 43.19           O  
ATOM   1156  CB  HIS B  56     -63.584  22.234 -30.856  1.00 46.19           C  
ATOM   1157  CG  HIS B  56     -63.510  23.341 -31.863  1.00 49.39           C  
ATOM   1158  ND1 HIS B  56     -64.172  23.287 -33.073  1.00 49.14           N  
ATOM   1159  CD2 HIS B  56     -62.954  24.575 -31.795  1.00 49.89           C  
ATOM   1160  CE1 HIS B  56     -64.031  24.439 -33.703  1.00 48.80           C  
ATOM   1161  NE2 HIS B  56     -63.298  25.238 -32.948  1.00 49.28           N  
ATOM   1162  N   GLU B  57     -65.546  19.780 -30.207  1.00 41.37           N  
ATOM   1163  CA  GLU B  57     -65.788  18.447 -29.672  1.00 39.65           C  
ATOM   1164  C   GLU B  57     -64.467  17.693 -29.479  1.00 39.07           C  
ATOM   1165  O   GLU B  57     -63.652  17.597 -30.405  1.00 39.40           O  
ATOM   1166  CB  GLU B  57     -66.697  17.691 -30.645  1.00 39.90           C  
ATOM   1167  CG  GLU B  57     -67.613  16.689 -30.017  1.00 40.43           C  
ATOM   1168  CD  GLU B  57     -68.407  17.286 -28.889  1.00 42.06           C  
ATOM   1169  OE1 GLU B  57     -68.644  18.508 -28.933  1.00 40.85           O  
ATOM   1170  OE2 GLU B  57     -68.798  16.534 -27.964  1.00 44.34           O  
ATOM   1171  N   LYS B  58     -64.257  17.165 -28.277  1.00 36.61           N  
ATOM   1172  CA  LYS B  58     -63.031  16.434 -27.973  1.00 36.06           C  
ATOM   1173  C   LYS B  58     -63.260  15.314 -26.959  1.00 34.10           C  
ATOM   1174  O   LYS B  58     -64.190  15.382 -26.154  1.00 34.05           O  
ATOM   1175  CB  LYS B  58     -61.972  17.404 -27.431  1.00 38.59           C  
ATOM   1176  CG  LYS B  58     -61.433  18.403 -28.453  1.00 40.77           C  
ATOM   1177  CD  LYS B  58     -60.595  17.692 -29.508  1.00 43.70           C  
ATOM   1178  CE  LYS B  58     -60.035  18.666 -30.530  1.00 46.62           C  
ATOM   1179  NZ  LYS B  58     -61.095  19.236 -31.413  1.00 48.59           N  
ATOM   1180  N   VAL B  59     -62.412  14.290 -27.000  1.00 31.61           N  
ATOM   1181  CA  VAL B  59     -62.513  13.169 -26.061  1.00 29.76           C  
ATOM   1182  C   VAL B  59     -61.390  13.270 -25.043  1.00 28.06           C  
ATOM   1183  O   VAL B  59     -60.227  13.373 -25.423  1.00 26.84           O  
ATOM   1184  CB  VAL B  59     -62.343  11.794 -26.746  1.00 30.35           C  
ATOM   1185  CG1 VAL B  59     -62.477  10.684 -25.702  1.00 27.37           C  
ATOM   1186  CG2 VAL B  59     -63.349  11.630 -27.874  1.00 28.60           C  
ATOM   1187  N   ARG B  60     -61.735  13.231 -23.757  1.00 27.18           N  
ATOM   1188  CA  ARG B  60     -60.731  13.301 -22.694  1.00 24.62           C  
ATOM   1189  C   ARG B  60     -60.476  11.905 -22.127  1.00 25.09           C  
ATOM   1190  O   ARG B  60     -61.376  11.286 -21.540  1.00 24.08           O  
ATOM   1191  CB  ARG B  60     -61.194  14.246 -21.582  1.00 23.56           C  
ATOM   1192  CG  ARG B  60     -60.194  14.421 -20.455  1.00 21.94           C  
ATOM   1193  CD  ARG B  60     -60.701  15.417 -19.444  1.00 23.60           C  
ATOM   1194  NE  ARG B  60     -59.867  15.455 -18.244  1.00 28.39           N  
ATOM   1195  CZ  ARG B  60     -59.762  14.459 -17.366  1.00 28.04           C  
ATOM   1196  NH1 ARG B  60     -60.444  13.334 -17.544  1.00 27.55           N  
ATOM   1197  NH2 ARG B  60     -58.963  14.583 -16.319  1.00 24.99           N  
ATOM   1198  N   LEU B  61     -59.250  11.418 -22.325  1.00 24.14           N  
ATOM   1199  CA  LEU B  61     -58.836  10.098 -21.863  1.00 26.56           C  
ATOM   1200  C   LEU B  61     -57.991  10.204 -20.597  1.00 27.54           C  
ATOM   1201  O   LEU B  61     -57.248  11.163 -20.429  1.00 27.71           O  
ATOM   1202  CB  LEU B  61     -58.028   9.402 -22.953  1.00 29.38           C  
ATOM   1203  CG  LEU B  61     -58.713   8.972 -24.246  1.00 30.06           C  
ATOM   1204  CD1 LEU B  61     -57.660   8.708 -25.280  1.00 31.00           C  
ATOM   1205  CD2 LEU B  61     -59.557   7.734 -24.015  1.00 32.67           C  
ATOM   1206  N   GLU B  62     -58.085   9.209 -19.719  1.00 29.05           N  
ATOM   1207  CA  GLU B  62     -57.340   9.232 -18.460  1.00 29.87           C  
ATOM   1208  C   GLU B  62     -56.814   7.838 -18.118  1.00 29.80           C  
ATOM   1209  O   GLU B  62     -57.548   6.978 -17.644  1.00 29.43           O  
ATOM   1210  CB  GLU B  62     -58.261   9.769 -17.358  1.00 30.94           C  
ATOM   1211  CG  GLU B  62     -57.601  10.152 -16.051  1.00 32.99           C  
ATOM   1212  CD  GLU B  62     -58.529  10.959 -15.158  1.00 34.62           C  
ATOM   1213  OE1 GLU B  62     -59.703  10.555 -14.991  1.00 36.79           O  
ATOM   1214  OE2 GLU B  62     -58.089  11.996 -14.619  1.00 34.69           O  
ATOM   1215  N   ILE B  63     -55.523   7.640 -18.368  1.00 31.19           N  
ATOM   1216  CA  ILE B  63     -54.840   6.365 -18.148  1.00 30.39           C  
ATOM   1217  C   ILE B  63     -53.802   6.447 -17.055  1.00 32.39           C  
ATOM   1218  O   ILE B  63     -52.947   7.329 -17.082  1.00 34.24           O  
ATOM   1219  CB  ILE B  63     -54.064   5.908 -19.393  1.00 29.20           C  
ATOM   1220  CG1 ILE B  63     -54.931   6.013 -20.647  1.00 29.20           C  
ATOM   1221  CG2 ILE B  63     -53.574   4.498 -19.189  1.00 29.51           C  
ATOM   1222  CD1 ILE B  63     -55.028   7.415 -21.201  1.00 29.22           C  
ATOM   1223  N   GLY B  64     -53.865   5.524 -16.101  1.00 33.70           N  
ATOM   1224  CA  GLY B  64     -52.882   5.503 -15.035  1.00 33.96           C  
ATOM   1225  C   GLY B  64     -51.870   4.477 -15.491  1.00 35.75           C  
ATOM   1226  O   GLY B  64     -52.244   3.327 -15.717  1.00 37.22           O  
ATOM   1227  N   VAL B  65     -50.610   4.881 -15.660  1.00 37.68           N  
ATOM   1228  CA  VAL B  65     -49.550   3.970 -16.121  1.00 39.60           C  
ATOM   1229  C   VAL B  65     -48.290   4.058 -15.261  1.00 41.74           C  
ATOM   1230  O   VAL B  65     -47.975   5.121 -14.716  1.00 42.00           O  
ATOM   1231  CB  VAL B  65     -49.109   4.258 -17.600  1.00 38.30           C  
ATOM   1232  CG1 VAL B  65     -50.310   4.459 -18.489  1.00 36.67           C  
ATOM   1233  CG2 VAL B  65     -48.193   5.466 -17.654  1.00 38.15           C  
ATOM   1234  N   SER B  66     -47.568   2.942 -15.154  1.00 43.26           N  
ATOM   1235  CA  SER B  66     -46.331   2.916 -14.383  1.00 45.82           C  
ATOM   1236  C   SER B  66     -45.148   3.391 -15.231  1.00 48.27           C  
ATOM   1237  O   SER B  66     -45.129   3.240 -16.454  1.00 47.03           O  
ATOM   1238  CB  SER B  66     -46.074   1.518 -13.856  1.00 43.70           C  
ATOM   1239  OG  SER B  66     -46.236   0.592 -14.902  1.00 45.17           O  
ATOM   1240  N   GLU B  67     -44.167   3.970 -14.552  1.00 52.17           N  
ATOM   1241  CA  GLU B  67     -42.956   4.535 -15.155  1.00 54.74           C  
ATOM   1242  C   GLU B  67     -42.460   3.950 -16.483  1.00 55.78           C  
ATOM   1243  O   GLU B  67     -42.261   4.675 -17.469  1.00 53.99           O  
ATOM   1244  CB  GLU B  67     -41.821   4.470 -14.134  1.00 55.29           C  
ATOM   1245  CG  GLU B  67     -42.231   4.874 -12.728  1.00 56.38           C  
ATOM   1246  CD  GLU B  67     -42.734   6.292 -12.660  1.00 57.37           C  
ATOM   1247  OE1 GLU B  67     -42.179   7.142 -13.392  1.00 57.89           O  
ATOM   1248  OE2 GLU B  67     -43.666   6.557 -11.870  1.00 57.16           O  
ATOM   1249  N   PRO B  68     -42.238   2.627 -16.518  1.00 57.23           N  
ATOM   1250  CA  PRO B  68     -41.755   1.943 -17.722  1.00 58.37           C  
ATOM   1251  C   PRO B  68     -42.578   2.222 -18.982  1.00 60.61           C  
ATOM   1252  O   PRO B  68     -42.033   2.306 -20.084  1.00 61.52           O  
ATOM   1253  CB  PRO B  68     -41.820   0.469 -17.326  1.00 57.71           C  
ATOM   1254  CG  PRO B  68     -41.689   0.498 -15.838  1.00 56.62           C  
ATOM   1255  CD  PRO B  68     -42.548   1.654 -15.455  1.00 56.15           C  
ATOM   1256  N   PHE B  69     -43.888   2.382 -18.803  1.00 62.61           N  
ATOM   1257  CA  PHE B  69     -44.810   2.591 -19.920  1.00 62.46           C  
ATOM   1258  C   PHE B  69     -45.233   4.021 -20.235  1.00 61.57           C  
ATOM   1259  O   PHE B  69     -45.926   4.249 -21.225  1.00 62.55           O  
ATOM   1260  CB  PHE B  69     -46.061   1.726 -19.703  1.00 63.19           C  
ATOM   1261  CG  PHE B  69     -45.756   0.262 -19.577  1.00 64.59           C  
ATOM   1262  CD1 PHE B  69     -44.975  -0.210 -18.524  1.00 65.14           C  
ATOM   1263  CD2 PHE B  69     -46.181  -0.634 -20.549  1.00 65.75           C  
ATOM   1264  CE1 PHE B  69     -44.613  -1.548 -18.442  1.00 65.63           C  
ATOM   1265  CE2 PHE B  69     -45.824  -1.982 -20.477  1.00 67.46           C  
ATOM   1266  CZ  PHE B  69     -45.035  -2.438 -19.420  1.00 66.88           C  
ATOM   1267  N   VAL B  70     -44.823   4.985 -19.419  1.00 59.67           N  
ATOM   1268  CA  VAL B  70     -45.205   6.366 -19.676  1.00 57.50           C  
ATOM   1269  C   VAL B  70     -44.689   6.833 -21.040  1.00 58.20           C  
ATOM   1270  O   VAL B  70     -45.476   7.153 -21.936  1.00 58.04           O  
ATOM   1271  CB  VAL B  70     -44.668   7.311 -18.587  1.00 56.09           C  
ATOM   1272  CG1 VAL B  70     -45.169   8.712 -18.845  1.00 54.85           C  
ATOM   1273  CG2 VAL B  70     -45.103   6.831 -17.209  1.00 54.36           C  
ATOM   1274  N   LYS B  71     -43.368   6.863 -21.199  1.00 58.14           N  
ATOM   1275  CA  LYS B  71     -42.751   7.297 -22.452  1.00 57.22           C  
ATOM   1276  C   LYS B  71     -43.385   6.621 -23.656  1.00 56.13           C  
ATOM   1277  O   LYS B  71     -43.722   7.276 -24.631  1.00 55.75           O  
ATOM   1278  CB  LYS B  71     -41.255   6.992 -22.441  1.00 59.04           C  
ATOM   1279  CG  LYS B  71     -40.458   7.697 -23.528  1.00 59.99           C  
ATOM   1280  CD  LYS B  71     -39.487   8.710 -22.924  1.00 60.96           C  
ATOM   1281  CE  LYS B  71     -40.207   9.740 -22.048  1.00 61.82           C  
ATOM   1282  NZ  LYS B  71     -39.258  10.670 -21.349  1.00 62.40           N  
ATOM   1283  N   PRO B  72     -43.552   5.291 -23.599  1.00 55.99           N  
ATOM   1284  CA  PRO B  72     -44.148   4.511 -24.692  1.00 55.81           C  
ATOM   1285  C   PRO B  72     -45.618   4.827 -24.988  1.00 55.53           C  
ATOM   1286  O   PRO B  72     -46.075   4.698 -26.132  1.00 56.00           O  
ATOM   1287  CB  PRO B  72     -43.974   3.067 -24.221  1.00 56.13           C  
ATOM   1288  CG  PRO B  72     -42.780   3.138 -23.313  1.00 57.21           C  
ATOM   1289  CD  PRO B  72     -43.047   4.393 -22.545  1.00 55.83           C  
ATOM   1290  N   THR B  73     -46.356   5.226 -23.957  1.00 54.28           N  
ATOM   1291  CA  THR B  73     -47.771   5.531 -24.109  1.00 53.44           C  
ATOM   1292  C   THR B  73     -48.015   6.905 -24.709  1.00 52.38           C  
ATOM   1293  O   THR B  73     -48.964   7.098 -25.472  1.00 51.06           O  
ATOM   1294  CB  THR B  73     -48.489   5.435 -22.766  1.00 53.73           C  
ATOM   1295  OG1 THR B  73     -48.249   4.143 -22.204  1.00 55.18           O  
ATOM   1296  CG2 THR B  73     -49.985   5.623 -22.946  1.00 55.66           C  
ATOM   1297  N   VAL B  74     -47.160   7.860 -24.359  1.00 51.59           N  
ATOM   1298  CA  VAL B  74     -47.291   9.201 -24.900  1.00 51.58           C  
ATOM   1299  C   VAL B  74     -46.980   9.154 -26.382  1.00 51.06           C  
ATOM   1300  O   VAL B  74     -47.584   9.870 -27.167  1.00 51.99           O  
ATOM   1301  CB  VAL B  74     -46.332  10.186 -24.213  1.00 51.71           C  
ATOM   1302  CG1 VAL B  74     -46.191  11.448 -25.053  1.00 51.92           C  
ATOM   1303  CG2 VAL B  74     -46.871  10.543 -22.831  1.00 52.40           C  
ATOM   1304  N   GLU B  75     -46.041   8.294 -26.757  1.00 50.89           N  
ATOM   1305  CA  GLU B  75     -45.645   8.136 -28.147  1.00 51.87           C  
ATOM   1306  C   GLU B  75     -46.768   7.531 -28.977  1.00 50.08           C  
ATOM   1307  O   GLU B  75     -47.056   7.994 -30.078  1.00 49.21           O  
ATOM   1308  CB  GLU B  75     -44.426   7.220 -28.247  1.00 56.11           C  
ATOM   1309  CG  GLU B  75     -43.192   7.703 -27.508  1.00 61.04           C  
ATOM   1310  CD  GLU B  75     -42.073   6.672 -27.538  1.00 63.82           C  
ATOM   1311  OE1 GLU B  75     -42.270   5.554 -27.009  1.00 65.33           O  
ATOM   1312  OE2 GLU B  75     -41.000   6.975 -28.095  1.00 65.59           O  
ATOM   1313  N   ALA B  76     -47.381   6.479 -28.442  1.00 49.08           N  
ATOM   1314  CA  ALA B  76     -48.472   5.778 -29.115  1.00 47.67           C  
ATOM   1315  C   ALA B  76     -49.650   6.703 -29.370  1.00 46.41           C  
ATOM   1316  O   ALA B  76     -50.345   6.566 -30.377  1.00 46.42           O  
ATOM   1317  CB  ALA B  76     -48.924   4.588 -28.276  1.00 48.81           C  
ATOM   1318  N   ILE B  77     -49.878   7.635 -28.447  1.00 44.29           N  
ATOM   1319  CA  ILE B  77     -50.962   8.604 -28.572  1.00 41.55           C  
ATOM   1320  C   ILE B  77     -50.584   9.676 -29.609  1.00 40.43           C  
ATOM   1321  O   ILE B  77     -51.346   9.950 -30.540  1.00 37.87           O  
ATOM   1322  CB  ILE B  77     -51.251   9.269 -27.211  1.00 41.01           C  
ATOM   1323  CG1 ILE B  77     -51.712   8.204 -26.214  1.00 41.87           C  
ATOM   1324  CG2 ILE B  77     -52.309  10.354 -27.360  1.00 39.57           C  
ATOM   1325  CD1 ILE B  77     -51.990   8.742 -24.815  1.00 43.48           C  
ATOM   1326  N   LEU B  78     -49.401  10.265 -29.448  1.00 39.08           N  
ATOM   1327  CA  LEU B  78     -48.919  11.282 -30.376  1.00 39.67           C  
ATOM   1328  C   LEU B  78     -49.005  10.775 -31.819  1.00 40.42           C  
ATOM   1329  O   LEU B  78     -49.573  11.444 -32.692  1.00 41.47           O  
ATOM   1330  CB  LEU B  78     -47.475  11.669 -30.040  1.00 38.50           C  
ATOM   1331  CG  LEU B  78     -47.273  12.455 -28.735  1.00 37.67           C  
ATOM   1332  CD1 LEU B  78     -45.809  12.497 -28.381  1.00 36.89           C  
ATOM   1333  CD2 LEU B  78     -47.827  13.862 -28.884  1.00 37.75           C  
ATOM   1334  N   LYS B  79     -48.454   9.596 -32.079  1.00 39.88           N  
ATOM   1335  CA  LYS B  79     -48.528   9.053 -33.425  1.00 40.07           C  
ATOM   1336  C   LYS B  79     -49.986   8.949 -33.845  1.00 39.01           C  
ATOM   1337  O   LYS B  79     -50.390   9.517 -34.858  1.00 40.35           O  
ATOM   1338  CB  LYS B  79     -47.894   7.661 -33.504  1.00 41.58           C  
ATOM   1339  CG  LYS B  79     -47.990   7.032 -34.905  1.00 42.91           C  
ATOM   1340  CD  LYS B  79     -47.774   5.515 -34.901  1.00 45.04           C  
ATOM   1341  CE  LYS B  79     -46.350   5.108 -34.502  1.00 46.12           C  
ATOM   1342  NZ  LYS B  79     -46.227   3.619 -34.304  1.00 46.52           N  
ATOM   1343  N   ALA B  80     -50.774   8.241 -33.043  1.00 37.70           N  
ATOM   1344  CA  ALA B  80     -52.185   8.015 -33.334  1.00 36.37           C  
ATOM   1345  C   ALA B  80     -53.125   9.226 -33.425  1.00 36.06           C  
ATOM   1346  O   ALA B  80     -54.089   9.175 -34.180  1.00 35.92           O  
ATOM   1347  CB  ALA B  80     -52.748   7.006 -32.339  1.00 34.28           C  
ATOM   1348  N   ALA B  81     -52.859  10.309 -32.694  1.00 36.59           N  
ATOM   1349  CA  ALA B  81     -53.764  11.473 -32.717  1.00 37.54           C  
ATOM   1350  C   ALA B  81     -53.391  12.688 -33.563  1.00 38.32           C  
ATOM   1351  O   ALA B  81     -54.203  13.601 -33.717  1.00 37.16           O  
ATOM   1352  CB  ALA B  81     -54.047  11.939 -31.285  1.00 37.31           C  
ATOM   1353  N   ARG B  82     -52.179  12.713 -34.104  1.00 40.05           N  
ATOM   1354  CA  ARG B  82     -51.750  13.845 -34.917  1.00 41.58           C  
ATOM   1355  C   ARG B  82     -52.286  13.810 -36.349  1.00 42.52           C  
ATOM   1356  O   ARG B  82     -52.215  12.781 -37.021  1.00 43.85           O  
ATOM   1357  CB  ARG B  82     -50.225  13.910 -34.950  1.00 41.59           C  
ATOM   1358  CG  ARG B  82     -49.690  15.072 -35.757  1.00 44.24           C  
ATOM   1359  CD  ARG B  82     -48.191  14.965 -35.937  1.00 46.34           C  
ATOM   1360  NE  ARG B  82     -47.479  15.206 -34.690  1.00 49.36           N  
ATOM   1361  CZ  ARG B  82     -46.162  15.088 -34.539  1.00 50.15           C  
ATOM   1362  NH1 ARG B  82     -45.385  14.725 -35.558  1.00 47.09           N  
ATOM   1363  NH2 ARG B  82     -45.621  15.344 -33.354  1.00 51.61           N  
ATOM   1364  N   THR B  83     -52.833  14.939 -36.802  1.00 42.74           N  
ATOM   1365  CA  THR B  83     -53.362  15.076 -38.161  1.00 41.35           C  
ATOM   1366  C   THR B  83     -52.692  16.294 -38.795  1.00 43.20           C  
ATOM   1367  O   THR B  83     -52.741  16.491 -40.012  1.00 44.46           O  
ATOM   1368  CB  THR B  83     -54.892  15.309 -38.186  1.00 39.76           C  
ATOM   1369  OG1 THR B  83     -55.211  16.518 -37.488  1.00 40.60           O  
ATOM   1370  CG2 THR B  83     -55.630  14.150 -37.553  1.00 39.48           C  
ATOM   1371  N   GLY B  84     -52.070  17.112 -37.955  1.00 42.94           N  
ATOM   1372  CA  GLY B  84     -51.396  18.293 -38.445  1.00 43.15           C  
ATOM   1373  C   GLY B  84     -52.115  19.598 -38.154  1.00 43.99           C  
ATOM   1374  O   GLY B  84     -51.481  20.583 -37.779  1.00 44.51           O  
ATOM   1375  N   GLU B  85     -53.433  19.615 -38.312  1.00 44.43           N  
ATOM   1376  CA  GLU B  85     -54.214  20.829 -38.088  1.00 46.26           C  
ATOM   1377  C   GLU B  85     -54.307  21.267 -36.624  1.00 47.47           C  
ATOM   1378  O   GLU B  85     -53.921  20.532 -35.714  1.00 48.21           O  
ATOM   1379  CB  GLU B  85     -55.623  20.636 -38.632  1.00 46.64           C  
ATOM   1380  CG  GLU B  85     -55.680  19.785 -39.882  1.00 49.72           C  
ATOM   1381  CD  GLU B  85     -57.091  19.621 -40.396  1.00 51.83           C  
ATOM   1382  OE1 GLU B  85     -57.590  20.564 -41.051  1.00 53.77           O  
ATOM   1383  OE2 GLU B  85     -57.703  18.559 -40.132  1.00 51.52           O  
ATOM   1384  N   VAL B  86     -54.819  22.476 -36.401  1.00 47.75           N  
ATOM   1385  CA  VAL B  86     -54.982  22.989 -35.043  1.00 48.64           C  
ATOM   1386  C   VAL B  86     -56.080  22.225 -34.319  1.00 47.25           C  
ATOM   1387  O   VAL B  86     -57.085  21.847 -34.919  1.00 44.94           O  
ATOM   1388  CB  VAL B  86     -55.385  24.500 -35.002  1.00 49.95           C  
ATOM   1389  CG1 VAL B  86     -54.160  25.394 -35.156  1.00 48.68           C  
ATOM   1390  CG2 VAL B  86     -56.417  24.787 -36.084  1.00 51.82           C  
ATOM   1391  N   GLY B  87     -55.880  22.009 -33.023  1.00 46.85           N  
ATOM   1392  CA  GLY B  87     -56.881  21.312 -32.246  1.00 45.53           C  
ATOM   1393  C   GLY B  87     -56.710  19.808 -32.170  1.00 44.84           C  
ATOM   1394  O   GLY B  87     -57.691  19.095 -31.936  1.00 44.63           O  
ATOM   1395  N   ASP B  88     -55.488  19.314 -32.378  1.00 42.52           N  
ATOM   1396  CA  ASP B  88     -55.249  17.879 -32.280  1.00 38.88           C  
ATOM   1397  C   ASP B  88     -55.407  17.480 -30.821  1.00 39.14           C  
ATOM   1398  O   ASP B  88     -55.739  16.337 -30.510  1.00 39.28           O  
ATOM   1399  CB  ASP B  88     -53.849  17.518 -32.763  1.00 34.93           C  
ATOM   1400  CG  ASP B  88     -53.803  17.257 -34.249  1.00 33.24           C  
ATOM   1401  OD1 ASP B  88     -54.880  17.089 -34.857  1.00 30.32           O  
ATOM   1402  OD2 ASP B  88     -52.692  17.205 -34.807  1.00 31.09           O  
ATOM   1403  N   GLY B  89     -55.178  18.439 -29.931  1.00 38.91           N  
ATOM   1404  CA  GLY B  89     -55.304  18.176 -28.510  1.00 39.40           C  
ATOM   1405  C   GLY B  89     -53.982  18.211 -27.767  1.00 39.47           C  
ATOM   1406  O   GLY B  89     -52.946  18.580 -28.320  1.00 39.35           O  
ATOM   1407  N   LYS B  90     -54.020  17.826 -26.499  1.00 39.45           N  
ATOM   1408  CA  LYS B  90     -52.818  17.811 -25.687  1.00 40.61           C  
ATOM   1409  C   LYS B  90     -52.717  16.567 -24.819  1.00 39.63           C  
ATOM   1410  O   LYS B  90     -53.693  15.847 -24.607  1.00 40.40           O  
ATOM   1411  CB  LYS B  90     -52.760  19.057 -24.795  1.00 42.37           C  
ATOM   1412  CG  LYS B  90     -52.754  20.376 -25.574  1.00 46.92           C  
ATOM   1413  CD  LYS B  90     -52.159  21.519 -24.766  1.00 46.71           C  
ATOM   1414  CE  LYS B  90     -51.867  22.704 -25.674  1.00 50.20           C  
ATOM   1415  NZ  LYS B  90     -50.790  23.601 -25.137  1.00 52.30           N  
ATOM   1416  N   ILE B  91     -51.511  16.313 -24.338  1.00 37.55           N  
ATOM   1417  CA  ILE B  91     -51.251  15.190 -23.463  1.00 35.83           C  
ATOM   1418  C   ILE B  91     -50.565  15.772 -22.242  1.00 35.62           C  
ATOM   1419  O   ILE B  91     -49.581  16.496 -22.370  1.00 33.72           O  
ATOM   1420  CB  ILE B  91     -50.275  14.170 -24.087  1.00 35.49           C  
ATOM   1421  CG1 ILE B  91     -50.904  13.487 -25.304  1.00 32.94           C  
ATOM   1422  CG2 ILE B  91     -49.835  13.164 -23.028  1.00 33.21           C  
ATOM   1423  CD1 ILE B  91     -49.914  12.614 -26.074  1.00 27.26           C  
ATOM   1424  N   PHE B  92     -51.100  15.478 -21.064  1.00 36.39           N  
ATOM   1425  CA  PHE B  92     -50.490  15.935 -19.825  1.00 36.80           C  
ATOM   1426  C   PHE B  92     -50.001  14.694 -19.097  1.00 36.03           C  
ATOM   1427  O   PHE B  92     -50.542  13.608 -19.297  1.00 36.27           O  
ATOM   1428  CB  PHE B  92     -51.498  16.638 -18.924  1.00 37.23           C  
ATOM   1429  CG  PHE B  92     -52.155  17.818 -19.553  1.00 38.65           C  
ATOM   1430  CD1 PHE B  92     -53.294  17.660 -20.334  1.00 39.80           C  
ATOM   1431  CD2 PHE B  92     -51.652  19.096 -19.347  1.00 39.96           C  
ATOM   1432  CE1 PHE B  92     -53.930  18.760 -20.905  1.00 39.64           C  
ATOM   1433  CE2 PHE B  92     -52.277  20.204 -19.912  1.00 41.10           C  
ATOM   1434  CZ  PHE B  92     -53.423  20.032 -20.697  1.00 40.22           C  
ATOM   1435  N   VAL B  93     -48.966  14.850 -18.281  1.00 34.81           N  
ATOM   1436  CA  VAL B  93     -48.449  13.746 -17.479  1.00 32.30           C  
ATOM   1437  C   VAL B  93     -48.394  14.271 -16.059  1.00 33.40           C  
ATOM   1438  O   VAL B  93     -47.760  15.292 -15.789  1.00 33.45           O  
ATOM   1439  CB  VAL B  93     -47.052  13.325 -17.885  1.00 30.05           C  
ATOM   1440  CG1 VAL B  93     -46.574  12.233 -16.950  1.00 27.84           C  
ATOM   1441  CG2 VAL B  93     -47.053  12.850 -19.327  1.00 28.62           C  
ATOM   1442  N   LEU B  94     -49.067  13.586 -15.147  1.00 33.84           N  
ATOM   1443  CA  LEU B  94     -49.081  14.046 -13.774  1.00 33.47           C  
ATOM   1444  C   LEU B  94     -48.543  13.041 -12.772  1.00 32.74           C  
ATOM   1445  O   LEU B  94     -48.555  11.829 -13.002  1.00 29.23           O  
ATOM   1446  CB  LEU B  94     -50.503  14.438 -13.366  1.00 35.76           C  
ATOM   1447  CG  LEU B  94     -51.362  15.212 -14.365  1.00 36.89           C  
ATOM   1448  CD1 LEU B  94     -52.597  15.715 -13.649  1.00 36.11           C  
ATOM   1449  CD2 LEU B  94     -50.580  16.383 -14.951  1.00 39.92           C  
ATOM   1450  N   PRO B  95     -48.055  13.552 -11.631  1.00 33.58           N  
ATOM   1451  CA  PRO B  95     -47.511  12.723 -10.561  1.00 32.60           C  
ATOM   1452  C   PRO B  95     -48.701  12.093  -9.862  1.00 32.88           C  
ATOM   1453  O   PRO B  95     -49.724  12.745  -9.671  1.00 32.09           O  
ATOM   1454  CB  PRO B  95     -46.825  13.734  -9.644  1.00 31.37           C  
ATOM   1455  CG  PRO B  95     -46.696  14.967 -10.469  1.00 32.12           C  
ATOM   1456  CD  PRO B  95     -47.920  14.976 -11.291  1.00 33.01           C  
ATOM   1457  N   VAL B  96     -48.576  10.830  -9.496  1.00 33.67           N  
ATOM   1458  CA  VAL B  96     -49.640  10.157  -8.788  1.00 35.35           C  
ATOM   1459  C   VAL B  96     -49.029   9.717  -7.477  1.00 35.66           C  
ATOM   1460  O   VAL B  96     -47.934   9.183  -7.457  1.00 38.47           O  
ATOM   1461  CB  VAL B  96     -50.147   8.918  -9.556  1.00 35.28           C  
ATOM   1462  CG1 VAL B  96     -51.311   8.287  -8.815  1.00 35.31           C  
ATOM   1463  CG2 VAL B  96     -50.573   9.315 -10.946  1.00 35.44           C  
ATOM   1464  N   GLU B  97     -49.715   9.965  -6.375  1.00 36.52           N  
ATOM   1465  CA  GLU B  97     -49.202   9.546  -5.088  1.00 36.85           C  
ATOM   1466  C   GLU B  97     -49.375   8.017  -5.013  1.00 37.01           C  
ATOM   1467  O   GLU B  97     -48.415   7.299  -4.740  1.00 36.03           O  
ATOM   1468  CB  GLU B  97     -49.978  10.246  -3.967  1.00 40.44           C  
ATOM   1469  CG  GLU B  97     -49.119  10.774  -2.810  1.00 43.66           C  
ATOM   1470  CD  GLU B  97     -48.194  11.916  -3.220  1.00 45.88           C  
ATOM   1471  OE1 GLU B  97     -47.498  12.466  -2.335  1.00 46.87           O  
ATOM   1472  OE2 GLU B  97     -48.158  12.264  -4.421  1.00 46.56           O  
ATOM   1473  N   LYS B  98     -50.595   7.524  -5.261  1.00 36.18           N  
ATOM   1474  CA  LYS B  98     -50.868   6.080  -5.234  1.00 35.80           C  
ATOM   1475  C   LYS B  98     -52.026   5.699  -6.155  1.00 33.77           C  
ATOM   1476  O   LYS B  98     -52.845   6.535  -6.508  1.00 33.95           O  
ATOM   1477  CB  LYS B  98     -51.204   5.589  -3.814  1.00 37.44           C  
ATOM   1478  CG  LYS B  98     -50.307   6.114  -2.701  1.00 40.74           C  
ATOM   1479  CD  LYS B  98     -50.844   7.444  -2.166  1.00 44.08           C  
ATOM   1480  CE  LYS B  98     -50.014   7.998  -1.001  1.00 45.50           C  
ATOM   1481  NZ  LYS B  98     -50.542   9.322  -0.523  1.00 45.21           N  
ATOM   1482  N   VAL B  99     -52.076   4.429  -6.547  1.00 32.23           N  
ATOM   1483  CA  VAL B  99     -53.139   3.915  -7.411  1.00 30.55           C  
ATOM   1484  C   VAL B  99     -53.716   2.655  -6.789  1.00 28.93           C  
ATOM   1485  O   VAL B  99     -52.979   1.754  -6.417  1.00 29.73           O  
ATOM   1486  CB  VAL B  99     -52.634   3.502  -8.822  1.00 31.09           C  
ATOM   1487  CG1 VAL B  99     -53.820   2.980  -9.660  1.00 29.83           C  
ATOM   1488  CG2 VAL B  99     -51.940   4.672  -9.518  1.00 31.59           C  
ATOM   1489  N   TYR B 100     -55.032   2.588  -6.692  1.00 28.04           N  
ATOM   1490  CA  TYR B 100     -55.676   1.421  -6.125  1.00 28.21           C  
ATOM   1491  C   TYR B 100     -56.713   0.782  -7.036  1.00 28.16           C  
ATOM   1492  O   TYR B 100     -57.665   1.431  -7.473  1.00 25.80           O  
ATOM   1493  CB  TYR B 100     -56.375   1.765  -4.818  1.00 29.29           C  
ATOM   1494  CG  TYR B 100     -55.492   2.372  -3.773  1.00 31.91           C  
ATOM   1495  CD1 TYR B 100     -55.480   3.746  -3.566  1.00 33.34           C  
ATOM   1496  CD2 TYR B 100     -54.691   1.574  -2.968  1.00 33.56           C  
ATOM   1497  CE1 TYR B 100     -54.695   4.314  -2.575  1.00 35.42           C  
ATOM   1498  CE2 TYR B 100     -53.901   2.125  -1.977  1.00 35.52           C  
ATOM   1499  CZ  TYR B 100     -53.907   3.499  -1.778  1.00 36.51           C  
ATOM   1500  OH  TYR B 100     -53.151   4.056  -0.764  1.00 38.73           O  
ATOM   1501  N   ARG B 101     -56.514  -0.495  -7.328  1.00 26.84           N  
ATOM   1502  CA  ARG B 101     -57.481  -1.223  -8.110  1.00 27.32           C  
ATOM   1503  C   ARG B 101     -58.522  -1.531  -7.030  1.00 25.89           C  
ATOM   1504  O   ARG B 101     -58.197  -2.117  -6.005  1.00 22.33           O  
ATOM   1505  CB  ARG B 101     -56.849  -2.499  -8.672  1.00 30.60           C  
ATOM   1506  CG  ARG B 101     -57.731  -3.750  -8.599  1.00 35.59           C  
ATOM   1507  CD  ARG B 101     -58.351  -4.152  -9.945  1.00 40.39           C  
ATOM   1508  NE  ARG B 101     -57.377  -4.326 -11.028  1.00 43.95           N  
ATOM   1509  CZ  ARG B 101     -56.148  -4.822 -10.884  1.00 45.19           C  
ATOM   1510  NH1 ARG B 101     -55.701  -5.206  -9.695  1.00 45.24           N  
ATOM   1511  NH2 ARG B 101     -55.355  -4.927 -11.941  1.00 46.48           N  
ATOM   1512  N   ILE B 102     -59.758  -1.093  -7.253  1.00 26.78           N  
ATOM   1513  CA  ILE B 102     -60.853  -1.283  -6.310  1.00 26.59           C  
ATOM   1514  C   ILE B 102     -61.224  -2.757  -6.114  1.00 29.14           C  
ATOM   1515  O   ILE B 102     -61.404  -3.221  -4.983  1.00 30.62           O  
ATOM   1516  CB  ILE B 102     -62.096  -0.476  -6.778  1.00 26.53           C  
ATOM   1517  CG1 ILE B 102     -61.759   1.020  -6.764  1.00 26.50           C  
ATOM   1518  CG2 ILE B 102     -63.316  -0.799  -5.912  1.00 24.19           C  
ATOM   1519  CD1 ILE B 102     -62.929   1.947  -7.050  1.00 24.42           C  
ATOM   1520  N   ARG B 103     -61.326  -3.490  -7.217  1.00 31.14           N  
ATOM   1521  CA  ARG B 103     -61.679  -4.906  -7.188  1.00 32.11           C  
ATOM   1522  C   ARG B 103     -60.863  -5.700  -6.171  1.00 34.06           C  
ATOM   1523  O   ARG B 103     -61.411  -6.503  -5.411  1.00 33.85           O  
ATOM   1524  CB  ARG B 103     -61.471  -5.511  -8.576  1.00 30.58           C  
ATOM   1525  CG  ARG B 103     -62.094  -6.870  -8.785  1.00 27.65           C  
ATOM   1526  CD  ARG B 103     -61.737  -7.413 -10.157  1.00 27.55           C  
ATOM   1527  NE  ARG B 103     -60.322  -7.765 -10.277  1.00 28.11           N  
ATOM   1528  CZ  ARG B 103     -59.772  -8.876  -9.779  1.00 29.33           C  
ATOM   1529  NH1 ARG B 103     -60.518  -9.770  -9.123  1.00 27.02           N  
ATOM   1530  NH2 ARG B 103     -58.463  -9.081  -9.914  1.00 26.47           N  
ATOM   1531  N   THR B 104     -59.555  -5.457  -6.157  1.00 36.11           N  
ATOM   1532  CA  THR B 104     -58.626  -6.163  -5.272  1.00 38.72           C  
ATOM   1533  C   THR B 104     -58.110  -5.369  -4.074  1.00 39.08           C  
ATOM   1534  O   THR B 104     -57.840  -5.933  -3.017  1.00 37.26           O  
ATOM   1535  CB  THR B 104     -57.395  -6.639  -6.068  1.00 39.42           C  
ATOM   1536  OG1 THR B 104     -57.815  -7.513  -7.123  1.00 42.94           O  
ATOM   1537  CG2 THR B 104     -56.438  -7.378  -5.167  1.00 41.60           C  
ATOM   1538  N   GLY B 105     -57.949  -4.063  -4.250  1.00 41.04           N  
ATOM   1539  CA  GLY B 105     -57.437  -3.235  -3.177  1.00 41.79           C  
ATOM   1540  C   GLY B 105     -55.933  -3.091  -3.289  1.00 43.62           C  
ATOM   1541  O   GLY B 105     -55.312  -2.333  -2.547  1.00 43.16           O  
ATOM   1542  N   GLU B 106     -55.341  -3.820  -4.227  1.00 45.56           N  
ATOM   1543  CA  GLU B 106     -53.900  -3.765  -4.417  1.00 49.82           C  
ATOM   1544  C   GLU B 106     -53.430  -2.436  -4.997  1.00 51.26           C  
ATOM   1545  O   GLU B 106     -54.082  -1.823  -5.841  1.00 50.17           O  
ATOM   1546  CB  GLU B 106     -53.440  -4.937  -5.284  1.00 51.22           C  
ATOM   1547  CG  GLU B 106     -54.300  -5.167  -6.512  1.00 55.72           C  
ATOM   1548  CD  GLU B 106     -54.157  -6.572  -7.050  1.00 56.46           C  
ATOM   1549  OE1 GLU B 106     -54.790  -6.885  -8.079  1.00 56.39           O  
ATOM   1550  OE2 GLU B 106     -53.414  -7.363  -6.431  1.00 58.54           O  
ATOM   1551  N   GLU B 107     -52.275  -2.006  -4.521  1.00 53.92           N  
ATOM   1552  CA  GLU B 107     -51.693  -0.743  -4.911  1.00 57.62           C  
ATOM   1553  C   GLU B 107     -50.886  -0.794  -6.198  1.00 60.69           C  
ATOM   1554  O   GLU B 107     -50.376  -1.842  -6.592  1.00 61.78           O  
ATOM   1555  CB  GLU B 107     -50.802  -0.254  -3.773  1.00 58.17           C  
ATOM   1556  CG  GLU B 107     -50.667   1.245  -3.661  1.00 61.05           C  
ATOM   1557  CD  GLU B 107     -49.712   1.657  -2.551  1.00 61.08           C  
ATOM   1558  OE1 GLU B 107     -49.866   1.159  -1.410  1.00 58.88           O  
ATOM   1559  OE2 GLU B 107     -48.814   2.485  -2.826  1.00 61.46           O  
ATOM   1560  N   ASP B 108     -50.795   0.368  -6.841  1.00 63.58           N  
ATOM   1561  CA  ASP B 108     -50.035   0.603  -8.074  1.00 66.70           C  
ATOM   1562  C   ASP B 108     -49.888  -0.500  -9.124  1.00 67.56           C  
ATOM   1563  O   ASP B 108     -50.866  -0.902  -9.750  1.00 67.15           O  
ATOM   1564  CB  ASP B 108     -48.642   1.125  -7.697  1.00 67.35           C  
ATOM   1565  CG  ASP B 108     -48.705   2.359  -6.815  1.00 67.86           C  
ATOM   1566  OD1 ASP B 108     -49.153   3.419  -7.304  1.00 67.47           O  
ATOM   1567  OD2 ASP B 108     -48.321   2.263  -5.630  1.00 67.82           O  
ATOM   1568  N   GLU B 109     -48.648  -0.948  -9.327  1.00 69.92           N  
ATOM   1569  CA  GLU B 109     -48.323  -1.983 -10.314  1.00 72.15           C  
ATOM   1570  C   GLU B 109     -49.212  -3.209 -10.180  1.00 73.35           C  
ATOM   1571  O   GLU B 109     -49.516  -3.875 -11.171  1.00 74.29           O  
ATOM   1572  CB  GLU B 109     -46.854  -2.419 -10.196  1.00 71.65           C  
ATOM   1573  CG  GLU B 109     -45.816  -1.312 -10.351  1.00 71.24           C  
ATOM   1574  CD  GLU B 109     -45.744  -0.385  -9.143  1.00 72.20           C  
ATOM   1575  OE1 GLU B 109     -45.748  -0.893  -7.999  1.00 72.43           O  
ATOM   1576  OE2 GLU B 109     -45.667   0.849  -9.335  1.00 72.31           O  
ATOM   1577  N   ALA B 110     -49.612  -3.518  -8.953  1.00 74.30           N  
ATOM   1578  CA  ALA B 110     -50.480  -4.658  -8.716  1.00 75.83           C  
ATOM   1579  C   ALA B 110     -51.882  -4.282  -9.199  1.00 76.91           C  
ATOM   1580  O   ALA B 110     -52.747  -5.138  -9.374  1.00 76.66           O  
ATOM   1581  CB  ALA B 110     -50.494  -5.001  -7.229  1.00 74.99           C  
ATOM   1582  N   ALA B 111     -52.089  -2.987  -9.417  1.00 78.69           N  
ATOM   1583  CA  ALA B 111     -53.370  -2.462  -9.879  1.00 80.89           C  
ATOM   1584  C   ALA B 111     -53.271  -2.003 -11.333  1.00 82.19           C  
ATOM   1585  O   ALA B 111     -53.953  -1.066 -11.743  1.00 82.66           O  
ATOM   1586  CB  ALA B 111     -53.803  -1.298  -8.995  1.00 81.05           C  
ATOM   1587  N   VAL B 112     -52.410  -2.666 -12.100  1.00 83.40           N  
ATOM   1588  CA  VAL B 112     -52.210  -2.350 -13.513  1.00 84.40           C  
ATOM   1589  C   VAL B 112     -51.793  -3.621 -14.257  1.00 85.12           C  
ATOM   1590  O   VAL B 112     -50.837  -4.290 -13.866  1.00 84.37           O  
ATOM   1591  CB  VAL B 112     -51.111  -1.266 -13.704  1.00 84.32           C  
ATOM   1592  CG1 VAL B 112     -50.904  -0.990 -15.182  1.00 84.00           C  
ATOM   1593  CG2 VAL B 112     -51.505   0.019 -12.984  1.00 84.22           C  
ATOM   1594  N   THR B 113     -52.519  -3.951 -15.323  1.00 86.68           N  
ATOM   1595  CA  THR B 113     -52.230  -5.145 -16.123  1.00 88.06           C  
ATOM   1596  C   THR B 113     -52.387  -6.440 -15.324  1.00 87.62           C  
ATOM   1597  O   THR B 113     -53.225  -7.282 -15.719  1.00 87.02           O  
ATOM   1598  CB  THR B 113     -50.792  -5.086 -16.729  1.00 88.92           C  
ATOM   1599  OG1 THR B 113     -50.777  -4.186 -17.847  1.00 89.06           O  
ATOM   1600  CG2 THR B 113     -50.334  -6.468 -17.188  1.00 89.19           C  
TER    1601      THR B 113                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
