
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  736),  selected   98 , name 1gnk_A
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 1gnk_A.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      K       3           -
LGA    -       -      R       4           -
LGA    M     1_A      A       5          1.035
LGA    K     2_A      N       6          0.687
LGA    L     3_A      K       7          0.599
LGA    V     4_A      L       8          0.885
LGA    T     5_A      V       9          0.884
LGA    V     6_A      I      10          0.756
LGA    I     7_A      V      11          0.514
LGA    I     8_A      T      12          0.416
LGA    K     9_A      E      13          0.413
LGA    P    10_A      K      14          0.156
LGA    F    11_A      V      15          0.343
LGA    K    12_A      L      16          0.552
LGA    L    13_A      L      17          0.911
LGA    E    14_A      K      18          0.850
LGA    D    15_A      K      19          0.852
LGA    V    16_A      V      20          0.609
LGA    R    17_A      A      21          0.961
LGA    E    18_A      K      22          1.019
LGA    A    19_A      I      23          1.429
LGA    L    20_A      I      24          1.696
LGA    S    21_A      E      25          1.699
LGA    S    22_A      E      26          1.681
LGA    I    23_A      A      27          1.590
LGA    G    24_A      G      28          1.395
LGA    I    25_A      A      29          1.770
LGA    Q    26_A      T      30          5.048
LGA    G    27_A      G      31          1.298
LGA    L    28_A      Y      32          0.989
LGA    T    29_A      T      33          0.458
LGA    V    30_A      V      34          0.590
LGA    T    31_A      V      35          0.507
LGA    E    32_A      D      36          0.560
LGA    V    33_A      T      37          0.601
LGA    K    34_A      G      38          0.294
LGA    G    35_A      G      39          0.615
LGA    F    36_A      -       -           -
LGA    G    37_A      -       -           -
LGA    R    38_A      -       -           -
LGA    V    53_A      -       -           -
LGA    N    54_A      -       -           -
LGA    F    55_A      -       -           -
LGA    L    56_A      -       -           -
LGA    P    57_A      S      58          0.967
LGA    K    58_A      N      59          0.621
LGA    V    59_A      V      60          0.331
LGA    K    60_A      K      61          0.476
LGA    I    61_A      F      62          0.440
LGA    D    62_A      E      63          0.437
LGA    V    63_A      V      64          0.415
LGA    A    64_A      L      65          0.407
LGA    I    65_A      T      66          0.898
LGA    A    66_A      E      67          2.465
LGA    D    67_A      N      68          2.946
LGA    D    68_A      R      69          3.164
LGA    -       -      E      70           -
LGA    Q    69_A      M      71          1.838
LGA    L    70_A      A      72          2.554
LGA    D    71_A      E      73          1.939
LGA    E    72_A      K      74          1.116
LGA    V    73_A      I      75          2.059
LGA    I    74_A      A      76          1.651
LGA    D    75_A      D      77          1.042
LGA    I    76_A      Q      78          1.717
LGA    V    77_A      V      79          2.352
LGA    S    78_A      A      80          1.494
LGA    K    79_A      I      81          2.951
LGA    A    80_A      K      82          4.113
LGA    A    81_A      F      83          3.718
LGA    Y    82_A      F      84          2.836
LGA    T    83_A      T      85          4.780
LGA    G    84_A      D      86          1.979
LGA    K    85_A      Y      87          4.613
LGA    I    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    D    88_A      A      88          1.176
LGA    G    89_A      G      89          0.542
LGA    K    90_A      I      90          0.130
LGA    I    91_A      I      91          0.615
LGA    F    92_A      Y      92          1.581
LGA    V    93_A      I      93          0.893
LGA    A    94_A      C      94          0.596
LGA    E    95_A      E      95          0.362
LGA    L    96_A      A      96          0.949
LGA    Q    97_A      E      97          1.311
LGA    R    98_A      V      98          1.785
LGA    V    99_A      L      99          3.534
LGA    I   100_A      Y     100          0.373
LGA    R   101_A      G     101          2.047
LGA    I   102_A      -       -           -
LGA    R   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    G   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    A   107_A      -       -           -
LGA    D   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    A   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    L   112_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   83    5.0     78    1.77    20.51     86.182     4.177

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.776671 * X  +  -0.107208 * Y  +  -0.620717 * Z  + -38.493050
  Y_new =   0.617755 * X  +   0.062989 * Y  +  -0.783844 * Z  +  16.715778
  Z_new =   0.123132 * X  +  -0.992239 * Y  +   0.017307 * Z  +  -1.779643 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.553356    1.588237  [ DEG:   -89.0007     90.9993 ]
  Theta =  -0.123446   -3.018147  [ DEG:    -7.0729   -172.9271 ]
  Phi   =   2.469670   -0.671923  [ DEG:   141.5017    -38.4983 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gnk_A                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gnk_A.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   83   5.0   78   1.77   20.51  86.182
REMARK  ---------------------------------------------------------- 
MOLECULE 1gnk_A
HEADER    SIGNALING PROTEIN                       14-JUL-98   1GNK              
TITLE     GLNK, A SIGNAL PROTEIN FROM E. COLI                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN (GLNK);                                            
COMPND   3 CHAIN: A, B                                                          
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: RB9040;                                                      
SOURCE   4 PLASMID: PNV102                                                      
KEYWDS    SIGNALING PROTEIN                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.XU,E.CHEAH,P.D.CARR,W.C.VANHEESWIJK,H.V.WESTERHOFF,                 
AUTHOR   2 S.G.VASUDEVAN,D.L.OLLIS                                              
REVDAT   2   01-APR-03 1GNK    1       JRNL                                     
REVDAT   1   23-JUL-99 1GNK    0                                                
JRNL        AUTH   Y.XU,E.CHEAH,P.D.CARR,W.C.VAN HEESWIJK,                      
JRNL        AUTH 2 H.V.WESTERHOFF,S.G.VASUDEVAN,D.L.OLLIS                       
JRNL        TITL   GLNK, A PII-HOMOLOGUE: STRUCTURE REVEALS ATP                 
JRNL        TITL 2 BINDING SITE AND INDICATES HOW THE T-LOOPS MAY BE            
JRNL        TITL 3 INVOLVED IN MOLECULAR RECOGNITION.                           
JRNL        REF    J.MOL.BIOL.                   V. 282   149 1998              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1GNK A    1   112  UNP    P0AC55   GLNK_ECOLI       1    112             
DBREF  1GNK B    1   112  UNP    P0AC55   GLNK_ECOLI       1    112             
SEQRES   1 A  112  MET LYS LEU VAL THR VAL ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 A  112  GLU ASP VAL ARG GLU ALA LEU SER SER ILE GLY ILE GLN          
SEQRES   3 A  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 A  112  LYS GLY HIS ALA GLU LEU TYR ARG GLY ALA GLU TYR SER          
SEQRES   5 A  112  VAL ASN PHE LEU PRO LYS VAL LYS ILE ASP VAL ALA ILE          
SEQRES   6 A  112  ALA ASP ASP GLN LEU ASP GLU VAL ILE ASP ILE VAL SER          
SEQRES   7 A  112  LYS ALA ALA TYR THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 A  112  PHE VAL ALA GLU LEU GLN ARG VAL ILE ARG ILE ARG THR          
SEQRES   9 A  112  GLY GLU ALA ASP GLU ALA ALA LEU                              
SEQRES   1 B  112  MET LYS LEU VAL THR VAL ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 B  112  GLU ASP VAL ARG GLU ALA LEU SER SER ILE GLY ILE GLN          
SEQRES   3 B  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 B  112  LYS GLY HIS ALA GLU LEU TYR ARG GLY ALA GLU TYR SER          
SEQRES   5 B  112  VAL ASN PHE LEU PRO LYS VAL LYS ILE ASP VAL ALA ILE          
SEQRES   6 B  112  ALA ASP ASP GLN LEU ASP GLU VAL ILE ASP ILE VAL SER          
SEQRES   7 B  112  LYS ALA ALA TYR THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 B  112  PHE VAL ALA GLU LEU GLN ARG VAL ILE ARG ILE ARG THR          
SEQRES   9 B  112  GLY GLU ALA ASP GLU ALA ALA LEU                              
HET    SO4    135       5                                                       
HET    SO4    136       5                                                       
HETNAM     SO4 SULFATE ION                                                      
FORMUL   3  SO4    2(O4 S 2-)                                                   
FORMUL   5  HOH   *131(H2 O)                                                    
CRYST1   85.530   85.530   85.530  90.00  90.00  90.00 P 21 3       24          
ATOM      1  N   MET A   1     -46.046   5.996 -10.133  1.00 18.39           N  
ATOM      2  CA  MET A   1     -47.194   5.930 -11.060  1.00 14.74           C  
ATOM      3  C   MET A   1     -47.551   7.323 -11.545  1.00 15.24           C  
ATOM      4  O   MET A   1     -47.260   8.319 -10.874  1.00 14.20           O  
ATOM      5  CB  MET A   1     -48.383   5.274 -10.370  1.00 15.42           C  
ATOM      6  CG  MET A   1     -48.083   3.895  -9.846  1.00 13.67           C  
ATOM      7  SD  MET A   1     -49.545   3.179  -9.169  1.00 12.81           S  
ATOM      8  CE  MET A   1     -49.589   4.086  -7.632  1.00 11.38           C  
ATOM      9  N   LYS A   2     -48.165   7.368 -12.722  1.00 10.45           N  
ATOM     10  CA  LYS A   2     -48.559   8.616 -13.352  1.00 12.61           C  
ATOM     11  C   LYS A   2     -49.988   8.531 -13.847  1.00 13.42           C  
ATOM     12  O   LYS A   2     -50.474   7.446 -14.154  1.00 10.71           O  
ATOM     13  CB  LYS A   2     -47.653   8.914 -14.567  1.00 12.67           C  
ATOM     14  CG  LYS A   2     -46.143   9.071 -14.278  1.00 12.32           C  
ATOM     15  CD  LYS A   2     -45.859  10.341 -13.499  1.00 12.94           C  
ATOM     16  CE  LYS A   2     -44.373  10.518 -13.266  1.00 16.87           C  
ATOM     17  NZ  LYS A   2     -43.970   9.720 -12.084  1.00 29.30           N  
ATOM     18  N   LEU A   3     -50.672   9.673 -13.892  1.00 13.83           N  
ATOM     19  CA  LEU A   3     -52.036   9.729 -14.423  1.00 15.05           C  
ATOM     20  C   LEU A   3     -51.859  10.545 -15.690  1.00 12.59           C  
ATOM     21  O   LEU A   3     -51.453  11.700 -15.620  1.00 13.45           O  
ATOM     22  CB  LEU A   3     -52.976  10.429 -13.450  1.00 12.74           C  
ATOM     23  CG  LEU A   3     -54.496  10.229 -13.625  1.00 22.35           C  
ATOM     24  CD1 LEU A   3     -55.020  10.909 -14.855  1.00 18.53           C  
ATOM     25  CD2 LEU A   3     -54.841   8.746 -13.674  1.00 22.82           C  
ATOM     26  N   VAL A   4     -52.022   9.903 -16.842  1.00 14.20           N  
ATOM     27  CA  VAL A   4     -51.860  10.572 -18.145  1.00 12.64           C  
ATOM     28  C   VAL A   4     -53.215  10.921 -18.729  1.00 15.39           C  
ATOM     29  O   VAL A   4     -54.084  10.044 -18.892  1.00 15.64           O  
ATOM     30  CB  VAL A   4     -51.100   9.695 -19.194  1.00 13.37           C  
ATOM     31  CG1 VAL A   4     -51.030  10.438 -20.507  1.00 10.72           C  
ATOM     32  CG2 VAL A   4     -49.665   9.368 -18.725  1.00 12.04           C  
ATOM     33  N   THR A   5     -53.408  12.211 -18.996  1.00 14.35           N  
ATOM     34  CA  THR A   5     -54.656  12.696 -19.565  1.00 14.26           C  
ATOM     35  C   THR A   5     -54.421  13.122 -20.999  1.00 13.98           C  
ATOM     36  O   THR A   5     -53.493  13.892 -21.270  1.00 14.65           O  
ATOM     37  CB  THR A   5     -55.185  13.909 -18.805  1.00 13.74           C  
ATOM     38  OG1 THR A   5     -55.349  13.568 -17.420  1.00 17.47           O  
ATOM     39  CG2 THR A   5     -56.529  14.337 -19.391  1.00 12.04           C  
ATOM     40  N   VAL A   6     -55.274  12.654 -21.902  1.00 10.56           N  
ATOM     41  CA  VAL A   6     -55.157  12.983 -23.320  1.00 12.10           C  
ATOM     42  C   VAL A   6     -56.447  13.628 -23.879  1.00 13.26           C  
ATOM     43  O   VAL A   6     -57.516  13.032 -23.809  1.00 11.24           O  
ATOM     44  CB  VAL A   6     -54.817  11.723 -24.143  1.00  9.89           C  
ATOM     45  CG1 VAL A   6     -54.401  12.124 -25.543  1.00 12.76           C  
ATOM     46  CG2 VAL A   6     -53.710  10.904 -23.445  1.00  7.22           C  
ATOM     47  N   ILE A   7     -56.345  14.857 -24.388  1.00 15.12           N  
ATOM     48  CA  ILE A   7     -57.497  15.566 -24.959  1.00 15.80           C  
ATOM     49  C   ILE A   7     -57.306  15.459 -26.461  1.00 14.63           C  
ATOM     50  O   ILE A   7     -56.302  15.938 -26.978  1.00 17.74           O  
ATOM     51  CB  ILE A   7     -57.490  17.066 -24.562  1.00 16.33           C  
ATOM     52  CG1 ILE A   7     -57.276  17.214 -23.054  1.00 20.74           C  
ATOM     53  CG2 ILE A   7     -58.825  17.737 -24.965  1.00 18.85           C  
ATOM     54  CD1 ILE A   7     -58.448  16.814 -22.213  1.00 18.66           C  
ATOM     55  N   ILE A   8     -58.264  14.891 -27.181  1.00 13.02           N  
ATOM     56  CA  ILE A   8     -58.081  14.715 -28.616  1.00 12.47           C  
ATOM     57  C   ILE A   8     -59.322  15.022 -29.433  1.00 14.93           C  
ATOM     58  O   ILE A   8     -60.338  15.467 -28.909  1.00 18.99           O  
ATOM     59  CB  ILE A   8     -57.673  13.224 -28.914  1.00 16.72           C  
ATOM     60  CG1 ILE A   8     -58.769  12.267 -28.418  1.00 17.53           C  
ATOM     61  CG2 ILE A   8     -56.314  12.873 -28.257  1.00 19.38           C  
ATOM     62  CD1 ILE A   8     -58.513  10.826 -28.720  1.00 19.57           C  
ATOM     63  N   LYS A   9     -59.218  14.812 -30.743  1.00 16.22           N  
ATOM     64  CA  LYS A   9     -60.355  14.971 -31.639  1.00 16.68           C  
ATOM     65  C   LYS A   9     -61.169  13.705 -31.388  1.00 16.38           C  
ATOM     66  O   LYS A   9     -60.602  12.607 -31.386  1.00 14.52           O  
ATOM     67  CB  LYS A   9     -59.863  15.032 -33.088  1.00 17.88           C  
ATOM     68  CG  LYS A   9     -59.443  16.422 -33.463  1.00 19.96           C  
ATOM     69  CD  LYS A   9     -58.476  16.508 -34.615  1.00 20.73           C  
ATOM     70  CE  LYS A   9     -58.308  17.976 -34.922  1.00 21.07           C  
ATOM     71  NZ  LYS A   9     -57.171  18.260 -35.817  1.00 25.50           N  
ATOM     72  N   PRO A  10     -62.510  13.820 -31.165  1.00 15.83           N  
ATOM     73  CA  PRO A  10     -63.386  12.678 -30.898  1.00 15.38           C  
ATOM     74  C   PRO A  10     -63.246  11.526 -31.893  1.00 15.45           C  
ATOM     75  O   PRO A  10     -63.326  10.356 -31.505  1.00 15.37           O  
ATOM     76  CB  PRO A  10     -64.788  13.288 -30.928  1.00 10.40           C  
ATOM     77  CG  PRO A  10     -64.549  14.666 -30.448  1.00 12.18           C  
ATOM     78  CD  PRO A  10     -63.293  15.069 -31.187  1.00  9.95           C  
ATOM     79  N   PHE A  11     -63.031  11.850 -33.165  1.00 14.60           N  
ATOM     80  CA  PHE A  11     -62.876  10.812 -34.178  1.00 15.86           C  
ATOM     81  C   PHE A  11     -61.550  10.026 -34.130  1.00 17.28           C  
ATOM     82  O   PHE A  11     -61.402   9.019 -34.816  1.00 16.13           O  
ATOM     83  CB  PHE A  11     -63.138  11.361 -35.583  1.00 13.83           C  
ATOM     84  CG  PHE A  11     -62.150  12.378 -36.049  1.00 11.42           C  
ATOM     85  CD1 PHE A  11     -62.366  13.734 -35.802  1.00 17.47           C  
ATOM     86  CD2 PHE A  11     -61.043  12.007 -36.790  1.00 13.66           C  
ATOM     87  CE1 PHE A  11     -61.493  14.705 -36.302  1.00 14.69           C  
ATOM     88  CE2 PHE A  11     -60.168  12.961 -37.290  1.00 11.44           C  
ATOM     89  CZ  PHE A  11     -60.397  14.318 -37.044  1.00 14.91           C  
ATOM     90  N   LYS A  12     -60.596  10.482 -33.318  1.00 18.81           N  
ATOM     91  CA  LYS A  12     -59.307   9.811 -33.185  1.00 17.49           C  
ATOM     92  C   LYS A  12     -59.280   8.837 -32.003  1.00 16.03           C  
ATOM     93  O   LYS A  12     -58.276   8.157 -31.760  1.00 17.76           O  
ATOM     94  CB  LYS A  12     -58.168  10.844 -33.051  1.00 16.98           C  
ATOM     95  CG  LYS A  12     -57.864  11.632 -34.316  1.00 14.67           C  
ATOM     96  CD  LYS A  12     -57.427  10.709 -35.439  1.00 15.41           C  
ATOM     97  CE  LYS A  12     -55.974  10.380 -35.297  1.00 19.19           C  
ATOM     98  NZ  LYS A  12     -55.445   9.558 -36.421  1.00 24.03           N  
ATOM     99  N   LEU A  13     -60.398   8.739 -31.304  1.00 14.16           N  
ATOM    100  CA  LEU A  13     -60.528   7.869 -30.143  1.00 19.15           C  
ATOM    101  C   LEU A  13     -60.177   6.412 -30.464  1.00 23.03           C  
ATOM    102  O   LEU A  13     -59.363   5.802 -29.768  1.00 24.95           O  
ATOM    103  CB  LEU A  13     -61.956   7.918 -29.595  1.00 20.93           C  
ATOM    104  CG  LEU A  13     -62.289   7.711 -28.100  1.00 23.38           C  
ATOM    105  CD1 LEU A  13     -63.713   7.188 -27.931  1.00 21.43           C  
ATOM    106  CD2 LEU A  13     -61.329   6.780 -27.443  1.00 21.18           C  
ATOM    107  N   GLU A  14     -60.779   5.839 -31.501  1.00 21.20           N  
ATOM    108  CA  GLU A  14     -60.475   4.443 -31.812  1.00 22.57           C  
ATOM    109  C   GLU A  14     -59.004   4.229 -32.150  1.00 18.96           C  
ATOM    110  O   GLU A  14     -58.403   3.235 -31.737  1.00 17.56           O  
ATOM    111  CB  GLU A  14     -61.372   3.902 -32.933  1.00 28.78           C  
ATOM    112  CG  GLU A  14     -61.190   2.404 -33.228  1.00 32.13           C  
ATOM    113  CD  GLU A  14     -61.474   1.504 -32.023  1.00 37.14           C  
ATOM    114  OE1 GLU A  14     -62.338   1.862 -31.180  1.00 36.83           O  
ATOM    115  OE2 GLU A  14     -60.829   0.429 -31.926  1.00 38.52           O  
ATOM    116  N   ASP A  15     -58.418   5.154 -32.895  1.00 17.22           N  
ATOM    117  CA  ASP A  15     -57.022   5.014 -33.238  1.00 19.30           C  
ATOM    118  C   ASP A  15     -56.174   5.044 -31.967  1.00 19.92           C  
ATOM    119  O   ASP A  15     -55.252   4.233 -31.803  1.00 20.23           O  
ATOM    120  CB  ASP A  15     -56.593   6.106 -34.213  1.00 22.20           C  
ATOM    121  CG  ASP A  15     -57.217   5.938 -35.605  1.00 28.53           C  
ATOM    122  OD1 ASP A  15     -57.068   6.866 -36.433  1.00 28.98           O  
ATOM    123  OD2 ASP A  15     -57.860   4.890 -35.865  1.00 29.17           O  
ATOM    124  N   VAL A  16     -56.505   5.942 -31.046  1.00 18.67           N  
ATOM    125  CA  VAL A  16     -55.749   6.024 -29.803  1.00 18.05           C  
ATOM    126  C   VAL A  16     -55.929   4.748 -28.982  1.00 17.76           C  
ATOM    127  O   VAL A  16     -54.939   4.143 -28.553  1.00 18.49           O  
ATOM    128  CB  VAL A  16     -56.103   7.292 -28.979  1.00 18.66           C  
ATOM    129  CG1 VAL A  16     -55.316   7.307 -27.689  1.00 15.28           C  
ATOM    130  CG2 VAL A  16     -55.793   8.555 -29.808  1.00 17.33           C  
ATOM    131  N   ARG A  17     -57.175   4.301 -28.833  1.00 16.82           N  
ATOM    132  CA  ARG A  17     -57.470   3.079 -28.095  1.00 18.76           C  
ATOM    133  C   ARG A  17     -56.717   1.855 -28.673  1.00 18.62           C  
ATOM    134  O   ARG A  17     -56.041   1.138 -27.949  1.00 18.07           O  
ATOM    135  CB  ARG A  17     -58.972   2.819 -28.087  1.00 18.10           C  
ATOM    136  CG  ARG A  17     -59.415   1.723 -27.123  1.00 23.82           C  
ATOM    137  CD  ARG A  17     -60.670   0.986 -27.618  1.00 28.24           C  
ATOM    138  NE  ARG A  17     -60.400   0.302 -28.889  1.00 33.17           N  
ATOM    139  CZ  ARG A  17     -60.040  -0.976 -28.999  1.00 33.23           C  
ATOM    140  NH1 ARG A  17     -59.801  -1.502 -30.190  1.00 33.17           N  
ATOM    141  NH2 ARG A  17     -59.920  -1.732 -27.917  1.00 35.34           N  
ATOM    142  N   GLU A  18     -56.808   1.628 -29.975  1.00 23.28           N  
ATOM    143  CA  GLU A  18     -56.125   0.489 -30.583  1.00 24.40           C  
ATOM    144  C   GLU A  18     -54.615   0.605 -30.391  1.00 25.17           C  
ATOM    145  O   GLU A  18     -53.927  -0.395 -30.127  1.00 28.79           O  
ATOM    146  CB  GLU A  18     -56.466   0.381 -32.070  1.00 27.12           C  
ATOM    147  N   ALA A  19     -54.097   1.822 -30.511  1.00 21.89           N  
ATOM    148  CA  ALA A  19     -52.664   2.043 -30.324  1.00 19.72           C  
ATOM    149  C   ALA A  19     -52.246   1.686 -28.885  1.00 18.99           C  
ATOM    150  O   ALA A  19     -51.274   0.973 -28.678  1.00 16.77           O  
ATOM    151  CB  ALA A  19     -52.304   3.494 -30.644  1.00 17.73           C  
ATOM    152  N   LEU A  20     -52.992   2.164 -27.895  1.00 15.66           N  
ATOM    153  CA  LEU A  20     -52.661   1.859 -26.517  1.00 16.07           C  
ATOM    154  C   LEU A  20     -52.804   0.359 -26.290  1.00 19.97           C  
ATOM    155  O   LEU A  20     -51.976  -0.257 -25.624  1.00 22.84           O  
ATOM    156  CB  LEU A  20     -53.575   2.624 -25.561  1.00 17.49           C  
ATOM    157  CG  LEU A  20     -53.091   3.853 -24.785  1.00 17.91           C  
ATOM    158  CD1 LEU A  20     -51.718   4.301 -25.198  1.00 18.24           C  
ATOM    159  CD2 LEU A  20     -54.117   4.946 -24.899  1.00 16.87           C  
ATOM    160  N   SER A  21     -53.853  -0.230 -26.857  1.00 20.49           N  
ATOM    161  CA  SER A  21     -54.105  -1.656 -26.729  1.00 22.19           C  
ATOM    162  C   SER A  21     -52.940  -2.431 -27.325  1.00 23.50           C  
ATOM    163  O   SER A  21     -52.584  -3.488 -26.808  1.00 25.89           O  
ATOM    164  CB  SER A  21     -55.418  -2.047 -27.429  1.00 22.21           C  
ATOM    165  OG  SER A  21     -55.673  -3.450 -27.346  1.00 23.52           O  
ATOM    166  N   SER A  22     -52.331  -1.909 -28.391  1.00 23.31           N  
ATOM    167  CA  SER A  22     -51.196  -2.591 -29.005  1.00 22.72           C  
ATOM    168  C   SER A  22     -49.995  -2.670 -28.064  1.00 23.92           C  
ATOM    169  O   SER A  22     -49.085  -3.471 -28.299  1.00 26.15           O  
ATOM    170  CB  SER A  22     -50.777  -1.925 -30.311  1.00 23.23           C  
ATOM    171  OG  SER A  22     -50.117  -0.691 -30.082  1.00 26.42           O  
ATOM    172  N   ILE A  23     -49.947  -1.804 -27.046  1.00 23.08           N  
ATOM    173  CA  ILE A  23     -48.859  -1.869 -26.070  1.00 18.85           C  
ATOM    174  C   ILE A  23     -49.342  -2.402 -24.714  1.00 20.36           C  
ATOM    175  O   ILE A  23     -48.769  -2.074 -23.679  1.00 24.50           O  
ATOM    176  CB  ILE A  23     -48.098  -0.533 -25.854  1.00 19.42           C  
ATOM    177  CG1 ILE A  23     -49.052   0.618 -25.536  1.00 19.14           C  
ATOM    178  CG2 ILE A  23     -47.228  -0.228 -27.038  1.00 19.59           C  
ATOM    179  CD1 ILE A  23     -48.348   1.833 -24.977  1.00 18.64           C  
ATOM    180  N   GLY A  24     -50.415  -3.192 -24.716  1.00 18.52           N  
ATOM    181  CA  GLY A  24     -50.939  -3.773 -23.485  1.00 20.04           C  
ATOM    182  C   GLY A  24     -51.760  -2.906 -22.540  1.00 19.88           C  
ATOM    183  O   GLY A  24     -52.043  -3.318 -21.407  1.00 15.39           O  
ATOM    184  N   ILE A  25     -52.128  -1.708 -22.982  1.00 19.58           N  
ATOM    185  CA  ILE A  25     -52.936  -0.811 -22.159  1.00 20.15           C  
ATOM    186  C   ILE A  25     -54.368  -0.752 -22.703  1.00 21.39           C  
ATOM    187  O   ILE A  25     -54.622  -0.119 -23.723  1.00 21.06           O  
ATOM    188  CB  ILE A  25     -52.320   0.599 -22.106  1.00 19.64           C  
ATOM    189  CG1 ILE A  25     -50.961   0.543 -21.397  1.00 20.11           C  
ATOM    190  CG2 ILE A  25     -53.246   1.544 -21.382  1.00 19.76           C  
ATOM    191  CD1 ILE A  25     -50.141   1.796 -21.531  1.00 15.74           C  
ATOM    192  N   GLN A  26     -55.296  -1.410 -22.011  1.00 20.95           N  
ATOM    193  CA  GLN A  26     -56.689  -1.450 -22.437  1.00 22.60           C  
ATOM    194  C   GLN A  26     -57.650  -0.684 -21.536  1.00 22.92           C  
ATOM    195  O   GLN A  26     -58.719  -0.237 -21.984  1.00 22.24           O  
ATOM    196  CB  GLN A  26     -57.151  -2.901 -22.572  1.00 23.21           C  
ATOM    197  CG  GLN A  26     -56.814  -3.544 -23.905  1.00 29.17           C  
ATOM    198  CD  GLN A  26     -56.775  -5.051 -23.841  1.00 33.57           C  
ATOM    199  OE1 GLN A  26     -57.514  -5.757 -24.525  1.00 35.12           O  
ATOM    200  NE2 GLN A  26     -55.896  -5.557 -23.004  1.00 38.96           N  
ATOM    201  N   GLY A  27     -57.291  -0.546 -20.265  1.00 23.57           N  
ATOM    202  CA  GLY A  27     -58.156   0.159 -19.333  1.00 24.17           C  
ATOM    203  C   GLY A  27     -57.974   1.668 -19.339  1.00 26.10           C  
ATOM    204  O   GLY A  27     -56.981   2.170 -18.812  1.00 27.94           O  
ATOM    205  N   LEU A  28     -58.921   2.379 -19.950  1.00 24.68           N  
ATOM    206  CA  LEU A  28     -58.910   3.847 -20.024  1.00 21.06           C  
ATOM    207  C   LEU A  28     -60.281   4.370 -19.626  1.00 20.67           C  
ATOM    208  O   LEU A  28     -61.279   3.661 -19.712  1.00 22.30           O  
ATOM    209  CB  LEU A  28     -58.671   4.364 -21.443  1.00 19.65           C  
ATOM    210  CG  LEU A  28     -58.259   3.534 -22.646  1.00 18.51           C  
ATOM    211  CD1 LEU A  28     -58.461   4.348 -23.897  1.00 16.78           C  
ATOM    212  CD2 LEU A  28     -56.823   3.150 -22.532  1.00 19.26           C  
ATOM    213  N   THR A  29     -60.345   5.646 -19.290  1.00 20.98           N  
ATOM    214  CA  THR A  29     -61.600   6.273 -18.914  1.00 19.00           C  
ATOM    215  C   THR A  29     -61.766   7.380 -19.946  1.00 16.43           C  
ATOM    216  O   THR A  29     -60.846   8.161 -20.161  1.00 14.42           O  
ATOM    217  CB  THR A  29     -61.492   6.870 -17.482  1.00 18.05           C  
ATOM    218  OG1 THR A  29     -61.244   5.820 -16.549  1.00 24.36           O  
ATOM    219  CG2 THR A  29     -62.774   7.564 -17.070  1.00 20.05           C  
ATOM    220  N   VAL A  30     -62.917   7.418 -20.602  1.00 17.11           N  
ATOM    221  CA  VAL A  30     -63.205   8.426 -21.614  1.00 16.60           C  
ATOM    222  C   VAL A  30     -64.274   9.402 -21.105  1.00 16.70           C  
ATOM    223  O   VAL A  30     -65.233   8.994 -20.439  1.00 15.92           O  
ATOM    224  CB  VAL A  30     -63.688   7.764 -22.932  1.00 17.61           C  
ATOM    225  CG1 VAL A  30     -64.120   8.819 -23.968  1.00 17.76           C  
ATOM    226  CG2 VAL A  30     -62.579   6.894 -23.521  1.00 18.76           C  
ATOM    227  N   THR A  31     -64.070  10.685 -21.395  1.00 15.17           N  
ATOM    228  CA  THR A  31     -64.981  11.752 -21.022  1.00 13.20           C  
ATOM    229  C   THR A  31     -65.158  12.699 -22.200  1.00 13.99           C  
ATOM    230  O   THR A  31     -64.196  13.024 -22.895  1.00 11.42           O  
ATOM    231  CB  THR A  31     -64.419  12.550 -19.828  1.00 12.34           C  
ATOM    232  OG1 THR A  31     -64.178  11.645 -18.745  1.00 14.19           O  
ATOM    233  CG2 THR A  31     -65.400  13.671 -19.357  1.00  8.29           C  
ATOM    234  N   GLU A  32     -66.404  13.113 -22.434  1.00 15.69           N  
ATOM    235  CA  GLU A  32     -66.725  14.056 -23.497  1.00 15.99           C  
ATOM    236  C   GLU A  32     -66.546  15.449 -22.900  1.00 15.19           C  
ATOM    237  O   GLU A  32     -67.109  15.762 -21.847  1.00 13.63           O  
ATOM    238  CB  GLU A  32     -68.171  13.900 -23.949  1.00 18.42           C  
ATOM    239  CG  GLU A  32     -68.632  12.486 -24.189  1.00 26.63           C  
ATOM    240  CD  GLU A  32     -70.058  12.435 -24.738  1.00 35.75           C  
ATOM    241  OE1 GLU A  32     -70.441  13.357 -25.497  1.00 42.95           O  
ATOM    242  OE2 GLU A  32     -70.803  11.482 -24.415  1.00 40.53           O  
ATOM    243  N   VAL A  33     -65.754  16.283 -23.563  1.00 17.26           N  
ATOM    244  CA  VAL A  33     -65.484  17.633 -23.083  1.00 17.25           C  
ATOM    245  C   VAL A  33     -65.544  18.618 -24.237  1.00 16.44           C  
ATOM    246  O   VAL A  33     -65.788  18.231 -25.391  1.00 18.33           O  
ATOM    247  CB  VAL A  33     -64.110  17.689 -22.391  1.00 16.25           C  
ATOM    248  CG1 VAL A  33     -64.012  16.575 -21.345  1.00  9.98           C  
ATOM    249  CG2 VAL A  33     -62.985  17.530 -23.402  1.00 14.20           C  
ATOM    250  N   LYS A  34     -65.280  19.883 -23.947  1.00 17.20           N  
ATOM    251  CA  LYS A  34     -65.340  20.909 -24.980  1.00 18.49           C  
ATOM    252  C   LYS A  34     -64.185  21.895 -24.877  1.00 20.53           C  
ATOM    253  O   LYS A  34     -63.680  22.180 -23.786  1.00 19.26           O  
ATOM    254  CB  LYS A  34     -66.661  21.683 -24.872  1.00 20.09           C  
ATOM    255  CG  LYS A  34     -67.920  20.836 -25.029  1.00 31.94           C  
ATOM    256  CD  LYS A  34     -69.164  21.595 -24.554  1.00 39.27           C  
ATOM    257  CE  LYS A  34     -70.475  20.810 -24.758  1.00 46.90           C  
ATOM    258  NZ  LYS A  34     -70.743  19.722 -23.744  1.00 52.47           N  
ATOM    259  N   GLY A  35     -63.761  22.386 -26.032  1.00 20.52           N  
ATOM    260  CA  GLY A  35     -62.713  23.378 -26.108  1.00 20.95           C  
ATOM    261  C   GLY A  35     -63.400  24.565 -26.763  1.00 24.00           C  
ATOM    262  O   GLY A  35     -64.617  24.540 -27.001  1.00 21.89           O  
ATOM    263  N   PHE A  36     -62.623  25.592 -27.083  1.00 25.84           N  
ATOM    264  CA  PHE A  36     -63.146  26.795 -27.716  1.00 27.66           C  
ATOM    265  C   PHE A  36     -62.335  27.195 -28.944  1.00 28.43           C  
ATOM    266  O   PHE A  36     -61.182  26.766 -29.089  1.00 29.67           O  
ATOM    267  CB  PHE A  36     -63.160  27.937 -26.710  1.00 25.91           C  
ATOM    268  CG  PHE A  36     -64.177  27.759 -25.653  1.00 30.05           C  
ATOM    269  CD1 PHE A  36     -63.846  27.134 -24.460  1.00 31.92           C  
ATOM    270  CD2 PHE A  36     -65.490  28.180 -25.858  1.00 28.01           C  
ATOM    271  CE1 PHE A  36     -64.815  26.922 -23.479  1.00 37.39           C  
ATOM    272  CE2 PHE A  36     -66.461  27.976 -24.886  1.00 29.93           C  
ATOM    273  CZ  PHE A  36     -66.125  27.347 -23.693  1.00 32.78           C  
ATOM    274  N   GLY A  37     -62.953  27.993 -29.815  1.00 26.27           N  
ATOM    275  CA  GLY A  37     -62.307  28.480 -31.023  1.00 30.84           C  
ATOM    276  C   GLY A  37     -63.059  29.701 -31.543  1.00 34.48           C  
ATOM    277  O   GLY A  37     -64.165  29.981 -31.085  1.00 34.76           O  
ATOM    278  N   ARG A  38     -62.449  30.459 -32.447  1.00 35.32           N  
ATOM    279  CA  ARG A  38     -63.080  31.648 -33.031  1.00 38.94           C  
ATOM    280  C   ARG A  38     -63.552  31.281 -34.453  1.00 40.94           C  
ATOM    281  O   ARG A  38     -62.873  30.526 -35.164  1.00 43.60           O  
ATOM    282  CB  ARG A  38     -62.078  32.830 -33.082  1.00 39.11           C  
ATOM    283  N   VAL A  53     -67.124  32.937 -30.356  1.00 49.61           N  
ATOM    284  CA  VAL A  53     -66.333  31.938 -29.642  1.00 48.96           C  
ATOM    285  C   VAL A  53     -67.170  30.664 -29.483  1.00 46.72           C  
ATOM    286  O   VAL A  53     -67.980  30.537 -28.570  1.00 51.99           O  
ATOM    287  CB  VAL A  53     -65.882  32.463 -28.271  1.00 49.10           C  
ATOM    288  N   ASN A  54     -66.991  29.731 -30.401  1.00 43.07           N  
ATOM    289  CA  ASN A  54     -67.727  28.475 -30.380  1.00 40.24           C  
ATOM    290  C   ASN A  54     -67.083  27.337 -29.590  1.00 37.82           C  
ATOM    291  O   ASN A  54     -65.875  27.323 -29.337  1.00 35.05           O  
ATOM    292  CB  ASN A  54     -67.989  28.022 -31.807  1.00 41.48           C  
ATOM    293  N   PHE A  55     -67.917  26.370 -29.226  1.00 36.12           N  
ATOM    294  CA  PHE A  55     -67.481  25.173 -28.520  1.00 34.61           C  
ATOM    295  C   PHE A  55     -66.919  24.236 -29.589  1.00 32.45           C  
ATOM    296  O   PHE A  55     -67.306  24.296 -30.763  1.00 34.09           O  
ATOM    297  CB  PHE A  55     -68.671  24.464 -27.856  1.00 35.37           C  
ATOM    298  CG  PHE A  55     -69.193  25.158 -26.638  1.00 38.56           C  
ATOM    299  CD1 PHE A  55     -70.464  25.712 -26.637  1.00 39.68           C  
ATOM    300  CD2 PHE A  55     -68.418  25.241 -25.470  1.00 39.55           C  
ATOM    301  CE1 PHE A  55     -70.973  26.340 -25.499  1.00 43.83           C  
ATOM    302  CE2 PHE A  55     -68.910  25.864 -24.318  1.00 39.17           C  
ATOM    303  CZ  PHE A  55     -70.189  26.414 -24.328  1.00 42.34           C  
ATOM    304  N   LEU A  56     -65.992  23.384 -29.205  1.00 29.51           N  
ATOM    305  CA  LEU A  56     -65.426  22.435 -30.144  1.00 27.08           C  
ATOM    306  C   LEU A  56     -65.412  21.162 -29.318  1.00 25.27           C  
ATOM    307  O   LEU A  56     -64.884  21.146 -28.203  1.00 23.52           O  
ATOM    308  CB  LEU A  56     -64.009  22.863 -30.570  1.00 29.01           C  
ATOM    309  CG  LEU A  56     -63.628  23.905 -31.654  1.00 25.26           C  
ATOM    310  CD1 LEU A  56     -64.488  25.138 -31.661  1.00 29.15           C  
ATOM    311  CD2 LEU A  56     -62.177  24.318 -31.433  1.00 26.23           C  
ATOM    312  N   PRO A  57     -66.111  20.118 -29.791  1.00 24.94           N  
ATOM    313  CA  PRO A  57     -66.187  18.833 -29.086  1.00 22.49           C  
ATOM    314  C   PRO A  57     -64.829  18.181 -29.036  1.00 20.53           C  
ATOM    315  O   PRO A  57     -64.079  18.235 -30.028  1.00 16.62           O  
ATOM    316  CB  PRO A  57     -67.125  18.014 -29.975  1.00 24.55           C  
ATOM    317  CG  PRO A  57     -67.885  19.068 -30.764  1.00 27.15           C  
ATOM    318  CD  PRO A  57     -66.796  20.032 -31.087  1.00 25.35           C  
ATOM    319  N   LYS A  58     -64.527  17.554 -27.904  1.00 17.07           N  
ATOM    320  CA  LYS A  58     -63.243  16.872 -27.718  1.00 15.82           C  
ATOM    321  C   LYS A  58     -63.457  15.636 -26.860  1.00 14.29           C  
ATOM    322  O   LYS A  58     -64.533  15.428 -26.296  1.00 16.01           O  
ATOM    323  CB  LYS A  58     -62.232  17.802 -27.024  1.00 17.61           C  
ATOM    324  CG  LYS A  58     -61.875  19.072 -27.788  1.00 18.66           C  
ATOM    325  CD  LYS A  58     -61.074  18.764 -29.038  1.00 24.15           C  
ATOM    326  CE  LYS A  58     -60.754  20.028 -29.822  1.00 22.82           C  
ATOM    327  NZ  LYS A  58     -59.721  19.709 -30.853  1.00 31.79           N  
ATOM    328  N   VAL A  59     -62.456  14.776 -26.816  1.00 14.99           N  
ATOM    329  CA  VAL A  59     -62.519  13.585 -25.993  1.00 16.85           C  
ATOM    330  C   VAL A  59     -61.318  13.594 -25.061  1.00 13.92           C  
ATOM    331  O   VAL A  59     -60.210  13.932 -25.468  1.00 12.32           O  
ATOM    332  CB  VAL A  59     -62.539  12.292 -26.850  1.00 21.75           C  
ATOM    333  CG1 VAL A  59     -62.073  11.072 -26.040  1.00 21.77           C  
ATOM    334  CG2 VAL A  59     -63.938  12.065 -27.352  1.00 24.61           C  
ATOM    335  N   LYS A  60     -61.592  13.304 -23.795  1.00 14.49           N  
ATOM    336  CA  LYS A  60     -60.593  13.227 -22.742  1.00 12.67           C  
ATOM    337  C   LYS A  60     -60.412  11.755 -22.335  1.00 12.95           C  
ATOM    338  O   LYS A  60     -61.368  11.049 -22.001  1.00 13.78           O  
ATOM    339  CB  LYS A  60     -61.034  14.070 -21.542  1.00  9.77           C  
ATOM    340  CG  LYS A  60     -60.063  13.971 -20.372  1.00 13.38           C  
ATOM    341  CD  LYS A  60     -60.073  15.194 -19.528  1.00 10.86           C  
ATOM    342  CE  LYS A  60     -60.913  15.014 -18.336  1.00 20.13           C  
ATOM    343  NZ  LYS A  60     -60.440  13.919 -17.443  1.00 26.85           N  
ATOM    344  N   ILE A  61     -59.184  11.281 -22.397  1.00 11.87           N  
ATOM    345  CA  ILE A  61     -58.872   9.908 -22.005  1.00 14.75           C  
ATOM    346  C   ILE A  61     -57.941   9.995 -20.815  1.00 14.39           C  
ATOM    347  O   ILE A  61     -56.990  10.781 -20.816  1.00 17.37           O  
ATOM    348  CB  ILE A  61     -58.147   9.154 -23.145  1.00 14.89           C  
ATOM    349  CG1 ILE A  61     -59.076   8.996 -24.358  1.00 14.64           C  
ATOM    350  CG2 ILE A  61     -57.631   7.833 -22.638  1.00 14.82           C  
ATOM    351  CD1 ILE A  61     -58.409   8.502 -25.605  1.00 15.44           C  
ATOM    352  N   ASP A  62     -58.236   9.243 -19.775  1.00 13.36           N  
ATOM    353  CA  ASP A  62     -57.381   9.256 -18.600  1.00 16.23           C  
ATOM    354  C   ASP A  62     -56.842   7.861 -18.483  1.00 18.15           C  
ATOM    355  O   ASP A  62     -57.614   6.890 -18.586  1.00 18.64           O  
ATOM    356  CB  ASP A  62     -58.171   9.600 -17.335  1.00 16.89           C  
ATOM    357  CG  ASP A  62     -58.533  11.067 -17.260  1.00 19.20           C  
ATOM    358  OD1 ASP A  62     -57.611  11.917 -17.258  1.00 22.11           O  
ATOM    359  OD2 ASP A  62     -59.738  11.376 -17.193  1.00 21.01           O  
ATOM    360  N   VAL A  63     -55.526   7.750 -18.325  1.00 15.84           N  
ATOM    361  CA  VAL A  63     -54.898   6.446 -18.190  1.00 18.92           C  
ATOM    362  C   VAL A  63     -53.938   6.430 -16.971  1.00 17.62           C  
ATOM    363  O   VAL A  63     -53.227   7.408 -16.734  1.00 17.43           O  
ATOM    364  CB  VAL A  63     -54.204   6.035 -19.548  1.00 18.46           C  
ATOM    365  CG1 VAL A  63     -52.877   6.703 -19.721  1.00 16.33           C  
ATOM    366  CG2 VAL A  63     -54.014   4.542 -19.624  1.00 22.05           C  
ATOM    367  N   ALA A  64     -54.018   5.390 -16.136  1.00 15.67           N  
ATOM    368  CA  ALA A  64     -53.136   5.267 -14.959  1.00 12.75           C  
ATOM    369  C   ALA A  64     -51.984   4.336 -15.349  1.00 15.10           C  
ATOM    370  O   ALA A  64     -52.220   3.214 -15.813  1.00 12.71           O  
ATOM    371  CB  ALA A  64     -53.908   4.706 -13.760  1.00  9.94           C  
ATOM    372  N   ILE A  65     -50.747   4.794 -15.200  1.00 13.10           N  
ATOM    373  CA  ILE A  65     -49.617   3.980 -15.610  1.00 13.12           C  
ATOM    374  C   ILE A  65     -48.443   3.936 -14.630  1.00 12.09           C  
ATOM    375  O   ILE A  65     -48.397   4.693 -13.663  1.00 14.10           O  
ATOM    376  CB  ILE A  65     -49.050   4.459 -16.991  1.00 13.38           C  
ATOM    377  CG1 ILE A  65     -48.510   5.877 -16.880  1.00  8.45           C  
ATOM    378  CG2 ILE A  65     -50.104   4.368 -18.089  1.00 10.81           C  
ATOM    379  CD1 ILE A  65     -47.730   6.311 -18.078  1.00  8.06           C  
ATOM    380  N   ALA A  66     -47.506   3.024 -14.889  1.00 12.81           N  
ATOM    381  CA  ALA A  66     -46.285   2.898 -14.090  1.00 12.37           C  
ATOM    382  C   ALA A  66     -45.356   3.916 -14.702  1.00 11.96           C  
ATOM    383  O   ALA A  66     -45.424   4.139 -15.898  1.00 10.20           O  
ATOM    384  CB  ALA A  66     -45.678   1.499 -14.245  1.00 13.18           C  
ATOM    385  N   ASP A  67     -44.460   4.500 -13.912  1.00 12.40           N  
ATOM    386  CA  ASP A  67     -43.527   5.512 -14.418  1.00 15.62           C  
ATOM    387  C   ASP A  67     -42.760   5.101 -15.649  1.00 15.76           C  
ATOM    388  O   ASP A  67     -42.494   5.912 -16.523  1.00 14.21           O  
ATOM    389  CB  ASP A  67     -42.527   5.891 -13.340  1.00 17.34           C  
ATOM    390  CG  ASP A  67     -43.198   6.488 -12.118  1.00 21.13           C  
ATOM    391  OD1 ASP A  67     -44.360   6.941 -12.227  1.00 15.45           O  
ATOM    392  OD2 ASP A  67     -42.570   6.481 -11.044  1.00 21.05           O  
ATOM    393  N   ASP A  68     -42.422   3.824 -15.703  1.00 20.95           N  
ATOM    394  CA  ASP A  68     -41.670   3.247 -16.795  1.00 24.08           C  
ATOM    395  C   ASP A  68     -42.411   3.222 -18.136  1.00 24.36           C  
ATOM    396  O   ASP A  68     -41.792   3.046 -19.180  1.00 27.64           O  
ATOM    397  CB  ASP A  68     -41.183   1.836 -16.390  1.00 29.47           C  
ATOM    398  CG  ASP A  68     -40.007   1.881 -15.378  1.00 34.63           C  
ATOM    399  OD1 ASP A  68     -39.123   2.755 -15.519  1.00 40.29           O  
ATOM    400  OD2 ASP A  68     -39.966   1.065 -14.433  1.00 40.73           O  
ATOM    401  N   GLN A  69     -43.729   3.395 -18.114  1.00 22.32           N  
ATOM    402  CA  GLN A  69     -44.521   3.410 -19.348  1.00 20.47           C  
ATOM    403  C   GLN A  69     -44.710   4.831 -19.929  1.00 19.43           C  
ATOM    404  O   GLN A  69     -45.246   4.979 -21.022  1.00 19.40           O  
ATOM    405  CB  GLN A  69     -45.918   2.832 -19.089  1.00 21.99           C  
ATOM    406  CG  GLN A  69     -45.979   1.500 -18.374  1.00 23.16           C  
ATOM    407  CD  GLN A  69     -47.401   1.015 -18.157  1.00 21.55           C  
ATOM    408  OE1 GLN A  69     -48.004   1.281 -17.120  1.00 20.38           O  
ATOM    409  NE2 GLN A  69     -47.927   0.265 -19.106  1.00 21.68           N  
ATOM    410  N   LEU A  70     -44.272   5.867 -19.217  1.00 17.35           N  
ATOM    411  CA  LEU A  70     -44.486   7.241 -19.676  1.00 17.39           C  
ATOM    412  C   LEU A  70     -44.019   7.573 -21.092  1.00 15.82           C  
ATOM    413  O   LEU A  70     -44.789   8.054 -21.894  1.00 18.23           O  
ATOM    414  CB  LEU A  70     -43.884   8.252 -18.688  1.00 17.65           C  
ATOM    415  CG  LEU A  70     -44.626   9.556 -18.324  1.00 20.72           C  
ATOM    416  CD1 LEU A  70     -43.734  10.770 -18.515  1.00 15.59           C  
ATOM    417  CD2 LEU A  70     -45.943   9.719 -19.097  1.00 13.75           C  
ATOM    418  N   ASP A  71     -42.763   7.320 -21.409  1.00 19.69           N  
ATOM    419  CA  ASP A  71     -42.253   7.630 -22.738  1.00 20.90           C  
ATOM    420  C   ASP A  71     -42.933   6.849 -23.850  1.00 19.59           C  
ATOM    421  O   ASP A  71     -43.253   7.396 -24.915  1.00 20.57           O  
ATOM    422  CB  ASP A  71     -40.746   7.421 -22.800  1.00 24.82           C  
ATOM    423  CG  ASP A  71     -39.995   8.381 -21.901  1.00 31.73           C  
ATOM    424  OD1 ASP A  71     -40.558   9.443 -21.539  1.00 33.74           O  
ATOM    425  OD2 ASP A  71     -38.844   8.054 -21.542  1.00 37.73           O  
ATOM    426  N   GLU A  72     -43.167   5.575 -23.606  1.00 16.10           N  
ATOM    427  CA  GLU A  72     -43.810   4.757 -24.603  1.00 18.01           C  
ATOM    428  C   GLU A  72     -45.238   5.268 -24.858  1.00 17.90           C  
ATOM    429  O   GLU A  72     -45.702   5.324 -26.001  1.00 17.25           O  
ATOM    430  CB  GLU A  72     -43.807   3.286 -24.165  1.00 15.57           C  
ATOM    431  CG  GLU A  72     -44.377   2.316 -25.208  1.00 23.30           C  
ATOM    432  CD  GLU A  72     -44.314   0.851 -24.776  1.00 26.38           C  
ATOM    433  OE1 GLU A  72     -44.532   0.546 -23.587  1.00 31.62           O  
ATOM    434  OE2 GLU A  72     -44.071  -0.012 -25.645  1.00 33.84           O  
ATOM    435  N   VAL A  73     -45.939   5.614 -23.786  1.00 16.37           N  
ATOM    436  CA  VAL A  73     -47.293   6.127 -23.911  1.00 16.46           C  
ATOM    437  C   VAL A  73     -47.310   7.457 -24.651  1.00 16.78           C  
ATOM    438  O   VAL A  73     -48.061   7.621 -25.612  1.00 18.87           O  
ATOM    439  CB  VAL A  73     -47.973   6.241 -22.540  1.00 16.52           C  
ATOM    440  CG1 VAL A  73     -49.303   6.918 -22.671  1.00 17.63           C  
ATOM    441  CG2 VAL A  73     -48.176   4.854 -21.959  1.00 14.84           C  
ATOM    442  N   ILE A  74     -46.445   8.382 -24.264  1.00 13.61           N  
ATOM    443  CA  ILE A  74     -46.411   9.666 -24.934  1.00 15.12           C  
ATOM    444  C   ILE A  74     -46.162   9.454 -26.427  1.00 15.03           C  
ATOM    445  O   ILE A  74     -46.801  10.075 -27.278  1.00 15.62           O  
ATOM    446  CB  ILE A  74     -45.309  10.562 -24.321  1.00 17.36           C  
ATOM    447  CG1 ILE A  74     -45.654  10.889 -22.870  1.00 15.77           C  
ATOM    448  CG2 ILE A  74     -45.160  11.858 -25.105  1.00 14.62           C  
ATOM    449  CD1 ILE A  74     -44.575  11.635 -22.166  1.00 17.88           C  
ATOM    450  N   ASP A  75     -45.267   8.527 -26.740  1.00 17.09           N  
ATOM    451  CA  ASP A  75     -44.893   8.221 -28.127  1.00 20.34           C  
ATOM    452  C   ASP A  75     -46.018   7.605 -28.988  1.00 18.88           C  
ATOM    453  O   ASP A  75     -46.316   8.078 -30.091  1.00 17.00           O  
ATOM    454  CB  ASP A  75     -43.657   7.298 -28.134  1.00 21.49           C  
ATOM    455  CG  ASP A  75     -43.167   6.992 -29.541  1.00 22.96           C  
ATOM    456  OD1 ASP A  75     -42.575   7.885 -30.171  1.00 26.88           O  
ATOM    457  OD2 ASP A  75     -43.387   5.872 -30.022  1.00 25.80           O  
ATOM    458  N   ILE A  76     -46.625   6.547 -28.476  1.00 20.16           N  
ATOM    459  CA  ILE A  76     -47.683   5.843 -29.181  1.00 19.80           C  
ATOM    460  C   ILE A  76     -48.918   6.714 -29.265  1.00 17.66           C  
ATOM    461  O   ILE A  76     -49.621   6.698 -30.271  1.00 22.94           O  
ATOM    462  CB  ILE A  76     -48.074   4.518 -28.457  1.00 24.16           C  
ATOM    463  CG1 ILE A  76     -46.819   3.751 -28.035  1.00 28.56           C  
ATOM    464  CG2 ILE A  76     -48.907   3.608 -29.376  1.00 24.72           C  
ATOM    465  CD1 ILE A  76     -45.931   3.327 -29.193  1.00 32.69           C  
ATOM    466  N   VAL A  77     -49.232   7.421 -28.189  1.00 16.19           N  
ATOM    467  CA  VAL A  77     -50.414   8.277 -28.192  1.00 14.76           C  
ATOM    468  C   VAL A  77     -50.278   9.431 -29.184  1.00 13.59           C  
ATOM    469  O   VAL A  77     -51.212   9.709 -29.932  1.00 13.55           O  
ATOM    470  CB  VAL A  77     -50.749   8.816 -26.775  1.00 14.02           C  
ATOM    471  CG1 VAL A  77     -51.791   9.948 -26.858  1.00 16.03           C  
ATOM    472  CG2 VAL A  77     -51.297   7.685 -25.927  1.00 15.02           C  
ATOM    473  N   SER A  78     -49.115  10.093 -29.187  1.00 16.68           N  
ATOM    474  CA  SER A  78     -48.871  11.226 -30.082  1.00 18.74           C  
ATOM    475  C   SER A  78     -49.116  10.803 -31.524  1.00 18.93           C  
ATOM    476  O   SER A  78     -49.915  11.412 -32.244  1.00 19.02           O  
ATOM    477  CB  SER A  78     -47.441  11.734 -29.944  1.00 17.46           C  
ATOM    478  OG  SER A  78     -47.161  12.084 -28.620  1.00 19.21           O  
ATOM    479  N   LYS A  79     -48.445   9.725 -31.909  1.00 17.08           N  
ATOM    480  CA  LYS A  79     -48.530   9.166 -33.244  1.00 18.53           C  
ATOM    481  C   LYS A  79     -49.931   8.774 -33.670  1.00 16.74           C  
ATOM    482  O   LYS A  79     -50.327   9.024 -34.813  1.00 15.39           O  
ATOM    483  CB  LYS A  79     -47.600   7.955 -33.358  1.00 17.00           C  
ATOM    484  CG  LYS A  79     -46.273   8.313 -33.955  1.00 25.57           C  
ATOM    485  CD  LYS A  79     -45.156   8.407 -32.959  1.00 27.36           C  
ATOM    486  CE  LYS A  79     -44.074   7.430 -33.377  1.00 31.02           C  
ATOM    487  NZ  LYS A  79     -42.698   7.824 -32.980  1.00 36.51           N  
ATOM    488  N   ALA A  80     -50.677   8.190 -32.734  1.00 15.67           N  
ATOM    489  CA  ALA A  80     -52.041   7.722 -32.979  1.00 16.28           C  
ATOM    490  C   ALA A  80     -53.105   8.837 -33.060  1.00 17.26           C  
ATOM    491  O   ALA A  80     -54.061   8.741 -33.827  1.00 15.22           O  
ATOM    492  CB  ALA A  80     -52.428   6.673 -31.929  1.00 12.40           C  
ATOM    493  N   ALA A  81     -52.939   9.883 -32.251  1.00 19.72           N  
ATOM    494  CA  ALA A  81     -53.860  11.016 -32.219  1.00 18.10           C  
ATOM    495  C   ALA A  81     -53.578  12.037 -33.323  1.00 20.72           C  
ATOM    496  O   ALA A  81     -54.428  12.867 -33.645  1.00 23.32           O  
ATOM    497  CB  ALA A  81     -53.769  11.713 -30.867  1.00 12.83           C  
ATOM    498  N   TYR A  82     -52.385  11.978 -33.893  1.00 19.35           N  
ATOM    499  CA  TYR A  82     -51.950  12.926 -34.907  1.00 22.58           C  
ATOM    500  C   TYR A  82     -52.772  12.991 -36.197  1.00 25.04           C  
ATOM    501  O   TYR A  82     -53.305  11.983 -36.659  1.00 27.93           O  
ATOM    502  CB  TYR A  82     -50.482  12.633 -35.238  1.00 21.08           C  
ATOM    503  CG  TYR A  82     -49.855  13.519 -36.277  1.00 21.34           C  
ATOM    504  CD1 TYR A  82     -49.340  14.767 -35.937  1.00 24.66           C  
ATOM    505  CD2 TYR A  82     -49.753  13.106 -37.601  1.00 21.31           C  
ATOM    506  CE1 TYR A  82     -48.722  15.579 -36.891  1.00 20.19           C  
ATOM    507  CE2 TYR A  82     -49.154  13.900 -38.557  1.00 21.21           C  
ATOM    508  CZ  TYR A  82     -48.643  15.134 -38.197  1.00 24.23           C  
ATOM    509  OH  TYR A  82     -48.047  15.927 -39.149  1.00 27.42           O  
ATOM    510  N   THR A  83     -52.891  14.198 -36.756  1.00 26.43           N  
ATOM    511  CA  THR A  83     -53.561  14.428 -38.039  1.00 25.18           C  
ATOM    512  C   THR A  83     -52.730  15.463 -38.765  1.00 22.55           C  
ATOM    513  O   THR A  83     -52.641  15.450 -39.974  1.00 28.06           O  
ATOM    514  CB  THR A  83     -55.019  14.990 -37.950  1.00 24.91           C  
ATOM    515  OG1 THR A  83     -55.000  16.336 -37.474  1.00 25.94           O  
ATOM    516  CG2 THR A  83     -55.883  14.146 -37.054  1.00 29.09           C  
ATOM    517  N   GLY A  84     -52.109  16.357 -38.015  1.00 20.16           N  
ATOM    518  CA  GLY A  84     -51.320  17.400 -38.618  1.00 16.19           C  
ATOM    519  C   GLY A  84     -52.089  18.703 -38.735  1.00 16.40           C  
ATOM    520  O   GLY A  84     -51.509  19.737 -39.070  1.00 18.75           O  
ATOM    521  N   LYS A  85     -53.395  18.660 -38.514  1.00 16.52           N  
ATOM    522  CA  LYS A  85     -54.220  19.865 -38.566  1.00 18.77           C  
ATOM    523  C   LYS A  85     -54.312  20.418 -37.139  1.00 20.89           C  
ATOM    524  O   LYS A  85     -54.320  19.631 -36.182  1.00 20.88           O  
ATOM    525  CB  LYS A  85     -55.633  19.537 -39.047  1.00 21.84           C  
ATOM    526  CG  LYS A  85     -55.737  18.659 -40.286  1.00 27.55           C  
ATOM    527  CD  LYS A  85     -57.171  18.691 -40.795  1.00 26.91           C  
ATOM    528  CE  LYS A  85     -57.467  17.516 -41.695  1.00 28.83           C  
ATOM    529  NZ  LYS A  85     -58.923  17.407 -41.919  1.00 24.88           N  
ATOM    530  N   ILE A  86     -54.431  21.742 -36.981  1.00 21.01           N  
ATOM    531  CA  ILE A  86     -54.523  22.316 -35.625  1.00 24.20           C  
ATOM    532  C   ILE A  86     -55.686  21.717 -34.842  1.00 20.97           C  
ATOM    533  O   ILE A  86     -56.665  21.259 -35.424  1.00 19.65           O  
ATOM    534  CB  ILE A  86     -54.670  23.877 -35.599  1.00 26.96           C  
ATOM    535  CG1 ILE A  86     -55.926  24.321 -36.366  1.00 29.52           C  
ATOM    536  CG2 ILE A  86     -53.369  24.551 -36.052  1.00 23.62           C  
ATOM    537  CD1 ILE A  86     -56.331  25.784 -36.121  1.00 27.90           C  
ATOM    538  N   GLY A  87     -55.566  21.720 -33.519  1.00 23.08           N  
ATOM    539  CA  GLY A  87     -56.616  21.160 -32.683  1.00 22.18           C  
ATOM    540  C   GLY A  87     -56.390  19.687 -32.356  1.00 22.58           C  
ATOM    541  O   GLY A  87     -57.262  19.058 -31.729  1.00 24.52           O  
ATOM    542  N   ASP A  88     -55.221  19.150 -32.731  1.00 19.26           N  
ATOM    543  CA  ASP A  88     -54.878  17.741 -32.470  1.00 19.54           C  
ATOM    544  C   ASP A  88     -54.934  17.313 -31.012  1.00 16.15           C  
ATOM    545  O   ASP A  88     -55.121  16.137 -30.728  1.00 16.14           O  
ATOM    546  CB  ASP A  88     -53.524  17.368 -33.062  1.00 19.32           C  
ATOM    547  CG  ASP A  88     -53.644  16.851 -34.483  1.00 20.52           C  
ATOM    548  OD1 ASP A  88     -54.788  16.845 -34.999  1.00 20.62           O  
ATOM    549  OD2 ASP A  88     -52.610  16.466 -35.071  1.00 13.05           O  
ATOM    550  N   GLY A  89     -54.735  18.260 -30.102  1.00 14.75           N  
ATOM    551  CA  GLY A  89     -54.824  17.959 -28.683  1.00 15.56           C  
ATOM    552  C   GLY A  89     -53.531  17.978 -27.891  1.00 15.63           C  
ATOM    553  O   GLY A  89     -52.465  18.314 -28.412  1.00 16.20           O  
ATOM    554  N   LYS A  90     -53.616  17.582 -26.624  1.00 15.89           N  
ATOM    555  CA  LYS A  90     -52.456  17.594 -25.740  1.00 14.31           C  
ATOM    556  C   LYS A  90     -52.459  16.443 -24.756  1.00 14.59           C  
ATOM    557  O   LYS A  90     -53.509  15.835 -24.471  1.00 11.75           O  
ATOM    558  CB  LYS A  90     -52.421  18.900 -24.940  1.00 15.41           C  
ATOM    559  CG  LYS A  90     -52.358  20.147 -25.809  1.00 15.70           C  
ATOM    560  CD  LYS A  90     -52.485  21.432 -25.006  1.00 12.79           C  
ATOM    561  CE  LYS A  90     -52.360  22.601 -25.942  1.00 11.69           C  
ATOM    562  NZ  LYS A  90     -52.459  23.857 -25.201  1.00 12.75           N  
ATOM    563  N   ILE A  91     -51.256  16.145 -24.273  1.00 12.33           N  
ATOM    564  CA  ILE A  91     -51.034  15.097 -23.291  1.00 12.32           C  
ATOM    565  C   ILE A  91     -50.572  15.838 -22.030  1.00 13.07           C  
ATOM    566  O   ILE A  91     -49.720  16.740 -22.110  1.00 13.14           O  
ATOM    567  CB  ILE A  91     -49.923  14.079 -23.753  1.00 11.48           C  
ATOM    568  CG1 ILE A  91     -50.342  13.384 -25.058  1.00  6.84           C  
ATOM    569  CG2 ILE A  91     -49.626  13.061 -22.624  1.00  7.66           C  
ATOM    570  CD1 ILE A  91     -49.221  12.563 -25.720  1.00  7.27           C  
ATOM    571  N   PHE A  92     -51.189  15.519 -20.893  1.00 10.76           N  
ATOM    572  CA  PHE A  92     -50.853  16.150 -19.624  1.00 10.78           C  
ATOM    573  C   PHE A  92     -50.396  15.041 -18.688  1.00 10.86           C  
ATOM    574  O   PHE A  92     -50.962  13.948 -18.671  1.00 10.20           O  
ATOM    575  CB  PHE A  92     -52.071  16.854 -19.033  1.00  7.15           C  
ATOM    576  CG  PHE A  92     -52.684  17.887 -19.947  1.00 14.13           C  
ATOM    577  CD1 PHE A  92     -52.256  19.213 -19.913  1.00 16.25           C  
ATOM    578  CD2 PHE A  92     -53.689  17.537 -20.851  1.00 13.71           C  
ATOM    579  CE1 PHE A  92     -52.825  20.172 -20.772  1.00 18.99           C  
ATOM    580  CE2 PHE A  92     -54.251  18.464 -21.698  1.00 10.04           C  
ATOM    581  CZ  PHE A  92     -53.829  19.784 -21.667  1.00 15.10           C  
ATOM    582  N   VAL A  93     -49.356  15.308 -17.916  1.00 13.51           N  
ATOM    583  CA  VAL A  93     -48.837  14.298 -17.007  1.00 13.09           C  
ATOM    584  C   VAL A  93     -48.813  14.768 -15.562  1.00 11.24           C  
ATOM    585  O   VAL A  93     -48.319  15.859 -15.263  1.00  9.85           O  
ATOM    586  CB  VAL A  93     -47.419  13.872 -17.416  1.00 12.68           C  
ATOM    587  CG1 VAL A  93     -46.868  12.818 -16.433  1.00  8.77           C  
ATOM    588  CG2 VAL A  93     -47.423  13.375 -18.876  1.00  9.74           C  
ATOM    589  N   ALA A  94     -49.336  13.924 -14.675  1.00 10.38           N  
ATOM    590  CA  ALA A  94     -49.376  14.217 -13.246  1.00 14.05           C  
ATOM    591  C   ALA A  94     -49.013  12.979 -12.454  1.00 11.77           C  
ATOM    592  O   ALA A  94     -49.159  11.862 -12.939  1.00 10.96           O  
ATOM    593  CB  ALA A  94     -50.754  14.698 -12.840  1.00 16.47           C  
ATOM    594  N   GLU A  95     -48.576  13.192 -11.222  1.00 12.27           N  
ATOM    595  CA  GLU A  95     -48.185  12.105 -10.329  1.00 14.88           C  
ATOM    596  C   GLU A  95     -49.419  11.388  -9.820  1.00 14.43           C  
ATOM    597  O   GLU A  95     -50.388  12.047  -9.459  1.00 17.78           O  
ATOM    598  CB  GLU A  95     -47.415  12.662  -9.123  1.00 13.81           C  
ATOM    599  CG  GLU A  95     -46.784  11.595  -8.243  1.00 18.66           C  
ATOM    600  CD  GLU A  95     -45.784  10.731  -9.004  1.00 24.68           C  
ATOM    601  OE1 GLU A  95     -45.555   9.579  -8.578  1.00 26.01           O  
ATOM    602  OE2 GLU A  95     -45.240  11.188 -10.040  1.00 23.31           O  
ATOM    603  N   LEU A  96     -49.395  10.057  -9.811  1.00 14.01           N  
ATOM    604  CA  LEU A  96     -50.513   9.271  -9.287  1.00 12.91           C  
ATOM    605  C   LEU A  96     -49.905   8.658  -8.044  1.00 13.30           C  
ATOM    606  O   LEU A  96     -48.950   7.892  -8.135  1.00 16.13           O  
ATOM    607  CB  LEU A  96     -50.920   8.161 -10.266  1.00 14.46           C  
ATOM    608  CG  LEU A  96     -52.379   7.670 -10.275  1.00 17.81           C  
ATOM    609  CD1 LEU A  96     -52.489   6.340 -11.001  1.00 10.83           C  
ATOM    610  CD2 LEU A  96     -52.957   7.538  -8.890  1.00 18.65           C  
ATOM    611  N   GLN A  97     -50.433   9.002  -6.881  1.00 15.36           N  
ATOM    612  CA  GLN A  97     -49.876   8.500  -5.638  1.00 15.47           C  
ATOM    613  C   GLN A  97     -50.353   7.098  -5.263  1.00 17.91           C  
ATOM    614  O   GLN A  97     -49.579   6.291  -4.757  1.00 17.05           O  
ATOM    615  CB  GLN A  97     -50.183   9.474  -4.507  1.00 17.74           C  
ATOM    616  CG  GLN A  97     -49.674  10.890  -4.737  1.00 14.93           C  
ATOM    617  CD  GLN A  97     -49.941  11.760  -3.549  1.00 18.37           C  
ATOM    618  OE1 GLN A  97     -50.831  11.478  -2.742  1.00 18.87           O  
ATOM    619  NE2 GLN A  97     -49.171  12.830  -3.419  1.00 21.73           N  
ATOM    620  N   ARG A  98     -51.618   6.800  -5.506  1.00 16.51           N  
ATOM    621  CA  ARG A  98     -52.111   5.491  -5.149  1.00 18.88           C  
ATOM    622  C   ARG A  98     -53.359   5.145  -5.950  1.00 18.32           C  
ATOM    623  O   ARG A  98     -54.045   6.024  -6.468  1.00 13.72           O  
ATOM    624  CB  ARG A  98     -52.395   5.467  -3.650  1.00 21.22           C  
ATOM    625  CG  ARG A  98     -52.735   4.124  -3.074  1.00 28.40           C  
ATOM    626  CD  ARG A  98     -52.660   4.178  -1.556  1.00 33.43           C  
ATOM    627  NE  ARG A  98     -53.374   3.058  -0.952  1.00 35.41           N  
ATOM    628  CZ  ARG A  98     -53.948   3.100   0.248  1.00 36.52           C  
ATOM    629  NH1 ARG A  98     -54.595   2.033   0.709  1.00 40.43           N  
ATOM    630  NH2 ARG A  98     -53.862   4.197   0.995  1.00 32.51           N  
ATOM    631  N   VAL A  99     -53.568   3.849  -6.130  1.00 17.24           N  
ATOM    632  CA  VAL A  99     -54.719   3.313  -6.833  1.00 18.40           C  
ATOM    633  C   VAL A  99     -55.150   2.099  -6.012  1.00 17.70           C  
ATOM    634  O   VAL A  99     -54.301   1.403  -5.431  1.00 16.12           O  
ATOM    635  CB  VAL A  99     -54.362   2.801  -8.262  1.00 19.29           C  
ATOM    636  CG1 VAL A  99     -55.618   2.257  -8.956  1.00 19.19           C  
ATOM    637  CG2 VAL A  99     -53.740   3.900  -9.092  1.00 21.71           C  
ATOM    638  N   ILE A 100     -56.458   1.890  -5.914  1.00 17.85           N  
ATOM    639  CA  ILE A 100     -57.014   0.736  -5.207  1.00 15.24           C  
ATOM    640  C   ILE A 100     -58.090   0.132  -6.107  1.00 16.02           C  
ATOM    641  O   ILE A 100     -58.946   0.856  -6.610  1.00 16.07           O  
ATOM    642  CB  ILE A 100     -57.686   1.108  -3.849  1.00 19.19           C  
ATOM    643  CG1 ILE A 100     -56.655   1.638  -2.856  1.00 15.56           C  
ATOM    644  CG2 ILE A 100     -58.409  -0.125  -3.255  1.00 15.57           C  
ATOM    645  CD1 ILE A 100     -56.574   3.113  -2.875  1.00 18.22           C  
ATOM    646  N   ARG A 101     -57.995  -1.169  -6.372  1.00 14.27           N  
ATOM    647  CA  ARG A 101     -58.993  -1.880  -7.181  1.00 13.71           C  
ATOM    648  C   ARG A 101     -60.086  -2.214  -6.154  1.00 14.15           C  
ATOM    649  O   ARG A 101     -59.872  -3.006  -5.251  1.00 14.62           O  
ATOM    650  CB  ARG A 101     -58.395  -3.170  -7.765  1.00 10.05           C  
ATOM    651  CG  ARG A 101     -59.359  -3.983  -8.652  1.00 11.89           C  
ATOM    652  CD  ARG A 101     -58.718  -5.218  -9.293  1.00  7.60           C  
ATOM    653  NE  ARG A 101     -57.450  -4.925  -9.979  1.00 14.39           N  
ATOM    654  CZ  ARG A 101     -57.321  -4.506 -11.245  1.00 16.33           C  
ATOM    655  NH1 ARG A 101     -58.383  -4.307 -12.033  1.00 13.27           N  
ATOM    656  NH2 ARG A 101     -56.112  -4.299 -11.741  1.00 15.00           N  
ATOM    657  N   ILE A 102     -61.228  -1.554  -6.255  1.00 14.76           N  
ATOM    658  CA  ILE A 102     -62.336  -1.743  -5.314  1.00 16.76           C  
ATOM    659  C   ILE A 102     -62.755  -3.198  -5.024  1.00 19.27           C  
ATOM    660  O   ILE A 102     -62.899  -3.592  -3.873  1.00 23.79           O  
ATOM    661  CB  ILE A 102     -63.585  -0.940  -5.809  1.00 16.28           C  
ATOM    662  CG1 ILE A 102     -63.332   0.558  -5.671  1.00 14.30           C  
ATOM    663  CG2 ILE A 102     -64.877  -1.378  -5.085  1.00 14.84           C  
ATOM    664  CD1 ILE A 102     -64.309   1.403  -6.443  1.00 12.50           C  
ATOM    665  N   ARG A 103     -62.912  -3.998  -6.063  1.00 18.56           N  
ATOM    666  CA  ARG A 103     -63.360  -5.376  -5.913  1.00 21.92           C  
ATOM    667  C   ARG A 103     -62.465  -6.295  -5.086  1.00 21.62           C  
ATOM    668  O   ARG A 103     -62.962  -7.163  -4.362  1.00 23.13           O  
ATOM    669  CB  ARG A 103     -63.549  -6.014  -7.284  1.00 22.78           C  
ATOM    670  CG  ARG A 103     -64.775  -6.888  -7.382  1.00 25.35           C  
ATOM    671  CD  ARG A 103     -64.545  -8.182  -8.115  1.00 22.53           C  
ATOM    672  NE  ARG A 103     -63.529  -8.110  -9.151  1.00 23.94           N  
ATOM    673  CZ  ARG A 103     -62.589  -9.040  -9.317  1.00 29.17           C  
ATOM    674  NH1 ARG A 103     -61.700  -8.896 -10.291  1.00 27.08           N  
ATOM    675  NH2 ARG A 103     -62.555 -10.133  -8.547  1.00 25.45           N  
ATOM    676  N   THR A 104     -61.151  -6.133  -5.212  1.00 19.78           N  
ATOM    677  CA  THR A 104     -60.225  -7.008  -4.512  1.00 16.73           C  
ATOM    678  C   THR A 104     -59.412  -6.328  -3.423  1.00 17.86           C  
ATOM    679  O   THR A 104     -58.844  -6.990  -2.556  1.00 21.05           O  
ATOM    680  CB  THR A 104     -59.237  -7.616  -5.510  1.00 14.45           C  
ATOM    681  OG1 THR A 104     -58.511  -6.557  -6.139  1.00 15.18           O  
ATOM    682  CG2 THR A 104     -59.975  -8.431  -6.587  1.00 12.80           C  
ATOM    683  N   GLY A 105     -59.330  -5.012  -3.477  1.00 15.97           N  
ATOM    684  CA  GLY A 105     -58.527  -4.303  -2.506  1.00 15.84           C  
ATOM    685  C   GLY A 105     -57.075  -4.246  -2.966  1.00 17.15           C  
ATOM    686  O   GLY A 105     -56.222  -3.759  -2.235  1.00 19.53           O  
ATOM    687  N   GLU A 106     -56.776  -4.751  -4.164  1.00 16.94           N  
ATOM    688  CA  GLU A 106     -55.411  -4.723  -4.694  1.00 12.83           C  
ATOM    689  C   GLU A 106     -54.961  -3.275  -4.827  1.00 12.50           C  
ATOM    690  O   GLU A 106     -55.750  -2.407  -5.180  1.00 13.43           O  
ATOM    691  CB  GLU A 106     -55.341  -5.424  -6.042  1.00 17.23           C  
ATOM    692  CG  GLU A 106     -55.536  -6.934  -6.003  1.00 16.44           C  
ATOM    693  CD  GLU A 106     -55.615  -7.518  -7.395  1.00 17.92           C  
ATOM    694  OE1 GLU A 106     -56.633  -7.304  -8.066  1.00 18.79           O  
ATOM    695  OE2 GLU A 106     -54.649  -8.155  -7.853  1.00 19.30           O  
ATOM    696  N   ALA A 107     -53.671  -3.030  -4.625  1.00  9.80           N  
ATOM    697  CA  ALA A 107     -53.134  -1.684  -4.667  1.00 10.01           C  
ATOM    698  C   ALA A 107     -52.086  -1.429  -5.731  1.00 12.96           C  
ATOM    699  O   ALA A 107     -51.329  -2.322  -6.110  1.00 14.68           O  
ATOM    700  CB  ALA A 107     -52.562  -1.337  -3.319  1.00  7.34           C  
ATOM    701  N   ASP A 108     -52.058  -0.181  -6.182  1.00 14.80           N  
ATOM    702  CA  ASP A 108     -51.094   0.311  -7.156  1.00 18.97           C  
ATOM    703  C   ASP A 108     -50.888  -0.534  -8.415  1.00 17.78           C  
ATOM    704  O   ASP A 108     -51.825  -0.695  -9.185  1.00 16.06           O  
ATOM    705  CB  ASP A 108     -49.784   0.649  -6.413  1.00 18.62           C  
ATOM    706  CG  ASP A 108     -50.010   1.664  -5.276  1.00 19.15           C  
ATOM    707  OD1 ASP A 108     -51.062   2.350  -5.277  1.00 19.20           O  
ATOM    708  OD2 ASP A 108     -49.150   1.774  -4.373  1.00 19.31           O  
ATOM    709  N   GLU A 109     -49.699  -1.086  -8.636  1.00 18.17           N  
ATOM    710  CA  GLU A 109     -49.493  -1.895  -9.838  1.00 19.27           C  
ATOM    711  C   GLU A 109     -50.455  -3.069  -9.989  1.00 18.13           C  
ATOM    712  O   GLU A 109     -50.772  -3.469 -11.110  1.00 19.13           O  
ATOM    713  CB  GLU A 109     -48.049  -2.347  -9.978  1.00 16.94           C  
ATOM    714  CG  GLU A 109     -47.253  -1.390 -10.838  1.00 17.19           C  
ATOM    715  CD  GLU A 109     -45.856  -1.862 -11.136  1.00 19.37           C  
ATOM    716  OE1 GLU A 109     -44.964  -1.010 -11.133  1.00 22.95           O  
ATOM    717  OE2 GLU A 109     -45.637  -3.071 -11.380  1.00 21.07           O  
ATOM    718  N   ALA A 110     -50.932  -3.613  -8.875  1.00 15.03           N  
ATOM    719  CA  ALA A 110     -51.884  -4.709  -8.931  1.00 11.96           C  
ATOM    720  C   ALA A 110     -53.274  -4.163  -9.240  1.00 11.95           C  
ATOM    721  O   ALA A 110     -54.193  -4.938  -9.460  1.00 15.73           O  
ATOM    722  CB  ALA A 110     -51.930  -5.441  -7.619  1.00 12.38           C  
ATOM    723  N   ALA A 111     -53.452  -2.852  -9.135  1.00 10.49           N  
ATOM    724  CA  ALA A 111     -54.739  -2.234  -9.408  1.00 10.26           C  
ATOM    725  C   ALA A 111     -54.758  -1.613 -10.789  1.00 14.18           C  
ATOM    726  O   ALA A 111     -55.792  -1.102 -11.216  1.00 16.15           O  
ATOM    727  CB  ALA A 111     -55.039  -1.157  -8.365  1.00  5.58           C  
ATOM    728  N   LEU A 112     -53.613  -1.613 -11.470  1.00 15.98           N  
ATOM    729  CA  LEU A 112     -53.508  -1.006 -12.800  1.00 17.40           C  
ATOM    730  C   LEU A 112     -54.146  -1.828 -13.919  1.00 19.85           C  
ATOM    731  O   LEU A 112     -54.459  -1.212 -14.969  1.00 23.28           O  
ATOM    732  CB  LEU A 112     -52.042  -0.704 -13.143  1.00 17.56           C  
ATOM    733  CG  LEU A 112     -51.314   0.393 -12.352  1.00 17.44           C  
ATOM    734  CD1 LEU A 112     -49.848   0.443 -12.754  1.00 17.17           C  
ATOM    735  CD2 LEU A 112     -51.963   1.752 -12.606  1.00 19.90           C  
ATOM    736  OXT LEU A 112     -54.324  -3.050 -13.747  1.00 22.42           O  
TER     737      LEU A 112                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
