
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 (  698),  selected   92 , name 1hwu_C
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 1hwu_C.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      K       3           -
LGA    -       -      R       4           -
LGA    M     1_C      A       5          0.866
LGA    K     2_C      N       6          0.553
LGA    Q     3_C      K       7          0.331
LGA    V     4_C      L       8          0.477
LGA    T     5_C      V       9          0.476
LGA    A     6_C      I      10          0.766
LGA    I     7_C      V      11          0.642
LGA    I     8_C      T      12          0.581
LGA    K     9_C      E      13          0.530
LGA    P    10_C      K      14          0.685
LGA    F    11_C      V      15          0.831
LGA    K    12_C      L      16          0.603
LGA    L    13_C      L      17          0.937
LGA    D    14_C      K      18          0.856
LGA    E    15_C      K      19          0.893
LGA    V    16_C      V      20          0.798
LGA    R    17_C      A      21          1.179
LGA    E    18_C      K      22          1.124
LGA    S    19_C      I      23          1.635
LGA    L    20_C      I      24          1.834
LGA    A    21_C      E      25          1.755
LGA    E    22_C      E      26          1.725
LGA    V    23_C      A      27          1.630
LGA    G    24_C      G      28          0.822
LGA    V    25_C      A      29          1.465
LGA    T    26_C      T      30          3.885
LGA    G    27_C      G      31          0.744
LGA    L    28_C      Y      32          1.131
LGA    T    29_C      T      33          0.478
LGA    V    30_C      V      34          0.597
LGA    T    31_C      V      35          0.477
LGA    E    32_C      D      36          0.435
LGA    V    33_C      T      37          0.564
LGA    K    34_C      G      38          0.362
LGA    G    35_C      G      39          1.031
LGA    F    36_C      -       -           -
LGA    P    57_C      S      58          0.828
LGA    K    58_C      N      59          0.422
LGA    V    59_C      V      60          0.378
LGA    K    60_C      K      61          0.515
LGA    I    61_C      F      62          0.517
LGA    E    62_C      E      63          0.478
LGA    V    63_C      V      64          0.519
LGA    V    64_C      L      65          0.621
LGA    V    65_C      T      66          0.823
LGA    D    66_C      E      67          1.852
LGA    D    67_C      N      68          2.296
LGA    K    68_C      R      69          4.177
LGA    V    69_C      E      70          3.134
LGA    -       -      M      71           -
LGA    V    70_C      A      72          1.854
LGA    E    71_C      E      73          1.725
LGA    Q    72_C      K      74          1.332
LGA    A    73_C      I      75          2.091
LGA    V    74_C      A      76          1.553
LGA    D    75_C      D      77          1.568
LGA    A    76_C      Q      78          2.439
LGA    I    77_C      V      79          2.342
LGA    I    78_C      A      80          1.716
LGA    K    79_C      I      81          3.655
LGA    A    80_C      K      82          3.924
LGA    A    81_C      F      83          3.096
LGA    R    82_C      F      84          2.393
LGA    T    83_C      -       -           -
LGA    G    84_C      T      85          1.978
LGA    K    85_C      D      86          3.557
LGA    I    86_C      Y      87          6.032
LGA    G    87_C      A      88          2.451
LGA    D    88_C      -       -           -
LGA    G    89_C      G      89          0.659
LGA    K    90_C      I      90          0.237
LGA    I    91_C      I      91          0.563
LGA    F    92_C      Y      92          1.142
LGA    V    93_C      I      93          0.487
LGA    Q    94_C      C      94          0.606
LGA    E    95_C      E      95          0.408
LGA    V    96_C      A      96          0.752
LGA    E    97_C      E      97          1.990
LGA    Q    98_C      V      98          2.438
LGA    V    99_C      L      99          3.653
LGA    I   100_C      Y     100          0.939
LGA    R   101_C      G     101          1.606
LGA    I   102_C      -       -           -
LGA    R   103_C      -       -           -
LGA    T   104_C      -       -           -
LGA    G   105_C      -       -           -
LGA    E   106_C      -       -           -
LGA    T   107_C      -       -           -
LGA    G   108_C      -       -           -
LGA    P   109_C      -       -           -
LGA    D   110_C      -       -           -
LGA    A   111_C      -       -           -
LGA    V   112_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92   83    5.0     78    1.80    24.36     86.404     4.114

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.725921 * X  +   0.687208 * Y  +   0.028007 * Z  + -103.190590
  Y_new =  -0.660287 * X  +   0.707725 * Y  +  -0.251287 * Z  +   8.561128
  Z_new =  -0.192508 * X  +   0.163922 * Y  +   0.967507 * Z  + -40.096336 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.167833   -2.973760  [ DEG:     9.6161   -170.3839 ]
  Theta =   0.193717    2.947875  [ DEG:    11.0992    168.9008 ]
  Phi   =  -0.738086    2.403507  [ DEG:   -42.2892    137.7108 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1hwu_C                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1hwu_C.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92   83   5.0   78   1.80   24.36  86.404
REMARK  ---------------------------------------------------------- 
MOLECULE 1hwu_C
HEADER    SIGNALING PROTEIN                       10-JAN-01   1HWU              
TITLE     STRUCTURE OF PII PROTEIN FROM HERBASPIRILLUM SEROPEDICAE              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PII PROTEIN;                                               
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HERBASPIRILLUM SEROPEDICAE;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: GLNB;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: RB9065(LAMBDA)DE3;                         
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28B+                                   
KEYWDS    HERBASPIRILLUM SEROPEDICAE PII, BETA-ALPHA-BETA MOTIF,                
KEYWDS   2 SIGNAL TRANSDUCTION PROTEIN                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.M.BENELLI,M.BUCK,I.POLIKARPOV,E.M.DE SOUZA,L.M.CRUZ,                
AUTHOR   2 F.O.PEDROSA                                                          
REVDAT   1   17-JUN-03 1HWU    0                                                
JRNL        AUTH   E.MACHADO BENELLI,M.BUCK,I.POLIKARPOV,                       
JRNL        AUTH 2 E.MALTEMPI DE SOUZA,L.M.CRUZ,F.O.PEDROSA                     
JRNL        TITL   HERBASPIRILLUM SEROPEDICAE SIGNAL TRANSDUCTION               
JRNL        TITL 2 PROTEIN PII IS STRUCTURALLY SIMILAR TO THE ENTERIC           
JRNL        TITL 3 GLNK.                                                        
JRNL        REF    EUR.J.BIOCHEM.                V. 269  3296 2002              
JRNL        REFN   ASTM EJBCAI  IX ISSN 0014-2956                               
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  1HWU A    1   112  UNP    P94852   P94852_HERSE     1    112             
DBREF  1HWU B    1   112  UNP    P94852   P94852_HERSE     1    112             
DBREF  1HWU C    1   112  UNP    P94852   P94852_HERSE     1    112             
DBREF  1HWU D    1   112  UNP    P94852   P94852_HERSE     1    112             
DBREF  1HWU E    1   112  UNP    P94852   P94852_HERSE     1    112             
DBREF  1HWU F    1   112  UNP    P94852   P94852_HERSE     1    112             
SEQRES   1 A  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 A  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 A  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 A  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 A  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 A  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 A  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 A  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 A  112  GLY GLU THR GLY PRO ASP ALA VAL                              
SEQRES   1 B  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 B  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 B  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 B  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 B  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 B  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 B  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 B  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 B  112  GLY GLU THR GLY PRO ASP ALA VAL                              
SEQRES   1 C  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 C  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 C  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 C  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 C  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 C  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 C  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 C  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 C  112  GLY GLU THR GLY PRO ASP ALA VAL                              
SEQRES   1 D  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 D  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 D  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 D  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 D  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 D  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 D  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 D  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 D  112  GLY GLU THR GLY PRO ASP ALA VAL                              
SEQRES   1 E  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 E  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 E  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 E  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 E  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 E  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 E  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 E  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 E  112  GLY GLU THR GLY PRO ASP ALA VAL                              
SEQRES   1 F  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 F  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 F  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 F  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 F  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 F  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 F  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 F  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 F  112  GLY GLU THR GLY PRO ASP ALA VAL                              
FORMUL   7  HOH   *118(H2 O)                                                    
CRYST1   78.410   82.320  100.950  90.00  90.00  90.00 P 21 21 21   24          
ATOM   1539  N   MET C   1     -46.323   6.065 -10.077  1.00 47.97           N  
ATOM   1540  CA  MET C   1     -47.392   5.888 -11.092  1.00 46.05           C  
ATOM   1541  C   MET C   1     -47.849   7.274 -11.579  1.00 43.90           C  
ATOM   1542  O   MET C   1     -47.655   8.236 -10.816  1.00 35.96           O  
ATOM   1543  CB  MET C   1     -48.608   5.138 -10.563  1.00 58.16           C  
ATOM   1544  CG  MET C   1     -48.366   3.650 -10.272  1.00 54.51           C  
ATOM   1545  SD  MET C   1     -48.828   3.458  -8.516  1.00 75.18           S  
ATOM   1546  CE  MET C   1     -47.617   4.534  -7.755  1.00 78.60           C  
ATOM   1547  N   LYS C   2     -48.266   7.294 -12.844  1.00 37.86           N  
ATOM   1548  CA  LYS C   2     -48.642   8.507 -13.546  1.00 34.42           C  
ATOM   1549  C   LYS C   2     -49.998   8.413 -14.124  1.00 33.45           C  
ATOM   1550  O   LYS C   2     -50.476   7.328 -14.451  1.00 35.80           O  
ATOM   1551  CB  LYS C   2     -47.679   8.781 -14.712  1.00 34.33           C  
ATOM   1552  CG  LYS C   2     -46.200   8.747 -14.365  1.00 45.29           C  
ATOM   1553  CD  LYS C   2     -45.824   9.997 -13.570  1.00 43.09           C  
ATOM   1554  CE  LYS C   2     -44.350  10.326 -13.748  1.00 59.04           C  
ATOM   1555  NZ  LYS C   2     -43.526   9.853 -12.597  1.00 52.47           N  
ATOM   1556  N   GLN C   3     -50.632   9.588 -14.204  1.00 34.41           N  
ATOM   1557  CA  GLN C   3     -51.887   9.695 -14.886  1.00 37.50           C  
ATOM   1558  C   GLN C   3     -51.574  10.399 -16.194  1.00 35.88           C  
ATOM   1559  O   GLN C   3     -51.059  11.525 -16.214  1.00 36.54           O  
ATOM   1560  CB  GLN C   3     -52.947  10.490 -14.118  1.00 38.30           C  
ATOM   1561  CG  GLN C   3     -54.218  10.669 -14.949  1.00 37.25           C  
ATOM   1562  CD  GLN C   3     -55.320  11.428 -14.252  1.00 51.43           C  
ATOM   1563  OE1 GLN C   3     -56.351  10.860 -13.879  1.00 53.68           O  
ATOM   1564  NE2 GLN C   3     -55.314  12.731 -13.981  1.00 50.61           N  
ATOM   1565  N   VAL C   4     -51.880   9.708 -17.292  1.00 29.95           N  
ATOM   1566  CA  VAL C   4     -51.661  10.317 -18.611  1.00 31.29           C  
ATOM   1567  C   VAL C   4     -53.003  10.818 -19.158  1.00 32.57           C  
ATOM   1568  O   VAL C   4     -53.933  10.046 -19.306  1.00 30.39           O  
ATOM   1569  CB  VAL C   4     -51.030   9.298 -19.592  1.00 34.92           C  
ATOM   1570  CG1 VAL C   4     -51.041   9.851 -21.019  1.00 34.66           C  
ATOM   1571  CG2 VAL C   4     -49.605   8.952 -19.170  1.00 37.66           C  
ATOM   1572  N   THR C   5     -53.098  12.106 -19.429  1.00 33.07           N  
ATOM   1573  CA  THR C   5     -54.343  12.609 -19.973  1.00 35.73           C  
ATOM   1574  C   THR C   5     -54.131  13.054 -21.415  1.00 31.75           C  
ATOM   1575  O   THR C   5     -53.104  13.621 -21.763  1.00 33.24           O  
ATOM   1576  CB  THR C   5     -54.863  13.816 -19.151  1.00 37.68           C  
ATOM   1577  OG1 THR C   5     -55.135  13.387 -17.806  1.00 34.07           O  
ATOM   1578  CG2 THR C   5     -56.132  14.382 -19.789  1.00 37.51           C  
ATOM   1579  N   ALA C   6     -55.120  12.809 -22.285  1.00 29.39           N  
ATOM   1580  CA  ALA C   6     -55.008  13.240 -23.630  1.00 35.79           C  
ATOM   1581  C   ALA C   6     -56.331  13.874 -24.038  1.00 32.56           C  
ATOM   1582  O   ALA C   6     -57.393  13.288 -23.779  1.00 33.72           O  
ATOM   1583  CB  ALA C   6     -54.637  12.090 -24.548  1.00 30.91           C  
ATOM   1584  N   ILE C   7     -56.310  15.028 -24.680  1.00 29.89           N  
ATOM   1585  CA  ILE C   7     -57.522  15.639 -25.207  1.00 28.80           C  
ATOM   1586  C   ILE C   7     -57.354  15.515 -26.722  1.00 35.77           C  
ATOM   1587  O   ILE C   7     -56.402  16.093 -27.248  1.00 33.67           O  
ATOM   1588  CB  ILE C   7     -57.666  17.133 -24.829  1.00 34.48           C  
ATOM   1589  CG1 ILE C   7     -57.618  17.406 -23.338  1.00 43.11           C  
ATOM   1590  CG2 ILE C   7     -58.971  17.684 -25.388  1.00 43.00           C  
ATOM   1591  CD1 ILE C   7     -57.570  16.151 -22.492  1.00 49.39           C  
ATOM   1592  N   ILE C   8     -58.200  14.803 -27.434  1.00 33.86           N  
ATOM   1593  CA  ILE C   8     -58.003  14.491 -28.841  1.00 38.67           C  
ATOM   1594  C   ILE C   8     -59.313  14.723 -29.571  1.00 35.54           C  
ATOM   1595  O   ILE C   8     -60.330  14.937 -28.950  1.00 33.14           O  
ATOM   1596  CB  ILE C   8     -57.543  13.045 -29.097  1.00 33.37           C  
ATOM   1597  CG1 ILE C   8     -58.630  12.104 -28.503  1.00 38.02           C  
ATOM   1598  CG2 ILE C   8     -56.162  12.692 -28.584  1.00 38.45           C  
ATOM   1599  CD1 ILE C   8     -58.452  10.645 -28.888  1.00 44.91           C  
ATOM   1600  N   LYS C   9     -59.245  14.651 -30.909  1.00 41.14           N  
ATOM   1601  CA  LYS C   9     -60.453  14.816 -31.741  1.00 39.71           C  
ATOM   1602  C   LYS C   9     -61.207  13.483 -31.650  1.00 31.25           C  
ATOM   1603  O   LYS C   9     -60.564  12.437 -31.446  1.00 33.82           O  
ATOM   1604  CB  LYS C   9     -60.074  15.116 -33.187  1.00 51.55           C  
ATOM   1605  CG  LYS C   9     -59.688  16.532 -33.564  1.00 46.77           C  
ATOM   1606  CD  LYS C   9     -58.759  16.482 -34.780  1.00 59.29           C  
ATOM   1607  CE  LYS C   9     -58.466  17.903 -35.225  1.00 64.89           C  
ATOM   1608  NZ  LYS C   9     -57.108  17.997 -35.829  1.00 73.15           N  
ATOM   1609  N   PRO C  10     -62.499  13.509 -31.532  1.00 32.93           N  
ATOM   1610  CA  PRO C  10     -63.301  12.323 -31.342  1.00 36.35           C  
ATOM   1611  C   PRO C  10     -63.059  11.185 -32.297  1.00 37.72           C  
ATOM   1612  O   PRO C  10     -63.088  10.010 -31.864  1.00 35.45           O  
ATOM   1613  CB  PRO C  10     -64.753  12.775 -31.379  1.00 32.79           C  
ATOM   1614  CG  PRO C  10     -64.713  14.225 -31.172  1.00 37.11           C  
ATOM   1615  CD  PRO C  10     -63.353  14.718 -31.584  1.00 35.89           C  
ATOM   1616  N   PHE C  11     -62.781  11.510 -33.579  1.00 42.78           N  
ATOM   1617  CA  PHE C  11     -62.652  10.413 -34.565  1.00 41.70           C  
ATOM   1618  C   PHE C  11     -61.363   9.644 -34.302  1.00 42.30           C  
ATOM   1619  O   PHE C  11     -61.206   8.567 -34.867  1.00 40.56           O  
ATOM   1620  CB  PHE C  11     -62.740  10.926 -35.987  1.00 53.54           C  
ATOM   1621  CG  PHE C  11     -61.921  12.111 -36.386  1.00 65.52           C  
ATOM   1622  CD1 PHE C  11     -60.650  11.987 -36.921  1.00 66.09           C  
ATOM   1623  CD2 PHE C  11     -62.433  13.396 -36.225  1.00 72.36           C  
ATOM   1624  CE1 PHE C  11     -59.905  13.100 -37.287  1.00 58.24           C  
ATOM   1625  CE2 PHE C  11     -61.698  14.511 -36.586  1.00 69.30           C  
ATOM   1626  CZ  PHE C  11     -60.433  14.355 -37.117  1.00 66.76           C  
ATOM   1627  N   LYS C  12     -60.410  10.172 -33.512  1.00 34.93           N  
ATOM   1628  CA  LYS C  12     -59.221   9.369 -33.244  1.00 32.95           C  
ATOM   1629  C   LYS C  12     -59.298   8.387 -32.112  1.00 37.61           C  
ATOM   1630  O   LYS C  12     -58.318   7.687 -31.813  1.00 37.70           O  
ATOM   1631  CB  LYS C  12     -58.064  10.406 -33.100  1.00 36.54           C  
ATOM   1632  CG  LYS C  12     -57.790  11.047 -34.510  1.00 36.27           C  
ATOM   1633  CD  LYS C  12     -57.086   9.990 -35.343  1.00 42.13           C  
ATOM   1634  CE  LYS C  12     -56.188  10.533 -36.429  1.00 55.55           C  
ATOM   1635  NZ  LYS C  12     -55.527   9.449 -37.232  1.00 62.37           N  
ATOM   1636  N   LEU C  13     -60.453   8.326 -31.410  1.00 37.91           N  
ATOM   1637  CA  LEU C  13     -60.537   7.484 -30.211  1.00 33.38           C  
ATOM   1638  C   LEU C  13     -60.156   6.068 -30.595  1.00 32.92           C  
ATOM   1639  O   LEU C  13     -59.411   5.394 -29.873  1.00 32.04           O  
ATOM   1640  CB  LEU C  13     -61.996   7.559 -29.676  1.00 27.38           C  
ATOM   1641  CG  LEU C  13     -62.300   7.241 -28.228  1.00 41.96           C  
ATOM   1642  CD1 LEU C  13     -63.691   6.665 -27.971  1.00 32.18           C  
ATOM   1643  CD2 LEU C  13     -61.230   6.417 -27.561  1.00 33.97           C  
ATOM   1644  N   ASP C  14     -60.816   5.541 -31.664  1.00 31.58           N  
ATOM   1645  CA  ASP C  14     -60.538   4.145 -32.002  1.00 33.66           C  
ATOM   1646  C   ASP C  14     -59.057   3.888 -32.238  1.00 32.81           C  
ATOM   1647  O   ASP C  14     -58.523   2.911 -31.684  1.00 34.73           O  
ATOM   1648  CB  ASP C  14     -61.396   3.647 -33.181  1.00 43.03           C  
ATOM   1649  CG  ASP C  14     -62.872   3.552 -32.841  1.00 47.59           C  
ATOM   1650  OD1 ASP C  14     -63.200   3.225 -31.658  1.00 50.91           O  
ATOM   1651  OD2 ASP C  14     -63.734   3.839 -33.722  1.00 39.83           O  
ATOM   1652  N   GLU C  15     -58.323   4.745 -32.914  1.00 29.55           N  
ATOM   1653  CA  GLU C  15     -56.940   4.476 -33.254  1.00 34.81           C  
ATOM   1654  C   GLU C  15     -56.053   4.611 -32.042  1.00 36.55           C  
ATOM   1655  O   GLU C  15     -55.119   3.820 -31.739  1.00 38.44           O  
ATOM   1656  CB  GLU C  15     -56.548   5.462 -34.382  1.00 41.08           C  
ATOM   1657  CG  GLU C  15     -57.467   5.314 -35.595  1.00 58.40           C  
ATOM   1658  CD  GLU C  15     -57.140   6.276 -36.723  1.00 57.83           C  
ATOM   1659  OE1 GLU C  15     -58.088   6.900 -37.243  1.00 62.09           O  
ATOM   1660  OE2 GLU C  15     -55.938   6.406 -37.078  1.00 66.92           O  
ATOM   1661  N   VAL C  16     -56.499   5.620 -31.239  1.00 32.57           N  
ATOM   1662  CA  VAL C  16     -55.711   5.802 -30.003  1.00 33.21           C  
ATOM   1663  C   VAL C  16     -55.789   4.599 -29.127  1.00 33.11           C  
ATOM   1664  O   VAL C  16     -54.827   4.074 -28.571  1.00 35.82           O  
ATOM   1665  CB  VAL C  16     -56.137   7.149 -29.347  1.00 41.09           C  
ATOM   1666  CG1 VAL C  16     -55.491   7.262 -27.976  1.00 31.60           C  
ATOM   1667  CG2 VAL C  16     -55.691   8.316 -30.260  1.00 29.22           C  
ATOM   1668  N   ARG C  17     -57.047   4.091 -28.952  1.00 33.80           N  
ATOM   1669  CA  ARG C  17     -57.169   2.987 -28.010  1.00 38.78           C  
ATOM   1670  C   ARG C  17     -56.449   1.775 -28.567  1.00 38.41           C  
ATOM   1671  O   ARG C  17     -55.858   1.090 -27.753  1.00 36.10           O  
ATOM   1672  CB  ARG C  17     -58.646   2.741 -27.679  1.00 45.55           C  
ATOM   1673  CG  ARG C  17     -59.017   1.328 -27.391  1.00 44.17           C  
ATOM   1674  CD  ARG C  17     -60.521   1.123 -27.177  1.00 38.11           C  
ATOM   1675  NE  ARG C  17     -60.637  -0.177 -26.431  1.00 39.96           N  
ATOM   1676  CZ  ARG C  17     -61.762  -0.881 -26.476  1.00 41.87           C  
ATOM   1677  NH1 ARG C  17     -62.736  -0.377 -27.257  1.00 35.01           N  
ATOM   1678  NH2 ARG C  17     -61.892  -2.022 -25.830  1.00 35.15           N  
ATOM   1679  N   GLU C  18     -56.436   1.606 -29.889  1.00 41.21           N  
ATOM   1680  CA  GLU C  18     -55.724   0.462 -30.494  1.00 41.99           C  
ATOM   1681  C   GLU C  18     -54.222   0.546 -30.297  1.00 39.74           C  
ATOM   1682  O   GLU C  18     -53.522  -0.333 -29.744  1.00 38.88           O  
ATOM   1683  CB  GLU C  18     -56.121   0.399 -31.992  1.00 38.91           C  
ATOM   1684  CG  GLU C  18     -55.366  -0.663 -32.782  1.00 60.78           C  
ATOM   1685  CD  GLU C  18     -55.690  -2.059 -32.255  1.00 77.90           C  
ATOM   1686  OE1 GLU C  18     -54.814  -2.952 -32.312  1.00 81.38           O  
ATOM   1687  OE2 GLU C  18     -56.838  -2.252 -31.770  1.00 83.04           O  
ATOM   1688  N   SER C  19     -53.664   1.742 -30.525  1.00 42.26           N  
ATOM   1689  CA  SER C  19     -52.199   1.845 -30.315  1.00 44.94           C  
ATOM   1690  C   SER C  19     -51.841   1.699 -28.846  1.00 43.55           C  
ATOM   1691  O   SER C  19     -50.823   1.084 -28.488  1.00 43.59           O  
ATOM   1692  CB  SER C  19     -51.744   3.172 -30.908  1.00 40.90           C  
ATOM   1693  OG  SER C  19     -50.517   3.481 -30.262  1.00 59.83           O  
ATOM   1694  N   LEU C  20     -52.686   2.195 -27.926  1.00 39.92           N  
ATOM   1695  CA  LEU C  20     -52.354   1.969 -26.493  1.00 42.49           C  
ATOM   1696  C   LEU C  20     -52.295   0.485 -26.150  1.00 40.91           C  
ATOM   1697  O   LEU C  20     -51.484  -0.038 -25.381  1.00 40.77           O  
ATOM   1698  CB  LEU C  20     -53.424   2.647 -25.618  1.00 39.20           C  
ATOM   1699  CG  LEU C  20     -53.103   3.882 -24.785  1.00 53.24           C  
ATOM   1700  CD1 LEU C  20     -51.633   4.273 -24.678  1.00 45.33           C  
ATOM   1701  CD2 LEU C  20     -53.944   5.114 -25.072  1.00 35.28           C  
ATOM   1702  N   ALA C  21     -53.313  -0.233 -26.638  1.00 41.26           N  
ATOM   1703  CA  ALA C  21     -53.527  -1.645 -26.427  1.00 48.32           C  
ATOM   1704  C   ALA C  21     -52.326  -2.468 -26.944  1.00 52.26           C  
ATOM   1705  O   ALA C  21     -51.959  -3.457 -26.316  1.00 53.50           O  
ATOM   1706  CB  ALA C  21     -54.743  -2.179 -27.148  1.00 43.10           C  
ATOM   1707  N   GLU C  22     -51.685  -1.985 -27.996  1.00 52.42           N  
ATOM   1708  CA  GLU C  22     -50.548  -2.670 -28.557  1.00 58.56           C  
ATOM   1709  C   GLU C  22     -49.311  -2.537 -27.675  1.00 58.43           C  
ATOM   1710  O   GLU C  22     -48.451  -3.397 -27.795  1.00 59.49           O  
ATOM   1711  CB  GLU C  22     -50.203  -2.227 -29.985  1.00 59.29           C  
ATOM   1712  CG  GLU C  22     -49.533  -3.412 -30.696  1.00 80.78           C  
ATOM   1713  CD  GLU C  22     -50.488  -4.599 -30.769  1.00 82.80           C  
ATOM   1714  OE1 GLU C  22     -51.697  -4.333 -30.979  1.00 90.29           O  
ATOM   1715  OE2 GLU C  22     -50.046  -5.752 -30.608  1.00 81.58           O  
ATOM   1716  N   VAL C  23     -49.247  -1.543 -26.790  1.00 55.07           N  
ATOM   1717  CA  VAL C  23     -48.128  -1.509 -25.844  1.00 52.41           C  
ATOM   1718  C   VAL C  23     -48.582  -2.013 -24.479  1.00 48.15           C  
ATOM   1719  O   VAL C  23     -47.985  -1.749 -23.465  1.00 51.89           O  
ATOM   1720  CB  VAL C  23     -47.475  -0.131 -25.771  1.00 53.30           C  
ATOM   1721  CG1 VAL C  23     -46.785   0.201 -27.099  1.00 49.47           C  
ATOM   1722  CG2 VAL C  23     -48.514   0.925 -25.426  1.00 56.09           C  
ATOM   1723  N   GLY C  24     -49.725  -2.665 -24.404  1.00 48.05           N  
ATOM   1724  CA  GLY C  24     -50.274  -3.205 -23.200  1.00 48.18           C  
ATOM   1725  C   GLY C  24     -50.957  -2.167 -22.337  1.00 43.67           C  
ATOM   1726  O   GLY C  24     -51.021  -2.483 -21.165  1.00 46.85           O  
ATOM   1727  N   VAL C  25     -51.334  -0.982 -22.760  1.00 46.58           N  
ATOM   1728  CA  VAL C  25     -52.019  -0.108 -21.783  1.00 47.89           C  
ATOM   1729  C   VAL C  25     -53.534  -0.156 -22.040  1.00 44.17           C  
ATOM   1730  O   VAL C  25     -54.003   0.166 -23.132  1.00 39.78           O  
ATOM   1731  CB  VAL C  25     -51.418   1.295 -21.630  1.00 47.38           C  
ATOM   1732  CG1 VAL C  25     -50.758   1.733 -22.929  1.00 61.05           C  
ATOM   1733  CG2 VAL C  25     -52.441   2.350 -21.183  1.00 44.86           C  
ATOM   1734  N   THR C  26     -54.275  -0.689 -21.064  1.00 39.96           N  
ATOM   1735  CA  THR C  26     -55.742  -0.636 -21.196  1.00 44.04           C  
ATOM   1736  C   THR C  26     -56.239   0.015 -19.907  1.00 47.54           C  
ATOM   1737  O   THR C  26     -55.403   0.551 -19.127  1.00 51.74           O  
ATOM   1738  CB  THR C  26     -56.399  -1.984 -21.482  1.00 45.60           C  
ATOM   1739  OG1 THR C  26     -55.977  -2.820 -20.390  1.00 47.86           O  
ATOM   1740  CG2 THR C  26     -55.980  -2.643 -22.782  1.00 53.62           C  
ATOM   1741  N   GLY C  27     -57.519  -0.105 -19.582  1.00 39.73           N  
ATOM   1742  CA  GLY C  27     -58.033   0.567 -18.388  1.00 35.32           C  
ATOM   1743  C   GLY C  27     -58.203   2.061 -18.703  1.00 34.09           C  
ATOM   1744  O   GLY C  27     -58.106   2.868 -17.766  1.00 36.36           O  
ATOM   1745  N   LEU C  28     -58.660   2.426 -19.897  1.00 31.39           N  
ATOM   1746  CA  LEU C  28     -58.865   3.859 -20.197  1.00 31.09           C  
ATOM   1747  C   LEU C  28     -60.194   4.357 -19.609  1.00 29.36           C  
ATOM   1748  O   LEU C  28     -61.175   3.590 -19.588  1.00 26.39           O  
ATOM   1749  CB  LEU C  28     -59.051   3.986 -21.721  1.00 38.09           C  
ATOM   1750  CG  LEU C  28     -57.789   4.200 -22.562  1.00 52.17           C  
ATOM   1751  CD1 LEU C  28     -56.715   3.238 -22.173  1.00 39.51           C  
ATOM   1752  CD2 LEU C  28     -58.008   3.990 -24.056  1.00 41.17           C  
ATOM   1753  N   THR C  29     -60.304   5.641 -19.322  1.00 24.66           N  
ATOM   1754  CA  THR C  29     -61.558   6.259 -19.000  1.00 33.11           C  
ATOM   1755  C   THR C  29     -61.818   7.332 -20.052  1.00 30.23           C  
ATOM   1756  O   THR C  29     -60.830   8.058 -20.282  1.00 28.30           O  
ATOM   1757  CB  THR C  29     -61.422   6.953 -17.615  1.00 35.35           C  
ATOM   1758  OG1 THR C  29     -61.390   5.899 -16.660  1.00 35.48           O  
ATOM   1759  CG2 THR C  29     -62.740   7.707 -17.419  1.00 31.49           C  
ATOM   1760  N   VAL C  30     -62.986   7.490 -20.584  1.00 30.11           N  
ATOM   1761  CA  VAL C  30     -63.183   8.503 -21.657  1.00 26.67           C  
ATOM   1762  C   VAL C  30     -64.323   9.418 -21.263  1.00 27.08           C  
ATOM   1763  O   VAL C  30     -65.369   8.901 -20.882  1.00 22.25           O  
ATOM   1764  CB  VAL C  30     -63.659   7.787 -22.957  1.00 36.47           C  
ATOM   1765  CG1 VAL C  30     -64.148   8.876 -23.978  1.00 30.15           C  
ATOM   1766  CG2 VAL C  30     -62.560   6.947 -23.543  1.00 31.92           C  
ATOM   1767  N   THR C  31     -64.162  10.701 -21.433  1.00 22.60           N  
ATOM   1768  CA  THR C  31     -65.170  11.698 -21.131  1.00 19.98           C  
ATOM   1769  C   THR C  31     -65.330  12.628 -22.358  1.00 28.98           C  
ATOM   1770  O   THR C  31     -64.317  12.958 -23.006  1.00 25.08           O  
ATOM   1771  CB  THR C  31     -64.579  12.624 -20.012  1.00 27.43           C  
ATOM   1772  OG1 THR C  31     -64.164  11.763 -18.918  1.00 29.33           O  
ATOM   1773  CG2 THR C  31     -65.640  13.571 -19.506  1.00 27.39           C  
ATOM   1774  N   GLU C  32     -66.534  12.961 -22.707  1.00 24.97           N  
ATOM   1775  CA  GLU C  32     -66.837  13.936 -23.766  1.00 33.50           C  
ATOM   1776  C   GLU C  32     -66.749  15.322 -23.143  1.00 34.76           C  
ATOM   1777  O   GLU C  32     -67.256  15.537 -22.019  1.00 32.17           O  
ATOM   1778  CB  GLU C  32     -68.320  13.904 -24.246  1.00 37.00           C  
ATOM   1779  CG  GLU C  32     -68.711  12.535 -24.747  1.00 50.63           C  
ATOM   1780  CD  GLU C  32     -70.175  12.320 -25.125  1.00 47.26           C  
ATOM   1781  OE1 GLU C  32     -70.593  11.141 -25.162  1.00 55.79           O  
ATOM   1782  OE2 GLU C  32     -70.850  13.330 -25.338  1.00 59.16           O  
ATOM   1783  N   VAL C  33     -65.893  16.135 -23.774  1.00 29.42           N  
ATOM   1784  CA  VAL C  33     -65.646  17.457 -23.231  1.00 28.99           C  
ATOM   1785  C   VAL C  33     -65.845  18.448 -24.398  1.00 34.71           C  
ATOM   1786  O   VAL C  33     -65.760  18.059 -25.573  1.00 35.11           O  
ATOM   1787  CB  VAL C  33     -64.227  17.601 -22.629  1.00 34.51           C  
ATOM   1788  CG1 VAL C  33     -64.083  16.657 -21.416  1.00 24.73           C  
ATOM   1789  CG2 VAL C  33     -63.051  17.406 -23.637  1.00 26.78           C  
ATOM   1790  N   LYS C  34     -65.848  19.704 -24.082  1.00 31.99           N  
ATOM   1791  CA  LYS C  34     -65.950  20.824 -25.027  1.00 31.86           C  
ATOM   1792  C   LYS C  34     -64.669  21.622 -24.879  1.00 32.11           C  
ATOM   1793  O   LYS C  34     -64.347  22.055 -23.769  1.00 31.73           O  
ATOM   1794  CB  LYS C  34     -67.142  21.735 -24.747  1.00 36.23           C  
ATOM   1795  CG  LYS C  34     -68.482  21.004 -25.018  1.00 44.50           C  
ATOM   1796  CD  LYS C  34     -69.722  21.830 -24.710  1.00 46.80           C  
ATOM   1797  CE  LYS C  34     -70.995  21.005 -24.873  1.00 47.17           C  
ATOM   1798  NZ  LYS C  34     -72.132  21.567 -24.078  1.00 63.58           N  
ATOM   1799  N   GLY C  35     -63.995  21.885 -26.001  1.00 33.17           N  
ATOM   1800  CA  GLY C  35     -62.780  22.679 -26.064  1.00 34.11           C  
ATOM   1801  C   GLY C  35     -63.165  24.085 -26.520  1.00 44.90           C  
ATOM   1802  O   GLY C  35     -63.855  24.250 -27.534  1.00 49.21           O  
ATOM   1803  N   PHE C  36     -62.837  25.123 -25.777  1.00 48.27           N  
ATOM   1804  CA  PHE C  36     -63.080  26.507 -26.138  1.00 51.80           C  
ATOM   1805  C   PHE C  36     -61.713  27.086 -26.514  1.00 57.80           C  
ATOM   1806  O   PHE C  36     -60.790  26.753 -25.801  1.00 55.33           O  
ATOM   1807  CB  PHE C  36     -63.608  27.466 -25.031  1.00 38.39           C  
ATOM   1808  CG  PHE C  36     -65.050  27.084 -24.782  1.00 49.72           C  
ATOM   1809  CD1 PHE C  36     -65.350  25.913 -24.112  1.00 44.19           C  
ATOM   1810  CD2 PHE C  36     -66.090  27.861 -25.278  1.00 47.33           C  
ATOM   1811  CE1 PHE C  36     -66.674  25.541 -23.897  1.00 60.51           C  
ATOM   1812  CE2 PHE C  36     -67.403  27.507 -25.065  1.00 57.53           C  
ATOM   1813  CZ  PHE C  36     -67.710  26.340 -24.372  1.00 62.03           C  
ATOM   1814  N   PRO C  57     -66.254  19.852 -30.009  1.00 45.57           N  
ATOM   1815  CA  PRO C  57     -66.397  18.607 -29.253  1.00 38.92           C  
ATOM   1816  C   PRO C  57     -65.058  17.928 -29.220  1.00 39.20           C  
ATOM   1817  O   PRO C  57     -64.308  17.920 -30.230  1.00 36.03           O  
ATOM   1818  CB  PRO C  57     -67.429  17.800 -30.018  1.00 43.68           C  
ATOM   1819  CG  PRO C  57     -67.570  18.436 -31.362  1.00 47.77           C  
ATOM   1820  CD  PRO C  57     -67.044  19.848 -31.289  1.00 46.24           C  
ATOM   1821  N   LYS C  58     -64.536  17.523 -28.045  1.00 29.82           N  
ATOM   1822  CA  LYS C  58     -63.337  16.728 -27.984  1.00 28.02           C  
ATOM   1823  C   LYS C  58     -63.639  15.427 -27.178  1.00 29.50           C  
ATOM   1824  O   LYS C  58     -64.579  15.401 -26.381  1.00 31.70           O  
ATOM   1825  CB  LYS C  58     -62.155  17.382 -27.232  1.00 36.18           C  
ATOM   1826  CG  LYS C  58     -61.736  18.750 -27.797  1.00 42.85           C  
ATOM   1827  CD  LYS C  58     -60.918  18.574 -29.069  1.00 52.93           C  
ATOM   1828  CE  LYS C  58     -60.542  19.911 -29.713  1.00 65.15           C  
ATOM   1829  NZ  LYS C  58     -60.431  19.845 -31.210  1.00 58.61           N  
ATOM   1830  N   VAL C  59     -62.647  14.566 -27.038  1.00 26.81           N  
ATOM   1831  CA  VAL C  59     -62.738  13.422 -26.129  1.00 32.62           C  
ATOM   1832  C   VAL C  59     -61.544  13.495 -25.222  1.00 31.43           C  
ATOM   1833  O   VAL C  59     -60.408  13.802 -25.701  1.00 32.01           O  
ATOM   1834  CB  VAL C  59     -62.698  12.093 -26.937  1.00 35.67           C  
ATOM   1835  CG1 VAL C  59     -62.294  10.869 -26.185  1.00 43.75           C  
ATOM   1836  CG2 VAL C  59     -64.138  11.803 -27.404  1.00 44.11           C  
ATOM   1837  N   LYS C  60     -61.758  13.393 -23.926  1.00 29.55           N  
ATOM   1838  CA  LYS C  60     -60.611  13.297 -23.018  1.00 25.47           C  
ATOM   1839  C   LYS C  60     -60.386  11.817 -22.695  1.00 30.77           C  
ATOM   1840  O   LYS C  60     -61.338  11.096 -22.327  1.00 30.42           O  
ATOM   1841  CB  LYS C  60     -60.776  14.087 -21.753  1.00 30.27           C  
ATOM   1842  CG  LYS C  60     -59.878  13.622 -20.611  1.00 31.91           C  
ATOM   1843  CD  LYS C  60     -60.433  14.091 -19.251  1.00 32.39           C  
ATOM   1844  CE  LYS C  60     -60.087  15.567 -19.114  1.00 33.94           C  
ATOM   1845  NZ  LYS C  60     -60.371  15.994 -17.696  1.00 44.17           N  
ATOM   1846  N   ILE C  61     -59.085  11.435 -22.654  1.00 25.14           N  
ATOM   1847  CA  ILE C  61     -58.794  10.045 -22.297  1.00 30.78           C  
ATOM   1848  C   ILE C  61     -57.914  10.110 -21.082  1.00 33.12           C  
ATOM   1849  O   ILE C  61     -56.984  10.927 -20.982  1.00 36.67           O  
ATOM   1850  CB  ILE C  61     -58.079   9.332 -23.469  1.00 43.50           C  
ATOM   1851  CG1 ILE C  61     -58.929   9.218 -24.745  1.00 46.86           C  
ATOM   1852  CG2 ILE C  61     -57.665   7.949 -23.035  1.00 42.57           C  
ATOM   1853  CD1 ILE C  61     -58.071   8.853 -25.954  1.00 43.04           C  
ATOM   1854  N   GLU C  62     -58.152   9.246 -20.084  1.00 29.57           N  
ATOM   1855  CA  GLU C  62     -57.336   9.265 -18.891  1.00 37.16           C  
ATOM   1856  C   GLU C  62     -56.864   7.833 -18.639  1.00 33.63           C  
ATOM   1857  O   GLU C  62     -57.651   6.887 -18.788  1.00 33.83           O  
ATOM   1858  CB  GLU C  62     -58.159   9.807 -17.683  1.00 34.34           C  
ATOM   1859  CG  GLU C  62     -58.578  11.252 -17.911  1.00 38.95           C  
ATOM   1860  CD  GLU C  62     -59.530  11.649 -16.787  1.00 48.24           C  
ATOM   1861  OE1 GLU C  62     -60.600  11.019 -16.650  1.00 43.51           O  
ATOM   1862  OE2 GLU C  62     -59.211  12.596 -16.040  1.00 46.58           O  
ATOM   1863  N   VAL C  63     -55.612   7.655 -18.327  1.00 33.79           N  
ATOM   1864  CA  VAL C  63     -55.099   6.318 -18.023  1.00 36.62           C  
ATOM   1865  C   VAL C  63     -54.016   6.447 -16.946  1.00 37.66           C  
ATOM   1866  O   VAL C  63     -53.287   7.438 -16.951  1.00 34.19           O  
ATOM   1867  CB  VAL C  63     -54.618   5.603 -19.291  1.00 38.67           C  
ATOM   1868  CG1 VAL C  63     -53.303   6.179 -19.825  1.00 39.03           C  
ATOM   1869  CG2 VAL C  63     -54.513   4.131 -18.886  1.00 50.81           C  
ATOM   1870  N   VAL C  64     -54.080   5.632 -15.913  1.00 34.29           N  
ATOM   1871  CA  VAL C  64     -53.118   5.628 -14.825  1.00 38.15           C  
ATOM   1872  C   VAL C  64     -52.196   4.407 -14.993  1.00 37.66           C  
ATOM   1873  O   VAL C  64     -52.675   3.283 -15.195  1.00 33.08           O  
ATOM   1874  CB  VAL C  64     -53.803   5.621 -13.441  1.00 48.52           C  
ATOM   1875  CG1 VAL C  64     -52.765   5.386 -12.348  1.00 50.03           C  
ATOM   1876  CG2 VAL C  64     -54.583   6.927 -13.181  1.00 42.27           C  
ATOM   1877  N   VAL C  65     -50.944   4.664 -15.372  1.00 39.34           N  
ATOM   1878  CA  VAL C  65     -49.919   3.687 -15.606  1.00 41.20           C  
ATOM   1879  C   VAL C  65     -48.694   3.718 -14.655  1.00 43.53           C  
ATOM   1880  O   VAL C  65     -48.401   4.678 -13.934  1.00 37.44           O  
ATOM   1881  CB  VAL C  65     -49.220   3.771 -16.987  1.00 39.67           C  
ATOM   1882  CG1 VAL C  65     -50.158   3.309 -18.085  1.00 44.48           C  
ATOM   1883  CG2 VAL C  65     -48.699   5.165 -17.181  1.00 35.90           C  
ATOM   1884  N   ASP C  66     -47.990   2.586 -14.789  1.00 41.84           N  
ATOM   1885  CA  ASP C  66     -46.741   2.391 -14.056  1.00 47.29           C  
ATOM   1886  C   ASP C  66     -45.730   3.356 -14.667  1.00 46.42           C  
ATOM   1887  O   ASP C  66     -45.634   3.516 -15.897  1.00 41.36           O  
ATOM   1888  CB  ASP C  66     -46.179   0.962 -14.198  1.00 49.36           C  
ATOM   1889  CG  ASP C  66     -45.133   0.662 -13.125  1.00 65.07           C  
ATOM   1890  OD1 ASP C  66     -43.950   1.007 -13.268  1.00 61.61           O  
ATOM   1891  OD2 ASP C  66     -45.495   0.081 -12.077  1.00 67.88           O  
ATOM   1892  N   ASP C  67     -44.858   3.907 -13.819  1.00 49.15           N  
ATOM   1893  CA  ASP C  67     -43.806   4.800 -14.300  1.00 50.49           C  
ATOM   1894  C   ASP C  67     -42.974   4.164 -15.403  1.00 48.53           C  
ATOM   1895  O   ASP C  67     -42.451   4.754 -16.347  1.00 48.48           O  
ATOM   1896  CB  ASP C  67     -42.791   5.155 -13.196  1.00 50.15           C  
ATOM   1897  CG  ASP C  67     -43.420   5.967 -12.089  1.00 53.61           C  
ATOM   1898  OD1 ASP C  67     -44.571   6.415 -12.216  1.00 51.75           O  
ATOM   1899  OD2 ASP C  67     -42.731   6.151 -11.058  1.00 61.80           O  
ATOM   1900  N   LYS C  68     -42.759   2.872 -15.245  1.00 51.37           N  
ATOM   1901  CA  LYS C  68     -41.997   2.095 -16.235  1.00 58.39           C  
ATOM   1902  C   LYS C  68     -42.615   2.148 -17.619  1.00 58.70           C  
ATOM   1903  O   LYS C  68     -41.791   2.129 -18.550  1.00 56.41           O  
ATOM   1904  CB  LYS C  68     -41.799   0.756 -15.559  1.00 59.54           C  
ATOM   1905  CG  LYS C  68     -41.152  -0.421 -16.217  1.00 72.16           C  
ATOM   1906  CD  LYS C  68     -41.384  -1.685 -15.380  1.00 78.92           C  
ATOM   1907  CE  LYS C  68     -42.851  -1.847 -14.998  1.00 83.81           C  
ATOM   1908  NZ  LYS C  68     -43.231  -3.278 -14.785  1.00 89.35           N  
ATOM   1909  N   VAL C  69     -43.890   2.487 -17.898  1.00 57.77           N  
ATOM   1910  CA  VAL C  69     -44.399   2.586 -19.258  1.00 53.51           C  
ATOM   1911  C   VAL C  69     -44.892   3.939 -19.723  1.00 47.15           C  
ATOM   1912  O   VAL C  69     -45.485   4.015 -20.806  1.00 45.09           O  
ATOM   1913  CB  VAL C  69     -45.582   1.639 -19.610  1.00 56.84           C  
ATOM   1914  CG1 VAL C  69     -45.072   0.242 -19.922  1.00 52.20           C  
ATOM   1915  CG2 VAL C  69     -46.676   1.647 -18.558  1.00 40.54           C  
ATOM   1916  N   VAL C  70     -44.642   5.029 -19.012  1.00 47.57           N  
ATOM   1917  CA  VAL C  70     -45.240   6.307 -19.451  1.00 45.43           C  
ATOM   1918  C   VAL C  70     -44.715   6.691 -20.811  1.00 45.70           C  
ATOM   1919  O   VAL C  70     -45.464   7.292 -21.576  1.00 42.46           O  
ATOM   1920  CB  VAL C  70     -45.073   7.453 -18.433  1.00 51.88           C  
ATOM   1921  CG1 VAL C  70     -45.192   8.849 -19.020  1.00 54.46           C  
ATOM   1922  CG2 VAL C  70     -46.180   7.360 -17.394  1.00 50.76           C  
ATOM   1923  N   GLU C  71     -43.431   6.402 -21.086  1.00 41.59           N  
ATOM   1924  CA  GLU C  71     -42.840   6.899 -22.340  1.00 46.69           C  
ATOM   1925  C   GLU C  71     -43.486   6.226 -23.552  1.00 42.48           C  
ATOM   1926  O   GLU C  71     -43.864   6.917 -24.461  1.00 39.03           O  
ATOM   1927  CB  GLU C  71     -41.332   6.658 -22.428  1.00 56.51           C  
ATOM   1928  CG  GLU C  71     -40.441   7.440 -21.509  1.00 71.12           C  
ATOM   1929  CD  GLU C  71     -40.910   7.712 -20.104  1.00 80.53           C  
ATOM   1930  OE1 GLU C  71     -40.882   6.850 -19.200  1.00 83.71           O  
ATOM   1931  OE2 GLU C  71     -41.344   8.871 -19.853  1.00 93.69           O  
ATOM   1932  N   GLN C  72     -43.600   4.920 -23.489  1.00 47.18           N  
ATOM   1933  CA  GLN C  72     -44.293   4.103 -24.441  1.00 51.15           C  
ATOM   1934  C   GLN C  72     -45.734   4.561 -24.632  1.00 50.02           C  
ATOM   1935  O   GLN C  72     -46.127   4.712 -25.791  1.00 48.44           O  
ATOM   1936  CB  GLN C  72     -44.307   2.641 -23.986  1.00 59.95           C  
ATOM   1937  CG  GLN C  72     -43.565   1.729 -24.955  1.00 80.49           C  
ATOM   1938  CD  GLN C  72     -44.008   0.283 -24.834  1.00 93.65           C  
ATOM   1939  OE1 GLN C  72     -44.691  -0.092 -23.869  1.00101.95           O  
ATOM   1940  NE2 GLN C  72     -43.630  -0.556 -25.801  1.00 99.50           N  
ATOM   1941  N   ALA C  73     -46.466   4.746 -23.532  1.00 44.48           N  
ATOM   1942  CA  ALA C  73     -47.874   5.195 -23.659  1.00 41.68           C  
ATOM   1943  C   ALA C  73     -47.955   6.577 -24.291  1.00 42.47           C  
ATOM   1944  O   ALA C  73     -48.746   6.768 -25.243  1.00 38.70           O  
ATOM   1945  CB  ALA C  73     -48.509   5.213 -22.272  1.00 41.07           C  
ATOM   1946  N   VAL C  74     -47.037   7.503 -23.917  1.00 43.26           N  
ATOM   1947  CA  VAL C  74     -47.214   8.862 -24.518  1.00 45.85           C  
ATOM   1948  C   VAL C  74     -46.956   8.852 -26.024  1.00 44.53           C  
ATOM   1949  O   VAL C  74     -47.624   9.401 -26.904  1.00 39.38           O  
ATOM   1950  CB  VAL C  74     -46.308   9.880 -23.819  1.00 47.89           C  
ATOM   1951  CG1 VAL C  74     -46.327  11.192 -24.610  1.00 47.22           C  
ATOM   1952  CG2 VAL C  74     -46.697  10.106 -22.368  1.00 48.82           C  
ATOM   1953  N   ASP C  75     -45.939   8.044 -26.354  1.00 47.96           N  
ATOM   1954  CA  ASP C  75     -45.555   7.883 -27.742  1.00 50.69           C  
ATOM   1955  C   ASP C  75     -46.606   7.191 -28.593  1.00 44.37           C  
ATOM   1956  O   ASP C  75     -46.990   7.591 -29.703  1.00 47.65           O  
ATOM   1957  CB  ASP C  75     -44.214   7.122 -27.730  1.00 62.41           C  
ATOM   1958  CG  ASP C  75     -43.651   7.273 -29.147  1.00 70.63           C  
ATOM   1959  OD1 ASP C  75     -43.235   8.418 -29.441  1.00 75.66           O  
ATOM   1960  OD2 ASP C  75     -43.695   6.262 -29.864  1.00 74.90           O  
ATOM   1961  N   ALA C  76     -47.214   6.160 -28.046  1.00 44.09           N  
ATOM   1962  CA  ALA C  76     -48.352   5.519 -28.761  1.00 46.13           C  
ATOM   1963  C   ALA C  76     -49.509   6.495 -28.916  1.00 44.29           C  
ATOM   1964  O   ALA C  76     -50.079   6.572 -30.007  1.00 40.89           O  
ATOM   1965  CB  ALA C  76     -48.680   4.211 -28.089  1.00 43.06           C  
ATOM   1966  N   ILE C  77     -49.786   7.408 -27.962  1.00 39.60           N  
ATOM   1967  CA  ILE C  77     -50.865   8.370 -28.223  1.00 42.81           C  
ATOM   1968  C   ILE C  77     -50.427   9.308 -29.353  1.00 46.30           C  
ATOM   1969  O   ILE C  77     -51.205   9.632 -30.275  1.00 41.08           O  
ATOM   1970  CB  ILE C  77     -51.225   9.187 -26.972  1.00 43.44           C  
ATOM   1971  CG1 ILE C  77     -51.937   8.343 -25.925  1.00 36.75           C  
ATOM   1972  CG2 ILE C  77     -52.131  10.361 -27.362  1.00 32.24           C  
ATOM   1973  CD1 ILE C  77     -51.735   8.770 -24.496  1.00 43.18           C  
ATOM   1974  N   ILE C  78     -49.206   9.861 -29.180  1.00 42.54           N  
ATOM   1975  CA  ILE C  78     -48.733  10.753 -30.276  1.00 48.80           C  
ATOM   1976  C   ILE C  78     -48.746   9.989 -31.613  1.00 49.47           C  
ATOM   1977  O   ILE C  78     -49.330  10.494 -32.557  1.00 45.64           O  
ATOM   1978  CB  ILE C  78     -47.330  11.334 -30.121  1.00 57.09           C  
ATOM   1979  CG1 ILE C  78     -47.259  12.383 -28.999  1.00 62.01           C  
ATOM   1980  CG2 ILE C  78     -46.804  12.017 -31.393  1.00 58.56           C  
ATOM   1981  CD1 ILE C  78     -45.864  12.433 -28.381  1.00 56.57           C  
ATOM   1982  N   LYS C  79     -48.200   8.764 -31.671  1.00 51.17           N  
ATOM   1983  CA  LYS C  79     -48.255   8.037 -32.939  1.00 52.50           C  
ATOM   1984  C   LYS C  79     -49.641   8.017 -33.543  1.00 53.82           C  
ATOM   1985  O   LYS C  79     -49.733   8.237 -34.767  1.00 51.03           O  
ATOM   1986  CB  LYS C  79     -47.694   6.616 -32.801  1.00 57.82           C  
ATOM   1987  CG  LYS C  79     -46.194   6.549 -32.680  1.00 69.74           C  
ATOM   1988  CD  LYS C  79     -45.587   5.196 -32.952  1.00 79.51           C  
ATOM   1989  CE  LYS C  79     -45.379   4.290 -31.770  1.00 81.38           C  
ATOM   1990  NZ  LYS C  79     -46.524   3.393 -31.435  1.00 81.03           N  
ATOM   1991  N   ALA C  80     -50.677   7.637 -32.751  1.00 46.27           N  
ATOM   1992  CA  ALA C  80     -52.000   7.520 -33.377  1.00 44.15           C  
ATOM   1993  C   ALA C  80     -52.792   8.796 -33.584  1.00 44.31           C  
ATOM   1994  O   ALA C  80     -53.682   8.782 -34.462  1.00 43.46           O  
ATOM   1995  CB  ALA C  80     -52.865   6.595 -32.500  1.00 44.07           C  
ATOM   1996  N   ALA C  81     -52.718   9.805 -32.699  1.00 41.66           N  
ATOM   1997  CA  ALA C  81     -53.674  10.925 -32.912  1.00 51.85           C  
ATOM   1998  C   ALA C  81     -53.181  12.059 -33.815  1.00 58.28           C  
ATOM   1999  O   ALA C  81     -53.914  13.005 -34.137  1.00 59.61           O  
ATOM   2000  CB  ALA C  81     -54.022  11.523 -31.558  1.00 56.42           C  
ATOM   2001  N   ARG C  82     -51.888  12.056 -34.113  1.00 61.46           N  
ATOM   2002  CA  ARG C  82     -51.265  13.126 -34.858  1.00 73.12           C  
ATOM   2003  C   ARG C  82     -51.777  13.048 -36.298  1.00 74.97           C  
ATOM   2004  O   ARG C  82     -51.449  12.113 -37.004  1.00 74.97           O  
ATOM   2005  CB  ARG C  82     -49.727  13.097 -34.807  1.00 76.04           C  
ATOM   2006  CG  ARG C  82     -49.069  14.231 -35.582  1.00 76.96           C  
ATOM   2007  CD  ARG C  82     -47.560  14.185 -35.597  1.00 82.09           C  
ATOM   2008  NE  ARG C  82     -46.973  14.363 -34.273  1.00 93.67           N  
ATOM   2009  CZ  ARG C  82     -45.676  14.499 -34.027  1.00 94.02           C  
ATOM   2010  NH1 ARG C  82     -44.819  14.482 -35.040  1.00101.45           N  
ATOM   2011  NH2 ARG C  82     -45.236  14.659 -32.792  1.00 93.39           N  
ATOM   2012  N   THR C  83     -52.674  13.954 -36.629  1.00 80.62           N  
ATOM   2013  CA  THR C  83     -53.149  14.042 -38.009  1.00 86.79           C  
ATOM   2014  C   THR C  83     -52.122  14.955 -38.689  1.00 91.53           C  
ATOM   2015  O   THR C  83     -51.501  14.585 -39.679  1.00 94.24           O  
ATOM   2016  CB  THR C  83     -54.549  14.636 -38.117  1.00 83.73           C  
ATOM   2017  OG1 THR C  83     -54.435  16.051 -37.912  1.00 79.74           O  
ATOM   2018  CG2 THR C  83     -55.487  14.065 -37.059  1.00 81.71           C  
ATOM   2019  N   GLY C  84     -51.817  16.060 -38.012  1.00 93.56           N  
ATOM   2020  CA  GLY C  84     -50.844  17.014 -38.528  1.00 96.48           C  
ATOM   2021  C   GLY C  84     -51.443  18.406 -38.697  1.00 97.85           C  
ATOM   2022  O   GLY C  84     -50.693  19.386 -38.726  1.00 98.55           O  
ATOM   2023  N   LYS C  85     -52.765  18.512 -38.809  1.00 98.43           N  
ATOM   2024  CA  LYS C  85     -53.432  19.805 -38.915  1.00 96.56           C  
ATOM   2025  C   LYS C  85     -53.682  20.388 -37.530  1.00 94.35           C  
ATOM   2026  O   LYS C  85     -53.460  19.760 -36.491  1.00 94.57           O  
ATOM   2027  CB  LYS C  85     -54.719  19.695 -39.731  1.00101.49           C  
ATOM   2028  CG  LYS C  85     -54.454  19.102 -41.109  1.00110.50           C  
ATOM   2029  CD  LYS C  85     -55.689  19.193 -41.995  1.00116.04           C  
ATOM   2030  CE  LYS C  85     -55.259  19.278 -43.455  1.00117.90           C  
ATOM   2031  NZ  LYS C  85     -56.412  19.580 -44.348  1.00118.94           N  
ATOM   2032  N   ILE C  86     -53.997  21.667 -37.487  1.00 90.83           N  
ATOM   2033  CA  ILE C  86     -54.223  22.438 -36.268  1.00 85.62           C  
ATOM   2034  C   ILE C  86     -55.295  21.789 -35.409  1.00 81.28           C  
ATOM   2035  O   ILE C  86     -56.285  21.308 -35.969  1.00 80.47           O  
ATOM   2036  CB  ILE C  86     -54.504  23.899 -36.656  1.00 86.89           C  
ATOM   2037  CG1 ILE C  86     -55.371  24.653 -35.645  1.00 86.36           C  
ATOM   2038  CG2 ILE C  86     -55.136  24.054 -38.038  1.00 89.53           C  
ATOM   2039  CD1 ILE C  86     -54.536  25.559 -34.767  1.00 87.02           C  
ATOM   2040  N   GLY C  87     -55.115  21.697 -34.088  1.00 73.67           N  
ATOM   2041  CA  GLY C  87     -56.083  21.037 -33.236  1.00 67.05           C  
ATOM   2042  C   GLY C  87     -55.942  19.574 -32.877  1.00 62.13           C  
ATOM   2043  O   GLY C  87     -56.847  19.050 -32.199  1.00 59.21           O  
ATOM   2044  N   ASP C  88     -54.850  18.860 -33.144  1.00 56.14           N  
ATOM   2045  CA  ASP C  88     -54.591  17.498 -32.726  1.00 55.77           C  
ATOM   2046  C   ASP C  88     -54.676  17.229 -31.208  1.00 53.27           C  
ATOM   2047  O   ASP C  88     -54.761  16.076 -30.736  1.00 54.71           O  
ATOM   2048  CB  ASP C  88     -53.234  17.002 -33.260  1.00 49.61           C  
ATOM   2049  CG  ASP C  88     -53.201  16.606 -34.720  1.00 58.37           C  
ATOM   2050  OD1 ASP C  88     -54.159  16.615 -35.508  1.00 49.96           O  
ATOM   2051  OD2 ASP C  88     -52.114  16.226 -35.197  1.00 62.49           O  
ATOM   2052  N   GLY C  89     -54.560  18.221 -30.358  1.00 45.28           N  
ATOM   2053  CA  GLY C  89     -54.728  18.209 -28.941  1.00 42.90           C  
ATOM   2054  C   GLY C  89     -53.457  18.139 -28.131  1.00 43.74           C  
ATOM   2055  O   GLY C  89     -52.368  18.463 -28.653  1.00 40.21           O  
ATOM   2056  N   LYS C  90     -53.605  17.912 -26.837  1.00 39.64           N  
ATOM   2057  CA  LYS C  90     -52.411  17.851 -25.973  1.00 41.76           C  
ATOM   2058  C   LYS C  90     -52.488  16.583 -25.139  1.00 38.86           C  
ATOM   2059  O   LYS C  90     -53.624  16.140 -24.879  1.00 39.82           O  
ATOM   2060  CB  LYS C  90     -52.336  18.907 -24.870  1.00 38.97           C  
ATOM   2061  CG  LYS C  90     -52.880  20.258 -25.274  1.00 59.01           C  
ATOM   2062  CD  LYS C  90     -51.821  21.130 -25.915  1.00 58.30           C  
ATOM   2063  CE  LYS C  90     -52.395  22.546 -26.125  1.00 59.90           C  
ATOM   2064  NZ  LYS C  90     -51.431  23.560 -25.620  1.00 57.86           N  
ATOM   2065  N   ILE C  91     -51.399  16.327 -24.495  1.00 33.65           N  
ATOM   2066  CA  ILE C  91     -51.223  15.221 -23.551  1.00 34.48           C  
ATOM   2067  C   ILE C  91     -50.653  15.824 -22.285  1.00 36.13           C  
ATOM   2068  O   ILE C  91     -49.826  16.755 -22.397  1.00 36.33           O  
ATOM   2069  CB  ILE C  91     -50.295  14.127 -24.079  1.00 40.71           C  
ATOM   2070  CG1 ILE C  91     -50.799  13.378 -25.315  1.00 37.29           C  
ATOM   2071  CG2 ILE C  91     -49.958  13.073 -23.019  1.00 36.52           C  
ATOM   2072  CD1 ILE C  91     -49.691  12.510 -25.939  1.00 44.44           C  
ATOM   2073  N   PHE C  92     -51.040  15.351 -21.103  1.00 32.58           N  
ATOM   2074  CA  PHE C  92     -50.533  15.964 -19.877  1.00 32.65           C  
ATOM   2075  C   PHE C  92     -50.146  14.763 -19.018  1.00 37.28           C  
ATOM   2076  O   PHE C  92     -50.833  13.745 -19.169  1.00 32.97           O  
ATOM   2077  CB  PHE C  92     -51.552  16.777 -19.079  1.00 41.08           C  
ATOM   2078  CG  PHE C  92     -52.371  17.778 -19.795  1.00 40.49           C  
ATOM   2079  CD1 PHE C  92     -53.737  17.687 -19.919  1.00 50.03           C  
ATOM   2080  CD2 PHE C  92     -51.761  18.895 -20.369  1.00 51.26           C  
ATOM   2081  CE1 PHE C  92     -54.503  18.631 -20.577  1.00 57.17           C  
ATOM   2082  CE2 PHE C  92     -52.490  19.856 -21.060  1.00 50.50           C  
ATOM   2083  CZ  PHE C  92     -53.862  19.716 -21.168  1.00 62.73           C  
ATOM   2084  N   VAL C  93     -49.167  14.931 -18.136  1.00 36.08           N  
ATOM   2085  CA  VAL C  93     -48.650  13.850 -17.310  1.00 36.43           C  
ATOM   2086  C   VAL C  93     -48.671  14.359 -15.862  1.00 41.83           C  
ATOM   2087  O   VAL C  93     -48.204  15.487 -15.652  1.00 39.96           O  
ATOM   2088  CB  VAL C  93     -47.243  13.340 -17.675  1.00 36.59           C  
ATOM   2089  CG1 VAL C  93     -46.715  12.203 -16.786  1.00 42.51           C  
ATOM   2090  CG2 VAL C  93     -47.261  12.758 -19.095  1.00 35.31           C  
ATOM   2091  N   GLN C  94     -49.212  13.599 -14.926  1.00 34.77           N  
ATOM   2092  CA  GLN C  94     -49.250  14.059 -13.536  1.00 36.66           C  
ATOM   2093  C   GLN C  94     -48.933  12.857 -12.654  1.00 38.59           C  
ATOM   2094  O   GLN C  94     -49.274  11.727 -13.026  1.00 36.33           O  
ATOM   2095  CB  GLN C  94     -50.707  14.502 -13.177  1.00 42.18           C  
ATOM   2096  CG  GLN C  94     -51.054  15.924 -13.604  1.00 42.58           C  
ATOM   2097  CD  GLN C  94     -52.555  16.203 -13.472  1.00 58.22           C  
ATOM   2098  OE1 GLN C  94     -53.413  15.650 -14.173  1.00 50.42           O  
ATOM   2099  NE2 GLN C  94     -52.913  17.089 -12.550  1.00 49.40           N  
ATOM   2100  N   GLU C  95     -48.338  13.065 -11.519  1.00 39.02           N  
ATOM   2101  CA  GLU C  95     -48.098  12.005 -10.571  1.00 43.08           C  
ATOM   2102  C   GLU C  95     -49.375  11.505  -9.916  1.00 41.08           C  
ATOM   2103  O   GLU C  95     -50.282  12.309  -9.624  1.00 43.47           O  
ATOM   2104  CB  GLU C  95     -47.321  12.636  -9.398  1.00 56.01           C  
ATOM   2105  CG  GLU C  95     -45.862  12.337  -9.418  1.00 65.68           C  
ATOM   2106  CD  GLU C  95     -45.452  10.896  -9.541  1.00 60.89           C  
ATOM   2107  OE1 GLU C  95     -45.888  10.055  -8.740  1.00 66.41           O  
ATOM   2108  OE2 GLU C  95     -44.670  10.615 -10.472  1.00 65.05           O  
ATOM   2109  N   VAL C  96     -49.383  10.223  -9.585  1.00 38.29           N  
ATOM   2110  CA  VAL C  96     -50.439   9.672  -8.785  1.00 33.07           C  
ATOM   2111  C   VAL C  96     -49.779   9.137  -7.509  1.00 39.77           C  
ATOM   2112  O   VAL C  96     -48.986   8.209  -7.580  1.00 46.12           O  
ATOM   2113  CB  VAL C  96     -51.254   8.626  -9.558  1.00 39.33           C  
ATOM   2114  CG1 VAL C  96     -52.330   8.059  -8.656  1.00 38.45           C  
ATOM   2115  CG2 VAL C  96     -51.903   9.161 -10.842  1.00 36.05           C  
ATOM   2116  N   GLU C  97     -50.132   9.577  -6.329  1.00 42.92           N  
ATOM   2117  CA  GLU C  97     -49.637   9.080  -5.064  1.00 44.93           C  
ATOM   2118  C   GLU C  97     -49.989   7.613  -4.774  1.00 45.79           C  
ATOM   2119  O   GLU C  97     -49.097   6.762  -4.576  1.00 35.84           O  
ATOM   2120  CB  GLU C  97     -50.207   9.903  -3.900  1.00 50.72           C  
ATOM   2121  CG  GLU C  97     -49.882  11.369  -4.001  1.00 52.81           C  
ATOM   2122  CD  GLU C  97     -49.824  12.050  -2.642  1.00 64.04           C  
ATOM   2123  OE1 GLU C  97     -49.326  13.205  -2.632  1.00 69.73           O  
ATOM   2124  OE2 GLU C  97     -50.246  11.484  -1.607  1.00 58.13           O  
ATOM   2125  N   GLN C  98     -51.265   7.280  -5.028  1.00 40.67           N  
ATOM   2126  CA  GLN C  98     -51.733   5.936  -4.818  1.00 40.86           C  
ATOM   2127  C   GLN C  98     -52.898   5.479  -5.707  1.00 41.99           C  
ATOM   2128  O   GLN C  98     -53.732   6.315  -6.083  1.00 34.89           O  
ATOM   2129  CB  GLN C  98     -52.218   5.784  -3.360  1.00 42.28           C  
ATOM   2130  CG  GLN C  98     -52.202   4.284  -3.005  1.00 67.40           C  
ATOM   2131  CD  GLN C  98     -50.900   3.591  -3.391  1.00 69.97           C  
ATOM   2132  OE1 GLN C  98     -50.858   2.752  -4.296  1.00 60.17           O  
ATOM   2133  NE2 GLN C  98     -49.816   3.971  -2.707  1.00 77.26           N  
ATOM   2134  N   VAL C  99     -52.869   4.194  -6.051  1.00 37.48           N  
ATOM   2135  CA  VAL C  99     -53.896   3.552  -6.832  1.00 37.85           C  
ATOM   2136  C   VAL C  99     -54.389   2.329  -6.086  1.00 38.31           C  
ATOM   2137  O   VAL C  99     -53.619   1.457  -5.600  1.00 38.65           O  
ATOM   2138  CB  VAL C  99     -53.374   3.165  -8.239  1.00 47.03           C  
ATOM   2139  CG1 VAL C  99     -54.545   2.606  -9.048  1.00 43.13           C  
ATOM   2140  CG2 VAL C  99     -52.793   4.351  -8.999  1.00 39.94           C  
ATOM   2141  N   ILE C 100     -55.721   2.252  -5.891  1.00 35.12           N  
ATOM   2142  CA  ILE C 100     -56.289   1.086  -5.211  1.00 31.42           C  
ATOM   2143  C   ILE C 100     -57.290   0.379  -6.100  1.00 36.62           C  
ATOM   2144  O   ILE C 100     -58.215   1.065  -6.551  1.00 36.77           O  
ATOM   2145  CB  ILE C 100     -57.041   1.482  -3.940  1.00 27.12           C  
ATOM   2146  CG1 ILE C 100     -56.165   2.100  -2.841  1.00 34.88           C  
ATOM   2147  CG2 ILE C 100     -57.719   0.277  -3.276  1.00 39.00           C  
ATOM   2148  CD1 ILE C 100     -56.140   3.607  -2.740  1.00 43.50           C  
ATOM   2149  N   ARG C 101     -57.200  -0.921  -6.282  1.00 35.74           N  
ATOM   2150  CA  ARG C 101     -58.243  -1.690  -6.986  1.00 41.49           C  
ATOM   2151  C   ARG C 101     -59.323  -2.078  -5.988  1.00 42.91           C  
ATOM   2152  O   ARG C 101     -59.114  -2.779  -4.981  1.00 42.74           O  
ATOM   2153  CB  ARG C 101     -57.606  -2.827  -7.781  1.00 40.59           C  
ATOM   2154  CG  ARG C 101     -58.473  -3.979  -8.142  1.00 54.98           C  
ATOM   2155  CD  ARG C 101     -58.112  -4.985  -9.178  1.00 60.39           C  
ATOM   2156  NE  ARG C 101     -56.742  -5.158  -9.604  1.00 68.63           N  
ATOM   2157  CZ  ARG C 101     -56.256  -4.813 -10.788  1.00 74.20           C  
ATOM   2158  NH1 ARG C 101     -57.066  -4.258 -11.691  1.00 82.40           N  
ATOM   2159  NH2 ARG C 101     -54.981  -5.021 -11.077  1.00 73.92           N  
ATOM   2160  N   ILE C 102     -60.571  -1.709  -6.266  1.00 35.10           N  
ATOM   2161  CA  ILE C 102     -61.681  -1.933  -5.351  1.00 33.66           C  
ATOM   2162  C   ILE C 102     -61.996  -3.396  -5.022  1.00 33.95           C  
ATOM   2163  O   ILE C 102     -62.218  -3.734  -3.866  1.00 36.51           O  
ATOM   2164  CB  ILE C 102     -62.963  -1.191  -5.784  1.00 28.63           C  
ATOM   2165  CG1 ILE C 102     -62.712   0.316  -5.680  1.00 35.52           C  
ATOM   2166  CG2 ILE C 102     -64.189  -1.613  -4.999  1.00 28.26           C  
ATOM   2167  CD1 ILE C 102     -63.814   1.266  -6.147  1.00 38.26           C  
ATOM   2168  N   ARG C 103     -61.974  -4.287  -5.956  1.00 32.53           N  
ATOM   2169  CA  ARG C 103     -62.431  -5.663  -5.868  1.00 40.05           C  
ATOM   2170  C   ARG C 103     -61.581  -6.458  -4.865  1.00 45.45           C  
ATOM   2171  O   ARG C 103     -62.115  -7.246  -4.080  1.00 44.04           O  
ATOM   2172  CB  ARG C 103     -62.306  -6.167  -7.299  1.00 33.86           C  
ATOM   2173  CG  ARG C 103     -62.318  -7.574  -7.729  1.00 44.90           C  
ATOM   2174  CD  ARG C 103     -61.857  -7.870  -9.162  1.00 57.80           C  
ATOM   2175  NE  ARG C 103     -61.328  -9.242  -9.111  1.00 75.12           N  
ATOM   2176  CZ  ARG C 103     -60.036  -9.557  -9.126  1.00 83.56           C  
ATOM   2177  NH1 ARG C 103     -59.055  -8.662  -9.239  1.00 85.24           N  
ATOM   2178  NH2 ARG C 103     -59.682 -10.838  -9.044  1.00 89.31           N  
ATOM   2179  N   THR C 104     -60.287  -6.201  -4.892  1.00 39.51           N  
ATOM   2180  CA  THR C 104     -59.293  -6.917  -4.122  1.00 48.57           C  
ATOM   2181  C   THR C 104     -58.590  -6.091  -3.079  1.00 49.11           C  
ATOM   2182  O   THR C 104     -57.934  -6.672  -2.209  1.00 49.91           O  
ATOM   2183  CB  THR C 104     -58.120  -7.420  -5.006  1.00 45.14           C  
ATOM   2184  OG1 THR C 104     -57.462  -6.281  -5.562  1.00 50.20           O  
ATOM   2185  CG2 THR C 104     -58.605  -8.274  -6.163  1.00 42.73           C  
ATOM   2186  N   GLY C 105     -58.558  -4.765  -3.228  1.00 46.23           N  
ATOM   2187  CA  GLY C 105     -57.831  -3.978  -2.234  1.00 41.37           C  
ATOM   2188  C   GLY C 105     -56.337  -3.985  -2.513  1.00 46.20           C  
ATOM   2189  O   GLY C 105     -55.559  -3.363  -1.772  1.00 45.13           O  
ATOM   2190  N   GLU C 106     -55.899  -4.598  -3.612  1.00 49.94           N  
ATOM   2191  CA  GLU C 106     -54.533  -4.419  -4.082  1.00 51.24           C  
ATOM   2192  C   GLU C 106     -54.272  -2.909  -4.222  1.00 55.69           C  
ATOM   2193  O   GLU C 106     -55.176  -2.117  -4.560  1.00 51.66           O  
ATOM   2194  CB  GLU C 106     -54.304  -5.070  -5.434  1.00 43.85           C  
ATOM   2195  CG  GLU C 106     -54.191  -6.597  -5.382  1.00 56.82           C  
ATOM   2196  CD  GLU C 106     -54.417  -7.149  -6.776  1.00 61.88           C  
ATOM   2197  OE1 GLU C 106     -55.609  -7.177  -7.162  1.00 60.00           O  
ATOM   2198  OE2 GLU C 106     -53.406  -7.512  -7.414  1.00 65.87           O  
ATOM   2199  N   THR C 107     -53.013  -2.551  -4.054  1.00 55.75           N  
ATOM   2200  CA  THR C 107     -52.579  -1.159  -3.951  1.00 59.46           C  
ATOM   2201  C   THR C 107     -51.420  -0.934  -4.885  1.00 64.04           C  
ATOM   2202  O   THR C 107     -50.869  -1.915  -5.418  1.00 69.25           O  
ATOM   2203  CB  THR C 107     -52.274  -0.991  -2.451  1.00 65.16           C  
ATOM   2204  OG1 THR C 107     -52.883   0.190  -1.910  1.00 73.23           O  
ATOM   2205  CG2 THR C 107     -50.786  -0.988  -2.156  1.00 63.58           C  
ATOM   2206  N   GLY C 108     -51.042   0.281  -5.194  1.00 63.62           N  
ATOM   2207  CA  GLY C 108     -49.951   0.604  -6.082  1.00 66.40           C  
ATOM   2208  C   GLY C 108     -49.843  -0.119  -7.396  1.00 67.21           C  
ATOM   2209  O   GLY C 108     -50.829  -0.489  -8.029  1.00 62.74           O  
ATOM   2210  N   PRO C 109     -48.604  -0.344  -7.862  1.00 71.61           N  
ATOM   2211  CA  PRO C 109     -48.287  -0.966  -9.135  1.00 72.41           C  
ATOM   2212  C   PRO C 109     -49.102  -2.156  -9.565  1.00 71.65           C  
ATOM   2213  O   PRO C 109     -49.459  -2.234 -10.732  1.00 72.14           O  
ATOM   2214  CB  PRO C 109     -46.803  -1.351  -8.996  1.00 73.63           C  
ATOM   2215  CG  PRO C 109     -46.247  -0.290  -8.105  1.00 73.01           C  
ATOM   2216  CD  PRO C 109     -47.357   0.048  -7.144  1.00 73.42           C  
ATOM   2217  N   ASP C 110     -49.507  -3.082  -8.696  1.00 74.34           N  
ATOM   2218  CA  ASP C 110     -50.350  -4.206  -9.056  1.00 75.09           C  
ATOM   2219  C   ASP C 110     -51.841  -3.860  -9.071  1.00 72.60           C  
ATOM   2220  O   ASP C 110     -52.681  -4.753  -9.258  1.00 71.63           O  
ATOM   2221  CB  ASP C 110     -50.109  -5.455  -8.218  1.00 87.85           C  
ATOM   2222  CG  ASP C 110     -49.350  -5.268  -6.932  1.00 96.28           C  
ATOM   2223  OD1 ASP C 110     -49.232  -4.140  -6.411  1.00106.01           O  
ATOM   2224  OD2 ASP C 110     -48.842  -6.276  -6.395  1.00 95.41           O  
ATOM   2225  N   ALA C 111     -52.176  -2.590  -8.866  1.00 65.81           N  
ATOM   2226  CA  ALA C 111     -53.530  -2.096  -9.010  1.00 60.99           C  
ATOM   2227  C   ALA C 111     -53.755  -1.613 -10.445  1.00 66.05           C  
ATOM   2228  O   ALA C 111     -54.900  -1.483 -10.869  1.00 64.96           O  
ATOM   2229  CB  ALA C 111     -53.811  -0.979  -8.013  1.00 47.42           C  
ATOM   2230  N   VAL C 112     -52.705  -1.340 -11.221  1.00 70.58           N  
ATOM   2231  CA  VAL C 112     -52.870  -0.851 -12.581  1.00 78.10           C  
ATOM   2232  C   VAL C 112     -53.838  -1.707 -13.401  1.00 79.82           C  
ATOM   2233  O   VAL C 112     -54.537  -1.123 -14.262  1.00 81.31           O  
ATOM   2234  CB  VAL C 112     -51.539  -0.757 -13.358  1.00 79.72           C  
ATOM   2235  CG1 VAL C 112     -50.577   0.099 -12.555  1.00 78.30           C  
ATOM   2236  CG2 VAL C 112     -50.990  -2.151 -13.626  1.00 85.58           C  
TER    2237      VAL C 112                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
