
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  132 ( 1019),  selected  132 , name 2re7_A
# Molecule2: number of CA atoms  124 (  982),  selected  124 , name T0402.pdb
# PARAMETERS: 2re7_A.T0402.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_A      -       -           -
LGA    N     3_A      -       -           -
LGA    Q     4_A      -       -           -
LGA    K     5_A      E       4          5.467
LGA    H     6_A      L       5          0.934
LGA    I     7_A      E       6          1.111
LGA    D     8_A      D       7          0.895
LGA    K     9_A      K       8          1.437
LGA    I    10_A      I       9          1.417
LGA    Q    11_A      L      10          1.399
LGA    A    12_A      A      11          1.047
LGA    V    13_A      I      12          1.004
LGA    I    14_A      L      13          1.911
LGA    K    15_A      E      14          2.130
LGA    D    16_A      Q      15          1.642
LGA    V    17_A      H      16          2.126
LGA    K    18_A      Q      17          3.627
LGA    F    19_A      V      18          1.019
LGA    A    20_A      G      19          1.083
LGA    X    21_A      V      20          0.364
LGA    I    22_A      L      21          0.467
LGA    S    23_A      T      22          0.257
LGA    T    24_A      S      23          0.443
LGA    S    25_A      V      24          0.669
LGA    N    26_A      Q      25          0.236
LGA    K    27_A      G      26          2.277
LGA    K    28_A      D      27          3.453
LGA    G    29_A      -       -           -
LGA    D    30_A      F      28          0.988
LGA    I    31_A      P      29          0.642
LGA    H    32_A      H      30          0.888
LGA    A    33_A      A      31          1.001
LGA    W    34_A      R      32          1.060
LGA    P    35_A      Y      33          1.046
LGA    X    36_A      M      34          1.257
LGA    T    37_A      T      35          0.937
LGA    T    38_A      F      36          1.096
LGA    S    39_A      L      37          1.792
LGA    E    40_A      H      38          1.762
LGA    V    41_A      D      39          3.671
LGA    N    42_A      G      40          0.978
LGA    L    43_A      L      41          1.905
LGA    D    44_A      -       -           -
LGA    N    45_A      -       -           -
LGA    K    46_A      -       -           -
LGA    E    47_A      T      42          1.714
LGA    I    48_A      L      43          1.210
LGA    W    49_A      Y      44          1.319
LGA    F    50_A      T      45          1.552
LGA    I    51_A      P      46          1.888
LGA    G    52_A      S      47          1.392
LGA    D    53_A      G      48          1.333
LGA    K    54_A      K      49          1.399
LGA    T    55_A      E      50          1.868
LGA    S    56_A      L      51          1.653
LGA    D    57_A      P      52          1.566
LGA    V    58_A      K      53          1.054
LGA    V    59_A      T      54          0.668
LGA    K    60_A      E      55          1.282
LGA    D    61_A      E      56          0.558
LGA    I    62_A      V      57          0.487
LGA    Q    63_A      R      58          0.994
LGA    D    64_A      R      59          0.587
LGA    D    65_A      N      60          0.197
LGA    A    66_A      P      61          0.385
LGA    R    67_A      H      62          0.445
LGA    I    68_A      V      63          0.410
LGA    G    69_A      C      64          0.517
LGA    L    70_A      V      65          0.445
LGA    T    71_A      L      66          0.364
LGA    Y    72_A      I      67          0.920
LGA    A    73_A      G      68          3.018
LGA    T    74_A      Y      69          3.206
LGA    Q    75_A      D      70          1.718
LGA    D    76_A      S      71          3.684
LGA    E    77_A      P      72          3.274
LGA    K    78_A      G      73          2.395
LGA    N    79_A      S      74          2.654
LGA    -       -      A      75           -
LGA    Y    80_A      F      76          1.732
LGA    V    81_A      L      77          0.720
LGA    S    82_A      E      78          0.276
LGA    I    83_A      I      79          0.234
LGA    S    84_A      N      80          0.272
LGA    G    85_A      G      81          0.081
LGA    D    86_A      L      82          0.181
LGA    A    87_A      A      83          0.264
LGA    E    88_A      S      84          0.906
LGA    L    89_A      L      85          0.777
LGA    P    90_A      E      86          2.385
LGA    T    91_A      E      87          2.398
LGA    D    92_A      D      88          1.802
LGA    K    93_A      E      89          1.559
LGA    A    94_A      S      90          1.064
LGA    K    95_A      I      91          0.886
LGA    L    96_A      K      92          1.995
LGA    D    97_A      E      93          2.905
LGA    E    98_A      R      94          2.723
LGA    L    99_A      I      95          2.290
LGA    W   100_A      W      96          3.478
LGA    S   101_A      E      97          3.261
LGA    -       -      N      98           -
LGA    -       -      I      99           -
LGA    -       -      S     100           -
LGA    P   102_A      K     101          0.884
LGA    V   103_A      D     102          4.451
LGA    Y   104_A      W     103           #
LGA    S   105_A      F     104          3.253
LGA    A   106_A      Q     105           #
LGA    F   107_A      G     106           -
LGA    F   108_A      -       -           -
LGA    A   109_A      -       -           -
LGA    N   110_A      E     107          4.569
LGA    G   111_A      D     108          2.106
LGA    K   112_A      -       -           -
LGA    E   113_A      -       -           -
LGA    D   114_A      S     109          1.586
LGA    A   115_A      P     110          1.695
LGA    N   116_A      S     111          1.009
LGA    I   117_A      F     112          0.758
LGA    Q   118_A      V     113          0.857
LGA    L   119_A      V     114          1.123
LGA    I   120_A      I     115          0.955
LGA    K   121_A      K     116          0.876
LGA    V   122_A      I     117          0.544
LGA    V   123_A      V     118          0.704
LGA    P   124_A      P     119          0.495
LGA    H   125_A      E     120          0.627
LGA    G   126_A      Q     121          0.244
LGA    V   127_A      I     122          0.477
LGA    E   128_A      R     123          0.658
LGA    C   129_A      I     124          1.001
LGA    W   130_A      L     125          1.856
LGA    -       -      N     126           -
LGA    L   131_A      S     127          1.986
LGA    S   132_A      -       -           -
LGA    G   133_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  132  124    5.0    116    1.78    16.38     85.015     6.182

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.098750 * X  +  -0.367453 * Y  +  -0.924785 * Z  +  20.447042
  Y_new =   0.510312 * X  +  -0.779125 * Y  +   0.364069 * Z  +   5.852315
  Z_new =  -0.854301 * X  +  -0.507881 * Y  +   0.110577 * Z  +  70.263016 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.356420    1.785173  [ DEG:   -77.7171    102.2829 ]
  Theta =   1.024204    2.117389  [ DEG:    58.6826    121.3174 ]
  Phi   =   1.379649   -1.761944  [ DEG:    79.0481   -100.9519 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2re7_A                                        
REMARK     2: T0402.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2re7_A.T0402.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  132  124   5.0  116   1.78   16.38  85.015
REMARK  ---------------------------------------------------------- 
MOLECULE 2re7_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-SEP-07   2RE7              
TITLE     CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN COG3871                   
TITLE    2 (YP_263493.1) FROM PSYCHROBACTER ARCTICUS 273-4 AT 2.50 A            
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 1-133;                                            
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSYCHROBACTER ARCTICUS 273-4;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 273-4;                                                       
SOURCE   5 GENE: YP_263493.1, PSYC_0186;                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_263493.1, GENERAL STRESS PROTEIN COG3871, PYRIDOXAMINE             
KEYWDS   2 5'-PHOSPHATE OXIDASE, STRUCTURAL GENOMICS, JOINT CENTER FOR          
KEYWDS   3 STRUCTURAL GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE,             
KEYWDS   4 PSI-2, STRUCTURAL GENOMICS, UNKNOWN FUNCTION                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   09-OCT-07 2RE7    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN                  
JRNL        TITL 2 COG3871 (YP_263493.1) FROM PSYCHROBACTER ARCTICUS            
JRNL        TITL 3 273-4 AT 2.50 A RESOLUTION                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2RE7 A    1   133  UNP    Q4FV99   Q4FV99_PSYAR     1    133             
SEQRES   1 A  134  GLY MSE SER ASN GLN LYS HIS ILE ASP LYS ILE GLN ALA          
SEQRES   2 A  134  VAL ILE LYS ASP VAL LYS PHE ALA MSE ILE SER THR SER          
SEQRES   3 A  134  ASN LYS LYS GLY ASP ILE HIS ALA TRP PRO MSE THR THR          
SEQRES   4 A  134  SER GLU VAL ASN LEU ASP ASN LYS GLU ILE TRP PHE ILE          
SEQRES   5 A  134  GLY ASP LYS THR SER ASP VAL VAL LYS ASP ILE GLN ASP          
SEQRES   6 A  134  ASP ALA ARG ILE GLY LEU THR TYR ALA THR GLN ASP GLU          
SEQRES   7 A  134  LYS ASN TYR VAL SER ILE SER GLY ASP ALA GLU LEU PRO          
SEQRES   8 A  134  THR ASP LYS ALA LYS LEU ASP GLU LEU TRP SER PRO VAL          
SEQRES   9 A  134  TYR SER ALA PHE PHE ALA ASN GLY LYS GLU ASP ALA ASN          
SEQRES  10 A  134  ILE GLN LEU ILE LYS VAL VAL PRO HIS GLY VAL GLU CYS          
SEQRES  11 A  134  TRP LEU SER GLY                                              
HET    MSE  A  21       8                                                       
HET    MSE  A  36       8                                                       
HET    SO4  A 134       5                                                       
HET    SO4  A 135       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   2  SO4    2(O4 S 2-)                                                   
FORMUL   4  HOH   *24(H2 O)                                                     
CRYST1  106.063  106.063   87.218  90.00  90.00  90.00 I 41 2 2     16          
ATOM      1  N   SER A   2     -10.150  11.422   4.954  1.00 77.30           N  
ATOM      2  CA  SER A   2     -10.832  12.748   4.809  1.00 77.27           C  
ATOM      3  C   SER A   2     -12.380  12.716   4.924  1.00 77.91           C  
ATOM      4  O   SER A   2     -12.973  13.725   5.305  1.00 77.74           O  
ATOM      5  CB  SER A   2     -10.425  13.399   3.488  1.00 76.58           C  
ATOM      6  OG  SER A   2      -9.017  13.463   3.378  1.00 73.96           O  
ATOM      7  N   ASN A   3     -13.025  11.591   4.579  1.00 78.20           N  
ATOM      8  CA  ASN A   3     -14.507  11.442   4.637  1.00 78.94           C  
ATOM      9  C   ASN A   3     -14.976  10.075   5.219  1.00 78.51           C  
ATOM     10  O   ASN A   3     -15.786   9.381   4.611  1.00 75.48           O  
ATOM     11  CB  ASN A   3     -15.143  11.645   3.237  1.00 79.54           C  
ATOM     12  CG  ASN A   3     -14.607  12.887   2.495  1.00 83.04           C  
ATOM     13  OD1 ASN A   3     -14.537  14.005   3.036  1.00 79.32           O  
ATOM     14  ND2 ASN A   3     -14.236  12.684   1.236  1.00 84.77           N  
ATOM     15  N   GLN A   4     -14.466   9.717   6.403  1.00 79.38           N  
ATOM     16  CA  GLN A   4     -14.735   8.409   7.055  1.00 78.31           C  
ATOM     17  C   GLN A   4     -14.271   8.446   8.541  1.00 76.55           C  
ATOM     18  O   GLN A   4     -13.682   9.431   8.972  1.00 74.66           O  
ATOM     19  CB  GLN A   4     -14.021   7.276   6.301  1.00 78.06           C  
ATOM     20  CG  GLN A   4     -12.494   7.286   6.548  1.00 80.59           C  
ATOM     21  CD  GLN A   4     -11.689   6.609   5.460  1.00 79.62           C  
ATOM     22  OE1 GLN A   4     -12.222   5.848   4.637  1.00 72.11           O  
ATOM     23  NE2 GLN A   4     -10.382   6.879   5.457  1.00 76.66           N  
ATOM     24  N   LYS A   5     -14.493   7.354   9.283  1.00 75.81           N  
ATOM     25  CA  LYS A   5     -14.427   7.360  10.757  1.00 74.86           C  
ATOM     26  C   LYS A   5     -13.621   6.226  11.440  1.00 72.03           C  
ATOM     27  O   LYS A   5     -13.740   5.053  11.112  1.00 72.15           O  
ATOM     28  CB  LYS A   5     -15.865   7.380  11.341  1.00 73.57           C  
ATOM     29  N   HIS A   6     -12.746   6.635  12.350  1.00 69.86           N  
ATOM     30  CA  HIS A   6     -12.557   5.979  13.649  1.00 67.80           C  
ATOM     31  C   HIS A   6     -12.632   7.127  14.720  1.00 66.67           C  
ATOM     32  O   HIS A   6     -11.974   7.071  15.770  1.00 65.84           O  
ATOM     33  CB  HIS A   6     -11.207   5.235  13.699  1.00 68.43           C  
ATOM     34  CG  HIS A   6     -11.248   3.833  13.173  1.00 70.28           C  
ATOM     35  ND1 HIS A   6     -12.168   2.897  13.602  1.00 78.48           N  
ATOM     36  CD2 HIS A   6     -10.441   3.188  12.294  1.00 72.78           C  
ATOM     37  CE1 HIS A   6     -11.953   1.749  12.982  1.00 76.51           C  
ATOM     38  NE2 HIS A   6     -10.908   1.898  12.184  1.00 76.13           N  
ATOM     39  N   ILE A   7     -13.470   8.140  14.440  1.00 63.77           N  
ATOM     40  CA  ILE A   7     -13.382   9.488  15.039  1.00 63.13           C  
ATOM     41  C   ILE A   7     -13.551   9.485  16.540  1.00 59.87           C  
ATOM     42  O   ILE A   7     -12.810  10.146  17.264  1.00 60.31           O  
ATOM     43  CB  ILE A   7     -14.460  10.443  14.467  1.00 62.89           C  
ATOM     44  CG1 ILE A   7     -14.171  10.780  13.006  1.00 63.31           C  
ATOM     45  CG2 ILE A   7     -14.536  11.748  15.288  1.00 62.12           C  
ATOM     46  CD1 ILE A   7     -15.315  11.528  12.336  1.00 64.70           C  
ATOM     47  N   ASP A   8     -14.593   8.793  16.968  1.00 57.76           N  
ATOM     48  CA  ASP A   8     -14.768   8.360  18.350  1.00 55.88           C  
ATOM     49  C   ASP A   8     -13.414   8.083  19.078  1.00 54.08           C  
ATOM     50  O   ASP A   8     -13.013   8.849  19.972  1.00 48.71           O  
ATOM     51  CB  ASP A   8     -15.770   7.157  18.445  1.00 56.27           C  
ATOM     52  CG  ASP A   8     -16.049   6.417  17.061  1.00 58.52           C  
ATOM     53  OD1 ASP A   8     -15.120   5.849  16.412  1.00 57.91           O  
ATOM     54  OD2 ASP A   8     -17.234   6.392  16.638  1.00 52.02           O  
ATOM     55  N   LYS A   9     -12.698   7.037  18.659  1.00 54.30           N  
ATOM     56  CA  LYS A   9     -11.479   6.595  19.370  1.00 54.95           C  
ATOM     57  C   LYS A   9     -10.280   7.545  19.205  1.00 55.22           C  
ATOM     58  O   LYS A   9      -9.434   7.672  20.118  1.00 55.46           O  
ATOM     59  CB  LYS A   9     -11.081   5.177  18.943  1.00 54.40           C  
ATOM     60  CG  LYS A   9      -9.961   4.581  19.797  1.00 54.01           C  
ATOM     61  N   ILE A  10     -10.206   8.186  18.037  1.00 53.73           N  
ATOM     62  CA  ILE A  10      -9.169   9.160  17.750  1.00 51.62           C  
ATOM     63  C   ILE A  10      -9.324  10.374  18.646  1.00 51.23           C  
ATOM     64  O   ILE A  10      -8.346  10.806  19.254  1.00 53.21           O  
ATOM     65  CB  ILE A  10      -9.162   9.582  16.256  1.00 51.37           C  
ATOM     66  CG1 ILE A  10      -8.678   8.418  15.383  1.00 55.33           C  
ATOM     67  CG2 ILE A  10      -8.254  10.764  16.029  1.00 40.93           C  
ATOM     68  CD1 ILE A  10      -8.532   8.740  13.886  1.00 52.50           C  
ATOM     69  N   GLN A  11     -10.529  10.929  18.739  1.00 48.76           N  
ATOM     70  CA  GLN A  11     -10.745  12.047  19.660  1.00 48.26           C  
ATOM     71  C   GLN A  11     -10.432  11.609  21.087  1.00 46.79           C  
ATOM     72  O   GLN A  11      -9.896  12.390  21.868  1.00 47.39           O  
ATOM     73  CB  GLN A  11     -12.163  12.627  19.580  1.00 47.50           C  
ATOM     74  CG  GLN A  11     -12.369  13.682  18.491  1.00 48.09           C  
ATOM     75  CD  GLN A  11     -13.741  14.338  18.572  1.00 51.85           C  
ATOM     76  OE1 GLN A  11     -14.512  14.331  17.612  1.00 67.33           O  
ATOM     77  NE2 GLN A  11     -14.062  14.882  19.731  1.00 60.85           N  
ATOM     78  N   ALA A  12     -10.736  10.352  21.403  1.00 47.82           N  
ATOM     79  CA  ALA A  12     -10.421   9.767  22.698  1.00 49.29           C  
ATOM     80  C   ALA A  12      -8.917   9.792  22.906  1.00 52.10           C  
ATOM     81  O   ALA A  12      -8.437  10.267  23.929  1.00 54.40           O  
ATOM     82  CB  ALA A  12     -10.950   8.347  22.778  1.00 47.42           C  
ATOM     83  N   VAL A  13      -8.174   9.327  21.911  1.00 53.80           N  
ATOM     84  CA  VAL A  13      -6.713   9.318  21.982  1.00 53.72           C  
ATOM     85  C   VAL A  13      -6.101  10.719  22.140  1.00 55.11           C  
ATOM     86  O   VAL A  13      -5.155  10.907  22.920  1.00 57.28           O  
ATOM     87  CB  VAL A  13      -6.119   8.569  20.750  1.00 53.63           C  
ATOM     88  CG1 VAL A  13      -4.641   8.873  20.574  1.00 49.54           C  
ATOM     89  CG2 VAL A  13      -6.375   7.076  20.896  1.00 44.61           C  
ATOM     90  N   ILE A  14      -6.647  11.699  21.430  1.00 55.23           N  
ATOM     91  CA  ILE A  14      -6.157  13.083  21.534  1.00 55.10           C  
ATOM     92  C   ILE A  14      -6.425  13.705  22.923  1.00 57.81           C  
ATOM     93  O   ILE A  14      -5.582  14.443  23.439  1.00 60.07           O  
ATOM     94  CB  ILE A  14      -6.792  13.989  20.465  1.00 55.07           C  
ATOM     95  CG1 ILE A  14      -6.367  13.526  19.054  1.00 54.10           C  
ATOM     96  CG2 ILE A  14      -6.416  15.452  20.727  1.00 46.79           C  
ATOM     97  CD1 ILE A  14      -6.920  14.377  17.903  1.00 51.49           C  
ATOM     98  N   LYS A  15      -7.594  13.422  23.518  1.00 57.42           N  
ATOM     99  CA  LYS A  15      -7.918  13.932  24.881  1.00 55.85           C  
ATOM    100  C   LYS A  15      -6.962  13.322  25.903  1.00 54.28           C  
ATOM    101  O   LYS A  15      -6.627  13.931  26.894  1.00 55.36           O  
ATOM    102  CB  LYS A  15      -9.387  13.661  25.274  1.00 52.52           C  
ATOM    103  N   ASP A  16      -6.496  12.123  25.624  1.00 53.91           N  
ATOM    104  CA  ASP A  16      -5.534  11.434  26.474  1.00 53.19           C  
ATOM    105  C   ASP A  16      -4.072  11.969  26.412  1.00 53.01           C  
ATOM    106  O   ASP A  16      -3.312  11.753  27.335  1.00 54.44           O  
ATOM    107  CB  ASP A  16      -5.517   9.957  26.049  1.00 54.35           C  
ATOM    108  CG  ASP A  16      -5.463   9.004  27.202  1.00 57.03           C  
ATOM    109  OD1 ASP A  16      -5.581   9.455  28.364  1.00 58.99           O  
ATOM    110  OD2 ASP A  16      -5.331   7.781  26.923  1.00 62.46           O  
ATOM    111  N   VAL A  17      -3.675  12.628  25.330  1.00 49.69           N  
ATOM    112  CA  VAL A  17      -2.279  12.992  25.114  1.00 49.12           C  
ATOM    113  C   VAL A  17      -2.020  14.433  25.542  1.00 47.56           C  
ATOM    114  O   VAL A  17      -2.673  15.336  25.038  1.00 48.64           O  
ATOM    115  CB  VAL A  17      -1.916  12.877  23.597  1.00 48.90           C  
ATOM    116  CG1 VAL A  17      -0.581  13.552  23.296  1.00 44.15           C  
ATOM    117  CG2 VAL A  17      -1.902  11.421  23.141  1.00 50.67           C  
ATOM    118  N   LYS A  18      -1.010  14.656  26.378  1.00 46.10           N  
ATOM    119  CA  LYS A  18      -0.717  15.983  26.934  1.00 47.97           C  
ATOM    120  C   LYS A  18      -0.286  17.026  25.937  1.00 48.79           C  
ATOM    121  O   LYS A  18      -0.671  18.194  26.058  1.00 52.11           O  
ATOM    122  CB  LYS A  18       0.400  15.879  27.969  1.00 49.15           C  
ATOM    123  CG  LYS A  18       0.673  17.181  28.729  1.00 51.64           C  
ATOM    124  CD  LYS A  18       1.388  16.872  30.040  1.00 54.18           C  
ATOM    125  CE  LYS A  18       1.785  18.124  30.804  1.00 59.06           C  
ATOM    126  NZ  LYS A  18       2.251  17.762  32.180  1.00 62.95           N  
ATOM    127  N   PHE A  19       0.573  16.627  25.001  1.00 48.22           N  
ATOM    128  CA  PHE A  19       1.105  17.536  23.981  1.00 47.83           C  
ATOM    129  C   PHE A  19       1.038  16.952  22.580  1.00 47.23           C  
ATOM    130  O   PHE A  19       1.524  15.849  22.326  1.00 44.32           O  
ATOM    131  CB  PHE A  19       2.572  17.873  24.262  1.00 50.05           C  
ATOM    132  CG  PHE A  19       2.794  18.696  25.498  1.00 48.61           C  
ATOM    133  CD1 PHE A  19       2.346  19.991  25.561  1.00 52.73           C  
ATOM    134  CD2 PHE A  19       3.468  18.177  26.583  1.00 52.58           C  
ATOM    135  CE1 PHE A  19       2.569  20.759  26.686  1.00 54.86           C  
ATOM    136  CE2 PHE A  19       3.691  18.940  27.727  1.00 52.79           C  
ATOM    137  CZ  PHE A  19       3.243  20.229  27.772  1.00 49.34           C  
ATOM    138  N   ALA A  20       0.437  17.711  21.673  1.00 48.55           N  
ATOM    139  CA  ALA A  20       0.566  17.492  20.245  1.00 48.99           C  
ATOM    140  C   ALA A  20       1.949  17.972  19.851  1.00 50.26           C  
ATOM    141  O   ALA A  20       2.477  18.917  20.456  1.00 48.12           O  
ATOM    142  CB  ALA A  20      -0.471  18.324  19.511  1.00 48.35           C  
HETATM  143  N   MSE A  21       2.533  17.347  18.830  1.00 50.42           N  
HETATM  144  CA  MSE A  21       3.702  17.919  18.168  1.00 45.87           C  
HETATM  145  C   MSE A  21       3.158  18.533  16.886  1.00 44.12           C  
HETATM  146  O   MSE A  21       2.631  17.824  16.022  1.00 44.34           O  
HETATM  147  CB  MSE A  21       4.741  16.841  17.872  1.00 46.25           C  
HETATM  148  CG  MSE A  21       5.360  16.161  19.105  1.00 49.80           C  
HETATM  149 SE   MSE A  21       6.310  17.443  20.244  0.75 49.13          SE  
HETATM  150  CE  MSE A  21       7.829  18.003  19.162  1.00 47.46           C  
ATOM    151  N   ILE A  22       3.269  19.849  16.770  1.00 43.52           N  
ATOM    152  CA  ILE A  22       2.787  20.544  15.596  1.00 44.92           C  
ATOM    153  C   ILE A  22       4.011  20.800  14.760  1.00 45.27           C  
ATOM    154  O   ILE A  22       4.968  21.400  15.256  1.00 44.87           O  
ATOM    155  CB  ILE A  22       2.027  21.842  15.942  1.00 44.45           C  
ATOM    156  CG1 ILE A  22       1.562  22.542  14.680  1.00 49.84           C  
ATOM    157  CG2 ILE A  22       2.861  22.809  16.777  1.00 51.60           C  
ATOM    158  CD1 ILE A  22       0.481  23.589  14.981  1.00 46.89           C  
ATOM    159  N   SER A  23       4.009  20.308  13.518  1.00 44.13           N  
ATOM    160  CA  SER A  23       5.132  20.539  12.619  1.00 46.82           C  
ATOM    161  C   SER A  23       4.712  21.579  11.574  1.00 45.91           C  
ATOM    162  O   SER A  23       3.586  21.549  11.106  1.00 45.47           O  
ATOM    163  CB  SER A  23       5.607  19.237  11.925  1.00 45.60           C  
ATOM    164  OG  SER A  23       6.012  18.234  12.842  1.00 47.59           O  
ATOM    165  N   THR A  24       5.627  22.486  11.217  1.00 47.31           N  
ATOM    166  CA  THR A  24       5.391  23.553  10.214  1.00 47.18           C  
ATOM    167  C   THR A  24       6.626  23.657   9.324  1.00 50.34           C  
ATOM    168  O   THR A  24       7.708  23.179   9.719  1.00 50.03           O  
ATOM    169  CB  THR A  24       5.207  24.925  10.865  1.00 46.60           C  
ATOM    170  OG1 THR A  24       6.432  25.315  11.483  1.00 50.47           O  
ATOM    171  CG2 THR A  24       4.124  24.920  11.925  1.00 47.52           C  
ATOM    172  N   SER A  25       6.487  24.264   8.137  1.00 49.84           N  
ATOM    173  CA  SER A  25       7.644  24.486   7.264  1.00 50.44           C  
ATOM    174  C   SER A  25       7.984  25.997   7.163  1.00 50.55           C  
ATOM    175  O   SER A  25       7.099  26.832   7.029  1.00 50.04           O  
ATOM    176  CB  SER A  25       7.439  23.838   5.884  1.00 51.64           C  
ATOM    177  OG  SER A  25       6.080  23.903   5.481  1.00 59.65           O  
ATOM    178  N   ASN A  26       9.263  26.346   7.233  1.00 51.02           N  
ATOM    179  CA  ASN A  26       9.659  27.756   7.298  1.00 49.94           C  
ATOM    180  C   ASN A  26       9.989  28.279   5.920  1.00 52.15           C  
ATOM    181  O   ASN A  26       9.924  27.523   4.961  1.00 53.75           O  
ATOM    182  CB  ASN A  26      10.800  27.945   8.299  1.00 49.16           C  
ATOM    183  CG  ASN A  26      12.097  27.272   7.875  1.00 47.43           C  
ATOM    184  OD1 ASN A  26      12.263  26.813   6.739  1.00 38.75           O  
ATOM    185  ND2 ASN A  26      13.032  27.213   8.810  1.00 46.17           N  
ATOM    186  N   LYS A  27      10.349  29.553   5.798  1.00 55.51           N  
ATOM    187  CA  LYS A  27      10.528  30.171   4.469  1.00 56.21           C  
ATOM    188  C   LYS A  27      11.510  29.391   3.598  1.00 56.85           C  
ATOM    189  O   LYS A  27      11.300  29.288   2.400  1.00 57.77           O  
ATOM    190  CB  LYS A  27      10.959  31.662   4.564  1.00 57.99           C  
ATOM    191  CG  LYS A  27       9.847  32.675   4.916  1.00 51.82           C  
ATOM    192  N   LYS A  28      12.547  28.809   4.206  1.00 57.64           N  
ATOM    193  CA  LYS A  28      13.538  27.966   3.499  1.00 55.74           C  
ATOM    194  C   LYS A  28      13.015  26.513   3.187  1.00 54.92           C  
ATOM    195  O   LYS A  28      13.696  25.693   2.545  1.00 54.16           O  
ATOM    196  CB  LYS A  28      14.872  27.998   4.304  1.00 55.33           C  
ATOM    197  CG  LYS A  28      15.984  27.097   3.774  1.00 59.03           C  
ATOM    198  CD  LYS A  28      17.437  27.560   4.037  1.00 59.29           C  
ATOM    199  CE  LYS A  28      18.423  26.420   3.637  1.00 59.57           C  
ATOM    200  NZ  LYS A  28      19.659  26.869   2.966  1.00 59.85           N  
ATOM    201  N   GLY A  29      11.793  26.203   3.609  1.00 54.71           N  
ATOM    202  CA  GLY A  29      11.155  24.890   3.362  1.00 53.88           C  
ATOM    203  C   GLY A  29      11.440  23.782   4.388  1.00 53.25           C  
ATOM    204  O   GLY A  29      10.967  22.655   4.230  1.00 51.56           O  
ATOM    205  N   ASP A  30      12.203  24.092   5.441  1.00 51.44           N  
ATOM    206  CA  ASP A  30      12.589  23.099   6.432  1.00 48.77           C  
ATOM    207  C   ASP A  30      11.438  22.889   7.370  1.00 47.59           C  
ATOM    208  O   ASP A  30      10.660  23.809   7.584  1.00 48.25           O  
ATOM    209  CB  ASP A  30      13.809  23.558   7.227  1.00 47.61           C  
ATOM    210  CG  ASP A  30      15.058  23.663   6.378  1.00 50.06           C  
ATOM    211  OD1 ASP A  30      15.145  22.978   5.343  1.00 46.94           O  
ATOM    212  OD2 ASP A  30      15.958  24.451   6.732  1.00 67.58           O  
ATOM    213  N   ILE A  31      11.353  21.683   7.931  1.00 46.85           N  
ATOM    214  CA  ILE A  31      10.296  21.312   8.885  1.00 45.63           C  
ATOM    215  C   ILE A  31      10.833  21.403  10.330  1.00 44.49           C  
ATOM    216  O   ILE A  31      11.957  20.976  10.595  1.00 43.31           O  
ATOM    217  CB  ILE A  31       9.741  19.886   8.580  1.00 44.26           C  
ATOM    218  CG1 ILE A  31       8.916  19.891   7.292  1.00 47.20           C  
ATOM    219  CG2 ILE A  31       8.840  19.410   9.670  1.00 37.66           C  
ATOM    220  CD1 ILE A  31       8.756  18.507   6.637  1.00 46.49           C  
ATOM    221  N   HIS A  32      10.022  21.951  11.238  1.00 43.63           N  
ATOM    222  CA  HIS A  32      10.336  22.067  12.676  1.00 45.22           C  
ATOM    223  C   HIS A  32       9.051  21.778  13.428  1.00 46.08           C  
ATOM    224  O   HIS A  32       7.975  22.020  12.891  1.00 47.30           O  
ATOM    225  CB  HIS A  32      10.796  23.502  13.051  1.00 44.61           C  
ATOM    226  CG  HIS A  32      12.068  23.893  12.404  1.00 38.38           C  
ATOM    227  ND1 HIS A  32      12.110  24.597  11.213  1.00 49.76           N  
ATOM    228  CD2 HIS A  32      13.348  23.552  12.690  1.00 39.85           C  
ATOM    229  CE1 HIS A  32      13.369  24.700  10.815  1.00 43.39           C  
ATOM    230  NE2 HIS A  32      14.138  24.070  11.689  1.00 40.05           N  
ATOM    231  N   ALA A  33       9.160  21.294  14.664  1.00 44.85           N  
ATOM    232  CA  ALA A  33       7.986  20.976  15.468  1.00 45.14           C  
ATOM    233  C   ALA A  33       8.075  21.587  16.871  1.00 45.73           C  
ATOM    234  O   ALA A  33       9.163  21.915  17.350  1.00 43.88           O  
ATOM    235  CB  ALA A  33       7.801  19.463  15.567  1.00 41.01           C  
ATOM    236  N   TRP A  34       6.921  21.760  17.508  1.00 44.76           N  
ATOM    237  CA  TRP A  34       6.867  22.230  18.879  1.00 46.99           C  
ATOM    238  C   TRP A  34       5.764  21.493  19.574  1.00 46.36           C  
ATOM    239  O   TRP A  34       4.750  21.201  18.945  1.00 45.58           O  
ATOM    240  CB  TRP A  34       6.517  23.708  18.956  1.00 49.60           C  
ATOM    241  CG  TRP A  34       7.508  24.564  18.299  1.00 55.03           C  
ATOM    242  CD1 TRP A  34       8.550  25.244  18.901  1.00 50.33           C  
ATOM    243  CD2 TRP A  34       7.578  24.863  16.902  1.00 50.94           C  
ATOM    244  NE1 TRP A  34       9.253  25.941  17.948  1.00 52.82           N  
ATOM    245  CE2 TRP A  34       8.692  25.719  16.712  1.00 54.29           C  
ATOM    246  CE3 TRP A  34       6.804  24.502  15.796  1.00 50.94           C  
ATOM    247  CZ2 TRP A  34       9.073  26.194  15.442  1.00 54.10           C  
ATOM    248  CZ3 TRP A  34       7.159  24.991  14.541  1.00 51.11           C  
ATOM    249  CH2 TRP A  34       8.295  25.817  14.371  1.00 55.46           C  
ATOM    250  N   PRO A  35       5.917  21.256  20.879  1.00 48.17           N  
ATOM    251  CA  PRO A  35       4.863  20.584  21.623  1.00 48.55           C  
ATOM    252  C   PRO A  35       3.821  21.589  22.029  1.00 47.41           C  
ATOM    253  O   PRO A  35       4.191  22.689  22.366  1.00 46.65           O  
ATOM    254  CB  PRO A  35       5.577  20.082  22.871  1.00 49.45           C  
ATOM    255  CG  PRO A  35       6.901  20.775  22.908  1.00 45.72           C  
ATOM    256  CD  PRO A  35       7.057  21.617  21.747  1.00 47.84           C  
HETATM  257  N   MSE A  36       2.541  21.239  21.991  1.00 49.49           N  
HETATM  258  CA  MSE A  36       1.482  22.157  22.404  1.00 53.22           C  
HETATM  259  C   MSE A  36       0.257  21.436  22.935  1.00 49.95           C  
HETATM  260  O   MSE A  36      -0.039  20.321  22.539  1.00 52.55           O  
HETATM  261  CB  MSE A  36       1.117  23.061  21.245  1.00 54.82           C  
HETATM  262  CG  MSE A  36       2.240  24.126  20.939  1.00 59.14           C  
HETATM  263 SE   MSE A  36       1.692  25.261  19.573  0.75 70.55          SE  
HETATM  264  CE  MSE A  36       0.392  26.375  20.540  1.00 60.10           C  
ATOM    265  N   THR A  37      -0.428  22.050  23.881  1.00 48.42           N  
ATOM    266  CA  THR A  37      -1.574  21.429  24.493  1.00 46.77           C  
ATOM    267  C   THR A  37      -2.764  21.808  23.624  1.00 45.67           C  
ATOM    268  O   THR A  37      -2.894  22.963  23.211  1.00 40.89           O  
ATOM    269  CB  THR A  37      -1.752  21.899  25.962  1.00 47.52           C  
ATOM    270  OG1 THR A  37      -1.531  23.287  26.002  1.00 44.87           O  
ATOM    271  CG2 THR A  37      -0.727  21.222  26.925  1.00 43.40           C  
ATOM    272  N   THR A  38      -3.584  20.807  23.297  1.00 49.51           N  
ATOM    273  CA  THR A  38      -4.756  20.993  22.446  1.00 51.72           C  
ATOM    274  C   THR A  38      -5.846  21.602  23.292  1.00 50.89           C  
ATOM    275  O   THR A  38      -6.186  21.067  24.332  1.00 48.84           O  
ATOM    276  CB  THR A  38      -5.299  19.674  21.823  1.00 52.82           C  
ATOM    277  OG1 THR A  38      -4.220  18.916  21.260  1.00 56.58           O  
ATOM    278  CG2 THR A  38      -6.316  19.996  20.712  1.00 48.31           C  
ATOM    279  N   SER A  39      -6.387  22.725  22.840  1.00 51.39           N  
ATOM    280  CA  SER A  39      -7.462  23.369  23.558  1.00 50.30           C  
ATOM    281  C   SER A  39      -8.784  22.752  23.216  1.00 49.01           C  
ATOM    282  O   SER A  39      -9.630  22.682  24.058  1.00 50.66           O  
ATOM    283  CB  SER A  39      -7.487  24.870  23.284  1.00 51.57           C  
ATOM    284  OG  SER A  39      -6.260  25.451  23.706  1.00 59.29           O  
ATOM    285  N   GLU A  40      -8.992  22.317  21.985  1.00 50.45           N  
ATOM    286  CA  GLU A  40     -10.274  21.714  21.619  1.00 50.04           C  
ATOM    287  C   GLU A  40     -10.076  20.872  20.394  1.00 49.33           C  
ATOM    288  O   GLU A  40      -9.291  21.243  19.519  1.00 50.05           O  
ATOM    289  CB  GLU A  40     -11.313  22.785  21.330  1.00 49.20           C  
ATOM    290  CG  GLU A  40     -12.734  22.248  21.154  1.00 52.98           C  
ATOM    291  CD  GLU A  40     -13.714  23.315  20.674  1.00 53.48           C  
ATOM    292  OE1 GLU A  40     -13.622  24.479  21.130  1.00 62.85           O  
ATOM    293  OE2 GLU A  40     -14.589  22.973  19.844  1.00 62.22           O  
ATOM    294  N   VAL A  41     -10.775  19.738  20.355  1.00 49.90           N  
ATOM    295  CA  VAL A  41     -10.722  18.819  19.226  1.00 48.90           C  
ATOM    296  C   VAL A  41     -12.161  18.411  18.903  1.00 48.80           C  
ATOM    297  O   VAL A  41     -12.811  17.754  19.703  1.00 49.03           O  
ATOM    298  CB  VAL A  41      -9.818  17.612  19.519  1.00 49.01           C  
ATOM    299  CG1 VAL A  41     -10.312  16.833  20.758  1.00 47.12           C  
ATOM    300  CG2 VAL A  41      -9.742  16.713  18.287  1.00 47.17           C  
ATOM    301  N   ASN A  42     -12.674  18.893  17.767  1.00 48.27           N  
ATOM    302  CA  ASN A  42     -13.949  18.444  17.220  1.00 48.16           C  
ATOM    303  C   ASN A  42     -13.733  18.069  15.754  1.00 47.80           C  
ATOM    304  O   ASN A  42     -13.819  18.922  14.854  1.00 46.95           O  
ATOM    305  CB  ASN A  42     -15.034  19.509  17.364  1.00 48.15           C  
ATOM    306  CG  ASN A  42     -16.386  19.057  16.809  1.00 49.68           C  
ATOM    307  OD1 ASN A  42     -16.479  18.150  15.975  1.00 52.45           O  
ATOM    308  ND2 ASN A  42     -17.441  19.714  17.254  1.00 50.76           N  
ATOM    309  N   LEU A  43     -13.489  16.776  15.538  1.00 46.12           N  
ATOM    310  CA  LEU A  43     -13.259  16.236  14.203  1.00 44.96           C  
ATOM    311  C   LEU A  43     -14.476  16.290  13.269  1.00 44.03           C  
ATOM    312  O   LEU A  43     -14.311  16.627  12.101  1.00 41.65           O  
ATOM    313  CB  LEU A  43     -12.670  14.819  14.298  1.00 44.67           C  
ATOM    314  CG  LEU A  43     -11.282  14.779  14.971  1.00 44.09           C  
ATOM    315  CD1 LEU A  43     -10.665  13.404  14.893  1.00 32.18           C  
ATOM    316  CD2 LEU A  43     -10.316  15.778  14.365  1.00 33.97           C  
ATOM    317  N   ASP A  44     -15.686  16.023  13.763  1.00 45.42           N  
ATOM    318  CA  ASP A  44     -16.893  16.232  12.932  1.00 45.69           C  
ATOM    319  C   ASP A  44     -16.996  17.651  12.364  1.00 45.77           C  
ATOM    320  O   ASP A  44     -17.317  17.806  11.193  1.00 47.39           O  
ATOM    321  CB  ASP A  44     -18.197  15.882  13.674  1.00 45.56           C  
ATOM    322  CG  ASP A  44     -18.497  14.395  13.668  1.00 48.08           C  
ATOM    323  OD1 ASP A  44     -17.686  13.593  13.145  1.00 51.58           O  
ATOM    324  OD2 ASP A  44     -19.565  14.021  14.187  1.00 54.82           O  
ATOM    325  N   ASN A  45     -16.711  18.672  13.169  1.00 45.18           N  
ATOM    326  CA  ASN A  45     -16.716  20.058  12.672  1.00 46.42           C  
ATOM    327  C   ASN A  45     -15.405  20.490  12.038  1.00 48.46           C  
ATOM    328  O   ASN A  45     -15.302  21.623  11.569  1.00 48.46           O  
ATOM    329  CB  ASN A  45     -17.067  21.035  13.787  1.00 46.62           C  
ATOM    330  CG  ASN A  45     -18.529  21.008  14.138  1.00 47.72           C  
ATOM    331  OD1 ASN A  45     -19.194  19.956  14.133  1.00 42.29           O  
ATOM    332  ND2 ASN A  45     -19.051  22.177  14.439  1.00 55.14           N  
ATOM    333  N   LYS A  46     -14.403  19.607  12.054  1.00 49.90           N  
ATOM    334  CA  LYS A  46     -13.130  19.823  11.360  1.00 51.10           C  
ATOM    335  C   LYS A  46     -12.472  21.068  11.910  1.00 51.21           C  
ATOM    336  O   LYS A  46     -12.352  22.094  11.231  1.00 52.49           O  
ATOM    337  CB  LYS A  46     -13.309  19.870   9.831  1.00 51.70           C  
ATOM    338  CG  LYS A  46     -13.909  18.580   9.263  1.00 51.30           C  
ATOM    339  CD  LYS A  46     -14.054  18.584   7.733  1.00 51.67           C  
ATOM    340  CE  LYS A  46     -14.750  17.293   7.249  1.00 51.63           C  
ATOM    341  NZ  LYS A  46     -15.446  17.441   5.924  1.00 56.76           N  
ATOM    342  N   GLU A  47     -12.067  20.937  13.173  1.00 50.78           N  
ATOM    343  CA  GLU A  47     -11.576  22.027  13.997  1.00 49.81           C  
ATOM    344  C   GLU A  47     -10.715  21.475  15.109  1.00 46.87           C  
ATOM    345  O   GLU A  47     -11.197  20.691  15.925  1.00 43.95           O  
ATOM    346  CB  GLU A  47     -12.747  22.747  14.644  1.00 51.41           C  
ATOM    347  CG  GLU A  47     -13.183  24.022  13.939  1.00 56.20           C  
ATOM    348  CD  GLU A  47     -14.430  24.646  14.561  1.00 52.63           C  
ATOM    349  OE1 GLU A  47     -14.844  24.193  15.656  1.00 49.04           O  
ATOM    350  OE2 GLU A  47     -14.994  25.578  13.935  1.00 50.42           O  
ATOM    351  N   ILE A  48      -9.441  21.860  15.118  1.00 45.90           N  
ATOM    352  CA  ILE A  48      -8.578  21.654  16.269  1.00 46.14           C  
ATOM    353  C   ILE A  48      -8.024  23.041  16.660  1.00 47.85           C  
ATOM    354  O   ILE A  48      -7.496  23.784  15.826  1.00 49.54           O  
ATOM    355  CB  ILE A  48      -7.454  20.606  15.999  1.00 47.16           C  
ATOM    356  CG1 ILE A  48      -8.042  19.298  15.396  1.00 50.50           C  
ATOM    357  CG2 ILE A  48      -6.705  20.322  17.278  1.00 41.12           C  
ATOM    358  CD1 ILE A  48      -6.998  18.293  14.819  1.00 44.71           C  
ATOM    359  N   TRP A  49      -8.175  23.394  17.934  1.00 48.65           N  
ATOM    360  CA  TRP A  49      -7.837  24.724  18.413  1.00 47.65           C  
ATOM    361  C   TRP A  49      -6.683  24.691  19.382  1.00 49.00           C  
ATOM    362  O   TRP A  49      -6.624  23.826  20.266  1.00 50.34           O  
ATOM    363  CB  TRP A  49      -9.020  25.310  19.147  1.00 46.74           C  
ATOM    364  CG  TRP A  49     -10.155  25.693  18.281  1.00 46.82           C  
ATOM    365  CD1 TRP A  49     -11.265  24.953  18.001  1.00 50.45           C  
ATOM    366  CD2 TRP A  49     -10.332  26.945  17.622  1.00 46.12           C  
ATOM    367  NE1 TRP A  49     -12.118  25.664  17.196  1.00 47.43           N  
ATOM    368  CE2 TRP A  49     -11.562  26.890  16.941  1.00 44.57           C  
ATOM    369  CE3 TRP A  49      -9.567  28.116  17.545  1.00 52.92           C  
ATOM    370  CZ2 TRP A  49     -12.047  27.959  16.184  1.00 43.93           C  
ATOM    371  CZ3 TRP A  49     -10.057  29.184  16.788  1.00 52.84           C  
ATOM    372  CH2 TRP A  49     -11.286  29.091  16.121  1.00 47.81           C  
ATOM    373  N   PHE A  50      -5.785  25.659  19.231  1.00 50.72           N  
ATOM    374  CA  PHE A  50      -4.709  25.932  20.195  1.00 50.13           C  
ATOM    375  C   PHE A  50      -4.735  27.400  20.583  1.00 50.78           C  
ATOM    376  O   PHE A  50      -5.200  28.234  19.811  1.00 51.40           O  
ATOM    377  CB  PHE A  50      -3.364  25.623  19.569  1.00 47.10           C  
ATOM    378  CG  PHE A  50      -3.237  24.222  19.142  1.00 47.72           C  
ATOM    379  CD1 PHE A  50      -3.684  23.828  17.902  1.00 50.73           C  
ATOM    380  CD2 PHE A  50      -2.692  23.273  19.997  1.00 53.73           C  
ATOM    381  CE1 PHE A  50      -3.604  22.511  17.516  1.00 53.31           C  
ATOM    382  CE2 PHE A  50      -2.588  21.954  19.614  1.00 51.88           C  
ATOM    383  CZ  PHE A  50      -3.046  21.568  18.365  1.00 51.44           C  
ATOM    384  N   ILE A  51      -4.222  27.710  21.766  1.00 52.23           N  
ATOM    385  CA  ILE A  51      -3.945  29.099  22.154  1.00 54.29           C  
ATOM    386  C   ILE A  51      -2.427  29.267  22.088  1.00 54.37           C  
ATOM    387  O   ILE A  51      -1.681  28.652  22.864  1.00 53.21           O  
ATOM    388  CB  ILE A  51      -4.471  29.437  23.552  1.00 54.37           C  
ATOM    389  CG1 ILE A  51      -6.000  29.398  23.557  1.00 56.40           C  
ATOM    390  CG2 ILE A  51      -3.997  30.815  23.969  1.00 58.37           C  
ATOM    391  CD1 ILE A  51      -6.611  29.433  24.953  1.00 53.06           C  
ATOM    392  N   GLY A  52      -1.985  30.045  21.104  1.00 53.28           N  
ATOM    393  CA  GLY A  52      -0.579  30.362  20.931  1.00 52.07           C  
ATOM    394  C   GLY A  52      -0.239  31.807  21.288  1.00 52.55           C  
ATOM    395  O   GLY A  52      -1.084  32.603  21.745  1.00 50.16           O  
ATOM    396  N   ASP A  53       1.026  32.113  21.047  1.00 51.77           N  
ATOM    397  CA  ASP A  53       1.631  33.408  21.246  1.00 51.00           C  
ATOM    398  C   ASP A  53       1.909  33.972  19.865  1.00 50.38           C  
ATOM    399  O   ASP A  53       2.404  33.236  18.989  1.00 50.72           O  
ATOM    400  CB  ASP A  53       2.952  33.204  21.923  1.00 50.88           C  
ATOM    401  CG  ASP A  53       3.192  34.173  22.978  1.00 65.39           C  
ATOM    402  OD1 ASP A  53       2.786  33.842  24.122  1.00 80.99           O  
ATOM    403  OD2 ASP A  53       3.793  35.237  22.674  1.00 76.64           O  
ATOM    404  N   LYS A  54       1.641  35.258  19.652  1.00 48.91           N  
ATOM    405  CA  LYS A  54       1.980  35.879  18.364  1.00 47.48           C  
ATOM    406  C   LYS A  54       3.465  35.949  18.122  1.00 49.08           C  
ATOM    407  O   LYS A  54       3.881  35.903  16.971  1.00 52.31           O  
ATOM    408  CB  LYS A  54       1.463  37.283  18.267  1.00 46.20           C  
ATOM    409  CG  LYS A  54       0.010  37.345  18.215  1.00 50.14           C  
ATOM    410  CD  LYS A  54      -0.443  38.728  17.948  1.00 51.07           C  
ATOM    411  CE  LYS A  54      -1.954  38.794  18.018  1.00 53.50           C  
ATOM    412  NZ  LYS A  54      -2.299  40.226  17.934  1.00 62.25           N  
ATOM    413  N   THR A  55       4.267  36.065  19.184  1.00 49.10           N  
ATOM    414  CA  THR A  55       5.725  36.075  19.030  1.00 48.84           C  
ATOM    415  C   THR A  55       6.343  34.692  18.742  1.00 47.79           C  
ATOM    416  O   THR A  55       7.526  34.630  18.480  1.00 46.33           O  
ATOM    417  CB  THR A  55       6.388  36.628  20.281  1.00 49.71           C  
ATOM    418  OG1 THR A  55       6.007  35.809  21.388  1.00 54.45           O  
ATOM    419  CG2 THR A  55       5.939  38.072  20.529  1.00 51.88           C  
ATOM    420  N   SER A  56       5.575  33.596  18.805  1.00 47.70           N  
ATOM    421  CA  SER A  56       6.138  32.230  18.644  1.00 45.67           C  
ATOM    422  C   SER A  56       6.559  31.909  17.224  1.00 46.98           C  
ATOM    423  O   SER A  56       5.971  32.411  16.268  1.00 45.15           O  
ATOM    424  CB  SER A  56       5.111  31.174  19.065  1.00 44.58           C  
ATOM    425  OG  SER A  56       3.982  31.151  18.181  1.00 42.83           O  
ATOM    426  N   ASP A  57       7.544  31.017  17.083  1.00 50.27           N  
ATOM    427  CA  ASP A  57       7.987  30.537  15.774  1.00 50.23           C  
ATOM    428  C   ASP A  57       6.912  29.820  14.974  1.00 51.42           C  
ATOM    429  O   ASP A  57       6.892  29.854  13.735  1.00 54.30           O  
ATOM    430  CB  ASP A  57       9.151  29.573  15.956  1.00 50.46           C  
ATOM    431  CG  ASP A  57      10.471  30.289  16.216  1.00 58.35           C  
ATOM    432  OD1 ASP A  57      10.641  31.420  15.732  1.00 52.07           O  
ATOM    433  OD2 ASP A  57      11.363  29.705  16.869  1.00 70.09           O  
ATOM    434  N   VAL A  58       6.038  29.132  15.683  1.00 50.06           N  
ATOM    435  CA  VAL A  58       5.040  28.334  15.032  1.00 48.55           C  
ATOM    436  C   VAL A  58       4.087  29.284  14.359  1.00 48.33           C  
ATOM    437  O   VAL A  58       3.771  29.094  13.166  1.00 48.95           O  
ATOM    438  CB  VAL A  58       4.354  27.348  16.018  1.00 48.77           C  
ATOM    439  CG1 VAL A  58       3.599  28.063  17.122  1.00 44.78           C  
ATOM    440  CG2 VAL A  58       3.429  26.454  15.277  1.00 55.21           C  
ATOM    441  N   VAL A  59       3.683  30.354  15.069  1.00 48.50           N  
ATOM    442  CA  VAL A  59       2.824  31.392  14.458  1.00 44.69           C  
ATOM    443  C   VAL A  59       3.519  32.091  13.276  1.00 47.35           C  
ATOM    444  O   VAL A  59       2.894  32.312  12.227  1.00 48.43           O  
ATOM    445  CB  VAL A  59       2.356  32.413  15.482  1.00 45.90           C  
ATOM    446  CG1 VAL A  59       1.708  33.606  14.772  1.00 37.63           C  
ATOM    447  CG2 VAL A  59       1.348  31.773  16.475  1.00 41.43           C  
ATOM    448  N   LYS A  60       4.813  32.394  13.438  1.00 49.85           N  
ATOM    449  CA  LYS A  60       5.635  32.976  12.381  1.00 51.25           C  
ATOM    450  C   LYS A  60       5.585  32.132  11.125  1.00 53.80           C  
ATOM    451  O   LYS A  60       5.298  32.638  10.046  1.00 56.42           O  
ATOM    452  CB  LYS A  60       7.096  33.106  12.832  1.00 51.19           C  
ATOM    453  CG  LYS A  60       7.970  33.937  11.885  1.00 55.37           C  
ATOM    454  CD  LYS A  60       9.488  33.952  12.259  1.00 59.91           C  
ATOM    455  CE  LYS A  60      10.271  32.705  11.754  1.00 74.53           C  
ATOM    456  NZ  LYS A  60      11.703  33.041  11.382  1.00 73.71           N  
ATOM    457  N   ASP A  61       5.886  30.845  11.258  1.00 55.46           N  
ATOM    458  CA  ASP A  61       5.832  29.934  10.117  1.00 54.58           C  
ATOM    459  C   ASP A  61       4.413  29.856   9.524  1.00 52.77           C  
ATOM    460  O   ASP A  61       4.251  29.890   8.303  1.00 53.57           O  
ATOM    461  CB  ASP A  61       6.322  28.531  10.517  1.00 55.16           C  
ATOM    462  CG  ASP A  61       7.836  28.459  10.749  1.00 55.64           C  
ATOM    463  OD1 ASP A  61       8.577  29.456  10.549  1.00 64.78           O  
ATOM    464  OD2 ASP A  61       8.297  27.361  11.134  1.00 67.39           O  
ATOM    465  N   ILE A  62       3.392  29.765  10.368  1.00 51.16           N  
ATOM    466  CA  ILE A  62       2.020  29.654   9.865  1.00 51.70           C  
ATOM    467  C   ILE A  62       1.618  30.871   9.047  1.00 53.57           C  
ATOM    468  O   ILE A  62       0.938  30.741   8.049  1.00 54.19           O  
ATOM    469  CB  ILE A  62       0.988  29.418  11.003  1.00 54.83           C  
ATOM    470  CG1 ILE A  62       1.182  28.015  11.620  1.00 53.92           C  
ATOM    471  CG2 ILE A  62      -0.439  29.573  10.466  1.00 51.39           C  
ATOM    472  CD1 ILE A  62       0.379  27.761  12.876  1.00 49.71           C  
ATOM    473  N   GLN A  63       2.057  32.056   9.453  1.00 55.81           N  
ATOM    474  CA  GLN A  63       1.798  33.253   8.662  1.00 56.68           C  
ATOM    475  C   GLN A  63       2.219  33.181   7.208  1.00 56.53           C  
ATOM    476  O   GLN A  63       1.551  33.775   6.376  1.00 57.44           O  
ATOM    477  CB  GLN A  63       2.424  34.501   9.291  1.00 57.24           C  
ATOM    478  CG  GLN A  63       1.364  35.464   9.849  1.00 61.34           C  
ATOM    479  CD  GLN A  63       1.601  35.820  11.291  1.00 67.30           C  
ATOM    480  OE1 GLN A  63       2.670  35.571  11.834  1.00 76.52           O  
ATOM    481  NE2 GLN A  63       0.593  36.387  11.937  1.00 62.01           N  
ATOM    482  N   ASP A  64       3.298  32.463   6.894  1.00 57.39           N  
ATOM    483  CA  ASP A  64       3.728  32.260   5.481  1.00 57.22           C  
ATOM    484  C   ASP A  64       3.327  30.931   4.844  1.00 54.87           C  
ATOM    485  O   ASP A  64       3.311  30.816   3.631  1.00 53.30           O  
ATOM    486  CB  ASP A  64       5.244  32.426   5.349  1.00 57.81           C  
ATOM    487  CG  ASP A  64       5.692  33.895   5.436  1.00 71.22           C  
ATOM    488  OD1 ASP A  64       5.008  34.816   4.893  1.00 72.03           O  
ATOM    489  OD2 ASP A  64       6.760  34.119   6.051  1.00 89.00           O  
ATOM    490  N   ASP A  65       3.024  29.928   5.659  1.00 54.83           N  
ATOM    491  CA  ASP A  65       2.685  28.616   5.160  1.00 52.62           C  
ATOM    492  C   ASP A  65       1.755  27.970   6.178  1.00 51.05           C  
ATOM    493  O   ASP A  65       2.192  27.485   7.225  1.00 47.08           O  
ATOM    494  CB  ASP A  65       3.964  27.810   4.984  1.00 54.02           C  
ATOM    495  CG  ASP A  65       3.748  26.482   4.257  1.00 56.92           C  
ATOM    496  OD1 ASP A  65       2.623  25.934   4.293  1.00 60.62           O  
ATOM    497  OD2 ASP A  65       4.733  25.981   3.656  1.00 55.21           O  
ATOM    498  N   ALA A  66       0.471  27.932   5.824  1.00 50.90           N  
ATOM    499  CA  ALA A  66      -0.592  27.406   6.682  1.00 49.59           C  
ATOM    500  C   ALA A  66      -0.699  25.867   6.704  1.00 50.13           C  
ATOM    501  O   ALA A  66      -1.537  25.324   7.430  1.00 49.01           O  
ATOM    502  CB  ALA A  66      -1.920  28.000   6.242  1.00 45.52           C  
ATOM    503  N   ARG A  67       0.148  25.169   5.943  1.00 51.01           N  
ATOM    504  CA  ARG A  67       0.064  23.701   5.808  1.00 52.29           C  
ATOM    505  C   ARG A  67       0.889  23.047   6.907  1.00 48.72           C  
ATOM    506  O   ARG A  67       2.125  23.097   6.875  1.00 46.65           O  
ATOM    507  CB  ARG A  67       0.547  23.279   4.419  1.00 52.29           C  
ATOM    508  CG  ARG A  67      -0.055  24.164   3.338  1.00 56.55           C  
ATOM    509  CD  ARG A  67      -0.081  23.560   1.971  1.00 61.47           C  
ATOM    510  NE  ARG A  67       1.157  23.692   1.204  1.00 76.81           N  
ATOM    511  CZ  ARG A  67       1.635  24.822   0.670  1.00 83.29           C  
ATOM    512  NH1 ARG A  67       1.017  26.010   0.828  1.00 89.96           N  
ATOM    513  NH2 ARG A  67       2.769  24.756  -0.035  1.00 78.41           N  
ATOM    514  N   ILE A  68       0.196  22.469   7.887  1.00 46.46           N  
ATOM    515  CA  ILE A  68       0.829  21.970   9.101  1.00 45.53           C  
ATOM    516  C   ILE A  68       0.534  20.509   9.295  1.00 45.56           C  
ATOM    517  O   ILE A  68      -0.269  19.936   8.559  1.00 44.37           O  
ATOM    518  CB  ILE A  68       0.399  22.795  10.338  1.00 46.17           C  
ATOM    519  CG1 ILE A  68      -1.066  22.558  10.756  1.00 43.91           C  
ATOM    520  CG2 ILE A  68       0.588  24.291  10.023  1.00 42.16           C  
ATOM    521  CD1 ILE A  68      -1.450  21.151  11.284  1.00 39.87           C  
ATOM    522  N   GLY A  69       1.196  19.929  10.297  1.00 43.62           N  
ATOM    523  CA  GLY A  69       1.007  18.552  10.691  1.00 41.98           C  
ATOM    524  C   GLY A  69       0.865  18.539  12.194  1.00 44.72           C  
ATOM    525  O   GLY A  69       1.543  19.311  12.883  1.00 45.95           O  
ATOM    526  N   LEU A  70      -0.053  17.710  12.699  1.00 44.19           N  
ATOM    527  CA  LEU A  70      -0.116  17.392  14.114  1.00 43.07           C  
ATOM    528  C   LEU A  70       0.110  15.900  14.325  1.00 42.39           C  
ATOM    529  O   LEU A  70      -0.380  15.084  13.559  1.00 41.87           O  
ATOM    530  CB  LEU A  70      -1.477  17.748  14.669  1.00 42.40           C  
ATOM    531  CG  LEU A  70      -1.892  19.199  14.604  1.00 44.80           C  
ATOM    532  CD1 LEU A  70      -3.421  19.251  14.876  1.00 35.23           C  
ATOM    533  CD2 LEU A  70      -1.071  20.018  15.631  1.00 45.38           C  
ATOM    534  N   THR A  71       0.837  15.531  15.370  1.00 43.52           N  
ATOM    535  CA  THR A  71       0.955  14.114  15.725  1.00 44.44           C  
ATOM    536  C   THR A  71       0.754  13.978  17.234  1.00 44.90           C  
ATOM    537  O   THR A  71       1.064  14.889  17.993  1.00 45.90           O  
ATOM    538  CB  THR A  71       2.322  13.477  15.310  1.00 45.90           C  
ATOM    539  OG1 THR A  71       3.342  13.943  16.196  1.00 41.37           O  
ATOM    540  CG2 THR A  71       2.712  13.815  13.860  1.00 42.58           C  
ATOM    541  N   TYR A  72       0.204  12.835  17.621  1.00 43.62           N  
ATOM    542  CA  TYR A  72      -0.202  12.522  18.970  1.00 43.75           C  
ATOM    543  C   TYR A  72       0.258  11.100  19.204  1.00 43.05           C  
ATOM    544  O   TYR A  72       0.011  10.246  18.356  1.00 39.63           O  
ATOM    545  CB  TYR A  72      -1.720  12.560  19.081  1.00 43.43           C  
ATOM    546  CG  TYR A  72      -2.301  13.939  18.988  1.00 42.35           C  
ATOM    547  CD1 TYR A  72      -2.473  14.708  20.125  1.00 46.32           C  
ATOM    548  CD2 TYR A  72      -2.696  14.474  17.774  1.00 44.05           C  
ATOM    549  CE1 TYR A  72      -3.012  15.981  20.055  1.00 47.43           C  
ATOM    550  CE2 TYR A  72      -3.244  15.752  17.694  1.00 44.39           C  
ATOM    551  CZ  TYR A  72      -3.392  16.499  18.842  1.00 49.03           C  
ATOM    552  OH  TYR A  72      -3.921  17.773  18.803  1.00 45.72           O  
ATOM    553  N   ALA A  73       0.952  10.858  20.317  1.00 43.62           N  
ATOM    554  CA  ALA A  73       1.386   9.509  20.717  1.00 44.01           C  
ATOM    555  C   ALA A  73       0.878   9.283  22.137  1.00 43.53           C  
ATOM    556  O   ALA A  73       1.060  10.143  22.967  1.00 45.96           O  
ATOM    557  CB  ALA A  73       2.900   9.417  20.677  1.00 42.16           C  
ATOM    558  N   THR A  74       0.189   8.178  22.408  1.00 42.56           N  
ATOM    559  CA  THR A  74      -0.251   7.908  23.763  1.00 43.65           C  
ATOM    560  C   THR A  74       0.923   7.385  24.585  1.00 45.60           C  
ATOM    561  O   THR A  74       1.843   6.758  24.066  1.00 46.62           O  
ATOM    562  CB  THR A  74      -1.416   6.898  23.831  1.00 42.31           C  
ATOM    563  OG1 THR A  74      -1.079   5.706  23.105  1.00 45.19           O  
ATOM    564  CG2 THR A  74      -2.694   7.525  23.295  1.00 37.97           C  
ATOM    565  N   GLN A  75       0.884   7.640  25.880  1.00 48.33           N  
ATOM    566  CA  GLN A  75       1.998   7.248  26.737  1.00 51.39           C  
ATOM    567  C   GLN A  75       2.181   5.761  26.882  1.00 50.36           C  
ATOM    568  O   GLN A  75       3.284   5.330  27.150  1.00 53.77           O  
ATOM    569  CB  GLN A  75       1.944   7.938  28.093  1.00 52.68           C  
ATOM    570  CG  GLN A  75       0.700   7.740  28.918  1.00 58.31           C  
ATOM    571  CD  GLN A  75       0.601   8.757  30.046  1.00 55.23           C  
ATOM    572  OE1 GLN A  75       1.444   9.645  30.182  1.00 51.78           O  
ATOM    573  NE2 GLN A  75      -0.430   8.615  30.870  1.00 56.63           N  
ATOM    574  N   ASP A  76       1.146   4.963  26.624  1.00 49.90           N  
ATOM    575  CA  ASP A  76       1.316   3.501  26.531  1.00 47.37           C  
ATOM    576  C   ASP A  76       2.018   3.022  25.242  1.00 46.40           C  
ATOM    577  O   ASP A  76       2.125   1.817  25.016  1.00 46.47           O  
ATOM    578  CB  ASP A  76      -0.039   2.774  26.739  1.00 46.62           C  
ATOM    579  CG  ASP A  76      -1.003   2.912  25.553  1.00 51.86           C  
ATOM    580  OD1 ASP A  76      -0.843   3.841  24.717  1.00 50.90           O  
ATOM    581  OD2 ASP A  76      -1.932   2.070  25.455  1.00 50.33           O  
ATOM    582  N   GLU A  77       2.416   3.948  24.370  1.00 45.73           N  
ATOM    583  CA  GLU A  77       3.086   3.637  23.097  1.00 46.96           C  
ATOM    584  C   GLU A  77       2.311   2.671  22.198  1.00 45.69           C  
ATOM    585  O   GLU A  77       2.890   1.970  21.385  1.00 46.86           O  
ATOM    586  CB  GLU A  77       4.535   3.157  23.348  1.00 47.55           C  
ATOM    587  CG  GLU A  77       5.442   4.269  23.939  1.00 52.34           C  
ATOM    588  CD  GLU A  77       6.961   4.004  23.828  1.00 50.28           C  
ATOM    589  OE1 GLU A  77       7.421   2.917  24.257  1.00 56.86           O  
ATOM    590  OE2 GLU A  77       7.694   4.907  23.336  1.00 48.10           O  
ATOM    591  N   LYS A  78       0.993   2.645  22.353  1.00 46.36           N  
ATOM    592  CA  LYS A  78       0.141   1.646  21.711  1.00 45.30           C  
ATOM    593  C   LYS A  78      -0.720   2.331  20.620  1.00 45.67           C  
ATOM    594  O   LYS A  78      -1.207   1.656  19.705  1.00 46.70           O  
ATOM    595  CB  LYS A  78      -0.685   0.936  22.800  1.00 43.03           C  
ATOM    596  CG  LYS A  78      -0.719  -0.625  22.751  1.00 51.94           C  
ATOM    597  CD  LYS A  78       0.035  -1.343  23.903  1.00 48.53           C  
ATOM    598  N   ASN A  79      -0.847   3.671  20.676  1.00 45.95           N  
ATOM    599  CA  ASN A  79      -1.690   4.453  19.752  1.00 44.83           C  
ATOM    600  C   ASN A  79      -0.998   5.684  19.228  1.00 42.77           C  
ATOM    601  O   ASN A  79      -0.477   6.425  20.017  1.00 45.30           O  
ATOM    602  CB  ASN A  79      -2.939   4.953  20.460  1.00 45.87           C  
ATOM    603  CG  ASN A  79      -3.738   3.849  21.069  1.00 48.12           C  
ATOM    604  OD1 ASN A  79      -4.693   3.361  20.466  1.00 47.91           O  
ATOM    605  ND2 ASN A  79      -3.339   3.424  22.264  1.00 49.58           N  
ATOM    606  N   TYR A  80      -1.057   5.935  17.915  1.00 43.47           N  
ATOM    607  CA  TYR A  80      -0.415   7.119  17.250  1.00 40.42           C  
ATOM    608  C   TYR A  80      -1.394   7.723  16.244  1.00 39.22           C  
ATOM    609  O   TYR A  80      -2.135   6.985  15.630  1.00 40.27           O  
ATOM    610  CB  TYR A  80       0.875   6.698  16.540  1.00 38.87           C  
ATOM    611  CG  TYR A  80       1.892   6.121  17.514  1.00 42.11           C  
ATOM    612  CD1 TYR A  80       1.851   4.765  17.890  1.00 46.54           C  
ATOM    613  CD2 TYR A  80       2.847   6.930  18.104  1.00 38.76           C  
ATOM    614  CE1 TYR A  80       2.757   4.253  18.794  1.00 44.33           C  
ATOM    615  CE2 TYR A  80       3.746   6.435  19.015  1.00 41.31           C  
ATOM    616  CZ  TYR A  80       3.700   5.102  19.361  1.00 45.88           C  
ATOM    617  OH  TYR A  80       4.603   4.619  20.271  1.00 45.63           O  
ATOM    618  N   VAL A  81      -1.429   9.054  16.115  1.00 40.15           N  
ATOM    619  CA  VAL A  81      -2.324   9.761  15.177  1.00 39.62           C  
ATOM    620  C   VAL A  81      -1.527  10.809  14.448  1.00 37.28           C  
ATOM    621  O   VAL A  81      -0.748  11.477  15.057  1.00 38.43           O  
ATOM    622  CB  VAL A  81      -3.496  10.476  15.903  1.00 41.16           C  
ATOM    623  CG1 VAL A  81      -4.316  11.349  14.904  1.00 43.11           C  
ATOM    624  CG2 VAL A  81      -4.389   9.451  16.601  1.00 32.41           C  
ATOM    625  N   SER A  82      -1.705  10.926  13.141  1.00 38.96           N  
ATOM    626  CA  SER A  82      -1.035  11.933  12.328  1.00 41.10           C  
ATOM    627  C   SER A  82      -2.146  12.650  11.587  1.00 41.10           C  
ATOM    628  O   SER A  82      -2.950  12.005  10.882  1.00 40.60           O  
ATOM    629  CB  SER A  82      -0.081  11.273  11.320  1.00 43.01           C  
ATOM    630  OG  SER A  82       0.427  12.193  10.350  1.00 45.64           O  
ATOM    631  N   ILE A  83      -2.195  13.961  11.752  1.00 38.88           N  
ATOM    632  CA  ILE A  83      -3.190  14.795  11.111  1.00 38.99           C  
ATOM    633  C   ILE A  83      -2.471  15.749  10.171  1.00 39.76           C  
ATOM    634  O   ILE A  83      -1.474  16.334  10.544  1.00 39.55           O  
ATOM    635  CB  ILE A  83      -3.973  15.611  12.151  1.00 39.24           C  
ATOM    636  CG1 ILE A  83      -4.905  14.681  12.931  1.00 38.58           C  
ATOM    637  CG2 ILE A  83      -4.796  16.711  11.454  1.00 33.64           C  
ATOM    638  CD1 ILE A  83      -5.294  15.154  14.266  1.00 30.68           C  
ATOM    639  N   SER A  84      -2.985  15.883   8.955  1.00 41.31           N  
ATOM    640  CA  SER A  84      -2.542  16.878   8.014  1.00 43.88           C  
ATOM    641  C   SER A  84      -3.650  17.908   7.912  1.00 45.53           C  
ATOM    642  O   SER A  84      -4.807  17.537   7.752  1.00 48.30           O  
ATOM    643  CB  SER A  84      -2.338  16.254   6.647  1.00 44.84           C  
ATOM    644  OG  SER A  84      -1.748  17.224   5.801  1.00 52.11           O  
ATOM    645  N   GLY A  85      -3.300  19.186   7.963  1.00 46.59           N  
ATOM    646  CA  GLY A  85      -4.283  20.238   8.196  1.00 48.56           C  
ATOM    647  C   GLY A  85      -3.835  21.609   7.744  1.00 48.86           C  
ATOM    648  O   GLY A  85      -2.655  21.815   7.451  1.00 47.85           O  
ATOM    649  N   ASP A  86      -4.797  22.530   7.662  1.00 49.55           N  
ATOM    650  CA  ASP A  86      -4.518  23.947   7.387  1.00 51.17           C  
ATOM    651  C   ASP A  86      -4.782  24.809   8.612  1.00 50.29           C  
ATOM    652  O   ASP A  86      -5.861  24.756   9.185  1.00 50.72           O  
ATOM    653  CB  ASP A  86      -5.326  24.441   6.200  1.00 50.29           C  
ATOM    654  CG  ASP A  86      -5.066  23.620   4.950  1.00 54.88           C  
ATOM    655  OD1 ASP A  86      -3.906  23.625   4.471  1.00 46.95           O  
ATOM    656  OD2 ASP A  86      -6.022  22.961   4.461  1.00 60.27           O  
ATOM    657  N   ALA A  87      -3.778  25.590   9.006  1.00 51.70           N  
ATOM    658  CA  ALA A  87      -3.820  26.352  10.250  1.00 51.79           C  
ATOM    659  C   ALA A  87      -4.265  27.756   9.909  1.00 51.19           C  
ATOM    660  O   ALA A  87      -3.704  28.376   9.002  1.00 51.30           O  
ATOM    661  CB  ALA A  87      -2.427  26.375  10.931  1.00 48.07           C  
ATOM    662  N   GLU A  88      -5.259  28.257  10.633  1.00 51.65           N  
ATOM    663  CA  GLU A  88      -5.683  29.659  10.531  1.00 52.47           C  
ATOM    664  C   GLU A  88      -5.361  30.429  11.810  1.00 53.11           C  
ATOM    665  O   GLU A  88      -5.288  29.844  12.900  1.00 51.84           O  
ATOM    666  CB  GLU A  88      -7.176  29.746  10.280  1.00 52.83           C  
ATOM    667  CG  GLU A  88      -7.573  29.459   8.877  1.00 56.10           C  
ATOM    668  CD  GLU A  88      -9.056  29.210   8.736  1.00 53.94           C  
ATOM    669  OE1 GLU A  88      -9.848  29.703   9.568  1.00 62.65           O  
ATOM    670  OE2 GLU A  88      -9.432  28.514   7.784  1.00 57.06           O  
ATOM    671  N   LEU A  89      -5.242  31.756  11.669  1.00 52.70           N  
ATOM    672  CA  LEU A  89      -4.842  32.659  12.751  1.00 51.83           C  
ATOM    673  C   LEU A  89      -5.946  33.685  13.020  1.00 51.98           C  
ATOM    674  O   LEU A  89      -5.779  34.868  12.753  1.00 53.05           O  
ATOM    675  CB  LEU A  89      -3.503  33.341  12.382  1.00 50.76           C  
ATOM    676  CG  LEU A  89      -2.289  32.411  12.222  1.00 48.75           C  
ATOM    677  CD1 LEU A  89      -1.039  33.176  11.781  1.00 46.79           C  
ATOM    678  CD2 LEU A  89      -2.008  31.640  13.510  1.00 42.34           C  
ATOM    679  N   PRO A  90      -7.099  33.230  13.528  1.00 54.07           N  
ATOM    680  CA  PRO A  90      -8.159  34.192  13.774  1.00 55.13           C  
ATOM    681  C   PRO A  90      -8.048  34.999  15.086  1.00 57.04           C  
ATOM    682  O   PRO A  90      -7.316  34.639  16.007  1.00 58.11           O  
ATOM    683  CB  PRO A  90      -9.414  33.313  13.800  1.00 54.16           C  
ATOM    684  CG  PRO A  90      -8.943  31.997  14.329  1.00 52.12           C  
ATOM    685  CD  PRO A  90      -7.524  31.852  13.856  1.00 54.37           C  
ATOM    686  N   THR A  91      -8.776  36.113  15.093  1.00 58.96           N  
ATOM    687  CA  THR A  91      -9.143  36.862  16.277  1.00 59.73           C  
ATOM    688  C   THR A  91     -10.626  36.567  16.515  1.00 59.11           C  
ATOM    689  O   THR A  91     -11.467  36.848  15.664  1.00 58.87           O  
ATOM    690  CB  THR A  91      -8.948  38.367  16.041  1.00 60.61           C  
ATOM    691  OG1 THR A  91      -7.553  38.637  15.831  1.00 63.23           O  
ATOM    692  CG2 THR A  91      -9.445  39.157  17.216  1.00 56.33           C  
ATOM    693  N   ASP A  92     -10.937  35.966  17.656  1.00 59.28           N  
ATOM    694  CA  ASP A  92     -12.310  35.605  17.994  1.00 57.67           C  
ATOM    695  C   ASP A  92     -12.459  35.592  19.522  1.00 55.71           C  
ATOM    696  O   ASP A  92     -12.139  34.597  20.182  1.00 54.89           O  
ATOM    697  CB  ASP A  92     -12.634  34.249  17.389  1.00 57.05           C  
ATOM    698  CG  ASP A  92     -14.117  33.938  17.395  1.00 61.31           C  
ATOM    699  OD1 ASP A  92     -14.868  34.369  18.320  1.00 59.74           O  
ATOM    700  OD2 ASP A  92     -14.526  33.230  16.449  1.00 64.51           O  
ATOM    701  N   LYS A  93     -12.939  36.715  20.052  1.00 53.19           N  
ATOM    702  CA  LYS A  93     -13.108  36.907  21.487  1.00 52.36           C  
ATOM    703  C   LYS A  93     -14.050  35.845  21.988  1.00 50.99           C  
ATOM    704  O   LYS A  93     -13.756  35.165  22.968  1.00 49.45           O  
ATOM    705  CB  LYS A  93     -13.688  38.299  21.812  1.00 52.00           C  
ATOM    706  CG  LYS A  93     -13.020  39.458  21.071  1.00 56.97           C  
ATOM    707  N   ALA A  94     -15.183  35.722  21.292  1.00 51.60           N  
ATOM    708  CA  ALA A  94     -16.208  34.730  21.593  1.00 52.24           C  
ATOM    709  C   ALA A  94     -15.579  33.344  21.761  1.00 53.31           C  
ATOM    710  O   ALA A  94     -15.806  32.658  22.764  1.00 53.90           O  
ATOM    711  CB  ALA A  94     -17.270  34.726  20.486  1.00 51.15           C  
ATOM    712  N   LYS A  95     -14.743  32.959  20.805  1.00 53.25           N  
ATOM    713  CA  LYS A  95     -14.084  31.665  20.863  1.00 52.77           C  
ATOM    714  C   LYS A  95     -13.045  31.610  21.984  1.00 52.97           C  
ATOM    715  O   LYS A  95     -13.005  30.619  22.698  1.00 55.02           O  
ATOM    716  CB  LYS A  95     -13.451  31.322  19.512  1.00 52.12           C  
ATOM    717  CG  LYS A  95     -12.916  29.885  19.407  1.00 56.43           C  
ATOM    718  CD  LYS A  95     -14.041  28.885  19.224  1.00 54.99           C  
ATOM    719  CE  LYS A  95     -13.723  27.553  19.852  1.00 52.45           C  
ATOM    720  NZ  LYS A  95     -14.937  26.703  19.758  1.00 39.27           N  
ATOM    721  N   LEU A  96     -12.219  32.653  22.148  1.00 52.25           N  
ATOM    722  CA  LEU A  96     -11.205  32.687  23.232  1.00 51.21           C  
ATOM    723  C   LEU A  96     -11.830  32.501  24.598  1.00 51.22           C  
ATOM    724  O   LEU A  96     -11.280  31.792  25.440  1.00 49.13           O  
ATOM    725  CB  LEU A  96     -10.416  34.010  23.258  1.00 51.56           C  
ATOM    726  CG  LEU A  96      -9.169  34.029  24.176  1.00 51.25           C  
ATOM    727  CD1 LEU A  96      -8.036  33.194  23.586  1.00 51.23           C  
ATOM    728  CD2 LEU A  96      -8.686  35.426  24.379  1.00 50.50           C  
ATOM    729  N   ASP A  97     -12.966  33.160  24.814  1.00 52.26           N  
ATOM    730  CA  ASP A  97     -13.729  32.970  26.029  1.00 55.93           C  
ATOM    731  C   ASP A  97     -14.072  31.520  26.276  1.00 55.32           C  
ATOM    732  O   ASP A  97     -13.899  31.017  27.385  1.00 55.39           O  
ATOM    733  CB  ASP A  97     -15.022  33.782  25.991  1.00 59.00           C  
ATOM    734  CG  ASP A  97     -14.793  35.229  26.291  1.00 64.95           C  
ATOM    735  OD1 ASP A  97     -14.308  35.512  27.403  1.00 71.73           O  
ATOM    736  OD2 ASP A  97     -15.097  36.079  25.429  1.00 77.75           O  
ATOM    737  N   GLU A  98     -14.543  30.847  25.238  1.00 55.72           N  
ATOM    738  CA  GLU A  98     -14.887  29.430  25.346  1.00 56.65           C  
ATOM    739  C   GLU A  98     -13.653  28.571  25.722  1.00 51.86           C  
ATOM    740  O   GLU A  98     -13.708  27.732  26.606  1.00 49.74           O  
ATOM    741  CB  GLU A  98     -15.549  28.972  24.039  1.00 57.58           C  
ATOM    742  CG  GLU A  98     -16.316  27.664  24.102  1.00 63.89           C  
ATOM    743  CD  GLU A  98     -16.430  27.032  22.720  1.00 63.70           C  
ATOM    744  OE1 GLU A  98     -17.129  27.629  21.863  1.00 75.48           O  
ATOM    745  OE2 GLU A  98     -15.808  25.959  22.492  1.00 71.67           O  
ATOM    746  N   LEU A  99     -12.514  28.840  25.106  1.00 51.03           N  
ATOM    747  CA  LEU A  99     -11.319  28.028  25.349  1.00 51.05           C  
ATOM    748  C   LEU A  99     -10.529  28.376  26.608  1.00 50.57           C  
ATOM    749  O   LEU A  99      -9.518  27.742  26.875  1.00 51.06           O  
ATOM    750  CB  LEU A  99     -10.375  28.128  24.147  1.00 51.06           C  
ATOM    751  CG  LEU A  99     -10.954  27.878  22.753  1.00 54.77           C  
ATOM    752  CD1 LEU A  99      -9.830  27.984  21.760  1.00 52.84           C  
ATOM    753  CD2 LEU A  99     -11.655  26.537  22.639  1.00 48.97           C  
ATOM    754  N   TRP A 100     -10.951  29.382  27.368  1.00 52.84           N  
ATOM    755  CA  TRP A 100     -10.120  29.919  28.456  1.00 54.82           C  
ATOM    756  C   TRP A 100     -10.206  29.116  29.772  1.00 56.33           C  
ATOM    757  O   TRP A 100     -11.277  28.637  30.175  1.00 55.83           O  
ATOM    758  CB  TRP A 100     -10.487  31.382  28.718  1.00 54.24           C  
ATOM    759  CG  TRP A 100      -9.425  32.218  29.405  1.00 54.87           C  
ATOM    760  CD1 TRP A 100      -9.428  32.654  30.708  1.00 52.78           C  
ATOM    761  CD2 TRP A 100      -8.226  32.751  28.810  1.00 49.12           C  
ATOM    762  NE1 TRP A 100      -8.305  33.413  30.956  1.00 52.63           N  
ATOM    763  CE2 TRP A 100      -7.560  33.494  29.805  1.00 53.06           C  
ATOM    764  CE3 TRP A 100      -7.654  32.661  27.542  1.00 51.70           C  
ATOM    765  CZ2 TRP A 100      -6.356  34.147  29.563  1.00 54.97           C  
ATOM    766  CZ3 TRP A 100      -6.450  33.307  27.306  1.00 54.69           C  
ATOM    767  CH2 TRP A 100      -5.815  34.035  28.312  1.00 55.39           C  
ATOM    768  N   SER A 101      -9.061  29.046  30.446  1.00 59.18           N  
ATOM    769  CA  SER A 101      -8.824  28.214  31.618  1.00 61.69           C  
ATOM    770  C   SER A 101      -8.093  29.068  32.601  1.00 61.66           C  
ATOM    771  O   SER A 101      -7.512  30.078  32.222  1.00 62.29           O  
ATOM    772  CB  SER A 101      -7.858  27.065  31.305  1.00 62.66           C  
ATOM    773  OG  SER A 101      -8.400  26.146  30.373  1.00 70.61           O  
ATOM    774  N   PRO A 102      -8.040  28.637  33.854  1.00 62.30           N  
ATOM    775  CA  PRO A 102      -7.114  29.311  34.776  1.00 64.04           C  
ATOM    776  C   PRO A 102      -5.593  29.152  34.491  1.00 63.44           C  
ATOM    777  O   PRO A 102      -4.788  29.889  35.072  1.00 59.27           O  
ATOM    778  CB  PRO A 102      -7.485  28.709  36.139  1.00 63.62           C  
ATOM    779  CG  PRO A 102      -8.841  28.033  35.925  1.00 64.44           C  
ATOM    780  CD  PRO A 102      -8.835  27.589  34.520  1.00 62.41           C  
ATOM    781  N   VAL A 103      -5.202  28.217  33.624  1.00 65.88           N  
ATOM    782  CA  VAL A 103      -3.777  28.066  33.278  1.00 67.83           C  
ATOM    783  C   VAL A 103      -3.289  29.329  32.543  1.00 69.81           C  
ATOM    784  O   VAL A 103      -2.313  29.992  32.946  1.00 71.12           O  
ATOM    785  CB  VAL A 103      -3.491  26.862  32.360  1.00 68.87           C  
ATOM    786  CG1 VAL A 103      -2.009  26.497  32.512  1.00 69.62           C  
ATOM    787  CG2 VAL A 103      -4.454  25.649  32.634  1.00 65.88           C  
ATOM    788  N   TYR A 104      -4.035  29.670  31.496  1.00 68.38           N  
ATOM    789  CA  TYR A 104      -3.756  30.821  30.659  1.00 66.56           C  
ATOM    790  C   TYR A 104      -3.847  32.145  31.386  1.00 68.96           C  
ATOM    791  O   TYR A 104      -3.101  33.065  31.072  1.00 70.51           O  
ATOM    792  CB  TYR A 104      -4.767  30.895  29.546  1.00 64.72           C  
ATOM    793  CG  TYR A 104      -4.834  29.678  28.704  1.00 60.08           C  
ATOM    794  CD1 TYR A 104      -3.779  29.319  27.909  1.00 60.86           C  
ATOM    795  CD2 TYR A 104      -5.961  28.896  28.687  1.00 63.18           C  
ATOM    796  CE1 TYR A 104      -3.846  28.198  27.117  1.00 66.61           C  
ATOM    797  CE2 TYR A 104      -6.044  27.777  27.901  1.00 66.89           C  
ATOM    798  CZ  TYR A 104      -4.973  27.427  27.119  1.00 67.89           C  
ATOM    799  OH  TYR A 104      -5.029  26.316  26.308  1.00 67.97           O  
ATOM    800  N   SER A 105      -4.789  32.271  32.317  1.00 70.04           N  
ATOM    801  CA  SER A 105      -4.912  33.515  33.069  1.00 71.63           C  
ATOM    802  C   SER A 105      -3.570  33.775  33.779  1.00 74.50           C  
ATOM    803  O   SER A 105      -3.141  34.929  33.890  1.00 74.85           O  
ATOM    804  CB  SER A 105      -6.103  33.509  34.055  1.00 70.20           C  
ATOM    805  OG  SER A 105      -6.667  34.813  34.162  1.00 63.16           O  
ATOM    806  N   ALA A 106      -2.893  32.704  34.203  1.00 76.40           N  
ATOM    807  CA  ALA A 106      -1.547  32.812  34.764  1.00 77.37           C  
ATOM    808  C   ALA A 106      -0.560  33.376  33.741  1.00 76.56           C  
ATOM    809  O   ALA A 106      -0.183  34.544  33.835  1.00 74.79           O  
ATOM    810  CB  ALA A 106      -1.058  31.448  35.298  1.00 78.32           C  
ATOM    811  N   PHE A 107      -0.175  32.580  32.745  1.00 76.70           N  
ATOM    812  CA  PHE A 107       0.965  32.959  31.898  1.00 76.38           C  
ATOM    813  C   PHE A 107       0.571  33.871  30.665  1.00 75.24           C  
ATOM    814  O   PHE A 107       0.836  33.531  29.512  1.00 77.82           O  
ATOM    815  CB  PHE A 107       1.715  31.725  31.387  1.00 80.44           C  
ATOM    816  CG  PHE A 107       1.954  30.595  32.391  1.00 87.66           C  
ATOM    817  CD1 PHE A 107       1.917  30.789  33.782  1.00 91.25           C  
ATOM    818  CD2 PHE A 107       2.260  29.299  31.903  1.00 89.82           C  
ATOM    819  CE1 PHE A 107       2.137  29.720  34.654  1.00 87.67           C  
ATOM    820  CE2 PHE A 107       2.477  28.248  32.759  1.00 88.79           C  
ATOM    821  CZ  PHE A 107       2.411  28.456  34.139  1.00 88.41           C  
ATOM    822  N   PHE A 108      -0.076  35.003  30.927  1.00 68.82           N  
ATOM    823  CA  PHE A 108      -0.404  36.001  29.932  1.00 65.91           C  
ATOM    824  C   PHE A 108      -0.723  37.213  30.769  1.00 62.80           C  
ATOM    825  O   PHE A 108      -1.837  37.308  31.298  1.00 62.30           O  
ATOM    826  CB  PHE A 108      -1.663  35.655  29.127  1.00 63.65           C  
ATOM    827  CG  PHE A 108      -1.408  34.954  27.813  1.00 63.01           C  
ATOM    828  CD1 PHE A 108      -0.596  35.528  26.836  1.00 58.25           C  
ATOM    829  CD2 PHE A 108      -2.030  33.744  27.527  1.00 61.39           C  
ATOM    830  CE1 PHE A 108      -0.382  34.892  25.633  1.00 61.46           C  
ATOM    831  CE2 PHE A 108      -1.836  33.118  26.319  1.00 58.47           C  
ATOM    832  CZ  PHE A 108      -1.009  33.690  25.368  1.00 61.18           C  
ATOM    833  N   ALA A 109       0.245  38.126  30.883  1.00 60.21           N  
ATOM    834  CA  ALA A 109       0.204  39.271  31.821  1.00 57.89           C  
ATOM    835  C   ALA A 109      -1.118  40.046  31.888  1.00 56.73           C  
ATOM    836  O   ALA A 109      -1.537  40.454  32.958  1.00 57.23           O  
ATOM    837  CB  ALA A 109       1.359  40.244  31.503  1.00 56.57           C  
ATOM    838  N   ASN A 110      -1.763  40.251  30.741  1.00 56.21           N  
ATOM    839  CA  ASN A 110      -2.987  41.051  30.644  1.00 54.52           C  
ATOM    840  C   ASN A 110      -4.245  40.213  30.366  1.00 52.29           C  
ATOM    841  O   ASN A 110      -5.239  40.737  29.882  1.00 51.45           O  
ATOM    842  CB  ASN A 110      -2.795  42.140  29.572  1.00 55.35           C  
ATOM    843  CG  ASN A 110      -1.787  43.205  29.993  1.00 51.50           C  
ATOM    844  OD1 ASN A 110      -2.165  44.276  30.425  1.00 56.30           O  
ATOM    845  ND2 ASN A 110      -0.516  42.910  29.863  1.00 50.99           N  
ATOM    846  N   GLY A 111      -4.198  38.921  30.682  1.00 52.83           N  
ATOM    847  CA  GLY A 111      -5.363  38.034  30.570  1.00 54.66           C  
ATOM    848  C   GLY A 111      -5.924  37.895  29.160  1.00 55.57           C  
ATOM    849  O   GLY A 111      -5.166  37.871  28.181  1.00 56.56           O  
ATOM    850  N   LYS A 112      -7.250  37.827  29.051  1.00 54.08           N  
ATOM    851  CA  LYS A 112      -7.917  37.662  27.759  1.00 53.38           C  
ATOM    852  C   LYS A 112      -7.682  38.833  26.790  1.00 53.50           C  
ATOM    853  O   LYS A 112      -7.846  38.659  25.570  1.00 55.49           O  
ATOM    854  CB  LYS A 112      -9.432  37.453  27.932  1.00 53.78           C  
ATOM    855  CG  LYS A 112      -9.887  36.174  28.650  1.00 53.04           C  
ATOM    856  CD  LYS A 112     -11.427  36.058  28.582  1.00 54.82           C  
ATOM    857  CE  LYS A 112     -12.043  35.105  29.628  1.00 57.55           C  
ATOM    858  NZ  LYS A 112     -12.833  35.799  30.706  1.00 71.36           N  
ATOM    859  N   GLU A 113      -7.286  40.008  27.300  1.00 52.24           N  
ATOM    860  CA  GLU A 113      -6.977  41.154  26.423  1.00 52.64           C  
ATOM    861  C   GLU A 113      -5.496  41.245  26.015  1.00 49.72           C  
ATOM    862  O   GLU A 113      -5.096  42.173  25.323  1.00 48.58           O  
ATOM    863  CB  GLU A 113      -7.441  42.466  27.060  1.00 54.11           C  
ATOM    864  CG  GLU A 113      -8.942  42.503  27.407  1.00 62.89           C  
ATOM    865  CD  GLU A 113      -9.285  41.937  28.796  1.00 75.18           C  
ATOM    866  OE1 GLU A 113      -8.383  41.483  29.546  1.00 79.17           O  
ATOM    867  OE2 GLU A 113     -10.487  41.941  29.138  1.00 83.97           O  
ATOM    868  N   ASP A 114      -4.690  40.268  26.401  1.00 48.45           N  
ATOM    869  CA  ASP A 114      -3.269  40.325  26.144  1.00 47.15           C  
ATOM    870  C   ASP A 114      -2.973  40.264  24.653  1.00 45.88           C  
ATOM    871  O   ASP A 114      -3.425  39.369  23.952  1.00 45.60           O  
ATOM    872  CB  ASP A 114      -2.563  39.185  26.857  1.00 48.11           C  
ATOM    873  CG  ASP A 114      -1.103  39.457  27.075  1.00 48.38           C  
ATOM    874  OD1 ASP A 114      -0.316  39.406  26.097  1.00 43.31           O  
ATOM    875  OD2 ASP A 114      -0.750  39.713  28.245  1.00 50.43           O  
ATOM    876  N   ALA A 115      -2.172  41.229  24.201  1.00 46.43           N  
ATOM    877  CA  ALA A 115      -1.786  41.419  22.795  1.00 42.90           C  
ATOM    878  C   ALA A 115      -1.049  40.245  22.210  1.00 43.81           C  
ATOM    879  O   ALA A 115      -1.031  40.076  20.998  1.00 48.04           O  
ATOM    880  CB  ALA A 115      -0.929  42.697  22.658  1.00 38.54           C  
ATOM    881  N   ASN A 116      -0.429  39.433  23.050  1.00 45.03           N  
ATOM    882  CA  ASN A 116       0.315  38.284  22.560  1.00 47.21           C  
ATOM    883  C   ASN A 116      -0.519  37.047  22.248  1.00 44.97           C  
ATOM    884  O   ASN A 116       0.002  36.097  21.663  1.00 43.43           O  
ATOM    885  CB  ASN A 116       1.393  37.899  23.557  1.00 48.44           C  
ATOM    886  CG  ASN A 116       2.733  38.295  23.109  1.00 54.16           C  
ATOM    887  OD1 ASN A 116       3.373  37.583  22.311  1.00 64.27           O  
ATOM    888  ND2 ASN A 116       3.202  39.447  23.619  1.00 50.44           N  
ATOM    889  N   ILE A 117      -1.786  37.043  22.656  1.00 42.87           N  
ATOM    890  CA  ILE A 117      -2.618  35.869  22.448  1.00 43.36           C  
ATOM    891  C   ILE A 117      -2.806  35.653  20.976  1.00 41.32           C  
ATOM    892  O   ILE A 117      -3.067  36.591  20.264  1.00 40.17           O  
ATOM    893  CB  ILE A 117      -3.998  36.033  23.120  1.00 44.54           C  
ATOM    894  CG1 ILE A 117      -3.862  35.886  24.653  1.00 46.52           C  
ATOM    895  CG2 ILE A 117      -4.986  35.012  22.550  1.00 42.80           C  
ATOM    896  CD1 ILE A 117      -5.075  36.378  25.398  1.00 46.27           C  
ATOM    897  N   GLN A 118      -2.675  34.419  20.505  1.00 45.53           N  
ATOM    898  CA  GLN A 118      -3.044  34.099  19.118  1.00 44.61           C  
ATOM    899  C   GLN A 118      -3.726  32.750  19.067  1.00 46.90           C  
ATOM    900  O   GLN A 118      -3.100  31.722  19.331  1.00 46.98           O  
ATOM    901  CB  GLN A 118      -1.816  34.094  18.206  1.00 43.14           C  
ATOM    902  CG  GLN A 118      -2.106  33.721  16.765  1.00 45.86           C  
ATOM    903  CD  GLN A 118      -3.033  34.719  16.126  1.00 43.59           C  
ATOM    904  OE1 GLN A 118      -2.626  35.840  15.853  1.00 45.40           O  
ATOM    905  NE2 GLN A 118      -4.303  34.340  15.924  1.00 52.57           N  
ATOM    906  N   LEU A 119      -5.016  32.753  18.737  1.00 50.50           N  
ATOM    907  CA  LEU A 119      -5.748  31.517  18.553  1.00 49.82           C  
ATOM    908  C   LEU A 119      -5.217  30.909  17.270  1.00 49.84           C  
ATOM    909  O   LEU A 119      -4.946  31.632  16.329  1.00 52.58           O  
ATOM    910  CB  LEU A 119      -7.230  31.798  18.391  1.00 51.84           C  
ATOM    911  CG  LEU A 119      -8.056  32.284  19.566  1.00 46.72           C  
ATOM    912  CD1 LEU A 119      -9.462  32.574  19.091  1.00 45.76           C  
ATOM    913  CD2 LEU A 119      -8.080  31.229  20.633  1.00 55.09           C  
ATOM    914  N   ILE A 120      -5.049  29.594  17.264  1.00 48.71           N  
ATOM    915  CA  ILE A 120      -4.724  28.828  16.075  1.00 47.90           C  
ATOM    916  C   ILE A 120      -5.834  27.806  15.823  1.00 47.59           C  
ATOM    917  O   ILE A 120      -6.112  26.950  16.653  1.00 45.71           O  
ATOM    918  CB  ILE A 120      -3.419  28.060  16.246  1.00 50.98           C  
ATOM    919  CG1 ILE A 120      -2.255  29.022  16.509  1.00 53.61           C  
ATOM    920  CG2 ILE A 120      -3.133  27.228  15.010  1.00 47.02           C  
ATOM    921  CD1 ILE A 120      -0.998  28.324  16.925  1.00 43.13           C  
ATOM    922  N   LYS A 121      -6.467  27.905  14.665  1.00 50.25           N  
ATOM    923  CA  LYS A 121      -7.509  26.969  14.263  1.00 49.10           C  
ATOM    924  C   LYS A 121      -6.907  26.074  13.236  1.00 48.90           C  
ATOM    925  O   LYS A 121      -6.498  26.557  12.187  1.00 51.03           O  
ATOM    926  CB  LYS A 121      -8.667  27.719  13.646  1.00 47.47           C  
ATOM    927  CG  LYS A 121      -9.917  26.892  13.407  1.00 50.39           C  
ATOM    928  CD  LYS A 121     -10.884  27.701  12.560  1.00 47.10           C  
ATOM    929  CE  LYS A 121     -12.195  26.996  12.359  1.00 49.75           C  
ATOM    930  NZ  LYS A 121     -13.068  27.749  11.405  1.00 54.55           N  
ATOM    931  N   VAL A 122      -6.819  24.779  13.525  1.00 49.78           N  
ATOM    932  CA  VAL A 122      -6.442  23.804  12.487  1.00 48.26           C  
ATOM    933  C   VAL A 122      -7.681  23.163  11.873  1.00 46.90           C  
ATOM    934  O   VAL A 122      -8.558  22.648  12.579  1.00 45.27           O  
ATOM    935  CB  VAL A 122      -5.510  22.754  13.032  1.00 48.81           C  
ATOM    936  CG1 VAL A 122      -5.186  21.741  11.940  1.00 46.37           C  
ATOM    937  CG2 VAL A 122      -4.251  23.444  13.562  1.00 42.63           C  
ATOM    938  N   VAL A 123      -7.779  23.255  10.552  1.00 47.81           N  
ATOM    939  CA  VAL A 123      -8.846  22.589   9.807  1.00 46.00           C  
ATOM    940  C   VAL A 123      -8.203  21.346   9.163  1.00 46.91           C  
ATOM    941  O   VAL A 123      -7.543  21.481   8.146  1.00 47.02           O  
ATOM    942  CB  VAL A 123      -9.501  23.527   8.729  1.00 45.80           C  
ATOM    943  CG1 VAL A 123     -10.585  22.773   7.917  1.00 24.92           C  
ATOM    944  CG2 VAL A 123     -10.084  24.769   9.379  1.00 42.61           C  
ATOM    945  N   PRO A 124      -8.354  20.149   9.785  1.00 47.17           N  
ATOM    946  CA  PRO A 124      -7.848  18.936   9.161  1.00 45.29           C  
ATOM    947  C   PRO A 124      -8.526  18.613   7.862  1.00 42.81           C  
ATOM    948  O   PRO A 124      -9.718  18.896   7.702  1.00 43.57           O  
ATOM    949  CB  PRO A 124      -8.229  17.835  10.151  1.00 47.47           C  
ATOM    950  CG  PRO A 124      -9.284  18.418  10.996  1.00 47.05           C  
ATOM    951  CD  PRO A 124      -8.949  19.846  11.101  1.00 48.00           C  
ATOM    952  N   HIS A 125      -7.740  18.055   6.944  1.00 38.46           N  
ATOM    953  CA  HIS A 125      -8.234  17.484   5.723  1.00 35.97           C  
ATOM    954  C   HIS A 125      -7.851  16.021   5.571  1.00 35.92           C  
ATOM    955  O   HIS A 125      -8.442  15.332   4.770  1.00 36.34           O  
ATOM    956  CB  HIS A 125      -7.772  18.304   4.517  1.00 36.50           C  
ATOM    957  CG  HIS A 125      -6.287  18.498   4.419  1.00 39.88           C  
ATOM    958  ND1 HIS A 125      -5.434  17.512   3.981  1.00 39.71           N  
ATOM    959  CD2 HIS A 125      -5.510  19.579   4.672  1.00 47.20           C  
ATOM    960  CE1 HIS A 125      -4.196  17.971   3.976  1.00 43.18           C  
ATOM    961  NE2 HIS A 125      -4.214  19.227   4.380  1.00 41.38           N  
ATOM    962  N   GLY A 126      -6.878  15.535   6.340  1.00 36.69           N  
ATOM    963  CA  GLY A 126      -6.626  14.097   6.432  1.00 36.32           C  
ATOM    964  C   GLY A 126      -6.130  13.676   7.796  1.00 34.90           C  
ATOM    965  O   GLY A 126      -5.403  14.422   8.451  1.00 38.02           O  
ATOM    966  N   VAL A 127      -6.522  12.476   8.212  1.00 36.17           N  
ATOM    967  CA  VAL A 127      -6.095  11.866   9.470  1.00 38.83           C  
ATOM    968  C   VAL A 127      -5.697  10.426   9.225  1.00 38.80           C  
ATOM    969  O   VAL A 127      -6.438   9.696   8.638  1.00 38.97           O  
ATOM    970  CB  VAL A 127      -7.197  11.894  10.536  1.00 40.25           C  
ATOM    971  CG1 VAL A 127      -6.685  11.256  11.846  1.00 41.52           C  
ATOM    972  CG2 VAL A 127      -7.612  13.348  10.785  1.00 40.44           C  
ATOM    973  N   GLU A 128      -4.489  10.046   9.633  1.00 42.28           N  
ATOM    974  CA  GLU A 128      -4.085   8.650   9.701  1.00 41.80           C  
ATOM    975  C   GLU A 128      -3.812   8.342  11.147  1.00 40.35           C  
ATOM    976  O   GLU A 128      -3.421   9.227  11.916  1.00 41.92           O  
ATOM    977  CB  GLU A 128      -2.838   8.372   8.882  1.00 43.36           C  
ATOM    978  CG  GLU A 128      -2.993   8.627   7.371  1.00 55.33           C  
ATOM    979  CD  GLU A 128      -4.031   7.737   6.685  1.00 66.15           C  
ATOM    980  OE1 GLU A 128      -3.927   6.494   6.804  1.00 69.44           O  
ATOM    981  OE2 GLU A 128      -4.943   8.297   6.022  1.00 69.15           O  
ATOM    982  N   CYS A 129      -4.047   7.091  11.516  1.00 38.75           N  
ATOM    983  CA  CYS A 129      -3.777   6.632  12.841  1.00 41.00           C  
ATOM    984  C   CYS A 129      -3.400   5.147  12.869  1.00 38.37           C  
ATOM    985  O   CYS A 129      -3.647   4.422  11.921  1.00 37.67           O  
ATOM    986  CB  CYS A 129      -4.975   6.927  13.722  1.00 42.72           C  
ATOM    987  SG  CYS A 129      -6.365   5.891  13.295  1.00 56.07           S  
ATOM    988  N   TRP A 130      -2.740   4.738  13.954  1.00 39.47           N  
ATOM    989  CA  TRP A 130      -2.224   3.375  14.139  1.00 38.77           C  
ATOM    990  C   TRP A 130      -2.599   3.056  15.560  1.00 42.57           C  
ATOM    991  O   TRP A 130      -1.930   3.513  16.495  1.00 42.95           O  
ATOM    992  CB  TRP A 130      -0.698   3.333  13.990  1.00 36.41           C  
ATOM    993  CG  TRP A 130      -0.215   3.742  12.642  1.00 34.60           C  
ATOM    994  CD1 TRP A 130       0.132   2.914  11.612  1.00 33.24           C  
ATOM    995  CD2 TRP A 130      -0.040   5.096  12.151  1.00 31.36           C  
ATOM    996  NE1 TRP A 130       0.503   3.666  10.504  1.00 33.15           N  
ATOM    997  CE2 TRP A 130       0.420   5.002  10.817  1.00 28.65           C  
ATOM    998  CE3 TRP A 130      -0.227   6.364  12.712  1.00 31.24           C  
ATOM    999  CZ2 TRP A 130       0.693   6.124  10.043  1.00 28.49           C  
ATOM   1000  CZ3 TRP A 130       0.053   7.484  11.949  1.00 33.78           C  
ATOM   1001  CH2 TRP A 130       0.508   7.358  10.630  1.00 36.46           C  
ATOM   1002  N   LEU A 131      -3.707   2.333  15.723  1.00 45.90           N  
ATOM   1003  CA  LEU A 131      -4.268   2.058  17.045  1.00 48.63           C  
ATOM   1004  C   LEU A 131      -4.005   0.602  17.384  1.00 52.24           C  
ATOM   1005  O   LEU A 131      -3.729  -0.226  16.492  1.00 53.77           O  
ATOM   1006  CB  LEU A 131      -5.769   2.374  17.077  1.00 47.30           C  
ATOM   1007  CG  LEU A 131      -6.208   3.769  16.571  1.00 49.60           C  
ATOM   1008  CD1 LEU A 131      -7.625   4.130  17.036  1.00 47.22           C  
ATOM   1009  CD2 LEU A 131      -5.251   4.881  16.968  1.00 41.75           C  
ATOM   1010  N   SER A 132      -4.030   0.307  18.679  1.00 54.85           N  
ATOM   1011  CA  SER A 132      -3.947  -1.065  19.166  1.00 56.26           C  
ATOM   1012  C   SER A 132      -5.091  -1.184  20.150  1.00 55.65           C  
ATOM   1013  O   SER A 132      -5.377  -0.216  20.856  1.00 54.90           O  
ATOM   1014  CB  SER A 132      -2.613  -1.320  19.875  1.00 57.20           C  
ATOM   1015  OG  SER A 132      -1.499  -0.911  19.086  1.00 59.11           O  
ATOM   1016  N   GLY A 133      -5.763  -2.328  20.220  1.00 56.03           N  
ATOM   1017  CA  GLY A 133      -5.482  -3.508  19.432  1.00 55.51           C  
ATOM   1018  C   GLY A 133      -6.376  -4.580  19.998  1.00 56.18           C  
ATOM   1019  O   GLY A 133      -7.577  -4.588  19.747  1.00 57.95           O  
TER    1020      GLY A 133                                                      
END
MOLECULE T0402.pdb
ATOM    891  N   GLU     4     -17.272   4.676  13.528  1.00 42.38           N  
ATOM    892  CA  GLU     4     -16.568   4.393  14.819  1.00 41.19           C  
ATOM    893  C   GLU     4     -15.129   4.921  14.732  1.00 39.47           C  
ATOM    894  O   GLU     4     -14.418   5.029  15.752  1.00 37.31           O  
ATOM    895  CB  GLU     4     -16.579   2.885  15.144  1.00 41.11           C  
ATOM    896  CG  GLU     4     -15.897   2.013  14.106  1.00 39.34           C  
ATOM    897  N   LEU     5     -14.709   5.212  13.498  1.00 37.46           N  
ATOM    898  CA  LEU     5     -13.373   5.756  13.253  1.00 36.64           C  
ATOM    899  C   LEU     5     -13.270   7.119  13.922  1.00 34.39           C  
ATOM    900  O   LEU     5     -12.259   7.374  14.576  1.00 31.86           O  
ATOM    901  CB  LEU     5     -13.041   5.842  11.755  1.00 35.60           C  
ATOM    902  CG  LEU     5     -11.673   6.420  11.371  1.00 36.47           C  
ATOM    903  CD1 LEU     5     -10.569   5.783  12.155  1.00 37.02           C  
ATOM    904  CD2 LEU     5     -11.414   6.277   9.874  1.00 39.29           C  
ATOM    905  N   GLU     6     -14.305   7.972  13.775  1.00 34.67           N  
ATOM    906  CA  GLU     6     -14.280   9.313  14.409  1.00 35.57           C  
ATOM    907  C   GLU     6     -14.207   9.044  15.877  1.00 34.45           C  
ATOM    908  O   GLU     6     -13.529   9.753  16.596  1.00 36.01           O  
ATOM    909  CB  GLU     6     -15.568  10.169  14.314  1.00 37.20           C  
ATOM    910  CG  GLU     6     -16.228  10.447  13.005  1.00 44.92           C  
ATOM    911  CD  GLU     6     -15.278  10.933  12.002  1.00 51.63           C  
ATOM    912  OE1 GLU     6     -14.242  10.254  11.920  1.00 53.06           O  
ATOM    913  OE2 GLU     6     -15.580  11.931  11.294  1.00 55.13           O  
ATOM    914  N   ASP     7     -15.017   8.079  16.321  1.00 33.33           N  
ATOM    915  CA  ASP     7     -15.104   7.792  17.745  1.00 32.02           C  
ATOM    916  C   ASP     7     -13.745   7.451  18.271  1.00 28.94           C  
ATOM    917  O   ASP     7     -13.370   7.930  19.313  1.00 29.46           O  
ATOM    918  CB  ASP     7     -16.148   6.720  18.074  1.00 35.52           C  
ATOM    919  CG  ASP     7     -17.577   7.284  18.071  1.00 34.61           C  
ATOM    920  OD1 ASP     7     -17.718   8.522  17.995  1.00 47.65           O  
ATOM    921  OD2 ASP     7     -18.537   6.494  18.159  1.00 44.63           O  
ATOM    922  N   LYS     8     -12.953   6.719  17.499  1.00 28.43           N  
ATOM    923  CA  LYS     8     -11.595   6.371  17.956  1.00 28.59           C  
ATOM    924  C   LYS     8     -10.671   7.595  17.906  1.00 26.95           C  
ATOM    925  O   LYS     8      -9.827   7.799  18.761  1.00 27.30           O  
ATOM    926  CB  LYS     8     -11.017   5.169  17.162  1.00 29.46           C  
ATOM    927  N   ILE     9     -10.860   8.428  16.897  1.00 29.92           N  
ATOM    928  CA  ILE     9     -10.058   9.646  16.759  1.00 24.61           C  
ATOM    929  C   ILE     9     -10.353  10.515  17.961  1.00 25.27           C  
ATOM    930  O   ILE     9      -9.442  10.992  18.630  1.00 26.29           O  
ATOM    931  CB  ILE     9     -10.347  10.365  15.425  1.00 25.78           C  
ATOM    932  CG1 ILE     9      -9.843   9.544  14.266  1.00 23.30           C  
ATOM    933  CG2 ILE     9      -9.667  11.769  15.331  1.00 23.82           C  
ATOM    934  CD1 ILE     9     -10.406   9.932  12.926  1.00 25.41           C  
ATOM    935  N   LEU    10     -11.639  10.687  18.283  1.00 25.00           N  
ATOM    936  CA  LEU    10     -12.032  11.569  19.391  1.00 24.56           C  
ATOM    937  C   LEU    10     -11.529  11.095  20.721  1.00 23.92           C  
ATOM    938  O   LEU    10     -11.132  11.896  21.587  1.00 26.43           O  
ATOM    939  CB  LEU    10     -13.554  11.749  19.433  1.00 28.23           C  
ATOM    940  CG  LEU    10     -14.079  12.624  18.318  1.00 33.38           C  
ATOM    941  CD1 LEU    10     -15.593  12.512  18.157  1.00 34.45           C  
ATOM    942  CD2 LEU    10     -13.658  14.053  18.655  1.00 30.00           C  
ATOM    943  N   ALA    11     -11.521   9.776  20.889  1.00 27.09           N  
ATOM    944  CA  ALA    11     -11.074   9.165  22.143  1.00 27.06           C  
ATOM    945  C   ALA    11      -9.604   9.533  22.363  1.00 29.21           C  
ATOM    946  O   ALA    11      -9.195   9.934  23.460  1.00 31.11           O  
ATOM    947  CB  ALA    11     -11.282   7.610  22.115  1.00 29.17           C  
ATOM    948  N   ILE    12      -8.820   9.481  21.288  1.00 25.92           N  
ATOM    949  CA  ILE    12      -7.401   9.770  21.407  1.00 25.02           C  
ATOM    950  C   ILE    12      -7.223  11.290  21.738  1.00 27.97           C  
ATOM    951  O   ILE    12      -6.411  11.669  22.601  1.00 30.55           O  
ATOM    952  CB  ILE    12      -6.642   9.389  20.142  1.00 24.32           C  
ATOM    953  CG1 ILE    12      -6.626   7.866  19.899  1.00 28.56           C  
ATOM    954  CG2 ILE    12      -5.214   9.899  20.248  1.00 24.77           C  
ATOM    955  CD1 ILE    12      -6.018   7.449  18.563  1.00 27.21           C  
ATOM    956  N   LEU    13      -8.028  12.132  21.084  1.00 24.76           N  
ATOM    957  CA  LEU    13      -7.991  13.585  21.342  1.00 26.43           C  
ATOM    958  C   LEU    13      -8.484  13.900  22.755  1.00 27.50           C  
ATOM    959  O   LEU    13      -8.014  14.833  23.371  1.00 29.87           O  
ATOM    960  CB  LEU    13      -8.853  14.385  20.332  1.00 23.89           C  
ATOM    961  CG  LEU    13      -8.371  14.385  18.875  1.00 19.63           C  
ATOM    962  CD1 LEU    13      -9.317  15.119  17.935  1.00 22.84           C  
ATOM    963  CD2 LEU    13      -6.905  14.962  18.813  1.00 19.00           C  
ATOM    964  N   GLU    14      -9.430  13.123  23.270  1.00 25.13           N  
ATOM    965  CA  GLU    14      -9.968  13.437  24.582  1.00 30.44           C  
ATOM    966  C   GLU    14      -8.977  13.129  25.674  1.00 31.51           C  
ATOM    967  O   GLU    14      -8.949  13.800  26.711  1.00 35.14           O  
ATOM    968  CB  GLU    14     -11.298  12.700  24.820  1.00 31.33           C  
ATOM    969  CG  GLU    14     -12.354  13.066  23.791  1.00 34.80           C  
ATOM    970  CD  GLU    14     -13.585  12.222  23.868  1.00 40.92           C  
ATOM    971  OE1 GLU    14     -13.509  11.127  24.465  1.00 47.22           O  
ATOM    972  OE2 GLU    14     -14.621  12.634  23.291  1.00 47.24           O  
ATOM    973  N   GLN    15      -8.111  12.165  25.395  1.00 30.42           N  
ATOM    974  CA  GLN    15      -7.152  11.690  26.363  1.00 30.22           C  
ATOM    975  C   GLN    15      -5.791  12.293  26.251  1.00 31.37           C  
ATOM    976  O   GLN    15      -4.941  12.006  27.061  1.00 29.45           O  
ATOM    977  CB  GLN    15      -7.084  10.182  26.251  1.00 32.12           C  
ATOM    978  CG  GLN    15      -8.453   9.576  26.520  1.00 40.22           C  
ATOM    979  CD  GLN    15      -8.669   8.270  25.798  1.00 49.99           C  
ATOM    980  OE1 GLN    15      -7.713   7.647  25.335  1.00 59.08           O  
ATOM    981  NE2 GLN    15      -9.935   7.861  25.663  1.00 53.52           N  
ATOM    982  N   HIS    16      -5.573  13.155  25.256  1.00 30.45           N  
ATOM    983  CA  HIS    16      -4.253  13.783  25.084  1.00 31.78           C  
ATOM    984  C   HIS    16      -4.358  15.267  24.743  1.00 32.34           C  
ATOM    985  O   HIS    16      -5.080  15.665  23.852  1.00 35.60           O  
ATOM    986  CB  HIS    16      -3.438  13.094  23.977  1.00 30.41           C  
ATOM    987  CG  HIS    16      -3.245  11.640  24.206  1.00 28.32           C  
ATOM    988  ND1 HIS    16      -4.194  10.700  23.867  1.00 29.60           N  
ATOM    989  CD2 HIS    16      -2.236  10.964  24.790  1.00 25.56           C  
ATOM    990  CE1 HIS    16      -3.764   9.504  24.220  1.00 22.95           C  
ATOM    991  NE2 HIS    16      -2.582   9.637  24.787  1.00 25.21           N  
ATOM    992  N   GLN    17      -3.587  16.059  25.457  1.00 29.66           N  
ATOM    993  CA  GLN    17      -3.560  17.475  25.246  1.00 31.81           C  
ATOM    994  C   GLN    17      -2.163  17.938  24.808  1.00 33.52           C  
ATOM    995  O   GLN    17      -1.966  19.118  24.576  1.00 38.12           O  
ATOM    996  CB  GLN    17      -3.950  18.219  26.500  1.00 31.34           C  
ATOM    997  CG  GLN    17      -5.454  18.319  26.714  1.00 45.87           C  
ATOM    998  CD  GLN    17      -5.808  19.275  27.862  1.00 52.08           C  
ATOM    999  OE1 GLN    17      -4.943  19.675  28.645  1.00 54.96           O  
ATOM   1000  NE2 GLN    17      -7.085  19.632  27.964  1.00 47.07           N  
ATOM   1001  N   VAL    18      -1.187  17.036  24.784  1.00 31.15           N  
ATOM   1002  CA  VAL    18       0.139  17.405  24.279  1.00 29.14           C  
ATOM   1003  C   VAL    18       0.388  16.655  22.972  1.00 28.20           C  
ATOM   1004  O   VAL    18       0.133  15.457  22.858  1.00 28.91           O  
ATOM   1005  CB  VAL    18       1.280  17.118  25.286  1.00 30.69           C  
ATOM   1006  CG1 VAL    18       2.643  17.446  24.687  1.00 24.44           C  
ATOM   1007  CG2 VAL    18       1.092  17.868  26.582  1.00 31.96           C  
ATOM   1008  N   GLY    19       0.886  17.368  21.984  1.00 24.76           N  
ATOM   1009  CA  GLY    19       1.212  16.763  20.719  1.00 24.21           C  
ATOM   1010  C   GLY    19       2.391  17.474  20.138  1.00 24.11           C  
ATOM   1011  O   GLY    19       2.929  18.421  20.740  1.00 21.18           O  
ATOM   1012  N   VAL    20       2.785  17.018  18.961  1.00 22.91           N  
ATOM   1013  CA  VAL    20       3.893  17.612  18.213  1.00 25.08           C  
ATOM   1014  C   VAL    20       3.316  18.383  17.013  1.00 25.01           C  
ATOM   1015  O   VAL    20       2.585  17.824  16.208  1.00 23.67           O  
ATOM   1016  CB  VAL    20       4.898  16.486  17.708  1.00 28.01           C  
ATOM   1017  CG1 VAL    20       6.032  17.064  16.888  1.00 22.46           C  
ATOM   1018  CG2 VAL    20       5.472  15.657  18.879  1.00 22.38           C  
ATOM   1019  N   LEU    21       3.592  19.678  16.923  1.00 21.88           N  
ATOM   1020  CA  LEU    21       3.210  20.429  15.755  1.00 22.34           C  
ATOM   1021  C   LEU    21       4.419  20.533  14.843  1.00 23.69           C  
ATOM   1022  O   LEU    21       5.484  20.928  15.299  1.00 22.74           O  
ATOM   1023  CB  LEU    21       2.844  21.879  16.097  1.00 24.83           C  
ATOM   1024  CG  LEU    21       2.461  22.649  14.818  1.00 26.96           C  
ATOM   1025  CD1 LEU    21       1.037  22.263  14.304  1.00 20.26           C  
ATOM   1026  CD2 LEU    21       2.556  24.085  15.092  1.00 27.07           C  
ATOM   1027  N   THR    22       4.265  20.185  13.570  1.00 22.98           N  
ATOM   1028  CA  THR    22       5.339  20.387  12.611  1.00 21.66           C  
ATOM   1029  C   THR    22       4.841  21.406  11.621  1.00 20.32           C  
ATOM   1030  O   THR    22       3.785  21.246  11.027  1.00 20.75           O  
ATOM   1031  CB  THR    22       5.750  19.076  11.908  1.00 24.87           C  
ATOM   1032  OG1 THR    22       6.149  18.115  12.904  1.00 24.69           O  
ATOM   1033  CG2 THR    22       6.901  19.331  10.889  1.00 24.48           C  
ATOM   1034  N   SER    23       5.575  22.513  11.549  1.00 21.81           N  
ATOM   1035  CA  SER    23       5.320  23.637  10.643  1.00 22.75           C  
ATOM   1036  C   SER    23       6.566  23.797   9.753  1.00 23.27           C  
ATOM   1037  O   SER    23       7.585  23.085   9.925  1.00 21.19           O  
ATOM   1038  CB  SER    23       4.951  24.895  11.396  1.00 24.06           C  
ATOM   1039  OG  SER    23       5.857  25.136  12.474  1.00 31.42           O  
ATOM   1040  N   VAL    24       6.459  24.702   8.789  1.00 21.84           N  
ATOM   1041  CA  VAL    24       7.466  24.869   7.783  1.00 22.28           C  
ATOM   1042  C   VAL    24       7.885  26.316   7.716  1.00 24.89           C  
ATOM   1043  O   VAL    24       7.049  27.227   7.763  1.00 28.74           O  
ATOM   1044  CB  VAL    24       6.890  24.474   6.379  1.00 24.26           C  
ATOM   1045  CG1 VAL    24       7.872  24.796   5.229  1.00 21.44           C  
ATOM   1046  CG2 VAL    24       6.415  23.036   6.366  1.00 27.38           C  
ATOM   1047  N   GLN    25       9.185  26.504   7.658  1.00 24.78           N  
ATOM   1048  CA  GLN    25       9.804  27.826   7.471  1.00 26.17           C  
ATOM   1049  C   GLN    25      10.672  27.763   6.222  1.00 23.98           C  
ATOM   1050  O   GLN    25      11.868  27.458   6.277  1.00 24.12           O  
ATOM   1051  CB  GLN    25      10.676  28.168   8.679  1.00 28.26           C  
ATOM   1052  CG  GLN    25      11.407  29.462   8.537  1.00 32.78           C  
ATOM   1053  CD  GLN    25      12.921  29.305   8.789  1.00 46.32           C  
ATOM   1054  OE1 GLN    25      13.393  28.353   9.448  1.00 31.55           O  
ATOM   1055  NE2 GLN    25      13.686  30.243   8.248  1.00 37.86           N  
ATOM   1056  N   GLY    26      10.075  28.064   5.079  1.00 25.59           N  
ATOM   1057  CA  GLY    26      10.796  28.004   3.821  1.00 23.90           C  
ATOM   1058  C   GLY    26      10.994  26.543   3.532  1.00 23.83           C  
ATOM   1059  O   GLY    26      10.037  25.826   3.368  1.00 29.46           O  
ATOM   1060  N   ASP    27      12.237  26.085   3.513  1.00 22.49           N  
ATOM   1061  CA  ASP    27      12.539  24.669   3.273  1.00 22.69           C  
ATOM   1062  C   ASP    27      12.805  23.898   4.568  1.00 21.00           C  
ATOM   1063  O   ASP    27      13.177  22.727   4.517  1.00 24.02           O  
ATOM   1064  CB  ASP    27      13.781  24.512   2.394  1.00 24.13           C  
ATOM   1065  CG  ASP    27      13.602  25.149   1.027  1.00 30.59           C  
ATOM   1066  OD1 ASP    27      12.553  24.885   0.428  1.00 31.77           O  
ATOM   1067  OD2 ASP    27      14.481  25.941   0.607  1.00 33.51           O  
ATOM   1068  N   PHE    28      12.600  24.525   5.707  1.00 21.28           N  
ATOM   1069  CA  PHE    28      12.906  23.855   6.983  1.00 22.11           C  
ATOM   1070  C   PHE    28      11.702  23.418   7.803  1.00 22.96           C  
ATOM   1071  O   PHE    28      10.787  24.216   8.046  1.00 23.25           O  
ATOM   1072  CB  PHE    28      13.754  24.751   7.846  1.00 23.03           C  
ATOM   1073  CG  PHE    28      15.086  25.078   7.262  1.00 25.86           C  
ATOM   1074  CD1 PHE    28      15.219  26.114   6.350  1.00 34.83           C  
ATOM   1075  CD2 PHE    28      16.209  24.349   7.629  1.00 30.51           C  
ATOM   1076  CE1 PHE    28      16.476  26.420   5.792  1.00 39.60           C  
ATOM   1077  CE2 PHE    28      17.463  24.648   7.085  1.00 34.80           C  
ATOM   1078  CZ  PHE    28      17.589  25.682   6.163  1.00 29.20           C  
ATOM   1079  N   PRO    29      11.722  22.150   8.281  1.00 20.87           N  
ATOM   1080  CA  PRO    29      10.654  21.756   9.179  1.00 20.13           C  
ATOM   1081  C   PRO    29      10.976  22.270  10.602  1.00 21.65           C  
ATOM   1082  O   PRO    29      12.148  22.428  10.977  1.00 22.71           O  
ATOM   1083  CB  PRO    29      10.703  20.218   9.105  1.00 16.93           C  
ATOM   1084  CG  PRO    29      12.087  19.904   8.813  1.00 20.39           C  
ATOM   1085  CD  PRO    29      12.558  20.996   7.887  1.00 21.93           C  
ATOM   1086  N   HIS    30       9.961  22.603  11.346  1.00 19.86           N  
ATOM   1087  CA  HIS    30      10.142  22.931  12.750  1.00 22.55           C  
ATOM   1088  C   HIS    30       9.177  22.051  13.519  1.00 23.86           C  
ATOM   1089  O   HIS    30       7.988  22.074  13.260  1.00 24.48           O  
ATOM   1090  CB  HIS    30       9.832  24.397  13.043  1.00 24.99           C  
ATOM   1091  CG  HIS    30      10.830  25.351  12.464  1.00 27.13           C  
ATOM   1092  ND1 HIS    30      11.991  25.684  13.116  1.00 42.31           N  
ATOM   1093  CD2 HIS    30      10.853  26.020  11.291  1.00 31.98           C  
ATOM   1094  CE1 HIS    30      12.685  26.527  12.372  1.00 43.97           C  
ATOM   1095  NE2 HIS    30      12.020  26.743  11.257  1.00 28.39           N  
ATOM   1096  N   ALA    31       9.683  21.241  14.440  1.00 21.62           N  
ATOM   1097  CA  ALA    31       8.786  20.420  15.239  1.00 21.19           C  
ATOM   1098  C   ALA    31       8.839  20.930  16.666  1.00 21.06           C  
ATOM   1099  O   ALA    31       9.911  21.187  17.197  1.00 22.76           O  
ATOM   1100  CB  ALA    31       9.184  18.935  15.190  1.00 17.98           C  
ATOM   1101  N   ARG    32       7.673  21.039  17.283  1.00 20.86           N  
ATOM   1102  CA  ARG    32       7.581  21.478  18.655  1.00 21.12           C  
ATOM   1103  C   ARG    32       6.466  20.776  19.402  1.00 22.95           C  
ATOM   1104  O   ARG    32       5.437  20.471  18.843  1.00 23.49           O  
ATOM   1105  CB  ARG    32       7.306  22.983  18.737  1.00 23.47           C  
ATOM   1106  CG  ARG    32       8.254  23.852  17.944  1.00 21.69           C  
ATOM   1107  CD  ARG    32       7.801  25.288  17.980  1.00 19.58           C  
ATOM   1108  NE  ARG    32       8.721  26.221  17.303  1.00 23.67           N  
ATOM   1109  CZ  ARG    32       8.622  26.605  16.033  1.00 28.15           C  
ATOM   1110  NH1 ARG    32       7.690  26.096  15.274  1.00 29.28           N  
ATOM   1111  NH2 ARG    32       9.488  27.463  15.518  1.00 25.35           N  
ATOM   1112  N   TYR    33       6.708  20.544  20.682  1.00 22.45           N  
ATOM   1113  CA  TYR    33       5.709  19.972  21.562  1.00 23.41           C  
ATOM   1114  C   TYR    33       4.845  21.101  22.066  1.00 24.86           C  
ATOM   1115  O   TYR    33       5.324  22.195  22.365  1.00 26.66           O  
ATOM   1116  CB  TYR    33       6.294  19.265  22.764  1.00 24.67           C  
ATOM   1117  CG  TYR    33       6.775  17.885  22.478  1.00 18.01           C  
ATOM   1118  CD1 TYR    33       5.897  16.844  22.358  1.00 24.93           C  
ATOM   1119  CD2 TYR    33       8.121  17.628  22.269  1.00 29.92           C  
ATOM   1120  CE1 TYR    33       6.339  15.580  22.088  1.00 23.33           C  
ATOM   1121  CE2 TYR    33       8.564  16.343  21.966  1.00 26.70           C  
ATOM   1122  CZ  TYR    33       7.689  15.350  21.891  1.00 21.77           C  
ATOM   1123  OH  TYR    33       8.099  14.072  21.576  1.00 21.78           O  
ATOM   1124  N   MET    34       3.550  20.874  22.097  1.00 21.95           N  
ATOM   1125  CA  MET    34       2.677  21.872  22.668  1.00 24.11           C  
ATOM   1126  C   MET    34       1.288  21.323  23.023  1.00 23.90           C  
ATOM   1127  O   MET    34       0.948  20.168  22.750  1.00 25.87           O  
ATOM   1128  CB  MET    34       2.552  23.094  21.756  1.00 23.16           C  
ATOM   1129  CG  MET    34       1.890  22.735  20.406  1.00 18.26           C  
ATOM   1130  SD  MET    34       1.980  24.104  19.065  0.75 21.15          SE  
ATOM   1131  CE  MET    34       3.937  23.951  18.781  1.00 25.84           C  
ATOM   1132  N   THR    35       0.525  22.189  23.673  1.00 25.59           N  
ATOM   1133  CA  THR    35      -0.821  21.872  24.155  1.00 26.45           C  
ATOM   1134  C   THR    35      -1.811  22.152  23.054  1.00 26.17           C  
ATOM   1135  O   THR    35      -1.737  23.199  22.356  1.00 25.36           O  
ATOM   1136  CB  THR    35      -1.160  22.672  25.429  1.00 30.86           C  
ATOM   1137  OG1 THR    35      -0.173  22.356  26.389  1.00 34.72           O  
ATOM   1138  CG2 THR    35      -2.567  22.327  26.032  1.00 27.33           C  
ATOM   1139  N   PHE    36      -2.667  21.146  22.879  1.00 24.61           N  
ATOM   1140  CA  PHE    36      -3.783  21.159  21.969  1.00 25.96           C  
ATOM   1141  C   PHE    36      -5.107  20.968  22.689  1.00 27.48           C  
ATOM   1142  O   PHE    36      -5.284  19.984  23.402  1.00 28.94           O  
ATOM   1143  CB  PHE    36      -3.651  20.045  20.937  1.00 23.70           C  
ATOM   1144  CG  PHE    36      -2.489  20.239  19.986  1.00 23.74           C  
ATOM   1145  CD1 PHE    36      -2.632  21.007  18.820  1.00 34.82           C  
ATOM   1146  CD2 PHE    36      -1.248  19.754  20.291  1.00 22.32           C  
ATOM   1147  CE1 PHE    36      -1.569  21.202  17.959  1.00 21.88           C  
ATOM   1148  CE2 PHE    36      -0.168  19.980  19.438  1.00 29.50           C  
ATOM   1149  CZ  PHE    36      -0.334  20.705  18.280  1.00 23.07           C  
ATOM   1150  N   LEU    37      -6.034  21.899  22.457  1.00 26.29           N  
ATOM   1151  CA  LEU    37      -7.442  21.729  22.836  1.00 22.58           C  
ATOM   1152  C   LEU    37      -8.156  21.293  21.549  1.00 23.58           C  
ATOM   1153  O   LEU    37      -7.637  21.463  20.425  1.00 24.31           O  
ATOM   1154  CB  LEU    37      -8.045  23.063  23.352  1.00 24.30           C  
ATOM   1155  CG  LEU    37      -7.245  23.618  24.548  1.00 28.99           C  
ATOM   1156  CD1 LEU    37      -7.872  24.797  25.259  1.00 27.85           C  
ATOM   1157  CD2 LEU    37      -7.115  22.530  25.554  1.00 36.86           C  
ATOM   1158  N   HIS    38      -9.339  20.709  21.658  1.00 24.95           N  
ATOM   1159  CA  HIS    38     -10.100  20.399  20.459  1.00 23.71           C  
ATOM   1160  C   HIS    38     -11.578  20.629  20.709  1.00 24.00           C  
ATOM   1161  O   HIS    38     -12.065  20.669  21.820  1.00 24.63           O  
ATOM   1162  CB  HIS    38      -9.889  18.943  20.045  1.00 25.67           C  
ATOM   1163  CG  HIS    38     -10.516  17.992  20.996  1.00 25.92           C  
ATOM   1164  ND1 HIS    38     -11.709  17.354  20.727  1.00 25.93           N  
ATOM   1165  CD2 HIS    38     -10.209  17.703  22.283  1.00 24.95           C  
ATOM   1166  CE1 HIS    38     -12.066  16.652  21.785  1.00 19.50           C  
ATOM   1167  NE2 HIS    38     -11.174  16.850  22.741  1.00 25.82           N  
ATOM   1168  N   ASP    39     -12.244  20.838  19.614  1.00 25.95           N  
ATOM   1169  CA  ASP    39     -13.651  21.013  19.521  1.00 25.74           C  
ATOM   1170  C   ASP    39     -14.006  20.108  18.373  1.00 26.80           C  
ATOM   1171  O   ASP    39     -13.857  20.450  17.179  1.00 26.30           O  
ATOM   1172  CB  ASP    39     -14.024  22.444  19.162  1.00 28.09           C  
ATOM   1173  CG  ASP    39     -15.538  22.586  18.914  1.00 35.59           C  
ATOM   1174  OD1 ASP    39     -16.277  21.857  19.572  1.00 33.68           O  
ATOM   1175  OD2 ASP    39     -15.973  23.377  18.063  1.00 41.29           O  
ATOM   1176  N   GLY    40     -14.462  18.922  18.699  1.00 27.82           N  
ATOM   1177  CA  GLY    40     -14.707  17.978  17.626  1.00 26.02           C  
ATOM   1178  C   GLY    40     -13.332  17.656  17.087  1.00 24.93           C  
ATOM   1179  O   GLY    40     -12.367  17.531  17.856  1.00 26.42           O  
ATOM   1180  N   LEU    41     -13.228  17.562  15.770  1.00 26.12           N  
ATOM   1181  CA  LEU    41     -11.943  17.249  15.136  1.00 27.21           C  
ATOM   1182  C   LEU    41     -11.118  18.512  14.833  1.00 27.41           C  
ATOM   1183  O   LEU    41      -9.995  18.428  14.292  1.00 27.79           O  
ATOM   1184  CB  LEU    41     -12.119  16.397  13.884  1.00 27.92           C  
ATOM   1185  CG  LEU    41     -12.854  15.056  14.020  1.00 32.57           C  
ATOM   1186  CD1 LEU    41     -12.713  14.341  12.703  1.00 32.75           C  
ATOM   1187  CD2 LEU    41     -12.344  14.206  15.165  1.00 27.90           C  
ATOM   1188  N   THR    42     -11.642  19.670  15.221  1.00 25.69           N  
ATOM   1189  CA  THR    42     -10.858  20.931  15.103  1.00 26.21           C  
ATOM   1190  C   THR    42      -9.897  21.110  16.299  1.00 26.36           C  
ATOM   1191  O   THR    42     -10.278  20.980  17.457  1.00 23.32           O  
ATOM   1192  CB  THR    42     -11.750  22.165  14.903  1.00 27.45           C  
ATOM   1193  OG1 THR    42     -12.414  22.058  13.636  1.00 30.71           O  
ATOM   1194  CG2 THR    42     -10.934  23.468  14.887  1.00 23.38           C  
ATOM   1195  N   LEU    43      -8.637  21.391  15.997  1.00 25.60           N  
ATOM   1196  CA  LEU    43      -7.637  21.600  17.028  1.00 23.92           C  
ATOM   1197  C   LEU    43      -7.300  23.088  17.192  1.00 24.50           C  
ATOM   1198  O   LEU    43      -7.443  23.909  16.257  1.00 23.65           O  
ATOM   1199  CB  LEU    43      -6.365  20.838  16.719  1.00 25.35           C  
ATOM   1200  CG  LEU    43      -6.368  19.308  16.630  1.00 27.97           C  
ATOM   1201  CD1 LEU    43      -4.941  18.829  16.496  1.00 30.50           C  
ATOM   1202  CD2 LEU    43      -6.977  18.611  17.785  1.00 33.23           C  
ATOM   1203  N   TYR    44      -6.934  23.433  18.416  1.00 22.63           N  
ATOM   1204  CA  TYR    44      -6.574  24.808  18.781  1.00 22.01           C  
ATOM   1205  C   TYR    44      -5.328  24.710  19.636  1.00 23.89           C  
ATOM   1206  O   TYR    44      -5.169  23.812  20.464  1.00 24.22           O  
ATOM   1207  CB  TYR    44      -7.687  25.526  19.565  1.00 24.73           C  
ATOM   1208  CG  TYR    44      -8.986  25.737  18.807  1.00 25.85           C  
ATOM   1209  CD1 TYR    44      -9.126  26.776  17.889  1.00 25.94           C  
ATOM   1210  CD2 TYR    44     -10.081  24.960  19.064  1.00 24.88           C  
ATOM   1211  CE1 TYR    44     -10.321  26.984  17.200  1.00 25.39           C  
ATOM   1212  CE2 TYR    44     -11.281  25.159  18.395  1.00 27.64           C  
ATOM   1213  CZ  TYR    44     -11.391  26.166  17.461  1.00 31.16           C  
ATOM   1214  OH  TYR    44     -12.548  26.332  16.774  1.00 33.25           O  
ATOM   1215  N   THR    45      -4.361  25.558  19.345  1.00 25.20           N  
ATOM   1216  CA  THR    45      -3.194  25.598  20.178  1.00 22.70           C  
ATOM   1217  C   THR    45      -2.822  27.101  20.418  1.00 25.43           C  
ATOM   1218  O   THR    45      -2.835  27.931  19.464  1.00 24.36           O  
ATOM   1219  CB  THR    45      -2.035  24.745  19.559  1.00 25.94           C  
ATOM   1220  OG1 THR    45      -0.976  24.643  20.495  1.00 26.71           O  
ATOM   1221  CG2 THR    45      -1.516  25.362  18.277  1.00 21.15           C  
ATOM   1222  N   PRO    46      -2.461  27.438  21.675  1.00 24.87           N  
ATOM   1223  CA  PRO    46      -2.083  28.799  22.061  1.00 26.94           C  
ATOM   1224  C   PRO    46      -0.775  29.250  21.502  1.00 27.27           C  
ATOM   1225  O   PRO    46       0.128  28.456  21.243  1.00 24.64           O  
ATOM   1226  CB  PRO    46      -2.052  28.760  23.605  1.00 27.69           C  
ATOM   1227  CG  PRO    46      -1.982  27.336  23.958  1.00 29.16           C  
ATOM   1228  CD  PRO    46      -2.376  26.491  22.796  1.00 26.04           C  
ATOM   1229  N   SER    47      -0.676  30.552  21.273  1.00 26.18           N  
ATOM   1230  CA  SER    47       0.591  31.101  20.790  1.00 26.44           C  
ATOM   1231  C   SER    47       0.672  32.592  21.108  1.00 26.07           C  
ATOM   1232  O   SER    47      -0.242  33.145  21.709  1.00 24.99           O  
ATOM   1233  CB  SER    47       0.738  30.807  19.309  1.00 28.27           C  
ATOM   1234  OG  SER    47       2.027  31.146  18.849  1.00 28.45           O  
ATOM   1235  N   GLY    48       1.784  33.227  20.761  1.00 26.43           N  
ATOM   1236  CA  GLY    48       1.962  34.661  20.935  1.00 25.49           C  
ATOM   1237  C   GLY    48       2.080  35.273  19.554  1.00 26.23           C  
ATOM   1238  O   GLY    48       2.554  34.624  18.624  1.00 24.88           O  
ATOM   1239  N   LYS    49       1.653  36.523  19.419  1.00 25.40           N  
ATOM   1240  CA  LYS    49       1.669  37.221  18.122  1.00 25.22           C  
ATOM   1241  C   LYS    49       3.022  37.259  17.461  1.00 26.54           C  
ATOM   1242  O   LYS    49       3.136  37.280  16.218  1.00 24.69           O  
ATOM   1243  CB  LYS    49       1.261  38.694  18.248  1.00 26.01           C  
ATOM   1244  CG  LYS    49      -0.194  38.964  18.407  1.00 35.93           C  
ATOM   1245  CD  LYS    49      -0.443  40.448  18.576  1.00 31.61           C  
ATOM   1246  CE  LYS    49      -1.828  40.643  19.141  1.00 34.42           C  
ATOM   1247  NZ  LYS    49      -2.097  42.069  19.406  1.00 29.95           N  
ATOM   1248  N   GLU    50       4.044  37.365  18.295  1.00 25.56           N  
ATOM   1249  CA  GLU    50       5.423  37.467  17.823  1.00 27.69           C  
ATOM   1250  C   GLU    50       6.224  36.186  17.832  1.00 27.68           C  
ATOM   1251  O   GLU    50       7.396  36.221  17.515  1.00 30.11           O  
ATOM   1252  CB  GLU    50       6.206  38.526  18.617  1.00 31.57           C  
ATOM   1253  CG  GLU    50       5.977  39.969  18.152  1.00 34.74           C  
ATOM   1254  CD  GLU    50       4.504  40.442  18.202  1.00 40.91           C  
ATOM   1255  OE1 GLU    50       3.918  40.488  19.303  1.00 34.03           O  
ATOM   1256  OE2 GLU    50       3.970  40.816  17.133  1.00 38.96           O  
ATOM   1257  N   LEU    51       5.624  35.065  18.206  1.00 24.38           N  
ATOM   1258  CA  LEU    51       6.381  33.815  18.241  1.00 24.29           C  
ATOM   1259  C   LEU    51       6.632  33.296  16.847  1.00 22.99           C  
ATOM   1260  O   LEU    51       5.835  33.524  15.985  1.00 23.76           O  
ATOM   1261  CB  LEU    51       5.653  32.773  19.042  1.00 23.68           C  
ATOM   1262  CG  LEU    51       5.603  33.114  20.548  1.00 29.25           C  
ATOM   1263  CD1 LEU    51       5.133  31.931  21.370  1.00 28.43           C  
ATOM   1264  CD2 LEU    51       6.967  33.558  20.995  1.00 30.25           C  
ATOM   1265  N   PRO    52       7.765  32.635  16.627  1.00 26.51           N  
ATOM   1266  CA  PRO    52       8.087  32.039  15.344  1.00 28.12           C  
ATOM   1267  C   PRO    52       6.981  31.096  14.817  1.00 26.60           C  
ATOM   1268  O   PRO    52       6.684  31.160  13.645  1.00 26.82           O  
ATOM   1269  CB  PRO    52       9.380  31.267  15.623  1.00 29.45           C  
ATOM   1270  CG  PRO    52      10.041  32.043  16.726  1.00 31.64           C  
ATOM   1271  CD  PRO    52       8.938  32.680  17.530  1.00 29.04           C  
ATOM   1272  N   LYS    53       6.369  30.267  15.651  1.00 26.62           N  
ATOM   1273  CA  LYS    53       5.366  29.332  15.131  1.00 25.94           C  
ATOM   1274  C   LYS    53       4.159  30.063  14.575  1.00 24.77           C  
ATOM   1275  O   LYS    53       3.563  29.635  13.608  1.00 22.68           O  
ATOM   1276  CB  LYS    53       4.940  28.277  16.141  1.00 30.60           C  
ATOM   1277  CG  LYS    53       4.206  28.801  17.354  1.00 31.49           C  
ATOM   1278  CD  LYS    53       3.825  27.659  18.280  1.00 34.33           C  
ATOM   1279  CE  LYS    53       3.118  28.193  19.502  1.00 38.11           C  
ATOM   1280  NZ  LYS    53       3.200  27.292  20.687  1.00 36.28           N  
ATOM   1281  N   THR    54       3.840  31.223  15.143  1.00 23.00           N  
ATOM   1282  CA  THR    54       2.766  32.034  14.633  1.00 22.98           C  
ATOM   1283  C   THR    54       3.084  32.599  13.258  1.00 22.46           C  
ATOM   1284  O   THR    54       2.229  32.601  12.378  1.00 23.60           O  
ATOM   1285  CB  THR    54       2.482  33.233  15.557  1.00 22.98           C  
ATOM   1286  OG1 THR    54       2.117  32.729  16.844  1.00 26.67           O  
ATOM   1287  CG2 THR    54       1.381  34.128  14.957  1.00 23.40           C  
ATOM   1288  N   GLU    55       4.297  33.117  13.080  1.00 22.50           N  
ATOM   1289  CA  GLU    55       4.715  33.635  11.779  1.00 24.13           C  
ATOM   1290  C   GLU    55       4.850  32.528  10.741  1.00 22.32           C  
ATOM   1291  O   GLU    55       4.596  32.735   9.542  1.00 22.91           O  
ATOM   1292  CB  GLU    55       6.011  34.464  11.877  1.00 21.81           C  
ATOM   1293  CG  GLU    55       6.418  35.134  10.550  1.00 33.77           C  
ATOM   1294  CD  GLU    55       5.396  36.146  10.043  1.00 34.42           C  
ATOM   1295  OE1 GLU    55       4.571  36.618  10.845  1.00 35.03           O  
ATOM   1296  OE2 GLU    55       5.434  36.465   8.838  1.00 40.57           O  
ATOM   1297  N   GLU    56       5.274  31.348  11.180  1.00 20.37           N  
ATOM   1298  CA  GLU    56       5.386  30.236  10.262  1.00 20.68           C  
ATOM   1299  C   GLU    56       4.025  29.921   9.630  1.00 25.11           C  
ATOM   1300  O   GLU    56       3.897  29.785   8.402  1.00 24.63           O  
ATOM   1301  CB  GLU    56       5.968  29.013  10.965  1.00 21.89           C  
ATOM   1302  CG  GLU    56       7.447  29.156  11.199  1.00 19.68           C  
ATOM   1303  CD  GLU    56       7.953  28.258  12.308  1.00 22.26           C  
ATOM   1304  OE1 GLU    56       7.260  27.304  12.613  1.00 22.14           O  
ATOM   1305  OE2 GLU    56       9.021  28.526  12.905  1.00 20.23           O  
ATOM   1306  N   VAL    57       3.017  29.800  10.497  1.00 23.86           N  
ATOM   1307  CA  VAL    57       1.615  29.525  10.102  1.00 24.91           C  
ATOM   1308  C   VAL    57       1.011  30.607   9.176  1.00 26.11           C  
ATOM   1309  O   VAL    57       0.280  30.282   8.240  1.00 25.99           O  
ATOM   1310  CB  VAL    57       0.751  29.308  11.384  1.00 24.87           C  
ATOM   1311  CG1 VAL    57      -0.696  29.476  11.111  1.00 25.59           C  
ATOM   1312  CG2 VAL    57       1.072  27.896  11.952  1.00 31.46           C  
ATOM   1313  N   ARG    58       1.321  31.885   9.446  1.00 24.58           N  
ATOM   1314  CA  ARG    58       0.847  32.967   8.645  1.00 24.69           C  
ATOM   1315  C   ARG    58       1.342  32.817   7.244  1.00 24.06           C  
ATOM   1316  O   ARG    58       0.627  33.111   6.333  1.00 26.23           O  
ATOM   1317  CB  ARG    58       1.343  34.342   9.130  1.00 25.86           C  
ATOM   1318  CG  ARG    58       0.753  34.779  10.472  1.00 34.18           C  
ATOM   1319  CD  ARG    58       0.919  36.296  10.728  1.00 33.97           C  
ATOM   1320  NE  ARG    58       0.531  36.633  12.105  1.00 33.53           N  
ATOM   1321  CZ  ARG    58       1.397  36.802  13.111  1.00 46.70           C  
ATOM   1322  NH1 ARG    58       2.712  36.714  12.897  1.00 46.58           N  
ATOM   1323  NH2 ARG    58       0.960  37.099  14.330  1.00 47.99           N  
ATOM   1324  N   ARG    59       2.580  32.353   7.086  1.00 20.98           N  
ATOM   1325  CA  ARG    59       3.226  32.273   5.785  1.00 21.14           C  
ATOM   1326  C   ARG    59       3.054  30.921   5.083  1.00 22.65           C  
ATOM   1327  O   ARG    59       3.206  30.825   3.861  1.00 25.19           O  
ATOM   1328  CB  ARG    59       4.718  32.597   5.919  1.00 24.78           C  
ATOM   1329  CG  ARG    59       4.958  34.017   6.372  1.00 32.59           C  
ATOM   1330  CD  ARG    59       6.280  34.236   7.067  1.00 49.16           C  
ATOM   1331  NE  ARG    59       7.328  34.743   6.198  1.00 64.75           N  
ATOM   1332  CZ  ARG    59       8.292  35.556   6.621  1.00 69.91           C  
ATOM   1333  NH1 ARG    59       8.294  35.984   7.880  1.00 73.25           N  
ATOM   1334  NH2 ARG    59       9.221  35.981   5.781  1.00 76.88           N  
ATOM   1335  N   ASN    60       2.806  29.879   5.858  1.00 21.58           N  
ATOM   1336  CA  ASN    60       2.549  28.535   5.278  1.00 23.00           C  
ATOM   1337  C   ASN    60       1.564  27.813   6.208  1.00 22.00           C  
ATOM   1338  O   ASN    60       1.943  27.443   7.311  1.00 23.03           O  
ATOM   1339  CB  ASN    60       3.854  27.751   5.103  1.00 25.44           C  
ATOM   1340  CG  ASN    60       3.659  26.376   4.458  1.00 23.96           C  
ATOM   1341  OD1 ASN    60       2.574  25.828   4.479  1.00 24.04           O  
ATOM   1342  ND2 ASN    60       4.718  25.830   3.884  1.00 20.04           N  
ATOM   1343  N   PRO    61       0.288  27.655   5.777  1.00 19.63           N  
ATOM   1344  CA  PRO    61      -0.748  27.060   6.618  1.00 22.26           C  
ATOM   1345  C   PRO    61      -0.676  25.528   6.797  1.00 23.66           C  
ATOM   1346  O   PRO    61      -1.383  24.953   7.619  1.00 21.03           O  
ATOM   1347  CB  PRO    61      -2.037  27.444   5.889  1.00 22.62           C  
ATOM   1348  CG  PRO    61      -1.624  27.401   4.427  1.00 22.15           C  
ATOM   1349  CD  PRO    61      -0.241  28.056   4.454  1.00 23.16           C  
ATOM   1350  N   HIS    62       0.216  24.889   6.062  1.00 19.44           N  
ATOM   1351  CA  HIS    62       0.300  23.436   6.075  1.00 18.08           C  
ATOM   1352  C   HIS    62       1.075  22.959   7.306  1.00 21.54           C  
ATOM   1353  O   HIS    62       2.283  23.242   7.473  1.00 21.88           O  
ATOM   1354  CB  HIS    62       0.967  22.916   4.845  1.00 19.49           C  
ATOM   1355  CG  HIS    62       0.406  23.470   3.581  1.00 21.80           C  
ATOM   1356  ND1 HIS    62       1.031  24.474   2.869  1.00 26.45           N  
ATOM   1357  CD2 HIS    62      -0.754  23.222   2.938  1.00 25.89           C  
ATOM   1358  CE1 HIS    62       0.303  24.783   1.811  1.00 26.72           C  
ATOM   1359  NE2 HIS    62      -0.787  24.046   1.834  1.00 27.18           N  
ATOM   1360  N   VAL    63       0.354  22.226   8.135  1.00 22.49           N  
ATOM   1361  CA  VAL    63       0.906  21.672   9.372  1.00 24.28           C  
ATOM   1362  C   VAL    63       0.599  20.203   9.478  1.00 23.23           C  
ATOM   1363  O   VAL    63      -0.341  19.704   8.864  1.00 25.47           O  
ATOM   1364  CB  VAL    63       0.430  22.427  10.618  1.00 24.21           C  
ATOM   1365  CG1 VAL    63       0.884  23.921  10.555  1.00 19.99           C  
ATOM   1366  CG2 VAL    63      -1.103  22.346  10.789  1.00 25.94           C  
ATOM   1367  N   CYS    64       1.459  19.511  10.206  1.00 21.97           N  
ATOM   1368  CA  CYS    64       1.253  18.134  10.512  1.00 22.35           C  
ATOM   1369  C   CYS    64       1.274  17.986  12.048  1.00 23.22           C  
ATOM   1370  O   CYS    64       2.241  18.414  12.686  1.00 22.53           O  
ATOM   1371  CB  CYS    64       2.374  17.290   9.890  1.00 23.04           C  
ATOM   1372  SG  CYS    64       2.156  15.484  10.259  1.00 29.36           S  
ATOM   1373  N   VAL    65       0.239  17.373  12.639  1.00 20.75           N  
ATOM   1374  CA  VAL    65       0.222  17.102  14.107  1.00 20.19           C  
ATOM   1375  C   VAL    65       0.265  15.598  14.419  1.00 20.91           C  
ATOM   1376  O   VAL    65      -0.418  14.808  13.787  1.00 23.06           O  
ATOM   1377  CB  VAL    65      -1.028  17.705  14.784  1.00 21.89           C  
ATOM   1378  CG1 VAL    65      -1.017  17.461  16.324  1.00 21.39           C  
ATOM   1379  CG2 VAL    65      -1.095  19.192  14.486  1.00 17.51           C  
ATOM   1380  N   LEU    66       1.128  15.241  15.350  1.00 21.00           N  
ATOM   1381  CA  LEU    66       1.207  13.906  15.886  1.00 22.83           C  
ATOM   1382  C   LEU    66       0.757  14.046  17.330  1.00 24.37           C  
ATOM   1383  O   LEU    66       1.253  14.899  18.086  1.00 22.34           O  
ATOM   1384  CB  LEU    66       2.616  13.317  15.864  1.00 23.54           C  
ATOM   1385  CG  LEU    66       3.253  13.028  14.493  1.00 22.50           C  
ATOM   1386  CD1 LEU    66       4.619  12.383  14.706  1.00 21.40           C  
ATOM   1387  CD2 LEU    66       2.365  12.090  13.805  1.00 24.83           C  
ATOM   1388  N   ILE    67      -0.204  13.207  17.677  1.00 24.16           N  
ATOM   1389  CA  ILE    67      -0.792  13.227  18.998  1.00 23.41           C  
ATOM   1390  C   ILE    67      -1.282  11.877  19.400  1.00 22.23           C  
ATOM   1391  O   ILE    67      -1.861  11.139  18.618  1.00 22.20           O  
ATOM   1392  CB  ILE    67      -1.921  14.345  19.144  1.00 27.64           C  
ATOM   1393  CG1 ILE    67      -2.524  14.393  20.584  1.00 27.72           C  
ATOM   1394  CG2 ILE    67      -3.065  14.147  18.145  1.00 23.71           C  
ATOM   1395  CD1 ILE    67      -3.050  15.759  20.941  1.00 30.36           C  
ATOM   1396  N   GLY    68      -0.964  11.511  20.647  1.00 23.63           N  
ATOM   1397  CA  GLY    68      -1.483  10.287  21.237  1.00 19.56           C  
ATOM   1398  C   GLY    68      -0.487   9.177  21.520  1.00 20.94           C  
ATOM   1399  O   GLY    68      -0.838   8.188  22.125  1.00 24.34           O  
ATOM   1400  N   TYR    69       0.774   9.400  21.175  1.00 23.18           N  
ATOM   1401  CA  TYR    69       1.815   8.409  21.363  1.00 25.41           C  
ATOM   1402  C   TYR    69       2.320   8.402  22.833  1.00 27.83           C  
ATOM   1403  O   TYR    69       3.092   9.253  23.249  1.00 31.88           O  
ATOM   1404  CB  TYR    69       2.925   8.617  20.327  1.00 21.24           C  
ATOM   1405  CG  TYR    69       4.025   7.605  20.393  1.00 24.82           C  
ATOM   1406  CD1 TYR    69       4.062   6.538  19.521  1.00 33.89           C  
ATOM   1407  CD2 TYR    69       4.992   7.673  21.406  1.00 37.24           C  
ATOM   1408  CE1 TYR    69       5.034   5.568  19.615  1.00 33.53           C  
ATOM   1409  CE2 TYR    69       5.980   6.706  21.515  1.00 40.44           C  
ATOM   1410  CZ  TYR    69       5.990   5.657  20.603  1.00 37.40           C  
ATOM   1411  OH  TYR    69       6.971   4.713  20.683  1.00 39.63           O  
ATOM   1412  N   ASP    70       1.854   7.424  23.600  1.00 27.00           N  
ATOM   1413  CA  ASP    70       2.182   7.269  25.029  1.00 29.39           C  
ATOM   1414  C   ASP    70       3.343   6.293  25.247  1.00 32.01           C  
ATOM   1415  O   ASP    70       4.220   6.510  26.084  1.00 30.28           O  
ATOM   1416  CB  ASP    70       0.970   6.717  25.779  1.00 31.09           C  
ATOM   1417  CG  ASP    70      -0.187   7.662  25.768  1.00 29.31           C  
ATOM   1418  OD1 ASP    70       0.083   8.852  25.824  1.00 34.31           O  
ATOM   1419  OD2 ASP    70      -1.347   7.220  25.687  1.00 41.91           O  
ATOM   1420  N   SER    71       3.312   5.230  24.451  1.00 32.18           N  
ATOM   1421  CA  SER    71       4.289   4.158  24.456  1.00 34.11           C  
ATOM   1422  C   SER    71       4.369   3.491  23.077  1.00 33.71           C  
ATOM   1423  O   SER    71       3.578   3.788  22.171  1.00 28.55           O  
ATOM   1424  CB  SER    71       3.901   3.096  25.475  1.00 35.35           C  
ATOM   1425  OG  SER    71       2.619   2.591  25.154  1.00 40.59           O  
ATOM   1426  N   PRO    72       5.341   2.589  22.909  1.00 33.67           N  
ATOM   1427  CA  PRO    72       5.466   1.972  21.585  1.00 35.80           C  
ATOM   1428  C   PRO    72       4.197   1.263  21.069  1.00 33.94           C  
ATOM   1429  O   PRO    72       4.069   1.103  19.876  1.00 32.67           O  
ATOM   1430  CB  PRO    72       6.640   0.992  21.758  1.00 35.26           C  
ATOM   1431  CG  PRO    72       7.411   1.530  22.898  1.00 36.46           C  
ATOM   1432  CD  PRO    72       6.400   2.141  23.828  1.00 34.30           C  
ATOM   1433  N   GLY    73       3.278   0.877  21.958  1.00 33.86           N  
ATOM   1434  CA  GLY    73       2.038   0.193  21.562  1.00 34.31           C  
ATOM   1435  C   GLY    73       0.785   1.063  21.418  1.00 34.45           C  
ATOM   1436  O   GLY    73      -0.265   0.574  21.057  1.00 32.11           O  
ATOM   1437  N   SER    74       0.907   2.349  21.733  1.00 32.57           N  
ATOM   1438  CA  SER    74      -0.194   3.311  21.624  1.00 31.98           C  
ATOM   1439  C   SER    74      -0.667   3.494  20.185  1.00 29.05           C  
ATOM   1440  O   SER    74       0.158   3.613  19.299  1.00 26.36           O  
ATOM   1441  CB  SER    74       0.290   4.708  22.041  1.00 32.27           C  
ATOM   1442  OG  SER    74       0.662   4.823  23.389  1.00 33.26           O  
ATOM   1443  N   ALA    75      -1.989   3.482  19.968  1.00 27.09           N  
ATOM   1444  CA  ALA    75      -2.547   3.897  18.676  1.00 24.35           C  
ATOM   1445  C   ALA    75      -2.503   5.426  18.810  1.00 26.03           C  
ATOM   1446  O   ALA    75      -2.787   5.990  19.881  1.00 25.85           O  
ATOM   1447  CB  ALA    75      -3.962   3.453  18.501  1.00 20.83           C  
ATOM   1448  N   PHE    76      -2.119   6.101  17.743  1.00 23.70           N  
ATOM   1449  CA  PHE    76      -2.009   7.547  17.775  1.00 21.58           C  
ATOM   1450  C   PHE    76      -2.453   8.126  16.461  1.00 22.33           C  
ATOM   1451  O   PHE    76      -2.805   7.397  15.541  1.00 22.48           O  
ATOM   1452  CB  PHE    76      -0.605   8.013  18.165  1.00 22.85           C  
ATOM   1453  CG  PHE    76       0.452   7.599  17.222  1.00 24.24           C  
ATOM   1454  CD1 PHE    76       1.010   6.332  17.313  1.00 22.01           C  
ATOM   1455  CD2 PHE    76       0.880   8.464  16.212  1.00 25.18           C  
ATOM   1456  CE1 PHE    76       1.977   5.930  16.408  1.00 31.42           C  
ATOM   1457  CE2 PHE    76       1.832   8.059  15.312  1.00 27.57           C  
ATOM   1458  CZ  PHE    76       2.393   6.794  15.419  1.00 27.59           C  
ATOM   1459  N   LEU    77      -2.452   9.448  16.398  1.00 24.31           N  
ATOM   1460  CA  LEU    77      -2.928  10.147  15.245  1.00 25.21           C  
ATOM   1461  C   LEU    77      -1.869  10.935  14.528  1.00 25.16           C  
ATOM   1462  O   LEU    77      -1.011  11.581  15.142  1.00 25.35           O  
ATOM   1463  CB  LEU    77      -4.039  11.154  15.657  1.00 23.45           C  
ATOM   1464  CG  LEU    77      -5.301  10.609  16.331  1.00 24.02           C  
ATOM   1465  CD1 LEU    77      -6.185  11.821  16.871  1.00 17.16           C  
ATOM   1466  CD2 LEU    77      -6.008   9.686  15.358  1.00 21.47           C  
ATOM   1467  N   GLU    78      -1.970  10.856  13.203  1.00 26.24           N  
ATOM   1468  CA  GLU    78      -1.228  11.736  12.320  1.00 25.21           C  
ATOM   1469  C   GLU    78      -2.282  12.603  11.616  1.00 23.10           C  
ATOM   1470  O   GLU    78      -3.155  12.109  10.906  1.00 24.75           O  
ATOM   1471  CB  GLU    78      -0.369  10.957  11.324  1.00 25.77           C  
ATOM   1472  CG  GLU    78       0.164  11.887  10.315  1.00 26.30           C  
ATOM   1473  CD  GLU    78       0.948  11.238   9.178  1.00 37.12           C  
ATOM   1474  OE1 GLU    78       1.284  10.043   9.212  1.00 29.49           O  
ATOM   1475  OE2 GLU    78       1.230  11.973   8.224  1.00 44.31           O  
ATOM   1476  N   ILE    79      -2.227  13.902  11.861  1.00 24.16           N  
ATOM   1477  CA  ILE    79      -3.181  14.865  11.334  1.00 22.67           C  
ATOM   1478  C   ILE    79      -2.497  15.905  10.408  1.00 25.34           C  
ATOM   1479  O   ILE    79      -1.618  16.641  10.834  1.00 25.31           O  
ATOM   1480  CB  ILE    79      -3.814  15.646  12.500  1.00 26.46           C  
ATOM   1481  CG1 ILE    79      -4.534  14.700  13.456  1.00 25.76           C  
ATOM   1482  CG2 ILE    79      -4.761  16.741  11.988  1.00 23.69           C  
ATOM   1483  CD1 ILE    79      -5.059  15.317  14.723  1.00 26.35           C  
ATOM   1484  N   ASN    80      -2.909  15.971   9.144  1.00 22.02           N  
ATOM   1485  CA  ASN    80      -2.364  16.967   8.199  1.00 21.97           C  
ATOM   1486  C   ASN    80      -3.489  17.910   8.003  1.00 23.64           C  
ATOM   1487  O   ASN    80      -4.624  17.496   7.736  1.00 22.91           O  
ATOM   1488  CB  ASN    80      -1.924  16.321   6.896  1.00 25.78           C  
ATOM   1489  CG  ASN    80      -0.768  15.321   7.109  1.00 24.67           C  
ATOM   1490  OD1 ASN    80      -0.979  14.113   7.097  1.00 42.52           O  
ATOM   1491  ND2 ASN    80       0.409  15.824   7.385  1.00 28.75           N  
ATOM   1492  N   GLY    81      -3.191  19.185   8.240  1.00 23.95           N  
ATOM   1493  CA  GLY    81      -4.218  20.202   8.228  1.00 23.64           C  
ATOM   1494  C   GLY    81      -3.752  21.580   7.849  1.00 20.09           C  
ATOM   1495  O   GLY    81      -2.612  21.794   7.519  1.00 21.52           O  
ATOM   1496  N   LEU    82      -4.704  22.479   7.870  1.00 23.69           N  
ATOM   1497  CA  LEU    82      -4.500  23.837   7.529  1.00 24.40           C  
ATOM   1498  C   LEU    82      -4.692  24.684   8.764  1.00 23.40           C  
ATOM   1499  O   LEU    82      -5.772  24.669   9.399  1.00 24.27           O  
ATOM   1500  CB  LEU    82      -5.481  24.226   6.407  1.00 24.89           C  
ATOM   1501  CG  LEU    82      -5.183  23.658   5.021  1.00 23.88           C  
ATOM   1502  CD1 LEU    82      -6.313  24.043   3.998  1.00 27.80           C  
ATOM   1503  CD2 LEU    82      -3.813  24.196   4.550  1.00 23.17           C  
ATOM   1504  N   ALA    83      -3.631  25.430   9.081  1.00 23.61           N  
ATOM   1505  CA  ALA    83      -3.572  26.262  10.267  1.00 24.02           C  
ATOM   1506  C   ALA    83      -3.760  27.717   9.900  1.00 22.11           C  
ATOM   1507  O   ALA    83      -3.321  28.180   8.836  1.00 22.50           O  
ATOM   1508  CB  ALA    83      -2.234  26.000  11.097  1.00 20.76           C  
ATOM   1509  N   SER    84      -4.459  28.391  10.811  1.00 24.74           N  
ATOM   1510  CA  SER    84      -4.812  29.809  10.729  1.00 24.69           C  
ATOM   1511  C   SER    84      -4.955  30.390  12.105  1.00 26.64           C  
ATOM   1512  O   SER    84      -5.035  29.680  13.109  1.00 23.99           O  
ATOM   1513  CB  SER    84      -6.087  30.011   9.888  1.00 24.39           C  
ATOM   1514  OG  SER    84      -7.217  29.490  10.540  1.00 26.80           O  
ATOM   1515  N   LEU    85      -4.918  31.708  12.172  1.00 25.96           N  
ATOM   1516  CA  LEU    85      -5.075  32.387  13.441  1.00 26.62           C  
ATOM   1517  C   LEU    85      -6.569  32.621  13.633  1.00 27.62           C  
ATOM   1518  O   LEU    85      -7.254  33.172  12.746  1.00 27.66           O  
ATOM   1519  CB  LEU    85      -4.256  33.687  13.473  1.00 30.04           C  
ATOM   1520  CG  LEU    85      -2.725  33.472  13.267  1.00 33.75           C  
ATOM   1521  CD1 LEU    85      -1.919  34.769  13.407  1.00 38.74           C  
ATOM   1522  CD2 LEU    85      -2.241  32.411  14.255  1.00 40.61           C  
ATOM   1523  N   GLU    86      -7.063  32.156  14.777  1.00 24.82           N  
ATOM   1524  CA  GLU    86      -8.472  32.274  15.156  1.00 24.15           C  
ATOM   1525  C   GLU    86      -8.813  33.721  15.315  1.00 21.95           C  
ATOM   1526  O   GLU    86      -8.141  34.434  16.035  1.00 25.74           O  
ATOM   1527  CB  GLU    86      -8.756  31.543  16.476  1.00 25.21           C  
ATOM   1528  CG  GLU    86     -10.209  31.635  16.921  1.00 27.45           C  
ATOM   1529  CD  GLU    86     -11.154  31.123  15.880  1.00 28.50           C  
ATOM   1530  OE1 GLU    86     -10.988  29.962  15.475  1.00 29.45           O  
ATOM   1531  OE2 GLU    86     -12.072  31.868  15.455  1.00 28.58           O  
ATOM   1532  N   GLU    87      -9.889  34.129  14.666  1.00 26.80           N  
ATOM   1533  CA  GLU    87     -10.319  35.541  14.658  1.00 28.88           C  
ATOM   1534  C   GLU    87     -11.535  35.799  15.502  1.00 28.11           C  
ATOM   1535  O   GLU    87     -11.872  36.940  15.774  1.00 25.77           O  
ATOM   1536  CB  GLU    87     -10.568  36.012  13.203  1.00 32.23           C  
ATOM   1537  CG  GLU    87      -9.275  36.095  12.334  1.00 38.23           C  
ATOM   1538  CD  GLU    87      -9.539  36.477  10.874  1.00 44.95           C  
ATOM   1539  OE1 GLU    87     -10.672  36.852  10.513  1.00 45.22           O  
ATOM   1540  OE2 GLU    87      -8.598  36.388  10.068  1.00 54.19           O  
ATOM   1541  N   ASP    88     -12.200  34.736  15.926  1.00 27.79           N  
ATOM   1542  CA  ASP    88     -13.409  34.877  16.766  1.00 27.66           C  
ATOM   1543  C   ASP    88     -12.946  35.104  18.198  1.00 24.62           C  
ATOM   1544  O   ASP    88     -12.305  34.262  18.811  1.00 22.62           O  
ATOM   1545  CB  ASP    88     -14.313  33.633  16.653  1.00 24.91           C  
ATOM   1546  CG  ASP    88     -15.606  33.733  17.458  1.00 24.99           C  
ATOM   1547  OD1 ASP    88     -15.621  34.014  18.689  1.00 25.75           O  
ATOM   1548  OD2 ASP    88     -16.637  33.406  16.875  1.00 26.56           O  
ATOM   1549  N   GLU    89     -13.260  36.292  18.670  1.00 24.47           N  
ATOM   1550  CA  GLU    89     -12.838  36.752  19.960  1.00 25.52           C  
ATOM   1551  C   GLU    89     -13.418  35.937  21.087  1.00 24.61           C  
ATOM   1552  O   GLU    89     -12.798  35.821  22.132  1.00 25.80           O  
ATOM   1553  CB  GLU    89     -13.190  38.217  20.139  1.00 26.20           C  
ATOM   1554  CG  GLU    89     -12.303  39.171  19.369  1.00 32.76           C  
ATOM   1555  CD  GLU    89     -10.903  39.266  19.935  1.00 45.69           C  
ATOM   1556  OE1 GLU    89     -10.691  38.911  21.134  1.00 48.75           O  
ATOM   1557  OE2 GLU    89     -10.024  39.743  19.181  1.00 50.86           O  
ATOM   1558  N   SER    90     -14.631  35.431  20.911  1.00 22.42           N  
ATOM   1559  CA  SER    90     -15.218  34.598  21.960  1.00 22.95           C  
ATOM   1560  C   SER    90     -14.452  33.258  22.052  1.00 24.76           C  
ATOM   1561  O   SER    90     -14.289  32.703  23.124  1.00 23.81           O  
ATOM   1562  CB  SER    90     -16.708  34.340  21.718  1.00 23.56           C  
ATOM   1563  OG  SER    90     -16.931  33.453  20.656  1.00 22.93           O  
ATOM   1564  N   ILE    91     -13.970  32.753  20.923  1.00 24.44           N  
ATOM   1565  CA  ILE    91     -13.220  31.478  20.922  1.00 25.61           C  
ATOM   1566  C   ILE    91     -11.841  31.727  21.536  1.00 26.70           C  
ATOM   1567  O   ILE    91     -11.346  30.941  22.345  1.00 25.04           O  
ATOM   1568  CB  ILE    91     -13.073  30.861  19.503  1.00 26.67           C  
ATOM   1569  CG1 ILE    91     -14.419  30.371  18.976  1.00 27.27           C  
ATOM   1570  CG2 ILE    91     -12.095  29.697  19.556  1.00 20.52           C  
ATOM   1571  CD1 ILE    91     -14.391  29.842  17.482  1.00 24.64           C  
ATOM   1572  N   LYS    92     -11.248  32.865  21.205  1.00 25.93           N  
ATOM   1573  CA  LYS    92      -9.946  33.192  21.769  1.00 28.64           C  
ATOM   1574  C   LYS    92      -9.999  33.309  23.288  1.00 27.15           C  
ATOM   1575  O   LYS    92      -9.083  32.861  23.959  1.00 24.46           O  
ATOM   1576  CB  LYS    92      -9.405  34.507  21.205  1.00 29.23           C  
ATOM   1577  CG  LYS    92      -9.036  34.421  19.709  1.00 35.47           C  
ATOM   1578  CD  LYS    92      -8.701  35.790  19.154  1.00 38.72           C  
ATOM   1579  CE  LYS    92      -7.547  36.408  19.888  1.00 42.97           C  
ATOM   1580  NZ  LYS    92      -7.442  37.843  19.536  1.00 46.31           N  
ATOM   1581  N   GLU    93     -11.045  33.961  23.788  1.00 24.10           N  
ATOM   1582  CA  GLU    93     -11.230  34.225  25.241  1.00 26.65           C  
ATOM   1583  C   GLU    93     -11.531  32.950  25.979  1.00 27.21           C  
ATOM   1584  O   GLU    93     -11.050  32.720  27.093  1.00 25.60           O  
ATOM   1585  CB  GLU    93     -12.369  35.215  25.486  1.00 25.01           C  
ATOM   1586  CG  GLU    93     -12.699  35.458  26.991  1.00 34.20           C  
ATOM   1587  CD  GLU    93     -11.556  36.095  27.747  1.00 35.65           C  
ATOM   1588  OE1 GLU    93     -10.778  36.797  27.093  1.00 46.70           O  
ATOM   1589  OE2 GLU    93     -11.423  35.895  28.984  1.00 35.98           O  
ATOM   1590  N   ARG    94     -12.316  32.097  25.343  1.00 27.12           N  
ATOM   1591  CA  ARG    94     -12.613  30.813  25.924  1.00 28.00           C  
ATOM   1592  C   ARG    94     -11.344  29.946  26.088  1.00 27.43           C  
ATOM   1593  O   ARG    94     -11.137  29.361  27.110  1.00 26.23           O  
ATOM   1594  CB  ARG    94     -13.656  30.092  25.082  1.00 29.52           C  
ATOM   1595  CG  ARG    94     -14.022  28.737  25.634  1.00 33.03           C  
ATOM   1596  CD  ARG    94     -14.433  28.837  27.081  1.00 36.10           C  
ATOM   1597  NE  ARG    94     -15.662  29.619  27.286  1.00 44.98           N  
ATOM   1598  CZ  ARG    94     -16.887  29.097  27.200  1.00 45.17           C  
ATOM   1599  NH1 ARG    94     -17.047  27.805  26.913  1.00 47.64           N  
ATOM   1600  NH2 ARG    94     -17.945  29.857  27.389  1.00 43.33           N  
ATOM   1601  N   ILE    95     -10.552  29.823  25.035  1.00 24.35           N  
ATOM   1602  CA  ILE    95      -9.319  29.105  25.060  1.00 24.04           C  
ATOM   1603  C   ILE    95      -8.389  29.742  26.129  1.00 24.16           C  
ATOM   1604  O   ILE    95      -7.738  29.034  26.896  1.00 24.92           O  
ATOM   1605  CB  ILE    95      -8.642  29.115  23.698  1.00 26.27           C  
ATOM   1606  CG1 ILE    95      -9.469  28.344  22.605  1.00 28.97           C  
ATOM   1607  CG2 ILE    95      -7.198  28.616  23.796  1.00 24.84           C  
ATOM   1608  CD1 ILE    95      -9.740  26.942  22.940  1.00 34.68           C  
ATOM   1609  N   TRP    96      -8.326  31.078  26.170  1.00 23.39           N  
ATOM   1610  CA  TRP    96      -7.495  31.785  27.144  1.00 21.32           C  
ATOM   1611  C   TRP    96      -7.867  31.360  28.565  1.00 24.82           C  
ATOM   1612  O   TRP    96      -7.014  31.040  29.399  1.00 22.90           O  
ATOM   1613  CB  TRP    96      -7.580  33.326  26.943  1.00 24.68           C  
ATOM   1614  CG  TRP    96      -6.959  34.140  28.049  1.00 26.84           C  
ATOM   1615  CD1 TRP    96      -7.623  34.949  28.944  1.00 30.90           C  
ATOM   1616  CD2 TRP    96      -5.560  34.192  28.439  1.00 28.62           C  
ATOM   1617  NE1 TRP    96      -6.729  35.515  29.824  1.00 35.51           N  
ATOM   1618  CE2 TRP    96      -5.465  35.057  29.548  1.00 25.02           C  
ATOM   1619  CE3 TRP    96      -4.392  33.618  27.949  1.00 27.30           C  
ATOM   1620  CZ2 TRP    96      -4.249  35.350  30.159  1.00 33.32           C  
ATOM   1621  CZ3 TRP    96      -3.187  33.904  28.592  1.00 31.13           C  
ATOM   1622  CH2 TRP    96      -3.131  34.743  29.668  1.00 30.56           C  
ATOM   1623  N   GLU    97      -9.161  31.333  28.834  1.00 26.97           N  
ATOM   1624  CA  GLU    97      -9.683  30.993  30.144  1.00 26.44           C  
ATOM   1625  C   GLU    97      -9.417  29.537  30.489  1.00 28.96           C  
ATOM   1626  O   GLU    97      -9.176  29.195  31.645  1.00 29.19           O  
ATOM   1627  CB  GLU    97     -11.196  31.323  30.213  1.00 29.88           C  
ATOM   1628  CG  GLU    97     -11.445  32.800  30.285  1.00 26.25           C  
ATOM   1629  CD  GLU    97     -12.896  33.194  30.164  1.00 33.38           C  
ATOM   1630  OE1 GLU    97     -13.775  32.312  30.248  1.00 45.27           O  
ATOM   1631  OE2 GLU    97     -13.139  34.387  29.937  1.00 31.96           O  
ATOM   1632  N   ASN    98      -9.446  28.669  29.491  0.50 29.09           N  
ATOM   1634  CA  ASN    98      -9.162  27.258  29.746  0.50 30.24           C  
ATOM   1636  C   ASN    98      -7.669  27.057  30.039  0.50 28.65           C  
ATOM   1638  O   ASN    98      -7.285  26.398  30.998  0.50 26.77           O  
ATOM   1640  CB  ASN    98      -9.605  26.390  28.584  0.50 29.92           C  
ATOM   1642  CG  ASN    98      -9.313  24.934  28.817  0.50 30.69           C  
ATOM   1644  OD1 ASN    98      -8.186  24.551  29.165  0.50 29.64           O  
ATOM   1646  ND2 ASN    98     -10.319  24.104  28.618  0.50 29.51           N  
ATOM   1648  N   ILE    99      -6.835  27.696  29.239  1.00 30.14           N  
ATOM   1649  CA  ILE    99      -5.385  27.606  29.431  1.00 30.55           C  
ATOM   1650  C   ILE    99      -4.894  28.183  30.779  1.00 31.12           C  
ATOM   1651  O   ILE    99      -4.009  27.611  31.412  1.00 33.81           O  
ATOM   1652  CB  ILE    99      -4.653  28.367  28.289  1.00 33.41           C  
ATOM   1653  CG1 ILE    99      -4.812  27.621  26.978  1.00 44.69           C  
ATOM   1654  CG2 ILE    99      -3.184  28.505  28.554  1.00 46.54           C  
ATOM   1655  CD1 ILE    99      -4.328  26.221  27.021  1.00 42.35           C  
ATOM   1656  N   SER   100      -5.451  29.326  31.193  1.00 27.06           N  
ATOM   1657  CA  SER   100      -4.987  30.084  32.374  1.00 25.77           C  
ATOM   1658  C   SER   100      -5.831  29.855  33.609  1.00 25.58           C  
ATOM   1659  O   SER   100      -5.760  30.622  34.594  1.00 23.46           O  
ATOM   1660  CB  SER   100      -5.019  31.595  32.054  1.00 20.90           C  
ATOM   1661  OG  SER   100      -6.356  32.059  31.869  1.00 23.13           O  
ATOM   1662  N   LYS   101      -6.631  28.795  33.577  1.00 27.27           N  
ATOM   1663  CA  LYS   101      -7.634  28.612  34.625  1.00 28.29           C  
ATOM   1664  C   LYS   101      -7.018  28.550  36.030  1.00 24.38           C  
ATOM   1665  O   LYS   101      -7.606  29.052  36.962  1.00 27.83           O  
ATOM   1666  CB  LYS   101      -8.543  27.414  34.370  1.00 30.29           C  
ATOM   1667  CG  LYS   101      -7.852  26.054  34.473  1.00 41.68           C  
ATOM   1668  CD  LYS   101      -8.890  24.917  34.512  1.00 46.81           C  
ATOM   1669  CE  LYS   101      -9.525  24.628  33.162  1.00 52.12           C  
ATOM   1670  NZ  LYS   101      -8.577  23.986  32.222  1.00 49.92           N  
ATOM   1671  N   ASP   102      -5.851  27.931  36.172  1.00 26.17           N  
ATOM   1672  CA  ASP   102      -5.208  27.819  37.486  1.00 24.93           C  
ATOM   1673  C   ASP   102      -4.880  29.191  38.122  1.00 24.36           C  
ATOM   1674  O   ASP   102      -4.769  29.287  39.354  1.00 29.92           O  
ATOM   1675  CB  ASP   102      -3.934  26.979  37.433  1.00 26.36           C  
ATOM   1676  CG  ASP   102      -4.203  25.480  37.373  1.00 32.59           C  
ATOM   1677  OD1 ASP   102      -5.388  25.048  37.427  1.00 33.69           O  
ATOM   1678  OD2 ASP   102      -3.191  24.743  37.318  1.00 36.93           O  
ATOM   1679  N   TRP   103      -4.765  30.242  37.301  1.00 24.60           N  
ATOM   1680  CA  TRP   103      -4.408  31.601  37.785  1.00 25.17           C  
ATOM   1681  C   TRP   103      -5.244  32.747  37.219  1.00 30.11           C  
ATOM   1682  O   TRP   103      -5.149  33.901  37.673  1.00 32.70           O  
ATOM   1683  CB  TRP   103      -2.919  31.898  37.502  1.00 28.09           C  
ATOM   1684  CG  TRP   103      -2.571  32.126  36.025  1.00 34.30           C  
ATOM   1685  CD1 TRP   103      -2.581  33.339  35.324  1.00 31.98           C  
ATOM   1686  CD2 TRP   103      -2.187  31.139  35.086  1.00 29.27           C  
ATOM   1687  NE1 TRP   103      -2.232  33.121  34.021  1.00 35.26           N  
ATOM   1688  CE2 TRP   103      -1.966  31.786  33.859  1.00 30.28           C  
ATOM   1689  CE3 TRP   103      -2.001  29.769  35.163  1.00 18.77           C  
ATOM   1690  CZ2 TRP   103      -1.606  31.115  32.754  1.00 37.18           C  
ATOM   1691  CZ3 TRP   103      -1.634  29.113  34.060  1.00 34.12           C  
ATOM   1692  CH2 TRP   103      -1.435  29.773  32.870  1.00 37.95           C  
ATOM   1693  N   PHE   104      -6.117  32.439  36.276  1.00 34.00           N  
ATOM   1694  CA  PHE   104      -6.934  33.459  35.617  1.00 35.95           C  
ATOM   1695  C   PHE   104      -7.833  34.206  36.572  1.00 35.24           C  
ATOM   1696  O   PHE   104      -8.594  33.594  37.319  1.00 34.16           O  
ATOM   1697  CB  PHE   104      -7.760  32.840  34.464  1.00 39.24           C  
ATOM   1698  CG  PHE   104      -8.773  33.787  33.844  1.00 38.94           C  
ATOM   1699  CD1 PHE   104      -8.411  34.636  32.817  1.00 36.50           C  
ATOM   1700  CD2 PHE   104     -10.091  33.796  34.272  1.00 40.95           C  
ATOM   1701  CE1 PHE   104      -9.340  35.505  32.243  1.00 40.74           C  
ATOM   1702  CE2 PHE   104     -11.026  34.660  33.703  1.00 41.12           C  
ATOM   1703  CZ  PHE   104     -10.641  35.510  32.685  1.00 42.71           C  
ATOM   1704  N   GLN   105      -7.717  35.531  36.573  1.00 34.79           N  
ATOM   1705  CA  GLN   105      -8.607  36.363  37.377  1.00 36.45           C  
ATOM   1706  C   GLN   105      -9.143  37.570  36.594  1.00 40.48           C  
ATOM   1707  O   GLN   105      -9.411  38.645  37.147  1.00 36.61           O  
ATOM   1708  CB  GLN   105      -8.006  36.755  38.757  1.00 36.06           C  
ATOM   1709  CG  GLN   105      -6.693  37.524  38.730  1.00 38.74           C  
ATOM   1710  CD  GLN   105      -6.259  38.008  40.108  1.00 27.15           C  
ATOM   1711  OE1 GLN   105      -5.901  37.207  40.992  1.00 23.55           O  
ATOM   1712  NE2 GLN   105      -6.251  39.339  40.291  1.00 33.92           N  
ATOM   1713  N   GLY   106      -9.331  37.367  35.291  1.00 43.39           N  
ATOM   1714  CA  GLY   106      -9.904  38.411  34.438  1.00 44.55           C  
ATOM   1715  C   GLY   106      -8.948  39.241  33.599  1.00 46.11           C  
ATOM   1716  O   GLY   106      -9.380  40.052  32.794  1.00 48.44           O  
ATOM   1717  N   GLU   107      -7.658  39.073  33.772  1.00 46.72           N  
ATOM   1718  CA  GLU   107      -6.717  39.761  32.944  1.00 48.03           C  
ATOM   1719  C   GLU   107      -6.746  39.219  31.524  1.00 49.31           C  
ATOM   1720  O   GLU   107      -7.100  38.105  31.283  1.00 50.37           O  
ATOM   1721  CB  GLU   107      -5.328  39.660  33.540  1.00 47.53           C  
ATOM   1722  N   ASP   108      -6.396  40.027  30.570  1.00 49.32           N  
ATOM   1723  CA  ASP   108      -6.167  39.478  29.265  1.00 50.51           C  
ATOM   1724  C   ASP   108      -4.826  39.877  28.771  1.00 47.60           C  
ATOM   1725  O   ASP   108      -4.200  40.720  29.313  1.00 48.55           O  
ATOM   1726  CB  ASP   108      -7.237  39.890  28.266  1.00 51.81           C  
ATOM   1727  CG  ASP   108      -7.812  38.721  27.513  1.00 59.75           C  
ATOM   1728  OD1 ASP   108      -7.216  38.269  26.500  1.00 69.25           O  
ATOM   1729  OD2 ASP   108      -8.866  38.247  27.943  1.00 60.83           O  
ATOM   1730  N   SER   109      -4.409  39.248  27.712  1.00 42.70           N  
ATOM   1731  CA  SER   109      -3.057  39.292  27.328  1.00 39.53           C  
ATOM   1732  C   SER   109      -3.109  39.706  25.889  1.00 37.93           C  
ATOM   1733  O   SER   109      -3.668  39.013  25.099  1.00 36.08           O  
ATOM   1734  CB  SER   109      -2.482  37.908  27.485  1.00 35.74           C  
ATOM   1735  OG  SER   109      -1.260  37.836  26.853  1.00 50.86           O  
ATOM   1736  N   PRO   110      -2.574  40.862  25.560  1.00 36.20           N  
ATOM   1737  CA  PRO   110      -2.735  41.388  24.200  1.00 34.17           C  
ATOM   1738  C   PRO   110      -1.943  40.604  23.149  1.00 28.51           C  
ATOM   1739  O   PRO   110      -2.276  40.602  21.977  1.00 30.62           O  
ATOM   1740  CB  PRO   110      -2.205  42.817  24.327  1.00 34.50           C  
ATOM   1741  CG  PRO   110      -1.144  42.732  25.361  1.00 38.99           C  
ATOM   1742  CD  PRO   110      -1.625  41.662  26.357  1.00 39.07           C  
ATOM   1743  N   SER   111      -0.931  39.896  23.588  1.00 26.60           N  
ATOM   1744  CA  SER   111      -0.087  39.204  22.652  1.00 27.88           C  
ATOM   1745  C   SER   111      -0.596  37.777  22.434  1.00 25.75           C  
ATOM   1746  O   SER   111      -0.098  37.091  21.603  1.00 24.21           O  
ATOM   1747  CB  SER   111       1.350  39.192  23.138  1.00 31.27           C  
ATOM   1748  OG  SER   111       1.500  38.284  24.205  1.00 36.14           O  
ATOM   1749  N   PHE   112      -1.644  37.389  23.154  1.00 28.87           N  
ATOM   1750  CA  PHE   112      -2.218  36.046  23.067  1.00 29.00           C  
ATOM   1751  C   PHE   112      -2.961  35.817  21.734  1.00 27.15           C  
ATOM   1752  O   PHE   112      -3.736  36.632  21.248  1.00 25.88           O  
ATOM   1753  CB  PHE   112      -3.128  35.738  24.247  1.00 30.08           C  
ATOM   1754  CG  PHE   112      -3.621  34.301  24.280  1.00 28.08           C  
ATOM   1755  CD1 PHE   112      -2.787  33.296  24.662  1.00 27.96           C  
ATOM   1756  CD2 PHE   112      -4.919  33.988  23.964  1.00 28.83           C  
ATOM   1757  CE1 PHE   112      -3.233  31.980  24.714  1.00 32.87           C  
ATOM   1758  CE2 PHE   112      -5.384  32.714  24.033  1.00 26.31           C  
ATOM   1759  CZ  PHE   112      -4.549  31.693  24.416  1.00 28.17           C  
ATOM   1760  N   VAL   113      -2.684  34.672  21.142  0.50 24.30           N  
ATOM   1762  CA  VAL   113      -3.327  34.302  19.901  0.50 23.77           C  
ATOM   1764  C   VAL   113      -3.588  32.822  19.960  0.50 24.04           C  
ATOM   1766  O   VAL   113      -3.043  32.104  20.808  0.50 21.68           O  
ATOM   1768  CB  VAL   113      -2.475  34.643  18.671  0.50 22.73           C  
ATOM   1770  CG1 VAL   113      -2.213  36.135  18.620  0.50 24.82           C  
ATOM   1772  CG2 VAL   113      -1.179  33.824  18.669  0.50 22.09           C  
ATOM   1774  N   VAL   114      -4.469  32.391  19.070  1.00 23.44           N  
ATOM   1775  CA  VAL   114      -4.847  31.005  18.988  1.00 22.58           C  
ATOM   1776  C   VAL   114      -4.680  30.527  17.543  1.00 22.66           C  
ATOM   1777  O   VAL   114      -5.131  31.199  16.604  1.00 20.35           O  
ATOM   1778  CB  VAL   114      -6.294  30.776  19.501  1.00 23.21           C  
ATOM   1779  CG1 VAL   114      -6.808  29.290  19.211  1.00 21.96           C  
ATOM   1780  CG2 VAL   114      -6.424  31.169  21.022  1.00 21.87           C  
ATOM   1781  N   ILE   115      -3.940  29.431  17.411  1.00 23.01           N  
ATOM   1782  CA  ILE   115      -3.781  28.710  16.168  1.00 26.40           C  
ATOM   1783  C   ILE   115      -4.855  27.650  16.069  1.00 25.68           C  
ATOM   1784  O   ILE   115      -4.964  26.714  16.887  1.00 21.88           O  
ATOM   1785  CB  ILE   115      -2.385  28.102  15.995  1.00 27.41           C  
ATOM   1786  CG1 ILE   115      -1.353  29.231  16.088  1.00 25.65           C  
ATOM   1787  CG2 ILE   115      -2.310  27.350  14.623  1.00 21.73           C  
ATOM   1788  CD1 ILE   115       0.119  28.811  16.281  1.00 23.90           C  
ATOM   1789  N   LYS   116      -5.675  27.829  15.037  1.00 24.59           N  
ATOM   1790  CA  LYS   116      -6.770  26.916  14.730  1.00 24.48           C  
ATOM   1791  C   LYS   116      -6.264  25.974  13.693  1.00 24.99           C  
ATOM   1792  O   LYS   116      -5.629  26.398  12.725  1.00 22.82           O  
ATOM   1793  CB  LYS   116      -7.972  27.677  14.165  1.00 24.07           C  
ATOM   1794  CG  LYS   116      -9.158  26.781  13.740  1.00 29.98           C  
ATOM   1795  CD  LYS   116     -10.210  27.567  12.898  1.00 26.90           C  
ATOM   1796  CE  LYS   116     -11.451  26.766  12.786  1.00 39.03           C  
ATOM   1797  NZ  LYS   116     -12.534  27.439  11.993  1.00 36.98           N  
ATOM   1798  N   ILE   117      -6.501  24.689  13.894  1.00 23.12           N  
ATOM   1799  CA  ILE   117      -6.088  23.710  12.889  1.00 24.67           C  
ATOM   1800  C   ILE   117      -7.274  22.911  12.408  1.00 22.63           C  
ATOM   1801  O   ILE   117      -7.896  22.146  13.175  1.00 23.51           O  
ATOM   1802  CB  ILE   117      -4.971  22.769  13.398  1.00 24.32           C  
ATOM   1803  CG1 ILE   117      -3.739  23.593  13.802  1.00 23.43           C  
ATOM   1804  CG2 ILE   117      -4.647  21.690  12.353  1.00 22.46           C  
ATOM   1805  CD1 ILE   117      -2.857  22.926  14.780  1.00 29.93           C  
ATOM   1806  N   VAL   118      -7.541  23.056  11.109  1.00 22.92           N  
ATOM   1807  CA  VAL   118      -8.609  22.333  10.418  1.00 24.35           C  
ATOM   1808  C   VAL   118      -8.024  21.095   9.739  1.00 22.53           C  
ATOM   1809  O   VAL   118      -7.231  21.177   8.816  1.00 25.36           O  
ATOM   1810  CB  VAL   118      -9.412  23.261   9.409  1.00 25.46           C  
ATOM   1811  CG1 VAL   118     -10.457  22.460   8.588  1.00 22.00           C  
ATOM   1812  CG2 VAL   118     -10.093  24.366  10.166  1.00 23.69           C  
ATOM   1813  N   PRO   119      -8.399  19.907  10.196  1.00 26.30           N  
ATOM   1814  CA  PRO   119      -7.805  18.708   9.598  1.00 23.16           C  
ATOM   1815  C   PRO   119      -8.249  18.413   8.191  1.00 23.39           C  
ATOM   1816  O   PRO   119      -9.413  18.576   7.884  1.00 21.45           O  
ATOM   1817  CB  PRO   119      -8.350  17.590  10.492  1.00 26.11           C  
ATOM   1818  CG  PRO   119      -8.743  18.279  11.769  1.00 35.28           C  
ATOM   1819  CD  PRO   119      -9.305  19.557  11.300  1.00 27.67           C  
ATOM   1820  N   GLU   120      -7.330  17.947   7.351  1.00 22.68           N  
ATOM   1821  CA  GLU   120      -7.670  17.614   5.964  1.00 21.99           C  
ATOM   1822  C   GLU   120      -7.601  16.102   5.818  1.00 22.64           C  
ATOM   1823  O   GLU   120      -8.355  15.469   5.064  1.00 24.80           O  
ATOM   1824  CB  GLU   120      -6.736  18.335   4.969  1.00 22.70           C  
ATOM   1825  CG  GLU   120      -6.900  19.845   5.001  1.00 20.40           C  
ATOM   1826  CD  GLU   120      -8.306  20.290   4.534  1.00 34.03           C  
ATOM   1827  OE1 GLU   120      -8.966  19.534   3.783  1.00 30.66           O  
ATOM   1828  OE2 GLU   120      -8.712  21.408   4.885  1.00 30.18           O  
ATOM   1829  N   GLN   121      -6.709  15.527   6.594  1.00 24.66           N  
ATOM   1830  CA  GLN   121      -6.496  14.081   6.638  1.00 23.73           C  
ATOM   1831  C   GLN   121      -6.116  13.668   8.034  1.00 24.77           C  
ATOM   1832  O   GLN   121      -5.267  14.305   8.654  1.00 23.86           O  
ATOM   1833  CB  GLN   121      -5.373  13.753   5.682  1.00 25.65           C  
ATOM   1834  CG  GLN   121      -5.802  14.075   4.254  1.00 40.52           C  
ATOM   1835  CD  GLN   121      -4.797  14.893   3.417  1.00 54.09           C  
ATOM   1836  OE1 GLN   121      -3.747  15.361   3.914  1.00 52.65           O  
ATOM   1837  NE2 GLN   121      -5.164  15.122   2.141  1.00 48.47           N  
ATOM   1838  N   ILE   122      -6.731  12.593   8.524  1.00 21.91           N  
ATOM   1839  CA  ILE   122      -6.380  12.019   9.821  1.00 24.16           C  
ATOM   1840  C   ILE   122      -6.192  10.559   9.697  1.00 25.57           C  
ATOM   1841  O   ILE   122      -7.104   9.882   9.250  1.00 24.21           O  
ATOM   1842  CB  ILE   122      -7.443  12.235  10.907  1.00 20.31           C  
ATOM   1843  CG1 ILE   122      -7.883  13.710  10.977  1.00 23.42           C  
ATOM   1844  CG2 ILE   122      -6.879  11.770  12.208  1.00 22.36           C  
ATOM   1845  CD1 ILE   122      -8.873  14.009  12.042  1.00 30.33           C  
ATOM   1846  N   ARG   123      -4.984  10.091  10.057  1.00 23.37           N  
ATOM   1847  CA  ARG   123      -4.657   8.692  10.024  1.00 26.13           C  
ATOM   1848  C   ARG   123      -4.416   8.207  11.435  1.00 26.76           C  
ATOM   1849  O   ARG   123      -3.755   8.905  12.241  1.00 24.02           O  
ATOM   1850  CB  ARG   123      -3.386   8.451   9.252  1.00 28.72           C  
ATOM   1851  CG  ARG   123      -3.494   8.665   7.788  1.00 40.48           C  
ATOM   1852  CD  ARG   123      -2.445   7.803   7.120  1.00 48.20           C  
ATOM   1853  NE  ARG   123      -1.123   8.352   7.326  1.00 50.46           N  
ATOM   1854  CZ  ARG   123      -0.001   7.660   7.174  1.00 49.84           C  
ATOM   1855  NH1 ARG   123      -0.052   6.365   6.840  1.00 45.51           N  
ATOM   1856  NH2 ARG   123       1.170   8.264   7.381  1.00 39.62           N  
ATOM   1857  N   ILE   124      -5.011   7.063  11.760  1.00 22.50           N  
ATOM   1858  CA  ILE   124      -4.734   6.415  13.038  1.00 24.45           C  
ATOM   1859  C   ILE   124      -3.657   5.435  12.717  1.00 24.58           C  
ATOM   1860  O   ILE   124      -3.829   4.523  11.892  1.00 20.24           O  
ATOM   1861  CB  ILE   124      -5.901   5.643  13.688  1.00 24.08           C  
ATOM   1862  CG1 ILE   124      -7.099   6.516  13.996  1.00 30.86           C  
ATOM   1863  CG2 ILE   124      -5.500   5.102  15.081  1.00 30.84           C  
ATOM   1864  CD1 ILE   124      -8.273   5.660  14.599  1.00 33.77           C  
ATOM   1865  N   LEU   125      -2.550   5.620  13.404  1.00 24.22           N  
ATOM   1866  CA  LEU   125      -1.399   4.785  13.257  1.00 26.90           C  
ATOM   1867  C   LEU   125      -1.216   3.896  14.470  1.00 28.39           C  
ATOM   1868  O   LEU   125      -1.678   4.229  15.576  1.00 24.33           O  
ATOM   1869  CB  LEU   125      -0.177   5.688  13.040  1.00 27.04           C  
ATOM   1870  CG  LEU   125      -0.197   6.589  11.806  1.00 29.37           C  
ATOM   1871  CD1 LEU   125       1.070   7.462  11.763  1.00 36.63           C  
ATOM   1872  CD2 LEU   125      -0.356   5.782  10.517  1.00 32.33           C  
ATOM   1873  N   ASN   126      -0.555   2.754  14.231  1.00 29.72           N  
ATOM   1874  CA  ASN   126      -0.239   1.761  15.256  1.00 30.16           C  
ATOM   1875  C   ASN   126      -1.513   1.250  15.937  1.00 30.72           C  
ATOM   1876  O   ASN   126      -1.550   0.994  17.153  1.00 28.12           O  
ATOM   1877  CB  ASN   126       0.769   2.326  16.280  1.00 31.62           C  
ATOM   1878  CG  ASN   126       1.511   1.238  17.057  1.00 29.72           C  
ATOM   1879  OD1 ASN   126       1.805   0.173  16.523  1.00 30.95           O  
ATOM   1880  ND2 ASN   126       1.842   1.515  18.310  1.00 31.08           N  
ATOM   1881  N   SER   127      -2.581   1.127  15.154  1.00 27.81           N  
ATOM   1882  CA  SER   127      -3.838   0.639  15.724  1.00 30.83           C  
ATOM   1883  C   SER   127      -3.832  -0.864  15.874  1.00 27.77           C  
ATOM   1884  O   SER   127      -4.618  -1.369  16.648  1.00 29.89           O  
ATOM   1885  CB  SER   127      -5.074   1.089  14.920  1.00 30.64           C  
ATOM   1886  OG  SER   127      -4.993   0.621  13.602  1.00 34.66           O  
ATOM   1887  OXT SER   127      -3.051  -1.593  15.260  1.00 27.95           O  
END
