
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  194 ( 1574),  selected  194 , name 2i51_A
# Molecule2: number of CA atoms  124 (  982),  selected  124 , name T0402.pdb
# PARAMETERS: 2i51_A.T0402.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      E       4           -
LGA    S     2_A      -       -           -
LGA    L     3_A      -       -           -
LGA    A     4_A      -       -           -
LGA    P     5_A      L       5          4.834
LGA    W     6_A      E       6          2.474
LGA    R     7_A      -       -           -
LGA    G     8_A      D       7          0.959
LGA    A     9_A      K       8          0.920
LGA    I    10_A      I       9          2.597
LGA    A    11_A      L      10          3.187
LGA    H    12_A      A      11          2.929
LGA    A    13_A      I      12          2.941
LGA    L    14_A      L      13          5.113
LGA    H    15_A      E      14           #
LGA    R    16_A      Q      15           #
LGA    N    17_A      -       -           -
LGA    R    18_A      -       -           -
LGA    S    19_A      -       -           -
LGA    L    20_A      -       -           -
LGA    V    21_A      -       -           -
LGA    Y    22_A      -       -           -
LGA    A    23_A      H      16          4.126
LGA    R    24_A      Q      17          2.459
LGA    Y    25_A      V      18          1.246
LGA    L    26_A      G      19          0.534
LGA    Q    27_A      V      20          0.352
LGA    L    28_A      L      21          0.407
LGA    A    29_A      T      22          0.455
LGA    T    30_A      S      23          0.583
LGA    V    31_A      V      24          0.619
LGA    Q    32_A      Q      25          0.193
LGA    P    33_A      G      26          3.026
LGA    N    34_A      -       -           -
LGA    G    35_A      D      27          1.606
LGA    R    36_A      F      28          1.021
LGA    P    37_A      P      29          0.818
LGA    A    38_A      H      30          0.676
LGA    N    39_A      A      31          0.620
LGA    R    40_A      R      32          0.264
LGA    T    41_A      Y      33          0.464
LGA    L    42_A      M      34          0.752
LGA    V    43_A      T      35          1.074
LGA    F    44_A      F      36          1.712
LGA    R    45_A      L      37          1.897
LGA    G    46_A      H      38          2.805
LGA    F    47_A      D      39          1.940
LGA    L    48_A      -       -           -
LGA    E    49_A      -       -           -
LGA    D    50_A      -       -           -
LGA    T    51_A      G      40          4.924
LGA    N    52_A      L      41          2.785
LGA    Q    53_A      T      42          0.920
LGA    L    54_A      L      43          0.898
LGA    R    55_A      Y      44          1.556
LGA    F    56_A      T      45          1.171
LGA    I    57_A      P      46          0.627
LGA    T    58_A      S      47          1.174
LGA    D    59_A      G      48          1.616
LGA    T    60_A      K      49          1.716
LGA    R    61_A      E      50          2.213
LGA    S    62_A      L      51          1.369
LGA    A    63_A      P      52          0.786
LGA    K    64_A      K      53          0.741
LGA    A    65_A      T      54          0.998
LGA    D    66_A      E      55          0.757
LGA    Q    67_A      E      56          0.648
LGA    I    68_A      V      57          0.654
LGA    Q    69_A      R      58          0.527
LGA    Q    70_A      R      59          0.413
LGA    Q    71_A      N      60          0.629
LGA    P    72_A      P      61          1.223
LGA    W    73_A      H      62          1.333
LGA    A    74_A      V      63          0.466
LGA    E    75_A      C      64          0.551
LGA    I    76_A      V      65          0.485
LGA    C    77_A      L      66          1.154
LGA    W    78_A      I      67          1.510
LGA    Y    79_A      G      68          3.386
LGA    F    80_A      Y      69          2.719
LGA    P    81_A      D      70          1.579
LGA    N    82_A      S      71          5.295
LGA    T    83_A      P      72           -
LGA    R    84_A      G      73          2.623
LGA    E    85_A      S      74          3.420
LGA    -       -      A      75           -
LGA    Q    86_A      F      76          2.121
LGA    F    87_A      L      77          0.660
LGA    R    88_A      E      78          0.563
LGA    X    89_A      I      79          0.340
LGA    A    90_A      N      80          0.696
LGA    G    91_A      G      81          0.990
LGA    D    92_A      L      82          0.736
LGA    L    93_A      A      83          0.755
LGA    T    94_A      S      84          1.651
LGA    L    95_A      L      85          1.301
LGA    I    96_A      E      86          2.989
LGA    S    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    D    99_A      -       -           -
LGA    D   100_A      -       -           -
LGA    S   101_A      -       -           -
LGA    H   102_A      E      87          2.477
LGA    Q   103_A      -       -           -
LGA    D   104_A      -       -           -
LGA    L   105_A      D      88          1.082
LGA    Q   106_A      E      89          1.000
LGA    P   107_A      S      90          0.684
LGA    A   108_A      I      91          0.167
LGA    R   109_A      K      92          0.140
LGA    I   110_A      E      93          0.920
LGA    A   111_A      R      94          1.027
LGA    X   112_A      I      95          1.101
LGA    W   113_A      W      96          1.054
LGA    Q   114_A      E      97          1.689
LGA    E   115_A      N      98          2.009
LGA    L   116_A      I      99          2.403
LGA    S   117_A      S     100          2.824
LGA    -       -      K     101           -
LGA    D   118_A      D     102          4.216
LGA    A   119_A      W     103           #
LGA    A   120_A      -       -           -
LGA    R   121_A      -       -           -
LGA    L   122_A      -       -           -
LGA    Q   123_A      -       -           -
LGA    F   124_A      -       -           -
LGA    G   125_A      -       -           -
LGA    W   126_A      -       -           -
LGA    P   127_A      -       -           -
LGA    Y   128_A      -       -           -
LGA    P   129_A      -       -           -
LGA    G   130_A      -       -           -
LGA    K   131_A      -       -           -
LGA    P   132_A      -       -           -
LGA    R   133_A      -       -           -
LGA    I   134_A      -       -           -
LGA    K   135_A      -       -           -
LGA    E   136_A      -       -           -
LGA    S   137_A      -       -           -
LGA    G   138_A      -       -           -
LGA    A   139_A      -       -           -
LGA    F   140_A      -       -           -
LGA    E   141_A      -       -           -
LGA    P   142_A      -       -           -
LGA    S   143_A      -       -           -
LGA    P   144_A      F     104           #
LGA    P   145_A      -       -           -
LGA    D   146_A      -       -           -
LGA    P   147_A      Q     105          3.721
LGA    I   148_A      G     106          3.048
LGA    E   149_A      E     107          4.906
LGA    P   150_A      D     108          2.829
LGA    V   151_A      S     109          1.171
LGA    P   152_A      P     110          1.426
LGA    N   153_A      S     111          0.974
LGA    F   154_A      F     112          0.544
LGA    C   155_A      V     113          0.892
LGA    L   156_A      V     114          1.241
LGA    L   157_A      I     115          1.241
LGA    L   158_A      K     116          1.100
LGA    L   159_A      I     117          0.700
LGA    D   160_A      V     118          0.631
LGA    P   161_A      P     119          0.305
LGA    V   162_A      E     120          0.761
LGA    Q   163_A      Q     121          0.461
LGA    V   164_A      I     122          0.854
LGA    D   165_A      R     123          1.303
LGA    H   166_A      I     124          0.872
LGA    L   167_A      L     125          1.127
LGA    E   168_A      N     126          2.360
LGA    L   169_A      S     127          4.822
LGA    R   170_A      -       -           -
LGA    G   171_A      -       -           -
LGA    E   172_A      -       -           -
LGA    P   173_A      -       -           -
LGA    Q   174_A      -       -           -
LGA    N   175_A      -       -           -
LGA    R   176_A      -       -           -
LGA    W   177_A      -       -           -
LGA    L   178_A      -       -           -
LGA    Y   179_A      -       -           -
LGA    H   180_A      -       -           -
LGA    R   181_A      -       -           -
LGA    N   182_A      -       -           -
LGA    D   183_A      -       -           -
LGA    Q   184_A      -       -           -
LGA    Q   185_A      -       -           -
LGA    E   186_A      -       -           -
LGA    W   187_A      -       -           -
LGA    S   188_A      -       -           -
LGA    S   189_A      -       -           -
LGA    E   190_A      -       -           -
LGA    A   191_A      -       -           -
LGA    I   192_A      -       -           -
LGA    N   193_A      -       -           -
LGA    P   194_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  194  124    5.0    116    1.98    18.97     81.736     5.567

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.585910 * X  +   0.386492 * Y  +   0.712273 * Z  +  -1.488509
  Y_new =  -0.763393 * X  +   0.031692 * Y  +  -0.645157 * Z  +  59.271183
  Z_new =  -0.271922 * X  +  -0.921748 * Y  +   0.276477 * Z  +  87.754807 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.279387    1.862206  [ DEG:   -73.3035    106.6965 ]
  Theta =   0.275389    2.866203  [ DEG:    15.7786    164.2214 ]
  Phi   =  -2.225409    0.916184  [ DEG:  -127.5065     52.4935 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i51_A                                        
REMARK     2: T0402.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i51_A.T0402.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  194  124   5.0  116   1.98   18.97  81.736
REMARK  ---------------------------------------------------------- 
MOLECULE 2i51_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   23-AUG-06   2I51              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED CONSERVED PROTEIN OF             
TITLE    2 COG5135 (ZP_00109616.1) FROM NOSTOC PUNCTIFORME PCC 73102            
TITLE    3 AT 1.40 A RESOLUTION                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED CONSERVED PROTEIN OF COG5135;              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NOSTOC PUNCTIFORME PCC 73102;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: ZP_00109616.1;                                                 
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ZP_00109616.1, UNCHARACTERIZED CONSERVED PROTEIN OF COG5135,          
KEYWDS   2 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   3 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI2                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   05-SEP-06 2I51    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED CONSERVED               
JRNL        TITL 2 PROTEIN OF COG5135 (ZP_00109616.1) FROM NOSTOC               
JRNL        TITL 3 PUNCTIFORME PCC 73102 AT 1.40 A RESOLUTION                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.40 ANGSTROMS.                                          
DBREF  2I51 A    1   181  UNP    Q8YQ04   Q8YQ04_ANASP     1    181             
DBREF  2I51 B    1   181  UNP    Q8YQ04   Q8YQ04_ANASP     1    181             
SEQRES   1 A  195  GLY MSE SER LEU ALA PRO TRP ARG GLY ALA ILE ALA HIS          
SEQRES   2 A  195  ALA LEU HIS ARG ASN ARG SER LEU VAL TYR ALA ARG TYR          
SEQRES   3 A  195  LEU GLN LEU ALA THR VAL GLN PRO ASN GLY ARG PRO ALA          
SEQRES   4 A  195  ASN ARG THR LEU VAL PHE ARG GLY PHE LEU GLU ASP THR          
SEQRES   5 A  195  ASN GLN LEU ARG PHE ILE THR ASP THR ARG SER ALA LYS          
SEQRES   6 A  195  ALA ASP GLN ILE GLN GLN GLN PRO TRP ALA GLU ILE CYS          
SEQRES   7 A  195  TRP TYR PHE PRO ASN THR ARG GLU GLN PHE ARG MSE ALA          
SEQRES   8 A  195  GLY ASP LEU THR LEU ILE SER SER ASP ASP SER HIS GLN          
SEQRES   9 A  195  ASP LEU GLN PRO ALA ARG ILE ALA MSE TRP GLN GLU LEU          
SEQRES  10 A  195  SER ASP ALA ALA ARG LEU GLN PHE GLY TRP PRO TYR PRO          
SEQRES  11 A  195  GLY LYS PRO ARG ILE LYS GLU SER GLY ALA PHE GLU PRO          
SEQRES  12 A  195  SER PRO PRO ASP PRO ILE GLU PRO VAL PRO ASN PHE CYS          
SEQRES  13 A  195  LEU LEU LEU LEU ASP PRO VAL GLN VAL ASP HIS LEU GLU          
SEQRES  14 A  195  LEU ARG GLY GLU PRO GLN ASN ARG TRP LEU TYR HIS ARG          
SEQRES  15 A  195  ASN ASP GLN GLN GLU TRP SER SER GLU ALA ILE ASN PRO          
SEQRES   1 B  195  GLY MSE SER LEU ALA PRO TRP ARG GLY ALA ILE ALA HIS          
SEQRES   2 B  195  ALA LEU HIS ARG ASN ARG SER LEU VAL TYR ALA ARG TYR          
SEQRES   3 B  195  LEU GLN LEU ALA THR VAL GLN PRO ASN GLY ARG PRO ALA          
SEQRES   4 B  195  ASN ARG THR LEU VAL PHE ARG GLY PHE LEU GLU ASP THR          
SEQRES   5 B  195  ASN GLN LEU ARG PHE ILE THR ASP THR ARG SER ALA LYS          
SEQRES   6 B  195  ALA ASP GLN ILE GLN GLN GLN PRO TRP ALA GLU ILE CYS          
SEQRES   7 B  195  TRP TYR PHE PRO ASN THR ARG GLU GLN PHE ARG MSE ALA          
SEQRES   8 B  195  GLY ASP LEU THR LEU ILE SER SER ASP ASP SER HIS GLN          
SEQRES   9 B  195  ASP LEU GLN PRO ALA ARG ILE ALA MSE TRP GLN GLU LEU          
SEQRES  10 B  195  SER ASP ALA ALA ARG LEU GLN PHE GLY TRP PRO TYR PRO          
SEQRES  11 B  195  GLY LYS PRO ARG ILE LYS GLU SER GLY ALA PHE GLU PRO          
SEQRES  12 B  195  SER PRO PRO ASP PRO ILE GLU PRO VAL PRO ASN PHE CYS          
SEQRES  13 B  195  LEU LEU LEU LEU ASP PRO VAL GLN VAL ASP HIS LEU GLU          
SEQRES  14 B  195  LEU ARG GLY GLU PRO GLN ASN ARG TRP LEU TYR HIS ARG          
SEQRES  15 B  195  ASN ASP GLN GLN GLU TRP SER SER GLU ALA ILE ASN PRO          
HET    MSE  A   1       5                                                       
HET    MSE  A  89      13                                                       
HET    MSE  A 112       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  89      13                                                       
HET    MSE  B 112       8                                                       
HET    FMN  A 300      31                                                       
HET    FMN  B 300      31                                                       
HET    EDO      2       4                                                       
HET    EDO      3       4                                                       
HET    EDO      4       4                                                       
HET    EDO      5       4                                                       
HET    EDO      6       6                                                       
HET    EDO      7       8                                                       
HET    EDO      8       4                                                       
HET    EDO      9       4                                                       
HET    EDO     10       4                                                       
HET    EDO     11       4                                                       
HET    EDO     12       4                                                       
HET    EDO     13       4                                                       
HET    EDO     14       4                                                       
HET    EDO     15       4                                                       
HET    EDO     16       4                                                       
HET    EDO     17       4                                                       
HET    EDO     18       4                                                       
HET    EDO     19       4                                                       
HET    EDO     20       4                                                       
HET    EDO     21       4                                                       
HET    GOL      1       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     FMN FLAVIN MONONUCLEOTIDE                                            
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     GOL GLYCEROL                                                         
HETSYN     FMN RIBOFLAVIN MONOPHOSPHATE                                         
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3  FMN    2(C17 H21 N4 O9 P)                                           
FORMUL   5  EDO    20(C2 H6 O2)                                                 
FORMUL  25  GOL    C3 H8 O3                                                     
FORMUL  26  HOH   *359(H2 O)                                                    
CRYST1   65.647   65.928  112.380  90.00  90.00  90.00 P 21 21 21    8          
HETATM    1  N   MSE A   1     -19.350  20.376  11.050  1.00 49.89           N  
HETATM    2  CA  MSE A   1     -20.644  20.420  11.807  1.00 48.25           C  
HETATM    3  C   MSE A   1     -21.076  19.008  12.195  1.00 45.22           C  
HETATM    4  O   MSE A   1     -21.503  18.776  13.331  1.00 50.28           O  
HETATM    5  CB  MSE A   1     -21.749  21.117  11.005  1.00 49.10           C  
ATOM      6  N   SER A   2     -20.988  18.061  11.268  1.00 35.95           N  
ATOM      7  CA  SER A   2     -21.137  16.663  11.668  1.00 31.21           C  
ATOM      8  C   SER A   2     -19.768  16.204  12.212  1.00 23.45           C  
ATOM      9  O   SER A   2     -18.717  16.733  11.812  1.00 20.56           O  
ATOM     10  CB  SER A   2     -21.616  15.784  10.526  1.00 34.13           C  
ATOM     11  OG  SER A   2     -20.587  15.480   9.622  1.00 40.99           O  
ATOM     12  N   LEU A   3     -19.810  15.288  13.166  1.00 20.63           N  
ATOM     13  CA  LEU A   3     -18.572  14.765  13.754  0.50 19.77           C  
ATOM     15  C   LEU A   3     -17.782  13.996  12.706  1.00 18.44           C  
ATOM     16  O   LEU A   3     -18.293  13.140  11.995  1.00 18.85           O  
ATOM     17  CB  LEU A   3     -18.858  13.874  14.984  0.50 22.46           C  
ATOM     19  CG  LEU A   3     -19.180  14.594  16.307  0.50 18.32           C  
ATOM     21  CD1 LEU A   3     -19.875  13.676  17.336  0.50 18.91           C  
ATOM     23  CD2 LEU A   3     -17.927  15.199  16.922  0.50 19.69           C  
ATOM     25  N   ALA A   4     -16.498  14.299  12.617  1.00 15.15           N  
ATOM     26  CA  ALA A   4     -15.645  13.591  11.691  1.00 16.31           C  
ATOM     27  C   ALA A   4     -15.514  12.148  12.145  1.00 15.65           C  
ATOM     28  O   ALA A   4     -15.580  11.834  13.341  1.00 15.30           O  
ATOM     29  CB  ALA A   4     -14.265  14.274  11.651  1.00 18.14           C  
ATOM     30  N   PRO A   5     -15.304  11.223  11.200  1.00 16.77           N  
ATOM     31  CA  PRO A   5     -15.361   9.798  11.498  1.00 17.79           C  
ATOM     32  C   PRO A   5     -14.228   9.256  12.348  1.00 16.35           C  
ATOM     33  O   PRO A   5     -14.302   8.129  12.809  1.00 18.15           O  
ATOM     34  CB  PRO A   5     -15.323   9.165  10.094  1.00 18.98           C  
ATOM     35  CG  PRO A   5     -14.662  10.150   9.250  1.00 20.71           C  
ATOM     36  CD  PRO A   5     -15.193  11.462   9.747  1.00 19.33           C  
ATOM     37  N   TRP A   6     -13.193  10.054  12.551  1.00 15.29           N  
ATOM     38  CA  TRP A   6     -12.060   9.713  13.395  1.00 14.25           C  
ATOM     39  C   TRP A   6     -12.206  10.276  14.800  1.00 14.16           C  
ATOM     40  O   TRP A   6     -11.345  10.024  15.660  1.00 14.66           O  
ATOM     41  CB  TRP A   6     -10.709  10.191  12.794  1.00 14.79           C  
ATOM     42  CG  TRP A   6     -10.767  11.581  12.204  1.00 14.87           C  
ATOM     43  CD1 TRP A   6     -10.937  11.883  10.901  1.00 15.85           C  
ATOM     44  CD2 TRP A   6     -10.711  12.840  12.906  1.00 15.27           C  
ATOM     45  NE1 TRP A   6     -10.988  13.226  10.734  1.00 15.33           N  
ATOM     46  CE2 TRP A   6     -10.858  13.858  11.933  1.00 14.61           C  
ATOM     47  CE3 TRP A   6     -10.521  13.212  14.239  1.00 15.97           C  
ATOM     48  CZ2 TRP A   6     -10.829  15.220  12.269  1.00 16.43           C  
ATOM     49  CZ3 TRP A   6     -10.521  14.547  14.581  1.00 16.80           C  
ATOM     50  CH2 TRP A   6     -10.686  15.548  13.585  1.00 15.69           C  
ATOM     51  N   ARG A   7     -13.310  10.977  15.071  1.00 13.42           N  
ATOM     52  CA  ARG A   7     -13.478  11.567  16.389  1.00 12.19           C  
ATOM     53  C   ARG A   7     -13.644  10.512  17.485  1.00 13.31           C  
ATOM     54  O   ARG A   7     -13.114  10.689  18.592  1.00 14.64           O  
ATOM     55  CB  ARG A   7     -14.631  12.565  16.433  1.00 13.74           C  
ATOM     56  CG  ARG A   7     -14.323  13.860  15.732  1.00 14.12           C  
ATOM     57  CD  ARG A   7     -13.469  14.761  16.521  1.00 15.16           C  
ATOM     58  NE  ARG A   7     -14.004  15.257  17.801  1.00 13.37           N  
ATOM     59  CZ  ARG A   7     -14.722  16.372  17.929  1.00 14.22           C  
ATOM     60  NH1 ARG A   7     -15.077  17.080  16.870  1.00 15.51           N  
ATOM     61  NH2 ARG A   7     -15.086  16.804  19.128  1.00 17.69           N  
ATOM     62  N   GLY A   8     -14.348   9.435  17.195  1.00 12.49           N  
ATOM     63  CA  GLY A   8     -14.461   8.369  18.162  1.00 13.55           C  
ATOM     64  C   GLY A   8     -13.140   7.728  18.509  1.00 14.01           C  
ATOM     65  O   GLY A   8     -12.868   7.425  19.685  1.00 14.86           O  
ATOM     66  N   ALA A   9     -12.284   7.563  17.499  1.00 14.88           N  
ATOM     67  CA  ALA A   9     -10.954   6.980  17.700  1.00 14.54           C  
ATOM     68  C   ALA A   9     -10.146   7.867  18.634  1.00 12.66           C  
ATOM     69  O   ALA A   9      -9.438   7.388  19.569  1.00 13.24           O  
ATOM     70  CB  ALA A   9     -10.224   6.765  16.347  1.00 17.42           C  
ATOM     71  N   ILE A  10     -10.176   9.175  18.386  1.00 12.84           N  
ATOM     72  CA  ILE A  10      -9.480  10.119  19.246  0.50 11.83           C  
ATOM     74  C   ILE A  10     -10.016  10.063  20.681  1.00 13.99           C  
ATOM     75  O   ILE A  10      -9.264  10.080  21.643  1.00 14.54           O  
ATOM     76  CB  ILE A  10      -9.584  11.598  18.712  0.50 11.81           C  
ATOM     78  CG1 ILE A  10      -8.593  11.725  17.534  0.50 13.37           C  
ATOM     80  CG2 ILE A  10      -9.263  12.652  19.823  0.50  9.96           C  
ATOM     82  CD1 ILE A  10      -7.148  11.800  17.941  0.50 11.74           C  
ATOM     84  N   ALA A  11     -11.358  10.013  20.814  1.00 13.80           N  
ATOM     85  CA  ALA A  11     -11.937   9.964  22.143  1.00 14.19           C  
ATOM     86  C   ALA A  11     -11.487   8.725  22.889  1.00 14.17           C  
ATOM     87  O   ALA A  11     -11.211   8.762  24.081  1.00 14.32           O  
ATOM     88  CB  ALA A  11     -13.467  10.000  22.048  1.00 14.56           C  
ATOM     89  N   HIS A  12     -11.434   7.606  22.185  1.00 12.77           N  
ATOM     90  CA  HIS A  12     -11.018   6.314  22.812  1.00 12.23           C  
ATOM     91  C   HIS A  12      -9.546   6.360  23.168  1.00 13.91           C  
ATOM     92  O   HIS A  12      -9.152   5.779  24.189  1.00 14.57           O  
ATOM     93  CB  HIS A  12     -11.358   5.169  21.861  1.00 13.79           C  
ATOM     94  CG  HIS A  12     -11.221   3.811  22.474  1.00 13.27           C  
ATOM     95  ND1 HIS A  12     -10.791   2.683  21.792  1.00 21.18           N  
ATOM     96  CD2 HIS A  12     -11.664   3.376  23.672  1.00 11.19           C  
ATOM     97  CE1 HIS A  12     -10.904   1.628  22.599  1.00 13.26           C  
ATOM     98  NE2 HIS A  12     -11.421   2.037  23.743  1.00 17.64           N  
ATOM     99  N   ALA A  13      -8.708   6.996  22.366  1.00 13.98           N  
ATOM    100  CA  ALA A  13      -7.292   7.132  22.702  1.00 13.08           C  
ATOM    101  C   ALA A  13      -7.110   8.033  23.916  1.00 13.66           C  
ATOM    102  O   ALA A  13      -6.402   7.678  24.875  1.00 13.95           O  
ATOM    103  CB  ALA A  13      -6.511   7.669  21.484  1.00 13.08           C  
ATOM    104  N   LEU A  14      -7.803   9.171  23.920  1.00 12.54           N  
ATOM    105  CA  LEU A  14      -7.676  10.089  25.060  1.00 14.17           C  
ATOM    106  C   LEU A  14      -8.124   9.398  26.344  1.00 14.56           C  
ATOM    107  O   LEU A  14      -7.452   9.467  27.380  1.00 15.45           O  
ATOM    108  CB  LEU A  14      -8.532  11.343  24.830  1.00 14.45           C  
ATOM    109  CG  LEU A  14      -7.943  12.322  23.825  1.00 15.71           C  
ATOM    110  CD1 LEU A  14      -9.028  13.280  23.340  1.00 17.56           C  
ATOM    111  CD2 LEU A  14      -6.741  13.074  24.435  1.00 16.11           C  
ATOM    112  N   HIS A  15      -9.248   8.700  26.317  1.00 14.60           N  
ATOM    113  CA  HIS A  15      -9.737   8.048  27.497  1.00 13.04           C  
ATOM    114  C   HIS A  15      -8.772   6.990  28.034  1.00 13.03           C  
ATOM    115  O   HIS A  15      -8.521   6.902  29.241  1.00 14.86           O  
ATOM    116  CB  HIS A  15     -11.136   7.496  27.249  1.00 13.76           C  
ATOM    117  CG  HIS A  15     -11.739   6.854  28.435  1.00 15.34           C  
ATOM    118  ND1 HIS A  15     -12.029   7.567  29.581  1.00 16.55           N  
ATOM    119  CD2 HIS A  15     -12.096   5.572  28.665  1.00 15.52           C  
ATOM    120  CE1 HIS A  15     -12.538   6.722  30.479  1.00 18.15           C  
ATOM    121  NE2 HIS A  15     -12.581   5.505  29.950  1.00 18.17           N  
ATOM    122  N   ARG A  16      -8.243   6.159  27.146  1.00 14.13           N  
ATOM    123  CA  ARG A  16      -7.392   5.055  27.562  1.00 13.52           C  
ATOM    124  C   ARG A  16      -6.002   5.512  27.928  1.00 16.73           C  
ATOM    125  O   ARG A  16      -5.239   4.730  28.498  1.00 19.78           O  
ATOM    126  CB  ARG A  16      -7.326   3.994  26.482  1.00 14.37           C  
ATOM    127  CG  ARG A  16      -8.580   3.213  26.309  1.00 13.67           C  
ATOM    128  CD  ARG A  16      -8.409   2.122  25.305  1.00 15.08           C  
ATOM    129  NE  ARG A  16      -8.115   2.729  24.022  1.00 19.17           N  
ATOM    130  CZ  ARG A  16      -7.754   2.092  22.923  1.00 23.12           C  
ATOM    131  NH1 ARG A  16      -7.685   0.783  22.886  1.00 20.81           N  
ATOM    132  NH2 ARG A  16      -7.504   2.813  21.829  1.00 24.38           N  
ATOM    133  N   ASN A  17      -5.686   6.766  27.681  1.00 14.39           N  
ATOM    134  CA  ASN A  17      -4.403   7.365  28.066  1.00 15.94           C  
ATOM    135  C   ASN A  17      -4.519   8.425  29.158  1.00 18.56           C  
ATOM    136  O   ASN A  17      -3.556   9.144  29.425  1.00 17.77           O  
ATOM    137  CB  ASN A  17      -3.655   7.920  26.841  1.00 15.87           C  
ATOM    138  CG  ASN A  17      -3.136   6.842  25.948  1.00 16.62           C  
ATOM    139  OD1 ASN A  17      -1.945   6.517  26.009  1.00 21.72           O  
ATOM    140  ND2 ASN A  17      -3.979   6.263  25.120  1.00 15.32           N  
ATOM    141  N   ARG A  18      -5.676   8.522  29.808  1.00 16.71           N  
ATOM    142  CA  ARG A  18      -5.965   9.598  30.743  1.00 19.09           C  
ATOM    143  C   ARG A  18      -5.051   9.564  31.986  1.00 18.23           C  
ATOM    144  O   ARG A  18      -4.957  10.620  32.637  1.00 21.86           O  
ATOM    145  CB  ARG A  18      -7.434   9.562  31.137  1.00 19.26           C  
ATOM    146  CG  ARG A  18      -7.847   8.435  31.970  1.00 19.50           C  
ATOM    147  CD  ARG A  18      -9.386   8.424  32.135  1.00 20.81           C  
ATOM    148  NE  ARG A  18      -9.832   7.368  33.010  1.00 22.90           N  
ATOM    149  CZ  ARG A  18      -9.881   6.080  32.728  1.00 24.30           C  
ATOM    150  NH1 ARG A  18      -9.550   5.584  31.543  1.00 19.05           N  
ATOM    151  NH2 ARG A  18     -10.322   5.236  33.660  1.00 34.63           N  
ATOM    152  N   SER A  19      -4.409   8.435  32.275  1.00 17.98           N  
ATOM    153  CA  SER A  19      -3.504   8.325  33.458  1.00 20.51           C  
ATOM    154  C   SER A  19      -2.191   9.065  33.170  1.00 21.23           C  
ATOM    155  O   SER A  19      -1.399   9.281  34.099  1.00 22.89           O  
ATOM    156  CB  SER A  19      -3.202   6.882  33.799  1.00 19.44           C  
ATOM    157  OG  SER A  19      -2.545   6.186  32.778  1.00 25.42           O  
ATOM    158  N   LEU A  20      -1.926   9.380  31.899  1.00 19.62           N  
ATOM    159  CA  LEU A  20      -0.672  10.056  31.505  1.00 18.99           C  
ATOM    160  C   LEU A  20      -0.947  11.488  31.134  1.00 18.15           C  
ATOM    161  O   LEU A  20      -1.578  11.760  30.091  1.00 19.39           O  
ATOM    162  CB  LEU A  20      -0.033   9.336  30.355  1.00 19.07           C  
ATOM    163  CG  LEU A  20       0.168   7.831  30.467  1.00 20.77           C  
ATOM    164  CD1 LEU A  20       0.714   7.299  29.132  1.00 24.39           C  
ATOM    165  CD2 LEU A  20       1.091   7.449  31.637  1.00 22.63           C  
ATOM    166  N   VAL A  21      -0.477  12.437  31.945  1.00 19.31           N  
ATOM    167  CA  VAL A  21      -0.712  13.854  31.650  1.00 19.75           C  
ATOM    168  C   VAL A  21      -0.230  14.217  30.237  1.00 17.74           C  
ATOM    169  O   VAL A  21      -0.848  15.002  29.490  1.00 20.05           O  
ATOM    170  CB  VAL A  21      -0.018  14.790  32.672  1.00 26.27           C  
ATOM    171  CG1 VAL A  21      -0.131  16.283  32.239  1.00 30.90           C  
ATOM    172  CG2 VAL A  21      -0.613  14.581  34.059  1.00 29.93           C  
ATOM    173  N   TYR A  22       0.900  13.617  29.881  1.00 17.56           N  
ATOM    174  CA  TYR A  22       1.569  13.898  28.644  1.00 17.54           C  
ATOM    175  C   TYR A  22       0.973  13.264  27.379  1.00 16.64           C  
ATOM    176  O   TYR A  22       1.445  13.456  26.259  1.00 19.29           O  
ATOM    177  CB  TYR A  22       3.056  13.529  28.760  1.00 19.69           C  
ATOM    178  CG  TYR A  22       3.360  12.171  29.356  1.00 18.06           C  
ATOM    179  CD1 TYR A  22       3.451  11.068  28.546  1.00 16.88           C  
ATOM    180  CD2 TYR A  22       3.615  12.021  30.712  1.00 18.26           C  
ATOM    181  CE1 TYR A  22       3.764   9.859  29.060  1.00 16.95           C  
ATOM    182  CE2 TYR A  22       4.006  10.823  31.230  1.00 16.89           C  
ATOM    183  CZ  TYR A  22       4.062   9.732  30.420  1.00 17.47           C  
ATOM    184  OH  TYR A  22       4.434   8.502  30.971  1.00 19.37           O  
ATOM    185  N   ALA A  23      -0.075  12.484  27.544  1.00 16.10           N  
ATOM    186  CA  ALA A  23      -0.788  11.959  26.382  1.00 17.38           C  
ATOM    187  C   ALA A  23      -1.557  13.081  25.680  1.00 16.78           C  
ATOM    188  O   ALA A  23      -2.032  12.865  24.585  1.00 19.10           O  
ATOM    189  CB  ALA A  23      -1.735  10.868  26.785  1.00 20.70           C  
ATOM    190  N   ARG A  24      -1.681  14.253  26.307  1.00 16.12           N  
ATOM    191  CA  ARG A  24      -2.269  15.424  25.662  1.00 16.50           C  
ATOM    192  C   ARG A  24      -1.201  16.316  25.025  1.00 15.58           C  
ATOM    193  O   ARG A  24      -1.527  17.399  24.528  1.00 18.28           O  
ATOM    194  CB  ARG A  24      -3.162  16.170  26.597  1.00 21.85           C  
ATOM    195  CG  ARG A  24      -4.421  15.275  26.916  1.00 26.06           C  
ATOM    196  CD  ARG A  24      -5.277  15.843  27.980  1.00 33.43           C  
ATOM    197  NE  ARG A  24      -5.872  17.072  27.498  1.00 31.94           N  
ATOM    198  CZ  ARG A  24      -7.094  17.201  26.972  1.00 34.90           C  
ATOM    199  NH1 ARG A  24      -7.921  16.164  26.867  1.00 30.55           N  
ATOM    200  NH2 ARG A  24      -7.497  18.406  26.559  1.00 35.97           N  
ATOM    201  N   TYR A  25       0.030  15.841  24.927  1.00 14.72           N  
ATOM    202  CA  TYR A  25       1.084  16.592  24.275  1.00 14.80           C  
ATOM    203  C   TYR A  25       1.293  16.015  22.881  1.00 16.03           C  
ATOM    204  O   TYR A  25       1.317  14.782  22.683  1.00 17.77           O  
ATOM    205  CB  TYR A  25       2.394  16.494  25.038  1.00 15.18           C  
ATOM    206  CG  TYR A  25       2.385  16.965  26.449  1.00 14.89           C  
ATOM    207  CD1 TYR A  25       1.382  17.745  26.953  1.00 17.04           C  
ATOM    208  CD2 TYR A  25       3.406  16.585  27.295  1.00 16.60           C  
ATOM    209  CE1 TYR A  25       1.395  18.131  28.312  1.00 20.36           C  
ATOM    210  CE2 TYR A  25       3.436  16.958  28.595  1.00 16.60           C  
ATOM    211  CZ  TYR A  25       2.446  17.726  29.096  1.00 18.93           C  
ATOM    212  OH  TYR A  25       2.469  18.108  30.452  1.00 21.86           O  
ATOM    213  N   LEU A  26       1.415  16.871  21.878  1.00 14.58           N  
ATOM    214  CA  LEU A  26       1.557  16.414  20.509  1.00 13.59           C  
ATOM    215  C   LEU A  26       2.550  17.317  19.791  1.00 14.70           C  
ATOM    216  O   LEU A  26       2.890  18.419  20.268  1.00 14.33           O  
ATOM    217  CB  LEU A  26       0.203  16.341  19.807  1.00 15.24           C  
ATOM    218  CG  LEU A  26      -0.643  17.611  19.740  1.00 14.81           C  
ATOM    219  CD1 LEU A  26      -0.037  18.594  18.713  1.00 16.29           C  
ATOM    220  CD2 LEU A  26      -2.147  17.264  19.373  1.00 16.23           C  
ATOM    221  N   GLN A  27       3.027  16.902  18.634  1.00 14.53           N  
ATOM    222  CA  GLN A  27       4.050  17.635  17.898  1.00 13.88           C  
ATOM    223  C   GLN A  27       3.494  18.276  16.650  1.00 14.70           C  
ATOM    224  O   GLN A  27       2.915  17.559  15.791  1.00 16.13           O  
ATOM    225  CB  GLN A  27       5.249  16.728  17.591  1.00 15.01           C  
ATOM    226  CG  GLN A  27       6.046  16.338  18.826  1.00 14.02           C  
ATOM    227  CD  GLN A  27       5.359  15.414  19.770  1.00 16.50           C  
ATOM    228  OE1 GLN A  27       4.687  14.456  19.340  1.00 16.84           O  
ATOM    229  NE2 GLN A  27       5.464  15.695  21.088  1.00 17.08           N  
ATOM    230  N   LEU A  28       3.690  19.584  16.523  1.00 13.59           N  
ATOM    231  CA  LEU A  28       3.158  20.308  15.369  1.00 14.39           C  
ATOM    232  C   LEU A  28       4.306  20.688  14.459  1.00 13.58           C  
ATOM    233  O   LEU A  28       5.232  21.449  14.830  1.00 14.94           O  
ATOM    234  CB  LEU A  28       2.499  21.603  15.830  1.00 16.96           C  
ATOM    235  CG  LEU A  28       2.084  22.576  14.696  1.00 17.48           C  
ATOM    236  CD1 LEU A  28       0.784  22.086  14.183  1.00 26.65           C  
ATOM    237  CD2 LEU A  28       2.038  24.043  15.193  1.00 22.13           C  
ATOM    238  N   ALA A  29       4.236  20.203  13.208  1.00 12.61           N  
ATOM    239  CA  ALA A  29       5.218  20.539  12.199  1.00 12.98           C  
ATOM    240  C   ALA A  29       4.668  21.609  11.276  1.00 15.20           C  
ATOM    241  O   ALA A  29       3.561  21.507  10.770  1.00 15.38           O  
ATOM    242  CB  ALA A  29       5.578  19.269  11.348  1.00 16.09           C  
ATOM    243  N   THR A  30       5.500  22.605  11.009  1.00 13.90           N  
ATOM    244  CA  THR A  30       5.222  23.657  10.068  1.00 16.10           C  
ATOM    245  C   THR A  30       6.402  23.771   9.103  1.00 16.67           C  
ATOM    246  O   THR A  30       7.394  23.027   9.228  1.00 14.74           O  
ATOM    247  CB  THR A  30       5.078  25.026  10.818  1.00 14.92           C  
ATOM    248  OG1 THR A  30       6.252  25.241  11.653  1.00 16.29           O  
ATOM    249  CG2 THR A  30       3.814  25.109  11.634  1.00 16.82           C  
ATOM    250  N   VAL A  31       6.284  24.652   8.099  1.00 16.55           N  
ATOM    251  CA  VAL A  31       7.381  24.914   7.172  1.00 16.89           C  
ATOM    252  C   VAL A  31       7.793  26.370   7.340  1.00 16.11           C  
ATOM    253  O   VAL A  31       6.936  27.296   7.461  1.00 19.16           O  
ATOM    254  CB  VAL A  31       7.019  24.573   5.692  1.00 20.08           C  
ATOM    255  CG1 VAL A  31       8.244  24.702   4.750  1.00 20.53           C  
ATOM    256  CG2 VAL A  31       6.542  23.173   5.566  1.00 26.32           C  
ATOM    257  N   GLN A  32       9.108  26.596   7.389  1.00 16.16           N  
ATOM    258  CA  GLN A  32       9.651  27.942   7.489  1.00 19.54           C  
ATOM    259  C   GLN A  32       9.638  28.627   6.112  1.00 18.73           C  
ATOM    260  O   GLN A  32       9.572  27.963   5.084  1.00 19.26           O  
ATOM    261  CB  GLN A  32      11.064  27.888   8.053  1.00 19.56           C  
ATOM    262  CG  GLN A  32      11.124  27.218   9.417  1.00 21.46           C  
ATOM    263  CD  GLN A  32      12.541  26.997   9.901  1.00 26.37           C  
ATOM    264  OE1 GLN A  32      13.302  27.961  10.137  1.00 32.11           O  
ATOM    265  NE2 GLN A  32      12.933  25.740  10.007  1.00 22.18           N  
ATOM    266  N   PRO A  33       9.690  29.966   6.095  1.00 19.66           N  
ATOM    267  CA  PRO A  33       9.845  30.692   4.834  1.00 23.31           C  
ATOM    268  C   PRO A  33      11.006  30.185   3.973  1.00 23.68           C  
ATOM    269  O   PRO A  33      10.932  30.236   2.733  1.00 25.27           O  
ATOM    270  CB  PRO A  33      10.079  32.139   5.282  1.00 23.67           C  
ATOM    271  CG  PRO A  33       9.398  32.230   6.619  1.00 24.37           C  
ATOM    272  CD  PRO A  33       9.493  30.867   7.247  1.00 21.34           C  
ATOM    273  N   ASN A  34      12.083  29.722   4.602  1.00 22.45           N  
ATOM    274  CA  ASN A  34      13.221  29.202   3.844  1.00 22.63           C  
ATOM    275  C   ASN A  34      13.023  27.762   3.310  1.00 23.67           C  
ATOM    276  O   ASN A  34      13.921  27.210   2.671  1.00 23.04           O  
ATOM    277  CB  ASN A  34      14.527  29.289   4.659  1.00 24.32           C  
ATOM    278  CG  ASN A  34      14.534  28.369   5.875  1.00 28.59           C  
ATOM    279  OD1 ASN A  34      13.648  27.520   6.050  1.00 21.32           O  
ATOM    280  ND2 ASN A  34      15.547  28.534   6.722  1.00 32.33           N  
ATOM    281  N   GLY A  35      11.855  27.170   3.557  1.00 20.19           N  
ATOM    282  CA  GLY A  35      11.508  25.868   2.995  1.00 20.35           C  
ATOM    283  C   GLY A  35      11.810  24.694   3.939  1.00 18.93           C  
ATOM    284  O   GLY A  35      11.510  23.550   3.643  1.00 21.91           O  
ATOM    285  N   ARG A  36      12.481  24.967   5.038  1.00 17.21           N  
ATOM    286  CA  ARG A  36      12.855  23.884   5.964  1.00 16.31           C  
ATOM    287  C   ARG A  36      11.709  23.641   6.965  1.00 15.67           C  
ATOM    288  O   ARG A  36      10.990  24.551   7.351  1.00 15.75           O  
ATOM    289  CB  ARG A  36      14.108  24.261   6.741  1.00 15.94           C  
ATOM    290  CG  ARG A  36      15.363  24.377   5.841  1.00 17.26           C  
ATOM    291  CD  ARG A  36      16.542  24.861   6.663  1.00 24.85           C  
ATOM    292  NE  ARG A  36      17.762  24.779   5.837  1.00 30.70           N  
ATOM    293  CZ  ARG A  36      18.978  25.195   6.192  1.00 37.26           C  
ATOM    294  NH1 ARG A  36      19.205  25.761   7.374  1.00 36.55           N  
ATOM    295  NH2 ARG A  36      19.979  25.038   5.341  1.00 40.33           N  
ATOM    296  N   PRO A  37      11.566  22.408   7.461  1.00 14.94           N  
ATOM    297  CA  PRO A  37      10.525  22.084   8.441  1.00 14.78           C  
ATOM    298  C   PRO A  37      10.906  22.609   9.815  1.00 17.32           C  
ATOM    299  O   PRO A  37      12.073  22.896  10.113  1.00 17.62           O  
ATOM    300  CB  PRO A  37      10.533  20.563   8.437  1.00 15.70           C  
ATOM    301  CG  PRO A  37      11.936  20.234   8.107  1.00 18.20           C  
ATOM    302  CD  PRO A  37      12.402  21.238   7.139  1.00 17.81           C  
ATOM    303  N   ALA A  38       9.890  22.708  10.661  1.00 14.69           N  
ATOM    304  CA  ALA A  38      10.026  23.038  12.092  1.00 16.00           C  
ATOM    305  C   ALA A  38       9.048  22.155  12.825  1.00 15.89           C  
ATOM    306  O   ALA A  38       8.010  21.795  12.294  1.00 17.27           O  
ATOM    307  CB  ALA A  38       9.743  24.535  12.384  1.00 17.46           C  
ATOM    308  N   ASN A  39       9.395  21.779  14.029  1.00 12.94           N  
ATOM    309  CA  ASN A  39       8.621  20.788  14.768  1.00 13.35           C  
ATOM    310  C   ASN A  39       8.759  21.050  16.258  1.00 14.81           C  
ATOM    311  O   ASN A  39       9.866  21.117  16.753  1.00 16.07           O  
ATOM    312  CB  ASN A  39       9.182  19.417  14.413  1.00 14.40           C  
ATOM    313  CG  ASN A  39       8.221  18.261  14.686  1.00 16.91           C  
ATOM    314  OD1 ASN A  39       7.046  18.460  15.007  1.00 16.64           O  
ATOM    315  ND2 ASN A  39       8.751  17.001  14.511  1.00 17.16           N  
ATOM    316  N   ARG A  40       7.632  21.162  16.964  1.00 13.29           N  
ATOM    317  CA  ARG A  40       7.673  21.381  18.427  1.00 13.53           C  
ATOM    318  C   ARG A  40       6.450  20.845  19.089  1.00 13.01           C  
ATOM    319  O   ARG A  40       5.395  20.715  18.470  1.00 14.64           O  
ATOM    320  CB  ARG A  40       7.847  22.855  18.766  1.00 14.98           C  
ATOM    321  CG  ARG A  40       6.618  23.684  18.695  1.00 14.45           C  
ATOM    322  CD  ARG A  40       6.118  23.952  17.287  1.00 14.32           C  
ATOM    323  NE  ARG A  40       6.973  24.823  16.503  1.00 14.18           N  
ATOM    324  CZ  ARG A  40       6.926  25.029  15.188  1.00 13.73           C  
ATOM    325  NH1 ARG A  40       6.203  24.247  14.368  1.00 16.14           N  
ATOM    326  NH2 ARG A  40       7.661  25.979  14.680  1.00 17.41           N  
ATOM    327  N   THR A  41       6.571  20.588  20.388  1.00 13.52           N  
ATOM    328  CA  THR A  41       5.482  20.076  21.171  1.00 13.52           C  
ATOM    329  C   THR A  41       4.530  21.197  21.590  1.00 15.19           C  
ATOM    330  O   THR A  41       5.004  22.295  21.968  1.00 14.27           O  
ATOM    331  CB  THR A  41       6.005  19.340  22.422  1.00 15.18           C  
ATOM    332  OG1 THR A  41       6.893  18.285  22.003  1.00 16.01           O  
ATOM    333  CG2 THR A  41       4.863  18.722  23.251  1.00 15.59           C  
ATOM    334  N   LEU A  42       3.230  20.908  21.535  1.00 15.31           N  
ATOM    335  CA  LEU A  42       2.211  21.765  22.087  1.00 14.88           C  
ATOM    336  C   LEU A  42       1.288  20.936  22.944  1.00 15.71           C  
ATOM    337  O   LEU A  42       1.218  19.726  22.802  1.00 16.09           O  
ATOM    338  CB  LEU A  42       1.323  22.376  21.006  1.00 15.35           C  
ATOM    339  CG  LEU A  42       2.024  23.031  19.828  1.00 21.87           C  
ATOM    340  CD1 LEU A  42       0.974  23.427  18.739  1.00 22.20           C  
ATOM    341  CD2 LEU A  42       2.767  24.163  20.366  1.00 21.42           C  
ATOM    342  N   VAL A  43       0.530  21.569  23.839  1.00 15.60           N  
ATOM    343  CA  VAL A  43      -0.563  20.917  24.573  1.00 15.54           C  
ATOM    344  C   VAL A  43      -1.868  20.989  23.816  1.00 15.44           C  
ATOM    345  O   VAL A  43      -2.295  22.086  23.420  1.00 15.79           O  
ATOM    346  CB  VAL A  43      -0.766  21.634  25.930  1.00 15.63           C  
ATOM    347  CG1 VAL A  43      -1.941  20.985  26.736  1.00 19.86           C  
ATOM    348  CG2 VAL A  43       0.539  21.619  26.758  1.00 19.44           C  
ATOM    349  N   PHE A  44      -2.513  19.848  23.577  1.00 14.99           N  
ATOM    350  CA  PHE A  44      -3.850  19.813  23.025  1.00 13.80           C  
ATOM    351  C   PHE A  44      -4.828  20.346  24.073  1.00 14.07           C  
ATOM    352  O   PHE A  44      -4.872  19.876  25.195  1.00 15.64           O  
ATOM    353  CB  PHE A  44      -4.192  18.358  22.725  1.00 16.55           C  
ATOM    354  CG  PHE A  44      -5.626  18.111  22.379  1.00 13.58           C  
ATOM    355  CD1 PHE A  44      -6.154  18.584  21.180  1.00 15.85           C  
ATOM    356  CD2 PHE A  44      -6.432  17.389  23.225  1.00 17.47           C  
ATOM    357  CE1 PHE A  44      -7.480  18.321  20.874  1.00 16.76           C  
ATOM    358  CE2 PHE A  44      -7.738  17.113  22.906  1.00 17.14           C  
ATOM    359  CZ  PHE A  44      -8.246  17.559  21.733  1.00 14.95           C  
ATOM    360  N   ARG A  45      -5.640  21.300  23.638  1.00 14.89           N  
ATOM    361  CA  ARG A  45      -6.597  21.974  24.516  0.50 16.15           C  
ATOM    363  C   ARG A  45      -8.046  21.733  24.113  1.00 18.59           C  
ATOM    364  O   ARG A  45      -8.898  22.627  24.250  1.00 17.82           O  
ATOM    365  CB  ARG A  45      -6.281  23.465  24.561  0.50 15.91           C  
ATOM    367  CG  ARG A  45      -4.805  23.716  24.877  0.50 21.59           C  
ATOM    369  CD  ARG A  45      -4.544  24.912  25.686  0.50 22.23           C  
ATOM    371  NE  ARG A  45      -3.202  24.958  26.279  0.50 13.34           N  
ATOM    373  CZ  ARG A  45      -2.964  24.926  27.601  0.50 13.00           C  
ATOM    375  NH1 ARG A  45      -3.946  24.764  28.464  0.50 16.65           N  
ATOM    377  NH2 ARG A  45      -1.729  24.990  28.067  0.50 20.19           N  
ATOM    379  N   GLY A  46      -8.349  20.545  23.590  1.00 16.15           N  
ATOM    380  CA  GLY A  46      -9.694  20.182  23.226  1.00 15.71           C  
ATOM    381  C   GLY A  46     -10.089  20.592  21.822  1.00 15.83           C  
ATOM    382  O   GLY A  46      -9.376  21.297  21.137  1.00 18.95           O  
ATOM    383  N   PHE A  47     -11.237  20.115  21.375  1.00 15.48           N  
ATOM    384  CA  PHE A  47     -11.870  20.593  20.164  1.00 14.10           C  
ATOM    385  C   PHE A  47     -12.697  21.848  20.408  1.00 16.79           C  
ATOM    386  O   PHE A  47     -13.310  22.005  21.458  1.00 18.39           O  
ATOM    387  CB  PHE A  47     -12.757  19.494  19.610  1.00 15.69           C  
ATOM    388  CG  PHE A  47     -11.954  18.294  19.089  1.00 15.01           C  
ATOM    389  CD1 PHE A  47     -11.455  18.277  17.794  1.00 16.88           C  
ATOM    390  CD2 PHE A  47     -11.669  17.233  19.936  1.00 15.59           C  
ATOM    391  CE1 PHE A  47     -10.693  17.187  17.331  1.00 17.41           C  
ATOM    392  CE2 PHE A  47     -10.888  16.171  19.488  1.00 16.24           C  
ATOM    393  CZ  PHE A  47     -10.391  16.172  18.213  1.00 15.51           C  
ATOM    394  N   LEU A  48     -12.758  22.679  19.380  1.00 17.06           N  
ATOM    395  CA  LEU A  48     -13.587  23.866  19.410  1.00 16.49           C  
ATOM    396  C   LEU A  48     -15.006  23.378  19.282  1.00 17.25           C  
ATOM    397  O   LEU A  48     -15.326  22.574  18.420  1.00 16.66           O  
ATOM    398  CB  LEU A  48     -13.216  24.780  18.261  1.00 16.02           C  
ATOM    399  CG  LEU A  48     -14.041  26.027  18.112  1.00 18.34           C  
ATOM    400  CD1 LEU A  48     -13.891  26.922  19.372  1.00 21.93           C  
ATOM    401  CD2 LEU A  48     -13.593  26.717  16.836  1.00 19.75           C  
ATOM    402  N   GLU A  49     -15.883  23.908  20.113  1.00 18.79           N  
ATOM    403  CA  GLU A  49     -17.248  23.414  20.193  0.50 20.70           C  
ATOM    405  C   GLU A  49     -17.947  23.506  18.842  1.00 20.20           C  
ATOM    406  O   GLU A  49     -17.766  24.482  18.072  1.00 19.58           O  
ATOM    407  CB  GLU A  49     -18.031  24.167  21.260  0.50 22.96           C  
ATOM    409  CG  GLU A  49     -18.056  25.645  21.040  0.50 21.42           C  
ATOM    411  N   ASP A  50     -18.724  22.469  18.536  1.00 21.46           N  
ATOM    412  CA  ASP A  50     -19.436  22.364  17.302  1.00 24.58           C  
ATOM    413  C   ASP A  50     -18.593  22.333  16.044  1.00 20.32           C  
ATOM    414  O   ASP A  50     -19.091  22.585  14.936  1.00 22.68           O  
ATOM    415  CB  ASP A  50     -20.507  23.449  17.199  1.00 26.61           C  
ATOM    416  CG  ASP A  50     -21.889  22.864  17.343  1.00 43.68           C  
ATOM    417  OD1 ASP A  50     -22.134  22.153  18.361  1.00 47.70           O  
ATOM    418  OD2 ASP A  50     -22.694  23.068  16.410  1.00 59.24           O  
ATOM    419  N   THR A  51     -17.318  21.957  16.193  1.00 17.29           N  
ATOM    420  CA  THR A  51     -16.450  21.795  15.050  1.00 16.13           C  
ATOM    421  C   THR A  51     -15.557  20.575  15.285  1.00 16.31           C  
ATOM    422  O   THR A  51     -15.554  19.993  16.388  1.00 17.43           O  
ATOM    423  CB  THR A  51     -15.501  22.974  14.850  1.00 19.51           C  
ATOM    424  OG1 THR A  51     -14.426  22.896  15.764  1.00 18.95           O  
ATOM    425  CG2 THR A  51     -16.234  24.373  15.012  1.00 18.29           C  
ATOM    426  N   ASN A  52     -14.791  20.236  14.252  1.00 16.96           N  
ATOM    427  CA  ASN A  52     -13.727  19.223  14.311  1.00 15.36           C  
ATOM    428  C   ASN A  52     -12.318  19.856  14.383  1.00 15.20           C  
ATOM    429  O   ASN A  52     -11.288  19.174  14.193  1.00 16.44           O  
ATOM    430  CB  ASN A  52     -13.822  18.278  13.118  1.00 17.06           C  
ATOM    431  CG  ASN A  52     -15.084  17.478  13.125  1.00 18.02           C  
ATOM    432  OD1 ASN A  52     -15.327  16.692  14.034  1.00 15.64           O  
ATOM    433  ND2 ASN A  52     -15.961  17.728  12.132  1.00 18.99           N  
ATOM    434  N   GLN A  53     -12.249  21.130  14.741  1.00 14.10           N  
ATOM    435  CA  GLN A  53     -10.970  21.822  14.902  1.00 15.85           C  
ATOM    436  C   GLN A  53     -10.364  21.584  16.254  1.00 14.38           C  
ATOM    437  O   GLN A  53     -11.018  21.637  17.282  1.00 15.56           O  
ATOM    438  CB  GLN A  53     -11.121  23.299  14.665  1.00 17.41           C  
ATOM    439  CG  GLN A  53     -11.654  23.564  13.274  1.00 18.01           C  
ATOM    440  CD  GLN A  53     -11.160  24.875  12.678  1.00 24.87           C  
ATOM    441  OE1 GLN A  53      -9.977  25.089  12.585  1.00 25.88           O  
ATOM    442  NE2 GLN A  53     -12.065  25.681  12.165  1.00 31.93           N  
ATOM    443  N   LEU A  54      -9.062  21.354  16.258  1.00 14.79           N  
ATOM    444  CA  LEU A  54      -8.292  21.231  17.520  1.00 14.63           C  
ATOM    445  C   LEU A  54      -7.760  22.586  17.965  1.00 14.74           C  
ATOM    446  O   LEU A  54      -7.290  23.365  17.107  1.00 15.15           O  
ATOM    447  CB  LEU A  54      -7.078  20.307  17.301  1.00 14.97           C  
ATOM    448  CG  LEU A  54      -7.362  18.848  16.965  1.00 16.33           C  
ATOM    449  CD1 LEU A  54      -7.857  18.605  15.495  1.00 15.80           C  
ATOM    450  CD2 LEU A  54      -6.043  18.087  17.176  1.00 19.08           C  
ATOM    451  N   ARG A  55      -7.809  22.832  19.275  1.00 14.65           N  
ATOM    452  CA  ARG A  55      -7.360  24.080  19.910  1.00 14.71           C  
ATOM    453  C   ARG A  55      -6.008  23.945  20.547  1.00 14.68           C  
ATOM    454  O   ARG A  55      -5.721  22.977  21.269  1.00 14.20           O  
ATOM    455  CB  ARG A  55      -8.341  24.513  21.022  1.00 15.18           C  
ATOM    456  CG  ARG A  55      -9.713  24.724  20.603  1.00 16.56           C  
ATOM    457  CD  ARG A  55     -10.512  25.441  21.704  1.00 14.37           C  
ATOM    458  NE  ARG A  55     -10.510  24.715  22.960  1.00 16.47           N  
ATOM    459  CZ  ARG A  55     -11.005  25.168  24.107  1.00 17.65           C  
ATOM    460  NH1 ARG A  55     -11.618  26.367  24.196  1.00 17.43           N  
ATOM    461  NH2 ARG A  55     -10.877  24.431  25.203  1.00 20.80           N  
ATOM    462  N   PHE A  56      -5.173  24.981  20.325  1.00 14.68           N  
ATOM    463  CA  PHE A  56      -3.904  25.155  20.997  1.00 14.44           C  
ATOM    464  C   PHE A  56      -3.773  26.658  21.306  1.00 15.55           C  
ATOM    465  O   PHE A  56      -4.522  27.478  20.738  1.00 15.71           O  
ATOM    466  CB  PHE A  56      -2.766  24.766  20.067  1.00 15.92           C  
ATOM    467  CG  PHE A  56      -2.938  23.411  19.460  1.00 14.15           C  
ATOM    468  CD1 PHE A  56      -2.512  22.310  20.139  1.00 17.02           C  
ATOM    469  CD2 PHE A  56      -3.537  23.261  18.248  1.00 18.74           C  
ATOM    470  CE1 PHE A  56      -2.703  21.050  19.605  1.00 16.62           C  
ATOM    471  CE2 PHE A  56      -3.702  22.019  17.671  1.00 19.28           C  
ATOM    472  CZ  PHE A  56      -3.278  20.901  18.389  1.00 15.61           C  
ATOM    473  N   ILE A  57      -2.799  26.990  22.136  1.00 15.25           N  
ATOM    474  CA  ILE A  57      -2.421  28.378  22.380  1.00 14.32           C  
ATOM    475  C   ILE A  57      -0.962  28.562  22.045  1.00 16.00           C  
ATOM    476  O   ILE A  57      -0.164  27.598  22.118  1.00 16.01           O  
ATOM    477  CB  ILE A  57      -2.718  28.803  23.834  1.00 14.08           C  
ATOM    478  CG1 ILE A  57      -1.773  28.163  24.842  1.00 16.48           C  
ATOM    479  CG2 ILE A  57      -4.188  28.589  24.138  1.00 15.99           C  
ATOM    480  CD1 ILE A  57      -2.012  28.540  26.339  1.00 18.22           C  
ATOM    481  N   THR A  58      -0.613  29.787  21.693  1.00 14.57           N  
ATOM    482  CA  THR A  58       0.780  30.135  21.430  1.00 14.84           C  
ATOM    483  C   THR A  58       0.958  31.625  21.575  1.00 15.34           C  
ATOM    484  O   THR A  58      -0.019  32.381  21.616  1.00 15.49           O  
ATOM    485  CB  THR A  58       1.285  29.594  20.088  1.00 18.09           C  
ATOM    486  OG1 THR A  58       2.716  29.490  20.105  1.00 22.08           O  
ATOM    487  CG2 THR A  58       0.799  30.450  18.923  1.00 19.35           C  
ATOM    488  N   ASP A  59       2.204  32.046  21.679  1.00 15.89           N  
ATOM    489  CA  ASP A  59       2.564  33.452  21.821  1.00 15.84           C  
ATOM    490  C   ASP A  59       2.829  34.073  20.447  1.00 16.30           C  
ATOM    491  O   ASP A  59       3.521  33.473  19.613  1.00 17.12           O  
ATOM    492  CB  ASP A  59       3.816  33.521  22.706  1.00 16.30           C  
ATOM    493  CG  ASP A  59       4.104  34.884  23.262  1.00 19.39           C  
ATOM    494  OD1 ASP A  59       4.189  35.870  22.512  1.00 15.98           O  
ATOM    495  OD2 ASP A  59       4.246  34.951  24.500  1.00 22.71           O  
ATOM    496  N   THR A  60       2.305  35.282  20.193  1.00 16.43           N  
ATOM    497  CA  THR A  60       2.540  35.971  18.912  1.00 16.11           C  
ATOM    498  C   THR A  60       4.027  36.231  18.685  1.00 17.95           C  
ATOM    499  O   THR A  60       4.444  36.450  17.537  1.00 18.08           O  
ATOM    500  CB  THR A  60       1.845  37.357  18.798  1.00 20.46           C  
ATOM    501  OG1 THR A  60       2.331  38.192  19.848  1.00 20.81           O  
ATOM    502  CG2 THR A  60       0.339  37.250  18.920  1.00 26.22           C  
ATOM    503  N   ARG A  61       4.816  36.277  19.756  1.00 16.04           N  
ATOM    504  CA  ARG A  61       6.254  36.564  19.664  1.00 16.91           C  
ATOM    505  C   ARG A  61       7.055  35.342  19.271  1.00 17.23           C  
ATOM    506  O   ARG A  61       8.247  35.469  18.972  1.00 18.45           O  
ATOM    507  CB  ARG A  61       6.774  37.063  21.023  1.00 16.32           C  
ATOM    508  CG  ARG A  61       6.135  38.378  21.433  1.00 16.65           C  
ATOM    509  CD  ARG A  61       6.507  38.780  22.855  1.00 17.09           C  
ATOM    510  NE  ARG A  61       6.105  37.792  23.828  1.00 17.79           N  
ATOM    511  CZ  ARG A  61       6.524  37.738  25.087  1.00 18.29           C  
ATOM    512  NH1 ARG A  61       7.334  38.680  25.570  1.00 20.36           N  
ATOM    513  NH2 ARG A  61       6.121  36.753  25.883  1.00 19.45           N  
ATOM    514  N   SER A  62       6.437  34.166  19.290  1.00 14.48           N  
ATOM    515  CA  SER A  62       7.180  32.949  18.937  1.00 16.72           C  
ATOM    516  C   SER A  62       7.416  32.824  17.417  1.00 16.72           C  
ATOM    517  O   SER A  62       6.716  33.384  16.566  1.00 17.91           O  
ATOM    518  CB  SER A  62       6.487  31.728  19.471  1.00 19.26           C  
ATOM    519  OG  SER A  62       5.289  31.509  18.782  1.00 19.00           O  
ATOM    520  N   ALA A  63       8.472  32.079  17.059  1.00 17.52           N  
ATOM    521  CA  ALA A  63       8.786  31.888  15.670  1.00 15.71           C  
ATOM    522  C   ALA A  63       7.664  31.265  14.857  1.00 15.26           C  
ATOM    523  O   ALA A  63       7.488  31.608  13.668  1.00 18.44           O  
ATOM    524  CB  ALA A  63      10.030  31.001  15.541  1.00 18.73           C  
ATOM    525  N   LYS A  64       6.919  30.349  15.467  1.00 16.22           N  
ATOM    526  CA  LYS A  64       5.914  29.616  14.722  1.00 16.78           C  
ATOM    527  C   LYS A  64       4.834  30.591  14.257  1.00 19.59           C  
ATOM    528  O   LYS A  64       4.185  30.348  13.270  1.00 18.22           O  
ATOM    529  CB  LYS A  64       5.281  28.499  15.528  1.00 17.15           C  
ATOM    530  CG  LYS A  64       4.210  28.927  16.564  1.00 15.13           C  
ATOM    531  CD  LYS A  64       3.731  27.781  17.416  1.00 17.29           C  
ATOM    532  CE  LYS A  64       4.695  27.384  18.494  1.00 17.18           C  
ATOM    533  NZ  LYS A  64       5.268  28.525  19.327  1.00 17.49           N  
ATOM    534  N   ALA A  65       4.621  31.684  15.001  1.00 19.83           N  
ATOM    535  CA  ALA A  65       3.558  32.640  14.596  1.00 21.01           C  
ATOM    536  C   ALA A  65       3.791  33.157  13.194  1.00 21.96           C  
ATOM    537  O   ALA A  65       2.880  33.123  12.363  1.00 21.14           O  
ATOM    538  CB  ALA A  65       3.407  33.790  15.621  1.00 23.26           C  
ATOM    539  N   ASP A  66       5.009  33.589  12.895  1.00 21.63           N  
ATOM    540  CA  ASP A  66       5.272  34.099  11.562  1.00 21.26           C  
ATOM    541  C   ASP A  66       5.283  32.982  10.533  1.00 21.95           C  
ATOM    542  O   ASP A  66       4.857  33.144   9.393  1.00 21.06           O  
ATOM    543  CB  ASP A  66       6.602  34.833  11.482  1.00 23.71           C  
ATOM    544  CG  ASP A  66       6.797  35.480  10.143  1.00 33.65           C  
ATOM    545  OD1 ASP A  66       6.019  36.413   9.828  1.00 44.48           O  
ATOM    546  OD2 ASP A  66       7.680  35.025   9.382  1.00 45.05           O  
ATOM    547  N   GLN A  67       5.756  31.804  10.936  1.00 19.08           N  
ATOM    548  CA  GLN A  67       5.771  30.682   9.991  1.00 18.35           C  
ATOM    549  C   GLN A  67       4.334  30.375   9.563  1.00 18.97           C  
ATOM    550  O   GLN A  67       4.072  30.135   8.388  1.00 19.62           O  
ATOM    551  CB  GLN A  67       6.378  29.417  10.608  1.00 18.19           C  
ATOM    552  CG  GLN A  67       7.878  29.553  11.024  1.00 15.55           C  
ATOM    553  CD  GLN A  67       8.355  28.455  11.930  1.00 16.12           C  
ATOM    554  OE1 GLN A  67       7.675  27.447  12.140  1.00 17.49           O  
ATOM    555  NE2 GLN A  67       9.550  28.640  12.488  1.00 17.90           N  
ATOM    556  N   ILE A  68       3.417  30.361  10.517  1.00 18.64           N  
ATOM    557  CA  ILE A  68       2.019  30.017  10.252  1.00 18.47           C  
ATOM    558  C   ILE A  68       1.351  31.079   9.384  1.00 20.21           C  
ATOM    559  O   ILE A  68       0.579  30.768   8.468  1.00 19.64           O  
ATOM    560  CB  ILE A  68       1.285  29.785  11.586  1.00 17.55           C  
ATOM    561  CG1 ILE A  68       1.841  28.519  12.230  1.00 18.01           C  
ATOM    562  CG2 ILE A  68      -0.225  29.690  11.409  1.00 19.15           C  
ATOM    563  CD1 ILE A  68       1.490  28.315  13.680  1.00 20.02           C  
ATOM    564  N   GLN A  69       1.633  32.345   9.661  1.00 19.19           N  
ATOM    565  CA  GLN A  69       1.077  33.399   8.841  1.00 20.70           C  
ATOM    566  C   GLN A  69       1.478  33.276   7.384  1.00 22.44           C  
ATOM    567  O   GLN A  69       0.673  33.563   6.495  1.00 26.01           O  
ATOM    568  CB  GLN A  69       1.494  34.764   9.408  1.00 23.14           C  
ATOM    569  CG  GLN A  69       0.920  34.991  10.806  1.00 31.58           C  
ATOM    570  N   GLN A  70       2.716  32.851   7.124  1.00 20.68           N  
ATOM    571  CA  GLN A  70       3.176  32.681   5.747  1.00 21.29           C  
ATOM    572  C   GLN A  70       2.737  31.366   5.097  1.00 21.72           C  
ATOM    573  O   GLN A  70       2.526  31.325   3.892  1.00 24.11           O  
ATOM    574  CB  GLN A  70       4.695  32.853   5.640  1.00 22.28           C  
ATOM    575  CG  GLN A  70       5.163  34.219   6.111  1.00 23.14           C  
ATOM    576  CD  GLN A  70       6.592  34.555   5.683  1.00 28.40           C  
ATOM    577  OE1 GLN A  70       6.989  34.307   4.544  1.00 44.05           O  
ATOM    578  NE2 GLN A  70       7.360  35.134   6.605  1.00 39.76           N  
ATOM    579  N   GLN A  71       2.585  30.294   5.884  1.00 20.09           N  
ATOM    580  CA  GLN A  71       2.141  29.007   5.353  1.00 19.14           C  
ATOM    581  C   GLN A  71       1.309  28.334   6.436  1.00 18.34           C  
ATOM    582  O   GLN A  71       1.847  27.711   7.342  1.00 16.99           O  
ATOM    583  CB  GLN A  71       3.331  28.164   4.934  1.00 21.95           C  
ATOM    584  CG  GLN A  71       3.109  26.654   4.671  1.00 28.61           C  
ATOM    585  CD  GLN A  71       2.132  26.332   3.601  1.00 35.45           C  
ATOM    586  OE1 GLN A  71       0.931  26.510   3.760  1.00 29.38           O  
ATOM    587  NE2 GLN A  71       2.639  25.828   2.475  1.00 43.95           N  
ATOM    588  N   PRO A  72      -0.004  28.510   6.360  1.00 18.07           N  
ATOM    589  CA  PRO A  72      -0.850  27.981   7.416  0.50 18.79           C  
ATOM    591  C   PRO A  72      -0.974  26.401   7.410  0.50 15.06           C  
ATOM    593  O   PRO A  72      -1.563  25.818   8.273  0.50 15.17           O  
ATOM    595  CB  PRO A  72      -2.151  28.813   7.247  1.00 22.73           C  
ATOM    596  CG  PRO A  72      -2.184  29.233   5.827  1.00 25.05           C  
ATOM    597  CD  PRO A  72      -0.744  29.303   5.357  1.00 21.93           C  
ATOM    598  N   TRP A  73      -0.448  25.691   6.431  0.50 22.73           N  
ATOM    600  CA  TRP A  73      -0.685  24.247   6.460  1.00 24.42           C  
ATOM    601  C   TRP A  73       0.289  23.551   7.429  1.00 26.70           C  
ATOM    602  O   TRP A  73       1.496  23.801   7.338  1.00 28.77           O  
ATOM    603  CB  TRP A  73      -0.508  23.728   5.098  1.00 27.21           C  
ATOM    604  CG  TRP A  73      -0.877  22.308   5.039  1.00 30.00           C  
ATOM    605  CD1 TRP A  73      -0.106  21.252   5.417  1.00 24.82           C  
ATOM    606  CD2 TRP A  73      -2.105  21.772   4.572  1.00 27.92           C  
ATOM    607  NE1 TRP A  73      -0.775  20.096   5.224  1.00 23.55           N  
ATOM    608  CE2 TRP A  73      -1.999  20.376   4.658  1.00 24.81           C  
ATOM    609  CE3 TRP A  73      -3.288  22.336   4.071  1.00 24.77           C  
ATOM    610  CZ2 TRP A  73      -3.030  19.522   4.269  1.00 26.17           C  
ATOM    611  CZ3 TRP A  73      -4.309  21.474   3.678  1.00 23.88           C  
ATOM    612  CH2 TRP A  73      -4.169  20.103   3.761  1.00 26.04           C  
ATOM    613  N   ALA A  74      -0.233  22.717   8.341  1.00 19.97           N  
ATOM    614  CA  ALA A  74       0.617  22.036   9.344  1.00 18.65           C  
ATOM    615  C   ALA A  74       0.272  20.547   9.380  1.00 17.33           C  
ATOM    616  O   ALA A  74      -0.791  20.142   8.902  1.00 16.94           O  
ATOM    617  CB  ALA A  74       0.465  22.648  10.699  1.00 23.03           C  
ATOM    618  N   GLU A  75       1.165  19.756   9.975  1.00 14.58           N  
ATOM    619  CA  GLU A  75       0.848  18.378  10.230  1.00 13.83           C  
ATOM    620  C   GLU A  75       1.234  18.051  11.666  1.00 15.80           C  
ATOM    621  O   GLU A  75       2.389  18.290  12.089  1.00 17.29           O  
ATOM    622  CB  GLU A  75       1.618  17.438   9.307  1.00 15.86           C  
ATOM    623  CG  GLU A  75       1.156  15.979   9.469  1.00 16.13           C  
ATOM    624  CD  GLU A  75       1.579  15.106   8.294  1.00 17.56           C  
ATOM    625  OE1 GLU A  75       1.130  15.375   7.127  1.00 21.07           O  
ATOM    626  OE2 GLU A  75       2.346  14.146   8.473  1.00 18.39           O  
ATOM    627  N   ILE A  76       0.250  17.595  12.432  1.00 14.80           N  
ATOM    628  CA  ILE A  76       0.566  17.150  13.768  0.50 14.42           C  
ATOM    630  C   ILE A  76       0.835  15.644  13.762  1.00 15.17           C  
ATOM    631  O   ILE A  76       0.327  14.884  12.928  1.00 15.50           O  
ATOM    632  CB  ILE A  76      -0.493  17.543  14.785  0.50 15.15           C  
ATOM    634  CG1 ILE A  76      -1.844  16.928  14.384  0.50 12.61           C  
ATOM    636  CG2 ILE A  76      -0.511  19.083  14.981  0.50 13.64           C  
ATOM    638  CD1 ILE A  76      -2.899  17.010  15.498  0.50 18.91           C  
ATOM    640  N   CYS A  77       1.707  15.221  14.674  1.00 14.89           N  
ATOM    641  CA  CYS A  77       1.905  13.825  14.971  1.00 14.31           C  
ATOM    642  C   CYS A  77       1.650  13.696  16.438  1.00 14.77           C  
ATOM    643  O   CYS A  77       2.211  14.417  17.255  1.00 15.38           O  
ATOM    644  CB  CYS A  77       3.299  13.387  14.611  1.00 17.44           C  
ATOM    645  SG  CYS A  77       3.552  11.625  14.867  1.00 17.79           S  
ATOM    646  N   TRP A  78       0.775  12.754  16.777  1.00 13.89           N  
ATOM    647  CA  TRP A  78       0.276  12.573  18.154  1.00 14.36           C  
ATOM    648  C   TRP A  78       0.388  11.100  18.517  1.00 15.48           C  
ATOM    649  O   TRP A  78      -0.293  10.255  17.918  1.00 15.41           O  
ATOM    650  CB  TRP A  78      -1.132  13.032  18.205  1.00 14.64           C  
ATOM    651  CG  TRP A  78      -1.746  13.219  19.583  1.00 13.80           C  
ATOM    652  CD1 TRP A  78      -1.184  13.007  20.817  1.00 16.26           C  
ATOM    653  CD2 TRP A  78      -3.042  13.794  19.813  1.00 12.86           C  
ATOM    654  NE1 TRP A  78      -2.071  13.440  21.804  1.00 16.42           N  
ATOM    655  CE2 TRP A  78      -3.187  13.939  21.212  1.00 14.02           C  
ATOM    656  CE3 TRP A  78      -4.044  14.277  18.979  1.00 15.18           C  
ATOM    657  CZ2 TRP A  78      -4.346  14.505  21.781  1.00 15.56           C  
ATOM    658  CZ3 TRP A  78      -5.202  14.757  19.529  1.00 16.17           C  
ATOM    659  CH2 TRP A  78      -5.321  14.884  20.903  1.00 17.60           C  
ATOM    660  N   TYR A  79       1.266  10.791  19.455  1.00 14.57           N  
ATOM    661  CA  TYR A  79       1.507   9.441  19.891  1.00 16.01           C  
ATOM    662  C   TYR A  79       0.947   9.223  21.286  1.00 14.87           C  
ATOM    663  O   TYR A  79       1.175  10.037  22.222  1.00 16.66           O  
ATOM    664  CB  TYR A  79       3.028   9.074  19.854  1.00 17.15           C  
ATOM    665  CG  TYR A  79       3.293   7.681  20.290  1.00 15.00           C  
ATOM    666  CD1 TYR A  79       2.829   6.615  19.524  1.00 15.28           C  
ATOM    667  CD2 TYR A  79       3.912   7.378  21.497  1.00 15.61           C  
ATOM    668  CE1 TYR A  79       2.970   5.307  19.926  1.00 15.59           C  
ATOM    669  CE2 TYR A  79       4.071   6.047  21.911  1.00 16.26           C  
ATOM    670  CZ  TYR A  79       3.619   5.000  21.107  1.00 15.41           C  
ATOM    671  OH  TYR A  79       3.737   3.707  21.495  1.00 17.77           O  
ATOM    672  N   PHE A  80       0.211   8.127  21.449  1.00 13.05           N  
ATOM    673  CA  PHE A  80      -0.464   7.753  22.693  1.00 15.14           C  
ATOM    674  C   PHE A  80       0.245   6.555  23.282  1.00 15.38           C  
ATOM    675  O   PHE A  80       0.135   5.457  22.790  1.00 15.73           O  
ATOM    676  CB  PHE A  80      -1.920   7.414  22.388  1.00 15.35           C  
ATOM    677  CG  PHE A  80      -2.768   8.616  22.123  1.00 12.83           C  
ATOM    678  CD1 PHE A  80      -3.379   9.288  23.142  1.00 15.11           C  
ATOM    679  CD2 PHE A  80      -2.926   9.099  20.831  1.00 14.25           C  
ATOM    680  CE1 PHE A  80      -4.198  10.421  22.889  1.00 16.99           C  
ATOM    681  CE2 PHE A  80      -3.684  10.220  20.563  1.00 16.21           C  
ATOM    682  CZ  PHE A  80      -4.354  10.868  21.577  1.00 15.71           C  
ATOM    683  N   PRO A  81       1.035   6.780  24.352  1.00 16.54           N  
ATOM    684  CA  PRO A  81       1.924   5.729  24.793  1.00 18.70           C  
ATOM    685  C   PRO A  81       1.329   4.511  25.446  1.00 18.40           C  
ATOM    686  O   PRO A  81       1.905   3.429  25.340  1.00 19.14           O  
ATOM    687  CB  PRO A  81       2.893   6.455  25.744  1.00 20.30           C  
ATOM    688  CG  PRO A  81       2.781   7.810  25.484  1.00 23.16           C  
ATOM    689  CD  PRO A  81       1.317   8.054  25.026  1.00 18.58           C  
ATOM    690  N   ASN A  82       0.158   4.636  26.065  1.00 17.55           N  
ATOM    691  CA  ASN A  82      -0.434   3.493  26.755  1.00 18.88           C  
ATOM    692  C   ASN A  82      -1.092   2.525  25.771  1.00 20.34           C  
ATOM    693  O   ASN A  82      -1.198   1.349  26.003  1.00 24.37           O  
ATOM    694  CB  ASN A  82      -1.541   3.952  27.694  1.00 22.73           C  
ATOM    695  CG  ASN A  82      -1.122   4.052  29.109  1.00 34.66           C  
ATOM    696  OD1 ASN A  82       0.019   3.777  29.460  1.00 33.61           O  
ATOM    697  ND2 ASN A  82      -2.073   4.461  29.959  1.00 40.02           N  
ATOM    698  N   THR A  83      -1.608   3.057  24.675  1.00 15.49           N  
ATOM    699  CA  THR A  83      -2.265   2.254  23.673  1.00 14.81           C  
ATOM    700  C   THR A  83      -1.449   2.037  22.408  1.00 15.63           C  
ATOM    701  O   THR A  83      -1.888   1.292  21.541  1.00 16.19           O  
ATOM    702  CB  THR A  83      -3.611   2.882  23.304  1.00 14.71           C  
ATOM    703  OG1 THR A  83      -3.412   4.243  22.951  1.00 15.82           O  
ATOM    704  CG2 THR A  83      -4.597   2.808  24.520  1.00 16.20           C  
ATOM    705  N   ARG A  84      -0.256   2.636  22.330  1.00 15.26           N  
ATOM    706  CA  ARG A  84       0.668   2.399  21.193  1.00 16.34           C  
ATOM    707  C   ARG A  84      -0.014   2.721  19.850  1.00 15.26           C  
ATOM    708  O   ARG A  84       0.002   1.935  18.903  1.00 15.99           O  
ATOM    709  CB  ARG A  84       1.236   0.979  21.230  1.00 15.44           C  
ATOM    710  CG  ARG A  84       1.979   0.663  22.515  1.00 19.29           C  
ATOM    711  CD  ARG A  84       2.619  -0.759  22.471  1.00 23.33           C  
ATOM    712  NE  ARG A  84       3.641  -0.872  21.435  1.00 30.92           N  
ATOM    713  CZ  ARG A  84       3.755  -1.839  20.522  1.00 36.91           C  
ATOM    714  NH1 ARG A  84       2.937  -2.911  20.455  1.00 38.43           N  
ATOM    715  NH2 ARG A  84       4.739  -1.742  19.652  1.00 39.72           N  
ATOM    716  N   GLU A  85      -0.620   3.914  19.781  1.00 13.77           N  
ATOM    717  CA  GLU A  85      -1.256   4.384  18.555  1.00 13.56           C  
ATOM    718  C   GLU A  85      -0.824   5.786  18.195  1.00 13.59           C  
ATOM    719  O   GLU A  85      -0.482   6.569  19.091  1.00 14.83           O  
ATOM    720  CB  GLU A  85      -2.770   4.270  18.658  1.00 16.89           C  
ATOM    721  CG  GLU A  85      -3.383   5.136  19.644  1.00 17.60           C  
ATOM    722  CD  GLU A  85      -4.867   4.775  19.893  1.00 20.02           C  
ATOM    723  OE1 GLU A  85      -5.660   4.742  18.930  1.00 18.92           O  
ATOM    724  OE2 GLU A  85      -5.226   4.596  21.076  1.00 17.97           O  
ATOM    725  N   GLN A  86      -0.816   6.099  16.908  1.00 12.96           N  
ATOM    726  CA  GLN A  86      -0.386   7.361  16.423  1.00 13.88           C  
ATOM    727  C   GLN A  86      -1.460   7.946  15.520  1.00 13.86           C  
ATOM    728  O   GLN A  86      -2.052   7.212  14.726  1.00 14.12           O  
ATOM    729  CB  GLN A  86       0.889   7.180  15.614  1.00 15.16           C  
ATOM    730  CG  GLN A  86       1.399   8.400  14.837  1.00 16.56           C  
ATOM    731  CD  GLN A  86       2.673   8.107  14.101  1.00 16.35           C  
ATOM    732  OE1 GLN A  86       3.748   8.494  14.574  1.00 17.86           O  
ATOM    733  NE2 GLN A  86       2.575   7.442  12.980  1.00 17.37           N  
ATOM    734  N   PHE A  87      -1.729   9.244  15.672  1.00 12.94           N  
ATOM    735  CA  PHE A  87      -2.540   9.998  14.733  1.00 12.47           C  
ATOM    736  C   PHE A  87      -1.675  11.073  14.085  1.00 14.39           C  
ATOM    737  O   PHE A  87      -1.030  11.879  14.770  1.00 15.57           O  
ATOM    738  CB  PHE A  87      -3.734  10.664  15.392  1.00 13.57           C  
ATOM    739  CG  PHE A  87      -4.708   9.740  16.009  1.00 13.74           C  
ATOM    740  CD1 PHE A  87      -4.457   9.123  17.214  1.00 17.15           C  
ATOM    741  CD2 PHE A  87      -5.915   9.477  15.348  1.00 15.08           C  
ATOM    742  CE1 PHE A  87      -5.409   8.256  17.807  1.00 15.78           C  
ATOM    743  CE2 PHE A  87      -6.867   8.628  15.947  1.00 13.49           C  
ATOM    744  CZ  PHE A  87      -6.608   8.042  17.185  1.00 14.14           C  
ATOM    745  N   ARG A  88      -1.677  11.094  12.778  1.00 12.45           N  
ATOM    746  CA  ARG A  88      -1.069  12.179  12.011  1.00 13.14           C  
ATOM    747  C   ARG A  88      -2.213  12.947  11.399  1.00 14.33           C  
ATOM    748  O   ARG A  88      -3.116  12.326  10.841  1.00 14.11           O  
ATOM    749  CB  ARG A  88      -0.130  11.643  10.930  1.00 14.33           C  
ATOM    750  CG  ARG A  88       1.070  10.971  11.504  1.00 15.38           C  
ATOM    751  CD  ARG A  88       1.838  10.187  10.437  1.00 16.99           C  
ATOM    752  NE  ARG A  88       2.339  11.092   9.391  1.00 17.17           N  
ATOM    753  CZ  ARG A  88       3.037  10.711   8.320  1.00 18.73           C  
ATOM    754  NH1 ARG A  88       3.184   9.452   8.117  1.00 20.09           N  
ATOM    755  NH2 ARG A  88       3.494  11.618   7.444  1.00 20.21           N  
HETATM  756  N   MSE A  89      -2.255  14.245  11.563  1.00 14.06           N  
HETATM  757  CA  MSE A  89      -3.388  15.034  11.124  0.50 14.79           C  
HETATM  759  C   MSE A  89      -2.848  16.275  10.395  1.00 15.48           C  
HETATM  760  O   MSE A  89      -2.101  17.055  10.977  1.00 15.83           O  
HETATM  761  CB  MSE A  89      -4.311  15.374  12.324  0.50 16.34           C  
HETATM  763  CG  MSE A  89      -4.464  14.218  13.354  0.50 12.10           C  
HETATM  765 SE   MSE A  89      -5.385  14.687  15.015  0.37 22.49          SE  
HETATM  767  CE  MSE A  89      -7.199  14.276  14.467  0.50 24.58           C  
ATOM    769  N   ALA A  90      -3.252  16.442   9.148  1.00 15.19           N  
ATOM    770  CA  ALA A  90      -2.758  17.528   8.320  1.00 15.22           C  
ATOM    771  C   ALA A  90      -3.904  18.420   7.922  1.00 17.30           C  
ATOM    772  O   ALA A  90      -4.973  17.933   7.613  1.00 15.73           O  
ATOM    773  CB  ALA A  90      -2.132  16.990   7.096  1.00 15.31           C  
ATOM    774  N   GLY A  91      -3.683  19.728   7.937  1.00 16.08           N  
ATOM    775  CA  GLY A  91      -4.703  20.656   7.494  1.00 16.35           C  
ATOM    776  C   GLY A  91      -4.305  22.083   7.774  1.00 16.44           C  
ATOM    777  O   GLY A  91      -3.152  22.380   8.075  1.00 17.00           O  
ATOM    778  N   ASP A  92      -5.268  22.972   7.569  1.00 19.78           N  
ATOM    779  CA  ASP A  92      -4.966  24.389   7.667  0.50 18.47           C  
ATOM    781  C   ASP A  92      -5.115  24.898   9.085  1.00 17.35           C  
ATOM    782  O   ASP A  92      -5.978  24.487   9.849  1.00 18.00           O  
ATOM    783  CB  ASP A  92      -5.831  25.220   6.745  0.50 21.83           C  
ATOM    785  CG  ASP A  92      -5.334  25.204   5.323  0.50 28.64           C  
ATOM    787  OD1 ASP A  92      -4.143  25.527   5.053  0.50 29.86           O  
ATOM    789  OD2 ASP A  92      -6.158  24.860   4.488  0.50 22.73           O  
ATOM    791  N   LEU A  93      -4.176  25.759   9.432  1.00 20.15           N  
ATOM    792  CA  LEU A  93      -4.173  26.468  10.675  1.00 17.10           C  
ATOM    793  C   LEU A  93      -4.874  27.802  10.570  1.00 18.98           C  
ATOM    794  O   LEU A  93      -4.779  28.484   9.591  1.00 18.52           O  
ATOM    795  CB  LEU A  93      -2.747  26.723  11.160  1.00 17.98           C  
ATOM    796  CG  LEU A  93      -1.952  25.450  11.524  1.00 20.63           C  
ATOM    797  CD1 LEU A  93      -0.440  25.760  11.728  1.00 23.48           C  
ATOM    798  CD2 LEU A  93      -2.538  24.737  12.730  1.00 24.18           C  
ATOM    799  N   THR A  94      -5.516  28.205  11.649  1.00 16.07           N  
ATOM    800  CA  THR A  94      -6.019  29.566  11.829  1.00 15.92           C  
ATOM    801  C   THR A  94      -5.384  30.137  13.105  1.00 15.71           C  
ATOM    802  O   THR A  94      -5.494  29.522  14.151  1.00 16.39           O  
ATOM    803  CB  THR A  94      -7.545  29.569  11.986  1.00 16.42           C  
ATOM    804  OG1 THR A  94      -8.190  28.910  10.883  1.00 20.36           O  
ATOM    805  CG2 THR A  94      -8.100  31.002  12.050  1.00 20.42           C  
ATOM    806  N   LEU A  95      -4.735  31.277  13.017  1.00 15.54           N  
ATOM    807  CA  LEU A  95      -4.089  31.910  14.142  1.00 16.65           C  
ATOM    808  C   LEU A  95      -4.909  33.148  14.486  1.00 16.67           C  
ATOM    809  O   LEU A  95      -5.046  34.059  13.667  1.00 17.54           O  
ATOM    810  CB  LEU A  95      -2.660  32.309  13.769  1.00 17.29           C  
ATOM    811  CG  LEU A  95      -1.731  32.786  14.880  1.00 23.27           C  
ATOM    812  CD1 LEU A  95      -1.412  31.724  15.942  1.00 23.84           C  
ATOM    813  CD2 LEU A  95      -0.422  33.318  14.269  1.00 26.05           C  
ATOM    814  N   ILE A  96      -5.520  33.105  15.655  1.00 16.03           N  
ATOM    815  CA  ILE A  96      -6.389  34.182  16.132  1.00 15.36           C  
ATOM    816  C   ILE A  96      -5.635  34.920  17.236  1.00 14.59           C  
ATOM    817  O   ILE A  96      -5.455  34.414  18.355  1.00 15.41           O  
ATOM    818  CB  ILE A  96      -7.752  33.635  16.642  1.00 15.82           C  
ATOM    819  CG1 ILE A  96      -8.411  32.733  15.610  1.00 20.07           C  
ATOM    820  CG2 ILE A  96      -8.747  34.770  16.984  1.00 15.53           C  
ATOM    821  CD1 ILE A  96      -8.152  31.327  15.831  1.00 27.68           C  
ATOM    822  N   SER A  97      -5.211  36.132  16.914  1.00 16.36           N  
ATOM    823  CA  SER A  97      -4.412  36.984  17.804  1.00 15.96           C  
ATOM    824  C   SER A  97      -5.268  38.180  18.186  1.00 18.02           C  
ATOM    825  O   SER A  97      -6.486  38.122  18.074  1.00 17.03           O  
ATOM    826  CB  SER A  97      -3.139  37.431  17.097  1.00 18.69           C  
ATOM    827  OG  SER A  97      -3.461  38.252  15.992  1.00 19.13           O  
ATOM    828  N   SER A  98      -4.652  39.288  18.568  1.00 17.19           N  
ATOM    829  CA  SER A  98      -5.414  40.501  18.803  1.00 20.06           C  
ATOM    830  C   SER A  98      -5.571  41.331  17.534  1.00 21.09           C  
ATOM    831  O   SER A  98      -6.224  42.385  17.567  1.00 24.32           O  
ATOM    832  CB  SER A  98      -4.745  41.354  19.886  1.00 22.80           C  
ATOM    833  OG  SER A  98      -3.405  41.625  19.510  1.00 28.37           O  
ATOM    834  N   ASP A  99      -4.982  40.909  16.422  1.00 20.95           N  
ATOM    835  CA  ASP A  99      -5.219  41.647  15.172  1.00 22.51           C  
ATOM    836  C   ASP A  99      -6.645  41.405  14.638  1.00 24.52           C  
ATOM    837  O   ASP A  99      -7.396  40.623  15.217  1.00 24.10           O  
ATOM    838  CB  ASP A  99      -4.129  41.377  14.155  1.00 28.13           C  
ATOM    839  CG  ASP A  99      -4.284  40.093  13.438  1.00 28.02           C  
ATOM    840  OD1 ASP A  99      -5.367  39.454  13.469  1.00 30.51           O  
ATOM    841  OD2 ASP A  99      -3.271  39.712  12.802  1.00 43.29           O  
ATOM    842  N   ASP A 100      -7.044  42.100  13.572  1.00 23.12           N  
ATOM    843  CA  ASP A 100      -8.454  42.061  13.143  1.00 23.46           C  
ATOM    844  C   ASP A 100      -8.777  41.040  12.041  1.00 24.78           C  
ATOM    845  O   ASP A 100      -9.827  41.124  11.413  1.00 26.17           O  
ATOM    846  CB  ASP A 100      -8.927  43.470  12.748  1.00 25.36           C  
ATOM    847  CG  ASP A 100      -8.239  44.002  11.528  1.00 33.27           C  
ATOM    848  OD1 ASP A 100      -7.558  43.230  10.818  1.00 31.81           O  
ATOM    849  OD2 ASP A 100      -8.395  45.223  11.271  1.00 41.23           O  
ATOM    850  N   SER A 101      -7.897  40.069  11.848  1.00 22.69           N  
ATOM    851  CA  SER A 101      -8.028  39.063  10.789  1.00 22.87           C  
ATOM    852  C   SER A 101      -9.157  38.061  10.981  1.00 23.17           C  
ATOM    853  O   SER A 101      -9.630  37.474  10.027  1.00 23.60           O  
ATOM    854  CB  SER A 101      -6.694  38.294  10.670  1.00 27.11           C  
ATOM    855  OG  SER A 101      -5.660  39.175  10.256  1.00 35.94           O  
ATOM    856  N   HIS A 102      -9.561  37.806  12.222  1.00 20.65           N  
ATOM    857  CA  HIS A 102     -10.526  36.745  12.504  1.00 17.73           C  
ATOM    858  C   HIS A 102     -11.499  37.183  13.581  1.00 19.86           C  
ATOM    859  O   HIS A 102     -11.645  36.519  14.605  1.00 17.13           O  
ATOM    860  CB  HIS A 102      -9.788  35.511  12.940  1.00 18.92           C  
ATOM    861  CG  HIS A 102      -8.892  34.954  11.877  1.00 20.87           C  
ATOM    862  ND1 HIS A 102      -9.384  34.394  10.719  1.00 22.84           N  
ATOM    863  CD2 HIS A 102      -7.543  34.903  11.789  1.00 22.07           C  
ATOM    864  CE1 HIS A 102      -8.367  33.970   9.984  1.00 20.56           C  
ATOM    865  NE2 HIS A 102      -7.240  34.280  10.606  1.00 22.51           N  
ATOM    866  N   GLN A 103     -12.215  38.261  13.310  1.00 18.67           N  
ATOM    867  CA  GLN A 103     -13.096  38.871  14.323  1.00 19.09           C  
ATOM    868  C   GLN A 103     -14.174  37.933  14.765  1.00 19.03           C  
ATOM    869  O   GLN A 103     -14.542  37.920  15.960  1.00 17.75           O  
ATOM    870  CB  GLN A 103     -13.707  40.174  13.811  1.00 21.26           C  
ATOM    871  CG  GLN A 103     -12.779  41.334  13.948  1.00 24.44           C  
ATOM    872  CD  GLN A 103     -12.181  41.451  15.359  1.00 32.08           C  
ATOM    873  OE1 GLN A 103     -11.005  41.144  15.537  1.00 35.33           O  
ATOM    874  NE2 GLN A 103     -13.010  41.808  16.384  1.00 26.18           N  
ATOM    875  N   ASP A 104     -14.679  37.124  13.844  1.00 17.90           N  
ATOM    876  CA  ASP A 104     -15.681  36.126  14.171  1.00 20.87           C  
ATOM    877  C   ASP A 104     -15.239  35.075  15.177  1.00 21.71           C  
ATOM    878  O   ASP A 104     -16.075  34.433  15.784  1.00 22.48           O  
ATOM    879  CB  ASP A 104     -16.210  35.415  12.916  1.00 24.75           C  
ATOM    880  CG  ASP A 104     -15.101  34.743  12.082  1.00 36.98           C  
ATOM    881  OD1 ASP A 104     -13.982  35.299  11.958  1.00 45.63           O  
ATOM    882  OD2 ASP A 104     -15.374  33.665  11.506  1.00 54.72           O  
ATOM    883  N   LEU A 105     -13.924  34.883  15.345  1.00 17.10           N  
ATOM    884  CA  LEU A 105     -13.423  33.910  16.282  1.00 16.63           C  
ATOM    885  C   LEU A 105     -12.880  34.558  17.566  1.00 12.58           C  
ATOM    886  O   LEU A 105     -12.259  33.873  18.379  1.00 14.48           O  
ATOM    887  CB  LEU A 105     -12.305  33.072  15.629  1.00 17.44           C  
ATOM    888  CG  LEU A 105     -12.851  32.075  14.578  1.00 22.22           C  
ATOM    889  CD1 LEU A 105     -11.761  31.577  13.679  1.00 21.92           C  
ATOM    890  CD2 LEU A 105     -13.488  30.905  15.345  1.00 25.48           C  
ATOM    891  N   GLN A 106     -13.086  35.851  17.735  1.00 12.87           N  
ATOM    892  CA  GLN A 106     -12.646  36.453  19.025  1.00 11.12           C  
ATOM    893  C   GLN A 106     -13.327  35.799  20.222  1.00 11.96           C  
ATOM    894  O   GLN A 106     -12.675  35.565  21.229  1.00 13.09           O  
ATOM    895  CB  GLN A 106     -12.748  37.964  19.032  1.00 12.59           C  
ATOM    896  CG  GLN A 106     -11.689  38.600  18.139  1.00 14.66           C  
ATOM    897  CD  GLN A 106     -10.280  38.377  18.599  1.00 14.59           C  
ATOM    898  OE1 GLN A 106     -10.017  38.365  19.810  1.00 14.83           O  
ATOM    899  NE2 GLN A 106      -9.337  38.210  17.626  1.00 14.37           N  
ATOM    900  N   PRO A 107     -14.658  35.516  20.185  1.00 12.23           N  
ATOM    901  CA  PRO A 107     -15.242  34.846  21.323  1.00 13.44           C  
ATOM    902  C   PRO A 107     -14.536  33.524  21.668  1.00 12.36           C  
ATOM    903  O   PRO A 107     -14.362  33.223  22.865  1.00 12.87           O  
ATOM    904  CB  PRO A 107     -16.703  34.649  20.907  1.00 13.69           C  
ATOM    905  CG  PRO A 107     -16.953  35.775  19.945  1.00 12.85           C  
ATOM    906  CD  PRO A 107     -15.696  35.916  19.189  1.00 13.08           C  
ATOM    907  N   ALA A 108     -14.103  32.753  20.655  1.00 13.27           N  
ATOM    908  CA  ALA A 108     -13.377  31.534  20.915  1.00 12.85           C  
ATOM    909  C   ALA A 108     -12.055  31.811  21.576  1.00 12.98           C  
ATOM    910  O   ALA A 108     -11.630  31.103  22.453  1.00 13.85           O  
ATOM    911  CB  ALA A 108     -13.162  30.741  19.620  1.00 14.54           C  
ATOM    912  N   ARG A 109     -11.355  32.830  21.112  1.00 12.39           N  
ATOM    913  CA  ARG A 109     -10.076  33.213  21.721  1.00 12.21           C  
ATOM    914  C   ARG A 109     -10.220  33.645  23.180  1.00 11.82           C  
ATOM    915  O   ARG A 109      -9.423  33.252  24.047  1.00 13.27           O  
ATOM    916  CB  ARG A 109      -9.423  34.311  20.867  1.00 13.19           C  
ATOM    917  CG  ARG A 109      -8.108  34.915  21.413  1.00 12.82           C  
ATOM    918  CD  ARG A 109      -7.511  35.913  20.463  1.00 13.30           C  
ATOM    919  NE  ARG A 109      -6.383  36.618  21.059  1.00 14.88           N  
ATOM    920  CZ  ARG A 109      -6.421  37.849  21.563  1.00 15.86           C  
ATOM    921  NH1 ARG A 109      -7.537  38.584  21.535  1.00 14.17           N  
ATOM    922  NH2 ARG A 109      -5.323  38.334  22.136  1.00 15.03           N  
ATOM    923  N   ILE A 110     -11.232  34.450  23.421  1.00 11.64           N  
ATOM    924  CA  ILE A 110     -11.523  34.963  24.776  1.00 12.19           C  
ATOM    925  C   ILE A 110     -11.893  33.803  25.710  1.00 12.54           C  
ATOM    926  O   ILE A 110     -11.423  33.708  26.842  1.00 13.65           O  
ATOM    927  CB  ILE A 110     -12.653  36.013  24.735  1.00 12.12           C  
ATOM    928  CG1 ILE A 110     -12.165  37.232  23.959  1.00 11.87           C  
ATOM    929  CG2 ILE A 110     -13.052  36.409  26.174  1.00 14.30           C  
ATOM    930  CD1 ILE A 110     -13.272  38.131  23.326  1.00 12.81           C  
ATOM    931  N   ALA A 111     -12.746  32.871  25.248  1.00 12.27           N  
ATOM    932  CA  ALA A 111     -13.104  31.710  26.019  1.00 13.82           C  
ATOM    933  C   ALA A 111     -11.882  30.889  26.370  1.00 13.18           C  
ATOM    934  O   ALA A 111     -11.750  30.424  27.493  1.00 14.81           O  
ATOM    935  CB  ALA A 111     -14.142  30.840  25.241  1.00 14.95           C  
HETATM  936  N   MSE A 112     -11.009  30.651  25.389  1.00 12.87           N  
HETATM  937  CA  MSE A 112      -9.810  29.876  25.674  1.00 13.41           C  
HETATM  938  C   MSE A 112      -8.972  30.531  26.771  1.00 12.92           C  
HETATM  939  O   MSE A 112      -8.493  29.880  27.709  1.00 14.11           O  
HETATM  940  CB  MSE A 112      -9.013  29.683  24.410  1.00 15.15           C  
HETATM  941  CG  MSE A 112      -7.683  28.955  24.513  1.00 15.70           C  
HETATM  942 SE   MSE A 112      -7.867  27.016  24.492  0.75 20.94          SE  
HETATM  943  CE  MSE A 112      -8.016  26.846  26.294  1.00 19.25           C  
ATOM    944  N   TRP A 113      -8.727  31.829  26.621  1.00 12.82           N  
ATOM    945  CA  TRP A 113      -7.975  32.590  27.625  1.00 13.42           C  
ATOM    946  C   TRP A 113      -8.544  32.382  29.012  1.00 13.14           C  
ATOM    947  O   TRP A 113      -7.826  32.165  29.989  1.00 13.47           O  
ATOM    948  CB  TRP A 113      -8.041  34.102  27.270  1.00 12.74           C  
ATOM    949  CG  TRP A 113      -7.345  34.972  28.254  1.00 11.05           C  
ATOM    950  CD1 TRP A 113      -7.943  35.796  29.178  1.00 12.69           C  
ATOM    951  CD2 TRP A 113      -5.944  35.150  28.406  1.00 12.10           C  
ATOM    952  NE1 TRP A 113      -6.992  36.490  29.867  1.00 11.91           N  
ATOM    953  CE2 TRP A 113      -5.750  36.115  29.424  1.00 11.65           C  
ATOM    954  CE3 TRP A 113      -4.831  34.588  27.800  1.00 11.48           C  
ATOM    955  CZ2 TRP A 113      -4.508  36.533  29.812  1.00 12.17           C  
ATOM    956  CZ3 TRP A 113      -3.574  35.029  28.202  1.00 13.58           C  
ATOM    957  CH2 TRP A 113      -3.437  35.978  29.204  1.00 12.62           C  
ATOM    958  N   GLN A 114      -9.861  32.519  29.121  1.00 13.34           N  
ATOM    959  CA  GLN A 114     -10.544  32.425  30.396  1.00 13.76           C  
ATOM    960  C   GLN A 114     -10.484  31.014  31.015  1.00 15.19           C  
ATOM    961  O   GLN A 114     -10.513  30.891  32.254  1.00 16.41           O  
ATOM    962  CB  GLN A 114     -11.978  32.873  30.234  1.00 15.86           C  
ATOM    963  CG  GLN A 114     -12.051  34.379  29.971  1.00 14.61           C  
ATOM    964  CD  GLN A 114     -13.466  34.864  29.861  1.00 16.70           C  
ATOM    965  OE1 GLN A 114     -14.401  34.062  29.997  1.00 20.63           O  
ATOM    966  NE2 GLN A 114     -13.661  36.143  29.547  1.00 14.23           N  
ATOM    967  N   GLU A 115     -10.408  29.996  30.167  1.00 14.84           N  
ATOM    968  CA  GLU A 115     -10.369  28.616  30.603  1.00 15.18           C  
ATOM    969  C   GLU A 115      -9.010  28.180  31.099  1.00 17.17           C  
ATOM    970  O   GLU A 115      -8.868  27.116  31.757  1.00 18.31           O  
ATOM    971  CB  GLU A 115     -10.828  27.723  29.416  1.00 16.03           C  
ATOM    972  CG  GLU A 115     -12.293  27.871  29.145  1.00 20.74           C  
ATOM    973  CD  GLU A 115     -12.815  27.413  27.774  1.00 25.22           C  
ATOM    974  OE1 GLU A 115     -12.037  26.830  26.997  1.00 26.96           O  
ATOM    975  OE2 GLU A 115     -14.036  27.636  27.499  1.00 27.23           O  
ATOM    976  N   LEU A 116      -7.976  28.920  30.761  1.00 14.89           N  
ATOM    977  CA  LEU A 116      -6.649  28.603  31.215  1.00 15.15           C  
ATOM    978  C   LEU A 116      -6.474  28.690  32.726  1.00 17.10           C  
ATOM    979  O   LEU A 116      -7.209  29.383  33.422  1.00 16.82           O  
ATOM    980  CB  LEU A 116      -5.630  29.526  30.572  1.00 15.44           C  
ATOM    981  CG  LEU A 116      -5.539  29.479  29.043  1.00 14.11           C  
ATOM    982  CD1 LEU A 116      -4.483  30.488  28.611  1.00 15.94           C  
ATOM    983  CD2 LEU A 116      -5.185  28.092  28.518  1.00 17.93           C  
ATOM    984  N   SER A 117      -5.437  28.014  33.249  1.00 18.84           N  
ATOM    985  CA  SER A 117      -5.023  28.333  34.589  1.00 18.42           C  
ATOM    986  C   SER A 117      -4.290  29.684  34.714  1.00 19.14           C  
ATOM    987  O   SER A 117      -3.789  30.237  33.737  1.00 17.24           O  
ATOM    988  CB  SER A 117      -4.060  27.246  35.123  1.00 20.15           C  
ATOM    989  OG  SER A 117      -2.901  27.246  34.318  1.00 20.87           O  
ATOM    990  N   ASP A 118      -4.170  30.190  35.941  1.00 18.89           N  
ATOM    991  CA  ASP A 118      -3.326  31.356  36.173  1.00 20.06           C  
ATOM    992  C   ASP A 118      -1.922  31.126  35.680  1.00 20.35           C  
ATOM    993  O   ASP A 118      -1.322  32.001  35.103  1.00 20.21           O  
ATOM    994  CB  ASP A 118      -3.302  31.769  37.654  1.00 21.28           C  
ATOM    995  CG  ASP A 118      -4.575  32.434  38.116  1.00 26.27           C  
ATOM    996  OD1 ASP A 118      -5.272  33.104  37.299  1.00 29.53           O  
ATOM    997  OD2 ASP A 118      -4.847  32.373  39.343  1.00 31.28           O  
ATOM    998  N   ALA A 119      -1.377  29.938  35.954  1.00 20.39           N  
ATOM    999  CA  ALA A 119      -0.002  29.655  35.523  1.00 20.55           C  
ATOM   1000  C   ALA A 119       0.189  29.794  34.018  1.00 19.62           C  
ATOM   1001  O   ALA A 119       1.209  30.341  33.530  1.00 19.95           O  
ATOM   1002  CB  ALA A 119       0.415  28.216  35.997  1.00 22.26           C  
ATOM   1003  N   ALA A 120      -0.791  29.295  33.272  1.00 19.20           N  
ATOM   1004  CA  ALA A 120      -0.731  29.296  31.853  1.00 18.42           C  
ATOM   1005  C   ALA A 120      -0.856  30.745  31.353  1.00 19.73           C  
ATOM   1006  O   ALA A 120      -0.112  31.150  30.467  1.00 18.64           O  
ATOM   1007  CB  ALA A 120      -1.802  28.387  31.222  1.00 19.18           C  
ATOM   1008  N   ARG A 121      -1.777  31.536  31.928  1.00 17.19           N  
ATOM   1009  CA  ARG A 121      -1.844  32.952  31.502  1.00 14.56           C  
ATOM   1010  C   ARG A 121      -0.580  33.747  31.819  1.00 15.92           C  
ATOM   1011  O   ARG A 121      -0.158  34.594  31.050  1.00 16.85           O  
ATOM   1012  CB  ARG A 121      -3.046  33.655  32.117  1.00 15.25           C  
ATOM   1013  CG  ARG A 121      -4.402  33.253  31.531  1.00 14.61           C  
ATOM   1014  CD  ARG A 121      -5.542  34.103  32.070  1.00 13.89           C  
ATOM   1015  NE  ARG A 121      -5.908  33.743  33.447  1.00 14.66           N  
ATOM   1016  CZ  ARG A 121      -6.746  32.765  33.755  1.00 15.85           C  
ATOM   1017  NH1 ARG A 121      -7.441  32.123  32.822  1.00 15.01           N  
ATOM   1018  NH2 ARG A 121      -6.875  32.420  35.019  1.00 18.17           N  
ATOM   1019  N   LEU A 122       0.032  33.442  32.989  1.00 18.30           N  
ATOM   1020  CA  LEU A 122       1.218  34.171  33.472  0.50 17.84           C  
ATOM   1022  C   LEU A 122       2.368  34.078  32.454  1.00 17.29           C  
ATOM   1023  O   LEU A 122       3.120  35.030  32.271  1.00 17.53           O  
ATOM   1024  CB  LEU A 122       1.688  33.627  34.844  0.50 19.92           C  
ATOM   1026  CG  LEU A 122       1.007  34.101  36.144  0.50 23.06           C  
ATOM   1028  CD1 LEU A 122       1.310  33.170  37.310  0.50 25.31           C  
ATOM   1030  CD2 LEU A 122       1.438  35.514  36.521  0.50 20.78           C  
ATOM   1032  N   GLN A 123       2.506  32.953  31.784  1.00 19.06           N  
ATOM   1033  CA  GLN A 123       3.615  32.771  30.836  1.00 19.17           C  
ATOM   1034  C   GLN A 123       3.608  33.759  29.696  1.00 20.08           C  
ATOM   1035  O   GLN A 123       4.642  34.060  29.131  1.00 18.80           O  
ATOM   1036  CB  GLN A 123       3.644  31.357  30.253  1.00 21.80           C  
ATOM   1037  CG  GLN A 123       3.878  30.274  31.223  1.00 27.46           C  
ATOM   1038  CD  GLN A 123       4.310  28.944  30.557  1.00 23.98           C  
ATOM   1039  OE1 GLN A 123       4.527  28.869  29.342  1.00 34.51           O  
ATOM   1040  NE2 GLN A 123       4.445  27.910  31.369  1.00 37.32           N  
ATOM   1041  N   PHE A 124       2.435  34.306  29.355  1.00 17.48           N  
ATOM   1042  CA  PHE A 124       2.381  35.302  28.297  1.00 17.26           C  
ATOM   1043  C   PHE A 124       3.011  36.634  28.739  1.00 17.77           C  
ATOM   1044  O   PHE A 124       3.292  37.478  27.890  1.00 19.22           O  
ATOM   1045  CB  PHE A 124       0.934  35.452  27.801  1.00 15.98           C  
ATOM   1046  CG  PHE A 124       0.475  34.225  27.048  1.00 14.54           C  
ATOM   1047  CD1 PHE A 124       0.736  34.089  25.694  1.00 17.30           C  
ATOM   1048  CD2 PHE A 124      -0.065  33.142  27.732  1.00 14.94           C  
ATOM   1049  CE1 PHE A 124       0.420  32.960  25.030  1.00 17.00           C  
ATOM   1050  CE2 PHE A 124      -0.372  31.979  27.069  1.00 16.36           C  
ATOM   1051  CZ  PHE A 124      -0.125  31.882  25.688  1.00 15.65           C  
ATOM   1052  N   GLY A 125       3.308  36.775  30.043  1.00 18.68           N  
ATOM   1053  CA  GLY A 125       4.024  37.933  30.546  1.00 18.79           C  
ATOM   1054  C   GLY A 125       5.516  37.752  30.689  1.00 17.96           C  
ATOM   1055  O   GLY A 125       6.222  38.660  31.155  1.00 21.47           O  
ATOM   1056  N   TRP A 126       6.018  36.606  30.273  1.00 17.61           N  
ATOM   1057  CA  TRP A 126       7.461  36.321  30.321  1.00 17.26           C  
ATOM   1058  C   TRP A 126       8.236  37.105  29.257  1.00 18.35           C  
ATOM   1059  O   TRP A 126       7.665  37.633  28.310  1.00 17.01           O  
ATOM   1060  CB  TRP A 126       7.702  34.823  30.129  1.00 18.45           C  
ATOM   1061  CG  TRP A 126       7.345  33.966  31.302  1.00 18.25           C  
ATOM   1062  CD1 TRP A 126       6.817  34.360  32.496  1.00 16.36           C  
ATOM   1063  CD2 TRP A 126       7.500  32.554  31.378  1.00 15.33           C  
ATOM   1064  NE1 TRP A 126       6.617  33.265  33.301  1.00 19.86           N  
ATOM   1065  CE2 TRP A 126       7.035  32.140  32.635  1.00 19.65           C  
ATOM   1066  CE3 TRP A 126       7.983  31.593  30.481  1.00 19.77           C  
ATOM   1067  CZ2 TRP A 126       7.056  30.828  33.040  1.00 19.36           C  
ATOM   1068  CZ3 TRP A 126       7.969  30.282  30.870  1.00 21.27           C  
ATOM   1069  CH2 TRP A 126       7.537  29.910  32.150  1.00 20.16           C  
ATOM   1070  N   PRO A 127       9.552  37.265  29.456  1.00 17.62           N  
ATOM   1071  CA  PRO A 127      10.312  38.000  28.462  1.00 18.04           C  
ATOM   1072  C   PRO A 127      10.348  37.349  27.099  1.00 18.79           C  
ATOM   1073  O   PRO A 127       9.990  36.188  26.970  1.00 20.93           O  
ATOM   1074  CB  PRO A 127      11.719  38.099  29.074  1.00 20.67           C  
ATOM   1075  CG  PRO A 127      11.757  37.168  30.178  1.00 23.92           C  
ATOM   1076  CD  PRO A 127      10.348  36.857  30.615  1.00 19.62           C  
ATOM   1077  N   TYR A 128      10.750  38.139  26.108  1.00 20.25           N  
ATOM   1078  CA  TYR A 128      10.642  37.808  24.694  1.00 19.31           C  
ATOM   1079  C   TYR A 128      11.299  36.454  24.366  1.00 20.30           C  
ATOM   1080  O   TYR A 128      12.490  36.284  24.536  1.00 19.43           O  
ATOM   1081  CB  TYR A 128      11.283  38.897  23.848  1.00 18.68           C  
ATOM   1082  CG  TYR A 128      10.714  39.005  22.464  1.00 17.09           C  
ATOM   1083  CD1 TYR A 128      10.975  38.040  21.508  1.00 21.07           C  
ATOM   1084  CD2 TYR A 128       9.923  40.074  22.102  1.00 22.44           C  
ATOM   1085  CE1 TYR A 128      10.454  38.137  20.225  1.00 18.94           C  
ATOM   1086  CE2 TYR A 128       9.394  40.174  20.813  1.00 21.22           C  
ATOM   1087  CZ  TYR A 128       9.664  39.197  19.899  1.00 25.57           C  
ATOM   1088  OH  TYR A 128       9.156  39.263  18.621  1.00 26.47           O  
ATOM   1089  N   PRO A 129      10.501  35.486  23.913  1.00 19.00           N  
ATOM   1090  CA  PRO A 129      11.038  34.159  23.679  1.00 20.50           C  
ATOM   1091  C   PRO A 129      12.166  34.160  22.670  1.00 21.63           C  
ATOM   1092  O   PRO A 129      12.103  34.868  21.652  1.00 22.84           O  
ATOM   1093  CB  PRO A 129       9.842  33.381  23.127  1.00 22.23           C  
ATOM   1094  CG  PRO A 129       8.938  34.378  22.605  1.00 23.29           C  
ATOM   1095  CD  PRO A 129       9.082  35.563  23.546  1.00 20.63           C  
ATOM   1096  N   GLY A 130      13.202  33.377  22.963  1.00 20.82           N  
ATOM   1097  CA  GLY A 130      14.357  33.245  22.070  1.00 21.21           C  
ATOM   1098  C   GLY A 130      15.478  34.263  22.202  1.00 22.51           C  
ATOM   1099  O   GLY A 130      16.530  34.108  21.605  1.00 24.68           O  
ATOM   1100  N   LYS A 131      15.276  35.320  22.966  1.00 20.10           N  
ATOM   1101  CA  LYS A 131      16.316  36.293  23.153  1.00 20.50           C  
ATOM   1102  C   LYS A 131      17.233  35.801  24.257  1.00 22.39           C  
ATOM   1103  O   LYS A 131      16.878  34.894  24.960  1.00 18.81           O  
ATOM   1104  CB  LYS A 131      15.698  37.652  23.522  1.00 21.81           C  
ATOM   1105  CG  LYS A 131      14.764  38.206  22.455  1.00 24.68           C  
ATOM   1106  CD  LYS A 131      15.419  38.339  21.109  1.00 34.13           C  
ATOM   1107  CE  LYS A 131      14.520  39.100  20.132  1.00 41.24           C  
ATOM   1108  NZ  LYS A 131      15.279  39.547  18.938  1.00 36.23           N  
ATOM   1109  N   PRO A 132      18.417  36.418  24.422  1.00 20.31           N  
ATOM   1110  CA  PRO A 132      19.314  36.042  25.516  1.00 20.91           C  
ATOM   1111  C   PRO A 132      18.642  35.979  26.873  1.00 17.95           C  
ATOM   1112  O   PRO A 132      17.895  36.887  27.231  1.00 22.36           O  
ATOM   1113  CB  PRO A 132      20.354  37.168  25.485  1.00 23.22           C  
ATOM   1114  CG  PRO A 132      20.468  37.448  23.979  1.00 24.10           C  
ATOM   1115  CD  PRO A 132      19.025  37.475  23.572  1.00 22.49           C  
ATOM   1116  N   ARG A 133      18.907  34.919  27.625  1.00 17.74           N  
ATOM   1117  CA  ARG A 133      18.164  34.608  28.845  1.00 15.74           C  
ATOM   1118  C   ARG A 133      18.326  35.732  29.866  1.00 19.26           C  
ATOM   1119  O   ARG A 133      19.452  36.106  30.212  1.00 20.99           O  
ATOM   1120  CB  ARG A 133      18.654  33.300  29.452  1.00 18.97           C  
ATOM   1121  CG  ARG A 133      18.051  32.968  30.842  1.00 19.90           C  
ATOM   1122  CD  ARG A 133      16.558  33.027  30.842  1.00 17.48           C  
ATOM   1123  NE  ARG A 133      16.023  32.782  32.159  1.00 16.15           N  
ATOM   1124  CZ  ARG A 133      15.589  31.628  32.635  1.00 22.81           C  
ATOM   1125  NH1 ARG A 133      15.656  30.522  31.901  1.00 22.43           N  
ATOM   1126  NH2 ARG A 133      15.086  31.596  33.872  1.00 25.84           N  
ATOM   1127  N   ILE A 134      17.201  36.295  30.300  1.00 19.36           N  
ATOM   1128  CA  ILE A 134      17.168  37.236  31.417  1.00 18.11           C  
ATOM   1129  C   ILE A 134      17.519  36.450  32.680  1.00 19.87           C  
ATOM   1130  O   ILE A 134      16.847  35.480  33.005  1.00 19.25           O  
ATOM   1131  CB  ILE A 134      15.782  37.862  31.532  1.00 19.39           C  
ATOM   1132  CG1 ILE A 134      15.514  38.781  30.326  1.00 22.92           C  
ATOM   1133  CG2 ILE A 134      15.628  38.662  32.850  1.00 23.26           C  
ATOM   1134  CD1 ILE A 134      16.458  39.981  30.265  1.00 28.47           C  
ATOM   1135  N   LYS A 135      18.522  36.916  33.425  1.00 22.78           N  
ATOM   1136  CA  LYS A 135      19.060  36.135  34.557  1.00 27.22           C  
ATOM   1137  C   LYS A 135      18.320  36.371  35.882  1.00 29.80           C  
ATOM   1138  O   LYS A 135      18.437  35.552  36.806  1.00 29.88           O  
ATOM   1139  CB  LYS A 135      20.536  36.423  34.763  1.00 26.96           C  
ATOM   1140  CG  LYS A 135      21.447  35.833  33.690  1.00 25.39           C  
ATOM   1141  CD  LYS A 135      22.896  36.310  33.932  1.00 31.68           C  
ATOM   1142  CE  LYS A 135      23.835  35.886  32.818  1.00 40.66           C  
ATOM   1143  NZ  LYS A 135      23.550  36.612  31.539  1.00 48.50           N  
ATOM   1144  N   GLU A 136      17.540  37.443  35.967  1.00 29.27           N  
ATOM   1145  CA  GLU A 136      16.799  37.739  37.191  1.00 32.36           C  
ATOM   1146  C   GLU A 136      15.464  36.979  37.206  1.00 33.16           C  
ATOM   1147  O   GLU A 136      14.662  37.080  36.270  1.00 33.14           O  
ATOM   1148  CB  GLU A 136      16.562  39.244  37.335  1.00 33.81           C  
ATOM   1149  CG  GLU A 136      17.859  40.027  37.567  1.00 36.72           C  
ATOM   1150  CD  GLU A 136      18.763  40.104  36.328  1.00 45.25           C  
ATOM   1151  OE1 GLU A 136      18.217  40.034  35.198  1.00 41.95           O  
ATOM   1152  OE2 GLU A 136      20.011  40.240  36.490  1.00 39.02           O  
ATOM   1153  N   SER A 137      15.220  36.242  38.291  1.00 33.90           N  
ATOM   1154  CA  SER A 137      14.013  35.421  38.420  1.00 33.01           C  
ATOM   1155  C   SER A 137      12.740  36.268  38.373  1.00 31.78           C  
ATOM   1156  O   SER A 137      11.679  35.772  37.977  1.00 33.24           O  
ATOM   1157  N   GLY A 138      12.855  37.535  38.778  1.00 29.70           N  
ATOM   1158  CA  GLY A 138      11.722  38.456  38.812  1.00 28.29           C  
ATOM   1159  C   GLY A 138      10.968  38.595  37.495  1.00 25.88           C  
ATOM   1160  O   GLY A 138       9.741  38.698  37.491  1.00 26.12           O  
ATOM   1161  N   ALA A 139      11.713  38.583  36.383  1.00 24.83           N  
ATOM   1162  CA  ALA A 139      11.147  38.733  35.037  1.00 24.47           C  
ATOM   1163  C   ALA A 139      10.199  37.594  34.698  1.00 21.89           C  
ATOM   1164  O   ALA A 139       9.359  37.731  33.834  1.00 22.31           O  
ATOM   1165  CB  ALA A 139      12.263  38.795  33.997  1.00 26.17           C  
ATOM   1166  N   PHE A 140      10.337  36.470  35.402  1.00 21.83           N  
ATOM   1167  CA  PHE A 140       9.501  35.293  35.178  1.00 19.71           C  
ATOM   1168  C   PHE A 140       8.389  35.131  36.201  1.00 20.47           C  
ATOM   1169  O   PHE A 140       7.637  34.152  36.143  1.00 23.61           O  
ATOM   1170  CB  PHE A 140      10.396  34.048  35.108  1.00 22.83           C  
ATOM   1171  CG  PHE A 140      11.260  34.053  33.898  1.00 19.32           C  
ATOM   1172  CD1 PHE A 140      10.781  33.537  32.705  1.00 22.60           C  
ATOM   1173  CD2 PHE A 140      12.532  34.620  33.915  1.00 19.89           C  
ATOM   1174  CE1 PHE A 140      11.529  33.578  31.555  1.00 20.74           C  
ATOM   1175  CE2 PHE A 140      13.276  34.674  32.772  1.00 22.17           C  
ATOM   1176  CZ  PHE A 140      12.777  34.120  31.581  1.00 22.73           C  
ATOM   1177  N   GLU A 141       8.249  36.139  37.067  1.00 20.12           N  
ATOM   1178  CA  GLU A 141       7.250  36.175  38.137  1.00 20.86           C  
ATOM   1179  C   GLU A 141       6.407  37.431  38.050  1.00 17.75           C  
ATOM   1180  O   GLU A 141       6.239  38.123  39.027  1.00 19.04           O  
ATOM   1181  CB  GLU A 141       7.964  36.153  39.506  1.00 20.16           C  
ATOM   1182  CG  GLU A 141       8.830  34.912  39.704  1.00 25.36           C  
ATOM   1183  CD  GLU A 141       9.659  34.923  40.979  1.00 30.33           C  
ATOM   1184  OE1 GLU A 141       9.817  35.991  41.613  1.00 41.84           O  
ATOM   1185  OE2 GLU A 141      10.201  33.844  41.318  1.00 46.76           O  
ATOM   1186  N   PRO A 142       5.853  37.718  36.846  1.00 18.67           N  
ATOM   1187  CA  PRO A 142       5.002  38.908  36.762  1.00 20.82           C  
ATOM   1188  C   PRO A 142       3.692  38.725  37.519  1.00 17.27           C  
ATOM   1189  O   PRO A 142       3.303  37.601  37.796  1.00 19.32           O  
ATOM   1190  CB  PRO A 142       4.736  39.017  35.258  1.00 23.14           C  
ATOM   1191  CG  PRO A 142       4.772  37.665  34.784  1.00 24.38           C  
ATOM   1192  CD  PRO A 142       5.915  36.998  35.564  1.00 21.35           C  
ATOM   1193  N   SER A 143       2.998  39.807  37.837  1.00 16.33           N  
ATOM   1194  CA  SER A 143       1.646  39.710  38.410  1.00 17.25           C  
ATOM   1195  C   SER A 143       0.749  39.085  37.363  1.00 17.93           C  
ATOM   1196  O   SER A 143       0.948  39.273  36.170  1.00 16.98           O  
ATOM   1197  CB  SER A 143       1.135  41.101  38.692  1.00 19.38           C  
ATOM   1198  OG  SER A 143       0.055  41.101  39.598  1.00 21.75           O  
ATOM   1199  N   PRO A 144      -0.269  38.325  37.800  1.00 20.87           N  
ATOM   1200  CA  PRO A 144      -1.123  37.663  36.818  1.00 19.90           C  
ATOM   1201  C   PRO A 144      -1.791  38.672  35.938  1.00 14.71           C  
ATOM   1202  O   PRO A 144      -2.197  39.717  36.406  1.00 18.35           O  
ATOM   1203  CB  PRO A 144      -2.244  37.060  37.698  1.00 23.06           C  
ATOM   1204  CG  PRO A 144      -2.227  37.870  38.950  1.00 29.04           C  
ATOM   1205  CD  PRO A 144      -0.759  38.088  39.172  1.00 23.71           C  
ATOM   1206  N   PRO A 145      -1.942  38.352  34.649  1.00 13.93           N  
ATOM   1207  CA  PRO A 145      -2.720  39.245  33.823  1.00 14.17           C  
ATOM   1208  C   PRO A 145      -4.223  39.185  34.132  1.00 13.30           C  
ATOM   1209  O   PRO A 145      -4.705  38.295  34.858  1.00 15.27           O  
ATOM   1210  CB  PRO A 145      -2.416  38.759  32.415  1.00 15.93           C  
ATOM   1211  CG  PRO A 145      -2.200  37.375  32.573  1.00 16.71           C  
ATOM   1212  CD  PRO A 145      -1.448  37.218  33.884  1.00 16.38           C  
ATOM   1213  N   ASP A 146      -4.967  40.089  33.526  1.00 12.71           N  
ATOM   1214  CA  ASP A 146      -6.440  40.079  33.612  1.00 12.43           C  
ATOM   1215  C   ASP A 146      -6.938  38.697  33.178  1.00 12.81           C  
ATOM   1216  O   ASP A 146      -6.634  38.262  32.089  1.00 13.02           O  
ATOM   1217  CB  ASP A 146      -6.965  41.135  32.631  1.00 11.07           C  
ATOM   1218  CG  ASP A 146      -8.412  41.379  32.722  1.00 12.14           C  
ATOM   1219  OD1 ASP A 146      -9.150  40.399  32.902  1.00 15.27           O  
ATOM   1220  OD2 ASP A 146      -8.860  42.502  32.561  1.00 11.80           O  
ATOM   1221  N   PRO A 147      -7.673  37.994  34.049  1.00 12.74           N  
ATOM   1222  CA  PRO A 147      -8.085  36.636  33.703  1.00 13.85           C  
ATOM   1223  C   PRO A 147      -9.319  36.581  32.815  1.00 12.45           C  
ATOM   1224  O   PRO A 147      -9.706  35.500  32.355  1.00 13.94           O  
ATOM   1225  CB  PRO A 147      -8.384  36.028  35.077  1.00 15.15           C  
ATOM   1226  CG  PRO A 147      -8.866  37.195  35.897  1.00 14.57           C  
ATOM   1227  CD  PRO A 147      -7.962  38.326  35.464  1.00 13.55           C  
ATOM   1228  N   ILE A 148      -9.876  37.742  32.511  1.00 11.68           N  
ATOM   1229  CA  ILE A 148     -11.070  37.871  31.674  1.00 12.32           C  
ATOM   1230  C   ILE A 148     -10.698  38.260  30.229  1.00 12.42           C  
ATOM   1231  O   ILE A 148     -11.317  37.830  29.247  1.00 13.41           O  
ATOM   1232  CB  ILE A 148     -12.044  38.926  32.266  1.00 12.72           C  
ATOM   1233  CG1 ILE A 148     -12.424  38.538  33.685  1.00 17.96           C  
ATOM   1234  CG2 ILE A 148     -13.276  39.161  31.391  1.00 12.12           C  
ATOM   1235  CD1 ILE A 148     -13.032  37.202  33.809  1.00 22.06           C  
ATOM   1236  N   GLU A 149      -9.695  39.141  30.086  1.00 12.37           N  
ATOM   1237  CA  GLU A 149      -9.391  39.821  28.831  1.00 11.96           C  
ATOM   1238  C   GLU A 149      -8.015  39.433  28.340  1.00 12.21           C  
ATOM   1239  O   GLU A 149      -7.033  39.717  29.015  1.00 12.30           O  
ATOM   1240  CB  GLU A 149      -9.445  41.335  29.078  1.00 12.84           C  
ATOM   1241  CG  GLU A 149     -10.776  41.776  29.680  1.00 11.33           C  
ATOM   1242  CD  GLU A 149     -11.183  43.202  29.479  1.00 11.80           C  
ATOM   1243  OE1 GLU A 149     -10.497  43.985  28.784  1.00 13.21           O  
ATOM   1244  OE2 GLU A 149     -12.259  43.599  29.994  1.00 13.06           O  
ATOM   1245  N   PRO A 150      -7.888  38.779  27.193  1.00 12.73           N  
ATOM   1246  CA  PRO A 150      -6.597  38.283  26.737  1.00 12.71           C  
ATOM   1247  C   PRO A 150      -5.589  39.362  26.449  1.00 11.14           C  
ATOM   1248  O   PRO A 150      -5.939  40.425  25.964  1.00 13.40           O  
ATOM   1249  CB  PRO A 150      -6.930  37.476  25.473  1.00 14.43           C  
ATOM   1250  CG  PRO A 150      -8.264  37.927  25.052  1.00 16.47           C  
ATOM   1251  CD  PRO A 150      -8.996  38.390  26.283  1.00 14.38           C  
ATOM   1252  N   VAL A 151      -4.307  39.048  26.700  1.00 13.49           N  
ATOM   1253  CA  VAL A 151      -3.226  39.978  26.394  1.00 13.03           C  
ATOM   1254  C   VAL A 151      -2.918  39.931  24.895  1.00 13.49           C  
ATOM   1255  O   VAL A 151      -3.234  38.952  24.229  1.00 13.40           O  
ATOM   1256  CB  VAL A 151      -1.983  39.650  27.259  1.00 13.67           C  
ATOM   1257  CG1 VAL A 151      -2.288  39.827  28.755  1.00 16.20           C  
ATOM   1258  CG2 VAL A 151      -1.477  38.257  26.947  1.00 12.85           C  
ATOM   1259  N   PRO A 152      -2.321  40.996  24.363  1.00 14.78           N  
ATOM   1260  CA  PRO A 152      -2.182  41.097  22.918  1.00 15.19           C  
ATOM   1261  C   PRO A 152      -1.328  40.044  22.284  1.00 15.86           C  
ATOM   1262  O   PRO A 152      -1.555  39.716  21.132  1.00 20.84           O  
ATOM   1263  CB  PRO A 152      -1.536  42.455  22.712  1.00 15.77           C  
ATOM   1264  CG  PRO A 152      -1.801  43.215  23.934  1.00 18.43           C  
ATOM   1265  CD  PRO A 152      -1.930  42.238  25.042  1.00 15.19           C  
ATOM   1266  N   ASN A 153      -0.410  39.435  23.032  1.00 13.95           N  
ATOM   1267  CA  ASN A 153       0.435  38.399  22.483  1.00 16.05           C  
ATOM   1268  C   ASN A 153      -0.138  36.987  22.662  1.00 17.07           C  
ATOM   1269  O   ASN A 153       0.505  36.018  22.293  1.00 17.29           O  
ATOM   1270  CB  ASN A 153       1.832  38.455  23.056  1.00 16.08           C  
ATOM   1271  CG  ASN A 153       1.878  38.384  24.569  1.00 18.46           C  
ATOM   1272  OD1 ASN A 153       1.220  39.181  25.254  1.00 20.08           O  
ATOM   1273  ND2 ASN A 153       2.702  37.504  25.103  1.00 21.23           N  
ATOM   1274  N   PHE A 154      -1.328  36.880  23.224  1.00 14.69           N  
ATOM   1275  CA  PHE A 154      -2.019  35.593  23.293  1.00 14.10           C  
ATOM   1276  C   PHE A 154      -2.729  35.253  22.008  1.00 14.30           C  
ATOM   1277  O   PHE A 154      -3.569  36.037  21.544  1.00 14.77           O  
ATOM   1278  CB  PHE A 154      -3.086  35.657  24.387  1.00 12.61           C  
ATOM   1279  CG  PHE A 154      -3.902  34.389  24.484  1.00 14.95           C  
ATOM   1280  CD1 PHE A 154      -3.342  33.212  25.009  1.00 13.20           C  
ATOM   1281  CD2 PHE A 154      -5.245  34.360  24.112  1.00 13.33           C  
ATOM   1282  CE1 PHE A 154      -4.086  32.052  25.092  1.00 14.23           C  
ATOM   1283  CE2 PHE A 154      -5.966  33.184  24.162  1.00 13.13           C  
ATOM   1284  CZ  PHE A 154      -5.407  32.048  24.679  1.00 13.56           C  
ATOM   1285  N   CYS A 155      -2.443  34.050  21.459  1.00 14.22           N  
ATOM   1286  CA  CYS A 155      -3.139  33.534  20.314  1.00 13.54           C  
ATOM   1287  C   CYS A 155      -3.809  32.224  20.614  1.00 16.40           C  
ATOM   1288  O   CYS A 155      -3.272  31.363  21.326  1.00 15.84           O  
ATOM   1289  CB  CYS A 155      -2.156  33.181  19.236  1.00 16.50           C  
ATOM   1290  SG  CYS A 155      -1.224  34.525  18.650  1.00 21.76           S  
ATOM   1291  N   LEU A 156      -4.994  32.073  20.041  1.00 13.91           N  
ATOM   1292  CA  LEU A 156      -5.671  30.775  19.886  1.00 16.23           C  
ATOM   1293  C   LEU A 156      -5.269  30.264  18.484  1.00 15.15           C  
ATOM   1294  O   LEU A 156      -5.339  30.947  17.490  1.00 17.84           O  
ATOM   1295  CB  LEU A 156      -7.195  30.918  19.957  1.00 14.66           C  
ATOM   1296  CG  LEU A 156      -8.007  29.656  19.599  1.00 15.39           C  
ATOM   1297  CD1 LEU A 156      -7.731  28.474  20.520  1.00 16.45           C  
ATOM   1298  CD2 LEU A 156      -9.520  30.012  19.629  1.00 17.48           C  
ATOM   1299  N   LEU A 157      -4.789  29.048  18.451  1.00 14.78           N  
ATOM   1300  CA  LEU A 157      -4.387  28.376  17.198  1.00 15.97           C  
ATOM   1301  C   LEU A 157      -5.338  27.211  16.973  1.00 15.59           C  
ATOM   1302  O   LEU A 157      -5.498  26.352  17.869  1.00 16.73           O  
ATOM   1303  CB  LEU A 157      -2.936  27.960  17.314  1.00 16.46           C  
ATOM   1304  CG  LEU A 157      -2.337  27.200  16.169  1.00 19.40           C  
ATOM   1305  CD1 LEU A 157      -2.394  28.054  14.890  1.00 19.90           C  
ATOM   1306  CD2 LEU A 157      -0.865  26.827  16.555  1.00 21.38           C  
ATOM   1307  N   LEU A 158      -6.003  27.191  15.826  1.00 14.79           N  
ATOM   1308  CA  LEU A 158      -6.894  26.083  15.437  1.00 15.96           C  
ATOM   1309  C   LEU A 158      -6.281  25.300  14.298  1.00 16.26           C  
ATOM   1310  O   LEU A 158      -5.785  25.915  13.343  1.00 16.87           O  
ATOM   1311  CB  LEU A 158      -8.208  26.630  14.977  1.00 16.32           C  
ATOM   1312  CG  LEU A 158      -8.971  27.442  16.003  1.00 14.97           C  
ATOM   1313  CD1 LEU A 158     -10.235  28.069  15.301  1.00 18.88           C  
ATOM   1314  CD2 LEU A 158      -9.366  26.676  17.278  1.00 16.51           C  
ATOM   1315  N   LEU A 159      -6.400  23.980  14.347  1.00 15.27           N  
ATOM   1316  CA  LEU A 159      -6.113  23.099  13.230  1.00 15.45           C  
ATOM   1317  C   LEU A 159      -7.396  22.430  12.765  1.00 14.93           C  
ATOM   1318  O   LEU A 159      -8.125  21.829  13.566  1.00 16.61           O  
ATOM   1319  CB  LEU A 159      -5.094  22.038  13.648  1.00 14.98           C  
ATOM   1320  CG  LEU A 159      -4.842  21.003  12.539  1.00 19.52           C  
ATOM   1321  CD1 LEU A 159      -4.061  21.611  11.453  1.00 20.26           C  
ATOM   1322  CD2 LEU A 159      -4.067  19.805  13.183  1.00 24.12           C  
ATOM   1323  N   ASP A 160      -7.662  22.544  11.465  1.00 16.21           N  
ATOM   1324  CA  ASP A 160      -8.812  21.887  10.816  1.00 16.54           C  
ATOM   1325  C   ASP A 160      -8.316  20.738   9.950  1.00 16.70           C  
ATOM   1326  O   ASP A 160      -7.874  20.987   8.819  1.00 17.12           O  
ATOM   1327  CB  ASP A 160      -9.586  22.859   9.937  1.00 18.32           C  
ATOM   1328  CG  ASP A 160     -10.932  22.260   9.450  1.00 20.93           C  
ATOM   1329  OD1 ASP A 160     -11.530  21.389  10.152  1.00 30.29           O  
ATOM   1330  OD2 ASP A 160     -11.429  22.776   8.435  1.00 35.80           O  
ATOM   1331  N   PRO A 161      -8.339  19.501  10.486  1.00 17.31           N  
ATOM   1332  CA  PRO A 161      -7.788  18.415   9.681  1.00 14.70           C  
ATOM   1333  C   PRO A 161      -8.543  18.131   8.388  1.00 16.11           C  
ATOM   1334  O   PRO A 161      -9.765  18.099   8.382  1.00 16.75           O  
ATOM   1335  CB  PRO A 161      -7.892  17.206  10.607  1.00 16.27           C  
ATOM   1336  CG  PRO A 161      -7.939  17.764  11.987  1.00 17.84           C  
ATOM   1337  CD  PRO A 161      -8.776  19.006  11.810  1.00 18.23           C  
ATOM   1338  N   VAL A 162      -7.778  17.956   7.322  1.00 14.35           N  
ATOM   1339  CA  VAL A 162      -8.385  17.407   6.121  0.50 13.51           C  
ATOM   1341  C   VAL A 162      -7.858  16.032   5.755  1.00 15.71           C  
ATOM   1342  O   VAL A 162      -8.448  15.364   4.922  1.00 15.45           O  
ATOM   1343  CB  VAL A 162      -8.300  18.371   4.926  0.50 12.94           C  
ATOM   1345  CG1 VAL A 162      -8.940  19.686   5.267  0.50 17.08           C  
ATOM   1347  CG2 VAL A 162      -6.864  18.552   4.475  0.50 20.10           C  
ATOM   1349  N   GLN A 163      -6.808  15.567   6.424  1.00 14.36           N  
ATOM   1350  CA  GLN A 163      -6.328  14.223   6.234  1.00 13.93           C  
ATOM   1351  C   GLN A 163      -5.851  13.711   7.574  1.00 13.91           C  
ATOM   1352  O   GLN A 163      -5.144  14.435   8.293  1.00 15.23           O  
ATOM   1353  CB  GLN A 163      -5.185  14.132   5.215  1.00 17.34           C  
ATOM   1354  CG  GLN A 163      -4.816  12.693   4.839  1.00 19.55           C  
ATOM   1355  CD  GLN A 163      -4.088  12.533   3.523  1.00 26.51           C  
ATOM   1356  OE1 GLN A 163      -2.993  11.976   3.477  1.00 31.74           O  
ATOM   1357  NE2 GLN A 163      -4.708  12.976   2.446  1.00 26.41           N  
ATOM   1358  N   VAL A 164      -6.236  12.479   7.922  1.00 13.60           N  
ATOM   1359  CA  VAL A 164      -5.845  11.858   9.174  1.00 13.57           C  
ATOM   1360  C   VAL A 164      -5.352  10.438   8.879  1.00 14.74           C  
ATOM   1361  O   VAL A 164      -6.035   9.685   8.177  1.00 16.10           O  
ATOM   1362  CB  VAL A 164      -7.008  11.840  10.167  1.00 13.83           C  
ATOM   1363  CG1 VAL A 164      -6.642  11.057  11.460  1.00 14.89           C  
ATOM   1364  CG2 VAL A 164      -7.433  13.273  10.486  1.00 15.28           C  
ATOM   1365  N   ASP A 165      -4.195  10.063   9.401  1.00 14.37           N  
ATOM   1366  CA  ASP A 165      -3.591   8.701   9.274  1.00 14.19           C  
ATOM   1367  C   ASP A 165      -3.514   8.168  10.692  1.00 15.63           C  
ATOM   1368  O   ASP A 165      -2.819   8.757  11.544  1.00 17.22           O  
ATOM   1369  CB  ASP A 165      -2.210   8.907   8.646  1.00 15.31           C  
ATOM   1370  CG  ASP A 165      -1.422   7.654   8.343  1.00 25.14           C  
ATOM   1371  OD1 ASP A 165      -1.760   6.569   8.774  1.00 29.15           O  
ATOM   1372  OD2 ASP A 165      -0.350   7.838   7.699  1.00 31.78           O  
ATOM   1373  N   HIS A 166      -4.249   7.115  10.988  1.00 12.87           N  
ATOM   1374  CA  HIS A 166      -4.273   6.479  12.301  1.00 12.64           C  
ATOM   1375  C   HIS A 166      -3.609   5.118  12.254  1.00 12.80           C  
ATOM   1376  O   HIS A 166      -4.082   4.234  11.541  1.00 13.49           O  
ATOM   1377  CB  HIS A 166      -5.715   6.328  12.743  1.00 14.06           C  
ATOM   1378  CG  HIS A 166      -5.885   5.717  14.093  1.00 15.32           C  
ATOM   1379  ND1 HIS A 166      -7.018   4.995  14.431  1.00 16.71           N  
ATOM   1380  CD2 HIS A 166      -5.100   5.747  15.200  1.00 14.81           C  
ATOM   1381  CE1 HIS A 166      -6.910   4.592  15.686  1.00 18.85           C  
ATOM   1382  NE2 HIS A 166      -5.757   5.036  16.180  1.00 16.39           N  
ATOM   1383  N   LEU A 167      -2.537   4.946  13.010  1.00 13.52           N  
ATOM   1384  CA  LEU A 167      -1.748   3.733  13.055  1.00 12.68           C  
ATOM   1385  C   LEU A 167      -1.887   3.147  14.458  1.00 13.50           C  
ATOM   1386  O   LEU A 167      -1.608   3.824  15.448  1.00 14.22           O  
ATOM   1387  CB  LEU A 167      -0.288   4.055  12.775  1.00 13.78           C  
ATOM   1388  CG  LEU A 167       0.698   2.894  12.887  1.00 15.55           C  
ATOM   1389  CD1 LEU A 167       0.427   1.841  11.816  1.00 15.91           C  
ATOM   1390  CD2 LEU A 167       2.123   3.421  12.768  1.00 16.23           C  
ATOM   1391  N   GLU A 168      -2.345   1.899  14.517  1.00 14.54           N  
ATOM   1392  CA  GLU A 168      -2.455   1.114  15.749  1.00 13.99           C  
ATOM   1393  C   GLU A 168      -1.362   0.058  15.731  1.00 15.94           C  
ATOM   1394  O   GLU A 168      -1.399  -0.852  14.903  1.00 15.92           O  
ATOM   1395  CB  GLU A 168      -3.827   0.447  15.816  1.00 16.35           C  
ATOM   1396  CG  GLU A 168      -4.925   1.423  16.076  1.00 18.69           C  
ATOM   1397  CD  GLU A 168      -6.292   0.793  16.146  1.00 28.39           C  
ATOM   1398  OE1 GLU A 168      -6.486  -0.294  15.570  1.00 32.52           O  
ATOM   1399  OE2 GLU A 168      -7.169   1.412  16.785  1.00 29.97           O  
ATOM   1400  N   LEU A 169      -0.398   0.151  16.643  1.00 15.43           N  
ATOM   1401  CA  LEU A 169       0.646  -0.853  16.683  1.00 15.89           C  
ATOM   1402  C   LEU A 169       0.156  -2.142  17.304  1.00 18.49           C  
ATOM   1403  O   LEU A 169       0.804  -3.180  17.099  1.00 18.52           O  
ATOM   1404  CB  LEU A 169       1.863  -0.338  17.422  1.00 15.73           C  
ATOM   1405  CG  LEU A 169       2.516   0.894  16.802  1.00 16.49           C  
ATOM   1406  CD1 LEU A 169       3.717   1.333  17.669  1.00 20.87           C  
ATOM   1407  CD2 LEU A 169       2.946   0.660  15.361  1.00 18.62           C  
ATOM   1408  N   ARG A 170      -0.917  -2.108  18.081  1.00 18.37           N  
ATOM   1409  CA  ARG A 170      -1.505  -3.320  18.669  0.50 22.54           C  
ATOM   1411  C   ARG A 170      -2.599  -3.834  17.750  1.00 23.25           C  
ATOM   1412  O   ARG A 170      -3.777  -3.714  18.074  1.00 27.36           O  
ATOM   1413  CB  ARG A 170      -2.132  -3.037  20.041  0.50 23.72           C  
ATOM   1415  CG  ARG A 170      -1.153  -2.706  21.145  0.50 29.68           C  
ATOM   1417  CD  ARG A 170      -1.561  -1.460  21.936  0.50 34.16           C  
ATOM   1419  NE  ARG A 170      -2.538  -1.641  23.016  0.50 30.32           N  
ATOM   1421  CZ  ARG A 170      -3.715  -1.025  23.125  0.50 28.03           C  
ATOM   1423  NH1 ARG A 170      -4.142  -0.174  22.204  0.50 37.00           N  
ATOM   1425  NH2 ARG A 170      -4.492  -1.266  24.177  0.50 32.21           N  
ATOM   1427  N   GLY A 171      -2.219  -4.391  16.611  1.00 23.68           N  
ATOM   1428  CA  GLY A 171      -3.179  -4.900  15.617  1.00 23.75           C  
ATOM   1429  C   GLY A 171      -2.902  -6.338  15.245  1.00 23.48           C  
ATOM   1430  O   GLY A 171      -2.417  -7.129  16.049  1.00 24.63           O  
ATOM   1431  N   GLU A 172      -3.175  -6.681  13.987  1.00 25.82           N  
ATOM   1432  CA  GLU A 172      -2.988  -8.041  13.509  1.00 28.91           C  
ATOM   1433  C   GLU A 172      -2.238  -8.056  12.169  1.00 28.79           C  
ATOM   1434  O   GLU A 172      -2.776  -8.498  11.145  1.00 31.27           O  
ATOM   1435  CB  GLU A 172      -4.347  -8.765  13.418  1.00 33.05           C  
ATOM   1436  CG  GLU A 172      -4.930  -9.128  14.805  1.00 34.19           C  
ATOM   1437  N   PRO A 173      -0.972  -7.616  12.176  1.00 22.40           N  
ATOM   1438  CA  PRO A 173      -0.164  -7.216  13.328  1.00 21.24           C  
ATOM   1439  C   PRO A 173      -0.271  -5.729  13.732  1.00 20.28           C  
ATOM   1440  O   PRO A 173      -0.006  -5.375  14.903  1.00 19.27           O  
ATOM   1441  CB  PRO A 173       1.263  -7.533  12.858  1.00 23.76           C  
ATOM   1442  CG  PRO A 173       1.229  -7.397  11.382  1.00 25.16           C  
ATOM   1443  CD  PRO A 173      -0.197  -7.619  10.918  1.00 23.50           C  
ATOM   1444  N   GLN A 174      -0.607  -4.889  12.763  1.00 19.09           N  
ATOM   1445  CA  GLN A 174      -0.846  -3.461  12.968  1.00 16.74           C  
ATOM   1446  C   GLN A 174      -1.983  -3.068  12.088  1.00 17.73           C  
ATOM   1447  O   GLN A 174      -2.240  -3.740  11.080  1.00 19.70           O  
ATOM   1448  CB  GLN A 174       0.361  -2.629  12.558  1.00 17.35           C  
ATOM   1449  CG  GLN A 174       1.634  -3.003  13.284  1.00 17.73           C  
ATOM   1450  CD  GLN A 174       2.826  -2.087  12.942  1.00 18.71           C  
ATOM   1451  OE1 GLN A 174       3.934  -2.231  13.486  1.00 20.59           O  
ATOM   1452  NE2 GLN A 174       2.602  -1.150  12.007  1.00 20.62           N  
ATOM   1453  N   ASN A 175      -2.702  -2.020  12.455  1.00 18.17           N  
ATOM   1454  CA  ASN A 175      -3.812  -1.511  11.648  1.00 18.24           C  
ATOM   1455  C   ASN A 175      -3.498  -0.062  11.286  1.00 16.38           C  
ATOM   1456  O   ASN A 175      -2.974   0.681  12.114  1.00 17.04           O  
ATOM   1457  CB  ASN A 175      -5.131  -1.537  12.441  1.00 18.12           C  
ATOM   1458  CG  ASN A 175      -5.460  -2.911  13.013  1.00 28.90           C  
ATOM   1459  OD1 ASN A 175      -5.295  -3.892  12.342  1.00 32.27           O  
ATOM   1460  ND2 ASN A 175      -5.928  -2.963  14.263  1.00 28.91           N  
ATOM   1461  N   ARG A 176      -3.780   0.333  10.057  1.00 16.02           N  
ATOM   1462  CA  ARG A 176      -3.587   1.700   9.616  1.00 15.12           C  
ATOM   1463  C   ARG A 176      -4.770   2.116   8.765  1.00 16.20           C  
ATOM   1464  O   ARG A 176      -5.184   1.373   7.863  1.00 16.46           O  
ATOM   1465  CB  ARG A 176      -2.300   1.771   8.819  1.00 15.81           C  
ATOM   1466  CG  ARG A 176      -1.841   3.193   8.544  1.00 16.60           C  
ATOM   1467  CD  ARG A 176      -0.538   3.204   7.863  1.00 18.00           C  
ATOM   1468  NE  ARG A 176      -0.095   4.534   7.472  1.00 19.60           N  
ATOM   1469  CZ  ARG A 176       0.816   4.756   6.527  1.00 22.52           C  
ATOM   1470  NH1 ARG A 176       1.370   3.731   5.910  1.00 22.52           N  
ATOM   1471  NH2 ARG A 176       1.172   5.981   6.195  1.00 21.92           N  
ATOM   1472  N   TRP A 177      -5.341   3.272   9.086  1.00 16.70           N  
ATOM   1473  CA  TRP A 177      -6.488   3.827   8.403  1.00 16.22           C  
ATOM   1474  C   TRP A 177      -6.190   5.240   7.985  1.00 16.80           C  
ATOM   1475  O   TRP A 177      -5.630   6.008   8.766  1.00 16.09           O  
ATOM   1476  CB  TRP A 177      -7.712   3.826   9.314  1.00 18.84           C  
ATOM   1477  CG  TRP A 177      -8.349   2.534   9.429  1.00 24.48           C  
ATOM   1478  CD1 TRP A 177      -8.042   1.535  10.303  1.00 28.21           C  
ATOM   1479  CD2 TRP A 177      -9.447   2.056   8.643  1.00 24.71           C  
ATOM   1480  NE1 TRP A 177      -8.867   0.450  10.083  1.00 31.48           N  
ATOM   1481  CE2 TRP A 177      -9.737   0.753   9.079  1.00 27.00           C  
ATOM   1482  CE3 TRP A 177     -10.213   2.608   7.613  1.00 29.59           C  
ATOM   1483  CZ2 TRP A 177     -10.780  -0.011   8.517  1.00 30.80           C  
ATOM   1484  CZ3 TRP A 177     -11.239   1.851   7.051  1.00 32.90           C  
ATOM   1485  CH2 TRP A 177     -11.507   0.557   7.504  1.00 28.96           C  
ATOM   1486  N   LEU A 178      -6.580   5.589   6.764  1.00 15.00           N  
ATOM   1487  CA  LEU A 178      -6.452   6.911   6.225  1.00 14.47           C  
ATOM   1488  C   LEU A 178      -7.833   7.495   6.041  1.00 16.28           C  
ATOM   1489  O   LEU A 178      -8.719   6.857   5.482  1.00 16.48           O  
ATOM   1490  CB  LEU A 178      -5.741   6.854   4.878  1.00 16.25           C  
ATOM   1491  CG  LEU A 178      -5.316   8.114   4.178  1.00 22.41           C  
ATOM   1492  CD1 LEU A 178      -4.316   8.961   5.014  1.00 26.96           C  
ATOM   1493  CD2 LEU A 178      -4.721   7.670   2.800  1.00 25.46           C  
ATOM   1494  N   TYR A 179      -7.997   8.728   6.472  1.00 14.95           N  
ATOM   1495  CA  TYR A 179      -9.244   9.468   6.335  1.00 14.83           C  
ATOM   1496  C   TYR A 179      -8.934  10.717   5.530  1.00 14.59           C  
ATOM   1497  O   TYR A 179      -7.945  11.403   5.785  1.00 15.06           O  
ATOM   1498  CB  TYR A 179      -9.753   9.879   7.718  1.00 13.91           C  
ATOM   1499  CG  TYR A 179     -10.041   8.787   8.705  1.00 13.75           C  
ATOM   1500  CD1 TYR A 179      -9.038   8.242   9.475  1.00 16.32           C  
ATOM   1501  CD2 TYR A 179     -11.357   8.314   8.855  1.00 16.53           C  
ATOM   1502  CE1 TYR A 179      -9.297   7.262  10.372  1.00 17.22           C  
ATOM   1503  CE2 TYR A 179     -11.637   7.334   9.773  1.00 22.68           C  
ATOM   1504  CZ  TYR A 179     -10.601   6.814  10.537  1.00 21.57           C  
ATOM   1505  OH  TYR A 179     -10.866   5.792  11.443  1.00 23.22           O  
ATOM   1506  N   HIS A 180      -9.794  11.065   4.576  1.00 14.19           N  
ATOM   1507  CA  HIS A 180      -9.605  12.270   3.767  1.00 14.74           C  
ATOM   1508  C   HIS A 180     -10.924  13.035   3.598  1.00 16.40           C  
ATOM   1509  O   HIS A 180     -11.953  12.430   3.406  1.00 17.93           O  
ATOM   1510  CB  HIS A 180      -9.003  11.890   2.417  1.00 20.64           C  
ATOM   1511  CG  HIS A 180      -8.755  13.060   1.523  1.00 25.98           C  
ATOM   1512  ND1 HIS A 180      -7.674  13.903   1.669  1.00 38.14           N  
ATOM   1513  CD2 HIS A 180      -9.488  13.556   0.498  1.00 29.78           C  
ATOM   1514  CE1 HIS A 180      -7.754  14.868   0.767  1.00 36.68           C  
ATOM   1515  NE2 HIS A 180      -8.838  14.671   0.036  1.00 32.90           N  
ATOM   1516  N   ARG A 181     -10.854  14.354   3.674  1.00 15.63           N  
ATOM   1517  CA  ARG A 181     -12.006  15.229   3.498  1.00 17.43           C  
ATOM   1518  C   ARG A 181     -11.926  15.863   2.110  1.00 20.05           C  
ATOM   1519  O   ARG A 181     -10.882  16.413   1.749  1.00 20.18           O  
ATOM   1520  CB  ARG A 181     -12.013  16.328   4.557  1.00 17.47           C  
ATOM   1521  CG  ARG A 181     -13.355  16.995   4.642  1.00 20.70           C  
ATOM   1522  CD  ARG A 181     -13.407  18.026   5.649  1.00 19.06           C  
ATOM   1523  NE  ARG A 181     -12.623  19.198   5.267  1.00 21.23           N  
ATOM   1524  CZ  ARG A 181     -12.345  20.181   6.113  1.00 30.41           C  
ATOM   1525  NH1 ARG A 181     -12.753  20.086   7.369  1.00 29.17           N  
ATOM   1526  NH2 ARG A 181     -11.649  21.231   5.712  1.00 33.80           N  
ATOM   1527  N   ASN A 182     -13.004  15.744   1.333  1.00 23.13           N  
ATOM   1528  CA  ASN A 182     -12.986  16.292  -0.024  1.00 24.77           C  
ATOM   1529  C   ASN A 182     -13.452  17.743  -0.029  1.00 28.59           C  
ATOM   1530  O   ASN A 182     -13.671  18.354   1.033  1.00 24.60           O  
ATOM   1531  CB  ASN A 182     -13.782  15.377  -0.983  1.00 27.50           C  
ATOM   1532  CG  ASN A 182     -15.286  15.354  -0.719  1.00 28.66           C  
ATOM   1533  OD1 ASN A 182     -15.833  16.183  -0.019  1.00 22.70           O  
ATOM   1534  ND2 ASN A 182     -15.954  14.357  -1.301  1.00 31.00           N  
ATOM   1535  N   ASP A 183     -13.576  18.303  -1.234  1.00 30.90           N  
ATOM   1536  CA  ASP A 183     -14.008  19.691  -1.406  1.00 35.13           C  
ATOM   1537  C   ASP A 183     -15.438  19.981  -0.939  1.00 34.36           C  
ATOM   1538  O   ASP A 183     -15.770  21.139  -0.646  1.00 36.50           O  
ATOM   1539  CB  ASP A 183     -13.890  20.087  -2.881  1.00 38.87           C  
ATOM   1540  CG  ASP A 183     -14.834  19.302  -3.768  1.00 45.78           C  
ATOM   1541  OD1 ASP A 183     -14.740  18.053  -3.774  1.00 51.82           O  
ATOM   1542  OD2 ASP A 183     -15.666  19.932  -4.465  1.00 60.39           O  
ATOM   1543  N   GLN A 184     -16.276  18.943  -0.883  1.00 32.92           N  
ATOM   1544  CA  GLN A 184     -17.650  19.043  -0.333  1.00 33.05           C  
ATOM   1545  C   GLN A 184     -17.752  18.809   1.167  1.00 32.33           C  
ATOM   1546  O   GLN A 184     -18.860  18.698   1.710  1.00 29.79           O  
ATOM   1547  CB  GLN A 184     -18.582  18.036  -1.029  1.00 35.10           C  
ATOM   1548  CG  GLN A 184     -18.959  18.399  -2.459  1.00 41.82           C  
ATOM   1549  CD  GLN A 184     -17.924  17.996  -3.480  1.00 50.13           C  
ATOM   1550  OE1 GLN A 184     -17.165  17.041  -3.283  1.00 56.20           O  
ATOM   1551  NE2 GLN A 184     -17.896  18.714  -4.600  1.00 58.70           N  
ATOM   1552  N   GLN A 185     -16.599  18.708   1.840  1.00 29.20           N  
ATOM   1553  CA  GLN A 185     -16.533  18.515   3.292  1.00 26.97           C  
ATOM   1554  C   GLN A 185     -16.965  17.107   3.742  1.00 24.25           C  
ATOM   1555  O   GLN A 185     -17.237  16.872   4.915  1.00 27.23           O  
ATOM   1556  CB  GLN A 185     -17.260  19.608   4.049  1.00 29.97           C  
ATOM   1557  CG  GLN A 185     -16.662  21.003   3.811  1.00 33.22           C  
ATOM   1558  CD  GLN A 185     -15.270  21.170   4.417  1.00 38.74           C  
ATOM   1559  N   GLU A 186     -16.966  16.177   2.799  1.00 24.41           N  
ATOM   1560  CA  GLU A 186     -17.345  14.808   3.069  1.00 22.21           C  
ATOM   1561  C   GLU A 186     -16.071  13.993   3.352  1.00 21.41           C  
ATOM   1562  O   GLU A 186     -15.084  14.103   2.616  1.00 20.13           O  
ATOM   1563  CB  GLU A 186     -18.077  14.210   1.892  1.00 24.70           C  
ATOM   1564  CG  GLU A 186     -19.335  15.001   1.538  1.00 31.85           C  
ATOM   1565  CD  GLU A 186     -19.906  14.634   0.187  1.00 41.75           C  
ATOM   1566  OE1 GLU A 186     -19.155  14.145  -0.690  1.00 44.54           O  
ATOM   1567  OE2 GLU A 186     -21.116  14.863  -0.009  1.00 57.91           O  
ATOM   1568  N   TRP A 187     -16.131  13.172   4.402  1.00 19.54           N  
ATOM   1569  CA  TRP A 187     -15.008  12.294   4.757  1.00 19.21           C  
ATOM   1570  C   TRP A 187     -15.128  10.917   4.121  1.00 21.09           C  
ATOM   1571  O   TRP A 187     -16.227  10.355   4.002  1.00 25.52           O  
ATOM   1572  CB  TRP A 187     -14.911  12.145   6.276  1.00 17.27           C  
ATOM   1573  CG  TRP A 187     -14.406  13.335   6.958  1.00 17.18           C  
ATOM   1574  CD1 TRP A 187     -15.149  14.372   7.495  1.00 17.10           C  
ATOM   1575  CD2 TRP A 187     -13.030  13.676   7.194  1.00 15.46           C  
ATOM   1576  NE1 TRP A 187     -14.304  15.311   8.031  1.00 18.19           N  
ATOM   1577  CE2 TRP A 187     -13.003  14.905   7.861  1.00 15.76           C  
ATOM   1578  CE3 TRP A 187     -11.812  13.040   6.898  1.00 16.74           C  
ATOM   1579  CZ2 TRP A 187     -11.810  15.516   8.234  1.00 15.54           C  
ATOM   1580  CZ3 TRP A 187     -10.626  13.646   7.265  1.00 14.35           C  
ATOM   1581  CH2 TRP A 187     -10.632  14.866   7.920  1.00 13.78           C  
ATOM   1582  N   SER A 188     -13.985  10.388   3.686  1.00 17.96           N  
ATOM   1583  CA  SER A 188     -13.863   8.996   3.246  1.00 20.30           C  
ATOM   1584  C   SER A 188     -12.781   8.345   4.083  1.00 18.30           C  
ATOM   1585  O   SER A 188     -11.962   9.036   4.700  1.00 17.61           O  
ATOM   1586  CB  SER A 188     -13.502   8.942   1.765  1.00 24.35           C  
ATOM   1587  OG  SER A 188     -12.256   9.542   1.512  1.00 34.36           O  
ATOM   1588  N   SER A 189     -12.847   7.028   4.213  1.00 17.36           N  
ATOM   1589  CA  SER A 189     -11.795   6.293   4.901  1.00 17.56           C  
ATOM   1590  C   SER A 189     -11.413   5.014   4.210  1.00 18.47           C  
ATOM   1591  O   SER A 189     -12.201   4.456   3.447  1.00 19.02           O  
ATOM   1592  CB  SER A 189     -12.187   6.005   6.317  1.00 21.43           C  
ATOM   1593  OG  SER A 189     -13.236   5.107   6.389  1.00 26.83           O  
ATOM   1594  N   GLU A 190     -10.195   4.555   4.461  1.00 17.48           N  
ATOM   1595  CA  GLU A 190      -9.716   3.326   3.861  1.00 20.27           C  
ATOM   1596  C   GLU A 190      -8.624   2.699   4.697  1.00 18.94           C  
ATOM   1597  O   GLU A 190      -7.757   3.395   5.232  1.00 17.41           O  
ATOM   1598  CB  GLU A 190      -9.205   3.519   2.439  1.00 23.48           C  
ATOM   1599  CG  GLU A 190      -8.018   4.409   2.223  1.00 33.17           C  
ATOM   1600  CD  GLU A 190      -7.343   4.173   0.861  1.00 33.15           C  
ATOM   1601  OE1 GLU A 190      -7.574   3.113   0.243  1.00 45.13           O  
ATOM   1602  OE2 GLU A 190      -6.572   5.064   0.424  1.00 48.08           O  
ATOM   1603  N   ALA A 191      -8.693   1.397   4.842  1.00 18.25           N  
ATOM   1604  CA  ALA A 191      -7.640   0.651   5.499  1.00 16.75           C  
ATOM   1605  C   ALA A 191      -6.475   0.518   4.506  1.00 17.31           C  
ATOM   1606  O   ALA A 191      -6.648   0.113   3.327  1.00 17.98           O  
ATOM   1607  CB  ALA A 191      -8.159  -0.727   5.937  1.00 18.33           C  
ATOM   1608  N   ILE A 192      -5.263   0.799   5.010  1.00 15.04           N  
ATOM   1609  CA  ILE A 192      -4.053   0.776   4.184  1.00 16.32           C  
ATOM   1610  C   ILE A 192      -2.973  -0.045   4.863  1.00 17.05           C  
ATOM   1611  O   ILE A 192      -3.043  -0.362   6.057  1.00 16.09           O  
ATOM   1612  CB  ILE A 192      -3.526   2.184   3.859  1.00 16.34           C  
ATOM   1613  CG1 ILE A 192      -3.305   3.030   5.130  1.00 17.68           C  
ATOM   1614  CG2 ILE A 192      -4.539   2.940   2.944  1.00 17.33           C  
ATOM   1615  CD1 ILE A 192      -2.457   4.305   4.968  1.00 18.37           C  
ATOM   1616  N   ASN A 193      -1.976  -0.457   4.089  1.00 16.06           N  
ATOM   1617  CA  ASN A 193      -0.900  -1.237   4.672  1.00 16.47           C  
ATOM   1618  C   ASN A 193      -0.048  -0.390   5.619  1.00 17.13           C  
ATOM   1619  O   ASN A 193       0.383   0.696   5.223  1.00 18.93           O  
ATOM   1620  CB  ASN A 193       0.006  -1.826   3.587  1.00 16.04           C  
ATOM   1621  CG  ASN A 193      -0.696  -2.879   2.751  1.00 20.14           C  
ATOM   1622  OD1 ASN A 193      -1.566  -3.635   3.255  1.00 18.68           O  
ATOM   1623  ND2 ASN A 193      -0.273  -2.997   1.482  1.00 18.17           N  
ATOM   1624  N   PRO A 194       0.259  -0.923   6.816  1.00 18.30           N  
ATOM   1625  CA  PRO A 194       1.142  -0.199   7.731  1.00 22.93           C  
ATOM   1626  C   PRO A 194       2.445   0.287   7.094  1.00 31.79           C  
ATOM   1627  O   PRO A 194       3.058  -0.439   6.316  1.00 32.36           O  
ATOM   1628  CB  PRO A 194       1.418  -1.198   8.826  1.00 24.68           C  
ATOM   1629  CG  PRO A 194       0.412  -2.262   8.708  1.00 28.18           C  
ATOM   1630  CD  PRO A 194      -0.251  -2.181   7.381  1.00 20.20           C  
ATOM   1631  OXT PRO A 194       2.887   1.448   7.305  1.00 34.86           O  
TER    1632      PRO A 194                                                      
END
MOLECULE T0402.pdb
ATOM    891  N   GLU     4     -17.272   4.676  13.528  1.00 42.38           N  
ATOM    892  CA  GLU     4     -16.568   4.393  14.819  1.00 41.19           C  
ATOM    893  C   GLU     4     -15.129   4.921  14.732  1.00 39.47           C  
ATOM    894  O   GLU     4     -14.418   5.029  15.752  1.00 37.31           O  
ATOM    895  CB  GLU     4     -16.579   2.885  15.144  1.00 41.11           C  
ATOM    896  CG  GLU     4     -15.897   2.013  14.106  1.00 39.34           C  
ATOM    897  N   LEU     5     -14.709   5.212  13.498  1.00 37.46           N  
ATOM    898  CA  LEU     5     -13.373   5.756  13.253  1.00 36.64           C  
ATOM    899  C   LEU     5     -13.270   7.119  13.922  1.00 34.39           C  
ATOM    900  O   LEU     5     -12.259   7.374  14.576  1.00 31.86           O  
ATOM    901  CB  LEU     5     -13.041   5.842  11.755  1.00 35.60           C  
ATOM    902  CG  LEU     5     -11.673   6.420  11.371  1.00 36.47           C  
ATOM    903  CD1 LEU     5     -10.569   5.783  12.155  1.00 37.02           C  
ATOM    904  CD2 LEU     5     -11.414   6.277   9.874  1.00 39.29           C  
ATOM    905  N   GLU     6     -14.305   7.972  13.775  1.00 34.67           N  
ATOM    906  CA  GLU     6     -14.280   9.313  14.409  1.00 35.57           C  
ATOM    907  C   GLU     6     -14.207   9.044  15.877  1.00 34.45           C  
ATOM    908  O   GLU     6     -13.529   9.753  16.596  1.00 36.01           O  
ATOM    909  CB  GLU     6     -15.568  10.169  14.314  1.00 37.20           C  
ATOM    910  CG  GLU     6     -16.228  10.447  13.005  1.00 44.92           C  
ATOM    911  CD  GLU     6     -15.278  10.933  12.002  1.00 51.63           C  
ATOM    912  OE1 GLU     6     -14.242  10.254  11.920  1.00 53.06           O  
ATOM    913  OE2 GLU     6     -15.580  11.931  11.294  1.00 55.13           O  
ATOM    914  N   ASP     7     -15.017   8.079  16.321  1.00 33.33           N  
ATOM    915  CA  ASP     7     -15.104   7.792  17.745  1.00 32.02           C  
ATOM    916  C   ASP     7     -13.745   7.451  18.271  1.00 28.94           C  
ATOM    917  O   ASP     7     -13.370   7.930  19.313  1.00 29.46           O  
ATOM    918  CB  ASP     7     -16.148   6.720  18.074  1.00 35.52           C  
ATOM    919  CG  ASP     7     -17.577   7.284  18.071  1.00 34.61           C  
ATOM    920  OD1 ASP     7     -17.718   8.522  17.995  1.00 47.65           O  
ATOM    921  OD2 ASP     7     -18.537   6.494  18.159  1.00 44.63           O  
ATOM    922  N   LYS     8     -12.953   6.719  17.499  1.00 28.43           N  
ATOM    923  CA  LYS     8     -11.595   6.371  17.956  1.00 28.59           C  
ATOM    924  C   LYS     8     -10.671   7.595  17.906  1.00 26.95           C  
ATOM    925  O   LYS     8      -9.827   7.799  18.761  1.00 27.30           O  
ATOM    926  CB  LYS     8     -11.017   5.169  17.162  1.00 29.46           C  
ATOM    927  N   ILE     9     -10.860   8.428  16.897  1.00 29.92           N  
ATOM    928  CA  ILE     9     -10.058   9.646  16.759  1.00 24.61           C  
ATOM    929  C   ILE     9     -10.353  10.515  17.961  1.00 25.27           C  
ATOM    930  O   ILE     9      -9.442  10.992  18.630  1.00 26.29           O  
ATOM    931  CB  ILE     9     -10.347  10.365  15.425  1.00 25.78           C  
ATOM    932  CG1 ILE     9      -9.843   9.544  14.266  1.00 23.30           C  
ATOM    933  CG2 ILE     9      -9.667  11.769  15.331  1.00 23.82           C  
ATOM    934  CD1 ILE     9     -10.406   9.932  12.926  1.00 25.41           C  
ATOM    935  N   LEU    10     -11.639  10.687  18.283  1.00 25.00           N  
ATOM    936  CA  LEU    10     -12.032  11.569  19.391  1.00 24.56           C  
ATOM    937  C   LEU    10     -11.529  11.095  20.721  1.00 23.92           C  
ATOM    938  O   LEU    10     -11.132  11.896  21.587  1.00 26.43           O  
ATOM    939  CB  LEU    10     -13.554  11.749  19.433  1.00 28.23           C  
ATOM    940  CG  LEU    10     -14.079  12.624  18.318  1.00 33.38           C  
ATOM    941  CD1 LEU    10     -15.593  12.512  18.157  1.00 34.45           C  
ATOM    942  CD2 LEU    10     -13.658  14.053  18.655  1.00 30.00           C  
ATOM    943  N   ALA    11     -11.521   9.776  20.889  1.00 27.09           N  
ATOM    944  CA  ALA    11     -11.074   9.165  22.143  1.00 27.06           C  
ATOM    945  C   ALA    11      -9.604   9.533  22.363  1.00 29.21           C  
ATOM    946  O   ALA    11      -9.195   9.934  23.460  1.00 31.11           O  
ATOM    947  CB  ALA    11     -11.282   7.610  22.115  1.00 29.17           C  
ATOM    948  N   ILE    12      -8.820   9.481  21.288  1.00 25.92           N  
ATOM    949  CA  ILE    12      -7.401   9.770  21.407  1.00 25.02           C  
ATOM    950  C   ILE    12      -7.223  11.290  21.738  1.00 27.97           C  
ATOM    951  O   ILE    12      -6.411  11.669  22.601  1.00 30.55           O  
ATOM    952  CB  ILE    12      -6.642   9.389  20.142  1.00 24.32           C  
ATOM    953  CG1 ILE    12      -6.626   7.866  19.899  1.00 28.56           C  
ATOM    954  CG2 ILE    12      -5.214   9.899  20.248  1.00 24.77           C  
ATOM    955  CD1 ILE    12      -6.018   7.449  18.563  1.00 27.21           C  
ATOM    956  N   LEU    13      -8.028  12.132  21.084  1.00 24.76           N  
ATOM    957  CA  LEU    13      -7.991  13.585  21.342  1.00 26.43           C  
ATOM    958  C   LEU    13      -8.484  13.900  22.755  1.00 27.50           C  
ATOM    959  O   LEU    13      -8.014  14.833  23.371  1.00 29.87           O  
ATOM    960  CB  LEU    13      -8.853  14.385  20.332  1.00 23.89           C  
ATOM    961  CG  LEU    13      -8.371  14.385  18.875  1.00 19.63           C  
ATOM    962  CD1 LEU    13      -9.317  15.119  17.935  1.00 22.84           C  
ATOM    963  CD2 LEU    13      -6.905  14.962  18.813  1.00 19.00           C  
ATOM    964  N   GLU    14      -9.430  13.123  23.270  1.00 25.13           N  
ATOM    965  CA  GLU    14      -9.968  13.437  24.582  1.00 30.44           C  
ATOM    966  C   GLU    14      -8.977  13.129  25.674  1.00 31.51           C  
ATOM    967  O   GLU    14      -8.949  13.800  26.711  1.00 35.14           O  
ATOM    968  CB  GLU    14     -11.298  12.700  24.820  1.00 31.33           C  
ATOM    969  CG  GLU    14     -12.354  13.066  23.791  1.00 34.80           C  
ATOM    970  CD  GLU    14     -13.585  12.222  23.868  1.00 40.92           C  
ATOM    971  OE1 GLU    14     -13.509  11.127  24.465  1.00 47.22           O  
ATOM    972  OE2 GLU    14     -14.621  12.634  23.291  1.00 47.24           O  
ATOM    973  N   GLN    15      -8.111  12.165  25.395  1.00 30.42           N  
ATOM    974  CA  GLN    15      -7.152  11.690  26.363  1.00 30.22           C  
ATOM    975  C   GLN    15      -5.791  12.293  26.251  1.00 31.37           C  
ATOM    976  O   GLN    15      -4.941  12.006  27.061  1.00 29.45           O  
ATOM    977  CB  GLN    15      -7.084  10.182  26.251  1.00 32.12           C  
ATOM    978  CG  GLN    15      -8.453   9.576  26.520  1.00 40.22           C  
ATOM    979  CD  GLN    15      -8.669   8.270  25.798  1.00 49.99           C  
ATOM    980  OE1 GLN    15      -7.713   7.647  25.335  1.00 59.08           O  
ATOM    981  NE2 GLN    15      -9.935   7.861  25.663  1.00 53.52           N  
ATOM    982  N   HIS    16      -5.573  13.155  25.256  1.00 30.45           N  
ATOM    983  CA  HIS    16      -4.253  13.783  25.084  1.00 31.78           C  
ATOM    984  C   HIS    16      -4.358  15.267  24.743  1.00 32.34           C  
ATOM    985  O   HIS    16      -5.080  15.665  23.852  1.00 35.60           O  
ATOM    986  CB  HIS    16      -3.438  13.094  23.977  1.00 30.41           C  
ATOM    987  CG  HIS    16      -3.245  11.640  24.206  1.00 28.32           C  
ATOM    988  ND1 HIS    16      -4.194  10.700  23.867  1.00 29.60           N  
ATOM    989  CD2 HIS    16      -2.236  10.964  24.790  1.00 25.56           C  
ATOM    990  CE1 HIS    16      -3.764   9.504  24.220  1.00 22.95           C  
ATOM    991  NE2 HIS    16      -2.582   9.637  24.787  1.00 25.21           N  
ATOM    992  N   GLN    17      -3.587  16.059  25.457  1.00 29.66           N  
ATOM    993  CA  GLN    17      -3.560  17.475  25.246  1.00 31.81           C  
ATOM    994  C   GLN    17      -2.163  17.938  24.808  1.00 33.52           C  
ATOM    995  O   GLN    17      -1.966  19.118  24.576  1.00 38.12           O  
ATOM    996  CB  GLN    17      -3.950  18.219  26.500  1.00 31.34           C  
ATOM    997  CG  GLN    17      -5.454  18.319  26.714  1.00 45.87           C  
ATOM    998  CD  GLN    17      -5.808  19.275  27.862  1.00 52.08           C  
ATOM    999  OE1 GLN    17      -4.943  19.675  28.645  1.00 54.96           O  
ATOM   1000  NE2 GLN    17      -7.085  19.632  27.964  1.00 47.07           N  
ATOM   1001  N   VAL    18      -1.187  17.036  24.784  1.00 31.15           N  
ATOM   1002  CA  VAL    18       0.139  17.405  24.279  1.00 29.14           C  
ATOM   1003  C   VAL    18       0.388  16.655  22.972  1.00 28.20           C  
ATOM   1004  O   VAL    18       0.133  15.457  22.858  1.00 28.91           O  
ATOM   1005  CB  VAL    18       1.280  17.118  25.286  1.00 30.69           C  
ATOM   1006  CG1 VAL    18       2.643  17.446  24.687  1.00 24.44           C  
ATOM   1007  CG2 VAL    18       1.092  17.868  26.582  1.00 31.96           C  
ATOM   1008  N   GLY    19       0.886  17.368  21.984  1.00 24.76           N  
ATOM   1009  CA  GLY    19       1.212  16.763  20.719  1.00 24.21           C  
ATOM   1010  C   GLY    19       2.391  17.474  20.138  1.00 24.11           C  
ATOM   1011  O   GLY    19       2.929  18.421  20.740  1.00 21.18           O  
ATOM   1012  N   VAL    20       2.785  17.018  18.961  1.00 22.91           N  
ATOM   1013  CA  VAL    20       3.893  17.612  18.213  1.00 25.08           C  
ATOM   1014  C   VAL    20       3.316  18.383  17.013  1.00 25.01           C  
ATOM   1015  O   VAL    20       2.585  17.824  16.208  1.00 23.67           O  
ATOM   1016  CB  VAL    20       4.898  16.486  17.708  1.00 28.01           C  
ATOM   1017  CG1 VAL    20       6.032  17.064  16.888  1.00 22.46           C  
ATOM   1018  CG2 VAL    20       5.472  15.657  18.879  1.00 22.38           C  
ATOM   1019  N   LEU    21       3.592  19.678  16.923  1.00 21.88           N  
ATOM   1020  CA  LEU    21       3.210  20.429  15.755  1.00 22.34           C  
ATOM   1021  C   LEU    21       4.419  20.533  14.843  1.00 23.69           C  
ATOM   1022  O   LEU    21       5.484  20.928  15.299  1.00 22.74           O  
ATOM   1023  CB  LEU    21       2.844  21.879  16.097  1.00 24.83           C  
ATOM   1024  CG  LEU    21       2.461  22.649  14.818  1.00 26.96           C  
ATOM   1025  CD1 LEU    21       1.037  22.263  14.304  1.00 20.26           C  
ATOM   1026  CD2 LEU    21       2.556  24.085  15.092  1.00 27.07           C  
ATOM   1027  N   THR    22       4.265  20.185  13.570  1.00 22.98           N  
ATOM   1028  CA  THR    22       5.339  20.387  12.611  1.00 21.66           C  
ATOM   1029  C   THR    22       4.841  21.406  11.621  1.00 20.32           C  
ATOM   1030  O   THR    22       3.785  21.246  11.027  1.00 20.75           O  
ATOM   1031  CB  THR    22       5.750  19.076  11.908  1.00 24.87           C  
ATOM   1032  OG1 THR    22       6.149  18.115  12.904  1.00 24.69           O  
ATOM   1033  CG2 THR    22       6.901  19.331  10.889  1.00 24.48           C  
ATOM   1034  N   SER    23       5.575  22.513  11.549  1.00 21.81           N  
ATOM   1035  CA  SER    23       5.320  23.637  10.643  1.00 22.75           C  
ATOM   1036  C   SER    23       6.566  23.797   9.753  1.00 23.27           C  
ATOM   1037  O   SER    23       7.585  23.085   9.925  1.00 21.19           O  
ATOM   1038  CB  SER    23       4.951  24.895  11.396  1.00 24.06           C  
ATOM   1039  OG  SER    23       5.857  25.136  12.474  1.00 31.42           O  
ATOM   1040  N   VAL    24       6.459  24.702   8.789  1.00 21.84           N  
ATOM   1041  CA  VAL    24       7.466  24.869   7.783  1.00 22.28           C  
ATOM   1042  C   VAL    24       7.885  26.316   7.716  1.00 24.89           C  
ATOM   1043  O   VAL    24       7.049  27.227   7.763  1.00 28.74           O  
ATOM   1044  CB  VAL    24       6.890  24.474   6.379  1.00 24.26           C  
ATOM   1045  CG1 VAL    24       7.872  24.796   5.229  1.00 21.44           C  
ATOM   1046  CG2 VAL    24       6.415  23.036   6.366  1.00 27.38           C  
ATOM   1047  N   GLN    25       9.185  26.504   7.658  1.00 24.78           N  
ATOM   1048  CA  GLN    25       9.804  27.826   7.471  1.00 26.17           C  
ATOM   1049  C   GLN    25      10.672  27.763   6.222  1.00 23.98           C  
ATOM   1050  O   GLN    25      11.868  27.458   6.277  1.00 24.12           O  
ATOM   1051  CB  GLN    25      10.676  28.168   8.679  1.00 28.26           C  
ATOM   1052  CG  GLN    25      11.407  29.462   8.537  1.00 32.78           C  
ATOM   1053  CD  GLN    25      12.921  29.305   8.789  1.00 46.32           C  
ATOM   1054  OE1 GLN    25      13.393  28.353   9.448  1.00 31.55           O  
ATOM   1055  NE2 GLN    25      13.686  30.243   8.248  1.00 37.86           N  
ATOM   1056  N   GLY    26      10.075  28.064   5.079  1.00 25.59           N  
ATOM   1057  CA  GLY    26      10.796  28.004   3.821  1.00 23.90           C  
ATOM   1058  C   GLY    26      10.994  26.543   3.532  1.00 23.83           C  
ATOM   1059  O   GLY    26      10.037  25.826   3.368  1.00 29.46           O  
ATOM   1060  N   ASP    27      12.237  26.085   3.513  1.00 22.49           N  
ATOM   1061  CA  ASP    27      12.539  24.669   3.273  1.00 22.69           C  
ATOM   1062  C   ASP    27      12.805  23.898   4.568  1.00 21.00           C  
ATOM   1063  O   ASP    27      13.177  22.727   4.517  1.00 24.02           O  
ATOM   1064  CB  ASP    27      13.781  24.512   2.394  1.00 24.13           C  
ATOM   1065  CG  ASP    27      13.602  25.149   1.027  1.00 30.59           C  
ATOM   1066  OD1 ASP    27      12.553  24.885   0.428  1.00 31.77           O  
ATOM   1067  OD2 ASP    27      14.481  25.941   0.607  1.00 33.51           O  
ATOM   1068  N   PHE    28      12.600  24.525   5.707  1.00 21.28           N  
ATOM   1069  CA  PHE    28      12.906  23.855   6.983  1.00 22.11           C  
ATOM   1070  C   PHE    28      11.702  23.418   7.803  1.00 22.96           C  
ATOM   1071  O   PHE    28      10.787  24.216   8.046  1.00 23.25           O  
ATOM   1072  CB  PHE    28      13.754  24.751   7.846  1.00 23.03           C  
ATOM   1073  CG  PHE    28      15.086  25.078   7.262  1.00 25.86           C  
ATOM   1074  CD1 PHE    28      15.219  26.114   6.350  1.00 34.83           C  
ATOM   1075  CD2 PHE    28      16.209  24.349   7.629  1.00 30.51           C  
ATOM   1076  CE1 PHE    28      16.476  26.420   5.792  1.00 39.60           C  
ATOM   1077  CE2 PHE    28      17.463  24.648   7.085  1.00 34.80           C  
ATOM   1078  CZ  PHE    28      17.589  25.682   6.163  1.00 29.20           C  
ATOM   1079  N   PRO    29      11.722  22.150   8.281  1.00 20.87           N  
ATOM   1080  CA  PRO    29      10.654  21.756   9.179  1.00 20.13           C  
ATOM   1081  C   PRO    29      10.976  22.270  10.602  1.00 21.65           C  
ATOM   1082  O   PRO    29      12.148  22.428  10.977  1.00 22.71           O  
ATOM   1083  CB  PRO    29      10.703  20.218   9.105  1.00 16.93           C  
ATOM   1084  CG  PRO    29      12.087  19.904   8.813  1.00 20.39           C  
ATOM   1085  CD  PRO    29      12.558  20.996   7.887  1.00 21.93           C  
ATOM   1086  N   HIS    30       9.961  22.603  11.346  1.00 19.86           N  
ATOM   1087  CA  HIS    30      10.142  22.931  12.750  1.00 22.55           C  
ATOM   1088  C   HIS    30       9.177  22.051  13.519  1.00 23.86           C  
ATOM   1089  O   HIS    30       7.988  22.074  13.260  1.00 24.48           O  
ATOM   1090  CB  HIS    30       9.832  24.397  13.043  1.00 24.99           C  
ATOM   1091  CG  HIS    30      10.830  25.351  12.464  1.00 27.13           C  
ATOM   1092  ND1 HIS    30      11.991  25.684  13.116  1.00 42.31           N  
ATOM   1093  CD2 HIS    30      10.853  26.020  11.291  1.00 31.98           C  
ATOM   1094  CE1 HIS    30      12.685  26.527  12.372  1.00 43.97           C  
ATOM   1095  NE2 HIS    30      12.020  26.743  11.257  1.00 28.39           N  
ATOM   1096  N   ALA    31       9.683  21.241  14.440  1.00 21.62           N  
ATOM   1097  CA  ALA    31       8.786  20.420  15.239  1.00 21.19           C  
ATOM   1098  C   ALA    31       8.839  20.930  16.666  1.00 21.06           C  
ATOM   1099  O   ALA    31       9.911  21.187  17.197  1.00 22.76           O  
ATOM   1100  CB  ALA    31       9.184  18.935  15.190  1.00 17.98           C  
ATOM   1101  N   ARG    32       7.673  21.039  17.283  1.00 20.86           N  
ATOM   1102  CA  ARG    32       7.581  21.478  18.655  1.00 21.12           C  
ATOM   1103  C   ARG    32       6.466  20.776  19.402  1.00 22.95           C  
ATOM   1104  O   ARG    32       5.437  20.471  18.843  1.00 23.49           O  
ATOM   1105  CB  ARG    32       7.306  22.983  18.737  1.00 23.47           C  
ATOM   1106  CG  ARG    32       8.254  23.852  17.944  1.00 21.69           C  
ATOM   1107  CD  ARG    32       7.801  25.288  17.980  1.00 19.58           C  
ATOM   1108  NE  ARG    32       8.721  26.221  17.303  1.00 23.67           N  
ATOM   1109  CZ  ARG    32       8.622  26.605  16.033  1.00 28.15           C  
ATOM   1110  NH1 ARG    32       7.690  26.096  15.274  1.00 29.28           N  
ATOM   1111  NH2 ARG    32       9.488  27.463  15.518  1.00 25.35           N  
ATOM   1112  N   TYR    33       6.708  20.544  20.682  1.00 22.45           N  
ATOM   1113  CA  TYR    33       5.709  19.972  21.562  1.00 23.41           C  
ATOM   1114  C   TYR    33       4.845  21.101  22.066  1.00 24.86           C  
ATOM   1115  O   TYR    33       5.324  22.195  22.365  1.00 26.66           O  
ATOM   1116  CB  TYR    33       6.294  19.265  22.764  1.00 24.67           C  
ATOM   1117  CG  TYR    33       6.775  17.885  22.478  1.00 18.01           C  
ATOM   1118  CD1 TYR    33       5.897  16.844  22.358  1.00 24.93           C  
ATOM   1119  CD2 TYR    33       8.121  17.628  22.269  1.00 29.92           C  
ATOM   1120  CE1 TYR    33       6.339  15.580  22.088  1.00 23.33           C  
ATOM   1121  CE2 TYR    33       8.564  16.343  21.966  1.00 26.70           C  
ATOM   1122  CZ  TYR    33       7.689  15.350  21.891  1.00 21.77           C  
ATOM   1123  OH  TYR    33       8.099  14.072  21.576  1.00 21.78           O  
ATOM   1124  N   MET    34       3.550  20.874  22.097  1.00 21.95           N  
ATOM   1125  CA  MET    34       2.677  21.872  22.668  1.00 24.11           C  
ATOM   1126  C   MET    34       1.288  21.323  23.023  1.00 23.90           C  
ATOM   1127  O   MET    34       0.948  20.168  22.750  1.00 25.87           O  
ATOM   1128  CB  MET    34       2.552  23.094  21.756  1.00 23.16           C  
ATOM   1129  CG  MET    34       1.890  22.735  20.406  1.00 18.26           C  
ATOM   1130  SD  MET    34       1.980  24.104  19.065  0.75 21.15          SE  
ATOM   1131  CE  MET    34       3.937  23.951  18.781  1.00 25.84           C  
ATOM   1132  N   THR    35       0.525  22.189  23.673  1.00 25.59           N  
ATOM   1133  CA  THR    35      -0.821  21.872  24.155  1.00 26.45           C  
ATOM   1134  C   THR    35      -1.811  22.152  23.054  1.00 26.17           C  
ATOM   1135  O   THR    35      -1.737  23.199  22.356  1.00 25.36           O  
ATOM   1136  CB  THR    35      -1.160  22.672  25.429  1.00 30.86           C  
ATOM   1137  OG1 THR    35      -0.173  22.356  26.389  1.00 34.72           O  
ATOM   1138  CG2 THR    35      -2.567  22.327  26.032  1.00 27.33           C  
ATOM   1139  N   PHE    36      -2.667  21.146  22.879  1.00 24.61           N  
ATOM   1140  CA  PHE    36      -3.783  21.159  21.969  1.00 25.96           C  
ATOM   1141  C   PHE    36      -5.107  20.968  22.689  1.00 27.48           C  
ATOM   1142  O   PHE    36      -5.284  19.984  23.402  1.00 28.94           O  
ATOM   1143  CB  PHE    36      -3.651  20.045  20.937  1.00 23.70           C  
ATOM   1144  CG  PHE    36      -2.489  20.239  19.986  1.00 23.74           C  
ATOM   1145  CD1 PHE    36      -2.632  21.007  18.820  1.00 34.82           C  
ATOM   1146  CD2 PHE    36      -1.248  19.754  20.291  1.00 22.32           C  
ATOM   1147  CE1 PHE    36      -1.569  21.202  17.959  1.00 21.88           C  
ATOM   1148  CE2 PHE    36      -0.168  19.980  19.438  1.00 29.50           C  
ATOM   1149  CZ  PHE    36      -0.334  20.705  18.280  1.00 23.07           C  
ATOM   1150  N   LEU    37      -6.034  21.899  22.457  1.00 26.29           N  
ATOM   1151  CA  LEU    37      -7.442  21.729  22.836  1.00 22.58           C  
ATOM   1152  C   LEU    37      -8.156  21.293  21.549  1.00 23.58           C  
ATOM   1153  O   LEU    37      -7.637  21.463  20.425  1.00 24.31           O  
ATOM   1154  CB  LEU    37      -8.045  23.063  23.352  1.00 24.30           C  
ATOM   1155  CG  LEU    37      -7.245  23.618  24.548  1.00 28.99           C  
ATOM   1156  CD1 LEU    37      -7.872  24.797  25.259  1.00 27.85           C  
ATOM   1157  CD2 LEU    37      -7.115  22.530  25.554  1.00 36.86           C  
ATOM   1158  N   HIS    38      -9.339  20.709  21.658  1.00 24.95           N  
ATOM   1159  CA  HIS    38     -10.100  20.399  20.459  1.00 23.71           C  
ATOM   1160  C   HIS    38     -11.578  20.629  20.709  1.00 24.00           C  
ATOM   1161  O   HIS    38     -12.065  20.669  21.820  1.00 24.63           O  
ATOM   1162  CB  HIS    38      -9.889  18.943  20.045  1.00 25.67           C  
ATOM   1163  CG  HIS    38     -10.516  17.992  20.996  1.00 25.92           C  
ATOM   1164  ND1 HIS    38     -11.709  17.354  20.727  1.00 25.93           N  
ATOM   1165  CD2 HIS    38     -10.209  17.703  22.283  1.00 24.95           C  
ATOM   1166  CE1 HIS    38     -12.066  16.652  21.785  1.00 19.50           C  
ATOM   1167  NE2 HIS    38     -11.174  16.850  22.741  1.00 25.82           N  
ATOM   1168  N   ASP    39     -12.244  20.838  19.614  1.00 25.95           N  
ATOM   1169  CA  ASP    39     -13.651  21.013  19.521  1.00 25.74           C  
ATOM   1170  C   ASP    39     -14.006  20.108  18.373  1.00 26.80           C  
ATOM   1171  O   ASP    39     -13.857  20.450  17.179  1.00 26.30           O  
ATOM   1172  CB  ASP    39     -14.024  22.444  19.162  1.00 28.09           C  
ATOM   1173  CG  ASP    39     -15.538  22.586  18.914  1.00 35.59           C  
ATOM   1174  OD1 ASP    39     -16.277  21.857  19.572  1.00 33.68           O  
ATOM   1175  OD2 ASP    39     -15.973  23.377  18.063  1.00 41.29           O  
ATOM   1176  N   GLY    40     -14.462  18.922  18.699  1.00 27.82           N  
ATOM   1177  CA  GLY    40     -14.707  17.978  17.626  1.00 26.02           C  
ATOM   1178  C   GLY    40     -13.332  17.656  17.087  1.00 24.93           C  
ATOM   1179  O   GLY    40     -12.367  17.531  17.856  1.00 26.42           O  
ATOM   1180  N   LEU    41     -13.228  17.562  15.770  1.00 26.12           N  
ATOM   1181  CA  LEU    41     -11.943  17.249  15.136  1.00 27.21           C  
ATOM   1182  C   LEU    41     -11.118  18.512  14.833  1.00 27.41           C  
ATOM   1183  O   LEU    41      -9.995  18.428  14.292  1.00 27.79           O  
ATOM   1184  CB  LEU    41     -12.119  16.397  13.884  1.00 27.92           C  
ATOM   1185  CG  LEU    41     -12.854  15.056  14.020  1.00 32.57           C  
ATOM   1186  CD1 LEU    41     -12.713  14.341  12.703  1.00 32.75           C  
ATOM   1187  CD2 LEU    41     -12.344  14.206  15.165  1.00 27.90           C  
ATOM   1188  N   THR    42     -11.642  19.670  15.221  1.00 25.69           N  
ATOM   1189  CA  THR    42     -10.858  20.931  15.103  1.00 26.21           C  
ATOM   1190  C   THR    42      -9.897  21.110  16.299  1.00 26.36           C  
ATOM   1191  O   THR    42     -10.278  20.980  17.457  1.00 23.32           O  
ATOM   1192  CB  THR    42     -11.750  22.165  14.903  1.00 27.45           C  
ATOM   1193  OG1 THR    42     -12.414  22.058  13.636  1.00 30.71           O  
ATOM   1194  CG2 THR    42     -10.934  23.468  14.887  1.00 23.38           C  
ATOM   1195  N   LEU    43      -8.637  21.391  15.997  1.00 25.60           N  
ATOM   1196  CA  LEU    43      -7.637  21.600  17.028  1.00 23.92           C  
ATOM   1197  C   LEU    43      -7.300  23.088  17.192  1.00 24.50           C  
ATOM   1198  O   LEU    43      -7.443  23.909  16.257  1.00 23.65           O  
ATOM   1199  CB  LEU    43      -6.365  20.838  16.719  1.00 25.35           C  
ATOM   1200  CG  LEU    43      -6.368  19.308  16.630  1.00 27.97           C  
ATOM   1201  CD1 LEU    43      -4.941  18.829  16.496  1.00 30.50           C  
ATOM   1202  CD2 LEU    43      -6.977  18.611  17.785  1.00 33.23           C  
ATOM   1203  N   TYR    44      -6.934  23.433  18.416  1.00 22.63           N  
ATOM   1204  CA  TYR    44      -6.574  24.808  18.781  1.00 22.01           C  
ATOM   1205  C   TYR    44      -5.328  24.710  19.636  1.00 23.89           C  
ATOM   1206  O   TYR    44      -5.169  23.812  20.464  1.00 24.22           O  
ATOM   1207  CB  TYR    44      -7.687  25.526  19.565  1.00 24.73           C  
ATOM   1208  CG  TYR    44      -8.986  25.737  18.807  1.00 25.85           C  
ATOM   1209  CD1 TYR    44      -9.126  26.776  17.889  1.00 25.94           C  
ATOM   1210  CD2 TYR    44     -10.081  24.960  19.064  1.00 24.88           C  
ATOM   1211  CE1 TYR    44     -10.321  26.984  17.200  1.00 25.39           C  
ATOM   1212  CE2 TYR    44     -11.281  25.159  18.395  1.00 27.64           C  
ATOM   1213  CZ  TYR    44     -11.391  26.166  17.461  1.00 31.16           C  
ATOM   1214  OH  TYR    44     -12.548  26.332  16.774  1.00 33.25           O  
ATOM   1215  N   THR    45      -4.361  25.558  19.345  1.00 25.20           N  
ATOM   1216  CA  THR    45      -3.194  25.598  20.178  1.00 22.70           C  
ATOM   1217  C   THR    45      -2.822  27.101  20.418  1.00 25.43           C  
ATOM   1218  O   THR    45      -2.835  27.931  19.464  1.00 24.36           O  
ATOM   1219  CB  THR    45      -2.035  24.745  19.559  1.00 25.94           C  
ATOM   1220  OG1 THR    45      -0.976  24.643  20.495  1.00 26.71           O  
ATOM   1221  CG2 THR    45      -1.516  25.362  18.277  1.00 21.15           C  
ATOM   1222  N   PRO    46      -2.461  27.438  21.675  1.00 24.87           N  
ATOM   1223  CA  PRO    46      -2.083  28.799  22.061  1.00 26.94           C  
ATOM   1224  C   PRO    46      -0.775  29.250  21.502  1.00 27.27           C  
ATOM   1225  O   PRO    46       0.128  28.456  21.243  1.00 24.64           O  
ATOM   1226  CB  PRO    46      -2.052  28.760  23.605  1.00 27.69           C  
ATOM   1227  CG  PRO    46      -1.982  27.336  23.958  1.00 29.16           C  
ATOM   1228  CD  PRO    46      -2.376  26.491  22.796  1.00 26.04           C  
ATOM   1229  N   SER    47      -0.676  30.552  21.273  1.00 26.18           N  
ATOM   1230  CA  SER    47       0.591  31.101  20.790  1.00 26.44           C  
ATOM   1231  C   SER    47       0.672  32.592  21.108  1.00 26.07           C  
ATOM   1232  O   SER    47      -0.242  33.145  21.709  1.00 24.99           O  
ATOM   1233  CB  SER    47       0.738  30.807  19.309  1.00 28.27           C  
ATOM   1234  OG  SER    47       2.027  31.146  18.849  1.00 28.45           O  
ATOM   1235  N   GLY    48       1.784  33.227  20.761  1.00 26.43           N  
ATOM   1236  CA  GLY    48       1.962  34.661  20.935  1.00 25.49           C  
ATOM   1237  C   GLY    48       2.080  35.273  19.554  1.00 26.23           C  
ATOM   1238  O   GLY    48       2.554  34.624  18.624  1.00 24.88           O  
ATOM   1239  N   LYS    49       1.653  36.523  19.419  1.00 25.40           N  
ATOM   1240  CA  LYS    49       1.669  37.221  18.122  1.00 25.22           C  
ATOM   1241  C   LYS    49       3.022  37.259  17.461  1.00 26.54           C  
ATOM   1242  O   LYS    49       3.136  37.280  16.218  1.00 24.69           O  
ATOM   1243  CB  LYS    49       1.261  38.694  18.248  1.00 26.01           C  
ATOM   1244  CG  LYS    49      -0.194  38.964  18.407  1.00 35.93           C  
ATOM   1245  CD  LYS    49      -0.443  40.448  18.576  1.00 31.61           C  
ATOM   1246  CE  LYS    49      -1.828  40.643  19.141  1.00 34.42           C  
ATOM   1247  NZ  LYS    49      -2.097  42.069  19.406  1.00 29.95           N  
ATOM   1248  N   GLU    50       4.044  37.365  18.295  1.00 25.56           N  
ATOM   1249  CA  GLU    50       5.423  37.467  17.823  1.00 27.69           C  
ATOM   1250  C   GLU    50       6.224  36.186  17.832  1.00 27.68           C  
ATOM   1251  O   GLU    50       7.396  36.221  17.515  1.00 30.11           O  
ATOM   1252  CB  GLU    50       6.206  38.526  18.617  1.00 31.57           C  
ATOM   1253  CG  GLU    50       5.977  39.969  18.152  1.00 34.74           C  
ATOM   1254  CD  GLU    50       4.504  40.442  18.202  1.00 40.91           C  
ATOM   1255  OE1 GLU    50       3.918  40.488  19.303  1.00 34.03           O  
ATOM   1256  OE2 GLU    50       3.970  40.816  17.133  1.00 38.96           O  
ATOM   1257  N   LEU    51       5.624  35.065  18.206  1.00 24.38           N  
ATOM   1258  CA  LEU    51       6.381  33.815  18.241  1.00 24.29           C  
ATOM   1259  C   LEU    51       6.632  33.296  16.847  1.00 22.99           C  
ATOM   1260  O   LEU    51       5.835  33.524  15.985  1.00 23.76           O  
ATOM   1261  CB  LEU    51       5.653  32.773  19.042  1.00 23.68           C  
ATOM   1262  CG  LEU    51       5.603  33.114  20.548  1.00 29.25           C  
ATOM   1263  CD1 LEU    51       5.133  31.931  21.370  1.00 28.43           C  
ATOM   1264  CD2 LEU    51       6.967  33.558  20.995  1.00 30.25           C  
ATOM   1265  N   PRO    52       7.765  32.635  16.627  1.00 26.51           N  
ATOM   1266  CA  PRO    52       8.087  32.039  15.344  1.00 28.12           C  
ATOM   1267  C   PRO    52       6.981  31.096  14.817  1.00 26.60           C  
ATOM   1268  O   PRO    52       6.684  31.160  13.645  1.00 26.82           O  
ATOM   1269  CB  PRO    52       9.380  31.267  15.623  1.00 29.45           C  
ATOM   1270  CG  PRO    52      10.041  32.043  16.726  1.00 31.64           C  
ATOM   1271  CD  PRO    52       8.938  32.680  17.530  1.00 29.04           C  
ATOM   1272  N   LYS    53       6.369  30.267  15.651  1.00 26.62           N  
ATOM   1273  CA  LYS    53       5.366  29.332  15.131  1.00 25.94           C  
ATOM   1274  C   LYS    53       4.159  30.063  14.575  1.00 24.77           C  
ATOM   1275  O   LYS    53       3.563  29.635  13.608  1.00 22.68           O  
ATOM   1276  CB  LYS    53       4.940  28.277  16.141  1.00 30.60           C  
ATOM   1277  CG  LYS    53       4.206  28.801  17.354  1.00 31.49           C  
ATOM   1278  CD  LYS    53       3.825  27.659  18.280  1.00 34.33           C  
ATOM   1279  CE  LYS    53       3.118  28.193  19.502  1.00 38.11           C  
ATOM   1280  NZ  LYS    53       3.200  27.292  20.687  1.00 36.28           N  
ATOM   1281  N   THR    54       3.840  31.223  15.143  1.00 23.00           N  
ATOM   1282  CA  THR    54       2.766  32.034  14.633  1.00 22.98           C  
ATOM   1283  C   THR    54       3.084  32.599  13.258  1.00 22.46           C  
ATOM   1284  O   THR    54       2.229  32.601  12.378  1.00 23.60           O  
ATOM   1285  CB  THR    54       2.482  33.233  15.557  1.00 22.98           C  
ATOM   1286  OG1 THR    54       2.117  32.729  16.844  1.00 26.67           O  
ATOM   1287  CG2 THR    54       1.381  34.128  14.957  1.00 23.40           C  
ATOM   1288  N   GLU    55       4.297  33.117  13.080  1.00 22.50           N  
ATOM   1289  CA  GLU    55       4.715  33.635  11.779  1.00 24.13           C  
ATOM   1290  C   GLU    55       4.850  32.528  10.741  1.00 22.32           C  
ATOM   1291  O   GLU    55       4.596  32.735   9.542  1.00 22.91           O  
ATOM   1292  CB  GLU    55       6.011  34.464  11.877  1.00 21.81           C  
ATOM   1293  CG  GLU    55       6.418  35.134  10.550  1.00 33.77           C  
ATOM   1294  CD  GLU    55       5.396  36.146  10.043  1.00 34.42           C  
ATOM   1295  OE1 GLU    55       4.571  36.618  10.845  1.00 35.03           O  
ATOM   1296  OE2 GLU    55       5.434  36.465   8.838  1.00 40.57           O  
ATOM   1297  N   GLU    56       5.274  31.348  11.180  1.00 20.37           N  
ATOM   1298  CA  GLU    56       5.386  30.236  10.262  1.00 20.68           C  
ATOM   1299  C   GLU    56       4.025  29.921   9.630  1.00 25.11           C  
ATOM   1300  O   GLU    56       3.897  29.785   8.402  1.00 24.63           O  
ATOM   1301  CB  GLU    56       5.968  29.013  10.965  1.00 21.89           C  
ATOM   1302  CG  GLU    56       7.447  29.156  11.199  1.00 19.68           C  
ATOM   1303  CD  GLU    56       7.953  28.258  12.308  1.00 22.26           C  
ATOM   1304  OE1 GLU    56       7.260  27.304  12.613  1.00 22.14           O  
ATOM   1305  OE2 GLU    56       9.021  28.526  12.905  1.00 20.23           O  
ATOM   1306  N   VAL    57       3.017  29.800  10.497  1.00 23.86           N  
ATOM   1307  CA  VAL    57       1.615  29.525  10.102  1.00 24.91           C  
ATOM   1308  C   VAL    57       1.011  30.607   9.176  1.00 26.11           C  
ATOM   1309  O   VAL    57       0.280  30.282   8.240  1.00 25.99           O  
ATOM   1310  CB  VAL    57       0.751  29.308  11.384  1.00 24.87           C  
ATOM   1311  CG1 VAL    57      -0.696  29.476  11.111  1.00 25.59           C  
ATOM   1312  CG2 VAL    57       1.072  27.896  11.952  1.00 31.46           C  
ATOM   1313  N   ARG    58       1.321  31.885   9.446  1.00 24.58           N  
ATOM   1314  CA  ARG    58       0.847  32.967   8.645  1.00 24.69           C  
ATOM   1315  C   ARG    58       1.342  32.817   7.244  1.00 24.06           C  
ATOM   1316  O   ARG    58       0.627  33.111   6.333  1.00 26.23           O  
ATOM   1317  CB  ARG    58       1.343  34.342   9.130  1.00 25.86           C  
ATOM   1318  CG  ARG    58       0.753  34.779  10.472  1.00 34.18           C  
ATOM   1319  CD  ARG    58       0.919  36.296  10.728  1.00 33.97           C  
ATOM   1320  NE  ARG    58       0.531  36.633  12.105  1.00 33.53           N  
ATOM   1321  CZ  ARG    58       1.397  36.802  13.111  1.00 46.70           C  
ATOM   1322  NH1 ARG    58       2.712  36.714  12.897  1.00 46.58           N  
ATOM   1323  NH2 ARG    58       0.960  37.099  14.330  1.00 47.99           N  
ATOM   1324  N   ARG    59       2.580  32.353   7.086  1.00 20.98           N  
ATOM   1325  CA  ARG    59       3.226  32.273   5.785  1.00 21.14           C  
ATOM   1326  C   ARG    59       3.054  30.921   5.083  1.00 22.65           C  
ATOM   1327  O   ARG    59       3.206  30.825   3.861  1.00 25.19           O  
ATOM   1328  CB  ARG    59       4.718  32.597   5.919  1.00 24.78           C  
ATOM   1329  CG  ARG    59       4.958  34.017   6.372  1.00 32.59           C  
ATOM   1330  CD  ARG    59       6.280  34.236   7.067  1.00 49.16           C  
ATOM   1331  NE  ARG    59       7.328  34.743   6.198  1.00 64.75           N  
ATOM   1332  CZ  ARG    59       8.292  35.556   6.621  1.00 69.91           C  
ATOM   1333  NH1 ARG    59       8.294  35.984   7.880  1.00 73.25           N  
ATOM   1334  NH2 ARG    59       9.221  35.981   5.781  1.00 76.88           N  
ATOM   1335  N   ASN    60       2.806  29.879   5.858  1.00 21.58           N  
ATOM   1336  CA  ASN    60       2.549  28.535   5.278  1.00 23.00           C  
ATOM   1337  C   ASN    60       1.564  27.813   6.208  1.00 22.00           C  
ATOM   1338  O   ASN    60       1.943  27.443   7.311  1.00 23.03           O  
ATOM   1339  CB  ASN    60       3.854  27.751   5.103  1.00 25.44           C  
ATOM   1340  CG  ASN    60       3.659  26.376   4.458  1.00 23.96           C  
ATOM   1341  OD1 ASN    60       2.574  25.828   4.479  1.00 24.04           O  
ATOM   1342  ND2 ASN    60       4.718  25.830   3.884  1.00 20.04           N  
ATOM   1343  N   PRO    61       0.288  27.655   5.777  1.00 19.63           N  
ATOM   1344  CA  PRO    61      -0.748  27.060   6.618  1.00 22.26           C  
ATOM   1345  C   PRO    61      -0.676  25.528   6.797  1.00 23.66           C  
ATOM   1346  O   PRO    61      -1.383  24.953   7.619  1.00 21.03           O  
ATOM   1347  CB  PRO    61      -2.037  27.444   5.889  1.00 22.62           C  
ATOM   1348  CG  PRO    61      -1.624  27.401   4.427  1.00 22.15           C  
ATOM   1349  CD  PRO    61      -0.241  28.056   4.454  1.00 23.16           C  
ATOM   1350  N   HIS    62       0.216  24.889   6.062  1.00 19.44           N  
ATOM   1351  CA  HIS    62       0.300  23.436   6.075  1.00 18.08           C  
ATOM   1352  C   HIS    62       1.075  22.959   7.306  1.00 21.54           C  
ATOM   1353  O   HIS    62       2.283  23.242   7.473  1.00 21.88           O  
ATOM   1354  CB  HIS    62       0.967  22.916   4.845  1.00 19.49           C  
ATOM   1355  CG  HIS    62       0.406  23.470   3.581  1.00 21.80           C  
ATOM   1356  ND1 HIS    62       1.031  24.474   2.869  1.00 26.45           N  
ATOM   1357  CD2 HIS    62      -0.754  23.222   2.938  1.00 25.89           C  
ATOM   1358  CE1 HIS    62       0.303  24.783   1.811  1.00 26.72           C  
ATOM   1359  NE2 HIS    62      -0.787  24.046   1.834  1.00 27.18           N  
ATOM   1360  N   VAL    63       0.354  22.226   8.135  1.00 22.49           N  
ATOM   1361  CA  VAL    63       0.906  21.672   9.372  1.00 24.28           C  
ATOM   1362  C   VAL    63       0.599  20.203   9.478  1.00 23.23           C  
ATOM   1363  O   VAL    63      -0.341  19.704   8.864  1.00 25.47           O  
ATOM   1364  CB  VAL    63       0.430  22.427  10.618  1.00 24.21           C  
ATOM   1365  CG1 VAL    63       0.884  23.921  10.555  1.00 19.99           C  
ATOM   1366  CG2 VAL    63      -1.103  22.346  10.789  1.00 25.94           C  
ATOM   1367  N   CYS    64       1.459  19.511  10.206  1.00 21.97           N  
ATOM   1368  CA  CYS    64       1.253  18.134  10.512  1.00 22.35           C  
ATOM   1369  C   CYS    64       1.274  17.986  12.048  1.00 23.22           C  
ATOM   1370  O   CYS    64       2.241  18.414  12.686  1.00 22.53           O  
ATOM   1371  CB  CYS    64       2.374  17.290   9.890  1.00 23.04           C  
ATOM   1372  SG  CYS    64       2.156  15.484  10.259  1.00 29.36           S  
ATOM   1373  N   VAL    65       0.239  17.373  12.639  1.00 20.75           N  
ATOM   1374  CA  VAL    65       0.222  17.102  14.107  1.00 20.19           C  
ATOM   1375  C   VAL    65       0.265  15.598  14.419  1.00 20.91           C  
ATOM   1376  O   VAL    65      -0.418  14.808  13.787  1.00 23.06           O  
ATOM   1377  CB  VAL    65      -1.028  17.705  14.784  1.00 21.89           C  
ATOM   1378  CG1 VAL    65      -1.017  17.461  16.324  1.00 21.39           C  
ATOM   1379  CG2 VAL    65      -1.095  19.192  14.486  1.00 17.51           C  
ATOM   1380  N   LEU    66       1.128  15.241  15.350  1.00 21.00           N  
ATOM   1381  CA  LEU    66       1.207  13.906  15.886  1.00 22.83           C  
ATOM   1382  C   LEU    66       0.757  14.046  17.330  1.00 24.37           C  
ATOM   1383  O   LEU    66       1.253  14.899  18.086  1.00 22.34           O  
ATOM   1384  CB  LEU    66       2.616  13.317  15.864  1.00 23.54           C  
ATOM   1385  CG  LEU    66       3.253  13.028  14.493  1.00 22.50           C  
ATOM   1386  CD1 LEU    66       4.619  12.383  14.706  1.00 21.40           C  
ATOM   1387  CD2 LEU    66       2.365  12.090  13.805  1.00 24.83           C  
ATOM   1388  N   ILE    67      -0.204  13.207  17.677  1.00 24.16           N  
ATOM   1389  CA  ILE    67      -0.792  13.227  18.998  1.00 23.41           C  
ATOM   1390  C   ILE    67      -1.282  11.877  19.400  1.00 22.23           C  
ATOM   1391  O   ILE    67      -1.861  11.139  18.618  1.00 22.20           O  
ATOM   1392  CB  ILE    67      -1.921  14.345  19.144  1.00 27.64           C  
ATOM   1393  CG1 ILE    67      -2.524  14.393  20.584  1.00 27.72           C  
ATOM   1394  CG2 ILE    67      -3.065  14.147  18.145  1.00 23.71           C  
ATOM   1395  CD1 ILE    67      -3.050  15.759  20.941  1.00 30.36           C  
ATOM   1396  N   GLY    68      -0.964  11.511  20.647  1.00 23.63           N  
ATOM   1397  CA  GLY    68      -1.483  10.287  21.237  1.00 19.56           C  
ATOM   1398  C   GLY    68      -0.487   9.177  21.520  1.00 20.94           C  
ATOM   1399  O   GLY    68      -0.838   8.188  22.125  1.00 24.34           O  
ATOM   1400  N   TYR    69       0.774   9.400  21.175  1.00 23.18           N  
ATOM   1401  CA  TYR    69       1.815   8.409  21.363  1.00 25.41           C  
ATOM   1402  C   TYR    69       2.320   8.402  22.833  1.00 27.83           C  
ATOM   1403  O   TYR    69       3.092   9.253  23.249  1.00 31.88           O  
ATOM   1404  CB  TYR    69       2.925   8.617  20.327  1.00 21.24           C  
ATOM   1405  CG  TYR    69       4.025   7.605  20.393  1.00 24.82           C  
ATOM   1406  CD1 TYR    69       4.062   6.538  19.521  1.00 33.89           C  
ATOM   1407  CD2 TYR    69       4.992   7.673  21.406  1.00 37.24           C  
ATOM   1408  CE1 TYR    69       5.034   5.568  19.615  1.00 33.53           C  
ATOM   1409  CE2 TYR    69       5.980   6.706  21.515  1.00 40.44           C  
ATOM   1410  CZ  TYR    69       5.990   5.657  20.603  1.00 37.40           C  
ATOM   1411  OH  TYR    69       6.971   4.713  20.683  1.00 39.63           O  
ATOM   1412  N   ASP    70       1.854   7.424  23.600  1.00 27.00           N  
ATOM   1413  CA  ASP    70       2.182   7.269  25.029  1.00 29.39           C  
ATOM   1414  C   ASP    70       3.343   6.293  25.247  1.00 32.01           C  
ATOM   1415  O   ASP    70       4.220   6.510  26.084  1.00 30.28           O  
ATOM   1416  CB  ASP    70       0.970   6.717  25.779  1.00 31.09           C  
ATOM   1417  CG  ASP    70      -0.187   7.662  25.768  1.00 29.31           C  
ATOM   1418  OD1 ASP    70       0.083   8.852  25.824  1.00 34.31           O  
ATOM   1419  OD2 ASP    70      -1.347   7.220  25.687  1.00 41.91           O  
ATOM   1420  N   SER    71       3.312   5.230  24.451  1.00 32.18           N  
ATOM   1421  CA  SER    71       4.289   4.158  24.456  1.00 34.11           C  
ATOM   1422  C   SER    71       4.369   3.491  23.077  1.00 33.71           C  
ATOM   1423  O   SER    71       3.578   3.788  22.171  1.00 28.55           O  
ATOM   1424  CB  SER    71       3.901   3.096  25.475  1.00 35.35           C  
ATOM   1425  OG  SER    71       2.619   2.591  25.154  1.00 40.59           O  
ATOM   1426  N   PRO    72       5.341   2.589  22.909  1.00 33.67           N  
ATOM   1427  CA  PRO    72       5.466   1.972  21.585  1.00 35.80           C  
ATOM   1428  C   PRO    72       4.197   1.263  21.069  1.00 33.94           C  
ATOM   1429  O   PRO    72       4.069   1.103  19.876  1.00 32.67           O  
ATOM   1430  CB  PRO    72       6.640   0.992  21.758  1.00 35.26           C  
ATOM   1431  CG  PRO    72       7.411   1.530  22.898  1.00 36.46           C  
ATOM   1432  CD  PRO    72       6.400   2.141  23.828  1.00 34.30           C  
ATOM   1433  N   GLY    73       3.278   0.877  21.958  1.00 33.86           N  
ATOM   1434  CA  GLY    73       2.038   0.193  21.562  1.00 34.31           C  
ATOM   1435  C   GLY    73       0.785   1.063  21.418  1.00 34.45           C  
ATOM   1436  O   GLY    73      -0.265   0.574  21.057  1.00 32.11           O  
ATOM   1437  N   SER    74       0.907   2.349  21.733  1.00 32.57           N  
ATOM   1438  CA  SER    74      -0.194   3.311  21.624  1.00 31.98           C  
ATOM   1439  C   SER    74      -0.667   3.494  20.185  1.00 29.05           C  
ATOM   1440  O   SER    74       0.158   3.613  19.299  1.00 26.36           O  
ATOM   1441  CB  SER    74       0.290   4.708  22.041  1.00 32.27           C  
ATOM   1442  OG  SER    74       0.662   4.823  23.389  1.00 33.26           O  
ATOM   1443  N   ALA    75      -1.989   3.482  19.968  1.00 27.09           N  
ATOM   1444  CA  ALA    75      -2.547   3.897  18.676  1.00 24.35           C  
ATOM   1445  C   ALA    75      -2.503   5.426  18.810  1.00 26.03           C  
ATOM   1446  O   ALA    75      -2.787   5.990  19.881  1.00 25.85           O  
ATOM   1447  CB  ALA    75      -3.962   3.453  18.501  1.00 20.83           C  
ATOM   1448  N   PHE    76      -2.119   6.101  17.743  1.00 23.70           N  
ATOM   1449  CA  PHE    76      -2.009   7.547  17.775  1.00 21.58           C  
ATOM   1450  C   PHE    76      -2.453   8.126  16.461  1.00 22.33           C  
ATOM   1451  O   PHE    76      -2.805   7.397  15.541  1.00 22.48           O  
ATOM   1452  CB  PHE    76      -0.605   8.013  18.165  1.00 22.85           C  
ATOM   1453  CG  PHE    76       0.452   7.599  17.222  1.00 24.24           C  
ATOM   1454  CD1 PHE    76       1.010   6.332  17.313  1.00 22.01           C  
ATOM   1455  CD2 PHE    76       0.880   8.464  16.212  1.00 25.18           C  
ATOM   1456  CE1 PHE    76       1.977   5.930  16.408  1.00 31.42           C  
ATOM   1457  CE2 PHE    76       1.832   8.059  15.312  1.00 27.57           C  
ATOM   1458  CZ  PHE    76       2.393   6.794  15.419  1.00 27.59           C  
ATOM   1459  N   LEU    77      -2.452   9.448  16.398  1.00 24.31           N  
ATOM   1460  CA  LEU    77      -2.928  10.147  15.245  1.00 25.21           C  
ATOM   1461  C   LEU    77      -1.869  10.935  14.528  1.00 25.16           C  
ATOM   1462  O   LEU    77      -1.011  11.581  15.142  1.00 25.35           O  
ATOM   1463  CB  LEU    77      -4.039  11.154  15.657  1.00 23.45           C  
ATOM   1464  CG  LEU    77      -5.301  10.609  16.331  1.00 24.02           C  
ATOM   1465  CD1 LEU    77      -6.185  11.821  16.871  1.00 17.16           C  
ATOM   1466  CD2 LEU    77      -6.008   9.686  15.358  1.00 21.47           C  
ATOM   1467  N   GLU    78      -1.970  10.856  13.203  1.00 26.24           N  
ATOM   1468  CA  GLU    78      -1.228  11.736  12.320  1.00 25.21           C  
ATOM   1469  C   GLU    78      -2.282  12.603  11.616  1.00 23.10           C  
ATOM   1470  O   GLU    78      -3.155  12.109  10.906  1.00 24.75           O  
ATOM   1471  CB  GLU    78      -0.369  10.957  11.324  1.00 25.77           C  
ATOM   1472  CG  GLU    78       0.164  11.887  10.315  1.00 26.30           C  
ATOM   1473  CD  GLU    78       0.948  11.238   9.178  1.00 37.12           C  
ATOM   1474  OE1 GLU    78       1.284  10.043   9.212  1.00 29.49           O  
ATOM   1475  OE2 GLU    78       1.230  11.973   8.224  1.00 44.31           O  
ATOM   1476  N   ILE    79      -2.227  13.902  11.861  1.00 24.16           N  
ATOM   1477  CA  ILE    79      -3.181  14.865  11.334  1.00 22.67           C  
ATOM   1478  C   ILE    79      -2.497  15.905  10.408  1.00 25.34           C  
ATOM   1479  O   ILE    79      -1.618  16.641  10.834  1.00 25.31           O  
ATOM   1480  CB  ILE    79      -3.814  15.646  12.500  1.00 26.46           C  
ATOM   1481  CG1 ILE    79      -4.534  14.700  13.456  1.00 25.76           C  
ATOM   1482  CG2 ILE    79      -4.761  16.741  11.988  1.00 23.69           C  
ATOM   1483  CD1 ILE    79      -5.059  15.317  14.723  1.00 26.35           C  
ATOM   1484  N   ASN    80      -2.909  15.971   9.144  1.00 22.02           N  
ATOM   1485  CA  ASN    80      -2.364  16.967   8.199  1.00 21.97           C  
ATOM   1486  C   ASN    80      -3.489  17.910   8.003  1.00 23.64           C  
ATOM   1487  O   ASN    80      -4.624  17.496   7.736  1.00 22.91           O  
ATOM   1488  CB  ASN    80      -1.924  16.321   6.896  1.00 25.78           C  
ATOM   1489  CG  ASN    80      -0.768  15.321   7.109  1.00 24.67           C  
ATOM   1490  OD1 ASN    80      -0.979  14.113   7.097  1.00 42.52           O  
ATOM   1491  ND2 ASN    80       0.409  15.824   7.385  1.00 28.75           N  
ATOM   1492  N   GLY    81      -3.191  19.185   8.240  1.00 23.95           N  
ATOM   1493  CA  GLY    81      -4.218  20.202   8.228  1.00 23.64           C  
ATOM   1494  C   GLY    81      -3.752  21.580   7.849  1.00 20.09           C  
ATOM   1495  O   GLY    81      -2.612  21.794   7.519  1.00 21.52           O  
ATOM   1496  N   LEU    82      -4.704  22.479   7.870  1.00 23.69           N  
ATOM   1497  CA  LEU    82      -4.500  23.837   7.529  1.00 24.40           C  
ATOM   1498  C   LEU    82      -4.692  24.684   8.764  1.00 23.40           C  
ATOM   1499  O   LEU    82      -5.772  24.669   9.399  1.00 24.27           O  
ATOM   1500  CB  LEU    82      -5.481  24.226   6.407  1.00 24.89           C  
ATOM   1501  CG  LEU    82      -5.183  23.658   5.021  1.00 23.88           C  
ATOM   1502  CD1 LEU    82      -6.313  24.043   3.998  1.00 27.80           C  
ATOM   1503  CD2 LEU    82      -3.813  24.196   4.550  1.00 23.17           C  
ATOM   1504  N   ALA    83      -3.631  25.430   9.081  1.00 23.61           N  
ATOM   1505  CA  ALA    83      -3.572  26.262  10.267  1.00 24.02           C  
ATOM   1506  C   ALA    83      -3.760  27.717   9.900  1.00 22.11           C  
ATOM   1507  O   ALA    83      -3.321  28.180   8.836  1.00 22.50           O  
ATOM   1508  CB  ALA    83      -2.234  26.000  11.097  1.00 20.76           C  
ATOM   1509  N   SER    84      -4.459  28.391  10.811  1.00 24.74           N  
ATOM   1510  CA  SER    84      -4.812  29.809  10.729  1.00 24.69           C  
ATOM   1511  C   SER    84      -4.955  30.390  12.105  1.00 26.64           C  
ATOM   1512  O   SER    84      -5.035  29.680  13.109  1.00 23.99           O  
ATOM   1513  CB  SER    84      -6.087  30.011   9.888  1.00 24.39           C  
ATOM   1514  OG  SER    84      -7.217  29.490  10.540  1.00 26.80           O  
ATOM   1515  N   LEU    85      -4.918  31.708  12.172  1.00 25.96           N  
ATOM   1516  CA  LEU    85      -5.075  32.387  13.441  1.00 26.62           C  
ATOM   1517  C   LEU    85      -6.569  32.621  13.633  1.00 27.62           C  
ATOM   1518  O   LEU    85      -7.254  33.172  12.746  1.00 27.66           O  
ATOM   1519  CB  LEU    85      -4.256  33.687  13.473  1.00 30.04           C  
ATOM   1520  CG  LEU    85      -2.725  33.472  13.267  1.00 33.75           C  
ATOM   1521  CD1 LEU    85      -1.919  34.769  13.407  1.00 38.74           C  
ATOM   1522  CD2 LEU    85      -2.241  32.411  14.255  1.00 40.61           C  
ATOM   1523  N   GLU    86      -7.063  32.156  14.777  1.00 24.82           N  
ATOM   1524  CA  GLU    86      -8.472  32.274  15.156  1.00 24.15           C  
ATOM   1525  C   GLU    86      -8.813  33.721  15.315  1.00 21.95           C  
ATOM   1526  O   GLU    86      -8.141  34.434  16.035  1.00 25.74           O  
ATOM   1527  CB  GLU    86      -8.756  31.543  16.476  1.00 25.21           C  
ATOM   1528  CG  GLU    86     -10.209  31.635  16.921  1.00 27.45           C  
ATOM   1529  CD  GLU    86     -11.154  31.123  15.880  1.00 28.50           C  
ATOM   1530  OE1 GLU    86     -10.988  29.962  15.475  1.00 29.45           O  
ATOM   1531  OE2 GLU    86     -12.072  31.868  15.455  1.00 28.58           O  
ATOM   1532  N   GLU    87      -9.889  34.129  14.666  1.00 26.80           N  
ATOM   1533  CA  GLU    87     -10.319  35.541  14.658  1.00 28.88           C  
ATOM   1534  C   GLU    87     -11.535  35.799  15.502  1.00 28.11           C  
ATOM   1535  O   GLU    87     -11.872  36.940  15.774  1.00 25.77           O  
ATOM   1536  CB  GLU    87     -10.568  36.012  13.203  1.00 32.23           C  
ATOM   1537  CG  GLU    87      -9.275  36.095  12.334  1.00 38.23           C  
ATOM   1538  CD  GLU    87      -9.539  36.477  10.874  1.00 44.95           C  
ATOM   1539  OE1 GLU    87     -10.672  36.852  10.513  1.00 45.22           O  
ATOM   1540  OE2 GLU    87      -8.598  36.388  10.068  1.00 54.19           O  
ATOM   1541  N   ASP    88     -12.200  34.736  15.926  1.00 27.79           N  
ATOM   1542  CA  ASP    88     -13.409  34.877  16.766  1.00 27.66           C  
ATOM   1543  C   ASP    88     -12.946  35.104  18.198  1.00 24.62           C  
ATOM   1544  O   ASP    88     -12.305  34.262  18.811  1.00 22.62           O  
ATOM   1545  CB  ASP    88     -14.313  33.633  16.653  1.00 24.91           C  
ATOM   1546  CG  ASP    88     -15.606  33.733  17.458  1.00 24.99           C  
ATOM   1547  OD1 ASP    88     -15.621  34.014  18.689  1.00 25.75           O  
ATOM   1548  OD2 ASP    88     -16.637  33.406  16.875  1.00 26.56           O  
ATOM   1549  N   GLU    89     -13.260  36.292  18.670  1.00 24.47           N  
ATOM   1550  CA  GLU    89     -12.838  36.752  19.960  1.00 25.52           C  
ATOM   1551  C   GLU    89     -13.418  35.937  21.087  1.00 24.61           C  
ATOM   1552  O   GLU    89     -12.798  35.821  22.132  1.00 25.80           O  
ATOM   1553  CB  GLU    89     -13.190  38.217  20.139  1.00 26.20           C  
ATOM   1554  CG  GLU    89     -12.303  39.171  19.369  1.00 32.76           C  
ATOM   1555  CD  GLU    89     -10.903  39.266  19.935  1.00 45.69           C  
ATOM   1556  OE1 GLU    89     -10.691  38.911  21.134  1.00 48.75           O  
ATOM   1557  OE2 GLU    89     -10.024  39.743  19.181  1.00 50.86           O  
ATOM   1558  N   SER    90     -14.631  35.431  20.911  1.00 22.42           N  
ATOM   1559  CA  SER    90     -15.218  34.598  21.960  1.00 22.95           C  
ATOM   1560  C   SER    90     -14.452  33.258  22.052  1.00 24.76           C  
ATOM   1561  O   SER    90     -14.289  32.703  23.124  1.00 23.81           O  
ATOM   1562  CB  SER    90     -16.708  34.340  21.718  1.00 23.56           C  
ATOM   1563  OG  SER    90     -16.931  33.453  20.656  1.00 22.93           O  
ATOM   1564  N   ILE    91     -13.970  32.753  20.923  1.00 24.44           N  
ATOM   1565  CA  ILE    91     -13.220  31.478  20.922  1.00 25.61           C  
ATOM   1566  C   ILE    91     -11.841  31.727  21.536  1.00 26.70           C  
ATOM   1567  O   ILE    91     -11.346  30.941  22.345  1.00 25.04           O  
ATOM   1568  CB  ILE    91     -13.073  30.861  19.503  1.00 26.67           C  
ATOM   1569  CG1 ILE    91     -14.419  30.371  18.976  1.00 27.27           C  
ATOM   1570  CG2 ILE    91     -12.095  29.697  19.556  1.00 20.52           C  
ATOM   1571  CD1 ILE    91     -14.391  29.842  17.482  1.00 24.64           C  
ATOM   1572  N   LYS    92     -11.248  32.865  21.205  1.00 25.93           N  
ATOM   1573  CA  LYS    92      -9.946  33.192  21.769  1.00 28.64           C  
ATOM   1574  C   LYS    92      -9.999  33.309  23.288  1.00 27.15           C  
ATOM   1575  O   LYS    92      -9.083  32.861  23.959  1.00 24.46           O  
ATOM   1576  CB  LYS    92      -9.405  34.507  21.205  1.00 29.23           C  
ATOM   1577  CG  LYS    92      -9.036  34.421  19.709  1.00 35.47           C  
ATOM   1578  CD  LYS    92      -8.701  35.790  19.154  1.00 38.72           C  
ATOM   1579  CE  LYS    92      -7.547  36.408  19.888  1.00 42.97           C  
ATOM   1580  NZ  LYS    92      -7.442  37.843  19.536  1.00 46.31           N  
ATOM   1581  N   GLU    93     -11.045  33.961  23.788  1.00 24.10           N  
ATOM   1582  CA  GLU    93     -11.230  34.225  25.241  1.00 26.65           C  
ATOM   1583  C   GLU    93     -11.531  32.950  25.979  1.00 27.21           C  
ATOM   1584  O   GLU    93     -11.050  32.720  27.093  1.00 25.60           O  
ATOM   1585  CB  GLU    93     -12.369  35.215  25.486  1.00 25.01           C  
ATOM   1586  CG  GLU    93     -12.699  35.458  26.991  1.00 34.20           C  
ATOM   1587  CD  GLU    93     -11.556  36.095  27.747  1.00 35.65           C  
ATOM   1588  OE1 GLU    93     -10.778  36.797  27.093  1.00 46.70           O  
ATOM   1589  OE2 GLU    93     -11.423  35.895  28.984  1.00 35.98           O  
ATOM   1590  N   ARG    94     -12.316  32.097  25.343  1.00 27.12           N  
ATOM   1591  CA  ARG    94     -12.613  30.813  25.924  1.00 28.00           C  
ATOM   1592  C   ARG    94     -11.344  29.946  26.088  1.00 27.43           C  
ATOM   1593  O   ARG    94     -11.137  29.361  27.110  1.00 26.23           O  
ATOM   1594  CB  ARG    94     -13.656  30.092  25.082  1.00 29.52           C  
ATOM   1595  CG  ARG    94     -14.022  28.737  25.634  1.00 33.03           C  
ATOM   1596  CD  ARG    94     -14.433  28.837  27.081  1.00 36.10           C  
ATOM   1597  NE  ARG    94     -15.662  29.619  27.286  1.00 44.98           N  
ATOM   1598  CZ  ARG    94     -16.887  29.097  27.200  1.00 45.17           C  
ATOM   1599  NH1 ARG    94     -17.047  27.805  26.913  1.00 47.64           N  
ATOM   1600  NH2 ARG    94     -17.945  29.857  27.389  1.00 43.33           N  
ATOM   1601  N   ILE    95     -10.552  29.823  25.035  1.00 24.35           N  
ATOM   1602  CA  ILE    95      -9.319  29.105  25.060  1.00 24.04           C  
ATOM   1603  C   ILE    95      -8.389  29.742  26.129  1.00 24.16           C  
ATOM   1604  O   ILE    95      -7.738  29.034  26.896  1.00 24.92           O  
ATOM   1605  CB  ILE    95      -8.642  29.115  23.698  1.00 26.27           C  
ATOM   1606  CG1 ILE    95      -9.469  28.344  22.605  1.00 28.97           C  
ATOM   1607  CG2 ILE    95      -7.198  28.616  23.796  1.00 24.84           C  
ATOM   1608  CD1 ILE    95      -9.740  26.942  22.940  1.00 34.68           C  
ATOM   1609  N   TRP    96      -8.326  31.078  26.170  1.00 23.39           N  
ATOM   1610  CA  TRP    96      -7.495  31.785  27.144  1.00 21.32           C  
ATOM   1611  C   TRP    96      -7.867  31.360  28.565  1.00 24.82           C  
ATOM   1612  O   TRP    96      -7.014  31.040  29.399  1.00 22.90           O  
ATOM   1613  CB  TRP    96      -7.580  33.326  26.943  1.00 24.68           C  
ATOM   1614  CG  TRP    96      -6.959  34.140  28.049  1.00 26.84           C  
ATOM   1615  CD1 TRP    96      -7.623  34.949  28.944  1.00 30.90           C  
ATOM   1616  CD2 TRP    96      -5.560  34.192  28.439  1.00 28.62           C  
ATOM   1617  NE1 TRP    96      -6.729  35.515  29.824  1.00 35.51           N  
ATOM   1618  CE2 TRP    96      -5.465  35.057  29.548  1.00 25.02           C  
ATOM   1619  CE3 TRP    96      -4.392  33.618  27.949  1.00 27.30           C  
ATOM   1620  CZ2 TRP    96      -4.249  35.350  30.159  1.00 33.32           C  
ATOM   1621  CZ3 TRP    96      -3.187  33.904  28.592  1.00 31.13           C  
ATOM   1622  CH2 TRP    96      -3.131  34.743  29.668  1.00 30.56           C  
ATOM   1623  N   GLU    97      -9.161  31.333  28.834  1.00 26.97           N  
ATOM   1624  CA  GLU    97      -9.683  30.993  30.144  1.00 26.44           C  
ATOM   1625  C   GLU    97      -9.417  29.537  30.489  1.00 28.96           C  
ATOM   1626  O   GLU    97      -9.176  29.195  31.645  1.00 29.19           O  
ATOM   1627  CB  GLU    97     -11.196  31.323  30.213  1.00 29.88           C  
ATOM   1628  CG  GLU    97     -11.445  32.800  30.285  1.00 26.25           C  
ATOM   1629  CD  GLU    97     -12.896  33.194  30.164  1.00 33.38           C  
ATOM   1630  OE1 GLU    97     -13.775  32.312  30.248  1.00 45.27           O  
ATOM   1631  OE2 GLU    97     -13.139  34.387  29.937  1.00 31.96           O  
ATOM   1632  N   ASN    98      -9.446  28.669  29.491  0.50 29.09           N  
ATOM   1634  CA  ASN    98      -9.162  27.258  29.746  0.50 30.24           C  
ATOM   1636  C   ASN    98      -7.669  27.057  30.039  0.50 28.65           C  
ATOM   1638  O   ASN    98      -7.285  26.398  30.998  0.50 26.77           O  
ATOM   1640  CB  ASN    98      -9.605  26.390  28.584  0.50 29.92           C  
ATOM   1642  CG  ASN    98      -9.313  24.934  28.817  0.50 30.69           C  
ATOM   1644  OD1 ASN    98      -8.186  24.551  29.165  0.50 29.64           O  
ATOM   1646  ND2 ASN    98     -10.319  24.104  28.618  0.50 29.51           N  
ATOM   1648  N   ILE    99      -6.835  27.696  29.239  1.00 30.14           N  
ATOM   1649  CA  ILE    99      -5.385  27.606  29.431  1.00 30.55           C  
ATOM   1650  C   ILE    99      -4.894  28.183  30.779  1.00 31.12           C  
ATOM   1651  O   ILE    99      -4.009  27.611  31.412  1.00 33.81           O  
ATOM   1652  CB  ILE    99      -4.653  28.367  28.289  1.00 33.41           C  
ATOM   1653  CG1 ILE    99      -4.812  27.621  26.978  1.00 44.69           C  
ATOM   1654  CG2 ILE    99      -3.184  28.505  28.554  1.00 46.54           C  
ATOM   1655  CD1 ILE    99      -4.328  26.221  27.021  1.00 42.35           C  
ATOM   1656  N   SER   100      -5.451  29.326  31.193  1.00 27.06           N  
ATOM   1657  CA  SER   100      -4.987  30.084  32.374  1.00 25.77           C  
ATOM   1658  C   SER   100      -5.831  29.855  33.609  1.00 25.58           C  
ATOM   1659  O   SER   100      -5.760  30.622  34.594  1.00 23.46           O  
ATOM   1660  CB  SER   100      -5.019  31.595  32.054  1.00 20.90           C  
ATOM   1661  OG  SER   100      -6.356  32.059  31.869  1.00 23.13           O  
ATOM   1662  N   LYS   101      -6.631  28.795  33.577  1.00 27.27           N  
ATOM   1663  CA  LYS   101      -7.634  28.612  34.625  1.00 28.29           C  
ATOM   1664  C   LYS   101      -7.018  28.550  36.030  1.00 24.38           C  
ATOM   1665  O   LYS   101      -7.606  29.052  36.962  1.00 27.83           O  
ATOM   1666  CB  LYS   101      -8.543  27.414  34.370  1.00 30.29           C  
ATOM   1667  CG  LYS   101      -7.852  26.054  34.473  1.00 41.68           C  
ATOM   1668  CD  LYS   101      -8.890  24.917  34.512  1.00 46.81           C  
ATOM   1669  CE  LYS   101      -9.525  24.628  33.162  1.00 52.12           C  
ATOM   1670  NZ  LYS   101      -8.577  23.986  32.222  1.00 49.92           N  
ATOM   1671  N   ASP   102      -5.851  27.931  36.172  1.00 26.17           N  
ATOM   1672  CA  ASP   102      -5.208  27.819  37.486  1.00 24.93           C  
ATOM   1673  C   ASP   102      -4.880  29.191  38.122  1.00 24.36           C  
ATOM   1674  O   ASP   102      -4.769  29.287  39.354  1.00 29.92           O  
ATOM   1675  CB  ASP   102      -3.934  26.979  37.433  1.00 26.36           C  
ATOM   1676  CG  ASP   102      -4.203  25.480  37.373  1.00 32.59           C  
ATOM   1677  OD1 ASP   102      -5.388  25.048  37.427  1.00 33.69           O  
ATOM   1678  OD2 ASP   102      -3.191  24.743  37.318  1.00 36.93           O  
ATOM   1679  N   TRP   103      -4.765  30.242  37.301  1.00 24.60           N  
ATOM   1680  CA  TRP   103      -4.408  31.601  37.785  1.00 25.17           C  
ATOM   1681  C   TRP   103      -5.244  32.747  37.219  1.00 30.11           C  
ATOM   1682  O   TRP   103      -5.149  33.901  37.673  1.00 32.70           O  
ATOM   1683  CB  TRP   103      -2.919  31.898  37.502  1.00 28.09           C  
ATOM   1684  CG  TRP   103      -2.571  32.126  36.025  1.00 34.30           C  
ATOM   1685  CD1 TRP   103      -2.581  33.339  35.324  1.00 31.98           C  
ATOM   1686  CD2 TRP   103      -2.187  31.139  35.086  1.00 29.27           C  
ATOM   1687  NE1 TRP   103      -2.232  33.121  34.021  1.00 35.26           N  
ATOM   1688  CE2 TRP   103      -1.966  31.786  33.859  1.00 30.28           C  
ATOM   1689  CE3 TRP   103      -2.001  29.769  35.163  1.00 18.77           C  
ATOM   1690  CZ2 TRP   103      -1.606  31.115  32.754  1.00 37.18           C  
ATOM   1691  CZ3 TRP   103      -1.634  29.113  34.060  1.00 34.12           C  
ATOM   1692  CH2 TRP   103      -1.435  29.773  32.870  1.00 37.95           C  
ATOM   1693  N   PHE   104      -6.117  32.439  36.276  1.00 34.00           N  
ATOM   1694  CA  PHE   104      -6.934  33.459  35.617  1.00 35.95           C  
ATOM   1695  C   PHE   104      -7.833  34.206  36.572  1.00 35.24           C  
ATOM   1696  O   PHE   104      -8.594  33.594  37.319  1.00 34.16           O  
ATOM   1697  CB  PHE   104      -7.760  32.840  34.464  1.00 39.24           C  
ATOM   1698  CG  PHE   104      -8.773  33.787  33.844  1.00 38.94           C  
ATOM   1699  CD1 PHE   104      -8.411  34.636  32.817  1.00 36.50           C  
ATOM   1700  CD2 PHE   104     -10.091  33.796  34.272  1.00 40.95           C  
ATOM   1701  CE1 PHE   104      -9.340  35.505  32.243  1.00 40.74           C  
ATOM   1702  CE2 PHE   104     -11.026  34.660  33.703  1.00 41.12           C  
ATOM   1703  CZ  PHE   104     -10.641  35.510  32.685  1.00 42.71           C  
ATOM   1704  N   GLN   105      -7.717  35.531  36.573  1.00 34.79           N  
ATOM   1705  CA  GLN   105      -8.607  36.363  37.377  1.00 36.45           C  
ATOM   1706  C   GLN   105      -9.143  37.570  36.594  1.00 40.48           C  
ATOM   1707  O   GLN   105      -9.411  38.645  37.147  1.00 36.61           O  
ATOM   1708  CB  GLN   105      -8.006  36.755  38.757  1.00 36.06           C  
ATOM   1709  CG  GLN   105      -6.693  37.524  38.730  1.00 38.74           C  
ATOM   1710  CD  GLN   105      -6.259  38.008  40.108  1.00 27.15           C  
ATOM   1711  OE1 GLN   105      -5.901  37.207  40.992  1.00 23.55           O  
ATOM   1712  NE2 GLN   105      -6.251  39.339  40.291  1.00 33.92           N  
ATOM   1713  N   GLY   106      -9.331  37.367  35.291  1.00 43.39           N  
ATOM   1714  CA  GLY   106      -9.904  38.411  34.438  1.00 44.55           C  
ATOM   1715  C   GLY   106      -8.948  39.241  33.599  1.00 46.11           C  
ATOM   1716  O   GLY   106      -9.380  40.052  32.794  1.00 48.44           O  
ATOM   1717  N   GLU   107      -7.658  39.073  33.772  1.00 46.72           N  
ATOM   1718  CA  GLU   107      -6.717  39.761  32.944  1.00 48.03           C  
ATOM   1719  C   GLU   107      -6.746  39.219  31.524  1.00 49.31           C  
ATOM   1720  O   GLU   107      -7.100  38.105  31.283  1.00 50.37           O  
ATOM   1721  CB  GLU   107      -5.328  39.660  33.540  1.00 47.53           C  
ATOM   1722  N   ASP   108      -6.396  40.027  30.570  1.00 49.32           N  
ATOM   1723  CA  ASP   108      -6.167  39.478  29.265  1.00 50.51           C  
ATOM   1724  C   ASP   108      -4.826  39.877  28.771  1.00 47.60           C  
ATOM   1725  O   ASP   108      -4.200  40.720  29.313  1.00 48.55           O  
ATOM   1726  CB  ASP   108      -7.237  39.890  28.266  1.00 51.81           C  
ATOM   1727  CG  ASP   108      -7.812  38.721  27.513  1.00 59.75           C  
ATOM   1728  OD1 ASP   108      -7.216  38.269  26.500  1.00 69.25           O  
ATOM   1729  OD2 ASP   108      -8.866  38.247  27.943  1.00 60.83           O  
ATOM   1730  N   SER   109      -4.409  39.248  27.712  1.00 42.70           N  
ATOM   1731  CA  SER   109      -3.057  39.292  27.328  1.00 39.53           C  
ATOM   1732  C   SER   109      -3.109  39.706  25.889  1.00 37.93           C  
ATOM   1733  O   SER   109      -3.668  39.013  25.099  1.00 36.08           O  
ATOM   1734  CB  SER   109      -2.482  37.908  27.485  1.00 35.74           C  
ATOM   1735  OG  SER   109      -1.260  37.836  26.853  1.00 50.86           O  
ATOM   1736  N   PRO   110      -2.574  40.862  25.560  1.00 36.20           N  
ATOM   1737  CA  PRO   110      -2.735  41.388  24.200  1.00 34.17           C  
ATOM   1738  C   PRO   110      -1.943  40.604  23.149  1.00 28.51           C  
ATOM   1739  O   PRO   110      -2.276  40.602  21.977  1.00 30.62           O  
ATOM   1740  CB  PRO   110      -2.205  42.817  24.327  1.00 34.50           C  
ATOM   1741  CG  PRO   110      -1.144  42.732  25.361  1.00 38.99           C  
ATOM   1742  CD  PRO   110      -1.625  41.662  26.357  1.00 39.07           C  
ATOM   1743  N   SER   111      -0.931  39.896  23.588  1.00 26.60           N  
ATOM   1744  CA  SER   111      -0.087  39.204  22.652  1.00 27.88           C  
ATOM   1745  C   SER   111      -0.596  37.777  22.434  1.00 25.75           C  
ATOM   1746  O   SER   111      -0.098  37.091  21.603  1.00 24.21           O  
ATOM   1747  CB  SER   111       1.350  39.192  23.138  1.00 31.27           C  
ATOM   1748  OG  SER   111       1.500  38.284  24.205  1.00 36.14           O  
ATOM   1749  N   PHE   112      -1.644  37.389  23.154  1.00 28.87           N  
ATOM   1750  CA  PHE   112      -2.218  36.046  23.067  1.00 29.00           C  
ATOM   1751  C   PHE   112      -2.961  35.817  21.734  1.00 27.15           C  
ATOM   1752  O   PHE   112      -3.736  36.632  21.248  1.00 25.88           O  
ATOM   1753  CB  PHE   112      -3.128  35.738  24.247  1.00 30.08           C  
ATOM   1754  CG  PHE   112      -3.621  34.301  24.280  1.00 28.08           C  
ATOM   1755  CD1 PHE   112      -2.787  33.296  24.662  1.00 27.96           C  
ATOM   1756  CD2 PHE   112      -4.919  33.988  23.964  1.00 28.83           C  
ATOM   1757  CE1 PHE   112      -3.233  31.980  24.714  1.00 32.87           C  
ATOM   1758  CE2 PHE   112      -5.384  32.714  24.033  1.00 26.31           C  
ATOM   1759  CZ  PHE   112      -4.549  31.693  24.416  1.00 28.17           C  
ATOM   1760  N   VAL   113      -2.684  34.672  21.142  0.50 24.30           N  
ATOM   1762  CA  VAL   113      -3.327  34.302  19.901  0.50 23.77           C  
ATOM   1764  C   VAL   113      -3.588  32.822  19.960  0.50 24.04           C  
ATOM   1766  O   VAL   113      -3.043  32.104  20.808  0.50 21.68           O  
ATOM   1768  CB  VAL   113      -2.475  34.643  18.671  0.50 22.73           C  
ATOM   1770  CG1 VAL   113      -2.213  36.135  18.620  0.50 24.82           C  
ATOM   1772  CG2 VAL   113      -1.179  33.824  18.669  0.50 22.09           C  
ATOM   1774  N   VAL   114      -4.469  32.391  19.070  1.00 23.44           N  
ATOM   1775  CA  VAL   114      -4.847  31.005  18.988  1.00 22.58           C  
ATOM   1776  C   VAL   114      -4.680  30.527  17.543  1.00 22.66           C  
ATOM   1777  O   VAL   114      -5.131  31.199  16.604  1.00 20.35           O  
ATOM   1778  CB  VAL   114      -6.294  30.776  19.501  1.00 23.21           C  
ATOM   1779  CG1 VAL   114      -6.808  29.290  19.211  1.00 21.96           C  
ATOM   1780  CG2 VAL   114      -6.424  31.169  21.022  1.00 21.87           C  
ATOM   1781  N   ILE   115      -3.940  29.431  17.411  1.00 23.01           N  
ATOM   1782  CA  ILE   115      -3.781  28.710  16.168  1.00 26.40           C  
ATOM   1783  C   ILE   115      -4.855  27.650  16.069  1.00 25.68           C  
ATOM   1784  O   ILE   115      -4.964  26.714  16.887  1.00 21.88           O  
ATOM   1785  CB  ILE   115      -2.385  28.102  15.995  1.00 27.41           C  
ATOM   1786  CG1 ILE   115      -1.353  29.231  16.088  1.00 25.65           C  
ATOM   1787  CG2 ILE   115      -2.310  27.350  14.623  1.00 21.73           C  
ATOM   1788  CD1 ILE   115       0.119  28.811  16.281  1.00 23.90           C  
ATOM   1789  N   LYS   116      -5.675  27.829  15.037  1.00 24.59           N  
ATOM   1790  CA  LYS   116      -6.770  26.916  14.730  1.00 24.48           C  
ATOM   1791  C   LYS   116      -6.264  25.974  13.693  1.00 24.99           C  
ATOM   1792  O   LYS   116      -5.629  26.398  12.725  1.00 22.82           O  
ATOM   1793  CB  LYS   116      -7.972  27.677  14.165  1.00 24.07           C  
ATOM   1794  CG  LYS   116      -9.158  26.781  13.740  1.00 29.98           C  
ATOM   1795  CD  LYS   116     -10.210  27.567  12.898  1.00 26.90           C  
ATOM   1796  CE  LYS   116     -11.451  26.766  12.786  1.00 39.03           C  
ATOM   1797  NZ  LYS   116     -12.534  27.439  11.993  1.00 36.98           N  
ATOM   1798  N   ILE   117      -6.501  24.689  13.894  1.00 23.12           N  
ATOM   1799  CA  ILE   117      -6.088  23.710  12.889  1.00 24.67           C  
ATOM   1800  C   ILE   117      -7.274  22.911  12.408  1.00 22.63           C  
ATOM   1801  O   ILE   117      -7.896  22.146  13.175  1.00 23.51           O  
ATOM   1802  CB  ILE   117      -4.971  22.769  13.398  1.00 24.32           C  
ATOM   1803  CG1 ILE   117      -3.739  23.593  13.802  1.00 23.43           C  
ATOM   1804  CG2 ILE   117      -4.647  21.690  12.353  1.00 22.46           C  
ATOM   1805  CD1 ILE   117      -2.857  22.926  14.780  1.00 29.93           C  
ATOM   1806  N   VAL   118      -7.541  23.056  11.109  1.00 22.92           N  
ATOM   1807  CA  VAL   118      -8.609  22.333  10.418  1.00 24.35           C  
ATOM   1808  C   VAL   118      -8.024  21.095   9.739  1.00 22.53           C  
ATOM   1809  O   VAL   118      -7.231  21.177   8.816  1.00 25.36           O  
ATOM   1810  CB  VAL   118      -9.412  23.261   9.409  1.00 25.46           C  
ATOM   1811  CG1 VAL   118     -10.457  22.460   8.588  1.00 22.00           C  
ATOM   1812  CG2 VAL   118     -10.093  24.366  10.166  1.00 23.69           C  
ATOM   1813  N   PRO   119      -8.399  19.907  10.196  1.00 26.30           N  
ATOM   1814  CA  PRO   119      -7.805  18.708   9.598  1.00 23.16           C  
ATOM   1815  C   PRO   119      -8.249  18.413   8.191  1.00 23.39           C  
ATOM   1816  O   PRO   119      -9.413  18.576   7.884  1.00 21.45           O  
ATOM   1817  CB  PRO   119      -8.350  17.590  10.492  1.00 26.11           C  
ATOM   1818  CG  PRO   119      -8.743  18.279  11.769  1.00 35.28           C  
ATOM   1819  CD  PRO   119      -9.305  19.557  11.300  1.00 27.67           C  
ATOM   1820  N   GLU   120      -7.330  17.947   7.351  1.00 22.68           N  
ATOM   1821  CA  GLU   120      -7.670  17.614   5.964  1.00 21.99           C  
ATOM   1822  C   GLU   120      -7.601  16.102   5.818  1.00 22.64           C  
ATOM   1823  O   GLU   120      -8.355  15.469   5.064  1.00 24.80           O  
ATOM   1824  CB  GLU   120      -6.736  18.335   4.969  1.00 22.70           C  
ATOM   1825  CG  GLU   120      -6.900  19.845   5.001  1.00 20.40           C  
ATOM   1826  CD  GLU   120      -8.306  20.290   4.534  1.00 34.03           C  
ATOM   1827  OE1 GLU   120      -8.966  19.534   3.783  1.00 30.66           O  
ATOM   1828  OE2 GLU   120      -8.712  21.408   4.885  1.00 30.18           O  
ATOM   1829  N   GLN   121      -6.709  15.527   6.594  1.00 24.66           N  
ATOM   1830  CA  GLN   121      -6.496  14.081   6.638  1.00 23.73           C  
ATOM   1831  C   GLN   121      -6.116  13.668   8.034  1.00 24.77           C  
ATOM   1832  O   GLN   121      -5.267  14.305   8.654  1.00 23.86           O  
ATOM   1833  CB  GLN   121      -5.373  13.753   5.682  1.00 25.65           C  
ATOM   1834  CG  GLN   121      -5.802  14.075   4.254  1.00 40.52           C  
ATOM   1835  CD  GLN   121      -4.797  14.893   3.417  1.00 54.09           C  
ATOM   1836  OE1 GLN   121      -3.747  15.361   3.914  1.00 52.65           O  
ATOM   1837  NE2 GLN   121      -5.164  15.122   2.141  1.00 48.47           N  
ATOM   1838  N   ILE   122      -6.731  12.593   8.524  1.00 21.91           N  
ATOM   1839  CA  ILE   122      -6.380  12.019   9.821  1.00 24.16           C  
ATOM   1840  C   ILE   122      -6.192  10.559   9.697  1.00 25.57           C  
ATOM   1841  O   ILE   122      -7.104   9.882   9.250  1.00 24.21           O  
ATOM   1842  CB  ILE   122      -7.443  12.235  10.907  1.00 20.31           C  
ATOM   1843  CG1 ILE   122      -7.883  13.710  10.977  1.00 23.42           C  
ATOM   1844  CG2 ILE   122      -6.879  11.770  12.208  1.00 22.36           C  
ATOM   1845  CD1 ILE   122      -8.873  14.009  12.042  1.00 30.33           C  
ATOM   1846  N   ARG   123      -4.984  10.091  10.057  1.00 23.37           N  
ATOM   1847  CA  ARG   123      -4.657   8.692  10.024  1.00 26.13           C  
ATOM   1848  C   ARG   123      -4.416   8.207  11.435  1.00 26.76           C  
ATOM   1849  O   ARG   123      -3.755   8.905  12.241  1.00 24.02           O  
ATOM   1850  CB  ARG   123      -3.386   8.451   9.252  1.00 28.72           C  
ATOM   1851  CG  ARG   123      -3.494   8.665   7.788  1.00 40.48           C  
ATOM   1852  CD  ARG   123      -2.445   7.803   7.120  1.00 48.20           C  
ATOM   1853  NE  ARG   123      -1.123   8.352   7.326  1.00 50.46           N  
ATOM   1854  CZ  ARG   123      -0.001   7.660   7.174  1.00 49.84           C  
ATOM   1855  NH1 ARG   123      -0.052   6.365   6.840  1.00 45.51           N  
ATOM   1856  NH2 ARG   123       1.170   8.264   7.381  1.00 39.62           N  
ATOM   1857  N   ILE   124      -5.011   7.063  11.760  1.00 22.50           N  
ATOM   1858  CA  ILE   124      -4.734   6.415  13.038  1.00 24.45           C  
ATOM   1859  C   ILE   124      -3.657   5.435  12.717  1.00 24.58           C  
ATOM   1860  O   ILE   124      -3.829   4.523  11.892  1.00 20.24           O  
ATOM   1861  CB  ILE   124      -5.901   5.643  13.688  1.00 24.08           C  
ATOM   1862  CG1 ILE   124      -7.099   6.516  13.996  1.00 30.86           C  
ATOM   1863  CG2 ILE   124      -5.500   5.102  15.081  1.00 30.84           C  
ATOM   1864  CD1 ILE   124      -8.273   5.660  14.599  1.00 33.77           C  
ATOM   1865  N   LEU   125      -2.550   5.620  13.404  1.00 24.22           N  
ATOM   1866  CA  LEU   125      -1.399   4.785  13.257  1.00 26.90           C  
ATOM   1867  C   LEU   125      -1.216   3.896  14.470  1.00 28.39           C  
ATOM   1868  O   LEU   125      -1.678   4.229  15.576  1.00 24.33           O  
ATOM   1869  CB  LEU   125      -0.177   5.688  13.040  1.00 27.04           C  
ATOM   1870  CG  LEU   125      -0.197   6.589  11.806  1.00 29.37           C  
ATOM   1871  CD1 LEU   125       1.070   7.462  11.763  1.00 36.63           C  
ATOM   1872  CD2 LEU   125      -0.356   5.782  10.517  1.00 32.33           C  
ATOM   1873  N   ASN   126      -0.555   2.754  14.231  1.00 29.72           N  
ATOM   1874  CA  ASN   126      -0.239   1.761  15.256  1.00 30.16           C  
ATOM   1875  C   ASN   126      -1.513   1.250  15.937  1.00 30.72           C  
ATOM   1876  O   ASN   126      -1.550   0.994  17.153  1.00 28.12           O  
ATOM   1877  CB  ASN   126       0.769   2.326  16.280  1.00 31.62           C  
ATOM   1878  CG  ASN   126       1.511   1.238  17.057  1.00 29.72           C  
ATOM   1879  OD1 ASN   126       1.805   0.173  16.523  1.00 30.95           O  
ATOM   1880  ND2 ASN   126       1.842   1.515  18.310  1.00 31.08           N  
ATOM   1881  N   SER   127      -2.581   1.127  15.154  1.00 27.81           N  
ATOM   1882  CA  SER   127      -3.838   0.639  15.724  1.00 30.83           C  
ATOM   1883  C   SER   127      -3.832  -0.864  15.874  1.00 27.77           C  
ATOM   1884  O   SER   127      -4.618  -1.369  16.648  1.00 29.89           O  
ATOM   1885  CB  SER   127      -5.074   1.089  14.920  1.00 30.64           C  
ATOM   1886  OG  SER   127      -4.993   0.621  13.602  1.00 34.66           O  
ATOM   1887  OXT SER   127      -3.051  -1.593  15.260  1.00 27.95           O  
END
