
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  155 ( 1236),  selected  155 , name 2psw_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 2psw_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    G     3_A      -       -           -
LGA    S     4_A      -       -           -
LGA    R     5_A      A       2          1.930
LGA    I     6_A      I       3          1.428
LGA    E     7_A      N       4          0.681
LGA    L     8_A      I       5          1.290
LGA    G     9_A      I       6          1.783
LGA    D    10_A      E       7          2.535
LGA    V    11_A      Y       8          1.777
LGA    T    12_A      N       9          1.859
LGA    P    13_A      R      10          2.007
LGA    H    14_A      S      11          1.458
LGA    N    15_A      Y      12          1.711
LGA    I    16_A      K      13          1.262
LGA    K    17_A      E      14          1.438
LGA    Q    18_A      E      15          1.144
LGA    L    19_A      L      16          0.861
LGA    K    20_A      I      17          0.847
LGA    R    21_A      E      18          1.295
LGA    L    22_A      F      19          0.815
LGA    N    23_A      I      20          1.000
LGA    Q    24_A      L      21          1.218
LGA    V    25_A      S      22          1.036
LGA    I    26_A      I      23          1.770
LGA    F    27_A      Q      24          2.329
LGA    P    28_A      K      25          3.956
LGA    -       -      N      26           -
LGA    -       -      E      27           -
LGA    -       -      F      28           -
LGA    -       -      N      29           -
LGA    -       -      I      30           -
LGA    -       -      K      31           -
LGA    V    29_A      I      32          2.691
LGA    S    30_A      D      33          2.573
LGA    Y    31_A      R      34          3.596
LGA    N    32_A      D      35          3.528
LGA    D    33_A      D      36           -
LGA    -       -      Q      37           -
LGA    K    34_A      P      38          3.379
LGA    F    35_A      D      39          1.077
LGA    Y    36_A      L      40          2.466
LGA    K    37_A      E      41          3.913
LGA    D    38_A      N      42          3.747
LGA    V    39_A      I      43          1.088
LGA    L    40_A      E      44          1.764
LGA    E    41_A      H      45          3.090
LGA    -       -      N      46           -
LGA    V    42_A      Y      47          2.920
LGA    G    43_A      L      48          3.097
LGA    E    44_A      N      49           -
LGA    -       -      S      50           -
LGA    -       -      G      51           -
LGA    -       -      G      52           -
LGA    L    45_A      Q      53          0.602
LGA    A    46_A      F      54          0.880
LGA    K    47_A      W      55          1.781
LGA    L    48_A      L      56          1.726
LGA    A    49_A      A      57          1.198
LGA    Y    50_A      I      58          1.009
LGA    F    51_A      N      59          2.702
LGA    N    52_A      N      60          3.110
LGA    D    53_A      H      61          3.463
LGA    -       -      Q      62           -
LGA    I    54_A      N      63          3.067
LGA    A    55_A      I      64          1.861
LGA    V    56_A      V      65          1.579
LGA    G    57_A      G      66          1.904
LGA    A    58_A      T      67          1.505
LGA    V    59_A      I      68          1.427
LGA    C    60_A      G      69          2.101
LGA    C    61_A      L      70          2.027
LGA    R    62_A      I      71          1.077
LGA    V    63_A      R      72          0.917
LGA    D    64_A      L      73          1.309
LGA    H    65_A      D      74          1.932
LGA    S    66_A      -       -           -
LGA    Q    67_A      -       -           -
LGA    N    68_A      -       -           -
LGA    Q    69_A      N      75          2.774
LGA    K    70_A      N      76          1.910
LGA    R    71_A      M      77          1.462
LGA    L    72_A      S      78          1.549
LGA    Y    73_A      A      79          0.677
LGA    I    74_A      L      80          1.221
LGA    X    75_A      K      81          1.767
LGA    T    76_A      K      82          0.700
LGA    L    77_A      M      83          0.671
LGA    G    78_A      F      84          0.497
LGA    C    79_A      V      85          1.403
LGA    L    80_A      D      86          1.523
LGA    A    81_A      K      87          1.093
LGA    P    82_A      G      88          1.713
LGA    Y    83_A      Y      89          1.227
LGA    R    84_A      R      90          0.729
LGA    R    85_A      N      91          1.863
LGA    L    86_A      L      92          1.035
LGA    G    87_A      K      93          1.054
LGA    I    88_A      I      94          1.035
LGA    G    89_A      G      95          0.655
LGA    T    90_A      K      96          0.925
LGA    K    91_A      K      97          1.296
LGA    X    92_A      L      98          0.968
LGA    L    93_A      L      99          0.681
LGA    N    94_A      D     100          0.827
LGA    H    95_A      K     101          1.062
LGA    V    96_A      V     102          0.705
LGA    L    97_A      I     103          0.598
LGA    N    98_A      M     104          0.868
LGA    I    99_A      T     105          0.912
LGA    C   100_A      C     106          0.710
LGA    E   101_A      K     107          0.735
LGA    K   102_A      E     108          0.831
LGA    D   103_A      Q     109          1.105
LGA    G   104_A      N     110          1.275
LGA    T   105_A      I     111          3.616
LGA    F   106_A      -       -           -
LGA    D   107_A      D     112          2.343
LGA    N   108_A      G     113          1.085
LGA    I   109_A      I     114          0.241
LGA    Y   110_A      Y     115          1.421
LGA    L   111_A      L     116          0.916
LGA    H   112_A      G     117          0.909
LGA    V   113_A      T     118          1.536
LGA    Q   114_A      I     119          0.925
LGA    I   115_A      D     120          2.209
LGA    S   116_A      K     121          3.214
LGA    N   117_A      F     122          2.409
LGA    E   118_A      I     123          2.388
LGA    S   119_A      S     124          0.685
LGA    A   120_A      A     125          0.628
LGA    I   121_A      Q     126          1.247
LGA    D   122_A      Y     127          0.907
LGA    F   123_A      F     128          0.753
LGA    Y   124_A      Y     129          1.031
LGA    R   125_A      S     130          1.284
LGA    K   126_A      N     131          1.322
LGA    F   127_A      N     132          1.167
LGA    G   128_A      G     133          0.752
LGA    F   129_A      F     134          0.397
LGA    E   130_A      R     135          0.639
LGA    I   131_A      E     136          0.505
LGA    I   132_A      I     137          1.178
LGA    E   133_A      K     138          1.615
LGA    T   134_A      -       -           -
LGA    K   135_A      R     139          3.858
LGA    K   136_A      G     140           -
LGA    N   137_A      D     141           -
LGA    -       -      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    -       -      K     148           -
LGA    Y   138_A      L     149          6.205
LGA    Y   139_A      D     150          2.986
LGA    K   140_A      V     151           #
LGA    R   141_A      -       -           -
LGA    I   142_A      -       -           -
LGA    E   143_A      -       -           -
LGA    P   144_A      -       -           -
LGA    A   145_A      -       -           -
LGA    D   146_A      D     152          5.845
LGA    A   147_A      N     153          1.109
LGA    H   148_A      R     154          1.126
LGA    V   149_A      F     155          0.625
LGA    L   150_A      Y     156          1.018
LGA    Q   151_A      Y     157          0.770
LGA    K   152_A      R     158          0.159
LGA    N   153_A      N     159          0.889
LGA    L   154_A      L     160          1.652
LGA    K   155_A      K     161          2.496

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  155  160    5.0    136    1.91    23.53     76.255     6.750

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.396770 * X  +  -0.627012 * Y  +   0.670395 * Z  + 239.973984
  Y_new =   0.426980 * X  +   0.772590 * Y  +   0.469887 * Z  + -206.511093
  Z_new =  -0.812565 * X  +   0.099808 * Y  +   0.574261 * Z  +  91.167610 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.172084   -2.969509  [ DEG:     9.8597   -170.1403 ]
  Theta =   0.948540    2.193053  [ DEG:    54.3473    125.6527 ]
  Phi   =   0.822055   -2.319538  [ DEG:    47.1003   -132.8997 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2psw_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2psw_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  155  160   5.0  136   1.91   23.53  76.255
REMARK  ---------------------------------------------------------- 
MOLECULE 2psw_A
HEADER    TRANSFERASE                             07-MAY-07   2PSW              
TITLE     HUMAN MAK3 HOMOLOG IN COMPLEX WITH COA                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: N-ACETYLTRANSFERASE 13;                                    
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: HNAT5, HSAN;                                                
COMPND   5 EC: 2.3.1.88;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: NAT13, MAK3, NAT5;                                             
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28-LIC                                 
KEYWDS    ACETYLTRANSFERASE, STRUCTURAL GENOMICS CONSORTIUM, SGC                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.R.WALKER,A.SCHUETZ,T.ANTOSHENKO,H.WU,G.BERNSTEIN,                   
AUTHOR   2 P.LOPPNAU,J.WEIGELT,M.SUNDSTROM,C.H.ARROWSMITH,A.M.EDWARDS,          
AUTHOR   3 A.BOCHKAREV,A.N.PLOTNIKOV,STRUCTURAL GENOMICS CONSORTIUM             
AUTHOR   4 (SGC)                                                                
REVDAT   1   05-JUN-07 2PSW    0                                                
JRNL        AUTH   A.SCHUETZ,J.R.WALKER,T.ANTOSHENKO,H.WU,G.BERNSTEIN,          
JRNL        AUTH 2 P.LOPPNAU,J.WEIGELT,M.SUNDSTROM,C.H.ARROWSMITH,              
JRNL        AUTH 3 A.M.EDWARDS,A.BOCHKAREV,A.N.PLOTNIKOV                        
JRNL        TITL   STRUCTURE OF HUMAN MAK3 HOMOLOG.                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2PSW A    2   169  UNP    Q9GZZ1   NAT13_HUMAN      2    169             
DBREF  2PSW B    2   169  UNP    Q9GZZ1   NAT13_HUMAN      2    169             
DBREF  2PSW C    2   169  UNP    Q9GZZ1   NAT13_HUMAN      2    169             
SEQRES   1 A  170  GLY SER LYS GLY SER ARG ILE GLU LEU GLY ASP VAL THR          
SEQRES   2 A  170  PRO HIS ASN ILE LYS GLN LEU LYS ARG LEU ASN GLN VAL          
SEQRES   3 A  170  ILE PHE PRO VAL SER TYR ASN ASP LYS PHE TYR LYS ASP          
SEQRES   4 A  170  VAL LEU GLU VAL GLY GLU LEU ALA LYS LEU ALA TYR PHE          
SEQRES   5 A  170  ASN ASP ILE ALA VAL GLY ALA VAL CYS CYS ARG VAL ASP          
SEQRES   6 A  170  HIS SER GLN ASN GLN LYS ARG LEU TYR ILE MSE THR LEU          
SEQRES   7 A  170  GLY CYS LEU ALA PRO TYR ARG ARG LEU GLY ILE GLY THR          
SEQRES   8 A  170  LYS MSE LEU ASN HIS VAL LEU ASN ILE CYS GLU LYS ASP          
SEQRES   9 A  170  GLY THR PHE ASP ASN ILE TYR LEU HIS VAL GLN ILE SER          
SEQRES  10 A  170  ASN GLU SER ALA ILE ASP PHE TYR ARG LYS PHE GLY PHE          
SEQRES  11 A  170  GLU ILE ILE GLU THR LYS LYS ASN TYR TYR LYS ARG ILE          
SEQRES  12 A  170  GLU PRO ALA ASP ALA HIS VAL LEU GLN LYS ASN LEU LYS          
SEQRES  13 A  170  VAL PRO SER GLY GLN ASN ALA ASP VAL GLN LYS THR ASP          
SEQRES  14 A  170  ASN                                                          
SEQRES   1 B  170  GLY SER LYS GLY SER ARG ILE GLU LEU GLY ASP VAL THR          
SEQRES   2 B  170  PRO HIS ASN ILE LYS GLN LEU LYS ARG LEU ASN GLN VAL          
SEQRES   3 B  170  ILE PHE PRO VAL SER TYR ASN ASP LYS PHE TYR LYS ASP          
SEQRES   4 B  170  VAL LEU GLU VAL GLY GLU LEU ALA LYS LEU ALA TYR PHE          
SEQRES   5 B  170  ASN ASP ILE ALA VAL GLY ALA VAL CYS CYS ARG VAL ASP          
SEQRES   6 B  170  HIS SER GLN ASN GLN LYS ARG LEU TYR ILE MSE THR LEU          
SEQRES   7 B  170  GLY CYS LEU ALA PRO TYR ARG ARG LEU GLY ILE GLY THR          
SEQRES   8 B  170  LYS MSE LEU ASN HIS VAL LEU ASN ILE CYS GLU LYS ASP          
SEQRES   9 B  170  GLY THR PHE ASP ASN ILE TYR LEU HIS VAL GLN ILE SER          
SEQRES  10 B  170  ASN GLU SER ALA ILE ASP PHE TYR ARG LYS PHE GLY PHE          
SEQRES  11 B  170  GLU ILE ILE GLU THR LYS LYS ASN TYR TYR LYS ARG ILE          
SEQRES  12 B  170  GLU PRO ALA ASP ALA HIS VAL LEU GLN LYS ASN LEU LYS          
SEQRES  13 B  170  VAL PRO SER GLY GLN ASN ALA ASP VAL GLN LYS THR ASP          
SEQRES  14 B  170  ASN                                                          
SEQRES   1 C  170  GLY SER LYS GLY SER ARG ILE GLU LEU GLY ASP VAL THR          
SEQRES   2 C  170  PRO HIS ASN ILE LYS GLN LEU LYS ARG LEU ASN GLN VAL          
SEQRES   3 C  170  ILE PHE PRO VAL SER TYR ASN ASP LYS PHE TYR LYS ASP          
SEQRES   4 C  170  VAL LEU GLU VAL GLY GLU LEU ALA LYS LEU ALA TYR PHE          
SEQRES   5 C  170  ASN ASP ILE ALA VAL GLY ALA VAL CYS CYS ARG VAL ASP          
SEQRES   6 C  170  HIS SER GLN ASN GLN LYS ARG LEU TYR ILE MSE THR LEU          
SEQRES   7 C  170  GLY CYS LEU ALA PRO TYR ARG ARG LEU GLY ILE GLY THR          
SEQRES   8 C  170  LYS MSE LEU ASN HIS VAL LEU ASN ILE CYS GLU LYS ASP          
SEQRES   9 C  170  GLY THR PHE ASP ASN ILE TYR LEU HIS VAL GLN ILE SER          
SEQRES  10 C  170  ASN GLU SER ALA ILE ASP PHE TYR ARG LYS PHE GLY PHE          
SEQRES  11 C  170  GLU ILE ILE GLU THR LYS LYS ASN TYR TYR LYS ARG ILE          
SEQRES  12 C  170  GLU PRO ALA ASP ALA HIS VAL LEU GLN LYS ASN LEU LYS          
SEQRES  13 C  170  VAL PRO SER GLY GLN ASN ALA ASP VAL GLN LYS THR ASP          
SEQRES  14 C  170  ASN                                                          
HET    MSE  A  75       8                                                       
HET    MSE  A  92       8                                                       
HET    MSE  B  75      16                                                       
HET    MSE  B  92       8                                                       
HET    MSE  C  75       8                                                       
HET    MSE  C  92       8                                                       
HET    COA  A 201      51                                                       
HET    COA  B 201      48                                                       
HET    COA  C 201      48                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     COA COENZYME A                                                       
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   4  COA    3(C21 H36 N7 O16 P3 S)                                       
FORMUL   7  HOH   *151(H2 O)                                                    
CRYST1   47.643  102.913   67.157  90.00 105.81  90.00 P 1 21 1      6          
ATOM      1  N   SER A   1     -25.712  46.201  30.739  1.00 65.04           N  
ATOM      2  CA  SER A   1     -25.832  46.441  32.221  1.00 62.03           C  
ATOM      3  C   SER A   1     -27.203  46.975  32.598  1.00 60.98           C  
ATOM      4  O   SER A   1     -27.673  46.775  33.738  1.00 57.60           O  
ATOM      5  CB  SER A   1     -24.790  47.451  32.703  1.00 64.55           C  
ATOM      6  OG  SER A   1     -25.296  48.781  32.616  1.00 60.59           O  
ATOM      7  N   LYS A   2     -27.834  47.688  31.663  1.00 59.98           N  
ATOM      8  CA  LYS A   2     -29.099  48.336  32.005  1.00 59.80           C  
ATOM      9  C   LYS A   2     -30.253  47.337  31.984  1.00 58.04           C  
ATOM     10  O   LYS A   2     -30.379  46.527  31.062  1.00 55.90           O  
ATOM     11  CB  LYS A   2     -29.316  49.667  31.257  1.00 61.43           C  
ATOM     12  CG  LYS A   2     -30.066  49.641  29.974  1.00 60.03           C  
ATOM     13  CD  LYS A   2     -31.414  50.275  30.164  1.00 57.24           C  
ATOM     14  CE  LYS A   2     -31.992  50.755  28.836  1.00 61.42           C  
ATOM     15  NZ  LYS A   2     -32.274  49.596  27.962  1.00 59.70           N  
ATOM     16  N   GLY A   3     -31.026  47.369  33.067  1.00 55.48           N  
ATOM     17  CA  GLY A   3     -32.107  46.422  33.322  1.00 57.59           C  
ATOM     18  C   GLY A   3     -31.620  45.106  33.923  1.00 55.36           C  
ATOM     19  O   GLY A   3     -32.413  44.210  34.197  1.00 56.48           O  
ATOM     20  N   SER A   4     -30.303  45.003  34.101  1.00 53.69           N  
ATOM     21  CA  SER A   4     -29.649  43.790  34.577  1.00 50.15           C  
ATOM     22  C   SER A   4     -30.186  43.375  35.930  1.00 48.50           C  
ATOM     23  O   SER A   4     -30.453  44.223  36.798  1.00 47.44           O  
ATOM     24  CB  SER A   4     -28.137  43.996  34.681  1.00 49.86           C  
ATOM     25  OG  SER A   4     -27.489  42.831  35.167  1.00 48.79           O  
ATOM     26  N   ARG A   5     -30.348  42.069  36.107  0.50 47.27           N  
ATOM     28  CA  ARG A   5     -30.808  41.516  37.378  0.50 46.31           C  
ATOM     30  C   ARG A   5     -29.607  41.137  38.251  0.50 43.77           C  
ATOM     32  O   ARG A   5     -29.758  40.675  39.393  0.50 44.48           O  
ATOM     34  CB  ARG A   5     -31.742  40.325  37.122  0.50 46.37           C  
ATOM     36  CG  ARG A   5     -33.007  40.713  36.347  0.50 50.17           C  
ATOM     38  CD  ARG A   5     -34.125  39.670  36.439  0.50 53.38           C  
ATOM     40  NE  ARG A   5     -35.429  40.232  36.068  0.50 59.20           N  
ATOM     42  CZ  ARG A   5     -36.213  40.951  36.880  0.50 62.47           C  
ATOM     44  NH1 ARG A   5     -35.844  41.212  38.127  0.50 60.93           N  
ATOM     46  NH2 ARG A   5     -37.380  41.418  36.440  0.50 65.18           N  
ATOM     48  N   ILE A   6     -28.410  41.339  37.704  1.00 41.46           N  
ATOM     49  CA  ILE A   6     -27.184  41.014  38.405  1.00 40.54           C  
ATOM     50  C   ILE A   6     -26.425  42.260  38.874  1.00 41.52           C  
ATOM     51  O   ILE A   6     -26.244  43.233  38.124  1.00 41.07           O  
ATOM     52  CB  ILE A   6     -26.263  40.157  37.544  1.00 41.58           C  
ATOM     53  CG1 ILE A   6     -27.030  39.034  36.865  1.00 44.10           C  
ATOM     54  CG2 ILE A   6     -25.126  39.564  38.392  1.00 40.90           C  
ATOM     55  CD1 ILE A   6     -26.306  38.579  35.612  1.00 53.13           C  
ATOM     56  N   GLU A   7     -25.947  42.180  40.107  1.00 41.62           N  
ATOM     57  CA  GLU A   7     -25.252  43.269  40.789  1.00 44.63           C  
ATOM     58  C   GLU A   7     -24.184  42.660  41.697  1.00 45.46           C  
ATOM     59  O   GLU A   7     -24.422  41.623  42.360  1.00 43.06           O  
ATOM     60  CB  GLU A   7     -26.276  44.055  41.597  1.00 46.81           C  
ATOM     61  CG  GLU A   7     -25.760  45.242  42.371  1.00 53.40           C  
ATOM     62  CD  GLU A   7     -26.867  46.257  42.732  1.00 56.12           C  
ATOM     63  OE1 GLU A   7     -26.582  47.147  43.574  1.00 59.99           O  
ATOM     64  OE2 GLU A   7     -28.002  46.176  42.164  1.00 61.05           O  
ATOM     65  N   LEU A   8     -23.008  43.289  41.726  1.00 38.42           N  
ATOM     66  CA  LEU A   8     -21.955  42.852  42.625  1.00 40.25           C  
ATOM     67  C   LEU A   8     -21.919  43.753  43.848  1.00 40.57           C  
ATOM     68  O   LEU A   8     -22.218  44.943  43.760  1.00 41.05           O  
ATOM     69  CB  LEU A   8     -20.575  42.838  41.936  1.00 37.25           C  
ATOM     70  CG  LEU A   8     -20.496  42.125  40.604  1.00 38.64           C  
ATOM     71  CD1 LEU A   8     -19.092  42.233  40.020  1.00 34.47           C  
ATOM     72  CD2 LEU A   8     -20.974  40.650  40.708  1.00 34.78           C  
ATOM     73  N   GLY A   9     -21.538  43.208  44.985  1.00 40.03           N  
ATOM     74  CA  GLY A   9     -21.476  44.030  46.188  1.00 40.54           C  
ATOM     75  C   GLY A   9     -20.230  43.756  46.998  1.00 42.47           C  
ATOM     76  O   GLY A   9     -19.521  42.791  46.760  1.00 42.95           O  
ATOM     77  N   ASP A  10     -19.964  44.620  47.964  1.00 44.71           N  
ATOM     78  CA  ASP A  10     -18.801  44.471  48.803  1.00 45.50           C  
ATOM     79  C   ASP A  10     -18.983  43.364  49.826  1.00 45.99           C  
ATOM     80  O   ASP A  10     -20.110  43.117  50.347  1.00 49.06           O  
ATOM     81  CB  ASP A  10     -18.499  45.785  49.516  1.00 46.52           C  
ATOM     82  CG  ASP A  10     -17.845  46.822  48.607  1.00 48.66           C  
ATOM     83  OD1 ASP A  10     -17.638  46.580  47.401  1.00 52.16           O  
ATOM     84  OD2 ASP A  10     -17.516  47.898  49.127  1.00 55.05           O  
ATOM     85  N   VAL A  11     -17.864  42.719  50.136  1.00 46.00           N  
ATOM     86  CA  VAL A  11     -17.802  41.741  51.225  1.00 47.16           C  
ATOM     87  C   VAL A  11     -17.439  42.498  52.506  1.00 49.30           C  
ATOM     88  O   VAL A  11     -16.504  43.298  52.529  1.00 49.76           O  
ATOM     89  CB  VAL A  11     -16.772  40.604  50.946  1.00 47.22           C  
ATOM     90  CG1 VAL A  11     -16.775  39.597  52.076  1.00 50.82           C  
ATOM     91  CG2 VAL A  11     -17.064  39.891  49.611  1.00 46.07           C  
ATOM     92  N   THR A  12     -18.205  42.267  53.567  1.00 49.71           N  
ATOM     93  CA  THR A  12     -18.024  42.995  54.813  1.00 50.36           C  
ATOM     94  C   THR A  12     -18.129  42.004  55.959  1.00 51.49           C  
ATOM     95  O   THR A  12     -18.616  40.889  55.763  1.00 51.50           O  
ATOM     96  CB  THR A  12     -19.120  44.057  55.009  1.00 50.80           C  
ATOM     97  OG1 THR A  12     -20.383  43.407  55.215  1.00 53.44           O  
ATOM     98  CG2 THR A  12     -19.200  45.008  53.818  1.00 49.95           C  
ATOM     99  N   PRO A  13     -17.717  42.418  57.178  1.00 54.70           N  
ATOM    100  CA  PRO A  13     -17.917  41.505  58.295  1.00 54.94           C  
ATOM    101  C   PRO A  13     -19.400  41.176  58.486  1.00 56.06           C  
ATOM    102  O   PRO A  13     -19.735  40.218  59.175  1.00 58.11           O  
ATOM    103  CB  PRO A  13     -17.393  42.300  59.503  1.00 59.64           C  
ATOM    104  CG  PRO A  13     -16.509  43.364  58.940  1.00 58.75           C  
ATOM    105  CD  PRO A  13     -17.104  43.698  57.598  1.00 54.28           C  
ATOM    106  N   HIS A  14     -20.290  41.954  57.882  1.00 54.39           N  
ATOM    107  CA  HIS A  14     -21.717  41.675  58.010  1.00 56.04           C  
ATOM    108  C   HIS A  14     -22.208  40.542  57.126  1.00 53.74           C  
ATOM    109  O   HIS A  14     -23.184  39.894  57.468  1.00 57.53           O  
ATOM    110  CB  HIS A  14     -22.565  42.925  57.772  1.00 56.44           C  
ATOM    111  CG  HIS A  14     -24.018  42.635  57.557  1.00 61.76           C  
ATOM    112  ND1 HIS A  14     -24.887  42.357  58.595  1.00 69.25           N  
ATOM    113  CD2 HIS A  14     -24.759  42.583  56.422  1.00 63.18           C  
ATOM    114  CE1 HIS A  14     -26.100  42.149  58.110  1.00 69.09           C  
ATOM    115  NE2 HIS A  14     -26.048  42.277  56.795  1.00 69.82           N  
ATOM    116  N   ASN A  15     -21.576  40.318  55.980  1.00 50.97           N  
ATOM    117  CA  ASN A  15     -22.107  39.320  55.064  1.00 47.81           C  
ATOM    118  C   ASN A  15     -21.101  38.231  54.761  1.00 49.56           C  
ATOM    119  O   ASN A  15     -21.363  37.397  53.913  1.00 47.62           O  
ATOM    120  CB  ASN A  15     -22.612  39.971  53.759  1.00 46.47           C  
ATOM    121  CG  ASN A  15     -21.553  40.819  53.092  1.00 40.90           C  
ATOM    122  OD1 ASN A  15     -20.363  40.518  53.164  1.00 42.13           O  
ATOM    123  ND2 ASN A  15     -21.978  41.912  52.479  1.00 41.58           N  
ATOM    124  N   ILE A  16     -19.958  38.241  55.456  1.00 52.63           N  
ATOM    125  CA  ILE A  16     -18.875  37.271  55.208  1.00 54.10           C  
ATOM    126  C   ILE A  16     -19.360  35.835  55.505  1.00 55.74           C  
ATOM    127  O   ILE A  16     -18.957  34.877  54.843  1.00 55.11           O  
ATOM    128  CB  ILE A  16     -17.573  37.619  56.002  1.00 56.33           C  
ATOM    129  CG1 ILE A  16     -16.387  36.751  55.550  1.00 55.92           C  
ATOM    130  CG2 ILE A  16     -17.771  37.482  57.536  1.00 53.81           C  
ATOM    131  CD1 ILE A  16     -15.484  37.378  54.550  1.00 50.89           C  
ATOM    132  N   LYS A  17     -20.253  35.713  56.477  1.00 56.49           N  
ATOM    133  CA  LYS A  17     -20.856  34.427  56.817  1.00 59.01           C  
ATOM    134  C   LYS A  17     -21.546  33.866  55.577  1.00 56.99           C  
ATOM    135  O   LYS A  17     -21.506  32.670  55.316  1.00 56.20           O  
ATOM    136  CB  LYS A  17     -21.876  34.612  57.934  1.00 60.30           C  
ATOM    137  N   GLN A  18     -22.144  34.763  54.803  1.00 55.36           N  
ATOM    138  CA  GLN A  18     -22.889  34.413  53.611  1.00 54.13           C  
ATOM    139  C   GLN A  18     -21.921  34.007  52.486  1.00 51.13           C  
ATOM    140  O   GLN A  18     -22.203  33.069  51.733  1.00 46.05           O  
ATOM    141  CB  GLN A  18     -23.793  35.604  53.220  1.00 55.92           C  
ATOM    142  CG  GLN A  18     -24.489  35.514  51.841  1.00 60.01           C  
ATOM    143  CD  GLN A  18     -25.727  34.607  51.875  1.00 69.22           C  
ATOM    144  OE1 GLN A  18     -25.688  33.429  51.454  1.00 67.75           O  
ATOM    145  NE2 GLN A  18     -26.831  35.151  52.395  1.00 69.03           N  
ATOM    146  N   LEU A  19     -20.790  34.720  52.375  1.00 49.43           N  
ATOM    147  CA  LEU A  19     -19.719  34.324  51.465  1.00 48.27           C  
ATOM    148  C   LEU A  19     -19.200  32.894  51.720  1.00 49.84           C  
ATOM    149  O   LEU A  19     -19.128  32.095  50.794  1.00 47.63           O  
ATOM    150  CB  LEU A  19     -18.551  35.300  51.527  1.00 49.51           C  
ATOM    151  CG  LEU A  19     -17.388  34.893  50.597  1.00 53.50           C  
ATOM    152  CD1 LEU A  19     -17.666  35.291  49.196  1.00 49.97           C  
ATOM    153  CD2 LEU A  19     -16.064  35.478  51.040  1.00 58.49           C  
ATOM    154  N   LYS A  20     -18.863  32.576  52.974  1.00 49.90           N  
ATOM    155  CA  LYS A  20     -18.372  31.251  53.334  1.00 52.58           C  
ATOM    156  C   LYS A  20     -19.392  30.161  52.968  1.00 52.75           C  
ATOM    157  O   LYS A  20     -19.025  29.120  52.438  1.00 52.01           O  
ATOM    158  CB  LYS A  20     -18.011  31.187  54.842  1.00 54.20           C  
ATOM    159  CG  LYS A  20     -17.573  29.806  55.330  1.00 58.33           C  
ATOM    160  CD  LYS A  20     -16.938  29.854  56.722  1.00 61.69           C  
ATOM    161  CE  LYS A  20     -16.331  28.511  57.125  1.00 70.17           C  
ATOM    162  NZ  LYS A  20     -16.199  28.368  58.637  1.00 72.60           N  
ATOM    163  N   ARG A  21     -20.666  30.422  53.280  1.00 53.60           N  
ATOM    164  CA  ARG A  21     -21.796  29.559  52.964  1.00 52.94           C  
ATOM    165  C   ARG A  21     -21.879  29.262  51.466  1.00 52.02           C  
ATOM    166  O   ARG A  21     -22.111  28.120  51.068  1.00 52.54           O  
ATOM    167  CB  ARG A  21     -23.056  30.272  53.393  1.00 55.09           C  
ATOM    168  CG  ARG A  21     -24.285  29.413  53.455  1.00 67.06           C  
ATOM    169  CD  ARG A  21     -25.176  29.779  54.661  1.00 77.48           C  
ATOM    170  NE  ARG A  21     -25.919  31.030  54.479  1.00 82.33           N  
ATOM    171  CZ  ARG A  21     -25.895  32.057  55.328  1.00 85.44           C  
ATOM    172  NH1 ARG A  21     -25.175  31.998  56.449  1.00 84.56           N  
ATOM    173  NH2 ARG A  21     -26.609  33.147  55.055  1.00 88.53           N  
ATOM    174  N   LEU A  22     -21.721  30.301  50.649  1.00 45.65           N  
ATOM    175  CA  LEU A  22     -21.739  30.173  49.206  1.00 46.48           C  
ATOM    176  C   LEU A  22     -20.562  29.328  48.757  1.00 45.97           C  
ATOM    177  O   LEU A  22     -20.735  28.411  47.972  1.00 46.71           O  
ATOM    178  CB  LEU A  22     -21.682  31.576  48.530  1.00 42.37           C  
ATOM    179  CG  LEU A  22     -23.036  32.298  48.541  1.00 36.89           C  
ATOM    180  CD1 LEU A  22     -22.869  33.759  48.300  1.00 41.95           C  
ATOM    181  CD2 LEU A  22     -23.983  31.663  47.541  1.00 38.14           C  
ATOM    182  N   ASN A  23     -19.372  29.637  49.269  1.00 44.96           N  
ATOM    183  CA  ASN A  23     -18.166  28.895  48.911  1.00 46.48           C  
ATOM    184  C   ASN A  23     -18.256  27.436  49.296  1.00 47.02           C  
ATOM    185  O   ASN A  23     -17.764  26.591  48.568  1.00 48.01           O  
ATOM    186  CB  ASN A  23     -16.912  29.508  49.574  1.00 47.88           C  
ATOM    187  CG  ASN A  23     -16.380  30.741  48.830  1.00 47.88           C  
ATOM    188  OD1 ASN A  23     -16.834  31.051  47.730  1.00 46.08           O  
ATOM    189  ND2 ASN A  23     -15.411  31.440  49.436  1.00 43.21           N  
ATOM    190  N   GLN A  24     -18.853  27.143  50.450  1.00 50.07           N  
ATOM    191  CA  GLN A  24     -19.011  25.746  50.933  1.00 53.45           C  
ATOM    192  C   GLN A  24     -19.854  24.903  49.985  1.00 51.52           C  
ATOM    193  O   GLN A  24     -19.568  23.723  49.776  1.00 53.64           O  
ATOM    194  CB  GLN A  24     -19.643  25.701  52.337  1.00 56.84           C  
ATOM    195  CG  GLN A  24     -18.730  26.084  53.504  1.00 60.72           C  
ATOM    196  CD  GLN A  24     -19.488  26.203  54.847  1.00 68.92           C  
ATOM    197  OE1 GLN A  24     -20.656  25.786  54.983  1.00 75.65           O  
ATOM    198  NE2 GLN A  24     -18.821  26.782  55.843  1.00 77.53           N  
ATOM    199  N   VAL A  25     -20.898  25.505  49.418  1.00 48.78           N  
ATOM    200  CA  VAL A  25     -21.761  24.820  48.453  1.00 49.23           C  
ATOM    201  C   VAL A  25     -21.122  24.692  47.056  1.00 48.79           C  
ATOM    202  O   VAL A  25     -21.173  23.653  46.426  1.00 50.04           O  
ATOM    203  CB  VAL A  25     -23.141  25.531  48.349  1.00 48.93           C  
ATOM    204  CG1 VAL A  25     -23.932  25.020  47.161  1.00 48.54           C  
ATOM    205  CG2 VAL A  25     -23.939  25.302  49.632  1.00 51.94           C  
ATOM    206  N   ILE A  26     -20.514  25.766  46.576  1.00 46.88           N  
ATOM    207  CA  ILE A  26     -20.058  25.820  45.209  1.00 45.83           C  
ATOM    208  C   ILE A  26     -18.721  25.098  44.973  1.00 50.07           C  
ATOM    209  O   ILE A  26     -18.541  24.424  43.945  1.00 51.98           O  
ATOM    210  CB  ILE A  26     -19.968  27.306  44.774  1.00 42.29           C  
ATOM    211  CG1 ILE A  26     -21.333  27.972  44.933  1.00 36.83           C  
ATOM    212  CG2 ILE A  26     -19.411  27.423  43.352  1.00 40.74           C  
ATOM    213  CD1 ILE A  26     -21.301  29.496  45.086  1.00 39.66           C  
ATOM    214  N   PHE A  27     -17.776  25.272  45.901  1.00 52.06           N  
ATOM    215  CA  PHE A  27     -16.396  24.802  45.727  1.00 54.17           C  
ATOM    216  C   PHE A  27     -16.092  23.550  46.517  1.00 59.88           C  
ATOM    217  O   PHE A  27     -16.481  23.436  47.692  1.00 60.32           O  
ATOM    218  CB  PHE A  27     -15.404  25.920  46.055  1.00 53.85           C  
ATOM    219  CG  PHE A  27     -15.602  27.140  45.210  1.00 48.93           C  
ATOM    220  CD1 PHE A  27     -15.198  27.151  43.882  1.00 49.94           C  
ATOM    221  CD2 PHE A  27     -16.271  28.241  45.717  1.00 48.30           C  
ATOM    222  CE1 PHE A  27     -15.421  28.262  43.075  1.00 45.72           C  
ATOM    223  CE2 PHE A  27     -16.513  29.369  44.918  1.00 48.55           C  
ATOM    224  CZ  PHE A  27     -16.069  29.365  43.576  1.00 47.45           C  
ATOM    225  N   PRO A  28     -15.393  22.596  45.879  1.00 63.52           N  
ATOM    226  CA  PRO A  28     -15.129  21.295  46.520  1.00 68.12           C  
ATOM    227  C   PRO A  28     -14.057  21.331  47.616  1.00 70.89           C  
ATOM    228  O   PRO A  28     -14.047  20.452  48.475  1.00 73.99           O  
ATOM    229  CB  PRO A  28     -14.673  20.415  45.356  1.00 69.47           C  
ATOM    230  CG  PRO A  28     -14.115  21.377  44.341  1.00 66.95           C  
ATOM    231  CD  PRO A  28     -14.809  22.691  44.526  1.00 63.96           C  
ATOM    232  N   VAL A  29     -13.170  22.332  47.574  1.00 71.88           N  
ATOM    233  CA  VAL A  29     -12.135  22.538  48.611  1.00 73.61           C  
ATOM    234  C   VAL A  29     -12.603  23.514  49.690  1.00 72.02           C  
ATOM    235  O   VAL A  29     -13.194  24.549  49.377  1.00 69.74           O  
ATOM    236  CB  VAL A  29     -10.758  23.005  48.009  1.00 74.93           C  
ATOM    237  CG1 VAL A  29     -10.942  23.739  46.702  1.00 73.40           C  
ATOM    238  CG2 VAL A  29      -9.971  23.875  48.993  1.00 74.67           C  
ATOM    239  N   SER A  30     -12.344  23.172  50.955  1.00 72.84           N  
ATOM    240  CA  SER A  30     -12.643  24.052  52.087  1.00 71.09           C  
ATOM    241  C   SER A  30     -11.565  25.104  52.307  1.00 68.96           C  
ATOM    242  O   SER A  30     -10.370  24.821  52.181  1.00 70.23           O  
ATOM    243  CB  SER A  30     -12.832  23.247  53.372  1.00 74.85           C  
ATOM    244  OG  SER A  30     -14.200  22.942  53.568  1.00 78.68           O  
ATOM    245  N   TYR A  31     -12.003  26.320  52.634  1.00 64.56           N  
ATOM    246  CA  TYR A  31     -11.103  27.440  52.888  1.00 62.88           C  
ATOM    247  C   TYR A  31     -11.090  27.764  54.384  1.00 63.13           C  
ATOM    248  O   TYR A  31     -12.119  27.677  55.048  1.00 64.25           O  
ATOM    249  CB  TYR A  31     -11.489  28.631  52.005  1.00 60.33           C  
ATOM    250  CG  TYR A  31     -11.365  28.275  50.543  1.00 61.27           C  
ATOM    251  CD1 TYR A  31     -10.119  28.310  49.911  1.00 62.97           C  
ATOM    252  CD2 TYR A  31     -12.475  27.842  49.797  1.00 59.37           C  
ATOM    253  CE1 TYR A  31      -9.967  27.953  48.572  1.00 64.09           C  
ATOM    254  CE2 TYR A  31     -12.330  27.471  48.444  1.00 61.06           C  
ATOM    255  CZ  TYR A  31     -11.069  27.536  47.843  1.00 62.40           C  
ATOM    256  OH  TYR A  31     -10.877  27.188  46.521  1.00 62.64           O  
ATOM    257  N   ASN A  32      -9.912  28.071  54.918  1.00 64.52           N  
ATOM    258  CA  ASN A  32      -9.731  28.241  56.360  1.00 65.71           C  
ATOM    259  C   ASN A  32     -10.004  29.674  56.746  1.00 65.95           C  
ATOM    260  O   ASN A  32     -10.205  30.521  55.866  1.00 63.27           O  
ATOM    261  CB  ASN A  32      -8.313  27.836  56.798  1.00 68.17           C  
ATOM    262  CG  ASN A  32      -7.219  28.581  56.038  1.00 67.40           C  
ATOM    263  OD1 ASN A  32      -7.461  29.623  55.417  1.00 66.27           O  
ATOM    264  ND2 ASN A  32      -6.010  28.032  56.064  1.00 65.07           N  
ATOM    265  N   ASP A  33      -9.974  29.952  58.048  1.00 67.29           N  
ATOM    266  CA  ASP A  33     -10.344  31.275  58.566  1.00 68.95           C  
ATOM    267  C   ASP A  33      -9.414  32.389  58.103  1.00 67.95           C  
ATOM    268  O   ASP A  33      -9.794  33.559  58.068  1.00 66.88           O  
ATOM    269  CB  ASP A  33     -10.457  31.236  60.089  1.00 71.46           C  
ATOM    270  CG  ASP A  33     -11.465  30.198  60.560  1.00 75.08           C  
ATOM    271  OD1 ASP A  33     -12.390  29.869  59.766  1.00 72.59           O  
ATOM    272  OD2 ASP A  33     -11.336  29.714  61.714  1.00 77.77           O  
ATOM    273  N   LYS A  34      -8.200  32.002  57.733  1.00 69.36           N  
ATOM    274  CA  LYS A  34      -7.258  32.930  57.163  1.00 69.55           C  
ATOM    275  C   LYS A  34      -7.764  33.435  55.816  1.00 65.99           C  
ATOM    276  O   LYS A  34      -7.693  34.635  55.566  1.00 66.94           O  
ATOM    277  CB  LYS A  34      -5.870  32.303  57.024  1.00 72.23           C  
ATOM    278  CG  LYS A  34      -4.754  33.319  57.156  1.00 77.61           C  
ATOM    279  CD  LYS A  34      -3.454  32.828  56.551  1.00 84.96           C  
ATOM    280  CE  LYS A  34      -2.494  33.995  56.321  1.00 88.61           C  
ATOM    281  N   PHE A  35      -8.269  32.531  54.962  1.00 63.35           N  
ATOM    282  CA  PHE A  35      -8.829  32.904  53.655  1.00 60.11           C  
ATOM    283  C   PHE A  35      -9.782  34.061  53.853  1.00 57.98           C  
ATOM    284  O   PHE A  35      -9.611  35.099  53.236  1.00 58.83           O  
ATOM    285  CB  PHE A  35      -9.564  31.716  53.017  1.00 59.77           C  
ATOM    286  CG  PHE A  35     -10.171  32.001  51.648  1.00 57.73           C  
ATOM    287  CD1 PHE A  35      -9.454  31.736  50.484  1.00 59.24           C  
ATOM    288  CD2 PHE A  35     -11.480  32.463  51.525  1.00 58.95           C  
ATOM    289  CE1 PHE A  35     -10.005  31.960  49.218  1.00 53.94           C  
ATOM    290  CE2 PHE A  35     -12.044  32.682  50.266  1.00 51.43           C  
ATOM    291  CZ  PHE A  35     -11.296  32.421  49.103  1.00 54.84           C  
ATOM    292  N   TYR A  36     -10.741  33.874  54.766  1.00 57.37           N  
ATOM    293  CA  TYR A  36     -11.863  34.788  54.998  1.00 55.52           C  
ATOM    294  C   TYR A  36     -11.447  36.117  55.629  1.00 57.80           C  
ATOM    295  O   TYR A  36     -11.972  37.182  55.266  1.00 56.47           O  
ATOM    296  CB  TYR A  36     -13.007  34.055  55.742  1.00 54.82           C  
ATOM    297  CG  TYR A  36     -13.591  32.988  54.830  1.00 52.67           C  
ATOM    298  CD1 TYR A  36     -14.294  33.354  53.675  1.00 54.15           C  
ATOM    299  CD2 TYR A  36     -13.374  31.626  55.060  1.00 50.31           C  
ATOM    300  CE1 TYR A  36     -14.796  32.396  52.776  1.00 52.32           C  
ATOM    301  CE2 TYR A  36     -13.876  30.646  54.170  1.00 48.17           C  
ATOM    302  CZ  TYR A  36     -14.585  31.057  53.028  1.00 52.18           C  
ATOM    303  OH  TYR A  36     -15.086  30.156  52.132  1.00 47.53           O  
ATOM    304  N   LYS A  37     -10.469  36.056  56.527  1.00 59.38           N  
ATOM    305  CA  LYS A  37      -9.829  37.254  57.078  1.00 61.76           C  
ATOM    306  C   LYS A  37      -9.127  38.052  55.978  1.00 60.93           C  
ATOM    307  O   LYS A  37      -9.164  39.281  55.973  1.00 61.84           O  
ATOM    308  CB  LYS A  37      -8.810  36.850  58.142  1.00 63.84           C  
ATOM    309  CG  LYS A  37      -8.429  37.964  59.092  1.00 72.90           C  
ATOM    310  N   ASP A  38      -8.461  37.350  55.065  1.00 61.27           N  
ATOM    311  CA  ASP A  38      -7.736  38.008  53.970  1.00 62.93           C  
ATOM    312  C   ASP A  38      -8.670  38.653  52.942  1.00 61.20           C  
ATOM    313  O   ASP A  38      -8.369  39.722  52.403  1.00 63.15           O  
ATOM    314  CB  ASP A  38      -6.765  37.040  53.286  1.00 62.97           C  
ATOM    315  CG  ASP A  38      -5.449  36.863  54.061  1.00 70.34           C  
ATOM    316  OD1 ASP A  38      -5.170  37.611  55.034  1.00 70.52           O  
ATOM    317  OD2 ASP A  38      -4.684  35.952  53.687  1.00 71.75           O  
ATOM    318  N   VAL A  39      -9.806  38.016  52.681  1.00 59.71           N  
ATOM    319  CA  VAL A  39     -10.748  38.556  51.705  1.00 58.97           C  
ATOM    320  C   VAL A  39     -11.344  39.896  52.157  1.00 60.33           C  
ATOM    321  O   VAL A  39     -11.723  40.729  51.307  1.00 60.46           O  
ATOM    322  CB  VAL A  39     -11.868  37.548  51.297  1.00 57.82           C  
ATOM    323  CG1 VAL A  39     -11.276  36.252  50.786  1.00 58.89           C  
ATOM    324  CG2 VAL A  39     -12.785  37.270  52.428  1.00 59.77           C  
ATOM    325  N   LEU A  40     -11.411  40.104  53.481  1.00 58.21           N  
ATOM    326  CA  LEU A  40     -11.973  41.325  54.043  1.00 58.95           C  
ATOM    327  C   LEU A  40     -11.012  42.483  53.839  1.00 61.89           C  
ATOM    328  O   LEU A  40     -11.387  43.636  54.042  1.00 64.25           O  
ATOM    329  CB  LEU A  40     -12.325  41.165  55.541  1.00 60.08           C  
ATOM    330  CG  LEU A  40     -13.623  40.457  55.966  1.00 56.01           C  
ATOM    331  CD1 LEU A  40     -13.844  40.482  57.474  1.00 56.37           C  
ATOM    332  CD2 LEU A  40     -14.781  41.101  55.279  1.00 53.54           C  
ATOM    333  N   GLU A  41      -9.795  42.171  53.388  1.00 65.14           N  
ATOM    334  CA  GLU A  41      -8.723  43.159  53.266  1.00 67.91           C  
ATOM    335  C   GLU A  41      -8.253  43.462  51.841  1.00 66.60           C  
ATOM    336  O   GLU A  41      -7.444  44.372  51.648  1.00 68.07           O  
ATOM    337  CB  GLU A  41      -7.529  42.748  54.140  1.00 70.44           C  
ATOM    338  CG  GLU A  41      -7.861  42.654  55.638  1.00 76.17           C  
ATOM    339  CD  GLU A  41      -8.104  44.012  56.306  1.00 81.23           C  
ATOM    340  OE1 GLU A  41      -7.284  44.936  56.098  1.00 85.07           O  
ATOM    341  OE2 GLU A  41      -9.102  44.153  57.053  1.00 83.00           O  
ATOM    342  N   VAL A  42      -8.747  42.711  50.854  1.00 64.72           N  
ATOM    343  CA  VAL A  42      -8.359  42.923  49.460  1.00 62.77           C  
ATOM    344  C   VAL A  42      -9.272  43.872  48.719  1.00 60.35           C  
ATOM    345  O   VAL A  42      -9.108  44.039  47.509  1.00 60.85           O  
ATOM    346  CB  VAL A  42      -8.277  41.612  48.611  1.00 63.25           C  
ATOM    347  CG1 VAL A  42      -7.020  40.813  48.946  1.00 64.78           C  
ATOM    348  CG2 VAL A  42      -9.549  40.796  48.730  1.00 61.62           C  
ATOM    349  N   GLY A  43     -10.247  44.458  49.417  1.00 57.99           N  
ATOM    350  CA  GLY A  43     -11.149  45.439  48.807  1.00 55.66           C  
ATOM    351  C   GLY A  43     -11.848  44.901  47.568  1.00 54.73           C  
ATOM    352  O   GLY A  43     -12.419  43.816  47.611  1.00 53.82           O  
ATOM    353  N   GLU A  44     -11.779  45.643  46.457  1.00 53.84           N  
ATOM    354  CA  GLU A  44     -12.511  45.296  45.214  1.00 52.00           C  
ATOM    355  C   GLU A  44     -12.211  43.912  44.628  1.00 48.98           C  
ATOM    356  O   GLU A  44     -12.845  43.498  43.668  1.00 48.59           O  
ATOM    357  CB  GLU A  44     -12.310  46.371  44.127  1.00 52.90           C  
ATOM    358  CG  GLU A  44     -13.005  47.740  44.387  1.00 57.49           C  
ATOM    359  CD  GLU A  44     -14.543  47.684  44.472  1.00 63.72           C  
ATOM    360  OE1 GLU A  44     -15.182  46.789  43.867  1.00 64.03           O  
ATOM    361  OE2 GLU A  44     -15.115  48.566  45.153  1.00 64.95           O  
ATOM    362  N   LEU A  45     -11.220  43.226  45.184  1.00 49.91           N  
ATOM    363  CA  LEU A  45     -10.819  41.910  44.716  1.00 49.17           C  
ATOM    364  C   LEU A  45     -11.617  40.771  45.338  1.00 48.96           C  
ATOM    365  O   LEU A  45     -11.341  39.609  45.045  1.00 50.36           O  
ATOM    366  CB  LEU A  45      -9.305  41.679  44.886  1.00 51.97           C  
ATOM    367  CG  LEU A  45      -8.292  42.474  44.054  1.00 51.28           C  
ATOM    368  CD1 LEU A  45      -6.872  41.992  44.376  1.00 54.59           C  
ATOM    369  CD2 LEU A  45      -8.571  42.381  42.545  1.00 52.83           C  
ATOM    370  N   ALA A  46     -12.584  41.099  46.200  1.00 45.29           N  
ATOM    371  CA  ALA A  46     -13.560  40.130  46.677  1.00 43.06           C  
ATOM    372  C   ALA A  46     -14.933  40.759  46.558  1.00 42.45           C  
ATOM    373  O   ALA A  46     -15.138  41.901  46.986  1.00 45.19           O  
ATOM    374  CB  ALA A  46     -13.291  39.714  48.122  1.00 45.51           C  
ATOM    375  N   LYS A  47     -15.864  40.046  45.937  1.00 39.69           N  
ATOM    376  CA  LYS A  47     -17.213  40.545  45.736  1.00 38.78           C  
ATOM    377  C   LYS A  47     -18.191  39.426  45.941  1.00 38.45           C  
ATOM    378  O   LYS A  47     -17.890  38.276  45.620  1.00 39.29           O  
ATOM    379  CB  LYS A  47     -17.389  41.065  44.306  1.00 37.02           C  
ATOM    380  CG  LYS A  47     -16.572  42.284  43.949  1.00 41.19           C  
ATOM    381  CD  LYS A  47     -16.779  43.456  44.885  1.00 39.32           C  
ATOM    382  CE  LYS A  47     -17.871  44.354  44.417  1.00 40.43           C  
ATOM    383  NZ  LYS A  47     -17.695  45.749  44.969  1.00 47.00           N  
ATOM    384  N   LEU A  48     -19.372  39.782  46.445  1.00 39.30           N  
ATOM    385  CA  LEU A  48     -20.561  38.939  46.384  1.00 37.77           C  
ATOM    386  C   LEU A  48     -21.336  39.275  45.121  1.00 37.39           C  
ATOM    387  O   LEU A  48     -21.397  40.430  44.714  1.00 37.01           O  
ATOM    388  CB  LEU A  48     -21.459  39.201  47.596  1.00 35.39           C  
ATOM    389  CG  LEU A  48     -20.946  38.486  48.853  1.00 37.91           C  
ATOM    390  CD1 LEU A  48     -21.371  39.217  50.067  1.00 38.05           C  
ATOM    391  CD2 LEU A  48     -21.441  37.032  48.924  1.00 36.48           C  
ATOM    392  N   ALA A  49     -21.922  38.267  44.490  1.00 37.07           N  
ATOM    393  CA  ALA A  49     -22.757  38.507  43.307  1.00 38.11           C  
ATOM    394  C   ALA A  49     -24.195  38.245  43.687  1.00 38.50           C  
ATOM    395  O   ALA A  49     -24.525  37.253  44.357  1.00 34.15           O  
ATOM    396  CB  ALA A  49     -22.349  37.620  42.146  1.00 37.50           C  
ATOM    397  N   TYR A  50     -25.041  39.172  43.249  1.00 39.71           N  
ATOM    398  CA  TYR A  50     -26.462  39.135  43.520  1.00 38.64           C  
ATOM    399  C   TYR A  50     -27.245  38.988  42.215  1.00 40.78           C  
ATOM    400  O   TYR A  50     -26.907  39.636  41.193  1.00 38.83           O  
ATOM    401  CB  TYR A  50     -26.894  40.419  44.219  1.00 36.99           C  
ATOM    402  CG  TYR A  50     -26.204  40.618  45.551  1.00 40.95           C  
ATOM    403  CD1 TYR A  50     -26.768  40.119  46.711  1.00 33.36           C  
ATOM    404  CD2 TYR A  50     -24.973  41.261  45.629  1.00 34.15           C  
ATOM    405  CE1 TYR A  50     -26.128  40.286  47.957  1.00 39.56           C  
ATOM    406  CE2 TYR A  50     -24.324  41.435  46.842  1.00 38.34           C  
ATOM    407  CZ  TYR A  50     -24.910  40.935  48.008  1.00 35.71           C  
ATOM    408  OH  TYR A  50     -24.286  41.137  49.199  1.00 38.07           O  
ATOM    409  N   PHE A  51     -28.275  38.144  42.273  1.00 36.68           N  
ATOM    410  CA  PHE A  51     -29.279  38.009  41.216  1.00 38.29           C  
ATOM    411  C   PHE A  51     -30.654  38.311  41.839  1.00 40.90           C  
ATOM    412  O   PHE A  51     -31.065  37.636  42.788  1.00 38.09           O  
ATOM    413  CB  PHE A  51     -29.243  36.598  40.616  1.00 37.17           C  
ATOM    414  CG  PHE A  51     -30.322  36.345  39.595  1.00 40.60           C  
ATOM    415  CD1 PHE A  51     -30.067  36.542  38.233  1.00 40.29           C  
ATOM    416  CD2 PHE A  51     -31.605  35.960  39.999  1.00 38.72           C  
ATOM    417  CE1 PHE A  51     -31.099  36.324  37.289  1.00 42.95           C  
ATOM    418  CE2 PHE A  51     -32.649  35.754  39.066  1.00 36.04           C  
ATOM    419  CZ  PHE A  51     -32.409  35.915  37.738  1.00 37.47           C  
ATOM    420  N   ASN A  52     -31.338  39.335  41.314  1.00 42.93           N  
ATOM    421  CA  ASN A  52     -32.600  39.848  41.895  1.00 45.53           C  
ATOM    422  C   ASN A  52     -32.469  40.115  43.399  1.00 45.58           C  
ATOM    423  O   ASN A  52     -33.387  39.834  44.192  1.00 43.99           O  
ATOM    424  CB  ASN A  52     -33.798  38.919  41.619  1.00 45.22           C  
ATOM    425  CG  ASN A  52     -34.305  39.006  40.182  1.00 47.87           C  
ATOM    426  OD1 ASN A  52     -33.773  39.746  39.365  1.00 49.07           O  
ATOM    427  ND2 ASN A  52     -35.346  38.236  39.879  1.00 47.87           N  
ATOM    428  N   ASP A  53     -31.317  40.667  43.762  1.00 44.58           N  
ATOM    429  CA  ASP A  53     -30.978  41.017  45.146  1.00 45.74           C  
ATOM    430  C   ASP A  53     -30.757  39.819  46.051  1.00 44.17           C  
ATOM    431  O   ASP A  53     -30.675  40.004  47.254  1.00 43.52           O  
ATOM    432  CB  ASP A  53     -32.007  42.004  45.757  1.00 47.38           C  
ATOM    433  CG  ASP A  53     -32.183  43.254  44.902  1.00 52.84           C  
ATOM    434  OD1 ASP A  53     -31.174  43.956  44.651  1.00 55.80           O  
ATOM    435  OD2 ASP A  53     -33.318  43.510  44.427  1.00 59.41           O  
ATOM    436  N   ILE A  54     -30.607  38.621  45.467  1.00 44.03           N  
ATOM    437  CA  ILE A  54     -30.217  37.386  46.200  1.00 44.51           C  
ATOM    438  C   ILE A  54     -28.720  37.080  46.019  1.00 43.65           C  
ATOM    439  O   ILE A  54     -28.217  37.042  44.886  1.00 42.52           O  
ATOM    440  CB  ILE A  54     -31.053  36.150  45.760  1.00 44.96           C  
ATOM    441  CG1 ILE A  54     -32.560  36.489  45.757  1.00 50.49           C  
ATOM    442  CG2 ILE A  54     -30.781  34.894  46.697  1.00 44.02           C  
ATOM    443  CD1 ILE A  54     -33.447  35.398  45.158  1.00 51.07           C  
ATOM    444  N   ALA A  55     -28.006  36.902  47.135  1.00 43.03           N  
ATOM    445  CA  ALA A  55     -26.577  36.514  47.108  1.00 41.94           C  
ATOM    446  C   ALA A  55     -26.478  35.085  46.530  1.00 44.25           C  
ATOM    447  O   ALA A  55     -26.945  34.139  47.164  1.00 43.48           O  
ATOM    448  CB  ALA A  55     -25.976  36.568  48.542  1.00 43.00           C  
ATOM    449  N   VAL A  56     -25.929  34.926  45.318  1.00 40.37           N  
ATOM    450  CA  VAL A  56     -25.864  33.598  44.712  1.00 38.29           C  
ATOM    451  C   VAL A  56     -24.462  33.205  44.280  1.00 38.24           C  
ATOM    452  O   VAL A  56     -24.248  32.077  43.819  1.00 40.32           O  
ATOM    453  CB  VAL A  56     -26.833  33.435  43.497  1.00 40.03           C  
ATOM    454  CG1 VAL A  56     -28.286  33.455  43.972  1.00 41.48           C  
ATOM    455  CG2 VAL A  56     -26.619  34.527  42.504  1.00 35.09           C  
ATOM    456  N   GLY A  57     -23.502  34.112  44.428  1.00 36.50           N  
ATOM    457  CA  GLY A  57     -22.125  33.808  43.976  1.00 29.79           C  
ATOM    458  C   GLY A  57     -21.156  34.731  44.653  1.00 32.33           C  
ATOM    459  O   GLY A  57     -21.551  35.618  45.426  1.00 30.72           O  
ATOM    460  N   ALA A  58     -19.880  34.547  44.342  1.00 34.80           N  
ATOM    461  CA  ALA A  58     -18.835  35.363  44.908  1.00 37.40           C  
ATOM    462  C   ALA A  58     -17.589  35.156  44.091  1.00 36.69           C  
ATOM    463  O   ALA A  58     -17.386  34.085  43.522  1.00 35.55           O  
ATOM    464  CB  ALA A  58     -18.569  34.937  46.380  1.00 35.12           C  
ATOM    465  N   VAL A  59     -16.739  36.170  44.062  1.00 40.30           N  
ATOM    466  CA  VAL A  59     -15.402  36.014  43.484  1.00 38.96           C  
ATOM    467  C   VAL A  59     -14.376  36.477  44.533  1.00 40.71           C  
ATOM    468  O   VAL A  59     -14.593  37.494  45.160  1.00 39.28           O  
ATOM    469  CB  VAL A  59     -15.274  36.747  42.122  1.00 42.64           C  
ATOM    470  CG1 VAL A  59     -15.787  38.192  42.180  1.00 39.26           C  
ATOM    471  CG2 VAL A  59     -13.823  36.673  41.551  1.00 42.55           C  
ATOM    472  N   CYS A  60     -13.302  35.709  44.739  1.00 40.19           N  
ATOM    473  CA  CYS A  60     -12.190  36.085  45.639  1.00 44.26           C  
ATOM    474  C   CYS A  60     -10.828  35.905  44.947  1.00 42.31           C  
ATOM    475  O   CYS A  60     -10.525  34.831  44.441  1.00 42.43           O  
ATOM    476  CB  CYS A  60     -12.245  35.327  46.974  1.00 45.48           C  
ATOM    477  SG  CYS A  60     -13.847  35.417  47.833  1.00 49.70           S  
ATOM    478  N   CYS A  61     -10.050  36.989  44.886  1.00 43.40           N  
ATOM    479  CA  CYS A  61      -8.740  37.014  44.235  1.00 40.72           C  
ATOM    480  C   CYS A  61      -7.654  37.435  45.213  1.00 45.67           C  
ATOM    481  O   CYS A  61      -7.948  37.839  46.331  1.00 45.16           O  
ATOM    482  CB  CYS A  61      -8.744  38.018  43.089  1.00 42.77           C  
ATOM    483  SG  CYS A  61     -10.034  37.767  41.909  1.00 47.71           S  
ATOM    484  N   ARG A  62      -6.401  37.376  44.750  1.00 45.04           N  
ATOM    485  CA  ARG A  62      -5.225  37.786  45.506  1.00 50.91           C  
ATOM    486  C   ARG A  62      -4.199  38.357  44.508  1.00 50.53           C  
ATOM    487  O   ARG A  62      -4.175  37.959  43.341  1.00 48.39           O  
ATOM    488  CB  ARG A  62      -4.674  36.530  46.174  1.00 54.35           C  
ATOM    489  CG  ARG A  62      -3.461  36.668  47.006  1.00 63.54           C  
ATOM    490  CD  ARG A  62      -2.629  35.389  46.898  1.00 72.72           C  
ATOM    491  NE  ARG A  62      -3.338  34.165  47.277  1.00 74.73           N  
ATOM    492  CZ  ARG A  62      -2.899  32.938  46.992  1.00 80.25           C  
ATOM    493  NH1 ARG A  62      -3.590  31.864  47.365  1.00 80.25           N  
ATOM    494  NH2 ARG A  62      -1.760  32.778  46.322  1.00 82.31           N  
ATOM    495  N   VAL A  63      -3.358  39.285  44.946  1.00 52.98           N  
ATOM    496  CA  VAL A  63      -2.222  39.715  44.121  1.00 55.24           C  
ATOM    497  C   VAL A  63      -1.055  38.782  44.412  1.00 57.29           C  
ATOM    498  O   VAL A  63      -0.701  38.566  45.572  1.00 59.62           O  
ATOM    499  CB  VAL A  63      -1.812  41.225  44.344  1.00 56.81           C  
ATOM    500  CG1 VAL A  63      -0.531  41.561  43.601  1.00 52.87           C  
ATOM    501  CG2 VAL A  63      -2.922  42.170  43.895  1.00 56.15           C  
ATOM    502  N   ASP A  64      -0.466  38.252  43.342  1.00 58.70           N  
ATOM    503  CA  ASP A  64       0.588  37.241  43.402  1.00 62.23           C  
ATOM    504  C   ASP A  64       1.865  37.762  42.744  1.00 61.40           C  
ATOM    505  O   ASP A  64       1.834  38.208  41.605  1.00 60.85           O  
ATOM    506  CB  ASP A  64       0.093  36.022  42.622  1.00 64.31           C  
ATOM    507  CG  ASP A  64       0.567  34.719  43.188  1.00 71.51           C  
ATOM    508  OD1 ASP A  64      -0.246  34.067  43.890  1.00 76.62           O  
ATOM    509  OD2 ASP A  64       1.730  34.342  42.917  1.00 75.59           O  
ATOM    510  N   HIS A  65       2.984  37.707  43.454  1.00 66.21           N  
ATOM    511  CA  HIS A  65       4.292  38.009  42.855  1.00 67.91           C  
ATOM    512  C   HIS A  65       5.119  36.741  42.808  1.00 71.67           C  
ATOM    513  O   HIS A  65       5.802  36.382  43.766  1.00 77.57           O  
ATOM    514  CB  HIS A  65       5.047  39.120  43.605  1.00 69.20           C  
ATOM    515  CG  HIS A  65       4.303  40.417  43.672  1.00 67.81           C  
ATOM    516  ND1 HIS A  65       4.489  41.429  42.754  1.00 64.34           N  
ATOM    517  CD2 HIS A  65       3.369  40.865  44.548  1.00 66.56           C  
ATOM    518  CE1 HIS A  65       3.697  42.444  43.060  1.00 66.67           C  
ATOM    519  NE2 HIS A  65       3.012  42.129  44.146  1.00 67.37           N  
ATOM    520  N   SER A  66       5.015  36.045  41.686  1.00 73.48           N  
ATOM    521  CA  SER A  66       5.735  34.803  41.448  1.00 77.34           C  
ATOM    522  C   SER A  66       6.286  34.892  40.036  1.00 77.36           C  
ATOM    523  O   SER A  66       5.796  35.701  39.229  1.00 75.58           O  
ATOM    524  CB  SER A  66       4.802  33.594  41.597  1.00 79.13           C  
ATOM    525  OG  SER A  66       3.599  33.765  40.865  1.00 73.97           O  
ATOM    526  N   GLN A  67       7.307  34.086  39.746  1.00 80.10           N  
ATOM    527  CA  GLN A  67       7.931  34.045  38.419  1.00 80.69           C  
ATOM    528  C   GLN A  67       8.375  35.424  37.949  1.00 77.63           C  
ATOM    529  O   GLN A  67       8.426  35.678  36.747  1.00 79.57           O  
ATOM    530  CB  GLN A  67       6.971  33.459  37.372  1.00 81.20           C  
ATOM    531  CG  GLN A  67       6.268  32.179  37.764  1.00 84.54           C  
ATOM    532  CD  GLN A  67       5.285  31.732  36.704  1.00 86.00           C  
ATOM    533  OE1 GLN A  67       4.883  32.521  35.839  1.00 81.36           O  
ATOM    534  NE2 GLN A  67       4.893  30.462  36.758  1.00 88.63           N  
ATOM    535  N   ASN A  68       8.676  36.318  38.885  1.00 75.86           N  
ATOM    536  CA  ASN A  68       9.091  37.684  38.544  1.00 74.50           C  
ATOM    537  C   ASN A  68       8.070  38.521  37.806  1.00 71.57           C  
ATOM    538  O   ASN A  68       8.413  39.470  37.091  1.00 70.09           O  
ATOM    539  CB  ASN A  68      10.414  37.662  37.791  1.00 77.45           C  
ATOM    540  CG  ASN A  68      11.554  37.658  38.718  1.00 79.74           C  
ATOM    541  OD1 ASN A  68      12.054  36.596  39.097  1.00 82.99           O  
ATOM    542  ND2 ASN A  68      11.927  38.849  39.185  1.00 81.36           N  
ATOM    543  N   GLN A  69       6.808  38.163  38.012  1.00 68.79           N  
ATOM    544  CA  GLN A  69       5.700  38.871  37.430  1.00 67.23           C  
ATOM    545  C   GLN A  69       4.831  39.394  38.549  1.00 64.26           C  
ATOM    546  O   GLN A  69       4.954  38.949  39.686  1.00 64.47           O  
ATOM    547  CB  GLN A  69       4.889  37.934  36.533  1.00 67.81           C  
ATOM    548  CG  GLN A  69       5.665  37.411  35.326  1.00 71.36           C  
ATOM    549  CD  GLN A  69       5.013  36.210  34.682  1.00 73.68           C  
ATOM    550  OE1 GLN A  69       4.826  36.177  33.466  1.00 74.89           O  
ATOM    551  NE2 GLN A  69       4.652  35.217  35.491  1.00 74.77           N  
ATOM    552  N   LYS A  70       3.990  40.372  38.216  1.00 63.99           N  
ATOM    553  CA  LYS A  70       2.850  40.757  39.040  1.00 60.87           C  
ATOM    554  C   LYS A  70       1.607  40.097  38.428  1.00 58.63           C  
ATOM    555  O   LYS A  70       1.221  40.367  37.269  1.00 60.36           O  
ATOM    556  CB  LYS A  70       2.704  42.276  39.106  1.00 62.72           C  
ATOM    557  CG  LYS A  70       1.626  42.756  40.081  1.00 62.55           C  
ATOM    558  CD  LYS A  70       1.340  44.214  39.828  1.00 66.83           C  
ATOM    559  CE  LYS A  70       0.578  44.836  40.967  1.00 71.07           C  
ATOM    560  NZ  LYS A  70       1.033  46.250  41.166  1.00 77.58           N  
ATOM    561  N   ARG A  71       0.998  39.215  39.210  1.00 59.24           N  
ATOM    562  CA  ARG A  71      -0.088  38.392  38.729  1.00 54.79           C  
ATOM    563  C   ARG A  71      -1.366  38.576  39.547  1.00 52.06           C  
ATOM    564  O   ARG A  71      -1.316  38.804  40.761  1.00 51.64           O  
ATOM    565  CB  ARG A  71       0.370  36.933  38.731  1.00 54.90           C  
ATOM    566  CG  ARG A  71       1.741  36.727  38.052  1.00 53.08           C  
ATOM    567  CD  ARG A  71       2.241  35.307  38.183  1.00 55.15           C  
ATOM    568  NE  ARG A  71       1.673  34.413  37.164  1.00 60.23           N  
ATOM    569  CZ  ARG A  71       1.598  33.089  37.285  1.00 58.66           C  
ATOM    570  NH1 ARG A  71       2.030  32.488  38.395  1.00 53.59           N  
ATOM    571  NH2 ARG A  71       1.076  32.369  36.305  1.00 56.80           N  
ATOM    572  N   LEU A  72      -2.518  38.510  38.882  1.00 49.32           N  
ATOM    573  CA  LEU A  72      -3.791  38.360  39.625  1.00 47.42           C  
ATOM    574  C   LEU A  72      -4.219  36.894  39.682  1.00 45.50           C  
ATOM    575  O   LEU A  72      -4.423  36.256  38.650  1.00 44.56           O  
ATOM    576  CB  LEU A  72      -4.932  39.229  39.055  1.00 47.00           C  
ATOM    577  CG  LEU A  72      -6.151  39.285  40.007  1.00 43.40           C  
ATOM    578  CD1 LEU A  72      -5.784  40.075  41.283  1.00 44.83           C  
ATOM    579  CD2 LEU A  72      -7.338  39.919  39.379  1.00 47.36           C  
ATOM    580  N   TYR A  73      -4.341  36.368  40.894  1.00 46.14           N  
ATOM    581  CA  TYR A  73      -4.762  35.002  41.097  1.00 44.53           C  
ATOM    582  C   TYR A  73      -6.241  34.872  41.507  1.00 45.00           C  
ATOM    583  O   TYR A  73      -6.664  35.338  42.575  1.00 45.17           O  
ATOM    584  CB  TYR A  73      -3.875  34.347  42.135  1.00 46.96           C  
ATOM    585  CG  TYR A  73      -4.144  32.874  42.294  1.00 50.79           C  
ATOM    586  CD1 TYR A  73      -4.074  31.996  41.200  1.00 50.68           C  
ATOM    587  CD2 TYR A  73      -4.461  32.354  43.536  1.00 50.10           C  
ATOM    588  CE1 TYR A  73      -4.329  30.637  41.370  1.00 52.26           C  
ATOM    589  CE2 TYR A  73      -4.712  31.024  43.713  1.00 50.98           C  
ATOM    590  CZ  TYR A  73      -4.642  30.166  42.648  1.00 52.32           C  
ATOM    591  OH  TYR A  73      -4.915  28.834  42.887  1.00 56.05           O  
ATOM    592  N   ILE A  74      -7.029  34.190  40.679  1.00 43.83           N  
ATOM    593  CA  ILE A  74      -8.425  33.941  41.050  1.00 40.96           C  
ATOM    594  C   ILE A  74      -8.457  32.677  41.880  1.00 44.11           C  
ATOM    595  O   ILE A  74      -8.204  31.588  41.380  1.00 44.64           O  
ATOM    596  CB  ILE A  74      -9.320  33.820  39.808  1.00 40.05           C  
ATOM    597  CG1 ILE A  74      -9.160  35.090  38.937  1.00 37.19           C  
ATOM    598  CG2 ILE A  74     -10.808  33.610  40.170  1.00 35.84           C  
ATOM    599  CD1 ILE A  74      -9.824  34.932  37.587  1.00 40.08           C  
HETATM  600  N   MSE A  75      -8.753  32.833  43.158  1.00 43.76           N  
HETATM  601  CA  MSE A  75      -8.806  31.715  44.056  1.00 48.53           C  
HETATM  602  C   MSE A  75     -10.180  31.050  43.970  1.00 47.00           C  
HETATM  603  O   MSE A  75     -10.273  29.845  43.887  1.00 47.10           O  
HETATM  604  CB  MSE A  75      -8.523  32.192  45.481  1.00 50.58           C  
HETATM  605  CG  MSE A  75      -7.249  33.023  45.616  1.00 49.17           C  
HETATM  606 SE   MSE A  75      -6.975  33.292  47.529  1.00 66.88          SE  
HETATM  607  CE  MSE A  75      -8.309  34.707  47.798  1.00 61.41           C  
ATOM    608  N   THR A  76     -11.253  31.834  44.001  1.00 45.70           N  
ATOM    609  CA  THR A  76     -12.587  31.293  43.767  1.00 42.67           C  
ATOM    610  C   THR A  76     -13.428  32.259  42.974  1.00 42.86           C  
ATOM    611  O   THR A  76     -13.405  33.473  43.218  1.00 43.48           O  
ATOM    612  CB  THR A  76     -13.311  31.093  45.093  1.00 44.83           C  
ATOM    613  OG1 THR A  76     -13.358  32.344  45.752  1.00 46.80           O  
ATOM    614  CG2 THR A  76     -12.571  30.109  45.980  1.00 41.47           C  
ATOM    615  N   LEU A  77     -14.157  31.728  42.000  1.00 42.73           N  
ATOM    616  CA  LEU A  77     -15.146  32.505  41.242  1.00 41.59           C  
ATOM    617  C   LEU A  77     -16.236  31.548  40.835  1.00 39.80           C  
ATOM    618  O   LEU A  77     -15.966  30.578  40.177  1.00 40.59           O  
ATOM    619  CB  LEU A  77     -14.516  33.155  40.018  1.00 38.48           C  
ATOM    620  CG  LEU A  77     -15.336  34.116  39.146  1.00 38.23           C  
ATOM    621  CD1 LEU A  77     -14.418  35.019  38.263  1.00 36.04           C  
ATOM    622  CD2 LEU A  77     -16.253  33.316  38.244  1.00 36.99           C  
ATOM    623  N   GLY A  78     -17.467  31.790  41.248  1.00 41.03           N  
ATOM    624  CA  GLY A  78     -18.491  30.768  41.038  1.00 36.76           C  
ATOM    625  C   GLY A  78     -19.832  31.264  41.482  1.00 36.46           C  
ATOM    626  O   GLY A  78     -19.899  32.282  42.148  1.00 37.76           O  
ATOM    627  N   CYS A  79     -20.894  30.591  41.040  1.00 37.72           N  
ATOM    628  CA  CYS A  79     -22.239  30.785  41.583  1.00 39.24           C  
ATOM    629  C   CYS A  79     -23.007  29.469  41.699  1.00 37.76           C  
ATOM    630  O   CYS A  79     -22.595  28.439  41.164  1.00 37.17           O  
ATOM    631  CB  CYS A  79     -23.046  31.829  40.814  1.00 42.64           C  
ATOM    632  SG  CYS A  79     -23.573  31.375  39.146  1.00 44.65           S  
ATOM    633  N   LEU A  80     -24.087  29.531  42.471  1.00 39.77           N  
ATOM    634  CA  LEU A  80     -24.981  28.432  42.754  1.00 39.97           C  
ATOM    635  C   LEU A  80     -25.464  27.861  41.440  1.00 40.91           C  
ATOM    636  O   LEU A  80     -25.805  28.615  40.533  1.00 40.19           O  
ATOM    637  CB  LEU A  80     -26.173  28.968  43.571  1.00 39.21           C  
ATOM    638  CG  LEU A  80     -25.847  29.413  45.012  1.00 39.93           C  
ATOM    639  CD1 LEU A  80     -27.109  29.728  45.823  1.00 40.17           C  
ATOM    640  CD2 LEU A  80     -25.082  28.293  45.675  1.00 41.09           C  
ATOM    641  N   ALA A  81     -25.494  26.530  41.365  1.00 39.52           N  
ATOM    642  CA  ALA A  81     -25.865  25.784  40.163  1.00 41.81           C  
ATOM    643  C   ALA A  81     -27.157  26.198  39.446  1.00 42.59           C  
ATOM    644  O   ALA A  81     -27.136  26.358  38.223  1.00 41.31           O  
ATOM    645  CB  ALA A  81     -25.830  24.220  40.437  1.00 44.34           C  
ATOM    646  N   PRO A  82     -28.294  26.370  40.178  1.00 43.70           N  
ATOM    647  CA  PRO A  82     -29.498  26.797  39.443  1.00 42.59           C  
ATOM    648  C   PRO A  82     -29.406  28.183  38.770  1.00 42.97           C  
ATOM    649  O   PRO A  82     -30.235  28.499  37.918  1.00 46.53           O  
ATOM    650  CB  PRO A  82     -30.615  26.756  40.508  1.00 42.93           C  
ATOM    651  CG  PRO A  82     -29.922  26.752  41.806  1.00 45.81           C  
ATOM    652  CD  PRO A  82     -28.580  26.118  41.607  1.00 45.80           C  
ATOM    653  N   TYR A  83     -28.416  28.996  39.116  1.00 41.11           N  
ATOM    654  CA  TYR A  83     -28.307  30.345  38.543  1.00 42.07           C  
ATOM    655  C   TYR A  83     -27.205  30.457  37.441  1.00 42.66           C  
ATOM    656  O   TYR A  83     -26.832  31.578  37.007  1.00 41.40           O  
ATOM    657  CB  TYR A  83     -28.064  31.383  39.663  1.00 41.70           C  
ATOM    658  CG  TYR A  83     -29.205  31.460  40.648  1.00 41.25           C  
ATOM    659  CD1 TYR A  83     -30.305  32.243  40.398  1.00 39.05           C  
ATOM    660  CD2 TYR A  83     -29.203  30.695  41.801  1.00 41.95           C  
ATOM    661  CE1 TYR A  83     -31.381  32.301  41.298  1.00 44.74           C  
ATOM    662  CE2 TYR A  83     -30.284  30.734  42.707  1.00 41.92           C  
ATOM    663  CZ  TYR A  83     -31.361  31.529  42.442  1.00 41.97           C  
ATOM    664  OH  TYR A  83     -32.406  31.570  43.337  1.00 46.71           O  
ATOM    665  N   ARG A  84     -26.691  29.312  36.993  1.00 38.97           N  
ATOM    666  CA  ARG A  84     -25.600  29.351  36.048  1.00 39.32           C  
ATOM    667  C   ARG A  84     -26.148  29.645  34.643  1.00 40.09           C  
ATOM    668  O   ARG A  84     -27.335  29.461  34.394  1.00 38.72           O  
ATOM    669  CB  ARG A  84     -24.775  28.074  36.113  1.00 39.71           C  
ATOM    670  CG  ARG A  84     -23.888  28.017  37.359  1.00 38.90           C  
ATOM    671  CD  ARG A  84     -23.093  26.756  37.476  1.00 35.90           C  
ATOM    672  NE  ARG A  84     -22.640  26.650  38.861  1.00 40.61           N  
ATOM    673  CZ  ARG A  84     -22.194  25.534  39.423  1.00 48.39           C  
ATOM    674  NH1 ARG A  84     -22.097  24.423  38.688  1.00 44.26           N  
ATOM    675  NH2 ARG A  84     -21.838  25.530  40.728  1.00 42.71           N  
ATOM    676  N   ARG A  85     -25.274  30.136  33.761  1.00 39.51           N  
ATOM    677  CA  ARG A  85     -25.617  30.456  32.357  1.00 39.71           C  
ATOM    678  C   ARG A  85     -26.561  31.613  32.313  1.00 39.21           C  
ATOM    679  O   ARG A  85     -27.417  31.684  31.442  1.00 40.75           O  
ATOM    680  CB  ARG A  85     -26.209  29.257  31.610  1.00 44.40           C  
ATOM    681  CG  ARG A  85     -25.226  28.127  31.260  1.00 49.95           C  
ATOM    682  CD  ARG A  85     -23.894  28.635  30.669  1.00 54.48           C  
ATOM    683  NE  ARG A  85     -23.854  28.774  29.198  1.00 55.85           N  
ATOM    684  CZ  ARG A  85     -23.880  27.748  28.345  1.00 54.63           C  
ATOM    685  NH1 ARG A  85     -24.010  26.516  28.817  1.00 50.37           N  
ATOM    686  NH2 ARG A  85     -23.801  27.947  27.027  1.00 48.43           N  
ATOM    687  N   LEU A  86     -26.395  32.533  33.260  1.00 39.32           N  
ATOM    688  CA  LEU A  86     -27.227  33.724  33.309  1.00 40.39           C  
ATOM    689  C   LEU A  86     -26.384  34.998  33.236  1.00 39.74           C  
ATOM    690  O   LEU A  86     -26.893  36.105  33.304  1.00 39.25           O  
ATOM    691  CB  LEU A  86     -28.102  33.719  34.550  1.00 41.94           C  
ATOM    692  CG  LEU A  86     -29.292  32.762  34.604  1.00 43.04           C  
ATOM    693  CD1 LEU A  86     -29.940  32.925  35.967  1.00 36.26           C  
ATOM    694  CD2 LEU A  86     -30.276  33.091  33.465  1.00 43.18           C  
ATOM    695  N   GLY A  87     -25.089  34.824  33.054  1.00 41.01           N  
ATOM    696  CA  GLY A  87     -24.188  35.947  32.948  1.00 38.92           C  
ATOM    697  C   GLY A  87     -23.557  36.326  34.274  1.00 38.86           C  
ATOM    698  O   GLY A  87     -22.850  37.328  34.344  1.00 38.27           O  
ATOM    699  N   ILE A  88     -23.749  35.533  35.329  1.00 34.64           N  
ATOM    700  CA  ILE A  88     -23.231  35.992  36.602  1.00 34.74           C  
ATOM    701  C   ILE A  88     -21.731  35.814  36.602  1.00 37.11           C  
ATOM    702  O   ILE A  88     -21.031  36.645  37.120  1.00 39.73           O  
ATOM    703  CB  ILE A  88     -23.927  35.336  37.813  1.00 33.86           C  
ATOM    704  CG1 ILE A  88     -25.406  35.727  37.817  1.00 32.33           C  
ATOM    705  CG2 ILE A  88     -23.263  35.742  39.158  1.00 34.70           C  
ATOM    706  CD1 ILE A  88     -26.296  34.687  38.445  1.00 32.19           C  
ATOM    707  N   GLY A  89     -21.224  34.752  35.992  1.00 38.55           N  
ATOM    708  CA  GLY A  89     -19.775  34.526  35.980  1.00 38.23           C  
ATOM    709  C   GLY A  89     -19.084  35.647  35.240  1.00 40.05           C  
ATOM    710  O   GLY A  89     -18.081  36.196  35.708  1.00 40.98           O  
ATOM    711  N   THR A  90     -19.642  35.991  34.078  1.00 40.13           N  
ATOM    712  CA  THR A  90     -19.128  37.054  33.238  1.00 39.37           C  
ATOM    713  C   THR A  90     -19.031  38.385  33.987  1.00 37.76           C  
ATOM    714  O   THR A  90     -18.049  39.054  33.924  1.00 40.42           O  
ATOM    715  CB  THR A  90     -20.045  37.235  32.010  1.00 41.18           C  
ATOM    716  OG1 THR A  90     -20.096  36.004  31.282  1.00 40.07           O  
ATOM    717  CG2 THR A  90     -19.510  38.336  31.089  1.00 41.61           C  
ATOM    718  N   LYS A  91     -20.089  38.767  34.670  1.00 41.06           N  
ATOM    719  CA  LYS A  91     -20.078  39.948  35.515  1.00 42.96           C  
ATOM    720  C   LYS A  91     -18.932  39.926  36.530  1.00 41.92           C  
ATOM    721  O   LYS A  91     -18.234  40.917  36.675  1.00 42.29           O  
ATOM    722  CB  LYS A  91     -21.429  40.094  36.230  1.00 44.00           C  
ATOM    723  CG  LYS A  91     -21.614  41.445  36.926  1.00 46.51           C  
ATOM    724  CD  LYS A  91     -22.370  42.412  36.058  1.00 48.21           C  
ATOM    725  CE  LYS A  91     -23.023  43.516  36.868  1.00 50.87           C  
ATOM    726  NZ  LYS A  91     -24.328  43.923  36.198  1.00 55.72           N  
HETATM  727  N   MSE A  92     -18.727  38.802  37.200  1.00 35.72           N  
HETATM  728  CA  MSE A  92     -17.609  38.674  38.144  1.00 42.85           C  
HETATM  729  C   MSE A  92     -16.222  38.694  37.471  1.00 42.38           C  
HETATM  730  O   MSE A  92     -15.279  39.353  37.948  1.00 44.75           O  
HETATM  731  CB  MSE A  92     -17.788  37.405  38.988  1.00 40.31           C  
HETATM  732  CG  MSE A  92     -18.918  37.488  39.928  1.00 43.29           C  
HETATM  733 SE   MSE A  92     -19.078  35.816  40.991  1.00 48.29          SE  
HETATM  734  CE  MSE A  92     -19.739  34.593  39.691  1.00 29.44           C  
ATOM    735  N   LEU A  93     -16.092  38.037  36.325  1.00 42.54           N  
ATOM    736  CA  LEU A  93     -14.792  38.023  35.664  1.00 39.54           C  
ATOM    737  C   LEU A  93     -14.483  39.389  35.015  1.00 42.19           C  
ATOM    738  O   LEU A  93     -13.343  39.868  35.025  1.00 43.20           O  
ATOM    739  CB  LEU A  93     -14.680  36.864  34.660  1.00 40.02           C  
ATOM    740  CG  LEU A  93     -13.371  36.795  33.812  1.00 41.58           C  
ATOM    741  CD1 LEU A  93     -12.093  36.726  34.676  1.00 41.84           C  
ATOM    742  CD2 LEU A  93     -13.393  35.624  32.927  1.00 38.57           C  
ATOM    743  N   ASN A  94     -15.489  40.020  34.445  1.00 40.76           N  
ATOM    744  CA  ASN A  94     -15.304  41.364  33.938  1.00 43.10           C  
ATOM    745  C   ASN A  94     -14.951  42.343  35.054  1.00 45.29           C  
ATOM    746  O   ASN A  94     -14.141  43.250  34.849  1.00 48.58           O  
ATOM    747  CB  ASN A  94     -16.545  41.819  33.173  1.00 43.11           C  
ATOM    748  CG  ASN A  94     -16.577  41.293  31.728  1.00 46.56           C  
ATOM    749  OD1 ASN A  94     -15.554  40.949  31.159  1.00 45.12           O  
ATOM    750  ND2 ASN A  94     -17.765  41.250  31.138  1.00 49.19           N  
ATOM    751  N   HIS A  95     -15.557  42.194  36.234  1.00 41.60           N  
ATOM    752  CA  HIS A  95     -15.118  43.000  37.379  1.00 40.71           C  
ATOM    753  C   HIS A  95     -13.611  42.871  37.603  1.00 39.78           C  
ATOM    754  O   HIS A  95     -12.931  43.849  37.778  1.00 43.72           O  
ATOM    755  CB  HIS A  95     -15.879  42.644  38.652  1.00 42.13           C  
ATOM    756  CG  HIS A  95     -15.367  43.356  39.869  1.00 43.56           C  
ATOM    757  ND1 HIS A  95     -15.768  44.631  40.206  1.00 42.44           N  
ATOM    758  CD2 HIS A  95     -14.507  42.965  40.841  1.00 45.76           C  
ATOM    759  CE1 HIS A  95     -15.164  45.006  41.325  1.00 47.09           C  
ATOM    760  NE2 HIS A  95     -14.394  44.012  41.733  1.00 49.11           N  
ATOM    761  N   VAL A  96     -13.068  41.670  37.604  1.00 42.39           N  
ATOM    762  CA  VAL A  96     -11.635  41.534  37.882  1.00 46.16           C  
ATOM    763  C   VAL A  96     -10.746  41.979  36.707  1.00 45.20           C  
ATOM    764  O   VAL A  96      -9.779  42.684  36.899  1.00 48.73           O  
ATOM    765  CB  VAL A  96     -11.261  40.137  38.434  1.00 49.41           C  
ATOM    766  CG1 VAL A  96     -12.371  39.605  39.312  1.00 52.36           C  
ATOM    767  CG2 VAL A  96     -11.014  39.167  37.336  1.00 56.32           C  
ATOM    768  N   LEU A  97     -11.097  41.597  35.490  1.00 46.39           N  
ATOM    769  CA  LEU A  97     -10.405  42.092  34.313  1.00 49.61           C  
ATOM    770  C   LEU A  97     -10.382  43.624  34.248  1.00 50.03           C  
ATOM    771  O   LEU A  97      -9.412  44.202  33.773  1.00 51.85           O  
ATOM    772  CB  LEU A  97     -10.994  41.486  33.028  1.00 51.77           C  
ATOM    773  CG  LEU A  97     -10.906  39.952  32.867  1.00 52.64           C  
ATOM    774  CD1 LEU A  97     -11.709  39.472  31.656  1.00 54.73           C  
ATOM    775  CD2 LEU A  97      -9.470  39.486  32.740  1.00 53.61           C  
ATOM    776  N   ASN A  98     -11.431  44.277  34.735  1.00 50.85           N  
ATOM    777  CA  ASN A  98     -11.498  45.738  34.693  1.00 53.50           C  
ATOM    778  C   ASN A  98     -10.527  46.353  35.702  1.00 54.17           C  
ATOM    779  O   ASN A  98      -9.827  47.314  35.387  1.00 56.54           O  
ATOM    780  CB  ASN A  98     -12.932  46.263  34.890  1.00 56.55           C  
ATOM    781  CG  ASN A  98     -13.859  45.949  33.700  1.00 62.62           C  
ATOM    782  OD1 ASN A  98     -13.399  45.629  32.591  1.00 71.18           O  
ATOM    783  ND2 ASN A  98     -15.176  46.045  33.930  1.00 65.53           N  
ATOM    784  N   ILE A  99     -10.445  45.778  36.895  1.00 52.33           N  
ATOM    785  CA  ILE A  99      -9.439  46.218  37.869  1.00 55.39           C  
ATOM    786  C   ILE A  99      -8.005  46.165  37.327  1.00 56.23           C  
ATOM    787  O   ILE A  99      -7.253  47.120  37.459  1.00 57.29           O  
ATOM    788  CB  ILE A  99      -9.523  45.382  39.145  1.00 55.91           C  
ATOM    789  CG1 ILE A  99     -10.784  45.758  39.922  1.00 53.45           C  
ATOM    790  CG2 ILE A  99      -8.248  45.554  39.990  1.00 56.86           C  
ATOM    791  CD1 ILE A  99     -11.282  44.605  40.744  1.00 57.26           C  
ATOM    792  N   CYS A 100      -7.642  45.042  36.715  1.00 55.65           N  
ATOM    793  CA  CYS A 100      -6.313  44.849  36.140  1.00 57.12           C  
ATOM    794  C   CYS A 100      -6.013  45.856  35.043  1.00 61.09           C  
ATOM    795  O   CYS A 100      -4.858  46.243  34.847  1.00 61.98           O  
ATOM    796  CB  CYS A 100      -6.172  43.446  35.558  1.00 55.97           C  
ATOM    797  SG  CYS A 100      -6.315  42.127  36.747  1.00 55.76           S  
ATOM    798  N   GLU A 101      -7.058  46.255  34.325  1.00 64.24           N  
ATOM    799  CA  GLU A 101      -6.907  47.125  33.185  1.00 70.62           C  
ATOM    800  C   GLU A 101      -6.693  48.566  33.656  1.00 73.88           C  
ATOM    801  O   GLU A 101      -5.852  49.299  33.104  1.00 76.53           O  
ATOM    802  CB  GLU A 101      -8.116  46.993  32.261  1.00 73.34           C  
ATOM    803  CG  GLU A 101      -7.746  46.734  30.794  1.00 83.61           C  
ATOM    804  CD  GLU A 101      -7.668  48.007  29.943  1.00 95.25           C  
ATOM    805  OE1 GLU A 101      -8.620  48.820  30.020  1.00100.24           O  
ATOM    806  OE2 GLU A 101      -6.677  48.186  29.182  1.00 97.24           O  
ATOM    807  N   LYS A 102      -7.437  48.958  34.688  1.00 73.43           N  
ATOM    808  CA  LYS A 102      -7.267  50.273  35.315  1.00 77.52           C  
ATOM    809  C   LYS A 102      -5.917  50.391  36.040  1.00 76.84           C  
ATOM    810  O   LYS A 102      -5.295  51.444  36.028  1.00 80.69           O  
ATOM    811  CB  LYS A 102      -8.425  50.585  36.275  1.00 78.68           C  
ATOM    812  CG  LYS A 102      -9.800  50.689  35.613  1.00 80.97           C  
ATOM    813  N   ASP A 103      -5.472  49.304  36.660  1.00 73.20           N  
ATOM    814  CA  ASP A 103      -4.200  49.287  37.380  1.00 74.53           C  
ATOM    815  C   ASP A 103      -3.012  49.339  36.407  1.00 74.90           C  
ATOM    816  O   ASP A 103      -2.092  50.135  36.591  1.00 79.20           O  
ATOM    817  CB  ASP A 103      -4.133  48.072  38.316  1.00 72.08           C  
ATOM    818  CG  ASP A 103      -2.785  47.913  38.994  1.00 74.89           C  
ATOM    819  OD1 ASP A 103      -2.682  48.143  40.222  1.00 78.54           O  
ATOM    820  OD2 ASP A 103      -1.825  47.547  38.297  1.00 76.87           O  
ATOM    821  N   GLY A 104      -3.043  48.493  35.380  1.00 70.71           N  
ATOM    822  CA  GLY A 104      -2.093  48.574  34.276  1.00 69.38           C  
ATOM    823  C   GLY A 104      -0.745  47.923  34.513  1.00 67.70           C  
ATOM    824  O   GLY A 104       0.080  47.850  33.600  1.00 68.45           O  
ATOM    825  N   THR A 105      -0.513  47.428  35.722  1.00 65.47           N  
ATOM    826  CA  THR A 105       0.802  46.896  36.047  1.00 64.46           C  
ATOM    827  C   THR A 105       0.834  45.373  36.141  1.00 61.89           C  
ATOM    828  O   THR A 105       1.902  44.796  36.341  1.00 61.68           O  
ATOM    829  CB  THR A 105       1.393  47.527  37.334  1.00 66.47           C  
ATOM    830  OG1 THR A 105       0.672  47.063  38.479  1.00 67.60           O  
ATOM    831  CG2 THR A 105       1.362  49.075  37.272  1.00 68.42           C  
ATOM    832  N   PHE A 106      -0.317  44.729  35.961  1.00 57.67           N  
ATOM    833  CA  PHE A 106      -0.418  43.262  36.027  1.00 54.78           C  
ATOM    834  C   PHE A 106       0.115  42.567  34.759  1.00 56.12           C  
ATOM    835  O   PHE A 106      -0.216  42.954  33.621  1.00 58.67           O  
ATOM    836  CB  PHE A 106      -1.872  42.847  36.278  1.00 51.15           C  
ATOM    837  CG  PHE A 106      -2.307  42.979  37.731  1.00 51.05           C  
ATOM    838  CD1 PHE A 106      -2.111  41.937  38.627  1.00 50.45           C  
ATOM    839  CD2 PHE A 106      -2.916  44.132  38.185  1.00 48.42           C  
ATOM    840  CE1 PHE A 106      -2.515  42.048  39.961  1.00 49.09           C  
ATOM    841  CE2 PHE A 106      -3.320  44.253  39.495  1.00 51.76           C  
ATOM    842  CZ  PHE A 106      -3.110  43.205  40.389  1.00 50.71           C  
ATOM    843  N   ASP A 107       0.917  41.524  34.951  1.00 54.74           N  
ATOM    844  CA  ASP A 107       1.446  40.765  33.822  1.00 56.90           C  
ATOM    845  C   ASP A 107       0.442  39.759  33.251  1.00 54.09           C  
ATOM    846  O   ASP A 107       0.346  39.548  32.033  1.00 55.17           O  
ATOM    847  CB  ASP A 107       2.753  40.071  34.221  1.00 59.48           C  
ATOM    848  CG  ASP A 107       3.892  41.058  34.444  1.00 65.12           C  
ATOM    849  OD1 ASP A 107       4.279  41.777  33.485  1.00 70.48           O  
ATOM    850  OD2 ASP A 107       4.404  41.113  35.585  1.00 67.06           O  
ATOM    851  N   ASN A 108      -0.286  39.119  34.148  1.00 50.23           N  
ATOM    852  CA  ASN A 108      -1.276  38.132  33.781  1.00 49.91           C  
ATOM    853  C   ASN A 108      -2.284  37.870  34.903  1.00 47.72           C  
ATOM    854  O   ASN A 108      -2.198  38.436  35.989  1.00 48.47           O  
ATOM    855  CB  ASN A 108      -0.622  36.826  33.280  1.00 50.96           C  
ATOM    856  CG  ASN A 108       0.355  36.208  34.280  1.00 54.33           C  
ATOM    857  OD1 ASN A 108      -0.033  35.725  35.338  1.00 50.31           O  
ATOM    858  ND2 ASN A 108       1.635  36.182  33.913  1.00 57.42           N  
ATOM    859  N   ILE A 109      -3.273  37.062  34.583  1.00 46.89           N  
ATOM    860  CA  ILE A 109      -4.218  36.571  35.545  1.00 45.53           C  
ATOM    861  C   ILE A 109      -4.330  35.085  35.300  1.00 44.33           C  
ATOM    862  O   ILE A 109      -4.293  34.637  34.168  1.00 44.77           O  
ATOM    863  CB  ILE A 109      -5.564  37.306  35.444  1.00 45.94           C  
ATOM    864  CG1 ILE A 109      -6.645  36.563  36.224  1.00 49.06           C  
ATOM    865  CG2 ILE A 109      -5.952  37.558  34.026  1.00 51.44           C  
ATOM    866  CD1 ILE A 109      -7.597  37.499  36.868  1.00 55.53           C  
ATOM    867  N   TYR A 110      -4.405  34.312  36.371  1.00 44.14           N  
ATOM    868  CA  TYR A 110      -4.420  32.866  36.254  1.00 43.63           C  
ATOM    869  C   TYR A 110      -5.215  32.264  37.410  1.00 43.43           C  
ATOM    870  O   TYR A 110      -5.569  32.969  38.345  1.00 41.33           O  
ATOM    871  CB  TYR A 110      -2.982  32.311  36.219  1.00 45.16           C  
ATOM    872  CG  TYR A 110      -2.246  32.326  37.544  1.00 46.21           C  
ATOM    873  CD1 TYR A 110      -2.000  31.130  38.235  1.00 48.75           C  
ATOM    874  CD2 TYR A 110      -1.804  33.522  38.116  1.00 47.16           C  
ATOM    875  CE1 TYR A 110      -1.337  31.121  39.445  1.00 48.08           C  
ATOM    876  CE2 TYR A 110      -1.123  33.523  39.351  1.00 43.52           C  
ATOM    877  CZ  TYR A 110      -0.893  32.311  39.999  1.00 50.00           C  
ATOM    878  OH  TYR A 110      -0.235  32.277  41.214  1.00 52.38           O  
ATOM    879  N   LEU A 111      -5.483  30.956  37.310  1.00 44.46           N  
ATOM    880  CA  LEU A 111      -6.233  30.184  38.296  1.00 42.69           C  
ATOM    881  C   LEU A 111      -6.009  28.697  38.046  1.00 44.87           C  
ATOM    882  O   LEU A 111      -5.420  28.317  37.029  1.00 44.43           O  
ATOM    883  CB  LEU A 111      -7.733  30.499  38.203  1.00 43.95           C  
ATOM    884  CG  LEU A 111      -8.537  29.933  37.011  1.00 43.57           C  
ATOM    885  CD1 LEU A 111      -9.900  29.499  37.492  1.00 45.57           C  
ATOM    886  CD2 LEU A 111      -8.660  30.926  35.918  1.00 44.79           C  
ATOM    887  N   HIS A 112      -6.487  27.862  38.975  1.00 46.30           N  
ATOM    888  CA  HIS A 112      -6.443  26.405  38.838  1.00 45.76           C  
ATOM    889  C   HIS A 112      -7.845  25.843  38.670  1.00 47.01           C  
ATOM    890  O   HIS A 112      -8.773  26.214  39.406  1.00 45.94           O  
ATOM    891  CB  HIS A 112      -5.755  25.754  40.045  1.00 46.82           C  
ATOM    892  CG  HIS A 112      -4.298  26.069  40.139  1.00 52.13           C  
ATOM    893  ND1 HIS A 112      -3.326  25.289  39.552  1.00 57.99           N  
ATOM    894  CD2 HIS A 112      -3.645  27.095  40.734  1.00 57.40           C  
ATOM    895  CE1 HIS A 112      -2.136  25.815  39.788  1.00 61.39           C  
ATOM    896  NE2 HIS A 112      -2.301  26.914  40.501  1.00 61.18           N  
ATOM    897  N   VAL A 113      -7.979  24.951  37.693  1.00 45.26           N  
ATOM    898  CA  VAL A 113      -9.220  24.270  37.403  1.00 49.10           C  
ATOM    899  C   VAL A 113      -8.973  22.759  37.400  1.00 50.89           C  
ATOM    900  O   VAL A 113      -8.125  22.262  36.650  1.00 53.68           O  
ATOM    901  CB  VAL A 113      -9.753  24.716  36.040  1.00 49.10           C  
ATOM    902  CG1 VAL A 113     -10.721  23.727  35.435  1.00 53.72           C  
ATOM    903  CG2 VAL A 113     -10.418  26.071  36.160  1.00 54.21           C  
ATOM    904  N   GLN A 114      -9.709  22.037  38.235  1.00 48.06           N  
ATOM    905  CA  GLN A 114      -9.720  20.575  38.198  1.00 51.55           C  
ATOM    906  C   GLN A 114      -9.889  20.106  36.752  1.00 50.68           C  
ATOM    907  O   GLN A 114     -10.753  20.609  36.048  1.00 53.20           O  
ATOM    908  CB  GLN A 114     -10.915  20.094  39.010  1.00 49.66           C  
ATOM    909  CG  GLN A 114     -10.630  18.910  39.888  1.00 55.40           C  
ATOM    910  CD  GLN A 114     -11.839  18.500  40.736  1.00 58.69           C  
ATOM    911  OE1 GLN A 114     -12.733  19.312  41.017  1.00 59.48           O  
ATOM    912  NE2 GLN A 114     -11.857  17.229  41.159  1.00 62.25           N  
ATOM    913  N   ILE A 115      -9.111  19.138  36.286  1.00 50.86           N  
ATOM    914  CA  ILE A 115      -9.216  18.769  34.851  1.00 49.27           C  
ATOM    915  C   ILE A 115     -10.632  18.373  34.389  1.00 51.17           C  
ATOM    916  O   ILE A 115     -10.931  18.386  33.183  1.00 50.26           O  
ATOM    917  CB  ILE A 115      -8.198  17.697  34.404  1.00 49.13           C  
ATOM    918  CG1 ILE A 115      -8.463  16.359  35.137  1.00 48.32           C  
ATOM    919  CG2 ILE A 115      -6.788  18.243  34.537  1.00 44.77           C  
ATOM    920  CD1 ILE A 115      -7.743  15.142  34.554  1.00 47.89           C  
ATOM    921  N   SER A 116     -11.506  18.046  35.337  1.00 51.51           N  
ATOM    922  CA  SER A 116     -12.845  17.540  34.984  1.00 52.08           C  
ATOM    923  C   SER A 116     -13.860  18.654  34.758  1.00 50.30           C  
ATOM    924  O   SER A 116     -14.956  18.412  34.245  1.00 50.99           O  
ATOM    925  CB  SER A 116     -13.348  16.604  36.077  1.00 52.86           C  
ATOM    926  OG  SER A 116     -13.267  17.283  37.304  1.00 55.72           O  
ATOM    927  N   ASN A 117     -13.481  19.869  35.151  1.00 50.02           N  
ATOM    928  CA  ASN A 117     -14.346  21.038  35.107  1.00 48.04           C  
ATOM    929  C   ASN A 117     -14.462  21.588  33.699  1.00 48.67           C  
ATOM    930  O   ASN A 117     -13.949  22.677  33.395  1.00 43.62           O  
ATOM    931  CB  ASN A 117     -13.807  22.134  36.033  1.00 48.02           C  
ATOM    932  CG  ASN A 117     -14.900  23.061  36.542  1.00 51.32           C  
ATOM    933  OD1 ASN A 117     -15.919  23.282  35.874  1.00 47.76           O  
ATOM    934  ND2 ASN A 117     -14.692  23.607  37.744  1.00 48.58           N  
ATOM    935  N   GLU A 118     -15.169  20.844  32.856  1.00 47.98           N  
ATOM    936  CA  GLU A 118     -15.338  21.201  31.465  1.00 49.99           C  
ATOM    937  C   GLU A 118     -15.963  22.583  31.292  1.00 47.73           C  
ATOM    938  O   GLU A 118     -15.492  23.384  30.514  1.00 48.15           O  
ATOM    939  CB  GLU A 118     -16.124  20.104  30.760  1.00 50.86           C  
ATOM    940  CG  GLU A 118     -15.333  18.793  30.728  1.00 55.31           C  
ATOM    941  CD  GLU A 118     -15.885  17.745  29.758  1.00 62.79           C  
ATOM    942  OE1 GLU A 118     -16.751  18.060  28.914  1.00 71.12           O  
ATOM    943  OE2 GLU A 118     -15.428  16.586  29.833  1.00 67.99           O  
ATOM    944  N   SER A 119     -16.997  22.857  32.071  1.00 48.97           N  
ATOM    945  CA  SER A 119     -17.728  24.089  31.974  1.00 47.11           C  
ATOM    946  C   SER A 119     -16.865  25.305  32.376  1.00 46.26           C  
ATOM    947  O   SER A 119     -16.928  26.364  31.729  1.00 45.59           O  
ATOM    948  CB  SER A 119     -19.016  23.980  32.789  1.00 51.42           C  
ATOM    949  OG  SER A 119     -18.850  24.412  34.118  1.00 50.62           O  
ATOM    950  N   ALA A 120     -16.036  25.142  33.407  1.00 42.32           N  
ATOM    951  CA  ALA A 120     -15.093  26.183  33.785  1.00 42.43           C  
ATOM    952  C   ALA A 120     -14.053  26.452  32.693  1.00 41.96           C  
ATOM    953  O   ALA A 120     -13.752  27.596  32.439  1.00 39.68           O  
ATOM    954  CB  ALA A 120     -14.394  25.866  35.103  1.00 40.84           C  
ATOM    955  N   ILE A 121     -13.500  25.405  32.084  1.00 42.83           N  
ATOM    956  CA  ILE A 121     -12.558  25.567  30.944  1.00 46.42           C  
ATOM    957  C   ILE A 121     -13.195  26.324  29.774  1.00 45.41           C  
ATOM    958  O   ILE A 121     -12.602  27.274  29.231  1.00 49.19           O  
ATOM    959  CB  ILE A 121     -12.008  24.198  30.458  1.00 46.24           C  
ATOM    960  CG1 ILE A 121     -11.234  23.485  31.571  1.00 47.87           C  
ATOM    961  CG2 ILE A 121     -11.130  24.354  29.233  1.00 46.53           C  
ATOM    962  CD1 ILE A 121     -11.076  21.939  31.349  1.00 46.43           C  
ATOM    963  N   ASP A 122     -14.386  25.883  29.367  1.00 45.43           N  
ATOM    964  CA  ASP A 122     -15.200  26.592  28.373  1.00 44.40           C  
ATOM    965  C   ASP A 122     -15.396  28.074  28.704  1.00 44.82           C  
ATOM    966  O   ASP A 122     -15.191  28.934  27.850  1.00 44.73           O  
ATOM    967  CB  ASP A 122     -16.580  25.968  28.303  1.00 46.58           C  
ATOM    968  CG  ASP A 122     -16.709  24.919  27.219  1.00 55.21           C  
ATOM    969  OD1 ASP A 122     -16.041  25.044  26.151  1.00 58.07           O  
ATOM    970  OD2 ASP A 122     -17.551  24.004  27.424  1.00 60.43           O  
ATOM    971  N   PHE A 123     -15.826  28.354  29.941  1.00 42.16           N  
ATOM    972  CA  PHE A 123     -16.014  29.724  30.434  1.00 41.41           C  
ATOM    973  C   PHE A 123     -14.733  30.577  30.296  1.00 40.15           C  
ATOM    974  O   PHE A 123     -14.716  31.637  29.648  1.00 43.76           O  
ATOM    975  CB  PHE A 123     -16.462  29.661  31.909  1.00 38.78           C  
ATOM    976  CG  PHE A 123     -16.532  31.011  32.589  1.00 37.54           C  
ATOM    977  CD1 PHE A 123     -17.560  31.895  32.304  1.00 34.55           C  
ATOM    978  CD2 PHE A 123     -15.573  31.390  33.497  1.00 33.60           C  
ATOM    979  CE1 PHE A 123     -17.623  33.126  32.903  1.00 36.55           C  
ATOM    980  CE2 PHE A 123     -15.635  32.631  34.124  1.00 37.57           C  
ATOM    981  CZ  PHE A 123     -16.664  33.502  33.812  1.00 37.20           C  
ATOM    982  N   TYR A 124     -13.644  30.109  30.888  1.00 40.11           N  
ATOM    983  CA  TYR A 124     -12.429  30.918  30.882  1.00 42.83           C  
ATOM    984  C   TYR A 124     -11.810  31.039  29.511  1.00 40.11           C  
ATOM    985  O   TYR A 124     -11.193  32.061  29.189  1.00 47.19           O  
ATOM    986  CB  TYR A 124     -11.411  30.393  31.878  1.00 42.33           C  
ATOM    987  CG  TYR A 124     -11.771  30.775  33.271  1.00 42.82           C  
ATOM    988  CD1 TYR A 124     -11.611  32.073  33.718  1.00 42.79           C  
ATOM    989  CD2 TYR A 124     -12.289  29.831  34.145  1.00 38.44           C  
ATOM    990  CE1 TYR A 124     -11.966  32.433  35.047  1.00 39.75           C  
ATOM    991  CE2 TYR A 124     -12.645  30.174  35.466  1.00 43.67           C  
ATOM    992  CZ  TYR A 124     -12.478  31.475  35.897  1.00 44.72           C  
ATOM    993  OH  TYR A 124     -12.835  31.812  37.173  1.00 43.46           O  
ATOM    994  N   ARG A 125     -11.942  30.014  28.687  1.00 38.52           N  
ATOM    995  CA  ARG A 125     -11.335  30.122  27.323  1.00 40.84           C  
ATOM    996  C   ARG A 125     -12.036  31.153  26.444  1.00 41.56           C  
ATOM    997  O   ARG A 125     -11.408  31.813  25.577  1.00 45.13           O  
ATOM    998  CB  ARG A 125     -11.251  28.769  26.632  1.00 38.56           C  
ATOM    999  CG  ARG A 125     -10.099  27.916  27.172  1.00 42.23           C  
ATOM   1000  CD  ARG A 125      -9.197  27.476  26.024  1.00 51.54           C  
ATOM   1001  NE  ARG A 125      -9.785  26.361  25.329  1.00 52.31           N  
ATOM   1002  CZ  ARG A 125      -9.686  26.126  24.023  1.00 47.57           C  
ATOM   1003  NH1 ARG A 125     -10.256  25.053  23.536  1.00 46.31           N  
ATOM   1004  NH2 ARG A 125      -9.036  26.936  23.213  1.00 44.24           N  
ATOM   1005  N   LYS A 126     -13.339  31.294  26.672  1.00 43.66           N  
ATOM   1006  CA  LYS A 126     -14.149  32.311  26.024  1.00 45.07           C  
ATOM   1007  C   LYS A 126     -13.566  33.700  26.251  1.00 45.21           C  
ATOM   1008  O   LYS A 126     -13.586  34.525  25.350  1.00 47.98           O  
ATOM   1009  CB  LYS A 126     -15.596  32.208  26.493  1.00 46.76           C  
ATOM   1010  CG  LYS A 126     -16.473  33.348  26.025  1.00 55.61           C  
ATOM   1011  CD  LYS A 126     -17.957  33.005  25.996  1.00 66.39           C  
ATOM   1012  CE  LYS A 126     -18.489  32.890  24.536  1.00 75.61           C  
ATOM   1013  NZ  LYS A 126     -17.998  31.660  23.790  1.00 75.83           N  
ATOM   1014  N   PHE A 127     -12.967  33.936  27.416  1.00 42.66           N  
ATOM   1015  CA  PHE A 127     -12.362  35.233  27.722  1.00 44.37           C  
ATOM   1016  C   PHE A 127     -10.887  35.316  27.360  1.00 44.20           C  
ATOM   1017  O   PHE A 127     -10.227  36.240  27.775  1.00 45.44           O  
ATOM   1018  CB  PHE A 127     -12.509  35.582  29.203  1.00 42.22           C  
ATOM   1019  CG  PHE A 127     -13.939  35.861  29.624  1.00 45.73           C  
ATOM   1020  CD1 PHE A 127     -14.393  37.167  29.767  1.00 44.02           C  
ATOM   1021  CD2 PHE A 127     -14.831  34.809  29.860  1.00 41.38           C  
ATOM   1022  CE1 PHE A 127     -15.710  37.426  30.144  1.00 48.85           C  
ATOM   1023  CE2 PHE A 127     -16.161  35.063  30.241  1.00 42.18           C  
ATOM   1024  CZ  PHE A 127     -16.595  36.353  30.385  1.00 48.45           C  
ATOM   1025  N   GLY A 128     -10.351  34.336  26.649  1.00 43.46           N  
ATOM   1026  CA  GLY A 128      -8.933  34.380  26.317  1.00 46.46           C  
ATOM   1027  C   GLY A 128      -7.958  33.777  27.307  1.00 45.16           C  
ATOM   1028  O   GLY A 128      -6.749  33.979  27.159  1.00 49.38           O  
ATOM   1029  N   PHE A 129      -8.458  33.034  28.302  1.00 45.25           N  
ATOM   1030  CA  PHE A 129      -7.592  32.207  29.170  1.00 42.56           C  
ATOM   1031  C   PHE A 129      -7.131  31.002  28.355  1.00 44.39           C  
ATOM   1032  O   PHE A 129      -7.837  30.577  27.457  1.00 47.32           O  
ATOM   1033  CB  PHE A 129      -8.337  31.766  30.434  1.00 39.44           C  
ATOM   1034  CG  PHE A 129      -8.473  32.853  31.489  1.00 39.39           C  
ATOM   1035  CD1 PHE A 129      -7.725  32.800  32.656  1.00 36.57           C  
ATOM   1036  CD2 PHE A 129      -9.336  33.938  31.293  1.00 37.83           C  
ATOM   1037  CE1 PHE A 129      -7.838  33.820  33.635  1.00 37.45           C  
ATOM   1038  CE2 PHE A 129      -9.477  34.943  32.246  1.00 40.05           C  
ATOM   1039  CZ  PHE A 129      -8.729  34.891  33.425  1.00 39.22           C  
ATOM   1040  N   GLU A 130      -5.932  30.490  28.623  1.00 45.52           N  
ATOM   1041  CA  GLU A 130      -5.386  29.347  27.893  1.00 45.97           C  
ATOM   1042  C   GLU A 130      -4.924  28.344  28.928  1.00 42.31           C  
ATOM   1043  O   GLU A 130      -4.385  28.750  29.935  1.00 44.57           O  
ATOM   1044  CB  GLU A 130      -4.138  29.768  27.117  1.00 48.84           C  
ATOM   1045  CG  GLU A 130      -4.327  30.528  25.793  1.00 56.25           C  
ATOM   1046  CD  GLU A 130      -2.966  31.119  25.264  1.00 64.54           C  
ATOM   1047  OE1 GLU A 130      -2.240  31.810  26.038  1.00 71.79           O  
ATOM   1048  OE2 GLU A 130      -2.615  30.891  24.071  1.00 75.17           O  
ATOM   1049  N   ILE A 131      -5.088  27.051  28.690  1.00 39.72           N  
ATOM   1050  CA  ILE A 131      -4.383  26.062  29.489  1.00 42.17           C  
ATOM   1051  C   ILE A 131      -2.876  26.160  29.237  1.00 46.11           C  
ATOM   1052  O   ILE A 131      -2.402  25.901  28.132  1.00 46.29           O  
ATOM   1053  CB  ILE A 131      -4.863  24.618  29.224  1.00 43.33           C  
ATOM   1054  CG1 ILE A 131      -6.347  24.465  29.588  1.00 41.07           C  
ATOM   1055  CG2 ILE A 131      -4.020  23.630  30.054  1.00 45.77           C  
ATOM   1056  CD1 ILE A 131      -7.094  23.323  28.828  1.00 42.71           C  
ATOM   1057  N   ILE A 132      -2.113  26.539  30.267  1.00 46.54           N  
ATOM   1058  CA  ILE A 132      -0.667  26.703  30.091  1.00 47.30           C  
ATOM   1059  C   ILE A 132       0.116  25.586  30.789  1.00 50.53           C  
ATOM   1060  O   ILE A 132       1.335  25.520  30.691  1.00 52.97           O  
ATOM   1061  CB  ILE A 132      -0.204  28.086  30.556  1.00 48.14           C  
ATOM   1062  CG1 ILE A 132      -0.627  28.333  32.017  1.00 43.93           C  
ATOM   1063  CG2 ILE A 132      -0.806  29.164  29.619  1.00 46.23           C  
ATOM   1064  CD1 ILE A 132       0.327  29.214  32.802  1.00 44.38           C  
ATOM   1065  N   GLU A 133      -0.598  24.693  31.469  1.00 47.07           N  
ATOM   1066  CA  GLU A 133       0.019  23.668  32.266  1.00 52.16           C  
ATOM   1067  C   GLU A 133      -1.073  22.785  32.834  1.00 50.95           C  
ATOM   1068  O   GLU A 133      -2.194  23.247  33.064  1.00 49.47           O  
ATOM   1069  CB  GLU A 133       0.799  24.300  33.421  1.00 53.57           C  
ATOM   1070  CG  GLU A 133       1.435  23.266  34.368  1.00 60.90           C  
ATOM   1071  CD  GLU A 133       2.426  23.856  35.354  1.00 63.17           C  
ATOM   1072  OE1 GLU A 133       2.165  24.960  35.892  1.00 68.85           O  
ATOM   1073  OE2 GLU A 133       3.464  23.199  35.601  1.00 71.00           O  
ATOM   1074  N   THR A 134      -0.750  21.507  33.021  1.00 53.27           N  
ATOM   1075  CA  THR A 134      -1.564  20.591  33.805  1.00 53.77           C  
ATOM   1076  C   THR A 134      -0.651  20.117  34.921  1.00 54.87           C  
ATOM   1077  O   THR A 134       0.391  19.530  34.668  1.00 55.74           O  
ATOM   1078  CB  THR A 134      -2.114  19.421  32.971  1.00 53.97           C  
ATOM   1079  OG1 THR A 134      -2.817  19.942  31.837  1.00 57.39           O  
ATOM   1080  CG2 THR A 134      -3.082  18.574  33.774  1.00 54.15           C  
ATOM   1081  N   LYS A 135      -1.011  20.451  36.151  1.00 56.05           N  
ATOM   1082  CA  LYS A 135      -0.201  20.080  37.293  1.00 58.89           C  
ATOM   1083  C   LYS A 135      -0.774  18.781  37.805  1.00 60.28           C  
ATOM   1084  O   LYS A 135      -1.962  18.706  38.130  1.00 58.55           O  
ATOM   1085  CB  LYS A 135      -0.257  21.150  38.382  1.00 59.96           C  
ATOM   1086  CG  LYS A 135       0.473  22.462  38.064  1.00 61.20           C  
ATOM   1087  CD  LYS A 135       0.699  23.275  39.360  1.00 63.98           C  
ATOM   1088  CE  LYS A 135       1.115  24.750  39.112  1.00 68.03           C  
ATOM   1089  NZ  LYS A 135       2.508  24.925  38.527  1.00 75.26           N  
ATOM   1090  N   LYS A 136       0.051  17.739  37.837  1.00 63.57           N  
ATOM   1091  CA  LYS A 136      -0.385  16.452  38.371  1.00 64.67           C  
ATOM   1092  C   LYS A 136      -0.464  16.505  39.906  1.00 63.77           C  
ATOM   1093  O   LYS A 136       0.401  17.066  40.574  1.00 65.15           O  
ATOM   1094  CB  LYS A 136       0.505  15.299  37.849  1.00 69.36           C  
ATOM   1095  CG  LYS A 136       0.096  14.725  36.468  1.00 68.35           C  
ATOM   1096  CD  LYS A 136       1.328  14.314  35.645  1.00 75.48           C  
ATOM   1097  CE  LYS A 136       1.022  13.302  34.523  1.00 77.88           C  
ATOM   1098  NZ  LYS A 136       0.129  13.765  33.401  1.00 76.05           N  
ATOM   1099  N   ASN A 137      -1.550  15.967  40.443  1.00 80.69           N  
ATOM   1100  CA  ASN A 137      -1.723  15.827  41.884  1.00 78.71           C  
ATOM   1101  C   ASN A 137      -1.710  17.140  42.665  1.00 79.07           C  
ATOM   1102  O   ASN A 137      -1.269  17.192  43.820  1.00 83.12           O  
ATOM   1103  CB  ASN A 137      -0.715  14.811  42.436  1.00 83.57           C  
ATOM   1104  CG  ASN A 137      -1.012  13.401  41.969  1.00 83.79           C  
ATOM   1105  OD1 ASN A 137      -1.908  12.743  42.498  1.00 85.82           O  
ATOM   1106  ND2 ASN A 137      -0.289  12.946  40.962  1.00 83.80           N  
ATOM   1107  N   TYR A 138      -2.213  18.193  42.022  1.00 77.74           N  
ATOM   1108  CA  TYR A 138      -2.415  19.497  42.663  1.00 79.42           C  
ATOM   1109  C   TYR A 138      -3.356  19.435  43.874  1.00 79.10           C  
ATOM   1110  O   TYR A 138      -3.051  20.021  44.911  1.00 85.65           O  
ATOM   1111  CB  TYR A 138      -2.917  20.535  41.639  1.00 77.64           C  
ATOM   1112  CG  TYR A 138      -3.134  21.924  42.212  1.00 80.57           C  
ATOM   1113  CD1 TYR A 138      -2.062  22.788  42.426  1.00 88.72           C  
ATOM   1114  CD2 TYR A 138      -4.413  22.372  42.539  1.00 76.12           C  
ATOM   1115  CE1 TYR A 138      -2.259  24.056  42.956  1.00 99.02           C  
ATOM   1116  CE2 TYR A 138      -4.620  23.642  43.071  1.00 83.98           C  
ATOM   1117  CZ  TYR A 138      -3.543  24.479  43.273  1.00100.12           C  
ATOM   1118  OH  TYR A 138      -3.739  25.744  43.803  1.00115.54           O  
ATOM   1119  N   TYR A 139      -4.492  18.752  43.740  1.00 74.93           N  
ATOM   1120  CA  TYR A 139      -5.467  18.666  44.836  1.00 79.76           C  
ATOM   1121  C   TYR A 139      -5.221  17.438  45.720  1.00 82.40           C  
ATOM   1122  O   TYR A 139      -5.096  16.314  45.230  1.00 80.37           O  
ATOM   1123  CB  TYR A 139      -6.915  18.628  44.312  1.00 75.44           C  
ATOM   1124  CG  TYR A 139      -7.358  19.820  43.485  1.00 76.26           C  
ATOM   1125  CD1 TYR A 139      -7.595  21.066  44.077  1.00 83.17           C  
ATOM   1126  CD2 TYR A 139      -7.556  19.696  42.105  1.00 72.28           C  
ATOM   1127  CE1 TYR A 139      -8.001  22.162  43.313  1.00 85.09           C  
ATOM   1128  CE2 TYR A 139      -7.966  20.784  41.338  1.00 74.54           C  
ATOM   1129  CZ  TYR A 139      -8.186  22.010  41.940  1.00 80.92           C  
ATOM   1130  OH  TYR A 139      -8.582  23.078  41.164  1.00 84.89           O  
ATOM   1131  N   LYS A 140      -5.180  17.657  47.029  1.00 92.25           N  
ATOM   1132  CA  LYS A 140      -4.930  16.575  47.986  1.00 97.47           C  
ATOM   1133  C   LYS A 140      -6.110  15.595  48.140  1.00 96.69           C  
ATOM   1134  O   LYS A 140      -5.921  14.380  48.015  1.00 96.73           O  
ATOM   1135  CB  LYS A 140      -4.516  17.144  49.352  1.00107.41           C  
ATOM   1136  N   ARG A 141      -7.315  16.121  48.381  1.00 98.19           N  
ATOM   1137  CA  ARG A 141      -8.444  15.289  48.841  1.00101.83           C  
ATOM   1138  C   ARG A 141      -9.526  14.872  47.819  1.00 97.51           C  
ATOM   1139  O   ARG A 141     -10.331  13.978  48.108  1.00102.53           O  
ATOM   1140  CB  ARG A 141      -9.102  15.908  50.085  1.00110.13           C  
ATOM   1141  CG  ARG A 141      -8.445  15.512  51.408  1.00121.39           C  
ATOM   1142  N   ILE A 142      -9.563  15.513  46.650  1.00 90.83           N  
ATOM   1143  CA  ILE A 142     -10.652  15.278  45.683  1.00 87.11           C  
ATOM   1144  C   ILE A 142     -10.182  14.531  44.424  1.00 84.50           C  
ATOM   1145  O   ILE A 142      -8.998  14.547  44.085  1.00 82.34           O  
ATOM   1146  CB  ILE A 142     -11.410  16.599  45.299  1.00 86.30           C  
ATOM   1147  CG1 ILE A 142     -10.519  17.537  44.476  1.00 81.61           C  
ATOM   1148  CG2 ILE A 142     -11.978  17.283  46.549  1.00 93.45           C  
ATOM   1149  CD1 ILE A 142     -11.084  18.923  44.273  1.00 86.00           C  
ATOM   1150  N   GLU A 143     -11.119  13.866  43.752  1.00 86.24           N  
ATOM   1151  CA  GLU A 143     -10.823  13.161  42.512  1.00 87.70           C  
ATOM   1152  C   GLU A 143     -11.514  13.919  41.385  1.00 84.59           C  
ATOM   1153  O   GLU A 143     -12.630  14.391  41.578  1.00 84.82           O  
ATOM   1154  CB  GLU A 143     -11.326  11.703  42.543  1.00 97.30           C  
ATOM   1155  CG  GLU A 143     -11.557  11.078  43.945  1.00106.65           C  
ATOM   1156  CD  GLU A 143     -10.367  10.286  44.503  1.00113.42           C  
ATOM   1157  OE1 GLU A 143      -9.288  10.234  43.863  1.00112.45           O  
ATOM   1158  OE2 GLU A 143     -10.525   9.705  45.601  1.00119.83           O  
ATOM   1159  N   PRO A 144     -10.841  14.081  40.223  1.00 83.24           N  
ATOM   1160  CA  PRO A 144      -9.413  13.840  39.976  1.00 82.42           C  
ATOM   1161  C   PRO A 144      -8.490  14.876  40.647  1.00 77.30           C  
ATOM   1162  O   PRO A 144      -8.903  16.011  40.918  1.00 74.76           O  
ATOM   1163  CB  PRO A 144      -9.303  13.934  38.456  1.00 86.06           C  
ATOM   1164  CG  PRO A 144     -10.425  14.812  38.056  1.00 85.35           C  
ATOM   1165  CD  PRO A 144     -11.542  14.482  38.992  1.00 85.29           C  
ATOM   1166  N   ALA A 145      -7.247  14.474  40.911  1.00 72.29           N  
ATOM   1167  CA  ALA A 145      -6.321  15.301  41.678  1.00 69.74           C  
ATOM   1168  C   ALA A 145      -5.635  16.356  40.813  1.00 64.98           C  
ATOM   1169  O   ALA A 145      -5.096  17.335  41.318  1.00 62.90           O  
ATOM   1170  CB  ALA A 145      -5.287  14.428  42.378  1.00 70.96           C  
ATOM   1171  N   ASP A 146      -5.659  16.145  39.504  1.00 62.42           N  
ATOM   1172  CA  ASP A 146      -4.948  17.023  38.582  1.00 59.00           C  
ATOM   1173  C   ASP A 146      -5.733  18.279  38.254  1.00 56.20           C  
ATOM   1174  O   ASP A 146      -6.964  18.290  38.250  1.00 55.83           O  
ATOM   1175  CB  ASP A 146      -4.596  16.271  37.298  1.00 61.16           C  
ATOM   1176  CG  ASP A 146      -3.810  14.971  37.549  1.00 65.40           C  
ATOM   1177  OD1 ASP A 146      -3.320  14.705  38.681  1.00 67.30           O  
ATOM   1178  OD2 ASP A 146      -3.686  14.208  36.576  1.00 67.10           O  
ATOM   1179  N   ALA A 147      -4.998  19.345  37.974  1.00 54.04           N  
ATOM   1180  CA  ALA A 147      -5.575  20.650  37.729  1.00 50.88           C  
ATOM   1181  C   ALA A 147      -4.923  21.290  36.523  1.00 48.11           C  
ATOM   1182  O   ALA A 147      -3.731  21.123  36.305  1.00 51.60           O  
ATOM   1183  CB  ALA A 147      -5.393  21.537  38.960  1.00 50.89           C  
ATOM   1184  N   HIS A 148      -5.710  21.991  35.722  1.00 46.90           N  
ATOM   1185  CA  HIS A 148      -5.164  22.803  34.646  1.00 46.09           C  
ATOM   1186  C   HIS A 148      -4.868  24.139  35.273  1.00 45.87           C  
ATOM   1187  O   HIS A 148      -5.642  24.626  36.108  1.00 44.58           O  
ATOM   1188  CB  HIS A 148      -6.198  23.065  33.562  1.00 46.52           C  
ATOM   1189  CG  HIS A 148      -6.536  21.882  32.718  1.00 47.85           C  
ATOM   1190  ND1 HIS A 148      -5.584  21.025  32.216  1.00 46.04           N  
ATOM   1191  CD2 HIS A 148      -7.726  21.450  32.231  1.00 45.72           C  
ATOM   1192  CE1 HIS A 148      -6.175  20.093  31.489  1.00 52.04           C  
ATOM   1193  NE2 HIS A 148      -7.474  20.336  31.469  1.00 47.93           N  
ATOM   1194  N   VAL A 149      -3.762  24.745  34.865  1.00 46.48           N  
ATOM   1195  CA  VAL A 149      -3.514  26.131  35.160  1.00 45.39           C  
ATOM   1196  C   VAL A 149      -3.988  26.909  33.931  1.00 46.60           C  
ATOM   1197  O   VAL A 149      -3.449  26.730  32.826  1.00 44.44           O  
ATOM   1198  CB  VAL A 149      -2.022  26.409  35.361  1.00 47.33           C  
ATOM   1199  CG1 VAL A 149      -1.786  27.874  35.697  1.00 46.35           C  
ATOM   1200  CG2 VAL A 149      -1.446  25.513  36.412  1.00 49.86           C  
ATOM   1201  N   LEU A 150      -4.996  27.761  34.127  1.00 44.95           N  
ATOM   1202  CA  LEU A 150      -5.481  28.638  33.065  1.00 43.35           C  
ATOM   1203  C   LEU A 150      -4.956  30.032  33.278  1.00 43.12           C  
ATOM   1204  O   LEU A 150      -5.027  30.568  34.385  1.00 41.51           O  
ATOM   1205  CB  LEU A 150      -6.997  28.695  33.105  1.00 43.68           C  
ATOM   1206  CG  LEU A 150      -7.877  27.602  32.511  1.00 47.53           C  
ATOM   1207  CD1 LEU A 150      -7.384  26.232  32.831  1.00 51.86           C  
ATOM   1208  CD2 LEU A 150      -9.256  27.777  33.090  1.00 52.04           C  
ATOM   1209  N   GLN A 151      -4.469  30.642  32.211  1.00 42.33           N  
ATOM   1210  CA  GLN A 151      -3.874  31.973  32.299  1.00 42.93           C  
ATOM   1211  C   GLN A 151      -4.299  32.853  31.147  1.00 43.03           C  
ATOM   1212  O   GLN A 151      -4.369  32.397  29.998  1.00 44.41           O  
ATOM   1213  CB  GLN A 151      -2.340  31.886  32.307  1.00 43.97           C  
ATOM   1214  CG  GLN A 151      -1.633  33.218  32.605  1.00 43.00           C  
ATOM   1215  CD  GLN A 151      -0.130  33.088  32.707  1.00 48.07           C  
ATOM   1216  OE1 GLN A 151       0.409  32.538  33.663  1.00 52.89           O  
ATOM   1217  NE2 GLN A 151       0.559  33.612  31.725  1.00 52.13           N  
ATOM   1218  N   LYS A 152      -4.540  34.122  31.464  1.00 42.59           N  
ATOM   1219  CA  LYS A 152      -4.734  35.171  30.479  1.00 45.81           C  
ATOM   1220  C   LYS A 152      -3.602  36.183  30.617  1.00 49.55           C  
ATOM   1221  O   LYS A 152      -3.421  36.759  31.690  1.00 50.50           O  
ATOM   1222  CB  LYS A 152      -6.069  35.889  30.688  1.00 45.69           C  
ATOM   1223  CG  LYS A 152      -6.445  36.846  29.559  1.00 39.28           C  
ATOM   1224  CD  LYS A 152      -7.636  37.703  29.920  1.00 41.66           C  
ATOM   1225  CE  LYS A 152      -7.915  38.755  28.856  1.00 45.39           C  
ATOM   1226  NZ  LYS A 152      -8.544  38.210  27.629  1.00 48.22           N  
ATOM   1227  N   ASN A 153      -2.850  36.360  29.537  1.00 51.83           N  
ATOM   1228  CA  ASN A 153      -1.823  37.381  29.418  1.00 57.65           C  
ATOM   1229  C   ASN A 153      -2.360  38.794  29.268  1.00 57.53           C  
ATOM   1230  O   ASN A 153      -3.182  39.076  28.375  1.00 58.05           O  
ATOM   1231  CB  ASN A 153      -0.949  37.103  28.195  1.00 62.61           C  
ATOM   1232  CG  ASN A 153       0.226  36.213  28.508  1.00 70.02           C  
ATOM   1233  OD1 ASN A 153       0.225  35.467  29.501  1.00 69.87           O  
ATOM   1234  ND2 ASN A 153       1.250  36.279  27.653  1.00 77.37           N  
ATOM   1235  N   LEU A 154      -1.850  39.691  30.104  1.00 57.49           N  
ATOM   1236  CA  LEU A 154      -2.248  41.077  30.039  1.00 58.64           C  
ATOM   1237  C   LEU A 154      -1.161  41.997  29.473  1.00 63.65           C  
ATOM   1238  O   LEU A 154      -1.480  43.001  28.828  1.00 65.31           O  
ATOM   1239  CB  LEU A 154      -2.695  41.556  31.417  1.00 54.07           C  
ATOM   1240  CG  LEU A 154      -3.870  40.781  32.010  1.00 54.50           C  
ATOM   1241  CD1 LEU A 154      -4.109  41.231  33.461  1.00 48.31           C  
ATOM   1242  CD2 LEU A 154      -5.101  40.958  31.163  1.00 46.23           C  
ATOM   1243  N   LYS A 155       0.109  41.653  29.694  1.00 68.04           N  
ATOM   1244  CA  LYS A 155       1.225  42.530  29.297  1.00 72.74           C  
ATOM   1245  C   LYS A 155       1.388  42.614  27.783  1.00 75.91           C  
ATOM   1246  O   LYS A 155       0.969  41.714  27.051  1.00 75.75           O  
ATOM   1247  CB  LYS A 155       2.540  42.079  29.940  1.00 77.75           C  
TER    1248      LYS A 155                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
