
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  160 ( 1203),  selected  160 , name 2fiw_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 2fiw_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    -2_A      -       -           -
LGA    H    -1_A      -       -           -
LGA    X     0_A      -       -           -
LGA    V     1_A      -       -           -
LGA    X     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    T     4_A      A       2           #
LGA    P     5_A      I       3          2.431
LGA    A     6_A      N       4          0.423
LGA    L     7_A      I       5          0.482
LGA    R     8_A      I       6          0.508
LGA    P     9_A      E       7          0.667
LGA    Y    10_A      Y       8          0.514
LGA    L    11_A      N       9          0.592
LGA    P    12_A      R      10          0.698
LGA    E    13_A      S      11          0.663
LGA    D    14_A      Y      12          0.368
LGA    A    15_A      K      13          0.153
LGA    A    16_A      E      14          0.890
LGA    V    17_A      E      15          0.873
LGA    T    18_A      L      16          0.364
LGA    A    19_A      I      17          0.642
LGA    A    20_A      E      18          1.397
LGA    I    21_A      F      19          1.091
LGA    F    22_A      I      20          0.065
LGA    V    23_A      L      21          1.238
LGA    A    24_A      S      22          1.710
LGA    S    25_A      I      23          1.565
LGA    I    26_A      Q      24          1.329
LGA    E    27_A      K      25          3.044
LGA    Q    28_A      N      26          4.762
LGA    L    29_A      E      27          4.423
LGA    T    30_A      F      28          2.651
LGA    A    31_A      -       -           -
LGA    D    32_A      -       -           -
LGA    D    33_A      -       -           -
LGA    Y    34_A      -       -           -
LGA    S    35_A      -       -           -
LGA    E    36_A      -       -           -
LGA    E    37_A      -       -           -
LGA    Q    38_A      N      29           #
LGA    Q    39_A      I      30          1.357
LGA    E    40_A      K      31          3.363
LGA    A    41_A      I      32          2.043
LGA    W    42_A      -       -           -
LGA    A    43_A      -       -           -
LGA    S    44_A      D      33          0.974
LGA    A    45_A      R      34          2.246
LGA    A    46_A      -       -           -
LGA    D    47_A      -       -           -
LGA    D    48_A      D      35          4.372
LGA    E    49_A      D      36           -
LGA    A    50_A      Q      37           -
LGA    K    51_A      P      38          3.249
LGA    F    52_A      D      39          4.260
LGA    A    53_A      L      40          3.606
LGA    A    54_A      E      41          4.043
LGA    R    55_A      N      42          4.810
LGA    L    56_A      I      43          1.954
LGA    S    57_A      E      44          1.762
LGA    G    58_A      H      45          2.686
LGA    -       -      N      46           -
LGA    Q    59_A      Y      47          0.793
LGA    -       -      L      48           -
LGA    -       -      N      49           -
LGA    -       -      S      50           -
LGA    -       -      G      51           -
LGA    -       -      G      52           -
LGA    L    60_A      Q      53          1.400
LGA    T    61_A      F      54          0.679
LGA    L    62_A      W      55          0.659
LGA    I    63_A      L      56          0.630
LGA    A    64_A      A      57          0.344
LGA    T    65_A      I      58          0.764
LGA    L    66_A      N      59          1.466
LGA    Q    67_A      N      60          1.058
LGA    G    68_A      H      61          3.316
LGA    V    69_A      Q      62          3.020
LGA    P    70_A      N      63          2.643
LGA    -       -      I      64           -
LGA    V    71_A      V      65          0.821
LGA    G    72_A      G      66          1.206
LGA    F    73_A      T      67          0.980
LGA    A    74_A      I      68          0.727
LGA    S    75_A      G      69          0.563
LGA    L    76_A      L      70          0.806
LGA    K    77_A      I      71          0.441
LGA    G    78_A      R      72          0.804
LGA    P    79_A      -       -           -
LGA    D    80_A      L      73           #
LGA    -       -      D      74           -
LGA    -       -      N      75           -
LGA    -       -      N      76           -
LGA    -       -      M      77           -
LGA    -       -      S      78           -
LGA    H    81_A      A      79          1.530
LGA    I    82_A      L      80          0.826
LGA    D    83_A      K      81          1.993
LGA    X    84_A      K      82          1.947
LGA    L    85_A      M      83          0.608
LGA    Y    86_A      F      84          1.571
LGA    V    87_A      V      85          1.544
LGA    H    88_A      D      86          2.074
LGA    P    89_A      K      87          2.242
LGA    D    90_A      G      88          2.574
LGA    Y    91_A      Y      89          2.070
LGA    V    92_A      R      90          1.950
LGA    G    93_A      N      91          2.460
LGA    R    94_A      L      92          1.981
LGA    D    95_A      K      93          1.384
LGA    V    96_A      I      94          1.434
LGA    G    97_A      G      95          1.234
LGA    T    98_A      K      96          1.171
LGA    T    99_A      K      97          0.942
LGA    L   100_A      L      98          0.799
LGA    I   101_A      L      99          0.940
LGA    D   102_A      D     100          0.860
LGA    A   103_A      K     101          0.626
LGA    L   104_A      V     102          0.803
LGA    E   105_A      I     103          0.910
LGA    K   106_A      M     104          0.820
LGA    L   107_A      T     105          0.984
LGA    A   108_A      C     106          1.010
LGA    G   109_A      K     107          1.196
LGA    A   110_A      E     108          0.926
LGA    R   111_A      Q     109          0.785
LGA    G   112_A      N     110          0.861
LGA    A   113_A      I     111          1.267
LGA    L   114_A      D     112          2.076
LGA    I   115_A      G     113          1.640
LGA    L   116_A      I     114          1.811
LGA    T   117_A      Y     115          1.700
LGA    V   118_A      L     116          1.380
LGA    D   119_A      G     117          1.387
LGA    A   120_A      T     118          2.648
LGA    S   121_A      I     119          2.536
LGA    D   122_A      D     120          1.901
LGA    -       -      K     121           -
LGA    N   123_A      F     122          1.592
LGA    -       -      I     123           -
LGA    -       -      S     124           -
LGA    A   124_A      A     125          1.822
LGA    A   125_A      Q     126          1.726
LGA    E   126_A      Y     127          1.465
LGA    F   127_A      F     128          1.053
LGA    F   128_A      Y     129          0.475
LGA    A   129_A      S     130          0.494
LGA    K   130_A      N     131          0.661
LGA    R   131_A      N     132          0.422
LGA    G   132_A      G     133          1.221
LGA    Y   133_A      F     134          0.448
LGA    V   134_A      R     135          0.313
LGA    A   135_A      E     136          0.311
LGA    K   136_A      I     137          1.135
LGA    Q   137_A      K     138          1.250
LGA    R   138_A      -       -           -
LGA    N   139_A      R     139          3.742
LGA    T   140_A      G     140           -
LGA    -       -      D     141           -
LGA    -       -      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    V   141_A      K     148          5.553
LGA    S   142_A      L     149          5.214
LGA    I   143_A      D     150          4.187
LGA    N   144_A      -       -           -
LGA    G   145_A      -       -           -
LGA    E   146_A      -       -           -
LGA    W   147_A      -       -           -
LGA    L   148_A      V     151          2.354
LGA    A   149_A      D     152          3.822
LGA    N   150_A      N     153          2.378
LGA    T   151_A      R     154          2.076
LGA    T   152_A      F     155          2.043
LGA    X   153_A      Y     156          0.921
LGA    T   154_A      Y     157          1.124
LGA    K   155_A      R     158          1.252
LGA    S   156_A      N     159          1.938
LGA    L   157_A      L     160          1.840
LGA    -       -      K     161           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  160  160    5.0    131    1.98    12.98     71.096     6.285

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.930185 * X  +   0.359410 * Y  +   0.074695 * Z  + -54.718441
  Y_new =  -0.118382 * X  +   0.101090 * Y  +   0.987809 * Z  +  -2.305495
  Z_new =   0.347478 * X  +  -0.927688 * Y  +   0.136581 * Z  +  52.787067 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.424620    1.716973  [ DEG:   -81.6247     98.3753 ]
  Theta =  -0.354880   -2.786713  [ DEG:   -20.3331   -159.6669 ]
  Phi   =  -0.126587    3.015006  [ DEG:    -7.2529    172.7471 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fiw_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fiw_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  160  160   5.0  131   1.98   12.98  71.096
REMARK  ---------------------------------------------------------- 
MOLECULE 2fiw_A
HEADER    TRANSFERASE                             30-DEC-05   2FIW              
TITLE     CRYSTAL STRUCTURE OF THE GCN5-RELATED N-ACETYLTRANSFERASE:            
TITLE    2 AMINOTRANSFERASE, CLASS-II FROM RHODOPSEUDOMONAS PALUSTRIS           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GCN5-RELATED N-                                            
COMPND   3 ACETYLTRANSFERASE:AMINOTRANSFERASE, CLASS-II;                        
COMPND   4 CHAIN: A;                                                            
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHODOPSEUDOMONAS PALUSTRIS CGA009;              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21DE3;                                   
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    ALPHA-BETA-ALPHA SANDWICH, GCN4-RELATED ACETYLTRANSFERASE ,           
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE,              
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,T.SKARINA,O.ONOPRIYENKO,A.SAVCHENKO,A.EDWARDS,                  
AUTHOR   2 A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   1   14-FEB-06 2FIW    0                                                
JRNL        AUTH   Y.KIM,T SKARINA,O.ONOPRIYENKO,A.SAVCHENKO,                   
JRNL        AUTH 2 A.EDWARDS,A.JOACHIMIAK                                       
JRNL        TITL   CRYSTAL STRUCTURE OF THE GCN5-RELATED                        
JRNL        TITL 2 N-ACETYLTRANSFERASE: AMINOTRANSFERASE, CLASS-II              
JRNL        TITL 3 FROM RHODOPSEUDOMONAS PALUSTRIS                              
JRNL        REF    TO BE PUBLISHED                            2006              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.35 ANGSTROMS.                                          
DBREF  2FIW A    1   167  GB     39648919 CAE27440         3    169             
SEQRES   1 A  172  GLY HIS MSE VAL MSE SER THR PRO ALA LEU ARG PRO TYR          
SEQRES   2 A  172  LEU PRO GLU ASP ALA ALA VAL THR ALA ALA ILE PHE VAL          
SEQRES   3 A  172  ALA SER ILE GLU GLN LEU THR ALA ASP ASP TYR SER GLU          
SEQRES   4 A  172  GLU GLN GLN GLU ALA TRP ALA SER ALA ALA ASP ASP GLU          
SEQRES   5 A  172  ALA LYS PHE ALA ALA ARG LEU SER GLY GLN LEU THR LEU          
SEQRES   6 A  172  ILE ALA THR LEU GLN GLY VAL PRO VAL GLY PHE ALA SER          
SEQRES   7 A  172  LEU LYS GLY PRO ASP HIS ILE ASP MSE LEU TYR VAL HIS          
SEQRES   8 A  172  PRO ASP TYR VAL GLY ARG ASP VAL GLY THR THR LEU ILE          
SEQRES   9 A  172  ASP ALA LEU GLU LYS LEU ALA GLY ALA ARG GLY ALA LEU          
SEQRES  10 A  172  ILE LEU THR VAL ASP ALA SER ASP ASN ALA ALA GLU PHE          
SEQRES  11 A  172  PHE ALA LYS ARG GLY TYR VAL ALA LYS GLN ARG ASN THR          
SEQRES  12 A  172  VAL SER ILE ASN GLY GLU TRP LEU ALA ASN THR THR MSE          
SEQRES  13 A  172  THR LYS SER LEU ALA ASP SER ALA ALA PRO GLY ALA SER          
SEQRES  14 A  172  SER GLY SER                                                  
HET    MSE  A   0       8                                                       
HET    MSE  A   2       8                                                       
HET    MSE  A  84       8                                                       
HET    MSE  A 153       8                                                       
HET    SO4    201       5                                                       
HET    ACO    200      51                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM     ACO ACETYL COENZYME *A                                               
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2  SO4    O4 S 2-                                                      
FORMUL   3  ACO    C23 H38 N7 O17 P3 S                                          
FORMUL   4  HOH   *90(H2 O)                                                     
CRYST1   78.293   78.293   93.242  90.00  90.00 120.00 P 31 2 1      6          
ATOM      1  N   GLY A  -2     -31.205  32.312  17.118  1.00 61.91           N  
ATOM      2  CA  GLY A  -2     -31.471  33.261  18.244  1.00 61.52           C  
ATOM      3  C   GLY A  -2     -31.044  32.724  19.605  1.00 61.24           C  
ATOM      4  O   GLY A  -2     -31.014  31.502  19.819  1.00 61.60           O  
ATOM      5  N   HIS A  -1     -30.719  33.640  20.521  1.00 60.24           N  
ATOM      6  CA  HIS A  -1     -30.285  33.293  21.880  1.00 59.17           C  
ATOM      7  C   HIS A  -1     -30.918  34.210  22.935  1.00 57.84           C  
ATOM      8  O   HIS A  -1     -31.266  35.347  22.627  1.00 57.40           O  
ATOM      9  CB  HIS A  -1     -28.754  33.331  21.984  1.00 59.52           C  
ATOM     10  CG  HIS A  -1     -28.137  34.594  21.461  1.00 60.96           C  
ATOM     11  ND1 HIS A  -1     -27.922  35.704  22.253  1.00 61.59           N  
ATOM     12  CD2 HIS A  -1     -27.678  34.920  20.226  1.00 61.96           C  
ATOM     13  CE1 HIS A  -1     -27.357  36.657  21.532  1.00 61.89           C  
ATOM     14  NE2 HIS A  -1     -27.200  36.208  20.299  1.00 62.41           N  
HETATM   15  N   MSE A   0     -31.072  33.707  24.165  1.00 56.39           N  
HETATM   16  CA  MSE A   0     -31.610  34.506  25.269  1.00 55.19           C  
HETATM   17  C   MSE A   0     -30.590  35.548  25.719  1.00 53.54           C  
HETATM   18  O   MSE A   0     -29.378  35.284  25.753  1.00 53.58           O  
HETATM   19  CB  MSE A   0     -32.003  33.642  26.467  1.00 55.72           C  
HETATM   20  CG  MSE A   0     -33.130  32.648  26.241  1.00 59.33           C  
HETATM   21 SE   MSE A   0     -34.906  33.451  26.050  0.70 69.06          SE  
HETATM   22  CE  MSE A   0     -34.915  33.524  24.201  1.00 65.76           C  
ATOM     23  N   VAL A   1     -31.091  36.729  26.063  1.00 51.24           N  
ATOM     24  CA  VAL A   1     -30.247  37.803  26.550  1.00 48.89           C  
ATOM     25  C   VAL A   1     -30.384  37.862  28.063  1.00 47.63           C  
ATOM     26  O   VAL A   1     -31.480  38.089  28.591  1.00 46.72           O  
ATOM     27  CB  VAL A   1     -30.606  39.154  25.906  1.00 48.67           C  
ATOM     28  CG1 VAL A   1     -29.685  40.245  26.410  1.00 48.01           C  
ATOM     29  CG2 VAL A   1     -30.516  39.061  24.389  1.00 48.31           C  
HETATM   30  N   MSE A   2     -29.265  37.633  28.755  1.00 46.08           N  
HETATM   31  CA  MSE A   2     -29.261  37.657  30.210  1.00 44.61           C  
HETATM   32  C   MSE A   2     -29.172  39.094  30.723  1.00 43.70           C  
HETATM   33  O   MSE A   2     -28.589  39.965  30.095  1.00 42.82           O  
HETATM   34  CB  MSE A   2     -28.092  36.839  30.786  1.00 45.69           C  
HETATM   35  CG  MSE A   2     -28.005  35.347  30.422  1.00 45.65           C  
HETATM   36 SE   MSE A   2     -29.542  34.290  30.948  0.60 50.60          SE  
HETATM   37  CE  MSE A   2     -29.977  34.954  32.689  1.00 50.26           C  
ATOM     38  N   SER A   3     -29.790  39.326  31.869  1.00 42.89           N  
ATOM     39  CA  SER A   3     -29.508  40.482  32.682  1.00 42.46           C  
ATOM     40  C   SER A   3     -28.116  40.340  33.335  1.00 42.64           C  
ATOM     41  O   SER A   3     -27.609  39.228  33.543  1.00 43.24           O  
ATOM     42  CB  SER A   3     -30.577  40.615  33.761  1.00 42.53           C  
ATOM     43  OG  SER A   3     -31.863  40.767  33.180  1.00 41.23           O  
ATOM     44  N   THR A   4     -27.497  41.468  33.639  1.00 41.96           N  
ATOM     45  CA  THR A   4     -26.234  41.483  34.353  1.00 41.59           C  
ATOM     46  C   THR A   4     -26.545  41.569  35.838  1.00 40.38           C  
ATOM     47  O   THR A   4     -27.373  42.372  36.251  1.00 40.91           O  
ATOM     48  CB  THR A   4     -25.404  42.703  33.928  1.00 42.02           C  
ATOM     49  OG1 THR A   4     -25.418  42.811  32.496  1.00 44.28           O  
ATOM     50  CG2 THR A   4     -23.978  42.561  34.361  1.00 42.75           C  
ATOM     51  N   PRO A   5     -25.910  40.730  36.660  1.00 39.22           N  
ATOM     52  CA  PRO A   5     -26.141  40.959  38.078  1.00 38.40           C  
ATOM     53  C   PRO A   5     -25.432  42.225  38.593  1.00 37.57           C  
ATOM     54  O   PRO A   5     -24.480  42.711  37.974  1.00 36.98           O  
ATOM     55  CB  PRO A   5     -25.558  39.701  38.739  1.00 38.30           C  
ATOM     56  CG  PRO A   5     -24.565  39.190  37.782  1.00 38.59           C  
ATOM     57  CD  PRO A   5     -25.026  39.580  36.412  1.00 38.94           C  
ATOM     58  N   ALA A   6     -25.937  42.755  39.705  1.00 36.94           N  
ATOM     59  CA  ALA A   6     -25.259  43.792  40.457  1.00 36.35           C  
ATOM     60  C   ALA A   6     -24.062  43.179  41.164  1.00 36.22           C  
ATOM     61  O   ALA A   6     -24.102  42.021  41.593  1.00 36.67           O  
ATOM     62  CB  ALA A   6     -26.197  44.395  41.459  1.00 35.87           C  
ATOM     63  N   LEU A   7     -22.990  43.953  41.267  1.00 35.95           N  
ATOM     64  CA  LEU A   7     -21.772  43.534  41.946  1.00 34.86           C  
ATOM     65  C   LEU A   7     -21.446  44.562  43.022  1.00 34.54           C  
ATOM     66  O   LEU A   7     -21.590  45.766  42.805  1.00 34.30           O  
ATOM     67  CB  LEU A   7     -20.605  43.430  40.960  1.00 34.67           C  
ATOM     68  CG  LEU A   7     -20.728  42.601  39.675  1.00 34.44           C  
ATOM     69  CD1 LEU A   7     -19.399  42.600  38.916  1.00 32.38           C  
ATOM     70  CD2 LEU A   7     -21.152  41.174  39.952  1.00 33.10           C  
ATOM     71  N   ARG A   8     -21.038  44.086  44.189  1.00 33.80           N  
ATOM     72  CA  ARG A   8     -20.604  44.965  45.262  1.00 33.56           C  
ATOM     73  C   ARG A   8     -19.441  44.331  46.007  1.00 32.93           C  
ATOM     74  O   ARG A   8     -19.347  43.101  46.063  1.00 32.43           O  
ATOM     75  CB  ARG A   8     -21.761  45.244  46.224  1.00 33.69           C  
ATOM     76  CG  ARG A   8     -22.404  43.987  46.787  1.00 34.74           C  
ATOM     77  CD  ARG A   8     -23.415  44.324  47.832  1.00 36.47           C  
ATOM     78  NE  ARG A   8     -23.868  43.126  48.535  1.00 38.35           N  
ATOM     79  CZ  ARG A   8     -23.235  42.543  49.552  1.00 36.25           C  
ATOM     80  NH1 ARG A   8     -22.074  43.017  50.009  1.00 33.76           N  
ATOM     81  NH2 ARG A   8     -23.769  41.456  50.094  1.00 36.45           N  
ATOM     82  N   PRO A   9     -18.539  45.163  46.574  1.00 32.61           N  
ATOM     83  CA  PRO A   9     -17.432  44.614  47.358  1.00 32.17           C  
ATOM     84  C   PRO A   9     -17.882  43.780  48.564  1.00 31.86           C  
ATOM     85  O   PRO A   9     -18.985  43.967  49.102  1.00 31.05           O  
ATOM     86  CB  PRO A   9     -16.674  45.869  47.802  1.00 32.23           C  
ATOM     87  CG  PRO A   9     -16.975  46.856  46.736  1.00 31.21           C  
ATOM     88  CD  PRO A   9     -18.435  46.633  46.496  1.00 32.34           C  
ATOM     89  N   TYR A  10     -17.026  42.832  48.927  1.00 31.57           N  
ATOM     90  CA  TYR A  10     -17.255  41.939  50.035  1.00 31.45           C  
ATOM     91  C   TYR A  10     -17.157  42.681  51.378  1.00 31.75           C  
ATOM     92  O   TYR A  10     -16.199  43.417  51.635  1.00 31.37           O  
ATOM     93  CB  TYR A  10     -16.232  40.804  49.966  1.00 31.39           C  
ATOM     94  CG  TYR A  10     -16.118  39.959  51.223  1.00 31.06           C  
ATOM     95  CD1 TYR A  10     -15.010  40.092  52.075  1.00 31.05           C  
ATOM     96  CD2 TYR A  10     -17.123  39.044  51.569  1.00 29.47           C  
ATOM     97  CE1 TYR A  10     -14.903  39.334  53.226  1.00 30.89           C  
ATOM     98  CE2 TYR A  10     -17.020  38.280  52.721  1.00 30.04           C  
ATOM     99  CZ  TYR A  10     -15.899  38.426  53.534  1.00 30.17           C  
ATOM    100  OH  TYR A  10     -15.778  37.679  54.661  1.00 30.39           O  
ATOM    101  N   LEU A  11     -18.152  42.468  52.229  1.00 32.07           N  
ATOM    102  CA  LEU A  11     -18.203  43.094  53.531  1.00 32.56           C  
ATOM    103  C   LEU A  11     -18.079  42.024  54.616  1.00 33.57           C  
ATOM    104  O   LEU A  11     -18.468  40.867  54.399  1.00 33.62           O  
ATOM    105  CB  LEU A  11     -19.511  43.868  53.685  1.00 32.55           C  
ATOM    106  CG  LEU A  11     -19.858  44.975  52.676  1.00 31.72           C  
ATOM    107  CD1 LEU A  11     -21.284  45.451  52.920  1.00 29.28           C  
ATOM    108  CD2 LEU A  11     -18.866  46.136  52.738  1.00 30.01           C  
ATOM    109  N   PRO A  12     -17.537  42.395  55.792  1.00 34.50           N  
ATOM    110  CA  PRO A  12     -17.373  41.406  56.876  1.00 35.41           C  
ATOM    111  C   PRO A  12     -18.649  40.637  57.205  1.00 36.38           C  
ATOM    112  O   PRO A  12     -18.565  39.479  57.600  1.00 36.76           O  
ATOM    113  CB  PRO A  12     -16.914  42.249  58.082  1.00 35.68           C  
ATOM    114  CG  PRO A  12     -17.058  43.691  57.663  1.00 35.29           C  
ATOM    115  CD  PRO A  12     -17.024  43.722  56.165  1.00 34.45           C  
ATOM    116  N   GLU A  13     -19.803  41.277  57.021  1.00 37.28           N  
ATOM    117  CA  GLU A  13     -21.104  40.687  57.291  1.00 38.56           C  
ATOM    118  C   GLU A  13     -21.454  39.626  56.264  1.00 39.01           C  
ATOM    119  O   GLU A  13     -22.437  38.910  56.428  1.00 39.47           O  
ATOM    120  CB  GLU A  13     -22.230  41.740  57.254  1.00 38.78           C  
ATOM    121  CG  GLU A  13     -21.946  43.039  57.931  1.00 40.33           C  
ATOM    122  CD  GLU A  13     -21.254  44.019  57.021  1.00 39.71           C  
ATOM    123  OE1 GLU A  13     -20.031  44.120  57.117  1.00 42.14           O  
ATOM    124  OE2 GLU A  13     -21.915  44.690  56.216  1.00 41.23           O  
ATOM    125  N   ASP A  14     -20.693  39.558  55.177  1.00 39.44           N  
ATOM    126  CA  ASP A  14     -20.993  38.594  54.121  1.00 39.31           C  
ATOM    127  C   ASP A  14     -20.253  37.286  54.340  1.00 39.12           C  
ATOM    128  O   ASP A  14     -20.327  36.391  53.500  1.00 39.36           O  
ATOM    129  CB  ASP A  14     -20.596  39.148  52.755  1.00 39.39           C  
ATOM    130  CG  ASP A  14     -21.309  40.421  52.405  1.00 39.99           C  
ATOM    131  OD1 ASP A  14     -22.534  40.538  52.684  1.00 41.33           O  
ATOM    132  OD2 ASP A  14     -20.631  41.304  51.828  1.00 39.34           O  
ATOM    133  N   ALA A  15     -19.531  37.187  55.453  1.00 38.83           N  
ATOM    134  CA  ALA A  15     -18.644  36.050  55.718  1.00 38.86           C  
ATOM    135  C   ALA A  15     -19.331  34.694  55.552  1.00 39.08           C  
ATOM    136  O   ALA A  15     -18.806  33.803  54.875  1.00 39.46           O  
ATOM    137  CB  ALA A  15     -18.012  36.171  57.105  1.00 38.32           C  
ATOM    138  N   ALA A  16     -20.504  34.553  56.161  1.00 39.13           N  
ATOM    139  CA  ALA A  16     -21.236  33.285  56.186  1.00 39.67           C  
ATOM    140  C   ALA A  16     -21.912  32.931  54.854  1.00 39.71           C  
ATOM    141  O   ALA A  16     -21.849  31.777  54.442  1.00 40.06           O  
ATOM    142  CB  ALA A  16     -22.258  33.260  57.335  1.00 39.28           C  
ATOM    143  N   VAL A  17     -22.564  33.895  54.195  1.00 39.21           N  
ATOM    144  CA  VAL A  17     -23.194  33.611  52.897  1.00 39.21           C  
ATOM    145  C   VAL A  17     -22.153  33.263  51.816  1.00 38.70           C  
ATOM    146  O   VAL A  17     -22.428  32.490  50.906  1.00 38.90           O  
ATOM    147  CB  VAL A  17     -24.185  34.740  52.407  1.00 39.42           C  
ATOM    148  CG1 VAL A  17     -25.174  35.146  53.522  1.00 39.95           C  
ATOM    149  CG2 VAL A  17     -23.440  35.964  51.880  1.00 40.31           C  
ATOM    150  N   THR A  18     -20.958  33.839  51.934  1.00 37.98           N  
ATOM    151  CA  THR A  18     -19.877  33.600  50.990  1.00 37.35           C  
ATOM    152  C   THR A  18     -19.357  32.173  51.156  1.00 36.15           C  
ATOM    153  O   THR A  18     -19.097  31.489  50.171  1.00 36.31           O  
ATOM    154  CB  THR A  18     -18.718  34.626  51.182  1.00 37.42           C  
ATOM    155  OG1 THR A  18     -19.248  35.952  51.114  1.00 40.37           O  
ATOM    156  CG2 THR A  18     -17.722  34.501  50.088  1.00 37.68           C  
ATOM    157  N   ALA A  19     -19.195  31.757  52.408  1.00 34.75           N  
ATOM    158  CA  ALA A  19     -18.755  30.417  52.749  1.00 33.94           C  
ATOM    159  C   ALA A  19     -19.793  29.412  52.305  1.00 33.03           C  
ATOM    160  O   ALA A  19     -19.435  28.339  51.866  1.00 33.26           O  
ATOM    161  CB  ALA A  19     -18.474  30.288  54.260  1.00 33.79           C  
ATOM    162  N   ALA A  20     -21.067  29.793  52.388  1.00 32.27           N  
ATOM    163  CA  ALA A  20     -22.184  28.985  51.930  1.00 31.82           C  
ATOM    164  C   ALA A  20     -22.283  28.824  50.407  1.00 31.86           C  
ATOM    165  O   ALA A  20     -22.637  27.748  49.912  1.00 32.29           O  
ATOM    166  CB  ALA A  20     -23.480  29.525  52.497  1.00 31.78           C  
ATOM    167  N   ILE A  21     -21.972  29.876  49.655  1.00 31.65           N  
ATOM    168  CA  ILE A  21     -21.975  29.791  48.181  1.00 31.23           C  
ATOM    169  C   ILE A  21     -20.829  28.895  47.714  1.00 31.90           C  
ATOM    170  O   ILE A  21     -20.962  28.147  46.746  1.00 32.16           O  
ATOM    171  CB  ILE A  21     -21.839  31.206  47.517  1.00 31.33           C  
ATOM    172  CG1 ILE A  21     -23.150  31.989  47.632  1.00 30.50           C  
ATOM    173  CG2 ILE A  21     -21.424  31.095  46.059  1.00 29.85           C  
ATOM    174  CD1 ILE A  21     -22.980  33.505  47.504  1.00 30.23           C  
ATOM    175  N   PHE A  22     -19.705  29.005  48.422  1.00 32.11           N  
ATOM    176  CA  PHE A  22     -18.463  28.315  48.123  1.00 32.23           C  
ATOM    177  C   PHE A  22     -18.635  26.794  48.301  1.00 32.69           C  
ATOM    178  O   PHE A  22     -18.340  26.025  47.376  1.00 32.85           O  
ATOM    179  CB  PHE A  22     -17.374  28.909  49.027  1.00 31.41           C  
ATOM    180  CG  PHE A  22     -16.079  28.130  49.083  1.00 31.21           C  
ATOM    181  CD1 PHE A  22     -15.845  27.210  50.115  1.00 29.75           C  
ATOM    182  CD2 PHE A  22     -15.053  28.397  48.179  1.00 28.09           C  
ATOM    183  CE1 PHE A  22     -14.633  26.528  50.193  1.00 30.99           C  
ATOM    184  CE2 PHE A  22     -13.850  27.728  48.235  1.00 27.46           C  
ATOM    185  CZ  PHE A  22     -13.620  26.792  49.247  1.00 30.49           C  
ATOM    186  N   VAL A  23     -19.140  26.364  49.459  1.00 33.10           N  
ATOM    187  CA  VAL A  23     -19.325  24.933  49.682  1.00 33.66           C  
ATOM    188  C   VAL A  23     -20.431  24.348  48.797  1.00 34.06           C  
ATOM    189  O   VAL A  23     -20.279  23.226  48.325  1.00 35.28           O  
ATOM    190  CB  VAL A  23     -19.489  24.495  51.194  1.00 33.89           C  
ATOM    191  CG1 VAL A  23     -18.699  25.371  52.126  1.00 32.84           C  
ATOM    192  CG2 VAL A  23     -20.922  24.411  51.605  1.00 34.19           C  
ATOM    193  N   ALA A  24     -21.521  25.090  48.560  1.00 33.71           N  
ATOM    194  CA  ALA A  24     -22.615  24.576  47.736  1.00 33.32           C  
ATOM    195  C   ALA A  24     -22.206  24.457  46.274  1.00 33.87           C  
ATOM    196  O   ALA A  24     -22.594  23.519  45.587  1.00 33.49           O  
ATOM    197  CB  ALA A  24     -23.830  25.436  47.884  1.00 33.46           C  
ATOM    198  N   SER A  25     -21.414  25.416  45.807  1.00 34.41           N  
ATOM    199  CA  SER A  25     -20.854  25.420  44.450  1.00 34.92           C  
ATOM    200  C   SER A  25     -19.952  24.202  44.211  1.00 35.31           C  
ATOM    201  O   SER A  25     -20.023  23.549  43.176  1.00 35.16           O  
ATOM    202  CB  SER A  25     -20.051  26.704  44.249  1.00 34.86           C  
ATOM    203  OG  SER A  25     -19.607  26.836  42.913  1.00 36.31           O  
ATOM    204  N   ILE A  26     -19.093  23.915  45.186  1.00 36.29           N  
ATOM    205  CA  ILE A  26     -18.190  22.775  45.137  1.00 36.15           C  
ATOM    206  C   ILE A  26     -18.938  21.420  45.186  1.00 36.85           C  
ATOM    207  O   ILE A  26     -18.723  20.557  44.331  1.00 37.23           O  
ATOM    208  CB  ILE A  26     -17.134  22.889  46.248  1.00 36.03           C  
ATOM    209  CG1 ILE A  26     -16.206  24.080  45.948  1.00 35.30           C  
ATOM    210  CG2 ILE A  26     -16.359  21.550  46.453  1.00 34.74           C  
ATOM    211  CD1 ILE A  26     -15.403  24.533  47.149  1.00 33.66           C  
ATOM    212  N   GLU A  27     -19.795  21.243  46.186  0.50 37.04           N  
ATOM    214  CA  GLU A  27     -20.564  20.008  46.337  0.50 37.22           C  
ATOM    216  C   GLU A  27     -21.285  19.670  45.041  0.50 37.31           C  
ATOM    218  O   GLU A  27     -21.114  18.583  44.468  0.50 37.19           O  
ATOM    220  CB  GLU A  27     -21.584  20.157  47.468  0.50 37.05           C  
ATOM    222  CG  GLU A  27     -20.969  20.240  48.868  0.50 37.33           C  
ATOM    224  CD  GLU A  27     -22.005  20.496  49.948  0.50 37.60           C  
ATOM    226  OE1 GLU A  27     -23.115  20.991  49.623  0.50 37.63           O  
ATOM    228  OE2 GLU A  27     -21.698  20.207  51.128  0.50 37.33           O  
ATOM    230  N   GLN A  28     -22.050  20.642  44.559  1.00 37.46           N  
ATOM    231  CA  GLN A  28     -23.012  20.414  43.475  1.00 37.74           C  
ATOM    232  C   GLN A  28     -22.471  20.560  42.055  1.00 37.56           C  
ATOM    233  O   GLN A  28     -23.091  20.046  41.122  1.00 38.58           O  
ATOM    234  CB  GLN A  28     -24.269  21.287  43.662  1.00 37.76           C  
ATOM    235  CG  GLN A  28     -24.979  21.088  45.029  1.00 38.49           C  
ATOM    236  CD  GLN A  28     -26.286  21.896  45.179  1.00 40.46           C  
ATOM    237  OE1 GLN A  28     -27.160  21.885  44.291  1.00 43.10           O  
ATOM    238  NE2 GLN A  28     -26.427  22.594  46.323  1.00 41.80           N  
ATOM    239  N   LEU A  29     -21.345  21.250  41.846  1.00 36.89           N  
ATOM    240  CA  LEU A  29     -20.928  21.524  40.457  1.00 36.45           C  
ATOM    241  C   LEU A  29     -19.672  20.828  39.963  1.00 36.36           C  
ATOM    242  O   LEU A  29     -19.283  21.003  38.812  1.00 35.94           O  
ATOM    243  CB  LEU A  29     -20.848  23.037  40.180  1.00 36.12           C  
ATOM    244  CG  LEU A  29     -22.112  23.859  40.454  1.00 36.49           C  
ATOM    245  CD1 LEU A  29     -21.791  25.335  40.578  1.00 35.30           C  
ATOM    246  CD2 LEU A  29     -23.202  23.604  39.389  1.00 34.54           C  
ATOM    247  N   THR A  30     -19.047  20.027  40.818  1.00 37.25           N  
ATOM    248  CA  THR A  30     -17.712  19.502  40.513  1.00 38.47           C  
ATOM    249  C   THR A  30     -17.618  17.967  40.397  1.00 39.26           C  
ATOM    250  O   THR A  30     -16.519  17.441  40.250  1.00 39.96           O  
ATOM    251  CB  THR A  30     -16.664  19.991  41.548  1.00 38.26           C  
ATOM    252  OG1 THR A  30     -16.948  19.406  42.816  1.00 37.78           O  
ATOM    253  CG2 THR A  30     -16.691  21.520  41.697  1.00 38.51           C  
ATOM    254  N   ALA A  31     -18.757  17.268  40.464  1.00 39.60           N  
ATOM    255  CA  ALA A  31     -18.792  15.801  40.552  1.00 39.73           C  
ATOM    256  C   ALA A  31     -18.185  15.096  39.351  1.00 39.98           C  
ATOM    257  O   ALA A  31     -17.620  14.009  39.485  1.00 40.46           O  
ATOM    258  CB  ALA A  31     -20.218  15.296  40.800  1.00 39.67           C  
ATOM    259  N   ASP A  32     -18.279  15.698  38.178  1.00 39.95           N  
ATOM    260  CA  ASP A  32     -17.775  15.026  36.996  1.00 40.40           C  
ATOM    261  C   ASP A  32     -16.252  15.073  36.912  1.00 40.25           C  
ATOM    262  O   ASP A  32     -15.647  14.342  36.126  1.00 40.04           O  
ATOM    263  CB  ASP A  32     -18.420  15.580  35.728  1.00 40.93           C  
ATOM    264  CG  ASP A  32     -19.947  15.388  35.704  1.00 43.06           C  
ATOM    265  OD1 ASP A  32     -20.483  14.437  36.334  1.00 44.25           O  
ATOM    266  OD2 ASP A  32     -20.609  16.200  35.031  1.00 44.53           O  
ATOM    267  N   ASP A  33     -15.626  15.924  37.721  1.00 39.61           N  
ATOM    268  CA  ASP A  33     -14.180  16.037  37.650  1.00 39.13           C  
ATOM    269  C   ASP A  33     -13.468  15.764  38.972  1.00 38.07           C  
ATOM    270  O   ASP A  33     -12.247  15.620  38.995  1.00 37.56           O  
ATOM    271  CB  ASP A  33     -13.764  17.376  37.053  1.00 39.18           C  
ATOM    272  CG  ASP A  33     -14.444  17.651  35.736  1.00 41.36           C  
ATOM    273  OD1 ASP A  33     -13.906  17.257  34.685  1.00 41.56           O  
ATOM    274  OD2 ASP A  33     -15.547  18.245  35.760  1.00 45.74           O  
ATOM    275  N   TYR A  34     -14.229  15.687  40.056  1.00 37.12           N  
ATOM    276  CA  TYR A  34     -13.639  15.494  41.373  1.00 37.34           C  
ATOM    277  C   TYR A  34     -14.439  14.486  42.161  1.00 38.02           C  
ATOM    278  O   TYR A  34     -15.667  14.568  42.197  1.00 38.22           O  
ATOM    279  CB  TYR A  34     -13.498  16.836  42.149  1.00 36.10           C  
ATOM    280  CG  TYR A  34     -12.584  17.801  41.444  1.00 34.43           C  
ATOM    281  CD1 TYR A  34     -13.086  18.744  40.535  1.00 32.80           C  
ATOM    282  CD2 TYR A  34     -11.203  17.726  41.617  1.00 33.39           C  
ATOM    283  CE1 TYR A  34     -12.224  19.610  39.845  1.00 31.86           C  
ATOM    284  CE2 TYR A  34     -10.340  18.578  40.929  1.00 31.75           C  
ATOM    285  CZ  TYR A  34     -10.852  19.520  40.059  1.00 33.09           C  
ATOM    286  OH  TYR A  34      -9.979  20.351  39.399  1.00 33.69           O  
ATOM    287  N   SER A  35     -13.747  13.537  42.794  1.00 38.70           N  
ATOM    288  CA  SER A  35     -14.425  12.540  43.620  1.00 39.36           C  
ATOM    289  C   SER A  35     -14.838  13.115  44.975  1.00 39.71           C  
ATOM    290  O   SER A  35     -14.312  14.124  45.409  1.00 39.94           O  
ATOM    291  CB  SER A  35     -13.615  11.232  43.735  1.00 39.27           C  
ATOM    292  OG  SER A  35     -12.348  11.396  44.362  1.00 40.57           O  
ATOM    293  N   GLU A  36     -15.811  12.444  45.584  0.50 40.10           N  
ATOM    295  CA  GLU A  36     -16.362  12.721  46.909  0.50 40.24           C  
ATOM    297  C   GLU A  36     -15.389  13.322  47.951  0.50 40.47           C  
ATOM    299  O   GLU A  36     -15.705  14.317  48.619  0.50 40.74           O  
ATOM    301  CB  GLU A  36     -17.008  11.428  47.438  0.50 40.20           C  
ATOM    303  CG  GLU A  36     -16.166  10.131  47.226  0.50 39.55           C  
ATOM    305  CD  GLU A  36     -16.487   9.317  45.941  0.50 38.94           C  
ATOM    307  OE1 GLU A  36     -16.762   9.889  44.851  0.50 36.22           O  
ATOM    309  OE2 GLU A  36     -16.420   8.068  46.036  0.50 37.44           O  
ATOM    311  N   GLU A  37     -14.215  12.715  48.075  1.00 40.29           N  
ATOM    312  CA  GLU A  37     -13.211  13.094  49.055  1.00 40.18           C  
ATOM    313  C   GLU A  37     -12.440  14.356  48.664  1.00 39.54           C  
ATOM    314  O   GLU A  37     -12.057  15.150  49.524  1.00 38.72           O  
ATOM    315  CB  GLU A  37     -12.230  11.946  49.261  1.00 40.81           C  
ATOM    316  CG  GLU A  37     -12.694  10.857  50.199  1.00 43.44           C  
ATOM    317  CD  GLU A  37     -11.528   9.971  50.659  1.00 47.46           C  
ATOM    318  OE1 GLU A  37     -10.479  10.525  51.063  1.00 47.54           O  
ATOM    319  OE2 GLU A  37     -11.662   8.725  50.616  1.00 48.38           O  
ATOM    320  N   GLN A  38     -12.180  14.500  47.366  1.00 38.94           N  
ATOM    321  CA  GLN A  38     -11.584  15.706  46.813  1.00 38.67           C  
ATOM    322  C   GLN A  38     -12.479  16.923  47.074  1.00 39.46           C  
ATOM    323  O   GLN A  38     -12.010  17.958  47.564  1.00 39.47           O  
ATOM    324  CB  GLN A  38     -11.346  15.540  45.322  1.00 38.31           C  
ATOM    325  CG  GLN A  38     -10.233  14.559  44.990  1.00 35.99           C  
ATOM    326  CD  GLN A  38     -10.045  14.401  43.512  1.00 33.82           C  
ATOM    327  OE1 GLN A  38     -10.977  14.049  42.787  1.00 32.21           O  
ATOM    328  NE2 GLN A  38      -8.835  14.668  43.046  1.00 32.38           N  
ATOM    329  N   GLN A  39     -13.771  16.777  46.777  1.00 39.77           N  
ATOM    330  CA  GLN A  39     -14.768  17.832  47.019  1.00 39.18           C  
ATOM    331  C   GLN A  39     -14.855  18.228  48.488  1.00 38.82           C  
ATOM    332  O   GLN A  39     -15.047  19.402  48.799  1.00 39.41           O  
ATOM    333  CB  GLN A  39     -16.151  17.390  46.532  1.00 39.17           C  
ATOM    334  CG  GLN A  39     -16.254  17.116  45.041  1.00 39.05           C  
ATOM    335  CD  GLN A  39     -17.599  16.517  44.666  1.00 39.52           C  
ATOM    336  OE1 GLN A  39     -18.104  15.625  45.346  1.00 40.66           O  
ATOM    337  NE2 GLN A  39     -18.181  17.001  43.581  1.00 39.87           N  
ATOM    338  N   GLU A  40     -14.704  17.252  49.378  0.50 38.47           N  
ATOM    340  CA  GLU A  40     -14.779  17.485  50.818  0.50 38.37           C  
ATOM    342  C   GLU A  40     -13.583  18.277  51.335  0.50 37.79           C  
ATOM    344  O   GLU A  40     -13.742  19.147  52.187  0.50 37.95           O  
ATOM    346  CB  GLU A  40     -14.929  16.158  51.587  0.50 38.39           C  
ATOM    348  CG  GLU A  40     -16.329  15.536  51.488  0.50 39.10           C  
ATOM    350  CD  GLU A  40     -16.382  14.032  51.811  0.50 39.32           C  
ATOM    352  OE1 GLU A  40     -15.355  13.436  52.226  0.50 39.28           O  
ATOM    354  OE2 GLU A  40     -17.475  13.449  51.637  0.50 40.19           O  
ATOM    356  N   ALA A  41     -12.392  17.968  50.826  1.00 37.28           N  
ATOM    357  CA  ALA A  41     -11.174  18.688  51.191  1.00 36.60           C  
ATOM    358  C   ALA A  41     -11.178  20.119  50.652  1.00 36.01           C  
ATOM    359  O   ALA A  41     -10.852  21.053  51.367  1.00 35.33           O  
ATOM    360  CB  ALA A  41      -9.956  17.949  50.697  1.00 36.42           C  
ATOM    361  N   TRP A  42     -11.542  20.263  49.382  1.00 35.84           N  
ATOM    362  CA  TRP A  42     -11.719  21.564  48.739  1.00 35.79           C  
ATOM    363  C   TRP A  42     -12.685  22.449  49.558  1.00 36.09           C  
ATOM    364  O   TRP A  42     -12.295  23.534  49.970  1.00 36.13           O  
ATOM    365  CB  TRP A  42     -12.233  21.349  47.318  1.00 35.12           C  
ATOM    366  CG  TRP A  42     -12.303  22.545  46.438  1.00 34.47           C  
ATOM    367  CD1 TRP A  42     -12.075  23.869  46.776  1.00 34.33           C  
ATOM    368  CD2 TRP A  42     -12.679  22.544  45.065  1.00 32.78           C  
ATOM    369  NE1 TRP A  42     -12.272  24.678  45.679  1.00 32.13           N  
ATOM    370  CE2 TRP A  42     -12.648  23.891  44.615  1.00 32.96           C  
ATOM    371  CE3 TRP A  42     -13.029  21.534  44.159  1.00 31.55           C  
ATOM    372  CZ2 TRP A  42     -12.962  24.247  43.289  1.00 33.54           C  
ATOM    373  CZ3 TRP A  42     -13.342  21.892  42.845  1.00 32.81           C  
ATOM    374  CH2 TRP A  42     -13.311  23.239  42.428  1.00 33.89           C  
ATOM    375  N   ALA A  43     -13.915  21.974  49.801  1.00 36.16           N  
ATOM    376  CA  ALA A  43     -14.910  22.707  50.589  1.00 36.60           C  
ATOM    377  C   ALA A  43     -14.500  22.982  52.030  1.00 37.30           C  
ATOM    378  O   ALA A  43     -14.953  23.954  52.632  1.00 37.50           O  
ATOM    379  CB  ALA A  43     -16.225  21.972  50.595  1.00 36.63           C  
ATOM    380  N   SER A  44     -13.658  22.121  52.592  1.00 37.77           N  
ATOM    381  CA  SER A  44     -13.336  22.202  54.003  1.00 38.30           C  
ATOM    382  C   SER A  44     -12.573  23.486  54.284  1.00 38.33           C  
ATOM    383  O   SER A  44     -12.324  23.804  55.437  1.00 38.75           O  
ATOM    384  CB  SER A  44     -12.541  20.961  54.485  1.00 38.63           C  
ATOM    385  OG  SER A  44     -11.138  21.099  54.223  1.00 39.29           O  
ATOM    386  N   ALA A  45     -12.198  24.222  53.238  1.00 38.31           N  
ATOM    387  CA  ALA A  45     -11.491  25.488  53.431  1.00 38.65           C  
ATOM    388  C   ALA A  45     -12.363  26.538  54.137  1.00 39.11           C  
ATOM    389  O   ALA A  45     -11.850  27.414  54.844  1.00 39.65           O  
ATOM    390  CB  ALA A  45     -10.951  26.011  52.115  1.00 38.68           C  
ATOM    391  N   ALA A  46     -13.678  26.426  53.982  1.00 39.28           N  
ATOM    392  CA  ALA A  46     -14.611  27.329  54.651  1.00 39.91           C  
ATOM    393  C   ALA A  46     -14.826  26.992  56.149  1.00 40.66           C  
ATOM    394  O   ALA A  46     -15.535  27.723  56.864  1.00 40.33           O  
ATOM    395  CB  ALA A  46     -15.937  27.364  53.894  1.00 39.59           C  
ATOM    396  N   ASP A  47     -14.211  25.885  56.589  1.00 41.42           N  
ATOM    397  CA  ASP A  47     -14.235  25.407  57.978  1.00 42.54           C  
ATOM    398  C   ASP A  47     -13.529  26.357  58.930  1.00 42.82           C  
ATOM    399  O   ASP A  47     -14.072  26.691  59.991  1.00 42.91           O  
ATOM    400  CB  ASP A  47     -13.566  24.025  58.108  1.00 42.77           C  
ATOM    401  CG  ASP A  47     -14.470  22.880  57.684  1.00 43.49           C  
ATOM    402  OD1 ASP A  47     -15.625  23.147  57.293  1.00 44.80           O  
ATOM    403  OD2 ASP A  47     -14.008  21.714  57.735  1.00 44.29           O  
ATOM    404  N   ASP A  48     -12.310  26.760  58.580  0.60 42.82           N  
ATOM    406  CA  ASP A  48     -11.595  27.768  59.351  0.60 43.04           C  
ATOM    408  C   ASP A  48     -12.154  29.136  58.960  0.60 43.41           C  
ATOM    410  O   ASP A  48     -11.655  29.799  58.041  0.60 43.48           O  
ATOM    412  CB  ASP A  48     -10.084  27.676  59.107  0.60 42.84           C  
ATOM    414  CG  ASP A  48      -9.277  28.559  60.050  0.60 42.74           C  
ATOM    416  OD1 ASP A  48      -9.870  29.282  60.891  0.60 41.53           O  
ATOM    418  OD2 ASP A  48      -8.033  28.538  59.928  0.60 42.42           O  
ATOM    420  N   GLU A  49     -13.205  29.532  59.667  1.00 43.65           N  
ATOM    421  CA  GLU A  49     -13.979  30.747  59.362  1.00 44.98           C  
ATOM    422  C   GLU A  49     -13.171  32.041  59.297  1.00 44.42           C  
ATOM    423  O   GLU A  49     -13.315  32.826  58.358  1.00 44.70           O  
ATOM    424  CB  GLU A  49     -15.168  30.881  60.328  1.00 44.78           C  
ATOM    425  CG  GLU A  49     -16.119  29.680  60.230  1.00 46.96           C  
ATOM    426  CD  GLU A  49     -17.409  29.816  61.038  1.00 48.04           C  
ATOM    427  OE1 GLU A  49     -17.709  30.927  61.554  1.00 51.96           O  
ATOM    428  OE2 GLU A  49     -18.124  28.791  61.154  1.00 50.46           O  
ATOM    429  N   ALA A  50     -12.307  32.238  60.284  1.00 44.21           N  
ATOM    430  CA  ALA A  50     -11.454  33.421  60.351  1.00 43.65           C  
ATOM    431  C   ALA A  50     -10.487  33.526  59.163  1.00 42.67           C  
ATOM    432  O   ALA A  50     -10.276  34.614  58.606  1.00 42.72           O  
ATOM    433  CB  ALA A  50     -10.692  33.459  61.698  1.00 43.61           C  
ATOM    434  N   LYS A  51      -9.919  32.389  58.786  1.00 41.65           N  
ATOM    435  CA  LYS A  51      -8.913  32.294  57.724  1.00 40.96           C  
ATOM    436  C   LYS A  51      -9.562  32.320  56.325  1.00 39.66           C  
ATOM    437  O   LYS A  51      -9.004  32.881  55.376  1.00 39.38           O  
ATOM    438  CB  LYS A  51      -8.080  31.021  57.949  1.00 40.76           C  
ATOM    439  CG  LYS A  51      -6.987  30.745  56.932  1.00 42.17           C  
ATOM    440  CD  LYS A  51      -6.242  29.450  57.267  1.00 43.27           C  
ATOM    441  CE  LYS A  51      -5.601  28.832  56.006  1.00 47.25           C  
ATOM    442  NZ  LYS A  51      -4.716  29.843  55.308  1.00 50.00           N  
ATOM    443  N   PHE A  52     -10.735  31.710  56.200  1.00 38.40           N  
ATOM    444  CA  PHE A  52     -11.552  31.876  54.990  1.00 37.63           C  
ATOM    445  C   PHE A  52     -11.934  33.357  54.773  1.00 36.73           C  
ATOM    446  O   PHE A  52     -11.767  33.888  53.686  1.00 36.47           O  
ATOM    447  CB  PHE A  52     -12.803  30.990  55.031  1.00 37.19           C  
ATOM    448  CG  PHE A  52     -13.565  30.958  53.734  1.00 37.30           C  
ATOM    449  CD1 PHE A  52     -13.113  30.180  52.663  1.00 37.10           C  
ATOM    450  CD2 PHE A  52     -14.730  31.707  53.576  1.00 36.95           C  
ATOM    451  CE1 PHE A  52     -13.806  30.157  51.446  1.00 35.87           C  
ATOM    452  CE2 PHE A  52     -15.438  31.684  52.359  1.00 38.06           C  
ATOM    453  CZ  PHE A  52     -14.972  30.910  51.297  1.00 36.47           C  
ATOM    454  N   ALA A  53     -12.431  34.006  55.825  1.00 35.92           N  
ATOM    455  CA  ALA A  53     -12.773  35.419  55.791  1.00 35.12           C  
ATOM    456  C   ALA A  53     -11.550  36.325  55.556  1.00 34.48           C  
ATOM    457  O   ALA A  53     -11.629  37.266  54.797  1.00 34.28           O  
ATOM    458  CB  ALA A  53     -13.523  35.808  57.070  1.00 35.66           C  
ATOM    459  N   ALA A  54     -10.412  36.020  56.171  1.00 34.06           N  
ATOM    460  CA  ALA A  54      -9.181  36.800  55.950  1.00 33.85           C  
ATOM    461  C   ALA A  54      -8.686  36.774  54.501  1.00 33.90           C  
ATOM    462  O   ALA A  54      -8.172  37.783  53.990  1.00 34.25           O  
ATOM    463  CB  ALA A  54      -8.064  36.371  56.912  1.00 33.24           C  
ATOM    464  N   ARG A  55      -8.820  35.629  53.842  1.00 33.96           N  
ATOM    465  CA  ARG A  55      -8.391  35.495  52.450  1.00 34.34           C  
ATOM    466  C   ARG A  55      -9.241  36.416  51.562  1.00 34.29           C  
ATOM    467  O   ARG A  55      -8.733  37.072  50.680  1.00 34.78           O  
ATOM    468  CB  ARG A  55      -8.492  34.025  52.007  1.00 34.68           C  
ATOM    469  CG  ARG A  55      -8.081  33.722  50.578  1.00 35.57           C  
ATOM    470  CD  ARG A  55      -8.441  32.281  50.275  1.00 40.90           C  
ATOM    471  NE  ARG A  55      -8.099  31.861  48.909  1.00 45.58           N  
ATOM    472  CZ  ARG A  55      -8.257  30.620  48.441  1.00 47.88           C  
ATOM    473  NH1 ARG A  55      -8.754  29.663  49.221  1.00 48.53           N  
ATOM    474  NH2 ARG A  55      -7.925  30.329  47.188  1.00 48.62           N  
ATOM    475  N   LEU A  56     -10.536  36.453  51.833  1.00 34.57           N  
ATOM    476  CA  LEU A  56     -11.495  37.287  51.148  1.00 34.41           C  
ATOM    477  C   LEU A  56     -11.286  38.777  51.403  1.00 34.57           C  
ATOM    478  O   LEU A  56     -11.216  39.567  50.461  1.00 35.11           O  
ATOM    479  CB  LEU A  56     -12.902  36.877  51.604  1.00 34.47           C  
ATOM    480  CG  LEU A  56     -13.683  35.950  50.655  1.00 35.23           C  
ATOM    481  CD1 LEU A  56     -12.768  34.987  50.045  1.00 35.53           C  
ATOM    482  CD2 LEU A  56     -14.775  35.211  51.363  1.00 34.15           C  
ATOM    483  N   SER A  57     -11.189  39.157  52.674  1.00 34.27           N  
ATOM    484  CA  SER A  57     -11.131  40.560  53.076  1.00 34.48           C  
ATOM    485  C   SER A  57      -9.804  41.220  52.717  1.00 33.71           C  
ATOM    486  O   SER A  57      -9.728  42.435  52.578  1.00 33.48           O  
ATOM    487  CB  SER A  57     -11.427  40.708  54.580  1.00 34.40           C  
ATOM    488  OG  SER A  57     -10.319  40.278  55.361  1.00 35.88           O  
ATOM    489  N   GLY A  58      -8.769  40.404  52.548  1.00 33.87           N  
ATOM    490  CA  GLY A  58      -7.434  40.897  52.230  1.00 33.54           C  
ATOM    491  C   GLY A  58      -7.143  40.848  50.741  1.00 33.72           C  
ATOM    492  O   GLY A  58      -6.040  41.198  50.302  1.00 33.50           O  
ATOM    493  N   GLN A  59      -8.140  40.409  49.968  1.00 33.65           N  
ATOM    494  CA  GLN A  59      -8.088  40.424  48.506  1.00 33.35           C  
ATOM    495  C   GLN A  59      -9.139  41.397  47.956  1.00 32.83           C  
ATOM    496  O   GLN A  59      -9.830  42.079  48.720  1.00 32.75           O  
ATOM    497  CB  GLN A  59      -8.287  39.009  47.971  1.00 33.32           C  
ATOM    498  CG  GLN A  59      -7.043  38.119  48.157  1.00 34.54           C  
ATOM    499  CD  GLN A  59      -7.298  36.623  47.926  1.00 33.84           C  
ATOM    500  OE1 GLN A  59      -8.324  36.215  47.353  1.00 35.14           O  
ATOM    501  NE2 GLN A  59      -6.367  35.800  48.393  1.00 33.46           N  
ATOM    502  N   LEU A  60      -9.245  41.497  46.640  1.00 32.38           N  
ATOM    503  CA  LEU A  60     -10.337  42.283  46.052  1.00 32.19           C  
ATOM    504  C   LEU A  60     -11.482  41.347  45.678  1.00 32.22           C  
ATOM    505  O   LEU A  60     -11.431  40.665  44.659  1.00 32.26           O  
ATOM    506  CB  LEU A  60      -9.867  43.133  44.859  1.00 31.53           C  
ATOM    507  CG  LEU A  60      -8.644  44.056  44.999  1.00 32.02           C  
ATOM    508  CD1 LEU A  60      -8.523  44.917  43.742  1.00 32.23           C  
ATOM    509  CD2 LEU A  60      -8.706  44.964  46.239  1.00 31.61           C  
ATOM    510  N   THR A  61     -12.500  41.322  46.533  1.00 32.46           N  
ATOM    511  CA  THR A  61     -13.568  40.330  46.483  1.00 32.25           C  
ATOM    512  C   THR A  61     -14.908  40.998  46.208  1.00 32.34           C  
ATOM    513  O   THR A  61     -15.338  41.886  46.941  1.00 32.44           O  
ATOM    514  CB  THR A  61     -13.641  39.497  47.823  1.00 32.32           C  
ATOM    515  OG1 THR A  61     -12.350  38.982  48.124  1.00 30.67           O  
ATOM    516  CG2 THR A  61     -14.622  38.329  47.715  1.00 31.33           C  
ATOM    517  N   LEU A  62     -15.554  40.551  45.141  1.00 32.18           N  
ATOM    518  CA  LEU A  62     -16.828  41.094  44.707  1.00 32.27           C  
ATOM    519  C   LEU A  62     -17.906  40.046  44.883  1.00 32.22           C  
ATOM    520  O   LEU A  62     -17.655  38.861  44.677  1.00 31.83           O  
ATOM    521  CB  LEU A  62     -16.749  41.523  43.230  1.00 32.14           C  
ATOM    522  CG  LEU A  62     -15.927  42.775  42.852  1.00 31.70           C  
ATOM    523  CD1 LEU A  62     -15.613  42.814  41.347  1.00 27.72           C  
ATOM    524  CD2 LEU A  62     -16.673  44.039  43.304  1.00 27.72           C  
ATOM    525  N   ILE A  63     -19.104  40.495  45.251  1.00 32.70           N  
ATOM    526  CA  ILE A  63     -20.256  39.634  45.409  1.00 32.91           C  
ATOM    527  C   ILE A  63     -21.312  39.967  44.361  1.00 33.85           C  
ATOM    528  O   ILE A  63     -21.711  41.121  44.227  1.00 33.99           O  
ATOM    529  CB  ILE A  63     -20.851  39.772  46.814  1.00 32.86           C  
ATOM    530  CG1 ILE A  63     -19.883  39.184  47.840  1.00 32.75           C  
ATOM    531  CG2 ILE A  63     -22.220  39.081  46.898  1.00 32.03           C  
ATOM    532  CD1 ILE A  63     -20.424  39.148  49.224  1.00 33.40           C  
ATOM    533  N   ALA A  64     -21.750  38.953  43.612  1.00 34.87           N  
ATOM    534  CA  ALA A  64     -22.831  39.118  42.643  1.00 35.44           C  
ATOM    535  C   ALA A  64     -24.171  38.908  43.334  1.00 36.63           C  
ATOM    536  O   ALA A  64     -24.360  37.931  44.073  1.00 36.75           O  
ATOM    537  CB  ALA A  64     -22.673  38.175  41.480  1.00 34.44           C  
ATOM    538  N   THR A  65     -25.093  39.844  43.104  1.00 37.87           N  
ATOM    539  CA  THR A  65     -26.444  39.759  43.657  1.00 38.98           C  
ATOM    540  C   THR A  65     -27.521  39.662  42.561  1.00 39.68           C  
ATOM    541  O   THR A  65     -27.333  40.133  41.437  1.00 39.66           O  
ATOM    542  CB  THR A  65     -26.751  40.906  44.695  1.00 38.71           C  
ATOM    543  OG1 THR A  65     -26.178  42.141  44.255  1.00 41.54           O  
ATOM    544  CG2 THR A  65     -26.148  40.605  46.028  1.00 38.11           C  
ATOM    545  N   LEU A  66     -28.620  38.982  42.885  1.00 41.04           N  
ATOM    546  CA  LEU A  66     -29.851  39.031  42.091  1.00 42.09           C  
ATOM    547  C   LEU A  66     -30.967  39.267  43.097  1.00 43.52           C  
ATOM    548  O   LEU A  66     -31.001  38.603  44.136  1.00 43.94           O  
ATOM    549  CB  LEU A  66     -30.087  37.740  41.316  1.00 41.78           C  
ATOM    550  CG  LEU A  66     -29.066  37.352  40.241  1.00 41.17           C  
ATOM    551  CD1 LEU A  66     -29.336  35.932  39.781  1.00 39.88           C  
ATOM    552  CD2 LEU A  66     -29.066  38.323  39.057  1.00 39.60           C  
ATOM    553  N   GLN A  67     -31.850  40.232  42.801  1.00 44.49           N  
ATOM    554  CA  GLN A  67     -32.826  40.797  43.770  1.00 45.21           C  
ATOM    555  C   GLN A  67     -32.222  41.032  45.146  1.00 44.80           C  
ATOM    556  O   GLN A  67     -32.871  40.809  46.166  1.00 45.60           O  
ATOM    557  CB  GLN A  67     -34.135  39.979  43.893  1.00 45.60           C  
ATOM    558  CG  GLN A  67     -34.455  38.977  42.768  1.00 49.19           C  
ATOM    559  CD  GLN A  67     -34.158  39.502  41.369  1.00 53.71           C  
ATOM    560  OE1 GLN A  67     -33.648  38.768  40.519  1.00 56.62           O  
ATOM    561  NE2 GLN A  67     -34.465  40.775  41.127  1.00 54.02           N  
ATOM    562  N   GLY A  68     -30.975  41.489  45.171  1.00 44.70           N  
ATOM    563  CA  GLY A  68     -30.253  41.753  46.421  1.00 43.76           C  
ATOM    564  C   GLY A  68     -29.865  40.511  47.212  1.00 43.34           C  
ATOM    565  O   GLY A  68     -29.415  40.621  48.363  1.00 43.60           O  
ATOM    566  N   VAL A  69     -30.049  39.329  46.627  1.00 42.45           N  
ATOM    567  CA  VAL A  69     -29.533  38.108  47.250  1.00 41.80           C  
ATOM    568  C   VAL A  69     -28.197  37.687  46.615  1.00 40.36           C  
ATOM    569  O   VAL A  69     -28.096  37.594  45.388  1.00 39.96           O  
ATOM    570  CB  VAL A  69     -30.583  36.945  47.302  1.00 42.22           C  
ATOM    571  CG1 VAL A  69     -31.085  36.568  45.921  1.00 43.60           C  
ATOM    572  CG2 VAL A  69     -30.006  35.699  48.021  1.00 42.74           C  
ATOM    573  N   PRO A  70     -27.160  37.464  47.450  1.00 39.24           N  
ATOM    574  CA  PRO A  70     -25.871  37.015  46.934  1.00 38.86           C  
ATOM    575  C   PRO A  70     -25.966  35.628  46.284  1.00 38.12           C  
ATOM    576  O   PRO A  70     -26.477  34.682  46.896  1.00 38.28           O  
ATOM    577  CB  PRO A  70     -24.987  36.979  48.188  1.00 38.66           C  
ATOM    578  CG  PRO A  70     -25.668  37.886  49.154  1.00 38.02           C  
ATOM    579  CD  PRO A  70     -27.106  37.629  48.911  1.00 38.98           C  
ATOM    580  N   VAL A  71     -25.475  35.535  45.050  1.00 36.61           N  
ATOM    581  CA  VAL A  71     -25.617  34.344  44.222  1.00 35.62           C  
ATOM    582  C   VAL A  71     -24.265  33.874  43.663  1.00 34.94           C  
ATOM    583  O   VAL A  71     -24.216  32.884  42.937  1.00 34.94           O  
ATOM    584  CB  VAL A  71     -26.604  34.575  43.018  1.00 35.68           C  
ATOM    585  CG1 VAL A  71     -28.009  34.908  43.516  1.00 36.63           C  
ATOM    586  CG2 VAL A  71     -26.108  35.656  42.069  1.00 34.32           C  
ATOM    587  N   GLY A  72     -23.191  34.597  43.996  1.00 33.51           N  
ATOM    588  CA  GLY A  72     -21.860  34.334  43.460  1.00 32.05           C  
ATOM    589  C   GLY A  72     -20.832  35.319  43.979  1.00 31.29           C  
ATOM    590  O   GLY A  72     -21.185  36.414  44.427  1.00 30.76           O  
ATOM    591  N   PHE A  73     -19.559  34.929  43.942  1.00 29.90           N  
ATOM    592  CA  PHE A  73     -18.474  35.839  44.300  1.00 29.60           C  
ATOM    593  C   PHE A  73     -17.166  35.480  43.570  1.00 29.86           C  
ATOM    594  O   PHE A  73     -16.977  34.343  43.079  1.00 30.36           O  
ATOM    595  CB  PHE A  73     -18.266  35.912  45.833  1.00 29.50           C  
ATOM    596  CG  PHE A  73     -17.537  34.724  46.396  1.00 29.81           C  
ATOM    597  CD1 PHE A  73     -18.218  33.521  46.638  1.00 28.78           C  
ATOM    598  CD2 PHE A  73     -16.161  34.783  46.640  1.00 28.99           C  
ATOM    599  CE1 PHE A  73     -17.536  32.415  47.140  1.00 28.95           C  
ATOM    600  CE2 PHE A  73     -15.474  33.686  47.147  1.00 28.43           C  
ATOM    601  CZ  PHE A  73     -16.165  32.499  47.401  1.00 28.19           C  
ATOM    602  N   ALA A  74     -16.275  36.455  43.469  1.00 29.31           N  
ATOM    603  CA  ALA A  74     -14.964  36.203  42.892  1.00 29.46           C  
ATOM    604  C   ALA A  74     -13.931  37.082  43.583  1.00 29.63           C  
ATOM    605  O   ALA A  74     -14.272  38.101  44.180  1.00 29.00           O  
ATOM    606  CB  ALA A  74     -14.973  36.430  41.380  1.00 28.71           C  
ATOM    607  N   SER A  75     -12.669  36.672  43.495  1.00 30.65           N  
ATOM    608  CA  SER A  75     -11.617  37.291  44.269  1.00 31.59           C  
ATOM    609  C   SER A  75     -10.340  37.424  43.479  1.00 33.01           C  
ATOM    610  O   SER A  75      -9.808  36.453  42.936  1.00 32.39           O  
ATOM    611  CB  SER A  75     -11.364  36.495  45.536  1.00 31.41           C  
ATOM    612  OG  SER A  75     -10.884  37.328  46.576  1.00 32.20           O  
ATOM    613  N   LEU A  76      -9.860  38.658  43.401  1.00 35.01           N  
ATOM    614  CA  LEU A  76      -8.572  38.921  42.799  1.00 37.01           C  
ATOM    615  C   LEU A  76      -7.505  38.990  43.897  1.00 38.31           C  
ATOM    616  O   LEU A  76      -7.667  39.714  44.882  1.00 38.16           O  
ATOM    617  CB  LEU A  76      -8.624  40.224  41.990  1.00 37.03           C  
ATOM    618  CG  LEU A  76      -7.329  40.628  41.285  1.00 36.55           C  
ATOM    619  CD1 LEU A  76      -7.205  39.896  39.957  1.00 35.10           C  
ATOM    620  CD2 LEU A  76      -7.356  42.135  41.082  1.00 36.73           C  
ATOM    621  N   LYS A  77      -6.446  38.198  43.740  1.00 40.11           N  
ATOM    622  CA  LYS A  77      -5.277  38.284  44.605  1.00 41.96           C  
ATOM    623  C   LYS A  77      -4.205  39.062  43.869  1.00 42.93           C  
ATOM    624  O   LYS A  77      -3.977  38.843  42.675  1.00 42.85           O  
ATOM    625  CB  LYS A  77      -4.743  36.895  44.976  1.00 42.41           C  
ATOM    626  CG  LYS A  77      -3.479  36.932  45.837  1.00 44.66           C  
ATOM    627  CD  LYS A  77      -3.168  35.581  46.460  1.00 48.38           C  
ATOM    628  CE  LYS A  77      -1.786  35.606  47.109  1.00 52.16           C  
ATOM    629  NZ  LYS A  77      -1.780  34.987  48.483  1.00 53.60           N  
ATOM    630  N   GLY A  78      -3.566  39.985  44.587  1.00 44.35           N  
ATOM    631  CA  GLY A  78      -2.437  40.746  44.059  1.00 45.15           C  
ATOM    632  C   GLY A  78      -2.854  41.478  42.799  1.00 45.75           C  
ATOM    633  O   GLY A  78      -4.045  41.757  42.616  1.00 45.57           O  
ATOM    634  N   PRO A  79      -1.882  41.767  41.906  1.00 45.97           N  
ATOM    635  CA  PRO A  79      -2.207  42.451  40.653  1.00 46.09           C  
ATOM    636  C   PRO A  79      -2.981  41.586  39.629  1.00 45.68           C  
ATOM    637  O   PRO A  79      -3.895  42.094  38.960  1.00 45.71           O  
ATOM    638  CB  PRO A  79      -0.825  42.861  40.110  1.00 46.25           C  
ATOM    639  CG  PRO A  79       0.115  41.837  40.664  1.00 46.21           C  
ATOM    640  CD  PRO A  79      -0.441  41.468  42.025  1.00 46.15           C  
ATOM    641  N   ASP A  80      -2.643  40.300  39.530  1.00 45.05           N  
ATOM    642  CA  ASP A  80      -3.062  39.507  38.370  1.00 44.47           C  
ATOM    643  C   ASP A  80      -3.564  38.076  38.602  1.00 43.46           C  
ATOM    644  O   ASP A  80      -3.657  37.308  37.652  1.00 43.17           O  
ATOM    645  CB  ASP A  80      -1.929  39.484  37.343  1.00 44.87           C  
ATOM    646  CG  ASP A  80      -0.615  38.990  37.926  1.00 46.42           C  
ATOM    647  OD1 ASP A  80      -0.603  38.413  39.048  1.00 45.56           O  
ATOM    648  OD2 ASP A  80       0.420  39.191  37.245  1.00 49.82           O  
ATOM    649  N   HIS A  81      -3.884  37.718  39.839  1.00 42.69           N  
ATOM    650  CA  HIS A  81      -4.417  36.381  40.112  1.00 42.06           C  
ATOM    651  C   HIS A  81      -5.915  36.333  40.358  1.00 40.89           C  
ATOM    652  O   HIS A  81      -6.416  36.943  41.302  1.00 40.22           O  
ATOM    653  CB  HIS A  81      -3.711  35.731  41.294  1.00 42.10           C  
ATOM    654  CG  HIS A  81      -2.290  35.383  41.023  1.00 44.39           C  
ATOM    655  ND1 HIS A  81      -1.269  36.298  41.134  1.00 47.50           N  
ATOM    656  CD2 HIS A  81      -1.715  34.219  40.637  1.00 47.10           C  
ATOM    657  CE1 HIS A  81      -0.123  35.714  40.832  1.00 48.63           C  
ATOM    658  NE2 HIS A  81      -0.367  34.452  40.525  1.00 48.35           N  
ATOM    659  N   ILE A  82      -6.617  35.570  39.528  1.00 40.07           N  
ATOM    660  CA  ILE A  82      -7.991  35.206  39.834  1.00 39.52           C  
ATOM    661  C   ILE A  82      -7.931  34.087  40.850  1.00 39.20           C  
ATOM    662  O   ILE A  82      -7.695  32.935  40.501  1.00 39.52           O  
ATOM    663  CB  ILE A  82      -8.787  34.773  38.588  1.00 39.91           C  
ATOM    664  CG1 ILE A  82      -8.895  35.946  37.601  1.00 39.80           C  
ATOM    665  CG2 ILE A  82     -10.168  34.216  38.988  1.00 38.36           C  
ATOM    666  CD1 ILE A  82      -9.902  35.729  36.515  1.00 42.48           C  
ATOM    667  N   ASP A  83      -8.138  34.445  42.112  1.00 38.47           N  
ATOM    668  CA  ASP A  83      -7.984  33.520  43.221  1.00 37.92           C  
ATOM    669  C   ASP A  83      -9.217  32.640  43.438  1.00 37.79           C  
ATOM    670  O   ASP A  83      -9.089  31.478  43.807  1.00 37.70           O  
ATOM    671  CB  ASP A  83      -7.652  34.290  44.498  1.00 37.52           C  
ATOM    672  CG  ASP A  83      -7.177  33.383  45.623  1.00 37.33           C  
ATOM    673  OD1 ASP A  83      -6.248  32.582  45.394  1.00 37.22           O  
ATOM    674  OD2 ASP A  83      -7.727  33.472  46.737  1.00 36.88           O  
HETATM  675  N   MSE A  84     -10.401  33.200  43.207  1.00 37.69           N  
HETATM  676  CA  MSE A  84     -11.665  32.539  43.504  1.00 38.89           C  
HETATM  677  C   MSE A  84     -12.769  32.983  42.565  1.00 36.84           C  
HETATM  678  O   MSE A  84     -12.845  34.163  42.195  1.00 36.61           O  
HETATM  679  CB  MSE A  84     -12.080  32.814  44.949  1.00 38.43           C  
HETATM  680  CG  MSE A  84     -11.071  32.311  45.962  1.00 40.94           C  
HETATM  681 SE   MSE A  84     -11.675  32.457  47.765  0.70 47.02          SE  
HETATM  682  CE  MSE A  84     -11.611  34.276  47.917  1.00 45.79           C  
ATOM    683  N   LEU A  85     -13.606  32.018  42.182  1.00 35.39           N  
ATOM    684  CA  LEU A  85     -14.794  32.222  41.360  1.00 34.52           C  
ATOM    685  C   LEU A  85     -15.782  31.136  41.739  1.00 34.04           C  
ATOM    686  O   LEU A  85     -15.537  29.967  41.458  1.00 34.12           O  
ATOM    687  CB  LEU A  85     -14.468  32.080  39.874  1.00 34.10           C  
ATOM    688  CG  LEU A  85     -15.331  32.822  38.838  1.00 34.92           C  
ATOM    689  CD1 LEU A  85     -15.432  32.045  37.527  1.00 33.68           C  
ATOM    690  CD2 LEU A  85     -16.715  33.295  39.289  1.00 31.04           C  
ATOM    691  N   TYR A  86     -16.878  31.507  42.390  1.00 33.51           N  
ATOM    692  CA  TYR A  86     -17.873  30.538  42.869  1.00 33.05           C  
ATOM    693  C   TYR A  86     -19.276  31.113  42.717  1.00 33.02           C  
ATOM    694  O   TYR A  86     -19.628  32.109  43.347  1.00 33.38           O  
ATOM    695  CB  TYR A  86     -17.593  30.111  44.330  1.00 32.59           C  
ATOM    696  CG  TYR A  86     -16.258  29.441  44.476  1.00 32.25           C  
ATOM    697  CD1 TYR A  86     -16.128  28.059  44.292  1.00 31.65           C  
ATOM    698  CD2 TYR A  86     -15.105  30.187  44.752  1.00 31.36           C  
ATOM    699  CE1 TYR A  86     -14.878  27.428  44.386  1.00 32.86           C  
ATOM    700  CE2 TYR A  86     -13.846  29.576  44.850  1.00 30.45           C  
ATOM    701  CZ  TYR A  86     -13.740  28.192  44.671  1.00 33.74           C  
ATOM    702  OH  TYR A  86     -12.505  27.566  44.755  1.00 33.96           O  
ATOM    703  N   VAL A  87     -20.057  30.495  41.847  1.00 33.24           N  
ATOM    704  CA  VAL A  87     -21.464  30.836  41.663  1.00 33.72           C  
ATOM    705  C   VAL A  87     -22.301  29.771  42.349  1.00 34.11           C  
ATOM    706  O   VAL A  87     -21.983  28.591  42.252  1.00 34.51           O  
ATOM    707  CB  VAL A  87     -21.820  30.914  40.152  1.00 33.58           C  
ATOM    708  CG1 VAL A  87     -23.335  31.256  39.935  1.00 33.09           C  
ATOM    709  CG2 VAL A  87     -20.903  31.936  39.455  1.00 33.04           C  
ATOM    710  N   HIS A  88     -23.359  30.178  43.044  1.00 34.91           N  
ATOM    711  CA  HIS A  88     -24.255  29.231  43.703  1.00 35.92           C  
ATOM    712  C   HIS A  88     -24.824  28.290  42.644  1.00 36.15           C  
ATOM    713  O   HIS A  88     -25.107  28.747  41.531  1.00 36.51           O  
ATOM    714  CB  HIS A  88     -25.383  29.970  44.441  1.00 36.93           C  
ATOM    715  CG  HIS A  88     -26.114  29.117  45.428  1.00 37.77           C  
ATOM    716  ND1 HIS A  88     -27.230  28.375  45.090  1.00 39.96           N  
ATOM    717  CD2 HIS A  88     -25.861  28.848  46.731  1.00 38.50           C  
ATOM    718  CE1 HIS A  88     -27.641  27.698  46.150  1.00 39.99           C  
ATOM    719  NE2 HIS A  88     -26.834  27.972  47.162  1.00 39.55           N  
ATOM    720  N   PRO A  89     -24.950  26.974  42.958  1.00 36.18           N  
ATOM    721  CA  PRO A  89     -25.464  25.990  41.987  1.00 36.53           C  
ATOM    722  C   PRO A  89     -26.870  26.294  41.436  1.00 36.98           C  
ATOM    723  O   PRO A  89     -27.168  25.960  40.305  1.00 36.99           O  
ATOM    724  CB  PRO A  89     -25.467  24.678  42.771  1.00 36.50           C  
ATOM    725  CG  PRO A  89     -25.301  25.035  44.175  1.00 36.24           C  
ATOM    726  CD  PRO A  89     -24.583  26.328  44.232  1.00 36.17           C  
ATOM    727  N   ASP A  90     -27.709  26.949  42.230  1.00 37.72           N  
ATOM    728  CA  ASP A  90     -29.026  27.369  41.778  1.00 38.22           C  
ATOM    729  C   ASP A  90     -29.024  28.535  40.782  1.00 38.05           C  
ATOM    730  O   ASP A  90     -30.061  28.829  40.196  1.00 37.70           O  
ATOM    731  CB  ASP A  90     -29.924  27.663  42.984  1.00 38.53           C  
ATOM    732  CG  ASP A  90     -30.278  26.393  43.759  1.00 40.30           C  
ATOM    733  OD1 ASP A  90     -30.437  25.339  43.105  1.00 41.81           O  
ATOM    734  OD2 ASP A  90     -30.379  26.433  45.004  1.00 42.40           O  
ATOM    735  N   TYR A  91     -27.867  29.165  40.559  1.00 37.63           N  
ATOM    736  CA  TYR A  91     -27.816  30.355  39.703  1.00 37.48           C  
ATOM    737  C   TYR A  91     -26.805  30.316  38.577  1.00 37.49           C  
ATOM    738  O   TYR A  91     -26.468  31.365  38.001  1.00 37.80           O  
ATOM    739  CB  TYR A  91     -27.620  31.602  40.545  1.00 37.68           C  
ATOM    740  CG  TYR A  91     -28.758  31.811  41.510  1.00 38.19           C  
ATOM    741  CD1 TYR A  91     -29.891  32.531  41.129  1.00 38.10           C  
ATOM    742  CD2 TYR A  91     -28.711  31.274  42.792  1.00 39.29           C  
ATOM    743  CE1 TYR A  91     -30.945  32.721  41.999  1.00 38.32           C  
ATOM    744  CE2 TYR A  91     -29.770  31.449  43.677  1.00 40.18           C  
ATOM    745  CZ  TYR A  91     -30.880  32.174  43.270  1.00 39.30           C  
ATOM    746  OH  TYR A  91     -31.916  32.365  44.152  1.00 40.45           O  
ATOM    747  N   VAL A  92     -26.329  29.116  38.251  1.00 36.98           N  
ATOM    748  CA  VAL A  92     -25.337  28.930  37.183  1.00 36.84           C  
ATOM    749  C   VAL A  92     -26.018  29.061  35.821  1.00 36.89           C  
ATOM    750  O   VAL A  92     -27.239  28.965  35.740  1.00 36.86           O  
ATOM    751  CB  VAL A  92     -24.560  27.566  37.327  1.00 36.82           C  
ATOM    752  CG1 VAL A  92     -23.698  27.587  38.558  1.00 35.05           C  
ATOM    753  CG2 VAL A  92     -25.524  26.373  37.384  1.00 36.55           C  
ATOM    754  N   GLY A  93     -25.243  29.310  34.769  1.00 36.87           N  
ATOM    755  CA  GLY A  93     -25.799  29.523  33.426  1.00 37.67           C  
ATOM    756  C   GLY A  93     -26.590  30.823  33.229  1.00 38.56           C  
ATOM    757  O   GLY A  93     -27.464  30.907  32.360  1.00 39.35           O  
ATOM    758  N   ARG A  94     -26.281  31.847  34.018  1.00 38.21           N  
ATOM    759  CA  ARG A  94     -27.061  33.074  34.034  1.00 37.90           C  
ATOM    760  C   ARG A  94     -26.144  34.274  33.809  1.00 37.68           C  
ATOM    761  O   ARG A  94     -26.518  35.410  34.089  1.00 38.12           O  
ATOM    762  CB  ARG A  94     -27.802  33.188  35.374  1.00 37.76           C  
ATOM    763  CG  ARG A  94     -29.087  32.393  35.406  1.00 39.69           C  
ATOM    764  CD  ARG A  94     -29.497  31.948  36.796  1.00 40.56           C  
ATOM    765  NE  ARG A  94     -30.643  32.680  37.304  1.00 44.35           N  
ATOM    766  CZ  ARG A  94     -31.611  32.174  38.079  1.00 45.32           C  
ATOM    767  NH1 ARG A  94     -31.614  30.890  38.448  1.00 42.62           N  
ATOM    768  NH2 ARG A  94     -32.599  32.972  38.486  1.00 45.53           N  
ATOM    769  N   ASP A  95     -24.942  34.002  33.298  0.60 37.37           N  
ATOM    771  CA  ASP A  95     -23.862  34.988  33.144  0.60 36.62           C  
ATOM    773  C   ASP A  95     -23.386  35.699  34.431  0.60 36.26           C  
ATOM    775  O   ASP A  95     -22.820  36.790  34.372  0.60 36.44           O  
ATOM    777  CB  ASP A  95     -24.168  35.975  32.006  0.60 36.64           C  
ATOM    779  CG  ASP A  95     -24.003  35.347  30.621  0.60 36.85           C  
ATOM    781  OD1 ASP A  95     -24.690  35.807  29.677  0.60 36.58           O  
ATOM    783  OD2 ASP A  95     -23.207  34.385  30.472  0.60 36.27           O  
ATOM    785  N   VAL A  96     -23.610  35.078  35.587  1.00 35.82           N  
ATOM    786  CA  VAL A  96     -23.060  35.576  36.860  1.00 35.12           C  
ATOM    787  C   VAL A  96     -21.513  35.455  36.853  1.00 35.23           C  
ATOM    788  O   VAL A  96     -20.808  36.433  37.100  1.00 35.44           O  
ATOM    789  CB  VAL A  96     -23.642  34.836  38.109  1.00 34.95           C  
ATOM    790  CG1 VAL A  96     -22.930  35.274  39.391  1.00 33.81           C  
ATOM    791  CG2 VAL A  96     -25.141  35.068  38.251  1.00 35.18           C  
ATOM    792  N   GLY A  97     -20.995  34.268  36.536  1.00 34.83           N  
ATOM    793  CA  GLY A  97     -19.549  34.056  36.419  1.00 34.28           C  
ATOM    794  C   GLY A  97     -18.860  35.056  35.503  1.00 34.47           C  
ATOM    795  O   GLY A  97     -17.833  35.650  35.872  1.00 34.27           O  
ATOM    796  N   THR A  98     -19.424  35.233  34.306  1.00 33.52           N  
ATOM    797  CA  THR A  98     -18.903  36.180  33.304  1.00 33.32           C  
ATOM    798  C   THR A  98     -18.863  37.634  33.794  1.00 33.04           C  
ATOM    799  O   THR A  98     -17.866  38.322  33.637  1.00 33.69           O  
ATOM    800  CB  THR A  98     -19.719  36.083  31.975  1.00 33.25           C  
ATOM    801  OG1 THR A  98     -19.563  34.769  31.431  1.00 32.22           O  
ATOM    802  CG2 THR A  98     -19.278  37.115  30.946  1.00 31.72           C  
ATOM    803  N   THR A  99     -19.954  38.088  34.387  1.00 32.98           N  
ATOM    804  CA  THR A  99     -20.033  39.413  34.990  1.00 32.77           C  
ATOM    805  C   THR A  99     -18.941  39.594  36.050  1.00 32.85           C  
ATOM    806  O   THR A  99     -18.237  40.590  36.046  1.00 32.84           O  
ATOM    807  CB  THR A  99     -21.455  39.641  35.598  1.00 32.95           C  
ATOM    808  OG1 THR A  99     -22.432  39.519  34.553  1.00 32.76           O  
ATOM    809  CG2 THR A  99     -21.586  41.015  36.228  1.00 31.62           C  
ATOM    810  N   LEU A 100     -18.788  38.607  36.928  1.00 33.01           N  
ATOM    811  CA  LEU A 100     -17.788  38.661  37.980  1.00 33.49           C  
ATOM    812  C   LEU A 100     -16.380  38.758  37.421  1.00 34.42           C  
ATOM    813  O   LEU A 100     -15.597  39.605  37.862  1.00 34.92           O  
ATOM    814  CB  LEU A 100     -17.897  37.440  38.892  1.00 32.56           C  
ATOM    815  CG  LEU A 100     -18.960  37.448  39.982  1.00 31.83           C  
ATOM    816  CD1 LEU A 100     -19.052  36.038  40.555  1.00 27.99           C  
ATOM    817  CD2 LEU A 100     -18.664  38.537  41.082  1.00 29.24           C  
ATOM    818  N   ILE A 101     -16.068  37.903  36.445  1.00 35.40           N  
ATOM    819  CA  ILE A 101     -14.724  37.854  35.865  1.00 36.15           C  
ATOM    820  C   ILE A 101     -14.384  39.095  35.039  1.00 36.34           C  
ATOM    821  O   ILE A 101     -13.275  39.589  35.133  1.00 36.98           O  
ATOM    822  CB  ILE A 101     -14.446  36.527  35.108  1.00 36.25           C  
ATOM    823  CG1 ILE A 101     -14.517  35.348  36.067  1.00 36.81           C  
ATOM    824  CG2 ILE A 101     -13.064  36.530  34.466  1.00 37.37           C  
ATOM    825  CD1 ILE A 101     -13.815  35.586  37.411  1.00 38.79           C  
ATOM    826  N   ASP A 102     -15.335  39.608  34.261  1.00 36.74           N  
ATOM    827  CA  ASP A 102     -15.170  40.903  33.600  1.00 36.90           C  
ATOM    828  C   ASP A 102     -14.778  42.012  34.599  1.00 37.17           C  
ATOM    829  O   ASP A 102     -13.897  42.830  34.321  1.00 36.95           O  
ATOM    830  CB  ASP A 102     -16.468  41.304  32.894  1.00 37.30           C  
ATOM    831  CG  ASP A 102     -16.784  40.444  31.655  1.00 37.96           C  
ATOM    832  OD1 ASP A 102     -15.894  39.709  31.144  1.00 39.41           O  
ATOM    833  OD2 ASP A 102     -17.950  40.509  31.198  1.00 36.49           O  
ATOM    834  N   ALA A 103     -15.438  42.039  35.757  1.00 37.37           N  
ATOM    835  CA  ALA A 103     -15.119  43.031  36.797  1.00 37.41           C  
ATOM    836  C   ALA A 103     -13.696  42.888  37.316  1.00 37.46           C  
ATOM    837  O   ALA A 103     -13.008  43.893  37.502  1.00 37.49           O  
ATOM    838  CB  ALA A 103     -16.119  42.984  37.931  1.00 36.78           C  
ATOM    839  N   LEU A 104     -13.250  41.643  37.504  1.00 37.61           N  
ATOM    840  CA  LEU A 104     -11.887  41.366  37.948  1.00 37.58           C  
ATOM    841  C   LEU A 104     -10.823  41.755  36.913  1.00 38.33           C  
ATOM    842  O   LEU A 104      -9.769  42.282  37.273  1.00 38.37           O  
ATOM    843  CB  LEU A 104     -11.722  39.910  38.385  1.00 37.07           C  
ATOM    844  CG  LEU A 104     -12.495  39.390  39.614  1.00 37.07           C  
ATOM    845  CD1 LEU A 104     -11.909  38.061  40.057  1.00 34.98           C  
ATOM    846  CD2 LEU A 104     -12.516  40.376  40.784  1.00 34.66           C  
ATOM    847  N   GLU A 105     -11.096  41.512  35.636  1.00 38.93           N  
ATOM    848  CA  GLU A 105     -10.181  41.951  34.569  1.00 39.78           C  
ATOM    849  C   GLU A 105     -10.078  43.480  34.434  1.00 40.19           C  
ATOM    850  O   GLU A 105      -8.996  43.998  34.201  1.00 40.44           O  
ATOM    851  CB  GLU A 105     -10.555  41.307  33.238  1.00 39.32           C  
ATOM    852  CG  GLU A 105     -10.648  39.807  33.359  1.00 40.59           C  
ATOM    853  CD  GLU A 105     -11.056  39.091  32.089  1.00 42.32           C  
ATOM    854  OE1 GLU A 105     -11.444  39.753  31.090  1.00 41.91           O  
ATOM    855  OE2 GLU A 105     -10.982  37.842  32.105  1.00 43.29           O  
ATOM    856  N   LYS A 106     -11.195  44.192  34.580  1.00 40.87           N  
ATOM    857  CA  LYS A 106     -11.199  45.664  34.560  1.00 41.96           C  
ATOM    858  C   LYS A 106     -10.363  46.183  35.733  1.00 42.63           C  
ATOM    859  O   LYS A 106      -9.498  47.040  35.554  1.00 43.12           O  
ATOM    860  CB  LYS A 106     -12.643  46.190  34.640  1.00 41.98           C  
ATOM    861  CG  LYS A 106     -12.829  47.715  34.665  1.00 42.11           C  
ATOM    862  CD  LYS A 106     -14.340  48.033  34.657  1.00 42.65           C  
ATOM    863  CE  LYS A 106     -14.661  49.537  34.611  1.00 43.62           C  
ATOM    864  NZ  LYS A 106     -14.679  50.123  33.223  1.00 44.72           N  
ATOM    865  N   LEU A 107     -10.626  45.622  36.916  1.00 42.93           N  
ATOM    866  CA  LEU A 107      -9.926  45.932  38.150  1.00 43.29           C  
ATOM    867  C   LEU A 107      -8.429  45.660  38.034  1.00 43.47           C  
ATOM    868  O   LEU A 107      -7.621  46.437  38.535  1.00 43.63           O  
ATOM    869  CB  LEU A 107     -10.502  45.073  39.280  1.00 43.28           C  
ATOM    870  CG  LEU A 107     -10.860  45.600  40.660  1.00 43.11           C  
ATOM    871  CD1 LEU A 107     -11.424  47.023  40.643  1.00 43.07           C  
ATOM    872  CD2 LEU A 107     -11.866  44.636  41.264  1.00 42.50           C  
ATOM    873  N   ALA A 108      -8.071  44.557  37.383  1.00 43.37           N  
ATOM    874  CA  ALA A 108      -6.675  44.167  37.240  1.00 43.78           C  
ATOM    875  C   ALA A 108      -5.943  45.000  36.170  1.00 44.35           C  
ATOM    876  O   ALA A 108      -4.790  45.385  36.357  1.00 44.46           O  
ATOM    877  CB  ALA A 108      -6.565  42.685  36.952  1.00 42.91           C  
ATOM    878  N   GLY A 109      -6.606  45.272  35.052  1.00 45.25           N  
ATOM    879  CA  GLY A 109      -6.077  46.201  34.051  1.00 46.54           C  
ATOM    880  C   GLY A 109      -5.797  47.563  34.670  1.00 47.70           C  
ATOM    881  O   GLY A 109      -4.713  48.112  34.503  1.00 47.76           O  
ATOM    882  N   ALA A 110      -6.760  48.089  35.428  1.00 48.80           N  
ATOM    883  CA  ALA A 110      -6.590  49.370  36.135  1.00 49.95           C  
ATOM    884  C   ALA A 110      -5.491  49.379  37.209  1.00 50.61           C  
ATOM    885  O   ALA A 110      -5.243  50.412  37.822  1.00 51.08           O  
ATOM    886  CB  ALA A 110      -7.923  49.831  36.736  1.00 49.52           C  
ATOM    887  N   ARG A 111      -4.848  48.233  37.434  0.60 51.18           N  
ATOM    889  CA  ARG A 111      -3.746  48.100  38.405  0.60 51.86           C  
ATOM    891  C   ARG A 111      -2.404  47.740  37.740  0.60 52.20           C  
ATOM    893  O   ARG A 111      -1.488  47.235  38.398  0.60 52.33           O  
ATOM    895  CB  ARG A 111      -4.068  47.023  39.446  0.60 51.89           C  
ATOM    897  CG  ARG A 111      -5.172  47.353  40.425  0.60 53.20           C  
ATOM    899  CD  ARG A 111      -5.531  46.113  41.238  0.60 54.74           C  
ATOM    901  NE  ARG A 111      -4.955  46.107  42.588  0.60 56.87           N  
ATOM    903  CZ  ARG A 111      -3.696  45.787  42.890  0.60 57.80           C  
ATOM    905  NH1 ARG A 111      -2.829  45.462  41.939  0.60 58.34           N  
ATOM    907  NH2 ARG A 111      -3.299  45.803  44.155  0.60 57.36           N  
ATOM    909  N   GLY A 112      -2.295  47.984  36.437  1.00 52.41           N  
ATOM    910  CA  GLY A 112      -1.083  47.667  35.696  1.00 52.97           C  
ATOM    911  C   GLY A 112      -1.083  46.353  34.947  1.00 53.38           C  
ATOM    912  O   GLY A 112      -0.547  46.277  33.835  1.00 53.98           O  
ATOM    913  N   ALA A 113      -1.693  45.330  35.540  1.00 53.35           N  
ATOM    914  CA  ALA A 113      -1.596  43.956  35.038  1.00 53.42           C  
ATOM    915  C   ALA A 113      -1.794  43.830  33.530  1.00 53.29           C  
ATOM    916  O   ALA A 113      -2.646  44.485  32.937  1.00 53.26           O  
ATOM    917  CB  ALA A 113      -2.553  43.023  35.801  1.00 53.59           C  
ATOM    918  N   LEU A 114      -0.981  42.987  32.916  1.00 53.65           N  
ATOM    919  CA  LEU A 114      -1.059  42.779  31.480  1.00 54.21           C  
ATOM    920  C   LEU A 114      -1.480  41.345  31.206  1.00 53.87           C  
ATOM    921  O   LEU A 114      -2.111  41.050  30.189  1.00 53.94           O  
ATOM    922  CB  LEU A 114       0.294  43.085  30.827  1.00 54.57           C  
ATOM    923  CG  LEU A 114       1.039  44.343  31.304  1.00 55.82           C  
ATOM    924  CD1 LEU A 114       2.551  44.243  31.041  1.00 57.03           C  
ATOM    925  CD2 LEU A 114       0.452  45.605  30.675  1.00 55.80           C  
ATOM    926  N   ILE A 115      -1.124  40.462  32.136  1.00 53.61           N  
ATOM    927  CA  ILE A 115      -1.411  39.030  32.028  1.00 53.29           C  
ATOM    928  C   ILE A 115      -2.134  38.570  33.296  1.00 52.34           C  
ATOM    929  O   ILE A 115      -1.505  38.409  34.352  1.00 52.76           O  
ATOM    930  CB  ILE A 115      -0.104  38.185  31.773  1.00 53.53           C  
ATOM    931  CG1 ILE A 115       0.620  38.658  30.497  1.00 53.83           C  
ATOM    932  CG2 ILE A 115      -0.420  36.676  31.696  1.00 53.63           C  
ATOM    933  CD1 ILE A 115       2.141  38.475  30.511  1.00 53.93           C  
ATOM    934  N   LEU A 116      -3.455  38.402  33.190  1.00 50.99           N  
ATOM    935  CA  LEU A 116      -4.260  37.782  34.242  1.00 49.64           C  
ATOM    936  C   LEU A 116      -4.016  36.275  34.289  1.00 48.37           C  
ATOM    937  O   LEU A 116      -3.840  35.620  33.253  1.00 48.40           O  
ATOM    938  CB  LEU A 116      -5.760  38.050  34.039  1.00 50.02           C  
ATOM    939  CG  LEU A 116      -6.486  39.052  34.957  1.00 51.60           C  
ATOM    940  CD1 LEU A 116      -7.932  38.644  35.143  1.00 52.62           C  
ATOM    941  CD2 LEU A 116      -5.872  39.154  36.341  1.00 52.57           C  
ATOM    942  N   THR A 117      -4.012  35.715  35.490  1.00 46.40           N  
ATOM    943  CA  THR A 117      -3.763  34.287  35.632  1.00 44.35           C  
ATOM    944  C   THR A 117      -4.737  33.641  36.621  1.00 42.99           C  
ATOM    945  O   THR A 117      -5.181  34.282  37.567  1.00 42.71           O  
ATOM    946  CB  THR A 117      -2.265  33.989  35.933  1.00 43.99           C  
ATOM    947  OG1 THR A 117      -2.075  32.586  36.127  1.00 44.59           O  
ATOM    948  CG2 THR A 117      -1.785  34.737  37.166  1.00 44.62           C  
ATOM    949  N   VAL A 118      -5.088  32.384  36.354  1.00 41.28           N  
ATOM    950  CA  VAL A 118      -5.996  31.597  37.183  1.00 39.60           C  
ATOM    951  C   VAL A 118      -5.500  30.153  37.196  1.00 38.94           C  
ATOM    952  O   VAL A 118      -5.008  29.671  36.193  1.00 38.25           O  
ATOM    953  CB  VAL A 118      -7.493  31.694  36.698  1.00 39.42           C  
ATOM    954  CG1 VAL A 118      -7.698  31.124  35.280  1.00 38.97           C  
ATOM    955  CG2 VAL A 118      -8.440  31.022  37.675  1.00 38.59           C  
ATOM    956  N   ASP A 119      -5.587  29.497  38.353  1.00 38.44           N  
ATOM    957  CA  ASP A 119      -5.413  28.052  38.452  1.00 37.58           C  
ATOM    958  C   ASP A 119      -6.810  27.430  38.427  1.00 37.26           C  
ATOM    959  O   ASP A 119      -7.444  27.254  39.475  1.00 36.61           O  
ATOM    960  CB  ASP A 119      -4.686  27.680  39.752  1.00 37.82           C  
ATOM    961  CG  ASP A 119      -3.207  28.046  39.730  1.00 38.26           C  
ATOM    962  OD1 ASP A 119      -2.604  28.094  38.638  1.00 37.45           O  
ATOM    963  OD2 ASP A 119      -2.638  28.281  40.820  1.00 39.57           O  
ATOM    964  N   ALA A 120      -7.279  27.107  37.220  1.00 37.02           N  
ATOM    965  CA  ALA A 120      -8.676  26.744  37.006  1.00 36.99           C  
ATOM    966  C   ALA A 120      -8.928  25.300  37.367  1.00 36.91           C  
ATOM    967  O   ALA A 120      -8.164  24.431  36.968  1.00 36.94           O  
ATOM    968  CB  ALA A 120      -9.071  26.995  35.546  1.00 36.94           C  
ATOM    969  N   SER A 121      -9.995  25.051  38.121  1.00 36.98           N  
ATOM    970  CA  SER A 121     -10.489  23.697  38.360  1.00 37.31           C  
ATOM    971  C   SER A 121     -10.959  23.069  37.043  1.00 37.59           C  
ATOM    972  O   SER A 121     -11.305  23.780  36.106  1.00 37.62           O  
ATOM    973  CB  SER A 121     -11.626  23.721  39.373  1.00 37.57           C  
ATOM    974  OG  SER A 121     -12.751  24.423  38.864  1.00 37.62           O  
ATOM    975  N   ASP A 122     -10.948  21.737  36.970  1.00 37.84           N  
ATOM    976  CA  ASP A 122     -11.194  21.020  35.718  1.00 37.47           C  
ATOM    977  C   ASP A 122     -12.572  21.303  35.144  1.00 37.66           C  
ATOM    978  O   ASP A 122     -12.755  21.298  33.933  1.00 37.90           O  
ATOM    979  CB  ASP A 122     -11.006  19.508  35.910  1.00 37.47           C  
ATOM    980  CG  ASP A 122      -9.536  19.104  36.142  1.00 38.34           C  
ATOM    981  OD1 ASP A 122      -8.638  19.987  36.186  1.00 37.86           O  
ATOM    982  OD2 ASP A 122      -9.281  17.886  36.277  1.00 38.71           O  
ATOM    983  N   ASN A 123     -13.534  21.561  36.023  1.00 37.71           N  
ATOM    984  CA  ASN A 123     -14.912  21.863  35.633  1.00 37.93           C  
ATOM    985  C   ASN A 123     -15.107  23.298  35.114  1.00 38.44           C  
ATOM    986  O   ASN A 123     -16.039  23.554  34.338  1.00 38.28           O  
ATOM    987  CB  ASN A 123     -15.850  21.596  36.804  1.00 37.42           C  
ATOM    988  CG  ASN A 123     -15.380  22.261  38.080  1.00 37.94           C  
ATOM    989  OD1 ASN A 123     -14.260  22.021  38.545  1.00 36.97           O  
ATOM    990  ND2 ASN A 123     -16.229  23.108  38.651  1.00 37.32           N  
ATOM    991  N   ALA A 124     -14.229  24.214  35.539  1.00 37.96           N  
ATOM    992  CA  ALA A 124     -14.261  25.602  35.109  1.00 38.17           C  
ATOM    993  C   ALA A 124     -13.259  25.847  33.985  1.00 38.87           C  
ATOM    994  O   ALA A 124     -13.191  26.933  33.425  1.00 39.58           O  
ATOM    995  CB  ALA A 124     -13.977  26.517  36.271  1.00 37.66           C  
ATOM    996  N   ALA A 125     -12.479  24.834  33.646  1.00 39.65           N  
ATOM    997  CA  ALA A 125     -11.492  24.964  32.575  1.00 40.45           C  
ATOM    998  C   ALA A 125     -12.073  25.513  31.247  1.00 40.75           C  
ATOM    999  O   ALA A 125     -11.502  26.419  30.639  1.00 40.79           O  
ATOM   1000  CB  ALA A 125     -10.795  23.623  32.352  1.00 40.28           C  
ATOM   1001  N   GLU A 126     -13.195  24.949  30.807  1.00 41.26           N  
ATOM   1002  CA  GLU A 126     -13.832  25.330  29.536  1.00 42.01           C  
ATOM   1003  C   GLU A 126     -14.384  26.756  29.593  1.00 40.86           C  
ATOM   1004  O   GLU A 126     -14.138  27.548  28.682  1.00 41.30           O  
ATOM   1005  CB  GLU A 126     -14.917  24.321  29.161  1.00 42.69           C  
ATOM   1006  CG  GLU A 126     -15.693  24.626  27.892  1.00 48.30           C  
ATOM   1007  CD  GLU A 126     -14.919  24.341  26.592  1.00 54.61           C  
ATOM   1008  OE1 GLU A 126     -13.787  24.873  26.404  1.00 56.24           O  
ATOM   1009  OE2 GLU A 126     -15.478  23.601  25.732  1.00 57.18           O  
ATOM   1010  N   PHE A 127     -15.087  27.072  30.682  1.00 39.77           N  
ATOM   1011  CA  PHE A 127     -15.511  28.425  31.012  1.00 38.54           C  
ATOM   1012  C   PHE A 127     -14.425  29.445  30.773  1.00 38.28           C  
ATOM   1013  O   PHE A 127     -14.666  30.424  30.070  1.00 38.23           O  
ATOM   1014  CB  PHE A 127     -15.972  28.545  32.472  1.00 38.78           C  
ATOM   1015  CG  PHE A 127     -16.210  29.986  32.915  1.00 38.27           C  
ATOM   1016  CD1 PHE A 127     -17.467  30.588  32.748  1.00 39.20           C  
ATOM   1017  CD2 PHE A 127     -15.188  30.737  33.463  1.00 37.92           C  
ATOM   1018  CE1 PHE A 127     -17.693  31.905  33.124  1.00 37.11           C  
ATOM   1019  CE2 PHE A 127     -15.399  32.063  33.842  1.00 38.99           C  
ATOM   1020  CZ  PHE A 127     -16.662  32.644  33.672  1.00 38.99           C  
ATOM   1021  N   PHE A 128     -13.241  29.234  31.365  1.00 37.67           N  
ATOM   1022  CA  PHE A 128     -12.138  30.197  31.226  1.00 36.98           C  
ATOM   1023  C   PHE A 128     -11.586  30.263  29.818  1.00 37.80           C  
ATOM   1024  O   PHE A 128     -11.234  31.351  29.348  1.00 38.02           O  
ATOM   1025  CB  PHE A 128     -11.005  29.952  32.239  1.00 35.89           C  
ATOM   1026  CG  PHE A 128     -11.311  30.453  33.637  1.00 33.76           C  
ATOM   1027  CD1 PHE A 128     -11.229  31.809  33.940  1.00 30.92           C  
ATOM   1028  CD2 PHE A 128     -11.690  29.563  34.647  1.00 30.82           C  
ATOM   1029  CE1 PHE A 128     -11.519  32.273  35.241  1.00 30.78           C  
ATOM   1030  CE2 PHE A 128     -11.980  30.012  35.943  1.00 29.81           C  
ATOM   1031  CZ  PHE A 128     -11.895  31.368  36.243  1.00 30.01           C  
ATOM   1032  N   ALA A 129     -11.506  29.110  29.147  1.00 38.66           N  
ATOM   1033  CA  ALA A 129     -10.982  29.043  27.782  1.00 39.72           C  
ATOM   1034  C   ALA A 129     -11.825  29.868  26.799  1.00 40.58           C  
ATOM   1035  O   ALA A 129     -11.272  30.517  25.923  1.00 39.85           O  
ATOM   1036  CB  ALA A 129     -10.870  27.594  27.319  1.00 39.81           C  
ATOM   1037  N   LYS A 130     -13.154  29.854  26.973  1.00 42.08           N  
ATOM   1038  CA  LYS A 130     -14.073  30.644  26.140  1.00 43.72           C  
ATOM   1039  C   LYS A 130     -13.931  32.169  26.339  1.00 44.46           C  
ATOM   1040  O   LYS A 130     -14.548  32.954  25.605  1.00 44.94           O  
ATOM   1041  CB  LYS A 130     -15.544  30.263  26.402  1.00 43.75           C  
ATOM   1042  CG  LYS A 130     -15.922  28.789  26.291  1.00 46.05           C  
ATOM   1043  CD  LYS A 130     -16.115  28.347  24.851  1.00 49.92           C  
ATOM   1044  CE  LYS A 130     -17.357  27.478  24.685  1.00 52.66           C  
ATOM   1045  NZ  LYS A 130     -17.336  26.189  25.446  1.00 54.18           N  
ATOM   1046  N   ARG A 131     -13.167  32.584  27.353  1.00 44.96           N  
ATOM   1047  CA  ARG A 131     -12.992  34.002  27.668  1.00 45.06           C  
ATOM   1048  C   ARG A 131     -11.530  34.347  27.464  1.00 45.30           C  
ATOM   1049  O   ARG A 131     -11.000  35.262  28.086  1.00 45.44           O  
ATOM   1050  CB  ARG A 131     -13.408  34.326  29.109  1.00 45.23           C  
ATOM   1051  CG  ARG A 131     -14.644  33.600  29.652  1.00 46.42           C  
ATOM   1052  CD  ARG A 131     -15.905  34.053  28.938  1.00 48.46           C  
ATOM   1053  NE  ARG A 131     -17.167  33.669  29.581  1.00 49.85           N  
ATOM   1054  CZ  ARG A 131     -17.667  32.430  29.608  1.00 51.31           C  
ATOM   1055  NH1 ARG A 131     -16.996  31.410  29.096  1.00 49.41           N  
ATOM   1056  NH2 ARG A 131     -18.840  32.198  30.184  1.00 53.09           N  
ATOM   1057  N   GLY A 132     -10.873  33.590  26.598  1.00 45.42           N  
ATOM   1058  CA  GLY A 132      -9.525  33.922  26.165  1.00 45.58           C  
ATOM   1059  C   GLY A 132      -8.387  33.477  27.061  1.00 45.26           C  
ATOM   1060  O   GLY A 132      -7.239  33.836  26.809  1.00 45.70           O  
ATOM   1061  N   TYR A 133      -8.685  32.707  28.104  1.00 45.09           N  
ATOM   1062  CA  TYR A 133      -7.629  32.114  28.936  1.00 44.66           C  
ATOM   1063  C   TYR A 133      -7.037  30.885  28.258  1.00 45.10           C  
ATOM   1064  O   TYR A 133      -7.774  30.015  27.760  1.00 44.89           O  
ATOM   1065  CB  TYR A 133      -8.154  31.757  30.329  1.00 44.06           C  
ATOM   1066  CG  TYR A 133      -8.464  32.974  31.163  1.00 43.21           C  
ATOM   1067  CD1 TYR A 133      -9.611  33.740  30.912  1.00 42.08           C  
ATOM   1068  CD2 TYR A 133      -7.616  33.364  32.201  1.00 40.89           C  
ATOM   1069  CE1 TYR A 133      -9.891  34.866  31.669  1.00 41.99           C  
ATOM   1070  CE2 TYR A 133      -7.892  34.479  32.964  1.00 40.61           C  
ATOM   1071  CZ  TYR A 133      -9.027  35.223  32.693  1.00 42.44           C  
ATOM   1072  OH  TYR A 133      -9.303  36.335  33.434  1.00 43.45           O  
ATOM   1073  N   VAL A 134      -5.707  30.815  28.247  1.00 45.39           N  
ATOM   1074  CA  VAL A 134      -5.009  29.749  27.551  1.00 45.95           C  
ATOM   1075  C   VAL A 134      -4.248  28.882  28.535  1.00 46.25           C  
ATOM   1076  O   VAL A 134      -3.447  29.389  29.319  1.00 46.33           O  
ATOM   1077  CB  VAL A 134      -4.056  30.318  26.470  1.00 46.28           C  
ATOM   1078  CG1 VAL A 134      -3.157  29.222  25.889  1.00 46.33           C  
ATOM   1079  CG2 VAL A 134      -4.856  31.029  25.367  1.00 46.05           C  
ATOM   1080  N   ALA A 135      -4.495  27.573  28.469  1.00 46.80           N  
ATOM   1081  CA  ALA A 135      -3.868  26.593  29.358  1.00 47.20           C  
ATOM   1082  C   ALA A 135      -2.356  26.585  29.212  1.00 47.94           C  
ATOM   1083  O   ALA A 135      -1.829  26.405  28.118  1.00 48.41           O  
ATOM   1084  CB  ALA A 135      -4.424  25.217  29.097  1.00 47.07           C  
ATOM   1085  N   LYS A 136      -1.659  26.786  30.320  1.00 48.41           N  
ATOM   1086  CA  LYS A 136      -0.212  26.825  30.302  1.00 48.87           C  
ATOM   1087  C   LYS A 136       0.426  25.652  31.028  1.00 48.60           C  
ATOM   1088  O   LYS A 136       1.455  25.142  30.586  1.00 48.57           O  
ATOM   1089  CB  LYS A 136       0.309  28.159  30.862  1.00 49.50           C  
ATOM   1090  CG  LYS A 136      -0.014  29.383  29.972  1.00 51.11           C  
ATOM   1091  CD  LYS A 136       0.129  29.068  28.462  1.00 53.03           C  
ATOM   1092  CE  LYS A 136       0.120  30.314  27.608  1.00 53.03           C  
ATOM   1093  NZ  LYS A 136       1.440  31.015  27.686  1.00 56.17           N  
ATOM   1094  N   GLN A 137      -0.187  25.217  32.129  1.00 48.17           N  
ATOM   1095  CA  GLN A 137       0.446  24.244  33.021  1.00 47.76           C  
ATOM   1096  C   GLN A 137      -0.594  23.478  33.833  1.00 47.00           C  
ATOM   1097  O   GLN A 137      -1.407  24.076  34.537  1.00 47.56           O  
ATOM   1098  CB  GLN A 137       1.454  24.965  33.942  1.00 47.99           C  
ATOM   1099  CG  GLN A 137       2.336  24.073  34.800  1.00 49.52           C  
ATOM   1100  CD  GLN A 137       3.004  22.959  34.005  1.00 52.84           C  
ATOM   1101  OE1 GLN A 137       2.600  21.800  34.087  1.00 53.53           O  
ATOM   1102  NE2 GLN A 137       4.023  23.310  33.217  1.00 54.75           N  
ATOM   1103  N   ARG A 138      -0.577  22.157  33.706  1.00 45.61           N  
ATOM   1104  CA  ARG A 138      -1.395  21.283  34.522  1.00 44.40           C  
ATOM   1105  C   ARG A 138      -0.684  21.113  35.869  1.00 43.94           C  
ATOM   1106  O   ARG A 138       0.520  20.881  35.908  1.00 44.55           O  
ATOM   1107  CB  ARG A 138      -1.615  19.950  33.781  1.00 44.50           C  
ATOM   1108  CG  ARG A 138      -2.425  18.875  34.504  1.00 43.51           C  
ATOM   1109  CD  ARG A 138      -3.631  18.426  33.647  1.00 43.44           C  
ATOM   1110  NE  ARG A 138      -4.793  19.179  34.093  1.00 41.89           N  
ATOM   1111  CZ  ARG A 138      -5.904  18.687  34.632  1.00 40.47           C  
ATOM   1112  NH1 ARG A 138      -6.127  17.392  34.748  1.00 36.64           N  
ATOM   1113  NH2 ARG A 138      -6.840  19.538  35.023  1.00 42.40           N  
ATOM   1114  N   ASN A 139      -1.416  21.289  36.969  1.00 42.53           N  
ATOM   1115  CA  ASN A 139      -0.855  21.182  38.312  1.00 41.04           C  
ATOM   1116  C   ASN A 139      -1.668  20.249  39.178  1.00 40.14           C  
ATOM   1117  O   ASN A 139      -2.790  19.878  38.849  1.00 40.05           O  
ATOM   1118  CB  ASN A 139      -0.828  22.532  39.054  1.00 41.15           C  
ATOM   1119  CG  ASN A 139      -0.643  23.733  38.143  1.00 41.38           C  
ATOM   1120  OD1 ASN A 139       0.421  23.933  37.536  1.00 42.13           O  
ATOM   1121  ND2 ASN A 139      -1.670  24.569  38.080  1.00 39.30           N  
ATOM   1122  N   THR A 140      -1.085  19.889  40.307  1.00 39.26           N  
ATOM   1123  CA  THR A 140      -1.793  19.236  41.386  1.00 38.12           C  
ATOM   1124  C   THR A 140      -1.611  20.140  42.587  1.00 37.97           C  
ATOM   1125  O   THR A 140      -0.523  20.648  42.830  1.00 37.90           O  
ATOM   1126  CB  THR A 140      -1.211  17.825  41.663  1.00 37.88           C  
ATOM   1127  OG1 THR A 140      -1.446  16.984  40.519  1.00 37.99           O  
ATOM   1128  CG2 THR A 140      -1.814  17.202  42.889  1.00 34.62           C  
ATOM   1129  N   VAL A 141      -2.689  20.367  43.316  1.00 38.19           N  
ATOM   1130  CA  VAL A 141      -2.624  21.130  44.555  1.00 38.57           C  
ATOM   1131  C   VAL A 141      -2.960  20.189  45.719  1.00 38.96           C  
ATOM   1132  O   VAL A 141      -3.838  19.328  45.607  1.00 38.96           O  
ATOM   1133  CB  VAL A 141      -3.565  22.409  44.507  1.00 38.32           C  
ATOM   1134  CG1 VAL A 141      -5.031  22.016  44.367  1.00 37.37           C  
ATOM   1135  CG2 VAL A 141      -3.360  23.301  45.721  1.00 37.62           C  
ATOM   1136  N   SER A 142      -2.236  20.345  46.821  1.00 39.45           N  
ATOM   1137  CA  SER A 142      -2.511  19.589  48.030  1.00 39.90           C  
ATOM   1138  C   SER A 142      -3.390  20.447  48.941  1.00 40.19           C  
ATOM   1139  O   SER A 142      -2.986  21.529  49.346  1.00 40.14           O  
ATOM   1140  CB  SER A 142      -1.203  19.188  48.724  1.00 39.73           C  
ATOM   1141  OG  SER A 142      -1.462  18.436  49.901  1.00 40.10           O  
ATOM   1142  N   ILE A 143      -4.604  19.971  49.217  1.00 40.46           N  
ATOM   1143  CA  ILE A 143      -5.567  20.683  50.048  1.00 41.00           C  
ATOM   1144  C   ILE A 143      -6.069  19.704  51.079  1.00 41.10           C  
ATOM   1145  O   ILE A 143      -6.629  18.669  50.718  1.00 41.07           O  
ATOM   1146  CB  ILE A 143      -6.827  21.179  49.266  1.00 40.94           C  
ATOM   1147  CG1 ILE A 143      -6.461  22.124  48.128  1.00 41.78           C  
ATOM   1148  CG2 ILE A 143      -7.822  21.878  50.228  1.00 41.54           C  
ATOM   1149  CD1 ILE A 143      -7.651  22.490  47.220  1.00 41.51           C  
ATOM   1150  N   ASN A 144      -5.887  20.035  52.356  1.00 41.44           N  
ATOM   1151  CA  ASN A 144      -6.396  19.215  53.454  1.00 41.69           C  
ATOM   1152  C   ASN A 144      -6.127  17.720  53.274  1.00 41.32           C  
ATOM   1153  O   ASN A 144      -7.013  16.876  53.485  1.00 41.57           O  
ATOM   1154  CB  ASN A 144      -7.891  19.466  53.658  1.00 42.08           C  
ATOM   1155  CG  ASN A 144      -8.311  19.248  55.086  1.00 44.30           C  
ATOM   1156  OD1 ASN A 144      -7.476  19.281  55.993  1.00 47.75           O  
ATOM   1157  ND2 ASN A 144      -9.602  19.021  55.305  1.00 46.11           N  
ATOM   1158  N   GLY A 145      -4.903  17.404  52.853  1.00 40.79           N  
ATOM   1159  CA  GLY A 145      -4.467  16.023  52.688  1.00 40.02           C  
ATOM   1160  C   GLY A 145      -4.960  15.312  51.437  1.00 39.12           C  
ATOM   1161  O   GLY A 145      -4.777  14.103  51.305  1.00 39.10           O  
ATOM   1162  N   GLU A 146      -5.595  16.049  50.529  1.00 38.13           N  
ATOM   1163  CA  GLU A 146      -6.024  15.501  49.244  1.00 37.43           C  
ATOM   1164  C   GLU A 146      -5.246  16.148  48.119  1.00 36.96           C  
ATOM   1165  O   GLU A 146      -4.810  17.284  48.260  1.00 37.37           O  
ATOM   1166  CB  GLU A 146      -7.518  15.740  49.017  1.00 37.22           C  
ATOM   1167  CG  GLU A 146      -8.418  14.870  49.862  1.00 37.17           C  
ATOM   1168  CD  GLU A 146      -8.679  13.527  49.220  1.00 37.60           C  
ATOM   1169  OE1 GLU A 146      -8.621  12.525  49.936  1.00 36.56           O  
ATOM   1170  OE2 GLU A 146      -8.933  13.467  47.997  1.00 39.12           O  
ATOM   1171  N   TRP A 147      -5.087  15.426  47.011  1.00 35.91           N  
ATOM   1172  CA  TRP A 147      -4.543  15.993  45.795  1.00 35.69           C  
ATOM   1173  C   TRP A 147      -5.669  16.254  44.773  1.00 35.97           C  
ATOM   1174  O   TRP A 147      -6.547  15.400  44.554  1.00 36.06           O  
ATOM   1175  CB  TRP A 147      -3.451  15.095  45.194  1.00 35.19           C  
ATOM   1176  CG  TRP A 147      -2.146  14.991  46.017  1.00 35.93           C  
ATOM   1177  CD1 TRP A 147      -1.790  15.725  47.130  1.00 35.85           C  
ATOM   1178  CD2 TRP A 147      -1.032  14.125  45.745  1.00 35.72           C  
ATOM   1179  NE1 TRP A 147      -0.535  15.347  47.573  1.00 35.81           N  
ATOM   1180  CE2 TRP A 147      -0.050  14.370  46.742  1.00 36.32           C  
ATOM   1181  CE3 TRP A 147      -0.778  13.149  44.771  1.00 34.50           C  
ATOM   1182  CZ2 TRP A 147       1.174  13.675  46.780  1.00 34.94           C  
ATOM   1183  CZ3 TRP A 147       0.443  12.462  44.816  1.00 35.85           C  
ATOM   1184  CH2 TRP A 147       1.399  12.735  45.814  1.00 34.20           C  
ATOM   1185  N   LEU A 148      -5.635  17.437  44.160  1.00 35.43           N  
ATOM   1186  CA  LEU A 148      -6.653  17.865  43.212  1.00 35.15           C  
ATOM   1187  C   LEU A 148      -5.936  18.473  42.032  1.00 35.22           C  
ATOM   1188  O   LEU A 148      -5.022  19.281  42.217  1.00 35.56           O  
ATOM   1189  CB  LEU A 148      -7.587  18.907  43.845  1.00 34.39           C  
ATOM   1190  CG  LEU A 148      -8.802  18.491  44.666  1.00 33.75           C  
ATOM   1191  CD1 LEU A 148      -8.449  18.096  46.094  1.00 34.27           C  
ATOM   1192  CD2 LEU A 148      -9.781  19.629  44.718  1.00 31.25           C  
ATOM   1193  N   ALA A 149      -6.327  18.081  40.822  1.00 35.25           N  
ATOM   1194  CA  ALA A 149      -5.740  18.650  39.610  1.00 35.42           C  
ATOM   1195  C   ALA A 149      -6.351  20.022  39.320  1.00 36.12           C  
ATOM   1196  O   ALA A 149      -7.491  20.298  39.713  1.00 35.99           O  
ATOM   1197  CB  ALA A 149      -5.939  17.733  38.432  1.00 34.70           C  
ATOM   1198  N   ASN A 150      -5.564  20.880  38.670  1.00 36.62           N  
ATOM   1199  CA  ASN A 150      -6.065  22.086  38.030  1.00 37.45           C  
ATOM   1200  C   ASN A 150      -5.107  22.513  36.943  1.00 38.18           C  
ATOM   1201  O   ASN A 150      -4.105  21.853  36.715  1.00 38.72           O  
ATOM   1202  CB  ASN A 150      -6.375  23.230  39.027  1.00 37.39           C  
ATOM   1203  CG  ASN A 150      -5.151  23.739  39.759  1.00 36.15           C  
ATOM   1204  OD1 ASN A 150      -4.103  23.992  39.164  1.00 34.88           O  
ATOM   1205  ND2 ASN A 150      -5.292  23.912  41.063  1.00 34.38           N  
ATOM   1206  N   THR A 151      -5.436  23.594  36.250  1.00 38.99           N  
ATOM   1207  CA  THR A 151      -4.627  24.078  35.151  1.00 39.54           C  
ATOM   1208  C   THR A 151      -4.432  25.580  35.305  1.00 40.18           C  
ATOM   1209  O   THR A 151      -5.403  26.339  35.484  1.00 40.22           O  
ATOM   1210  CB  THR A 151      -5.297  23.783  33.786  1.00 39.22           C  
ATOM   1211  OG1 THR A 151      -5.813  22.454  33.787  1.00 40.10           O  
ATOM   1212  CG2 THR A 151      -4.310  23.905  32.638  1.00 38.94           C  
ATOM   1213  N   THR A 152      -3.172  25.993  35.236  1.00 40.74           N  
ATOM   1214  CA  THR A 152      -2.815  27.401  35.145  1.00 41.12           C  
ATOM   1215  C   THR A 152      -3.140  27.856  33.731  1.00 41.72           C  
ATOM   1216  O   THR A 152      -2.749  27.222  32.766  1.00 41.54           O  
ATOM   1217  CB  THR A 152      -1.322  27.626  35.465  1.00 40.85           C  
ATOM   1218  OG1 THR A 152      -1.025  27.047  36.738  1.00 39.89           O  
ATOM   1219  CG2 THR A 152      -0.984  29.112  35.495  1.00 40.57           C  
HETATM 1220  N   MSE A 153      -3.910  28.932  33.635  1.00 42.69           N  
HETATM 1221  CA  MSE A 153      -4.378  29.472  32.367  1.00 43.88           C  
HETATM 1222  C   MSE A 153      -4.206  30.974  32.454  1.00 44.53           C  
HETATM 1223  O   MSE A 153      -4.515  31.574  33.483  1.00 44.19           O  
HETATM 1224  CB  MSE A 153      -5.858  29.140  32.132  1.00 44.07           C  
HETATM 1225  CG  MSE A 153      -6.230  27.687  32.381  1.00 43.56           C  
HETATM 1226 SE   MSE A 153      -8.009  27.271  31.823  0.70 44.80          SE  
HETATM 1227  CE  MSE A 153      -8.126  25.563  32.524  1.00 46.79           C  
ATOM   1228  N   THR A 154      -3.696  31.578  31.387  1.00 45.47           N  
ATOM   1229  CA  THR A 154      -3.398  33.016  31.395  1.00 46.79           C  
ATOM   1230  C   THR A 154      -4.137  33.757  30.287  1.00 47.12           C  
ATOM   1231  O   THR A 154      -4.410  33.190  29.232  1.00 47.02           O  
ATOM   1232  CB  THR A 154      -1.877  33.296  31.278  1.00 46.70           C  
ATOM   1233  OG1 THR A 154      -1.387  32.733  30.056  1.00 48.12           O  
ATOM   1234  CG2 THR A 154      -1.104  32.692  32.454  1.00 46.07           C  
ATOM   1235  N   LYS A 155      -4.475  35.014  30.553  1.00 48.20           N  
ATOM   1236  CA  LYS A 155      -5.084  35.887  29.558  1.00 49.37           C  
ATOM   1237  C   LYS A 155      -4.345  37.220  29.465  1.00 50.77           C  
ATOM   1238  O   LYS A 155      -4.107  37.882  30.486  1.00 50.38           O  
ATOM   1239  CB  LYS A 155      -6.557  36.136  29.884  1.00 49.16           C  
ATOM   1240  CG  LYS A 155      -7.322  36.887  28.788  1.00 48.17           C  
ATOM   1241  CD  LYS A 155      -8.686  37.314  29.270  1.00 45.46           C  
ATOM   1242  CE  LYS A 155      -9.462  38.017  28.184  1.00 45.64           C  
ATOM   1243  NZ  LYS A 155     -10.883  38.231  28.594  1.00 45.03           N  
ATOM   1244  N   SER A 156      -3.983  37.602  28.236  1.00 52.60           N  
ATOM   1245  CA  SER A 156      -3.424  38.935  27.952  1.00 54.37           C  
ATOM   1246  C   SER A 156      -4.545  39.974  28.020  1.00 55.18           C  
ATOM   1247  O   SER A 156      -5.635  39.757  27.462  1.00 55.71           O  
ATOM   1248  CB  SER A 156      -2.758  38.966  26.572  1.00 54.57           C  
ATOM   1249  OG  SER A 156      -1.717  39.944  26.523  1.00 56.08           O  
ATOM   1250  N   LEU A 157      -4.291  41.089  28.706  1.00 55.92           N  
ATOM   1251  CA  LEU A 157      -5.310  42.121  28.901  1.00 56.78           C  
ATOM   1252  C   LEU A 157      -5.245  43.235  27.840  1.00 57.49           C  
ATOM   1253  O   LEU A 157      -4.168  43.576  27.317  1.00 58.08           O  
ATOM   1254  CB  LEU A 157      -5.215  42.708  30.317  1.00 56.92           C  
ATOM   1255  CG  LEU A 157      -6.133  42.217  31.451  1.00 57.43           C  
ATOM   1256  CD1 LEU A 157      -6.495  40.722  31.349  1.00 58.14           C  
ATOM   1257  CD2 LEU A 157      -5.524  42.533  32.830  1.00 55.99           C  
TER    1258      LEU A 157                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
