
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  171 ( 1315),  selected  171 , name 1yvo_B
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 1yvo_B.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_B      A       2          2.670
LGA    A     3_B      I       3          0.791
LGA    S     4_B      N       4          1.047
LGA    I     5_B      I       5          1.277
LGA    R     6_B      I       6          1.822
LGA    D     7_B      E       7          1.312
LGA    A     8_B      Y       8          1.551
LGA    G     9_B      N       9          1.327
LGA    V    10_B      R      10          1.437
LGA    A    11_B      S      11          1.923
LGA    D    12_B      Y      12          2.337
LGA    L    13_B      K      13          2.173
LGA    P    14_B      E      14          2.885
LGA    G    15_B      E      15          2.405
LGA    I    16_B      L      16          1.093
LGA    L    17_B      I      17          1.481
LGA    A    18_B      E      18          1.623
LGA    I    19_B      F      19          1.099
LGA    Y    20_B      I      20          1.845
LGA    N    21_B      L      21          1.895
LGA    D    22_B      S      22          0.875
LGA    A    23_B      I      23          3.032
LGA    V    24_B      Q      24          3.830
LGA    G    25_B      K      25          1.909
LGA    N    26_B      N      26          2.568
LGA    -       -      E      27           -
LGA    T    27_B      F      28          2.312
LGA    T    28_B      N      29           #
LGA    A    29_B      I      30           #
LGA    I    30_B      -       -           -
LGA    W    31_B      K      31           #
LGA    N    32_B      I      32          1.799
LGA    E    33_B      D      33          3.115
LGA    T    34_B      -       -           -
LGA    P    35_B      R      34          3.067
LGA    V    36_B      D      35          5.380
LGA    D    37_B      D      36           -
LGA    L    38_B      Q      37           -
LGA    A    39_B      P      38           -
LGA    N    40_B      D      39           #
LGA    R    41_B      L      40          3.202
LGA    Q    42_B      E      41          4.105
LGA    A    43_B      N      42          1.989
LGA    W    44_B      I      43          3.199
LGA    F    45_B      E      44          2.763
LGA    D    46_B      H      45          1.957
LGA    T    47_B      N      46          1.879
LGA    R    48_B      Y      47          1.560
LGA    A    49_B      L      48          2.653
LGA    R    50_B      N      49          2.201
LGA    Q    51_B      S      50          0.332
LGA    G    52_B      G      51          2.244
LGA    Y    53_B      G      52          1.237
LGA    P    54_B      Q      53          1.404
LGA    I    55_B      F      54          0.800
LGA    L    56_B      W      55          0.429
LGA    V    57_B      L      56          0.535
LGA    A    58_B      A      57          0.266
LGA    S    59_B      I      58          0.749
LGA    D    60_B      N      59          1.236
LGA    A    61_B      N      60          1.738
LGA    A    62_B      H      61          1.431
LGA    G    63_B      Q      62          0.947
LGA    E    64_B      N      63          0.516
LGA    V    65_B      I      64          0.808
LGA    L    66_B      V      65          0.655
LGA    G    67_B      G      66          0.948
LGA    Y    68_B      T      67          0.942
LGA    A    69_B      I      68          0.610
LGA    S    70_B      G      69          0.828
LGA    Y    71_B      L      70          0.854
LGA    G    72_B      I      71          1.128
LGA    D    73_B      R      72          4.095
LGA    W    74_B      L      73          4.951
LGA    R    75_B      -       -           -
LGA    P    76_B      -       -           -
LGA    F    77_B      -       -           -
LGA    E    78_B      -       -           -
LGA    G    79_B      -       -           -
LGA    F    80_B      D      74          3.288
LGA    R    81_B      N      75          2.827
LGA    G    82_B      N      76          1.187
LGA    T    83_B      M      77          1.123
LGA    V    84_B      S      78          0.873
LGA    E    85_B      A      79          0.831
LGA    H    86_B      L      80          0.589
LGA    S    87_B      K      81          1.917
LGA    -       -      K      82           -
LGA    V    88_B      M      83          0.905
LGA    Y    89_B      F      84          1.335
LGA    V    90_B      V      85          1.275
LGA    R    91_B      D      86          2.100
LGA    D    92_B      K      87          2.739
LGA    D    93_B      G      88          2.655
LGA    Q    94_B      Y      89          2.218
LGA    R    95_B      R      90          2.327
LGA    G    96_B      N      91          2.859
LGA    K    97_B      L      92          2.491
LGA    G    98_B      K      93          1.962
LGA    L    99_B      I      94          1.269
LGA    G   100_B      G      95          1.238
LGA    V   101_B      K      96          1.350
LGA    Q   102_B      K      97          1.142
LGA    L   103_B      L      98          0.728
LGA    L   104_B      L      99          0.966
LGA    Q   105_B      D     100          1.325
LGA    A   106_B      K     101          1.028
LGA    L   107_B      V     102          0.956
LGA    I   108_B      I     103          1.092
LGA    E   109_B      M     104          0.947
LGA    R   110_B      T     105          0.946
LGA    A   111_B      C     106          1.147
LGA    R   112_B      K     107          1.211
LGA    A   113_B      E     108          0.992
LGA    Q   114_B      Q     109          0.844
LGA    G   115_B      N     110          0.762
LGA    L   116_B      I     111          0.444
LGA    H   117_B      D     112          0.638
LGA    V   118_B      G     113          0.913
LGA    X   119_B      I     114          0.312
LGA    V   120_B      Y     115          0.880
LGA    A   121_B      L     116          1.747
LGA    A   122_B      G     117          1.115
LGA    I   123_B      T     118          1.730
LGA    E   124_B      I     119          1.099
LGA    S   125_B      D     120          2.642
LGA    G   126_B      K     121          4.202
LGA    N   127_B      F     122          2.888
LGA    A   128_B      I     123          3.165
LGA    A   129_B      S     124          1.029
LGA    S   130_B      A     125          0.939
LGA    I   131_B      Q     126          1.623
LGA    G   132_B      Y     127          1.354
LGA    L   133_B      F     128          1.069
LGA    H   134_B      Y     129          1.275
LGA    R   135_B      S     130          1.600
LGA    R   136_B      N     131          1.605
LGA    L   137_B      N     132          1.422
LGA    G   138_B      G     133          1.150
LGA    F   139_B      F     134          1.082
LGA    E   140_B      R     135          1.006
LGA    I   141_B      E     136          1.160
LGA    S   142_B      I     137          1.597
LGA    G   143_B      K     138          2.158
LGA    Q   144_B      -       -           -
LGA    X   145_B      R     139          5.243
LGA    P   146_B      G     140           -
LGA    Q   147_B      D     141           -
LGA    -       -      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    -       -      K     148           -
LGA    -       -      L     149           -
LGA    V   148_B      D     150           #
LGA    G   149_B      V     151          3.785
LGA    Q   150_B      -       -           -
LGA    K   151_B      -       -           -
LGA    F   152_B      -       -           -
LGA    G   153_B      -       -           -
LGA    R   154_B      -       -           -
LGA    W   155_B      -       -           -
LGA    L   156_B      -       -           -
LGA    D   157_B      D     152           #
LGA    L   158_B      N     153          1.360
LGA    T   159_B      R     154          1.493
LGA    F   160_B      F     155          1.142
LGA    X   161_B      Y     156          1.034
LGA    Q   162_B      Y     157          0.787
LGA    L   163_B      R     158          0.774
LGA    N   164_B      N     159          0.727
LGA    L   165_B      L     160          0.637
LGA    D   166_B      K     161          0.924
LGA    P   167_B      -       -           -
LGA    T   168_B      -       -           -
LGA    R   169_B      -       -           -
LGA    S   170_B      -       -           -
LGA    A   171_B      -       -           -
LGA    P   172_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  171  160    5.0    139    1.94    12.23     70.524     6.814

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.831141 * X  +  -0.134376 * Y  +  -0.539581 * Z  +  46.579079
  Y_new =  -0.346507 * X  +   0.884085 * Y  +   0.313570 * Z  + -31.972925
  Z_new =   0.434899 * X  +   0.447589 * Y  +  -0.781362 * Z  +  22.018366 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.621389   -0.520203  [ DEG:   150.1945    -29.8055 ]
  Theta =  -0.449926   -2.691666  [ DEG:   -25.7789   -154.2211 ]
  Phi   =  -2.746598    0.394994  [ DEG:  -157.3685     22.6315 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yvo_B                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yvo_B.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  171  160   5.0  139   1.94   12.23  70.524
REMARK  ---------------------------------------------------------- 
MOLECULE 1yvo_B
HEADER    TRANSFERASE                             16-FEB-05   1YVO              
TITLE     HYPOTHETICAL ACETYLTRANSFERASE FROM P.AERUGINOSA PA01                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED HYPOTHETICAL PROTEIN;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 2.3.-.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA PAO1;                    
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS, HYPOTHETICAL               
KEYWDS   2 ACETYLTRANSFERASE, PSI, PROTEIN STRUCTURE INITIATIVE,                
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.NOCEK,A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS           
AUTHOR   2 (MCSG)                                                               
REVDAT   1   29-MAR-05 1YVO    0                                                
JRNL        AUTH   B.NOCEK,X.XU,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK              
JRNL        TITL   CRYSTAL STRUCTURE OF A HYPOTHETICAL                          
JRNL        TITL 2 ACETYLTRANSFERASE FROM P.AERUGINOSA PA01                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1YVO A    1   172  UNP    Q9HUU7   Q9HUU7_PSEAE     1    172             
DBREF  1YVO B    1   172  UNP    Q9HUU7   Q9HUU7_PSEAE     1    172             
SEQRES   1 A  172  MSE SER ALA SER ILE ARG ASP ALA GLY VAL ALA ASP LEU          
SEQRES   2 A  172  PRO GLY ILE LEU ALA ILE TYR ASN ASP ALA VAL GLY ASN          
SEQRES   3 A  172  THR THR ALA ILE TRP ASN GLU THR PRO VAL ASP LEU ALA          
SEQRES   4 A  172  ASN ARG GLN ALA TRP PHE ASP THR ARG ALA ARG GLN GLY          
SEQRES   5 A  172  TYR PRO ILE LEU VAL ALA SER ASP ALA ALA GLY GLU VAL          
SEQRES   6 A  172  LEU GLY TYR ALA SER TYR GLY ASP TRP ARG PRO PHE GLU          
SEQRES   7 A  172  GLY PHE ARG GLY THR VAL GLU HIS SER VAL TYR VAL ARG          
SEQRES   8 A  172  ASP ASP GLN ARG GLY LYS GLY LEU GLY VAL GLN LEU LEU          
SEQRES   9 A  172  GLN ALA LEU ILE GLU ARG ALA ARG ALA GLN GLY LEU HIS          
SEQRES  10 A  172  VAL MSE VAL ALA ALA ILE GLU SER GLY ASN ALA ALA SER          
SEQRES  11 A  172  ILE GLY LEU HIS ARG ARG LEU GLY PHE GLU ILE SER GLY          
SEQRES  12 A  172  GLN MSE PRO GLN VAL GLY GLN LYS PHE GLY ARG TRP LEU          
SEQRES  13 A  172  ASP LEU THR PHE MSE GLN LEU ASN LEU ASP PRO THR ARG          
SEQRES  14 A  172  SER ALA PRO                                                  
SEQRES   1 B  172  MSE SER ALA SER ILE ARG ASP ALA GLY VAL ALA ASP LEU          
SEQRES   2 B  172  PRO GLY ILE LEU ALA ILE TYR ASN ASP ALA VAL GLY ASN          
SEQRES   3 B  172  THR THR ALA ILE TRP ASN GLU THR PRO VAL ASP LEU ALA          
SEQRES   4 B  172  ASN ARG GLN ALA TRP PHE ASP THR ARG ALA ARG GLN GLY          
SEQRES   5 B  172  TYR PRO ILE LEU VAL ALA SER ASP ALA ALA GLY GLU VAL          
SEQRES   6 B  172  LEU GLY TYR ALA SER TYR GLY ASP TRP ARG PRO PHE GLU          
SEQRES   7 B  172  GLY PHE ARG GLY THR VAL GLU HIS SER VAL TYR VAL ARG          
SEQRES   8 B  172  ASP ASP GLN ARG GLY LYS GLY LEU GLY VAL GLN LEU LEU          
SEQRES   9 B  172  GLN ALA LEU ILE GLU ARG ALA ARG ALA GLN GLY LEU HIS          
SEQRES  10 B  172  VAL MSE VAL ALA ALA ILE GLU SER GLY ASN ALA ALA SER          
SEQRES  11 B  172  ILE GLY LEU HIS ARG ARG LEU GLY PHE GLU ILE SER GLY          
SEQRES  12 B  172  GLN MSE PRO GLN VAL GLY GLN LYS PHE GLY ARG TRP LEU          
SEQRES  13 B  172  ASP LEU THR PHE MSE GLN LEU ASN LEU ASP PRO THR ARG          
SEQRES  14 B  172  SER ALA PRO                                                  
HET    MSE  A 119       8                                                       
HET    MSE  A 145       8                                                       
HET    MSE  A 161       8                                                       
HET    MSE  B 119       8                                                       
HET    MSE  B 145       8                                                       
HET    MSE  B 161       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *266(H2 O)                                                    
CRYST1   48.015   84.007   85.903  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1322  N   SER B   2     -30.178  40.613  35.391  1.00 38.99           N  
ATOM   1323  CA  SER B   2     -30.846  41.231  36.572  1.00 38.88           C  
ATOM   1324  C   SER B   2     -29.812  41.578  37.648  1.00 38.23           C  
ATOM   1325  O   SER B   2     -29.737  42.728  38.098  1.00 38.73           O  
ATOM   1326  CB  SER B   2     -31.927  40.291  37.128  1.00 39.15           C  
ATOM   1327  OG  SER B   2     -32.574  40.855  38.261  1.00 40.84           O  
ATOM   1328  N   ALA B   3     -29.001  40.587  38.025  1.00 37.06           N  
ATOM   1329  CA  ALA B   3     -27.987  40.732  39.082  1.00 35.44           C  
ATOM   1330  C   ALA B   3     -26.979  41.851  38.805  1.00 34.10           C  
ATOM   1331  O   ALA B   3     -26.578  42.065  37.654  1.00 34.26           O  
ATOM   1332  CB  ALA B   3     -27.260  39.412  39.298  1.00 35.51           C  
ATOM   1333  N   SER B   4     -26.581  42.558  39.864  1.00 32.01           N  
ATOM   1334  CA  SER B   4     -25.542  43.588  39.761  1.00 29.95           C  
ATOM   1335  C   SER B   4     -24.213  43.103  40.332  1.00 27.87           C  
ATOM   1336  O   SER B   4     -24.193  42.357  41.309  1.00 27.66           O  
ATOM   1337  CB  SER B   4     -25.967  44.859  40.491  1.00 30.23           C  
ATOM   1338  OG  SER B   4     -25.931  44.677  41.895  1.00 31.33           O  
ATOM   1339  N   ILE B   5     -23.117  43.544  39.720  1.00 25.48           N  
ATOM   1340  CA  ILE B   5     -21.766  43.266  40.217  1.00 23.33           C  
ATOM   1341  C   ILE B   5     -21.267  44.481  41.005  1.00 22.01           C  
ATOM   1342  O   ILE B   5     -21.259  45.595  40.486  1.00 21.76           O  
ATOM   1343  CB  ILE B   5     -20.755  42.955  39.061  1.00 23.44           C  
ATOM   1344  CG1 ILE B   5     -21.301  41.904  38.073  1.00 23.28           C  
ATOM   1345  CG2 ILE B   5     -19.380  42.552  39.622  1.00 22.84           C  
ATOM   1346  CD1 ILE B   5     -21.495  40.511  38.641  1.00 22.72           C  
ATOM   1347  N   ARG B   6     -20.860  44.262  42.250  1.00 20.04           N  
ATOM   1348  CA  ARG B   6     -20.373  45.341  43.111  1.00 19.15           C  
ATOM   1349  C   ARG B   6     -19.306  44.808  44.057  1.00 18.96           C  
ATOM   1350  O   ARG B   6     -19.173  43.595  44.222  1.00 18.51           O  
ATOM   1351  CB  ARG B   6     -21.527  45.926  43.921  1.00 18.94           C  
ATOM   1352  CG  ARG B   6     -22.262  44.890  44.745  1.00 18.07           C  
ATOM   1353  CD  ARG B   6     -23.217  45.516  45.748  1.00 20.27           C  
ATOM   1354  NE  ARG B   6     -23.947  44.477  46.475  1.00 21.53           N  
ATOM   1355  CZ  ARG B   6     -23.493  43.824  47.542  1.00 22.25           C  
ATOM   1356  NH1 ARG B   6     -22.285  44.086  48.039  1.00 22.43           N  
ATOM   1357  NH2 ARG B   6     -24.256  42.894  48.109  1.00 22.46           N  
ATOM   1358  N   ASP B   7     -18.567  45.712  44.699  1.00 18.82           N  
ATOM   1359  CA  ASP B   7     -17.582  45.311  45.698  1.00 19.31           C  
ATOM   1360  C   ASP B   7     -18.278  44.705  46.901  1.00 18.93           C  
ATOM   1361  O   ASP B   7     -19.344  45.178  47.317  1.00 18.90           O  
ATOM   1362  CB  ASP B   7     -16.707  46.482  46.129  1.00 19.88           C  
ATOM   1363  CG  ASP B   7     -15.797  46.960  45.025  1.00 22.85           C  
ATOM   1364  OD1 ASP B   7     -14.647  46.468  44.922  1.00 25.13           O  
ATOM   1365  OD2 ASP B   7     -16.236  47.830  44.243  1.00 27.42           O  
ATOM   1366  N   ALA B   8     -17.675  43.648  47.442  1.00 18.15           N  
ATOM   1367  CA  ALA B   8     -18.154  43.009  48.657  1.00 17.96           C  
ATOM   1368  C   ALA B   8     -17.936  43.873  49.903  1.00 18.11           C  
ATOM   1369  O   ALA B   8     -16.942  44.607  50.008  1.00 17.92           O  
ATOM   1370  CB  ALA B   8     -17.469  41.662  48.843  1.00 17.41           C  
ATOM   1371  N   GLY B   9     -18.863  43.767  50.848  1.00 17.94           N  
ATOM   1372  CA  GLY B   9     -18.641  44.269  52.202  1.00 18.68           C  
ATOM   1373  C   GLY B   9     -18.676  43.130  53.213  1.00 19.11           C  
ATOM   1374  O   GLY B   9     -18.968  41.965  52.862  1.00 18.58           O  
ATOM   1375  N   VAL B  10     -18.388  43.452  54.470  0.50 19.02           N  
ATOM   1377  CA  VAL B  10     -18.398  42.442  55.535  0.50 18.96           C  
ATOM   1379  C   VAL B  10     -19.769  41.775  55.691  0.50 18.84           C  
ATOM   1381  O   VAL B  10     -19.854  40.625  56.117  0.50 18.79           O  
ATOM   1383  CB  VAL B  10     -17.884  43.001  56.894  0.50 19.04           C  
ATOM   1385  CG1 VAL B  10     -16.389  43.328  56.807  0.50 19.15           C  
ATOM   1387  CG2 VAL B  10     -18.688  44.220  57.328  0.50 18.77           C  
ATOM   1389  N   ALA B  11     -20.832  42.494  55.328  1.00 18.77           N  
ATOM   1390  CA  ALA B  11     -22.188  41.939  55.343  1.00 18.76           C  
ATOM   1391  C   ALA B  11     -22.460  40.897  54.248  1.00 18.49           C  
ATOM   1392  O   ALA B  11     -23.476  40.194  54.294  1.00 18.05           O  
ATOM   1393  CB  ALA B  11     -23.224  43.063  55.271  1.00 19.20           C  
ATOM   1394  N   ASP B  12     -21.571  40.805  53.259  1.00 17.64           N  
ATOM   1395  CA  ASP B  12     -21.692  39.773  52.223  1.00 17.23           C  
ATOM   1396  C   ASP B  12     -20.989  38.490  52.620  1.00 16.38           C  
ATOM   1397  O   ASP B  12     -21.111  37.482  51.932  1.00 15.17           O  
ATOM   1398  CB  ASP B  12     -21.116  40.260  50.891  1.00 17.47           C  
ATOM   1399  CG  ASP B  12     -21.871  41.450  50.330  1.00 19.95           C  
ATOM   1400  OD1 ASP B  12     -23.112  41.352  50.176  1.00 22.06           O  
ATOM   1401  OD2 ASP B  12     -21.222  42.483  50.044  1.00 21.90           O  
ATOM   1402  N   LEU B  13     -20.240  38.531  53.718  1.00 15.96           N  
ATOM   1403  CA  LEU B  13     -19.427  37.379  54.123  1.00 15.90           C  
ATOM   1404  C   LEU B  13     -20.224  36.113  54.485  1.00 15.42           C  
ATOM   1405  O   LEU B  13     -19.775  35.021  54.157  1.00 15.61           O  
ATOM   1406  CB  LEU B  13     -18.384  37.737  55.200  1.00 16.16           C  
ATOM   1407  CG  LEU B  13     -17.188  38.576  54.726  1.00 16.73           C  
ATOM   1408  CD1 LEU B  13     -16.367  39.096  55.895  1.00 16.42           C  
ATOM   1409  CD2 LEU B  13     -16.287  37.792  53.757  1.00 15.75           C  
ATOM   1410  N   PRO B  14     -21.392  36.241  55.157  1.00 14.91           N  
ATOM   1411  CA  PRO B  14     -22.176  35.006  55.335  1.00 14.30           C  
ATOM   1412  C   PRO B  14     -22.602  34.340  54.014  1.00 13.54           C  
ATOM   1413  O   PRO B  14     -22.583  33.110  53.926  1.00 13.64           O  
ATOM   1414  CB  PRO B  14     -23.406  35.478  56.123  1.00 14.43           C  
ATOM   1415  CG  PRO B  14     -22.936  36.730  56.835  1.00 14.95           C  
ATOM   1416  CD  PRO B  14     -22.049  37.390  55.808  1.00 14.94           C  
ATOM   1417  N   GLY B  15     -22.973  35.134  53.004  1.00 12.51           N  
ATOM   1418  CA  GLY B  15     -23.365  34.588  51.687  1.00 11.81           C  
ATOM   1419  C   GLY B  15     -22.173  34.013  50.938  1.00 11.26           C  
ATOM   1420  O   GLY B  15     -22.255  32.960  50.289  1.00 10.30           O  
ATOM   1421  N   ILE B  16     -21.048  34.709  51.029  1.00 11.14           N  
ATOM   1422  CA  ILE B  16     -19.779  34.190  50.505  1.00 11.74           C  
ATOM   1423  C   ILE B  16     -19.392  32.854  51.139  1.00 11.84           C  
ATOM   1424  O   ILE B  16     -19.038  31.904  50.436  1.00 11.74           O  
ATOM   1425  CB  ILE B  16     -18.649  35.244  50.673  1.00 10.95           C  
ATOM   1426  CG1 ILE B  16     -18.867  36.381  49.676  1.00 11.89           C  
ATOM   1427  CG2 ILE B  16     -17.278  34.615  50.490  1.00 12.06           C  
ATOM   1428  CD1 ILE B  16     -17.961  37.620  49.922  1.00 12.00           C  
ATOM   1429  N   LEU B  17     -19.474  32.795  52.468  1.00 12.55           N  
ATOM   1430  CA  LEU B  17     -19.158  31.581  53.238  1.00 13.03           C  
ATOM   1431  C   LEU B  17     -20.019  30.390  52.809  1.00 12.35           C  
ATOM   1432  O   LEU B  17     -19.506  29.272  52.634  1.00 12.02           O  
ATOM   1433  CB  LEU B  17     -19.338  31.836  54.747  1.00 12.79           C  
ATOM   1434  CG  LEU B  17     -19.038  30.704  55.750  1.00 13.66           C  
ATOM   1435  CD1 LEU B  17     -17.568  30.341  55.785  1.00 15.35           C  
ATOM   1436  CD2 LEU B  17     -19.501  31.124  57.127  1.00 15.02           C  
ATOM   1437  N   ALA B  18     -21.320  30.625  52.649  1.00 12.28           N  
ATOM   1438  CA  ALA B  18     -22.233  29.556  52.223  1.00 11.70           C  
ATOM   1439  C   ALA B  18     -21.839  28.997  50.847  1.00 11.98           C  
ATOM   1440  O   ALA B  18     -21.844  27.778  50.650  1.00 11.50           O  
ATOM   1441  CB  ALA B  18     -23.664  30.033  52.217  1.00 11.69           C  
ATOM   1442  N   ILE B  19     -21.490  29.873  49.906  1.00 11.74           N  
ATOM   1443  CA  ILE B  19     -21.005  29.416  48.581  1.00 12.72           C  
ATOM   1444  C   ILE B  19     -19.668  28.670  48.715  1.00 12.74           C  
ATOM   1445  O   ILE B  19     -19.478  27.597  48.138  1.00 13.29           O  
ATOM   1446  CB  ILE B  19     -20.861  30.589  47.568  1.00 12.88           C  
ATOM   1447  CG1 ILE B  19     -22.235  31.199  47.278  1.00 13.63           C  
ATOM   1448  CG2 ILE B  19     -20.157  30.113  46.257  1.00 12.76           C  
ATOM   1449  CD1 ILE B  19     -22.181  32.585  46.661  1.00 14.95           C  
ATOM   1450  N   TYR B  20     -18.752  29.235  49.485  1.00 13.07           N  
ATOM   1451  CA  TYR B  20     -17.447  28.609  49.683  1.00 13.45           C  
ATOM   1452  C   TYR B  20     -17.611  27.196  50.259  1.00 12.89           C  
ATOM   1453  O   TYR B  20     -17.037  26.239  49.735  1.00 12.45           O  
ATOM   1454  CB  TYR B  20     -16.561  29.476  50.579  1.00 14.30           C  
ATOM   1455  CG  TYR B  20     -15.188  28.900  50.822  1.00 16.27           C  
ATOM   1456  CD1 TYR B  20     -14.113  29.203  49.976  1.00 18.15           C  
ATOM   1457  CD2 TYR B  20     -14.962  28.048  51.905  1.00 17.95           C  
ATOM   1458  CE1 TYR B  20     -12.832  28.656  50.210  1.00 18.72           C  
ATOM   1459  CE2 TYR B  20     -13.688  27.496  52.143  1.00 20.07           C  
ATOM   1460  CZ  TYR B  20     -12.642  27.812  51.299  1.00 17.78           C  
ATOM   1461  OH  TYR B  20     -11.411  27.265  51.562  1.00 20.75           O  
ATOM   1462  N   ASN B  21     -18.410  27.064  51.316  1.00 11.82           N  
ATOM   1463  CA  ASN B  21     -18.576  25.766  51.976  1.00 12.08           C  
ATOM   1464  C   ASN B  21     -19.325  24.727  51.125  1.00 12.06           C  
ATOM   1465  O   ASN B  21     -19.080  23.516  51.246  1.00 11.57           O  
ATOM   1466  CB  ASN B  21     -19.206  25.948  53.368  1.00 11.97           C  
ATOM   1467  CG  ASN B  21     -18.189  26.418  54.404  1.00 13.11           C  
ATOM   1468  OD1 ASN B  21     -16.988  26.196  54.242  1.00 15.00           O  
ATOM   1469  ND2 ASN B  21     -18.666  27.057  55.477  1.00 13.71           N  
ATOM   1470  N   ASP B  22     -20.230  25.199  50.268  1.00 12.05           N  
ATOM   1471  CA  ASP B  22     -20.934  24.319  49.335  1.00 13.33           C  
ATOM   1472  C   ASP B  22     -19.942  23.728  48.312  1.00 13.63           C  
ATOM   1473  O   ASP B  22     -19.997  22.538  48.016  1.00 13.68           O  
ATOM   1474  CB  ASP B  22     -22.071  25.072  48.626  1.00 13.98           C  
ATOM   1475  CG  ASP B  22     -23.039  24.138  47.895  1.00 17.16           C  
ATOM   1476  OD1 ASP B  22     -23.154  22.949  48.263  1.00 17.97           O  
ATOM   1477  OD2 ASP B  22     -23.709  24.604  46.954  1.00 22.65           O  
ATOM   1478  N   ALA B  23     -19.029  24.558  47.796  1.00 13.52           N  
ATOM   1479  CA  ALA B  23     -18.009  24.079  46.849  1.00 14.44           C  
ATOM   1480  C   ALA B  23     -17.041  23.115  47.530  1.00 14.72           C  
ATOM   1481  O   ALA B  23     -16.663  22.087  46.951  1.00 15.27           O  
ATOM   1482  CB  ALA B  23     -17.267  25.246  46.210  1.00 14.39           C  
ATOM   1483  N   VAL B  24     -16.662  23.436  48.768  1.00 15.41           N  
ATOM   1484  CA  VAL B  24     -15.879  22.530  49.616  1.00 15.62           C  
ATOM   1485  C   VAL B  24     -16.549  21.162  49.733  1.00 16.33           C  
ATOM   1486  O   VAL B  24     -15.909  20.134  49.498  1.00 16.53           O  
ATOM   1487  CB  VAL B  24     -15.620  23.153  51.016  1.00 15.79           C  
ATOM   1488  CG1 VAL B  24     -15.181  22.104  52.024  1.00 15.87           C  
ATOM   1489  CG2 VAL B  24     -14.569  24.246  50.901  1.00 15.15           C  
ATOM   1490  N   GLY B  25     -17.837  21.146  50.078  1.00 16.75           N  
ATOM   1491  CA  GLY B  25     -18.543  19.882  50.267  1.00 17.75           C  
ATOM   1492  C   GLY B  25     -18.883  19.108  49.000  1.00 18.70           C  
ATOM   1493  O   GLY B  25     -18.909  17.867  49.013  1.00 19.11           O  
ATOM   1494  N   ASN B  26     -19.124  19.822  47.903  1.00 18.80           N  
ATOM   1495  CA  ASN B  26     -19.795  19.216  46.757  1.00 20.08           C  
ATOM   1496  C   ASN B  26     -19.066  19.197  45.424  1.00 20.45           C  
ATOM   1497  O   ASN B  26     -19.528  18.549  44.488  1.00 21.47           O  
ATOM   1498  CB  ASN B  26     -21.167  19.867  46.565  1.00 19.93           C  
ATOM   1499  CG  ASN B  26     -22.149  19.433  47.609  1.00 20.60           C  
ATOM   1500  OD1 ASN B  26     -22.511  18.261  47.673  1.00 22.87           O  
ATOM   1501  ND2 ASN B  26     -22.594  20.371  48.443  1.00 20.45           N  
ATOM   1502  N   THR B  27     -17.945  19.907  45.316  1.00 20.37           N  
ATOM   1503  CA  THR B  27     -17.337  20.112  44.006  1.00 20.71           C  
ATOM   1504  C   THR B  27     -15.815  20.013  44.074  1.00 21.19           C  
ATOM   1505  O   THR B  27     -15.233  19.959  45.174  1.00 20.92           O  
ATOM   1506  CB  THR B  27     -17.691  21.508  43.416  1.00 20.46           C  
ATOM   1507  OG1 THR B  27     -16.897  22.505  44.065  1.00 21.05           O  
ATOM   1508  CG2 THR B  27     -19.163  21.843  43.607  1.00 20.56           C  
ATOM   1509  N   THR B  28     -15.190  20.023  42.886  1.00 21.76           N  
ATOM   1510  CA  THR B  28     -13.742  20.110  42.742  1.00 22.03           C  
ATOM   1511  C   THR B  28     -13.268  21.540  42.519  1.00 22.80           C  
ATOM   1512  O   THR B  28     -12.126  21.752  42.125  1.00 23.21           O  
ATOM   1513  CB  THR B  28     -13.241  19.253  41.561  1.00 22.28           C  
ATOM   1514  OG1 THR B  28     -13.833  19.719  40.335  1.00 22.61           O  
ATOM   1515  CG2 THR B  28     -13.569  17.777  41.785  1.00 21.14           C  
ATOM   1516  N   ALA B  29     -14.130  22.526  42.760  1.00 22.81           N  
ATOM   1517  CA  ALA B  29     -13.763  23.926  42.509  1.00 23.24           C  
ATOM   1518  C   ALA B  29     -12.791  24.409  43.568  1.00 23.40           C  
ATOM   1519  O   ALA B  29     -12.028  25.354  43.353  1.00 23.26           O  
ATOM   1520  CB  ALA B  29     -15.002  24.818  42.485  1.00 23.32           C  
ATOM   1521  N   ILE B  30     -12.843  23.768  44.730  1.00 23.17           N  
ATOM   1522  CA  ILE B  30     -11.918  24.069  45.801  1.00 23.10           C  
ATOM   1523  C   ILE B  30     -11.392  22.757  46.393  1.00 22.42           C  
ATOM   1524  O   ILE B  30     -12.168  21.889  46.791  1.00 21.87           O  
ATOM   1525  CB  ILE B  30     -12.511  25.119  46.812  1.00 24.07           C  
ATOM   1526  CG1 ILE B  30     -12.129  24.839  48.261  1.00 25.08           C  
ATOM   1527  CG2 ILE B  30     -14.008  25.285  46.666  1.00 25.73           C  
ATOM   1528  CD1 ILE B  30     -10.996  25.735  48.731  1.00 28.50           C  
ATOM   1529  N   TRP B  31     -10.065  22.602  46.393  1.00 21.59           N  
ATOM   1530  CA  TRP B  31      -9.440  21.343  46.810  1.00 21.87           C  
ATOM   1531  C   TRP B  31      -9.158  21.341  48.315  1.00 22.48           C  
ATOM   1532  O   TRP B  31      -8.022  21.159  48.770  1.00 22.79           O  
ATOM   1533  CB  TRP B  31      -8.199  21.018  45.971  1.00 20.92           C  
ATOM   1534  CG  TRP B  31      -8.526  20.764  44.494  1.00 21.65           C  
ATOM   1535  CD1 TRP B  31      -9.732  20.936  43.876  1.00 20.35           C  
ATOM   1536  CD2 TRP B  31      -7.615  20.326  43.471  1.00 20.65           C  
ATOM   1537  NE1 TRP B  31      -9.634  20.624  42.533  1.00 20.78           N  
ATOM   1538  CE2 TRP B  31      -8.346  20.247  42.260  1.00 20.44           C  
ATOM   1539  CE3 TRP B  31      -6.262  19.978  43.463  1.00 20.42           C  
ATOM   1540  CZ2 TRP B  31      -7.763  19.846  41.054  1.00 19.30           C  
ATOM   1541  CZ3 TRP B  31      -5.679  19.583  42.252  1.00 19.74           C  
ATOM   1542  CH2 TRP B  31      -6.430  19.516  41.075  1.00 20.29           C  
ATOM   1543  N   ASN B  32     -10.213  21.631  49.070  0.50 22.38           N  
ATOM   1545  CA  ASN B  32     -10.255  21.459  50.510  0.50 22.55           C  
ATOM   1547  C   ASN B  32     -11.525  20.680  50.803  0.50 22.40           C  
ATOM   1549  O   ASN B  32     -12.525  20.839  50.109  0.50 22.09           O  
ATOM   1551  CB  ASN B  32     -10.314  22.811  51.235  0.50 22.64           C  
ATOM   1553  CG  ASN B  32      -8.985  23.564  51.214  0.50 23.51           C  
ATOM   1555  OD1 ASN B  32      -7.921  22.976  51.021  0.50 24.03           O  
ATOM   1557  ND2 ASN B  32      -9.051  24.876  51.426  0.50 23.69           N  
ATOM   1559  N   GLU B  33     -11.477  19.835  51.824  1.00 22.47           N  
ATOM   1560  CA  GLU B  33     -12.634  19.046  52.234  1.00 23.10           C  
ATOM   1561  C   GLU B  33     -13.224  19.556  53.545  1.00 22.31           C  
ATOM   1562  O   GLU B  33     -14.345  19.193  53.898  1.00 22.67           O  
ATOM   1563  CB  GLU B  33     -12.256  17.570  52.380  1.00 23.18           C  
ATOM   1564  CG  GLU B  33     -11.987  16.834  51.065  1.00 24.85           C  
ATOM   1565  CD  GLU B  33     -11.577  15.383  51.292  1.00 25.76           C  
ATOM   1566  OE1 GLU B  33     -11.433  14.974  52.476  1.00 29.80           O  
ATOM   1567  OE2 GLU B  33     -11.396  14.649  50.294  1.00 28.66           O  
ATOM   1568  N   THR B  34     -12.469  20.397  54.250  1.00 21.74           N  
ATOM   1569  CA  THR B  34     -12.861  20.914  55.568  1.00 21.44           C  
ATOM   1570  C   THR B  34     -13.549  22.274  55.432  1.00 20.37           C  
ATOM   1571  O   THR B  34     -12.963  23.201  54.875  1.00 19.79           O  
ATOM   1572  CB  THR B  34     -11.622  21.042  56.500  1.00 21.90           C  
ATOM   1573  OG1 THR B  34     -10.990  19.760  56.630  1.00 23.45           O  
ATOM   1574  CG2 THR B  34     -12.014  21.540  57.899  1.00 22.40           C  
ATOM   1575  N   PRO B  35     -14.789  22.407  55.954  1.00 19.74           N  
ATOM   1576  CA  PRO B  35     -15.467  23.698  55.851  1.00 19.38           C  
ATOM   1577  C   PRO B  35     -14.838  24.733  56.792  1.00 19.38           C  
ATOM   1578  O   PRO B  35     -14.152  24.369  57.748  1.00 19.08           O  
ATOM   1579  CB  PRO B  35     -16.899  23.377  56.291  1.00 19.31           C  
ATOM   1580  CG  PRO B  35     -16.745  22.235  57.223  1.00 19.39           C  
ATOM   1581  CD  PRO B  35     -15.614  21.414  56.673  1.00 19.42           C  
ATOM   1582  N   VAL B  36     -15.056  26.009  56.503  1.00 19.39           N  
ATOM   1583  CA  VAL B  36     -14.462  27.080  57.295  1.00 19.73           C  
ATOM   1584  C   VAL B  36     -15.553  27.886  57.967  1.00 19.64           C  
ATOM   1585  O   VAL B  36     -16.722  27.760  57.613  1.00 19.45           O  
ATOM   1586  CB  VAL B  36     -13.572  28.012  56.428  1.00 20.00           C  
ATOM   1587  CG1 VAL B  36     -12.375  27.238  55.879  1.00 20.36           C  
ATOM   1588  CG2 VAL B  36     -14.380  28.645  55.311  1.00 19.54           C  
ATOM   1589  N   ASP B  37     -15.169  28.717  58.933  1.00 19.93           N  
ATOM   1590  CA  ASP B  37     -16.142  29.544  59.639  1.00 20.16           C  
ATOM   1591  C   ASP B  37     -16.054  30.988  59.181  1.00 19.52           C  
ATOM   1592  O   ASP B  37     -15.136  31.347  58.440  1.00 19.18           O  
ATOM   1593  CB  ASP B  37     -15.988  29.421  61.172  1.00 20.81           C  
ATOM   1594  CG  ASP B  37     -14.624  29.894  61.695  1.00 22.67           C  
ATOM   1595  OD1 ASP B  37     -13.830  30.538  60.970  1.00 23.22           O  
ATOM   1596  OD2 ASP B  37     -14.351  29.626  62.885  1.00 26.13           O  
ATOM   1597  N   LEU B  38     -17.008  31.800  59.630  1.00 19.14           N  
ATOM   1598  CA  LEU B  38     -17.097  33.207  59.269  1.00 19.30           C  
ATOM   1599  C   LEU B  38     -15.796  33.955  59.569  1.00 19.41           C  
ATOM   1600  O   LEU B  38     -15.359  34.786  58.771  1.00 19.35           O  
ATOM   1601  CB  LEU B  38     -18.293  33.861  59.977  1.00 19.18           C  
ATOM   1602  CG  LEU B  38     -18.763  35.251  59.512  1.00 19.93           C  
ATOM   1603  CD1 LEU B  38     -19.227  35.228  58.039  1.00 21.35           C  
ATOM   1604  CD2 LEU B  38     -19.884  35.777  60.392  1.00 19.25           C  
ATOM   1605  N   ALA B  39     -15.172  33.637  60.706  1.00 19.55           N  
ATOM   1606  CA  ALA B  39     -13.903  34.268  61.105  1.00 19.73           C  
ATOM   1607  C   ALA B  39     -12.797  34.032  60.074  1.00 19.79           C  
ATOM   1608  O   ALA B  39     -12.017  34.944  59.769  1.00 19.65           O  
ATOM   1609  CB  ALA B  39     -13.473  33.777  62.498  1.00 19.57           C  
ATOM   1610  N   ASN B  40     -12.742  32.809  59.539  1.00 19.40           N  
ATOM   1611  CA  ASN B  40     -11.784  32.453  58.498  1.00 19.83           C  
ATOM   1612  C   ASN B  40     -11.975  33.310  57.243  1.00 19.80           C  
ATOM   1613  O   ASN B  40     -11.000  33.808  56.677  1.00 19.45           O  
ATOM   1614  CB  ASN B  40     -11.873  30.956  58.161  1.00 20.44           C  
ATOM   1615  CG  ASN B  40     -11.072  30.580  56.920  1.00 20.93           C  
ATOM   1616  OD1 ASN B  40     -11.397  30.983  55.806  1.00 21.71           O  
ATOM   1617  ND2 ASN B  40     -10.025  29.795  57.115  1.00 23.51           N  
ATOM   1618  N   ARG B  41     -13.228  33.476  56.816  1.00 19.46           N  
ATOM   1619  CA  ARG B  41     -13.530  34.303  55.642  1.00 19.32           C  
ATOM   1620  C   ARG B  41     -13.327  35.787  55.931  1.00 19.27           C  
ATOM   1621  O   ARG B  41     -12.938  36.543  55.041  1.00 19.63           O  
ATOM   1622  CB  ARG B  41     -14.948  34.039  55.118  1.00 19.15           C  
ATOM   1623  CG  ARG B  41     -15.140  32.668  54.432  1.00 18.70           C  
ATOM   1624  CD  ARG B  41     -14.229  32.460  53.210  1.00 18.57           C  
ATOM   1625  NE  ARG B  41     -12.903  31.961  53.583  1.00 18.75           N  
ATOM   1626  CZ  ARG B  41     -11.880  31.797  52.745  1.00 21.04           C  
ATOM   1627  NH1 ARG B  41     -11.998  32.086  51.457  1.00 20.74           N  
ATOM   1628  NH2 ARG B  41     -10.718  31.344  53.204  1.00 21.98           N  
ATOM   1629  N   GLN B  42     -13.566  36.204  57.173  1.00 19.41           N  
ATOM   1630  CA  GLN B  42     -13.213  37.579  57.569  1.00 19.45           C  
ATOM   1631  C   GLN B  42     -11.704  37.819  57.477  1.00 18.79           C  
ATOM   1632  O   GLN B  42     -11.273  38.894  57.047  1.00 19.02           O  
ATOM   1633  CB  GLN B  42     -13.751  37.933  58.961  1.00 19.92           C  
ATOM   1634  CG  GLN B  42     -13.408  39.363  59.412  1.00 22.25           C  
ATOM   1635  CD  GLN B  42     -14.077  40.435  58.560  1.00 24.96           C  
ATOM   1636  OE1 GLN B  42     -13.426  41.107  57.751  1.00 27.42           O  
ATOM   1637  NE2 GLN B  42     -15.380  40.591  58.729  1.00 25.84           N  
ATOM   1638  N   ALA B  43     -10.908  36.823  57.869  1.00 17.88           N  
ATOM   1639  CA  ALA B  43      -9.447  36.902  57.746  1.00 17.70           C  
ATOM   1640  C   ALA B  43      -8.996  36.971  56.288  1.00 17.16           C  
ATOM   1641  O   ALA B  43      -8.025  37.670  55.963  1.00 17.15           O  
ATOM   1642  CB  ALA B  43      -8.775  35.726  58.463  1.00 18.13           C  
ATOM   1643  N   TRP B  44      -9.689  36.225  55.423  1.00 16.30           N  
ATOM   1644  CA  TRP B  44      -9.466  36.261  53.963  1.00 15.70           C  
ATOM   1645  C   TRP B  44      -9.818  37.644  53.380  1.00 15.21           C  
ATOM   1646  O   TRP B  44      -9.066  38.197  52.567  1.00 14.84           O  
ATOM   1647  CB  TRP B  44     -10.281  35.145  53.289  1.00 15.55           C  
ATOM   1648  CG  TRP B  44     -10.474  35.270  51.781  1.00 15.80           C  
ATOM   1649  CD1 TRP B  44      -9.568  34.981  50.806  1.00 16.76           C  
ATOM   1650  CD2 TRP B  44     -11.667  35.699  51.109  1.00 16.27           C  
ATOM   1651  NE1 TRP B  44     -10.115  35.222  49.557  1.00 16.45           N  
ATOM   1652  CE2 TRP B  44     -11.403  35.661  49.719  1.00 16.58           C  
ATOM   1653  CE3 TRP B  44     -12.935  36.131  51.554  1.00 15.65           C  
ATOM   1654  CZ2 TRP B  44     -12.368  36.021  48.763  1.00 16.38           C  
ATOM   1655  CZ3 TRP B  44     -13.889  36.492  50.614  1.00 15.23           C  
ATOM   1656  CH2 TRP B  44     -13.603  36.430  49.233  1.00 16.11           C  
ATOM   1657  N   PHE B  45     -10.964  38.184  53.799  1.00 14.47           N  
ATOM   1658  CA  PHE B  45     -11.412  39.524  53.422  1.00 14.84           C  
ATOM   1659  C   PHE B  45     -10.345  40.559  53.824  1.00 14.97           C  
ATOM   1660  O   PHE B  45      -9.963  41.417  53.018  1.00 14.66           O  
ATOM   1661  CB  PHE B  45     -12.772  39.803  54.091  1.00 15.18           C  
ATOM   1662  CG  PHE B  45     -13.424  41.127  53.705  1.00 15.42           C  
ATOM   1663  CD1 PHE B  45     -14.410  41.170  52.727  1.00 16.12           C  
ATOM   1664  CD2 PHE B  45     -13.092  42.311  54.360  1.00 17.10           C  
ATOM   1665  CE1 PHE B  45     -15.034  42.372  52.389  1.00 17.19           C  
ATOM   1666  CE2 PHE B  45     -13.710  43.523  54.020  1.00 18.64           C  
ATOM   1667  CZ  PHE B  45     -14.683  43.547  53.034  1.00 16.72           C  
ATOM   1668  N   ASP B  46      -9.846  40.453  55.060  1.00 14.75           N  
ATOM   1669  CA  ASP B  46      -8.809  41.367  55.577  1.00 14.99           C  
ATOM   1670  C   ASP B  46      -7.508  41.260  54.769  1.00 14.75           C  
ATOM   1671  O   ASP B  46      -6.858  42.264  54.474  1.00 15.03           O  
ATOM   1672  CB  ASP B  46      -8.511  41.065  57.046  1.00 14.84           C  
ATOM   1673  CG  ASP B  46      -9.693  41.312  57.957  1.00 17.00           C  
ATOM   1674  OD1 ASP B  46     -10.623  42.077  57.582  1.00 19.64           O  
ATOM   1675  OD2 ASP B  46      -9.683  40.741  59.079  1.00 16.97           O  
ATOM   1676  N   THR B  47      -7.133  40.034  54.415  1.00 14.41           N  
ATOM   1677  CA  THR B  47      -5.957  39.802  53.584  1.00 14.59           C  
ATOM   1678  C   THR B  47      -6.075  40.559  52.257  1.00 13.63           C  
ATOM   1679  O   THR B  47      -5.168  41.309  51.885  1.00 13.20           O  
ATOM   1680  CB  THR B  47      -5.720  38.293  53.360  1.00 14.92           C  
ATOM   1681  OG1 THR B  47      -5.482  37.674  54.631  1.00 17.07           O  
ATOM   1682  CG2 THR B  47      -4.506  38.047  52.443  1.00 15.42           C  
ATOM   1683  N   ARG B  48      -7.193  40.375  51.558  1.00 13.10           N  
ATOM   1684  CA  ARG B  48      -7.444  41.092  50.290  1.00 13.01           C  
ATOM   1685  C   ARG B  48      -7.407  42.619  50.477  1.00 12.44           C  
ATOM   1686  O   ARG B  48      -6.869  43.348  49.635  1.00 11.95           O  
ATOM   1687  CB  ARG B  48      -8.791  40.667  49.692  1.00 13.04           C  
ATOM   1688  CG  ARG B  48      -8.851  39.194  49.222  1.00 14.00           C  
ATOM   1689  CD  ARG B  48      -7.914  38.931  48.050  1.00 15.70           C  
ATOM   1690  NE  ARG B  48      -7.964  37.522  47.663  1.00 18.06           N  
ATOM   1691  CZ  ARG B  48      -7.103  36.603  48.091  1.00 19.57           C  
ATOM   1692  NH1 ARG B  48      -6.115  36.943  48.907  1.00 19.63           N  
ATOM   1693  NH2 ARG B  48      -7.232  35.337  47.697  1.00 19.29           N  
ATOM   1694  N   ALA B  49      -7.967  43.087  51.592  1.00 12.18           N  
ATOM   1695  CA  ALA B  49      -7.925  44.510  51.952  1.00 13.06           C  
ATOM   1696  C   ALA B  49      -6.487  45.020  52.085  1.00 13.55           C  
ATOM   1697  O   ALA B  49      -6.149  46.088  51.550  1.00 13.73           O  
ATOM   1698  CB  ALA B  49      -8.702  44.765  53.244  1.00 13.07           C  
ATOM   1699  N   ARG B  50      -5.652  44.259  52.798  1.00 14.01           N  
ATOM   1700  CA  ARG B  50      -4.221  44.594  52.951  1.00 14.49           C  
ATOM   1701  C   ARG B  50      -3.502  44.629  51.608  1.00 14.79           C  
ATOM   1702  O   ARG B  50      -2.637  45.480  51.374  1.00 14.76           O  
ATOM   1703  CB  ARG B  50      -3.515  43.590  53.868  1.00 14.28           C  
ATOM   1704  CG  ARG B  50      -3.903  43.697  55.330  1.00 14.67           C  
ATOM   1705  CD  ARG B  50      -2.890  43.018  56.259  1.00 14.53           C  
ATOM   1706  NE  ARG B  50      -2.677  41.611  55.936  1.00 15.64           N  
ATOM   1707  CZ  ARG B  50      -3.450  40.599  56.333  1.00 16.54           C  
ATOM   1708  NH1 ARG B  50      -4.536  40.803  57.081  1.00 15.65           N  
ATOM   1709  NH2 ARG B  50      -3.142  39.359  55.960  1.00 16.85           N  
ATOM   1710  N   GLN B  51      -3.863  43.698  50.726  1.00 15.07           N  
ATOM   1711  CA  GLN B  51      -3.227  43.584  49.416  1.00 15.39           C  
ATOM   1712  C   GLN B  51      -3.747  44.637  48.442  1.00 15.24           C  
ATOM   1713  O   GLN B  51      -3.100  44.923  47.436  1.00 16.05           O  
ATOM   1714  CB  GLN B  51      -3.471  42.199  48.828  1.00 15.63           C  
ATOM   1715  CG  GLN B  51      -2.826  41.057  49.569  1.00 16.33           C  
ATOM   1716  CD  GLN B  51      -3.410  39.722  49.136  1.00 18.94           C  
ATOM   1717  OE1 GLN B  51      -4.632  39.585  48.962  1.00 18.49           O  
ATOM   1718  NE2 GLN B  51      -2.545  38.726  48.967  1.00 19.79           N  
ATOM   1719  N   GLY B  52      -4.902  45.215  48.755  1.00 14.97           N  
ATOM   1720  CA  GLY B  52      -5.571  46.156  47.860  1.00 15.59           C  
ATOM   1721  C   GLY B  52      -6.222  45.471  46.668  1.00 15.64           C  
ATOM   1722  O   GLY B  52      -6.450  46.097  45.629  1.00 16.15           O  
ATOM   1723  N   TYR B  53      -6.516  44.180  46.822  1.00 15.27           N  
ATOM   1724  CA  TYR B  53      -7.153  43.389  45.779  1.00 14.76           C  
ATOM   1725  C   TYR B  53      -8.664  43.326  46.001  1.00 14.37           C  
ATOM   1726  O   TYR B  53      -9.121  43.236  47.150  1.00 14.16           O  
ATOM   1727  CB  TYR B  53      -6.596  41.960  45.767  1.00 15.51           C  
ATOM   1728  CG  TYR B  53      -5.130  41.825  45.383  1.00 15.58           C  
ATOM   1729  CD1 TYR B  53      -4.516  42.735  44.523  1.00 15.56           C  
ATOM   1730  CD2 TYR B  53      -4.377  40.753  45.853  1.00 16.84           C  
ATOM   1731  CE1 TYR B  53      -3.164  42.590  44.169  1.00 17.50           C  
ATOM   1732  CE2 TYR B  53      -3.035  40.599  45.503  1.00 16.84           C  
ATOM   1733  CZ  TYR B  53      -2.444  41.511  44.665  1.00 16.67           C  
ATOM   1734  OH  TYR B  53      -1.113  41.350  44.321  1.00 19.04           O  
ATOM   1735  N   PRO B  54      -9.440  43.339  44.905  1.00 13.72           N  
ATOM   1736  CA  PRO B  54     -10.895  43.405  45.018  1.00 13.56           C  
ATOM   1737  C   PRO B  54     -11.534  42.083  45.411  1.00 12.97           C  
ATOM   1738  O   PRO B  54     -10.978  41.010  45.156  1.00 12.27           O  
ATOM   1739  CB  PRO B  54     -11.322  43.788  43.595  1.00 13.50           C  
ATOM   1740  CG  PRO B  54     -10.295  43.125  42.726  1.00 13.99           C  
ATOM   1741  CD  PRO B  54      -9.011  43.322  43.492  1.00 14.15           C  
ATOM   1742  N   ILE B  55     -12.698  42.167  46.044  1.00 12.80           N  
ATOM   1743  CA  ILE B  55     -13.596  41.022  46.125  1.00 13.00           C  
ATOM   1744  C   ILE B  55     -14.915  41.550  45.577  1.00 12.67           C  
ATOM   1745  O   ILE B  55     -15.436  42.559  46.064  1.00 12.45           O  
ATOM   1746  CB  ILE B  55     -13.790  40.507  47.590  1.00 12.89           C  
ATOM   1747  CG1 ILE B  55     -12.459  40.041  48.205  1.00 12.56           C  
ATOM   1748  CG2 ILE B  55     -14.821  39.392  47.626  1.00 12.22           C  
ATOM   1749  CD1 ILE B  55     -12.482  39.986  49.732  1.00 12.94           C  
ATOM   1750  N   LEU B  56     -15.444  40.891  44.556  1.00 12.44           N  
ATOM   1751  CA  LEU B  56     -16.691  41.332  43.950  1.00 12.68           C  
ATOM   1752  C   LEU B  56     -17.771  40.296  44.217  1.00 13.19           C  
ATOM   1753  O   LEU B  56     -17.485  39.093  44.333  1.00 12.39           O  
ATOM   1754  CB  LEU B  56     -16.535  41.535  42.437  1.00 12.58           C  
ATOM   1755  CG  LEU B  56     -15.349  42.347  41.925  1.00 12.28           C  
ATOM   1756  CD1 LEU B  56     -15.296  42.276  40.415  1.00 12.64           C  
ATOM   1757  CD2 LEU B  56     -15.410  43.826  42.392  1.00 11.13           C  
ATOM   1758  N   VAL B  57     -19.014  40.763  44.318  1.00 13.47           N  
ATOM   1759  CA  VAL B  57     -20.143  39.860  44.445  1.00 14.62           C  
ATOM   1760  C   VAL B  57     -21.139  40.135  43.326  1.00 15.76           C  
ATOM   1761  O   VAL B  57     -21.250  41.275  42.838  1.00 16.44           O  
ATOM   1762  CB  VAL B  57     -20.855  39.951  45.842  1.00 14.82           C  
ATOM   1763  CG1 VAL B  57     -19.966  39.392  46.956  1.00 14.83           C  
ATOM   1764  CG2 VAL B  57     -21.281  41.379  46.159  1.00 15.12           C  
ATOM   1765  N   ALA B  58     -21.834  39.081  42.917  1.00 16.64           N  
ATOM   1766  CA  ALA B  58     -23.028  39.183  42.089  1.00 18.33           C  
ATOM   1767  C   ALA B  58     -24.187  39.143  43.067  1.00 19.75           C  
ATOM   1768  O   ALA B  58     -24.333  38.184  43.823  1.00 19.40           O  
ATOM   1769  CB  ALA B  58     -23.106  38.023  41.106  1.00 18.03           C  
ATOM   1770  N   SER B  59     -24.998  40.195  43.076  1.00 21.90           N  
ATOM   1771  CA  SER B  59     -25.991  40.355  44.130  1.00 24.08           C  
ATOM   1772  C   SER B  59     -27.371  40.590  43.531  1.00 25.05           C  
ATOM   1773  O   SER B  59     -27.492  41.089  42.407  1.00 25.28           O  
ATOM   1774  CB  SER B  59     -25.585  41.507  45.060  1.00 24.44           C  
ATOM   1775  OG  SER B  59     -26.481  41.663  46.143  1.00 26.25           O  
ATOM   1776  N   ASP B  60     -28.402  40.183  44.263  1.00 26.30           N  
ATOM   1777  CA  ASP B  60     -29.772  40.531  43.882  1.00 27.69           C  
ATOM   1778  C   ASP B  60     -30.325  41.619  44.795  1.00 28.22           C  
ATOM   1779  O   ASP B  60     -29.619  42.120  45.683  1.00 28.50           O  
ATOM   1780  CB  ASP B  60     -30.685  39.296  43.823  1.00 27.61           C  
ATOM   1781  CG  ASP B  60     -30.905  38.643  45.177  1.00 28.70           C  
ATOM   1782  OD1 ASP B  60     -30.600  39.262  46.226  1.00 29.88           O  
ATOM   1783  OD2 ASP B  60     -31.409  37.495  45.184  1.00 28.73           O  
ATOM   1784  N   ALA B  61     -31.586  41.976  44.564  1.00 29.34           N  
ATOM   1785  CA  ALA B  61     -32.270  43.041  45.298  1.00 29.59           C  
ATOM   1786  C   ALA B  61     -32.168  42.887  46.821  1.00 29.92           C  
ATOM   1787  O   ALA B  61     -31.801  43.833  47.522  1.00 30.02           O  
ATOM   1788  CB  ALA B  61     -33.719  43.097  44.866  1.00 29.94           C  
ATOM   1789  N   ALA B  62     -32.487  41.689  47.314  1.00 30.16           N  
ATOM   1790  CA  ALA B  62     -32.438  41.366  48.749  1.00 30.16           C  
ATOM   1791  C   ALA B  62     -31.018  41.349  49.336  1.00 30.08           C  
ATOM   1792  O   ALA B  62     -30.839  41.228  50.554  1.00 30.33           O  
ATOM   1793  CB  ALA B  62     -33.143  40.026  49.011  1.00 30.26           C  
ATOM   1794  N   GLY B  63     -30.016  41.472  48.468  1.00 29.53           N  
ATOM   1795  CA  GLY B  63     -28.628  41.435  48.893  1.00 28.72           C  
ATOM   1796  C   GLY B  63     -28.106  40.020  49.062  1.00 27.88           C  
ATOM   1797  O   GLY B  63     -27.085  39.815  49.726  1.00 28.45           O  
ATOM   1798  N   GLU B  64     -28.812  39.049  48.480  1.00 26.10           N  
ATOM   1799  CA  GLU B  64     -28.334  37.670  48.416  1.00 25.02           C  
ATOM   1800  C   GLU B  64     -27.079  37.624  47.547  1.00 22.26           C  
ATOM   1801  O   GLU B  64     -27.034  38.247  46.490  1.00 21.52           O  
ATOM   1802  CB  GLU B  64     -29.386  36.747  47.788  1.00 25.45           C  
ATOM   1803  CG  GLU B  64     -30.540  36.347  48.690  1.00 27.44           C  
ATOM   1804  CD  GLU B  64     -31.615  35.562  47.940  1.00 27.97           C  
ATOM   1805  OE1 GLU B  64     -31.390  34.355  47.638  1.00 31.40           O  
ATOM   1806  OE2 GLU B  64     -32.695  36.154  47.670  1.00 31.50           O  
ATOM   1807  N   VAL B  65     -26.067  36.894  48.003  1.00 19.64           N  
ATOM   1808  CA  VAL B  65     -24.852  36.704  47.219  1.00 17.02           C  
ATOM   1809  C   VAL B  65     -25.115  35.531  46.266  1.00 15.66           C  
ATOM   1810  O   VAL B  65     -25.291  34.397  46.701  1.00 15.66           O  
ATOM   1811  CB  VAL B  65     -23.634  36.416  48.133  1.00 16.76           C  
ATOM   1812  CG1 VAL B  65     -22.367  36.185  47.299  1.00 15.66           C  
ATOM   1813  CG2 VAL B  65     -23.429  37.564  49.132  1.00 17.01           C  
ATOM   1814  N   LEU B  66     -25.161  35.820  44.971  1.00 14.16           N  
ATOM   1815  CA  LEU B  66     -25.402  34.806  43.941  1.00 13.16           C  
ATOM   1816  C   LEU B  66     -24.083  34.213  43.421  1.00 12.52           C  
ATOM   1817  O   LEU B  66     -24.059  33.130  42.844  1.00 12.80           O  
ATOM   1818  CB  LEU B  66     -26.163  35.424  42.773  1.00 12.90           C  
ATOM   1819  CG  LEU B  66     -27.463  36.171  43.101  1.00 13.82           C  
ATOM   1820  CD1 LEU B  66     -27.995  36.828  41.841  1.00 14.68           C  
ATOM   1821  CD2 LEU B  66     -28.472  35.214  43.694  1.00 13.14           C  
ATOM   1822  N   GLY B  67     -23.000  34.960  43.603  1.00 11.92           N  
ATOM   1823  CA  GLY B  67     -21.672  34.496  43.226  1.00 11.00           C  
ATOM   1824  C   GLY B  67     -20.649  35.504  43.698  1.00 11.07           C  
ATOM   1825  O   GLY B  67     -21.009  36.614  44.104  1.00  9.86           O  
ATOM   1826  N   TYR B  68     -19.376  35.130  43.661  1.00 10.02           N  
ATOM   1827  CA  TYR B  68     -18.327  36.098  43.998  1.00 10.86           C  
ATOM   1828  C   TYR B  68     -17.028  35.786  43.275  1.00 10.46           C  
ATOM   1829  O   TYR B  68     -16.855  34.682  42.753  1.00 10.30           O  
ATOM   1830  CB  TYR B  68     -18.104  36.193  45.519  1.00 10.77           C  
ATOM   1831  CG  TYR B  68     -17.358  35.026  46.152  1.00 12.43           C  
ATOM   1832  CD1 TYR B  68     -15.976  35.089  46.364  1.00 13.07           C  
ATOM   1833  CD2 TYR B  68     -18.045  33.882  46.570  1.00 12.70           C  
ATOM   1834  CE1 TYR B  68     -15.294  34.031  46.961  1.00 14.32           C  
ATOM   1835  CE2 TYR B  68     -17.387  32.831  47.168  1.00 13.49           C  
ATOM   1836  CZ  TYR B  68     -16.016  32.907  47.366  1.00 13.03           C  
ATOM   1837  OH  TYR B  68     -15.366  31.860  47.958  1.00 14.81           O  
ATOM   1838  N   ALA B  69     -16.126  36.766  43.254  1.00 10.63           N  
ATOM   1839  CA  ALA B  69     -14.858  36.640  42.547  1.00 10.92           C  
ATOM   1840  C   ALA B  69     -13.793  37.480  43.224  1.00 10.93           C  
ATOM   1841  O   ALA B  69     -14.077  38.554  43.752  1.00 10.72           O  
ATOM   1842  CB  ALA B  69     -15.001  37.065  41.087  1.00 10.88           C  
ATOM   1843  N   SER B  70     -12.561  36.981  43.223  1.00  9.88           N  
ATOM   1844  CA  SER B  70     -11.461  37.763  43.767  1.00  9.86           C  
ATOM   1845  C   SER B  70     -10.174  37.330  43.073  1.00  9.97           C  
ATOM   1846  O   SER B  70     -10.160  36.352  42.315  1.00  9.70           O  
ATOM   1847  CB  SER B  70     -11.352  37.556  45.293  1.00 10.27           C  
ATOM   1848  OG  SER B  70     -10.491  38.531  45.875  1.00 11.12           O  
ATOM   1849  N   TYR B  71      -9.098  38.048  43.331  1.00  9.48           N  
ATOM   1850  CA  TYR B  71      -7.773  37.528  42.996  1.00 10.38           C  
ATOM   1851  C   TYR B  71      -6.773  37.830  44.081  1.00 10.91           C  
ATOM   1852  O   TYR B  71      -6.959  38.760  44.862  1.00 10.15           O  
ATOM   1853  CB  TYR B  71      -7.277  37.998  41.620  1.00  9.94           C  
ATOM   1854  CG  TYR B  71      -7.294  39.483  41.362  1.00 10.87           C  
ATOM   1855  CD1 TYR B  71      -6.358  40.342  41.945  1.00 11.18           C  
ATOM   1856  CD2 TYR B  71      -8.229  40.028  40.487  1.00 12.14           C  
ATOM   1857  CE1 TYR B  71      -6.365  41.719  41.663  1.00 11.40           C  
ATOM   1858  CE2 TYR B  71      -8.251  41.387  40.212  1.00 12.08           C  
ATOM   1859  CZ  TYR B  71      -7.325  42.227  40.803  1.00 11.46           C  
ATOM   1860  OH  TYR B  71      -7.362  43.579  40.509  1.00 12.56           O  
ATOM   1861  N   GLY B  72      -5.735  36.994  44.147  1.00 11.28           N  
ATOM   1862  CA  GLY B  72      -4.650  37.182  45.087  1.00 11.94           C  
ATOM   1863  C   GLY B  72      -3.329  36.930  44.397  1.00 12.58           C  
ATOM   1864  O   GLY B  72      -3.266  36.801  43.163  1.00 11.80           O  
ATOM   1865  N   ASP B  73      -2.269  36.837  45.190  1.00 13.73           N  
ATOM   1866  CA  ASP B  73      -0.951  36.556  44.629  1.00 15.13           C  
ATOM   1867  C   ASP B  73      -0.918  35.121  44.135  1.00 15.11           C  
ATOM   1868  O   ASP B  73      -1.638  34.243  44.656  1.00 15.42           O  
ATOM   1869  CB  ASP B  73       0.138  36.799  45.664  1.00 15.96           C  
ATOM   1870  CG  ASP B  73       0.204  38.231  46.093  1.00 17.79           C  
ATOM   1871  OD1 ASP B  73       0.053  39.131  45.233  1.00 21.97           O  
ATOM   1872  OD2 ASP B  73       0.411  38.455  47.298  1.00 24.52           O  
ATOM   1873  N   TRP B  74      -0.112  34.892  43.100  1.00 14.87           N  
ATOM   1874  CA  TRP B  74       0.002  33.570  42.497  1.00 15.01           C  
ATOM   1875  C   TRP B  74       1.199  32.809  43.080  1.00 15.95           C  
ATOM   1876  O   TRP B  74       1.055  31.665  43.516  1.00 16.59           O  
ATOM   1877  CB  TRP B  74       0.075  33.688  40.969  1.00 14.96           C  
ATOM   1878  CG  TRP B  74       0.266  32.378  40.265  1.00 14.45           C  
ATOM   1879  CD1 TRP B  74      -0.519  31.269  40.371  1.00 15.07           C  
ATOM   1880  CD2 TRP B  74       1.326  32.035  39.362  1.00 13.92           C  
ATOM   1881  NE1 TRP B  74      -0.017  30.256  39.595  1.00 15.47           N  
ATOM   1882  CE2 TRP B  74       1.111  30.700  38.956  1.00 14.48           C  
ATOM   1883  CE3 TRP B  74       2.435  32.728  38.853  1.00 14.47           C  
ATOM   1884  CZ2 TRP B  74       1.954  30.042  38.054  1.00 14.47           C  
ATOM   1885  CZ3 TRP B  74       3.281  32.070  37.959  1.00 14.07           C  
ATOM   1886  CH2 TRP B  74       3.036  30.737  37.577  1.00 14.46           C  
ATOM   1887  N   ARG B  75       2.369  33.444  43.091  1.00 15.72           N  
ATOM   1888  CA  ARG B  75       3.550  32.899  43.740  1.00 16.83           C  
ATOM   1889  C   ARG B  75       4.132  33.973  44.671  1.00 18.52           C  
ATOM   1890  O   ARG B  75       4.137  35.153  44.310  1.00 18.63           O  
ATOM   1891  CB  ARG B  75       4.581  32.438  42.707  1.00 16.36           C  
ATOM   1892  CG  ARG B  75       4.161  31.176  41.951  1.00 15.82           C  
ATOM   1893  CD  ARG B  75       5.155  30.779  40.864  1.00 16.10           C  
ATOM   1894  NE  ARG B  75       6.489  30.501  41.384  1.00 15.91           N  
ATOM   1895  CZ  ARG B  75       6.879  29.337  41.911  1.00 17.20           C  
ATOM   1896  NH1 ARG B  75       6.037  28.307  42.014  1.00 16.18           N  
ATOM   1897  NH2 ARG B  75       8.124  29.207  42.346  1.00 15.50           N  
ATOM   1898  N   PRO B  76       4.583  33.573  45.881  1.00 19.96           N  
ATOM   1899  CA  PRO B  76       5.081  34.496  46.912  1.00 20.99           C  
ATOM   1900  C   PRO B  76       6.521  34.966  46.731  1.00 21.47           C  
ATOM   1901  O   PRO B  76       7.361  34.731  47.610  1.00 22.41           O  
ATOM   1902  CB  PRO B  76       4.984  33.654  48.192  1.00 20.95           C  
ATOM   1903  CG  PRO B  76       5.303  32.267  47.713  1.00 21.08           C  
ATOM   1904  CD  PRO B  76       4.592  32.173  46.369  1.00 20.19           C  
ATOM   1905  N   PHE B  77       6.812  35.610  45.606  1.00 21.52           N  
ATOM   1906  CA  PHE B  77       8.116  36.222  45.370  1.00 21.35           C  
ATOM   1907  C   PHE B  77       7.881  37.555  44.654  1.00 20.82           C  
ATOM   1908  O   PHE B  77       6.942  37.682  43.846  1.00 19.85           O  
ATOM   1909  CB  PHE B  77       9.030  35.309  44.519  1.00 22.19           C  
ATOM   1910  CG  PHE B  77       9.236  33.923  45.091  1.00 23.22           C  
ATOM   1911  CD1 PHE B  77      10.345  33.643  45.888  1.00 25.00           C  
ATOM   1912  CD2 PHE B  77       8.318  32.899  44.834  1.00 23.91           C  
ATOM   1913  CE1 PHE B  77      10.535  32.361  46.428  1.00 25.80           C  
ATOM   1914  CE2 PHE B  77       8.495  31.615  45.371  1.00 25.32           C  
ATOM   1915  CZ  PHE B  77       9.610  31.345  46.165  1.00 24.52           C  
ATOM   1916  N   GLU B  78       8.731  38.541  44.935  1.00 20.16           N  
ATOM   1917  CA  GLU B  78       8.561  39.884  44.362  1.00 20.21           C  
ATOM   1918  C   GLU B  78       8.570  39.904  42.820  1.00 18.88           C  
ATOM   1919  O   GLU B  78       7.915  40.750  42.206  1.00 18.40           O  
ATOM   1920  CB  GLU B  78       9.583  40.884  44.928  1.00 20.22           C  
ATOM   1921  CG  GLU B  78      11.034  40.641  44.525  1.00 21.85           C  
ATOM   1922  CD  GLU B  78      11.991  41.735  44.997  1.00 22.48           C  
ATOM   1923  OE1 GLU B  78      11.797  42.279  46.120  1.00 25.75           O  
ATOM   1924  OE2 GLU B  78      12.955  42.034  44.252  1.00 23.39           O  
ATOM   1925  N   GLY B  79       9.296  38.969  42.207  1.00 17.61           N  
ATOM   1926  CA  GLY B  79       9.347  38.879  40.743  1.00 16.39           C  
ATOM   1927  C   GLY B  79       8.011  38.548  40.092  1.00 15.81           C  
ATOM   1928  O   GLY B  79       7.863  38.683  38.875  1.00 15.65           O  
ATOM   1929  N   PHE B  80       7.042  38.116  40.899  1.00 14.60           N  
ATOM   1930  CA  PHE B  80       5.708  37.746  40.405  1.00 14.79           C  
ATOM   1931  C   PHE B  80       4.627  38.816  40.637  1.00 14.69           C  
ATOM   1932  O   PHE B  80       3.438  38.577  40.398  1.00 14.53           O  
ATOM   1933  CB  PHE B  80       5.278  36.408  40.997  1.00 14.35           C  
ATOM   1934  CG  PHE B  80       6.115  35.253  40.532  1.00 15.92           C  
ATOM   1935  CD1 PHE B  80       5.880  34.661  39.295  1.00 16.50           C  
ATOM   1936  CD2 PHE B  80       7.160  34.773  41.315  1.00 14.93           C  
ATOM   1937  CE1 PHE B  80       6.674  33.600  38.856  1.00 17.25           C  
ATOM   1938  CE2 PHE B  80       7.951  33.716  40.890  1.00 15.84           C  
ATOM   1939  CZ  PHE B  80       7.704  33.122  39.661  1.00 16.50           C  
ATOM   1940  N   ARG B  81       5.050  40.006  41.041  1.00 14.87           N  
ATOM   1941  CA  ARG B  81       4.112  41.091  41.344  1.00 16.01           C  
ATOM   1942  C   ARG B  81       3.154  41.502  40.197  1.00 15.89           C  
ATOM   1943  O   ARG B  81       2.090  42.070  40.448  1.00 15.94           O  
ATOM   1944  CB  ARG B  81       4.854  42.303  41.916  1.00 16.56           C  
ATOM   1945  CG  ARG B  81       5.891  42.902  40.997  1.00 18.95           C  
ATOM   1946  CD  ARG B  81       6.763  43.877  41.771  1.00 23.53           C  
ATOM   1947  NE  ARG B  81       7.765  44.545  40.952  1.00 25.93           N  
ATOM   1948  CZ  ARG B  81       8.987  44.073  40.701  1.00 28.06           C  
ATOM   1949  NH1 ARG B  81       9.376  42.900  41.191  1.00 28.42           N  
ATOM   1950  NH2 ARG B  81       9.824  44.780  39.953  1.00 27.92           N  
ATOM   1951  N   GLY B  82       3.506  41.208  38.949  1.00 15.89           N  
ATOM   1952  CA  GLY B  82       2.563  41.464  37.831  1.00 15.67           C  
ATOM   1953  C   GLY B  82       1.480  40.406  37.593  1.00 14.75           C  
ATOM   1954  O   GLY B  82       0.617  40.567  36.715  1.00 14.95           O  
ATOM   1955  N   THR B  83       1.516  39.330  38.374  1.00 13.13           N  
ATOM   1956  CA  THR B  83       0.689  38.157  38.127  1.00 11.93           C  
ATOM   1957  C   THR B  83      -0.205  37.895  39.331  1.00 11.07           C  
ATOM   1958  O   THR B  83       0.256  37.918  40.472  1.00 11.38           O  
ATOM   1959  CB  THR B  83       1.583  36.922  37.827  1.00 11.48           C  
ATOM   1960  OG1 THR B  83       2.486  37.238  36.745  1.00 12.46           O  
ATOM   1961  CG2 THR B  83       0.762  35.716  37.434  1.00 12.00           C  
ATOM   1962  N   VAL B  84      -1.490  37.670  39.076  1.00 10.72           N  
ATOM   1963  CA  VAL B  84      -2.409  37.313  40.145  1.00 10.04           C  
ATOM   1964  C   VAL B  84      -3.147  36.054  39.741  1.00 10.35           C  
ATOM   1965  O   VAL B  84      -3.245  35.744  38.534  1.00  9.77           O  
ATOM   1966  CB  VAL B  84      -3.429  38.439  40.466  1.00  9.71           C  
ATOM   1967  CG1 VAL B  84      -2.735  39.663  41.091  1.00 10.12           C  
ATOM   1968  CG2 VAL B  84      -4.251  38.834  39.223  1.00  8.69           C  
ATOM   1969  N   GLU B  85      -3.671  35.340  40.736  1.00 10.32           N  
ATOM   1970  CA  GLU B  85      -4.492  34.179  40.467  1.00 11.47           C  
ATOM   1971  C   GLU B  85      -5.893  34.459  40.984  1.00 11.61           C  
ATOM   1972  O   GLU B  85      -6.072  34.814  42.139  1.00 10.62           O  
ATOM   1973  CB  GLU B  85      -3.923  32.905  41.105  1.00 11.93           C  
ATOM   1974  CG  GLU B  85      -4.917  31.722  41.008  1.00 13.26           C  
ATOM   1975  CD  GLU B  85      -4.463  30.475  41.712  1.00 13.94           C  
ATOM   1976  OE1 GLU B  85      -3.251  30.320  41.979  1.00 17.66           O  
ATOM   1977  OE2 GLU B  85      -5.342  29.637  42.009  1.00 15.30           O  
ATOM   1978  N   HIS B  86      -6.882  34.298  40.116  1.00 10.87           N  
ATOM   1979  CA  HIS B  86      -8.231  34.651  40.478  1.00 12.19           C  
ATOM   1980  C   HIS B  86      -9.059  33.409  40.814  1.00 12.76           C  
ATOM   1981  O   HIS B  86      -8.657  32.260  40.514  1.00 12.46           O  
ATOM   1982  CB  HIS B  86      -8.885  35.467  39.360  1.00 12.08           C  
ATOM   1983  CG  HIS B  86      -9.260  34.648  38.163  1.00 14.30           C  
ATOM   1984  ND1 HIS B  86      -8.371  34.370  37.146  1.00 16.23           N  
ATOM   1985  CD2 HIS B  86     -10.414  34.015  37.841  1.00 14.43           C  
ATOM   1986  CE1 HIS B  86      -8.971  33.623  36.235  1.00 16.57           C  
ATOM   1987  NE2 HIS B  86     -10.200  33.371  36.645  1.00 16.50           N  
ATOM   1988  N   SER B  87     -10.200  33.637  41.455  1.00 12.72           N  
ATOM   1989  CA  SER B  87     -11.193  32.582  41.656  1.00 13.39           C  
ATOM   1990  C   SER B  87     -12.587  33.172  41.457  1.00 13.25           C  
ATOM   1991  O   SER B  87     -12.825  34.331  41.791  1.00 12.61           O  
ATOM   1992  CB  SER B  87     -11.055  31.962  43.048  1.00 15.03           C  
ATOM   1993  OG  SER B  87     -11.324  32.926  44.043  1.00 19.30           O  
ATOM   1994  N   VAL B  88     -13.492  32.388  40.885  1.00 12.20           N  
ATOM   1995  CA  VAL B  88     -14.864  32.841  40.623  1.00 12.74           C  
ATOM   1996  C   VAL B  88     -15.770  31.712  41.052  1.00 12.80           C  
ATOM   1997  O   VAL B  88     -15.585  30.584  40.607  1.00 11.94           O  
ATOM   1998  CB  VAL B  88     -15.107  33.168  39.103  1.00 12.35           C  
ATOM   1999  CG1 VAL B  88     -16.566  33.592  38.835  1.00 13.25           C  
ATOM   2000  CG2 VAL B  88     -14.187  34.264  38.630  1.00 15.55           C  
ATOM   2001  N   TYR B  89     -16.740  32.013  41.915  1.00 13.44           N  
ATOM   2002  CA  TYR B  89     -17.708  31.010  42.369  1.00 14.96           C  
ATOM   2003  C   TYR B  89     -19.120  31.504  42.111  1.00 14.47           C  
ATOM   2004  O   TYR B  89     -19.441  32.654  42.406  1.00 14.00           O  
ATOM   2005  CB  TYR B  89     -17.518  30.724  43.865  1.00 16.56           C  
ATOM   2006  CG  TYR B  89     -16.094  30.327  44.194  1.00 20.22           C  
ATOM   2007  CD1 TYR B  89     -15.651  29.030  43.967  1.00 24.11           C  
ATOM   2008  CD2 TYR B  89     -15.184  31.260  44.686  1.00 21.90           C  
ATOM   2009  CE1 TYR B  89     -14.331  28.669  44.228  1.00 26.37           C  
ATOM   2010  CE2 TYR B  89     -13.876  30.903  44.964  1.00 24.06           C  
ATOM   2011  CZ  TYR B  89     -13.463  29.604  44.731  1.00 22.60           C  
ATOM   2012  OH  TYR B  89     -12.160  29.237  44.989  1.00 26.36           O  
ATOM   2013  N   VAL B  90     -19.944  30.642  41.534  1.00 14.22           N  
ATOM   2014  CA  VAL B  90     -21.359  30.924  41.325  1.00 14.45           C  
ATOM   2015  C   VAL B  90     -22.182  29.969  42.191  1.00 14.84           C  
ATOM   2016  O   VAL B  90     -21.899  28.768  42.241  1.00 14.71           O  
ATOM   2017  CB  VAL B  90     -21.724  30.808  39.816  1.00 14.99           C  
ATOM   2018  CG1 VAL B  90     -23.222  30.941  39.585  1.00 14.98           C  
ATOM   2019  CG2 VAL B  90     -20.971  31.887  39.014  1.00 14.86           C  
ATOM   2020  N   ARG B  91     -23.187  30.498  42.890  1.00 15.19           N  
ATOM   2021  CA  ARG B  91     -24.068  29.651  43.683  1.00 15.48           C  
ATOM   2022  C   ARG B  91     -24.687  28.588  42.772  1.00 16.04           C  
ATOM   2023  O   ARG B  91     -25.104  28.882  41.646  1.00 15.66           O  
ATOM   2024  CB  ARG B  91     -25.159  30.486  44.360  1.00 16.15           C  
ATOM   2025  CG  ARG B  91     -25.685  29.891  45.664  1.00 17.80           C  
ATOM   2026  CD  ARG B  91     -26.533  30.920  46.423  1.00 19.89           C  
ATOM   2027  NE  ARG B  91     -27.809  31.164  45.756  1.00 22.08           N  
ATOM   2028  CZ  ARG B  91     -28.767  31.984  46.203  1.00 24.73           C  
ATOM   2029  NH1 ARG B  91     -28.605  32.674  47.326  1.00 24.62           N  
ATOM   2030  NH2 ARG B  91     -29.894  32.133  45.510  1.00 23.78           N  
ATOM   2031  N   ASP B  92     -24.718  27.353  43.255  1.00 16.29           N  
ATOM   2032  CA  ASP B  92     -25.160  26.219  42.446  1.00 17.29           C  
ATOM   2033  C   ASP B  92     -26.491  26.453  41.676  1.00 17.22           C  
ATOM   2034  O   ASP B  92     -26.598  26.127  40.487  1.00 17.52           O  
ATOM   2035  CB  ASP B  92     -25.248  24.966  43.325  1.00 17.94           C  
ATOM   2036  CG  ASP B  92     -25.517  23.716  42.516  1.00 18.94           C  
ATOM   2037  OD1 ASP B  92     -24.668  23.379  41.686  1.00 22.26           O  
ATOM   2038  OD2 ASP B  92     -26.574  23.088  42.703  1.00 21.68           O  
ATOM   2039  N   ASP B  93     -27.483  27.036  42.339  1.00 17.70           N  
ATOM   2040  CA  ASP B  93     -28.790  27.267  41.709  1.00 18.37           C  
ATOM   2041  C   ASP B  93     -28.764  28.410  40.684  1.00 17.86           C  
ATOM   2042  O   ASP B  93     -29.722  28.611  39.944  1.00 17.78           O  
ATOM   2043  CB  ASP B  93     -29.858  27.548  42.764  1.00 19.21           C  
ATOM   2044  CG  ASP B  93     -29.664  28.881  43.438  1.00 21.22           C  
ATOM   2045  OD1 ASP B  93     -28.631  29.063  44.108  1.00 24.52           O  
ATOM   2046  OD2 ASP B  93     -30.541  29.764  43.298  1.00 25.30           O  
ATOM   2047  N   GLN B  94     -27.659  29.151  40.651  1.00 16.95           N  
ATOM   2048  CA  GLN B  94     -27.516  30.287  39.747  1.00 16.68           C  
ATOM   2049  C   GLN B  94     -26.678  29.952  38.520  1.00 15.58           C  
ATOM   2050  O   GLN B  94     -26.349  30.832  37.726  1.00 16.02           O  
ATOM   2051  CB  GLN B  94     -26.925  31.480  40.509  1.00 16.80           C  
ATOM   2052  CG  GLN B  94     -27.865  32.026  41.589  1.00 18.25           C  
ATOM   2053  CD  GLN B  94     -29.159  32.588  41.003  1.00 21.11           C  
ATOM   2054  OE1 GLN B  94     -29.143  33.314  40.000  1.00 22.37           O  
ATOM   2055  NE2 GLN B  94     -30.285  32.253  41.626  1.00 21.23           N  
ATOM   2056  N   ARG B  95     -26.325  28.678  38.372  1.00 14.98           N  
ATOM   2057  CA  ARG B  95     -25.544  28.238  37.218  1.00 14.71           C  
ATOM   2058  C   ARG B  95     -26.390  28.333  35.952  1.00 14.80           C  
ATOM   2059  O   ARG B  95     -27.619  28.227  36.013  1.00 14.80           O  
ATOM   2060  CB  ARG B  95     -25.047  26.800  37.410  1.00 14.61           C  
ATOM   2061  CG  ARG B  95     -23.927  26.666  38.432  1.00 14.14           C  
ATOM   2062  CD  ARG B  95     -23.606  25.202  38.707  1.00 15.41           C  
ATOM   2063  NE  ARG B  95     -23.131  24.507  37.513  1.00 15.19           N  
ATOM   2064  CZ  ARG B  95     -21.853  24.435  37.148  1.00 18.64           C  
ATOM   2065  NH1 ARG B  95     -20.912  25.015  37.885  1.00 18.12           N  
ATOM   2066  NH2 ARG B  95     -21.512  23.780  36.046  1.00 18.13           N  
ATOM   2067  N   GLY B  96     -25.724  28.543  34.818  1.00 15.10           N  
ATOM   2068  CA  GLY B  96     -26.396  28.584  33.515  1.00 15.24           C  
ATOM   2069  C   GLY B  96     -27.070  29.905  33.206  1.00 15.24           C  
ATOM   2070  O   GLY B  96     -27.981  29.966  32.371  1.00 15.44           O  
ATOM   2071  N   LYS B  97     -26.624  30.965  33.872  1.00 14.66           N  
ATOM   2072  CA  LYS B  97     -27.227  32.291  33.706  1.00 14.59           C  
ATOM   2073  C   LYS B  97     -26.202  33.340  33.265  1.00 14.22           C  
ATOM   2074  O   LYS B  97     -26.521  34.527  33.179  1.00 15.05           O  
ATOM   2075  CB  LYS B  97     -27.867  32.739  35.017  1.00 14.56           C  
ATOM   2076  CG  LYS B  97     -29.085  31.952  35.446  1.00 16.44           C  
ATOM   2077  CD  LYS B  97     -29.523  32.420  36.813  1.00 19.61           C  
ATOM   2078  CE  LYS B  97     -30.672  31.599  37.350  1.00 22.89           C  
ATOM   2079  NZ  LYS B  97     -31.429  32.340  38.402  1.00 24.76           N  
ATOM   2080  N   GLY B  98     -24.972  32.910  33.002  1.00 13.49           N  
ATOM   2081  CA  GLY B  98     -23.914  33.827  32.576  1.00 13.04           C  
ATOM   2082  C   GLY B  98     -23.324  34.688  33.689  1.00 13.29           C  
ATOM   2083  O   GLY B  98     -22.628  35.658  33.403  1.00 12.82           O  
ATOM   2084  N   LEU B  99     -23.574  34.332  34.951  1.00 12.75           N  
ATOM   2085  CA  LEU B  99     -23.058  35.125  36.083  1.00 13.65           C  
ATOM   2086  C   LEU B  99     -21.539  35.018  36.224  1.00 13.08           C  
ATOM   2087  O   LEU B  99     -20.873  35.991  36.545  1.00 12.69           O  
ATOM   2088  CB  LEU B  99     -23.729  34.743  37.412  1.00 14.02           C  
ATOM   2089  CG  LEU B  99     -25.218  35.085  37.559  1.00 17.02           C  
ATOM   2090  CD1 LEU B  99     -25.741  34.567  38.884  1.00 18.45           C  
ATOM   2091  CD2 LEU B  99     -25.467  36.580  37.445  1.00 19.64           C  
ATOM   2092  N   GLY B 100     -21.002  33.824  35.983  1.00 13.56           N  
ATOM   2093  CA  GLY B 100     -19.551  33.616  35.981  1.00 13.43           C  
ATOM   2094  C   GLY B 100     -18.853  34.527  34.995  1.00 14.16           C  
ATOM   2095  O   GLY B 100     -17.802  35.102  35.312  1.00 13.65           O  
ATOM   2096  N   VAL B 101     -19.431  34.668  33.801  1.00 13.84           N  
ATOM   2097  CA  VAL B 101     -18.902  35.604  32.796  1.00 14.71           C  
ATOM   2098  C   VAL B 101     -18.931  37.060  33.281  1.00 14.33           C  
ATOM   2099  O   VAL B 101     -17.937  37.787  33.140  1.00 14.43           O  
ATOM   2100  CB  VAL B 101     -19.645  35.500  31.433  1.00 15.03           C  
ATOM   2101  CG1 VAL B 101     -19.076  36.505  30.453  1.00 15.85           C  
ATOM   2102  CG2 VAL B 101     -19.517  34.104  30.858  1.00 15.65           C  
ATOM   2103  N   GLN B 102     -20.065  37.481  33.841  1.00 14.17           N  
ATOM   2104  CA  GLN B 102     -20.207  38.847  34.358  1.00 14.48           C  
ATOM   2105  C   GLN B 102     -19.159  39.132  35.416  1.00 13.69           C  
ATOM   2106  O   GLN B 102     -18.518  40.193  35.405  1.00 13.25           O  
ATOM   2107  CB  GLN B 102     -21.584  39.054  34.976  1.00 14.55           C  
ATOM   2108  CG  GLN B 102     -22.694  39.248  33.974  1.00 18.60           C  
ATOM   2109  CD  GLN B 102     -23.970  39.706  34.648  1.00 23.61           C  
ATOM   2110  OE1 GLN B 102     -23.979  40.696  35.391  1.00 26.29           O  
ATOM   2111  NE2 GLN B 102     -25.060  38.986  34.397  1.00 27.14           N  
ATOM   2112  N   LEU B 103     -18.988  38.177  36.326  1.00 12.64           N  
ATOM   2113  CA  LEU B 103     -18.038  38.334  37.429  1.00 12.15           C  
ATOM   2114  C   LEU B 103     -16.611  38.446  36.917  1.00 12.41           C  
ATOM   2115  O   LEU B 103     -15.858  39.333  37.333  1.00 11.80           O  
ATOM   2116  CB  LEU B 103     -18.174  37.185  38.438  1.00 11.57           C  
ATOM   2117  CG  LEU B 103     -19.314  37.367  39.456  1.00 11.24           C  
ATOM   2118  CD1 LEU B 103     -19.734  36.035  40.076  1.00 12.49           C  
ATOM   2119  CD2 LEU B 103     -18.956  38.371  40.555  1.00 10.79           C  
ATOM   2120  N   LEU B 104     -16.245  37.545  36.012  1.00 12.30           N  
ATOM   2121  CA  LEU B 104     -14.880  37.499  35.509  1.00 12.97           C  
ATOM   2122  C   LEU B 104     -14.592  38.688  34.610  1.00 12.95           C  
ATOM   2123  O   LEU B 104     -13.502  39.242  34.669  1.00 13.00           O  
ATOM   2124  CB  LEU B 104     -14.597  36.169  34.795  1.00 13.03           C  
ATOM   2125  CG  LEU B 104     -13.171  35.889  34.304  1.00 14.26           C  
ATOM   2126  CD1 LEU B 104     -12.066  36.182  35.353  1.00 15.12           C  
ATOM   2127  CD2 LEU B 104     -13.097  34.446  33.841  1.00 14.00           C  
ATOM   2128  N   GLN B 105     -15.558  39.093  33.788  1.00 13.33           N  
ATOM   2129  CA  GLN B 105     -15.385  40.320  33.005  1.00 14.39           C  
ATOM   2130  C   GLN B 105     -15.065  41.504  33.914  1.00 13.89           C  
ATOM   2131  O   GLN B 105     -14.168  42.296  33.628  1.00 14.43           O  
ATOM   2132  CB  GLN B 105     -16.634  40.643  32.202  1.00 15.35           C  
ATOM   2133  CG  GLN B 105     -16.809  39.784  30.984  1.00 18.24           C  
ATOM   2134  CD  GLN B 105     -18.054  40.147  30.229  1.00 23.05           C  
ATOM   2135  OE1 GLN B 105     -19.068  40.556  30.823  1.00 25.00           O  
ATOM   2136  NE2 GLN B 105     -18.004  39.992  28.906  1.00 23.39           N  
ATOM   2137  N   ALA B 106     -15.803  41.620  35.010  1.00 13.59           N  
ATOM   2138  CA  ALA B 106     -15.614  42.725  35.950  1.00 13.77           C  
ATOM   2139  C   ALA B 106     -14.245  42.674  36.624  1.00 13.50           C  
ATOM   2140  O   ALA B 106     -13.594  43.708  36.806  1.00 13.55           O  
ATOM   2141  CB  ALA B 106     -16.721  42.719  36.997  1.00 13.72           C  
ATOM   2142  N   LEU B 107     -13.813  41.464  36.982  1.00 12.77           N  
ATOM   2143  CA  LEU B 107     -12.542  41.251  37.648  1.00 13.19           C  
ATOM   2144  C   LEU B 107     -11.368  41.604  36.724  1.00 12.96           C  
ATOM   2145  O   LEU B 107     -10.401  42.246  37.151  1.00 12.08           O  
ATOM   2146  CB  LEU B 107     -12.463  39.785  38.106  1.00 13.34           C  
ATOM   2147  CG  LEU B 107     -11.574  39.435  39.293  1.00 14.10           C  
ATOM   2148  CD1 LEU B 107     -12.012  40.160  40.602  1.00 12.47           C  
ATOM   2149  CD2 LEU B 107     -11.566  37.919  39.452  1.00 13.20           C  
ATOM   2150  N   ILE B 108     -11.477  41.212  35.454  1.00 13.40           N  
ATOM   2151  CA  ILE B 108     -10.475  41.565  34.432  1.00 14.18           C  
ATOM   2152  C   ILE B 108     -10.316  43.099  34.320  1.00 14.79           C  
ATOM   2153  O   ILE B 108      -9.200  43.620  34.230  1.00 15.26           O  
ATOM   2154  CB  ILE B 108     -10.845  40.949  33.052  1.00 14.21           C  
ATOM   2155  CG1 ILE B 108     -10.687  39.417  33.080  1.00 14.60           C  
ATOM   2156  CG2 ILE B 108      -9.963  41.519  31.947  1.00 13.52           C  
ATOM   2157  CD1 ILE B 108     -11.368  38.704  31.924  1.00 14.36           C  
ATOM   2158  N   GLU B 109     -11.437  43.810  34.331  1.00 15.60           N  
ATOM   2159  CA  GLU B 109     -11.416  45.260  34.218  1.00 17.14           C  
ATOM   2160  C   GLU B 109     -10.737  45.892  35.430  1.00 16.90           C  
ATOM   2161  O   GLU B 109      -9.969  46.834  35.269  1.00 16.62           O  
ATOM   2162  CB  GLU B 109     -12.814  45.835  33.950  1.00 17.87           C  
ATOM   2163  CG  GLU B 109     -13.499  45.144  32.770  1.00 22.36           C  
ATOM   2164  CD  GLU B 109     -14.409  46.035  31.938  1.00 30.03           C  
ATOM   2165  OE1 GLU B 109     -15.647  45.801  31.955  1.00 32.40           O  
ATOM   2166  OE2 GLU B 109     -13.888  46.942  31.241  1.00 32.71           O  
ATOM   2167  N   ARG B 110     -10.982  45.339  36.624  1.00 16.87           N  
ATOM   2168  CA  ARG B 110     -10.290  45.774  37.844  1.00 17.11           C  
ATOM   2169  C   ARG B 110      -8.792  45.516  37.753  1.00 16.85           C  
ATOM   2170  O   ARG B 110      -7.991  46.383  38.090  1.00 17.21           O  
ATOM   2171  CB  ARG B 110     -10.851  45.060  39.087  1.00 17.47           C  
ATOM   2172  CG  ARG B 110     -12.300  45.359  39.409  1.00 18.95           C  
ATOM   2173  CD  ARG B 110     -12.525  46.857  39.614  1.00 20.24           C  
ATOM   2174  NE  ARG B 110     -13.869  47.082  40.130  1.00 22.63           N  
ATOM   2175  CZ  ARG B 110     -14.168  47.178  41.423  1.00 22.39           C  
ATOM   2176  NH1 ARG B 110     -13.211  47.092  42.343  1.00 22.00           N  
ATOM   2177  NH2 ARG B 110     -15.428  47.368  41.792  1.00 23.55           N  
ATOM   2178  N   ALA B 111      -8.418  44.320  37.300  1.00 16.64           N  
ATOM   2179  CA  ALA B 111      -7.011  43.938  37.194  1.00 17.13           C  
ATOM   2180  C   ALA B 111      -6.273  44.888  36.249  1.00 17.76           C  
ATOM   2181  O   ALA B 111      -5.160  45.320  36.538  1.00 17.07           O  
ATOM   2182  CB  ALA B 111      -6.868  42.476  36.739  1.00 16.54           C  
ATOM   2183  N   ARG B 112      -6.909  45.216  35.125  1.00 19.04           N  
ATOM   2184  CA  ARG B 112      -6.360  46.201  34.184  1.00 20.47           C  
ATOM   2185  C   ARG B 112      -6.185  47.574  34.810  1.00 20.94           C  
ATOM   2186  O   ARG B 112      -5.120  48.188  34.676  1.00 21.45           O  
ATOM   2187  CB  ARG B 112      -7.224  46.313  32.936  1.00 20.80           C  
ATOM   2188  CG  ARG B 112      -6.967  45.194  31.980  1.00 22.63           C  
ATOM   2189  CD  ARG B 112      -7.060  45.654  30.534  1.00 25.78           C  
ATOM   2190  NE  ARG B 112      -6.895  44.507  29.645  1.00 26.12           N  
ATOM   2191  CZ  ARG B 112      -7.895  43.733  29.250  1.00 26.81           C  
ATOM   2192  NH1 ARG B 112      -9.132  44.003  29.641  1.00 27.80           N  
ATOM   2193  NH2 ARG B 112      -7.657  42.699  28.455  1.00 27.77           N  
ATOM   2194  N   ALA B 113      -7.219  48.046  35.505  1.00 21.28           N  
ATOM   2195  CA  ALA B 113      -7.164  49.348  36.181  1.00 21.35           C  
ATOM   2196  C   ALA B 113      -6.048  49.408  37.229  1.00 21.48           C  
ATOM   2197  O   ALA B 113      -5.530  50.490  37.531  1.00 21.90           O  
ATOM   2198  CB  ALA B 113      -8.514  49.681  36.806  1.00 21.16           C  
ATOM   2199  N   GLN B 114      -5.666  48.247  37.765  1.00 21.15           N  
ATOM   2200  CA  GLN B 114      -4.593  48.155  38.765  1.00 20.75           C  
ATOM   2201  C   GLN B 114      -3.197  48.029  38.161  1.00 20.18           C  
ATOM   2202  O   GLN B 114      -2.203  47.969  38.889  1.00 19.97           O  
ATOM   2203  CB  GLN B 114      -4.858  47.010  39.749  1.00 21.31           C  
ATOM   2204  CG  GLN B 114      -6.077  47.229  40.628  1.00 22.05           C  
ATOM   2205  CD  GLN B 114      -6.034  46.412  41.906  1.00 24.75           C  
ATOM   2206  OE1 GLN B 114      -5.959  45.183  41.877  1.00 20.56           O  
ATOM   2207  NE2 GLN B 114      -6.088  47.102  43.042  1.00 26.39           N  
ATOM   2208  N   GLY B 115      -3.121  47.993  36.831  1.00 19.57           N  
ATOM   2209  CA  GLY B 115      -1.846  47.858  36.136  1.00 18.66           C  
ATOM   2210  C   GLY B 115      -1.198  46.486  36.252  1.00 18.08           C  
ATOM   2211  O   GLY B 115       0.011  46.360  36.096  1.00 18.13           O  
ATOM   2212  N   LEU B 116      -1.998  45.451  36.512  1.00 17.30           N  
ATOM   2213  CA  LEU B 116      -1.499  44.075  36.540  1.00 16.01           C  
ATOM   2214  C   LEU B 116      -1.194  43.563  35.126  1.00 15.45           C  
ATOM   2215  O   LEU B 116      -1.697  44.113  34.133  1.00 15.39           O  
ATOM   2216  CB  LEU B 116      -2.487  43.168  37.294  1.00 16.15           C  
ATOM   2217  CG  LEU B 116      -2.736  43.616  38.739  1.00 17.39           C  
ATOM   2218  CD1 LEU B 116      -3.860  42.801  39.397  1.00 17.53           C  
ATOM   2219  CD2 LEU B 116      -1.460  43.533  39.568  1.00 18.07           C  
ATOM   2220  N   HIS B 117      -0.347  42.538  35.032  1.00 14.16           N  
ATOM   2221  CA  HIS B 117       0.126  42.030  33.747  1.00 13.70           C  
ATOM   2222  C   HIS B 117      -0.522  40.715  33.293  1.00 13.29           C  
ATOM   2223  O   HIS B 117      -0.788  40.530  32.096  1.00 12.70           O  
ATOM   2224  CB  HIS B 117       1.661  41.882  33.763  1.00 13.66           C  
ATOM   2225  CG  HIS B 117       2.263  41.619  32.420  1.00 14.69           C  
ATOM   2226  ND1 HIS B 117       3.153  40.590  32.190  1.00 17.39           N  
ATOM   2227  CD2 HIS B 117       2.131  42.271  31.240  1.00 14.64           C  
ATOM   2228  CE1 HIS B 117       3.519  40.602  30.920  1.00 15.47           C  
ATOM   2229  NE2 HIS B 117       2.915  41.612  30.323  1.00 18.65           N  
ATOM   2230  N   VAL B 118      -0.736  39.784  34.228  1.00 11.95           N  
ATOM   2231  CA  VAL B 118      -1.212  38.444  33.866  1.00 11.18           C  
ATOM   2232  C   VAL B 118      -2.203  37.949  34.924  1.00 11.05           C  
ATOM   2233  O   VAL B 118      -1.964  38.129  36.128  1.00 10.09           O  
ATOM   2234  CB  VAL B 118      -0.023  37.424  33.728  1.00 11.07           C  
ATOM   2235  CG1 VAL B 118      -0.534  35.999  33.447  1.00 10.72           C  
ATOM   2236  CG2 VAL B 118       0.975  37.857  32.640  1.00 12.25           C  
HETATM 2237  N   MSE B 119      -3.319  37.365  34.487  1.00 10.72           N  
HETATM 2238  CA  MSE B 119      -4.237  36.674  35.411  1.00 11.05           C  
HETATM 2239  C   MSE B 119      -4.113  35.182  35.151  1.00 11.03           C  
HETATM 2240  O   MSE B 119      -4.175  34.756  33.999  1.00 10.30           O  
HETATM 2241  CB  MSE B 119      -5.705  37.134  35.221  1.00 10.82           C  
HETATM 2242  CG  MSE B 119      -6.712  36.750  36.362  1.00 11.62           C  
HETATM 2243 SE   MSE B 119      -8.342  37.628  36.256  1.00 14.58          SE  
HETATM 2244  CE  MSE B 119      -7.805  38.994  35.164  1.00  2.00           C  
ATOM   2245  N   VAL B 120      -3.943  34.401  36.217  1.00 11.12           N  
ATOM   2246  CA  VAL B 120      -3.830  32.951  36.129  1.00 11.48           C  
ATOM   2247  C   VAL B 120      -5.082  32.295  36.734  1.00 11.93           C  
ATOM   2248  O   VAL B 120      -5.533  32.691  37.807  1.00 12.16           O  
ATOM   2249  CB  VAL B 120      -2.554  32.432  36.859  1.00 11.60           C  
ATOM   2250  CG1 VAL B 120      -2.503  30.888  36.844  1.00 11.51           C  
ATOM   2251  CG2 VAL B 120      -1.298  33.003  36.226  1.00 12.56           C  
ATOM   2252  N   ALA B 121      -5.648  31.327  36.014  1.00 12.12           N  
ATOM   2253  CA  ALA B 121      -6.716  30.436  36.522  1.00 12.30           C  
ATOM   2254  C   ALA B 121      -6.166  29.033  36.753  1.00 12.59           C  
ATOM   2255  O   ALA B 121      -5.415  28.516  35.917  1.00 12.70           O  
ATOM   2256  CB  ALA B 121      -7.847  30.368  35.512  1.00 12.75           C  
ATOM   2257  N   ALA B 122      -6.536  28.426  37.881  1.00 12.05           N  
ATOM   2258  CA  ALA B 122      -6.231  27.019  38.161  1.00 11.38           C  
ATOM   2259  C   ALA B 122      -7.548  26.279  38.231  1.00 11.29           C  
ATOM   2260  O   ALA B 122      -8.383  26.554  39.101  1.00 10.91           O  
ATOM   2261  CB  ALA B 122      -5.462  26.875  39.465  1.00 11.89           C  
ATOM   2262  N   ILE B 123      -7.756  25.374  37.284  1.00 10.61           N  
ATOM   2263  CA  ILE B 123      -9.064  24.759  37.085  1.00 11.26           C  
ATOM   2264  C   ILE B 123      -8.856  23.253  37.089  1.00 11.55           C  
ATOM   2265  O   ILE B 123      -7.935  22.765  36.450  1.00 10.45           O  
ATOM   2266  CB  ILE B 123      -9.660  25.198  35.705  1.00 11.18           C  
ATOM   2267  CG1 ILE B 123      -9.833  26.720  35.657  1.00 11.60           C  
ATOM   2268  CG2 ILE B 123     -11.004  24.511  35.429  1.00 11.25           C  
ATOM   2269  CD1 ILE B 123      -9.858  27.299  34.215  1.00 12.79           C  
ATOM   2270  N   GLU B 124      -9.708  22.519  37.800  1.00 11.66           N  
ATOM   2271  CA  GLU B 124      -9.662  21.073  37.735  1.00 12.04           C  
ATOM   2272  C   GLU B 124      -9.916  20.685  36.266  1.00 12.11           C  
ATOM   2273  O   GLU B 124     -10.828  21.206  35.647  1.00 11.35           O  
ATOM   2274  CB  GLU B 124     -10.702  20.479  38.667  1.00 13.37           C  
ATOM   2275  CG  GLU B 124     -10.580  18.980  38.803  1.00 15.07           C  
ATOM   2276  CD  GLU B 124     -11.608  18.266  38.002  1.00 18.54           C  
ATOM   2277  OE1 GLU B 124     -12.793  18.638  38.122  1.00 21.13           O  
ATOM   2278  OE2 GLU B 124     -11.250  17.322  37.272  1.00 17.04           O  
ATOM   2279  N   SER B 125      -9.089  19.800  35.720  1.00 10.98           N  
ATOM   2280  CA  SER B 125      -9.049  19.568  34.271  1.00 12.13           C  
ATOM   2281  C   SER B 125     -10.349  19.022  33.682  1.00 11.98           C  
ATOM   2282  O   SER B 125     -10.621  19.231  32.506  1.00 12.42           O  
ATOM   2283  CB  SER B 125      -7.898  18.630  33.903  1.00 11.15           C  
ATOM   2284  OG  SER B 125      -6.681  19.136  34.415  1.00 12.94           O  
ATOM   2285  N   GLY B 126     -11.136  18.315  34.491  1.00 12.59           N  
ATOM   2286  CA  GLY B 126     -12.439  17.797  34.031  1.00 12.46           C  
ATOM   2287  C   GLY B 126     -13.557  18.840  33.967  1.00 12.95           C  
ATOM   2288  O   GLY B 126     -14.650  18.566  33.452  1.00 12.46           O  
ATOM   2289  N   ASN B 127     -13.297  20.037  34.485  1.00 12.39           N  
ATOM   2290  CA  ASN B 127     -14.325  21.063  34.548  1.00 12.48           C  
ATOM   2291  C   ASN B 127     -14.392  21.820  33.224  1.00 12.21           C  
ATOM   2292  O   ASN B 127     -13.894  22.952  33.108  1.00 11.99           O  
ATOM   2293  CB  ASN B 127     -14.076  21.985  35.741  1.00 12.56           C  
ATOM   2294  CG  ASN B 127     -15.217  22.977  35.988  1.00 14.58           C  
ATOM   2295  OD1 ASN B 127     -16.085  23.202  35.131  1.00 13.76           O  
ATOM   2296  ND2 ASN B 127     -15.197  23.598  37.163  1.00 15.36           N  
ATOM   2297  N   ALA B 128     -15.018  21.187  32.229  1.00 12.15           N  
ATOM   2298  CA  ALA B 128     -15.106  21.749  30.882  1.00 12.10           C  
ATOM   2299  C   ALA B 128     -15.881  23.064  30.870  1.00 12.17           C  
ATOM   2300  O   ALA B 128     -15.558  23.969  30.084  1.00 12.38           O  
ATOM   2301  CB  ALA B 128     -15.730  20.756  29.919  1.00 12.33           C  
ATOM   2302  N   ALA B 129     -16.875  23.187  31.755  1.00 11.50           N  
ATOM   2303  CA  ALA B 129     -17.639  24.422  31.832  1.00 11.45           C  
ATOM   2304  C   ALA B 129     -16.718  25.606  32.152  1.00 10.92           C  
ATOM   2305  O   ALA B 129     -16.792  26.661  31.495  1.00 10.75           O  
ATOM   2306  CB  ALA B 129     -18.741  24.314  32.863  1.00 11.51           C  
ATOM   2307  N   SER B 130     -15.858  25.431  33.158  1.00 10.56           N  
ATOM   2308  CA  SER B 130     -14.943  26.491  33.584  1.00 11.41           C  
ATOM   2309  C   SER B 130     -13.871  26.787  32.546  1.00 10.96           C  
ATOM   2310  O   SER B 130     -13.576  27.948  32.249  1.00 11.00           O  
ATOM   2311  CB  SER B 130     -14.307  26.177  34.933  1.00 11.26           C  
ATOM   2312  OG  SER B 130     -13.464  27.251  35.307  1.00 14.47           O  
ATOM   2313  N   ILE B 131     -13.270  25.740  32.008  1.00 11.66           N  
ATOM   2314  CA  ILE B 131     -12.308  25.912  30.893  1.00 13.16           C  
ATOM   2315  C   ILE B 131     -12.901  26.718  29.727  1.00 11.34           C  
ATOM   2316  O   ILE B 131     -12.242  27.618  29.186  1.00 10.95           O  
ATOM   2317  CB  ILE B 131     -11.739  24.551  30.402  1.00 12.36           C  
ATOM   2318  CG1 ILE B 131     -10.951  23.898  31.550  1.00 14.02           C  
ATOM   2319  CG2 ILE B 131     -10.841  24.758  29.163  1.00 13.24           C  
ATOM   2320  CD1 ILE B 131     -10.368  22.546  31.241  1.00 14.71           C  
ATOM   2321  N   GLY B 132     -14.141  26.412  29.348  1.00 11.61           N  
ATOM   2322  CA  GLY B 132     -14.781  27.086  28.205  1.00 11.18           C  
ATOM   2323  C   GLY B 132     -15.108  28.541  28.491  1.00 11.36           C  
ATOM   2324  O   GLY B 132     -14.970  29.416  27.623  1.00 10.86           O  
ATOM   2325  N   LEU B 133     -15.530  28.796  29.720  1.00 11.00           N  
ATOM   2326  CA  LEU B 133     -15.814  30.153  30.180  1.00 12.10           C  
ATOM   2327  C   LEU B 133     -14.561  31.032  30.052  1.00 10.94           C  
ATOM   2328  O   LEU B 133     -14.615  32.158  29.537  1.00 10.44           O  
ATOM   2329  CB  LEU B 133     -16.292  30.088  31.633  1.00 12.86           C  
ATOM   2330  CG  LEU B 133     -16.740  31.348  32.376  1.00 17.00           C  
ATOM   2331  CD1 LEU B 133     -17.604  30.923  33.554  1.00 20.93           C  
ATOM   2332  CD2 LEU B 133     -15.562  32.127  32.857  1.00 20.14           C  
ATOM   2333  N   HIS B 134     -13.433  30.488  30.500  1.00 10.27           N  
ATOM   2334  CA  HIS B 134     -12.161  31.194  30.465  1.00 10.27           C  
ATOM   2335  C   HIS B 134     -11.661  31.373  29.029  1.00 10.00           C  
ATOM   2336  O   HIS B 134     -11.244  32.470  28.650  1.00  9.39           O  
ATOM   2337  CB  HIS B 134     -11.138  30.473  31.346  1.00 10.32           C  
ATOM   2338  CG  HIS B 134     -11.362  30.704  32.806  1.00 11.27           C  
ATOM   2339  ND1 HIS B 134     -12.313  30.018  33.530  1.00 11.89           N  
ATOM   2340  CD2 HIS B 134     -10.783  31.570  33.669  1.00 13.12           C  
ATOM   2341  CE1 HIS B 134     -12.308  30.446  34.780  1.00 15.23           C  
ATOM   2342  NE2 HIS B 134     -11.390  31.391  34.892  1.00 14.67           N  
ATOM   2343  N   ARG B 135     -11.714  30.302  28.237  1.00  9.40           N  
ATOM   2344  CA  ARG B 135     -11.321  30.376  26.820  1.00 10.22           C  
ATOM   2345  C   ARG B 135     -12.039  31.514  26.106  1.00  9.83           C  
ATOM   2346  O   ARG B 135     -11.412  32.301  25.377  1.00  9.39           O  
ATOM   2347  CB  ARG B 135     -11.588  29.065  26.083  1.00 10.16           C  
ATOM   2348  CG  ARG B 135     -11.387  29.182  24.576  1.00 11.24           C  
ATOM   2349  CD  ARG B 135     -11.550  27.856  23.843  1.00 12.23           C  
ATOM   2350  NE  ARG B 135     -12.923  27.360  23.912  1.00 17.11           N  
ATOM   2351  CZ  ARG B 135     -13.317  26.339  24.670  1.00 18.35           C  
ATOM   2352  NH1 ARG B 135     -12.443  25.669  25.426  1.00 18.04           N  
ATOM   2353  NH2 ARG B 135     -14.591  25.981  24.656  1.00 18.66           N  
ATOM   2354  N   ARG B 136     -13.348  31.607  26.325  1.00  9.71           N  
ATOM   2355  CA  ARG B 136     -14.175  32.614  25.643  1.00 10.60           C  
ATOM   2356  C   ARG B 136     -13.893  34.047  26.097  1.00 11.22           C  
ATOM   2357  O   ARG B 136     -14.309  35.007  25.428  1.00 11.86           O  
ATOM   2358  CB  ARG B 136     -15.670  32.255  25.737  1.00  9.95           C  
ATOM   2359  CG  ARG B 136     -15.999  31.006  24.914  1.00 10.27           C  
ATOM   2360  CD  ARG B 136     -17.489  30.717  24.853  1.00  9.41           C  
ATOM   2361  NE  ARG B 136     -18.054  30.411  26.162  1.00 12.56           N  
ATOM   2362  CZ  ARG B 136     -18.135  29.192  26.695  1.00 13.39           C  
ATOM   2363  NH1 ARG B 136     -17.687  28.134  26.027  1.00 12.69           N  
ATOM   2364  NH2 ARG B 136     -18.665  29.038  27.907  1.00 14.31           N  
ATOM   2365  N   LEU B 137     -13.185  34.195  27.218  1.00 11.14           N  
ATOM   2366  CA  LEU B 137     -12.733  35.515  27.675  1.00 11.61           C  
ATOM   2367  C   LEU B 137     -11.233  35.782  27.407  1.00 12.04           C  
ATOM   2368  O   LEU B 137     -10.651  36.726  27.956  1.00 12.38           O  
ATOM   2369  CB  LEU B 137     -13.084  35.728  29.155  1.00 11.81           C  
ATOM   2370  CG  LEU B 137     -14.559  36.008  29.479  1.00 13.81           C  
ATOM   2371  CD1 LEU B 137     -14.776  36.230  30.963  1.00 16.21           C  
ATOM   2372  CD2 LEU B 137     -15.141  37.192  28.667  1.00 16.70           C  
ATOM   2373  N   GLY B 138     -10.622  34.954  26.561  1.00 11.79           N  
ATOM   2374  CA  GLY B 138      -9.256  35.202  26.095  1.00 11.19           C  
ATOM   2375  C   GLY B 138      -8.161  34.439  26.820  1.00 11.09           C  
ATOM   2376  O   GLY B 138      -6.980  34.641  26.527  1.00 10.33           O  
ATOM   2377  N   PHE B 139      -8.528  33.581  27.782  1.00 10.00           N  
ATOM   2378  CA  PHE B 139      -7.529  32.768  28.482  1.00 10.34           C  
ATOM   2379  C   PHE B 139      -7.033  31.638  27.596  1.00 10.63           C  
ATOM   2380  O   PHE B 139      -7.800  31.078  26.814  1.00 10.21           O  
ATOM   2381  CB  PHE B 139      -8.098  32.158  29.761  1.00  9.76           C  
ATOM   2382  CG  PHE B 139      -8.229  33.126  30.892  1.00 10.20           C  
ATOM   2383  CD1 PHE B 139      -7.294  33.119  31.928  1.00  9.63           C  
ATOM   2384  CD2 PHE B 139      -9.302  34.024  30.946  1.00 11.99           C  
ATOM   2385  CE1 PHE B 139      -7.404  34.018  32.992  1.00  9.20           C  
ATOM   2386  CE2 PHE B 139      -9.425  34.933  32.019  1.00 12.20           C  
ATOM   2387  CZ  PHE B 139      -8.457  34.924  33.040  1.00 11.01           C  
ATOM   2388  N   GLU B 140      -5.747  31.311  27.729  1.00 11.39           N  
ATOM   2389  CA  GLU B 140      -5.133  30.211  27.001  1.00 12.70           C  
ATOM   2390  C   GLU B 140      -4.591  29.130  27.960  1.00 11.55           C  
ATOM   2391  O   GLU B 140      -4.098  29.454  29.028  1.00 10.84           O  
ATOM   2392  CB  GLU B 140      -3.981  30.735  26.142  1.00 13.07           C  
ATOM   2393  CG  GLU B 140      -4.406  31.611  24.974  1.00 17.25           C  
ATOM   2394  CD  GLU B 140      -3.230  32.037  24.114  1.00 17.90           C  
ATOM   2395  OE1 GLU B 140      -2.555  31.160  23.544  1.00 25.38           O  
ATOM   2396  OE2 GLU B 140      -2.994  33.259  23.989  1.00 26.82           O  
ATOM   2397  N   ILE B 141      -4.676  27.856  27.564  1.00 10.80           N  
ATOM   2398  CA  ILE B 141      -4.144  26.776  28.376  1.00 10.98           C  
ATOM   2399  C   ILE B 141      -2.620  26.898  28.394  1.00 10.92           C  
ATOM   2400  O   ILE B 141      -1.993  27.046  27.343  1.00 10.48           O  
ATOM   2401  CB  ILE B 141      -4.584  25.385  27.875  1.00 10.96           C  
ATOM   2402  CG1 ILE B 141      -6.107  25.257  27.985  1.00 11.74           C  
ATOM   2403  CG2 ILE B 141      -3.875  24.254  28.680  1.00  9.64           C  
ATOM   2404  CD1 ILE B 141      -6.666  23.981  27.396  1.00 15.54           C  
ATOM   2405  N   SER B 142      -2.055  26.874  29.597  1.00 11.39           N  
ATOM   2406  CA  SER B 142      -0.609  27.013  29.792  1.00 12.70           C  
ATOM   2407  C   SER B 142      -0.017  25.788  30.456  1.00 12.65           C  
ATOM   2408  O   SER B 142       1.183  25.572  30.384  1.00 12.63           O  
ATOM   2409  CB  SER B 142      -0.302  28.247  30.651  1.00 13.06           C  
ATOM   2410  OG  SER B 142      -0.680  29.411  29.958  1.00 18.41           O  
ATOM   2411  N   GLY B 143      -0.852  24.992  31.115  1.00 12.38           N  
ATOM   2412  CA  GLY B 143      -0.328  23.861  31.856  1.00 13.70           C  
ATOM   2413  C   GLY B 143      -1.376  22.815  32.103  1.00 14.16           C  
ATOM   2414  O   GLY B 143      -2.550  23.129  32.236  1.00 13.39           O  
ATOM   2415  N   GLN B 144      -0.932  21.564  32.146  1.00 15.05           N  
ATOM   2416  CA  GLN B 144      -1.801  20.455  32.483  1.00 16.28           C  
ATOM   2417  C   GLN B 144      -0.964  19.510  33.334  1.00 15.36           C  
ATOM   2418  O   GLN B 144       0.034  18.948  32.876  1.00 15.24           O  
ATOM   2419  CB  GLN B 144      -2.391  19.801  31.227  1.00 17.47           C  
ATOM   2420  CG  GLN B 144      -3.815  20.332  30.938  1.00 22.37           C  
ATOM   2421  CD  GLN B 144      -4.425  19.759  29.687  1.00 27.58           C  
ATOM   2422  OE1 GLN B 144      -4.184  18.601  29.335  1.00 31.63           O  
ATOM   2423  NE2 GLN B 144      -5.242  20.560  29.010  1.00 28.89           N  
HETATM 2424  N   MSE B 145      -1.368  19.403  34.593  1.00 14.31           N  
HETATM 2425  CA  MSE B 145      -0.545  18.817  35.634  1.00 13.98           C  
HETATM 2426  C   MSE B 145      -1.302  17.650  36.283  1.00 13.31           C  
HETATM 2427  O   MSE B 145      -2.205  17.870  37.083  1.00 13.51           O  
HETATM 2428  CB  MSE B 145      -0.154  19.910  36.649  1.00 13.48           C  
HETATM 2429  CG  MSE B 145       0.470  21.155  35.966  1.00 14.89           C  
HETATM 2430 SE   MSE B 145       1.191  22.367  37.085  1.00 14.78          SE  
HETATM 2431  CE  MSE B 145       2.636  21.433  37.635  1.00 17.18           C  
ATOM   2432  N   PRO B 146      -0.956  16.403  35.896  1.00 12.83           N  
ATOM   2433  CA  PRO B 146      -1.651  15.193  36.381  1.00 12.31           C  
ATOM   2434  C   PRO B 146      -1.374  14.835  37.833  1.00 11.48           C  
ATOM   2435  O   PRO B 146      -0.220  14.875  38.274  1.00 10.91           O  
ATOM   2436  CB  PRO B 146      -1.106  14.079  35.474  1.00 12.05           C  
ATOM   2437  CG  PRO B 146       0.254  14.600  35.024  1.00 13.53           C  
ATOM   2438  CD  PRO B 146       0.071  16.085  34.887  1.00 12.74           C  
ATOM   2439  N   GLN B 147      -2.442  14.481  38.542  1.00 11.26           N  
ATOM   2440  CA  GLN B 147      -2.389  13.871  39.874  1.00 11.69           C  
ATOM   2441  C   GLN B 147      -1.712  14.739  40.945  1.00 11.62           C  
ATOM   2442  O   GLN B 147      -1.173  14.223  41.932  1.00 11.76           O  
ATOM   2443  CB  GLN B 147      -1.779  12.463  39.799  1.00 11.65           C  
ATOM   2444  CG  GLN B 147      -2.514  11.528  38.828  1.00 12.26           C  
ATOM   2445  CD  GLN B 147      -2.086  10.080  38.958  1.00 13.96           C  
ATOM   2446  OE1 GLN B 147      -1.100   9.767  39.621  1.00 15.05           O  
ATOM   2447  NE2 GLN B 147      -2.840   9.181  38.322  1.00 16.60           N  
ATOM   2448  N   VAL B 148      -1.777  16.057  40.759  1.00 11.34           N  
ATOM   2449  CA  VAL B 148      -1.220  16.997  41.726  1.00 11.29           C  
ATOM   2450  C   VAL B 148      -2.162  17.248  42.897  1.00 12.06           C  
ATOM   2451  O   VAL B 148      -1.746  17.786  43.924  1.00 12.31           O  
ATOM   2452  CB  VAL B 148      -0.786  18.334  41.068  1.00 11.15           C  
ATOM   2453  CG1 VAL B 148       0.397  18.091  40.148  1.00 10.65           C  
ATOM   2454  CG2 VAL B 148      -1.940  18.980  40.308  1.00 10.70           C  
ATOM   2455  N   GLY B 149      -3.426  16.848  42.737  1.00 12.20           N  
ATOM   2456  CA  GLY B 149      -4.426  17.026  43.784  1.00 12.90           C  
ATOM   2457  C   GLY B 149      -5.143  15.741  44.104  1.00 12.72           C  
ATOM   2458  O   GLY B 149      -5.007  14.748  43.388  1.00 11.46           O  
ATOM   2459  N   GLN B 150      -5.894  15.769  45.204  1.00 13.66           N  
ATOM   2460  CA  GLN B 150      -6.737  14.663  45.600  1.00 14.64           C  
ATOM   2461  C   GLN B 150      -7.985  15.228  46.249  1.00 14.71           C  
ATOM   2462  O   GLN B 150      -7.918  16.222  46.993  1.00 14.40           O  
ATOM   2463  CB  GLN B 150      -6.021  13.728  46.588  1.00 14.70           C  
ATOM   2464  CG  GLN B 150      -5.401  14.426  47.810  1.00 15.74           C  
ATOM   2465  CD  GLN B 150      -4.540  13.508  48.632  1.00 16.80           C  
ATOM   2466  OE1 GLN B 150      -5.047  12.729  49.428  1.00 18.99           O  
ATOM   2467  NE2 GLN B 150      -3.225  13.589  48.444  1.00 17.87           N  
ATOM   2468  N   LYS B 151      -9.115  14.599  45.955  1.00 14.50           N  
ATOM   2469  CA  LYS B 151     -10.349  14.866  46.695  1.00 15.27           C  
ATOM   2470  C   LYS B 151     -11.310  13.727  46.425  1.00 16.17           C  
ATOM   2471  O   LYS B 151     -11.246  13.088  45.366  1.00 16.44           O  
ATOM   2472  CB  LYS B 151     -10.969  16.218  46.312  1.00 14.49           C  
ATOM   2473  CG  LYS B 151     -12.019  16.739  47.295  1.00 14.30           C  
ATOM   2474  CD  LYS B 151     -12.436  18.175  46.955  1.00 14.44           C  
ATOM   2475  CE  LYS B 151     -13.618  18.610  47.808  1.00 13.40           C  
ATOM   2476  NZ  LYS B 151     -14.068  20.010  47.540  1.00 10.76           N  
ATOM   2477  N   PHE B 152     -12.181  13.461  47.397  1.00 17.83           N  
ATOM   2478  CA  PHE B 152     -13.146  12.365  47.294  1.00 18.85           C  
ATOM   2479  C   PHE B 152     -12.437  11.033  47.027  1.00 19.38           C  
ATOM   2480  O   PHE B 152     -12.938  10.192  46.271  1.00 19.56           O  
ATOM   2481  CB  PHE B 152     -14.177  12.650  46.195  1.00 19.63           C  
ATOM   2482  CG  PHE B 152     -14.797  14.036  46.273  1.00 20.99           C  
ATOM   2483  CD1 PHE B 152     -14.626  14.945  45.233  1.00 21.48           C  
ATOM   2484  CD2 PHE B 152     -15.544  14.421  47.385  1.00 22.23           C  
ATOM   2485  CE1 PHE B 152     -15.203  16.226  45.296  1.00 22.97           C  
ATOM   2486  CE2 PHE B 152     -16.121  15.700  47.459  1.00 22.74           C  
ATOM   2487  CZ  PHE B 152     -15.950  16.597  46.409  1.00 21.53           C  
ATOM   2488  N   GLY B 153     -11.267  10.853  47.639  1.00 19.26           N  
ATOM   2489  CA  GLY B 153     -10.505   9.611  47.492  1.00 19.23           C  
ATOM   2490  C   GLY B 153      -9.916   9.342  46.115  1.00 19.06           C  
ATOM   2491  O   GLY B 153      -9.515   8.220  45.829  1.00 19.01           O  
ATOM   2492  N   ARG B 154      -9.851  10.359  45.259  1.00 18.77           N  
ATOM   2493  CA  ARG B 154      -9.289  10.180  43.915  1.00 18.77           C  
ATOM   2494  C   ARG B 154      -8.256  11.261  43.548  1.00 17.30           C  
ATOM   2495  O   ARG B 154      -8.288  12.360  44.092  1.00 16.33           O  
ATOM   2496  CB  ARG B 154     -10.410  10.069  42.863  1.00 19.11           C  
ATOM   2497  CG  ARG B 154     -11.059  11.388  42.416  1.00 20.95           C  
ATOM   2498  CD  ARG B 154     -12.188  11.146  41.399  1.00 21.40           C  
ATOM   2499  NE  ARG B 154     -12.728  12.397  40.859  1.00 27.25           N  
ATOM   2500  CZ  ARG B 154     -13.812  13.025  41.319  1.00 29.26           C  
ATOM   2501  NH1 ARG B 154     -14.507  12.533  42.346  1.00 31.06           N  
ATOM   2502  NH2 ARG B 154     -14.206  14.160  40.748  1.00 31.08           N  
ATOM   2503  N   TRP B 155      -7.334  10.926  42.640  1.00 16.34           N  
ATOM   2504  CA  TRP B 155      -6.360  11.898  42.128  1.00 14.90           C  
ATOM   2505  C   TRP B 155      -7.073  12.895  41.218  1.00 14.61           C  
ATOM   2506  O   TRP B 155      -8.026  12.538  40.534  1.00 15.18           O  
ATOM   2507  CB  TRP B 155      -5.228  11.196  41.357  1.00 14.88           C  
ATOM   2508  CG  TRP B 155      -4.340  10.271  42.182  1.00 14.36           C  
ATOM   2509  CD1 TRP B 155      -4.102   8.944  41.949  1.00 15.01           C  
ATOM   2510  CD2 TRP B 155      -3.584  10.610  43.358  1.00 13.86           C  
ATOM   2511  NE1 TRP B 155      -3.240   8.437  42.898  1.00 14.96           N  
ATOM   2512  CE2 TRP B 155      -2.911   9.434  43.777  1.00 15.37           C  
ATOM   2513  CE3 TRP B 155      -3.405  11.792  44.091  1.00 13.96           C  
ATOM   2514  CZ2 TRP B 155      -2.074   9.404  44.908  1.00 14.99           C  
ATOM   2515  CZ3 TRP B 155      -2.577  11.765  45.216  1.00 14.62           C  
ATOM   2516  CH2 TRP B 155      -1.924  10.576  45.613  1.00 15.78           C  
ATOM   2517  N   LEU B 156      -6.627  14.144  41.237  1.00 13.97           N  
ATOM   2518  CA  LEU B 156      -7.196  15.205  40.400  1.00 13.33           C  
ATOM   2519  C   LEU B 156      -6.090  15.863  39.602  1.00 13.10           C  
ATOM   2520  O   LEU B 156      -4.964  16.019  40.104  1.00 12.51           O  
ATOM   2521  CB  LEU B 156      -7.888  16.265  41.257  1.00 13.02           C  
ATOM   2522  CG  LEU B 156      -9.113  15.872  42.098  1.00 15.71           C  
ATOM   2523  CD1 LEU B 156      -9.584  17.072  42.932  1.00 17.63           C  
ATOM   2524  CD2 LEU B 156     -10.240  15.342  41.212  1.00 17.12           C  
ATOM   2525  N   ASP B 157      -6.410  16.254  38.365  1.00 12.44           N  
ATOM   2526  CA  ASP B 157      -5.451  16.959  37.520  1.00 12.99           C  
ATOM   2527  C   ASP B 157      -5.811  18.438  37.493  1.00 12.29           C  
ATOM   2528  O   ASP B 157      -6.989  18.810  37.592  1.00 11.16           O  
ATOM   2529  CB  ASP B 157      -5.429  16.412  36.085  1.00 13.23           C  
ATOM   2530  CG  ASP B 157      -5.269  14.898  36.020  1.00 16.58           C  
ATOM   2531  OD1 ASP B 157      -4.772  14.261  36.991  1.00 16.08           O  
ATOM   2532  OD2 ASP B 157      -5.636  14.343  34.962  1.00 19.99           O  
ATOM   2533  N   LEU B 158      -4.793  19.275  37.336  1.00 11.94           N  
ATOM   2534  CA  LEU B 158      -4.976  20.713  37.340  1.00 12.20           C  
ATOM   2535  C   LEU B 158      -4.593  21.311  35.992  1.00 12.46           C  
ATOM   2536  O   LEU B 158      -3.568  20.956  35.404  1.00 13.02           O  
ATOM   2537  CB  LEU B 158      -4.155  21.361  38.468  1.00 12.20           C  
ATOM   2538  CG  LEU B 158      -4.445  22.826  38.820  1.00 12.48           C  
ATOM   2539  CD1 LEU B 158      -5.917  23.032  39.229  1.00 14.27           C  
ATOM   2540  CD2 LEU B 158      -3.532  23.326  39.949  1.00 12.67           C  
ATOM   2541  N   THR B 159      -5.432  22.208  35.503  1.00 12.38           N  
ATOM   2542  CA  THR B 159      -5.134  22.918  34.263  1.00 12.26           C  
ATOM   2543  C   THR B 159      -4.872  24.354  34.639  1.00 12.22           C  
ATOM   2544  O   THR B 159      -5.663  24.944  35.366  1.00 12.27           O  
ATOM   2545  CB  THR B 159      -6.309  22.812  33.298  1.00 12.52           C  
ATOM   2546  OG1 THR B 159      -6.456  21.444  32.909  1.00 12.88           O  
ATOM   2547  CG2 THR B 159      -6.109  23.698  32.050  1.00 12.94           C  
ATOM   2548  N   PHE B 160      -3.744  24.901  34.182  1.00 11.89           N  
ATOM   2549  CA  PHE B 160      -3.495  26.334  34.316  1.00 11.91           C  
ATOM   2550  C   PHE B 160      -3.884  27.038  33.013  1.00 11.37           C  
ATOM   2551  O   PHE B 160      -3.542  26.569  31.925  1.00 10.60           O  
ATOM   2552  CB  PHE B 160      -2.018  26.619  34.604  1.00 12.84           C  
ATOM   2553  CG  PHE B 160      -1.636  26.497  36.058  1.00 13.92           C  
ATOM   2554  CD1 PHE B 160      -2.265  27.259  37.026  1.00 17.57           C  
ATOM   2555  CD2 PHE B 160      -0.608  25.642  36.444  1.00 18.04           C  
ATOM   2556  CE1 PHE B 160      -1.900  27.157  38.372  1.00 18.60           C  
ATOM   2557  CE2 PHE B 160      -0.228  25.530  37.795  1.00 20.05           C  
ATOM   2558  CZ  PHE B 160      -0.882  26.297  38.756  1.00 17.65           C  
HETATM 2559  N   MSE B 161      -4.585  28.161  33.127  1.00 10.23           N  
HETATM 2560  CA  MSE B 161      -4.835  29.007  31.969  1.00  9.06           C  
HETATM 2561  C   MSE B 161      -4.413  30.432  32.338  1.00  9.70           C  
HETATM 2562  O   MSE B 161      -4.420  30.806  33.522  1.00 10.27           O  
HETATM 2563  CB  MSE B 161      -6.328  28.992  31.574  1.00  9.10           C  
HETATM 2564  CG  MSE B 161      -6.917  27.611  31.173  1.00  8.57           C  
HETATM 2565 SE   MSE B 161      -8.697  27.666  30.749  1.00  5.20          SE  
HETATM 2566  CE  MSE B 161      -8.574  28.368  29.088  1.00  7.66           C  
ATOM   2567  N   GLN B 162      -4.038  31.228  31.352  1.00  8.70           N  
ATOM   2568  CA  GLN B 162      -3.644  32.605  31.656  1.00  9.18           C  
ATOM   2569  C   GLN B 162      -4.111  33.610  30.618  1.00  9.29           C  
ATOM   2570  O   GLN B 162      -4.337  33.260  29.452  1.00  8.41           O  
ATOM   2571  CB  GLN B 162      -2.124  32.704  31.877  1.00  9.74           C  
ATOM   2572  CG  GLN B 162      -1.301  32.653  30.598  1.00 11.23           C  
ATOM   2573  CD  GLN B 162       0.176  32.664  30.894  1.00 13.09           C  
ATOM   2574  OE1 GLN B 162       0.845  33.691  30.765  1.00 15.23           O  
ATOM   2575  NE2 GLN B 162       0.691  31.524  31.300  1.00 11.87           N  
ATOM   2576  N   LEU B 163      -4.285  34.849  31.081  1.00  9.49           N  
ATOM   2577  CA  LEU B 163      -4.673  35.970  30.244  1.00 11.00           C  
ATOM   2578  C   LEU B 163      -3.650  37.059  30.435  1.00 11.24           C  
ATOM   2579  O   LEU B 163      -3.441  37.513  31.559  1.00 11.29           O  
ATOM   2580  CB  LEU B 163      -6.058  36.492  30.659  1.00 10.02           C  
ATOM   2581  CG  LEU B 163      -6.576  37.721  29.894  1.00 10.83           C  
ATOM   2582  CD1 LEU B 163      -6.653  37.471  28.382  1.00  9.08           C  
ATOM   2583  CD2 LEU B 163      -7.939  38.163  30.449  1.00 12.06           C  
ATOM   2584  N   ASN B 164      -2.984  37.469  29.363  1.00 13.37           N  
ATOM   2585  CA  ASN B 164      -2.109  38.637  29.446  1.00 15.27           C  
ATOM   2586  C   ASN B 164      -2.955  39.884  29.247  1.00 16.61           C  
ATOM   2587  O   ASN B 164      -3.598  40.064  28.202  1.00 16.36           O  
ATOM   2588  CB  ASN B 164      -0.941  38.572  28.449  1.00 15.76           C  
ATOM   2589  CG  ASN B 164       0.094  39.715  28.661  1.00 17.55           C  
ATOM   2590  OD1 ASN B 164      -0.260  40.875  28.887  1.00 16.72           O  
ATOM   2591  ND2 ASN B 164       1.372  39.375  28.554  1.00 19.41           N  
ATOM   2592  N   LEU B 165      -2.952  40.734  30.267  1.00 17.82           N  
ATOM   2593  CA  LEU B 165      -3.825  41.893  30.332  1.00 19.38           C  
ATOM   2594  C   LEU B 165      -3.325  43.082  29.511  1.00 21.00           C  
ATOM   2595  O   LEU B 165      -4.101  43.973  29.172  1.00 21.45           O  
ATOM   2596  CB  LEU B 165      -4.010  42.310  31.789  1.00 18.98           C  
ATOM   2597  CG  LEU B 165      -4.641  41.256  32.703  1.00 19.97           C  
ATOM   2598  CD1 LEU B 165      -4.349  41.560  34.167  1.00 20.12           C  
ATOM   2599  CD2 LEU B 165      -6.142  41.125  32.449  1.00 21.09           C  
ATOM   2600  N   ASP B 166      -2.034  43.104  29.200  1.00 22.32           N  
ATOM   2601  CA  ASP B 166      -1.475  44.190  28.400  1.00 23.77           C  
ATOM   2602  C   ASP B 166      -0.398  43.637  27.484  1.00 24.11           C  
ATOM   2603  O   ASP B 166       0.791  43.851  27.721  1.00 24.36           O  
ATOM   2604  CB  ASP B 166      -0.915  45.272  29.313  1.00 24.10           C  
ATOM   2605  CG  ASP B 166      -0.529  46.543  28.562  1.00 26.23           C  
ATOM   2606  OD1 ASP B 166      -0.527  46.560  27.301  1.00 28.09           O  
ATOM   2607  OD2 ASP B 166      -0.217  47.533  29.254  1.00 28.72           O  
ATOM   2608  N   PRO B 167      -0.813  42.910  26.431  1.00 24.95           N  
ATOM   2609  CA  PRO B 167       0.143  42.208  25.583  1.00 25.60           C  
ATOM   2610  C   PRO B 167       1.166  43.151  24.949  1.00 26.16           C  
ATOM   2611  O   PRO B 167       2.289  42.720  24.673  1.00 26.19           O  
ATOM   2612  CB  PRO B 167      -0.740  41.553  24.515  1.00 25.76           C  
ATOM   2613  CG  PRO B 167      -2.016  42.306  24.549  1.00 25.69           C  
ATOM   2614  CD  PRO B 167      -2.198  42.706  25.972  1.00 24.98           C  
ATOM   2615  N   THR B 168       0.792  44.422  24.770  1.00 26.61           N  
ATOM   2616  CA  THR B 168       1.694  45.436  24.184  1.00 27.50           C  
ATOM   2617  C   THR B 168       2.825  45.918  25.118  1.00 27.74           C  
ATOM   2618  O   THR B 168       3.795  46.515  24.642  1.00 27.87           O  
ATOM   2619  CB  THR B 168       0.928  46.674  23.616  1.00 27.30           C  
ATOM   2620  OG1 THR B 168       0.471  47.515  24.687  1.00 27.58           O  
ATOM   2621  CG2 THR B 168      -0.253  46.239  22.761  1.00 27.80           C  
ATOM   2622  N   ARG B 169       2.697  45.676  26.428  1.00 27.90           N  
ATOM   2623  CA  ARG B 169       3.717  46.102  27.395  1.00 28.01           C  
ATOM   2624  C   ARG B 169       4.939  45.184  27.324  1.00 27.85           C  
ATOM   2625  O   ARG B 169       5.042  44.192  28.047  1.00 27.39           O  
ATOM   2626  CB  ARG B 169       3.154  46.195  28.820  1.00 28.38           C  
ATOM   2627  CG  ARG B 169       4.142  46.785  29.832  1.00 30.58           C  
ATOM   2628  CD  ARG B 169       3.472  47.560  30.957  1.00 34.54           C  
ATOM   2629  NE  ARG B 169       3.037  46.718  32.074  1.00 37.29           N  
ATOM   2630  CZ  ARG B 169       3.707  46.559  33.218  1.00 37.97           C  
ATOM   2631  NH1 ARG B 169       4.865  47.179  33.411  1.00 38.50           N  
ATOM   2632  NH2 ARG B 169       3.215  45.775  34.177  1.00 37.30           N  
ATOM   2633  N   SER B 170       5.861  45.545  26.438  1.00 27.81           N  
ATOM   2634  CA  SER B 170       6.993  44.702  26.070  1.00 27.96           C  
ATOM   2635  C   SER B 170       7.994  44.485  27.200  1.00 27.50           C  
ATOM   2636  O   SER B 170       8.728  43.495  27.196  1.00 27.19           O  
ATOM   2637  CB  SER B 170       7.711  45.296  24.854  1.00 28.23           C  
ATOM   2638  OG  SER B 170       6.881  45.259  23.700  1.00 29.97           O  
ATOM   2639  N   ALA B 171       8.027  45.422  28.148  1.00 27.16           N  
ATOM   2640  CA  ALA B 171       8.937  45.348  29.292  1.00 27.08           C  
ATOM   2641  C   ALA B 171       8.265  45.846  30.573  1.00 26.86           C  
ATOM   2642  O   ALA B 171       7.374  46.701  30.514  1.00 26.56           O  
ATOM   2643  CB  ALA B 171      10.227  46.137  29.001  1.00 27.16           C  
ATOM   2644  N   PRO B 172       8.672  45.303  31.737  1.00 26.84           N  
ATOM   2645  CA  PRO B 172       8.060  45.719  32.999  1.00 27.12           C  
ATOM   2646  C   PRO B 172       8.419  47.155  33.375  1.00 27.55           C  
ATOM   2647  O   PRO B 172       7.734  47.781  34.185  1.00 28.09           O  
ATOM   2648  CB  PRO B 172       8.631  44.726  34.014  1.00 26.94           C  
ATOM   2649  CG  PRO B 172       9.900  44.255  33.414  1.00 26.58           C  
ATOM   2650  CD  PRO B 172       9.706  44.269  31.941  1.00 26.75           C  
ATOM   2651  OXT PRO B 172       9.388  47.730  32.868  1.00 27.81           O  
TER    2652      PRO B 172                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
