
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  173 ( 1414),  selected  173 , name 1tiq_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 1tiq_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_A      A       2          1.751
LGA    V     3_A      I       3          1.836
LGA    K     4_A      N       4          0.432
LGA    X     5_A      I       5          0.670
LGA    K     6_A      I       6          0.703
LGA    K     7_A      E       7          0.474
LGA    C     8_A      Y       8          0.760
LGA    S     9_A      N       9          1.872
LGA    R    10_A      R      10          2.342
LGA    E    11_A      S      11          2.572
LGA    D    12_A      Y      12          2.224
LGA    L    13_A      K      13          1.614
LGA    Q    14_A      E      14          2.323
LGA    T    15_A      E      15          2.185
LGA    L    16_A      L      16          1.725
LGA    Q    17_A      I      17          1.998
LGA    Q    18_A      E      18          2.092
LGA    L    19_A      F      19          1.708
LGA    S    20_A      I      20          2.151
LGA    I    21_A      L      21          1.980
LGA    E    22_A      S      22          1.801
LGA    T    23_A      I      23          2.318
LGA    F    24_A      Q      24          2.095
LGA    N    25_A      K      25          1.849
LGA    D    26_A      N      26          3.647
LGA    T    27_A      E      27          4.655
LGA    F    28_A      F      28          3.393
LGA    K    29_A      N      29          1.104
LGA    E    30_A      -       -           -
LGA    Q    31_A      I      30          5.440
LGA    N    32_A      K      31          4.158
LGA    S    33_A      -       -           -
LGA    P    34_A      -       -           -
LGA    E    35_A      -       -           -
LGA    N    36_A      -       -           -
LGA    X    37_A      I      32          4.760
LGA    K    38_A      -       -           -
LGA    A    39_A      -       -           -
LGA    Y    40_A      -       -           -
LGA    L    41_A      D      33          2.358
LGA    E    42_A      R      34          3.479
LGA    S    43_A      D      35          0.552
LGA    A    44_A      D      36          3.661
LGA    F    45_A      Q      37          5.446
LGA    N    46_A      -       -           -
LGA    T    47_A      -       -           -
LGA    E    48_A      P      38           #
LGA    Q    49_A      D      39          5.094
LGA    L    50_A      L      40          2.667
LGA    E    51_A      E      41          3.360
LGA    K    52_A      N      42          3.033
LGA    E    53_A      I      43          3.546
LGA    L    54_A      E      44          2.637
LGA    S    55_A      H      45          1.726
LGA    N    56_A      N      46          2.682
LGA    -       -      Y      47           -
LGA    -       -      L      48           -
LGA    X    57_A      N      49          1.736
LGA    S    58_A      S      50          2.179
LGA    -       -      G      51           -
LGA    S    59_A      G      52          3.702
LGA    Q    60_A      Q      53          2.568
LGA    F    61_A      F      54          1.605
LGA    F    62_A      W      55          1.187
LGA    F    63_A      L      56          0.798
LGA    I    64_A      A      57          0.130
LGA    Y    65_A      I      58          1.622
LGA    F    66_A      N      59          2.994
LGA    D    67_A      N      60          3.007
LGA    H    68_A      H      61          3.526
LGA    E    69_A      Q      62          4.376
LGA    -       -      N      63           -
LGA    I    70_A      I      64          2.247
LGA    A    71_A      V      65          0.588
LGA    G    72_A      G      66          1.447
LGA    Y    73_A      T      67          0.807
LGA    V    74_A      I      68          0.848
LGA    K    75_A      G      69          1.249
LGA    V    76_A      L      70          0.938
LGA    N    77_A      I      71          0.507
LGA    I    78_A      R      72          0.451
LGA    D    79_A      L      73          2.362
LGA    D    80_A      -       -           -
LGA    A    81_A      -       -           -
LGA    Q    82_A      -       -           -
LGA    S    83_A      -       -           -
LGA    E    84_A      -       -           -
LGA    E    85_A      -       -           -
LGA    X    86_A      -       -           -
LGA    G    87_A      D      74          2.888
LGA    A    88_A      N      75          2.755
LGA    E    89_A      N      76          1.333
LGA    S    90_A      M      77          1.386
LGA    L    91_A      S      78          1.935
LGA    E    92_A      A      79          1.395
LGA    I    93_A      L      80          0.863
LGA    E    94_A      K      81          1.412
LGA    R    95_A      K      82          1.363
LGA    I    96_A      M      83          0.244
LGA    Y    97_A      F      84          0.365
LGA    I    98_A      V      85          0.467
LGA    K    99_A      D      86          0.953
LGA    N   100_A      K      87          0.639
LGA    S   101_A      G      88          0.845
LGA    F   102_A      Y      89          0.877
LGA    Q   103_A      R      90          0.778
LGA    K   104_A      N      91          1.727
LGA    H   105_A      L      92          1.151
LGA    G   106_A      K      93          0.291
LGA    L   107_A      I      94          0.412
LGA    G   108_A      G      95          0.716
LGA    K   109_A      K      96          0.642
LGA    H   110_A      K      97          0.804
LGA    L   111_A      L      98          0.938
LGA    L   112_A      L      99          1.078
LGA    N   113_A      D     100          1.124
LGA    K   114_A      K     101          1.305
LGA    A   115_A      V     102          1.478
LGA    I   116_A      I     103          0.906
LGA    E   117_A      M     104          1.389
LGA    I   118_A      T     105          1.852
LGA    A   119_A      C     106          1.238
LGA    L   120_A      K     107          0.876
LGA    E   121_A      E     108          1.367
LGA    R   122_A      Q     109          1.167
LGA    N   123_A      N     110          0.426
LGA    K   124_A      I     111          0.770
LGA    K   125_A      D     112          0.975
LGA    N   126_A      G     113          1.032
LGA    I   127_A      I     114          1.529
LGA    W   128_A      Y     115          1.954
LGA    L   129_A      L     116          0.933
LGA    G   130_A      G     117          1.178
LGA    V   131_A      T     118          1.729
LGA    W   132_A      I     119          1.626
LGA    E   133_A      D     120          3.016
LGA    K   134_A      K     121          3.761
LGA    N   135_A      F     122          2.686
LGA    E   136_A      I     123          2.403
LGA    N   137_A      S     124          0.830
LGA    A   138_A      A     125          0.703
LGA    I   139_A      Q     126          0.865
LGA    A   140_A      Y     127          0.256
LGA    F   141_A      F     128          0.539
LGA    Y   142_A      Y     129          0.708
LGA    K   143_A      S     130          0.983
LGA    K   144_A      N     131          1.038
LGA    X   145_A      N     132          0.956
LGA    G   146_A      G     133          1.631
LGA    F   147_A      F     134          1.115
LGA    V   148_A      R     135          0.943
LGA    Q   149_A      E     136          0.865
LGA    T   150_A      I     137          2.511
LGA    G   151_A      K     138          2.178
LGA    A   152_A      -       -           -
LGA    H   153_A      R     139          2.995
LGA    S   154_A      G     140           -
LGA    -       -      D     141           -
LGA    -       -      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    -       -      K     148           -
LGA    F   155_A      L     149           #
LGA    Y   156_A      D     150          4.289
LGA    X   157_A      V     151          3.932
LGA    G   158_A      -       -           -
LGA    D   159_A      -       -           -
LGA    E   160_A      -       -           -
LGA    E   161_A      -       -           -
LGA    Q   162_A      -       -           -
LGA    T   163_A      D     152           #
LGA    D   164_A      N     153          1.963
LGA    L   165_A      R     154          2.137
LGA    I   166_A      F     155          1.905
LGA    X   167_A      Y     156          1.004
LGA    A   168_A      Y     157          1.308
LGA    K   169_A      R     158          1.624
LGA    T   170_A      N     159          1.283
LGA    L   171_A      L     160          1.135
LGA    I   172_A      K     161          2.732
LGA    L   173_A      -       -           -
LGA    E   174_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  173  160    5.0    144    2.12    20.83     70.513     6.475

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.077171 * X  +   0.877782 * Y  +  -0.472805 * Z  + -48.271381
  Y_new =   0.835590 * X  +  -0.201760 * Y  +  -0.510962 * Z  +  59.963402
  Z_new =  -0.543906 * X  +  -0.434502 * Y  +  -0.717896 * Z  + 113.610641 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.597326    0.544267  [ DEG:  -148.8158     31.1842 ]
  Theta =   0.575085    2.566508  [ DEG:    32.9499    147.0501 ]
  Phi   =   1.662890   -1.478702  [ DEG:    95.2766    -84.7234 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1tiq_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1tiq_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  173  160   5.0  144   2.12   20.83  70.513
REMARK  ---------------------------------------------------------- 
MOLECULE 1tiq_A
HEADER    STRUCTURAL GENOMICS, TRANSCRIPTION      02-JUN-04   1TIQ              
TITLE     CRYSTAL STRUCTURE OF AN ACETYLTRANSFERASE (PAIA) IN COMPLEX           
TITLE    2 WITH COA AND DTT FROM BACILLUS SUBTILIS, NORTHEAST                   
TITLE    3 STRUCTURAL GENOMICS TARGET SR64.                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEASE SYNTHASE AND SPORULATION NEGATIVE                 
COMPND   3 REGULATORY PROTEIN PAI 1;                                            
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 STRAIN: 168;                                                         
SOURCE   4 GENE: PAIA, BSU32150;                                                
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PET21;                                
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: BL21                                      
KEYWDS    ALPHA-BETA PROTEIN, STRUCTURAL GENOMICS, PSI, PROTEIN                 
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.FOROUHAR,I.LEE,J.SHEN,S.M.VOROBIEV,R.XIAO,T.B.ACTON,                
AUTHOR   2 G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL                  
AUTHOR   3 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   2   25-JAN-05 1TIQ    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   13-JUL-04 1TIQ    0                                                
JRNL        AUTH   F.FOROUHAR,I.S.LEE,J.VUJCIC,S.VUJCIC,J.SHEN,                 
JRNL        AUTH 2 S.M.VOROBIEV,R.XIAO,T.B.ACTON,G.T.MONTELIONE,                
JRNL        AUTH 3 C.W.PORTER,L.TONG                                            
JRNL        TITL   STRUCTURAL AND FUNCTIONAL EVIDENCE FOR BACILLUS              
JRNL        TITL 2 SUBTILIS PAIA AS A NOVEL N1-SPERMIDINE/SPERMINE              
JRNL        TITL 3 ACETYLTRANSFERASE.                                           
JRNL        REF    J.BIOL.CHEM.                  V. 280 40328 2005              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1TIQ A    2   172  UNP    P21340   PAIA_BACSU       1    171             
DBREF  1TIQ B    2   172  UNP    P21340   PAIA_BACSU       1    171             
SEQRES   1 A  180  MET SER VAL LYS MSE LYS LYS CYS SER ARG GLU ASP LEU          
SEQRES   2 A  180  GLN THR LEU GLN GLN LEU SER ILE GLU THR PHE ASN ASP          
SEQRES   3 A  180  THR PHE LYS GLU GLN ASN SER PRO GLU ASN MSE LYS ALA          
SEQRES   4 A  180  TYR LEU GLU SER ALA PHE ASN THR GLU GLN LEU GLU LYS          
SEQRES   5 A  180  GLU LEU SER ASN MSE SER SER GLN PHE PHE PHE ILE TYR          
SEQRES   6 A  180  PHE ASP HIS GLU ILE ALA GLY TYR VAL LYS VAL ASN ILE          
SEQRES   7 A  180  ASP ASP ALA GLN SER GLU GLU MSE GLY ALA GLU SER LEU          
SEQRES   8 A  180  GLU ILE GLU ARG ILE TYR ILE LYS ASN SER PHE GLN LYS          
SEQRES   9 A  180  HIS GLY LEU GLY LYS HIS LEU LEU ASN LYS ALA ILE GLU          
SEQRES  10 A  180  ILE ALA LEU GLU ARG ASN LYS LYS ASN ILE TRP LEU GLY          
SEQRES  11 A  180  VAL TRP GLU LYS ASN GLU ASN ALA ILE ALA PHE TYR LYS          
SEQRES  12 A  180  LYS MSE GLY PHE VAL GLN THR GLY ALA HIS SER PHE TYR          
SEQRES  13 A  180  MSE GLY ASP GLU GLU GLN THR ASP LEU ILE MSE ALA LYS          
SEQRES  14 A  180  THR LEU ILE LEU GLU HIS HIS HIS HIS HIS HIS                  
SEQRES   1 B  180  MET SER VAL LYS MSE LYS LYS CYS SER ARG GLU ASP LEU          
SEQRES   2 B  180  GLN THR LEU GLN GLN LEU SER ILE GLU THR PHE ASN ASP          
SEQRES   3 B  180  THR PHE LYS GLU GLN ASN SER PRO GLU ASN MSE LYS ALA          
SEQRES   4 B  180  TYR LEU GLU SER ALA PHE ASN THR GLU GLN LEU GLU LYS          
SEQRES   5 B  180  GLU LEU SER ASN MSE SER SER GLN PHE PHE PHE ILE TYR          
SEQRES   6 B  180  PHE ASP HIS GLU ILE ALA GLY TYR VAL LYS VAL ASN ILE          
SEQRES   7 B  180  ASP ASP ALA GLN SER GLU GLU MSE GLY ALA GLU SER LEU          
SEQRES   8 B  180  GLU ILE GLU ARG ILE TYR ILE LYS ASN SER PHE GLN LYS          
SEQRES   9 B  180  HIS GLY LEU GLY LYS HIS LEU LEU ASN LYS ALA ILE GLU          
SEQRES  10 B  180  ILE ALA LEU GLU ARG ASN LYS LYS ASN ILE TRP LEU GLY          
SEQRES  11 B  180  VAL TRP GLU LYS ASN GLU ASN ALA ILE ALA PHE TYR LYS          
SEQRES  12 B  180  LYS MSE GLY PHE VAL GLN THR GLY ALA HIS SER PHE TYR          
SEQRES  13 B  180  MSE GLY ASP GLU GLU GLN THR ASP LEU ILE MSE ALA LYS          
SEQRES  14 B  180  THR LEU ILE LEU GLU HIS HIS HIS HIS HIS HIS                  
HET    MSE  A   5       8                                                       
HET    MSE  A  37       8                                                       
HET    MSE  A  57       8                                                       
HET    MSE  A  86       8                                                       
HET    MSE  A 145       8                                                       
HET    MSE  A 157       8                                                       
HET    MSE  A 167       8                                                       
HET    MSE  B   5       8                                                       
HET    MSE  B  37       8                                                       
HET    MSE  B  57       8                                                       
HET    MSE  B  86       8                                                       
HET    MSE  B 145       8                                                       
HET    MSE  B 157       8                                                       
HET    MSE  B 167       8                                                       
HET    SO4    401       5                                                       
HET    COA    301      48                                                       
HET    COA    303      22                                                       
HET    COA    302      48                                                       
HET    DTT   1201       8                                                       
HET    DTT   1202       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM     COA COENZYME A                                                       
HETNAM     DTT 2,3-DIHYDROXY-1,4-DITHIOBUTANE                                   
HETSYN     DTT 1,4-DITHIOTHREITOL                                               
FORMUL   1  MSE    14(C5 H11 N O2 SE)                                           
FORMUL   3  SO4    O4 S 2-                                                      
FORMUL   4  COA    3(C21 H36 N7 O16 P3 S)                                       
FORMUL   7  DTT    2(C4 H10 O2 S2)                                              
FORMUL   9  HOH   *272(H2 O)                                                    
CRYST1   39.870  135.825  132.395  90.00  90.00  90.00 C 2 2 21     16          
ATOM      1  N   SER A   2     -32.373  43.074  38.354  1.00 29.15           N  
ATOM      2  CA  SER A   2     -31.160  43.522  37.613  1.00 29.65           C  
ATOM      3  C   SER A   2     -29.903  42.889  38.209  1.00 27.60           C  
ATOM      4  O   SER A   2     -29.952  42.296  39.285  1.00 30.05           O  
ATOM      5  CB  SER A   2     -31.051  45.049  37.668  1.00 31.85           C  
ATOM      6  OG  SER A   2     -29.957  45.518  36.897  1.00 35.24           O  
ATOM      7  N   VAL A   3     -28.781  43.015  37.504  1.00 25.03           N  
ATOM      8  CA  VAL A   3     -27.512  42.459  37.968  1.00 23.76           C  
ATOM      9  C   VAL A   3     -26.662  43.529  38.650  1.00 22.64           C  
ATOM     10  O   VAL A   3     -26.506  44.634  38.130  1.00 23.52           O  
ATOM     11  CB  VAL A   3     -26.695  41.861  36.786  1.00 23.64           C  
ATOM     12  CG1 VAL A   3     -25.315  41.409  37.271  1.00 23.06           C  
ATOM     13  CG2 VAL A   3     -27.447  40.684  36.176  1.00 23.79           C  
ATOM     14  N   LYS A   4     -26.121  43.207  39.819  1.00 21.32           N  
ATOM     15  CA  LYS A   4     -25.272  44.145  40.539  1.00 21.73           C  
ATOM     16  C   LYS A   4     -24.172  43.398  41.275  1.00 20.59           C  
ATOM     17  O   LYS A   4     -24.354  42.250  41.679  1.00 19.45           O  
ATOM     18  CB  LYS A   4     -26.085  44.962  41.548  1.00 24.76           C  
ATOM     19  CG  LYS A   4     -26.607  44.164  42.724  1.00 27.70           C  
ATOM     20  CD  LYS A   4     -27.370  45.051  43.696  1.00 33.24           C  
ATOM     21  CE  LYS A   4     -27.885  44.249  44.883  1.00 34.35           C  
ATOM     22  NZ  LYS A   4     -28.639  45.103  45.834  1.00 36.80           N  
HETATM   23  N   MSE A   5     -23.026  44.050  41.430  1.00 19.33           N  
HETATM   24  CA  MSE A   5     -21.910  43.458  42.146  1.00 18.51           C  
HETATM   25  C   MSE A   5     -21.490  44.402  43.258  1.00 19.31           C  
HETATM   26  O   MSE A   5     -21.611  45.624  43.128  1.00 18.74           O  
HETATM   27  CB  MSE A   5     -20.731  43.193  41.207  1.00 18.89           C  
HETATM   28  CG  MSE A   5     -20.942  42.000  40.283  1.00 19.09           C  
HETATM   29 SE   MSE A   5     -19.445  41.715  39.102  1.00 25.09          SE  
HETATM   30  CE  MSE A   5     -20.009  42.889  37.682  1.00 26.79           C  
ATOM     31  N   LYS A   6     -21.003  43.827  44.352  1.00 16.57           N  
ATOM     32  CA  LYS A   6     -20.569  44.605  45.507  1.00 18.54           C  
ATOM     33  C   LYS A   6     -19.289  44.034  46.100  1.00 16.59           C  
ATOM     34  O   LYS A   6     -19.139  42.814  46.206  1.00 14.53           O  
ATOM     35  CB  LYS A   6     -21.659  44.601  46.580  1.00 20.67           C  
ATOM     36  CG  LYS A   6     -21.312  45.439  47.802  1.00 25.49           C  
ATOM     37  CD  LYS A   6     -22.264  45.178  48.957  1.00 27.28           C  
ATOM     38  CE  LYS A   6     -22.117  43.767  49.486  1.00 29.43           C  
ATOM     39  NZ  LYS A   6     -23.037  43.510  50.624  1.00 32.06           N  
ATOM     40  N   LYS A   7     -18.370  44.912  46.490  1.00 14.39           N  
ATOM     41  CA  LYS A   7     -17.119  44.471  47.099  1.00 16.35           C  
ATOM     42  C   LYS A   7     -17.437  44.013  48.516  1.00 16.17           C  
ATOM     43  O   LYS A   7     -18.133  44.709  49.259  1.00 15.16           O  
ATOM     44  CB  LYS A   7     -16.095  45.614  47.152  1.00 18.29           C  
ATOM     45  CG  LYS A   7     -14.779  45.207  47.808  1.00 20.81           C  
ATOM     46  CD  LYS A   7     -13.808  46.378  47.986  1.00 25.23           C  
ATOM     47  CE  LYS A   7     -13.360  46.959  46.659  1.00 28.07           C  
ATOM     48  NZ  LYS A   7     -12.424  48.117  46.843  1.00 29.19           N  
ATOM     49  N   CYS A   8     -16.920  42.850  48.894  1.00 14.91           N  
ATOM     50  CA  CYS A   8     -17.172  42.300  50.223  1.00 14.91           C  
ATOM     51  C   CYS A   8     -16.415  43.010  51.340  1.00 18.03           C  
ATOM     52  O   CYS A   8     -15.247  43.362  51.191  1.00 17.61           O  
ATOM     53  CB  CYS A   8     -16.813  40.813  50.255  1.00 14.47           C  
ATOM     54  SG  CYS A   8     -17.776  39.775  49.136  1.00 14.21           S  
ATOM     55  N   SER A   9     -17.091  43.216  52.466  1.00 20.36           N  
ATOM     56  CA  SER A   9     -16.474  43.862  53.619  1.00 23.14           C  
ATOM     57  C   SER A   9     -16.470  42.899  54.790  1.00 23.62           C  
ATOM     58  O   SER A   9     -16.902  41.751  54.672  1.00 19.63           O  
ATOM     59  CB  SER A   9     -17.243  45.123  54.005  1.00 24.50           C  
ATOM     60  OG  SER A   9     -17.230  46.053  52.942  1.00 31.12           O  
ATOM     61  N   ARG A  10     -15.985  43.382  55.927  1.00 24.44           N  
ATOM     62  CA  ARG A  10     -15.913  42.574  57.129  1.00 25.77           C  
ATOM     63  C   ARG A  10     -17.289  42.057  57.544  1.00 22.65           C  
ATOM     64  O   ARG A  10     -17.408  40.942  58.039  1.00 24.03           O  
ATOM     65  CB  ARG A  10     -15.300  43.399  58.264  1.00 29.12           C  
ATOM     66  CG  ARG A  10     -14.914  42.599  59.490  1.00 33.08           C  
ATOM     67  CD  ARG A  10     -14.214  43.498  60.502  1.00 37.60           C  
ATOM     68  NE  ARG A  10     -13.088  44.214  59.901  1.00 39.19           N  
ATOM     69  CZ  ARG A  10     -12.017  43.624  59.379  1.00 39.89           C  
ATOM     70  NH1 ARG A  10     -11.041  44.356  58.855  1.00 41.04           N  
ATOM     71  NH2 ARG A  10     -11.917  42.301  59.387  1.00 40.58           N  
ATOM     72  N   GLU A  11     -18.325  42.863  57.335  1.00 23.10           N  
ATOM     73  CA  GLU A  11     -19.675  42.456  57.707  1.00 23.12           C  
ATOM     74  C   GLU A  11     -20.254  41.359  56.817  1.00 20.01           C  
ATOM     75  O   GLU A  11     -21.256  40.736  57.166  1.00 20.23           O  
ATOM     76  CB  GLU A  11     -20.621  43.662  57.726  1.00 26.33           C  
ATOM     77  CG  GLU A  11     -20.375  44.702  56.650  1.00 33.93           C  
ATOM     78  CD  GLU A  11     -19.453  45.824  57.119  1.00 37.33           C  
ATOM     79  OE1 GLU A  11     -18.260  45.554  57.384  1.00 38.83           O  
ATOM     80  OE2 GLU A  11     -19.928  46.976  57.230  1.00 38.95           O  
ATOM     81  N   ASP A  12     -19.616  41.114  55.678  1.00 17.33           N  
ATOM     82  CA  ASP A  12     -20.076  40.082  54.750  1.00 14.54           C  
ATOM     83  C   ASP A  12     -19.458  38.722  55.053  1.00 13.83           C  
ATOM     84  O   ASP A  12     -19.707  37.756  54.340  1.00  9.90           O  
ATOM     85  CB  ASP A  12     -19.721  40.468  53.313  1.00 14.61           C  
ATOM     86  CG  ASP A  12     -20.419  41.725  52.859  1.00 16.15           C  
ATOM     87  OD1 ASP A  12     -21.661  41.787  52.986  1.00 16.16           O  
ATOM     88  OD2 ASP A  12     -19.729  42.649  52.373  1.00 17.91           O  
ATOM     89  N   LEU A  13     -18.656  38.655  56.111  1.00 13.16           N  
ATOM     90  CA  LEU A  13     -17.974  37.423  56.496  1.00 14.48           C  
ATOM     91  C   LEU A  13     -18.870  36.193  56.585  1.00 14.28           C  
ATOM     92  O   LEU A  13     -18.571  35.158  55.992  1.00 13.62           O  
ATOM     93  CB  LEU A  13     -17.257  37.623  57.833  1.00 15.21           C  
ATOM     94  CG  LEU A  13     -16.512  36.428  58.436  1.00 18.19           C  
ATOM     95  CD1 LEU A  13     -15.378  35.982  57.514  1.00 19.49           C  
ATOM     96  CD2 LEU A  13     -15.953  36.836  59.795  1.00 19.92           C  
ATOM     97  N   GLN A  14     -19.963  36.299  57.335  1.00 15.35           N  
ATOM     98  CA  GLN A  14     -20.870  35.169  57.497  1.00 16.36           C  
ATOM     99  C   GLN A  14     -21.511  34.728  56.184  1.00 14.68           C  
ATOM    100  O   GLN A  14     -21.603  33.533  55.902  1.00 12.46           O  
ATOM    101  CB  GLN A  14     -21.960  35.503  58.518  1.00 18.75           C  
ATOM    102  CG  GLN A  14     -21.466  35.612  59.957  1.00 24.45           C  
ATOM    103  CD  GLN A  14     -20.400  36.679  60.146  1.00 24.38           C  
ATOM    104  OE1 GLN A  14     -20.551  37.816  59.691  1.00 27.68           O  
ATOM    105  NE2 GLN A  14     -19.321  36.319  60.833  1.00 25.87           N  
ATOM    106  N   THR A  15     -21.963  35.692  55.390  1.00 14.30           N  
ATOM    107  CA  THR A  15     -22.587  35.383  54.107  1.00 13.91           C  
ATOM    108  C   THR A  15     -21.558  34.758  53.172  1.00 12.87           C  
ATOM    109  O   THR A  15     -21.839  33.764  52.506  1.00 11.96           O  
ATOM    110  CB  THR A  15     -23.167  36.651  53.438  1.00 17.65           C  
ATOM    111  OG1 THR A  15     -24.131  37.251  54.312  1.00 24.03           O  
ATOM    112  CG2 THR A  15     -23.851  36.293  52.122  1.00 19.70           C  
ATOM    113  N   LEU A  16     -20.362  35.343  53.127  1.00 11.34           N  
ATOM    114  CA  LEU A  16     -19.297  34.817  52.273  1.00 11.27           C  
ATOM    115  C   LEU A  16     -18.984  33.372  52.655  1.00 10.19           C  
ATOM    116  O   LEU A  16     -18.817  32.519  51.790  1.00 10.02           O  
ATOM    117  CB  LEU A  16     -18.029  35.662  52.410  1.00 10.65           C  
ATOM    118  CG  LEU A  16     -16.792  35.148  51.657  1.00 10.93           C  
ATOM    119  CD1 LEU A  16     -17.023  35.259  50.151  1.00 11.82           C  
ATOM    120  CD2 LEU A  16     -15.568  35.960  52.058  1.00 12.36           C  
ATOM    121  N   GLN A  17     -18.910  33.105  53.956  1.00 10.92           N  
ATOM    122  CA  GLN A  17     -18.607  31.761  54.444  1.00 11.93           C  
ATOM    123  C   GLN A  17     -19.635  30.733  53.993  1.00 11.04           C  
ATOM    124  O   GLN A  17     -19.280  29.641  53.539  1.00 12.30           O  
ATOM    125  CB  GLN A  17     -18.520  31.757  55.974  1.00 12.62           C  
ATOM    126  CG  GLN A  17     -18.395  30.368  56.597  1.00 15.20           C  
ATOM    127  CD  GLN A  17     -18.399  30.418  58.119  1.00 20.42           C  
ATOM    128  OE1 GLN A  17     -19.332  30.941  58.732  1.00 21.90           O  
ATOM    129  NE2 GLN A  17     -17.351  29.877  58.733  1.00 20.80           N  
ATOM    130  N   GLN A  18     -20.913  31.072  54.115  1.00  9.91           N  
ATOM    131  CA  GLN A  18     -21.961  30.140  53.722  1.00 10.46           C  
ATOM    132  C   GLN A  18     -21.970  29.909  52.216  1.00  7.89           C  
ATOM    133  O   GLN A  18     -22.102  28.775  51.749  1.00 10.06           O  
ATOM    134  CB  GLN A  18     -23.329  30.660  54.176  1.00 13.25           C  
ATOM    135  CG  GLN A  18     -24.458  29.707  53.838  1.00 17.42           C  
ATOM    136  CD  GLN A  18     -24.312  28.355  54.522  1.00 17.50           C  
ATOM    137  OE1 GLN A  18     -24.719  27.332  53.979  1.00 22.48           O  
ATOM    138  NE2 GLN A  18     -23.746  28.350  55.718  1.00 17.38           N  
ATOM    139  N   LEU A  19     -21.824  30.985  51.454  1.00  9.09           N  
ATOM    140  CA  LEU A  19     -21.819  30.880  49.998  1.00  7.32           C  
ATOM    141  C   LEU A  19     -20.594  30.082  49.540  1.00  7.96           C  
ATOM    142  O   LEU A  19     -20.681  29.271  48.617  1.00  8.86           O  
ATOM    143  CB  LEU A  19     -21.805  32.280  49.381  1.00  9.10           C  
ATOM    144  CG  LEU A  19     -21.851  32.364  47.851  1.00  9.25           C  
ATOM    145  CD1 LEU A  19     -23.187  31.813  47.346  1.00 11.03           C  
ATOM    146  CD2 LEU A  19     -21.676  33.821  47.426  1.00 11.75           C  
ATOM    147  N   SER A  20     -19.456  30.309  50.195  1.00  7.87           N  
ATOM    148  CA  SER A  20     -18.220  29.594  49.851  1.00  8.95           C  
ATOM    149  C   SER A  20     -18.373  28.086  50.065  1.00  9.61           C  
ATOM    150  O   SER A  20     -17.999  27.281  49.209  1.00  8.37           O  
ATOM    151  CB  SER A  20     -17.048  30.113  50.695  1.00  7.97           C  
ATOM    152  OG  SER A  20     -16.765  31.470  50.408  1.00  9.51           O  
ATOM    153  N   ILE A  21     -18.935  27.712  51.210  1.00 10.94           N  
ATOM    154  CA  ILE A  21     -19.134  26.305  51.541  1.00 10.21           C  
ATOM    155  C   ILE A  21     -20.074  25.600  50.560  1.00 11.59           C  
ATOM    156  O   ILE A  21     -19.744  24.536  50.036  1.00 13.37           O  
ATOM    157  CB  ILE A  21     -19.705  26.140  52.981  1.00  9.60           C  
ATOM    158  CG1 ILE A  21     -18.644  26.524  54.017  1.00 10.46           C  
ATOM    159  CG2 ILE A  21     -20.161  24.704  53.196  1.00 10.09           C  
ATOM    160  CD1 ILE A  21     -19.166  26.661  55.444  1.00 10.74           C  
ATOM    161  N   GLU A  22     -21.236  26.196  50.313  1.00 12.63           N  
ATOM    162  CA  GLU A  22     -22.227  25.614  49.412  1.00 13.35           C  
ATOM    163  C   GLU A  22     -21.703  25.412  47.994  1.00 13.80           C  
ATOM    164  O   GLU A  22     -21.804  24.319  47.436  1.00 12.84           O  
ATOM    165  CB  GLU A  22     -23.480  26.498  49.343  1.00 16.10           C  
ATOM    166  CG  GLU A  22     -24.206  26.672  50.662  1.00 21.81           C  
ATOM    167  CD  GLU A  22     -25.380  27.640  50.569  1.00 24.77           C  
ATOM    168  OE1 GLU A  22     -26.080  27.822  51.588  1.00 29.12           O  
ATOM    169  OE2 GLU A  22     -25.599  28.217  49.482  1.00 27.02           O  
ATOM    170  N   THR A  23     -21.146  26.466  47.409  1.00 12.13           N  
ATOM    171  CA  THR A  23     -20.646  26.367  46.043  1.00 11.85           C  
ATOM    172  C   THR A  23     -19.444  25.437  45.910  1.00 12.24           C  
ATOM    173  O   THR A  23     -19.331  24.707  44.920  1.00 13.67           O  
ATOM    174  CB  THR A  23     -20.312  27.767  45.469  1.00  8.37           C  
ATOM    175  OG1 THR A  23     -19.324  28.409  46.277  1.00  8.77           O  
ATOM    176  CG2 THR A  23     -21.579  28.628  45.425  1.00 11.44           C  
ATOM    177  N   PHE A  24     -18.557  25.440  46.899  1.00 11.47           N  
ATOM    178  CA  PHE A  24     -17.392  24.564  46.837  1.00 13.53           C  
ATOM    179  C   PHE A  24     -17.809  23.106  46.994  1.00 14.65           C  
ATOM    180  O   PHE A  24     -17.346  22.235  46.255  1.00 14.89           O  
ATOM    181  CB  PHE A  24     -16.371  24.913  47.921  1.00 13.17           C  
ATOM    182  CG  PHE A  24     -15.083  24.148  47.797  1.00 16.83           C  
ATOM    183  CD1 PHE A  24     -14.959  22.867  48.326  1.00 17.89           C  
ATOM    184  CD2 PHE A  24     -14.009  24.692  47.106  1.00 17.30           C  
ATOM    185  CE1 PHE A  24     -13.780  22.143  48.164  1.00 19.82           C  
ATOM    186  CE2 PHE A  24     -12.828  23.977  46.940  1.00 19.18           C  
ATOM    187  CZ  PHE A  24     -12.712  22.702  47.468  1.00 18.83           C  
ATOM    188  N   ASN A  25     -18.676  22.841  47.965  1.00 15.95           N  
ATOM    189  CA  ASN A  25     -19.145  21.481  48.190  1.00 18.98           C  
ATOM    190  C   ASN A  25     -19.767  20.933  46.910  1.00 21.45           C  
ATOM    191  O   ASN A  25     -19.451  19.830  46.465  1.00 21.95           O  
ATOM    192  CB  ASN A  25     -20.187  21.451  49.304  1.00 18.93           C  
ATOM    193  CG  ASN A  25     -20.609  20.042  49.663  1.00 21.96           C  
ATOM    194  OD1 ASN A  25     -21.800  19.746  49.765  1.00 24.28           O  
ATOM    195  ND2 ASN A  25     -19.632  19.164  49.863  1.00 19.84           N  
ATOM    196  N   ASP A  26     -20.649  21.722  46.315  1.00 23.56           N  
ATOM    197  CA  ASP A  26     -21.330  21.310  45.100  1.00 26.84           C  
ATOM    198  C   ASP A  26     -20.411  21.200  43.882  1.00 26.50           C  
ATOM    199  O   ASP A  26     -20.856  20.829  42.797  1.00 29.60           O  
ATOM    200  CB  ASP A  26     -22.473  22.281  44.810  1.00 29.64           C  
ATOM    201  CG  ASP A  26     -23.361  21.813  43.685  1.00 32.58           C  
ATOM    202  OD1 ASP A  26     -23.907  20.690  43.789  1.00 33.66           O  
ATOM    203  OD2 ASP A  26     -23.511  22.565  42.701  1.00 33.73           O  
ATOM    204  N   THR A  27     -19.130  21.503  44.060  1.00 25.03           N  
ATOM    205  CA  THR A  27     -18.186  21.432  42.952  1.00 23.60           C  
ATOM    206  C   THR A  27     -17.193  20.265  43.051  1.00 24.15           C  
ATOM    207  O   THR A  27     -16.781  19.724  42.028  1.00 24.60           O  
ATOM    208  CB  THR A  27     -17.402  22.765  42.810  1.00 24.42           C  
ATOM    209  OG1 THR A  27     -18.324  23.835  42.557  1.00 22.83           O  
ATOM    210  CG2 THR A  27     -16.404  22.690  41.661  1.00 21.63           C  
ATOM    211  N   PHE A  28     -16.812  19.883  44.269  1.00 22.13           N  
ATOM    212  CA  PHE A  28     -15.862  18.790  44.466  1.00 22.97           C  
ATOM    213  C   PHE A  28     -16.438  17.632  45.282  1.00 23.61           C  
ATOM    214  O   PHE A  28     -15.710  16.708  45.657  1.00 26.80           O  
ATOM    215  CB  PHE A  28     -14.604  19.296  45.176  1.00 22.70           C  
ATOM    216  CG  PHE A  28     -13.874  20.375  44.432  1.00 21.25           C  
ATOM    217  CD1 PHE A  28     -14.300  21.699  44.500  1.00 21.29           C  
ATOM    218  CD2 PHE A  28     -12.752  20.070  43.669  1.00 19.68           C  
ATOM    219  CE1 PHE A  28     -13.615  22.707  43.818  1.00 23.00           C  
ATOM    220  CE2 PHE A  28     -12.060  21.065  42.984  1.00 20.57           C  
ATOM    221  CZ  PHE A  28     -12.491  22.387  43.058  1.00 19.49           C  
ATOM    222  N   LYS A  29     -17.740  17.691  45.548  1.00 24.69           N  
ATOM    223  CA  LYS A  29     -18.452  16.683  46.340  1.00 27.83           C  
ATOM    224  C   LYS A  29     -18.418  15.276  45.768  1.00 28.05           C  
ATOM    225  O   LYS A  29     -18.283  14.298  46.504  1.00 28.86           O  
ATOM    226  CB  LYS A  29     -19.916  17.102  46.503  1.00 28.16           C  
ATOM    227  CG  LYS A  29     -20.796  16.077  47.194  1.00 32.39           C  
ATOM    228  CD  LYS A  29     -22.229  16.580  47.333  1.00 32.47           C  
ATOM    229  CE  LYS A  29     -22.870  16.811  45.976  1.00 34.10           C  
ATOM    230  NZ  LYS A  29     -24.227  17.410  46.098  1.00 34.58           N  
ATOM    231  N   GLU A  30     -18.553  15.182  44.452  1.00 28.66           N  
ATOM    232  CA  GLU A  30     -18.585  13.893  43.779  1.00 30.84           C  
ATOM    233  C   GLU A  30     -17.257  13.147  43.725  1.00 30.59           C  
ATOM    234  O   GLU A  30     -17.235  11.914  43.757  1.00 29.86           O  
ATOM    235  CB  GLU A  30     -19.118  14.073  42.357  1.00 33.19           C  
ATOM    236  CG  GLU A  30     -19.748  12.819  41.791  1.00 38.11           C  
ATOM    237  CD  GLU A  30     -21.051  12.476  42.487  1.00 40.98           C  
ATOM    238  OE1 GLU A  30     -21.490  11.309  42.392  1.00 42.71           O  
ATOM    239  OE2 GLU A  30     -21.643  13.379  43.120  1.00 41.62           O  
ATOM    240  N   GLN A  31     -16.150  13.879  43.649  1.00 30.20           N  
ATOM    241  CA  GLN A  31     -14.834  13.249  43.556  1.00 30.18           C  
ATOM    242  C   GLN A  31     -14.035  13.242  44.855  1.00 28.15           C  
ATOM    243  O   GLN A  31     -12.818  13.080  44.828  1.00 29.84           O  
ATOM    244  CB  GLN A  31     -14.010  13.942  42.466  1.00 33.17           C  
ATOM    245  CG  GLN A  31     -13.459  13.022  41.383  1.00 37.17           C  
ATOM    246  CD  GLN A  31     -12.364  12.096  41.884  1.00 39.52           C  
ATOM    247  OE1 GLN A  31     -12.621  11.152  42.639  1.00 40.24           O  
ATOM    248  NE2 GLN A  31     -11.130  12.365  41.465  1.00 39.74           N  
ATOM    249  N   ASN A  32     -14.708  13.394  45.991  1.00 25.52           N  
ATOM    250  CA  ASN A  32     -14.016  13.413  47.276  1.00 22.70           C  
ATOM    251  C   ASN A  32     -14.809  12.742  48.388  1.00 20.91           C  
ATOM    252  O   ASN A  32     -16.036  12.712  48.345  1.00 18.71           O  
ATOM    253  CB  ASN A  32     -13.709  14.858  47.659  1.00 23.62           C  
ATOM    254  CG  ASN A  32     -12.598  15.450  46.824  1.00 25.45           C  
ATOM    255  OD1 ASN A  32     -11.424  15.132  47.021  1.00 25.01           O  
ATOM    256  ND2 ASN A  32     -12.961  16.303  45.869  1.00 26.52           N  
ATOM    257  N   SER A  33     -14.114  12.208  49.388  1.00 18.36           N  
ATOM    258  CA  SER A  33     -14.811  11.551  50.491  1.00 17.32           C  
ATOM    259  C   SER A  33     -15.429  12.600  51.411  1.00 16.21           C  
ATOM    260  O   SER A  33     -14.895  13.695  51.562  1.00 17.71           O  
ATOM    261  CB  SER A  33     -13.859  10.649  51.286  1.00 14.93           C  
ATOM    262  OG  SER A  33     -12.969  11.397  52.102  1.00 14.59           O  
ATOM    263  N   PRO A  34     -16.580  12.281  52.022  1.00 17.38           N  
ATOM    264  CA  PRO A  34     -17.253  13.217  52.930  1.00 15.94           C  
ATOM    265  C   PRO A  34     -16.316  13.663  54.045  1.00 14.67           C  
ATOM    266  O   PRO A  34     -16.379  14.801  54.510  1.00 13.21           O  
ATOM    267  CB  PRO A  34     -18.421  12.394  53.465  1.00 17.47           C  
ATOM    268  CG  PRO A  34     -18.762  11.524  52.303  1.00 19.10           C  
ATOM    269  CD  PRO A  34     -17.403  11.076  51.812  1.00 16.37           C  
ATOM    270  N   GLU A  35     -15.451  12.747  54.473  1.00 13.33           N  
ATOM    271  CA  GLU A  35     -14.492  13.016  55.537  1.00 13.44           C  
ATOM    272  C   GLU A  35     -13.461  14.058  55.109  1.00 14.73           C  
ATOM    273  O   GLU A  35     -13.105  14.961  55.883  1.00 15.97           O  
ATOM    274  CB  GLU A  35     -13.778  11.719  55.934  1.00 11.98           C  
ATOM    275  CG  GLU A  35     -14.646  10.670  56.654  1.00  9.25           C  
ATOM    276  CD  GLU A  35     -15.798  10.128  55.819  1.00 10.05           C  
ATOM    277  OE1 GLU A  35     -15.629   9.910  54.596  1.00 10.00           O  
ATOM    278  OE2 GLU A  35     -16.882   9.893  56.397  1.00 11.59           O  
ATOM    279  N   ASN A  36     -12.964  13.918  53.885  1.00 15.62           N  
ATOM    280  CA  ASN A  36     -11.982  14.865  53.357  1.00 16.77           C  
ATOM    281  C   ASN A  36     -12.660  16.215  53.105  1.00 16.79           C  
ATOM    282  O   ASN A  36     -12.067  17.268  53.350  1.00 17.16           O  
ATOM    283  CB  ASN A  36     -11.365  14.340  52.052  1.00 16.75           C  
ATOM    284  CG  ASN A  36     -10.267  13.301  52.287  1.00 18.65           C  
ATOM    285  OD1 ASN A  36      -9.668  12.796  51.334  1.00 19.32           O  
ATOM    286  ND2 ASN A  36     -10.003  12.981  53.550  1.00 15.78           N  
HETATM  287  N   MSE A  37     -13.899  16.188  52.619  1.00 16.93           N  
HETATM  288  CA  MSE A  37     -14.626  17.428  52.354  1.00 18.31           C  
HETATM  289  C   MSE A  37     -14.904  18.199  53.643  1.00 18.31           C  
HETATM  290  O   MSE A  37     -14.737  19.418  53.694  1.00 18.50           O  
HETATM  291  CB  MSE A  37     -15.950  17.143  51.643  1.00 18.51           C  
HETATM  292  CG  MSE A  37     -16.813  18.381  51.413  1.00 23.16           C  
HETATM  293 SE   MSE A  37     -15.976  19.646  50.195  1.00 29.97          SE  
HETATM  294  CE  MSE A  37     -15.715  18.452  48.697  1.00 25.68           C  
ATOM    295  N   LYS A  38     -15.325  17.490  54.685  1.00 17.64           N  
ATOM    296  CA  LYS A  38     -15.618  18.126  55.964  1.00 16.84           C  
ATOM    297  C   LYS A  38     -14.374  18.814  56.516  1.00 16.23           C  
ATOM    298  O   LYS A  38     -14.430  19.962  56.964  1.00 13.50           O  
ATOM    299  CB  LYS A  38     -16.122  17.082  56.965  1.00 18.43           C  
ATOM    300  CG  LYS A  38     -16.691  17.664  58.246  1.00 23.36           C  
ATOM    301  CD  LYS A  38     -17.345  16.574  59.082  1.00 26.48           C  
ATOM    302  CE  LYS A  38     -18.149  17.161  60.229  1.00 30.93           C  
ATOM    303  NZ  LYS A  38     -17.291  17.923  61.178  1.00 31.88           N  
ATOM    304  N   ALA A  39     -13.248  18.109  56.474  1.00 15.65           N  
ATOM    305  CA  ALA A  39     -11.989  18.651  56.978  1.00 16.95           C  
ATOM    306  C   ALA A  39     -11.545  19.898  56.210  1.00 17.60           C  
ATOM    307  O   ALA A  39     -11.138  20.893  56.810  1.00 17.21           O  
ATOM    308  CB  ALA A  39     -10.900  17.583  56.915  1.00 15.84           C  
ATOM    309  N   TYR A  40     -11.620  19.845  54.885  1.00 17.61           N  
ATOM    310  CA  TYR A  40     -11.211  20.982  54.070  1.00 17.62           C  
ATOM    311  C   TYR A  40     -12.120  22.195  54.274  1.00 18.07           C  
ATOM    312  O   TYR A  40     -11.645  23.322  54.428  1.00 17.43           O  
ATOM    313  CB  TYR A  40     -11.193  20.598  52.586  1.00 19.23           C  
ATOM    314  CG  TYR A  40     -10.899  21.777  51.688  1.00 20.30           C  
ATOM    315  CD1 TYR A  40     -11.931  22.556  51.171  1.00 20.30           C  
ATOM    316  CD2 TYR A  40      -9.586  22.161  51.422  1.00 21.56           C  
ATOM    317  CE1 TYR A  40     -11.664  23.689  50.413  1.00 20.44           C  
ATOM    318  CE2 TYR A  40      -9.307  23.294  50.666  1.00 21.33           C  
ATOM    319  CZ  TYR A  40     -10.352  24.054  50.166  1.00 21.37           C  
ATOM    320  OH  TYR A  40     -10.083  25.181  49.424  1.00 20.90           O  
ATOM    321  N   LEU A  41     -13.428  21.958  54.255  1.00 16.72           N  
ATOM    322  CA  LEU A  41     -14.399  23.026  54.453  1.00 16.75           C  
ATOM    323  C   LEU A  41     -14.130  23.768  55.762  1.00 17.85           C  
ATOM    324  O   LEU A  41     -14.225  24.999  55.825  1.00 16.20           O  
ATOM    325  CB  LEU A  41     -15.820  22.444  54.448  1.00 18.80           C  
ATOM    326  CG  LEU A  41     -16.679  22.608  53.184  1.00 20.14           C  
ATOM    327  CD1 LEU A  41     -15.819  22.634  51.936  1.00 22.47           C  
ATOM    328  CD2 LEU A  41     -17.705  21.489  53.123  1.00 19.42           C  
ATOM    329  N   GLU A  42     -13.779  23.019  56.804  1.00 17.06           N  
ATOM    330  CA  GLU A  42     -13.497  23.621  58.101  1.00 19.52           C  
ATOM    331  C   GLU A  42     -12.167  24.380  58.131  1.00 18.22           C  
ATOM    332  O   GLU A  42     -12.028  25.368  58.852  1.00 19.10           O  
ATOM    333  CB  GLU A  42     -13.519  22.544  59.198  1.00 22.13           C  
ATOM    334  CG  GLU A  42     -14.917  21.980  59.458  1.00 28.42           C  
ATOM    335  CD  GLU A  42     -14.945  20.859  60.490  1.00 32.02           C  
ATOM    336  OE1 GLU A  42     -16.057  20.470  60.908  1.00 33.44           O  
ATOM    337  OE2 GLU A  42     -13.864  20.364  60.879  1.00 34.56           O  
ATOM    338  N   SER A  43     -11.196  23.937  57.341  1.00 18.92           N  
ATOM    339  CA  SER A  43      -9.896  24.601  57.329  1.00 19.65           C  
ATOM    340  C   SER A  43      -9.808  25.736  56.310  1.00 18.63           C  
ATOM    341  O   SER A  43      -8.986  26.642  56.447  1.00 20.59           O  
ATOM    342  CB  SER A  43      -8.783  23.588  57.052  1.00 22.56           C  
ATOM    343  OG  SER A  43      -8.914  23.041  55.752  1.00 25.74           O  
ATOM    344  N   ALA A  44     -10.659  25.697  55.295  1.00 15.58           N  
ATOM    345  CA  ALA A  44     -10.632  26.728  54.269  1.00 12.60           C  
ATOM    346  C   ALA A  44     -11.647  27.837  54.488  1.00 12.07           C  
ATOM    347  O   ALA A  44     -11.382  29.002  54.186  1.00 10.63           O  
ATOM    348  CB  ALA A  44     -10.860  26.099  52.906  1.00 14.82           C  
ATOM    349  N   PHE A  45     -12.803  27.488  55.032  1.00  9.50           N  
ATOM    350  CA  PHE A  45     -13.849  28.484  55.199  1.00 10.49           C  
ATOM    351  C   PHE A  45     -14.268  28.803  56.630  1.00 12.45           C  
ATOM    352  O   PHE A  45     -15.354  29.342  56.858  1.00 11.43           O  
ATOM    353  CB  PHE A  45     -15.058  28.054  54.365  1.00 10.28           C  
ATOM    354  CG  PHE A  45     -14.718  27.741  52.925  1.00 12.07           C  
ATOM    355  CD1 PHE A  45     -14.014  28.660  52.147  1.00 12.87           C  
ATOM    356  CD2 PHE A  45     -15.125  26.548  52.338  1.00 13.71           C  
ATOM    357  CE1 PHE A  45     -13.727  28.394  50.801  1.00 11.94           C  
ATOM    358  CE2 PHE A  45     -14.844  26.271  50.996  1.00 13.02           C  
ATOM    359  CZ  PHE A  45     -14.145  27.197  50.227  1.00 11.03           C  
ATOM    360  N   ASN A  46     -13.418  28.479  57.600  1.00 12.38           N  
ATOM    361  CA  ASN A  46     -13.761  28.794  58.970  1.00 13.43           C  
ATOM    362  C   ASN A  46     -13.702  30.317  59.087  1.00 14.74           C  
ATOM    363  O   ASN A  46     -13.044  30.993  58.285  1.00 13.61           O  
ATOM    364  CB  ASN A  46     -12.797  28.106  59.953  1.00 15.17           C  
ATOM    365  CG  ASN A  46     -11.373  28.583  59.818  1.00 13.74           C  
ATOM    366  OD1 ASN A  46     -11.055  29.716  60.155  1.00 15.80           O  
ATOM    367  ND2 ASN A  46     -10.502  27.714  59.320  1.00 13.59           N  
ATOM    368  N   THR A  47     -14.415  30.847  60.069  1.00 14.19           N  
ATOM    369  CA  THR A  47     -14.501  32.283  60.317  1.00 17.44           C  
ATOM    370  C   THR A  47     -13.169  33.021  60.319  1.00 16.14           C  
ATOM    371  O   THR A  47     -13.032  34.077  59.703  1.00 14.88           O  
ATOM    372  CB  THR A  47     -15.191  32.545  61.673  1.00 18.32           C  
ATOM    373  OG1 THR A  47     -16.444  31.851  61.709  1.00 23.64           O  
ATOM    374  CG2 THR A  47     -15.440  34.032  61.863  1.00 23.12           C  
ATOM    375  N   GLU A  48     -12.191  32.455  61.015  1.00 14.62           N  
ATOM    376  CA  GLU A  48     -10.882  33.071  61.136  1.00 16.69           C  
ATOM    377  C   GLU A  48     -10.109  33.139  59.825  1.00 14.28           C  
ATOM    378  O   GLU A  48      -9.486  34.156  59.516  1.00 14.22           O  
ATOM    379  CB  GLU A  48     -10.051  32.318  62.180  1.00 17.11           C  
ATOM    380  CG  GLU A  48      -8.847  33.096  62.659  1.00 23.11           C  
ATOM    381  CD  GLU A  48      -9.235  34.292  63.514  1.00 25.39           C  
ATOM    382  OE1 GLU A  48      -8.373  35.163  63.738  1.00 27.08           O  
ATOM    383  OE2 GLU A  48     -10.402  34.356  63.967  1.00 29.24           O  
ATOM    384  N   GLN A  49     -10.144  32.059  59.057  1.00 13.51           N  
ATOM    385  CA  GLN A  49      -9.431  32.022  57.786  1.00 13.94           C  
ATOM    386  C   GLN A  49     -10.001  33.075  56.833  1.00 13.77           C  
ATOM    387  O   GLN A  49      -9.260  33.900  56.295  1.00 13.26           O  
ATOM    388  CB  GLN A  49      -9.538  30.618  57.175  1.00 14.67           C  
ATOM    389  CG  GLN A  49      -8.778  30.408  55.873  1.00 15.62           C  
ATOM    390  CD  GLN A  49      -7.304  30.748  55.977  1.00 17.47           C  
ATOM    391  OE1 GLN A  49      -6.626  30.363  56.933  1.00 19.56           O  
ATOM    392  NE2 GLN A  49      -6.794  31.461  54.981  1.00 17.58           N  
ATOM    393  N   LEU A  50     -11.315  33.063  56.636  1.00 13.72           N  
ATOM    394  CA  LEU A  50     -11.944  34.026  55.734  1.00 14.72           C  
ATOM    395  C   LEU A  50     -11.790  35.464  56.226  1.00 15.05           C  
ATOM    396  O   LEU A  50     -11.658  36.391  55.428  1.00 13.34           O  
ATOM    397  CB  LEU A  50     -13.427  33.674  55.522  1.00 16.74           C  
ATOM    398  CG  LEU A  50     -13.681  32.416  54.672  1.00 17.90           C  
ATOM    399  CD1 LEU A  50     -15.177  32.135  54.563  1.00 17.94           C  
ATOM    400  CD2 LEU A  50     -13.086  32.612  53.284  1.00 18.73           C  
ATOM    401  N   GLU A  51     -11.788  35.654  57.540  1.00 16.47           N  
ATOM    402  CA  GLU A  51     -11.621  36.990  58.097  1.00 18.40           C  
ATOM    403  C   GLU A  51     -10.234  37.507  57.699  1.00 18.35           C  
ATOM    404  O   GLU A  51     -10.075  38.675  57.331  1.00 17.46           O  
ATOM    405  CB  GLU A  51     -11.757  36.947  59.621  1.00 22.74           C  
ATOM    406  CG  GLU A  51     -11.936  38.307  60.260  1.00 27.19           C  
ATOM    407  CD  GLU A  51     -12.141  38.231  61.762  1.00 31.99           C  
ATOM    408  OE1 GLU A  51     -12.255  39.300  62.390  1.00 34.59           O  
ATOM    409  OE2 GLU A  51     -12.190  37.108  62.315  1.00 34.99           O  
ATOM    410  N   LYS A  52      -9.236  36.626  57.751  1.00 17.68           N  
ATOM    411  CA  LYS A  52      -7.870  36.991  57.380  1.00 18.68           C  
ATOM    412  C   LYS A  52      -7.802  37.360  55.901  1.00 17.11           C  
ATOM    413  O   LYS A  52      -7.239  38.391  55.532  1.00 17.10           O  
ATOM    414  CB  LYS A  52      -6.912  35.829  57.668  1.00 20.11           C  
ATOM    415  CG  LYS A  52      -5.470  36.107  57.279  1.00 24.55           C  
ATOM    416  CD  LYS A  52      -4.589  34.888  57.505  1.00 28.71           C  
ATOM    417  CE  LYS A  52      -3.147  35.175  57.094  1.00 31.74           C  
ATOM    418  NZ  LYS A  52      -2.293  33.962  57.195  1.00 32.69           N  
ATOM    419  N   GLU A  53      -8.376  36.511  55.056  1.00 14.84           N  
ATOM    420  CA  GLU A  53      -8.386  36.751  53.615  1.00 13.70           C  
ATOM    421  C   GLU A  53      -9.112  38.042  53.262  1.00 14.33           C  
ATOM    422  O   GLU A  53      -8.663  38.789  52.396  1.00 14.28           O  
ATOM    423  CB  GLU A  53      -9.029  35.562  52.907  1.00 11.34           C  
ATOM    424  CG  GLU A  53      -8.268  34.278  53.176  1.00 12.59           C  
ATOM    425  CD  GLU A  53      -8.749  33.118  52.351  1.00 14.59           C  
ATOM    426  OE1 GLU A  53      -9.510  33.345  51.382  1.00 13.56           O  
ATOM    427  OE2 GLU A  53      -8.345  31.979  52.664  1.00 15.25           O  
ATOM    428  N   LEU A  54     -10.229  38.309  53.931  1.00 15.02           N  
ATOM    429  CA  LEU A  54     -10.976  39.532  53.668  1.00 18.01           C  
ATOM    430  C   LEU A  54     -10.167  40.770  54.055  1.00 19.65           C  
ATOM    431  O   LEU A  54     -10.314  41.829  53.446  1.00 19.08           O  
ATOM    432  CB  LEU A  54     -12.297  39.531  54.433  1.00 19.19           C  
ATOM    433  CG  LEU A  54     -13.462  38.792  53.782  1.00 19.67           C  
ATOM    434  CD1 LEU A  54     -14.590  38.666  54.789  1.00 21.61           C  
ATOM    435  CD2 LEU A  54     -13.933  39.552  52.539  1.00 19.68           C  
ATOM    436  N   SER A  55      -9.316  40.627  55.066  1.00 19.87           N  
ATOM    437  CA  SER A  55      -8.481  41.721  55.545  1.00 21.32           C  
ATOM    438  C   SER A  55      -7.159  41.863  54.795  1.00 22.01           C  
ATOM    439  O   SER A  55      -6.405  42.809  55.039  1.00 24.29           O  
ATOM    440  CB  SER A  55      -8.179  41.546  57.041  1.00 22.28           C  
ATOM    441  OG  SER A  55      -9.331  41.775  57.831  1.00 26.25           O  
ATOM    442  N   ASN A  56      -6.868  40.925  53.897  1.00 21.58           N  
ATOM    443  CA  ASN A  56      -5.626  40.968  53.129  1.00 20.46           C  
ATOM    444  C   ASN A  56      -5.686  42.097  52.107  1.00 21.10           C  
ATOM    445  O   ASN A  56      -6.585  42.136  51.268  1.00 19.28           O  
ATOM    446  CB  ASN A  56      -5.398  39.638  52.402  1.00 21.92           C  
ATOM    447  CG  ASN A  56      -3.983  39.502  51.861  1.00 21.78           C  
ATOM    448  OD1 ASN A  56      -3.418  40.455  51.312  1.00 21.92           O  
ATOM    449  ND2 ASN A  56      -3.406  38.315  52.003  1.00 24.34           N  
HETATM  450  N   MSE A  57      -4.720  43.010  52.180  1.00 20.48           N  
HETATM  451  CA  MSE A  57      -4.662  44.149  51.266  1.00 21.14           C  
HETATM  452  C   MSE A  57      -4.535  43.744  49.800  1.00 18.96           C  
HETATM  453  O   MSE A  57      -4.951  44.480  48.911  1.00 21.86           O  
HETATM  454  CB  MSE A  57      -3.472  45.043  51.623  1.00 22.18           C  
HETATM  455  CG  MSE A  57      -3.534  45.642  53.013  1.00 23.87           C  
HETATM  456 SE   MSE A  57      -2.071  46.882  53.241  1.00 33.98          SE  
HETATM  457  CE  MSE A  57      -2.369  47.890  51.679  1.00  9.66           C  
ATOM    458  N   SER A  58      -3.960  42.573  49.556  1.00 18.08           N  
ATOM    459  CA  SER A  58      -3.738  42.104  48.194  1.00 18.30           C  
ATOM    460  C   SER A  58      -4.791  41.142  47.659  1.00 18.30           C  
ATOM    461  O   SER A  58      -4.605  40.524  46.608  1.00 15.80           O  
ATOM    462  CB  SER A  58      -2.355  41.470  48.114  1.00 17.67           C  
ATOM    463  OG  SER A  58      -1.396  42.355  48.674  1.00 20.00           O  
ATOM    464  N   SER A  59      -5.894  41.030  48.391  1.00 17.48           N  
ATOM    465  CA  SER A  59      -7.008  40.168  48.015  1.00 17.12           C  
ATOM    466  C   SER A  59      -8.279  40.993  47.993  1.00 18.12           C  
ATOM    467  O   SER A  59      -8.409  41.978  48.722  1.00 16.82           O  
ATOM    468  CB  SER A  59      -7.177  39.020  49.013  1.00 14.33           C  
ATOM    469  OG  SER A  59      -6.170  38.044  48.851  1.00 12.80           O  
ATOM    470  N   GLN A  60      -9.222  40.578  47.158  1.00 17.00           N  
ATOM    471  CA  GLN A  60     -10.479  41.281  47.049  1.00 15.69           C  
ATOM    472  C   GLN A  60     -11.580  40.295  46.668  1.00 14.48           C  
ATOM    473  O   GLN A  60     -11.405  39.452  45.782  1.00 12.37           O  
ATOM    474  CB  GLN A  60     -10.334  42.387  46.008  1.00 19.16           C  
ATOM    475  CG  GLN A  60     -11.316  43.512  46.120  1.00 20.53           C  
ATOM    476  CD  GLN A  60     -10.824  44.767  45.417  1.00 22.47           C  
ATOM    477  OE1 GLN A  60     -10.288  45.679  46.049  1.00 22.28           O  
ATOM    478  NE2 GLN A  60     -10.986  44.810  44.103  1.00 18.96           N  
ATOM    479  N   PHE A  61     -12.703  40.388  47.373  1.00 11.88           N  
ATOM    480  CA  PHE A  61     -13.859  39.528  47.135  1.00  9.61           C  
ATOM    481  C   PHE A  61     -15.008  40.387  46.635  1.00  9.92           C  
ATOM    482  O   PHE A  61     -15.179  41.512  47.094  1.00  9.88           O  
ATOM    483  CB  PHE A  61     -14.324  38.861  48.434  1.00  9.43           C  
ATOM    484  CG  PHE A  61     -13.424  37.770  48.942  1.00  9.86           C  
ATOM    485  CD1 PHE A  61     -13.715  36.431  48.686  1.00  9.90           C  
ATOM    486  CD2 PHE A  61     -12.329  38.077  49.743  1.00 11.26           C  
ATOM    487  CE1 PHE A  61     -12.927  35.414  49.233  1.00  7.71           C  
ATOM    488  CE2 PHE A  61     -11.536  37.067  50.292  1.00 11.61           C  
ATOM    489  CZ  PHE A  61     -11.838  35.736  50.038  1.00  8.36           C  
ATOM    490  N   PHE A  62     -15.794  39.851  45.704  1.00  9.27           N  
ATOM    491  CA  PHE A  62     -16.959  40.550  45.173  1.00  9.64           C  
ATOM    492  C   PHE A  62     -18.160  39.616  45.097  1.00  9.40           C  
ATOM    493  O   PHE A  62     -18.034  38.476  44.651  1.00  5.94           O  
ATOM    494  CB  PHE A  62     -16.700  41.082  43.760  1.00 11.84           C  
ATOM    495  CG  PHE A  62     -15.936  42.366  43.724  1.00 14.01           C  
ATOM    496  CD1 PHE A  62     -14.548  42.363  43.747  1.00 16.25           C  
ATOM    497  CD2 PHE A  62     -16.608  43.583  43.673  1.00 15.55           C  
ATOM    498  CE1 PHE A  62     -13.834  43.553  43.722  1.00 16.86           C  
ATOM    499  CE2 PHE A  62     -15.904  44.784  43.649  1.00 17.45           C  
ATOM    500  CZ  PHE A  62     -14.514  44.765  43.673  1.00 17.59           C  
ATOM    501  N   PHE A  63     -19.322  40.089  45.535  1.00  7.39           N  
ATOM    502  CA  PHE A  63     -20.536  39.282  45.435  1.00  9.29           C  
ATOM    503  C   PHE A  63     -21.256  39.728  44.166  1.00 10.25           C  
ATOM    504  O   PHE A  63     -21.129  40.881  43.749  1.00  9.24           O  
ATOM    505  CB  PHE A  63     -21.495  39.536  46.608  1.00 10.14           C  
ATOM    506  CG  PHE A  63     -21.126  38.837  47.885  1.00 11.06           C  
ATOM    507  CD1 PHE A  63     -20.414  37.647  47.867  1.00 12.44           C  
ATOM    508  CD2 PHE A  63     -21.529  39.363  49.111  1.00 11.25           C  
ATOM    509  CE1 PHE A  63     -20.098  36.981  49.050  1.00 12.40           C  
ATOM    510  CE2 PHE A  63     -21.217  38.701  50.310  1.00 13.65           C  
ATOM    511  CZ  PHE A  63     -20.499  37.509  50.272  1.00 11.58           C  
ATOM    512  N   ILE A  64     -21.987  38.815  43.535  1.00 10.09           N  
ATOM    513  CA  ILE A  64     -22.775  39.193  42.375  1.00  9.09           C  
ATOM    514  C   ILE A  64     -24.213  38.855  42.757  1.00  9.68           C  
ATOM    515  O   ILE A  64     -24.474  37.822  43.377  1.00  8.80           O  
ATOM    516  CB  ILE A  64     -22.351  38.448  41.077  1.00  9.83           C  
ATOM    517  CG1 ILE A  64     -23.117  39.046  39.891  1.00 10.80           C  
ATOM    518  CG2 ILE A  64     -22.609  36.946  41.195  1.00  7.10           C  
ATOM    519  CD1 ILE A  64     -22.452  38.803  38.531  1.00 11.00           C  
ATOM    520  N   TYR A  65     -25.131  39.754  42.425  1.00  9.11           N  
ATOM    521  CA  TYR A  65     -26.543  39.580  42.753  1.00 12.81           C  
ATOM    522  C   TYR A  65     -27.438  39.638  41.526  1.00 14.58           C  
ATOM    523  O   TYR A  65     -27.117  40.293  40.537  1.00 14.41           O  
ATOM    524  CB  TYR A  65     -27.030  40.687  43.690  1.00 13.61           C  
ATOM    525  CG  TYR A  65     -26.351  40.792  45.031  1.00 16.95           C  
ATOM    526  CD1 TYR A  65     -25.099  41.397  45.165  1.00 16.33           C  
ATOM    527  CD2 TYR A  65     -26.981  40.315  46.182  1.00 18.83           C  
ATOM    528  CE1 TYR A  65     -24.496  41.526  46.417  1.00 17.72           C  
ATOM    529  CE2 TYR A  65     -26.388  40.435  47.432  1.00 18.44           C  
ATOM    530  CZ  TYR A  65     -25.151  41.038  47.544  1.00 19.07           C  
ATOM    531  OH  TYR A  65     -24.567  41.139  48.782  1.00 21.22           O  
ATOM    532  N   PHE A  66     -28.576  38.964  41.617  1.00 16.70           N  
ATOM    533  CA  PHE A  66     -29.565  38.963  40.554  1.00 20.38           C  
ATOM    534  C   PHE A  66     -30.904  39.163  41.256  1.00 21.33           C  
ATOM    535  O   PHE A  66     -31.340  38.309  42.029  1.00 17.97           O  
ATOM    536  CB  PHE A  66     -29.551  37.635  39.794  1.00 22.60           C  
ATOM    537  CG  PHE A  66     -30.704  37.471  38.844  1.00 26.40           C  
ATOM    538  CD1 PHE A  66     -30.903  38.371  37.803  1.00 28.59           C  
ATOM    539  CD2 PHE A  66     -31.606  36.427  39.007  1.00 28.38           C  
ATOM    540  CE1 PHE A  66     -31.989  38.233  36.935  1.00 29.35           C  
ATOM    541  CE2 PHE A  66     -32.692  36.277  38.151  1.00 30.19           C  
ATOM    542  CZ  PHE A  66     -32.884  37.184  37.114  1.00 29.86           C  
ATOM    543  N   ASP A  67     -31.536  40.307  41.013  1.00 23.41           N  
ATOM    544  CA  ASP A  67     -32.815  40.616  41.639  1.00 25.64           C  
ATOM    545  C   ASP A  67     -32.690  40.685  43.161  1.00 26.49           C  
ATOM    546  O   ASP A  67     -33.578  40.242  43.883  1.00 27.54           O  
ATOM    547  CB  ASP A  67     -33.852  39.568  41.234  1.00 27.57           C  
ATOM    548  CG  ASP A  67     -34.159  39.607  39.752  1.00 31.27           C  
ATOM    549  OD1 ASP A  67     -34.762  38.639  39.233  1.00 33.89           O  
ATOM    550  OD2 ASP A  67     -33.800  40.614  39.101  1.00 30.13           O  
ATOM    551  N   HIS A  68     -31.575  41.249  43.628  1.00 26.45           N  
ATOM    552  CA  HIS A  68     -31.294  41.413  45.056  1.00 26.13           C  
ATOM    553  C   HIS A  68     -30.925  40.116  45.769  1.00 24.84           C  
ATOM    554  O   HIS A  68     -30.741  40.103  46.986  1.00 24.58           O  
ATOM    555  CB  HIS A  68     -32.492  42.069  45.757  1.00 29.52           C  
ATOM    556  CG  HIS A  68     -32.850  43.414  45.205  1.00 30.98           C  
ATOM    557  ND1 HIS A  68     -32.023  44.512  45.319  1.00 33.36           N  
ATOM    558  CD2 HIS A  68     -33.936  43.833  44.513  1.00 31.92           C  
ATOM    559  CE1 HIS A  68     -32.582  45.547  44.721  1.00 31.98           C  
ATOM    560  NE2 HIS A  68     -33.744  45.163  44.223  1.00 32.42           N  
ATOM    561  N   GLU A  69     -30.814  39.027  45.014  1.00 22.74           N  
ATOM    562  CA  GLU A  69     -30.458  37.730  45.585  1.00 21.70           C  
ATOM    563  C   GLU A  69     -29.012  37.352  45.272  1.00 19.24           C  
ATOM    564  O   GLU A  69     -28.573  37.470  44.131  1.00 18.20           O  
ATOM    565  CB  GLU A  69     -31.392  36.644  45.054  1.00 23.08           C  
ATOM    566  CG  GLU A  69     -32.731  36.571  45.774  1.00 27.41           C  
ATOM    567  CD  GLU A  69     -33.615  35.465  45.234  1.00 29.12           C  
ATOM    568  OE1 GLU A  69     -33.105  34.344  45.015  1.00 30.30           O  
ATOM    569  OE2 GLU A  69     -34.824  35.713  45.038  1.00 30.92           O  
ATOM    570  N   ILE A  70     -28.278  36.905  46.289  1.00 16.56           N  
ATOM    571  CA  ILE A  70     -26.882  36.509  46.111  1.00 15.04           C  
ATOM    572  C   ILE A  70     -26.780  35.322  45.158  1.00 13.32           C  
ATOM    573  O   ILE A  70     -27.357  34.257  45.402  1.00 14.07           O  
ATOM    574  CB  ILE A  70     -26.219  36.144  47.459  1.00 16.00           C  
ATOM    575  CG1 ILE A  70     -24.776  35.690  47.223  1.00 16.86           C  
ATOM    576  CG2 ILE A  70     -27.019  35.063  48.170  1.00 15.53           C  
ATOM    577  CD1 ILE A  70     -23.877  36.776  46.688  1.00 20.66           C  
ATOM    578  N   ALA A  71     -26.031  35.504  44.074  1.00 11.73           N  
ATOM    579  CA  ALA A  71     -25.883  34.462  43.064  1.00 10.88           C  
ATOM    580  C   ALA A  71     -24.496  33.828  42.973  1.00 10.51           C  
ATOM    581  O   ALA A  71     -24.342  32.769  42.374  1.00 10.34           O  
ATOM    582  CB  ALA A  71     -26.285  35.026  41.695  1.00  9.97           C  
ATOM    583  N   GLY A  72     -23.487  34.468  43.552  1.00  7.95           N  
ATOM    584  CA  GLY A  72     -22.151  33.905  43.489  1.00  8.30           C  
ATOM    585  C   GLY A  72     -21.090  34.901  43.896  1.00  6.60           C  
ATOM    586  O   GLY A  72     -21.405  36.000  44.343  1.00  5.65           O  
ATOM    587  N   TYR A  73     -19.825  34.526  43.766  1.00  7.56           N  
ATOM    588  CA  TYR A  73     -18.759  35.445  44.136  1.00  6.75           C  
ATOM    589  C   TYR A  73     -17.470  35.135  43.400  1.00  4.89           C  
ATOM    590  O   TYR A  73     -17.331  34.089  42.763  1.00  5.26           O  
ATOM    591  CB  TYR A  73     -18.491  35.377  45.637  1.00  3.88           C  
ATOM    592  CG  TYR A  73     -17.694  34.153  46.047  1.00  4.43           C  
ATOM    593  CD1 TYR A  73     -18.284  32.886  46.075  1.00  4.50           C  
ATOM    594  CD2 TYR A  73     -16.341  34.262  46.383  1.00  6.54           C  
ATOM    595  CE1 TYR A  73     -17.546  31.757  46.428  1.00  5.35           C  
ATOM    596  CE2 TYR A  73     -15.594  33.140  46.737  1.00  7.50           C  
ATOM    597  CZ  TYR A  73     -16.206  31.890  46.759  1.00  4.94           C  
ATOM    598  OH  TYR A  73     -15.467  30.787  47.126  1.00  7.53           O  
ATOM    599  N   VAL A  74     -16.529  36.064  43.507  1.00  6.83           N  
ATOM    600  CA  VAL A  74     -15.220  35.912  42.899  1.00  5.63           C  
ATOM    601  C   VAL A  74     -14.197  36.445  43.902  1.00  7.78           C  
ATOM    602  O   VAL A  74     -14.475  37.385  44.656  1.00  7.68           O  
ATOM    603  CB  VAL A  74     -15.116  36.711  41.563  1.00  6.53           C  
ATOM    604  CG1 VAL A  74     -15.225  38.214  41.824  1.00  6.01           C  
ATOM    605  CG2 VAL A  74     -13.810  36.386  40.851  1.00  6.92           C  
ATOM    606  N   LYS A  75     -13.028  35.813  43.940  1.00  5.92           N  
ATOM    607  CA  LYS A  75     -11.942  36.265  44.803  1.00  6.11           C  
ATOM    608  C   LYS A  75     -10.724  36.438  43.918  1.00  7.22           C  
ATOM    609  O   LYS A  75     -10.333  35.508  43.207  1.00  7.39           O  
ATOM    610  CB  LYS A  75     -11.598  35.241  45.895  1.00  8.27           C  
ATOM    611  CG  LYS A  75     -10.416  35.697  46.736  1.00  6.79           C  
ATOM    612  CD  LYS A  75      -9.766  34.584  47.554  1.00  7.91           C  
ATOM    613  CE  LYS A  75      -8.658  35.179  48.427  1.00  8.93           C  
ATOM    614  NZ  LYS A  75      -7.840  34.140  49.112  1.00 12.54           N  
ATOM    615  N   VAL A  76     -10.130  37.626  43.951  1.00  5.96           N  
ATOM    616  CA  VAL A  76      -8.939  37.904  43.155  1.00  8.17           C  
ATOM    617  C   VAL A  76      -7.751  38.220  44.065  1.00  7.98           C  
ATOM    618  O   VAL A  76      -7.934  38.717  45.179  1.00  9.37           O  
ATOM    619  CB  VAL A  76      -9.162  39.098  42.173  1.00  8.07           C  
ATOM    620  CG1 VAL A  76     -10.286  38.763  41.192  1.00  9.26           C  
ATOM    621  CG2 VAL A  76      -9.484  40.373  42.944  1.00  9.93           C  
ATOM    622  N   ASN A  77      -6.546  37.891  43.597  1.00  6.82           N  
ATOM    623  CA  ASN A  77      -5.302  38.143  44.330  1.00  9.54           C  
ATOM    624  C   ASN A  77      -4.289  38.832  43.433  1.00 10.05           C  
ATOM    625  O   ASN A  77      -4.256  38.610  42.223  1.00  8.91           O  
ATOM    626  CB  ASN A  77      -4.602  36.849  44.773  1.00  7.58           C  
ATOM    627  CG  ASN A  77      -5.442  35.982  45.677  1.00  9.41           C  
ATOM    628  OD1 ASN A  77      -5.543  34.765  45.465  1.00 10.37           O  
ATOM    629  ND2 ASN A  77      -6.028  36.580  46.696  1.00  8.37           N  
ATOM    630  N   ILE A  78      -3.443  39.648  44.042  1.00 10.45           N  
ATOM    631  CA  ILE A  78      -2.365  40.298  43.319  1.00 10.63           C  
ATOM    632  C   ILE A  78      -1.141  40.149  44.209  1.00 10.83           C  
ATOM    633  O   ILE A  78      -1.259  39.811  45.389  1.00 11.25           O  
ATOM    634  CB  ILE A  78      -2.610  41.801  43.059  1.00 10.18           C  
ATOM    635  CG1 ILE A  78      -2.835  42.538  44.382  1.00 12.10           C  
ATOM    636  CG2 ILE A  78      -3.765  41.983  42.084  1.00 10.77           C  
ATOM    637  CD1 ILE A  78      -2.953  44.037  44.204  1.00 13.62           C  
ATOM    638  N   ASP A  79       0.028  40.392  43.634  1.00 11.39           N  
ATOM    639  CA  ASP A  79       1.280  40.296  44.365  1.00 13.55           C  
ATOM    640  C   ASP A  79       1.423  39.036  45.220  1.00 13.01           C  
ATOM    641  O   ASP A  79       1.217  37.924  44.733  1.00 12.29           O  
ATOM    642  CB  ASP A  79       1.455  41.562  45.208  1.00 14.82           C  
ATOM    643  CG  ASP A  79       1.494  42.809  44.353  1.00 16.41           C  
ATOM    644  OD1 ASP A  79       2.356  42.878  43.450  1.00 19.53           O  
ATOM    645  OD2 ASP A  79       0.669  43.717  44.562  1.00 19.53           O  
ATOM    646  N   ASP A  80       1.780  39.209  46.491  1.00 15.97           N  
ATOM    647  CA  ASP A  80       1.990  38.085  47.411  1.00 18.61           C  
ATOM    648  C   ASP A  80       0.751  37.293  47.805  1.00 18.01           C  
ATOM    649  O   ASP A  80       0.858  36.226  48.417  1.00 18.22           O  
ATOM    650  CB  ASP A  80       2.674  38.578  48.686  1.00 23.52           C  
ATOM    651  CG  ASP A  80       4.132  38.904  48.474  1.00 28.75           C  
ATOM    652  OD1 ASP A  80       4.724  39.557  49.359  1.00 31.09           O  
ATOM    653  OD2 ASP A  80       4.688  38.498  47.430  1.00 30.60           O  
ATOM    654  N   ALA A  81      -0.424  37.810  47.474  1.00 15.94           N  
ATOM    655  CA  ALA A  81      -1.648  37.110  47.816  1.00 14.80           C  
ATOM    656  C   ALA A  81      -1.963  35.982  46.828  1.00 14.76           C  
ATOM    657  O   ALA A  81      -2.794  35.118  47.123  1.00 13.37           O  
ATOM    658  CB  ALA A  81      -2.814  38.096  47.885  1.00 13.45           C  
ATOM    659  N   GLN A  82      -1.301  35.970  45.670  1.00 14.17           N  
ATOM    660  CA  GLN A  82      -1.551  34.923  44.669  1.00 12.38           C  
ATOM    661  C   GLN A  82      -1.154  33.538  45.187  1.00 14.34           C  
ATOM    662  O   GLN A  82      -0.168  33.406  45.911  1.00 15.45           O  
ATOM    663  CB  GLN A  82      -0.795  35.235  43.371  1.00 14.88           C  
ATOM    664  CG  GLN A  82      -1.111  36.620  42.793  1.00 10.48           C  
ATOM    665  CD  GLN A  82      -0.267  36.952  41.567  1.00 12.46           C  
ATOM    666  OE1 GLN A  82      -0.602  36.580  40.444  1.00  9.51           O  
ATOM    667  NE2 GLN A  82       0.849  37.644  41.790  1.00 12.09           N  
ATOM    668  N   SER A  83      -1.914  32.508  44.810  1.00 12.10           N  
ATOM    669  CA  SER A  83      -1.641  31.142  45.278  1.00 14.76           C  
ATOM    670  C   SER A  83      -0.379  30.530  44.672  1.00 16.23           C  
ATOM    671  O   SER A  83       0.050  29.441  45.058  1.00 18.03           O  
ATOM    672  CB  SER A  83      -2.845  30.225  45.012  1.00 13.06           C  
ATOM    673  OG  SER A  83      -3.087  30.058  43.627  1.00 11.84           O  
ATOM    674  N   GLU A  84       0.195  31.241  43.710  1.00 18.74           N  
ATOM    675  CA  GLU A  84       1.431  30.839  43.042  1.00 19.70           C  
ATOM    676  C   GLU A  84       2.223  32.128  42.904  1.00 19.18           C  
ATOM    677  O   GLU A  84       1.644  33.188  42.669  1.00 16.24           O  
ATOM    678  CB  GLU A  84       1.143  30.256  41.654  1.00 19.91           C  
ATOM    679  CG  GLU A  84       0.451  28.908  41.682  1.00 24.23           C  
ATOM    680  CD  GLU A  84       1.404  27.778  42.037  1.00 27.86           C  
ATOM    681  OE1 GLU A  84       2.299  27.986  42.883  1.00 29.77           O  
ATOM    682  OE2 GLU A  84       1.251  26.681  41.470  1.00 30.72           O  
ATOM    683  N   GLU A  85       3.539  32.043  43.064  1.00 21.08           N  
ATOM    684  CA  GLU A  85       4.403  33.217  42.965  1.00 22.18           C  
ATOM    685  C   GLU A  85       4.561  33.639  41.503  1.00 21.69           C  
ATOM    686  O   GLU A  85       5.579  33.350  40.881  1.00 21.11           O  
ATOM    687  CB  GLU A  85       5.773  32.897  43.573  1.00 25.41           C  
ATOM    688  CG  GLU A  85       6.784  34.035  43.530  1.00 33.17           C  
ATOM    689  CD  GLU A  85       6.274  35.299  44.197  1.00 36.62           C  
ATOM    690  OE1 GLU A  85       5.636  35.189  45.269  1.00 39.08           O  
ATOM    691  OE2 GLU A  85       6.519  36.401  43.655  1.00 38.45           O  
HETATM  692  N   MSE A  86       3.554  34.328  40.967  1.00 19.58           N  
HETATM  693  CA  MSE A  86       3.579  34.771  39.575  1.00 20.75           C  
HETATM  694  C   MSE A  86       4.180  36.160  39.375  1.00 18.37           C  
HETATM  695  O   MSE A  86       4.454  36.565  38.246  1.00 20.16           O  
HETATM  696  CB  MSE A  86       2.167  34.728  38.979  1.00 19.50           C  
HETATM  697  CG  MSE A  86       1.554  33.332  38.960  1.00 22.69           C  
HETATM  698 SE   MSE A  86       2.617  32.066  37.954  1.00 28.18          SE  
HETATM  699  CE  MSE A  86       1.180  30.984  37.219  1.00 24.54           C  
ATOM    700  N   GLY A  87       4.372  36.901  40.459  1.00 19.12           N  
ATOM    701  CA  GLY A  87       4.963  38.222  40.325  1.00 18.09           C  
ATOM    702  C   GLY A  87       4.034  39.398  40.550  1.00 18.31           C  
ATOM    703  O   GLY A  87       2.841  39.230  40.807  1.00 17.52           O  
ATOM    704  N   ALA A  88       4.586  40.600  40.426  1.00 15.92           N  
ATOM    705  CA  ALA A  88       3.819  41.821  40.645  1.00 15.97           C  
ATOM    706  C   ALA A  88       3.186  42.408  39.391  1.00 14.47           C  
ATOM    707  O   ALA A  88       2.734  43.554  39.398  1.00 13.99           O  
ATOM    708  CB  ALA A  88       4.707  42.864  41.303  1.00 19.99           C  
ATOM    709  N   GLU A  89       3.150  41.633  38.315  1.00 11.30           N  
ATOM    710  CA  GLU A  89       2.565  42.125  37.079  1.00 12.34           C  
ATOM    711  C   GLU A  89       1.368  41.286  36.669  1.00 11.90           C  
ATOM    712  O   GLU A  89       0.903  41.370  35.536  1.00 13.14           O  
ATOM    713  CB  GLU A  89       3.621  42.114  35.969  1.00 14.65           C  
ATOM    714  CG  GLU A  89       4.809  43.027  36.267  1.00 17.03           C  
ATOM    715  CD  GLU A  89       4.425  44.499  36.298  1.00 21.86           C  
ATOM    716  OE1 GLU A  89       5.281  45.325  36.677  1.00 24.39           O  
ATOM    717  OE2 GLU A  89       3.271  44.834  35.939  1.00 22.20           O  
ATOM    718  N   SER A  90       0.861  40.483  37.597  1.00 11.62           N  
ATOM    719  CA  SER A  90      -0.270  39.620  37.296  1.00 10.03           C  
ATOM    720  C   SER A  90      -1.369  39.659  38.349  1.00 10.55           C  
ATOM    721  O   SER A  90      -1.164  40.134  39.465  1.00  9.47           O  
ATOM    722  CB  SER A  90       0.228  38.180  37.142  1.00 10.57           C  
ATOM    723  OG  SER A  90       0.868  37.751  38.327  1.00 14.05           O  
ATOM    724  N   LEU A  91      -2.550  39.174  37.973  1.00  9.35           N  
ATOM    725  CA  LEU A  91      -3.674  39.100  38.893  1.00  7.27           C  
ATOM    726  C   LEU A  91      -4.213  37.686  38.769  1.00  5.92           C  
ATOM    727  O   LEU A  91      -4.269  37.138  37.675  1.00  5.50           O  
ATOM    728  CB  LEU A  91      -4.765  40.122  38.530  1.00  6.77           C  
ATOM    729  CG  LEU A  91      -6.063  40.070  39.354  1.00  7.26           C  
ATOM    730  CD1 LEU A  91      -6.723  41.447  39.381  1.00  8.54           C  
ATOM    731  CD2 LEU A  91      -7.018  39.040  38.762  1.00  5.18           C  
ATOM    732  N   GLU A  92      -4.587  37.087  39.892  1.00  6.96           N  
ATOM    733  CA  GLU A  92      -5.123  35.737  39.879  1.00  7.11           C  
ATOM    734  C   GLU A  92      -6.611  35.705  40.224  1.00  8.58           C  
ATOM    735  O   GLU A  92      -7.066  36.440  41.101  1.00  6.52           O  
ATOM    736  CB  GLU A  92      -4.389  34.851  40.896  1.00  7.40           C  
ATOM    737  CG  GLU A  92      -4.975  33.437  41.004  1.00  8.35           C  
ATOM    738  CD  GLU A  92      -4.582  32.713  42.286  1.00  8.40           C  
ATOM    739  OE1 GLU A  92      -4.125  33.387  43.234  1.00  9.97           O  
ATOM    740  OE2 GLU A  92      -4.742  31.473  42.348  1.00 11.42           O  
ATOM    741  N   ILE A  93      -7.364  34.870  39.512  1.00  8.53           N  
ATOM    742  CA  ILE A  93      -8.771  34.670  39.827  1.00  8.99           C  
ATOM    743  C   ILE A  93      -8.628  33.362  40.600  1.00  9.80           C  
ATOM    744  O   ILE A  93      -8.493  32.297  39.998  1.00 10.72           O  
ATOM    745  CB  ILE A  93      -9.647  34.418  38.562  1.00  8.72           C  
ATOM    746  CG1 ILE A  93      -9.671  35.664  37.678  1.00  6.69           C  
ATOM    747  CG2 ILE A  93     -11.083  34.060  38.981  1.00  8.80           C  
ATOM    748  CD1 ILE A  93     -10.301  35.423  36.319  1.00  9.48           C  
ATOM    749  N   GLU A  94      -8.611  33.447  41.926  1.00  9.07           N  
ATOM    750  CA  GLU A  94      -8.435  32.263  42.755  1.00  7.62           C  
ATOM    751  C   GLU A  94      -9.715  31.456  42.898  1.00  7.26           C  
ATOM    752  O   GLU A  94      -9.688  30.220  42.871  1.00  8.00           O  
ATOM    753  CB  GLU A  94      -7.935  32.650  44.152  1.00  8.54           C  
ATOM    754  CG  GLU A  94      -7.407  31.445  44.933  1.00  9.87           C  
ATOM    755  CD  GLU A  94      -7.210  31.706  46.415  1.00 12.88           C  
ATOM    756  OE1 GLU A  94      -6.930  32.859  46.797  1.00 12.30           O  
ATOM    757  OE2 GLU A  94      -7.325  30.742  47.202  1.00 17.80           O  
ATOM    758  N   ARG A  95     -10.830  32.165  43.051  1.00  7.34           N  
ATOM    759  CA  ARG A  95     -12.138  31.543  43.209  1.00  7.70           C  
ATOM    760  C   ARG A  95     -13.190  32.280  42.395  1.00  8.36           C  
ATOM    761  O   ARG A  95     -13.180  33.503  42.321  1.00  7.14           O  
ATOM    762  CB  ARG A  95     -12.548  31.550  44.690  1.00  9.60           C  
ATOM    763  CG  ARG A  95     -11.612  30.736  45.578  1.00 11.12           C  
ATOM    764  CD  ARG A  95     -11.906  30.889  47.066  1.00 15.95           C  
ATOM    765  NE  ARG A  95     -10.714  30.542  47.839  1.00 19.62           N  
ATOM    766  CZ  ARG A  95     -10.472  30.952  49.079  1.00 19.84           C  
ATOM    767  NH1 ARG A  95     -11.345  31.727  49.704  1.00 18.24           N  
ATOM    768  NH2 ARG A  95      -9.345  30.598  49.688  1.00 21.22           N  
ATOM    769  N   ILE A  96     -14.076  31.522  41.761  1.00  8.28           N  
ATOM    770  CA  ILE A  96     -15.167  32.102  40.992  1.00  7.10           C  
ATOM    771  C   ILE A  96     -16.268  31.050  40.996  1.00  7.76           C  
ATOM    772  O   ILE A  96     -16.103  29.927  40.507  1.00  8.01           O  
ATOM    773  CB  ILE A  96     -14.730  32.526  39.546  1.00  7.97           C  
ATOM    774  CG1 ILE A  96     -15.933  33.131  38.812  1.00  7.20           C  
ATOM    775  CG2 ILE A  96     -14.110  31.348  38.797  1.00  7.20           C  
ATOM    776  CD1 ILE A  96     -15.587  33.813  37.487  1.00  8.87           C  
ATOM    777  N   TYR A  97     -17.393  31.421  41.598  1.00  6.91           N  
ATOM    778  CA  TYR A  97     -18.506  30.499  41.754  1.00  5.89           C  
ATOM    779  C   TYR A  97     -19.870  31.121  41.574  1.00  6.88           C  
ATOM    780  O   TYR A  97     -20.136  32.194  42.098  1.00  6.98           O  
ATOM    781  CB  TYR A  97     -18.474  29.909  43.162  1.00  6.38           C  
ATOM    782  CG  TYR A  97     -17.335  28.963  43.430  1.00  9.20           C  
ATOM    783  CD1 TYR A  97     -17.482  27.595  43.214  1.00  7.90           C  
ATOM    784  CD2 TYR A  97     -16.113  29.432  43.916  1.00  6.69           C  
ATOM    785  CE1 TYR A  97     -16.446  26.714  43.481  1.00  9.37           C  
ATOM    786  CE2 TYR A  97     -15.069  28.561  44.182  1.00  8.24           C  
ATOM    787  CZ  TYR A  97     -15.245  27.198  43.962  1.00  9.34           C  
ATOM    788  OH  TYR A  97     -14.218  26.339  44.240  1.00  9.70           O  
ATOM    789  N   ILE A  98     -20.736  30.425  40.847  1.00  5.87           N  
ATOM    790  CA  ILE A  98     -22.103  30.871  40.658  1.00  5.46           C  
ATOM    791  C   ILE A  98     -22.956  29.716  41.171  1.00  7.86           C  
ATOM    792  O   ILE A  98     -22.678  28.550  40.875  1.00  6.80           O  
ATOM    793  CB  ILE A  98     -22.445  31.139  39.177  1.00  5.70           C  
ATOM    794  CG1 ILE A  98     -21.580  32.280  38.629  1.00  6.56           C  
ATOM    795  CG2 ILE A  98     -23.933  31.499  39.051  1.00  6.84           C  
ATOM    796  CD1 ILE A  98     -21.915  33.652  39.212  1.00  5.72           C  
ATOM    797  N   LYS A  99     -23.968  30.037  41.974  1.00  7.88           N  
ATOM    798  CA  LYS A  99     -24.861  29.016  42.510  1.00 11.58           C  
ATOM    799  C   LYS A  99     -25.498  28.288  41.341  1.00 11.44           C  
ATOM    800  O   LYS A  99     -25.904  28.910  40.366  1.00 10.14           O  
ATOM    801  CB  LYS A  99     -25.952  29.656  43.371  1.00 12.59           C  
ATOM    802  CG  LYS A  99     -25.442  30.279  44.670  1.00 15.50           C  
ATOM    803  CD  LYS A  99     -26.575  30.914  45.477  1.00 17.68           C  
ATOM    804  CE  LYS A  99     -27.589  29.891  45.963  1.00 17.83           C  
ATOM    805  NZ  LYS A  99     -28.572  30.523  46.909  1.00 19.56           N  
ATOM    806  N   ASN A 100     -25.608  26.970  41.448  1.00 13.80           N  
ATOM    807  CA  ASN A 100     -26.175  26.170  40.374  1.00 14.93           C  
ATOM    808  C   ASN A 100     -27.422  26.752  39.701  1.00 14.70           C  
ATOM    809  O   ASN A 100     -27.480  26.842  38.471  1.00 13.00           O  
ATOM    810  CB  ASN A 100     -26.469  24.759  40.889  1.00 18.84           C  
ATOM    811  CG  ASN A 100     -27.028  23.856  39.816  1.00 22.95           C  
ATOM    812  OD1 ASN A 100     -28.237  23.786  39.618  1.00 26.19           O  
ATOM    813  ND2 ASN A 100     -26.141  23.169  39.097  1.00 26.25           N  
ATOM    814  N   SER A 101     -28.411  27.159  40.491  1.00 14.70           N  
ATOM    815  CA  SER A 101     -29.643  27.711  39.924  1.00 16.10           C  
ATOM    816  C   SER A 101     -29.458  29.037  39.182  1.00 15.76           C  
ATOM    817  O   SER A 101     -30.333  29.444  38.410  1.00 15.19           O  
ATOM    818  CB  SER A 101     -30.702  27.887  41.019  1.00 16.71           C  
ATOM    819  OG  SER A 101     -30.307  28.869  41.959  1.00 21.38           O  
ATOM    820  N   PHE A 102     -28.333  29.714  39.408  1.00 12.73           N  
ATOM    821  CA  PHE A 102     -28.088  30.992  38.726  1.00 11.08           C  
ATOM    822  C   PHE A 102     -27.103  30.887  37.558  1.00 10.18           C  
ATOM    823  O   PHE A 102     -26.795  31.892  36.914  1.00  8.19           O  
ATOM    824  CB  PHE A 102     -27.575  32.055  39.703  1.00 11.94           C  
ATOM    825  CG  PHE A 102     -28.593  32.507  40.713  1.00 13.08           C  
ATOM    826  CD1 PHE A 102     -28.703  31.873  41.943  1.00 14.98           C  
ATOM    827  CD2 PHE A 102     -29.430  33.583  40.439  1.00 14.20           C  
ATOM    828  CE1 PHE A 102     -29.634  32.305  42.896  1.00 15.37           C  
ATOM    829  CE2 PHE A 102     -30.367  34.026  41.382  1.00 16.33           C  
ATOM    830  CZ  PHE A 102     -30.464  33.384  42.611  1.00 16.39           C  
ATOM    831  N   GLN A 103     -26.618  29.680  37.284  1.00  9.48           N  
ATOM    832  CA  GLN A 103     -25.669  29.467  36.190  1.00  9.91           C  
ATOM    833  C   GLN A 103     -26.342  29.606  34.821  1.00 10.09           C  
ATOM    834  O   GLN A 103     -27.569  29.552  34.716  1.00  9.45           O  
ATOM    835  CB  GLN A 103     -25.020  28.082  36.318  1.00 11.31           C  
ATOM    836  CG  GLN A 103     -24.000  27.966  37.452  1.00 11.06           C  
ATOM    837  CD  GLN A 103     -23.523  26.540  37.679  1.00 12.53           C  
ATOM    838  OE1 GLN A 103     -23.683  25.678  36.816  1.00 11.55           O  
ATOM    839  NE2 GLN A 103     -22.921  26.289  38.843  1.00 10.75           N  
ATOM    840  N   LYS A 104     -25.528  29.795  33.784  1.00 11.58           N  
ATOM    841  CA  LYS A 104     -26.003  29.932  32.400  1.00 12.46           C  
ATOM    842  C   LYS A 104     -26.847  31.181  32.146  1.00 13.57           C  
ATOM    843  O   LYS A 104     -27.744  31.164  31.302  1.00 14.41           O  
ATOM    844  CB  LYS A 104     -26.814  28.692  31.999  1.00 12.58           C  
ATOM    845  CG  LYS A 104     -26.193  27.378  32.425  1.00 14.36           C  
ATOM    846  CD  LYS A 104     -24.817  27.165  31.821  1.00 15.06           C  
ATOM    847  CE  LYS A 104     -24.224  25.854  32.334  1.00 17.49           C  
ATOM    848  NZ  LYS A 104     -22.918  25.535  31.701  1.00 18.97           N  
ATOM    849  N   HIS A 105     -26.557  32.258  32.872  1.00 11.33           N  
ATOM    850  CA  HIS A 105     -27.286  33.512  32.711  1.00 13.16           C  
ATOM    851  C   HIS A 105     -26.358  34.709  32.563  1.00 12.28           C  
ATOM    852  O   HIS A 105     -26.786  35.855  32.708  1.00 14.21           O  
ATOM    853  CB  HIS A 105     -28.224  33.744  33.898  1.00 16.15           C  
ATOM    854  CG  HIS A 105     -29.347  32.762  33.965  1.00 20.49           C  
ATOM    855  ND1 HIS A 105     -29.397  31.745  34.895  1.00 24.01           N  
ATOM    856  CD2 HIS A 105     -30.429  32.596  33.170  1.00 21.84           C  
ATOM    857  CE1 HIS A 105     -30.459  30.994  34.668  1.00 22.35           C  
ATOM    858  NE2 HIS A 105     -31.103  31.488  33.626  1.00 23.41           N  
ATOM    859  N   GLY A 106     -25.088  34.440  32.283  1.00  9.06           N  
ATOM    860  CA  GLY A 106     -24.134  35.516  32.109  1.00  9.67           C  
ATOM    861  C   GLY A 106     -23.501  36.058  33.379  1.00  9.59           C  
ATOM    862  O   GLY A 106     -22.713  37.001  33.311  1.00  8.82           O  
ATOM    863  N   LEU A 107     -23.818  35.478  34.535  1.00  8.99           N  
ATOM    864  CA  LEU A 107     -23.246  35.968  35.793  1.00 10.06           C  
ATOM    865  C   LEU A 107     -21.764  35.615  35.959  1.00  8.95           C  
ATOM    866  O   LEU A 107     -21.000  36.393  36.536  1.00  8.07           O  
ATOM    867  CB  LEU A 107     -24.059  35.452  36.988  1.00 11.19           C  
ATOM    868  CG  LEU A 107     -25.562  35.790  36.978  1.00 12.55           C  
ATOM    869  CD1 LEU A 107     -26.233  35.204  38.217  1.00 11.80           C  
ATOM    870  CD2 LEU A 107     -25.761  37.296  36.941  1.00 12.44           C  
ATOM    871  N   GLY A 108     -21.356  34.452  35.461  1.00  6.75           N  
ATOM    872  CA  GLY A 108     -19.956  34.071  35.551  1.00  7.34           C  
ATOM    873  C   GLY A 108     -19.142  35.043  34.714  1.00  7.24           C  
ATOM    874  O   GLY A 108     -18.075  35.491  35.128  1.00  8.49           O  
ATOM    875  N   LYS A 109     -19.659  35.374  33.531  1.00  8.28           N  
ATOM    876  CA  LYS A 109     -18.989  36.312  32.632  1.00 10.08           C  
ATOM    877  C   LYS A 109     -18.806  37.655  33.333  1.00  8.66           C  
ATOM    878  O   LYS A 109     -17.739  38.263  33.244  1.00  8.61           O  
ATOM    879  CB  LYS A 109     -19.796  36.512  31.339  1.00 10.94           C  
ATOM    880  CG  LYS A 109     -19.140  37.528  30.387  1.00 14.69           C  
ATOM    881  CD  LYS A 109     -19.633  37.428  28.954  1.00 15.76           C  
ATOM    882  CE  LYS A 109     -21.091  37.794  28.825  1.00 20.59           C  
ATOM    883  NZ  LYS A 109     -21.523  37.699  27.387  1.00 24.30           N  
ATOM    884  N   HIS A 110     -19.852  38.116  34.021  1.00  9.66           N  
ATOM    885  CA  HIS A 110     -19.794  39.381  34.753  1.00  7.62           C  
ATOM    886  C   HIS A 110     -18.675  39.356  35.791  1.00  7.63           C  
ATOM    887  O   HIS A 110     -17.895  40.300  35.901  1.00  8.84           O  
ATOM    888  CB  HIS A 110     -21.119  39.662  35.466  1.00  8.67           C  
ATOM    889  CG  HIS A 110     -22.134  40.356  34.616  1.00  9.92           C  
ATOM    890  ND1 HIS A 110     -21.925  41.609  34.077  1.00 10.81           N  
ATOM    891  CD2 HIS A 110     -23.375  39.981  34.220  1.00 11.30           C  
ATOM    892  CE1 HIS A 110     -22.993  41.973  33.387  1.00 14.27           C  
ATOM    893  NE2 HIS A 110     -23.886  41.003  33.459  1.00 11.91           N  
ATOM    894  N   LEU A 111     -18.600  38.277  36.562  1.00  7.68           N  
ATOM    895  CA  LEU A 111     -17.561  38.170  37.583  1.00  8.33           C  
ATOM    896  C   LEU A 111     -16.171  38.131  36.980  1.00  8.31           C  
ATOM    897  O   LEU A 111     -15.245  38.764  37.498  1.00  7.29           O  
ATOM    898  CB  LEU A 111     -17.754  36.913  38.425  1.00  8.57           C  
ATOM    899  CG  LEU A 111     -18.975  36.859  39.350  1.00  8.14           C  
ATOM    900  CD1 LEU A 111     -19.023  35.486  40.022  1.00  7.44           C  
ATOM    901  CD2 LEU A 111     -18.883  37.959  40.390  1.00  7.99           C  
ATOM    902  N   LEU A 112     -16.010  37.387  35.893  1.00  8.26           N  
ATOM    903  CA  LEU A 112     -14.694  37.292  35.268  1.00  8.62           C  
ATOM    904  C   LEU A 112     -14.280  38.630  34.662  1.00  8.60           C  
ATOM    905  O   LEU A 112     -13.119  39.034  34.773  1.00  9.03           O  
ATOM    906  CB  LEU A 112     -14.690  36.183  34.208  1.00  8.41           C  
ATOM    907  CG  LEU A 112     -13.354  35.905  33.498  1.00  8.78           C  
ATOM    908  CD1 LEU A 112     -13.202  34.410  33.226  1.00  9.34           C  
ATOM    909  CD2 LEU A 112     -13.308  36.706  32.202  1.00  8.26           C  
ATOM    910  N   ASN A 113     -15.219  39.321  34.023  1.00  8.09           N  
ATOM    911  CA  ASN A 113     -14.898  40.609  33.424  1.00  8.77           C  
ATOM    912  C   ASN A 113     -14.587  41.654  34.482  1.00  9.50           C  
ATOM    913  O   ASN A 113     -13.861  42.619  34.223  1.00 10.18           O  
ATOM    914  CB  ASN A 113     -16.028  41.069  32.503  1.00 10.41           C  
ATOM    915  CG  ASN A 113     -15.949  40.409  31.148  1.00 12.24           C  
ATOM    916  OD1 ASN A 113     -14.856  40.079  30.684  1.00 11.81           O  
ATOM    917  ND2 ASN A 113     -17.093  40.213  30.503  1.00 12.27           N  
ATOM    918  N   LYS A 114     -15.130  41.449  35.677  1.00  8.34           N  
ATOM    919  CA  LYS A 114     -14.861  42.349  36.784  1.00  9.98           C  
ATOM    920  C   LYS A 114     -13.412  42.099  37.195  1.00  9.41           C  
ATOM    921  O   LYS A 114     -12.680  43.039  37.506  1.00  9.18           O  
ATOM    922  CB  LYS A 114     -15.794  42.058  37.968  1.00 10.40           C  
ATOM    923  CG  LYS A 114     -15.499  42.915  39.200  1.00 13.98           C  
ATOM    924  CD  LYS A 114     -15.713  44.392  38.889  1.00 15.41           C  
ATOM    925  CE  LYS A 114     -15.493  45.259  40.110  1.00 17.89           C  
ATOM    926  NZ  LYS A 114     -15.630  46.699  39.764  1.00 18.09           N  
ATOM    927  N   ALA A 115     -13.000  40.831  37.195  1.00  8.67           N  
ATOM    928  CA  ALA A 115     -11.618  40.487  37.552  1.00  6.46           C  
ATOM    929  C   ALA A 115     -10.671  41.098  36.525  1.00  7.63           C  
ATOM    930  O   ALA A 115      -9.582  41.553  36.868  1.00  7.65           O  
ATOM    931  CB  ALA A 115     -11.439  38.967  37.591  1.00  6.36           C  
ATOM    932  N   ILE A 116     -11.088  41.090  35.261  1.00  7.71           N  
ATOM    933  CA  ILE A 116     -10.266  41.663  34.192  1.00 10.84           C  
ATOM    934  C   ILE A 116     -10.172  43.173  34.373  1.00 11.44           C  
ATOM    935  O   ILE A 116      -9.105  43.770  34.179  1.00 11.57           O  
ATOM    936  CB  ILE A 116     -10.862  41.365  32.800  1.00 12.09           C  
ATOM    937  CG1 ILE A 116     -10.665  39.883  32.468  1.00 10.33           C  
ATOM    938  CG2 ILE A 116     -10.201  42.253  31.737  1.00 13.01           C  
ATOM    939  CD1 ILE A 116     -11.317  39.452  31.170  1.00 13.33           C  
ATOM    940  N   GLU A 117     -11.290  43.780  34.755  1.00  9.54           N  
ATOM    941  CA  GLU A 117     -11.352  45.223  34.963  1.00 13.91           C  
ATOM    942  C   GLU A 117     -10.427  45.617  36.112  1.00 11.71           C  
ATOM    943  O   GLU A 117      -9.729  46.628  36.038  1.00 12.60           O  
ATOM    944  CB  GLU A 117     -12.798  45.646  35.257  1.00 14.46           C  
ATOM    945  CG  GLU A 117     -13.025  47.142  35.442  1.00 20.00           C  
ATOM    946  CD  GLU A 117     -12.648  47.635  36.828  1.00 22.17           C  
ATOM    947  OE1 GLU A 117     -13.068  47.000  37.817  1.00 24.62           O  
ATOM    948  OE2 GLU A 117     -11.949  48.665  36.927  1.00 26.19           O  
ATOM    949  N   ILE A 118     -10.420  44.815  37.171  1.00 10.84           N  
ATOM    950  CA  ILE A 118      -9.558  45.091  38.312  1.00 10.41           C  
ATOM    951  C   ILE A 118      -8.085  44.965  37.909  1.00 10.71           C  
ATOM    952  O   ILE A 118      -7.251  45.775  38.321  1.00 12.49           O  
ATOM    953  CB  ILE A 118      -9.860  44.130  39.481  1.00 10.56           C  
ATOM    954  CG1 ILE A 118     -11.281  44.370  39.989  1.00 10.66           C  
ATOM    955  CG2 ILE A 118      -8.860  44.332  40.594  1.00 13.53           C  
ATOM    956  CD1 ILE A 118     -11.802  43.271  40.893  1.00 12.76           C  
ATOM    957  N   ALA A 119      -7.774  43.962  37.092  1.00 11.18           N  
ATOM    958  CA  ALA A 119      -6.410  43.744  36.634  1.00 10.84           C  
ATOM    959  C   ALA A 119      -5.958  44.929  35.790  1.00 14.06           C  
ATOM    960  O   ALA A 119      -4.847  45.431  35.951  1.00 14.61           O  
ATOM    961  CB  ALA A 119      -6.325  42.453  35.817  1.00  9.83           C  
ATOM    962  N   LEU A 120      -6.825  45.378  34.891  1.00 12.97           N  
ATOM    963  CA  LEU A 120      -6.498  46.514  34.038  1.00 15.86           C  
ATOM    964  C   LEU A 120      -6.286  47.760  34.894  1.00 16.34           C  
ATOM    965  O   LEU A 120      -5.328  48.506  34.695  1.00 15.80           O  
ATOM    966  CB  LEU A 120      -7.627  46.757  33.029  1.00 14.36           C  
ATOM    967  CG  LEU A 120      -7.833  45.655  31.995  1.00 15.51           C  
ATOM    968  CD1 LEU A 120      -9.097  45.928  31.190  1.00 15.96           C  
ATOM    969  CD2 LEU A 120      -6.613  45.570  31.086  1.00 14.38           C  
ATOM    970  N   GLU A 121      -7.183  47.978  35.851  1.00 18.11           N  
ATOM    971  CA  GLU A 121      -7.092  49.135  36.736  1.00 20.69           C  
ATOM    972  C   GLU A 121      -5.822  49.086  37.595  1.00 22.14           C  
ATOM    973  O   GLU A 121      -5.235  50.122  37.918  1.00 20.54           O  
ATOM    974  CB  GLU A 121      -8.341  49.202  37.626  1.00 23.82           C  
ATOM    975  CG  GLU A 121      -8.329  50.294  38.688  1.00 30.32           C  
ATOM    976  CD  GLU A 121      -9.671  50.431  39.397  1.00 33.71           C  
ATOM    977  OE1 GLU A 121     -10.230  49.400  39.836  1.00 36.84           O  
ATOM    978  OE2 GLU A 121     -10.170  51.571  39.519  1.00 36.63           O  
ATOM    979  N   ARG A 122      -5.400  47.875  37.948  1.00 20.11           N  
ATOM    980  CA  ARG A 122      -4.208  47.668  38.768  1.00 22.65           C  
ATOM    981  C   ARG A 122      -2.961  47.607  37.898  1.00 21.94           C  
ATOM    982  O   ARG A 122      -1.860  47.331  38.383  1.00 20.93           O  
ATOM    983  CB  ARG A 122      -4.331  46.364  39.559  1.00 23.83           C  
ATOM    984  CG  ARG A 122      -5.319  46.405  40.703  1.00 27.70           C  
ATOM    985  CD  ARG A 122      -4.760  47.208  41.859  1.00 33.18           C  
ATOM    986  NE  ARG A 122      -4.609  48.619  41.517  1.00 36.83           N  
ATOM    987  CZ  ARG A 122      -3.949  49.499  42.260  1.00 38.07           C  
ATOM    988  NH1 ARG A 122      -3.372  49.111  43.391  1.00 38.97           N  
ATOM    989  NH2 ARG A 122      -3.870  50.767  41.873  1.00 38.19           N  
ATOM    990  N   ASN A 123      -3.154  47.858  36.606  1.00 20.65           N  
ATOM    991  CA  ASN A 123      -2.077  47.846  35.625  1.00 21.64           C  
ATOM    992  C   ASN A 123      -1.297  46.528  35.583  1.00 20.23           C  
ATOM    993  O   ASN A 123      -0.070  46.528  35.473  1.00 20.42           O  
ATOM    994  CB  ASN A 123      -1.116  49.010  35.888  1.00 27.41           C  
ATOM    995  CG  ASN A 123      -0.064  49.154  34.803  1.00 30.47           C  
ATOM    996  OD1 ASN A 123      -0.387  49.267  33.618  1.00 34.96           O  
ATOM    997  ND2 ASN A 123       1.203  49.159  35.202  1.00 33.81           N  
ATOM    998  N   LYS A 124      -2.006  45.405  35.663  1.00 16.03           N  
ATOM    999  CA  LYS A 124      -1.346  44.103  35.610  1.00 16.07           C  
ATOM   1000  C   LYS A 124      -1.224  43.641  34.159  1.00 16.49           C  
ATOM   1001  O   LYS A 124      -2.171  43.764  33.380  1.00 18.62           O  
ATOM   1002  CB  LYS A 124      -2.126  43.066  36.434  1.00 13.94           C  
ATOM   1003  CG  LYS A 124      -2.275  43.416  37.916  1.00 11.82           C  
ATOM   1004  CD  LYS A 124      -0.923  43.701  38.590  1.00 11.84           C  
ATOM   1005  CE  LYS A 124      -1.081  43.954  40.088  1.00  7.33           C  
ATOM   1006  NZ  LYS A 124       0.237  44.121  40.781  1.00 11.38           N  
ATOM   1007  N   LYS A 125      -0.053  43.117  33.801  1.00 16.53           N  
ATOM   1008  CA  LYS A 125       0.225  42.645  32.443  1.00 16.45           C  
ATOM   1009  C   LYS A 125      -0.577  41.413  32.039  1.00 16.92           C  
ATOM   1010  O   LYS A 125      -0.899  41.233  30.868  1.00 16.93           O  
ATOM   1011  CB  LYS A 125       1.724  42.343  32.291  1.00 19.52           C  
ATOM   1012  CG  LYS A 125       2.590  43.549  31.895  1.00 24.31           C  
ATOM   1013  CD  LYS A 125       2.376  44.740  32.807  1.00 28.04           C  
ATOM   1014  CE  LYS A 125       3.198  45.937  32.350  1.00 29.24           C  
ATOM   1015  NZ  LYS A 125       2.937  47.122  33.210  1.00 33.45           N  
ATOM   1016  N   ASN A 126      -0.881  40.544  32.993  1.00 15.96           N  
ATOM   1017  CA  ASN A 126      -1.650  39.361  32.651  1.00 16.76           C  
ATOM   1018  C   ASN A 126      -2.496  38.840  33.795  1.00 13.68           C  
ATOM   1019  O   ASN A 126      -2.259  39.155  34.956  1.00 12.52           O  
ATOM   1020  CB  ASN A 126      -0.723  38.265  32.128  1.00 22.05           C  
ATOM   1021  CG  ASN A 126       0.616  38.265  32.818  1.00 25.95           C  
ATOM   1022  OD1 ASN A 126       1.666  38.449  32.183  1.00 25.51           O  
ATOM   1023  ND2 ASN A 126       0.597  38.067  34.130  1.00 27.70           N  
ATOM   1024  N   ILE A 127      -3.502  38.051  33.439  1.00 11.71           N  
ATOM   1025  CA  ILE A 127      -4.422  37.476  34.403  1.00  8.43           C  
ATOM   1026  C   ILE A 127      -4.356  35.964  34.221  1.00  6.97           C  
ATOM   1027  O   ILE A 127      -4.202  35.475  33.104  1.00  5.33           O  
ATOM   1028  CB  ILE A 127      -5.847  38.039  34.169  1.00  7.89           C  
ATOM   1029  CG1 ILE A 127      -6.822  37.463  35.196  1.00  6.77           C  
ATOM   1030  CG2 ILE A 127      -6.291  37.762  32.737  1.00  6.65           C  
ATOM   1031  CD1 ILE A 127      -8.176  38.180  35.215  1.00  9.02           C  
ATOM   1032  N   TRP A 128      -4.446  35.226  35.322  1.00  6.39           N  
ATOM   1033  CA  TRP A 128      -4.341  33.772  35.251  1.00  7.21           C  
ATOM   1034  C   TRP A 128      -5.179  33.084  36.313  1.00  7.06           C  
ATOM   1035  O   TRP A 128      -5.724  33.728  37.202  1.00  7.44           O  
ATOM   1036  CB  TRP A 128      -2.879  33.348  35.446  1.00  7.11           C  
ATOM   1037  CG  TRP A 128      -2.388  33.556  36.857  1.00  8.09           C  
ATOM   1038  CD1 TRP A 128      -1.989  34.736  37.435  1.00  7.02           C  
ATOM   1039  CD2 TRP A 128      -2.317  32.563  37.887  1.00  9.22           C  
ATOM   1040  NE1 TRP A 128      -1.678  34.533  38.758  1.00  7.80           N  
ATOM   1041  CE2 TRP A 128      -1.869  33.208  39.064  1.00  9.70           C  
ATOM   1042  CE3 TRP A 128      -2.588  31.186  37.929  1.00  9.58           C  
ATOM   1043  CZ2 TRP A 128      -1.691  32.530  40.273  1.00  9.50           C  
ATOM   1044  CZ3 TRP A 128      -2.411  30.505  39.137  1.00  9.98           C  
ATOM   1045  CH2 TRP A 128      -1.964  31.180  40.290  1.00 12.99           C  
ATOM   1046  N   LEU A 129      -5.252  31.761  36.217  1.00  6.71           N  
ATOM   1047  CA  LEU A 129      -5.997  30.965  37.177  1.00  6.41           C  
ATOM   1048  C   LEU A 129      -5.594  29.507  37.053  1.00  6.70           C  
ATOM   1049  O   LEU A 129      -4.999  29.089  36.057  1.00  7.53           O  
ATOM   1050  CB  LEU A 129      -7.504  31.101  36.928  1.00  7.73           C  
ATOM   1051  CG  LEU A 129      -8.040  30.704  35.548  1.00  8.53           C  
ATOM   1052  CD1 LEU A 129      -8.195  29.176  35.452  1.00  9.03           C  
ATOM   1053  CD2 LEU A 129      -9.392  31.377  35.340  1.00 10.63           C  
ATOM   1054  N   GLY A 130      -5.920  28.745  38.085  1.00  7.22           N  
ATOM   1055  CA  GLY A 130      -5.633  27.331  38.080  1.00  8.00           C  
ATOM   1056  C   GLY A 130      -6.987  26.644  38.053  1.00  9.11           C  
ATOM   1057  O   GLY A 130      -7.912  27.088  38.742  1.00  8.05           O  
ATOM   1058  N   VAL A 131      -7.127  25.594  37.245  1.00  9.70           N  
ATOM   1059  CA  VAL A 131      -8.395  24.859  37.173  1.00  8.57           C  
ATOM   1060  C   VAL A 131      -8.205  23.358  36.998  1.00  8.92           C  
ATOM   1061  O   VAL A 131      -7.457  22.904  36.136  1.00  8.00           O  
ATOM   1062  CB  VAL A 131      -9.338  25.392  36.049  1.00 10.40           C  
ATOM   1063  CG1 VAL A 131      -8.711  25.232  34.674  1.00 11.34           C  
ATOM   1064  CG2 VAL A 131     -10.675  24.648  36.115  1.00  8.57           C  
ATOM   1065  N   TRP A 132      -8.879  22.593  37.853  1.00  7.29           N  
ATOM   1066  CA  TRP A 132      -8.815  21.131  37.819  1.00  9.66           C  
ATOM   1067  C   TRP A 132      -9.152  20.634  36.415  1.00 10.28           C  
ATOM   1068  O   TRP A 132     -10.196  20.979  35.858  1.00 11.63           O  
ATOM   1069  CB  TRP A 132      -9.798  20.581  38.852  1.00 11.09           C  
ATOM   1070  CG  TRP A 132      -9.854  19.100  38.978  1.00 15.26           C  
ATOM   1071  CD1 TRP A 132      -8.862  18.194  38.682  1.00 17.27           C  
ATOM   1072  CD2 TRP A 132     -10.936  18.346  39.523  1.00 15.31           C  
ATOM   1073  NE1 TRP A 132      -9.268  16.926  39.023  1.00 17.40           N  
ATOM   1074  CE2 TRP A 132     -10.534  16.991  39.548  1.00 17.75           C  
ATOM   1075  CE3 TRP A 132     -12.206  18.688  40.014  1.00 17.47           C  
ATOM   1076  CZ2 TRP A 132     -11.362  15.972  40.025  1.00 19.34           C  
ATOM   1077  CZ3 TRP A 132     -13.032  17.673  40.492  1.00 20.05           C  
ATOM   1078  CH2 TRP A 132     -12.599  16.331  40.499  1.00 19.65           C  
ATOM   1079  N   GLU A 133      -8.268  19.823  35.844  1.00 10.64           N  
ATOM   1080  CA  GLU A 133      -8.470  19.316  34.489  1.00 11.42           C  
ATOM   1081  C   GLU A 133      -9.822  18.630  34.259  1.00 11.77           C  
ATOM   1082  O   GLU A 133     -10.329  18.640  33.141  1.00 11.27           O  
ATOM   1083  CB  GLU A 133      -7.314  18.371  34.108  1.00 14.26           C  
ATOM   1084  CG  GLU A 133      -7.415  17.794  32.703  1.00 16.20           C  
ATOM   1085  CD  GLU A 133      -6.142  17.090  32.259  1.00 19.02           C  
ATOM   1086  OE1 GLU A 133      -5.624  16.265  33.032  1.00 19.67           O  
ATOM   1087  OE2 GLU A 133      -5.669  17.358  31.134  1.00 21.00           O  
ATOM   1088  N   LYS A 134     -10.406  18.052  35.311  1.00 10.98           N  
ATOM   1089  CA  LYS A 134     -11.699  17.369  35.199  1.00 11.67           C  
ATOM   1090  C   LYS A 134     -12.884  18.337  35.125  1.00 11.53           C  
ATOM   1091  O   LYS A 134     -13.991  17.942  34.761  1.00 10.51           O  
ATOM   1092  CB  LYS A 134     -11.942  16.436  36.394  1.00 14.40           C  
ATOM   1093  CG  LYS A 134     -10.966  15.287  36.560  1.00 19.02           C  
ATOM   1094  CD  LYS A 134     -11.081  14.265  35.452  1.00 25.13           C  
ATOM   1095  CE  LYS A 134     -10.203  13.046  35.739  1.00 28.22           C  
ATOM   1096  NZ  LYS A 134     -10.364  12.001  34.684  1.00 31.59           N  
ATOM   1097  N   ASN A 135     -12.662  19.593  35.487  1.00  9.38           N  
ATOM   1098  CA  ASN A 135     -13.739  20.575  35.454  1.00  9.26           C  
ATOM   1099  C   ASN A 135     -13.909  21.103  34.025  1.00 11.07           C  
ATOM   1100  O   ASN A 135     -13.535  22.235  33.710  1.00  5.65           O  
ATOM   1101  CB  ASN A 135     -13.427  21.712  36.440  1.00  9.50           C  
ATOM   1102  CG  ASN A 135     -14.657  22.534  36.803  1.00  9.21           C  
ATOM   1103  OD1 ASN A 135     -14.650  23.273  37.795  1.00 10.62           O  
ATOM   1104  ND2 ASN A 135     -15.710  22.417  36.005  1.00  5.88           N  
ATOM   1105  N   GLU A 136     -14.480  20.263  33.164  1.00  9.68           N  
ATOM   1106  CA  GLU A 136     -14.695  20.611  31.764  1.00 10.91           C  
ATOM   1107  C   GLU A 136     -15.578  21.830  31.562  1.00  8.40           C  
ATOM   1108  O   GLU A 136     -15.336  22.613  30.649  1.00  7.11           O  
ATOM   1109  CB  GLU A 136     -15.294  19.423  31.005  1.00 14.03           C  
ATOM   1110  CG  GLU A 136     -14.358  18.217  30.904  1.00 21.53           C  
ATOM   1111  CD  GLU A 136     -14.820  17.218  29.865  1.00 27.13           C  
ATOM   1112  OE1 GLU A 136     -14.795  17.556  28.661  1.00 31.16           O  
ATOM   1113  OE2 GLU A 136     -15.212  16.096  30.254  1.00 30.44           O  
ATOM   1114  N   ASN A 137     -16.600  21.987  32.398  1.00  8.34           N  
ATOM   1115  CA  ASN A 137     -17.491  23.138  32.279  1.00  9.14           C  
ATOM   1116  C   ASN A 137     -16.709  24.431  32.486  1.00  7.48           C  
ATOM   1117  O   ASN A 137     -16.833  25.377  31.703  1.00  7.16           O  
ATOM   1118  CB  ASN A 137     -18.630  23.053  33.306  1.00  8.51           C  
ATOM   1119  CG  ASN A 137     -19.575  24.258  33.243  1.00 10.75           C  
ATOM   1120  OD1 ASN A 137     -20.308  24.452  32.264  1.00 13.63           O  
ATOM   1121  ND2 ASN A 137     -19.561  25.069  34.295  1.00  9.06           N  
ATOM   1122  N   ALA A 138     -15.893  24.483  33.533  1.00  6.92           N  
ATOM   1123  CA  ALA A 138     -15.128  25.705  33.794  1.00  5.91           C  
ATOM   1124  C   ALA A 138     -14.071  25.982  32.727  1.00  4.88           C  
ATOM   1125  O   ALA A 138     -13.841  27.138  32.363  1.00  6.68           O  
ATOM   1126  CB  ALA A 138     -14.484  25.639  35.168  1.00  2.69           C  
ATOM   1127  N   ILE A 139     -13.422  24.930  32.238  1.00  7.28           N  
ATOM   1128  CA  ILE A 139     -12.398  25.086  31.207  1.00  7.88           C  
ATOM   1129  C   ILE A 139     -13.013  25.686  29.948  1.00  9.47           C  
ATOM   1130  O   ILE A 139     -12.471  26.631  29.368  1.00  9.08           O  
ATOM   1131  CB  ILE A 139     -11.723  23.726  30.890  1.00  7.20           C  
ATOM   1132  CG1 ILE A 139     -10.894  23.277  32.102  1.00  7.36           C  
ATOM   1133  CG2 ILE A 139     -10.834  23.854  29.639  1.00  7.36           C  
ATOM   1134  CD1 ILE A 139     -10.433  21.803  32.063  1.00  6.67           C  
ATOM   1135  N   ALA A 140     -14.164  25.157  29.548  1.00  7.73           N  
ATOM   1136  CA  ALA A 140     -14.865  25.640  28.362  1.00  8.86           C  
ATOM   1137  C   ALA A 140     -15.266  27.106  28.531  1.00  7.14           C  
ATOM   1138  O   ALA A 140     -15.185  27.887  27.587  1.00  8.30           O  
ATOM   1139  CB  ALA A 140     -16.111  24.777  28.110  1.00  7.30           C  
ATOM   1140  N   PHE A 141     -15.713  27.461  29.732  1.00  8.39           N  
ATOM   1141  CA  PHE A 141     -16.103  28.837  30.040  1.00  7.31           C  
ATOM   1142  C   PHE A 141     -14.886  29.754  29.892  1.00  5.60           C  
ATOM   1143  O   PHE A 141     -14.938  30.755  29.172  1.00  5.31           O  
ATOM   1144  CB  PHE A 141     -16.670  28.905  31.466  1.00  5.87           C  
ATOM   1145  CG  PHE A 141     -16.738  30.300  32.047  1.00  7.04           C  
ATOM   1146  CD1 PHE A 141     -15.908  30.661  33.100  1.00  6.44           C  
ATOM   1147  CD2 PHE A 141     -17.643  31.238  31.560  1.00  7.03           C  
ATOM   1148  CE1 PHE A 141     -15.970  31.934  33.671  1.00  4.85           C  
ATOM   1149  CE2 PHE A 141     -17.720  32.524  32.122  1.00  6.98           C  
ATOM   1150  CZ  PHE A 141     -16.880  32.865  33.179  1.00  6.98           C  
ATOM   1151  N   TYR A 142     -13.787  29.399  30.549  1.00  5.32           N  
ATOM   1152  CA  TYR A 142     -12.570  30.212  30.475  1.00  6.83           C  
ATOM   1153  C   TYR A 142     -12.069  30.400  29.037  1.00  7.67           C  
ATOM   1154  O   TYR A 142     -11.662  31.500  28.656  1.00  8.11           O  
ATOM   1155  CB  TYR A 142     -11.451  29.599  31.329  1.00  5.49           C  
ATOM   1156  CG  TYR A 142     -11.766  29.460  32.809  1.00  5.39           C  
ATOM   1157  CD1 TYR A 142     -12.412  30.482  33.512  1.00  6.89           C  
ATOM   1158  CD2 TYR A 142     -11.379  28.319  33.517  1.00  6.05           C  
ATOM   1159  CE1 TYR A 142     -12.665  30.369  34.886  1.00  8.92           C  
ATOM   1160  CE2 TYR A 142     -11.625  28.197  34.893  1.00  7.59           C  
ATOM   1161  CZ  TYR A 142     -12.267  29.230  35.564  1.00  9.99           C  
ATOM   1162  OH  TYR A 142     -12.512  29.129  36.917  1.00 12.99           O  
ATOM   1163  N   LYS A 143     -12.078  29.331  28.244  1.00  7.38           N  
ATOM   1164  CA  LYS A 143     -11.621  29.426  26.856  1.00 10.72           C  
ATOM   1165  C   LYS A 143     -12.511  30.385  26.071  1.00 10.15           C  
ATOM   1166  O   LYS A 143     -12.035  31.138  25.217  1.00 10.89           O  
ATOM   1167  CB  LYS A 143     -11.635  28.044  26.190  1.00 13.03           C  
ATOM   1168  CG  LYS A 143     -10.533  27.105  26.653  1.00 16.42           C  
ATOM   1169  CD  LYS A 143     -10.639  25.775  25.916  1.00 18.71           C  
ATOM   1170  CE  LYS A 143      -9.549  24.791  26.297  1.00 22.13           C  
ATOM   1171  NZ  LYS A 143      -9.803  23.481  25.606  1.00 24.35           N  
ATOM   1172  N   LYS A 144     -13.805  30.357  26.361  1.00 10.15           N  
ATOM   1173  CA  LYS A 144     -14.738  31.250  25.687  1.00  9.34           C  
ATOM   1174  C   LYS A 144     -14.387  32.684  26.091  1.00 11.65           C  
ATOM   1175  O   LYS A 144     -14.491  33.610  25.283  1.00 11.50           O  
ATOM   1176  CB  LYS A 144     -16.180  30.915  26.099  1.00 11.55           C  
ATOM   1177  CG  LYS A 144     -17.264  31.550  25.223  1.00 15.92           C  
ATOM   1178  CD  LYS A 144     -17.232  31.006  23.806  1.00 18.08           C  
ATOM   1179  CE  LYS A 144     -18.286  31.679  22.924  1.00 22.28           C  
ATOM   1180  NZ  LYS A 144     -19.628  31.754  23.585  1.00 22.08           N  
HETATM 1181  N   MSE A 145     -13.954  32.864  27.336  1.00  8.93           N  
HETATM 1182  CA  MSE A 145     -13.593  34.190  27.816  1.00 10.25           C  
HETATM 1183  C   MSE A 145     -12.197  34.649  27.367  1.00  9.52           C  
HETATM 1184  O   MSE A 145     -11.726  35.703  27.791  1.00 12.47           O  
HETATM 1185  CB  MSE A 145     -13.700  34.258  29.346  1.00 11.86           C  
HETATM 1186  CG  MSE A 145     -15.114  33.971  29.894  1.00 14.02           C  
HETATM 1187 SE   MSE A 145     -16.462  35.200  29.208  1.00 24.37          SE  
HETATM 1188  CE  MSE A 145     -17.092  34.150  27.723  1.00 20.48           C  
ATOM   1189  N   GLY A 146     -11.535  33.861  26.527  1.00  9.96           N  
ATOM   1190  CA  GLY A 146     -10.230  34.259  26.025  1.00 10.31           C  
ATOM   1191  C   GLY A 146      -8.990  33.720  26.712  1.00 10.10           C  
ATOM   1192  O   GLY A 146      -7.866  34.074  26.340  1.00  9.50           O  
ATOM   1193  N   PHE A 147      -9.176  32.868  27.712  1.00  9.46           N  
ATOM   1194  CA  PHE A 147      -8.041  32.285  28.422  1.00  9.64           C  
ATOM   1195  C   PHE A 147      -7.504  31.072  27.666  1.00  9.97           C  
ATOM   1196  O   PHE A 147      -8.260  30.382  26.986  1.00  9.69           O  
ATOM   1197  CB  PHE A 147      -8.458  31.862  29.832  1.00  8.50           C  
ATOM   1198  CG  PHE A 147      -8.573  32.999  30.805  1.00 10.60           C  
ATOM   1199  CD1 PHE A 147      -9.533  33.995  30.640  1.00 10.30           C  
ATOM   1200  CD2 PHE A 147      -7.738  33.050  31.917  1.00 11.20           C  
ATOM   1201  CE1 PHE A 147      -9.660  35.024  31.579  1.00 13.49           C  
ATOM   1202  CE2 PHE A 147      -7.855  34.067  32.858  1.00 12.12           C  
ATOM   1203  CZ  PHE A 147      -8.817  35.056  32.692  1.00 11.67           C  
ATOM   1204  N   VAL A 148      -6.200  30.829  27.782  1.00  8.81           N  
ATOM   1205  CA  VAL A 148      -5.555  29.703  27.114  1.00 10.31           C  
ATOM   1206  C   VAL A 148      -4.655  28.942  28.086  1.00  8.28           C  
ATOM   1207  O   VAL A 148      -4.069  29.520  29.000  1.00  8.86           O  
ATOM   1208  CB  VAL A 148      -4.703  30.165  25.889  1.00 11.76           C  
ATOM   1209  CG1 VAL A 148      -5.585  30.933  24.911  1.00 15.20           C  
ATOM   1210  CG2 VAL A 148      -3.530  31.034  26.340  1.00 14.26           C  
ATOM   1211  N   GLN A 149      -4.546  27.636  27.892  1.00 10.16           N  
ATOM   1212  CA  GLN A 149      -3.715  26.827  28.768  1.00 10.59           C  
ATOM   1213  C   GLN A 149      -2.242  27.053  28.449  1.00 10.78           C  
ATOM   1214  O   GLN A 149      -1.797  26.824  27.319  1.00 10.34           O  
ATOM   1215  CB  GLN A 149      -4.060  25.347  28.598  1.00 11.78           C  
ATOM   1216  CG  GLN A 149      -3.348  24.449  29.592  1.00 12.35           C  
ATOM   1217  CD  GLN A 149      -3.683  23.004  29.380  1.00 12.97           C  
ATOM   1218  OE1 GLN A 149      -4.848  22.651  29.202  1.00 15.81           O  
ATOM   1219  NE2 GLN A 149      -2.669  22.153  29.402  1.00 11.83           N  
ATOM   1220  N   THR A 150      -1.489  27.497  29.451  1.00  9.91           N  
ATOM   1221  CA  THR A 150      -0.061  27.756  29.285  1.00 11.60           C  
ATOM   1222  C   THR A 150       0.769  26.694  29.993  1.00 12.16           C  
ATOM   1223  O   THR A 150       1.970  26.574  29.755  1.00 12.22           O  
ATOM   1224  CB  THR A 150       0.332  29.130  29.853  1.00 12.09           C  
ATOM   1225  OG1 THR A 150       0.014  29.182  31.251  1.00 12.41           O  
ATOM   1226  CG2 THR A 150      -0.408  30.241  29.128  1.00 12.97           C  
ATOM   1227  N   GLY A 151       0.124  25.929  30.870  1.00 10.12           N  
ATOM   1228  CA  GLY A 151       0.830  24.890  31.588  1.00 11.57           C  
ATOM   1229  C   GLY A 151      -0.099  23.939  32.321  1.00 13.21           C  
ATOM   1230  O   GLY A 151      -1.320  24.081  32.281  1.00 10.16           O  
ATOM   1231  N   ALA A 152       0.489  22.962  32.998  1.00 13.15           N  
ATOM   1232  CA  ALA A 152      -0.282  21.981  33.743  1.00 14.80           C  
ATOM   1233  C   ALA A 152       0.671  21.285  34.696  1.00 17.35           C  
ATOM   1234  O   ALA A 152       1.788  20.935  34.314  1.00 17.98           O  
ATOM   1235  CB  ALA A 152      -0.904  20.969  32.791  1.00 13.93           C  
ATOM   1236  N   HIS A 153       0.235  21.094  35.936  1.00 16.85           N  
ATOM   1237  CA  HIS A 153       1.067  20.429  36.926  1.00 17.77           C  
ATOM   1238  C   HIS A 153       0.183  19.587  37.826  1.00 18.34           C  
ATOM   1239  O   HIS A 153      -1.019  19.837  37.939  1.00 16.48           O  
ATOM   1240  CB  HIS A 153       1.859  21.460  37.739  1.00 19.06           C  
ATOM   1241  CG  HIS A 153       1.014  22.318  38.628  1.00 20.02           C  
ATOM   1242  ND1 HIS A 153       0.639  21.935  39.897  1.00 21.95           N  
ATOM   1243  CD2 HIS A 153       0.469  23.541  38.427  1.00 20.29           C  
ATOM   1244  CE1 HIS A 153      -0.100  22.885  40.442  1.00 21.81           C  
ATOM   1245  NE2 HIS A 153      -0.218  23.871  39.571  1.00 20.37           N  
ATOM   1246  N   SER A 154       0.769  18.572  38.448  1.00 17.43           N  
ATOM   1247  CA  SER A 154       0.001  17.702  39.325  1.00 19.60           C  
ATOM   1248  C   SER A 154      -0.158  18.312  40.713  1.00 19.22           C  
ATOM   1249  O   SER A 154       0.682  19.098  41.154  1.00 18.56           O  
ATOM   1250  CB  SER A 154       0.684  16.335  39.437  1.00 19.84           C  
ATOM   1251  OG  SER A 154       0.695  15.663  38.186  1.00 25.52           O  
ATOM   1252  N   PHE A 155      -1.252  17.961  41.386  1.00 18.45           N  
ATOM   1253  CA  PHE A 155      -1.516  18.421  42.746  1.00 18.69           C  
ATOM   1254  C   PHE A 155      -2.280  17.314  43.462  1.00 18.79           C  
ATOM   1255  O   PHE A 155      -2.925  16.489  42.817  1.00 17.45           O  
ATOM   1256  CB  PHE A 155      -2.338  19.723  42.765  1.00 19.34           C  
ATOM   1257  CG  PHE A 155      -3.777  19.552  42.367  1.00 19.13           C  
ATOM   1258  CD1 PHE A 155      -4.133  19.439  41.028  1.00 18.38           C  
ATOM   1259  CD2 PHE A 155      -4.779  19.489  43.337  1.00 17.81           C  
ATOM   1260  CE1 PHE A 155      -5.461  19.265  40.657  1.00 19.27           C  
ATOM   1261  CE2 PHE A 155      -6.112  19.313  42.972  1.00 17.99           C  
ATOM   1262  CZ  PHE A 155      -6.452  19.199  41.631  1.00 18.81           C  
ATOM   1263  N   TYR A 156      -2.200  17.292  44.788  1.00 19.64           N  
ATOM   1264  CA  TYR A 156      -2.884  16.272  45.575  1.00 21.91           C  
ATOM   1265  C   TYR A 156      -4.294  16.670  46.000  1.00 21.35           C  
ATOM   1266  O   TYR A 156      -4.490  17.699  46.649  1.00 22.19           O  
ATOM   1267  CB  TYR A 156      -2.070  15.932  46.831  1.00 21.66           C  
ATOM   1268  CG  TYR A 156      -1.011  14.874  46.622  1.00 22.24           C  
ATOM   1269  CD1 TYR A 156      -1.358  13.523  46.522  1.00 22.22           C  
ATOM   1270  CD2 TYR A 156       0.336  15.221  46.527  1.00 22.41           C  
ATOM   1271  CE1 TYR A 156      -0.382  12.541  46.333  1.00 24.02           C  
ATOM   1272  CE2 TYR A 156       1.319  14.252  46.336  1.00 23.69           C  
ATOM   1273  CZ  TYR A 156       0.955  12.916  46.243  1.00 24.50           C  
ATOM   1274  OH  TYR A 156       1.934  11.961  46.068  1.00 25.12           O  
HETATM 1275  N   MSE A 157      -5.270  15.854  45.612  1.00 20.69           N  
HETATM 1276  CA  MSE A 157      -6.663  16.068  45.985  1.00 20.29           C  
HETATM 1277  C   MSE A 157      -7.000  14.894  46.903  1.00 20.31           C  
HETATM 1278  O   MSE A 157      -7.098  13.749  46.450  1.00 18.46           O  
HETATM 1279  CB  MSE A 157      -7.576  16.044  44.758  1.00 21.89           C  
HETATM 1280  CG  MSE A 157      -9.040  16.344  45.076  1.00 23.95           C  
HETATM 1281 SE   MSE A 157     -10.187  16.349  43.485  1.00 33.12          SE  
HETATM 1282  CE  MSE A 157      -9.840  18.153  42.873  1.00 27.68           C  
ATOM   1283  N   GLY A 158      -7.158  15.174  48.190  1.00 20.64           N  
ATOM   1284  CA  GLY A 158      -7.450  14.113  49.134  1.00 22.36           C  
ATOM   1285  C   GLY A 158      -6.195  13.296  49.376  1.00 23.82           C  
ATOM   1286  O   GLY A 158      -5.302  13.732  50.099  1.00 27.46           O  
ATOM   1287  N   ASP A 159      -6.122  12.117  48.763  1.00 23.50           N  
ATOM   1288  CA  ASP A 159      -4.965  11.242  48.915  1.00 24.80           C  
ATOM   1289  C   ASP A 159      -4.473  10.777  47.547  1.00 24.74           C  
ATOM   1290  O   ASP A 159      -3.661   9.859  47.450  1.00 26.42           O  
ATOM   1291  CB  ASP A 159      -5.338  10.025  49.768  1.00 27.08           C  
ATOM   1292  CG  ASP A 159      -6.197   9.019  49.012  1.00 30.10           C  
ATOM   1293  OD1 ASP A 159      -6.989   9.439  48.138  1.00 32.05           O  
ATOM   1294  OD2 ASP A 159      -6.090   7.809  49.300  1.00 31.20           O  
ATOM   1295  N   GLU A 160      -4.963  11.421  46.493  1.00 24.50           N  
ATOM   1296  CA  GLU A 160      -4.593  11.056  45.125  1.00 24.52           C  
ATOM   1297  C   GLU A 160      -4.220  12.282  44.291  1.00 22.99           C  
ATOM   1298  O   GLU A 160      -4.752  13.367  44.501  1.00 22.12           O  
ATOM   1299  CB  GLU A 160      -5.764  10.323  44.464  1.00 27.58           C  
ATOM   1300  CG  GLU A 160      -5.457   9.762  43.085  1.00 32.69           C  
ATOM   1301  CD  GLU A 160      -6.617   8.963  42.512  1.00 35.07           C  
ATOM   1302  OE1 GLU A 160      -7.708   9.544  42.322  1.00 35.27           O  
ATOM   1303  OE2 GLU A 160      -6.436   7.753  42.256  1.00 37.78           O  
ATOM   1304  N   GLU A 161      -3.310  12.113  43.339  1.00 21.03           N  
ATOM   1305  CA  GLU A 161      -2.912  13.238  42.507  1.00 20.60           C  
ATOM   1306  C   GLU A 161      -3.900  13.514  41.380  1.00 18.34           C  
ATOM   1307  O   GLU A 161      -4.524  12.600  40.827  1.00 16.55           O  
ATOM   1308  CB  GLU A 161      -1.515  13.018  41.910  1.00 22.26           C  
ATOM   1309  CG  GLU A 161      -0.352  13.304  42.862  1.00 23.54           C  
ATOM   1310  CD  GLU A 161       1.009  13.199  42.177  1.00 25.85           C  
ATOM   1311  OE1 GLU A 161       2.026  13.616  42.780  1.00 25.37           O  
ATOM   1312  OE2 GLU A 161       1.063  12.694  41.034  1.00 27.87           O  
ATOM   1313  N   GLN A 162      -4.047  14.797  41.070  1.00 16.66           N  
ATOM   1314  CA  GLN A 162      -4.915  15.253  39.997  1.00 13.98           C  
ATOM   1315  C   GLN A 162      -4.125  16.276  39.198  1.00 13.06           C  
ATOM   1316  O   GLN A 162      -3.016  16.638  39.583  1.00 10.83           O  
ATOM   1317  CB  GLN A 162      -6.193  15.877  40.563  1.00 14.73           C  
ATOM   1318  CG  GLN A 162      -7.174  14.831  41.079  1.00 17.40           C  
ATOM   1319  CD  GLN A 162      -7.685  13.930  39.970  1.00 18.01           C  
ATOM   1320  OE1 GLN A 162      -8.488  14.345  39.146  1.00 14.53           O  
ATOM   1321  NE2 GLN A 162      -7.203  12.690  39.939  1.00 21.11           N  
ATOM   1322  N   THR A 163      -4.683  16.736  38.085  1.00 13.17           N  
ATOM   1323  CA  THR A 163      -3.983  17.712  37.257  1.00 12.77           C  
ATOM   1324  C   THR A 163      -4.640  19.087  37.316  1.00 12.66           C  
ATOM   1325  O   THR A 163      -5.857  19.221  37.201  1.00 13.01           O  
ATOM   1326  CB  THR A 163      -3.908  17.240  35.791  1.00 12.56           C  
ATOM   1327  OG1 THR A 163      -3.156  16.021  35.725  1.00 14.46           O  
ATOM   1328  CG2 THR A 163      -3.226  18.294  34.926  1.00 12.63           C  
ATOM   1329  N   ASP A 164      -3.812  20.100  37.518  1.00 12.05           N  
ATOM   1330  CA  ASP A 164      -4.254  21.485  37.595  1.00 12.41           C  
ATOM   1331  C   ASP A 164      -3.792  22.164  36.307  1.00 10.57           C  
ATOM   1332  O   ASP A 164      -2.607  22.138  35.998  1.00 10.58           O  
ATOM   1333  CB  ASP A 164      -3.587  22.155  38.802  1.00 13.15           C  
ATOM   1334  CG  ASP A 164      -4.061  23.576  39.025  1.00 17.94           C  
ATOM   1335  OD1 ASP A 164      -3.441  24.286  39.847  1.00 20.32           O  
ATOM   1336  OD2 ASP A 164      -5.055  23.984  38.389  1.00 17.81           O  
ATOM   1337  N   LEU A 165      -4.710  22.759  35.553  1.00 10.67           N  
ATOM   1338  CA  LEU A 165      -4.322  23.438  34.323  1.00 10.24           C  
ATOM   1339  C   LEU A 165      -4.118  24.922  34.614  1.00 11.60           C  
ATOM   1340  O   LEU A 165      -4.934  25.551  35.299  1.00 12.96           O  
ATOM   1341  CB  LEU A 165      -5.405  23.275  33.251  1.00  8.59           C  
ATOM   1342  CG  LEU A 165      -5.866  21.839  32.946  1.00  8.85           C  
ATOM   1343  CD1 LEU A 165      -6.965  21.857  31.898  1.00 12.53           C  
ATOM   1344  CD2 LEU A 165      -4.685  21.017  32.460  1.00 10.72           C  
ATOM   1345  N   ILE A 166      -3.019  25.477  34.117  1.00  7.87           N  
ATOM   1346  CA  ILE A 166      -2.739  26.893  34.310  1.00  8.81           C  
ATOM   1347  C   ILE A 166      -3.222  27.579  33.039  1.00  9.36           C  
ATOM   1348  O   ILE A 166      -2.746  27.279  31.945  1.00  9.92           O  
ATOM   1349  CB  ILE A 166      -1.218  27.164  34.491  1.00  7.71           C  
ATOM   1350  CG1 ILE A 166      -0.698  26.463  35.754  1.00  9.80           C  
ATOM   1351  CG2 ILE A 166      -0.960  28.671  34.530  1.00  9.76           C  
ATOM   1352  CD1 ILE A 166      -1.385  26.877  37.057  1.00 13.00           C  
HETATM 1353  N   MSE A 167      -4.174  28.491  33.187  1.00  9.98           N  
HETATM 1354  CA  MSE A 167      -4.733  29.198  32.049  1.00 10.28           C  
HETATM 1355  C   MSE A 167      -4.526  30.693  32.244  1.00 10.44           C  
HETATM 1356  O   MSE A 167      -4.628  31.202  33.358  1.00 11.07           O  
HETATM 1357  CB  MSE A 167      -6.216  28.847  31.909  1.00 12.98           C  
HETATM 1358  CG  MSE A 167      -6.443  27.368  31.626  1.00 19.01           C  
HETATM 1359 SE   MSE A 167      -8.277  27.003  31.262  1.00 31.17          SE  
HETATM 1360  CE  MSE A 167      -8.255  27.411  29.373  1.00 19.71           C  
ATOM   1361  N   ALA A 168      -4.226  31.397  31.161  1.00  8.99           N  
ATOM   1362  CA  ALA A 168      -3.955  32.811  31.286  1.00  7.12           C  
ATOM   1363  C   ALA A 168      -4.285  33.614  30.048  1.00  7.40           C  
ATOM   1364  O   ALA A 168      -4.616  33.065  29.000  1.00  5.99           O  
ATOM   1365  CB  ALA A 168      -2.492  33.006  31.637  1.00  5.70           C  
ATOM   1366  N   LYS A 169      -4.174  34.928  30.190  1.00  8.69           N  
ATOM   1367  CA  LYS A 169      -4.426  35.849  29.102  1.00 10.68           C  
ATOM   1368  C   LYS A 169      -3.603  37.100  29.351  1.00 10.49           C  
ATOM   1369  O   LYS A 169      -3.517  37.595  30.479  1.00 10.11           O  
ATOM   1370  CB  LYS A 169      -5.914  36.198  29.026  1.00 14.39           C  
ATOM   1371  CG  LYS A 169      -6.276  37.070  27.842  1.00 21.15           C  
ATOM   1372  CD  LYS A 169      -7.782  37.242  27.686  1.00 25.07           C  
ATOM   1373  CE  LYS A 169      -8.405  37.982  28.850  1.00 27.96           C  
ATOM   1374  NZ  LYS A 169      -9.830  38.312  28.549  1.00 32.64           N  
ATOM   1375  N   THR A 170      -2.983  37.598  28.289  1.00  9.81           N  
ATOM   1376  CA  THR A 170      -2.174  38.798  28.379  1.00 12.28           C  
ATOM   1377  C   THR A 170      -3.075  40.002  28.171  1.00 13.46           C  
ATOM   1378  O   THR A 170      -3.926  40.004  27.287  1.00 13.36           O  
ATOM   1379  CB  THR A 170      -1.060  38.777  27.328  1.00 13.52           C  
ATOM   1380  OG1 THR A 170      -0.172  37.687  27.613  1.00 15.78           O  
ATOM   1381  CG2 THR A 170      -0.275  40.083  27.357  1.00 14.95           C  
ATOM   1382  N   LEU A 171      -2.894  41.020  29.002  1.00 14.94           N  
ATOM   1383  CA  LEU A 171      -3.706  42.227  28.914  1.00 15.04           C  
ATOM   1384  C   LEU A 171      -2.919  43.379  28.288  1.00 17.71           C  
ATOM   1385  O   LEU A 171      -2.182  43.187  27.320  1.00 19.59           O  
ATOM   1386  CB  LEU A 171      -4.191  42.605  30.314  1.00 13.86           C  
ATOM   1387  CG  LEU A 171      -4.810  41.434  31.093  1.00 13.87           C  
ATOM   1388  CD1 LEU A 171      -5.135  41.860  32.521  1.00 17.92           C  
ATOM   1389  CD2 LEU A 171      -6.054  40.954  30.382  1.00 16.33           C  
ATOM   1390  N   ILE A 172      -3.074  44.571  28.852  1.00 20.14           N  
ATOM   1391  CA  ILE A 172      -2.394  45.762  28.358  1.00 23.30           C  
ATOM   1392  C   ILE A 172      -0.896  45.719  28.639  1.00 23.84           C  
ATOM   1393  O   ILE A 172      -0.474  45.439  29.758  1.00 24.41           O  
ATOM   1394  CB  ILE A 172      -2.971  47.042  29.008  1.00 24.10           C  
ATOM   1395  CG1 ILE A 172      -2.622  47.088  30.504  1.00 27.78           C  
ATOM   1396  CG2 ILE A 172      -4.477  47.100  28.784  1.00 24.86           C  
ATOM   1397  CD1 ILE A 172      -3.085  45.881  31.328  1.00 22.97           C  
ATOM   1398  N   LEU A 173      -0.093  46.001  27.619  1.00 25.81           N  
ATOM   1399  CA  LEU A 173       1.358  45.997  27.781  1.00 27.67           C  
ATOM   1400  C   LEU A 173       1.959  47.379  27.536  1.00 30.37           C  
ATOM   1401  O   LEU A 173       3.142  47.605  27.786  1.00 29.90           O  
ATOM   1402  CB  LEU A 173       1.997  44.988  26.827  1.00 25.58           C  
ATOM   1403  CG  LEU A 173       1.674  43.508  27.055  1.00 24.83           C  
ATOM   1404  CD1 LEU A 173       2.328  42.685  25.963  1.00 23.21           C  
ATOM   1405  CD2 LEU A 173       2.168  43.067  28.434  1.00 21.53           C  
ATOM   1406  N   GLU A 174       1.139  48.301  27.042  1.00 34.84           N  
ATOM   1407  CA  GLU A 174       1.588  49.664  26.763  1.00 38.83           C  
ATOM   1408  C   GLU A 174       2.177  50.329  27.999  1.00 40.20           C  
ATOM   1409  O   GLU A 174       3.185  51.055  27.853  1.00 42.26           O  
ATOM   1410  CB  GLU A 174       0.424  50.494  26.216  1.00 40.13           C  
ATOM   1411  CG  GLU A 174      -0.823  50.485  27.092  1.00 43.72           C  
ATOM   1412  CD  GLU A 174      -0.745  51.459  28.250  1.00 44.90           C  
ATOM   1413  OE1 GLU A 174      -0.630  52.676  27.991  1.00 46.06           O  
ATOM   1414  OE2 GLU A 174      -0.807  51.011  29.417  1.00 45.76           O  
TER    1415      GLU A 174                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
