
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  164 ( 1288),  selected  164 , name 2ge3_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 2ge3_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     6_A      -       -           -
LGA    T     7_A      A       2          1.620
LGA    V     8_A      I       3          1.689
LGA    T     9_A      N       4          1.219
LGA    I    10_A      I       5          1.175
LGA    K    11_A      I       6          1.633
LGA    P    12_A      E       7          1.732
LGA    I    13_A      Y       8          1.521
LGA    R    14_A      N       9          2.086
LGA    A    15_A      R      10          2.599
LGA    E    16_A      S      11          2.493
LGA    H    17_A      Y      12          2.293
LGA    V    18_A      K      13          2.114
LGA    E    19_A      E      14          2.654
LGA    S    20_A      E      15          2.055
LGA    F    21_A      L      16          1.281
LGA    H    22_A      I      17          1.690
LGA    R    23_A      E      18          1.872
LGA    A    24_A      F      19          1.133
LGA    L    25_A      I      20          1.635
LGA    D    26_A      L      21          2.135
LGA    A    27_A      S      22          1.464
LGA    V    28_A      I      23          1.644
LGA    S    29_A      Q      24          2.277
LGA    R    30_A      K      25          1.673
LGA    E    31_A      N      26          2.732
LGA    -       -      E      27           -
LGA    -       -      F      28           -
LGA    R    32_A      N      29          2.193
LGA    K    33_A      I      30          4.154
LGA    Y    34_A      -       -           -
LGA    L    35_A      -       -           -
LGA    S    36_A      -       -           -
LGA    F    37_A      K      31           #
LGA    L    38_A      I      32          1.780
LGA    E    39_A      D      33          2.580
LGA    A    40_A      R      34          2.724
LGA    P    41_A      D      35          4.060
LGA    P    42_A      D      36           -
LGA    L    43_A      Q      37           -
LGA    E    44_A      -       -           -
LGA    A    45_A      P      38          4.820
LGA    -       -      D      39           -
LGA    V    46_A      L      40          2.832
LGA    R    47_A      E      41          3.843
LGA    A    48_A      N      42          2.229
LGA    F    49_A      I      43          3.341
LGA    V    50_A      E      44          3.005
LGA    L    51_A      H      45          3.839
LGA    D    52_A      N      46          4.023
LGA    X    53_A      Y      47          2.282
LGA    I    54_A      L      48          2.450
LGA    E    55_A      N      49          2.464
LGA    N    56_A      S      50          3.000
LGA    D    57_A      G      51          3.463
LGA    H    58_A      G      52          1.003
LGA    P    59_A      Q      53          1.569
LGA    Q    60_A      F      54          1.237
LGA    F    61_A      W      55          0.659
LGA    V    62_A      L      56          0.519
LGA    A    63_A      A      57          0.850
LGA    I    64_A      I      58          0.757
LGA    A    65_A      N      59          1.635
LGA    D    66_A      N      60          3.652
LGA    G    67_A      H      61          3.581
LGA    -       -      Q      62           -
LGA    D    68_A      N      63          1.256
LGA    V    69_A      I      64          1.373
LGA    I    70_A      V      65          1.925
LGA    G    71_A      G      66          1.406
LGA    W    72_A      T      67          0.505
LGA    C    73_A      I      68          0.554
LGA    D    74_A      G      69          0.689
LGA    I    75_A      L      70          0.816
LGA    R    76_A      I      71          1.196
LGA    R    77_A      R      72          1.627
LGA    Q    78_A      L      73          2.152
LGA    D    79_A      -       -           -
LGA    R    80_A      -       -           -
LGA    A    81_A      -       -           -
LGA    T    82_A      -       -           -
LGA    R    83_A      D      74          3.323
LGA    A    84_A      N      75          3.658
LGA    H    85_A      N      76          1.189
LGA    C    86_A      M      77          1.491
LGA    G    87_A      S      78          1.142
LGA    T    88_A      A      79          1.148
LGA    L    89_A      L      80          0.670
LGA    G    90_A      K      81          1.768
LGA    -       -      K      82           -
LGA    X    91_A      M      83          0.759
LGA    G    92_A      F      84          1.086
LGA    I    93_A      V      85          1.636
LGA    L    94_A      D      86          2.007
LGA    P    95_A      K      87          1.497
LGA    A    96_A      G      88          1.396
LGA    Y    97_A      Y      89          1.582
LGA    R    98_A      R      90          1.757
LGA    N    99_A      N      91          3.419
LGA    K   100_A      L      92          2.758
LGA    G   101_A      K      93          1.342
LGA    L   102_A      I      94          0.969
LGA    G   103_A      G      95          0.742
LGA    A   104_A      K      96          1.032
LGA    R   105_A      K      97          0.920
LGA    L   106_A      L      98          0.605
LGA    X   107_A      L      99          0.806
LGA    R   108_A      D     100          0.884
LGA    R   109_A      K     101          0.584
LGA    T   110_A      V     102          1.390
LGA    L   111_A      I     103          1.876
LGA    D   112_A      M     104          1.542
LGA    A   113_A      T     105          1.128
LGA    A   114_A      C     106          1.987
LGA    H   115_A      K     107          2.396
LGA    E   116_A      E     108          1.577
LGA    F   117_A      Q     109          1.806
LGA    G   118_A      N     110          2.419
LGA    L   119_A      I     111          1.502
LGA    H   120_A      D     112          1.044
LGA    R   121_A      G     113          1.733
LGA    I   122_A      I     114          0.342
LGA    E   123_A      Y     115          0.573
LGA    L   124_A      L     116          0.936
LGA    S   125_A      G     117          1.907
LGA    V   126_A      T     118          2.512
LGA    H   127_A      I     119          2.286
LGA    A   128_A      D     120          3.101
LGA    D   129_A      K     121          4.599
LGA    N   130_A      F     122          2.924
LGA    A   131_A      I     123          2.896
LGA    R   132_A      S     124          0.902
LGA    A   133_A      A     125          0.608
LGA    I   134_A      Q     126          1.309
LGA    A   135_A      Y     127          1.324
LGA    L   136_A      F     128          1.007
LGA    Y   137_A      Y     129          0.759
LGA    E   138_A      S     130          1.507
LGA    K   139_A      N     131          1.639
LGA    I   140_A      N     132          1.261
LGA    G   141_A      G     133          0.923
LGA    F   142_A      F     134          0.818
LGA    A   143_A      R     135          1.372
LGA    H   144_A      E     136          1.825
LGA    E   145_A      I     137          1.966
LGA    G   146_A      K     138          3.567
LGA    R   147_A      -       -           -
LGA    A   148_A      R     139          5.523
LGA    R   149_A      G     140           -
LGA    D   150_A      D     141           -
LGA    -       -      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    -       -      K     148           -
LGA    -       -      L     149           -
LGA    A   151_A      D     150           #
LGA    V   152_A      V     151          4.303
LGA    S   153_A      -       -           -
LGA    I   154_A      -       -           -
LGA    D   155_A      -       -           -
LGA    G   156_A      -       -           -
LGA    H   157_A      -       -           -
LGA    Y   158_A      -       -           -
LGA    I   159_A      -       -           -
LGA    D   160_A      -       -           -
LGA    S   161_A      D     152           #
LGA    -       -      N     153           -
LGA    L   162_A      R     154          2.359
LGA    N   163_A      F     155          1.675
LGA    X   164_A      Y     156          0.988
LGA    A   165_A      Y     157          0.315
LGA    I   166_A      R     158          0.684
LGA    I   167_A      N     159          1.093
LGA    F   168_A      L     160          1.013
LGA    G   169_A      K     161          2.060

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  164  160    5.0    139    2.12    14.39     70.829     6.262

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.127293 * X  +   0.823293 * Y  +   0.553159 * Z  + -49.812271
  Y_new =  -0.044963 * X  +   0.552333 * Y  +  -0.832410 * Z  +  20.067348
  Z_new =  -0.990846 * X  +  -0.130832 * Y  +  -0.033291 * Z  +  81.848412 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.819962    1.321631  [ DEG:  -104.2761     75.7239 ]
  Theta =   1.435382    1.706210  [ DEG:    82.2413     97.7587 ]
  Phi   =  -2.802050    0.339543  [ DEG:  -160.5456     19.4544 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ge3_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ge3_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  164  160   5.0  139   2.12   14.39  70.829
REMARK  ---------------------------------------------------------- 
MOLECULE 2ge3_A
HEADER    TRANSFERASE                             17-MAR-06   2GE3              
TITLE     CRYSTAL STRUCTURE OF PROBABLE ACETYLTRANSFERASE FROM                  
TITLE    2 AGROBACTERIUM TUMEFACIENS                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROBABLE ACETYLTRANSFERASE;                                
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)                                  
KEYWDS    ACETYLTRANSFERASE, AGROBACTERIUM TUMEFACIENS, STRUCTURAL              
KEYWDS   2 GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER          
KEYWDS   3 FOR STRUCTURAL GENOMICS, MCSG                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.CHANG,X.XU,J.GU,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK,                 
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   18-APR-06 2GE3    0                                                
JRNL        AUTH   C.CHANG,X.XU,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK              
JRNL        TITL   CRYSTAL STRUCTURE OF PROBABLE ACETYLTRANSFERASE              
JRNL        TITL 2 FROM AGROBACTERIUM TUMEFACIENS                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.25 ANGSTROMS.                                          
DBREF  2GE3 A    1   170  UNP    Q8UD38   Q8UD38_AGRT5     1    170             
DBREF  2GE3 B    1   170  UNP    Q8UD38   Q8UD38_AGRT5     1    170             
DBREF  2GE3 C    1   170  UNP    Q8UD38   Q8UD38_AGRT5     1    170             
DBREF  2GE3 D    1   170  UNP    Q8UD38   Q8UD38_AGRT5     1    170             
SEQRES   1 A  170  MSE MSE ALA LEU ASP ASP THR VAL THR ILE LYS PRO ILE          
SEQRES   2 A  170  ARG ALA GLU HIS VAL GLU SER PHE HIS ARG ALA LEU ASP          
SEQRES   3 A  170  ALA VAL SER ARG GLU ARG LYS TYR LEU SER PHE LEU GLU          
SEQRES   4 A  170  ALA PRO PRO LEU GLU ALA VAL ARG ALA PHE VAL LEU ASP          
SEQRES   5 A  170  MSE ILE GLU ASN ASP HIS PRO GLN PHE VAL ALA ILE ALA          
SEQRES   6 A  170  ASP GLY ASP VAL ILE GLY TRP CYS ASP ILE ARG ARG GLN          
SEQRES   7 A  170  ASP ARG ALA THR ARG ALA HIS CYS GLY THR LEU GLY MSE          
SEQRES   8 A  170  GLY ILE LEU PRO ALA TYR ARG ASN LYS GLY LEU GLY ALA          
SEQRES   9 A  170  ARG LEU MSE ARG ARG THR LEU ASP ALA ALA HIS GLU PHE          
SEQRES  10 A  170  GLY LEU HIS ARG ILE GLU LEU SER VAL HIS ALA ASP ASN          
SEQRES  11 A  170  ALA ARG ALA ILE ALA LEU TYR GLU LYS ILE GLY PHE ALA          
SEQRES  12 A  170  HIS GLU GLY ARG ALA ARG ASP ALA VAL SER ILE ASP GLY          
SEQRES  13 A  170  HIS TYR ILE ASP SER LEU ASN MSE ALA ILE ILE PHE GLY          
SEQRES  14 A  170  ASN                                                          
SEQRES   1 B  170  MSE MSE ALA LEU ASP ASP THR VAL THR ILE LYS PRO ILE          
SEQRES   2 B  170  ARG ALA GLU HIS VAL GLU SER PHE HIS ARG ALA LEU ASP          
SEQRES   3 B  170  ALA VAL SER ARG GLU ARG LYS TYR LEU SER PHE LEU GLU          
SEQRES   4 B  170  ALA PRO PRO LEU GLU ALA VAL ARG ALA PHE VAL LEU ASP          
SEQRES   5 B  170  MSE ILE GLU ASN ASP HIS PRO GLN PHE VAL ALA ILE ALA          
SEQRES   6 B  170  ASP GLY ASP VAL ILE GLY TRP CYS ASP ILE ARG ARG GLN          
SEQRES   7 B  170  ASP ARG ALA THR ARG ALA HIS CYS GLY THR LEU GLY MSE          
SEQRES   8 B  170  GLY ILE LEU PRO ALA TYR ARG ASN LYS GLY LEU GLY ALA          
SEQRES   9 B  170  ARG LEU MSE ARG ARG THR LEU ASP ALA ALA HIS GLU PHE          
SEQRES  10 B  170  GLY LEU HIS ARG ILE GLU LEU SER VAL HIS ALA ASP ASN          
SEQRES  11 B  170  ALA ARG ALA ILE ALA LEU TYR GLU LYS ILE GLY PHE ALA          
SEQRES  12 B  170  HIS GLU GLY ARG ALA ARG ASP ALA VAL SER ILE ASP GLY          
SEQRES  13 B  170  HIS TYR ILE ASP SER LEU ASN MSE ALA ILE ILE PHE GLY          
SEQRES  14 B  170  ASN                                                          
SEQRES   1 C  170  MSE MSE ALA LEU ASP ASP THR VAL THR ILE LYS PRO ILE          
SEQRES   2 C  170  ARG ALA GLU HIS VAL GLU SER PHE HIS ARG ALA LEU ASP          
SEQRES   3 C  170  ALA VAL SER ARG GLU ARG LYS TYR LEU SER PHE LEU GLU          
SEQRES   4 C  170  ALA PRO PRO LEU GLU ALA VAL ARG ALA PHE VAL LEU ASP          
SEQRES   5 C  170  MSE ILE GLU ASN ASP HIS PRO GLN PHE VAL ALA ILE ALA          
SEQRES   6 C  170  ASP GLY ASP VAL ILE GLY TRP CYS ASP ILE ARG ARG GLN          
SEQRES   7 C  170  ASP ARG ALA THR ARG ALA HIS CYS GLY THR LEU GLY MSE          
SEQRES   8 C  170  GLY ILE LEU PRO ALA TYR ARG ASN LYS GLY LEU GLY ALA          
SEQRES   9 C  170  ARG LEU MSE ARG ARG THR LEU ASP ALA ALA HIS GLU PHE          
SEQRES  10 C  170  GLY LEU HIS ARG ILE GLU LEU SER VAL HIS ALA ASP ASN          
SEQRES  11 C  170  ALA ARG ALA ILE ALA LEU TYR GLU LYS ILE GLY PHE ALA          
SEQRES  12 C  170  HIS GLU GLY ARG ALA ARG ASP ALA VAL SER ILE ASP GLY          
SEQRES  13 C  170  HIS TYR ILE ASP SER LEU ASN MSE ALA ILE ILE PHE GLY          
SEQRES  14 C  170  ASN                                                          
SEQRES   1 D  170  MSE MSE ALA LEU ASP ASP THR VAL THR ILE LYS PRO ILE          
SEQRES   2 D  170  ARG ALA GLU HIS VAL GLU SER PHE HIS ARG ALA LEU ASP          
SEQRES   3 D  170  ALA VAL SER ARG GLU ARG LYS TYR LEU SER PHE LEU GLU          
SEQRES   4 D  170  ALA PRO PRO LEU GLU ALA VAL ARG ALA PHE VAL LEU ASP          
SEQRES   5 D  170  MSE ILE GLU ASN ASP HIS PRO GLN PHE VAL ALA ILE ALA          
SEQRES   6 D  170  ASP GLY ASP VAL ILE GLY TRP CYS ASP ILE ARG ARG GLN          
SEQRES   7 D  170  ASP ARG ALA THR ARG ALA HIS CYS GLY THR LEU GLY MSE          
SEQRES   8 D  170  GLY ILE LEU PRO ALA TYR ARG ASN LYS GLY LEU GLY ALA          
SEQRES   9 D  170  ARG LEU MSE ARG ARG THR LEU ASP ALA ALA HIS GLU PHE          
SEQRES  10 D  170  GLY LEU HIS ARG ILE GLU LEU SER VAL HIS ALA ASP ASN          
SEQRES  11 D  170  ALA ARG ALA ILE ALA LEU TYR GLU LYS ILE GLY PHE ALA          
SEQRES  12 D  170  HIS GLU GLY ARG ALA ARG ASP ALA VAL SER ILE ASP GLY          
SEQRES  13 D  170  HIS TYR ILE ASP SER LEU ASN MSE ALA ILE ILE PHE GLY          
SEQRES  14 D  170  ASN                                                          
HET    MSE  A  53       8                                                       
HET    MSE  A  91       8                                                       
HET    MSE  A 107       8                                                       
HET    MSE  A 164       8                                                       
HET    MSE  B  53       8                                                       
HET    MSE  B  91       8                                                       
HET    MSE  B 107       8                                                       
HET    MSE  B 164       8                                                       
HET    MSE  C  53       8                                                       
HET    MSE  C  91       8                                                       
HET    MSE  C 107       8                                                       
HET    MSE  C 164       8                                                       
HET    MSE  D  53       8                                                       
HET    MSE  D  91       8                                                       
HET    MSE  D 107       8                                                       
HET    MSE  D 164       8                                                       
HET    ACO   1301      51                                                       
HET    ACO   1302      51                                                       
HET    ACO   1303      51                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACO ACETYL COENZYME *A                                               
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   5  ACO    3(C23 H38 N7 O17 P3 S)                                       
FORMUL   8  HOH   *375(H2 O)                                                    
CRYST1   79.906   90.796  103.789  90.00  90.00  90.00 P 21 21 21   16          
ATOM      1  N   ASP A   6     -35.191  38.054  37.675  1.00 59.95           N  
ATOM      2  CA  ASP A   6     -34.846  38.434  39.069  1.00 59.85           C  
ATOM      3  C   ASP A   6     -33.355  38.869  39.163  1.00 60.08           C  
ATOM      4  O   ASP A   6     -32.436  38.035  38.944  1.00 60.77           O  
ATOM      5  CB  ASP A   6     -35.224  37.284  40.061  1.00 60.73           C  
ATOM      6  N   THR A   7     -33.127  40.173  39.454  1.00 58.80           N  
ATOM      7  CA  THR A   7     -31.819  40.832  39.226  1.00 56.70           C  
ATOM      8  C   THR A   7     -30.595  40.354  40.056  1.00 54.70           C  
ATOM      9  O   THR A   7     -30.667  40.192  41.281  1.00 55.67           O  
ATOM     10  CB  THR A   7     -31.943  42.351  39.198  1.00 57.67           C  
ATOM     11  OG1 THR A   7     -31.384  42.848  37.972  1.00 55.75           O  
ATOM     12  CG2 THR A   7     -31.279  43.054  40.438  1.00 60.00           C  
ATOM     13  N   VAL A   8     -29.502  40.052  39.357  1.00 50.53           N  
ATOM     14  CA  VAL A   8     -28.201  39.890  40.005  1.00 45.93           C  
ATOM     15  C   VAL A   8     -27.400  41.156  39.840  1.00 43.78           C  
ATOM     16  O   VAL A   8     -27.359  41.726  38.760  1.00 42.52           O  
ATOM     17  CB  VAL A   8     -27.409  38.703  39.470  1.00 45.47           C  
ATOM     18  CG1 VAL A   8     -26.027  38.692  40.035  1.00 41.76           C  
ATOM     19  CG2 VAL A   8     -28.110  37.412  39.865  1.00 45.50           C  
ATOM     20  N   THR A   9     -26.814  41.617  40.939  1.00 41.36           N  
ATOM     21  CA  THR A   9     -25.838  42.716  40.907  1.00 40.09           C  
ATOM     22  C   THR A   9     -24.485  42.262  41.344  1.00 37.93           C  
ATOM     23  O   THR A   9     -24.355  41.455  42.285  1.00 36.02           O  
ATOM     24  CB  THR A   9     -26.291  43.844  41.785  1.00 40.42           C  
ATOM     25  OG1 THR A   9     -27.608  44.162  41.344  1.00 45.40           O  
ATOM     26  CG2 THR A   9     -25.436  45.090  41.562  1.00 39.75           C  
ATOM     27  N   ILE A  10     -23.475  42.749  40.611  1.00 37.32           N  
ATOM     28  CA  ILE A  10     -22.061  42.448  40.882  1.00 35.83           C  
ATOM     29  C   ILE A  10     -21.422  43.695  41.499  1.00 35.20           C  
ATOM     30  O   ILE A  10     -21.546  44.759  40.983  1.00 33.58           O  
ATOM     31  CB  ILE A  10     -21.366  42.040  39.573  1.00 36.19           C  
ATOM     32  CG1 ILE A  10     -21.904  40.680  39.115  1.00 38.19           C  
ATOM     33  CG2 ILE A  10     -19.823  42.082  39.737  1.00 36.05           C  
ATOM     34  CD1 ILE A  10     -21.725  40.423  37.730  1.00 38.97           C  
ATOM     35  N   LYS A  11     -20.729  43.564  42.611  1.00 35.14           N  
ATOM     36  CA  LYS A  11     -20.119  44.721  43.248  1.00 35.82           C  
ATOM     37  C   LYS A  11     -18.864  44.243  43.972  1.00 35.17           C  
ATOM     38  O   LYS A  11     -18.750  43.038  44.246  1.00 33.26           O  
ATOM     39  CB  LYS A  11     -21.096  45.332  44.252  1.00 35.10           C  
ATOM     40  CG  LYS A  11     -21.622  44.269  45.195  1.00 37.64           C  
ATOM     41  CD  LYS A  11     -22.838  44.731  45.955  1.00 43.84           C  
ATOM     42  CE  LYS A  11     -23.951  45.239  45.031  1.00 43.49           C  
ATOM     43  NZ  LYS A  11     -25.293  44.870  45.598  1.00 48.99           N  
ATOM     44  N   PRO A  12     -17.923  45.182  44.276  1.00 34.65           N  
ATOM     45  CA  PRO A  12     -16.761  44.820  45.120  1.00 34.31           C  
ATOM     46  C   PRO A  12     -17.245  44.294  46.446  1.00 34.11           C  
ATOM     47  O   PRO A  12     -18.317  44.640  46.903  1.00 35.56           O  
ATOM     48  CB  PRO A  12     -15.921  46.136  45.222  1.00 34.73           C  
ATOM     49  CG  PRO A  12     -16.368  46.923  43.990  1.00 34.03           C  
ATOM     50  CD  PRO A  12     -17.882  46.586  43.838  1.00 33.52           C  
ATOM     51  N   ILE A  13     -16.544  43.342  47.009  1.00 34.38           N  
ATOM     52  CA  ILE A  13     -16.972  42.795  48.274  1.00 35.14           C  
ATOM     53  C   ILE A  13     -16.756  43.854  49.406  1.00 36.89           C  
ATOM     54  O   ILE A  13     -15.754  44.640  49.409  1.00 35.56           O  
ATOM     55  CB  ILE A  13     -16.254  41.463  48.583  1.00 34.85           C  
ATOM     56  CG1 ILE A  13     -17.023  40.684  49.677  1.00 34.34           C  
ATOM     57  CG2 ILE A  13     -14.785  41.743  48.963  1.00 29.39           C  
ATOM     58  CD1 ILE A  13     -16.634  39.111  49.819  1.00 33.33           C  
ATOM     59  N   ARG A  14     -17.712  43.890  50.346  1.00 37.77           N  
ATOM     60  CA  ARG A  14     -17.569  44.707  51.543  1.00 38.98           C  
ATOM     61  C   ARG A  14     -17.623  43.820  52.796  1.00 40.12           C  
ATOM     62  O   ARG A  14     -18.074  42.646  52.736  1.00 40.04           O  
ATOM     63  CB  ARG A  14     -18.663  45.757  51.548  1.00 39.09           C  
ATOM     64  CG  ARG A  14     -18.580  46.756  50.357  1.00 39.94           C  
ATOM     65  CD  ARG A  14     -19.561  47.982  50.499  1.00 41.38           C  
ATOM     66  NE  ARG A  14     -20.920  47.564  50.829  1.00 46.60           N  
ATOM     67  CZ  ARG A  14     -21.922  47.344  49.966  1.00 49.28           C  
ATOM     68  NH1 ARG A  14     -21.770  47.527  48.656  1.00 51.91           N  
ATOM     69  NH2 ARG A  14     -23.109  46.968  50.428  1.00 46.76           N  
ATOM     70  N   ALA A  15     -17.160  44.372  53.925  1.00 40.78           N  
ATOM     71  CA  ALA A  15     -17.163  43.701  55.241  1.00 41.59           C  
ATOM     72  C   ALA A  15     -18.472  42.955  55.590  1.00 42.11           C  
ATOM     73  O   ALA A  15     -18.443  41.884  56.201  1.00 42.32           O  
ATOM     74  CB  ALA A  15     -16.815  44.714  56.385  1.00 41.73           C  
ATOM     75  N   GLU A  16     -19.611  43.548  55.247  1.00 41.49           N  
ATOM     76  CA  GLU A  16     -20.910  42.956  55.538  1.00 40.70           C  
ATOM     77  C   GLU A  16     -21.195  41.595  54.791  1.00 40.46           C  
ATOM     78  O   GLU A  16     -21.963  40.760  55.277  1.00 39.86           O  
ATOM     79  CB  GLU A  16     -21.952  43.982  55.165  1.00 40.73           C  
ATOM     80  CG  GLU A  16     -22.187  44.078  53.691  1.00 45.83           C  
ATOM     81  CD  GLU A  16     -22.986  45.304  53.336  1.00 52.19           C  
ATOM     82  OE1 GLU A  16     -22.346  46.323  52.992  1.00 53.17           O  
ATOM     83  OE2 GLU A  16     -24.249  45.248  53.441  1.00 54.99           O  
ATOM     84  N   HIS A  17     -20.559  41.395  53.627  1.00 38.50           N  
ATOM     85  CA  HIS A  17     -20.726  40.198  52.762  1.00 38.62           C  
ATOM     86  C   HIS A  17     -20.026  38.967  53.315  1.00 37.82           C  
ATOM     87  O   HIS A  17     -20.324  37.871  52.884  1.00 37.24           O  
ATOM     88  CB  HIS A  17     -20.174  40.477  51.328  1.00 37.84           C  
ATOM     89  CG  HIS A  17     -20.850  41.627  50.643  1.00 35.39           C  
ATOM     90  ND1 HIS A  17     -22.225  41.765  50.622  1.00 37.64           N  
ATOM     91  CD2 HIS A  17     -20.356  42.727  50.020  1.00 32.05           C  
ATOM     92  CE1 HIS A  17     -22.550  42.866  49.959  1.00 35.32           C  
ATOM     93  NE2 HIS A  17     -21.433  43.465  49.578  1.00 31.98           N  
ATOM     94  N   VAL A  18     -19.123  39.145  54.292  1.00 37.91           N  
ATOM     95  CA  VAL A  18     -18.276  38.044  54.775  1.00 39.01           C  
ATOM     96  C   VAL A  18     -18.991  36.694  55.135  1.00 38.79           C  
ATOM     97  O   VAL A  18     -18.586  35.601  54.670  1.00 38.05           O  
ATOM     98  CB  VAL A  18     -17.407  38.539  55.942  1.00 39.51           C  
ATOM     99  CG1 VAL A  18     -16.837  37.393  56.769  1.00 36.48           C  
ATOM    100  CG2 VAL A  18     -16.294  39.432  55.404  1.00 41.48           C  
ATOM    101  N   GLU A  19     -20.020  36.785  55.979  1.00 37.62           N  
ATOM    102  CA  GLU A  19     -20.869  35.656  56.337  1.00 38.01           C  
ATOM    103  C   GLU A  19     -21.674  34.985  55.184  1.00 36.89           C  
ATOM    104  O   GLU A  19     -21.611  33.776  55.033  1.00 35.69           O  
ATOM    105  CB  GLU A  19     -21.775  36.006  57.525  1.00 38.65           C  
ATOM    106  CG  GLU A  19     -21.072  36.614  58.759  1.00 44.54           C  
ATOM    107  CD  GLU A  19     -20.575  38.122  58.630  1.00 52.25           C  
ATOM    108  OE1 GLU A  19     -20.828  38.847  57.606  1.00 54.55           O  
ATOM    109  OE2 GLU A  19     -19.903  38.575  59.606  1.00 53.77           O  
ATOM    110  N   SER A  20     -22.462  35.740  54.413  1.00 37.08           N  
ATOM    111  CA  SER A  20     -23.042  35.256  53.136  1.00 36.58           C  
ATOM    112  C   SER A  20     -22.013  34.591  52.107  1.00 36.54           C  
ATOM    113  O   SER A  20     -22.268  33.510  51.511  1.00 36.72           O  
ATOM    114  CB  SER A  20     -23.706  36.440  52.473  1.00 36.14           C  
ATOM    115  OG  SER A  20     -24.676  35.995  51.566  1.00 38.14           O  
ATOM    116  N   PHE A  21     -20.875  35.248  51.931  1.00 34.71           N  
ATOM    117  CA  PHE A  21     -19.755  34.749  51.156  1.00 35.21           C  
ATOM    118  C   PHE A  21     -19.193  33.426  51.678  1.00 34.75           C  
ATOM    119  O   PHE A  21     -18.917  32.513  50.913  1.00 35.62           O  
ATOM    120  CB  PHE A  21     -18.666  35.859  51.029  1.00 34.81           C  
ATOM    121  CG  PHE A  21     -17.370  35.375  50.450  1.00 34.32           C  
ATOM    122  CD1 PHE A  21     -17.316  34.786  49.158  1.00 35.60           C  
ATOM    123  CD2 PHE A  21     -16.203  35.477  51.163  1.00 36.09           C  
ATOM    124  CE1 PHE A  21     -16.113  34.259  48.619  1.00 33.40           C  
ATOM    125  CE2 PHE A  21     -14.919  34.965  50.590  1.00 36.98           C  
ATOM    126  CZ  PHE A  21     -14.916  34.353  49.336  1.00 35.87           C  
ATOM    127  N   HIS A  22     -19.081  33.274  52.982  1.00 35.57           N  
ATOM    128  CA  HIS A  22     -18.542  32.065  53.544  1.00 35.10           C  
ATOM    129  C   HIS A  22     -19.484  30.909  53.316  1.00 36.25           C  
ATOM    130  O   HIS A  22     -19.005  29.782  53.103  1.00 35.61           O  
ATOM    131  CB  HIS A  22     -18.360  32.250  55.046  1.00 37.36           C  
ATOM    132  CG  HIS A  22     -18.105  30.981  55.803  1.00 36.82           C  
ATOM    133  ND1 HIS A  22     -16.870  30.359  55.822  1.00 37.16           N  
ATOM    134  CD2 HIS A  22     -18.917  30.230  56.596  1.00 39.74           C  
ATOM    135  CE1 HIS A  22     -16.929  29.294  56.607  1.00 35.66           C  
ATOM    136  NE2 HIS A  22     -18.162  29.173  57.068  1.00 36.08           N  
ATOM    137  N   ARG A  23     -20.806  31.157  53.427  1.00 35.24           N  
ATOM    138  CA  ARG A  23     -21.820  30.153  53.069  1.00 36.17           C  
ATOM    139  C   ARG A  23     -21.801  29.697  51.600  1.00 35.87           C  
ATOM    140  O   ARG A  23     -22.002  28.519  51.322  1.00 37.43           O  
ATOM    141  CB  ARG A  23     -23.222  30.638  53.414  1.00 34.89           C  
ATOM    142  CG  ARG A  23     -23.354  30.926  54.888  1.00 39.93           C  
ATOM    143  CD  ARG A  23     -24.798  31.153  55.333  1.00 43.93           C  
ATOM    144  NE  ARG A  23     -25.404  32.401  54.878  1.00 47.90           N  
ATOM    145  CZ  ARG A  23     -25.421  33.528  55.593  1.00 50.79           C  
ATOM    146  NH1 ARG A  23     -24.822  33.591  56.787  1.00 52.95           N  
ATOM    147  NH2 ARG A  23     -26.032  34.600  55.120  1.00 51.86           N  
ATOM    148  N   ALA A  24     -21.629  30.642  50.677  1.00 36.16           N  
ATOM    149  CA  ALA A  24     -21.490  30.428  49.218  1.00 34.89           C  
ATOM    150  C   ALA A  24     -20.279  29.548  48.936  1.00 35.26           C  
ATOM    151  O   ALA A  24     -20.363  28.559  48.249  1.00 33.43           O  
ATOM    152  CB  ALA A  24     -21.297  31.787  48.559  1.00 36.20           C  
ATOM    153  N   LEU A  25     -19.167  29.902  49.563  1.00 35.86           N  
ATOM    154  CA  LEU A  25     -17.928  29.228  49.402  1.00 38.90           C  
ATOM    155  C   LEU A  25     -18.042  27.804  50.005  1.00 38.49           C  
ATOM    156  O   LEU A  25     -17.578  26.780  49.449  1.00 38.02           O  
ATOM    157  CB  LEU A  25     -16.825  30.106  50.033  1.00 38.25           C  
ATOM    158  CG  LEU A  25     -15.383  29.668  50.092  1.00 44.31           C  
ATOM    159  CD1 LEU A  25     -14.783  29.428  48.704  1.00 47.84           C  
ATOM    160  CD2 LEU A  25     -14.567  30.729  50.801  1.00 43.95           C  
ATOM    161  N   ASP A  26     -18.713  27.726  51.129  1.00 38.27           N  
ATOM    162  CA  ASP A  26     -18.899  26.447  51.770  1.00 37.15           C  
ATOM    163  C   ASP A  26     -19.828  25.491  50.973  1.00 36.28           C  
ATOM    164  O   ASP A  26     -19.520  24.294  50.830  1.00 35.02           O  
ATOM    165  CB  ASP A  26     -19.433  26.698  53.173  1.00 37.93           C  
ATOM    166  CG  ASP A  26     -19.293  25.504  54.051  1.00 42.09           C  
ATOM    167  OD1 ASP A  26     -18.165  24.941  54.160  1.00 42.35           O  
ATOM    168  OD2 ASP A  26     -20.351  25.086  54.563  1.00 47.02           O  
ATOM    169  N   ALA A  27     -20.948  26.024  50.463  1.00 36.01           N  
ATOM    170  CA  ALA A  27     -21.878  25.285  49.576  1.00 35.64           C  
ATOM    171  C   ALA A  27     -21.179  24.748  48.303  1.00 35.67           C  
ATOM    172  O   ALA A  27     -21.266  23.585  48.007  1.00 36.01           O  
ATOM    173  CB  ALA A  27     -23.070  26.151  49.209  1.00 35.00           C  
ATOM    174  N   VAL A  28     -20.484  25.586  47.550  1.00 35.14           N  
ATOM    175  CA  VAL A  28     -19.786  25.145  46.344  1.00 34.17           C  
ATOM    176  C   VAL A  28     -18.608  24.174  46.626  1.00 34.62           C  
ATOM    177  O   VAL A  28     -18.384  23.195  45.852  1.00 33.92           O  
ATOM    178  CB  VAL A  28     -19.340  26.369  45.467  1.00 33.51           C  
ATOM    179  CG1 VAL A  28     -18.540  25.966  44.291  1.00 31.53           C  
ATOM    180  CG2 VAL A  28     -20.586  27.275  45.034  1.00 35.12           C  
ATOM    181  N   SER A  29     -17.849  24.417  47.702  1.00 36.30           N  
ATOM    182  CA  SER A  29     -16.653  23.547  48.040  1.00 37.42           C  
ATOM    183  C   SER A  29     -17.141  22.136  48.370  1.00 37.69           C  
ATOM    184  O   SER A  29     -16.515  21.109  47.931  1.00 37.51           O  
ATOM    185  CB  SER A  29     -15.848  24.076  49.212  1.00 36.96           C  
ATOM    186  OG  SER A  29     -15.477  25.418  48.963  1.00 45.16           O  
ATOM    187  N   ARG A  30     -18.253  22.100  49.090  1.00 36.32           N  
ATOM    188  CA  ARG A  30     -18.814  20.812  49.639  1.00 39.66           C  
ATOM    189  C   ARG A  30     -19.435  19.879  48.602  1.00 39.37           C  
ATOM    190  O   ARG A  30     -19.756  18.731  48.875  1.00 41.31           O  
ATOM    191  CB  ARG A  30     -19.758  21.067  50.830  1.00 38.19           C  
ATOM    192  CG  ARG A  30     -18.996  21.525  52.106  1.00 41.61           C  
ATOM    193  CD  ARG A  30     -19.906  21.672  53.359  1.00 42.06           C  
ATOM    194  NE  ARG A  30     -21.288  21.871  52.976  1.00 53.57           N  
ATOM    195  CZ  ARG A  30     -22.367  21.490  53.675  1.00 58.87           C  
ATOM    196  NH1 ARG A  30     -22.259  20.813  54.817  1.00 58.58           N  
ATOM    197  NH2 ARG A  30     -23.580  21.760  53.188  1.00 60.80           N  
ATOM    198  N   GLU A  31     -19.571  20.379  47.394  1.00 40.63           N  
ATOM    199  CA  GLU A  31     -19.969  19.589  46.258  1.00 41.50           C  
ATOM    200  C   GLU A  31     -18.851  18.688  45.878  1.00 41.50           C  
ATOM    201  O   GLU A  31     -19.097  17.697  45.207  1.00 43.37           O  
ATOM    202  CB  GLU A  31     -20.293  20.494  45.074  1.00 39.47           C  
ATOM    203  CG  GLU A  31     -21.624  21.228  45.263  1.00 43.53           C  
ATOM    204  CD  GLU A  31     -21.975  22.215  44.083  1.00 43.79           C  
ATOM    205  OE1 GLU A  31     -22.132  21.779  42.920  1.00 46.60           O  
ATOM    206  OE2 GLU A  31     -22.129  23.428  44.340  1.00 49.84           O  
ATOM    207  N   ARG A  32     -17.620  19.067  46.258  1.00 40.13           N  
ATOM    208  CA  ARG A  32     -16.418  18.280  46.019  1.00 40.58           C  
ATOM    209  C   ARG A  32     -16.162  17.944  44.548  1.00 40.39           C  
ATOM    210  O   ARG A  32     -15.606  16.901  44.255  1.00 42.32           O  
ATOM    211  CB  ARG A  32     -16.384  16.992  46.871  1.00 39.10           C  
ATOM    212  CG  ARG A  32     -16.580  17.173  48.367  1.00 39.86           C  
ATOM    213  CD  ARG A  32     -16.673  15.765  49.057  1.00 41.39           C  
ATOM    214  NE  ARG A  32     -15.536  15.459  49.951  1.00 40.64           N  
ATOM    215  CZ  ARG A  32     -14.725  14.439  49.809  1.00 46.98           C  
ATOM    216  NH1 ARG A  32     -14.861  13.575  48.793  1.00 53.60           N  
ATOM    217  NH2 ARG A  32     -13.771  14.241  50.707  1.00 51.15           N  
ATOM    218  N   LYS A  33     -16.546  18.799  43.611  1.00 40.76           N  
ATOM    219  CA  LYS A  33     -16.221  18.512  42.183  1.00 40.48           C  
ATOM    220  C   LYS A  33     -15.401  19.555  41.473  1.00 37.42           C  
ATOM    221  O   LYS A  33     -14.714  19.259  40.540  1.00 36.58           O  
ATOM    222  CB  LYS A  33     -17.465  18.125  41.328  1.00 41.03           C  
ATOM    223  CG  LYS A  33     -18.764  18.114  42.035  1.00 48.47           C  
ATOM    224  CD  LYS A  33     -19.764  17.185  41.336  1.00 54.88           C  
ATOM    225  CE  LYS A  33     -19.982  17.554  39.852  1.00 56.88           C  
ATOM    226  NZ  LYS A  33     -21.467  17.412  39.606  1.00 61.36           N  
ATOM    227  N   TYR A  34     -15.452  20.775  41.936  1.00 34.97           N  
ATOM    228  CA  TYR A  34     -14.867  21.862  41.194  1.00 35.01           C  
ATOM    229  C   TYR A  34     -13.700  22.546  41.885  1.00 35.47           C  
ATOM    230  O   TYR A  34     -12.712  22.835  41.263  1.00 37.04           O  
ATOM    231  CB  TYR A  34     -15.951  22.879  40.881  1.00 34.73           C  
ATOM    232  CG  TYR A  34     -17.261  22.282  40.423  1.00 34.46           C  
ATOM    233  CD1 TYR A  34     -18.382  22.307  41.265  1.00 36.52           C  
ATOM    234  CD2 TYR A  34     -17.397  21.699  39.145  1.00 31.04           C  
ATOM    235  CE1 TYR A  34     -19.644  21.813  40.840  1.00 33.87           C  
ATOM    236  CE2 TYR A  34     -18.620  21.170  38.719  1.00 29.70           C  
ATOM    237  CZ  TYR A  34     -19.735  21.248  39.578  1.00 35.71           C  
ATOM    238  OH  TYR A  34     -20.955  20.746  39.205  1.00 39.30           O  
ATOM    239  N   LEU A  35     -13.808  22.831  43.170  1.00 36.52           N  
ATOM    240  CA  LEU A  35     -12.795  23.641  43.866  1.00 36.83           C  
ATOM    241  C   LEU A  35     -11.664  22.802  44.424  1.00 36.74           C  
ATOM    242  O   LEU A  35     -11.841  21.611  44.660  1.00 36.94           O  
ATOM    243  CB  LEU A  35     -13.513  24.422  45.029  1.00 35.53           C  
ATOM    244  CG  LEU A  35     -14.576  25.437  44.617  1.00 36.95           C  
ATOM    245  CD1 LEU A  35     -15.168  26.231  45.793  1.00 34.61           C  
ATOM    246  CD2 LEU A  35     -14.058  26.348  43.526  1.00 35.05           C  
ATOM    247  N   SER A  36     -10.566  23.430  44.744  1.00 38.08           N  
ATOM    248  CA  SER A  36      -9.439  22.716  45.355  1.00 42.39           C  
ATOM    249  C   SER A  36      -9.482  22.581  46.879  1.00 43.59           C  
ATOM    250  O   SER A  36      -8.633  21.903  47.480  1.00 44.30           O  
ATOM    251  CB  SER A  36      -8.082  23.370  45.007  1.00 43.55           C  
ATOM    252  OG  SER A  36      -7.870  24.535  45.803  1.00 49.53           O  
ATOM    253  N   PHE A  37     -10.417  23.266  47.504  1.00 44.70           N  
ATOM    254  CA  PHE A  37     -10.709  22.965  48.895  1.00 46.15           C  
ATOM    255  C   PHE A  37     -12.085  22.269  48.957  1.00 44.17           C  
ATOM    256  O   PHE A  37     -12.935  22.470  48.071  1.00 43.52           O  
ATOM    257  CB  PHE A  37     -10.573  24.229  49.768  1.00 48.02           C  
ATOM    258  CG  PHE A  37     -11.230  25.388  49.201  1.00 50.88           C  
ATOM    259  CD1 PHE A  37     -10.777  25.941  48.030  1.00 56.74           C  
ATOM    260  CD2 PHE A  37     -12.347  25.909  49.802  1.00 56.57           C  
ATOM    261  CE1 PHE A  37     -11.406  27.007  47.482  1.00 57.30           C  
ATOM    262  CE2 PHE A  37     -12.980  26.960  49.269  1.00 54.85           C  
ATOM    263  CZ  PHE A  37     -12.506  27.530  48.110  1.00 55.16           C  
ATOM    264  N   LEU A  38     -12.243  21.377  49.931  1.00 42.70           N  
ATOM    265  CA  LEU A  38     -13.395  20.489  49.991  1.00 41.95           C  
ATOM    266  C   LEU A  38     -14.424  21.058  50.993  1.00 43.00           C  
ATOM    267  O   LEU A  38     -15.557  20.573  51.117  1.00 41.66           O  
ATOM    268  CB  LEU A  38     -12.969  19.068  50.337  1.00 41.26           C  
ATOM    269  CG  LEU A  38     -12.010  18.376  49.322  1.00 38.87           C  
ATOM    270  CD1 LEU A  38     -11.531  17.049  49.799  1.00 28.71           C  
ATOM    271  CD2 LEU A  38     -12.698  18.194  47.939  1.00 39.39           C  
ATOM    272  N   GLU A  39     -14.046  22.168  51.607  1.00 42.72           N  
ATOM    273  CA  GLU A  39     -14.844  22.770  52.650  1.00 44.94           C  
ATOM    274  C   GLU A  39     -14.359  24.192  52.768  1.00 44.06           C  
ATOM    275  O   GLU A  39     -13.151  24.421  52.582  1.00 42.90           O  
ATOM    276  CB  GLU A  39     -14.473  22.049  53.950  1.00 45.16           C  
ATOM    277  CG  GLU A  39     -15.574  21.916  54.900  1.00 50.10           C  
ATOM    278  CD  GLU A  39     -15.025  21.422  56.200  1.00 56.14           C  
ATOM    279  OE1 GLU A  39     -15.042  22.210  57.178  1.00 57.49           O  
ATOM    280  OE2 GLU A  39     -14.529  20.265  56.225  1.00 60.72           O  
ATOM    281  N   ALA A  40     -15.225  25.131  53.149  1.00 43.69           N  
ATOM    282  CA  ALA A  40     -14.699  26.492  53.362  1.00 44.31           C  
ATOM    283  C   ALA A  40     -13.750  26.537  54.587  1.00 45.24           C  
ATOM    284  O   ALA A  40     -13.841  25.714  55.519  1.00 43.71           O  
ATOM    285  CB  ALA A  40     -15.807  27.554  53.473  1.00 43.30           C  
ATOM    286  N   PRO A  41     -12.836  27.516  54.584  1.00 46.86           N  
ATOM    287  CA  PRO A  41     -12.070  27.815  55.795  1.00 47.39           C  
ATOM    288  C   PRO A  41     -13.011  28.373  56.923  1.00 48.55           C  
ATOM    289  O   PRO A  41     -14.130  28.880  56.638  1.00 48.11           O  
ATOM    290  CB  PRO A  41     -11.079  28.883  55.319  1.00 48.56           C  
ATOM    291  CG  PRO A  41     -11.058  28.733  53.792  1.00 48.66           C  
ATOM    292  CD  PRO A  41     -12.490  28.412  53.462  1.00 46.85           C  
ATOM    293  N   PRO A  42     -12.587  28.262  58.206  1.00 48.00           N  
ATOM    294  CA  PRO A  42     -13.503  28.735  59.235  1.00 47.60           C  
ATOM    295  C   PRO A  42     -13.926  30.202  59.012  1.00 46.71           C  
ATOM    296  O   PRO A  42     -13.133  30.980  58.491  1.00 45.62           O  
ATOM    297  CB  PRO A  42     -12.699  28.577  60.541  1.00 47.70           C  
ATOM    298  CG  PRO A  42     -11.304  28.202  60.159  1.00 48.14           C  
ATOM    299  CD  PRO A  42     -11.316  27.731  58.747  1.00 48.42           C  
ATOM    300  N   LEU A  43     -15.135  30.580  59.431  1.00 46.41           N  
ATOM    301  CA  LEU A  43     -15.597  31.950  59.209  1.00 46.34           C  
ATOM    302  C   LEU A  43     -14.583  33.052  59.525  1.00 46.35           C  
ATOM    303  O   LEU A  43     -14.422  33.988  58.735  1.00 46.08           O  
ATOM    304  CB  LEU A  43     -16.915  32.246  59.936  1.00 47.33           C  
ATOM    305  CG  LEU A  43     -17.877  33.387  59.499  1.00 47.51           C  
ATOM    306  CD1 LEU A  43     -17.239  34.689  59.104  1.00 51.77           C  
ATOM    307  CD2 LEU A  43     -18.699  32.979  58.328  1.00 50.64           C  
ATOM    308  N   GLU A  44     -13.895  32.957  60.661  1.00 46.32           N  
ATOM    309  CA  GLU A  44     -13.057  34.065  61.078  1.00 46.38           C  
ATOM    310  C   GLU A  44     -11.780  34.085  60.278  1.00 45.46           C  
ATOM    311  O   GLU A  44     -11.174  35.142  60.102  1.00 45.09           O  
ATOM    312  CB  GLU A  44     -12.846  34.091  62.601  1.00 47.75           C  
ATOM    313  CG  GLU A  44     -13.594  35.271  63.411  1.00 50.93           C  
ATOM    314  CD  GLU A  44     -15.102  35.486  63.078  1.00 54.77           C  
ATOM    315  OE1 GLU A  44     -15.930  34.582  63.354  1.00 56.90           O  
ATOM    316  OE2 GLU A  44     -15.461  36.578  62.565  1.00 54.21           O  
ATOM    317  N   ALA A  45     -11.402  32.916  59.757  1.00 44.51           N  
ATOM    318  CA  ALA A  45     -10.338  32.808  58.755  1.00 43.90           C  
ATOM    319  C   ALA A  45     -10.772  33.495  57.456  1.00 44.03           C  
ATOM    320  O   ALA A  45      -9.980  34.194  56.819  1.00 43.66           O  
ATOM    321  CB  ALA A  45      -9.961  31.325  58.486  1.00 43.27           C  
ATOM    322  N   VAL A  46     -12.033  33.299  57.055  1.00 43.75           N  
ATOM    323  CA  VAL A  46     -12.499  33.947  55.850  1.00 44.01           C  
ATOM    324  C   VAL A  46     -12.594  35.483  56.051  1.00 42.94           C  
ATOM    325  O   VAL A  46     -12.161  36.250  55.186  1.00 43.92           O  
ATOM    326  CB  VAL A  46     -13.737  33.230  55.177  1.00 44.54           C  
ATOM    327  CG1 VAL A  46     -13.541  31.740  55.131  1.00 42.98           C  
ATOM    328  CG2 VAL A  46     -15.062  33.533  55.911  1.00 48.62           C  
ATOM    329  N   ARG A  47     -13.083  35.919  57.200  1.00 41.59           N  
ATOM    330  CA  ARG A  47     -13.113  37.341  57.520  1.00 41.12           C  
ATOM    331  C   ARG A  47     -11.739  38.026  57.474  1.00 41.33           C  
ATOM    332  O   ARG A  47     -11.644  39.157  56.999  1.00 41.70           O  
ATOM    333  CB  ARG A  47     -13.755  37.616  58.914  1.00 41.51           C  
ATOM    334  CG  ARG A  47     -13.997  39.136  59.165  1.00 38.50           C  
ATOM    335  CD  ARG A  47     -14.673  39.504  60.467  1.00 40.23           C  
ATOM    336  NE  ARG A  47     -15.641  38.494  60.844  1.00 40.59           N  
ATOM    337  CZ  ARG A  47     -16.929  38.516  60.522  1.00 42.32           C  
ATOM    338  NH1 ARG A  47     -17.436  39.533  59.829  1.00 44.18           N  
ATOM    339  NH2 ARG A  47     -17.713  37.516  60.901  1.00 37.76           N  
ATOM    340  N   ALA A  48     -10.705  37.393  58.033  1.00 40.93           N  
ATOM    341  CA  ALA A  48      -9.347  37.933  57.971  1.00 41.63           C  
ATOM    342  C   ALA A  48      -8.926  38.165  56.511  1.00 42.64           C  
ATOM    343  O   ALA A  48      -8.390  39.228  56.152  1.00 43.80           O  
ATOM    344  CB  ALA A  48      -8.335  36.974  58.683  1.00 40.66           C  
ATOM    345  N   PHE A  49      -9.154  37.146  55.683  1.00 42.48           N  
ATOM    346  CA  PHE A  49      -8.748  37.148  54.305  1.00 42.32           C  
ATOM    347  C   PHE A  49      -9.567  38.228  53.527  1.00 41.96           C  
ATOM    348  O   PHE A  49      -9.008  38.983  52.757  1.00 41.76           O  
ATOM    349  CB  PHE A  49      -8.913  35.721  53.757  1.00 42.85           C  
ATOM    350  CG  PHE A  49      -9.180  35.647  52.274  1.00 43.69           C  
ATOM    351  CD1 PHE A  49     -10.454  35.432  51.792  1.00 45.63           C  
ATOM    352  CD2 PHE A  49      -8.137  35.767  51.354  1.00 47.59           C  
ATOM    353  CE1 PHE A  49     -10.715  35.350  50.408  1.00 47.44           C  
ATOM    354  CE2 PHE A  49      -8.364  35.681  49.959  1.00 44.22           C  
ATOM    355  CZ  PHE A  49      -9.661  35.484  49.491  1.00 46.79           C  
ATOM    356  N   VAL A  50     -10.869  38.337  53.773  1.00 41.39           N  
ATOM    357  CA  VAL A  50     -11.654  39.392  53.124  1.00 41.21           C  
ATOM    358  C   VAL A  50     -11.318  40.809  53.577  1.00 41.09           C  
ATOM    359  O   VAL A  50     -11.227  41.691  52.751  1.00 40.85           O  
ATOM    360  CB  VAL A  50     -13.166  39.148  53.183  1.00 41.46           C  
ATOM    361  CG1 VAL A  50     -13.901  40.339  52.625  1.00 40.24           C  
ATOM    362  CG2 VAL A  50     -13.486  37.892  52.404  1.00 38.73           C  
ATOM    363  N   LEU A  51     -11.112  41.017  54.881  1.00 42.27           N  
ATOM    364  CA  LEU A  51     -10.617  42.318  55.403  1.00 41.64           C  
ATOM    365  C   LEU A  51      -9.301  42.728  54.760  1.00 40.54           C  
ATOM    366  O   LEU A  51      -9.186  43.839  54.327  1.00 39.82           O  
ATOM    367  CB  LEU A  51     -10.563  42.356  56.947  1.00 42.02           C  
ATOM    368  CG  LEU A  51     -11.838  42.871  57.704  1.00 43.54           C  
ATOM    369  CD1 LEU A  51     -13.196  42.893  56.921  1.00 40.93           C  
ATOM    370  CD2 LEU A  51     -11.978  42.166  59.059  1.00 40.52           C  
ATOM    371  N   ASP A  52      -8.352  41.808  54.663  1.00 41.31           N  
ATOM    372  CA  ASP A  52      -7.033  42.023  54.030  1.00 43.19           C  
ATOM    373  C   ASP A  52      -7.095  42.397  52.527  1.00 43.80           C  
ATOM    374  O   ASP A  52      -6.394  43.301  52.046  1.00 43.77           O  
ATOM    375  CB  ASP A  52      -6.234  40.717  54.176  1.00 44.27           C  
ATOM    376  CG  ASP A  52      -4.751  40.860  53.835  1.00 49.29           C  
ATOM    377  OD1 ASP A  52      -4.073  41.807  54.314  1.00 55.47           O  
ATOM    378  OD2 ASP A  52      -4.230  39.978  53.116  1.00 54.84           O  
HETATM  379  N   MSE A  53      -7.904  41.664  51.775  1.00 43.55           N  
HETATM  380  CA  MSE A  53      -8.120  41.963  50.380  1.00 44.90           C  
HETATM  381  C   MSE A  53      -8.654  43.391  50.144  1.00 43.78           C  
HETATM  382  O   MSE A  53      -8.129  44.117  49.304  1.00 42.93           O  
HETATM  383  CB  MSE A  53      -9.095  40.949  49.825  1.00 46.02           C  
HETATM  384  CG  MSE A  53      -8.545  39.541  49.995  1.00 54.60           C  
HETATM  385 SE   MSE A  53      -7.600  38.988  48.361  1.00 70.98          SE  
HETATM  386  CE  MSE A  53      -9.236  38.096  47.498  1.00 63.53           C  
ATOM    387  N   ILE A  54      -9.704  43.769  50.877  1.00 42.46           N  
ATOM    388  CA  ILE A  54     -10.263  45.091  50.799  1.00 42.54           C  
ATOM    389  C   ILE A  54      -9.170  46.136  51.132  1.00 44.52           C  
ATOM    390  O   ILE A  54      -9.008  47.120  50.430  1.00 45.34           O  
ATOM    391  CB  ILE A  54     -11.468  45.225  51.756  1.00 42.88           C  
ATOM    392  CG1 ILE A  54     -12.615  44.336  51.262  1.00 41.03           C  
ATOM    393  CG2 ILE A  54     -11.897  46.689  51.935  1.00 37.80           C  
ATOM    394  CD1 ILE A  54     -13.823  44.311  52.207  1.00 41.42           C  
ATOM    395  N   GLU A  55      -8.395  45.879  52.171  1.00 45.83           N  
ATOM    396  CA  GLU A  55      -7.488  46.874  52.709  1.00 47.76           C  
ATOM    397  C   GLU A  55      -6.337  47.135  51.738  1.00 47.56           C  
ATOM    398  O   GLU A  55      -5.954  48.298  51.494  1.00 47.07           O  
ATOM    399  CB  GLU A  55      -7.035  46.479  54.130  1.00 47.84           C  
ATOM    400  CG  GLU A  55      -7.919  47.043  55.351  1.00 52.30           C  
ATOM    401  CD  GLU A  55      -9.506  47.170  55.181  1.00 56.61           C  
ATOM    402  OE1 GLU A  55      -9.930  48.355  54.974  1.00 55.38           O  
ATOM    403  OE2 GLU A  55     -10.315  46.157  55.320  1.00 51.88           O  
ATOM    404  N   ASN A  56      -5.857  46.045  51.147  1.00 47.91           N  
ATOM    405  CA  ASN A  56      -4.799  46.042  50.142  1.00 48.92           C  
ATOM    406  C   ASN A  56      -5.262  46.092  48.690  1.00 49.68           C  
ATOM    407  O   ASN A  56      -4.472  45.844  47.762  1.00 49.95           O  
ATOM    408  CB  ASN A  56      -3.927  44.828  50.356  1.00 49.08           C  
ATOM    409  CG  ASN A  56      -3.386  44.790  51.745  1.00 50.61           C  
ATOM    410  OD1 ASN A  56      -3.000  45.834  52.292  1.00 51.34           O  
ATOM    411  ND2 ASN A  56      -3.412  43.623  52.358  1.00 51.16           N  
ATOM    412  N   ASP A  57      -6.550  46.409  48.525  1.00 49.67           N  
ATOM    413  CA  ASP A  57      -7.132  46.781  47.257  1.00 48.99           C  
ATOM    414  C   ASP A  57      -7.151  45.666  46.166  1.00 48.10           C  
ATOM    415  O   ASP A  57      -7.272  45.993  44.972  1.00 46.64           O  
ATOM    416  CB  ASP A  57      -6.474  48.092  46.774  1.00 50.50           C  
ATOM    417  CG  ASP A  57      -7.355  48.864  45.803  1.00 54.48           C  
ATOM    418  OD1 ASP A  57      -8.547  49.090  46.134  1.00 57.51           O  
ATOM    419  OD2 ASP A  57      -6.870  49.232  44.694  1.00 58.40           O  
ATOM    420  N   HIS A  58      -7.067  44.383  46.589  1.00 46.59           N  
ATOM    421  CA  HIS A  58      -7.069  43.190  45.677  1.00 45.63           C  
ATOM    422  C   HIS A  58      -8.482  42.797  45.170  1.00 42.97           C  
ATOM    423  O   HIS A  58      -9.431  42.738  45.988  1.00 42.71           O  
ATOM    424  CB  HIS A  58      -6.448  41.985  46.347  1.00 45.94           C  
ATOM    425  CG  HIS A  58      -5.029  42.197  46.757  1.00 49.45           C  
ATOM    426  ND1 HIS A  58      -4.375  41.357  47.629  1.00 53.55           N  
ATOM    427  CD2 HIS A  58      -4.144  43.171  46.433  1.00 51.87           C  
ATOM    428  CE1 HIS A  58      -3.146  41.798  47.823  1.00 54.90           C  
ATOM    429  NE2 HIS A  58      -2.982  42.900  47.106  1.00 54.96           N  
ATOM    430  N   PRO A  59      -8.627  42.601  43.829  1.00 39.08           N  
ATOM    431  CA  PRO A  59      -9.958  42.533  43.160  1.00 36.90           C  
ATOM    432  C   PRO A  59     -10.773  41.363  43.708  1.00 36.35           C  
ATOM    433  O   PRO A  59     -10.256  40.245  43.782  1.00 35.33           O  
ATOM    434  CB  PRO A  59      -9.622  42.322  41.680  1.00 35.49           C  
ATOM    435  CG  PRO A  59      -8.158  42.560  41.545  1.00 37.35           C  
ATOM    436  CD  PRO A  59      -7.501  42.492  42.880  1.00 38.15           C  
ATOM    437  N   GLN A  60     -11.965  41.657  44.221  1.00 33.67           N  
ATOM    438  CA  GLN A  60     -12.780  40.658  44.787  1.00 34.34           C  
ATOM    439  C   GLN A  60     -14.227  41.096  44.663  1.00 33.08           C  
ATOM    440  O   GLN A  60     -14.630  42.088  45.237  1.00 31.66           O  
ATOM    441  CB  GLN A  60     -12.404  40.369  46.236  1.00 34.80           C  
ATOM    442  CG  GLN A  60     -13.264  39.268  46.894  1.00 36.51           C  
ATOM    443  CD  GLN A  60     -12.657  38.869  48.274  1.00 39.99           C  
ATOM    444  OE1 GLN A  60     -12.149  39.744  49.044  1.00 45.14           O  
ATOM    445  NE2 GLN A  60     -12.627  37.548  48.541  1.00 40.82           N  
ATOM    446  N   PHE A  61     -14.998  40.349  43.881  1.00 32.59           N  
ATOM    447  CA  PHE A  61     -16.347  40.771  43.526  1.00 32.32           C  
ATOM    448  C   PHE A  61     -17.348  39.723  43.945  1.00 33.67           C  
ATOM    449  O   PHE A  61     -17.056  38.520  43.907  1.00 32.97           O  
ATOM    450  CB  PHE A  61     -16.411  41.009  41.994  1.00 32.22           C  
ATOM    451  CG  PHE A  61     -15.723  42.274  41.567  1.00 31.03           C  
ATOM    452  CD1 PHE A  61     -14.322  42.348  41.476  1.00 27.91           C  
ATOM    453  CD2 PHE A  61     -16.468  43.423  41.361  1.00 30.19           C  
ATOM    454  CE1 PHE A  61     -13.683  43.610  41.184  1.00 29.42           C  
ATOM    455  CE2 PHE A  61     -15.853  44.627  41.058  1.00 28.29           C  
ATOM    456  CZ  PHE A  61     -14.466  44.720  40.977  1.00 26.50           C  
ATOM    457  N   VAL A  62     -18.558  40.178  44.319  1.00 34.63           N  
ATOM    458  CA  VAL A  62     -19.627  39.237  44.713  1.00 33.01           C  
ATOM    459  C   VAL A  62     -20.815  39.426  43.813  1.00 32.93           C  
ATOM    460  O   VAL A  62     -21.028  40.530  43.334  1.00 31.37           O  
ATOM    461  CB  VAL A  62     -19.968  39.295  46.197  1.00 32.70           C  
ATOM    462  CG1 VAL A  62     -18.846  38.606  46.928  1.00 32.52           C  
ATOM    463  CG2 VAL A  62     -20.283  40.795  46.659  1.00 28.45           C  
ATOM    464  N   ALA A  63     -21.526  38.337  43.518  1.00 31.60           N  
ATOM    465  CA  ALA A  63     -22.811  38.523  42.874  1.00 30.72           C  
ATOM    466  C   ALA A  63     -23.875  38.368  43.923  1.00 31.44           C  
ATOM    467  O   ALA A  63     -23.933  37.364  44.619  1.00 32.01           O  
ATOM    468  CB  ALA A  63     -23.004  37.567  41.736  1.00 29.27           C  
ATOM    469  N   ILE A  64     -24.766  39.349  43.956  1.00 33.45           N  
ATOM    470  CA  ILE A  64     -25.760  39.483  44.982  1.00 34.95           C  
ATOM    471  C   ILE A  64     -27.190  39.304  44.407  1.00 36.59           C  
ATOM    472  O   ILE A  64     -27.584  40.003  43.410  1.00 35.09           O  
ATOM    473  CB  ILE A  64     -25.618  40.869  45.706  1.00 35.68           C  
ATOM    474  CG1 ILE A  64     -24.640  40.682  46.846  1.00 35.55           C  
ATOM    475  CG2 ILE A  64     -26.940  41.280  46.411  1.00 35.96           C  
ATOM    476  CD1 ILE A  64     -23.524  41.183  46.546  1.00 37.62           C  
ATOM    477  N   ALA A  65     -27.927  38.365  44.988  1.00 35.26           N  
ATOM    478  CA  ALA A  65     -29.331  38.196  44.601  1.00 37.01           C  
ATOM    479  C   ALA A  65     -30.216  38.080  45.860  1.00 37.76           C  
ATOM    480  O   ALA A  65     -30.003  37.224  46.744  1.00 36.52           O  
ATOM    481  CB  ALA A  65     -29.548  36.961  43.643  1.00 34.74           C  
ATOM    482  N   ASP A  66     -31.181  38.991  45.940  1.00 40.74           N  
ATOM    483  CA  ASP A  66     -32.064  39.117  47.138  1.00 42.25           C  
ATOM    484  C   ASP A  66     -31.250  39.187  48.430  1.00 41.24           C  
ATOM    485  O   ASP A  66     -31.448  38.419  49.365  1.00 40.26           O  
ATOM    486  CB  ASP A  66     -33.080  37.976  47.166  1.00 43.58           C  
ATOM    487  CG  ASP A  66     -34.131  38.089  46.009  1.00 50.45           C  
ATOM    488  OD1 ASP A  66     -34.811  39.168  45.868  1.00 59.17           O  
ATOM    489  OD2 ASP A  66     -34.292  37.087  45.263  1.00 56.66           O  
ATOM    490  N   GLY A  67     -30.304  40.110  48.446  1.00 41.23           N  
ATOM    491  CA  GLY A  67     -29.404  40.240  49.576  1.00 40.90           C  
ATOM    492  C   GLY A  67     -28.352  39.144  49.783  1.00 40.40           C  
ATOM    493  O   GLY A  67     -27.398  39.391  50.515  1.00 41.97           O  
ATOM    494  N   ASP A  68     -28.493  37.954  49.200  1.00 38.63           N  
ATOM    495  CA  ASP A  68     -27.505  36.858  49.443  1.00 38.82           C  
ATOM    496  C   ASP A  68     -26.342  36.963  48.418  1.00 36.17           C  
ATOM    497  O   ASP A  68     -26.586  37.411  47.310  1.00 33.58           O  
ATOM    498  CB  ASP A  68     -28.186  35.465  49.305  1.00 39.94           C  
ATOM    499  CG  ASP A  68     -29.317  35.184  50.388  1.00 47.21           C  
ATOM    500  OD1 ASP A  68     -28.966  34.947  51.580  1.00 52.15           O  
ATOM    501  OD2 ASP A  68     -30.554  35.115  50.054  1.00 51.37           O  
ATOM    502  N   VAL A  69     -25.114  36.534  48.799  1.00 36.06           N  
ATOM    503  CA  VAL A  69     -23.984  36.258  47.886  1.00 34.50           C  
ATOM    504  C   VAL A  69     -24.292  34.924  47.196  1.00 34.06           C  
ATOM    505  O   VAL A  69     -24.410  33.885  47.851  1.00 32.83           O  
ATOM    506  CB  VAL A  69     -22.529  36.243  48.569  1.00 34.86           C  
ATOM    507  CG1 VAL A  69     -21.410  35.684  47.587  1.00 36.21           C  
ATOM    508  CG2 VAL A  69     -22.100  37.659  49.112  1.00 34.12           C  
ATOM    509  N   ILE A  70     -24.485  34.972  45.870  1.00 33.18           N  
ATOM    510  CA  ILE A  70     -24.737  33.747  45.101  1.00 31.67           C  
ATOM    511  C   ILE A  70     -23.536  33.376  44.187  1.00 29.66           C  
ATOM    512  O   ILE A  70     -23.539  32.354  43.513  1.00 28.39           O  
ATOM    513  CB  ILE A  70     -26.099  33.830  44.339  1.00 33.39           C  
ATOM    514  CG1 ILE A  70     -26.208  35.134  43.588  1.00 34.81           C  
ATOM    515  CG2 ILE A  70     -27.301  33.843  45.275  1.00 32.29           C  
ATOM    516  CD1 ILE A  70     -26.232  34.970  42.132  1.00 36.13           C  
ATOM    517  N   GLY A  71     -22.461  34.159  44.275  1.00 28.99           N  
ATOM    518  CA  GLY A  71     -21.325  33.955  43.431  1.00 29.68           C  
ATOM    519  C   GLY A  71     -20.241  34.942  43.785  1.00 29.71           C  
ATOM    520  O   GLY A  71     -20.535  35.924  44.389  1.00 28.75           O  
ATOM    521  N   TRP A  72     -18.991  34.631  43.393  1.00 28.22           N  
ATOM    522  CA  TRP A  72     -17.827  35.465  43.689  1.00 28.61           C  
ATOM    523  C   TRP A  72     -16.743  35.191  42.651  1.00 27.64           C  
ATOM    524  O   TRP A  72     -16.737  34.183  41.998  1.00 25.66           O  
ATOM    525  CB  TRP A  72     -17.281  35.184  45.073  1.00 27.30           C  
ATOM    526  CG  TRP A  72     -16.533  33.879  45.145  1.00 29.85           C  
ATOM    527  CD1 TRP A  72     -15.173  33.697  45.014  1.00 26.98           C  
ATOM    528  CD2 TRP A  72     -17.103  32.584  45.359  1.00 25.51           C  
ATOM    529  NE1 TRP A  72     -14.872  32.384  45.202  1.00 28.90           N  
ATOM    530  CE2 TRP A  72     -16.038  31.676  45.404  1.00 29.58           C  
ATOM    531  CE3 TRP A  72     -18.438  32.117  45.571  1.00 29.73           C  
ATOM    532  CZ2 TRP A  72     -16.231  30.272  45.592  1.00 29.96           C  
ATOM    533  CZ3 TRP A  72     -18.627  30.697  45.793  1.00 29.09           C  
ATOM    534  CH2 TRP A  72     -17.542  29.826  45.780  1.00 29.05           C  
ATOM    535  N   CYS A  73     -15.839  36.136  42.510  1.00 29.94           N  
ATOM    536  CA  CYS A  73     -14.701  35.951  41.683  1.00 30.38           C  
ATOM    537  C   CYS A  73     -13.645  36.783  42.379  1.00 30.82           C  
ATOM    538  O   CYS A  73     -13.882  37.946  42.713  1.00 32.14           O  
ATOM    539  CB  CYS A  73     -15.024  36.415  40.231  1.00 28.93           C  
ATOM    540  SG  CYS A  73     -13.665  36.303  39.046  1.00 31.57           S  
ATOM    541  N   ASP A  74     -12.450  36.242  42.523  1.00 30.63           N  
ATOM    542  CA  ASP A  74     -11.425  37.020  43.161  1.00 32.57           C  
ATOM    543  C   ASP A  74     -10.004  36.766  42.629  1.00 33.06           C  
ATOM    544  O   ASP A  74      -9.715  35.739  42.003  1.00 30.72           O  
ATOM    545  CB  ASP A  74     -11.514  36.994  44.690  1.00 32.55           C  
ATOM    546  CG  ASP A  74     -11.417  35.587  45.310  1.00 38.55           C  
ATOM    547  OD1 ASP A  74     -10.714  34.683  44.769  1.00 44.54           O  
ATOM    548  OD2 ASP A  74     -12.030  35.409  46.419  1.00 47.68           O  
ATOM    549  N   ILE A  75      -9.150  37.770  42.803  1.00 33.39           N  
ATOM    550  CA  ILE A  75      -7.776  37.643  42.298  1.00 34.43           C  
ATOM    551  C   ILE A  75      -6.822  37.885  43.490  1.00 36.67           C  
ATOM    552  O   ILE A  75      -6.852  38.973  44.083  1.00 37.07           O  
ATOM    553  CB  ILE A  75      -7.489  38.508  41.002  1.00 34.13           C  
ATOM    554  CG1 ILE A  75      -8.361  38.035  39.831  1.00 32.93           C  
ATOM    555  CG2 ILE A  75      -5.978  38.438  40.559  1.00 33.29           C  
ATOM    556  CD1 ILE A  75      -8.295  38.851  38.495  1.00 30.26           C  
ATOM    557  N   ARG A  76      -6.070  36.851  43.892  1.00 38.37           N  
ATOM    558  CA  ARG A  76      -5.006  37.021  44.891  1.00 41.76           C  
ATOM    559  C   ARG A  76      -3.634  37.314  44.244  1.00 40.73           C  
ATOM    560  O   ARG A  76      -3.075  36.485  43.487  1.00 37.54           O  
ATOM    561  CB  ARG A  76      -4.955  35.852  45.883  1.00 40.99           C  
ATOM    562  CG  ARG A  76      -4.492  34.466  45.279  1.00 49.58           C  
ATOM    563  CD  ARG A  76      -4.542  33.290  46.323  1.00 50.70           C  
ATOM    564  NE  ARG A  76      -5.805  33.500  47.051  1.00 64.41           N  
ATOM    565  CZ  ARG A  76      -6.964  32.999  46.655  1.00 69.33           C  
ATOM    566  NH1 ARG A  76      -6.985  32.204  45.565  1.00 71.20           N  
ATOM    567  NH2 ARG A  76      -8.079  33.288  47.346  1.00 70.25           N  
ATOM    568  N   ARG A  77      -3.125  38.523  44.535  1.00 41.80           N  
ATOM    569  CA  ARG A  77      -1.734  38.930  44.254  1.00 42.83           C  
ATOM    570  C   ARG A  77      -0.653  38.006  44.876  1.00 43.72           C  
ATOM    571  O   ARG A  77      -0.715  37.711  46.060  1.00 41.59           O  
ATOM    572  CB  ARG A  77      -1.485  40.363  44.693  1.00 42.67           C  
ATOM    573  CG  ARG A  77      -0.364  41.021  43.888  1.00 44.81           C  
ATOM    574  CD  ARG A  77      -0.151  42.486  44.274  1.00 45.32           C  
ATOM    575  NE  ARG A  77       0.935  43.089  43.529  1.00 48.48           N  
ATOM    576  CZ  ARG A  77       1.565  44.214  43.902  1.00 55.32           C  
ATOM    577  NH1 ARG A  77       1.220  44.841  45.031  1.00 55.37           N  
ATOM    578  NH2 ARG A  77       2.549  44.735  43.161  1.00 53.81           N  
ATOM    579  N   GLN A  78       0.294  37.534  44.028  1.00 44.75           N  
ATOM    580  CA  GLN A  78       1.477  36.755  44.455  1.00 46.10           C  
ATOM    581  C   GLN A  78       2.315  37.621  45.414  1.00 47.03           C  
ATOM    582  O   GLN A  78       2.387  38.839  45.287  1.00 46.18           O  
ATOM    583  CB  GLN A  78       2.350  36.296  43.275  1.00 45.06           C  
ATOM    584  CG  GLN A  78       1.813  35.128  42.434  1.00 47.57           C  
ATOM    585  CD  GLN A  78       1.822  33.734  43.144  1.00 53.43           C  
ATOM    586  OE1 GLN A  78       0.783  33.063  43.187  1.00 52.92           O  
ATOM    587  NE2 GLN A  78       2.993  33.304  43.712  1.00 56.05           N  
ATOM    588  N   ASP A  79       2.924  36.969  46.397  1.00 49.60           N  
ATOM    589  CA  ASP A  79       3.647  37.692  47.436  1.00 51.78           C  
ATOM    590  C   ASP A  79       5.038  38.050  47.035  1.00 50.38           C  
ATOM    591  O   ASP A  79       5.437  39.211  47.170  1.00 49.77           O  
ATOM    592  CB  ASP A  79       3.674  36.922  48.756  1.00 54.17           C  
ATOM    593  CG  ASP A  79       2.737  37.551  49.795  1.00 60.74           C  
ATOM    594  OD1 ASP A  79       1.475  37.507  49.589  1.00 64.74           O  
ATOM    595  OD2 ASP A  79       3.282  38.110  50.799  1.00 68.55           O  
ATOM    596  N   ARG A  80       5.779  37.075  46.520  1.00 48.99           N  
ATOM    597  CA  ARG A  80       7.165  37.392  46.257  1.00 48.39           C  
ATOM    598  C   ARG A  80       7.370  38.516  45.229  1.00 46.16           C  
ATOM    599  O   ARG A  80       6.583  38.709  44.311  1.00 44.80           O  
ATOM    600  CB  ARG A  80       8.043  36.161  46.032  1.00 49.73           C  
ATOM    601  CG  ARG A  80       7.500  35.127  45.114  1.00 53.92           C  
ATOM    602  CD  ARG A  80       8.548  34.061  44.905  1.00 62.32           C  
ATOM    603  NE  ARG A  80       9.280  33.753  46.141  1.00 68.43           N  
ATOM    604  CZ  ARG A  80       9.084  32.661  46.901  1.00 71.54           C  
ATOM    605  NH1 ARG A  80       8.191  31.738  46.559  1.00 71.45           N  
ATOM    606  NH2 ARG A  80       9.800  32.473  48.010  1.00 72.89           N  
ATOM    607  N   ALA A  81       8.443  39.277  45.431  1.00 43.32           N  
ATOM    608  CA  ALA A  81       8.695  40.441  44.630  1.00 41.31           C  
ATOM    609  C   ALA A  81       8.837  40.103  43.137  1.00 40.20           C  
ATOM    610  O   ALA A  81       8.406  40.919  42.318  1.00 40.64           O  
ATOM    611  CB  ALA A  81       9.939  41.158  45.122  1.00 41.04           C  
ATOM    612  N   THR A  82       9.433  38.951  42.783  1.00 36.84           N  
ATOM    613  CA  THR A  82       9.552  38.580  41.396  1.00 36.86           C  
ATOM    614  C   THR A  82       8.237  38.112  40.719  1.00 36.94           C  
ATOM    615  O   THR A  82       8.246  37.920  39.500  1.00 35.85           O  
ATOM    616  CB  THR A  82      10.553  37.443  41.134  1.00 37.52           C  
ATOM    617  OG1 THR A  82      10.045  36.231  41.679  1.00 38.01           O  
ATOM    618  CG2 THR A  82      11.940  37.767  41.686  1.00 40.40           C  
ATOM    619  N   ARG A  83       7.150  37.934  41.483  1.00 34.91           N  
ATOM    620  CA  ARG A  83       5.926  37.323  40.985  1.00 34.68           C  
ATOM    621  C   ARG A  83       4.789  38.285  41.285  1.00 34.97           C  
ATOM    622  O   ARG A  83       3.658  38.011  40.943  1.00 35.76           O  
ATOM    623  CB  ARG A  83       5.654  35.984  41.703  1.00 34.57           C  
ATOM    624  CG  ARG A  83       6.713  34.909  41.513  1.00 38.09           C  
ATOM    625  CD  ARG A  83       6.429  33.929  40.301  1.00 41.84           C  
ATOM    626  NE  ARG A  83       5.179  33.189  40.550  1.00 45.32           N  
ATOM    627  CZ  ARG A  83       4.071  33.184  39.779  1.00 45.06           C  
ATOM    628  NH1 ARG A  83       4.008  33.843  38.596  1.00 35.89           N  
ATOM    629  NH2 ARG A  83       2.994  32.511  40.229  1.00 41.44           N  
ATOM    630  N   ALA A  84       5.078  39.420  41.928  1.00 34.25           N  
ATOM    631  CA  ALA A  84       4.023  40.419  42.293  1.00 34.42           C  
ATOM    632  C   ALA A  84       3.218  41.081  41.200  1.00 33.36           C  
ATOM    633  O   ALA A  84       2.205  41.645  41.551  1.00 35.69           O  
ATOM    634  CB  ALA A  84       4.570  41.537  43.259  1.00 34.53           C  
ATOM    635  N   HIS A  85       3.634  41.031  39.912  1.00 32.51           N  
ATOM    636  CA  HIS A  85       2.821  41.425  38.763  1.00 32.02           C  
ATOM    637  C   HIS A  85       1.771  40.303  38.391  1.00 33.19           C  
ATOM    638  O   HIS A  85       0.975  40.497  37.484  1.00 33.10           O  
ATOM    639  CB  HIS A  85       3.735  41.641  37.533  1.00 32.29           C  
ATOM    640  CG  HIS A  85       4.497  40.393  37.143  1.00 33.63           C  
ATOM    641  ND1 HIS A  85       5.363  39.770  38.017  1.00 30.89           N  
ATOM    642  CD2 HIS A  85       4.434  39.590  36.045  1.00 33.08           C  
ATOM    643  CE1 HIS A  85       5.877  38.686  37.448  1.00 30.46           C  
ATOM    644  NE2 HIS A  85       5.305  38.531  36.264  1.00 34.77           N  
ATOM    645  N   CYS A  86       1.723  39.221  39.156  1.00 35.09           N  
ATOM    646  CA  CYS A  86       0.814  38.090  38.946  1.00 35.94           C  
ATOM    647  C   CYS A  86      -0.277  37.898  39.992  1.00 34.71           C  
ATOM    648  O   CYS A  86      -0.046  38.114  41.199  1.00 35.97           O  
ATOM    649  CB  CYS A  86       1.633  36.830  38.941  1.00 36.85           C  
ATOM    650  SG  CYS A  86       0.838  35.390  38.184  1.00 45.09           S  
ATOM    651  N   GLY A  87      -1.488  37.550  39.536  1.00 32.58           N  
ATOM    652  CA  GLY A  87      -2.588  37.243  40.464  1.00 29.58           C  
ATOM    653  C   GLY A  87      -3.191  35.861  40.130  1.00 29.91           C  
ATOM    654  O   GLY A  87      -3.115  35.453  38.981  1.00 30.72           O  
ATOM    655  N   THR A  88      -3.722  35.142  41.131  1.00 29.13           N  
ATOM    656  CA  THR A  88      -4.400  33.861  40.959  1.00 30.24           C  
ATOM    657  C   THR A  88      -5.898  34.062  41.093  1.00 29.14           C  
ATOM    658  O   THR A  88      -6.354  34.635  42.074  1.00 29.18           O  
ATOM    659  CB  THR A  88      -3.974  32.874  42.004  1.00 30.73           C  
ATOM    660  OG1 THR A  88      -2.584  32.751  41.924  1.00 32.01           O  
ATOM    661  CG2 THR A  88      -4.585  31.425  41.766  1.00 32.17           C  
ATOM    662  N   LEU A  89      -6.630  33.632  40.093  1.00 28.21           N  
ATOM    663  CA  LEU A  89      -8.084  33.741  40.071  1.00 29.42           C  
ATOM    664  C   LEU A  89      -8.816  32.513  40.716  1.00 30.35           C  
ATOM    665  O   LEU A  89      -8.401  31.393  40.521  1.00 30.79           O  
ATOM    666  CB  LEU A  89      -8.585  34.020  38.628  1.00 30.72           C  
ATOM    667  CG  LEU A  89     -10.100  34.384  38.419  1.00 29.89           C  
ATOM    668  CD1 LEU A  89     -10.232  35.361  37.322  1.00 33.82           C  
ATOM    669  CD2 LEU A  89     -10.816  33.148  38.081  1.00 29.28           C  
ATOM    670  N   GLY A  90      -9.837  32.756  41.560  1.00 31.03           N  
ATOM    671  CA  GLY A  90     -10.839  31.711  41.917  1.00 29.46           C  
ATOM    672  C   GLY A  90     -12.270  32.276  41.819  1.00 28.26           C  
ATOM    673  O   GLY A  90     -12.483  33.472  41.869  1.00 27.66           O  
HETATM  674  N   MSE A  91     -13.243  31.411  41.624  1.00 26.39           N  
HETATM  675  CA  MSE A  91     -14.606  31.835  41.474  1.00 30.65           C  
HETATM  676  C   MSE A  91     -15.530  30.659  41.610  1.00 27.82           C  
HETATM  677  O   MSE A  91     -15.106  29.507  41.405  1.00 26.40           O  
HETATM  678  CB  MSE A  91     -14.822  32.425  40.107  1.00 28.62           C  
HETATM  679  CG  MSE A  91     -14.619  31.427  39.033  1.00 30.62           C  
HETATM  680 SE   MSE A  91     -14.903  32.467  37.284  1.00 44.03          SE  
HETATM  681  CE  MSE A  91     -16.642  33.524  37.779  1.00 25.54           C  
ATOM    682  N   GLY A  92     -16.792  30.976  41.897  1.00 24.61           N  
ATOM    683  CA  GLY A  92     -17.802  29.954  42.147  1.00 24.56           C  
ATOM    684  C   GLY A  92     -19.164  30.585  42.080  1.00 25.13           C  
ATOM    685  O   GLY A  92     -19.345  31.784  42.365  1.00 25.72           O  
ATOM    686  N   ILE A  93     -20.159  29.789  41.743  1.00 25.21           N  
ATOM    687  CA  ILE A  93     -21.527  30.278  41.635  1.00 27.17           C  
ATOM    688  C   ILE A  93     -22.414  29.140  42.156  1.00 27.30           C  
ATOM    689  O   ILE A  93     -22.165  27.982  41.816  1.00 27.23           O  
ATOM    690  CB  ILE A  93     -21.855  30.657  40.120  1.00 25.94           C  
ATOM    691  CG1 ILE A  93     -21.036  31.871  39.664  1.00 32.61           C  
ATOM    692  CG2 ILE A  93     -23.352  30.942  39.887  1.00 28.12           C  
ATOM    693  CD1 ILE A  93     -21.331  32.342  38.273  1.00 28.96           C  
ATOM    694  N   LEU A  94     -23.448  29.492  42.933  1.00 28.01           N  
ATOM    695  CA  LEU A  94     -24.444  28.582  43.413  1.00 27.78           C  
ATOM    696  C   LEU A  94     -25.109  27.887  42.211  1.00 27.98           C  
ATOM    697  O   LEU A  94     -25.302  28.509  41.184  1.00 28.22           O  
ATOM    698  CB  LEU A  94     -25.495  29.324  44.287  1.00 26.53           C  
ATOM    699  CG  LEU A  94     -24.988  29.867  45.632  1.00 27.34           C  
ATOM    700  CD1 LEU A  94     -26.160  30.309  46.497  1.00 26.51           C  
ATOM    701  CD2 LEU A  94     -24.091  28.818  46.340  1.00 30.66           C  
ATOM    702  N   PRO A  95     -25.418  26.584  42.339  1.00 29.34           N  
ATOM    703  CA  PRO A  95     -25.932  25.778  41.220  1.00 29.02           C  
ATOM    704  C   PRO A  95     -27.111  26.390  40.451  1.00 30.74           C  
ATOM    705  O   PRO A  95     -27.093  26.343  39.187  1.00 31.14           O  
ATOM    706  CB  PRO A  95     -26.318  24.449  41.879  1.00 29.73           C  
ATOM    707  CG  PRO A  95     -25.496  24.337  43.133  1.00 29.63           C  
ATOM    708  CD  PRO A  95     -25.282  25.801  43.595  1.00 28.70           C  
ATOM    709  N   ALA A  96     -28.107  26.980  41.150  1.00 30.04           N  
ATOM    710  CA  ALA A  96     -29.240  27.587  40.478  1.00 31.15           C  
ATOM    711  C   ALA A  96     -28.846  28.758  39.576  1.00 32.45           C  
ATOM    712  O   ALA A  96     -29.622  29.161  38.717  1.00 31.36           O  
ATOM    713  CB  ALA A  96     -30.335  28.159  41.560  1.00 32.34           C  
ATOM    714  N   TYR A  97     -27.658  29.341  39.761  1.00 32.44           N  
ATOM    715  CA  TYR A  97     -27.342  30.558  38.977  1.00 31.46           C  
ATOM    716  C   TYR A  97     -26.316  30.332  37.871  1.00 30.08           C  
ATOM    717  O   TYR A  97     -25.919  31.245  37.209  1.00 30.88           O  
ATOM    718  CB  TYR A  97     -26.921  31.658  39.911  1.00 32.83           C  
ATOM    719  CG  TYR A  97     -28.037  32.089  40.869  1.00 35.95           C  
ATOM    720  CD1 TYR A  97     -28.829  33.206  40.537  1.00 41.00           C  
ATOM    721  CD2 TYR A  97     -28.276  31.433  42.097  1.00 35.74           C  
ATOM    722  CE1 TYR A  97     -29.833  33.663  41.404  1.00 44.62           C  
ATOM    723  CE2 TYR A  97     -29.330  31.863  42.961  1.00 37.89           C  
ATOM    724  CZ  TYR A  97     -30.075  32.975  42.597  1.00 42.50           C  
ATOM    725  OH  TYR A  97     -31.054  33.517  43.395  1.00 45.69           O  
ATOM    726  N   ARG A  98     -25.896  29.090  37.693  1.00 28.69           N  
ATOM    727  CA  ARG A  98     -24.932  28.753  36.630  1.00 28.10           C  
ATOM    728  C   ARG A  98     -25.543  28.774  35.252  1.00 28.90           C  
ATOM    729  O   ARG A  98     -26.773  28.653  35.070  1.00 28.38           O  
ATOM    730  CB  ARG A  98     -24.268  27.387  36.859  1.00 26.13           C  
ATOM    731  CG  ARG A  98     -23.528  27.320  38.192  1.00 23.76           C  
ATOM    732  CD  ARG A  98     -23.053  25.924  38.594  1.00 28.07           C  
ATOM    733  NE  ARG A  98     -22.530  26.003  39.969  1.00 25.61           N  
ATOM    734  CZ  ARG A  98     -22.313  24.997  40.788  1.00 23.39           C  
ATOM    735  NH1 ARG A  98     -22.620  23.742  40.418  1.00 27.37           N  
ATOM    736  NH2 ARG A  98     -21.865  25.264  42.027  1.00 21.55           N  
ATOM    737  N   ASN A  99     -24.621  28.807  34.287  1.00 29.19           N  
ATOM    738  CA  ASN A  99     -24.912  28.682  32.887  1.00 30.39           C  
ATOM    739  C   ASN A  99     -25.804  29.793  32.398  1.00 30.19           C  
ATOM    740  O   ASN A  99     -26.517  29.635  31.430  1.00 32.57           O  
ATOM    741  CB  ASN A  99     -25.507  27.294  32.558  1.00 30.66           C  
ATOM    742  CG  ASN A  99     -25.164  26.853  31.113  1.00 34.43           C  
ATOM    743  OD1 ASN A  99     -25.925  26.129  30.468  1.00 38.45           O  
ATOM    744  ND2 ASN A  99     -24.047  27.346  30.594  1.00 27.08           N  
ATOM    745  N   LYS A 100     -25.757  30.954  33.021  1.00 30.54           N  
ATOM    746  CA  LYS A 100     -26.651  32.026  32.574  1.00 30.80           C  
ATOM    747  C   LYS A 100     -25.843  33.319  32.263  1.00 30.53           C  
ATOM    748  O   LYS A 100     -26.391  34.384  32.242  1.00 29.89           O  
ATOM    749  CB  LYS A 100     -27.715  32.291  33.658  1.00 29.25           C  
ATOM    750  CG  LYS A 100     -28.792  31.145  33.842  1.00 31.22           C  
ATOM    751  CD  LYS A 100     -29.800  31.563  34.972  1.00 32.30           C  
ATOM    752  CE  LYS A 100     -30.470  30.393  35.643  1.00 34.91           C  
ATOM    753  NZ  LYS A 100     -29.516  29.261  35.901  1.00 36.74           N  
ATOM    754  N   GLY A 101     -24.536  33.227  32.084  1.00 28.33           N  
ATOM    755  CA  GLY A 101     -23.769  34.385  31.687  1.00 28.49           C  
ATOM    756  C   GLY A 101     -23.222  35.177  32.866  1.00 28.90           C  
ATOM    757  O   GLY A 101     -22.496  36.188  32.685  1.00 29.12           O  
ATOM    758  N   LEU A 102     -23.565  34.731  34.064  1.00 27.12           N  
ATOM    759  CA  LEU A 102     -23.133  35.406  35.280  1.00 28.12           C  
ATOM    760  C   LEU A 102     -21.594  35.278  35.613  1.00 27.32           C  
ATOM    761  O   LEU A 102     -20.927  36.254  36.060  1.00 27.35           O  
ATOM    762  CB  LEU A 102     -23.976  34.912  36.460  1.00 27.21           C  
ATOM    763  CG  LEU A 102     -23.612  35.519  37.813  1.00 34.05           C  
ATOM    764  CD1 LEU A 102     -23.952  37.113  37.778  1.00 33.25           C  
ATOM    765  CD2 LEU A 102     -24.421  34.792  38.873  1.00 34.25           C  
ATOM    766  N   GLY A 103     -21.024  34.119  35.342  1.00 26.26           N  
ATOM    767  CA  GLY A 103     -19.588  33.956  35.502  1.00 24.14           C  
ATOM    768  C   GLY A 103     -18.831  34.863  34.571  1.00 25.45           C  
ATOM    769  O   GLY A 103     -17.820  35.427  34.944  1.00 24.38           O  
ATOM    770  N   ALA A 104     -19.310  34.971  33.332  1.00 24.84           N  
ATOM    771  CA  ALA A 104     -18.696  35.866  32.342  1.00 26.58           C  
ATOM    772  C   ALA A 104     -18.711  37.275  32.822  1.00 27.79           C  
ATOM    773  O   ALA A 104     -17.685  37.929  32.766  1.00 29.82           O  
ATOM    774  CB  ALA A 104     -19.362  35.701  30.997  1.00 24.40           C  
ATOM    775  N   ARG A 105     -19.831  37.714  33.438  1.00 27.35           N  
ATOM    776  CA  ARG A 105     -19.915  39.077  33.960  1.00 26.43           C  
ATOM    777  C   ARG A 105     -19.036  39.322  35.152  1.00 26.62           C  
ATOM    778  O   ARG A 105     -18.391  40.335  35.252  1.00 25.28           O  
ATOM    779  CB  ARG A 105     -21.377  39.455  34.382  1.00 22.71           C  
ATOM    780  CG  ARG A 105     -22.472  39.469  33.297  1.00 24.37           C  
ATOM    781  CD  ARG A 105     -23.563  40.335  33.877  1.00 35.28           C  
ATOM    782  NE  ARG A 105     -24.654  39.636  34.375  1.00 43.20           N  
ATOM    783  CZ  ARG A 105     -25.432  40.026  35.385  1.00 45.26           C  
ATOM    784  NH1 ARG A 105     -25.191  41.103  36.127  1.00 42.77           N  
ATOM    785  NH2 ARG A 105     -26.460  39.251  35.665  1.00 42.86           N  
ATOM    786  N   LEU A 106     -19.071  38.420  36.110  1.00 28.52           N  
ATOM    787  CA  LEU A 106     -18.160  38.506  37.276  1.00 29.91           C  
ATOM    788  C   LEU A 106     -16.680  38.517  36.866  1.00 31.16           C  
ATOM    789  O   LEU A 106     -15.903  39.320  37.412  1.00 31.11           O  
ATOM    790  CB  LEU A 106     -18.396  37.293  38.157  1.00 29.27           C  
ATOM    791  CG  LEU A 106     -18.702  37.165  39.654  1.00 31.70           C  
ATOM    792  CD1 LEU A 106     -19.316  38.340  40.381  1.00 29.63           C  
ATOM    793  CD2 LEU A 106     -19.568  35.819  39.810  1.00 30.46           C  
HETATM  794  N   MSE A 107     -16.281  37.639  35.931  1.00 30.25           N  
HETATM  795  CA  MSE A 107     -14.919  37.640  35.415  1.00 35.40           C  
HETATM  796  C   MSE A 107     -14.508  38.942  34.757  1.00 31.74           C  
HETATM  797  O   MSE A 107     -13.474  39.443  35.065  1.00 29.34           O  
HETATM  798  CB  MSE A 107     -14.709  36.544  34.382  1.00 33.23           C  
HETATM  799  CG  MSE A 107     -13.293  35.890  34.445  1.00 44.56           C  
HETATM  800 SE   MSE A 107     -13.557  33.957  33.821  1.00 54.95          SE  
HETATM  801  CE  MSE A 107     -15.256  33.992  34.600  1.00 57.69           C  
ATOM    802  N   ARG A 108     -15.330  39.482  33.833  1.00 31.27           N  
ATOM    803  CA  ARG A 108     -15.057  40.779  33.227  1.00 30.51           C  
ATOM    804  C   ARG A 108     -14.801  41.920  34.173  1.00 30.85           C  
ATOM    805  O   ARG A 108     -13.914  42.765  33.921  1.00 29.70           O  
ATOM    806  CB  ARG A 108     -16.180  41.152  32.230  1.00 31.71           C  
ATOM    807  CG  ARG A 108     -16.266  40.116  31.173  1.00 30.31           C  
ATOM    808  CD  ARG A 108     -16.675  40.525  29.829  1.00 32.21           C  
ATOM    809  NE  ARG A 108     -17.690  39.615  29.362  1.00 32.71           N  
ATOM    810  CZ  ARG A 108     -17.592  38.689  28.423  1.00 39.79           C  
ATOM    811  NH1 ARG A 108     -16.423  38.429  27.673  1.00 40.57           N  
ATOM    812  NH2 ARG A 108     -18.743  38.031  28.208  1.00 31.53           N  
ATOM    813  N   ARG A 109     -15.645  42.024  35.198  1.00 30.21           N  
ATOM    814  CA  ARG A 109     -15.474  43.057  36.215  1.00 29.60           C  
ATOM    815  C   ARG A 109     -14.188  42.837  36.995  1.00 30.39           C  
ATOM    816  O   ARG A 109     -13.476  43.799  37.361  1.00 31.00           O  
ATOM    817  CB  ARG A 109     -16.647  43.065  37.204  1.00 29.25           C  
ATOM    818  CG  ARG A 109     -17.984  43.670  36.583  1.00 29.72           C  
ATOM    819  CD  ARG A 109     -17.765  45.227  36.341  1.00 31.39           C  
ATOM    820  NE  ARG A 109     -17.629  45.960  37.622  1.00 36.18           N  
ATOM    821  CZ  ARG A 109     -18.655  46.208  38.456  1.00 41.68           C  
ATOM    822  NH1 ARG A 109     -19.889  45.735  38.190  1.00 41.93           N  
ATOM    823  NH2 ARG A 109     -18.453  46.887  39.580  1.00 40.48           N  
ATOM    824  N   THR A 110     -13.924  41.581  37.329  1.00 29.53           N  
ATOM    825  CA  THR A 110     -12.797  41.227  38.196  1.00 28.69           C  
ATOM    826  C   THR A 110     -11.471  41.427  37.437  1.00 28.39           C  
ATOM    827  O   THR A 110     -10.535  41.937  38.006  1.00 29.07           O  
ATOM    828  CB  THR A 110     -12.947  39.797  38.783  1.00 29.09           C  
ATOM    829  OG1 THR A 110     -14.205  39.719  39.473  1.00 29.05           O  
ATOM    830  CG2 THR A 110     -11.751  39.400  39.796  1.00 26.79           C  
ATOM    831  N   LEU A 111     -11.402  41.044  36.164  1.00 28.20           N  
ATOM    832  CA  LEU A 111     -10.230  41.296  35.305  1.00 28.79           C  
ATOM    833  C   LEU A 111      -9.981  42.745  35.016  1.00 30.77           C  
ATOM    834  O   LEU A 111      -8.813  43.221  34.911  1.00 30.72           O  
ATOM    835  CB  LEU A 111     -10.373  40.521  33.971  1.00 27.88           C  
ATOM    836  CG  LEU A 111     -10.278  38.961  34.096  1.00 32.16           C  
ATOM    837  CD1 LEU A 111     -10.650  38.341  32.779  1.00 32.09           C  
ATOM    838  CD2 LEU A 111      -8.809  38.473  34.494  1.00 24.73           C  
ATOM    839  N   ASP A 112     -11.068  43.482  34.774  1.00 32.91           N  
ATOM    840  CA  ASP A 112     -10.885  44.865  34.591  1.00 33.15           C  
ATOM    841  C   ASP A 112     -10.301  45.536  35.861  1.00 32.87           C  
ATOM    842  O   ASP A 112      -9.342  46.320  35.775  1.00 31.64           O  
ATOM    843  CB  ASP A 112     -12.147  45.522  34.108  1.00 35.32           C  
ATOM    844  CG  ASP A 112     -11.833  46.512  32.934  1.00 43.33           C  
ATOM    845  OD1 ASP A 112     -11.441  46.060  31.766  1.00 47.49           O  
ATOM    846  OD2 ASP A 112     -11.902  47.711  33.236  1.00 37.98           O  
ATOM    847  N   ALA A 113     -10.825  45.215  37.043  1.00 31.73           N  
ATOM    848  CA  ALA A 113     -10.219  45.782  38.238  1.00 31.23           C  
ATOM    849  C   ALA A 113      -8.730  45.328  38.395  1.00 31.64           C  
ATOM    850  O   ALA A 113      -7.907  46.093  38.924  1.00 30.80           O  
ATOM    851  CB  ALA A 113     -10.981  45.381  39.422  1.00 31.87           C  
ATOM    852  N   ALA A 114      -8.397  44.092  37.997  1.00 30.39           N  
ATOM    853  CA  ALA A 114      -6.986  43.635  38.103  1.00 31.85           C  
ATOM    854  C   ALA A 114      -6.035  44.427  37.211  1.00 30.68           C  
ATOM    855  O   ALA A 114      -4.906  44.726  37.575  1.00 27.88           O  
ATOM    856  CB  ALA A 114      -6.835  42.144  37.816  1.00 30.45           C  
ATOM    857  N   HIS A 115      -6.519  44.713  36.017  1.00 30.88           N  
ATOM    858  CA  HIS A 115      -5.765  45.468  35.089  1.00 32.02           C  
ATOM    859  C   HIS A 115      -5.580  46.910  35.633  1.00 31.55           C  
ATOM    860  O   HIS A 115      -4.482  47.372  35.669  1.00 30.37           O  
ATOM    861  CB  HIS A 115      -6.474  45.429  33.748  1.00 33.18           C  
ATOM    862  CG  HIS A 115      -5.668  45.951  32.592  1.00 39.83           C  
ATOM    863  ND1 HIS A 115      -6.006  45.697  31.277  1.00 43.60           N  
ATOM    864  CD2 HIS A 115      -4.547  46.703  32.542  1.00 46.55           C  
ATOM    865  CE1 HIS A 115      -5.129  46.275  30.474  1.00 43.51           C  
ATOM    866  NE2 HIS A 115      -4.226  46.879  31.214  1.00 45.99           N  
ATOM    867  N   GLU A 116      -6.653  47.566  36.072  1.00 33.64           N  
ATOM    868  CA  GLU A 116      -6.597  48.864  36.711  1.00 36.69           C  
ATOM    869  C   GLU A 116      -5.628  48.865  37.862  1.00 36.77           C  
ATOM    870  O   GLU A 116      -4.892  49.795  38.044  1.00 37.31           O  
ATOM    871  CB  GLU A 116      -7.975  49.274  37.232  1.00 35.83           C  
ATOM    872  CG  GLU A 116      -8.113  50.880  37.496  1.00 39.17           C  
ATOM    873  CD  GLU A 116      -9.590  51.343  37.735  1.00 42.01           C  
ATOM    874  OE1 GLU A 116     -10.520  50.519  37.610  1.00 52.35           O  
ATOM    875  OE2 GLU A 116      -9.848  52.534  38.053  1.00 52.81           O  
ATOM    876  N   PHE A 117      -5.640  47.820  38.672  1.00 36.70           N  
ATOM    877  CA  PHE A 117      -4.681  47.745  39.756  1.00 37.64           C  
ATOM    878  C   PHE A 117      -3.222  47.679  39.238  1.00 35.80           C  
ATOM    879  O   PHE A 117      -2.341  47.966  39.971  1.00 37.35           O  
ATOM    880  CB  PHE A 117      -5.027  46.532  40.647  1.00 38.61           C  
ATOM    881  CG  PHE A 117      -4.043  46.250  41.745  1.00 44.47           C  
ATOM    882  CD1 PHE A 117      -4.394  46.511  43.099  1.00 47.32           C  
ATOM    883  CD2 PHE A 117      -2.746  45.714  41.457  1.00 47.62           C  
ATOM    884  CE1 PHE A 117      -3.486  46.235  44.152  1.00 45.21           C  
ATOM    885  CE2 PHE A 117      -1.834  45.437  42.490  1.00 49.28           C  
ATOM    886  CZ  PHE A 117      -2.223  45.702  43.856  1.00 46.53           C  
ATOM    887  N   GLY A 118      -2.924  47.196  38.035  1.00 34.33           N  
ATOM    888  CA  GLY A 118      -1.538  47.162  37.634  1.00 30.33           C  
ATOM    889  C   GLY A 118      -0.932  45.793  37.445  1.00 31.77           C  
ATOM    890  O   GLY A 118       0.245  45.701  37.174  1.00 31.35           O  
ATOM    891  N   LEU A 119      -1.734  44.724  37.553  1.00 31.15           N  
ATOM    892  CA  LEU A 119      -1.291  43.377  37.332  1.00 30.29           C  
ATOM    893  C   LEU A 119      -1.118  43.132  35.870  1.00 29.92           C  
ATOM    894  O   LEU A 119      -1.773  43.770  35.026  1.00 31.54           O  
ATOM    895  CB  LEU A 119      -2.254  42.360  37.963  1.00 31.49           C  
ATOM    896  CG  LEU A 119      -2.470  42.389  39.494  1.00 34.00           C  
ATOM    897  CD1 LEU A 119      -3.541  41.342  39.904  1.00 40.33           C  
ATOM    898  CD2 LEU A 119      -1.219  42.036  40.280  1.00 33.85           C  
ATOM    899  N   HIS A 120      -0.119  42.325  35.564  1.00 28.79           N  
ATOM    900  CA  HIS A 120       0.228  41.962  34.176  1.00 29.81           C  
ATOM    901  C   HIS A 120      -0.400  40.594  33.774  1.00 27.78           C  
ATOM    902  O   HIS A 120      -0.901  40.378  32.617  1.00 27.18           O  
ATOM    903  CB  HIS A 120       1.811  41.984  34.036  1.00 28.94           C  
ATOM    904  CG  HIS A 120       2.335  41.467  32.733  1.00 31.70           C  
ATOM    905  ND1 HIS A 120       2.329  42.212  31.569  1.00 30.72           N  
ATOM    906  CD2 HIS A 120       2.912  40.283  32.421  1.00 29.74           C  
ATOM    907  CE1 HIS A 120       2.888  41.515  30.605  1.00 28.67           C  
ATOM    908  NE2 HIS A 120       3.266  40.346  31.096  1.00 28.34           N  
ATOM    909  N   ARG A 121      -0.333  39.683  34.741  1.00 25.50           N  
ATOM    910  CA  ARG A 121      -0.615  38.257  34.526  1.00 25.38           C  
ATOM    911  C   ARG A 121      -1.626  37.692  35.525  1.00 24.16           C  
ATOM    912  O   ARG A 121      -1.487  37.900  36.722  1.00 25.97           O  
ATOM    913  CB  ARG A 121       0.683  37.460  34.451  1.00 24.92           C  
ATOM    914  CG  ARG A 121       0.508  35.930  34.297  1.00 22.01           C  
ATOM    915  CD  ARG A 121       1.898  35.331  34.387  1.00 23.54           C  
ATOM    916  NE  ARG A 121       1.671  33.927  34.699  1.00 25.95           N  
ATOM    917  CZ  ARG A 121       1.362  33.007  33.770  1.00 28.23           C  
ATOM    918  NH1 ARG A 121       1.337  33.309  32.447  1.00 23.20           N  
ATOM    919  NH2 ARG A 121       1.072  31.788  34.169  1.00 21.76           N  
ATOM    920  N   ILE A 122      -2.728  37.166  34.985  1.00 22.81           N  
ATOM    921  CA  ILE A 122      -3.730  36.432  35.726  1.00 23.57           C  
ATOM    922  C   ILE A 122      -3.683  34.904  35.392  1.00 24.54           C  
ATOM    923  O   ILE A 122      -3.761  34.515  34.266  1.00 22.85           O  
ATOM    924  CB  ILE A 122      -5.158  36.959  35.598  1.00 22.36           C  
ATOM    925  CG1 ILE A 122      -5.238  38.461  35.744  1.00 24.11           C  
ATOM    926  CG2 ILE A 122      -6.079  36.217  36.642  1.00 25.31           C  
ATOM    927  CD1 ILE A 122      -4.559  39.051  37.056  1.00 21.82           C  
ATOM    928  N   GLU A 123      -3.526  34.070  36.421  1.00 25.55           N  
ATOM    929  CA  GLU A 123      -3.381  32.647  36.215  1.00 27.86           C  
ATOM    930  C   GLU A 123      -4.393  31.880  37.051  1.00 25.00           C  
ATOM    931  O   GLU A 123      -4.963  32.428  37.981  1.00 25.15           O  
ATOM    932  CB  GLU A 123      -1.910  32.196  36.447  1.00 26.95           C  
ATOM    933  CG  GLU A 123      -1.530  32.035  37.865  1.00 32.68           C  
ATOM    934  CD  GLU A 123       0.058  31.836  38.132  1.00 37.55           C  
ATOM    935  OE1 GLU A 123       0.291  31.140  39.148  1.00 45.05           O  
ATOM    936  OE2 GLU A 123       1.006  32.294  37.376  1.00 44.66           O  
ATOM    937  N   LEU A 124      -4.693  30.665  36.602  1.00 25.03           N  
ATOM    938  CA  LEU A 124      -5.717  29.784  37.174  1.00 25.16           C  
ATOM    939  C   LEU A 124      -5.378  28.350  36.861  1.00 26.79           C  
ATOM    940  O   LEU A 124      -4.603  28.025  35.924  1.00 27.44           O  
ATOM    941  CB  LEU A 124      -7.147  30.177  36.715  1.00 24.98           C  
ATOM    942  CG  LEU A 124      -7.613  30.129  35.280  1.00 24.24           C  
ATOM    943  CD1 LEU A 124      -7.794  28.616  34.749  1.00 22.16           C  
ATOM    944  CD2 LEU A 124      -8.867  30.955  35.140  1.00 23.18           C  
ATOM    945  N   SER A 125      -5.881  27.479  37.707  1.00 28.70           N  
ATOM    946  CA  SER A 125      -5.831  26.031  37.494  1.00 29.56           C  
ATOM    947  C   SER A 125      -7.250  25.502  37.457  1.00 28.23           C  
ATOM    948  O   SER A 125      -8.031  25.913  38.275  1.00 29.43           O  
ATOM    949  CB  SER A 125      -5.116  25.408  38.674  1.00 29.52           C  
ATOM    950  OG  SER A 125      -3.711  25.574  38.359  1.00 42.23           O  
ATOM    951  N   VAL A 126      -7.578  24.610  36.531  1.00 25.14           N  
ATOM    952  CA  VAL A 126      -8.905  24.057  36.419  1.00 24.38           C  
ATOM    953  C   VAL A 126      -8.853  22.527  36.203  1.00 26.25           C  
ATOM    954  O   VAL A 126      -7.982  22.037  35.469  1.00 26.06           O  
ATOM    955  CB  VAL A 126      -9.706  24.812  35.290  1.00 23.78           C  
ATOM    956  CG1 VAL A 126      -9.017  24.639  33.874  1.00 17.49           C  
ATOM    957  CG2 VAL A 126     -11.097  24.415  35.249  1.00 20.30           C  
ATOM    958  N   HIS A 127      -9.784  21.789  36.820  1.00 25.96           N  
ATOM    959  CA  HIS A 127      -9.867  20.364  36.590  1.00 24.90           C  
ATOM    960  C   HIS A 127     -10.153  20.069  35.142  1.00 25.20           C  
ATOM    961  O   HIS A 127     -11.032  20.700  34.520  1.00 25.29           O  
ATOM    962  CB  HIS A 127     -10.895  19.658  37.521  1.00 23.92           C  
ATOM    963  CG  HIS A 127     -10.637  19.822  38.986  1.00 24.17           C  
ATOM    964  ND1 HIS A 127     -11.544  19.442  39.947  1.00 32.95           N  
ATOM    965  CD2 HIS A 127      -9.581  20.332  39.669  1.00 28.76           C  
ATOM    966  CE1 HIS A 127     -11.086  19.754  41.146  1.00 30.62           C  
ATOM    967  NE2 HIS A 127      -9.913  20.330  41.003  1.00 31.18           N  
ATOM    968  N   ALA A 128      -9.436  19.083  34.589  1.00 25.89           N  
ATOM    969  CA  ALA A 128      -9.506  18.794  33.139  1.00 26.82           C  
ATOM    970  C   ALA A 128     -10.912  18.372  32.715  1.00 27.43           C  
ATOM    971  O   ALA A 128     -11.305  18.505  31.532  1.00 27.60           O  
ATOM    972  CB  ALA A 128      -8.452  17.763  32.650  1.00 24.55           C  
ATOM    973  N   ASP A 129     -11.656  17.852  33.673  1.00 28.24           N  
ATOM    974  CA  ASP A 129     -13.009  17.437  33.422  1.00 29.91           C  
ATOM    975  C   ASP A 129     -14.092  18.521  33.756  1.00 28.98           C  
ATOM    976  O   ASP A 129     -15.271  18.294  33.538  1.00 26.82           O  
ATOM    977  CB  ASP A 129     -13.269  16.085  34.102  1.00 31.79           C  
ATOM    978  CG  ASP A 129     -13.224  16.162  35.655  1.00 40.40           C  
ATOM    979  OD1 ASP A 129     -12.917  17.246  36.228  1.00 45.60           O  
ATOM    980  OD2 ASP A 129     -13.509  15.109  36.322  1.00 49.84           O  
ATOM    981  N   ASN A 130     -13.680  19.725  34.188  1.00 27.60           N  
ATOM    982  CA  ASN A 130     -14.638  20.795  34.460  1.00 26.94           C  
ATOM    983  C   ASN A 130     -14.959  21.538  33.151  1.00 26.74           C  
ATOM    984  O   ASN A 130     -14.430  22.633  32.926  1.00 25.95           O  
ATOM    985  CB  ASN A 130     -14.046  21.765  35.470  1.00 25.80           C  
ATOM    986  CG  ASN A 130     -15.071  22.756  36.026  1.00 23.13           C  
ATOM    987  OD1 ASN A 130     -16.146  22.944  35.484  1.00 23.68           O  
ATOM    988  ND2 ASN A 130     -14.753  23.340  37.170  1.00 21.49           N  
ATOM    989  N   ALA A 131     -15.749  20.944  32.260  1.00 26.01           N  
ATOM    990  CA  ALA A 131     -15.854  21.543  30.866  1.00 26.33           C  
ATOM    991  C   ALA A 131     -16.556  22.918  30.810  1.00 25.95           C  
ATOM    992  O   ALA A 131     -16.272  23.789  29.929  1.00 27.75           O  
ATOM    993  CB  ALA A 131     -16.540  20.480  29.879  1.00 25.66           C  
ATOM    994  N   ARG A 132     -17.498  23.138  31.740  1.00 22.77           N  
ATOM    995  CA  ARG A 132     -18.143  24.395  31.826  1.00 22.37           C  
ATOM    996  C   ARG A 132     -17.167  25.582  32.203  1.00 23.46           C  
ATOM    997  O   ARG A 132     -17.257  26.648  31.580  1.00 22.41           O  
ATOM    998  CB  ARG A 132     -19.358  24.328  32.764  1.00 21.81           C  
ATOM    999  CG  ARG A 132     -19.815  25.715  33.138  1.00 24.69           C  
ATOM   1000  CD  ARG A 132     -21.198  25.729  33.702  1.00 27.45           C  
ATOM   1001  NE  ARG A 132     -21.344  24.455  34.355  1.00 39.09           N  
ATOM   1002  CZ  ARG A 132     -21.267  24.378  35.641  1.00 37.79           C  
ATOM   1003  NH1 ARG A 132     -21.127  25.550  36.211  1.00 49.39           N  
ATOM   1004  NH2 ARG A 132     -21.394  23.261  36.320  1.00 32.21           N  
ATOM   1005  N   ALA A 133     -16.290  25.374  33.220  1.00 21.28           N  
ATOM   1006  CA  ALA A 133     -15.321  26.375  33.625  1.00 21.89           C  
ATOM   1007  C   ALA A 133     -14.370  26.541  32.494  1.00 23.09           C  
ATOM   1008  O   ALA A 133     -14.134  27.666  32.124  1.00 25.00           O  
ATOM   1009  CB  ALA A 133     -14.505  25.997  34.959  1.00 19.87           C  
ATOM   1010  N   ILE A 134     -13.808  25.448  31.937  1.00 23.00           N  
ATOM   1011  CA  ILE A 134     -12.931  25.602  30.792  1.00 22.85           C  
ATOM   1012  C   ILE A 134     -13.519  26.462  29.623  1.00 23.41           C  
ATOM   1013  O   ILE A 134     -12.840  27.374  29.144  1.00 24.43           O  
ATOM   1014  CB  ILE A 134     -12.407  24.239  30.297  1.00 22.95           C  
ATOM   1015  CG1 ILE A 134     -11.481  23.603  31.354  1.00 19.43           C  
ATOM   1016  CG2 ILE A 134     -11.623  24.389  28.978  1.00 21.13           C  
ATOM   1017  CD1 ILE A 134     -11.509  22.116  31.188  1.00 18.10           C  
ATOM   1018  N   ALA A 135     -14.731  26.133  29.149  1.00 22.80           N  
ATOM   1019  CA  ALA A 135     -15.399  26.876  28.076  1.00 22.84           C  
ATOM   1020  C   ALA A 135     -15.575  28.319  28.411  1.00 23.14           C  
ATOM   1021  O   ALA A 135     -15.447  29.170  27.517  1.00 23.81           O  
ATOM   1022  CB  ALA A 135     -16.799  26.281  27.758  1.00 23.47           C  
ATOM   1023  N   LEU A 136     -15.907  28.619  29.667  1.00 22.90           N  
ATOM   1024  CA  LEU A 136     -15.999  30.035  30.077  1.00 23.28           C  
ATOM   1025  C   LEU A 136     -14.618  30.692  30.064  1.00 23.73           C  
ATOM   1026  O   LEU A 136     -14.463  31.807  29.558  1.00 24.27           O  
ATOM   1027  CB  LEU A 136     -16.644  30.215  31.473  1.00 23.68           C  
ATOM   1028  CG  LEU A 136     -16.568  31.677  32.005  1.00 23.56           C  
ATOM   1029  CD1 LEU A 136     -17.358  32.568  31.094  1.00 24.88           C  
ATOM   1030  CD2 LEU A 136     -16.985  31.929  33.459  1.00 21.60           C  
ATOM   1031  N   TYR A 137     -13.610  30.034  30.607  1.00 23.28           N  
ATOM   1032  CA  TYR A 137     -12.264  30.634  30.543  1.00 23.49           C  
ATOM   1033  C   TYR A 137     -11.767  30.860  29.115  1.00 23.25           C  
ATOM   1034  O   TYR A 137     -11.205  31.879  28.830  1.00 19.78           O  
ATOM   1035  CB  TYR A 137     -11.245  29.784  31.308  1.00 22.91           C  
ATOM   1036  CG  TYR A 137     -11.593  29.611  32.734  1.00 23.85           C  
ATOM   1037  CD1 TYR A 137     -12.243  30.637  33.442  1.00 27.08           C  
ATOM   1038  CD2 TYR A 137     -11.314  28.396  33.415  1.00 26.08           C  
ATOM   1039  CE1 TYR A 137     -12.674  30.455  34.812  1.00 26.26           C  
ATOM   1040  CE2 TYR A 137     -11.638  28.229  34.794  1.00 24.26           C  
ATOM   1041  CZ  TYR A 137     -12.317  29.254  35.481  1.00 28.90           C  
ATOM   1042  OH  TYR A 137     -12.641  29.082  36.816  1.00 29.17           O  
ATOM   1043  N   GLU A 138     -11.975  29.884  28.222  1.00 24.49           N  
ATOM   1044  CA  GLU A 138     -11.658  30.113  26.788  1.00 27.63           C  
ATOM   1045  C   GLU A 138     -12.386  31.344  26.198  1.00 27.72           C  
ATOM   1046  O   GLU A 138     -11.771  32.162  25.572  1.00 26.63           O  
ATOM   1047  CB  GLU A 138     -11.956  28.853  25.935  1.00 26.04           C  
ATOM   1048  CG  GLU A 138     -10.944  27.742  26.364  1.00 27.60           C  
ATOM   1049  CD  GLU A 138     -11.223  26.378  25.732  1.00 29.83           C  
ATOM   1050  OE1 GLU A 138     -12.332  26.185  25.201  1.00 36.89           O  
ATOM   1051  OE2 GLU A 138     -10.364  25.472  25.810  1.00 35.04           O  
ATOM   1052  N   LYS A 139     -13.695  31.461  26.458  1.00 28.91           N  
ATOM   1053  CA  LYS A 139     -14.507  32.513  25.931  1.00 29.01           C  
ATOM   1054  C   LYS A 139     -13.953  33.837  26.415  1.00 29.48           C  
ATOM   1055  O   LYS A 139     -13.842  34.757  25.657  1.00 29.56           O  
ATOM   1056  CB  LYS A 139     -15.938  32.340  26.431  1.00 29.71           C  
ATOM   1057  CG  LYS A 139     -16.850  33.363  25.964  1.00 31.92           C  
ATOM   1058  CD  LYS A 139     -17.955  33.655  26.931  1.00 41.36           C  
ATOM   1059  CE  LYS A 139     -18.702  32.388  27.394  1.00 47.61           C  
ATOM   1060  NZ  LYS A 139     -19.947  32.846  28.177  1.00 55.76           N  
ATOM   1061  N   ILE A 140     -13.632  33.948  27.708  1.00 29.19           N  
ATOM   1062  CA  ILE A 140     -13.128  35.214  28.246  1.00 27.63           C  
ATOM   1063  C   ILE A 140     -11.756  35.583  27.637  1.00 27.33           C  
ATOM   1064  O   ILE A 140     -11.431  36.723  27.641  1.00 25.20           O  
ATOM   1065  CB  ILE A 140     -12.992  35.124  29.784  1.00 28.55           C  
ATOM   1066  CG1 ILE A 140     -14.379  34.946  30.443  1.00 27.12           C  
ATOM   1067  CG2 ILE A 140     -12.278  36.357  30.356  1.00 30.02           C  
ATOM   1068  CD1 ILE A 140     -15.434  35.967  30.150  1.00 24.36           C  
ATOM   1069  N   GLY A 141     -10.959  34.604  27.151  1.00 26.28           N  
ATOM   1070  CA  GLY A 141      -9.693  34.874  26.500  1.00 23.91           C  
ATOM   1071  C   GLY A 141      -8.470  34.318  27.290  1.00 25.23           C  
ATOM   1072  O   GLY A 141      -7.342  34.649  26.965  1.00 23.86           O  
ATOM   1073  N   PHE A 142      -8.664  33.399  28.258  1.00 24.85           N  
ATOM   1074  CA  PHE A 142      -7.524  32.690  28.869  1.00 23.94           C  
ATOM   1075  C   PHE A 142      -6.903  31.744  27.829  1.00 24.67           C  
ATOM   1076  O   PHE A 142      -7.601  31.205  27.038  1.00 25.66           O  
ATOM   1077  CB  PHE A 142      -7.908  31.914  30.110  1.00 22.41           C  
ATOM   1078  CG  PHE A 142      -8.066  32.788  31.302  1.00 24.68           C  
ATOM   1079  CD1 PHE A 142      -9.223  33.570  31.468  1.00 22.47           C  
ATOM   1080  CD2 PHE A 142      -7.076  32.822  32.288  1.00 19.51           C  
ATOM   1081  CE1 PHE A 142      -9.384  34.367  32.598  1.00 27.40           C  
ATOM   1082  CE2 PHE A 142      -7.220  33.646  33.427  1.00 28.39           C  
ATOM   1083  CZ  PHE A 142      -8.381  34.398  33.609  1.00 24.57           C  
ATOM   1084  N   ALA A 143      -5.582  31.657  27.801  1.00 23.74           N  
ATOM   1085  CA  ALA A 143      -4.829  30.737  27.010  1.00 23.53           C  
ATOM   1086  C   ALA A 143      -4.478  29.498  27.856  1.00 24.13           C  
ATOM   1087  O   ALA A 143      -4.096  29.600  29.069  1.00 23.94           O  
ATOM   1088  CB  ALA A 143      -3.521  31.445  26.497  1.00 20.85           C  
ATOM   1089  N   HIS A 144      -4.512  28.333  27.206  1.00 23.76           N  
ATOM   1090  CA  HIS A 144      -3.961  27.170  27.811  1.00 23.80           C  
ATOM   1091  C   HIS A 144      -2.459  27.239  27.891  1.00 25.86           C  
ATOM   1092  O   HIS A 144      -1.777  27.564  26.897  1.00 25.02           O  
ATOM   1093  CB  HIS A 144      -4.395  25.898  26.984  1.00 23.89           C  
ATOM   1094  CG  HIS A 144      -5.863  25.578  27.127  1.00 22.62           C  
ATOM   1095  ND1 HIS A 144      -6.360  24.890  28.203  1.00 23.03           N  
ATOM   1096  CD2 HIS A 144      -6.933  25.881  26.352  1.00 22.97           C  
ATOM   1097  CE1 HIS A 144      -7.662  24.721  28.066  1.00 26.10           C  
ATOM   1098  NE2 HIS A 144      -8.041  25.355  26.971  1.00 27.17           N  
ATOM   1099  N   GLU A 145      -1.929  26.793  29.026  1.00 26.37           N  
ATOM   1100  CA  GLU A 145      -0.493  26.876  29.273  1.00 27.85           C  
ATOM   1101  C   GLU A 145       0.112  25.551  29.595  1.00 28.19           C  
ATOM   1102  O   GLU A 145       1.309  25.510  29.653  1.00 30.43           O  
ATOM   1103  CB  GLU A 145      -0.136  27.817  30.424  1.00 25.94           C  
ATOM   1104  CG  GLU A 145      -0.302  29.268  29.998  1.00 28.95           C  
ATOM   1105  CD  GLU A 145       0.438  30.217  30.943  1.00 29.29           C  
ATOM   1106  OE1 GLU A 145       0.968  31.242  30.454  1.00 24.23           O  
ATOM   1107  OE2 GLU A 145       0.477  29.912  32.186  1.00 29.42           O  
ATOM   1108  N   GLY A 146      -0.714  24.521  29.809  1.00 26.37           N  
ATOM   1109  CA  GLY A 146      -0.282  23.177  29.951  1.00 24.71           C  
ATOM   1110  C   GLY A 146      -1.142  22.339  30.864  1.00 25.58           C  
ATOM   1111  O   GLY A 146      -2.049  22.856  31.475  1.00 24.66           O  
ATOM   1112  N   ARG A 147      -0.824  21.034  30.993  1.00 26.31           N  
ATOM   1113  CA  ARG A 147      -1.735  20.056  31.602  1.00 26.64           C  
ATOM   1114  C   ARG A 147      -0.906  19.428  32.713  1.00 27.05           C  
ATOM   1115  O   ARG A 147       0.206  19.003  32.491  1.00 27.49           O  
ATOM   1116  CB  ARG A 147      -2.098  19.064  30.522  1.00 27.40           C  
ATOM   1117  CG  ARG A 147      -2.792  17.855  30.945  1.00 30.74           C  
ATOM   1118  CD  ARG A 147      -3.239  17.141  29.697  1.00 37.23           C  
ATOM   1119  NE  ARG A 147      -4.632  16.702  29.759  1.00 43.66           N  
ATOM   1120  CZ  ARG A 147      -5.592  17.210  28.969  1.00 46.06           C  
ATOM   1121  NH1 ARG A 147      -5.311  18.116  28.036  1.00 45.36           N  
ATOM   1122  NH2 ARG A 147      -6.833  16.811  29.098  1.00 47.80           N  
ATOM   1123  N   ALA A 148      -1.409  19.441  33.934  1.00 26.59           N  
ATOM   1124  CA  ALA A 148      -0.713  18.781  35.027  1.00 25.28           C  
ATOM   1125  C   ALA A 148      -1.287  17.371  35.293  1.00 24.09           C  
ATOM   1126  O   ALA A 148      -2.360  17.296  35.747  1.00 22.85           O  
ATOM   1127  CB  ALA A 148      -0.807  19.699  36.285  1.00 24.43           C  
ATOM   1128  N   ARG A 149      -0.539  16.276  35.070  1.00 23.83           N  
ATOM   1129  CA  ARG A 149      -1.104  14.935  35.148  1.00 26.44           C  
ATOM   1130  C   ARG A 149      -1.258  14.489  36.598  1.00 25.08           C  
ATOM   1131  O   ARG A 149      -0.306  14.557  37.338  1.00 22.60           O  
ATOM   1132  CB  ARG A 149      -0.221  13.874  34.421  1.00 26.92           C  
ATOM   1133  CG  ARG A 149       0.332  14.365  33.055  1.00 35.36           C  
ATOM   1134  CD  ARG A 149      -0.719  14.264  31.867  1.00 42.79           C  
ATOM   1135  NE  ARG A 149      -1.618  13.078  31.906  1.00 49.60           N  
ATOM   1136  CZ  ARG A 149      -1.323  11.819  31.502  1.00 56.43           C  
ATOM   1137  NH1 ARG A 149      -0.148  11.473  30.961  1.00 55.61           N  
ATOM   1138  NH2 ARG A 149      -2.254  10.873  31.602  1.00 58.99           N  
ATOM   1139  N   ASP A 150      -2.420  13.943  36.947  1.00 23.73           N  
ATOM   1140  CA  ASP A 150      -2.638  13.491  38.327  1.00 24.75           C  
ATOM   1141  C   ASP A 150      -2.379  14.585  39.402  1.00 23.38           C  
ATOM   1142  O   ASP A 150      -1.903  14.292  40.453  1.00 23.72           O  
ATOM   1143  CB  ASP A 150      -1.757  12.281  38.674  1.00 21.99           C  
ATOM   1144  CG  ASP A 150      -2.095  11.019  37.866  1.00 25.69           C  
ATOM   1145  OD1 ASP A 150      -3.134  11.075  37.115  1.00 24.57           O  
ATOM   1146  OD2 ASP A 150      -1.297   9.975  38.009  1.00 24.61           O  
ATOM   1147  N   ALA A 151      -2.680  15.814  39.130  1.00 23.84           N  
ATOM   1148  CA  ALA A 151      -2.302  16.903  40.045  1.00 24.82           C  
ATOM   1149  C   ALA A 151      -3.322  17.040  41.198  1.00 25.31           C  
ATOM   1150  O   ALA A 151      -3.003  17.633  42.203  1.00 25.05           O  
ATOM   1151  CB  ALA A 151      -2.143  18.226  39.311  1.00 23.14           C  
ATOM   1152  N   VAL A 152      -4.495  16.415  41.053  1.00 25.80           N  
ATOM   1153  CA  VAL A 152      -5.668  16.591  41.962  1.00 24.71           C  
ATOM   1154  C   VAL A 152      -6.059  15.173  42.381  1.00 24.48           C  
ATOM   1155  O   VAL A 152      -6.002  14.245  41.589  1.00 24.73           O  
ATOM   1156  CB  VAL A 152      -6.841  17.397  41.258  1.00 25.42           C  
ATOM   1157  CG1 VAL A 152      -8.165  17.409  42.090  1.00 26.38           C  
ATOM   1158  CG2 VAL A 152      -6.469  18.833  41.032  1.00 20.55           C  
ATOM   1159  N   SER A 153      -6.369  14.962  43.633  1.00 24.17           N  
ATOM   1160  CA  SER A 153      -6.895  13.638  44.049  1.00 27.44           C  
ATOM   1161  C   SER A 153      -8.114  13.997  44.891  1.00 28.79           C  
ATOM   1162  O   SER A 153      -8.022  14.897  45.741  1.00 28.24           O  
ATOM   1163  CB  SER A 153      -5.867  12.927  44.919  1.00 26.77           C  
ATOM   1164  OG  SER A 153      -6.283  11.655  45.319  1.00 30.48           O  
ATOM   1165  N   ILE A 154      -9.270  13.431  44.620  1.00 30.55           N  
ATOM   1166  CA  ILE A 154     -10.412  13.869  45.415  1.00 34.55           C  
ATOM   1167  C   ILE A 154     -10.983  12.843  46.442  1.00 37.79           C  
ATOM   1168  O   ILE A 154     -11.361  13.193  47.594  1.00 41.50           O  
ATOM   1169  CB  ILE A 154     -11.503  14.574  44.599  1.00 33.13           C  
ATOM   1170  CG1 ILE A 154     -11.035  15.973  44.275  1.00 33.56           C  
ATOM   1171  CG2 ILE A 154     -12.807  14.671  45.442  1.00 34.86           C  
ATOM   1172  CD1 ILE A 154     -11.920  16.770  43.274  1.00 34.19           C  
ATOM   1173  N   ASP A 155     -11.089  11.594  46.056  1.00 38.63           N  
ATOM   1174  CA  ASP A 155     -11.279  10.584  47.048  1.00 39.43           C  
ATOM   1175  C   ASP A 155     -10.790   9.300  46.406  1.00 39.18           C  
ATOM   1176  O   ASP A 155     -11.550   8.500  45.871  1.00 38.91           O  
ATOM   1177  CB  ASP A 155     -12.723  10.551  47.603  1.00 41.61           C  
ATOM   1178  CG  ASP A 155     -13.783  10.483  46.527  1.00 42.76           C  
ATOM   1179  OD1 ASP A 155     -14.758  11.310  46.586  1.00 41.06           O  
ATOM   1180  OD2 ASP A 155     -13.623   9.575  45.667  1.00 44.40           O  
ATOM   1181  N   GLY A 156      -9.465   9.204  46.383  1.00 38.75           N  
ATOM   1182  CA  GLY A 156      -8.737   8.069  45.846  1.00 37.06           C  
ATOM   1183  C   GLY A 156      -8.748   8.065  44.348  1.00 36.33           C  
ATOM   1184  O   GLY A 156      -8.245   7.110  43.749  1.00 37.62           O  
ATOM   1185  N   HIS A 157      -9.316   9.114  43.734  1.00 34.42           N  
ATOM   1186  CA  HIS A 157      -9.230   9.267  42.270  1.00 33.80           C  
ATOM   1187  C   HIS A 157      -8.327  10.460  41.838  1.00 30.90           C  
ATOM   1188  O   HIS A 157      -8.509  11.538  42.336  1.00 28.93           O  
ATOM   1189  CB  HIS A 157     -10.619   9.386  41.637  1.00 33.26           C  
ATOM   1190  CG  HIS A 157     -11.484   8.188  41.860  1.00 38.29           C  
ATOM   1191  ND1 HIS A 157     -10.996   6.894  41.789  1.00 41.17           N  
ATOM   1192  CD2 HIS A 157     -12.805   8.080  42.165  1.00 40.22           C  
ATOM   1193  CE1 HIS A 157     -11.976   6.038  42.038  1.00 43.10           C  
ATOM   1194  NE2 HIS A 157     -13.085   6.734  42.264  1.00 45.63           N  
ATOM   1195  N   TYR A 158      -7.372  10.208  40.942  1.00 30.14           N  
ATOM   1196  CA  TYR A 158      -6.540  11.258  40.308  1.00 30.13           C  
ATOM   1197  C   TYR A 158      -7.210  11.975  39.150  1.00 29.25           C  
ATOM   1198  O   TYR A 158      -7.692  11.336  38.227  1.00 29.33           O  
ATOM   1199  CB  TYR A 158      -5.210  10.683  39.792  1.00 30.19           C  
ATOM   1200  CG  TYR A 158      -4.316  10.153  40.881  1.00 31.07           C  
ATOM   1201  CD1 TYR A 158      -3.848   8.850  40.843  1.00 32.60           C  
ATOM   1202  CD2 TYR A 158      -3.966  10.949  41.979  1.00 29.34           C  
ATOM   1203  CE1 TYR A 158      -3.077   8.333  41.891  1.00 31.97           C  
ATOM   1204  CE2 TYR A 158      -3.142  10.441  43.012  1.00 27.83           C  
ATOM   1205  CZ  TYR A 158      -2.716   9.157  42.968  1.00 30.55           C  
ATOM   1206  OH  TYR A 158      -1.953   8.658  44.023  1.00 32.56           O  
ATOM   1207  N   ILE A 159      -7.148  13.303  39.189  1.00 29.52           N  
ATOM   1208  CA  ILE A 159      -7.658  14.233  38.153  1.00 29.14           C  
ATOM   1209  C   ILE A 159      -6.474  15.063  37.608  1.00 27.44           C  
ATOM   1210  O   ILE A 159      -5.640  15.564  38.359  1.00 25.30           O  
ATOM   1211  CB  ILE A 159      -8.737  15.272  38.749  1.00 29.23           C  
ATOM   1212  CG1 ILE A 159      -9.728  14.610  39.703  1.00 34.79           C  
ATOM   1213  CG2 ILE A 159      -9.529  15.998  37.684  1.00 30.84           C  
ATOM   1214  CD1 ILE A 159     -10.285  13.390  39.160  1.00 36.88           C  
ATOM   1215  N   ASP A 160      -6.418  15.205  36.298  1.00 26.41           N  
ATOM   1216  CA  ASP A 160      -5.581  16.224  35.682  1.00 26.04           C  
ATOM   1217  C   ASP A 160      -6.075  17.634  35.924  1.00 25.97           C  
ATOM   1218  O   ASP A 160      -7.276  17.939  36.073  1.00 24.13           O  
ATOM   1219  CB  ASP A 160      -5.507  15.947  34.182  1.00 27.17           C  
ATOM   1220  CG  ASP A 160      -4.752  14.630  33.871  1.00 27.06           C  
ATOM   1221  OD1 ASP A 160      -4.451  13.862  34.793  1.00 27.23           O  
ATOM   1222  OD2 ASP A 160      -4.454  14.352  32.704  1.00 32.50           O  
ATOM   1223  N   SER A 161      -5.123  18.520  35.948  1.00 25.84           N  
ATOM   1224  CA  SER A 161      -5.465  19.932  36.094  1.00 27.48           C  
ATOM   1225  C   SER A 161      -4.896  20.647  34.847  1.00 25.37           C  
ATOM   1226  O   SER A 161      -3.873  20.263  34.335  1.00 25.46           O  
ATOM   1227  CB  SER A 161      -4.808  20.496  37.368  1.00 26.97           C  
ATOM   1228  OG  SER A 161      -5.606  21.547  37.827  1.00 36.76           O  
ATOM   1229  N   LEU A 162      -5.577  21.656  34.357  1.00 25.00           N  
ATOM   1230  CA  LEU A 162      -5.092  22.479  33.244  1.00 23.60           C  
ATOM   1231  C   LEU A 162      -4.730  23.797  33.772  1.00 23.24           C  
ATOM   1232  O   LEU A 162      -5.511  24.433  34.517  1.00 22.61           O  
ATOM   1233  CB  LEU A 162      -6.181  22.706  32.188  1.00 21.86           C  
ATOM   1234  CG  LEU A 162      -6.805  21.422  31.594  1.00 19.39           C  
ATOM   1235  CD1 LEU A 162      -7.829  21.713  30.480  1.00 19.17           C  
ATOM   1236  CD2 LEU A 162      -5.765  20.366  31.122  1.00 19.97           C  
ATOM   1237  N   ASN A 163      -3.571  24.253  33.353  1.00 22.93           N  
ATOM   1238  CA  ASN A 163      -3.140  25.629  33.714  1.00 23.73           C  
ATOM   1239  C   ASN A 163      -3.438  26.562  32.614  1.00 23.04           C  
ATOM   1240  O   ASN A 163      -3.171  26.248  31.482  1.00 23.37           O  
ATOM   1241  CB  ASN A 163      -1.624  25.680  33.950  1.00 25.48           C  
ATOM   1242  CG  ASN A 163      -1.260  24.903  35.163  1.00 29.56           C  
ATOM   1243  OD1 ASN A 163      -1.808  25.190  36.176  1.00 33.30           O  
ATOM   1244  ND2 ASN A 163      -0.449  23.840  35.040  1.00 33.45           N  
HETATM 1245  N   MSE A 164      -3.924  27.731  32.947  1.00 22.81           N  
HETATM 1246  CA  MSE A 164      -4.347  28.673  31.921  1.00 25.93           C  
HETATM 1247  C   MSE A 164      -3.935  30.030  32.459  1.00 24.80           C  
HETATM 1248  O   MSE A 164      -3.788  30.174  33.656  1.00 25.20           O  
HETATM 1249  CB  MSE A 164      -5.854  28.598  31.713  1.00 23.76           C  
HETATM 1250  CG  MSE A 164      -6.362  27.112  31.312  1.00 24.63           C  
HETATM 1251 SE   MSE A 164      -8.289  27.364  30.899  1.00 39.00          SE  
HETATM 1252  CE  MSE A 164      -8.061  28.293  29.084  1.00 21.18           C  
ATOM   1253  N   ALA A 165      -3.760  31.000  31.577  1.00 23.89           N  
ATOM   1254  CA  ALA A 165      -3.392  32.339  31.969  1.00 25.73           C  
ATOM   1255  C   ALA A 165      -3.844  33.410  30.945  1.00 24.45           C  
ATOM   1256  O   ALA A 165      -4.019  33.134  29.727  1.00 23.98           O  
ATOM   1257  CB  ALA A 165      -1.900  32.428  32.244  1.00 24.61           C  
ATOM   1258  N   ILE A 166      -4.027  34.617  31.449  1.00 23.92           N  
ATOM   1259  CA  ILE A 166      -4.257  35.777  30.583  1.00 25.85           C  
ATOM   1260  C   ILE A 166      -3.209  36.827  30.848  1.00 25.95           C  
ATOM   1261  O   ILE A 166      -2.792  37.007  31.980  1.00 26.24           O  
ATOM   1262  CB  ILE A 166      -5.737  36.328  30.748  1.00 25.36           C  
ATOM   1263  CG1 ILE A 166      -6.223  37.093  29.517  1.00 29.64           C  
ATOM   1264  CG2 ILE A 166      -5.899  37.065  32.100  1.00 27.81           C  
ATOM   1265  CD1 ILE A 166      -7.850  37.240  29.497  1.00 29.36           C  
ATOM   1266  N   ILE A 167      -2.747  37.511  29.797  1.00 28.21           N  
ATOM   1267  CA  ILE A 167      -1.752  38.583  29.956  1.00 28.84           C  
ATOM   1268  C   ILE A 167      -2.407  39.876  29.452  1.00 29.54           C  
ATOM   1269  O   ILE A 167      -2.981  39.889  28.342  1.00 26.29           O  
ATOM   1270  CB  ILE A 167      -0.360  38.294  29.314  1.00 29.59           C  
ATOM   1271  CG1 ILE A 167       0.492  37.382  30.206  1.00 31.20           C  
ATOM   1272  CG2 ILE A 167       0.485  39.608  29.064  1.00 27.11           C  
ATOM   1273  CD1 ILE A 167       0.915  36.337  29.470  1.00 34.38           C  
ATOM   1274  N   PHE A 168      -2.410  40.927  30.306  1.00 30.35           N  
ATOM   1275  CA  PHE A 168      -3.055  42.193  29.888  1.00 32.02           C  
ATOM   1276  C   PHE A 168      -2.121  42.891  28.913  1.00 33.96           C  
ATOM   1277  O   PHE A 168      -0.893  42.964  29.124  1.00 34.09           O  
ATOM   1278  CB  PHE A 168      -3.390  43.113  31.050  1.00 30.01           C  
ATOM   1279  CG  PHE A 168      -4.410  42.570  31.964  1.00 31.14           C  
ATOM   1280  CD1 PHE A 168      -4.083  42.379  33.314  1.00 25.52           C  
ATOM   1281  CD2 PHE A 168      -5.718  42.198  31.473  1.00 27.32           C  
ATOM   1282  CE1 PHE A 168      -4.995  41.860  34.180  1.00 25.07           C  
ATOM   1283  CE2 PHE A 168      -6.638  41.651  32.322  1.00 26.19           C  
ATOM   1284  CZ  PHE A 168      -6.307  41.506  33.689  1.00 29.81           C  
ATOM   1285  N   GLY A 169      -2.733  43.294  27.816  1.00 37.34           N  
ATOM   1286  CA  GLY A 169      -2.094  44.119  26.806  1.00 40.98           C  
ATOM   1287  C   GLY A 169      -2.754  45.452  26.988  1.00 43.33           C  
ATOM   1288  O   GLY A 169      -2.137  46.463  26.671  1.00 47.97           O  
TER    1289      GLY A 169                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
