
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  154 ( 1250),  selected  154 , name 2fe7_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 2fe7_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A       2           -
LGA    L     3_A      I       3          1.548
LGA    E     4_A      N       4          0.612
LGA    I     5_A      I       5          0.623
LGA    R     6_A      I       6          0.830
LGA    P     7_A      E       7          0.683
LGA    A     8_A      Y       8          0.383
LGA    V     9_A      N       9          0.629
LGA    P    10_A      R      10          0.732
LGA    A    11_A      S      11          0.530
LGA    D    12_A      Y      12          0.749
LGA    A    13_A      K      13          0.306
LGA    E    14_A      E      14          1.498
LGA    Q    15_A      E      15          1.229
LGA    I    16_A      L      16          0.651
LGA    L    17_A      I      17          0.678
LGA    A    18_A      E      18          1.048
LGA    F    19_A      F      19          1.268
LGA    I    20_A      I      20          1.718
LGA    I    21_A      L      21          0.572
LGA    E    22_A      S      22          1.934
LGA    L    23_A      I      23          2.954
LGA    A    24_A      Q      24          1.842
LGA    D    25_A      K      25          1.566
LGA    -       -      N      26           -
LGA    Y    26_A      E      27          3.840
LGA    E    27_A      F      28          4.221
LGA    R    28_A      N      29          2.614
LGA    A    29_A      I      30          2.232
LGA    R    30_A      K      31          5.119
LGA    H    31_A      -       -           -
LGA    E    32_A      I      32          2.391
LGA    V    33_A      D      33          1.517
LGA    V    34_A      R      34          3.331
LGA    T    35_A      D      35          3.933
LGA    D    36_A      D      36           -
LGA    V    37_A      Q      37           -
LGA    E    38_A      P      38           -
LGA    -       -      D      39           -
LGA    G    39_A      L      40           #
LGA    I    40_A      E      41          1.413
LGA    R    41_A      -       -           -
LGA    R    42_A      -       -           -
LGA    S    43_A      N      42          2.935
LGA    L    44_A      I      43          2.442
LGA    F    45_A      E      44          3.414
LGA    A    46_A      -       -           -
LGA    E    47_A      -       -           -
LGA    G    48_A      -       -           -
LGA    S    49_A      H      45          1.493
LGA    P    50_A      N      46          3.581
LGA    T    51_A      Y      47          1.262
LGA    R    52_A      L      48          3.680
LGA    -       -      N      49           -
LGA    -       -      S      50           -
LGA    -       -      G      51           -
LGA    -       -      G      52           -
LGA    -       -      Q      53           -
LGA    A    53_A      F      54          1.982
LGA    L    54_A      W      55          1.202
LGA    M    55_A      L      56          0.846
LGA    C    56_A      A      57          0.495
LGA    L    57_A      I      58          0.939
LGA    S    58_A      N      59          2.054
LGA    E    59_A      N      60          1.725
LGA    G    60_A      H      61          3.445
LGA    R    61_A      Q      62          3.215
LGA    P    62_A      N      63          2.362
LGA    -       -      I      64           -
LGA    I    63_A      V      65          0.785
LGA    G    64_A      G      66          1.187
LGA    Y    65_A      T      67          1.135
LGA    A    66_A      I      68          1.581
LGA    V    67_A      G      69          2.457
LGA    F    68_A      L      70          2.263
LGA    F    69_A      I      71          1.100
LGA    Y    70_A      R      72          0.585
LGA    S    71_A      L      73          1.237
LGA    Y    72_A      D      74          2.452
LGA    S    73_A      N      75          3.011
LGA    T    74_A      -       -           -
LGA    W    75_A      -       -           -
LGA    L    76_A      -       -           -
LGA    G    77_A      -       -           -
LGA    R    78_A      -       -           -
LGA    N    79_A      N      76          1.695
LGA    G    80_A      M      77          2.406
LGA    I    81_A      S      78          2.446
LGA    Y    82_A      A      79          0.976
LGA    L    83_A      L      80          1.228
LGA    E    84_A      K      81          1.538
LGA    D    85_A      K      82          0.728
LGA    L    86_A      M      83          0.495
LGA    Y    87_A      F      84          0.569
LGA    V    88_A      V      85          0.739
LGA    T    89_A      D      86          0.516
LGA    P    90_A      K      87          0.546
LGA    E    91_A      G      88          0.524
LGA    Y    92_A      Y      89          0.471
LGA    R    93_A      R      90          0.514
LGA    -       -      N      91           -
LGA    -       -      L      92           -
LGA    G    96_A      K      93          0.714
LGA    A    97_A      I      94          0.444
LGA    G    98_A      G      95          0.606
LGA    R    99_A      K      96          0.595
LGA    R   100_A      K      97          0.490
LGA    L   101_A      L      98          0.453
LGA    L   102_A      L      99          0.357
LGA    R   103_A      D     100          0.410
LGA    E   104_A      K     101          0.459
LGA    L   105_A      V     102          0.546
LGA    A   106_A      I     103          0.441
LGA    R   107_A      M     104          0.779
LGA    E   108_A      T     105          1.071
LGA    A   109_A      C     106          0.655
LGA    V   110_A      K     107          0.287
LGA    A   111_A      E     108          0.370
LGA    N   112_A      Q     109          0.281
LGA    D   113_A      N     110          0.471
LGA    C   114_A      I     111          0.366
LGA    G   115_A      D     112          0.267
LGA    R   116_A      G     113          0.419
LGA    L   117_A      I     114          1.896
LGA    E   118_A      Y     115          2.275
LGA    W   119_A      L     116          1.548
LGA    S   120_A      G     117          1.581
LGA    V   121_A      T     118          1.821
LGA    L   122_A      I     119          1.216
LGA    D   123_A      D     120          2.886
LGA    W   124_A      K     121          4.039
LGA    N   125_A      F     122          3.057
LGA    Q   126_A      I     123          2.644
LGA    P   127_A      S     124          1.120
LGA    A   128_A      A     125          1.082
LGA    I   129_A      Q     126          0.974
LGA    D   130_A      Y     127          0.915
LGA    F   131_A      F     128          1.014
LGA    Y   132_A      Y     129          0.970
LGA    R   133_A      S     130          1.084
LGA    S   134_A      N     131          1.131
LGA    I   135_A      N     132          1.259
LGA    G   136_A      G     133          2.183
LGA    A   137_A      F     134          1.144
LGA    L   138_A      R     135          0.519
LGA    P   139_A      E     136          0.907
LGA    Q   140_A      I     137          1.467
LGA    D   141_A      K     138          2.173
LGA    E   142_A      R     139           #
LGA    W   143_A      G     140          1.919
LGA    V   144_A      D     141          6.416
LGA    -       -      L     142           -
LGA    -       -      P     143           -
LGA    R   145_A      S     144           #
LGA    Y   146_A      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    R   147_A      K     148           #
LGA    L   148_A      L     149           -
LGA    D   149_A      D     150           -
LGA    G   150_A      V     151           -
LGA    E   151_A      D     152           -
LGA    A   152_A      N     153           -
LGA    L   153_A      R     154           -
LGA    R   154_A      F     155           -
LGA    K   155_A      Y     156           -
LGA    M   156_A      Y     157           -
LGA    A   157_A      R     158           -
LGA    E   158_A      N     159           -
LGA    -       -      L     160           -
LGA    -       -      K     161           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  154  160    5.0    124    1.87    14.52     69.952     6.298

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.917817 * X  +  -0.099108 * Y  +  -0.384435 * Z  +  36.262138
  Y_new =  -0.277116 * X  +  -0.533476 * Y  +   0.799131 * Z  +  54.047947
  Z_new =  -0.284287 * X  +   0.839989 * Y  +   0.462169 * Z  +   9.338108 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.067793   -2.073800  [ DEG:    61.1800   -118.8200 ]
  Theta =   0.288262    2.853330  [ DEG:    16.5162    163.4838 ]
  Phi   =  -2.848366    0.293226  [ DEG:  -163.1994     16.8006 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fe7_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fe7_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  154  160   5.0  124   1.87   14.52  69.952
REMARK  ---------------------------------------------------------- 
MOLECULE 2fe7_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   15-DEC-05   2FE7              
TITLE     THE CRYSTAL STRUCTURE OF A PROBABLE N-ACETYLTRANSFERASE               
TITLE    2 FROM PSEUDOMONAS AERUGINOSA                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROBABLE N-ACETYLTRANSFERASE;                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA UCBPP-PA14;              
SOURCE   3 STRAIN: PAO1;                                                        
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    STRUCTURAL GENOMICS, N-ACETYLTRANSFERASE, PSEUDOMONAS                 
KEYWDS   2 AERUGINOSA, PSI, PROTEIN STRUCTURE INITIATIVE, MIDWEST               
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS, MCSG                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK,              
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   24-JAN-06 2FE7    0                                                
JRNL        AUTH   R.ZHANG,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,                  
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   THE CRYSTAL STRUCTURE OF A N-ACETYLTRANSFERASE               
JRNL        TITL 2 FROM PSEUDOMONAS AERUGINOSA                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2FE7 A    1   158  GB     32043669 ZP_00140931      1    158             
DBREF  2FE7 B    1   158  GB     32043669 ZP_00140931      1    158             
SEQRES   1 A  166  GLU ASN LEU TYR PHE GLN GLY HIS MET THR LEU GLU ILE          
SEQRES   2 A  166  ARG PRO ALA VAL PRO ALA ASP ALA GLU GLN ILE LEU ALA          
SEQRES   3 A  166  PHE ILE ILE GLU LEU ALA ASP TYR GLU ARG ALA ARG HIS          
SEQRES   4 A  166  GLU VAL VAL THR ASP VAL GLU GLY ILE ARG ARG SER LEU          
SEQRES   5 A  166  PHE ALA GLU GLY SER PRO THR ARG ALA LEU MET CYS LEU          
SEQRES   6 A  166  SER GLU GLY ARG PRO ILE GLY TYR ALA VAL PHE PHE TYR          
SEQRES   7 A  166  SER TYR SER THR TRP LEU GLY ARG ASN GLY ILE TYR LEU          
SEQRES   8 A  166  GLU ASP LEU TYR VAL THR PRO GLU TYR ARG GLY VAL GLY          
SEQRES   9 A  166  ALA GLY ARG ARG LEU LEU ARG GLU LEU ALA ARG GLU ALA          
SEQRES  10 A  166  VAL ALA ASN ASP CYS GLY ARG LEU GLU TRP SER VAL LEU          
SEQRES  11 A  166  ASP TRP ASN GLN PRO ALA ILE ASP PHE TYR ARG SER ILE          
SEQRES  12 A  166  GLY ALA LEU PRO GLN ASP GLU TRP VAL ARG TYR ARG LEU          
SEQRES  13 A  166  ASP GLY GLU ALA LEU ARG LYS MET ALA GLU                      
SEQRES   1 B  166  GLU ASN LEU TYR PHE GLN GLY HIS MET THR LEU GLU ILE          
SEQRES   2 B  166  ARG PRO ALA VAL PRO ALA ASP ALA GLU GLN ILE LEU ALA          
SEQRES   3 B  166  PHE ILE ILE GLU LEU ALA ASP TYR GLU ARG ALA ARG HIS          
SEQRES   4 B  166  GLU VAL VAL THR ASP VAL GLU GLY ILE ARG ARG SER LEU          
SEQRES   5 B  166  PHE ALA GLU GLY SER PRO THR ARG ALA LEU MET CYS LEU          
SEQRES   6 B  166  SER GLU GLY ARG PRO ILE GLY TYR ALA VAL PHE PHE TYR          
SEQRES   7 B  166  SER TYR SER THR TRP LEU GLY ARG ASN GLY ILE TYR LEU          
SEQRES   8 B  166  GLU ASP LEU TYR VAL THR PRO GLU TYR ARG GLY VAL GLY          
SEQRES   9 B  166  ALA GLY ARG ARG LEU LEU ARG GLU LEU ALA ARG GLU ALA          
SEQRES  10 B  166  VAL ALA ASN ASP CYS GLY ARG LEU GLU TRP SER VAL LEU          
SEQRES  11 B  166  ASP TRP ASN GLN PRO ALA ILE ASP PHE TYR ARG SER ILE          
SEQRES  12 B  166  GLY ALA LEU PRO GLN ASP GLU TRP VAL ARG TYR ARG LEU          
SEQRES  13 B  166  ASP GLY GLU ALA LEU ARG LYS MET ALA GLU                      
FORMUL   3  HOH   *301(H2 O)                                                    
CRYST1  141.375   52.036   58.970  90.00  94.07  90.00 C 1 2 1       8          
ATOM      1  N   LEU A   3     -28.026  42.820  37.206  1.00 33.77           N  
ATOM      2  CA  LEU A   3     -27.278  42.288  38.392  1.00 33.74           C  
ATOM      3  C   LEU A   3     -26.214  43.262  38.893  1.00 33.28           C  
ATOM      4  O   LEU A   3     -25.726  44.097  38.132  1.00 33.63           O  
ATOM      5  CB  LEU A   3     -26.677  40.905  38.107  1.00 33.91           C  
ATOM      6  CG  LEU A   3     -26.087  40.549  36.744  1.00 34.54           C  
ATOM      7  CD1 LEU A   3     -25.044  39.495  36.937  1.00 36.04           C  
ATOM      8  CD2 LEU A   3     -27.163  40.030  35.798  1.00 36.31           C  
ATOM      9  N   GLU A   4     -25.884  43.151  40.182  1.00 32.61           N  
ATOM     10  CA  GLU A   4     -24.955  44.050  40.873  1.00 31.92           C  
ATOM     11  C   GLU A   4     -23.671  43.325  41.299  1.00 30.89           C  
ATOM     12  O   GLU A   4     -23.733  42.246  41.891  1.00 30.53           O  
ATOM     13  CB  GLU A   4     -25.642  44.648  42.115  1.00 31.92           C  
ATOM     14  CG  GLU A   4     -24.695  45.421  43.045  1.00 32.95           C  
ATOM     15  CD  GLU A   4     -25.275  45.722  44.422  1.00 33.28           C  
ATOM     16  OE1 GLU A   4     -24.643  46.515  45.155  1.00 34.89           O  
ATOM     17  OE2 GLU A   4     -26.346  45.179  44.783  1.00 35.97           O  
ATOM     18  N   ILE A   5     -22.521  43.924  40.985  1.00 29.62           N  
ATOM     19  CA  ILE A   5     -21.223  43.469  41.488  1.00 28.45           C  
ATOM     20  C   ILE A   5     -20.711  44.504  42.487  1.00 27.66           C  
ATOM     21  O   ILE A   5     -20.638  45.693  42.170  1.00 27.46           O  
ATOM     22  CB  ILE A   5     -20.162  43.307  40.350  1.00 28.49           C  
ATOM     23  CG1 ILE A   5     -20.708  42.500  39.161  1.00 28.59           C  
ATOM     24  CG2 ILE A   5     -18.840  42.726  40.896  1.00 28.50           C  
ATOM     25  CD1 ILE A   5     -20.964  41.051  39.436  1.00 28.33           C  
ATOM     26  N   ARG A   6     -20.366  44.057  43.693  1.00 26.60           N  
ATOM     27  CA  ARG A   6     -19.789  44.952  44.700  1.00 25.82           C  
ATOM     28  C   ARG A   6     -18.693  44.277  45.517  1.00 25.51           C  
ATOM     29  O   ARG A   6     -18.702  43.049  45.672  1.00 25.09           O  
ATOM     30  CB  ARG A   6     -20.872  45.527  45.628  1.00 25.93           C  
ATOM     31  CG  ARG A   6     -21.625  44.502  46.469  1.00 24.90           C  
ATOM     32  CD  ARG A   6     -22.341  45.171  47.641  1.00 25.11           C  
ATOM     33  NE  ARG A   6     -23.112  44.218  48.442  1.00 23.28           N  
ATOM     34  CZ  ARG A   6     -22.583  43.313  49.269  1.00 22.71           C  
ATOM     35  NH1 ARG A   6     -21.263  43.210  49.415  1.00 20.07           N  
ATOM     36  NH2 ARG A   6     -23.380  42.498  49.950  1.00 21.87           N  
ATOM     37  N   PRO A   7     -17.742  45.077  46.045  1.00 25.27           N  
ATOM     38  CA  PRO A   7     -16.760  44.524  46.987  1.00 24.94           C  
ATOM     39  C   PRO A   7     -17.463  43.912  48.205  1.00 24.75           C  
ATOM     40  O   PRO A   7     -18.446  44.483  48.702  1.00 24.09           O  
ATOM     41  CB  PRO A   7     -15.951  45.751  47.419  1.00 25.23           C  
ATOM     42  CG  PRO A   7     -16.157  46.768  46.342  1.00 25.69           C  
ATOM     43  CD  PRO A   7     -17.531  46.517  45.798  1.00 25.52           C  
ATOM     44  N   ALA A   8     -16.975  42.759  48.663  1.00 23.97           N  
ATOM     45  CA  ALA A   8     -17.517  42.118  49.858  1.00 23.92           C  
ATOM     46  C   ALA A   8     -17.105  42.891  51.108  1.00 23.94           C  
ATOM     47  O   ALA A   8     -16.027  43.486  51.153  1.00 24.12           O  
ATOM     48  CB  ALA A   8     -17.043  40.673  49.960  1.00 23.71           C  
ATOM     49  N   VAL A   9     -17.972  42.868  52.111  1.00 23.77           N  
ATOM     50  CA  VAL A   9     -17.713  43.492  53.404  1.00 23.82           C  
ATOM     51  C   VAL A   9     -17.787  42.403  54.485  1.00 23.71           C  
ATOM     52  O   VAL A   9     -18.300  41.323  54.205  1.00 23.92           O  
ATOM     53  CB  VAL A   9     -18.729  44.623  53.692  1.00 23.64           C  
ATOM     54  CG1 VAL A   9     -18.502  45.790  52.738  1.00 24.10           C  
ATOM     55  CG2 VAL A   9     -20.179  44.114  53.603  1.00 23.53           C  
ATOM     56  N   PRO A  10     -17.263  42.671  55.709  1.00 23.24           N  
ATOM     57  CA  PRO A  10     -17.276  41.660  56.779  1.00 22.63           C  
ATOM     58  C   PRO A  10     -18.646  41.007  57.034  1.00 22.14           C  
ATOM     59  O   PRO A  10     -18.696  39.849  57.429  1.00 21.55           O  
ATOM     60  CB  PRO A  10     -16.801  42.450  58.005  1.00 22.73           C  
ATOM     61  CG  PRO A  10     -15.894  43.486  57.422  1.00 23.51           C  
ATOM     62  CD  PRO A  10     -16.588  43.910  56.150  1.00 23.32           C  
ATOM     63  N   ALA A  11     -19.734  41.747  56.797  1.00 21.69           N  
ATOM     64  CA  ALA A  11     -21.105  41.219  56.919  1.00 21.42           C  
ATOM     65  C   ALA A  11     -21.450  40.104  55.922  1.00 21.23           C  
ATOM     66  O   ALA A  11     -22.390  39.337  56.150  1.00 21.02           O  
ATOM     67  CB  ALA A  11     -22.131  42.359  56.817  1.00 21.45           C  
ATOM     68  N   ASP A  12     -20.691  40.019  54.828  1.00 21.12           N  
ATOM     69  CA  ASP A  12     -20.893  38.980  53.815  1.00 21.34           C  
ATOM     70  C   ASP A  12     -20.305  37.618  54.184  1.00 21.38           C  
ATOM     71  O   ASP A  12     -20.560  36.634  53.484  1.00 21.41           O  
ATOM     72  CB  ASP A  12     -20.305  39.413  52.470  1.00 21.13           C  
ATOM     73  CG  ASP A  12     -20.990  40.628  51.900  1.00 21.98           C  
ATOM     74  OD1 ASP A  12     -22.240  40.672  51.891  1.00 21.49           O  
ATOM     75  OD2 ASP A  12     -20.268  41.533  51.446  1.00 21.98           O  
ATOM     76  N   ALA A  13     -19.525  37.562  55.265  1.00 21.61           N  
ATOM     77  CA  ALA A  13     -18.744  36.359  55.597  1.00 21.93           C  
ATOM     78  C   ALA A  13     -19.562  35.063  55.621  1.00 22.21           C  
ATOM     79  O   ALA A  13     -19.124  34.061  55.070  1.00 22.23           O  
ATOM     80  CB  ALA A  13     -17.976  36.543  56.889  1.00 21.87           C  
ATOM     81  N   GLU A  14     -20.741  35.098  56.247  1.00 22.62           N  
ATOM     82  CA  GLU A  14     -21.652  33.944  56.290  1.00 23.72           C  
ATOM     83  C   GLU A  14     -22.021  33.447  54.893  1.00 22.88           C  
ATOM     84  O   GLU A  14     -21.951  32.249  54.614  1.00 22.26           O  
ATOM     85  CB  GLU A  14     -22.937  34.270  57.074  1.00 23.74           C  
ATOM     86  CG  GLU A  14     -23.053  33.575  58.431  1.00 26.03           C  
ATOM     87  CD  GLU A  14     -24.473  33.592  59.021  1.00 26.56           C  
ATOM     88  OE1 GLU A  14     -25.176  34.623  58.909  1.00 29.52           O  
ATOM     89  OE2 GLU A  14     -24.887  32.564  59.616  1.00 30.84           O  
ATOM     90  N   GLN A  15     -22.442  34.372  54.032  1.00 22.57           N  
ATOM     91  CA  GLN A  15     -22.860  34.025  52.674  1.00 22.44           C  
ATOM     92  C   GLN A  15     -21.671  33.537  51.845  1.00 21.79           C  
ATOM     93  O   GLN A  15     -21.791  32.569  51.092  1.00 21.58           O  
ATOM     94  CB  GLN A  15     -23.549  35.214  51.999  1.00 22.85           C  
ATOM     95  CG  GLN A  15     -24.033  34.940  50.577  1.00 24.17           C  
ATOM     96  CD  GLN A  15     -25.015  33.781  50.507  1.00 25.82           C  
ATOM     97  OE1 GLN A  15     -24.651  32.660  50.133  1.00 25.81           O  
ATOM     98  NE2 GLN A  15     -26.257  34.038  50.888  1.00 25.46           N  
ATOM     99  N   ILE A  16     -20.526  34.196  52.008  1.00 21.10           N  
ATOM    100  CA  ILE A  16     -19.282  33.769  51.352  1.00 20.96           C  
ATOM    101  C   ILE A  16     -18.903  32.321  51.696  1.00 20.55           C  
ATOM    102  O   ILE A  16     -18.616  31.529  50.787  1.00 20.17           O  
ATOM    103  CB  ILE A  16     -18.104  34.758  51.611  1.00 20.85           C  
ATOM    104  CG1 ILE A  16     -18.383  36.092  50.900  1.00 21.79           C  
ATOM    105  CG2 ILE A  16     -16.764  34.177  51.115  1.00 20.87           C  
ATOM    106  CD1 ILE A  16     -17.405  37.225  51.243  1.00 21.55           C  
ATOM    107  N   LEU A  17     -18.931  31.977  52.985  1.00 19.98           N  
ATOM    108  CA  LEU A  17     -18.617  30.604  53.418  1.00 19.93           C  
ATOM    109  C   LEU A  17     -19.587  29.573  52.845  1.00 19.42           C  
ATOM    110  O   LEU A  17     -19.154  28.516  52.414  1.00 19.81           O  
ATOM    111  CB  LEU A  17     -18.535  30.470  54.948  1.00 19.60           C  
ATOM    112  CG  LEU A  17     -18.178  29.045  55.441  1.00 19.79           C  
ATOM    113  CD1 LEU A  17     -16.783  28.590  54.964  1.00 20.25           C  
ATOM    114  CD2 LEU A  17     -18.290  28.899  56.940  1.00 20.28           C  
ATOM    115  N   ALA A  18     -20.886  29.887  52.842  1.00 19.88           N  
ATOM    116  CA  ALA A  18     -21.903  29.011  52.249  1.00 19.36           C  
ATOM    117  C   ALA A  18     -21.580  28.734  50.785  1.00 19.43           C  
ATOM    118  O   ALA A  18     -21.647  27.590  50.334  1.00 19.31           O  
ATOM    119  CB  ALA A  18     -23.301  29.621  52.391  1.00 19.47           C  
ATOM    120  N   PHE A  19     -21.201  29.785  50.060  1.00 19.38           N  
ATOM    121  CA  PHE A  19     -20.804  29.671  48.661  1.00 19.31           C  
ATOM    122  C   PHE A  19     -19.478  28.897  48.491  1.00 19.19           C  
ATOM    123  O   PHE A  19     -19.354  28.059  47.588  1.00 18.29           O  
ATOM    124  CB  PHE A  19     -20.665  31.062  48.042  1.00 19.51           C  
ATOM    125  CG  PHE A  19     -21.969  31.713  47.641  1.00 20.39           C  
ATOM    126  CD1 PHE A  19     -23.121  30.968  47.426  1.00 20.67           C  
ATOM    127  CD2 PHE A  19     -22.015  33.095  47.423  1.00 21.23           C  
ATOM    128  CE1 PHE A  19     -24.310  31.593  47.030  1.00 22.42           C  
ATOM    129  CE2 PHE A  19     -23.187  33.729  47.035  1.00 21.60           C  
ATOM    130  CZ  PHE A  19     -24.343  32.978  46.840  1.00 21.82           C  
ATOM    131  N   ILE A  20     -18.497  29.191  49.353  1.00 18.55           N  
ATOM    132  CA  ILE A  20     -17.211  28.468  49.360  1.00 18.47           C  
ATOM    133  C   ILE A  20     -17.447  26.959  49.456  1.00 18.84           C  
ATOM    134  O   ILE A  20     -16.846  26.177  48.710  1.00 18.76           O  
ATOM    135  CB  ILE A  20     -16.295  28.924  50.517  1.00 18.46           C  
ATOM    136  CG1 ILE A  20     -15.717  30.322  50.242  1.00 17.75           C  
ATOM    137  CG2 ILE A  20     -15.172  27.878  50.788  1.00 18.63           C  
ATOM    138  CD1 ILE A  20     -15.093  30.976  51.497  1.00 18.03           C  
ATOM    139  N   ILE A  21     -18.344  26.565  50.361  1.00 19.15           N  
ATOM    140  CA  ILE A  21     -18.700  25.158  50.547  1.00 19.60           C  
ATOM    141  C   ILE A  21     -19.391  24.592  49.309  1.00 20.31           C  
ATOM    142  O   ILE A  21     -19.086  23.474  48.891  1.00 20.22           O  
ATOM    143  CB  ILE A  21     -19.565  24.958  51.829  1.00 19.52           C  
ATOM    144  CG1 ILE A  21     -18.704  25.165  53.077  1.00 19.01           C  
ATOM    145  CG2 ILE A  21     -20.213  23.567  51.871  1.00 19.21           C  
ATOM    146  CD1 ILE A  21     -19.504  25.404  54.361  1.00 19.73           C  
ATOM    147  N   GLU A  22     -20.314  25.362  48.729  1.00 21.05           N  
ATOM    148  CA  GLU A  22     -20.996  24.958  47.496  1.00 22.01           C  
ATOM    149  C   GLU A  22     -19.981  24.717  46.381  1.00 21.28           C  
ATOM    150  O   GLU A  22     -20.014  23.686  45.697  1.00 21.07           O  
ATOM    151  CB  GLU A  22     -22.028  26.008  47.072  1.00 22.02           C  
ATOM    152  CG  GLU A  22     -23.302  26.014  47.915  1.00 24.02           C  
ATOM    153  CD  GLU A  22     -24.283  27.127  47.516  1.00 25.17           C  
ATOM    154  OE1 GLU A  22     -24.907  27.735  48.418  1.00 29.49           O  
ATOM    155  OE2 GLU A  22     -24.438  27.393  46.301  1.00 30.03           O  
ATOM    156  N   LEU A  23     -19.058  25.654  46.213  1.00 20.75           N  
ATOM    157  CA  LEU A  23     -18.011  25.489  45.205  1.00 20.44           C  
ATOM    158  C   LEU A  23     -17.098  24.275  45.481  1.00 20.45           C  
ATOM    159  O   LEU A  23     -16.843  23.468  44.573  1.00 20.45           O  
ATOM    160  CB  LEU A  23     -17.203  26.783  45.031  1.00 20.03           C  
ATOM    161  CG  LEU A  23     -16.015  26.741  44.064  1.00 20.23           C  
ATOM    162  CD1 LEU A  23     -16.424  26.416  42.616  1.00 21.41           C  
ATOM    163  CD2 LEU A  23     -15.249  28.056  44.125  1.00 20.37           C  
ATOM    164  N   ALA A  24     -16.613  24.151  46.720  1.00 20.31           N  
ATOM    165  CA  ALA A  24     -15.781  23.015  47.125  1.00 20.76           C  
ATOM    166  C   ALA A  24     -16.493  21.693  46.875  1.00 21.37           C  
ATOM    167  O   ALA A  24     -15.872  20.720  46.426  1.00 21.05           O  
ATOM    168  CB  ALA A  24     -15.391  23.129  48.589  1.00 20.80           C  
ATOM    169  N   ASP A  25     -17.792  21.657  47.169  1.00 22.10           N  
ATOM    170  CA  ASP A  25     -18.586  20.459  46.960  1.00 23.25           C  
ATOM    171  C   ASP A  25     -18.596  20.089  45.483  1.00 23.67           C  
ATOM    172  O   ASP A  25     -18.351  18.936  45.136  1.00 23.48           O  
ATOM    173  CB  ASP A  25     -20.010  20.626  47.488  1.00 23.52           C  
ATOM    174  CG  ASP A  25     -20.797  19.309  47.483  1.00 26.98           C  
ATOM    175  OD1 ASP A  25     -21.143  18.819  46.391  1.00 30.28           O  
ATOM    176  OD2 ASP A  25     -21.079  18.766  48.572  1.00 30.42           O  
ATOM    177  N   TYR A  26     -18.854  21.065  44.615  1.00 24.04           N  
ATOM    178  CA  TYR A  26     -18.788  20.813  43.173  1.00 25.02           C  
ATOM    179  C   TYR A  26     -17.402  20.283  42.748  1.00 24.46           C  
ATOM    180  O   TYR A  26     -17.301  19.331  41.960  1.00 24.22           O  
ATOM    181  CB  TYR A  26     -19.153  22.053  42.338  1.00 26.22           C  
ATOM    182  CG  TYR A  26     -18.979  21.742  40.863  1.00 28.55           C  
ATOM    183  CD1 TYR A  26     -19.922  20.961  40.181  1.00 30.33           C  
ATOM    184  CD2 TYR A  26     -17.834  22.149  40.175  1.00 28.90           C  
ATOM    185  CE1 TYR A  26     -19.744  20.627  38.835  1.00 30.63           C  
ATOM    186  CE2 TYR A  26     -17.647  21.821  38.838  1.00 30.04           C  
ATOM    187  CZ  TYR A  26     -18.606  21.060  38.173  1.00 29.75           C  
ATOM    188  OH  TYR A  26     -18.422  20.734  36.842  1.00 29.99           O  
ATOM    189  N   GLU A  27     -16.353  20.894  43.292  1.00 23.06           N  
ATOM    190  CA  GLU A  27     -14.975  20.525  42.981  1.00 22.80           C  
ATOM    191  C   GLU A  27     -14.512  19.234  43.664  1.00 22.26           C  
ATOM    192  O   GLU A  27     -13.305  18.920  43.685  1.00 22.07           O  
ATOM    193  CB  GLU A  27     -14.043  21.687  43.317  1.00 22.49           C  
ATOM    194  CG  GLU A  27     -14.267  22.904  42.414  1.00 22.93           C  
ATOM    195  CD  GLU A  27     -13.362  24.072  42.753  1.00 23.82           C  
ATOM    196  OE1 GLU A  27     -12.946  24.180  43.922  1.00 25.77           O  
ATOM    197  OE2 GLU A  27     -13.061  24.888  41.849  1.00 27.77           O  
ATOM    198  N   ARG A  28     -15.470  18.504  44.227  1.00 21.92           N  
ATOM    199  CA  ARG A  28     -15.234  17.186  44.844  1.00 21.93           C  
ATOM    200  C   ARG A  28     -14.282  17.268  46.032  1.00 21.94           C  
ATOM    201  O   ARG A  28     -13.434  16.403  46.233  1.00 22.03           O  
ATOM    202  CB  ARG A  28     -14.749  16.179  43.785  1.00 22.16           C  
ATOM    203  CG  ARG A  28     -15.821  15.873  42.761  1.00 22.35           C  
ATOM    204  CD  ARG A  28     -15.286  15.132  41.544  1.00 22.35           C  
ATOM    205  NE  ARG A  28     -16.302  15.142  40.495  1.00 21.98           N  
ATOM    206  CZ  ARG A  28     -16.165  14.597  39.291  1.00 22.37           C  
ATOM    207  NH1 ARG A  28     -15.037  13.975  38.954  1.00 20.77           N  
ATOM    208  NH2 ARG A  28     -17.170  14.669  38.425  1.00 21.89           N  
ATOM    209  N   ALA A  29     -14.463  18.314  46.834  1.00 21.71           N  
ATOM    210  CA  ALA A  29     -13.518  18.664  47.867  1.00 21.54           C  
ATOM    211  C   ALA A  29     -14.217  19.289  49.072  1.00 21.45           C  
ATOM    212  O   ALA A  29     -13.596  20.024  49.822  1.00 21.58           O  
ATOM    213  CB  ALA A  29     -12.460  19.622  47.301  1.00 21.39           C  
ATOM    214  N   ARG A  30     -15.498  18.970  49.264  1.00 21.42           N  
ATOM    215  CA  ARG A  30     -16.273  19.483  50.403  1.00 21.78           C  
ATOM    216  C   ARG A  30     -15.550  19.304  51.743  1.00 21.77           C  
ATOM    217  O   ARG A  30     -15.584  20.192  52.602  1.00 21.33           O  
ATOM    218  CB  ARG A  30     -17.658  18.822  50.471  1.00 21.81           C  
ATOM    219  CG  ARG A  30     -18.527  19.372  51.578  1.00 23.74           C  
ATOM    220  CD  ARG A  30     -19.873  18.690  51.663  1.00 28.21           C  
ATOM    221  NE  ARG A  30     -20.759  19.440  52.550  1.00 31.00           N  
ATOM    222  CZ  ARG A  30     -21.675  20.315  52.143  1.00 32.15           C  
ATOM    223  NH1 ARG A  30     -21.858  20.554  50.846  1.00 32.21           N  
ATOM    224  NH2 ARG A  30     -22.420  20.949  53.040  1.00 33.93           N  
ATOM    225  N   HIS A  31     -14.922  18.144  51.919  1.00 21.56           N  
ATOM    226  CA  HIS A  31     -14.189  17.806  53.144  1.00 21.97           C  
ATOM    227  C   HIS A  31     -12.939  18.666  53.377  1.00 21.77           C  
ATOM    228  O   HIS A  31     -12.404  18.704  54.489  1.00 21.00           O  
ATOM    229  CB  HIS A  31     -13.777  16.333  53.095  1.00 21.89           C  
ATOM    230  CG  HIS A  31     -12.993  15.983  51.874  1.00 22.26           C  
ATOM    231  ND1 HIS A  31     -13.590  15.705  50.663  1.00 22.76           N  
ATOM    232  CD2 HIS A  31     -11.657  15.896  51.666  1.00 22.32           C  
ATOM    233  CE1 HIS A  31     -12.655  15.454  49.763  1.00 24.21           C  
ATOM    234  NE2 HIS A  31     -11.475  15.558  50.349  1.00 24.36           N  
ATOM    235  N   GLU A  32     -12.461  19.346  52.334  1.00 21.93           N  
ATOM    236  CA  GLU A  32     -11.292  20.213  52.473  1.00 21.84           C  
ATOM    237  C   GLU A  32     -11.618  21.566  53.130  1.00 22.26           C  
ATOM    238  O   GLU A  32     -10.708  22.282  53.560  1.00 22.52           O  
ATOM    239  CB  GLU A  32     -10.600  20.432  51.120  1.00 22.38           C  
ATOM    240  CG  GLU A  32     -10.108  19.146  50.440  1.00 23.42           C  
ATOM    241  CD  GLU A  32      -8.877  18.507  51.112  1.00 26.54           C  
ATOM    242  OE1 GLU A  32      -8.406  18.990  52.176  1.00 27.39           O  
ATOM    243  OE2 GLU A  32      -8.387  17.497  50.567  1.00 28.18           O  
ATOM    244  N   VAL A  33     -12.901  21.930  53.198  1.00 22.20           N  
ATOM    245  CA  VAL A  33     -13.278  23.184  53.861  1.00 22.49           C  
ATOM    246  C   VAL A  33     -13.284  22.953  55.366  1.00 23.00           C  
ATOM    247  O   VAL A  33     -14.232  22.394  55.915  1.00 22.32           O  
ATOM    248  CB  VAL A  33     -14.648  23.760  53.400  1.00 22.61           C  
ATOM    249  CG1 VAL A  33     -14.797  25.203  53.883  1.00 21.79           C  
ATOM    250  CG2 VAL A  33     -14.771  23.730  51.879  1.00 22.04           C  
ATOM    251  N   VAL A  34     -12.212  23.383  56.022  1.00 23.71           N  
ATOM    252  CA  VAL A  34     -12.044  23.135  57.450  1.00 24.79           C  
ATOM    253  C   VAL A  34     -12.225  24.407  58.276  1.00 25.32           C  
ATOM    254  O   VAL A  34     -12.154  24.369  59.507  1.00 25.52           O  
ATOM    255  CB  VAL A  34     -10.685  22.435  57.768  1.00 24.59           C  
ATOM    256  CG1 VAL A  34     -10.668  20.997  57.213  1.00 25.65           C  
ATOM    257  CG2 VAL A  34      -9.510  23.228  57.235  1.00 23.72           C  
ATOM    258  N   THR A  35     -12.469  25.525  57.592  1.00 25.47           N  
ATOM    259  CA  THR A  35     -12.685  26.806  58.252  1.00 25.94           C  
ATOM    260  C   THR A  35     -14.164  27.032  58.628  1.00 26.42           C  
ATOM    261  O   THR A  35     -15.064  26.372  58.092  1.00 25.77           O  
ATOM    262  CB  THR A  35     -12.156  27.992  57.384  1.00 25.84           C  
ATOM    263  OG1 THR A  35     -12.128  29.188  58.167  1.00 25.73           O  
ATOM    264  CG2 THR A  35     -13.031  28.216  56.137  1.00 25.99           C  
ATOM    265  N   ASP A  36     -14.392  27.956  59.563  1.00 27.12           N  
ATOM    266  CA  ASP A  36     -15.739  28.429  59.901  1.00 27.94           C  
ATOM    267  C   ASP A  36     -15.874  29.907  59.531  1.00 28.00           C  
ATOM    268  O   ASP A  36     -14.932  30.490  58.991  1.00 27.64           O  
ATOM    269  CB  ASP A  36     -16.055  28.190  61.385  1.00 28.62           C  
ATOM    270  CG  ASP A  36     -14.948  28.672  62.322  1.00 30.43           C  
ATOM    271  OD1 ASP A  36     -14.309  29.718  62.056  1.00 31.04           O  
ATOM    272  OD2 ASP A  36     -14.739  27.998  63.357  1.00 33.74           O  
ATOM    273  N   VAL A  37     -17.037  30.504  59.794  1.00 28.09           N  
ATOM    274  CA  VAL A  37     -17.277  31.914  59.451  1.00 28.64           C  
ATOM    275  C   VAL A  37     -16.284  32.817  60.184  1.00 28.72           C  
ATOM    276  O   VAL A  37     -15.745  33.755  59.600  1.00 28.45           O  
ATOM    277  CB  VAL A  37     -18.726  32.374  59.762  1.00 28.69           C  
ATOM    278  CG1 VAL A  37     -18.980  33.760  59.191  1.00 29.24           C  
ATOM    279  CG2 VAL A  37     -19.739  31.407  59.184  1.00 29.54           C  
ATOM    280  N   GLU A  38     -16.049  32.517  61.462  1.00 29.08           N  
ATOM    281  CA  GLU A  38     -15.041  33.208  62.267  1.00 29.52           C  
ATOM    282  C   GLU A  38     -13.690  33.231  61.545  1.00 28.76           C  
ATOM    283  O   GLU A  38     -13.121  34.297  61.317  1.00 28.79           O  
ATOM    284  CB  GLU A  38     -14.895  32.545  63.643  1.00 29.74           C  
ATOM    285  CG  GLU A  38     -16.040  32.818  64.611  1.00 32.74           C  
ATOM    286  CD  GLU A  38     -17.173  31.793  64.529  1.00 35.63           C  
ATOM    287  OE1 GLU A  38     -17.172  30.937  63.605  1.00 35.66           O  
ATOM    288  OE2 GLU A  38     -18.071  31.853  65.402  1.00 36.55           O  
ATOM    289  N   GLY A  39     -13.209  32.052  61.151  1.00 28.19           N  
ATOM    290  CA  GLY A  39     -11.934  31.923  60.440  1.00 27.08           C  
ATOM    291  C   GLY A  39     -11.850  32.725  59.151  1.00 26.38           C  
ATOM    292  O   GLY A  39     -10.800  33.282  58.832  1.00 26.30           O  
ATOM    293  N   ILE A  40     -12.954  32.769  58.409  1.00 26.08           N  
ATOM    294  CA  ILE A  40     -13.069  33.590  57.195  1.00 25.78           C  
ATOM    295  C   ILE A  40     -12.982  35.081  57.553  1.00 26.26           C  
ATOM    296  O   ILE A  40     -12.201  35.822  56.954  1.00 25.79           O  
ATOM    297  CB  ILE A  40     -14.389  33.268  56.405  1.00 25.60           C  
ATOM    298  CG1 ILE A  40     -14.307  31.890  55.729  1.00 24.40           C  
ATOM    299  CG2 ILE A  40     -14.746  34.369  55.389  1.00 24.72           C  
ATOM    300  CD1 ILE A  40     -13.275  31.780  54.589  1.00 23.57           C  
ATOM    301  N   ARG A  41     -13.778  35.505  58.538  1.00 26.90           N  
ATOM    302  CA  ARG A  41     -13.735  36.885  59.061  1.00 27.54           C  
ATOM    303  C   ARG A  41     -12.321  37.322  59.452  1.00 27.75           C  
ATOM    304  O   ARG A  41     -11.860  38.374  59.034  1.00 28.09           O  
ATOM    305  CB  ARG A  41     -14.650  37.047  60.287  1.00 27.27           C  
ATOM    306  CG  ARG A  41     -16.152  36.883  60.060  1.00 27.84           C  
ATOM    307  CD  ARG A  41     -16.927  37.324  61.315  1.00 27.75           C  
ATOM    308  NE  ARG A  41     -18.206  36.637  61.513  1.00 28.24           N  
ATOM    309  CZ  ARG A  41     -19.350  36.975  60.924  1.00 28.76           C  
ATOM    310  NH1 ARG A  41     -19.403  38.005  60.074  1.00 28.80           N  
ATOM    311  NH2 ARG A  41     -20.451  36.273  61.184  1.00 29.62           N  
ATOM    312  N   ARG A  42     -11.644  36.506  60.258  1.00 28.68           N  
ATOM    313  CA  ARG A  42     -10.328  36.856  60.822  1.00 29.20           C  
ATOM    314  C   ARG A  42      -9.209  36.968  59.796  1.00 29.02           C  
ATOM    315  O   ARG A  42      -8.207  37.648  60.031  1.00 29.15           O  
ATOM    316  CB  ARG A  42      -9.917  35.846  61.902  1.00 29.51           C  
ATOM    317  CG  ARG A  42     -10.923  35.715  63.031  1.00 31.99           C  
ATOM    318  CD  ARG A  42     -11.229  37.053  63.699  1.00 33.59           C  
ATOM    319  NE  ARG A  42     -10.173  37.433  64.628  1.00 36.06           N  
ATOM    320  CZ  ARG A  42      -9.994  36.881  65.826  1.00 37.44           C  
ATOM    321  NH1 ARG A  42     -10.804  35.913  66.255  1.00 37.18           N  
ATOM    322  NH2 ARG A  42      -8.998  37.298  66.594  1.00 37.90           N  
ATOM    323  N   SER A  43      -9.382  36.291  58.664  1.00 28.63           N  
ATOM    324  CA  SER A  43      -8.356  36.221  57.638  1.00 28.23           C  
ATOM    325  C   SER A  43      -8.719  37.067  56.424  1.00 28.32           C  
ATOM    326  O   SER A  43      -7.997  37.996  56.076  1.00 28.28           O  
ATOM    327  CB  SER A  43      -8.133  34.764  57.228  1.00 28.17           C  
ATOM    328  OG  SER A  43      -9.354  34.185  56.810  1.00 27.32           O  
ATOM    329  N   LEU A  44      -9.838  36.734  55.787  1.00 28.56           N  
ATOM    330  CA  LEU A  44     -10.314  37.455  54.605  1.00 28.95           C  
ATOM    331  C   LEU A  44     -10.586  38.925  54.906  1.00 28.76           C  
ATOM    332  O   LEU A  44     -10.282  39.793  54.094  1.00 28.52           O  
ATOM    333  CB  LEU A  44     -11.566  36.780  54.018  1.00 29.01           C  
ATOM    334  CG  LEU A  44     -12.181  37.324  52.724  1.00 28.89           C  
ATOM    335  CD1 LEU A  44     -11.151  37.338  51.625  1.00 28.92           C  
ATOM    336  CD2 LEU A  44     -13.381  36.486  52.295  1.00 29.17           C  
ATOM    337  N   PHE A  45     -11.136  39.204  56.084  1.00 29.26           N  
ATOM    338  CA  PHE A  45     -11.499  40.574  56.434  1.00 29.49           C  
ATOM    339  C   PHE A  45     -10.640  41.157  57.550  1.00 29.95           C  
ATOM    340  O   PHE A  45     -11.066  42.069  58.256  1.00 30.01           O  
ATOM    341  CB  PHE A  45     -13.000  40.670  56.768  1.00 29.59           C  
ATOM    342  CG  PHE A  45     -13.901  40.260  55.630  1.00 29.72           C  
ATOM    343  CD1 PHE A  45     -14.140  41.128  54.564  1.00 29.48           C  
ATOM    344  CD2 PHE A  45     -14.499  39.001  55.618  1.00 29.18           C  
ATOM    345  CE1 PHE A  45     -14.959  40.745  53.508  1.00 29.33           C  
ATOM    346  CE2 PHE A  45     -15.330  38.612  54.569  1.00 28.91           C  
ATOM    347  CZ  PHE A  45     -15.553  39.485  53.509  1.00 29.50           C  
ATOM    348  N   ALA A  46      -9.428  40.628  57.707  1.00 30.66           N  
ATOM    349  CA  ALA A  46      -8.463  41.180  58.662  1.00 31.05           C  
ATOM    350  C   ALA A  46      -8.066  42.581  58.228  1.00 31.63           C  
ATOM    351  O   ALA A  46      -7.974  42.865  57.030  1.00 31.67           O  
ATOM    352  CB  ALA A  46      -7.222  40.291  58.763  1.00 30.94           C  
ATOM    353  N   GLU A  47      -7.855  43.464  59.201  1.00 32.14           N  
ATOM    354  CA  GLU A  47      -7.232  44.753  58.920  1.00 33.03           C  
ATOM    355  C   GLU A  47      -5.906  44.472  58.200  1.00 32.48           C  
ATOM    356  O   GLU A  47      -5.112  43.647  58.665  1.00 32.90           O  
ATOM    357  CB  GLU A  47      -7.032  45.541  60.225  1.00 33.24           C  
ATOM    358  CG  GLU A  47      -6.249  46.854  60.090  1.00 36.17           C  
ATOM    359  CD  GLU A  47      -4.737  46.656  60.208  1.00 40.24           C  
ATOM    360  OE1 GLU A  47      -4.309  45.701  60.913  1.00 41.39           O  
ATOM    361  OE2 GLU A  47      -3.981  47.457  59.602  1.00 40.86           O  
ATOM    362  N   GLY A  48      -5.698  45.113  57.049  1.00 32.00           N  
ATOM    363  CA  GLY A  48      -4.482  44.904  56.243  1.00 31.04           C  
ATOM    364  C   GLY A  48      -4.459  43.637  55.379  1.00 30.83           C  
ATOM    365  O   GLY A  48      -3.395  43.227  54.882  1.00 30.55           O  
ATOM    366  N   SER A  49      -5.626  43.020  55.189  1.00 30.07           N  
ATOM    367  CA  SER A  49      -5.727  41.785  54.394  1.00 29.51           C  
ATOM    368  C   SER A  49      -5.297  41.974  52.932  1.00 29.15           C  
ATOM    369  O   SER A  49      -5.715  42.931  52.283  1.00 28.83           O  
ATOM    370  CB  SER A  49      -7.151  41.238  54.421  1.00 29.33           C  
ATOM    371  OG  SER A  49      -7.225  40.060  53.642  1.00 28.95           O  
ATOM    372  N   PRO A  50      -4.459  41.056  52.413  1.00 28.95           N  
ATOM    373  CA  PRO A  50      -4.088  41.092  50.994  1.00 28.65           C  
ATOM    374  C   PRO A  50      -5.150  40.485  50.069  1.00 28.16           C  
ATOM    375  O   PRO A  50      -5.018  40.557  48.846  1.00 28.15           O  
ATOM    376  CB  PRO A  50      -2.809  40.249  50.946  1.00 28.96           C  
ATOM    377  CG  PRO A  50      -2.971  39.269  52.054  1.00 29.74           C  
ATOM    378  CD  PRO A  50      -3.792  39.956  53.134  1.00 28.77           C  
ATOM    379  N   THR A  51      -6.189  39.894  50.648  1.00 27.70           N  
ATOM    380  CA  THR A  51      -7.209  39.207  49.865  1.00 27.20           C  
ATOM    381  C   THR A  51      -8.471  40.034  49.757  1.00 27.05           C  
ATOM    382  O   THR A  51      -8.885  40.701  50.709  1.00 26.51           O  
ATOM    383  CB  THR A  51      -7.561  37.824  50.455  1.00 27.64           C  
ATOM    384  OG1 THR A  51      -6.358  37.161  50.856  1.00 27.46           O  
ATOM    385  CG2 THR A  51      -8.271  36.967  49.415  1.00 25.94           C  
ATOM    386  N   ARG A  52      -9.067  39.989  48.574  1.00 26.72           N  
ATOM    387  CA  ARG A  52     -10.315  40.669  48.310  1.00 26.46           C  
ATOM    388  C   ARG A  52     -11.393  39.694  47.869  1.00 25.33           C  
ATOM    389  O   ARG A  52     -11.112  38.585  47.415  1.00 24.82           O  
ATOM    390  CB  ARG A  52     -10.114  41.733  47.235  1.00 27.06           C  
ATOM    391  CG  ARG A  52      -9.313  42.910  47.692  1.00 30.18           C  
ATOM    392  CD  ARG A  52      -8.810  43.690  46.507  1.00 35.57           C  
ATOM    393  NE  ARG A  52      -7.833  44.695  46.906  1.00 38.82           N  
ATOM    394  CZ  ARG A  52      -7.563  45.789  46.200  1.00 40.10           C  
ATOM    395  NH1 ARG A  52      -8.204  46.016  45.057  1.00 39.73           N  
ATOM    396  NH2 ARG A  52      -6.656  46.653  46.643  1.00 40.41           N  
ATOM    397  N   ALA A  53     -12.638  40.133  47.994  1.00 24.31           N  
ATOM    398  CA  ALA A  53     -13.761  39.359  47.525  1.00 23.40           C  
ATOM    399  C   ALA A  53     -14.778  40.269  46.857  1.00 23.57           C  
ATOM    400  O   ALA A  53     -14.921  41.455  47.214  1.00 22.71           O  
ATOM    401  CB  ALA A  53     -14.388  38.575  48.674  1.00 23.12           C  
ATOM    402  N   LEU A  54     -15.462  39.705  45.867  1.00 23.59           N  
ATOM    403  CA  LEU A  54     -16.537  40.378  45.162  1.00 23.67           C  
ATOM    404  C   LEU A  54     -17.802  39.587  45.390  1.00 23.93           C  
ATOM    405  O   LEU A  54     -17.771  38.349  45.390  1.00 24.06           O  
ATOM    406  CB  LEU A  54     -16.250  40.433  43.660  1.00 23.59           C  
ATOM    407  CG  LEU A  54     -15.096  41.283  43.108  1.00 23.73           C  
ATOM    408  CD1 LEU A  54     -15.076  41.183  41.579  1.00 22.18           C  
ATOM    409  CD2 LEU A  54     -15.206  42.756  43.537  1.00 22.44           C  
ATOM    410  N   MET A  55     -18.904  40.300  45.599  1.00 24.05           N  
ATOM    411  CA  MET A  55     -20.230  39.697  45.630  1.00 24.66           C  
ATOM    412  C   MET A  55     -20.969  40.015  44.337  1.00 25.58           C  
ATOM    413  O   MET A  55     -20.922  41.150  43.839  1.00 25.73           O  
ATOM    414  CB  MET A  55     -21.055  40.225  46.813  1.00 24.47           C  
ATOM    415  CG  MET A  55     -20.450  39.973  48.181  1.00 23.95           C  
ATOM    416  SD  MET A  55     -20.099  38.232  48.497  1.00 20.95           S  
ATOM    417  CE  MET A  55     -21.759  37.526  48.330  1.00 19.62           C  
ATOM    418  N   CYS A  56     -21.651  39.011  43.799  1.00 26.63           N  
ATOM    419  CA  CYS A  56     -22.587  39.215  42.700  1.00 27.12           C  
ATOM    420  C   CYS A  56     -23.996  39.043  43.234  1.00 27.57           C  
ATOM    421  O   CYS A  56     -24.306  38.040  43.886  1.00 27.13           O  
ATOM    422  CB  CYS A  56     -22.339  38.229  41.558  1.00 27.11           C  
ATOM    423  SG  CYS A  56     -23.469  38.478  40.164  1.00 28.61           S  
ATOM    424  N   LEU A  57     -24.848  40.030  42.969  1.00 28.36           N  
ATOM    425  CA  LEU A  57     -26.220  39.991  43.449  1.00 29.26           C  
ATOM    426  C   LEU A  57     -27.210  40.204  42.320  1.00 30.15           C  
ATOM    427  O   LEU A  57     -26.943  40.951  41.381  1.00 30.04           O  
ATOM    428  CB  LEU A  57     -26.454  41.039  44.547  1.00 29.28           C  
ATOM    429  CG  LEU A  57     -25.641  40.916  45.844  1.00 28.95           C  
ATOM    430  CD1 LEU A  57     -24.356  41.719  45.758  1.00 29.22           C  
ATOM    431  CD2 LEU A  57     -26.459  41.368  47.033  1.00 28.53           C  
ATOM    432  N   SER A  58     -28.353  39.533  42.418  1.00 31.06           N  
ATOM    433  CA  SER A  58     -29.476  39.789  41.527  1.00 31.90           C  
ATOM    434  C   SER A  58     -30.665  40.235  42.373  1.00 32.34           C  
ATOM    435  O   SER A  58     -31.182  39.464  43.184  1.00 32.58           O  
ATOM    436  CB  SER A  58     -29.814  38.544  40.707  1.00 31.98           C  
ATOM    437  OG  SER A  58     -30.892  38.794  39.829  1.00 32.45           O  
ATOM    438  N   GLU A  59     -31.060  41.495  42.199  1.00 32.75           N  
ATOM    439  CA  GLU A  59     -32.177  42.106  42.937  1.00 33.26           C  
ATOM    440  C   GLU A  59     -32.025  42.026  44.463  1.00 32.92           C  
ATOM    441  O   GLU A  59     -32.991  41.750  45.186  1.00 32.96           O  
ATOM    442  CB  GLU A  59     -33.526  41.529  42.472  1.00 33.50           C  
ATOM    443  CG  GLU A  59     -33.774  41.628  40.960  1.00 35.51           C  
ATOM    444  CD  GLU A  59     -33.861  43.066  40.460  1.00 38.38           C  
ATOM    445  OE1 GLU A  59     -34.806  43.787  40.858  1.00 39.09           O  
ATOM    446  OE2 GLU A  59     -32.987  43.468  39.656  1.00 39.83           O  
ATOM    447  N   GLY A  60     -30.807  42.276  44.943  1.00 32.59           N  
ATOM    448  CA  GLY A  60     -30.510  42.260  46.379  1.00 31.99           C  
ATOM    449  C   GLY A  60     -30.184  40.879  46.926  1.00 31.51           C  
ATOM    450  O   GLY A  60     -29.725  40.752  48.060  1.00 31.66           O  
ATOM    451  N   ARG A  61     -30.433  39.846  46.122  1.00 30.83           N  
ATOM    452  CA  ARG A  61     -30.146  38.462  46.489  1.00 30.45           C  
ATOM    453  C   ARG A  61     -28.722  38.097  46.039  1.00 29.42           C  
ATOM    454  O   ARG A  61     -28.399  38.229  44.856  1.00 29.19           O  
ATOM    455  CB  ARG A  61     -31.168  37.533  45.820  1.00 30.86           C  
ATOM    456  CG  ARG A  61     -30.904  36.030  45.950  1.00 33.09           C  
ATOM    457  CD  ARG A  61     -31.724  35.373  47.068  1.00 38.54           C  
ATOM    458  NE  ARG A  61     -31.029  35.374  48.358  1.00 41.88           N  
ATOM    459  CZ  ARG A  61     -31.213  36.277  49.324  1.00 43.29           C  
ATOM    460  NH1 ARG A  61     -32.073  37.278  49.164  1.00 43.02           N  
ATOM    461  NH2 ARG A  61     -30.520  36.180  50.457  1.00 44.21           N  
ATOM    462  N   PRO A  62     -27.865  37.641  46.979  1.00 28.66           N  
ATOM    463  CA  PRO A  62     -26.529  37.145  46.596  1.00 27.89           C  
ATOM    464  C   PRO A  62     -26.611  35.891  45.727  1.00 27.14           C  
ATOM    465  O   PRO A  62     -27.228  34.902  46.129  1.00 27.37           O  
ATOM    466  CB  PRO A  62     -25.872  36.817  47.942  1.00 28.00           C  
ATOM    467  CG  PRO A  62     -26.677  37.583  48.969  1.00 28.66           C  
ATOM    468  CD  PRO A  62     -28.072  37.584  48.435  1.00 28.46           C  
ATOM    469  N   ILE A  63     -26.006  35.936  44.543  1.00 26.37           N  
ATOM    470  CA  ILE A  63     -26.077  34.800  43.599  1.00 25.79           C  
ATOM    471  C   ILE A  63     -24.720  34.176  43.266  1.00 25.09           C  
ATOM    472  O   ILE A  63     -24.650  33.068  42.723  1.00 25.11           O  
ATOM    473  CB  ILE A  63     -26.859  35.151  42.294  1.00 25.71           C  
ATOM    474  CG1 ILE A  63     -26.119  36.209  41.465  1.00 25.70           C  
ATOM    475  CG2 ILE A  63     -28.265  35.599  42.637  1.00 25.41           C  
ATOM    476  CD1 ILE A  63     -26.582  36.289  40.010  1.00 25.72           C  
ATOM    477  N   GLY A  64     -23.649  34.897  43.587  1.00 24.40           N  
ATOM    478  CA  GLY A  64     -22.292  34.410  43.346  1.00 23.47           C  
ATOM    479  C   GLY A  64     -21.227  35.268  44.000  1.00 22.84           C  
ATOM    480  O   GLY A  64     -21.539  36.307  44.598  1.00 22.70           O  
ATOM    481  N   TYR A  65     -19.970  34.837  43.859  1.00 22.03           N  
ATOM    482  CA  TYR A  65     -18.825  35.510  44.479  1.00 21.43           C  
ATOM    483  C   TYR A  65     -17.500  35.214  43.765  1.00 21.03           C  
ATOM    484  O   TYR A  65     -17.372  34.238  43.008  1.00 20.62           O  
ATOM    485  CB  TYR A  65     -18.710  35.138  45.979  1.00 21.13           C  
ATOM    486  CG  TYR A  65     -17.993  33.834  46.234  1.00 21.02           C  
ATOM    487  CD1 TYR A  65     -16.733  33.811  46.846  1.00 20.24           C  
ATOM    488  CD2 TYR A  65     -18.548  32.622  45.826  1.00 20.14           C  
ATOM    489  CE1 TYR A  65     -16.059  32.605  47.055  1.00 19.97           C  
ATOM    490  CE2 TYR A  65     -17.875  31.421  46.026  1.00 19.87           C  
ATOM    491  CZ  TYR A  65     -16.649  31.419  46.651  1.00 19.72           C  
ATOM    492  OH  TYR A  65     -16.007  30.221  46.844  1.00 21.20           O  
ATOM    493  N   ALA A  66     -16.519  36.070  44.007  1.00 20.20           N  
ATOM    494  CA  ALA A  66     -15.131  35.752  43.677  1.00 19.78           C  
ATOM    495  C   ALA A  66     -14.239  36.104  44.858  1.00 19.54           C  
ATOM    496  O   ALA A  66     -14.587  36.960  45.678  1.00 20.15           O  
ATOM    497  CB  ALA A  66     -14.679  36.487  42.434  1.00 19.83           C  
ATOM    498  N   VAL A  67     -13.095  35.434  44.933  1.00 19.07           N  
ATOM    499  CA  VAL A  67     -12.057  35.722  45.903  1.00 19.16           C  
ATOM    500  C   VAL A  67     -10.736  35.804  45.135  1.00 19.53           C  
ATOM    501  O   VAL A  67     -10.408  34.915  44.350  1.00 19.70           O  
ATOM    502  CB  VAL A  67     -11.996  34.637  47.009  1.00 18.66           C  
ATOM    503  CG1 VAL A  67     -10.756  34.809  47.885  1.00 19.11           C  
ATOM    504  CG2 VAL A  67     -13.265  34.661  47.845  1.00 18.69           C  
ATOM    505  N   PHE A  68      -9.997  36.886  45.345  1.00 19.68           N  
ATOM    506  CA  PHE A  68      -8.781  37.117  44.588  1.00 20.08           C  
ATOM    507  C   PHE A  68      -7.720  37.876  45.384  1.00 20.03           C  
ATOM    508  O   PHE A  68      -8.009  38.526  46.408  1.00 19.86           O  
ATOM    509  CB  PHE A  68      -9.109  37.828  43.263  1.00 20.35           C  
ATOM    510  CG  PHE A  68      -9.645  39.210  43.439  1.00 22.40           C  
ATOM    511  CD1 PHE A  68      -8.825  40.309  43.229  1.00 22.50           C  
ATOM    512  CD2 PHE A  68     -10.962  39.414  43.830  1.00 22.10           C  
ATOM    513  CE1 PHE A  68      -9.304  41.557  43.392  1.00 23.28           C  
ATOM    514  CE2 PHE A  68     -11.441  40.664  43.998  1.00 23.40           C  
ATOM    515  CZ  PHE A  68     -10.612  41.743  43.773  1.00 23.13           C  
ATOM    516  N   PHE A  69      -6.490  37.787  44.895  1.00 20.05           N  
ATOM    517  CA  PHE A  69      -5.359  38.497  45.486  1.00 20.40           C  
ATOM    518  C   PHE A  69      -4.383  38.903  44.392  1.00 20.69           C  
ATOM    519  O   PHE A  69      -4.467  38.421  43.256  1.00 19.97           O  
ATOM    520  CB  PHE A  69      -4.672  37.647  46.580  1.00 20.09           C  
ATOM    521  CG  PHE A  69      -4.304  36.246  46.132  1.00 20.77           C  
ATOM    522  CD1 PHE A  69      -3.093  36.002  45.489  1.00 19.46           C  
ATOM    523  CD2 PHE A  69      -5.162  35.175  46.368  1.00 20.45           C  
ATOM    524  CE1 PHE A  69      -2.748  34.718  45.069  1.00 20.71           C  
ATOM    525  CE2 PHE A  69      -4.822  33.869  45.963  1.00 21.27           C  
ATOM    526  CZ  PHE A  69      -3.609  33.645  45.309  1.00 20.57           C  
ATOM    527  N   TYR A  70      -3.464  39.800  44.735  1.00 21.09           N  
ATOM    528  CA  TYR A  70      -2.498  40.281  43.764  1.00 21.71           C  
ATOM    529  C   TYR A  70      -1.267  39.389  43.688  1.00 21.45           C  
ATOM    530  O   TYR A  70      -0.678  39.023  44.712  1.00 20.48           O  
ATOM    531  CB  TYR A  70      -2.134  41.742  44.034  1.00 22.88           C  
ATOM    532  CG  TYR A  70      -3.200  42.685  43.528  1.00 24.46           C  
ATOM    533  CD1 TYR A  70      -3.045  43.339  42.315  1.00 25.56           C  
ATOM    534  CD2 TYR A  70      -4.389  42.882  44.235  1.00 26.08           C  
ATOM    535  CE1 TYR A  70      -4.025  44.189  41.819  1.00 25.26           C  
ATOM    536  CE2 TYR A  70      -5.384  43.737  43.745  1.00 27.54           C  
ATOM    537  CZ  TYR A  70      -5.187  44.385  42.531  1.00 26.30           C  
ATOM    538  OH  TYR A  70      -6.143  45.238  42.022  1.00 27.26           O  
ATOM    539  N   SER A  71      -0.918  39.022  42.453  1.00 21.25           N  
ATOM    540  CA  SER A  71       0.320  38.315  42.155  1.00 21.28           C  
ATOM    541  C   SER A  71       1.339  39.301  41.571  1.00 21.38           C  
ATOM    542  O   SER A  71       1.103  40.517  41.536  1.00 20.64           O  
ATOM    543  CB  SER A  71       0.048  37.177  41.157  1.00 21.03           C  
ATOM    544  OG  SER A  71      -0.506  37.699  39.958  1.00 21.24           O  
ATOM    545  N   TYR A  72       2.468  38.765  41.118  1.00 21.20           N  
ATOM    546  CA  TYR A  72       3.519  39.566  40.508  1.00 21.63           C  
ATOM    547  C   TYR A  72       4.256  38.747  39.455  1.00 21.41           C  
ATOM    548  O   TYR A  72       4.565  37.580  39.664  1.00 20.72           O  
ATOM    549  CB  TYR A  72       4.496  40.107  41.571  1.00 21.50           C  
ATOM    550  CG  TYR A  72       5.502  41.094  41.024  1.00 22.21           C  
ATOM    551  CD1 TYR A  72       5.142  42.427  40.794  1.00 22.74           C  
ATOM    552  CD2 TYR A  72       6.812  40.699  40.716  1.00 22.12           C  
ATOM    553  CE1 TYR A  72       6.055  43.347  40.272  1.00 23.00           C  
ATOM    554  CE2 TYR A  72       7.735  41.612  40.189  1.00 22.23           C  
ATOM    555  CZ  TYR A  72       7.349  42.936  39.978  1.00 21.95           C  
ATOM    556  OH  TYR A  72       8.242  43.849  39.467  1.00 21.17           O  
ATOM    557  N   SER A  73       4.511  39.378  38.310  1.00 21.73           N  
ATOM    558  CA  SER A  73       5.327  38.787  37.265  1.00 21.40           C  
ATOM    559  C   SER A  73       6.653  39.533  37.188  1.00 21.41           C  
ATOM    560  O   SER A  73       6.691  40.733  36.867  1.00 21.30           O  
ATOM    561  CB  SER A  73       4.623  38.879  35.914  1.00 21.36           C  
ATOM    562  OG  SER A  73       5.518  38.521  34.880  1.00 22.77           O  
ATOM    563  N   THR A  74       7.733  38.819  37.484  1.00 20.81           N  
ATOM    564  CA  THR A  74       9.078  39.383  37.379  1.00 20.95           C  
ATOM    565  C   THR A  74       9.477  39.598  35.912  1.00 21.07           C  
ATOM    566  O   THR A  74      10.296  40.462  35.605  1.00 21.02           O  
ATOM    567  CB  THR A  74      10.128  38.497  38.077  1.00 20.85           C  
ATOM    568  OG1 THR A  74      10.113  37.178  37.509  1.00 20.57           O  
ATOM    569  CG2 THR A  74       9.864  38.407  39.574  1.00 20.85           C  
ATOM    570  N   TRP A  75       8.888  38.819  35.007  1.00 20.48           N  
ATOM    571  CA  TRP A  75       9.187  38.968  33.586  1.00 21.06           C  
ATOM    572  C   TRP A  75       8.595  40.259  33.010  1.00 21.25           C  
ATOM    573  O   TRP A  75       9.218  40.915  32.182  1.00 20.96           O  
ATOM    574  CB  TRP A  75       8.697  37.751  32.799  1.00 21.18           C  
ATOM    575  CG  TRP A  75       9.378  36.475  33.194  1.00 21.29           C  
ATOM    576  CD1 TRP A  75      10.426  36.333  34.070  1.00 21.20           C  
ATOM    577  CD2 TRP A  75       9.083  35.157  32.708  1.00 22.60           C  
ATOM    578  NE1 TRP A  75      10.780  35.010  34.170  1.00 22.71           N  
ATOM    579  CE2 TRP A  75       9.982  34.266  33.343  1.00 21.31           C  
ATOM    580  CE3 TRP A  75       8.144  34.642  31.796  1.00 22.73           C  
ATOM    581  CZ2 TRP A  75       9.980  32.886  33.094  1.00 22.74           C  
ATOM    582  CZ3 TRP A  75       8.139  33.263  31.551  1.00 22.83           C  
ATOM    583  CH2 TRP A  75       9.051  32.402  32.202  1.00 21.60           C  
ATOM    584  N   LEU A  76       7.402  40.610  33.480  1.00 21.50           N  
ATOM    585  CA  LEU A  76       6.659  41.777  33.018  1.00 22.14           C  
ATOM    586  C   LEU A  76       6.969  43.004  33.859  1.00 22.34           C  
ATOM    587  O   LEU A  76       6.716  44.131  33.438  1.00 21.90           O  
ATOM    588  CB  LEU A  76       5.148  41.497  33.105  1.00 22.16           C  
ATOM    589  CG  LEU A  76       4.532  40.384  32.254  1.00 22.70           C  
ATOM    590  CD1 LEU A  76       3.018  40.443  32.383  1.00 21.76           C  
ATOM    591  CD2 LEU A  76       4.944  40.509  30.776  1.00 21.44           C  
ATOM    592  N   GLY A  77       7.499  42.770  35.061  1.00 22.68           N  
ATOM    593  CA  GLY A  77       7.702  43.835  36.040  1.00 22.76           C  
ATOM    594  C   GLY A  77       6.375  44.465  36.410  1.00 22.89           C  
ATOM    595  O   GLY A  77       6.283  45.678  36.583  1.00 22.85           O  
ATOM    596  N   ARG A  78       5.343  43.633  36.535  1.00 22.70           N  
ATOM    597  CA  ARG A  78       3.988  44.115  36.779  1.00 22.70           C  
ATOM    598  C   ARG A  78       3.239  43.222  37.755  1.00 22.58           C  
ATOM    599  O   ARG A  78       3.421  42.001  37.761  1.00 21.72           O  
ATOM    600  CB  ARG A  78       3.197  44.173  35.468  1.00 22.46           C  
ATOM    601  CG  ARG A  78       3.627  45.256  34.496  1.00 23.04           C  
ATOM    602  CD  ARG A  78       2.853  45.142  33.189  1.00 23.55           C  
ATOM    603  NE  ARG A  78       1.568  45.828  33.270  1.00 24.48           N  
ATOM    604  CZ  ARG A  78       0.666  45.875  32.290  1.00 26.97           C  
ATOM    605  NH1 ARG A  78       0.890  45.269  31.127  1.00 25.52           N  
ATOM    606  NH2 ARG A  78      -0.469  46.546  32.473  1.00 27.85           N  
ATOM    607  N   ASN A  79       2.369  43.835  38.557  1.00 22.08           N  
ATOM    608  CA  ASN A  79       1.437  43.058  39.370  1.00 22.07           C  
ATOM    609  C   ASN A  79       0.511  42.271  38.458  1.00 21.71           C  
ATOM    610  O   ASN A  79       0.379  42.589  37.274  1.00 21.13           O  
ATOM    611  CB  ASN A  79       0.617  43.959  40.291  1.00 22.31           C  
ATOM    612  CG  ASN A  79       1.476  44.731  41.280  1.00 23.88           C  
ATOM    613  OD1 ASN A  79       1.221  45.902  41.548  1.00 28.88           O  
ATOM    614  ND2 ASN A  79       2.491  44.089  41.817  1.00 23.49           N  
ATOM    615  N   GLY A  80      -0.088  41.222  39.003  1.00 21.01           N  
ATOM    616  CA  GLY A  80      -1.171  40.524  38.342  1.00 20.89           C  
ATOM    617  C   GLY A  80      -2.253  40.285  39.375  1.00 20.77           C  
ATOM    618  O   GLY A  80      -2.074  40.613  40.555  1.00 21.29           O  
ATOM    619  N   ILE A  81      -3.379  39.731  38.935  1.00 20.61           N  
ATOM    620  CA  ILE A  81      -4.415  39.264  39.859  1.00 20.30           C  
ATOM    621  C   ILE A  81      -4.555  37.762  39.701  1.00 20.41           C  
ATOM    622  O   ILE A  81      -4.572  37.251  38.572  1.00 20.04           O  
ATOM    623  CB  ILE A  81      -5.772  39.936  39.599  1.00 20.04           C  
ATOM    624  CG1 ILE A  81      -5.652  41.452  39.847  1.00 19.57           C  
ATOM    625  CG2 ILE A  81      -6.866  39.303  40.474  1.00 20.49           C  
ATOM    626  CD1 ILE A  81      -6.933  42.239  39.621  1.00 20.81           C  
ATOM    627  N   TYR A  82      -4.611  37.061  40.829  1.00 19.72           N  
ATOM    628  CA  TYR A  82      -4.933  35.642  40.811  1.00 20.21           C  
ATOM    629  C   TYR A  82      -6.318  35.450  41.427  1.00 20.31           C  
ATOM    630  O   TYR A  82      -6.577  35.901  42.545  1.00 20.23           O  
ATOM    631  CB  TYR A  82      -3.871  34.800  41.523  1.00 19.71           C  
ATOM    632  CG  TYR A  82      -4.157  33.320  41.425  1.00 20.55           C  
ATOM    633  CD1 TYR A  82      -3.726  32.589  40.322  1.00 19.90           C  
ATOM    634  CD2 TYR A  82      -4.900  32.659  42.412  1.00 18.51           C  
ATOM    635  CE1 TYR A  82      -4.002  31.229  40.217  1.00 21.69           C  
ATOM    636  CE2 TYR A  82      -5.174  31.305  42.319  1.00 19.12           C  
ATOM    637  CZ  TYR A  82      -4.722  30.600  41.221  1.00 20.24           C  
ATOM    638  OH  TYR A  82      -4.986  29.260  41.099  1.00 23.09           O  
ATOM    639  N   LEU A  83      -7.202  34.818  40.660  1.00 20.27           N  
ATOM    640  CA  LEU A  83      -8.570  34.523  41.078  1.00 20.76           C  
ATOM    641  C   LEU A  83      -8.617  33.129  41.711  1.00 20.56           C  
ATOM    642  O   LEU A  83      -8.450  32.126  41.017  1.00 20.75           O  
ATOM    643  CB  LEU A  83      -9.495  34.616  39.852  1.00 20.33           C  
ATOM    644  CG  LEU A  83     -10.957  34.172  39.876  1.00 21.56           C  
ATOM    645  CD1 LEU A  83     -11.773  34.997  40.858  1.00 19.78           C  
ATOM    646  CD2 LEU A  83     -11.527  34.315  38.470  1.00 21.10           C  
ATOM    647  N   GLU A  84      -8.826  33.067  43.026  1.00 20.70           N  
ATOM    648  CA  GLU A  84      -8.829  31.791  43.762  1.00 20.93           C  
ATOM    649  C   GLU A  84     -10.157  31.033  43.626  1.00 20.81           C  
ATOM    650  O   GLU A  84     -10.170  29.836  43.324  1.00 20.08           O  
ATOM    651  CB  GLU A  84      -8.468  32.005  45.244  1.00 21.20           C  
ATOM    652  CG  GLU A  84      -8.595  30.751  46.136  1.00 21.58           C  
ATOM    653  CD  GLU A  84      -7.864  29.520  45.570  1.00 23.36           C  
ATOM    654  OE1 GLU A  84      -6.721  29.648  45.083  1.00 24.29           O  
ATOM    655  OE2 GLU A  84      -8.445  28.420  45.596  1.00 25.22           O  
ATOM    656  N   ASP A  85     -11.263  31.740  43.839  1.00 20.61           N  
ATOM    657  CA  ASP A  85     -12.606  31.169  43.763  1.00 21.15           C  
ATOM    658  C   ASP A  85     -13.475  32.029  42.859  1.00 21.91           C  
ATOM    659  O   ASP A  85     -13.442  33.258  42.939  1.00 21.23           O  
ATOM    660  CB  ASP A  85     -13.285  31.153  45.149  1.00 21.18           C  
ATOM    661  CG  ASP A  85     -12.858  29.983  46.027  1.00 20.81           C  
ATOM    662  OD1 ASP A  85     -11.847  29.341  45.727  1.00 19.13           O  
ATOM    663  OD2 ASP A  85     -13.546  29.710  47.048  1.00 21.16           O  
ATOM    664  N   LEU A  86     -14.280  31.376  42.028  1.00 23.05           N  
ATOM    665  CA  LEU A  86     -15.313  32.051  41.236  1.00 24.61           C  
ATOM    666  C   LEU A  86     -16.498  31.106  41.190  1.00 25.65           C  
ATOM    667  O   LEU A  86     -16.345  29.950  40.802  1.00 26.30           O  
ATOM    668  CB  LEU A  86     -14.804  32.353  39.821  1.00 24.63           C  
ATOM    669  CG  LEU A  86     -15.768  33.012  38.819  1.00 24.33           C  
ATOM    670  CD1 LEU A  86     -15.897  34.493  39.092  1.00 24.57           C  
ATOM    671  CD2 LEU A  86     -15.276  32.791  37.396  1.00 24.95           C  
ATOM    672  N   TYR A  87     -17.671  31.580  41.599  1.00 26.73           N  
ATOM    673  CA  TYR A  87     -18.839  30.707  41.689  1.00 28.04           C  
ATOM    674  C   TYR A  87     -20.138  31.483  41.509  1.00 28.78           C  
ATOM    675  O   TYR A  87     -20.303  32.568  42.063  1.00 28.68           O  
ATOM    676  CB  TYR A  87     -18.824  29.959  43.036  1.00 27.81           C  
ATOM    677  CG  TYR A  87     -20.035  29.110  43.331  1.00 27.70           C  
ATOM    678  CD1 TYR A  87     -20.150  27.808  42.820  1.00 27.04           C  
ATOM    679  CD2 TYR A  87     -21.058  29.595  44.133  1.00 26.96           C  
ATOM    680  CE1 TYR A  87     -21.269  27.025  43.103  1.00 26.91           C  
ATOM    681  CE2 TYR A  87     -22.168  28.830  44.417  1.00 28.14           C  
ATOM    682  CZ  TYR A  87     -22.271  27.546  43.898  1.00 27.71           C  
ATOM    683  OH  TYR A  87     -23.391  26.802  44.196  1.00 28.51           O  
ATOM    684  N   VAL A  88     -21.042  30.914  40.715  1.00 30.25           N  
ATOM    685  CA  VAL A  88     -22.430  31.377  40.614  1.00 31.65           C  
ATOM    686  C   VAL A  88     -23.346  30.191  40.949  1.00 33.12           C  
ATOM    687  O   VAL A  88     -23.180  29.101  40.390  1.00 33.33           O  
ATOM    688  CB  VAL A  88     -22.765  31.946  39.198  1.00 31.52           C  
ATOM    689  CG1 VAL A  88     -24.234  32.378  39.111  1.00 31.37           C  
ATOM    690  CG2 VAL A  88     -21.844  33.112  38.840  1.00 30.50           C  
ATOM    691  N   THR A  89     -24.287  30.398  41.870  1.00 34.78           N  
ATOM    692  CA  THR A  89     -25.222  29.349  42.290  1.00 36.91           C  
ATOM    693  C   THR A  89     -26.046  28.832  41.081  1.00 38.24           C  
ATOM    694  O   THR A  89     -26.380  29.617  40.183  1.00 38.27           O  
ATOM    695  CB  THR A  89     -26.117  29.826  43.487  1.00 37.01           C  
ATOM    696  OG1 THR A  89     -26.671  28.695  44.175  1.00 37.82           O  
ATOM    697  CG2 THR A  89     -27.240  30.758  43.030  1.00 36.92           C  
ATOM    698  N   PRO A  90     -26.327  27.505  41.034  1.00 39.57           N  
ATOM    699  CA  PRO A  90     -27.022  26.848  39.910  1.00 40.52           C  
ATOM    700  C   PRO A  90     -28.264  27.557  39.351  1.00 41.43           C  
ATOM    701  O   PRO A  90     -28.429  27.608  38.134  1.00 41.31           O  
ATOM    702  CB  PRO A  90     -27.391  25.478  40.486  1.00 40.64           C  
ATOM    703  CG  PRO A  90     -26.256  25.185  41.411  1.00 40.12           C  
ATOM    704  CD  PRO A  90     -25.949  26.516  42.065  1.00 39.75           C  
ATOM    705  N   GLU A  91     -29.111  28.108  40.218  1.00 42.66           N  
ATOM    706  CA  GLU A  91     -30.364  28.715  39.764  1.00 44.21           C  
ATOM    707  C   GLU A  91     -30.157  30.010  38.955  1.00 44.66           C  
ATOM    708  O   GLU A  91     -31.123  30.586  38.439  1.00 44.83           O  
ATOM    709  CB  GLU A  91     -31.327  28.946  40.936  1.00 43.99           C  
ATOM    710  CG  GLU A  91     -32.811  28.788  40.551  1.00 45.26           C  
ATOM    711  CD  GLU A  91     -33.788  29.365  41.578  1.00 45.43           C  
ATOM    712  OE1 GLU A  91     -34.846  28.731  41.813  1.00 46.88           O  
ATOM    713  OE2 GLU A  91     -33.512  30.450  42.140  1.00 46.99           O  
ATOM    714  N   TYR A  92     -28.898  30.441  38.825  1.00 45.31           N  
ATOM    715  CA  TYR A  92     -28.558  31.692  38.136  1.00 45.79           C  
ATOM    716  C   TYR A  92     -27.459  31.547  37.089  1.00 46.28           C  
ATOM    717  O   TYR A  92     -26.812  32.531  36.720  1.00 46.53           O  
ATOM    718  CB  TYR A  92     -28.168  32.769  39.153  1.00 45.70           C  
ATOM    719  CG  TYR A  92     -29.338  33.327  39.926  1.00 45.70           C  
ATOM    720  CD1 TYR A  92     -29.785  32.712  41.093  1.00 45.63           C  
ATOM    721  CD2 TYR A  92     -29.998  34.473  39.489  1.00 45.71           C  
ATOM    722  CE1 TYR A  92     -30.861  33.223  41.804  1.00 45.52           C  
ATOM    723  CE2 TYR A  92     -31.075  34.993  40.192  1.00 45.57           C  
ATOM    724  CZ  TYR A  92     -31.500  34.363  41.347  1.00 45.80           C  
ATOM    725  OH  TYR A  92     -32.566  34.880  42.045  1.00 46.09           O  
ATOM    726  N   ARG A  93     -27.255  30.332  36.594  1.00 46.88           N  
ATOM    727  CA  ARG A  93     -26.170  30.075  35.650  1.00 47.44           C  
ATOM    728  C   ARG A  93     -26.625  30.097  34.193  1.00 47.62           C  
ATOM    729  O   ARG A  93     -25.915  30.613  33.330  1.00 47.72           O  
ATOM    730  CB  ARG A  93     -25.460  28.761  35.985  1.00 47.74           C  
ATOM    731  CG  ARG A  93     -24.498  28.897  37.152  1.00 48.78           C  
ATOM    732  CD  ARG A  93     -24.406  27.628  37.968  1.00 50.87           C  
ATOM    733  NE  ARG A  93     -23.150  26.903  37.794  1.00 52.58           N  
ATOM    734  CZ  ARG A  93     -22.633  26.080  38.705  1.00 53.57           C  
ATOM    735  NH1 ARG A  93     -23.256  25.883  39.865  1.00 53.49           N  
ATOM    736  NH2 ARG A  93     -21.486  25.454  38.463  1.00 53.85           N  
ATOM    737  N   GLY A  96     -25.843  36.255  32.457  1.00 32.99           N  
ATOM    738  CA  GLY A  96     -24.446  35.796  32.460  1.00 32.74           C  
ATOM    739  C   GLY A  96     -23.625  36.368  33.606  1.00 32.85           C  
ATOM    740  O   GLY A  96     -22.798  37.259  33.405  1.00 32.83           O  
ATOM    741  N   ALA A  97     -23.847  35.839  34.807  1.00 32.65           N  
ATOM    742  CA  ALA A  97     -23.250  36.375  36.035  1.00 32.40           C  
ATOM    743  C   ALA A  97     -21.740  36.120  36.189  1.00 32.25           C  
ATOM    744  O   ALA A  97     -21.000  36.996  36.651  1.00 32.04           O  
ATOM    745  CB  ALA A  97     -24.009  35.856  37.250  1.00 32.49           C  
ATOM    746  N   GLY A  98     -21.294  34.929  35.796  1.00 31.89           N  
ATOM    747  CA  GLY A  98     -19.889  34.543  35.892  1.00 31.40           C  
ATOM    748  C   GLY A  98     -19.008  35.406  35.012  1.00 31.42           C  
ATOM    749  O   GLY A  98     -17.934  35.843  35.431  1.00 30.97           O  
ATOM    750  N   ARG A  99     -19.482  35.650  33.791  1.00 31.14           N  
ATOM    751  CA  ARG A  99     -18.812  36.502  32.822  1.00 31.46           C  
ATOM    752  C   ARG A  99     -18.712  37.934  33.346  1.00 31.13           C  
ATOM    753  O   ARG A  99     -17.706  38.616  33.146  1.00 31.31           O  
ATOM    754  CB  ARG A  99     -19.605  36.491  31.517  1.00 31.99           C  
ATOM    755  CG  ARG A  99     -18.761  36.339  30.274  1.00 33.95           C  
ATOM    756  CD  ARG A  99     -19.630  36.411  29.025  1.00 37.63           C  
ATOM    757  NE  ARG A  99     -18.971  35.803  27.868  1.00 40.19           N  
ATOM    758  CZ  ARG A  99     -18.046  36.401  27.117  1.00 41.61           C  
ATOM    759  NH1 ARG A  99     -17.646  37.640  27.393  1.00 42.45           N  
ATOM    760  NH2 ARG A  99     -17.516  35.755  26.086  1.00 42.57           N  
ATOM    761  N   ARG A 100     -19.776  38.378  34.008  1.00 30.46           N  
ATOM    762  CA  ARG A 100     -19.835  39.698  34.614  1.00 30.10           C  
ATOM    763  C   ARG A 100     -18.805  39.865  35.738  1.00 29.08           C  
ATOM    764  O   ARG A 100     -18.124  40.889  35.817  1.00 28.83           O  
ATOM    765  CB  ARG A 100     -21.246  39.946  35.143  1.00 30.62           C  
ATOM    766  CG  ARG A 100     -21.519  41.369  35.505  1.00 33.06           C  
ATOM    767  CD  ARG A 100     -21.910  42.181  34.281  1.00 37.63           C  
ATOM    768  NE  ARG A 100     -21.652  43.601  34.505  1.00 41.31           N  
ATOM    769  CZ  ARG A 100     -22.347  44.376  35.336  1.00 42.85           C  
ATOM    770  NH1 ARG A 100     -23.362  43.882  36.039  1.00 42.94           N  
ATOM    771  NH2 ARG A 100     -22.023  45.658  35.462  1.00 44.53           N  
ATOM    772  N   LEU A 101     -18.696  38.856  36.602  1.00 28.08           N  
ATOM    773  CA  LEU A 101     -17.688  38.853  37.665  1.00 27.26           C  
ATOM    774  C   LEU A 101     -16.270  38.913  37.086  1.00 27.00           C  
ATOM    775  O   LEU A 101     -15.433  39.687  37.565  1.00 26.49           O  
ATOM    776  CB  LEU A 101     -17.849  37.628  38.573  1.00 27.07           C  
ATOM    777  CG  LEU A 101     -18.939  37.637  39.650  1.00 27.10           C  
ATOM    778  CD1 LEU A 101     -19.243  36.219  40.145  1.00 27.13           C  
ATOM    779  CD2 LEU A 101     -18.573  38.550  40.823  1.00 27.33           C  
ATOM    780  N   LEU A 102     -16.015  38.122  36.044  1.00 27.17           N  
ATOM    781  CA  LEU A 102     -14.714  38.141  35.354  1.00 27.54           C  
ATOM    782  C   LEU A 102     -14.377  39.488  34.727  1.00 27.29           C  
ATOM    783  O   LEU A 102     -13.222  39.935  34.780  1.00 27.65           O  
ATOM    784  CB  LEU A 102     -14.630  37.041  34.293  1.00 27.64           C  
ATOM    785  CG  LEU A 102     -14.060  35.695  34.736  1.00 29.24           C  
ATOM    786  CD1 LEU A 102     -14.343  34.650  33.690  1.00 30.12           C  
ATOM    787  CD2 LEU A 102     -12.559  35.774  35.003  1.00 29.02           C  
ATOM    788  N   ARG A 103     -15.385  40.120  34.131  1.00 27.18           N  
ATOM    789  CA  ARG A 103     -15.232  41.432  33.511  1.00 27.15           C  
ATOM    790  C   ARG A 103     -14.751  42.451  34.540  1.00 26.27           C  
ATOM    791  O   ARG A 103     -13.816  43.210  34.280  1.00 25.79           O  
ATOM    792  CB  ARG A 103     -16.562  41.875  32.892  1.00 26.98           C  
ATOM    793  CG  ARG A 103     -16.572  43.252  32.232  1.00 27.78           C  
ATOM    794  CD  ARG A 103     -17.814  43.408  31.343  1.00 29.34           C  
ATOM    795  NE  ARG A 103     -17.825  42.382  30.289  1.00 35.87           N  
ATOM    796  CZ  ARG A 103     -18.680  41.352  30.205  1.00 38.04           C  
ATOM    797  NH1 ARG A 103     -19.660  41.185  31.098  1.00 37.00           N  
ATOM    798  NH2 ARG A 103     -18.558  40.484  29.198  1.00 38.81           N  
ATOM    799  N   GLU A 104     -15.390  42.440  35.712  1.00 25.70           N  
ATOM    800  CA  GLU A 104     -15.027  43.343  36.798  1.00 25.48           C  
ATOM    801  C   GLU A 104     -13.597  43.123  37.261  1.00 24.53           C  
ATOM    802  O   GLU A 104     -12.870  44.086  37.518  1.00 23.91           O  
ATOM    803  CB  GLU A 104     -16.016  43.221  37.965  1.00 25.97           C  
ATOM    804  CG  GLU A 104     -17.393  43.791  37.634  1.00 28.99           C  
ATOM    805  CD  GLU A 104     -17.336  45.220  37.112  1.00 33.19           C  
ATOM    806  OE1 GLU A 104     -16.826  46.101  37.843  1.00 35.29           O  
ATOM    807  OE2 GLU A 104     -17.796  45.465  35.970  1.00 34.18           O  
ATOM    808  N   LEU A 105     -13.193  41.856  37.333  1.00 23.75           N  
ATOM    809  CA  LEU A 105     -11.817  41.504  37.704  1.00 23.88           C  
ATOM    810  C   LEU A 105     -10.824  41.996  36.659  1.00 23.34           C  
ATOM    811  O   LEU A 105      -9.770  42.537  37.006  1.00 23.04           O  
ATOM    812  CB  LEU A 105     -11.672  39.995  37.944  1.00 23.72           C  
ATOM    813  CG  LEU A 105     -12.409  39.503  39.196  1.00 25.29           C  
ATOM    814  CD1 LEU A 105     -12.701  38.025  39.134  1.00 24.54           C  
ATOM    815  CD2 LEU A 105     -11.630  39.853  40.461  1.00 26.54           C  
ATOM    816  N   ALA A 106     -11.175  41.821  35.383  1.00 23.45           N  
ATOM    817  CA  ALA A 106     -10.351  42.314  34.275  1.00 23.05           C  
ATOM    818  C   ALA A 106     -10.225  43.841  34.314  1.00 23.21           C  
ATOM    819  O   ALA A 106      -9.130  44.392  34.158  1.00 22.94           O  
ATOM    820  CB  ALA A 106     -10.920  41.844  32.939  1.00 23.52           C  
ATOM    821  N   ARG A 107     -11.345  44.526  34.543  1.00 23.66           N  
ATOM    822  CA  ARG A 107     -11.332  45.985  34.699  1.00 23.67           C  
ATOM    823  C   ARG A 107     -10.426  46.403  35.858  1.00 23.33           C  
ATOM    824  O   ARG A 107      -9.668  47.365  35.747  1.00 22.84           O  
ATOM    825  CB  ARG A 107     -12.745  46.527  34.913  1.00 23.77           C  
ATOM    826  CG  ARG A 107     -13.662  46.398  33.708  1.00 24.55           C  
ATOM    827  CD  ARG A 107     -15.008  47.078  33.946  1.00 25.22           C  
ATOM    828  NE  ARG A 107     -14.919  48.529  33.787  1.00 31.16           N  
ATOM    829  CZ  ARG A 107     -14.847  49.405  34.790  1.00 33.28           C  
ATOM    830  NH1 ARG A 107     -14.866  48.992  36.056  1.00 34.70           N  
ATOM    831  NH2 ARG A 107     -14.764  50.704  34.524  1.00 33.77           N  
ATOM    832  N   GLU A 108     -10.500  45.667  36.966  1.00 23.50           N  
ATOM    833  CA  GLU A 108      -9.631  45.926  38.104  1.00 24.13           C  
ATOM    834  C   GLU A 108      -8.167  45.719  37.691  1.00 23.40           C  
ATOM    835  O   GLU A 108      -7.310  46.535  38.021  1.00 23.01           O  
ATOM    836  CB  GLU A 108     -10.000  45.048  39.313  1.00 24.12           C  
ATOM    837  CG  GLU A 108      -9.186  45.391  40.567  1.00 25.31           C  
ATOM    838  CD  GLU A 108      -9.548  44.556  41.791  1.00 26.47           C  
ATOM    839  OE1 GLU A 108     -10.723  44.120  41.917  1.00 28.87           O  
ATOM    840  OE2 GLU A 108      -8.648  44.347  42.644  1.00 30.17           O  
ATOM    841  N   ALA A 109      -7.900  44.643  36.945  1.00 23.18           N  
ATOM    842  CA  ALA A 109      -6.550  44.333  36.456  1.00 23.09           C  
ATOM    843  C   ALA A 109      -6.009  45.465  35.579  1.00 23.17           C  
ATOM    844  O   ALA A 109      -4.896  45.938  35.784  1.00 23.36           O  
ATOM    845  CB  ALA A 109      -6.547  42.996  35.695  1.00 22.84           C  
ATOM    846  N   VAL A 110      -6.819  45.922  34.630  1.00 23.55           N  
ATOM    847  CA  VAL A 110      -6.438  47.026  33.738  1.00 24.43           C  
ATOM    848  C   VAL A 110      -6.199  48.351  34.492  1.00 24.43           C  
ATOM    849  O   VAL A 110      -5.181  49.016  34.279  1.00 24.97           O  
ATOM    850  CB  VAL A 110      -7.450  47.163  32.555  1.00 24.39           C  
ATOM    851  CG1 VAL A 110      -7.248  48.451  31.792  1.00 26.56           C  
ATOM    852  CG2 VAL A 110      -7.306  45.969  31.611  1.00 24.97           C  
ATOM    853  N   ALA A 111      -7.105  48.711  35.399  1.00 24.48           N  
ATOM    854  CA  ALA A 111      -6.975  49.962  36.160  1.00 24.25           C  
ATOM    855  C   ALA A 111      -5.768  49.948  37.100  1.00 24.45           C  
ATOM    856  O   ALA A 111      -5.134  50.983  37.320  1.00 24.78           O  
ATOM    857  CB  ALA A 111      -8.253  50.255  36.937  1.00 24.26           C  
ATOM    858  N   ASN A 112      -5.447  48.774  37.640  1.00 24.50           N  
ATOM    859  CA  ASN A 112      -4.318  48.631  38.553  1.00 25.03           C  
ATOM    860  C   ASN A 112      -3.008  48.226  37.877  1.00 24.60           C  
ATOM    861  O   ASN A 112      -2.106  47.711  38.535  1.00 25.06           O  
ATOM    862  CB  ASN A 112      -4.649  47.666  39.691  1.00 25.59           C  
ATOM    863  CG  ASN A 112      -5.535  48.287  40.754  1.00 27.59           C  
ATOM    864  OD1 ASN A 112      -6.565  47.725  41.112  1.00 32.76           O  
ATOM    865  ND2 ASN A 112      -5.143  49.440  41.263  1.00 28.32           N  
ATOM    866  N   ASP A 113      -2.901  48.471  36.572  1.00 24.44           N  
ATOM    867  CA  ASP A 113      -1.658  48.224  35.831  1.00 24.56           C  
ATOM    868  C   ASP A 113      -1.190  46.760  35.887  1.00 24.16           C  
ATOM    869  O   ASP A 113       0.011  46.494  35.972  1.00 24.35           O  
ATOM    870  CB  ASP A 113      -0.547  49.157  36.347  1.00 24.99           C  
ATOM    871  CG  ASP A 113       0.621  49.288  35.376  1.00 26.38           C  
ATOM    872  OD1 ASP A 113       0.451  49.004  34.173  1.00 28.11           O  
ATOM    873  OD2 ASP A 113       1.719  49.672  35.829  1.00 28.69           O  
ATOM    874  N   CYS A 114      -2.133  45.821  35.837  1.00 23.88           N  
ATOM    875  CA  CYS A 114      -1.807  44.383  35.894  1.00 23.21           C  
ATOM    876  C   CYS A 114      -1.585  43.743  34.522  1.00 23.30           C  
ATOM    877  O   CYS A 114      -2.343  43.993  33.588  1.00 23.00           O  
ATOM    878  CB  CYS A 114      -2.906  43.615  36.631  1.00 23.37           C  
ATOM    879  SG  CYS A 114      -3.004  43.986  38.378  1.00 22.93           S  
ATOM    880  N   GLY A 115      -0.563  42.896  34.414  1.00 23.03           N  
ATOM    881  CA  GLY A 115      -0.261  42.217  33.147  1.00 23.09           C  
ATOM    882  C   GLY A 115      -1.091  40.963  32.894  1.00 23.14           C  
ATOM    883  O   GLY A 115      -1.325  40.581  31.738  1.00 23.64           O  
ATOM    884  N   ARG A 116      -1.547  40.323  33.970  1.00 22.65           N  
ATOM    885  CA  ARG A 116      -2.177  39.002  33.881  1.00 22.72           C  
ATOM    886  C   ARG A 116      -3.331  38.873  34.863  1.00 21.61           C  
ATOM    887  O   ARG A 116      -3.286  39.427  35.966  1.00 20.53           O  
ATOM    888  CB  ARG A 116      -1.131  37.874  34.070  1.00 22.50           C  
ATOM    889  CG  ARG A 116       0.155  38.185  33.279  1.00 24.35           C  
ATOM    890  CD  ARG A 116       1.086  37.053  32.871  1.00 24.96           C  
ATOM    891  NE  ARG A 116       1.836  36.514  33.973  1.00 26.84           N  
ATOM    892  CZ  ARG A 116       3.113  36.135  33.944  1.00 25.83           C  
ATOM    893  NH1 ARG A 116       3.878  36.261  32.861  1.00 27.79           N  
ATOM    894  NH2 ARG A 116       3.630  35.635  35.043  1.00 23.55           N  
ATOM    895  N   LEU A 117      -4.392  38.213  34.402  1.00 20.55           N  
ATOM    896  CA  LEU A 117      -5.450  37.702  35.270  1.00 19.04           C  
ATOM    897  C   LEU A 117      -5.374  36.183  35.144  1.00 18.96           C  
ATOM    898  O   LEU A 117      -5.373  35.664  34.031  1.00 17.99           O  
ATOM    899  CB  LEU A 117      -6.811  38.214  34.808  1.00 19.05           C  
ATOM    900  CG  LEU A 117      -8.071  37.755  35.553  1.00 19.39           C  
ATOM    901  CD1 LEU A 117      -7.978  37.980  37.071  1.00 17.78           C  
ATOM    902  CD2 LEU A 117      -9.319  38.426  34.974  1.00 19.21           C  
ATOM    903  N   GLU A 118      -5.262  35.478  36.269  1.00 18.33           N  
ATOM    904  CA  GLU A 118      -5.044  34.030  36.235  1.00 18.75           C  
ATOM    905  C   GLU A 118      -5.899  33.339  37.281  1.00 18.53           C  
ATOM    906  O   GLU A 118      -6.423  33.982  38.193  1.00 17.73           O  
ATOM    907  CB  GLU A 118      -3.572  33.685  36.486  1.00 18.37           C  
ATOM    908  CG  GLU A 118      -2.612  34.293  35.471  1.00 20.86           C  
ATOM    909  CD  GLU A 118      -1.175  33.990  35.806  1.00 23.02           C  
ATOM    910  OE1 GLU A 118      -0.684  34.439  36.869  1.00 24.34           O  
ATOM    911  OE2 GLU A 118      -0.546  33.286  35.012  1.00 22.79           O  
ATOM    912  N   TRP A 119      -6.030  32.024  37.122  1.00 18.66           N  
ATOM    913  CA  TRP A 119      -6.862  31.196  37.988  1.00 19.36           C  
ATOM    914  C   TRP A 119      -6.554  29.749  37.625  1.00 20.30           C  
ATOM    915  O   TRP A 119      -5.804  29.481  36.662  1.00 20.03           O  
ATOM    916  CB  TRP A 119      -8.361  31.503  37.802  1.00 19.21           C  
ATOM    917  CG  TRP A 119      -8.872  31.229  36.422  1.00 18.98           C  
ATOM    918  CD1 TRP A 119      -9.359  30.037  35.942  1.00 20.03           C  
ATOM    919  CD2 TRP A 119      -8.947  32.159  35.336  1.00 18.94           C  
ATOM    920  NE1 TRP A 119      -9.715  30.173  34.614  1.00 20.25           N  
ATOM    921  CE2 TRP A 119      -9.472  31.463  34.220  1.00 19.01           C  
ATOM    922  CE3 TRP A 119      -8.614  33.512  35.191  1.00 18.34           C  
ATOM    923  CZ2 TRP A 119      -9.698  32.086  32.983  1.00 19.26           C  
ATOM    924  CZ3 TRP A 119      -8.817  34.127  33.951  1.00 19.43           C  
ATOM    925  CH2 TRP A 119      -9.355  33.410  32.867  1.00 19.70           C  
ATOM    926  N   SER A 120      -7.119  28.821  38.383  1.00 20.24           N  
ATOM    927  CA  SER A 120      -6.851  27.422  38.124  1.00 21.03           C  
ATOM    928  C   SER A 120      -8.133  26.651  37.949  1.00 21.09           C  
ATOM    929  O   SER A 120      -9.192  27.075  38.422  1.00 21.29           O  
ATOM    930  CB  SER A 120      -5.968  26.838  39.225  1.00 21.44           C  
ATOM    931  OG  SER A 120      -4.678  27.454  39.183  1.00 23.04           O  
ATOM    932  N   VAL A 121      -8.040  25.526  37.250  1.00 21.03           N  
ATOM    933  CA  VAL A 121      -9.192  24.675  37.012  1.00 21.03           C  
ATOM    934  C   VAL A 121      -8.766  23.214  37.111  1.00 21.25           C  
ATOM    935  O   VAL A 121      -7.643  22.839  36.723  1.00 21.01           O  
ATOM    936  CB  VAL A 121      -9.876  24.985  35.642  1.00 21.23           C  
ATOM    937  CG1 VAL A 121      -8.973  24.649  34.480  1.00 22.34           C  
ATOM    938  CG2 VAL A 121     -11.210  24.255  35.502  1.00 20.86           C  
ATOM    939  N   LEU A 122      -9.665  22.404  37.655  1.00 20.99           N  
ATOM    940  CA  LEU A 122      -9.457  20.966  37.749  1.00 21.34           C  
ATOM    941  C   LEU A 122      -9.540  20.372  36.360  1.00 21.65           C  
ATOM    942  O   LEU A 122     -10.404  20.753  35.564  1.00 21.80           O  
ATOM    943  CB  LEU A 122     -10.487  20.338  38.699  1.00 21.15           C  
ATOM    944  CG  LEU A 122     -10.225  20.721  40.164  1.00 20.61           C  
ATOM    945  CD1 LEU A 122     -11.456  20.505  41.052  1.00 20.81           C  
ATOM    946  CD2 LEU A 122      -9.021  19.941  40.707  1.00 21.26           C  
ATOM    947  N   ASP A 123      -8.624  19.459  36.055  1.00 22.00           N  
ATOM    948  CA  ASP A 123      -8.523  18.919  34.705  1.00 22.55           C  
ATOM    949  C   ASP A 123      -9.756  18.111  34.249  1.00 22.23           C  
ATOM    950  O   ASP A 123      -9.994  17.960  33.051  1.00 22.06           O  
ATOM    951  CB  ASP A 123      -7.182  18.187  34.485  1.00 23.35           C  
ATOM    952  CG  ASP A 123      -6.934  17.068  35.490  1.00 26.03           C  
ATOM    953  OD1 ASP A 123      -7.895  16.573  36.127  1.00 29.21           O  
ATOM    954  OD2 ASP A 123      -5.755  16.675  35.640  1.00 27.80           O  
ATOM    955  N   TRP A 124     -10.563  17.643  35.201  1.00 21.67           N  
ATOM    956  CA  TRP A 124     -11.797  16.897  34.886  1.00 21.15           C  
ATOM    957  C   TRP A 124     -13.032  17.787  34.667  1.00 20.88           C  
ATOM    958  O   TRP A 124     -14.070  17.318  34.198  1.00 20.33           O  
ATOM    959  CB  TRP A 124     -12.092  15.833  35.967  1.00 21.26           C  
ATOM    960  CG  TRP A 124     -12.241  16.391  37.375  1.00 20.88           C  
ATOM    961  CD1 TRP A 124     -11.289  16.401  38.362  1.00 21.45           C  
ATOM    962  CD2 TRP A 124     -13.409  17.021  37.941  1.00 21.31           C  
ATOM    963  NE1 TRP A 124     -11.791  16.996  39.499  1.00 20.19           N  
ATOM    964  CE2 TRP A 124     -13.085  17.385  39.269  1.00 21.39           C  
ATOM    965  CE3 TRP A 124     -14.694  17.312  37.452  1.00 21.42           C  
ATOM    966  CZ2 TRP A 124     -14.003  18.030  40.118  1.00 21.46           C  
ATOM    967  CZ3 TRP A 124     -15.608  17.955  38.300  1.00 22.03           C  
ATOM    968  CH2 TRP A 124     -15.253  18.304  39.618  1.00 20.63           C  
ATOM    969  N   ASN A 125     -12.911  19.068  35.003  1.00 20.77           N  
ATOM    970  CA  ASN A 125     -14.050  19.994  35.045  1.00 21.18           C  
ATOM    971  C   ASN A 125     -14.254  20.636  33.666  1.00 20.93           C  
ATOM    972  O   ASN A 125     -13.932  21.808  33.455  1.00 20.47           O  
ATOM    973  CB  ASN A 125     -13.789  21.046  36.139  1.00 20.88           C  
ATOM    974  CG  ASN A 125     -15.001  21.943  36.440  1.00 21.86           C  
ATOM    975  OD1 ASN A 125     -16.093  21.786  35.886  1.00 22.04           O  
ATOM    976  ND2 ASN A 125     -14.788  22.909  37.326  1.00 22.26           N  
ATOM    977  N   GLN A 126     -14.790  19.849  32.736  1.00 20.87           N  
ATOM    978  CA  GLN A 126     -14.875  20.264  31.334  1.00 21.41           C  
ATOM    979  C   GLN A 126     -15.763  21.500  31.120  1.00 22.12           C  
ATOM    980  O   GLN A 126     -15.434  22.334  30.274  1.00 21.19           O  
ATOM    981  CB  GLN A 126     -15.305  19.102  30.427  1.00 21.42           C  
ATOM    982  CG  GLN A 126     -15.021  19.313  28.921  1.00 21.33           C  
ATOM    983  CD  GLN A 126     -13.555  19.608  28.627  1.00 22.22           C  
ATOM    984  OE1 GLN A 126     -12.657  18.952  29.159  1.00 20.48           O  
ATOM    985  NE2 GLN A 126     -13.307  20.603  27.778  1.00 21.04           N  
ATOM    986  N   PRO A 127     -16.895  21.608  31.868  1.00 22.71           N  
ATOM    987  CA  PRO A 127     -17.722  22.819  31.794  1.00 22.95           C  
ATOM    988  C   PRO A 127     -16.953  24.106  32.112  1.00 22.65           C  
ATOM    989  O   PRO A 127     -17.121  25.102  31.415  1.00 22.92           O  
ATOM    990  CB  PRO A 127     -18.811  22.569  32.852  1.00 23.46           C  
ATOM    991  CG  PRO A 127     -18.902  21.074  32.960  1.00 23.19           C  
ATOM    992  CD  PRO A 127     -17.486  20.600  32.779  1.00 22.74           C  
ATOM    993  N   ALA A 128     -16.121  24.094  33.150  1.00 22.75           N  
ATOM    994  CA  ALA A 128     -15.285  25.260  33.464  1.00 21.85           C  
ATOM    995  C   ALA A 128     -14.247  25.489  32.350  1.00 21.58           C  
ATOM    996  O   ALA A 128     -14.090  26.603  31.866  1.00 21.89           O  
ATOM    997  CB  ALA A 128     -14.602  25.102  34.823  1.00 21.83           C  
ATOM    998  N   ILE A 129     -13.554  24.424  31.946  1.00 21.12           N  
ATOM    999  CA  ILE A 129     -12.573  24.492  30.848  1.00 21.04           C  
ATOM   1000  C   ILE A 129     -13.212  25.087  29.569  1.00 21.55           C  
ATOM   1001  O   ILE A 129     -12.654  26.004  28.956  1.00 21.12           O  
ATOM   1002  CB  ILE A 129     -11.953  23.113  30.553  1.00 21.02           C  
ATOM   1003  CG1 ILE A 129     -11.151  22.605  31.768  1.00 19.92           C  
ATOM   1004  CG2 ILE A 129     -11.037  23.173  29.286  1.00 20.33           C  
ATOM   1005  CD1 ILE A 129     -10.675  21.140  31.613  1.00 21.01           C  
ATOM   1006  N   ASP A 130     -14.383  24.573  29.191  1.00 21.73           N  
ATOM   1007  CA  ASP A 130     -15.125  25.098  28.039  1.00 22.61           C  
ATOM   1008  C   ASP A 130     -15.418  26.595  28.184  1.00 22.95           C  
ATOM   1009  O   ASP A 130     -15.256  27.357  27.229  1.00 23.19           O  
ATOM   1010  CB  ASP A 130     -16.428  24.326  27.820  1.00 22.45           C  
ATOM   1011  CG  ASP A 130     -16.200  22.923  27.268  1.00 24.08           C  
ATOM   1012  OD1 ASP A 130     -15.083  22.599  26.811  1.00 24.18           O  
ATOM   1013  OD2 ASP A 130     -17.158  22.126  27.298  1.00 26.42           O  
ATOM   1014  N   PHE A 131     -15.844  27.011  29.372  1.00 23.36           N  
ATOM   1015  CA  PHE A 131     -16.130  28.431  29.607  1.00 24.20           C  
ATOM   1016  C   PHE A 131     -14.877  29.299  29.490  1.00 23.96           C  
ATOM   1017  O   PHE A 131     -14.895  30.321  28.803  1.00 24.15           O  
ATOM   1018  CB  PHE A 131     -16.831  28.676  30.946  1.00 24.68           C  
ATOM   1019  CG  PHE A 131     -16.916  30.140  31.317  1.00 26.65           C  
ATOM   1020  CD1 PHE A 131     -17.645  31.033  30.528  1.00 28.20           C  
ATOM   1021  CD2 PHE A 131     -16.257  30.624  32.439  1.00 28.07           C  
ATOM   1022  CE1 PHE A 131     -17.710  32.390  30.855  1.00 29.03           C  
ATOM   1023  CE2 PHE A 131     -16.325  31.981  32.785  1.00 28.75           C  
ATOM   1024  CZ  PHE A 131     -17.050  32.863  31.989  1.00 28.04           C  
ATOM   1025  N   TYR A 132     -13.798  28.888  30.152  1.00 23.67           N  
ATOM   1026  CA  TYR A 132     -12.540  29.628  30.102  1.00 23.87           C  
ATOM   1027  C   TYR A 132     -11.974  29.721  28.690  1.00 23.52           C  
ATOM   1028  O   TYR A 132     -11.492  30.776  28.285  1.00 23.32           O  
ATOM   1029  CB  TYR A 132     -11.513  29.022  31.056  1.00 24.35           C  
ATOM   1030  CG  TYR A 132     -11.966  28.993  32.504  1.00 26.61           C  
ATOM   1031  CD1 TYR A 132     -12.632  30.083  33.069  1.00 27.60           C  
ATOM   1032  CD2 TYR A 132     -11.714  27.879  33.314  1.00 27.36           C  
ATOM   1033  CE1 TYR A 132     -13.049  30.059  34.399  1.00 27.81           C  
ATOM   1034  CE2 TYR A 132     -12.119  27.848  34.651  1.00 27.80           C  
ATOM   1035  CZ  TYR A 132     -12.788  28.940  35.178  1.00 27.56           C  
ATOM   1036  OH  TYR A 132     -13.187  28.932  36.496  1.00 29.41           O  
ATOM   1037  N   ARG A 133     -12.044  28.623  27.943  1.00 23.11           N  
ATOM   1038  CA  ARG A 133     -11.634  28.638  26.539  1.00 23.15           C  
ATOM   1039  C   ARG A 133     -12.432  29.679  25.751  1.00 23.77           C  
ATOM   1040  O   ARG A 133     -11.874  30.397  24.918  1.00 23.80           O  
ATOM   1041  CB  ARG A 133     -11.823  27.256  25.909  1.00 22.96           C  
ATOM   1042  CG  ARG A 133     -10.766  26.257  26.300  1.00 21.64           C  
ATOM   1043  CD  ARG A 133     -11.180  24.863  25.872  1.00 19.55           C  
ATOM   1044  NE  ARG A 133     -10.096  23.910  26.084  1.00 18.49           N  
ATOM   1045  CZ  ARG A 133     -10.197  22.604  25.862  1.00 18.57           C  
ATOM   1046  NH1 ARG A 133     -11.341  22.085  25.425  1.00 17.62           N  
ATOM   1047  NH2 ARG A 133      -9.152  21.823  26.079  1.00 18.66           N  
ATOM   1048  N   SER A 134     -13.729  29.771  26.045  1.00 24.22           N  
ATOM   1049  CA  SER A 134     -14.632  30.640  25.292  1.00 24.98           C  
ATOM   1050  C   SER A 134     -14.377  32.138  25.515  1.00 25.74           C  
ATOM   1051  O   SER A 134     -14.840  32.964  24.727  1.00 26.53           O  
ATOM   1052  CB  SER A 134     -16.091  30.297  25.595  1.00 24.60           C  
ATOM   1053  OG  SER A 134     -16.480  30.826  26.845  1.00 24.40           O  
ATOM   1054  N   ILE A 135     -13.649  32.484  26.575  1.00 25.68           N  
ATOM   1055  CA  ILE A 135     -13.318  33.888  26.839  1.00 25.86           C  
ATOM   1056  C   ILE A 135     -11.879  34.252  26.452  1.00 25.59           C  
ATOM   1057  O   ILE A 135     -11.409  35.341  26.771  1.00 26.62           O  
ATOM   1058  CB  ILE A 135     -13.593  34.296  28.313  1.00 25.97           C  
ATOM   1059  CG1 ILE A 135     -12.781  33.423  29.276  1.00 26.92           C  
ATOM   1060  CG2 ILE A 135     -15.093  34.253  28.600  1.00 25.95           C  
ATOM   1061  CD1 ILE A 135     -12.325  34.116  30.541  1.00 28.69           C  
ATOM   1062  N   GLY A 136     -11.188  33.348  25.766  1.00 24.80           N  
ATOM   1063  CA  GLY A 136      -9.838  33.624  25.271  1.00 24.10           C  
ATOM   1064  C   GLY A 136      -8.708  33.318  26.242  1.00 22.99           C  
ATOM   1065  O   GLY A 136      -7.556  33.691  25.990  1.00 23.15           O  
ATOM   1066  N   ALA A 137      -9.020  32.648  27.355  1.00 21.83           N  
ATOM   1067  CA  ALA A 137      -7.981  32.256  28.314  1.00 20.69           C  
ATOM   1068  C   ALA A 137      -7.171  31.063  27.807  1.00 20.14           C  
ATOM   1069  O   ALA A 137      -7.692  30.204  27.096  1.00 19.44           O  
ATOM   1070  CB  ALA A 137      -8.578  31.967  29.694  1.00 20.12           C  
ATOM   1071  N   LEU A 138      -5.902  31.023  28.192  1.00 19.59           N  
ATOM   1072  CA  LEU A 138      -4.965  30.035  27.677  1.00 19.85           C  
ATOM   1073  C   LEU A 138      -4.319  29.276  28.816  1.00 19.75           C  
ATOM   1074  O   LEU A 138      -3.962  29.890  29.813  1.00 19.88           O  
ATOM   1075  CB  LEU A 138      -3.882  30.726  26.838  1.00 19.71           C  
ATOM   1076  CG  LEU A 138      -4.307  31.425  25.552  1.00 19.01           C  
ATOM   1077  CD1 LEU A 138      -3.091  32.114  24.935  1.00 20.33           C  
ATOM   1078  CD2 LEU A 138      -4.902  30.436  24.570  1.00 19.81           C  
ATOM   1079  N   PRO A 139      -4.156  27.941  28.660  1.00 19.93           N  
ATOM   1080  CA  PRO A 139      -3.603  27.088  29.696  1.00 20.25           C  
ATOM   1081  C   PRO A 139      -2.086  27.221  29.788  1.00 21.36           C  
ATOM   1082  O   PRO A 139      -1.388  27.248  28.770  1.00 20.52           O  
ATOM   1083  CB  PRO A 139      -3.996  25.680  29.250  1.00 19.40           C  
ATOM   1084  CG  PRO A 139      -4.038  25.764  27.769  1.00 19.44           C  
ATOM   1085  CD  PRO A 139      -4.514  27.168  27.452  1.00 19.60           C  
ATOM   1086  N   GLN A 140      -1.603  27.330  31.019  1.00 22.06           N  
ATOM   1087  CA  GLN A 140      -0.178  27.428  31.306  1.00 23.49           C  
ATOM   1088  C   GLN A 140       0.264  26.055  31.758  1.00 24.70           C  
ATOM   1089  O   GLN A 140       0.630  25.844  32.927  1.00 25.09           O  
ATOM   1090  CB  GLN A 140       0.066  28.485  32.396  1.00 23.07           C  
ATOM   1091  CG  GLN A 140      -0.560  29.831  32.097  1.00 22.71           C  
ATOM   1092  CD  GLN A 140      -0.173  30.365  30.727  1.00 23.99           C  
ATOM   1093  OE1 GLN A 140      -1.026  30.550  29.850  1.00 25.17           O  
ATOM   1094  NE2 GLN A 140       1.118  30.604  30.530  1.00 22.42           N  
ATOM   1095  N   ASP A 141       0.204  25.101  30.834  1.00 26.75           N  
ATOM   1096  CA  ASP A 141       0.312  23.698  31.226  1.00 28.71           C  
ATOM   1097  C   ASP A 141       1.720  23.094  31.248  1.00 28.78           C  
ATOM   1098  O   ASP A 141       1.876  21.896  31.460  1.00 28.72           O  
ATOM   1099  CB  ASP A 141      -0.693  22.802  30.483  1.00 30.12           C  
ATOM   1100  CG  ASP A 141      -0.580  22.888  28.977  1.00 32.99           C  
ATOM   1101  OD1 ASP A 141       0.305  23.596  28.452  1.00 36.13           O  
ATOM   1102  OD2 ASP A 141      -1.414  22.230  28.309  1.00 39.23           O  
ATOM   1103  N   GLU A 142       2.739  23.928  31.083  1.00 28.60           N  
ATOM   1104  CA  GLU A 142       4.113  23.463  31.275  1.00 29.26           C  
ATOM   1105  C   GLU A 142       4.525  23.460  32.753  1.00 28.83           C  
ATOM   1106  O   GLU A 142       5.512  22.835  33.122  1.00 29.05           O  
ATOM   1107  CB  GLU A 142       5.088  24.309  30.463  1.00 29.65           C  
ATOM   1108  CG  GLU A 142       4.995  24.063  28.965  1.00 32.58           C  
ATOM   1109  CD  GLU A 142       6.295  24.389  28.257  1.00 36.43           C  
ATOM   1110  OE1 GLU A 142       6.817  23.495  27.562  1.00 38.59           O  
ATOM   1111  OE2 GLU A 142       6.794  25.529  28.411  1.00 37.35           O  
ATOM   1112  N   TRP A 143       3.754  24.149  33.589  1.00 28.49           N  
ATOM   1113  CA  TRP A 143       4.081  24.314  35.007  1.00 28.16           C  
ATOM   1114  C   TRP A 143       3.309  23.337  35.873  1.00 27.89           C  
ATOM   1115  O   TRP A 143       2.156  23.018  35.579  1.00 28.33           O  
ATOM   1116  CB  TRP A 143       3.759  25.740  35.463  1.00 28.28           C  
ATOM   1117  CG  TRP A 143       4.584  26.810  34.781  1.00 28.76           C  
ATOM   1118  CD1 TRP A 143       4.260  27.497  33.638  1.00 29.89           C  
ATOM   1119  CD2 TRP A 143       5.864  27.306  35.198  1.00 28.66           C  
ATOM   1120  NE1 TRP A 143       5.264  28.391  33.320  1.00 30.58           N  
ATOM   1121  CE2 TRP A 143       6.255  28.301  34.263  1.00 29.48           C  
ATOM   1122  CE3 TRP A 143       6.714  27.019  36.276  1.00 28.55           C  
ATOM   1123  CZ2 TRP A 143       7.466  28.998  34.368  1.00 28.67           C  
ATOM   1124  CZ3 TRP A 143       7.928  27.719  36.381  1.00 29.06           C  
ATOM   1125  CH2 TRP A 143       8.287  28.693  35.429  1.00 29.02           C  
ATOM   1126  N   VAL A 144       3.945  22.881  36.948  1.00 27.03           N  
ATOM   1127  CA  VAL A 144       3.269  22.107  37.988  1.00 26.25           C  
ATOM   1128  C   VAL A 144       3.363  22.890  39.299  1.00 25.13           C  
ATOM   1129  O   VAL A 144       4.454  23.273  39.697  1.00 24.23           O  
ATOM   1130  CB  VAL A 144       3.938  20.717  38.164  1.00 25.80           C  
ATOM   1131  CG1 VAL A 144       3.261  19.928  39.270  1.00 26.09           C  
ATOM   1132  CG2 VAL A 144       3.886  19.929  36.856  1.00 27.77           C  
ATOM   1133  N   ARG A 145       2.232  23.122  39.966  1.00 24.27           N  
ATOM   1134  CA  ARG A 145       2.235  23.802  41.264  1.00 24.08           C  
ATOM   1135  C   ARG A 145       2.679  22.827  42.348  1.00 22.48           C  
ATOM   1136  O   ARG A 145       2.139  21.730  42.439  1.00 21.76           O  
ATOM   1137  CB  ARG A 145       0.837  24.343  41.591  1.00 24.03           C  
ATOM   1138  CG  ARG A 145       0.685  25.038  42.962  1.00 26.76           C  
ATOM   1139  CD  ARG A 145      -0.705  25.709  43.139  1.00 27.81           C  
ATOM   1140  NE  ARG A 145      -1.271  26.055  41.837  1.00 36.96           N  
ATOM   1141  CZ  ARG A 145      -2.233  25.365  41.215  1.00 39.89           C  
ATOM   1142  NH1 ARG A 145      -2.780  24.302  41.808  1.00 39.64           N  
ATOM   1143  NH2 ARG A 145      -2.660  25.751  39.997  1.00 38.77           N  
ATOM   1144  N   TYR A 146       3.666  23.221  43.149  1.00 21.39           N  
ATOM   1145  CA  TYR A 146       4.078  22.415  44.315  1.00 21.29           C  
ATOM   1146  C   TYR A 146       3.654  23.086  45.604  1.00 20.82           C  
ATOM   1147  O   TYR A 146       3.525  24.299  45.666  1.00 20.64           O  
ATOM   1148  CB  TYR A 146       5.585  22.138  44.316  1.00 20.49           C  
ATOM   1149  CG  TYR A 146       5.924  20.844  43.623  1.00 21.65           C  
ATOM   1150  CD1 TYR A 146       5.894  20.749  42.225  1.00 20.39           C  
ATOM   1151  CD2 TYR A 146       6.241  19.698  44.361  1.00 20.56           C  
ATOM   1152  CE1 TYR A 146       6.190  19.547  41.582  1.00 21.83           C  
ATOM   1153  CE2 TYR A 146       6.538  18.492  43.731  1.00 20.13           C  
ATOM   1154  CZ  TYR A 146       6.512  18.426  42.348  1.00 21.59           C  
ATOM   1155  OH  TYR A 146       6.796  17.246  41.725  1.00 22.28           O  
ATOM   1156  N   ARG A 147       3.453  22.287  46.637  1.00 21.14           N  
ATOM   1157  CA  ARG A 147       2.905  22.784  47.890  1.00 21.20           C  
ATOM   1158  C   ARG A 147       3.538  22.093  49.085  1.00 21.15           C  
ATOM   1159  O   ARG A 147       3.693  20.880  49.102  1.00 20.72           O  
ATOM   1160  CB  ARG A 147       1.387  22.560  47.918  1.00 21.29           C  
ATOM   1161  CG  ARG A 147       0.716  22.834  49.256  1.00 20.49           C  
ATOM   1162  CD  ARG A 147      -0.757  22.406  49.253  1.00 22.15           C  
ATOM   1163  NE  ARG A 147      -1.542  23.206  48.317  1.00 23.27           N  
ATOM   1164  CZ  ARG A 147      -2.843  23.037  48.073  1.00 24.52           C  
ATOM   1165  NH1 ARG A 147      -3.448  23.826  47.192  1.00 24.84           N  
ATOM   1166  NH2 ARG A 147      -3.534  22.083  48.692  1.00 22.78           N  
ATOM   1167  N   LEU A 148       3.907  22.877  50.088  1.00 21.80           N  
ATOM   1168  CA  LEU A 148       4.114  22.306  51.408  1.00 23.21           C  
ATOM   1169  C   LEU A 148       3.097  22.876  52.378  1.00 23.07           C  
ATOM   1170  O   LEU A 148       2.796  24.083  52.371  1.00 22.66           O  
ATOM   1171  CB  LEU A 148       5.560  22.431  51.922  1.00 24.06           C  
ATOM   1172  CG  LEU A 148       6.555  23.453  51.430  1.00 26.73           C  
ATOM   1173  CD1 LEU A 148       5.975  24.761  51.841  1.00 30.90           C  
ATOM   1174  CD2 LEU A 148       7.933  23.270  52.065  1.00 25.45           C  
ATOM   1175  N   ASP A 149       2.532  21.979  53.167  1.00 23.00           N  
ATOM   1176  CA  ASP A 149       1.568  22.332  54.191  1.00 23.30           C  
ATOM   1177  C   ASP A 149       1.684  21.265  55.273  1.00 23.77           C  
ATOM   1178  O   ASP A 149       2.514  20.342  55.153  1.00 23.11           O  
ATOM   1179  CB  ASP A 149       0.139  22.446  53.599  1.00 23.32           C  
ATOM   1180  CG  ASP A 149      -0.388  21.129  53.040  1.00 24.48           C  
ATOM   1181  OD1 ASP A 149       0.299  20.099  53.177  1.00 25.03           O  
ATOM   1182  OD2 ASP A 149      -1.508  21.121  52.463  1.00 26.31           O  
ATOM   1183  N   GLY A 150       0.885  21.406  56.330  1.00 24.15           N  
ATOM   1184  CA  GLY A 150       0.880  20.451  57.437  1.00 24.82           C  
ATOM   1185  C   GLY A 150       2.252  20.265  58.052  1.00 25.19           C  
ATOM   1186  O   GLY A 150       3.002  21.234  58.226  1.00 25.17           O  
ATOM   1187  N   GLU A 151       2.580  19.012  58.358  1.00 25.37           N  
ATOM   1188  CA  GLU A 151       3.840  18.663  59.023  1.00 26.04           C  
ATOM   1189  C   GLU A 151       5.062  18.998  58.181  1.00 25.22           C  
ATOM   1190  O   GLU A 151       6.064  19.464  58.714  1.00 25.33           O  
ATOM   1191  CB  GLU A 151       3.872  17.183  59.403  1.00 26.18           C  
ATOM   1192  CG  GLU A 151       3.166  16.871  60.707  1.00 30.14           C  
ATOM   1193  CD  GLU A 151       3.859  17.490  61.913  1.00 33.96           C  
ATOM   1194  OE1 GLU A 151       4.854  16.899  62.391  1.00 35.86           O  
ATOM   1195  OE2 GLU A 151       3.399  18.562  62.384  1.00 35.53           O  
ATOM   1196  N   ALA A 152       4.978  18.754  56.876  1.00 24.72           N  
ATOM   1197  CA  ALA A 152       6.100  19.011  55.988  1.00 24.07           C  
ATOM   1198  C   ALA A 152       6.487  20.489  56.028  1.00 24.06           C  
ATOM   1199  O   ALA A 152       7.672  20.817  56.029  1.00 24.28           O  
ATOM   1200  CB  ALA A 152       5.777  18.570  54.576  1.00 24.32           C  
ATOM   1201  N   LEU A 153       5.487  21.371  56.068  1.00 23.78           N  
ATOM   1202  CA  LEU A 153       5.735  22.808  56.181  1.00 23.83           C  
ATOM   1203  C   LEU A 153       6.384  23.152  57.525  1.00 24.37           C  
ATOM   1204  O   LEU A 153       7.386  23.857  57.565  1.00 23.57           O  
ATOM   1205  CB  LEU A 153       4.447  23.617  55.992  1.00 23.60           C  
ATOM   1206  CG  LEU A 153       4.574  25.151  56.132  1.00 23.40           C  
ATOM   1207  CD1 LEU A 153       5.517  25.737  55.070  1.00 23.40           C  
ATOM   1208  CD2 LEU A 153       3.211  25.838  56.067  1.00 23.62           C  
ATOM   1209  N   ARG A 154       5.803  22.648  58.615  1.00 25.08           N  
ATOM   1210  CA  ARG A 154       6.306  22.926  59.959  1.00 26.65           C  
ATOM   1211  C   ARG A 154       7.759  22.438  60.107  1.00 26.92           C  
ATOM   1212  O   ARG A 154       8.612  23.135  60.659  1.00 26.58           O  
ATOM   1213  CB  ARG A 154       5.393  22.280  61.013  1.00 26.41           C  
ATOM   1214  CG  ARG A 154       5.714  22.671  62.455  1.00 28.15           C  
ATOM   1215  CD  ARG A 154       4.944  21.815  63.495  1.00 28.82           C  
ATOM   1216  NE  ARG A 154       5.236  20.377  63.389  1.00 33.16           N  
ATOM   1217  CZ  ARG A 154       6.384  19.807  63.757  1.00 33.91           C  
ATOM   1218  NH1 ARG A 154       7.369  20.539  64.256  1.00 34.49           N  
ATOM   1219  NH2 ARG A 154       6.550  18.498  63.622  1.00 35.01           N  
ATOM   1220  N   LYS A 155       8.036  21.245  59.595  1.00 27.70           N  
ATOM   1221  CA  LYS A 155       9.372  20.663  59.686  1.00 28.44           C  
ATOM   1222  C   LYS A 155      10.415  21.409  58.847  1.00 29.11           C  
ATOM   1223  O   LYS A 155      11.566  21.528  59.276  1.00 29.17           O  
ATOM   1224  CB  LYS A 155       9.345  19.184  59.309  1.00 28.35           C  
ATOM   1225  CG  LYS A 155       8.798  18.268  60.387  1.00 28.35           C  
ATOM   1226  CD  LYS A 155       8.798  16.842  59.874  1.00 30.01           C  
ATOM   1227  CE  LYS A 155       7.725  16.013  60.536  1.00 31.46           C  
ATOM   1228  NZ  LYS A 155       8.272  15.219  61.650  1.00 31.28           N  
ATOM   1229  N   MET A 156      10.013  21.903  57.673  1.00 30.02           N  
ATOM   1230  CA  MET A 156      10.874  22.730  56.807  1.00 30.68           C  
ATOM   1231  C   MET A 156      11.256  24.030  57.521  1.00 31.50           C  
ATOM   1232  O   MET A 156      12.423  24.423  57.502  1.00 31.51           O  
ATOM   1233  CB  MET A 156      10.195  23.032  55.452  1.00 30.96           C  
ATOM   1234  CG  MET A 156      11.045  23.855  54.416  1.00 30.71           C  
ATOM   1235  SD  MET A 156      12.356  22.893  53.625  1.00 32.67           S  
ATOM   1236  CE  MET A 156      13.405  24.164  52.928  1.00 32.74           C  
ATOM   1237  N   ALA A 157      10.271  24.685  58.142  1.00 31.97           N  
ATOM   1238  CA  ALA A 157      10.497  25.907  58.925  1.00 32.85           C  
ATOM   1239  C   ALA A 157      11.533  25.669  60.034  1.00 34.04           C  
ATOM   1240  O   ALA A 157      12.510  26.409  60.159  1.00 34.15           O  
ATOM   1241  CB  ALA A 157       9.191  26.411  59.511  1.00 32.29           C  
ATOM   1242  N   GLU A 158      11.313  24.628  60.826  1.00 35.23           N  
ATOM   1243  CA  GLU A 158      12.318  24.156  61.768  1.00 36.84           C  
ATOM   1244  C   GLU A 158      13.445  23.463  60.996  1.00 36.84           C  
ATOM   1245  O   GLU A 158      14.469  23.083  61.568  1.00 37.82           O  
ATOM   1246  CB  GLU A 158      11.690  23.178  62.758  1.00 36.86           C  
ATOM   1247  CG  GLU A 158      10.398  23.656  63.400  1.00 37.56           C  
ATOM   1248  CD  GLU A 158       9.701  22.558  64.191  1.00 38.69           C  
ATOM   1249  OE1 GLU A 158      10.228  21.418  64.241  1.00 41.43           O  
ATOM   1250  OE2 GLU A 158       8.618  22.833  64.765  1.00 41.00           O  
TER    1251      GLU A 158                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
