
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  163 ( 1284),  selected  163 , name 1yr0_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 1yr0_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     4_A      A       2          2.324
LGA    V     5_A      I       3          1.303
LGA    E     6_A      N       4          1.370
LGA    L     7_A      I       5          1.026
LGA    R     8_A      I       6          1.812
LGA    D     9_A      E       7          1.370
LGA    A    10_A      Y       8          1.629
LGA    T    11_A      N       9          1.482
LGA    V    12_A      R      10          1.630
LGA    D    13_A      S      11          2.194
LGA    D    14_A      Y      12          2.402
LGA    L    15_A      K      13          2.292
LGA    S    16_A      E      14          2.737
LGA    G    17_A      E      15          2.291
LGA    I    18_A      L      16          1.231
LGA    X    19_A      I      17          1.557
LGA    E    20_A      E      18          1.610
LGA    I    21_A      F      19          1.242
LGA    Y    22_A      I      20          1.838
LGA    N    23_A      L      21          1.878
LGA    D    24_A      S      22          1.215
LGA    A    25_A      I      23          3.156
LGA    V    26_A      Q      24          3.667
LGA    V    27_A      K      25          1.720
LGA    N    28_A      N      26          2.886
LGA    -       -      E      27           -
LGA    T    29_A      F      28          2.666
LGA    T    30_A      N      29           #
LGA    A    31_A      I      30           #
LGA    I    32_A      -       -           -
LGA    W    33_A      -       -           -
LGA    N    34_A      K      31           #
LGA    E    35_A      I      32          2.782
LGA    V    36_A      D      33          1.851
LGA    V    37_A      R      34          2.628
LGA    V    38_A      D      35           #
LGA    D    39_A      D      36           -
LGA    L    40_A      Q      37           -
LGA    E    41_A      P      38           -
LGA    N    42_A      D      39           #
LGA    R    43_A      L      40          3.922
LGA    K    44_A      E      41          4.936
LGA    D    45_A      N      42          2.019
LGA    W    46_A      I      43          2.891
LGA    F    47_A      E      44          2.471
LGA    A    48_A      H      45          2.697
LGA    A    49_A      N      46          2.872
LGA    R    50_A      Y      47          1.753
LGA    T    51_A      L      48          1.895
LGA    S    52_A      N      49          1.146
LGA    R    53_A      S      50          0.787
LGA    G    54_A      G      51          2.044
LGA    F    55_A      G      52          0.964
LGA    P    56_A      Q      53          1.022
LGA    V    57_A      F      54          0.927
LGA    I    58_A      W      55          0.512
LGA    V    59_A      L      56          0.531
LGA    A    60_A      A      57          0.329
LGA    I    61_A      I      58          0.922
LGA    L    62_A      N      59          1.123
LGA    D    63_A      N      60          2.772
LGA    G    64_A      H      61          1.581
LGA    K    65_A      Q      62          3.053
LGA    -       -      N      63           -
LGA    V    66_A      I      64          1.088
LGA    A    67_A      V      65          0.617
LGA    G    68_A      G      66          0.972
LGA    Y    69_A      T      67          1.137
LGA    A    70_A      I      68          0.719
LGA    S    71_A      G      69          0.801
LGA    Y    72_A      L      70          1.012
LGA    G    73_A      I      71          1.079
LGA    D    74_A      R      72          4.700
LGA    W    75_A      L      73          5.436
LGA    R    76_A      -       -           -
LGA    A    77_A      -       -           -
LGA    F    78_A      -       -           -
LGA    D    79_A      -       -           -
LGA    G    80_A      -       -           -
LGA    Y    81_A      D      74          3.014
LGA    R    82_A      N      75          3.298
LGA    H    83_A      N      76          0.985
LGA    T    84_A      M      77          1.131
LGA    R    85_A      S      78          0.937
LGA    E    86_A      A      79          0.985
LGA    H    87_A      L      80          0.435
LGA    S    88_A      K      81          2.225
LGA    -       -      K      82           -
LGA    V    89_A      M      83          1.055
LGA    Y    90_A      F      84          1.303
LGA    V    91_A      V      85          1.111
LGA    H    92_A      D      86          2.148
LGA    K    93_A      K      87          2.953
LGA    D    94_A      G      88          3.134
LGA    A    95_A      Y      89          2.411
LGA    R    96_A      R      90          2.125
LGA    G    97_A      N      91          1.913
LGA    H    98_A      L      92          1.743
LGA    G    99_A      K      93          1.438
LGA    I   100_A      I      94          1.067
LGA    G   101_A      G      95          1.149
LGA    K   102_A      K      96          1.362
LGA    R   103_A      K      97          1.022
LGA    L   104_A      L      98          0.736
LGA    X   105_A      L      99          1.159
LGA    Q   106_A      D     100          1.354
LGA    A   107_A      K     101          1.011
LGA    L   108_A      V     102          1.066
LGA    I   109_A      I     103          1.123
LGA    D   110_A      M     104          1.131
LGA    H   111_A      T     105          1.076
LGA    A   112_A      C     106          1.156
LGA    G   113_A      K     107          1.244
LGA    G   114_A      E     108          1.251
LGA    N   115_A      Q     109          1.501
LGA    D   116_A      N     110          2.409
LGA    V   117_A      I     111          1.102
LGA    H   118_A      D     112          0.639
LGA    V   119_A      G     113          0.990
LGA    L   120_A      I     114          0.233
LGA    I   121_A      Y     115          0.812
LGA    A   122_A      L     116          1.915
LGA    A   123_A      G     117          1.222
LGA    I   124_A      T     118          1.981
LGA    E   125_A      I     119          1.103
LGA    A   126_A      D     120          2.656
LGA    E   127_A      K     121          4.433
LGA    N   128_A      F     122          2.964
LGA    T   129_A      I     123          3.353
LGA    A   130_A      S     124          1.270
LGA    S   131_A      A     125          0.982
LGA    I   132_A      Q     126          1.766
LGA    R   133_A      Y     127          1.550
LGA    L   134_A      F     128          1.181
LGA    H   135_A      Y     129          1.369
LGA    E   136_A      S     130          2.071
LGA    S   137_A      N     131          2.144
LGA    L   138_A      N     132          1.647
LGA    G   139_A      G     133          1.147
LGA    F   140_A      F     134          1.170
LGA    R   141_A      R     135          1.322
LGA    V   142_A      E     136          1.609
LGA    V   143_A      I     137          1.853
LGA    G   144_A      K     138          3.411
LGA    R   145_A      -       -           -
LGA    F   146_A      R     139          5.147
LGA    S   147_A      G     140           -
LGA    E   148_A      D     141           -
LGA    V   149_A      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    -       -      K     148           -
LGA    -       -      L     149           -
LGA    G   150_A      D     150          4.594
LGA    T   151_A      V     151          5.367
LGA    K   152_A      -       -           -
LGA    F   153_A      -       -           -
LGA    G   154_A      -       -           -
LGA    R   155_A      -       -           -
LGA    W   156_A      -       -           -
LGA    L   157_A      -       -           -
LGA    D   158_A      D     152           #
LGA    L   159_A      N     153          1.627
LGA    T   160_A      R     154          1.824
LGA    C   161_A      F     155          1.197
LGA    X   162_A      Y     156          1.136
LGA    E   163_A      Y     157          0.845
LGA    L   164_A      R     158          0.817
LGA    K   165_A      N     159          0.873
LGA    L   166_A      L     160          0.961
LGA    -       -      K     161           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  163  160    5.0    137    2.08    13.14     68.175     6.275

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.435584 * X  +  -0.830812 * Y  +  -0.346436 * Z  +  50.929962
  Y_new =  -0.580525 * X  +   0.553412 * Y  +  -0.597265 * Z  +  30.940905
  Z_new =   0.687937 * X  +  -0.059044 * Y  +  -0.723365 * Z  +  40.348709 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.060149    0.081444  [ DEG:  -175.3336      4.6664 ]
  Theta =  -0.758642   -2.382951  [ DEG:   -43.4670   -136.5330 ]
  Phi   =  -2.214507    0.927085  [ DEG:  -126.8819     53.1181 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yr0_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yr0_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  163  160   5.0  137   2.08   13.14  68.175
REMARK  ---------------------------------------------------------- 
MOLECULE 1yr0_A
HEADER    TRANSFERASE                             02-FEB-05   1YR0              
TITLE     CRYSTAL STRUCTURE OF PHOSPHINOTHRICIN ACETYLTRANSFERASE               
TITLE    2 FROM AGROBACTERIUM TUMEFACIENS                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHINOTHRICIN ACETYLTRANSFERASE;                        
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: AGR_C_1654P;                                                
COMPND   5 EC: 2.3.1.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C58;                                                         
SOURCE   5 GENE: AGR_C_1654;                                                    
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: B834 DE3;                                  
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET T7                                    
KEYWDS    STRUCTURAL GENOMICS, PROTEIN STRUCTURE INITIATIVE, NYSGXRC,           
KEYWDS   2 T1682, AGR_C_1654, PHOSPHINOTHRICIN ACETYLTRANSFERASE, PSI,          
KEYWDS   3 NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.K.BURLEY,NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM            
AUTHOR   2 (NYSGXRC)                                                            
REVDAT   1   15-FEB-05 1YR0    0                                                
JRNL        AUTH   K.R.RAJASHANKAR,R.KNIEWEL,K.LEE,C.D.LIMA                     
JRNL        TITL   CRYSTAL STRUCTURE OF PHOSPHINOTHRICIN                        
JRNL        TITL 2 ACETYLTRANSFERASE FROM AGROBACTERIUM TUMEFACIENS             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1YR0 A    1   167  UNP    Q8UGX8   Q8UGX8_AGRT5     1    165             
DBREF  1YR0 B    1   167  UNP    Q8UGX8   Q8UGX8_AGRT5     1    165             
DBREF  1YR0 C    1   167  UNP    Q8UGX8   Q8UGX8_AGRT5     1    165             
DBREF  1YR0 D    1   167  UNP    Q8UGX8   Q8UGX8_AGRT5     1    165             
SEQRES   1 A  175  MSE SER LEU SER VAL GLU LEU ARG ASP ALA THR VAL ASP          
SEQRES   2 A  175  ASP LEU SER GLY ILE MSE GLU ILE TYR ASN ASP ALA VAL          
SEQRES   3 A  175  VAL ASN THR THR ALA ILE TRP ASN GLU VAL VAL VAL ASP          
SEQRES   4 A  175  LEU GLU ASN ARG LYS ASP TRP PHE ALA ALA ARG THR SER          
SEQRES   5 A  175  ARG GLY PHE PRO VAL ILE VAL ALA ILE LEU ASP GLY LYS          
SEQRES   6 A  175  VAL ALA GLY TYR ALA SER TYR GLY ASP TRP ARG ALA PHE          
SEQRES   7 A  175  ASP GLY TYR ARG HIS THR ARG GLU HIS SER VAL TYR VAL          
SEQRES   8 A  175  HIS LYS ASP ALA ARG GLY HIS GLY ILE GLY LYS ARG LEU          
SEQRES   9 A  175  MSE GLN ALA LEU ILE ASP HIS ALA GLY GLY ASN ASP VAL          
SEQRES  10 A  175  HIS VAL LEU ILE ALA ALA ILE GLU ALA GLU ASN THR ALA          
SEQRES  11 A  175  SER ILE ARG LEU HIS GLU SER LEU GLY PHE ARG VAL VAL          
SEQRES  12 A  175  GLY ARG PHE SER GLU VAL GLY THR LYS PHE GLY ARG TRP          
SEQRES  13 A  175  LEU ASP LEU THR CYS MSE GLU LEU LYS LEU GLY GLU GLY          
SEQRES  14 A  175  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 B  175  MSE SER LEU SER VAL GLU LEU ARG ASP ALA THR VAL ASP          
SEQRES   2 B  175  ASP LEU SER GLY ILE MSE GLU ILE TYR ASN ASP ALA VAL          
SEQRES   3 B  175  VAL ASN THR THR ALA ILE TRP ASN GLU VAL VAL VAL ASP          
SEQRES   4 B  175  LEU GLU ASN ARG LYS ASP TRP PHE ALA ALA ARG THR SER          
SEQRES   5 B  175  ARG GLY PHE PRO VAL ILE VAL ALA ILE LEU ASP GLY LYS          
SEQRES   6 B  175  VAL ALA GLY TYR ALA SER TYR GLY ASP TRP ARG ALA PHE          
SEQRES   7 B  175  ASP GLY TYR ARG HIS THR ARG GLU HIS SER VAL TYR VAL          
SEQRES   8 B  175  HIS LYS ASP ALA ARG GLY HIS GLY ILE GLY LYS ARG LEU          
SEQRES   9 B  175  MSE GLN ALA LEU ILE ASP HIS ALA GLY GLY ASN ASP VAL          
SEQRES  10 B  175  HIS VAL LEU ILE ALA ALA ILE GLU ALA GLU ASN THR ALA          
SEQRES  11 B  175  SER ILE ARG LEU HIS GLU SER LEU GLY PHE ARG VAL VAL          
SEQRES  12 B  175  GLY ARG PHE SER GLU VAL GLY THR LYS PHE GLY ARG TRP          
SEQRES  13 B  175  LEU ASP LEU THR CYS MSE GLU LEU LYS LEU GLY GLU GLY          
SEQRES  14 B  175  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 C  175  MSE SER LEU SER VAL GLU LEU ARG ASP ALA THR VAL ASP          
SEQRES   2 C  175  ASP LEU SER GLY ILE MSE GLU ILE TYR ASN ASP ALA VAL          
SEQRES   3 C  175  VAL ASN THR THR ALA ILE TRP ASN GLU VAL VAL VAL ASP          
SEQRES   4 C  175  LEU GLU ASN ARG LYS ASP TRP PHE ALA ALA ARG THR SER          
SEQRES   5 C  175  ARG GLY PHE PRO VAL ILE VAL ALA ILE LEU ASP GLY LYS          
SEQRES   6 C  175  VAL ALA GLY TYR ALA SER TYR GLY ASP TRP ARG ALA PHE          
SEQRES   7 C  175  ASP GLY TYR ARG HIS THR ARG GLU HIS SER VAL TYR VAL          
SEQRES   8 C  175  HIS LYS ASP ALA ARG GLY HIS GLY ILE GLY LYS ARG LEU          
SEQRES   9 C  175  MSE GLN ALA LEU ILE ASP HIS ALA GLY GLY ASN ASP VAL          
SEQRES  10 C  175  HIS VAL LEU ILE ALA ALA ILE GLU ALA GLU ASN THR ALA          
SEQRES  11 C  175  SER ILE ARG LEU HIS GLU SER LEU GLY PHE ARG VAL VAL          
SEQRES  12 C  175  GLY ARG PHE SER GLU VAL GLY THR LYS PHE GLY ARG TRP          
SEQRES  13 C  175  LEU ASP LEU THR CYS MSE GLU LEU LYS LEU GLY GLU GLY          
SEQRES  14 C  175  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 D  175  MSE SER LEU SER VAL GLU LEU ARG ASP ALA THR VAL ASP          
SEQRES   2 D  175  ASP LEU SER GLY ILE MSE GLU ILE TYR ASN ASP ALA VAL          
SEQRES   3 D  175  VAL ASN THR THR ALA ILE TRP ASN GLU VAL VAL VAL ASP          
SEQRES   4 D  175  LEU GLU ASN ARG LYS ASP TRP PHE ALA ALA ARG THR SER          
SEQRES   5 D  175  ARG GLY PHE PRO VAL ILE VAL ALA ILE LEU ASP GLY LYS          
SEQRES   6 D  175  VAL ALA GLY TYR ALA SER TYR GLY ASP TRP ARG ALA PHE          
SEQRES   7 D  175  ASP GLY TYR ARG HIS THR ARG GLU HIS SER VAL TYR VAL          
SEQRES   8 D  175  HIS LYS ASP ALA ARG GLY HIS GLY ILE GLY LYS ARG LEU          
SEQRES   9 D  175  MSE GLN ALA LEU ILE ASP HIS ALA GLY GLY ASN ASP VAL          
SEQRES  10 D  175  HIS VAL LEU ILE ALA ALA ILE GLU ALA GLU ASN THR ALA          
SEQRES  11 D  175  SER ILE ARG LEU HIS GLU SER LEU GLY PHE ARG VAL VAL          
SEQRES  12 D  175  GLY ARG PHE SER GLU VAL GLY THR LYS PHE GLY ARG TRP          
SEQRES  13 D  175  LEU ASP LEU THR CYS MSE GLU LEU LYS LEU GLY GLU GLY          
SEQRES  14 D  175  HIS HIS HIS HIS HIS HIS                                      
HET    MSE  A  19       8                                                       
HET    MSE  A 105       8                                                       
HET    MSE  A 162       8                                                       
HET    MSE  B  19       8                                                       
HET    MSE  B 105       8                                                       
HET    MSE  B 162       8                                                       
HET    MSE  C  19       8                                                       
HET    MSE  C 105       8                                                       
HET    MSE  C 162       8                                                       
HET    MSE  D  19       8                                                       
HET    MSE  D 105       8                                                       
HET    MSE  D 162       8                                                       
HET    SO4   1001       5                                                       
HET    SO4   1002       5                                                       
HET    SO4   1003       5                                                       
HET    SO4   1004       5                                                       
HET    SO4   1005       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    12(C5 H11 N O2 SE)                                           
FORMUL   5  SO4    5(O4 S 2-)                                                   
FORMUL  10  HOH   *823(H2 O)                                                    
CRYST1   73.849   64.490  145.447  90.00  99.30  90.00 C 1 2 1      16          
ATOM      1  N   SER A   4     -32.895  40.556  37.306  1.00 30.93           N  
ATOM      2  CA  SER A   4     -31.580  41.097  36.856  1.00 31.52           C  
ATOM      3  C   SER A   4     -30.497  40.961  37.918  1.00 30.76           C  
ATOM      4  O   SER A   4     -30.771  40.989  39.121  1.00 31.53           O  
ATOM      5  CB  SER A   4     -31.714  42.567  36.449  1.00 33.30           C  
ATOM      6  OG  SER A   4     -32.335  42.687  35.178  1.00 37.62           O  
ATOM      7  N   VAL A   5     -29.262  40.805  37.454  1.00 28.87           N  
ATOM      8  CA  VAL A   5     -28.118  40.658  38.338  1.00 25.94           C  
ATOM      9  C   VAL A   5     -27.265  41.909  38.293  1.00 23.85           C  
ATOM     10  O   VAL A   5     -27.124  42.527  37.244  1.00 23.84           O  
ATOM     11  CB  VAL A   5     -27.219  39.491  37.906  1.00 25.76           C  
ATOM     12  CG1 VAL A   5     -26.093  39.317  38.911  1.00 24.41           C  
ATOM     13  CG2 VAL A   5     -28.037  38.222  37.773  1.00 26.79           C  
ATOM     14  N   GLU A   6     -26.694  42.275  39.431  1.00 22.02           N  
ATOM     15  CA  GLU A   6     -25.828  43.441  39.503  1.00 21.49           C  
ATOM     16  C   GLU A   6     -24.569  43.095  40.290  1.00 20.56           C  
ATOM     17  O   GLU A   6     -24.624  42.357  41.278  1.00 18.68           O  
ATOM     18  CB  GLU A   6     -26.546  44.610  40.177  1.00 22.39           C  
ATOM     19  CG  GLU A   6     -27.771  45.126  39.431  1.00 25.70           C  
ATOM     20  CD  GLU A   6     -27.484  45.499  37.990  1.00 25.81           C  
ATOM     21  OE1 GLU A   6     -26.330  45.869  37.680  1.00 28.63           O  
ATOM     22  OE2 GLU A   6     -28.419  45.436  37.163  1.00 23.01           O  
ATOM     23  N   LEU A   7     -23.435  43.624  39.841  1.00 19.11           N  
ATOM     24  CA  LEU A   7     -22.155  43.377  40.503  1.00 18.87           C  
ATOM     25  C   LEU A   7     -21.654  44.620  41.247  1.00 18.01           C  
ATOM     26  O   LEU A   7     -21.896  45.749  40.816  1.00 16.98           O  
ATOM     27  CB  LEU A   7     -21.105  42.923  39.478  1.00 18.30           C  
ATOM     28  CG  LEU A   7     -21.108  41.446  39.040  1.00 19.54           C  
ATOM     29  CD1 LEU A   7     -22.417  41.098  38.363  1.00 20.55           C  
ATOM     30  CD2 LEU A   7     -19.937  41.186  38.095  1.00 18.71           C  
ATOM     31  N   ARG A   8     -20.964  44.399  42.362  1.00 16.53           N  
ATOM     32  CA  ARG A   8     -20.422  45.481  43.174  1.00 16.36           C  
ATOM     33  C   ARG A   8     -19.372  44.943  44.128  1.00 16.44           C  
ATOM     34  O   ARG A   8     -19.207  43.726  44.257  1.00 17.42           O  
ATOM     35  CB  ARG A   8     -21.530  46.165  43.990  1.00 16.62           C  
ATOM     36  CG  ARG A   8     -22.206  45.277  45.041  1.00 17.07           C  
ATOM     37  CD  ARG A   8     -23.133  46.087  45.963  1.00 19.39           C  
ATOM     38  NE  ARG A   8     -23.917  45.262  46.887  1.00 18.38           N  
ATOM     39  CZ  ARG A   8     -23.405  44.493  47.848  1.00 20.92           C  
ATOM     40  NH1 ARG A   8     -22.094  44.428  48.028  1.00 19.98           N  
ATOM     41  NH2 ARG A   8     -24.205  43.786  48.645  1.00 17.26           N  
ATOM     42  N   ASP A   9     -18.664  45.850  44.797  1.00 13.18           N  
ATOM     43  CA  ASP A   9     -17.648  45.453  45.764  1.00 13.58           C  
ATOM     44  C   ASP A   9     -18.334  44.768  46.936  1.00 12.49           C  
ATOM     45  O   ASP A   9     -19.415  45.179  47.366  1.00 11.07           O  
ATOM     46  CB  ASP A   9     -16.884  46.665  46.317  1.00 11.43           C  
ATOM     47  CG  ASP A   9     -15.895  47.250  45.328  1.00 13.56           C  
ATOM     48  OD1 ASP A   9     -15.575  46.577  44.331  1.00  8.88           O  
ATOM     49  OD2 ASP A   9     -15.428  48.385  45.568  1.00 11.76           O  
ATOM     50  N   ALA A  10     -17.701  43.723  47.450  1.00 13.18           N  
ATOM     51  CA  ALA A  10     -18.234  43.010  48.598  1.00 12.28           C  
ATOM     52  C   ALA A  10     -17.914  43.847  49.833  1.00 13.74           C  
ATOM     53  O   ALA A  10     -16.934  44.592  49.842  1.00 13.81           O  
ATOM     54  CB  ALA A  10     -17.571  41.649  48.718  1.00 12.53           C  
ATOM     55  N   THR A  11     -18.766  43.761  50.853  1.00 14.01           N  
ATOM     56  CA  THR A  11     -18.522  44.458  52.117  1.00 14.74           C  
ATOM     57  C   THR A  11     -18.559  43.368  53.180  1.00 14.98           C  
ATOM     58  O   THR A  11     -18.881  42.214  52.875  1.00 11.80           O  
ATOM     59  CB  THR A  11     -19.617  45.498  52.469  1.00 14.97           C  
ATOM     60  OG1 THR A  11     -20.865  44.831  52.681  1.00 19.03           O  
ATOM     61  CG2 THR A  11     -19.766  46.528  51.361  1.00 13.88           C  
ATOM     62  N   VAL A  12     -18.240  43.719  54.422  1.00 15.81           N  
ATOM     63  CA  VAL A  12     -18.263  42.724  55.485  1.00 17.84           C  
ATOM     64  C   VAL A  12     -19.660  42.113  55.600  1.00 17.28           C  
ATOM     65  O   VAL A  12     -19.805  40.965  56.006  1.00 17.39           O  
ATOM     66  CB  VAL A  12     -17.841  43.323  56.872  1.00 18.66           C  
ATOM     67  CG1 VAL A  12     -16.368  43.719  56.846  1.00 19.44           C  
ATOM     68  CG2 VAL A  12     -18.709  44.519  57.223  1.00 20.91           C  
ATOM     69  N   ASP A  13     -20.679  42.872  55.211  1.00 18.58           N  
ATOM     70  CA  ASP A  13     -22.054  42.384  55.292  1.00 20.02           C  
ATOM     71  C   ASP A  13     -22.381  41.265  54.305  1.00 18.22           C  
ATOM     72  O   ASP A  13     -23.412  40.606  54.439  1.00 18.57           O  
ATOM     73  CB  ASP A  13     -23.037  43.540  55.109  1.00 22.42           C  
ATOM     74  CG  ASP A  13     -22.905  44.587  56.197  1.00 26.28           C  
ATOM     75  OD1 ASP A  13     -22.698  44.209  57.369  1.00 26.81           O  
ATOM     76  OD2 ASP A  13     -23.017  45.788  55.883  1.00 30.55           O  
ATOM     77  N   ASP A  14     -21.508  41.045  53.324  1.00 16.74           N  
ATOM     78  CA  ASP A  14     -21.722  39.986  52.333  1.00 15.65           C  
ATOM     79  C   ASP A  14     -20.921  38.733  52.684  1.00 14.56           C  
ATOM     80  O   ASP A  14     -21.004  37.729  51.978  1.00 14.44           O  
ATOM     81  CB  ASP A  14     -21.270  40.433  50.937  1.00 14.41           C  
ATOM     82  CG  ASP A  14     -21.966  41.679  50.465  1.00 14.73           C  
ATOM     83  OD1 ASP A  14     -23.210  41.695  50.434  1.00 14.77           O  
ATOM     84  OD2 ASP A  14     -21.266  42.647  50.113  1.00 15.17           O  
ATOM     85  N   LEU A  15     -20.158  38.783  53.769  1.00 12.94           N  
ATOM     86  CA  LEU A  15     -19.312  37.647  54.126  1.00 14.65           C  
ATOM     87  C   LEU A  15     -20.000  36.327  54.475  1.00 13.82           C  
ATOM     88  O   LEU A  15     -19.471  35.260  54.155  1.00 12.29           O  
ATOM     89  CB  LEU A  15     -18.330  38.056  55.238  1.00 13.78           C  
ATOM     90  CG  LEU A  15     -17.379  39.196  54.850  1.00 15.41           C  
ATOM     91  CD1 LEU A  15     -16.392  39.451  55.982  1.00 14.66           C  
ATOM     92  CD2 LEU A  15     -16.628  38.850  53.568  1.00 12.00           C  
ATOM     93  N   SER A  16     -21.165  36.370  55.117  1.00 13.36           N  
ATOM     94  CA  SER A  16     -21.835  35.117  55.440  1.00 13.36           C  
ATOM     95  C   SER A  16     -22.339  34.474  54.140  1.00 14.09           C  
ATOM     96  O   SER A  16     -22.299  33.254  53.991  1.00 14.96           O  
ATOM     97  CB  SER A  16     -22.980  35.326  56.453  1.00 13.31           C  
ATOM     98  OG  SER A  16     -24.037  36.102  55.932  1.00 16.29           O  
ATOM     99  N   GLY A  17     -22.797  35.289  53.193  1.00 14.05           N  
ATOM    100  CA  GLY A  17     -23.243  34.742  51.922  1.00 13.08           C  
ATOM    101  C   GLY A  17     -22.064  34.159  51.145  1.00 15.21           C  
ATOM    102  O   GLY A  17     -22.179  33.116  50.498  1.00 15.84           O  
ATOM    103  N   ILE A  18     -20.925  34.844  51.202  1.00 14.31           N  
ATOM    104  CA  ILE A  18     -19.715  34.395  50.520  1.00 12.39           C  
ATOM    105  C   ILE A  18     -19.264  33.082  51.165  1.00 13.45           C  
ATOM    106  O   ILE A  18     -18.908  32.119  50.479  1.00 12.47           O  
ATOM    107  CB  ILE A  18     -18.591  35.484  50.615  1.00 10.26           C  
ATOM    108  CG1 ILE A  18     -18.927  36.652  49.675  1.00 11.41           C  
ATOM    109  CG2 ILE A  18     -17.228  34.901  50.236  1.00  9.71           C  
ATOM    110  CD1 ILE A  18     -17.877  37.762  49.641  1.00  9.04           C  
HETATM  111  N   MSE A  19     -19.323  33.037  52.489  1.00 15.38           N  
HETATM  112  CA  MSE A  19     -18.941  31.845  53.240  1.00 16.45           C  
HETATM  113  C   MSE A  19     -19.751  30.632  52.788  1.00 16.90           C  
HETATM  114  O   MSE A  19     -19.208  29.541  52.593  1.00 15.76           O  
HETATM  115  CB  MSE A  19     -19.170  32.087  54.732  1.00 16.77           C  
HETATM  116  CG  MSE A  19     -18.968  30.863  55.602  1.00 23.19           C  
HETATM  117 SE   MSE A  19     -19.609  31.205  57.393  1.00 28.83          SE  
HETATM  118  CE  MSE A  19     -21.477  30.778  57.120  1.00 31.07           C  
ATOM    119  N   GLU A  20     -21.054  30.821  52.622  1.00 16.80           N  
ATOM    120  CA  GLU A  20     -21.922  29.726  52.210  1.00 16.50           C  
ATOM    121  C   GLU A  20     -21.555  29.188  50.836  1.00 15.11           C  
ATOM    122  O   GLU A  20     -21.548  27.984  50.627  1.00 17.00           O  
ATOM    123  CB  GLU A  20     -23.383  30.180  52.219  1.00 17.59           C  
ATOM    124  CG  GLU A  20     -23.860  30.684  53.578  1.00 18.49           C  
ATOM    125  CD  GLU A  20     -25.272  31.216  53.527  1.00 19.24           C  
ATOM    126  OE1 GLU A  20     -25.697  31.663  52.438  1.00 19.76           O  
ATOM    127  OE2 GLU A  20     -25.957  31.200  54.575  1.00 20.90           O  
ATOM    128  N   ILE A  21     -21.254  30.078  49.896  1.00 14.10           N  
ATOM    129  CA  ILE A  21     -20.886  29.645  48.553  1.00 12.55           C  
ATOM    130  C   ILE A  21     -19.557  28.906  48.586  1.00 11.49           C  
ATOM    131  O   ILE A  21     -19.381  27.892  47.914  1.00 11.76           O  
ATOM    132  CB  ILE A  21     -20.790  30.851  47.584  1.00 11.25           C  
ATOM    133  CG1 ILE A  21     -22.193  31.410  47.330  1.00 11.20           C  
ATOM    134  CG2 ILE A  21     -20.139  30.415  46.255  1.00 11.64           C  
ATOM    135  CD1 ILE A  21     -22.229  32.666  46.481  1.00 13.82           C  
ATOM    136  N   TYR A  22     -18.623  29.434  49.369  1.00 13.48           N  
ATOM    137  CA  TYR A  22     -17.305  28.838  49.511  1.00 13.53           C  
ATOM    138  C   TYR A  22     -17.419  27.435  50.110  1.00 14.69           C  
ATOM    139  O   TYR A  22     -16.869  26.471  49.573  1.00 13.32           O  
ATOM    140  CB  TYR A  22     -16.444  29.718  50.421  1.00 16.59           C  
ATOM    141  CG  TYR A  22     -15.058  29.177  50.673  1.00 17.33           C  
ATOM    142  CD1 TYR A  22     -13.992  29.517  49.839  1.00 19.77           C  
ATOM    143  CD2 TYR A  22     -14.818  28.298  51.730  1.00 18.35           C  
ATOM    144  CE1 TYR A  22     -12.719  28.996  50.051  1.00 19.80           C  
ATOM    145  CE2 TYR A  22     -13.548  27.767  51.949  1.00 20.14           C  
ATOM    146  CZ  TYR A  22     -12.505  28.123  51.102  1.00 20.88           C  
ATOM    147  OH  TYR A  22     -11.258  27.589  51.298  1.00 19.84           O  
ATOM    148  N   ASN A  23     -18.135  27.324  51.225  1.00 13.43           N  
ATOM    149  CA  ASN A  23     -18.294  26.033  51.871  1.00 13.67           C  
ATOM    150  C   ASN A  23     -18.990  25.026  50.986  1.00 14.22           C  
ATOM    151  O   ASN A  23     -18.637  23.848  50.979  1.00 14.39           O  
ATOM    152  CB  ASN A  23     -19.035  26.195  53.194  1.00 13.79           C  
ATOM    153  CG  ASN A  23     -18.163  26.836  54.243  1.00 17.31           C  
ATOM    154  OD1 ASN A  23     -16.930  26.755  54.156  1.00 14.88           O  
ATOM    155  ND2 ASN A  23     -18.779  27.465  55.245  1.00 15.49           N  
ATOM    156  N   ASP A  24     -19.971  25.483  50.220  1.00 14.98           N  
ATOM    157  CA  ASP A  24     -20.661  24.563  49.340  1.00 16.19           C  
ATOM    158  C   ASP A  24     -19.684  23.995  48.311  1.00 16.16           C  
ATOM    159  O   ASP A  24     -19.717  22.801  48.011  1.00 15.60           O  
ATOM    160  CB  ASP A  24     -21.802  25.257  48.614  1.00 16.61           C  
ATOM    161  CG  ASP A  24     -22.481  24.344  47.635  1.00 18.24           C  
ATOM    162  OD1 ASP A  24     -23.291  23.505  48.074  1.00 18.75           O  
ATOM    163  OD2 ASP A  24     -22.182  24.446  46.430  1.00 18.68           O  
ATOM    164  N   ALA A  25     -18.822  24.853  47.768  1.00 15.59           N  
ATOM    165  CA  ALA A  25     -17.840  24.412  46.776  1.00 15.50           C  
ATOM    166  C   ALA A  25     -16.909  23.372  47.395  1.00 14.69           C  
ATOM    167  O   ALA A  25     -16.595  22.355  46.782  1.00 14.82           O  
ATOM    168  CB  ALA A  25     -17.037  25.603  46.265  1.00 14.80           C  
ATOM    169  N   VAL A  26     -16.475  23.632  48.621  1.00 15.27           N  
ATOM    170  CA  VAL A  26     -15.595  22.703  49.317  1.00 16.57           C  
ATOM    171  C   VAL A  26     -16.249  21.335  49.481  1.00 17.15           C  
ATOM    172  O   VAL A  26     -15.610  20.302  49.280  1.00 16.03           O  
ATOM    173  CB  VAL A  26     -15.237  23.217  50.714  1.00 16.96           C  
ATOM    174  CG1 VAL A  26     -14.424  22.165  51.457  1.00 18.50           C  
ATOM    175  CG2 VAL A  26     -14.455  24.518  50.605  1.00 15.84           C  
ATOM    176  N   VAL A  27     -17.527  21.339  49.850  1.00 17.09           N  
ATOM    177  CA  VAL A  27     -18.268  20.102  50.073  1.00 18.84           C  
ATOM    178  C   VAL A  27     -18.616  19.285  48.824  1.00 18.60           C  
ATOM    179  O   VAL A  27     -18.418  18.073  48.813  1.00 18.24           O  
ATOM    180  CB  VAL A  27     -19.602  20.365  50.853  1.00 17.95           C  
ATOM    181  CG1 VAL A  27     -20.436  19.089  50.911  1.00 20.60           C  
ATOM    182  CG2 VAL A  27     -19.311  20.845  52.265  1.00 17.09           C  
ATOM    183  N   ASN A  28     -19.129  19.930  47.777  1.00 19.03           N  
ATOM    184  CA  ASN A  28     -19.529  19.179  46.582  1.00 20.52           C  
ATOM    185  C   ASN A  28     -18.800  19.387  45.268  1.00 18.13           C  
ATOM    186  O   ASN A  28     -19.262  18.896  44.244  1.00 20.04           O  
ATOM    187  CB  ASN A  28     -21.020  19.387  46.307  1.00 24.28           C  
ATOM    188  CG  ASN A  28     -21.896  18.700  47.318  1.00 25.93           C  
ATOM    189  OD1 ASN A  28     -22.214  19.265  48.356  1.00 32.22           O  
ATOM    190  ND2 ASN A  28     -22.279  17.464  47.029  1.00 30.29           N  
ATOM    191  N   THR A  29     -17.676  20.093  45.267  1.00 18.81           N  
ATOM    192  CA  THR A  29     -16.987  20.327  44.003  1.00 17.59           C  
ATOM    193  C   THR A  29     -15.479  20.235  44.100  1.00 16.32           C  
ATOM    194  O   THR A  29     -14.913  20.114  45.187  1.00 15.00           O  
ATOM    195  CB  THR A  29     -17.326  21.718  43.436  1.00 17.88           C  
ATOM    196  OG1 THR A  29     -16.577  22.714  44.144  1.00 18.63           O  
ATOM    197  CG2 THR A  29     -18.816  22.011  43.594  1.00 18.27           C  
ATOM    198  N   THR A  30     -14.840  20.307  42.938  1.00 15.86           N  
ATOM    199  CA  THR A  30     -13.391  20.261  42.834  1.00 15.05           C  
ATOM    200  C   THR A  30     -12.857  21.682  42.620  1.00 15.39           C  
ATOM    201  O   THR A  30     -11.732  21.868  42.167  1.00 15.72           O  
ATOM    202  CB  THR A  30     -12.952  19.381  41.644  1.00 16.61           C  
ATOM    203  OG1 THR A  30     -13.531  19.891  40.435  1.00 16.79           O  
ATOM    204  CG2 THR A  30     -13.408  17.942  41.843  1.00 16.85           C  
ATOM    205  N   ALA A  31     -13.668  22.684  42.940  1.00 15.11           N  
ATOM    206  CA  ALA A  31     -13.255  24.074  42.775  1.00 15.73           C  
ATOM    207  C   ALA A  31     -12.243  24.472  43.839  1.00 15.22           C  
ATOM    208  O   ALA A  31     -11.437  25.369  43.625  1.00 16.36           O  
ATOM    209  CB  ALA A  31     -14.474  24.995  42.837  1.00 16.16           C  
ATOM    210  N   ILE A  32     -12.292  23.790  44.982  1.00 16.20           N  
ATOM    211  CA  ILE A  32     -11.391  24.064  46.105  1.00 15.72           C  
ATOM    212  C   ILE A  32     -10.805  22.735  46.555  1.00 16.47           C  
ATOM    213  O   ILE A  32     -11.529  21.856  47.015  1.00 16.61           O  
ATOM    214  CB  ILE A  32     -12.150  24.697  47.274  1.00 16.99           C  
ATOM    215  CG1 ILE A  32     -12.803  26.003  46.808  1.00 17.19           C  
ATOM    216  CG2 ILE A  32     -11.207  24.941  48.441  1.00 16.70           C  
ATOM    217  CD1 ILE A  32     -13.711  26.629  47.836  1.00 22.23           C  
ATOM    218  N   TRP A  33      -9.493  22.594  46.423  1.00 15.37           N  
ATOM    219  CA  TRP A  33      -8.824  21.349  46.772  1.00 16.20           C  
ATOM    220  C   TRP A  33      -8.478  21.111  48.247  1.00 17.05           C  
ATOM    221  O   TRP A  33      -7.314  21.117  48.652  1.00 16.80           O  
ATOM    222  CB  TRP A  33      -7.588  21.185  45.881  1.00 14.07           C  
ATOM    223  CG  TRP A  33      -7.950  20.947  44.422  1.00 14.78           C  
ATOM    224  CD1 TRP A  33      -9.154  21.196  43.826  1.00 17.03           C  
ATOM    225  CD2 TRP A  33      -7.093  20.441  43.387  1.00 16.28           C  
ATOM    226  NE1 TRP A  33      -9.101  20.877  42.491  1.00 16.59           N  
ATOM    227  CE2 TRP A  33      -7.848  20.412  42.193  1.00 16.17           C  
ATOM    228  CE3 TRP A  33      -5.760  20.010  43.352  1.00 15.34           C  
ATOM    229  CZ2 TRP A  33      -7.315  19.971  40.978  1.00 16.06           C  
ATOM    230  CZ3 TRP A  33      -5.230  19.572  42.142  1.00 14.34           C  
ATOM    231  CH2 TRP A  33      -6.005  19.557  40.976  1.00 16.40           C  
ATOM    232  N   ASN A  34      -9.527  20.893  49.029  1.00 19.47           N  
ATOM    233  CA  ASN A  34      -9.430  20.588  50.450  1.00 22.48           C  
ATOM    234  C   ASN A  34     -10.863  20.396  50.934  1.00 22.88           C  
ATOM    235  O   ASN A  34     -11.809  20.703  50.208  1.00 20.67           O  
ATOM    236  CB  ASN A  34      -8.739  21.719  51.229  1.00 25.51           C  
ATOM    237  CG  ASN A  34      -9.546  23.002  51.250  1.00 25.84           C  
ATOM    238  OD1 ASN A  34     -10.690  23.023  51.692  1.00 25.29           O  
ATOM    239  ND2 ASN A  34      -8.942  24.085  50.772  1.00 29.32           N  
ATOM    240  N   GLU A  35     -11.024  19.880  52.146  1.00 22.46           N  
ATOM    241  CA  GLU A  35     -12.351  19.651  52.700  1.00 25.68           C  
ATOM    242  C   GLU A  35     -12.557  20.517  53.927  1.00 26.28           C  
ATOM    243  O   GLU A  35     -13.318  20.155  54.823  1.00 28.61           O  
ATOM    244  CB  GLU A  35     -12.532  18.182  53.109  1.00 26.67           C  
ATOM    245  CG  GLU A  35     -12.387  17.152  51.996  1.00 28.18           C  
ATOM    246  CD  GLU A  35     -10.941  16.819  51.674  1.00 30.55           C  
ATOM    247  OE1 GLU A  35     -10.047  17.164  52.483  1.00 32.17           O  
ATOM    248  OE2 GLU A  35     -10.698  16.197  50.616  1.00 32.02           O  
ATOM    249  N   VAL A  36     -11.884  21.660  53.970  1.00 26.68           N  
ATOM    250  CA  VAL A  36     -11.984  22.549  55.121  1.00 26.60           C  
ATOM    251  C   VAL A  36     -13.109  23.572  55.020  1.00 25.44           C  
ATOM    252  O   VAL A  36     -13.037  24.516  54.237  1.00 22.31           O  
ATOM    253  CB  VAL A  36     -10.650  23.300  55.355  1.00 27.83           C  
ATOM    254  CG1 VAL A  36     -10.699  24.055  56.676  1.00 27.68           C  
ATOM    255  CG2 VAL A  36      -9.491  22.315  55.340  1.00 28.57           C  
ATOM    256  N   VAL A  37     -14.155  23.368  55.812  1.00 25.85           N  
ATOM    257  CA  VAL A  37     -15.277  24.293  55.842  1.00 27.51           C  
ATOM    258  C   VAL A  37     -14.828  25.477  56.689  1.00 26.92           C  
ATOM    259  O   VAL A  37     -14.215  25.289  57.737  1.00 28.33           O  
ATOM    260  CB  VAL A  37     -16.530  23.641  56.482  1.00 28.40           C  
ATOM    261  CG1 VAL A  37     -16.195  23.092  57.863  1.00 29.20           C  
ATOM    262  CG2 VAL A  37     -17.646  24.658  56.585  1.00 30.53           C  
ATOM    263  N   VAL A  38     -15.127  26.690  56.235  1.00 26.64           N  
ATOM    264  CA  VAL A  38     -14.722  27.896  56.954  1.00 27.64           C  
ATOM    265  C   VAL A  38     -15.886  28.597  57.647  1.00 28.16           C  
ATOM    266  O   VAL A  38     -17.043  28.406  57.277  1.00 28.73           O  
ATOM    267  CB  VAL A  38     -14.050  28.915  55.998  1.00 27.11           C  
ATOM    268  CG1 VAL A  38     -12.906  28.252  55.246  1.00 26.88           C  
ATOM    269  CG2 VAL A  38     -15.075  29.477  55.024  1.00 27.91           C  
ATOM    270  N   ASP A  39     -15.574  29.414  58.649  1.00 27.23           N  
ATOM    271  CA  ASP A  39     -16.603  30.146  59.383  1.00 26.78           C  
ATOM    272  C   ASP A  39     -16.536  31.630  59.036  1.00 25.26           C  
ATOM    273  O   ASP A  39     -15.761  32.039  58.173  1.00 26.12           O  
ATOM    274  CB  ASP A  39     -16.404  29.967  60.883  1.00 28.86           C  
ATOM    275  CG  ASP A  39     -15.182  30.693  61.388  1.00 30.03           C  
ATOM    276  OD1 ASP A  39     -14.126  30.581  60.738  1.00 31.23           O  
ATOM    277  OD2 ASP A  39     -15.277  31.374  62.432  1.00 33.55           O  
ATOM    278  N   LEU A  40     -17.332  32.438  59.728  1.00 23.18           N  
ATOM    279  CA  LEU A  40     -17.366  33.870  59.465  1.00 22.87           C  
ATOM    280  C   LEU A  40     -16.040  34.576  59.749  1.00 22.70           C  
ATOM    281  O   LEU A  40     -15.627  35.436  58.976  1.00 20.16           O  
ATOM    282  CB  LEU A  40     -18.488  34.535  60.272  1.00 21.36           C  
ATOM    283  CG  LEU A  40     -18.783  35.994  59.901  1.00 23.06           C  
ATOM    284  CD1 LEU A  40     -19.177  36.074  58.426  1.00 22.12           C  
ATOM    285  CD2 LEU A  40     -19.891  36.549  60.785  1.00 21.54           C  
ATOM    286  N   GLU A  41     -15.377  34.230  60.851  1.00 23.84           N  
ATOM    287  CA  GLU A  41     -14.103  34.874  61.175  1.00 25.29           C  
ATOM    288  C   GLU A  41     -13.111  34.668  60.043  1.00 24.14           C  
ATOM    289  O   GLU A  41     -12.394  35.593  59.666  1.00 24.93           O  
ATOM    290  CB  GLU A  41     -13.489  34.315  62.460  1.00 27.22           C  
ATOM    291  CG  GLU A  41     -14.293  34.533  63.722  1.00 30.97           C  
ATOM    292  CD  GLU A  41     -13.466  34.264  64.978  1.00 34.34           C  
ATOM    293  OE1 GLU A  41     -12.546  33.416  64.913  1.00 36.11           O  
ATOM    294  OE2 GLU A  41     -13.744  34.895  66.022  1.00 35.19           O  
ATOM    295  N   ASN A  42     -13.071  33.455  59.501  1.00 21.97           N  
ATOM    296  CA  ASN A  42     -12.150  33.160  58.414  1.00 20.98           C  
ATOM    297  C   ASN A  42     -12.378  34.106  57.235  1.00 19.75           C  
ATOM    298  O   ASN A  42     -11.424  34.647  56.692  1.00 17.31           O  
ATOM    299  CB  ASN A  42     -12.293  31.701  57.957  1.00 21.98           C  
ATOM    300  CG  ASN A  42     -11.493  31.402  56.693  1.00 22.86           C  
ATOM    301  OD1 ASN A  42     -11.880  31.788  55.590  1.00 22.39           O  
ATOM    302  ND2 ASN A  42     -10.369  30.717  56.855  1.00 25.03           N  
ATOM    303  N   ARG A  43     -13.636  34.315  56.853  1.00 18.19           N  
ATOM    304  CA  ARG A  43     -13.948  35.197  55.735  1.00 18.27           C  
ATOM    305  C   ARG A  43     -13.604  36.643  56.062  1.00 18.30           C  
ATOM    306  O   ARG A  43     -13.209  37.411  55.186  1.00 17.57           O  
ATOM    307  CB  ARG A  43     -15.428  35.086  55.358  1.00 16.32           C  
ATOM    308  CG  ARG A  43     -15.829  33.760  54.697  1.00 20.65           C  
ATOM    309  CD  ARG A  43     -15.132  33.524  53.351  1.00 19.42           C  
ATOM    310  NE  ARG A  43     -13.788  32.983  53.512  1.00 20.90           N  
ATOM    311  CZ  ARG A  43     -12.947  32.727  52.512  1.00 22.98           C  
ATOM    312  NH1 ARG A  43     -13.298  32.962  51.251  1.00 20.22           N  
ATOM    313  NH2 ARG A  43     -11.747  32.226  52.778  1.00 20.01           N  
ATOM    314  N   LYS A  44     -13.760  37.008  57.330  1.00 19.76           N  
ATOM    315  CA  LYS A  44     -13.449  38.353  57.791  1.00 20.41           C  
ATOM    316  C   LYS A  44     -11.963  38.645  57.627  1.00 18.58           C  
ATOM    317  O   LYS A  44     -11.588  39.701  57.117  1.00 17.15           O  
ATOM    318  CB  LYS A  44     -13.847  38.503  59.259  1.00 21.21           C  
ATOM    319  CG  LYS A  44     -15.114  39.293  59.463  1.00 26.07           C  
ATOM    320  CD  LYS A  44     -15.957  38.682  60.564  1.00 28.32           C  
ATOM    321  CE  LYS A  44     -16.989  39.667  61.054  1.00 31.07           C  
ATOM    322  NZ  LYS A  44     -16.331  40.751  61.843  1.00 35.79           N  
ATOM    323  N   ASP A  45     -11.119  37.712  58.061  1.00 17.91           N  
ATOM    324  CA  ASP A  45      -9.672  37.888  57.940  1.00 18.32           C  
ATOM    325  C   ASP A  45      -9.314  37.919  56.470  1.00 18.55           C  
ATOM    326  O   ASP A  45      -8.549  38.770  56.018  1.00 19.96           O  
ATOM    327  CB  ASP A  45      -8.924  36.729  58.593  1.00 20.47           C  
ATOM    328  CG  ASP A  45      -9.218  36.604  60.067  1.00 23.01           C  
ATOM    329  OD1 ASP A  45      -9.440  37.643  60.716  1.00 25.70           O  
ATOM    330  OD2 ASP A  45      -9.208  35.467  60.576  1.00 26.80           O  
ATOM    331  N   TRP A  46      -9.865  36.952  55.741  1.00 16.43           N  
ATOM    332  CA  TRP A  46      -9.665  36.816  54.304  1.00 14.89           C  
ATOM    333  C   TRP A  46     -10.010  38.144  53.636  1.00 13.60           C  
ATOM    334  O   TRP A  46      -9.240  38.670  52.833  1.00 14.72           O  
ATOM    335  CB  TRP A  46     -10.582  35.708  53.776  1.00 15.70           C  
ATOM    336  CG  TRP A  46     -10.658  35.588  52.273  1.00 15.87           C  
ATOM    337  CD1 TRP A  46      -9.718  35.049  51.439  1.00 13.35           C  
ATOM    338  CD2 TRP A  46     -11.749  35.992  51.440  1.00 14.48           C  
ATOM    339  NE1 TRP A  46     -10.160  35.089  50.136  1.00 15.08           N  
ATOM    340  CE2 TRP A  46     -11.405  35.660  50.106  1.00 15.78           C  
ATOM    341  CE3 TRP A  46     -12.988  36.599  51.689  1.00 13.20           C  
ATOM    342  CZ2 TRP A  46     -12.257  35.916  49.019  1.00 13.04           C  
ATOM    343  CZ3 TRP A  46     -13.840  36.855  50.606  1.00 15.63           C  
ATOM    344  CH2 TRP A  46     -13.465  36.509  49.286  1.00 13.65           C  
ATOM    345  N   PHE A  47     -11.173  38.683  53.983  1.00 10.95           N  
ATOM    346  CA  PHE A  47     -11.627  39.939  53.412  1.00 12.11           C  
ATOM    347  C   PHE A  47     -10.749  41.127  53.809  1.00 13.39           C  
ATOM    348  O   PHE A  47     -10.534  42.044  53.012  1.00 14.19           O  
ATOM    349  CB  PHE A  47     -13.068  40.223  53.836  1.00 12.98           C  
ATOM    350  CG  PHE A  47     -13.607  41.520  53.308  1.00 13.83           C  
ATOM    351  CD1 PHE A  47     -13.998  41.638  51.978  1.00 15.04           C  
ATOM    352  CD2 PHE A  47     -13.711  42.631  54.138  1.00 13.74           C  
ATOM    353  CE1 PHE A  47     -14.487  42.842  51.485  1.00 13.76           C  
ATOM    354  CE2 PHE A  47     -14.196  43.838  53.655  1.00 14.37           C  
ATOM    355  CZ  PHE A  47     -14.586  43.942  52.328  1.00 13.03           C  
ATOM    356  N   ALA A  48     -10.248  41.118  55.039  1.00 13.19           N  
ATOM    357  CA  ALA A  48      -9.398  42.207  55.508  1.00 13.59           C  
ATOM    358  C   ALA A  48      -8.035  42.175  54.810  1.00 14.73           C  
ATOM    359  O   ALA A  48      -7.489  43.220  54.456  1.00 15.40           O  
ATOM    360  CB  ALA A  48      -9.217  42.124  57.022  1.00 13.69           C  
ATOM    361  N   ALA A  49      -7.504  40.975  54.599  1.00 14.91           N  
ATOM    362  CA  ALA A  49      -6.205  40.823  53.947  1.00 17.15           C  
ATOM    363  C   ALA A  49      -6.252  41.244  52.486  1.00 16.20           C  
ATOM    364  O   ALA A  49      -5.334  41.896  51.990  1.00 17.95           O  
ATOM    365  CB  ALA A  49      -5.726  39.389  54.058  1.00 15.98           C  
ATOM    366  N   ARG A  50      -7.322  40.882  51.790  1.00 16.99           N  
ATOM    367  CA  ARG A  50      -7.435  41.265  50.395  1.00 17.29           C  
ATOM    368  C   ARG A  50      -7.623  42.772  50.264  1.00 16.02           C  
ATOM    369  O   ARG A  50      -7.008  43.399  49.401  1.00 14.86           O  
ATOM    370  CB  ARG A  50      -8.581  40.501  49.721  1.00 19.24           C  
ATOM    371  CG  ARG A  50      -8.092  39.234  49.018  1.00 23.52           C  
ATOM    372  CD  ARG A  50      -9.187  38.215  48.846  1.00 25.77           C  
ATOM    373  NE  ARG A  50      -8.843  37.185  47.860  1.00 25.13           N  
ATOM    374  CZ  ARG A  50      -7.796  36.371  47.946  1.00 25.63           C  
ATOM    375  NH1 ARG A  50      -6.964  36.453  48.975  1.00 25.68           N  
ATOM    376  NH2 ARG A  50      -7.584  35.468  47.000  1.00 24.15           N  
ATOM    377  N   THR A  51      -8.444  43.353  51.133  1.00 14.74           N  
ATOM    378  CA  THR A  51      -8.681  44.791  51.098  1.00 14.17           C  
ATOM    379  C   THR A  51      -7.354  45.536  51.280  1.00 14.45           C  
ATOM    380  O   THR A  51      -7.067  46.492  50.554  1.00 13.06           O  
ATOM    381  CB  THR A  51      -9.714  45.203  52.187  1.00 13.70           C  
ATOM    382  OG1 THR A  51     -10.964  44.559  51.906  1.00 15.98           O  
ATOM    383  CG2 THR A  51      -9.936  46.709  52.194  1.00 14.39           C  
ATOM    384  N   SER A  52      -6.538  45.072  52.225  1.00 14.53           N  
ATOM    385  CA  SER A  52      -5.232  45.673  52.490  1.00 15.75           C  
ATOM    386  C   SER A  52      -4.295  45.582  51.277  1.00 15.10           C  
ATOM    387  O   SER A  52      -3.597  46.543  50.962  1.00 15.80           O  
ATOM    388  CB  SER A  52      -4.560  44.985  53.688  1.00 15.54           C  
ATOM    389  OG  SER A  52      -5.271  45.223  54.892  1.00 21.44           O  
ATOM    390  N   ARG A  53      -4.278  44.431  50.609  1.00 14.30           N  
ATOM    391  CA  ARG A  53      -3.410  44.233  49.445  1.00 15.70           C  
ATOM    392  C   ARG A  53      -3.964  44.941  48.211  1.00 13.75           C  
ATOM    393  O   ARG A  53      -3.291  45.039  47.185  1.00 14.05           O  
ATOM    394  CB  ARG A  53      -3.254  42.735  49.127  1.00 16.12           C  
ATOM    395  CG  ARG A  53      -2.535  41.904  50.194  1.00 16.60           C  
ATOM    396  CD  ARG A  53      -1.052  42.237  50.276  1.00 18.68           C  
ATOM    397  NE  ARG A  53      -0.337  41.947  49.032  1.00 16.64           N  
ATOM    398  CZ  ARG A  53      -0.045  40.725  48.594  1.00 19.30           C  
ATOM    399  NH1 ARG A  53      -0.408  39.658  49.295  1.00 16.76           N  
ATOM    400  NH2 ARG A  53       0.629  40.570  47.456  1.00 18.01           N  
ATOM    401  N   GLY A  54      -5.195  45.424  48.317  1.00 13.42           N  
ATOM    402  CA  GLY A  54      -5.817  46.106  47.200  1.00 13.63           C  
ATOM    403  C   GLY A  54      -6.425  45.114  46.223  1.00 13.88           C  
ATOM    404  O   GLY A  54      -6.721  45.460  45.078  1.00 14.07           O  
ATOM    405  N   PHE A  55      -6.596  43.873  46.668  1.00 11.40           N  
ATOM    406  CA  PHE A  55      -7.180  42.847  45.813  1.00 11.44           C  
ATOM    407  C   PHE A  55      -8.689  42.994  45.891  1.00 11.13           C  
ATOM    408  O   PHE A  55      -9.245  43.162  46.967  1.00 11.41           O  
ATOM    409  CB  PHE A  55      -6.774  41.441  46.267  1.00 11.31           C  
ATOM    410  CG  PHE A  55      -5.291  41.176  46.198  1.00 11.16           C  
ATOM    411  CD1 PHE A  55      -4.475  41.886  45.322  1.00 11.75           C  
ATOM    412  CD2 PHE A  55      -4.719  40.189  46.993  1.00 10.72           C  
ATOM    413  CE1 PHE A  55      -3.102  41.619  45.239  1.00 12.76           C  
ATOM    414  CE2 PHE A  55      -3.352  39.912  46.921  1.00 12.06           C  
ATOM    415  CZ  PHE A  55      -2.543  40.627  46.043  1.00 13.47           C  
ATOM    416  N   PRO A  56      -9.371  42.919  44.745  1.00 11.48           N  
ATOM    417  CA  PRO A  56     -10.825  43.060  44.710  1.00  9.79           C  
ATOM    418  C   PRO A  56     -11.603  41.859  45.225  1.00 13.14           C  
ATOM    419  O   PRO A  56     -11.102  40.734  45.255  1.00 11.77           O  
ATOM    420  CB  PRO A  56     -11.099  43.318  43.236  1.00 13.30           C  
ATOM    421  CG  PRO A  56     -10.087  42.415  42.572  1.00 10.46           C  
ATOM    422  CD  PRO A  56      -8.833  42.653  43.399  1.00  9.94           C  
ATOM    423  N   VAL A  57     -12.829  42.126  45.661  1.00 14.24           N  
ATOM    424  CA  VAL A  57     -13.743  41.099  46.127  1.00 14.48           C  
ATOM    425  C   VAL A  57     -15.068  41.606  45.596  1.00 14.71           C  
ATOM    426  O   VAL A  57     -15.656  42.553  46.126  1.00 14.12           O  
ATOM    427  CB  VAL A  57     -13.785  40.976  47.657  1.00 15.59           C  
ATOM    428  CG1 VAL A  57     -14.737  39.847  48.049  1.00 14.44           C  
ATOM    429  CG2 VAL A  57     -12.389  40.672  48.191  1.00 14.07           C  
ATOM    430  N   ILE A  58     -15.509  40.975  44.518  1.00 13.74           N  
ATOM    431  CA  ILE A  58     -16.728  41.362  43.836  1.00 14.09           C  
ATOM    432  C   ILE A  58     -17.839  40.344  44.023  1.00 12.30           C  
ATOM    433  O   ILE A  58     -17.619  39.147  43.879  1.00 14.20           O  
ATOM    434  CB  ILE A  58     -16.447  41.517  42.320  1.00 12.78           C  
ATOM    435  CG1 ILE A  58     -15.277  42.480  42.111  1.00 15.53           C  
ATOM    436  CG2 ILE A  58     -17.673  42.018  41.609  1.00  9.45           C  
ATOM    437  CD1 ILE A  58     -14.738  42.494  40.686  1.00 17.14           C  
ATOM    438  N   VAL A  59     -19.035  40.818  44.357  1.00 12.54           N  
ATOM    439  CA  VAL A  59     -20.159  39.914  44.516  1.00 10.07           C  
ATOM    440  C   VAL A  59     -21.229  40.212  43.489  1.00 11.79           C  
ATOM    441  O   VAL A  59     -21.345  41.338  43.004  1.00 12.17           O  
ATOM    442  CB  VAL A  59     -20.783  39.995  45.934  1.00 11.31           C  
ATOM    443  CG1 VAL A  59     -19.843  39.364  46.950  1.00 10.47           C  
ATOM    444  CG2 VAL A  59     -21.064  41.443  46.306  1.00 10.69           C  
ATOM    445  N   ALA A  60     -21.984  39.186  43.114  1.00 13.30           N  
ATOM    446  CA  ALA A  60     -23.082  39.373  42.175  1.00 12.87           C  
ATOM    447  C   ALA A  60     -24.311  39.277  43.068  1.00 13.43           C  
ATOM    448  O   ALA A  60     -24.448  38.342  43.858  1.00 10.50           O  
ATOM    449  CB  ALA A  60     -23.090  38.263  41.122  1.00 12.94           C  
ATOM    450  N   ILE A  61     -25.186  40.264  42.959  1.00 13.67           N  
ATOM    451  CA  ILE A  61     -26.391  40.303  43.771  1.00 15.11           C  
ATOM    452  C   ILE A  61     -27.601  40.031  42.895  1.00 17.92           C  
ATOM    453  O   ILE A  61     -27.782  40.660  41.848  1.00 18.08           O  
ATOM    454  CB  ILE A  61     -26.558  41.678  44.439  1.00 15.98           C  
ATOM    455  CG1 ILE A  61     -25.288  42.025  45.228  1.00 15.14           C  
ATOM    456  CG2 ILE A  61     -27.794  41.679  45.347  1.00 14.55           C  
ATOM    457  CD1 ILE A  61     -24.980  41.072  46.365  1.00 13.82           C  
ATOM    458  N   LEU A  62     -28.415  39.077  43.327  1.00 20.94           N  
ATOM    459  CA  LEU A  62     -29.621  38.693  42.613  1.00 22.09           C  
ATOM    460  C   LEU A  62     -30.692  38.385  43.648  1.00 23.29           C  
ATOM    461  O   LEU A  62     -30.463  37.611  44.575  1.00 21.74           O  
ATOM    462  CB  LEU A  62     -29.356  37.458  41.751  1.00 22.65           C  
ATOM    463  CG  LEU A  62     -30.551  36.856  41.011  1.00 23.06           C  
ATOM    464  CD1 LEU A  62     -31.071  37.842  39.975  1.00 23.27           C  
ATOM    465  CD2 LEU A  62     -30.123  35.558  40.344  1.00 24.81           C  
ATOM    466  N   ASP A  63     -31.855  39.008  43.497  1.00 25.60           N  
ATOM    467  CA  ASP A  63     -32.962  38.800  44.424  1.00 28.85           C  
ATOM    468  C   ASP A  63     -32.547  39.142  45.858  1.00 27.94           C  
ATOM    469  O   ASP A  63     -32.919  38.450  46.810  1.00 29.71           O  
ATOM    470  CB  ASP A  63     -33.436  37.343  44.348  1.00 33.17           C  
ATOM    471  CG  ASP A  63     -34.835  37.151  44.908  1.00 37.47           C  
ATOM    472  OD1 ASP A  63     -35.767  37.820  44.412  1.00 39.59           O  
ATOM    473  OD2 ASP A  63     -35.004  36.330  45.837  1.00 39.62           O  
ATOM    474  N   GLY A  64     -31.767  40.205  46.007  1.00 26.97           N  
ATOM    475  CA  GLY A  64     -31.328  40.625  47.326  1.00 26.10           C  
ATOM    476  C   GLY A  64     -30.227  39.807  47.979  1.00 25.62           C  
ATOM    477  O   GLY A  64     -29.740  40.170  49.052  1.00 26.49           O  
ATOM    478  N   LYS A  65     -29.814  38.712  47.351  1.00 23.45           N  
ATOM    479  CA  LYS A  65     -28.764  37.882  47.936  1.00 22.17           C  
ATOM    480  C   LYS A  65     -27.525  37.715  47.054  1.00 19.09           C  
ATOM    481  O   LYS A  65     -27.549  38.023  45.861  1.00 17.69           O  
ATOM    482  CB  LYS A  65     -29.347  36.517  48.292  1.00 26.46           C  
ATOM    483  CG  LYS A  65     -29.995  35.801  47.124  1.00 33.03           C  
ATOM    484  CD  LYS A  65     -31.076  34.828  47.597  1.00 36.93           C  
ATOM    485  CE  LYS A  65     -32.358  35.566  47.951  1.00 39.74           C  
ATOM    486  NZ  LYS A  65     -32.159  36.589  49.020  1.00 41.07           N  
ATOM    487  N   VAL A  66     -26.439  37.233  47.653  1.00 16.05           N  
ATOM    488  CA  VAL A  66     -25.187  37.018  46.930  1.00 14.40           C  
ATOM    489  C   VAL A  66     -25.335  35.786  46.054  1.00 14.19           C  
ATOM    490  O   VAL A  66     -25.458  34.669  46.558  1.00 14.08           O  
ATOM    491  CB  VAL A  66     -24.007  36.819  47.918  1.00 15.51           C  
ATOM    492  CG1 VAL A  66     -22.721  36.515  47.159  1.00 11.94           C  
ATOM    493  CG2 VAL A  66     -23.838  38.072  48.773  1.00 11.38           C  
ATOM    494  N   ALA A  67     -25.339  35.994  44.740  1.00 13.24           N  
ATOM    495  CA  ALA A  67     -25.492  34.892  43.793  1.00 10.23           C  
ATOM    496  C   ALA A  67     -24.149  34.433  43.233  1.00 11.60           C  
ATOM    497  O   ALA A  67     -24.088  33.542  42.384  1.00 12.13           O  
ATOM    498  CB  ALA A  67     -26.409  35.311  42.667  1.00 11.81           C  
ATOM    499  N   GLY A  68     -23.077  35.041  43.722  1.00 11.02           N  
ATOM    500  CA  GLY A  68     -21.752  34.676  43.267  1.00 11.54           C  
ATOM    501  C   GLY A  68     -20.722  35.679  43.741  1.00 11.85           C  
ATOM    502  O   GLY A  68     -21.062  36.803  44.113  1.00 10.44           O  
ATOM    503  N   TYR A  69     -19.455  35.279  43.757  1.00 10.93           N  
ATOM    504  CA  TYR A  69     -18.414  36.204  44.176  1.00 10.37           C  
ATOM    505  C   TYR A  69     -17.136  35.890  43.430  1.00 10.82           C  
ATOM    506  O   TYR A  69     -16.968  34.795  42.890  1.00  9.98           O  
ATOM    507  CB  TYR A  69     -18.223  36.157  45.700  1.00  9.93           C  
ATOM    508  CG  TYR A  69     -17.373  35.034  46.244  1.00 13.02           C  
ATOM    509  CD1 TYR A  69     -15.990  35.171  46.358  1.00 12.68           C  
ATOM    510  CD2 TYR A  69     -17.959  33.855  46.697  1.00 13.70           C  
ATOM    511  CE1 TYR A  69     -15.209  34.158  46.923  1.00 12.18           C  
ATOM    512  CE2 TYR A  69     -17.194  32.837  47.259  1.00 14.60           C  
ATOM    513  CZ  TYR A  69     -15.821  32.997  47.373  1.00 15.23           C  
ATOM    514  OH  TYR A  69     -15.065  31.994  47.958  1.00 13.20           O  
ATOM    515  N   ALA A  70     -16.246  36.869  43.369  1.00 11.04           N  
ATOM    516  CA  ALA A  70     -15.002  36.686  42.639  1.00 10.96           C  
ATOM    517  C   ALA A  70     -13.881  37.485  43.265  1.00 10.39           C  
ATOM    518  O   ALA A  70     -14.118  38.515  43.884  1.00 11.89           O  
ATOM    519  CB  ALA A  70     -15.199  37.106  41.204  1.00  8.98           C  
ATOM    520  N   SER A  71     -12.651  37.024  43.079  1.00 11.97           N  
ATOM    521  CA  SER A  71     -11.521  37.722  43.660  1.00 11.16           C  
ATOM    522  C   SER A  71     -10.227  37.201  43.046  1.00 10.94           C  
ATOM    523  O   SER A  71     -10.236  36.294  42.211  1.00 12.45           O  
ATOM    524  CB  SER A  71     -11.534  37.477  45.176  1.00 13.32           C  
ATOM    525  OG  SER A  71     -10.488  38.151  45.846  1.00 11.64           O  
ATOM    526  N   TYR A  72      -9.114  37.802  43.431  1.00 11.33           N  
ATOM    527  CA  TYR A  72      -7.823  37.315  42.979  1.00 11.18           C  
ATOM    528  C   TYR A  72      -6.808  37.670  44.028  1.00 11.94           C  
ATOM    529  O   TYR A  72      -7.044  38.536  44.869  1.00 13.17           O  
ATOM    530  CB  TYR A  72      -7.434  37.831  41.577  1.00  6.35           C  
ATOM    531  CG  TYR A  72      -7.227  39.316  41.374  1.00  9.00           C  
ATOM    532  CD1 TYR A  72      -8.066  40.037  40.518  1.00  7.79           C  
ATOM    533  CD2 TYR A  72      -6.163  39.993  41.980  1.00  8.11           C  
ATOM    534  CE1 TYR A  72      -7.852  41.387  40.273  1.00 10.03           C  
ATOM    535  CE2 TYR A  72      -5.940  41.348  41.740  1.00  7.40           C  
ATOM    536  CZ  TYR A  72      -6.784  42.034  40.889  1.00  9.08           C  
ATOM    537  OH  TYR A  72      -6.573  43.370  40.652  1.00  7.50           O  
ATOM    538  N   GLY A  73      -5.696  36.952  44.009  1.00 13.11           N  
ATOM    539  CA  GLY A  73      -4.648  37.185  44.976  1.00 11.97           C  
ATOM    540  C   GLY A  73      -3.338  36.693  44.410  1.00 12.65           C  
ATOM    541  O   GLY A  73      -3.200  36.569  43.194  1.00 13.01           O  
ATOM    542  N   ASP A  74      -2.376  36.405  45.278  1.00 13.22           N  
ATOM    543  CA  ASP A  74      -1.085  35.931  44.805  1.00 14.01           C  
ATOM    544  C   ASP A  74      -1.208  34.606  44.063  1.00 15.00           C  
ATOM    545  O   ASP A  74      -2.065  33.780  44.370  1.00 13.82           O  
ATOM    546  CB  ASP A  74      -0.097  35.717  45.956  1.00 14.60           C  
ATOM    547  CG  ASP A  74       0.280  37.003  46.676  1.00 14.86           C  
ATOM    548  OD1 ASP A  74       0.502  38.037  46.016  1.00 14.56           O  
ATOM    549  OD2 ASP A  74       0.377  36.963  47.919  1.00 19.12           O  
ATOM    550  N   TRP A  75      -0.341  34.415  43.077  1.00 16.81           N  
ATOM    551  CA  TRP A  75      -0.300  33.165  42.335  1.00 16.64           C  
ATOM    552  C   TRP A  75       0.870  32.405  42.959  1.00 18.42           C  
ATOM    553  O   TRP A  75       0.739  31.252  43.362  1.00 22.20           O  
ATOM    554  CB  TRP A  75      -0.039  33.424  40.859  1.00 13.90           C  
ATOM    555  CG  TRP A  75       0.225  32.174  40.092  1.00 15.02           C  
ATOM    556  CD1 TRP A  75      -0.521  31.029  40.098  1.00 14.73           C  
ATOM    557  CD2 TRP A  75       1.296  31.952  39.176  1.00 14.36           C  
ATOM    558  NE1 TRP A  75       0.025  30.105  39.235  1.00 16.55           N  
ATOM    559  CE2 TRP A  75       1.140  30.648  38.654  1.00 14.59           C  
ATOM    560  CE3 TRP A  75       2.374  32.730  38.738  1.00 14.76           C  
ATOM    561  CZ2 TRP A  75       2.022  30.104  37.720  1.00 14.07           C  
ATOM    562  CZ3 TRP A  75       3.254  32.187  37.807  1.00 13.73           C  
ATOM    563  CH2 TRP A  75       3.070  30.886  37.309  1.00 11.50           C  
ATOM    564  N   ARG A  76       2.010  33.080  43.040  1.00 20.14           N  
ATOM    565  CA  ARG A  76       3.219  32.536  43.646  1.00 24.06           C  
ATOM    566  C   ARG A  76       3.680  33.621  44.610  1.00 24.26           C  
ATOM    567  O   ARG A  76       3.930  34.754  44.202  1.00 23.53           O  
ATOM    568  CB  ARG A  76       4.293  32.297  42.585  1.00 25.90           C  
ATOM    569  CG  ARG A  76       3.814  31.462  41.419  1.00 29.65           C  
ATOM    570  CD  ARG A  76       4.227  30.025  41.577  1.00 31.42           C  
ATOM    571  NE  ARG A  76       5.680  29.888  41.525  1.00 29.68           N  
ATOM    572  CZ  ARG A  76       6.322  28.759  41.793  1.00 26.73           C  
ATOM    573  NH1 ARG A  76       5.630  27.681  42.130  1.00 26.28           N  
ATOM    574  NH2 ARG A  76       7.643  28.707  41.727  1.00 24.01           N  
ATOM    575  N   ALA A  77       3.783  33.271  45.885  1.00 26.82           N  
ATOM    576  CA  ALA A  77       4.181  34.217  46.923  1.00 28.68           C  
ATOM    577  C   ALA A  77       5.637  34.671  46.826  1.00 28.28           C  
ATOM    578  O   ALA A  77       6.462  34.320  47.671  1.00 27.79           O  
ATOM    579  CB  ALA A  77       3.908  33.610  48.305  1.00 30.64           C  
ATOM    580  N   PHE A  78       5.933  35.459  45.797  1.00 27.64           N  
ATOM    581  CA  PHE A  78       7.273  35.980  45.578  1.00 27.42           C  
ATOM    582  C   PHE A  78       7.221  37.353  44.903  1.00 26.73           C  
ATOM    583  O   PHE A  78       6.470  37.563  43.948  1.00 24.06           O  
ATOM    584  CB  PHE A  78       8.092  35.008  44.723  1.00 29.37           C  
ATOM    585  CG  PHE A  78       8.206  33.633  45.316  1.00 32.16           C  
ATOM    586  CD1 PHE A  78       7.431  32.584  44.832  1.00 33.63           C  
ATOM    587  CD2 PHE A  78       9.064  33.394  46.387  1.00 34.83           C  
ATOM    588  CE1 PHE A  78       7.503  31.314  45.407  1.00 35.01           C  
ATOM    589  CE2 PHE A  78       9.146  32.130  46.971  1.00 35.23           C  
ATOM    590  CZ  PHE A  78       8.364  31.085  46.480  1.00 36.19           C  
ATOM    591  N   ASP A  79       8.031  38.279  45.417  1.00 25.27           N  
ATOM    592  CA  ASP A  79       8.112  39.653  44.917  1.00 23.84           C  
ATOM    593  C   ASP A  79       8.159  39.764  43.391  1.00 19.74           C  
ATOM    594  O   ASP A  79       7.555  40.663  42.808  1.00 16.58           O  
ATOM    595  CB  ASP A  79       9.352  40.347  45.496  1.00 28.77           C  
ATOM    596  CG  ASP A  79       9.349  40.405  47.024  1.00 31.63           C  
ATOM    597  OD1 ASP A  79      10.387  40.811  47.592  1.00 34.89           O  
ATOM    598  OD2 ASP A  79       8.329  40.058  47.654  1.00 31.59           O  
ATOM    599  N   GLY A  80       8.893  38.862  42.749  1.00 17.58           N  
ATOM    600  CA  GLY A  80       8.995  38.901  41.299  1.00 15.63           C  
ATOM    601  C   GLY A  80       7.697  38.602  40.562  1.00 14.43           C  
ATOM    602  O   GLY A  80       7.612  38.821  39.351  1.00 13.32           O  
ATOM    603  N   TYR A  81       6.687  38.101  41.273  1.00 13.05           N  
ATOM    604  CA  TYR A  81       5.402  37.786  40.641  1.00 14.07           C  
ATOM    605  C   TYR A  81       4.366  38.843  40.963  1.00 13.76           C  
ATOM    606  O   TYR A  81       3.165  38.610  40.799  1.00 14.19           O  
ATOM    607  CB  TYR A  81       4.843  36.451  41.126  1.00 13.34           C  
ATOM    608  CG  TYR A  81       5.674  35.238  40.822  1.00 17.80           C  
ATOM    609  CD1 TYR A  81       6.740  34.881  41.644  1.00 17.33           C  
ATOM    610  CD2 TYR A  81       5.359  34.408  39.752  1.00 19.53           C  
ATOM    611  CE1 TYR A  81       7.467  33.722  41.414  1.00 17.80           C  
ATOM    612  CE2 TYR A  81       6.078  33.244  39.509  1.00 20.47           C  
ATOM    613  CZ  TYR A  81       7.130  32.906  40.346  1.00 21.31           C  
ATOM    614  OH  TYR A  81       7.839  31.748  40.118  1.00 21.82           O  
ATOM    615  N   ARG A  82       4.823  39.999  41.423  1.00 14.38           N  
ATOM    616  CA  ARG A  82       3.918  41.077  41.803  1.00 16.33           C  
ATOM    617  C   ARG A  82       2.893  41.510  40.759  1.00 14.69           C  
ATOM    618  O   ARG A  82       1.852  42.052  41.116  1.00 16.27           O  
ATOM    619  CB  ARG A  82       4.719  42.297  42.286  1.00 20.43           C  
ATOM    620  CG  ARG A  82       5.742  42.858  41.304  1.00 25.68           C  
ATOM    621  CD  ARG A  82       6.279  44.217  41.786  1.00 27.83           C  
ATOM    622  NE  ARG A  82       7.513  44.599  41.110  1.00 32.10           N  
ATOM    623  CZ  ARG A  82       8.670  43.965  41.267  1.00 33.46           C  
ATOM    624  NH1 ARG A  82       8.750  42.922  42.081  1.00 34.28           N  
ATOM    625  NH2 ARG A  82       9.752  44.367  40.610  1.00 35.60           N  
ATOM    626  N   HIS A  83       3.165  41.266  39.480  1.00 14.36           N  
ATOM    627  CA  HIS A  83       2.223  41.658  38.428  1.00 11.95           C  
ATOM    628  C   HIS A  83       1.392  40.477  37.926  1.00 10.90           C  
ATOM    629  O   HIS A  83       0.669  40.581  36.932  1.00  9.59           O  
ATOM    630  CB  HIS A  83       2.979  42.304  37.262  1.00 10.94           C  
ATOM    631  CG  HIS A  83       3.877  43.423  37.684  1.00 13.51           C  
ATOM    632  ND1 HIS A  83       3.396  44.586  38.246  1.00 14.16           N  
ATOM    633  CD2 HIS A  83       5.229  43.529  37.699  1.00 13.22           C  
ATOM    634  CE1 HIS A  83       4.412  45.357  38.592  1.00 14.23           C  
ATOM    635  NE2 HIS A  83       5.535  44.740  38.271  1.00 13.70           N  
ATOM    636  N   THR A  84       1.501  39.350  38.615  1.00 11.52           N  
ATOM    637  CA  THR A  84       0.741  38.161  38.253  1.00 10.38           C  
ATOM    638  C   THR A  84      -0.192  37.798  39.422  1.00 10.75           C  
ATOM    639  O   THR A  84       0.241  37.726  40.575  1.00 11.50           O  
ATOM    640  CB  THR A  84       1.690  36.979  37.936  1.00  9.77           C  
ATOM    641  OG1 THR A  84       2.537  37.329  36.827  1.00  8.13           O  
ATOM    642  CG2 THR A  84       0.897  35.729  37.583  1.00  8.74           C  
ATOM    643  N   ARG A  85      -1.474  37.605  39.125  1.00 11.12           N  
ATOM    644  CA  ARG A  85      -2.463  37.253  40.148  1.00 11.98           C  
ATOM    645  C   ARG A  85      -3.288  36.043  39.707  1.00 12.72           C  
ATOM    646  O   ARG A  85      -3.521  35.852  38.512  1.00 12.92           O  
ATOM    647  CB  ARG A  85      -3.419  38.435  40.404  1.00 11.37           C  
ATOM    648  CG  ARG A  85      -2.750  39.719  40.922  1.00 13.15           C  
ATOM    649  CD  ARG A  85      -2.049  39.458  42.234  1.00 12.24           C  
ATOM    650  NE  ARG A  85      -1.334  40.618  42.770  1.00 13.83           N  
ATOM    651  CZ  ARG A  85      -0.101  40.551  43.263  1.00 13.55           C  
ATOM    652  NH1 ARG A  85       0.541  39.387  43.273  1.00 12.56           N  
ATOM    653  NH2 ARG A  85       0.481  41.630  43.765  1.00 10.33           N  
ATOM    654  N   GLU A  86      -3.706  35.217  40.667  1.00 11.08           N  
ATOM    655  CA  GLU A  86      -4.538  34.057  40.357  1.00 11.41           C  
ATOM    656  C   GLU A  86      -5.933  34.439  40.805  1.00 10.60           C  
ATOM    657  O   GLU A  86      -6.120  34.922  41.922  1.00 10.90           O  
ATOM    658  CB  GLU A  86      -4.088  32.807  41.120  1.00 12.44           C  
ATOM    659  CG  GLU A  86      -4.865  31.543  40.722  1.00 12.71           C  
ATOM    660  CD  GLU A  86      -4.419  30.309  41.491  1.00 14.57           C  
ATOM    661  OE1 GLU A  86      -3.237  30.257  41.888  1.00 14.96           O  
ATOM    662  OE2 GLU A  86      -5.244  29.385  41.689  1.00 14.96           O  
ATOM    663  N   HIS A  87      -6.908  34.235  39.933  1.00 10.47           N  
ATOM    664  CA  HIS A  87      -8.276  34.591  40.259  1.00 11.61           C  
ATOM    665  C   HIS A  87      -9.167  33.377  40.431  1.00 12.11           C  
ATOM    666  O   HIS A  87      -8.841  32.273  40.000  1.00 12.48           O  
ATOM    667  CB  HIS A  87      -8.863  35.480  39.167  1.00 12.12           C  
ATOM    668  CG  HIS A  87      -9.141  34.754  37.891  1.00 13.16           C  
ATOM    669  ND1 HIS A  87      -8.139  34.298  37.060  1.00 11.54           N  
ATOM    670  CD2 HIS A  87     -10.307  34.370  37.321  1.00 11.97           C  
ATOM    671  CE1 HIS A  87      -8.677  33.662  36.035  1.00 13.78           C  
ATOM    672  NE2 HIS A  87      -9.992  33.693  36.168  1.00 14.83           N  
ATOM    673  N   SER A  88     -10.303  33.597  41.074  1.00 12.80           N  
ATOM    674  CA  SER A  88     -11.259  32.537  41.288  1.00 14.43           C  
ATOM    675  C   SER A  88     -12.624  33.182  41.207  1.00 11.98           C  
ATOM    676  O   SER A  88     -12.810  34.322  41.628  1.00 11.52           O  
ATOM    677  CB  SER A  88     -11.032  31.875  42.652  1.00 15.26           C  
ATOM    678  OG  SER A  88     -11.174  32.812  43.706  1.00 23.98           O  
ATOM    679  N   VAL A  89     -13.568  32.463  40.621  1.00 12.90           N  
ATOM    680  CA  VAL A  89     -14.928  32.958  40.471  1.00 11.74           C  
ATOM    681  C   VAL A  89     -15.858  31.865  40.950  1.00 12.18           C  
ATOM    682  O   VAL A  89     -15.662  30.697  40.622  1.00 11.60           O  
ATOM    683  CB  VAL A  89     -15.254  33.268  38.997  1.00 12.50           C  
ATOM    684  CG1 VAL A  89     -16.735  33.593  38.850  1.00 12.96           C  
ATOM    685  CG2 VAL A  89     -14.403  34.437  38.504  1.00 11.72           C  
ATOM    686  N   TYR A  90     -16.868  32.235  41.728  1.00 12.58           N  
ATOM    687  CA  TYR A  90     -17.815  31.245  42.220  1.00 11.56           C  
ATOM    688  C   TYR A  90     -19.247  31.701  42.006  1.00 11.48           C  
ATOM    689  O   TYR A  90     -19.620  32.794  42.403  1.00 10.94           O  
ATOM    690  CB  TYR A  90     -17.628  30.979  43.715  1.00 12.87           C  
ATOM    691  CG  TYR A  90     -16.239  30.586  44.137  1.00 14.77           C  
ATOM    692  CD1 TYR A  90     -15.284  31.559  44.435  1.00 14.58           C  
ATOM    693  CD2 TYR A  90     -15.892  29.246  44.298  1.00 13.28           C  
ATOM    694  CE1 TYR A  90     -14.021  31.209  44.892  1.00 16.83           C  
ATOM    695  CE2 TYR A  90     -14.630  28.883  44.754  1.00 17.09           C  
ATOM    696  CZ  TYR A  90     -13.700  29.870  45.054  1.00 18.28           C  
ATOM    697  OH  TYR A  90     -12.457  29.523  45.540  1.00 19.19           O  
ATOM    698  N   VAL A  91     -20.042  30.856  41.371  1.00 11.99           N  
ATOM    699  CA  VAL A  91     -21.436  31.178  41.153  1.00 13.65           C  
ATOM    700  C   VAL A  91     -22.260  30.278  42.071  1.00 13.97           C  
ATOM    701  O   VAL A  91     -22.019  29.068  42.158  1.00 13.36           O  
ATOM    702  CB  VAL A  91     -21.834  30.951  39.686  1.00 15.91           C  
ATOM    703  CG1 VAL A  91     -23.297  31.335  39.478  1.00 13.88           C  
ATOM    704  CG2 VAL A  91     -20.933  31.797  38.767  1.00 14.91           C  
ATOM    705  N   HIS A  92     -23.215  30.875  42.775  1.00 13.30           N  
ATOM    706  CA  HIS A  92     -24.076  30.127  43.688  1.00 13.73           C  
ATOM    707  C   HIS A  92     -24.756  29.006  42.904  1.00 14.53           C  
ATOM    708  O   HIS A  92     -25.221  29.220  41.788  1.00 13.82           O  
ATOM    709  CB  HIS A  92     -25.125  31.063  44.300  1.00 13.70           C  
ATOM    710  CG  HIS A  92     -25.916  30.442  45.411  1.00 15.50           C  
ATOM    711  ND1 HIS A  92     -26.769  29.378  45.213  1.00 13.21           N  
ATOM    712  CD2 HIS A  92     -26.005  30.754  46.727  1.00 15.39           C  
ATOM    713  CE1 HIS A  92     -27.352  29.063  46.357  1.00 16.11           C  
ATOM    714  NE2 HIS A  92     -26.905  29.883  47.291  1.00 15.97           N  
ATOM    715  N   LYS A  93     -24.814  27.816  43.495  1.00 14.91           N  
ATOM    716  CA  LYS A  93     -25.412  26.653  42.849  1.00 17.04           C  
ATOM    717  C   LYS A  93     -26.837  26.846  42.340  1.00 18.12           C  
ATOM    718  O   LYS A  93     -27.246  26.199  41.376  1.00 16.02           O  
ATOM    719  CB  LYS A  93     -25.378  25.455  43.799  1.00 19.35           C  
ATOM    720  CG  LYS A  93     -26.164  25.654  45.080  1.00 18.86           C  
ATOM    721  CD  LYS A  93     -26.023  24.430  45.997  1.00 20.44           C  
ATOM    722  CE  LYS A  93     -26.739  24.639  47.321  1.00 19.73           C  
ATOM    723  NZ  LYS A  93     -26.568  23.481  48.217  1.00 21.20           N  
ATOM    724  N   ASP A  94     -27.592  27.734  42.979  1.00 17.98           N  
ATOM    725  CA  ASP A  94     -28.971  27.980  42.569  1.00 18.73           C  
ATOM    726  C   ASP A  94     -29.118  29.195  41.660  1.00 17.92           C  
ATOM    727  O   ASP A  94     -30.237  29.625  41.381  1.00 20.59           O  
ATOM    728  CB  ASP A  94     -29.877  28.168  43.796  1.00 19.23           C  
ATOM    729  CG  ASP A  94     -29.967  26.918  44.666  1.00 22.03           C  
ATOM    730  OD1 ASP A  94     -29.958  25.793  44.119  1.00 24.15           O  
ATOM    731  OD2 ASP A  94     -30.066  27.067  45.900  1.00 21.51           O  
ATOM    732  N   ALA A  95     -27.999  29.746  41.197  1.00 16.98           N  
ATOM    733  CA  ALA A  95     -28.037  30.920  40.326  1.00 17.07           C  
ATOM    734  C   ALA A  95     -27.228  30.714  39.051  1.00 16.93           C  
ATOM    735  O   ALA A  95     -26.705  31.669  38.475  1.00 17.17           O  
ATOM    736  CB  ALA A  95     -27.519  32.145  41.072  1.00 14.90           C  
ATOM    737  N   ARG A  96     -27.140  29.466  38.614  1.00 17.63           N  
ATOM    738  CA  ARG A  96     -26.404  29.119  37.412  1.00 19.53           C  
ATOM    739  C   ARG A  96     -27.226  29.434  36.169  1.00 20.84           C  
ATOM    740  O   ARG A  96     -28.449  29.556  36.242  1.00 17.57           O  
ATOM    741  CB  ARG A  96     -26.060  27.632  37.432  1.00 21.56           C  
ATOM    742  CG  ARG A  96     -25.308  27.199  38.670  1.00 24.51           C  
ATOM    743  CD  ARG A  96     -23.906  27.774  38.678  1.00 27.54           C  
ATOM    744  NE  ARG A  96     -23.146  27.300  37.525  1.00 32.57           N  
ATOM    745  CZ  ARG A  96     -21.833  27.437  37.383  1.00 31.20           C  
ATOM    746  NH1 ARG A  96     -21.120  28.039  38.323  1.00 36.21           N  
ATOM    747  NH2 ARG A  96     -21.231  26.969  36.301  1.00 32.08           N  
ATOM    748  N   GLY A  97     -26.549  29.574  35.029  1.00 21.16           N  
ATOM    749  CA  GLY A  97     -27.239  29.851  33.777  1.00 22.29           C  
ATOM    750  C   GLY A  97     -27.729  31.275  33.581  1.00 24.30           C  
ATOM    751  O   GLY A  97     -28.557  31.526  32.705  1.00 23.51           O  
ATOM    752  N   HIS A  98     -27.220  32.204  34.390  1.00 23.88           N  
ATOM    753  CA  HIS A  98     -27.607  33.613  34.303  1.00 23.46           C  
ATOM    754  C   HIS A  98     -26.450  34.492  33.841  1.00 22.32           C  
ATOM    755  O   HIS A  98     -26.520  35.713  33.934  1.00 21.74           O  
ATOM    756  CB  HIS A  98     -28.104  34.120  35.660  1.00 23.85           C  
ATOM    757  CG  HIS A  98     -29.398  33.507  36.096  1.00 27.09           C  
ATOM    758  ND1 HIS A  98     -29.615  33.059  37.382  1.00 26.27           N  
ATOM    759  CD2 HIS A  98     -30.540  33.256  35.412  1.00 26.28           C  
ATOM    760  CE1 HIS A  98     -30.832  32.553  37.470  1.00 25.55           C  
ATOM    761  NE2 HIS A  98     -31.414  32.661  36.290  1.00 25.74           N  
ATOM    762  N   GLY A  99     -25.386  33.865  33.347  1.00 21.65           N  
ATOM    763  CA  GLY A  99     -24.238  34.625  32.881  1.00 21.33           C  
ATOM    764  C   GLY A  99     -23.456  35.320  33.987  1.00 20.17           C  
ATOM    765  O   GLY A  99     -22.606  36.172  33.718  1.00 18.18           O  
ATOM    766  N   ILE A 100     -23.737  34.952  35.233  1.00 18.22           N  
ATOM    767  CA  ILE A 100     -23.056  35.546  36.373  1.00 16.16           C  
ATOM    768  C   ILE A 100     -21.550  35.283  36.329  1.00 15.71           C  
ATOM    769  O   ILE A 100     -20.750  36.190  36.561  1.00 14.93           O  
ATOM    770  CB  ILE A 100     -23.636  35.004  37.716  1.00 16.88           C  
ATOM    771  CG1 ILE A 100     -25.105  35.426  37.854  1.00 15.02           C  
ATOM    772  CG2 ILE A 100     -22.817  35.528  38.894  1.00 14.63           C  
ATOM    773  CD1 ILE A 100     -25.776  34.987  39.148  1.00 13.10           C  
ATOM    774  N   GLY A 101     -21.168  34.047  36.016  1.00 15.49           N  
ATOM    775  CA  GLY A 101     -19.758  33.709  35.956  1.00 14.17           C  
ATOM    776  C   GLY A 101     -18.946  34.626  35.051  1.00 14.03           C  
ATOM    777  O   GLY A 101     -17.934  35.195  35.465  1.00 13.14           O  
ATOM    778  N   LYS A 102     -19.395  34.779  33.812  1.00 13.49           N  
ATOM    779  CA  LYS A 102     -18.695  35.620  32.849  1.00 13.40           C  
ATOM    780  C   LYS A 102     -18.621  37.067  33.313  1.00 12.70           C  
ATOM    781  O   LYS A 102     -17.577  37.703  33.207  1.00 14.33           O  
ATOM    782  CB  LYS A 102     -19.386  35.560  31.481  1.00 12.53           C  
ATOM    783  CG  LYS A 102     -18.529  36.099  30.343  1.00 14.70           C  
ATOM    784  CD  LYS A 102     -19.207  35.953  28.994  1.00 15.81           C  
ATOM    785  CE  LYS A 102     -18.333  36.528  27.885  1.00 18.67           C  
ATOM    786  NZ  LYS A 102     -19.027  36.598  26.559  1.00 18.44           N  
ATOM    787  N   ARG A 103     -19.722  37.585  33.837  1.00 12.65           N  
ATOM    788  CA  ARG A 103     -19.741  38.965  34.294  1.00 11.10           C  
ATOM    789  C   ARG A 103     -18.786  39.171  35.457  1.00 10.04           C  
ATOM    790  O   ARG A 103     -18.125  40.200  35.536  1.00 10.06           O  
ATOM    791  CB  ARG A 103     -21.154  39.371  34.691  1.00 15.76           C  
ATOM    792  CG  ARG A 103     -22.125  39.377  33.521  1.00 20.65           C  
ATOM    793  CD  ARG A 103     -23.539  39.696  33.978  1.00 23.13           C  
ATOM    794  NE  ARG A 103     -23.626  40.996  34.634  1.00 25.89           N  
ATOM    795  CZ  ARG A 103     -24.731  41.473  35.197  1.00 26.52           C  
ATOM    796  NH1 ARG A 103     -25.843  40.752  35.180  1.00 26.93           N  
ATOM    797  NH2 ARG A 103     -24.725  42.668  35.776  1.00 26.05           N  
ATOM    798  N   LEU A 104     -18.708  38.198  36.358  1.00  9.94           N  
ATOM    799  CA  LEU A 104     -17.803  38.312  37.494  1.00  9.74           C  
ATOM    800  C   LEU A 104     -16.358  38.296  37.025  1.00  9.61           C  
ATOM    801  O   LEU A 104     -15.535  39.079  37.501  1.00  8.26           O  
ATOM    802  CB  LEU A 104     -18.020  37.165  38.485  1.00  7.54           C  
ATOM    803  CG  LEU A 104     -19.215  37.312  39.425  1.00  8.48           C  
ATOM    804  CD1 LEU A 104     -19.407  36.016  40.207  1.00  9.01           C  
ATOM    805  CD2 LEU A 104     -18.992  38.488  40.369  1.00  9.10           C  
HETATM  806  N   MSE A 105     -16.042  37.411  36.085  1.00 10.70           N  
HETATM  807  CA  MSE A 105     -14.666  37.325  35.600  1.00 12.63           C  
HETATM  808  C   MSE A 105     -14.282  38.564  34.817  1.00 12.75           C  
HETATM  809  O   MSE A 105     -13.135  39.006  34.864  1.00 13.72           O  
HETATM  810  CB  MSE A 105     -14.474  36.084  34.729  1.00 13.57           C  
HETATM  811  CG  MSE A 105     -13.010  35.699  34.557  1.00 18.07           C  
HETATM  812 SE   MSE A 105     -12.841  33.919  33.797  1.00 27.33          SE  
HETATM  813  CE  MSE A 105     -13.524  32.905  35.302  1.00 24.72           C  
ATOM    814  N   GLN A 106     -15.239  39.124  34.086  1.00 13.69           N  
ATOM    815  CA  GLN A 106     -14.960  40.326  33.315  1.00 14.88           C  
ATOM    816  C   GLN A 106     -14.647  41.460  34.291  1.00 13.85           C  
ATOM    817  O   GLN A 106     -13.745  42.260  34.061  1.00 13.63           O  
ATOM    818  CB  GLN A 106     -16.163  40.683  32.442  1.00 17.54           C  
ATOM    819  CG  GLN A 106     -15.937  41.891  31.554  1.00 17.72           C  
ATOM    820  CD  GLN A 106     -14.739  41.719  30.641  1.00 21.26           C  
ATOM    821  OE1 GLN A 106     -14.706  40.821  29.794  1.00 21.78           O  
ATOM    822  NE2 GLN A 106     -13.740  42.583  30.811  1.00 19.27           N  
ATOM    823  N   ALA A 107     -15.387  41.513  35.393  1.00 14.14           N  
ATOM    824  CA  ALA A 107     -15.175  42.543  36.400  1.00 12.98           C  
ATOM    825  C   ALA A 107     -13.765  42.426  36.992  1.00 13.93           C  
ATOM    826  O   ALA A 107     -13.107  43.439  37.255  1.00 14.70           O  
ATOM    827  CB  ALA A 107     -16.236  42.431  37.502  1.00 12.87           C  
ATOM    828  N   LEU A 108     -13.315  41.189  37.208  1.00 11.81           N  
ATOM    829  CA  LEU A 108     -11.981  40.924  37.739  1.00 14.39           C  
ATOM    830  C   LEU A 108     -10.932  41.372  36.718  1.00 13.57           C  
ATOM    831  O   LEU A 108      -9.894  41.938  37.077  1.00 14.91           O  
ATOM    832  CB  LEU A 108     -11.789  39.430  38.023  1.00 13.48           C  
ATOM    833  CG  LEU A 108     -12.575  38.792  39.163  1.00 15.01           C  
ATOM    834  CD1 LEU A 108     -12.155  37.332  39.294  1.00 14.54           C  
ATOM    835  CD2 LEU A 108     -12.301  39.539  40.478  1.00 15.42           C  
ATOM    836  N   ILE A 109     -11.208  41.106  35.446  1.00 12.14           N  
ATOM    837  CA  ILE A 109     -10.304  41.502  34.379  1.00 12.36           C  
ATOM    838  C   ILE A 109     -10.229  43.031  34.335  1.00 10.53           C  
ATOM    839  O   ILE A 109      -9.144  43.597  34.195  1.00 13.14           O  
ATOM    840  CB  ILE A 109     -10.775  40.950  33.009  1.00 10.74           C  
ATOM    841  CG1 ILE A 109     -10.571  39.436  32.965  1.00  8.06           C  
ATOM    842  CG2 ILE A 109     -10.002  41.633  31.873  1.00 11.04           C  
ATOM    843  CD1 ILE A 109     -11.310  38.733  31.825  1.00  6.11           C  
ATOM    844  N   ASP A 110     -11.367  43.700  34.481  1.00 12.95           N  
ATOM    845  CA  ASP A 110     -11.373  45.162  34.465  1.00 13.52           C  
ATOM    846  C   ASP A 110     -10.589  45.719  35.635  1.00 11.92           C  
ATOM    847  O   ASP A 110      -9.759  46.609  35.473  1.00 12.95           O  
ATOM    848  CB  ASP A 110     -12.796  45.718  34.518  1.00 17.10           C  
ATOM    849  CG  ASP A 110     -13.599  45.377  33.281  1.00 20.44           C  
ATOM    850  OD1 ASP A 110     -12.983  45.005  32.262  1.00 23.39           O  
ATOM    851  OD2 ASP A 110     -14.841  45.491  33.323  1.00 22.74           O  
ATOM    852  N   HIS A 111     -10.840  45.193  36.820  1.00 13.13           N  
ATOM    853  CA  HIS A 111     -10.134  45.684  37.989  1.00 10.41           C  
ATOM    854  C   HIS A 111      -8.631  45.472  37.823  1.00 10.16           C  
ATOM    855  O   HIS A 111      -7.840  46.380  38.060  1.00  9.48           O  
ATOM    856  CB  HIS A 111     -10.639  44.968  39.242  1.00 13.37           C  
ATOM    857  CG  HIS A 111     -10.031  45.477  40.511  1.00 13.94           C  
ATOM    858  ND1 HIS A 111      -8.766  45.118  40.927  1.00 12.75           N  
ATOM    859  CD2 HIS A 111     -10.496  46.355  41.431  1.00 11.68           C  
ATOM    860  CE1 HIS A 111      -8.477  45.757  42.047  1.00 10.62           C  
ATOM    861  NE2 HIS A 111      -9.510  46.514  42.374  1.00 11.72           N  
ATOM    862  N   ALA A 112      -8.246  44.268  37.409  1.00 10.82           N  
ATOM    863  CA  ALA A 112      -6.839  43.934  37.215  1.00 10.71           C  
ATOM    864  C   ALA A 112      -6.166  44.894  36.229  1.00 11.26           C  
ATOM    865  O   ALA A 112      -5.017  45.295  36.421  1.00 11.37           O  
ATOM    866  CB  ALA A 112      -6.717  42.499  36.713  1.00 10.18           C  
ATOM    867  N   GLY A 113      -6.889  45.263  35.179  1.00 10.98           N  
ATOM    868  CA  GLY A 113      -6.337  46.165  34.183  1.00 11.92           C  
ATOM    869  C   GLY A 113      -5.997  47.533  34.746  1.00 13.07           C  
ATOM    870  O   GLY A 113      -5.179  48.259  34.186  1.00 11.96           O  
ATOM    871  N   GLY A 114      -6.633  47.893  35.853  1.00 11.86           N  
ATOM    872  CA  GLY A 114      -6.360  49.182  36.456  1.00 11.74           C  
ATOM    873  C   GLY A 114      -5.583  49.037  37.743  1.00 12.65           C  
ATOM    874  O   GLY A 114      -5.379  50.009  38.477  1.00 14.11           O  
ATOM    875  N   ASN A 115      -5.135  47.820  38.023  1.00 11.72           N  
ATOM    876  CA  ASN A 115      -4.396  47.573  39.244  1.00 10.79           C  
ATOM    877  C   ASN A 115      -2.971  47.090  39.001  1.00 13.07           C  
ATOM    878  O   ASN A 115      -2.392  46.376  39.826  1.00 12.55           O  
ATOM    879  CB  ASN A 115      -5.162  46.571  40.099  1.00  9.01           C  
ATOM    880  CG  ASN A 115      -4.757  46.627  41.552  1.00 10.12           C  
ATOM    881  OD1 ASN A 115      -4.424  47.696  42.073  1.00 10.74           O  
ATOM    882  ND2 ASN A 115      -4.809  45.484  42.225  1.00  7.02           N  
ATOM    883  N   ASP A 116      -2.413  47.493  37.862  1.00 12.87           N  
ATOM    884  CA  ASP A 116      -1.046  47.140  37.501  1.00 15.55           C  
ATOM    885  C   ASP A 116      -0.822  45.631  37.563  1.00 15.92           C  
ATOM    886  O   ASP A 116       0.158  45.137  38.135  1.00 14.75           O  
ATOM    887  CB  ASP A 116      -0.072  47.865  38.432  1.00 17.06           C  
ATOM    888  CG  ASP A 116       1.340  47.949  37.867  1.00 19.95           C  
ATOM    889  OD1 ASP A 116       1.544  47.646  36.674  1.00 18.52           O  
ATOM    890  OD2 ASP A 116       2.246  48.338  38.633  1.00 21.72           O  
ATOM    891  N   VAL A 117      -1.765  44.901  36.989  1.00 14.14           N  
ATOM    892  CA  VAL A 117      -1.688  43.454  36.929  1.00 13.70           C  
ATOM    893  C   VAL A 117      -1.398  43.167  35.466  1.00 13.14           C  
ATOM    894  O   VAL A 117      -2.098  43.657  34.582  1.00 12.68           O  
ATOM    895  CB  VAL A 117      -3.016  42.819  37.354  1.00 12.76           C  
ATOM    896  CG1 VAL A 117      -2.978  41.319  37.108  1.00 17.42           C  
ATOM    897  CG2 VAL A 117      -3.266  43.104  38.833  1.00 12.79           C  
ATOM    898  N   HIS A 118      -0.349  42.396  35.209  1.00 12.10           N  
ATOM    899  CA  HIS A 118       0.033  42.094  33.838  1.00 11.78           C  
ATOM    900  C   HIS A 118      -0.522  40.760  33.372  1.00 11.52           C  
ATOM    901  O   HIS A 118      -0.880  40.601  32.210  1.00 11.62           O  
ATOM    902  CB  HIS A 118       1.560  42.093  33.719  1.00 11.30           C  
ATOM    903  CG  HIS A 118       2.062  41.929  32.320  1.00 11.34           C  
ATOM    904  ND1 HIS A 118       2.899  40.899  31.945  1.00 13.12           N  
ATOM    905  CD2 HIS A 118       1.891  42.692  31.214  1.00 12.98           C  
ATOM    906  CE1 HIS A 118       3.225  41.038  30.673  1.00  9.30           C  
ATOM    907  NE2 HIS A 118       2.627  42.119  30.207  1.00 13.64           N  
ATOM    908  N   VAL A 119      -0.586  39.794  34.280  1.00 12.19           N  
ATOM    909  CA  VAL A 119      -1.099  38.484  33.920  1.00 12.12           C  
ATOM    910  C   VAL A 119      -2.065  37.919  34.966  1.00 11.59           C  
ATOM    911  O   VAL A 119      -1.851  38.066  36.171  1.00 11.54           O  
ATOM    912  CB  VAL A 119       0.068  37.466  33.725  1.00 12.21           C  
ATOM    913  CG1 VAL A 119      -0.489  36.087  33.413  1.00 11.42           C  
ATOM    914  CG2 VAL A 119       0.998  37.924  32.594  1.00  7.44           C  
ATOM    915  N   LEU A 120      -3.138  37.298  34.491  1.00 10.60           N  
ATOM    916  CA  LEU A 120      -4.105  36.643  35.356  1.00 12.32           C  
ATOM    917  C   LEU A 120      -3.922  35.166  35.061  1.00 12.25           C  
ATOM    918  O   LEU A 120      -3.819  34.769  33.894  1.00 11.91           O  
ATOM    919  CB  LEU A 120      -5.540  37.045  35.013  1.00 12.57           C  
ATOM    920  CG  LEU A 120      -5.993  38.388  35.580  1.00 13.13           C  
ATOM    921  CD1 LEU A 120      -7.416  38.680  35.104  1.00 12.56           C  
ATOM    922  CD2 LEU A 120      -5.940  38.345  37.112  1.00 13.28           C  
ATOM    923  N   ILE A 121      -3.877  34.365  36.119  1.00 12.13           N  
ATOM    924  CA  ILE A 121      -3.687  32.922  36.016  1.00 12.63           C  
ATOM    925  C   ILE A 121      -4.913  32.165  36.516  1.00 12.46           C  
ATOM    926  O   ILE A 121      -5.448  32.475  37.581  1.00 12.86           O  
ATOM    927  CB  ILE A 121      -2.473  32.448  36.875  1.00 12.06           C  
ATOM    928  CG1 ILE A 121      -1.174  33.074  36.364  1.00 11.82           C  
ATOM    929  CG2 ILE A 121      -2.353  30.926  36.814  1.00 13.66           C  
ATOM    930  CD1 ILE A 121      -0.870  32.743  34.915  1.00  7.80           C  
ATOM    931  N   ALA A 122      -5.349  31.170  35.749  1.00 11.81           N  
ATOM    932  CA  ALA A 122      -6.484  30.346  36.144  1.00 13.18           C  
ATOM    933  C   ALA A 122      -5.971  28.935  36.432  1.00 13.95           C  
ATOM    934  O   ALA A 122      -5.210  28.371  35.640  1.00 14.32           O  
ATOM    935  CB  ALA A 122      -7.533  30.308  35.029  1.00 12.61           C  
ATOM    936  N   ALA A 123      -6.350  28.388  37.587  1.00 13.93           N  
ATOM    937  CA  ALA A 123      -5.967  27.030  37.974  1.00 13.18           C  
ATOM    938  C   ALA A 123      -7.294  26.289  38.020  1.00 12.77           C  
ATOM    939  O   ALA A 123      -8.036  26.379  38.993  1.00 13.74           O  
ATOM    940  CB  ALA A 123      -5.303  27.021  39.344  1.00 15.11           C  
ATOM    941  N   ILE A 124      -7.587  25.557  36.954  1.00 12.65           N  
ATOM    942  CA  ILE A 124      -8.854  24.851  36.832  1.00 13.00           C  
ATOM    943  C   ILE A 124      -8.727  23.332  36.917  1.00 12.92           C  
ATOM    944  O   ILE A 124      -7.830  22.750  36.308  1.00 11.06           O  
ATOM    945  CB  ILE A 124      -9.506  25.210  35.485  1.00 12.60           C  
ATOM    946  CG1 ILE A 124      -9.619  26.735  35.372  1.00 10.92           C  
ATOM    947  CG2 ILE A 124     -10.848  24.506  35.347  1.00 10.39           C  
ATOM    948  CD1 ILE A 124      -9.787  27.255  33.948  1.00 12.06           C  
ATOM    949  N   GLU A 125      -9.615  22.693  37.679  1.00 11.58           N  
ATOM    950  CA  GLU A 125      -9.578  21.237  37.773  1.00 12.35           C  
ATOM    951  C   GLU A 125      -9.828  20.768  36.338  1.00 13.07           C  
ATOM    952  O   GLU A 125     -10.823  21.145  35.714  1.00 14.04           O  
ATOM    953  CB  GLU A 125     -10.654  20.723  38.739  1.00 11.44           C  
ATOM    954  CG  GLU A 125     -10.608  19.224  38.966  1.00  9.91           C  
ATOM    955  CD  GLU A 125     -11.593  18.487  38.090  1.00 13.40           C  
ATOM    956  OE1 GLU A 125     -12.804  18.715  38.267  1.00 14.22           O  
ATOM    957  OE2 GLU A 125     -11.169  17.687  37.229  1.00 12.62           O  
ATOM    958  N   ALA A 126      -8.899  19.964  35.824  1.00 14.55           N  
ATOM    959  CA  ALA A 126      -8.911  19.471  34.444  1.00 16.83           C  
ATOM    960  C   ALA A 126     -10.230  19.098  33.758  1.00 16.71           C  
ATOM    961  O   ALA A 126     -10.481  19.526  32.628  1.00 16.54           O  
ATOM    962  CB  ALA A 126      -7.935  18.313  34.321  1.00 18.17           C  
ATOM    963  N   GLU A 127     -11.063  18.304  34.420  1.00 14.45           N  
ATOM    964  CA  GLU A 127     -12.327  17.870  33.821  1.00 15.71           C  
ATOM    965  C   GLU A 127     -13.427  18.926  33.838  1.00 13.47           C  
ATOM    966  O   GLU A 127     -14.499  18.711  33.281  1.00 11.52           O  
ATOM    967  CB  GLU A 127     -12.844  16.610  34.518  1.00 18.29           C  
ATOM    968  CG  GLU A 127     -11.873  15.451  34.489  1.00 24.63           C  
ATOM    969  CD  GLU A 127     -11.394  15.134  33.087  1.00 28.38           C  
ATOM    970  OE1 GLU A 127     -12.238  15.040  32.175  1.00 32.61           O  
ATOM    971  OE2 GLU A 127     -10.175  14.967  32.893  1.00 32.18           O  
ATOM    972  N   ASN A 128     -13.168  20.065  34.473  1.00 13.49           N  
ATOM    973  CA  ASN A 128     -14.176  21.116  34.525  1.00 13.03           C  
ATOM    974  C   ASN A 128     -14.181  21.882  33.206  1.00 13.05           C  
ATOM    975  O   ASN A 128     -13.710  23.014  33.127  1.00 11.86           O  
ATOM    976  CB  ASN A 128     -13.905  22.089  35.669  1.00 13.35           C  
ATOM    977  CG  ASN A 128     -15.116  22.948  35.988  1.00 14.64           C  
ATOM    978  OD1 ASN A 128     -15.905  23.286  35.099  1.00 11.82           O  
ATOM    979  ND2 ASN A 128     -15.268  23.311  37.254  1.00 13.23           N  
ATOM    980  N   THR A 129     -14.730  21.247  32.178  1.00 13.85           N  
ATOM    981  CA  THR A 129     -14.800  21.830  30.847  1.00 13.69           C  
ATOM    982  C   THR A 129     -15.557  23.151  30.800  1.00 13.05           C  
ATOM    983  O   THR A 129     -15.174  24.069  30.072  1.00 15.24           O  
ATOM    984  CB  THR A 129     -15.463  20.841  29.876  1.00 13.87           C  
ATOM    985  OG1 THR A 129     -14.733  19.615  29.890  1.00 17.88           O  
ATOM    986  CG2 THR A 129     -15.489  21.398  28.462  1.00 16.18           C  
ATOM    987  N   ALA A 130     -16.633  23.242  31.575  1.00 13.86           N  
ATOM    988  CA  ALA A 130     -17.441  24.458  31.621  1.00 13.01           C  
ATOM    989  C   ALA A 130     -16.602  25.651  32.073  1.00 12.39           C  
ATOM    990  O   ALA A 130     -16.710  26.753  31.524  1.00 11.13           O  
ATOM    991  CB  ALA A 130     -18.631  24.266  32.563  1.00 13.25           C  
ATOM    992  N   SER A 131     -15.771  25.442  33.083  1.00 11.65           N  
ATOM    993  CA  SER A 131     -14.923  26.529  33.561  1.00 11.56           C  
ATOM    994  C   SER A 131     -13.895  26.862  32.481  1.00 10.14           C  
ATOM    995  O   SER A 131     -13.642  28.034  32.200  1.00 12.83           O  
ATOM    996  CB  SER A 131     -14.219  26.137  34.866  1.00 10.57           C  
ATOM    997  OG  SER A 131     -13.386  27.183  35.340  1.00 12.89           O  
ATOM    998  N   ILE A 132     -13.311  25.835  31.871  1.00  9.83           N  
ATOM    999  CA  ILE A 132     -12.318  26.057  30.824  1.00 10.65           C  
ATOM   1000  C   ILE A 132     -12.908  26.905  29.697  1.00 10.87           C  
ATOM   1001  O   ILE A 132     -12.301  27.893  29.270  1.00 11.73           O  
ATOM   1002  CB  ILE A 132     -11.790  24.711  30.276  1.00 10.48           C  
ATOM   1003  CG1 ILE A 132     -11.036  23.993  31.398  1.00 12.86           C  
ATOM   1004  CG2 ILE A 132     -10.851  24.938  29.085  1.00  8.04           C  
ATOM   1005  CD1 ILE A 132     -10.569  22.603  31.062  1.00 17.52           C  
ATOM   1006  N   ARG A 133     -14.103  26.540  29.241  1.00 12.41           N  
ATOM   1007  CA  ARG A 133     -14.771  27.280  28.174  1.00 12.07           C  
ATOM   1008  C   ARG A 133     -15.057  28.723  28.590  1.00 13.67           C  
ATOM   1009  O   ARG A 133     -14.888  29.655  27.791  1.00 14.37           O  
ATOM   1010  CB  ARG A 133     -16.077  26.580  27.778  1.00 11.06           C  
ATOM   1011  CG  ARG A 133     -15.879  25.174  27.223  1.00 10.38           C  
ATOM   1012  CD  ARG A 133     -17.213  24.491  26.968  1.00 14.33           C  
ATOM   1013  NE  ARG A 133     -17.985  25.133  25.901  1.00 16.51           N  
ATOM   1014  CZ  ARG A 133     -18.000  24.724  24.636  1.00 16.57           C  
ATOM   1015  NH1 ARG A 133     -17.286  23.668  24.265  1.00 16.37           N  
ATOM   1016  NH2 ARG A 133     -18.736  25.367  23.743  1.00 17.44           N  
ATOM   1017  N   LEU A 134     -15.489  28.915  29.835  1.00 13.87           N  
ATOM   1018  CA  LEU A 134     -15.781  30.265  30.325  1.00 13.79           C  
ATOM   1019  C   LEU A 134     -14.518  31.126  30.268  1.00 13.10           C  
ATOM   1020  O   LEU A 134     -14.569  32.280  29.854  1.00 11.94           O  
ATOM   1021  CB  LEU A 134     -16.321  30.227  31.771  1.00 14.44           C  
ATOM   1022  CG  LEU A 134     -16.461  31.591  32.469  1.00 15.42           C  
ATOM   1023  CD1 LEU A 134     -17.452  32.454  31.706  1.00 16.23           C  
ATOM   1024  CD2 LEU A 134     -16.931  31.402  33.904  1.00 17.89           C  
ATOM   1025  N   HIS A 135     -13.384  30.568  30.679  1.00 13.23           N  
ATOM   1026  CA  HIS A 135     -12.138  31.331  30.640  1.00 12.92           C  
ATOM   1027  C   HIS A 135     -11.745  31.626  29.191  1.00 12.17           C  
ATOM   1028  O   HIS A 135     -11.294  32.727  28.884  1.00 12.08           O  
ATOM   1029  CB  HIS A 135     -10.999  30.576  31.340  1.00 12.59           C  
ATOM   1030  CG  HIS A 135     -11.087  30.594  32.837  1.00 13.07           C  
ATOM   1031  ND1 HIS A 135     -11.952  29.789  33.543  1.00 13.81           N  
ATOM   1032  CD2 HIS A 135     -10.423  31.331  33.760  1.00 14.23           C  
ATOM   1033  CE1 HIS A 135     -11.816  30.023  34.837  1.00 15.44           C  
ATOM   1034  NE2 HIS A 135     -10.895  30.955  34.996  1.00 14.42           N  
ATOM   1035  N   GLU A 136     -11.931  30.645  28.306  1.00 12.94           N  
ATOM   1036  CA  GLU A 136     -11.597  30.820  26.894  1.00 12.92           C  
ATOM   1037  C   GLU A 136     -12.440  31.931  26.265  1.00 14.00           C  
ATOM   1038  O   GLU A 136     -11.944  32.722  25.465  1.00 14.10           O  
ATOM   1039  CB  GLU A 136     -11.807  29.508  26.117  1.00 13.98           C  
ATOM   1040  CG  GLU A 136     -10.884  28.360  26.554  1.00 15.08           C  
ATOM   1041  CD  GLU A 136     -11.177  27.038  25.843  1.00 14.72           C  
ATOM   1042  OE1 GLU A 136     -12.362  26.655  25.737  1.00 13.67           O  
ATOM   1043  OE2 GLU A 136     -10.218  26.367  25.403  1.00 14.58           O  
ATOM   1044  N   SER A 137     -13.714  31.999  26.637  1.00 16.52           N  
ATOM   1045  CA  SER A 137     -14.592  33.019  26.082  1.00 17.35           C  
ATOM   1046  C   SER A 137     -14.131  34.409  26.504  1.00 16.35           C  
ATOM   1047  O   SER A 137     -14.548  35.411  25.917  1.00 16.21           O  
ATOM   1048  CB  SER A 137     -16.030  32.804  26.540  1.00 18.96           C  
ATOM   1049  OG  SER A 137     -16.182  33.182  27.895  1.00 17.83           O  
ATOM   1050  N   LEU A 138     -13.274  34.470  27.517  1.00 14.87           N  
ATOM   1051  CA  LEU A 138     -12.766  35.749  27.990  1.00 14.12           C  
ATOM   1052  C   LEU A 138     -11.300  35.983  27.641  1.00 14.06           C  
ATOM   1053  O   LEU A 138     -10.651  36.875  28.191  1.00 14.23           O  
ATOM   1054  CB  LEU A 138     -12.995  35.892  29.501  1.00 15.73           C  
ATOM   1055  CG  LEU A 138     -14.470  36.148  29.847  1.00 14.91           C  
ATOM   1056  CD1 LEU A 138     -14.674  36.087  31.341  1.00 18.33           C  
ATOM   1057  CD2 LEU A 138     -14.890  37.511  29.308  1.00 15.67           C  
ATOM   1058  N   GLY A 139     -10.777  35.176  26.727  1.00 13.47           N  
ATOM   1059  CA  GLY A 139      -9.405  35.362  26.289  1.00 14.30           C  
ATOM   1060  C   GLY A 139      -8.301  34.542  26.917  1.00 15.18           C  
ATOM   1061  O   GLY A 139      -7.152  34.646  26.487  1.00 15.84           O  
ATOM   1062  N   PHE A 140      -8.621  33.734  27.924  1.00 14.45           N  
ATOM   1063  CA  PHE A 140      -7.596  32.916  28.560  1.00 13.76           C  
ATOM   1064  C   PHE A 140      -7.142  31.819  27.609  1.00 13.35           C  
ATOM   1065  O   PHE A 140      -7.929  31.304  26.809  1.00 11.68           O  
ATOM   1066  CB  PHE A 140      -8.120  32.279  29.856  1.00 13.33           C  
ATOM   1067  CG  PHE A 140      -8.206  33.233  31.019  1.00 12.37           C  
ATOM   1068  CD1 PHE A 140      -9.230  34.172  31.102  1.00 13.90           C  
ATOM   1069  CD2 PHE A 140      -7.250  33.199  32.029  1.00 13.86           C  
ATOM   1070  CE1 PHE A 140      -9.301  35.067  32.180  1.00 13.93           C  
ATOM   1071  CE2 PHE A 140      -7.312  34.089  33.107  1.00 13.55           C  
ATOM   1072  CZ  PHE A 140      -8.340  35.022  33.180  1.00 12.38           C  
ATOM   1073  N   ARG A 141      -5.866  31.473  27.683  1.00 12.96           N  
ATOM   1074  CA  ARG A 141      -5.344  30.412  26.837  1.00 14.57           C  
ATOM   1075  C   ARG A 141      -4.650  29.386  27.716  1.00 12.40           C  
ATOM   1076  O   ARG A 141      -4.103  29.716  28.767  1.00  8.60           O  
ATOM   1077  CB  ARG A 141      -4.385  30.975  25.787  1.00 15.50           C  
ATOM   1078  CG  ARG A 141      -5.076  31.928  24.824  1.00 20.68           C  
ATOM   1079  CD  ARG A 141      -4.117  32.499  23.808  1.00 24.08           C  
ATOM   1080  NE  ARG A 141      -4.751  33.542  23.008  1.00 25.71           N  
ATOM   1081  CZ  ARG A 141      -4.099  34.345  22.173  1.00 28.02           C  
ATOM   1082  NH1 ARG A 141      -2.782  34.227  22.022  1.00 29.15           N  
ATOM   1083  NH2 ARG A 141      -4.766  35.268  21.493  1.00 25.41           N  
ATOM   1084  N   VAL A 142      -4.700  28.139  27.272  1.00 11.10           N  
ATOM   1085  CA  VAL A 142      -4.108  27.034  27.993  1.00 12.30           C  
ATOM   1086  C   VAL A 142      -2.596  27.136  28.038  1.00 13.08           C  
ATOM   1087  O   VAL A 142      -1.957  27.510  27.052  1.00 13.27           O  
ATOM   1088  CB  VAL A 142      -4.492  25.690  27.330  1.00 14.07           C  
ATOM   1089  CG1 VAL A 142      -3.783  24.537  28.019  1.00 13.47           C  
ATOM   1090  CG2 VAL A 142      -6.007  25.496  27.389  1.00 15.42           C  
ATOM   1091  N   VAL A 143      -2.032  26.813  29.197  1.00 12.03           N  
ATOM   1092  CA  VAL A 143      -0.586  26.820  29.373  1.00 12.00           C  
ATOM   1093  C   VAL A 143      -0.156  25.360  29.401  1.00 11.79           C  
ATOM   1094  O   VAL A 143       0.780  24.956  28.711  1.00 11.49           O  
ATOM   1095  CB  VAL A 143      -0.169  27.518  30.694  1.00 11.43           C  
ATOM   1096  CG1 VAL A 143       1.327  27.297  30.956  1.00 10.14           C  
ATOM   1097  CG2 VAL A 143      -0.454  29.014  30.600  1.00 10.97           C  
ATOM   1098  N   GLY A 144      -0.867  24.567  30.193  1.00 12.50           N  
ATOM   1099  CA  GLY A 144      -0.550  23.153  30.298  1.00 13.20           C  
ATOM   1100  C   GLY A 144      -1.419  22.459  31.326  1.00 13.65           C  
ATOM   1101  O   GLY A 144      -2.235  23.098  31.989  1.00 12.56           O  
ATOM   1102  N   ARG A 145      -1.233  21.153  31.476  1.00 14.10           N  
ATOM   1103  CA  ARG A 145      -2.026  20.389  32.426  1.00 14.70           C  
ATOM   1104  C   ARG A 145      -1.154  19.499  33.302  1.00 14.99           C  
ATOM   1105  O   ARG A 145      -0.399  18.665  32.802  1.00 15.50           O  
ATOM   1106  CB  ARG A 145      -3.063  19.551  31.663  1.00 14.01           C  
ATOM   1107  CG  ARG A 145      -3.875  18.578  32.496  1.00 15.06           C  
ATOM   1108  CD  ARG A 145      -5.070  18.067  31.692  1.00 16.62           C  
ATOM   1109  NE  ARG A 145      -5.674  16.874  32.278  1.00 14.95           N  
ATOM   1110  CZ  ARG A 145      -6.828  16.338  31.882  1.00 16.16           C  
ATOM   1111  NH1 ARG A 145      -7.522  16.883  30.893  1.00 14.96           N  
ATOM   1112  NH2 ARG A 145      -7.287  15.246  32.476  1.00 15.98           N  
ATOM   1113  N   PHE A 146      -1.251  19.703  34.612  1.00 14.03           N  
ATOM   1114  CA  PHE A 146      -0.490  18.919  35.568  1.00 14.60           C  
ATOM   1115  C   PHE A 146      -1.251  17.644  35.882  1.00 15.14           C  
ATOM   1116  O   PHE A 146      -2.446  17.678  36.186  1.00 15.21           O  
ATOM   1117  CB  PHE A 146      -0.252  19.724  36.840  1.00 15.04           C  
ATOM   1118  CG  PHE A 146       0.589  20.949  36.630  1.00 16.59           C  
ATOM   1119  CD1 PHE A 146       0.026  22.126  36.139  1.00 18.10           C  
ATOM   1120  CD2 PHE A 146       1.950  20.927  36.919  1.00 19.19           C  
ATOM   1121  CE1 PHE A 146       0.804  23.260  35.941  1.00 17.30           C  
ATOM   1122  CE2 PHE A 146       2.737  22.057  36.725  1.00 19.11           C  
ATOM   1123  CZ  PHE A 146       2.163  23.226  36.235  1.00 20.24           C  
ATOM   1124  N   SER A 147      -0.549  16.519  35.823  1.00 14.75           N  
ATOM   1125  CA  SER A 147      -1.167  15.226  36.051  1.00 14.49           C  
ATOM   1126  C   SER A 147      -1.146  14.712  37.490  1.00 14.59           C  
ATOM   1127  O   SER A 147      -0.092  14.596  38.119  1.00 14.22           O  
ATOM   1128  CB  SER A 147      -0.532  14.189  35.119  1.00 16.10           C  
ATOM   1129  OG  SER A 147      -1.110  12.909  35.310  1.00 17.88           O  
ATOM   1130  N   GLU A 148      -2.341  14.417  37.990  1.00 11.75           N  
ATOM   1131  CA  GLU A 148      -2.545  13.885  39.326  1.00 11.75           C  
ATOM   1132  C   GLU A 148      -1.803  14.651  40.415  1.00 12.11           C  
ATOM   1133  O   GLU A 148      -1.216  14.055  41.312  1.00 12.60           O  
ATOM   1134  CB  GLU A 148      -2.153  12.402  39.351  1.00 12.66           C  
ATOM   1135  CG  GLU A 148      -2.776  11.601  38.207  1.00 14.83           C  
ATOM   1136  CD  GLU A 148      -2.404  10.123  38.226  1.00 18.43           C  
ATOM   1137  OE1 GLU A 148      -1.274   9.786  38.636  1.00 19.37           O  
ATOM   1138  OE2 GLU A 148      -3.242   9.300  37.808  1.00 21.28           O  
ATOM   1139  N   VAL A 149      -1.846  15.976  40.352  1.00 12.14           N  
ATOM   1140  CA  VAL A 149      -1.171  16.784  41.355  1.00 12.41           C  
ATOM   1141  C   VAL A 149      -2.062  17.029  42.568  1.00 14.70           C  
ATOM   1142  O   VAL A 149      -1.611  17.557  43.586  1.00 16.17           O  
ATOM   1143  CB  VAL A 149      -0.706  18.126  40.768  1.00 11.92           C  
ATOM   1144  CG1 VAL A 149       0.541  17.910  39.908  1.00 10.76           C  
ATOM   1145  CG2 VAL A 149      -1.823  18.737  39.915  1.00 10.65           C  
ATOM   1146  N   GLY A 150      -3.329  16.639  42.464  1.00 14.91           N  
ATOM   1147  CA  GLY A 150      -4.232  16.822  43.585  1.00 15.70           C  
ATOM   1148  C   GLY A 150      -5.071  15.591  43.857  1.00 15.88           C  
ATOM   1149  O   GLY A 150      -5.118  14.672  43.039  1.00 15.13           O  
ATOM   1150  N   THR A 151      -5.720  15.556  45.016  1.00 15.75           N  
ATOM   1151  CA  THR A 151      -6.590  14.437  45.356  1.00 16.29           C  
ATOM   1152  C   THR A 151      -7.803  14.931  46.131  1.00 15.09           C  
ATOM   1153  O   THR A 151      -7.699  15.827  46.966  1.00 16.61           O  
ATOM   1154  CB  THR A 151      -5.856  13.333  46.191  1.00 17.73           C  
ATOM   1155  OG1 THR A 151      -6.727  12.205  46.350  1.00 19.51           O  
ATOM   1156  CG2 THR A 151      -5.463  13.840  47.571  1.00 17.72           C  
ATOM   1157  N   LYS A 152      -8.962  14.370  45.808  1.00 13.93           N  
ATOM   1158  CA  LYS A 152     -10.212  14.711  46.476  1.00 14.31           C  
ATOM   1159  C   LYS A 152     -11.255  13.661  46.108  1.00 14.13           C  
ATOM   1160  O   LYS A 152     -11.200  13.082  45.026  1.00 14.03           O  
ATOM   1161  CB  LYS A 152     -10.707  16.098  46.052  1.00 13.11           C  
ATOM   1162  CG  LYS A 152     -11.793  16.637  46.977  1.00 15.06           C  
ATOM   1163  CD  LYS A 152     -12.185  18.088  46.694  1.00 13.79           C  
ATOM   1164  CE  LYS A 152     -13.244  18.534  47.710  1.00 16.01           C  
ATOM   1165  NZ  LYS A 152     -13.696  19.947  47.558  1.00 14.49           N  
ATOM   1166  N   PHE A 153     -12.197  13.406  47.008  1.00 15.96           N  
ATOM   1167  CA  PHE A 153     -13.238  12.415  46.753  1.00 17.10           C  
ATOM   1168  C   PHE A 153     -12.650  11.031  46.463  1.00 16.83           C  
ATOM   1169  O   PHE A 153     -13.268  10.223  45.770  1.00 17.09           O  
ATOM   1170  CB  PHE A 153     -14.114  12.852  45.568  1.00 17.99           C  
ATOM   1171  CG  PHE A 153     -14.681  14.231  45.709  1.00 19.86           C  
ATOM   1172  CD1 PHE A 153     -15.394  14.592  46.847  1.00 20.71           C  
ATOM   1173  CD2 PHE A 153     -14.506  15.174  44.705  1.00 20.25           C  
ATOM   1174  CE1 PHE A 153     -15.922  15.876  46.984  1.00 21.64           C  
ATOM   1175  CE2 PHE A 153     -15.031  16.465  44.831  1.00 21.73           C  
ATOM   1176  CZ  PHE A 153     -15.740  16.814  45.973  1.00 18.62           C  
ATOM   1177  N   GLY A 154     -11.457  10.766  46.984  1.00 19.06           N  
ATOM   1178  CA  GLY A 154     -10.827   9.471  46.777  1.00 19.08           C  
ATOM   1179  C   GLY A 154     -10.128   9.272  45.440  1.00 20.48           C  
ATOM   1180  O   GLY A 154      -9.663   8.172  45.150  1.00 20.30           O  
ATOM   1181  N   ARG A 155     -10.037  10.318  44.624  1.00 20.00           N  
ATOM   1182  CA  ARG A 155      -9.385  10.188  43.321  1.00 19.33           C  
ATOM   1183  C   ARG A 155      -8.350  11.275  43.024  1.00 16.87           C  
ATOM   1184  O   ARG A 155      -8.361  12.338  43.644  1.00 14.74           O  
ATOM   1185  CB  ARG A 155     -10.432  10.190  42.208  1.00 19.76           C  
ATOM   1186  CG  ARG A 155     -11.146  11.527  42.011  1.00 22.18           C  
ATOM   1187  CD  ARG A 155     -11.912  11.506  40.695  1.00 23.30           C  
ATOM   1188  NE  ARG A 155     -12.550  12.774  40.353  1.00 21.28           N  
ATOM   1189  CZ  ARG A 155     -13.596  13.289  40.989  1.00 23.77           C  
ATOM   1190  NH1 ARG A 155     -14.136  12.649  42.019  1.00 20.39           N  
ATOM   1191  NH2 ARG A 155     -14.118  14.441  40.576  1.00 22.15           N  
ATOM   1192  N   TRP A 156      -7.455  10.991  42.074  1.00 16.99           N  
ATOM   1193  CA  TRP A 156      -6.427  11.945  41.665  1.00 15.65           C  
ATOM   1194  C   TRP A 156      -7.074  12.983  40.762  1.00 15.11           C  
ATOM   1195  O   TRP A 156      -7.983  12.672  39.989  1.00 16.02           O  
ATOM   1196  CB  TRP A 156      -5.287  11.276  40.875  1.00 16.24           C  
ATOM   1197  CG  TRP A 156      -4.409  10.335  41.656  1.00 16.63           C  
ATOM   1198  CD1 TRP A 156      -4.319   8.985  41.494  1.00 16.11           C  
ATOM   1199  CD2 TRP A 156      -3.519  10.672  42.730  1.00 17.10           C  
ATOM   1200  NE1 TRP A 156      -3.431   8.454  42.402  1.00 19.70           N  
ATOM   1201  CE2 TRP A 156      -2.926   9.466  43.174  1.00 18.38           C  
ATOM   1202  CE3 TRP A 156      -3.168  11.868  43.362  1.00 16.88           C  
ATOM   1203  CZ2 TRP A 156      -2.000   9.426  44.223  1.00 17.95           C  
ATOM   1204  CZ3 TRP A 156      -2.246  11.829  44.406  1.00 18.08           C  
ATOM   1205  CH2 TRP A 156      -1.674  10.613  44.826  1.00 18.07           C  
ATOM   1206  N   LEU A 157      -6.586  14.212  40.857  1.00 14.22           N  
ATOM   1207  CA  LEU A 157      -7.094  15.313  40.055  1.00 12.38           C  
ATOM   1208  C   LEU A 157      -5.983  15.928  39.217  1.00 12.51           C  
ATOM   1209  O   LEU A 157      -4.827  15.987  39.646  1.00 12.66           O  
ATOM   1210  CB  LEU A 157      -7.671  16.396  40.957  1.00 11.44           C  
ATOM   1211  CG  LEU A 157      -8.810  15.984  41.890  1.00 12.27           C  
ATOM   1212  CD1 LEU A 157      -9.112  17.145  42.830  1.00 11.78           C  
ATOM   1213  CD2 LEU A 157     -10.040  15.607  41.077  1.00 12.46           C  
ATOM   1214  N   ASP A 158      -6.344  16.385  38.021  1.00 13.83           N  
ATOM   1215  CA  ASP A 158      -5.395  17.041  37.126  1.00 13.22           C  
ATOM   1216  C   ASP A 158      -5.695  18.526  37.212  1.00 14.43           C  
ATOM   1217  O   ASP A 158      -6.839  18.926  37.451  1.00 15.56           O  
ATOM   1218  CB  ASP A 158      -5.571  16.566  35.683  1.00 14.05           C  
ATOM   1219  CG  ASP A 158      -5.149  15.125  35.481  1.00 15.82           C  
ATOM   1220  OD1 ASP A 158      -4.476  14.565  36.366  1.00 15.77           O  
ATOM   1221  OD2 ASP A 158      -5.485  14.557  34.423  1.00 21.04           O  
ATOM   1222  N   LEU A 159      -4.668  19.342  37.021  1.00 13.32           N  
ATOM   1223  CA  LEU A 159      -4.823  20.786  37.092  1.00 13.55           C  
ATOM   1224  C   LEU A 159      -4.427  21.435  35.767  1.00 15.27           C  
ATOM   1225  O   LEU A 159      -3.271  21.344  35.346  1.00 15.18           O  
ATOM   1226  CB  LEU A 159      -3.957  21.353  38.227  1.00 11.85           C  
ATOM   1227  CG  LEU A 159      -4.204  22.816  38.591  1.00 10.44           C  
ATOM   1228  CD1 LEU A 159      -5.608  22.936  39.161  1.00 11.02           C  
ATOM   1229  CD2 LEU A 159      -3.173  23.309  39.612  1.00 11.28           C  
ATOM   1230  N   THR A 160      -5.395  22.060  35.098  1.00 14.13           N  
ATOM   1231  CA  THR A 160      -5.130  22.747  33.834  1.00 14.13           C  
ATOM   1232  C   THR A 160      -5.015  24.228  34.141  1.00 13.54           C  
ATOM   1233  O   THR A 160      -5.951  24.842  34.658  1.00 13.17           O  
ATOM   1234  CB  THR A 160      -6.266  22.520  32.804  1.00 14.96           C  
ATOM   1235  OG1 THR A 160      -6.200  21.174  32.313  1.00 17.50           O  
ATOM   1236  CG2 THR A 160      -6.142  23.486  31.629  1.00 13.52           C  
ATOM   1237  N   CYS A 161      -3.855  24.798  33.849  1.00 12.80           N  
ATOM   1238  CA  CYS A 161      -3.651  26.206  34.104  1.00 12.73           C  
ATOM   1239  C   CYS A 161      -3.771  26.993  32.814  1.00 11.76           C  
ATOM   1240  O   CYS A 161      -3.415  26.513  31.729  1.00 11.87           O  
ATOM   1241  CB  CYS A 161      -2.295  26.440  34.767  1.00 12.18           C  
ATOM   1242  SG  CYS A 161      -2.138  25.674  36.414  1.00 18.86           S  
HETATM 1243  N   MSE A 162      -4.293  28.202  32.950  1.00 10.86           N  
HETATM 1244  CA  MSE A 162      -4.509  29.085  31.821  1.00 11.05           C  
HETATM 1245  C   MSE A 162      -4.041  30.483  32.190  1.00 10.35           C  
HETATM 1246  O   MSE A 162      -3.952  30.827  33.367  1.00 11.09           O  
HETATM 1247  CB  MSE A 162      -5.997  29.110  31.460  1.00 11.34           C  
HETATM 1248  CG  MSE A 162      -6.604  27.742  31.189  1.00 13.11           C  
HETATM 1249 SE   MSE A 162      -8.461  27.900  30.618  1.00 17.78          SE  
HETATM 1250  CE  MSE A 162      -8.206  28.365  28.775  1.00 10.56           C  
ATOM   1251  N   GLU A 163      -3.758  31.289  31.176  1.00 10.55           N  
ATOM   1252  CA  GLU A 163      -3.267  32.635  31.406  1.00  9.69           C  
ATOM   1253  C   GLU A 163      -3.926  33.667  30.503  1.00 10.38           C  
ATOM   1254  O   GLU A 163      -4.336  33.369  29.378  1.00 10.18           O  
ATOM   1255  CB  GLU A 163      -1.752  32.669  31.177  1.00  9.17           C  
ATOM   1256  CG  GLU A 163      -1.378  32.510  29.709  1.00 11.12           C  
ATOM   1257  CD  GLU A 163       0.111  32.293  29.467  1.00 13.96           C  
ATOM   1258  OE1 GLU A 163       0.935  32.650  30.342  1.00 15.80           O  
ATOM   1259  OE2 GLU A 163       0.460  31.772  28.388  1.00 13.30           O  
ATOM   1260  N   LEU A 164      -4.009  34.886  31.025  1.00 11.26           N  
ATOM   1261  CA  LEU A 164      -4.562  36.033  30.321  1.00 12.25           C  
ATOM   1262  C   LEU A 164      -3.584  37.180  30.539  1.00 12.81           C  
ATOM   1263  O   LEU A 164      -3.406  37.652  31.661  1.00 12.15           O  
ATOM   1264  CB  LEU A 164      -5.928  36.429  30.887  1.00 10.72           C  
ATOM   1265  CG  LEU A 164      -6.528  37.693  30.256  1.00 13.00           C  
ATOM   1266  CD1 LEU A 164      -6.616  37.521  28.744  1.00 14.58           C  
ATOM   1267  CD2 LEU A 164      -7.913  37.960  30.834  1.00 15.22           C  
ATOM   1268  N   LYS A 165      -2.942  37.620  29.468  1.00 14.68           N  
ATOM   1269  CA  LYS A 165      -1.990  38.712  29.566  1.00 17.32           C  
ATOM   1270  C   LYS A 165      -2.758  40.011  29.347  1.00 18.36           C  
ATOM   1271  O   LYS A 165      -3.491  40.142  28.370  1.00 17.67           O  
ATOM   1272  CB  LYS A 165      -0.895  38.540  28.510  1.00 17.10           C  
ATOM   1273  CG  LYS A 165       0.249  39.546  28.594  1.00 21.01           C  
ATOM   1274  CD  LYS A 165       1.294  39.290  27.500  1.00 22.51           C  
ATOM   1275  CE  LYS A 165       1.900  37.902  27.626  1.00 23.95           C  
ATOM   1276  NZ  LYS A 165       2.833  37.583  26.499  1.00 27.77           N  
ATOM   1277  N   LEU A 166      -2.619  40.950  30.279  1.00 20.24           N  
ATOM   1278  CA  LEU A 166      -3.297  42.244  30.188  1.00 25.69           C  
ATOM   1279  C   LEU A 166      -2.363  43.307  29.625  1.00 27.35           C  
ATOM   1280  O   LEU A 166      -2.834  44.140  28.824  1.00 30.91           O  
ATOM   1281  CB  LEU A 166      -3.804  42.701  31.562  1.00 24.29           C  
ATOM   1282  CG  LEU A 166      -5.047  42.039  32.160  1.00 27.12           C  
ATOM   1283  CD1 LEU A 166      -4.750  40.590  32.492  1.00 27.13           C  
ATOM   1284  CD2 LEU A 166      -5.467  42.782  33.425  1.00 26.77           C  
TER    1285      LEU A 166                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
