
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  165 ( 1235),  selected  165 , name 1jtg_D
# Molecule2: number of CA atoms  162 ( 1249),  selected  162 , name T0399.pdb
# PARAMETERS: 1jtg_D.T0399.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_D      K      45           -
LGA    G     2_D      T      46           -
LGA    V     3_D      E      47           -
LGA    M     4_D      N      48           -
LGA    -       -      L      49           -
LGA    -       -      D      50           -
LGA    T     5_D      F      51          1.637
LGA    G     6_D      R      52          1.710
LGA    A     7_D      L      53          3.717
LGA    K     8_D      S      54          3.186
LGA    F     9_D      F      55          1.984
LGA    T    10_D      N      56          3.092
LGA    Q    11_D      K      57          3.682
LGA    I    12_D      I      58          3.551
LGA    Q    13_D      K      59          3.860
LGA    F    14_D      V      60          3.975
LGA    -       -      T      61           -
LGA    -       -      T      62           -
LGA    -       -      D      63           -
LGA    -       -      Q      64           -
LGA    -       -      N      65           -
LGA    -       -      H      66           -
LGA    -       -      F      67           -
LGA    -       -      S      68           -
LGA    -       -      G      69           -
LGA    G    15_D      G      70          1.792
LGA    M    16_D      T      71          2.422
LGA    T    17_D      S      72          2.150
LGA    R    18_D      I      73          2.343
LGA    Q    19_D      E      74          3.558
LGA    Q    20_D      Q      75          2.979
LGA    V    21_D      L      76          1.722
LGA    L    22_D      K      77          2.934
LGA    D    23_D      Q      78          3.826
LGA    I    24_D      W      79          2.486
LGA    A    25_D      F      80          1.378
LGA    G    26_D      G      81          1.922
LGA    A    27_D      D      82          1.326
LGA    E    28_D      P      83          5.044
LGA    N    29_D      N      84          3.386
LGA    C    30_D      -       -           -
LGA    E    31_D      K      85          0.761
LGA    T    32_D      S      86          1.788
LGA    G    33_D      E      87          2.675
LGA    G    34_D      -       -           -
LGA    S    35_D      -       -           -
LGA    F    36_D      -       -           -
LGA    G    37_D      Q      88          5.149
LGA    D    38_D      R      89          3.613
LGA    -       -      N      90           -
LGA    -       -      A      91           -
LGA    -       -      G      92           -
LGA    -       -      N      93           -
LGA    -       -      I      94           -
LGA    -       -      T      95           -
LGA    -       -      L      96           -
LGA    -       -      D      97           -
LGA    S    39_D      S      98          1.441
LGA    I    40_D      Y      99          1.038
LGA    H    41_D      T     100          1.522
LGA    C    42_D      W     101          1.169
LGA    R    43_D      V     102          0.845
LGA    G    44_D      K     103          1.407
LGA    H    45_D      D     104          0.373
LGA    A    46_D      G     105          2.848
LGA    A    47_D      -       -           -
LGA    G    48_D      -       -           -
LGA    D    49_D      -       -           -
LGA    Y    50_D      -       -           -
LGA    Y    51_D      -       -           -
LGA    A    52_D      A     106          1.205
LGA    Y    53_D      V     107          1.014
LGA    A    54_D      I     108          0.830
LGA    T    55_D      N     109          0.936
LGA    F    56_D      A     110          0.502
LGA    G    57_D      Q     111          1.532
LGA    F    58_D      L     112          1.349
LGA    T    59_D      Y     113          1.998
LGA    S    60_D      K     114          4.911
LGA    A    61_D      -       -           -
LGA    A    62_D      -       -           -
LGA    A    63_D      -       -           -
LGA    D    64_D      -       -           -
LGA    A    65_D      N     115          2.051
LGA    K    66_D      S     116          0.992
LGA    V    67_D      T     117          1.003
LGA    D    68_D      V     118          1.844
LGA    S    69_D      A     119          2.023
LGA    K    70_D      R     120          1.850
LGA    S    71_D      S     121          0.999
LGA    Q    72_D      I     122          0.663
LGA    E    73_D      S     123          1.815
LGA    K    74_D      N     124          3.653
LGA    L    75_D      F     125          4.113
LGA    L    76_D      S     126           #
LGA    A    77_D      F     127          2.450
LGA    P    78_D      S     128           #
LGA    S    79_D      R     129          5.307
LGA    A    80_D      E     130          4.491
LGA    P    81_D      A     131          4.315
LGA    T    82_D      K     132          2.269
LGA    L    83_D      I     133          2.441
LGA    T    84_D      G     134          3.015
LGA    L    85_D      K     135          3.623
LGA    A    86_D      E     136          4.116
LGA    K    87_D      D     137          3.210
LGA    F    88_D      Y     138          2.315
LGA    N    89_D      D     139          3.266
LGA    Q    90_D      E     140          3.421
LGA    V    91_D      L     141          2.341
LGA    T    92_D      K     142          2.829
LGA    V    93_D      I     143          1.900
LGA    G    94_D      G     144          2.306
LGA    M    95_D      E     145          2.314
LGA    T    96_D      S     146          2.634
LGA    R    97_D      Y     147          2.795
LGA    A    98_D      K     148          4.951
LGA    Q    99_D      K     149          5.112
LGA    V   100_D      V     150          3.855
LGA    L   101_D      V     151          4.754
LGA    A   102_D      E     152           #
LGA    T   103_D      K     153           #
LGA    V   104_D      -       -           -
LGA    G   105_D      -       -           -
LGA    Q   106_D      L     154          3.118
LGA    G   107_D      G     155          2.244
LGA    S   108_D      E     156           #
LGA    C   109_D      P     157          2.769
LGA    T   110_D      D     158          4.109
LGA    T   111_D      V     159           #
LGA    W   112_D      L     160          0.373
LGA    S   113_D      S     161          1.893
LGA    E   114_D      Q     162          2.414
LGA    Y   115_D      S     163          2.278
LGA    Y   116_D      M     164          3.041
LGA    P   117_D      S     165          1.876
LGA    A   118_D      S     166          3.241
LGA    Y   119_D      -       -           -
LGA    P   120_D      -       -           -
LGA    S   121_D      -       -           -
LGA    T   122_D      -       -           -
LGA    A   123_D      D     167           #
LGA    G   124_D      K     168          2.989
LGA    V   125_D      E     169          2.690
LGA    T   126_D      E     170          1.878
LGA    L   127_D      M     171          2.415
LGA    S   128_D      Q     172          2.271
LGA    L   129_D      T     173          2.209
LGA    S   130_D      V     174          1.646
LGA    C   131_D      W     175          1.950
LGA    F   132_D      S     176          3.745
LGA    -       -      S     177           -
LGA    -       -      G     178           -
LGA    D   133_D      I     179          1.231
LGA    V   134_D      K     180          3.776
LGA    -       -      T     181           -
LGA    -       -      K     182           -
LGA    -       -      S     183           -
LGA    D   135_D      S     184          4.983
LGA    G   136_D      -       -           -
LGA    Y   137_D      -       -           -
LGA    S   138_D      -       -           -
LGA    S   139_D      -       -           -
LGA    T   140_D      -       -           -
LGA    G   141_D      -       -           -
LGA    F   142_D      -       -           -
LGA    Y   143_D      -       -           -
LGA    R   144_D      S     185          1.377
LGA    G   145_D      A     186          0.889
LGA    S   146_D      T     187          0.883
LGA    A   147_D      I     188          1.288
LGA    H   148_D      E     189          1.104
LGA    L   149_D      L     190          0.574
LGA    W   150_D      Y     191          1.310
LGA    F   151_D      F     192          1.215
LGA    T   152_D      E     193          1.345
LGA    D   153_D      N     194          1.965
LGA    G   154_D      G     195          2.137
LGA    V   155_D      L     196          1.582
LGA    L   156_D      L     197          0.837
LGA    Q   157_D      K     198          0.672
LGA    G   158_D      N     199          0.759
LGA    K   159_D      K     200          1.392
LGA    R   160_D      T     201          1.658
LGA    Q   161_D      Q     202          1.595
LGA    W   162_D      K     203          1.795
LGA    D   163_D      D     204          2.114
LGA    L   164_D      L     205          1.880
LGA    V   165_D      E     206          4.132

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  165  162    5.0    127    2.66    16.54     54.948     4.598

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.738010 * X  +   0.551395 * Y  +   0.388979 * Z  +  64.461975
  Y_new =   0.440980 * X  +   0.830423 * Y  +  -0.340490 * Z  +   6.584968
  Z_new =  -0.510762 * X  +  -0.079753 * Y  +  -0.856015 * Z  +   8.477402 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.048693    0.092900  [ DEG:  -174.6772      5.3228 ]
  Theta =   0.536071    2.605522  [ DEG:    30.7146    149.2854 ]
  Phi   =   2.602994   -0.538599  [ DEG:   149.1406    -30.8594 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jtg_D                                        
REMARK     2: T0399.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jtg_D.T0399.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  165  162   5.0  127   2.66   16.54  54.948
REMARK  ---------------------------------------------------------- 
MOLECULE 1jtg_D
HEADER    HYDROLASE                               20-AUG-01   1JTG              
TITLE     CRYSTAL STRUCTURE OF TEM-1 BETA-LACTAMASE / BETA-LACTAMASE            
TITLE    2 INHIBITOR PROTEIN COMPLEX                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BETA-LACTAMASE TEM;                                        
COMPND   3 CHAIN: A, C;                                                         
COMPND   4 EC: 3.5.2.6;                                                         
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES;                                                       
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: BETA-LACTAMASE INHIBITORY PROTEIN;                         
COMPND   9 CHAIN: B, D;                                                         
COMPND  10 SYNONYM: BLIP;                                                       
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 MOL_ID: 2;                                                           
SOURCE   7 ORGANISM_SCIENTIFIC: STREPTOMYCES CLAVULIGERUS;                      
SOURCE   8 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    PROTEIN-PROTEIN COMPLEX, TEM-1 BETA-LACTAMASE, BETA-                  
KEYWDS   2 LACTAMASE INHIBITOR PROTEIN, BLIP                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.C.J.STRYNADKA,S.E.JENSEN,P.M.ALZARI,M.N.JAMES                       
REVDAT   2   01-APR-03 1JTG    1       JRNL                                     
REVDAT   1   17-OCT-01 1JTG    0                                                
JRNL        AUTH   D.LIM,H.U.PARK,L.DE CASTRO,S.G.KANG,H.S.LEE,                 
JRNL        AUTH 2 S.JENSEN,K.J.LEE,N.C.STRYNADKA                               
JRNL        TITL   CRYSTAL STRUCTURE AND KINETIC ANALYSIS OF                    
JRNL        TITL 2 BETA-LACTAMASE INHIBITOR PROTEIN-II IN COMPLEX               
JRNL        TITL 3 WITH TEM-1 BETA-LACTAMASE.                                   
JRNL        REF    NAT.STRUCT.BIOL.              V.   8   848 2001              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 1.73 ANGSTROMS.                                          
DBREF  1JTG A   26   288  UNP    P62593   BLAT_ECOLI      24    286             
DBREF  1JTG B  301   465  UNP    P35804   BLIP_STRCL      37    201             
DBREF  1JTG C   26   288  UNP    P62593   BLAT_ECOLI      24    286             
DBREF  1JTG D  301   465  UNP    P35804   BLIP_STRCL      37    201             
SEQRES   1 A  263  HIS PRO GLU THR LEU VAL LYS VAL LYS ASP ALA GLU ASP          
SEQRES   2 A  263  GLN LEU GLY ALA ARG VAL GLY TYR ILE GLU LEU ASP LEU          
SEQRES   3 A  263  ASN SER GLY LYS ILE LEU GLU SER PHE ARG PRO GLU GLU          
SEQRES   4 A  263  ARG PHE PRO MET MET SER THR PHE LYS VAL LEU LEU CYS          
SEQRES   5 A  263  GLY ALA VAL LEU SER ARG ILE ASP ALA GLY GLN GLU GLN          
SEQRES   6 A  263  LEU GLY ARG ARG ILE HIS TYR SER GLN ASN ASP LEU VAL          
SEQRES   7 A  263  GLU TYR SER PRO VAL THR GLU LYS HIS LEU THR ASP GLY          
SEQRES   8 A  263  MET THR VAL ARG GLU LEU CYS SER ALA ALA ILE THR MET          
SEQRES   9 A  263  SER ASP ASN THR ALA ALA ASN LEU LEU LEU THR THR ILE          
SEQRES  10 A  263  GLY GLY PRO LYS GLU LEU THR ALA PHE LEU HIS ASN MET          
SEQRES  11 A  263  GLY ASP HIS VAL THR ARG LEU ASP ARG TRP GLU PRO GLU          
SEQRES  12 A  263  LEU ASN GLU ALA ILE PRO ASN ASP GLU ARG ASP THR THR          
SEQRES  13 A  263  MET PRO VAL ALA MET ALA THR THR LEU ARG LYS LEU LEU          
SEQRES  14 A  263  THR GLY GLU LEU LEU THR LEU ALA SER ARG GLN GLN LEU          
SEQRES  15 A  263  ILE ASP TRP MET GLU ALA ASP LYS VAL ALA GLY PRO LEU          
SEQRES  16 A  263  LEU ARG SER ALA LEU PRO ALA GLY TRP PHE ILE ALA ASP          
SEQRES  17 A  263  LYS SER GLY ALA GLY GLU ARG GLY SER ARG GLY ILE ILE          
SEQRES  18 A  263  ALA ALA LEU GLY PRO ASP GLY LYS PRO SER ARG ILE VAL          
SEQRES  19 A  263  VAL ILE TYR THR THR GLY SER GLN ALA THR MET ASP GLU          
SEQRES  20 A  263  ARG ASN ARG GLN ILE ALA GLU ILE GLY ALA SER LEU ILE          
SEQRES  21 A  263  LYS HIS TRP                                                  
SEQRES   1 B  165  ALA GLY VAL MET THR GLY ALA LYS PHE THR GLN ILE GLN          
SEQRES   2 B  165  PHE GLY MET THR ARG GLN GLN VAL LEU ASP ILE ALA GLY          
SEQRES   3 B  165  ALA GLU ASN CYS GLU THR GLY GLY SER PHE GLY ASP SER          
SEQRES   4 B  165  ILE HIS CYS ARG GLY HIS ALA ALA GLY ASP TYR TYR ALA          
SEQRES   5 B  165  TYR ALA THR PHE GLY PHE THR SER ALA ALA ALA ASP ALA          
SEQRES   6 B  165  LYS VAL ASP SER LYS SER GLN GLU LYS LEU LEU ALA PRO          
SEQRES   7 B  165  SER ALA PRO THR LEU THR LEU ALA LYS PHE ASN GLN VAL          
SEQRES   8 B  165  THR VAL GLY MET THR ARG ALA GLN VAL LEU ALA THR VAL          
SEQRES   9 B  165  GLY GLN GLY SER CYS THR THR TRP SER GLU TYR TYR PRO          
SEQRES  10 B  165  ALA TYR PRO SER THR ALA GLY VAL THR LEU SER LEU SER          
SEQRES  11 B  165  CYS PHE ASP VAL ASP GLY TYR SER SER THR GLY PHE TYR          
SEQRES  12 B  165  ARG GLY SER ALA HIS LEU TRP PHE THR ASP GLY VAL LEU          
SEQRES  13 B  165  GLN GLY LYS ARG GLN TRP ASP LEU VAL                          
SEQRES   1 C  263  HIS PRO GLU THR LEU VAL LYS VAL LYS ASP ALA GLU ASP          
SEQRES   2 C  263  GLN LEU GLY ALA ARG VAL GLY TYR ILE GLU LEU ASP LEU          
SEQRES   3 C  263  ASN SER GLY LYS ILE LEU GLU SER PHE ARG PRO GLU GLU          
SEQRES   4 C  263  ARG PHE PRO MET MET SER THR PHE LYS VAL LEU LEU CYS          
SEQRES   5 C  263  GLY ALA VAL LEU SER ARG ILE ASP ALA GLY GLN GLU GLN          
SEQRES   6 C  263  LEU GLY ARG ARG ILE HIS TYR SER GLN ASN ASP LEU VAL          
SEQRES   7 C  263  GLU TYR SER PRO VAL THR GLU LYS HIS LEU THR ASP GLY          
SEQRES   8 C  263  MET THR VAL ARG GLU LEU CYS SER ALA ALA ILE THR MET          
SEQRES   9 C  263  SER ASP ASN THR ALA ALA ASN LEU LEU LEU THR THR ILE          
SEQRES  10 C  263  GLY GLY PRO LYS GLU LEU THR ALA PHE LEU HIS ASN MET          
SEQRES  11 C  263  GLY ASP HIS VAL THR ARG LEU ASP ARG TRP GLU PRO GLU          
SEQRES  12 C  263  LEU ASN GLU ALA ILE PRO ASN ASP GLU ARG ASP THR THR          
SEQRES  13 C  263  MET PRO VAL ALA MET ALA THR THR LEU ARG LYS LEU LEU          
SEQRES  14 C  263  THR GLY GLU LEU LEU THR LEU ALA SER ARG GLN GLN LEU          
SEQRES  15 C  263  ILE ASP TRP MET GLU ALA ASP LYS VAL ALA GLY PRO LEU          
SEQRES  16 C  263  LEU ARG SER ALA LEU PRO ALA GLY TRP PHE ILE ALA ASP          
SEQRES  17 C  263  LYS SER GLY ALA GLY GLU ARG GLY SER ARG GLY ILE ILE          
SEQRES  18 C  263  ALA ALA LEU GLY PRO ASP GLY LYS PRO SER ARG ILE VAL          
SEQRES  19 C  263  VAL ILE TYR THR THR GLY SER GLN ALA THR MET ASP GLU          
SEQRES  20 C  263  ARG ASN ARG GLN ILE ALA GLU ILE GLY ALA SER LEU ILE          
SEQRES  21 C  263  LYS HIS TRP                                                  
SEQRES   1 D  165  ALA GLY VAL MET THR GLY ALA LYS PHE THR GLN ILE GLN          
SEQRES   2 D  165  PHE GLY MET THR ARG GLN GLN VAL LEU ASP ILE ALA GLY          
SEQRES   3 D  165  ALA GLU ASN CYS GLU THR GLY GLY SER PHE GLY ASP SER          
SEQRES   4 D  165  ILE HIS CYS ARG GLY HIS ALA ALA GLY ASP TYR TYR ALA          
SEQRES   5 D  165  TYR ALA THR PHE GLY PHE THR SER ALA ALA ALA ASP ALA          
SEQRES   6 D  165  LYS VAL ASP SER LYS SER GLN GLU LYS LEU LEU ALA PRO          
SEQRES   7 D  165  SER ALA PRO THR LEU THR LEU ALA LYS PHE ASN GLN VAL          
SEQRES   8 D  165  THR VAL GLY MET THR ARG ALA GLN VAL LEU ALA THR VAL          
SEQRES   9 D  165  GLY GLN GLY SER CYS THR THR TRP SER GLU TYR TYR PRO          
SEQRES  10 D  165  ALA TYR PRO SER THR ALA GLY VAL THR LEU SER LEU SER          
SEQRES  11 D  165  CYS PHE ASP VAL ASP GLY TYR SER SER THR GLY PHE TYR          
SEQRES  12 D  165  ARG GLY SER ALA HIS LEU TRP PHE THR ASP GLY VAL LEU          
SEQRES  13 D  165  GLN GLY LYS ARG GLN TRP ASP LEU VAL                          
HET     CA  B 645       1                                                       
HET     CA  D 702       1                                                       
HETNAM      CA CALCIUM ION                                                      
FORMUL   5   CA    2(CA 2+)                                                     
FORMUL   7  HOH   *441(H2 O)                                                    
CRYST1   45.800  126.300  158.300  90.00  90.00  90.00 P 21 21 21    8          
ATOM   5274  N   ALA D   1      64.320  39.012  -5.196  1.00 61.99           N  
ATOM   5275  CA  ALA D   1      64.129  37.621  -5.698  1.00 57.59           C  
ATOM   5276  C   ALA D   1      65.151  36.676  -5.078  1.00 55.43           C  
ATOM   5277  O   ALA D   1      65.499  36.804  -3.896  1.00 55.39           O  
ATOM   5278  CB  ALA D   1      64.246  37.589  -7.231  1.00 57.08           C  
ATOM   5279  N   GLY D   2      65.635  35.736  -5.886  1.00 51.73           N  
ATOM   5280  CA  GLY D   2      66.598  34.768  -5.396  1.00 42.22           C  
ATOM   5281  C   GLY D   2      65.851  33.694  -4.625  1.00 37.55           C  
ATOM   5282  O   GLY D   2      64.801  33.955  -4.031  1.00 36.03           O  
ATOM   5283  N   VAL D   3      66.385  32.483  -4.628  1.00 32.61           N  
ATOM   5284  CA  VAL D   3      65.738  31.378  -3.931  1.00 27.02           C  
ATOM   5285  C   VAL D   3      65.922  31.447  -2.419  1.00 26.25           C  
ATOM   5286  O   VAL D   3      66.402  32.443  -1.880  1.00 22.83           O  
ATOM   5287  CB  VAL D   3      66.279  30.041  -4.449  1.00 27.77           C  
ATOM   5288  CG1 VAL D   3      65.942  29.897  -5.935  1.00 29.67           C  
ATOM   5289  CG2 VAL D   3      67.784  29.976  -4.231  1.00 25.81           C  
ATOM   5290  N   MET D   4      65.524  30.387  -1.727  1.00 19.55           N  
ATOM   5291  CA  MET D   4      65.675  30.354  -0.275  1.00 19.49           C  
ATOM   5292  C   MET D   4      67.163  30.199   0.023  1.00 21.71           C  
ATOM   5293  O   MET D   4      67.876  29.455  -0.664  1.00 21.11           O  
ATOM   5294  CB  MET D   4      64.903  29.164   0.292  1.00 21.09           C  
ATOM   5295  CG  MET D   4      64.887  29.109   1.795  1.00 19.01           C  
ATOM   5296  SD  MET D   4      64.037  30.569   2.403  1.00 23.31           S  
ATOM   5297  CE  MET D   4      64.333  30.351   4.124  1.00 24.89           C  
ATOM   5298  N   THR D   5      67.625  30.881   1.064  1.00 23.95           N  
ATOM   5299  CA  THR D   5      69.029  30.857   1.465  1.00 22.94           C  
ATOM   5300  C   THR D   5      69.181  30.775   2.986  1.00 22.62           C  
ATOM   5301  O   THR D   5      68.225  30.997   3.728  1.00 20.28           O  
ATOM   5302  CB  THR D   5      69.709  32.157   1.017  1.00 24.31           C  
ATOM   5303  OG1 THR D   5      69.086  33.259   1.692  1.00 22.31           O  
ATOM   5304  CG2 THR D   5      69.522  32.360  -0.490  1.00 23.09           C  
ATOM   5305  N   GLY D   6      70.391  30.467   3.440  1.00 18.68           N  
ATOM   5306  CA  GLY D   6      70.652  30.414   4.868  1.00 17.65           C  
ATOM   5307  C   GLY D   6      70.371  31.760   5.536  1.00 22.04           C  
ATOM   5308  O   GLY D   6      69.868  31.817   6.655  1.00 21.13           O  
ATOM   5309  N   ALA D   7      70.704  32.860   4.867  1.00 23.14           N  
ATOM   5310  CA  ALA D   7      70.463  34.180   5.450  1.00 24.44           C  
ATOM   5311  C   ALA D   7      68.972  34.412   5.687  1.00 27.50           C  
ATOM   5312  O   ALA D   7      68.562  34.960   6.717  1.00 24.57           O  
ATOM   5313  CB  ALA D   7      71.024  35.262   4.544  1.00 27.43           C  
ATOM   5314  N   LYS D   8      68.141  33.993   4.742  1.00 20.14           N  
ATOM   5315  CA  LYS D   8      66.719  34.181   4.940  1.00 18.34           C  
ATOM   5316  C   LYS D   8      66.228  33.305   6.081  1.00 19.05           C  
ATOM   5317  O   LYS D   8      65.389  33.727   6.878  1.00 21.46           O  
ATOM   5318  CB  LYS D   8      65.960  33.849   3.666  1.00 21.09           C  
ATOM   5319  CG  LYS D   8      66.156  34.891   2.558  1.00 22.13           C  
ATOM   5320  CD  LYS D   8      65.616  34.368   1.233  1.00 21.94           C  
ATOM   5321  CE  LYS D   8      65.638  35.458   0.169  1.00 31.53           C  
ATOM   5322  NZ  LYS D   8      64.919  35.034  -1.068  1.00 30.40           N  
ATOM   5323  N   PHE D   9      66.758  32.085   6.153  1.00 18.31           N  
ATOM   5324  CA  PHE D   9      66.374  31.136   7.198  1.00 16.87           C  
ATOM   5325  C   PHE D   9      66.635  31.726   8.581  1.00 20.26           C  
ATOM   5326  O   PHE D   9      65.847  31.567   9.512  1.00 20.80           O  
ATOM   5327  CB  PHE D   9      67.183  29.830   7.051  1.00 18.89           C  
ATOM   5328  CG  PHE D   9      66.822  28.777   8.069  1.00 22.50           C  
ATOM   5329  CD1 PHE D   9      65.667  28.007   7.916  1.00 18.19           C  
ATOM   5330  CD2 PHE D   9      67.629  28.563   9.192  1.00 17.09           C  
ATOM   5331  CE1 PHE D   9      65.324  27.043   8.858  1.00 18.87           C  
ATOM   5332  CE2 PHE D   9      67.290  27.599  10.137  1.00 22.69           C  
ATOM   5333  CZ  PHE D   9      66.126  26.829   9.967  1.00 20.40           C  
ATOM   5334  N   THR D  10      67.755  32.422   8.696  1.00 21.22           N  
ATOM   5335  CA  THR D  10      68.148  33.030   9.954  1.00 21.92           C  
ATOM   5336  C   THR D  10      67.280  34.218  10.302  1.00 22.80           C  
ATOM   5337  O   THR D  10      66.991  34.457  11.474  1.00 23.43           O  
ATOM   5338  CB  THR D  10      69.622  33.439   9.877  1.00 23.88           C  
ATOM   5339  OG1 THR D  10      70.411  32.265   9.632  1.00 27.85           O  
ATOM   5340  CG2 THR D  10      70.052  34.096  11.154  1.00 28.16           C  
ATOM   5341  N   GLN D  11      66.848  34.969   9.298  1.00 22.73           N  
ATOM   5342  CA  GLN D  11      65.988  36.124   9.556  1.00 23.94           C  
ATOM   5343  C   GLN D  11      64.615  35.721  10.065  1.00 24.25           C  
ATOM   5344  O   GLN D  11      63.954  36.476  10.767  1.00 21.98           O  
ATOM   5345  CB  GLN D  11      65.774  36.942   8.284  1.00 25.29           C  
ATOM   5346  CG  GLN D  11      67.006  37.554   7.700  1.00 34.47           C  
ATOM   5347  CD  GLN D  11      66.686  38.317   6.429  1.00 45.80           C  
ATOM   5348  OE1 GLN D  11      65.826  39.199   6.430  1.00 49.92           O  
ATOM   5349  NE2 GLN D  11      67.368  37.980   5.338  1.00 47.54           N  
ATOM   5350  N   ILE D  12      64.146  34.540   9.673  1.00 18.57           N  
ATOM   5351  CA  ILE D  12      62.835  34.120  10.124  1.00 16.28           C  
ATOM   5352  C   ILE D  12      62.878  33.722  11.598  1.00 17.73           C  
ATOM   5353  O   ILE D  12      63.769  33.002  12.065  1.00 21.29           O  
ATOM   5354  CB  ILE D  12      62.298  32.989   9.207  1.00 19.04           C  
ATOM   5355  CG1 ILE D  12      61.958  33.607   7.842  1.00 20.77           C  
ATOM   5356  CG2 ILE D  12      61.073  32.343   9.814  1.00 19.71           C  
ATOM   5357  CD1 ILE D  12      61.819  32.626   6.709  1.00 24.93           C  
ATOM   5358  N   GLN D  13      61.891  34.205  12.333  1.00 17.69           N  
ATOM   5359  CA  GLN D  13      61.819  33.970  13.751  1.00 19.74           C  
ATOM   5360  C   GLN D  13      60.613  33.190  14.210  1.00 17.44           C  
ATOM   5361  O   GLN D  13      59.533  33.266  13.624  1.00 20.98           O  
ATOM   5362  CB  GLN D  13      61.783  35.324  14.489  1.00 22.46           C  
ATOM   5363  CG  GLN D  13      62.867  36.293  14.104  1.00 32.34           C  
ATOM   5364  CD  GLN D  13      64.232  35.776  14.474  1.00 38.67           C  
ATOM   5365  OE1 GLN D  13      64.424  35.245  15.568  1.00 44.09           O  
ATOM   5366  NE2 GLN D  13      65.195  35.936  13.576  1.00 40.24           N  
ATOM   5367  N   PHE D  14      60.799  32.452  15.293  1.00 18.27           N  
ATOM   5368  CA  PHE D  14      59.686  31.763  15.886  1.00 15.62           C  
ATOM   5369  C   PHE D  14      58.684  32.848  16.253  1.00 20.58           C  
ATOM   5370  O   PHE D  14      59.070  33.960  16.656  1.00 20.29           O  
ATOM   5371  CB  PHE D  14      60.124  31.008  17.138  1.00 17.53           C  
ATOM   5372  CG  PHE D  14      60.943  29.804  16.821  1.00 17.11           C  
ATOM   5373  CD1 PHE D  14      62.326  29.853  16.879  1.00 16.23           C  
ATOM   5374  CD2 PHE D  14      60.328  28.643  16.367  1.00 15.19           C  
ATOM   5375  CE1 PHE D  14      63.095  28.781  16.490  1.00 16.75           C  
ATOM   5376  CE2 PHE D  14      61.106  27.543  15.968  1.00 13.29           C  
ATOM   5377  CZ  PHE D  14      62.481  27.614  16.028  1.00 16.09           C  
ATOM   5378  N   GLY D  15      57.407  32.528  16.115  1.00 20.79           N  
ATOM   5379  CA  GLY D  15      56.362  33.488  16.443  1.00 20.15           C  
ATOM   5380  C   GLY D  15      55.948  34.350  15.266  1.00 23.28           C  
ATOM   5381  O   GLY D  15      54.982  35.110  15.379  1.00 21.17           O  
ATOM   5382  N   MET D  16      56.660  34.259  14.144  1.00 18.62           N  
ATOM   5383  CA  MET D  16      56.286  35.061  12.978  1.00 18.33           C  
ATOM   5384  C   MET D  16      55.031  34.479  12.336  1.00 21.93           C  
ATOM   5385  O   MET D  16      54.719  33.303  12.514  1.00 19.74           O  
ATOM   5386  CB  MET D  16      57.409  35.100  11.948  1.00 19.59           C  
ATOM   5387  CG  MET D  16      58.456  36.162  12.198  1.00 17.60           C  
ATOM   5388  SD  MET D  16      59.666  36.220  10.913  1.00 24.49           S  
ATOM   5389  CE  MET D  16      60.770  37.480  11.506  1.00 25.68           C  
ATOM   5390  N   THR D  17      54.286  35.315  11.617  1.00 19.67           N  
ATOM   5391  CA  THR D  17      53.083  34.843  10.943  1.00 20.51           C  
ATOM   5392  C   THR D  17      53.426  34.295   9.558  1.00 18.97           C  
ATOM   5393  O   THR D  17      54.524  34.483   9.057  1.00 18.90           O  
ATOM   5394  CB  THR D  17      52.096  35.989  10.723  1.00 21.05           C  
ATOM   5395  OG1 THR D  17      52.714  36.971   9.876  1.00 20.33           O  
ATOM   5396  CG2 THR D  17      51.737  36.634  12.052  1.00 24.25           C  
ATOM   5397  N   ARG D  18      52.461  33.623   8.936  1.00 19.19           N  
ATOM   5398  CA  ARG D  18      52.655  33.087   7.601  1.00 19.79           C  
ATOM   5399  C   ARG D  18      53.097  34.159   6.628  1.00 21.02           C  
ATOM   5400  O   ARG D  18      54.012  33.965   5.823  1.00 19.74           O  
ATOM   5401  CB  ARG D  18      51.351  32.465   7.097  1.00 21.59           C  
ATOM   5402  CG  ARG D  18      51.061  31.104   7.664  1.00 24.43           C  
ATOM   5403  CD  ARG D  18      49.667  30.605   7.257  1.00 22.47           C  
ATOM   5404  NE  ARG D  18      49.324  29.458   8.079  1.00 27.16           N  
ATOM   5405  CZ  ARG D  18      49.865  28.261   7.901  1.00 18.91           C  
ATOM   5406  NH1 ARG D  18      50.733  28.097   6.911  1.00 23.41           N  
ATOM   5407  NH2 ARG D  18      49.611  27.276   8.755  1.00 20.17           N  
ATOM   5408  N   GLN D  19      52.437  35.311   6.685  1.00 22.53           N  
ATOM   5409  CA  GLN D  19      52.797  36.376   5.770  1.00 23.56           C  
ATOM   5410  C   GLN D  19      54.237  36.847   5.942  1.00 19.45           C  
ATOM   5411  O   GLN D  19      54.940  37.101   4.968  1.00 22.23           O  
ATOM   5412  CB  GLN D  19      51.833  37.560   5.933  1.00 30.21           C  
ATOM   5413  CG  GLN D  19      51.910  38.527   4.761  1.00 35.58           C  
ATOM   5414  CD  GLN D  19      51.663  37.823   3.429  1.00 42.51           C  
ATOM   5415  OE1 GLN D  19      52.513  37.837   2.530  1.00 48.70           O  
ATOM   5416  NE2 GLN D  19      50.497  37.194   3.301  1.00 46.18           N  
ATOM   5417  N   GLN D  20      54.672  36.987   7.189  1.00 21.42           N  
ATOM   5418  CA  GLN D  20      56.028  37.435   7.465  1.00 20.15           C  
ATOM   5419  C   GLN D  20      57.037  36.473   6.891  1.00 20.77           C  
ATOM   5420  O   GLN D  20      58.053  36.876   6.339  1.00 21.62           O  
ATOM   5421  CB  GLN D  20      56.241  37.555   8.959  1.00 24.18           C  
ATOM   5422  CG  GLN D  20      55.493  38.719   9.557  1.00 26.16           C  
ATOM   5423  CD  GLN D  20      55.708  38.813  11.046  1.00 33.02           C  
ATOM   5424  OE1 GLN D  20      55.170  38.014  11.824  1.00 30.07           O  
ATOM   5425  NE2 GLN D  20      56.511  39.787  11.457  1.00 40.21           N  
ATOM   5426  N   VAL D  21      56.760  35.186   7.052  1.00 19.42           N  
ATOM   5427  CA  VAL D  21      57.645  34.172   6.521  1.00 17.99           C  
ATOM   5428  C   VAL D  21      57.747  34.307   4.998  1.00 18.44           C  
ATOM   5429  O   VAL D  21      58.841  34.364   4.426  1.00 21.07           O  
ATOM   5430  CB  VAL D  21      57.121  32.762   6.898  1.00 18.80           C  
ATOM   5431  CG1 VAL D  21      57.903  31.681   6.156  1.00 19.99           C  
ATOM   5432  CG2 VAL D  21      57.238  32.573   8.404  1.00 16.99           C  
ATOM   5433  N   LEU D  22      56.594  34.368   4.346  1.00 18.50           N  
ATOM   5434  CA  LEU D  22      56.555  34.479   2.897  1.00 18.70           C  
ATOM   5435  C   LEU D  22      57.252  35.737   2.407  1.00 22.11           C  
ATOM   5436  O   LEU D  22      58.012  35.680   1.430  1.00 25.60           O  
ATOM   5437  CB  LEU D  22      55.108  34.449   2.400  1.00 21.96           C  
ATOM   5438  CG  LEU D  22      54.377  33.110   2.540  1.00 20.82           C  
ATOM   5439  CD1 LEU D  22      52.960  33.287   2.022  1.00 26.52           C  
ATOM   5440  CD2 LEU D  22      55.094  32.015   1.733  1.00 24.05           C  
ATOM   5441  N   ASP D  23      57.007  36.863   3.081  1.00 25.24           N  
ATOM   5442  CA  ASP D  23      57.666  38.121   2.698  1.00 24.95           C  
ATOM   5443  C   ASP D  23      59.184  37.961   2.752  1.00 26.04           C  
ATOM   5444  O   ASP D  23      59.890  38.399   1.851  1.00 29.64           O  
ATOM   5445  CB  ASP D  23      57.254  39.274   3.626  1.00 29.67           C  
ATOM   5446  CG  ASP D  23      55.774  39.656   3.490  1.00 38.58           C  
ATOM   5447  OD1 ASP D  23      55.262  40.346   4.397  1.00 41.10           O  
ATOM   5448  OD2 ASP D  23      55.123  39.279   2.490  1.00 39.73           O  
ATOM   5449  N   ILE D  24      59.702  37.321   3.794  1.00 23.37           N  
ATOM   5450  CA  ILE D  24      61.154  37.146   3.887  1.00 21.66           C  
ATOM   5451  C   ILE D  24      61.720  36.104   2.936  1.00 23.57           C  
ATOM   5452  O   ILE D  24      62.735  36.331   2.287  1.00 23.30           O  
ATOM   5453  CB  ILE D  24      61.583  36.752   5.326  1.00 23.09           C  
ATOM   5454  CG1 ILE D  24      61.260  37.905   6.280  1.00 24.37           C  
ATOM   5455  CG2 ILE D  24      63.064  36.400   5.357  1.00 25.68           C  
ATOM   5456  CD1 ILE D  24      61.300  37.548   7.752  1.00 23.94           C  
ATOM   5457  N   ALA D  25      61.068  34.948   2.848  1.00 22.34           N  
ATOM   5458  CA  ALA D  25      61.583  33.870   2.005  1.00 21.10           C  
ATOM   5459  C   ALA D  25      61.431  34.086   0.504  1.00 22.50           C  
ATOM   5460  O   ALA D  25      62.255  33.622  -0.276  1.00 24.51           O  
ATOM   5461  CB  ALA D  25      60.896  32.552   2.382  1.00 18.83           C  
ATOM   5462  N   GLY D  26      60.364  34.776   0.118  1.00 21.44           N  
ATOM   5463  CA  GLY D  26      60.082  34.980  -1.293  1.00 22.99           C  
ATOM   5464  C   GLY D  26      59.000  33.957  -1.599  1.00 23.93           C  
ATOM   5465  O   GLY D  26      59.278  32.755  -1.727  1.00 23.90           O  
ATOM   5466  N   ALA D  27      57.760  34.416  -1.704  1.00 24.41           N  
ATOM   5467  CA  ALA D  27      56.631  33.509  -1.932  1.00 27.86           C  
ATOM   5468  C   ALA D  27      56.818  32.525  -3.075  1.00 26.98           C  
ATOM   5469  O   ALA D  27      56.325  31.394  -3.028  1.00 26.84           O  
ATOM   5470  CB  ALA D  27      55.350  34.316  -2.137  1.00 33.16           C  
ATOM   5471  N   GLU D  28      57.552  32.952  -4.091  1.00 26.29           N  
ATOM   5472  CA  GLU D  28      57.811  32.142  -5.267  1.00 28.05           C  
ATOM   5473  C   GLU D  28      58.597  30.866  -5.001  1.00 30.04           C  
ATOM   5474  O   GLU D  28      58.524  29.901  -5.770  1.00 31.71           O  
ATOM   5475  CB  GLU D  28      58.572  32.979  -6.288  1.00 31.33           C  
ATOM   5476  CG  GLU D  28      58.134  32.721  -7.707  1.00 43.85           C  
ATOM   5477  CD  GLU D  28      56.628  32.662  -7.806  1.00 46.97           C  
ATOM   5478  OE1 GLU D  28      55.969  33.610  -7.315  1.00 48.29           O  
ATOM   5479  OE2 GLU D  28      56.112  31.664  -8.360  1.00 49.88           O  
ATOM   5480  N   ASN D  29      59.366  30.877  -3.919  1.00 22.98           N  
ATOM   5481  CA  ASN D  29      60.199  29.738  -3.551  1.00 23.81           C  
ATOM   5482  C   ASN D  29      59.504  28.742  -2.671  1.00 21.57           C  
ATOM   5483  O   ASN D  29      60.051  27.682  -2.395  1.00 22.70           O  
ATOM   5484  CB  ASN D  29      61.417  30.226  -2.769  1.00 25.23           C  
ATOM   5485  CG  ASN D  29      62.241  31.219  -3.549  1.00 29.43           C  
ATOM   5486  OD1 ASN D  29      62.604  30.950  -4.681  1.00 29.73           O  
ATOM   5487  ND2 ASN D  29      62.551  32.366  -2.942  1.00 26.59           N  
ATOM   5488  N   CYS D  30      58.293  29.067  -2.242  1.00 22.36           N  
ATOM   5489  CA  CYS D  30      57.607  28.223  -1.290  1.00 19.87           C  
ATOM   5490  C   CYS D  30      56.312  27.582  -1.715  1.00 20.53           C  
ATOM   5491  O   CYS D  30      55.671  28.030  -2.656  1.00 27.10           O  
ATOM   5492  CB  CYS D  30      57.332  29.041  -0.045  1.00 16.28           C  
ATOM   5493  SG  CYS D  30      58.694  30.073   0.565  1.00 19.81           S  
ATOM   5494  N   GLU D  31      55.927  26.535  -0.998  1.00 19.94           N  
ATOM   5495  CA  GLU D  31      54.668  25.850  -1.254  1.00 21.38           C  
ATOM   5496  C   GLU D  31      54.085  25.445   0.074  1.00 21.88           C  
ATOM   5497  O   GLU D  31      54.785  25.392   1.083  1.00 19.52           O  
ATOM   5498  CB  GLU D  31      54.871  24.613  -2.125  1.00 26.90           C  
ATOM   5499  CG  GLU D  31      55.783  23.568  -1.536  1.00 36.89           C  
ATOM   5500  CD  GLU D  31      55.889  22.335  -2.429  1.00 42.06           C  
ATOM   5501  OE1 GLU D  31      54.952  21.510  -2.434  1.00 45.25           O  
ATOM   5502  OE2 GLU D  31      56.906  22.204  -3.137  1.00 46.47           O  
ATOM   5503  N   THR D  32      52.787  25.185   0.080  1.00 17.55           N  
ATOM   5504  CA  THR D  32      52.103  24.745   1.279  1.00 19.89           C  
ATOM   5505  C   THR D  32      51.069  23.773   0.747  1.00 21.69           C  
ATOM   5506  O   THR D  32      50.894  23.692  -0.464  1.00 26.87           O  
ATOM   5507  CB  THR D  32      51.458  25.921   2.015  1.00 20.22           C  
ATOM   5508  OG1 THR D  32      50.942  25.462   3.261  1.00 18.03           O  
ATOM   5509  CG2 THR D  32      50.340  26.538   1.187  1.00 24.65           C  
ATOM   5510  N   GLY D  33      50.411  23.023   1.620  1.00 23.92           N  
ATOM   5511  CA  GLY D  33      49.438  22.058   1.144  1.00 26.79           C  
ATOM   5512  C   GLY D  33      50.115  20.805   0.605  1.00 30.37           C  
ATOM   5513  O   GLY D  33      51.324  20.617   0.760  1.00 23.25           O  
ATOM   5514  N   GLY D  34      49.342  19.934  -0.034  1.00 31.39           N  
ATOM   5515  CA  GLY D  34      49.926  18.718  -0.561  1.00 28.02           C  
ATOM   5516  C   GLY D  34      50.666  17.928   0.505  1.00 26.40           C  
ATOM   5517  O   GLY D  34      50.173  17.736   1.622  1.00 27.71           O  
ATOM   5518  N   SER D  35      51.872  17.489   0.164  1.00 23.86           N  
ATOM   5519  CA  SER D  35      52.685  16.691   1.075  1.00 23.57           C  
ATOM   5520  C   SER D  35      53.081  17.453   2.341  1.00 22.70           C  
ATOM   5521  O   SER D  35      53.486  16.857   3.320  1.00 22.72           O  
ATOM   5522  CB  SER D  35      53.962  16.240   0.362  1.00 29.57           C  
ATOM   5523  OG  SER D  35      53.657  15.601  -0.868  1.00 37.76           O  
ATOM   5524  N   PHE D  36      52.954  18.770   2.327  1.00 21.56           N  
ATOM   5525  CA  PHE D  36      53.379  19.529   3.488  1.00 20.17           C  
ATOM   5526  C   PHE D  36      52.315  20.013   4.428  1.00 25.07           C  
ATOM   5527  O   PHE D  36      52.615  20.697   5.401  1.00 22.36           O  
ATOM   5528  CB  PHE D  36      54.234  20.687   3.007  1.00 18.03           C  
ATOM   5529  CG  PHE D  36      55.503  20.229   2.376  1.00 21.34           C  
ATOM   5530  CD1 PHE D  36      55.620  20.144   0.994  1.00 23.66           C  
ATOM   5531  CD2 PHE D  36      56.550  19.788   3.170  1.00 21.50           C  
ATOM   5532  CE1 PHE D  36      56.767  19.622   0.409  1.00 25.61           C  
ATOM   5533  CE2 PHE D  36      57.706  19.260   2.589  1.00 21.46           C  
ATOM   5534  CZ  PHE D  36      57.805  19.182   1.207  1.00 23.03           C  
ATOM   5535  N   GLY D  37      51.066  19.648   4.162  1.00 23.30           N  
ATOM   5536  CA  GLY D  37      50.001  20.102   5.034  1.00 22.41           C  
ATOM   5537  C   GLY D  37      49.948  21.613   5.148  1.00 21.61           C  
ATOM   5538  O   GLY D  37      49.998  22.329   4.148  1.00 22.02           O  
ATOM   5539  N   ASP D  38      49.864  22.121   6.372  1.00 21.28           N  
ATOM   5540  CA  ASP D  38      49.779  23.562   6.522  1.00 22.51           C  
ATOM   5541  C   ASP D  38      51.139  24.209   6.814  1.00 23.68           C  
ATOM   5542  O   ASP D  38      51.211  25.366   7.220  1.00 23.54           O  
ATOM   5543  CB  ASP D  38      48.765  23.907   7.620  1.00 28.02           C  
ATOM   5544  CG  ASP D  38      49.147  23.326   8.955  1.00 31.34           C  
ATOM   5545  OD1 ASP D  38      48.302  23.312   9.871  1.00 48.49           O  
ATOM   5546  OD2 ASP D  38      50.297  22.875   9.093  1.00 46.02           O  
ATOM   5547  N   SER D  39      52.212  23.451   6.619  1.00 19.67           N  
ATOM   5548  CA  SER D  39      53.550  24.001   6.809  1.00 18.15           C  
ATOM   5549  C   SER D  39      53.906  24.738   5.531  1.00 16.43           C  
ATOM   5550  O   SER D  39      53.237  24.570   4.505  1.00 18.35           O  
ATOM   5551  CB  SER D  39      54.560  22.876   7.032  1.00 17.49           C  
ATOM   5552  OG  SER D  39      54.376  22.326   8.320  1.00 17.23           O  
ATOM   5553  N   ILE D  40      54.944  25.564   5.587  1.00 13.12           N  
ATOM   5554  CA  ILE D  40      55.391  26.273   4.392  1.00 11.42           C  
ATOM   5555  C   ILE D  40      56.800  25.763   4.109  1.00 16.14           C  
ATOM   5556  O   ILE D  40      57.688  25.863   4.948  1.00 13.90           O  
ATOM   5557  CB  ILE D  40      55.399  27.782   4.625  1.00 13.97           C  
ATOM   5558  CG1 ILE D  40      53.954  28.264   4.846  1.00 17.13           C  
ATOM   5559  CG2 ILE D  40      56.031  28.489   3.434  1.00 15.27           C  
ATOM   5560  CD1 ILE D  40      53.866  29.729   5.069  1.00 21.56           C  
ATOM   5561  N   HIS D  41      56.984  25.225   2.909  1.00 13.90           N  
ATOM   5562  CA  HIS D  41      58.248  24.623   2.480  1.00 18.47           C  
ATOM   5563  C   HIS D  41      58.858  25.497   1.405  1.00 19.31           C  
ATOM   5564  O   HIS D  41      58.233  25.741   0.386  1.00 17.80           O  
ATOM   5565  CB  HIS D  41      57.927  23.235   1.920  1.00 15.01           C  
ATOM   5566  CG  HIS D  41      59.110  22.479   1.409  1.00 15.57           C  
ATOM   5567  ND1 HIS D  41      60.036  21.878   2.246  1.00 15.95           N  
ATOM   5568  CD2 HIS D  41      59.454  22.128   0.148  1.00 16.25           C  
ATOM   5569  CE1 HIS D  41      60.888  21.181   1.516  1.00 14.31           C  
ATOM   5570  NE2 HIS D  41      60.561  21.315   0.243  1.00 14.12           N  
ATOM   5571  N   CYS D  42      60.083  25.955   1.606  1.00 15.60           N  
ATOM   5572  CA  CYS D  42      60.697  26.837   0.621  1.00 15.83           C  
ATOM   5573  C   CYS D  42      61.976  26.244   0.085  1.00 18.15           C  
ATOM   5574  O   CYS D  42      62.840  25.794   0.838  1.00 15.84           O  
ATOM   5575  CB  CYS D  42      60.971  28.191   1.269  1.00 15.92           C  
ATOM   5576  SG  CYS D  42      59.504  28.929   2.049  1.00 18.04           S  
ATOM   5577  N   ARG D  43      62.104  26.258  -1.231  1.00 15.23           N  
ATOM   5578  CA  ARG D  43      63.270  25.663  -1.860  1.00 17.02           C  
ATOM   5579  C   ARG D  43      64.399  26.597  -2.186  1.00 17.47           C  
ATOM   5580  O   ARG D  43      64.179  27.750  -2.577  1.00 21.47           O  
ATOM   5581  CB  ARG D  43      62.852  24.937  -3.146  1.00 20.30           C  
ATOM   5582  CG  ARG D  43      61.917  23.746  -2.887  1.00 28.19           C  
ATOM   5583  CD  ARG D  43      61.239  23.244  -4.159  1.00 35.60           C  
ATOM   5584  NE  ARG D  43      60.392  24.293  -4.727  1.00 50.62           N  
ATOM   5585  CZ  ARG D  43      60.824  25.260  -5.539  1.00 55.66           C  
ATOM   5586  NH1 ARG D  43      62.103  25.308  -5.899  1.00 59.73           N  
ATOM   5587  NH2 ARG D  43      59.984  26.198  -5.970  1.00 54.73           N  
ATOM   5588  N   GLY D  44      65.613  26.091  -2.000  1.00 19.58           N  
ATOM   5589  CA  GLY D  44      66.806  26.852  -2.337  1.00 18.56           C  
ATOM   5590  C   GLY D  44      67.343  26.301  -3.651  1.00 20.17           C  
ATOM   5591  O   GLY D  44      66.577  25.903  -4.523  1.00 21.46           O  
ATOM   5592  N   HIS D  45      68.660  26.273  -3.805  1.00 21.24           N  
ATOM   5593  CA  HIS D  45      69.282  25.764  -5.022  1.00 23.02           C  
ATOM   5594  C   HIS D  45      69.121  24.240  -5.125  1.00 24.11           C  
ATOM   5595  O   HIS D  45      68.921  23.555  -4.118  1.00 20.72           O  
ATOM   5596  CB  HIS D  45      70.773  26.062  -4.990  1.00 22.43           C  
ATOM   5597  CG  HIS D  45      71.449  25.545  -3.757  1.00 29.66           C  
ATOM   5598  ND1 HIS D  45      71.452  26.239  -2.566  1.00 32.86           N  
ATOM   5599  CD2 HIS D  45      72.066  24.365  -3.505  1.00 25.45           C  
ATOM   5600  CE1 HIS D  45      72.040  25.509  -1.634  1.00 28.45           C  
ATOM   5601  NE2 HIS D  45      72.421  24.368  -2.178  1.00 27.92           N  
ATOM   5602  N   ALA D  46      69.240  23.718  -6.343  1.00 21.48           N  
ATOM   5603  CA  ALA D  46      69.174  22.271  -6.557  1.00 18.92           C  
ATOM   5604  C   ALA D  46      70.316  21.591  -5.802  1.00 21.03           C  
ATOM   5605  O   ALA D  46      71.425  22.125  -5.684  1.00 20.76           O  
ATOM   5606  CB  ALA D  46      69.289  21.957  -8.050  1.00 24.68           C  
ATOM   5607  N   ALA D  47      70.051  20.395  -5.304  1.00 17.25           N  
ATOM   5608  CA  ALA D  47      71.045  19.640  -4.560  1.00 17.08           C  
ATOM   5609  C   ALA D  47      70.646  18.181  -4.647  1.00 16.96           C  
ATOM   5610  O   ALA D  47      69.494  17.854  -4.390  1.00 18.06           O  
ATOM   5611  CB  ALA D  47      71.062  20.100  -3.101  1.00 16.94           C  
ATOM   5612  N   GLY D  48      71.585  17.312  -5.015  1.00 17.41           N  
ATOM   5613  CA  GLY D  48      71.265  15.893  -5.120  1.00 16.55           C  
ATOM   5614  C   GLY D  48      70.100  15.700  -6.077  1.00 19.05           C  
ATOM   5615  O   GLY D  48      70.087  16.259  -7.179  1.00 21.21           O  
ATOM   5616  N   ASP D  49      69.101  14.929  -5.650  1.00 16.39           N  
ATOM   5617  CA  ASP D  49      67.935  14.713  -6.495  1.00 17.59           C  
ATOM   5618  C   ASP D  49      66.773  15.590  -6.021  1.00 19.24           C  
ATOM   5619  O   ASP D  49      65.625  15.370  -6.397  1.00 21.26           O  
ATOM   5620  CB  ASP D  49      67.540  13.227  -6.497  1.00 17.54           C  
ATOM   5621  CG  ASP D  49      66.618  12.868  -7.664  1.00 22.90           C  
ATOM   5622  OD1 ASP D  49      66.845  13.354  -8.811  1.00 20.78           O  
ATOM   5623  OD2 ASP D  49      65.665  12.101  -7.436  1.00 21.43           O  
ATOM   5624  N   TYR D  50      67.082  16.598  -5.217  1.00 18.55           N  
ATOM   5625  CA  TYR D  50      66.047  17.506  -4.716  1.00 15.60           C  
ATOM   5626  C   TYR D  50      66.617  18.927  -4.640  1.00 16.26           C  
ATOM   5627  O   TYR D  50      67.195  19.409  -5.613  1.00 15.41           O  
ATOM   5628  CB  TYR D  50      65.536  17.020  -3.349  1.00 13.42           C  
ATOM   5629  CG  TYR D  50      64.251  17.708  -2.920  1.00 15.25           C  
ATOM   5630  CD1 TYR D  50      63.118  17.680  -3.739  1.00 17.81           C  
ATOM   5631  CD2 TYR D  50      64.199  18.467  -1.752  1.00 12.34           C  
ATOM   5632  CE1 TYR D  50      61.966  18.411  -3.406  1.00 19.50           C  
ATOM   5633  CE2 TYR D  50      63.053  19.202  -1.406  1.00 14.35           C  
ATOM   5634  CZ  TYR D  50      61.939  19.170  -2.245  1.00 19.77           C  
ATOM   5635  OH  TYR D  50      60.787  19.884  -1.926  1.00 20.17           O  
ATOM   5636  N   TYR D  51      66.484  19.592  -3.494  1.00 16.63           N  
ATOM   5637  CA  TYR D  51      66.994  20.959  -3.337  1.00 16.73           C  
ATOM   5638  C   TYR D  51      67.361  21.182  -1.901  1.00 16.28           C  
ATOM   5639  O   TYR D  51      66.920  20.430  -1.032  1.00 16.00           O  
ATOM   5640  CB  TYR D  51      65.905  21.996  -3.571  1.00 18.55           C  
ATOM   5641  CG  TYR D  51      65.214  21.906  -4.872  1.00 15.09           C  
ATOM   5642  CD1 TYR D  51      64.177  20.991  -5.055  1.00 22.48           C  
ATOM   5643  CD2 TYR D  51      65.612  22.700  -5.937  1.00 22.41           C  
ATOM   5644  CE1 TYR D  51      63.547  20.865  -6.278  1.00 30.14           C  
ATOM   5645  CE2 TYR D  51      64.988  22.582  -7.178  1.00 31.41           C  
ATOM   5646  CZ  TYR D  51      63.957  21.658  -7.331  1.00 33.28           C  
ATOM   5647  OH  TYR D  51      63.328  21.512  -8.546  1.00 41.82           O  
ATOM   5648  N   ALA D  52      68.158  22.220  -1.656  1.00 14.63           N  
ATOM   5649  CA  ALA D  52      68.443  22.612  -0.286  1.00 15.70           C  
ATOM   5650  C   ALA D  52      67.071  23.251   0.034  1.00 15.53           C  
ATOM   5651  O   ALA D  52      66.387  23.719  -0.869  1.00 16.41           O  
ATOM   5652  CB  ALA D  52      69.572  23.675  -0.233  1.00 16.69           C  
ATOM   5653  N   TYR D  53      66.654  23.282   1.292  1.00 13.42           N  
ATOM   5654  CA  TYR D  53      65.332  23.806   1.599  1.00 13.00           C  
ATOM   5655  C   TYR D  53      65.140  24.124   3.065  1.00 13.44           C  
ATOM   5656  O   TYR D  53      65.967  23.787   3.914  1.00 13.62           O  
ATOM   5657  CB  TYR D  53      64.262  22.741   1.225  1.00 12.18           C  
ATOM   5658  CG  TYR D  53      64.315  21.513   2.118  1.00 11.34           C  
ATOM   5659  CD1 TYR D  53      63.592  21.465   3.301  1.00 12.24           C  
ATOM   5660  CD2 TYR D  53      65.124  20.406   1.794  1.00 11.83           C  
ATOM   5661  CE1 TYR D  53      63.671  20.348   4.153  1.00 13.34           C  
ATOM   5662  CE2 TYR D  53      65.209  19.289   2.632  1.00 11.74           C  
ATOM   5663  CZ  TYR D  53      64.476  19.275   3.816  1.00 12.99           C  
ATOM   5664  OH  TYR D  53      64.562  18.224   4.695  1.00 14.84           O  
ATOM   5665  N   ALA D  54      64.027  24.788   3.338  1.00 13.47           N  
ATOM   5666  CA  ALA D  54      63.621  25.067   4.694  1.00 10.57           C  
ATOM   5667  C   ALA D  54      62.155  24.747   4.775  1.00 12.73           C  
ATOM   5668  O   ALA D  54      61.430  24.905   3.794  1.00 15.17           O  
ATOM   5669  CB  ALA D  54      63.831  26.530   5.047  1.00 16.90           C  
ATOM   5670  N   THR D  55      61.722  24.292   5.943  1.00 12.56           N  
ATOM   5671  CA  THR D  55      60.314  24.033   6.205  1.00 11.57           C  
ATOM   5672  C   THR D  55      59.945  24.723   7.497  1.00 11.59           C  
ATOM   5673  O   THR D  55      60.636  24.576   8.530  1.00 12.74           O  
ATOM   5674  CB  THR D  55      60.023  22.535   6.338  1.00 13.03           C  
ATOM   5675  OG1 THR D  55      60.448  21.893   5.144  1.00 11.83           O  
ATOM   5676  CG2 THR D  55      58.515  22.291   6.491  1.00 19.61           C  
ATOM   5677  N   PHE D  56      58.851  25.475   7.443  1.00 12.88           N  
ATOM   5678  CA  PHE D  56      58.361  26.195   8.598  1.00 12.42           C  
ATOM   5679  C   PHE D  56      57.021  25.638   9.042  1.00 15.58           C  
ATOM   5680  O   PHE D  56      56.072  25.552   8.245  1.00 17.11           O  
ATOM   5681  CB  PHE D  56      58.233  27.682   8.243  1.00 13.11           C  
ATOM   5682  CG  PHE D  56      59.508  28.268   7.773  1.00 15.28           C  
ATOM   5683  CD1 PHE D  56      60.538  28.535   8.685  1.00 18.26           C  
ATOM   5684  CD2 PHE D  56      59.746  28.461   6.403  1.00 14.29           C  
ATOM   5685  CE1 PHE D  56      61.796  28.978   8.236  1.00 18.74           C  
ATOM   5686  CE2 PHE D  56      61.000  28.900   5.957  1.00 15.24           C  
ATOM   5687  CZ  PHE D  56      62.024  29.155   6.884  1.00 18.22           C  
ATOM   5688  N   GLY D  57      56.963  25.255  10.316  1.00 11.37           N  
ATOM   5689  CA  GLY D  57      55.761  24.722  10.916  1.00 13.87           C  
ATOM   5690  C   GLY D  57      55.028  25.823  11.681  1.00 14.68           C  
ATOM   5691  O   GLY D  57      55.638  26.769  12.175  1.00 14.41           O  
ATOM   5692  N   PHE D  58      53.715  25.673  11.801  1.00 15.07           N  
ATOM   5693  CA  PHE D  58      52.876  26.683  12.451  1.00 17.27           C  
ATOM   5694  C   PHE D  58      52.002  26.113  13.537  1.00 19.78           C  
ATOM   5695  O   PHE D  58      51.703  24.926  13.536  1.00 20.64           O  
ATOM   5696  CB  PHE D  58      52.010  27.398  11.398  1.00 17.10           C  
ATOM   5697  CG  PHE D  58      52.804  28.231  10.446  1.00 15.82           C  
ATOM   5698  CD1 PHE D  58      53.405  27.662   9.326  1.00 12.63           C  
ATOM   5699  CD2 PHE D  58      53.044  29.567  10.722  1.00 16.88           C  
ATOM   5700  CE1 PHE D  58      54.249  28.407   8.504  1.00 15.42           C  
ATOM   5701  CE2 PHE D  58      53.873  30.326   9.913  1.00 17.30           C  
ATOM   5702  CZ  PHE D  58      54.487  29.753   8.801  1.00 18.48           C  
ATOM   5703  N   THR D  59      51.585  26.971  14.464  1.00 18.43           N  
ATOM   5704  CA  THR D  59      50.763  26.526  15.574  1.00 23.18           C  
ATOM   5705  C   THR D  59      49.410  25.999  15.126  1.00 26.24           C  
ATOM   5706  O   THR D  59      48.827  25.192  15.818  1.00 27.62           O  
ATOM   5707  CB  THR D  59      50.575  27.653  16.603  1.00 21.61           C  
ATOM   5708  OG1 THR D  59      50.139  28.841  15.942  1.00 22.44           O  
ATOM   5709  CG2 THR D  59      51.916  27.951  17.302  1.00 22.13           C  
ATOM   5710  N   SER D  60      48.923  26.470  13.981  1.00 28.16           N  
ATOM   5711  CA  SER D  60      47.648  26.009  13.426  1.00 30.50           C  
ATOM   5712  C   SER D  60      47.574  26.370  11.934  1.00 29.82           C  
ATOM   5713  O   SER D  60      48.467  27.020  11.392  1.00 27.64           O  
ATOM   5714  CB  SER D  60      46.457  26.666  14.152  1.00 26.99           C  
ATOM   5715  OG  SER D  60      46.372  28.045  13.809  1.00 34.67           O  
ATOM   5716  N   ALA D  61      46.479  25.975  11.283  1.00 31.39           N  
ATOM   5717  CA  ALA D  61      46.298  26.263   9.868  1.00 31.53           C  
ATOM   5718  C   ALA D  61      45.797  27.677   9.607  1.00 34.54           C  
ATOM   5719  O   ALA D  61      45.741  28.121   8.451  1.00 33.34           O  
ATOM   5720  CB  ALA D  61      45.340  25.237   9.253  1.00 36.93           C  
ATOM   5721  N   ALA D  62      45.444  28.392  10.676  1.00 32.40           N  
ATOM   5722  CA  ALA D  62      44.949  29.766  10.553  1.00 35.59           C  
ATOM   5723  C   ALA D  62      45.937  30.700   9.869  1.00 35.02           C  
ATOM   5724  O   ALA D  62      47.153  30.537   9.970  1.00 32.34           O  
ATOM   5725  CB  ALA D  62      44.598  30.318  11.935  1.00 36.62           C  
ATOM   5726  N   ALA D  63      45.413  31.705   9.187  1.00 32.26           N  
ATOM   5727  CA  ALA D  63      46.271  32.658   8.500  1.00 35.48           C  
ATOM   5728  C   ALA D  63      47.071  33.483   9.502  1.00 34.17           C  
ATOM   5729  O   ALA D  63      48.034  34.160   9.131  1.00 36.86           O  
ATOM   5730  CB  ALA D  63      45.441  33.576   7.612  1.00 34.97           C  
ATOM   5731  N   ASP D  64      46.672  33.438  10.766  1.00 34.09           N  
ATOM   5732  CA  ASP D  64      47.390  34.198  11.778  1.00 40.77           C  
ATOM   5733  C   ASP D  64      48.099  33.244  12.746  1.00 38.48           C  
ATOM   5734  O   ASP D  64      48.294  33.541  13.931  1.00 37.13           O  
ATOM   5735  CB  ASP D  64      46.439  35.165  12.522  1.00 43.02           C  
ATOM   5736  CG  ASP D  64      45.401  34.449  13.379  1.00 53.63           C  
ATOM   5737  OD1 ASP D  64      44.844  35.115  14.279  1.00 58.32           O  
ATOM   5738  OD2 ASP D  64      45.129  33.244  13.164  1.00 54.03           O  
ATOM   5739  N   ALA D  65      48.476  32.083  12.219  1.00 32.32           N  
ATOM   5740  CA  ALA D  65      49.193  31.086  13.005  1.00 28.10           C  
ATOM   5741  C   ALA D  65      50.617  31.600  13.133  1.00 25.18           C  
ATOM   5742  O   ALA D  65      51.056  32.435  12.342  1.00 24.50           O  
ATOM   5743  CB  ALA D  65      49.180  29.746  12.289  1.00 29.71           C  
ATOM   5744  N   LYS D  66      51.354  31.085  14.110  1.00 21.89           N  
ATOM   5745  CA  LYS D  66      52.720  31.547  14.314  1.00 21.98           C  
ATOM   5746  C   LYS D  66      53.692  30.397  14.126  1.00 15.49           C  
ATOM   5747  O   LYS D  66      53.354  29.244  14.365  1.00 20.03           O  
ATOM   5748  CB  LYS D  66      52.875  32.107  15.726  1.00 23.27           C  
ATOM   5749  CG  LYS D  66      51.939  33.287  15.994  1.00 32.00           C  
ATOM   5750  CD  LYS D  66      52.057  33.763  17.432  1.00 43.66           C  
ATOM   5751  CE  LYS D  66      51.069  34.902  17.709  1.00 49.12           C  
ATOM   5752  NZ  LYS D  66      49.661  34.459  17.491  1.00 52.46           N  
ATOM   5753  N   VAL D  67      54.900  30.741  13.730  1.00 16.02           N  
ATOM   5754  CA  VAL D  67      55.942  29.732  13.508  1.00 16.74           C  
ATOM   5755  C   VAL D  67      56.326  29.075  14.819  1.00 15.89           C  
ATOM   5756  O   VAL D  67      56.692  29.762  15.794  1.00 15.64           O  
ATOM   5757  CB  VAL D  67      57.210  30.378  12.897  1.00 13.39           C  
ATOM   5758  CG1 VAL D  67      58.368  29.364  12.854  1.00 12.54           C  
ATOM   5759  CG2 VAL D  67      56.912  30.890  11.498  1.00 17.31           C  
ATOM   5760  N   ASP D  68      56.232  27.752  14.870  1.00 15.30           N  
ATOM   5761  CA  ASP D  68      56.628  27.048  16.079  1.00 11.49           C  
ATOM   5762  C   ASP D  68      57.723  26.036  15.762  1.00 14.44           C  
ATOM   5763  O   ASP D  68      58.186  25.329  16.646  1.00 14.79           O  
ATOM   5764  CB  ASP D  68      55.438  26.363  16.794  1.00 11.42           C  
ATOM   5765  CG  ASP D  68      54.732  25.304  15.950  1.00 15.92           C  
ATOM   5766  OD1 ASP D  68      55.143  25.027  14.812  1.00 16.29           O  
ATOM   5767  OD2 ASP D  68      53.750  24.730  16.470  1.00 19.10           O  
ATOM   5768  N   SER D  69      58.140  25.978  14.503  1.00 12.10           N  
ATOM   5769  CA  SER D  69      59.225  25.064  14.145  1.00 13.80           C  
ATOM   5770  C   SER D  69      59.941  25.482  12.872  1.00 12.60           C  
ATOM   5771  O   SER D  69      59.327  25.960  11.916  1.00 15.23           O  
ATOM   5772  CB  SER D  69      58.715  23.620  14.034  1.00 24.58           C  
ATOM   5773  OG  SER D  69      58.178  23.348  12.780  1.00 28.66           O  
ATOM   5774  N   LYS D  70      61.263  25.328  12.871  1.00  9.60           N  
ATOM   5775  CA  LYS D  70      62.080  25.662  11.717  1.00 10.75           C  
ATOM   5776  C   LYS D  70      62.986  24.475  11.435  1.00 10.82           C  
ATOM   5777  O   LYS D  70      63.653  23.971  12.346  1.00 13.76           O  
ATOM   5778  CB  LYS D  70      62.979  26.873  12.011  1.00 10.84           C  
ATOM   5779  CG  LYS D  70      62.223  28.171  12.286  1.00 17.96           C  
ATOM   5780  CD  LYS D  70      63.184  29.266  12.766  1.00 23.13           C  
ATOM   5781  CE  LYS D  70      64.110  29.720  11.643  1.00 24.30           C  
ATOM   5782  NZ  LYS D  70      65.155  30.673  12.123  1.00 21.68           N  
ATOM   5783  N   SER D  71      63.013  24.041  10.184  1.00 10.48           N  
ATOM   5784  CA  SER D  71      63.880  22.924   9.759  1.00 10.26           C  
ATOM   5785  C   SER D  71      64.560  23.283   8.456  1.00 11.36           C  
ATOM   5786  O   SER D  71      64.004  24.013   7.635  1.00 13.38           O  
ATOM   5787  CB  SER D  71      63.046  21.669   9.503  1.00 15.99           C  
ATOM   5788  OG  SER D  71      62.330  21.327  10.671  1.00 25.52           O  
ATOM   5789  N   GLN D  72      65.773  22.788   8.266  1.00 11.26           N  
ATOM   5790  CA  GLN D  72      66.438  23.055   7.016  1.00 14.11           C  
ATOM   5791  C   GLN D  72      67.472  22.005   6.712  1.00 11.83           C  
ATOM   5792  O   GLN D  72      67.964  21.343   7.617  1.00 13.84           O  
ATOM   5793  CB  GLN D  72      67.121  24.427   7.061  1.00 18.09           C  
ATOM   5794  CG  GLN D  72      68.307  24.560   8.062  1.00 16.07           C  
ATOM   5795  CD  GLN D  72      69.650  24.019   7.553  1.00 18.99           C  
ATOM   5796  OE1 GLN D  72      70.011  24.162   6.380  1.00 15.31           O  
ATOM   5797  NE2 GLN D  72      70.410  23.431   8.457  1.00 18.34           N  
ATOM   5798  N   GLU D  73      67.704  21.794   5.420  1.00 11.79           N  
ATOM   5799  CA  GLU D  73      68.805  20.973   4.953  1.00 12.59           C  
ATOM   5800  C   GLU D  73      69.560  21.729   3.871  1.00 13.70           C  
ATOM   5801  O   GLU D  73      68.974  22.267   2.928  1.00 13.67           O  
ATOM   5802  CB  GLU D  73      68.390  19.621   4.357  1.00 12.77           C  
ATOM   5803  CG  GLU D  73      67.848  18.660   5.388  1.00 11.68           C  
ATOM   5804  CD  GLU D  73      67.737  17.266   4.830  1.00 15.72           C  
ATOM   5805  OE1 GLU D  73      66.618  16.863   4.452  1.00 13.08           O  
ATOM   5806  OE2 GLU D  73      68.779  16.602   4.773  1.00 13.46           O  
ATOM   5807  N   LYS D  74      70.877  21.767   4.048  1.00 14.82           N  
ATOM   5808  CA  LYS D  74      71.795  22.338   3.091  1.00 16.54           C  
ATOM   5809  C   LYS D  74      71.760  23.828   2.813  1.00 17.82           C  
ATOM   5810  O   LYS D  74      72.278  24.277   1.798  1.00 17.10           O  
ATOM   5811  CB  LYS D  74      71.707  21.505   1.798  1.00 16.60           C  
ATOM   5812  CG  LYS D  74      72.219  20.094   2.078  1.00 17.60           C  
ATOM   5813  CD  LYS D  74      71.781  19.042   1.070  1.00 24.00           C  
ATOM   5814  CE  LYS D  74      72.035  17.632   1.630  1.00 19.92           C  
ATOM   5815  NZ  LYS D  74      73.404  17.220   1.328  1.00 22.73           N  
ATOM   5816  N   LEU D  75      71.160  24.590   3.723  1.00 15.76           N  
ATOM   5817  CA  LEU D  75      71.124  26.044   3.593  1.00 14.51           C  
ATOM   5818  C   LEU D  75      72.203  26.675   4.470  1.00 19.53           C  
ATOM   5819  O   LEU D  75      72.726  27.717   4.116  1.00 21.96           O  
ATOM   5820  CB  LEU D  75      69.777  26.622   4.037  1.00 14.46           C  
ATOM   5821  CG  LEU D  75      68.571  26.303   3.138  1.00 15.18           C  
ATOM   5822  CD1 LEU D  75      67.316  26.998   3.665  1.00 13.58           C  
ATOM   5823  CD2 LEU D  75      68.872  26.786   1.706  1.00 16.73           C  
ATOM   5824  N   LEU D  76      72.487  26.059   5.617  1.00 21.82           N  
ATOM   5825  CA  LEU D  76      73.480  26.557   6.576  1.00 19.77           C  
ATOM   5826  C   LEU D  76      74.739  25.703   6.515  1.00 22.01           C  
ATOM   5827  O   LEU D  76      74.670  24.486   6.452  1.00 25.45           O  
ATOM   5828  CB  LEU D  76      72.918  26.499   8.004  1.00 20.13           C  
ATOM   5829  CG  LEU D  76      71.621  27.267   8.277  1.00 22.48           C  
ATOM   5830  CD1 LEU D  76      71.189  27.075   9.725  1.00 23.68           C  
ATOM   5831  CD2 LEU D  76      71.840  28.732   7.963  1.00 29.08           C  
ATOM   5832  N   ALA D  77      75.903  26.338   6.549  1.00 22.45           N  
ATOM   5833  CA  ALA D  77      77.140  25.577   6.511  1.00 22.54           C  
ATOM   5834  C   ALA D  77      77.794  25.645   7.890  1.00 22.03           C  
ATOM   5835  O   ALA D  77      77.639  26.642   8.599  1.00 21.83           O  
ATOM   5836  CB  ALA D  77      78.078  26.148   5.437  1.00 24.13           C  
ATOM   5837  N   PRO D  78      78.471  24.565   8.322  1.00 20.83           N  
ATOM   5838  CA  PRO D  78      79.100  24.648   9.647  1.00 24.74           C  
ATOM   5839  C   PRO D  78      80.278  25.621   9.525  1.00 27.83           C  
ATOM   5840  O   PRO D  78      80.898  25.698   8.465  1.00 27.13           O  
ATOM   5841  CB  PRO D  78      79.536  23.211   9.913  1.00 23.89           C  
ATOM   5842  CG  PRO D  78      79.796  22.675   8.547  1.00 21.66           C  
ATOM   5843  CD  PRO D  78      78.674  23.237   7.719  1.00 21.24           C  
ATOM   5844  N   SER D  79      80.583  26.356  10.587  1.00 28.07           N  
ATOM   5845  CA  SER D  79      81.667  27.327  10.514  1.00 31.14           C  
ATOM   5846  C   SER D  79      83.081  26.738  10.542  1.00 33.94           C  
ATOM   5847  O   SER D  79      83.960  27.215   9.826  1.00 34.82           O  
ATOM   5848  CB  SER D  79      81.498  28.386  11.612  1.00 29.42           C  
ATOM   5849  OG  SER D  79      81.358  27.802  12.892  1.00 31.75           O  
ATOM   5850  N   ALA D  80      83.295  25.693  11.334  1.00 31.56           N  
ATOM   5851  CA  ALA D  80      84.610  25.061  11.444  1.00 31.37           C  
ATOM   5852  C   ALA D  80      84.386  23.618  11.843  1.00 29.64           C  
ATOM   5853  O   ALA D  80      84.536  23.252  13.015  1.00 30.47           O  
ATOM   5854  CB  ALA D  80      85.445  25.779  12.512  1.00 32.76           C  
ATOM   5855  N   PRO D  81      84.052  22.757  10.867  1.00 26.20           N  
ATOM   5856  CA  PRO D  81      83.808  21.356  11.206  1.00 26.04           C  
ATOM   5857  C   PRO D  81      85.036  20.554  11.591  1.00 26.13           C  
ATOM   5858  O   PRO D  81      86.013  20.540  10.858  1.00 29.44           O  
ATOM   5859  CB  PRO D  81      83.121  20.813   9.952  1.00 27.04           C  
ATOM   5860  CG  PRO D  81      83.753  21.611   8.848  1.00 26.32           C  
ATOM   5861  CD  PRO D  81      83.860  23.011   9.428  1.00 24.62           C  
ATOM   5862  N   THR D  82      84.957  19.852  12.722  1.00 25.77           N  
ATOM   5863  CA  THR D  82      86.070  19.051  13.207  1.00 24.33           C  
ATOM   5864  C   THR D  82      85.644  17.721  13.810  1.00 28.48           C  
ATOM   5865  O   THR D  82      86.422  17.029  14.467  1.00 26.94           O  
ATOM   5866  CB  THR D  82      86.854  19.853  14.250  1.00 30.36           C  
ATOM   5867  OG1 THR D  82      85.996  20.198  15.347  1.00 28.09           O  
ATOM   5868  CG2 THR D  82      87.365  21.133  13.618  1.00 28.86           C  
ATOM   5869  N   LEU D  83      84.393  17.349  13.581  1.00 23.79           N  
ATOM   5870  CA  LEU D  83      83.883  16.094  14.093  1.00 22.61           C  
ATOM   5871  C   LEU D  83      84.696  14.945  13.501  1.00 20.44           C  
ATOM   5872  O   LEU D  83      85.145  15.039  12.363  1.00 22.84           O  
ATOM   5873  CB  LEU D  83      82.424  15.935  13.652  1.00 19.86           C  
ATOM   5874  CG  LEU D  83      81.712  14.662  14.066  1.00 21.57           C  
ATOM   5875  CD1 LEU D  83      81.665  14.561  15.581  1.00 21.49           C  
ATOM   5876  CD2 LEU D  83      80.287  14.689  13.471  1.00 23.79           C  
ATOM   5877  N   THR D  84      84.892  13.880  14.264  1.00 18.94           N  
ATOM   5878  CA  THR D  84      85.587  12.696  13.766  1.00 19.73           C  
ATOM   5879  C   THR D  84      84.827  11.570  14.402  1.00 19.85           C  
ATOM   5880  O   THR D  84      84.024  11.815  15.295  1.00 21.49           O  
ATOM   5881  CB  THR D  84      87.056  12.605  14.225  1.00 22.64           C  
ATOM   5882  OG1 THR D  84      87.093  12.566  15.653  1.00 25.16           O  
ATOM   5883  CG2 THR D  84      87.841  13.786  13.708  1.00 24.39           C  
ATOM   5884  N   LEU D  85      85.051  10.340  13.944  1.00 19.27           N  
ATOM   5885  CA  LEU D  85      84.349   9.207  14.526  1.00 19.48           C  
ATOM   5886  C   LEU D  85      84.749   9.132  15.995  1.00 23.82           C  
ATOM   5887  O   LEU D  85      83.928   8.838  16.850  1.00 21.67           O  
ATOM   5888  CB  LEU D  85      84.717   7.913  13.807  1.00 23.27           C  
ATOM   5889  CG  LEU D  85      84.125   6.611  14.364  1.00 25.00           C  
ATOM   5890  CD1 LEU D  85      82.612   6.631  14.319  1.00 24.65           C  
ATOM   5891  CD2 LEU D  85      84.656   5.437  13.529  1.00 31.08           C  
ATOM   5892  N   ALA D  86      86.020   9.421  16.273  1.00 23.47           N  
ATOM   5893  CA  ALA D  86      86.520   9.383  17.652  1.00 28.84           C  
ATOM   5894  C   ALA D  86      85.669  10.265  18.577  1.00 23.21           C  
ATOM   5895  O   ALA D  86      85.209   9.818  19.634  1.00 21.79           O  
ATOM   5896  CB  ALA D  86      87.977   9.846  17.686  1.00 28.66           C  
ATOM   5897  N   LYS D  87      85.471  11.511  18.164  1.00 22.30           N  
ATOM   5898  CA  LYS D  87      84.692  12.470  18.940  1.00 22.19           C  
ATOM   5899  C   LYS D  87      83.225  12.079  19.064  1.00 23.90           C  
ATOM   5900  O   LYS D  87      82.608  12.271  20.105  1.00 20.38           O  
ATOM   5901  CB  LYS D  87      84.813  13.847  18.321  1.00 24.13           C  
ATOM   5902  CG  LYS D  87      86.238  14.425  18.350  1.00 28.69           C  
ATOM   5903  CD  LYS D  87      86.240  15.821  17.817  1.00 28.57           C  
ATOM   5904  CE  LYS D  87      87.628  16.316  17.518  1.00 39.84           C  
ATOM   5905  NZ  LYS D  87      87.554  17.694  16.963  1.00 43.29           N  
ATOM   5906  N   PHE D  88      82.662  11.557  17.978  1.00 20.71           N  
ATOM   5907  CA  PHE D  88      81.280  11.110  17.986  1.00 20.56           C  
ATOM   5908  C   PHE D  88      81.081  10.033  19.049  1.00 18.18           C  
ATOM   5909  O   PHE D  88      80.065  10.015  19.742  1.00 18.27           O  
ATOM   5910  CB  PHE D  88      80.907  10.537  16.611  1.00 20.15           C  
ATOM   5911  CG  PHE D  88      79.544   9.940  16.553  1.00 13.18           C  
ATOM   5912  CD1 PHE D  88      78.424  10.759  16.344  1.00 22.90           C  
ATOM   5913  CD2 PHE D  88      79.351   8.581  16.745  1.00 17.54           C  
ATOM   5914  CE1 PHE D  88      77.141  10.220  16.338  1.00 14.53           C  
ATOM   5915  CE2 PHE D  88      78.066   8.034  16.736  1.00 22.37           C  
ATOM   5916  CZ  PHE D  88      76.962   8.861  16.534  1.00 19.54           C  
ATOM   5917  N   ASN D  89      82.051   9.130  19.180  1.00 17.60           N  
ATOM   5918  CA  ASN D  89      81.936   8.052  20.138  1.00 20.60           C  
ATOM   5919  C   ASN D  89      82.044   8.508  21.599  1.00 21.16           C  
ATOM   5920  O   ASN D  89      81.594   7.808  22.505  1.00 28.18           O  
ATOM   5921  CB  ASN D  89      82.965   6.959  19.812  1.00 24.51           C  
ATOM   5922  CG  ASN D  89      82.621   6.204  18.522  1.00 37.32           C  
ATOM   5923  OD1 ASN D  89      81.443   5.936  18.240  1.00 31.41           O  
ATOM   5924  ND2 ASN D  89      83.646   5.850  17.742  1.00 36.37           N  
ATOM   5925  N   GLN D  90      82.594   9.694  21.816  1.00 19.73           N  
ATOM   5926  CA  GLN D  90      82.718  10.236  23.167  1.00 21.36           C  
ATOM   5927  C   GLN D  90      81.447  10.969  23.620  1.00 24.08           C  
ATOM   5928  O   GLN D  90      81.281  11.273  24.798  1.00 23.13           O  
ATOM   5929  CB  GLN D  90      83.935  11.167  23.235  1.00 23.16           C  
ATOM   5930  CG  GLN D  90      85.242  10.405  23.020  1.00 21.81           C  
ATOM   5931  CD  GLN D  90      86.336  11.244  22.387  1.00 30.41           C  
ATOM   5932  OE1 GLN D  90      86.225  12.469  22.308  1.00 36.06           O  
ATOM   5933  NE2 GLN D  90      87.416  10.583  21.938  1.00 33.73           N  
ATOM   5934  N   VAL D  91      80.551  11.264  22.682  1.00 19.38           N  
ATOM   5935  CA  VAL D  91      79.300  11.919  23.008  1.00 18.63           C  
ATOM   5936  C   VAL D  91      78.386  10.889  23.676  1.00 20.43           C  
ATOM   5937  O   VAL D  91      78.248   9.776  23.186  1.00 24.75           O  
ATOM   5938  CB  VAL D  91      78.622  12.455  21.721  1.00 16.54           C  
ATOM   5939  CG1 VAL D  91      77.222  12.970  22.050  1.00 20.47           C  
ATOM   5940  CG2 VAL D  91      79.487  13.541  21.102  1.00 19.37           C  
ATOM   5941  N   THR D  92      77.759  11.246  24.788  1.00 18.17           N  
ATOM   5942  CA  THR D  92      76.897  10.301  25.478  1.00 19.27           C  
ATOM   5943  C   THR D  92      75.519  10.884  25.755  1.00 20.50           C  
ATOM   5944  O   THR D  92      75.382  12.081  25.992  1.00 19.47           O  
ATOM   5945  CB  THR D  92      77.519   9.879  26.824  1.00 23.24           C  
ATOM   5946  OG1 THR D  92      77.780  11.051  27.597  1.00 26.21           O  
ATOM   5947  CG2 THR D  92      78.829   9.159  26.609  1.00 22.57           C  
ATOM   5948  N   VAL D  93      74.498  10.036  25.712  1.00 18.82           N  
ATOM   5949  CA  VAL D  93      73.143  10.478  25.989  1.00 18.90           C  
ATOM   5950  C   VAL D  93      73.101  11.085  27.382  1.00 25.63           C  
ATOM   5951  O   VAL D  93      73.762  10.596  28.311  1.00 25.41           O  
ATOM   5952  CB  VAL D  93      72.165   9.297  25.874  1.00 23.82           C  
ATOM   5953  CG1 VAL D  93      70.831   9.646  26.493  1.00 28.74           C  
ATOM   5954  CG2 VAL D  93      71.979   8.959  24.400  1.00 25.50           C  
ATOM   5955  N   GLY D  94      72.334  12.158  27.532  1.00 19.40           N  
ATOM   5956  CA  GLY D  94      72.244  12.835  28.811  1.00 21.21           C  
ATOM   5957  C   GLY D  94      73.111  14.088  28.874  1.00 22.11           C  
ATOM   5958  O   GLY D  94      72.974  14.885  29.799  1.00 21.60           O  
ATOM   5959  N   MET D  95      74.012  14.266  27.910  1.00 20.77           N  
ATOM   5960  CA  MET D  95      74.858  15.451  27.880  1.00 16.63           C  
ATOM   5961  C   MET D  95      74.043  16.682  27.512  1.00 22.23           C  
ATOM   5962  O   MET D  95      73.050  16.599  26.784  1.00 17.99           O  
ATOM   5963  CB  MET D  95      75.968  15.330  26.834  1.00 16.67           C  
ATOM   5964  CG  MET D  95      77.226  14.591  27.260  1.00 15.76           C  
ATOM   5965  SD  MET D  95      78.387  14.637  25.918  1.00 21.31           S  
ATOM   5966  CE  MET D  95      79.914  14.065  26.817  1.00 25.76           C  
ATOM   5967  N   THR D  96      74.467  17.842  27.999  1.00 19.30           N  
ATOM   5968  CA  THR D  96      73.783  19.078  27.631  1.00 19.05           C  
ATOM   5969  C   THR D  96      74.316  19.499  26.268  1.00 17.74           C  
ATOM   5970  O   THR D  96      75.328  18.978  25.782  1.00 15.37           O  
ATOM   5971  CB  THR D  96      74.113  20.238  28.585  1.00 19.76           C  
ATOM   5972  OG1 THR D  96      75.527  20.466  28.554  1.00 19.31           O  
ATOM   5973  CG2 THR D  96      73.649  19.920  29.979  1.00 21.09           C  
ATOM   5974  N   ARG D  97      73.638  20.458  25.652  1.00 17.62           N  
ATOM   5975  CA  ARG D  97      74.065  20.957  24.363  1.00 20.53           C  
ATOM   5976  C   ARG D  97      75.505  21.499  24.485  1.00 20.51           C  
ATOM   5977  O   ARG D  97      76.351  21.267  23.614  1.00 17.42           O  
ATOM   5978  CB  ARG D  97      73.078  22.050  23.914  1.00 20.46           C  
ATOM   5979  CG  ARG D  97      73.407  22.666  22.586  1.00 30.77           C  
ATOM   5980  CD  ARG D  97      72.440  23.782  22.279  1.00 33.93           C  
ATOM   5981  NE  ARG D  97      72.633  24.285  20.926  1.00 45.97           N  
ATOM   5982  CZ  ARG D  97      71.829  25.169  20.343  1.00 49.48           C  
ATOM   5983  NH1 ARG D  97      70.777  25.648  21.000  1.00 51.46           N  
ATOM   5984  NH2 ARG D  97      72.069  25.564  19.097  1.00 52.92           N  
ATOM   5985  N   ALA D  98      75.800  22.207  25.575  1.00 19.10           N  
ATOM   5986  CA  ALA D  98      77.147  22.727  25.762  1.00 20.55           C  
ATOM   5987  C   ALA D  98      78.186  21.601  25.813  1.00 18.67           C  
ATOM   5988  O   ALA D  98      79.251  21.708  25.204  1.00 21.96           O  
ATOM   5989  CB  ALA D  98      77.210  23.561  27.039  1.00 24.01           C  
ATOM   5990  N   GLN D  99      77.875  20.521  26.516  1.00 18.47           N  
ATOM   5991  CA  GLN D  99      78.814  19.401  26.624  1.00 19.55           C  
ATOM   5992  C   GLN D  99      79.039  18.740  25.287  1.00 20.14           C  
ATOM   5993  O   GLN D  99      80.167  18.379  24.927  1.00 19.30           O  
ATOM   5994  CB  GLN D  99      78.284  18.386  27.615  1.00 17.04           C  
ATOM   5995  CG  GLN D  99      78.289  18.921  29.038  1.00 23.52           C  
ATOM   5996  CD  GLN D  99      77.772  17.913  29.995  1.00 24.06           C  
ATOM   5997  OE1 GLN D  99      76.729  17.328  29.768  1.00 27.88           O  
ATOM   5998  NE2 GLN D  99      78.506  17.690  31.090  1.00 25.86           N  
ATOM   5999  N   VAL D 100      77.955  18.567  24.535  1.00 18.49           N  
ATOM   6000  CA  VAL D 100      78.084  17.961  23.209  1.00 15.88           C  
ATOM   6001  C   VAL D 100      78.972  18.810  22.291  1.00 16.77           C  
ATOM   6002  O   VAL D 100      79.874  18.277  21.626  1.00 19.30           O  
ATOM   6003  CB  VAL D 100      76.685  17.759  22.551  1.00 14.08           C  
ATOM   6004  CG1 VAL D 100      76.843  17.382  21.096  1.00 22.79           C  
ATOM   6005  CG2 VAL D 100      75.911  16.691  23.302  1.00 14.99           C  
ATOM   6006  N   LEU D 101      78.759  20.128  22.273  1.00 19.28           N  
ATOM   6007  CA  LEU D 101      79.543  20.988  21.407  1.00 22.10           C  
ATOM   6008  C   LEU D 101      81.004  21.009  21.846  1.00 26.53           C  
ATOM   6009  O   LEU D 101      81.888  21.157  21.016  1.00 25.45           O  
ATOM   6010  CB  LEU D 101      78.956  22.407  21.359  1.00 20.79           C  
ATOM   6011  CG  LEU D 101      77.552  22.501  20.711  1.00 20.60           C  
ATOM   6012  CD1 LEU D 101      76.987  23.894  20.811  1.00 29.95           C  
ATOM   6013  CD2 LEU D 101      77.642  22.118  19.270  1.00 25.86           C  
ATOM   6014  N   ALA D 102      81.254  20.837  23.142  1.00 22.07           N  
ATOM   6015  CA  ALA D 102      82.631  20.809  23.642  1.00 24.76           C  
ATOM   6016  C   ALA D 102      83.312  19.554  23.098  1.00 24.57           C  
ATOM   6017  O   ALA D 102      84.514  19.540  22.816  1.00 29.59           O  
ATOM   6018  CB  ALA D 102      82.637  20.786  25.189  1.00 21.19           C  
ATOM   6019  N   THR D 103      82.527  18.497  22.945  1.00 19.86           N  
ATOM   6020  CA  THR D 103      83.033  17.219  22.462  1.00 23.26           C  
ATOM   6021  C   THR D 103      83.214  17.139  20.943  1.00 25.27           C  
ATOM   6022  O   THR D 103      84.272  16.712  20.464  1.00 25.43           O  
ATOM   6023  CB  THR D 103      82.100  16.079  22.910  1.00 25.06           C  
ATOM   6024  OG1 THR D 103      81.895  16.157  24.329  1.00 24.61           O  
ATOM   6025  CG2 THR D 103      82.687  14.722  22.542  1.00 24.57           C  
ATOM   6026  N   VAL D 104      82.204  17.561  20.174  1.00 23.03           N  
ATOM   6027  CA  VAL D 104      82.311  17.475  18.712  1.00 19.38           C  
ATOM   6028  C   VAL D 104      82.887  18.679  18.007  1.00 24.29           C  
ATOM   6029  O   VAL D 104      83.134  18.638  16.801  1.00 23.96           O  
ATOM   6030  CB  VAL D 104      80.955  17.210  18.068  1.00 22.42           C  
ATOM   6031  CG1 VAL D 104      80.356  15.956  18.655  1.00 24.07           C  
ATOM   6032  CG2 VAL D 104      80.050  18.427  18.270  1.00 19.63           C  
ATOM   6033  N   GLY D 105      83.097  19.759  18.744  1.00 23.76           N  
ATOM   6034  CA  GLY D 105      83.630  20.954  18.126  1.00 29.06           C  
ATOM   6035  C   GLY D 105      82.556  22.016  18.015  1.00 29.62           C  
ATOM   6036  O   GLY D 105      81.482  21.791  17.451  1.00 26.62           O  
ATOM   6037  N   GLN D 106      82.849  23.190  18.543  1.00 28.89           N  
ATOM   6038  CA  GLN D 106      81.903  24.296  18.514  1.00 32.43           C  
ATOM   6039  C   GLN D 106      81.441  24.727  17.128  1.00 30.30           C  
ATOM   6040  O   GLN D 106      80.392  25.346  17.006  1.00 32.74           O  
ATOM   6041  CB  GLN D 106      82.507  25.520  19.211  1.00 37.43           C  
ATOM   6042  CG  GLN D 106      82.802  25.346  20.694  1.00 50.19           C  
ATOM   6043  CD  GLN D 106      81.546  25.362  21.543  1.00 56.05           C  
ATOM   6044  OE1 GLN D 106      80.661  26.206  21.350  1.00 57.74           O  
ATOM   6045  NE2 GLN D 106      81.465  24.440  22.501  1.00 58.55           N  
ATOM   6046  N   GLY D 107      82.212  24.430  16.089  1.00 25.42           N  
ATOM   6047  CA  GLY D 107      81.799  24.858  14.761  1.00 25.24           C  
ATOM   6048  C   GLY D 107      81.474  23.722  13.806  1.00 26.29           C  
ATOM   6049  O   GLY D 107      81.440  23.915  12.586  1.00 26.12           O  
ATOM   6050  N   SER D 108      81.212  22.544  14.359  1.00 25.22           N  
ATOM   6051  CA  SER D 108      80.939  21.364  13.547  1.00 19.78           C  
ATOM   6052  C   SER D 108      79.461  21.151  13.223  1.00 21.55           C  
ATOM   6053  O   SER D 108      79.130  20.307  12.402  1.00 19.88           O  
ATOM   6054  CB  SER D 108      81.424  20.110  14.260  1.00 24.18           C  
ATOM   6055  OG  SER D 108      82.810  20.169  14.593  1.00 24.02           O  
ATOM   6056  N   CYS D 109      78.588  21.912  13.848  1.00 17.02           N  
ATOM   6057  CA  CYS D 109      77.162  21.639  13.661  1.00 18.00           C  
ATOM   6058  C   CYS D 109      76.291  22.779  13.244  1.00 21.46           C  
ATOM   6059  O   CYS D 109      76.602  23.935  13.494  1.00 19.76           O  
ATOM   6060  CB  CYS D 109      76.589  21.122  14.961  1.00 17.26           C  
ATOM   6061  SG  CYS D 109      77.456  19.781  15.846  1.00 18.28           S  
ATOM   6062  N   THR D 110      75.152  22.429  12.643  1.00 15.76           N  
ATOM   6063  CA  THR D 110      74.160  23.426  12.265  1.00 16.45           C  
ATOM   6064  C   THR D 110      72.835  22.893  12.781  1.00 16.41           C  
ATOM   6065  O   THR D 110      72.721  21.708  13.105  1.00 13.91           O  
ATOM   6066  CB  THR D 110      74.053  23.582  10.749  1.00 17.79           C  
ATOM   6067  OG1 THR D 110      73.721  22.319  10.185  1.00 16.40           O  
ATOM   6068  CG2 THR D 110      75.395  24.061  10.167  1.00 18.05           C  
ATOM   6069  N   THR D 111      71.834  23.758  12.887  1.00 15.15           N  
ATOM   6070  CA  THR D 111      70.537  23.289  13.366  1.00 15.95           C  
ATOM   6071  C   THR D 111      69.731  22.691  12.216  1.00 15.50           C  
ATOM   6072  O   THR D 111      69.468  23.364  11.226  1.00 17.05           O  
ATOM   6073  CB  THR D 111      69.739  24.437  13.969  1.00 21.04           C  
ATOM   6074  OG1 THR D 111      70.509  25.006  15.037  1.00 24.14           O  
ATOM   6075  CG2 THR D 111      68.411  23.931  14.513  1.00 22.59           C  
ATOM   6076  N   TRP D 112      69.367  21.419  12.353  1.00 12.79           N  
ATOM   6077  CA  TRP D 112      68.562  20.742  11.348  1.00 13.20           C  
ATOM   6078  C   TRP D 112      67.108  21.109  11.650  1.00 13.75           C  
ATOM   6079  O   TRP D 112      66.383  21.581  10.769  1.00 17.45           O  
ATOM   6080  CB  TRP D 112      68.766  19.238  11.454  1.00 15.01           C  
ATOM   6081  CG  TRP D 112      68.094  18.425  10.347  1.00 14.36           C  
ATOM   6082  CD1 TRP D 112      67.198  18.876   9.417  1.00 18.54           C  
ATOM   6083  CD2 TRP D 112      68.274  17.031  10.089  1.00 12.93           C  
ATOM   6084  NE1 TRP D 112      66.808  17.838   8.587  1.00 17.73           N  
ATOM   6085  CE2 TRP D 112      67.454  16.696   8.979  1.00 16.20           C  
ATOM   6086  CE3 TRP D 112      69.052  16.024  10.685  1.00 14.87           C  
ATOM   6087  CZ2 TRP D 112      67.387  15.399   8.455  1.00 16.76           C  
ATOM   6088  CZ3 TRP D 112      68.984  14.738  10.167  1.00 21.35           C  
ATOM   6089  CH2 TRP D 112      68.153  14.436   9.054  1.00 21.69           C  
ATOM   6090  N   SER D 113      66.655  20.874  12.882  1.00 11.20           N  
ATOM   6091  CA  SER D 113      65.279  21.235  13.207  1.00 13.73           C  
ATOM   6092  C   SER D 113      65.129  21.679  14.638  1.00 15.35           C  
ATOM   6093  O   SER D 113      65.815  21.187  15.533  1.00 17.81           O  
ATOM   6094  CB  SER D 113      64.324  20.082  12.923  1.00 19.51           C  
ATOM   6095  OG  SER D 113      64.658  18.998  13.731  1.00 27.59           O  
ATOM   6096  N   GLU D 114      64.241  22.634  14.853  1.00 13.93           N  
ATOM   6097  CA  GLU D 114      63.994  23.126  16.215  1.00 12.43           C  
ATOM   6098  C   GLU D 114      62.488  23.297  16.280  1.00 14.66           C  
ATOM   6099  O   GLU D 114      61.913  23.966  15.425  1.00 16.06           O  
ATOM   6100  CB  GLU D 114      64.703  24.456  16.399  1.00 12.94           C  
ATOM   6101  CG  GLU D 114      64.569  25.029  17.785  1.00 19.13           C  
ATOM   6102  CD  GLU D 114      65.438  26.256  17.987  1.00 26.96           C  
ATOM   6103  OE1 GLU D 114      65.331  26.852  19.066  1.00 26.04           O  
ATOM   6104  OE2 GLU D 114      66.220  26.611  17.073  1.00 23.37           O  
ATOM   6105  N   TYR D 115      61.858  22.682  17.278  1.00 12.69           N  
ATOM   6106  CA  TYR D 115      60.403  22.714  17.389  1.00 14.01           C  
ATOM   6107  C   TYR D 115      59.966  22.941  18.832  1.00 14.53           C  
ATOM   6108  O   TYR D 115      60.519  22.343  19.767  1.00 14.99           O  
ATOM   6109  CB  TYR D 115      59.865  21.362  16.870  1.00 13.86           C  
ATOM   6110  CG  TYR D 115      58.411  21.060  17.154  1.00 14.15           C  
ATOM   6111  CD1 TYR D 115      58.041  19.838  17.726  1.00 19.54           C  
ATOM   6112  CD2 TYR D 115      57.402  21.965  16.814  1.00 17.31           C  
ATOM   6113  CE1 TYR D 115      56.698  19.521  17.949  1.00 21.88           C  
ATOM   6114  CE2 TYR D 115      56.061  21.657  17.031  1.00 18.50           C  
ATOM   6115  CZ  TYR D 115      55.722  20.430  17.598  1.00 22.88           C  
ATOM   6116  OH  TYR D 115      54.401  20.107  17.801  1.00 28.58           O  
ATOM   6117  N   TYR D 116      58.955  23.796  18.995  1.00 12.62           N  
ATOM   6118  CA  TYR D 116      58.393  24.129  20.306  1.00 16.64           C  
ATOM   6119  C   TYR D 116      56.964  23.593  20.348  1.00 17.14           C  
ATOM   6120  O   TYR D 116      56.033  24.280  19.936  1.00 17.63           O  
ATOM   6121  CB  TYR D 116      58.384  25.648  20.468  1.00 12.86           C  
ATOM   6122  CG  TYR D 116      59.766  26.185  20.608  1.00 15.14           C  
ATOM   6123  CD1 TYR D 116      60.482  26.621  19.493  1.00 16.43           C  
ATOM   6124  CD2 TYR D 116      60.414  26.158  21.844  1.00 17.65           C  
ATOM   6125  CE1 TYR D 116      61.809  27.004  19.599  1.00 16.82           C  
ATOM   6126  CE2 TYR D 116      61.743  26.548  21.952  1.00 13.96           C  
ATOM   6127  CZ  TYR D 116      62.431  26.967  20.831  1.00 18.25           C  
ATOM   6128  OH  TYR D 116      63.767  27.361  20.936  1.00 18.82           O  
ATOM   6129  N   PRO D 117      56.779  22.365  20.860  1.00 15.16           N  
ATOM   6130  CA  PRO D 117      55.452  21.741  20.931  1.00 16.04           C  
ATOM   6131  C   PRO D 117      54.461  22.441  21.831  1.00 17.32           C  
ATOM   6132  O   PRO D 117      53.270  22.210  21.710  1.00 20.46           O  
ATOM   6133  CB  PRO D 117      55.757  20.326  21.407  1.00 20.39           C  
ATOM   6134  CG  PRO D 117      56.991  20.542  22.292  1.00 20.56           C  
ATOM   6135  CD  PRO D 117      57.812  21.493  21.455  1.00 17.44           C  
ATOM   6136  N   ALA D 118      54.954  23.296  22.729  1.00 16.44           N  
ATOM   6137  CA  ALA D 118      54.083  24.021  23.652  1.00 20.68           C  
ATOM   6138  C   ALA D 118      54.158  25.516  23.423  1.00 18.97           C  
ATOM   6139  O   ALA D 118      53.780  26.305  24.299  1.00 21.95           O  
ATOM   6140  CB  ALA D 118      54.466  23.693  25.092  1.00 22.83           C  
ATOM   6141  N   TYR D 119      54.640  25.915  22.248  1.00 16.84           N  
ATOM   6142  CA  TYR D 119      54.752  27.326  21.915  1.00 18.49           C  
ATOM   6143  C   TYR D 119      53.487  28.059  22.371  1.00 24.70           C  
ATOM   6144  O   TYR D 119      52.380  27.579  22.147  1.00 19.76           O  
ATOM   6145  CB  TYR D 119      54.941  27.499  20.408  1.00 18.10           C  
ATOM   6146  CG  TYR D 119      55.342  28.889  20.039  1.00 19.39           C  
ATOM   6147  CD1 TYR D 119      54.384  29.861  19.722  1.00 23.23           C  
ATOM   6148  CD2 TYR D 119      56.677  29.274  20.110  1.00 22.34           C  
ATOM   6149  CE1 TYR D 119      54.772  31.195  19.487  1.00 25.67           C  
ATOM   6150  CE2 TYR D 119      57.065  30.587  19.890  1.00 25.20           C  
ATOM   6151  CZ  TYR D 119      56.116  31.537  19.580  1.00 28.80           C  
ATOM   6152  OH  TYR D 119      56.532  32.825  19.387  1.00 33.91           O  
ATOM   6153  N   PRO D 120      53.627  29.264  22.955  1.00 19.93           N  
ATOM   6154  CA  PRO D 120      54.811  30.079  23.256  1.00 18.49           C  
ATOM   6155  C   PRO D 120      55.775  29.591  24.337  1.00 16.53           C  
ATOM   6156  O   PRO D 120      56.884  30.109  24.429  1.00 19.18           O  
ATOM   6157  CB  PRO D 120      54.203  31.450  23.592  1.00 20.25           C  
ATOM   6158  CG  PRO D 120      52.981  31.066  24.334  1.00 21.81           C  
ATOM   6159  CD  PRO D 120      52.413  29.901  23.505  1.00 24.72           C  
ATOM   6160  N   SER D 121      55.375  28.604  25.129  1.00 16.32           N  
ATOM   6161  CA  SER D 121      56.255  28.054  26.158  1.00 13.93           C  
ATOM   6162  C   SER D 121      57.447  27.361  25.477  1.00 21.41           C  
ATOM   6163  O   SER D 121      57.303  26.777  24.395  1.00 16.60           O  
ATOM   6164  CB  SER D 121      55.524  27.021  26.979  1.00 17.03           C  
ATOM   6165  OG  SER D 121      56.421  26.346  27.855  1.00 18.01           O  
ATOM   6166  N   THR D 122      58.619  27.425  26.103  1.00 14.32           N  
ATOM   6167  CA  THR D 122      59.786  26.767  25.537  1.00 14.53           C  
ATOM   6168  C   THR D 122      59.945  25.383  26.149  1.00 13.41           C  
ATOM   6169  O   THR D 122      60.901  24.691  25.840  1.00 16.19           O  
ATOM   6170  CB  THR D 122      61.072  27.573  25.779  1.00 15.88           C  
ATOM   6171  OG1 THR D 122      61.171  27.876  27.170  1.00 14.42           O  
ATOM   6172  CG2 THR D 122      61.055  28.873  24.977  1.00 22.09           C  
ATOM   6173  N   ALA D 123      59.025  24.958  27.012  1.00 14.55           N  
ATOM   6174  CA  ALA D 123      59.156  23.625  27.600  1.00 16.44           C  
ATOM   6175  C   ALA D 123      58.893  22.532  26.546  1.00 18.50           C  
ATOM   6176  O   ALA D 123      57.960  22.635  25.736  1.00 17.66           O  
ATOM   6177  CB  ALA D 123      58.192  23.459  28.750  1.00 21.34           C  
ATOM   6178  N   GLY D 124      59.727  21.498  26.573  1.00 15.94           N  
ATOM   6179  CA  GLY D 124      59.576  20.383  25.649  1.00 18.11           C  
ATOM   6180  C   GLY D 124      60.243  20.604  24.306  1.00 19.42           C  
ATOM   6181  O   GLY D 124      60.098  19.773  23.405  1.00 16.71           O  
ATOM   6182  N   VAL D 125      60.980  21.703  24.167  1.00 15.75           N  
ATOM   6183  CA  VAL D 125      61.672  22.009  22.910  1.00 14.29           C  
ATOM   6184  C   VAL D 125      62.520  20.834  22.409  1.00 16.31           C  
ATOM   6185  O   VAL D 125      63.299  20.223  23.164  1.00 14.86           O  
ATOM   6186  CB  VAL D 125      62.592  23.286  23.031  1.00 13.07           C  
ATOM   6187  CG1 VAL D 125      63.676  23.075  24.152  1.00 14.47           C  
ATOM   6188  CG2 VAL D 125      63.295  23.548  21.694  1.00 15.74           C  
ATOM   6189  N   THR D 126      62.357  20.502  21.133  1.00 11.97           N  
ATOM   6190  CA  THR D 126      63.151  19.406  20.546  1.00 14.03           C  
ATOM   6191  C   THR D 126      64.096  20.041  19.527  1.00 19.91           C  
ATOM   6192  O   THR D 126      63.707  20.895  18.736  1.00 18.84           O  
ATOM   6193  CB  THR D 126      62.272  18.347  19.839  1.00 21.21           C  
ATOM   6194  OG1 THR D 126      61.549  18.963  18.767  1.00 24.43           O  
ATOM   6195  CG2 THR D 126      61.287  17.740  20.818  1.00 22.16           C  
ATOM   6196  N   LEU D 127      65.346  19.613  19.535  1.00 14.21           N  
ATOM   6197  CA  LEU D 127      66.323  20.202  18.641  1.00 12.76           C  
ATOM   6198  C   LEU D 127      67.121  19.086  17.991  1.00 14.10           C  
ATOM   6199  O   LEU D 127      67.502  18.142  18.664  1.00 16.77           O  
ATOM   6200  CB  LEU D 127      67.276  21.082  19.451  1.00 15.17           C  
ATOM   6201  CG  LEU D 127      68.492  21.646  18.690  1.00 18.05           C  
ATOM   6202  CD1 LEU D 127      68.022  22.778  17.809  1.00 23.53           C  
ATOM   6203  CD2 LEU D 127      69.559  22.137  19.668  1.00 26.54           C  
ATOM   6204  N   SER D 128      67.333  19.174  16.683  1.00 13.92           N  
ATOM   6205  CA  SER D 128      68.168  18.191  15.977  1.00 11.76           C  
ATOM   6206  C   SER D 128      69.297  18.976  15.373  1.00 12.88           C  
ATOM   6207  O   SER D 128      69.081  20.007  14.707  1.00 13.77           O  
ATOM   6208  CB  SER D 128      67.441  17.523  14.804  1.00 14.07           C  
ATOM   6209  OG  SER D 128      66.696  16.398  15.226  1.00 13.34           O  
ATOM   6210  N   LEU D 129      70.516  18.505  15.601  1.00 11.47           N  
ATOM   6211  CA  LEU D 129      71.664  19.178  15.008  1.00 12.03           C  
ATOM   6212  C   LEU D 129      72.250  18.279  13.949  1.00 14.82           C  
ATOM   6213  O   LEU D 129      72.234  17.056  14.106  1.00 14.04           O  
ATOM   6214  CB  LEU D 129      72.779  19.420  16.045  1.00 15.94           C  
ATOM   6215  CG  LEU D 129      72.466  20.378  17.196  1.00 20.70           C  
ATOM   6216  CD1 LEU D 129      73.644  20.422  18.211  1.00 21.25           C  
ATOM   6217  CD2 LEU D 129      72.198  21.748  16.593  1.00 18.78           C  
ATOM   6218  N   SER D 130      72.763  18.888  12.878  1.00 11.81           N  
ATOM   6219  CA  SER D 130      73.483  18.143  11.843  1.00 10.00           C  
ATOM   6220  C   SER D 130      74.935  18.571  12.049  1.00 12.70           C  
ATOM   6221  O   SER D 130      75.229  19.753  12.049  1.00 16.52           O  
ATOM   6222  CB  SER D 130      73.056  18.561  10.431  1.00 16.58           C  
ATOM   6223  OG  SER D 130      71.791  18.023  10.179  1.00 21.95           O  
ATOM   6224  N   CYS D 131      75.837  17.613  12.193  1.00 13.62           N  
ATOM   6225  CA  CYS D 131      77.242  17.971  12.425  1.00 14.98           C  
ATOM   6226  C   CYS D 131      78.096  17.304  11.372  1.00 19.11           C  
ATOM   6227  O   CYS D 131      77.750  16.229  10.869  1.00 16.70           O  
ATOM   6228  CB  CYS D 131      77.678  17.514  13.811  1.00 17.18           C  
ATOM   6229  SG  CYS D 131      76.572  18.109  15.124  1.00 17.99           S  
ATOM   6230  N   PHE D 132      79.245  17.905  11.080  1.00 16.22           N  
ATOM   6231  CA  PHE D 132      80.055  17.382   9.993  1.00 16.90           C  
ATOM   6232  C   PHE D 132      81.533  17.277  10.278  1.00 20.29           C  
ATOM   6233  O   PHE D 132      82.037  18.027  11.111  1.00 20.14           O  
ATOM   6234  CB  PHE D 132      79.867  18.297   8.793  1.00 19.30           C  
ATOM   6235  CG  PHE D 132      78.419  18.513   8.435  1.00 17.01           C  
ATOM   6236  CD1 PHE D 132      77.679  19.532   9.026  1.00 20.43           C  
ATOM   6237  CD2 PHE D 132      77.789  17.640   7.558  1.00 18.50           C  
ATOM   6238  CE1 PHE D 132      76.316  19.681   8.757  1.00 19.34           C  
ATOM   6239  CE2 PHE D 132      76.432  17.784   7.287  1.00 17.95           C  
ATOM   6240  CZ  PHE D 132      75.701  18.796   7.883  1.00 16.28           C  
ATOM   6241  N   ASP D 133      82.198  16.338   9.601  1.00 22.02           N  
ATOM   6242  CA  ASP D 133      83.643  16.231   9.734  1.00 21.16           C  
ATOM   6243  C   ASP D 133      84.253  17.227   8.751  1.00 25.45           C  
ATOM   6244  O   ASP D 133      83.539  17.928   8.047  1.00 21.05           O  
ATOM   6245  CB  ASP D 133      84.169  14.797   9.535  1.00 18.88           C  
ATOM   6246  CG  ASP D 133      84.052  14.267   8.102  1.00 18.42           C  
ATOM   6247  OD1 ASP D 133      83.936  15.053   7.141  1.00 25.82           O  
ATOM   6248  OD2 ASP D 133      84.107  13.019   7.964  1.00 19.74           O  
ATOM   6249  N   VAL D 134      85.582  17.305   8.722  1.00 27.21           N  
ATOM   6250  CA  VAL D 134      86.277  18.264   7.889  1.00 26.51           C  
ATOM   6251  C   VAL D 134      85.808  18.478   6.457  1.00 24.72           C  
ATOM   6252  O   VAL D 134      85.772  19.613   5.994  1.00 31.31           O  
ATOM   6253  CB  VAL D 134      87.811  17.958   7.862  1.00 30.02           C  
ATOM   6254  CG1 VAL D 134      88.072  16.578   7.256  1.00 24.07           C  
ATOM   6255  CG2 VAL D 134      88.523  19.025   7.066  1.00 34.96           C  
ATOM   6256  N   ASP D 135      85.463  17.404   5.754  1.00 24.59           N  
ATOM   6257  CA  ASP D 135      85.021  17.525   4.362  1.00 26.80           C  
ATOM   6258  C   ASP D 135      83.628  16.911   4.160  1.00 28.09           C  
ATOM   6259  O   ASP D 135      83.214  16.639   3.033  1.00 27.15           O  
ATOM   6260  CB  ASP D 135      86.006  16.781   3.469  1.00 29.84           C  
ATOM   6261  CG  ASP D 135      85.977  15.277   3.694  1.00 33.91           C  
ATOM   6262  OD1 ASP D 135      85.321  14.795   4.654  1.00 30.89           O  
ATOM   6263  OD2 ASP D 135      86.621  14.555   2.904  1.00 38.10           O  
ATOM   6264  N   GLY D 136      82.910  16.697   5.251  1.00 24.30           N  
ATOM   6265  CA  GLY D 136      81.614  16.045   5.148  1.00 23.65           C  
ATOM   6266  C   GLY D 136      80.435  16.853   4.665  1.00 24.03           C  
ATOM   6267  O   GLY D 136      79.500  16.285   4.101  1.00 20.94           O  
ATOM   6268  N   TYR D 137      80.450  18.161   4.876  1.00 22.09           N  
ATOM   6269  CA  TYR D 137      79.325  18.968   4.449  1.00 22.70           C  
ATOM   6270  C   TYR D 137      79.321  19.167   2.940  1.00 26.17           C  
ATOM   6271  O   TYR D 137      80.373  19.286   2.311  1.00 24.23           O  
ATOM   6272  CB  TYR D 137      79.348  20.334   5.128  1.00 23.12           C  
ATOM   6273  CG  TYR D 137      78.189  21.220   4.733  1.00 22.04           C  
ATOM   6274  CD1 TYR D 137      76.894  20.940   5.176  1.00 22.44           C  
ATOM   6275  CD2 TYR D 137      78.367  22.310   3.871  1.00 18.23           C  
ATOM   6276  CE1 TYR D 137      75.816  21.711   4.771  1.00 22.22           C  
ATOM   6277  CE2 TYR D 137      77.292  23.079   3.461  1.00 18.80           C  
ATOM   6278  CZ  TYR D 137      76.016  22.771   3.917  1.00 21.74           C  
ATOM   6279  OH  TYR D 137      74.945  23.520   3.513  1.00 23.77           O  
ATOM   6280  N   SER D 138      78.133  19.183   2.354  1.00 20.33           N  
ATOM   6281  CA  SER D 138      78.003  19.426   0.918  1.00 21.47           C  
ATOM   6282  C   SER D 138      76.663  20.109   0.745  1.00 24.00           C  
ATOM   6283  O   SER D 138      75.659  19.594   1.218  1.00 21.82           O  
ATOM   6284  CB  SER D 138      78.004  18.114   0.135  1.00 22.46           C  
ATOM   6285  OG  SER D 138      77.730  18.366  -1.233  1.00 22.64           O  
ATOM   6286  N   SER D 139      76.620  21.267   0.095  1.00 20.60           N  
ATOM   6287  CA  SER D 139      75.318  21.914  -0.061  1.00 24.30           C  
ATOM   6288  C   SER D 139      74.649  21.555  -1.388  1.00 24.05           C  
ATOM   6289  O   SER D 139      73.487  21.881  -1.604  1.00 24.98           O  
ATOM   6290  CB  SER D 139      75.447  23.427   0.045  1.00 27.52           C  
ATOM   6291  OG  SER D 139      76.362  23.893  -0.926  1.00 34.86           O  
ATOM   6292  N   THR D 140      75.366  20.845  -2.248  1.00 19.21           N  
ATOM   6293  CA  THR D 140      74.819  20.493  -3.555  1.00 20.21           C  
ATOM   6294  C   THR D 140      74.840  19.027  -3.836  1.00 17.85           C  
ATOM   6295  O   THR D 140      74.258  18.585  -4.818  1.00 23.49           O  
ATOM   6296  CB  THR D 140      75.615  21.174  -4.678  1.00 26.12           C  
ATOM   6297  OG1 THR D 140      77.001  20.837  -4.533  1.00 27.98           O  
ATOM   6298  CG2 THR D 140      75.459  22.679  -4.602  1.00 24.23           C  
ATOM   6299  N   GLY D 141      75.531  18.251  -3.012  1.00 19.31           N  
ATOM   6300  CA  GLY D 141      75.587  16.824  -3.269  1.00 19.24           C  
ATOM   6301  C   GLY D 141      75.234  15.979  -2.062  1.00 20.27           C  
ATOM   6302  O   GLY D 141      74.211  16.197  -1.409  1.00 21.33           O  
ATOM   6303  N   PHE D 142      76.091  15.017  -1.757  1.00 17.79           N  
ATOM   6304  CA  PHE D 142      75.864  14.132  -0.628  1.00 16.53           C  
ATOM   6305  C   PHE D 142      76.928  14.307   0.425  1.00 19.27           C  
ATOM   6306  O   PHE D 142      78.095  14.556   0.086  1.00 17.65           O  
ATOM   6307  CB  PHE D 142      75.820  12.696  -1.098  1.00 20.58           C  
ATOM   6308  CG  PHE D 142      74.625  12.408  -1.949  1.00 23.45           C  
ATOM   6309  CD1 PHE D 142      74.612  12.785  -3.290  1.00 26.19           C  
ATOM   6310  CD2 PHE D 142      73.496  11.824  -1.396  1.00 22.86           C  
ATOM   6311  CE1 PHE D 142      73.484  12.587  -4.075  1.00 29.49           C  
ATOM   6312  CE2 PHE D 142      72.356  11.615  -2.172  1.00 27.37           C  
ATOM   6313  CZ  PHE D 142      72.358  12.001  -3.515  1.00 23.27           C  
ATOM   6314  N   TYR D 143      76.534  14.189   1.692  1.00 16.42           N  
ATOM   6315  CA  TYR D 143      77.506  14.345   2.782  1.00 17.95           C  
ATOM   6316  C   TYR D 143      78.551  13.253   2.738  1.00 21.22           C  
ATOM   6317  O   TYR D 143      78.286  12.144   2.293  1.00 18.75           O  
ATOM   6318  CB  TYR D 143      76.854  14.255   4.162  1.00 14.34           C  
ATOM   6319  CG  TYR D 143      75.784  15.291   4.436  1.00 13.50           C  
ATOM   6320  CD1 TYR D 143      75.869  16.570   3.898  1.00 13.17           C  
ATOM   6321  CD2 TYR D 143      74.685  14.979   5.256  1.00 13.91           C  
ATOM   6322  CE1 TYR D 143      74.897  17.526   4.149  1.00 16.83           C  
ATOM   6323  CE2 TYR D 143      73.710  15.924   5.515  1.00 15.14           C  
ATOM   6324  CZ  TYR D 143      73.818  17.179   4.965  1.00 15.28           C  
ATOM   6325  OH  TYR D 143      72.842  18.099   5.187  1.00 15.63           O  
ATOM   6326  N   ARG D 144      79.737  13.569   3.247  1.00 18.33           N  
ATOM   6327  CA  ARG D 144      80.799  12.582   3.322  1.00 21.42           C  
ATOM   6328  C   ARG D 144      81.356  12.585   4.757  1.00 23.80           C  
ATOM   6329  O   ARG D 144      82.530  12.879   4.968  1.00 22.96           O  
ATOM   6330  CB  ARG D 144      81.903  12.933   2.315  1.00 28.30           C  
ATOM   6331  CG  ARG D 144      81.407  13.071   0.871  1.00 37.00           C  
ATOM   6332  CD  ARG D 144      82.570  13.135  -0.112  1.00 47.63           C  
ATOM   6333  NE  ARG D 144      83.575  14.135   0.256  1.00 56.28           N  
ATOM   6334  CZ  ARG D 144      83.398  15.454   0.178  1.00 61.79           C  
ATOM   6335  NH1 ARG D 144      82.246  15.954  -0.259  1.00 63.20           N  
ATOM   6336  NH2 ARG D 144      84.379  16.279   0.534  1.00 60.16           N  
ATOM   6337  N   GLY D 145      80.506  12.279   5.732  1.00 18.02           N  
ATOM   6338  CA  GLY D 145      80.927  12.257   7.131  1.00 18.91           C  
ATOM   6339  C   GLY D 145      80.048  13.235   7.888  1.00 18.37           C  
ATOM   6340  O   GLY D 145      80.311  14.446   7.927  1.00 19.34           O  
ATOM   6341  N   SER D 146      78.993  12.703   8.491  1.00 15.73           N  
ATOM   6342  CA  SER D 146      78.052  13.553   9.194  1.00 16.38           C  
ATOM   6343  C   SER D 146      77.400  12.816  10.335  1.00 13.88           C  
ATOM   6344  O   SER D 146      77.521  11.602  10.470  1.00 14.69           O  
ATOM   6345  CB  SER D 146      76.969  14.035   8.211  1.00 18.13           C  
ATOM   6346  OG  SER D 146      76.193  12.928   7.773  1.00 16.84           O  
ATOM   6347  N   ALA D 147      76.667  13.560  11.151  1.00 15.06           N  
ATOM   6348  CA  ALA D 147      75.981  12.955  12.262  1.00 13.10           C  
ATOM   6349  C   ALA D 147      74.745  13.772  12.602  1.00 11.28           C  
ATOM   6350  O   ALA D 147      74.648  14.955  12.278  1.00 17.16           O  
ATOM   6351  CB  ALA D 147      76.910  12.855  13.489  1.00 14.40           C  
ATOM   6352  N   HIS D 148      73.803  13.104  13.247  1.00 11.60           N  
ATOM   6353  CA  HIS D 148      72.572  13.724  13.679  1.00 11.72           C  
ATOM   6354  C   HIS D 148      72.528  13.517  15.194  1.00 14.44           C  
ATOM   6355  O   HIS D 148      72.608  12.388  15.665  1.00 12.85           O  
ATOM   6356  CB  HIS D 148      71.390  12.999  12.986  1.00 12.16           C  
ATOM   6357  CG  HIS D 148      70.035  13.398  13.497  1.00 10.21           C  
ATOM   6358  ND1 HIS D 148      68.934  12.580  13.370  1.00 12.82           N  
ATOM   6359  CD2 HIS D 148      69.594  14.536  14.087  1.00 12.68           C  
ATOM   6360  CE1 HIS D 148      67.870  13.197  13.861  1.00 12.73           C  
ATOM   6361  NE2 HIS D 148      68.246  14.386  14.302  1.00 15.23           N  
ATOM   6362  N   LEU D 149      72.411  14.610  15.941  1.00 15.02           N  
ATOM   6363  CA  LEU D 149      72.331  14.545  17.403  1.00 12.12           C  
ATOM   6364  C   LEU D 149      70.997  15.229  17.741  1.00 13.19           C  
ATOM   6365  O   LEU D 149      70.733  16.317  17.236  1.00 14.93           O  
ATOM   6366  CB  LEU D 149      73.492  15.347  18.015  1.00 13.88           C  
ATOM   6367  CG  LEU D 149      74.880  14.953  17.512  1.00 24.15           C  
ATOM   6368  CD1 LEU D 149      75.908  16.002  17.939  1.00 28.50           C  
ATOM   6369  CD2 LEU D 149      75.228  13.611  18.069  1.00 27.72           C  
ATOM   6370  N   TRP D 150      70.158  14.591  18.554  1.00 14.09           N  
ATOM   6371  CA  TRP D 150      68.873  15.194  18.883  1.00 14.10           C  
ATOM   6372  C   TRP D 150      68.680  15.312  20.380  1.00 14.56           C  
ATOM   6373  O   TRP D 150      69.110  14.467  21.157  1.00 14.28           O  
ATOM   6374  CB  TRP D 150      67.709  14.443  18.204  1.00 12.89           C  
ATOM   6375  CG  TRP D 150      67.589  12.974  18.499  1.00 13.38           C  
ATOM   6376  CD1 TRP D 150      66.755  12.376  19.419  1.00 14.78           C  
ATOM   6377  CD2 TRP D 150      68.245  11.910  17.804  1.00 11.82           C  
ATOM   6378  NE1 TRP D 150      66.854  11.003  19.322  1.00 15.14           N  
ATOM   6379  CE2 TRP D 150      67.758  10.694  18.340  1.00 14.06           C  
ATOM   6380  CE3 TRP D 150      69.199  11.865  16.776  1.00 13.19           C  
ATOM   6381  CZ2 TRP D 150      68.190   9.444  17.879  1.00 14.00           C  
ATOM   6382  CZ3 TRP D 150      69.630  10.610  16.317  1.00 14.44           C  
ATOM   6383  CH2 TRP D 150      69.124   9.430  16.866  1.00 12.67           C  
ATOM   6384  N   PHE D 151      68.048  16.419  20.752  1.00 13.03           N  
ATOM   6385  CA  PHE D 151      67.848  16.818  22.137  1.00 12.59           C  
ATOM   6386  C   PHE D 151      66.402  17.125  22.461  1.00 14.20           C  
ATOM   6387  O   PHE D 151      65.615  17.473  21.573  1.00 14.24           O  
ATOM   6388  CB  PHE D 151      68.586  18.143  22.392  1.00 10.16           C  
ATOM   6389  CG  PHE D 151      70.056  18.104  22.077  1.00 14.12           C  
ATOM   6390  CD1 PHE D 151      70.518  18.192  20.755  1.00 13.75           C  
ATOM   6391  CD2 PHE D 151      70.988  18.050  23.117  1.00 14.10           C  
ATOM   6392  CE1 PHE D 151      71.891  18.237  20.479  1.00 15.47           C  
ATOM   6393  CE2 PHE D 151      72.354  18.094  22.849  1.00 14.02           C  
ATOM   6394  CZ  PHE D 151      72.805  18.190  21.534  1.00 17.71           C  
ATOM   6395  N   THR D 152      66.070  16.995  23.742  1.00 12.96           N  
ATOM   6396  CA  THR D 152      64.768  17.423  24.241  1.00 11.89           C  
ATOM   6397  C   THR D 152      65.088  18.233  25.508  1.00 15.07           C  
ATOM   6398  O   THR D 152      65.788  17.739  26.386  1.00 13.97           O  
ATOM   6399  CB  THR D 152      63.824  16.271  24.610  1.00 17.91           C  
ATOM   6400  OG1 THR D 152      63.494  15.540  23.418  1.00 16.64           O  
ATOM   6401  CG2 THR D 152      62.510  16.850  25.195  1.00 20.45           C  
ATOM   6402  N   ASP D 153      64.562  19.454  25.602  1.00 12.96           N  
ATOM   6403  CA  ASP D 153      64.850  20.342  26.743  1.00 13.47           C  
ATOM   6404  C   ASP D 153      66.339  20.488  26.998  1.00 15.70           C  
ATOM   6405  O   ASP D 153      66.791  20.478  28.147  1.00 17.35           O  
ATOM   6406  CB  ASP D 153      64.132  19.858  28.010  1.00 15.32           C  
ATOM   6407  CG  ASP D 153      62.638  20.079  27.937  1.00 15.56           C  
ATOM   6408  OD1 ASP D 153      62.227  21.192  27.559  1.00 20.08           O  
ATOM   6409  OD2 ASP D 153      61.871  19.154  28.266  1.00 20.22           O  
ATOM   6410  N   GLY D 154      67.097  20.610  25.911  1.00 12.55           N  
ATOM   6411  CA  GLY D 154      68.535  20.814  25.995  1.00 16.00           C  
ATOM   6412  C   GLY D 154      69.391  19.629  26.408  1.00 16.86           C  
ATOM   6413  O   GLY D 154      70.573  19.801  26.648  1.00 18.60           O  
ATOM   6414  N   VAL D 155      68.815  18.438  26.467  1.00 15.60           N  
ATOM   6415  CA  VAL D 155      69.580  17.260  26.872  1.00 13.60           C  
ATOM   6416  C   VAL D 155      69.610  16.250  25.740  1.00 16.07           C  
ATOM   6417  O   VAL D 155      68.558  15.917  25.181  1.00 13.69           O  
ATOM   6418  CB  VAL D 155      68.938  16.613  28.121  1.00 19.55           C  
ATOM   6419  CG1 VAL D 155      69.739  15.382  28.555  1.00 20.49           C  
ATOM   6420  CG2 VAL D 155      68.890  17.653  29.271  1.00 23.20           C  
ATOM   6421  N   LEU D 156      70.799  15.742  25.429  1.00 15.10           N  
ATOM   6422  CA  LEU D 156      70.934  14.774  24.317  1.00 14.73           C  
ATOM   6423  C   LEU D 156      70.125  13.503  24.559  1.00 17.40           C  
ATOM   6424  O   LEU D 156      70.250  12.853  25.609  1.00 15.69           O  
ATOM   6425  CB  LEU D 156      72.409  14.390  24.099  1.00 12.64           C  
ATOM   6426  CG  LEU D 156      72.663  13.547  22.836  1.00 15.65           C  
ATOM   6427  CD1 LEU D 156      72.428  14.423  21.608  1.00 12.76           C  
ATOM   6428  CD2 LEU D 156      74.103  13.012  22.822  1.00 15.32           C  
ATOM   6429  N   GLN D 157      69.277  13.161  23.588  1.00 13.79           N  
ATOM   6430  CA  GLN D 157      68.445  11.968  23.669  1.00 13.82           C  
ATOM   6431  C   GLN D 157      68.982  10.843  22.773  1.00 17.04           C  
ATOM   6432  O   GLN D 157      68.692   9.678  23.019  1.00 17.40           O  
ATOM   6433  CB  GLN D 157      67.011  12.269  23.223  1.00 14.69           C  
ATOM   6434  CG  GLN D 157      66.320  13.335  24.055  1.00 23.52           C  
ATOM   6435  CD  GLN D 157      66.217  12.924  25.497  1.00 30.28           C  
ATOM   6436  OE1 GLN D 157      65.686  11.867  25.803  1.00 37.17           O  
ATOM   6437  NE2 GLN D 157      66.735  13.753  26.397  1.00 31.79           N  
ATOM   6438  N   GLY D 158      69.742  11.186  21.736  1.00 15.04           N  
ATOM   6439  CA  GLY D 158      70.251  10.146  20.856  1.00 17.14           C  
ATOM   6440  C   GLY D 158      71.218  10.670  19.822  1.00 15.02           C  
ATOM   6441  O   GLY D 158      71.363  11.870  19.663  1.00 15.71           O  
ATOM   6442  N   LYS D 159      71.884   9.769  19.106  1.00 13.71           N  
ATOM   6443  CA  LYS D 159      72.827  10.178  18.081  1.00 12.39           C  
ATOM   6444  C   LYS D 159      72.961   9.096  17.012  1.00 14.09           C  
ATOM   6445  O   LYS D 159      72.721   7.923  17.278  1.00 16.50           O  
ATOM   6446  CB  LYS D 159      74.212  10.436  18.691  1.00 15.50           C  
ATOM   6447  CG  LYS D 159      74.762   9.224  19.472  1.00 17.82           C  
ATOM   6448  CD  LYS D 159      76.206   9.481  19.950  1.00 19.62           C  
ATOM   6449  CE  LYS D 159      76.777   8.237  20.657  1.00 21.57           C  
ATOM   6450  NZ  LYS D 159      78.236   8.374  21.000  1.00 22.55           N  
ATOM   6451  N   ARG D 160      73.345   9.507  15.811  1.00 15.07           N  
ATOM   6452  CA  ARG D 160      73.557   8.553  14.727  1.00 15.26           C  
ATOM   6453  C   ARG D 160      74.579   9.178  13.792  1.00 14.70           C  
ATOM   6454  O   ARG D 160      74.629  10.403  13.662  1.00 17.33           O  
ATOM   6455  CB  ARG D 160      72.228   8.285  13.995  1.00 17.08           C  
ATOM   6456  CG  ARG D 160      72.381   7.214  12.920  1.00 21.23           C  
ATOM   6457  CD  ARG D 160      71.040   6.721  12.408  1.00 20.17           C  
ATOM   6458  NE  ARG D 160      71.236   5.842  11.264  1.00 24.13           N  
ATOM   6459  CZ  ARG D 160      70.285   5.504  10.397  1.00 31.47           C  
ATOM   6460  NH1 ARG D 160      69.045   5.969  10.539  1.00 25.53           N  
ATOM   6461  NH2 ARG D 160      70.583   4.717   9.368  1.00 32.83           N  
ATOM   6462  N   GLN D 161      75.435   8.370  13.171  1.00 14.24           N  
ATOM   6463  CA  GLN D 161      76.415   8.937  12.265  1.00 13.81           C  
ATOM   6464  C   GLN D 161      76.504   8.139  10.970  1.00 15.55           C  
ATOM   6465  O   GLN D 161      76.103   6.986  10.912  1.00 15.53           O  
ATOM   6466  CB  GLN D 161      77.820   9.011  12.922  1.00 16.22           C  
ATOM   6467  CG  GLN D 161      78.478   7.669  13.304  1.00 21.50           C  
ATOM   6468  CD  GLN D 161      79.178   6.960  12.139  1.00 24.48           C  
ATOM   6469  OE1 GLN D 161      79.685   7.591  11.215  1.00 20.04           O  
ATOM   6470  NE2 GLN D 161      79.209   5.640  12.197  1.00 30.52           N  
ATOM   6471  N   TRP D 162      77.024   8.787   9.950  1.00 17.13           N  
ATOM   6472  CA  TRP D 162      77.234   8.167   8.653  1.00 19.96           C  
ATOM   6473  C   TRP D 162      78.617   8.522   8.131  1.00 18.43           C  
ATOM   6474  O   TRP D 162      78.962   9.698   8.032  1.00 16.71           O  
ATOM   6475  CB  TRP D 162      76.217   8.671   7.631  1.00 17.84           C  
ATOM   6476  CG  TRP D 162      74.797   8.345   8.006  1.00 17.76           C  
ATOM   6477  CD1 TRP D 162      74.069   7.245   7.635  1.00 17.09           C  
ATOM   6478  CD2 TRP D 162      73.938   9.147   8.812  1.00 19.13           C  
ATOM   6479  NE1 TRP D 162      72.796   7.322   8.163  1.00 18.29           N  
ATOM   6480  CE2 TRP D 162      72.691   8.481   8.889  1.00 15.16           C  
ATOM   6481  CE3 TRP D 162      74.097  10.371   9.480  1.00 15.05           C  
ATOM   6482  CZ2 TRP D 162      71.605   9.006   9.607  1.00 16.51           C  
ATOM   6483  CZ3 TRP D 162      73.019  10.892  10.189  1.00 21.01           C  
ATOM   6484  CH2 TRP D 162      71.787  10.206  10.245  1.00 16.97           C  
ATOM   6485  N   ASP D 163      79.403   7.493   7.827  1.00 18.90           N  
ATOM   6486  CA  ASP D 163      80.705   7.672   7.196  1.00 22.49           C  
ATOM   6487  C   ASP D 163      81.798   8.439   7.898  1.00 25.26           C  
ATOM   6488  O   ASP D 163      82.696   8.978   7.233  1.00 23.22           O  
ATOM   6489  CB  ASP D 163      80.489   8.294   5.808  1.00 26.44           C  
ATOM   6490  CG  ASP D 163      79.594   7.426   4.935  1.00 39.37           C  
ATOM   6491  OD1 ASP D 163      79.963   6.259   4.695  1.00 39.72           O  
ATOM   6492  OD2 ASP D 163      78.519   7.899   4.511  1.00 45.71           O  
ATOM   6493  N   LEU D 164      81.739   8.512   9.220  1.00 23.21           N  
ATOM   6494  CA  LEU D 164      82.805   9.220   9.927  1.00 23.78           C  
ATOM   6495  C   LEU D 164      83.941   8.233  10.055  1.00 23.96           C  
ATOM   6496  O   LEU D 164      83.733   7.022  10.029  1.00 25.26           O  
ATOM   6497  CB  LEU D 164      82.361   9.650  11.324  1.00 21.40           C  
ATOM   6498  CG  LEU D 164      81.264  10.731  11.391  1.00 16.33           C  
ATOM   6499  CD1 LEU D 164      80.840  10.942  12.869  1.00 18.08           C  
ATOM   6500  CD2 LEU D 164      81.761  12.017  10.775  1.00 18.80           C  
ATOM   6501  N   VAL D 165      85.142   8.758  10.202  1.00 27.82           N  
ATOM   6502  CA  VAL D 165      86.308   7.911  10.356  1.00 29.20           C  
ATOM   6503  C   VAL D 165      87.202   8.443  11.470  1.00 28.80           C  
ATOM   6504  O   VAL D 165      87.063   9.636  11.823  1.00 31.88           O  
ATOM   6505  CB  VAL D 165      87.117   7.841   9.034  1.00 28.89           C  
ATOM   6506  CG1 VAL D 165      86.320   7.062   7.990  1.00 34.92           C  
ATOM   6507  CG2 VAL D 165      87.400   9.245   8.506  1.00 29.56           C  
ATOM   6508  OXT VAL D 165      88.036   7.649  11.950  1.00 33.07           O  
TER    6509      VAL D 165                                                      
END
MOLECULE T0399.pdb
ATOM      1  N   LYS    45      84.426  29.161   0.628  1.00 42.99           N  
ATOM      2  CA  LYS    45      83.194  30.002   0.504  1.00 41.39           C  
ATOM      3  C   LYS    45      81.975  29.131   0.353  1.00 38.94           C  
ATOM      4  O   LYS    45      81.905  28.302  -0.553  1.00 39.84           O  
ATOM      5  CB  LYS    45      83.298  30.946  -0.697  1.00 43.10           C  
ATOM      6  N   THR    46      81.018  29.339   1.253  1.00 35.02           N  
ATOM      7  CA  THR    46      79.759  28.568   1.244  1.00 32.77           C  
ATOM      8  C   THR    46      78.744  29.213   0.327  1.00 33.82           C  
ATOM      9  O   THR    46      78.369  30.389   0.507  1.00 37.09           O  
ATOM     10  CB  THR    46      79.076  28.453   2.647  1.00 23.56           C  
ATOM     11  OG1 THR    46      79.975  27.887   3.592  1.00 31.33           O  
ATOM     12  CG2 THR    46      77.879  27.613   2.554  1.00 30.99           C  
ATOM     13  N   GLU    47      78.274  28.427  -0.633  1.00 31.97           N  
ATOM     14  CA  GLU    47      77.190  28.877  -1.501  1.00 32.96           C  
ATOM     15  C   GLU    47      75.884  28.665  -0.752  1.00 30.55           C  
ATOM     16  O   GLU    47      75.736  27.729   0.041  1.00 30.01           O  
ATOM     17  CB  GLU    47      77.150  28.095  -2.811  1.00 35.35           C  
ATOM     18  N   ASN    48      74.950  29.569  -1.013  1.00 31.15           N  
ATOM     19  CA  ASN    48      73.630  29.501  -0.428  1.00 28.92           C  
ATOM     20  C   ASN    48      73.662  29.830   1.055  1.00 23.48           C  
ATOM     21  O   ASN    48      72.736  29.522   1.820  1.00 21.47           O  
ATOM     22  CB  ASN    48      73.073  28.099  -0.630  1.00 31.56           C  
ATOM     23  CG  ASN    48      71.668  28.128  -1.054  1.00 28.90           C  
ATOM     24  OD1 ASN    48      71.104  29.228  -1.253  1.00 28.16           O  
ATOM     25  ND2 ASN    48      71.073  26.942  -1.217  1.00 29.69           N  
ATOM     26  N   LEU    49      74.750  30.434   1.474  1.00 20.56           N  
ATOM     27  CA  LEU    49      74.975  30.694   2.889  1.00 18.25           C  
ATOM     28  C   LEU    49      73.899  31.563   3.476  1.00 16.52           C  
ATOM     29  O   LEU    49      73.457  31.296   4.611  1.00 16.83           O  
ATOM     30  CB  LEU    49      76.351  31.339   3.162  1.00 16.81           C  
ATOM     31  CG  LEU    49      76.742  31.662   4.612  1.00 17.58           C  
ATOM     32  CD1 LEU    49      76.704  30.395   5.443  1.00 17.41           C  
ATOM     33  CD2 LEU    49      78.155  32.264   4.680  1.00 17.66           C  
ATOM     34  N   ASP    50      73.467  32.608   2.762  1.00 17.74           N  
ATOM     35  CA  ASP    50      72.514  33.568   3.355  1.00 18.04           C  
ATOM     36  C   ASP    50      71.156  32.894   3.653  1.00 16.25           C  
ATOM     37  O   ASP    50      70.520  33.198   4.645  1.00 16.02           O  
ATOM     38  CB  ASP    50      72.300  34.803   2.510  1.00 19.71           C  
ATOM     39  CG  ASP    50      73.493  35.768   2.537  1.00 23.89           C  
ATOM     40  OD1 ASP    50      74.378  35.666   3.416  1.00 26.34           O  
ATOM     41  OD2 ASP    50      73.540  36.637   1.653  1.00 24.79           O  
ATOM     42  N   PHE    51      70.787  31.939   2.822  1.00 15.71           N  
ATOM     43  CA  PHE    51      69.540  31.169   2.988  1.00 16.27           C  
ATOM     44  C   PHE    51      69.634  30.372   4.267  1.00 14.99           C  
ATOM     45  O   PHE    51      68.715  30.394   5.097  1.00 14.50           O  
ATOM     46  CB  PHE    51      69.356  30.265   1.768  1.00 15.21           C  
ATOM     47  CG  PHE    51      68.010  29.605   1.638  1.00 12.72           C  
ATOM     48  CD1 PHE    51      66.874  30.329   1.341  1.00 13.29           C  
ATOM     49  CD2 PHE    51      67.888  28.230   1.696  1.00 12.97           C  
ATOM     50  CE1 PHE    51      65.641  29.691   1.179  1.00 13.20           C  
ATOM     51  CE2 PHE    51      66.683  27.596   1.487  1.00 14.59           C  
ATOM     52  CZ  PHE    51      65.550  28.337   1.224  1.00 13.82           C  
ATOM     53  N   ARG    52      70.761  29.683   4.471  1.00 14.93           N  
ATOM     54  CA  ARG    52      70.984  28.959   5.703  1.00 15.54           C  
ATOM     55  C   ARG    52      71.011  29.857   6.913  1.00 14.11           C  
ATOM     56  O   ARG    52      70.507  29.495   7.978  1.00 14.71           O  
ATOM     57  CB  ARG    52      72.280  28.105   5.637  1.00 15.39           C  
ATOM     58  CG  ARG    52      72.682  27.483   6.941  1.00 15.54           C  
ATOM     59  CD  ARG    52      71.731  26.378   7.340  1.00 15.02           C  
ATOM     60  NE  ARG    52      72.095  25.781   8.603  1.00 14.18           N  
ATOM     61  CZ  ARG    52      71.868  26.280   9.804  1.00 13.25           C  
ATOM     62  NH1 ARG    52      71.203  27.436   9.925  1.00 14.55           N  
ATOM     63  NH2 ARG    52      72.201  25.604  10.888  1.00 17.42           N  
ATOM     64  N   LEU    53      71.692  30.981   6.834  1.00 14.00           N  
ATOM     65  CA  LEU    53      71.795  31.831   8.003  1.00 14.53           C  
ATOM     66  C   LEU    53      70.462  32.491   8.327  1.00 12.64           C  
ATOM     67  O   LEU    53      70.144  32.712   9.470  1.00 13.53           O  
ATOM     68  CB  LEU    53      72.923  32.881   7.870  1.00 15.95           C  
ATOM     69  CG  LEU    53      74.316  32.256   7.813  1.00 17.21           C  
ATOM     70  CD1 LEU    53      75.363  33.452   7.755  1.00 17.11           C  
ATOM     71  CD2 LEU    53      74.636  31.367   8.956  1.00 19.67           C  
ATOM     72  N   SER    54      69.679  32.840   7.309  1.00 14.53           N  
ATOM     73  CA  SER    54      68.350  33.374   7.554  1.00 14.34           C  
ATOM     74  C   SER    54      67.444  32.368   8.276  1.00 13.71           C  
ATOM     75  O   SER    54      66.566  32.756   9.026  1.00 13.76           O  
ATOM     76  CB  SER    54      67.674  33.836   6.263  1.00 14.87           C  
ATOM     77  OG  SER    54      68.363  35.005   5.746  1.00 17.09           O  
ATOM     78  N   PHE    55      67.683  31.087   8.018  1.00 12.78           N  
ATOM     79  CA  PHE    55      66.965  30.019   8.728  1.00 11.82           C  
ATOM     80  C   PHE    55      67.124  30.149  10.246  1.00 11.79           C  
ATOM     81  O   PHE    55      66.184  29.868  10.983  1.00 12.52           O  
ATOM     82  CB  PHE    55      67.413  28.640   8.274  1.00 12.19           C  
ATOM     83  CG  PHE    55      66.710  27.516   8.962  1.00 11.79           C  
ATOM     84  CD1 PHE    55      65.450  27.155   8.617  1.00 12.72           C  
ATOM     85  CD2 PHE    55      67.332  26.830   9.978  1.00 13.32           C  
ATOM     86  CE1 PHE    55      64.833  26.102   9.267  1.00 13.73           C  
ATOM     87  CE2 PHE    55      66.721  25.801  10.620  1.00 15.75           C  
ATOM     88  CZ  PHE    55      65.519  25.425  10.272  1.00 13.03           C  
ATOM     89  N   ASN    56      68.275  30.672  10.680  1.00 12.41           N  
ATOM     90  CA  ASN    56      68.492  30.861  12.131  1.00 12.34           C  
ATOM     91  C   ASN    56      67.597  31.926  12.748  1.00 13.23           C  
ATOM     92  O   ASN    56      67.438  31.932  13.967  1.00 15.54           O  
ATOM     93  CB  ASN    56      69.949  31.227  12.375  1.00 13.43           C  
ATOM     94  CG  ASN    56      70.909  30.137  12.069  1.00 12.29           C  
ATOM     95  OD1 ASN    56      70.570  28.918  12.190  1.00 14.98           O  
ATOM     96  ND2 ASN    56      72.134  30.504  11.692  1.00 14.56           N  
ATOM     97  N   LYS    57      66.998  32.756  11.935  1.00 12.98           N  
ATOM     98  CA  LYS    57      66.067  33.775  12.390  1.00 13.77           C  
ATOM     99  C   LYS    57      64.706  33.188  12.706  1.00 13.91           C  
ATOM    100  O   LYS    57      63.884  33.803  13.433  1.00 14.02           O  
ATOM    101  CB  LYS    57      65.907  34.877  11.357  1.00 15.47           C  
ATOM    102  CG  LYS    57      67.185  35.657  11.121  1.00 17.27           C  
ATOM    103  CD  LYS    57      66.949  36.668   9.997  1.00 20.48           C  
ATOM    104  CE  LYS    57      68.234  37.348   9.593  1.00 27.76           C  
ATOM    105  NZ  LYS    57      67.928  38.491   8.716  1.00 37.51           N  
ATOM    106  N   ILE    58      64.405  31.992  12.197  1.00 12.98           N  
ATOM    107  CA  ILE    58      63.091  31.423  12.420  1.00 12.07           C  
ATOM    108  C   ILE    58      63.081  30.804  13.793  1.00 14.09           C  
ATOM    109  O   ILE    58      63.908  29.927  14.089  1.00 13.94           O  
ATOM    110  CB  ILE    58      62.757  30.364  11.348  1.00 13.47           C  
ATOM    111  CG1 ILE    58      62.918  30.860   9.930  1.00 12.14           C  
ATOM    112  CG2 ILE    58      61.342  29.817  11.581  1.00 15.56           C  
ATOM    113  CD1 ILE    58      62.744  29.746   8.903  1.00 14.23           C  
ATOM    114  N   LYS    59      62.121  31.246  14.598  1.00 14.08           N  
ATOM    115  CA  LYS    59      62.020  30.843  16.006  1.00 14.62           C  
ATOM    116  C   LYS    59      60.743  30.022  16.200  1.00 12.52           C  
ATOM    117  O   LYS    59      59.644  30.488  15.927  1.00 13.60           O  
ATOM    118  CB  LYS    59      61.910  32.079  16.895  1.00 15.93           C  
ATOM    119  CG  LYS    59      61.829  31.753  18.359  1.00 26.23           C  
ATOM    120  CD  LYS    59      61.027  32.736  19.182  1.00 42.53           C  
ATOM    121  CE  LYS    59      60.478  32.008  20.423  1.00 38.99           C  
ATOM    122  NZ  LYS    59      59.795  32.940  21.356  1.00 52.57           N  
ATOM    123  N   VAL    60      60.934  28.802  16.689  1.00 13.66           N  
ATOM    124  CA  VAL    60      59.793  27.994  17.143  1.00 13.47           C  
ATOM    125  C   VAL    60      59.344  28.498  18.511  1.00 13.92           C  
ATOM    126  O   VAL    60      60.137  28.816  19.414  1.00 14.52           O  
ATOM    127  CB  VAL    60      60.234  26.554  17.220  1.00 13.49           C  
ATOM    128  CG1 VAL    60      59.198  25.667  17.858  1.00 16.90           C  
ATOM    129  CG2 VAL    60      60.592  26.012  15.833  1.00 15.18           C  
ATOM    130  N   THR    61      58.045  28.632  18.669  1.00 11.16           N  
ATOM    131  CA  THR    61      57.489  29.030  19.955  1.00 12.58           C  
ATOM    132  C   THR    61      58.021  28.177  21.079  1.00 11.96           C  
ATOM    133  O   THR    61      58.180  26.977  20.937  1.00 14.16           O  
ATOM    134  CB  THR    61      55.958  28.978  19.959  1.00 12.49           C  
ATOM    135  OG1 THR    61      55.466  29.355  21.259  1.00 12.38           O  
ATOM    136  CG2 THR    61      55.400  27.573  19.642  1.00 15.10           C  
ATOM    137  N   THR    62      58.247  28.813  22.226  1.00 11.36           N  
ATOM    138  CA  THR    62      58.591  28.147  23.483  1.00 12.68           C  
ATOM    139  C   THR    62      57.476  28.210  24.494  1.00 13.79           C  
ATOM    140  O   THR    62      57.664  27.915  25.658  1.00 13.51           O  
ATOM    141  CB  THR    62      59.871  28.693  24.089  1.00 13.18           C  
ATOM    142  OG1 THR    62      59.710  30.055  24.410  1.00 15.34           O  
ATOM    143  CG2 THR    62      61.061  28.498  23.091  1.00 15.79           C  
ATOM    144  N   ASP    63      56.331  28.681  24.068  1.00 12.04           N  
ATOM    145  CA  ASP    63      55.099  28.824  24.891  1.00 12.49           C  
ATOM    146  C   ASP    63      54.255  27.568  24.788  1.00 12.75           C  
ATOM    147  O   ASP    63      53.565  27.355  23.828  1.00 13.51           O  
ATOM    148  CB  ASP    63      54.350  30.064  24.448  1.00 12.64           C  
ATOM    149  CG  ASP    63      52.971  30.192  25.040  1.00 12.95           C  
ATOM    150  OD1 ASP    63      52.627  29.458  26.003  1.00 13.34           O  
ATOM    151  OD2 ASP    63      52.179  31.027  24.611  1.00 14.27           O  
ATOM    152  N   GLN    64      54.374  26.695  25.788  0.50 12.12           N  
ATOM    154  CA  GLN    64      53.705  25.408  25.788  0.50 14.02           C  
ATOM    156  C   GLN    64      52.248  25.493  26.246  0.50 14.55           C  
ATOM    158  O   GLN    64      51.557  24.557  26.224  0.50 14.93           O  
ATOM    160  CB  GLN    64      54.460  24.419  26.676  0.50 14.49           C  
ATOM    162  CG  GLN    64      55.815  23.957  26.145  0.50 12.98           C  
ATOM    164  CD  GLN    64      56.635  23.304  27.264  0.50 14.84           C  
ATOM    166  OE1 GLN    64      57.488  23.881  27.749  0.50 17.79           O  
ATOM    168  NE2 GLN    64      56.284  22.161  27.659  0.50 16.37           N  
ATOM    170  N   ASN    65      51.866  26.671  26.646  1.00 13.25           N  
ATOM    171  CA  ASN    65      50.451  26.926  27.022  1.00 13.33           C  
ATOM    172  C   ASN    65      49.610  27.304  25.810  1.00 16.33           C  
ATOM    173  O   ASN    65      48.565  26.697  25.531  1.00 18.30           O  
ATOM    174  CB  ASN    65      50.326  28.018  28.077  1.00 13.67           C  
ATOM    175  CG  ASN    65      50.886  27.646  29.469  1.00 16.25           C  
ATOM    176  OD1 ASN    65      51.095  26.517  29.757  1.00 16.68           O  
ATOM    177  ND2 ASN    65      51.181  28.674  30.277  1.00 21.75           N  
ATOM    178  N   HIS    66      50.085  28.325  25.104  1.00 12.59           N  
ATOM    179  CA  HIS    66      49.288  28.890  23.985  1.00 13.98           C  
ATOM    180  C   HIS    66      50.034  29.082  22.698  1.00 13.12           C  
ATOM    181  O   HIS    66      49.472  29.597  21.739  1.00 14.64           O  
ATOM    182  CB  HIS    66      48.680  30.209  24.422  1.00 14.75           C  
ATOM    183  CG  HIS    66      47.828  30.104  25.631  1.00 16.73           C  
ATOM    184  ND1 HIS    66      46.642  29.417  25.613  1.00 20.53           N  
ATOM    185  CD2 HIS    66      47.978  30.597  26.875  1.00 21.10           C  
ATOM    186  CE1 HIS    66      46.106  29.470  26.829  1.00 18.23           C  
ATOM    187  NE2 HIS    66      46.893  30.187  27.609  1.00 22.26           N  
ATOM    188  N   PHE    67      51.284  28.629  22.627  1.00 13.01           N  
ATOM    189  CA  PHE    67      52.021  28.572  21.382  1.00 13.28           C  
ATOM    190  C   PHE    67      52.322  29.906  20.756  1.00 13.49           C  
ATOM    191  O   PHE    67      52.498  30.025  19.527  1.00 13.56           O  
ATOM    192  CB  PHE    67      51.341  27.654  20.368  1.00 15.05           C  
ATOM    193  CG  PHE    67      50.957  26.344  20.965  1.00 17.72           C  
ATOM    194  CD1 PHE    67      51.911  25.378  21.176  1.00 23.21           C  
ATOM    195  CD2 PHE    67      49.658  26.143  21.406  1.00 22.52           C  
ATOM    196  CE1 PHE    67      51.537  24.149  21.815  1.00 25.66           C  
ATOM    197  CE2 PHE    67      49.293  24.947  22.040  1.00 28.53           C  
ATOM    198  CZ  PHE    67      50.229  23.962  22.194  1.00 25.82           C  
ATOM    199  N   SER    68      52.387  30.928  21.578  1.00 12.49           N  
ATOM    200  CA  SER    68      52.660  32.295  21.105  1.00 12.95           C  
ATOM    201  C   SER    68      54.118  32.605  20.942  1.00 14.02           C  
ATOM    202  O   SER    68      54.984  31.954  21.516  1.00 12.82           O  
ATOM    203  CB  SER    68      52.083  33.358  22.054  1.00 13.92           C  
ATOM    204  OG  SER    68      52.800  33.389  23.291  1.00 15.55           O  
ATOM    205  N   GLY    69      54.380  33.619  20.102  1.00 13.56           N  
ATOM    206  CA  GLY    69      55.725  34.170  20.006  1.00 13.94           C  
ATOM    207  C   GLY    69      56.683  33.525  19.032  1.00 13.72           C  
ATOM    208  O   GLY    69      57.862  33.882  18.964  1.00 15.52           O  
ATOM    209  N   GLY    70      56.212  32.519  18.300  1.00 13.04           N  
ATOM    210  CA  GLY    70      56.975  31.982  17.196  1.00 12.43           C  
ATOM    211  C   GLY    70      56.981  32.950  16.050  1.00 12.32           C  
ATOM    212  O   GLY    70      56.150  33.843  15.955  1.00 12.85           O  
ATOM    213  N   THR    71      57.865  32.692  15.100  1.00 13.21           N  
ATOM    214  CA  THR    71      57.926  33.543  13.911  1.00 13.30           C  
ATOM    215  C   THR    71      56.612  33.537  13.147  1.00 12.97           C  
ATOM    216  O   THR    71      55.937  32.524  13.039  1.00 12.97           O  
ATOM    217  CB  THR    71      59.090  33.094  13.050  1.00 12.99           C  
ATOM    218  OG1 THR    71      60.305  33.177  13.794  1.00 13.48           O  
ATOM    219  CG2 THR    71      59.201  33.884  11.752  1.00 15.30           C  
ATOM    220  N   SER    72      56.244  34.710  12.629  1.00 14.09           N  
ATOM    221  CA  SER    72      55.040  34.891  11.830  1.00 13.45           C  
ATOM    222  C   SER    72      55.295  34.802  10.333  1.00 13.09           C  
ATOM    223  O   SER    72      56.421  34.900   9.902  1.00 12.49           O  
ATOM    224  CB  SER    72      54.442  36.260  12.107  1.00 14.68           C  
ATOM    225  OG  SER    72      55.310  37.264  11.594  1.00 16.44           O  
ATOM    226  N   ILE    73      54.227  34.683   9.549  1.00 13.18           N  
ATOM    227  CA  ILE    73      54.364  34.608   8.107  1.00 13.51           C  
ATOM    228  C   ILE    73      54.882  35.955   7.582  1.00 13.87           C  
ATOM    229  O   ILE    73      55.617  36.016   6.613  1.00 13.86           O  
ATOM    230  CB  ILE    73      53.086  34.139   7.357  1.00 13.51           C  
ATOM    231  CG1 ILE    73      53.350  33.888   5.880  1.00 14.56           C  
ATOM    232  CG2 ILE    73      51.889  35.106   7.531  1.00 13.17           C  
ATOM    233  CD1 ILE    73      54.528  32.975   5.539  1.00 15.87           C  
ATOM    234  N   GLU    74      54.467  37.084   8.185  1.00 13.06           N  
ATOM    235  CA  GLU    74      54.958  38.421   7.720  1.00 13.88           C  
ATOM    236  C   GLU    74      56.457  38.482   7.857  1.00 14.61           C  
ATOM    237  O   GLU    74      57.184  38.966   7.002  1.00 15.05           O  
ATOM    238  CB  GLU    74      54.273  39.509   8.558  1.00 17.37           C  
ATOM    239  CG  GLU    74      52.772  39.642   8.275  1.00 20.52           C  
ATOM    240  CD  GLU    74      51.845  38.674   9.029  1.00 22.79           C  
ATOM    241  OE1 GLU    74      52.291  37.856   9.877  1.00 17.21           O  
ATOM    242  OE2 GLU    74      50.626  38.709   8.725  1.00 28.56           O  
ATOM    243  N   GLN    75      56.970  37.948   8.979  1.00 13.46           N  
ATOM    244  CA  GLN    75      58.413  37.935   9.178  1.00 13.61           C  
ATOM    245  C   GLN    75      59.107  37.018   8.139  1.00 13.36           C  
ATOM    246  O   GLN    75      60.135  37.370   7.560  1.00 14.80           O  
ATOM    247  CB  GLN    75      58.847  37.471  10.593  1.00 14.32           C  
ATOM    248  CG  GLN    75      58.525  38.506  11.640  1.00 16.98           C  
ATOM    249  CD  GLN    75      58.716  37.980  13.040  1.00 17.63           C  
ATOM    250  OE1 GLN    75      58.334  36.855  13.362  1.00 17.41           O  
ATOM    251  NE2 GLN    75      59.168  38.861  13.929  1.00 24.89           N  
ATOM    252  N   LEU    76      58.562  35.792   7.980  1.00 13.88           N  
ATOM    253  CA  LEU    76      59.156  34.825   7.029  1.00 13.39           C  
ATOM    254  C   LEU    76      59.223  35.440   5.624  1.00 13.33           C  
ATOM    255  O   LEU    76      60.226  35.271   4.935  1.00 14.77           O  
ATOM    256  CB  LEU    76      58.337  33.539   7.016  1.00 12.89           C  
ATOM    257  CG  LEU    76      58.547  32.722   8.283  1.00 13.51           C  
ATOM    258  CD1 LEU    76      57.444  31.675   8.386  1.00 15.01           C  
ATOM    259  CD2 LEU    76      59.921  32.063   8.311  1.00 14.69           C  
ATOM    260  N   LYS    77      58.182  36.158   5.232  1.00 13.00           N  
ATOM    261  CA  LYS    77      58.164  36.734   3.863  1.00 14.08           C  
ATOM    262  C   LYS    77      59.163  37.869   3.760  1.00 14.65           C  
ATOM    263  O   LYS    77      59.757  38.063   2.699  1.00 15.54           O  
ATOM    264  CB  LYS    77      56.787  37.160   3.464  1.00 14.38           C  
ATOM    265  CG  LYS    77      55.855  36.018   3.184  1.00 14.59           C  
ATOM    266  CD  LYS    77      54.453  36.490   2.811  1.00 17.96           C  
ATOM    267  CE  LYS    77      53.524  35.381   2.334  1.00 20.49           C  
ATOM    268  NZ  LYS    77      52.175  35.980   2.020  1.00 29.93           N  
ATOM    269  N   GLN    78      59.367  38.632   4.831  0.50 15.57           N  
ATOM    271  CA  GLN    78      60.434  39.654   4.850  0.50 15.54           C  
ATOM    273  C   GLN    78      61.792  39.059   4.574  0.50 16.54           C  
ATOM    275  O   GLN    78      62.583  39.621   3.909  0.50 17.93           O  
ATOM    277  CB  GLN    78      60.506  40.392   6.167  0.50 17.51           C  
ATOM    279  CG  GLN    78      59.459  41.345   6.358  0.50 20.65           C  
ATOM    281  CD  GLN    78      59.608  42.049   7.678  0.50 30.94           C  
ATOM    283  OE1 GLN    78      60.699  42.079   8.248  0.50 34.48           O  
ATOM    285  NE2 GLN    78      58.524  42.576   8.188  0.50 36.48           N  
ATOM    287  N   TRP    79      62.052  37.890   5.108  1.00 14.19           N  
ATOM    288  CA  TRP    79      63.365  37.279   5.016  1.00 14.86           C  
ATOM    289  C   TRP    79      63.563  36.453   3.743  1.00 15.73           C  
ATOM    290  O   TRP    79      64.651  36.381   3.217  1.00 18.13           O  
ATOM    291  CB  TRP    79      63.691  36.393   6.233  1.00 17.01           C  
ATOM    292  CG  TRP    79      63.571  37.087   7.552  1.00 16.46           C  
ATOM    293  CD1 TRP    79      63.879  38.398   7.830  1.00 19.66           C  
ATOM    294  CD2 TRP    79      63.165  36.501   8.772  1.00 16.89           C  
ATOM    295  NE1 TRP    79      63.642  38.638   9.164  1.00 19.26           N  
ATOM    296  CE2 TRP    79      63.164  37.484   9.749  1.00 14.01           C  
ATOM    297  CE3 TRP    79      62.756  35.227   9.115  1.00 16.48           C  
ATOM    298  CZ2 TRP    79      62.805  37.228  11.072  1.00 17.69           C  
ATOM    299  CZ3 TRP    79      62.379  34.988  10.423  1.00 17.55           C  
ATOM    300  CH2 TRP    79      62.399  35.991  11.378  1.00 16.64           C  
ATOM    301  N   PHE    80      62.497  35.778   3.311  1.00 13.08           N  
ATOM    302  CA  PHE    80      62.593  34.774   2.255  1.00 14.50           C  
ATOM    303  C   PHE    80      61.747  35.080   1.009  1.00 13.80           C  
ATOM    304  O   PHE    80      61.840  34.369  -0.012  1.00 15.94           O  
ATOM    305  CB  PHE    80      62.124  33.428   2.815  1.00 14.21           C  
ATOM    306  CG  PHE    80      62.994  32.886   3.905  1.00 14.04           C  
ATOM    307  CD1 PHE    80      64.259  32.416   3.617  1.00 14.25           C  
ATOM    308  CD2 PHE    80      62.613  32.891   5.239  1.00 14.48           C  
ATOM    309  CE1 PHE    80      65.090  31.917   4.572  1.00 13.53           C  
ATOM    310  CE2 PHE    80      63.475  32.367   6.208  1.00 14.84           C  
ATOM    311  CZ  PHE    80      64.709  31.892   5.873  1.00 13.35           C  
ATOM    312  N   GLY    81      60.946  36.118   1.061  1.00 13.12           N  
ATOM    313  CA  GLY    81      60.021  36.403  -0.003  1.00 13.04           C  
ATOM    314  C   GLY    81      58.835  35.471  -0.021  1.00 14.06           C  
ATOM    315  O   GLY    81      58.583  34.814   0.916  1.00 13.41           O  
ATOM    316  N   ASP    82      58.113  35.430  -1.116  1.00 14.92           N  
ATOM    317  CA  ASP    82      56.952  34.560  -1.190  1.00 14.81           C  
ATOM    318  C   ASP    82      57.358  33.098  -1.201  1.00 13.54           C  
ATOM    319  O   ASP    82      58.287  32.722  -1.811  1.00 13.58           O  
ATOM    320  CB  ASP    82      56.123  34.831  -2.421  1.00 18.65           C  
ATOM    321  CG  ASP    82      55.392  36.129  -2.360  1.00 24.78           C  
ATOM    322  OD1 ASP    82      55.129  36.646  -1.300  1.00 30.84           O  
ATOM    323  OD2 ASP    82      55.078  36.599  -3.422  1.00 31.01           O  
ATOM    324  N   PRO    83      56.596  32.284  -0.495  1.00 13.40           N  
ATOM    325  CA  PRO    83      56.875  30.849  -0.482  1.00 12.94           C  
ATOM    326  C   PRO    83      56.639  30.215  -1.858  1.00 12.49           C  
ATOM    327  O   PRO    83      55.826  30.666  -2.602  1.00 14.14           O  
ATOM    328  CB  PRO    83      55.873  30.293   0.521  1.00 16.29           C  
ATOM    329  CG  PRO    83      55.048  31.352   0.916  1.00 19.28           C  
ATOM    330  CD  PRO    83      55.500  32.668   0.393  1.00 15.92           C  
ATOM    331  N   ASN    84      57.371  29.180  -2.154  1.00 10.26           N  
ATOM    332  CA  ASN    84      57.107  28.378  -3.325  1.00 10.08           C  
ATOM    333  C   ASN    84      55.864  27.537  -3.213  1.00 10.37           C  
ATOM    334  O   ASN    84      55.220  27.279  -4.152  1.00 11.07           O  
ATOM    335  CB  ASN    84      58.322  27.511  -3.595  1.00 10.26           C  
ATOM    336  CG  ASN    84      59.568  28.346  -3.824  1.00 12.83           C  
ATOM    337  OD1 ASN    84      60.328  28.612  -2.992  1.00 12.21           O  
ATOM    338  ND2 ASN    84      59.690  28.798  -5.033  1.00 12.91           N  
ATOM    339  N   LYS    85      55.532  27.131  -2.006  1.00 11.53           N  
ATOM    340  CA  LYS    85      54.341  26.293  -1.779  1.00 13.08           C  
ATOM    341  C   LYS    85      53.823  26.548  -0.416  1.00 12.34           C  
ATOM    342  O   LYS    85      54.578  26.848   0.520  1.00 12.94           O  
ATOM    343  CB  LYS    85      54.688  24.833  -1.969  1.00 16.21           C  
ATOM    344  CG  LYS    85      53.428  23.979  -2.095  1.00 20.53           C  
ATOM    345  CD  LYS    85      53.757  22.596  -2.641  1.00 24.01           C  
ATOM    346  CE  LYS    85      52.487  21.778  -3.011  1.00 27.26           C  
ATOM    347  NZ  LYS    85      52.753  20.349  -3.387  1.00 36.02           N  
ATOM    348  N   SER    86      52.518  26.472  -0.258  1.00 13.01           N  
ATOM    349  CA  SER    86      51.903  26.504   1.026  1.00 13.02           C  
ATOM    350  C   SER    86      50.656  25.691   1.065  1.00 13.53           C  
ATOM    351  O   SER    86      49.986  25.481   0.055  1.00 15.93           O  
ATOM    352  CB  SER    86      51.647  27.889   1.449  1.00 18.27           C  
ATOM    353  OG  SER    86      50.766  28.526   0.638  1.00 19.45           O  
ATOM    354  N   GLU    87      50.361  25.197   2.250  1.00 13.71           N  
ATOM    355  CA  GLU    87      49.161  24.403   2.401  1.00 16.67           C  
ATOM    356  C   GLU    87      48.689  24.395   3.810  1.00 13.63           C  
ATOM    357  O   GLU    87      49.433  24.548   4.758  1.00 15.39           O  
ATOM    358  CB  GLU    87      49.409  22.986   1.980  1.00 22.37           C  
ATOM    359  CG  GLU    87      50.411  22.300   2.720  1.00 25.77           C  
ATOM    360  CD  GLU    87      50.615  20.866   2.254  1.00 46.22           C  
ATOM    361  OE1 GLU    87      50.455  20.609   1.038  1.00 47.73           O  
ATOM    362  OE2 GLU    87      50.954  20.006   3.102  1.00 47.64           O  
ATOM    363  N   GLN    88      47.399  24.201   3.935  1.00 14.79           N  
ATOM    364  CA  GLN    88      46.756  24.095   5.243  1.00 16.17           C  
ATOM    365  C   GLN    88      46.789  22.639   5.586  1.00 20.90           C  
ATOM    366  O   GLN    88      46.277  21.812   4.808  1.00 25.93           O  
ATOM    367  CB  GLN    88      45.321  24.644   5.166  1.00 21.92           C  
ATOM    368  CG  GLN    88      44.563  24.820   6.376  1.00 29.30           C  
ATOM    369  CD  GLN    88      43.148  25.141   5.996  1.00 31.23           C  
ATOM    370  OE1 GLN    88      42.367  24.246   5.625  1.00 36.11           O  
ATOM    371  NE2 GLN    88      42.818  26.419   6.014  1.00 29.69           N  
ATOM    372  N   ARG    89      47.349  22.295   6.754  1.00 18.58           N  
ATOM    373  CA  ARG    89      47.418  20.934   7.278  1.00 18.32           C  
ATOM    374  C   ARG    89      46.464  20.766   8.483  1.00 17.44           C  
ATOM    375  O   ARG    89      46.679  21.335   9.567  1.00 17.86           O  
ATOM    376  CB  ARG    89      48.805  20.575   7.741  1.00 20.36           C  
ATOM    377  CG  ARG    89      49.915  20.773   6.611  1.00 22.85           C  
ATOM    378  CD  ARG    89      51.262  20.373   7.119  1.00 31.18           C  
ATOM    379  NE  ARG    89      51.309  18.929   7.338  1.00 40.83           N  
ATOM    380  CZ  ARG    89      51.624  18.331   8.493  1.00 45.64           C  
ATOM    381  NH1 ARG    89      51.984  19.029   9.570  1.00 41.18           N  
ATOM    382  NH2 ARG    89      51.595  17.003   8.565  1.00 52.35           N  
ATOM    383  N   ASN    90      45.433  19.964   8.279  1.00 16.30           N  
ATOM    384  CA  ASN    90      44.302  19.826   9.220  1.00 16.40           C  
ATOM    385  C   ASN    90      44.354  18.497   9.860  1.00 15.52           C  
ATOM    386  O   ASN    90      44.631  17.480   9.210  1.00 15.70           O  
ATOM    387  CB  ASN    90      43.013  19.994   8.455  1.00 16.99           C  
ATOM    388  CG  ASN    90      42.918  21.368   7.844  1.00 25.42           C  
ATOM    389  OD1 ASN    90      43.005  22.386   8.546  1.00 27.15           O  
ATOM    390  ND2 ASN    90      42.799  21.407   6.517  1.00 24.63           N  
ATOM    391  N   ALA    91      44.130  18.455  11.171  1.00 13.92           N  
ATOM    392  CA  ALA    91      44.035  17.171  11.898  1.00 13.29           C  
ATOM    393  C   ALA    91      43.074  17.440  13.048  1.00 10.01           C  
ATOM    394  O   ALA    91      43.404  18.297  13.915  1.00 12.66           O  
ATOM    395  CB  ALA    91      45.407  16.736  12.368  1.00 17.79           C  
ATOM    396  N   GLY    92      41.935  16.817  13.099  1.00 10.34           N  
ATOM    397  CA  GLY    92      40.941  17.162  14.068  1.00 10.21           C  
ATOM    398  C   GLY    92      40.631  18.614  13.922  1.00 11.97           C  
ATOM    399  O   GLY    92      40.472  19.125  12.779  1.00 12.53           O  
ATOM    400  N   ASN    93      40.533  19.360  15.018  1.00 11.57           N  
ATOM    401  CA  ASN    93      40.282  20.799  14.966  1.00 11.98           C  
ATOM    402  C   ASN    93      41.590  21.632  15.115  1.00 13.52           C  
ATOM    403  O   ASN    93      41.517  22.779  15.541  1.00 20.02           O  
ATOM    404  CB  ASN    93      39.197  21.199  15.994  1.00 12.29           C  
ATOM    405  CG  ASN    93      37.825  20.847  15.533  1.00 11.52           C  
ATOM    406  OD1 ASN    93      37.555  20.946  14.328  1.00 12.34           O  
ATOM    407  ND2 ASN    93      36.920  20.517  16.430  1.00 10.26           N  
ATOM    408  N   ILE    94      42.724  21.041  14.815  1.00 12.82           N  
ATOM    409  CA  ILE    94      43.997  21.757  14.764  1.00 13.61           C  
ATOM    410  C   ILE    94      44.345  21.991  13.320  1.00 13.37           C  
ATOM    411  O   ILE    94      44.348  21.063  12.505  1.00 16.62           O  
ATOM    412  CB  ILE    94      45.095  20.999  15.477  1.00 15.85           C  
ATOM    413  CG1 ILE    94      44.692  20.791  16.912  1.00 18.01           C  
ATOM    414  CG2 ILE    94      46.431  21.819  15.439  1.00 19.39           C  
ATOM    415  CD1 ILE    94      45.634  19.874  17.681  1.00 22.29           C  
ATOM    416  N   THR    95      44.654  23.234  12.961  1.00 13.04           N  
ATOM    417  CA  THR    95      45.120  23.590  11.631  1.00 14.32           C  
ATOM    418  C   THR    95      46.447  24.274  11.740  1.00 13.15           C  
ATOM    419  O   THR    95      46.647  25.183  12.556  1.00 14.51           O  
ATOM    420  CB  THR    95      44.169  24.553  10.963  1.00 18.04           C  
ATOM    421  OG1 THR    95      42.910  23.872  10.806  1.00 19.06           O  
ATOM    422  CG2 THR    95      44.662  25.009   9.649  1.00 18.01           C  
ATOM    423  N   LEU    96      47.394  23.765  10.956  1.00 13.47           N  
ATOM    424  CA  LEU    96      48.706  24.398  10.776  1.00 14.28           C  
ATOM    425  C   LEU    96      48.799  24.886   9.368  1.00 14.86           C  
ATOM    426  O   LEU    96      48.312  24.242   8.428  1.00 17.12           O  
ATOM    427  CB  LEU    96      49.861  23.443  11.057  1.00 13.90           C  
ATOM    428  CG  LEU    96      49.893  22.766  12.398  1.00 14.59           C  
ATOM    429  CD1 LEU    96      51.103  21.831  12.512  1.00 19.89           C  
ATOM    430  CD2 LEU    96      49.896  23.786  13.523  1.00 15.90           C  
ATOM    431  N   ASP    97      49.391  26.048   9.206  1.00 13.46           N  
ATOM    432  CA  ASP    97      49.737  26.575   7.878  1.00 12.58           C  
ATOM    433  C   ASP    97      51.178  26.270   7.595  1.00 12.91           C  
ATOM    434  O   ASP    97      52.061  26.723   8.336  1.00 13.45           O  
ATOM    435  CB  ASP    97      49.474  28.091   7.820  1.00 13.48           C  
ATOM    436  CG  ASP    97      47.991  28.419   7.974  1.00 21.00           C  
ATOM    437  OD1 ASP    97      47.179  27.799   7.246  1.00 21.28           O  
ATOM    438  OD2 ASP    97      47.610  29.151   8.896  1.00 26.54           O  
ATOM    439  N   SER    98      51.424  25.514   6.518  1.00 12.39           N  
ATOM    440  CA  SER    98      52.753  25.041   6.211  1.00 12.76           C  
ATOM    441  C   SER    98      53.264  25.843   4.988  1.00 12.48           C  
ATOM    442  O   SER    98      52.555  25.937   3.978  1.00 15.58           O  
ATOM    443  CB  SER    98      52.708  23.571   5.882  1.00 14.87           C  
ATOM    444  OG  SER    98      53.988  23.063   5.505  1.00 15.98           O  
ATOM    445  N   TYR    99      54.476  26.363   5.024  1.00 10.99           N  
ATOM    446  CA  TYR    99      55.045  27.161   3.980  1.00 11.66           C  
ATOM    447  C   TYR    99      56.425  26.630   3.654  1.00 12.44           C  
ATOM    448  O   TYR    99      57.205  26.302   4.545  1.00 12.27           O  
ATOM    449  CB  TYR    99      55.211  28.591   4.440  1.00 13.89           C  
ATOM    450  CG  TYR    99      53.946  29.271   4.925  1.00 13.25           C  
ATOM    451  CD1 TYR    99      53.097  29.962   4.059  1.00 15.32           C  
ATOM    452  CD2 TYR    99      53.602  29.232   6.263  1.00 13.12           C  
ATOM    453  CE1 TYR    99      51.935  30.616   4.533  1.00 14.71           C  
ATOM    454  CE2 TYR    99      52.477  29.873   6.753  1.00 15.27           C  
ATOM    455  CZ  TYR    99      51.686  30.572   5.901  1.00 14.87           C  
ATOM    456  OH  TYR    99      50.563  31.253   6.397  1.00 16.68           O  
ATOM    457  N   THR   100      56.749  26.573   2.379  1.00 11.11           N  
ATOM    458  CA  THR   100      58.040  26.030   1.941  1.00 11.74           C  
ATOM    459  C   THR   100      58.708  26.947   0.949  1.00 12.17           C  
ATOM    460  O   THR   100      58.046  27.466   0.016  1.00 11.04           O  
ATOM    461  CB  THR   100      57.833  24.658   1.290  1.00 13.32           C  
ATOM    462  OG1 THR   100      57.208  23.788   2.279  1.00 14.23           O  
ATOM    463  CG2 THR   100      59.139  24.062   0.838  1.00 15.26           C  
ATOM    464  N   TRP   101      60.005  27.167   1.137  1.00 11.39           N  
ATOM    465  CA  TRP   101      60.852  27.930   0.239  1.00 11.15           C  
ATOM    466  C   TRP   101      61.971  27.032  -0.280  1.00 11.99           C  
ATOM    467  O   TRP   101      62.516  26.227   0.471  1.00 12.44           O  
ATOM    468  CB  TRP   101      61.474  29.170   0.921  1.00 12.60           C  
ATOM    469  CG  TRP   101      60.531  30.197   1.374  1.00 11.64           C  
ATOM    470  CD1 TRP   101      60.250  31.360   0.729  1.00 12.60           C  
ATOM    471  CD2 TRP   101      59.729  30.214   2.576  1.00 11.65           C  
ATOM    472  NE1 TRP   101      59.343  32.102   1.448  1.00 13.00           N  
ATOM    473  CE2 TRP   101      58.995  31.415   2.573  1.00 11.80           C  
ATOM    474  CE3 TRP   101      59.539  29.326   3.632  1.00 12.78           C  
ATOM    475  CZ2 TRP   101      58.113  31.745   3.559  1.00 13.27           C  
ATOM    476  CZ3 TRP   101      58.677  29.682   4.638  1.00 12.39           C  
ATOM    477  CH2 TRP   101      57.956  30.889   4.578  1.00 12.17           C  
ATOM    478  N   VAL   102      62.345  27.199  -1.545  1.00 11.00           N  
ATOM    479  CA  VAL   102      63.421  26.448  -2.134  1.00 11.98           C  
ATOM    480  C   VAL   102      64.393  27.410  -2.741  1.00 12.13           C  
ATOM    481  O   VAL   102      64.020  28.384  -3.395  1.00 12.59           O  
ATOM    482  CB  VAL   102      62.866  25.510  -3.252  1.00 12.04           C  
ATOM    483  CG1 VAL   102      64.015  24.682  -3.872  1.00 14.31           C  
ATOM    484  CG2 VAL   102      61.760  24.619  -2.718  1.00 13.96           C  
ATOM    485  N   LYS   103      65.683  27.177  -2.538  1.00 12.39           N  
ATOM    486  CA  LYS   103      66.739  27.994  -3.156  1.00 11.73           C  
ATOM    487  C   LYS   103      67.937  27.102  -3.481  1.00 12.61           C  
ATOM    488  O   LYS   103      68.522  26.528  -2.553  1.00 11.82           O  
ATOM    489  CB  LYS   103      67.206  29.135  -2.264  1.00 12.41           C  
ATOM    490  CG  LYS   103      68.104  30.138  -2.998  1.00 15.61           C  
ATOM    491  CD  LYS   103      68.423  31.332  -2.160  1.00 23.60           C  
ATOM    492  CE  LYS   103      69.469  32.215  -2.836  1.00 31.98           C  
ATOM    493  NZ  LYS   103      69.181  32.337  -4.283  1.00 40.27           N  
ATOM    494  N   ASP   104      68.220  26.932  -4.763  1.00 13.36           N  
ATOM    495  CA  ASP   104      69.344  26.091  -5.189  1.00 14.29           C  
ATOM    496  C   ASP   104      69.292  24.709  -4.573  1.00 14.95           C  
ATOM    497  O   ASP   104      70.312  24.182  -4.126  1.00 15.50           O  
ATOM    498  CB  ASP   104      70.655  26.770  -4.844  1.00 17.74           C  
ATOM    499  CG  ASP   104      70.815  28.092  -5.539  1.00 24.86           C  
ATOM    500  OD1 ASP   104      70.181  28.297  -6.604  1.00 22.61           O  
ATOM    501  OD2 ASP   104      71.566  28.925  -4.994  1.00 35.59           O  
ATOM    502  N   GLY   105      68.099  24.137  -4.534  1.00 12.75           N  
ATOM    503  CA  GLY   105      67.888  22.785  -4.069  1.00 13.20           C  
ATOM    504  C   GLY   105      67.731  22.672  -2.548  1.00 12.35           C  
ATOM    505  O   GLY   105      67.197  21.682  -2.095  1.00 13.16           O  
ATOM    506  N   ALA   106      68.151  23.697  -1.809  1.00 12.17           N  
ATOM    507  CA  ALA   106      67.907  23.690  -0.337  1.00 12.30           C  
ATOM    508  C   ALA   106      66.439  24.001  -0.085  1.00 11.67           C  
ATOM    509  O   ALA   106      65.861  24.830  -0.805  1.00 13.14           O  
ATOM    510  CB  ALA   106      68.779  24.716   0.356  1.00 14.20           C  
ATOM    511  N   VAL   107      65.860  23.405   0.936  1.00 11.22           N  
ATOM    512  CA  VAL   107      64.434  23.536   1.213  1.00 11.38           C  
ATOM    513  C   VAL   107      64.239  23.930   2.646  1.00 13.17           C  
ATOM    514  O   VAL   107      64.735  23.266   3.575  1.00 12.64           O  
ATOM    515  CB  VAL   107      63.704  22.222   0.996  1.00 12.07           C  
ATOM    516  CG1 VAL   107      62.196  22.410   1.209  1.00 14.82           C  
ATOM    517  CG2 VAL   107      63.947  21.655  -0.431  1.00 14.27           C  
ATOM    518  N   ILE   108      63.526  25.022   2.860  1.00 10.68           N  
ATOM    519  CA  ILE   108      63.098  25.485   4.204  1.00 11.86           C  
ATOM    520  C   ILE   108      61.610  25.304   4.333  1.00 11.07           C  
ATOM    521  O   ILE   108      60.855  25.764   3.454  1.00 11.74           O  
ATOM    522  CB  ILE   108      63.472  26.939   4.452  1.00 12.14           C  
ATOM    523  CG1 ILE   108      64.995  27.057   4.669  1.00 12.29           C  
ATOM    524  CG2 ILE   108      62.709  27.569   5.682  1.00 13.02           C  
ATOM    525  CD1 ILE   108      65.475  28.495   4.753  1.00 13.94           C  
ATOM    526  N   ASN   109      61.182  24.703   5.426  1.00 11.22           N  
ATOM    527  CA  ASN   109      59.740  24.604   5.736  1.00 10.80           C  
ATOM    528  C   ASN   109      59.488  25.211   7.081  1.00 12.44           C  
ATOM    529  O   ASN   109      60.281  25.027   8.034  1.00 12.88           O  
ATOM    530  CB  ASN   109      59.291  23.134   5.732  1.00 11.22           C  
ATOM    531  CG  ASN   109      57.867  22.916   6.169  1.00 14.50           C  
ATOM    532  OD1 ASN   109      57.597  22.396   7.257  1.00 16.95           O  
ATOM    533  ND2 ASN   109      56.917  23.307   5.315  1.00 14.77           N  
ATOM    534  N   ALA   110      58.365  25.881   7.214  1.00 11.48           N  
ATOM    535  CA  ALA   110      57.888  26.355   8.545  1.00 11.46           C  
ATOM    536  C   ALA   110      56.412  26.018   8.637  1.00 12.60           C  
ATOM    537  O   ALA   110      55.663  26.225   7.661  1.00 13.35           O  
ATOM    538  CB  ALA   110      58.141  27.836   8.693  1.00 13.86           C  
ATOM    539  N   GLN   111      55.989  25.562   9.811  1.00 11.51           N  
ATOM    540  CA  GLN   111      54.583  25.237  10.082  1.00 12.48           C  
ATOM    541  C   GLN   111      54.135  26.110  11.216  1.00 11.55           C  
ATOM    542  O   GLN   111      54.765  26.162  12.254  1.00 13.08           O  
ATOM    543  CB  GLN   111      54.387  23.744  10.398  1.00 14.31           C  
ATOM    544  CG  GLN   111      54.933  22.916   9.243  1.00 16.67           C  
ATOM    545  CD  GLN   111      54.579  21.508   9.263  1.00 26.20           C  
ATOM    546  OE1 GLN   111      53.558  21.137   9.764  1.00 25.40           O  
ATOM    547  NE2 GLN   111      55.369  20.706   8.559  1.00 29.54           N  
ATOM    548  N   LEU   112      53.045  26.809  11.025  1.00 11.87           N  
ATOM    549  CA  LEU   112      52.555  27.886  11.930  1.00 12.53           C  
ATOM    550  C   LEU   112      51.172  27.530  12.446  1.00 11.84           C  
ATOM    551  O   LEU   112      50.286  27.107  11.676  1.00 13.09           O  
ATOM    552  CB  LEU   112      52.531  29.242  11.207  1.00 11.83           C  
ATOM    553  CG  LEU   112      53.847  29.982  11.033  1.00 11.76           C  
ATOM    554  CD1 LEU   112      54.845  29.179  10.133  1.00 13.76           C  
ATOM    555  CD2 LEU   112      53.649  31.367  10.488  1.00 14.54           C  
ATOM    556  N   TYR   113      50.973  27.704  13.743  1.00 11.89           N  
ATOM    557  CA  TYR   113      49.636  27.640  14.357  1.00 12.14           C  
ATOM    558  C   TYR   113      49.210  29.063  14.702  1.00 12.39           C  
ATOM    559  O   TYR   113      49.896  29.754  15.430  1.00 12.68           O  
ATOM    560  CB  TYR   113      49.757  26.862  15.681  1.00 13.23           C  
ATOM    561  CG  TYR   113      48.496  26.839  16.459  1.00 14.16           C  
ATOM    562  CD1 TYR   113      47.384  26.158  15.964  1.00 14.81           C  
ATOM    563  CD2 TYR   113      48.365  27.476  17.682  1.00 14.51           C  
ATOM    564  CE1 TYR   113      46.186  26.176  16.658  1.00 15.36           C  
ATOM    565  CE2 TYR   113      47.196  27.464  18.356  1.00 16.51           C  
ATOM    566  CZ  TYR   113      46.151  26.766  17.886  1.00 17.01           C  
ATOM    567  OH  TYR   113      44.940  26.794  18.633  1.00 23.05           O  
ATOM    568  N   LYS   114      48.113  29.500  14.114  1.00 13.28           N  
ATOM    569  CA  LYS   114      47.614  30.836  14.330  1.00 11.79           C  
ATOM    570  C   LYS   114      48.735  31.839  14.177  1.00 12.47           C  
ATOM    571  O   LYS   114      48.929  32.735  15.003  1.00 12.90           O  
ATOM    572  CB  LYS   114      46.872  30.926  15.648  1.00 15.41           C  
ATOM    573  CG  LYS   114      45.515  30.185  15.573  1.00 16.75           C  
ATOM    574  CD  LYS   114      44.738  30.230  16.891  1.00 19.45           C  
ATOM    575  CE  LYS   114      43.541  29.251  16.827  1.00 21.41           C  
ATOM    576  NZ  LYS   114      42.574  29.663  15.860  1.00 28.98           N  
ATOM    577  N   ASN   115      49.511  31.669  13.107  1.00 12.64           N  
ATOM    578  CA  ASN   115      50.544  32.608  12.747  1.00 12.82           C  
ATOM    579  C   ASN   115      51.724  32.670  13.653  1.00 12.90           C  
ATOM    580  O   ASN   115      52.466  33.654  13.697  1.00 13.55           O  
ATOM    581  CB  ASN   115      49.971  34.008  12.496  1.00 13.60           C  
ATOM    582  CG  ASN   115      50.846  34.831  11.517  1.00 14.45           C  
ATOM    583  OD1 ASN   115      51.575  34.257  10.681  1.00 14.99           O  
ATOM    584  ND2 ASN   115      50.777  36.195  11.599  1.00 16.77           N  
ATOM    585  N   SER   116      51.988  31.558  14.311  1.00 12.46           N  
ATOM    586  CA  SER   116      53.139  31.363  15.194  1.00 12.60           C  
ATOM    587  C   SER   116      53.865  30.045  14.897  1.00 11.87           C  
ATOM    588  O   SER   116      53.263  28.952  14.938  1.00 12.13           O  
ATOM    589  CB  SER   116      52.682  31.354  16.653  1.00 12.71           C  
ATOM    590  OG  SER   116      53.761  31.225  17.547  1.00 12.36           O  
ATOM    591  N   THR   117      55.144  30.120  14.511  1.00 12.20           N  
ATOM    592  CA  THR   117      55.890  28.909  14.078  1.00 12.01           C  
ATOM    593  C   THR   117      56.006  27.895  15.185  1.00 11.44           C  
ATOM    594  O   THR   117      56.445  28.205  16.306  1.00 12.59           O  
ATOM    595  CB  THR   117      57.294  29.293  13.609  1.00 12.21           C  
ATOM    596  OG1 THR   117      57.175  30.106  12.440  1.00 12.60           O  
ATOM    597  CG2 THR   117      58.117  28.049  13.246  1.00 13.43           C  
ATOM    598  N   VAL   118      55.548  26.660  14.917  1.00 12.10           N  
ATOM    599  CA  VAL   118      55.649  25.508  15.812  1.00 11.65           C  
ATOM    600  C   VAL   118      56.609  24.460  15.306  1.00 13.44           C  
ATOM    601  O   VAL   118      56.930  23.520  16.062  1.00 13.92           O  
ATOM    602  CB  VAL   118      54.294  24.885  16.158  1.00 12.32           C  
ATOM    603  CG1 VAL   118      53.398  25.907  16.920  1.00 15.07           C  
ATOM    604  CG2 VAL   118      53.573  24.401  14.901  1.00 14.09           C  
ATOM    605  N   ALA   119      57.059  24.558  14.058  1.00 11.45           N  
ATOM    606  CA  ALA   119      58.005  23.577  13.517  1.00 12.03           C  
ATOM    607  C   ALA   119      58.754  24.262  12.386  1.00 12.37           C  
ATOM    608  O   ALA   119      58.193  25.095  11.667  1.00 12.56           O  
ATOM    609  CB  ALA   119      57.293  22.308  12.985  1.00 13.93           C  
ATOM    610  N   ARG   120      60.016  23.917  12.205  1.00 11.57           N  
ATOM    611  CA  ARG   120      60.845  24.411  11.138  1.00 11.57           C  
ATOM    612  C   ARG   120      61.887  23.401  10.710  1.00 12.22           C  
ATOM    613  O   ARG   120      62.282  22.563  11.516  1.00 12.86           O  
ATOM    614  CB  ARG   120      61.556  25.682  11.559  1.00 12.74           C  
ATOM    615  CG  ARG   120      62.549  25.493  12.702  1.00 12.79           C  
ATOM    616  CD  ARG   120      63.310  26.753  13.031  1.00 13.10           C  
ATOM    617  NE  ARG   120      64.202  26.465  14.160  1.00 13.47           N  
ATOM    618  CZ  ARG   120      65.454  26.866  14.242  1.00 15.05           C  
ATOM    619  NH1 ARG   120      65.999  27.718  13.398  1.00 14.47           N  
ATOM    620  NH2 ARG   120      66.209  26.350  15.235  1.00 15.65           N  
ATOM    621  N   SER   121      62.270  23.436   9.443  1.00 12.31           N  
ATOM    622  CA  SER   121      63.355  22.547   8.998  1.00 12.20           C  
ATOM    623  C   SER   121      64.039  23.157   7.820  1.00 13.11           C  
ATOM    624  O   SER   121      63.457  23.939   7.040  1.00 13.54           O  
ATOM    625  CB  SER   121      62.811  21.192   8.665  1.00 14.12           C  
ATOM    626  OG  SER   121      61.914  21.262   7.562  1.00 16.25           O  
ATOM    627  N   ILE   122      65.314  22.783   7.684  1.00 12.50           N  
ATOM    628  CA  ILE   122      66.106  23.033   6.442  1.00 11.80           C  
ATOM    629  C   ILE   122      66.699  21.707   6.032  1.00 12.02           C  
ATOM    630  O   ILE   122      67.133  20.947   6.878  1.00 13.69           O  
ATOM    631  CB  ILE   122      67.112  24.154   6.580  1.00 12.18           C  
ATOM    632  CG1 ILE   122      67.721  24.407   5.226  1.00 12.82           C  
ATOM    633  CG2 ILE   122      68.164  23.854   7.655  1.00 12.77           C  
ATOM    634  CD1 ILE   122      68.565  25.702   5.218  1.00 16.04           C  
ATOM    635  N   SER   123      66.661  21.447   4.723  0.60 11.08           N  
ATOM    637  CA  SER   123      67.333  20.304   4.128  0.60 12.28           C  
ATOM    639  C   SER   123      68.167  20.698   2.950  0.60 12.38           C  
ATOM    641  O   SER   123      68.085  21.794   2.414  0.60 12.17           O  
ATOM    643  CB  SER   123      66.321  19.227   3.740  0.60 15.33           C  
ATOM    645  OG  SER   123      65.518  19.675   2.648  0.60 16.33           O  
ATOM    647  N   ASN   124      69.033  19.760   2.604  1.00 15.00           N  
ATOM    648  CA  ASN   124      69.796  19.827   1.347  1.00 14.71           C  
ATOM    649  C   ASN   124      70.671  21.060   1.293  1.00 15.43           C  
ATOM    650  O   ASN   124      70.723  21.822   0.313  1.00 17.43           O  
ATOM    651  CB  ASN   124      68.852  19.657   0.123  1.00 15.21           C  
ATOM    652  CG  ASN   124      68.064  18.381   0.210  1.00 17.59           C  
ATOM    653  OD1 ASN   124      66.867  18.392   0.460  1.00 26.01           O  
ATOM    654  ND2 ASN   124      68.731  17.268  -0.016  1.00 22.75           N  
ATOM    655  N   PHE   125      71.432  21.256   2.366  1.00 17.20           N  
ATOM    656  CA  PHE   125      72.420  22.296   2.500  1.00 15.68           C  
ATOM    657  C   PHE   125      73.675  21.819   3.254  1.00 16.94           C  
ATOM    658  O   PHE   125      73.589  21.070   4.188  1.00 16.88           O  
ATOM    659  CB  PHE   125      71.803  23.489   3.273  1.00 15.68           C  
ATOM    660  CG  PHE   125      72.798  24.551   3.554  1.00 16.09           C  
ATOM    661  CD1 PHE   125      73.065  25.525   2.610  1.00 19.18           C  
ATOM    662  CD2 PHE   125      73.597  24.506   4.687  1.00 18.90           C  
ATOM    663  CE1 PHE   125      74.063  26.444   2.813  1.00 18.90           C  
ATOM    664  CE2 PHE   125      74.579  25.443   4.905  1.00 19.57           C  
ATOM    665  CZ  PHE   125      74.842  26.409   3.941  1.00 14.71           C  
ATOM    666  N   SER   126      74.843  22.252   2.789  0.25 17.09           N  
ATOM    669  CA  SER   126      76.099  22.060   3.524  0.25 17.21           C  
ATOM    672  C   SER   126      76.950  23.329   3.497  0.25 16.95           C  
ATOM    675  O   SER   126      77.049  24.010   2.475  0.25 18.80           O  
ATOM    678  CB  SER   126      76.930  20.912   2.927  0.25 19.72           C  
ATOM    681  OG  SER   126      76.556  19.639   3.437  0.25 15.15           O  
ATOM    684  N   PHE   127      77.550  23.633   4.637  1.00 16.81           N  
ATOM    685  CA  PHE   127      78.572  24.696   4.729  1.00 16.95           C  
ATOM    686  C   PHE   127      79.832  24.234   4.018  1.00 20.45           C  
ATOM    687  O   PHE   127      80.088  23.042   3.844  1.00 20.92           O  
ATOM    688  CB  PHE   127      78.934  25.014   6.157  1.00 18.08           C  
ATOM    689  CG  PHE   127      77.825  25.651   6.972  1.00 18.12           C  
ATOM    690  CD1 PHE   127      77.486  27.000   6.810  1.00 19.82           C  
ATOM    691  CD2 PHE   127      77.205  24.916   8.000  1.00 17.62           C  
ATOM    692  CE1 PHE   127      76.509  27.574   7.621  1.00 19.81           C  
ATOM    693  CE2 PHE   127      76.230  25.491   8.811  1.00 17.77           C  
ATOM    694  CZ  PHE   127      75.877  26.808   8.624  1.00 17.59           C  
ATOM    695  N   SER   128      80.603  25.218   3.565  1.00 20.02           N  
ATOM    696  CA  SER   128      82.009  24.993   3.211  1.00 24.29           C  
ATOM    697  C   SER   128      82.804  25.592   4.329  1.00 21.30           C  
ATOM    698  O   SER   128      82.780  26.795   4.542  1.00 25.76           O  
ATOM    699  CB  SER   128      82.338  25.684   1.911  1.00 26.97           C  
ATOM    700  OG  SER   128      81.669  25.066   0.834  1.00 33.36           O  
ATOM    701  N   ARG   129      83.428  24.734   5.115  1.00 23.44           N  
ATOM    702  CA  ARG   129      84.114  25.169   6.328  1.00 23.21           C  
ATOM    703  C   ARG   129      85.255  24.243   6.687  1.00 26.00           C  
ATOM    704  O   ARG   129      85.364  23.130   6.174  1.00 22.84           O  
ATOM    705  CB  ARG   129      83.166  25.321   7.517  1.00 23.26           C  
ATOM    706  CG  ARG   129      82.427  24.066   7.937  1.00 21.08           C  
ATOM    707  CD  ARG   129      81.495  24.376   9.095  1.00 19.60           C  
ATOM    708  NE  ARG   129      80.497  23.304   9.248  1.00 17.93           N  
ATOM    709  CZ  ARG   129      79.545  23.305  10.165  1.00 17.15           C  
ATOM    710  NH1 ARG   129      79.461  24.238  11.074  1.00 17.66           N  
ATOM    711  NH2 ARG   129      78.663  22.264  10.168  1.00 16.65           N  
ATOM    712  N   GLU   130      86.098  24.746   7.579  1.00 27.23           N  
ATOM    713  CA  GLU   130      87.293  24.006   8.000  1.00 29.49           C  
ATOM    714  C   GLU   130      86.934  22.776   8.809  1.00 29.91           C  
ATOM    715  O   GLU   130      86.000  22.775   9.629  1.00 27.04           O  
ATOM    716  CB  GLU   130      88.279  24.896   8.780  1.00 31.99           C  
ATOM    717  N   ALA   131      87.675  21.716   8.532  1.00 30.50           N  
ATOM    718  CA  ALA   131      87.541  20.447   9.242  1.00 30.07           C  
ATOM    719  C   ALA   131      88.102  20.605  10.648  1.00 30.19           C  
ATOM    720  O   ALA   131      89.320  20.786  10.862  1.00 29.14           O  
ATOM    721  CB  ALA   131      88.236  19.325   8.490  1.00 28.44           C  
ATOM    722  N   LYS   132      87.191  20.571  11.601  1.00 26.84           N  
ATOM    723  CA  LYS   132      87.512  20.788  12.986  1.00 25.67           C  
ATOM    724  C   LYS   132      87.037  19.714  13.934  1.00 26.75           C  
ATOM    725  O   LYS   132      87.589  19.578  15.022  1.00 29.08           O  
ATOM    726  CB  LYS   132      86.998  22.147  13.431  1.00 30.73           C  
ATOM    727  CG  LYS   132      87.599  23.296  12.584  1.00 33.01           C  
ATOM    728  CD  LYS   132      87.768  24.571  13.350  1.00 42.86           C  
ATOM    729  CE  LYS   132      86.491  25.019  13.993  1.00 39.68           C  
ATOM    730  NZ  LYS   132      86.613  26.422  14.504  1.00 50.45           N  
ATOM    731  N   ILE   133      86.004  18.957  13.537  1.00 18.66           N  
ATOM    732  CA  ILE   133      85.415  17.966  14.421  1.00 19.20           C  
ATOM    733  C   ILE   133      86.051  16.612  14.234  1.00 17.90           C  
ATOM    734  O   ILE   133      85.961  16.004  13.184  1.00 18.46           O  
ATOM    735  CB  ILE   133      83.877  17.840  14.209  1.00 16.84           C  
ATOM    736  CG1 ILE   133      83.180  19.188  14.352  1.00 17.39           C  
ATOM    737  CG2 ILE   133      83.306  16.782  15.163  1.00 18.08           C  
ATOM    738  CD1 ILE   133      81.790  19.167  13.674  1.00 17.68           C  
ATOM    739  N   GLY   134      86.655  16.102  15.295  1.00 18.48           N  
ATOM    740  CA  GLY   134      87.239  14.756  15.222  1.00 19.96           C  
ATOM    741  C   GLY   134      86.486  13.706  16.002  1.00 17.19           C  
ATOM    742  O   GLY   134      85.509  13.982  16.742  1.00 16.36           O  
ATOM    743  N   LYS   135      86.929  12.475  15.862  1.00 16.02           N  
ATOM    744  CA  LYS   135      86.331  11.390  16.632  1.00 18.36           C  
ATOM    745  C   LYS   135      86.300  11.654  18.130  1.00 18.09           C  
ATOM    746  O   LYS   135      85.343  11.316  18.828  1.00 16.27           O  
ATOM    747  CB  LYS   135      86.984  10.038  16.308  1.00 23.75           C  
ATOM    748  CG  LYS   135      88.352   9.830  16.894  1.00 21.50           C  
ATOM    749  N   GLU   136      87.297  12.345  18.652  1.00 16.84           N  
ATOM    750  CA  GLU   136      87.317  12.607  20.083  1.00 15.11           C  
ATOM    751  C   GLU   136      86.213  13.574  20.496  1.00 13.93           C  
ATOM    752  O   GLU   136      85.596  13.462  21.566  1.00 16.77           O  
ATOM    753  CB  GLU   136      88.676  13.172  20.529  1.00 15.60           C  
ATOM    754  N   ASP   137      85.954  14.560  19.654  1.00 13.84           N  
ATOM    755  CA  ASP   137      84.887  15.526  19.901  1.00 15.41           C  
ATOM    756  C   ASP   137      83.545  14.769  19.947  1.00 14.86           C  
ATOM    757  O   ASP   137      82.689  15.038  20.772  1.00 15.89           O  
ATOM    758  CB  ASP   137      84.873  16.558  18.802  1.00 14.72           C  
ATOM    759  CG  ASP   137      86.143  17.409  18.789  1.00 21.20           C  
ATOM    760  OD1 ASP   137      86.495  17.942  19.855  1.00 22.43           O  
ATOM    761  OD2 ASP   137      86.809  17.452  17.735  1.00 27.37           O  
ATOM    762  N   TYR   138      83.368  13.871  18.999  1.00 14.17           N  
ATOM    763  CA  TYR   138      82.170  13.011  18.963  1.00 13.48           C  
ATOM    764  C   TYR   138      82.035  12.166  20.212  1.00 14.10           C  
ATOM    765  O   TYR   138      80.942  12.045  20.811  1.00 14.45           O  
ATOM    766  CB  TYR   138      82.127  12.193  17.682  1.00 14.65           C  
ATOM    767  CG  TYR   138      80.933  11.255  17.587  1.00 13.08           C  
ATOM    768  CD1 TYR   138      79.714  11.733  17.126  1.00 13.22           C  
ATOM    769  CD2 TYR   138      81.022   9.946  18.009  1.00 15.26           C  
ATOM    770  CE1 TYR   138      78.619  10.886  17.056  1.00 13.55           C  
ATOM    771  CE2 TYR   138      79.936   9.077  17.947  1.00 14.75           C  
ATOM    772  CZ  TYR   138      78.733   9.576  17.471  1.00 17.42           C  
ATOM    773  OH  TYR   138      77.657   8.693  17.411  1.00 17.95           O  
ATOM    774  N   ASP   139      83.137  11.574  20.635  1.00 12.27           N  
ATOM    775  CA  ASP   139      83.122  10.623  21.765  1.00 14.62           C  
ATOM    776  C   ASP   139      82.751  11.366  23.031  1.00 14.48           C  
ATOM    777  O   ASP   139      82.144  10.799  23.953  1.00 20.06           O  
ATOM    778  CB  ASP   139      84.483   9.923  21.942  1.00 17.98           C  
ATOM    779  CG  ASP   139      84.789   8.947  20.833  1.00 23.25           C  
ATOM    780  OD1 ASP   139      83.891   8.567  20.043  1.00 19.63           O  
ATOM    781  OD2 ASP   139      85.983   8.559  20.720  1.00 22.58           O  
ATOM    782  N   GLU   140      83.137  12.629  23.071  0.50 15.80           N  
ATOM    784  CA  GLU   140      82.920  13.472  24.257  0.50 18.24           C  
ATOM    786  C   GLU   140      81.457  13.887  24.461  0.50 17.54           C  
ATOM    788  O   GLU   140      81.070  14.288  25.549  0.50 21.31           O  
ATOM    790  CB  GLU   140      83.746  14.754  24.189  0.50 19.28           C  
ATOM    792  CG  GLU   140      85.239  14.663  24.452  0.50 23.20           C  
ATOM    794  CD  GLU   140      85.889  16.021  24.173  0.50 29.65           C  
ATOM    796  OE1 GLU   140      85.760  16.923  25.030  0.50 29.59           O  
ATOM    798  OE2 GLU   140      86.452  16.211  23.070  0.50 27.07           O  
ATOM    800  N   LEU   141      80.642  13.782  23.405  1.00 16.18           N  
ATOM    801  CA  LEU   141      79.234  14.213  23.469  1.00 14.09           C  
ATOM    802  C   LEU   141      78.543  13.239  24.401  1.00 17.53           C  
ATOM    803  O   LEU   141      78.637  12.022  24.219  1.00 19.46           O  
ATOM    804  CB  LEU   141      78.586  14.091  22.088  1.00 13.41           C  
ATOM    805  CG  LEU   141      79.170  15.011  21.046  1.00 12.04           C  
ATOM    806  CD1 LEU   141      78.607  14.678  19.644  1.00 15.14           C  
ATOM    807  CD2 LEU   141      78.993  16.516  21.354  1.00 16.55           C  
ATOM    808  N   LYS   142      77.813  13.775  25.381  1.00 15.57           N  
ATOM    809  CA  LYS   142      77.147  12.970  26.384  1.00 16.22           C  
ATOM    810  C   LYS   142      75.645  13.195  26.395  1.00 13.47           C  
ATOM    811  O   LYS   142      75.157  14.298  26.191  1.00 14.74           O  
ATOM    812  CB  LYS   142      77.683  13.331  27.765  1.00 19.18           C  
ATOM    813  CG  LYS   142      79.199  13.084  27.925  1.00 23.95           C  
ATOM    814  N   ILE   143      74.932  12.102  26.601  1.00 16.11           N  
ATOM    815  CA  ILE   143      73.485  12.157  26.809  1.00 15.64           C  
ATOM    816  C   ILE   143      73.196  13.123  27.967  1.00 15.05           C  
ATOM    817  O   ILE   143      73.821  13.055  29.036  1.00 16.60           O  
ATOM    818  CB  ILE   143      72.881  10.768  27.089  1.00 19.70           C  
ATOM    819  CG1 ILE   143      73.151   9.792  25.932  1.00 22.83           C  
ATOM    820  CG2 ILE   143      71.385  10.900  27.390  1.00 19.55           C  
ATOM    821  CD1 ILE   143      73.022  10.401  24.589  1.00 27.21           C  
ATOM    822  N   GLY   144      72.294  14.070  27.718  1.00 13.42           N  
ATOM    823  CA  GLY   144      71.924  15.114  28.657  1.00 14.19           C  
ATOM    824  C   GLY   144      72.643  16.423  28.434  1.00 15.81           C  
ATOM    825  O   GLY   144      72.354  17.452  29.078  1.00 17.76           O  
ATOM    826  N   GLU   145      73.639  16.407  27.550  1.00 15.19           N  
ATOM    827  CA  GLU   145      74.394  17.626  27.241  1.00 14.46           C  
ATOM    828  C   GLU   145      73.502  18.602  26.423  1.00 15.99           C  
ATOM    829  O   GLU   145      72.705  18.208  25.553  1.00 15.08           O  
ATOM    830  CB  GLU   145      75.675  17.283  26.468  1.00 16.14           C  
ATOM    831  CG  GLU   145      76.535  18.463  26.121  1.00 16.14           C  
ATOM    832  CD  GLU   145      77.835  18.063  25.468  1.00 18.79           C  
ATOM    833  OE1 GLU   145      78.007  16.840  25.263  1.00 17.34           O  
ATOM    834  OE2 GLU   145      78.692  18.932  25.156  1.00 18.41           O  
ATOM    835  N   SER   146      73.589  19.916  26.674  1.00 15.39           N  
ATOM    836  CA  SER   146      72.727  20.853  25.997  1.00 16.32           C  
ATOM    837  C   SER   146      73.101  21.102  24.543  1.00 16.47           C  
ATOM    838  O   SER   146      74.275  21.088  24.173  1.00 14.49           O  
ATOM    839  CB  SER   146      72.670  22.199  26.766  1.00 16.97           C  
ATOM    840  OG  SER   146      73.874  22.908  26.620  1.00 19.56           O  
ATOM    841  N   TYR   147      72.078  21.293  23.750  1.00 16.27           N  
ATOM    842  CA  TYR   147      72.267  21.748  22.375  1.00 16.16           C  
ATOM    843  C   TYR   147      73.118  22.995  22.339  1.00 19.01           C  
ATOM    844  O   TYR   147      74.017  23.115  21.513  1.00 15.64           O  
ATOM    845  CB  TYR   147      70.925  21.988  21.705  1.00 17.72           C  
ATOM    846  CG  TYR   147      71.030  22.531  20.289  1.00 17.46           C  
ATOM    847  CD1 TYR   147      71.723  21.805  19.332  1.00 16.27           C  
ATOM    848  CD2 TYR   147      70.506  23.737  19.928  1.00 22.06           C  
ATOM    849  CE1 TYR   147      71.842  22.241  18.025  1.00 16.81           C  
ATOM    850  CE2 TYR   147      70.628  24.184  18.613  1.00 19.47           C  
ATOM    851  CZ  TYR   147      71.300  23.423  17.673  1.00 19.80           C  
ATOM    852  OH  TYR   147      71.465  23.842  16.361  1.00 21.86           O  
ATOM    853  N   LYS   148      72.863  23.952  23.242  1.00 17.71           N  
ATOM    854  CA  LYS   148      73.657  25.159  23.229  1.00 19.22           C  
ATOM    855  C   LYS   148      75.156  24.871  23.373  1.00 17.21           C  
ATOM    856  O   LYS   148      75.983  25.464  22.666  1.00 18.18           O  
ATOM    857  CB  LYS   148      73.176  26.137  24.331  1.00 23.44           C  
ATOM    858  CG  LYS   148      73.867  27.495  24.299  1.00 29.63           C  
ATOM    859  N   LYS   149      75.521  24.009  24.315  1.00 17.24           N  
ATOM    860  CA  LYS   149      76.929  23.681  24.560  1.00 16.39           C  
ATOM    861  C   LYS   149      77.546  22.988  23.321  1.00 16.10           C  
ATOM    862  O   LYS   149      78.683  23.258  22.906  1.00 17.64           O  
ATOM    863  CB  LYS   149      77.124  22.811  25.792  1.00 18.33           C  
ATOM    864  CG  LYS   149      78.547  22.441  26.070  1.00 21.30           C  
ATOM    865  CD  LYS   149      78.648  21.746  27.402  1.00 21.89           C  
ATOM    866  CE  LYS   149      80.032  21.165  27.587  1.00 27.39           C  
ATOM    867  NZ  LYS   149      80.181  20.596  28.965  1.00 29.82           N  
ATOM    868  N   VAL   150      76.740  22.112  22.720  1.00 15.45           N  
ATOM    869  CA  VAL   150      77.226  21.349  21.583  1.00 15.79           C  
ATOM    870  C   VAL   150      77.443  22.240  20.381  1.00 13.71           C  
ATOM    871  O   VAL   150      78.423  22.102  19.657  1.00 14.53           O  
ATOM    872  CB  VAL   150      76.267  20.156  21.287  1.00 12.96           C  
ATOM    873  CG1 VAL   150      76.472  19.160  22.387  1.00 13.07           C  
ATOM    874  CG2 VAL   150      76.543  19.530  19.870  1.00 15.19           C  
ATOM    876  N   VAL   151      76.584  23.203  20.166  1.00 15.97           N  
ATOM    877  CA  VAL   151      76.850  24.127  19.062  1.00 16.39           C  
ATOM    878  C   VAL   151      78.120  24.993  19.308  1.00 20.15           C  
ATOM    879  O   VAL   151      78.866  25.324  18.378  1.00 19.48           O  
ATOM    880  CB  VAL   151      75.668  25.052  18.801  1.00 17.19           C  
ATOM    881  CG1 VAL   151      76.025  26.188  17.815  1.00 18.46           C  
ATOM    882  CG2 VAL   151      74.492  24.217  18.273  1.00 16.12           C  
ATOM    883  N   GLU   152      78.391  25.287  20.568  1.00 19.19           N  
ATOM    884  CA  GLU   152      79.616  26.025  20.898  1.00 22.89           C  
ATOM    885  C   GLU   152      80.834  25.190  20.548  1.00 21.76           C  
ATOM    886  O   GLU   152      81.863  25.705  20.128  1.00 28.29           O  
ATOM    887  CB  GLU   152      79.652  26.416  22.380  1.00 23.01           C  
ATOM    888  CG  GLU   152      78.653  27.499  22.698  1.00 27.18           C  
ATOM    889  CD  GLU   152      78.523  27.774  24.196  1.00 37.19           C  
ATOM    890  OE1 GLU   152      79.226  27.117  24.991  1.00 39.26           O  
ATOM    891  OE2 GLU   152      77.707  28.641  24.559  1.00 40.42           O  
ATOM    892  N   LYS   153      80.728  23.894  20.773  1.00 18.30           N  
ATOM    893  CA  LYS   153      81.828  22.950  20.512  1.00 18.55           C  
ATOM    894  C   LYS   153      81.970  22.559  19.037  1.00 21.20           C  
ATOM    895  O   LYS   153      83.093  22.441  18.512  1.00 22.54           O  
ATOM    896  CB  LYS   153      81.658  21.657  21.340  1.00 22.15           C  
ATOM    897  CG  LYS   153      81.770  21.830  22.859  1.00 28.00           C  
ATOM    898  N   LEU   154      80.852  22.329  18.346  1.00 16.62           N  
ATOM    899  CA  LEU   154      80.923  21.748  17.007  1.00 15.82           C  
ATOM    900  C   LEU   154      80.644  22.741  15.908  1.00 15.20           C  
ATOM    901  O   LEU   154      80.814  22.417  14.724  1.00 18.19           O  
ATOM    902  CB  LEU   154      79.935  20.572  16.807  1.00 15.70           C  
ATOM    903  CG  LEU   154      79.974  19.462  17.842  1.00 17.15           C  
ATOM    904  CD1 LEU   154      78.996  18.309  17.463  1.00 18.12           C  
ATOM    905  CD2 LEU   154      81.434  18.967  18.025  1.00 17.27           C  
ATOM    906  N   GLY   155      80.179  23.920  16.294  1.00 16.08           N  
ATOM    907  CA  GLY   155      79.628  24.866  15.329  1.00 16.49           C  
ATOM    908  C   GLY   155      78.206  24.442  14.935  1.00 16.66           C  
ATOM    909  O   GLY   155      77.677  23.432  15.409  1.00 17.10           O  
ATOM    910  N   GLU   156      77.554  25.285  14.162  1.00 16.01           N  
ATOM    911  CA  GLU   156      76.165  25.029  13.785  1.00 16.77           C  
ATOM    912  C   GLU   156      76.085  23.794  12.913  1.00 14.78           C  
ATOM    913  O   GLU   156      76.944  23.520  12.079  1.00 16.26           O  
ATOM    914  CB  GLU   156      75.585  26.225  13.003  1.00 17.64           C  
ATOM    915  CG  GLU   156      75.323  27.447  13.828  1.00 21.86           C  
ATOM    916  CD  GLU   156      74.714  28.603  13.012  1.00 23.91           C  
ATOM    917  OE1 GLU   156      74.268  28.396  11.869  1.00 23.27           O  
ATOM    918  OE2 GLU   156      74.690  29.732  13.551  1.00 38.11           O  
ATOM    919  N   PRO   157      75.016  22.974  13.119  1.00 14.94           N  
ATOM    920  CA  PRO   157      74.805  21.828  12.220  1.00 14.86           C  
ATOM    921  C   PRO   157      74.505  22.357  10.810  1.00 15.29           C  
ATOM    922  O   PRO   157      73.976  23.466  10.630  1.00 15.87           O  
ATOM    923  CB  PRO   157      73.620  21.100  12.833  1.00 15.78           C  
ATOM    924  CG  PRO   157      72.812  22.196  13.433  1.00 15.64           C  
ATOM    925  CD  PRO   157      73.899  23.153  14.055  1.00 14.94           C  
ATOM    926  N   ASP   158      74.840  21.595   9.805  1.00 13.50           N  
ATOM    927  CA  ASP   158      74.518  21.954   8.445  1.00 13.23           C  
ATOM    928  C   ASP   158      72.996  22.081   8.229  1.00 14.66           C  
ATOM    929  O   ASP   158      72.488  23.021   7.600  1.00 15.50           O  
ATOM    930  CB  ASP   158      75.107  20.944   7.446  1.00 15.15           C  
ATOM    931  CG  ASP   158      76.629  20.938   7.464  1.00 18.61           C  
ATOM    932  OD1 ASP   158      77.172  20.319   8.393  1.00 15.52           O  
ATOM    933  OD2 ASP   158      77.222  21.674   6.617  1.00 16.12           O  
ATOM    934  N   VAL   159      72.263  21.063   8.692  1.00 13.88           N  
ATOM    935  CA  VAL   159      70.786  21.060   8.583  1.00 12.92           C  
ATOM    936  C   VAL   159      70.195  20.656   9.902  1.00 13.51           C  
ATOM    937  O   VAL   159      70.848  20.023  10.754  1.00 12.86           O  
ATOM    938  CB  VAL   159      70.257  20.172   7.448  1.00 15.39           C  
ATOM    939  CG1 VAL   159      70.710  20.683   6.056  1.00 16.09           C  
ATOM    940  CG2 VAL   159      70.688  18.771   7.639  1.00 15.13           C  
ATOM    941  N   LEU   160      68.937  21.055  10.100  1.00 13.38           N  
ATOM    942  CA  LEU   160      68.204  20.647  11.299  1.00 13.51           C  
ATOM    943  C   LEU   160      66.718  20.753  11.052  1.00 12.49           C  
ATOM    944  O   LEU   160      66.248  21.423  10.131  1.00 14.00           O  
ATOM    945  CB  LEU   160      68.610  21.470  12.513  1.00 15.50           C  
ATOM    946  CG  LEU   160      68.118  22.912  12.608  1.00 15.27           C  
ATOM    947  CD1 LEU   160      66.692  23.063  13.185  1.00 17.15           C  
ATOM    948  CD2 LEU   160      69.061  23.773  13.473  1.00 18.15           C  
ATOM    949  N   SER   161      65.969  20.042  11.876  0.60 13.15           N  
ATOM    951  CA  SER   161      64.504  20.062  11.940  0.60 13.72           C  
ATOM    953  C   SER   161      64.080  20.112  13.404  0.60 11.84           C  
ATOM    955  O   SER   161      64.595  19.311  14.202  0.60 13.22           O  
ATOM    957  CB  SER   161      63.927  18.818  11.309  0.60 16.10           C  
ATOM    959  OG  SER   161      62.509  18.756  11.462  0.60 18.89           O  
ATOM    961  N   GLN   162      63.160  21.029  13.752  1.00 12.91           N  
ATOM    962  CA  GLN   162      62.788  21.326  15.150  1.00 12.68           C  
ATOM    963  C   GLN   162      61.303  21.449  15.260  1.00 13.15           C  
ATOM    964  O   GLN   162      60.694  22.077  14.368  1.00 14.59           O  
ATOM    965  CB  GLN   162      63.423  22.601  15.608  1.00 12.70           C  
ATOM    966  CG  GLN   162      63.140  22.962  17.093  1.00 14.00           C  
ATOM    967  CD  GLN   162      63.765  24.224  17.537  1.00 13.52           C  
ATOM    968  OE1 GLN   162      63.971  25.147  16.735  1.00 14.92           O  
ATOM    969  NE2 GLN   162      64.057  24.322  18.855  1.00 17.47           N  
ATOM    970  N   SER   163      60.688  20.830  16.248  1.00 14.48           N  
ATOM    971  CA  SER   163      59.225  21.024  16.417  1.00 15.88           C  
ATOM    972  C   SER   163      58.890  21.004  17.878  1.00 17.30           C  
ATOM    973  O   SER   163      59.679  20.533  18.716  1.00 17.81           O  
ATOM    974  CB  SER   163      58.434  19.935  15.744  1.00 18.13           C  
ATOM    975  OG  SER   163      58.751  18.647  16.281  1.00 26.25           O  
ATOM    976  N   MET   164      57.719  21.500  18.213  1.00 16.23           N  
ATOM    977  CA  MET   164      57.275  21.397  19.574  1.00 18.30           C  
ATOM    978  C   MET   164      55.825  21.104  19.677  1.00 18.93           C  
ATOM    979  O   MET   164      55.042  21.359  18.757  1.00 18.43           O  
ATOM    980  CB  MET   164      57.544  22.673  20.249  1.00 18.17           C  
ATOM    981  CG  MET   164      56.811  23.873  19.800  1.00 16.05           C  
ATOM    982  SD  MET   164      54.962  23.997  20.482  0.75 18.24          SE  
ATOM    983  CE  MET   164      55.421  24.707  22.226  1.00 20.85           C  
ATOM    984  N   SER   165      55.516  20.578  20.844  1.00 17.55           N  
ATOM    985  CA  SER   165      54.152  20.442  21.305  1.00 17.57           C  
ATOM    986  C   SER   165      54.087  20.923  22.730  1.00 15.84           C  
ATOM    987  O   SER   165      55.047  21.372  23.327  1.00 17.41           O  
ATOM    988  CB  SER   165      53.732  18.984  21.279  1.00 22.40           C  
ATOM    989  OG  SER   165      54.412  18.274  22.319  1.00 25.08           O  
ATOM    990  N   SER   166      52.883  20.835  23.288  1.00 16.56           N  
ATOM    991  CA  SER   166      52.705  21.265  24.656  1.00 17.45           C  
ATOM    992  C   SER   166      53.488  20.439  25.624  1.00 18.54           C  
ATOM    993  O   SER   166      53.759  20.876  26.733  1.00 19.55           O  
ATOM    994  CB  SER   166      51.229  21.271  25.019  1.00 18.34           C  
ATOM    995  OG  SER   166      50.781  19.929  25.063  1.00 26.50           O  
ATOM    996  N   ASP   167      53.867  19.249  25.191  0.50 20.37           N  
ATOM    998  CA  ASP   167      54.535  18.279  26.046  0.50 20.54           C  
ATOM   1000  C   ASP   167      56.051  18.322  25.922  0.50 17.52           C  
ATOM   1002  O   ASP   167      56.778  18.375  26.935  0.50 16.32           O  
ATOM   1004  CB  ASP   167      54.033  16.862  25.708  0.50 21.99           C  
ATOM   1006  CG  ASP   167      52.536  16.693  25.988  0.50 31.89           C  
ATOM   1008  OD1 ASP   167      52.099  17.008  27.115  0.50 36.67           O  
ATOM   1010  OD2 ASP   167      51.790  16.271  25.073  0.50 39.09           O  
ATOM   1012  N   LYS   168      56.524  18.286  24.668  0.50 16.41           N  
ATOM   1014  CA  LYS   168      57.956  18.195  24.415  0.50 17.82           C  
ATOM   1016  C   LYS   168      58.389  18.952  23.161  0.50 16.03           C  
ATOM   1018  O   LYS   168      57.631  19.183  22.229  0.50 17.87           O  
ATOM   1020  CB  LYS   168      58.393  16.730  24.255  0.50 17.76           C  
ATOM   1022  CG  LYS   168      57.928  16.095  22.940  0.50 21.37           C  
ATOM   1024  CD  LYS   168      58.329  14.611  22.823  0.50 28.42           C  
ATOM   1026  N   GLU   169      59.674  19.271  23.173  1.00 16.32           N  
ATOM   1027  CA  GLU   169      60.368  19.838  22.004  1.00 15.40           C  
ATOM   1028  C   GLU   169      61.345  18.810  21.503  1.00 14.30           C  
ATOM   1029  O   GLU   169      61.920  18.047  22.288  1.00 16.32           O  
ATOM   1030  CB  GLU   169      61.105  21.079  22.351  1.00 16.33           C  
ATOM   1031  CG  GLU   169      61.947  21.668  21.188  1.00 21.29           C  
ATOM   1032  CD  GLU   169      63.407  21.259  21.173  1.00 24.02           C  
ATOM   1033  OE1 GLU   169      63.852  20.464  22.042  1.00 23.54           O  
ATOM   1034  OE2 GLU   169      64.205  21.669  20.282  1.00 22.69           O  
ATOM   1035  N   GLU   170      61.500  18.741  20.196  0.50 15.79           N  
ATOM   1037  CA  GLU   170      62.519  17.899  19.622  0.50 17.72           C  
ATOM   1039  C   GLU   170      63.253  18.596  18.523  0.50 16.23           C  
ATOM   1041  O   GLU   170      62.853  19.632  17.955  0.50 12.15           O  
ATOM   1043  CB  GLU   170      61.999  16.523  19.163  0.50 23.31           C  
ATOM   1045  CG  GLU   170      60.820  16.480  18.218  0.50 29.10           C  
ATOM   1047  CD  GLU   170      60.143  15.106  18.236  0.50 32.32           C  
ATOM   1049  OE1 GLU   170      59.504  14.777  19.255  0.50 35.52           O  
ATOM   1051  OE2 GLU   170      60.291  14.342  17.259  0.50 39.84           O  
ATOM   1053  N   MET   171      64.404  18.009  18.266  1.00 13.44           N  
ATOM   1054  CA  MET   171      65.269  18.548  17.231  1.00 12.62           C  
ATOM   1055  C   MET   171      66.163  17.496  16.701  1.00 11.87           C  
ATOM   1056  O   MET   171      66.823  16.797  17.482  1.00 13.16           O  
ATOM   1057  CB  MET   171      66.070  19.754  17.721  1.00 14.10           C  
ATOM   1058  CG  MET   171      67.010  20.301  16.675  1.00 14.61           C  
ATOM   1059  SD  MET   171      68.269  21.655  17.406  0.75 14.33          SE  
ATOM   1060  CE  MET   171      67.118  23.177  17.456  1.00 18.01           C  
ATOM   1061  N   GLN   172      66.265  17.391  15.379  1.00 12.24           N  
ATOM   1062  CA  GLN   172      67.253  16.521  14.739  1.00 13.11           C  
ATOM   1063  C   GLN   172      68.228  17.395  14.002  1.00 13.85           C  
ATOM   1064  O   GLN   172      67.835  18.394  13.387  1.00 13.88           O  
ATOM   1065  CB  GLN   172      66.582  15.560  13.778  1.00 15.17           C  
ATOM   1066  CG  GLN   172      65.612  14.630  14.464  1.00 18.83           C  
ATOM   1067  CD  GLN   172      64.291  15.267  14.584  1.00 26.07           C  
ATOM   1068  OE1 GLN   172      63.802  15.866  13.593  1.00 30.42           O  
ATOM   1069  NE2 GLN   172      63.653  15.162  15.766  1.00 33.42           N  
ATOM   1070  N   THR   173      69.522  17.084  14.096  1.00 13.45           N  
ATOM   1071  CA  THR   173      70.598  17.902  13.554  1.00 14.10           C  
ATOM   1072  C   THR   173      71.562  17.003  12.763  1.00 16.32           C  
ATOM   1073  O   THR   173      71.755  15.824  13.165  1.00 17.30           O  
ATOM   1074  CB  THR   173      71.378  18.590  14.659  1.00 13.74           C  
ATOM   1075  OG1 THR   173      71.882  17.555  15.566  1.00 16.53           O  
ATOM   1076  CG2 THR   173      70.501  19.540  15.360  1.00 14.87           C  
ATOM   1077  N   VAL   174      72.145  17.537  11.696  1.00 12.69           N  
ATOM   1078  CA  VAL   174      73.182  16.806  10.931  1.00 12.75           C  
ATOM   1079  C   VAL   174      74.331  17.716  10.690  1.00 13.90           C  
ATOM   1080  O   VAL   174      74.163  18.803  10.204  1.00 13.82           O  
ATOM   1081  CB  VAL   174      72.666  16.304   9.584  1.00 13.10           C  
ATOM   1082  CG1 VAL   174      73.775  15.528   8.825  1.00 15.08           C  
ATOM   1083  CG2 VAL   174      71.496  15.353   9.786  1.00 16.21           C  
ATOM   1084  N   TRP   175      75.521  17.215  10.989  1.00 13.60           N  
ATOM   1085  CA  TRP   175      76.780  17.820  10.537  1.00 13.73           C  
ATOM   1086  C   TRP   175      77.278  16.971   9.384  1.00 13.88           C  
ATOM   1087  O   TRP   175      77.580  15.770   9.592  1.00 15.77           O  
ATOM   1088  CB  TRP   175      77.831  17.879  11.682  1.00 15.15           C  
ATOM   1089  CG  TRP   175      77.627  18.928  12.678  1.00 15.18           C  
ATOM   1090  CD1 TRP   175      78.346  20.095  12.772  1.00 16.99           C  
ATOM   1091  CD2 TRP   175      76.684  18.949  13.767  1.00 13.29           C  
ATOM   1092  NE1 TRP   175      77.879  20.837  13.818  1.00 16.32           N  
ATOM   1093  CE2 TRP   175      76.887  20.150  14.469  1.00 14.08           C  
ATOM   1094  CE3 TRP   175      75.704  18.066  14.235  1.00 13.73           C  
ATOM   1095  CZ2 TRP   175      76.106  20.519  15.573  1.00 15.00           C  
ATOM   1096  CZ3 TRP   175      74.963  18.432  15.350  1.00 15.04           C  
ATOM   1097  CH2 TRP   175      75.168  19.659  16.013  1.00 13.79           C  
ATOM   1098  N   SER   176      77.338  17.548   8.193  1.00 14.94           N  
ATOM   1099  CA  SER   176      77.849  16.905   7.004  1.00 17.68           C  
ATOM   1100  C   SER   176      79.113  17.598   6.491  1.00 18.66           C  
ATOM   1101  O   SER   176      79.683  17.159   5.503  1.00 20.46           O  
ATOM   1102  CB  SER   176      76.800  16.917   5.920  1.00 18.26           C  
ATOM   1103  OG  SER   176      76.403  18.256   5.683  1.00 20.40           O  
ATOM   1104  N   SER   177      79.498  18.663   7.163  1.00 16.71           N  
ATOM   1105  CA  SER   177      80.763  19.405   6.935  1.00 17.93           C  
ATOM   1106  C   SER   177      81.414  19.756   8.266  1.00 18.54           C  
ATOM   1107  O   SER   177      80.804  19.649   9.330  1.00 19.06           O  
ATOM   1108  CB  SER   177      80.502  20.687   6.165  1.00 18.24           C  
ATOM   1109  OG  SER   177      79.813  21.654   6.965  1.00 17.90           O  
ATOM   1110  N   GLY   178      82.699  20.146   8.210  1.00 17.57           N  
ATOM   1111  CA  GLY   178      83.415  20.573   9.406  1.00 18.77           C  
ATOM   1112  C   GLY   178      84.052  19.436  10.167  1.00 19.02           C  
ATOM   1113  O   GLY   178      84.543  19.604  11.276  1.00 18.92           O  
ATOM   1114  N   ILE   179      83.980  18.262   9.569  1.00 16.99           N  
ATOM   1115  CA  ILE   179      84.502  16.997  10.172  1.00 16.88           C  
ATOM   1116  C   ILE   179      85.898  16.628   9.650  1.00 19.73           C  
ATOM   1117  O   ILE   179      86.147  16.647   8.452  1.00 20.94           O  
ATOM   1118  CB  ILE   179      83.517  15.819   9.960  1.00 19.26           C  
ATOM   1119  CG1 ILE   179      82.135  16.166  10.531  1.00 17.11           C  
ATOM   1120  CG2 ILE   179      84.024  14.561  10.614  1.00 18.70           C  
ATOM   1121  CD1 ILE   179      81.056  15.168  10.189  1.00 18.80           C  
ATOM   1122  N   LYS   180      86.786  16.351  10.590  1.00 19.39           N  
ATOM   1123  CA  LYS   180      88.177  16.030  10.267  1.00 21.87           C  
ATOM   1124  C   LYS   180      88.275  14.563  10.318  1.00 22.31           C  
ATOM   1125  O   LYS   180      88.354  14.010  11.398  1.00 26.45           O  
ATOM   1126  CB  LYS   180      89.152  16.596  11.322  1.00 27.48           C  
ATOM   1127  N   THR   181      88.254  13.915   9.165  1.00 22.39           N  
ATOM   1128  CA  THR   181      88.485  12.475   9.132  1.00 27.54           C  
ATOM   1129  C   THR   181      88.901  11.971   7.758  1.00 30.11           C  
ATOM   1130  O   THR   181      88.877  12.710   6.765  1.00 34.74           O  
ATOM   1131  CB  THR   181      87.251  11.695   9.624  1.00 31.61           C  
ATOM   1132  OG1 THR   181      87.620  10.331   9.930  1.00 32.78           O  
ATOM   1133  CG2 THR   181      86.132  11.736   8.568  1.00 29.78           C  
ATOM   1134  N   LYS   182      89.257  10.692   7.716  1.00 29.45           N  
ATOM   1135  CA  LYS   182      89.797  10.109   6.489  1.00 30.82           C  
ATOM   1136  C   LYS   182      88.760  10.270   5.380  1.00 32.08           C  
ATOM   1137  O   LYS   182      89.072  10.750   4.287  1.00 33.98           O  
ATOM   1138  CB  LYS   182      90.227   8.641   6.672  1.00 31.78           C  
ATOM   1139  N   SER   183      87.520   9.905   5.692  1.00 31.83           N  
ATOM   1140  CA  SER   183      86.439   9.883   4.690  1.00 32.47           C  
ATOM   1141  C   SER   183      85.757  11.212   4.517  1.00 34.80           C  
ATOM   1142  O   SER   183      85.365  11.899   5.485  1.00 33.71           O  
ATOM   1143  CB  SER   183      85.374   8.812   4.994  1.00 33.04           C  
ATOM   1144  OG  SER   183      84.150   9.132   4.343  1.00 36.53           O  
ATOM   1145  N   SER   184      85.583  11.530   3.247  1.00 34.75           N  
ATOM   1146  CA  SER   184      85.000  12.790   2.809  1.00 34.35           C  
ATOM   1147  C   SER   184      83.509  12.795   3.078  1.00 34.30           C  
ATOM   1148  O   SER   184      82.872  13.855   3.121  1.00 37.93           O  
ATOM   1149  CB  SER   184      85.260  13.003   1.300  1.00 34.66           C  
ATOM   1150  N   SER   185      82.968  11.596   3.276  1.00 32.52           N  
ATOM   1151  CA  SER   185      81.514  11.406   3.275  1.00 27.51           C  
ATOM   1152  C   SER   185      80.919  11.380   4.693  1.00 24.93           C  
ATOM   1153  O   SER   185      79.761  11.146   4.904  1.00 24.12           O  
ATOM   1154  CB  SER   185      81.170  10.108   2.517  1.00 30.94           C  
ATOM   1155  N   ALA   186      81.764  11.636   5.665  1.00 23.25           N  
ATOM   1156  CA  ALA   186      81.373  11.491   7.068  1.00 18.32           C  
ATOM   1157  C   ALA   186      80.246  12.434   7.479  1.00 18.02           C  
ATOM   1158  O   ALA   186      80.155  13.577   7.019  1.00 20.32           O  
ATOM   1159  CB  ALA   186      82.583  11.714   7.962  1.00 18.13           C  
ATOM   1160  N   THR   187      79.397  11.936   8.357  1.00 15.46           N  
ATOM   1161  CA  THR   187      78.337  12.743   8.990  1.00 17.07           C  
ATOM   1162  C   THR   187      78.164  12.401  10.450  1.00 14.23           C  
ATOM   1163  O   THR   187      78.517  11.315  10.906  1.00 14.24           O  
ATOM   1164  CB  THR   187      76.993  12.573   8.253  1.00 19.95           C  
ATOM   1165  OG1 THR   187      76.506  11.237   8.441  1.00 24.49           O  
ATOM   1166  CG2 THR   187      77.151  12.822   6.777  1.00 23.75           C  
ATOM   1167  N   ILE   188      77.621  13.339  11.215  1.00 13.98           N  
ATOM   1168  CA  ILE   188      77.210  13.155  12.589  1.00 12.95           C  
ATOM   1169  C   ILE   188      75.750  13.630  12.686  1.00 13.66           C  
ATOM   1170  O   ILE   188      75.395  14.703  12.185  1.00 15.20           O  
ATOM   1171  CB  ILE   188      78.033  14.040  13.548  1.00 14.97           C  
ATOM   1172  CG1 ILE   188      79.482  13.563  13.586  1.00 13.87           C  
ATOM   1173  CG2 ILE   188      77.449  14.021  14.987  1.00 17.70           C  
ATOM   1174  CD1 ILE   188      80.428  14.552  14.274  1.00 17.01           C  
ATOM   1175  N   GLU   189      74.883  12.785  13.234  0.60 13.17           N  
ATOM   1177  CA  GLU   189      73.496  13.151  13.490  0.60 12.94           C  
ATOM   1179  C   GLU   189      73.205  13.028  14.977  0.60 12.96           C  
ATOM   1181  O   GLU   189      73.501  12.007  15.634  0.60 13.62           O  
ATOM   1183  CB  GLU   189      72.474  12.335  12.645  0.60 15.37           C  
ATOM   1185  CG  GLU   189      71.017  12.857  12.829  0.60 17.94           C  
ATOM   1187  CD  GLU   189      69.975  12.500  11.735  0.60 23.55           C  
ATOM   1189  OE1 GLU   189      70.250  11.765  10.777  0.60 22.90           O  
ATOM   1191  OE2 GLU   189      68.832  12.992  11.873  0.60 26.30           O  
ATOM   1193  N   LEU   190      72.671  14.122  15.511  1.00 12.41           N  
ATOM   1194  CA  LEU   190      72.334  14.220  16.930  1.00 11.34           C  
ATOM   1195  C   LEU   190      70.846  14.527  17.087  1.00 12.10           C  
ATOM   1196  O   LEU   190      70.273  15.359  16.367  1.00 14.20           O  
ATOM   1197  CB  LEU   190      73.146  15.321  17.624  1.00 12.94           C  
ATOM   1198  CG  LEU   190      74.658  15.305  17.480  1.00 11.70           C  
ATOM   1199  CD1 LEU   190      75.307  16.468  18.294  1.00 13.99           C  
ATOM   1200  CD2 LEU   190      75.226  13.911  17.913  1.00 13.17           C  
ATOM   1201  N   TYR   191      70.211  13.794  17.978  0.50 12.11           N  
ATOM   1203  CA  TYR   191      68.809  14.003  18.343  0.50 11.89           C  
ATOM   1205  C   TYR   191      68.768  14.642  19.707  0.50 11.15           C  
ATOM   1207  O   TYR   191      69.462  14.240  20.653  0.50 11.69           O  
ATOM   1209  CB  TYR   191      67.997  12.698  18.305  0.50 12.66           C  
ATOM   1211  CG  TYR   191      66.543  12.870  18.696  0.50 16.85           C  
ATOM   1213  CD1 TYR   191      65.744  13.843  18.071  0.50 17.67           C  
ATOM   1215  CD2 TYR   191      65.963  12.064  19.647  0.50 20.93           C  
ATOM   1217  CE1 TYR   191      64.493  14.033  18.415  0.50 14.53           C  
ATOM   1219  CE2 TYR   191      64.614  12.213  19.982  0.50 19.63           C  
ATOM   1221  CZ  TYR   191      63.886  13.196  19.356  0.50 19.57           C  
ATOM   1223  OH  TYR   191      62.538  13.353  19.707  0.50 23.05           O  
ATOM   1225  N   PHE   192      67.934  15.671  19.788  1.00 12.92           N  
ATOM   1226  CA  PHE   192      67.682  16.391  21.012  1.00 12.00           C  
ATOM   1227  C   PHE   192      66.217  16.350  21.390  1.00 15.05           C  
ATOM   1228  O   PHE   192      65.342  16.391  20.546  1.00 14.95           O  
ATOM   1229  CB  PHE   192      68.081  17.887  20.891  1.00 13.36           C  
ATOM   1230  CG  PHE   192      69.568  18.071  20.625  1.00 13.38           C  
ATOM   1231  CD1 PHE   192      70.111  17.982  19.352  1.00 13.21           C  
ATOM   1232  CD2 PHE   192      70.414  18.306  21.664  1.00 13.92           C  
ATOM   1233  CE1 PHE   192      71.453  18.146  19.132  1.00 14.47           C  
ATOM   1234  CE2 PHE   192      71.792  18.413  21.461  1.00 16.10           C  
ATOM   1235  CZ  PHE   192      72.304  18.316  20.152  1.00 15.42           C  
ATOM   1236  N   GLU   193      66.020  16.328  22.698  0.50 14.86           N  
ATOM   1238  CA  GLU   193      64.714  16.451  23.313  0.50 14.43           C  
ATOM   1240  C   GLU   193      64.810  17.511  24.374  0.50 14.06           C  
ATOM   1242  O   GLU   193      65.703  17.521  25.230  0.50 13.21           O  
ATOM   1244  CB  GLU   193      64.251  15.102  23.882  0.50 18.56           C  
ATOM   1246  CG  GLU   193      62.771  15.051  24.176  0.50 19.08           C  
ATOM   1248  CD  GLU   193      62.271  13.640  24.406  0.50 19.24           C  
ATOM   1250  OE1 GLU   193      62.593  13.085  25.459  0.50 24.99           O  
ATOM   1252  OE2 GLU   193      61.562  13.091  23.532  0.50 24.02           O  
ATOM   1254  N   ASN   194      63.881  18.437  24.301  1.00 15.28           N  
ATOM   1255  CA  ASN   194      63.862  19.476  25.281  1.00 13.84           C  
ATOM   1256  C   ASN   194      65.216  20.171  25.452  1.00 15.03           C  
ATOM   1257  O   ASN   194      65.667  20.463  26.566  1.00 15.53           O  
ATOM   1258  CB  ASN   194      63.317  18.922  26.604  1.00 15.51           C  
ATOM   1259  CG  ASN   194      61.905  18.368  26.475  1.00 18.03           C  
ATOM   1260  OD1 ASN   194      61.081  18.910  25.715  1.00 18.54           O  
ATOM   1261  ND2 ASN   194      61.613  17.275  27.198  1.00 22.58           N  
ATOM   1262  N   GLY   195      65.925  20.334  24.335  1.00 14.89           N  
ATOM   1263  CA  GLY   195      67.167  21.056  24.370  1.00 13.79           C  
ATOM   1264  C   GLY   195      68.406  20.271  24.797  1.00 13.38           C  
ATOM   1265  O   GLY   195      69.477  20.857  25.001  1.00 15.80           O  
ATOM   1266  N   LEU   196      68.217  18.982  25.039  1.00 13.03           N  
ATOM   1267  CA  LEU   196      69.274  18.120  25.580  1.00 14.39           C  
ATOM   1268  C   LEU   196      69.497  16.928  24.692  1.00 13.64           C  
ATOM   1269  O   LEU   196      68.554  16.350  24.159  1.00 13.46           O  
ATOM   1270  CB  LEU   196      68.885  17.609  26.974  1.00 16.15           C  
ATOM   1271  CG  LEU   196      68.502  18.640  28.031  1.00 14.72           C  
ATOM   1272  CD1 LEU   196      67.932  17.937  29.315  1.00 18.12           C  
ATOM   1273  CD2 LEU   196      69.661  19.534  28.350  1.00 17.62           C  
ATOM   1274  N   LEU   197      70.759  16.505  24.630  1.00 11.94           N  
ATOM   1275  CA  LEU   197      71.132  15.365  23.759  1.00 12.92           C  
ATOM   1276  C   LEU   197      70.454  14.085  24.211  1.00 13.06           C  
ATOM   1277  O   LEU   197      70.592  13.695  25.369  1.00 14.71           O  
ATOM   1278  CB  LEU   197      72.649  15.220  23.667  1.00 13.00           C  
ATOM   1279  CG  LEU   197      73.126  14.139  22.688  1.00 13.00           C  
ATOM   1280  CD1 LEU   197      72.751  14.521  21.262  1.00 13.62           C  
ATOM   1281  CD2 LEU   197      74.627  13.906  22.775  1.00 14.53           C  
ATOM   1282  N   LYS   198      69.782  13.394  23.316  1.00 13.69           N  
ATOM   1283  CA  LYS   198      69.084  12.160  23.589  1.00 16.94           C  
ATOM   1284  C   LYS   198      69.771  10.970  22.909  1.00 16.25           C  
ATOM   1285  O   LYS   198      69.780   9.855  23.438  1.00 18.30           O  
ATOM   1286  CB  LYS   198      67.618  12.227  23.171  1.00 18.84           C  
ATOM   1287  CG  LYS   198      66.839  10.999  23.554  1.00 29.27           C  
ATOM   1288  N   ASN   199      70.302  11.182  21.723  1.00 14.81           N  
ATOM   1289  CA  ASN   199      70.999  10.109  20.978  1.00 14.70           C  
ATOM   1290  C   ASN   199      71.980  10.688  19.997  1.00 15.01           C  
ATOM   1291  O   ASN   199      71.739  11.779  19.475  1.00 13.56           O  
ATOM   1292  CB  ASN   199      69.961   9.269  20.196  1.00 16.31           C  
ATOM   1293  CG  ASN   199      70.551   8.016  19.560  1.00 27.61           C  
ATOM   1294  OD1 ASN   199      71.428   7.348  20.124  1.00 40.36           O  
ATOM   1295  ND2 ASN   199      70.077   7.704  18.352  1.00 42.03           N  
ATOM   1296  N   LYS   200      73.077   9.975  19.764  1.00 15.34           N  
ATOM   1297  CA  LYS   200      74.038  10.351  18.745  1.00 13.30           C  
ATOM   1298  C   LYS   200      74.372   9.195  17.824  1.00 12.84           C  
ATOM   1299  O   LYS   200      74.454   8.061  18.277  1.00 14.91           O  
ATOM   1300  CB  LYS   200      75.331  10.915  19.383  1.00 14.58           C  
ATOM   1301  CG  LYS   200      76.118   9.913  20.216  1.00 16.72           C  
ATOM   1302  CD  LYS   200      77.393  10.560  20.810  1.00 15.59           C  
ATOM   1303  CE  LYS   200      78.254   9.595  21.607  1.00 18.90           C  
ATOM   1304  NZ  LYS   200      79.435  10.254  22.272  1.00 16.70           N  
ATOM   1305  N   THR   201      74.592   9.531  16.556  1.00 13.61           N  
ATOM   1306  CA  THR   201      75.007   8.574  15.530  1.00 13.30           C  
ATOM   1307  C   THR   201      76.039   9.217  14.628  1.00 15.22           C  
ATOM   1308  O   THR   201      76.116  10.459  14.523  1.00 12.23           O  
ATOM   1309  CB  THR   201      73.810   8.081  14.676  1.00 17.48           C  
ATOM   1310  OG1 THR   201      73.306   9.122  13.843  1.00 18.89           O  
ATOM   1311  CG2 THR   201      72.697   7.525  15.561  1.00 22.52           C  
ATOM   1312  N   GLN   202      76.797   8.389  13.933  1.00 13.93           N  
ATOM   1313  CA  GLN   202      77.830   8.861  12.997  1.00 14.75           C  
ATOM   1314  C   GLN   202      78.002   7.887  11.855  1.00 16.16           C  
ATOM   1315  O   GLN   202      77.661   6.708  11.993  1.00 18.17           O  
ATOM   1316  CB  GLN   202      79.189   9.104  13.686  1.00 16.42           C  
ATOM   1317  CG  GLN   202      79.757   7.943  14.445  1.00 15.93           C  
ATOM   1318  CD  GLN   202      80.473   6.950  13.564  1.00 23.94           C  
ATOM   1319  OE1 GLN   202      80.926   7.284  12.448  1.00 18.99           O  
ATOM   1320  NE2 GLN   202      80.562   5.712  14.048  1.00 22.38           N  
ATOM   1321  N   LYS   203      78.390   8.432  10.714  1.00 15.86           N  
ATOM   1322  CA  LYS   203      78.738   7.680   9.503  1.00 16.55           C  
ATOM   1323  C   LYS   203      80.157   8.054   9.129  1.00 17.12           C  
ATOM   1324  O   LYS   203      80.510   9.205   8.962  1.00 17.00           O  
ATOM   1325  CB  LYS   203      77.793   8.036   8.374  1.00 18.56           C  
ATOM   1326  CG  LYS   203      78.096   7.354   7.061  1.00 19.48           C  
ATOM   1327  CD  LYS   203      77.243   7.899   5.937  1.00 25.27           C  
ATOM   1328  CE  LYS   203      77.700   7.431   4.577  1.00 35.37           C  
ATOM   1329  NZ  LYS   203      76.995   8.156   3.469  1.00 38.80           N  
ATOM   1330  N   ASP   204      80.969   7.003   8.972  1.00 18.61           N  
ATOM   1331  CA  ASP   204      82.335   7.089   8.410  1.00 20.62           C  
ATOM   1332  C   ASP   204      83.301   7.924   9.218  1.00 20.47           C  
ATOM   1333  O   ASP   204      84.268   8.434   8.676  1.00 25.10           O  
ATOM   1334  CB  ASP   204      82.284   7.624   6.968  1.00 21.23           C  
ATOM   1335  CG  ASP   204      81.720   6.622   5.979  1.00 30.33           C  
ATOM   1336  OD1 ASP   204      81.703   5.414   6.298  1.00 30.92           O  
ATOM   1337  OD2 ASP   204      81.294   7.053   4.873  1.00 41.68           O  
ATOM   1338  N   LEU   205      83.026   8.103  10.519  1.00 21.00           N  
ATOM   1339  CA  LEU   205      83.890   8.891  11.426  1.00 22.54           C  
ATOM   1340  C   LEU   205      84.753   8.057  12.369  1.00 25.85           C  
ATOM   1341  O   LEU   205      85.904   8.419  12.682  1.00 26.84           O  
ATOM   1342  CB  LEU   205      83.042   9.827  12.276  1.00 23.44           C  
ATOM   1343  CG  LEU   205      83.840  10.700  13.217  1.00 21.98           C  
ATOM   1344  CD1 LEU   205      84.867  11.574  12.457  1.00 24.08           C  
ATOM   1345  CD2 LEU   205      82.933  11.567  14.091  1.00 23.55           C  
ATOM   1346  N   GLU   206      84.172   6.965  12.853  1.00 25.20           N  
ATOM   1347  CA  GLU   206      84.887   6.017  13.743  1.00 26.40           C  
ATOM   1348  C   GLU   206      84.307   4.618  13.645  1.00 28.28           C  
ATOM   1349  O   GLU   206      84.871   3.641  14.196  1.00 29.52           O  
ATOM   1350  CB  GLU   206      84.869   6.478  15.207  1.00 25.41           C  
ATOM   1351  CG  GLU   206      83.490   6.434  15.836  1.00 25.16           C  
ATOM   1352  CD  GLU   206      83.478   6.957  17.255  1.00 23.71           C  
ATOM   1353  OE1 GLU   206      84.410   7.708  17.627  1.00 26.38           O  
ATOM   1354  OE2 GLU   206      82.551   6.619  18.017  1.00 26.68           O  
ATOM   1355  OXT GLU   206      83.280   4.452  12.982  1.00 26.41           O  
END
