
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  111 (  929),  selected  111 , name 1oqc_B
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 1oqc_B.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D    14_B      -       -           -
LGA    C    15_B      -       -           -
LGA    P    16_B      -       -           -
LGA    Q    17_B      -       -           -
LGA    D    18_B      -       -           -
LGA    R    19_B      M       3          1.310
LGA    E    20_B      L       4          1.460
LGA    E    21_B      H       5          1.021
LGA    L    22_B      W       6          0.874
LGA    G    23_B      G       7          0.569
LGA    R    24_B      P       8          0.706
LGA    N    25_B      K       9          0.921
LGA    T    26_B      Y      10          0.765
LGA    W    27_B      W      11          0.495
LGA    A    28_B      R      12          1.166
LGA    F    29_B      S      13          1.503
LGA    L    30_B      L      14          1.139
LGA    H    31_B      H      15          1.013
LGA    T    32_B      L      16          1.721
LGA    L    33_B      Y      17          1.842
LGA    A    34_B      A      18          1.463
LGA    A    35_B      I      19          1.674
LGA    Y    36_B      F      20          2.039
LGA    Y    37_B      F      21          1.635
LGA    P    38_B      S      22          1.326
LGA    D    39_B      D      23          1.239
LGA    M    40_B      A      24          1.273
LGA    P    41_B      P      25          1.167
LGA    T    42_B      S      26          1.316
LGA    P    43_B      W      27          1.172
LGA    E    44_B      K      28          0.899
LGA    Q    45_B      E      29          0.809
LGA    Q    46_B      K      30          1.003
LGA    Q    47_B      Y      31          1.019
LGA    D    48_B      E      32          0.544
LGA    M    49_B      A      33          0.538
LGA    A    50_B      I      34          1.367
LGA    Q    51_B      Q      35          1.488
LGA    F    52_B      W      36          0.829
LGA    I    53_B      I      37          0.625
LGA    H    54_B      L      38          1.745
LGA    I    55_B      N      39          2.363
LGA    F    56_B      F      40          1.830
LGA    S    57_B      I      41          1.827
LGA    K    58_B      E      42          2.693
LGA    F    59_B      S      43          3.085
LGA    Y    60_B      L      44          1.590
LGA    P    61_B      P      45          1.681
LGA    C    62_B      C      46          1.426
LGA    E    63_B      T      47          1.247
LGA    E    64_B      R      48          1.232
LGA    C    65_B      C      49          0.771
LGA    A    66_B      Q      50          0.859
LGA    E    67_B      H      51          1.115
LGA    D    68_B      H      52          1.013
LGA    I    69_B      A      53          0.818
LGA    R    70_B      F      54          0.662
LGA    K    71_B      S      55          0.714
LGA    R    72_B      Y      56          0.778
LGA    I    73_B      L      57          0.799
LGA    D    74_B      T      58          1.124
LGA    R    75_B      K      59          0.696
LGA    S    76_B      N      60          0.440
LGA    Q    77_B      P      61          1.697
LGA    P    78_B      L      62          1.354
LGA    D    79_B      T      63          1.222
LGA    T    80_B      L      64          1.648
LGA    S    81_B      N      65          1.751
LGA    T    82_B      N      66          0.673
LGA    R    83_B      S      67          0.397
LGA    V    84_B      E      68          0.883
LGA    S    85_B      D      69          0.728
LGA    F    86_B      F      70          0.185
LGA    S    87_B      Q      71          0.056
LGA    Q    88_B      Y      72          0.085
LGA    W    89_B      W      73          0.456
LGA    L    90_B      T      74          0.456
LGA    C    91_B      F      75          0.220
LGA    R    92_B      A      76          0.226
LGA    L    93_B      F      77          0.267
LGA    H    94_B      H      78          0.335
LGA    N    95_B      N      79          0.374
LGA    E    96_B      N      80          0.302
LGA    V    97_B      V      81          0.132
LGA    N    98_B      N      82          0.202
LGA    R    99_B      N      83          0.221
LGA    K   100_B      R      84          0.170
LGA    L   101_B      L      85          0.290
LGA    G   102_B      N      86          0.406
LGA    K   103_B      K      87          0.573
LGA    P   104_B      K      88          0.953
LGA    D   105_B      I      89          0.613
LGA    F   106_B      I      90          1.329
LGA    D   107_B      S      91          0.899
LGA    C   108_B      W      92          1.973
LGA    S   109_B      S      93          3.186
LGA    R   110_B      E      94          3.413
LGA    V   111_B      Y      95          2.569
LGA    D   112_B      K      96          2.849
LGA    E   113_B      N      97          1.997
LGA    R   114_B      I      98          0.970
LGA    W   115_B      Y      99          1.486
LGA    R   116_B      E     100          3.254
LGA    D   117_B      Q     101          2.492
LGA    G   118_B      S     102           #
LGA    W   119_B      I     103           -
LGA    K   120_B      L     104           -
LGA    D   121_B      -       -           -
LGA    G   122_B      -       -           -
LGA    S   123_B      -       -           -
LGA    C   124_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  111  102    5.0     99    1.37    22.22     92.084     6.738

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.698863 * X  +  -0.674755 * Y  +   0.237269 * Z  +  22.591076
  Y_new =  -0.282751 * X  +  -0.565332 * Y  +  -0.774888 * Z  +  53.665562
  Z_new =   0.656995 * X  +   0.474453 * Y  +  -0.585877 * Z  +   2.100813 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.460895   -0.680698  [ DEG:   140.9989    -39.0011 ]
  Theta =  -0.716826   -2.424767  [ DEG:   -41.0711   -138.9289 ]
  Phi   =  -0.384454    2.757138  [ DEG:   -22.0276    157.9724 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1oqc_B                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1oqc_B.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  111  102   5.0   99   1.37   22.22  92.084
REMARK  ---------------------------------------------------------- 
MOLECULE 1oqc_B
HEADER    OXIDOREDUCTASE                          07-MAR-03   1OQC              
TITLE     THE CRYSTAL STRUCTURE OF AUGMENTER OF LIVER REGENERATION: A           
TITLE    2 MAMMALIAN FAD DEPENDENT SULFHYDRYL OXIDASE                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: AUGMENTER OF LIVER REGENERATION;                           
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: ALR;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 GENE: ALR;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET16                                     
KEYWDS    SULFHYDRYL OXIDASE, LIVER REGENERATION, ALR, HELIX-TURN-              
KEYWDS   2 HELIX                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.P.ROSE,C.-K.WU,B.-C.WANG                                            
REVDAT   3   28-FEB-06 1OQC    1       REMARK                                   
REVDAT   2   27-APR-04 1OQC    1       JRNL                                     
REVDAT   1   15-APR-03 1OQC    0                                                
JRNL        AUTH   C.-K.WU,T.A.DAILEY,H.A.DAILEY,B.-C.WANG,J.P.ROSE             
JRNL        TITL   THE REFINED CRYSTAL STRUCTURE OF AUGMENTER OF                
JRNL        TITL 2 LIVER REGENERATION                                           
JRNL        REF    INT.UNION CRYST.(MEETING)     V.   1   293 1999              
JRNL        REFN                US ISSN 1067-0696                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1OQC A    1   125  UNP    Q63042   ALR_RAT          1    125             
DBREF  1OQC B    1   125  UNP    Q63042   ALR_RAT          1    125             
DBREF  1OQC C    1   125  UNP    Q63042   ALR_RAT          1    125             
DBREF  1OQC D    1   125  UNP    Q63042   ALR_RAT          1    125             
SEQRES   1 A  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 A  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 A  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 A  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 A  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 A  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 A  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 A  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 A  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 A  125  GLY TRP LYS ASP GLY SER CYS ASP                              
SEQRES   1 B  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 B  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 B  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 B  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 B  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 B  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 B  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 B  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 B  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 B  125  GLY TRP LYS ASP GLY SER CYS ASP                              
SEQRES   1 C  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 C  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 C  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 C  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 C  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 C  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 C  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 C  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 C  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 C  125  GLY TRP LYS ASP GLY SER CYS ASP                              
SEQRES   1 D  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 D  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 D  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 D  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 D  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 D  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 D  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 D  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 D  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 D  125  GLY TRP LYS ASP GLY SER CYS ASP                              
HET    FAD  A   1      53                                                       
HET    FAD  B   1      53                                                       
HET    FAD  C   1      53                                                       
HET    FAD  D   1      53                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   5  FAD    4(C27 H33 N9 O15 P2)                                         
FORMUL   9  HOH   *623(H2 O)                                                    
CRYST1  106.987  123.130   37.930  90.00  90.00  90.00 P 21 21 2    16          
ATOM    988  N   ASP B  14      54.589  36.973  14.978  1.00 21.60           N  
ATOM    989  CA  ASP B  14      55.513  37.728  14.083  1.00 18.76           C  
ATOM    990  C   ASP B  14      55.986  36.817  12.956  1.00 17.10           C  
ATOM    991  O   ASP B  14      56.661  37.258  12.026  1.00 15.29           O  
ATOM    992  CB  ASP B  14      56.720  38.213  14.887  1.00 24.50           C  
ATOM    993  CG  ASP B  14      57.093  39.642  14.568  1.00 26.69           C  
ATOM    994  OD1 ASP B  14      56.234  40.530  14.757  1.00 29.49           O  
ATOM    995  OD2 ASP B  14      58.239  39.877  14.134  1.00 28.87           O  
ATOM    996  N   CYS B  15      55.626  35.543  13.052  1.00 13.11           N  
ATOM    997  CA  CYS B  15      56.019  34.548  12.063  1.00 11.74           C  
ATOM    998  C   CYS B  15      54.834  33.999  11.274  1.00  9.61           C  
ATOM    999  O   CYS B  15      53.684  34.184  11.656  1.00  8.26           O  
ATOM   1000  CB  CYS B  15      56.728  33.391  12.762  1.00 13.45           C  
ATOM   1001  SG  CYS B  15      58.330  33.834  13.503  1.00 15.44           S  
ATOM   1002  N   PRO B  16      55.106  33.313  10.152  1.00  8.99           N  
ATOM   1003  CA  PRO B  16      54.014  32.752   9.350  1.00  8.60           C  
ATOM   1004  C   PRO B  16      53.166  31.800  10.197  1.00 10.15           C  
ATOM   1005  O   PRO B  16      53.674  31.130  11.100  1.00 10.17           O  
ATOM   1006  CB  PRO B  16      54.750  32.028   8.223  1.00  9.38           C  
ATOM   1007  CG  PRO B  16      56.008  32.849   8.062  1.00  8.50           C  
ATOM   1008  CD  PRO B  16      56.409  33.093   9.498  1.00  8.58           C  
ATOM   1009  N   GLN B  17      51.872  31.744   9.903  1.00 10.67           N  
ATOM   1010  CA  GLN B  17      50.947  30.888  10.640  1.00 11.85           C  
ATOM   1011  C   GLN B  17      51.131  29.412  10.304  1.00 11.78           C  
ATOM   1012  O   GLN B  17      51.162  29.046   9.130  1.00 12.40           O  
ATOM   1013  CB  GLN B  17      49.507  31.273  10.297  1.00 12.84           C  
ATOM   1014  CG  GLN B  17      49.207  32.754  10.418  1.00 16.23           C  
ATOM   1015  CD  GLN B  17      48.251  33.056  11.551  1.00 17.51           C  
ATOM   1016  OE1 GLN B  17      47.138  32.531  11.591  1.00 17.14           O  
ATOM   1017  NE2 GLN B  17      48.677  33.904  12.477  1.00 18.01           N  
ATOM   1018  N   ASP B  18      51.258  28.560  11.320  1.00 11.37           N  
ATOM   1019  CA  ASP B  18      51.375  27.136  11.041  1.00 11.47           C  
ATOM   1020  C   ASP B  18      49.962  26.622  10.790  1.00 11.98           C  
ATOM   1021  O   ASP B  18      48.995  27.375  10.920  1.00 10.68           O  
ATOM   1022  CB  ASP B  18      52.047  26.362  12.190  1.00 13.99           C  
ATOM   1023  CG  ASP B  18      51.386  26.590  13.537  1.00 15.81           C  
ATOM   1024  OD1 ASP B  18      50.147  26.687  13.602  1.00 16.06           O  
ATOM   1025  OD2 ASP B  18      52.122  26.646  14.547  1.00 18.85           O  
ATOM   1026  N   ARG B  19      49.840  25.352  10.425  1.00 12.34           N  
ATOM   1027  CA  ARG B  19      48.533  24.776  10.133  1.00 11.30           C  
ATOM   1028  C   ARG B  19      47.483  24.983  11.221  1.00 11.47           C  
ATOM   1029  O   ARG B  19      46.318  25.238  10.919  1.00  9.76           O  
ATOM   1030  CB  ARG B  19      48.672  23.283   9.842  1.00 12.35           C  
ATOM   1031  CG  ARG B  19      47.347  22.573   9.668  1.00 14.39           C  
ATOM   1032  CD  ARG B  19      47.543  21.085   9.451  1.00 16.31           C  
ATOM   1033  NE  ARG B  19      48.165  20.799   8.165  1.00 20.93           N  
ATOM   1034  CZ  ARG B  19      48.266  19.579   7.648  1.00 22.83           C  
ATOM   1035  NH1 ARG B  19      47.784  18.536   8.313  1.00 23.78           N  
ATOM   1036  NH2 ARG B  19      48.842  19.401   6.466  1.00 22.62           N  
ATOM   1037  N   GLU B  20      47.893  24.873  12.481  1.00 11.63           N  
ATOM   1038  CA  GLU B  20      46.972  25.037  13.602  1.00 11.34           C  
ATOM   1039  C   GLU B  20      46.566  26.487  13.839  1.00 10.45           C  
ATOM   1040  O   GLU B  20      45.398  26.768  14.094  1.00  9.82           O  
ATOM   1041  CB  GLU B  20      47.587  24.460  14.879  1.00 13.88           C  
ATOM   1042  CG  GLU B  20      47.769  22.946  14.858  1.00 15.87           C  
ATOM   1043  CD  GLU B  20      48.664  22.478  13.724  1.00 18.20           C  
ATOM   1044  OE1 GLU B  20      49.816  22.953  13.630  1.00 18.37           O  
ATOM   1045  OE2 GLU B  20      48.214  21.632  12.924  1.00 19.96           O  
ATOM   1046  N   GLU B  21      47.529  27.401  13.766  1.00 10.51           N  
ATOM   1047  CA  GLU B  21      47.249  28.822  13.967  1.00 10.22           C  
ATOM   1048  C   GLU B  21      46.344  29.333  12.853  1.00  8.32           C  
ATOM   1049  O   GLU B  21      45.347  30.007  13.112  1.00  6.58           O  
ATOM   1050  CB  GLU B  21      48.547  29.631  13.973  1.00 13.29           C  
ATOM   1051  CG  GLU B  21      49.515  29.246  15.072  1.00 19.57           C  
ATOM   1052  CD  GLU B  21      50.819  30.020  14.997  1.00 22.14           C  
ATOM   1053  OE1 GLU B  21      51.472  29.989  13.931  1.00 21.72           O  
ATOM   1054  OE2 GLU B  21      51.191  30.653  16.006  1.00 25.63           O  
ATOM   1055  N   LEU B  22      46.696  29.012  11.612  1.00  7.02           N  
ATOM   1056  CA  LEU B  22      45.902  29.437  10.465  1.00  7.05           C  
ATOM   1057  C   LEU B  22      44.494  28.880  10.624  1.00  7.00           C  
ATOM   1058  O   LEU B  22      43.505  29.582  10.409  1.00  6.74           O  
ATOM   1059  CB  LEU B  22      46.512  28.910   9.166  1.00  6.28           C  
ATOM   1060  CG  LEU B  22      45.713  29.273   7.911  1.00  7.68           C  
ATOM   1061  CD1 LEU B  22      45.884  30.757   7.640  1.00  8.85           C  
ATOM   1062  CD2 LEU B  22      46.187  28.450   6.714  1.00  7.66           C  
ATOM   1063  N   GLY B  23      44.419  27.611  11.013  1.00  5.91           N  
ATOM   1064  CA  GLY B  23      43.137  26.960  11.202  1.00  6.97           C  
ATOM   1065  C   GLY B  23      42.229  27.677  12.183  1.00  6.70           C  
ATOM   1066  O   GLY B  23      41.143  28.116  11.816  1.00  4.59           O  
ATOM   1067  N   ARG B  24      42.669  27.808  13.432  1.00  6.49           N  
ATOM   1068  CA  ARG B  24      41.840  28.465  14.436  1.00  8.35           C  
ATOM   1069  C   ARG B  24      41.450  29.890  14.045  1.00  8.58           C  
ATOM   1070  O   ARG B  24      40.320  30.321  14.292  1.00  7.10           O  
ATOM   1071  CB  ARG B  24      42.536  28.443  15.804  1.00 12.05           C  
ATOM   1072  CG  ARG B  24      43.899  29.101  15.856  1.00 14.53           C  
ATOM   1073  CD  ARG B  24      44.471  28.988  17.267  1.00 17.74           C  
ATOM   1074  NE  ARG B  24      44.581  27.597  17.697  1.00 19.98           N  
ATOM   1075  CZ  ARG B  24      45.711  26.893  17.698  1.00 20.26           C  
ATOM   1076  NH1 ARG B  24      46.848  27.447  17.298  1.00 20.41           N  
ATOM   1077  NH2 ARG B  24      45.702  25.627  18.090  1.00 19.74           N  
ATOM   1078  N   ASN B  25      42.371  30.615  13.420  1.00  7.51           N  
ATOM   1079  CA  ASN B  25      42.090  31.983  12.990  1.00  8.42           C  
ATOM   1080  C   ASN B  25      41.083  32.017  11.843  1.00  7.04           C  
ATOM   1081  O   ASN B  25      40.227  32.900  11.781  1.00  5.73           O  
ATOM   1082  CB  ASN B  25      43.381  32.674  12.550  1.00 10.65           C  
ATOM   1083  CG  ASN B  25      44.271  33.033  13.720  1.00 13.26           C  
ATOM   1084  OD1 ASN B  25      45.442  33.373  13.543  1.00 16.22           O  
ATOM   1085  ND2 ASN B  25      43.716  32.970  14.924  1.00 11.25           N  
ATOM   1086  N   THR B  26      41.180  31.055  10.935  1.00  5.92           N  
ATOM   1087  CA  THR B  26      40.256  31.020   9.808  1.00  6.57           C  
ATOM   1088  C   THR B  26      38.867  30.600  10.272  1.00  7.29           C  
ATOM   1089  O   THR B  26      37.876  31.162   9.822  1.00  5.89           O  
ATOM   1090  CB  THR B  26      40.757  30.069   8.709  1.00  6.64           C  
ATOM   1091  OG1 THR B  26      42.050  30.503   8.274  1.00  7.20           O  
ATOM   1092  CG2 THR B  26      39.813  30.082   7.514  1.00  6.93           C  
ATOM   1093  N   TRP B  27      38.790  29.621  11.173  1.00  6.53           N  
ATOM   1094  CA  TRP B  27      37.488  29.199  11.681  1.00  6.26           C  
ATOM   1095  C   TRP B  27      36.825  30.374  12.393  1.00  5.54           C  
ATOM   1096  O   TRP B  27      35.624  30.595  12.249  1.00  5.91           O  
ATOM   1097  CB  TRP B  27      37.617  28.032  12.665  1.00  5.79           C  
ATOM   1098  CG  TRP B  27      37.934  26.706  12.040  1.00  5.30           C  
ATOM   1099  CD1 TRP B  27      39.005  25.906  12.328  1.00  4.09           C  
ATOM   1100  CD2 TRP B  27      37.157  26.000  11.061  1.00  4.74           C  
ATOM   1101  NE1 TRP B  27      38.942  24.746  11.591  1.00  4.80           N  
ATOM   1102  CE2 TRP B  27      37.819  24.775  10.805  1.00  4.69           C  
ATOM   1103  CE3 TRP B  27      35.967  26.281  10.375  1.00  5.92           C  
ATOM   1104  CZ2 TRP B  27      37.329  23.829   9.892  1.00  4.36           C  
ATOM   1105  CZ3 TRP B  27      35.478  25.336   9.462  1.00  4.91           C  
ATOM   1106  CH2 TRP B  27      36.164  24.125   9.232  1.00  6.19           C  
ATOM   1107  N   ALA B  28      37.606  31.125  13.165  1.00  3.92           N  
ATOM   1108  CA  ALA B  28      37.059  32.277  13.886  1.00  5.01           C  
ATOM   1109  C   ALA B  28      36.436  33.236  12.885  1.00  5.58           C  
ATOM   1110  O   ALA B  28      35.321  33.723  13.076  1.00  3.72           O  
ATOM   1111  CB  ALA B  28      38.161  32.981  14.671  1.00  4.94           C  
ATOM   1112  N   PHE B  29      37.165  33.504  11.809  1.00  5.24           N  
ATOM   1113  CA  PHE B  29      36.675  34.395  10.772  1.00  4.69           C  
ATOM   1114  C   PHE B  29      35.396  33.850  10.143  1.00  4.97           C  
ATOM   1115  O   PHE B  29      34.393  34.557  10.048  1.00  3.71           O  
ATOM   1116  CB  PHE B  29      37.736  34.575   9.690  1.00  5.66           C  
ATOM   1117  CG  PHE B  29      37.194  35.114   8.401  1.00  7.01           C  
ATOM   1118  CD1 PHE B  29      36.566  36.356   8.356  1.00  7.91           C  
ATOM   1119  CD2 PHE B  29      37.271  34.360   7.235  1.00  7.92           C  
ATOM   1120  CE1 PHE B  29      36.020  36.836   7.168  1.00  9.16           C  
ATOM   1121  CE2 PHE B  29      36.729  34.832   6.044  1.00  9.77           C  
ATOM   1122  CZ  PHE B  29      36.100  36.074   6.011  1.00 10.25           C  
ATOM   1123  N   LEU B  30      35.436  32.594   9.707  1.00  5.37           N  
ATOM   1124  CA  LEU B  30      34.275  31.976   9.076  1.00  5.93           C  
ATOM   1125  C   LEU B  30      33.053  31.931   9.982  1.00  5.97           C  
ATOM   1126  O   LEU B  30      31.955  32.291   9.558  1.00  5.64           O  
ATOM   1127  CB  LEU B  30      34.615  30.562   8.596  1.00  6.20           C  
ATOM   1128  CG  LEU B  30      35.627  30.453   7.453  1.00  7.17           C  
ATOM   1129  CD1 LEU B  30      35.940  28.987   7.183  1.00  7.94           C  
ATOM   1130  CD2 LEU B  30      35.073  31.126   6.202  1.00  7.65           C  
ATOM   1131  N   HIS B  31      33.235  31.497  11.228  1.00  4.82           N  
ATOM   1132  CA  HIS B  31      32.108  31.415  12.155  1.00  4.96           C  
ATOM   1133  C   HIS B  31      31.552  32.786  12.535  1.00  5.89           C  
ATOM   1134  O   HIS B  31      30.352  32.931  12.755  1.00  4.37           O  
ATOM   1135  CB  HIS B  31      32.501  30.637  13.421  1.00  4.25           C  
ATOM   1136  CG  HIS B  31      32.736  29.174  13.184  1.00  5.18           C  
ATOM   1137  ND1 HIS B  31      31.788  28.350  12.613  1.00  7.10           N  
ATOM   1138  CD2 HIS B  31      33.810  28.390  13.438  1.00  5.11           C  
ATOM   1139  CE1 HIS B  31      32.271  27.123  12.522  1.00  7.58           C  
ATOM   1140  NE2 HIS B  31      33.496  27.120  13.017  1.00  5.02           N  
ATOM   1141  N   THR B  32      32.419  33.791  12.623  1.00  5.39           N  
ATOM   1142  CA  THR B  32      31.959  35.136  12.962  1.00  4.40           C  
ATOM   1143  C   THR B  32      31.251  35.698  11.726  1.00  4.73           C  
ATOM   1144  O   THR B  32      30.269  36.433  11.834  1.00  5.78           O  
ATOM   1145  CB  THR B  32      33.141  36.040  13.361  1.00  3.22           C  
ATOM   1146  OG1 THR B  32      33.839  35.440  14.462  1.00  4.30           O  
ATOM   1147  CG2 THR B  32      32.648  37.415  13.785  1.00  5.03           C  
ATOM   1148  N   LEU B  33      31.751  35.337  10.550  1.00  5.11           N  
ATOM   1149  CA  LEU B  33      31.145  35.774   9.296  1.00  5.97           C  
ATOM   1150  C   LEU B  33      29.709  35.248   9.243  1.00  5.69           C  
ATOM   1151  O   LEU B  33      28.769  35.983   8.922  1.00  6.21           O  
ATOM   1152  CB  LEU B  33      31.943  35.217   8.114  1.00  8.34           C  
ATOM   1153  CG  LEU B  33      31.496  35.526   6.684  1.00 11.96           C  
ATOM   1154  CD1 LEU B  33      31.699  36.988   6.393  1.00 16.25           C  
ATOM   1155  CD2 LEU B  33      32.305  34.686   5.704  1.00 16.55           C  
ATOM   1156  N   ALA B  34      29.547  33.970   9.572  1.00  4.82           N  
ATOM   1157  CA  ALA B  34      28.238  33.326   9.558  1.00  5.17           C  
ATOM   1158  C   ALA B  34      27.336  33.885  10.646  1.00  4.64           C  
ATOM   1159  O   ALA B  34      26.141  34.079  10.434  1.00  5.22           O  
ATOM   1160  CB  ALA B  34      28.396  31.819   9.739  1.00  3.78           C  
ATOM   1161  N   ALA B  35      27.920  34.146  11.810  1.00  4.73           N  
ATOM   1162  CA  ALA B  35      27.170  34.671  12.940  1.00  4.99           C  
ATOM   1163  C   ALA B  35      26.436  35.963  12.611  1.00  6.87           C  
ATOM   1164  O   ALA B  35      25.335  36.204  13.113  1.00  5.86           O  
ATOM   1165  CB  ALA B  35      28.113  34.896  14.125  1.00  3.76           C  
ATOM   1166  N   TYR B  36      27.039  36.795  11.768  1.00  5.64           N  
ATOM   1167  CA  TYR B  36      26.429  38.073  11.418  1.00  6.46           C  
ATOM   1168  C   TYR B  36      25.776  38.116  10.043  1.00  5.83           C  
ATOM   1169  O   TYR B  36      25.384  39.179   9.559  1.00  5.17           O  
ATOM   1170  CB  TYR B  36      27.467  39.186  11.567  1.00  8.10           C  
ATOM   1171  CG  TYR B  36      27.773  39.477  13.018  1.00  8.65           C  
ATOM   1172  CD1 TYR B  36      26.899  40.238  13.794  1.00  9.92           C  
ATOM   1173  CD2 TYR B  36      28.904  38.944  13.633  1.00  9.18           C  
ATOM   1174  CE1 TYR B  36      27.141  40.460  15.150  1.00 10.37           C  
ATOM   1175  CE2 TYR B  36      29.155  39.158  14.989  1.00 11.05           C  
ATOM   1176  CZ  TYR B  36      28.269  39.917  15.738  1.00 11.81           C  
ATOM   1177  OH  TYR B  36      28.514  40.125  17.076  1.00 13.92           O  
ATOM   1178  N   TYR B  37      25.655  36.948   9.425  1.00  4.16           N  
ATOM   1179  CA  TYR B  37      25.014  36.814   8.121  1.00  6.03           C  
ATOM   1180  C   TYR B  37      23.545  37.231   8.328  1.00  6.02           C  
ATOM   1181  O   TYR B  37      23.000  37.066   9.420  1.00  5.99           O  
ATOM   1182  CB  TYR B  37      25.122  35.353   7.685  1.00  2.81           C  
ATOM   1183  CG  TYR B  37      24.653  35.032   6.283  1.00  6.79           C  
ATOM   1184  CD1 TYR B  37      25.263  35.601   5.166  1.00  7.12           C  
ATOM   1185  CD2 TYR B  37      23.631  34.110   6.076  1.00  6.08           C  
ATOM   1186  CE1 TYR B  37      24.860  35.249   3.869  1.00  6.59           C  
ATOM   1187  CE2 TYR B  37      23.229  33.752   4.802  1.00  6.21           C  
ATOM   1188  CZ  TYR B  37      23.844  34.321   3.702  1.00  6.96           C  
ATOM   1189  OH  TYR B  37      23.435  33.948   2.445  1.00  6.96           O  
ATOM   1190  N   PRO B  38      22.891  37.793   7.297  1.00  5.47           N  
ATOM   1191  CA  PRO B  38      21.490  38.207   7.463  1.00  6.11           C  
ATOM   1192  C   PRO B  38      20.531  37.073   7.827  1.00  5.82           C  
ATOM   1193  O   PRO B  38      20.731  35.926   7.424  1.00  4.78           O  
ATOM   1194  CB  PRO B  38      21.141  38.809   6.102  1.00  6.57           C  
ATOM   1195  CG  PRO B  38      22.461  39.317   5.599  1.00  7.36           C  
ATOM   1196  CD  PRO B  38      23.398  38.189   5.973  1.00  6.25           C  
ATOM   1197  N   ASP B  39      19.487  37.403   8.587  1.00  6.93           N  
ATOM   1198  CA  ASP B  39      18.484  36.413   8.962  1.00  7.73           C  
ATOM   1199  C   ASP B  39      17.790  35.952   7.692  1.00  7.99           C  
ATOM   1200  O   ASP B  39      17.551  34.763   7.494  1.00  8.38           O  
ATOM   1201  CB  ASP B  39      17.424  37.005   9.901  1.00  9.14           C  
ATOM   1202  CG  ASP B  39      17.977  37.367  11.262  1.00  9.71           C  
ATOM   1203  OD1 ASP B  39      18.910  36.686  11.730  1.00 10.88           O  
ATOM   1204  OD2 ASP B  39      17.463  38.327  11.875  1.00  8.88           O  
ATOM   1205  N   MET B  40      17.462  36.920   6.840  1.00  7.36           N  
ATOM   1206  CA  MET B  40      16.783  36.658   5.576  1.00  7.43           C  
ATOM   1207  C   MET B  40      17.589  37.261   4.425  1.00  7.32           C  
ATOM   1208  O   MET B  40      17.231  38.300   3.876  1.00  5.55           O  
ATOM   1209  CB  MET B  40      15.371  37.264   5.612  1.00  7.21           C  
ATOM   1210  CG  MET B  40      14.411  36.584   6.598  1.00  8.11           C  
ATOM   1211  SD  MET B  40      12.756  37.358   6.707  1.00  7.57           S  
ATOM   1212  CE  MET B  40      12.270  37.309   5.026  1.00 10.50           C  
ATOM   1213  N   PRO B  41      18.694  36.606   4.043  1.00  8.03           N  
ATOM   1214  CA  PRO B  41      19.529  37.115   2.950  1.00  7.39           C  
ATOM   1215  C   PRO B  41      18.794  37.165   1.617  1.00  7.77           C  
ATOM   1216  O   PRO B  41      17.888  36.374   1.371  1.00  6.90           O  
ATOM   1217  CB  PRO B  41      20.700  36.132   2.924  1.00  6.33           C  
ATOM   1218  CG  PRO B  41      20.062  34.849   3.378  1.00  7.88           C  
ATOM   1219  CD  PRO B  41      19.200  35.312   4.534  1.00  7.50           C  
ATOM   1220  N   THR B  42      19.180  38.110   0.766  1.00  7.54           N  
ATOM   1221  CA  THR B  42      18.575  38.232  -0.549  1.00  6.90           C  
ATOM   1222  C   THR B  42      19.162  37.120  -1.398  1.00  7.83           C  
ATOM   1223  O   THR B  42      20.159  36.501  -1.018  1.00  7.13           O  
ATOM   1224  CB  THR B  42      18.917  39.574  -1.229  1.00  8.71           C  
ATOM   1225  OG1 THR B  42      20.329  39.643  -1.470  1.00  8.38           O  
ATOM   1226  CG2 THR B  42      18.495  40.740  -0.351  1.00 10.04           C  
ATOM   1227  N   PRO B  43      18.541  36.832  -2.548  1.00  6.94           N  
ATOM   1228  CA  PRO B  43      19.078  35.773  -3.400  1.00  7.84           C  
ATOM   1229  C   PRO B  43      20.527  36.074  -3.775  1.00  8.83           C  
ATOM   1230  O   PRO B  43      21.356  35.168  -3.848  1.00  8.90           O  
ATOM   1231  CB  PRO B  43      18.137  35.801  -4.597  1.00  6.84           C  
ATOM   1232  CG  PRO B  43      16.819  36.099  -3.933  1.00  6.43           C  
ATOM   1233  CD  PRO B  43      17.195  37.233  -2.998  1.00  7.55           C  
ATOM   1234  N   GLU B  44      20.825  37.350  -4.007  1.00  8.81           N  
ATOM   1235  CA  GLU B  44      22.183  37.758  -4.356  1.00  9.05           C  
ATOM   1236  C   GLU B  44      23.146  37.368  -3.237  1.00  7.30           C  
ATOM   1237  O   GLU B  44      24.215  36.809  -3.486  1.00  7.45           O  
ATOM   1238  CB  GLU B  44      22.264  39.271  -4.565  1.00  9.19           C  
ATOM   1239  CG  GLU B  44      23.666  39.759  -4.920  1.00 15.53           C  
ATOM   1240  CD  GLU B  44      23.746  41.265  -5.073  1.00 18.28           C  
ATOM   1241  OE1 GLU B  44      23.642  41.978  -4.054  1.00 22.67           O  
ATOM   1242  OE2 GLU B  44      23.908  41.737  -6.216  1.00 19.93           O  
ATOM   1243  N   GLN B  45      22.760  37.678  -2.003  1.00  7.19           N  
ATOM   1244  CA  GLN B  45      23.591  37.362  -0.846  1.00  6.50           C  
ATOM   1245  C   GLN B  45      23.757  35.854  -0.666  1.00  5.45           C  
ATOM   1246  O   GLN B  45      24.832  35.380  -0.306  1.00  5.98           O  
ATOM   1247  CB  GLN B  45      22.995  37.991   0.419  1.00  4.98           C  
ATOM   1248  CG  GLN B  45      23.080  39.522   0.433  1.00  6.15           C  
ATOM   1249  CD  GLN B  45      22.426  40.151   1.648  1.00  5.89           C  
ATOM   1250  OE1 GLN B  45      21.303  39.807   2.008  1.00  4.86           O  
ATOM   1251  NE2 GLN B  45      23.120  41.091   2.277  1.00  7.60           N  
ATOM   1252  N   GLN B  46      22.695  35.098  -0.917  1.00  5.86           N  
ATOM   1253  CA  GLN B  46      22.763  33.646  -0.784  1.00  5.38           C  
ATOM   1254  C   GLN B  46      23.730  33.102  -1.824  1.00  7.33           C  
ATOM   1255  O   GLN B  46      24.552  32.226  -1.541  1.00  7.20           O  
ATOM   1256  CB  GLN B  46      21.380  33.038  -0.994  1.00  5.62           C  
ATOM   1257  CG  GLN B  46      20.376  33.465   0.055  1.00  5.92           C  
ATOM   1258  CD  GLN B  46      18.988  32.944  -0.233  1.00  6.14           C  
ATOM   1259  OE1 GLN B  46      18.811  31.767  -0.533  1.00  9.39           O  
ATOM   1260  NE2 GLN B  46      17.994  33.819  -0.137  1.00  6.56           N  
ATOM   1261  N   GLN B  47      23.620  33.631  -3.036  1.00  5.51           N  
ATOM   1262  CA  GLN B  47      24.485  33.216  -4.129  1.00  6.86           C  
ATOM   1263  C   GLN B  47      25.929  33.621  -3.843  1.00  5.70           C  
ATOM   1264  O   GLN B  47      26.854  32.832  -4.040  1.00  6.42           O  
ATOM   1265  CB  GLN B  47      24.003  33.851  -5.434  1.00  9.64           C  
ATOM   1266  CG  GLN B  47      22.690  33.275  -5.938  1.00 14.82           C  
ATOM   1267  CD  GLN B  47      22.073  34.108  -7.048  1.00 18.09           C  
ATOM   1268  OE1 GLN B  47      22.770  34.570  -7.950  1.00 22.28           O  
ATOM   1269  NE2 GLN B  47      20.758  34.293  -6.993  1.00 19.98           N  
ATOM   1270  N   ASP B  48      26.121  34.847  -3.365  1.00  6.42           N  
ATOM   1271  CA  ASP B  48      27.464  35.326  -3.056  1.00  5.96           C  
ATOM   1272  C   ASP B  48      28.154  34.493  -1.987  1.00  6.68           C  
ATOM   1273  O   ASP B  48      29.331  34.162  -2.120  1.00  7.79           O  
ATOM   1274  CB  ASP B  48      27.447  36.785  -2.585  1.00  7.77           C  
ATOM   1275  CG  ASP B  48      27.328  37.774  -3.726  1.00  9.74           C  
ATOM   1276  OD1 ASP B  48      27.534  37.385  -4.893  1.00 13.37           O  
ATOM   1277  OD2 ASP B  48      27.042  38.951  -3.446  1.00 12.35           O  
ATOM   1278  N   MET B  49      27.435  34.158  -0.917  1.00  6.81           N  
ATOM   1279  CA  MET B  49      28.054  33.385   0.154  1.00  6.21           C  
ATOM   1280  C   MET B  49      28.366  31.964  -0.279  1.00  4.74           C  
ATOM   1281  O   MET B  49      29.372  31.401   0.131  1.00  4.51           O  
ATOM   1282  CB  MET B  49      27.174  33.376   1.410  1.00  6.93           C  
ATOM   1283  CG  MET B  49      27.854  32.750   2.630  1.00  7.74           C  
ATOM   1284  SD  MET B  49      29.413  33.568   3.132  1.00  2.81           S  
ATOM   1285  CE  MET B  49      28.788  34.879   4.157  1.00 11.47           C  
ATOM   1286  N   ALA B  50      27.512  31.380  -1.114  1.00  4.99           N  
ATOM   1287  CA  ALA B  50      27.770  30.029  -1.586  1.00  6.35           C  
ATOM   1288  C   ALA B  50      29.046  30.068  -2.424  1.00  6.15           C  
ATOM   1289  O   ALA B  50      29.912  29.207  -2.292  1.00  6.82           O  
ATOM   1290  CB  ALA B  50      26.599  29.524  -2.423  1.00  8.04           C  
ATOM   1291  N   GLN B  51      29.166  31.084  -3.271  1.00  5.96           N  
ATOM   1292  CA  GLN B  51      30.343  31.224  -4.118  1.00  6.89           C  
ATOM   1293  C   GLN B  51      31.579  31.498  -3.270  1.00  5.79           C  
ATOM   1294  O   GLN B  51      32.668  31.005  -3.565  1.00  7.04           O  
ATOM   1295  CB  GLN B  51      30.148  32.356  -5.127  1.00  8.68           C  
ATOM   1296  CG  GLN B  51      31.388  32.634  -5.962  1.00 11.57           C  
ATOM   1297  CD  GLN B  51      31.131  33.607  -7.095  1.00 14.53           C  
ATOM   1298  OE1 GLN B  51      30.424  34.601  -6.931  1.00 15.38           O  
ATOM   1299  NE2 GLN B  51      31.721  33.331  -8.256  1.00 18.69           N  
ATOM   1300  N   PHE B  52      31.403  32.282  -2.211  1.00  4.19           N  
ATOM   1301  CA  PHE B  52      32.507  32.606  -1.319  1.00  4.60           C  
ATOM   1302  C   PHE B  52      33.082  31.319  -0.724  1.00  5.08           C  
ATOM   1303  O   PHE B  52      34.297  31.123  -0.693  1.00  4.38           O  
ATOM   1304  CB  PHE B  52      32.012  33.527  -0.199  1.00  4.92           C  
ATOM   1305  CG  PHE B  52      33.090  33.991   0.734  1.00  8.00           C  
ATOM   1306  CD1 PHE B  52      33.929  35.047   0.384  1.00  7.09           C  
ATOM   1307  CD2 PHE B  52      33.258  33.385   1.976  1.00  6.76           C  
ATOM   1308  CE1 PHE B  52      34.917  35.496   1.260  1.00  8.10           C  
ATOM   1309  CE2 PHE B  52      34.245  33.827   2.858  1.00  6.65           C  
ATOM   1310  CZ  PHE B  52      35.074  34.885   2.499  1.00  8.03           C  
ATOM   1311  N   ILE B  53      32.203  30.444  -0.252  1.00  4.16           N  
ATOM   1312  CA  ILE B  53      32.641  29.188   0.340  1.00  5.24           C  
ATOM   1313  C   ILE B  53      33.342  28.334  -0.714  1.00  5.39           C  
ATOM   1314  O   ILE B  53      34.346  27.678  -0.435  1.00  6.10           O  
ATOM   1315  CB  ILE B  53      31.451  28.413   0.947  1.00  6.24           C  
ATOM   1316  CG1 ILE B  53      30.886  29.185   2.146  1.00  4.65           C  
ATOM   1317  CG2 ILE B  53      31.895  27.019   1.379  1.00  4.86           C  
ATOM   1318  CD1 ILE B  53      31.855  29.316   3.325  1.00 10.19           C  
ATOM   1319  N   HIS B  54      32.827  28.347  -1.938  1.00  5.87           N  
ATOM   1320  CA  HIS B  54      33.458  27.560  -2.989  1.00  5.42           C  
ATOM   1321  C   HIS B  54      34.855  28.056  -3.330  1.00  5.00           C  
ATOM   1322  O   HIS B  54      35.790  27.265  -3.426  1.00  5.66           O  
ATOM   1323  CB  HIS B  54      32.578  27.536  -4.235  1.00  6.86           C  
ATOM   1324  CG  HIS B  54      31.415  26.608  -4.110  1.00 12.72           C  
ATOM   1325  ND1 HIS B  54      31.567  25.280  -3.775  1.00 14.74           N  
ATOM   1326  CD2 HIS B  54      30.084  26.817  -4.232  1.00 14.88           C  
ATOM   1327  CE1 HIS B  54      30.379  24.711  -3.693  1.00 14.93           C  
ATOM   1328  NE2 HIS B  54      29.462  25.621  -3.966  1.00 15.10           N  
ATOM   1329  N   ILE B  55      35.002  29.364  -3.506  1.00  4.82           N  
ATOM   1330  CA  ILE B  55      36.302  29.925  -3.828  1.00  3.87           C  
ATOM   1331  C   ILE B  55      37.232  29.708  -2.631  1.00  4.18           C  
ATOM   1332  O   ILE B  55      38.409  29.396  -2.789  1.00  2.81           O  
ATOM   1333  CB  ILE B  55      36.183  31.425  -4.160  1.00  4.28           C  
ATOM   1334  CG1 ILE B  55      35.341  31.601  -5.430  1.00  3.39           C  
ATOM   1335  CG2 ILE B  55      37.564  32.031  -4.355  1.00  4.94           C  
ATOM   1336  CD1 ILE B  55      35.017  33.048  -5.759  1.00  2.87           C  
ATOM   1337  N   PHE B  56      36.694  29.867  -1.429  1.00  4.08           N  
ATOM   1338  CA  PHE B  56      37.492  29.662  -0.229  1.00  4.94           C  
ATOM   1339  C   PHE B  56      38.115  28.262  -0.257  1.00  6.12           C  
ATOM   1340  O   PHE B  56      39.311  28.097  -0.000  1.00  5.30           O  
ATOM   1341  CB  PHE B  56      36.608  29.808   1.015  1.00  5.13           C  
ATOM   1342  CG  PHE B  56      37.256  29.317   2.277  1.00  5.21           C  
ATOM   1343  CD1 PHE B  56      38.146  30.123   2.980  1.00  5.19           C  
ATOM   1344  CD2 PHE B  56      36.998  28.031   2.742  1.00  4.98           C  
ATOM   1345  CE1 PHE B  56      38.771  29.651   4.131  1.00  7.38           C  
ATOM   1346  CE2 PHE B  56      37.615  27.548   3.886  1.00  3.92           C  
ATOM   1347  CZ  PHE B  56      38.506  28.359   4.586  1.00  6.23           C  
ATOM   1348  N   SER B  57      37.299  27.262  -0.586  1.00  6.04           N  
ATOM   1349  CA  SER B  57      37.746  25.873  -0.610  1.00  6.50           C  
ATOM   1350  C   SER B  57      38.845  25.601  -1.623  1.00  7.22           C  
ATOM   1351  O   SER B  57      39.582  24.624  -1.497  1.00  5.41           O  
ATOM   1352  CB  SER B  57      36.566  24.935  -0.880  1.00  6.50           C  
ATOM   1353  OG  SER B  57      36.191  24.944  -2.247  1.00  6.07           O  
ATOM   1354  N   LYS B  58      38.952  26.464  -2.629  1.00  8.40           N  
ATOM   1355  CA  LYS B  58      39.973  26.309  -3.657  1.00  7.71           C  
ATOM   1356  C   LYS B  58      41.283  26.989  -3.277  1.00  8.30           C  
ATOM   1357  O   LYS B  58      42.352  26.572  -3.714  1.00  8.73           O  
ATOM   1358  CB  LYS B  58      39.492  26.907  -4.981  1.00  9.92           C  
ATOM   1359  CG  LYS B  58      38.277  26.224  -5.588  1.00 11.57           C  
ATOM   1360  CD  LYS B  58      37.854  26.947  -6.864  1.00 15.59           C  
ATOM   1361  CE  LYS B  58      36.542  26.410  -7.406  1.00 18.69           C  
ATOM   1362  NZ  LYS B  58      36.076  27.190  -8.596  1.00 21.44           N  
ATOM   1363  N   PHE B  59      41.201  28.031  -2.455  1.00  6.87           N  
ATOM   1364  CA  PHE B  59      42.394  28.780  -2.077  1.00  7.33           C  
ATOM   1365  C   PHE B  59      42.867  28.724  -0.632  1.00  7.54           C  
ATOM   1366  O   PHE B  59      43.902  29.312  -0.310  1.00  6.97           O  
ATOM   1367  CB  PHE B  59      42.226  30.247  -2.478  1.00  7.19           C  
ATOM   1368  CG  PHE B  59      42.161  30.461  -3.961  1.00  8.80           C  
ATOM   1369  CD1 PHE B  59      40.983  30.876  -4.570  1.00  9.98           C  
ATOM   1370  CD2 PHE B  59      43.280  30.234  -4.755  1.00  9.79           C  
ATOM   1371  CE1 PHE B  59      40.924  31.063  -5.952  1.00 13.59           C  
ATOM   1372  CE2 PHE B  59      43.231  30.418  -6.132  1.00 10.60           C  
ATOM   1373  CZ  PHE B  59      42.055  30.833  -6.732  1.00 10.89           C  
ATOM   1374  N   TYR B  60      42.140  28.036   0.244  1.00  7.11           N  
ATOM   1375  CA  TYR B  60      42.587  27.965   1.637  1.00  7.22           C  
ATOM   1376  C   TYR B  60      44.058  27.528   1.628  1.00  9.05           C  
ATOM   1377  O   TYR B  60      44.393  26.488   1.066  1.00  8.23           O  
ATOM   1378  CB  TYR B  60      41.732  26.974   2.431  1.00  7.05           C  
ATOM   1379  CG  TYR B  60      42.098  26.924   3.897  1.00  6.01           C  
ATOM   1380  CD1 TYR B  60      41.954  28.047   4.709  1.00  5.74           C  
ATOM   1381  CD2 TYR B  60      42.630  25.769   4.461  1.00  7.75           C  
ATOM   1382  CE1 TYR B  60      42.337  28.022   6.047  1.00  5.12           C  
ATOM   1383  CE2 TYR B  60      43.016  25.733   5.797  1.00  7.38           C  
ATOM   1384  CZ  TYR B  60      42.869  26.862   6.583  1.00  6.63           C  
ATOM   1385  OH  TYR B  60      43.269  26.830   7.900  1.00  6.75           O  
ATOM   1386  N   PRO B  61      44.946  28.331   2.250  1.00 10.14           N  
ATOM   1387  CA  PRO B  61      46.404  28.200   2.403  1.00 12.87           C  
ATOM   1388  C   PRO B  61      47.037  26.921   2.951  1.00 14.70           C  
ATOM   1389  O   PRO B  61      48.207  26.934   3.332  1.00 18.41           O  
ATOM   1390  CB  PRO B  61      46.771  29.405   3.267  1.00 13.32           C  
ATOM   1391  CG  PRO B  61      45.722  30.387   2.948  1.00 12.44           C  
ATOM   1392  CD  PRO B  61      44.485  29.545   2.944  1.00  9.11           C  
ATOM   1393  N   CYS B  62      46.285  25.835   3.025  1.00 14.24           N  
ATOM   1394  CA  CYS B  62      46.846  24.569   3.486  1.00 14.43           C  
ATOM   1395  C   CYS B  62      46.343  23.510   2.518  1.00 14.50           C  
ATOM   1396  O   CYS B  62      45.178  23.113   2.556  1.00 13.96           O  
ATOM   1397  CB  CYS B  62      46.431  24.251   4.936  1.00 14.72           C  
ATOM   1398  SG  CYS B  62      46.470  22.466   5.311  1.00 17.40           S  
ATOM   1399  N   GLU B  63      47.238  23.085   1.629  1.00 15.04           N  
ATOM   1400  CA  GLU B  63      46.930  22.103   0.597  1.00 14.03           C  
ATOM   1401  C   GLU B  63      46.105  20.915   1.068  1.00 13.28           C  
ATOM   1402  O   GLU B  63      45.009  20.678   0.566  1.00 10.18           O  
ATOM   1403  CB  GLU B  63      48.226  21.610  -0.053  1.00 15.97           C  
ATOM   1404  CG  GLU B  63      48.006  20.761  -1.293  1.00 18.68           C  
ATOM   1405  CD  GLU B  63      49.282  20.535  -2.083  1.00 20.31           C  
ATOM   1406  OE1 GLU B  63      50.187  19.838  -1.579  1.00 21.51           O  
ATOM   1407  OE2 GLU B  63      49.377  21.062  -3.213  1.00 23.33           O  
ATOM   1408  N   GLU B  64      46.636  20.155   2.020  1.00 13.90           N  
ATOM   1409  CA  GLU B  64      45.925  18.995   2.537  1.00 13.76           C  
ATOM   1410  C   GLU B  64      44.561  19.382   3.104  1.00 12.91           C  
ATOM   1411  O   GLU B  64      43.578  18.666   2.926  1.00 11.77           O  
ATOM   1412  CB  GLU B  64      46.765  18.302   3.615  1.00 17.63           C  
ATOM   1413  CG  GLU B  64      46.000  17.269   4.424  1.00 21.56           C  
ATOM   1414  CD  GLU B  64      46.898  16.464   5.338  1.00 24.33           C  
ATOM   1415  OE1 GLU B  64      47.744  17.069   6.030  1.00 24.99           O  
ATOM   1416  OE2 GLU B  64      46.752  15.224   5.369  1.00 27.99           O  
ATOM   1417  N   CYS B  65      44.504  20.521   3.781  1.00 12.39           N  
ATOM   1418  CA  CYS B  65      43.254  20.984   4.367  1.00 10.97           C  
ATOM   1419  C   CYS B  65      42.229  21.335   3.296  1.00 11.06           C  
ATOM   1420  O   CYS B  65      41.057  20.977   3.403  1.00  9.01           O  
ATOM   1421  CB  CYS B  65      43.487  22.229   5.212  1.00 13.79           C  
ATOM   1422  SG  CYS B  65      44.817  22.189   6.452  1.00 14.34           S  
ATOM   1423  N   ALA B  66      42.673  22.055   2.271  1.00  9.30           N  
ATOM   1424  CA  ALA B  66      41.779  22.467   1.195  1.00 10.56           C  
ATOM   1425  C   ALA B  66      41.243  21.266   0.423  1.00  9.89           C  
ATOM   1426  O   ALA B  66      40.069  21.213   0.071  1.00  9.70           O  
ATOM   1427  CB  ALA B  66      42.504  23.425   0.251  1.00  9.95           C  
ATOM   1428  N   GLU B  67      42.102  20.290   0.164  1.00 11.41           N  
ATOM   1429  CA  GLU B  67      41.657  19.113  -0.567  1.00 11.93           C  
ATOM   1430  C   GLU B  67      40.586  18.383   0.236  1.00 11.10           C  
ATOM   1431  O   GLU B  67      39.588  17.924  -0.315  1.00 11.73           O  
ATOM   1432  CB  GLU B  67      42.842  18.189  -0.849  1.00 14.25           C  
ATOM   1433  CG  GLU B  67      43.981  18.890  -1.576  1.00 15.16           C  
ATOM   1434  CD  GLU B  67      45.140  17.963  -1.884  1.00 15.97           C  
ATOM   1435  OE1 GLU B  67      45.457  17.106  -1.034  1.00 17.68           O  
ATOM   1436  OE2 GLU B  67      45.743  18.106  -2.967  1.00 16.11           O  
ATOM   1437  N   ASP B  68      40.783  18.298   1.547  1.00 12.80           N  
ATOM   1438  CA  ASP B  68      39.826  17.616   2.409  1.00 12.91           C  
ATOM   1439  C   ASP B  68      38.507  18.376   2.488  1.00 12.47           C  
ATOM   1440  O   ASP B  68      37.433  17.784   2.381  1.00 10.20           O  
ATOM   1441  CB  ASP B  68      40.410  17.437   3.818  1.00 15.23           C  
ATOM   1442  CG  ASP B  68      39.388  16.901   4.816  1.00 17.72           C  
ATOM   1443  OD1 ASP B  68      38.570  17.693   5.333  1.00 17.48           O  
ATOM   1444  OD2 ASP B  68      39.394  15.683   5.079  1.00 18.25           O  
ATOM   1445  N   ILE B  69      38.586  19.691   2.661  1.00 11.43           N  
ATOM   1446  CA  ILE B  69      37.378  20.496   2.775  1.00 10.13           C  
ATOM   1447  C   ILE B  69      36.565  20.519   1.480  1.00 10.78           C  
ATOM   1448  O   ILE B  69      35.335  20.553   1.520  1.00 11.02           O  
ATOM   1449  CB  ILE B  69      37.713  21.947   3.238  1.00  8.35           C  
ATOM   1450  CG1 ILE B  69      36.584  22.477   4.122  1.00  9.97           C  
ATOM   1451  CG2 ILE B  69      37.914  22.864   2.045  1.00  9.02           C  
ATOM   1452  CD1 ILE B  69      36.507  21.799   5.480  1.00 10.45           C  
ATOM   1453  N   ARG B  70      37.241  20.490   0.333  1.00 10.66           N  
ATOM   1454  CA  ARG B  70      36.537  20.486  -0.946  1.00 10.28           C  
ATOM   1455  C   ARG B  70      35.717  19.204  -1.075  1.00 10.87           C  
ATOM   1456  O   ARG B  70      34.599  19.214  -1.594  1.00  9.68           O  
ATOM   1457  CB  ARG B  70      37.522  20.591  -2.116  1.00 10.31           C  
ATOM   1458  CG  ARG B  70      38.087  21.988  -2.343  1.00 10.31           C  
ATOM   1459  CD  ARG B  70      38.731  22.109  -3.720  1.00 10.45           C  
ATOM   1460  NE  ARG B  70      39.958  21.325  -3.849  1.00  9.68           N  
ATOM   1461  CZ  ARG B  70      41.153  21.729  -3.432  1.00 10.57           C  
ATOM   1462  NH1 ARG B  70      41.297  22.916  -2.852  1.00  8.66           N  
ATOM   1463  NH2 ARG B  70      42.214  20.949  -3.606  1.00 12.88           N  
ATOM   1464  N   LYS B  71      36.275  18.098  -0.595  1.00 11.33           N  
ATOM   1465  CA  LYS B  71      35.580  16.819  -0.658  1.00 13.28           C  
ATOM   1466  C   LYS B  71      34.313  16.849   0.194  1.00 11.15           C  
ATOM   1467  O   LYS B  71      33.257  16.372  -0.226  1.00 11.07           O  
ATOM   1468  CB  LYS B  71      36.502  15.696  -0.178  1.00 15.82           C  
ATOM   1469  CG  LYS B  71      37.803  15.593  -0.963  1.00 20.59           C  
ATOM   1470  CD  LYS B  71      38.698  14.463  -0.455  1.00 24.70           C  
ATOM   1471  CE  LYS B  71      38.123  13.087  -0.774  1.00 26.61           C  
ATOM   1472  NZ  LYS B  71      36.859  12.795  -0.043  1.00 29.85           N  
ATOM   1473  N   ARG B  72      34.415  17.423   1.388  1.00 11.11           N  
ATOM   1474  CA  ARG B  72      33.270  17.498   2.288  1.00  9.96           C  
ATOM   1475  C   ARG B  72      32.189  18.424   1.742  1.00  9.99           C  
ATOM   1476  O   ARG B  72      31.001  18.135   1.859  1.00  9.30           O  
ATOM   1477  CB  ARG B  72      33.717  17.966   3.678  1.00  9.98           C  
ATOM   1478  CG  ARG B  72      34.749  17.044   4.321  1.00 10.04           C  
ATOM   1479  CD  ARG B  72      35.115  17.461   5.743  1.00  8.45           C  
ATOM   1480  NE  ARG B  72      36.227  16.661   6.249  1.00 10.85           N  
ATOM   1481  CZ  ARG B  72      36.145  15.369   6.557  1.00 11.93           C  
ATOM   1482  NH1 ARG B  72      34.997  14.718   6.425  1.00 11.58           N  
ATOM   1483  NH2 ARG B  72      37.225  14.715   6.970  1.00 14.38           N  
ATOM   1484  N   ILE B  73      32.604  19.534   1.141  1.00 10.23           N  
ATOM   1485  CA  ILE B  73      31.656  20.486   0.581  1.00 11.22           C  
ATOM   1486  C   ILE B  73      30.935  19.871  -0.616  1.00 12.89           C  
ATOM   1487  O   ILE B  73      29.742  20.103  -0.824  1.00 12.17           O  
ATOM   1488  CB  ILE B  73      32.369  21.782   0.141  1.00 12.11           C  
ATOM   1489  CG1 ILE B  73      32.906  22.516   1.372  1.00 10.97           C  
ATOM   1490  CG2 ILE B  73      31.404  22.683  -0.634  1.00 11.34           C  
ATOM   1491  CD1 ILE B  73      33.795  23.696   1.050  1.00 14.50           C  
ATOM   1492  N   ASP B  74      31.660  19.081  -1.401  1.00 13.35           N  
ATOM   1493  CA  ASP B  74      31.059  18.444  -2.563  1.00 15.87           C  
ATOM   1494  C   ASP B  74      29.966  17.491  -2.098  1.00 15.24           C  
ATOM   1495  O   ASP B  74      28.933  17.349  -2.750  1.00 17.47           O  
ATOM   1496  CB  ASP B  74      32.115  17.680  -3.363  1.00 17.42           C  
ATOM   1497  CG  ASP B  74      31.629  17.301  -4.748  1.00 22.23           C  
ATOM   1498  OD1 ASP B  74      31.259  18.213  -5.513  1.00 24.21           O  
ATOM   1499  OD2 ASP B  74      31.617  16.097  -5.071  1.00 23.83           O  
ATOM   1500  N   ARG B  75      30.186  16.846  -0.958  1.00 14.91           N  
ATOM   1501  CA  ARG B  75      29.199  15.915  -0.430  1.00 15.04           C  
ATOM   1502  C   ARG B  75      27.987  16.665   0.109  1.00 13.74           C  
ATOM   1503  O   ARG B  75      26.845  16.235  -0.075  1.00 13.10           O  
ATOM   1504  CB  ARG B  75      29.823  15.059   0.672  1.00 17.20           C  
ATOM   1505  CG  ARG B  75      28.869  14.061   1.302  1.00 21.63           C  
ATOM   1506  CD  ARG B  75      29.636  13.081   2.176  1.00 25.36           C  
ATOM   1507  NE  ARG B  75      30.521  13.777   3.103  1.00 28.73           N  
ATOM   1508  CZ  ARG B  75      31.407  13.175   3.891  1.00 30.72           C  
ATOM   1509  NH1 ARG B  75      31.533  11.852   3.870  1.00 31.07           N  
ATOM   1510  NH2 ARG B  75      32.171  13.897   4.699  1.00 31.27           N  
ATOM   1511  N   SER B  76      28.237  17.792   0.769  1.00 11.53           N  
ATOM   1512  CA  SER B  76      27.163  18.604   1.328  1.00 10.82           C  
ATOM   1513  C   SER B  76      27.405  20.083   1.047  1.00  9.90           C  
ATOM   1514  O   SER B  76      28.122  20.761   1.785  1.00  8.83           O  
ATOM   1515  CB  SER B  76      27.051  18.374   2.835  1.00 11.41           C  
ATOM   1516  OG  SER B  76      25.981  19.127   3.375  1.00 15.21           O  
ATOM   1517  N   GLN B  77      26.793  20.572  -0.028  1.00  9.85           N  
ATOM   1518  CA  GLN B  77      26.928  21.965  -0.443  1.00  9.98           C  
ATOM   1519  C   GLN B  77      26.436  22.925   0.632  1.00 10.22           C  
ATOM   1520  O   GLN B  77      25.511  22.616   1.378  1.00  9.62           O  
ATOM   1521  CB  GLN B  77      26.140  22.199  -1.734  1.00 11.68           C  
ATOM   1522  CG  GLN B  77      26.655  21.412  -2.932  1.00 14.00           C  
ATOM   1523  CD  GLN B  77      28.060  21.816  -3.319  1.00 15.54           C  
ATOM   1524  OE1 GLN B  77      28.530  22.885  -2.941  1.00 14.43           O  
ATOM   1525  NE2 GLN B  77      28.739  20.966  -4.087  1.00 15.11           N  
ATOM   1526  N   PRO B  78      27.046  24.114   0.720  1.00 10.18           N  
ATOM   1527  CA  PRO B  78      26.622  25.081   1.735  1.00  9.47           C  
ATOM   1528  C   PRO B  78      25.177  25.535   1.577  1.00  9.37           C  
ATOM   1529  O   PRO B  78      24.731  25.827   0.470  1.00 11.23           O  
ATOM   1530  CB  PRO B  78      27.617  26.228   1.554  1.00 10.84           C  
ATOM   1531  CG  PRO B  78      27.946  26.164   0.096  1.00 10.69           C  
ATOM   1532  CD  PRO B  78      28.109  24.678  -0.133  1.00 12.39           C  
ATOM   1533  N   ASP B  79      24.446  25.566   2.686  1.00  8.47           N  
ATOM   1534  CA  ASP B  79      23.063  26.024   2.677  1.00  8.88           C  
ATOM   1535  C   ASP B  79      23.114  27.458   3.190  1.00  8.72           C  
ATOM   1536  O   ASP B  79      23.209  27.692   4.393  1.00  8.07           O  
ATOM   1537  CB  ASP B  79      22.193  25.173   3.606  1.00 11.54           C  
ATOM   1538  CG  ASP B  79      20.725  25.539   3.521  1.00 13.65           C  
ATOM   1539  OD1 ASP B  79      20.410  26.645   3.036  1.00 15.30           O  
ATOM   1540  OD2 ASP B  79      19.881  24.727   3.951  1.00 18.29           O  
ATOM   1541  N   THR B  80      23.062  28.412   2.269  1.00  7.79           N  
ATOM   1542  CA  THR B  80      23.137  29.822   2.624  1.00  6.54           C  
ATOM   1543  C   THR B  80      21.782  30.517   2.637  1.00  6.51           C  
ATOM   1544  O   THR B  80      21.713  31.746   2.642  1.00  4.64           O  
ATOM   1545  CB  THR B  80      24.066  30.580   1.651  1.00  6.22           C  
ATOM   1546  OG1 THR B  80      23.555  30.478   0.313  1.00  7.34           O  
ATOM   1547  CG2 THR B  80      25.479  29.988   1.697  1.00  7.11           C  
ATOM   1548  N   SER B  81      20.709  29.734   2.669  1.00  7.76           N  
ATOM   1549  CA  SER B  81      19.363  30.299   2.657  1.00  8.98           C  
ATOM   1550  C   SER B  81      19.096  31.277   3.793  1.00  7.85           C  
ATOM   1551  O   SER B  81      18.427  32.290   3.594  1.00  8.69           O  
ATOM   1552  CB  SER B  81      18.318  29.176   2.694  1.00 11.23           C  
ATOM   1553  OG  SER B  81      18.435  28.409   3.876  1.00 15.44           O  
ATOM   1554  N   THR B  82      19.614  30.979   4.982  1.00  6.58           N  
ATOM   1555  CA  THR B  82      19.401  31.847   6.140  1.00  7.15           C  
ATOM   1556  C   THR B  82      20.601  31.837   7.076  1.00  7.35           C  
ATOM   1557  O   THR B  82      21.522  31.036   6.908  1.00  6.57           O  
ATOM   1558  CB  THR B  82      18.173  31.394   6.939  1.00  7.56           C  
ATOM   1559  OG1 THR B  82      18.435  30.117   7.535  1.00  6.51           O  
ATOM   1560  CG2 THR B  82      16.974  31.276   6.024  1.00  9.47           C  
ATOM   1561  N   ARG B  83      20.588  32.728   8.064  1.00  6.49           N  
ATOM   1562  CA  ARG B  83      21.682  32.796   9.024  1.00  5.78           C  
ATOM   1563  C   ARG B  83      21.789  31.482   9.796  1.00  6.90           C  
ATOM   1564  O   ARG B  83      22.888  30.968  10.001  1.00  6.80           O  
ATOM   1565  CB  ARG B  83      21.473  33.950  10.012  1.00  5.48           C  
ATOM   1566  CG  ARG B  83      22.674  34.215  10.922  1.00  5.46           C  
ATOM   1567  CD  ARG B  83      22.313  35.192  12.032  1.00  5.79           C  
ATOM   1568  NE  ARG B  83      21.604  34.513  13.110  1.00  6.48           N  
ATOM   1569  CZ  ARG B  83      22.210  33.839  14.083  1.00  7.31           C  
ATOM   1570  NH1 ARG B  83      23.531  33.768  14.109  1.00  6.26           N  
ATOM   1571  NH2 ARG B  83      21.501  33.222  15.018  1.00  4.85           N  
ATOM   1572  N   VAL B  84      20.657  30.935  10.232  1.00  6.43           N  
ATOM   1573  CA  VAL B  84      20.709  29.683  10.981  1.00  7.57           C  
ATOM   1574  C   VAL B  84      21.109  28.498  10.111  1.00  7.62           C  
ATOM   1575  O   VAL B  84      21.878  27.645  10.551  1.00  5.89           O  
ATOM   1576  CB  VAL B  84      19.370  29.368  11.684  1.00  8.06           C  
ATOM   1577  CG1 VAL B  84      19.098  30.414  12.752  1.00  7.80           C  
ATOM   1578  CG2 VAL B  84      18.238  29.330  10.677  1.00 10.55           C  
ATOM   1579  N   SER B  85      20.606  28.439   8.881  1.00  7.11           N  
ATOM   1580  CA  SER B  85      20.963  27.324   8.015  1.00  5.99           C  
ATOM   1581  C   SER B  85      22.456  27.372   7.716  1.00  5.65           C  
ATOM   1582  O   SER B  85      23.126  26.341   7.740  1.00  5.23           O  
ATOM   1583  CB  SER B  85      20.166  27.358   6.701  1.00  7.20           C  
ATOM   1584  OG  SER B  85      20.673  28.335   5.805  1.00  8.54           O  
ATOM   1585  N   PHE B  86      22.978  28.570   7.457  1.00  5.64           N  
ATOM   1586  CA  PHE B  86      24.393  28.730   7.138  1.00  4.95           C  
ATOM   1587  C   PHE B  86      25.300  28.530   8.347  1.00  4.00           C  
ATOM   1588  O   PHE B  86      26.285  27.796   8.274  1.00  4.15           O  
ATOM   1589  CB  PHE B  86      24.641  30.107   6.495  1.00  5.24           C  
ATOM   1590  CG  PHE B  86      26.069  30.332   6.066  1.00  8.11           C  
ATOM   1591  CD1 PHE B  86      26.737  29.383   5.296  1.00  7.66           C  
ATOM   1592  CD2 PHE B  86      26.749  31.487   6.442  1.00  8.59           C  
ATOM   1593  CE1 PHE B  86      28.065  29.583   4.909  1.00 10.00           C  
ATOM   1594  CE2 PHE B  86      28.075  31.698   6.062  1.00  8.41           C  
ATOM   1595  CZ  PHE B  86      28.735  30.741   5.293  1.00  8.51           C  
ATOM   1596  N   SER B  87      24.967  29.162   9.469  1.00  3.51           N  
ATOM   1597  CA  SER B  87      25.778  29.008  10.667  1.00  4.40           C  
ATOM   1598  C   SER B  87      25.847  27.535  11.089  1.00  4.01           C  
ATOM   1599  O   SER B  87      26.897  27.059  11.530  1.00  4.97           O  
ATOM   1600  CB  SER B  87      25.211  29.864  11.810  1.00  5.60           C  
ATOM   1601  OG  SER B  87      23.881  29.484  12.132  1.00  9.22           O  
ATOM   1602  N   GLN B  88      24.738  26.808  10.953  1.00  3.98           N  
ATOM   1603  CA  GLN B  88      24.733  25.398  11.332  1.00  3.16           C  
ATOM   1604  C   GLN B  88      25.470  24.539  10.313  1.00  4.81           C  
ATOM   1605  O   GLN B  88      26.164  23.589  10.677  1.00  2.81           O  
ATOM   1606  CB  GLN B  88      23.298  24.893  11.516  1.00  3.74           C  
ATOM   1607  CG  GLN B  88      22.603  25.528  12.703  1.00  3.35           C  
ATOM   1608  CD  GLN B  88      23.332  25.262  14.011  1.00  5.55           C  
ATOM   1609  OE1 GLN B  88      23.202  26.020  14.973  1.00  8.91           O  
ATOM   1610  NE2 GLN B  88      24.095  24.178  14.054  1.00  2.81           N  
ATOM   1611  N   TRP B  89      25.317  24.862   9.035  1.00  5.59           N  
ATOM   1612  CA  TRP B  89      26.009  24.104   8.002  1.00  4.64           C  
ATOM   1613  C   TRP B  89      27.507  24.184   8.273  1.00  3.91           C  
ATOM   1614  O   TRP B  89      28.228  23.183   8.199  1.00  3.03           O  
ATOM   1615  CB  TRP B  89      25.714  24.686   6.615  1.00  6.48           C  
ATOM   1616  CG  TRP B  89      26.508  24.026   5.534  1.00  6.61           C  
ATOM   1617  CD1 TRP B  89      26.204  22.864   4.881  1.00  6.61           C  
ATOM   1618  CD2 TRP B  89      27.783  24.445   5.037  1.00  6.50           C  
ATOM   1619  NE1 TRP B  89      27.216  22.531   4.011  1.00  7.11           N  
ATOM   1620  CE2 TRP B  89      28.198  23.484   4.088  1.00  7.00           C  
ATOM   1621  CE3 TRP B  89      28.622  25.537   5.305  1.00  5.71           C  
ATOM   1622  CZ2 TRP B  89      29.414  23.582   3.404  1.00  6.83           C  
ATOM   1623  CZ3 TRP B  89      29.834  25.632   4.626  1.00  6.22           C  
ATOM   1624  CH2 TRP B  89      30.217  24.658   3.687  1.00  6.03           C  
ATOM   1625  N   LEU B  90      27.965  25.385   8.614  1.00  3.48           N  
ATOM   1626  CA  LEU B  90      29.374  25.625   8.891  1.00  4.67           C  
ATOM   1627  C   LEU B  90      29.819  24.932  10.171  1.00  4.03           C  
ATOM   1628  O   LEU B  90      30.945  24.442  10.262  1.00  4.74           O  
ATOM   1629  CB  LEU B  90      29.636  27.125   8.988  1.00  4.98           C  
ATOM   1630  CG  LEU B  90      31.086  27.569   9.170  1.00  7.24           C  
ATOM   1631  CD1 LEU B  90      31.940  27.046   8.018  1.00  7.61           C  
ATOM   1632  CD2 LEU B  90      31.134  29.094   9.230  1.00  9.82           C  
ATOM   1633  N   CYS B  91      28.944  24.897  11.169  1.00  4.74           N  
ATOM   1634  CA  CYS B  91      29.285  24.227  12.413  1.00  3.94           C  
ATOM   1635  C   CYS B  91      29.446  22.734  12.137  1.00  5.29           C  
ATOM   1636  O   CYS B  91      30.386  22.099  12.623  1.00  4.42           O  
ATOM   1637  CB  CYS B  91      28.196  24.443  13.467  1.00  3.84           C  
ATOM   1638  SG  CYS B  91      28.598  23.668  15.068  1.00  5.92           S  
ATOM   1639  N   ARG B  92      28.538  22.177  11.341  1.00  4.73           N  
ATOM   1640  CA  ARG B  92      28.613  20.756  11.024  1.00  4.52           C  
ATOM   1641  C   ARG B  92      29.869  20.447  10.229  1.00  4.02           C  
ATOM   1642  O   ARG B  92      30.496  19.409  10.444  1.00  2.81           O  
ATOM   1643  CB  ARG B  92      27.369  20.300  10.254  1.00  5.84           C  
ATOM   1644  CG  ARG B  92      26.085  20.353  11.084  1.00  7.52           C  
ATOM   1645  CD  ARG B  92      24.976  19.529  10.460  1.00  7.38           C  
ATOM   1646  NE  ARG B  92      24.652  19.970   9.106  1.00  7.11           N  
ATOM   1647  CZ  ARG B  92      23.898  21.027   8.819  1.00  7.59           C  
ATOM   1648  NH1 ARG B  92      23.374  21.760   9.796  1.00  6.61           N  
ATOM   1649  NH2 ARG B  92      23.679  21.362   7.554  1.00  9.58           N  
ATOM   1650  N   LEU B  93      30.238  21.337   9.310  1.00  2.81           N  
ATOM   1651  CA  LEU B  93      31.448  21.131   8.512  1.00  4.30           C  
ATOM   1652  C   LEU B  93      32.664  21.112   9.432  1.00  4.54           C  
ATOM   1653  O   LEU B  93      33.542  20.252   9.318  1.00  5.54           O  
ATOM   1654  CB  LEU B  93      31.615  22.251   7.477  1.00  3.94           C  
ATOM   1655  CG  LEU B  93      32.920  22.208   6.667  1.00  5.97           C  
ATOM   1656  CD1 LEU B  93      32.979  20.923   5.853  1.00  5.61           C  
ATOM   1657  CD2 LEU B  93      33.010  23.427   5.753  1.00  4.31           C  
ATOM   1658  N   HIS B  94      32.707  22.065  10.356  1.00  3.90           N  
ATOM   1659  CA  HIS B  94      33.822  22.150  11.287  1.00  3.95           C  
ATOM   1660  C   HIS B  94      33.870  20.896  12.157  1.00  3.87           C  
ATOM   1661  O   HIS B  94      34.950  20.392  12.467  1.00  5.00           O  
ATOM   1662  CB  HIS B  94      33.684  23.419  12.136  1.00  3.21           C  
ATOM   1663  CG  HIS B  94      34.893  23.744  12.963  1.00  4.00           C  
ATOM   1664  ND1 HIS B  94      35.077  24.979  13.547  1.00  3.10           N  
ATOM   1665  CD2 HIS B  94      35.959  22.994  13.333  1.00  3.85           C  
ATOM   1666  CE1 HIS B  94      36.200  24.976  14.242  1.00  3.53           C  
ATOM   1667  NE2 HIS B  94      36.754  23.782  14.130  1.00  4.56           N  
ATOM   1668  N   ASN B  95      32.708  20.363  12.526  1.00  4.36           N  
ATOM   1669  CA  ASN B  95      32.701  19.160  13.351  1.00  3.68           C  
ATOM   1670  C   ASN B  95      33.220  17.952  12.587  1.00  4.59           C  
ATOM   1671  O   ASN B  95      33.799  17.048  13.184  1.00  5.25           O  
ATOM   1672  CB  ASN B  95      31.309  18.868  13.911  1.00  5.33           C  
ATOM   1673  CG  ASN B  95      31.073  19.555  15.241  1.00  3.73           C  
ATOM   1674  OD1 ASN B  95      32.020  19.848  15.972  1.00  6.10           O  
ATOM   1675  ND2 ASN B  95      29.811  19.803  15.569  1.00  6.43           N  
ATOM   1676  N   GLU B  96      33.013  17.932  11.274  1.00  4.95           N  
ATOM   1677  CA  GLU B  96      33.523  16.826  10.475  1.00  6.02           C  
ATOM   1678  C   GLU B  96      35.038  16.846  10.577  1.00  6.34           C  
ATOM   1679  O   GLU B  96      35.677  15.805  10.730  1.00  7.51           O  
ATOM   1680  CB  GLU B  96      33.115  16.969   9.008  1.00  4.80           C  
ATOM   1681  CG  GLU B  96      31.693  16.548   8.725  1.00  6.85           C  
ATOM   1682  CD  GLU B  96      31.417  16.428   7.243  1.00 12.92           C  
ATOM   1683  OE1 GLU B  96      32.269  15.861   6.530  1.00 13.81           O  
ATOM   1684  OE2 GLU B  96      30.345  16.886   6.794  1.00 13.78           O  
ATOM   1685  N   VAL B  97      35.616  18.039  10.489  1.00  6.08           N  
ATOM   1686  CA  VAL B  97      37.063  18.164  10.585  1.00  6.62           C  
ATOM   1687  C   VAL B  97      37.520  17.811  12.004  1.00  6.32           C  
ATOM   1688  O   VAL B  97      38.564  17.188  12.188  1.00  6.54           O  
ATOM   1689  CB  VAL B  97      37.525  19.590  10.204  1.00  5.56           C  
ATOM   1690  CG1 VAL B  97      39.033  19.712  10.355  1.00  5.39           C  
ATOM   1691  CG2 VAL B  97      37.120  19.890   8.762  1.00  4.31           C  
ATOM   1692  N   ASN B  98      36.740  18.201  13.011  1.00  6.08           N  
ATOM   1693  CA  ASN B  98      37.107  17.873  14.389  1.00  6.09           C  
ATOM   1694  C   ASN B  98      37.238  16.362  14.556  1.00  5.42           C  
ATOM   1695  O   ASN B  98      38.225  15.870  15.115  1.00  6.78           O  
ATOM   1696  CB  ASN B  98      36.061  18.394  15.374  1.00  5.18           C  
ATOM   1697  CG  ASN B  98      36.122  19.892  15.539  1.00  6.12           C  
ATOM   1698  OD1 ASN B  98      37.167  20.507  15.328  1.00  4.50           O  
ATOM   1699  ND2 ASN B  98      35.007  20.489  15.938  1.00  5.66           N  
ATOM   1700  N   ARG B  99      36.234  15.632  14.075  1.00  7.65           N  
ATOM   1701  CA  ARG B  99      36.240  14.177  14.168  1.00  8.94           C  
ATOM   1702  C   ARG B  99      37.422  13.607  13.396  1.00  9.72           C  
ATOM   1703  O   ARG B  99      38.064  12.652  13.839  1.00  9.63           O  
ATOM   1704  CB  ARG B  99      34.929  13.597  13.628  1.00 10.38           C  
ATOM   1705  CG  ARG B  99      33.710  13.996  14.451  1.00 16.56           C  
ATOM   1706  CD  ARG B  99      32.507  13.105  14.150  1.00 21.24           C  
ATOM   1707  NE  ARG B  99      31.815  13.483  12.922  1.00 23.47           N  
ATOM   1708  CZ  ARG B  99      31.080  14.581  12.786  1.00 23.75           C  
ATOM   1709  NH1 ARG B  99      30.939  15.417  13.806  1.00 24.20           N  
ATOM   1710  NH2 ARG B  99      30.476  14.840  11.634  1.00 23.29           N  
ATOM   1711  N   LYS B 100      37.708  14.201  12.243  1.00 11.17           N  
ATOM   1712  CA  LYS B 100      38.827  13.765  11.411  1.00 12.62           C  
ATOM   1713  C   LYS B 100      40.114  13.815  12.228  1.00 12.86           C  
ATOM   1714  O   LYS B 100      40.966  12.924  12.134  1.00 13.99           O  
ATOM   1715  CB  LYS B 100      38.960  14.684  10.190  1.00 13.92           C  
ATOM   1716  CG  LYS B 100      40.260  14.534   9.398  1.00 16.94           C  
ATOM   1717  CD  LYS B 100      40.407  15.667   8.385  1.00 19.38           C  
ATOM   1718  CE  LYS B 100      41.709  15.582   7.593  1.00 20.60           C  
ATOM   1719  NZ  LYS B 100      41.729  14.430   6.650  1.00 22.23           N  
ATOM   1720  N   LEU B 101      40.233  14.856  13.046  1.00 11.89           N  
ATOM   1721  CA  LEU B 101      41.412  15.078  13.872  1.00 10.65           C  
ATOM   1722  C   LEU B 101      41.286  14.594  15.307  1.00 10.84           C  
ATOM   1723  O   LEU B 101      42.113  14.934  16.151  1.00 12.24           O  
ATOM   1724  CB  LEU B 101      41.752  16.567  13.877  1.00 11.71           C  
ATOM   1725  CG  LEU B 101      41.884  17.187  12.485  1.00 10.93           C  
ATOM   1726  CD1 LEU B 101      42.184  18.671  12.622  1.00 11.44           C  
ATOM   1727  CD2 LEU B 101      42.984  16.476  11.707  1.00 11.15           C  
ATOM   1728  N   GLY B 102      40.250  13.813  15.585  1.00 10.68           N  
ATOM   1729  CA  GLY B 102      40.060  13.288  16.926  1.00 10.95           C  
ATOM   1730  C   GLY B 102      39.786  14.321  18.000  1.00 12.38           C  
ATOM   1731  O   GLY B 102      40.154  14.132  19.159  1.00 12.30           O  
ATOM   1732  N   LYS B 103      39.149  15.423  17.619  1.00 11.19           N  
ATOM   1733  CA  LYS B 103      38.812  16.473  18.566  1.00 10.79           C  
ATOM   1734  C   LYS B 103      37.355  16.273  18.964  1.00 10.85           C  
ATOM   1735  O   LYS B 103      36.608  15.582  18.276  1.00 10.96           O  
ATOM   1736  CB  LYS B 103      38.973  17.849  17.918  1.00 11.38           C  
ATOM   1737  CG  LYS B 103      40.381  18.177  17.454  1.00 12.74           C  
ATOM   1738  CD  LYS B 103      40.396  19.514  16.716  1.00 13.88           C  
ATOM   1739  CE  LYS B 103      41.788  19.873  16.226  1.00 14.26           C  
ATOM   1740  NZ  LYS B 103      42.709  20.161  17.355  1.00 16.86           N  
ATOM   1741  N   PRO B 104      36.932  16.877  20.082  1.00 11.13           N  
ATOM   1742  CA  PRO B 104      35.546  16.738  20.535  1.00 12.02           C  
ATOM   1743  C   PRO B 104      34.576  17.374  19.547  1.00 11.48           C  
ATOM   1744  O   PRO B 104      34.947  18.253  18.767  1.00  9.81           O  
ATOM   1745  CB  PRO B 104      35.538  17.486  21.868  1.00 12.92           C  
ATOM   1746  CG  PRO B 104      36.950  17.368  22.343  1.00 14.40           C  
ATOM   1747  CD  PRO B 104      37.737  17.604  21.078  1.00 13.00           C  
ATOM   1748  N   ASP B 105      33.330  16.924  19.578  1.00 12.19           N  
ATOM   1749  CA  ASP B 105      32.322  17.505  18.712  1.00 12.97           C  
ATOM   1750  C   ASP B 105      31.817  18.743  19.437  1.00 12.11           C  
ATOM   1751  O   ASP B 105      31.517  18.689  20.628  1.00 12.08           O  
ATOM   1752  CB  ASP B 105      31.175  16.520  18.492  1.00 18.24           C  
ATOM   1753  CG  ASP B 105      31.034  16.116  17.041  1.00 21.39           C  
ATOM   1754  OD1 ASP B 105      32.059  15.774  16.417  1.00 24.85           O  
ATOM   1755  OD2 ASP B 105      29.899  16.137  16.524  1.00 26.91           O  
ATOM   1756  N   PHE B 106      31.753  19.864  18.728  1.00  9.42           N  
ATOM   1757  CA  PHE B 106      31.264  21.100  19.320  1.00  8.51           C  
ATOM   1758  C   PHE B 106      29.738  21.074  19.290  1.00  8.10           C  
ATOM   1759  O   PHE B 106      29.138  20.605  18.322  1.00  8.87           O  
ATOM   1760  CB  PHE B 106      31.803  22.299  18.533  1.00  8.04           C  
ATOM   1761  CG  PHE B 106      31.275  23.631  18.995  1.00  8.83           C  
ATOM   1762  CD1 PHE B 106      30.110  24.161  18.451  1.00  8.62           C  
ATOM   1763  CD2 PHE B 106      31.946  24.358  19.972  1.00  9.04           C  
ATOM   1764  CE1 PHE B 106      29.622  25.401  18.874  1.00  8.92           C  
ATOM   1765  CE2 PHE B 106      31.469  25.596  20.402  1.00  8.70           C  
ATOM   1766  CZ  PHE B 106      30.301  26.119  19.851  1.00  9.28           C  
ATOM   1767  N   ASP B 107      29.117  21.557  20.361  1.00  8.53           N  
ATOM   1768  CA  ASP B 107      27.659  21.599  20.460  1.00  9.20           C  
ATOM   1769  C   ASP B 107      27.162  22.743  19.581  1.00  8.06           C  
ATOM   1770  O   ASP B 107      27.133  23.891  20.015  1.00  8.85           O  
ATOM   1771  CB  ASP B 107      27.245  21.858  21.912  1.00 10.05           C  
ATOM   1772  CG  ASP B 107      25.744  21.764  22.124  1.00 12.09           C  
ATOM   1773  OD1 ASP B 107      24.977  21.856  21.140  1.00 10.39           O  
ATOM   1774  OD2 ASP B 107      25.331  21.611  23.291  1.00 12.36           O  
ATOM   1775  N   CYS B 108      26.758  22.424  18.354  1.00  8.97           N  
ATOM   1776  CA  CYS B 108      26.298  23.449  17.424  1.00  6.70           C  
ATOM   1777  C   CYS B 108      25.169  24.337  17.932  1.00  7.45           C  
ATOM   1778  O   CYS B 108      24.978  25.437  17.420  1.00  7.70           O  
ATOM   1779  CB  CYS B 108      25.895  22.820  16.090  1.00  6.97           C  
ATOM   1780  SG  CYS B 108      27.319  22.101  15.212  1.00  6.14           S  
ATOM   1781  N   SER B 109      24.423  23.875  18.929  1.00  8.22           N  
ATOM   1782  CA  SER B 109      23.337  24.687  19.460  1.00  8.51           C  
ATOM   1783  C   SER B 109      23.905  25.868  20.233  1.00  8.76           C  
ATOM   1784  O   SER B 109      23.182  26.798  20.580  1.00  9.87           O  
ATOM   1785  CB  SER B 109      22.415  23.859  20.367  1.00  8.70           C  
ATOM   1786  OG  SER B 109      23.047  23.513  21.586  1.00  9.72           O  
ATOM   1787  N   ARG B 110      25.207  25.839  20.498  1.00  8.90           N  
ATOM   1788  CA  ARG B 110      25.835  26.929  21.232  1.00  8.22           C  
ATOM   1789  C   ARG B 110      26.716  27.790  20.328  1.00  8.28           C  
ATOM   1790  O   ARG B 110      27.534  28.579  20.809  1.00  6.28           O  
ATOM   1791  CB  ARG B 110      26.666  26.365  22.385  1.00 11.34           C  
ATOM   1792  CG  ARG B 110      25.889  25.380  23.246  1.00 13.97           C  
ATOM   1793  CD  ARG B 110      26.662  25.003  24.490  1.00 17.72           C  
ATOM   1794  NE  ARG B 110      26.730  26.116  25.431  1.00 18.72           N  
ATOM   1795  CZ  ARG B 110      27.319  26.051  26.620  1.00 21.58           C  
ATOM   1796  NH1 ARG B 110      27.893  24.923  27.012  1.00 23.03           N  
ATOM   1797  NH2 ARG B 110      27.328  27.108  27.419  1.00 22.11           N  
ATOM   1798  N   VAL B 111      26.534  27.653  19.019  1.00  6.60           N  
ATOM   1799  CA  VAL B 111      27.341  28.411  18.073  1.00  5.91           C  
ATOM   1800  C   VAL B 111      27.209  29.928  18.245  1.00  7.21           C  
ATOM   1801  O   VAL B 111      28.170  30.670  18.008  1.00  6.77           O  
ATOM   1802  CB  VAL B 111      27.020  27.993  16.611  1.00  7.20           C  
ATOM   1803  CG1 VAL B 111      25.688  28.591  16.153  1.00  6.22           C  
ATOM   1804  CG2 VAL B 111      28.159  28.404  15.695  1.00  9.15           C  
ATOM   1805  N   ASP B 112      26.037  30.405  18.663  1.00  5.77           N  
ATOM   1806  CA  ASP B 112      25.871  31.840  18.867  1.00  6.61           C  
ATOM   1807  C   ASP B 112      26.542  32.277  20.170  1.00  7.16           C  
ATOM   1808  O   ASP B 112      27.109  33.365  20.242  1.00  6.92           O  
ATOM   1809  CB  ASP B 112      24.390  32.240  18.860  1.00  7.16           C  
ATOM   1810  CG  ASP B 112      23.796  32.232  17.460  1.00  9.13           C  
ATOM   1811  OD1 ASP B 112      24.546  32.515  16.502  1.00  7.02           O  
ATOM   1812  OD2 ASP B 112      22.586  31.962  17.308  1.00  8.34           O  
ATOM   1813  N   GLU B 113      26.486  31.435  21.199  1.00  7.49           N  
ATOM   1814  CA  GLU B 113      27.149  31.776  22.459  1.00  7.62           C  
ATOM   1815  C   GLU B 113      28.640  31.949  22.186  1.00  6.28           C  
ATOM   1816  O   GLU B 113      29.261  32.925  22.603  1.00  7.05           O  
ATOM   1817  CB  GLU B 113      26.976  30.659  23.497  1.00  9.27           C  
ATOM   1818  CG  GLU B 113      25.577  30.493  24.064  1.00 11.25           C  
ATOM   1819  CD  GLU B 113      25.509  29.375  25.095  1.00 12.99           C  
ATOM   1820  OE1 GLU B 113      26.085  29.533  26.191  1.00 14.49           O  
ATOM   1821  OE2 GLU B 113      24.890  28.331  24.805  1.00 16.29           O  
ATOM   1822  N   ARG B 114      29.209  30.984  21.474  1.00  6.16           N  
ATOM   1823  CA  ARG B 114      30.630  30.990  21.168  1.00  5.84           C  
ATOM   1824  C   ARG B 114      31.126  32.112  20.268  1.00  6.54           C  
ATOM   1825  O   ARG B 114      32.161  32.717  20.539  1.00  5.74           O  
ATOM   1826  CB  ARG B 114      31.034  29.657  20.532  1.00  5.78           C  
ATOM   1827  CG  ARG B 114      32.498  29.603  20.107  1.00  5.73           C  
ATOM   1828  CD  ARG B 114      33.428  29.646  21.306  1.00  6.37           C  
ATOM   1829  NE  ARG B 114      34.839  29.634  20.927  1.00  7.26           N  
ATOM   1830  CZ  ARG B 114      35.521  30.704  20.529  1.00  8.96           C  
ATOM   1831  NH1 ARG B 114      34.928  31.888  20.452  1.00  5.90           N  
ATOM   1832  NH2 ARG B 114      36.808  30.592  20.222  1.00  8.71           N  
ATOM   1833  N   TRP B 115      30.377  32.411  19.214  1.00  6.52           N  
ATOM   1834  CA  TRP B 115      30.838  33.402  18.261  1.00  6.60           C  
ATOM   1835  C   TRP B 115      30.123  34.736  18.160  1.00  6.99           C  
ATOM   1836  O   TRP B 115      30.627  35.648  17.509  1.00  8.08           O  
ATOM   1837  CB  TRP B 115      30.897  32.752  16.878  1.00  6.26           C  
ATOM   1838  CG  TRP B 115      31.833  31.586  16.836  1.00  5.89           C  
ATOM   1839  CD1 TRP B 115      31.504  30.263  16.724  1.00  7.03           C  
ATOM   1840  CD2 TRP B 115      33.261  31.640  16.909  1.00  6.33           C  
ATOM   1841  NE1 TRP B 115      32.643  29.490  16.718  1.00  7.03           N  
ATOM   1842  CE2 TRP B 115      33.735  30.310  16.831  1.00  7.08           C  
ATOM   1843  CE3 TRP B 115      34.189  32.684  17.037  1.00  6.20           C  
ATOM   1844  CZ2 TRP B 115      35.098  29.997  16.872  1.00  6.86           C  
ATOM   1845  CZ3 TRP B 115      35.544  32.373  17.080  1.00  7.00           C  
ATOM   1846  CH2 TRP B 115      35.986  31.037  16.997  1.00  6.13           C  
ATOM   1847  N   ARG B 116      28.969  34.873  18.799  1.00  7.29           N  
ATOM   1848  CA  ARG B 116      28.255  36.139  18.704  1.00  7.14           C  
ATOM   1849  C   ARG B 116      27.877  36.785  20.028  1.00  7.94           C  
ATOM   1850  O   ARG B 116      28.255  37.923  20.295  1.00  8.34           O  
ATOM   1851  CB  ARG B 116      26.985  35.974  17.863  1.00  8.09           C  
ATOM   1852  CG  ARG B 116      26.291  37.299  17.544  1.00  7.95           C  
ATOM   1853  CD  ARG B 116      24.950  37.109  16.830  1.00  8.70           C  
ATOM   1854  NE  ARG B 116      23.940  36.504  17.696  1.00  8.39           N  
ATOM   1855  CZ  ARG B 116      22.690  36.242  17.325  1.00  8.32           C  
ATOM   1856  NH1 ARG B 116      22.278  36.528  16.094  1.00  6.99           N  
ATOM   1857  NH2 ARG B 116      21.843  35.699  18.190  1.00  9.86           N  
ATOM   1858  N   ASP B 117      27.150  36.050  20.860  1.00  8.24           N  
ATOM   1859  CA  ASP B 117      26.658  36.600  22.123  1.00  9.81           C  
ATOM   1860  C   ASP B 117      27.463  36.339  23.386  1.00 10.14           C  
ATOM   1861  O   ASP B 117      27.320  37.067  24.370  1.00  9.51           O  
ATOM   1862  CB  ASP B 117      25.229  36.110  22.335  1.00 10.86           C  
ATOM   1863  CG  ASP B 117      24.370  36.299  21.105  1.00 12.97           C  
ATOM   1864  OD1 ASP B 117      23.648  35.352  20.730  1.00 14.56           O  
ATOM   1865  OD2 ASP B 117      24.420  37.397  20.514  1.00 13.74           O  
ATOM   1866  N   GLY B 118      28.308  35.317  23.365  1.00  8.37           N  
ATOM   1867  CA  GLY B 118      29.084  34.988  24.544  1.00  9.01           C  
ATOM   1868  C   GLY B 118      28.336  33.917  25.314  1.00  8.98           C  
ATOM   1869  O   GLY B 118      27.123  33.772  25.156  1.00  8.46           O  
ATOM   1870  N   TRP B 119      29.043  33.168  26.151  1.00  9.36           N  
ATOM   1871  CA  TRP B 119      28.414  32.101  26.918  1.00 11.91           C  
ATOM   1872  C   TRP B 119      27.285  32.606  27.805  1.00 12.71           C  
ATOM   1873  O   TRP B 119      27.361  33.694  28.375  1.00 11.84           O  
ATOM   1874  CB  TRP B 119      29.468  31.364  27.746  1.00 12.61           C  
ATOM   1875  CG  TRP B 119      30.601  30.875  26.901  1.00 13.07           C  
ATOM   1876  CD1 TRP B 119      31.859  31.400  26.832  1.00 15.29           C  
ATOM   1877  CD2 TRP B 119      30.566  29.790  25.964  1.00 13.56           C  
ATOM   1878  NE1 TRP B 119      32.611  30.709  25.910  1.00 14.49           N  
ATOM   1879  CE2 TRP B 119      31.842  29.716  25.363  1.00 13.70           C  
ATOM   1880  CE3 TRP B 119      29.581  28.872  25.574  1.00 13.35           C  
ATOM   1881  CZ2 TRP B 119      32.161  28.761  24.391  1.00 13.95           C  
ATOM   1882  CZ3 TRP B 119      29.898  27.920  24.606  1.00 11.51           C  
ATOM   1883  CH2 TRP B 119      31.178  27.874  24.028  1.00 14.11           C  
ATOM   1884  N   LYS B 120      26.234  31.802  27.907  1.00 13.65           N  
ATOM   1885  CA  LYS B 120      25.060  32.151  28.694  1.00 14.18           C  
ATOM   1886  C   LYS B 120      25.363  32.529  30.143  1.00 13.46           C  
ATOM   1887  O   LYS B 120      24.645  33.329  30.738  1.00 14.75           O  
ATOM   1888  CB  LYS B 120      24.053  30.995  28.669  1.00 15.59           C  
ATOM   1889  CG  LYS B 120      24.421  29.780  29.526  1.00 18.49           C  
ATOM   1890  CD  LYS B 120      25.688  29.056  29.062  1.00 20.61           C  
ATOM   1891  CE  LYS B 120      26.868  29.345  29.986  1.00 17.72           C  
ATOM   1892  NZ  LYS B 120      28.063  28.498  29.729  1.00 20.17           N  
ATOM   1893  N   ASP B 121      26.424  31.964  30.707  1.00 12.30           N  
ATOM   1894  CA  ASP B 121      26.771  32.246  32.096  1.00 12.76           C  
ATOM   1895  C   ASP B 121      27.425  33.614  32.267  1.00 12.32           C  
ATOM   1896  O   ASP B 121      27.786  34.002  33.377  1.00 11.54           O  
ATOM   1897  CB  ASP B 121      27.677  31.136  32.658  1.00 12.60           C  
ATOM   1898  CG  ASP B 121      29.064  31.126  32.035  1.00 13.93           C  
ATOM   1899  OD1 ASP B 121      29.316  31.906  31.095  1.00 12.23           O  
ATOM   1900  OD2 ASP B 121      29.910  30.326  32.493  1.00 14.31           O  
ATOM   1901  N   GLY B 122      27.565  34.340  31.163  1.00 12.63           N  
ATOM   1902  CA  GLY B 122      28.155  35.667  31.210  1.00 13.42           C  
ATOM   1903  C   GLY B 122      29.661  35.711  31.377  1.00 13.41           C  
ATOM   1904  O   GLY B 122      30.228  36.780  31.609  1.00 15.11           O  
ATOM   1905  N   SER B 123      30.317  34.564  31.239  1.00 12.35           N  
ATOM   1906  CA  SER B 123      31.767  34.489  31.398  1.00 13.55           C  
ATOM   1907  C   SER B 123      32.563  35.264  30.348  1.00 14.18           C  
ATOM   1908  O   SER B 123      33.780  35.392  30.463  1.00 14.61           O  
ATOM   1909  CB  SER B 123      32.220  33.027  31.415  1.00 13.26           C  
ATOM   1910  OG  SER B 123      31.806  32.350  30.242  1.00 12.15           O  
ATOM   1911  N   CYS B 124      31.884  35.780  29.328  1.00 15.50           N  
ATOM   1912  CA  CYS B 124      32.563  36.555  28.294  1.00 18.58           C  
ATOM   1913  C   CYS B 124      32.335  38.049  28.481  1.00 20.81           C  
ATOM   1914  O   CYS B 124      32.045  38.728  27.473  1.00 21.87           O  
ATOM   1915  CB  CYS B 124      32.078  36.140  26.908  1.00 16.47           C  
ATOM   1916  SG  CYS B 124      32.674  34.504  26.403  1.00 18.51           S  
TER    1917      CYS B 124                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
