
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  105 (  862),  selected  105 , name 1jra_C
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 1jra_C.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     7_C      -       -           -
LGA    D     8_C      -       -           -
LGA    K     9_C      -       -           -
LGA    V    10_C      -       -           -
LGA    K    11_C      M       3          1.217
LGA    K    12_C      L       4          1.217
LGA    E    13_C      H       5          0.534
LGA    V    14_C      W       6          0.342
LGA    G    15_C      G       7          0.235
LGA    R    16_C      P       8          0.782
LGA    A    17_C      K       9          0.946
LGA    S    18_C      Y      10          0.975
LGA    W    19_C      W      11          0.895
LGA    K    20_C      R      12          1.422
LGA    Y    21_C      S      13          1.745
LGA    F    22_C      L      14          1.314
LGA    H    23_C      H      15          0.830
LGA    T    24_C      L      16          1.252
LGA    L    25_C      Y      17          1.399
LGA    L    26_C      A      18          0.844
LGA    A    27_C      I      19          0.750
LGA    R    28_C      F      20          0.963
LGA    F    29_C      F      21          0.637
LGA    P    30_C      S      22          0.529
LGA    D    31_C      D      23          0.592
LGA    E    32_C      A      24          0.759
LGA    P    33_C      P      25          0.359
LGA    T    34_C      S      26          0.476
LGA    P    35_C      W      27          0.463
LGA    E    36_C      K      28          0.359
LGA    E    37_C      E      29          0.427
LGA    R    38_C      K      30          0.584
LGA    E    39_C      Y      31          0.599
LGA    K    40_C      E      32          0.487
LGA    L    41_C      A      33          0.352
LGA    H    42_C      I      34          1.099
LGA    T    43_C      Q      35          1.299
LGA    F    44_C      W      36          0.923
LGA    I    45_C      I      37          0.645
LGA    G    46_C      L      38          1.557
LGA    L    47_C      N      39          1.870
LGA    Y    48_C      F      40          1.172
LGA    A    49_C      I      41          1.329
LGA    E    50_C      E      42          2.586
LGA    L    51_C      S      43          2.794
LGA    Y    52_C      L      44          1.294
LGA    P    53_C      P      45          1.366
LGA    C    54_C      C      46          1.154
LGA    G    55_C      T      47          1.268
LGA    E    56_C      R      48          1.202
LGA    C    57_C      C      49          0.861
LGA    S    58_C      Q      50          0.905
LGA    Y    59_C      H      51          1.266
LGA    H    60_C      H      52          0.771
LGA    F    61_C      A      53          0.677
LGA    V    62_C      F      54          0.787
LGA    K    63_C      S      55          0.609
LGA    L    64_C      Y      56          0.760
LGA    I    65_C      L      57          0.952
LGA    E    66_C      T      58          1.172
LGA    K    67_C      K      59          1.026
LGA    Y    68_C      N      60          1.072
LGA    P    69_C      P      61          1.872
LGA    V    70_C      L      62          1.723
LGA    Q    71_C      T      63          1.072
LGA    T    72_C      L      64          0.886
LGA    S    73_C      N      65          0.766
LGA    S    74_C      N      66          0.359
LGA    R    75_C      S      67          0.356
LGA    T    76_C      E      68          0.420
LGA    A    77_C      D      69          0.182
LGA    A    78_C      F      70          0.326
LGA    A    79_C      Q      71          0.396
LGA    M    80_C      Y      72          0.695
LGA    W    81_C      W      73          0.641
LGA    G    82_C      T      74          0.672
LGA    C    83_C      F      75          0.382
LGA    H    84_C      A      76          0.462
LGA    I    85_C      F      77          0.448
LGA    H    86_C      H      78          0.339
LGA    N    87_C      N      79          0.456
LGA    K    88_C      N      80          0.505
LGA    V    89_C      V      81          0.460
LGA    N    90_C      N      82          0.493
LGA    E    91_C      N      83          0.835
LGA    Y    92_C      R      84          0.607
LGA    L    93_C      L      85          0.602
LGA    K    94_C      N      86          0.430
LGA    K    95_C      K      87          0.621
LGA    D    96_C      K      88          0.698
LGA    I    97_C      I      89          0.465
LGA    Y    98_C      I      90          1.334
LGA    D    99_C      S      91          1.246
LGA    C   100_C      W      92          1.608
LGA    A   101_C      S      93          2.331
LGA    -       -      E      94           -
LGA    -       -      Y      95           -
LGA    T   102_C      K      96          1.639
LGA    I   103_C      N      97          6.588
LGA    L   104_C      I      98           -
LGA    E   105_C      Y      99          4.135
LGA    D   106_C      E     100          3.375
LGA    Y   107_C      Q     101          5.941
LGA    D   108_C      S     102          0.828
LGA    C   109_C      I     103          2.136
LGA    G   110_C      L     104          2.132
LGA    C   111_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  105  102    5.0     99    1.48    23.23     92.651     6.281

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.145725 * X  +  -0.489406 * Y  +  -0.859794 * Z  +  62.721645
  Y_new =   0.967691 * X  +  -0.110239 * Y  +   0.226762 * Z  +  19.784933
  Z_new =  -0.205762 * X  +  -0.865060 * Y  +   0.457529 * Z  +  29.653124 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.084298    2.057294  [ DEG:   -62.1257    117.8743 ]
  Theta =   0.207242    2.934350  [ DEG:    11.8741    168.1259 ]
  Phi   =   1.421329   -1.720264  [ DEG:    81.4361    -98.5639 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jra_C                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jra_C.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  105  102   5.0   99   1.48   23.23  92.651
REMARK  ---------------------------------------------------------- 
MOLECULE 1jra_C
HEADER    OXIDOREDUCTASE                          13-AUG-01   1JRA              
TITLE     CRYSTAL STRUCTURE OF ERV2P                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ERV2 PROTEIN, MITOCHONDRIAL;                               
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: PROTEASE-RESISTANT DOMAIN;                                 
COMPND   5 SYNONYM: ERV2P SULFHYDRYL OXIDASE;                                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 GENE: ERV2;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 PLYSS;                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PAED4                                     
KEYWDS    FAD, SULFHYDRYL OXIDASE, HELICAL BUNDLE, CXXC                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.GROSS,C.S.SEVIER,A.VALA,C.A.KAISER,D.FASS                           
REVDAT   1   28-DEC-01 1JRA    0                                                
JRNL        AUTH   E.GROSS,C.S.SEVIER,A.VALA,C.A.KAISER,D.FASS                  
JRNL        TITL   A NEW FAD-BINDING FOLD AND INTERSUBUNIT DISULFIDE            
JRNL        TITL 2 SHUTTLE IN THE THIOL OXIDASE ERV2P.                          
JRNL        REF    NAT.STRUCT.BIOL.              V.   9    61 2002              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1JRA A    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JRA B    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JRA C    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JRA D    4   120  UNP    Q12284   ERV2_YEAST      71    187             
SEQRES   1 A  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 A  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 A  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 A  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 A  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 A  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 A  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 A  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 A  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 B  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 B  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 B  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 B  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 B  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 B  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 B  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 B  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 B  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 C  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 C  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 C  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 C  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 C  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 C  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 C  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 C  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 C  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 D  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 D  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 D  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 D  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 D  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 D  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 D  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 D  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 D  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
HET    FAD    334      53                                                       
HET    FAD    335      53                                                       
HET    FAD    336      53                                                       
HET    FAD    337      53                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   5  FAD    4(C27 H33 N9 O15 P2)                                         
FORMUL   9  HOH   *288(H2 O)                                                    
CRYST1   53.630   66.810   60.380  90.00  91.44  90.00 P 1 21 1      8          
ATOM   1739  N   ASP C   7      54.579  23.244   9.208  1.00 49.49           N  
ATOM   1740  CA  ASP C   7      54.930  21.901   9.751  1.00 49.58           C  
ATOM   1741  C   ASP C   7      53.819  21.368  10.648  1.00 49.17           C  
ATOM   1742  O   ASP C   7      53.367  20.231  10.487  1.00 51.27           O  
ATOM   1743  CB  ASP C   7      56.233  21.976  10.556  1.00 50.58           C  
ATOM   1744  CG  ASP C   7      56.622  20.637  11.185  1.00 51.95           C  
ATOM   1745  OD1 ASP C   7      55.821  19.676  11.146  1.00 51.72           O  
ATOM   1746  OD2 ASP C   7      57.738  20.549  11.733  1.00 52.85           O  
ATOM   1747  N   ASP C   8      53.375  22.192  11.592  1.00 47.12           N  
ATOM   1748  CA  ASP C   8      52.341  21.767  12.520  1.00 44.03           C  
ATOM   1749  C   ASP C   8      51.782  22.971  13.271  1.00 40.99           C  
ATOM   1750  O   ASP C   8      50.571  23.194  13.294  1.00 39.27           O  
ATOM   1751  CB  ASP C   8      52.948  20.767  13.509  1.00 46.76           C  
ATOM   1752  CG  ASP C   8      51.932  19.781  14.050  1.00 50.01           C  
ATOM   1753  OD1 ASP C   8      51.003  20.206  14.774  1.00 51.67           O  
ATOM   1754  OD2 ASP C   8      52.073  18.574  13.748  1.00 50.71           O  
ATOM   1755  N   LYS C   9      52.679  23.747  13.875  1.00 37.54           N  
ATOM   1756  CA  LYS C   9      52.301  24.925  14.650  1.00 34.11           C  
ATOM   1757  C   LYS C   9      51.613  25.995  13.811  1.00 31.39           C  
ATOM   1758  O   LYS C   9      50.628  26.592  14.241  1.00 29.57           O  
ATOM   1759  CB  LYS C   9      53.538  25.522  15.331  1.00 35.10           C  
ATOM   1760  CG  LYS C   9      53.244  26.703  16.249  1.00 34.65           C  
ATOM   1761  CD  LYS C   9      54.497  27.159  16.992  1.00 36.89           C  
ATOM   1762  CE  LYS C   9      54.205  28.348  17.901  1.00 36.46           C  
ATOM   1763  NZ  LYS C   9      55.407  28.767  18.680  1.00 39.07           N  
ATOM   1764  N   VAL C  10      52.139  26.241  12.617  1.00 29.29           N  
ATOM   1765  CA  VAL C  10      51.564  27.242  11.726  1.00 27.99           C  
ATOM   1766  C   VAL C  10      50.166  26.832  11.286  1.00 26.05           C  
ATOM   1767  O   VAL C  10      49.247  27.647  11.253  1.00 24.19           O  
ATOM   1768  CB  VAL C  10      52.426  27.429  10.464  1.00 29.74           C  
ATOM   1769  CG1 VAL C  10      51.720  28.356   9.479  1.00 31.44           C  
ATOM   1770  CG2 VAL C  10      53.791  27.984  10.845  1.00 31.53           C  
ATOM   1771  N   LYS C  11      50.014  25.559  10.949  1.00 24.29           N  
ATOM   1772  CA  LYS C  11      48.735  25.047  10.493  1.00 24.69           C  
ATOM   1773  C   LYS C  11      47.639  25.262  11.536  1.00 23.92           C  
ATOM   1774  O   LYS C  11      46.536  25.705  11.206  1.00 23.58           O  
ATOM   1775  CB  LYS C  11      48.872  23.562  10.150  1.00 25.82           C  
ATOM   1776  CG  LYS C  11      47.731  23.011   9.315  1.00 28.02           C  
ATOM   1777  CD  LYS C  11      48.032  21.598   8.828  1.00 29.36           C  
ATOM   1778  CE  LYS C  11      48.283  20.649   9.990  1.00 29.21           C  
ATOM   1779  NZ  LYS C  11      48.484  19.245   9.534  1.00 30.82           N  
ATOM   1780  N   LYS C  12      47.948  24.964  12.795  1.00 21.63           N  
ATOM   1781  CA  LYS C  12      46.980  25.130  13.873  1.00 22.49           C  
ATOM   1782  C   LYS C  12      46.693  26.605  14.157  1.00 23.97           C  
ATOM   1783  O   LYS C  12      45.546  26.992  14.395  1.00 23.08           O  
ATOM   1784  CB  LYS C  12      47.483  24.440  15.145  1.00 23.34           C  
ATOM   1785  CG  LYS C  12      47.614  22.930  15.010  1.00 25.89           C  
ATOM   1786  CD  LYS C  12      48.108  22.287  16.301  1.00 29.78           C  
ATOM   1787  CE  LYS C  12      48.287  20.780  16.130  1.00 31.26           C  
ATOM   1788  NZ  LYS C  12      48.909  20.146  17.334  1.00 34.76           N  
ATOM   1789  N   GLU C  13      47.739  27.424  14.122  1.00 22.89           N  
ATOM   1790  CA  GLU C  13      47.609  28.858  14.375  1.00 22.56           C  
ATOM   1791  C   GLU C  13      46.734  29.532  13.311  1.00 21.71           C  
ATOM   1792  O   GLU C  13      45.833  30.319  13.621  1.00 20.24           O  
ATOM   1793  CB  GLU C  13      49.001  29.495  14.391  1.00 24.75           C  
ATOM   1794  CG  GLU C  13      49.033  30.969  14.743  1.00 31.20           C  
ATOM   1795  CD  GLU C  13      50.455  31.508  14.804  1.00 34.27           C  
ATOM   1796  OE1 GLU C  13      51.311  30.833  15.419  1.00 34.55           O  
ATOM   1797  OE2 GLU C  13      50.718  32.598  14.248  1.00 36.00           O  
ATOM   1798  N   VAL C  14      47.011  29.225  12.050  1.00 18.23           N  
ATOM   1799  CA  VAL C  14      46.243  29.795  10.957  1.00 18.11           C  
ATOM   1800  C   VAL C  14      44.832  29.205  10.985  1.00 18.93           C  
ATOM   1801  O   VAL C  14      43.859  29.868  10.617  1.00 18.54           O  
ATOM   1802  CB  VAL C  14      46.922  29.491   9.606  1.00 17.78           C  
ATOM   1803  CG1 VAL C  14      46.050  29.969   8.455  1.00 17.12           C  
ATOM   1804  CG2 VAL C  14      48.287  30.170   9.556  1.00 17.35           C  
ATOM   1805  N   GLY C  15      44.731  27.960  11.440  1.00 16.61           N  
ATOM   1806  CA  GLY C  15      43.444  27.300  11.516  1.00 17.09           C  
ATOM   1807  C   GLY C  15      42.509  27.997  12.484  1.00 15.50           C  
ATOM   1808  O   GLY C  15      41.363  28.290  12.150  1.00 13.90           O  
ATOM   1809  N   ARG C  16      42.998  28.267  13.691  1.00 14.82           N  
ATOM   1810  CA  ARG C  16      42.188  28.937  14.696  1.00 14.92           C  
ATOM   1811  C   ARG C  16      41.680  30.286  14.190  1.00 15.05           C  
ATOM   1812  O   ARG C  16      40.516  30.633  14.389  1.00 15.19           O  
ATOM   1813  CB  ARG C  16      42.995  29.159  15.985  1.00 15.97           C  
ATOM   1814  CG  ARG C  16      43.284  27.894  16.781  1.00 19.49           C  
ATOM   1815  CD  ARG C  16      43.858  28.239  18.163  1.00 19.16           C  
ATOM   1816  NE  ARG C  16      42.903  28.991  18.977  1.00 20.19           N  
ATOM   1817  CZ  ARG C  16      41.826  28.463  19.559  1.00 21.66           C  
ATOM   1818  NH1 ARG C  16      41.562  27.173  19.425  1.00 21.85           N  
ATOM   1819  NH2 ARG C  16      41.002  29.232  20.265  1.00 22.04           N  
ATOM   1820  N   ALA C  17      42.561  31.038  13.535  1.00 14.24           N  
ATOM   1821  CA  ALA C  17      42.217  32.357  13.021  1.00 14.28           C  
ATOM   1822  C   ALA C  17      41.179  32.283  11.917  1.00 13.97           C  
ATOM   1823  O   ALA C  17      40.248  33.082  11.876  1.00 12.88           O  
ATOM   1824  CB  ALA C  17      43.471  33.065  12.508  1.00 13.30           C  
ATOM   1825  N   SER C  18      41.340  31.326  11.013  1.00 14.73           N  
ATOM   1826  CA  SER C  18      40.393  31.193   9.919  1.00 15.59           C  
ATOM   1827  C   SER C  18      39.001  30.825  10.429  1.00 14.60           C  
ATOM   1828  O   SER C  18      38.009  31.362   9.946  1.00 15.68           O  
ATOM   1829  CB  SER C  18      40.882  30.144   8.914  1.00 17.30           C  
ATOM   1830  OG  SER C  18      42.186  30.452   8.450  1.00 21.63           O  
ATOM   1831  N   TRP C  19      38.923  29.922  11.406  1.00 14.33           N  
ATOM   1832  CA  TRP C  19      37.625  29.503  11.945  1.00 15.05           C  
ATOM   1833  C   TRP C  19      36.929  30.654  12.668  1.00 14.57           C  
ATOM   1834  O   TRP C  19      35.713  30.807  12.571  1.00 16.46           O  
ATOM   1835  CB  TRP C  19      37.775  28.316  12.903  1.00 11.94           C  
ATOM   1836  CG  TRP C  19      38.085  26.981  12.257  1.00 12.78           C  
ATOM   1837  CD1 TRP C  19      39.133  26.157  12.559  1.00 12.80           C  
ATOM   1838  CD2 TRP C  19      37.301  26.282  11.274  1.00 13.19           C  
ATOM   1839  NE1 TRP C  19      39.051  24.992  11.835  1.00 13.22           N  
ATOM   1840  CE2 TRP C  19      37.937  25.039  11.039  1.00 12.70           C  
ATOM   1841  CE3 TRP C  19      36.125  26.583  10.569  1.00 12.52           C  
ATOM   1842  CZ2 TRP C  19      37.439  24.099  10.130  1.00 12.13           C  
ATOM   1843  CZ3 TRP C  19      35.629  25.646   9.664  1.00 11.93           C  
ATOM   1844  CH2 TRP C  19      36.288  24.419   9.453  1.00 12.04           C  
ATOM   1845  N   LYS C  20      37.697  31.451  13.404  1.00 15.75           N  
ATOM   1846  CA  LYS C  20      37.142  32.601  14.118  1.00 15.09           C  
ATOM   1847  C   LYS C  20      36.443  33.513  13.096  1.00 14.47           C  
ATOM   1848  O   LYS C  20      35.286  33.899  13.274  1.00 16.34           O  
ATOM   1849  CB  LYS C  20      38.266  33.362  14.827  1.00 15.63           C  
ATOM   1850  CG  LYS C  20      37.850  34.663  15.516  1.00 16.33           C  
ATOM   1851  CD  LYS C  20      36.884  34.413  16.670  1.00 20.36           C  
ATOM   1852  CE  LYS C  20      36.580  35.706  17.432  1.00 19.79           C  
ATOM   1853  NZ  LYS C  20      35.447  35.527  18.389  1.00 18.45           N  
ATOM   1854  N   TYR C  21      37.161  33.846  12.029  1.00 13.77           N  
ATOM   1855  CA  TYR C  21      36.649  34.687  10.934  1.00 13.52           C  
ATOM   1856  C   TYR C  21      35.450  33.995  10.249  1.00 12.34           C  
ATOM   1857  O   TYR C  21      34.368  34.569  10.109  1.00 13.29           O  
ATOM   1858  CB  TYR C  21      37.789  34.912   9.927  1.00 15.03           C  
ATOM   1859  CG  TYR C  21      37.365  35.273   8.519  1.00 14.30           C  
ATOM   1860  CD1 TYR C  21      36.834  36.525   8.228  1.00 13.25           C  
ATOM   1861  CD2 TYR C  21      37.511  34.360   7.476  1.00 13.84           C  
ATOM   1862  CE1 TYR C  21      36.463  36.862   6.932  1.00 13.20           C  
ATOM   1863  CE2 TYR C  21      37.139  34.685   6.175  1.00 15.04           C  
ATOM   1864  CZ  TYR C  21      36.617  35.940   5.912  1.00 12.80           C  
ATOM   1865  OH  TYR C  21      36.248  36.276   4.633  1.00 15.70           O  
ATOM   1866  N   PHE C  22      35.670  32.753   9.838  1.00 10.51           N  
ATOM   1867  CA  PHE C  22      34.666  31.928   9.172  1.00 10.50           C  
ATOM   1868  C   PHE C  22      33.316  31.915   9.901  1.00 10.64           C  
ATOM   1869  O   PHE C  22      32.281  32.233   9.304  1.00  9.68           O  
ATOM   1870  CB  PHE C  22      35.230  30.507   9.047  1.00 10.93           C  
ATOM   1871  CG  PHE C  22      34.276  29.493   8.471  1.00 11.26           C  
ATOM   1872  CD1 PHE C  22      34.148  29.333   7.097  1.00  8.76           C  
ATOM   1873  CD2 PHE C  22      33.566  28.639   9.314  1.00  8.56           C  
ATOM   1874  CE1 PHE C  22      33.335  28.327   6.570  1.00  8.24           C  
ATOM   1875  CE2 PHE C  22      32.753  27.635   8.802  1.00  9.96           C  
ATOM   1876  CZ  PHE C  22      32.637  27.475   7.426  1.00 10.56           C  
ATOM   1877  N   HIS C  23      33.322  31.558  11.187  1.00  9.75           N  
ATOM   1878  CA  HIS C  23      32.075  31.491  11.957  1.00 10.86           C  
ATOM   1879  C   HIS C  23      31.437  32.852  12.230  1.00 11.75           C  
ATOM   1880  O   HIS C  23      30.215  32.955  12.403  1.00 12.25           O  
ATOM   1881  CB  HIS C  23      32.302  30.748  13.282  1.00 11.08           C  
ATOM   1882  CG  HIS C  23      32.590  29.288  13.111  1.00 12.51           C  
ATOM   1883  ND1 HIS C  23      31.677  28.408  12.565  1.00 10.88           N  
ATOM   1884  CD2 HIS C  23      33.696  28.558  13.387  1.00 12.17           C  
ATOM   1885  CE1 HIS C  23      32.211  27.202  12.512  1.00 13.42           C  
ATOM   1886  NE2 HIS C  23      33.436  27.266  13.005  1.00 12.56           N  
ATOM   1887  N   THR C  24      32.259  33.895  12.283  1.00 10.94           N  
ATOM   1888  CA  THR C  24      31.742  35.234  12.525  1.00 11.87           C  
ATOM   1889  C   THR C  24      31.047  35.728  11.248  1.00 14.02           C  
ATOM   1890  O   THR C  24      30.001  36.378  11.301  1.00 14.75           O  
ATOM   1891  CB  THR C  24      32.876  36.211  12.904  1.00 12.30           C  
ATOM   1892  OG1 THR C  24      33.531  35.751  14.101  1.00 13.53           O  
ATOM   1893  CG2 THR C  24      32.311  37.604  13.146  1.00 12.45           C  
ATOM   1894  N   LEU C  25      31.645  35.405  10.103  1.00 14.11           N  
ATOM   1895  CA  LEU C  25      31.106  35.796   8.808  1.00 13.79           C  
ATOM   1896  C   LEU C  25      29.737  35.168   8.590  1.00 12.15           C  
ATOM   1897  O   LEU C  25      28.816  35.828   8.125  1.00 12.98           O  
ATOM   1898  CB  LEU C  25      32.067  35.374   7.685  1.00 13.89           C  
ATOM   1899  CG  LEU C  25      31.666  35.698   6.236  1.00 14.68           C  
ATOM   1900  CD1 LEU C  25      32.908  35.754   5.355  1.00 12.71           C  
ATOM   1901  CD2 LEU C  25      30.680  34.670   5.725  1.00 12.62           C  
ATOM   1902  N   LEU C  26      29.601  33.893   8.941  1.00 10.62           N  
ATOM   1903  CA  LEU C  26      28.331  33.199   8.760  1.00 10.91           C  
ATOM   1904  C   LEU C  26      27.260  33.717   9.709  1.00 12.56           C  
ATOM   1905  O   LEU C  26      26.099  33.832   9.331  1.00 11.78           O  
ATOM   1906  CB  LEU C  26      28.517  31.690   8.958  1.00 11.05           C  
ATOM   1907  CG  LEU C  26      29.447  30.982   7.973  1.00 10.72           C  
ATOM   1908  CD1 LEU C  26      29.683  29.534   8.416  1.00  9.90           C  
ATOM   1909  CD2 LEU C  26      28.838  31.040   6.568  1.00 12.00           C  
ATOM   1910  N   ALA C  27      27.651  34.039  10.940  1.00 12.74           N  
ATOM   1911  CA  ALA C  27      26.706  34.531  11.936  1.00 12.05           C  
ATOM   1912  C   ALA C  27      26.212  35.947  11.619  1.00 14.32           C  
ATOM   1913  O   ALA C  27      25.239  36.423  12.214  1.00 13.59           O  
ATOM   1914  CB  ALA C  27      27.351  34.497  13.336  1.00 13.76           C  
ATOM   1915  N   ARG C  28      26.877  36.616  10.680  1.00 12.07           N  
ATOM   1916  CA  ARG C  28      26.485  37.968  10.303  1.00 13.81           C  
ATOM   1917  C   ARG C  28      25.645  37.994   9.006  1.00 14.17           C  
ATOM   1918  O   ARG C  28      25.153  39.041   8.603  1.00 14.80           O  
ATOM   1919  CB  ARG C  28      27.742  38.844  10.161  1.00 16.60           C  
ATOM   1920  CG  ARG C  28      27.527  40.344  10.387  1.00 20.77           C  
ATOM   1921  CD  ARG C  28      27.054  40.644  11.816  1.00 25.75           C  
ATOM   1922  NE  ARG C  28      28.067  40.382  12.845  1.00 28.26           N  
ATOM   1923  CZ  ARG C  28      29.039  41.226  13.192  1.00 30.05           C  
ATOM   1924  NH1 ARG C  28      29.152  42.408  12.594  1.00 31.50           N  
ATOM   1925  NH2 ARG C  28      29.892  40.898  14.155  1.00 28.59           N  
ATOM   1926  N   PHE C  29      25.476  36.836   8.369  1.00 14.23           N  
ATOM   1927  CA  PHE C  29      24.691  36.708   7.133  1.00 12.87           C  
ATOM   1928  C   PHE C  29      23.227  37.096   7.423  1.00 13.58           C  
ATOM   1929  O   PHE C  29      22.751  36.946   8.548  1.00 14.87           O  
ATOM   1930  CB  PHE C  29      24.783  35.257   6.639  1.00 14.32           C  
ATOM   1931  CG  PHE C  29      24.316  35.053   5.223  1.00 12.69           C  
ATOM   1932  CD1 PHE C  29      24.955  35.691   4.160  1.00 13.85           C  
ATOM   1933  CD2 PHE C  29      23.248  34.206   4.952  1.00 13.80           C  
ATOM   1934  CE1 PHE C  29      24.534  35.484   2.843  1.00 12.51           C  
ATOM   1935  CE2 PHE C  29      22.818  33.992   3.636  1.00 12.18           C  
ATOM   1936  CZ  PHE C  29      23.465  34.634   2.584  1.00 12.73           C  
ATOM   1937  N   PRO C  30      22.487  37.595   6.415  1.00 13.78           N  
ATOM   1938  CA  PRO C  30      21.090  37.988   6.659  1.00 11.55           C  
ATOM   1939  C   PRO C  30      20.122  36.886   7.086  1.00 11.31           C  
ATOM   1940  O   PRO C  30      20.275  35.727   6.706  1.00 10.83           O  
ATOM   1941  CB  PRO C  30      20.668  38.619   5.328  1.00 12.51           C  
ATOM   1942  CG  PRO C  30      21.946  39.135   4.771  1.00 14.04           C  
ATOM   1943  CD  PRO C  30      22.901  37.996   5.059  1.00 12.87           C  
ATOM   1944  N   ASP C  31      19.119  37.259   7.882  1.00 12.93           N  
ATOM   1945  CA  ASP C  31      18.107  36.305   8.320  1.00 14.34           C  
ATOM   1946  C   ASP C  31      17.261  35.889   7.124  1.00 14.58           C  
ATOM   1947  O   ASP C  31      16.857  34.732   7.014  1.00 13.15           O  
ATOM   1948  CB  ASP C  31      17.211  36.921   9.392  1.00 17.21           C  
ATOM   1949  CG  ASP C  31      17.924  37.073  10.715  1.00 21.57           C  
ATOM   1950  OD1 ASP C  31      18.349  36.037  11.274  1.00 20.90           O  
ATOM   1951  OD2 ASP C  31      18.067  38.222  11.187  1.00 21.24           O  
ATOM   1952  N   GLU C  32      16.995  36.847   6.239  1.00 14.88           N  
ATOM   1953  CA  GLU C  32      16.218  36.598   5.023  1.00 17.02           C  
ATOM   1954  C   GLU C  32      17.010  37.143   3.839  1.00 16.28           C  
ATOM   1955  O   GLU C  32      16.723  38.216   3.316  1.00 16.21           O  
ATOM   1956  CB  GLU C  32      14.841  37.268   5.115  1.00 20.30           C  
ATOM   1957  CG  GLU C  32      13.950  36.627   6.184  1.00 26.80           C  
ATOM   1958  CD  GLU C  32      12.527  37.157   6.186  1.00 30.23           C  
ATOM   1959  OE1 GLU C  32      12.337  38.378   6.378  1.00 33.04           O  
ATOM   1960  OE2 GLU C  32      11.598  36.346   5.997  1.00 33.00           O  
ATOM   1961  N   PRO C  33      18.030  36.391   3.399  1.00 16.20           N  
ATOM   1962  CA  PRO C  33      18.895  36.773   2.281  1.00 16.18           C  
ATOM   1963  C   PRO C  33      18.209  36.732   0.917  1.00 17.82           C  
ATOM   1964  O   PRO C  33      17.359  35.881   0.666  1.00 19.16           O  
ATOM   1965  CB  PRO C  33      20.033  35.764   2.380  1.00 15.04           C  
ATOM   1966  CG  PRO C  33      19.320  34.526   2.823  1.00 15.98           C  
ATOM   1967  CD  PRO C  33      18.385  35.050   3.903  1.00 14.63           C  
ATOM   1968  N   THR C  34      18.570  37.671   0.051  1.00 18.12           N  
ATOM   1969  CA  THR C  34      18.024  37.711  -1.303  1.00 20.46           C  
ATOM   1970  C   THR C  34      18.753  36.617  -2.079  1.00 19.75           C  
ATOM   1971  O   THR C  34      19.780  36.117  -1.627  1.00 18.52           O  
ATOM   1972  CB  THR C  34      18.352  39.032  -1.999  1.00 21.46           C  
ATOM   1973  OG1 THR C  34      19.773  39.160  -2.103  1.00 21.21           O  
ATOM   1974  CG2 THR C  34      17.799  40.207  -1.215  1.00 21.98           C  
ATOM   1975  N   PRO C  35      18.229  36.217  -3.251  1.00 20.14           N  
ATOM   1976  CA  PRO C  35      18.953  35.173  -3.983  1.00 19.01           C  
ATOM   1977  C   PRO C  35      20.384  35.606  -4.335  1.00 17.33           C  
ATOM   1978  O   PRO C  35      21.291  34.786  -4.375  1.00 15.67           O  
ATOM   1979  CB  PRO C  35      18.073  34.948  -5.213  1.00 19.40           C  
ATOM   1980  CG  PRO C  35      16.689  35.121  -4.629  1.00 21.76           C  
ATOM   1981  CD  PRO C  35      16.858  36.374  -3.776  1.00 20.90           C  
ATOM   1982  N   GLU C  36      20.583  36.900  -4.575  1.00 16.87           N  
ATOM   1983  CA  GLU C  36      21.912  37.415  -4.911  1.00 18.08           C  
ATOM   1984  C   GLU C  36      22.883  37.222  -3.738  1.00 16.54           C  
ATOM   1985  O   GLU C  36      24.054  36.900  -3.930  1.00 14.67           O  
ATOM   1986  CB  GLU C  36      21.826  38.902  -5.281  1.00 22.19           C  
ATOM   1987  CG  GLU C  36      23.167  39.517  -5.673  1.00 31.82           C  
ATOM   1988  CD  GLU C  36      23.068  40.992  -6.056  1.00 36.11           C  
ATOM   1989  OE1 GLU C  36      24.128  41.623  -6.270  1.00 38.50           O  
ATOM   1990  OE2 GLU C  36      21.939  41.520  -6.145  1.00 40.04           O  
ATOM   1991  N   GLU C  37      22.392  37.417  -2.520  1.00 16.28           N  
ATOM   1992  CA  GLU C  37      23.228  37.249  -1.338  1.00 16.40           C  
ATOM   1993  C   GLU C  37      23.540  35.772  -1.106  1.00 15.45           C  
ATOM   1994  O   GLU C  37      24.648  35.419  -0.699  1.00 13.95           O  
ATOM   1995  CB  GLU C  37      22.532  37.863  -0.122  1.00 15.58           C  
ATOM   1996  CG  GLU C  37      22.247  39.343  -0.325  1.00 17.38           C  
ATOM   1997  CD  GLU C  37      21.490  39.975   0.818  1.00 17.59           C  
ATOM   1998  OE1 GLU C  37      20.533  39.350   1.314  1.00 20.21           O  
ATOM   1999  OE2 GLU C  37      21.845  41.108   1.207  1.00 20.74           O  
ATOM   2000  N   ARG C  38      22.572  34.908  -1.388  1.00 14.52           N  
ATOM   2001  CA  ARG C  38      22.780  33.474  -1.217  1.00 14.23           C  
ATOM   2002  C   ARG C  38      23.820  33.009  -2.231  1.00 15.79           C  
ATOM   2003  O   ARG C  38      24.643  32.136  -1.943  1.00 15.73           O  
ATOM   2004  CB  ARG C  38      21.465  32.716  -1.428  1.00 14.06           C  
ATOM   2005  CG  ARG C  38      20.359  33.098  -0.447  1.00 13.98           C  
ATOM   2006  CD  ARG C  38      19.123  32.223  -0.623  1.00 15.18           C  
ATOM   2007  NE  ARG C  38      19.437  30.798  -0.484  1.00 15.52           N  
ATOM   2008  CZ  ARG C  38      18.521  29.838  -0.411  1.00 16.21           C  
ATOM   2009  NH1 ARG C  38      17.232  30.144  -0.467  1.00 12.56           N  
ATOM   2010  NH2 ARG C  38      18.893  28.573  -0.268  1.00 15.21           N  
ATOM   2011  N   GLU C  39      23.773  33.597  -3.423  1.00 15.15           N  
ATOM   2012  CA  GLU C  39      24.717  33.257  -4.480  1.00 16.75           C  
ATOM   2013  C   GLU C  39      26.120  33.692  -4.066  1.00 15.24           C  
ATOM   2014  O   GLU C  39      27.087  32.958  -4.247  1.00 14.49           O  
ATOM   2015  CB  GLU C  39      24.319  33.950  -5.785  1.00 20.46           C  
ATOM   2016  CG  GLU C  39      25.225  33.625  -6.951  1.00 25.59           C  
ATOM   2017  CD  GLU C  39      24.703  34.184  -8.263  1.00 31.51           C  
ATOM   2018  OE1 GLU C  39      24.716  35.422  -8.435  1.00 33.54           O  
ATOM   2019  OE2 GLU C  39      24.272  33.379  -9.118  1.00 35.23           O  
ATOM   2020  N   LYS C  40      26.227  34.897  -3.520  1.00 15.37           N  
ATOM   2021  CA  LYS C  40      27.514  35.403  -3.064  1.00 16.00           C  
ATOM   2022  C   LYS C  40      28.120  34.465  -2.026  1.00 14.30           C  
ATOM   2023  O   LYS C  40      29.301  34.117  -2.106  1.00 15.43           O  
ATOM   2024  CB  LYS C  40      27.356  36.796  -2.452  1.00 17.43           C  
ATOM   2025  CG  LYS C  40      27.136  37.900  -3.472  1.00 22.07           C  
ATOM   2026  CD  LYS C  40      27.126  39.262  -2.801  1.00 23.89           C  
ATOM   2027  CE  LYS C  40      27.186  40.376  -3.834  1.00 28.37           C  
ATOM   2028  NZ  LYS C  40      26.046  40.359  -4.777  1.00 30.09           N  
ATOM   2029  N   LEU C  41      27.317  34.052  -1.051  1.00 14.16           N  
ATOM   2030  CA  LEU C  41      27.827  33.153  -0.016  1.00 14.08           C  
ATOM   2031  C   LEU C  41      28.226  31.808  -0.613  1.00 14.92           C  
ATOM   2032  O   LEU C  41      29.262  31.250  -0.254  1.00 14.23           O  
ATOM   2033  CB  LEU C  41      26.789  32.941   1.090  1.00 11.76           C  
ATOM   2034  CG  LEU C  41      27.246  32.054   2.253  1.00 12.10           C  
ATOM   2035  CD1 LEU C  41      28.540  32.615   2.858  1.00 11.50           C  
ATOM   2036  CD2 LEU C  41      26.151  31.962   3.305  1.00 13.53           C  
ATOM   2037  N   HIS C  42      27.415  31.284  -1.528  1.00 14.14           N  
ATOM   2038  CA  HIS C  42      27.741  30.001  -2.138  1.00 15.40           C  
ATOM   2039  C   HIS C  42      29.084  30.086  -2.871  1.00 14.21           C  
ATOM   2040  O   HIS C  42      29.939  29.230  -2.692  1.00 13.91           O  
ATOM   2041  CB  HIS C  42      26.652  29.565  -3.125  1.00 14.27           C  
ATOM   2042  CG  HIS C  42      26.964  28.279  -3.828  1.00 14.65           C  
ATOM   2043  ND1 HIS C  42      26.728  27.044  -3.265  1.00 18.68           N  
ATOM   2044  CD2 HIS C  42      27.538  28.038  -5.031  1.00 16.92           C  
ATOM   2045  CE1 HIS C  42      27.145  26.097  -4.089  1.00 16.91           C  
ATOM   2046  NE2 HIS C  42      27.641  26.674  -5.167  1.00 18.73           N  
ATOM   2047  N   THR C  43      29.259  31.117  -3.693  1.00 14.60           N  
ATOM   2048  CA  THR C  43      30.500  31.308  -4.445  1.00 15.15           C  
ATOM   2049  C   THR C  43      31.700  31.515  -3.518  1.00 14.52           C  
ATOM   2050  O   THR C  43      32.781  30.976  -3.761  1.00 13.23           O  
ATOM   2051  CB  THR C  43      30.404  32.525  -5.387  1.00 15.68           C  
ATOM   2052  OG1 THR C  43      29.324  32.334  -6.308  1.00 19.43           O  
ATOM   2053  CG2 THR C  43      31.694  32.702  -6.169  1.00 15.74           C  
ATOM   2054  N   PHE C  44      31.509  32.302  -2.463  1.00 14.62           N  
ATOM   2055  CA  PHE C  44      32.579  32.571  -1.506  1.00 12.58           C  
ATOM   2056  C   PHE C  44      33.089  31.288  -0.840  1.00 12.60           C  
ATOM   2057  O   PHE C  44      34.298  31.072  -0.744  1.00 14.04           O  
ATOM   2058  CB  PHE C  44      32.099  33.543  -0.416  1.00 11.50           C  
ATOM   2059  CG  PHE C  44      33.089  33.717   0.711  1.00 12.27           C  
ATOM   2060  CD1 PHE C  44      34.160  34.597   0.588  1.00 13.23           C  
ATOM   2061  CD2 PHE C  44      32.966  32.972   1.882  1.00 11.47           C  
ATOM   2062  CE1 PHE C  44      35.099  34.736   1.615  1.00 14.42           C  
ATOM   2063  CE2 PHE C  44      33.896  33.098   2.914  1.00 15.11           C  
ATOM   2064  CZ  PHE C  44      34.967  33.985   2.778  1.00 13.91           C  
ATOM   2065  N   ILE C  45      32.175  30.443  -0.371  1.00 11.69           N  
ATOM   2066  CA  ILE C  45      32.586  29.200   0.284  1.00 12.61           C  
ATOM   2067  C   ILE C  45      33.409  28.327  -0.663  1.00 11.60           C  
ATOM   2068  O   ILE C  45      34.384  27.705  -0.251  1.00 14.06           O  
ATOM   2069  CB  ILE C  45      31.366  28.405   0.801  1.00 13.05           C  
ATOM   2070  CG1 ILE C  45      30.661  29.193   1.915  1.00 13.08           C  
ATOM   2071  CG2 ILE C  45      31.807  27.054   1.324  1.00 14.17           C  
ATOM   2072  CD1 ILE C  45      31.508  29.418   3.164  1.00 15.01           C  
ATOM   2073  N   GLY C  46      33.022  28.277  -1.932  1.00 11.81           N  
ATOM   2074  CA  GLY C  46      33.779  27.481  -2.885  1.00 12.47           C  
ATOM   2075  C   GLY C  46      35.211  27.977  -3.000  1.00 11.24           C  
ATOM   2076  O   GLY C  46      36.151  27.183  -3.022  1.00 11.71           O  
ATOM   2077  N   LEU C  47      35.376  29.295  -3.075  1.00 10.13           N  
ATOM   2078  CA  LEU C  47      36.700  29.913  -3.186  1.00 12.81           C  
ATOM   2079  C   LEU C  47      37.481  29.759  -1.880  1.00 12.54           C  
ATOM   2080  O   LEU C  47      38.693  29.530  -1.890  1.00 14.64           O  
ATOM   2081  CB  LEU C  47      36.559  31.400  -3.539  1.00 12.00           C  
ATOM   2082  CG  LEU C  47      35.900  31.686  -4.896  1.00 14.55           C  
ATOM   2083  CD1 LEU C  47      35.758  33.185  -5.105  1.00 16.53           C  
ATOM   2084  CD2 LEU C  47      36.737  31.073  -6.002  1.00 15.10           C  
ATOM   2085  N   TYR C  48      36.772  29.901  -0.763  1.00 12.52           N  
ATOM   2086  CA  TYR C  48      37.348  29.758   0.570  1.00 12.18           C  
ATOM   2087  C   TYR C  48      38.000  28.380   0.677  1.00 13.59           C  
ATOM   2088  O   TYR C  48      39.120  28.245   1.165  1.00 14.16           O  
ATOM   2089  CB  TYR C  48      36.244  29.888   1.621  1.00 13.03           C  
ATOM   2090  CG  TYR C  48      36.712  29.675   3.044  1.00 13.55           C  
ATOM   2091  CD1 TYR C  48      37.280  30.718   3.783  1.00 13.73           C  
ATOM   2092  CD2 TYR C  48      36.602  28.427   3.645  1.00 13.37           C  
ATOM   2093  CE1 TYR C  48      37.725  30.515   5.088  1.00 15.76           C  
ATOM   2094  CE2 TYR C  48      37.043  28.211   4.948  1.00 17.36           C  
ATOM   2095  CZ  TYR C  48      37.601  29.259   5.663  1.00 17.70           C  
ATOM   2096  OH  TYR C  48      38.019  29.045   6.951  1.00 18.06           O  
ATOM   2097  N   ALA C  49      37.291  27.354   0.219  1.00 11.85           N  
ATOM   2098  CA  ALA C  49      37.813  25.990   0.262  1.00 12.14           C  
ATOM   2099  C   ALA C  49      39.027  25.814  -0.657  1.00 13.49           C  
ATOM   2100  O   ALA C  49      40.088  25.365  -0.218  1.00 13.14           O  
ATOM   2101  CB  ALA C  49      36.711  24.999  -0.140  1.00 12.07           C  
ATOM   2102  N   GLU C  50      38.861  26.179  -1.929  1.00 13.24           N  
ATOM   2103  CA  GLU C  50      39.921  26.050  -2.927  1.00 14.97           C  
ATOM   2104  C   GLU C  50      41.188  26.825  -2.612  1.00 14.88           C  
ATOM   2105  O   GLU C  50      42.289  26.358  -2.895  1.00 13.75           O  
ATOM   2106  CB  GLU C  50      39.434  26.519  -4.298  1.00 17.73           C  
ATOM   2107  CG  GLU C  50      38.273  25.749  -4.870  1.00 24.28           C  
ATOM   2108  CD  GLU C  50      37.948  26.198  -6.277  1.00 27.50           C  
ATOM   2109  OE1 GLU C  50      37.600  27.386  -6.465  1.00 25.36           O  
ATOM   2110  OE2 GLU C  50      38.046  25.360  -7.195  1.00 32.48           O  
ATOM   2111  N   LEU C  51      41.028  28.015  -2.049  1.00 13.78           N  
ATOM   2112  CA  LEU C  51      42.165  28.867  -1.733  1.00 13.88           C  
ATOM   2113  C   LEU C  51      42.728  28.753  -0.319  1.00 15.04           C  
ATOM   2114  O   LEU C  51      43.657  29.484   0.028  1.00 15.52           O  
ATOM   2115  CB  LEU C  51      41.803  30.333  -2.010  1.00 14.04           C  
ATOM   2116  CG  LEU C  51      41.506  30.686  -3.473  1.00 16.25           C  
ATOM   2117  CD1 LEU C  51      41.082  32.146  -3.584  1.00 16.67           C  
ATOM   2118  CD2 LEU C  51      42.749  30.412  -4.322  1.00 17.56           C  
ATOM   2119  N   TYR C  52      42.200  27.847   0.498  1.00 14.13           N  
ATOM   2120  CA  TYR C  52      42.710  27.728   1.859  1.00 14.63           C  
ATOM   2121  C   TYR C  52      44.213  27.416   1.846  1.00 15.10           C  
ATOM   2122  O   TYR C  52      44.654  26.509   1.154  1.00 15.52           O  
ATOM   2123  CB  TYR C  52      41.951  26.656   2.639  1.00 13.46           C  
ATOM   2124  CG  TYR C  52      42.224  26.758   4.117  1.00 15.52           C  
ATOM   2125  CD1 TYR C  52      41.554  27.695   4.905  1.00 12.74           C  
ATOM   2126  CD2 TYR C  52      43.223  25.990   4.712  1.00 14.94           C  
ATOM   2127  CE1 TYR C  52      41.880  27.868   6.243  1.00 15.61           C  
ATOM   2128  CE2 TYR C  52      43.556  26.157   6.049  1.00 15.67           C  
ATOM   2129  CZ  TYR C  52      42.885  27.097   6.808  1.00 14.33           C  
ATOM   2130  OH  TYR C  52      43.233  27.283   8.122  1.00 15.82           O  
ATOM   2131  N   PRO C  53      45.014  28.176   2.619  1.00 16.53           N  
ATOM   2132  CA  PRO C  53      46.478  28.060   2.748  1.00 17.58           C  
ATOM   2133  C   PRO C  53      47.019  26.803   3.427  1.00 17.94           C  
ATOM   2134  O   PRO C  53      47.747  26.898   4.418  1.00 19.06           O  
ATOM   2135  CB  PRO C  53      46.871  29.315   3.540  1.00 18.01           C  
ATOM   2136  CG  PRO C  53      45.649  30.196   3.506  1.00 20.44           C  
ATOM   2137  CD  PRO C  53      44.506  29.243   3.496  1.00 15.14           C  
ATOM   2138  N   CYS C  54      46.671  25.636   2.897  1.00 18.45           N  
ATOM   2139  CA  CYS C  54      47.130  24.354   3.434  1.00 19.32           C  
ATOM   2140  C   CYS C  54      46.580  23.259   2.526  1.00 20.07           C  
ATOM   2141  O   CYS C  54      45.372  23.055   2.442  1.00 19.36           O  
ATOM   2142  CB  CYS C  54      46.660  24.167   4.893  1.00 18.77           C  
ATOM   2143  SG  CYS C  54      46.515  22.426   5.424  1.00 21.24           S  
ATOM   2144  N   GLY C  55      47.487  22.577   1.828  1.00 19.20           N  
ATOM   2145  CA  GLY C  55      47.111  21.525   0.900  1.00 17.94           C  
ATOM   2146  C   GLY C  55      46.130  20.472   1.381  1.00 18.21           C  
ATOM   2147  O   GLY C  55      45.062  20.312   0.796  1.00 17.07           O  
ATOM   2148  N   GLU C  56      46.479  19.743   2.436  1.00 16.71           N  
ATOM   2149  CA  GLU C  56      45.592  18.699   2.929  1.00 18.56           C  
ATOM   2150  C   GLU C  56      44.266  19.291   3.386  1.00 16.96           C  
ATOM   2151  O   GLU C  56      43.209  18.703   3.170  1.00 14.69           O  
ATOM   2152  CB  GLU C  56      46.246  17.935   4.084  1.00 21.29           C  
ATOM   2153  CG  GLU C  56      46.378  18.720   5.371  1.00 26.68           C  
ATOM   2154  CD  GLU C  56      47.052  17.921   6.469  1.00 29.85           C  
ATOM   2155  OE1 GLU C  56      46.575  16.805   6.776  1.00 30.67           O  
ATOM   2156  OE2 GLU C  56      48.059  18.410   7.027  1.00 31.67           O  
ATOM   2157  N   CYS C  57      44.329  20.464   4.007  1.00 15.29           N  
ATOM   2158  CA  CYS C  57      43.124  21.129   4.500  1.00 16.71           C  
ATOM   2159  C   CYS C  57      42.180  21.446   3.349  1.00 16.13           C  
ATOM   2160  O   CYS C  57      40.992  21.111   3.388  1.00 15.92           O  
ATOM   2161  CB  CYS C  57      43.483  22.433   5.197  1.00 16.11           C  
ATOM   2162  SG  CYS C  57      44.772  22.389   6.480  1.00 18.88           S  
ATOM   2163  N   SER C  58      42.719  22.113   2.331  1.00 17.15           N  
ATOM   2164  CA  SER C  58      41.946  22.497   1.152  1.00 16.25           C  
ATOM   2165  C   SER C  58      41.360  21.256   0.477  1.00 17.12           C  
ATOM   2166  O   SER C  58      40.187  21.230   0.098  1.00 14.62           O  
ATOM   2167  CB  SER C  58      42.846  23.256   0.173  1.00 17.80           C  
ATOM   2168  OG  SER C  58      42.128  23.638  -0.987  1.00 20.74           O  
ATOM   2169  N   TYR C  59      42.188  20.228   0.321  1.00 18.59           N  
ATOM   2170  CA  TYR C  59      41.740  18.980  -0.287  1.00 18.82           C  
ATOM   2171  C   TYR C  59      40.510  18.447   0.441  1.00 16.78           C  
ATOM   2172  O   TYR C  59      39.516  18.097  -0.184  1.00 16.46           O  
ATOM   2173  CB  TYR C  59      42.847  17.924  -0.223  1.00 19.84           C  
ATOM   2174  CG  TYR C  59      42.372  16.531  -0.577  1.00 22.03           C  
ATOM   2175  CD1 TYR C  59      42.283  16.112  -1.907  1.00 22.39           C  
ATOM   2176  CD2 TYR C  59      41.992  15.634   0.424  1.00 21.84           C  
ATOM   2177  CE1 TYR C  59      41.828  14.826  -2.229  1.00 23.86           C  
ATOM   2178  CE2 TYR C  59      41.536  14.359   0.116  1.00 23.80           C  
ATOM   2179  CZ  TYR C  59      41.458  13.961  -1.209  1.00 25.13           C  
ATOM   2180  OH  TYR C  59      41.008  12.694  -1.497  1.00 31.51           O  
ATOM   2181  N   HIS C  60      40.596  18.374   1.765  1.00 18.91           N  
ATOM   2182  CA  HIS C  60      39.496  17.870   2.580  1.00 20.57           C  
ATOM   2183  C   HIS C  60      38.278  18.771   2.571  1.00 18.97           C  
ATOM   2184  O   HIS C  60      37.149  18.292   2.454  1.00 20.23           O  
ATOM   2185  CB  HIS C  60      39.937  17.675   4.032  1.00 22.99           C  
ATOM   2186  CG  HIS C  60      40.586  16.355   4.295  1.00 28.85           C  
ATOM   2187  ND1 HIS C  60      41.862  16.241   4.803  1.00 32.25           N  
ATOM   2188  CD2 HIS C  60      40.135  15.091   4.121  1.00 29.47           C  
ATOM   2189  CE1 HIS C  60      42.170  14.962   4.932  1.00 31.89           C  
ATOM   2190  NE2 HIS C  60      41.139  14.244   4.524  1.00 33.00           N  
ATOM   2191  N   PHE C  61      38.497  20.073   2.699  1.00 16.48           N  
ATOM   2192  CA  PHE C  61      37.373  20.994   2.738  1.00 16.39           C  
ATOM   2193  C   PHE C  61      36.591  21.066   1.435  1.00 16.36           C  
ATOM   2194  O   PHE C  61      35.369  21.219   1.451  1.00 17.10           O  
ATOM   2195  CB  PHE C  61      37.826  22.393   3.166  1.00 15.31           C  
ATOM   2196  CG  PHE C  61      36.766  23.147   3.926  1.00 18.90           C  
ATOM   2197  CD1 PHE C  61      36.261  22.635   5.118  1.00 16.77           C  
ATOM   2198  CD2 PHE C  61      36.239  24.332   3.431  1.00 17.17           C  
ATOM   2199  CE1 PHE C  61      35.238  23.293   5.806  1.00 19.40           C  
ATOM   2200  CE2 PHE C  61      35.219  24.997   4.110  1.00 20.24           C  
ATOM   2201  CZ  PHE C  61      34.716  24.476   5.301  1.00 17.79           C  
ATOM   2202  N   VAL C  62      37.286  20.953   0.309  1.00 15.59           N  
ATOM   2203  CA  VAL C  62      36.621  20.986  -0.987  1.00 17.78           C  
ATOM   2204  C   VAL C  62      35.688  19.784  -1.108  1.00 19.45           C  
ATOM   2205  O   VAL C  62      34.592  19.892  -1.652  1.00 19.75           O  
ATOM   2206  CB  VAL C  62      37.636  20.935  -2.144  1.00 20.18           C  
ATOM   2207  CG1 VAL C  62      36.911  20.662  -3.466  1.00 18.96           C  
ATOM   2208  CG2 VAL C  62      38.397  22.251  -2.219  1.00 17.76           C  
ATOM   2209  N   LYS C  63      36.124  18.635  -0.602  1.00 19.49           N  
ATOM   2210  CA  LYS C  63      35.291  17.448  -0.667  1.00 21.02           C  
ATOM   2211  C   LYS C  63      34.120  17.571   0.303  1.00 20.81           C  
ATOM   2212  O   LYS C  63      32.998  17.160  -0.008  1.00 19.78           O  
ATOM   2213  CB  LYS C  63      36.116  16.197  -0.353  1.00 23.87           C  
ATOM   2214  CG  LYS C  63      36.895  15.671  -1.553  1.00 25.89           C  
ATOM   2215  CD  LYS C  63      37.680  14.418  -1.207  1.00 28.94           C  
ATOM   2216  CE  LYS C  63      38.357  13.834  -2.443  1.00 29.59           C  
ATOM   2217  NZ  LYS C  63      37.377  13.375  -3.462  1.00 29.86           N  
ATOM   2218  N   LEU C  64      34.373  18.154   1.471  1.00 18.88           N  
ATOM   2219  CA  LEU C  64      33.321  18.313   2.468  1.00 20.44           C  
ATOM   2220  C   LEU C  64      32.185  19.228   2.023  1.00 20.79           C  
ATOM   2221  O   LEU C  64      31.015  18.914   2.251  1.00 21.47           O  
ATOM   2222  CB  LEU C  64      33.904  18.820   3.791  1.00 19.28           C  
ATOM   2223  CG  LEU C  64      34.617  17.760   4.638  1.00 22.04           C  
ATOM   2224  CD1 LEU C  64      35.131  18.379   5.937  1.00 18.00           C  
ATOM   2225  CD2 LEU C  64      33.642  16.621   4.938  1.00 20.27           C  
ATOM   2226  N   ILE C  65      32.511  20.358   1.397  1.00 19.65           N  
ATOM   2227  CA  ILE C  65      31.459  21.266   0.957  1.00 21.58           C  
ATOM   2228  C   ILE C  65      30.760  20.672  -0.260  1.00 23.23           C  
ATOM   2229  O   ILE C  65      29.603  20.982  -0.533  1.00 22.22           O  
ATOM   2230  CB  ILE C  65      31.999  22.677   0.608  1.00 21.17           C  
ATOM   2231  CG1 ILE C  65      32.870  22.619  -0.651  1.00 19.85           C  
ATOM   2232  CG2 ILE C  65      32.769  23.234   1.796  1.00 17.60           C  
ATOM   2233  CD1 ILE C  65      33.169  23.979  -1.256  1.00 19.43           C  
ATOM   2234  N   GLU C  66      31.474  19.820  -0.985  1.00 24.74           N  
ATOM   2235  CA  GLU C  66      30.908  19.155  -2.147  1.00 27.18           C  
ATOM   2236  C   GLU C  66      29.826  18.215  -1.627  1.00 26.90           C  
ATOM   2237  O   GLU C  66      28.728  18.143  -2.181  1.00 27.99           O  
ATOM   2238  CB  GLU C  66      31.999  18.365  -2.875  1.00 31.21           C  
ATOM   2239  CG  GLU C  66      31.488  17.366  -3.906  1.00 36.68           C  
ATOM   2240  CD  GLU C  66      32.616  16.598  -4.588  1.00 40.95           C  
ATOM   2241  OE1 GLU C  66      32.311  15.681  -5.382  1.00 43.18           O  
ATOM   2242  OE2 GLU C  66      33.803  16.909  -4.336  1.00 41.37           O  
ATOM   2243  N   LYS C  67      30.138  17.512  -0.542  1.00 25.57           N  
ATOM   2244  CA  LYS C  67      29.206  16.568   0.066  1.00 26.17           C  
ATOM   2245  C   LYS C  67      28.160  17.274   0.921  1.00 27.01           C  
ATOM   2246  O   LYS C  67      27.039  16.788   1.069  1.00 26.53           O  
ATOM   2247  CB  LYS C  67      29.973  15.560   0.922  1.00 26.06           C  
ATOM   2248  CG  LYS C  67      29.109  14.475   1.542  1.00 27.16           C  
ATOM   2249  CD  LYS C  67      29.969  13.499   2.320  1.00 30.61           C  
ATOM   2250  CE  LYS C  67      29.162  12.328   2.848  1.00 31.42           C  
ATOM   2251  NZ  LYS C  67      30.043  11.364   3.565  1.00 32.46           N  
ATOM   2252  N   TYR C  68      28.529  18.422   1.486  1.00 26.10           N  
ATOM   2253  CA  TYR C  68      27.613  19.194   2.321  1.00 24.59           C  
ATOM   2254  C   TYR C  68      27.621  20.654   1.886  1.00 22.49           C  
ATOM   2255  O   TYR C  68      28.269  21.490   2.516  1.00 21.92           O  
ATOM   2256  CB  TYR C  68      28.017  19.104   3.797  1.00 26.79           C  
ATOM   2257  CG  TYR C  68      28.133  17.695   4.328  1.00 29.82           C  
ATOM   2258  CD1 TYR C  68      29.383  17.118   4.567  1.00 31.16           C  
ATOM   2259  CD2 TYR C  68      26.993  16.933   4.592  1.00 32.38           C  
ATOM   2260  CE1 TYR C  68      29.495  15.817   5.058  1.00 31.96           C  
ATOM   2261  CE2 TYR C  68      27.094  15.633   5.079  1.00 32.86           C  
ATOM   2262  CZ  TYR C  68      28.345  15.082   5.311  1.00 34.53           C  
ATOM   2263  OH  TYR C  68      28.439  13.796   5.796  1.00 36.85           O  
ATOM   2264  N   PRO C  69      26.902  20.979   0.799  1.00 20.78           N  
ATOM   2265  CA  PRO C  69      26.863  22.360   0.316  1.00 19.50           C  
ATOM   2266  C   PRO C  69      26.416  23.324   1.394  1.00 19.08           C  
ATOM   2267  O   PRO C  69      25.594  22.983   2.243  1.00 18.50           O  
ATOM   2268  CB  PRO C  69      25.891  22.293  -0.866  1.00 20.37           C  
ATOM   2269  CG  PRO C  69      25.009  21.134  -0.529  1.00 22.60           C  
ATOM   2270  CD  PRO C  69      25.993  20.124   0.018  1.00 20.97           C  
ATOM   2271  N   VAL C  70      26.974  24.530   1.368  1.00 18.15           N  
ATOM   2272  CA  VAL C  70      26.623  25.528   2.364  1.00 16.20           C  
ATOM   2273  C   VAL C  70      25.131  25.818   2.294  1.00 15.87           C  
ATOM   2274  O   VAL C  70      24.562  25.959   1.212  1.00 15.20           O  
ATOM   2275  CB  VAL C  70      27.424  26.833   2.155  1.00 18.48           C  
ATOM   2276  CG1 VAL C  70      27.273  27.313   0.723  1.00 17.91           C  
ATOM   2277  CG2 VAL C  70      26.947  27.909   3.146  1.00 16.92           C  
ATOM   2278  N   GLN C  71      24.495  25.871   3.458  1.00 15.60           N  
ATOM   2279  CA  GLN C  71      23.073  26.155   3.539  1.00 16.08           C  
ATOM   2280  C   GLN C  71      22.947  27.670   3.630  1.00 16.64           C  
ATOM   2281  O   GLN C  71      23.303  28.276   4.638  1.00 15.29           O  
ATOM   2282  CB  GLN C  71      22.482  25.471   4.773  1.00 18.43           C  
ATOM   2283  CG  GLN C  71      22.664  23.947   4.742  1.00 21.52           C  
ATOM   2284  CD  GLN C  71      21.981  23.314   3.540  1.00 23.67           C  
ATOM   2285  OE1 GLN C  71      20.755  23.292   3.452  1.00 25.26           O  
ATOM   2286  NE2 GLN C  71      22.777  22.814   2.597  1.00 25.73           N  
ATOM   2287  N   THR C  72      22.443  28.275   2.562  1.00 15.60           N  
ATOM   2288  CA  THR C  72      22.310  29.728   2.484  1.00 16.53           C  
ATOM   2289  C   THR C  72      20.898  30.284   2.682  1.00 16.14           C  
ATOM   2290  O   THR C  72      20.683  31.476   2.473  1.00 16.03           O  
ATOM   2291  CB  THR C  72      22.818  30.233   1.110  1.00 16.05           C  
ATOM   2292  OG1 THR C  72      22.015  29.657   0.073  1.00 16.99           O  
ATOM   2293  CG2 THR C  72      24.273  29.810   0.877  1.00 17.05           C  
ATOM   2294  N   SER C  73      19.941  29.451   3.082  1.00 16.14           N  
ATOM   2295  CA  SER C  73      18.571  29.943   3.255  1.00 16.30           C  
ATOM   2296  C   SER C  73      18.399  31.006   4.344  1.00 16.48           C  
ATOM   2297  O   SER C  73      17.443  31.789   4.306  1.00 14.40           O  
ATOM   2298  CB  SER C  73      17.600  28.781   3.510  1.00 15.82           C  
ATOM   2299  OG  SER C  73      17.889  28.098   4.714  1.00 19.86           O  
ATOM   2300  N   SER C  74      19.312  31.041   5.308  1.00 13.49           N  
ATOM   2301  CA  SER C  74      19.215  32.033   6.371  1.00 16.43           C  
ATOM   2302  C   SER C  74      20.462  32.087   7.236  1.00 16.30           C  
ATOM   2303  O   SER C  74      21.305  31.190   7.198  1.00 15.66           O  
ATOM   2304  CB  SER C  74      18.028  31.731   7.282  1.00 16.80           C  
ATOM   2305  OG  SER C  74      18.296  30.586   8.070  1.00 18.16           O  
ATOM   2306  N   ARG C  75      20.551  33.148   8.028  1.00 15.66           N  
ATOM   2307  CA  ARG C  75      21.662  33.342   8.943  1.00 15.16           C  
ATOM   2308  C   ARG C  75      21.814  32.108   9.826  1.00 15.00           C  
ATOM   2309  O   ARG C  75      22.902  31.557   9.947  1.00 12.11           O  
ATOM   2310  CB  ARG C  75      21.410  34.554   9.838  1.00 14.25           C  
ATOM   2311  CG  ARG C  75      22.541  34.835  10.817  1.00 15.93           C  
ATOM   2312  CD  ARG C  75      22.033  35.539  12.063  1.00 18.36           C  
ATOM   2313  NE  ARG C  75      21.254  36.733  11.751  1.00 20.08           N  
ATOM   2314  CZ  ARG C  75      21.775  37.938  11.537  1.00 24.54           C  
ATOM   2315  NH1 ARG C  75      23.090  38.124  11.600  1.00 21.76           N  
ATOM   2316  NH2 ARG C  75      20.976  38.959  11.260  1.00 22.75           N  
ATOM   2317  N   THR C  76      20.713  31.674  10.437  1.00 15.52           N  
ATOM   2318  CA  THR C  76      20.749  30.514  11.320  1.00 15.17           C  
ATOM   2319  C   THR C  76      21.146  29.241  10.575  1.00 15.73           C  
ATOM   2320  O   THR C  76      21.929  28.439  11.081  1.00 14.58           O  
ATOM   2321  CB  THR C  76      19.382  30.291  12.022  1.00 17.34           C  
ATOM   2322  OG1 THR C  76      18.952  31.516  12.636  1.00 15.47           O  
ATOM   2323  CG2 THR C  76      19.505  29.221  13.105  1.00 14.36           C  
ATOM   2324  N   ALA C  77      20.619  29.060   9.368  1.00 16.69           N  
ATOM   2325  CA  ALA C  77      20.944  27.875   8.579  1.00 14.76           C  
ATOM   2326  C   ALA C  77      22.409  27.888   8.153  1.00 16.17           C  
ATOM   2327  O   ALA C  77      23.070  26.852   8.154  1.00 16.42           O  
ATOM   2328  CB  ALA C  77      20.044  27.797   7.345  1.00 16.08           C  
ATOM   2329  N   ALA C  78      22.918  29.062   7.788  1.00 13.48           N  
ATOM   2330  CA  ALA C  78      24.307  29.173   7.358  1.00 13.96           C  
ATOM   2331  C   ALA C  78      25.271  28.949   8.522  1.00 13.45           C  
ATOM   2332  O   ALA C  78      26.273  28.244   8.383  1.00 12.40           O  
ATOM   2333  CB  ALA C  78      24.555  30.532   6.728  1.00 13.93           C  
ATOM   2334  N   ALA C  79      24.970  29.552   9.666  1.00 12.39           N  
ATOM   2335  CA  ALA C  79      25.818  29.401  10.843  1.00 14.77           C  
ATOM   2336  C   ALA C  79      25.827  27.957  11.340  1.00 14.62           C  
ATOM   2337  O   ALA C  79      26.863  27.460  11.787  1.00 16.79           O  
ATOM   2338  CB  ALA C  79      25.346  30.337  11.956  1.00 12.52           C  
ATOM   2339  N   MET C  80      24.671  27.296  11.283  1.00 14.08           N  
ATOM   2340  CA  MET C  80      24.553  25.906  11.723  1.00 14.70           C  
ATOM   2341  C   MET C  80      25.388  25.030  10.801  1.00 14.45           C  
ATOM   2342  O   MET C  80      26.089  24.116  11.242  1.00 15.11           O  
ATOM   2343  CB  MET C  80      23.087  25.454  11.685  1.00 16.25           C  
ATOM   2344  CG  MET C  80      22.278  25.876  12.889  1.00 18.80           C  
ATOM   2345  SD  MET C  80      22.851  25.060  14.384  1.00 21.67           S  
ATOM   2346  CE  MET C  80      22.113  26.092  15.651  1.00 22.20           C  
ATOM   2347  N   TRP C  81      25.295  25.314   9.509  1.00 13.36           N  
ATOM   2348  CA  TRP C  81      26.069  24.586   8.523  1.00 13.13           C  
ATOM   2349  C   TRP C  81      27.551  24.758   8.852  1.00 11.97           C  
ATOM   2350  O   TRP C  81      28.319  23.805   8.787  1.00 12.85           O  
ATOM   2351  CB  TRP C  81      25.797  25.138   7.123  1.00 12.61           C  
ATOM   2352  CG  TRP C  81      26.752  24.603   6.107  1.00 13.84           C  
ATOM   2353  CD1 TRP C  81      26.668  23.409   5.448  1.00 12.83           C  
ATOM   2354  CD2 TRP C  81      27.970  25.218   5.676  1.00 13.58           C  
ATOM   2355  NE1 TRP C  81      27.760  23.242   4.632  1.00 15.27           N  
ATOM   2356  CE2 TRP C  81      28.575  24.339   4.751  1.00 14.85           C  
ATOM   2357  CE3 TRP C  81      28.609  26.429   5.980  1.00 13.48           C  
ATOM   2358  CZ2 TRP C  81      29.792  24.632   4.124  1.00 14.19           C  
ATOM   2359  CZ3 TRP C  81      29.822  26.719   5.354  1.00 14.01           C  
ATOM   2360  CH2 TRP C  81      30.399  25.825   4.438  1.00 14.96           C  
ATOM   2361  N   GLY C  82      27.950  25.981   9.196  1.00 11.57           N  
ATOM   2362  CA  GLY C  82      29.347  26.231   9.519  1.00 11.79           C  
ATOM   2363  C   GLY C  82      29.801  25.392  10.702  1.00 13.72           C  
ATOM   2364  O   GLY C  82      30.895  24.822  10.708  1.00 11.81           O  
ATOM   2365  N   CYS C  83      28.950  25.318  11.719  1.00 15.15           N  
ATOM   2366  CA  CYS C  83      29.266  24.542  12.911  1.00 15.69           C  
ATOM   2367  C   CYS C  83      29.371  23.055  12.578  1.00 15.96           C  
ATOM   2368  O   CYS C  83      30.261  22.352  13.064  1.00 15.45           O  
ATOM   2369  CB  CYS C  83      28.186  24.761  13.967  1.00 16.51           C  
ATOM   2370  SG  CYS C  83      28.534  23.950  15.559  1.00 18.57           S  
ATOM   2371  N   HIS C  84      28.453  22.586  11.738  1.00 16.83           N  
ATOM   2372  CA  HIS C  84      28.420  21.190  11.328  1.00 18.01           C  
ATOM   2373  C   HIS C  84      29.650  20.805  10.516  1.00 18.86           C  
ATOM   2374  O   HIS C  84      30.281  19.784  10.779  1.00 17.96           O  
ATOM   2375  CB  HIS C  84      27.160  20.918  10.492  1.00 19.42           C  
ATOM   2376  CG  HIS C  84      25.881  21.061  11.257  1.00 21.48           C  
ATOM   2377  ND1 HIS C  84      24.659  21.236  10.640  1.00 22.07           N  
ATOM   2378  CD2 HIS C  84      25.630  21.037  12.588  1.00 19.11           C  
ATOM   2379  CE1 HIS C  84      23.712  21.316  11.559  1.00 21.82           C  
ATOM   2380  NE2 HIS C  84      24.275  21.198  12.748  1.00 21.43           N  
ATOM   2381  N   ILE C  85      29.997  21.626   9.527  1.00 17.58           N  
ATOM   2382  CA  ILE C  85      31.140  21.303   8.686  1.00 18.33           C  
ATOM   2383  C   ILE C  85      32.454  21.410   9.463  1.00 17.82           C  
ATOM   2384  O   ILE C  85      33.402  20.657   9.211  1.00 18.32           O  
ATOM   2385  CB  ILE C  85      31.145  22.178   7.399  1.00 18.56           C  
ATOM   2386  CG1 ILE C  85      31.875  21.428   6.284  1.00 20.38           C  
ATOM   2387  CG2 ILE C  85      31.768  23.540   7.673  1.00 17.77           C  
ATOM   2388  CD1 ILE C  85      31.708  22.047   4.922  1.00 21.29           C  
ATOM   2389  N   HIS C  86      32.509  22.317  10.431  1.00 16.25           N  
ATOM   2390  CA  HIS C  86      33.714  22.442  11.233  1.00 15.68           C  
ATOM   2391  C   HIS C  86      33.781  21.171  12.083  1.00 16.55           C  
ATOM   2392  O   HIS C  86      34.863  20.666  12.381  1.00 17.62           O  
ATOM   2393  CB  HIS C  86      33.649  23.696  12.113  1.00 15.92           C  
ATOM   2394  CG  HIS C  86      34.869  23.920  12.958  1.00 14.74           C  
ATOM   2395  ND1 HIS C  86      35.153  25.138  13.540  1.00 13.86           N  
ATOM   2396  CD2 HIS C  86      35.878  23.089  13.316  1.00 13.43           C  
ATOM   2397  CE1 HIS C  86      36.286  25.048  14.213  1.00 14.28           C  
ATOM   2398  NE2 HIS C  86      36.747  23.817  14.093  1.00 14.17           N  
ATOM   2399  N   ASN C  87      32.621  20.641  12.465  1.00 17.26           N  
ATOM   2400  CA  ASN C  87      32.611  19.415  13.258  1.00 19.08           C  
ATOM   2401  C   ASN C  87      33.012  18.200  12.426  1.00 18.90           C  
ATOM   2402  O   ASN C  87      33.457  17.196  12.974  1.00 20.13           O  
ATOM   2403  CB  ASN C  87      31.244  19.182  13.909  1.00 19.23           C  
ATOM   2404  CG  ASN C  87      31.135  19.841  15.271  1.00 21.03           C  
ATOM   2405  OD1 ASN C  87      32.122  19.944  16.001  1.00 20.23           O  
ATOM   2406  ND2 ASN C  87      29.934  20.276  15.627  1.00 19.39           N  
ATOM   2407  N   LYS C  88      32.845  18.275  11.110  1.00 18.68           N  
ATOM   2408  CA  LYS C  88      33.248  17.159  10.262  1.00 20.19           C  
ATOM   2409  C   LYS C  88      34.774  17.146  10.221  1.00 19.40           C  
ATOM   2410  O   LYS C  88      35.394  16.087  10.153  1.00 18.96           O  
ATOM   2411  CB  LYS C  88      32.667  17.302   8.857  1.00 21.62           C  
ATOM   2412  CG  LYS C  88      31.200  16.905   8.769  1.00 25.77           C  
ATOM   2413  CD  LYS C  88      31.012  15.438   9.148  1.00 29.15           C  
ATOM   2414  CE  LYS C  88      29.540  15.053   9.193  1.00 32.65           C  
ATOM   2415  NZ  LYS C  88      29.355  13.618   9.557  1.00 36.16           N  
ATOM   2416  N   VAL C  89      35.375  18.330  10.270  1.00 18.21           N  
ATOM   2417  CA  VAL C  89      36.826  18.427  10.280  1.00 18.96           C  
ATOM   2418  C   VAL C  89      37.318  17.912  11.642  1.00 20.65           C  
ATOM   2419  O   VAL C  89      38.314  17.191  11.718  1.00 20.20           O  
ATOM   2420  CB  VAL C  89      37.295  19.891  10.057  1.00 17.99           C  
ATOM   2421  CG1 VAL C  89      38.797  20.014  10.327  1.00 14.92           C  
ATOM   2422  CG2 VAL C  89      36.999  20.309   8.622  1.00 16.06           C  
ATOM   2423  N   ASN C  90      36.609  18.273  12.710  1.00 21.00           N  
ATOM   2424  CA  ASN C  90      36.982  17.824  14.051  1.00 24.00           C  
ATOM   2425  C   ASN C  90      36.909  16.304  14.113  1.00 26.12           C  
ATOM   2426  O   ASN C  90      37.744  15.649  14.740  1.00 25.53           O  
ATOM   2427  CB  ASN C  90      36.043  18.401  15.110  1.00 24.14           C  
ATOM   2428  CG  ASN C  90      36.206  19.894  15.286  1.00 25.21           C  
ATOM   2429  OD1 ASN C  90      37.248  20.461  14.947  1.00 26.94           O  
ATOM   2430  ND2 ASN C  90      35.182  20.540  15.840  1.00 22.42           N  
ATOM   2431  N   GLU C  91      35.896  15.758  13.452  1.00 27.05           N  
ATOM   2432  CA  GLU C  91      35.689  14.323  13.412  1.00 30.78           C  
ATOM   2433  C   GLU C  91      36.884  13.574  12.813  1.00 31.01           C  
ATOM   2434  O   GLU C  91      37.420  12.663  13.446  1.00 30.89           O  
ATOM   2435  CB  GLU C  91      34.411  14.019  12.622  1.00 33.77           C  
ATOM   2436  CG  GLU C  91      34.039  12.553  12.517  1.00 38.45           C  
ATOM   2437  CD  GLU C  91      32.588  12.364  12.093  1.00 42.07           C  
ATOM   2438  OE1 GLU C  91      32.141  13.065  11.159  1.00 43.22           O  
ATOM   2439  OE2 GLU C  91      31.894  11.516  12.694  1.00 43.99           O  
ATOM   2440  N   TYR C  92      37.323  13.951  11.615  1.00 31.28           N  
ATOM   2441  CA  TYR C  92      38.446  13.232  11.027  1.00 31.10           C  
ATOM   2442  C   TYR C  92      39.807  13.572  11.623  1.00 29.46           C  
ATOM   2443  O   TYR C  92      40.790  12.904  11.321  1.00 29.28           O  
ATOM   2444  CB  TYR C  92      38.459  13.364   9.491  1.00 34.24           C  
ATOM   2445  CG  TYR C  92      38.840  14.703   8.899  1.00 36.77           C  
ATOM   2446  CD1 TYR C  92      40.132  15.213   9.037  1.00 37.10           C  
ATOM   2447  CD2 TYR C  92      37.926  15.424   8.133  1.00 38.47           C  
ATOM   2448  CE1 TYR C  92      40.503  16.410   8.417  1.00 39.39           C  
ATOM   2449  CE2 TYR C  92      38.284  16.620   7.510  1.00 39.52           C  
ATOM   2450  CZ  TYR C  92      39.572  17.109   7.656  1.00 40.76           C  
ATOM   2451  OH  TYR C  92      39.920  18.297   7.045  1.00 42.53           O  
ATOM   2452  N   LEU C  93      39.865  14.595  12.473  1.00 26.93           N  
ATOM   2453  CA  LEU C  93      41.117  14.958  13.138  1.00 26.31           C  
ATOM   2454  C   LEU C  93      41.057  14.427  14.568  1.00 27.40           C  
ATOM   2455  O   LEU C  93      41.929  14.708  15.388  1.00 28.20           O  
ATOM   2456  CB  LEU C  93      41.327  16.478  13.171  1.00 23.78           C  
ATOM   2457  CG  LEU C  93      41.591  17.209  11.849  1.00 24.81           C  
ATOM   2458  CD1 LEU C  93      41.961  18.667  12.137  1.00 24.66           C  
ATOM   2459  CD2 LEU C  93      42.714  16.523  11.088  1.00 24.07           C  
ATOM   2460  N   LYS C  94      40.007  13.669  14.863  1.00 27.41           N  
ATOM   2461  CA  LYS C  94      39.826  13.085  16.186  1.00 29.67           C  
ATOM   2462  C   LYS C  94      39.717  14.135  17.294  1.00 29.66           C  
ATOM   2463  O   LYS C  94      40.258  13.951  18.385  1.00 31.00           O  
ATOM   2464  CB  LYS C  94      40.983  12.129  16.501  1.00 30.77           C  
ATOM   2465  CG  LYS C  94      41.340  11.164  15.379  1.00 32.00           C  
ATOM   2466  CD  LYS C  94      40.210  10.207  15.059  1.00 34.98           C  
ATOM   2467  CE  LYS C  94      40.673   9.151  14.068  1.00 38.06           C  
ATOM   2468  NZ  LYS C  94      39.643   8.101  13.825  1.00 40.18           N  
ATOM   2469  N   LYS C  95      39.022  15.234  17.012  1.00 29.30           N  
ATOM   2470  CA  LYS C  95      38.823  16.302  17.990  1.00 27.96           C  
ATOM   2471  C   LYS C  95      37.395  16.237  18.536  1.00 27.67           C  
ATOM   2472  O   LYS C  95      36.512  15.663  17.903  1.00 28.13           O  
ATOM   2473  CB  LYS C  95      39.038  17.671  17.337  1.00 29.65           C  
ATOM   2474  CG  LYS C  95      40.476  17.993  16.942  1.00 30.89           C  
ATOM   2475  CD  LYS C  95      40.530  19.334  16.209  1.00 32.31           C  
ATOM   2476  CE  LYS C  95      41.952  19.841  16.058  1.00 34.58           C  
ATOM   2477  NZ  LYS C  95      42.554  20.162  17.386  1.00 33.24           N  
ATOM   2478  N   ASP C  96      37.165  16.836  19.701  1.00 26.77           N  
ATOM   2479  CA  ASP C  96      35.830  16.843  20.296  1.00 27.75           C  
ATOM   2480  C   ASP C  96      34.795  17.481  19.380  1.00 27.55           C  
ATOM   2481  O   ASP C  96      35.115  18.362  18.584  1.00 26.37           O  
ATOM   2482  CB  ASP C  96      35.818  17.618  21.618  1.00 28.72           C  
ATOM   2483  CG  ASP C  96      36.509  16.877  22.739  1.00 30.26           C  
ATOM   2484  OD1 ASP C  96      36.450  15.630  22.749  1.00 29.85           O  
ATOM   2485  OD2 ASP C  96      37.093  17.548  23.618  1.00 32.13           O  
ATOM   2486  N   ILE C  97      33.549  17.036  19.500  1.00 27.98           N  
ATOM   2487  CA  ILE C  97      32.480  17.616  18.703  1.00 27.84           C  
ATOM   2488  C   ILE C  97      31.957  18.821  19.482  1.00 26.43           C  
ATOM   2489  O   ILE C  97      31.664  18.730  20.676  1.00 25.37           O  
ATOM   2490  CB  ILE C  97      31.351  16.602  18.451  1.00 28.72           C  
ATOM   2491  CG1 ILE C  97      31.909  15.400  17.680  1.00 31.17           C  
ATOM   2492  CG2 ILE C  97      30.221  17.253  17.655  1.00 28.49           C  
ATOM   2493  CD1 ILE C  97      32.616  15.767  16.370  1.00 30.82           C  
ATOM   2494  N   TYR C  98      31.859  19.953  18.795  1.00 23.39           N  
ATOM   2495  CA  TYR C  98      31.413  21.209  19.390  1.00 22.48           C  
ATOM   2496  C   TYR C  98      29.890  21.383  19.360  1.00 21.90           C  
ATOM   2497  O   TYR C  98      29.253  21.178  18.325  1.00 21.88           O  
ATOM   2498  CB  TYR C  98      32.084  22.353  18.631  1.00 22.11           C  
ATOM   2499  CG  TYR C  98      31.847  23.742  19.162  1.00 19.45           C  
ATOM   2500  CD1 TYR C  98      32.714  24.311  20.092  1.00 21.78           C  
ATOM   2501  CD2 TYR C  98      30.815  24.531  18.659  1.00 19.66           C  
ATOM   2502  CE1 TYR C  98      32.568  25.637  20.497  1.00 18.63           C  
ATOM   2503  CE2 TYR C  98      30.659  25.853  19.055  1.00 18.57           C  
ATOM   2504  CZ  TYR C  98      31.540  26.400  19.967  1.00 18.41           C  
ATOM   2505  OH  TYR C  98      31.417  27.721  20.314  1.00 17.52           O  
ATOM   2506  N   ASP C  99      29.318  21.777  20.497  1.00 22.34           N  
ATOM   2507  CA  ASP C  99      27.873  21.985  20.608  1.00 21.03           C  
ATOM   2508  C   ASP C  99      27.465  23.215  19.801  1.00 20.55           C  
ATOM   2509  O   ASP C  99      27.945  24.316  20.064  1.00 20.06           O  
ATOM   2510  CB  ASP C  99      27.474  22.199  22.070  1.00 23.91           C  
ATOM   2511  CG  ASP C  99      25.965  22.082  22.289  1.00 23.91           C  
ATOM   2512  OD1 ASP C  99      25.195  22.391  21.357  1.00 24.86           O  
ATOM   2513  OD2 ASP C  99      25.550  21.691  23.400  1.00 23.74           O  
ATOM   2514  N   CYS C 100      26.569  23.030  18.836  1.00 20.33           N  
ATOM   2515  CA  CYS C 100      26.117  24.130  17.984  1.00 21.70           C  
ATOM   2516  C   CYS C 100      24.935  24.922  18.545  1.00 22.08           C  
ATOM   2517  O   CYS C 100      24.445  25.846  17.896  1.00 23.62           O  
ATOM   2518  CB  CYS C 100      25.730  23.589  16.601  1.00 20.20           C  
ATOM   2519  SG  CYS C 100      27.017  22.613  15.754  1.00 18.37           S  
ATOM   2520  N   ALA C 101      24.488  24.570  19.748  1.00 22.74           N  
ATOM   2521  CA  ALA C 101      23.337  25.219  20.381  1.00 21.20           C  
ATOM   2522  C   ALA C 101      23.342  26.747  20.462  1.00 21.59           C  
ATOM   2523  O   ALA C 101      22.283  27.369  20.413  1.00 21.84           O  
ATOM   2524  CB  ALA C 101      23.117  24.625  21.782  1.00 21.53           C  
ATOM   2525  N   THR C 102      24.513  27.358  20.599  1.00 20.35           N  
ATOM   2526  CA  THR C 102      24.589  28.819  20.691  1.00 19.26           C  
ATOM   2527  C   THR C 102      25.552  29.371  19.639  1.00 18.20           C  
ATOM   2528  O   THR C 102      26.246  30.358  19.874  1.00 17.96           O  
ATOM   2529  CB  THR C 102      25.078  29.255  22.093  1.00 22.43           C  
ATOM   2530  OG1 THR C 102      26.375  28.690  22.343  1.00 23.01           O  
ATOM   2531  CG2 THR C 102      24.106  28.776  23.178  1.00 20.84           C  
ATOM   2532  N   ILE C 103      25.564  28.740  18.469  1.00 17.99           N  
ATOM   2533  CA  ILE C 103      26.464  29.119  17.385  1.00 14.57           C  
ATOM   2534  C   ILE C 103      26.446  30.600  16.974  1.00 14.98           C  
ATOM   2535  O   ILE C 103      27.478  31.142  16.583  1.00 13.50           O  
ATOM   2536  CB  ILE C 103      26.211  28.226  16.143  1.00 14.98           C  
ATOM   2537  CG1 ILE C 103      27.330  28.418  15.117  1.00 11.97           C  
ATOM   2538  CG2 ILE C 103      24.848  28.545  15.540  1.00 13.19           C  
ATOM   2539  CD1 ILE C 103      28.716  28.081  15.645  1.00 12.34           C  
ATOM   2540  N   LEU C 104      25.294  31.259  17.072  1.00 14.72           N  
ATOM   2541  CA  LEU C 104      25.204  32.669  16.698  1.00 15.86           C  
ATOM   2542  C   LEU C 104      25.792  33.619  17.746  1.00 17.28           C  
ATOM   2543  O   LEU C 104      26.587  34.496  17.413  1.00 16.82           O  
ATOM   2544  CB  LEU C 104      23.745  33.053  16.410  1.00 16.34           C  
ATOM   2545  CG  LEU C 104      23.098  32.385  15.193  1.00 15.92           C  
ATOM   2546  CD1 LEU C 104      21.653  32.849  15.055  1.00 16.41           C  
ATOM   2547  CD2 LEU C 104      23.900  32.722  13.938  1.00 15.15           C  
ATOM   2548  N   GLU C 105      25.404  33.456  19.007  1.00 18.81           N  
ATOM   2549  CA  GLU C 105      25.930  34.319  20.067  1.00 19.94           C  
ATOM   2550  C   GLU C 105      27.425  34.072  20.210  1.00 20.12           C  
ATOM   2551  O   GLU C 105      28.195  35.005  20.430  1.00 20.24           O  
ATOM   2552  CB  GLU C 105      25.258  34.021  21.411  1.00 24.04           C  
ATOM   2553  CG  GLU C 105      23.745  33.956  21.378  1.00 27.74           C  
ATOM   2554  CD  GLU C 105      23.235  32.563  21.082  1.00 29.23           C  
ATOM   2555  OE1 GLU C 105      23.352  32.112  19.917  1.00 26.10           O  
ATOM   2556  OE2 GLU C 105      22.723  31.917  22.025  1.00 30.43           O  
ATOM   2557  N   ASP C 106      27.825  32.807  20.086  1.00 17.73           N  
ATOM   2558  CA  ASP C 106      29.229  32.416  20.186  1.00 18.18           C  
ATOM   2559  C   ASP C 106      30.104  33.278  19.280  1.00 18.36           C  
ATOM   2560  O   ASP C 106      31.238  33.598  19.626  1.00 18.65           O  
ATOM   2561  CB  ASP C 106      29.414  30.944  19.780  1.00 18.24           C  
ATOM   2562  CG  ASP C 106      28.961  29.968  20.850  1.00 16.66           C  
ATOM   2563  OD1 ASP C 106      28.443  30.423  21.888  1.00 15.77           O  
ATOM   2564  OD2 ASP C 106      29.121  28.740  20.653  1.00 15.92           O  
ATOM   2565  N   TYR C 107      29.582  33.654  18.116  1.00 18.65           N  
ATOM   2566  CA  TYR C 107      30.363  34.459  17.194  1.00 18.15           C  
ATOM   2567  C   TYR C 107      29.805  35.844  16.900  1.00 21.04           C  
ATOM   2568  O   TYR C 107      29.798  36.309  15.757  1.00 18.70           O  
ATOM   2569  CB  TYR C 107      30.621  33.668  15.907  1.00 16.24           C  
ATOM   2570  CG  TYR C 107      31.518  32.471  16.159  1.00 14.71           C  
ATOM   2571  CD1 TYR C 107      30.987  31.226  16.498  1.00 11.88           C  
ATOM   2572  CD2 TYR C 107      32.910  32.604  16.120  1.00 14.67           C  
ATOM   2573  CE1 TYR C 107      31.819  30.143  16.791  1.00 14.25           C  
ATOM   2574  CE2 TYR C 107      33.749  31.532  16.413  1.00 12.63           C  
ATOM   2575  CZ  TYR C 107      33.205  30.306  16.747  1.00 16.40           C  
ATOM   2576  OH  TYR C 107      34.048  29.245  17.032  1.00 17.05           O  
ATOM   2577  N   ASP C 108      29.344  36.491  17.968  1.00 22.87           N  
ATOM   2578  CA  ASP C 108      28.832  37.856  17.934  1.00 24.43           C  
ATOM   2579  C   ASP C 108      27.940  38.218  16.748  1.00 27.33           C  
ATOM   2580  O   ASP C 108      28.251  39.140  15.993  1.00 25.99           O  
ATOM   2581  CB  ASP C 108      30.033  38.800  17.991  1.00 26.20           C  
ATOM   2582  CG  ASP C 108      31.052  38.364  19.033  1.00 27.11           C  
ATOM   2583  OD1 ASP C 108      30.725  38.426  20.234  1.00 26.41           O  
ATOM   2584  OD2 ASP C 108      32.168  37.940  18.657  1.00 26.30           O  
ATOM   2585  N   CYS C 109      26.824  37.506  16.601  1.00 28.31           N  
ATOM   2586  CA  CYS C 109      25.895  37.753  15.500  1.00 30.50           C  
ATOM   2587  C   CYS C 109      25.262  39.137  15.614  1.00 31.96           C  
ATOM   2588  O   CYS C 109      24.773  39.687  14.626  1.00 31.97           O  
ATOM   2589  CB  CYS C 109      24.783  36.697  15.495  1.00 29.07           C  
ATOM   2590  SG  CYS C 109      23.584  36.892  16.858  1.00 30.95           S  
ATOM   2591  N   GLY C 110      25.280  39.696  16.821  1.00 33.18           N  
ATOM   2592  CA  GLY C 110      24.674  40.997  17.034  1.00 34.63           C  
ATOM   2593  C   GLY C 110      23.217  40.883  16.635  1.00 35.64           C  
ATOM   2594  O   GLY C 110      22.610  41.836  16.144  1.00 35.81           O  
ATOM   2595  N   CYS C 111      22.658  39.695  16.851  1.00 36.42           N  
ATOM   2596  CA  CYS C 111      21.273  39.411  16.495  1.00 37.24           C  
ATOM   2597  C   CYS C 111      20.423  38.993  17.701  1.00 39.33           C  
ATOM   2598  O   CYS C 111      19.571  38.091  17.545  1.00 41.30           O  
ATOM   2599  CB  CYS C 111      21.252  38.306  15.428  1.00 35.19           C  
ATOM   2600  SG  CYS C 111      21.758  36.641  15.992  1.00 31.70           S  
TER    2601      CYS C 111                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
