
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  106 (  868),  selected  106 , name 1jra_B
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 1jra_B.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     7_B      -       -           -
LGA    D     8_B      -       -           -
LGA    K     9_B      -       -           -
LGA    V    10_B      -       -           -
LGA    K    11_B      M       3          1.179
LGA    K    12_B      L       4          1.087
LGA    E    13_B      H       5          0.464
LGA    V    14_B      W       6          0.274
LGA    G    15_B      G       7          0.278
LGA    R    16_B      P       8          0.876
LGA    A    17_B      K       9          1.142
LGA    S    18_B      Y      10          1.094
LGA    W    19_B      W      11          0.954
LGA    K    20_B      R      12          1.487
LGA    Y    21_B      S      13          1.871
LGA    F    22_B      L      14          1.472
LGA    H    23_B      H      15          0.882
LGA    T    24_B      L      16          1.347
LGA    L    25_B      Y      17          1.589
LGA    L    26_B      A      18          1.036
LGA    A    27_B      I      19          0.596
LGA    R    28_B      F      20          0.675
LGA    F    29_B      F      21          0.487
LGA    P    30_B      S      22          0.549
LGA    D    31_B      D      23          0.343
LGA    E    32_B      A      24          0.381
LGA    P    33_B      P      25          0.277
LGA    T    34_B      S      26          0.221
LGA    P    35_B      W      27          0.376
LGA    E    36_B      K      28          0.319
LGA    E    37_B      E      29          0.323
LGA    R    38_B      K      30          0.589
LGA    E    39_B      Y      31          0.682
LGA    K    40_B      E      32          0.584
LGA    L    41_B      A      33          0.367
LGA    H    42_B      I      34          1.043
LGA    T    43_B      Q      35          1.254
LGA    F    44_B      W      36          0.857
LGA    I    45_B      I      37          0.681
LGA    G    46_B      L      38          1.578
LGA    L    47_B      N      39          1.867
LGA    Y    48_B      F      40          1.128
LGA    A    49_B      I      41          1.272
LGA    E    50_B      E      42          2.583
LGA    L    51_B      S      43          2.793
LGA    Y    52_B      L      44          1.353
LGA    P    53_B      P      45          1.399
LGA    C    54_B      C      46          1.210
LGA    G    55_B      T      47          1.429
LGA    E    56_B      R      48          1.039
LGA    C    57_B      C      49          0.793
LGA    S    58_B      Q      50          0.858
LGA    Y    59_B      H      51          1.351
LGA    H    60_B      H      52          0.814
LGA    F    61_B      A      53          0.854
LGA    V    62_B      F      54          0.898
LGA    K    63_B      S      55          0.625
LGA    L    64_B      Y      56          0.764
LGA    I    65_B      L      57          1.168
LGA    E    66_B      T      58          1.222
LGA    K    67_B      K      59          1.093
LGA    Y    68_B      N      60          0.975
LGA    P    69_B      P      61          1.854
LGA    V    70_B      L      62          1.664
LGA    Q    71_B      T      63          0.969
LGA    T    72_B      L      64          0.688
LGA    S    73_B      N      65          0.645
LGA    S    74_B      N      66          0.302
LGA    R    75_B      S      67          0.474
LGA    T    76_B      E      68          0.486
LGA    A    77_B      D      69          0.228
LGA    A    78_B      F      70          0.435
LGA    A    79_B      Q      71          0.696
LGA    M    80_B      Y      72          1.021
LGA    W    81_B      W      73          0.808
LGA    G    82_B      T      74          0.781
LGA    C    83_B      F      75          0.496
LGA    H    84_B      A      76          0.627
LGA    I    85_B      F      77          0.640
LGA    H    86_B      H      78          0.330
LGA    N    87_B      N      79          0.507
LGA    K    88_B      N      80          0.672
LGA    V    89_B      V      81          0.523
LGA    N    90_B      N      82          0.538
LGA    E    91_B      N      83          0.917
LGA    Y    92_B      R      84          0.790
LGA    L    93_B      L      85          0.728
LGA    K    94_B      N      86          0.700
LGA    K    95_B      K      87          0.621
LGA    D    96_B      K      88          0.696
LGA    I    97_B      I      89          0.491
LGA    Y    98_B      I      90          1.372
LGA    D    99_B      S      91          1.333
LGA    C   100_B      W      92          1.611
LGA    A   101_B      S      93          2.190
LGA    -       -      E      94           -
LGA    -       -      Y      95           -
LGA    T   102_B      K      96          1.398
LGA    I   103_B      N      97          6.526
LGA    L   104_B      I      98           -
LGA    E   105_B      Y      99          3.893
LGA    D   106_B      E     100          3.602
LGA    Y   107_B      Q     101          5.868
LGA    D   108_B      S     102          1.031
LGA    C   109_B      I     103           #
LGA    G   110_B      L     104           -
LGA    C   111_B      -       -           -
LGA    S   112_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  106  102    5.0     97    1.47    23.71     91.043     6.195

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.109954 * X  +   0.415899 * Y  +  -0.902739 * Z  +  55.570801
  Y_new =  -0.970977 * X  +   0.149141 * Y  +   0.186976 * Z  +  41.132793
  Z_new =   0.212398 * X  +   0.897098 * Y  +   0.387430 * Z  +  -3.562773 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.163121   -1.978471  [ DEG:    66.6419   -113.3581 ]
  Theta =  -0.214029   -2.927564  [ DEG:   -12.2629   -167.7370 ]
  Phi   =  -1.683556    1.458036  [ DEG:   -96.4607     83.5393 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jra_B                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jra_B.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  106  102   5.0   97   1.47   23.71  91.043
REMARK  ---------------------------------------------------------- 
MOLECULE 1jra_B
HEADER    OXIDOREDUCTASE                          13-AUG-01   1JRA              
TITLE     CRYSTAL STRUCTURE OF ERV2P                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ERV2 PROTEIN, MITOCHONDRIAL;                               
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: PROTEASE-RESISTANT DOMAIN;                                 
COMPND   5 SYNONYM: ERV2P SULFHYDRYL OXIDASE;                                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 GENE: ERV2;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 PLYSS;                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PAED4                                     
KEYWDS    FAD, SULFHYDRYL OXIDASE, HELICAL BUNDLE, CXXC                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.GROSS,C.S.SEVIER,A.VALA,C.A.KAISER,D.FASS                           
REVDAT   1   28-DEC-01 1JRA    0                                                
JRNL        AUTH   E.GROSS,C.S.SEVIER,A.VALA,C.A.KAISER,D.FASS                  
JRNL        TITL   A NEW FAD-BINDING FOLD AND INTERSUBUNIT DISULFIDE            
JRNL        TITL 2 SHUTTLE IN THE THIOL OXIDASE ERV2P.                          
JRNL        REF    NAT.STRUCT.BIOL.              V.   9    61 2002              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1JRA A    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JRA B    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JRA C    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JRA D    4   120  UNP    Q12284   ERV2_YEAST      71    187             
SEQRES   1 A  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 A  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 A  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 A  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 A  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 A  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 A  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 A  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 A  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 B  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 B  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 B  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 B  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 B  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 B  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 B  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 B  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 B  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 C  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 C  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 C  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 C  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 C  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 C  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 C  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 C  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 C  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 D  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 D  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 D  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 D  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 D  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 D  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 D  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 D  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 D  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
HET    FAD    334      53                                                       
HET    FAD    335      53                                                       
HET    FAD    336      53                                                       
HET    FAD    337      53                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   5  FAD    4(C27 H33 N9 O15 P2)                                         
FORMUL   9  HOH   *288(H2 O)                                                    
CRYST1   53.630   66.810   60.380  90.00  91.44  90.00 P 1 21 1      8          
ATOM    870  N   ASP B   7      54.965  23.923   9.862  1.00 46.29           N  
ATOM    871  CA  ASP B   7      54.754  22.504  10.272  1.00 45.42           C  
ATOM    872  C   ASP B   7      53.371  22.386  10.918  1.00 43.69           C  
ATOM    873  O   ASP B   7      52.440  23.117  10.555  1.00 42.36           O  
ATOM    874  CB  ASP B   7      55.855  22.080  11.260  1.00 47.79           C  
ATOM    875  CG  ASP B   7      56.021  20.563  11.352  1.00 49.53           C  
ATOM    876  OD1 ASP B   7      55.202  19.898  12.020  1.00 50.09           O  
ATOM    877  OD2 ASP B   7      56.980  20.032  10.750  1.00 50.64           O  
ATOM    878  N   ASP B   8      53.234  21.470  11.870  1.00 39.82           N  
ATOM    879  CA  ASP B   8      51.961  21.277  12.549  1.00 37.52           C  
ATOM    880  C   ASP B   8      51.554  22.577  13.231  1.00 34.37           C  
ATOM    881  O   ASP B   8      50.376  22.923  13.277  1.00 33.12           O  
ATOM    882  CB  ASP B   8      52.078  20.163  13.589  1.00 38.93           C  
ATOM    883  CG  ASP B   8      52.578  18.858  12.995  1.00 40.77           C  
ATOM    884  OD1 ASP B   8      51.970  18.372  12.017  1.00 40.09           O  
ATOM    885  OD2 ASP B   8      53.579  18.316  13.511  1.00 42.19           O  
ATOM    886  N   LYS B   9      52.544  23.290  13.756  1.00 32.05           N  
ATOM    887  CA  LYS B   9      52.317  24.553  14.451  1.00 31.18           C  
ATOM    888  C   LYS B   9      51.578  25.565  13.574  1.00 29.03           C  
ATOM    889  O   LYS B   9      50.511  26.064  13.940  1.00 26.38           O  
ATOM    890  CB  LYS B   9      53.660  25.145  14.895  1.00 33.69           C  
ATOM    891  CG  LYS B   9      53.549  26.497  15.585  1.00 38.01           C  
ATOM    892  CD  LYS B   9      54.916  27.139  15.790  1.00 39.69           C  
ATOM    893  CE  LYS B   9      54.776  28.515  16.432  1.00 41.88           C  
ATOM    894  NZ  LYS B   9      56.081  29.224  16.568  1.00 41.58           N  
ATOM    895  N   VAL B  10      52.157  25.862  12.417  1.00 27.12           N  
ATOM    896  CA  VAL B  10      51.573  26.817  11.485  1.00 25.73           C  
ATOM    897  C   VAL B  10      50.140  26.454  11.146  1.00 23.96           C  
ATOM    898  O   VAL B  10      49.245  27.297  11.207  1.00 22.46           O  
ATOM    899  CB  VAL B  10      52.382  26.880  10.172  1.00 26.61           C  
ATOM    900  CG1 VAL B  10      51.683  27.802   9.165  1.00 28.37           C  
ATOM    901  CG2 VAL B  10      53.795  27.367  10.459  1.00 25.74           C  
ATOM    902  N   LYS B  11      49.928  25.192  10.790  1.00 22.14           N  
ATOM    903  CA  LYS B  11      48.602  24.712  10.424  1.00 20.76           C  
ATOM    904  C   LYS B  11      47.595  24.974  11.539  1.00 18.57           C  
ATOM    905  O   LYS B  11      46.450  25.336  11.275  1.00 15.31           O  
ATOM    906  CB  LYS B  11      48.655  23.215  10.128  1.00 22.79           C  
ATOM    907  CG  LYS B  11      47.532  22.720   9.246  1.00 27.20           C  
ATOM    908  CD  LYS B  11      47.463  21.204   9.234  1.00 31.08           C  
ATOM    909  CE  LYS B  11      48.768  20.567   8.799  1.00 33.21           C  
ATOM    910  NZ  LYS B  11      48.701  19.087   8.979  1.00 35.46           N  
ATOM    911  N   LYS B  12      48.028  24.793  12.784  1.00 14.79           N  
ATOM    912  CA  LYS B  12      47.152  25.000  13.932  1.00 16.26           C  
ATOM    913  C   LYS B  12      46.844  26.470  14.178  1.00 16.71           C  
ATOM    914  O   LYS B  12      45.700  26.832  14.458  1.00 17.53           O  
ATOM    915  CB  LYS B  12      47.774  24.421  15.209  1.00 16.96           C  
ATOM    916  CG  LYS B  12      48.012  22.908  15.215  1.00 20.81           C  
ATOM    917  CD  LYS B  12      48.685  22.506  16.538  1.00 25.53           C  
ATOM    918  CE  LYS B  12      49.395  21.156  16.470  1.00 29.67           C  
ATOM    919  NZ  LYS B  12      48.466  20.015  16.249  1.00 33.18           N  
ATOM    920  N   GLU B  13      47.867  27.312  14.093  1.00 15.52           N  
ATOM    921  CA  GLU B  13      47.697  28.738  14.343  1.00 17.36           C  
ATOM    922  C   GLU B  13      46.840  29.393  13.272  1.00 14.67           C  
ATOM    923  O   GLU B  13      45.958  30.195  13.574  1.00 15.76           O  
ATOM    924  CB  GLU B  13      49.067  29.402  14.440  1.00 19.37           C  
ATOM    925  CG  GLU B  13      49.988  28.651  15.393  1.00 25.69           C  
ATOM    926  CD  GLU B  13      51.260  29.396  15.713  1.00 29.25           C  
ATOM    927  OE1 GLU B  13      51.863  29.980  14.785  1.00 31.75           O  
ATOM    928  OE2 GLU B  13      51.660  29.386  16.897  1.00 31.83           O  
ATOM    929  N   VAL B  14      47.089  29.034  12.020  1.00 13.48           N  
ATOM    930  CA  VAL B  14      46.312  29.571  10.908  1.00 13.68           C  
ATOM    931  C   VAL B  14      44.866  29.061  10.989  1.00 14.16           C  
ATOM    932  O   VAL B  14      43.921  29.821  10.800  1.00 14.15           O  
ATOM    933  CB  VAL B  14      46.939  29.156   9.553  1.00 14.36           C  
ATOM    934  CG1 VAL B  14      46.016  29.534   8.398  1.00 11.85           C  
ATOM    935  CG2 VAL B  14      48.291  29.850   9.383  1.00 13.42           C  
ATOM    936  N   GLY B  15      44.704  27.773  11.281  1.00 12.30           N  
ATOM    937  CA  GLY B  15      43.373  27.200  11.378  1.00 11.19           C  
ATOM    938  C   GLY B  15      42.500  27.886  12.414  1.00 11.33           C  
ATOM    939  O   GLY B  15      41.340  28.186  12.144  1.00 12.15           O  
ATOM    940  N   ARG B  16      43.047  28.131  13.605  1.00 11.88           N  
ATOM    941  CA  ARG B  16      42.286  28.797  14.664  1.00 11.65           C  
ATOM    942  C   ARG B  16      41.804  30.177  14.236  1.00 11.02           C  
ATOM    943  O   ARG B  16      40.647  30.531  14.460  1.00 11.32           O  
ATOM    944  CB  ARG B  16      43.129  28.937  15.932  1.00 10.06           C  
ATOM    945  CG  ARG B  16      43.415  27.630  16.621  1.00 13.00           C  
ATOM    946  CD  ARG B  16      44.474  27.790  17.690  1.00 15.84           C  
ATOM    947  NE  ARG B  16      44.839  26.482  18.213  1.00 20.57           N  
ATOM    948  CZ  ARG B  16      46.075  26.123  18.525  1.00 18.55           C  
ATOM    949  NH1 ARG B  16      47.074  26.983  18.367  1.00 17.52           N  
ATOM    950  NH2 ARG B  16      46.309  24.901  18.984  1.00 18.47           N  
ATOM    951  N   ALA B  17      42.700  30.960  13.638  1.00 12.02           N  
ATOM    952  CA  ALA B  17      42.360  32.306  13.178  1.00 11.73           C  
ATOM    953  C   ALA B  17      41.293  32.234  12.095  1.00 12.30           C  
ATOM    954  O   ALA B  17      40.337  32.999  12.102  1.00 13.44           O  
ATOM    955  CB  ALA B  17      43.608  33.009  12.626  1.00 10.71           C  
ATOM    956  N   SER B  18      41.469  31.309  11.155  1.00 15.28           N  
ATOM    957  CA  SER B  18      40.523  31.146  10.059  1.00 13.54           C  
ATOM    958  C   SER B  18      39.122  30.796  10.550  1.00 12.19           C  
ATOM    959  O   SER B  18      38.141  31.365  10.080  1.00 12.84           O  
ATOM    960  CB  SER B  18      41.016  30.064   9.096  1.00 15.98           C  
ATOM    961  OG  SER B  18      42.275  30.412   8.542  1.00 22.18           O  
ATOM    962  N   TRP B  19      39.027  29.856  11.488  1.00 12.16           N  
ATOM    963  CA  TRP B  19      37.720  29.460  12.015  1.00 12.75           C  
ATOM    964  C   TRP B  19      37.034  30.630  12.700  1.00 13.12           C  
ATOM    965  O   TRP B  19      35.823  30.811  12.572  1.00 14.51           O  
ATOM    966  CB  TRP B  19      37.852  28.308  13.019  1.00 11.78           C  
ATOM    967  CG  TRP B  19      38.216  26.983  12.409  1.00 11.24           C  
ATOM    968  CD1 TRP B  19      39.306  26.214  12.712  1.00  9.07           C  
ATOM    969  CD2 TRP B  19      37.452  26.235  11.453  1.00 10.86           C  
ATOM    970  NE1 TRP B  19      39.265  25.032  12.008  1.00 10.08           N  
ATOM    971  CE2 TRP B  19      38.139  25.018  11.230  1.00 11.37           C  
ATOM    972  CE3 TRP B  19      36.253  26.470  10.766  1.00 12.03           C  
ATOM    973  CZ2 TRP B  19      37.664  24.039  10.347  1.00 12.06           C  
ATOM    974  CZ3 TRP B  19      35.780  25.495   9.890  1.00 11.56           C  
ATOM    975  CH2 TRP B  19      36.489  24.295   9.689  1.00 12.47           C  
ATOM    976  N   LYS B  20      37.808  31.417  13.441  1.00 13.21           N  
ATOM    977  CA  LYS B  20      37.266  32.572  14.145  1.00 15.09           C  
ATOM    978  C   LYS B  20      36.609  33.524  13.142  1.00 15.22           C  
ATOM    979  O   LYS B  20      35.473  33.960  13.329  1.00 14.64           O  
ATOM    980  CB  LYS B  20      38.391  33.272  14.916  1.00 15.72           C  
ATOM    981  CG  LYS B  20      38.021  34.608  15.552  1.00 17.92           C  
ATOM    982  CD  LYS B  20      36.987  34.458  16.657  1.00 19.18           C  
ATOM    983  CE  LYS B  20      36.877  35.749  17.457  1.00 17.69           C  
ATOM    984  NZ  LYS B  20      35.769  35.698  18.447  1.00 15.92           N  
ATOM    985  N   TYR B  21      37.332  33.837  12.074  1.00 16.06           N  
ATOM    986  CA  TYR B  21      36.823  34.717  11.028  1.00 17.05           C  
ATOM    987  C   TYR B  21      35.633  34.048  10.319  1.00 16.63           C  
ATOM    988  O   TYR B  21      34.587  34.672  10.108  1.00 15.98           O  
ATOM    989  CB  TYR B  21      37.952  35.010  10.030  1.00 16.88           C  
ATOM    990  CG  TYR B  21      37.503  35.352   8.625  1.00 18.46           C  
ATOM    991  CD1 TYR B  21      36.930  36.588   8.327  1.00 19.04           C  
ATOM    992  CD2 TYR B  21      37.653  34.431   7.590  1.00 19.02           C  
ATOM    993  CE1 TYR B  21      36.513  36.896   7.020  1.00 18.19           C  
ATOM    994  CE2 TYR B  21      37.242  34.721   6.294  1.00 18.85           C  
ATOM    995  CZ  TYR B  21      36.671  35.952   6.010  1.00 19.28           C  
ATOM    996  OH  TYR B  21      36.232  36.214   4.727  1.00 14.84           O  
ATOM    997  N   PHE B  22      35.820  32.777   9.960  1.00 16.03           N  
ATOM    998  CA  PHE B  22      34.809  31.958   9.274  1.00 15.68           C  
ATOM    999  C   PHE B  22      33.438  31.998   9.961  1.00 15.07           C  
ATOM   1000  O   PHE B  22      32.435  32.388   9.352  1.00 13.87           O  
ATOM   1001  CB  PHE B  22      35.310  30.503   9.201  1.00 15.48           C  
ATOM   1002  CG  PHE B  22      34.354  29.538   8.527  1.00 15.27           C  
ATOM   1003  CD1 PHE B  22      34.226  29.507   7.143  1.00 14.48           C  
ATOM   1004  CD2 PHE B  22      33.628  28.624   9.280  1.00 15.05           C  
ATOM   1005  CE1 PHE B  22      33.394  28.578   6.521  1.00 16.33           C  
ATOM   1006  CE2 PHE B  22      32.789  27.686   8.668  1.00 16.11           C  
ATOM   1007  CZ  PHE B  22      32.674  27.663   7.286  1.00 15.57           C  
ATOM   1008  N   HIS B  23      33.393  31.600  11.232  1.00 15.47           N  
ATOM   1009  CA  HIS B  23      32.129  31.570  11.968  1.00 14.96           C  
ATOM   1010  C   HIS B  23      31.530  32.949  12.234  1.00 15.10           C  
ATOM   1011  O   HIS B  23      30.311  33.093  12.334  1.00 14.57           O  
ATOM   1012  CB  HIS B  23      32.303  30.808  13.287  1.00 14.70           C  
ATOM   1013  CG  HIS B  23      32.618  29.355  13.109  1.00 13.52           C  
ATOM   1014  ND1 HIS B  23      31.746  28.473  12.509  1.00 13.69           N  
ATOM   1015  CD2 HIS B  23      33.708  28.628  13.457  1.00 13.59           C  
ATOM   1016  CE1 HIS B  23      32.284  27.266  12.496  1.00 11.51           C  
ATOM   1017  NE2 HIS B  23      33.474  27.333  13.066  1.00 12.06           N  
ATOM   1018  N   THR B  24      32.376  33.968  12.344  1.00 14.64           N  
ATOM   1019  CA  THR B  24      31.868  35.313  12.586  1.00 15.95           C  
ATOM   1020  C   THR B  24      31.212  35.828  11.306  1.00 16.33           C  
ATOM   1021  O   THR B  24      30.162  36.473  11.342  1.00 15.91           O  
ATOM   1022  CB  THR B  24      32.996  36.271  13.011  1.00 16.67           C  
ATOM   1023  OG1 THR B  24      33.622  35.770  14.197  1.00 16.55           O  
ATOM   1024  CG2 THR B  24      32.431  37.659  13.298  1.00 15.29           C  
ATOM   1025  N   LEU B  25      31.844  35.529  10.176  1.00 16.64           N  
ATOM   1026  CA  LEU B  25      31.330  35.929   8.873  1.00 16.57           C  
ATOM   1027  C   LEU B  25      29.935  35.334   8.662  1.00 18.11           C  
ATOM   1028  O   LEU B  25      29.008  36.032   8.251  1.00 18.25           O  
ATOM   1029  CB  LEU B  25      32.280  35.445   7.765  1.00 15.14           C  
ATOM   1030  CG  LEU B  25      31.953  35.793   6.304  1.00 17.33           C  
ATOM   1031  CD1 LEU B  25      33.204  35.638   5.458  1.00 15.64           C  
ATOM   1032  CD2 LEU B  25      30.835  34.912   5.778  1.00 15.50           C  
ATOM   1033  N   LEU B  26      29.787  34.042   8.949  1.00 17.29           N  
ATOM   1034  CA  LEU B  26      28.502  33.372   8.769  1.00 16.94           C  
ATOM   1035  C   LEU B  26      27.421  33.936   9.689  1.00 18.71           C  
ATOM   1036  O   LEU B  26      26.268  34.093   9.281  1.00 17.12           O  
ATOM   1037  CB  LEU B  26      28.655  31.862   9.004  1.00 17.47           C  
ATOM   1038  CG  LEU B  26      29.549  31.146   7.986  1.00 15.53           C  
ATOM   1039  CD1 LEU B  26      29.817  29.714   8.438  1.00 15.30           C  
ATOM   1040  CD2 LEU B  26      28.885  31.170   6.621  1.00 14.68           C  
ATOM   1041  N   ALA B  27      27.802  34.252  10.922  1.00 19.35           N  
ATOM   1042  CA  ALA B  27      26.866  34.791  11.898  1.00 20.67           C  
ATOM   1043  C   ALA B  27      26.297  36.140  11.481  1.00 21.98           C  
ATOM   1044  O   ALA B  27      25.305  36.599  12.046  1.00 22.10           O  
ATOM   1045  CB  ALA B  27      27.539  34.909  13.257  1.00 19.85           C  
ATOM   1046  N   ARG B  28      26.922  36.773  10.494  1.00 23.99           N  
ATOM   1047  CA  ARG B  28      26.456  38.067  10.014  1.00 27.15           C  
ATOM   1048  C   ARG B  28      25.611  37.950   8.747  1.00 28.08           C  
ATOM   1049  O   ARG B  28      25.040  38.935   8.286  1.00 28.67           O  
ATOM   1050  CB  ARG B  28      27.646  38.996   9.768  1.00 30.38           C  
ATOM   1051  CG  ARG B  28      28.168  39.664  11.025  1.00 33.35           C  
ATOM   1052  CD  ARG B  28      27.395  40.942  11.327  1.00 38.17           C  
ATOM   1053  NE  ARG B  28      27.594  41.944  10.283  1.00 41.74           N  
ATOM   1054  CZ  ARG B  28      27.085  43.174  10.309  1.00 44.72           C  
ATOM   1055  NH1 ARG B  28      26.337  43.568  11.335  1.00 45.47           N  
ATOM   1056  NH2 ARG B  28      27.325  44.014   9.309  1.00 44.67           N  
ATOM   1057  N   PHE B  29      25.533  36.751   8.181  1.00 27.23           N  
ATOM   1058  CA  PHE B  29      24.733  36.548   6.979  1.00 28.14           C  
ATOM   1059  C   PHE B  29      23.291  36.931   7.344  1.00 28.96           C  
ATOM   1060  O   PHE B  29      22.825  36.638   8.442  1.00 28.71           O  
ATOM   1061  CB  PHE B  29      24.811  35.084   6.542  1.00 25.87           C  
ATOM   1062  CG  PHE B  29      24.286  34.831   5.160  1.00 26.39           C  
ATOM   1063  CD1 PHE B  29      24.880  35.437   4.053  1.00 25.93           C  
ATOM   1064  CD2 PHE B  29      23.201  33.988   4.959  1.00 24.33           C  
ATOM   1065  CE1 PHE B  29      24.400  35.204   2.772  1.00 23.77           C  
ATOM   1066  CE2 PHE B  29      22.713  33.747   3.679  1.00 26.00           C  
ATOM   1067  CZ  PHE B  29      23.312  34.356   2.585  1.00 25.93           C  
ATOM   1068  N   PRO B  30      22.569  37.595   6.430  1.00 30.00           N  
ATOM   1069  CA  PRO B  30      21.185  38.008   6.705  1.00 29.99           C  
ATOM   1070  C   PRO B  30      20.174  36.897   7.005  1.00 29.85           C  
ATOM   1071  O   PRO B  30      20.367  35.735   6.633  1.00 28.24           O  
ATOM   1072  CB  PRO B  30      20.812  38.808   5.459  1.00 29.74           C  
ATOM   1073  CG  PRO B  30      21.625  38.147   4.385  1.00 31.60           C  
ATOM   1074  CD  PRO B  30      22.964  37.961   5.059  1.00 30.31           C  
ATOM   1075  N   ASP B  31      19.093  37.271   7.683  1.00 29.76           N  
ATOM   1076  CA  ASP B  31      18.037  36.328   8.029  1.00 31.18           C  
ATOM   1077  C   ASP B  31      17.183  36.016   6.809  1.00 31.74           C  
ATOM   1078  O   ASP B  31      16.620  34.926   6.700  1.00 31.53           O  
ATOM   1079  CB  ASP B  31      17.132  36.910   9.116  1.00 33.71           C  
ATOM   1080  CG  ASP B  31      17.870  37.214  10.395  1.00 34.48           C  
ATOM   1081  OD1 ASP B  31      18.385  36.273  11.033  1.00 37.12           O  
ATOM   1082  OD2 ASP B  31      17.929  38.403  10.760  1.00 36.38           O  
ATOM   1083  N   GLU B  32      17.089  36.983   5.898  1.00 32.00           N  
ATOM   1084  CA  GLU B  32      16.282  36.847   4.684  1.00 34.05           C  
ATOM   1085  C   GLU B  32      17.133  37.138   3.447  1.00 33.25           C  
ATOM   1086  O   GLU B  32      16.818  38.038   2.670  1.00 34.86           O  
ATOM   1087  CB  GLU B  32      15.129  37.853   4.726  1.00 35.91           C  
ATOM   1088  CG  GLU B  32      13.807  37.347   4.202  1.00 41.83           C  
ATOM   1089  CD  GLU B  32      13.055  36.543   5.239  1.00 44.89           C  
ATOM   1090  OE1 GLU B  32      13.484  35.408   5.544  1.00 47.74           O  
ATOM   1091  OE2 GLU B  32      12.038  37.052   5.755  1.00 45.87           O  
ATOM   1092  N   PRO B  33      18.214  36.371   3.237  1.00 32.24           N  
ATOM   1093  CA  PRO B  33      19.067  36.615   2.072  1.00 30.39           C  
ATOM   1094  C   PRO B  33      18.327  36.649   0.742  1.00 28.99           C  
ATOM   1095  O   PRO B  33      17.351  35.927   0.538  1.00 27.49           O  
ATOM   1096  CB  PRO B  33      20.063  35.464   2.133  1.00 30.19           C  
ATOM   1097  CG  PRO B  33      19.228  34.354   2.707  1.00 30.75           C  
ATOM   1098  CD  PRO B  33      18.532  35.068   3.846  1.00 31.05           C  
ATOM   1099  N   THR B  34      18.801  37.497  -0.163  1.00 27.66           N  
ATOM   1100  CA  THR B  34      18.207  37.601  -1.487  1.00 27.43           C  
ATOM   1101  C   THR B  34      18.859  36.500  -2.315  1.00 27.07           C  
ATOM   1102  O   THR B  34      19.890  35.950  -1.923  1.00 27.01           O  
ATOM   1103  CB  THR B  34      18.544  38.938  -2.148  1.00 27.06           C  
ATOM   1104  OG1 THR B  34      19.950  38.980  -2.415  1.00 26.77           O  
ATOM   1105  CG2 THR B  34      18.166  40.103  -1.235  1.00 27.80           C  
ATOM   1106  N   PRO B  35      18.266  36.155  -3.466  1.00 26.94           N  
ATOM   1107  CA  PRO B  35      18.857  35.108  -4.303  1.00 26.33           C  
ATOM   1108  C   PRO B  35      20.327  35.414  -4.602  1.00 26.17           C  
ATOM   1109  O   PRO B  35      21.155  34.511  -4.666  1.00 23.97           O  
ATOM   1110  CB  PRO B  35      17.991  35.150  -5.559  1.00 28.26           C  
ATOM   1111  CG  PRO B  35      16.634  35.491  -5.000  1.00 26.58           C  
ATOM   1112  CD  PRO B  35      16.972  36.602  -4.013  1.00 26.54           C  
ATOM   1113  N   GLU B  36      20.642  36.695  -4.775  1.00 27.05           N  
ATOM   1114  CA  GLU B  36      22.010  37.102  -5.078  1.00 28.54           C  
ATOM   1115  C   GLU B  36      22.944  36.870  -3.889  1.00 26.35           C  
ATOM   1116  O   GLU B  36      24.078  36.425  -4.065  1.00 25.29           O  
ATOM   1117  CB  GLU B  36      22.063  38.583  -5.475  1.00 32.25           C  
ATOM   1118  CG  GLU B  36      21.948  39.536  -4.300  1.00 40.03           C  
ATOM   1119  CD  GLU B  36      22.213  40.980  -4.672  1.00 43.74           C  
ATOM   1120  OE1 GLU B  36      23.292  41.265  -5.239  1.00 46.32           O  
ATOM   1121  OE2 GLU B  36      21.342  41.829  -4.383  1.00 46.70           O  
ATOM   1122  N   GLU B  37      22.472  37.181  -2.685  1.00 26.18           N  
ATOM   1123  CA  GLU B  37      23.290  36.992  -1.493  1.00 26.44           C  
ATOM   1124  C   GLU B  37      23.522  35.509  -1.263  1.00 25.33           C  
ATOM   1125  O   GLU B  37      24.615  35.100  -0.871  1.00 25.13           O  
ATOM   1126  CB  GLU B  37      22.616  37.628  -0.279  1.00 27.08           C  
ATOM   1127  CG  GLU B  37      22.436  39.131  -0.426  1.00 29.39           C  
ATOM   1128  CD  GLU B  37      21.618  39.741   0.693  1.00 28.49           C  
ATOM   1129  OE1 GLU B  37      20.578  39.159   1.064  1.00 28.83           O  
ATOM   1130  OE2 GLU B  37      22.008  40.814   1.192  1.00 30.61           O  
ATOM   1131  N   ARG B  38      22.497  34.699  -1.508  1.00 23.95           N  
ATOM   1132  CA  ARG B  38      22.649  33.260  -1.347  1.00 24.83           C  
ATOM   1133  C   ARG B  38      23.673  32.783  -2.376  1.00 24.78           C  
ATOM   1134  O   ARG B  38      24.482  31.896  -2.104  1.00 22.97           O  
ATOM   1135  CB  ARG B  38      21.314  32.541  -1.562  1.00 25.38           C  
ATOM   1136  CG  ARG B  38      20.267  32.847  -0.497  1.00 27.87           C  
ATOM   1137  CD  ARG B  38      19.017  31.989  -0.656  1.00 29.61           C  
ATOM   1138  NE  ARG B  38      19.309  30.561  -0.538  1.00 33.37           N  
ATOM   1139  CZ  ARG B  38      18.390  29.615  -0.349  1.00 35.17           C  
ATOM   1140  NH1 ARG B  38      17.104  29.934  -0.255  1.00 36.18           N  
ATOM   1141  NH2 ARG B  38      18.756  28.346  -0.247  1.00 35.42           N  
ATOM   1142  N   GLU B  39      23.641  33.389  -3.559  1.00 23.89           N  
ATOM   1143  CA  GLU B  39      24.571  33.019  -4.620  1.00 24.74           C  
ATOM   1144  C   GLU B  39      25.999  33.403  -4.215  1.00 23.23           C  
ATOM   1145  O   GLU B  39      26.937  32.628  -4.400  1.00 23.55           O  
ATOM   1146  CB  GLU B  39      24.180  33.730  -5.924  1.00 26.93           C  
ATOM   1147  CG  GLU B  39      24.927  33.262  -7.174  1.00 30.15           C  
ATOM   1148  CD  GLU B  39      26.394  33.650  -7.174  1.00 32.92           C  
ATOM   1149  OE1 GLU B  39      26.694  34.849  -6.992  1.00 33.94           O  
ATOM   1150  OE2 GLU B  39      27.247  32.756  -7.362  1.00 34.65           O  
ATOM   1151  N   LYS B  40      26.153  34.597  -3.651  1.00 22.45           N  
ATOM   1152  CA  LYS B  40      27.465  35.074  -3.240  1.00 22.49           C  
ATOM   1153  C   LYS B  40      28.081  34.242  -2.126  1.00 21.79           C  
ATOM   1154  O   LYS B  40      29.267  33.915  -2.182  1.00 21.23           O  
ATOM   1155  CB  LYS B  40      27.390  36.539  -2.820  1.00 22.31           C  
ATOM   1156  CG  LYS B  40      27.215  37.480  -3.998  1.00 25.36           C  
ATOM   1157  CD  LYS B  40      27.177  38.931  -3.554  1.00 27.88           C  
ATOM   1158  CE  LYS B  40      26.979  39.854  -4.750  1.00 30.78           C  
ATOM   1159  NZ  LYS B  40      26.908  41.286  -4.347  1.00 33.16           N  
ATOM   1160  N   LEU B  41      27.291  33.901  -1.114  1.00 21.12           N  
ATOM   1161  CA  LEU B  41      27.823  33.089  -0.028  1.00 20.97           C  
ATOM   1162  C   LEU B  41      28.268  31.748  -0.608  1.00 20.46           C  
ATOM   1163  O   LEU B  41      29.324  31.228  -0.247  1.00 20.14           O  
ATOM   1164  CB  LEU B  41      26.771  32.885   1.069  1.00 18.06           C  
ATOM   1165  CG  LEU B  41      27.240  32.083   2.291  1.00 18.53           C  
ATOM   1166  CD1 LEU B  41      28.577  32.624   2.806  1.00 14.54           C  
ATOM   1167  CD2 LEU B  41      26.170  32.156   3.377  1.00 16.72           C  
ATOM   1168  N   HIS B  42      27.471  31.196  -1.520  1.00 18.99           N  
ATOM   1169  CA  HIS B  42      27.821  29.926  -2.150  1.00 18.50           C  
ATOM   1170  C   HIS B  42      29.172  30.028  -2.868  1.00 17.63           C  
ATOM   1171  O   HIS B  42      30.041  29.171  -2.712  1.00 17.98           O  
ATOM   1172  CB  HIS B  42      26.752  29.508  -3.169  1.00 19.77           C  
ATOM   1173  CG  HIS B  42      27.097  28.256  -3.916  1.00 17.84           C  
ATOM   1174  ND1 HIS B  42      26.946  26.999  -3.372  1.00 19.80           N  
ATOM   1175  CD2 HIS B  42      27.634  28.069  -5.145  1.00 18.49           C  
ATOM   1176  CE1 HIS B  42      27.378  26.092  -4.231  1.00 16.48           C  
ATOM   1177  NE2 HIS B  42      27.801  26.716  -5.314  1.00 20.62           N  
ATOM   1178  N   THR B  43      29.344  31.075  -3.662  1.00 16.09           N  
ATOM   1179  CA  THR B  43      30.595  31.261  -4.385  1.00 17.88           C  
ATOM   1180  C   THR B  43      31.771  31.539  -3.439  1.00 15.87           C  
ATOM   1181  O   THR B  43      32.888  31.085  -3.679  1.00 15.04           O  
ATOM   1182  CB  THR B  43      30.466  32.407  -5.415  1.00 18.37           C  
ATOM   1183  OG1 THR B  43      29.451  32.061  -6.368  1.00 21.79           O  
ATOM   1184  CG2 THR B  43      31.786  32.632  -6.156  1.00 17.03           C  
ATOM   1185  N   PHE B  44      31.521  32.278  -2.363  1.00 16.05           N  
ATOM   1186  CA  PHE B  44      32.577  32.586  -1.401  1.00 16.66           C  
ATOM   1187  C   PHE B  44      33.100  31.301  -0.772  1.00 16.89           C  
ATOM   1188  O   PHE B  44      34.310  31.086  -0.675  1.00 17.93           O  
ATOM   1189  CB  PHE B  44      32.054  33.508  -0.292  1.00 17.19           C  
ATOM   1190  CG  PHE B  44      33.025  33.692   0.852  1.00 18.24           C  
ATOM   1191  CD1 PHE B  44      34.059  34.618   0.767  1.00 17.56           C  
ATOM   1192  CD2 PHE B  44      32.918  32.910   2.006  1.00 18.51           C  
ATOM   1193  CE1 PHE B  44      34.982  34.767   1.819  1.00 20.67           C  
ATOM   1194  CE2 PHE B  44      33.835  33.049   3.064  1.00 19.57           C  
ATOM   1195  CZ  PHE B  44      34.868  33.980   2.967  1.00 17.60           C  
ATOM   1196  N   ILE B  45      32.180  30.445  -0.349  1.00 16.17           N  
ATOM   1197  CA  ILE B  45      32.546  29.186   0.284  1.00 15.53           C  
ATOM   1198  C   ILE B  45      33.390  28.314  -0.646  1.00 16.84           C  
ATOM   1199  O   ILE B  45      34.373  27.708  -0.215  1.00 14.40           O  
ATOM   1200  CB  ILE B  45      31.282  28.415   0.735  1.00 16.51           C  
ATOM   1201  CG1 ILE B  45      30.582  29.191   1.860  1.00 16.58           C  
ATOM   1202  CG2 ILE B  45      31.646  27.016   1.200  1.00 16.58           C  
ATOM   1203  CD1 ILE B  45      31.463  29.469   3.071  1.00 16.25           C  
ATOM   1204  N   GLY B  46      33.009  28.255  -1.920  1.00 16.09           N  
ATOM   1205  CA  GLY B  46      33.767  27.463  -2.869  1.00 14.47           C  
ATOM   1206  C   GLY B  46      35.187  27.982  -3.001  1.00 16.40           C  
ATOM   1207  O   GLY B  46      36.142  27.200  -3.049  1.00 16.31           O  
ATOM   1208  N   LEU B  47      35.330  29.307  -3.057  1.00 16.93           N  
ATOM   1209  CA  LEU B  47      36.646  29.938  -3.181  1.00 15.54           C  
ATOM   1210  C   LEU B  47      37.414  29.821  -1.871  1.00 15.64           C  
ATOM   1211  O   LEU B  47      38.627  29.623  -1.873  1.00 14.51           O  
ATOM   1212  CB  LEU B  47      36.495  31.415  -3.567  1.00 16.31           C  
ATOM   1213  CG  LEU B  47      35.868  31.637  -4.946  1.00 17.96           C  
ATOM   1214  CD1 LEU B  47      35.710  33.121  -5.233  1.00 17.96           C  
ATOM   1215  CD2 LEU B  47      36.752  30.985  -5.996  1.00 20.08           C  
ATOM   1216  N   TYR B  48      36.697  29.954  -0.758  1.00 15.47           N  
ATOM   1217  CA  TYR B  48      37.296  29.841   0.566  1.00 15.22           C  
ATOM   1218  C   TYR B  48      37.979  28.479   0.660  1.00 14.79           C  
ATOM   1219  O   TYR B  48      39.129  28.373   1.070  1.00 15.65           O  
ATOM   1220  CB  TYR B  48      36.207  29.953   1.640  1.00 16.09           C  
ATOM   1221  CG  TYR B  48      36.709  29.770   3.059  1.00 18.85           C  
ATOM   1222  CD1 TYR B  48      37.280  30.829   3.765  1.00 17.64           C  
ATOM   1223  CD2 TYR B  48      36.632  28.526   3.685  1.00 18.81           C  
ATOM   1224  CE1 TYR B  48      37.767  30.648   5.070  1.00 19.89           C  
ATOM   1225  CE2 TYR B  48      37.111  28.333   4.977  1.00 20.82           C  
ATOM   1226  CZ  TYR B  48      37.676  29.397   5.665  1.00 21.65           C  
ATOM   1227  OH  TYR B  48      38.134  29.196   6.946  1.00 20.26           O  
ATOM   1228  N   ALA B  49      37.262  27.436   0.255  1.00 15.82           N  
ATOM   1229  CA  ALA B  49      37.787  26.076   0.301  1.00 16.25           C  
ATOM   1230  C   ALA B  49      38.946  25.855  -0.668  1.00 16.00           C  
ATOM   1231  O   ALA B  49      39.978  25.303  -0.306  1.00 14.68           O  
ATOM   1232  CB  ALA B  49      36.673  25.085   0.003  1.00 16.31           C  
ATOM   1233  N   GLU B  50      38.772  26.302  -1.901  1.00 15.59           N  
ATOM   1234  CA  GLU B  50      39.793  26.126  -2.917  1.00 17.14           C  
ATOM   1235  C   GLU B  50      41.091  26.891  -2.637  1.00 16.93           C  
ATOM   1236  O   GLU B  50      42.180  26.402  -2.938  1.00 17.18           O  
ATOM   1237  CB  GLU B  50      39.205  26.532  -4.267  1.00 20.77           C  
ATOM   1238  CG  GLU B  50      40.122  26.371  -5.445  1.00 27.91           C  
ATOM   1239  CD  GLU B  50      39.377  26.519  -6.755  1.00 29.50           C  
ATOM   1240  OE1 GLU B  50      38.459  27.368  -6.823  1.00 32.09           O  
ATOM   1241  OE2 GLU B  50      39.710  25.795  -7.713  1.00 32.42           O  
ATOM   1242  N   LEU B  51      40.976  28.076  -2.042  1.00 16.41           N  
ATOM   1243  CA  LEU B  51      42.142  28.903  -1.751  1.00 16.14           C  
ATOM   1244  C   LEU B  51      42.717  28.755  -0.342  1.00 15.84           C  
ATOM   1245  O   LEU B  51      43.687  29.436  -0.005  1.00 13.91           O  
ATOM   1246  CB  LEU B  51      41.800  30.382  -1.997  1.00 15.38           C  
ATOM   1247  CG  LEU B  51      41.352  30.769  -3.414  1.00 17.74           C  
ATOM   1248  CD1 LEU B  51      40.836  32.194  -3.430  1.00 16.91           C  
ATOM   1249  CD2 LEU B  51      42.510  30.620  -4.379  1.00 18.84           C  
ATOM   1250  N   TYR B  52      42.137  27.881   0.479  1.00 14.95           N  
ATOM   1251  CA  TYR B  52      42.628  27.714   1.844  1.00 14.83           C  
ATOM   1252  C   TYR B  52      44.126  27.391   1.866  1.00 16.06           C  
ATOM   1253  O   TYR B  52      44.579  26.468   1.192  1.00 15.17           O  
ATOM   1254  CB  TYR B  52      41.846  26.626   2.588  1.00 14.42           C  
ATOM   1255  CG  TYR B  52      42.114  26.689   4.072  1.00 15.42           C  
ATOM   1256  CD1 TYR B  52      41.555  27.700   4.855  1.00 13.85           C  
ATOM   1257  CD2 TYR B  52      43.024  25.822   4.670  1.00 13.61           C  
ATOM   1258  CE1 TYR B  52      41.905  27.850   6.194  1.00 14.71           C  
ATOM   1259  CE2 TYR B  52      43.383  25.965   6.009  1.00 16.45           C  
ATOM   1260  CZ  TYR B  52      42.823  26.983   6.762  1.00 16.27           C  
ATOM   1261  OH  TYR B  52      43.195  27.141   8.077  1.00 16.38           O  
ATOM   1262  N   PRO B  53      44.907  28.155   2.658  1.00 17.72           N  
ATOM   1263  CA  PRO B  53      46.364  28.082   2.865  1.00 18.90           C  
ATOM   1264  C   PRO B  53      46.968  26.817   3.482  1.00 19.56           C  
ATOM   1265  O   PRO B  53      47.797  26.911   4.391  1.00 17.69           O  
ATOM   1266  CB  PRO B  53      46.659  29.298   3.752  1.00 18.19           C  
ATOM   1267  CG  PRO B  53      45.446  30.149   3.648  1.00 20.03           C  
ATOM   1268  CD  PRO B  53      44.325  29.192   3.527  1.00 17.72           C  
ATOM   1269  N   CYS B  54      46.559  25.647   3.008  1.00 20.16           N  
ATOM   1270  CA  CYS B  54      47.101  24.376   3.499  1.00 20.32           C  
ATOM   1271  C   CYS B  54      46.647  23.283   2.540  1.00 20.78           C  
ATOM   1272  O   CYS B  54      45.451  23.040   2.380  1.00 21.76           O  
ATOM   1273  CB  CYS B  54      46.642  24.079   4.940  1.00 19.72           C  
ATOM   1274  SG  CYS B  54      46.594  22.295   5.346  1.00 21.51           S  
ATOM   1275  N   GLY B  55      47.622  22.651   1.892  1.00 19.70           N  
ATOM   1276  CA  GLY B  55      47.354  21.615   0.909  1.00 21.68           C  
ATOM   1277  C   GLY B  55      46.323  20.558   1.245  1.00 21.85           C  
ATOM   1278  O   GLY B  55      45.271  20.485   0.607  1.00 22.13           O  
ATOM   1279  N   GLU B  56      46.635  19.722   2.230  1.00 21.74           N  
ATOM   1280  CA  GLU B  56      45.730  18.655   2.646  1.00 22.01           C  
ATOM   1281  C   GLU B  56      44.402  19.217   3.147  1.00 19.91           C  
ATOM   1282  O   GLU B  56      43.347  18.651   2.880  1.00 18.71           O  
ATOM   1283  CB  GLU B  56      46.374  17.816   3.751  1.00 25.65           C  
ATOM   1284  CG  GLU B  56      46.637  18.588   5.033  1.00 31.44           C  
ATOM   1285  CD  GLU B  56      47.256  17.730   6.120  1.00 35.77           C  
ATOM   1286  OE1 GLU B  56      46.646  16.700   6.482  1.00 35.58           O  
ATOM   1287  OE2 GLU B  56      48.351  18.094   6.611  1.00 35.96           O  
ATOM   1288  N   CYS B  57      44.458  20.332   3.869  1.00 19.08           N  
ATOM   1289  CA  CYS B  57      43.246  20.946   4.403  1.00 18.73           C  
ATOM   1290  C   CYS B  57      42.272  21.309   3.277  1.00 19.43           C  
ATOM   1291  O   CYS B  57      41.079  20.993   3.340  1.00 18.27           O  
ATOM   1292  CB  CYS B  57      43.586  22.212   5.184  1.00 19.25           C  
ATOM   1293  SG  CYS B  57      44.897  22.127   6.449  1.00 17.31           S  
ATOM   1294  N   SER B  58      42.786  21.988   2.256  1.00 20.19           N  
ATOM   1295  CA  SER B  58      41.968  22.390   1.113  1.00 22.25           C  
ATOM   1296  C   SER B  58      41.423  21.144   0.417  1.00 22.97           C  
ATOM   1297  O   SER B  58      40.246  21.086   0.046  1.00 23.10           O  
ATOM   1298  CB  SER B  58      42.803  23.214   0.127  1.00 21.92           C  
ATOM   1299  OG  SER B  58      42.013  23.654  -0.966  1.00 23.37           O  
ATOM   1300  N   TYR B  59      42.290  20.151   0.245  1.00 23.38           N  
ATOM   1301  CA  TYR B  59      41.902  18.895  -0.394  1.00 24.47           C  
ATOM   1302  C   TYR B  59      40.664  18.309   0.288  1.00 22.53           C  
ATOM   1303  O   TYR B  59      39.672  17.995  -0.367  1.00 19.61           O  
ATOM   1304  CB  TYR B  59      43.053  17.882  -0.319  1.00 28.08           C  
ATOM   1305  CG  TYR B  59      42.654  16.486  -0.737  1.00 32.10           C  
ATOM   1306  CD1 TYR B  59      42.389  16.185  -2.074  1.00 35.33           C  
ATOM   1307  CD2 TYR B  59      42.491  15.476   0.211  1.00 34.27           C  
ATOM   1308  CE1 TYR B  59      41.967  14.910  -2.459  1.00 37.40           C  
ATOM   1309  CE2 TYR B  59      42.068  14.197  -0.161  1.00 36.97           C  
ATOM   1310  CZ  TYR B  59      41.810  13.923  -1.496  1.00 38.83           C  
ATOM   1311  OH  TYR B  59      41.389  12.666  -1.867  1.00 41.08           O  
ATOM   1312  N   HIS B  60      40.733  18.170   1.608  1.00 21.64           N  
ATOM   1313  CA  HIS B  60      39.628  17.617   2.385  1.00 20.06           C  
ATOM   1314  C   HIS B  60      38.424  18.545   2.439  1.00 19.29           C  
ATOM   1315  O   HIS B  60      37.282  18.101   2.334  1.00 20.66           O  
ATOM   1316  CB  HIS B  60      40.085  17.323   3.816  1.00 20.45           C  
ATOM   1317  CG  HIS B  60      41.047  16.180   3.925  1.00 24.27           C  
ATOM   1318  ND1 HIS B  60      42.195  16.244   4.686  1.00 23.56           N  
ATOM   1319  CD2 HIS B  60      41.025  14.940   3.381  1.00 24.48           C  
ATOM   1320  CE1 HIS B  60      42.839  15.094   4.604  1.00 26.40           C  
ATOM   1321  NE2 HIS B  60      42.150  14.284   3.819  1.00 27.68           N  
ATOM   1322  N   PHE B  61      38.679  19.840   2.597  1.00 18.23           N  
ATOM   1323  CA  PHE B  61      37.595  20.797   2.709  1.00 18.94           C  
ATOM   1324  C   PHE B  61      36.789  21.026   1.433  1.00 18.97           C  
ATOM   1325  O   PHE B  61      35.594  21.329   1.504  1.00 19.94           O  
ATOM   1326  CB  PHE B  61      38.114  22.132   3.240  1.00 18.50           C  
ATOM   1327  CG  PHE B  61      37.057  22.948   3.913  1.00 18.48           C  
ATOM   1328  CD1 PHE B  61      36.383  22.442   5.021  1.00 19.95           C  
ATOM   1329  CD2 PHE B  61      36.724  24.210   3.443  1.00 19.37           C  
ATOM   1330  CE1 PHE B  61      35.388  23.187   5.656  1.00 21.60           C  
ATOM   1331  CE2 PHE B  61      35.733  24.966   4.066  1.00 19.21           C  
ATOM   1332  CZ  PHE B  61      35.061  24.452   5.179  1.00 20.50           C  
ATOM   1333  N   VAL B  62      37.429  20.898   0.275  1.00 19.16           N  
ATOM   1334  CA  VAL B  62      36.712  21.074  -0.986  1.00 20.22           C  
ATOM   1335  C   VAL B  62      35.701  19.941  -1.123  1.00 20.72           C  
ATOM   1336  O   VAL B  62      34.557  20.164  -1.514  1.00 22.77           O  
ATOM   1337  CB  VAL B  62      37.659  21.035  -2.194  1.00 21.42           C  
ATOM   1338  CG1 VAL B  62      36.850  21.034  -3.492  1.00 20.81           C  
ATOM   1339  CG2 VAL B  62      38.588  22.229  -2.158  1.00 19.46           C  
ATOM   1340  N   LYS B  63      36.120  18.726  -0.786  1.00 21.66           N  
ATOM   1341  CA  LYS B  63      35.231  17.570  -0.872  1.00 22.53           C  
ATOM   1342  C   LYS B  63      34.096  17.663   0.144  1.00 22.35           C  
ATOM   1343  O   LYS B  63      32.961  17.267  -0.136  1.00 22.87           O  
ATOM   1344  CB  LYS B  63      36.022  16.277  -0.666  1.00 24.58           C  
ATOM   1345  CG  LYS B  63      37.006  15.981  -1.787  1.00 29.47           C  
ATOM   1346  CD  LYS B  63      37.715  14.653  -1.564  1.00 33.14           C  
ATOM   1347  CE  LYS B  63      38.621  14.306  -2.737  1.00 35.85           C  
ATOM   1348  NZ  LYS B  63      37.851  14.122  -4.002  1.00 38.29           N  
ATOM   1349  N   LEU B  64      34.395  18.199   1.323  1.00 21.04           N  
ATOM   1350  CA  LEU B  64      33.381  18.350   2.357  1.00 20.82           C  
ATOM   1351  C   LEU B  64      32.273  19.318   1.957  1.00 20.96           C  
ATOM   1352  O   LEU B  64      31.099  19.003   2.120  1.00 21.58           O  
ATOM   1353  CB  LEU B  64      34.006  18.824   3.675  1.00 20.90           C  
ATOM   1354  CG  LEU B  64      34.654  17.781   4.586  1.00 22.32           C  
ATOM   1355  CD1 LEU B  64      35.174  18.470   5.843  1.00 20.36           C  
ATOM   1356  CD2 LEU B  64      33.629  16.699   4.952  1.00 20.38           C  
ATOM   1357  N   ILE B  65      32.625  20.492   1.440  1.00 21.08           N  
ATOM   1358  CA  ILE B  65      31.592  21.452   1.064  1.00 23.79           C  
ATOM   1359  C   ILE B  65      30.772  20.992  -0.139  1.00 26.04           C  
ATOM   1360  O   ILE B  65      29.631  21.420  -0.311  1.00 27.21           O  
ATOM   1361  CB  ILE B  65      32.167  22.859   0.780  1.00 24.55           C  
ATOM   1362  CG1 ILE B  65      33.053  22.835  -0.461  1.00 26.41           C  
ATOM   1363  CG2 ILE B  65      32.942  23.345   1.985  1.00 26.07           C  
ATOM   1364  CD1 ILE B  65      33.309  24.197  -1.038  1.00 26.88           C  
ATOM   1365  N   GLU B  66      31.341  20.127  -0.973  1.00 27.87           N  
ATOM   1366  CA  GLU B  66      30.594  19.619  -2.119  1.00 29.89           C  
ATOM   1367  C   GLU B  66      29.672  18.508  -1.626  1.00 30.62           C  
ATOM   1368  O   GLU B  66      28.564  18.334  -2.136  1.00 32.23           O  
ATOM   1369  CB  GLU B  66      31.533  19.073  -3.197  1.00 31.29           C  
ATOM   1370  CG  GLU B  66      32.606  20.051  -3.641  1.00 34.20           C  
ATOM   1371  CD  GLU B  66      33.197  19.700  -4.991  1.00 35.57           C  
ATOM   1372  OE1 GLU B  66      33.358  18.494  -5.278  1.00 37.62           O  
ATOM   1373  OE2 GLU B  66      33.510  20.633  -5.759  1.00 36.16           O  
ATOM   1374  N   LYS B  67      30.130  17.764  -0.622  1.00 30.70           N  
ATOM   1375  CA  LYS B  67      29.341  16.677  -0.052  1.00 30.26           C  
ATOM   1376  C   LYS B  67      28.226  17.234   0.840  1.00 30.34           C  
ATOM   1377  O   LYS B  67      27.144  16.650   0.941  1.00 29.77           O  
ATOM   1378  CB  LYS B  67      30.236  15.742   0.762  1.00 29.69           C  
ATOM   1379  CG  LYS B  67      29.555  14.450   1.177  1.00 33.49           C  
ATOM   1380  CD  LYS B  67      30.483  13.561   1.998  1.00 34.50           C  
ATOM   1381  CE  LYS B  67      29.830  12.218   2.304  1.00 37.05           C  
ATOM   1382  NZ  LYS B  67      30.664  11.362   3.205  1.00 38.77           N  
ATOM   1383  N   TYR B  68      28.503  18.360   1.490  1.00 29.32           N  
ATOM   1384  CA  TYR B  68      27.533  19.027   2.361  1.00 28.52           C  
ATOM   1385  C   TYR B  68      27.547  20.512   2.011  1.00 27.74           C  
ATOM   1386  O   TYR B  68      28.138  21.319   2.730  1.00 27.42           O  
ATOM   1387  CB  TYR B  68      27.911  18.864   3.838  1.00 29.73           C  
ATOM   1388  CG  TYR B  68      28.162  17.441   4.276  1.00 30.70           C  
ATOM   1389  CD1 TYR B  68      29.452  16.912   4.289  1.00 30.61           C  
ATOM   1390  CD2 TYR B  68      27.109  16.621   4.683  1.00 32.30           C  
ATOM   1391  CE1 TYR B  68      29.689  15.600   4.702  1.00 31.18           C  
ATOM   1392  CE2 TYR B  68      27.334  15.309   5.096  1.00 31.65           C  
ATOM   1393  CZ  TYR B  68      28.624  14.806   5.103  1.00 32.37           C  
ATOM   1394  OH  TYR B  68      28.847  13.509   5.509  1.00 34.08           O  
ATOM   1395  N   PRO B  69      26.886  20.890   0.904  1.00 27.42           N  
ATOM   1396  CA  PRO B  69      26.825  22.285   0.447  1.00 26.93           C  
ATOM   1397  C   PRO B  69      26.348  23.274   1.506  1.00 26.18           C  
ATOM   1398  O   PRO B  69      25.513  22.943   2.345  1.00 26.00           O  
ATOM   1399  CB  PRO B  69      25.886  22.213  -0.756  1.00 27.80           C  
ATOM   1400  CG  PRO B  69      24.981  21.058  -0.403  1.00 29.82           C  
ATOM   1401  CD  PRO B  69      25.960  20.046   0.129  1.00 26.86           C  
ATOM   1402  N   VAL B  70      26.883  24.491   1.462  1.00 23.91           N  
ATOM   1403  CA  VAL B  70      26.504  25.513   2.425  1.00 22.86           C  
ATOM   1404  C   VAL B  70      25.004  25.785   2.377  1.00 23.58           C  
ATOM   1405  O   VAL B  70      24.421  25.928   1.302  1.00 22.74           O  
ATOM   1406  CB  VAL B  70      27.280  26.841   2.178  1.00 24.26           C  
ATOM   1407  CG1 VAL B  70      27.044  27.347   0.757  1.00 23.67           C  
ATOM   1408  CG2 VAL B  70      26.860  27.888   3.197  1.00 25.27           C  
ATOM   1409  N   GLN B  71      24.383  25.838   3.550  1.00 22.72           N  
ATOM   1410  CA  GLN B  71      22.952  26.109   3.650  1.00 24.01           C  
ATOM   1411  C   GLN B  71      22.810  27.625   3.719  1.00 24.15           C  
ATOM   1412  O   GLN B  71      23.179  28.243   4.713  1.00 25.16           O  
ATOM   1413  CB  GLN B  71      22.386  25.442   4.905  1.00 22.08           C  
ATOM   1414  CG  GLN B  71      22.574  23.936   4.901  1.00 24.19           C  
ATOM   1415  CD  GLN B  71      21.802  23.266   3.776  1.00 26.31           C  
ATOM   1416  OE1 GLN B  71      20.575  23.300   3.752  1.00 26.76           O  
ATOM   1417  NE2 GLN B  71      22.518  22.661   2.835  1.00 25.58           N  
ATOM   1418  N   THR B  72      22.267  28.215   2.658  1.00 25.18           N  
ATOM   1419  CA  THR B  72      22.137  29.665   2.563  1.00 25.67           C  
ATOM   1420  C   THR B  72      20.730  30.248   2.683  1.00 26.46           C  
ATOM   1421  O   THR B  72      20.532  31.429   2.408  1.00 27.22           O  
ATOM   1422  CB  THR B  72      22.726  30.150   1.228  1.00 25.34           C  
ATOM   1423  OG1 THR B  72      21.966  29.595   0.147  1.00 22.83           O  
ATOM   1424  CG2 THR B  72      24.173  29.691   1.087  1.00 25.98           C  
ATOM   1425  N   SER B  73      19.755  29.444   3.092  1.00 26.36           N  
ATOM   1426  CA  SER B  73      18.390  29.948   3.209  1.00 26.69           C  
ATOM   1427  C   SER B  73      18.244  31.053   4.251  1.00 25.90           C  
ATOM   1428  O   SER B  73      17.325  31.870   4.163  1.00 27.05           O  
ATOM   1429  CB  SER B  73      17.423  28.813   3.547  1.00 27.22           C  
ATOM   1430  OG  SER B  73      17.549  28.427   4.903  1.00 30.48           O  
ATOM   1431  N   SER B  74      19.136  31.080   5.237  1.00 24.03           N  
ATOM   1432  CA  SER B  74      19.069  32.101   6.280  1.00 22.19           C  
ATOM   1433  C   SER B  74      20.337  32.173   7.116  1.00 23.44           C  
ATOM   1434  O   SER B  74      21.236  31.341   6.986  1.00 23.11           O  
ATOM   1435  CB  SER B  74      17.898  31.823   7.218  1.00 23.34           C  
ATOM   1436  OG  SER B  74      18.153  30.667   8.001  1.00 20.38           O  
ATOM   1437  N   ARG B  75      20.391  33.181   7.980  1.00 24.08           N  
ATOM   1438  CA  ARG B  75      21.524  33.380   8.872  1.00 24.26           C  
ATOM   1439  C   ARG B  75      21.718  32.123   9.717  1.00 24.66           C  
ATOM   1440  O   ARG B  75      22.796  31.531   9.733  1.00 25.41           O  
ATOM   1441  CB  ARG B  75      21.263  34.574   9.797  1.00 25.37           C  
ATOM   1442  CG  ARG B  75      22.371  34.824  10.818  1.00 27.14           C  
ATOM   1443  CD  ARG B  75      21.867  35.585  12.038  1.00 31.38           C  
ATOM   1444  NE  ARG B  75      21.275  36.879  11.708  1.00 36.01           N  
ATOM   1445  CZ  ARG B  75      21.937  37.895  11.163  1.00 38.56           C  
ATOM   1446  NH1 ARG B  75      23.226  37.779  10.876  1.00 40.68           N  
ATOM   1447  NH2 ARG B  75      21.310  39.036  10.908  1.00 39.95           N  
ATOM   1448  N   THR B  76      20.658  31.722  10.415  1.00 23.43           N  
ATOM   1449  CA  THR B  76      20.697  30.540  11.272  1.00 22.15           C  
ATOM   1450  C   THR B  76      21.163  29.304  10.506  1.00 21.41           C  
ATOM   1451  O   THR B  76      22.047  28.584  10.967  1.00 23.26           O  
ATOM   1452  CB  THR B  76      19.306  30.255  11.897  1.00 22.07           C  
ATOM   1453  OG1 THR B  76      18.881  31.393  12.656  1.00 20.23           O  
ATOM   1454  CG2 THR B  76      19.367  29.048  12.813  1.00 22.68           C  
ATOM   1455  N   ALA B  77      20.575  29.062   9.339  1.00 19.30           N  
ATOM   1456  CA  ALA B  77      20.949  27.910   8.527  1.00 18.88           C  
ATOM   1457  C   ALA B  77      22.420  27.932   8.124  1.00 18.58           C  
ATOM   1458  O   ALA B  77      23.070  26.889   8.093  1.00 18.63           O  
ATOM   1459  CB  ALA B  77      20.079  27.841   7.279  1.00 20.13           C  
ATOM   1460  N   ALA B  78      22.935  29.119   7.814  1.00 17.21           N  
ATOM   1461  CA  ALA B  78      24.328  29.275   7.402  1.00 18.03           C  
ATOM   1462  C   ALA B  78      25.323  29.115   8.553  1.00 16.57           C  
ATOM   1463  O   ALA B  78      26.300  28.381   8.438  1.00 16.92           O  
ATOM   1464  CB  ALA B  78      24.519  30.628   6.730  1.00 16.66           C  
ATOM   1465  N   ALA B  79      25.086  29.809   9.659  1.00 16.18           N  
ATOM   1466  CA  ALA B  79      25.978  29.700  10.807  1.00 16.58           C  
ATOM   1467  C   ALA B  79      25.950  28.273  11.365  1.00 15.96           C  
ATOM   1468  O   ALA B  79      26.968  27.755  11.838  1.00 15.38           O  
ATOM   1469  CB  ALA B  79      25.568  30.698  11.889  1.00 14.89           C  
ATOM   1470  N   MET B  80      24.779  27.646  11.316  1.00 16.38           N  
ATOM   1471  CA  MET B  80      24.625  26.282  11.812  1.00 17.49           C  
ATOM   1472  C   MET B  80      25.411  25.363  10.883  1.00 17.84           C  
ATOM   1473  O   MET B  80      26.108  24.453  11.340  1.00 19.79           O  
ATOM   1474  CB  MET B  80      23.136  25.895  11.842  1.00 17.89           C  
ATOM   1475  CG  MET B  80      22.819  24.566  12.513  1.00 17.27           C  
ATOM   1476  SD  MET B  80      23.399  24.407  14.228  1.00 19.73           S  
ATOM   1477  CE  MET B  80      22.465  25.661  15.037  1.00 16.71           C  
ATOM   1478  N   TRP B  81      25.312  25.607   9.578  1.00 18.00           N  
ATOM   1479  CA  TRP B  81      26.047  24.804   8.608  1.00 16.78           C  
ATOM   1480  C   TRP B  81      27.549  24.933   8.880  1.00 16.00           C  
ATOM   1481  O   TRP B  81      28.301  23.971   8.729  1.00 14.95           O  
ATOM   1482  CB  TRP B  81      25.756  25.274   7.178  1.00 17.13           C  
ATOM   1483  CG  TRP B  81      26.679  24.649   6.169  1.00 15.57           C  
ATOM   1484  CD1 TRP B  81      26.546  23.425   5.572  1.00 16.43           C  
ATOM   1485  CD2 TRP B  81      27.925  25.185   5.711  1.00 16.24           C  
ATOM   1486  NE1 TRP B  81      27.635  23.167   4.774  1.00 17.50           N  
ATOM   1487  CE2 TRP B  81      28.498  24.230   4.843  1.00 16.87           C  
ATOM   1488  CE3 TRP B  81      28.616  26.381   5.954  1.00 16.78           C  
ATOM   1489  CZ2 TRP B  81      29.731  24.433   4.214  1.00 17.15           C  
ATOM   1490  CZ3 TRP B  81      29.846  26.583   5.327  1.00 18.34           C  
ATOM   1491  CH2 TRP B  81      30.386  25.613   4.469  1.00 16.24           C  
ATOM   1492  N   GLY B  82      27.970  26.132   9.278  1.00 16.27           N  
ATOM   1493  CA  GLY B  82      29.371  26.375   9.575  1.00 14.74           C  
ATOM   1494  C   GLY B  82      29.816  25.541  10.762  1.00 14.64           C  
ATOM   1495  O   GLY B  82      30.906  24.978  10.758  1.00 15.74           O  
ATOM   1496  N   CYS B  83      28.971  25.461  11.783  1.00 14.51           N  
ATOM   1497  CA  CYS B  83      29.287  24.676  12.967  1.00 15.08           C  
ATOM   1498  C   CYS B  83      29.359  23.195  12.581  1.00 16.48           C  
ATOM   1499  O   CYS B  83      30.284  22.483  12.979  1.00 16.23           O  
ATOM   1500  CB  CYS B  83      28.226  24.906  14.045  1.00 16.08           C  
ATOM   1501  SG  CYS B  83      28.601  24.140  15.652  1.00 17.39           S  
ATOM   1502  N   HIS B  84      28.391  22.743  11.784  1.00 16.83           N  
ATOM   1503  CA  HIS B  84      28.350  21.356  11.328  1.00 17.64           C  
ATOM   1504  C   HIS B  84      29.564  20.989  10.475  1.00 17.18           C  
ATOM   1505  O   HIS B  84      30.145  19.917  10.638  1.00 16.81           O  
ATOM   1506  CB  HIS B  84      27.080  21.101  10.504  1.00 19.49           C  
ATOM   1507  CG  HIS B  84      25.814  21.118  11.306  1.00 20.04           C  
ATOM   1508  ND1 HIS B  84      24.567  21.157  10.721  1.00 21.33           N  
ATOM   1509  CD2 HIS B  84      25.601  21.073  12.642  1.00 20.36           C  
ATOM   1510  CE1 HIS B  84      23.638  21.134  11.662  1.00 21.42           C  
ATOM   1511  NE2 HIS B  84      24.241  21.083  12.837  1.00 21.53           N  
ATOM   1512  N   ILE B  85      29.938  21.879   9.560  1.00 15.41           N  
ATOM   1513  CA  ILE B  85      31.069  21.626   8.678  1.00 14.02           C  
ATOM   1514  C   ILE B  85      32.380  21.620   9.463  1.00 14.55           C  
ATOM   1515  O   ILE B  85      33.290  20.841   9.163  1.00 15.13           O  
ATOM   1516  CB  ILE B  85      31.125  22.676   7.528  1.00 17.17           C  
ATOM   1517  CG1 ILE B  85      31.849  22.077   6.324  1.00 17.45           C  
ATOM   1518  CG2 ILE B  85      31.819  23.953   7.993  1.00 17.01           C  
ATOM   1519  CD1 ILE B  85      31.123  20.889   5.720  1.00 20.63           C  
ATOM   1520  N   HIS B  86      32.479  22.481  10.471  1.00 13.89           N  
ATOM   1521  CA  HIS B  86      33.680  22.528  11.299  1.00 13.11           C  
ATOM   1522  C   HIS B  86      33.712  21.241  12.116  1.00 14.44           C  
ATOM   1523  O   HIS B  86      34.780  20.683  12.362  1.00 14.47           O  
ATOM   1524  CB  HIS B  86      33.654  23.763  12.207  1.00 13.63           C  
ATOM   1525  CG  HIS B  86      34.912  23.973  12.998  1.00 14.95           C  
ATOM   1526  ND1 HIS B  86      35.201  25.169  13.620  1.00 13.66           N  
ATOM   1527  CD2 HIS B  86      35.938  23.138  13.293  1.00 14.28           C  
ATOM   1528  CE1 HIS B  86      36.351  25.061  14.264  1.00 15.58           C  
ATOM   1529  NE2 HIS B  86      36.818  23.838  14.081  1.00 14.89           N  
ATOM   1530  N   ASN B  87      32.545  20.749  12.526  1.00 16.10           N  
ATOM   1531  CA  ASN B  87      32.522  19.501  13.286  1.00 17.43           C  
ATOM   1532  C   ASN B  87      32.918  18.303  12.422  1.00 18.11           C  
ATOM   1533  O   ASN B  87      33.393  17.289  12.938  1.00 19.16           O  
ATOM   1534  CB  ASN B  87      31.159  19.268  13.941  1.00 15.49           C  
ATOM   1535  CG  ASN B  87      31.036  19.981  15.277  1.00 17.84           C  
ATOM   1536  OD1 ASN B  87      32.036  20.191  15.973  1.00 17.23           O  
ATOM   1537  ND2 ASN B  87      29.812  20.340  15.654  1.00 14.93           N  
ATOM   1538  N   LYS B  88      32.740  18.420  11.109  1.00 19.04           N  
ATOM   1539  CA  LYS B  88      33.136  17.342  10.205  1.00 19.81           C  
ATOM   1540  C   LYS B  88      34.661  17.282  10.217  1.00 18.15           C  
ATOM   1541  O   LYS B  88      35.245  16.203  10.187  1.00 16.22           O  
ATOM   1542  CB  LYS B  88      32.642  17.604   8.777  1.00 21.48           C  
ATOM   1543  CG  LYS B  88      31.138  17.478   8.595  1.00 27.13           C  
ATOM   1544  CD  LYS B  88      30.655  16.057   8.875  1.00 28.92           C  
ATOM   1545  CE  LYS B  88      29.177  15.910   8.539  1.00 32.35           C  
ATOM   1546  NZ  LYS B  88      28.679  14.525   8.760  1.00 35.36           N  
ATOM   1547  N   VAL B  89      35.301  18.451  10.253  1.00 16.61           N  
ATOM   1548  CA  VAL B  89      36.759  18.511  10.298  1.00 17.77           C  
ATOM   1549  C   VAL B  89      37.221  17.949  11.644  1.00 16.68           C  
ATOM   1550  O   VAL B  89      38.166  17.165  11.706  1.00 17.69           O  
ATOM   1551  CB  VAL B  89      37.280  19.973  10.132  1.00 16.75           C  
ATOM   1552  CG1 VAL B  89      38.789  20.020  10.329  1.00 15.87           C  
ATOM   1553  CG2 VAL B  89      36.933  20.488   8.745  1.00 17.83           C  
ATOM   1554  N   ASN B  90      36.551  18.348  12.720  1.00 17.50           N  
ATOM   1555  CA  ASN B  90      36.893  17.860  14.054  1.00 18.96           C  
ATOM   1556  C   ASN B  90      36.826  16.338  14.066  1.00 22.02           C  
ATOM   1557  O   ASN B  90      37.738  15.660  14.533  1.00 22.29           O  
ATOM   1558  CB  ASN B  90      35.913  18.400  15.101  1.00 17.68           C  
ATOM   1559  CG  ASN B  90      36.113  19.865  15.382  1.00 15.49           C  
ATOM   1560  OD1 ASN B  90      37.194  20.408  15.153  1.00 16.70           O  
ATOM   1561  ND2 ASN B  90      35.073  20.519  15.906  1.00 13.87           N  
ATOM   1562  N   GLU B  91      35.722  15.813  13.554  1.00 24.14           N  
ATOM   1563  CA  GLU B  91      35.508  14.379  13.489  1.00 28.13           C  
ATOM   1564  C   GLU B  91      36.696  13.750  12.776  1.00 28.62           C  
ATOM   1565  O   GLU B  91      37.299  12.790  13.263  1.00 27.82           O  
ATOM   1566  CB  GLU B  91      34.221  14.100  12.716  1.00 31.42           C  
ATOM   1567  CG  GLU B  91      33.711  12.685  12.807  1.00 36.75           C  
ATOM   1568  CD  GLU B  91      32.399  12.516  12.063  1.00 39.93           C  
ATOM   1569  OE1 GLU B  91      31.513  13.388  12.223  1.00 40.89           O  
ATOM   1570  OE2 GLU B  91      32.254  11.516  11.327  1.00 42.00           O  
ATOM   1571  N   TYR B  92      37.037  14.319  11.625  1.00 28.52           N  
ATOM   1572  CA  TYR B  92      38.148  13.834  10.819  1.00 29.75           C  
ATOM   1573  C   TYR B  92      39.480  13.838  11.573  1.00 27.90           C  
ATOM   1574  O   TYR B  92      40.271  12.904  11.454  1.00 25.11           O  
ATOM   1575  CB  TYR B  92      38.285  14.681   9.548  1.00 33.87           C  
ATOM   1576  CG  TYR B  92      39.321  14.138   8.604  1.00 38.12           C  
ATOM   1577  CD1 TYR B  92      39.172  12.868   8.044  1.00 40.82           C  
ATOM   1578  CD2 TYR B  92      40.477  14.861   8.307  1.00 40.40           C  
ATOM   1579  CE1 TYR B  92      40.150  12.322   7.216  1.00 42.68           C  
ATOM   1580  CE2 TYR B  92      41.465  14.324   7.477  1.00 42.48           C  
ATOM   1581  CZ  TYR B  92      41.292  13.051   6.936  1.00 43.14           C  
ATOM   1582  OH  TYR B  92      42.257  12.493   6.126  1.00 44.64           O  
ATOM   1583  N   LEU B  93      39.726  14.890  12.345  1.00 26.06           N  
ATOM   1584  CA  LEU B  93      40.970  15.007  13.100  1.00 24.83           C  
ATOM   1585  C   LEU B  93      40.883  14.372  14.484  1.00 24.70           C  
ATOM   1586  O   LEU B  93      41.791  14.531  15.298  1.00 24.87           O  
ATOM   1587  CB  LEU B  93      41.360  16.483  13.240  1.00 24.02           C  
ATOM   1588  CG  LEU B  93      41.505  17.265  11.930  1.00 20.23           C  
ATOM   1589  CD1 LEU B  93      41.890  18.696  12.233  1.00 19.88           C  
ATOM   1590  CD2 LEU B  93      42.559  16.608  11.052  1.00 20.33           C  
ATOM   1591  N   LYS B  94      39.789  13.664  14.750  1.00 25.72           N  
ATOM   1592  CA  LYS B  94      39.582  13.008  16.041  1.00 26.36           C  
ATOM   1593  C   LYS B  94      39.535  14.006  17.200  1.00 26.90           C  
ATOM   1594  O   LYS B  94      39.994  13.714  18.306  1.00 26.18           O  
ATOM   1595  CB  LYS B  94      40.690  11.980  16.295  1.00 29.55           C  
ATOM   1596  CG  LYS B  94      40.827  10.926  15.201  1.00 33.12           C  
ATOM   1597  CD  LYS B  94      39.522  10.176  14.992  1.00 36.83           C  
ATOM   1598  CE  LYS B  94      39.647   9.147  13.886  1.00 39.50           C  
ATOM   1599  NZ  LYS B  94      40.626   8.088  14.245  1.00 42.22           N  
ATOM   1600  N   LYS B  95      38.982  15.186  16.941  1.00 25.08           N  
ATOM   1601  CA  LYS B  95      38.873  16.217  17.964  1.00 24.38           C  
ATOM   1602  C   LYS B  95      37.448  16.191  18.498  1.00 24.11           C  
ATOM   1603  O   LYS B  95      36.575  15.574  17.895  1.00 24.09           O  
ATOM   1604  CB  LYS B  95      39.199  17.588  17.362  1.00 26.13           C  
ATOM   1605  CG  LYS B  95      40.563  17.638  16.680  1.00 27.17           C  
ATOM   1606  CD  LYS B  95      40.775  18.923  15.896  1.00 28.66           C  
ATOM   1607  CE  LYS B  95      40.954  20.117  16.813  1.00 31.39           C  
ATOM   1608  NZ  LYS B  95      42.189  20.001  17.637  1.00 32.10           N  
ATOM   1609  N   ASP B  96      37.206  16.851  19.625  1.00 22.61           N  
ATOM   1610  CA  ASP B  96      35.866  16.861  20.206  1.00 24.06           C  
ATOM   1611  C   ASP B  96      34.845  17.585  19.339  1.00 23.09           C  
ATOM   1612  O   ASP B  96      35.181  18.521  18.612  1.00 22.63           O  
ATOM   1613  CB  ASP B  96      35.877  17.510  21.592  1.00 24.97           C  
ATOM   1614  CG  ASP B  96      36.683  16.721  22.603  1.00 26.52           C  
ATOM   1615  OD1 ASP B  96      36.782  15.484  22.457  1.00 27.03           O  
ATOM   1616  OD2 ASP B  96      37.202  17.339  23.555  1.00 27.90           O  
ATOM   1617  N   ILE B  97      33.594  17.141  19.417  1.00 24.41           N  
ATOM   1618  CA  ILE B  97      32.510  17.762  18.666  1.00 23.73           C  
ATOM   1619  C   ILE B  97      31.998  18.946  19.486  1.00 23.12           C  
ATOM   1620  O   ILE B  97      31.718  18.819  20.675  1.00 23.43           O  
ATOM   1621  CB  ILE B  97      31.363  16.754  18.390  1.00 26.29           C  
ATOM   1622  CG1 ILE B  97      31.695  15.901  17.157  1.00 28.23           C  
ATOM   1623  CG2 ILE B  97      30.056  17.493  18.142  1.00 26.35           C  
ATOM   1624  CD1 ILE B  97      33.046  15.232  17.195  1.00 29.51           C  
ATOM   1625  N   TYR B  98      31.895  20.098  18.831  1.00 20.62           N  
ATOM   1626  CA  TYR B  98      31.456  21.345  19.448  1.00 18.96           C  
ATOM   1627  C   TYR B  98      29.931  21.478  19.498  1.00 18.10           C  
ATOM   1628  O   TYR B  98      29.251  21.219  18.507  1.00 19.26           O  
ATOM   1629  CB  TYR B  98      32.038  22.494  18.631  1.00 18.30           C  
ATOM   1630  CG  TYR B  98      31.872  23.889  19.190  1.00 17.22           C  
ATOM   1631  CD1 TYR B  98      32.784  24.401  20.115  1.00 17.99           C  
ATOM   1632  CD2 TYR B  98      30.871  24.736  18.709  1.00 16.66           C  
ATOM   1633  CE1 TYR B  98      32.713  25.728  20.536  1.00 18.97           C  
ATOM   1634  CE2 TYR B  98      30.788  26.064  19.124  1.00 16.47           C  
ATOM   1635  CZ  TYR B  98      31.715  26.556  20.035  1.00 19.43           C  
ATOM   1636  OH  TYR B  98      31.662  27.878  20.429  1.00 18.08           O  
ATOM   1637  N   ASP B  99      29.405  21.895  20.648  1.00 18.20           N  
ATOM   1638  CA  ASP B  99      27.961  22.082  20.824  1.00 19.29           C  
ATOM   1639  C   ASP B  99      27.546  23.308  20.007  1.00 18.13           C  
ATOM   1640  O   ASP B  99      28.007  24.414  20.281  1.00 18.46           O  
ATOM   1641  CB  ASP B  99      27.643  22.328  22.300  1.00 21.04           C  
ATOM   1642  CG  ASP B  99      26.150  22.299  22.596  1.00 22.07           C  
ATOM   1643  OD1 ASP B  99      25.341  22.566  21.685  1.00 23.38           O  
ATOM   1644  OD2 ASP B  99      25.784  22.020  23.754  1.00 25.78           O  
ATOM   1645  N   CYS B 100      26.680  23.112  19.011  1.00 17.18           N  
ATOM   1646  CA  CYS B 100      26.228  24.206  18.141  1.00 16.76           C  
ATOM   1647  C   CYS B 100      25.044  25.014  18.663  1.00 16.17           C  
ATOM   1648  O   CYS B 100      24.532  25.882  17.952  1.00 16.45           O  
ATOM   1649  CB  CYS B 100      25.841  23.659  16.758  1.00 16.96           C  
ATOM   1650  SG  CYS B 100      27.145  22.744  15.879  1.00 16.35           S  
ATOM   1651  N   ALA B 101      24.629  24.753  19.901  1.00 16.71           N  
ATOM   1652  CA  ALA B 101      23.459  25.419  20.488  1.00 17.98           C  
ATOM   1653  C   ALA B 101      23.492  26.944  20.613  1.00 18.68           C  
ATOM   1654  O   ALA B 101      22.442  27.580  20.684  1.00 19.74           O  
ATOM   1655  CB  ALA B 101      23.144  24.793  21.856  1.00 18.88           C  
ATOM   1656  N   THR B 102      24.682  27.532  20.652  1.00 18.42           N  
ATOM   1657  CA  THR B 102      24.801  28.985  20.765  1.00 17.92           C  
ATOM   1658  C   THR B 102      25.748  29.490  19.679  1.00 16.91           C  
ATOM   1659  O   THR B 102      26.499  30.428  19.898  1.00 16.98           O  
ATOM   1660  CB  THR B 102      25.383  29.388  22.134  1.00 18.59           C  
ATOM   1661  OG1 THR B 102      26.651  28.745  22.313  1.00 20.10           O  
ATOM   1662  CG2 THR B 102      24.449  28.974  23.264  1.00 19.35           C  
ATOM   1663  N   ILE B 103      25.691  28.872  18.503  1.00 16.56           N  
ATOM   1664  CA  ILE B 103      26.584  29.227  17.405  1.00 17.66           C  
ATOM   1665  C   ILE B 103      26.625  30.711  17.021  1.00 18.78           C  
ATOM   1666  O   ILE B 103      27.686  31.227  16.677  1.00 18.23           O  
ATOM   1667  CB  ILE B 103      26.278  28.357  16.152  1.00 16.02           C  
ATOM   1668  CG1 ILE B 103      27.366  28.560  15.087  1.00 13.92           C  
ATOM   1669  CG2 ILE B 103      24.892  28.695  15.603  1.00 15.56           C  
ATOM   1670  CD1 ILE B 103      28.774  28.197  15.539  1.00 12.03           C  
ATOM   1671  N   LEU B 104      25.493  31.407  17.079  1.00 20.17           N  
ATOM   1672  CA  LEU B 104      25.499  32.830  16.737  1.00 20.60           C  
ATOM   1673  C   LEU B 104      26.118  33.653  17.873  1.00 20.73           C  
ATOM   1674  O   LEU B 104      26.989  34.498  17.638  1.00 19.93           O  
ATOM   1675  CB  LEU B 104      24.078  33.330  16.445  1.00 20.16           C  
ATOM   1676  CG  LEU B 104      23.334  32.717  15.251  1.00 18.62           C  
ATOM   1677  CD1 LEU B 104      21.916  33.266  15.223  1.00 20.12           C  
ATOM   1678  CD2 LEU B 104      24.044  33.034  13.947  1.00 17.45           C  
ATOM   1679  N   GLU B 105      25.670  33.401  19.101  1.00 20.03           N  
ATOM   1680  CA  GLU B 105      26.178  34.124  20.268  1.00 20.42           C  
ATOM   1681  C   GLU B 105      27.676  33.916  20.471  1.00 20.17           C  
ATOM   1682  O   GLU B 105      28.366  34.807  20.966  1.00 20.54           O  
ATOM   1683  CB  GLU B 105      25.445  33.690  21.544  1.00 22.21           C  
ATOM   1684  CG  GLU B 105      23.941  33.891  21.511  1.00 24.58           C  
ATOM   1685  CD  GLU B 105      23.196  32.668  21.006  1.00 26.02           C  
ATOM   1686  OE1 GLU B 105      23.645  32.060  20.011  1.00 22.17           O  
ATOM   1687  OE2 GLU B 105      22.152  32.322  21.599  1.00 26.73           O  
ATOM   1688  N   ASP B 106      28.173  32.738  20.103  1.00 18.81           N  
ATOM   1689  CA  ASP B 106      29.599  32.435  20.249  1.00 19.54           C  
ATOM   1690  C   ASP B 106      30.481  33.298  19.347  1.00 20.96           C  
ATOM   1691  O   ASP B 106      31.667  33.495  19.634  1.00 20.78           O  
ATOM   1692  CB  ASP B 106      29.890  30.963  19.919  1.00 17.36           C  
ATOM   1693  CG  ASP B 106      29.252  29.999  20.900  1.00 17.62           C  
ATOM   1694  OD1 ASP B 106      28.786  30.445  21.965  1.00 18.87           O  
ATOM   1695  OD2 ASP B 106      29.232  28.790  20.606  1.00 18.93           O  
ATOM   1696  N   TYR B 107      29.907  33.802  18.259  1.00 21.04           N  
ATOM   1697  CA  TYR B 107      30.670  34.606  17.321  1.00 21.45           C  
ATOM   1698  C   TYR B 107      30.074  35.967  16.963  1.00 22.38           C  
ATOM   1699  O   TYR B 107      29.853  36.276  15.790  1.00 20.90           O  
ATOM   1700  CB  TYR B 107      30.933  33.791  16.046  1.00 19.36           C  
ATOM   1701  CG  TYR B 107      31.789  32.567  16.296  1.00 17.97           C  
ATOM   1702  CD1 TYR B 107      31.213  31.323  16.582  1.00 15.51           C  
ATOM   1703  CD2 TYR B 107      33.178  32.661  16.279  1.00 17.52           C  
ATOM   1704  CE1 TYR B 107      32.014  30.202  16.844  1.00 12.92           C  
ATOM   1705  CE2 TYR B 107      33.981  31.560  16.536  1.00 15.64           C  
ATOM   1706  CZ  TYR B 107      33.401  30.334  16.816  1.00 17.62           C  
ATOM   1707  OH  TYR B 107      34.220  29.250  17.054  1.00 15.81           O  
ATOM   1708  N   ASP B 108      29.833  36.792  17.975  1.00 23.96           N  
ATOM   1709  CA  ASP B 108      29.289  38.117  17.723  1.00 25.41           C  
ATOM   1710  C   ASP B 108      30.359  38.934  17.006  1.00 25.52           C  
ATOM   1711  O   ASP B 108      31.548  38.835  17.319  1.00 22.92           O  
ATOM   1712  CB  ASP B 108      28.883  38.790  19.032  1.00 28.93           C  
ATOM   1713  CG  ASP B 108      28.247  40.148  18.810  1.00 32.32           C  
ATOM   1714  OD1 ASP B 108      28.977  41.164  18.831  1.00 31.57           O  
ATOM   1715  OD2 ASP B 108      27.016  40.192  18.599  1.00 34.17           O  
ATOM   1716  N   CYS B 109      29.931  39.726  16.032  1.00 24.57           N  
ATOM   1717  CA  CYS B 109      30.841  40.546  15.241  1.00 27.38           C  
ATOM   1718  C   CYS B 109      31.486  41.673  16.044  1.00 27.52           C  
ATOM   1719  O   CYS B 109      32.466  42.270  15.602  1.00 27.08           O  
ATOM   1720  CB  CYS B 109      30.081  41.152  14.062  1.00 28.41           C  
ATOM   1721  SG  CYS B 109      28.875  42.397  14.613  1.00 32.67           S  
ATOM   1722  N   GLY B 110      30.940  41.964  17.222  1.00 28.51           N  
ATOM   1723  CA  GLY B 110      31.474  43.050  18.024  1.00 29.21           C  
ATOM   1724  C   GLY B 110      31.367  44.328  17.206  1.00 31.50           C  
ATOM   1725  O   GLY B 110      32.078  45.306  17.449  1.00 30.73           O  
ATOM   1726  N   CYS B 111      30.460  44.315  16.233  1.00 31.31           N  
ATOM   1727  CA  CYS B 111      30.264  45.451  15.342  1.00 33.30           C  
ATOM   1728  C   CYS B 111      28.941  46.176  15.566  1.00 34.27           C  
ATOM   1729  O   CYS B 111      28.182  45.840  16.474  1.00 33.77           O  
ATOM   1730  CB  CYS B 111      30.372  44.985  13.884  1.00 32.93           C  
ATOM   1731  SG  CYS B 111      29.040  43.902  13.252  1.00 31.75           S  
ATOM   1732  N   SER B 112      28.672  47.178  14.733  1.00 36.07           N  
ATOM   1733  CA  SER B 112      27.447  47.957  14.852  1.00 38.38           C  
ATOM   1734  C   SER B 112      26.227  47.184  14.362  1.00 39.57           C  
ATOM   1735  O   SER B 112      26.402  46.128  13.721  1.00 40.12           O  
ATOM   1736  CB  SER B 112      27.580  49.271  14.071  1.00 38.43           C  
ATOM   1737  OG  SER B 112      27.860  49.038  12.699  1.00 38.54           O  
TER    1738      SER B 112                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
