
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  204 ( 1661),  selected  204 , name 1zun_A
# Molecule2: number of CA atoms  287 ( 2373),  selected  287 , name T0395.pdb
# PARAMETERS: 1zun_A.T0395.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    -6_A      M       1           -
LGA    V    -5_A      R       2           -
LGA    P    -4_A      L       3           -
LGA    R    -3_A      G       4           -
LGA    G    -2_A      D       5           -
LGA    S    -1_A      A       6           -
LGA    H     0_A      A       7           -
LGA    X     1_A      E       8           -
LGA    V     2_A      L       9           -
LGA    -       -      C      10           -
LGA    -       -      Y      11           -
LGA    -       -      N      12           -
LGA    -       -      L      13           -
LGA    -       -      T      14           -
LGA    -       -      S      15           -
LGA    -       -      S      16           -
LGA    -       -      Y      17           -
LGA    -       -      L      18           -
LGA    D     3_A      Q      19          6.091
LGA    -       -      I      20           -
LGA    -       -      A      21           -
LGA    K     4_A      A      22           #
LGA    L     5_A      E      23           -
LGA    T     6_A      -       -           -
LGA    H     7_A      S      24           #
LGA    -       -      D      25           -
LGA    -       -      S      26           -
LGA    -       -      I      27           -
LGA    -       -      I      28           -
LGA    -       -      A      29           -
LGA    -       -      Q      30           -
LGA    L     8_A      T      31          1.494
LGA    K     9_A      Q      32          1.929
LGA    Q    10_A      R      33          2.199
LGA    L    11_A      A      34          1.381
LGA    E    12_A      I      35          1.274
LGA    A    13_A      N      36          2.360
LGA    E    14_A      T      37          1.802
LGA    S    15_A      T      38          1.041
LGA    I    16_A      K      39          2.223
LGA    H    17_A      S      40          2.485
LGA    I    18_A      I      41          1.798
LGA    I    19_A      L      42          2.375
LGA    R    20_A      I      43          3.001
LGA    -       -      N      44           -
LGA    E    21_A      E      45          3.254
LGA    V    22_A      T      46          2.124
LGA    A    23_A      F      47          2.755
LGA    A    24_A      P      48          2.435
LGA    E    25_A      K      49          0.918
LGA    F    26_A      W      50          1.764
LGA    D    27_A      S      51          4.513
LGA    -       -      P      52           -
LGA    -       -      L      53           -
LGA    -       -      N      54           -
LGA    -       -      G      55           -
LGA    N    28_A      E      56          0.842
LGA    P    29_A      I      57          0.800
LGA    V    30_A      S      58          0.815
LGA    X    31_A      F      59          0.741
LGA    L    32_A      S      60          0.296
LGA    Y    33_A      Y      61          0.280
LGA    S    34_A      N      62          0.583
LGA    I    35_A      G      63          1.618
LGA    G    36_A      G      64          1.056
LGA    K    37_A      K      65          1.135
LGA    D    38_A      D      66          0.567
LGA    S    39_A      C      67          0.442
LGA    A    40_A      Q      68          0.522
LGA    V    41_A      V      69          0.551
LGA    X    42_A      L      70          0.658
LGA    L    43_A      L      71          0.554
LGA    H    44_A      L      72          0.607
LGA    L    45_A      L      73          0.566
LGA    A    46_A      Y      74          0.986
LGA    R    47_A      L      75          1.192
LGA    K    48_A      S      76          0.763
LGA    A    49_A      C      77          0.621
LGA    F    50_A      L      78          1.522
LGA    F    51_A      W      79          1.998
LGA    -       -      E      80           -
LGA    -       -      Y      81           -
LGA    -       -      Y      82           -
LGA    P    52_A      I      83           #
LGA    G    53_A      V      84           -
LGA    K    54_A      K     102           #
LGA    L    55_A      -       -           -
LGA    P    56_A      -       -           -
LGA    F    57_A      L     103          4.973
LGA    P    58_A      P     104          1.045
LGA    V    59_A      T     105          1.314
LGA    X    60_A      V     106          1.136
LGA    H    61_A      F     107          0.876
LGA    V    62_A      I     108          1.431
LGA    D    63_A      D     109          1.725
LGA    T    64_A      H     110          2.042
LGA    R    65_A      D     111          2.593
LGA    W    66_A      D     112          4.474
LGA    K    67_A      T     113          1.445
LGA    F    68_A      F     114          1.180
LGA    Q    69_A      K     115          1.145
LGA    E    70_A      T     116          1.029
LGA    X    71_A      L     117          1.448
LGA    Y    72_A      E     118          1.782
LGA    R    73_A      N     119          1.610
LGA    F    74_A      F     120          1.541
LGA    R    75_A      I     121          1.735
LGA    D    76_A      E     122          1.478
LGA    Q    77_A      E     123          1.796
LGA    X    78_A      T     124          1.527
LGA    V    79_A      S     125          1.919
LGA    E    80_A      L     126          1.987
LGA    E    81_A      R     127          2.223
LGA    X    82_A      Y     128          2.355
LGA    G    83_A      S     129          2.191
LGA    L    84_A      L     130          2.106
LGA    D    85_A      S     131          1.655
LGA    L    86_A      L     132          1.529
LGA    I    87_A      Y     133          1.666
LGA    T    88_A      E     134          1.769
LGA    H    89_A      S     135          2.132
LGA    I    90_A      D     136          1.733
LGA    -       -      R     137           -
LGA    -       -      D     138           -
LGA    N    91_A      K     139          4.646
LGA    S   106_A      -       -           -
LGA    A   107_A      -       -           -
LGA    K   108_A      -       -           -
LGA    H   109_A      C     140          5.512
LGA    T   110_A      -       -           -
LGA    D   111_A      -       -           -
LGA    I   112_A      E     141          1.469
LGA    X   113_A      T     142          4.402
LGA    K   114_A      M     143          2.762
LGA    T   115_A      A     144          3.107
LGA    E   116_A      E     145          1.379
LGA    G   117_A      A     146          0.709
LGA    L   118_A      F     147          2.107
LGA    K   119_A      E     148          2.922
LGA    Q   120_A      T     149          2.132
LGA    A   121_A      F     150          1.034
LGA    L   122_A      L     151          2.623
LGA    D   123_A      Q     152          3.624
LGA    K   124_A      V     153          2.587
LGA    H   125_A      F     154          0.579
LGA    G   126_A      P     155          1.827
LGA    -       -      E     156           -
LGA    F   127_A      T     157          1.209
LGA    D   128_A      K     158          0.988
LGA    A   129_A      A     159          0.368
LGA    A   130_A      I     160          0.754
LGA    F   131_A      V     161          0.705
LGA    G   132_A      I     162          0.655
LGA    G   133_A      G     163          0.657
LGA    A   134_A      I     164          0.754
LGA    R   135_A      R     165          0.578
LGA    R   136_A      H     166          0.800
LGA    D   137_A      T     167          1.865
LGA    E   138_A      D     168          2.032
LGA    E   139_A      P     169          3.727
LGA    K   140_A      -       -           -
LGA    S   141_A      F     170           #
LGA    R   142_A      G     171          3.093
LGA    A   143_A      E     172          3.386
LGA    K   144_A      H     173          3.886
LGA    E   145_A      L     174          2.248
LGA    R   146_A      K     175          1.283
LGA    V   147_A      P     176          1.114
LGA    Y   148_A      I     177          1.346
LGA    S   149_A      Q     178          1.453
LGA    F   150_A      K     179          1.367
LGA    R   151_A      T     180          3.308
LGA    D   152_A      -       -           -
LGA    S   153_A      -       -           -
LGA    K   154_A      -       -           -
LGA    H   155_A      D     181           #
LGA    R   156_A      A     182          0.708
LGA    W   157_A      N     183           -
LGA    D   158_A      W     184           -
LGA    P   159_A      -       -           -
LGA    K   160_A      -       -           -
LGA    N   161_A      -       -           -
LGA    Q   162_A      -       -           -
LGA    R   163_A      -       -           -
LGA    P   164_A      -       -           -
LGA    E   165_A      -       -           -
LGA    L   166_A      -       -           -
LGA    W   167_A      -       -           -
LGA    N   168_A      -       -           -
LGA    V   169_A      -       -           -
LGA    Y   170_A      -       -           -
LGA    N   171_A      -       -           -
LGA    G   172_A      -       -           -
LGA    N   173_A      -       -           -
LGA    V   174_A      -       -           -
LGA    N   175_A      -       -           -
LGA    K   176_A      -       -           -
LGA    G   177_A      -       -           -
LGA    E   178_A      P     185           #
LGA    S   179_A      D     186          4.011
LGA    -       -      F     187           -
LGA    I   180_A      Y     188          0.796
LGA    R   181_A      R     189          0.779
LGA    V   182_A      L     190          1.299
LGA    F   183_A      Q     191          0.827
LGA    P   184_A      P     192          0.688
LGA    L   185_A      L     193          0.441
LGA    S   186_A      L     194          0.422
LGA    N   187_A      H     195          0.510
LGA    W   188_A      W     196          0.381
LGA    T   189_A      N     197          0.920
LGA    E   190_A      L     198          1.397
LGA    L   191_A      A     199          1.537
LGA    D   192_A      N     200          1.290
LGA    I   193_A      I     201          0.777
LGA    W   194_A      W     202          1.197
LGA    Q   195_A      S     203          1.652
LGA    Y   196_A      F     204          1.495
LGA    I   197_A      L     205          1.173
LGA    Y   198_A      L     206          1.486
LGA    L   199_A      Y     207          1.778
LGA    E   200_A      S     208          1.733
LGA    G   201_A      N     209          2.127
LGA    I   202_A      E     210          3.260
LGA    P   203_A      P     211          2.007
LGA    I   204_A      I     212          1.459
LGA    V   205_A      C     213          1.184
LGA    P   206_A      E     214          1.497
LGA    L   207_A      L     215          1.128
LGA    Y   208_A      Y     216          2.070
LGA    -       -      R     217           -
LGA    -       -      Y     218           -
LGA    -       -      G     219           -
LGA    F   209_A      F     220          1.953
LGA    -       -      T     221           -
LGA    A   210_A      S     222          0.701
LGA    A   211_A      L     223          0.982
LGA    -       -      G     224           -
LGA    -       -      N     225           -
LGA    -       -      V     226           -
LGA    -       -      E     227           -
LGA    -       -      E     228           -
LGA    -       -      T     229           -
LGA    -       -      L     230           -
LGA    -       -      P     231           -
LGA    -       -      N     232           -
LGA    -       -      P     233           -
LGA    -       -      H     234           -
LGA    -       -      L     235           -
LGA    -       -      R     236           -
LGA    -       -      K     237           -
LGA    -       -      D     238           -
LGA    -       -      K     239           -
LGA    -       -      N     240           -
LGA    -       -      S     241           -
LGA    -       -      T     242           -
LGA    -       -      P     243           -
LGA    -       -      L     244           -
LGA    -       -      K     245           -
LGA    -       -      L     246           -
LGA    -       -      N     247           -
LGA    -       -      F     248           -
LGA    -       -      E     249           -
LGA    -       -      W     250           -
LGA    -       -      E     251           -
LGA    -       -      I     252           -
LGA    -       -      E     253           -
LGA    -       -      N     254           -
LGA    -       -      R     255           -
LGA    -       -      Y     256           -
LGA    -       -      K     257           -
LGA    -       -      H     258           -
LGA    -       -      N     259           -
LGA    -       -      E     260           -
LGA    -       -      V     261           -
LGA    -       -      T     262           -
LGA    -       -      K     263           -
LGA    -       -      A     264           -
LGA    -       -      E     265           -
LGA    -       -      P     266           -
LGA    -       -      I     267           -
LGA    -       -      P     268           -
LGA    -       -      I     269           -
LGA    -       -      A     270           -
LGA    -       -      D     271           -
LGA    -       -      E     272           -
LGA    -       -      D     273           -
LGA    -       -      L     274           -
LGA    -       -      V     275           -
LGA    -       -      K     276           -
LGA    -       -      I     277           -
LGA    -       -      E     278           -
LGA    -       -      N     279           -
LGA    -       -      L     280           -
LGA    -       -      H     281           -
LGA    -       -      E     282           -
LGA    -       -      D     283           -
LGA    -       -      Y     284           -
LGA    -       -      Y     285           -
LGA    -       -      P     286           -
LGA    -       -      G     287           -
LGA    -       -      W     288           -
LGA    -       -      Y     289           -
LGA    -       -      L     290           -
LGA    -       -      V     291           -
LGA    -       -      D     292           -
LGA    -       -      D     293           -
LGA    -       -      K     294           -
LGA    -       -      L     295           -
LGA    -       -      E     296           -
LGA    -       -      R     297           -
LGA    -       -      A     298           -
LGA    -       -      G     299           -
LGA    -       -      R     300           -
LGA    -       -      I     301           -
LGA    -       -      K     302           -
LGA    -       -      K     303           -
LGA    -       -      K     304           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  204  287    5.0    153    2.00    20.26     41.271     7.279

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.676569 * X  +  -0.242577 * Y  +  -0.695277 * Z  + 136.804794
  Y_new =  -0.441002 * X  +  -0.622665 * Y  +   0.646379 * Z  +  23.420021
  Z_new =  -0.589721 * X  +   0.743939 * Y  +   0.314299 * Z  + -44.828808 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.171063   -1.970530  [ DEG:    67.0969   -112.9031 ]
  Theta =   0.630713    2.510879  [ DEG:    36.1372    143.8628 ]
  Phi   =  -2.563938    0.577654  [ DEG:  -146.9028     33.0972 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1zun_A                                        
REMARK     2: T0395.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1zun_A.T0395.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  204  287   5.0  153   2.00   20.26  41.271
REMARK  ---------------------------------------------------------- 
MOLECULE 1zun_A
HEADER    TRANSFERASE                             31-MAY-05   1ZUN              
TITLE     CRYSTAL STRUCTURE OF A GTP-REGULATED ATP SULFURYLASE                  
TITLE    2 HETERODIMER FROM PSEUDOMONAS SYRINGAE                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SULFATE ADENYLYLTRANSFERASE SUBUNIT 2;                     
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: SULFATE ADENYLATE TRANSFERASE, SAT, ATP-                    
COMPND   5 SULFURYLASE SMALL SUBUNIT, ATP SULFURYLASE CATALYTIC                 
COMPND   6 SUBUNIT (CYSD);                                                      
COMPND   7 EC: 2.7.7.4;                                                         
COMPND   8 ENGINEERED: YES;                                                     
COMPND   9 MOL_ID: 2;                                                           
COMPND  10 MOLECULE: SULFATE ADENYLATE TRANSFERASE, SUBUNIT                     
COMPND  11 1/ADENYLYLSULFATE KINASE;                                            
COMPND  12 CHAIN: B;                                                            
COMPND  13 SYNONYM: GTPASE DOMAIN OF ATP SULFURYLASE REGULATORY                 
COMPND  14 SUBUNIT (CYSN);                                                      
COMPND  15 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS SYRINGAE;                           
SOURCE   3 ORGANISM_COMMON: PV. TOMATO;                                         
SOURCE   4 GENE: CYSD;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28B;                                   
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: PSEUDOMONAS SYRINGAE PV. TOMATO STR.            
SOURCE  12 DC3000;                                                              
SOURCE  13 GENE: CYSNC;                                                         
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PET21A                                    
KEYWDS    BETA BARREL, SWITCH DOMAIN, HETERODIMER, PYROPHOSPHATE, G             
KEYWDS   2 PROTEIN, GTPASE                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.D.MOUGOUS,D.H.LEE,S.C.HUBBARD,M.W.SCHELLE,D.J.VOCADLO,              
AUTHOR   2 J.M.BERGER,C.R.BERTOZZI                                              
REVDAT   1   17-JAN-06 1ZUN    0                                                
JRNL        AUTH   J.D.MOUGOUS,D.H.LEE,S.C.HUBBARD,M.W.SCHELLE,                 
JRNL        AUTH 2 D.J.VOCADLO,J.M.BERGER,C.R.BERTOZZI                          
JRNL        TITL   MOLECULAR BASIS FOR G PROTEIN CONTROL OF THE                 
JRNL        TITL 2 PROKARYOTIC ATP SULFURYLASE.                                 
JRNL        REF    MOL.CELL                      V.  21   109 2006              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1ZUN A  -19   305  UNP    Q87WW0   CYSD_PSESM       1    305             
DBREF  1ZUN B    1   434  GB     28871567 NP_794186        1    434             
SEQRES   1 A  325  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  325  LEU VAL PRO ARG GLY SER HIS MSE VAL ASP LYS LEU THR          
SEQRES   3 A  325  HIS LEU LYS GLN LEU GLU ALA GLU SER ILE HIS ILE ILE          
SEQRES   4 A  325  ARG GLU VAL ALA ALA GLU PHE ASP ASN PRO VAL MSE LEU          
SEQRES   5 A  325  TYR SER ILE GLY LYS ASP SER ALA VAL MSE LEU HIS LEU          
SEQRES   6 A  325  ALA ARG LYS ALA PHE PHE PRO GLY LYS LEU PRO PHE PRO          
SEQRES   7 A  325  VAL MSE HIS VAL ASP THR ARG TRP LYS PHE GLN GLU MSE          
SEQRES   8 A  325  TYR ARG PHE ARG ASP GLN MSE VAL GLU GLU MSE GLY LEU          
SEQRES   9 A  325  ASP LEU ILE THR HIS ILE ASN PRO ASP GLY VAL ALA GLN          
SEQRES  10 A  325  GLY ILE ASN PRO PHE THR HIS GLY SER ALA LYS HIS THR          
SEQRES  11 A  325  ASP ILE MSE LYS THR GLU GLY LEU LYS GLN ALA LEU ASP          
SEQRES  12 A  325  LYS HIS GLY PHE ASP ALA ALA PHE GLY GLY ALA ARG ARG          
SEQRES  13 A  325  ASP GLU GLU LYS SER ARG ALA LYS GLU ARG VAL TYR SER          
SEQRES  14 A  325  PHE ARG ASP SER LYS HIS ARG TRP ASP PRO LYS ASN GLN          
SEQRES  15 A  325  ARG PRO GLU LEU TRP ASN VAL TYR ASN GLY ASN VAL ASN          
SEQRES  16 A  325  LYS GLY GLU SER ILE ARG VAL PHE PRO LEU SER ASN TRP          
SEQRES  17 A  325  THR GLU LEU ASP ILE TRP GLN TYR ILE TYR LEU GLU GLY          
SEQRES  18 A  325  ILE PRO ILE VAL PRO LEU TYR PHE ALA ALA GLU ARG ASP          
SEQRES  19 A  325  VAL ILE GLU LYS ASN GLY THR LEU ILE MET ILE ASP ASP          
SEQRES  20 A  325  GLU ARG ILE LEU GLU HIS LEU THR ASP GLU GLU LYS SER          
SEQRES  21 A  325  ARG ILE VAL LYS LYS LYS VAL ARG PHE ARG THR LEU GLY          
SEQRES  22 A  325  CYS TYR PRO LEU THR GLY ALA VAL GLU SER GLU ALA THR          
SEQRES  23 A  325  SER LEU THR ASP ILE ILE GLN GLU MET LEU LEU THR ARG          
SEQRES  24 A  325  THR SER GLU ARG GLN GLY ARG VAL ILE ASP HIS ASP GLY          
SEQRES  25 A  325  ALA GLY SER MET GLU GLU LYS LYS ARG GLN GLY TYR PHE          
SEQRES   1 B  434  MET SER HIS GLN SER ASP LEU ILE SER GLU ASP ILE LEU          
SEQRES   2 B  434  ALA TYR LEU GLY GLN HIS GLU ARG LYS GLU MSE LEU ARG          
SEQRES   3 B  434  PHE LEU THR CYS GLY ASN VAL ASP ASP GLY LYS SER THR          
SEQRES   4 B  434  LEU ILE GLY ARG LEU LEU HIS ASP SER LYS MSE ILE TYR          
SEQRES   5 B  434  GLU ASP HIS LEU GLU ALA ILE THR ARG ASP SER LYS LYS          
SEQRES   6 B  434  SER GLY THR THR GLY ASP ASP VAL ASP LEU ALA LEU LEU          
SEQRES   7 B  434  VAL ASP GLY LEU GLN ALA GLU ARG GLU GLN GLY ILE THR          
SEQRES   8 B  434  ILE ASP VAL ALA TYR ARG TYR PHE SER THR ALA LYS ARG          
SEQRES   9 B  434  LYS PHE ILE ILE ALA ASP THR PRO GLY HIS GLU GLN TYR          
SEQRES  10 B  434  THR ARG ASN MSE ALA THR GLY ALA SER THR CYS ASP LEU          
SEQRES  11 B  434  ALA ILE ILE LEU VAL ASP ALA ARG TYR GLY VAL GLN THR          
SEQRES  12 B  434  GLN THR ARG ARG HIS SER TYR ILE ALA SER LEU LEU GLY          
SEQRES  13 B  434  ILE LYS HIS ILE VAL VAL ALA ILE ASN LYS MSE ASP LEU          
SEQRES  14 B  434  ASN GLY PHE ASP GLU ARG VAL PHE GLU SER ILE LYS ALA          
SEQRES  15 B  434  ASP TYR LEU LYS PHE ALA GLU GLY ILE ALA PHE LYS PRO          
SEQRES  16 B  434  THR THR MSE ALA PHE VAL PRO MSE SER ALA LEU LYS GLY          
SEQRES  17 B  434  ASP ASN VAL VAL ASN LYS SER GLU ARG SER PRO TRP TYR          
SEQRES  18 B  434  ALA GLY GLN SER LEU MSE GLU ILE LEU GLU THR VAL GLU          
SEQRES  19 B  434  ILE ALA SER ASP ARG ASN TYR THR ASP LEU ARG PHE PRO          
SEQRES  20 B  434  VAL GLN TYR VAL ASN ARG PRO ASN LEU ASN PHE ARG GLY          
SEQRES  21 B  434  PHE ALA GLY THR LEU ALA SER GLY ILE VAL HIS LYS GLY          
SEQRES  22 B  434  ASP GLU ILE VAL VAL LEU PRO SER GLY LYS SER SER ARG          
SEQRES  23 B  434  VAL LYS SER ILE VAL THR PHE GLU GLY GLU LEU GLU GLN          
SEQRES  24 B  434  ALA GLY PRO GLY GLN ALA VAL THR LEU THR MSE GLU ASP          
SEQRES  25 B  434  GLU ILE ASP ILE SER ARG GLY ASP LEU LEU VAL HIS ALA          
SEQRES  26 B  434  ASP ASN VAL PRO GLN VAL SER ASP ALA PHE ASP ALA MSE          
SEQRES  27 B  434  LEU VAL TRP MSE ALA GLU GLU PRO MSE LEU PRO GLY LYS          
SEQRES  28 B  434  LYS TYR ASP ILE LYS ARG ALA THR SER TYR VAL PRO GLY          
SEQRES  29 B  434  SER ILE ALA SER ILE THR HIS ARG VAL ASP VAL ASN THR          
SEQRES  30 B  434  LEU GLU GLU GLY PRO ALA SER SER LEU GLN LEU ASN GLU          
SEQRES  31 B  434  ILE GLY ARG VAL LYS VAL SER LEU ASP ALA PRO ILE ALA          
SEQRES  32 B  434  LEU ASP GLY TYR SER SER ASN ARG THR THR GLY ALA PHE          
SEQRES  33 B  434  ILE VAL ILE ASP ARG LEU THR ASN GLY THR VAL ALA ALA          
SEQRES  34 B  434  GLY MSE ILE ILE ALA                                          
HET    MSE  A   1       8                                                       
HET    MSE  A  31       8                                                       
HET    MSE  A  42       8                                                       
HET    MSE  A  60       8                                                       
HET    MSE  A  71       8                                                       
HET    MSE  A  78       8                                                       
HET    MSE  A  82       8                                                       
HET    MSE  A 113       8                                                       
HET    MSE  B  24       8                                                       
HET    MSE  B  50       8                                                       
HET    MSE  B 121       8                                                       
HET    MSE  B 167       8                                                       
HET    MSE  B 198       8                                                       
HET    MSE  B 203       8                                                       
HET    MSE  B 227       8                                                       
HET    MSE  B 310       8                                                       
HET    MSE  B 338       8                                                       
HET    MSE  B 342       8                                                       
HET    MSE  B 347       8                                                       
HET    MSE  B 431       8                                                       
HET     MG    598       1                                                       
HET     NA    700       1                                                       
HET    GDP    599      28                                                       
HET    AGS    600      31                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MG MAGNESIUM ION                                                    
HETNAM      NA SODIUM ION                                                       
HETNAM     GDP GUANOSINE-5'-DIPHOSPHATE                                         
HETNAM     AGS PHOSPHOTHIOPHOSPHORIC ACID-ADENYLATE ESTER                       
HETSYN     AGS ATP GAMMA-S                                                      
FORMUL   1  MSE    20(C5 H11 N O2 SE)                                           
FORMUL   3   MG    MG 2+                                                        
FORMUL   4   NA    NA 1+                                                        
FORMUL   5  GDP    C10 H15 N5 O11 P2                                            
FORMUL   6  AGS    C10 H16 N5 O12 P3 S                                          
FORMUL   7  HOH   *87(H2 O)                                                     
CRYST1  110.072  110.072  171.002  90.00  90.00 120.00 H 3           9          
ATOM      1  N   LEU A  -6      81.130  -1.061  34.558  1.00 50.34           N  
ATOM      2  CA  LEU A  -6      80.996   0.295  33.947  1.00 50.40           C  
ATOM      3  C   LEU A  -6      79.562   0.826  34.019  1.00 50.44           C  
ATOM      4  O   LEU A  -6      78.605   0.104  33.733  1.00 50.36           O  
ATOM      5  CB  LEU A  -6      81.491   0.288  32.496  1.00 50.37           C  
ATOM      6  CG  LEU A  -6      82.086   1.586  31.937  1.00 50.29           C  
ATOM      7  CD1 LEU A  -6      83.525   1.769  32.400  1.00 50.17           C  
ATOM      8  CD2 LEU A  -6      82.019   1.609  30.417  1.00 50.40           C  
ATOM      9  N   VAL A  -5      79.436   2.093  34.413  1.00 50.59           N  
ATOM     10  CA  VAL A  -5      78.151   2.784  34.504  1.00 50.63           C  
ATOM     11  C   VAL A  -5      77.729   3.280  33.121  1.00 50.83           C  
ATOM     12  O   VAL A  -5      78.530   3.897  32.414  1.00 50.84           O  
ATOM     13  CB  VAL A  -5      78.210   3.965  35.513  1.00 50.60           C  
ATOM     14  CG1 VAL A  -5      77.081   4.962  35.284  1.00 50.48           C  
ATOM     15  CG2 VAL A  -5      78.175   3.448  36.944  1.00 50.56           C  
ATOM     16  N   PRO A  -4      76.472   3.001  32.730  1.00 50.97           N  
ATOM     17  CA  PRO A  -4      75.945   3.417  31.435  1.00 51.06           C  
ATOM     18  C   PRO A  -4      75.686   4.920  31.348  1.00 51.19           C  
ATOM     19  O   PRO A  -4      75.570   5.595  32.371  1.00 51.36           O  
ATOM     20  CB  PRO A  -4      74.623   2.657  31.346  1.00 51.10           C  
ATOM     21  CG  PRO A  -4      74.199   2.485  32.762  1.00 50.94           C  
ATOM     22  CD  PRO A  -4      75.470   2.249  33.511  1.00 51.00           C  
ATOM     23  N   ARG A  -3      75.589   5.422  30.122  1.00 51.33           N  
ATOM     24  CA  ARG A  -3      75.325   6.832  29.859  1.00 51.43           C  
ATOM     25  C   ARG A  -3      73.885   7.210  30.215  1.00 51.72           C  
ATOM     26  O   ARG A  -3      72.980   6.375  30.154  1.00 51.71           O  
ATOM     27  CB  ARG A  -3      75.629   7.157  28.390  1.00 51.34           C  
ATOM     28  CG  ARG A  -3      77.096   6.979  28.005  1.00 50.66           C  
ATOM     29  CD  ARG A  -3      77.300   6.883  26.498  1.00 49.71           C  
ATOM     30  NE  ARG A  -3      78.721   6.849  26.147  1.00 49.45           N  
ATOM     31  CZ  ARG A  -3      79.205   6.614  24.930  1.00 48.95           C  
ATOM     32  NH1 ARG A  -3      78.389   6.379  23.911  1.00 48.87           N  
ATOM     33  NH2 ARG A  -3      80.515   6.606  24.729  1.00 48.51           N  
ATOM     34  N   GLY A  -2      73.686   8.469  30.596  1.00 52.08           N  
ATOM     35  CA  GLY A  -2      72.370   8.961  31.000  1.00 52.54           C  
ATOM     36  C   GLY A  -2      71.773   9.938  30.007  1.00 52.89           C  
ATOM     37  O   GLY A  -2      72.473  10.449  29.130  1.00 52.95           O  
ATOM     38  N   SER A  -1      70.476  10.202  30.151  1.00 53.16           N  
ATOM     39  CA  SER A  -1      69.749  11.100  29.252  1.00 53.42           C  
ATOM     40  C   SER A  -1      70.203  12.554  29.382  1.00 53.68           C  
ATOM     41  O   SER A  -1      70.058  13.345  28.447  1.00 53.70           O  
ATOM     42  CB  SER A  -1      68.240  10.994  29.489  1.00 53.33           C  
ATOM     43  OG  SER A  -1      67.912  11.226  30.846  1.00 53.46           O  
ATOM     44  N   HIS A   0      70.761  12.885  30.544  1.00 53.94           N  
ATOM     45  CA  HIS A   0      71.277  14.220  30.845  1.00 54.22           C  
ATOM     46  C   HIS A   0      72.463  14.621  29.961  1.00 54.34           C  
ATOM     47  O   HIS A   0      72.997  15.726  30.092  1.00 54.40           O  
ATOM     48  CB  HIS A   0      71.699  14.272  32.313  1.00 54.26           C  
ATOM     49  CG  HIS A   0      72.693  13.216  32.678  1.00 54.57           C  
ATOM     50  ND1 HIS A   0      74.053  13.435  32.655  1.00 54.75           N  
ATOM     51  CD2 HIS A   0      72.525  11.921  33.038  1.00 54.79           C  
ATOM     52  CE1 HIS A   0      74.681  12.325  33.001  1.00 54.82           C  
ATOM     53  NE2 HIS A   0      73.777  11.392  33.239  1.00 54.98           N  
HETATM   54  N   MSE A   1      72.870  13.721  29.069  1.00 54.41           N  
HETATM   55  CA  MSE A   1      74.013  13.956  28.188  1.00 54.44           C  
HETATM   56  C   MSE A   1      73.591  14.473  26.814  1.00 54.53           C  
HETATM   57  O   MSE A   1      74.300  15.275  26.203  1.00 54.58           O  
HETATM   58  CB  MSE A   1      74.854  12.685  28.041  1.00 54.34           C  
HETATM   59  CG  MSE A   1      75.397  12.152  29.357  1.00 54.10           C  
HETATM   60 SE   MSE A   1      76.618  10.656  29.138  0.50 52.80          SE  
HETATM   61  CE  MSE A   1      76.730  10.108  30.990  1.00 52.97           C  
ATOM     62  N   VAL A   2      72.444  14.002  26.332  1.00 54.61           N  
ATOM     63  CA  VAL A   2      71.915  14.423  25.036  1.00 54.71           C  
ATOM     64  C   VAL A   2      70.698  15.340  25.210  1.00 54.71           C  
ATOM     65  O   VAL A   2      69.932  15.195  26.166  1.00 54.80           O  
ATOM     66  CB  VAL A   2      71.598  13.196  24.125  1.00 54.76           C  
ATOM     67  CG1 VAL A   2      70.441  12.362  24.683  1.00 54.63           C  
ATOM     68  CG2 VAL A   2      71.332  13.625  22.678  1.00 55.01           C  
ATOM     69  N   ASP A   3      70.545  16.301  24.305  1.00 54.68           N  
ATOM     70  CA  ASP A   3      69.372  17.176  24.300  1.00 54.73           C  
ATOM     71  C   ASP A   3      68.129  16.367  23.936  1.00 54.29           C  
ATOM     72  O   ASP A   3      68.093  15.720  22.886  1.00 54.33           O  
ATOM     73  CB  ASP A   3      69.567  18.367  23.345  1.00 55.09           C  
ATOM     74  CG  ASP A   3      70.067  17.953  21.960  1.00 56.05           C  
ATOM     75  OD1 ASP A   3      70.791  16.937  21.847  1.00 57.18           O  
ATOM     76  OD2 ASP A   3      69.745  18.659  20.978  1.00 56.83           O  
ATOM     77  N   LYS A   4      67.130  16.390  24.818  1.00 53.73           N  
ATOM     78  CA  LYS A   4      65.930  15.559  24.655  1.00 53.14           C  
ATOM     79  C   LYS A   4      65.097  15.944  23.429  1.00 52.40           C  
ATOM     80  O   LYS A   4      65.057  17.110  23.031  1.00 52.32           O  
ATOM     81  CB  LYS A   4      65.074  15.535  25.935  1.00 53.23           C  
ATOM     82  CG  LYS A   4      64.278  16.803  26.219  1.00 53.54           C  
ATOM     83  CD  LYS A   4      63.020  16.516  27.044  1.00 54.27           C  
ATOM     84  CE  LYS A   4      63.300  16.513  28.546  1.00 54.72           C  
ATOM     85  NZ  LYS A   4      62.052  16.521  29.367  1.00 54.33           N  
ATOM     86  N   LEU A   5      64.447  14.948  22.836  1.00 51.61           N  
ATOM     87  CA  LEU A   5      63.707  15.131  21.593  1.00 50.84           C  
ATOM     88  C   LEU A   5      62.436  15.948  21.780  1.00 50.21           C  
ATOM     89  O   LEU A   5      61.502  15.519  22.459  1.00 50.16           O  
ATOM     90  CB  LEU A   5      63.356  13.778  20.964  1.00 50.93           C  
ATOM     91  CG  LEU A   5      64.393  13.038  20.120  1.00 50.92           C  
ATOM     92  CD1 LEU A   5      63.776  11.758  19.588  1.00 51.31           C  
ATOM     93  CD2 LEU A   5      64.901  13.898  18.970  1.00 51.00           C  
ATOM     94  N   THR A   6      62.426  17.132  21.173  1.00 49.37           N  
ATOM     95  CA  THR A   6      61.228  17.958  21.076  1.00 48.38           C  
ATOM     96  C   THR A   6      60.322  17.386  19.988  1.00 47.72           C  
ATOM     97  O   THR A   6      60.765  16.577  19.171  1.00 47.77           O  
ATOM     98  CB  THR A   6      61.580  19.425  20.749  1.00 48.54           C  
ATOM     99  OG1 THR A   6      62.314  19.479  19.519  1.00 48.45           O  
ATOM    100  CG2 THR A   6      62.415  20.048  21.867  1.00 48.32           C  
ATOM    101  N   HIS A   7      59.060  17.811  19.975  1.00 46.88           N  
ATOM    102  CA  HIS A   7      58.050  17.224  19.090  1.00 46.09           C  
ATOM    103  C   HIS A   7      58.407  17.309  17.602  1.00 45.72           C  
ATOM    104  O   HIS A   7      58.232  16.338  16.867  1.00 45.44           O  
ATOM    105  CB  HIS A   7      56.660  17.812  19.377  1.00 45.98           C  
ATOM    106  CG  HIS A   7      56.491  19.233  18.931  1.00 45.47           C  
ATOM    107  ND1 HIS A   7      57.279  20.261  19.400  1.00 44.92           N  
ATOM    108  CD2 HIS A   7      55.616  19.794  18.063  1.00 44.74           C  
ATOM    109  CE1 HIS A   7      56.902  21.395  18.835  1.00 44.66           C  
ATOM    110  NE2 HIS A   7      55.895  21.138  18.020  1.00 44.63           N  
ATOM    111  N   LEU A   8      58.936  18.453  17.175  1.00 45.40           N  
ATOM    112  CA  LEU A   8      59.336  18.651  15.782  1.00 45.19           C  
ATOM    113  C   LEU A   8      60.560  17.828  15.384  1.00 45.06           C  
ATOM    114  O   LEU A   8      60.632  17.321  14.265  1.00 44.89           O  
ATOM    115  CB  LEU A   8      59.575  20.131  15.485  1.00 45.07           C  
ATOM    116  CG  LEU A   8      58.352  21.049  15.503  1.00 45.12           C  
ATOM    117  CD1 LEU A   8      58.803  22.496  15.401  1.00 44.71           C  
ATOM    118  CD2 LEU A   8      57.356  20.701  14.395  1.00 44.85           C  
ATOM    119  N   LYS A   9      61.517  17.693  16.298  1.00 44.95           N  
ATOM    120  CA  LYS A   9      62.692  16.862  16.044  1.00 45.06           C  
ATOM    121  C   LYS A   9      62.293  15.393  15.947  1.00 44.80           C  
ATOM    122  O   LYS A   9      62.814  14.648  15.115  1.00 44.71           O  
ATOM    123  CB  LYS A   9      63.763  17.072  17.119  1.00 45.02           C  
ATOM    124  CG  LYS A   9      64.600  18.323  16.901  1.00 45.74           C  
ATOM    125  CD  LYS A   9      65.616  18.545  18.015  1.00 47.28           C  
ATOM    126  CE  LYS A   9      66.250  19.933  17.913  1.00 47.92           C  
ATOM    127  NZ  LYS A   9      67.484  20.063  18.744  1.00 48.43           N  
ATOM    128  N   GLN A  10      61.348  14.998  16.792  1.00 44.60           N  
ATOM    129  CA  GLN A  10      60.849  13.632  16.811  1.00 44.56           C  
ATOM    130  C   GLN A  10      60.071  13.322  15.536  1.00 44.48           C  
ATOM    131  O   GLN A  10      60.269  12.269  14.930  1.00 44.41           O  
ATOM    132  CB  GLN A  10      59.975  13.414  18.041  1.00 44.58           C  
ATOM    133  CG  GLN A  10      59.880  11.966  18.480  1.00 44.99           C  
ATOM    134  CD  GLN A  10      59.042  11.788  19.730  1.00 45.04           C  
ATOM    135  OE1 GLN A  10      58.869  12.716  20.523  1.00 44.97           O  
ATOM    136  NE2 GLN A  10      58.513  10.587  19.911  1.00 45.73           N  
ATOM    137  N   LEU A  11      59.199  14.250  15.137  1.00 44.33           N  
ATOM    138  CA  LEU A  11      58.473  14.161  13.870  1.00 44.11           C  
ATOM    139  C   LEU A  11      59.428  14.140  12.675  1.00 44.12           C  
ATOM    140  O   LEU A  11      59.249  13.351  11.746  1.00 44.22           O  
ATOM    141  CB  LEU A  11      57.489  15.326  13.725  1.00 44.00           C  
ATOM    142  CG  LEU A  11      56.225  15.362  14.593  1.00 43.70           C  
ATOM    143  CD1 LEU A  11      55.529  16.708  14.449  1.00 42.85           C  
ATOM    144  CD2 LEU A  11      55.267  14.219  14.267  1.00 43.31           C  
ATOM    145  N   GLU A  12      60.433  15.013  12.711  1.00 43.98           N  
ATOM    146  CA  GLU A  12      61.473  15.074  11.687  1.00 43.89           C  
ATOM    147  C   GLU A  12      62.142  13.712  11.502  1.00 43.81           C  
ATOM    148  O   GLU A  12      62.207  13.193  10.385  1.00 43.79           O  
ATOM    149  CB  GLU A  12      62.515  16.133  12.060  1.00 43.94           C  
ATOM    150  CG  GLU A  12      63.520  16.461  10.969  1.00 44.16           C  
ATOM    151  CD  GLU A  12      64.592  17.426  11.440  1.00 44.22           C  
ATOM    152  OE1 GLU A  12      64.607  18.578  10.963  1.00 44.02           O  
ATOM    153  OE2 GLU A  12      65.413  17.042  12.299  1.00 44.65           O  
ATOM    154  N   ALA A  13      62.619  13.135  12.602  1.00 43.62           N  
ATOM    155  CA  ALA A  13      63.278  11.828  12.570  1.00 43.58           C  
ATOM    156  C   ALA A  13      62.355  10.719  12.068  1.00 43.49           C  
ATOM    157  O   ALA A  13      62.773   9.862  11.284  1.00 43.49           O  
ATOM    158  CB  ALA A  13      63.847  11.477  13.939  1.00 43.33           C  
ATOM    159  N   GLU A  14      61.099  10.750  12.510  1.00 43.38           N  
ATOM    160  CA  GLU A  14      60.126   9.725  12.144  1.00 43.37           C  
ATOM    161  C   GLU A  14      59.817   9.756  10.651  1.00 43.34           C  
ATOM    162  O   GLU A  14      59.683   8.706  10.019  1.00 43.50           O  
ATOM    163  CB  GLU A  14      58.843   9.874  12.963  1.00 43.37           C  
ATOM    164  CG  GLU A  14      58.915   9.241  14.348  1.00 43.71           C  
ATOM    165  CD  GLU A  14      57.671   9.496  15.193  1.00 44.77           C  
ATOM    166  OE1 GLU A  14      56.587   9.766  14.628  1.00 44.17           O  
ATOM    167  OE2 GLU A  14      57.780   9.422  16.439  1.00 45.32           O  
ATOM    168  N   SER A  15      59.725  10.962  10.096  1.00 42.98           N  
ATOM    169  CA  SER A  15      59.472  11.141   8.676  1.00 42.76           C  
ATOM    170  C   SER A  15      60.698  10.783   7.834  1.00 42.73           C  
ATOM    171  O   SER A  15      60.564  10.205   6.751  1.00 42.81           O  
ATOM    172  CB  SER A  15      59.018  12.575   8.399  1.00 42.98           C  
ATOM    173  OG  SER A  15      57.789  12.847   9.053  1.00 42.79           O  
ATOM    174  N   ILE A  16      61.886  11.125   8.335  1.00 42.38           N  
ATOM    175  CA  ILE A  16      63.140  10.746   7.684  1.00 42.03           C  
ATOM    176  C   ILE A  16      63.244   9.229   7.585  1.00 41.92           C  
ATOM    177  O   ILE A  16      63.568   8.691   6.526  1.00 41.96           O  
ATOM    178  CB  ILE A  16      64.378  11.323   8.418  1.00 42.24           C  
ATOM    179  CG1 ILE A  16      64.516  12.822   8.130  1.00 41.62           C  
ATOM    180  CG2 ILE A  16      65.656  10.589   7.999  1.00 41.68           C  
ATOM    181  CD1 ILE A  16      65.321  13.578   9.164  1.00 40.64           C  
ATOM    182  N   HIS A  17      62.952   8.552   8.691  1.00 41.70           N  
ATOM    183  CA  HIS A  17      62.956   7.094   8.738  1.00 41.58           C  
ATOM    184  C   HIS A  17      62.048   6.486   7.666  1.00 41.50           C  
ATOM    185  O   HIS A  17      62.463   5.574   6.947  1.00 41.58           O  
ATOM    186  CB  HIS A  17      62.553   6.612  10.134  1.00 41.61           C  
ATOM    187  CG  HIS A  17      62.688   5.134  10.330  1.00 41.74           C  
ATOM    188  ND1 HIS A  17      61.654   4.255  10.092  1.00 42.07           N  
ATOM    189  CD2 HIS A  17      63.732   4.382  10.752  1.00 42.31           C  
ATOM    190  CE1 HIS A  17      62.055   3.024  10.354  1.00 42.64           C  
ATOM    191  NE2 HIS A  17      63.313   3.072  10.755  1.00 42.84           N  
ATOM    192  N   ILE A  18      60.822   6.999   7.559  1.00 41.20           N  
ATOM    193  CA  ILE A  18      59.861   6.528   6.558  1.00 40.98           C  
ATOM    194  C   ILE A  18      60.402   6.676   5.132  1.00 41.20           C  
ATOM    195  O   ILE A  18      60.320   5.743   4.329  1.00 41.33           O  
ATOM    196  CB  ILE A  18      58.512   7.269   6.672  1.00 40.76           C  
ATOM    197  CG1 ILE A  18      57.793   6.893   7.966  1.00 39.97           C  
ATOM    198  CG2 ILE A  18      57.628   6.966   5.469  1.00 40.56           C  
ATOM    199  CD1 ILE A  18      56.883   7.986   8.489  1.00 40.03           C  
ATOM    200  N   ILE A  19      60.953   7.850   4.829  1.00 41.26           N  
ATOM    201  CA  ILE A  19      61.508   8.132   3.507  1.00 41.33           C  
ATOM    202  C   ILE A  19      62.641   7.159   3.167  1.00 41.53           C  
ATOM    203  O   ILE A  19      62.668   6.589   2.074  1.00 41.55           O  
ATOM    204  CB  ILE A  19      61.928   9.622   3.374  1.00 41.26           C  
ATOM    205  CG1 ILE A  19      60.672  10.499   3.296  1.00 41.20           C  
ATOM    206  CG2 ILE A  19      62.796   9.851   2.143  1.00 40.82           C  
ATOM    207  CD1 ILE A  19      60.901  11.967   3.586  1.00 41.52           C  
ATOM    208  N   ARG A  20      63.540   6.944   4.124  1.00 41.84           N  
ATOM    209  CA  ARG A  20      64.642   5.997   3.965  1.00 42.13           C  
ATOM    210  C   ARG A  20      64.168   4.563   3.689  1.00 42.63           C  
ATOM    211  O   ARG A  20      64.722   3.897   2.809  1.00 42.68           O  
ATOM    212  CB  ARG A  20      65.567   6.037   5.183  1.00 42.11           C  
ATOM    213  CG  ARG A  20      66.427   7.292   5.279  1.00 41.94           C  
ATOM    214  CD  ARG A  20      67.104   7.402   6.645  1.00 41.71           C  
ATOM    215  NE  ARG A  20      68.096   8.478   6.694  1.00 41.41           N  
ATOM    216  CZ  ARG A  20      68.823   8.791   7.766  1.00 40.91           C  
ATOM    217  NH1 ARG A  20      69.700   9.783   7.708  1.00 39.84           N  
ATOM    218  NH2 ARG A  20      68.682   8.116   8.898  1.00 41.25           N  
ATOM    219  N   GLU A  21      63.151   4.100   4.423  1.00 43.00           N  
ATOM    220  CA  GLU A  21      62.573   2.763   4.215  1.00 43.63           C  
ATOM    221  C   GLU A  21      62.100   2.544   2.782  1.00 43.91           C  
ATOM    222  O   GLU A  21      62.436   1.539   2.154  1.00 44.02           O  
ATOM    223  CB  GLU A  21      61.391   2.490   5.157  1.00 43.75           C  
ATOM    224  CG  GLU A  21      61.703   1.695   6.429  1.00 44.27           C  
ATOM    225  CD  GLU A  21      62.514   0.436   6.187  1.00 44.64           C  
ATOM    226  OE1 GLU A  21      61.922  -0.651   6.021  1.00 44.37           O  
ATOM    227  OE2 GLU A  21      63.756   0.536   6.173  1.00 46.27           O  
ATOM    228  N   VAL A  22      61.303   3.483   2.280  1.00 44.16           N  
ATOM    229  CA  VAL A  22      60.789   3.398   0.924  1.00 44.52           C  
ATOM    230  C   VAL A  22      61.956   3.344  -0.055  1.00 44.78           C  
ATOM    231  O   VAL A  22      62.019   2.454  -0.903  1.00 44.78           O  
ATOM    232  CB  VAL A  22      59.849   4.573   0.597  1.00 44.60           C  
ATOM    233  CG1 VAL A  22      59.371   4.499  -0.846  1.00 44.52           C  
ATOM    234  CG2 VAL A  22      58.665   4.580   1.550  1.00 44.40           C  
ATOM    235  N   ALA A  23      62.895   4.274   0.094  1.00 45.16           N  
ATOM    236  CA  ALA A  23      64.092   4.291  -0.741  1.00 45.58           C  
ATOM    237  C   ALA A  23      64.831   2.957  -0.663  1.00 46.01           C  
ATOM    238  O   ALA A  23      65.333   2.459  -1.670  1.00 45.99           O  
ATOM    239  CB  ALA A  23      65.004   5.434  -0.343  1.00 45.40           C  
ATOM    240  N   ALA A  24      64.869   2.374   0.534  1.00 46.56           N  
ATOM    241  CA  ALA A  24      65.560   1.107   0.769  1.00 47.04           C  
ATOM    242  C   ALA A  24      64.869  -0.097   0.130  1.00 47.36           C  
ATOM    243  O   ALA A  24      65.526  -1.076  -0.223  1.00 47.43           O  
ATOM    244  CB  ALA A  24      65.746   0.876   2.265  1.00 46.98           C  
ATOM    245  N   GLU A  25      63.551  -0.020  -0.023  1.00 47.82           N  
ATOM    246  CA  GLU A  25      62.766  -1.185  -0.435  1.00 48.22           C  
ATOM    247  C   GLU A  25      62.188  -1.103  -1.848  1.00 48.36           C  
ATOM    248  O   GLU A  25      61.930  -2.133  -2.470  1.00 48.31           O  
ATOM    249  CB  GLU A  25      61.654  -1.469   0.579  1.00 48.22           C  
ATOM    250  CG  GLU A  25      62.153  -2.013   1.910  1.00 48.52           C  
ATOM    251  CD  GLU A  25      61.039  -2.584   2.772  1.00 49.36           C  
ATOM    252  OE1 GLU A  25      59.951  -1.967   2.849  1.00 48.84           O  
ATOM    253  OE2 GLU A  25      61.261  -3.653   3.380  1.00 49.81           O  
ATOM    254  N   PHE A  26      61.992   0.114  -2.346  1.00 48.67           N  
ATOM    255  CA  PHE A  26      61.371   0.320  -3.652  1.00 48.99           C  
ATOM    256  C   PHE A  26      62.370   0.759  -4.717  1.00 49.27           C  
ATOM    257  O   PHE A  26      63.316   1.500  -4.430  1.00 49.28           O  
ATOM    258  CB  PHE A  26      60.216   1.320  -3.541  1.00 49.08           C  
ATOM    259  CG  PHE A  26      59.018   0.777  -2.811  1.00 49.28           C  
ATOM    260  CD1 PHE A  26      57.944   0.243  -3.520  1.00 48.75           C  
ATOM    261  CD2 PHE A  26      58.971   0.782  -1.419  1.00 48.74           C  
ATOM    262  CE1 PHE A  26      56.840  -0.272  -2.852  1.00 48.73           C  
ATOM    263  CE2 PHE A  26      57.872   0.269  -0.745  1.00 48.85           C  
ATOM    264  CZ  PHE A  26      56.803  -0.258  -1.464  1.00 48.98           C  
ATOM    265  N   ASP A  27      62.147   0.292  -5.944  1.00 49.52           N  
ATOM    266  CA  ASP A  27      63.052   0.549  -7.062  1.00 49.79           C  
ATOM    267  C   ASP A  27      62.923   1.954  -7.640  1.00 49.90           C  
ATOM    268  O   ASP A  27      63.924   2.653  -7.803  1.00 49.96           O  
ATOM    269  CB  ASP A  27      62.845  -0.490  -8.165  1.00 49.94           C  
ATOM    270  CG  ASP A  27      63.360  -1.862  -7.780  1.00 50.33           C  
ATOM    271  OD1 ASP A  27      62.670  -2.859  -8.077  1.00 50.55           O  
ATOM    272  OD2 ASP A  27      64.455  -1.943  -7.182  1.00 50.91           O  
ATOM    273  N   ASN A  28      61.696   2.363  -7.956  1.00 50.01           N  
ATOM    274  CA  ASN A  28      61.458   3.662  -8.581  1.00 50.20           C  
ATOM    275  C   ASN A  28      60.484   4.549  -7.801  1.00 50.19           C  
ATOM    276  O   ASN A  28      59.309   4.641  -8.154  1.00 50.21           O  
ATOM    277  CB  ASN A  28      60.971   3.486 -10.026  1.00 50.32           C  
ATOM    278  CG  ASN A  28      61.980   2.772 -10.908  1.00 50.72           C  
ATOM    279  OD1 ASN A  28      63.169   3.095 -10.905  1.00 51.74           O  
ATOM    280  ND2 ASN A  28      61.504   1.803 -11.680  1.00 51.03           N  
ATOM    281  N   PRO A  29      60.963   5.197  -6.726  1.00 50.16           N  
ATOM    282  CA  PRO A  29      60.115   6.152  -6.025  1.00 50.19           C  
ATOM    283  C   PRO A  29      60.071   7.521  -6.705  1.00 50.36           C  
ATOM    284  O   PRO A  29      60.940   7.845  -7.516  1.00 50.32           O  
ATOM    285  CB  PRO A  29      60.782   6.272  -4.645  1.00 50.09           C  
ATOM    286  CG  PRO A  29      61.932   5.301  -4.643  1.00 49.97           C  
ATOM    287  CD  PRO A  29      62.273   5.065  -6.072  1.00 50.13           C  
ATOM    288  N   VAL A  30      59.042   8.301  -6.386  1.00 50.63           N  
ATOM    289  CA  VAL A  30      58.997   9.725  -6.721  1.00 50.84           C  
ATOM    290  C   VAL A  30      58.483  10.541  -5.555  1.00 51.06           C  
ATOM    291  O   VAL A  30      57.595  10.104  -4.820  1.00 51.12           O  
ATOM    292  CB  VAL A  30      58.077  10.057  -7.912  1.00 50.77           C  
ATOM    293  CG1 VAL A  30      58.899  10.383  -9.139  1.00 50.81           C  
ATOM    294  CG2 VAL A  30      57.051   8.958  -8.158  1.00 50.68           C  
HETATM  295  N   MSE A  31      59.044  11.733  -5.399  1.00 51.27           N  
HETATM  296  CA  MSE A  31      58.472  12.701  -4.485  1.00 51.47           C  
HETATM  297  C   MSE A  31      57.519  13.607  -5.256  1.00 51.48           C  
HETATM  298  O   MSE A  31      57.944  14.458  -6.042  1.00 51.51           O  
HETATM  299  CB  MSE A  31      59.561  13.501  -3.768  1.00 51.48           C  
HETATM  300  CG  MSE A  31      58.999  14.509  -2.785  1.00 51.95           C  
HETATM  301 SE   MSE A  31      60.096  14.737  -1.205  0.75 53.06          SE  
HETATM  302  CE  MSE A  31      59.906  12.972  -0.423  1.00 52.65           C  
ATOM    303  N   LEU A  32      56.225  13.386  -5.047  1.00 51.50           N  
ATOM    304  CA  LEU A  32      55.194  14.254  -5.597  1.00 51.48           C  
ATOM    305  C   LEU A  32      55.314  15.615  -4.930  1.00 51.53           C  
ATOM    306  O   LEU A  32      54.962  15.778  -3.762  1.00 51.51           O  
ATOM    307  CB  LEU A  32      53.803  13.657  -5.358  1.00 51.37           C  
ATOM    308  CG  LEU A  32      53.168  12.706  -6.379  1.00 51.27           C  
ATOM    309  CD1 LEU A  32      54.175  11.809  -7.097  1.00 50.81           C  
ATOM    310  CD2 LEU A  32      52.089  11.870  -5.694  1.00 51.11           C  
ATOM    311  N   TYR A  33      55.850  16.581  -5.666  1.00 51.58           N  
ATOM    312  CA  TYR A  33      56.045  17.925  -5.143  1.00 51.81           C  
ATOM    313  C   TYR A  33      55.055  18.891  -5.781  1.00 51.98           C  
ATOM    314  O   TYR A  33      55.066  19.089  -6.997  1.00 52.04           O  
ATOM    315  CB  TYR A  33      57.494  18.382  -5.362  1.00 51.79           C  
ATOM    316  CG  TYR A  33      57.724  19.873  -5.218  1.00 51.82           C  
ATOM    317  CD1 TYR A  33      57.595  20.504  -3.982  1.00 52.05           C  
ATOM    318  CD2 TYR A  33      58.088  20.647  -6.317  1.00 51.73           C  
ATOM    319  CE1 TYR A  33      57.803  21.869  -3.847  1.00 51.98           C  
ATOM    320  CE2 TYR A  33      58.302  22.014  -6.191  1.00 51.56           C  
ATOM    321  CZ  TYR A  33      58.156  22.618  -4.956  1.00 51.77           C  
ATOM    322  OH  TYR A  33      58.365  23.970  -4.823  1.00 51.94           O  
ATOM    323  N   SER A  34      54.185  19.466  -4.953  1.00 52.24           N  
ATOM    324  CA  SER A  34      53.274  20.523  -5.378  1.00 52.40           C  
ATOM    325  C   SER A  34      54.103  21.744  -5.741  1.00 52.46           C  
ATOM    326  O   SER A  34      55.147  21.626  -6.378  1.00 52.76           O  
ATOM    327  CB  SER A  34      52.316  20.886  -4.240  1.00 52.45           C  
ATOM    328  OG  SER A  34      51.376  19.860  -3.998  1.00 52.62           O  
ATOM    329  N   ILE A  35      53.626  22.918  -5.355  1.00 52.37           N  
ATOM    330  CA  ILE A  35      54.490  24.085  -5.219  1.00 52.27           C  
ATOM    331  C   ILE A  35      54.110  24.732  -3.886  1.00 52.13           C  
ATOM    332  O   ILE A  35      54.472  25.876  -3.596  1.00 52.19           O  
ATOM    333  CB  ILE A  35      54.348  25.093  -6.392  1.00 52.26           C  
ATOM    334  CG1 ILE A  35      54.025  24.396  -7.726  1.00 52.32           C  
ATOM    335  CG2 ILE A  35      55.592  25.972  -6.482  1.00 52.30           C  
ATOM    336  CD1 ILE A  35      55.212  23.781  -8.453  1.00 52.01           C  
ATOM    337  N   GLY A  36      53.389  23.961  -3.072  1.00 51.81           N  
ATOM    338  CA  GLY A  36      52.806  24.444  -1.825  1.00 51.42           C  
ATOM    339  C   GLY A  36      53.601  24.113  -0.577  1.00 51.19           C  
ATOM    340  O   GLY A  36      54.714  23.590  -0.653  1.00 51.20           O  
ATOM    341  N   LYS A  37      53.006  24.398   0.578  1.00 50.79           N  
ATOM    342  CA  LYS A  37      53.742  24.445   1.840  1.00 50.40           C  
ATOM    343  C   LYS A  37      54.086  23.088   2.452  1.00 50.10           C  
ATOM    344  O   LYS A  37      55.165  22.921   3.022  1.00 50.11           O  
ATOM    345  CB  LYS A  37      53.039  25.359   2.853  1.00 50.44           C  
ATOM    346  CG  LYS A  37      51.576  25.048   3.132  1.00 50.97           C  
ATOM    347  CD  LYS A  37      51.412  24.445   4.513  1.00 51.93           C  
ATOM    348  CE  LYS A  37      50.026  24.718   5.070  1.00 52.92           C  
ATOM    349  NZ  LYS A  37      49.891  24.174   6.453  1.00 54.41           N  
ATOM    350  N   ASP A  38      53.180  22.124   2.335  1.00 49.60           N  
ATOM    351  CA  ASP A  38      53.424  20.800   2.898  1.00 48.98           C  
ATOM    352  C   ASP A  38      54.491  20.057   2.102  1.00 48.70           C  
ATOM    353  O   ASP A  38      55.358  19.406   2.686  1.00 48.81           O  
ATOM    354  CB  ASP A  38      52.130  19.987   2.979  1.00 48.93           C  
ATOM    355  CG  ASP A  38      51.117  20.595   3.938  1.00 48.77           C  
ATOM    356  OD1 ASP A  38      51.308  20.491   5.171  1.00 47.96           O  
ATOM    357  OD2 ASP A  38      50.118  21.167   3.453  1.00 48.45           O  
ATOM    358  N   SER A  39      54.440  20.179   0.776  1.00 48.19           N  
ATOM    359  CA  SER A  39      55.422  19.534  -0.096  1.00 47.76           C  
ATOM    360  C   SER A  39      56.822  20.126   0.080  1.00 47.38           C  
ATOM    361  O   SER A  39      57.826  19.450  -0.161  1.00 47.30           O  
ATOM    362  CB  SER A  39      54.986  19.611  -1.557  1.00 47.63           C  
ATOM    363  OG  SER A  39      55.042  20.942  -2.026  1.00 48.17           O  
ATOM    364  N   ALA A  40      56.872  21.388   0.501  1.00 46.92           N  
ATOM    365  CA  ALA A  40      58.126  22.077   0.798  1.00 46.49           C  
ATOM    366  C   ALA A  40      58.786  21.510   2.050  1.00 46.21           C  
ATOM    367  O   ALA A  40      60.011  21.420   2.129  1.00 46.27           O  
ATOM    368  CB  ALA A  40      57.882  23.566   0.960  1.00 46.52           C  
ATOM    369  N   VAL A  41      57.964  21.138   3.027  1.00 45.81           N  
ATOM    370  CA  VAL A  41      58.450  20.506   4.251  1.00 45.40           C  
ATOM    371  C   VAL A  41      58.943  19.089   3.956  1.00 45.17           C  
ATOM    372  O   VAL A  41      59.986  18.667   4.465  1.00 45.19           O  
ATOM    373  CB  VAL A  41      57.361  20.482   5.345  1.00 45.39           C  
ATOM    374  CG1 VAL A  41      57.809  19.649   6.544  1.00 45.33           C  
ATOM    375  CG2 VAL A  41      57.011  21.899   5.776  1.00 44.94           C  
HETATM  376  N   MSE A  42      58.196  18.374   3.119  1.00 44.74           N  
HETATM  377  CA  MSE A  42      58.545  17.008   2.739  1.00 44.31           C  
HETATM  378  C   MSE A  42      59.849  16.964   1.951  1.00 44.20           C  
HETATM  379  O   MSE A  42      60.686  16.097   2.190  1.00 44.44           O  
HETATM  380  CB  MSE A  42      57.410  16.357   1.945  1.00 44.27           C  
HETATM  381  CG  MSE A  42      57.577  14.860   1.728  1.00 43.43           C  
HETATM  382 SE   MSE A  42      56.045  14.037   0.853  0.50 41.56          SE  
HETATM  383  CE  MSE A  42      56.005  15.076  -0.774  1.00 41.10           C  
ATOM    384  N   LEU A  43      60.023  17.908   1.029  1.00 43.97           N  
ATOM    385  CA  LEU A  43      61.254  17.997   0.244  1.00 43.64           C  
ATOM    386  C   LEU A  43      62.463  18.322   1.121  1.00 43.49           C  
ATOM    387  O   LEU A  43      63.559  17.812   0.892  1.00 43.56           O  
ATOM    388  CB  LEU A  43      61.114  19.035  -0.869  1.00 43.67           C  
ATOM    389  CG  LEU A  43      62.253  19.136  -1.887  1.00 43.60           C  
ATOM    390  CD1 LEU A  43      62.286  17.917  -2.796  1.00 43.61           C  
ATOM    391  CD2 LEU A  43      62.108  20.401  -2.705  1.00 43.23           C  
ATOM    392  N   HIS A  44      62.252  19.173   2.121  1.00 43.22           N  
ATOM    393  CA  HIS A  44      63.282  19.498   3.099  1.00 42.93           C  
ATOM    394  C   HIS A  44      63.664  18.264   3.924  1.00 42.86           C  
ATOM    395  O   HIS A  44      64.842  18.041   4.215  1.00 42.76           O  
ATOM    396  CB  HIS A  44      62.803  20.635   4.002  1.00 42.89           C  
ATOM    397  CG  HIS A  44      63.901  21.300   4.771  1.00 42.81           C  
ATOM    398  ND1 HIS A  44      63.918  21.354   6.147  1.00 42.93           N  
ATOM    399  CD2 HIS A  44      65.019  21.942   4.355  1.00 42.69           C  
ATOM    400  CE1 HIS A  44      64.998  22.001   6.548  1.00 42.69           C  
ATOM    401  NE2 HIS A  44      65.684  22.366   5.480  1.00 42.69           N  
ATOM    402  N   LEU A  45      62.661  17.463   4.285  1.00 42.66           N  
ATOM    403  CA  LEU A  45      62.883  16.193   4.977  1.00 42.59           C  
ATOM    404  C   LEU A  45      63.655  15.196   4.116  1.00 42.50           C  
ATOM    405  O   LEU A  45      64.543  14.499   4.603  1.00 42.68           O  
ATOM    406  CB  LEU A  45      61.548  15.587   5.423  1.00 42.56           C  
ATOM    407  CG  LEU A  45      61.032  15.843   6.847  1.00 42.75           C  
ATOM    408  CD1 LEU A  45      61.781  16.952   7.579  1.00 42.30           C  
ATOM    409  CD2 LEU A  45      59.526  16.109   6.839  1.00 42.24           C  
ATOM    410  N   ALA A  46      63.319  15.143   2.832  1.00 42.37           N  
ATOM    411  CA  ALA A  46      63.991  14.255   1.897  1.00 42.29           C  
ATOM    412  C   ALA A  46      65.484  14.568   1.779  1.00 42.30           C  
ATOM    413  O   ALA A  46      66.304  13.657   1.684  1.00 42.11           O  
ATOM    414  CB  ALA A  46      63.315  14.318   0.541  1.00 42.34           C  
ATOM    415  N   ARG A  47      65.830  15.854   1.780  1.00 42.43           N  
ATOM    416  CA  ARG A  47      67.229  16.274   1.748  1.00 42.63           C  
ATOM    417  C   ARG A  47      67.959  15.803   3.003  1.00 42.41           C  
ATOM    418  O   ARG A  47      69.039  15.212   2.916  1.00 42.40           O  
ATOM    419  CB  ARG A  47      67.356  17.797   1.590  1.00 42.80           C  
ATOM    420  CG  ARG A  47      66.825  18.358   0.273  1.00 44.37           C  
ATOM    421  CD  ARG A  47      67.532  17.769  -0.954  1.00 47.01           C  
ATOM    422  NE  ARG A  47      68.704  18.539  -1.376  1.00 48.72           N  
ATOM    423  CZ  ARG A  47      69.408  18.294  -2.482  1.00 49.89           C  
ATOM    424  NH1 ARG A  47      69.074  17.292  -3.289  1.00 49.88           N  
ATOM    425  NH2 ARG A  47      70.454  19.057  -2.786  1.00 50.18           N  
ATOM    426  N   LYS A  48      67.350  16.050   4.161  1.00 42.19           N  
ATOM    427  CA  LYS A  48      67.898  15.627   5.450  1.00 42.00           C  
ATOM    428  C   LYS A  48      68.081  14.113   5.529  1.00 42.01           C  
ATOM    429  O   LYS A  48      69.012  13.619   6.173  1.00 42.21           O  
ATOM    430  CB  LYS A  48      67.001  16.098   6.598  1.00 41.86           C  
ATOM    431  CG  LYS A  48      66.898  17.612   6.742  1.00 42.01           C  
ATOM    432  CD  LYS A  48      66.343  17.985   8.109  1.00 41.89           C  
ATOM    433  CE  LYS A  48      66.527  19.463   8.401  1.00 41.21           C  
ATOM    434  NZ  LYS A  48      66.601  19.735   9.867  1.00 39.94           N  
ATOM    435  N   ALA A  49      67.188  13.386   4.860  1.00 41.81           N  
ATOM    436  CA  ALA A  49      67.202  11.927   4.847  1.00 41.45           C  
ATOM    437  C   ALA A  49      68.416  11.317   4.142  1.00 41.24           C  
ATOM    438  O   ALA A  49      68.809  10.193   4.456  1.00 40.98           O  
ATOM    439  CB  ALA A  49      65.914  11.401   4.227  1.00 41.38           C  
ATOM    440  N   PHE A  50      69.007  12.052   3.203  1.00 41.05           N  
ATOM    441  CA  PHE A  50      70.053  11.483   2.351  1.00 41.21           C  
ATOM    442  C   PHE A  50      71.399  12.202   2.354  1.00 41.29           C  
ATOM    443  O   PHE A  50      72.343  11.740   1.715  1.00 41.03           O  
ATOM    444  CB  PHE A  50      69.533  11.271   0.928  1.00 41.10           C  
ATOM    445  CG  PHE A  50      68.400  10.294   0.856  1.00 40.99           C  
ATOM    446  CD1 PHE A  50      68.624   8.939   1.051  1.00 40.53           C  
ATOM    447  CD2 PHE A  50      67.106  10.733   0.629  1.00 41.08           C  
ATOM    448  CE1 PHE A  50      67.578   8.035   1.004  1.00 40.62           C  
ATOM    449  CE2 PHE A  50      66.055   9.835   0.583  1.00 40.88           C  
ATOM    450  CZ  PHE A  50      66.291   8.485   0.771  1.00 40.52           C  
ATOM    451  N   PHE A  51      71.487  13.318   3.073  1.00 41.53           N  
ATOM    452  CA  PHE A  51      72.741  14.050   3.212  1.00 41.71           C  
ATOM    453  C   PHE A  51      73.864  13.086   3.588  1.00 41.95           C  
ATOM    454  O   PHE A  51      73.650  12.182   4.394  1.00 42.27           O  
ATOM    455  CB  PHE A  51      72.607  15.153   4.267  1.00 41.63           C  
ATOM    456  CG  PHE A  51      73.786  16.083   4.322  1.00 41.66           C  
ATOM    457  CD1 PHE A  51      73.862  17.179   3.470  1.00 41.35           C  
ATOM    458  CD2 PHE A  51      74.829  15.855   5.215  1.00 41.96           C  
ATOM    459  CE1 PHE A  51      74.954  18.035   3.509  1.00 41.39           C  
ATOM    460  CE2 PHE A  51      75.928  16.704   5.260  1.00 41.49           C  
ATOM    461  CZ  PHE A  51      75.989  17.798   4.406  1.00 41.64           C  
ATOM    462  N   PRO A  52      75.062  13.261   3.002  1.00 42.20           N  
ATOM    463  CA  PRO A  52      75.441  14.282   2.028  1.00 42.31           C  
ATOM    464  C   PRO A  52      75.203  13.868   0.577  1.00 42.50           C  
ATOM    465  O   PRO A  52      75.855  14.391  -0.327  1.00 42.50           O  
ATOM    466  CB  PRO A  52      76.938  14.462   2.296  1.00 42.42           C  
ATOM    467  CG  PRO A  52      77.400  13.123   2.810  1.00 42.29           C  
ATOM    468  CD  PRO A  52      76.195  12.374   3.323  1.00 42.18           C  
ATOM    469  N   GLY A  53      74.284  12.933   0.362  1.00 42.69           N  
ATOM    470  CA  GLY A  53      73.900  12.535  -0.985  1.00 43.00           C  
ATOM    471  C   GLY A  53      72.730  13.359  -1.482  1.00 43.27           C  
ATOM    472  O   GLY A  53      72.044  14.020  -0.701  1.00 43.26           O  
ATOM    473  N   LYS A  54      72.512  13.329  -2.792  1.00 43.61           N  
ATOM    474  CA  LYS A  54      71.323  13.930  -3.382  1.00 44.04           C  
ATOM    475  C   LYS A  54      70.164  12.952  -3.218  1.00 44.29           C  
ATOM    476  O   LYS A  54      70.362  11.827  -2.752  1.00 44.34           O  
ATOM    477  CB  LYS A  54      71.554  14.263  -4.862  1.00 44.05           C  
ATOM    478  CG  LYS A  54      72.732  15.200  -5.115  1.00 44.40           C  
ATOM    479  CD  LYS A  54      72.468  16.155  -6.271  1.00 45.10           C  
ATOM    480  CE  LYS A  54      73.560  17.218  -6.362  1.00 45.63           C  
ATOM    481  NZ  LYS A  54      73.289  18.246  -7.408  1.00 45.27           N  
ATOM    482  N   LEU A  55      68.958  13.383  -3.582  1.00 44.63           N  
ATOM    483  CA  LEU A  55      67.805  12.489  -3.609  1.00 44.93           C  
ATOM    484  C   LEU A  55      68.036  11.362  -4.616  1.00 45.31           C  
ATOM    485  O   LEU A  55      68.337  11.628  -5.783  1.00 45.32           O  
ATOM    486  CB  LEU A  55      66.519  13.247  -3.958  1.00 44.84           C  
ATOM    487  CG  LEU A  55      66.063  14.467  -3.149  1.00 44.86           C  
ATOM    488  CD1 LEU A  55      64.617  14.796  -3.490  1.00 44.27           C  
ATOM    489  CD2 LEU A  55      66.211  14.262  -1.645  1.00 44.89           C  
ATOM    490  N   PRO A  56      67.919  10.100  -4.166  1.00 45.72           N  
ATOM    491  CA  PRO A  56      68.065   8.942  -5.051  1.00 46.06           C  
ATOM    492  C   PRO A  56      66.868   8.767  -5.981  1.00 46.43           C  
ATOM    493  O   PRO A  56      66.900   7.925  -6.879  1.00 46.56           O  
ATOM    494  CB  PRO A  56      68.155   7.767  -4.076  1.00 46.02           C  
ATOM    495  CG  PRO A  56      67.404   8.222  -2.873  1.00 46.14           C  
ATOM    496  CD  PRO A  56      67.647   9.700  -2.773  1.00 45.79           C  
ATOM    497  N   PHE A  57      65.826   9.562  -5.755  1.00 46.96           N  
ATOM    498  CA  PHE A  57      64.615   9.539  -6.571  1.00 47.37           C  
ATOM    499  C   PHE A  57      64.335  10.905  -7.199  1.00 47.77           C  
ATOM    500  O   PHE A  57      64.774  11.930  -6.676  1.00 47.71           O  
ATOM    501  CB  PHE A  57      63.409   9.068  -5.743  1.00 47.24           C  
ATOM    502  CG  PHE A  57      63.332   9.673  -4.368  1.00 47.02           C  
ATOM    503  CD1 PHE A  57      62.842  10.960  -4.182  1.00 46.89           C  
ATOM    504  CD2 PHE A  57      63.730   8.941  -3.255  1.00 46.94           C  
ATOM    505  CE1 PHE A  57      62.763  11.516  -2.909  1.00 46.89           C  
ATOM    506  CE2 PHE A  57      63.653   9.488  -1.977  1.00 46.75           C  
ATOM    507  CZ  PHE A  57      63.168  10.778  -1.804  1.00 46.59           C  
ATOM    508  N   PRO A  58      63.620  10.926  -8.340  1.00 48.24           N  
ATOM    509  CA  PRO A  58      63.242  12.211  -8.921  1.00 48.70           C  
ATOM    510  C   PRO A  58      62.046  12.864  -8.226  1.00 49.15           C  
ATOM    511  O   PRO A  58      61.296  12.195  -7.510  1.00 49.17           O  
ATOM    512  CB  PRO A  58      62.903  11.857 -10.372  1.00 48.61           C  
ATOM    513  CG  PRO A  58      62.504  10.433 -10.343  1.00 48.47           C  
ATOM    514  CD  PRO A  58      63.167   9.786  -9.158  1.00 48.28           C  
ATOM    515  N   VAL A  59      61.896  14.169  -8.441  1.00 49.76           N  
ATOM    516  CA  VAL A  59      60.766  14.943  -7.932  1.00 50.36           C  
ATOM    517  C   VAL A  59      59.794  15.227  -9.074  1.00 50.82           C  
ATOM    518  O   VAL A  59      60.214  15.525 -10.192  1.00 50.97           O  
ATOM    519  CB  VAL A  59      61.254  16.253  -7.266  1.00 50.38           C  
ATOM    520  CG1 VAL A  59      60.241  17.388  -7.406  1.00 50.38           C  
ATOM    521  CG2 VAL A  59      61.595  16.006  -5.808  1.00 50.31           C  
HETATM  522  N   MSE A  60      58.499  15.118  -8.793  1.00 51.42           N  
HETATM  523  CA  MSE A  60      57.475  15.319  -9.813  1.00 52.09           C  
HETATM  524  C   MSE A  60      56.493  16.434  -9.489  1.00 52.29           C  
HETATM  525  O   MSE A  60      56.128  16.636  -8.332  1.00 52.40           O  
HETATM  526  CB  MSE A  60      56.696  14.028 -10.055  1.00 52.24           C  
HETATM  527  CG  MSE A  60      57.251  13.177 -11.174  1.00 53.28           C  
HETATM  528 SE   MSE A  60      55.837  12.618 -12.389  1.00 55.52          SE  
HETATM  529  CE  MSE A  60      55.324  14.366 -13.056  1.00 55.16           C  
ATOM    530  N   HIS A  61      56.064  17.146 -10.528  1.00 52.65           N  
ATOM    531  CA  HIS A  61      54.980  18.113 -10.417  1.00 52.92           C  
ATOM    532  C   HIS A  61      53.931  17.876 -11.500  1.00 53.16           C  
ATOM    533  O   HIS A  61      54.208  18.037 -12.692  1.00 53.18           O  
ATOM    534  CB  HIS A  61      55.509  19.550 -10.478  1.00 52.92           C  
ATOM    535  CG  HIS A  61      54.432  20.592 -10.458  1.00 52.90           C  
ATOM    536  ND1 HIS A  61      54.296  21.541 -11.447  1.00 52.49           N  
ATOM    537  CD2 HIS A  61      53.431  20.821  -9.574  1.00 52.81           C  
ATOM    538  CE1 HIS A  61      53.263  22.317 -11.169  1.00 52.55           C  
ATOM    539  NE2 HIS A  61      52.718  21.900 -10.040  1.00 52.51           N  
ATOM    540  N   VAL A  62      52.735  17.481 -11.068  1.00 53.42           N  
ATOM    541  CA  VAL A  62      51.592  17.317 -11.963  1.00 53.69           C  
ATOM    542  C   VAL A  62      51.041  18.698 -12.307  1.00 53.93           C  
ATOM    543  O   VAL A  62      50.346  19.318 -11.499  1.00 53.96           O  
ATOM    544  CB  VAL A  62      50.486  16.439 -11.331  1.00 53.59           C  
ATOM    545  CG1 VAL A  62      49.333  16.237 -12.302  1.00 53.55           C  
ATOM    546  CG2 VAL A  62      51.050  15.096 -10.905  1.00 53.70           C  
ATOM    547  N   ASP A  63      51.372  19.178 -13.501  1.00 54.26           N  
ATOM    548  CA  ASP A  63      50.977  20.518 -13.923  1.00 54.66           C  
ATOM    549  C   ASP A  63      49.581  20.524 -14.535  1.00 54.93           C  
ATOM    550  O   ASP A  63      49.264  19.720 -15.414  1.00 54.91           O  
ATOM    551  CB  ASP A  63      51.993  21.110 -14.907  1.00 54.66           C  
ATOM    552  CG  ASP A  63      51.941  22.633 -14.972  1.00 54.70           C  
ATOM    553  OD1 ASP A  63      50.939  23.239 -14.533  1.00 54.46           O  
ATOM    554  OD2 ASP A  63      52.917  23.233 -15.474  1.00 55.03           O  
ATOM    555  N   THR A  64      48.760  21.446 -14.045  1.00 55.31           N  
ATOM    556  CA  THR A  64      47.413  21.670 -14.554  1.00 55.74           C  
ATOM    557  C   THR A  64      47.504  22.640 -15.740  1.00 56.02           C  
ATOM    558  O   THR A  64      48.564  22.768 -16.355  1.00 56.16           O  
ATOM    559  CB  THR A  64      46.501  22.228 -13.435  1.00 55.66           C  
ATOM    560  OG1 THR A  64      46.840  21.608 -12.187  1.00 55.90           O  
ATOM    561  CG2 THR A  64      45.054  21.923 -13.731  1.00 55.80           C  
ATOM    562  N   ARG A  65      46.405  23.311 -16.075  1.00 56.32           N  
ATOM    563  CA  ARG A  65      46.439  24.352 -17.097  1.00 56.70           C  
ATOM    564  C   ARG A  65      47.304  25.515 -16.617  1.00 56.92           C  
ATOM    565  O   ARG A  65      48.217  25.952 -17.322  1.00 56.95           O  
ATOM    566  CB  ARG A  65      45.025  24.837 -17.437  1.00 56.67           C  
ATOM    567  N   TRP A  66      47.020  25.988 -15.404  1.00 57.21           N  
ATOM    568  CA  TRP A  66      47.729  27.115 -14.806  1.00 57.47           C  
ATOM    569  C   TRP A  66      47.449  27.230 -13.309  1.00 57.66           C  
ATOM    570  O   TRP A  66      46.305  27.109 -12.867  1.00 57.64           O  
ATOM    571  CB  TRP A  66      47.346  28.426 -15.504  1.00 57.48           C  
ATOM    572  N   LYS A  67      48.511  27.451 -12.541  1.00 57.93           N  
ATOM    573  CA  LYS A  67      48.406  27.837 -11.138  1.00 58.27           C  
ATOM    574  C   LYS A  67      48.938  29.264 -11.000  1.00 58.54           C  
ATOM    575  O   LYS A  67      49.336  29.872 -11.995  1.00 58.54           O  
ATOM    576  CB  LYS A  67      49.197  26.869 -10.255  1.00 58.18           C  
ATOM    577  N   PHE A  68      48.942  29.798  -9.778  1.00 58.95           N  
ATOM    578  CA  PHE A  68      49.461  31.143  -9.510  1.00 59.33           C  
ATOM    579  C   PHE A  68      50.834  31.359 -10.150  1.00 59.67           C  
ATOM    580  O   PHE A  68      51.686  30.468 -10.126  1.00 59.67           O  
ATOM    581  CB  PHE A  68      49.543  31.411  -8.002  1.00 59.31           C  
ATOM    582  CG  PHE A  68      48.207  31.634  -7.340  1.00 59.26           C  
ATOM    583  CD1 PHE A  68      47.625  32.897  -7.323  1.00 59.22           C  
ATOM    584  CD2 PHE A  68      47.545  30.587  -6.709  1.00 59.15           C  
ATOM    585  CE1 PHE A  68      46.398  33.109  -6.704  1.00 59.22           C  
ATOM    586  CE2 PHE A  68      46.316  30.789  -6.089  1.00 59.14           C  
ATOM    587  CZ  PHE A  68      45.743  32.054  -6.086  1.00 59.27           C  
ATOM    588  N   GLN A  69      51.035  32.544 -10.722  1.00 60.13           N  
ATOM    589  CA  GLN A  69      52.278  32.877 -11.424  1.00 60.56           C  
ATOM    590  C   GLN A  69      53.500  32.881 -10.509  1.00 60.93           C  
ATOM    591  O   GLN A  69      54.607  32.554 -10.941  1.00 60.95           O  
ATOM    592  CB  GLN A  69      52.150  34.224 -12.145  1.00 60.51           C  
ATOM    593  CG  GLN A  69      51.311  34.177 -13.416  1.00 60.36           C  
ATOM    594  CD  GLN A  69      51.853  33.201 -14.446  1.00 60.18           C  
ATOM    595  OE1 GLN A  69      53.047  33.191 -14.748  1.00 60.04           O  
ATOM    596  NE2 GLN A  69      50.972  32.371 -14.994  1.00 60.11           N  
ATOM    597  N   GLU A  70      53.287  33.243  -9.247  1.00 61.41           N  
ATOM    598  CA  GLU A  70      54.353  33.274  -8.248  1.00 61.91           C  
ATOM    599  C   GLU A  70      54.804  31.877  -7.815  1.00 62.27           C  
ATOM    600  O   GLU A  70      55.845  31.730  -7.170  1.00 62.30           O  
ATOM    601  CB  GLU A  70      53.922  34.099  -7.032  1.00 61.92           C  
ATOM    602  CG  GLU A  70      53.974  35.606  -7.250  1.00 62.01           C  
ATOM    603  CD  GLU A  70      53.333  36.388  -6.118  1.00 62.11           C  
ATOM    604  OE1 GLU A  70      52.092  36.335  -5.982  1.00 62.12           O  
ATOM    605  OE2 GLU A  70      54.071  37.064  -5.371  1.00 62.17           O  
HETATM  606  N   MSE A  71      54.021  30.859  -8.170  1.00 62.70           N  
HETATM  607  CA  MSE A  71      54.364  29.469  -7.867  1.00 63.15           C  
HETATM  608  C   MSE A  71      55.337  28.901  -8.897  1.00 63.35           C  
HETATM  609  O   MSE A  71      56.331  28.270  -8.537  1.00 63.34           O  
HETATM  610  CB  MSE A  71      53.107  28.596  -7.783  1.00 63.19           C  
HETATM  611  CG  MSE A  71      52.126  29.011  -6.698  1.00 63.63           C  
HETATM  612 SE   MSE A  71      50.491  27.941  -6.683  1.00 65.06          SE  
HETATM  613  CE  MSE A  71      51.118  26.407  -5.658  1.00 64.56           C  
ATOM    614  N   TYR A  72      55.047  29.132 -10.177  1.00 63.71           N  
ATOM    615  CA  TYR A  72      55.924  28.701 -11.262  1.00 64.08           C  
ATOM    616  C   TYR A  72      57.327  29.281 -11.110  1.00 64.41           C  
ATOM    617  O   TYR A  72      58.315  28.562 -11.254  1.00 64.47           O  
ATOM    618  CB  TYR A  72      55.348  29.097 -12.625  1.00 64.02           C  
ATOM    619  CG  TYR A  72      54.169  28.267 -13.077  1.00 63.97           C  
ATOM    620  CD1 TYR A  72      54.322  26.921 -13.401  1.00 63.67           C  
ATOM    621  CD2 TYR A  72      52.903  28.835 -13.203  1.00 63.91           C  
ATOM    622  CE1 TYR A  72      53.243  26.158 -13.824  1.00 63.64           C  
ATOM    623  CE2 TYR A  72      51.818  28.081 -13.627  1.00 63.73           C  
ATOM    624  CZ  TYR A  72      51.994  26.744 -13.936  1.00 63.71           C  
ATOM    625  OH  TYR A  72      50.921  25.992 -14.356  1.00 63.66           O  
ATOM    626  N   ARG A  73      57.398  30.576 -10.807  1.00 64.84           N  
ATOM    627  CA  ARG A  73      58.667  31.289 -10.657  1.00 65.25           C  
ATOM    628  C   ARG A  73      59.457  30.796  -9.444  1.00 65.53           C  
ATOM    629  O   ARG A  73      60.686  30.703  -9.492  1.00 65.53           O  
ATOM    630  CB  ARG A  73      58.417  32.797 -10.560  1.00 65.22           C  
ATOM    631  CG  ARG A  73      59.442  33.650 -11.297  1.00 65.35           C  
ATOM    632  CD  ARG A  73      58.980  35.097 -11.410  1.00 65.31           C  
ATOM    633  NE  ARG A  73      59.616  35.801 -12.523  1.00 65.26           N  
ATOM    634  CZ  ARG A  73      60.759  36.479 -12.442  1.00 65.29           C  
ATOM    635  NH1 ARG A  73      61.420  36.551 -11.293  1.00 65.23           N  
ATOM    636  NH2 ARG A  73      61.246  37.084 -13.516  1.00 65.27           N  
ATOM    637  N   PHE A  74      58.744  30.479  -8.365  1.00 65.93           N  
ATOM    638  CA  PHE A  74      59.353  29.922  -7.160  1.00 66.34           C  
ATOM    639  C   PHE A  74      59.946  28.538  -7.429  1.00 66.66           C  
ATOM    640  O   PHE A  74      61.097  28.272  -7.078  1.00 66.76           O  
ATOM    641  CB  PHE A  74      58.335  29.854  -6.014  1.00 66.27           C  
ATOM    642  CG  PHE A  74      58.891  29.287  -4.736  1.00 66.26           C  
ATOM    643  CD1 PHE A  74      59.551  30.103  -3.826  1.00 66.20           C  
ATOM    644  CD2 PHE A  74      58.754  27.935  -4.442  1.00 66.36           C  
ATOM    645  CE1 PHE A  74      60.070  29.582  -2.646  1.00 66.14           C  
ATOM    646  CE2 PHE A  74      59.270  27.405  -3.266  1.00 66.30           C  
ATOM    647  CZ  PHE A  74      59.929  28.230  -2.367  1.00 66.16           C  
ATOM    648  N   ARG A  75      59.153  27.672  -8.056  1.00 66.97           N  
ATOM    649  CA  ARG A  75      59.567  26.303  -8.354  1.00 67.30           C  
ATOM    650  C   ARG A  75      60.681  26.225  -9.398  1.00 67.59           C  
ATOM    651  O   ARG A  75      61.582  25.393  -9.280  1.00 67.69           O  
ATOM    652  CB  ARG A  75      58.352  25.454  -8.744  1.00 67.27           C  
ATOM    653  CG  ARG A  75      58.590  24.349  -9.762  1.00 67.16           C  
ATOM    654  CD  ARG A  75      58.074  24.779 -11.123  1.00 67.23           C  
ATOM    655  NE  ARG A  75      58.025  23.678 -12.079  1.00 67.14           N  
ATOM    656  CZ  ARG A  75      57.491  23.762 -13.295  1.00 67.01           C  
ATOM    657  NH1 ARG A  75      56.952  24.899 -13.719  1.00 66.71           N  
ATOM    658  NH2 ARG A  75      57.496  22.702 -14.089  1.00 67.10           N  
ATOM    659  N   ASP A  76      60.619  27.090 -10.407  1.00 67.92           N  
ATOM    660  CA  ASP A  76      61.664  27.157 -11.429  1.00 68.30           C  
ATOM    661  C   ASP A  76      63.027  27.482 -10.821  1.00 68.51           C  
ATOM    662  O   ASP A  76      64.019  26.818 -11.126  1.00 68.58           O  
ATOM    663  CB  ASP A  76      61.305  28.173 -12.521  1.00 68.27           C  
ATOM    664  CG  ASP A  76      60.246  27.655 -13.484  1.00 68.32           C  
ATOM    665  OD1 ASP A  76      59.993  28.330 -14.504  1.00 68.39           O  
ATOM    666  OD2 ASP A  76      59.665  26.578 -13.229  1.00 68.28           O  
ATOM    667  N   GLN A  77      63.063  28.493  -9.954  1.00 68.75           N  
ATOM    668  CA  GLN A  77      64.290  28.886  -9.264  1.00 69.01           C  
ATOM    669  C   GLN A  77      64.769  27.805  -8.299  1.00 69.20           C  
ATOM    670  O   GLN A  77      65.971  27.626  -8.108  1.00 69.22           O  
ATOM    671  CB  GLN A  77      64.106  30.216  -8.528  1.00 68.98           C  
ATOM    672  CG  GLN A  77      64.150  31.442  -9.435  1.00 69.17           C  
ATOM    673  CD  GLN A  77      64.398  32.740  -8.682  1.00 69.23           C  
ATOM    674  OE1 GLN A  77      63.814  32.985  -7.626  1.00 69.34           O  
ATOM    675  NE2 GLN A  77      65.262  33.585  -9.234  1.00 69.04           N  
HETATM  676  N   MSE A  78      63.821  27.082  -7.709  1.00 69.46           N  
HETATM  677  CA  MSE A  78      64.114  25.996  -6.774  1.00 69.72           C  
HETATM  678  C   MSE A  78      64.902  24.852  -7.408  1.00 69.81           C  
HETATM  679  O   MSE A  78      65.778  24.269  -6.768  1.00 69.83           O  
HETATM  680  CB  MSE A  78      62.817  25.462  -6.166  1.00 69.77           C  
HETATM  681  CG  MSE A  78      62.349  26.225  -4.942  1.00 70.02           C  
HETATM  682 SE   MSE A  78      62.747  25.273  -3.294  0.50 70.85          SE  
HETATM  683  CE  MSE A  78      61.366  23.911  -3.406  1.00 70.22           C  
ATOM    684  N   VAL A  79      64.588  24.537  -8.662  1.00 69.98           N  
ATOM    685  CA  VAL A  79      65.267  23.466  -9.392  1.00 70.14           C  
ATOM    686  C   VAL A  79      66.719  23.841  -9.701  1.00 70.21           C  
ATOM    687  O   VAL A  79      67.634  23.046  -9.468  1.00 70.22           O  
ATOM    688  CB  VAL A  79      64.515  23.090 -10.693  1.00 70.19           C  
ATOM    689  CG1 VAL A  79      65.193  21.921 -11.399  1.00 70.21           C  
ATOM    690  CG2 VAL A  79      63.065  22.746 -10.391  1.00 70.14           C  
ATOM    691  N   GLU A  80      66.920  25.055 -10.209  1.00 70.24           N  
ATOM    692  CA  GLU A  80      68.255  25.554 -10.548  1.00 70.28           C  
ATOM    693  C   GLU A  80      69.145  25.766  -9.323  1.00 70.31           C  
ATOM    694  O   GLU A  80      70.360  25.574  -9.396  1.00 70.35           O  
ATOM    695  CB  GLU A  80      68.163  26.850 -11.360  1.00 70.25           C  
ATOM    696  CG  GLU A  80      67.906  26.644 -12.848  1.00 70.30           C  
ATOM    697  CD  GLU A  80      68.125  27.906 -13.666  1.00 70.45           C  
ATOM    698  OE1 GLU A  80      67.528  28.953 -13.335  1.00 70.64           O  
ATOM    699  OE2 GLU A  80      68.892  27.852 -14.651  1.00 70.27           O  
ATOM    700  N   GLU A  81      68.538  26.158  -8.205  1.00 70.34           N  
ATOM    701  CA  GLU A  81      69.276  26.455  -6.975  1.00 70.36           C  
ATOM    702  C   GLU A  81      69.566  25.238  -6.091  1.00 70.29           C  
ATOM    703  O   GLU A  81      70.161  25.376  -5.021  1.00 70.31           O  
ATOM    704  CB  GLU A  81      68.559  27.542  -6.163  1.00 70.40           C  
ATOM    705  CG  GLU A  81      69.170  28.936  -6.285  1.00 70.64           C  
ATOM    706  CD  GLU A  81      69.035  29.539  -7.675  1.00 71.04           C  
ATOM    707  OE1 GLU A  81      67.898  29.639  -8.182  1.00 71.30           O  
ATOM    708  OE2 GLU A  81      70.071  29.931  -8.256  1.00 71.08           O  
HETATM  709  N   MSE A  82      69.155  24.053  -6.535  1.00 70.24           N  
HETATM  710  CA  MSE A  82      69.394  22.824  -5.774  1.00 70.21           C  
HETATM  711  C   MSE A  82      69.931  21.675  -6.627  1.00 70.18           C  
HETATM  712  O   MSE A  82      70.148  20.572  -6.120  1.00 70.14           O  
HETATM  713  CB  MSE A  82      68.123  22.384  -5.040  1.00 70.16           C  
HETATM  714  CG  MSE A  82      67.784  23.221  -3.816  1.00 70.14           C  
HETATM  715 SE   MSE A  82      66.325  22.467  -2.767  0.50 70.34          SE  
HETATM  716  CE  MSE A  82      64.903  22.585  -4.073  1.00 70.41           C  
ATOM    717  N   GLY A  83      70.149  21.943  -7.913  1.00 70.17           N  
ATOM    718  CA  GLY A  83      70.562  20.917  -8.870  1.00 70.07           C  
ATOM    719  C   GLY A  83      69.603  19.741  -8.868  1.00 70.02           C  
ATOM    720  O   GLY A  83      70.026  18.584  -8.904  1.00 70.04           O  
ATOM    721  N   LEU A  84      68.309  20.046  -8.815  1.00 69.94           N  
ATOM    722  CA  LEU A  84      67.275  19.027  -8.671  1.00 69.80           C  
ATOM    723  C   LEU A  84      66.810  18.427  -9.991  1.00 69.69           C  
ATOM    724  O   LEU A  84      66.949  19.033 -11.056  1.00 69.67           O  
ATOM    725  CB  LEU A  84      66.070  19.572  -7.898  1.00 69.80           C  
ATOM    726  CG  LEU A  84      65.982  19.323  -6.389  1.00 69.86           C  
ATOM    727  CD1 LEU A  84      64.555  19.568  -5.921  1.00 69.79           C  
ATOM    728  CD2 LEU A  84      66.419  17.909  -6.014  1.00 69.80           C  
ATOM    729  N   ASP A  85      66.254  17.222  -9.891  1.00 69.53           N  
ATOM    730  CA  ASP A  85      65.651  16.525 -11.016  1.00 69.36           C  
ATOM    731  C   ASP A  85      64.132  16.652 -10.909  1.00 69.17           C  
ATOM    732  O   ASP A  85      63.485  15.880 -10.196  1.00 69.10           O  
ATOM    733  CB  ASP A  85      66.090  15.054 -11.007  1.00 69.38           C  
ATOM    734  CG  ASP A  85      65.516  14.251 -12.165  1.00 69.46           C  
ATOM    735  OD1 ASP A  85      65.539  13.005 -12.075  1.00 69.45           O  
ATOM    736  OD2 ASP A  85      65.047  14.847 -13.159  1.00 69.58           O  
ATOM    737  N   LEU A  86      63.572  17.640 -11.605  1.00 68.96           N  
ATOM    738  CA  LEU A  86      62.127  17.858 -11.592  1.00 68.80           C  
ATOM    739  C   LEU A  86      61.469  17.411 -12.890  1.00 68.60           C  
ATOM    740  O   LEU A  86      61.861  17.833 -13.977  1.00 68.57           O  
ATOM    741  CB  LEU A  86      61.776  19.319 -11.281  1.00 68.84           C  
ATOM    742  CG  LEU A  86      60.303  19.607 -10.952  1.00 69.03           C  
ATOM    743  CD1 LEU A  86      60.166  20.587  -9.795  1.00 69.45           C  
ATOM    744  CD2 LEU A  86      59.516  20.093 -12.164  1.00 69.03           C  
ATOM    745  N   ILE A  87      60.464  16.553 -12.754  1.00 68.41           N  
ATOM    746  CA  ILE A  87      59.654  16.121 -13.882  1.00 68.26           C  
ATOM    747  C   ILE A  87      58.319  16.860 -13.848  1.00 68.24           C  
ATOM    748  O   ILE A  87      57.640  16.894 -12.820  1.00 68.27           O  
ATOM    749  CB  ILE A  87      59.429  14.590 -13.872  1.00 68.20           C  
ATOM    750  CG1 ILE A  87      60.772  13.853 -13.877  1.00 68.03           C  
ATOM    751  CG2 ILE A  87      58.574  14.157 -15.063  1.00 68.21           C  
ATOM    752  CD1 ILE A  87      60.679  12.385 -13.514  1.00 67.88           C  
ATOM    753  N   THR A  88      57.971  17.476 -14.972  1.00 68.18           N  
ATOM    754  CA  THR A  88      56.680  18.128 -15.138  1.00 68.17           C  
ATOM    755  C   THR A  88      55.788  17.215 -15.973  1.00 68.18           C  
ATOM    756  O   THR A  88      56.268  16.530 -16.877  1.00 68.16           O  
ATOM    757  CB  THR A  88      56.839  19.501 -15.822  1.00 68.18           C  
ATOM    758  OG1 THR A  88      57.894  20.232 -15.187  1.00 68.13           O  
ATOM    759  CG2 THR A  88      55.553  20.312 -15.738  1.00 68.14           C  
ATOM    760  N   HIS A  89      54.496  17.194 -15.658  1.00 68.20           N  
ATOM    761  CA  HIS A  89      53.551  16.372 -16.405  1.00 68.27           C  
ATOM    762  C   HIS A  89      52.239  17.095 -16.691  1.00 68.35           C  
ATOM    763  O   HIS A  89      51.641  17.700 -15.799  1.00 68.37           O  
ATOM    764  CB  HIS A  89      53.286  15.056 -15.676  1.00 68.26           C  
ATOM    765  CG  HIS A  89      52.560  14.045 -16.505  1.00 68.32           C  
ATOM    766  ND1 HIS A  89      51.184  13.984 -16.565  1.00 68.35           N  
ATOM    767  CD2 HIS A  89      53.016  13.061 -17.314  1.00 68.40           C  
ATOM    768  CE1 HIS A  89      50.825  13.004 -17.374  1.00 68.50           C  
ATOM    769  NE2 HIS A  89      51.919  12.427 -17.841  1.00 68.52           N  
ATOM    770  N   ILE A  90      51.803  17.013 -17.946  1.00 68.41           N  
ATOM    771  CA  ILE A  90      50.575  17.648 -18.421  1.00 68.45           C  
ATOM    772  C   ILE A  90      50.092  16.965 -19.703  1.00 68.50           C  
ATOM    773  O   ILE A  90      50.881  16.732 -20.622  1.00 68.59           O  
ATOM    774  CB  ILE A  90      50.761  19.185 -18.641  1.00 68.46           C  
ATOM    775  CG1 ILE A  90      49.612  19.787 -19.463  1.00 68.50           C  
ATOM    776  CG2 ILE A  90      52.102  19.496 -19.307  1.00 68.42           C  
ATOM    777  CD1 ILE A  90      48.323  20.004 -18.689  1.00 68.65           C  
ATOM    778  N   ASN A  91      48.803  16.636 -19.751  1.00 68.51           N  
ATOM    779  CA  ASN A  91      48.194  16.051 -20.946  1.00 68.48           C  
ATOM    780  C   ASN A  91      46.934  16.791 -21.385  1.00 68.48           C  
ATOM    781  O   ASN A  91      46.498  16.677 -22.533  1.00 68.47           O  
ATOM    782  CB  ASN A  91      47.888  14.565 -20.730  1.00 68.47           C  
ATOM    783  CG  ASN A  91      46.865  14.329 -19.632  1.00 68.52           C  
ATOM    784  OD1 ASN A  91      46.964  14.884 -18.537  1.00 68.54           O  
ATOM    785  ND2 ASN A  91      45.877  13.489 -19.922  1.00 68.41           N  
ATOM    786  N   SER A 106      35.938  23.503 -10.169  1.00 65.72           N  
ATOM    787  CA  SER A 106      37.069  22.588 -10.039  1.00 65.75           C  
ATOM    788  C   SER A 106      36.619  21.132  -9.907  1.00 65.72           C  
ATOM    789  O   SER A 106      37.338  20.294  -9.357  1.00 65.67           O  
ATOM    790  CB  SER A 106      37.953  22.993  -8.854  1.00 65.78           C  
ATOM    791  OG  SER A 106      38.561  24.255  -9.074  1.00 65.78           O  
ATOM    792  N   ALA A 107      35.427  20.839 -10.423  1.00 65.66           N  
ATOM    793  CA  ALA A 107      34.877  19.486 -10.393  1.00 65.59           C  
ATOM    794  C   ALA A 107      35.464  18.630 -11.514  1.00 65.51           C  
ATOM    795  O   ALA A 107      36.036  17.568 -11.260  1.00 65.46           O  
ATOM    796  CB  ALA A 107      33.355  19.527 -10.484  1.00 65.61           C  
ATOM    797  N   LYS A 108      35.318  19.107 -12.748  1.00 65.44           N  
ATOM    798  CA  LYS A 108      35.858  18.434 -13.927  1.00 65.33           C  
ATOM    799  C   LYS A 108      37.368  18.626 -13.999  1.00 65.23           C  
ATOM    800  O   LYS A 108      38.121  17.663 -14.146  1.00 65.24           O  
ATOM    801  CB  LYS A 108      35.229  19.002 -15.202  1.00 65.35           C  
ATOM    802  CG  LYS A 108      33.727  18.799 -15.346  1.00 65.20           C  
ATOM    803  CD  LYS A 108      33.181  19.582 -16.535  1.00 65.09           C  
ATOM    804  CE  LYS A 108      33.694  19.036 -17.863  1.00 64.92           C  
ATOM    805  NZ  LYS A 108      33.367  19.938 -19.001  1.00 65.10           N  
ATOM    806  N   HIS A 109      37.784  19.884 -13.884  1.00 65.12           N  
ATOM    807  CA  HIS A 109      39.175  20.307 -14.020  1.00 65.02           C  
ATOM    808  C   HIS A 109      40.156  19.439 -13.233  1.00 65.00           C  
ATOM    809  O   HIS A 109      41.080  18.864 -13.811  1.00 65.02           O  
ATOM    810  CB  HIS A 109      39.294  21.773 -13.596  1.00 64.99           C  
ATOM    811  CG  HIS A 109      40.623  22.388 -13.893  1.00 64.93           C  
ATOM    812  ND1 HIS A 109      41.100  22.549 -15.177  1.00 64.97           N  
ATOM    813  CD2 HIS A 109      41.567  22.909 -13.074  1.00 64.80           C  
ATOM    814  CE1 HIS A 109      42.284  23.131 -15.135  1.00 65.02           C  
ATOM    815  NE2 HIS A 109      42.589  23.362 -13.870  1.00 64.91           N  
ATOM    816  N   THR A 110      39.935  19.338 -11.923  1.00 64.90           N  
ATOM    817  CA  THR A 110      40.819  18.599 -11.021  1.00 64.81           C  
ATOM    818  C   THR A 110      40.882  17.112 -11.377  1.00 64.71           C  
ATOM    819  O   THR A 110      41.944  16.491 -11.294  1.00 64.73           O  
ATOM    820  CB  THR A 110      40.378  18.755  -9.545  1.00 64.85           C  
ATOM    821  OG1 THR A 110      39.999  20.114  -9.292  1.00 64.98           O  
ATOM    822  CG2 THR A 110      41.500  18.363  -8.590  1.00 64.77           C  
ATOM    823  N   ASP A 111      39.745  16.556 -11.785  1.00 64.52           N  
ATOM    824  CA  ASP A 111      39.637  15.137 -12.109  1.00 64.32           C  
ATOM    825  C   ASP A 111      40.498  14.746 -13.308  1.00 64.14           C  
ATOM    826  O   ASP A 111      41.244  13.767 -13.250  1.00 64.10           O  
ATOM    827  CB  ASP A 111      38.170  14.763 -12.356  1.00 64.37           C  
ATOM    828  CG  ASP A 111      37.960  13.266 -12.513  1.00 64.44           C  
ATOM    829  OD1 ASP A 111      36.967  12.878 -13.167  1.00 64.58           O  
ATOM    830  OD2 ASP A 111      38.774  12.477 -11.987  1.00 64.50           O  
ATOM    831  N   ILE A 112      40.399  15.520 -14.385  1.00 63.91           N  
ATOM    832  CA  ILE A 112      41.090  15.200 -15.632  1.00 63.68           C  
ATOM    833  C   ILE A 112      42.575  15.559 -15.571  1.00 63.55           C  
ATOM    834  O   ILE A 112      43.421  14.817 -16.072  1.00 63.49           O  
ATOM    835  CB  ILE A 112      40.431  15.892 -16.852  1.00 63.65           C  
ATOM    836  CG1 ILE A 112      38.903  15.881 -16.724  1.00 63.66           C  
ATOM    837  CG2 ILE A 112      40.859  15.210 -18.148  1.00 63.59           C  
ATOM    838  CD1 ILE A 112      38.200  16.984 -17.498  1.00 63.44           C  
HETATM  839  N   MSE A 113      42.886  16.692 -14.948  1.00 63.37           N  
HETATM  840  CA  MSE A 113      44.247  17.225 -14.960  1.00 63.24           C  
HETATM  841  C   MSE A 113      45.131  16.659 -13.851  1.00 62.89           C  
HETATM  842  O   MSE A 113      46.252  16.222 -14.116  1.00 62.87           O  
HETATM  843  CB  MSE A 113      44.229  18.754 -14.903  1.00 63.41           C  
HETATM  844  CG  MSE A 113      43.532  19.432 -16.078  1.00 64.15           C  
HETATM  845 SE   MSE A 113      44.474  19.224 -17.776  1.00 66.07          SE  
HETATM  846  CE  MSE A 113      43.515  17.693 -18.507  1.00 65.47           C  
ATOM    847  N   LYS A 114      44.632  16.674 -12.618  1.00 62.48           N  
ATOM    848  CA  LYS A 114      45.389  16.152 -11.483  1.00 62.07           C  
ATOM    849  C   LYS A 114      45.297  14.632 -11.382  1.00 61.82           C  
ATOM    850  O   LYS A 114      46.299  13.937 -11.561  1.00 61.77           O  
ATOM    851  CB  LYS A 114      44.945  16.801 -10.168  1.00 62.07           C  
ATOM    852  CG  LYS A 114      45.678  18.086  -9.818  1.00 61.86           C  
ATOM    853  CD  LYS A 114      45.513  18.419  -8.344  1.00 61.41           C  
ATOM    854  CE  LYS A 114      46.491  19.494  -7.912  1.00 61.07           C  
ATOM    855  NZ  LYS A 114      46.434  19.742  -6.446  1.00 60.71           N  
ATOM    856  N   THR A 115      44.095  14.127 -11.108  1.00 61.48           N  
ATOM    857  CA  THR A 115      43.880  12.707 -10.827  1.00 61.13           C  
ATOM    858  C   THR A 115      44.356  11.809 -11.967  1.00 60.85           C  
ATOM    859  O   THR A 115      45.106  10.861 -11.739  1.00 60.80           O  
ATOM    860  CB  THR A 115      42.401  12.399 -10.509  1.00 61.17           C  
ATOM    861  OG1 THR A 115      41.837  13.472  -9.745  1.00 61.24           O  
ATOM    862  CG2 THR A 115      42.279  11.102  -9.722  1.00 61.23           C  
ATOM    863  N   GLU A 116      43.924  12.117 -13.186  1.00 60.48           N  
ATOM    864  CA  GLU A 116      44.338  11.350 -14.358  1.00 60.16           C  
ATOM    865  C   GLU A 116      45.787  11.632 -14.736  1.00 59.82           C  
ATOM    866  O   GLU A 116      46.510  10.724 -15.148  1.00 59.80           O  
ATOM    867  CB  GLU A 116      43.410  11.614 -15.549  1.00 60.21           C  
ATOM    868  CG  GLU A 116      42.040  10.955 -15.437  1.00 60.42           C  
ATOM    869  CD  GLU A 116      42.124   9.457 -15.197  1.00 60.70           C  
ATOM    870  OE1 GLU A 116      42.843   8.765 -15.950  1.00 60.45           O  
ATOM    871  OE2 GLU A 116      41.468   8.970 -14.251  1.00 60.95           O  
ATOM    872  N   GLY A 117      46.199  12.890 -14.592  1.00 59.41           N  
ATOM    873  CA  GLY A 117      47.563  13.309 -14.903  1.00 58.94           C  
ATOM    874  C   GLY A 117      48.600  12.582 -14.068  1.00 58.62           C  
ATOM    875  O   GLY A 117      49.572  12.048 -14.606  1.00 58.58           O  
ATOM    876  N   LEU A 118      48.381  12.560 -12.755  1.00 58.24           N  
ATOM    877  CA  LEU A 118      49.247  11.848 -11.818  1.00 57.84           C  
ATOM    878  C   LEU A 118      49.267  10.350 -12.114  1.00 57.54           C  
ATOM    879  O   LEU A 118      50.323   9.716 -12.089  1.00 57.39           O  
ATOM    880  CB  LEU A 118      48.793  12.103 -10.375  1.00 57.89           C  
ATOM    881  CG  LEU A 118      49.523  11.387  -9.232  1.00 57.87           C  
ATOM    882  CD1 LEU A 118      51.005  11.745  -9.214  1.00 57.75           C  
ATOM    883  CD2 LEU A 118      48.864  11.700  -7.893  1.00 57.77           C  
ATOM    884  N   LYS A 119      48.085   9.806 -12.398  1.00 57.22           N  
ATOM    885  CA  LYS A 119      47.909   8.405 -12.766  1.00 56.95           C  
ATOM    886  C   LYS A 119      48.725   8.061 -14.010  1.00 56.63           C  
ATOM    887  O   LYS A 119      49.390   7.025 -14.058  1.00 56.64           O  
ATOM    888  CB  LYS A 119      46.424   8.128 -13.025  1.00 57.05           C  
ATOM    889  CG  LYS A 119      46.022   6.661 -12.985  1.00 57.30           C  
ATOM    890  CD  LYS A 119      44.581   6.454 -13.455  1.00 57.50           C  
ATOM    891  CE  LYS A 119      43.557   7.036 -12.479  1.00 57.65           C  
ATOM    892  NZ  LYS A 119      43.620   6.410 -11.127  1.00 57.33           N  
ATOM    893  N   GLN A 120      48.669   8.945 -15.003  1.00 56.20           N  
ATOM    894  CA  GLN A 120      49.371   8.765 -16.271  1.00 55.80           C  
ATOM    895  C   GLN A 120      50.878   8.949 -16.112  1.00 55.48           C  
ATOM    896  O   GLN A 120      51.667   8.264 -16.766  1.00 55.47           O  
ATOM    897  CB  GLN A 120      48.824   9.745 -17.312  1.00 55.83           C  
ATOM    898  CG  GLN A 120      49.263   9.474 -18.745  1.00 55.83           C  
ATOM    899  CD  GLN A 120      48.898  10.603 -19.692  1.00 55.94           C  
ATOM    900  OE1 GLN A 120      48.694  11.741 -19.270  1.00 55.89           O  
ATOM    901  NE2 GLN A 120      48.819  10.292 -20.981  1.00 55.76           N  
ATOM    902  N   ALA A 121      51.267   9.877 -15.241  1.00 55.09           N  
ATOM    903  CA  ALA A 121      52.675  10.157 -14.973  1.00 54.76           C  
ATOM    904  C   ALA A 121      53.399   8.969 -14.335  1.00 54.49           C  
ATOM    905  O   ALA A 121      54.552   8.690 -14.666  1.00 54.41           O  
ATOM    906  CB  ALA A 121      52.812  11.395 -14.101  1.00 54.79           C  
ATOM    907  N   LEU A 122      52.713   8.275 -13.427  1.00 54.12           N  
ATOM    908  CA  LEU A 122      53.280   7.112 -12.742  1.00 53.74           C  
ATOM    909  C   LEU A 122      53.490   5.927 -13.684  1.00 53.50           C  
ATOM    910  O   LEU A 122      54.441   5.161 -13.517  1.00 53.49           O  
ATOM    911  CB  LEU A 122      52.406   6.698 -11.550  1.00 53.75           C  
ATOM    912  CG  LEU A 122      52.329   7.614 -10.322  1.00 53.50           C  
ATOM    913  CD1 LEU A 122      51.179   7.196  -9.415  1.00 53.12           C  
ATOM    914  CD2 LEU A 122      53.641   7.646  -9.546  1.00 53.09           C  
ATOM    915  N   ASP A 123      52.605   5.786 -14.670  1.00 53.13           N  
ATOM    916  CA  ASP A 123      52.691   4.705 -15.652  1.00 52.83           C  
ATOM    917  C   ASP A 123      53.804   4.918 -16.672  1.00 52.58           C  
ATOM    918  O   ASP A 123      54.500   3.971 -17.043  1.00 52.56           O  
ATOM    919  CB  ASP A 123      51.356   4.526 -16.381  1.00 52.86           C  
ATOM    920  CG  ASP A 123      50.342   3.751 -15.564  1.00 52.93           C  
ATOM    921  OD1 ASP A 123      49.159   4.145 -15.572  1.00 53.10           O  
ATOM    922  OD2 ASP A 123      50.720   2.750 -14.920  1.00 53.08           O  
ATOM    923  N   LYS A 124      53.960   6.161 -17.122  1.00 52.22           N  
ATOM    924  CA  LYS A 124      54.948   6.509 -18.141  1.00 51.90           C  
ATOM    925  C   LYS A 124      56.380   6.218 -17.690  1.00 51.56           C  
ATOM    926  O   LYS A 124      57.217   5.811 -18.497  1.00 51.54           O  
ATOM    927  CB  LYS A 124      54.803   7.980 -18.554  1.00 51.99           C  
ATOM    928  CG  LYS A 124      55.543   8.345 -19.840  1.00 52.26           C  
ATOM    929  CD  LYS A 124      55.086   9.679 -20.423  1.00 52.72           C  
ATOM    930  CE  LYS A 124      55.869  10.856 -19.855  1.00 52.78           C  
ATOM    931  NZ  LYS A 124      55.694  12.075 -20.693  1.00 52.70           N  
ATOM    932  N   HIS A 125      56.647   6.411 -16.402  1.00 51.13           N  
ATOM    933  CA  HIS A 125      57.996   6.255 -15.863  1.00 50.71           C  
ATOM    934  C   HIS A 125      58.233   4.905 -15.183  1.00 50.39           C  
ATOM    935  O   HIS A 125      59.375   4.457 -15.073  1.00 50.33           O  
ATOM    936  CB  HIS A 125      58.318   7.392 -14.894  1.00 50.68           C  
ATOM    937  CG  HIS A 125      58.214   8.757 -15.501  1.00 50.65           C  
ATOM    938  ND1 HIS A 125      59.299   9.418 -16.037  1.00 50.68           N  
ATOM    939  CD2 HIS A 125      57.157   9.589 -15.650  1.00 50.58           C  
ATOM    940  CE1 HIS A 125      58.913  10.595 -16.494  1.00 50.62           C  
ATOM    941  NE2 HIS A 125      57.618  10.724 -16.271  1.00 50.74           N  
ATOM    942  N   GLY A 126      57.157   4.269 -14.728  1.00 50.07           N  
ATOM    943  CA  GLY A 126      57.242   2.955 -14.088  1.00 49.68           C  
ATOM    944  C   GLY A 126      57.549   3.010 -12.604  1.00 49.39           C  
ATOM    945  O   GLY A 126      58.193   2.109 -12.061  1.00 49.36           O  
ATOM    946  N   PHE A 127      57.082   4.067 -11.946  1.00 49.06           N  
ATOM    947  CA  PHE A 127      57.277   4.246 -10.512  1.00 48.76           C  
ATOM    948  C   PHE A 127      56.457   3.252  -9.695  1.00 48.60           C  
ATOM    949  O   PHE A 127      55.292   2.995 -10.006  1.00 48.61           O  
ATOM    950  CB  PHE A 127      56.914   5.674 -10.097  1.00 48.72           C  
ATOM    951  CG  PHE A 127      57.759   6.737 -10.745  1.00 48.59           C  
ATOM    952  CD1 PHE A 127      59.148   6.694 -10.661  1.00 48.47           C  
ATOM    953  CD2 PHE A 127      57.161   7.799 -11.413  1.00 48.27           C  
ATOM    954  CE1 PHE A 127      59.930   7.679 -11.249  1.00 48.14           C  
ATOM    955  CE2 PHE A 127      57.933   8.796 -11.995  1.00 48.26           C  
ATOM    956  CZ  PHE A 127      59.323   8.733 -11.917  1.00 48.34           C  
ATOM    957  N   ASP A 128      57.067   2.699  -8.651  1.00 48.34           N  
ATOM    958  CA  ASP A 128      56.367   1.774  -7.759  1.00 48.17           C  
ATOM    959  C   ASP A 128      56.070   2.354  -6.368  1.00 47.99           C  
ATOM    960  O   ASP A 128      55.400   1.718  -5.551  1.00 47.91           O  
ATOM    961  CB  ASP A 128      57.102   0.427  -7.670  1.00 48.20           C  
ATOM    962  CG  ASP A 128      58.552   0.560  -7.219  1.00 48.58           C  
ATOM    963  OD1 ASP A 128      59.051   1.696  -7.046  1.00 48.88           O  
ATOM    964  OD2 ASP A 128      59.199  -0.494  -7.038  1.00 48.71           O  
ATOM    965  N   ALA A 129      56.556   3.566  -6.110  1.00 47.76           N  
ATOM    966  CA  ALA A 129      56.292   4.259  -4.852  1.00 47.63           C  
ATOM    967  C   ALA A 129      56.210   5.765  -5.071  1.00 47.54           C  
ATOM    968  O   ALA A 129      56.981   6.328  -5.851  1.00 47.45           O  
ATOM    969  CB  ALA A 129      57.362   3.929  -3.827  1.00 47.67           C  
ATOM    970  N   ALA A 130      55.275   6.411  -4.378  1.00 47.31           N  
ATOM    971  CA  ALA A 130      55.030   7.839  -4.570  1.00 47.13           C  
ATOM    972  C   ALA A 130      54.820   8.574  -3.251  1.00 46.97           C  
ATOM    973  O   ALA A 130      53.910   8.251  -2.487  1.00 46.94           O  
ATOM    974  CB  ALA A 130      53.845   8.056  -5.506  1.00 47.03           C  
ATOM    975  N   PHE A 131      55.670   9.566  -2.996  1.00 46.77           N  
ATOM    976  CA  PHE A 131      55.603  10.353  -1.770  1.00 46.64           C  
ATOM    977  C   PHE A 131      54.585  11.479  -1.880  1.00 46.61           C  
ATOM    978  O   PHE A 131      54.740  12.384  -2.696  1.00 46.87           O  
ATOM    979  CB  PHE A 131      56.972  10.941  -1.423  1.00 46.62           C  
ATOM    980  CG  PHE A 131      57.983   9.921  -0.987  1.00 46.45           C  
ATOM    981  CD1 PHE A 131      59.062   9.604  -1.803  1.00 46.62           C  
ATOM    982  CD2 PHE A 131      57.865   9.285   0.243  1.00 46.29           C  
ATOM    983  CE1 PHE A 131      60.004   8.667  -1.402  1.00 46.85           C  
ATOM    984  CE2 PHE A 131      58.799   8.345   0.651  1.00 46.51           C  
ATOM    985  CZ  PHE A 131      59.874   8.039  -0.172  1.00 46.74           C  
ATOM    986  N   GLY A 132      53.548  11.412  -1.053  1.00 46.49           N  
ATOM    987  CA  GLY A 132      52.569  12.485  -0.939  1.00 46.40           C  
ATOM    988  C   GLY A 132      52.681  13.164   0.411  1.00 46.48           C  
ATOM    989  O   GLY A 132      52.960  12.514   1.420  1.00 46.34           O  
ATOM    990  N   GLY A 133      52.468  14.475   0.428  1.00 46.55           N  
ATOM    991  CA  GLY A 133      52.602  15.258   1.651  1.00 46.79           C  
ATOM    992  C   GLY A 133      51.301  15.480   2.398  1.00 47.00           C  
ATOM    993  O   GLY A 133      51.208  16.388   3.224  1.00 47.20           O  
ATOM    994  N   ALA A 134      50.300  14.651   2.115  1.00 47.11           N  
ATOM    995  CA  ALA A 134      49.000  14.747   2.775  1.00 47.23           C  
ATOM    996  C   ALA A 134      49.109  14.447   4.269  1.00 47.26           C  
ATOM    997  O   ALA A 134      49.913  13.611   4.678  1.00 47.23           O  
ATOM    998  CB  ALA A 134      47.995  13.815   2.111  1.00 47.15           C  
ATOM    999  N   ARG A 135      48.306  15.145   5.068  1.00 47.49           N  
ATOM   1000  CA  ARG A 135      48.296  14.990   6.527  1.00 47.64           C  
ATOM   1001  C   ARG A 135      46.977  14.392   7.006  1.00 47.79           C  
ATOM   1002  O   ARG A 135      45.928  14.613   6.394  1.00 47.95           O  
ATOM   1003  CB  ARG A 135      48.511  16.339   7.217  1.00 47.58           C  
ATOM   1004  CG  ARG A 135      49.919  16.893   7.122  1.00 47.31           C  
ATOM   1005  CD  ARG A 135      50.040  18.214   7.863  1.00 47.18           C  
ATOM   1006  NE  ARG A 135      49.584  19.346   7.059  1.00 47.82           N  
ATOM   1007  CZ  ARG A 135      48.497  20.070   7.315  1.00 47.42           C  
ATOM   1008  NH1 ARG A 135      47.736  19.800   8.367  1.00 47.56           N  
ATOM   1009  NH2 ARG A 135      48.174  21.076   6.518  1.00 47.34           N  
ATOM   1010  N   ARG A 136      47.030  13.655   8.113  1.00 47.83           N  
ATOM   1011  CA  ARG A 136      45.832  13.021   8.665  1.00 47.89           C  
ATOM   1012  C   ARG A 136      44.822  14.008   9.262  1.00 48.19           C  
ATOM   1013  O   ARG A 136      43.627  13.711   9.318  1.00 48.44           O  
ATOM   1014  CB  ARG A 136      46.193  11.924   9.674  1.00 47.65           C  
ATOM   1015  CG  ARG A 136      46.880  10.713   9.046  1.00 47.00           C  
ATOM   1016  CD  ARG A 136      46.700   9.454   9.883  1.00 45.78           C  
ATOM   1017  NE  ARG A 136      47.783   9.252  10.844  1.00 44.66           N  
ATOM   1018  CZ  ARG A 136      48.584   8.191  10.872  1.00 43.65           C  
ATOM   1019  NH1 ARG A 136      48.433   7.206   9.997  1.00 42.85           N  
ATOM   1020  NH2 ARG A 136      49.533   8.108  11.793  1.00 43.08           N  
ATOM   1021  N   ASP A 137      45.287  15.181   9.684  1.00 48.43           N  
ATOM   1022  CA  ASP A 137      44.406  16.171  10.304  1.00 48.77           C  
ATOM   1023  C   ASP A 137      43.761  17.126   9.292  1.00 48.95           C  
ATOM   1024  O   ASP A 137      42.966  17.992   9.666  1.00 48.86           O  
ATOM   1025  CB  ASP A 137      45.146  16.948  11.402  1.00 48.88           C  
ATOM   1026  CG  ASP A 137      46.026  18.061  10.849  1.00 49.37           C  
ATOM   1027  OD1 ASP A 137      46.061  19.153  11.459  1.00 49.81           O  
ATOM   1028  OD2 ASP A 137      46.678  17.851   9.804  1.00 49.83           O  
ATOM   1029  N   GLU A 138      44.105  16.956   8.016  1.00 49.22           N  
ATOM   1030  CA  GLU A 138      43.623  17.829   6.943  1.00 49.44           C  
ATOM   1031  C   GLU A 138      42.165  17.588   6.569  1.00 49.54           C  
ATOM   1032  O   GLU A 138      41.440  18.530   6.246  1.00 49.59           O  
ATOM   1033  CB  GLU A 138      44.508  17.701   5.702  1.00 49.45           C  
ATOM   1034  CG  GLU A 138      45.801  18.489   5.798  1.00 49.77           C  
ATOM   1035  CD  GLU A 138      46.631  18.418   4.535  1.00 50.59           C  
ATOM   1036  OE1 GLU A 138      46.982  17.297   4.109  1.00 50.85           O  
ATOM   1037  OE2 GLU A 138      46.948  19.488   3.969  1.00 50.69           O  
ATOM   1038  N   GLU A 139      41.753  16.324   6.596  1.00 49.77           N  
ATOM   1039  CA  GLU A 139      40.360  15.942   6.379  1.00 49.90           C  
ATOM   1040  C   GLU A 139      39.979  14.839   7.360  1.00 49.96           C  
ATOM   1041  O   GLU A 139      40.822  14.030   7.747  1.00 49.95           O  
ATOM   1042  CB  GLU A 139      40.141  15.476   4.938  1.00 49.92           C  
ATOM   1043  N   LYS A 140      38.709  14.815   7.756  1.00 50.17           N  
ATOM   1044  CA  LYS A 140      38.208  13.866   8.755  1.00 50.35           C  
ATOM   1045  C   LYS A 140      38.512  12.402   8.435  1.00 50.29           C  
ATOM   1046  O   LYS A 140      38.962  11.659   9.307  1.00 50.31           O  
ATOM   1047  CB  LYS A 140      36.706  14.067   8.996  1.00 50.42           C  
ATOM   1048  CG  LYS A 140      36.359  14.892  10.236  1.00 51.15           C  
ATOM   1049  CD  LYS A 140      36.740  16.365  10.098  1.00 52.23           C  
ATOM   1050  CE  LYS A 140      36.408  17.145  11.364  1.00 52.60           C  
ATOM   1051  NZ  LYS A 140      36.970  18.525  11.333  1.00 52.74           N  
ATOM   1052  N   SER A 141      38.280  12.004   7.185  1.00 50.36           N  
ATOM   1053  CA  SER A 141      38.503  10.625   6.741  1.00 50.33           C  
ATOM   1054  C   SER A 141      39.949  10.166   6.926  1.00 50.45           C  
ATOM   1055  O   SER A 141      40.201   8.990   7.205  1.00 50.72           O  
ATOM   1056  CB  SER A 141      38.092  10.460   5.276  1.00 50.27           C  
ATOM   1057  OG  SER A 141      38.996  11.124   4.408  1.00 49.93           O  
ATOM   1058  N   ARG A 142      40.886  11.101   6.780  1.00 50.35           N  
ATOM   1059  CA  ARG A 142      42.319  10.812   6.854  1.00 50.17           C  
ATOM   1060  C   ARG A 142      42.748  10.198   8.194  1.00 49.97           C  
ATOM   1061  O   ARG A 142      43.860   9.686   8.312  1.00 50.03           O  
ATOM   1062  CB  ARG A 142      43.134  12.079   6.580  1.00 50.25           C  
ATOM   1063  CG  ARG A 142      42.924  12.740   5.218  1.00 50.89           C  
ATOM   1064  CD  ARG A 142      44.141  12.564   4.317  1.00 51.55           C  
ATOM   1065  NE  ARG A 142      43.948  11.512   3.322  1.00 52.40           N  
ATOM   1066  CZ  ARG A 142      44.926  10.789   2.782  1.00 52.62           C  
ATOM   1067  NH1 ARG A 142      46.188  10.979   3.148  1.00 52.03           N  
ATOM   1068  NH2 ARG A 142      44.636   9.861   1.878  1.00 52.95           N  
ATOM   1069  N   ALA A 143      41.869  10.245   9.195  1.00 49.66           N  
ATOM   1070  CA  ALA A 143      42.169   9.715  10.531  1.00 49.42           C  
ATOM   1071  C   ALA A 143      42.492   8.219  10.543  1.00 49.20           C  
ATOM   1072  O   ALA A 143      43.349   7.772  11.307  1.00 49.16           O  
ATOM   1073  CB  ALA A 143      41.026  10.015  11.493  1.00 49.46           C  
ATOM   1074  N   LYS A 144      41.799   7.455   9.699  1.00 48.90           N  
ATOM   1075  CA  LYS A 144      42.015   6.015   9.593  1.00 48.51           C  
ATOM   1076  C   LYS A 144      43.034   5.673   8.506  1.00 48.34           C  
ATOM   1077  O   LYS A 144      43.243   4.502   8.186  1.00 48.33           O  
ATOM   1078  CB  LYS A 144      40.695   5.285   9.327  1.00 48.44           C  
ATOM   1079  CG  LYS A 144      39.762   5.173  10.529  1.00 48.47           C  
ATOM   1080  CD  LYS A 144      38.770   6.330  10.584  1.00 48.86           C  
ATOM   1081  CE  LYS A 144      37.657   6.081  11.590  1.00 48.48           C  
ATOM   1082  NZ  LYS A 144      36.656   5.104  11.082  1.00 48.41           N  
ATOM   1083  N   GLU A 145      43.665   6.699   7.941  1.00 48.09           N  
ATOM   1084  CA  GLU A 145      44.669   6.503   6.900  1.00 47.86           C  
ATOM   1085  C   GLU A 145      45.963   5.952   7.474  1.00 47.58           C  
ATOM   1086  O   GLU A 145      46.321   6.239   8.620  1.00 47.56           O  
ATOM   1087  CB  GLU A 145      44.957   7.810   6.158  1.00 47.97           C  
ATOM   1088  CG  GLU A 145      43.980   8.129   5.034  1.00 48.49           C  
ATOM   1089  CD  GLU A 145      44.167   7.243   3.813  1.00 49.28           C  
ATOM   1090  OE1 GLU A 145      45.300   6.761   3.581  1.00 49.99           O  
ATOM   1091  OE2 GLU A 145      43.176   7.036   3.082  1.00 48.94           O  
ATOM   1092  N   ARG A 146      46.652   5.158   6.660  1.00 47.22           N  
ATOM   1093  CA  ARG A 146      47.970   4.633   6.994  1.00 46.83           C  
ATOM   1094  C   ARG A 146      49.061   5.399   6.251  1.00 46.63           C  
ATOM   1095  O   ARG A 146      48.775   6.171   5.335  1.00 46.65           O  
ATOM   1096  CB  ARG A 146      48.040   3.148   6.647  1.00 46.73           C  
ATOM   1097  CG  ARG A 146      47.515   2.235   7.737  1.00 46.45           C  
ATOM   1098  CD  ARG A 146      47.034   0.918   7.155  1.00 46.21           C  
ATOM   1099  NE  ARG A 146      45.916   1.120   6.238  1.00 46.09           N  
ATOM   1100  CZ  ARG A 146      44.647   1.241   6.615  1.00 45.68           C  
ATOM   1101  NH1 ARG A 146      44.319   1.167   7.899  1.00 46.02           N  
ATOM   1102  NH2 ARG A 146      43.702   1.431   5.706  1.00 45.64           N  
ATOM   1103  N   VAL A 147      50.308   5.192   6.657  1.00 46.56           N  
ATOM   1104  CA  VAL A 147      51.453   5.794   5.969  1.00 46.65           C  
ATOM   1105  C   VAL A 147      51.614   5.218   4.550  1.00 46.69           C  
ATOM   1106  O   VAL A 147      51.812   5.964   3.591  1.00 46.59           O  
ATOM   1107  CB  VAL A 147      52.759   5.669   6.808  1.00 46.59           C  
ATOM   1108  CG1 VAL A 147      53.980   6.149   6.029  1.00 45.99           C  
ATOM   1109  CG2 VAL A 147      52.627   6.447   8.114  1.00 46.33           C  
ATOM   1110  N   TYR A 148      51.504   3.897   4.429  1.00 46.80           N  
ATOM   1111  CA  TYR A 148      51.576   3.215   3.140  1.00 46.98           C  
ATOM   1112  C   TYR A 148      50.167   2.949   2.618  1.00 47.12           C  
ATOM   1113  O   TYR A 148      49.331   2.394   3.332  1.00 47.08           O  
ATOM   1114  CB  TYR A 148      52.340   1.890   3.270  1.00 46.99           C  
ATOM   1115  CG  TYR A 148      53.848   2.007   3.423  1.00 47.07           C  
ATOM   1116  CD1 TYR A 148      54.414   2.835   4.388  1.00 47.70           C  
ATOM   1117  CD2 TYR A 148      54.707   1.253   2.628  1.00 47.32           C  
ATOM   1118  CE1 TYR A 148      55.792   2.938   4.535  1.00 47.96           C  
ATOM   1119  CE2 TYR A 148      56.090   1.346   2.770  1.00 47.31           C  
ATOM   1120  CZ  TYR A 148      56.623   2.188   3.727  1.00 47.47           C  
ATOM   1121  OH  TYR A 148      57.983   2.293   3.888  1.00 47.25           O  
ATOM   1122  N   SER A 149      49.906   3.357   1.378  1.00 47.39           N  
ATOM   1123  CA  SER A 149      48.616   3.117   0.733  1.00 47.65           C  
ATOM   1124  C   SER A 149      48.804   2.297  -0.537  1.00 47.84           C  
ATOM   1125  O   SER A 149      49.243   2.816  -1.564  1.00 47.87           O  
ATOM   1126  CB  SER A 149      47.906   4.436   0.422  1.00 47.67           C  
ATOM   1127  OG  SER A 149      46.706   4.215  -0.301  1.00 47.69           O  
ATOM   1128  N   PHE A 150      48.456   1.017  -0.457  1.00 48.22           N  
ATOM   1129  CA  PHE A 150      48.741   0.065  -1.529  1.00 48.61           C  
ATOM   1130  C   PHE A 150      47.744   0.116  -2.683  1.00 48.91           C  
ATOM   1131  O   PHE A 150      46.532   0.009  -2.483  1.00 48.97           O  
ATOM   1132  CB  PHE A 150      48.878  -1.354  -0.967  1.00 48.51           C  
ATOM   1133  CG  PHE A 150      50.079  -1.531  -0.084  1.00 48.56           C  
ATOM   1134  CD1 PHE A 150      51.279  -1.991  -0.610  1.00 48.38           C  
ATOM   1135  CD2 PHE A 150      50.020  -1.211   1.269  1.00 48.54           C  
ATOM   1136  CE1 PHE A 150      52.401  -2.136   0.198  1.00 48.49           C  
ATOM   1137  CE2 PHE A 150      51.134  -1.357   2.086  1.00 48.53           C  
ATOM   1138  CZ  PHE A 150      52.327  -1.819   1.549  1.00 48.54           C  
ATOM   1139  N   ARG A 151      48.276   0.293  -3.889  1.00 49.27           N  
ATOM   1140  CA  ARG A 151      47.475   0.321  -5.106  1.00 49.74           C  
ATOM   1141  C   ARG A 151      47.830  -0.868  -5.994  1.00 50.07           C  
ATOM   1142  O   ARG A 151      48.974  -1.324  -6.002  1.00 50.03           O  
ATOM   1143  CB  ARG A 151      47.689   1.636  -5.868  1.00 49.73           C  
ATOM   1144  CG  ARG A 151      47.614   2.903  -5.016  1.00 49.71           C  
ATOM   1145  CD  ARG A 151      46.218   3.155  -4.455  1.00 49.71           C  
ATOM   1146  NE  ARG A 151      46.239   4.183  -3.415  1.00 49.82           N  
ATOM   1147  CZ  ARG A 151      45.805   5.432  -3.569  1.00 49.81           C  
ATOM   1148  NH1 ARG A 151      45.288   5.832  -4.725  1.00 49.27           N  
ATOM   1149  NH2 ARG A 151      45.883   6.283  -2.553  1.00 49.42           N  
ATOM   1150  N   ASP A 152      46.846  -1.364  -6.739  1.00 50.65           N  
ATOM   1151  CA  ASP A 152      47.057  -2.506  -7.628  1.00 51.16           C  
ATOM   1152  C   ASP A 152      47.575  -2.072  -9.002  1.00 51.47           C  
ATOM   1153  O   ASP A 152      47.918  -0.904  -9.205  1.00 51.52           O  
ATOM   1154  CB  ASP A 152      45.782  -3.353  -7.746  1.00 51.16           C  
ATOM   1155  CG  ASP A 152      44.661  -2.634  -8.472  1.00 51.37           C  
ATOM   1156  OD1 ASP A 152      44.754  -2.477  -9.705  1.00 51.70           O  
ATOM   1157  OD2 ASP A 152      43.675  -2.240  -7.816  1.00 51.95           O  
ATOM   1158  N   SER A 153      47.628  -3.023  -9.934  1.00 51.83           N  
ATOM   1159  CA  SER A 153      48.130  -2.778 -11.284  1.00 52.17           C  
ATOM   1160  C   SER A 153      47.312  -1.713 -12.016  1.00 52.34           C  
ATOM   1161  O   SER A 153      47.869  -0.727 -12.501  1.00 52.25           O  
ATOM   1162  CB  SER A 153      48.162  -4.082 -12.085  1.00 52.21           C  
ATOM   1163  OG  SER A 153      48.727  -3.882 -13.369  1.00 52.60           O  
ATOM   1164  N   LYS A 154      45.997  -1.909 -12.076  1.00 52.66           N  
ATOM   1165  CA  LYS A 154      45.096  -0.928 -12.687  1.00 52.98           C  
ATOM   1166  C   LYS A 154      44.858   0.291 -11.789  1.00 53.12           C  
ATOM   1167  O   LYS A 154      44.027   1.147 -12.104  1.00 53.10           O  
ATOM   1168  CB  LYS A 154      43.777  -1.575 -13.139  1.00 52.99           C  
ATOM   1169  CG  LYS A 154      42.977  -2.266 -12.044  1.00 53.24           C  
ATOM   1170  CD  LYS A 154      41.795  -3.036 -12.617  1.00 53.63           C  
ATOM   1171  CE  LYS A 154      41.114  -3.890 -11.556  1.00 53.64           C  
ATOM   1172  NZ  LYS A 154      40.544  -3.070 -10.448  1.00 54.01           N  
ATOM   1173  N   HIS A 155      45.578   0.343 -10.666  1.00 53.41           N  
ATOM   1174  CA  HIS A 155      45.764   1.566  -9.875  1.00 53.65           C  
ATOM   1175  C   HIS A 155      44.797   1.787  -8.698  1.00 53.54           C  
ATOM   1176  O   HIS A 155      45.004   2.690  -7.885  1.00 53.54           O  
ATOM   1177  CB  HIS A 155      45.787   2.792 -10.797  1.00 53.84           C  
ATOM   1178  CG  HIS A 155      46.561   3.945 -10.251  1.00 54.68           C  
ATOM   1179  ND1 HIS A 155      45.974   4.945  -9.505  1.00 55.61           N  
ATOM   1180  CD2 HIS A 155      47.876   4.259 -10.337  1.00 55.45           C  
ATOM   1181  CE1 HIS A 155      46.895   5.826  -9.155  1.00 56.12           C  
ATOM   1182  NE2 HIS A 155      48.057   5.431  -9.644  1.00 56.24           N  
ATOM   1183  N   ARG A 156      43.763   0.955  -8.595  1.00 53.41           N  
ATOM   1184  CA  ARG A 156      42.740   1.116  -7.556  1.00 53.29           C  
ATOM   1185  C   ARG A 156      43.210   0.705  -6.148  1.00 53.08           C  
ATOM   1186  O   ARG A 156      44.244   0.053  -5.988  1.00 53.08           O  
ATOM   1187  CB  ARG A 156      41.453   0.378  -7.957  1.00 53.40           C  
ATOM   1188  CG  ARG A 156      40.268   0.549  -6.999  1.00 53.97           C  
ATOM   1189  CD  ARG A 156      39.739   1.982  -6.949  1.00 54.74           C  
ATOM   1190  NE  ARG A 156      39.437   2.393  -5.577  1.00 55.35           N  
ATOM   1191  CZ  ARG A 156      38.654   3.415  -5.240  1.00 55.76           C  
ATOM   1192  NH1 ARG A 156      38.059   4.147  -6.175  1.00 55.76           N  
ATOM   1193  NH2 ARG A 156      38.455   3.700  -3.959  1.00 55.72           N  
ATOM   1194  N   TRP A 157      42.435   1.108  -5.141  1.00 52.71           N  
ATOM   1195  CA  TRP A 157      42.704   0.837  -3.732  1.00 52.34           C  
ATOM   1196  C   TRP A 157      41.785  -0.274  -3.215  1.00 52.20           C  
ATOM   1197  O   TRP A 157      40.569  -0.222  -3.412  1.00 52.22           O  
ATOM   1198  CB  TRP A 157      42.483   2.129  -2.937  1.00 52.29           C  
ATOM   1199  CG  TRP A 157      42.735   2.048  -1.461  1.00 52.17           C  
ATOM   1200  CD1 TRP A 157      43.907   2.318  -0.813  1.00 52.17           C  
ATOM   1201  CD2 TRP A 157      41.781   1.714  -0.442  1.00 52.05           C  
ATOM   1202  NE1 TRP A 157      43.747   2.157   0.544  1.00 52.23           N  
ATOM   1203  CE2 TRP A 157      42.453   1.783   0.799  1.00 52.36           C  
ATOM   1204  CE3 TRP A 157      40.427   1.353  -0.459  1.00 51.83           C  
ATOM   1205  CZ2 TRP A 157      41.816   1.507   2.014  1.00 52.39           C  
ATOM   1206  CZ3 TRP A 157      39.795   1.075   0.749  1.00 52.04           C  
ATOM   1207  CH2 TRP A 157      40.490   1.153   1.967  1.00 52.29           C  
ATOM   1208  N   ASP A 158      42.366  -1.278  -2.561  1.00 52.00           N  
ATOM   1209  CA  ASP A 158      41.592  -2.390  -1.999  1.00 51.80           C  
ATOM   1210  C   ASP A 158      41.871  -2.600  -0.510  1.00 51.56           C  
ATOM   1211  O   ASP A 158      43.032  -2.711  -0.110  1.00 51.46           O  
ATOM   1212  CB  ASP A 158      41.852  -3.690  -2.771  1.00 51.92           C  
ATOM   1213  CG  ASP A 158      40.927  -3.861  -3.965  1.00 52.09           C  
ATOM   1214  OD1 ASP A 158      41.425  -4.234  -5.049  1.00 52.02           O  
ATOM   1215  OD2 ASP A 158      39.705  -3.635  -3.822  1.00 52.49           O  
ATOM   1216  N   PRO A 159      40.801  -2.668   0.309  1.00 51.31           N  
ATOM   1217  CA  PRO A 159      40.867  -2.761   1.774  1.00 51.12           C  
ATOM   1218  C   PRO A 159      41.726  -3.909   2.318  1.00 50.82           C  
ATOM   1219  O   PRO A 159      42.528  -3.689   3.229  1.00 50.72           O  
ATOM   1220  CB  PRO A 159      39.403  -2.957   2.185  1.00 51.14           C  
ATOM   1221  CG  PRO A 159      38.612  -2.381   1.070  1.00 51.37           C  
ATOM   1222  CD  PRO A 159      39.407  -2.649  -0.173  1.00 51.38           C  
ATOM   1223  N   LYS A 160      41.561  -5.111   1.767  1.00 50.48           N  
ATOM   1224  CA  LYS A 160      42.290  -6.293   2.242  1.00 50.15           C  
ATOM   1225  C   LYS A 160      43.767  -6.287   1.844  1.00 49.78           C  
ATOM   1226  O   LYS A 160      44.569  -7.032   2.412  1.00 49.83           O  
ATOM   1227  CB  LYS A 160      41.625  -7.586   1.755  1.00 50.26           C  
ATOM   1228  CG  LYS A 160      40.233  -7.857   2.316  1.00 50.74           C  
ATOM   1229  CD  LYS A 160      40.270  -8.740   3.557  1.00 51.21           C  
ATOM   1230  CE  LYS A 160      38.869  -9.200   3.933  1.00 51.54           C  
ATOM   1231  NZ  LYS A 160      38.872 -10.120   5.105  1.00 51.70           N  
ATOM   1232  N   ASN A 161      44.120  -5.453   0.867  1.00 49.23           N  
ATOM   1233  CA  ASN A 161      45.514  -5.281   0.460  1.00 48.76           C  
ATOM   1234  C   ASN A 161      46.270  -4.296   1.362  1.00 48.28           C  
ATOM   1235  O   ASN A 161      47.497  -4.194   1.293  1.00 48.25           O  
ATOM   1236  CB  ASN A 161      45.596  -4.841  -1.007  1.00 48.86           C  
ATOM   1237  CG  ASN A 161      46.854  -5.348  -1.711  1.00 49.10           C  
ATOM   1238  OD1 ASN A 161      47.968  -5.270  -1.184  1.00 48.30           O  
ATOM   1239  ND2 ASN A 161      46.672  -5.863  -2.923  1.00 49.51           N  
ATOM   1240  N   GLN A 162      45.533  -3.579   2.208  1.00 47.66           N  
ATOM   1241  CA  GLN A 162      46.134  -2.652   3.162  1.00 47.07           C  
ATOM   1242  C   GLN A 162      46.645  -3.406   4.385  1.00 46.82           C  
ATOM   1243  O   GLN A 162      46.038  -4.390   4.812  1.00 46.78           O  
ATOM   1244  CB  GLN A 162      45.138  -1.565   3.576  1.00 46.97           C  
ATOM   1245  CG  GLN A 162      44.447  -0.856   2.414  1.00 46.63           C  
ATOM   1246  CD  GLN A 162      45.413  -0.346   1.356  1.00 46.27           C  
ATOM   1247  OE1 GLN A 162      46.405   0.319   1.662  1.00 46.30           O  
ATOM   1248  NE2 GLN A 162      45.116  -0.645   0.099  1.00 45.72           N  
ATOM   1249  N   ARG A 163      47.759  -2.933   4.942  1.00 46.41           N  
ATOM   1250  CA  ARG A 163      48.460  -3.645   6.009  1.00 46.10           C  
ATOM   1251  C   ARG A 163      48.543  -2.848   7.307  1.00 46.02           C  
ATOM   1252  O   ARG A 163      48.770  -1.637   7.277  1.00 46.15           O  
ATOM   1253  CB  ARG A 163      49.863  -4.027   5.543  1.00 45.96           C  
ATOM   1254  CG  ARG A 163      49.860  -4.935   4.332  1.00 46.01           C  
ATOM   1255  CD  ARG A 163      51.109  -4.770   3.499  1.00 45.50           C  
ATOM   1256  NE  ARG A 163      50.857  -5.149   2.113  1.00 44.97           N  
ATOM   1257  CZ  ARG A 163      51.800  -5.305   1.192  1.00 45.08           C  
ATOM   1258  NH1 ARG A 163      53.079  -5.117   1.497  1.00 45.35           N  
ATOM   1259  NH2 ARG A 163      51.462  -5.646  -0.042  1.00 44.83           N  
ATOM   1260  N   PRO A 164      48.370  -3.527   8.455  1.00 45.91           N  
ATOM   1261  CA  PRO A 164      48.488  -2.840   9.740  1.00 45.86           C  
ATOM   1262  C   PRO A 164      49.908  -2.327   9.931  1.00 45.81           C  
ATOM   1263  O   PRO A 164      50.863  -3.060   9.676  1.00 45.63           O  
ATOM   1264  CB  PRO A 164      48.185  -3.937  10.768  1.00 45.77           C  
ATOM   1265  CG  PRO A 164      47.552  -5.039  10.011  1.00 45.95           C  
ATOM   1266  CD  PRO A 164      48.080  -4.961   8.618  1.00 45.87           C  
ATOM   1267  N   GLU A 165      50.037  -1.074  10.356  1.00 45.97           N  
ATOM   1268  CA  GLU A 165      51.348  -0.464  10.580  1.00 46.20           C  
ATOM   1269  C   GLU A 165      51.666  -0.419  12.063  1.00 46.48           C  
ATOM   1270  O   GLU A 165      51.127   0.397  12.813  1.00 46.41           O  
ATOM   1271  CB  GLU A 165      51.419   0.930   9.964  1.00 45.92           C  
ATOM   1272  CG  GLU A 165      51.325   0.918   8.454  1.00 45.76           C  
ATOM   1273  CD  GLU A 165      51.154   2.299   7.864  1.00 45.81           C  
ATOM   1274  OE1 GLU A 165      50.863   3.255   8.621  1.00 45.69           O  
ATOM   1275  OE2 GLU A 165      51.304   2.422   6.631  1.00 45.57           O  
ATOM   1276  N   LEU A 166      52.569  -1.301  12.472  1.00 47.00           N  
ATOM   1277  CA  LEU A 166      52.747  -1.600  13.883  1.00 47.43           C  
ATOM   1278  C   LEU A 166      53.618  -0.613  14.652  1.00 47.59           C  
ATOM   1279  O   LEU A 166      53.099   0.150  15.459  1.00 47.96           O  
ATOM   1280  CB  LEU A 166      53.384  -2.979  14.061  1.00 47.47           C  
ATOM   1281  CG  LEU A 166      52.604  -4.166  13.492  1.00 47.94           C  
ATOM   1282  CD1 LEU A 166      53.349  -5.468  13.739  1.00 49.48           C  
ATOM   1283  CD2 LEU A 166      51.207  -4.227  14.091  1.00 47.65           C  
ATOM   1284  N   TRP A 167      54.923  -0.606  14.426  1.00 47.62           N  
ATOM   1285  CA  TRP A 167      55.766   0.303  15.197  1.00 47.84           C  
ATOM   1286  C   TRP A 167      56.240   1.439  14.305  1.00 48.24           C  
ATOM   1287  O   TRP A 167      55.452   2.314  13.956  1.00 48.04           O  
ATOM   1288  CB  TRP A 167      56.917  -0.452  15.863  1.00 47.41           C  
ATOM   1289  CG  TRP A 167      56.443  -1.374  16.949  1.00 47.02           C  
ATOM   1290  CD1 TRP A 167      56.237  -1.053  18.261  1.00 46.54           C  
ATOM   1291  CD2 TRP A 167      56.103  -2.761  16.819  1.00 46.30           C  
ATOM   1292  NE1 TRP A 167      55.800  -2.152  18.956  1.00 45.91           N  
ATOM   1293  CE2 TRP A 167      55.706  -3.215  18.096  1.00 46.23           C  
ATOM   1294  CE3 TRP A 167      56.107  -3.668  15.752  1.00 46.29           C  
ATOM   1295  CZ2 TRP A 167      55.314  -4.537  18.335  1.00 46.14           C  
ATOM   1296  CZ3 TRP A 167      55.712  -4.981  15.991  1.00 46.63           C  
ATOM   1297  CH2 TRP A 167      55.323  -5.403  17.274  1.00 46.14           C  
ATOM   1298  N   ASN A 168      57.522   1.438  13.960  1.00 48.91           N  
ATOM   1299  CA  ASN A 168      57.987   2.174  12.794  1.00 49.82           C  
ATOM   1300  C   ASN A 168      58.566   1.165  11.803  1.00 49.69           C  
ATOM   1301  O   ASN A 168      59.373   1.498  10.934  1.00 49.74           O  
ATOM   1302  CB  ASN A 168      58.987   3.268  13.177  1.00 50.28           C  
ATOM   1303  CG  ASN A 168      58.457   4.205  14.266  1.00 52.91           C  
ATOM   1304  OD1 ASN A 168      59.211   4.631  15.149  1.00 55.76           O  
ATOM   1305  ND2 ASN A 168      57.161   4.531  14.209  1.00 54.30           N  
ATOM   1306  N   VAL A 169      58.131  -0.081  11.969  1.00 49.69           N  
ATOM   1307  CA  VAL A 169      58.376  -1.158  11.019  1.00 49.78           C  
ATOM   1308  C   VAL A 169      57.261  -1.112   9.979  1.00 49.83           C  
ATOM   1309  O   VAL A 169      56.078  -1.131  10.318  1.00 50.02           O  
ATOM   1310  CB  VAL A 169      58.368  -2.539  11.716  1.00 49.75           C  
ATOM   1311  CG1 VAL A 169      58.688  -3.646  10.729  1.00 49.86           C  
ATOM   1312  CG2 VAL A 169      59.356  -2.569  12.871  1.00 49.86           C  
ATOM   1313  N   TYR A 170      57.644  -1.033   8.711  1.00 49.87           N  
ATOM   1314  CA  TYR A 170      56.677  -0.941   7.627  1.00 49.73           C  
ATOM   1315  C   TYR A 170      56.892  -2.065   6.617  1.00 49.54           C  
ATOM   1316  O   TYR A 170      58.028  -2.453   6.338  1.00 49.65           O  
ATOM   1317  CB  TYR A 170      56.780   0.427   6.948  1.00 49.88           C  
ATOM   1318  CG  TYR A 170      56.351   1.578   7.833  1.00 50.19           C  
ATOM   1319  CD1 TYR A 170      55.004   1.938   7.936  1.00 50.71           C  
ATOM   1320  CD2 TYR A 170      57.287   2.310   8.566  1.00 50.35           C  
ATOM   1321  CE1 TYR A 170      54.597   2.990   8.747  1.00 50.29           C  
ATOM   1322  CE2 TYR A 170      56.889   3.367   9.384  1.00 50.41           C  
ATOM   1323  CZ  TYR A 170      55.542   3.699   9.467  1.00 50.92           C  
ATOM   1324  OH  TYR A 170      55.131   4.744  10.264  1.00 51.29           O  
ATOM   1325  N   ASN A 171      55.796  -2.590   6.083  1.00 49.22           N  
ATOM   1326  CA  ASN A 171      55.849  -3.667   5.100  1.00 48.96           C  
ATOM   1327  C   ASN A 171      55.709  -3.108   3.690  1.00 48.74           C  
ATOM   1328  O   ASN A 171      54.657  -2.594   3.320  1.00 48.97           O  
ATOM   1329  CB  ASN A 171      54.749  -4.696   5.383  1.00 48.93           C  
ATOM   1330  CG  ASN A 171      54.833  -5.920   4.485  1.00 49.01           C  
ATOM   1331  OD1 ASN A 171      55.646  -5.984   3.565  1.00 49.75           O  
ATOM   1332  ND2 ASN A 171      53.983  -6.903   4.756  1.00 49.03           N  
ATOM   1333  N   GLY A 172      56.777  -3.207   2.908  1.00 48.51           N  
ATOM   1334  CA  GLY A 172      56.784  -2.680   1.547  1.00 48.25           C  
ATOM   1335  C   GLY A 172      56.760  -3.747   0.469  1.00 48.02           C  
ATOM   1336  O   GLY A 172      56.819  -3.432  -0.720  1.00 47.94           O  
ATOM   1337  N   ASN A 173      56.685  -5.009   0.886  1.00 47.90           N  
ATOM   1338  CA  ASN A 173      56.595  -6.127  -0.048  1.00 47.85           C  
ATOM   1339  C   ASN A 173      55.445  -5.945  -1.026  1.00 47.87           C  
ATOM   1340  O   ASN A 173      54.273  -6.009  -0.652  1.00 47.78           O  
ATOM   1341  CB  ASN A 173      56.446  -7.454   0.696  1.00 47.83           C  
ATOM   1342  CG  ASN A 173      57.744  -7.935   1.303  1.00 47.57           C  
ATOM   1343  OD1 ASN A 173      58.797  -7.322   1.125  1.00 47.15           O  
ATOM   1344  ND2 ASN A 173      57.675  -9.046   2.022  1.00 47.60           N  
ATOM   1345  N   VAL A 174      55.797  -5.710  -2.283  1.00 47.92           N  
ATOM   1346  CA  VAL A 174      54.807  -5.417  -3.307  1.00 47.93           C  
ATOM   1347  C   VAL A 174      55.021  -6.330  -4.516  1.00 47.98           C  
ATOM   1348  O   VAL A 174      56.125  -6.840  -4.730  1.00 47.97           O  
ATOM   1349  CB  VAL A 174      54.851  -3.913  -3.682  1.00 47.94           C  
ATOM   1350  CG1 VAL A 174      55.827  -3.643  -4.830  1.00 47.76           C  
ATOM   1351  CG2 VAL A 174      53.460  -3.394  -3.992  1.00 47.60           C  
ATOM   1352  N   ASN A 175      53.958  -6.561  -5.279  1.00 48.08           N  
ATOM   1353  CA  ASN A 175      54.038  -7.403  -6.471  1.00 48.14           C  
ATOM   1354  C   ASN A 175      54.425  -6.619  -7.719  1.00 48.18           C  
ATOM   1355  O   ASN A 175      54.461  -5.385  -7.707  1.00 48.31           O  
ATOM   1356  CB  ASN A 175      52.727  -8.161  -6.698  1.00 48.11           C  
ATOM   1357  CG  ASN A 175      52.592  -9.374  -5.800  1.00 48.12           C  
ATOM   1358  OD1 ASN A 175      53.551 -10.117  -5.589  1.00 48.18           O  
ATOM   1359  ND2 ASN A 175      51.390  -9.588  -5.274  1.00 48.22           N  
ATOM   1360  N   LYS A 176      54.718  -7.348  -8.791  1.00 48.13           N  
ATOM   1361  CA  LYS A 176      55.141  -6.747 -10.049  1.00 48.08           C  
ATOM   1362  C   LYS A 176      53.983  -5.958 -10.661  1.00 47.94           C  
ATOM   1363  O   LYS A 176      52.923  -6.518 -10.954  1.00 47.94           O  
ATOM   1364  CB  LYS A 176      55.640  -7.828 -11.013  1.00 48.21           C  
ATOM   1365  CG  LYS A 176      56.295  -9.026 -10.321  1.00 48.56           C  
ATOM   1366  CD  LYS A 176      57.187  -9.827 -11.263  1.00 49.10           C  
ATOM   1367  CE  LYS A 176      58.632  -9.342 -11.209  1.00 49.18           C  
ATOM   1368  NZ  LYS A 176      59.552 -10.256 -11.940  1.00 49.45           N  
ATOM   1369  N   GLY A 177      54.188  -4.654 -10.827  1.00 47.70           N  
ATOM   1370  CA  GLY A 177      53.163  -3.774 -11.386  1.00 47.42           C  
ATOM   1371  C   GLY A 177      52.313  -3.080 -10.337  1.00 47.22           C  
ATOM   1372  O   GLY A 177      51.433  -2.285 -10.672  1.00 47.20           O  
ATOM   1373  N   GLU A 178      52.575  -3.382  -9.068  1.00 46.96           N  
ATOM   1374  CA  GLU A 178      51.864  -2.762  -7.954  1.00 46.65           C  
ATOM   1375  C   GLU A 178      52.661  -1.595  -7.377  1.00 46.58           C  
ATOM   1376  O   GLU A 178      53.889  -1.642  -7.319  1.00 46.58           O  
ATOM   1377  CB  GLU A 178      51.569  -3.790  -6.859  1.00 46.52           C  
ATOM   1378  CG  GLU A 178      50.553  -4.851  -7.247  1.00 46.09           C  
ATOM   1379  CD  GLU A 178      50.159  -5.754  -6.090  1.00 45.50           C  
ATOM   1380  OE1 GLU A 178      50.928  -5.864  -5.112  1.00 44.79           O  
ATOM   1381  OE2 GLU A 178      49.070  -6.362  -6.165  1.00 45.61           O  
ATOM   1382  N   SER A 179      51.956  -0.552  -6.953  1.00 46.52           N  
ATOM   1383  CA  SER A 179      52.593   0.654  -6.439  1.00 46.55           C  
ATOM   1384  C   SER A 179      51.952   1.116  -5.135  1.00 46.56           C  
ATOM   1385  O   SER A 179      50.826   0.730  -4.820  1.00 46.62           O  
ATOM   1386  CB  SER A 179      52.531   1.779  -7.472  1.00 46.46           C  
ATOM   1387  OG  SER A 179      51.257   2.402  -7.460  1.00 46.64           O  
ATOM   1388  N   ILE A 180      52.670   1.950  -4.388  1.00 46.50           N  
ATOM   1389  CA  ILE A 180      52.171   2.470  -3.118  1.00 46.41           C  
ATOM   1390  C   ILE A 180      52.129   3.997  -3.079  1.00 46.42           C  
ATOM   1391  O   ILE A 180      52.738   4.673  -3.912  1.00 46.39           O  
ATOM   1392  CB  ILE A 180      53.001   1.958  -1.915  1.00 46.36           C  
ATOM   1393  CG1 ILE A 180      54.374   2.632  -1.875  1.00 46.40           C  
ATOM   1394  CG2 ILE A 180      53.146   0.447  -1.961  1.00 46.37           C  
ATOM   1395  CD1 ILE A 180      55.031   2.581  -0.523  1.00 46.82           C  
ATOM   1396  N   ARG A 181      51.399   4.523  -2.101  1.00 46.40           N  
ATOM   1397  CA  ARG A 181      51.411   5.947  -1.786  1.00 46.42           C  
ATOM   1398  C   ARG A 181      51.920   6.132  -0.361  1.00 46.23           C  
ATOM   1399  O   ARG A 181      51.387   5.535   0.580  1.00 46.19           O  
ATOM   1400  CB  ARG A 181      50.012   6.549  -1.924  1.00 46.60           C  
ATOM   1401  CG  ARG A 181      49.349   6.330  -3.274  1.00 47.34           C  
ATOM   1402  CD  ARG A 181      50.119   7.003  -4.399  1.00 48.57           C  
ATOM   1403  NE  ARG A 181      49.205   7.548  -5.395  1.00 50.42           N  
ATOM   1404  CZ  ARG A 181      48.735   6.879  -6.443  1.00 51.40           C  
ATOM   1405  NH1 ARG A 181      49.095   5.619  -6.663  1.00 52.13           N  
ATOM   1406  NH2 ARG A 181      47.903   7.486  -7.278  1.00 51.63           N  
ATOM   1407  N   VAL A 182      52.956   6.951  -0.209  1.00 45.98           N  
ATOM   1408  CA  VAL A 182      53.586   7.147   1.092  1.00 45.75           C  
ATOM   1409  C   VAL A 182      53.321   8.547   1.624  1.00 45.58           C  
ATOM   1410  O   VAL A 182      53.472   9.532   0.899  1.00 45.58           O  
ATOM   1411  CB  VAL A 182      55.106   6.916   1.050  1.00 45.75           C  
ATOM   1412  CG1 VAL A 182      55.583   6.406   2.397  1.00 45.69           C  
ATOM   1413  CG2 VAL A 182      55.475   5.934  -0.046  1.00 45.55           C  
ATOM   1414  N   PHE A 183      52.939   8.629   2.896  1.00 45.31           N  
ATOM   1415  CA  PHE A 183      52.633   9.915   3.511  1.00 44.96           C  
ATOM   1416  C   PHE A 183      53.490  10.182   4.751  1.00 45.01           C  
ATOM   1417  O   PHE A 183      53.047   9.953   5.877  1.00 45.09           O  
ATOM   1418  CB  PHE A 183      51.134  10.034   3.812  1.00 44.68           C  
ATOM   1419  CG  PHE A 183      50.253   9.746   2.626  1.00 43.99           C  
ATOM   1420  CD1 PHE A 183      49.560   8.545   2.536  1.00 43.36           C  
ATOM   1421  CD2 PHE A 183      50.127  10.670   1.592  1.00 43.92           C  
ATOM   1422  CE1 PHE A 183      48.746   8.271   1.436  1.00 42.98           C  
ATOM   1423  CE2 PHE A 183      49.316  10.403   0.487  1.00 43.00           C  
ATOM   1424  CZ  PHE A 183      48.624   9.202   0.412  1.00 42.55           C  
ATOM   1425  N   PRO A 184      54.727  10.676   4.541  1.00 45.09           N  
ATOM   1426  CA  PRO A 184      55.677  10.990   5.612  1.00 45.18           C  
ATOM   1427  C   PRO A 184      55.138  11.977   6.645  1.00 45.18           C  
ATOM   1428  O   PRO A 184      55.542  11.932   7.810  1.00 45.21           O  
ATOM   1429  CB  PRO A 184      56.844  11.644   4.862  1.00 45.15           C  
ATOM   1430  CG  PRO A 184      56.757  11.120   3.485  1.00 45.04           C  
ATOM   1431  CD  PRO A 184      55.295  10.970   3.212  1.00 45.12           C  
ATOM   1432  N   LEU A 185      54.237  12.856   6.213  1.00 45.15           N  
ATOM   1433  CA  LEU A 185      53.782  13.973   7.033  1.00 45.24           C  
ATOM   1434  C   LEU A 185      52.479  13.689   7.770  1.00 45.25           C  
ATOM   1435  O   LEU A 185      51.903  14.589   8.388  1.00 45.35           O  
ATOM   1436  CB  LEU A 185      53.611  15.222   6.165  1.00 45.35           C  
ATOM   1437  CG  LEU A 185      54.785  16.147   5.835  1.00 45.37           C  
ATOM   1438  CD1 LEU A 185      56.039  15.406   5.388  1.00 45.35           C  
ATOM   1439  CD2 LEU A 185      54.331  17.120   4.761  1.00 45.25           C  
ATOM   1440  N   SER A 186      52.029  12.438   7.722  1.00 45.11           N  
ATOM   1441  CA  SER A 186      50.717  12.080   8.260  1.00 45.02           C  
ATOM   1442  C   SER A 186      50.525  12.400   9.749  1.00 44.96           C  
ATOM   1443  O   SER A 186      49.397  12.644  10.184  1.00 45.03           O  
ATOM   1444  CB  SER A 186      50.362  10.621   7.944  1.00 44.92           C  
ATOM   1445  OG  SER A 186      51.445   9.751   8.199  1.00 44.97           O  
ATOM   1446  N   ASN A 187      51.610  12.420  10.519  1.00 44.82           N  
ATOM   1447  CA  ASN A 187      51.521  12.741  11.948  1.00 44.82           C  
ATOM   1448  C   ASN A 187      51.641  14.232  12.269  1.00 44.78           C  
ATOM   1449  O   ASN A 187      51.390  14.653  13.401  1.00 44.69           O  
ATOM   1450  CB  ASN A 187      52.531  11.927  12.767  1.00 44.86           C  
ATOM   1451  CG  ASN A 187      52.031  10.528  13.099  1.00 45.09           C  
ATOM   1452  OD1 ASN A 187      50.891  10.351  13.529  1.00 44.96           O  
ATOM   1453  ND2 ASN A 187      52.892   9.528  12.916  1.00 44.53           N  
ATOM   1454  N   TRP A 188      52.016  15.026  11.269  1.00 44.79           N  
ATOM   1455  CA  TRP A 188      52.171  16.469  11.444  1.00 44.75           C  
ATOM   1456  C   TRP A 188      50.816  17.163  11.418  1.00 44.93           C  
ATOM   1457  O   TRP A 188      49.886  16.705  10.751  1.00 45.04           O  
ATOM   1458  CB  TRP A 188      53.061  17.055  10.347  1.00 44.36           C  
ATOM   1459  CG  TRP A 188      54.491  16.571  10.333  1.00 44.22           C  
ATOM   1460  CD1 TRP A 188      54.923  15.283  10.174  1.00 43.43           C  
ATOM   1461  CD2 TRP A 188      55.673  17.380  10.433  1.00 43.50           C  
ATOM   1462  NE1 TRP A 188      56.295  15.239  10.188  1.00 43.49           N  
ATOM   1463  CE2 TRP A 188      56.782  16.509  10.345  1.00 43.43           C  
ATOM   1464  CE3 TRP A 188      55.902  18.750  10.602  1.00 43.23           C  
ATOM   1465  CZ2 TRP A 188      58.104  16.965  10.416  1.00 43.57           C  
ATOM   1466  CZ3 TRP A 188      57.213  19.203  10.676  1.00 43.64           C  
ATOM   1467  CH2 TRP A 188      58.299  18.311  10.580  1.00 43.47           C  
ATOM   1468  N   THR A 189      50.709  18.266  12.150  1.00 45.20           N  
ATOM   1469  CA  THR A 189      49.504  19.089  12.136  1.00 45.57           C  
ATOM   1470  C   THR A 189      49.791  20.409  11.418  1.00 45.82           C  
ATOM   1471  O   THR A 189      50.951  20.731  11.145  1.00 45.86           O  
ATOM   1472  CB  THR A 189      48.964  19.356  13.565  1.00 45.56           C  
ATOM   1473  OG1 THR A 189      49.940  20.072  14.336  1.00 45.63           O  
ATOM   1474  CG2 THR A 189      48.626  18.052  14.272  1.00 45.49           C  
ATOM   1475  N   GLU A 190      48.737  21.158  11.104  1.00 46.05           N  
ATOM   1476  CA  GLU A 190      48.880  22.481  10.493  1.00 46.38           C  
ATOM   1477  C   GLU A 190      49.876  23.349  11.259  1.00 46.28           C  
ATOM   1478  O   GLU A 190      50.689  24.052  10.657  1.00 46.36           O  
ATOM   1479  CB  GLU A 190      47.524  23.189  10.410  1.00 46.56           C  
ATOM   1480  CG  GLU A 190      46.781  22.996   9.093  1.00 47.42           C  
ATOM   1481  CD  GLU A 190      47.030  24.121   8.096  1.00 48.04           C  
ATOM   1482  OE1 GLU A 190      47.024  25.303   8.506  1.00 48.04           O  
ATOM   1483  OE2 GLU A 190      47.216  23.823   6.897  1.00 48.29           O  
ATOM   1484  N   LEU A 191      49.805  23.286  12.587  1.00 46.18           N  
ATOM   1485  CA  LEU A 191      50.696  24.045  13.458  1.00 46.07           C  
ATOM   1486  C   LEU A 191      52.134  23.534  13.371  1.00 45.98           C  
ATOM   1487  O   LEU A 191      53.068  24.330  13.305  1.00 45.81           O  
ATOM   1488  CB  LEU A 191      50.192  23.995  14.905  1.00 46.15           C  
ATOM   1489  CG  LEU A 191      50.918  24.831  15.961  1.00 46.15           C  
ATOM   1490  CD1 LEU A 191      50.506  26.291  15.876  1.00 46.58           C  
ATOM   1491  CD2 LEU A 191      50.638  24.279  17.352  1.00 46.40           C  
ATOM   1492  N   ASP A 192      52.301  22.213  13.366  1.00 45.91           N  
ATOM   1493  CA  ASP A 192      53.620  21.594  13.249  1.00 45.86           C  
ATOM   1494  C   ASP A 192      54.372  22.089  12.011  1.00 45.84           C  
ATOM   1495  O   ASP A 192      55.535  22.488  12.108  1.00 45.78           O  
ATOM   1496  CB  ASP A 192      53.510  20.065  13.228  1.00 45.83           C  
ATOM   1497  CG  ASP A 192      52.989  19.488  14.539  1.00 46.25           C  
ATOM   1498  OD1 ASP A 192      53.382  19.974  15.622  1.00 46.74           O  
ATOM   1499  OD2 ASP A 192      52.189  18.529  14.486  1.00 46.21           O  
ATOM   1500  N   ILE A 193      53.695  22.081  10.862  1.00 45.70           N  
ATOM   1501  CA  ILE A 193      54.289  22.481   9.584  1.00 45.64           C  
ATOM   1502  C   ILE A 193      54.814  23.918   9.570  1.00 45.76           C  
ATOM   1503  O   ILE A 193      55.983  24.149   9.251  1.00 45.76           O  
ATOM   1504  CB  ILE A 193      53.329  22.207   8.390  1.00 45.55           C  
ATOM   1505  CG1 ILE A 193      53.730  20.918   7.676  1.00 45.40           C  
ATOM   1506  CG2 ILE A 193      53.352  23.332   7.368  1.00 45.06           C  
ATOM   1507  CD1 ILE A 193      53.178  19.683   8.298  1.00 45.23           C  
ATOM   1508  N   TRP A 194      53.957  24.874   9.921  1.00 45.83           N  
ATOM   1509  CA  TRP A 194      54.342  26.283   9.940  1.00 45.93           C  
ATOM   1510  C   TRP A 194      55.468  26.520  10.939  1.00 46.11           C  
ATOM   1511  O   TRP A 194      56.431  27.229  10.646  1.00 46.23           O  
ATOM   1512  CB  TRP A 194      53.138  27.168  10.268  1.00 45.88           C  
ATOM   1513  CG  TRP A 194      52.127  27.262   9.160  1.00 45.88           C  
ATOM   1514  CD1 TRP A 194      50.876  26.720   9.147  1.00 45.77           C  
ATOM   1515  CD2 TRP A 194      52.280  27.944   7.906  1.00 45.88           C  
ATOM   1516  NE1 TRP A 194      50.238  27.020   7.967  1.00 46.00           N  
ATOM   1517  CE2 TRP A 194      51.077  27.771   7.186  1.00 45.98           C  
ATOM   1518  CE3 TRP A 194      53.315  28.687   7.322  1.00 45.88           C  
ATOM   1519  CZ2 TRP A 194      50.879  28.311   5.910  1.00 45.69           C  
ATOM   1520  CZ3 TRP A 194      53.117  29.224   6.051  1.00 45.64           C  
ATOM   1521  CH2 TRP A 194      51.909  29.031   5.362  1.00 45.60           C  
ATOM   1522  N   GLN A 195      55.338  25.901  12.110  1.00 46.37           N  
ATOM   1523  CA  GLN A 195      56.355  25.940  13.158  1.00 46.65           C  
ATOM   1524  C   GLN A 195      57.687  25.375  12.656  1.00 46.52           C  
ATOM   1525  O   GLN A 195      58.757  25.864  13.026  1.00 46.59           O  
ATOM   1526  CB  GLN A 195      55.862  25.159  14.383  1.00 46.81           C  
ATOM   1527  CG  GLN A 195      56.663  25.364  15.663  1.00 48.02           C  
ATOM   1528  CD  GLN A 195      56.301  26.641  16.390  1.00 49.83           C  
ATOM   1529  OE1 GLN A 195      55.490  26.628  17.318  1.00 51.19           O  
ATOM   1530  NE2 GLN A 195      56.896  27.754  15.973  1.00 50.35           N  
ATOM   1531  N   TYR A 196      57.611  24.349  11.811  1.00 46.32           N  
ATOM   1532  CA  TYR A 196      58.796  23.764  11.194  1.00 46.10           C  
ATOM   1533  C   TYR A 196      59.352  24.685  10.114  1.00 46.15           C  
ATOM   1534  O   TYR A 196      60.565  24.877  10.025  1.00 46.24           O  
ATOM   1535  CB  TYR A 196      58.472  22.390  10.607  1.00 45.84           C  
ATOM   1536  CG  TYR A 196      59.679  21.585  10.187  1.00 45.74           C  
ATOM   1537  CD1 TYR A 196      60.542  21.033  11.134  1.00 45.57           C  
ATOM   1538  CD2 TYR A 196      59.948  21.354   8.842  1.00 45.41           C  
ATOM   1539  CE1 TYR A 196      61.647  20.286  10.750  1.00 44.87           C  
ATOM   1540  CE2 TYR A 196      61.050  20.609   8.446  1.00 44.76           C  
ATOM   1541  CZ  TYR A 196      61.893  20.079   9.404  1.00 44.74           C  
ATOM   1542  OH  TYR A 196      62.985  19.340   9.015  1.00 44.75           O  
ATOM   1543  N   ILE A 197      58.463  25.259   9.306  1.00 46.12           N  
ATOM   1544  CA  ILE A 197      58.858  26.190   8.252  1.00 46.01           C  
ATOM   1545  C   ILE A 197      59.590  27.391   8.845  1.00 46.07           C  
ATOM   1546  O   ILE A 197      60.634  27.799   8.335  1.00 46.18           O  
ATOM   1547  CB  ILE A 197      57.648  26.657   7.401  1.00 46.01           C  
ATOM   1548  CG1 ILE A 197      57.101  25.496   6.566  1.00 45.57           C  
ATOM   1549  CG2 ILE A 197      58.038  27.826   6.487  1.00 45.81           C  
ATOM   1550  CD1 ILE A 197      55.743  25.760   5.945  1.00 45.18           C  
ATOM   1551  N   TYR A 198      59.046  27.932   9.934  1.00 46.03           N  
ATOM   1552  CA  TYR A 198      59.621  29.094  10.610  1.00 45.97           C  
ATOM   1553  C   TYR A 198      61.013  28.829  11.191  1.00 46.10           C  
ATOM   1554  O   TYR A 198      61.929  29.630  11.002  1.00 46.18           O  
ATOM   1555  CB  TYR A 198      58.674  29.611  11.700  1.00 45.85           C  
ATOM   1556  CG  TYR A 198      59.302  30.647  12.608  1.00 45.66           C  
ATOM   1557  CD1 TYR A 198      59.483  31.959  12.179  1.00 45.48           C  
ATOM   1558  CD2 TYR A 198      59.724  30.311  13.893  1.00 45.56           C  
ATOM   1559  CE1 TYR A 198      60.068  32.909  13.004  1.00 45.58           C  
ATOM   1560  CE2 TYR A 198      60.309  31.255  14.725  1.00 45.64           C  
ATOM   1561  CZ  TYR A 198      60.477  32.551  14.274  1.00 45.49           C  
ATOM   1562  OH  TYR A 198      61.053  33.489  15.096  1.00 45.72           O  
ATOM   1563  N   LEU A 199      61.163  27.711  11.899  1.00 46.25           N  
ATOM   1564  CA  LEU A 199      62.418  27.388  12.578  1.00 46.26           C  
ATOM   1565  C   LEU A 199      63.526  26.953  11.623  1.00 46.34           C  
ATOM   1566  O   LEU A 199      64.703  27.178  11.903  1.00 46.30           O  
ATOM   1567  CB  LEU A 199      62.195  26.320  13.653  1.00 46.25           C  
ATOM   1568  CG  LEU A 199      61.519  26.745  14.963  1.00 46.16           C  
ATOM   1569  CD1 LEU A 199      61.007  25.531  15.723  1.00 45.41           C  
ATOM   1570  CD2 LEU A 199      62.458  27.572  15.837  1.00 46.12           C  
ATOM   1571  N   GLU A 200      63.150  26.334  10.507  1.00 46.55           N  
ATOM   1572  CA  GLU A 200      64.117  25.838   9.526  1.00 46.85           C  
ATOM   1573  C   GLU A 200      64.467  26.879   8.463  1.00 47.26           C  
ATOM   1574  O   GLU A 200      65.493  26.769   7.790  1.00 47.27           O  
ATOM   1575  CB  GLU A 200      63.602  24.563   8.848  1.00 46.73           C  
ATOM   1576  CG  GLU A 200      63.308  23.398   9.794  1.00 46.36           C  
ATOM   1577  CD  GLU A 200      64.555  22.804  10.422  1.00 45.42           C  
ATOM   1578  OE1 GLU A 200      65.486  22.433   9.676  1.00 44.55           O  
ATOM   1579  OE2 GLU A 200      64.595  22.701  11.666  1.00 45.42           O  
ATOM   1580  N   GLY A 201      63.610  27.886   8.318  1.00 47.73           N  
ATOM   1581  CA  GLY A 201      63.781  28.900   7.284  1.00 48.32           C  
ATOM   1582  C   GLY A 201      63.584  28.330   5.893  1.00 48.76           C  
ATOM   1583  O   GLY A 201      64.349  28.630   4.976  1.00 48.78           O  
ATOM   1584  N   ILE A 202      62.564  27.491   5.745  1.00 49.29           N  
ATOM   1585  CA  ILE A 202      62.211  26.913   4.455  1.00 49.77           C  
ATOM   1586  C   ILE A 202      61.569  27.995   3.587  1.00 50.33           C  
ATOM   1587  O   ILE A 202      60.592  28.619   4.005  1.00 50.32           O  
ATOM   1588  CB  ILE A 202      61.259  25.702   4.621  1.00 49.63           C  
ATOM   1589  CG1 ILE A 202      61.953  24.589   5.413  1.00 49.57           C  
ATOM   1590  CG2 ILE A 202      60.802  25.178   3.260  1.00 49.50           C  
ATOM   1591  CD1 ILE A 202      61.019  23.697   6.201  1.00 49.29           C  
ATOM   1592  N   PRO A 203      62.138  28.246   2.392  1.00 50.91           N  
ATOM   1593  CA  PRO A 203      61.561  29.220   1.467  1.00 51.41           C  
ATOM   1594  C   PRO A 203      60.127  28.857   1.093  1.00 51.88           C  
ATOM   1595  O   PRO A 203      59.816  27.681   0.883  1.00 51.79           O  
ATOM   1596  CB  PRO A 203      62.479  29.132   0.242  1.00 51.41           C  
ATOM   1597  CG  PRO A 203      63.768  28.611   0.773  1.00 51.22           C  
ATOM   1598  CD  PRO A 203      63.369  27.645   1.851  1.00 51.01           C  
ATOM   1599  N   ILE A 204      59.269  29.872   1.023  1.00 52.44           N  
ATOM   1600  CA  ILE A 204      57.838  29.674   0.800  1.00 53.09           C  
ATOM   1601  C   ILE A 204      57.254  30.724  -0.156  1.00 53.49           C  
ATOM   1602  O   ILE A 204      57.701  31.875  -0.178  1.00 53.56           O  
ATOM   1603  CB  ILE A 204      57.059  29.613   2.155  1.00 53.11           C  
ATOM   1604  CG1 ILE A 204      55.568  29.344   1.941  1.00 53.42           C  
ATOM   1605  CG2 ILE A 204      57.281  30.872   2.994  1.00 53.18           C  
ATOM   1606  CD1 ILE A 204      55.258  27.915   1.549  1.00 54.30           C  
ATOM   1607  N   VAL A 205      56.273  30.305  -0.953  1.00 53.90           N  
ATOM   1608  CA  VAL A 205      55.586  31.179  -1.907  1.00 54.32           C  
ATOM   1609  C   VAL A 205      54.953  32.374  -1.183  1.00 54.69           C  
ATOM   1610  O   VAL A 205      54.225  32.184  -0.207  1.00 54.76           O  
ATOM   1611  CB  VAL A 205      54.511  30.396  -2.705  1.00 54.26           C  
ATOM   1612  CG1 VAL A 205      53.840  31.283  -3.747  1.00 54.31           C  
ATOM   1613  CG2 VAL A 205      55.124  29.173  -3.374  1.00 54.23           C  
ATOM   1614  N   PRO A 206      55.244  33.607  -1.649  1.00 55.05           N  
ATOM   1615  CA  PRO A 206      54.781  34.862  -1.044  1.00 55.36           C  
ATOM   1616  C   PRO A 206      53.306  34.916  -0.631  1.00 55.72           C  
ATOM   1617  O   PRO A 206      52.959  35.675   0.276  1.00 55.76           O  
ATOM   1618  CB  PRO A 206      55.059  35.892  -2.139  1.00 55.37           C  
ATOM   1619  CG  PRO A 206      56.258  35.361  -2.829  1.00 55.20           C  
ATOM   1620  CD  PRO A 206      56.099  33.863  -2.824  1.00 55.09           C  
ATOM   1621  N   LEU A 207      52.452  34.133  -1.285  1.00 56.17           N  
ATOM   1622  CA  LEU A 207      51.044  34.032  -0.901  1.00 56.72           C  
ATOM   1623  C   LEU A 207      50.916  33.188   0.365  1.00 57.12           C  
ATOM   1624  O   LEU A 207      51.451  32.080   0.432  1.00 57.18           O  
ATOM   1625  CB  LEU A 207      50.220  33.413  -2.034  1.00 56.69           C  
ATOM   1626  CG  LEU A 207      50.280  34.069  -3.418  1.00 57.04           C  
ATOM   1627  CD1 LEU A 207      50.018  33.038  -4.505  1.00 57.35           C  
ATOM   1628  CD2 LEU A 207      49.318  35.250  -3.541  1.00 56.84           C  
ATOM   1629  N   TYR A 208      50.213  33.708   1.368  1.00 57.61           N  
ATOM   1630  CA  TYR A 208      50.138  33.036   2.669  1.00 58.11           C  
ATOM   1631  C   TYR A 208      48.828  32.285   2.934  1.00 58.37           C  
ATOM   1632  O   TYR A 208      48.531  31.922   4.077  1.00 58.33           O  
ATOM   1633  CB  TYR A 208      50.463  34.013   3.806  1.00 58.20           C  
ATOM   1634  CG  TYR A 208      51.936  34.339   3.920  1.00 58.44           C  
ATOM   1635  CD1 TYR A 208      52.825  33.439   4.507  1.00 58.80           C  
ATOM   1636  CD2 TYR A 208      52.442  35.548   3.441  1.00 58.71           C  
ATOM   1637  CE1 TYR A 208      54.182  33.732   4.613  1.00 58.82           C  
ATOM   1638  CE2 TYR A 208      53.798  35.850   3.542  1.00 58.69           C  
ATOM   1639  CZ  TYR A 208      54.658  34.937   4.128  1.00 58.86           C  
ATOM   1640  OH  TYR A 208      56.000  35.222   4.234  1.00 58.91           O  
ATOM   1641  N   PHE A 209      48.061  32.037   1.874  1.00 58.68           N  
ATOM   1642  CA  PHE A 209      46.829  31.253   1.977  1.00 58.97           C  
ATOM   1643  C   PHE A 209      46.934  29.913   1.248  1.00 59.06           C  
ATOM   1644  O   PHE A 209      47.326  29.867   0.078  1.00 59.12           O  
ATOM   1645  CB  PHE A 209      45.610  32.058   1.497  1.00 59.08           C  
ATOM   1646  CG  PHE A 209      45.718  32.574   0.084  1.00 59.41           C  
ATOM   1647  CD1 PHE A 209      45.145  31.873  -0.974  1.00 59.78           C  
ATOM   1648  CD2 PHE A 209      46.361  33.777  -0.186  1.00 59.65           C  
ATOM   1649  CE1 PHE A 209      45.230  32.350  -2.279  1.00 59.91           C  
ATOM   1650  CE2 PHE A 209      46.451  34.263  -1.488  1.00 59.87           C  
ATOM   1651  CZ  PHE A 209      45.885  33.547  -2.537  1.00 59.90           C  
ATOM   1652  N   ALA A 210      46.588  28.837   1.959  1.00 59.08           N  
ATOM   1653  CA  ALA A 210      46.621  27.465   1.437  1.00 59.03           C  
ATOM   1654  C   ALA A 210      46.313  27.397  -0.058  1.00 59.10           C  
ATOM   1655  O   ALA A 210      45.226  27.777  -0.499  1.00 59.13           O  
ATOM   1656  CB  ALA A 210      45.666  26.578   2.222  1.00 58.97           C  
ATOM   1657  N   ALA A 211      47.286  26.920  -0.829  1.00 59.13           N  
ATOM   1658  CA  ALA A 211      47.224  26.963  -2.287  1.00 59.20           C  
ATOM   1659  C   ALA A 211      46.187  25.996  -2.851  1.00 59.21           C  
ATOM   1660  O   ALA A 211      46.486  24.835  -3.130  1.00 59.34           O  
ATOM   1661  CB  ALA A 211      48.604  26.694  -2.880  1.00 59.16           C  
TER    1662      ALA A 211                                                      
END
MOLECULE T0395.pdb
ATOM     25  N   MET     1      71.981  24.696  -5.737  1.00 15.20           N   
ATOM     26  CA  MET     1      72.852  23.731  -5.062  1.00 16.24           C   
ATOM     27  CB  MET     1      72.338  23.440  -3.637  1.00 16.10           C   
ATOM     28  CG  MET     1      72.512  24.631  -2.710  1.00 19.35           C   
ATOM     29  SD  MET     1      71.907  24.357  -1.057  1.00 17.91           S   
ATOM     30  CE  MET     1      70.123  24.299  -1.343  1.00 20.07           C   
ATOM     31  C   MET     1      72.831  22.441  -5.847  1.00 15.56           C   
ATOM     32  O   MET     1      71.749  21.971  -6.234  1.00 16.92           O   
ATOM     33  N   ARG     2      73.999  21.824  -6.020  1.00 15.98           N   
ATOM     34  CA  ARG     2      74.045  20.439  -6.481  1.00 15.91           C   
ATOM     35  CB  ARG     2      75.480  19.954  -6.636  1.00 18.66           C   
ATOM     36  CG  ARG     2      76.169  20.567  -7.887  1.00 24.26           C   
ATOM     37  CD  ARG     2      77.645  20.106  -8.004  1.00 29.52           C   
ATOM     38  NE  ARG     2      77.727  18.696  -8.407  1.00 37.96           N   
ATOM     39  CZ  ARG     2      78.859  18.014  -8.595  1.00 41.43           C   
ATOM     40  NH1 ARG     2      80.043  18.598  -8.429  1.00 43.27           N   
ATOM     41  NH2 ARG     2      78.804  16.738  -8.954  1.00 44.65           N   
ATOM     42  C   ARG     2      73.332  19.553  -5.477  1.00 14.90           C   
ATOM     43  O   ARG     2      73.238  19.876  -4.277  1.00 15.50           O   
ATOM     44  N   LEU     3      72.830  18.435  -5.959  1.00 17.05           N   
ATOM     45  CA  LEU     3      71.928  17.633  -5.139  1.00 16.55           C   
ATOM     46  CB  LEU     3      71.438  16.415  -5.936  1.00 17.75           C   
ATOM     47  CG  LEU     3      70.380  15.549  -5.257  1.00 17.89           C   
ATOM     48  CD1 LEU     3      69.155  16.343  -4.848  1.00 18.51           C   
ATOM     49  CD2 LEU     3      70.006  14.358  -6.133  1.00 19.29           C   
ATOM     50  C   LEU     3      72.587  17.201  -3.813  1.00 16.67           C   
ATOM     51  O   LEU     3      71.963  17.257  -2.753  1.00 15.82           O   
ATOM     52  N   GLY     4      73.844  16.775  -3.859  1.00 16.61           N   
ATOM     53  CA  GLY     4      74.530  16.365  -2.635  1.00 17.85           C   
ATOM     54  C   GLY     4      74.678  17.493  -1.627  1.00 16.62           C   
ATOM     55  O   GLY     4      74.519  17.281  -0.402  1.00 16.49           O   
ATOM     56  N   ASP     5      75.012  18.698  -2.099  1.00 16.22           N   
ATOM     57  CA  ASP     5      75.082  19.849  -1.211  1.00 15.73           C   
ATOM     58  CB  ASP     5      75.644  21.074  -1.941  1.00 17.18           C   
ATOM     59  CG  ASP     5      77.130  20.988  -2.196  1.00 19.91           C   
ATOM     60  OD1 ASP     5      77.877  20.226  -1.540  1.00 21.83           O   
ATOM     61  OD2 ASP     5      77.568  21.737  -3.107  1.00 23.61           O   
ATOM     62  C   ASP     5      73.716  20.179  -0.643  1.00 13.88           C   
ATOM     63  O   ASP     5      73.602  20.575   0.534  1.00 15.01           O   
ATOM     64  N   ALA     6      72.676  20.066  -1.475  1.00 14.07           N   
ATOM     65  CA  ALA     6      71.317  20.288  -0.958  1.00 14.21           C   
ATOM     66  CB  ALA     6      70.296  20.240  -2.099  1.00 14.63           C   
ATOM     67  C   ALA     6      70.959  19.278   0.134  1.00 12.87           C   
ATOM     68  O   ALA     6      70.388  19.645   1.182  1.00 13.54           O   
ATOM     69  N   ALA     7      71.267  18.011  -0.119  1.00 13.49           N   
ATOM     70  CA  ALA     7      70.939  16.960   0.861  1.00 13.71           C   
ATOM     71  CB  ALA     7      71.230  15.608   0.253  1.00 14.33           C   
ATOM     72  C   ALA     7      71.720  17.181   2.161  1.00 13.43           C   
ATOM     73  O   ALA     7      71.168  17.065   3.256  1.00 13.51           O   
ATOM     74  N   GLU     8      73.000  17.543   2.053  1.00 13.88           N   
ATOM     75  CA  GLU     8      73.802  17.789   3.255  1.00 14.84           C   
ATOM     76  CB  GLU     8      75.252  18.012   2.851  1.00 15.93           C   
ATOM     77  CG  GLU     8      76.137  18.140   4.112  1.00 19.48           C   
ATOM     78  CD  GLU     8      77.620  18.104   3.837  1.00 25.10           C   
ATOM     79  OE1 GLU     8      78.031  18.312   2.676  1.00 25.37           O   
ATOM     80  OE2 GLU     8      78.378  17.855   4.810  1.00 27.80           O   
ATOM     81  C   GLU     8      73.275  18.984   4.038  1.00 13.49           C   
ATOM     82  O   GLU     8      73.217  18.945   5.269  1.00 14.51           O   
ATOM     83  N   LEU     9      72.912  20.058   3.335  1.00 13.71           N   
ATOM     84  CA  LEU     9      72.319  21.211   3.971  1.00 13.18           C   
ATOM     85  CB  LEU     9      71.937  22.264   2.933  1.00 14.38           C   
ATOM     86  CG  LEU     9      71.004  23.364   3.447  1.00 15.57           C   
ATOM     87  CD1 LEU     9      71.574  24.221   4.579  1.00 17.65           C   
ATOM     88  CD2 LEU     9      70.524  24.234   2.285  1.00 17.32           C   
ATOM     89  C   LEU     9      71.081  20.795   4.752  1.00 13.49           C   
ATOM     90  O   LEU     9      70.891  21.158   5.899  1.00 13.58           O   
ATOM     91  N   CYS    10      70.231  19.998   4.109  1.00 12.70           N   
ATOM     92  CA  CYS    10      68.964  19.624   4.753  1.00 13.13           C   
ATOM     93  CB  CYS    10      68.067  18.901   3.763  1.00 12.86           C   
ATOM     94  SG  CYS    10      67.356  20.091   2.543  1.00 13.12           S   
ATOM     95  C   CYS    10      69.211  18.747   5.974  1.00 13.20           C   
ATOM     96  O   CYS    10      68.536  18.878   6.998  1.00 13.30           O   
ATOM     97  N   TYR    11      70.191  17.853   5.861  1.00 13.04           N   
ATOM     98  CA  TYR    11      70.615  17.069   7.027  1.00 13.73           C   
ATOM     99  CB  TYR    11      71.675  16.076   6.601  1.00 15.41           C   
ATOM    100  CG  TYR    11      72.182  15.277   7.781  1.00 16.94           C   
ATOM    101  CD1 TYR    11      71.427  14.226   8.291  1.00 17.42           C   
ATOM    102  CE1 TYR    11      71.867  13.496   9.395  1.00 20.14           C   
ATOM    103  CZ  TYR    11      73.063  13.844   9.972  1.00 20.78           C   
ATOM    104  OH  TYR    11      73.501  13.114  11.072  1.00 23.58           O   
ATOM    105  CE2 TYR    11      73.854  14.867   9.507  1.00 19.48           C   
ATOM    106  CD2 TYR    11      73.398  15.597   8.397  1.00 16.80           C   
ATOM    107  C   TYR    11      71.092  17.958   8.165  1.00 13.70           C   
ATOM    108  O   TYR    11      70.742  17.750   9.337  1.00 14.26           O   
ATOM    109  N   ASN    12      71.918  18.942   7.841  1.00 13.20           N   
ATOM    110  CA  ASN    12      72.442  19.816   8.861  1.00 14.73           C   
ATOM    111  CB  ASN    12      73.561  20.664   8.264  1.00 16.76           C   
ATOM    112  CG  ASN    12      74.818  19.849   7.961  1.00 17.09           C   
ATOM    113  OD1 ASN    12      75.081  18.808   8.520  1.00 20.10           O   
ATOM    114  ND2 ASN    12      75.629  20.391   7.030  1.00 20.98           N   
ATOM    115  C   ASN    12      71.391  20.691   9.519  1.00 13.85           C   
ATOM    116  O   ASN    12      71.374  20.822  10.736  1.00 15.21           O   
ATOM    117  N   LEU    13      70.464  21.262   8.748  1.00 14.11           N   
ATOM    118  CA  LEU    13      69.453  22.105   9.372  1.00 14.16           C   
ATOM    119  CB  LEU    13      68.772  23.070   8.379  1.00 14.88           C   
ATOM    120  CG  LEU    13      67.859  22.467   7.322  1.00 14.89           C   
ATOM    121  CD1 LEU    13      66.425  22.330   7.907  1.00 16.24           C   
ATOM    122  CD2 LEU    13      67.823  23.360   6.082  1.00 16.86           C   
ATOM    123  C   LEU    13      68.466  21.255  10.182  1.00 14.22           C   
ATOM    124  O   LEU    13      67.978  21.692  11.226  1.00 14.17           O   
ATOM    125  N   THR    14      68.179  20.035   9.718  1.00 13.12           N   
ATOM    126  CA  THR    14      67.267  19.144  10.449  1.00 14.22           C   
ATOM    127  CB  THR    14      66.863  17.954   9.579  1.00 14.04           C   
ATOM    128  OG1 THR    14      66.203  18.454   8.380  1.00 14.17           O   
ATOM    129  CG2 THR    14      65.902  17.037  10.311  1.00 15.28           C   
ATOM    130  C   THR    14      67.912  18.707  11.781  1.00 13.88           C   
ATOM    131  O   THR    14      67.277  18.738  12.842  1.00 13.89           O   
ATOM    132  N   SER    15      69.175  18.335  11.710  1.00 14.23           N   
ATOM    133  CA  SER    15      69.920  17.991  12.911  1.00 15.08           C   
ATOM    134  CB  SER    15      71.325  17.560  12.503  1.00 16.38           C   
ATOM    135  OG  SER    15      71.339  16.341  11.806  1.00 20.10           O   
ATOM    136  C   SER    15      69.991  19.161  13.892  1.00 14.26           C   
ATOM    137  O   SER    15      69.867  18.980  15.106  1.00 15.63           O   
ATOM    138  N   SER    16      70.191  20.359  13.362  1.00 14.48           N   
ATOM    139  CA  SER    16      70.238  21.558  14.182  1.00 14.50           C   
ATOM    140  CB  SER    16      70.686  22.763  13.348  1.00 15.97           C   
ATOM    141  OG  SER    16      70.718  23.937  14.130  0.60 17.71           O   
ATOM    143  C   SER    16      68.888  21.781  14.847  1.00 14.20           C   
ATOM    144  O   SER    16      68.805  22.089  16.064  1.00 15.36           O   
ATOM    145  N   TYR    17      67.797  21.594  14.104  1.00 12.96           N   
ATOM    146  CA  TYR    17      66.481  21.751  14.718  1.00 12.36           C   
ATOM    147  CB  TYR    17      65.364  21.530  13.644  1.00 12.65           C   
ATOM    148  CG  TYR    17      63.994  21.931  14.163  1.00 11.48           C   
ATOM    149  CD1 TYR    17      63.453  23.184  13.899  1.00 12.41           C   
ATOM    150  CE1 TYR    17      62.217  23.577  14.413  1.00 12.00           C   
ATOM    151  CZ  TYR    17      61.527  22.669  15.243  1.00 11.56           C   
ATOM    152  OH  TYR    17      60.331  22.993  15.806  1.00 11.82           O   
ATOM    153  CE2 TYR    17      62.045  21.422  15.504  1.00 11.79           C   
ATOM    154  CD2 TYR    17      63.244  21.046  14.967  1.00 11.76           C   
ATOM    155  C   TYR    17      66.279  20.745  15.871  1.00 12.97           C   
ATOM    156  O   TYR    17      65.759  21.091  16.950  1.00 13.96           O   
ATOM    157  N   LEU    18      66.730  19.514  15.646  1.00 13.46           N   
ATOM    158  CA  LEU    18      66.617  18.455  16.664  1.00 15.21           C   
ATOM    159  CB  LEU    18      66.996  17.116  16.085  1.00 14.47           C   
ATOM    160  CG  LEU    18      65.964  16.564  15.093  1.00 14.00           C   
ATOM    161  CD1 LEU    18      66.529  15.300  14.459  1.00 17.38           C   
ATOM    162  CD2 LEU    18      64.650  16.220  15.806  1.00 15.37           C   
ATOM    163  C   LEU    18      67.447  18.735  17.902  1.00 16.58           C   
ATOM    164  O   LEU    18      67.165  18.171  18.964  1.00 16.41           O   
ATOM    165  N   GLN    19      68.425  19.626  17.783  1.00 17.01           N   
ATOM    166  CA  GLN    19      69.250  20.038  18.925  1.00 17.35           C   
ATOM    167  CB  GLN    19      70.677  20.288  18.438  1.00 20.45           C   
ATOM    168  CG  GLN    19      71.384  19.057  17.934  1.00 24.12           C   
ATOM    169  CD  GLN    19      72.623  19.391  17.096  1.00 32.01           C   
ATOM    170  OE1 GLN    19      73.070  20.553  17.046  1.00 36.23           O   
ATOM    171  NE2 GLN    19      73.172  18.374  16.417  1.00 35.60           N   
ATOM    172  C   GLN    19      68.721  21.265  19.636  1.00 22.69           C   
ATOM    173  O   GLN    19      69.229  21.593  20.595  1.00 27.71           O   
ATOM    174  N   ILE    20      67.651  21.898  19.215  1.00 16.53           N   
ATOM    175  CA  ILE    20      67.075  23.045  19.933  1.00 16.80           C   
ATOM    176  CB  ILE    20      65.881  23.722  19.151  1.00 16.18           C   
ATOM    177  CG1 ILE    20      66.289  24.233  17.743  1.00 15.78           C   
ATOM    178  CD1 ILE    20      65.057  24.495  16.852  1.00 16.10           C   
ATOM    179  CG2 ILE    20      65.223  24.871  19.978  1.00 18.45           C   
ATOM    180  C   ILE    20      66.513  22.863  21.342  0.50 14.19           C   
ATOM    182  O   ILE    20      65.732  21.954  21.575  0.50 13.19           O   
ATOM    184  N   ALA    21      66.838  23.784  22.254  0.50 13.96           N   
ATOM    186  CA  ALA    21      66.418  23.663  23.643  0.50 12.99           C   
ATOM    188  CB  ALA    21      67.308  24.554  24.530  0.50 17.22           C   
ATOM    190  C   ALA    21      64.969  24.053  23.778  0.50 15.24           C   
ATOM    192  O   ALA    21      64.585  25.194  23.525  0.50 17.19           O   
ATOM    194  N   ALA    22      64.159  23.100  24.195  0.50 14.46           N   
ATOM    196  CA  ALA    22      62.765  23.331  24.322  0.50 15.96           C   
ATOM    198  CB  ALA    22      62.057  23.113  22.974  0.50 15.83           C   
ATOM    200  C   ALA    22      62.235  22.384  25.380  0.50 16.70           C   
ATOM    202  O   ALA    22      62.779  21.340  25.688  0.50 17.47           O   
ATOM    204  N   GLU    23      61.136  22.779  25.918  1.00 17.40           N   
ATOM    205  CA  GLU    23      60.484  22.018  26.969  0.50 16.70           C   
ATOM    207  CB  GLU    23      59.949  22.938  28.065  0.50 18.56           C   
ATOM    209  CG  GLU    23      61.051  23.817  28.727  0.50 19.91           C   
ATOM    211  CD  GLU    23      61.863  23.077  29.789  0.50 20.26           C   
ATOM    213  OE1 GLU    23      61.232  22.270  30.506  0.50 24.47           O   
ATOM    215  OE2 GLU    23      63.093  23.340  29.990  0.50 21.80           O   
ATOM    217  C   GLU    23      59.371  21.164  26.397  1.00 16.48           C   
ATOM    218  O   GLU    23      58.934  21.298  25.248  1.00 16.36           O   
ATOM    219  N   SER    24      58.967  20.187  27.210  1.00 17.31           N   
ATOM    220  CA  SER    24      58.189  19.055  26.737  1.00 18.00           C   
ATOM    221  CB  SER    24      58.128  17.960  27.818  1.00 20.56           C   
ATOM    222  OG  SER    24      57.414  18.451  28.931  1.00 22.04           O   
ATOM    223  C   SER    24      56.793  19.410  26.274  1.00 16.68           C   
ATOM    224  O   SER    24      56.203  18.649  25.520  1.00 21.29           O   
ATOM    225  N   ASP    25      56.274  20.561  26.684  1.00 15.13           N   
ATOM    226  CA  ASP    25      54.964  20.979  26.239  1.00 15.22           C   
ATOM    227  CB  ASP    25      54.111  21.422  27.393  1.00 18.35           C   
ATOM    228  CG  ASP    25      54.680  22.600  28.107  1.00 19.57           C   
ATOM    229  OD1 ASP    25      55.776  23.116  27.768  1.00 20.78           O   
ATOM    230  OD2 ASP    25      53.986  23.037  29.081  1.00 22.49           O   
ATOM    231  C   ASP    25      55.011  22.040  25.143  1.00 14.69           C   
ATOM    232  O   ASP    25      53.988  22.682  24.854  1.00 15.94           O   
ATOM    233  N   SER    26      56.158  22.155  24.464  1.00 13.24           N   
ATOM    234  CA  SER    26      56.304  23.194  23.459  1.00 12.78           C   
ATOM    235  CB  SER    26      57.701  23.778  23.484  1.00 13.63           C   
ATOM    236  OG  SER    26      58.676  22.834  23.074  1.00 14.26           O   
ATOM    237  C   SER    26      55.986  22.697  22.061  1.00 12.51           C   
ATOM    238  O   SER    26      56.055  21.491  21.772  1.00 12.06           O   
ATOM    239  N   ILE    27      55.685  23.639  21.187  1.00 12.50           N   
ATOM    240  CA  ILE    27      55.550  23.322  19.762  1.00 12.49           C   
ATOM    241  CB  ILE    27      55.071  24.547  18.962  1.00 11.99           C   
ATOM    242  CG1 ILE    27      53.643  24.927  19.331  1.00 13.13           C   
ATOM    243  CD1 ILE    27      53.256  26.326  18.888  1.00 14.84           C   
ATOM    244  CG2 ILE    27      55.177  24.280  17.446  1.00 13.57           C   
ATOM    245  C   ILE    27      56.867  22.803  19.195  1.00 11.26           C   
ATOM    246  O   ILE    27      56.856  21.859  18.397  1.00 11.61           O   
ATOM    247  N   ILE    28      58.007  23.374  19.600  1.00 11.80           N   
ATOM    248  CA  ILE    28      59.295  22.907  19.089  1.00 12.30           C   
ATOM    249  CB  ILE    28      60.454  23.793  19.527  1.00 12.56           C   
ATOM    250  CG1 ILE    28      60.389  25.127  18.802  1.00 13.63           C   
ATOM    251  CD1 ILE    28      61.273  26.200  19.410  1.00 15.47           C   
ATOM    252  CG2 ILE    28      61.778  23.103  19.278  1.00 13.71           C   
ATOM    253  C   ILE    28      59.504  21.438  19.465  1.00 11.36           C   
ATOM    254  O   ILE    28      59.876  20.625  18.625  1.00 11.92           O   
ATOM    255  N   ALA    29      59.257  21.063  20.733  1.00 11.84           N   
ATOM    256  CA  ALA    29      59.442  19.662  21.102  1.00 12.94           C   
ATOM    257  CB  ALA    29      59.233  19.478  22.616  1.00 13.70           C   
ATOM    258  C   ALA    29      58.495  18.738  20.327  1.00 11.68           C   
ATOM    259  O   ALA    29      58.911  17.666  19.893  1.00 11.63           O   
ATOM    260  N   GLN    30      57.247  19.160  20.127  1.00 11.53           N   
ATOM    261  CA  GLN    30      56.317  18.374  19.347  1.00 11.62           C   
ATOM    262  CB  GLN    30      54.957  19.045  19.369  1.00 11.76           C   
ATOM    263  CG  GLN    30      53.837  18.246  18.706  1.00 13.11           C   
ATOM    264  CD  GLN    30      52.591  19.085  18.574  1.00 13.54           C   
ATOM    265  OE1 GLN    30      52.589  20.112  17.907  1.00 15.78           O   
ATOM    266  NE2 GLN    30      51.514  18.673  19.246  1.00 14.73           N   
ATOM    267  C   GLN    30      56.811  18.193  17.887  1.00 11.43           C   
ATOM    268  O   GLN    30      56.664  17.126  17.299  1.00 11.11           O   
ATOM    269  N   THR    31      57.397  19.252  17.345  1.00 10.97           N   
ATOM    270  CA  THR    31      57.965  19.207  15.991  1.00 10.73           C   
ATOM    271  CB  THR    31      58.337  20.631  15.515  1.00 10.83           C   
ATOM    272  OG1 THR    31      57.209  21.481  15.663  1.00 11.65           O   
ATOM    273  CG2 THR    31      58.805  20.615  14.064  1.00 11.69           C   
ATOM    274  C   THR    31      59.161  18.266  15.937  1.00 10.78           C   
ATOM    275  O   THR    31      59.321  17.512  14.981  1.00 11.18           O   
ATOM    276  N   GLN    32      60.024  18.305  16.963  1.00 11.25           N   
ATOM    277  CA  GLN    32      61.110  17.351  17.034  1.00 11.25           C   
ATOM    278  CB  GLN    32      61.995  17.593  18.285  1.00 12.53           C   
ATOM    279  CG  GLN    32      62.675  18.967  18.213  1.00 13.31           C   
ATOM    280  CD  GLN    32      63.348  19.385  19.498  1.00 14.16           C   
ATOM    281  OE1 GLN    32      62.915  19.005  20.567  1.00 13.75           O   
ATOM    282  NE2 GLN    32      64.376  20.205  19.411  1.00 13.57           N   
ATOM    283  C   GLN    32      60.610  15.910  16.993  1.00 11.79           C   
ATOM    284  O   GLN    32      61.177  15.057  16.299  1.00 11.76           O   
ATOM    285  N   ARG    33      59.584  15.621  17.795  1.00 11.39           N   
ATOM    286  CA  ARG    33      58.989  14.300  17.775  1.00 12.14           C   
ATOM    287  CB  ARG    33      57.887  14.193  18.840  1.00 12.90           C   
ATOM    288  CG  ARG    33      58.453  14.344  20.278  1.00 13.48           C   
ATOM    289  CD  ARG    33      57.365  14.017  21.354  1.00 14.40           C   
ATOM    290  NE  ARG    33      56.147  14.825  21.317  1.00 14.43           N   
ATOM    291  CZ  ARG    33      55.965  15.977  21.955  1.00 14.55           C   
ATOM    292  NH1 ARG    33      56.983  16.562  22.583  1.00 15.11           N   
ATOM    293  NH2 ARG    33      54.784  16.565  21.932  1.00 14.11           N   
ATOM    294  C   ARG    33      58.448  13.930  16.384  1.00 12.43           C   
ATOM    295  O   ARG    33      58.628  12.786  15.927  1.00 12.45           O   
ATOM    296  N   ALA    34      57.827  14.898  15.716  1.00 11.37           N   
ATOM    297  CA  ALA    34      57.281  14.639  14.376  1.00 11.30           C   
ATOM    298  CB  ALA    34      56.477  15.840  13.926  1.00 11.61           C   
ATOM    299  C   ALA    34      58.418  14.359  13.386  1.00 11.34           C   
ATOM    300  O   ALA    34      58.283  13.461  12.524  1.00 11.55           O   
ATOM    301  N   ILE    35      59.529  15.080  13.520  1.00 11.13           N   
ATOM    302  CA  ILE    35      60.714  14.803  12.674  1.00 11.67           C   
ATOM    303  CB  ILE    35      61.823  15.852  12.920  1.00 11.53           C   
ATOM    304  CG1 ILE    35      61.380  17.230  12.444  1.00 12.18           C   
ATOM    305  CD1 ILE    35      62.247  18.394  12.977  1.00 14.43           C   
ATOM    306  CG2 ILE    35      63.146  15.403  12.311  1.00 13.68           C   
ATOM    307  C   ILE    35      61.232  13.405  12.881  1.00 11.84           C   
ATOM    308  O   ILE    35      61.539  12.674  11.932  1.00 12.40           O   
ATOM    309  N   ASN    36      61.347  12.995  14.146  1.00 12.29           N   
ATOM    310  CA  ASN    36      61.830  11.653  14.425  1.00 13.73           C   
ATOM    311  CB  ASN    36      62.027  11.472  15.928  1.00 16.86           C   
ATOM    312  CG  ASN    36      63.219  12.257  16.440  1.00 20.83           C   
ATOM    313  OD1 ASN    36      64.176  12.476  15.713  1.00 24.42           O   
ATOM    314  ND2 ASN    36      63.146  12.684  17.691  1.00 27.82           N   
ATOM    315  C   ASN    36      60.936  10.564  13.833  1.00 12.44           C   
ATOM    316  O   ASN    36      61.433   9.579  13.305  1.00 13.20           O   
ATOM    317  N   THR    37      59.619  10.760  13.907  1.00 12.47           N   
ATOM    318  CA  THR    37      58.727   9.792  13.278  1.00 12.39           C   
ATOM    319  CB  THR    37      57.271  10.094  13.620  1.00 15.09           C   
ATOM    320  OG1 THR    37      57.128   9.926  15.027  1.00 19.11           O   
ATOM    321  CG2 THR    37      56.288   9.147  12.925  1.00 14.95           C   
ATOM    322  C   THR    37      58.906   9.767  11.759  1.00 12.45           C   
ATOM    323  O   THR    37      58.986   8.676  11.157  1.00 12.89           O   
ATOM    324  N   THR    38      58.995  10.949  11.132  1.00 11.36           N   
ATOM    325  CA  THR    38      59.213  10.991   9.673  1.00 10.90           C   
ATOM    326  CB  THR    38      59.168  12.446   9.205  1.00 11.39           C   
ATOM    327  OG1 THR    38      57.859  12.967   9.417  1.00 11.34           O   
ATOM    328  CG2 THR    38      59.592  12.575   7.732  1.00 12.71           C   
ATOM    329  C   THR    38      60.521  10.294   9.280  1.00 11.20           C   
ATOM    330  O   THR    38      60.578   9.552   8.304  1.00 11.94           O   
ATOM    331  N   LYS    39      61.589  10.585  10.028  1.00 11.56           N   
ATOM    332  CA  LYS    39      62.888   9.958   9.747  1.00 13.39           C   
ATOM    333  CB  LYS    39      63.952  10.440  10.743  1.00 14.74           C   
ATOM    334  CG  LYS    39      64.485  11.826  10.530  1.00 16.61           C   
ATOM    335  CD  LYS    39      65.689  12.006  11.521  1.00 23.16           C   
ATOM    336  CE  LYS    39      66.451  13.274  11.353  1.00 25.23           C   
ATOM    337  NZ  LYS    39      67.850  13.052  11.898  1.00 27.64           N   
ATOM    338  C   LYS    39      62.808   8.452   9.837  1.00 13.21           C   
ATOM    339  O   LYS    39      63.360   7.751   9.003  1.00 14.29           O   
ATOM    340  N   SER    40      62.104   7.932  10.847  1.00 13.33           N   
ATOM    341  CA  SER    40      61.996   6.489  10.949  1.00 14.52           C   
ATOM    342  CB  SER    40      61.336   6.125  12.269  0.60 15.46           C   
ATOM    344  OG  SER    40      61.299   4.733  12.408  0.60 16.06           O   
ATOM    346  C   SER    40      61.221   5.886   9.776  1.00 13.30           C   
ATOM    347  O   SER    40      61.600   4.841   9.250  1.00 14.34           O   
ATOM    348  N   ILE    41      60.138   6.538   9.355  1.00 13.24           N   
ATOM    349  CA  ILE    41      59.379   6.043   8.221  1.00 13.13           C   
ATOM    350  CB  ILE    41      58.157   6.956   7.955  1.00 13.15           C   
ATOM    351  CG1 ILE    41      57.119   6.770   9.086  1.00 14.24           C   
ATOM    352  CD1 ILE    41      56.081   7.886   9.140  1.00 13.93           C   
ATOM    353  CG2 ILE    41      57.538   6.657   6.596  1.00 14.52           C   
ATOM    354  C   ILE    41      60.308   5.963   7.001  1.00 13.16           C   
ATOM    355  O   ILE    41      60.294   4.961   6.278  1.00 13.44           O   
ATOM    356  N   LEU    42      61.100   7.011   6.738  1.00 12.24           N   
ATOM    357  CA  LEU    42      61.935   6.996   5.548  1.00 12.69           C   
ATOM    358  CB  LEU    42      62.370   8.416   5.205  1.00 13.24           C   
ATOM    359  CG  LEU    42      61.251   9.299   4.657  1.00 12.93           C   
ATOM    360  CD1 LEU    42      61.687  10.745   4.552  1.00 15.02           C   
ATOM    361  CD2 LEU    42      60.704   8.780   3.334  1.00 14.38           C   
ATOM    362  C   LEU    42      63.124   6.057   5.675  1.00 12.59           C   
ATOM    363  O   LEU    42      63.372   5.206   4.805  1.00 14.10           O   
ATOM    364  N   ILE    43      63.900   6.212   6.754  1.00 13.26           N   
ATOM    365  CA  ILE    43      65.146   5.467   6.876  1.00 14.12           C   
ATOM    366  CB  ILE    43      66.031   6.115   7.959  1.00 14.88           C   
ATOM    367  CG1 ILE    43      66.445   7.517   7.497  1.00 16.61           C   
ATOM    368  CD1 ILE    43      67.129   8.393   8.536  1.00 19.12           C   
ATOM    369  CG2 ILE    43      67.241   5.237   8.304  1.00 18.52           C   
ATOM    370  C   ILE    43      64.898   3.989   7.183  1.00 14.30           C   
ATOM    371  O   ILE    43      65.598   3.118   6.662  1.00 16.22           O   
ATOM    372  N   ASN    44      63.918   3.695   8.029  1.00 14.32           N   
ATOM    373  CA  ASN    44      63.662   2.318   8.445  1.00 16.82           C   
ATOM    374  CB  ASN    44      63.238   2.250   9.924  1.00 17.70           C   
ATOM    375  CG  ASN    44      64.290   2.824  10.858  1.00 18.04           C   
ATOM    376  OD1 ASN    44      65.477   2.655  10.624  1.00 23.81           O   
ATOM    377  ND2 ASN    44      63.854   3.495  11.910  1.00 21.09           N   
ATOM    378  C   ASN    44      62.651   1.604   7.596  1.00 16.45           C   
ATOM    379  O   ASN    44      62.791   0.415   7.371  1.00 20.08           O   
ATOM    380  N   GLU    45      61.597   2.304   7.154  1.00 15.80           N   
ATOM    381  CA  GLU    45      60.513   1.614   6.457  1.00 16.08           C   
ATOM    382  CB  GLU    45      59.152   2.072   6.977  1.00 17.78           C   
ATOM    383  CG  GLU    45      58.903   1.874   8.459  1.00 21.29           C   
ATOM    384  CD  GLU    45      57.469   2.251   8.818  1.00 25.33           C   
ATOM    385  OE1 GLU    45      56.513   1.665   8.224  1.00 31.21           O   
ATOM    386  OE2 GLU    45      57.289   3.146   9.654  1.00 28.91           O   
ATOM    387  C   GLU    45      60.538   1.775   4.946  1.00 16.63           C   
ATOM    388  O   GLU    45      59.901   1.005   4.239  1.00 20.81           O   
ATOM    389  N   THR    46      61.218   2.792   4.432  1.00 14.08           N   
ATOM    390  CA  THR    46      61.061   3.131   3.013  1.00 14.43           C   
ATOM    391  CB  THR    46      60.722   4.614   2.823  1.00 14.96           C   
ATOM    392  OG1 THR    46      59.505   4.909   3.532  1.00 17.22           O   
ATOM    393  CG2 THR    46      60.565   4.973   1.333  1.00 16.19           C   
ATOM    394  C   THR    46      62.303   2.754   2.225  1.00 14.79           C   
ATOM    395  O   THR    46      62.234   1.878   1.361  1.00 15.30           O   
ATOM    396  N   PHE    47      63.439   3.370   2.536  1.00 15.09           N   
ATOM    397  CA  PHE    47      64.641   3.176   1.717  1.00 16.01           C   
ATOM    398  CB  PHE    47      65.748   4.140   2.154  1.00 16.17           C   
ATOM    399  CG  PHE    47      65.407   5.614   1.968  1.00 15.54           C   
ATOM    400  CD1 PHE    47      64.462   6.052   1.022  1.00 17.85           C   
ATOM    401  CE1 PHE    47      64.182   7.418   0.868  1.00 17.76           C   
ATOM    402  CZ  PHE    47      64.877   8.333   1.633  1.00 16.48           C   
ATOM    403  CE2 PHE    47      65.806   7.902   2.557  1.00 17.71           C   
ATOM    404  CD2 PHE    47      66.075   6.560   2.722  1.00 16.20           C   
ATOM    405  C   PHE    47      65.138   1.721   1.672  1.00 17.74           C   
ATOM    406  O   PHE    47      65.674   1.326   0.649  1.00 19.15           O   
ATOM    407  N   PRO    48      64.965   0.926   2.748  1.00 17.49           N   
ATOM    408  CA  PRO    48      65.378  -0.482   2.605  1.00 18.23           C   
ATOM    409  CB  PRO    48      65.173  -1.048   4.017  1.00 19.99           C   
ATOM    410  CG  PRO    48      65.333   0.171   4.926  1.00 19.28           C   
ATOM    411  CD  PRO    48      64.603   1.249   4.142  1.00 18.02           C   
ATOM    412  C   PRO    48      64.556  -1.279   1.595  1.00 19.21           C   
ATOM    413  O   PRO    48      65.012  -2.333   1.135  1.00 20.80           O   
ATOM    414  N   LYS    49      63.358  -0.792   1.268  1.00 17.58           N   
ATOM    415  CA  LYS    49      62.445  -1.484   0.371  1.00 17.73           C   
ATOM    416  CB  LYS    49      61.014  -1.409   0.900  1.00 19.20           C   
ATOM    417  CG  LYS    49      60.778  -2.121   2.239  1.00 24.14           C   
ATOM    418  CD  LYS    49      59.336  -1.951   2.697  1.00 28.42           C   
ATOM    419  CE  LYS    49      59.129  -2.589   4.064  1.00 32.93           C   
ATOM    420  NZ  LYS    49      59.748  -3.956   4.100  1.00 37.03           N   
ATOM    421  C   LYS    49      62.474  -0.941  -1.053  1.00 17.39           C   
ATOM    422  O   LYS    49      62.355  -1.713  -1.993  1.00 17.70           O   
ATOM    423  N   TRP    50      62.550   0.387  -1.204  1.00 15.94           N   
ATOM    424  CA  TRP    50      62.526   1.020  -2.516  1.00 16.33           C   
ATOM    425  CB  TRP    50      61.226   1.806  -2.753  1.00 17.53           C   
ATOM    426  CG  TRP    50      59.981   0.967  -2.614  1.00 16.49           C   
ATOM    427  CD1 TRP    50      59.449   0.131  -3.560  1.00 17.99           C   
ATOM    428  NE1 TRP    50      58.339  -0.496  -3.056  1.00 17.25           N   
ATOM    429  CE2 TRP    50      58.103  -0.052  -1.783  1.00 16.63           C   
ATOM    430  CD2 TRP    50      59.128   0.869  -1.458  1.00 15.86           C   
ATOM    431  CE3 TRP    50      59.129   1.472  -0.195  1.00 17.55           C   
ATOM    432  CZ3 TRP    50      58.130   1.114   0.724  1.00 18.66           C   
ATOM    433  CH2 TRP    50      57.121   0.179   0.369  1.00 18.15           C   
ATOM    434  CZ2 TRP    50      57.082  -0.394  -0.881  1.00 18.50           C   
ATOM    435  C   TRP    50      63.682   1.960  -2.602  1.00 17.40           C   
ATOM    436  O   TRP    50      63.920   2.760  -1.697  1.00 17.98           O   
ATOM    437  N   SER    51      64.393   1.855  -3.725  1.00 20.46           N   
ATOM    438  CA  SER    51      65.563   2.688  -3.982  1.00 22.65           C   
ATOM    439  CB  SER    51      66.410   2.068  -5.093  1.00 23.40           C   
ATOM    440  OG  SER    51      67.426   3.003  -5.447  1.00 26.96           O   
ATOM    441  C   SER    51      65.244   4.144  -4.365  1.00 21.60           C   
ATOM    442  O   SER    51      64.500   4.410  -5.319  1.00 23.72           O   
ATOM    443  N   PRO    52      65.781   5.090  -3.610  1.00 21.23           N   
ATOM    444  CA  PRO    52      65.604   6.471  -4.018  1.00 23.06           C   
ATOM    445  CB  PRO    52      65.837   7.236  -2.726  1.00 22.03           C   
ATOM    446  CG  PRO    52      66.788   6.427  -1.967  1.00 21.68           C   
ATOM    447  CD  PRO    52      66.409   4.991  -2.294  1.00 19.25           C   
ATOM    448  C   PRO    52      66.600   6.917  -5.075  1.00 27.00           C   
ATOM    449  O   PRO    52      66.537   8.072  -5.509  1.00 25.41           O   
ATOM    450  N   LEU    53      67.512   6.037  -5.486  1.00 24.99           N   
ATOM    451  CA  LEU    53      68.566   6.453  -6.426  1.00 28.17           C   
ATOM    452  CB  LEU    53      69.906   5.852  -6.004  1.00 31.21           C   
ATOM    453  CG  LEU    53      70.315   6.093  -4.552  1.00 29.87           C   
ATOM    454  CD1 LEU    53      71.630   5.394  -4.230  1.00 32.55           C   
ATOM    455  CD2 LEU    53      70.381   7.590  -4.201  1.00 32.04           C   
ATOM    456  C   LEU    53      68.319   6.079  -7.879  1.00 31.79           C   
ATOM    457  O   LEU    53      68.854   6.746  -8.786  1.00 32.74           O   
ATOM    458  N   ASN    54      67.553   5.008  -8.109  1.00 29.98           N   
ATOM    459  CA  ASN    54      67.502   4.380  -9.427  1.00 31.81           C   
ATOM    460  CB  ASN    54      67.825   2.882  -9.311  1.00 32.66           C   
ATOM    461  CG  ASN    54      66.727   2.094  -8.638  1.00 34.13           C   
ATOM    462  OD1 ASN    54      65.695   2.647  -8.224  1.00 32.94           O   
ATOM    463  ND2 ASN    54      66.940   0.785  -8.511  1.00 33.66           N   
ATOM    464  C   ASN    54      66.181   4.619 -10.159  1.00 31.10           C   
ATOM    465  O   ASN    54      65.942   4.081 -11.257  1.00 34.28           O   
ATOM    466  N   GLY    55      65.332   5.441  -9.559  1.00 26.33           N   
ATOM    467  CA  GLY    55      64.082   5.800 -10.176  1.00 26.65           C   
ATOM    468  C   GLY    55      62.934   4.978  -9.643  1.00 20.36           C   
ATOM    469  O   GLY    55      61.808   5.188 -10.070  1.00 25.46           O   
ATOM    470  N   GLU    56      63.181   4.098  -8.661  1.00 20.13           N   
ATOM    471  CA  GLU    56      62.032   3.438  -8.007  1.00 17.73           C   
ATOM    472  CB  GLU    56      62.451   2.302  -7.065  1.00 17.51           C   
ATOM    473  CG  GLU    56      63.009   1.112  -7.869  1.00 20.68           C   
ATOM    474  CD  GLU    56      63.553  -0.007  -7.006  1.00 23.97           C   
ATOM    475  OE1 GLU    56      63.450   0.042  -5.772  1.00 23.87           O   
ATOM    476  OE2 GLU    56      64.124  -0.970  -7.594  1.00 28.47           O   
ATOM    477  C   GLU    56      61.103   4.399  -7.283  1.00 15.95           C   
ATOM    478  O   GLU    56      59.900   4.134  -7.209  1.00 16.90           O   
ATOM    479  N   ILE    57      61.666   5.480  -6.727  1.00 14.31           N   
ATOM    480  CA  ILE    57      60.861   6.440  -5.993  1.00 14.47           C   
ATOM    481  CB  ILE    57      61.432   6.708  -4.590  1.00 14.91           C   
ATOM    482  CG1 ILE    57      61.490   5.418  -3.765  1.00 16.06           C   
ATOM    483  CD1 ILE    57      62.023   5.621  -2.363  1.00 17.51           C   
ATOM    484  CG2 ILE    57      60.584   7.789  -3.851  1.00 15.96           C   
ATOM    485  C   ILE    57      60.824   7.773  -6.744  1.00 14.96           C   
ATOM    486  O   ILE    57      61.885   8.314  -7.116  1.00 16.71           O   
ATOM    487  N   SER    58      59.632   8.331  -6.920  1.00 13.77           N   
ATOM    488  CA  SER    58      59.507   9.721  -7.357  0.70 13.46           C   
ATOM    490  CB  SER    58      58.695   9.812  -8.638  0.70 15.42           C   
ATOM    492  OG  SER    58      59.496   9.508  -9.771  0.70 16.81           O   
ATOM    494  C   SER    58      58.863  10.543  -6.239  1.00 12.68           C   
ATOM    495  O   SER    58      58.162  10.007  -5.395  1.00 15.90           O   
ATOM    496  N   PHE    59      59.148  11.834  -6.231  1.00 11.87           N   
ATOM    497  CA  PHE    59      58.664  12.711  -5.201  1.00 11.90           C   
ATOM    498  CB  PHE    59      59.850  13.518  -4.628  1.00 13.30           C   
ATOM    499  CG  PHE    59      59.502  14.297  -3.402  1.00 12.77           C   
ATOM    500  CD1 PHE    59      60.003  13.887  -2.151  1.00 13.41           C   
ATOM    501  CE1 PHE    59      59.676  14.551  -0.993  1.00 13.22           C   
ATOM    502  CZ  PHE    59      58.829  15.672  -1.049  1.00 13.42           C   
ATOM    503  CE2 PHE    59      58.316  16.090  -2.284  1.00 15.31           C   
ATOM    504  CD2 PHE    59      58.665  15.400  -3.458  1.00 14.15           C   
ATOM    505  C   PHE    59      57.585  13.617  -5.784  1.00 11.10           C   
ATOM    506  O   PHE    59      57.868  14.358  -6.727  1.00 12.20           O   
ATOM    507  N   SER    60      56.362  13.599  -5.231  1.00 11.84           N   
ATOM    508  CA  SER    60      55.319  14.502  -5.700  1.00 11.60           C   
ATOM    509  CB  SER    60      53.930  13.872  -5.498  1.00 14.24           C   
ATOM    510  OG  SER    60      52.961  14.753  -6.067  1.00 15.65           O   
ATOM    511  C   SER    60      55.424  15.842  -4.997  1.00 11.80           C   
ATOM    512  O   SER    60      55.246  15.916  -3.787  1.00 14.28           O   
ATOM    513  N   TYR    61      55.720  16.892  -5.738  1.00 12.59           N   
ATOM    514  CA  TYR    61      56.015  18.201  -5.180  1.00 12.55           C   
ATOM    515  CB  TYR    61      57.499  18.533  -5.414  1.00 14.14           C   
ATOM    516  CG  TYR    61      57.963  19.864  -4.865  1.00 13.85           C   
ATOM    517  CD1 TYR    61      58.167  20.063  -3.508  1.00 13.57           C   
ATOM    518  CE1 TYR    61      58.565  21.291  -3.021  1.00 15.31           C   
ATOM    519  CZ  TYR    61      58.862  22.305  -3.930  1.00 15.83           C   
ATOM    520  OH  TYR    61      59.347  23.489  -3.420  1.00 18.96           O   
ATOM    521  CE2 TYR    61      58.744  22.116  -5.297  1.00 18.13           C   
ATOM    522  CD2 TYR    61      58.283  20.917  -5.766  1.00 15.93           C   
ATOM    523  C   TYR    61      55.169  19.271  -5.798  1.00 12.40           C   
ATOM    524  O   TYR    61      55.220  19.472  -7.021  1.00 15.87           O   
ATOM    525  N   ASN    62      54.423  20.008  -4.977  1.00 12.61           N   
ATOM    526  CA  ASN    62      53.519  21.035  -5.509  1.00 14.19           C   
ATOM    527  CB  ASN    62      52.065  20.678  -5.227  1.00 16.06           C   
ATOM    528  CG  ASN    62      51.751  20.636  -3.721  1.00 16.26           C   
ATOM    529  OD1 ASN    62      52.456  21.237  -2.902  1.00 15.07           O   
ATOM    530  ND2 ASN    62      50.698  19.902  -3.346  1.00 23.02           N   
ATOM    531  C   ASN    62      53.829  22.425  -5.001  1.00 13.83           C   
ATOM    532  O   ASN    62      52.989  23.335  -5.158  1.00 15.70           O   
ATOM    533  N   GLY    63      54.990  22.594  -4.370  1.00 13.10           N   
ATOM    534  CA  GLY    63      55.478  23.901  -3.951  1.00 14.50           C   
ATOM    535  C   GLY    63      54.896  24.439  -2.656  1.00 12.61           C   
ATOM    536  O   GLY    63      55.406  25.428  -2.142  1.00 13.58           O   
ATOM    537  N   GLY    64      53.880  23.765  -2.106  1.00 11.37           N   
ATOM    538  CA  GLY    64      53.270  24.242  -0.898  1.00 11.96           C   
ATOM    539  C   GLY    64      54.105  23.911   0.328  1.00 11.37           C   
ATOM    540  O   GLY    64      55.042  23.091   0.259  1.00 11.87           O   
ATOM    541  N   LYS    65      53.718  24.494   1.450  1.00 11.99           N   
ATOM    542  CA  LYS    65      54.500  24.347   2.679  1.00 12.14           C   
ATOM    543  CB  LYS    65      53.844  25.210   3.762  1.00 13.31           C   
ATOM    544  CG  LYS    65      52.429  24.780   4.111  1.00 13.51           C   
ATOM    545  CD  LYS    65      51.728  25.791   5.010  1.00 14.43           C   
ATOM    546  CE  LYS    65      50.393  25.267   5.518  1.00 16.15           C   
ATOM    547  NZ  LYS    65      49.331  25.150   4.466  1.00 15.17           N   
ATOM    548  C   LYS    65      54.661  22.880   3.107  1.00 12.19           C   
ATOM    549  O   LYS    65      55.708  22.510   3.640  1.00 12.13           O   
ATOM    550  N   ASP    66      53.632  22.053   2.912  1.00 11.58           N   
ATOM    551  CA  ASP    66      53.732  20.653   3.351  1.00 12.43           C   
ATOM    552  CB  ASP    66      52.386  19.933   3.272  1.00 14.82           C   
ATOM    553  CG  ASP    66      51.325  20.516   4.192  1.00 16.26           C   
ATOM    554  OD1 ASP    66      51.634  21.184   5.191  1.00 18.37           O   
ATOM    555  OD2 ASP    66      50.142  20.217   3.871  1.00 18.20           O   
ATOM    556  C   ASP    66      54.732  19.881   2.496  1.00 10.86           C   
ATOM    557  O   ASP    66      55.624  19.176   2.995  1.00 11.41           O   
ATOM    558  N   CYS    67      54.618  20.010   1.170  1.00 10.76           N   
ATOM    559  CA  CYS    67      55.580  19.393   0.292  1.00 10.82           C   
ATOM    560  CB  CYS    67      55.172  19.628  -1.181  1.00 12.32           C   
ATOM    561  SG  CYS    67      53.857  18.527  -1.744  1.00 14.45           S   
ATOM    562  C   CYS    67      56.975  19.912   0.517  1.00 11.04           C   
ATOM    563  O   CYS    67      57.928  19.145   0.375  1.00 11.16           O   
ATOM    564  N   GLN    68      57.115  21.211   0.806  1.00 10.86           N   
ATOM    565  CA  GLN    68      58.441  21.738   1.041  1.00 11.55           C   
ATOM    566  CB  GLN    68      58.430  23.255   1.057  1.00 12.98           C   
ATOM    567  CG  GLN    68      59.891  23.773   1.060  1.00 14.41           C   
ATOM    568  CD  GLN    68      60.008  25.237   0.957  1.00 14.34           C   
ATOM    569  OE1 GLN    68      59.008  25.963   1.006  1.00 14.06           O   
ATOM    570  NE2 GLN    68      61.250  25.714   0.831  1.00 16.37           N   
ATOM    571  C   GLN    68      59.076  21.166   2.320  1.00 11.08           C   
ATOM    572  O   GLN    68      60.232  20.756   2.307  1.00 11.27           O   
ATOM    573  N   VAL    69      58.326  21.143   3.420  1.00 10.33           N   
ATOM    574  CA  VAL    69      58.852  20.508   4.628  1.00 11.33           C   
ATOM    575  CB  VAL    69      57.812  20.562   5.779  1.00 11.54           C   
ATOM    576  CG1 VAL    69      58.221  19.578   6.909  1.00 12.35           C   
ATOM    577  CG2 VAL    69      57.681  21.968   6.304  1.00 13.19           C   
ATOM    578  C   VAL    69      59.252  19.079   4.312  1.00 10.09           C   
ATOM    579  O   VAL    69      60.332  18.608   4.705  1.00 10.66           O   
ATOM    580  N   LEU    70      58.375  18.338   3.647  1.00  9.89           N   
ATOM    581  CA  LEU    70      58.692  16.942   3.377  1.00 10.80           C   
ATOM    582  CB  LEU    70      57.490  16.234   2.793  1.00 11.00           C   
ATOM    583  CG  LEU    70      57.686  14.732   2.516  1.00 12.00           C   
ATOM    584  CD1 LEU    70      58.134  13.958   3.790  1.00 13.17           C   
ATOM    585  CD2 LEU    70      56.394  14.152   2.004  1.00 12.93           C   
ATOM    586  C   LEU    70      59.913  16.797   2.479  1.00 10.34           C   
ATOM    587  O   LEU    70      60.718  15.890   2.677  1.00 10.97           O   
ATOM    588  N   LEU    71      60.065  17.688   1.496  1.00  9.99           N   
ATOM    589  CA  LEU    71      61.247  17.607   0.637  1.00 10.73           C   
ATOM    590  CB  LEU    71      61.143  18.634  -0.473  1.00 11.46           C   
ATOM    591  CG  LEU    71      62.323  18.651  -1.467  1.00 13.16           C   
ATOM    592  CD1 LEU    71      62.555  17.324  -2.162  1.00 14.60           C   
ATOM    593  CD2 LEU    71      62.073  19.786  -2.503  1.00 14.88           C   
ATOM    594  C   LEU    71      62.525  17.853   1.464  1.00 10.60           C   
ATOM    595  O   LEU    71      63.527  17.160   1.262  1.00 10.92           O   
ATOM    596  N   LEU    72      62.526  18.852   2.357  1.00 10.18           N   
ATOM    597  CA  LEU    72      63.695  19.066   3.205  1.00 10.79           C   
ATOM    598  CB  LEU    72      63.455  20.261   4.119  1.00 11.71           C   
ATOM    599  CG  LEU    72      63.216  21.617   3.441  1.00 13.31           C   
ATOM    600  CD1 LEU    72      63.033  22.705   4.489  1.00 15.59           C   
ATOM    601  CD2 LEU    72      64.306  21.983   2.403  1.00 16.32           C   
ATOM    602  C   LEU    72      64.005  17.822   4.030  1.00 11.21           C   
ATOM    603  O   LEU    72      65.159  17.424   4.151  1.00 11.39           O   
ATOM    604  N   LEU    73      62.972  17.200   4.626  1.00 10.35           N   
ATOM    605  CA  LEU    73      63.196  16.002   5.408  1.00 11.57           C   
ATOM    606  CB  LEU    73      61.940  15.662   6.212  1.00 11.72           C   
ATOM    607  CG  LEU    73      61.570  16.716   7.244  1.00 13.10           C   
ATOM    608  CD1 LEU    73      60.193  16.413   7.814  1.00 15.68           C   
ATOM    609  CD2 LEU    73      62.636  16.898   8.382  1.00 15.40           C   
ATOM    610  C   LEU    73      63.645  14.821   4.566  1.00 11.34           C   
ATOM    611  O   LEU    73      64.462  14.005   5.025  1.00 11.77           O   
ATOM    612  N   TYR    74      63.103  14.694   3.348  1.00 10.90           N   
ATOM    613  CA  TYR    74      63.482  13.624   2.459  1.00 11.44           C   
ATOM    614  CB  TYR    74      62.562  13.669   1.238  1.00 11.59           C   
ATOM    615  CG  TYR    74      62.733  12.521   0.279  1.00 12.25           C   
ATOM    616  CD1 TYR    74      62.126  11.312   0.533  1.00 13.46           C   
ATOM    617  CE1 TYR    74      62.270  10.233  -0.308  1.00 14.71           C   
ATOM    618  CZ  TYR    74      63.061  10.357  -1.419  1.00 13.61           C   
ATOM    619  OH  TYR    74      63.192   9.287  -2.248  1.00 15.72           O   
ATOM    620  CE2 TYR    74      63.661  11.564  -1.720  1.00 13.36           C   
ATOM    621  CD2 TYR    74      63.509  12.626  -0.860  1.00 12.78           C   
ATOM    622  C   TYR    74      64.953  13.755   2.058  1.00 11.69           C   
ATOM    623  O   TYR    74      65.710  12.772   2.104  1.00 12.16           O   
ATOM    624  N   LEU    75      65.353  14.974   1.687  1.00 11.66           N   
ATOM    625  CA  LEU    75      66.774  15.235   1.382  1.00 11.86           C   
ATOM    626  CB  LEU    75      66.910  16.659   0.889  1.00 13.10           C   
ATOM    627  CG  LEU    75      66.423  16.960  -0.540  1.00 13.55           C   
ATOM    628  CD1 LEU    75      66.328  18.442  -0.799  1.00 15.16           C   
ATOM    629  CD2 LEU    75      67.386  16.316  -1.545  1.00 19.31           C   
ATOM    630  C   LEU    75      67.675  14.942   2.582  1.00 12.64           C   
ATOM    631  O   LEU    75      68.737  14.298   2.417  1.00 13.35           O   
ATOM    632  N   SER    76      67.243  15.353   3.775  1.00 11.71           N   
ATOM    633  CA  SER    76      68.040  15.054   4.967  1.00 12.46           C   
ATOM    634  CB  SER    76      67.312  15.630   6.173  1.00 12.76           C   
ATOM    635  OG  SER    76      67.955  15.223   7.406  1.00 15.21           O   
ATOM    636  C   SER    76      68.206  13.537   5.130  1.00 12.26           C   
ATOM    637  O   SER    76      69.282  13.045   5.428  1.00 13.76           O   
ATOM    638  N   CYS    77      67.129  12.788   4.918  1.00 12.43           N   
ATOM    639  CA  CYS    77      67.178  11.347   5.068  1.00 13.13           C   
ATOM    640  CB  CYS    77      65.767  10.760   5.146  1.00 14.51           C   
ATOM    641  SG  CYS    77      64.922  11.161   6.666  1.00 15.99           S   
ATOM    642  C   CYS    77      67.993  10.656   4.016  1.00 13.68           C   
ATOM    643  O   CYS    77      68.628   9.638   4.299  1.00 14.87           O   
ATOM    644  N   LEU    78      68.009  11.176   2.792  1.00 14.78           N   
ATOM    645  CA  LEU    78      68.933  10.631   1.773  1.00 15.74           C   
ATOM    646  CB  LEU    78      68.733  11.365   0.446  1.00 17.60           C   
ATOM    647  CG  LEU    78      67.431  11.106  -0.290  1.00 18.46           C   
ATOM    648  CD1 LEU    78      67.341  12.019  -1.516  1.00 20.21           C   
ATOM    649  CD2 LEU    78      67.302   9.642  -0.699  1.00 20.52           C   
ATOM    650  C   LEU    78      70.374  10.784   2.215  1.00 16.95           C   
ATOM    651  O   LEU    78      71.175   9.850   2.092  1.00 19.30           O   
ATOM    652  N   TRP    79      70.723  11.958   2.716  1.00 16.02           N   
ATOM    653  CA  TRP    79      72.075  12.167   3.222  1.00 16.98           C   
ATOM    654  CB  TRP    79      72.281  13.624   3.620  1.00 16.75           C   
ATOM    655  CG  TRP    79      73.688  13.921   4.006  1.00 17.23           C   
ATOM    656  CD1 TRP    79      74.231  13.927   5.278  1.00 17.76           C   
ATOM    657  NE1 TRP    79      75.594  14.212   5.213  1.00 19.15           N   
ATOM    658  CE2 TRP    79      75.932  14.403   3.901  1.00 19.57           C   
ATOM    659  CD2 TRP    79      74.772  14.201   3.113  1.00 17.67           C   
ATOM    660  CE3 TRP    79      74.858  14.361   1.730  1.00 18.95           C   
ATOM    661  CZ3 TRP    79      76.095  14.656   1.168  1.00 18.96           C   
ATOM    662  CH2 TRP    79      77.220  14.830   1.966  1.00 19.78           C   
ATOM    663  CZ2 TRP    79      77.172  14.695   3.337  1.00 20.24           C   
ATOM    664  C   TRP    79      72.374  11.228   4.382  1.00 18.77           C   
ATOM    665  O   TRP    79      73.413  10.560   4.413  1.00 20.11           O   
ATOM    666  N   GLU    80      71.466  11.173   5.338  1.00 17.10           N   
ATOM    667  CA  GLU    80      71.689  10.325   6.515  1.00 18.32           C   
ATOM    668  CB  GLU    80      70.574  10.551   7.521  1.00 17.99           C   
ATOM    669  CG  GLU    80      70.749   9.714   8.809  1.00 21.88           C   
ATOM    670  CD  GLU    80      69.865  10.139   9.962  1.00 21.59           C   
ATOM    671  OE1 GLU    80      69.149  11.151   9.904  1.00 21.04           O   
ATOM    672  OE2 GLU    80      69.866   9.413  11.000  1.00 26.23           O   
ATOM    673  C   GLU    80      71.836   8.865   6.128  1.00 19.42           C   
ATOM    674  O   GLU    80      72.759   8.163   6.595  1.00 21.78           O   
ATOM    675  N   TYR    81      71.005   8.399   5.212  1.00 19.31           N   
ATOM    676  CA  TYR    81      70.985   6.989   4.840  1.00 19.63           C   
ATOM    677  CB  TYR    81      69.758   6.683   3.982  1.00 20.53           C   
ATOM    678  CG  TYR    81      69.533   5.227   3.677  1.00 21.92           C   
ATOM    679  CD1 TYR    81      69.001   4.373   4.649  1.00 23.13           C   
ATOM    680  CE1 TYR    81      68.750   3.033   4.362  1.00 24.22           C   
ATOM    681  CZ  TYR    81      69.020   2.545   3.119  1.00 22.71           C   
ATOM    682  OH  TYR    81      68.737   1.202   2.863  1.00 26.82           O   
ATOM    683  CE2 TYR    81      69.527   3.370   2.118  1.00 23.84           C   
ATOM    684  CD2 TYR    81      69.774   4.710   2.401  1.00 22.35           C   
ATOM    685  C   TYR    81      72.256   6.617   4.102  1.00 22.28           C   
ATOM    686  O   TYR    81      72.860   5.583   4.392  1.00 24.59           O   
ATOM    687  N   TYR    82      72.672   7.457   3.167  1.00 20.97           N   
ATOM    688  CA  TYR    82      73.810   7.128   2.297  1.00 24.24           C   
ATOM    689  CB  TYR    82      73.577   7.634   0.873  1.00 25.46           C   
ATOM    690  CG  TYR    82      72.497   6.860   0.181  1.00 25.29           C   
ATOM    691  CD1 TYR    82      72.669   5.507  -0.128  1.00 26.35           C   
ATOM    692  CE1 TYR    82      71.664   4.781  -0.719  1.00 26.93           C   
ATOM    693  CZ  TYR    82      70.466   5.398  -1.023  1.00 26.66           C   
ATOM    694  OH  TYR    82      69.483   4.681  -1.622  1.00 29.21           O   
ATOM    695  CE2 TYR    82      70.257   6.737  -0.726  1.00 26.33           C   
ATOM    696  CD2 TYR    82      71.258   7.458  -0.112  1.00 25.39           C   
ATOM    697  C   TYR    82      75.170   7.555   2.792  1.00 25.64           C   
ATOM    698  O   TYR    82      76.181   6.894   2.449  1.00 29.70           O   
ATOM    699  N   ILE    83      75.229   8.614   3.581  1.00 23.04           N   
ATOM    700  CA  ILE    83      76.498   9.150   4.085  1.00 26.97           C   
ATOM    701  CB  ILE    83      76.596  10.667   3.828  1.00 27.08           C   
ATOM    702  CG1 ILE    83      76.406  10.967   2.327  1.00 26.26           C   
ATOM    703  CD1 ILE    83      77.460  10.308   1.386  1.00 31.63           C   
ATOM    704  CG2 ILE    83      77.915  11.251   4.378  1.00 27.83           C   
ATOM    705  C   ILE    83      76.710   8.886   5.562  1.00 30.89           C   
ATOM    706  O   ILE    83      77.790   8.430   5.978  1.00 31.43           O   
ATOM    707  N   VAL    84      75.709   9.192   6.377  1.00 31.43           N   
ATOM    708  CA  VAL    84      75.897   9.188   7.831  1.00 33.20           C   
ATOM    709  CB  VAL    84      74.911  10.126   8.548  1.00 31.34           C   
ATOM    710  CG1 VAL    84      75.041   9.981  10.066  1.00 32.75           C   
ATOM    711  CG2 VAL    84      75.163  11.566   8.143  1.00 29.87           C   
ATOM    712  C   VAL    84      75.832   7.787   8.420  1.00 35.69           C   
ATOM    713  O   VAL    84      76.777   7.354   9.090  1.00 38.11           O   
ATOM    714  N   LYS   102      70.159  14.698 -10.191  0.55 16.44           N   
ATOM    716  CA  LYS   102      68.922  15.456  -9.977  0.55 18.09           C   
ATOM    718  CB  LYS   102      68.421  16.022 -11.306  0.55 18.67           C   
ATOM    720  CG  LYS   102      69.322  17.149 -11.861  0.55 20.02           C   
ATOM    722  CD  LYS   102      68.652  17.975 -12.981  0.55 19.36           C   
ATOM    724  CE  LYS   102      69.583  19.060 -13.553  0.55 20.86           C   
ATOM    726  NZ  LYS   102      70.011  20.182 -12.621  0.55 20.39           N   
ATOM    728  C   LYS   102      67.900  14.496  -9.400  0.55 18.13           C   
ATOM    730  O   LYS   102      67.954  13.296  -9.695  0.55 18.18           O   
ATOM    732  N   LEU   103      66.980  14.994  -8.577  0.50 14.34           N   
ATOM    734  CA  LEU   103      65.960  14.135  -7.911  0.50 13.97           C   
ATOM    736  CB  LEU   103      65.677  14.785  -6.554  0.50 12.50           C   
ATOM    738  CG  LEU   103      64.942  14.001  -5.452  0.50 13.64           C   
ATOM    740  CD1 LEU   103      65.700  12.794  -4.973  0.50 16.03           C   
ATOM    742  CD2 LEU   103      63.468  13.720  -5.669  0.50 17.11           C   
ATOM    744  C   LEU   103      64.579  13.898  -8.705  0.50 14.30           C   
ATOM    746  O   LEU   103      63.919  14.888  -8.970  0.50 12.11           O   
ATOM    748  N   PRO   104      64.122  12.618  -9.043  1.00 16.20           N   
ATOM    749  CA  PRO   104      62.911  12.579  -9.841  1.00 15.73           C   
ATOM    750  CB  PRO   104      62.762  11.092 -10.204  1.00 19.59           C   
ATOM    751  CG  PRO   104      64.129  10.513 -10.032  1.00 25.50           C   
ATOM    752  CD  PRO   104      64.718  11.269  -8.883  1.00 21.04           C   
ATOM    753  C   PRO   104      61.713  13.122  -9.085  1.00 13.77           C   
ATOM    754  O   PRO   104      61.382  12.636  -7.999  1.00 15.09           O   
ATOM    755  N   THR   105      61.081  14.121  -9.673  1.00 12.34           N   
ATOM    756  CA  THR   105      60.037  14.902  -9.024  1.00 12.15           C   
ATOM    757  CB  THR   105      60.579  16.286  -8.582  1.00 13.21           C   
ATOM    758  OG1 THR   105      61.703  16.094  -7.731  1.00 13.58           O   
ATOM    759  CG2 THR   105      59.601  17.127  -7.876  1.00 13.62           C   
ATOM    760  C   THR   105      58.869  15.003  -9.982  1.00 12.50           C   
ATOM    761  O   THR   105      59.097  15.108 -11.196  1.00 15.00           O   
ATOM    762  N   VAL   106      57.652  14.970  -9.476  1.00 11.17           N   
ATOM    763  CA  VAL   106      56.465  15.125 -10.294  1.00 11.95           C   
ATOM    764  CB  VAL   106      55.696  13.779 -10.485  1.00 13.03           C   
ATOM    765  CG1 VAL   106      55.485  13.024  -9.161  1.00 14.46           C   
ATOM    766  CG2 VAL   106      54.392  13.956 -11.240  1.00 14.74           C   
ATOM    767  C   VAL   106      55.578  16.196  -9.696  1.00 11.16           C   
ATOM    768  O   VAL   106      55.307  16.178  -8.477  1.00 12.21           O   
ATOM    769  N   PHE   107      55.097  17.110 -10.546  1.00 11.71           N   
ATOM    770  CA  PHE   107      54.140  18.142 -10.172  1.00 11.96           C   
ATOM    771  CB  PHE   107      54.774  19.519 -10.347  1.00 13.15           C   
ATOM    772  CG  PHE   107      53.808  20.670 -10.222  1.00 12.99           C   
ATOM    773  CD1 PHE   107      52.836  20.720  -9.210  1.00 14.85           C   
ATOM    774  CE1 PHE   107      51.934  21.784  -9.140  1.00 14.84           C   
ATOM    775  CZ  PHE   107      52.011  22.807 -10.095  1.00 15.63           C   
ATOM    776  CE2 PHE   107      52.945  22.749 -11.118  1.00 15.33           C   
ATOM    777  CD2 PHE   107      53.835  21.690 -11.176  1.00 14.06           C   
ATOM    778  C   PHE   107      52.916  17.964 -11.076  1.00 12.51           C   
ATOM    779  O   PHE   107      53.015  18.043 -12.289  1.00 13.26           O   
ATOM    780  N   ILE   108      51.741  17.817 -10.457  1.00 13.07           N   
ATOM    781  CA  ILE   108      50.494  17.800 -11.184  1.00 14.34           C   
ATOM    782  CB  ILE   108      49.439  16.918 -10.444  1.00 17.00           C   
ATOM    783  CG1 ILE   108      49.981  15.485 -10.214  1.00 17.69           C   
ATOM    784  CD1 ILE   108      50.545  14.779 -11.418  1.00 17.92           C   
ATOM    785  CG2 ILE   108      48.153  16.881 -11.254  1.00 18.68           C   
ATOM    786  C   ILE   108      50.017  19.245 -11.305  1.00 14.39           C   
ATOM    787  O   ILE   108      49.575  19.865 -10.336  1.00 15.18           O   
ATOM    788  N   ASP   109      50.199  19.809 -12.491  1.00 13.71           N   
ATOM    789  CA  ASP   109      49.920  21.210 -12.748  1.00 13.60           C   
ATOM    790  CB  ASP   109      50.859  21.673 -13.884  1.00 14.31           C   
ATOM    791  CG  ASP   109      51.013  23.184 -14.001  1.00 14.86           C   
ATOM    792  OD1 ASP   109      50.506  23.921 -13.127  1.00 15.36           O   
ATOM    793  OD2 ASP   109      51.675  23.623 -14.976  1.00 16.18           O   
ATOM    794  C   ASP   109      48.463  21.406 -13.105  1.00 14.05           C   
ATOM    795  O   ASP   109      47.807  20.487 -13.573  1.00 16.12           O   
ATOM    796  N   HIS   110      47.950  22.608 -12.878  1.00 13.15           N   
ATOM    797  CA  HIS   110      46.548  22.927 -13.197  1.00 13.79           C   
ATOM    798  CB  HIS   110      45.677  22.912 -11.919  1.00 15.73           C   
ATOM    799  CG  HIS   110      45.705  21.608 -11.191  1.00 17.24           C   
ATOM    800  ND1 HIS   110      46.634  21.311 -10.215  1.00 19.48           N   
ATOM    801  CE1 HIS   110      46.423  20.086  -9.764  1.00 19.86           C   
ATOM    802  NE2 HIS   110      45.407  19.570 -10.429  1.00 19.77           N   
ATOM    803  CD2 HIS   110      44.944  20.505 -11.329  1.00 19.55           C   
ATOM    804  C   HIS   110      46.487  24.305 -13.787  1.00 13.03           C   
ATOM    805  O   HIS   110      47.344  25.167 -13.489  1.00 13.64           O   
ATOM    806  N   ASP   111      45.432  24.555 -14.558  1.00 12.77           N   
ATOM    807  CA  ASP   111      45.346  25.819 -15.259  1.00 13.55           C   
ATOM    808  CB  ASP   111      44.412  25.721 -16.448  1.00 15.48           C   
ATOM    809  CG  ASP   111      43.002  25.528 -16.067  1.00 18.57           C   
ATOM    810  OD1 ASP   111      42.463  25.754 -15.005  1.00 19.60           O   
ATOM    811  OD2 ASP   111      42.281  25.093 -17.015  1.00 23.85           O   
ATOM    812  C   ASP   111      44.987  26.985 -14.339  1.00 12.98           C   
ATOM    813  O   ASP   111      45.096  28.115 -14.755  1.00 14.81           O   
ATOM    814  N   ASP   112      44.625  26.695 -13.090  1.00 11.93           N   
ATOM    815  CA  ASP   112      44.183  27.710 -12.143  1.00 12.31           C   
ATOM    816  CB  ASP   112      42.728  27.481 -11.730  1.00 13.29           C   
ATOM    817  CG  ASP   112      42.495  26.142 -11.060  1.00 13.64           C   
ATOM    818  OD1 ASP   112      43.456  25.326 -10.947  1.00 14.12           O   
ATOM    819  OD2 ASP   112      41.325  25.898 -10.614  1.00 14.66           O   
ATOM    820  C   ASP   112      45.123  27.817 -10.939  1.00 11.76           C   
ATOM    821  O   ASP   112      44.735  28.269  -9.866  1.00 12.55           O   
ATOM    822  N   THR   113      46.375  27.439 -11.148  1.00 12.84           N   
ATOM    823  CA  THR   113      47.432  27.558 -10.108  1.00 12.79           C   
ATOM    824  CB  THR   113      48.623  26.681 -10.513  1.00 14.26           C   
ATOM    825  OG1 THR   113      48.176  25.332 -10.739  1.00 16.55           O   
ATOM    826  CG2 THR   113      49.713  26.652  -9.471  1.00 14.15           C   
ATOM    827  C   THR   113      47.888  29.013  -9.992  1.00 11.83           C   
ATOM    828  O   THR   113      48.009  29.710 -10.996  1.00 13.16           O   
ATOM    829  N   PHE   114      48.198  29.472  -8.792  1.00 11.58           N   
ATOM    830  CA  PHE   114      48.785  30.788  -8.610  1.00 12.06           C   
ATOM    831  CB  PHE   114      49.114  31.053  -7.123  1.00 12.24           C   
ATOM    832  CG  PHE   114      47.936  31.504  -6.309  1.00 12.14           C   
ATOM    833  CD1 PHE   114      47.615  32.853  -6.224  1.00 14.29           C   
ATOM    834  CE1 PHE   114      46.530  33.283  -5.494  1.00 14.91           C   
ATOM    835  CZ  PHE   114      45.727  32.344  -4.840  1.00 15.77           C   
ATOM    836  CE2 PHE   114      46.041  31.003  -4.879  1.00 15.16           C   
ATOM    837  CD2 PHE   114      47.147  30.560  -5.640  1.00 14.07           C   
ATOM    838  C   PHE   114      50.106  30.897  -9.371  1.00 11.15           C   
ATOM    839  O   PHE   114      50.981  30.015  -9.286  1.00 11.50           O   
ATOM    840  N   LYS   115      50.306  32.032 -10.045  1.00 11.31           N   
ATOM    841  CA  LYS   115      51.572  32.283 -10.746  1.00 11.57           C   
ATOM    842  CB  LYS   115      51.545  33.654 -11.398  1.00 12.85           C   
ATOM    843  CG  LYS   115      52.779  33.963 -12.201  1.00 13.79           C   
ATOM    844  CD  LYS   115      52.975  32.979 -13.372  1.00 18.80           C   
ATOM    845  CE  LYS   115      53.906  33.515 -14.445  1.00 22.92           C   
ATOM    846  NZ  LYS   115      53.615  32.785 -15.763  1.00 24.30           N   
ATOM    847  C   LYS   115      52.761  32.212  -9.762  1.00 10.30           C   
ATOM    848  O   LYS   115      53.822  31.699 -10.095  1.00 10.53           O   
ATOM    849  N   THR   116      52.597  32.757  -8.554  1.00 10.71           N   
ATOM    850  CA  THR   116      53.716  32.779  -7.609  1.00 10.71           C   
ATOM    851  CB  THR   116      53.344  33.527  -6.331  1.00 11.11           C   
ATOM    852  OG1 THR   116      53.081  34.888  -6.634  1.00 11.98           O   
ATOM    853  CG2 THR   116      54.500  33.505  -5.341  1.00 12.36           C   
ATOM    854  C   THR   116      54.107  31.337  -7.261  1.00 10.81           C   
ATOM    855  O   THR   116      55.281  31.037  -7.043  1.00 10.90           O   
ATOM    856  N   LEU   117      53.111  30.443  -7.139  1.00 10.65           N   
ATOM    857  CA  LEU   117      53.397  29.054  -6.872  1.00 11.57           C   
ATOM    858  CB  LEU   117      52.112  28.318  -6.508  1.00 13.58           C   
ATOM    859  CG  LEU   117      52.267  26.938  -5.927  1.00 15.08           C   
ATOM    860  CD1 LEU   117      53.210  26.882  -4.713  1.00 15.21           C   
ATOM    861  CD2 LEU   117      50.892  26.459  -5.508  1.00 20.08           C   
ATOM    862  C   LEU   117      54.128  28.385  -8.054  1.00 11.71           C   
ATOM    863  O   LEU   117      55.090  27.647  -7.835  1.00 11.53           O   
ATOM    864  N   GLU   118      53.677  28.629  -9.304  1.00 10.97           N   
ATOM    865  CA  GLU   118      54.432  28.137 -10.468  1.00 11.93           C   
ATOM    866  CB  GLU   118      53.781  28.614 -11.780  1.00 12.82           C   
ATOM    867  CG  GLU   118      52.352  28.140 -12.018  1.00 13.54           C   
ATOM    868  CD  GLU   118      52.217  26.721 -12.454  1.00 14.20           C   
ATOM    869  OE1 GLU   118      53.212  25.982 -12.591  1.00 14.84           O   
ATOM    870  OE2 GLU   118      51.045  26.344 -12.727  1.00 16.67           O   
ATOM    871  C   GLU   118      55.874  28.602 -10.409  1.00 11.11           C   
ATOM    872  O   GLU   118      56.819  27.819 -10.628  1.00 11.62           O   
ATOM    873  N   ASN   119      56.072  29.908 -10.138  1.00 11.09           N   
ATOM    874  CA  ASN   119      57.416  30.466 -10.063  1.00 11.42           C   
ATOM    875  CB  ASN   119      57.381  31.936  -9.701  1.00 11.06           C   
ATOM    876  CG  ASN   119      56.869  32.840 -10.796  1.00 12.92           C   
ATOM    877  OD1 ASN   119      56.782  32.446 -11.968  1.00 15.02           O   
ATOM    878  ND2 ASN   119      56.551  34.081 -10.425  1.00 13.41           N   
ATOM    879  C   ASN   119      58.220  29.725  -8.984  1.00 10.52           C   
ATOM    880  O   ASN   119      59.390  29.389  -9.185  1.00 11.31           O   
ATOM    881  N   PHE   120      57.592  29.496  -7.832  1.00 10.50           N   
ATOM    882  CA  PHE   120      58.290  28.902  -6.709  1.00 11.22           C   
ATOM    883  CB  PHE   120      57.411  28.982  -5.483  1.00 11.21           C   
ATOM    884  CG  PHE   120      58.099  28.440  -4.258  1.00 11.00           C   
ATOM    885  CD1 PHE   120      59.178  29.128  -3.713  1.00 12.54           C   
ATOM    886  CE1 PHE   120      59.848  28.651  -2.587  1.00 13.05           C   
ATOM    887  CZ  PHE   120      59.483  27.444  -2.045  1.00 12.63           C   
ATOM    888  CE2 PHE   120      58.424  26.711  -2.578  1.00 12.25           C   
ATOM    889  CD2 PHE   120      57.721  27.230  -3.695  1.00 11.46           C   
ATOM    890  C   PHE   120      58.690  27.454  -6.992  1.00 10.27           C   
ATOM    891  O   PHE   120      59.775  27.005  -6.595  1.00 11.08           O   
ATOM    892  N   ILE   121      57.822  26.705  -7.680  1.00 10.73           N   
ATOM    893  CA  ILE   121      58.169  25.320  -8.057  1.00 11.40           C   
ATOM    894  CB  ILE   121      56.964  24.627  -8.692  1.00 12.02           C   
ATOM    895  CG1 ILE   121      55.867  24.430  -7.615  1.00 13.40           C   
ATOM    896  CD1 ILE   121      54.498  24.068  -8.196  1.00 13.92           C   
ATOM    897  CG2 ILE   121      57.390  23.318  -9.346  1.00 13.98           C   
ATOM    898  C   ILE   121      59.390  25.320  -8.976  1.00 11.14           C   
ATOM    899  O   ILE   121      60.298  24.507  -8.817  1.00 12.04           O   
ATOM    900  N   GLU   122      59.427  26.244  -9.926  1.00 11.34           N   
ATOM    901  CA  GLU   122      60.597  26.328 -10.831  1.00 12.36           C   
ATOM    902  CB  GLU   122      60.266  27.345 -11.918  1.00 14.04           C   
ATOM    903  CG  GLU   122      59.168  26.797 -12.820  1.00 16.00           C   
ATOM    904  CD  GLU   122      58.384  27.855 -13.607  1.00 19.04           C   
ATOM    905  OE1 GLU   122      58.820  29.023 -13.668  1.00 25.16           O   
ATOM    906  OE2 GLU   122      57.291  27.515 -14.127  1.00 20.10           O   
ATOM    907  C   GLU   122      61.868  26.719 -10.061  1.00 12.18           C   
ATOM    908  O   GLU   122      62.935  26.117 -10.256  1.00 12.46           O   
ATOM    909  N   GLU   123      61.735  27.694  -9.165  1.00 11.37           N   
ATOM    910  CA  GLU   123      62.890  28.179  -8.389  1.00 12.52           C   
ATOM    911  CB  GLU   123      62.443  29.380  -7.555  1.00 13.67           C   
ATOM    912  CG  GLU   123      62.158  30.608  -8.414  1.00 15.26           C   
ATOM    913  CD  GLU   123      61.076  31.546  -7.892  1.00 15.52           C   
ATOM    914  OE1 GLU   123      60.657  31.443  -6.691  1.00 15.68           O   
ATOM    915  OE2 GLU   123      60.627  32.433  -8.684  1.00 16.14           O   
ATOM    916  C   GLU   123      63.419  27.089  -7.500  1.00 12.27           C   
ATOM    917  O   GLU   123      64.643  26.899  -7.379  1.00 12.96           O   
ATOM    918  N   THR   124      62.533  26.338  -6.865  1.00 11.15           N   
ATOM    919  CA  THR   124      63.007  25.276  -6.007  1.00 12.18           C   
ATOM    920  CB  THR   124      61.993  24.931  -4.971  1.00 16.23           C   
ATOM    921  OG1 THR   124      60.786  24.645  -5.587  1.00 18.82           O   
ATOM    922  CG2 THR   124      61.717  26.093  -4.016  1.00 18.78           C   
ATOM    923  C   THR   124      63.539  24.072  -6.762  1.00 11.29           C   
ATOM    924  O   THR   124      64.457  23.406  -6.273  1.00 11.17           O   
ATOM    925  N   SER   125      63.005  23.807  -7.947  1.00 11.71           N   
ATOM    926  CA  SER   125      63.599  22.758  -8.760  1.00 12.45           C   
ATOM    927  CB  SER   125      62.760  22.585 -10.042  1.00 14.80           C   
ATOM    928  OG  SER   125      61.474  22.066  -9.744  1.00 16.93           O   
ATOM    929  C   SER   125      65.055  23.079  -9.084  1.00 12.61           C   
ATOM    930  O   SER   125      65.904  22.184  -9.110  1.00 12.96           O   
ATOM    931  N   LEU   126      65.335  24.345  -9.374  1.00 11.78           N   
ATOM    932  CA  LEU   126      66.721  24.724  -9.595  1.00 11.96           C   
ATOM    933  CB  LEU   126      66.751  26.112 -10.178  1.00 14.02           C   
ATOM    934  CG  LEU   126      66.341  26.230 -11.635  1.00 15.57           C   
ATOM    935  CD1 LEU   126      66.342  27.694 -12.037  1.00 20.89           C   
ATOM    936  CD2 LEU   126      67.328  25.408 -12.530  1.00 19.36           C   
ATOM    937  C   LEU   126      67.513  24.697  -8.299  1.00 12.07           C   
ATOM    938  O   LEU   126      68.643  24.211  -8.292  1.00 13.08           O   
ATOM    939  N   ARG   127      66.943  25.186  -7.202  1.00 11.36           N   
ATOM    940  CA  ARG   127      67.699  25.263  -5.959  1.00 11.31           C   
ATOM    941  CB  ARG   127      66.851  25.901  -4.887  1.00 12.58           C   
ATOM    942  CG  ARG   127      67.632  26.037  -3.556  1.00 12.53           C   
ATOM    943  CD  ARG   127      66.932  26.937  -2.586  1.00 16.27           C   
ATOM    944  NE  ARG   127      67.620  27.035  -1.286  1.00 14.00           N   
ATOM    945  CZ  ARG   127      68.913  27.423  -1.036  0.60 13.25           C   
ATOM    947  NH1 ARG   127      69.780  27.813  -1.984  0.60 14.11           N   
ATOM    949  NH2 ARG   127      69.384  27.385   0.197  0.60 13.38           N   
ATOM    951  C   ARG   127      68.159  23.921  -5.460  1.00 12.41           C   
ATOM    952  O   ARG   127      69.300  23.781  -5.011  1.00 13.03           O   
ATOM    953  N   TYR   128      67.279  22.930  -5.547  1.00 12.49           N   
ATOM    954  CA  TYR   128      67.552  21.619  -4.937  1.00 14.13           C   
ATOM    955  CB  TYR   128      66.312  21.102  -4.176  1.00 16.50           C   
ATOM    956  CG  TYR   128      65.796  22.023  -3.061  1.00 15.98           C   
ATOM    957  CD1 TYR   128      66.627  22.426  -2.022  1.00 18.15           C   
ATOM    958  CE1 TYR   128      66.126  23.261  -0.974  1.00 16.08           C   
ATOM    959  CZ  TYR   128      64.829  23.755  -1.062  1.00 17.11           C   
ATOM    960  OH  TYR   128      64.371  24.629  -0.101  1.00 18.96           O   
ATOM    961  CE2 TYR   128      63.988  23.397  -2.129  1.00 17.92           C   
ATOM    962  CD2 TYR   128      64.480  22.537  -3.120  1.00 18.88           C   
ATOM    963  C   TYR   128      67.961  20.592  -5.972  1.00 14.34           C   
ATOM    964  O   TYR   128      68.021  19.414  -5.668  1.00 18.01           O   
ATOM    965  N   SER   129      68.211  21.034  -7.224  1.00 13.36           N   
ATOM    966  CA  SER   129      68.605  20.121  -8.292  1.00 14.43           C   
ATOM    967  CB  SER   129      70.044  19.610  -8.118  1.00 17.17           C   
ATOM    968  OG  SER   129      70.953  20.683  -8.320  1.00 18.46           O   
ATOM    969  C   SER   129      67.608  18.985  -8.477  1.00 13.70           C   
ATOM    970  O   SER   129      67.993  17.827  -8.640  1.00 17.14           O   
ATOM    971  N   LEU   130      66.332  19.341  -8.552  1.00 12.78           N   
ATOM    972  CA  LEU   130      65.286  18.366  -8.877  1.00 12.83           C   
ATOM    973  CB  LEU   130      63.915  18.889  -8.395  1.00 15.72           C   
ATOM    974  CG  LEU   130      63.847  19.345  -6.925  1.00 14.87           C   
ATOM    975  CD1 LEU   130      62.422  19.751  -6.591  1.00 16.84           C   
ATOM    976  CD2 LEU   130      64.398  18.240  -5.992  1.00 16.42           C   
ATOM    977  C   LEU   130      65.250  18.097 -10.399  1.00 13.50           C   
ATOM    978  O   LEU   130      65.642  18.935 -11.195  1.00 19.22           O   
ATOM    979  N   SER   131      64.751  16.914 -10.737  1.00 13.47           N   
ATOM    980  CA  SER   131      64.439  16.598 -12.141  1.00 15.03           C   
ATOM    981  CB  SER   131      64.963  15.271 -12.613  0.50 16.54           C   
ATOM    983  OG  SER   131      64.560  15.191 -13.971  0.50 16.72           O   
ATOM    985  C   SER   131      62.936  16.604 -12.248  1.00 13.37           C   
ATOM    986  O   SER   131      62.266  15.637 -11.863  1.00 13.17           O   
ATOM    987  N   LEU   132      62.406  17.733 -12.680  1.00 13.41           N   
ATOM    988  CA  LEU   132      60.996  18.006 -12.610  1.00 14.00           C   
ATOM    989  CB  LEU   132      60.838  19.504 -12.495  1.00 16.81           C   
ATOM    990  CG  LEU   132      59.459  20.083 -12.491  1.00 19.58           C   
ATOM    991  CD1 LEU   132      58.776  19.546 -11.267  1.00 18.00           C   
ATOM    992  CD2 LEU   132      59.495  21.627 -12.531  1.00 20.08           C   
ATOM    993  C   LEU   132      60.273  17.501 -13.860  1.00 13.92           C   
ATOM    994  O   LEU   132      60.639  17.815 -14.976  1.00 20.65           O   
ATOM    995  N   TYR   133      59.222  16.729 -13.627  1.00 12.69           N   
ATOM    996  CA  TYR   133      58.181  16.408 -14.605  1.00 12.99           C   
ATOM    997  CB  TYR   133      57.930  14.920 -14.655  1.00 14.38           C   
ATOM    998  CG  TYR   133      56.730  14.514 -15.521  1.00 14.06           C   
ATOM    999  CD1 TYR   133      56.898  14.106 -16.845  1.00 17.05           C   
ATOM   1000  CE1 TYR   133      55.806  13.689 -17.602  1.00 18.10           C   
ATOM   1001  CZ  TYR   133      54.536  13.729 -17.069  1.00 16.73           C   
ATOM   1002  OH  TYR   133      53.457  13.309 -17.820  1.00 18.64           O   
ATOM   1003  CE2 TYR   133      54.339  14.129 -15.762  1.00 15.50           C   
ATOM   1004  CD2 TYR   133      55.428  14.523 -15.006  1.00 14.56           C   
ATOM   1005  C   TYR   133      56.909  17.125 -14.176  1.00 12.59           C   
ATOM   1006  O   TYR   133      56.509  17.037 -13.013  1.00 13.96           O   
ATOM   1007  N   GLU   134      56.260  17.807 -15.110  1.00 13.23           N   
ATOM   1008  CA  GLU   134      54.968  18.460 -14.845  1.00 13.71           C   
ATOM   1009  CB  GLU   134      55.029  19.999 -15.128  1.00 16.18           C   
ATOM   1010  CG  GLU   134      56.040  20.734 -14.244  1.00 18.29           C   
ATOM   1011  CD  GLU   134      55.871  22.234 -14.278  1.00 20.39           C   
ATOM   1012  OE1 GLU   134      55.248  22.731 -15.233  1.00 27.26           O   
ATOM   1013  OE2 GLU   134      56.342  22.936 -13.345  1.00 20.78           O   
ATOM   1014  C   GLU   134      53.918  17.846 -15.753  1.00 13.82           C   
ATOM   1015  O   GLU   134      54.159  17.679 -16.963  1.00 15.25           O   
ATOM   1016  N   SER   135      52.749  17.524 -15.203  1.00 13.85           N   
ATOM   1017  CA  SER   135      51.613  17.182 -16.039  1.00 14.43           C   
ATOM   1018  CB  SER   135      50.465  16.635 -15.189  1.00 15.04           C   
ATOM   1019  OG  SER   135      49.879  17.684 -14.426  1.00 16.23           O   
ATOM   1020  C   SER   135      51.188  18.398 -16.849  1.00 14.64           C   
ATOM   1021  O   SER   135      51.592  19.541 -16.576  1.00 15.22           O   
ATOM   1022  N   ASP   136      50.322  18.172 -17.818  1.00 15.18           N   
ATOM   1023  CA  ASP   136      49.977  19.245 -18.733  1.00 15.56           C   
ATOM   1024  CB  ASP   136      49.590  18.650 -20.076  1.00 19.57           C   
ATOM   1025  CG  ASP   136      49.302  19.691 -21.108  1.00 21.89           C   
ATOM   1026  OD1 ASP   136      49.287  20.927 -20.893  1.00 21.57           O   
ATOM   1027  OD2 ASP   136      49.104  19.220 -22.258  1.00 27.43           O   
ATOM   1028  C   ASP   136      48.821  20.059 -18.204  1.00 15.00           C   
ATOM   1029  O   ASP   136      47.696  19.572 -18.175  1.00 16.27           O   
ATOM   1030  N   ARG   137      49.065  21.331 -17.850  1.00 13.73           N   
ATOM   1031  CA  ARG   137      48.007  22.140 -17.268  1.00 14.95           C   
ATOM   1032  CB  ARG   137      48.551  23.445 -16.723  1.00 17.20           C   
ATOM   1033  CG  ARG   137      49.304  24.269 -17.775  1.00 18.40           C   
ATOM   1034  CD  ARG   137      48.408  25.266 -18.531  1.00 22.66           C   
ATOM   1035  NE  ARG   137      48.205  26.439 -17.684  1.00 20.55           N   
ATOM   1036  CZ  ARG   137      47.450  27.533 -17.909  1.00 18.49           C   
ATOM   1037  NH1 ARG   137      46.638  27.638 -18.926  1.00 18.72           N   
ATOM   1038  NH2 ARG   137      47.501  28.524 -17.029  1.00 19.27           N   
ATOM   1039  C   ARG   137      46.862  22.434 -18.225  1.00 15.04           C   
ATOM   1040  O   ARG   137      45.790  22.826 -17.777  1.00 16.94           O   
ATOM   1041  N   ASP   138      47.116  22.321 -19.527  1.00 15.77           N   
ATOM   1042  CA  ASP   138      46.101  22.619 -20.544  1.00 18.39           C   
ATOM   1043  CB  ASP   138      46.762  23.338 -21.743  1.00 21.22           C   
ATOM   1044  CG  ASP   138      47.068  24.786 -21.445  1.00 25.58           C   
ATOM   1045  OD1 ASP   138      46.414  25.349 -20.558  1.00 25.96           O   
ATOM   1046  OD2 ASP   138      47.962  25.366 -22.075  1.00 29.48           O   
ATOM   1047  C   ASP   138      45.307  21.377 -20.967  1.00 19.33           C   
ATOM   1048  O   ASP   138      44.497  21.457 -21.895  1.00 24.17           O   
ATOM   1049  N   LYS   139      45.514  20.248 -20.275  1.00 18.52           N   
ATOM   1050  CA  LYS   139      44.680  19.052 -20.470  1.00 19.14           C   
ATOM   1051  CB  LYS   139      45.544  17.785 -20.500  1.00 20.91           C   
ATOM   1052  CG  LYS   139      44.790  16.540 -20.953  0.60 21.24           C   
ATOM   1054  CD  LYS   139      45.724  15.409 -21.297  0.60 21.29           C   
ATOM   1056  CE  LYS   139      44.933  14.188 -21.765  0.60 25.23           C   
ATOM   1058  NZ  LYS   139      45.831  13.106 -22.246  0.60 26.99           N   
ATOM   1060  C   LYS   139      43.657  18.893 -19.359  1.00 20.44           C   
ATOM   1061  O   LYS   139      44.020  18.926 -18.163  1.00 24.13           O   
ATOM   1062  N   CYS   140      42.397  18.670 -19.707  1.00 20.11           N   
ATOM   1063  CA  CYS   140      41.374  18.474 -18.730  1.00 19.62           C   
ATOM   1064  CB  CYS   140      40.003  18.849 -19.338  1.00 23.62           C   
ATOM   1065  SG  CYS   140      38.629  18.778 -18.213  1.00 24.72           S   
ATOM   1066  C   CYS   140      41.401  17.001 -18.313  1.00 21.24           C   
ATOM   1067  O   CYS   140      40.965  16.120 -19.080  1.00 24.67           O   
ATOM   1068  N   GLU   141      41.943  16.717 -17.138  1.00 18.95           N   
ATOM   1069  CA  GLU   141      42.107  15.339 -16.682  1.00 19.16           C   
ATOM   1070  CB  GLU   141      43.374  14.723 -17.316  1.00 19.56           C   
ATOM   1071  CG  GLU   141      44.663  15.324 -16.770  1.00 19.73           C   
ATOM   1072  CD  GLU   141      45.917  14.788 -17.430  1.00 20.06           C   
ATOM   1073  OE1 GLU   141      45.839  13.742 -18.133  1.00 23.11           O   
ATOM   1074  OE2 GLU   141      47.015  15.357 -17.218  1.00 19.72           O   
ATOM   1075  C   GLU   141      42.152  15.310 -15.157  1.00 18.80           C   
ATOM   1076  O   GLU   141      42.476  16.310 -14.513  1.00 19.54           O   
ATOM   1077  N   THR   142      41.836  14.153 -14.579  1.00 18.69           N   
ATOM   1078  CA  THR   142      41.898  13.983 -13.129  1.00 18.90           C   
ATOM   1079  CB  THR   142      41.069  12.778 -12.691  1.00 19.74           C   
ATOM   1080  OG1 THR   142      41.654  11.610 -13.288  1.00 20.36           O   
ATOM   1081  CG2 THR   142      39.614  12.919 -13.168  1.00 23.31           C   
ATOM   1082  C   THR   142      43.347  13.723 -12.686  1.00 17.70           C   
ATOM   1083  O   THR   142      44.234  13.413 -13.508  1.00 17.35           O   
ATOM   1084  N   MET   143      43.584  13.817 -11.386  1.00 17.58           N   
ATOM   1085  CA  MET   143      44.902  13.508 -10.849  1.00 18.22           C   
ATOM   1086  CB  MET   143      44.901  13.728  -9.348  1.00 19.17           C   
ATOM   1087  CG  MET   143      46.242  13.466  -8.727  1.00 21.03           C   
ATOM   1088  SD  MET   143      46.406  14.003  -7.037  1.00 26.55           S   
ATOM   1089  CE  MET   143      46.962  15.676  -7.349  1.00 29.91           C   
ATOM   1090  C   MET   143      45.298  12.078 -11.181  1.00 17.27           C   
ATOM   1091  O   MET   143      46.440  11.822 -11.549  1.00 16.89           O   
ATOM   1092  N   ALA   144      44.353  11.141 -11.045  1.00 17.00           N   
ATOM   1093  CA  ALA   144      44.640   9.741 -11.358  1.00 18.01           C   
ATOM   1094  CB  ALA   144      43.395   8.869 -11.107  1.00 19.53           C   
ATOM   1095  C   ALA   144      45.098   9.618 -12.801  1.00 17.62           C   
ATOM   1096  O   ALA   144      46.074   8.939 -13.111  1.00 18.12           O   
ATOM   1097  N   GLU   145      44.395  10.319 -13.692  1.00 17.32           N   
ATOM   1098  CA  GLU   145      44.734  10.273 -15.123  1.00 18.23           C   
ATOM   1099  CB  GLU   145      43.653  10.990 -15.968  1.00 18.95           C   
ATOM   1100  CG  GLU   145      42.335  10.183 -16.052  1.00 21.75           C   
ATOM   1101  CD  GLU   145      41.169  10.972 -16.589  1.00 23.57           C   
ATOM   1102  OE1 GLU   145      41.119  12.216 -16.537  1.00 23.10           O   
ATOM   1103  OE2 GLU   145      40.217  10.314 -17.057  1.00 28.64           O   
ATOM   1104  C   GLU   145      46.119  10.876 -15.390  1.00 17.32           C   
ATOM   1105  O   GLU   145      46.916  10.354 -16.173  1.00 18.35           O   
ATOM   1106  N   ALA   146      46.421  11.999 -14.738  1.00 16.50           N   
ATOM   1107  CA  ALA   146      47.735  12.621 -14.911  1.00 16.21           C   
ATOM   1108  CB  ALA   146      47.794  13.964 -14.148  1.00 16.26           C   
ATOM   1109  C   ALA   146      48.841  11.680 -14.429  1.00 16.17           C   
ATOM   1110  O   ALA   146      49.918  11.596 -15.040  1.00 16.55           O   
ATOM   1111  N   PHE   147      48.595  10.959 -13.338  1.00 16.34           N   
ATOM   1112  CA  PHE   147      49.588  10.022 -12.813  1.00 16.58           C   
ATOM   1113  CB  PHE   147      49.300   9.653 -11.351  1.00 17.08           C   
ATOM   1114  CG  PHE   147      49.975  10.547 -10.372  1.00 15.54           C   
ATOM   1115  CD1 PHE   147      51.342  10.483 -10.175  1.00 17.18           C   
ATOM   1116  CE1 PHE   147      51.976  11.310  -9.207  1.00 18.73           C   
ATOM   1117  CZ  PHE   147      51.210  12.221  -8.484  1.00 18.55           C   
ATOM   1118  CE2 PHE   147      49.853  12.284  -8.688  1.00 19.88           C   
ATOM   1119  CD2 PHE   147      49.237  11.436  -9.625  1.00 18.59           C   
ATOM   1120  C   PHE   147      49.697   8.791 -13.709  1.00 16.18           C   
ATOM   1121  O   PHE   147      50.769   8.207 -13.806  1.00 18.29           O   
ATOM   1122  N   GLU   148      48.618   8.400 -14.378  1.00 17.52           N   
ATOM   1123  CA  GLU   148      48.725   7.287 -15.340  1.00 18.36           C   
ATOM   1124  CB  GLU   148      47.345   6.919 -15.876  1.00 21.09           C   
ATOM   1125  CG  GLU   148      47.393   5.838 -16.941  1.00 28.35           C   
ATOM   1126  CD  GLU   148      48.091   4.573 -16.461  1.00 34.09           C   
ATOM   1127  OE1 GLU   148      47.805   4.124 -15.316  1.00 34.28           O   
ATOM   1128  OE2 GLU   148      48.933   4.041 -17.238  1.00 39.12           O   
ATOM   1129  C   GLU   148      49.670   7.649 -16.471  1.00 19.33           C   
ATOM   1130  O   GLU   148      50.515   6.838 -16.879  1.00 20.27           O   
ATOM   1131  N   THR   149      49.556   8.876 -16.972  1.00 17.53           N   
ATOM   1132  CA  THR   149      50.467   9.342 -18.006  1.00 19.01           C   
ATOM   1133  CB  THR   149      49.999  10.696 -18.561  1.00 19.70           C   
ATOM   1134  OG1 THR   149      48.710  10.503 -19.143  1.00 21.04           O   
ATOM   1135  CG2 THR   149      51.008  11.260 -19.563  1.00 21.64           C   
ATOM   1136  C   THR   149      51.905   9.406 -17.515  1.00 17.94           C   
ATOM   1137  O   THR   149      52.838   8.981 -18.211  1.00 18.87           O   
ATOM   1138  N   PHE   150      52.092   9.892 -16.295  1.00 17.20           N   
ATOM   1139  CA  PHE   150      53.399   9.901 -15.666  1.00 16.17           C   
ATOM   1140  CB  PHE   150      53.267  10.502 -14.264  1.00 17.71           C   
ATOM   1141  CG  PHE   150      54.479  10.323 -13.445  1.00 18.84           C   
ATOM   1142  CD1 PHE   150      55.556  11.145 -13.609  1.00 18.71           C   
ATOM   1143  CE1 PHE   150      56.729  10.971 -12.837  1.00 23.96           C   
ATOM   1144  CZ  PHE   150      56.761   9.915 -11.890  1.00 22.28           C   
ATOM   1145  CE2 PHE   150      55.701   9.074 -11.767  1.00 23.10           C   
ATOM   1146  CD2 PHE   150      54.552   9.281 -12.524  1.00 22.13           C   
ATOM   1147  C   PHE   150      54.021   8.509 -15.605  1.00 17.24           C   
ATOM   1148  O   PHE   150      55.189   8.325 -15.942  1.00 17.57           O   
ATOM   1149  N   LEU   151      53.243   7.516 -15.220  1.00 17.92           N   
ATOM   1150  CA  LEU   151      53.792   6.159 -15.131  1.00 21.10           C   
ATOM   1151  CB  LEU   151      52.846   5.248 -14.334  1.00 24.65           C   
ATOM   1152  CG  LEU   151      53.233   4.810 -12.909  1.00 31.80           C   
ATOM   1153  CD1 LEU   151      53.496   6.004 -11.974  1.00 34.09           C   
ATOM   1154  CD2 LEU   151      54.412   3.821 -12.922  1.00 32.25           C   
ATOM   1155  C   LEU   151      54.159   5.578 -16.517  1.00 20.87           C   
ATOM   1156  O   LEU   151      55.144   4.825 -16.623  1.00 21.92           O   
ATOM   1157  N   GLN   152      53.465   6.001 -17.581  1.00 19.96           N   
ATOM   1158  CA  GLN   152      53.869   5.608 -18.958  1.00 22.23           C   
ATOM   1159  CB  GLN   152      52.841   6.093 -19.987  1.00 24.73           C   
ATOM   1160  CG  GLN   152      51.493   5.398 -19.917  1.00 31.13           C   
ATOM   1161  CD  GLN   152      50.401   6.085 -20.781  1.00 33.42           C   
ATOM   1162  OE1 GLN   152      50.595   7.193 -21.306  1.00 37.54           O   
ATOM   1163  NE2 GLN   152      49.244   5.428 -20.903  1.00 38.35           N   
ATOM   1164  C   GLN   152      55.241   6.184 -19.314  1.00 23.16           C   
ATOM   1165  O   GLN   152      56.020   5.546 -20.022  1.00 23.49           O   
ATOM   1166  N   VAL   153      55.541   7.391 -18.844  1.00 19.81           N   
ATOM   1167  CA  VAL   153      56.835   8.009 -19.081  1.00 20.49           C   
ATOM   1168  CB  VAL   153      56.761   9.543 -18.885  1.00 22.18           C   
ATOM   1169  CG1 VAL   153      58.109  10.221 -19.139  1.00 23.13           C   
ATOM   1170  CG2 VAL   153      55.674  10.131 -19.818  1.00 22.44           C   
ATOM   1171  C   VAL   153      57.894   7.369 -18.208  1.00 19.99           C   
ATOM   1172  O   VAL   153      59.017   7.151 -18.656  1.00 22.74           O   
ATOM   1173  N   PHE   154      57.539   7.016 -16.964  1.00 17.51           N   
ATOM   1174  CA  PHE   154      58.508   6.488 -15.999  1.00 18.74           C   
ATOM   1175  CB  PHE   154      58.712   7.469 -14.841  1.00 18.79           C   
ATOM   1176  CG  PHE   154      59.209   8.833 -15.284  1.00 21.28           C   
ATOM   1177  CD1 PHE   154      60.562   9.057 -15.470  1.00 25.70           C   
ATOM   1178  CE1 PHE   154      61.027  10.323 -15.839  1.00 25.55           C   
ATOM   1179  CZ  PHE   154      60.123  11.364 -15.996  1.00 24.73           C   
ATOM   1180  CE2 PHE   154      58.786  11.155 -15.822  1.00 23.69           C   
ATOM   1181  CD2 PHE   154      58.325   9.894 -15.443  1.00 20.84           C   
ATOM   1182  C   PHE   154      58.046   5.141 -15.463  1.00 18.66           C   
ATOM   1183  O   PHE   154      57.664   5.017 -14.280  1.00 17.53           O   
ATOM   1184  N   PRO   155      58.057   4.104 -16.302  1.00 19.62           N   
ATOM   1185  CA  PRO   155      57.489   2.827 -15.894  1.00 19.79           C   
ATOM   1186  CB  PRO   155      57.456   2.032 -17.216  1.00 22.13           C   
ATOM   1187  CG  PRO   155      58.550   2.612 -18.029  1.00 24.22           C   
ATOM   1188  CD  PRO   155      58.548   4.078 -17.708  1.00 19.80           C   
ATOM   1189  C   PRO   155      58.267   2.079 -14.811  1.00 19.74           C   
ATOM   1190  O   PRO   155      57.735   1.107 -14.283  1.00 24.10           O   
ATOM   1191  N   GLU   156      59.471   2.516 -14.481  1.00 18.69           N   
ATOM   1192  CA  GLU   156      60.259   1.910 -13.416  1.00 21.95           C   
ATOM   1193  CB  GLU   156      61.732   2.338 -13.557  1.00 24.46           C   
ATOM   1194  CG  GLU   156      62.054   3.827 -13.287  1.00 28.89           C   
ATOM   1195  CD  GLU   156      61.904   4.780 -14.505  1.00 29.62           C   
ATOM   1196  OE1 GLU   156      61.101   4.518 -15.440  1.00 25.73           O   
ATOM   1197  OE2 GLU   156      62.583   5.839 -14.492  1.00 31.20           O   
ATOM   1198  C   GLU   156      59.758   2.331 -12.015  1.00 18.34           C   
ATOM   1199  O   GLU   156      60.257   1.834 -10.988  1.00 20.65           O   
ATOM   1200  N   THR   157      58.862   3.320 -11.971  1.00 18.16           N   
ATOM   1201  CA  THR   157      58.423   3.913 -10.708  1.00 16.88           C   
ATOM   1202  CB  THR   157      57.507   5.122 -10.963  1.00 16.67           C   
ATOM   1203  OG1 THR   157      58.165   6.055 -11.812  1.00 17.68           O   
ATOM   1204  CG2 THR   157      57.149   5.814  -9.627  1.00 19.44           C   
ATOM   1205  C   THR   157      57.679   2.864  -9.920  1.00 15.00           C   
ATOM   1206  O   THR   157      56.723   2.271 -10.437  1.00 18.47           O   
ATOM   1207  N   LYS   158      58.054   2.685  -8.646  1.00 15.45           N   
ATOM   1208  CA  LYS   158      57.355   1.754  -7.765  1.00 14.32           C   
ATOM   1209  CB  LYS   158      58.337   0.750  -7.157  1.00 16.07           C   
ATOM   1210  CG  LYS   158      59.086  -0.124  -8.160  1.00 18.64           C   
ATOM   1211  CD  LYS   158      59.991  -1.083  -7.420  0.45 20.40           C   
ATOM   1213  CE  LYS   158      59.304  -2.362  -7.021  0.45 26.72           C   
ATOM   1215  NZ  LYS   158      60.295  -3.292  -6.397  0.45 27.38           N   
ATOM   1217  C   LYS   158      56.626   2.471  -6.650  1.00 13.43           C   
ATOM   1218  O   LYS   158      55.692   1.888  -6.056  1.00 13.61           O   
ATOM   1219  N   ALA   159      57.043   3.689  -6.307  1.00 13.26           N   
ATOM   1220  CA  ALA   159      56.517   4.360  -5.125  1.00 13.73           C   
ATOM   1221  CB  ALA   159      57.295   3.930  -3.880  1.00 14.28           C   
ATOM   1222  C   ALA   159      56.637   5.853  -5.340  1.00 12.44           C   
ATOM   1223  O   ALA   159      57.547   6.330  -6.042  1.00 14.09           O   
ATOM   1224  N   ILE   160      55.703   6.605  -4.751  1.00 12.45           N   
ATOM   1225  CA  ILE   160      55.682   8.065  -4.873  1.00 13.31           C   
ATOM   1226  CB  ILE   160      54.642   8.563  -5.853  1.00 15.48           C   
ATOM   1227  CG1 ILE   160      55.019   7.995  -7.235  1.00 19.32           C   
ATOM   1228  CD1 ILE   160      54.286   8.522  -8.365  1.00 19.74           C   
ATOM   1229  CG2 ILE   160      54.670  10.104  -5.919  1.00 18.51           C   
ATOM   1230  C   ILE   160      55.499   8.678  -3.487  1.00 12.17           C   
ATOM   1231  O   ILE   160      54.621   8.259  -2.727  1.00 11.98           O   
ATOM   1232  N   VAL   161      56.355   9.651  -3.181  1.00 11.89           N   
ATOM   1233  CA  VAL   161      56.291  10.370  -1.922  1.00 12.05           C   
ATOM   1234  CB  VAL   161      57.660  10.970  -1.568  1.00 13.05           C   
ATOM   1235  CG1 VAL   161      57.583  11.705  -0.241  1.00 14.59           C   
ATOM   1236  CG2 VAL   161      58.739   9.912  -1.540  1.00 15.73           C   
ATOM   1237  C   VAL   161      55.243  11.480  -2.026  1.00 11.97           C   
ATOM   1238  O   VAL   161      55.289  12.295  -2.977  1.00 12.95           O   
ATOM   1239  N   ILE   162      54.323  11.524  -1.063  1.00 11.86           N   
ATOM   1240  CA  ILE   162      53.207  12.474  -1.087  1.00 12.75           C   
ATOM   1241  CB  ILE   162      51.887  11.755  -1.289  1.00 13.92           C   
ATOM   1242  CG1 ILE   162      51.922  11.030  -2.626  1.00 17.08           C   
ATOM   1243  CD1 ILE   162      50.739  10.148  -2.879  1.00 22.16           C   
ATOM   1244  CG2 ILE   162      50.706  12.714  -1.311  1.00 15.35           C   
ATOM   1245  C   ILE   162      53.175  13.247   0.218  1.00 12.89           C   
ATOM   1246  O   ILE   162      53.178  12.654   1.292  1.00 12.86           O   
ATOM   1247  N   GLY   163      53.071  14.570   0.138  0.50 13.46           N   
ATOM   1249  CA  GLY   163      53.167  15.414   1.353  0.50 13.94           C   
ATOM   1251  C   GLY   163      51.862  15.789   2.052  0.50 12.50           C   
ATOM   1253  O   GLY   163      51.711  16.877   2.575  0.50 16.58           O   
ATOM   1255  N   ILE   164      50.941  14.871   2.120  0.50 14.59           N   
ATOM   1257  CA  ILE   164      49.659  15.113   2.772  1.00 13.95           C   
ATOM   1258  CB  ILE   164      48.687  14.210   2.029  1.00 13.94           C   
ATOM   1259  CG1 ILE   164      47.238  14.496   2.403  1.00 16.21           C   
ATOM   1260  CD1 ILE   164      46.239  13.923   1.397  1.00 16.31           C   
ATOM   1261  CG2 ILE   164      49.098  12.757   2.148  1.00 15.93           C   
ATOM   1262  C   ILE   164      49.682  14.880   4.283  1.00 11.76           C   
ATOM   1263  O   ILE   164      50.475  14.062   4.797  1.00 12.19           O   
ATOM   1264  N   ARG   165      48.817  15.591   4.978  1.00 12.44           N   
ATOM   1265  CA  ARG   165      48.666  15.422   6.427  1.00 12.23           C   
ATOM   1266  CB  ARG   165      48.850  16.768   7.169  1.00 13.69           C   
ATOM   1267  CG  ARG   165      50.185  17.392   6.857  1.00 14.13           C   
ATOM   1268  CD  ARG   165      50.561  18.661   7.689  1.00 17.12           C   
ATOM   1269  NE  ARG   165      49.579  19.742   7.691  0.60 12.27           N   
ATOM   1271  CZ  ARG   165      48.638  19.918   8.643  0.60 14.27           C   
ATOM   1273  NH1 ARG   165      48.525  19.090   9.669  0.60 14.13           N   
ATOM   1275  NH2 ARG   165      47.812  20.938   8.561  0.60 16.46           N   
ATOM   1277  C   ARG   165      47.284  14.867   6.724  1.00 11.58           C   
ATOM   1278  O   ARG   165      46.333  15.053   5.959  1.00 12.14           O   
ATOM   1279  N   HIS   166      47.134  14.229   7.883  1.00 11.78           N   
ATOM   1280  CA  HIS   166      45.801  13.688   8.223  1.00 12.27           C   
ATOM   1281  CB  HIS   166      45.820  12.980   9.575  1.00 13.16           C   
ATOM   1282  CG  HIS   166      46.380  11.596   9.554  1.00 13.51           C   
ATOM   1283  ND1 HIS   166      45.936  10.616   8.683  1.00 14.70           N   
ATOM   1284  CE1 HIS   166      46.615   9.493   8.914  1.00 15.84           C   
ATOM   1285  NE2 HIS   166      47.450   9.705   9.922  1.00 16.13           N   
ATOM   1286  CD2 HIS   166      47.316  11.014  10.337  1.00 14.70           C   
ATOM   1287  C   HIS   166      44.701  14.734   8.259  1.00 12.66           C   
ATOM   1288  O   HIS   166      43.554  14.403   7.977  1.00 13.55           O   
ATOM   1289  N   THR   167      45.032  15.987   8.604  1.00 12.87           N   
ATOM   1290  CA  THR   167      44.022  17.018   8.687  1.00 14.29           C   
ATOM   1291  CB  THR   167      44.471  18.198   9.574  1.00 16.49           C   
ATOM   1292  OG1 THR   167      45.652  18.731   8.997  1.00 17.77           O   
ATOM   1293  CG2 THR   167      44.753  17.755  11.017  1.00 17.92           C   
ATOM   1294  C   THR   167      43.604  17.577   7.329  1.00 14.05           C   
ATOM   1295  O   THR   167      42.636  18.328   7.256  1.00 15.94           O   
ATOM   1296  N   ASP   168      44.324  17.224   6.270  1.00 13.28           N   
ATOM   1297  CA  ASP   168      43.952  17.683   4.943  1.00 13.62           C   
ATOM   1298  CB  ASP   168      45.111  17.419   3.968  1.00 14.78           C   
ATOM   1299  CG  ASP   168      46.333  18.303   4.222  1.00 16.92           C   
ATOM   1300  OD1 ASP   168      46.175  19.449   4.643  1.00 19.84           O   
ATOM   1301  OD2 ASP   168      47.449  17.842   3.927  1.00 19.77           O   
ATOM   1302  C   ASP   168      42.721  16.942   4.424  1.00 13.69           C   
ATOM   1303  O   ASP   168      42.433  15.834   4.870  1.00 14.43           O   
ATOM   1304  N   PRO   169      42.015  17.527   3.448  1.00 15.27           N   
ATOM   1305  CA  PRO   169      40.952  16.766   2.793  1.00 16.61           C   
ATOM   1306  CB  PRO   169      40.522  17.693   1.640  1.00 20.23           C   
ATOM   1307  CG  PRO   169      40.811  19.041   2.152  1.00 20.82           C   
ATOM   1308  CD  PRO   169      42.143  18.881   2.896  1.00 17.88           C   
ATOM   1309  C   PRO   169      41.486  15.427   2.272  1.00 15.96           C   
ATOM   1310  O   PRO   169      42.599  15.354   1.739  1.00 16.74           O   
ATOM   1311  N   PHE   170      40.684  14.377   2.408  1.00 18.17           N   
ATOM   1312  CA  PHE   170      41.090  13.037   2.022  1.00 19.37           C   
ATOM   1313  CB  PHE   170      41.336  12.925   0.505  1.00 22.37           C   
ATOM   1314  CG  PHE   170      40.293  13.639  -0.312  1.00 26.63           C   
ATOM   1315  CD1 PHE   170      38.969  13.213  -0.273  1.00 29.17           C   
ATOM   1316  CE1 PHE   170      37.970  13.905  -0.995  1.00 29.54           C   
ATOM   1317  CZ  PHE   170      38.317  15.030  -1.721  1.00 28.66           C   
ATOM   1318  CE2 PHE   170      39.635  15.485  -1.737  1.00 29.34           C   
ATOM   1319  CD2 PHE   170      40.615  14.790  -1.024  1.00 25.61           C   
ATOM   1320  C   PHE   170      42.274  12.516   2.802  1.00 17.53           C   
ATOM   1321  O   PHE   170      42.920  11.569   2.339  1.00 18.28           O   
ATOM   1322  N   GLY   171      42.533  13.082   3.994  1.00 15.77           N   
ATOM   1323  CA  GLY   171      43.682  12.656   4.779  1.00 14.19           C   
ATOM   1324  C   GLY   171      43.372  11.673   5.894  1.00 14.07           C   
ATOM   1325  O   GLY   171      44.292  11.128   6.507  1.00 14.15           O   
ATOM   1326  N   GLU   172      42.098  11.451   6.150  1.00 15.55           N   
ATOM   1327  CA  GLU   172      41.731  10.673   7.313  1.00 15.57           C   
ATOM   1328  CB  GLU   172      40.211  10.736   7.550  1.00 16.87           C   
ATOM   1329  CG  GLU   172      39.767  10.011   8.806  1.00 19.47           C   
ATOM   1330  CD  GLU   172      38.250  10.134   9.108  1.00 22.42           C   
ATOM   1331  OE1 GLU   172      37.524  10.819   8.373  1.00 24.23           O   
ATOM   1332  OE2 GLU   172      37.809   9.500  10.103  1.00 25.26           O   
ATOM   1333  C   GLU   172      42.159   9.213   7.214  1.00 15.79           C   
ATOM   1334  O   GLU   172      42.686   8.695   8.181  1.00 19.95           O   
ATOM   1335  N   HIS   173      41.913   8.590   6.063  1.00 15.43           N   
ATOM   1336  CA  HIS   173      42.086   7.150   5.877  1.00 14.78           C   
ATOM   1337  CB  HIS   173      40.841   6.547   5.262  1.00 16.23           C   
ATOM   1338  CG  HIS   173      39.649   6.681   6.156  1.00 16.34           C   
ATOM   1339  ND1 HIS   173      38.581   7.483   5.846  1.00 17.76           N   
ATOM   1340  CE1 HIS   173      37.683   7.422   6.824  1.00 17.90           C   
ATOM   1341  NE2 HIS   173      38.146   6.627   7.766  1.00 19.79           N   
ATOM   1342  CD2 HIS   173      39.406   6.195   7.396  1.00 17.82           C   
ATOM   1343  C   HIS   173      43.353   6.841   5.101  1.00 14.43           C   
ATOM   1344  O   HIS   173      43.325   6.131   4.036  1.00 16.39           O   
ATOM   1345  N   LEU   174      44.469   7.372   5.654  1.00 13.14           N   
ATOM   1346  CA  LEU   174      45.774   7.179   5.063  1.00 12.38           C   
ATOM   1347  CB  LEU   174      46.327   8.517   4.556  1.00 12.31           C   
ATOM   1348  CG  LEU   174      45.474   9.245   3.523  1.00 12.44           C   
ATOM   1349  CD1 LEU   174      46.235  10.525   3.101  1.00 14.34           C   
ATOM   1350  CD2 LEU   174      45.219   8.394   2.302  1.00 14.37           C   
ATOM   1351  C   LEU   174      46.755   6.596   6.051  1.00 11.65           C   
ATOM   1352  O   LEU   174      46.630   6.799   7.256  1.00 12.50           O   
ATOM   1353  N   LYS   175      47.745   5.874   5.536  1.00 11.41           N   
ATOM   1354  CA  LYS   175      48.823   5.311   6.317  1.00 11.66           C   
ATOM   1355  CB  LYS   175      48.684   3.792   6.441  1.00 13.84           C   
ATOM   1356  CG  LYS   175      47.425   3.385   7.171  1.00 17.27           C   
ATOM   1357  CD  LYS   175      47.447   2.002   7.830  0.70 16.40           C   
ATOM   1359  CE  LYS   175      46.356   1.799   8.881  0.70 14.94           C   
ATOM   1361  NZ  LYS   175      46.191   0.353   9.289  0.70 17.00           N   
ATOM   1363  C   LYS   175      50.146   5.650   5.681  1.00 11.03           C   
ATOM   1364  O   LYS   175      50.204   6.024   4.508  1.00 11.86           O   
ATOM   1365  N   PRO   176      51.249   5.536   6.448  1.00 11.70           N   
ATOM   1366  CA  PRO   176      52.554   5.932   5.873  1.00 12.22           C   
ATOM   1367  CB  PRO   176      53.535   5.708   7.036  1.00 12.86           C   
ATOM   1368  CG  PRO   176      52.672   5.941   8.263  1.00 14.05           C   
ATOM   1369  CD  PRO   176      51.339   5.271   7.891  1.00 12.37           C   
ATOM   1370  C   PRO   176      52.991   5.180   4.624  1.00 11.85           C   
ATOM   1371  O   PRO   176      53.713   5.743   3.800  1.00 12.20           O   
ATOM   1372  N   ILE   177      52.594   3.922   4.513  1.00 11.68           N   
ATOM   1373  CA  ILE   177      52.903   3.091   3.331  1.00 11.84           C   
ATOM   1374  CB  ILE   177      53.909   2.007   3.679  1.00 13.63           C   
ATOM   1375  CG1 ILE   177      55.289   2.654   3.831  0.60 15.83           C   
ATOM   1377  CD1 ILE   177      56.335   1.741   4.447  0.60 15.05           C   
ATOM   1379  CG2 ILE   177      54.064   1.034   2.495  1.00 15.63           C   
ATOM   1380  C   ILE   177      51.576   2.483   2.897  1.00 11.62           C   
ATOM   1381  O   ILE   177      50.927   1.792   3.683  1.00 12.17           O   
ATOM   1382  N   GLN   178      51.148   2.762   1.671  1.00 11.57           N   
ATOM   1383  CA  GLN   178      49.780   2.447   1.288  1.00 12.28           C   
ATOM   1384  CB  GLN   178      48.876   3.621   1.773  1.00 13.22           C   
ATOM   1385  CG  GLN   178      47.394   3.419   1.575  1.00 14.86           C   
ATOM   1386  CD  GLN   178      46.593   4.568   2.138  1.00 12.59           C   
ATOM   1387  OE1 GLN   178      47.131   5.548   2.680  1.00 12.37           O   
ATOM   1388  NE2 GLN   178      45.261   4.396   2.130  1.00 14.81           N   
ATOM   1389  C   GLN   178      49.665   2.374  -0.238  1.00 11.65           C   
ATOM   1390  O   GLN   178      49.937   3.373  -0.931  1.00 13.11           O   
ATOM   1391  N   LYS   179      49.229   1.253  -0.793  1.00 11.66           N   
ATOM   1392  CA  LYS   179      49.045   1.184  -2.252  1.00 11.61           C   
ATOM   1393  CB  LYS   179      48.641  -0.238  -2.682  1.00 12.43           C   
ATOM   1394  CG  LYS   179      49.802  -1.171  -2.762  1.00 13.72           C   
ATOM   1395  CD  LYS   179      49.399  -2.535  -3.295  1.00 15.42           C   
ATOM   1396  CE  LYS   179      50.538  -3.500  -3.361  1.00 17.12           C   
ATOM   1397  NZ  LYS   179      51.284  -3.359  -4.597  1.00 19.70           N   
ATOM   1398  C   LYS   179      48.004   2.204  -2.690  1.00 11.35           C   
ATOM   1399  O   LYS   179      47.088   2.593  -1.950  1.00 12.53           O   
ATOM   1400  N   THR   180      48.135   2.630  -3.956  1.00 12.26           N   
ATOM   1401  CA  THR   180      47.202   3.573  -4.562  1.00 11.94           C   
ATOM   1402  CB  THR   180      47.708   3.997  -5.957  1.00 13.18           C   
ATOM   1403  OG1 THR   180      48.011   2.803  -6.678  1.00 13.57           O   
ATOM   1404  CG2 THR   180      48.924   4.873  -5.857  1.00 14.57           C   
ATOM   1405  C   THR   180      45.808   2.980  -4.740  1.00 13.10           C   
ATOM   1406  O   THR   180      45.611   1.754  -4.705  1.00 13.90           O   
ATOM   1407  N   ASP   181      44.839   3.861  -4.958  1.00 13.89           N   
ATOM   1408  CA  ASP   181      43.477   3.500  -5.328  1.00 15.16           C   
ATOM   1409  CB  ASP   181      42.621   4.781  -5.551  1.00 17.61           C   
ATOM   1410  CG  ASP   181      42.334   5.559  -4.269  1.00 22.88           C   
ATOM   1411  OD1 ASP   181      42.538   5.022  -3.154  1.00 22.55           O   
ATOM   1412  OD2 ASP   181      41.850   6.711  -4.406  1.00 24.36           O   
ATOM   1413  C   ASP   181      43.451   2.712  -6.649  1.00 14.79           C   
ATOM   1414  O   ASP   181      44.364   2.802  -7.480  1.00 15.25           O   
ATOM   1415  N   ALA   182      42.367   1.978  -6.878  1.00 15.18           N   
ATOM   1416  CA  ALA   182      42.239   1.112  -8.056  1.00 16.39           C   
ATOM   1417  CB  ALA   182      40.978   0.290  -7.981  1.00 16.99           C   
ATOM   1418  C   ALA   182      42.283   1.854  -9.385  1.00 16.17           C   
ATOM   1419  O   ALA   182      42.673   1.259 -10.398  1.00 17.28           O   
ATOM   1420  N   ASN   183      41.899   3.138  -9.395  1.00 15.79           N   
ATOM   1421  CA  ASN   183      41.885   3.914 -10.646  1.00 16.14           C   
ATOM   1422  CB  ASN   183      40.629   4.773 -10.748  1.00 18.08           C   
ATOM   1423  CG  ASN   183      40.632   5.914  -9.793  1.00 19.86           C   
ATOM   1424  OD1 ASN   183      41.300   5.878  -8.752  1.00 21.28           O   
ATOM   1425  ND2 ASN   183      39.868   6.938 -10.105  1.00 21.06           N   
ATOM   1426  C   ASN   183      43.137   4.729 -10.868  1.00 16.47           C   
ATOM   1427  O   ASN   183      43.192   5.521 -11.780  1.00 19.38           O   
ATOM   1428  N   TRP   184      44.152   4.516 -10.028  1.00 15.67           N   
ATOM   1429  CA  TRP   184      45.472   5.104 -10.246  1.00 15.60           C   
ATOM   1430  CB  TRP   184      46.057   5.444  -8.878  1.00 17.03           C   
ATOM   1431  CG  TRP   184      45.578   6.751  -8.359  1.00 17.30           C   
ATOM   1432  CD1 TRP   184      44.283   7.124  -8.126  1.00 18.90           C   
ATOM   1433  NE1 TRP   184      44.233   8.411  -7.630  1.00 21.43           N   
ATOM   1434  CE2 TRP   184      45.511   8.856  -7.499  1.00 19.80           C   
ATOM   1435  CD2 TRP   184      46.387   7.828  -7.955  1.00 20.91           C   
ATOM   1436  CE3 TRP   184      47.752   8.038  -7.938  1.00 23.37           C   
ATOM   1437  CZ3 TRP   184      48.231   9.288  -7.483  1.00 26.56           C   
ATOM   1438  CH2 TRP   184      47.339  10.281  -7.020  1.00 26.40           C   
ATOM   1439  CZ2 TRP   184      45.985  10.094  -7.038  1.00 24.86           C   
ATOM   1440  C   TRP   184      46.388   4.089 -10.913  1.00 15.05           C   
ATOM   1441  O   TRP   184      46.118   2.881 -10.837  1.00 15.84           O   
ATOM   1442  N   PRO   185      47.534   4.539 -11.432  1.00 15.74           N   
ATOM   1443  CA  PRO   185      48.605   3.604 -11.683  1.00 16.29           C   
ATOM   1444  CB  PRO   185      49.757   4.495 -12.139  1.00 18.72           C   
ATOM   1445  CG  PRO   185      49.447   5.835 -11.559  1.00 21.67           C   
ATOM   1446  CD  PRO   185      47.955   5.945 -11.665  1.00 16.73           C   
ATOM   1447  C   PRO   185      48.957   2.891 -10.375  1.00 15.23           C   
ATOM   1448  O   PRO   185      48.751   3.429  -9.274  1.00 14.64           O   
ATOM   1449  N   ASP   186      49.530   1.708 -10.496  1.00 14.26           N   
ATOM   1450  CA  ASP   186      49.842   0.877  -9.349  1.00 13.82           C   
ATOM   1451  CB  ASP   186      49.883  -0.572  -9.863  1.00 16.22           C   
ATOM   1452  CG  ASP   186      50.276  -1.549  -8.795  1.00 16.10           C   
ATOM   1453  OD1 ASP   186      50.364  -1.163  -7.609  1.00 15.38           O   
ATOM   1454  OD2 ASP   186      50.504  -2.721  -9.159  1.00 17.90           O   
ATOM   1455  C   ASP   186      51.180   1.290  -8.775  1.00 15.43           C   
ATOM   1456  O   ASP   186      52.219   1.001  -9.364  1.00 17.94           O   
ATOM   1457  N   PHE   187      51.171   1.988  -7.640  1.00 12.50           N   
ATOM   1458  CA  PHE   187      52.391   2.248  -6.916  1.00 13.25           C   
ATOM   1459  CB  PHE   187      53.153   3.506  -7.450  1.00 18.19           C   
ATOM   1460  CG  PHE   187      52.371   4.812  -7.417  1.00 19.55           C   
ATOM   1461  CD1 PHE   187      51.801   5.371  -8.577  1.00 20.13           C   
ATOM   1462  CE1 PHE   187      51.100   6.611  -8.500  1.00 20.92           C   
ATOM   1463  CZ  PHE   187      51.035   7.306  -7.303  1.00 21.01           C   
ATOM   1464  CE2 PHE   187      51.658   6.789  -6.167  1.00 20.06           C   
ATOM   1465  CD2 PHE   187      52.340   5.564  -6.237  1.00 19.50           C   
ATOM   1466  C   PHE   187      52.080   2.268  -5.423  1.00 12.29           C   
ATOM   1467  O   PHE   187      50.912   2.306  -5.027  1.00 13.18           O   
ATOM   1468  N   TYR   188      53.132   2.255  -4.607  1.00 12.50           N   
ATOM   1469  CA  TYR   188      52.964   2.517  -3.169  1.00 12.35           C   
ATOM   1470  CB  TYR   188      54.094   1.848  -2.386  1.00 13.40           C   
ATOM   1471  CG  TYR   188      53.817   0.419  -2.017  1.00 13.37           C   
ATOM   1472  CD1 TYR   188      53.147   0.145  -0.831  1.00 15.06           C   
ATOM   1473  CE1 TYR   188      52.885  -1.166  -0.415  1.00 15.43           C   
ATOM   1474  CZ  TYR   188      53.304  -2.210  -1.181  1.00 15.80           C   
ATOM   1475  OH  TYR   188      53.021  -3.490  -0.743  1.00 17.61           O   
ATOM   1476  CE2 TYR   188      53.989  -2.014  -2.397  1.00 14.50           C   
ATOM   1477  CD2 TYR   188      54.240  -0.653  -2.811  1.00 15.59           C   
ATOM   1478  C   TYR   188      53.048   4.023  -2.928  1.00 11.93           C   
ATOM   1479  O   TYR   188      53.979   4.698  -3.413  1.00 13.58           O   
ATOM   1480  N   ARG   189      52.056   4.558  -2.254  1.00 11.53           N   
ATOM   1481  CA  ARG   189      52.182   5.886  -1.689  1.00 11.16           C   
ATOM   1482  CB  ARG   189      50.801   6.437  -1.340  1.00 12.67           C   
ATOM   1483  CG  ARG   189      49.867   6.557  -2.548  1.00 13.04           C   
ATOM   1484  CD  ARG   189      48.529   7.094  -2.120  1.00 15.17           C   
ATOM   1485  NE  ARG   189      47.724   5.976  -1.674  1.00 14.47           N   
ATOM   1486  CZ  ARG   189      46.438   6.074  -1.362  1.00 14.36           C   
ATOM   1487  NH1 ARG   189      45.855   7.277  -1.251  1.00 15.28           N   
ATOM   1488  NH2 ARG   189      45.732   4.964  -1.149  1.00 15.28           N   
ATOM   1489  C   ARG   189      53.027   5.851  -0.430  1.00 11.51           C   
ATOM   1490  O   ARG   189      52.832   5.017   0.448  1.00 12.91           O   
ATOM   1491  N   LEU   190      53.963   6.781  -0.351  1.00 10.90           N   
ATOM   1492  CA  LEU   190      54.840   6.981   0.797  1.00 11.53           C   
ATOM   1493  CB  LEU   190      56.304   6.992   0.335  1.00 11.78           C   
ATOM   1494  CG  LEU   190      56.746   5.794  -0.510  1.00 12.98           C   
ATOM   1495  CD1 LEU   190      58.148   6.019  -1.028  1.00 14.93           C   
ATOM   1496  CD2 LEU   190      56.629   4.479   0.258  1.00 14.60           C   
ATOM   1497  C   LEU   190      54.446   8.282   1.395  1.00 10.73           C   
ATOM   1498  O   LEU   190      54.604   9.336   0.771  1.00 11.57           O   
ATOM   1499  N   GLN   191      53.859   8.228   2.599  1.00 10.75           N   
ATOM   1500  CA  GLN   191      53.180   9.395   3.174  1.00 10.50           C   
ATOM   1501  CB  GLN   191      51.673   9.154   3.230  1.00 11.04           C   
ATOM   1502  CG  GLN   191      51.115   9.114   1.801  1.00 12.24           C   
ATOM   1503  CD  GLN   191      49.712   8.606   1.591  1.00 11.57           C   
ATOM   1504  OE1 GLN   191      49.009   9.138   0.731  1.00 12.83           O   
ATOM   1505  NE2 GLN   191      49.296   7.566   2.320  1.00 12.40           N   
ATOM   1506  C   GLN   191      53.757   9.651   4.552  1.00 10.81           C   
ATOM   1507  O   GLN   191      53.173   9.260   5.562  1.00 12.12           O   
ATOM   1508  N   PRO   192      54.940  10.268   4.621  1.00 10.62           N   
ATOM   1509  CA  PRO   192      55.685  10.358   5.884  1.00 11.75           C   
ATOM   1510  CB  PRO   192      57.163  10.357   5.406  1.00 12.63           C   
ATOM   1511  CG  PRO   192      57.122  10.123   3.891  1.00 14.03           C   
ATOM   1512  CD  PRO   192      55.794  10.690   3.497  1.00 11.66           C   
ATOM   1513  C   PRO   192      55.391  11.602   6.715  1.00 11.00           C   
ATOM   1514  O   PRO   192      56.095  11.824   7.715  1.00 12.22           O   
ATOM   1515  N   LEU   193      54.434  12.430   6.285  1.00 10.72           N   
ATOM   1516  CA  LEU   193      54.107  13.698   6.918  1.00 10.90           C   
ATOM   1517  CB  LEU   193      54.113  14.830   5.859  1.00 11.81           C   
ATOM   1518  CG  LEU   193      54.514  16.197   6.409  1.00 13.23           C   
ATOM   1519  CD1 LEU   193      56.004  16.265   6.784  1.00 15.07           C   
ATOM   1520  CD2 LEU   193      54.122  17.289   5.418  1.00 15.25           C   
ATOM   1521  C   LEU   193      52.743  13.655   7.595  1.00 10.98           C   
ATOM   1522  O   LEU   193      52.247  14.682   8.091  1.00 11.66           O   
ATOM   1523  N   LEU   194      52.103  12.475   7.678  1.00 11.46           N   
ATOM   1524  CA  LEU   194      50.677  12.440   8.043  1.00 11.59           C   
ATOM   1525  CB  LEU   194      50.157  10.992   7.995  1.00 11.47           C   
ATOM   1526  CG  LEU   194      50.065  10.408   6.593  1.00 11.54           C   
ATOM   1527  CD1 LEU   194      49.810   8.893   6.663  1.00 13.26           C   
ATOM   1528  CD2 LEU   194      48.920  11.080   5.822  1.00 13.58           C   
ATOM   1529  C   LEU   194      50.402  12.988   9.435  1.00 11.17           C   
ATOM   1530  O   LEU   194      49.387  13.627   9.664  1.00 11.78           O   
ATOM   1531  N   HIS   195      51.338  12.726  10.356  1.00 11.35           N   
ATOM   1532  CA  HIS   195      51.200  13.096  11.772  1.00 12.58           C   
ATOM   1533  CB  HIS   195      52.061  12.166  12.622  1.00 12.61           C   
ATOM   1534  CG  HIS   195      53.478  12.146  12.169  1.00 11.96           C   
ATOM   1535  ND1 HIS   195      53.863  11.489  11.027  1.00 12.68           N   
ATOM   1536  CE1 HIS   195      55.151  11.713  10.826  1.00 12.67           C   
ATOM   1537  NE2 HIS   195      55.607  12.501  11.789  1.00 12.52           N   
ATOM   1538  CD2 HIS   195      54.570  12.787  12.636  1.00 12.96           C   
ATOM   1539  C   HIS   195      51.603  14.548  12.077  1.00 11.79           C   
ATOM   1540  O   HIS   195      51.500  14.963  13.229  1.00 12.74           O   
ATOM   1541  N   TRP   196      52.101  15.298  11.094  1.00 11.73           N   
ATOM   1542  CA  TRP   196      52.462  16.687  11.329  1.00 12.04           C   
ATOM   1543  CB  TRP   196      53.326  17.218  10.161  1.00 11.44           C   
ATOM   1544  CG  TRP   196      54.722  16.756  10.203  1.00 10.80           C   
ATOM   1545  CD1 TRP   196      55.174  15.451  10.171  1.00 11.23           C   
ATOM   1546  NE1 TRP   196      56.545  15.419  10.291  1.00 11.02           N   
ATOM   1547  CE2 TRP   196      56.989  16.712  10.409  1.00 10.34           C   
ATOM   1548  CD2 TRP   196      55.863  17.573  10.367  1.00 10.64           C   
ATOM   1549  CE3 TRP   196      56.060  18.961  10.455  1.00 11.23           C   
ATOM   1550  CZ3 TRP   196      57.378  19.438  10.635  1.00 11.01           C   
ATOM   1551  CH2 TRP   196      58.474  18.545  10.673  1.00 11.37           C   
ATOM   1552  CZ2 TRP   196      58.290  17.187  10.584  1.00 10.84           C   
ATOM   1553  C   TRP   196      51.217  17.534  11.476  1.00 11.34           C   
ATOM   1554  O   TRP   196      50.230  17.304  10.775  1.00 14.17           O   
ATOM   1555  N   ASN   197      51.254  18.510  12.373  1.00 11.63           N   
ATOM   1556  CA  ASN   197      50.231  19.529  12.489  1.00 12.18           C   
ATOM   1557  CB  ASN   197      49.969  19.823  14.018  1.00 15.26           C   
ATOM   1558  CG  ASN   197      49.810  18.563  14.864  1.00 15.63           C   
ATOM   1559  OD1 ASN   197      48.877  17.797  14.635  1.00 17.19           O   
ATOM   1560  ND2 ASN   197      50.691  18.374  15.863  1.00 18.88           N   
ATOM   1561  C   ASN   197      50.706  20.839  11.868  1.00 11.60           C   
ATOM   1562  O   ASN   197      51.909  21.044  11.642  1.00 11.70           O   
ATOM   1563  N   LEU   198      49.758  21.745  11.628  1.00 11.06           N   
ATOM   1564  CA  LEU   198      50.057  23.028  11.009  1.00 11.75           C   
ATOM   1565  CB  LEU   198      48.779  23.861  10.928  1.00 12.14           C   
ATOM   1566  CG  LEU   198      48.924  25.268  10.321  1.00 12.42           C   
ATOM   1567  CD1 LEU   198      49.534  25.208   8.914  1.00 13.24           C   
ATOM   1568  CD2 LEU   198      47.577  25.972  10.351  1.00 13.81           C   
ATOM   1569  C   LEU   198      51.158  23.761  11.783  1.00 10.84           C   
ATOM   1570  O   LEU   198      52.074  24.309  11.178  1.00 11.59           O   
ATOM   1571  N   ALA   199      51.097  23.786  13.122  1.00 11.05           N   
ATOM   1572  CA  ALA   199      52.103  24.500  13.877  1.00 12.27           C   
ATOM   1573  CB  ALA   199      51.733  24.479  15.373  1.00 13.75           C   
ATOM   1574  C   ALA   199      53.494  23.909  13.673  1.00 11.14           C   
ATOM   1575  O   ALA   199      54.503  24.638  13.710  1.00 11.77           O   
ATOM   1576  N   ASN   200      53.568  22.589  13.534  1.00 10.97           N   
ATOM   1577  CA  ASN   200      54.858  21.955  13.286  1.00 10.64           C   
ATOM   1578  CB  ASN   200      54.741  20.439  13.334  1.00 12.09           C   
ATOM   1579  CG  ASN   200      54.061  19.942  14.597  1.00 12.14           C   
ATOM   1580  OD1 ASN   200      53.131  19.154  14.488  1.00 14.24           O   
ATOM   1581  ND2 ASN   200      54.523  20.391  15.769  1.00 12.91           N   
ATOM   1582  C   ASN   200      55.446  22.369  11.930  1.00 10.95           C   
ATOM   1583  O   ASN   200      56.651  22.594  11.815  1.00 10.86           O   
ATOM   1584  N   ILE   201      54.584  22.403  10.914  1.00 10.87           N   
ATOM   1585  CA  ILE   201      54.984  22.828   9.581  1.00 11.05           C   
ATOM   1586  CB  ILE   201      53.773  22.785   8.637  1.00 10.77           C   
ATOM   1587  CG1 ILE   201      53.266  21.348   8.409  1.00 11.25           C   
ATOM   1588  CD1 ILE   201      54.190  20.473   7.652  1.00 12.24           C   
ATOM   1589  CG2 ILE   201      54.129  23.497   7.299  1.00 12.00           C   
ATOM   1590  C   ILE   201      55.598  24.249   9.657  1.00 10.93           C   
ATOM   1591  O   ILE   201      56.689  24.477   9.146  1.00 10.93           O   
ATOM   1592  N   TRP   202      54.892  25.200  10.286  1.00 10.74           N   
ATOM   1593  CA  TRP   202      55.434  26.569  10.339  1.00 10.96           C   
ATOM   1594  CB  TRP   202      54.449  27.569  10.920  1.00 11.16           C   
ATOM   1595  CG  TRP   202      53.173  27.808  10.237  1.00 10.40           C   
ATOM   1596  CD1 TRP   202      51.947  27.815  10.806  1.00 10.91           C   
ATOM   1597  NE1 TRP   202      50.994  28.179   9.904  1.00 11.14           N   
ATOM   1598  CE2 TRP   202      51.597  28.417   8.705  1.00 10.84           C   
ATOM   1599  CD2 TRP   202      52.970  28.204   8.874  1.00 11.00           C   
ATOM   1600  CE3 TRP   202      53.828  28.403   7.780  1.00 11.90           C   
ATOM   1601  CZ3 TRP   202      53.261  28.818   6.576  1.00 12.64           C   
ATOM   1602  CH2 TRP   202      51.895  29.031   6.454  1.00 12.63           C   
ATOM   1603  CZ2 TRP   202      51.036  28.832   7.499  1.00 11.97           C   
ATOM   1604  C   TRP   202      56.747  26.618  11.126  1.00 11.13           C   
ATOM   1605  O   TRP   202      57.691  27.274  10.703  1.00 11.36           O   
ATOM   1606  N   SER   203      56.811  25.918  12.259  1.00 10.94           N   
ATOM   1607  CA  SER   203      58.005  25.988  13.098  1.00 10.55           C   
ATOM   1608  CB  SER   203      57.827  25.116  14.322  1.00 11.59           C   
ATOM   1609  OG  SER   203      59.014  25.128  15.099  1.00 12.03           O   
ATOM   1610  C   SER   203      59.241  25.531  12.314  1.00 11.25           C   
ATOM   1611  O   SER   203      60.267  26.224  12.291  1.00 11.92           O   
ATOM   1612  N   PHE   204      59.147  24.378  11.679  1.00 10.53           N   
ATOM   1613  CA  PHE   204      60.273  23.830  10.974  1.00 11.53           C   
ATOM   1614  CB  PHE   204      59.986  22.396  10.592  1.00 11.61           C   
ATOM   1615  CG  PHE   204      61.175  21.717   9.970  1.00 11.26           C   
ATOM   1616  CD1 PHE   204      62.260  21.325  10.758  1.00 13.34           C   
ATOM   1617  CE1 PHE   204      63.350  20.696  10.209  1.00 15.28           C   
ATOM   1618  CZ  PHE   204      63.393  20.452   8.838  1.00 15.01           C   
ATOM   1619  CE2 PHE   204      62.323  20.822   8.041  1.00 14.59           C   
ATOM   1620  CD2 PHE   204      61.235  21.468   8.606  1.00 13.24           C   
ATOM   1621  C   PHE   204      60.614  24.688   9.747  1.00 11.03           C   
ATOM   1622  O   PHE   204      61.788  24.976   9.478  1.00 11.78           O   
ATOM   1623  N   LEU   205      59.608  25.073   8.984  1.00 11.04           N   
ATOM   1624  CA  LEU   205      59.880  25.845   7.791  1.00 12.05           C   
ATOM   1625  CB  LEU   205      58.601  26.048   6.993  1.00 14.98           C   
ATOM   1626  CG  LEU   205      58.723  26.321   5.484  1.00 17.17           C   
ATOM   1627  CD1 LEU   205      59.669  25.296   4.786  1.00 18.20           C   
ATOM   1628  CD2 LEU   205      57.328  26.240   4.866  1.00 19.49           C   
ATOM   1629  C   LEU   205      60.525  27.187   8.107  1.00 11.27           C   
ATOM   1630  O   LEU   205      61.447  27.595   7.414  1.00 12.82           O   
ATOM   1631  N   LEU   206      60.035  27.859   9.132  1.00 11.35           N   
ATOM   1632  CA  LEU   206      60.616  29.140   9.507  1.00 12.25           C   
ATOM   1633  CB  LEU   206      59.726  29.839  10.542  1.00 12.34           C   
ATOM   1634  CG  LEU   206      58.392  30.350  10.002  1.00 12.53           C   
ATOM   1635  CD1 LEU   206      57.471  30.670  11.157  1.00 13.25           C   
ATOM   1636  CD2 LEU   206      58.586  31.589   9.092  1.00 14.53           C   
ATOM   1637  C   LEU   206      62.044  28.972  10.006  1.00 12.60           C   
ATOM   1638  O   LEU   206      62.936  29.763   9.632  1.00 13.21           O   
ATOM   1639  N   TYR   207      62.285  27.964  10.838  1.00 11.67           N   
ATOM   1640  CA  TYR   207      63.628  27.743  11.324  1.00 11.52           C   
ATOM   1641  CB  TYR   207      63.628  26.569  12.307  1.00 12.73           C   
ATOM   1642  CG  TYR   207      65.032  26.273  12.793  1.00 12.74           C   
ATOM   1643  CD1 TYR   207      65.616  27.062  13.775  1.00 14.20           C   
ATOM   1644  CE1 TYR   207      66.926  26.821  14.208  1.00 16.73           C   
ATOM   1645  CZ  TYR   207      67.628  25.827  13.584  1.00 16.90           C   
ATOM   1646  OH  TYR   207      68.951  25.575  13.950  1.00 22.37           O   
ATOM   1647  CE2 TYR   207      67.093  25.029  12.621  1.00 15.42           C   
ATOM   1648  CD2 TYR   207      65.804  25.256  12.206  1.00 13.88           C   
ATOM   1649  C   TYR   207      64.597  27.445  10.178  1.00 12.00           C   
ATOM   1650  O   TYR   207      65.771  27.815  10.225  1.00 12.68           O   
ATOM   1651  N   SER   208      64.108  26.742   9.159  1.00 11.48           N   
ATOM   1652  CA  SER   208      65.007  26.270   8.104  1.00 12.31           C   
ATOM   1653  CB  SER   208      64.244  25.439   7.060  1.00 12.61           C   
ATOM   1654  OG  SER   208      63.457  26.256   6.176  1.00 12.59           O   
ATOM   1655  C   SER   208      65.707  27.416   7.380  1.00 11.60           C   
ATOM   1656  O   SER   208      66.778  27.195   6.843  1.00 13.24           O   
ATOM   1657  N   ASN   209      65.081  28.589   7.326  1.00 12.42           N   
ATOM   1658  CA  ASN   209      65.609  29.727   6.578  1.00 13.47           C   
ATOM   1659  CB  ASN   209      66.953  30.153   7.171  1.00 15.28           C   
ATOM   1660  CG  ASN   209      67.350  31.559   6.804  1.00 16.35           C   
ATOM   1661  OD1 ASN   209      66.523  32.390   6.368  1.00 16.08           O   
ATOM   1662  ND2 ASN   209      68.611  31.868   7.043  1.00 18.84           N   
ATOM   1663  C   ASN   209      65.753  29.426   5.093  1.00 13.05           C   
ATOM   1664  O   ASN   209      66.517  30.085   4.414  1.00 15.39           O   
ATOM   1665  N   GLU   210      64.987  28.458   4.599  1.00 13.08           N   
ATOM   1666  CA  GLU   210      64.898  28.220   3.151  1.00 13.99           C   
ATOM   1667  CB  GLU   210      64.507  26.776   2.909  1.00 16.42           C   
ATOM   1668  CG  GLU   210      65.654  25.871   3.127  1.00 16.22           C   
ATOM   1669  CD  GLU   210      66.751  26.102   2.069  1.00 17.03           C   
ATOM   1670  OE1 GLU   210      66.501  25.809   0.908  1.00 20.67           O   
ATOM   1671  OE2 GLU   210      67.819  26.644   2.405  1.00 16.79           O   
ATOM   1672  C   GLU   210      63.868  29.187   2.576  1.00 14.58           C   
ATOM   1673  O   GLU   210      62.891  29.547   3.239  1.00 16.34           O   
ATOM   1674  N   PRO   211      64.037  29.578   1.305  1.00 14.89           N   
ATOM   1675  CA  PRO   211      62.985  30.367   0.639  1.00 15.78           C   
ATOM   1676  CB  PRO   211      63.526  30.526  -0.823  1.00 17.23           C   
ATOM   1677  CG  PRO   211      65.020  30.352  -0.679  1.00 19.32           C   
ATOM   1678  CD  PRO   211      65.177  29.292   0.416  1.00 16.51           C   
ATOM   1679  C   PRO   211      61.706  29.554   0.641  1.00 14.15           C   
ATOM   1680  O   PRO   211      61.738  28.361   0.346  1.00 15.06           O   
ATOM   1681  N   ILE   212      60.585  30.197   0.887  1.00 14.11           N   
ATOM   1682  CA  ILE   212      59.290  29.530   0.816  1.00 13.40           C   
ATOM   1683  CB  ILE   212      58.598  29.438   2.181  1.00 15.25           C   
ATOM   1684  CG1 ILE   212      58.223  30.820   2.698  1.00 17.83           C   
ATOM   1685  CD1 ILE   212      57.453  30.777   4.019  1.00 21.94           C   
ATOM   1686  CG2 ILE   212      59.535  28.713   3.194  1.00 18.26           C   
ATOM   1687  C   ILE   212      58.404  30.282  -0.162  1.00 12.48           C   
ATOM   1688  O   ILE   212      58.747  31.390  -0.599  1.00 14.74           O   
ATOM   1689  N   CYS   213      57.256  29.692  -0.524  1.00 11.94           N   
ATOM   1690  CA  CYS   213      56.342  30.423  -1.398  1.00 11.93           C   
ATOM   1691  CB  CYS   213      55.171  29.563  -1.766  1.00 11.93           C   
ATOM   1692  SG  CYS   213      54.027  30.422  -2.918  1.00 12.24           S   
ATOM   1693  C   CYS   213      55.874  31.698  -0.721  1.00 10.68           C   
ATOM   1694  O   CYS   213      55.249  31.634   0.352  1.00 11.92           O   
ATOM   1695  N   GLU   214      56.155  32.864  -1.309  1.00 10.75           N   
ATOM   1696  CA  GLU   214      55.965  34.086  -0.558  0.50 11.31           C   
ATOM   1698  CB  GLU   214      56.908  35.218  -1.051  0.50 12.41           C   
ATOM   1700  CG  GLU   214      58.332  35.109  -0.481  0.50 11.64           C   
ATOM   1702  CD  GLU   214      58.373  35.381   1.023  0.50 13.53           C   
ATOM   1704  OE1 GLU   214      58.727  34.465   1.764  0.50 17.37           O   
ATOM   1706  OE2 GLU   214      58.012  36.494   1.461  0.50 14.61           O   
ATOM   1708  C   GLU   214      54.511  34.513  -0.437  1.00 10.68           C   
ATOM   1709  O   GLU   214      54.198  35.449   0.295  1.00 11.44           O   
ATOM   1710  N   LEU   215      53.576  33.787  -1.068  1.00 10.65           N   
ATOM   1711  CA  LEU   215      52.164  34.032  -0.763  1.00 11.25           C   
ATOM   1712  CB  LEU   215      51.252  33.105  -1.583  1.00 11.71           C   
ATOM   1713  CG  LEU   215      51.266  33.415  -3.086  1.00 12.54           C   
ATOM   1714  CD1 LEU   215      50.487  32.326  -3.830  1.00 14.47           C   
ATOM   1715  CD2 LEU   215      50.729  34.835  -3.401  1.00 15.06           C   
ATOM   1716  C   LEU   215      51.842  33.907   0.733  1.00 10.10           C   
ATOM   1717  O   LEU   215      50.983  34.624   1.236  1.00 10.33           O   
ATOM   1718  N   TYR   216      52.495  32.980   1.444  1.00 10.22           N   
ATOM   1719  CA  TYR   216      52.188  32.833   2.878  1.00 10.43           C   
ATOM   1720  CB  TYR   216      52.991  31.667   3.472  1.00 11.45           C   
ATOM   1721  CG  TYR   216      52.673  30.339   2.841  1.00 10.72           C   
ATOM   1722  CD1 TYR   216      51.365  29.839   2.820  1.00 10.59           C   
ATOM   1723  CE1 TYR   216      51.091  28.600   2.211  1.00 11.63           C   
ATOM   1724  CZ  TYR   216      52.148  27.879   1.639  1.00 11.49           C   
ATOM   1725  OH  TYR   216      51.926  26.670   1.022  1.00 13.59           O   
ATOM   1726  CE2 TYR   216      53.421  28.345   1.645  1.00 11.90           C   
ATOM   1727  CD2 TYR   216      53.693  29.587   2.227  1.00 11.70           C   
ATOM   1728  C   TYR   216      52.463  34.117   3.630  1.00 10.60           C   
ATOM   1729  O   TYR   216      51.741  34.459   4.581  1.00 10.81           O   
ATOM   1730  N   ARG   217      53.480  34.878   3.213  1.00 10.80           N   
ATOM   1731  CA  ARG   217      53.819  36.144   3.852  1.00 11.10           C   
ATOM   1732  CB  ARG   217      55.096  36.705   3.189  1.00 11.92           C   
ATOM   1733  CG  ARG   217      55.525  38.081   3.685  1.00 12.22           C   
ATOM   1734  CD  ARG   217      56.048  38.024   5.161  1.00 12.23           C   
ATOM   1735  NE  ARG   217      56.402  39.381   5.610  1.00 12.36           N   
ATOM   1736  CZ  ARG   217      55.523  40.264   6.069  1.00 12.38           C   
ATOM   1737  NH1 ARG   217      54.235  39.946   6.233  1.00 13.46           N   
ATOM   1738  NH2 ARG   217      55.931  41.483   6.398  1.00 13.94           N   
ATOM   1739  C   ARG   217      52.658  37.142   3.817  1.00 10.56           C   
ATOM   1740  O   ARG   217      52.606  38.034   4.645  1.00 11.50           O   
ATOM   1741  N   TYR   218      51.808  37.027   2.805  1.00 10.67           N   
ATOM   1742  CA  TYR   218      50.720  37.963   2.583  1.00 11.45           C   
ATOM   1743  CB  TYR   218      50.555  38.228   1.079  1.00 11.79           C   
ATOM   1744  CG  TYR   218      51.701  39.084   0.525  1.00 10.91           C   
ATOM   1745  CD1 TYR   218      51.516  40.442   0.307  1.00 12.12           C   
ATOM   1746  CE1 TYR   218      52.552  41.256  -0.164  1.00 12.21           C   
ATOM   1747  CZ  TYR   218      53.781  40.688  -0.435  1.00 11.87           C   
ATOM   1748  OH  TYR   218      54.806  41.486  -0.886  1.00 13.06           O   
ATOM   1749  CE2 TYR   218      53.982  39.331  -0.243  1.00 11.75           C   
ATOM   1750  CD2 TYR   218      52.932  38.535   0.214  1.00 11.14           C   
ATOM   1751  C   TYR   218      49.402  37.523   3.208  1.00 11.56           C   
ATOM   1752  O   TYR   218      48.374  38.176   3.015  1.00 13.84           O   
ATOM   1753  N   GLY   219      49.416  36.441   3.999  1.00 11.38           N   
ATOM   1754  CA  GLY   219      48.211  36.059   4.765  1.00 11.75           C   
ATOM   1755  C   GLY   219      47.530  34.807   4.267  1.00 10.48           C   
ATOM   1756  O   GLY   219      46.537  34.379   4.862  1.00 11.44           O   
ATOM   1757  N   PHE   220      48.028  34.199   3.189  1.00 10.61           N   
ATOM   1758  CA  PHE   220      47.489  32.912   2.769  1.00 10.73           C   
ATOM   1759  CB  PHE   220      47.971  32.583   1.347  1.00 11.15           C   
ATOM   1760  CG  PHE   220      47.358  33.472   0.320  1.00 11.06           C   
ATOM   1761  CD1 PHE   220      46.141  33.136  -0.250  1.00 13.38           C   
ATOM   1762  CE1 PHE   220      45.586  33.947  -1.231  1.00 14.72           C   
ATOM   1763  CZ  PHE   220      46.208  35.123  -1.617  1.00 14.12           C   
ATOM   1764  CE2 PHE   220      47.388  35.489  -1.022  1.00 14.09           C   
ATOM   1765  CD2 PHE   220      47.963  34.657  -0.095  1.00 12.40           C   
ATOM   1766  C   PHE   220      47.958  31.841   3.733  1.00 10.90           C   
ATOM   1767  O   PHE   220      49.125  31.838   4.167  1.00 11.14           O   
ATOM   1768  N   THR   221      47.056  30.898   4.045  1.00 10.93           N   
ATOM   1769  CA  THR   221      47.421  29.728   4.824  1.00 11.18           C   
ATOM   1770  CB  THR   221      46.568  29.650   6.111  1.00 11.27           C   
ATOM   1771  OG1 THR   221      45.176  29.631   5.768  1.00 11.23           O   
ATOM   1772  CG2 THR   221      46.847  30.839   7.008  1.00 12.12           C   
ATOM   1773  C   THR   221      47.288  28.435   4.058  1.00 11.25           C   
ATOM   1774  O   THR   221      47.786  27.408   4.501  1.00 13.37           O   
ATOM   1775  N   SER   222      46.608  28.473   2.924  1.00 12.44           N   
ATOM   1776  CA  SER   222      46.452  27.293   2.095  1.00 13.73           C   
ATOM   1777  CB  SER   222      45.170  26.506   2.499  1.00 16.25           C   
ATOM   1778  OG  SER   222      44.933  25.379   1.684  1.00 19.55           O   
ATOM   1779  C   SER   222      46.251  27.692   0.671  0.60 14.71           C   
ATOM   1781  O   SER   222      45.267  28.413   0.380  0.60 14.24           O   
ATOM   1783  N   LEU   223      47.132  27.193  -0.208  1.00 14.12           N   
ATOM   1784  CA  LEU   223      47.188  27.650  -1.586  1.00 15.18           C   
ATOM   1785  CB  LEU   223      48.632  27.684  -2.076  1.00 15.15           C   
ATOM   1786  CG  LEU   223      49.538  28.585  -1.215  1.00 17.28           C   
ATOM   1787  CD1 LEU   223      50.980  28.524  -1.734  1.00 19.25           C   
ATOM   1788  CD2 LEU   223      49.048  30.022  -1.089  1.00 19.73           C   
ATOM   1789  C   LEU   223      46.322  26.716  -2.418  1.00 15.68           C   
ATOM   1790  O   LEU   223      46.745  25.675  -2.882  1.00 19.39           O   
ATOM   1791  N   GLY   224      45.049  27.042  -2.528  1.00 14.91           N   
ATOM   1792  CA  GLY   224      44.180  26.355  -3.440  1.00 14.83           C   
ATOM   1793  C   GLY   224      44.305  27.078  -4.781  1.00 14.90           C   
ATOM   1794  O   GLY   224      45.326  27.710  -5.094  1.00 16.15           O   
ATOM   1795  N   ASN   225      43.237  27.107  -5.522  1.00 14.80           N   
ATOM   1796  CA  ASN   225      43.299  27.689  -6.839  1.00 13.76           C   
ATOM   1797  CB  ASN   225      42.357  26.952  -7.783  1.00 14.22           C   
ATOM   1798  CG  ASN   225      40.926  27.136  -7.424  1.00 15.36           C   
ATOM   1799  OD1 ASN   225      40.445  28.255  -7.316  1.00 17.45           O   
ATOM   1800  ND2 ASN   225      40.215  26.024  -7.250  1.00 19.90           N   
ATOM   1801  C   ASN   225      43.056  29.207  -6.809  1.00 12.09           C   
ATOM   1802  O   ASN   225      42.608  29.785  -5.798  1.00 12.65           O   
ATOM   1803  N   VAL   226      43.353  29.859  -7.935  1.00 12.72           N   
ATOM   1804  CA  VAL   226      43.278  31.329  -7.967  1.00 14.69           C   
ATOM   1805  CB  VAL   226      43.910  31.932  -9.255  1.00 15.49           C   
ATOM   1806  CG1 VAL   226      45.351  31.677  -9.277  1.00 16.57           C   
ATOM   1807  CG2 VAL   226      43.229  31.420 -10.558  1.00 15.70           C   
ATOM   1808  C   VAL   226      41.882  31.855  -7.841  1.00 14.12           C   
ATOM   1809  O   VAL   226      41.698  32.998  -7.375  1.00 16.66           O   
ATOM   1810  N   GLU   227      40.891  31.078  -8.279  1.00 13.47           N   
ATOM   1811  CA  GLU   227      39.520  31.555  -8.273  1.00 15.60           C   
ATOM   1812  CB  GLU   227      38.657  30.864  -9.366  1.00 16.55           C   
ATOM   1813  CG  GLU   227      38.378  29.336  -9.336  1.00 17.66           C   
ATOM   1814  CD  GLU   227      39.460  28.481  -9.994  1.00 17.97           C   
ATOM   1815  OE1 GLU   227      39.100  27.323 -10.386  1.00 20.00           O   
ATOM   1816  OE2 GLU   227      40.598  28.980 -10.168  1.00 20.56           O   
ATOM   1817  C   GLU   227      38.892  31.490  -6.888  1.00 15.47           C   
ATOM   1818  O   GLU   227      38.014  32.291  -6.596  1.00 19.99           O   
ATOM   1819  N   GLU   228      39.317  30.551  -6.042  1.00 12.61           N   
ATOM   1820  CA  GLU   228      38.652  30.310  -4.742  1.00 13.04           C   
ATOM   1821  CB  GLU   228      38.489  28.801  -4.483  1.00 14.73           C   
ATOM   1822  CG  GLU   228      39.862  28.062  -4.193  0.60 16.58           C   
ATOM   1824  CD  GLU   228      39.797  26.517  -4.095  0.60 16.50           C   
ATOM   1826  OE1 GLU   228      38.668  25.960  -3.931  0.60 20.59           O   
ATOM   1828  OE2 GLU   228      40.879  25.869  -4.184  0.60 15.47           O   
ATOM   1830  C   GLU   228      39.454  30.877  -3.570  1.00 12.24           C   
ATOM   1831  O   GLU   228      38.874  31.110  -2.518  1.00 13.88           O   
ATOM   1832  N   THR   229      40.761  31.004  -3.711  1.00 11.70           N   
ATOM   1833  CA  THR   229      41.606  31.208  -2.522  1.00 11.82           C   
ATOM   1834  CB  THR   229      42.990  30.559  -2.741  1.00 12.88           C   
ATOM   1835  OG1 THR   229      42.796  29.188  -3.093  1.00 13.35           O   
ATOM   1836  CG2 THR   229      43.823  30.627  -1.501  1.00 14.74           C   
ATOM   1837  C   THR   229      41.792  32.658  -2.193  1.00 11.50           C   
ATOM   1838  O   THR   229      42.130  33.464  -3.042  1.00 13.43           O   
ATOM   1839  N   LEU   230      41.624  32.993  -0.926  1.00 12.24           N   
ATOM   1840  CA  LEU   230      41.835  34.349  -0.415  1.00 11.85           C   
ATOM   1841  CB  LEU   230      40.508  34.963   0.089  1.00 13.29           C   
ATOM   1842  CG  LEU   230      39.504  35.239  -1.021  1.00 14.74           C   
ATOM   1843  CD1 LEU   230      38.152  35.575  -0.423  1.00 16.53           C   
ATOM   1844  CD2 LEU   230      39.990  36.386  -1.956  1.00 18.12           C   
ATOM   1845  C   LEU   230      42.802  34.257   0.773  1.00 11.81           C   
ATOM   1846  O   LEU   230      42.929  33.205   1.408  1.00 11.07           O   
ATOM   1847  N   PRO   231      43.421  35.377   1.159  1.00 11.27           N   
ATOM   1848  CA  PRO   231      44.125  35.399   2.441  1.00 11.99           C   
ATOM   1849  CB  PRO   231      44.603  36.866   2.550  1.00 12.80           C   
ATOM   1850  CG  PRO   231      44.686  37.345   1.124  1.00 13.39           C   
ATOM   1851  CD  PRO   231      43.499  36.674   0.454  1.00 12.78           C   
ATOM   1852  C   PRO   231      43.138  35.029   3.552  1.00 11.62           C   
ATOM   1853  O   PRO   231      41.941  35.248   3.446  1.00 12.62           O   
ATOM   1854  N   ASN   232      43.644  34.428   4.626  1.00 11.33           N   
ATOM   1855  CA  ASN   232      42.759  33.856   5.612  1.00 11.52           C   
ATOM   1856  CB  ASN   232      43.579  32.928   6.508  1.00 11.97           C   
ATOM   1857  CG  ASN   232      42.713  32.028   7.366  1.00 11.47           C   
ATOM   1858  OD1 ASN   232      41.805  32.489   8.045  1.00 12.83           O   
ATOM   1859  ND2 ASN   232      42.998  30.734   7.343  1.00 12.55           N   
ATOM   1860  C   ASN   232      42.069  34.944   6.426  1.00 11.44           C   
ATOM   1861  O   ASN   232      42.739  35.769   7.023  1.00 11.82           O   
ATOM   1862  N   PRO   233      40.718  34.930   6.498  1.00 11.89           N   
ATOM   1863  CA  PRO   233      40.039  36.044   7.182  1.00 13.26           C   
ATOM   1864  CB  PRO   233      38.540  35.768   6.897  1.00 14.30           C   
ATOM   1865  CG  PRO   233      38.473  34.244   6.678  1.00 13.86           C   
ATOM   1866  CD  PRO   233      39.779  33.969   5.902  1.00 12.91           C   
ATOM   1867  C   PRO   233      40.330  36.063   8.662  1.00 12.54           C   
ATOM   1868  O   PRO   233      40.228  37.120   9.292  1.00 13.00           O   
ATOM   1869  N   HIS   234      40.731  34.932   9.250  1.00 12.24           N   
ATOM   1870  CA  HIS   234      41.135  34.906  10.669  1.00 13.07           C   
ATOM   1871  CB  HIS   234      41.245  33.466  11.160  1.00 14.41           C   
ATOM   1872  CG  HIS   234      39.950  32.737  11.101  1.00 14.03           C   
ATOM   1873  ND1 HIS   234      38.991  32.838  12.091  1.00 17.48           N   
ATOM   1874  CE1 HIS   234      37.930  32.127  11.738  1.00 18.07           C   
ATOM   1875  NE2 HIS   234      38.152  31.597  10.549  1.00 17.72           N   
ATOM   1876  CD2 HIS   234      39.411  31.962  10.129  1.00 15.82           C   
ATOM   1877  C   HIS   234      42.432  35.664  10.912  1.00 12.83           C   
ATOM   1878  O   HIS   234      42.757  35.942  12.070  1.00 14.63           O   
ATOM   1879  N   LEU   235      43.170  35.981   9.842  1.00 12.34           N   
ATOM   1880  CA  LEU   235      44.416  36.744   9.916  1.00 12.08           C   
ATOM   1881  CB  LEU   235      45.507  36.063   9.071  1.00 11.77           C   
ATOM   1882  CG  LEU   235      45.782  34.603   9.486  1.00 12.33           C   
ATOM   1883  CD1 LEU   235      46.906  34.060   8.667  1.00 12.69           C   
ATOM   1884  CD2 LEU   235      46.096  34.478  10.995  1.00 14.32           C   
ATOM   1885  C   LEU   235      44.269  38.193   9.508  1.00 11.99           C   
ATOM   1886  O   LEU   235      45.264  38.914   9.438  1.00 12.40           O   
ATOM   1887  N   ARG   236      43.031  38.652   9.260  1.00 12.57           N   
ATOM   1888  CA  ARG   236      42.873  40.028   8.845  1.00 13.67           C   
ATOM   1889  CB  ARG   236      41.440  40.243   8.317  1.00 15.63           C   
ATOM   1890  CG  ARG   236      41.262  41.591   7.611  1.00 17.20           C   
ATOM   1891  CD  ARG   236      39.843  41.783   7.095  1.00 20.76           C   
ATOM   1892  NE  ARG   236      38.905  41.852   8.215  1.00 22.75           N   
ATOM   1893  CZ  ARG   236      38.632  42.969   8.898  1.00 26.94           C   
ATOM   1894  NH1 ARG   236      39.192  44.133   8.562  1.00 26.15           N   
ATOM   1895  NH2 ARG   236      37.788  42.918   9.922  1.00 31.02           N   
ATOM   1896  C   ARG   236      43.179  40.956   9.991  1.00 14.27           C   
ATOM   1897  O   ARG   236      42.706  40.742  11.115  1.00 16.21           O   
ATOM   1898  N   LYS   237      43.936  42.008   9.726  1.00 13.87           N   
ATOM   1899  CA  LYS   237      44.239  42.997  10.748  1.00 16.80           C   
ATOM   1900  CB  LYS   237      45.465  43.805  10.358  1.00 17.03           C   
ATOM   1901  CG  LYS   237      46.704  42.948  10.315  1.00 17.62           C   
ATOM   1902  CD  LYS   237      47.952  43.791  10.058  1.00 21.14           C   
ATOM   1903  CE  LYS   237      49.205  42.959   9.884  1.00 21.60           C   
ATOM   1904  NZ  LYS   237      50.301  43.878   9.342  1.00 24.69           N   
ATOM   1905  C   LYS   237      43.075  43.909  10.901  1.00 18.13           C   
ATOM   1906  O   LYS   237      42.520  44.433   9.957  1.00 19.53           O   
ATOM   1907  N   ASP   238      42.771  44.190  12.163  1.00 20.76           N   
ATOM   1908  CA  ASP   238      41.625  45.028  12.508  1.00 27.12           C   
ATOM   1909  CB  ASP   238      40.355  44.182  12.515  1.00 30.46           C   
ATOM   1910  CG  ASP   238      39.097  44.990  12.839  1.00 34.32           C   
ATOM   1911  OD1 ASP   238      39.182  46.020  13.552  1.00 35.78           O   
ATOM   1912  OD2 ASP   238      38.012  44.564  12.389  1.00 37.85           O   
ATOM   1913  C   ASP   238      41.875  45.610  13.903  1.00 31.03           C   
ATOM   1914  O   ASP   238      42.127  44.870  14.832  1.00 29.29           O   
ATOM   1915  N   LYS   239      41.788  46.932  14.023  1.00 36.40           N   
ATOM   1916  CA  LYS   239      42.016  47.624  15.306  1.00 41.70           C   
ATOM   1917  CB  LYS   239      41.712  49.111  15.159  1.00 44.34           C   
ATOM   1918  CG  LYS   239      42.753  49.879  14.365  1.00 47.09           C   
ATOM   1919  CD  LYS   239      42.338  51.333  14.165  1.00 49.75           C   
ATOM   1920  CE  LYS   239      41.309  51.475  13.053  1.00 50.81           C   
ATOM   1921  NZ  LYS   239      40.656  52.815  13.085  1.00 52.85           N   
ATOM   1922  C   LYS   239      41.219  47.051  16.487  1.00 43.37           C   
ATOM   1923  O   LYS   239      41.689  47.093  17.632  1.00 45.05           O   
ATOM   1924  N   ASN   240      40.031  46.511  16.201  1.00 41.75           N   
ATOM   1925  CA  ASN   240      39.077  46.073  17.234  1.00 42.54           C   
ATOM   1926  CB  ASN   240      37.701  46.681  16.956  1.00 45.04           C   
ATOM   1927  CG  ASN   240      37.772  48.166  16.611  1.00 44.87           C   
ATOM   1928  OD1 ASN   240      38.471  48.939  17.266  1.00 46.75           O   
ATOM   1929  ND2 ASN   240      37.044  48.565  15.575  1.00 46.40           N   
ATOM   1930  C   ASN   240      38.964  44.547  17.403  1.00 41.67           C   
ATOM   1931  O   ASN   240      38.033  44.033  18.054  1.00 43.42           O   
ATOM   1932  N   SER   241      39.910  43.830  16.799  1.00 38.18           N   
ATOM   1933  CA  SER   241      40.159  42.435  17.121  1.00 37.45           C   
ATOM   1934  CB  SER   241      40.597  41.671  15.863  1.00 37.76           C   
ATOM   1935  OG  SER   241      39.487  41.362  15.037  1.00 37.95           O   
ATOM   1936  C   SER   241      41.279  42.391  18.164  1.00 33.58           C   
ATOM   1937  O   SER   241      42.069  43.325  18.273  1.00 37.84           O   
ATOM   1938  N   THR   242      41.337  41.315  18.930  1.00 33.71           N   
ATOM   1939  CA  THR   242      42.505  41.075  19.788  1.00 31.40           C   
ATOM   1940  CB  THR   242      42.282  39.879  20.747  1.00 31.45           C   
ATOM   1941  OG1 THR   242      41.100  40.102  21.540  1.00 33.29           O   
ATOM   1942  CG2 THR   242      43.476  39.699  21.689  1.00 32.76           C   
ATOM   1943  C   THR   242      43.703  40.796  18.845  1.00 29.38           C   
ATOM   1944  O   THR   242      43.610  39.923  17.966  1.00 26.57           O   
ATOM   1945  N   PRO   243      44.808  41.550  18.998  1.00 28.72           N   
ATOM   1946  CA  PRO   243      46.002  41.273  18.180  1.00 27.17           C   
ATOM   1947  CB  PRO   243      47.055  42.207  18.771  1.00 29.67           C   
ATOM   1948  CG  PRO   243      46.263  43.331  19.411  1.00 31.71           C   
ATOM   1949  CD  PRO   243      45.027  42.661  19.947  1.00 31.87           C   
ATOM   1950  C   PRO   243      46.439  39.821  18.317  1.00 24.14           C   
ATOM   1951  O   PRO   243      46.286  39.201  19.385  1.00 23.94           O   
ATOM   1952  N   LEU   244      46.921  39.250  17.215  1.00 19.73           N   
ATOM   1953  CA  LEU   244      47.359  37.871  17.258  1.00 18.49           C   
ATOM   1954  CB  LEU   244      47.290  37.217  15.889  1.00 17.25           C   
ATOM   1955  CG  LEU   244      45.909  37.160  15.270  1.00 18.56           C   
ATOM   1956  CD1 LEU   244      45.936  36.389  13.960  1.00 17.38           C   
ATOM   1957  CD2 LEU   244      44.921  36.505  16.218  1.00 21.38           C   
ATOM   1958  C   LEU   244      48.785  37.837  17.759  1.00 17.73           C   
ATOM   1959  O   LEU   244      49.590  38.755  17.495  1.00 21.94           O   
ATOM   1960  N   LYS   245      49.097  36.744  18.441  1.00 18.94           N   
ATOM   1961  CA  LYS   245      50.432  36.565  18.971  0.50 18.98           C   
ATOM   1963  CB  LYS   245      50.410  36.170  20.449  0.50 18.29           C   
ATOM   1965  CG  LYS   245      49.779  37.241  21.361  0.50 21.62           C   
ATOM   1967  CD  LYS   245      49.808  36.828  22.828  0.50 22.11           C   
ATOM   1969  CE  LYS   245      48.528  37.245  23.537  0.50 26.93           C   
ATOM   1971  NZ  LYS   245      47.391  36.388  23.119  0.50 29.13           N   
ATOM   1973  C   LYS   245      51.179  35.544  18.141  1.00 17.88           C   
ATOM   1974  O   LYS   245      50.595  34.636  17.541  1.00 19.98           O   
ATOM   1975  N   LEU   246      52.466  35.708  18.086  1.00 15.54           N   
ATOM   1976  CA  LEU   246      53.318  34.875  17.262  1.00 15.37           C   
ATOM   1977  CB  LEU   246      54.453  35.730  16.720  1.00 15.65           C   
ATOM   1978  CG  LEU   246      55.524  35.013  15.875  1.00 16.35           C   
ATOM   1979  CD1 LEU   246      54.956  34.274  14.656  1.00 17.78           C   
ATOM   1980  CD2 LEU   246      56.569  36.012  15.390  1.00 19.89           C   
ATOM   1981  C   LEU   246      53.872  33.727  18.087  1.00 14.06           C   
ATOM   1982  O   LEU   246      54.506  33.953  19.116  1.00 15.75           O   
ATOM   1983  N   ASN   247      53.681  32.494  17.615  1.00 13.26           N   
ATOM   1984  CA  ASN   247      54.200  31.303  18.275  1.00 12.45           C   
ATOM   1985  CB  ASN   247      53.266  30.106  18.093  1.00 14.92           C   
ATOM   1986  CG  ASN   247      52.045  30.215  18.953  1.00 16.36           C   
ATOM   1987  OD1 ASN   247      52.148  30.053  20.179  1.00 17.76           O   
ATOM   1988  ND2 ASN   247      50.878  30.484  18.357  1.00 19.04           N   
ATOM   1989  C   ASN   247      55.604  30.901  17.854  1.00 13.23           C   
ATOM   1990  O   ASN   247      56.164  29.970  18.446  1.00 14.77           O   
ATOM   1991  N   PHE   248      56.191  31.592  16.861  1.00 12.47           N   
ATOM   1992  CA  PHE   248      57.424  31.148  16.235  1.00 12.66           C   
ATOM   1993  CB  PHE   248      57.151  30.750  14.775  1.00 13.26           C   
ATOM   1994  CG  PHE   248      56.013  29.775  14.660  1.00 11.64           C   
ATOM   1995  CD1 PHE   248      56.144  28.499  15.212  1.00 12.29           C   
ATOM   1996  CE1 PHE   248      55.076  27.592  15.164  1.00 12.71           C   
ATOM   1997  CZ  PHE   248      53.861  27.981  14.613  1.00 12.55           C   
ATOM   1998  CE2 PHE   248      53.700  29.248  14.107  1.00 12.33           C   
ATOM   1999  CD2 PHE   248      54.766  30.160  14.133  1.00 12.01           C   
ATOM   2000  C   PHE   248      58.525  32.189  16.320  1.00 12.78           C   
ATOM   2001  O   PHE   248      59.426  32.219  15.485  1.00 13.38           O   
ATOM   2002  N   GLU   249      58.478  33.014  17.355  1.00 14.19           N   
ATOM   2003  CA  GLU   249      59.488  34.038  17.520  1.00 15.99           C   
ATOM   2004  CB  GLU   249      59.172  34.924  18.741  1.00 18.36           C   
ATOM   2005  CG  GLU   249      58.076  35.948  18.477  0.50 22.78           C   
ATOM   2007  CD  GLU   249      57.502  36.624  19.728  0.50 23.98           C   
ATOM   2009  OE1 GLU   249      57.879  36.253  20.866  0.50 27.58           O   
ATOM   2011  OE2 GLU   249      56.637  37.513  19.554  0.50 26.55           O   
ATOM   2013  C   GLU   249      60.897  33.476  17.609  1.00 14.62           C   
ATOM   2014  O   GLU   249      61.823  33.993  16.965  1.00 15.69           O   
ATOM   2015  N   TRP   250      61.079  32.418  18.393  1.00 14.23           N   
ATOM   2016  CA  TRP   250      62.427  31.881  18.570  1.00 15.34           C   
ATOM   2017  CB  TRP   250      62.458  30.802  19.660  1.00 16.55           C   
ATOM   2018  CG  TRP   250      63.861  30.495  20.028  1.00 17.01           C   
ATOM   2019  CD1 TRP   250      64.611  31.085  21.043  1.00 18.37           C   
ATOM   2020  NE1 TRP   250      65.864  30.546  21.057  1.00 18.37           N   
ATOM   2021  CE2 TRP   250      65.980  29.627  20.044  1.00 18.08           C   
ATOM   2022  CD2 TRP   250      64.724  29.565  19.380  1.00 17.48           C   
ATOM   2023  CE3 TRP   250      64.567  28.688  18.281  1.00 17.55           C   
ATOM   2024  CZ3 TRP   250      65.632  27.933  17.878  1.00 18.68           C   
ATOM   2025  CH2 TRP   250      66.881  28.016  18.558  1.00 19.13           C   
ATOM   2026  CZ2 TRP   250      67.066  28.860  19.642  1.00 18.20           C   
ATOM   2027  C   TRP   250      62.973  31.361  17.255  1.00 13.95           C   
ATOM   2028  O   TRP   250      64.118  31.626  16.893  1.00 14.87           O   
ATOM   2029  N   GLU   251      62.149  30.598  16.538  1.00 13.02           N   
ATOM   2030  CA  GLU   251      62.571  29.995  15.287  1.00 12.82           C   
ATOM   2031  CB  GLU   251      61.417  29.176  14.686  1.00 13.24           C   
ATOM   2032  CG  GLU   251      61.039  27.938  15.472  1.00 13.76           C   
ATOM   2033  CD  GLU   251      59.907  28.154  16.499  1.00 13.02           C   
ATOM   2034  OE1 GLU   251      59.894  29.208  17.160  1.00 13.36           O   
ATOM   2035  OE2 GLU   251      59.037  27.254  16.602  1.00 13.11           O   
ATOM   2036  C   GLU   251      62.979  31.054  14.293  1.00 13.00           C   
ATOM   2037  O   GLU   251      63.970  30.860  13.570  1.00 14.46           O   
ATOM   2038  N   ILE   252      62.207  32.132  14.202  1.00 13.66           N   
ATOM   2039  CA  ILE   252      62.506  33.190  13.227  1.00 14.13           C   
ATOM   2040  CB  ILE   252      61.314  34.161  13.143  1.00 14.48           C   
ATOM   2041  CG1 ILE   252      60.143  33.467  12.433  1.00 14.16           C   
ATOM   2042  CD1 ILE   252      58.860  34.206  12.539  1.00 16.90           C   
ATOM   2043  CG2 ILE   252      61.716  35.392  12.333  1.00 16.74           C   
ATOM   2044  C   ILE   252      63.781  33.928  13.649  1.00 15.20           C   
ATOM   2045  O   ILE   252      64.661  34.173  12.813  1.00 16.53           O   
ATOM   2046  N   GLU   253      63.902  34.262  14.938  1.00 15.31           N   
ATOM   2047  CA  GLU   253      65.049  35.043  15.419  1.00 15.95           C   
ATOM   2048  CB  GLU   253      64.731  35.564  16.833  1.00 19.13           C   
ATOM   2049  CG  GLU   253      63.672  36.660  16.868  1.00 22.99           C   
ATOM   2050  CD  GLU   253      63.289  37.108  18.280  1.00 27.38           C   
ATOM   2051  OE1 GLU   253      63.666  36.418  19.256  1.00 31.83           O   
ATOM   2052  OE2 GLU   253      62.585  38.135  18.389  1.00 35.02           O   
ATOM   2053  C   GLU   253      66.338  34.234  15.430  1.00 16.76           C   
ATOM   2054  O   GLU   253      67.431  34.816  15.460  1.00 20.21           O   
ATOM   2055  N   ASN   254      66.246  32.917  15.478  1.00 15.57           N   
ATOM   2056  CA  ASN   254      67.405  32.034  15.598  1.00 16.64           C   
ATOM   2057  CB  ASN   254      67.334  31.292  16.925  1.00 17.13           C   
ATOM   2058  CG  ASN   254      67.340  32.247  18.078  1.00 18.75           C   
ATOM   2059  OD1 ASN   254      66.292  32.673  18.601  1.00 19.69           O   
ATOM   2060  ND2 ASN   254      68.509  32.664  18.437  1.00 20.34           N   
ATOM   2061  C   ASN   254      67.471  31.039  14.458  1.00 16.13           C   
ATOM   2062  O   ASN   254      68.015  29.928  14.581  1.00 17.52           O   
ATOM   2063  N   ARG   255      66.903  31.433  13.324  1.00 15.24           N   
ATOM   2064  CA  ARG   255      66.819  30.526  12.178  1.00 16.02           C   
ATOM   2065  CB  ARG   255      65.970  31.129  11.069  1.00 15.00           C   
ATOM   2066  CG  ARG   255      66.568  32.346  10.432  1.00 16.59           C   
ATOM   2067  CD  ARG   255      65.510  33.004   9.574  1.00 17.37           C   
ATOM   2068  NE  ARG   255      66.000  34.182   8.898  1.00 19.19           N   
ATOM   2069  CZ  ARG   255      65.291  34.854   7.995  1.00 19.43           C   
ATOM   2070  NH1 ARG   255      64.033  34.530   7.725  1.00 20.70           N   
ATOM   2071  NH2 ARG   255      65.841  35.886   7.369  1.00 23.84           N   
ATOM   2072  C   ARG   255      68.200  30.087  11.669  1.00 15.21           C   
ATOM   2073  O   ARG   255      69.229  30.744  11.936  1.00 17.04           O   
ATOM   2074  N   TYR   256      68.228  28.968  10.971  1.00 14.59           N   
ATOM   2075  CA  TYR   256      69.448  28.325  10.564  1.00 15.12           C   
ATOM   2076  CB  TYR   256      69.127  27.055   9.776  1.00 15.50           C   
ATOM   2077  CG  TYR   256      70.336  26.223   9.468  1.00 15.42           C   
ATOM   2078  CD1 TYR   256      70.896  25.392  10.443  1.00 17.48           C   
ATOM   2079  CE1 TYR   256      72.029  24.621  10.182  1.00 19.81           C   
ATOM   2080  CZ  TYR   256      72.615  24.703   8.936  1.00 19.76           C   
ATOM   2081  OH  TYR   256      73.727  23.924   8.704  1.00 22.42           O   
ATOM   2082  CE2 TYR   256      72.088  25.531   7.943  1.00 19.40           C   
ATOM   2083  CD2 TYR   256      70.945  26.288   8.223  1.00 18.65           C   
ATOM   2084  C   TYR   256      70.293  29.277   9.700  1.00 16.56           C   
ATOM   2085  O   TYR   256      69.834  29.892   8.749  1.00 18.61           O   
ATOM   2086  N   LYS   257      71.549  29.401  10.074  1.00 17.36           N   
ATOM   2087  CA  LYS   257      72.482  30.234   9.317  1.00 20.13           C   
ATOM   2088  CB  LYS   257      73.563  30.777  10.251  1.00 21.57           C   
ATOM   2089  CG  LYS   257      73.039  31.610  11.404  1.00 29.13           C   
ATOM   2090  CD  LYS   257      74.196  32.086  12.295  1.00 31.04           C   
ATOM   2091  CE  LYS   257      73.864  31.936  13.760  1.00 34.11           C   
ATOM   2092  NZ  LYS   257      74.002  30.510  14.161  1.00 35.17           N   
ATOM   2093  C   LYS   257      73.166  29.478   8.192  1.00 19.89           C   
ATOM   2094  O   LYS   257      73.830  28.478   8.410  1.00 23.29           O   
ATOM   2095  N   HIS   258      73.024  30.026   7.003  1.00 21.94           N   
ATOM   2096  CA  HIS   258      73.643  29.460   5.809  1.00 25.15           C   
ATOM   2097  CB  HIS   258      72.888  29.881   4.566  1.00 28.57           C   
ATOM   2098  CG  HIS   258      71.473  29.397   4.516  1.00 28.52           C   
ATOM   2099  ND1 HIS   258      71.131  28.081   4.281  1.00 30.51           N   
ATOM   2100  CE1 HIS   258      69.808  27.978   4.252  1.00 25.43           C   
ATOM   2101  NE2 HIS   258      69.291  29.174   4.458  1.00 33.09           N   
ATOM   2102  CD2 HIS   258      70.308  30.082   4.600  1.00 31.84           C   
ATOM   2103  C   HIS   258      75.074  29.938   5.648  1.00 27.50           C   
ATOM   2104  O   HIS   258      75.571  30.789   6.393  1.00 26.66           O   
ATOM   2105  N   ASN   259      75.711  29.413   4.624  1.00 28.50           N   
ATOM   2106  CA  ASN   259      77.085  29.753   4.331  1.00 27.97           C   
ATOM   2107  CB  ASN   259      77.940  28.534   4.673  1.00 26.78           C   
ATOM   2108  CG  ASN   259      77.630  27.331   3.793  1.00 28.27           C   
ATOM   2109  OD1 ASN   259      77.259  27.493   2.626  1.00 23.39           O   
ATOM   2110  ND2 ASN   259      77.778  26.117   4.343  1.00 30.51           N   
ATOM   2111  C   ASN   259      77.155  30.151   2.860  1.00 30.74           C   
ATOM   2112  O   ASN   259      76.121  30.386   2.212  1.00 30.34           O   
ATOM   2113  N   GLU   260      78.366  30.211   2.306  1.00 31.31           N   
ATOM   2114  CA  GLU   260      78.550  30.681   0.937  1.00 28.12           C   
ATOM   2115  CB  GLU   260      80.046  30.792   0.588  1.00 34.91           C   
ATOM   2116  CG  GLU   260      80.981  31.113   1.759  1.00 41.29           C   
ATOM   2117  CD  GLU   260      80.632  32.406   2.463  1.00 43.63           C   
ATOM   2118  OE1 GLU   260      80.194  33.360   1.779  1.00 46.91           O   
ATOM   2119  OE2 GLU   260      80.794  32.465   3.705  1.00 46.56           O   
ATOM   2120  C   GLU   260      77.873  29.784  -0.103  1.00 29.74           C   
ATOM   2121  O   GLU   260      77.342  30.258  -1.107  1.00 34.71           O   
ATOM   2122  N   VAL   261      77.911  28.485   0.155  1.00 27.63           N   
ATOM   2123  CA  VAL   261      77.320  27.481  -0.719  1.00 26.26           C   
ATOM   2124  CB  VAL   261      77.857  26.071  -0.355  1.00 28.02           C   
ATOM   2125  CG1 VAL   261      77.087  24.960  -1.100  1.00 30.18           C   
ATOM   2126  CG2 VAL   261      79.366  26.003  -0.631  1.00 28.66           C   
ATOM   2127  C   VAL   261      75.781  27.496  -0.672  1.00 24.73           C   
ATOM   2128  O   VAL   261      75.119  27.344  -1.704  1.00 24.05           O   
ATOM   2129  N   THR   262      75.227  27.670   0.527  1.00 20.54           N   
ATOM   2130  CA  THR   262      73.764  27.539   0.744  1.00 21.56           C   
ATOM   2131  CB  THR   262      73.534  26.744   2.044  1.00 22.10           C   
ATOM   2132  OG1 THR   262      74.059  27.518   3.131  1.00 24.48           O   
ATOM   2133  CG2 THR   262      74.289  25.390   1.996  1.00 21.76           C   
ATOM   2134  C   THR   262      72.988  28.867   0.744  1.00 23.25           C   
ATOM   2135  O   THR   262      71.744  28.860   0.898  1.00 21.88           O   
ATOM   2136  N   LYS   263      73.682  30.009   0.566  1.00 23.66           N   
ATOM   2137  CA  LYS   263      73.062  31.331   0.643  1.00 27.62           C   
ATOM   2138  CB  LYS   263      74.070  32.433   0.238  1.00 33.85           C   
ATOM   2139  CG  LYS   263      75.145  32.804   1.288  1.00 38.76           C   
ATOM   2140  CD  LYS   263      74.577  33.018   2.714  1.00 38.88           C   
ATOM   2141  CE  LYS   263      75.530  33.811   3.615  1.00 39.56           C   
ATOM   2142  NZ  LYS   263      76.941  33.301   3.601  1.00 41.96           N   
ATOM   2143  C   LYS   263      71.820  31.432  -0.279  1.00 27.32           C   
ATOM   2144  O   LYS   263      71.845  30.942  -1.422  1.00 25.90           O   
ATOM   2145  N   ALA   264      70.738  32.017   0.244  1.00 22.97           N   
ATOM   2146  CA  ALA   264      69.501  32.217  -0.482  1.00 23.60           C   
ATOM   2147  CB  ALA   264      68.637  31.012  -0.311  1.00 22.66           C   
ATOM   2148  C   ALA   264      68.768  33.438   0.044  1.00 24.35           C   
ATOM   2149  O   ALA   264      69.167  34.037   1.063  1.00 26.00           O   
ATOM   2150  N   GLU   265      67.635  33.731  -0.601  1.00 19.56           N   
ATOM   2151  CA  GLU   265      66.839  34.961  -0.439  1.00 22.75           C   
ATOM   2152  CB  GLU   265      67.232  35.980  -1.546  1.00 27.99           C   
ATOM   2153  CG  GLU   265      68.642  36.528  -1.525  1.00 33.44           C   
ATOM   2154  CD  GLU   265      68.710  37.903  -2.191  1.00 32.18           C   
ATOM   2155  OE1 GLU   265      68.488  38.013  -3.427  1.00 33.40           O   
ATOM   2156  OE2 GLU   265      68.969  38.881  -1.464  1.00 36.41           O   
ATOM   2157  C   GLU   265      65.393  34.628  -0.776  1.00 18.33           C   
ATOM   2158  O   GLU   265      65.150  33.836  -1.699  1.00 18.55           O   
ATOM   2159  N   PRO   266      64.423  35.284  -0.116  1.00 17.01           N   
ATOM   2160  CA  PRO   266      63.043  35.156  -0.592  1.00 15.99           C   
ATOM   2161  CB  PRO   266      62.233  35.997   0.413  1.00 18.70           C   
ATOM   2162  CG  PRO   266      63.078  36.103   1.609  1.00 20.18           C   
ATOM   2163  CD  PRO   266      64.497  36.120   1.105  1.00 17.76           C   
ATOM   2164  C   PRO   266      62.885  35.738  -1.988  1.00 15.58           C   
ATOM   2165  O   PRO   266      63.569  36.709  -2.371  1.00 18.53           O   
ATOM   2166  N   ILE   267      61.937  35.179  -2.714  1.00 14.95           N   
ATOM   2167  CA  ILE   267      61.626  35.704  -4.054  1.00 14.20           C   
ATOM   2168  CB  ILE   267      61.657  34.579  -5.096  1.00 14.95           C   
ATOM   2169  CG1 ILE   267      63.057  33.992  -5.179  1.00 18.14           C   
ATOM   2170  CD1 ILE   267      64.069  34.933  -5.642  0.60 16.32           C   
ATOM   2172  CG2 ILE   267      61.102  35.091  -6.432  1.00 15.94           C   
ATOM   2173  C   ILE   267      60.258  36.390  -3.958  1.00 12.67           C   
ATOM   2174  O   ILE   267      59.289  35.786  -3.500  1.00 13.60           O   
ATOM   2175  N   PRO   268      60.156  37.642  -4.406  1.00 12.87           N   
ATOM   2176  CA  PRO   268      58.874  38.331  -4.299  1.00 12.66           C   
ATOM   2177  CB  PRO   268      59.164  39.760  -4.807  1.00 14.29           C   
ATOM   2178  CG  PRO   268      60.467  39.638  -5.545  1.00 17.99           C   
ATOM   2179  CD  PRO   268      61.220  38.496  -4.975  1.00 14.57           C   
ATOM   2180  C   PRO   268      57.765  37.653  -5.072  1.00 12.39           C   
ATOM   2181  O   PRO   268      58.004  36.973  -6.076  1.00 13.15           O   
ATOM   2182  N   ILE   269      56.546  37.876  -4.613  1.00 11.86           N   
ATOM   2183  CA  ILE   269      55.384  37.320  -5.303  1.00 12.06           C   
ATOM   2184  CB  ILE   269      54.075  37.522  -4.507  1.00 12.11           C   
ATOM   2185  CG1 ILE   269      53.657  38.982  -4.380  1.00 12.74           C   
ATOM   2186  CD1 ILE   269      52.328  39.119  -3.693  1.00 12.82           C   
ATOM   2187  CG2 ILE   269      54.225  36.837  -3.118  1.00 13.80           C   
ATOM   2188  C   ILE   269      55.291  37.882  -6.740  1.00 11.49           C   
ATOM   2189  O   ILE   269      55.791  38.954  -7.053  1.00 12.25           O   
ATOM   2190  N   ALA   270      54.600  37.147  -7.590  1.00 12.05           N   
ATOM   2191  CA  ALA   270      54.357  37.576  -8.940  1.00 12.69           C   
ATOM   2192  CB  ALA   270      53.562  36.482  -9.664  1.00 13.07           C   
ATOM   2193  C   ALA   270      53.570  38.885  -8.922  1.00 12.61           C   
ATOM   2194  O   ALA   270      52.683  39.086  -8.076  1.00 12.21           O   
ATOM   2195  N   ASP   271      53.853  39.737  -9.924  0.50 12.56           N   
ATOM   2197  CA  ASP   271      53.178  41.022 -10.100  0.50 15.18           C   
ATOM   2199  CB  ASP   271      53.573  41.672 -11.433  0.50 16.95           C   
ATOM   2201  CG  ASP   271      54.994  42.171 -11.450  0.50 18.99           C   
ATOM   2203  OD1 ASP   271      55.472  42.488 -12.568  0.50 21.09           O   
ATOM   2205  OD2 ASP   271      55.647  42.264 -10.382  0.50 15.64           O   
ATOM   2207  C   ASP   271      51.658  40.901 -10.088  0.50 13.10           C   
ATOM   2209  O   ASP   271      50.964  41.737  -9.543  0.50 13.86           O   
ATOM   2211  N   GLU   272      51.140  39.863 -10.736  1.00 13.70           N   
ATOM   2212  CA  GLU   272      49.697  39.681 -10.863  1.00 14.78           C   
ATOM   2213  CB  GLU   272      49.351  38.648 -11.953  1.00 17.52           C   
ATOM   2214  CG  GLU   272      49.847  37.228 -11.663  1.00 19.69           C   
ATOM   2215  CD  GLU   272      49.651  36.237 -12.811  1.00 23.31           C   
ATOM   2216  OE1 GLU   272      48.702  35.425 -12.751  1.00 24.37           O   
ATOM   2217  OE2 GLU   272      50.515  36.237 -13.735  1.00 27.71           O   
ATOM   2218  C   GLU   272      49.089  39.300  -9.519  1.00 13.49           C   
ATOM   2219  O   GLU   272      47.934  39.673  -9.213  1.00 13.98           O   
ATOM   2220  N   ASP   273      49.860  38.588  -8.682  1.00 12.63           N   
ATOM   2221  CA  ASP   273      49.365  38.202  -7.361  1.00 12.22           C   
ATOM   2222  CB  ASP   273      50.149  37.006  -6.818  1.00 11.83           C   
ATOM   2223  CG  ASP   273      49.828  35.724  -7.579  1.00 12.50           C   
ATOM   2224  OD1 ASP   273      48.715  35.632  -8.135  1.00 14.23           O   
ATOM   2225  OD2 ASP   273      50.677  34.794  -7.632  1.00 12.81           O   
ATOM   2226  C   ASP   273      49.395  39.389  -6.395  1.00 11.24           C   
ATOM   2227  O   ASP   273      48.489  39.577  -5.596  1.00 11.98           O   
ATOM   2228  N   LEU   274      50.408  40.260  -6.508  1.00 11.27           N   
ATOM   2229  CA  LEU   274      50.414  41.463  -5.693  1.00 11.97           C   
ATOM   2230  CB  LEU   274      51.745  42.227  -5.855  1.00 12.73           C   
ATOM   2231  CG  LEU   274      51.829  43.498  -5.004  1.00 14.33           C   
ATOM   2232  CD1 LEU   274      51.823  43.167  -3.465  1.00 17.01           C   
ATOM   2233  CD2 LEU   274      53.056  44.310  -5.343  1.00 16.70           C   
ATOM   2234  C   LEU   274      49.223  42.360  -6.028  1.00 12.34           C   
ATOM   2235  O   LEU   274      48.597  42.905  -5.121  1.00 12.41           O   
ATOM   2236  N   VAL   275      48.876  42.489  -7.311  1.00 12.28           N   
ATOM   2237  CA  VAL   275      47.719  43.292  -7.695  1.00 13.65           C   
ATOM   2238  CB  VAL   275      47.596  43.341  -9.243  1.00 15.63           C   
ATOM   2239  CG1 VAL   275      46.273  44.004  -9.625  1.00 17.43           C   
ATOM   2240  CG2 VAL   275      48.751  44.145  -9.844  1.00 17.11           C   
ATOM   2241  C   VAL   275      46.455  42.725  -7.039  1.00 13.44           C   
ATOM   2242  O   VAL   275      45.647  43.438  -6.486  1.00 14.34           O   
ATOM   2243  N   LYS   276      46.285  41.412  -7.081  1.00 12.76           N   
ATOM   2244  CA  LYS   276      45.093  40.820  -6.473  1.00 13.87           C   
ATOM   2245  CB  LYS   276      45.065  39.333  -6.765  1.00 15.71           C   
ATOM   2246  CG  LYS   276      44.684  39.018  -8.219  1.00 17.91           C   
ATOM   2247  CD  LYS   276      44.530  37.510  -8.477  1.00 20.76           C   
ATOM   2248  CE  LYS   276      45.862  36.817  -8.496  1.00 20.60           C   
ATOM   2249  NZ  LYS   276      45.736  35.328  -8.596  1.00 21.30           N   
ATOM   2250  C   LYS   276      45.045  41.051  -4.968  1.00 13.95           C   
ATOM   2251  O   LYS   276      43.975  41.301  -4.397  1.00 17.10           O   
ATOM   2252  N   ILE   277      46.194  40.998  -4.308  1.00 13.40           N   
ATOM   2253  CA  ILE   277      46.233  41.214  -2.875  1.00 14.38           C   
ATOM   2254  CB  ILE   277      47.558  40.699  -2.311  1.00 16.62           C   
ATOM   2255  CG1 ILE   277      47.616  39.167  -2.453  1.00 16.44           C   
ATOM   2256  CD1 ILE   277      49.048  38.604  -2.421  1.00 17.24           C   
ATOM   2257  CG2 ILE   277      47.748  41.151  -0.879  1.00 19.36           C   
ATOM   2258  C   ILE   277      45.988  42.680  -2.532  1.00 13.43           C   
ATOM   2259  O   ILE   277      45.208  42.985  -1.619  1.00 15.13           O   
ATOM   2260  N   GLU   278      46.579  43.601  -3.294  1.00 13.96           N   
ATOM   2261  CA  GLU   278      46.405  45.030  -3.041  1.00 16.04           C   
ATOM   2262  CB  GLU   278      47.343  45.841  -3.928  1.00 17.64           C   
ATOM   2263  CG  GLU   278      48.806  45.806  -3.570  1.00 22.52           C   
ATOM   2264  CD  GLU   278      49.628  46.347  -4.743  1.00 29.44           C   
ATOM   2265  OE1 GLU   278      49.147  46.359  -5.892  1.00 30.77           O   
ATOM   2266  OE2 GLU   278      50.782  46.699  -4.540  1.00 26.57           O   
ATOM   2267  C   GLU   278      44.943  45.445  -3.298  1.00 14.07           C   
ATOM   2268  O   GLU   278      44.415  46.314  -2.594  1.00 16.14           O   
ATOM   2269  N   ASN   279      44.275  44.802  -4.255  1.00 14.24           N   
ATOM   2270  CA  ASN   279      42.894  45.160  -4.561  1.00 14.88           C   
ATOM   2271  CB  ASN   279      42.398  44.416  -5.815  1.00 16.04           C   
ATOM   2272  CG  ASN   279      42.849  45.029  -7.099  1.00 21.47           C   
ATOM   2273  OD1 ASN   279      43.464  46.085  -7.135  1.00 21.95           O   
ATOM   2274  ND2 ASN   279      42.570  44.302  -8.207  1.00 22.06           N   
ATOM   2275  C   ASN   279      41.953  44.867  -3.395  1.00 13.97           C   
ATOM   2276  O   ASN   279      40.827  45.374  -3.381  1.00 15.46           O   
ATOM   2277  N   LEU   280      42.366  44.029  -2.430  1.00 14.07           N   
ATOM   2278  CA  LEU   280      41.509  43.732  -1.274  1.00 13.62           C   
ATOM   2279  CB  LEU   280      42.064  42.544  -0.501  1.00 13.37           C   
ATOM   2280  CG  LEU   280      42.150  41.223  -1.265  1.00 14.30           C   
ATOM   2281  CD1 LEU   280      42.918  40.181  -0.419  1.00 15.30           C   
ATOM   2282  CD2 LEU   280      40.753  40.695  -1.594  1.00 18.14           C   
ATOM   2283  C   LEU   280      41.366  44.909  -0.334  1.00 14.11           C   
ATOM   2284  O   LEU   280      40.392  44.963   0.441  1.00 15.93           O   
ATOM   2285  N   HIS   281      42.333  45.836  -0.348  1.00 14.91           N   
ATOM   2286  CA  HIS   281      42.328  47.012   0.570  1.00 16.33           C   
ATOM   2287  CB  HIS   281      41.182  47.999   0.234  1.00 19.59           C   
ATOM   2288  CG  HIS   281      41.099  48.391  -1.216  1.00 25.43           C   
ATOM   2289  ND1 HIS   281      42.209  48.637  -1.995  1.00 30.37           N   
ATOM   2290  CE1 HIS   281      41.824  48.986  -3.216  1.00 30.10           C   
ATOM   2291  NE2 HIS   281      40.506  48.960  -3.259  1.00 31.92           N   
ATOM   2292  CD2 HIS   281      40.026  48.606  -2.017  1.00 29.83           C   
ATOM   2293  C   HIS   281      42.256  46.550   2.036  1.00 16.20           C   
ATOM   2294  O   HIS   281      41.567  47.155   2.867  1.00 18.69           O   
ATOM   2295  N   GLU   282      42.954  45.472   2.355  1.00 15.33           N   
ATOM   2296  CA  GLU   282      42.986  44.935   3.721  1.00 14.95           C   
ATOM   2297  CB  GLU   282      41.991  43.794   3.912  1.00 17.05           C   
ATOM   2298  CG  GLU   282      40.533  44.162   3.789  1.00 19.48           C   
ATOM   2299  CD  GLU   282      39.981  45.034   4.928  1.00 23.78           C   
ATOM   2300  OE1 GLU   282      40.592  45.132   6.027  1.00 23.95           O   
ATOM   2301  OE2 GLU   282      38.878  45.611   4.734  1.00 27.62           O   
ATOM   2302  C   GLU   282      44.362  44.395   3.947  1.00 15.01           C   
ATOM   2303  O   GLU   282      45.029  44.013   2.988  1.00 18.43           O   
ATOM   2304  N   ASP   283      44.786  44.333   5.207  1.00 14.66           N   
ATOM   2305  CA  ASP   283      46.080  43.756   5.464  1.00 14.43           C   
ATOM   2306  CB  ASP   283      47.012  44.787   6.092  1.00 17.19           C   
ATOM   2307  CG  ASP   283      48.488  44.399   5.988  1.00 20.22           C   
ATOM   2308  OD1 ASP   283      48.903  43.708   5.050  1.00 23.42           O   
ATOM   2309  OD2 ASP   283      49.255  44.834   6.858  1.00 24.26           O   
ATOM   2310  C   ASP   283      45.931  42.551   6.371  1.00 13.51           C   
ATOM   2311  O   ASP   283      44.933  42.444   7.108  1.00 14.39           O   
ATOM   2312  N   TYR   284      46.887  41.640   6.276  1.00 12.72           N   
ATOM   2313  CA  TYR   284      46.817  40.363   6.976  1.00 11.58           C   
ATOM   2314  CB  TYR   284      46.529  39.220   5.968  1.00 12.04           C   
ATOM   2315  CG  TYR   284      45.169  39.329   5.301  1.00 12.13           C   
ATOM   2316  CD1 TYR   284      44.072  38.618   5.798  1.00 12.84           C   
ATOM   2317  CE1 TYR   284      42.811  38.773   5.239  1.00 13.55           C   
ATOM   2318  CZ  TYR   284      42.645  39.664   4.182  1.00 13.57           C   
ATOM   2319  OH  TYR   284      41.388  39.815   3.642  1.00 17.62           O   
ATOM   2320  CE2 TYR   284      43.726  40.362   3.656  1.00 13.99           C   
ATOM   2321  CD2 TYR   284      44.969  40.209   4.230  1.00 12.59           C   
ATOM   2322  C   TYR   284      48.102  40.051   7.657  1.00 12.23           C   
ATOM   2323  O   TYR   284      49.156  40.379   7.137  1.00 13.99           O   
ATOM   2324  N   TYR   285      48.029  39.401   8.814  1.00 12.06           N   
ATOM   2325  CA  TYR   285      49.214  38.753   9.360  1.00 11.08           C   
ATOM   2326  CB  TYR   285      48.868  38.070  10.681  1.00 12.81           C   
ATOM   2327  CG  TYR   285      48.561  38.995  11.808  1.00 13.70           C   
ATOM   2328  CD1 TYR   285      49.598  39.457  12.649  1.00 16.57           C   
ATOM   2329  CE1 TYR   285      49.319  40.276  13.733  1.00 20.32           C   
ATOM   2330  CZ  TYR   285      48.009  40.633  14.001  1.00 19.73           C   
ATOM   2331  OH  TYR   285      47.763  41.439  15.105  1.00 22.19           O   
ATOM   2332  CE2 TYR   285      46.961  40.183  13.214  1.00 19.20           C   
ATOM   2333  CD2 TYR   285      47.245  39.356  12.109  1.00 16.53           C   
ATOM   2334  C   TYR   285      49.670  37.652   8.407  1.00 11.08           C   
ATOM   2335  O   TYR   285      48.842  37.055   7.695  1.00 10.88           O   
ATOM   2336  N   PRO   286      50.965  37.325   8.389  1.00 10.98           N   
ATOM   2337  CA  PRO   286      51.388  36.201   7.569  1.00 10.88           C   
ATOM   2338  CB  PRO   286      52.931  36.211   7.661  1.00 13.15           C   
ATOM   2339  CG  PRO   286      53.228  37.019   8.854  1.00 14.59           C   
ATOM   2340  CD  PRO   286      52.079  37.984   9.090  1.00 11.88           C   
ATOM   2341  C   PRO   286      50.807  34.894   8.071  1.00 10.65           C   
ATOM   2342  O   PRO   286      50.369  34.768   9.226  1.00 11.16           O   
ATOM   2343  N   GLY   287      50.834  33.888   7.205  1.00 10.91           N   
ATOM   2344  CA  GLY   287      50.135  32.632   7.449  1.00 10.74           C   
ATOM   2345  C   GLY   287      50.543  31.926   8.714  1.00 10.88           C   
ATOM   2346  O   GLY   287      49.728  31.205   9.308  1.00 11.16           O   
ATOM   2347  N   TRP   288      51.799  32.121   9.137  1.00 10.85           N   
ATOM   2348  CA  TRP   288      52.304  31.478  10.355  1.00 11.09           C   
ATOM   2349  CB  TRP   288      53.834  31.435  10.345  1.00 11.55           C   
ATOM   2350  CG  TRP   288      54.517  32.718  10.018  1.00 10.92           C   
ATOM   2351  CD1 TRP   288      54.948  33.664  10.892  1.00 12.39           C   
ATOM   2352  NE1 TRP   288      55.604  34.691  10.200  1.00 12.12           N   
ATOM   2353  CE2 TRP   288      55.638  34.373   8.873  1.00 11.47           C   
ATOM   2354  CD2 TRP   288      54.949  33.141   8.712  1.00 11.06           C   
ATOM   2355  CE3 TRP   288      54.840  32.580   7.434  1.00 11.83           C   
ATOM   2356  CZ3 TRP   288      55.385  33.255   6.358  1.00 12.61           C   
ATOM   2357  CH2 TRP   288      56.073  34.478   6.540  1.00 13.15           C   
ATOM   2358  CZ2 TRP   288      56.208  35.059   7.790  1.00 13.56           C   
ATOM   2359  C   TRP   288      51.752  32.076  11.653  1.00 11.20           C   
ATOM   2360  O   TRP   288      52.093  31.589  12.715  1.00 11.98           O   
ATOM   2361  N   TYR   289      50.844  33.046  11.560  1.00 10.72           N   
ATOM   2362  CA  TYR   289      50.026  33.430  12.714  1.00 11.41           C   
ATOM   2363  CB  TYR   289      49.630  34.897  12.640  1.00 12.36           C   
ATOM   2364  CG  TYR   289      50.738  35.834  13.047  1.00 11.85           C   
ATOM   2365  CD1 TYR   289      51.801  36.098  12.189  1.00 13.27           C   
ATOM   2366  CE1 TYR   289      52.843  36.971  12.564  1.00 13.49           C   
ATOM   2367  CZ  TYR   289      52.803  37.582  13.803  1.00 14.12           C   
ATOM   2368  OH  TYR   289      53.824  38.440  14.181  1.00 16.60           O   
ATOM   2369  CE2 TYR   289      51.775  37.300  14.684  1.00 14.25           C   
ATOM   2370  CD2 TYR   289      50.743  36.432  14.311  1.00 13.68           C   
ATOM   2371  C   TYR   289      48.807  32.529  12.897  1.00 11.65           C   
ATOM   2372  O   TYR   289      48.108  32.682  13.904  1.00 12.94           O   
ATOM   2373  N   LEU   290      48.558  31.610  11.959  1.00 11.33           N   
ATOM   2374  CA  LEU   290      47.504  30.606  12.147  1.00 11.89           C   
ATOM   2375  CB  LEU   290      46.745  30.391  10.819  1.00 12.50           C   
ATOM   2376  CG  LEU   290      45.484  29.531  11.017  1.00 14.14           C   
ATOM   2377  CD1 LEU   290      44.336  30.409  11.535  1.00 19.21           C   
ATOM   2378  CD2 LEU   290      45.052  28.806   9.735  1.00 13.16           C   
ATOM   2379  C   LEU   290      48.084  29.269  12.584  1.00 11.53           C   
ATOM   2380  O   LEU   290      48.952  28.725  11.894  1.00 12.33           O   
ATOM   2381  N   VAL   291      47.587  28.729  13.704  1.00 11.48           N   
ATOM   2382  CA  VAL   291      48.043  27.424  14.149  1.00 13.27           C   
ATOM   2383  CB  VAL   291      48.907  27.487  15.436  1.00 14.56           C   
ATOM   2384  CG1 VAL   291      50.239  28.219  15.133  1.00 16.38           C   
ATOM   2385  CG2 VAL   291      48.129  28.186  16.563  1.00 16.30           C   
ATOM   2386  C   VAL   291      46.888  26.445  14.337  1.00 13.14           C   
ATOM   2387  O   VAL   291      47.125  25.290  14.687  1.00 17.30           O   
ATOM   2388  N   ASP   292      45.655  26.853  14.047  1.00 12.72           N   
ATOM   2389  CA  ASP   292      44.509  25.933  14.137  1.00 14.08           C   
ATOM   2390  CB  ASP   292      43.282  26.740  14.580  1.00 14.52           C   
ATOM   2391  CG  ASP   292      42.048  25.883  14.810  1.00 15.25           C   
ATOM   2392  OD1 ASP   292      42.029  24.677  14.424  1.00 14.94           O   
ATOM   2393  OD2 ASP   292      41.083  26.447  15.373  1.00 18.59           O   
ATOM   2394  C   ASP   292      44.277  25.234  12.809  1.00 12.50           C   
ATOM   2395  O   ASP   292      43.815  25.839  11.840  1.00 13.05           O   
ATOM   2396  N   ASP   293      44.561  23.921  12.777  1.00 13.43           N   
ATOM   2397  CA  ASP   293      44.412  23.127  11.575  1.00 14.33           C   
ATOM   2398  CB  ASP   293      44.739  21.653  11.820  1.00 14.60           C   
ATOM   2399  CG  ASP   293      46.168  21.458  12.342  1.00 14.89           C   
ATOM   2400  OD1 ASP   293      47.018  20.972  11.583  1.00 15.95           O   
ATOM   2401  OD2 ASP   293      46.448  21.835  13.525  1.00 17.37           O   
ATOM   2402  C   ASP   293      43.024  23.223  10.989  1.00 13.75           C   
ATOM   2403  O   ASP   293      42.889  23.118   9.772  1.00 15.62           O   
ATOM   2404  N   LYS   294      42.008  23.406  11.830  1.00 13.10           N   
ATOM   2405  CA  LYS   294      40.623  23.414  11.322  1.00 13.92           C   
ATOM   2406  CB  LYS   294      39.619  23.412  12.469  1.00 14.53           C   
ATOM   2407  CG  LYS   294      39.639  22.097  13.258  1.00 16.32           C   
ATOM   2408  CD  LYS   294      38.651  22.075  14.412  1.00 17.69           C   
ATOM   2409  CE  LYS   294      38.985  23.069  15.504  1.00 17.41           C   
ATOM   2410  NZ  LYS   294      40.409  22.977  15.959  1.00 16.55           N   
ATOM   2411  C   LYS   294      40.349  24.623  10.457  1.00 13.50           C   
ATOM   2412  O   LYS   294      39.391  24.611   9.700  1.00 15.86           O   
ATOM   2413  N   LEU   295      41.164  25.674  10.592  1.00 12.61           N   
ATOM   2414  CA  LEU   295      40.933  26.927   9.882  1.00 12.95           C   
ATOM   2415  CB  LEU   295      41.057  28.090  10.849  1.00 14.23           C   
ATOM   2416  CG  LEU   295      40.098  28.065  12.046  1.00 16.52           C   
ATOM   2417  CD1 LEU   295      40.412  29.247  12.954  1.00 18.47           C   
ATOM   2418  CD2 LEU   295      38.650  28.080  11.614  1.00 20.21           C   
ATOM   2419  C   LEU   295      41.896  27.139   8.723  1.00 12.14           C   
ATOM   2420  O   LEU   295      41.868  28.187   8.066  1.00 12.57           O   
ATOM   2421  N   GLU   296      42.700  26.131   8.405  1.00 12.26           N   
ATOM   2422  CA  GLU   296      43.705  26.254   7.377  1.00 12.40           C   
ATOM   2423  CB  GLU   296      44.504  24.949   7.296  1.00 13.55           C   
ATOM   2424  CG  GLU   296      45.704  24.994   6.373  1.00 15.14           C   
ATOM   2425  CD  GLU   296      46.582  23.761   6.478  1.00 17.27           C   
ATOM   2426  OE1 GLU   296      46.406  22.966   7.418  1.00 19.98           O   
ATOM   2427  OE2 GLU   296      47.464  23.590   5.615  1.00 19.76           O   
ATOM   2428  C   GLU   296      43.141  26.649   6.009  1.00 12.32           C   
ATOM   2429  O   GLU   296      43.783  27.406   5.277  1.00 12.92           O   
ATOM   2430  N   ARG   297      41.954  26.142   5.680  1.00 12.35           N   
ATOM   2431  CA  ARG   297      41.309  26.398   4.410  1.00 13.43           C   
ATOM   2432  CB  ARG   297      40.882  25.072   3.779  1.00 15.90           C   
ATOM   2433  CG  ARG   297      42.096  24.238   3.433  1.00 16.64           C   
ATOM   2434  CD  ARG   297      41.792  22.810   3.017  1.00 21.02           C   
ATOM   2435  NE  ARG   297      42.952  22.188   2.327  1.00 29.10           N   
ATOM   2436  CZ  ARG   297      44.045  21.641   2.903  1.00 31.26           C   
ATOM   2437  NH1 ARG   297      44.992  21.118   2.130  1.00 33.74           N   
ATOM   2438  NH2 ARG   297      44.211  21.603   4.222  1.00 30.95           N   
ATOM   2439  C   ARG   297      40.160  27.390   4.536  1.00 13.51           C   
ATOM   2440  O   ARG   297      39.323  27.458   3.647  1.00 16.20           O   
ATOM   2441  N   ALA   298      40.186  28.244   5.556  1.00 13.21           N   
ATOM   2442  CA  ALA   298      39.126  29.259   5.742  1.00 13.97           C   
ATOM   2443  CB  ALA   298      39.188  29.834   7.104  1.00 13.65           C   
ATOM   2444  C   ALA   298      39.133  30.395   4.713  1.00 13.99           C   
ATOM   2445  O   ALA   298      38.104  31.041   4.536  1.00 16.45           O   
ATOM   2446  N   GLY   299      40.268  30.660   4.095  1.00 13.31           N   
ATOM   2447  CA  GLY   299      40.450  31.763   3.099  1.00 16.06           C   
ATOM   2448  C   GLY   299      39.931  31.332   1.754  1.00 17.23           C   
ATOM   2449  O   GLY   299      40.719  30.851   0.962  1.00 16.83           O   
ATOM   2450  N   ARG   300      38.599  31.444   1.528  1.00 19.79           N   
ATOM   2451  CA  ARG   300      37.829  30.921   0.335  1.00 16.13           C   
ATOM   2452  CB  ARG   300      37.378  29.454   0.444  1.00 21.02           C   
ATOM   2453  CG  ARG   300      38.454  28.382   0.705  1.00 23.82           C   
ATOM   2454  CD  ARG   300      39.511  28.353  -0.354  1.00 26.67           C   
ATOM   2455  NE  ARG   300      40.441  27.214  -0.278  1.00 27.75           N   
ATOM   2456  CZ  ARG   300      41.678  27.225   0.250  1.00 28.30           C   
ATOM   2457  NH1 ARG   300      42.196  28.312   0.913  1.00 22.60           N   
ATOM   2458  NH2 ARG   300      42.404  26.099   0.136  1.00 27.30           N   
ATOM   2459  C   ARG   300      36.516  31.633  -0.073  0.50 18.02           C   
ATOM   2461  O   ARG   300      35.508  31.691   0.677  0.50 16.54           O   
ATOM   2463  N   ILE   301      36.464  32.012  -1.332  1.00 14.64           N   
ATOM   2464  CA  ILE   301      35.298  32.681  -1.873  1.00 15.06           C   
ATOM   2465  CB  ILE   301      35.439  32.771  -3.399  1.00 15.02           C   
ATOM   2466  CG1 ILE   301      36.569  33.732  -3.790  1.00 16.19           C   
ATOM   2467  CD1 ILE   301      36.181  35.226  -3.742  1.00 18.24           C   
ATOM   2468  CG2 ILE   301      34.097  33.198  -4.051  1.00 17.05           C   
ATOM   2469  C   ILE   301      34.059  31.896  -1.510  1.00 16.58           C   
ATOM   2470  O   ILE   301      34.019  30.687  -1.611  1.00 18.18           O   
ATOM   2471  N   LYS   302      33.022  32.629  -1.111  1.00 17.52           N   
ATOM   2472  CA  LYS   302      31.745  32.026  -0.754  1.00 21.96           C   
ATOM   2473  CB  LYS   302      30.847  33.053  -0.045  0.55 23.98           C   
ATOM   2475  CG  LYS   302      29.600  32.442   0.587  0.55 25.45           C   
ATOM   2477  CD  LYS   302      28.979  33.347   1.636  0.55 28.47           C   
ATOM   2479  CE  LYS   302      29.814  33.425   2.904  0.55 28.23           C   
ATOM   2481  NZ  LYS   302      29.404  34.594   3.719  0.55 31.92           N   
ATOM   2483  C   LYS   302      31.050  31.444  -1.988  1.00 20.14           C   
ATOM   2484  O   LYS   302      30.937  32.121  -3.052  1.00 22.27           O   
ATOM   2485  N   LYS   303      30.635  30.196  -1.910  1.00 21.65           N   
ATOM   2486  CA  LYS   303      29.914  29.511  -2.994  1.00 25.31           C   
ATOM   2487  CB  LYS   303      30.728  28.323  -3.517  1.00 27.89           C   
ATOM   2488  CG  LYS   303      32.014  28.677  -4.199  1.00 27.82           C   
ATOM   2489  CD  LYS   303      31.730  29.202  -5.586  1.00 26.05           C   
ATOM   2490  CE  LYS   303      32.918  29.980  -6.132  1.00 27.62           C   
ATOM   2491  NZ  LYS   303      34.188  29.190  -6.121  1.00 34.22           N   
ATOM   2492  C   LYS   303      28.622  28.944  -2.453  1.00 28.49           C   
ATOM   2493  O   LYS   303      28.577  28.481  -1.300  1.00 32.29           O   
ATOM   2494  N   LYS   304      27.581  28.934  -3.285  1.00 28.06           N   
ATOM   2495  CA  LYS   304      26.296  28.289  -2.941  1.00 33.28           C   
ATOM   2496  CB  LYS   304      25.197  28.690  -3.938  1.00 29.84           C   
ATOM   2497  CG  LYS   304      24.802  30.137  -3.873  1.00 34.47           C   
ATOM   2498  CD  LYS   304      23.858  30.413  -2.720  1.00 37.84           C   
ATOM   2499  CE  LYS   304      23.879  31.889  -2.373  1.00 39.29           C   
ATOM   2500  NZ  LYS   304      23.706  32.127  -0.903  1.00 40.73           N   
ATOM   2501  C   LYS   304      26.409  26.765  -2.861  1.00 33.86           C   
ATOM   2502  O   LYS   304      27.282  26.155  -3.491  1.00 38.84           O   
END
