
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  255 ( 2071),  selected  255 , name 2h4x_A
# Molecule2: number of CA atoms  247 ( 1945),  selected  247 , name T0394.pdb
# PARAMETERS: 2h4x_A.T0394.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_A      N       1           -
LGA    -       -      L       2           -
LGA    -       -      Y       3           -
LGA    -       -      F       4           -
LGA    -       -      Q       5           -
LGA    -       -      S       6           -
LGA    -       -      A       7           -
LGA    K     3_A      R       8          4.230
LGA    Y     4_A      F       9          3.054
LGA    K     5_A      A      10          2.136
LGA    L     6_A      L      11          1.569
LGA    I     7_A      T      12          0.464
LGA    M     8_A      V      13          0.404
LGA    L     9_A      V      14          1.098
LGA    R    10_A      R      15          0.848
LGA    H    11_A      H      16          0.500
LGA    G    12_A      G      17          1.304
LGA    E    13_A      E      18          0.907
LGA    G    14_A      T      19          0.599
LGA    A    15_A      R      20          0.875
LGA    W    16_A      F      21          0.871
LGA    N    17_A      N      22          1.296
LGA    K    18_A      K      23          2.084
LGA    E    19_A      E      24          1.799
LGA    N    20_A      K      25          1.097
LGA    R    21_A      I      26          1.190
LGA    F    22_A      I      27          0.831
LGA    C    23_A      Q      28          0.714
LGA    S    24_A      G      29          0.353
LGA    W    25_A      Q      30          0.534
LGA    V    26_A      G      31          2.158
LGA    -       -      V      32           -
LGA    D    27_A      D      33          0.860
LGA    Q    28_A      E      34          0.846
LGA    K    29_A      P      35          0.655
LGA    L    30_A      L      36          0.793
LGA    N    31_A      S      37          0.672
LGA    S    32_A      E      38          0.562
LGA    E    33_A      T      39          0.671
LGA    G    34_A      G      40          0.848
LGA    M    35_A      F      41          1.088
LGA    E    36_A      K      42          1.026
LGA    E    37_A      Q      43          1.024
LGA    A    38_A      A      44          1.007
LGA    R    39_A      A      45          1.229
LGA    N    40_A      A      46          1.448
LGA    C    41_A      A      47          1.341
LGA    G    42_A      G      48          1.435
LGA    K    43_A      I      49          1.668
LGA    Q    44_A      F      50          1.627
LGA    L    45_A      L      51          1.572
LGA    K    46_A      N      52          2.267
LGA    A    47_A      -       -           -
LGA    L    48_A      -       -           -
LGA    N    49_A      N      53          2.749
LGA    F    50_A      V      54          0.781
LGA    E    51_A      K      55          0.939
LGA    F    52_A      F      56          1.215
LGA    D    53_A      T      57          1.322
LGA    L    54_A      H      58          1.173
LGA    V    55_A      A      59          0.402
LGA    F    56_A      F      60          0.464
LGA    T    57_A      S      61          0.783
LGA    S    58_A      S      62          1.079
LGA    V    59_A      D      63          0.940
LGA    L    60_A      L      64          0.658
LGA    N    61_A      M      65          1.391
LGA    R    62_A      R      66          1.063
LGA    S    63_A      T      67          0.746
LGA    I    64_A      K      68          0.922
LGA    H    65_A      Q      69          0.965
LGA    T    66_A      T      70          0.682
LGA    A    67_A      M      71          0.569
LGA    W    68_A      H      72          0.835
LGA    L    69_A      G      73          0.687
LGA    I    70_A      I      74          0.229
LGA    L    71_A      L      75          0.355
LGA    E    72_A      E      76          0.922
LGA    E    73_A      R      77          1.430
LGA    L    74_A      S      78          0.939
LGA    G    75_A      K      79          3.731
LGA    -       -      F      80           -
LGA    Q    76_A      C      81          2.179
LGA    E    77_A      K      82          2.262
LGA    W    78_A      D      83          0.869
LGA    V    79_A      M      84          0.841
LGA    P    80_A      T      85          1.720
LGA    V    81_A      V      86          0.816
LGA    E    82_A      K      87          0.374
LGA    S    83_A      Y      88          0.412
LGA    S    84_A      D      89          1.238
LGA    W    85_A      S      90          0.908
LGA    R    86_A      R      91          0.830
LGA    L    87_A      L      92          0.709
LGA    N    88_A      R      93          0.578
LGA    E    89_A      E      94          0.505
LGA    R    90_A      R      95          0.753
LGA    H    91_A      K      96          0.777
LGA    Y    92_A      Y      97          1.085
LGA    G    93_A      G      98          1.496
LGA    A    94_A      V      99          1.706
LGA    L    95_A      V     100          2.045
LGA    I    96_A      E     101          1.226
LGA    G    97_A      G     102          1.465
LGA    L    98_A      K     103          1.685
LGA    N    99_A      A     104          0.838
LGA    R   100_A      L     105          0.919
LGA    E   101_A      S     106          2.403
LGA    Q   102_A      E     107          3.765
LGA    M   103_A      L     108          3.654
LGA    A   104_A      R     109          3.410
LGA    L   105_A      A     110          5.058
LGA    N   106_A      M     111          5.941
LGA    H   107_A      A     112          4.647
LGA    G   108_A      K     113          4.137
LGA    E   109_A      A     114           -
LGA    E   110_A      A     115           -
LGA    -       -      R     116           -
LGA    Q   111_A      E     117          3.953
LGA    V   112_A      E     118          4.487
LGA    R   113_A      C     119          2.608
LGA    L   114_A      -       -           -
LGA    W   115_A      -       -           -
LGA    R   116_A      P     120          2.266
LGA    R   117_A      -       -           -
LGA    S   118_A      V     121          3.301
LGA    Y   119_A      -       -           -
LGA    N   120_A      -       -           -
LGA    V   121_A      -       -           -
LGA    T   122_A      F     122           #
LGA    P   123_A      T     123          1.590
LGA    P   124_A      P     124          2.556
LGA    P   125_A      P     125          2.674
LGA    I   126_A      G     126          2.968
LGA    E   127_A      -       -           -
LGA    E   128_A      -       -           -
LGA    S   129_A      -       -           -
LGA    H   130_A      -       -           -
LGA    P   131_A      -       -           -
LGA    Y   132_A      -       -           -
LGA    Y   133_A      -       -           -
LGA    Q   134_A      -       -           -
LGA    E   135_A      -       -           -
LGA    I   136_A      -       -           -
LGA    Y   137_A      -       -           -
LGA    N   138_A      -       -           -
LGA    D   139_A      -       -           -
LGA    R   140_A      -       -           -
LGA    R   141_A      -       -           -
LGA    Y   142_A      -       -           -
LGA    K   143_A      -       -           -
LGA    V   144_A      -       -           -
LGA    C   145_A      -       -           -
LGA    D   146_A      -       -           -
LGA    V   147_A      -       -           -
LGA    P   148_A      -       -           -
LGA    L   149_A      -       -           -
LGA    D   150_A      -       -           -
LGA    Q   151_A      -       -           -
LGA    L   152_A      -       -           -
LGA    P   153_A      -       -           -
LGA    R   154_A      -       -           -
LGA    S   155_A      G     127          2.201
LGA    E   156_A      E     128          0.854
LGA    S   157_A      T     129          0.937
LGA    L   158_A      L     130          1.778
LGA    K   159_A      D     131          0.915
LGA    D   160_A      Q     132          0.585
LGA    V   161_A      V     133          1.658
LGA    L   162_A      K     134          2.287
LGA    E   163_A      M     135          1.930
LGA    R   164_A      R     136          2.960
LGA    L   165_A      G     137          3.496
LGA    L   166_A      I     138          2.051
LGA    P   167_A      D     139          2.185
LGA    Y   168_A      F     140          2.655
LGA    W   169_A      F     141          2.191
LGA    N   170_A      E     142          1.154
LGA    E   171_A      F     143          1.968
LGA    R   172_A      L     144          3.669
LGA    I   173_A      C     145          5.074
LGA    A   174_A      Q     146          4.970
LGA    P   175_A      L     147          2.968
LGA    E   176_A      I     148          1.898
LGA    V   177_A      -       -           -
LGA    L   178_A      L     149          4.176
LGA    R   179_A      K     150           #
LGA    -       -      E     151           -
LGA    -       -      A     152           -
LGA    -       -      D     153           -
LGA    -       -      Q     154           -
LGA    -       -      K     155           -
LGA    -       -      N     165           -
LGA    -       -      C     166           -
LGA    -       -      L     167           -
LGA    -       -      E     168           -
LGA    -       -      T     169           -
LGA    -       -      S     170           -
LGA    -       -      L     171           -
LGA    -       -      A     172           -
LGA    -       -      E     173           -
LGA    -       -      I     174           -
LGA    -       -      F     175           -
LGA    -       -      P     176           -
LGA    -       -      L     177           -
LGA    -       -      I     191           -
LGA    -       -      P     192           -
LGA    -       -      G     193           -
LGA    -       -      L     194           -
LGA    G   180_A      A     195          0.813
LGA    K   181_A      A     196          1.272
LGA    T   182_A      S     197          1.190
LGA    I   183_A      V     198          0.581
LGA    L   184_A      L     199          0.167
LGA    I   185_A      V     200          0.397
LGA    S   186_A      V     201          0.518
LGA    A   187_A      S     202          0.628
LGA    H   188_A      H     203          0.584
LGA    G   189_A      G     204          0.767
LGA    N   190_A      A     205          1.520
LGA    S   191_A      Y     206          1.537
LGA    S   192_A      M     207          1.280
LGA    R   193_A      R     208          1.669
LGA    A   194_A      S     209          2.165
LGA    L   195_A      L     210          1.791
LGA    L   196_A      F     211          1.439
LGA    K   197_A      D     212          1.720
LGA    H   198_A      Y     213          1.828
LGA    L   199_A      F     214          2.142
LGA    E   200_A      L     215          2.387
LGA    G   201_A      T     216          2.756
LGA    I   202_A      D     217          5.290
LGA    S   203_A      L     218           -
LGA    D   204_A      K     219           -
LGA    E   205_A      C     220           -
LGA    -       -      S     221           -
LGA    -       -      L     222           -
LGA    -       -      P     223           -
LGA    -       -      A     224           -
LGA    -       -      T     225           -
LGA    -       -      L     226           -
LGA    -       -      S     227           -
LGA    D   206_A      R     228           #
LGA    I   207_A      -       -           -
LGA    I   208_A      -       -           -
LGA    N   209_A      S     229          4.328
LGA    -       -      E     230           -
LGA    -       -      L     231           -
LGA    I   210_A      M     232          1.151
LGA    T   211_A      S     233          2.132
LGA    L   212_A      V     234          3.284
LGA    -       -      T     235           -
LGA    P   213_A      P     236          1.638
LGA    T   214_A      N     237          1.585
LGA    G   215_A      T     238          1.045
LGA    V   216_A      G     239          1.384
LGA    P   217_A      M     240          1.431
LGA    I   218_A      S     241          1.048
LGA    L   219_A      L     242          1.233
LGA    L   220_A      F     243          1.363
LGA    E   221_A      I     244          1.948
LGA    L   222_A      I     245          2.120
LGA    D   223_A      N     246          2.066
LGA    E   224_A      F     247          1.951
LGA    N   225_A      E     248          5.548
LGA    -       -      E     249           -
LGA    -       -      G     250           -
LGA    -       -      R     251           -
LGA    -       -      E     252           -
LGA    -       -      V     253           -
LGA    -       -      K     254           -
LGA    L   226_A      P     255          2.989
LGA    R   227_A      T     256          2.587
LGA    A   228_A      V     257          1.653
LGA    V   229_A      Q     258          2.147
LGA    G   230_A      C     259          3.929
LGA    P   231_A      I     260           #
LGA    H   232_A      C     261          4.444
LGA    Q   233_A      M     262          2.631
LGA    F   234_A      N     263          3.194
LGA    -       -      L     264           -
LGA    L   235_A      Q     265           #
LGA    G   236_A      D     266          2.246
LGA    -       -      H     267           -
LGA    -       -      L     268           -
LGA    D   237_A      N     269           #
LGA    Q   238_A      -       -           -
LGA    E   239_A      -       -           -
LGA    A   240_A      -       -           -
LGA    I   241_A      -       -           -
LGA    Q   242_A      -       -           -
LGA    A   243_A      -       -           -
LGA    A   244_A      -       -           -
LGA    I   245_A      -       -           -
LGA    K   246_A      -       -           -
LGA    K   247_A      -       -           -
LGA    V   248_A      -       -           -
LGA    E   249_A      -       -           -
LGA    D   250_A      -       -           -
LGA    Q   251_A      -       -           -
LGA    G   252_A      -       -           -
LGA    K   253_A      -       -           -
LGA    V   254_A      -       -           -
LGA    K   255_A      -       -           -
LGA    Q   256_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  255  247    5.0    185    2.10    24.86     58.419     8.408

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.052024 * X  +  -0.848664 * Y  +   0.526368 * Z  +  21.651880
  Y_new =   0.696973 * X  +   0.346629 * Y  +   0.627755 * Z  + -52.476830
  Z_new =  -0.715207 * X  +   0.399523 * Y  +   0.573463 * Z  + -27.702484 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.608497   -2.533096  [ DEG:    34.8643   -145.1357 ]
  Theta =   0.796921    2.344672  [ DEG:    45.6602    134.3398 ]
  Phi   =   1.645301   -1.496292  [ DEG:    94.2688    -85.7312 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2h4x_A                                        
REMARK     2: T0394.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2h4x_A.T0394.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  255  247   5.0  185   2.10   24.86  58.419
REMARK  ---------------------------------------------------------- 
MOLECULE 2h4x_A
HEADER    ISOMERASE                               25-MAY-06   2H4X              
TITLE     HUMAN BISPHOSPHOGLYCERATE MUTASE COMPLEX WITH 3-                      
TITLE    2 PHOSPHOGLYCERATE WITH CRYSTAL GROWTH 90 DAYS                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BISPHOSPHOGLYCERATE MUTASE;                                
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: 2,3-BISPHOSPHOGLYCERATE MUTASE, ERYTHROCYTE, 2,3-           
COMPND   5 BISPHOSPHOGLYCERATE SYNTHASE, BPGM, BPG-DEPENDENT PGAM;              
COMPND   6 EC: 5.4.2.4, 5.4.2.1, 3.1.3.13;                                      
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET22B                                    
KEYWDS    BISPHOSPHOGLYCERATE MUTASE, 3-PHOSPHOGLYCERATE                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.WANG,W.GONG                                                         
REVDAT   1   24-OCT-06 2H4X    0                                                
JRNL        AUTH   Y.WANG,W.GONG                                                
JRNL        TITL   SEEING THE PROCESS OF HISTIDINE PHOSPHORYLATION IN           
JRNL        TITL 2 HUMAN BISPHOSPHOGLYCERATE MUTASE                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.85 ANGSTROMS.                                          
DBREF  2H4X A    1   259  UNP    P07738   PMGE_HUMAN       1    258             
DBREF  2H4X B    1   259  UNP    P07738   PMGE_HUMAN       1    258             
SEQRES   1 A  267  MET SER LYS TYR LYS LEU ILE MET LEU ARG HIS GLY GLU          
SEQRES   2 A  267  GLY ALA TRP ASN LYS GLU ASN ARG PHE CYS SER TRP VAL          
SEQRES   3 A  267  ASP GLN LYS LEU ASN SER GLU GLY MET GLU GLU ALA ARG          
SEQRES   4 A  267  ASN CYS GLY LYS GLN LEU LYS ALA LEU ASN PHE GLU PHE          
SEQRES   5 A  267  ASP LEU VAL PHE THR SER VAL LEU ASN ARG SER ILE HIS          
SEQRES   6 A  267  THR ALA TRP LEU ILE LEU GLU GLU LEU GLY GLN GLU TRP          
SEQRES   7 A  267  VAL PRO VAL GLU SER SER TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 A  267  TYR GLY ALA LEU ILE GLY LEU ASN ARG GLU GLN MET ALA          
SEQRES   9 A  267  LEU ASN HIS GLY GLU GLU GLN VAL ARG LEU TRP ARG ARG          
SEQRES  10 A  267  SER TYR ASN VAL THR PRO PRO PRO ILE GLU GLU SER HIS          
SEQRES  11 A  267  PRO TYR TYR GLN GLU ILE TYR ASN ASP ARG ARG TYR LYS          
SEQRES  12 A  267  VAL CYS ASP VAL PRO LEU ASP GLN LEU PRO ARG SER GLU          
SEQRES  13 A  267  SER LEU LYS ASP VAL LEU GLU ARG LEU LEU PRO TYR TRP          
SEQRES  14 A  267  ASN GLU ARG ILE ALA PRO GLU VAL LEU ARG GLY LYS THR          
SEQRES  15 A  267  ILE LEU ILE SER ALA HIS GLY ASN SER SER ARG ALA LEU          
SEQRES  16 A  267  LEU LYS HIS LEU GLU GLY ILE SER ASP GLU ASP ILE ILE          
SEQRES  17 A  267  ASN ILE THR LEU PRO THR GLY VAL PRO ILE LEU LEU GLU          
SEQRES  18 A  267  LEU ASP GLU ASN LEU ARG ALA VAL GLY PRO HIS GLN PHE          
SEQRES  19 A  267  LEU GLY ASP GLN GLU ALA ILE GLN ALA ALA ILE LYS LYS          
SEQRES  20 A  267  VAL GLU ASP GLN GLY LYS VAL LYS GLN ALA LYS LYS LEU          
SEQRES  21 A  267  GLU HIS HIS HIS HIS HIS HIS                                  
SEQRES   1 B  267  MET SER LYS TYR LYS LEU ILE MET LEU ARG HIS GLY GLU          
SEQRES   2 B  267  GLY ALA TRP ASN LYS GLU ASN ARG PHE CYS SER TRP VAL          
SEQRES   3 B  267  ASP GLN LYS LEU ASN SER GLU GLY MET GLU GLU ALA ARG          
SEQRES   4 B  267  ASN CYS GLY LYS GLN LEU LYS ALA LEU ASN PHE GLU PHE          
SEQRES   5 B  267  ASP LEU VAL PHE THR SER VAL LEU ASN ARG SER ILE HIS          
SEQRES   6 B  267  THR ALA TRP LEU ILE LEU GLU GLU LEU GLY GLN GLU TRP          
SEQRES   7 B  267  VAL PRO VAL GLU SER SER TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 B  267  TYR GLY ALA LEU ILE GLY LEU ASN ARG GLU GLN MET ALA          
SEQRES   9 B  267  LEU ASN HIS GLY GLU GLU GLN VAL ARG LEU TRP ARG ARG          
SEQRES  10 B  267  SER TYR ASN VAL THR PRO PRO PRO ILE GLU GLU SER HIS          
SEQRES  11 B  267  PRO TYR TYR GLN GLU ILE TYR ASN ASP ARG ARG TYR LYS          
SEQRES  12 B  267  VAL CYS ASP VAL PRO LEU ASP GLN LEU PRO ARG SER GLU          
SEQRES  13 B  267  SER LEU LYS ASP VAL LEU GLU ARG LEU LEU PRO TYR TRP          
SEQRES  14 B  267  ASN GLU ARG ILE ALA PRO GLU VAL LEU ARG GLY LYS THR          
SEQRES  15 B  267  ILE LEU ILE SER ALA HIS GLY ASN SER SER ARG ALA LEU          
SEQRES  16 B  267  LEU LYS HIS LEU GLU GLY ILE SER ASP GLU ASP ILE ILE          
SEQRES  17 B  267  ASN ILE THR LEU PRO THR GLY VAL PRO ILE LEU LEU GLU          
SEQRES  18 B  267  LEU ASP GLU ASN LEU ARG ALA VAL GLY PRO HIS GLN PHE          
SEQRES  19 B  267  LEU GLY ASP GLN GLU ALA ILE GLN ALA ALA ILE LYS LYS          
SEQRES  20 B  267  VAL GLU ASP GLN GLY LYS VAL LYS GLN ALA LYS LYS LEU          
SEQRES  21 B  267  GLU HIS HIS HIS HIS HIS HIS                                  
HET    3PG   1408      11                                                       
HET    3PG   2408      11                                                       
HETNAM     3PG 3-PHOSPHOGLYCERIC ACID                                           
FORMUL   3  3PG    2(C3 H7 O7 P)                                                
FORMUL   5  HOH   *698(H2 O)                                                    
CRYST1   48.498   71.362  160.162  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   SER A   2       4.578  46.063  14.435  1.00 33.84           N  
ATOM      2  CA  SER A   2       5.782  46.863  14.084  1.00 31.91           C  
ATOM      3  C   SER A   2       6.476  46.308  12.844  1.00 31.40           C  
ATOM      4  O   SER A   2       6.232  45.174  12.430  1.00 32.35           O  
ATOM      5  CB  SER A   2       6.754  46.884  15.259  1.00 32.77           C  
ATOM      6  N   LYS A   3       7.341  47.129  12.259  1.00 29.87           N  
ATOM      7  CA  LYS A   3       8.099  46.770  11.070  1.00 28.13           C  
ATOM      8  C   LYS A   3       9.588  46.835  11.383  1.00 25.69           C  
ATOM      9  O   LYS A   3      10.036  47.732  12.096  1.00 26.54           O  
ATOM     10  CB  LYS A   3       7.756  47.733   9.931  1.00 27.66           C  
ATOM     11  CG  LYS A   3       8.893  48.000   8.952  1.00 31.91           C  
ATOM     12  CD  LYS A   3       9.726  49.220   9.336  1.00 30.46           C  
ATOM     13  CE  LYS A   3      10.697  49.591   8.221  1.00 32.49           C  
ATOM     14  NZ  LYS A   3      11.304  50.954   8.368  1.00 28.14           N  
ATOM     15  N   TYR A   4      10.352  45.888  10.847  1.00 23.18           N  
ATOM     16  CA  TYR A   4      11.788  45.858  11.089  1.00 21.58           C  
ATOM     17  C   TYR A   4      12.562  45.717   9.788  1.00 21.46           C  
ATOM     18  O   TYR A   4      12.148  44.985   8.889  1.00 24.16           O  
ATOM     19  CB  TYR A   4      12.160  44.686  12.001  1.00 22.44           C  
ATOM     20  CG  TYR A   4      11.261  44.505  13.203  1.00 23.17           C  
ATOM     21  CD1 TYR A   4      10.119  43.707  13.128  1.00 24.59           C  
ATOM     22  CD2 TYR A   4      11.548  45.131  14.415  1.00 25.03           C  
ATOM     23  CE1 TYR A   4       9.288  43.535  14.231  1.00 27.26           C  
ATOM     24  CE2 TYR A   4      10.723  44.966  15.525  1.00 26.26           C  
ATOM     25  CZ  TYR A   4       9.596  44.168  15.425  1.00 26.75           C  
ATOM     26  OH  TYR A   4       8.779  44.001  16.518  1.00 28.36           O  
ATOM     27  N   LYS A   5      13.685  46.417   9.689  1.00 18.58           N  
ATOM     28  CA  LYS A   5      14.519  46.319   8.498  1.00 19.77           C  
ATOM     29  C   LYS A   5      15.887  45.759   8.853  1.00 19.59           C  
ATOM     30  O   LYS A   5      16.418  46.011   9.935  1.00 16.50           O  
ATOM     31  CB  LYS A   5      14.652  47.678   7.810  1.00 21.75           C  
ATOM     32  CG  LYS A   5      13.380  48.074   7.063  1.00 25.25           C  
ATOM     33  CD  LYS A   5      13.575  49.268   6.143  1.00 25.65           C  
ATOM     34  CE  LYS A   5      12.294  49.553   5.366  1.00 24.88           C  
ATOM     35  NZ  LYS A   5      12.433  50.697   4.424  1.00 26.13           N  
ATOM     36  N   LEU A   6      16.435  44.979   7.933  1.00 19.44           N  
ATOM     37  CA  LEU A   6      17.727  44.348   8.117  1.00 19.68           C  
ATOM     38  C   LEU A   6      18.503  44.409   6.811  1.00 18.15           C  
ATOM     39  O   LEU A   6      17.914  44.536   5.737  1.00 16.24           O  
ATOM     40  CB  LEU A   6      17.512  42.892   8.543  1.00 24.70           C  
ATOM     41  CG  LEU A   6      18.495  41.776   8.173  1.00 28.10           C  
ATOM     42  CD1 LEU A   6      18.097  40.515   8.910  1.00 27.96           C  
ATOM     43  CD2 LEU A   6      18.489  41.520   6.671  1.00 29.52           C  
ATOM     44  N   ILE A   7      19.822  44.307   6.914  1.00 14.26           N  
ATOM     45  CA  ILE A   7      20.685  44.320   5.742  1.00 14.10           C  
ATOM     46  C   ILE A   7      21.495  43.032   5.684  1.00 13.39           C  
ATOM     47  O   ILE A   7      22.065  42.598   6.685  1.00 13.16           O  
ATOM     48  CB  ILE A   7      21.696  45.490   5.774  1.00 14.94           C  
ATOM     49  CG1 ILE A   7      20.965  46.834   5.745  1.00 15.73           C  
ATOM     50  CG2 ILE A   7      22.659  45.373   4.589  1.00 15.10           C  
ATOM     51  CD1 ILE A   7      20.202  47.092   4.457  1.00 18.81           C  
ATOM     52  N   MET A   8      21.514  42.409   4.515  1.00 13.16           N  
ATOM     53  CA  MET A   8      22.318  41.216   4.312  1.00 14.40           C  
ATOM     54  C   MET A   8      22.974  41.412   2.957  1.00 13.90           C  
ATOM     55  O   MET A   8      22.488  42.183   2.130  1.00 14.37           O  
ATOM     56  CB  MET A   8      21.469  39.936   4.333  1.00 17.13           C  
ATOM     57  CG  MET A   8      20.539  39.721   3.163  1.00 19.76           C  
ATOM     58  SD  MET A   8      19.777  38.065   3.266  1.00 25.48           S  
ATOM     59  CE  MET A   8      18.554  38.366   4.492  1.00 15.07           C  
ATOM     60  N   LEU A   9      24.097  40.749   2.739  1.00 13.75           N  
ATOM     61  CA  LEU A   9      24.789  40.871   1.470  1.00 13.72           C  
ATOM     62  C   LEU A   9      25.793  39.756   1.337  1.00 14.37           C  
ATOM     63  O   LEU A   9      26.138  39.107   2.324  1.00 11.84           O  
ATOM     64  CB  LEU A   9      25.506  42.227   1.383  1.00 14.31           C  
ATOM     65  CG  LEU A   9      26.482  42.635   2.500  1.00 16.21           C  
ATOM     66  CD1 LEU A   9      27.829  41.949   2.319  1.00 15.69           C  
ATOM     67  CD2 LEU A   9      26.673  44.149   2.468  1.00 19.90           C  
ATOM     68  N   ARG A  10      26.229  39.507   0.109  1.00 13.23           N  
ATOM     69  CA  ARG A  10      27.254  38.505  -0.116  1.00 14.67           C  
ATOM     70  C   ARG A  10      28.485  39.331  -0.465  1.00 14.30           C  
ATOM     71  O   ARG A  10      28.384  40.386  -1.108  1.00 15.04           O  
ATOM     72  CB  ARG A  10      26.870  37.542  -1.251  1.00 15.82           C  
ATOM     73  CG  ARG A  10      26.683  38.166  -2.614  1.00 18.09           C  
ATOM     74  CD  ARG A  10      26.290  37.106  -3.650  1.00 16.71           C  
ATOM     75  NE  ARG A  10      27.315  36.073  -3.798  1.00 15.00           N  
ATOM     76  CZ  ARG A  10      27.349  35.184  -4.790  1.00 16.43           C  
ATOM     77  NH1 ARG A  10      26.412  35.194  -5.732  1.00 16.18           N  
ATOM     78  NH2 ARG A  10      28.323  34.287  -4.846  1.00 13.69           N  
ATOM     79  N   HIS A  11      29.638  38.870  -0.001  1.00 13.56           N  
ATOM     80  CA  HIS A  11      30.902  39.558  -0.221  1.00 14.15           C  
ATOM     81  C   HIS A  11      31.228  39.751  -1.693  1.00 14.82           C  
ATOM     82  O   HIS A  11      30.552  39.215  -2.583  1.00 12.64           O  
ATOM     83  CB  HIS A  11      32.025  38.771   0.444  1.00 14.06           C  
ATOM     84  CG  HIS A  11      32.108  37.352  -0.020  1.00 14.53           C  
ATOM     85  ND1 HIS A  11      32.646  37.001  -1.241  1.00 12.52           N  
ATOM     86  CD2 HIS A  11      31.641  36.207   0.531  1.00 13.26           C  
ATOM     87  CE1 HIS A  11      32.502  35.700  -1.423  1.00 14.72           C  
ATOM     88  NE2 HIS A  11      31.894  35.195  -0.364  1.00 11.78           N  
ATOM     89  N   GLY A  12      32.278  40.523  -1.932  1.00 15.68           N  
ATOM     90  CA  GLY A  12      32.714  40.794  -3.282  1.00 17.39           C  
ATOM     91  C   GLY A  12      33.531  39.665  -3.874  1.00 18.73           C  
ATOM     92  O   GLY A  12      33.681  38.587  -3.294  1.00 15.82           O  
ATOM     93  N   GLU A  13      34.080  39.949  -5.043  1.00 18.26           N  
ATOM     94  CA  GLU A  13      34.879  39.016  -5.815  1.00 21.74           C  
ATOM     95  C   GLU A  13      36.172  38.505  -5.174  1.00 20.25           C  
ATOM     96  O   GLU A  13      36.770  39.157  -4.315  1.00 17.56           O  
ATOM     97  CB  GLU A  13      35.198  39.687  -7.144  1.00 24.33           C  
ATOM     98  CG  GLU A  13      36.035  38.898  -8.091  1.00 30.78           C  
ATOM     99  CD  GLU A  13      36.508  39.765  -9.229  1.00 30.24           C  
ATOM    100  OE1 GLU A  13      35.649  40.414  -9.866  1.00 31.87           O  
ATOM    101  OE2 GLU A  13      37.731  39.801  -9.476  1.00 29.93           O  
ATOM    102  N   GLY A  14      36.578  37.317  -5.618  1.00 20.08           N  
ATOM    103  CA  GLY A  14      37.804  36.680  -5.167  1.00 18.78           C  
ATOM    104  C   GLY A  14      38.472  36.153  -6.429  1.00 19.19           C  
ATOM    105  O   GLY A  14      37.896  36.266  -7.506  1.00 18.10           O  
ATOM    106  N   ALA A  15      39.664  35.574  -6.319  1.00 20.16           N  
ATOM    107  CA  ALA A  15      40.365  35.063  -7.497  1.00 20.32           C  
ATOM    108  C   ALA A  15      39.555  34.060  -8.318  1.00 20.97           C  
ATOM    109  O   ALA A  15      39.503  34.151  -9.546  1.00 20.66           O  
ATOM    110  CB  ALA A  15      41.697  34.434  -7.081  1.00 20.38           C  
ATOM    111  N   TRP A  16      38.916  33.107  -7.649  1.00 20.57           N  
ATOM    112  CA  TRP A  16      38.147  32.099  -8.364  1.00 22.40           C  
ATOM    113  C   TRP A  16      36.912  32.617  -9.099  1.00 23.62           C  
ATOM    114  O   TRP A  16      36.338  31.906  -9.917  1.00 23.64           O  
ATOM    115  CB  TRP A  16      37.775  30.958  -7.413  1.00 23.13           C  
ATOM    116  CG  TRP A  16      38.953  30.063  -7.093  1.00 23.24           C  
ATOM    117  CD1 TRP A  16      40.265  30.283  -7.420  1.00 23.23           C  
ATOM    118  CD2 TRP A  16      38.924  28.821  -6.379  1.00 23.49           C  
ATOM    119  NE1 TRP A  16      41.050  29.257  -6.955  1.00 24.91           N  
ATOM    120  CE2 TRP A  16      40.254  28.346  -6.311  1.00 23.74           C  
ATOM    121  CE3 TRP A  16      37.905  28.062  -5.788  1.00 22.34           C  
ATOM    122  CZ2 TRP A  16      40.590  27.146  -5.675  1.00 23.50           C  
ATOM    123  CZ3 TRP A  16      38.239  26.872  -5.158  1.00 21.70           C  
ATOM    124  CH2 TRP A  16      39.571  26.425  -5.107  1.00 23.11           C  
ATOM    125  N   ASN A  17      36.508  33.854  -8.819  1.00 25.82           N  
ATOM    126  CA  ASN A  17      35.345  34.431  -9.489  1.00 26.69           C  
ATOM    127  C   ASN A  17      35.606  34.577 -10.984  1.00 27.13           C  
ATOM    128  O   ASN A  17      34.811  34.122 -11.806  1.00 26.96           O  
ATOM    129  CB  ASN A  17      35.003  35.797  -8.887  1.00 29.56           C  
ATOM    130  CG  ASN A  17      34.151  35.687  -7.635  1.00 28.98           C  
ATOM    131  OD1 ASN A  17      34.664  35.475  -6.535  1.00 32.12           O  
ATOM    132  ND2 ASN A  17      32.844  35.848  -7.794  1.00 28.97           N  
ATOM    133  N   LYS A  18      36.722  35.210 -11.334  1.00 25.87           N  
ATOM    134  CA  LYS A  18      37.086  35.398 -12.737  1.00 26.43           C  
ATOM    135  C   LYS A  18      37.421  34.052 -13.371  1.00 24.90           C  
ATOM    136  O   LYS A  18      37.202  33.843 -14.567  1.00 26.12           O  
ATOM    137  CB  LYS A  18      38.280  36.345 -12.850  1.00 26.43           C  
ATOM    138  N   GLU A  19      37.963  33.143 -12.565  1.00 22.40           N  
ATOM    139  CA  GLU A  19      38.317  31.808 -13.038  1.00 21.27           C  
ATOM    140  C   GLU A  19      37.061  30.949 -13.206  1.00 19.23           C  
ATOM    141  O   GLU A  19      37.101  29.897 -13.844  1.00 17.51           O  
ATOM    142  CB  GLU A  19      39.264  31.125 -12.045  1.00 21.56           C  
ATOM    143  CG  GLU A  19      40.691  31.655 -12.046  1.00 25.94           C  
ATOM    144  CD  GLU A  19      41.557  30.975 -10.997  1.00 27.20           C  
ATOM    145  OE1 GLU A  19      41.546  29.727 -10.931  1.00 28.17           O  
ATOM    146  OE2 GLU A  19      42.252  31.685 -10.238  1.00 29.10           O  
ATOM    147  N   ASN A  20      35.955  31.401 -12.622  1.00 17.36           N  
ATOM    148  CA  ASN A  20      34.678  30.687 -12.694  1.00 15.94           C  
ATOM    149  C   ASN A  20      34.740  29.306 -12.043  1.00 14.67           C  
ATOM    150  O   ASN A  20      34.307  28.317 -12.629  1.00 13.74           O  
ATOM    151  CB  ASN A  20      34.211  30.554 -14.156  1.00 14.78           C  
ATOM    152  CG  ASN A  20      32.755  30.092 -14.273  1.00 15.67           C  
ATOM    153  OD1 ASN A  20      32.002  30.110 -13.298  1.00 12.81           O  
ATOM    154  ND2 ASN A  20      32.355  29.690 -15.475  1.00 13.30           N  
ATOM    155  N   ARG A  21      35.277  29.248 -10.828  1.00 13.90           N  
ATOM    156  CA  ARG A  21      35.367  27.992 -10.092  1.00 15.02           C  
ATOM    157  C   ARG A  21      34.592  28.031  -8.778  1.00 13.69           C  
ATOM    158  O   ARG A  21      34.628  29.028  -8.054  1.00 13.14           O  
ATOM    159  CB  ARG A  21      36.826  27.644  -9.802  1.00 16.02           C  
ATOM    160  CG  ARG A  21      37.614  27.259 -11.045  1.00 20.09           C  
ATOM    161  CD  ARG A  21      38.786  26.366 -10.681  1.00 26.49           C  
ATOM    162  NE  ARG A  21      39.897  27.094 -10.095  1.00 27.42           N  
ATOM    163  CZ  ARG A  21      40.862  26.536  -9.372  1.00 29.83           C  
ATOM    164  NH1 ARG A  21      40.851  25.232  -9.129  1.00 30.01           N  
ATOM    165  NH2 ARG A  21      41.853  27.281  -8.908  1.00 28.59           N  
ATOM    166  N   PHE A  22      33.878  26.950  -8.479  1.00 13.75           N  
ATOM    167  CA  PHE A  22      33.128  26.873  -7.230  1.00 14.88           C  
ATOM    168  C   PHE A  22      34.142  27.036  -6.097  1.00 14.98           C  
ATOM    169  O   PHE A  22      35.145  26.323  -6.054  1.00 15.95           O  
ATOM    170  CB  PHE A  22      32.437  25.513  -7.094  1.00 14.00           C  
ATOM    171  CG  PHE A  22      31.354  25.267  -8.111  1.00 16.06           C  
ATOM    172  CD1 PHE A  22      30.176  26.006  -8.087  1.00 16.56           C  
ATOM    173  CD2 PHE A  22      31.509  24.282  -9.084  1.00 15.90           C  
ATOM    174  CE1 PHE A  22      29.158  25.767  -9.022  1.00 17.50           C  
ATOM    175  CE2 PHE A  22      30.505  24.034 -10.020  1.00 16.77           C  
ATOM    176  CZ  PHE A  22      29.326  24.778  -9.988  1.00 17.36           C  
ATOM    177  N   CYS A  23      33.884  27.968  -5.186  1.00 14.73           N  
ATOM    178  CA  CYS A  23      34.796  28.204  -4.067  1.00 14.14           C  
ATOM    179  C   CYS A  23      34.247  27.559  -2.795  1.00 13.54           C  
ATOM    180  O   CYS A  23      34.934  26.781  -2.134  1.00 11.03           O  
ATOM    181  CB  CYS A  23      34.997  29.698  -3.853  1.00 14.86           C  
ATOM    182  SG  CYS A  23      36.229  30.063  -2.593  1.00 17.52           S  
ATOM    183  N   SER A  24      33.015  27.905  -2.440  1.00 12.83           N  
ATOM    184  CA  SER A  24      32.364  27.292  -1.281  1.00 12.67           C  
ATOM    185  C   SER A  24      33.175  27.388   0.021  1.00 13.36           C  
ATOM    186  O   SER A  24      33.590  28.476   0.429  1.00 11.61           O  
ATOM    187  CB  SER A  24      32.053  25.824  -1.634  1.00 11.96           C  
ATOM    188  OG  SER A  24      31.265  25.165  -0.656  1.00 12.04           O  
ATOM    189  N   TRP A  25      33.421  26.249   0.665  1.00 13.87           N  
ATOM    190  CA  TRP A  25      34.156  26.244   1.929  1.00 14.69           C  
ATOM    191  C   TRP A  25      35.663  26.501   1.865  1.00 14.37           C  
ATOM    192  O   TRP A  25      36.321  26.576   2.902  1.00 13.61           O  
ATOM    193  CB  TRP A  25      33.869  24.944   2.691  1.00 12.80           C  
ATOM    194  CG  TRP A  25      32.529  24.945   3.373  1.00 13.13           C  
ATOM    195  CD1 TRP A  25      31.349  25.433   2.873  1.00 11.22           C  
ATOM    196  CD2 TRP A  25      32.219  24.391   4.658  1.00 11.30           C  
ATOM    197  NE1 TRP A  25      30.329  25.211   3.768  1.00 12.00           N  
ATOM    198  CE2 TRP A  25      30.836  24.573   4.870  1.00 12.63           C  
ATOM    199  CE3 TRP A  25      32.980  23.757   5.650  1.00 13.82           C  
ATOM    200  CZ2 TRP A  25      30.192  24.141   6.038  1.00 11.82           C  
ATOM    201  CZ3 TRP A  25      32.340  23.327   6.811  1.00 12.36           C  
ATOM    202  CH2 TRP A  25      30.960  23.522   6.992  1.00 13.65           C  
ATOM    203  N   VAL A  26      36.226  26.626   0.668  1.00 13.37           N  
ATOM    204  CA  VAL A  26      37.649  26.940   0.577  1.00 13.90           C  
ATOM    205  C   VAL A  26      37.752  28.366   1.128  1.00 14.69           C  
ATOM    206  O   VAL A  26      37.043  29.262   0.671  1.00 14.78           O  
ATOM    207  CB  VAL A  26      38.154  26.904  -0.881  1.00 14.13           C  
ATOM    208  CG1 VAL A  26      39.598  27.381  -0.943  1.00 14.67           C  
ATOM    209  CG2 VAL A  26      38.059  25.486  -1.426  1.00 14.98           C  
ATOM    210  N   ASP A  27      38.622  28.577   2.111  1.00 13.58           N  
ATOM    211  CA  ASP A  27      38.748  29.895   2.739  1.00 13.12           C  
ATOM    212  C   ASP A  27      39.522  30.928   1.916  1.00 12.79           C  
ATOM    213  O   ASP A  27      40.496  31.501   2.392  1.00 12.45           O  
ATOM    214  CB  ASP A  27      39.407  29.738   4.112  1.00 12.81           C  
ATOM    215  CG  ASP A  27      39.219  30.955   4.994  1.00 13.65           C  
ATOM    216  OD1 ASP A  27      40.079  31.185   5.867  1.00 13.53           O  
ATOM    217  OD2 ASP A  27      38.209  31.672   4.824  1.00 11.66           O  
ATOM    218  N   GLN A  28      39.074  31.183   0.690  1.00 13.92           N  
ATOM    219  CA  GLN A  28      39.754  32.144  -0.176  1.00 14.13           C  
ATOM    220  C   GLN A  28      39.517  33.582   0.270  1.00 14.27           C  
ATOM    221  O   GLN A  28      38.425  33.926   0.706  1.00 14.39           O  
ATOM    222  CB  GLN A  28      39.282  31.982  -1.621  1.00 15.49           C  
ATOM    223  CG  GLN A  28      40.141  32.708  -2.638  1.00 20.07           C  
ATOM    224  CD  GLN A  28      39.730  32.407  -4.070  1.00 21.52           C  
ATOM    225  OE1 GLN A  28      38.792  33.000  -4.601  1.00 22.20           O  
ATOM    226  NE2 GLN A  28      40.426  31.467  -4.695  1.00 24.01           N  
ATOM    227  N   LYS A  29      40.548  34.414   0.160  1.00 13.70           N  
ATOM    228  CA  LYS A  29      40.440  35.817   0.536  1.00 13.67           C  
ATOM    229  C   LYS A  29      39.864  36.641  -0.610  1.00 13.26           C  
ATOM    230  O   LYS A  29      39.878  36.220  -1.766  1.00 12.38           O  
ATOM    231  CB  LYS A  29      41.813  36.397   0.890  1.00 14.22           C  
ATOM    232  CG  LYS A  29      42.419  35.898   2.188  1.00 17.67           C  
ATOM    233  CD  LYS A  29      43.630  36.751   2.557  1.00 22.78           C  
ATOM    234  CE  LYS A  29      44.233  36.329   3.884  1.00 23.42           C  
ATOM    235  NZ  LYS A  29      45.344  37.238   4.283  1.00 26.36           N  
ATOM    236  N   LEU A  30      39.347  37.816  -0.274  1.00 13.10           N  
ATOM    237  CA  LEU A  30      38.818  38.725  -1.283  1.00 14.70           C  
ATOM    238  C   LEU A  30      40.041  39.223  -2.045  1.00 14.66           C  
ATOM    239  O   LEU A  30      41.157  39.168  -1.523  1.00 15.22           O  
ATOM    240  CB  LEU A  30      38.162  39.940  -0.617  1.00 14.16           C  
ATOM    241  CG  LEU A  30      36.973  39.744   0.324  1.00 11.64           C  
ATOM    242  CD1 LEU A  30      36.783  40.992   1.172  1.00 14.40           C  
ATOM    243  CD2 LEU A  30      35.724  39.442  -0.486  1.00 11.29           C  
ATOM    244  N   ASN A  31      39.851  39.685  -3.274  1.00 15.92           N  
ATOM    245  CA  ASN A  31      40.975  40.252  -4.005  1.00 16.27           C  
ATOM    246  C   ASN A  31      40.752  41.762  -3.950  1.00 17.75           C  
ATOM    247  O   ASN A  31      39.828  42.225  -3.277  1.00 15.56           O  
ATOM    248  CB  ASN A  31      41.044  39.749  -5.458  1.00 17.05           C  
ATOM    249  CG  ASN A  31      39.776  40.012  -6.244  1.00 17.51           C  
ATOM    250  OD1 ASN A  31      38.984  40.889  -5.907  1.00 16.23           O  
ATOM    251  ND2 ASN A  31      39.590  39.254  -7.323  1.00 18.35           N  
ATOM    252  N   SER A  32      41.590  42.531  -4.634  1.00 17.83           N  
ATOM    253  CA  SER A  32      41.452  43.981  -4.615  1.00 19.92           C  
ATOM    254  C   SER A  32      40.034  44.437  -4.945  1.00 19.74           C  
ATOM    255  O   SER A  32      39.458  45.264  -4.236  1.00 18.64           O  
ATOM    256  CB  SER A  32      42.445  44.616  -5.590  1.00 21.30           C  
ATOM    257  OG  SER A  32      43.772  44.412  -5.137  1.00 26.42           O  
ATOM    258  N   GLU A  33      39.478  43.891  -6.021  1.00 18.34           N  
ATOM    259  CA  GLU A  33      38.130  44.245  -6.445  1.00 20.06           C  
ATOM    260  C   GLU A  33      37.088  43.910  -5.383  1.00 17.91           C  
ATOM    261  O   GLU A  33      36.177  44.701  -5.136  1.00 15.47           O  
ATOM    262  CB  GLU A  33      37.796  43.532  -7.757  1.00 23.85           C  
ATOM    263  CG  GLU A  33      38.609  44.050  -8.939  1.00 31.58           C  
ATOM    264  CD  GLU A  33      38.517  43.154 -10.162  1.00 35.68           C  
ATOM    265  OE1 GLU A  33      38.980  41.992 -10.089  1.00 37.95           O  
ATOM    266  OE2 GLU A  33      37.985  43.613 -11.198  1.00 38.16           O  
ATOM    267  N   GLY A  34      37.227  42.743  -4.756  1.00 14.04           N  
ATOM    268  CA  GLY A  34      36.286  42.337  -3.726  1.00 13.91           C  
ATOM    269  C   GLY A  34      36.328  43.262  -2.523  1.00 14.14           C  
ATOM    270  O   GLY A  34      35.304  43.531  -1.897  1.00 14.83           O  
ATOM    271  N   MET A  35      37.520  43.739  -2.185  1.00 14.48           N  
ATOM    272  CA  MET A  35      37.668  44.654  -1.061  1.00 14.94           C  
ATOM    273  C   MET A  35      36.974  45.971  -1.406  1.00 15.30           C  
ATOM    274  O   MET A  35      36.258  46.547  -0.587  1.00 13.83           O  
ATOM    275  CB  MET A  35      39.151  44.900  -0.771  1.00 16.63           C  
ATOM    276  CG  MET A  35      39.872  43.690  -0.193  1.00 19.30           C  
ATOM    277  SD  MET A  35      41.663  43.939  -0.132  1.00 25.64           S  
ATOM    278  CE  MET A  35      42.248  42.333  -0.666  1.00 25.78           C  
ATOM    279  N   GLU A  36      37.179  46.439  -2.632  1.00 15.07           N  
ATOM    280  CA  GLU A  36      36.558  47.682  -3.067  1.00 16.80           C  
ATOM    281  C   GLU A  36      35.035  47.554  -3.033  1.00 15.01           C  
ATOM    282  O   GLU A  36      34.335  48.498  -2.671  1.00 15.19           O  
ATOM    283  CB  GLU A  36      37.024  48.040  -4.477  1.00 19.00           C  
ATOM    284  CG  GLU A  36      36.802  49.495  -4.853  1.00 25.58           C  
ATOM    285  CD  GLU A  36      37.431  50.459  -3.858  1.00 27.31           C  
ATOM    286  OE1 GLU A  36      38.563  50.198  -3.396  1.00 30.50           O  
ATOM    287  OE2 GLU A  36      36.798  51.487  -3.543  1.00 31.78           O  
ATOM    288  N   GLU A  37      34.519  46.389  -3.414  1.00 15.59           N  
ATOM    289  CA  GLU A  37      33.076  46.168  -3.398  1.00 16.00           C  
ATOM    290  C   GLU A  37      32.543  46.346  -1.977  1.00 15.92           C  
ATOM    291  O   GLU A  37      31.459  46.897  -1.771  1.00 14.36           O  
ATOM    292  CB  GLU A  37      32.740  44.758  -3.888  1.00 17.92           C  
ATOM    293  CG  GLU A  37      32.761  44.576  -5.398  1.00 17.55           C  
ATOM    294  CD  GLU A  37      32.408  43.153  -5.804  1.00 18.67           C  
ATOM    295  OE1 GLU A  37      33.332  42.335  -5.974  1.00 18.70           O  
ATOM    296  OE2 GLU A  37      31.203  42.849  -5.938  1.00 18.98           O  
ATOM    297  N   ALA A  38      33.306  45.865  -0.999  1.00 13.70           N  
ATOM    298  CA  ALA A  38      32.906  45.983   0.400  1.00 14.50           C  
ATOM    299  C   ALA A  38      32.861  47.454   0.790  1.00 13.72           C  
ATOM    300  O   ALA A  38      31.904  47.915   1.418  1.00 12.76           O  
ATOM    301  CB  ALA A  38      33.890  45.229   1.300  1.00 13.01           C  
ATOM    302  N   ARG A  39      33.899  48.195   0.419  1.00 15.30           N  
ATOM    303  CA  ARG A  39      33.949  49.614   0.745  1.00 15.68           C  
ATOM    304  C   ARG A  39      32.770  50.346   0.104  1.00 15.50           C  
ATOM    305  O   ARG A  39      32.214  51.269   0.700  1.00 15.22           O  
ATOM    306  CB  ARG A  39      35.273  50.236   0.284  1.00 16.61           C  
ATOM    307  CG  ARG A  39      36.506  49.643   0.960  1.00 18.68           C  
ATOM    308  CD  ARG A  39      37.742  50.511   0.756  1.00 23.77           C  
ATOM    309  NE  ARG A  39      38.965  49.803   1.133  1.00 26.52           N  
ATOM    310  CZ  ARG A  39      39.636  48.986   0.324  1.00 30.58           C  
ATOM    311  NH1 ARG A  39      39.210  48.779  -0.917  1.00 30.29           N  
ATOM    312  NH2 ARG A  39      40.724  48.361   0.757  1.00 30.36           N  
ATOM    313  N   ASN A  40      32.388  49.933  -1.101  1.00 14.54           N  
ATOM    314  CA  ASN A  40      31.259  50.564  -1.776  1.00 16.75           C  
ATOM    315  C   ASN A  40      29.979  50.337  -0.981  1.00 15.69           C  
ATOM    316  O   ASN A  40      29.176  51.256  -0.812  1.00 15.23           O  
ATOM    317  CB  ASN A  40      31.094  50.020  -3.196  1.00 18.56           C  
ATOM    318  CG  ASN A  40      32.190  50.495  -4.125  1.00 21.70           C  
ATOM    319  OD1 ASN A  40      32.712  51.594  -3.964  1.00 23.71           O  
ATOM    320  ND2 ASN A  40      32.534  49.677  -5.109  1.00 24.45           N  
ATOM    321  N   CYS A  41      29.795  49.115  -0.488  1.00 12.68           N  
ATOM    322  CA  CYS A  41      28.618  48.800   0.310  1.00 12.92           C  
ATOM    323  C   CYS A  41      28.614  49.656   1.573  1.00 13.52           C  
ATOM    324  O   CYS A  41      27.569  50.144   1.999  1.00 11.85           O  
ATOM    325  CB  CYS A  41      28.599  47.316   0.689  1.00 12.48           C  
ATOM    326  SG  CYS A  41      28.250  46.193  -0.682  1.00 15.19           S  
ATOM    327  N   GLY A  42      29.786  49.835   2.171  1.00 13.59           N  
ATOM    328  CA  GLY A  42      29.876  50.647   3.372  1.00 13.05           C  
ATOM    329  C   GLY A  42      29.467  52.080   3.093  1.00 13.94           C  
ATOM    330  O   GLY A  42      28.765  52.701   3.887  1.00 12.13           O  
ATOM    331  N   LYS A  43      29.906  52.611   1.955  1.00 14.15           N  
ATOM    332  CA  LYS A  43      29.582  53.985   1.581  1.00 15.38           C  
ATOM    333  C   LYS A  43      28.089  54.175   1.355  1.00 15.44           C  
ATOM    334  O   LYS A  43      27.534  55.220   1.699  1.00 16.83           O  
ATOM    335  CB  LYS A  43      30.359  54.387   0.329  1.00 16.00           C  
ATOM    336  CG  LYS A  43      31.865  54.416   0.551  1.00 20.59           C  
ATOM    337  CD  LYS A  43      32.625  54.716  -0.731  1.00 24.44           C  
ATOM    338  CE  LYS A  43      34.123  54.725  -0.478  1.00 28.48           C  
ATOM    339  NZ  LYS A  43      34.891  54.982  -1.726  1.00 32.83           N  
ATOM    340  N   GLN A  44      27.437  53.171   0.777  1.00 14.98           N  
ATOM    341  CA  GLN A  44      26.001  53.247   0.536  1.00 14.25           C  
ATOM    342  C   GLN A  44      25.269  53.254   1.872  1.00 14.86           C  
ATOM    343  O   GLN A  44      24.351  54.048   2.095  1.00 14.61           O  
ATOM    344  CB  GLN A  44      25.529  52.050  -0.290  1.00 15.47           C  
ATOM    345  CG  GLN A  44      26.011  52.046  -1.730  1.00 17.26           C  
ATOM    346  CD  GLN A  44      25.616  50.780  -2.455  1.00 20.06           C  
ATOM    347  OE1 GLN A  44      26.029  49.681  -2.081  1.00 19.10           O  
ATOM    348  NE2 GLN A  44      24.808  50.924  -3.498  1.00 21.37           N  
ATOM    349  N   LEU A  45      25.686  52.363   2.765  1.00 12.85           N  
ATOM    350  CA  LEU A  45      25.062  52.268   4.074  1.00 13.65           C  
ATOM    351  C   LEU A  45      25.292  53.538   4.880  1.00 14.84           C  
ATOM    352  O   LEU A  45      24.412  53.961   5.636  1.00 15.64           O  
ATOM    353  CB  LEU A  45      25.589  51.036   4.818  1.00 13.80           C  
ATOM    354  CG  LEU A  45      25.182  49.713   4.148  1.00 14.10           C  
ATOM    355  CD1 LEU A  45      25.890  48.534   4.803  1.00 14.06           C  
ATOM    356  CD2 LEU A  45      23.668  49.546   4.241  1.00 14.16           C  
ATOM    357  N   LYS A  46      26.461  54.157   4.718  1.00 13.65           N  
ATOM    358  CA  LYS A  46      26.743  55.398   5.434  1.00 14.67           C  
ATOM    359  C   LYS A  46      25.780  56.473   4.928  1.00 15.48           C  
ATOM    360  O   LYS A  46      25.233  57.247   5.709  1.00 15.08           O  
ATOM    361  CB  LYS A  46      28.194  55.856   5.215  1.00 15.50           C  
ATOM    362  CG  LYS A  46      28.499  57.187   5.905  1.00 17.34           C  
ATOM    363  CD  LYS A  46      29.962  57.585   5.825  1.00 21.49           C  
ATOM    364  CE  LYS A  46      30.192  58.898   6.575  1.00 24.41           C  
ATOM    365  NZ  LYS A  46      31.627  59.305   6.608  1.00 29.12           N  
ATOM    366  N   ALA A  47      25.576  56.504   3.615  1.00 16.82           N  
ATOM    367  CA  ALA A  47      24.665  57.463   2.994  1.00 17.41           C  
ATOM    368  C   ALA A  47      23.265  57.362   3.612  1.00 17.95           C  
ATOM    369  O   ALA A  47      22.606  58.373   3.846  1.00 16.89           O  
ATOM    370  CB  ALA A  47      24.594  57.209   1.495  1.00 15.96           C  
ATOM    371  N   LEU A  48      22.823  56.136   3.880  1.00 15.26           N  
ATOM    372  CA  LEU A  48      21.513  55.894   4.474  1.00 15.14           C  
ATOM    373  C   LEU A  48      21.555  56.067   5.988  1.00 14.69           C  
ATOM    374  O   LEU A  48      20.566  55.821   6.684  1.00 14.79           O  
ATOM    375  CB  LEU A  48      21.034  54.486   4.114  1.00 15.01           C  
ATOM    376  CG  LEU A  48      20.793  54.307   2.610  1.00 16.41           C  
ATOM    377  CD1 LEU A  48      20.496  52.855   2.294  1.00 15.91           C  
ATOM    378  CD2 LEU A  48      19.633  55.195   2.175  1.00 13.36           C  
ATOM    379  N   ASN A  49      22.714  56.493   6.479  1.00 14.61           N  
ATOM    380  CA  ASN A  49      22.944  56.739   7.897  1.00 16.44           C  
ATOM    381  C   ASN A  49      22.689  55.524   8.781  1.00 16.52           C  
ATOM    382  O   ASN A  49      22.145  55.646   9.880  1.00 16.56           O  
ATOM    383  CB  ASN A  49      22.075  57.909   8.357  0.50 16.59           C  
ATOM    385  CG  ASN A  49      22.420  59.196   7.644  0.50 16.99           C  
ATOM    387  OD1 ASN A  49      23.538  59.701   7.757  0.50 16.78           O  
ATOM    389  ND2 ASN A  49      21.462  59.732   6.894  0.50 18.43           N  
ATOM    391  N   PHE A  50      23.074  54.349   8.302  1.00 14.90           N  
ATOM    392  CA  PHE A  50      22.890  53.146   9.097  1.00 15.91           C  
ATOM    393  C   PHE A  50      23.781  53.186  10.329  1.00 14.98           C  
ATOM    394  O   PHE A  50      24.937  53.602  10.262  1.00 15.50           O  
ATOM    395  CB  PHE A  50      23.217  51.884   8.288  1.00 16.42           C  
ATOM    396  CG  PHE A  50      22.016  51.243   7.661  1.00 18.42           C  
ATOM    397  CD1 PHE A  50      21.525  51.699   6.443  1.00 18.06           C  
ATOM    398  CD2 PHE A  50      21.330  50.229   8.323  1.00 19.02           C  
ATOM    399  CE1 PHE A  50      20.365  51.158   5.895  1.00 17.31           C  
ATOM    400  CE2 PHE A  50      20.166  49.680   7.782  1.00 20.73           C  
ATOM    401  CZ  PHE A  50      19.682  50.148   6.565  1.00 18.81           C  
ATOM    402  N   GLU A  51      23.218  52.758  11.452  1.00 13.50           N  
ATOM    403  CA  GLU A  51      23.932  52.689  12.715  1.00 14.55           C  
ATOM    404  C   GLU A  51      23.703  51.274  13.226  1.00 14.76           C  
ATOM    405  O   GLU A  51      22.725  50.996  13.916  1.00 14.17           O  
ATOM    406  CB  GLU A  51      23.385  53.730  13.701  1.00 16.49           C  
ATOM    407  CG  GLU A  51      23.878  55.140  13.399  1.00 19.63           C  
ATOM    408  CD  GLU A  51      23.386  56.186  14.388  1.00 21.41           C  
ATOM    409  OE1 GLU A  51      23.934  57.306  14.367  1.00 23.54           O  
ATOM    410  OE2 GLU A  51      22.457  55.902  15.172  1.00 22.89           O  
ATOM    411  N   PHE A  52      24.605  50.372  12.863  1.00 13.89           N  
ATOM    412  CA  PHE A  52      24.463  48.983  13.268  1.00 12.16           C  
ATOM    413  C   PHE A  52      24.701  48.745  14.746  1.00 10.85           C  
ATOM    414  O   PHE A  52      25.468  49.459  15.390  1.00 11.10           O  
ATOM    415  CB  PHE A  52      25.393  48.093  12.446  1.00 12.20           C  
ATOM    416  CG  PHE A  52      25.019  48.017  10.997  1.00 13.99           C  
ATOM    417  CD1 PHE A  52      25.742  48.721  10.041  1.00 13.26           C  
ATOM    418  CD2 PHE A  52      23.914  47.276  10.595  1.00 11.83           C  
ATOM    419  CE1 PHE A  52      25.364  48.688   8.701  1.00 13.19           C  
ATOM    420  CE2 PHE A  52      23.527  47.238   9.258  1.00 14.56           C  
ATOM    421  CZ  PHE A  52      24.253  47.946   8.310  1.00 14.66           C  
ATOM    422  N   ASP A  53      24.025  47.724  15.262  1.00 12.27           N  
ATOM    423  CA  ASP A  53      24.116  47.324  16.660  1.00 13.04           C  
ATOM    424  C   ASP A  53      24.841  45.988  16.779  1.00 13.50           C  
ATOM    425  O   ASP A  53      25.464  45.709  17.796  1.00 13.98           O  
ATOM    426  CB  ASP A  53      22.717  47.180  17.253  1.00 12.58           C  
ATOM    427  CG  ASP A  53      21.958  48.488  17.276  1.00 12.59           C  
ATOM    428  OD1 ASP A  53      20.795  48.507  16.821  1.00 14.57           O  
ATOM    429  OD2 ASP A  53      22.523  49.491  17.754  1.00 14.19           O  
ATOM    430  N   LEU A  54      24.734  45.163  15.739  1.00 12.74           N  
ATOM    431  CA  LEU A  54      25.371  43.851  15.720  1.00 13.28           C  
ATOM    432  C   LEU A  54      25.625  43.398  14.292  1.00 12.96           C  
ATOM    433  O   LEU A  54      24.841  43.695  13.388  1.00 13.33           O  
ATOM    434  CB  LEU A  54      24.479  42.812  16.406  1.00 15.86           C  
ATOM    435  CG  LEU A  54      24.138  43.013  17.880  1.00 20.99           C  
ATOM    436  CD1 LEU A  54      23.059  42.023  18.292  1.00 22.64           C  
ATOM    437  CD2 LEU A  54      25.391  42.837  18.719  1.00 21.50           C  
ATOM    438  N   VAL A  55      26.717  42.666  14.097  1.00 12.29           N  
ATOM    439  CA  VAL A  55      27.076  42.150  12.781  1.00 11.87           C  
ATOM    440  C   VAL A  55      27.290  40.643  12.858  1.00 11.86           C  
ATOM    441  O   VAL A  55      28.017  40.158  13.730  1.00 13.74           O  
ATOM    442  CB  VAL A  55      28.386  42.773  12.257  1.00 11.59           C  
ATOM    443  CG1 VAL A  55      28.726  42.182  10.893  1.00 11.34           C  
ATOM    444  CG2 VAL A  55      28.258  44.294  12.180  1.00 11.53           C  
ATOM    445  N   PHE A  56      26.655  39.902  11.955  1.00  9.80           N  
ATOM    446  CA  PHE A  56      26.814  38.447  11.925  1.00 10.86           C  
ATOM    447  C   PHE A  56      27.516  38.039  10.636  1.00 11.35           C  
ATOM    448  O   PHE A  56      27.199  38.559   9.567  1.00 10.92           O  
ATOM    449  CB  PHE A  56      25.453  37.753  12.017  1.00 11.62           C  
ATOM    450  CG  PHE A  56      24.757  37.965  13.330  1.00 13.86           C  
ATOM    451  CD1 PHE A  56      23.884  39.034  13.507  1.00 12.93           C  
ATOM    452  CD2 PHE A  56      24.993  37.106  14.400  1.00 13.41           C  
ATOM    453  CE1 PHE A  56      23.253  39.246  14.732  1.00 15.43           C  
ATOM    454  CE2 PHE A  56      24.370  37.311  15.626  1.00 13.85           C  
ATOM    455  CZ  PHE A  56      23.499  38.382  15.794  1.00 14.79           C  
ATOM    456  N   THR A  57      28.467  37.111  10.735  1.00  8.59           N  
ATOM    457  CA  THR A  57      29.220  36.649   9.566  1.00  9.51           C  
ATOM    458  C   THR A  57      29.440  35.143   9.651  1.00  9.20           C  
ATOM    459  O   THR A  57      29.049  34.511  10.630  1.00  9.75           O  
ATOM    460  CB  THR A  57      30.628  37.312   9.498  1.00  9.79           C  
ATOM    461  OG1 THR A  57      31.525  36.611  10.372  1.00 10.92           O  
ATOM    462  CG2 THR A  57      30.566  38.775   9.947  1.00  9.49           C  
ATOM    463  N   SER A  58      30.060  34.570   8.620  1.00  9.63           N  
ATOM    464  CA  SER A  58      30.381  33.144   8.619  1.00 10.17           C  
ATOM    465  C   SER A  58      31.803  33.070   9.174  1.00 10.99           C  
ATOM    466  O   SER A  58      32.350  34.090   9.604  1.00 11.52           O  
ATOM    467  CB  SER A  58      30.355  32.567   7.195  1.00  9.35           C  
ATOM    468  OG  SER A  58      31.448  33.043   6.415  1.00  9.16           O  
ATOM    469  N   VAL A  59      32.407  31.884   9.182  1.00 11.87           N  
ATOM    470  CA  VAL A  59      33.777  31.777   9.671  1.00 12.10           C  
ATOM    471  C   VAL A  59      34.754  31.773   8.494  1.00 14.07           C  
ATOM    472  O   VAL A  59      35.952  31.542   8.664  1.00 13.06           O  
ATOM    473  CB  VAL A  59      33.990  30.524  10.566  1.00 13.36           C  
ATOM    474  CG1 VAL A  59      33.129  30.643  11.828  1.00 14.31           C  
ATOM    475  CG2 VAL A  59      33.646  29.249   9.804  1.00 12.48           C  
ATOM    476  N   LEU A  60      34.230  32.028   7.293  1.00 13.36           N  
ATOM    477  CA  LEU A  60      35.065  32.114   6.093  1.00 12.64           C  
ATOM    478  C   LEU A  60      35.577  33.557   6.134  1.00 12.68           C  
ATOM    479  O   LEU A  60      34.784  34.506   6.196  1.00 10.72           O  
ATOM    480  CB  LEU A  60      34.224  31.839   4.839  1.00 12.54           C  
ATOM    481  CG  LEU A  60      33.687  30.400   4.779  1.00 13.24           C  
ATOM    482  CD1 LEU A  60      32.724  30.235   3.617  1.00 11.72           C  
ATOM    483  CD2 LEU A  60      34.855  29.419   4.650  1.00 11.48           C  
ATOM    484  N   ASN A  61      36.898  33.731   6.104  1.00 11.67           N  
ATOM    485  CA  ASN A  61      37.464  35.069   6.239  1.00 12.55           C  
ATOM    486  C   ASN A  61      36.983  36.128   5.260  1.00 11.90           C  
ATOM    487  O   ASN A  61      36.992  37.313   5.587  1.00 12.31           O  
ATOM    488  CB  ASN A  61      39.007  35.020   6.270  1.00 10.17           C  
ATOM    489  CG  ASN A  61      39.638  34.950   4.890  1.00 11.73           C  
ATOM    490  OD1 ASN A  61      40.188  33.917   4.493  1.00 17.17           O  
ATOM    491  ND2 ASN A  61      39.582  36.053   4.159  1.00  9.20           N  
ATOM    492  N   ARG A  62      36.532  35.727   4.078  1.00 11.10           N  
ATOM    493  CA  ARG A  62      36.071  36.728   3.130  1.00 10.81           C  
ATOM    494  C   ARG A  62      34.806  37.444   3.607  1.00 11.10           C  
ATOM    495  O   ARG A  62      34.597  38.614   3.280  1.00  9.45           O  
ATOM    496  CB  ARG A  62      35.857  36.116   1.740  1.00 12.17           C  
ATOM    497  CG  ARG A  62      34.890  34.944   1.658  1.00 11.09           C  
ATOM    498  CD  ARG A  62      34.990  34.351   0.257  1.00 10.20           C  
ATOM    499  NE  ARG A  62      34.030  33.290  -0.036  1.00 10.02           N  
ATOM    500  CZ  ARG A  62      34.191  32.006   0.277  1.00 11.72           C  
ATOM    501  NH1 ARG A  62      35.284  31.596   0.914  1.00  8.03           N  
ATOM    502  NH2 ARG A  62      33.274  31.119  -0.092  1.00  9.47           N  
ATOM    503  N   SER A  63      33.970  36.761   4.386  1.00 10.83           N  
ATOM    504  CA  SER A  63      32.752  37.402   4.884  1.00 11.57           C  
ATOM    505  C   SER A  63      33.112  38.291   6.071  1.00 11.20           C  
ATOM    506  O   SER A  63      32.492  39.334   6.295  1.00 10.25           O  
ATOM    507  CB  SER A  63      31.708  36.363   5.308  1.00 13.05           C  
ATOM    508  OG  SER A  63      31.938  35.900   6.624  1.00 15.86           O  
ATOM    509  N   ILE A  64      34.123  37.871   6.827  1.00 10.53           N  
ATOM    510  CA  ILE A  64      34.579  38.632   7.980  1.00 10.56           C  
ATOM    511  C   ILE A  64      35.284  39.910   7.525  1.00 10.11           C  
ATOM    512  O   ILE A  64      35.001  40.990   8.040  1.00 11.07           O  
ATOM    513  CB  ILE A  64      35.521  37.778   8.856  1.00 10.68           C  
ATOM    514  CG1 ILE A  64      34.749  36.562   9.388  1.00 10.74           C  
ATOM    515  CG2 ILE A  64      36.058  38.603  10.020  1.00 11.85           C  
ATOM    516  CD1 ILE A  64      35.612  35.544  10.112  1.00 11.21           C  
ATOM    517  N   HIS A  65      36.185  39.795   6.552  1.00  9.23           N  
ATOM    518  CA  HIS A  65      36.889  40.967   6.041  1.00 10.49           C  
ATOM    519  C   HIS A  65      35.896  41.951   5.426  1.00 10.45           C  
ATOM    520  O   HIS A  65      36.072  43.163   5.531  1.00 11.53           O  
ATOM    521  CB  HIS A  65      37.937  40.560   4.998  1.00 12.87           C  
ATOM    522  CG  HIS A  65      39.238  40.114   5.592  1.00 13.20           C  
ATOM    523  ND1 HIS A  65      40.162  40.998   6.110  1.00 12.22           N  
ATOM    524  CD2 HIS A  65      39.751  38.876   5.791  1.00 11.61           C  
ATOM    525  CE1 HIS A  65      41.187  40.325   6.601  1.00 12.97           C  
ATOM    526  NE2 HIS A  65      40.963  39.035   6.421  1.00 13.14           N  
ATOM    527  N   THR A  66      34.854  41.428   4.787  1.00 11.20           N  
ATOM    528  CA  THR A  66      33.834  42.283   4.180  1.00 10.33           C  
ATOM    529  C   THR A  66      33.172  43.128   5.278  1.00 10.90           C  
ATOM    530  O   THR A  66      33.015  44.343   5.132  1.00 10.52           O  
ATOM    531  CB  THR A  66      32.774  41.434   3.425  1.00 10.27           C  
ATOM    532  OG1 THR A  66      33.385  40.825   2.279  1.00 11.31           O  
ATOM    533  CG2 THR A  66      31.599  42.304   2.957  1.00 10.20           C  
ATOM    534  N   ALA A  67      32.806  42.482   6.382  1.00 11.16           N  
ATOM    535  CA  ALA A  67      32.181  43.167   7.509  1.00 11.59           C  
ATOM    536  C   ALA A  67      33.112  44.240   8.080  1.00 11.13           C  
ATOM    537  O   ALA A  67      32.684  45.358   8.367  1.00 11.71           O  
ATOM    538  CB  ALA A  67      31.818  42.153   8.604  1.00 13.98           C  
ATOM    539  N   TRP A  68      34.386  43.893   8.249  1.00 11.13           N  
ATOM    540  CA  TRP A  68      35.362  44.833   8.788  1.00 11.05           C  
ATOM    541  C   TRP A  68      35.500  46.076   7.907  1.00 12.18           C  
ATOM    542  O   TRP A  68      35.606  47.192   8.417  1.00 12.12           O  
ATOM    543  CB  TRP A  68      36.731  44.160   8.938  1.00 10.87           C  
ATOM    544  CG  TRP A  68      36.794  43.112  10.023  1.00 10.96           C  
ATOM    545  CD1 TRP A  68      35.858  42.857  10.982  1.00 11.44           C  
ATOM    546  CD2 TRP A  68      37.875  42.203  10.269  1.00 12.60           C  
ATOM    547  NE1 TRP A  68      36.287  41.846  11.811  1.00 12.10           N  
ATOM    548  CE2 TRP A  68      37.524  41.427  11.395  1.00 11.44           C  
ATOM    549  CE3 TRP A  68      39.109  41.969   9.645  1.00 11.75           C  
ATOM    550  CZ2 TRP A  68      38.363  40.431  11.916  1.00 13.11           C  
ATOM    551  CZ3 TRP A  68      39.943  40.980  10.161  1.00 13.88           C  
ATOM    552  CH2 TRP A  68      39.563  40.224  11.286  1.00 12.18           C  
ATOM    553  N   LEU A  69      35.504  45.881   6.591  1.00 10.28           N  
ATOM    554  CA  LEU A  69      35.632  46.998   5.659  1.00 12.14           C  
ATOM    555  C   LEU A  69      34.407  47.896   5.702  1.00 13.18           C  
ATOM    556  O   LEU A  69      34.525  49.120   5.618  1.00 14.06           O  
ATOM    557  CB  LEU A  69      35.848  46.481   4.236  1.00 13.09           C  
ATOM    558  CG  LEU A  69      37.215  45.825   4.005  1.00 14.10           C  
ATOM    559  CD1 LEU A  69      37.254  45.161   2.634  1.00 14.13           C  
ATOM    560  CD2 LEU A  69      38.308  46.881   4.134  1.00 14.51           C  
ATOM    561  N   ILE A  70      33.232  47.283   5.830  1.00 12.31           N  
ATOM    562  CA  ILE A  70      31.991  48.038   5.906  1.00 13.41           C  
ATOM    563  C   ILE A  70      31.992  48.854   7.199  1.00 13.81           C  
ATOM    564  O   ILE A  70      31.683  50.046   7.182  1.00 12.21           O  
ATOM    565  CB  ILE A  70      30.761  47.091   5.862  1.00 13.22           C  
ATOM    566  CG1 ILE A  70      30.632  46.495   4.458  1.00 14.06           C  
ATOM    567  CG2 ILE A  70      29.489  47.842   6.246  1.00 13.50           C  
ATOM    568  CD1 ILE A  70      29.609  45.383   4.334  1.00 13.37           C  
ATOM    569  N   LEU A  71      32.356  48.216   8.313  1.00 12.72           N  
ATOM    570  CA  LEU A  71      32.394  48.901   9.600  1.00 13.48           C  
ATOM    571  C   LEU A  71      33.383  50.066   9.586  1.00 13.54           C  
ATOM    572  O   LEU A  71      33.138  51.097  10.214  1.00 11.83           O  
ATOM    573  CB  LEU A  71      32.750  47.922  10.733  1.00 12.37           C  
ATOM    574  CG  LEU A  71      31.665  46.898  11.100  1.00 11.33           C  
ATOM    575  CD1 LEU A  71      32.124  46.069  12.286  1.00  9.66           C  
ATOM    576  CD2 LEU A  71      30.361  47.617  11.445  1.00 11.45           C  
ATOM    577  N   GLU A  72      34.495  49.912   8.869  1.00 14.13           N  
ATOM    578  CA  GLU A  72      35.470  50.997   8.806  1.00 14.38           C  
ATOM    579  C   GLU A  72      34.895  52.181   8.034  1.00 14.13           C  
ATOM    580  O   GLU A  72      35.068  53.334   8.433  1.00 13.66           O  
ATOM    581  CB  GLU A  72      36.781  50.542   8.150  1.00 15.03           C  
ATOM    582  CG  GLU A  72      37.799  51.678   8.037  1.00 15.12           C  
ATOM    583  CD  GLU A  72      39.150  51.235   7.499  1.00 19.34           C  
ATOM    584  OE1 GLU A  72      40.021  52.111   7.323  1.00 19.98           O  
ATOM    585  OE2 GLU A  72      39.344  50.024   7.260  1.00 14.44           O  
ATOM    586  N   GLU A  73      34.217  51.901   6.925  1.00 13.69           N  
ATOM    587  CA  GLU A  73      33.614  52.967   6.126  1.00 15.43           C  
ATOM    588  C   GLU A  73      32.601  53.743   6.960  1.00 14.49           C  
ATOM    589  O   GLU A  73      32.414  54.942   6.769  1.00 15.21           O  
ATOM    590  CB  GLU A  73      32.903  52.392   4.893  1.00 17.05           C  
ATOM    591  CG  GLU A  73      33.818  51.902   3.785  1.00 18.87           C  
ATOM    592  CD  GLU A  73      34.767  52.981   3.285  1.00 20.54           C  
ATOM    593  OE1 GLU A  73      34.357  54.158   3.203  1.00 18.08           O  
ATOM    594  OE2 GLU A  73      35.923  52.644   2.963  1.00 21.13           O  
ATOM    595  N   LEU A  74      31.947  53.041   7.882  1.00 13.25           N  
ATOM    596  CA  LEU A  74      30.934  53.630   8.753  1.00 12.96           C  
ATOM    597  C   LEU A  74      31.502  54.249  10.025  1.00 13.53           C  
ATOM    598  O   LEU A  74      30.811  55.004  10.712  1.00 13.14           O  
ATOM    599  CB  LEU A  74      29.915  52.559   9.160  1.00 10.93           C  
ATOM    600  CG  LEU A  74      28.977  52.017   8.083  1.00 12.44           C  
ATOM    601  CD1 LEU A  74      28.366  50.703   8.549  1.00 10.96           C  
ATOM    602  CD2 LEU A  74      27.898  53.048   7.791  1.00 13.84           C  
ATOM    603  N   GLY A  75      32.751  53.926  10.340  1.00 13.44           N  
ATOM    604  CA  GLY A  75      33.351  54.438  11.558  1.00 13.21           C  
ATOM    605  C   GLY A  75      32.670  53.745  12.724  1.00 13.06           C  
ATOM    606  O   GLY A  75      32.483  54.328  13.794  1.00 13.61           O  
ATOM    607  N   GLN A  76      32.293  52.487  12.508  1.00 11.80           N  
ATOM    608  CA  GLN A  76      31.609  51.696  13.529  1.00 12.67           C  
ATOM    609  C   GLN A  76      32.349  50.397  13.864  1.00 11.52           C  
ATOM    610  O   GLN A  76      31.723  49.374  14.156  1.00 11.51           O  
ATOM    611  CB  GLN A  76      30.181  51.383  13.057  1.00 12.70           C  
ATOM    612  CG  GLN A  76      29.258  52.618  13.018  1.00 12.14           C  
ATOM    613  CD  GLN A  76      27.940  52.357  12.302  1.00 14.36           C  
ATOM    614  OE1 GLN A  76      27.393  51.260  12.371  1.00 11.88           O  
ATOM    615  NE2 GLN A  76      27.416  53.381  11.621  1.00 13.87           N  
ATOM    616  N   GLU A  77      33.680  50.452  13.844  1.00 11.75           N  
ATOM    617  CA  GLU A  77      34.504  49.278  14.123  1.00 11.03           C  
ATOM    618  C   GLU A  77      34.277  48.667  15.504  1.00 11.25           C  
ATOM    619  O   GLU A  77      34.628  47.511  15.735  1.00 11.35           O  
ATOM    620  CB  GLU A  77      35.992  49.617  13.951  1.00 12.09           C  
ATOM    621  CG  GLU A  77      36.382  50.011  12.524  1.00 11.16           C  
ATOM    622  CD  GLU A  77      36.462  51.516  12.320  1.00 13.07           C  
ATOM    623  OE1 GLU A  77      35.625  52.251  12.888  1.00 13.60           O  
ATOM    624  OE2 GLU A  77      37.361  51.962  11.580  1.00 16.17           O  
ATOM    625  N   TRP A  78      33.681  49.435  16.410  1.00 11.73           N  
ATOM    626  CA  TRP A  78      33.413  48.968  17.770  1.00 13.18           C  
ATOM    627  C   TRP A  78      32.156  48.104  17.877  1.00 12.70           C  
ATOM    628  O   TRP A  78      31.929  47.461  18.900  1.00 12.46           O  
ATOM    629  CB  TRP A  78      33.267  50.162  18.717  1.00 12.58           C  
ATOM    630  CG  TRP A  78      32.217  51.138  18.269  1.00 13.17           C  
ATOM    631  CD1 TRP A  78      32.393  52.202  17.429  1.00 13.93           C  
ATOM    632  CD2 TRP A  78      30.821  51.103  18.587  1.00 13.85           C  
ATOM    633  NE1 TRP A  78      31.191  52.833  17.204  1.00 13.58           N  
ATOM    634  CE2 TRP A  78      30.209  52.178  17.902  1.00 14.87           C  
ATOM    635  CE3 TRP A  78      30.023  50.267  19.383  1.00 13.73           C  
ATOM    636  CZ2 TRP A  78      28.836  52.438  17.988  1.00 15.27           C  
ATOM    637  CZ3 TRP A  78      28.660  50.527  19.469  1.00 16.24           C  
ATOM    638  CH2 TRP A  78      28.081  51.606  18.774  1.00 14.18           C  
ATOM    639  N   VAL A  79      31.338  48.096  16.827  1.00 11.95           N  
ATOM    640  CA  VAL A  79      30.102  47.312  16.823  1.00 11.61           C  
ATOM    641  C   VAL A  79      30.406  45.821  16.918  1.00 11.19           C  
ATOM    642  O   VAL A  79      31.219  45.293  16.162  1.00 12.31           O  
ATOM    643  CB  VAL A  79      29.280  47.594  15.550  1.00 12.33           C  
ATOM    644  CG1 VAL A  79      28.068  46.667  15.480  1.00 13.59           C  
ATOM    645  CG2 VAL A  79      28.830  49.046  15.554  1.00 12.06           C  
ATOM    646  N   PRO A  80      29.746  45.120  17.851  1.00 11.44           N  
ATOM    647  CA  PRO A  80      29.959  43.679  18.042  1.00 12.81           C  
ATOM    648  C   PRO A  80      29.764  42.831  16.787  1.00 11.65           C  
ATOM    649  O   PRO A  80      28.783  42.981  16.056  1.00 11.59           O  
ATOM    650  CB  PRO A  80      28.943  43.315  19.126  1.00 12.52           C  
ATOM    651  CG  PRO A  80      28.796  44.582  19.897  1.00 14.16           C  
ATOM    652  CD  PRO A  80      28.755  45.632  18.810  1.00 11.70           C  
ATOM    653  N   VAL A  81      30.704  41.922  16.562  1.00 12.00           N  
ATOM    654  CA  VAL A  81      30.655  41.016  15.427  1.00 10.93           C  
ATOM    655  C   VAL A  81      30.623  39.587  15.961  1.00 13.06           C  
ATOM    656  O   VAL A  81      31.302  39.277  16.941  1.00 11.29           O  
ATOM    657  CB  VAL A  81      31.913  41.171  14.541  1.00 13.20           C  
ATOM    658  CG1 VAL A  81      31.928  40.101  13.446  1.00 12.74           C  
ATOM    659  CG2 VAL A  81      31.947  42.559  13.932  1.00 11.71           C  
ATOM    660  N   GLU A  82      29.813  38.732  15.342  1.00 11.30           N  
ATOM    661  CA  GLU A  82      29.754  37.327  15.735  1.00 13.21           C  
ATOM    662  C   GLU A  82      29.845  36.493  14.465  1.00 13.01           C  
ATOM    663  O   GLU A  82      29.147  36.760  13.487  1.00 13.18           O  
ATOM    664  CB  GLU A  82      28.461  36.994  16.481  1.00 14.72           C  
ATOM    665  CG  GLU A  82      28.354  35.497  16.778  1.00 19.62           C  
ATOM    666  CD  GLU A  82      27.151  35.125  17.613  1.00 20.61           C  
ATOM    667  OE1 GLU A  82      26.505  34.104  17.285  1.00 21.06           O  
ATOM    668  OE2 GLU A  82      26.861  35.836  18.597  1.00 19.48           O  
ATOM    669  N   SER A  83      30.714  35.488  14.481  1.00 13.05           N  
ATOM    670  CA  SER A  83      30.917  34.637  13.314  1.00 14.11           C  
ATOM    671  C   SER A  83      30.558  33.188  13.618  1.00 15.21           C  
ATOM    672  O   SER A  83      30.899  32.667  14.680  1.00 15.04           O  
ATOM    673  CB  SER A  83      32.378  34.727  12.871  1.00 14.18           C  
ATOM    674  OG  SER A  83      32.799  36.081  12.795  1.00 14.75           O  
ATOM    675  N   SER A  84      29.872  32.540  12.680  1.00 14.33           N  
ATOM    676  CA  SER A  84      29.455  31.151  12.856  1.00 13.50           C  
ATOM    677  C   SER A  84      29.524  30.353  11.560  1.00 14.12           C  
ATOM    678  O   SER A  84      29.279  30.889  10.475  1.00 10.55           O  
ATOM    679  CB  SER A  84      28.020  31.099  13.391  1.00 14.46           C  
ATOM    680  OG  SER A  84      27.500  29.779  13.333  1.00 12.20           O  
ATOM    681  N   TRP A  85      29.853  29.069  11.671  1.00 12.17           N  
ATOM    682  CA  TRP A  85      29.913  28.225  10.484  1.00 12.91           C  
ATOM    683  C   TRP A  85      28.512  28.076   9.904  1.00 11.01           C  
ATOM    684  O   TRP A  85      28.348  27.722   8.733  1.00 12.99           O  
ATOM    685  CB  TRP A  85      30.456  26.831  10.817  1.00 12.77           C  
ATOM    686  CG  TRP A  85      29.449  25.934  11.489  1.00 13.63           C  
ATOM    687  CD1 TRP A  85      29.176  25.860  12.823  1.00 12.26           C  
ATOM    688  CD2 TRP A  85      28.579  24.990  10.848  1.00 14.11           C  
ATOM    689  NE1 TRP A  85      28.192  24.925  13.057  1.00 13.12           N  
ATOM    690  CE2 TRP A  85      27.808  24.377  11.862  1.00 14.96           C  
ATOM    691  CE3 TRP A  85      28.376  24.604   9.515  1.00 16.06           C  
ATOM    692  CZ2 TRP A  85      26.847  23.396  11.585  1.00 15.20           C  
ATOM    693  CZ3 TRP A  85      27.419  23.627   9.237  1.00 14.66           C  
ATOM    694  CH2 TRP A  85      26.667  23.035  10.270  1.00 16.39           C  
ATOM    695  N   ARG A  86      27.493  28.353  10.715  1.00 11.65           N  
ATOM    696  CA  ARG A  86      26.127  28.205  10.231  1.00 11.02           C  
ATOM    697  C   ARG A  86      25.743  29.218   9.163  1.00 10.55           C  
ATOM    698  O   ARG A  86      24.685  29.103   8.551  1.00 11.41           O  
ATOM    699  CB  ARG A  86      25.140  28.214  11.403  1.00 10.29           C  
ATOM    700  CG  ARG A  86      25.267  26.926  12.224  1.00 12.90           C  
ATOM    701  CD  ARG A  86      24.389  26.892  13.457  1.00 16.10           C  
ATOM    702  NE  ARG A  86      24.594  25.653  14.202  1.00 15.50           N  
ATOM    703  CZ  ARG A  86      24.023  24.491  13.901  1.00 18.38           C  
ATOM    704  NH1 ARG A  86      23.195  24.396  12.864  1.00 15.06           N  
ATOM    705  NH2 ARG A  86      24.292  23.416  14.630  1.00 18.44           N  
ATOM    706  N   LEU A  87      26.606  30.203   8.932  1.00 10.10           N  
ATOM    707  CA  LEU A  87      26.355  31.197   7.891  1.00 11.49           C  
ATOM    708  C   LEU A  87      27.309  30.952   6.716  1.00 12.37           C  
ATOM    709  O   LEU A  87      27.311  31.692   5.733  1.00 11.05           O  
ATOM    710  CB  LEU A  87      26.527  32.618   8.443  1.00 11.39           C  
ATOM    711  CG  LEU A  87      25.356  33.127   9.297  1.00 12.24           C  
ATOM    712  CD1 LEU A  87      25.669  34.504   9.866  1.00 10.20           C  
ATOM    713  CD2 LEU A  87      24.088  33.168   8.443  1.00 13.12           C  
ATOM    714  N   ASN A  88      28.120  29.902   6.831  1.00 10.96           N  
ATOM    715  CA  ASN A  88      29.069  29.531   5.778  1.00 10.95           C  
ATOM    716  C   ASN A  88      28.342  29.331   4.456  1.00 10.39           C  
ATOM    717  O   ASN A  88      27.164  28.983   4.428  1.00 10.19           O  
ATOM    718  CB  ASN A  88      29.780  28.220   6.137  1.00 10.68           C  
ATOM    719  CG  ASN A  88      31.111  28.440   6.825  1.00 10.22           C  
ATOM    720  OD1 ASN A  88      31.343  29.474   7.450  1.00 12.10           O  
ATOM    721  ND2 ASN A  88      31.995  27.450   6.721  1.00 10.55           N  
ATOM    722  N   GLU A  89      29.051  29.541   3.355  1.00 11.36           N  
ATOM    723  CA  GLU A  89      28.455  29.342   2.038  1.00 12.27           C  
ATOM    724  C   GLU A  89      28.095  27.863   1.918  1.00 13.22           C  
ATOM    725  O   GLU A  89      28.677  27.021   2.613  1.00 12.32           O  
ATOM    726  CB  GLU A  89      29.454  29.736   0.941  1.00 12.25           C  
ATOM    727  CG  GLU A  89      28.985  29.430  -0.483  1.00 13.09           C  
ATOM    728  CD  GLU A  89      27.671  30.104  -0.844  1.00 13.07           C  
ATOM    729  OE1 GLU A  89      26.647  29.833  -0.183  1.00 10.94           O  
ATOM    730  OE2 GLU A  89      27.657  30.906  -1.799  1.00 13.22           O  
ATOM    731  N   ARG A  90      27.132  27.544   1.057  1.00 11.62           N  
ATOM    732  CA  ARG A  90      26.721  26.155   0.865  1.00 12.59           C  
ATOM    733  C   ARG A  90      27.933  25.313   0.492  1.00 12.59           C  
ATOM    734  O   ARG A  90      28.767  25.737  -0.306  1.00 11.27           O  
ATOM    735  CB  ARG A  90      25.655  26.051  -0.235  1.00 13.08           C  
ATOM    736  CG  ARG A  90      25.271  24.616  -0.618  1.00 11.33           C  
ATOM    737  CD  ARG A  90      26.092  24.111  -1.801  1.00 13.24           C  
ATOM    738  NE  ARG A  90      25.623  24.677  -3.063  1.00 14.41           N  
ATOM    739  CZ  ARG A  90      24.524  24.281  -3.699  1.00 13.93           C  
ATOM    740  NH1 ARG A  90      23.774  23.302  -3.199  1.00 13.59           N  
ATOM    741  NH2 ARG A  90      24.160  24.879  -4.827  1.00 12.67           N  
ATOM    742  N   HIS A  91      28.025  24.126   1.080  1.00 13.00           N  
ATOM    743  CA  HIS A  91      29.138  23.214   0.815  1.00 13.69           C  
ATOM    744  C   HIS A  91      28.944  22.487  -0.519  1.00 13.40           C  
ATOM    745  O   HIS A  91      28.058  21.639  -0.645  1.00 14.23           O  
ATOM    746  CB  HIS A  91      29.241  22.189   1.943  1.00 12.57           C  
ATOM    747  CG  HIS A  91      30.551  21.470   1.982  1.00 13.00           C  
ATOM    748  ND1 HIS A  91      31.152  20.961   0.851  1.00 14.59           N  
ATOM    749  CD2 HIS A  91      31.369  21.160   3.017  1.00 13.26           C  
ATOM    750  CE1 HIS A  91      32.285  20.368   1.187  1.00 15.14           C  
ATOM    751  NE2 HIS A  91      32.440  20.475   2.494  1.00 13.60           N  
ATOM    752  N   TYR A  92      29.779  22.809  -1.507  1.00 12.84           N  
ATOM    753  CA  TYR A  92      29.678  22.199  -2.834  1.00 13.27           C  
ATOM    754  C   TYR A  92      30.308  20.813  -2.992  1.00 13.95           C  
ATOM    755  O   TYR A  92      30.377  20.282  -4.105  1.00 12.94           O  
ATOM    756  CB  TYR A  92      30.250  23.151  -3.897  1.00 11.89           C  
ATOM    757  CG  TYR A  92      29.183  23.928  -4.650  1.00  9.20           C  
ATOM    758  CD1 TYR A  92      29.197  25.325  -4.692  1.00 12.22           C  
ATOM    759  CD2 TYR A  92      28.160  23.262  -5.323  1.00  9.37           C  
ATOM    760  CE1 TYR A  92      28.209  26.041  -5.392  1.00  9.86           C  
ATOM    761  CE2 TYR A  92      27.171  23.964  -6.023  1.00 10.33           C  
ATOM    762  CZ  TYR A  92      27.202  25.350  -6.053  1.00 10.71           C  
ATOM    763  OH  TYR A  92      26.216  26.036  -6.737  1.00 11.00           O  
ATOM    764  N   GLY A  93      30.755  20.227  -1.886  1.00 14.04           N  
ATOM    765  CA  GLY A  93      31.346  18.900  -1.945  1.00 14.03           C  
ATOM    766  C   GLY A  93      32.444  18.733  -2.981  1.00 14.68           C  
ATOM    767  O   GLY A  93      33.317  19.589  -3.119  1.00 13.67           O  
ATOM    768  N   ALA A  94      32.393  17.625  -3.718  1.00 14.17           N  
ATOM    769  CA  ALA A  94      33.385  17.316  -4.743  1.00 14.24           C  
ATOM    770  C   ALA A  94      33.475  18.362  -5.852  1.00 14.93           C  
ATOM    771  O   ALA A  94      34.488  18.442  -6.556  1.00 15.23           O  
ATOM    772  CB  ALA A  94      33.084  15.935  -5.349  1.00 16.50           C  
ATOM    773  N   LEU A  95      32.419  19.156  -6.015  1.00 14.58           N  
ATOM    774  CA  LEU A  95      32.405  20.183  -7.052  1.00 14.32           C  
ATOM    775  C   LEU A  95      33.320  21.360  -6.722  1.00 15.60           C  
ATOM    776  O   LEU A  95      33.623  22.187  -7.587  1.00 15.19           O  
ATOM    777  CB  LEU A  95      30.976  20.689  -7.282  1.00 15.38           C  
ATOM    778  CG  LEU A  95      29.967  19.673  -7.822  1.00 15.16           C  
ATOM    779  CD1 LEU A  95      28.634  20.367  -8.090  1.00 14.93           C  
ATOM    780  CD2 LEU A  95      30.507  19.043  -9.103  1.00 16.10           C  
ATOM    781  N   ILE A  96      33.760  21.438  -5.472  1.00 14.93           N  
ATOM    782  CA  ILE A  96      34.648  22.515  -5.055  1.00 14.82           C  
ATOM    783  C   ILE A  96      35.897  22.563  -5.929  1.00 15.19           C  
ATOM    784  O   ILE A  96      36.529  21.533  -6.197  1.00 14.66           O  
ATOM    785  CB  ILE A  96      35.068  22.352  -3.583  1.00 14.04           C  
ATOM    786  CG1 ILE A  96      33.848  22.565  -2.678  1.00 16.07           C  
ATOM    787  CG2 ILE A  96      36.184  23.338  -3.243  1.00 13.37           C  
ATOM    788  CD1 ILE A  96      34.144  22.467  -1.200  1.00 18.30           C  
ATOM    789  N   GLY A  97      36.236  23.763  -6.387  1.00 14.08           N  
ATOM    790  CA  GLY A  97      37.412  23.926  -7.222  1.00 14.65           C  
ATOM    791  C   GLY A  97      37.198  23.656  -8.697  1.00 14.54           C  
ATOM    792  O   GLY A  97      38.055  23.987  -9.515  1.00 16.86           O  
ATOM    793  N   LEU A  98      36.067  23.059  -9.056  1.00 14.63           N  
ATOM    794  CA  LEU A  98      35.801  22.770 -10.460  1.00 15.37           C  
ATOM    795  C   LEU A  98      35.255  23.995 -11.185  1.00 15.22           C  
ATOM    796  O   LEU A  98      34.641  24.871 -10.574  1.00 15.59           O  
ATOM    797  CB  LEU A  98      34.822  21.601 -10.595  1.00 14.83           C  
ATOM    798  CG  LEU A  98      35.263  20.290  -9.934  1.00 18.07           C  
ATOM    799  CD1 LEU A  98      34.283  19.185 -10.304  1.00 17.89           C  
ATOM    800  CD2 LEU A  98      36.678  19.923 -10.388  1.00 18.86           C  
ATOM    801  N   ASN A  99      35.496  24.049 -12.489  1.00 13.53           N  
ATOM    802  CA  ASN A  99      35.047  25.158 -13.329  1.00 13.66           C  
ATOM    803  C   ASN A  99      33.575  24.953 -13.707  1.00 13.97           C  
ATOM    804  O   ASN A  99      33.204  23.896 -14.223  1.00 13.32           O  
ATOM    805  CB  ASN A  99      35.934  25.218 -14.583  1.00 13.68           C  
ATOM    806  CG  ASN A  99      35.612  26.395 -15.478  1.00 14.29           C  
ATOM    807  OD1 ASN A  99      34.569  26.427 -16.126  1.00 14.38           O  
ATOM    808  ND2 ASN A  99      36.512  27.375 -15.514  1.00 13.46           N  
ATOM    809  N   ARG A 100      32.744  25.962 -13.442  1.00 13.53           N  
ATOM    810  CA  ARG A 100      31.310  25.893 -13.731  1.00 14.28           C  
ATOM    811  C   ARG A 100      30.992  25.682 -15.207  1.00 15.61           C  
ATOM    812  O   ARG A 100      30.091  24.912 -15.552  1.00 13.53           O  
ATOM    813  CB  ARG A 100      30.600  27.168 -13.258  1.00 14.92           C  
ATOM    814  CG  ARG A 100      30.769  27.503 -11.778  1.00 13.76           C  
ATOM    815  CD  ARG A 100      29.783  28.596 -11.375  1.00 16.73           C  
ATOM    816  NE  ARG A 100      29.917  29.009  -9.981  1.00 15.95           N  
ATOM    817  CZ  ARG A 100      30.919  29.747  -9.508  1.00 17.90           C  
ATOM    818  NH1 ARG A 100      31.886  30.160 -10.320  1.00 14.51           N  
ATOM    819  NH2 ARG A 100      30.954  30.073  -8.224  1.00 17.96           N  
ATOM    820  N   GLU A 101      31.709  26.382 -16.080  1.00 15.24           N  
ATOM    821  CA  GLU A 101      31.460  26.233 -17.506  1.00 15.33           C  
ATOM    822  C   GLU A 101      31.882  24.841 -17.958  1.00 13.95           C  
ATOM    823  O   GLU A 101      31.224  24.222 -18.794  1.00 15.78           O  
ATOM    824  CB  GLU A 101      32.217  27.290 -18.307  1.00 13.55           C  
ATOM    825  CG  GLU A 101      31.808  27.306 -19.768  1.00 14.62           C  
ATOM    826  CD  GLU A 101      32.419  28.458 -20.524  1.00 16.94           C  
ATOM    827  OE1 GLU A 101      32.541  29.551 -19.933  1.00 14.97           O  
ATOM    828  OE2 GLU A 101      32.759  28.273 -21.710  1.00 17.05           O  
ATOM    829  N   GLN A 102      32.984  24.350 -17.405  1.00 14.30           N  
ATOM    830  CA  GLN A 102      33.455  23.021 -17.753  1.00 15.82           C  
ATOM    831  C   GLN A 102      32.377  22.009 -17.365  1.00 15.48           C  
ATOM    832  O   GLN A 102      32.137  21.039 -18.082  1.00 14.79           O  
ATOM    833  CB  GLN A 102      34.758  22.695 -17.020  1.00 16.26           C  
ATOM    834  CG  GLN A 102      35.368  21.348 -17.411  1.00 18.85           C  
ATOM    835  CD  GLN A 102      35.901  21.332 -18.833  1.00 21.02           C  
ATOM    836  OE1 GLN A 102      36.830  22.071 -19.166  1.00 22.74           O  
ATOM    837  NE2 GLN A 102      35.315  20.490 -19.683  1.00 20.49           N  
ATOM    838  N   MET A 103      31.724  22.237 -16.229  1.00 15.03           N  
ATOM    839  CA  MET A 103      30.675  21.324 -15.779  1.00 15.82           C  
ATOM    840  C   MET A 103      29.477  21.384 -16.718  1.00 15.17           C  
ATOM    841  O   MET A 103      28.771  20.390 -16.904  1.00 15.35           O  
ATOM    842  CB  MET A 103      30.241  21.662 -14.347  1.00 15.68           C  
ATOM    843  CG  MET A 103      31.321  21.419 -13.299  1.00 17.06           C  
ATOM    844  SD  MET A 103      31.883  19.697 -13.276  1.00 22.13           S  
ATOM    845  CE  MET A 103      33.318  19.790 -14.375  1.00 21.47           C  
ATOM    846  N   ALA A 104      29.250  22.553 -17.313  1.00 14.51           N  
ATOM    847  CA  ALA A 104      28.141  22.729 -18.243  1.00 15.72           C  
ATOM    848  C   ALA A 104      28.428  21.936 -19.516  1.00 16.38           C  
ATOM    849  O   ALA A 104      27.540  21.288 -20.074  1.00 15.76           O  
ATOM    850  CB  ALA A 104      27.957  24.207 -18.572  1.00 15.52           C  
ATOM    851  N   LEU A 105      29.675  21.992 -19.974  1.00 17.31           N  
ATOM    852  CA  LEU A 105      30.074  21.263 -21.172  1.00 17.64           C  
ATOM    853  C   LEU A 105      30.035  19.761 -20.917  1.00 18.51           C  
ATOM    854  O   LEU A 105      29.662  18.982 -21.791  1.00 17.90           O  
ATOM    855  CB  LEU A 105      31.493  21.660 -21.593  1.00 17.43           C  
ATOM    856  CG  LEU A 105      31.688  23.073 -22.153  1.00 18.06           C  
ATOM    857  CD1 LEU A 105      33.171  23.348 -22.350  1.00 17.29           C  
ATOM    858  CD2 LEU A 105      30.935  23.206 -23.473  1.00 17.16           C  
ATOM    859  N   ASN A 106      30.421  19.361 -19.710  1.00 17.74           N  
ATOM    860  CA  ASN A 106      30.458  17.946 -19.364  1.00 19.81           C  
ATOM    861  C   ASN A 106      29.109  17.324 -19.020  1.00 20.90           C  
ATOM    862  O   ASN A 106      28.808  16.214 -19.461  1.00 20.52           O  
ATOM    863  CB  ASN A 106      31.418  17.711 -18.192  1.00 18.91           C  
ATOM    864  CG  ASN A 106      32.866  18.028 -18.536  1.00 20.79           C  
ATOM    865  OD1 ASN A 106      33.152  18.547 -19.618  1.00 22.91           O  
ATOM    866  ND2 ASN A 106      33.785  17.718 -17.623  1.00 17.05           N  
ATOM    867  N   HIS A 107      28.296  18.040 -18.250  1.00 20.96           N  
ATOM    868  CA  HIS A 107      27.008  17.508 -17.809  1.00 20.58           C  
ATOM    869  C   HIS A 107      25.762  18.210 -18.348  1.00 18.68           C  
ATOM    870  O   HIS A 107      24.640  17.769 -18.097  1.00 18.54           O  
ATOM    871  CB  HIS A 107      26.982  17.512 -16.282  1.00 20.71           C  
ATOM    872  CG  HIS A 107      28.211  16.922 -15.663  1.00 23.45           C  
ATOM    873  ND1 HIS A 107      28.482  15.570 -15.690  1.00 25.28           N  
ATOM    874  CD2 HIS A 107      29.266  17.505 -15.047  1.00 23.04           C  
ATOM    875  CE1 HIS A 107      29.652  15.347 -15.118  1.00 24.24           C  
ATOM    876  NE2 HIS A 107      30.149  16.504 -14.720  1.00 24.05           N  
ATOM    877  N   GLY A 108      25.955  19.294 -19.089  1.00 18.15           N  
ATOM    878  CA  GLY A 108      24.822  20.012 -19.637  1.00 16.99           C  
ATOM    879  C   GLY A 108      24.389  21.166 -18.754  1.00 16.99           C  
ATOM    880  O   GLY A 108      24.548  21.118 -17.532  1.00 14.83           O  
ATOM    881  N   GLU A 109      23.839  22.204 -19.372  1.00 16.88           N  
ATOM    882  CA  GLU A 109      23.386  23.379 -18.640  1.00 17.50           C  
ATOM    883  C   GLU A 109      22.258  23.088 -17.654  1.00 16.49           C  
ATOM    884  O   GLU A 109      22.190  23.703 -16.595  1.00 16.47           O  
ATOM    885  CB  GLU A 109      22.934  24.473 -19.615  1.00 18.87           C  
ATOM    886  CG  GLU A 109      24.081  25.176 -20.322  1.00 20.05           C  
ATOM    887  CD  GLU A 109      23.611  26.260 -21.274  1.00 22.96           C  
ATOM    888  OE1 GLU A 109      22.464  26.738 -21.126  1.00 26.81           O  
ATOM    889  OE2 GLU A 109      24.396  26.646 -22.162  1.00 24.19           O  
ATOM    890  N   GLU A 110      21.373  22.157 -17.996  1.00 16.39           N  
ATOM    891  CA  GLU A 110      20.255  21.832 -17.110  1.00 14.18           C  
ATOM    892  C   GLU A 110      20.749  21.282 -15.782  1.00 14.66           C  
ATOM    893  O   GLU A 110      20.324  21.737 -14.720  1.00 14.38           O  
ATOM    894  CB  GLU A 110      19.325  20.807 -17.766  1.00 15.22           C  
ATOM    895  CG  GLU A 110      18.720  21.272 -19.082  1.00 18.25           C  
ATOM    896  CD  GLU A 110      17.812  20.223 -19.701  1.00 22.11           C  
ATOM    897  OE1 GLU A 110      16.577  20.354 -19.581  1.00 24.49           O  
ATOM    898  OE2 GLU A 110      18.339  19.265 -20.301  1.00 22.65           O  
ATOM    899  N   GLN A 111      21.641  20.300 -15.845  1.00 13.59           N  
ATOM    900  CA  GLN A 111      22.188  19.687 -14.640  1.00 15.58           C  
ATOM    901  C   GLN A 111      22.936  20.697 -13.775  1.00 14.93           C  
ATOM    902  O   GLN A 111      22.839  20.667 -12.548  1.00 15.53           O  
ATOM    903  CB  GLN A 111      23.132  18.542 -15.009  1.00 15.83           C  
ATOM    904  CG  GLN A 111      23.649  17.762 -13.810  1.00 17.20           C  
ATOM    905  CD  GLN A 111      22.523  17.202 -12.955  1.00 19.08           C  
ATOM    906  OE1 GLN A 111      21.602  16.564 -13.465  1.00 19.82           O  
ATOM    907  NE2 GLN A 111      22.596  17.435 -11.650  1.00 16.66           N  
ATOM    908  N   VAL A 112      23.699  21.579 -14.412  1.00 14.01           N  
ATOM    909  CA  VAL A 112      24.447  22.584 -13.666  1.00 14.07           C  
ATOM    910  C   VAL A 112      23.490  23.551 -12.976  1.00 13.97           C  
ATOM    911  O   VAL A 112      23.729  23.963 -11.842  1.00 15.16           O  
ATOM    912  CB  VAL A 112      25.420  23.370 -14.586  1.00 12.74           C  
ATOM    913  CG1 VAL A 112      26.046  24.535 -13.821  1.00 11.67           C  
ATOM    914  CG2 VAL A 112      26.516  22.436 -15.095  1.00 12.87           C  
ATOM    915  N   ARG A 113      22.406  23.916 -13.654  1.00 15.65           N  
ATOM    916  CA  ARG A 113      21.438  24.824 -13.051  1.00 15.65           C  
ATOM    917  C   ARG A 113      20.844  24.164 -11.809  1.00 16.32           C  
ATOM    918  O   ARG A 113      20.629  24.828 -10.797  1.00 14.72           O  
ATOM    919  CB  ARG A 113      20.338  25.187 -14.055  1.00 17.44           C  
ATOM    920  CG  ARG A 113      19.216  26.053 -13.491  1.00 19.15           C  
ATOM    921  CD  ARG A 113      18.376  26.638 -14.622  1.00 22.43           C  
ATOM    922  NE  ARG A 113      17.130  27.249 -14.158  1.00 24.30           N  
ATOM    923  CZ  ARG A 113      16.069  26.563 -13.737  1.00 27.93           C  
ATOM    924  NH1 ARG A 113      16.095  25.236 -13.714  1.00 26.52           N  
ATOM    925  NH2 ARG A 113      14.973  27.205 -13.348  1.00 28.90           N  
ATOM    926  N   LEU A 114      20.588  22.859 -11.875  1.00 15.99           N  
ATOM    927  CA  LEU A 114      20.044  22.158 -10.710  1.00 16.41           C  
ATOM    928  C   LEU A 114      21.068  22.131  -9.581  1.00 15.12           C  
ATOM    929  O   LEU A 114      20.742  22.414  -8.427  1.00 13.90           O  
ATOM    930  CB  LEU A 114      19.644  20.718 -11.056  1.00 17.55           C  
ATOM    931  CG  LEU A 114      18.402  20.496 -11.922  1.00 18.85           C  
ATOM    932  CD1 LEU A 114      18.020  19.020 -11.866  1.00 20.22           C  
ATOM    933  CD2 LEU A 114      17.244  21.351 -11.417  1.00 19.95           C  
ATOM    934  N   TRP A 115      22.309  21.785  -9.903  1.00 14.77           N  
ATOM    935  CA  TRP A 115      23.345  21.749  -8.874  1.00 13.56           C  
ATOM    936  C   TRP A 115      23.482  23.095  -8.172  1.00 13.94           C  
ATOM    937  O   TRP A 115      23.557  23.163  -6.941  1.00 12.76           O  
ATOM    938  CB  TRP A 115      24.705  21.379  -9.475  1.00 13.85           C  
ATOM    939  CG  TRP A 115      24.968  19.907  -9.591  1.00 14.34           C  
ATOM    940  CD1 TRP A 115      24.594  18.929  -8.709  1.00 16.75           C  
ATOM    941  CD2 TRP A 115      25.730  19.255 -10.611  1.00 14.48           C  
ATOM    942  NE1 TRP A 115      25.077  17.708  -9.121  1.00 16.75           N  
ATOM    943  CE2 TRP A 115      25.779  17.881 -10.285  1.00 16.57           C  
ATOM    944  CE3 TRP A 115      26.381  19.699 -11.770  1.00 15.98           C  
ATOM    945  CZ2 TRP A 115      26.454  16.946 -11.079  1.00 17.04           C  
ATOM    946  CZ3 TRP A 115      27.053  18.770 -12.560  1.00 17.09           C  
ATOM    947  CH2 TRP A 115      27.082  17.408 -12.209  1.00 18.53           C  
ATOM    948  N   ARG A 116      23.510  24.165  -8.963  1.00 12.05           N  
ATOM    949  CA  ARG A 116      23.683  25.517  -8.432  1.00 11.91           C  
ATOM    950  C   ARG A 116      22.499  26.157  -7.721  1.00 12.14           C  
ATOM    951  O   ARG A 116      22.655  26.740  -6.647  1.00 12.58           O  
ATOM    952  CB  ARG A 116      24.098  26.484  -9.551  1.00 12.14           C  
ATOM    953  CG  ARG A 116      25.437  26.212 -10.230  1.00 12.04           C  
ATOM    954  CD  ARG A 116      25.648  27.245 -11.352  1.00 12.03           C  
ATOM    955  NE  ARG A 116      26.101  28.546 -10.854  1.00 10.83           N  
ATOM    956  CZ  ARG A 116      26.051  29.682 -11.551  1.00 13.80           C  
ATOM    957  NH1 ARG A 116      25.551  29.693 -12.782  1.00 11.38           N  
ATOM    958  NH2 ARG A 116      26.537  30.804 -11.037  1.00 12.55           N  
ATOM    959  N   ARG A 117      21.318  26.049  -8.317  1.00 12.53           N  
ATOM    960  CA  ARG A 117      20.148  26.714  -7.769  1.00 13.79           C  
ATOM    961  C   ARG A 117      18.991  25.887  -7.217  1.00 12.93           C  
ATOM    962  O   ARG A 117      18.117  26.445  -6.566  1.00 13.28           O  
ATOM    963  CB  ARG A 117      19.610  27.678  -8.830  1.00 13.85           C  
ATOM    964  CG  ARG A 117      20.633  28.709  -9.288  1.00 15.18           C  
ATOM    965  CD  ARG A 117      20.789  29.837  -8.273  1.00 15.73           C  
ATOM    966  NE  ARG A 117      21.901  30.711  -8.626  1.00 14.95           N  
ATOM    967  CZ  ARG A 117      23.158  30.514  -8.243  1.00 15.52           C  
ATOM    968  NH1 ARG A 117      23.471  29.474  -7.474  1.00 14.29           N  
ATOM    969  NH2 ARG A 117      24.109  31.339  -8.659  1.00 12.73           N  
ATOM    970  N   SER A 118      18.971  24.581  -7.466  1.00 13.18           N  
ATOM    971  CA  SER A 118      17.864  23.761  -6.969  1.00 12.97           C  
ATOM    972  C   SER A 118      17.857  23.756  -5.451  1.00 12.99           C  
ATOM    973  O   SER A 118      18.845  24.109  -4.812  1.00 12.92           O  
ATOM    974  CB  SER A 118      17.963  22.320  -7.479  1.00 12.08           C  
ATOM    975  OG  SER A 118      18.982  21.608  -6.802  1.00 15.18           O  
ATOM    976  N   TYR A 119      16.735  23.341  -4.877  1.00 13.79           N  
ATOM    977  CA  TYR A 119      16.604  23.301  -3.432  1.00 14.09           C  
ATOM    978  C   TYR A 119      17.019  21.951  -2.859  1.00 14.26           C  
ATOM    979  O   TYR A 119      17.724  21.887  -1.856  1.00 13.55           O  
ATOM    980  CB  TYR A 119      15.151  23.588  -3.037  1.00 14.63           C  
ATOM    981  CG  TYR A 119      14.911  23.682  -1.544  1.00 15.86           C  
ATOM    982  CD1 TYR A 119      15.593  24.614  -0.767  1.00 13.94           C  
ATOM    983  CD2 TYR A 119      13.976  22.857  -0.913  1.00 17.04           C  
ATOM    984  CE1 TYR A 119      15.350  24.730   0.605  1.00 17.98           C  
ATOM    985  CE2 TYR A 119      13.723  22.962   0.457  1.00 17.99           C  
ATOM    986  CZ  TYR A 119      14.412  23.902   1.207  1.00 16.94           C  
ATOM    987  OH  TYR A 119      14.159  24.022   2.551  1.00 18.67           O  
ATOM    988  N   ASN A 120      16.599  20.875  -3.516  1.00 14.80           N  
ATOM    989  CA  ASN A 120      16.868  19.532  -3.023  1.00 16.12           C  
ATOM    990  C   ASN A 120      18.057  18.758  -3.569  1.00 15.81           C  
ATOM    991  O   ASN A 120      18.462  17.764  -2.965  1.00 18.18           O  
ATOM    992  CB  ASN A 120      15.613  18.669  -3.195  1.00 17.87           C  
ATOM    993  CG  ASN A 120      14.374  19.324  -2.616  1.00 21.02           C  
ATOM    994  OD1 ASN A 120      13.535  19.855  -3.349  1.00 21.20           O  
ATOM    995  ND2 ASN A 120      14.262  19.306  -1.295  1.00 16.50           N  
ATOM    996  N   VAL A 121      18.621  19.179  -4.696  1.00 13.94           N  
ATOM    997  CA  VAL A 121      19.747  18.436  -5.258  1.00 14.29           C  
ATOM    998  C   VAL A 121      21.016  18.600  -4.419  1.00 14.32           C  
ATOM    999  O   VAL A 121      21.433  19.715  -4.094  1.00 15.08           O  
ATOM   1000  CB  VAL A 121      20.006  18.848  -6.728  1.00 14.62           C  
ATOM   1001  CG1 VAL A 121      21.184  18.068  -7.303  1.00 15.64           C  
ATOM   1002  CG2 VAL A 121      18.755  18.572  -7.553  1.00 15.48           C  
ATOM   1003  N   THR A 122      21.606  17.465  -4.057  1.00 14.98           N  
ATOM   1004  CA  THR A 122      22.811  17.419  -3.241  1.00 15.20           C  
ATOM   1005  C   THR A 122      24.047  17.153  -4.086  1.00 15.45           C  
ATOM   1006  O   THR A 122      24.096  16.179  -4.840  1.00 16.36           O  
ATOM   1007  CB  THR A 122      22.708  16.292  -2.190  1.00 15.93           C  
ATOM   1008  OG1 THR A 122      21.508  16.459  -1.426  1.00 16.96           O  
ATOM   1009  CG2 THR A 122      23.911  16.310  -1.257  1.00 16.95           C  
ATOM   1010  N   PRO A 123      25.066  18.017  -3.984  1.00 16.51           N  
ATOM   1011  CA  PRO A 123      26.266  17.769  -4.784  1.00 16.64           C  
ATOM   1012  C   PRO A 123      27.004  16.543  -4.247  1.00 17.80           C  
ATOM   1013  O   PRO A 123      26.817  16.154  -3.093  1.00 16.12           O  
ATOM   1014  CB  PRO A 123      27.073  19.063  -4.617  1.00 17.12           C  
ATOM   1015  CG  PRO A 123      26.622  19.588  -3.286  1.00 20.96           C  
ATOM   1016  CD  PRO A 123      25.140  19.316  -3.290  1.00 16.83           C  
ATOM   1017  N   PRO A 124      27.830  15.900  -5.086  1.00 18.50           N  
ATOM   1018  CA  PRO A 124      28.566  14.725  -4.613  1.00 19.54           C  
ATOM   1019  C   PRO A 124      29.414  15.164  -3.423  1.00 20.67           C  
ATOM   1020  O   PRO A 124      29.952  16.270  -3.423  1.00 20.37           O  
ATOM   1021  CB  PRO A 124      29.423  14.344  -5.815  1.00 20.40           C  
ATOM   1022  CG  PRO A 124      28.599  14.819  -6.986  1.00 24.53           C  
ATOM   1023  CD  PRO A 124      28.114  16.168  -6.506  1.00 18.89           C  
ATOM   1024  N   PRO A 125      29.527  14.316  -2.391  1.00 20.70           N  
ATOM   1025  CA  PRO A 125      30.320  14.649  -1.202  1.00 21.18           C  
ATOM   1026  C   PRO A 125      31.807  14.785  -1.512  1.00 20.88           C  
ATOM   1027  O   PRO A 125      32.329  14.106  -2.401  1.00 19.60           O  
ATOM   1028  CB  PRO A 125      30.048  13.475  -0.263  1.00 22.32           C  
ATOM   1029  CG  PRO A 125      28.699  12.989  -0.691  1.00 24.58           C  
ATOM   1030  CD  PRO A 125      28.791  13.058  -2.192  1.00 23.29           C  
ATOM   1031  N   ILE A 126      32.487  15.661  -0.779  1.00 20.14           N  
ATOM   1032  CA  ILE A 126      33.918  15.852  -0.979  1.00 19.77           C  
ATOM   1033  C   ILE A 126      34.641  14.672  -0.327  1.00 21.74           C  
ATOM   1034  O   ILE A 126      34.290  14.246   0.777  1.00 20.59           O  
ATOM   1035  CB  ILE A 126      34.402  17.186  -0.361  1.00 19.54           C  
ATOM   1036  CG1 ILE A 126      35.873  17.423  -0.722  1.00 19.85           C  
ATOM   1037  CG2 ILE A 126      34.207  17.171   1.150  1.00 20.40           C  
ATOM   1038  CD1 ILE A 126      36.404  18.774  -0.283  1.00 18.35           C  
ATOM   1039  N   GLU A 127      35.634  14.137  -1.029  1.00 22.79           N  
ATOM   1040  CA  GLU A 127      36.405  12.994  -0.544  1.00 26.25           C  
ATOM   1041  C   GLU A 127      37.748  13.449   0.019  1.00 24.97           C  
ATOM   1042  O   GLU A 127      38.243  14.522  -0.324  1.00 22.85           O  
ATOM   1043  CB  GLU A 127      36.644  12.010  -1.694  1.00 28.44           C  
ATOM   1044  CG  GLU A 127      35.371  11.537  -2.380  1.00 35.40           C  
ATOM   1045  CD  GLU A 127      34.718  10.369  -1.668  1.00 37.69           C  
ATOM   1046  OE1 GLU A 127      35.214   9.230  -1.818  1.00 41.03           O  
ATOM   1047  OE2 GLU A 127      33.717  10.587  -0.955  1.00 39.81           O  
ATOM   1048  N   GLU A 128      38.340  12.626   0.879  1.00 25.27           N  
ATOM   1049  CA  GLU A 128      39.630  12.956   1.472  1.00 27.04           C  
ATOM   1050  C   GLU A 128      40.706  13.131   0.408  1.00 25.88           C  
ATOM   1051  O   GLU A 128      41.692  13.834   0.621  1.00 26.97           O  
ATOM   1052  CB  GLU A 128      40.054  11.868   2.458  1.00 29.17           C  
ATOM   1053  CG  GLU A 128      39.292  11.897   3.769  1.00 34.09           C  
ATOM   1054  CD  GLU A 128      39.729  10.797   4.716  1.00 37.68           C  
ATOM   1055  OE1 GLU A 128      40.953  10.610   4.886  1.00 39.72           O  
ATOM   1056  OE2 GLU A 128      38.849  10.124   5.292  1.00 40.16           O  
ATOM   1057  N   SER A 129      40.511  12.491  -0.739  1.00 24.88           N  
ATOM   1058  CA  SER A 129      41.470  12.584  -1.832  1.00 24.86           C  
ATOM   1059  C   SER A 129      41.322  13.903  -2.585  1.00 23.75           C  
ATOM   1060  O   SER A 129      42.185  14.270  -3.381  1.00 23.75           O  
ATOM   1061  CB  SER A 129      41.276  11.417  -2.805  1.00 25.60           C  
ATOM   1062  OG  SER A 129      39.977  11.436  -3.365  1.00 28.49           O  
ATOM   1063  N   HIS A 130      40.228  14.613  -2.327  1.00 22.44           N  
ATOM   1064  CA  HIS A 130      39.977  15.889  -2.988  1.00 22.05           C  
ATOM   1065  C   HIS A 130      41.101  16.873  -2.667  1.00 21.46           C  
ATOM   1066  O   HIS A 130      41.555  16.957  -1.530  1.00 22.33           O  
ATOM   1067  CB  HIS A 130      38.623  16.448  -2.533  1.00 20.02           C  
ATOM   1068  CG  HIS A 130      38.116  17.576  -3.379  1.00 21.25           C  
ATOM   1069  ND1 HIS A 130      38.614  18.859  -3.292  1.00 21.10           N  
ATOM   1070  CD2 HIS A 130      37.147  17.612  -4.325  1.00 20.04           C  
ATOM   1071  CE1 HIS A 130      37.972  19.636  -4.146  1.00 19.53           C  
ATOM   1072  NE2 HIS A 130      37.078  18.905  -4.785  1.00 18.64           N  
ATOM   1073  N   PRO A 131      41.564  17.629  -3.674  1.00 22.15           N  
ATOM   1074  CA  PRO A 131      42.640  18.618  -3.545  1.00 22.57           C  
ATOM   1075  C   PRO A 131      42.462  19.660  -2.439  1.00 22.64           C  
ATOM   1076  O   PRO A 131      43.444  20.127  -1.855  1.00 21.87           O  
ATOM   1077  CB  PRO A 131      42.681  19.262  -4.929  1.00 23.93           C  
ATOM   1078  CG  PRO A 131      42.257  18.154  -5.824  1.00 26.10           C  
ATOM   1079  CD  PRO A 131      41.097  17.556  -5.070  1.00 23.03           C  
ATOM   1080  N   TYR A 132      41.222  20.029  -2.142  1.00 19.68           N  
ATOM   1081  CA  TYR A 132      40.996  21.034  -1.115  1.00 21.56           C  
ATOM   1082  C   TYR A 132      40.386  20.518   0.186  1.00 21.47           C  
ATOM   1083  O   TYR A 132      39.978  21.307   1.039  1.00 20.96           O  
ATOM   1084  CB  TYR A 132      40.145  22.169  -1.691  1.00 22.51           C  
ATOM   1085  CG  TYR A 132      40.812  22.851  -2.865  1.00 24.23           C  
ATOM   1086  CD1 TYR A 132      40.689  22.341  -4.157  1.00 26.43           C  
ATOM   1087  CD2 TYR A 132      41.625  23.968  -2.674  1.00 25.69           C  
ATOM   1088  CE1 TYR A 132      41.365  22.926  -5.232  1.00 28.52           C  
ATOM   1089  CE2 TYR A 132      42.308  24.556  -3.737  1.00 27.48           C  
ATOM   1090  CZ  TYR A 132      42.175  24.032  -5.012  1.00 28.96           C  
ATOM   1091  OH  TYR A 132      42.868  24.597  -6.060  1.00 30.41           O  
ATOM   1092  N   TYR A 133      40.349  19.198   0.351  1.00 21.07           N  
ATOM   1093  CA  TYR A 133      39.788  18.599   1.558  1.00 22.14           C  
ATOM   1094  C   TYR A 133      40.571  18.935   2.826  1.00 24.42           C  
ATOM   1095  O   TYR A 133      40.010  19.453   3.790  1.00 23.70           O  
ATOM   1096  CB  TYR A 133      39.720  17.076   1.424  1.00 21.89           C  
ATOM   1097  CG  TYR A 133      39.114  16.398   2.636  1.00 22.18           C  
ATOM   1098  CD1 TYR A 133      37.751  16.107   2.688  1.00 22.92           C  
ATOM   1099  CD2 TYR A 133      39.900  16.072   3.742  1.00 22.85           C  
ATOM   1100  CE1 TYR A 133      37.184  15.509   3.808  1.00 23.22           C  
ATOM   1101  CE2 TYR A 133      39.342  15.474   4.871  1.00 25.05           C  
ATOM   1102  CZ  TYR A 133      37.983  15.195   4.896  1.00 25.95           C  
ATOM   1103  OH  TYR A 133      37.424  14.601   6.008  1.00 25.37           O  
ATOM   1104  N   GLN A 134      41.864  18.622   2.834  1.00 25.83           N  
ATOM   1105  CA  GLN A 134      42.698  18.887   4.003  1.00 28.45           C  
ATOM   1106  C   GLN A 134      42.665  20.343   4.453  1.00 27.53           C  
ATOM   1107  O   GLN A 134      42.456  20.628   5.633  1.00 27.41           O  
ATOM   1108  CB  GLN A 134      44.146  18.464   3.730  1.00 31.45           C  
ATOM   1109  CG  GLN A 134      44.345  16.957   3.685  1.00 37.19           C  
ATOM   1110  CD  GLN A 134      44.018  16.284   5.011  1.00 42.15           C  
ATOM   1111  OE1 GLN A 134      42.911  16.425   5.538  1.00 44.74           O  
ATOM   1112  NE2 GLN A 134      44.981  15.543   5.554  1.00 43.53           N  
ATOM   1113  N   GLU A 135      42.871  21.257   3.510  1.00 28.07           N  
ATOM   1114  CA  GLU A 135      42.875  22.687   3.801  1.00 27.96           C  
ATOM   1115  C   GLU A 135      41.608  23.114   4.539  1.00 26.93           C  
ATOM   1116  O   GLU A 135      41.624  24.049   5.342  1.00 26.06           O  
ATOM   1117  CB  GLU A 135      42.994  23.482   2.498  1.00 31.16           C  
ATOM   1118  CG  GLU A 135      43.259  24.962   2.698  1.00 37.32           C  
ATOM   1119  CD  GLU A 135      43.208  25.746   1.398  1.00 40.24           C  
ATOM   1120  OE1 GLU A 135      43.875  25.332   0.423  1.00 42.25           O  
ATOM   1121  OE2 GLU A 135      42.506  26.779   1.356  1.00 40.82           O  
ATOM   1122  N   ILE A 136      40.511  22.419   4.265  1.00 23.69           N  
ATOM   1123  CA  ILE A 136      39.236  22.731   4.893  1.00 23.68           C  
ATOM   1124  C   ILE A 136      39.059  22.117   6.277  1.00 24.42           C  
ATOM   1125  O   ILE A 136      38.889  22.831   7.262  1.00 25.64           O  
ATOM   1126  CB  ILE A 136      38.053  22.268   4.002  1.00 20.83           C  
ATOM   1127  CG1 ILE A 136      38.019  23.092   2.714  1.00 20.11           C  
ATOM   1128  CG2 ILE A 136      36.739  22.387   4.766  1.00 21.80           C  
ATOM   1129  CD1 ILE A 136      36.985  22.617   1.700  1.00 20.66           C  
ATOM   1130  N   TYR A 137      39.116  20.792   6.353  1.00 24.25           N  
ATOM   1131  CA  TYR A 137      38.890  20.108   7.619  1.00 25.92           C  
ATOM   1132  C   TYR A 137      40.015  20.061   8.650  1.00 26.81           C  
ATOM   1133  O   TYR A 137      39.821  19.530   9.745  1.00 28.03           O  
ATOM   1134  CB  TYR A 137      38.375  18.695   7.346  1.00 25.60           C  
ATOM   1135  CG  TYR A 137      37.074  18.694   6.572  1.00 25.37           C  
ATOM   1136  CD1 TYR A 137      37.069  18.693   5.176  1.00 23.65           C  
ATOM   1137  CD2 TYR A 137      35.847  18.758   7.234  1.00 23.99           C  
ATOM   1138  CE1 TYR A 137      35.873  18.757   4.458  1.00 23.36           C  
ATOM   1139  CE2 TYR A 137      34.646  18.823   6.529  1.00 22.86           C  
ATOM   1140  CZ  TYR A 137      34.666  18.824   5.141  1.00 22.93           C  
ATOM   1141  OH  TYR A 137      33.481  18.898   4.440  1.00 19.27           O  
ATOM   1142  N   ASN A 138      41.180  20.605   8.319  1.00 26.87           N  
ATOM   1143  CA  ASN A 138      42.279  20.612   9.279  1.00 27.95           C  
ATOM   1144  C   ASN A 138      42.365  21.958   9.988  1.00 25.74           C  
ATOM   1145  O   ASN A 138      43.215  22.157  10.853  1.00 26.50           O  
ATOM   1146  CB  ASN A 138      43.619  20.314   8.597  1.00 31.02           C  
ATOM   1147  CG  ASN A 138      43.798  18.840   8.276  1.00 35.21           C  
ATOM   1148  OD1 ASN A 138      43.432  17.970   9.069  1.00 37.03           O  
ATOM   1149  ND2 ASN A 138      44.381  18.554   7.118  1.00 38.92           N  
ATOM   1150  N   ASP A 139      41.478  22.881   9.629  1.00 22.96           N  
ATOM   1151  CA  ASP A 139      41.486  24.199  10.250  1.00 20.21           C  
ATOM   1152  C   ASP A 139      40.810  24.164  11.617  1.00 15.99           C  
ATOM   1153  O   ASP A 139      39.735  23.591  11.775  1.00 17.12           O  
ATOM   1154  CB  ASP A 139      40.796  25.221   9.344  1.00 20.65           C  
ATOM   1155  CG  ASP A 139      41.039  26.644   9.795  1.00 20.77           C  
ATOM   1156  OD1 ASP A 139      40.547  27.016  10.881  1.00 20.36           O  
ATOM   1157  OD2 ASP A 139      41.735  27.389   9.071  1.00 23.77           O  
ATOM   1158  N   ARG A 140      41.453  24.784  12.599  1.00 15.25           N  
ATOM   1159  CA  ARG A 140      40.955  24.827  13.972  1.00 14.03           C  
ATOM   1160  C   ARG A 140      39.557  25.423  14.127  1.00 14.26           C  
ATOM   1161  O   ARG A 140      38.825  25.059  15.049  1.00 13.34           O  
ATOM   1162  CB  ARG A 140      41.951  25.602  14.851  1.00 14.25           C  
ATOM   1163  CG  ARG A 140      41.588  25.663  16.329  1.00 14.76           C  
ATOM   1164  CD  ARG A 140      42.718  26.287  17.145  1.00 15.06           C  
ATOM   1165  NE  ARG A 140      42.992  27.679  16.777  1.00 14.78           N  
ATOM   1166  CZ  ARG A 140      42.646  28.733  17.512  1.00 14.91           C  
ATOM   1167  NH1 ARG A 140      42.008  28.564  18.659  1.00 15.61           N  
ATOM   1168  NH2 ARG A 140      42.950  29.958  17.108  1.00 13.19           N  
ATOM   1169  N   ARG A 141      39.169  26.328  13.231  1.00 13.48           N  
ATOM   1170  CA  ARG A 141      37.847  26.941  13.347  1.00 14.25           C  
ATOM   1171  C   ARG A 141      36.728  25.900  13.320  1.00 14.82           C  
ATOM   1172  O   ARG A 141      35.658  26.117  13.892  1.00 16.93           O  
ATOM   1173  CB  ARG A 141      37.638  27.983  12.238  1.00 15.33           C  
ATOM   1174  CG  ARG A 141      37.345  27.418  10.860  1.00 13.37           C  
ATOM   1175  CD  ARG A 141      37.538  28.500   9.797  1.00 16.84           C  
ATOM   1176  NE  ARG A 141      38.952  28.837   9.637  1.00 14.38           N  
ATOM   1177  CZ  ARG A 141      39.413  29.828   8.879  1.00 18.73           C  
ATOM   1178  NH1 ARG A 141      38.572  30.601   8.203  1.00 13.06           N  
ATOM   1179  NH2 ARG A 141      40.721  30.039   8.786  1.00 17.94           N  
ATOM   1180  N   TYR A 142      36.979  24.763  12.679  1.00 16.56           N  
ATOM   1181  CA  TYR A 142      35.972  23.708  12.600  1.00 18.22           C  
ATOM   1182  C   TYR A 142      36.119  22.677  13.713  1.00 21.77           C  
ATOM   1183  O   TYR A 142      35.402  21.676  13.745  1.00 23.17           O  
ATOM   1184  CB  TYR A 142      36.029  23.028  11.231  1.00 17.16           C  
ATOM   1185  CG  TYR A 142      35.729  23.987  10.105  1.00 16.59           C  
ATOM   1186  CD1 TYR A 142      34.532  24.704  10.083  1.00 17.14           C  
ATOM   1187  CD2 TYR A 142      36.654  24.219   9.092  1.00 16.48           C  
ATOM   1188  CE1 TYR A 142      34.270  25.636   9.085  1.00 16.57           C  
ATOM   1189  CE2 TYR A 142      36.403  25.152   8.083  1.00 17.75           C  
ATOM   1190  CZ  TYR A 142      35.208  25.856   8.092  1.00 16.52           C  
ATOM   1191  OH  TYR A 142      34.953  26.790   7.121  1.00 15.24           O  
ATOM   1192  N   LYS A 143      37.054  22.923  14.623  1.00 22.72           N  
ATOM   1193  CA  LYS A 143      37.265  22.024  15.747  1.00 24.69           C  
ATOM   1194  C   LYS A 143      36.553  22.588  16.965  1.00 24.64           C  
ATOM   1195  O   LYS A 143      36.358  21.892  17.963  1.00 26.06           O  
ATOM   1196  CB  LYS A 143      38.758  21.866  16.050  1.00 26.27           C  
ATOM   1197  CG  LYS A 143      39.527  21.101  14.989  1.00 27.49           C  
ATOM   1198  CD  LYS A 143      40.938  20.771  15.453  1.00 28.59           C  
ATOM   1199  CE  LYS A 143      41.674  19.928  14.422  1.00 28.41           C  
ATOM   1200  NZ  LYS A 143      41.938  20.679  13.160  1.00 32.19           N  
ATOM   1201  N   VAL A 144      36.154  23.853  16.872  1.00 23.58           N  
ATOM   1202  CA  VAL A 144      35.469  24.515  17.973  1.00 23.29           C  
ATOM   1203  C   VAL A 144      34.050  24.956  17.620  1.00 23.11           C  
ATOM   1204  O   VAL A 144      33.526  25.897  18.210  1.00 20.94           O  
ATOM   1205  CB  VAL A 144      36.277  25.740  18.477  1.00 24.50           C  
ATOM   1206  CG1 VAL A 144      37.659  25.290  18.926  1.00 23.64           C  
ATOM   1207  CG2 VAL A 144      36.398  26.796  17.375  1.00 24.24           C  
ATOM   1208  N   CYS A 145      33.432  24.283  16.653  1.00 23.11           N  
ATOM   1209  CA  CYS A 145      32.060  24.608  16.265  1.00 24.60           C  
ATOM   1210  C   CYS A 145      31.116  23.928  17.245  1.00 24.86           C  
ATOM   1211  O   CYS A 145      31.551  23.118  18.066  1.00 25.18           O  
ATOM   1212  CB  CYS A 145      31.756  24.106  14.852  1.00 23.07           C  
ATOM   1213  SG  CYS A 145      32.586  25.013  13.550  1.00 27.98           S  
ATOM   1214  N   ASP A 146      29.828  24.259  17.166  1.00 23.90           N  
ATOM   1215  CA  ASP A 146      28.838  23.648  18.048  1.00 23.92           C  
ATOM   1216  C   ASP A 146      28.500  22.245  17.554  1.00 24.28           C  
ATOM   1217  O   ASP A 146      27.587  21.591  18.059  1.00 26.94           O  
ATOM   1218  CB  ASP A 146      27.570  24.507  18.115  1.00 22.74           C  
ATOM   1219  CG  ASP A 146      26.934  24.723  16.758  1.00 22.17           C  
ATOM   1220  OD1 ASP A 146      27.433  24.163  15.761  1.00 20.29           O  
ATOM   1221  OD2 ASP A 146      25.928  25.460  16.694  1.00 24.04           O  
ATOM   1222  N   VAL A 147      29.245  21.797  16.552  1.00 25.36           N  
ATOM   1223  CA  VAL A 147      29.078  20.471  15.971  1.00 26.28           C  
ATOM   1224  C   VAL A 147      30.476  19.897  15.755  1.00 26.60           C  
ATOM   1225  O   VAL A 147      31.362  20.581  15.239  1.00 25.61           O  
ATOM   1226  CB  VAL A 147      28.350  20.536  14.611  1.00 27.82           C  
ATOM   1227  CG1 VAL A 147      28.248  19.142  14.002  1.00 28.08           C  
ATOM   1228  CG2 VAL A 147      26.969  21.137  14.792  1.00 27.58           C  
ATOM   1229  N   PRO A 148      30.696  18.636  16.161  1.00 26.40           N  
ATOM   1230  CA  PRO A 148      31.999  17.984  16.005  1.00 26.29           C  
ATOM   1231  C   PRO A 148      32.525  18.031  14.571  1.00 25.86           C  
ATOM   1232  O   PRO A 148      31.753  17.992  13.611  1.00 24.81           O  
ATOM   1233  CB  PRO A 148      31.726  16.559  16.475  1.00 27.48           C  
ATOM   1234  CG  PRO A 148      30.693  16.765  17.542  1.00 27.57           C  
ATOM   1235  CD  PRO A 148      29.759  17.763  16.891  1.00 26.44           C  
ATOM   1236  N   LEU A 149      33.845  18.106  14.437  1.00 25.51           N  
ATOM   1237  CA  LEU A 149      34.487  18.160  13.128  1.00 28.67           C  
ATOM   1238  C   LEU A 149      34.010  17.053  12.187  1.00 30.05           C  
ATOM   1239  O   LEU A 149      33.682  17.310  11.029  1.00 31.74           O  
ATOM   1240  CB  LEU A 149      36.009  18.068  13.290  1.00 26.61           C  
ATOM   1241  CG  LEU A 149      36.827  17.954  12.000  1.00 25.58           C  
ATOM   1242  CD1 LEU A 149      36.626  19.198  11.144  1.00 25.02           C  
ATOM   1243  CD2 LEU A 149      38.294  17.771  12.343  1.00 24.98           C  
ATOM   1244  N   ASP A 150      33.968  15.826  12.694  1.00 32.72           N  
ATOM   1245  CA  ASP A 150      33.558  14.675  11.896  1.00 33.71           C  
ATOM   1246  C   ASP A 150      32.075  14.681  11.522  1.00 32.77           C  
ATOM   1247  O   ASP A 150      31.642  13.900  10.671  1.00 31.85           O  
ATOM   1248  CB  ASP A 150      33.889  13.382  12.645  1.00 37.63           C  
ATOM   1249  CG  ASP A 150      33.016  13.179  13.870  1.00 41.29           C  
ATOM   1250  OD1 ASP A 150      32.960  14.091  14.723  1.00 43.78           O  
ATOM   1251  OD2 ASP A 150      32.387  12.106  13.982  1.00 45.05           O  
ATOM   1252  N   GLN A 151      31.299  15.555  12.154  1.00 30.87           N  
ATOM   1253  CA  GLN A 151      29.871  15.632  11.869  1.00 29.77           C  
ATOM   1254  C   GLN A 151      29.477  16.807  10.973  1.00 27.14           C  
ATOM   1255  O   GLN A 151      28.299  16.987  10.664  1.00 27.88           O  
ATOM   1256  CB  GLN A 151      29.077  15.667  13.179  1.00 32.90           C  
ATOM   1257  CG  GLN A 151      28.974  14.302  13.851  1.00 37.96           C  
ATOM   1258  CD  GLN A 151      28.331  14.357  15.224  1.00 41.37           C  
ATOM   1259  OE1 GLN A 151      28.898  14.914  16.164  1.00 44.29           O  
ATOM   1260  NE2 GLN A 151      27.144  13.776  15.348  1.00 43.21           N  
ATOM   1261  N   LEU A 152      30.454  17.607  10.556  1.00 23.57           N  
ATOM   1262  CA  LEU A 152      30.168  18.734   9.670  1.00 21.75           C  
ATOM   1263  C   LEU A 152      29.887  18.173   8.275  1.00 20.60           C  
ATOM   1264  O   LEU A 152      30.410  17.123   7.905  1.00 20.94           O  
ATOM   1265  CB  LEU A 152      31.360  19.701   9.621  1.00 20.05           C  
ATOM   1266  CG  LEU A 152      31.593  20.579  10.858  1.00 18.83           C  
ATOM   1267  CD1 LEU A 152      32.937  21.287  10.752  1.00 17.94           C  
ATOM   1268  CD2 LEU A 152      30.469  21.596  10.987  1.00 18.29           C  
ATOM   1269  N   PRO A 153      29.064  18.868   7.479  1.00 19.44           N  
ATOM   1270  CA  PRO A 153      28.748  18.383   6.134  1.00 20.07           C  
ATOM   1271  C   PRO A 153      29.943  18.237   5.194  1.00 19.23           C  
ATOM   1272  O   PRO A 153      30.970  18.902   5.356  1.00 17.19           O  
ATOM   1273  CB  PRO A 153      27.739  19.412   5.628  1.00 19.02           C  
ATOM   1274  CG  PRO A 153      28.208  20.675   6.287  1.00 21.13           C  
ATOM   1275  CD  PRO A 153      28.485  20.207   7.701  1.00 19.93           C  
ATOM   1276  N   ARG A 154      29.792  17.339   4.224  1.00 18.18           N  
ATOM   1277  CA  ARG A 154      30.811  17.091   3.211  1.00 19.79           C  
ATOM   1278  C   ARG A 154      30.250  17.560   1.864  1.00 18.35           C  
ATOM   1279  O   ARG A 154      30.920  17.502   0.835  1.00 19.36           O  
ATOM   1280  CB  ARG A 154      31.171  15.602   3.174  1.00 21.51           C  
ATOM   1281  CG  ARG A 154      32.418  15.235   3.988  1.00 23.06           C  
ATOM   1282  CD  ARG A 154      32.342  15.661   5.456  1.00 24.00           C  
ATOM   1283  NE  ARG A 154      33.566  15.296   6.172  1.00 24.41           N  
ATOM   1284  CZ  ARG A 154      33.838  15.615   7.438  1.00 26.36           C  
ATOM   1285  NH1 ARG A 154      32.974  16.315   8.162  1.00 26.55           N  
ATOM   1286  NH2 ARG A 154      34.988  15.238   7.978  1.00 26.34           N  
ATOM   1287  N   SER A 155      28.998  18.014   1.902  1.00 17.95           N  
ATOM   1288  CA  SER A 155      28.281  18.568   0.750  1.00 15.74           C  
ATOM   1289  C   SER A 155      26.895  18.949   1.264  1.00 14.76           C  
ATOM   1290  O   SER A 155      26.425  18.397   2.262  1.00 13.55           O  
ATOM   1291  CB  SER A 155      28.170  17.564  -0.406  1.00 16.88           C  
ATOM   1292  OG  SER A 155      27.233  16.543  -0.137  1.00 19.93           O  
ATOM   1293  N   GLU A 156      26.247  19.895   0.595  1.00 14.03           N  
ATOM   1294  CA  GLU A 156      24.934  20.354   1.028  1.00 13.96           C  
ATOM   1295  C   GLU A 156      24.004  20.782  -0.095  1.00 14.53           C  
ATOM   1296  O   GLU A 156      24.420  21.444  -1.047  1.00 13.39           O  
ATOM   1297  CB  GLU A 156      25.070  21.567   1.958  1.00 13.78           C  
ATOM   1298  CG  GLU A 156      25.759  21.343   3.287  1.00 11.94           C  
ATOM   1299  CD  GLU A 156      25.929  22.648   4.043  1.00 13.67           C  
ATOM   1300  OE1 GLU A 156      25.484  22.739   5.207  1.00 13.00           O  
ATOM   1301  OE2 GLU A 156      26.512  23.589   3.461  1.00 13.21           O  
ATOM   1302  N   SER A 157      22.738  20.408   0.037  1.00 15.33           N  
ATOM   1303  CA  SER A 157      21.724  20.836  -0.911  1.00 14.69           C  
ATOM   1304  C   SER A 157      21.324  22.166  -0.272  1.00 13.24           C  
ATOM   1305  O   SER A 157      21.698  22.427   0.874  1.00 13.11           O  
ATOM   1306  CB  SER A 157      20.538  19.874  -0.904  1.00 15.49           C  
ATOM   1307  OG  SER A 157      19.896  19.873   0.360  1.00 16.37           O  
ATOM   1308  N   LEU A 158      20.592  23.012  -0.982  1.00 11.47           N  
ATOM   1309  CA  LEU A 158      20.195  24.280  -0.388  1.00 13.65           C  
ATOM   1310  C   LEU A 158      19.323  23.985   0.833  1.00 12.87           C  
ATOM   1311  O   LEU A 158      19.338  24.725   1.818  1.00 12.96           O  
ATOM   1312  CB  LEU A 158      19.428  25.140  -1.397  1.00 11.52           C  
ATOM   1313  CG  LEU A 158      19.175  26.587  -0.950  1.00 12.74           C  
ATOM   1314  CD1 LEU A 158      20.498  27.293  -0.695  1.00 12.48           C  
ATOM   1315  CD2 LEU A 158      18.383  27.326  -2.023  1.00 13.81           C  
ATOM   1316  N   LYS A 159      18.569  22.891   0.762  1.00 13.18           N  
ATOM   1317  CA  LYS A 159      17.712  22.488   1.870  1.00 14.33           C  
ATOM   1318  C   LYS A 159      18.585  22.184   3.089  1.00 13.31           C  
ATOM   1319  O   LYS A 159      18.249  22.572   4.213  1.00 13.30           O  
ATOM   1320  CB  LYS A 159      16.880  21.259   1.483  1.00 15.58           C  
ATOM   1321  CG  LYS A 159      15.912  20.797   2.563  1.00 18.58           C  
ATOM   1322  CD  LYS A 159      15.093  19.606   2.087  1.00 21.35           C  
ATOM   1323  CE  LYS A 159      14.194  19.069   3.193  1.00 23.87           C  
ATOM   1324  NZ  LYS A 159      13.395  17.900   2.727  1.00 27.67           N  
ATOM   1325  N   ASP A 160      19.710  21.504   2.867  1.00 13.00           N  
ATOM   1326  CA  ASP A 160      20.633  21.192   3.962  1.00 13.10           C  
ATOM   1327  C   ASP A 160      21.133  22.493   4.601  1.00 14.22           C  
ATOM   1328  O   ASP A 160      21.226  22.604   5.828  1.00 12.13           O  
ATOM   1329  CB  ASP A 160      21.849  20.393   3.462  1.00 14.97           C  
ATOM   1330  CG  ASP A 160      21.516  18.944   3.114  1.00 16.31           C  
ATOM   1331  OD1 ASP A 160      20.681  18.323   3.809  1.00 15.84           O  
ATOM   1332  OD2 ASP A 160      22.114  18.414   2.154  1.00 16.44           O  
ATOM   1333  N   VAL A 161      21.466  23.474   3.766  1.00 13.44           N  
ATOM   1334  CA  VAL A 161      21.945  24.758   4.266  1.00 13.23           C  
ATOM   1335  C   VAL A 161      20.907  25.388   5.189  1.00 13.36           C  
ATOM   1336  O   VAL A 161      21.219  25.777   6.319  1.00 12.49           O  
ATOM   1337  CB  VAL A 161      22.241  25.754   3.111  1.00 13.37           C  
ATOM   1338  CG1 VAL A 161      22.627  27.117   3.680  1.00 11.52           C  
ATOM   1339  CG2 VAL A 161      23.363  25.213   2.228  1.00 11.30           C  
ATOM   1340  N   LEU A 162      19.671  25.489   4.712  1.00 12.62           N  
ATOM   1341  CA  LEU A 162      18.624  26.093   5.522  1.00 12.72           C  
ATOM   1342  C   LEU A 162      18.454  25.359   6.846  1.00 12.51           C  
ATOM   1343  O   LEU A 162      18.245  25.986   7.886  1.00 12.42           O  
ATOM   1344  CB  LEU A 162      17.294  26.121   4.765  1.00 12.69           C  
ATOM   1345  CG  LEU A 162      16.142  26.759   5.552  1.00 12.62           C  
ATOM   1346  CD1 LEU A 162      16.511  28.182   5.967  1.00 15.40           C  
ATOM   1347  CD2 LEU A 162      14.882  26.762   4.700  1.00 18.12           C  
ATOM   1348  N   GLU A 163      18.560  24.033   6.819  1.00 13.59           N  
ATOM   1349  CA  GLU A 163      18.406  23.265   8.047  1.00 14.37           C  
ATOM   1350  C   GLU A 163      19.478  23.572   9.094  1.00 13.14           C  
ATOM   1351  O   GLU A 163      19.198  23.490  10.290  1.00 14.15           O  
ATOM   1352  CB  GLU A 163      18.354  21.763   7.739  1.00 16.35           C  
ATOM   1353  CG  GLU A 163      17.227  21.411   6.769  1.00 21.44           C  
ATOM   1354  CD  GLU A 163      16.891  19.930   6.733  1.00 24.48           C  
ATOM   1355  OE1 GLU A 163      17.816  19.103   6.874  1.00 24.18           O  
ATOM   1356  OE2 GLU A 163      15.697  19.600   6.542  1.00 25.00           O  
ATOM   1357  N   ARG A 164      20.695  23.927   8.680  1.00 11.92           N  
ATOM   1358  CA  ARG A 164      21.712  24.257   9.686  1.00 13.36           C  
ATOM   1359  C   ARG A 164      21.827  25.765   9.922  1.00 12.72           C  
ATOM   1360  O   ARG A 164      22.443  26.200  10.897  1.00 12.36           O  
ATOM   1361  CB  ARG A 164      23.094  23.654   9.338  1.00 10.70           C  
ATOM   1362  CG  ARG A 164      23.626  23.853   7.914  1.00 10.60           C  
ATOM   1363  CD  ARG A 164      24.278  25.219   7.677  1.00  9.46           C  
ATOM   1364  NE  ARG A 164      25.118  25.175   6.479  1.00 10.41           N  
ATOM   1365  CZ  ARG A 164      25.685  26.230   5.906  1.00 13.03           C  
ATOM   1366  NH1 ARG A 164      25.508  27.448   6.409  1.00 11.57           N  
ATOM   1367  NH2 ARG A 164      26.450  26.063   4.833  1.00 12.51           N  
ATOM   1368  N   LEU A 165      21.211  26.554   9.046  1.00 11.29           N  
ATOM   1369  CA  LEU A 165      21.250  28.014   9.163  1.00 12.47           C  
ATOM   1370  C   LEU A 165      20.034  28.561   9.914  1.00 12.20           C  
ATOM   1371  O   LEU A 165      20.152  29.481  10.731  1.00 11.96           O  
ATOM   1372  CB  LEU A 165      21.326  28.654   7.763  1.00 12.99           C  
ATOM   1373  CG  LEU A 165      21.528  30.171   7.651  1.00 13.31           C  
ATOM   1374  CD1 LEU A 165      22.111  30.523   6.276  1.00 15.32           C  
ATOM   1375  CD2 LEU A 165      20.209  30.887   7.871  1.00 15.04           C  
ATOM   1376  N   LEU A 166      18.867  27.990   9.638  1.00 12.77           N  
ATOM   1377  CA  LEU A 166      17.628  28.440  10.267  1.00 13.32           C  
ATOM   1378  C   LEU A 166      17.703  28.530  11.793  1.00 13.40           C  
ATOM   1379  O   LEU A 166      17.261  29.514  12.378  1.00 12.79           O  
ATOM   1380  CB  LEU A 166      16.461  27.533   9.850  1.00 14.95           C  
ATOM   1381  CG  LEU A 166      15.068  27.970  10.320  1.00 14.53           C  
ATOM   1382  CD1 LEU A 166      14.797  29.404   9.865  1.00 16.64           C  
ATOM   1383  CD2 LEU A 166      14.016  27.023   9.760  1.00 17.33           C  
ATOM   1384  N   PRO A 167      18.263  27.503  12.458  1.00 15.30           N  
ATOM   1385  CA  PRO A 167      18.366  27.532  13.922  1.00 15.36           C  
ATOM   1386  C   PRO A 167      19.204  28.716  14.412  1.00 15.41           C  
ATOM   1387  O   PRO A 167      18.920  29.306  15.457  1.00 15.17           O  
ATOM   1388  CB  PRO A 167      19.021  26.192  14.249  1.00 17.25           C  
ATOM   1389  CG  PRO A 167      18.537  25.302  13.137  1.00 19.69           C  
ATOM   1390  CD  PRO A 167      18.696  26.196  11.931  1.00 15.32           C  
ATOM   1391  N   TYR A 168      20.246  29.049  13.658  1.00 13.54           N  
ATOM   1392  CA  TYR A 168      21.116  30.162  14.020  1.00 13.76           C  
ATOM   1393  C   TYR A 168      20.335  31.469  13.888  1.00 13.14           C  
ATOM   1394  O   TYR A 168      20.427  32.349  14.747  1.00 14.02           O  
ATOM   1395  CB  TYR A 168      22.344  30.187  13.109  1.00 13.53           C  
ATOM   1396  CG  TYR A 168      23.391  31.184  13.533  1.00 14.06           C  
ATOM   1397  CD1 TYR A 168      24.089  31.023  14.729  1.00 12.50           C  
ATOM   1398  CD2 TYR A 168      23.689  32.288  12.738  1.00 14.17           C  
ATOM   1399  CE1 TYR A 168      25.063  31.941  15.122  1.00 13.45           C  
ATOM   1400  CE2 TYR A 168      24.659  33.209  13.118  1.00 14.86           C  
ATOM   1401  CZ  TYR A 168      25.341  33.029  14.311  1.00 14.65           C  
ATOM   1402  OH  TYR A 168      26.302  33.934  14.686  1.00 12.74           O  
ATOM   1403  N   TRP A 169      19.564  31.592  12.810  1.00 13.61           N  
ATOM   1404  CA  TRP A 169      18.754  32.787  12.593  1.00 14.46           C  
ATOM   1405  C   TRP A 169      17.720  32.929  13.708  1.00 15.31           C  
ATOM   1406  O   TRP A 169      17.658  33.953  14.389  1.00 15.17           O  
ATOM   1407  CB  TRP A 169      18.044  32.719  11.235  1.00 15.34           C  
ATOM   1408  CG  TRP A 169      16.847  33.635  11.132  1.00 15.05           C  
ATOM   1409  CD1 TRP A 169      15.535  33.297  11.329  1.00 17.12           C  
ATOM   1410  CD2 TRP A 169      16.860  35.045  10.866  1.00 15.28           C  
ATOM   1411  NE1 TRP A 169      14.732  34.411  11.206  1.00 16.01           N  
ATOM   1412  CE2 TRP A 169      15.520  35.496  10.923  1.00 16.13           C  
ATOM   1413  CE3 TRP A 169      17.874  35.972  10.592  1.00 15.12           C  
ATOM   1414  CZ2 TRP A 169      15.168  36.837  10.711  1.00 17.08           C  
ATOM   1415  CZ3 TRP A 169      17.523  37.306  10.383  1.00 15.32           C  
ATOM   1416  CH2 TRP A 169      16.179  37.724  10.443  1.00 15.89           C  
ATOM   1417  N   ASN A 170      16.914  31.890  13.895  1.00 15.87           N  
ATOM   1418  CA  ASN A 170      15.872  31.906  14.920  1.00 16.61           C  
ATOM   1419  C   ASN A 170      16.391  32.169  16.330  1.00 17.19           C  
ATOM   1420  O   ASN A 170      15.830  32.973  17.069  1.00 17.73           O  
ATOM   1421  CB  ASN A 170      15.122  30.569  14.934  1.00 18.48           C  
ATOM   1422  CG  ASN A 170      14.111  30.444  13.810  1.00 19.69           C  
ATOM   1423  OD1 ASN A 170      13.729  29.337  13.435  1.00 25.37           O  
ATOM   1424  ND2 ASN A 170      13.658  31.572  13.284  1.00 19.18           N  
ATOM   1425  N   GLU A 171      17.474  31.495  16.692  1.00 17.96           N  
ATOM   1426  CA  GLU A 171      18.026  31.595  18.034  1.00 19.02           C  
ATOM   1427  C   GLU A 171      18.986  32.725  18.380  1.00 18.92           C  
ATOM   1428  O   GLU A 171      19.035  33.152  19.533  1.00 18.44           O  
ATOM   1429  CB  GLU A 171      18.666  30.253  18.396  1.00 20.46           C  
ATOM   1430  CG  GLU A 171      17.639  29.144  18.573  1.00 26.10           C  
ATOM   1431  CD  GLU A 171      18.245  27.758  18.541  1.00 28.50           C  
ATOM   1432  OE1 GLU A 171      19.378  27.591  19.037  1.00 29.01           O  
ATOM   1433  OE2 GLU A 171      17.577  26.835  18.026  1.00 31.32           O  
ATOM   1434  N   ARG A 172      19.738  33.225  17.406  1.00 17.22           N  
ATOM   1435  CA  ARG A 172      20.696  34.273  17.710  1.00 16.28           C  
ATOM   1436  C   ARG A 172      20.529  35.598  16.969  1.00 16.66           C  
ATOM   1437  O   ARG A 172      20.935  36.642  17.482  1.00 17.10           O  
ATOM   1438  CB  ARG A 172      22.112  33.725  17.517  1.00 18.51           C  
ATOM   1439  CG  ARG A 172      22.387  32.483  18.379  1.00 18.86           C  
ATOM   1440  CD  ARG A 172      23.836  32.027  18.290  1.00 22.63           C  
ATOM   1441  NE  ARG A 172      24.754  32.993  18.891  1.00 23.34           N  
ATOM   1442  CZ  ARG A 172      24.871  33.212  20.197  1.00 24.94           C  
ATOM   1443  NH1 ARG A 172      24.130  32.526  21.059  1.00 25.88           N  
ATOM   1444  NH2 ARG A 172      25.728  34.122  20.644  1.00 25.76           N  
ATOM   1445  N   ILE A 173      19.933  35.578  15.780  1.00 12.78           N  
ATOM   1446  CA  ILE A 173      19.751  36.825  15.040  1.00 13.71           C  
ATOM   1447  C   ILE A 173      18.337  37.406  15.171  1.00 13.38           C  
ATOM   1448  O   ILE A 173      18.169  38.583  15.500  1.00 13.12           O  
ATOM   1449  CB  ILE A 173      20.068  36.643  13.537  1.00 13.29           C  
ATOM   1450  CG1 ILE A 173      21.475  36.067  13.356  1.00 13.14           C  
ATOM   1451  CG2 ILE A 173      19.977  37.985  12.832  1.00 13.18           C  
ATOM   1452  CD1 ILE A 173      21.841  35.798  11.903  1.00 12.29           C  
ATOM   1453  N   ALA A 174      17.328  36.580  14.914  1.00 13.63           N  
ATOM   1454  CA  ALA A 174      15.932  37.011  14.989  1.00 12.75           C  
ATOM   1455  C   ALA A 174      15.570  37.720  16.299  1.00 13.11           C  
ATOM   1456  O   ALA A 174      14.860  38.729  16.288  1.00 10.90           O  
ATOM   1457  CB  ALA A 174      15.000  35.814  14.760  1.00 11.22           C  
ATOM   1458  N   PRO A 175      16.047  37.207  17.447  1.00 12.37           N  
ATOM   1459  CA  PRO A 175      15.709  37.883  18.704  1.00 13.17           C  
ATOM   1460  C   PRO A 175      16.161  39.347  18.712  1.00 14.01           C  
ATOM   1461  O   PRO A 175      15.458  40.224  19.220  1.00 15.14           O  
ATOM   1462  CB  PRO A 175      16.443  37.048  19.755  1.00 13.35           C  
ATOM   1463  CG  PRO A 175      16.458  35.677  19.147  1.00 12.76           C  
ATOM   1464  CD  PRO A 175      16.808  35.972  17.702  1.00 12.58           C  
ATOM   1465  N   GLU A 176      17.339  39.607  18.152  1.00 14.14           N  
ATOM   1466  CA  GLU A 176      17.871  40.963  18.112  1.00 14.61           C  
ATOM   1467  C   GLU A 176      17.001  41.838  17.218  1.00 14.00           C  
ATOM   1468  O   GLU A 176      16.798  43.018  17.503  1.00 13.57           O  
ATOM   1469  CB  GLU A 176      19.312  40.955  17.594  1.00 15.22           C  
ATOM   1470  CG  GLU A 176      20.252  40.032  18.360  1.00 20.07           C  
ATOM   1471  CD  GLU A 176      20.417  40.408  19.827  1.00 23.11           C  
ATOM   1472  OE1 GLU A 176      21.203  39.728  20.519  1.00 24.28           O  
ATOM   1473  OE2 GLU A 176      19.769  41.371  20.294  1.00 22.52           O  
ATOM   1474  N   VAL A 177      16.489  41.255  16.140  1.00 14.97           N  
ATOM   1475  CA  VAL A 177      15.627  41.992  15.226  1.00 15.15           C  
ATOM   1476  C   VAL A 177      14.348  42.384  15.961  1.00 16.59           C  
ATOM   1477  O   VAL A 177      13.868  43.511  15.835  1.00 17.22           O  
ATOM   1478  CB  VAL A 177      15.256  41.147  13.990  1.00 16.68           C  
ATOM   1479  CG1 VAL A 177      14.283  41.923  13.100  1.00 17.65           C  
ATOM   1480  CG2 VAL A 177      16.518  40.791  13.202  1.00 16.80           C  
ATOM   1481  N   LEU A 178      13.804  41.452  16.739  1.00 18.14           N  
ATOM   1482  CA  LEU A 178      12.578  41.708  17.488  1.00 18.85           C  
ATOM   1483  C   LEU A 178      12.796  42.708  18.611  1.00 18.99           C  
ATOM   1484  O   LEU A 178      11.837  43.238  19.167  1.00 20.74           O  
ATOM   1485  CB  LEU A 178      12.013  40.404  18.060  1.00 21.08           C  
ATOM   1486  CG  LEU A 178      11.260  39.515  17.067  1.00 23.66           C  
ATOM   1487  CD1 LEU A 178      10.645  38.330  17.801  1.00 23.95           C  
ATOM   1488  CD2 LEU A 178      10.170  40.329  16.382  1.00 24.31           C  
ATOM   1489  N   ARG A 179      14.058  42.955  18.942  1.00 16.71           N  
ATOM   1490  CA  ARG A 179      14.411  43.911  19.987  1.00 18.48           C  
ATOM   1491  C   ARG A 179      14.663  45.279  19.357  1.00 16.57           C  
ATOM   1492  O   ARG A 179      15.116  46.206  20.023  1.00 18.84           O  
ATOM   1493  CB  ARG A 179      15.661  43.441  20.735  1.00 18.09           C  
ATOM   1494  CG  ARG A 179      15.419  42.261  21.663  1.00 22.07           C  
ATOM   1495  CD  ARG A 179      16.721  41.571  22.045  1.00 23.74           C  
ATOM   1496  NE  ARG A 179      17.752  42.516  22.464  1.00 28.42           N  
ATOM   1497  CZ  ARG A 179      17.663  43.302  23.531  1.00 29.64           C  
ATOM   1498  NH1 ARG A 179      16.583  43.259  24.300  1.00 32.81           N  
ATOM   1499  NH2 ARG A 179      18.651  44.133  23.829  1.00 30.44           N  
ATOM   1500  N   GLY A 180      14.375  45.389  18.064  1.00 16.64           N  
ATOM   1501  CA  GLY A 180      14.558  46.647  17.363  1.00 15.75           C  
ATOM   1502  C   GLY A 180      15.993  46.993  17.019  1.00 16.51           C  
ATOM   1503  O   GLY A 180      16.275  48.134  16.655  1.00 14.98           O  
ATOM   1504  N   LYS A 181      16.901  46.022  17.127  1.00 14.76           N  
ATOM   1505  CA  LYS A 181      18.309  46.262  16.814  1.00 14.34           C  
ATOM   1506  C   LYS A 181      18.546  46.270  15.305  1.00 12.53           C  
ATOM   1507  O   LYS A 181      17.872  45.563  14.562  1.00 14.73           O  
ATOM   1508  CB  LYS A 181      19.197  45.189  17.458  1.00 13.89           C  
ATOM   1509  CG  LYS A 181      19.081  45.111  18.977  1.00 17.50           C  
ATOM   1510  CD  LYS A 181      19.442  46.439  19.631  1.00 22.95           C  
ATOM   1511  CE  LYS A 181      19.220  46.397  21.138  1.00 25.77           C  
ATOM   1512  NZ  LYS A 181      19.473  47.721  21.780  1.00 28.70           N  
ATOM   1513  N   THR A 182      19.511  47.072  14.868  1.00 14.09           N  
ATOM   1514  CA  THR A 182      19.859  47.184  13.454  1.00 12.70           C  
ATOM   1515  C   THR A 182      20.971  46.189  13.158  1.00 12.16           C  
ATOM   1516  O   THR A 182      22.107  46.345  13.608  1.00 12.19           O  
ATOM   1517  CB  THR A 182      20.309  48.609  13.128  1.00 13.32           C  
ATOM   1518  OG1 THR A 182      19.255  49.511  13.485  1.00 13.07           O  
ATOM   1519  CG2 THR A 182      20.613  48.753  11.634  1.00 13.98           C  
ATOM   1520  N   ILE A 183      20.627  45.163  12.389  1.00 12.54           N  
ATOM   1521  CA  ILE A 183      21.552  44.084  12.081  1.00 12.85           C  
ATOM   1522  C   ILE A 183      22.075  44.013  10.651  1.00 13.67           C  
ATOM   1523  O   ILE A 183      21.358  44.314   9.695  1.00 11.73           O  
ATOM   1524  CB  ILE A 183      20.883  42.722  12.395  1.00 15.50           C  
ATOM   1525  CG1 ILE A 183      20.402  42.700  13.850  1.00 16.79           C  
ATOM   1526  CG2 ILE A 183      21.836  41.574  12.088  1.00 17.05           C  
ATOM   1527  CD1 ILE A 183      21.451  43.053  14.861  1.00 18.46           C  
ATOM   1528  N   LEU A 184      23.331  43.588  10.529  1.00 14.11           N  
ATOM   1529  CA  LEU A 184      23.985  43.396   9.238  1.00 12.90           C  
ATOM   1530  C   LEU A 184      24.438  41.946   9.174  1.00 13.64           C  
ATOM   1531  O   LEU A 184      25.110  41.461  10.085  1.00 13.74           O  
ATOM   1532  CB  LEU A 184      25.221  44.285   9.095  1.00 15.40           C  
ATOM   1533  CG  LEU A 184      26.151  43.899   7.932  1.00 14.35           C  
ATOM   1534  CD1 LEU A 184      25.441  44.142   6.606  1.00 15.38           C  
ATOM   1535  CD2 LEU A 184      27.436  44.709   7.989  1.00 14.88           C  
ATOM   1536  N   ILE A 185      24.061  41.249   8.110  1.00 12.33           N  
ATOM   1537  CA  ILE A 185      24.491  39.871   7.933  1.00 11.36           C  
ATOM   1538  C   ILE A 185      25.424  39.834   6.725  1.00 12.46           C  
ATOM   1539  O   ILE A 185      24.998  40.069   5.594  1.00 13.03           O  
ATOM   1540  CB  ILE A 185      23.304  38.919   7.682  1.00 11.10           C  
ATOM   1541  CG1 ILE A 185      22.361  38.926   8.888  1.00 11.80           C  
ATOM   1542  CG2 ILE A 185      23.817  37.509   7.427  1.00 12.53           C  
ATOM   1543  CD1 ILE A 185      21.162  38.005   8.727  1.00 15.25           C  
ATOM   1544  N   SER A 186      26.702  39.563   6.975  1.00 11.73           N  
ATOM   1545  CA  SER A 186      27.699  39.482   5.910  1.00 11.05           C  
ATOM   1546  C   SER A 186      27.821  38.004   5.584  1.00 12.06           C  
ATOM   1547  O   SER A 186      28.509  37.262   6.285  1.00 11.11           O  
ATOM   1548  CB  SER A 186      29.041  40.034   6.401  1.00 12.08           C  
ATOM   1549  OG  SER A 186      30.013  40.000   5.372  1.00 11.50           O  
ATOM   1550  N   ALA A 187      27.153  37.574   4.518  1.00 12.31           N  
ATOM   1551  CA  ALA A 187      27.155  36.162   4.176  1.00 12.77           C  
ATOM   1552  C   ALA A 187      27.643  35.823   2.779  1.00 11.65           C  
ATOM   1553  O   ALA A 187      28.519  36.494   2.232  1.00 12.92           O  
ATOM   1554  CB  ALA A 187      25.756  35.586   4.395  1.00 13.26           C  
ATOM   1555  N   HIS A 188      27.054  34.778   2.207  1.00 12.14           N  
ATOM   1556  CA  HIS A 188      27.449  34.291   0.892  1.00 12.66           C  
ATOM   1557  C   HIS A 188      26.259  34.120  -0.044  1.00 12.65           C  
ATOM   1558  O   HIS A 188      25.107  34.274   0.361  1.00 12.90           O  
ATOM   1559  CB  HIS A 188      28.186  32.959   1.062  1.00 11.83           C  
ATOM   1560  CG  HIS A 188      29.325  33.027   2.033  1.00 12.08           C  
ATOM   1561  ND1 HIS A 188      30.587  33.455   1.676  1.00 10.72           N  
ATOM   1562  CD2 HIS A 188      29.373  32.790   3.366  1.00 10.14           C  
ATOM   1563  CE1 HIS A 188      31.362  33.482   2.747  1.00 11.01           C  
ATOM   1564  NE2 HIS A 188      30.648  33.083   3.786  1.00 11.58           N  
ATOM   1565  N   GLY A 189      26.550  33.789  -1.297  1.00 12.99           N  
ATOM   1566  CA  GLY A 189      25.502  33.625  -2.288  1.00 12.18           C  
ATOM   1567  C   GLY A 189      24.370  32.679  -1.931  1.00 13.46           C  
ATOM   1568  O   GLY A 189      23.208  33.085  -1.856  1.00 13.45           O  
ATOM   1569  N   ASN A 190      24.694  31.413  -1.696  1.00 11.13           N  
ATOM   1570  CA  ASN A 190      23.658  30.449  -1.383  1.00 12.26           C  
ATOM   1571  C   ASN A 190      23.153  30.442   0.056  1.00 11.46           C  
ATOM   1572  O   ASN A 190      21.985  30.135   0.281  1.00 12.23           O  
ATOM   1573  CB  ASN A 190      24.101  29.056  -1.839  1.00 11.93           C  
ATOM   1574  CG  ASN A 190      24.324  28.999  -3.342  1.00 14.50           C  
ATOM   1575  OD1 ASN A 190      23.493  29.478  -4.115  1.00 11.68           O  
ATOM   1576  ND2 ASN A 190      25.443  28.418  -3.762  1.00 14.83           N  
ATOM   1577  N   SER A 191      23.995  30.785   1.029  1.00 12.03           N  
ATOM   1578  CA  SER A 191      23.507  30.822   2.406  1.00 11.28           C  
ATOM   1579  C   SER A 191      22.509  31.983   2.520  1.00 12.66           C  
ATOM   1580  O   SER A 191      21.548  31.916   3.291  1.00 10.61           O  
ATOM   1581  CB  SER A 191      24.662  30.961   3.422  1.00 13.09           C  
ATOM   1582  OG  SER A 191      25.556  32.021   3.128  1.00 12.09           O  
ATOM   1583  N   SER A 192      22.719  33.034   1.725  1.00 10.74           N  
ATOM   1584  CA  SER A 192      21.795  34.166   1.723  1.00 11.37           C  
ATOM   1585  C   SER A 192      20.493  33.749   1.024  1.00 11.76           C  
ATOM   1586  O   SER A 192      19.398  34.108   1.465  1.00 11.20           O  
ATOM   1587  CB  SER A 192      22.410  35.379   1.007  1.00 11.62           C  
ATOM   1588  OG  SER A 192      23.439  35.973   1.788  1.00 12.75           O  
ATOM   1589  N   ARG A 193      20.609  32.989  -0.062  1.00 11.21           N  
ATOM   1590  CA  ARG A 193      19.421  32.524  -0.773  1.00 11.38           C  
ATOM   1591  C   ARG A 193      18.584  31.639   0.151  1.00 11.87           C  
ATOM   1592  O   ARG A 193      17.355  31.698   0.133  1.00 10.81           O  
ATOM   1593  CB  ARG A 193      19.807  31.737  -2.032  1.00 11.59           C  
ATOM   1594  CG  ARG A 193      20.428  32.581  -3.146  1.00 10.73           C  
ATOM   1595  CD  ARG A 193      20.894  31.703  -4.312  1.00 10.00           C  
ATOM   1596  NE  ARG A 193      19.785  30.995  -4.948  1.00 10.04           N  
ATOM   1597  CZ  ARG A 193      19.683  29.671  -5.017  1.00 10.90           C  
ATOM   1598  NH1 ARG A 193      20.629  28.902  -4.490  1.00 10.53           N  
ATOM   1599  NH2 ARG A 193      18.631  29.115  -5.608  1.00  9.24           N  
ATOM   1600  N   ALA A 194      19.250  30.821   0.961  1.00  9.66           N  
ATOM   1601  CA  ALA A 194      18.539  29.936   1.881  1.00  9.92           C  
ATOM   1602  C   ALA A 194      17.722  30.750   2.882  1.00 10.42           C  
ATOM   1603  O   ALA A 194      16.553  30.442   3.141  1.00  8.65           O  
ATOM   1604  CB  ALA A 194      19.529  29.037   2.625  1.00 10.32           C  
ATOM   1605  N   LEU A 195      18.339  31.790   3.441  1.00  9.86           N  
ATOM   1606  CA  LEU A 195      17.658  32.638   4.413  1.00 12.41           C  
ATOM   1607  C   LEU A 195      16.477  33.358   3.761  1.00 11.97           C  
ATOM   1608  O   LEU A 195      15.383  33.403   4.326  1.00 12.39           O  
ATOM   1609  CB  LEU A 195      18.626  33.671   4.997  1.00 14.56           C  
ATOM   1610  CG  LEU A 195      18.523  33.995   6.493  1.00 19.06           C  
ATOM   1611  CD1 LEU A 195      19.088  35.388   6.738  1.00 15.77           C  
ATOM   1612  CD2 LEU A 195      17.093  33.909   6.975  1.00 16.72           C  
ATOM   1613  N   LEU A 196      16.701  33.918   2.575  1.00 11.27           N  
ATOM   1614  CA  LEU A 196      15.641  34.626   1.858  1.00 12.43           C  
ATOM   1615  C   LEU A 196      14.477  33.690   1.523  1.00 12.39           C  
ATOM   1616  O   LEU A 196      13.317  34.066   1.662  1.00 13.42           O  
ATOM   1617  CB  LEU A 196      16.192  35.264   0.572  1.00 12.74           C  
ATOM   1618  CG  LEU A 196      17.228  36.376   0.764  1.00 14.54           C  
ATOM   1619  CD1 LEU A 196      17.734  36.857  -0.598  1.00 15.91           C  
ATOM   1620  CD2 LEU A 196      16.610  37.527   1.549  1.00 13.65           C  
ATOM   1621  N   LYS A 197      14.784  32.471   1.086  1.00 13.20           N  
ATOM   1622  CA  LYS A 197      13.731  31.513   0.763  1.00 13.91           C  
ATOM   1623  C   LYS A 197      12.789  31.374   1.956  1.00 14.12           C  
ATOM   1624  O   LYS A 197      11.564  31.361   1.806  1.00 13.88           O  
ATOM   1625  CB  LYS A 197      14.321  30.138   0.439  1.00 12.91           C  
ATOM   1626  CG  LYS A 197      13.272  29.148  -0.071  1.00 12.97           C  
ATOM   1627  CD  LYS A 197      13.824  27.743  -0.216  1.00 10.53           C  
ATOM   1628  CE  LYS A 197      12.843  26.831  -0.956  1.00 12.99           C  
ATOM   1629  NZ  LYS A 197      11.515  26.736  -0.269  1.00 12.84           N  
ATOM   1630  N   HIS A 198      13.374  31.275   3.144  1.00 12.98           N  
ATOM   1631  CA  HIS A 198      12.597  31.135   4.370  1.00 13.98           C  
ATOM   1632  C   HIS A 198      11.794  32.395   4.706  1.00 13.60           C  
ATOM   1633  O   HIS A 198      10.576  32.344   4.863  1.00 14.46           O  
ATOM   1634  CB  HIS A 198      13.525  30.815   5.539  1.00 13.50           C  
ATOM   1635  CG  HIS A 198      12.850  30.874   6.872  1.00 16.26           C  
ATOM   1636  ND1 HIS A 198      11.920  29.941   7.275  1.00 18.83           N  
ATOM   1637  CD2 HIS A 198      12.952  31.766   7.884  1.00 18.03           C  
ATOM   1638  CE1 HIS A 198      11.478  30.256   8.480  1.00 18.78           C  
ATOM   1639  NE2 HIS A 198      12.089  31.359   8.872  1.00 19.29           N  
ATOM   1640  N   LEU A 199      12.487  33.521   4.822  1.00 13.91           N  
ATOM   1641  CA  LEU A 199      11.846  34.785   5.169  1.00 14.92           C  
ATOM   1642  C   LEU A 199      10.786  35.257   4.181  1.00 15.67           C  
ATOM   1643  O   LEU A 199       9.792  35.854   4.589  1.00 14.76           O  
ATOM   1644  CB  LEU A 199      12.904  35.877   5.347  1.00 15.14           C  
ATOM   1645  CG  LEU A 199      13.896  35.640   6.487  1.00 16.94           C  
ATOM   1646  CD1 LEU A 199      14.912  36.766   6.519  1.00 15.69           C  
ATOM   1647  CD2 LEU A 199      13.149  35.550   7.816  1.00 15.82           C  
ATOM   1648  N   GLU A 200      10.986  34.994   2.892  1.00 15.84           N  
ATOM   1649  CA  GLU A 200      10.011  35.426   1.890  1.00 17.37           C  
ATOM   1650  C   GLU A 200       9.000  34.347   1.521  1.00 18.26           C  
ATOM   1651  O   GLU A 200       8.084  34.587   0.726  1.00 18.75           O  
ATOM   1652  CB  GLU A 200      10.723  35.904   0.623  1.00 16.95           C  
ATOM   1653  CG  GLU A 200      11.573  37.141   0.826  1.00 17.78           C  
ATOM   1654  CD  GLU A 200      12.275  37.567  -0.446  1.00 17.04           C  
ATOM   1655  OE1 GLU A 200      13.498  37.817  -0.392  1.00 15.15           O  
ATOM   1656  OE2 GLU A 200      11.606  37.651  -1.497  1.00 17.81           O  
ATOM   1657  N   GLY A 201       9.164  33.162   2.101  1.00 17.57           N  
ATOM   1658  CA  GLY A 201       8.255  32.066   1.810  1.00 18.16           C  
ATOM   1659  C   GLY A 201       8.311  31.641   0.353  1.00 18.62           C  
ATOM   1660  O   GLY A 201       7.286  31.294  -0.237  1.00 18.74           O  
ATOM   1661  N   ILE A 202       9.503  31.663  -0.236  1.00 15.79           N  
ATOM   1662  CA  ILE A 202       9.662  31.275  -1.637  1.00 17.04           C  
ATOM   1663  C   ILE A 202       9.575  29.756  -1.764  1.00 17.61           C  
ATOM   1664  O   ILE A 202      10.187  29.025  -0.982  1.00 17.92           O  
ATOM   1665  CB  ILE A 202      11.021  31.745  -2.196  1.00 17.41           C  
ATOM   1666  CG1 ILE A 202      11.160  33.257  -2.015  1.00 18.66           C  
ATOM   1667  CG2 ILE A 202      11.139  31.366  -3.673  1.00 16.35           C  
ATOM   1668  CD1 ILE A 202      12.546  33.792  -2.330  1.00 18.63           C  
ATOM   1669  N   SER A 203       8.811  29.285  -2.748  1.00 17.93           N  
ATOM   1670  CA  SER A 203       8.634  27.853  -2.960  1.00 18.55           C  
ATOM   1671  C   SER A 203       9.911  27.166  -3.436  1.00 20.15           C  
ATOM   1672  O   SER A 203      10.838  27.810  -3.932  1.00 17.91           O  
ATOM   1673  CB  SER A 203       7.527  27.599  -3.986  1.00 18.50           C  
ATOM   1674  OG  SER A 203       7.945  27.980  -5.286  1.00 16.40           O  
ATOM   1675  N   ASP A 204       9.944  25.847  -3.282  1.00 20.91           N  
ATOM   1676  CA  ASP A 204      11.085  25.048  -3.703  1.00 25.22           C  
ATOM   1677  C   ASP A 204      11.390  25.290  -5.175  1.00 25.73           C  
ATOM   1678  O   ASP A 204      12.550  25.358  -5.572  1.00 27.36           O  
ATOM   1679  CB  ASP A 204      10.787  23.563  -3.497  1.00 27.17           C  
ATOM   1680  CG  ASP A 204      10.785  23.165  -2.039  1.00 29.01           C  
ATOM   1681  OD1 ASP A 204      10.649  24.054  -1.170  1.00 29.20           O  
ATOM   1682  OD2 ASP A 204      10.913  21.953  -1.764  1.00 32.92           O  
ATOM   1683  N   GLU A 205      10.339  25.425  -5.976  1.00 25.85           N  
ATOM   1684  CA  GLU A 205      10.483  25.638  -7.410  1.00 26.16           C  
ATOM   1685  C   GLU A 205      10.955  27.045  -7.762  1.00 24.04           C  
ATOM   1686  O   GLU A 205      11.840  27.218  -8.596  1.00 24.99           O  
ATOM   1687  CB  GLU A 205       9.150  25.371  -8.123  1.00 28.77           C  
ATOM   1688  CG  GLU A 205       8.350  24.204  -7.564  1.00 34.48           C  
ATOM   1689  CD  GLU A 205       7.680  24.537  -6.239  1.00 36.46           C  
ATOM   1690  OE1 GLU A 205       6.858  25.480  -6.210  1.00 42.79           O  
ATOM   1691  OE2 GLU A 205       7.969  23.864  -5.227  1.00 36.82           O  
ATOM   1692  N   ASP A 206      10.366  28.051  -7.128  1.00 21.51           N  
ATOM   1693  CA  ASP A 206      10.739  29.427  -7.422  1.00 20.03           C  
ATOM   1694  C   ASP A 206      12.130  29.846  -6.953  1.00 17.89           C  
ATOM   1695  O   ASP A 206      12.732  30.744  -7.542  1.00 16.65           O  
ATOM   1696  CB  ASP A 206       9.698  30.398  -6.855  1.00 20.34           C  
ATOM   1697  CG  ASP A 206       8.368  30.313  -7.582  1.00 24.82           C  
ATOM   1698  OD1 ASP A 206       8.383  30.206  -8.827  1.00 23.76           O  
ATOM   1699  OD2 ASP A 206       7.311  30.362  -6.917  1.00 24.51           O  
ATOM   1700  N   ILE A 207      12.652  29.205  -5.910  1.00 16.02           N  
ATOM   1701  CA  ILE A 207      13.969  29.594  -5.418  1.00 14.27           C  
ATOM   1702  C   ILE A 207      15.060  29.360  -6.465  1.00 13.57           C  
ATOM   1703  O   ILE A 207      16.091  30.037  -6.460  1.00 14.10           O  
ATOM   1704  CB  ILE A 207      14.337  28.851  -4.096  1.00 14.60           C  
ATOM   1705  CG1 ILE A 207      15.506  29.563  -3.414  1.00 13.63           C  
ATOM   1706  CG2 ILE A 207      14.708  27.410  -4.378  1.00 16.68           C  
ATOM   1707  CD1 ILE A 207      15.201  31.004  -3.015  1.00 13.92           C  
ATOM   1708  N   ILE A 208      14.823  28.425  -7.380  1.00 14.44           N  
ATOM   1709  CA  ILE A 208      15.802  28.123  -8.422  1.00 15.89           C  
ATOM   1710  C   ILE A 208      16.103  29.327  -9.316  1.00 15.29           C  
ATOM   1711  O   ILE A 208      17.194  29.438  -9.869  1.00 15.13           O  
ATOM   1712  CB  ILE A 208      15.329  26.957  -9.329  1.00 18.48           C  
ATOM   1713  CG1 ILE A 208      15.024  25.720  -8.480  1.00 21.46           C  
ATOM   1714  CG2 ILE A 208      16.419  26.615 -10.343  1.00 19.83           C  
ATOM   1715  CD1 ILE A 208      14.626  24.494  -9.296  1.00 25.97           C  
ATOM   1716  N   ASN A 209      15.146  30.237  -9.446  1.00 15.69           N  
ATOM   1717  CA  ASN A 209      15.347  31.409 -10.292  1.00 17.65           C  
ATOM   1718  C   ASN A 209      15.909  32.631  -9.572  1.00 18.13           C  
ATOM   1719  O   ASN A 209      16.071  33.697 -10.175  1.00 18.30           O  
ATOM   1720  CB  ASN A 209      14.038  31.761 -10.999  1.00 20.62           C  
ATOM   1721  CG  ASN A 209      13.600  30.673 -11.957  1.00 25.03           C  
ATOM   1722  OD1 ASN A 209      14.361  30.270 -12.842  1.00 28.23           O  
ATOM   1723  ND2 ASN A 209      12.378  30.183 -11.783  1.00 27.05           N  
ATOM   1724  N   ILE A 210      16.224  32.476  -8.291  1.00 16.48           N  
ATOM   1725  CA  ILE A 210      16.785  33.580  -7.520  1.00 15.97           C  
ATOM   1726  C   ILE A 210      18.313  33.529  -7.520  1.00 16.00           C  
ATOM   1727  O   ILE A 210      18.911  32.569  -7.032  1.00 13.57           O  
ATOM   1728  CB  ILE A 210      16.300  33.552  -6.050  1.00 15.47           C  
ATOM   1729  CG1 ILE A 210      14.779  33.731  -5.994  1.00 16.60           C  
ATOM   1730  CG2 ILE A 210      17.002  34.647  -5.249  1.00 17.14           C  
ATOM   1731  CD1 ILE A 210      14.292  35.058  -6.551  1.00 16.43           C  
ATOM   1732  N   THR A 211      18.934  34.560  -8.085  1.00 13.48           N  
ATOM   1733  CA  THR A 211      20.390  34.667  -8.124  1.00 14.68           C  
ATOM   1734  C   THR A 211      20.757  36.013  -7.515  1.00 14.11           C  
ATOM   1735  O   THR A 211      20.151  37.034  -7.846  1.00 14.29           O  
ATOM   1736  CB  THR A 211      20.936  34.612  -9.568  1.00 14.72           C  
ATOM   1737  OG1 THR A 211      20.761  33.292 -10.098  1.00 15.87           O  
ATOM   1738  CG2 THR A 211      22.424  34.973  -9.587  1.00 13.73           C  
ATOM   1739  N   LEU A 212      21.741  36.020  -6.622  1.00 13.50           N  
ATOM   1740  CA  LEU A 212      22.151  37.257  -5.966  1.00 13.85           C  
ATOM   1741  C   LEU A 212      23.495  37.774  -6.470  1.00 13.17           C  
ATOM   1742  O   LEU A 212      24.457  37.015  -6.599  1.00 15.36           O  
ATOM   1743  CB  LEU A 212      22.236  37.048  -4.450  1.00 11.38           C  
ATOM   1744  CG  LEU A 212      21.036  36.407  -3.745  1.00 12.99           C  
ATOM   1745  CD1 LEU A 212      21.394  36.198  -2.272  1.00 11.30           C  
ATOM   1746  CD2 LEU A 212      19.784  37.290  -3.881  1.00 10.42           C  
ATOM   1747  N   PRO A 213      23.576  39.081  -6.762  1.00 14.73           N  
ATOM   1748  CA  PRO A 213      24.826  39.672  -7.248  1.00 15.69           C  
ATOM   1749  C   PRO A 213      25.800  39.876  -6.089  1.00 15.24           C  
ATOM   1750  O   PRO A 213      25.382  40.039  -4.944  1.00 15.24           O  
ATOM   1751  CB  PRO A 213      24.360  40.991  -7.854  1.00 15.55           C  
ATOM   1752  CG  PRO A 213      23.245  41.388  -6.948  1.00 14.80           C  
ATOM   1753  CD  PRO A 213      22.494  40.083  -6.730  1.00 13.63           C  
ATOM   1754  N   THR A 214      27.095  39.866  -6.385  1.00 17.29           N  
ATOM   1755  CA  THR A 214      28.109  40.054  -5.350  1.00 16.40           C  
ATOM   1756  C   THR A 214      28.259  41.518  -4.945  1.00 15.77           C  
ATOM   1757  O   THR A 214      28.072  42.418  -5.764  1.00 16.19           O  
ATOM   1758  CB  THR A 214      29.491  39.566  -5.822  1.00 19.09           C  
ATOM   1759  OG1 THR A 214      29.956  40.411  -6.878  1.00 20.75           O  
ATOM   1760  CG2 THR A 214      29.413  38.137  -6.326  1.00 18.08           C  
ATOM   1761  N   GLY A 215      28.599  41.741  -3.677  1.00 14.64           N  
ATOM   1762  CA  GLY A 215      28.818  43.087  -3.167  1.00 13.03           C  
ATOM   1763  C   GLY A 215      27.688  44.087  -3.327  1.00 14.84           C  
ATOM   1764  O   GLY A 215      27.926  45.251  -3.653  1.00 14.29           O  
ATOM   1765  N   VAL A 216      26.457  43.647  -3.083  1.00 13.50           N  
ATOM   1766  CA  VAL A 216      25.297  44.526  -3.202  1.00 14.71           C  
ATOM   1767  C   VAL A 216      24.416  44.407  -1.965  1.00 13.03           C  
ATOM   1768  O   VAL A 216      23.959  43.317  -1.628  1.00 14.62           O  
ATOM   1769  CB  VAL A 216      24.452  44.165  -4.448  1.00 13.85           C  
ATOM   1770  CG1 VAL A 216      23.173  45.005  -4.485  1.00 15.60           C  
ATOM   1771  CG2 VAL A 216      25.274  44.389  -5.716  1.00 15.02           C  
ATOM   1772  N   PRO A 217      24.178  45.528  -1.261  1.00 13.58           N  
ATOM   1773  CA  PRO A 217      23.334  45.495  -0.063  1.00 14.03           C  
ATOM   1774  C   PRO A 217      21.938  44.986  -0.399  1.00 14.51           C  
ATOM   1775  O   PRO A 217      21.321  45.430  -1.370  1.00 14.53           O  
ATOM   1776  CB  PRO A 217      23.319  46.956   0.394  1.00 14.27           C  
ATOM   1777  CG  PRO A 217      24.661  47.455  -0.047  1.00 14.85           C  
ATOM   1778  CD  PRO A 217      24.777  46.862  -1.440  1.00 13.32           C  
ATOM   1779  N   ILE A 218      21.452  44.044   0.399  1.00 13.30           N  
ATOM   1780  CA  ILE A 218      20.128  43.483   0.189  1.00 14.48           C  
ATOM   1781  C   ILE A 218      19.283  43.960   1.353  1.00 15.91           C  
ATOM   1782  O   ILE A 218      19.580  43.659   2.510  1.00 13.26           O  
ATOM   1783  CB  ILE A 218      20.161  41.931   0.166  1.00 14.58           C  
ATOM   1784  CG1 ILE A 218      21.130  41.446  -0.912  1.00 15.23           C  
ATOM   1785  CG2 ILE A 218      18.771  41.381  -0.131  1.00 13.69           C  
ATOM   1786  CD1 ILE A 218      21.296  39.934  -0.959  1.00 16.68           C  
ATOM   1787  N   LEU A 219      18.247  44.730   1.041  1.00 18.53           N  
ATOM   1788  CA  LEU A 219      17.347  45.269   2.051  1.00 20.85           C  
ATOM   1789  C   LEU A 219      16.141  44.360   2.211  1.00 20.34           C  
ATOM   1790  O   LEU A 219      15.565  43.889   1.229  1.00 19.93           O  
ATOM   1791  CB  LEU A 219      16.863  46.663   1.647  1.00 27.09           C  
ATOM   1792  CG  LEU A 219      17.893  47.767   1.386  1.00 30.43           C  
ATOM   1793  CD1 LEU A 219      18.794  47.391   0.220  1.00 33.46           C  
ATOM   1794  CD2 LEU A 219      17.153  49.061   1.065  1.00 33.97           C  
ATOM   1795  N   LEU A 220      15.753  44.110   3.451  1.00 17.16           N  
ATOM   1796  CA  LEU A 220      14.605  43.262   3.690  1.00 18.63           C  
ATOM   1797  C   LEU A 220      13.827  43.823   4.870  1.00 19.44           C  
ATOM   1798  O   LEU A 220      14.409  44.220   5.881  1.00 18.46           O  
ATOM   1799  CB  LEU A 220      15.052  41.823   3.972  1.00 19.74           C  
ATOM   1800  CG  LEU A 220      13.967  40.742   3.982  1.00 22.99           C  
ATOM   1801  CD1 LEU A 220      13.290  40.677   2.618  1.00 23.49           C  
ATOM   1802  CD2 LEU A 220      14.582  39.392   4.332  1.00 21.84           C  
ATOM   1803  N   GLU A 221      12.511  43.882   4.715  1.00 19.19           N  
ATOM   1804  CA  GLU A 221      11.635  44.381   5.764  1.00 19.98           C  
ATOM   1805  C   GLU A 221      10.835  43.189   6.261  1.00 18.43           C  
ATOM   1806  O   GLU A 221      10.307  42.413   5.465  1.00 19.96           O  
ATOM   1807  CB  GLU A 221      10.689  45.448   5.209  1.00 19.85           C  
ATOM   1808  CG  GLU A 221       9.888  46.182   6.271  1.00 22.73           C  
ATOM   1809  CD  GLU A 221       8.893  47.167   5.677  1.00 26.76           C  
ATOM   1810  OE1 GLU A 221       8.474  48.102   6.388  1.00 30.29           O  
ATOM   1811  OE2 GLU A 221       8.519  47.005   4.500  1.00 26.36           O  
ATOM   1812  N   LEU A 222      10.761  43.040   7.577  1.00 18.51           N  
ATOM   1813  CA  LEU A 222      10.025  41.940   8.183  1.00 19.64           C  
ATOM   1814  C   LEU A 222       8.913  42.492   9.069  1.00 20.64           C  
ATOM   1815  O   LEU A 222       9.008  43.613   9.567  1.00 20.35           O  
ATOM   1816  CB  LEU A 222      10.968  41.081   9.029  1.00 19.84           C  
ATOM   1817  CG  LEU A 222      12.240  40.583   8.336  1.00 20.62           C  
ATOM   1818  CD1 LEU A 222      13.077  39.801   9.328  1.00 19.74           C  
ATOM   1819  CD2 LEU A 222      11.875  39.714   7.145  1.00 19.99           C  
ATOM   1820  N   ASP A 223       7.862  41.701   9.260  1.00 21.71           N  
ATOM   1821  CA  ASP A 223       6.741  42.114  10.097  1.00 23.65           C  
ATOM   1822  C   ASP A 223       6.869  41.515  11.495  1.00 25.34           C  
ATOM   1823  O   ASP A 223       7.856  40.844  11.800  1.00 24.25           O  
ATOM   1824  CB  ASP A 223       5.411  41.676   9.474  1.00 24.92           C  
ATOM   1825  CG  ASP A 223       5.352  40.186   9.204  1.00 25.85           C  
ATOM   1826  OD1 ASP A 223       5.951  39.401   9.973  1.00 24.05           O  
ATOM   1827  OD2 ASP A 223       4.684  39.795   8.227  1.00 26.24           O  
ATOM   1828  N   GLU A 224       5.861  41.750  12.332  1.00 26.23           N  
ATOM   1829  CA  GLU A 224       5.849  41.250  13.706  1.00 28.64           C  
ATOM   1830  C   GLU A 224       6.121  39.756  13.804  1.00 27.57           C  
ATOM   1831  O   GLU A 224       6.607  39.274  14.827  1.00 30.28           O  
ATOM   1832  CB  GLU A 224       4.503  41.559  14.372  1.00 32.10           C  
ATOM   1833  CG  GLU A 224       4.266  43.029  14.653  1.00 38.78           C  
ATOM   1834  CD  GLU A 224       5.120  43.551  15.795  1.00 42.44           C  
ATOM   1835  OE1 GLU A 224       6.356  43.382  15.743  1.00 45.17           O  
ATOM   1836  OE2 GLU A 224       4.554  44.135  16.744  1.00 45.39           O  
ATOM   1837  N   ASN A 225       5.799  39.018  12.748  1.00 25.62           N  
ATOM   1838  CA  ASN A 225       6.022  37.579  12.753  1.00 24.48           C  
ATOM   1839  C   ASN A 225       7.327  37.211  12.053  1.00 24.20           C  
ATOM   1840  O   ASN A 225       7.533  36.064  11.657  1.00 23.57           O  
ATOM   1841  CB  ASN A 225       4.838  36.871  12.098  1.00 25.71           C  
ATOM   1842  CG  ASN A 225       3.530  37.173  12.807  1.00 26.99           C  
ATOM   1843  OD1 ASN A 225       3.439  37.052  14.029  1.00 24.86           O  
ATOM   1844  ND2 ASN A 225       2.514  37.572  12.045  1.00 26.46           N  
ATOM   1845  N   LEU A 226       8.202  38.203  11.917  1.00 23.26           N  
ATOM   1846  CA  LEU A 226       9.505  38.034  11.281  1.00 25.00           C  
ATOM   1847  C   LEU A 226       9.422  37.400   9.898  1.00 26.05           C  
ATOM   1848  O   LEU A 226      10.205  36.512   9.552  1.00 27.88           O  
ATOM   1849  CB  LEU A 226      10.432  37.220  12.188  1.00 23.80           C  
ATOM   1850  CG  LEU A 226      10.728  37.903  13.527  1.00 25.40           C  
ATOM   1851  CD1 LEU A 226      11.717  37.066  14.324  1.00 26.10           C  
ATOM   1852  CD2 LEU A 226      11.289  39.298  13.279  1.00 25.43           C  
ATOM   1853  N   ARG A 227       8.457  37.871   9.118  1.00 25.53           N  
ATOM   1854  CA  ARG A 227       8.248  37.404   7.757  1.00 25.88           C  
ATOM   1855  C   ARG A 227       8.346  38.609   6.837  1.00 24.07           C  
ATOM   1856  O   ARG A 227       7.913  39.702   7.195  1.00 23.02           O  
ATOM   1857  CB  ARG A 227       6.874  36.748   7.626  1.00 29.93           C  
ATOM   1858  CG  ARG A 227       6.762  35.471   8.431  1.00 35.26           C  
ATOM   1859  CD  ARG A 227       7.843  34.494   8.004  1.00 40.38           C  
ATOM   1860  NE  ARG A 227       7.886  33.308   8.854  1.00 45.04           N  
ATOM   1861  CZ  ARG A 227       8.589  32.219   8.568  1.00 45.98           C  
ATOM   1862  NH1 ARG A 227       9.307  32.168   7.453  1.00 47.33           N  
ATOM   1863  NH2 ARG A 227       8.564  31.177   9.387  1.00 46.49           N  
ATOM   1864  N   ALA A 228       8.920  38.403   5.655  1.00 22.91           N  
ATOM   1865  CA  ALA A 228       9.097  39.472   4.680  1.00 23.02           C  
ATOM   1866  C   ALA A 228       7.801  40.207   4.356  1.00 24.21           C  
ATOM   1867  O   ALA A 228       6.801  39.591   3.984  1.00 24.18           O  
ATOM   1868  CB  ALA A 228       9.700  38.904   3.396  1.00 22.51           C  
ATOM   1869  N   VAL A 229       7.824  41.528   4.498  1.00 25.86           N  
ATOM   1870  CA  VAL A 229       6.656  42.349   4.193  1.00 28.06           C  
ATOM   1871  C   VAL A 229       6.503  42.384   2.677  1.00 29.13           C  
ATOM   1872  O   VAL A 229       5.390  42.458   2.149  1.00 30.79           O  
ATOM   1873  CB  VAL A 229       6.830  43.791   4.709  1.00 27.56           C  
ATOM   1874  CG1 VAL A 229       5.688  44.665   4.212  1.00 28.39           C  
ATOM   1875  CG2 VAL A 229       6.873  43.793   6.228  1.00 29.05           C  
ATOM   1876  N   GLY A 230       7.640  42.335   1.992  1.00 27.37           N  
ATOM   1877  CA  GLY A 230       7.660  42.342   0.540  1.00 27.04           C  
ATOM   1878  C   GLY A 230       8.940  41.666   0.082  1.00 26.35           C  
ATOM   1879  O   GLY A 230       9.757  41.283   0.920  1.00 26.80           O  
ATOM   1880  N   PRO A 231       9.154  41.495  -1.231  1.00 25.53           N  
ATOM   1881  CA  PRO A 231      10.382  40.846  -1.702  1.00 24.83           C  
ATOM   1882  C   PRO A 231      11.636  41.641  -1.350  1.00 22.90           C  
ATOM   1883  O   PRO A 231      11.565  42.835  -1.051  1.00 22.65           O  
ATOM   1884  CB  PRO A 231      10.159  40.739  -3.211  1.00 25.40           C  
ATOM   1885  CG  PRO A 231       9.303  41.937  -3.505  1.00 26.81           C  
ATOM   1886  CD  PRO A 231       8.313  41.916  -2.366  1.00 27.50           C  
ATOM   1887  N   HIS A 232      12.785  40.971  -1.375  1.00 21.96           N  
ATOM   1888  CA  HIS A 232      14.048  41.626  -1.065  1.00 19.65           C  
ATOM   1889  C   HIS A 232      14.387  42.646  -2.151  1.00 21.16           C  
ATOM   1890  O   HIS A 232      14.046  42.458  -3.314  1.00 20.00           O  
ATOM   1891  CB  HIS A 232      15.178  40.595  -0.962  1.00 19.66           C  
ATOM   1892  CG  HIS A 232      15.403  39.814  -2.220  1.00 17.41           C  
ATOM   1893  ND1 HIS A 232      14.666  38.695  -2.546  1.00 19.21           N  
ATOM   1894  CD2 HIS A 232      16.272  40.002  -3.241  1.00 18.86           C  
ATOM   1895  CE1 HIS A 232      15.073  38.226  -3.712  1.00 18.28           C  
ATOM   1896  NE2 HIS A 232      16.047  39.001  -4.155  1.00 18.77           N  
ATOM   1897  N   GLN A 233      15.060  43.724  -1.769  1.00 20.78           N  
ATOM   1898  CA  GLN A 233      15.428  44.754  -2.733  1.00 21.47           C  
ATOM   1899  C   GLN A 233      16.937  44.936  -2.778  1.00 19.81           C  
ATOM   1900  O   GLN A 233      17.620  44.801  -1.764  1.00 20.00           O  
ATOM   1901  CB  GLN A 233      14.764  46.081  -2.366  1.00 24.59           C  
ATOM   1902  CG  GLN A 233      13.259  45.973  -2.168  1.00 28.07           C  
ATOM   1903  CD  GLN A 233      12.605  47.313  -1.901  1.00 32.19           C  
ATOM   1904  OE1 GLN A 233      13.075  48.094  -1.072  1.00 33.24           O  
ATOM   1905  NE2 GLN A 233      11.507  47.584  -2.600  1.00 33.00           N  
ATOM   1906  N   PHE A 234      17.454  45.240  -3.959  1.00 17.09           N  
ATOM   1907  CA  PHE A 234      18.884  45.452  -4.125  1.00 16.43           C  
ATOM   1908  C   PHE A 234      19.168  46.948  -4.131  1.00 16.20           C  
ATOM   1909  O   PHE A 234      18.511  47.714  -4.837  1.00 15.83           O  
ATOM   1910  CB  PHE A 234      19.367  44.820  -5.433  1.00 14.66           C  
ATOM   1911  CG  PHE A 234      19.220  43.325  -5.477  1.00 14.54           C  
ATOM   1912  CD1 PHE A 234      18.401  42.720  -6.428  1.00 13.83           C  
ATOM   1913  CD2 PHE A 234      19.916  42.518  -4.582  1.00 15.36           C  
ATOM   1914  CE1 PHE A 234      18.279  41.327  -6.490  1.00 16.23           C  
ATOM   1915  CE2 PHE A 234      19.803  41.126  -4.634  1.00 11.14           C  
ATOM   1916  CZ  PHE A 234      18.984  40.530  -5.589  1.00 13.54           C  
ATOM   1917  N   LEU A 235      20.151  47.356  -3.340  1.00 15.19           N  
ATOM   1918  CA  LEU A 235      20.522  48.761  -3.238  1.00 17.23           C  
ATOM   1919  C   LEU A 235      21.582  49.119  -4.275  1.00 17.33           C  
ATOM   1920  O   LEU A 235      22.664  48.535  -4.293  1.00 17.54           O  
ATOM   1921  CB  LEU A 235      21.060  49.045  -1.838  1.00 17.08           C  
ATOM   1922  CG  LEU A 235      21.271  50.493  -1.415  1.00 21.94           C  
ATOM   1923  CD1 LEU A 235      19.924  51.204  -1.322  1.00 22.61           C  
ATOM   1924  CD2 LEU A 235      21.979  50.518  -0.062  1.00 23.42           C  
ATOM   1925  N   GLY A 236      21.268  50.083  -5.133  1.00 19.25           N  
ATOM   1926  CA  GLY A 236      22.208  50.502  -6.155  1.00 19.04           C  
ATOM   1927  C   GLY A 236      21.551  50.672  -7.511  1.00 21.46           C  
ATOM   1928  O   GLY A 236      20.325  50.656  -7.620  1.00 20.66           O  
ATOM   1929  N   ASP A 237      22.372  50.839  -8.544  1.00 22.50           N  
ATOM   1930  CA  ASP A 237      21.890  50.998  -9.914  1.00 24.05           C  
ATOM   1931  C   ASP A 237      21.260  49.677 -10.351  1.00 24.15           C  
ATOM   1932  O   ASP A 237      21.955  48.668 -10.484  1.00 21.76           O  
ATOM   1933  CB  ASP A 237      23.061  51.332 -10.838  1.00 27.76           C  
ATOM   1934  CG  ASP A 237      22.617  51.657 -12.244  1.00 31.08           C  
ATOM   1935  OD1 ASP A 237      22.311  52.839 -12.512  1.00 33.79           O  
ATOM   1936  OD2 ASP A 237      22.561  50.727 -13.076  1.00 31.66           O  
ATOM   1937  N   GLN A 238      19.950  49.689 -10.585  1.00 23.74           N  
ATOM   1938  CA  GLN A 238      19.224  48.482 -10.974  1.00 25.97           C  
ATOM   1939  C   GLN A 238      19.698  47.818 -12.268  1.00 27.19           C  
ATOM   1940  O   GLN A 238      19.639  46.592 -12.397  1.00 25.48           O  
ATOM   1941  CB  GLN A 238      17.724  48.780 -11.061  1.00 26.36           C  
ATOM   1942  CG  GLN A 238      17.124  49.281  -9.748  1.00 28.16           C  
ATOM   1943  CD  GLN A 238      17.424  48.355  -8.574  1.00 29.11           C  
ATOM   1944  OE1 GLN A 238      17.006  47.195  -8.558  1.00 27.34           O  
ATOM   1945  NE2 GLN A 238      18.154  48.866  -7.587  1.00 27.60           N  
ATOM   1946  N   GLU A 239      20.157  48.615 -13.228  1.00 27.00           N  
ATOM   1947  CA  GLU A 239      20.640  48.059 -14.489  1.00 28.28           C  
ATOM   1948  C   GLU A 239      21.950  47.313 -14.273  1.00 26.77           C  
ATOM   1949  O   GLU A 239      22.145  46.222 -14.809  1.00 25.39           O  
ATOM   1950  CB  GLU A 239      20.832  49.168 -15.523  1.00 31.51           C  
ATOM   1951  CG  GLU A 239      19.527  49.727 -16.061  1.00 37.60           C  
ATOM   1952  CD  GLU A 239      19.725  51.001 -16.856  1.00 41.75           C  
ATOM   1953  OE1 GLU A 239      20.266  51.977 -16.291  1.00 43.51           O  
ATOM   1954  OE2 GLU A 239      19.336  51.027 -18.044  1.00 44.65           O  
ATOM   1955  N   ALA A 240      22.847  47.899 -13.485  1.00 25.12           N  
ATOM   1956  CA  ALA A 240      24.130  47.267 -13.202  1.00 25.02           C  
ATOM   1957  C   ALA A 240      23.899  46.011 -12.366  1.00 24.11           C  
ATOM   1958  O   ALA A 240      24.612  45.017 -12.506  1.00 23.85           O  
ATOM   1959  CB  ALA A 240      25.039  48.232 -12.456  1.00 25.34           C  
ATOM   1960  N   ILE A 241      22.895  46.064 -11.498  1.00 22.46           N  
ATOM   1961  CA  ILE A 241      22.561  44.931 -10.646  1.00 22.32           C  
ATOM   1962  C   ILE A 241      22.024  43.760 -11.477  1.00 23.31           C  
ATOM   1963  O   ILE A 241      22.435  42.614 -11.282  1.00 22.04           O  
ATOM   1964  CB  ILE A 241      21.527  45.342  -9.572  1.00 22.36           C  
ATOM   1965  CG1 ILE A 241      22.198  46.285  -8.563  1.00 22.33           C  
ATOM   1966  CG2 ILE A 241      20.957  44.104  -8.879  1.00 20.85           C  
ATOM   1967  CD1 ILE A 241      21.238  46.942  -7.592  1.00 24.67           C  
ATOM   1968  N   GLN A 242      21.113  44.037 -12.404  1.00 23.16           N  
ATOM   1969  CA  GLN A 242      20.579  42.963 -13.234  1.00 24.45           C  
ATOM   1970  C   GLN A 242      21.673  42.414 -14.145  1.00 22.98           C  
ATOM   1971  O   GLN A 242      21.693  41.224 -14.456  1.00 23.03           O  
ATOM   1972  CB  GLN A 242      19.385  43.451 -14.062  1.00 27.58           C  
ATOM   1973  CG  GLN A 242      18.133  43.671 -13.223  1.00 31.75           C  
ATOM   1974  CD  GLN A 242      17.668  42.402 -12.509  1.00 35.02           C  
ATOM   1975  OE1 GLN A 242      17.014  42.468 -11.466  1.00 35.82           O  
ATOM   1976  NE2 GLN A 242      17.995  41.244 -13.074  1.00 35.12           N  
ATOM   1977  N   ALA A 243      22.593  43.280 -14.556  1.00 22.10           N  
ATOM   1978  CA  ALA A 243      23.691  42.856 -15.412  1.00 22.17           C  
ATOM   1979  C   ALA A 243      24.615  41.921 -14.630  1.00 21.38           C  
ATOM   1980  O   ALA A 243      25.113  40.932 -15.169  1.00 22.20           O  
ATOM   1981  CB  ALA A 243      24.465  44.071 -15.911  1.00 21.99           C  
ATOM   1982  N   ALA A 244      24.834  42.234 -13.356  1.00 20.48           N  
ATOM   1983  CA  ALA A 244      25.693  41.417 -12.499  1.00 18.70           C  
ATOM   1984  C   ALA A 244      25.043  40.061 -12.257  1.00 18.93           C  
ATOM   1985  O   ALA A 244      25.722  39.035 -12.176  1.00 19.21           O  
ATOM   1986  CB  ALA A 244      25.934  42.120 -11.173  1.00 17.49           C  
ATOM   1987  N   ILE A 245      23.721  40.067 -12.127  1.00 17.44           N  
ATOM   1988  CA  ILE A 245      22.974  38.838 -11.917  1.00 16.98           C  
ATOM   1989  C   ILE A 245      23.094  37.948 -13.152  1.00 18.19           C  
ATOM   1990  O   ILE A 245      23.333  36.746 -13.042  1.00 15.43           O  
ATOM   1991  CB  ILE A 245      21.485  39.143 -11.638  1.00 16.73           C  
ATOM   1992  CG1 ILE A 245      21.344  39.798 -10.260  1.00 16.34           C  
ATOM   1993  CG2 ILE A 245      20.656  37.867 -11.721  1.00 14.32           C  
ATOM   1994  CD1 ILE A 245      19.919  40.171  -9.900  1.00 16.59           C  
ATOM   1995  N   LYS A 246      22.941  38.544 -14.332  1.00 19.03           N  
ATOM   1996  CA  LYS A 246      23.036  37.787 -15.581  1.00 20.46           C  
ATOM   1997  C   LYS A 246      24.421  37.157 -15.707  1.00 19.42           C  
ATOM   1998  O   LYS A 246      24.563  36.029 -16.179  1.00 19.24           O  
ATOM   1999  CB  LYS A 246      22.775  38.701 -16.784  1.00 22.08           C  
ATOM   2000  CG  LYS A 246      22.731  37.963 -18.119  1.00 25.77           C  
ATOM   2001  CD  LYS A 246      22.421  38.910 -19.271  1.00 26.53           C  
ATOM   2002  CE  LYS A 246      22.196  38.149 -20.573  1.00 29.12           C  
ATOM   2003  NZ  LYS A 246      23.340  37.265 -20.920  1.00 27.35           N  
ATOM   2004  N   LYS A 247      25.435  37.905 -15.283  1.00 19.83           N  
ATOM   2005  CA  LYS A 247      26.820  37.455 -15.323  1.00 20.06           C  
ATOM   2006  C   LYS A 247      26.976  36.173 -14.509  1.00 18.70           C  
ATOM   2007  O   LYS A 247      27.610  35.211 -14.954  1.00 16.51           O  
ATOM   2008  CB  LYS A 247      27.727  38.548 -14.754  1.00 22.12           C  
ATOM   2009  CG  LYS A 247      29.207  38.215 -14.754  1.00 29.44           C  
ATOM   2010  CD  LYS A 247      29.991  39.330 -14.083  1.00 32.35           C  
ATOM   2011  CE  LYS A 247      31.473  39.024 -14.015  1.00 35.89           C  
ATOM   2012  NZ  LYS A 247      32.196  40.090 -13.260  1.00 39.47           N  
ATOM   2013  N   VAL A 248      26.403  36.172 -13.310  1.00 15.57           N  
ATOM   2014  CA  VAL A 248      26.460  35.004 -12.440  1.00 14.43           C  
ATOM   2015  C   VAL A 248      25.697  33.842 -13.077  1.00 14.94           C  
ATOM   2016  O   VAL A 248      26.158  32.700 -13.042  1.00 13.72           O  
ATOM   2017  CB  VAL A 248      25.856  35.316 -11.049  1.00 13.61           C  
ATOM   2018  CG1 VAL A 248      25.730  34.039 -10.234  1.00 14.06           C  
ATOM   2019  CG2 VAL A 248      26.746  36.325 -10.317  1.00 13.55           C  
ATOM   2020  N   GLU A 249      24.536  34.129 -13.662  1.00 13.99           N  
ATOM   2021  CA  GLU A 249      23.748  33.083 -14.311  1.00 16.33           C  
ATOM   2022  C   GLU A 249      24.542  32.481 -15.473  1.00 16.98           C  
ATOM   2023  O   GLU A 249      24.605  31.260 -15.634  1.00 16.96           O  
ATOM   2024  CB  GLU A 249      22.430  33.653 -14.847  1.00 17.97           C  
ATOM   2025  CG  GLU A 249      21.531  34.262 -13.780  1.00 19.88           C  
ATOM   2026  CD  GLU A 249      20.264  34.866 -14.358  1.00 22.38           C  
ATOM   2027  OE1 GLU A 249      20.351  35.532 -15.413  1.00 20.29           O  
ATOM   2028  OE2 GLU A 249      19.186  34.689 -13.749  1.00 20.37           O  
ATOM   2029  N   ASP A 250      25.154  33.347 -16.274  1.00 16.57           N  
ATOM   2030  CA  ASP A 250      25.930  32.915 -17.431  1.00 17.95           C  
ATOM   2031  C   ASP A 250      27.174  32.073 -17.129  1.00 17.08           C  
ATOM   2032  O   ASP A 250      27.712  31.422 -18.023  1.00 16.24           O  
ATOM   2033  CB  ASP A 250      26.317  34.127 -18.283  1.00 19.17           C  
ATOM   2034  CG  ASP A 250      25.117  34.766 -18.966  1.00 20.58           C  
ATOM   2035  OD1 ASP A 250      24.045  34.127 -19.014  1.00 19.96           O  
ATOM   2036  OD2 ASP A 250      25.249  35.902 -19.466  1.00 22.98           O  
ATOM   2037  N   GLN A 251      27.641  32.077 -15.886  1.00 16.40           N  
ATOM   2038  CA  GLN A 251      28.812  31.272 -15.548  1.00 16.01           C  
ATOM   2039  C   GLN A 251      28.506  29.791 -15.720  1.00 15.48           C  
ATOM   2040  O   GLN A 251      29.415  28.970 -15.852  1.00 14.81           O  
ATOM   2041  CB  GLN A 251      29.250  31.514 -14.103  1.00 15.46           C  
ATOM   2042  CG  GLN A 251      29.821  32.887 -13.837  1.00 19.84           C  
ATOM   2043  CD  GLN A 251      30.240  33.041 -12.398  1.00 20.37           C  
ATOM   2044  OE1 GLN A 251      29.453  32.787 -11.486  1.00 22.08           O  
ATOM   2045  NE2 GLN A 251      31.484  33.453 -12.181  1.00 20.96           N  
ATOM   2046  N   GLY A 252      27.220  29.454 -15.708  1.00 13.58           N  
ATOM   2047  CA  GLY A 252      26.827  28.065 -15.856  1.00 15.85           C  
ATOM   2048  C   GLY A 252      26.356  27.716 -17.253  1.00 16.60           C  
ATOM   2049  O   GLY A 252      25.744  26.670 -17.456  1.00 18.11           O  
ATOM   2050  N   LYS A 253      26.652  28.580 -18.219  1.00 18.06           N  
ATOM   2051  CA  LYS A 253      26.232  28.349 -19.599  1.00 19.23           C  
ATOM   2052  C   LYS A 253      27.407  28.220 -20.556  1.00 21.63           C  
ATOM   2053  O   LYS A 253      28.493  28.747 -20.307  1.00 18.43           O  
ATOM   2054  CB  LYS A 253      25.334  29.490 -20.084  1.00 18.57           C  
ATOM   2055  CG  LYS A 253      24.022  29.645 -19.325  1.00 22.16           C  
ATOM   2056  CD  LYS A 253      23.164  30.725 -19.975  1.00 24.96           C  
ATOM   2057  CE  LYS A 253      21.799  30.842 -19.321  1.00 26.49           C  
ATOM   2058  NZ  LYS A 253      20.947  31.845 -20.029  1.00 24.64           N  
ATOM   2059  N   VAL A 254      27.172  27.519 -21.659  1.00 26.08           N  
ATOM   2060  CA  VAL A 254      28.191  27.328 -22.679  1.00 30.54           C  
ATOM   2061  C   VAL A 254      28.200  28.567 -23.570  1.00 32.91           C  
ATOM   2062  O   VAL A 254      27.183  29.248 -23.703  1.00 33.11           O  
ATOM   2063  CB  VAL A 254      27.890  26.077 -23.537  1.00 32.21           C  
ATOM   2064  CG1 VAL A 254      27.823  24.844 -22.647  1.00 31.76           C  
ATOM   2065  CG2 VAL A 254      26.582  26.259 -24.288  1.00 34.70           C  
ATOM   2066  N   LYS A 255      29.347  28.861 -24.172  1.00 36.24           N  
ATOM   2067  CA  LYS A 255      29.473  30.023 -25.043  1.00 39.82           C  
ATOM   2068  C   LYS A 255      28.480  29.948 -26.200  1.00 41.71           C  
ATOM   2069  O   LYS A 255      28.192  28.865 -26.714  1.00 42.53           O  
ATOM   2070  CB  LYS A 255      30.902  30.123 -25.580  1.00 39.55           C  
ATOM   2071  N   GLN A 256      27.956  31.101 -26.603  1.00 43.82           N  
ATOM   2072  CA  GLN A 256      26.997  31.160 -27.703  1.00 46.08           C  
ATOM   2073  C   GLN A 256      27.336  32.301 -28.664  1.00 47.30           C  
ATOM   2074  O   GLN A 256      28.350  32.992 -28.428  1.00 47.63           O  
ATOM   2075  CB  GLN A 256      25.584  31.336 -27.154  1.00 46.11           C  
TER    2076      GLN A 256                                                      
END
MOLECULE T0394.pdb
ATOM      1  N   ASN     1       7.131  28.263  26.435  1.00 37.08           N  
ATOM      2  CA  ASN     1       7.437  29.315  25.416  1.00 36.05           C  
ATOM      3  C   ASN     1       7.192  30.735  25.903  1.00 34.53           C  
ATOM      4  O   ASN     1       6.216  30.997  26.611  1.00 34.93           O  
ATOM      5  CB  ASN     1       6.662  29.047  24.125  1.00 37.00           C  
ATOM      6  CG  ASN     1       7.395  28.086  23.213  1.00 39.47           C  
ATOM      7  OD1 ASN     1       7.200  26.869  23.286  1.00 43.62           O  
ATOM      8  ND2 ASN     1       8.288  28.624  22.384  1.00 40.23           N  
ATOM      9  N   LEU     2       8.082  31.640  25.492  1.00 32.19           N  
ATOM     10  CA  LEU     2       8.122  33.016  25.993  1.00 29.95           C  
ATOM     11  C   LEU     2       7.110  33.917  25.298  1.00 28.07           C  
ATOM     12  O   LEU     2       6.983  33.894  24.068  1.00 28.29           O  
ATOM     13  CB  LEU     2       9.527  33.600  25.804  1.00 29.69           C  
ATOM     14  CG  LEU     2      10.670  32.930  26.564  1.00 29.92           C  
ATOM     15  CD1 LEU     2      12.000  33.222  25.886  1.00 29.23           C  
ATOM     16  CD2 LEU     2      10.663  33.446  27.989  1.00 28.60           C  
ATOM     17  N   TYR     3       6.407  34.722  26.095  1.00 25.72           N  
ATOM     18  CA  TYR     3       5.529  35.769  25.587  1.00 24.38           C  
ATOM     19  C   TYR     3       6.320  37.041  25.320  1.00 23.44           C  
ATOM     20  O   TYR     3       7.033  37.574  26.203  1.00 21.70           O  
ATOM     21  CB  TYR     3       4.386  36.067  26.569  1.00 24.95           C  
ATOM     22  CG  TYR     3       3.542  37.283  26.201  1.00 24.49           C  
ATOM     23  CD1 TYR     3       2.296  37.140  25.578  1.00 25.41           C  
ATOM     24  CD2 TYR     3       3.986  38.574  26.489  1.00 24.54           C  
ATOM     25  CE1 TYR     3       1.528  38.265  25.239  1.00 26.31           C  
ATOM     26  CE2 TYR     3       3.232  39.700  26.154  1.00 24.99           C  
ATOM     27  CZ  TYR     3       2.015  39.541  25.528  1.00 26.12           C  
ATOM     28  OH  TYR     3       1.282  40.675  25.217  1.00 29.19           O  
ATOM     29  N   PHE     4       6.198  37.532  24.092  1.00 21.28           N  
ATOM     30  CA  PHE     4       6.804  38.796  23.732  1.00 21.92           C  
ATOM     31  C   PHE     4       5.758  39.769  23.248  1.00 22.33           C  
ATOM     32  O   PHE     4       4.744  39.358  22.707  1.00 21.26           O  
ATOM     33  CB  PHE     4       7.841  38.598  22.620  1.00 21.80           C  
ATOM     34  CG  PHE     4       9.019  37.763  23.036  1.00 20.69           C  
ATOM     35  CD1 PHE     4       9.930  38.245  23.973  1.00 18.93           C  
ATOM     36  CD2 PHE     4       9.209  36.497  22.501  1.00 21.68           C  
ATOM     37  CE1 PHE     4      11.035  37.458  24.352  1.00 20.05           C  
ATOM     38  CE2 PHE     4      10.302  35.717  22.866  1.00 22.45           C  
ATOM     39  CZ  PHE     4      11.222  36.218  23.803  1.00 21.82           C  
ATOM     40  N   GLN     5       6.032  41.054  23.450  1.00 22.99           N  
ATOM     41  CA  GLN     5       5.226  42.107  22.871  1.00 24.75           C  
ATOM     42  C   GLN     5       5.521  42.151  21.367  1.00 23.85           C  
ATOM     43  O   GLN     5       6.451  41.461  20.899  1.00 23.54           O  
ATOM     44  CB  GLN     5       5.532  43.444  23.553  1.00 26.07           C  
ATOM     45  CG  GLN     5       5.034  43.473  25.022  1.00 31.04           C  
ATOM     46  CD  GLN     5       4.811  44.878  25.566  1.00 37.81           C  
ATOM     47  OE1 GLN     5       5.661  45.777  25.403  1.00 41.06           O  
ATOM     48  NE2 GLN     5       3.660  45.079  26.215  1.00 38.49           N  
ATOM     49  N   SER     6       4.726  42.924  20.628  1.00 23.52           N  
ATOM     50  CA  SER     6       4.940  43.126  19.191  0.50 23.55           C  
ATOM     52  C   SER     6       6.337  43.702  18.962  1.00 22.75           C  
ATOM     53  O   SER     6       6.858  44.463  19.805  1.00 22.96           O  
ATOM     54  CB  SER     6       3.856  44.057  18.638  0.50 23.94           C  
ATOM     56  OG  SER     6       3.940  44.174  17.233  0.50 25.41           O  
ATOM     58  N   ALA     7       6.977  43.335  17.852  1.00 21.09           N  
ATOM     59  CA  ALA     7       8.341  43.796  17.589  1.00 19.34           C  
ATOM     60  C   ALA     7       8.616  43.806  16.096  1.00 18.62           C  
ATOM     61  O   ALA     7       7.962  43.078  15.352  1.00 17.81           O  
ATOM     62  CB  ALA     7       9.361  42.902  18.314  1.00 18.58           C  
ATOM     63  N   ARG     8       9.540  44.662  15.692  1.00 17.77           N  
ATOM     64  CA  ARG     8       9.981  44.808  14.311  1.00 18.09           C  
ATOM     65  C   ARG     8      11.475  45.003  14.342  1.00 17.38           C  
ATOM     66  O   ARG     8      11.988  45.711  15.227  1.00 16.45           O  
ATOM     67  CB  ARG     8       9.398  46.071  13.683  1.00 19.36           C  
ATOM     68  CG  ARG     8       7.946  46.007  13.335  1.00 23.70           C  
ATOM     69  CD  ARG     8       7.465  47.406  12.982  1.00 28.18           C  
ATOM     70  NE  ARG     8       7.941  47.887  11.680  1.00 30.83           N  
ATOM     71  CZ  ARG     8       8.710  48.960  11.501  1.00 30.42           C  
ATOM     72  NH1 ARG     8       9.117  49.682  12.536  1.00 32.52           N  
ATOM     73  NH2 ARG     8       9.060  49.316  10.274  1.00 29.09           N  
ATOM     74  N   PHE     9      12.184  44.376  13.397  1.00 15.44           N  
ATOM     75  CA  PHE     9      13.609  44.661  13.228  1.00 14.36           C  
ATOM     76  C   PHE     9      14.024  44.617  11.750  1.00 14.07           C  
ATOM     77  O   PHE     9      13.327  44.021  10.922  1.00 14.11           O  
ATOM     78  CB  PHE     9      14.503  43.808  14.139  1.00 14.06           C  
ATOM     79  CG  PHE     9      14.646  42.339  13.723  1.00 14.99           C  
ATOM     80  CD1 PHE     9      15.716  41.917  12.893  1.00 14.73           C  
ATOM     81  CD2 PHE     9      13.778  41.373  14.237  1.00 14.99           C  
ATOM     82  CE1 PHE     9      15.873  40.529  12.575  1.00 15.03           C  
ATOM     83  CE2 PHE     9      13.931  40.017  13.902  1.00 13.86           C  
ATOM     84  CZ  PHE     9      14.979  39.616  13.065  1.00 15.53           C  
ATOM     85  N   ALA    10      15.107  45.315  11.432  1.00 13.59           N  
ATOM     86  CA  ALA    10      15.614  45.381  10.074  1.00 13.29           C  
ATOM     87  C   ALA    10      16.736  44.351   9.943  1.00 12.11           C  
ATOM     88  O   ALA    10      17.515  44.114  10.867  1.00 12.79           O  
ATOM     89  CB  ALA    10      16.127  46.747   9.770  1.00 13.92           C  
ATOM     90  N   LEU    11      16.820  43.776   8.765  1.00 11.89           N  
ATOM     91  CA  LEU    11      17.884  42.825   8.461  1.00 11.66           C  
ATOM     92  C   LEU    11      18.479  43.206   7.106  1.00 11.25           C  
ATOM     93  O   LEU    11      17.791  43.100   6.088  1.00 11.70           O  
ATOM     94  CB  LEU    11      17.268  41.424   8.382  1.00 11.80           C  
ATOM     95  CG  LEU    11      18.199  40.311   7.867  1.00 11.81           C  
ATOM     96  CD1 LEU    11      19.499  40.184   8.709  1.00 11.54           C  
ATOM     97  CD2 LEU    11      17.431  38.946   7.835  1.00 11.16           C  
ATOM     98  N   THR    12      19.739  43.651   7.093  1.00 11.06           N  
ATOM     99  CA  THR    12      20.437  43.941   5.843  1.00 10.80           C  
ATOM    100  C   THR    12      21.431  42.812   5.554  1.00 10.75           C  
ATOM    101  O   THR    12      22.268  42.492   6.427  1.00 10.78           O  
ATOM    102  CB  THR    12      21.207  45.258   5.979  1.00 12.04           C  
ATOM    103  OG1 THR    12      20.261  46.309   6.268  1.00 13.87           O  
ATOM    104  CG2 THR    12      21.944  45.545   4.716  1.00 11.84           C  
ATOM    105  N   VAL    13      21.329  42.215   4.366  1.00 10.59           N  
ATOM    106  CA  VAL    13      22.159  41.059   3.976  1.00 10.00           C  
ATOM    107  C   VAL    13      23.009  41.448   2.754  1.00 10.55           C  
ATOM    108  O   VAL    13      22.471  41.918   1.733  1.00 10.36           O  
ATOM    109  CB  VAL    13      21.256  39.828   3.638  1.00 10.02           C  
ATOM    110  CG1 VAL    13      22.153  38.561   3.516  1.00  9.93           C  
ATOM    111  CG2 VAL    13      20.243  39.644   4.736  1.00 12.14           C  
ATOM    112  N   VAL    14      24.327  41.288   2.872  1.00 10.61           N  
ATOM    113  CA  VAL    14      25.251  41.780   1.877  1.00 10.14           C  
ATOM    114  C   VAL    14      26.202  40.645   1.457  1.00 10.94           C  
ATOM    115  O   VAL    14      26.790  40.007   2.325  1.00 10.94           O  
ATOM    116  CB  VAL    14      26.075  42.959   2.446  1.00 11.36           C  
ATOM    117  CG1 VAL    14      27.056  43.456   1.382  1.00  9.89           C  
ATOM    118  CG2 VAL    14      25.134  44.137   2.849  1.00 12.81           C  
ATOM    119  N   ARG    15      26.318  40.368   0.158  1.00 10.04           N  
ATOM    120  CA  ARG    15      27.289  39.336  -0.282  1.00 10.79           C  
ATOM    121  C   ARG    15      28.699  39.909  -0.117  1.00 10.29           C  
ATOM    122  O   ARG    15      28.904  41.106  -0.283  1.00 11.57           O  
ATOM    123  CB  ARG    15      27.048  38.936  -1.768  1.00  9.43           C  
ATOM    124  CG  ARG    15      28.024  37.834  -2.263  1.00 11.35           C  
ATOM    125  CD  ARG    15      27.585  37.222  -3.602  1.00 12.46           C  
ATOM    126  NE  ARG    15      28.624  36.330  -4.093  1.00 13.39           N  
ATOM    127  CZ  ARG    15      29.143  36.335  -5.318  1.00 15.37           C  
ATOM    128  NH1 ARG    15      28.674  37.137  -6.260  1.00 14.12           N  
ATOM    129  NH2 ARG    15      30.131  35.500  -5.608  1.00 13.89           N  
ATOM    130  N   HIS    16      29.679  39.062   0.166  1.00 11.14           N  
ATOM    131  CA  HIS    16      31.080  39.515   0.244  1.00 11.40           C  
ATOM    132  C   HIS    16      31.557  40.087  -1.118  1.00 12.40           C  
ATOM    133  O   HIS    16      30.975  39.795  -2.202  1.00 12.27           O  
ATOM    134  CB  HIS    16      31.969  38.326   0.622  1.00 11.89           C  
ATOM    135  CG  HIS    16      31.909  37.244  -0.383  1.00 11.77           C  
ATOM    136  ND1 HIS    16      32.675  37.259  -1.532  1.00 10.88           N  
ATOM    137  CD2 HIS    16      31.113  36.155  -0.466  1.00 14.23           C  
ATOM    138  CE1 HIS    16      32.387  36.191  -2.256  1.00 16.26           C  
ATOM    139  NE2 HIS    16      31.442  35.506  -1.630  1.00 14.39           N  
ATOM    140  N   GLY    17      32.636  40.876  -1.055  1.00 12.57           N  
ATOM    141  CA  GLY    17      33.265  41.387  -2.260  1.00 12.64           C  
ATOM    142  C   GLY    17      33.923  40.326  -3.120  1.00 13.60           C  
ATOM    143  O   GLY    17      34.100  39.176  -2.698  1.00 12.67           O  
ATOM    144  N   GLU    18      34.245  40.696  -4.356  1.00 12.79           N  
ATOM    145  CA  GLU    18      34.855  39.768  -5.308  1.00 14.33           C  
ATOM    146  C   GLU    18      36.181  39.161  -4.816  1.00 14.19           C  
ATOM    147  O   GLU    18      36.985  39.853  -4.170  1.00 13.24           O  
ATOM    148  CB  GLU    18      35.072  40.498  -6.641  1.00 15.58           C  
ATOM    149  CG  GLU    18      35.615  39.646  -7.737  1.00 18.58           C  
ATOM    150  CD  GLU    18      36.423  40.473  -8.747  1.00 26.24           C  
ATOM    151  OE1 GLU    18      37.548  40.925  -8.432  1.00 28.76           O  
ATOM    152  OE2 GLU    18      35.935  40.634  -9.857  1.00 27.17           O  
ATOM    153  N   THR    19      36.361  37.856  -5.065  1.00 14.63           N  
ATOM    154  CA  THR    19      37.661  37.193  -4.893  1.00 15.69           C  
ATOM    155  C   THR    19      38.223  36.845  -6.260  1.00 16.12           C  
ATOM    156  O   THR    19      37.525  36.893  -7.282  1.00 15.11           O  
ATOM    157  CB  THR    19      37.572  35.837  -4.120  1.00 14.87           C  
ATOM    158  OG1 THR    19      36.910  34.873  -4.955  1.00 16.55           O  
ATOM    159  CG2 THR    19      36.837  35.983  -2.742  1.00 12.93           C  
ATOM    160  N   ARG    20      39.495  36.453  -6.260  1.00 16.97           N  
ATOM    161  CA  ARG    20      40.161  35.912  -7.443  1.00 18.93           C  
ATOM    162  C   ARG    20      39.322  34.822  -8.158  1.00 19.29           C  
ATOM    163  O   ARG    20      39.202  34.812  -9.396  1.00 20.04           O  
ATOM    164  CB  ARG    20      41.546  35.408  -6.992  1.00 19.32           C  
ATOM    165  CG  ARG    20      42.275  34.361  -7.777  1.00 22.18           C  
ATOM    166  CD  ARG    20      43.709  34.338  -7.214  1.00 21.66           C  
ATOM    167  NE  ARG    20      43.840  33.443  -6.063  1.00 20.51           N  
ATOM    168  CZ  ARG    20      44.436  32.262  -6.102  1.00 22.87           C  
ATOM    169  NH1 ARG    20      44.481  31.517  -5.016  1.00 24.91           N  
ATOM    170  NH2 ARG    20      44.975  31.823  -7.228  1.00 23.22           N  
ATOM    171  N   PHE    21      38.714  33.939  -7.373  1.00 17.76           N  
ATOM    172  CA  PHE    21      37.948  32.834  -7.941  1.00 17.97           C  
ATOM    173  C   PHE    21      36.604  33.277  -8.506  1.00 17.74           C  
ATOM    174  O   PHE    21      36.151  32.759  -9.544  1.00 16.99           O  
ATOM    175  CB  PHE    21      37.833  31.701  -6.911  1.00 19.01           C  
ATOM    176  CG  PHE    21      39.181  31.131  -6.530  1.00 20.00           C  
ATOM    177  CD1 PHE    21      40.117  30.838  -7.512  1.00 23.92           C  
ATOM    178  CD2 PHE    21      39.525  30.940  -5.202  1.00 24.47           C  
ATOM    179  CE1 PHE    21      41.375  30.310  -7.171  1.00 24.93           C  
ATOM    180  CE2 PHE    21      40.774  30.412  -4.859  1.00 25.63           C  
ATOM    181  CZ  PHE    21      41.691  30.099  -5.842  1.00 24.75           C  
ATOM    182  N   ASN    22      35.962  34.229  -7.840  1.00 17.57           N  
ATOM    183  CA  ASN    22      34.719  34.794  -8.414  1.00 18.52           C  
ATOM    184  C   ASN    22      34.988  35.351  -9.818  1.00 19.89           C  
ATOM    185  O   ASN    22      34.228  35.105 -10.771  1.00 19.51           O  
ATOM    186  CB  ASN    22      34.190  35.907  -7.554  1.00 18.37           C  
ATOM    187  CG  ASN    22      33.602  35.407  -6.245  1.00 19.37           C  
ATOM    188  OD1 ASN    22      33.150  34.237  -6.104  1.00 18.97           O  
ATOM    189  ND2 ASN    22      33.568  36.286  -5.301  1.00 13.55           N  
ATOM    190  N   LYS    23      36.093  36.074  -9.948  1.00 20.75           N  
ATOM    191  CA  LYS    23      36.443  36.692 -11.235  1.00 23.46           C  
ATOM    192  C   LYS    23      36.623  35.624 -12.306  1.00 24.29           C  
ATOM    193  O   LYS    23      36.138  35.776 -13.428  1.00 25.47           O  
ATOM    194  CB  LYS    23      37.690  37.556 -11.072  1.00 23.52           C  
ATOM    195  CG  LYS    23      38.222  38.212 -12.349  1.00 27.47           C  
ATOM    196  CD  LYS    23      37.326  39.322 -12.822  1.00 32.44           C  
ATOM    197  CE  LYS    23      38.108  40.299 -13.700  1.00 35.21           C  
ATOM    198  NZ  LYS    23      37.221  41.431 -14.082  1.00 39.24           N  
ATOM    199  N   GLU    24      37.280  34.531 -11.936  1.00 25.02           N  
ATOM    200  CA  GLU    24      37.646  33.470 -12.881  1.00 26.99           C  
ATOM    201  C   GLU    24      36.574  32.393 -13.025  1.00 26.34           C  
ATOM    202  O   GLU    24      36.802  31.393 -13.728  1.00 27.71           O  
ATOM    203  CB  GLU    24      38.981  32.836 -12.465  1.00 27.65           C  
ATOM    204  CG  GLU    24      40.141  33.811 -12.232  1.00 30.31           C  
ATOM    205  CD  GLU    24      40.401  34.779 -13.408  1.00 36.92           C  
ATOM    206  OE1 GLU    24      40.063  34.451 -14.569  1.00 38.73           O  
ATOM    207  OE2 GLU    24      40.950  35.884 -13.159  1.00 38.71           O  
ATOM    208  N   LYS    25      35.421  32.604 -12.378  1.00 25.57           N  
ATOM    209  CA  LYS    25      34.277  31.667 -12.408  1.00 24.89           C  
ATOM    210  C   LYS    25      34.691  30.274 -11.910  1.00 22.95           C  
ATOM    211  O   LYS    25      34.323  29.237 -12.514  1.00 24.07           O  
ATOM    212  CB  LYS    25      33.655  31.563 -13.820  1.00 26.00           C  
ATOM    213  CG  LYS    25      33.068  32.889 -14.367  1.00 30.31           C  
ATOM    214  CD  LYS    25      31.531  32.954 -14.285  1.00 37.00           C  
ATOM    215  CE  LYS    25      30.851  32.201 -15.442  1.00 39.72           C  
ATOM    216  NZ  LYS    25      29.358  32.126 -15.292  1.00 41.81           N  
ATOM    217  N   ILE    26      35.474  30.269 -10.834  1.00 20.24           N  
ATOM    218  CA  ILE    26      35.921  29.042 -10.172  0.50 19.68           C  
ATOM    220  C   ILE    26      35.057  28.826  -8.941  1.00 18.78           C  
ATOM    221  O   ILE    26      34.810  29.759  -8.172  1.00 18.27           O  
ATOM    222  CB  ILE    26      37.425  29.134  -9.782  0.50 19.24           C  
ATOM    224  CG1 ILE    26      38.297  29.028 -11.046  0.50 20.15           C  
ATOM    226  CG2 ILE    26      37.834  28.074  -8.758  0.50 19.79           C  
ATOM    228  CD1 ILE    26      39.716  29.509 -10.829  0.50 19.10           C  
ATOM    230  N   ILE    27      34.588  27.598  -8.779  1.00 17.64           N  
ATOM    231  CA  ILE    27      33.708  27.274  -7.670  0.50 17.31           C  
ATOM    233  C   ILE    27      34.422  27.476  -6.353  1.00 17.86           C  
ATOM    234  O   ILE    27      35.542  27.019  -6.154  1.00 16.33           O  
ATOM    235  CB  ILE    27      33.170  25.849  -7.774  0.50 16.83           C  
ATOM    237  CG1 ILE    27      32.426  25.673  -9.102  0.50 18.12           C  
ATOM    239  CG2 ILE    27      32.228  25.543  -6.610  0.50 15.69           C  
ATOM    241  CD1 ILE    27      32.230  24.258  -9.481  0.50 17.55           C  
ATOM    243  N   GLN    28      33.712  28.157  -5.457  1.00 19.94           N  
ATOM    244  CA  GLN    28      34.188  28.558  -4.186  1.00 21.00           C  
ATOM    245  C   GLN    28      33.026  28.413  -3.207  1.00 20.63           C  
ATOM    246  O   GLN    28      32.128  29.284  -3.155  1.00 21.79           O  
ATOM    247  CB  GLN    28      34.493  30.038  -4.326  1.00 22.79           C  
ATOM    248  CG  GLN    28      35.186  30.690  -3.187  1.00 25.95           C  
ATOM    249  CD  GLN    28      35.402  32.143  -3.518  1.00 23.19           C  
ATOM    250  OE1 GLN    28      34.439  32.916  -3.650  1.00 26.05           O  
ATOM    251  NE2 GLN    28      36.658  32.528  -3.684  1.00 18.04           N  
ATOM    252  N   GLY    29      33.023  27.314  -2.470  1.00 18.42           N  
ATOM    253  CA  GLY    29      32.073  27.123  -1.387  1.00 18.14           C  
ATOM    254  C   GLY    29      32.830  27.131  -0.072  1.00 18.33           C  
ATOM    255  O   GLY    29      33.116  28.190   0.473  1.00 18.58           O  
ATOM    256  N   GLN    30      33.180  25.950   0.427  1.00 18.10           N  
ATOM    257  CA  GLN    30      33.966  25.825   1.659  1.00 19.44           C  
ATOM    258  C   GLN    30      35.303  25.107   1.278  1.00 21.53           C  
ATOM    259  O   GLN    30      35.699  24.135   1.898  1.00 22.52           O  
ATOM    260  CB  GLN    30      33.146  25.074   2.757  1.00 18.80           C  
ATOM    261  CG  GLN    30      31.821  25.772   3.166  1.00 17.51           C  
ATOM    262  CD  GLN    30      31.107  25.155   4.393  1.00 18.30           C  
ATOM    263  OE1 GLN    30      31.751  24.637   5.332  1.00 17.71           O  
ATOM    264  NE2 GLN    30      29.785  25.260   4.418  1.00 15.39           N  
ATOM    265  N   GLY    31      35.971  25.592   0.233  1.00 23.08           N  
ATOM    266  CA  GLY    31      37.221  24.988  -0.236  1.00 24.28           C  
ATOM    267  C   GLY    31      38.442  25.756   0.219  1.00 24.89           C  
ATOM    268  O   GLY    31      38.798  25.700   1.396  1.00 24.91           O  
ATOM    269  N   VAL    32      39.121  26.439  -0.706  1.00 24.97           N  
ATOM    270  CA  VAL    32      40.138  27.382  -0.288  1.00 24.40           C  
ATOM    271  C   VAL    32      39.368  28.547   0.340  1.00 22.92           C  
ATOM    272  O   VAL    32      38.374  29.027  -0.170  1.00 23.11           O  
ATOM    273  CB  VAL    32      41.112  27.879  -1.434  1.00 25.58           C  
ATOM    274  CG1 VAL    32      41.796  29.243  -1.078  1.00 25.76           C  
ATOM    275  CG2 VAL    32      42.175  26.840  -1.736  1.00 26.45           C  
ATOM    276  N   ASP    33      39.840  28.949   1.490  1.00 21.48           N  
ATOM    277  CA  ASP    33      39.335  30.116   2.151  1.00 19.20           C  
ATOM    278  C   ASP    33      40.047  31.316   1.497  1.00 17.34           C  
ATOM    279  O   ASP    33      41.003  31.846   2.054  1.00 18.03           O  
ATOM    280  CB  ASP    33      39.747  29.960   3.601  1.00 18.89           C  
ATOM    281  CG  ASP    33      39.039  30.875   4.486  1.00 18.74           C  
ATOM    282  OD1 ASP    33      38.258  31.695   3.971  1.00 16.19           O  
ATOM    283  OD2 ASP    33      39.269  30.786   5.698  1.00 18.51           O  
ATOM    284  N   GLU    34      39.564  31.721   0.315  1.00 16.16           N  
ATOM    285  CA  GLU    34      40.199  32.771  -0.530  1.00 13.68           C  
ATOM    286  C   GLU    34      39.829  34.184  -0.062  1.00 13.01           C  
ATOM    287  O   GLU    34      38.658  34.481   0.182  1.00 12.76           O  
ATOM    288  CB  GLU    34      39.758  32.569  -1.988  1.00 13.32           C  
ATOM    289  CG  GLU    34      40.392  33.542  -2.987  1.00 14.27           C  
ATOM    290  CD  GLU    34      41.895  33.337  -3.121  1.00 17.56           C  
ATOM    291  OE1 GLU    34      42.406  32.292  -2.657  1.00 16.95           O  
ATOM    292  OE2 GLU    34      42.561  34.222  -3.687  1.00 14.35           O  
ATOM    293  N   PRO    35      40.816  35.087   0.038  1.00 12.61           N  
ATOM    294  CA  PRO    35      40.519  36.460   0.441  1.00 12.40           C  
ATOM    295  C   PRO    35      39.941  37.281  -0.696  1.00 12.19           C  
ATOM    296  O   PRO    35      39.870  36.798  -1.836  1.00 12.16           O  
ATOM    297  CB  PRO    35      41.903  37.012   0.800  1.00 13.18           C  
ATOM    298  CG  PRO    35      42.830  36.282  -0.091  1.00 11.73           C  
ATOM    299  CD  PRO    35      42.257  34.876  -0.197  1.00 12.29           C  
ATOM    300  N   LEU    36      39.553  38.525  -0.381  1.00 13.27           N  
ATOM    301  CA  LEU    36      39.129  39.442  -1.419  1.00 13.91           C  
ATOM    302  C   LEU    36      40.288  39.748  -2.367  1.00 14.60           C  
ATOM    303  O   LEU    36      41.477  39.720  -1.959  1.00 15.26           O  
ATOM    304  CB  LEU    36      38.660  40.730  -0.791  1.00 13.30           C  
ATOM    305  CG  LEU    36      37.476  40.669   0.167  1.00 11.16           C  
ATOM    306  CD1 LEU    36      37.120  42.084   0.644  1.00 12.32           C  
ATOM    307  CD2 LEU    36      36.294  40.061  -0.606  1.00 14.18           C  
ATOM    308  N   SER    37      39.942  40.002  -3.627  1.00 14.66           N  
ATOM    309  CA  SER    37      40.887  40.588  -4.581  1.00 15.07           C  
ATOM    310  C   SER    37      40.955  42.115  -4.361  1.00 16.18           C  
ATOM    311  O   SER    37      40.191  42.650  -3.561  1.00 15.86           O  
ATOM    312  CB  SER    37      40.387  40.310  -5.990  1.00 15.28           C  
ATOM    313  OG  SER    37      39.163  40.991  -6.245  1.00 15.00           O  
ATOM    314  N   GLU    38      41.843  42.819  -5.053  0.50 16.90           N  
ATOM    316  CA  GLU    38      41.822  44.275  -4.919  0.50 17.68           C  
ATOM    318  C   GLU    38      40.468  44.909  -5.349  0.50 17.34           C  
ATOM    320  O   GLU    38      39.992  45.839  -4.683  0.50 16.87           O  
ATOM    322  CB  GLU    38      43.062  44.905  -5.555  0.50 18.44           C  
ATOM    324  CG  GLU    38      44.363  44.465  -4.861  0.50 20.32           C  
ATOM    326  CD  GLU    38      44.498  45.003  -3.442  0.50 23.44           C  
ATOM    328  OE1 GLU    38      44.550  46.248  -3.280  0.50 23.55           O  
ATOM    330  OE2 GLU    38      44.564  44.191  -2.493  0.50 20.46           O  
ATOM    332  N   THR    39      39.818  44.357  -6.381  1.00 17.89           N  
ATOM    333  CA  THR    39      38.442  44.762  -6.739  1.00 18.70           C  
ATOM    334  C   THR    39      37.477  44.495  -5.573  1.00 17.31           C  
ATOM    335  O   THR    39      36.641  45.350  -5.250  1.00 16.75           O  
ATOM    336  CB  THR    39      37.965  44.078  -8.026  1.00 19.07           C  
ATOM    337  OG1 THR    39      38.780  44.507  -9.123  1.00 23.74           O  
ATOM    338  CG2 THR    39      36.491  44.402  -8.353  1.00 21.10           C  
ATOM    339  N   GLY    40      37.635  43.343  -4.911  1.00 16.64           N  
ATOM    340  CA  GLY    40      36.796  43.013  -3.755  1.00 15.47           C  
ATOM    341  C   GLY    40      36.961  43.990  -2.593  1.00 15.29           C  
ATOM    342  O   GLY    40      35.992  44.422  -1.961  1.00 14.78           O  
ATOM    343  N   PHE    41      38.204  44.362  -2.311  1.00 14.84           N  
ATOM    344  CA  PHE    41      38.482  45.341  -1.283  1.00 16.00           C  
ATOM    345  C   PHE    41      37.857  46.706  -1.643  1.00 15.44           C  
ATOM    346  O   PHE    41      37.278  47.347  -0.781  1.00 16.26           O  
ATOM    347  CB  PHE    41      39.994  45.489  -1.080  1.00 16.48           C  
ATOM    348  CG  PHE    41      40.600  44.395  -0.260  1.00 16.72           C  
ATOM    349  CD1 PHE    41      40.213  44.206   1.066  1.00 16.36           C  
ATOM    350  CD2 PHE    41      41.607  43.599  -0.798  1.00 18.31           C  
ATOM    351  CE1 PHE    41      40.788  43.184   1.839  1.00 17.37           C  
ATOM    352  CE2 PHE    41      42.194  42.576  -0.035  1.00 17.66           C  
ATOM    353  CZ  PHE    41      41.779  42.378   1.287  1.00 17.32           C  
ATOM    354  N   LYS    42      37.973  47.118  -2.900  1.00 15.99           N  
ATOM    355  CA  LYS    42      37.278  48.329  -3.408  1.00 17.34           C  
ATOM    356  C   LYS    42      35.755  48.273  -3.244  1.00 17.57           C  
ATOM    357  O   LYS    42      35.146  49.256  -2.833  1.00 16.74           O  
ATOM    358  CB  LYS    42      37.634  48.638  -4.865  1.00 18.01           C  
ATOM    359  CG  LYS    42      39.093  49.050  -5.043  1.00 21.90           C  
ATOM    360  CD  LYS    42      39.416  49.194  -6.520  1.00 25.92           C  
ATOM    361  CE  LYS    42      40.607  50.124  -6.698  1.00 31.54           C  
ATOM    362  NZ  LYS    42      40.793  50.449  -8.144  1.00 35.78           N  
ATOM    363  N   GLN    43      35.141  47.130  -3.560  1.00 17.23           N  
ATOM    364  CA  GLN    43      33.689  46.988  -3.408  1.00 16.65           C  
ATOM    365  C   GLN    43      33.281  47.098  -1.934  1.00 16.50           C  
ATOM    366  O   GLN    43      32.313  47.778  -1.603  1.00 15.99           O  
ATOM    367  CB  GLN    43      33.204  45.648  -3.998  1.00 17.02           C  
ATOM    368  CG  GLN    43      33.434  45.511  -5.503  1.00 14.54           C  
ATOM    369  CD  GLN    43      33.179  44.106  -6.005  1.00 17.25           C  
ATOM    370  OE1 GLN    43      33.287  43.143  -5.240  1.00 15.36           O  
ATOM    371  NE2 GLN    43      32.798  43.981  -7.286  1.00 17.54           N  
ATOM    372  N   ALA    44      34.049  46.460  -1.053  1.00 17.00           N  
ATOM    373  CA  ALA    44      33.780  46.481   0.362  1.00 18.25           C  
ATOM    374  C   ALA    44      33.894  47.920   0.893  1.00 18.29           C  
ATOM    375  O   ALA    44      33.071  48.365   1.710  1.00 19.67           O  
ATOM    376  CB  ALA    44      34.726  45.538   1.082  1.00 18.12           C  
ATOM    377  N   ALA    45      34.879  48.659   0.370  1.00 18.75           N  
ATOM    378  CA  ALA    45      35.095  50.055   0.802  1.00 18.36           C  
ATOM    379  C   ALA    45      33.906  50.917   0.356  1.00 17.22           C  
ATOM    380  O   ALA    45      33.358  51.719   1.139  1.00 18.63           O  
ATOM    381  CB  ALA    45      36.430  50.601   0.207  1.00 18.25           C  
ATOM    382  N   ALA    46      33.485  50.718  -0.884  1.00 17.27           N  
ATOM    383  CA  ALA    46      32.370  51.440  -1.471  1.00 17.55           C  
ATOM    384  C   ALA    46      31.100  51.155  -0.685  1.00 18.90           C  
ATOM    385  O   ALA    46      30.296  52.059  -0.395  1.00 17.88           O  
ATOM    386  CB  ALA    46      32.196  51.040  -2.903  1.00 18.02           C  
ATOM    387  N   ALA    47      30.886  49.882  -0.369  1.00 17.73           N  
ATOM    388  CA  ALA    47      29.743  49.513   0.469  1.00 18.26           C  
ATOM    389  C   ALA    47      29.810  50.180   1.851  1.00 18.11           C  
ATOM    390  O   ALA    47      28.780  50.598   2.404  1.00 19.38           O  
ATOM    391  CB  ALA    47      29.686  47.977   0.621  1.00 18.48           C  
ATOM    392  N   GLY    48      31.011  50.248   2.408  1.00 18.17           N  
ATOM    393  CA  GLY    48      31.250  50.880   3.714  1.00 19.13           C  
ATOM    394  C   GLY    48      30.921  52.359   3.648  1.00 19.49           C  
ATOM    395  O   GLY    48      30.279  52.887   4.548  1.00 20.37           O  
ATOM    396  N   ILE    49      31.301  53.017   2.557  1.00 21.18           N  
ATOM    397  CA  ILE    49      30.955  54.451   2.406  1.00 21.55           C  
ATOM    398  C   ILE    49      29.445  54.633   2.232  1.00 21.40           C  
ATOM    399  O   ILE    49      28.849  55.497   2.891  1.00 20.53           O  
ATOM    400  CB  ILE    49      31.725  55.134   1.271  1.00 21.92           C  
ATOM    401  CG1 ILE    49      33.240  55.058   1.563  1.00 22.53           C  
ATOM    402  CG2 ILE    49      31.190  56.604   1.066  1.00 23.77           C  
ATOM    403  CD1 ILE    49      34.126  55.098   0.360  1.00 25.96           C  
ATOM    404  N   PHE    50      28.825  53.794   1.396  1.00 20.95           N  
ATOM    405  CA  PHE    50      27.381  53.811   1.189  1.00 20.87           C  
ATOM    406  C   PHE    50      26.614  53.701   2.519  1.00 20.75           C  
ATOM    407  O   PHE    50      25.611  54.421   2.729  1.00 20.09           O  
ATOM    408  CB  PHE    50      26.959  52.675   0.236  1.00 21.75           C  
ATOM    409  CG  PHE    50      25.505  52.713  -0.165  1.00 21.42           C  
ATOM    410  CD1 PHE    50      25.034  53.666  -1.070  1.00 23.70           C  
ATOM    411  CD2 PHE    50      24.615  51.769   0.344  1.00 22.52           C  
ATOM    412  CE1 PHE    50      23.685  53.701  -1.454  1.00 25.31           C  
ATOM    413  CE2 PHE    50      23.278  51.778  -0.020  1.00 20.38           C  
ATOM    414  CZ  PHE    50      22.794  52.747  -0.929  1.00 23.41           C  
ATOM    415  N   LEU    51      27.106  52.823   3.398  1.00 20.65           N  
ATOM    416  CA  LEU    51      26.477  52.528   4.707  1.00 20.31           C  
ATOM    417  C   LEU    51      26.994  53.347   5.909  1.00 20.94           C  
ATOM    418  O   LEU    51      26.689  53.035   7.074  1.00 20.47           O  
ATOM    419  CB  LEU    51      26.620  51.024   5.012  1.00 20.45           C  
ATOM    420  CG  LEU    51      26.018  50.029   4.002  1.00 18.73           C  
ATOM    421  CD1 LEU    51      26.516  48.571   4.293  1.00 17.74           C  
ATOM    422  CD2 LEU    51      24.503  50.071   4.006  1.00 18.95           C  
ATOM    423  N   ASN    52      27.776  54.391   5.646  1.00 22.08           N  
ATOM    424  CA  ASN    52      28.569  54.990   6.714  1.00 24.34           C  
ATOM    425  C   ASN    52      27.711  55.621   7.834  1.00 24.30           C  
ATOM    426  O   ASN    52      28.155  55.738   8.984  1.00 24.66           O  
ATOM    427  CB  ASN    52      29.517  56.037   6.111  1.00 25.39           C  
ATOM    428  CG  ASN    52      28.787  57.295   5.740  1.00 28.11           C  
ATOM    429  OD1 ASN    52      28.587  58.166   6.588  1.00 33.96           O  
ATOM    430  ND2 ASN    52      28.315  57.376   4.501  1.00 29.08           N  
ATOM    431  N   ASN    53      26.498  56.042   7.487  1.00 25.05           N  
ATOM    432  CA  ASN    53      25.632  56.715   8.469  1.00 25.92           C  
ATOM    433  C   ASN    53      24.488  55.833   8.952  1.00 25.06           C  
ATOM    434  O   ASN    53      23.578  56.317   9.638  1.00 25.23           O  
ATOM    435  CB  ASN    53      25.075  58.026   7.904  1.00 27.15           C  
ATOM    436  CG  ASN    53      24.652  58.988   9.000  1.00 30.53           C  
ATOM    437  OD1 ASN    53      25.455  59.349   9.865  1.00 36.72           O  
ATOM    438  ND2 ASN    53      23.382  59.389   8.986  1.00 34.91           N  
ATOM    439  N   VAL    54      24.521  54.547   8.585  1.00 23.11           N  
ATOM    440  CA  VAL    54      23.505  53.626   9.060  1.00 21.47           C  
ATOM    441  C   VAL    54      23.824  53.191  10.471  1.00 21.39           C  
ATOM    442  O   VAL    54      24.938  52.731  10.780  1.00 22.40           O  
ATOM    443  CB  VAL    54      23.363  52.343   8.167  1.00 20.54           C  
ATOM    444  CG1 VAL    54      22.303  51.405   8.775  1.00 20.21           C  
ATOM    445  CG2 VAL    54      22.991  52.714   6.759  1.00 20.99           C  
ATOM    446  N   LYS    55      22.832  53.303  11.339  1.00 21.50           N  
ATOM    447  CA  LYS    55      23.011  52.869  12.707  1.00 22.40           C  
ATOM    448  C   LYS    55      22.615  51.395  12.855  1.00 21.79           C  
ATOM    449  O   LYS    55      21.475  51.073  13.260  1.00 22.74           O  
ATOM    450  CB  LYS    55      22.190  53.741  13.659  1.00 23.17           C  
ATOM    451  CG  LYS    55      22.523  55.236  13.533  1.00 26.63           C  
ATOM    452  CD  LYS    55      22.200  55.945  14.829  1.00 32.13           C  
ATOM    453  CE  LYS    55      22.697  57.386  14.808  1.00 34.40           C  
ATOM    454  NZ  LYS    55      22.953  57.903  16.192  1.00 36.92           N  
ATOM    455  N   PHE    56      23.546  50.503  12.539  1.00 20.73           N  
ATOM    456  CA  PHE    56      23.337  49.078  12.823  1.00 19.15           C  
ATOM    457  C   PHE    56      23.510  48.812  14.304  1.00 19.61           C  
ATOM    458  O   PHE    56      24.285  49.504  15.000  1.00 21.15           O  
ATOM    459  CB  PHE    56      24.321  48.167  12.053  1.00 18.58           C  
ATOM    460  CG  PHE    56      24.172  48.230  10.567  1.00 17.80           C  
ATOM    461  CD1 PHE    56      23.018  47.719   9.935  1.00 14.64           C  
ATOM    462  CD2 PHE    56      25.183  48.753   9.779  1.00 16.61           C  
ATOM    463  CE1 PHE    56      22.881  47.789   8.533  1.00 14.77           C  
ATOM    464  CE2 PHE    56      25.061  48.793   8.381  1.00 16.45           C  
ATOM    465  CZ  PHE    56      23.904  48.324   7.749  1.00 14.90           C  
ATOM    466  N   THR    57      22.861  47.749  14.765  1.00 17.09           N  
ATOM    467  CA  THR    57      22.898  47.326  16.146  1.00 16.54           C  
ATOM    468  C   THR    57      23.611  45.992  16.347  1.00 16.67           C  
ATOM    469  O   THR    57      24.075  45.688  17.445  1.00 17.10           O  
ATOM    470  CB  THR    57      21.474  47.200  16.744  1.00 17.55           C  
ATOM    471  OG1 THR    57      20.692  46.278  15.957  1.00 14.51           O  
ATOM    472  CG2 THR    57      20.772  48.546  16.751  1.00 15.49           C  
ATOM    473  N   HIS    58      23.659  45.185  15.272  1.00 15.40           N  
ATOM    474  CA  HIS    58      24.258  43.857  15.350  1.00 14.88           C  
ATOM    475  C   HIS    58      24.974  43.589  14.027  1.00 14.04           C  
ATOM    476  O   HIS    58      24.557  44.082  12.977  1.00 13.96           O  
ATOM    477  CB  HIS    58      23.178  42.780  15.466  1.00 13.38           C  
ATOM    478  CG  HIS    58      22.385  42.839  16.735  1.00 14.77           C  
ATOM    479  ND1 HIS    58      21.409  43.785  16.961  1.00 15.83           N  
ATOM    480  CD2 HIS    58      22.419  42.059  17.838  1.00 15.46           C  
ATOM    481  CE1 HIS    58      20.892  43.595  18.164  1.00 17.07           C  
ATOM    482  NE2 HIS    58      21.460  42.535  18.700  1.00 15.53           N  
ATOM    483  N   ALA    59      26.044  42.806  14.100  1.00 13.04           N  
ATOM    484  CA  ALA    59      26.787  42.411  12.878  1.00 13.95           C  
ATOM    485  C   ALA    59      27.139  40.942  12.968  1.00 14.25           C  
ATOM    486  O   ALA    59      27.758  40.502  13.951  1.00 14.77           O  
ATOM    487  CB  ALA    59      28.058  43.213  12.703  1.00 14.18           C  
ATOM    488  N   PHE    60      26.778  40.185  11.930  1.00 12.96           N  
ATOM    489  CA  PHE    60      27.139  38.760  11.816  1.00 12.74           C  
ATOM    490  C   PHE    60      27.780  38.498  10.478  1.00 12.41           C  
ATOM    491  O   PHE    60      27.340  39.056   9.465  1.00 13.16           O  
ATOM    492  CB  PHE    60      25.911  37.831  11.919  1.00 13.31           C  
ATOM    493  CG  PHE    60      25.207  37.891  13.256  1.00 13.17           C  
ATOM    494  CD1 PHE    60      25.482  36.946  14.244  1.00 15.99           C  
ATOM    495  CD2 PHE    60      24.249  38.868  13.490  1.00 16.08           C  
ATOM    496  CE1 PHE    60      24.827  36.980  15.485  1.00 17.65           C  
ATOM    497  CE2 PHE    60      23.575  38.909  14.728  1.00 17.11           C  
ATOM    498  CZ  PHE    60      23.877  37.976  15.714  1.00 15.95           C  
ATOM    499  N   SER    61      28.775  37.602  10.451  1.00 11.13           N  
ATOM    500  CA  SER    61      29.467  37.297   9.202  1.00 12.21           C  
ATOM    501  C   SER    61      29.727  35.794   9.216  1.00 11.56           C  
ATOM    502  O   SER    61      29.983  35.205  10.263  1.00 12.53           O  
ATOM    503  CB  SER    61      30.800  38.071   9.126  1.00 11.54           C  
ATOM    504  OG  SER    61      31.557  37.684   7.995  1.00 14.79           O  
ATOM    505  N   SER    62      29.687  35.174   8.047  1.00 10.94           N  
ATOM    506  CA  SER    62      30.357  33.901   7.851  1.00 11.59           C  
ATOM    507  C   SER    62      31.798  33.973   8.360  1.00 11.84           C  
ATOM    508  O   SER    62      32.420  35.019   8.272  1.00 11.46           O  
ATOM    509  CB  SER    62      30.392  33.669   6.338  1.00 12.08           C  
ATOM    510  OG  SER    62      31.297  32.701   6.015  1.00 16.57           O  
ATOM    511  N   ASP    63      32.276  32.831   8.853  0.50 12.21           N  
ATOM    513  CA  ASP    63      33.641  32.659   9.378  0.50 13.48           C  
ATOM    515  C   ASP    63      34.594  32.183   8.266  0.50 13.52           C  
ATOM    517  O   ASP    63      35.392  31.242   8.442  0.50 13.40           O  
ATOM    519  CB  ASP    63      33.669  31.742  10.624  0.50 13.93           C  
ATOM    521  CG  ASP    63      33.182  30.313  10.355  0.50 14.36           C  
ATOM    523  OD1 ASP    63      32.267  30.105   9.530  0.50 10.93           O  
ATOM    525  OD2 ASP    63      33.724  29.377  10.988  0.50 15.00           O  
ATOM    527  N   LEU    64      34.455  32.830   7.104  1.00 14.85           N  
ATOM    528  CA  LEU    64      35.372  32.683   5.974  1.00 14.13           C  
ATOM    529  C   LEU    64      36.040  34.045   5.711  1.00 13.74           C  
ATOM    530  O   LEU    64      35.487  35.081   6.092  1.00 12.53           O  
ATOM    531  CB  LEU    64      34.610  32.144   4.735  1.00 14.06           C  
ATOM    532  CG  LEU    64      34.112  30.684   4.857  1.00 15.57           C  
ATOM    533  CD1 LEU    64      33.222  30.172   3.726  1.00 16.81           C  
ATOM    534  CD2 LEU    64      35.373  29.730   5.011  1.00 16.50           C  
ATOM    535  N   MET    65      37.244  34.054   5.120  1.00 13.80           N  
ATOM    536  CA  MET    65      37.997  35.312   4.978  1.00 14.27           C  
ATOM    537  C   MET    65      37.259  36.328   4.141  1.00 12.80           C  
ATOM    538  O   MET    65      37.249  37.513   4.483  1.00 12.68           O  
ATOM    539  CB  MET    65      39.344  35.088   4.268  1.00 14.39           C  
ATOM    540  CG  MET    65      40.368  34.551   5.151  1.00 19.40           C  
ATOM    541  SD  MET    65      42.061  34.816   4.234  1.00 17.57          SE  
ATOM    542  CE  MET    65      42.703  36.459   4.953  1.00 18.75           C  
ATOM    543  N   ARG    66      36.664  35.878   3.035  1.00 11.81           N  
ATOM    544  CA  ARG    66      36.066  36.820   2.071  1.00 11.30           C  
ATOM    545  C   ARG    66      34.928  37.632   2.693  1.00 12.24           C  
ATOM    546  O   ARG    66      34.802  38.856   2.479  1.00 11.93           O  
ATOM    547  CB  ARG    66      35.654  36.107   0.777  1.00 10.46           C  
ATOM    548  CG  ARG    66      34.682  34.894   0.959  1.00 10.29           C  
ATOM    549  CD  ARG    66      34.627  34.203  -0.373  1.00 12.79           C  
ATOM    550  NE  ARG    66      33.700  33.054  -0.470  1.00 11.27           N  
ATOM    551  CZ  ARG    66      33.988  31.816  -0.053  1.00 14.16           C  
ATOM    552  NH1 ARG    66      33.126  30.849  -0.290  1.00 12.57           N  
ATOM    553  NH2 ARG    66      35.111  31.536   0.612  1.00 11.25           N  
ATOM    554  N   THR    67      34.149  36.966   3.543  1.00 11.56           N  
ATOM    555  CA  THR    67      33.050  37.640   4.242  1.00 12.08           C  
ATOM    556  C   THR    67      33.622  38.488   5.417  1.00 11.63           C  
ATOM    557  O   THR    67      33.223  39.648   5.611  1.00 12.77           O  
ATOM    558  CB  THR    67      32.050  36.601   4.741  1.00 10.04           C  
ATOM    559  OG1 THR    67      32.796  35.490   5.240  1.00 12.29           O  
ATOM    560  CG2 THR    67      31.131  36.086   3.571  1.00 11.13           C  
ATOM    561  N   LYS    68      34.592  37.937   6.151  1.00 13.01           N  
ATOM    562  CA  LYS    68      35.199  38.673   7.299  1.00 13.10           C  
ATOM    563  C   LYS    68      35.821  40.001   6.795  1.00 11.78           C  
ATOM    564  O   LYS    68      35.613  41.042   7.377  1.00 11.93           O  
ATOM    565  CB  LYS    68      36.239  37.809   8.024  1.00 13.79           C  
ATOM    566  CG  LYS    68      37.010  38.545   9.119  1.00 16.70           C  
ATOM    567  CD  LYS    68      37.820  37.554   9.999  1.00 17.70           C  
ATOM    568  CE  LYS    68      38.271  38.243  11.310  1.00 22.84           C  
ATOM    569  NZ  LYS    68      38.987  37.265  12.187  1.00 25.71           N  
ATOM    570  N   GLN    69      36.578  39.925   5.702  1.00 11.45           N  
ATOM    571  CA  GLN    69      37.230  41.109   5.149  1.00 12.01           C  
ATOM    572  C   GLN    69      36.212  42.128   4.655  1.00 12.80           C  
ATOM    573  O   GLN    69      36.421  43.360   4.776  1.00 12.36           O  
ATOM    574  CB  GLN    69      38.143  40.690   4.024  1.00 11.90           C  
ATOM    575  CG  GLN    69      39.389  39.947   4.540  1.00 11.34           C  
ATOM    576  CD  GLN    69      40.288  39.535   3.414  1.00 14.07           C  
ATOM    577  OE1 GLN    69      39.807  39.100   2.363  1.00 12.32           O  
ATOM    578  NE2 GLN    69      41.613  39.608   3.639  1.00 15.02           N  
ATOM    579  N   THR    70      35.107  41.621   4.080  1.00 12.32           N  
ATOM    580  CA  THR    70      34.067  42.536   3.591  1.00 12.94           C  
ATOM    581  C   THR    70      33.409  43.288   4.778  1.00 12.24           C  
ATOM    582  O   THR    70      33.180  44.519   4.705  1.00 12.26           O  
ATOM    583  CB  THR    70      33.005  41.781   2.757  1.00 12.52           C  
ATOM    584  OG1 THR    70      33.657  41.176   1.623  1.00 12.51           O  
ATOM    585  CG2 THR    70      31.874  42.738   2.253  1.00 11.26           C  
ATOM    586  N   MET    71      33.076  42.532   5.819  1.00 12.95           N  
ATOM    587  CA  MET    71      32.513  43.084   7.054  1.00 14.04           C  
ATOM    588  C   MET    71      33.506  44.129   7.601  1.00 15.16           C  
ATOM    589  O   MET    71      33.100  45.209   8.015  1.00 14.69           O  
ATOM    590  CB  MET    71      32.311  42.000   8.084  1.00 14.72           C  
ATOM    591  CG  MET    71      31.741  42.503   9.416  1.00 16.03           C  
ATOM    592  SD  MET    71      30.009  43.366   9.266  1.00 12.53          SE  
ATOM    593  CE  MET    71      28.976  41.707   9.223  1.00 13.52           C  
ATOM    594  N   HIS    72      34.798  43.805   7.570  1.00 15.73           N  
ATOM    595  CA  HIS    72      35.798  44.765   8.079  1.00 17.92           C  
ATOM    596  C   HIS    72      35.799  46.068   7.279  1.00 18.23           C  
ATOM    597  O   HIS    72      35.806  47.170   7.877  1.00 18.65           O  
ATOM    598  CB  HIS    72      37.197  44.172   8.104  1.00 18.26           C  
ATOM    599  CG  HIS    72      38.231  45.134   8.616  1.00 22.21           C  
ATOM    600  ND1 HIS    72      38.329  45.480   9.946  1.00 26.17           N  
ATOM    601  CD2 HIS    72      39.186  45.851   7.968  1.00 26.64           C  
ATOM    602  CE1 HIS    72      39.323  46.337  10.106  1.00 25.60           C  
ATOM    603  NE2 HIS    72      39.856  46.583   8.920  1.00 28.23           N  
ATOM    604  N   GLY    73      35.786  45.922   5.950  1.00 17.64           N  
ATOM    605  CA  GLY    73      35.749  47.021   4.982  1.00 18.22           C  
ATOM    606  C   GLY    73      34.553  47.914   5.241  1.00 18.59           C  
ATOM    607  O   GLY    73      34.632  49.135   5.137  1.00 17.35           O  
ATOM    608  N   ILE    74      33.422  47.293   5.569  1.00 17.82           N  
ATOM    609  CA  ILE    74      32.208  48.049   5.833  1.00 18.14           C  
ATOM    610  C   ILE    74      32.322  48.766   7.168  1.00 19.12           C  
ATOM    611  O   ILE    74      32.124  49.976   7.216  1.00 20.75           O  
ATOM    612  CB  ILE    74      30.929  47.127   5.787  1.00 17.24           C  
ATOM    613  CG1 ILE    74      30.633  46.719   4.347  1.00 18.41           C  
ATOM    614  CG2 ILE    74      29.716  47.847   6.393  1.00 17.25           C  
ATOM    615  CD1 ILE    74      29.677  45.514   4.249  1.00 17.62           C  
ATOM    616  N   LEU    75      32.660  48.047   8.242  1.00 20.26           N  
ATOM    617  CA  LEU    75      32.654  48.660   9.584  1.00 20.39           C  
ATOM    618  C   LEU    75      33.748  49.711   9.784  1.00 21.93           C  
ATOM    619  O   LEU    75      33.506  50.723  10.442  1.00 21.81           O  
ATOM    620  CB  LEU    75      32.682  47.618  10.687  1.00 20.74           C  
ATOM    621  CG  LEU    75      31.457  46.705  10.768  1.00 18.86           C  
ATOM    622  CD1 LEU    75      31.706  45.688  11.869  1.00 20.32           C  
ATOM    623  CD2 LEU    75      30.175  47.516  10.991  1.00 20.37           C  
ATOM    624  N   GLU    76      34.907  49.519   9.165  1.00 22.34           N  
ATOM    625  CA  GLU    76      35.997  50.479   9.357  1.00 25.10           C  
ATOM    626  C   GLU    76      35.621  51.889   8.865  1.00 25.23           C  
ATOM    627  O   GLU    76      36.219  52.863   9.314  1.00 26.75           O  
ATOM    628  CB  GLU    76      37.318  49.973   8.753  1.00 24.36           C  
ATOM    629  CG  GLU    76      37.476  50.167   7.255  1.00 25.72           C  
ATOM    630  CD  GLU    76      38.694  49.424   6.693  1.00 27.22           C  
ATOM    631  OE1 GLU    76      39.583  49.024   7.479  1.00 30.93           O  
ATOM    632  OE2 GLU    76      38.774  49.240   5.461  1.00 32.26           O  
ATOM    633  N   ARG    77      34.624  51.982   7.977  1.00 25.58           N  
ATOM    634  CA  ARG    77      34.132  53.257   7.427  1.00 26.51           C  
ATOM    635  C   ARG    77      32.831  53.782   8.025  1.00 26.65           C  
ATOM    636  O   ARG    77      32.262  54.749   7.501  1.00 26.66           O  
ATOM    637  CB  ARG    77      33.949  53.141   5.920  1.00 26.38           C  
ATOM    638  CG  ARG    77      35.290  53.011   5.227  1.00 27.67           C  
ATOM    639  CD  ARG    77      35.178  52.485   3.846  1.00 30.97           C  
ATOM    640  NE  ARG    77      36.510  52.433   3.255  1.00 30.98           N  
ATOM    641  CZ  ARG    77      37.312  51.372   3.292  1.00 35.20           C  
ATOM    642  NH1 ARG    77      38.520  51.454   2.715  1.00 36.34           N  
ATOM    643  NH2 ARG    77      36.910  50.228   3.875  1.00 28.89           N  
ATOM    644  N   SER    78      32.357  53.130   9.079  1.00 26.15           N  
ATOM    645  CA  SER    78      31.086  53.486   9.669  1.00 27.03           C  
ATOM    646  C   SER    78      31.300  54.636  10.634  1.00 27.68           C  
ATOM    647  O   SER    78      32.276  54.646  11.391  1.00 27.16           O  
ATOM    648  CB  SER    78      30.468  52.308  10.416  1.00 26.71           C  
ATOM    649  OG  SER    78      29.259  52.707  11.068  1.00 26.27           O  
ATOM    650  N   LYS    79      30.379  55.591  10.600  1.00 29.19           N  
ATOM    651  CA  LYS    79      30.364  56.674  11.605  1.00 30.36           C  
ATOM    652  C   LYS    79      30.015  56.189  13.025  1.00 30.63           C  
ATOM    653  O   LYS    79      30.639  56.613  14.014  1.00 30.77           O  
ATOM    654  CB  LYS    79      29.411  57.772  11.163  1.00 30.35           C  
ATOM    655  CG  LYS    79      29.804  58.387   9.823  1.00 34.19           C  
ATOM    656  CD  LYS    79      28.840  59.478   9.389  1.00 38.11           C  
ATOM    657  CE  LYS    79      29.545  60.497   8.510  1.00 41.68           C  
ATOM    658  NZ  LYS    79      30.320  59.884   7.374  1.00 44.79           N  
ATOM    659  N   PHE    80      29.039  55.283  13.132  1.00 30.30           N  
ATOM    660  CA  PHE    80      28.579  54.815  14.441  1.00 29.95           C  
ATOM    661  C   PHE    80      29.020  53.438  14.871  1.00 29.66           C  
ATOM    662  O   PHE    80      29.052  53.163  16.069  1.00 29.18           O  
ATOM    663  CB  PHE    80      27.053  54.898  14.522  1.00 31.44           C  
ATOM    664  CG  PHE    80      26.530  56.235  14.154  1.00 34.11           C  
ATOM    665  CD1 PHE    80      26.564  57.278  15.077  1.00 37.99           C  
ATOM    666  CD2 PHE    80      26.056  56.478  12.874  1.00 35.72           C  
ATOM    667  CE1 PHE    80      26.106  58.537  14.729  1.00 38.23           C  
ATOM    668  CE2 PHE    80      25.597  57.722  12.519  1.00 39.19           C  
ATOM    669  CZ  PHE    80      25.623  58.758  13.446  1.00 38.01           C  
ATOM    670  N   CYS    81      29.366  52.575  13.910  1.00 28.01           N  
ATOM    671  CA  CYS    81      29.606  51.158  14.197  1.00 27.84           C  
ATOM    672  C   CYS    81      31.044  50.686  13.981  1.00 27.70           C  
ATOM    673  O   CYS    81      31.309  49.485  14.007  1.00 26.84           O  
ATOM    674  CB  CYS    81      28.645  50.276  13.398  1.00 27.28           C  
ATOM    675  SG  CYS    81      26.920  50.779  13.612  1.00 28.89           S  
ATOM    676  N   LYS    82      31.985  51.617  13.832  1.00 27.45           N  
ATOM    677  CA  LYS    82      33.403  51.222  13.766  1.00 28.50           C  
ATOM    678  C   LYS    82      33.834  50.144  14.796  1.00 27.82           C  
ATOM    679  O   LYS    82      34.547  49.182  14.454  1.00 28.25           O  
ATOM    680  CB  LYS    82      34.281  52.465  13.927  1.00 28.86           C  
ATOM    681  CG  LYS    82      35.101  52.816  12.713  1.00 32.47           C  
ATOM    682  CD  LYS    82      36.212  53.785  13.150  1.00 36.51           C  
ATOM    683  CE  LYS    82      37.407  53.769  12.213  1.00 39.21           C  
ATOM    684  NZ  LYS    82      38.422  54.834  12.584  1.00 41.30           N  
ATOM    685  N   ASP    83      33.375  50.304  16.039  1.00 27.50           N  
ATOM    686  CA  ASP    83      33.775  49.512  17.197  1.00 28.02           C  
ATOM    687  C   ASP    83      32.878  48.306  17.488  1.00 27.52           C  
ATOM    688  O   ASP    83      33.135  47.570  18.441  1.00 26.64           O  
ATOM    689  CB  ASP    83      33.731  50.395  18.458  1.00 29.41           C  
ATOM    690  CG  ASP    83      35.074  50.979  18.833  1.00 33.35           C  
ATOM    691  OD1 ASP    83      36.018  50.982  18.002  1.00 37.87           O  
ATOM    692  OD2 ASP    83      35.171  51.465  19.991  1.00 39.80           O  
ATOM    693  N   MET    84      31.827  48.123  16.684  1.00 27.33           N  
ATOM    694  CA  MET    84      30.888  47.015  16.853  1.00 27.36           C  
ATOM    695  C   MET    84      31.554  45.635  16.835  1.00 26.64           C  
ATOM    696  O   MET    84      32.397  45.363  15.972  1.00 26.44           O  
ATOM    697  CB  MET    84      29.828  47.074  15.754  1.00 27.33           C  
ATOM    698  CG  MET    84      28.843  45.919  15.820  1.00 29.83           C  
ATOM    699  SD  MET    84      27.184  46.452  15.025  1.00 28.68          SE  
ATOM    700  CE  MET    84      26.622  47.647  16.472  1.00 31.10           C  
ATOM    701  N   THR    85      31.151  44.771  17.770  1.00 25.42           N  
ATOM    702  CA  THR    85      31.643  43.400  17.829  1.00 25.35           C  
ATOM    703  C   THR    85      30.957  42.626  16.710  1.00 23.90           C  
ATOM    704  O   THR    85      29.733  42.626  16.620  1.00 25.42           O  
ATOM    705  CB  THR    85      31.307  42.725  19.175  1.00 26.00           C  
ATOM    706  OG1 THR    85      31.981  43.414  20.236  1.00 30.50           O  
ATOM    707  CG2 THR    85      31.750  41.256  19.191  1.00 26.88           C  
ATOM    708  N   VAL    86      31.747  41.998  15.858  1.00 21.60           N  
ATOM    709  CA  VAL    86      31.200  41.111  14.828  1.00 20.01           C  
ATOM    710  C   VAL    86      31.084  39.709  15.396  1.00 19.18           C  
ATOM    711  O   VAL    86      32.048  39.192  15.994  1.00 18.56           O  
ATOM    712  CB  VAL    86      32.133  41.078  13.584  1.00 19.70           C  
ATOM    713  CG1 VAL    86      31.600  40.066  12.497  1.00 19.54           C  
ATOM    714  CG2 VAL    86      32.330  42.463  13.026  1.00 19.51           C  
ATOM    715  N   LYS    87      29.931  39.060  15.205  1.00 18.68           N  
ATOM    716  CA  LYS    87      29.822  37.655  15.569  1.00 18.36           C  
ATOM    717  C   LYS    87      30.030  36.774  14.329  1.00 18.76           C  
ATOM    718  O   LYS    87      29.404  37.017  13.300  1.00 17.89           O  
ATOM    719  CB  LYS    87      28.465  37.363  16.219  1.00 20.32           C  
ATOM    720  CG  LYS    87      28.207  38.121  17.539  1.00 23.26           C  
ATOM    721  CD  LYS    87      28.881  37.441  18.727  1.00 29.51           C  
ATOM    722  CE  LYS    87      28.862  38.306  20.018  1.00 29.46           C  
ATOM    723  NZ  LYS    87      27.499  38.859  20.350  1.00 34.69           N  
ATOM    724  N   TYR    88      30.908  35.778  14.414  1.00 17.24           N  
ATOM    725  CA  TYR    88      31.205  34.925  13.245  1.00 17.08           C  
ATOM    726  C   TYR    88      30.472  33.634  13.446  1.00 17.77           C  
ATOM    727  O   TYR    88      30.595  33.005  14.519  1.00 19.09           O  
ATOM    728  CB  TYR    88      32.723  34.681  13.083  1.00 16.63           C  
ATOM    729  CG  TYR    88      33.416  35.982  12.807  1.00 16.87           C  
ATOM    730  CD1 TYR    88      33.417  36.518  11.521  1.00 15.13           C  
ATOM    731  CD2 TYR    88      33.947  36.751  13.855  1.00 19.18           C  
ATOM    732  CE1 TYR    88      33.996  37.748  11.259  1.00 16.39           C  
ATOM    733  CE2 TYR    88      34.524  37.980  13.606  1.00 16.91           C  
ATOM    734  CZ  TYR    88      34.548  38.461  12.314  1.00 18.38           C  
ATOM    735  OH  TYR    88      35.119  39.660  12.080  1.00 18.80           O  
ATOM    736  N   ASP    89      29.706  33.225  12.429  1.00 15.32           N  
ATOM    737  CA  ASP    89      28.752  32.138  12.598  1.00 14.95           C  
ATOM    738  C   ASP    89      28.880  31.221  11.400  1.00 14.21           C  
ATOM    739  O   ASP    89      28.637  31.632  10.269  1.00 13.18           O  
ATOM    740  CB  ASP    89      27.320  32.705  12.754  1.00 13.62           C  
ATOM    741  CG  ASP    89      26.326  31.703  13.309  1.00 17.57           C  
ATOM    742  OD1 ASP    89      26.216  30.557  12.790  1.00 16.56           O  
ATOM    743  OD2 ASP    89      25.635  32.056  14.296  1.00 18.76           O  
ATOM    744  N   SER    90      29.255  29.979  11.660  1.00 13.24           N  
ATOM    745  CA  SER    90      29.434  28.988  10.594  1.00 13.21           C  
ATOM    746  C   SER    90      28.127  28.694   9.846  1.00 12.15           C  
ATOM    747  O   SER    90      28.166  28.199   8.726  1.00 12.17           O  
ATOM    748  CB  SER    90      30.017  27.664  11.149  1.00 14.65           C  
ATOM    749  OG  SER    90      29.081  27.013  11.999  1.00 16.86           O  
ATOM    750  N   ARG    91      26.978  28.922  10.475  1.00 11.21           N  
ATOM    751  CA  ARG    91      25.693  28.726   9.753  1.00 11.52           C  
ATOM    752  C   ARG    91      25.545  29.632   8.523  1.00 10.85           C  
ATOM    753  O   ARG    91      24.752  29.346   7.617  1.00 11.71           O  
ATOM    754  CB  ARG    91      24.487  28.872  10.673  1.00 10.94           C  
ATOM    755  CG  ARG    91      24.441  27.792  11.768  1.00 13.03           C  
ATOM    756  CD  ARG    91      23.351  28.149  12.747  1.00 15.77           C  
ATOM    757  NE  ARG    91      23.786  29.244  13.608  1.00 15.09           N  
ATOM    758  CZ  ARG    91      23.191  29.560  14.752  1.00 17.43           C  
ATOM    759  NH1 ARG    91      22.113  28.881  15.146  1.00 16.56           N  
ATOM    760  NH2 ARG    91      23.653  30.574  15.469  1.00 16.42           N  
ATOM    761  N   LEU    92      26.309  30.720   8.483  1.00 10.05           N  
ATOM    762  CA  LEU    92      26.264  31.669   7.370  1.00 10.24           C  
ATOM    763  C   LEU    92      27.184  31.304   6.192  1.00 10.17           C  
ATOM    764  O   LEU    92      27.289  32.071   5.230  1.00  9.19           O  
ATOM    765  CB  LEU    92      26.659  33.064   7.888  1.00 10.64           C  
ATOM    766  CG  LEU    92      25.647  33.620   8.896  1.00  7.81           C  
ATOM    767  CD1 LEU    92      26.151  34.998   9.449  1.00  9.51           C  
ATOM    768  CD2 LEU    92      24.265  33.840   8.216  1.00  9.67           C  
ATOM    769  N   ARG    93      27.896  30.172   6.322  1.00  9.79           N  
ATOM    770  CA  ARG    93      28.920  29.832   5.307  0.50 10.74           C  
ATOM    772  C   ARG    93      28.293  29.473   3.946  1.00 10.23           C  
ATOM    773  O   ARG    93      27.130  29.136   3.852  1.00  9.45           O  
ATOM    774  CB  ARG    93      29.871  28.723   5.810  0.50 10.99           C  
ATOM    776  CG  ARG    93      30.830  29.182   6.953  0.50 10.53           C  
ATOM    778  CD  ARG    93      31.618  28.043   7.722  0.50 13.00           C  
ATOM    780  NE  ARG    93      32.947  27.783   7.170  0.50 16.63           N  
ATOM    782  CZ  ARG    93      33.539  26.581   7.087  0.50 18.09           C  
ATOM    784  NH1 ARG    93      34.723  26.475   6.518  0.50 20.66           N  
ATOM    786  NH2 ARG    93      32.953  25.481   7.538  0.50 21.05           N  
ATOM    788  N   GLU    94      29.087  29.574   2.874  1.00  9.81           N  
ATOM    789  CA  GLU    94      28.566  29.225   1.559  1.00  9.24           C  
ATOM    790  C   GLU    94      28.222  27.720   1.486  1.00  8.74           C  
ATOM    791  O   GLU    94      28.737  26.905   2.264  1.00 10.34           O  
ATOM    792  CB  GLU    94      29.576  29.564   0.464  1.00 11.27           C  
ATOM    793  CG  GLU    94      29.088  29.349  -0.995  1.00 12.74           C  
ATOM    794  CD  GLU    94      27.785  30.006  -1.403  1.00 10.47           C  
ATOM    795  OE1 GLU    94      26.737  29.737  -0.779  1.00 14.15           O  
ATOM    796  OE2 GLU    94      27.760  30.741  -2.438  1.00 16.89           O  
ATOM    797  N   ARG    95      27.340  27.399   0.548  1.00  9.78           N  
ATOM    798  CA  ARG    95      27.030  25.998   0.196  1.00  9.41           C  
ATOM    799  C   ARG    95      28.352  25.240  -0.046  1.00 10.34           C  
ATOM    800  O   ARG    95      29.275  25.768  -0.680  1.00 10.97           O  
ATOM    801  CB  ARG    95      26.208  26.018  -1.105  1.00 10.13           C  
ATOM    802  CG  ARG    95      25.946  24.628  -1.684  1.00 11.28           C  
ATOM    803  CD  ARG    95      24.903  24.690  -2.839  1.00 10.27           C  
ATOM    804  NE  ARG    95      24.391  23.349  -3.179  1.00 11.61           N  
ATOM    805  CZ  ARG    95      23.752  23.052  -4.310  1.00 14.85           C  
ATOM    806  NH1 ARG    95      23.582  23.987  -5.240  1.00 13.49           N  
ATOM    807  NH2 ARG    95      23.327  21.791  -4.534  1.00 15.15           N  
ATOM    808  N   LYS    96      28.445  24.020   0.483  1.00 10.77           N  
ATOM    809  CA  LYS    96      29.595  23.136   0.192  1.00 11.17           C  
ATOM    810  C   LYS    96      29.486  22.581  -1.218  1.00 10.95           C  
ATOM    811  O   LYS    96      28.428  22.118  -1.598  1.00 10.65           O  
ATOM    812  CB  LYS    96      29.583  21.978   1.171  1.00 11.63           C  
ATOM    813  CG  LYS    96      30.032  22.318   2.529  1.00 13.62           C  
ATOM    814  CD  LYS    96      29.955  21.039   3.375  1.00 16.90           C  
ATOM    815  CE  LYS    96      30.787  21.227   4.642  1.00 21.22           C  
ATOM    816  NZ  LYS    96      30.972  19.848   5.295  1.00 27.76           N  
ATOM    817  N   TYR    97      30.603  22.551  -1.955  1.00 11.30           N  
ATOM    818  CA  TYR    97      30.624  21.926  -3.290  1.00 12.22           C  
ATOM    819  C   TYR    97      31.571  20.706  -3.360  1.00 11.94           C  
ATOM    820  O   TYR    97      31.841  20.166  -4.447  1.00 12.35           O  
ATOM    821  CB  TYR    97      31.000  22.967  -4.355  1.00 13.04           C  
ATOM    822  CG  TYR    97      29.936  24.034  -4.515  1.00 14.72           C  
ATOM    823  CD1 TYR    97      28.774  23.798  -5.274  1.00 14.38           C  
ATOM    824  CD2 TYR    97      30.088  25.270  -3.896  1.00 15.43           C  
ATOM    825  CE1 TYR    97      27.810  24.791  -5.393  1.00 14.73           C  
ATOM    826  CE2 TYR    97      29.122  26.262  -4.010  1.00 12.53           C  
ATOM    827  CZ  TYR    97      27.999  26.014  -4.720  1.00 14.34           C  
ATOM    828  OH  TYR    97      27.092  27.032  -4.827  1.00 16.25           O  
ATOM    829  N   GLY    98      32.089  20.291  -2.206  1.00 11.77           N  
ATOM    830  CA  GLY    98      32.826  19.036  -2.111  1.00 12.24           C  
ATOM    831  C   GLY    98      33.949  18.921  -3.124  1.00 11.83           C  
ATOM    832  O   GLY    98      34.843  19.794  -3.224  1.00 11.40           O  
ATOM    833  N   VAL    99      33.936  17.809  -3.851  1.00 12.50           N  
ATOM    834  CA  VAL    99      35.079  17.516  -4.759  1.00 12.04           C  
ATOM    835  C   VAL    99      35.247  18.503  -5.926  1.00 13.67           C  
ATOM    836  O   VAL    99      36.288  18.456  -6.634  1.00 14.68           O  
ATOM    837  CB  VAL    99      34.966  16.107  -5.330  1.00 12.48           C  
ATOM    838  CG1 VAL    99      34.952  15.066  -4.205  1.00 11.02           C  
ATOM    839  CG2 VAL    99      33.676  16.004  -6.206  1.00 10.02           C  
ATOM    840  N   VAL   100      34.243  19.356  -6.190  1.00 13.11           N  
ATOM    841  CA  VAL   100      34.429  20.384  -7.258  1.00 14.81           C  
ATOM    842  C   VAL   100      34.881  21.755  -6.749  1.00 14.74           C  
ATOM    843  O   VAL   100      35.011  22.702  -7.539  1.00 14.67           O  
ATOM    844  CB  VAL   100      33.220  20.532  -8.215  1.00 15.29           C  
ATOM    845  CG1 VAL   100      32.946  19.211  -8.916  1.00 19.59           C  
ATOM    846  CG2 VAL   100      32.006  20.981  -7.464  1.00 14.33           C  
ATOM    847  N   GLU   101      35.136  21.874  -5.446  1.00 14.02           N  
ATOM    848  CA  GLU   101      35.714  23.106  -4.924  1.00 14.89           C  
ATOM    849  C   GLU   101      37.010  23.377  -5.661  1.00 16.00           C  
ATOM    850  O   GLU   101      37.861  22.484  -5.742  1.00 16.46           O  
ATOM    851  CB  GLU   101      36.007  22.975  -3.420  1.00 15.96           C  
ATOM    852  CG  GLU   101      34.792  22.693  -2.590  1.00 18.68           C  
ATOM    853  CD  GLU   101      34.050  23.919  -2.181  1.00 21.81           C  
ATOM    854  OE1 GLU   101      34.382  25.012  -2.728  1.00 23.06           O  
ATOM    855  OE2 GLU   101      33.145  23.767  -1.300  1.00 19.19           O  
ATOM    856  N   GLY   102      37.147  24.585  -6.197  1.00 16.89           N  
ATOM    857  CA  GLY   102      38.361  24.997  -6.908  1.00 18.62           C  
ATOM    858  C   GLY   102      38.395  24.590  -8.367  1.00 19.14           C  
ATOM    859  O   GLY   102      39.412  24.832  -9.049  1.00 20.07           O  
ATOM    860  N   LYS   103      37.291  24.032  -8.876  1.00 18.98           N  
ATOM    861  CA  LYS   103      37.197  23.699 -10.299  1.00 20.92           C  
ATOM    862  C   LYS   103      36.380  24.757 -11.029  1.00 21.03           C  
ATOM    863  O   LYS   103      35.632  25.519 -10.411  1.00 20.19           O  
ATOM    864  CB  LYS   103      36.570  22.310 -10.518  1.00 20.50           C  
ATOM    865  CG  LYS   103      37.190  21.159  -9.715  1.00 22.86           C  
ATOM    866  CD  LYS   103      38.507  20.669 -10.290  1.00 23.45           C  
ATOM    867  CE  LYS   103      38.950  19.375  -9.614  1.00 23.50           C  
ATOM    868  NZ  LYS   103      40.298  18.991 -10.102  1.00 25.68           N  
ATOM    869  N   ALA   104      36.531  24.809 -12.356  1.00 22.14           N  
ATOM    870  CA  ALA   104      35.691  25.672 -13.175  1.00 23.68           C  
ATOM    871  C   ALA   104      34.233  25.281 -13.011  1.00 24.89           C  
ATOM    872  O   ALA   104      33.888  24.084 -12.896  1.00 23.99           O  
ATOM    873  CB  ALA   104      36.097  25.574 -14.678  1.00 24.14           C  
ATOM    874  N   LEU   105      33.380  26.298 -12.996  1.00 27.07           N  
ATOM    875  CA  LEU   105      31.931  26.103 -13.087  1.00 28.87           C  
ATOM    876  C   LEU   105      31.530  25.061 -14.143  1.00 29.02           C  
ATOM    877  O   LEU   105      30.664  24.232 -13.898  1.00 29.23           O  
ATOM    878  CB  LEU   105      31.257  27.442 -13.362  1.00 29.23           C  
ATOM    879  CG  LEU   105      29.755  27.479 -13.668  1.00 31.02           C  
ATOM    880  CD1 LEU   105      28.907  27.141 -12.425  1.00 32.77           C  
ATOM    881  CD2 LEU   105      29.399  28.852 -14.209  1.00 30.51           C  
ATOM    882  N   SER   106      32.178  25.086 -15.307  1.00 29.91           N  
ATOM    883  CA  SER   106      31.881  24.149 -16.387  1.00 29.14           C  
ATOM    884  C   SER   106      32.051  22.681 -15.998  1.00 29.11           C  
ATOM    885  O   SER   106      31.355  21.822 -16.527  1.00 29.44           O  
ATOM    886  CB  SER   106      32.728  24.472 -17.622  1.00 29.72           C  
ATOM    887  OG  SER   106      34.098  24.225 -17.361  1.00 30.00           O  
ATOM    888  N   GLU   107      32.982  22.398 -15.080  1.00 27.75           N  
ATOM    889  CA  GLU   107      33.183  21.041 -14.562  1.00 27.48           C  
ATOM    890  C   GLU   107      32.013  20.561 -13.714  1.00 26.29           C  
ATOM    891  O   GLU   107      31.682  19.367 -13.708  1.00 25.83           O  
ATOM    892  CB  GLU   107      34.431  20.982 -13.697  1.00 27.28           C  
ATOM    893  CG  GLU   107      35.726  20.925 -14.471  1.00 31.09           C  
ATOM    894  CD  GLU   107      36.761  20.054 -13.765  1.00 34.47           C  
ATOM    895  OE1 GLU   107      36.413  18.951 -13.265  1.00 39.28           O  
ATOM    896  OE2 GLU   107      37.930  20.465 -13.731  1.00 36.57           O  
ATOM    897  N   LEU   108      31.437  21.482 -12.953  1.00 24.91           N  
ATOM    898  CA  LEU   108      30.246  21.168 -12.154  1.00 24.54           C  
ATOM    899  C   LEU   108      29.064  20.903 -13.085  1.00 24.38           C  
ATOM    900  O   LEU   108      28.318  19.949 -12.900  1.00 23.94           O  
ATOM    901  CB  LEU   108      29.924  22.317 -11.200  1.00 23.85           C  
ATOM    902  CG  LEU   108      28.633  22.283 -10.366  1.00 24.31           C  
ATOM    903  CD1 LEU   108      28.572  21.058  -9.475  1.00 24.85           C  
ATOM    904  CD2 LEU   108      28.493  23.548  -9.560  1.00 25.05           C  
ATOM    905  N   ARG   109      28.905  21.759 -14.093  1.00 24.69           N  
ATOM    906  CA  ARG   109      27.797  21.593 -15.046  1.00 25.81           C  
ATOM    907  C   ARG   109      27.927  20.267 -15.799  1.00 25.60           C  
ATOM    908  O   ARG   109      26.936  19.578 -16.013  1.00 25.88           O  
ATOM    909  CB  ARG   109      27.722  22.778 -16.012  1.00 26.38           C  
ATOM    910  CG  ARG   109      27.505  24.090 -15.295  1.00 29.70           C  
ATOM    911  CD  ARG   109      26.671  25.027 -16.096  1.00 37.60           C  
ATOM    912  NE  ARG   109      26.665  26.367 -15.512  1.00 43.01           N  
ATOM    913  CZ  ARG   109      26.248  27.449 -16.166  1.00 45.11           C  
ATOM    914  NH1 ARG   109      25.796  27.329 -17.408  1.00 47.16           N  
ATOM    915  NH2 ARG   109      26.277  28.645 -15.585  1.00 47.45           N  
ATOM    916  N   ALA   110      29.155  19.917 -16.190  1.00 25.45           N  
ATOM    917  CA  ALA   110      29.412  18.652 -16.891  1.00 25.48           C  
ATOM    918  C   ALA   110      29.078  17.447 -16.012  1.00 25.62           C  
ATOM    919  O   ALA   110      28.485  16.465 -16.476  1.00 25.86           O  
ATOM    920  CB  ALA   110      30.848  18.593 -17.374  1.00 25.39           C  
ATOM    921  N   MET   111      29.438  17.540 -14.729  1.00 24.85           N  
ATOM    922  CA  MET   111      29.117  16.514 -13.757  0.50 23.26           C  
ATOM    924  C   MET   111      27.592  16.359 -13.584  1.00 24.91           C  
ATOM    925  O   MET   111      27.085  15.230 -13.477  1.00 24.74           O  
ATOM    926  CB  MET   111      29.815  16.828 -12.422  0.50 23.59           C  
ATOM    928  CG  MET   111      30.092  15.611 -11.579  0.50 20.75           C  
ATOM    930  SD  MET   111      30.883  16.032  -9.843  0.50 18.95          SE  
ATOM    932  CE  MET   111      32.747  15.837 -10.220  0.50 15.17           C  
ATOM    934  N   ALA   112      26.884  17.494 -13.540  1.00 25.44           N  
ATOM    935  CA  ALA   112      25.427  17.512 -13.439  1.00 26.76           C  
ATOM    936  C   ALA   112      24.818  16.790 -14.647  1.00 27.56           C  
ATOM    937  O   ALA   112      24.077  15.821 -14.486  1.00 27.10           O  
ATOM    938  CB  ALA   112      24.911  18.932 -13.376  1.00 26.49           C  
ATOM    939  N   LYS   113      25.139  17.300 -15.834  1.00 29.94           N  
ATOM    940  CA  LYS   113      24.723  16.725 -17.128  1.00 31.32           C  
ATOM    941  C   LYS   113      24.909  15.206 -17.140  1.00 31.81           C  
ATOM    942  O   LYS   113      23.985  14.460 -17.480  1.00 32.12           O  
ATOM    943  CB  LYS   113      25.496  17.434 -18.269  1.00 32.12           C  
ATOM    944  CG  LYS   113      25.539  16.786 -19.681  1.00 32.56           C  
ATOM    945  CD  LYS   113      24.177  16.663 -20.371  1.00 37.78           C  
ATOM    946  CE  LYS   113      24.235  15.605 -21.499  1.00 38.53           C  
ATOM    947  NZ  LYS   113      22.973  14.790 -21.585  1.00 41.24           N  
ATOM    948  N   ALA   114      26.094  14.753 -16.737  1.00 32.76           N  
ATOM    949  CA  ALA   114      26.410  13.322 -16.690  1.00 33.68           C  
ATOM    950  C   ALA   114      25.518  12.546 -15.725  1.00 34.47           C  
ATOM    951  O   ALA   114      25.190  11.380 -15.980  1.00 34.78           O  
ATOM    952  CB  ALA   114      27.859  13.111 -16.338  1.00 33.77           C  
ATOM    953  N   ALA   115      25.130  13.181 -14.617  1.00 34.82           N  
ATOM    954  CA  ALA   115      24.253  12.533 -13.633  1.00 35.21           C  
ATOM    955  C   ALA   115      22.772  12.575 -14.030  1.00 35.51           C  
ATOM    956  O   ALA   115      21.914  12.092 -13.291  1.00 35.77           O  
ATOM    957  CB  ALA   115      24.458  13.149 -12.245  1.00 35.54           C  
ATOM    958  N   ARG   116      22.485  13.151 -15.197  1.00 35.81           N  
ATOM    959  CA  ARG   116      21.116  13.413 -15.664  1.00 36.57           C  
ATOM    960  C   ARG   116      20.358  14.336 -14.703  1.00 35.96           C  
ATOM    961  O   ARG   116      19.173  14.146 -14.421  1.00 35.58           O  
ATOM    962  CB  ARG   116      20.351  12.109 -15.954  1.00 36.76           C  
ATOM    963  CG  ARG   116      20.943  11.282 -17.109  1.00 38.35           C  
ATOM    964  CD  ARG   116      19.941  10.231 -17.616  1.00 39.16           C  
ATOM    965  NE  ARG   116      18.865  10.833 -18.415  1.00 45.58           N  
ATOM    966  CZ  ARG   116      18.722  10.692 -19.735  1.00 47.21           C  
ATOM    967  NH1 ARG   116      17.713  11.292 -20.360  1.00 48.53           N  
ATOM    968  NH2 ARG   116      19.577   9.950 -20.436  1.00 47.82           N  
ATOM    969  N   GLU   117      21.074  15.339 -14.198  1.00 35.11           N  
ATOM    970  CA  GLU   117      20.493  16.359 -13.344  1.00 34.78           C  
ATOM    971  C   GLU   117      20.925  17.749 -13.819  1.00 33.72           C  
ATOM    972  O   GLU   117      21.735  17.874 -14.752  1.00 33.94           O  
ATOM    973  CB  GLU   117      20.900  16.117 -11.888  1.00 34.37           C  
ATOM    974  CG  GLU   117      20.427  14.774 -11.341  1.00 35.31           C  
ATOM    975  CD  GLU   117      20.919  14.515  -9.929  1.00 36.02           C  
ATOM    976  OE1 GLU   117      21.039  15.488  -9.157  1.00 35.32           O  
ATOM    977  OE2 GLU   117      21.184  13.339  -9.586  1.00 39.92           O  
ATOM    978  N   GLU   118      20.361  18.785 -13.204  1.00 32.71           N  
ATOM    979  CA  GLU   118      20.663  20.176 -13.569  1.00 32.59           C  
ATOM    980  C   GLU   118      21.165  20.955 -12.355  1.00 30.03           C  
ATOM    981  O   GLU   118      20.750  20.663 -11.221  1.00 28.44           O  
ATOM    982  CB  GLU   118      19.410  20.892 -14.056  1.00 32.85           C  
ATOM    983  CG  GLU   118      18.594  20.155 -15.100  1.00 35.90           C  
ATOM    984  CD  GLU   118      17.471  21.020 -15.648  1.00 36.89           C  
ATOM    985  OE1 GLU   118      16.623  21.507 -14.845  1.00 42.48           O  
ATOM    986  OE2 GLU   118      17.447  21.218 -16.887  1.00 42.19           O  
ATOM    987  N   CYS   119      22.027  21.946 -12.614  1.00 28.23           N  
ATOM    988  CA  CYS   119      22.452  22.914 -11.593  1.00 26.98           C  
ATOM    989  C   CYS   119      21.342  23.946 -11.462  1.00 25.57           C  
ATOM    990  O   CYS   119      20.665  24.224 -12.462  1.00 25.73           O  
ATOM    991  CB  CYS   119      23.757  23.606 -12.002  1.00 27.45           C  
ATOM    992  SG  CYS   119      25.141  22.472 -12.121  1.00 29.53           S  
ATOM    993  N   PRO   120      21.139  24.523 -10.258  1.00 23.62           N  
ATOM    994  CA  PRO   120      21.849  24.302  -8.974  1.00 21.20           C  
ATOM    995  C   PRO   120      21.369  23.125  -8.124  1.00 20.06           C  
ATOM    996  O   PRO   120      21.936  22.885  -7.060  1.00 17.82           O  
ATOM    997  CB  PRO   120      21.537  25.580  -8.198  1.00 22.04           C  
ATOM    998  CG  PRO   120      20.144  25.948  -8.652  1.00 22.84           C  
ATOM    999  CD  PRO   120      20.095  25.560 -10.125  1.00 23.21           C  
ATOM   1000  N   VAL   121      20.349  22.390  -8.562  1.00 18.45           N  
ATOM   1001  CA  VAL   121      19.870  21.259  -7.749  1.00 17.90           C  
ATOM   1002  C   VAL   121      20.963  20.198  -7.540  1.00 16.37           C  
ATOM   1003  O   VAL   121      21.146  19.687  -6.433  1.00 16.62           O  
ATOM   1004  CB  VAL   121      18.557  20.661  -8.340  1.00 18.55           C  
ATOM   1005  CG1 VAL   121      18.271  19.271  -7.769  1.00 19.26           C  
ATOM   1006  CG2 VAL   121      17.409  21.618  -8.031  1.00 18.36           C  
ATOM   1007  N   PHE   122      21.673  19.872  -8.610  1.00 16.51           N  
ATOM   1008  CA  PHE   122      22.654  18.799  -8.556  1.00 16.39           C  
ATOM   1009  C   PHE   122      23.668  19.052  -7.432  1.00 16.35           C  
ATOM   1010  O   PHE   122      24.175  20.152  -7.316  1.00 15.68           O  
ATOM   1011  CB  PHE   122      23.375  18.677  -9.889  1.00 17.53           C  
ATOM   1012  CG  PHE   122      24.571  17.769  -9.834  1.00 18.38           C  
ATOM   1013  CD1 PHE   122      24.405  16.393  -9.692  1.00 18.85           C  
ATOM   1014  CD2 PHE   122      25.873  18.316  -9.857  1.00 19.32           C  
ATOM   1015  CE1 PHE   122      25.520  15.545  -9.598  1.00 21.40           C  
ATOM   1016  CE2 PHE   122      26.990  17.492  -9.795  1.00 19.08           C  
ATOM   1017  CZ  PHE   122      26.818  16.100  -9.644  1.00 20.67           C  
ATOM   1018  N   THR   123      23.937  18.023  -6.636  1.00 14.58           N  
ATOM   1019  CA  THR   123      24.913  18.081  -5.558  1.00 13.79           C  
ATOM   1020  C   THR   123      26.057  17.091  -5.784  1.00 13.81           C  
ATOM   1021  O   THR   123      25.815  15.882  -5.743  1.00 14.03           O  
ATOM   1022  CB  THR   123      24.210  17.757  -4.229  1.00 13.79           C  
ATOM   1023  OG1 THR   123      23.150  18.714  -4.043  1.00 13.23           O  
ATOM   1024  CG2 THR   123      25.165  17.834  -3.075  1.00 13.37           C  
ATOM   1025  N   PRO   124      27.298  17.598  -5.974  1.00 13.35           N  
ATOM   1026  CA  PRO   124      28.459  16.717  -6.210  1.00 12.91           C  
ATOM   1027  C   PRO   124      28.835  15.980  -4.923  1.00 13.01           C  
ATOM   1028  O   PRO   124      28.407  16.405  -3.816  1.00 12.54           O  
ATOM   1029  CB  PRO   124      29.580  17.679  -6.617  1.00 14.14           C  
ATOM   1030  CG  PRO   124      29.146  19.047  -6.128  1.00 13.45           C  
ATOM   1031  CD  PRO   124      27.650  19.032  -5.972  1.00 12.87           C  
ATOM   1032  N   PRO   125      29.655  14.912  -5.037  1.00 13.44           N  
ATOM   1033  CA  PRO   125      30.187  14.273  -3.846  1.00 13.53           C  
ATOM   1034  C   PRO   125      30.823  15.290  -2.880  1.00 13.16           C  
ATOM   1035  O   PRO   125      31.621  16.109  -3.298  1.00 12.44           O  
ATOM   1036  CB  PRO   125      31.230  13.295  -4.423  1.00 14.24           C  
ATOM   1037  CG  PRO   125      30.673  12.977  -5.804  1.00 15.16           C  
ATOM   1038  CD  PRO   125      30.160  14.294  -6.276  1.00 14.35           C  
ATOM   1039  N   GLY   126      30.452  15.221  -1.600  1.00 13.37           N  
ATOM   1040  CA  GLY   126      30.991  16.124  -0.568  1.00 12.38           C  
ATOM   1041  C   GLY   126      30.260  17.469  -0.494  1.00 12.55           C  
ATOM   1042  O   GLY   126      30.558  18.265   0.386  1.00 14.16           O  
ATOM   1043  N   GLY   127      29.307  17.701  -1.375  1.00 12.12           N  
ATOM   1044  CA  GLY   127      28.544  18.974  -1.397  1.00 11.03           C  
ATOM   1045  C   GLY   127      27.258  18.895  -0.603  1.00 12.16           C  
ATOM   1046  O   GLY   127      26.846  17.783  -0.121  1.00 11.11           O  
ATOM   1047  N   GLU   128      26.644  20.072  -0.380  1.00 11.01           N  
ATOM   1048  CA  GLU   128      25.330  20.188   0.289  1.00 11.89           C  
ATOM   1049  C   GLU   128      24.229  20.326  -0.747  1.00 11.34           C  
ATOM   1050  O   GLU   128      24.424  20.983  -1.790  1.00 12.25           O  
ATOM   1051  CB  GLU   128      25.265  21.460   1.176  1.00 11.43           C  
ATOM   1052  CG  GLU   128      26.020  21.334   2.516  1.00 11.16           C  
ATOM   1053  CD  GLU   128      26.067  22.656   3.250  1.00 14.31           C  
ATOM   1054  OE1 GLU   128      26.553  23.629   2.649  1.00 12.14           O  
ATOM   1055  OE2 GLU   128      25.672  22.695   4.437  1.00 17.34           O  
ATOM   1056  N   THR   129      23.055  19.755  -0.451  1.00 11.74           N  
ATOM   1057  CA  THR   129      21.827  19.964  -1.236  1.00 11.64           C  
ATOM   1058  C   THR   129      21.280  21.373  -0.977  1.00 11.58           C  
ATOM   1059  O   THR   129      21.643  21.995   0.050  1.00 10.25           O  
ATOM   1060  CB  THR   129      20.719  18.950  -0.876  1.00 12.61           C  
ATOM   1061  OG1 THR   129      20.353  19.146   0.536  1.00 14.75           O  
ATOM   1062  CG2 THR   129      21.286  17.516  -0.977  1.00 15.54           C  
ATOM   1063  N   LEU   130      20.437  21.862  -1.904  1.00 11.52           N  
ATOM   1064  CA  LEU   130      19.738  23.143  -1.676  1.00 12.31           C  
ATOM   1065  C   LEU   130      18.949  23.100  -0.380  1.00 12.77           C  
ATOM   1066  O   LEU   130      18.929  24.072   0.332  1.00 10.77           O  
ATOM   1067  CB  LEU   130      18.831  23.525  -2.852  1.00 13.53           C  
ATOM   1068  CG  LEU   130      19.595  23.847  -4.142  1.00 14.68           C  
ATOM   1069  CD1 LEU   130      18.645  24.060  -5.326  1.00 17.49           C  
ATOM   1070  CD2 LEU   130      20.532  25.046  -3.947  1.00 18.17           C  
ATOM   1071  N   ASP   131      18.345  21.964  -0.042  1.00 12.80           N  
ATOM   1072  CA  ASP   131      17.546  21.916   1.175  1.00 13.89           C  
ATOM   1073  C   ASP   131      18.433  21.950   2.421  1.00 13.08           C  
ATOM   1074  O   ASP   131      18.056  22.543   3.433  1.00 12.35           O  
ATOM   1075  CB  ASP   131      16.610  20.690   1.175  1.00 15.29           C  
ATOM   1076  CG  ASP   131      15.323  20.920   0.350  1.00 19.19           C  
ATOM   1077  OD1 ASP   131      14.896  22.070   0.066  1.00 24.81           O  
ATOM   1078  OD2 ASP   131      14.735  19.904  -0.020  1.00 27.72           O  
ATOM   1079  N   GLN   132      19.621  21.349   2.346  1.00 12.26           N  
ATOM   1080  CA  GLN   132      20.561  21.450   3.443  1.00 11.76           C  
ATOM   1081  C   GLN   132      21.019  22.912   3.650  1.00 11.28           C  
ATOM   1082  O   GLN   132      21.130  23.390   4.812  1.00  9.47           O  
ATOM   1083  CB  GLN   132      21.777  20.566   3.167  1.00 12.20           C  
ATOM   1084  CG  GLN   132      21.508  19.091   3.488  1.00 15.13           C  
ATOM   1085  CD  GLN   132      22.679  18.210   3.078  1.00 18.85           C  
ATOM   1086  OE1 GLN   132      23.201  18.338   1.971  1.00 16.27           O  
ATOM   1087  NE2 GLN   132      23.110  17.325   3.991  1.00 23.69           N  
ATOM   1088  N   VAL   133      21.279  23.616   2.550  1.00  9.48           N  
ATOM   1089  CA  VAL   133      21.651  25.041   2.659  1.00  9.49           C  
ATOM   1090  C   VAL   133      20.518  25.854   3.282  1.00  9.92           C  
ATOM   1091  O   VAL   133      20.744  26.611   4.228  1.00  9.67           O  
ATOM   1092  CB  VAL   133      22.038  25.636   1.275  1.00 10.42           C  
ATOM   1093  CG1 VAL   133      22.439  27.068   1.402  1.00 10.99           C  
ATOM   1094  CG2 VAL   133      23.237  24.856   0.663  1.00  9.59           C  
ATOM   1095  N   LYS   134      19.309  25.698   2.754  1.00 10.05           N  
ATOM   1096  CA  LYS   134      18.129  26.384   3.308  1.00 10.95           C  
ATOM   1097  C   LYS   134      17.980  26.086   4.795  1.00 11.05           C  
ATOM   1098  O   LYS   134      17.592  26.959   5.566  1.00  9.92           O  
ATOM   1099  CB  LYS   134      16.856  25.966   2.585  1.00 10.96           C  
ATOM   1100  CG  LYS   134      15.648  26.772   3.054  1.00 13.28           C  
ATOM   1101  CD  LYS   134      14.331  26.418   2.340  1.00 15.14           C  
ATOM   1102  CE  LYS   134      14.135  27.178   1.071  1.00 19.20           C  
ATOM   1103  NZ  LYS   134      12.763  26.837   0.546  1.00 22.40           N  
ATOM   1104  N   MET   135      18.239  24.845   5.204  1.00  9.06           N  
ATOM   1105  CA  MET   135      18.044  24.514   6.621  1.00 11.12           C  
ATOM   1106  C   MET   135      19.006  25.323   7.494  1.00 10.30           C  
ATOM   1107  O   MET   135      18.621  25.789   8.531  1.00 10.53           O  
ATOM   1108  CB  MET   135      18.138  22.983   6.830  1.00 11.96           C  
ATOM   1109  CG  MET   135      17.896  22.479   8.257  1.00 13.35           C  
ATOM   1110  SD  MET   135      16.066  22.913   8.811  1.00 15.75          SE  
ATOM   1111  CE  MET   135      16.394  24.116  10.229  1.00 19.57           C  
ATOM   1112  N   ARG   136      20.245  25.528   7.042  1.00  9.96           N  
ATOM   1113  CA  ARG   136      21.207  26.423   7.733  1.00  9.44           C  
ATOM   1114  C   ARG   136      20.721  27.874   7.792  1.00 10.34           C  
ATOM   1115  O   ARG   136      20.948  28.566   8.776  1.00 11.05           O  
ATOM   1116  CB  ARG   136      22.596  26.348   7.102  1.00  8.92           C  
ATOM   1117  CG  ARG   136      23.220  24.964   7.297  1.00 10.88           C  
ATOM   1118  CD  ARG   136      24.692  25.051   7.080  1.00 10.58           C  
ATOM   1119  NE  ARG   136      25.105  25.173   5.661  1.00  9.48           N  
ATOM   1120  CZ  ARG   136      25.618  26.262   5.081  1.00 10.08           C  
ATOM   1121  NH1 ARG   136      25.626  27.455   5.692  1.00  9.95           N  
ATOM   1122  NH2 ARG   136      26.066  26.169   3.812  1.00  9.85           N  
ATOM   1123  N   GLY   137      19.974  28.275   6.763  1.00  9.12           N  
ATOM   1124  CA  GLY   137      19.362  29.616   6.694  1.00 10.59           C  
ATOM   1125  C   GLY   137      18.235  29.727   7.721  1.00 10.98           C  
ATOM   1126  O   GLY   137      18.143  30.735   8.466  1.00 10.49           O  
ATOM   1127  N   ILE   138      17.365  28.706   7.739  1.00 10.10           N  
ATOM   1128  CA  ILE   138      16.271  28.625   8.740  1.00  9.94           C  
ATOM   1129  C   ILE   138      16.838  28.634  10.204  1.00 10.47           C  
ATOM   1130  O   ILE   138      16.357  29.367  11.071  1.00 10.30           O  
ATOM   1131  CB  ILE   138      15.379  27.383   8.485  1.00  9.63           C  
ATOM   1132  CG1 ILE   138      14.688  27.518   7.103  1.00  9.46           C  
ATOM   1133  CG2 ILE   138      14.331  27.262   9.586  1.00 12.67           C  
ATOM   1134  CD1 ILE   138      13.942  26.227   6.728  1.00 10.38           C  
ATOM   1135  N   ASP   139      17.871  27.827  10.446  1.00 10.75           N  
ATOM   1136  CA  ASP   139      18.523  27.719  11.751  1.00 12.25           C  
ATOM   1137  C   ASP   139      19.051  29.087  12.177  1.00 11.78           C  
ATOM   1138  O   ASP   139      18.744  29.575  13.280  1.00 12.04           O  
ATOM   1139  CB  ASP   139      19.665  26.694  11.614  1.00 12.31           C  
ATOM   1140  CG  ASP   139      20.421  26.416  12.931  1.00 17.51           C  
ATOM   1141  OD1 ASP   139      20.224  27.111  13.931  1.00 23.55           O  
ATOM   1142  OD2 ASP   139      21.267  25.482  12.918  1.00 23.53           O  
ATOM   1143  N   PHE   140      19.828  29.719  11.300  1.00 10.99           N  
ATOM   1144  CA  PHE   140      20.375  31.032  11.623  1.00 11.07           C  
ATOM   1145  C   PHE   140      19.255  32.044  11.868  1.00 10.71           C  
ATOM   1146  O   PHE   140      19.280  32.819  12.844  1.00 11.15           O  
ATOM   1147  CB  PHE   140      21.308  31.564  10.533  1.00 10.66           C  
ATOM   1148  CG  PHE   140      21.842  32.928  10.882  1.00 11.12           C  
ATOM   1149  CD1 PHE   140      22.879  33.030  11.802  1.00 13.72           C  
ATOM   1150  CD2 PHE   140      21.241  34.092  10.383  1.00 11.20           C  
ATOM   1151  CE1 PHE   140      23.358  34.277  12.190  1.00 13.44           C  
ATOM   1152  CE2 PHE   140      21.724  35.384  10.768  1.00 11.43           C  
ATOM   1153  CZ  PHE   140      22.778  35.452  11.680  1.00 13.56           C  
ATOM   1154  N   PHE   141      18.275  32.061  10.961  1.00  9.26           N  
ATOM   1155  CA  PHE   141      17.192  33.042  11.078  1.00  9.67           C  
ATOM   1156  C   PHE   141      16.396  32.886  12.391  1.00  9.64           C  
ATOM   1157  O   PHE   141      16.073  33.884  13.054  1.00 10.41           O  
ATOM   1158  CB  PHE   141      16.224  32.908   9.897  1.00  9.66           C  
ATOM   1159  CG  PHE   141      15.129  33.941   9.915  1.00 10.69           C  
ATOM   1160  CD1 PHE   141      15.453  35.288   9.712  1.00 11.03           C  
ATOM   1161  CD2 PHE   141      13.787  33.576  10.129  1.00 13.04           C  
ATOM   1162  CE1 PHE   141      14.439  36.279   9.718  1.00 13.41           C  
ATOM   1163  CE2 PHE   141      12.752  34.558  10.131  1.00 12.72           C  
ATOM   1164  CZ  PHE   141      13.090  35.911   9.934  1.00 12.61           C  
ATOM   1165  N   GLU   142      16.056  31.654  12.739  1.00 10.90           N  
ATOM   1166  CA  GLU   142      15.343  31.419  14.018  1.00 12.50           C  
ATOM   1167  C   GLU   142      16.180  31.860  15.208  1.00 12.76           C  
ATOM   1168  O   GLU   142      15.645  32.512  16.144  1.00 12.86           O  
ATOM   1169  CB  GLU   142      14.956  29.948  14.133  1.00 14.29           C  
ATOM   1170  CG  GLU   142      13.950  29.649  13.002  1.00 18.51           C  
ATOM   1171  CD  GLU   142      13.206  28.339  13.106  1.00 26.10           C  
ATOM   1172  OE1 GLU   142      12.074  28.285  12.548  1.00 26.39           O  
ATOM   1173  OE2 GLU   142      13.733  27.380  13.716  1.00 30.36           O  
ATOM   1174  N   PHE   143      17.468  31.490  15.178  1.00 11.64           N  
ATOM   1175  CA  PHE   143      18.452  31.988  16.154  1.00 12.86           C  
ATOM   1176  C   PHE   143      18.407  33.541  16.285  1.00 13.14           C  
ATOM   1177  O   PHE   143      18.296  34.089  17.402  1.00 12.88           O  
ATOM   1178  CB  PHE   143      19.855  31.490  15.793  1.00 14.14           C  
ATOM   1179  CG  PHE   143      20.971  32.331  16.383  1.00 16.21           C  
ATOM   1180  CD1 PHE   143      21.327  32.196  17.723  1.00 19.07           C  
ATOM   1181  CD2 PHE   143      21.602  33.302  15.624  1.00 15.91           C  
ATOM   1182  CE1 PHE   143      22.348  32.991  18.271  1.00 20.54           C  
ATOM   1183  CE2 PHE   143      22.596  34.111  16.160  1.00 20.18           C  
ATOM   1184  CZ  PHE   143      22.977  33.955  17.484  1.00 17.61           C  
ATOM   1185  N   LEU   144      18.513  34.228  15.153  1.00 11.11           N  
ATOM   1186  CA  LEU   144      18.529  35.689  15.110  1.00 11.52           C  
ATOM   1187  C   LEU   144      17.234  36.287  15.704  1.00 11.63           C  
ATOM   1188  O   LEU   144      17.280  37.194  16.562  1.00 12.63           O  
ATOM   1189  CB  LEU   144      18.725  36.173  13.658  1.00 10.82           C  
ATOM   1190  CG  LEU   144      18.846  37.697  13.477  1.00 11.37           C  
ATOM   1191  CD1 LEU   144      20.007  38.293  14.264  1.00 14.98           C  
ATOM   1192  CD2 LEU   144      18.998  38.069  11.981  1.00 12.34           C  
ATOM   1193  N   CYS   145      16.089  35.738  15.280  1.00 11.54           N  
ATOM   1194  CA  CYS   145      14.771  36.188  15.771  1.00 12.26           C  
ATOM   1195  C   CYS   145      14.670  36.081  17.292  1.00 13.44           C  
ATOM   1196  O   CYS   145      14.323  37.070  17.943  1.00 13.67           O  
ATOM   1197  CB  CYS   145      13.644  35.406  15.096  1.00 12.21           C  
ATOM   1198  SG  CYS   145      13.463  35.951  13.328  1.00 14.79           S  
ATOM   1199  N   GLN   146      15.007  34.920  17.837  1.00 13.71           N  
ATOM   1200  CA  GLN   146      15.004  34.707  19.294  1.00 15.59           C  
ATOM   1201  C   GLN   146      15.946  35.663  20.006  1.00 15.93           C  
ATOM   1202  O   GLN   146      15.580  36.240  21.051  1.00 15.40           O  
ATOM   1203  CB  GLN   146      15.332  33.252  19.635  1.00 16.45           C  
ATOM   1204  CG  GLN   146      14.186  32.288  19.241  1.00 22.14           C  
ATOM   1205  CD  GLN   146      12.874  32.640  19.971  1.00 29.71           C  
ATOM   1206  OE1 GLN   146      12.777  32.509  21.201  1.00 32.44           O  
ATOM   1207  NE2 GLN   146      11.882  33.131  19.216  1.00 32.00           N  
ATOM   1208  N   LEU   147      17.138  35.859  19.428  1.00 15.37           N  
ATOM   1209  CA  LEU   147      18.154  36.782  19.976  1.00 15.16           C  
ATOM   1210  C   LEU   147      17.588  38.202  20.161  1.00 15.14           C  
ATOM   1211  O   LEU   147      17.635  38.785  21.258  1.00 15.30           O  
ATOM   1212  CB  LEU   147      19.390  36.799  19.053  1.00 14.58           C  
ATOM   1213  CG  LEU   147      20.477  37.750  19.578  1.00 18.48           C  
ATOM   1214  CD1 LEU   147      21.277  37.026  20.669  1.00 24.94           C  
ATOM   1215  CD2 LEU   147      21.391  38.217  18.509  1.00 21.05           C  
ATOM   1216  N   ILE   148      17.013  38.730  19.088  1.00 13.47           N  
ATOM   1217  CA  ILE   148      16.472  40.085  19.047  1.00 13.77           C  
ATOM   1218  C   ILE   148      15.277  40.239  19.987  1.00 13.26           C  
ATOM   1219  O   ILE   148      15.188  41.254  20.716  1.00 13.49           O  
ATOM   1220  CB  ILE   148      16.083  40.484  17.599  1.00 13.22           C  
ATOM   1221  CG1 ILE   148      17.315  40.531  16.688  1.00 12.36           C  
ATOM   1222  CG2 ILE   148      15.325  41.837  17.556  1.00 15.01           C  
ATOM   1223  CD1 ILE   148      18.530  41.337  17.225  1.00 14.76           C  
ATOM   1224  N   LEU   149      14.378  39.253  19.981  1.00 13.33           N  
ATOM   1225  CA  LEU   149      13.166  39.304  20.851  1.00 12.70           C  
ATOM   1226  C   LEU   149      13.587  39.302  22.328  1.00 13.92           C  
ATOM   1227  O   LEU   149      13.110  40.134  23.119  1.00 13.08           O  
ATOM   1228  CB  LEU   149      12.228  38.132  20.556  1.00 13.22           C  
ATOM   1229  CG  LEU   149      11.562  38.284  19.170  1.00 11.59           C  
ATOM   1230  CD1 LEU   149      10.787  36.997  18.820  1.00 14.38           C  
ATOM   1231  CD2 LEU   149      10.627  39.515  19.141  1.00 16.20           C  
ATOM   1232  N   LYS   150      14.521  38.415  22.660  1.00 13.32           N  
ATOM   1233  CA  LYS   150      15.031  38.306  24.051  1.00 15.01           C  
ATOM   1234  C   LYS   150      15.770  39.578  24.495  1.00 15.41           C  
ATOM   1235  O   LYS   150      15.614  40.042  25.647  1.00 15.91           O  
ATOM   1236  CB  LYS   150      15.924  37.077  24.192  1.00 15.61           C  
ATOM   1237  CG  LYS   150      15.172  35.781  24.225  1.00 18.33           C  
ATOM   1238  CD  LYS   150      16.140  34.636  24.225  1.00 22.37           C  
ATOM   1239  CE  LYS   150      15.405  33.333  24.046  1.00 29.21           C  
ATOM   1240  NZ  LYS   150      15.119  32.732  25.380  1.00 34.01           N  
ATOM   1241  N   GLU   151      16.566  40.159  23.600  1.00 16.59           N  
ATOM   1242  CA  GLU   151      17.236  41.421  23.903  1.00 18.62           C  
ATOM   1243  C   GLU   151      16.242  42.543  24.094  1.00 18.93           C  
ATOM   1244  O   GLU   151      16.381  43.320  25.036  1.00 19.86           O  
ATOM   1245  CB  GLU   151      18.279  41.783  22.826  1.00 18.64           C  
ATOM   1246  CG  GLU   151      19.491  40.830  22.871  1.00 20.23           C  
ATOM   1247  CD  GLU   151      20.613  41.209  21.915  1.00 21.22           C  
ATOM   1248  OE1 GLU   151      20.429  42.127  21.092  1.00 26.24           O  
ATOM   1249  OE2 GLU   151      21.676  40.557  21.971  1.00 24.90           O  
ATOM   1250  N   ALA   152      15.231  42.625  23.220  1.00 19.10           N  
ATOM   1251  CA  ALA   152      14.172  43.629  23.369  1.00 19.49           C  
ATOM   1252  C   ALA   152      13.473  43.445  24.730  1.00 19.77           C  
ATOM   1253  O   ALA   152      13.114  44.432  25.390  1.00 19.86           O  
ATOM   1254  CB  ALA   152      13.159  43.526  22.252  1.00 20.37           C  
ATOM   1255  N   ASP   153      13.259  42.188  25.112  1.00 19.41           N  
ATOM   1256  CA  ASP   153      12.605  41.850  26.380  1.00 21.62           C  
ATOM   1257  C   ASP   153      13.466  42.281  27.569  1.00 23.56           C  
ATOM   1258  O   ASP   153      12.959  42.809  28.560  1.00 23.49           O  
ATOM   1259  CB  ASP   153      12.369  40.338  26.494  1.00 20.56           C  
ATOM   1260  CG  ASP   153      11.495  39.982  27.680  1.00 19.09           C  
ATOM   1261  OD1 ASP   153      10.349  40.462  27.714  1.00 21.16           O  
ATOM   1262  OD2 ASP   153      11.962  39.243  28.563  1.00 19.70           O  
ATOM   1263  N   GLN   154      14.763  42.012  27.472  1.00 26.71           N  
ATOM   1264  CA  GLN   154      15.697  42.277  28.574  1.00 30.61           C  
ATOM   1265  C   GLN   154      16.002  43.776  28.747  1.00 32.44           C  
ATOM   1266  O   GLN   154      16.568  44.176  29.779  1.00 34.00           O  
ATOM   1267  CB  GLN   154      16.979  41.429  28.444  1.00 30.79           C  
ATOM   1268  CG  GLN   154      16.770  39.895  28.461  1.00 33.07           C  
ATOM   1269  CD  GLN   154      16.043  39.367  29.699  1.00 37.37           C  
ATOM   1270  OE1 GLN   154      16.550  39.443  30.823  1.00 39.46           O  
ATOM   1271  NE2 GLN   154      14.846  38.807  29.487  1.00 40.42           N  
ATOM   1272  N   LYS   155      15.587  44.612  27.785  1.00 34.64           N  
ATOM   1273  CA  LYS   155      15.755  46.085  27.881  1.00 36.26           C  
ATOM   1274  C   LYS   155      14.446  46.864  28.024  1.00 36.17           C  
ATOM   1275  O   LYS   155      13.360  46.298  28.201  1.00 37.58           O  
ATOM   1276  CB  LYS   155      16.523  46.682  26.678  1.00 36.32           C  
ATOM   1277  CG  LYS   155      17.355  45.733  25.836  1.00 39.40           C  
ATOM   1278  CD  LYS   155      18.806  45.627  26.267  1.00 40.09           C  
ATOM   1279  CE  LYS   155      19.565  44.727  25.301  1.00 43.03           C  
ATOM   1280  NZ  LYS   155      19.928  45.384  24.002  1.00 43.48           N  
ATOM   1281  N   ASN   165      12.474  55.446  15.912  1.00 41.07           N  
ATOM   1282  CA  ASN   165      12.786  56.233  14.721  1.00 40.86           C  
ATOM   1283  C   ASN   165      14.225  56.117  14.260  1.00 39.46           C  
ATOM   1284  O   ASN   165      14.474  55.926  13.065  1.00 39.76           O  
ATOM   1285  CB  ASN   165      12.495  57.726  14.953  1.00 41.56           C  
ATOM   1286  CG  ASN   165      11.019  58.026  15.088  1.00 43.79           C  
ATOM   1287  OD1 ASN   165      10.175  57.371  14.470  1.00 47.63           O  
ATOM   1288  ND2 ASN   165      10.696  59.042  15.885  1.00 46.17           N  
ATOM   1289  N   CYS   166      15.149  56.242  15.216  1.00 37.98           N  
ATOM   1290  CA  CYS   166      16.580  56.379  14.945  0.50 36.88           C  
ATOM   1292  C   CYS   166      17.170  55.327  13.986  1.00 36.05           C  
ATOM   1293  O   CYS   166      17.921  55.653  13.041  1.00 35.95           O  
ATOM   1294  CB  CYS   166      17.329  56.360  16.274  0.50 37.09           C  
ATOM   1296  SG  CYS   166      19.092  56.519  16.131  0.50 38.12           S  
ATOM   1298  N   LEU   167      16.844  54.063  14.232  1.00 33.59           N  
ATOM   1299  CA  LEU   167      17.349  52.984  13.376  1.00 30.89           C  
ATOM   1300  C   LEU   167      16.723  53.022  11.973  1.00 29.85           C  
ATOM   1301  O   LEU   167      17.438  52.862  10.974  1.00 28.15           O  
ATOM   1302  CB  LEU   167      17.144  51.623  14.043  1.00 29.90           C  
ATOM   1303  CG  LEU   167      17.722  51.341  15.434  1.00 29.69           C  
ATOM   1304  CD1 LEU   167      17.442  49.901  15.841  1.00 27.15           C  
ATOM   1305  CD2 LEU   167      19.210  51.625  15.503  1.00 27.72           C  
ATOM   1306  N   GLU   168      15.405  53.265  11.905  1.00 28.65           N  
ATOM   1307  CA  GLU   168      14.659  53.300  10.634  1.00 28.93           C  
ATOM   1308  C   GLU   168      15.057  54.494   9.758  1.00 27.44           C  
ATOM   1309  O   GLU   168      15.255  54.348   8.551  1.00 27.06           O  
ATOM   1310  CB  GLU   168      13.141  53.301  10.891  1.00 29.00           C  
ATOM   1311  CG  GLU   168      12.255  53.014   9.660  1.00 30.98           C  
ATOM   1312  CD  GLU   168      10.935  52.292  10.007  1.00 32.01           C  
ATOM   1313  OE1 GLU   168      10.464  52.369  11.172  1.00 35.69           O  
ATOM   1314  OE2 GLU   168      10.375  51.617   9.112  1.00 36.97           O  
ATOM   1315  N   THR   169      15.176  55.673  10.373  1.00 27.30           N  
ATOM   1316  CA  THR   169      15.520  56.891   9.635  1.00 27.25           C  
ATOM   1317  C   THR   169      16.842  56.760   8.882  1.00 26.37           C  
ATOM   1318  O   THR   169      16.923  57.137   7.709  1.00 26.91           O  
ATOM   1319  CB  THR   169      15.510  58.168  10.544  1.00 27.66           C  
ATOM   1320  OG1 THR   169      16.549  58.072  11.523  1.00 29.75           O  
ATOM   1321  CG2 THR   169      14.185  58.297  11.260  1.00 27.52           C  
ATOM   1322  N   SER   170      17.848  56.182   9.535  1.00 26.61           N  
ATOM   1323  CA  SER   170      19.174  56.002   8.917  1.00 26.93           C  
ATOM   1324  C   SER   170      19.123  55.010   7.750  1.00 26.69           C  
ATOM   1325  O   SER   170      19.792  55.208   6.740  1.00 27.67           O  
ATOM   1326  CB  SER   170      20.248  55.639   9.958  1.00 27.25           C  
ATOM   1327  OG  SER   170      20.071  54.353  10.510  1.00 28.32           O  
ATOM   1328  N   LEU   171      18.305  53.966   7.868  1.00 26.17           N  
ATOM   1329  CA  LEU   171      18.040  53.090   6.720  1.00 25.72           C  
ATOM   1330  C   LEU   171      17.287  53.802   5.580  1.00 26.04           C  
ATOM   1331  O   LEU   171      17.639  53.648   4.407  1.00 25.52           O  
ATOM   1332  CB  LEU   171      17.298  51.821   7.156  1.00 25.40           C  
ATOM   1333  CG  LEU   171      18.092  50.830   8.015  1.00 24.74           C  
ATOM   1334  CD1 LEU   171      17.136  49.817   8.632  1.00 23.70           C  
ATOM   1335  CD2 LEU   171      19.200  50.144   7.186  1.00 22.15           C  
ATOM   1336  N   ALA   172      16.256  54.588   5.927  1.00 26.86           N  
ATOM   1337  CA  ALA   172      15.388  55.251   4.933  1.00 27.07           C  
ATOM   1338  C   ALA   172      16.132  56.273   4.070  1.00 27.99           C  
ATOM   1339  O   ALA   172      15.687  56.601   2.959  1.00 28.28           O  
ATOM   1340  CB  ALA   172      14.173  55.917   5.628  1.00 26.59           C  
ATOM   1341  N   GLU   173      17.268  56.735   4.592  1.00 28.87           N  
ATOM   1342  CA  GLU   173      18.192  57.649   3.923  1.00 31.20           C  
ATOM   1343  C   GLU   173      18.737  57.100   2.610  1.00 30.70           C  
ATOM   1344  O   GLU   173      19.006  57.862   1.683  1.00 30.82           O  
ATOM   1345  CB  GLU   173      19.397  57.907   4.827  1.00 31.14           C  
ATOM   1346  CG  GLU   173      19.240  59.056   5.812  1.00 33.97           C  
ATOM   1347  CD  GLU   173      20.443  59.217   6.735  1.00 34.81           C  
ATOM   1348  OE1 GLU   173      21.599  58.949   6.305  1.00 37.15           O  
ATOM   1349  OE2 GLU   173      20.223  59.620   7.912  1.00 40.87           O  
ATOM   1350  N   ILE   174      18.937  55.779   2.550  1.00 29.59           N  
ATOM   1351  CA  ILE   174      19.664  55.177   1.444  1.00 28.75           C  
ATOM   1352  C   ILE   174      18.945  53.993   0.816  1.00 27.96           C  
ATOM   1353  O   ILE   174      19.270  53.604  -0.303  1.00 28.16           O  
ATOM   1354  CB  ILE   174      21.095  54.747   1.855  1.00 28.85           C  
ATOM   1355  CG1 ILE   174      21.047  53.714   2.996  1.00 28.35           C  
ATOM   1356  CG2 ILE   174      21.951  55.980   2.220  1.00 28.66           C  
ATOM   1357  CD1 ILE   174      22.382  53.050   3.268  1.00 28.84           C  
ATOM   1358  N   PHE   175      17.976  53.438   1.545  1.00 27.25           N  
ATOM   1359  CA  PHE   175      17.154  52.313   1.089  1.00 27.16           C  
ATOM   1360  C   PHE   175      15.712  52.748   0.844  1.00 27.96           C  
ATOM   1361  O   PHE   175      15.198  53.589   1.591  1.00 28.32           O  
ATOM   1362  CB  PHE   175      17.148  51.197   2.138  1.00 25.39           C  
ATOM   1363  CG  PHE   175      18.448  50.476   2.254  1.00 25.02           C  
ATOM   1364  CD1 PHE   175      19.000  49.831   1.144  1.00 22.62           C  
ATOM   1365  CD2 PHE   175      19.138  50.455   3.463  1.00 23.11           C  
ATOM   1366  CE1 PHE   175      20.233  49.168   1.253  1.00 22.60           C  
ATOM   1367  CE2 PHE   175      20.371  49.793   3.582  1.00 23.59           C  
ATOM   1368  CZ  PHE   175      20.907  49.145   2.472  1.00 22.09           C  
ATOM   1369  N   PRO   176      15.042  52.144  -0.159  1.00 28.92           N  
ATOM   1370  CA  PRO   176      13.659  52.519  -0.523  1.00 29.85           C  
ATOM   1371  C   PRO   176      12.546  52.111   0.472  1.00 30.23           C  
ATOM   1372  O   PRO   176      11.619  51.369   0.120  1.00 29.89           O  
ATOM   1373  CB  PRO   176      13.460  51.839  -1.879  1.00 29.67           C  
ATOM   1374  CG  PRO   176      14.364  50.658  -1.842  1.00 29.69           C  
ATOM   1375  CD  PRO   176      15.559  51.076  -1.037  1.00 29.70           C  
ATOM   1376  N   LEU   177      12.649  52.594   1.702  1.00 31.32           N  
ATOM   1377  CA  LEU   177      11.584  52.454   2.669  1.00 32.99           C  
ATOM   1378  C   LEU   177      10.558  53.566   2.434  1.00 34.01           C  
ATOM   1379  O   LEU   177       9.364  53.292   2.296  1.00 35.48           O  
ATOM   1380  CB  LEU   177      12.135  52.570   4.085  1.00 33.09           C  
ATOM   1381  CG  LEU   177      12.901  51.402   4.709  1.00 33.87           C  
ATOM   1382  CD1 LEU   177      13.626  51.910   5.929  1.00 35.29           C  
ATOM   1383  CD2 LEU   177      11.974  50.264   5.097  1.00 34.86           C  
ATOM   1384  N   ILE   191       3.939  49.630  13.570  1.00 39.51           N  
ATOM   1385  CA  ILE   191       3.880  50.674  14.609  1.00 39.47           C  
ATOM   1386  C   ILE   191       5.049  50.664  15.620  1.00 38.14           C  
ATOM   1387  O   ILE   191       5.580  51.740  15.924  1.00 37.87           O  
ATOM   1388  CB  ILE   191       2.462  50.789  15.328  1.00 39.29           C  
ATOM   1389  CG1 ILE   191       2.433  51.996  16.290  1.00 40.74           C  
ATOM   1390  CG2 ILE   191       2.038  49.463  16.001  1.00 40.80           C  
ATOM   1391  CD1 ILE   191       1.296  52.006  17.340  1.00 40.39           C  
ATOM   1392  N   PRO   192       5.482  49.463  16.109  1.00 37.22           N  
ATOM   1393  CA  PRO   192       6.645  49.479  17.014  1.00 35.79           C  
ATOM   1394  C   PRO   192       7.866  50.047  16.289  1.00 34.05           C  
ATOM   1395  O   PRO   192       8.092  49.699  15.126  1.00 34.00           O  
ATOM   1396  CB  PRO   192       6.894  47.986  17.313  1.00 35.96           C  
ATOM   1397  CG  PRO   192       5.638  47.306  17.007  1.00 36.88           C  
ATOM   1398  CD  PRO   192       5.026  48.079  15.861  1.00 37.57           C  
ATOM   1399  N   GLY   193       8.628  50.919  16.953  1.00 32.00           N  
ATOM   1400  CA  GLY   193       9.924  51.376  16.415  1.00 29.30           C  
ATOM   1401  C   GLY   193      10.830  50.158  16.267  1.00 26.86           C  
ATOM   1402  O   GLY   193      10.654  49.181  16.991  1.00 27.57           O  
ATOM   1403  N   LEU   194      11.785  50.196  15.335  1.00 25.02           N  
ATOM   1404  CA  LEU   194      12.666  49.029  15.119  1.00 22.05           C  
ATOM   1405  C   LEU   194      13.431  48.669  16.374  1.00 21.47           C  
ATOM   1406  O   LEU   194      14.097  49.519  16.968  1.00 20.52           O  
ATOM   1407  CB  LEU   194      13.667  49.268  13.981  1.00 22.03           C  
ATOM   1408  CG  LEU   194      13.115  49.448  12.567  1.00 21.92           C  
ATOM   1409  CD1 LEU   194      14.218  49.717  11.554  1.00 21.24           C  
ATOM   1410  CD2 LEU   194      12.268  48.216  12.181  1.00 19.60           C  
ATOM   1411  N   ALA   195      13.359  47.408  16.768  1.00 19.34           N  
ATOM   1412  CA  ALA   195      14.067  46.936  17.943  1.00 18.73           C  
ATOM   1413  C   ALA   195      15.570  46.801  17.690  1.00 18.18           C  
ATOM   1414  O   ALA   195      16.388  46.907  18.607  1.00 18.05           O  
ATOM   1415  CB  ALA   195      13.484  45.595  18.409  1.00 18.89           C  
ATOM   1416  N   ALA   196      15.917  46.565  16.437  1.00 16.89           N  
ATOM   1417  CA  ALA   196      17.301  46.288  16.039  1.00 15.01           C  
ATOM   1418  C   ALA   196      17.445  46.486  14.517  1.00 14.33           C  
ATOM   1419  O   ALA   196      16.454  46.568  13.795  1.00 13.96           O  
ATOM   1420  CB  ALA   196      17.727  44.886  16.457  1.00 15.92           C  
ATOM   1421  N   SER   197      18.707  46.610  14.069  1.00 13.64           N  
ATOM   1422  CA  SER   197      19.075  46.758  12.665  1.00 13.45           C  
ATOM   1423  C   SER   197      20.336  45.904  12.511  1.00 13.46           C  
ATOM   1424  O   SER   197      21.446  46.289  12.920  1.00 13.37           O  
ATOM   1425  CB  SER   197      19.358  48.221  12.305  1.00 13.58           C  
ATOM   1426  OG  SER   197      19.622  48.367  10.900  1.00 14.68           O  
ATOM   1427  N   VAL   198      20.138  44.726  11.921  1.00 13.15           N  
ATOM   1428  CA  VAL   198      21.175  43.684  11.893  1.00 13.08           C  
ATOM   1429  C   VAL   198      21.837  43.708  10.520  1.00 13.08           C  
ATOM   1430  O   VAL   198      21.150  43.812   9.488  1.00 13.79           O  
ATOM   1431  CB  VAL   198      20.539  42.297  12.111  1.00 12.94           C  
ATOM   1432  CG1 VAL   198      21.583  41.206  11.969  1.00 13.89           C  
ATOM   1433  CG2 VAL   198      19.785  42.182  13.457  1.00 12.57           C  
ATOM   1434  N   LEU   199      23.165  43.640  10.519  1.00 12.11           N  
ATOM   1435  CA  LEU   199      23.944  43.552   9.280  1.00 11.62           C  
ATOM   1436  C   LEU   199      24.484  42.142   9.161  1.00 11.23           C  
ATOM   1437  O   LEU   199      25.156  41.672  10.058  1.00 11.71           O  
ATOM   1438  CB  LEU   199      25.143  44.520   9.306  1.00 12.31           C  
ATOM   1439  CG  LEU   199      26.104  44.482   8.086  1.00 11.66           C  
ATOM   1440  CD1 LEU   199      25.454  44.717   6.697  1.00 13.39           C  
ATOM   1441  CD2 LEU   199      27.300  45.506   8.317  1.00 12.95           C  
ATOM   1442  N   VAL   200      24.258  41.507   8.006  1.00 10.78           N  
ATOM   1443  CA  VAL   200      24.776  40.120   7.811  1.00  8.76           C  
ATOM   1444  C   VAL   200      25.585  40.101   6.520  1.00  9.38           C  
ATOM   1445  O   VAL   200      25.108  40.550   5.475  1.00 10.10           O  
ATOM   1446  CB  VAL   200      23.609  39.072   7.698  1.00  8.66           C  
ATOM   1447  CG1 VAL   200      24.164  37.703   7.228  1.00  8.33           C  
ATOM   1448  CG2 VAL   200      22.846  38.947   9.017  1.00 10.38           C  
ATOM   1449  N   VAL   201      26.812  39.596   6.594  1.00  9.43           N  
ATOM   1450  CA  VAL   201      27.621  39.452   5.399  1.00  8.97           C  
ATOM   1451  C   VAL   201      27.796  37.959   5.116  1.00  9.62           C  
ATOM   1452  O   VAL   201      28.275  37.211   5.968  1.00  7.86           O  
ATOM   1453  CB  VAL   201      28.996  40.116   5.547  1.00  9.59           C  
ATOM   1454  CG1 VAL   201      29.874  39.759   4.306  1.00  9.68           C  
ATOM   1455  CG2 VAL   201      28.800  41.646   5.700  1.00 11.12           C  
ATOM   1456  N   SER   202      27.426  37.544   3.899  1.00  9.31           N  
ATOM   1457  CA  SER   202      27.409  36.101   3.605  1.00  8.95           C  
ATOM   1458  C   SER   202      27.682  35.867   2.128  1.00  9.16           C  
ATOM   1459  O   SER   202      28.438  36.636   1.488  1.00 10.38           O  
ATOM   1460  CB  SER   202      26.058  35.492   4.096  1.00  8.93           C  
ATOM   1461  OG  SER   202      25.903  34.092   3.831  1.00 10.01           O  
ATOM   1462  N   HIS   203      27.061  34.814   1.570  1.00 10.13           N  
ATOM   1463  CA  HIS   203      27.535  34.249   0.316  1.00  9.52           C  
ATOM   1464  C   HIS   203      26.367  34.086  -0.635  1.00 10.30           C  
ATOM   1465  O   HIS   203      25.216  33.917  -0.171  1.00  9.32           O  
ATOM   1466  CB  HIS   203      28.166  32.852   0.589  1.00  9.59           C  
ATOM   1467  CG  HIS   203      29.341  32.879   1.531  1.00  7.84           C  
ATOM   1468  ND1 HIS   203      30.649  32.959   1.093  1.00  9.11           N  
ATOM   1469  CD2 HIS   203      29.401  32.780   2.882  1.00 10.71           C  
ATOM   1470  CE1 HIS   203      31.465  32.895   2.139  1.00  9.53           C  
ATOM   1471  NE2 HIS   203      30.731  32.788   3.237  1.00  8.48           N  
ATOM   1472  N   GLY   204      26.642  34.041  -1.948  1.00  9.69           N  
ATOM   1473  CA  GLY   204      25.503  34.073  -2.911  1.00  9.75           C  
ATOM   1474  C   GLY   204      24.522  32.906  -2.808  1.00  9.54           C  
ATOM   1475  O   GLY   204      23.329  33.126  -2.661  1.00  9.85           O  
ATOM   1476  N   ALA   205      25.014  31.678  -2.814  1.00  9.62           N  
ATOM   1477  CA  ALA   205      24.075  30.533  -2.842  1.00  8.60           C  
ATOM   1478  C   ALA   205      23.305  30.459  -1.523  1.00  9.84           C  
ATOM   1479  O   ALA   205      22.099  30.182  -1.506  1.00  9.20           O  
ATOM   1480  CB  ALA   205      24.798  29.203  -3.200  1.00 11.04           C  
ATOM   1481  N   TYR   206      24.010  30.687  -0.419  1.00  8.72           N  
ATOM   1482  CA  TYR   206      23.350  30.676   0.884  1.00  8.73           C  
ATOM   1483  C   TYR   206      22.268  31.735   0.959  1.00  8.56           C  
ATOM   1484  O   TYR   206      21.148  31.498   1.465  1.00  8.88           O  
ATOM   1485  CB  TYR   206      24.384  30.938   1.962  1.00  7.66           C  
ATOM   1486  CG  TYR   206      23.785  30.956   3.365  1.00  9.51           C  
ATOM   1487  CD1 TYR   206      23.564  29.772   4.063  1.00  7.24           C  
ATOM   1488  CD2 TYR   206      23.374  32.155   3.961  1.00 10.79           C  
ATOM   1489  CE1 TYR   206      23.034  29.805   5.359  1.00 10.51           C  
ATOM   1490  CE2 TYR   206      22.854  32.198   5.246  1.00 11.50           C  
ATOM   1491  CZ  TYR   206      22.699  31.025   5.941  1.00 10.75           C  
ATOM   1492  OH  TYR   206      22.157  31.087   7.208  1.00 10.83           O  
ATOM   1493  N   MET   207      22.618  32.922   0.472  1.00  7.25           N  
ATOM   1494  CA  MET   207      21.640  34.024   0.460  1.00  9.04           C  
ATOM   1495  C   MET   207      20.403  33.663  -0.376  1.00  8.99           C  
ATOM   1496  O   MET   207      19.240  33.915   0.050  1.00 11.12           O  
ATOM   1497  CB  MET   207      22.287  35.307   0.016  1.00  8.31           C  
ATOM   1498  CG  MET   207      23.162  35.904   1.145  1.00  8.70           C  
ATOM   1499  SD  MET   207      24.421  37.241   0.441  1.00 11.06          SE  
ATOM   1500  CE  MET   207      23.098  38.585  -0.024  1.00 13.46           C  
ATOM   1501  N   ARG   208      20.636  33.083  -1.535  1.00 10.61           N  
ATOM   1502  CA  ARG   208      19.503  32.741  -2.425  1.00  9.90           C  
ATOM   1503  C   ARG   208      18.536  31.785  -1.713  1.00 11.11           C  
ATOM   1504  O   ARG   208      17.295  31.938  -1.782  1.00 11.37           O  
ATOM   1505  CB  ARG   208      20.015  32.179  -3.743  1.00 12.27           C  
ATOM   1506  CG  ARG   208      20.585  33.343  -4.610  1.00 15.78           C  
ATOM   1507  CD  ARG   208      20.941  32.873  -6.042  1.00 16.42           C  
ATOM   1508  NE  ARG   208      22.040  31.918  -6.103  1.00 17.26           N  
ATOM   1509  CZ  ARG   208      23.330  32.252  -6.152  1.00 16.45           C  
ATOM   1510  NH1 ARG   208      23.690  33.522  -6.102  1.00 17.32           N  
ATOM   1511  NH2 ARG   208      24.268  31.307  -6.225  1.00 17.91           N  
ATOM   1512  N   SER   209      19.091  30.845  -0.973  1.00  9.56           N  
ATOM   1513  CA  SER   209      18.271  29.853  -0.265  1.00 10.25           C  
ATOM   1514  C   SER   209      17.548  30.490   0.896  1.00 10.33           C  
ATOM   1515  O   SER   209      16.381  30.164   1.185  1.00 11.28           O  
ATOM   1516  CB  SER   209      19.144  28.705   0.232  1.00 11.33           C  
ATOM   1517  OG  SER   209      19.516  27.853  -0.832  1.00 13.34           O  
ATOM   1518  N   LEU   210      18.242  31.401   1.590  1.00 10.38           N  
ATOM   1519  CA  LEU   210      17.569  32.130   2.698  1.00  8.87           C  
ATOM   1520  C   LEU   210      16.428  32.977   2.120  1.00  9.51           C  
ATOM   1521  O   LEU   210      15.323  32.988   2.670  1.00  9.92           O  
ATOM   1522  CB  LEU   210      18.623  32.968   3.434  1.00  9.32           C  
ATOM   1523  CG  LEU   210      18.048  33.840   4.556  1.00  9.09           C  
ATOM   1524  CD1 LEU   210      17.590  32.951   5.718  1.00 10.71           C  
ATOM   1525  CD2 LEU   210      19.140  34.878   5.001  1.00 10.89           C  
ATOM   1526  N   PHE   211      16.667  33.630   0.980  1.00  9.30           N  
ATOM   1527  CA  PHE   211      15.672  34.526   0.423  1.00 10.50           C  
ATOM   1528  C   PHE   211      14.498  33.663  -0.069  1.00  9.99           C  
ATOM   1529  O   PHE   211      13.333  34.056   0.074  1.00  9.59           O  
ATOM   1530  CB  PHE   211      16.256  35.373  -0.710  1.00  9.65           C  
ATOM   1531  CG  PHE   211      17.358  36.303  -0.267  1.00 10.52           C  
ATOM   1532  CD1 PHE   211      17.539  36.610   1.083  1.00 11.62           C  
ATOM   1533  CD2 PHE   211      18.194  36.871  -1.203  1.00 14.73           C  
ATOM   1534  CE1 PHE   211      18.576  37.453   1.488  1.00 15.33           C  
ATOM   1535  CE2 PHE   211      19.217  37.745  -0.808  1.00 15.53           C  
ATOM   1536  CZ  PHE   211      19.387  38.034   0.550  1.00 13.13           C  
ATOM   1537  N   ASP   212      14.806  32.486  -0.590  1.00 10.28           N  
ATOM   1538  CA  ASP   212      13.733  31.557  -0.956  1.00 10.45           C  
ATOM   1539  C   ASP   212      12.895  31.125   0.242  1.00 10.32           C  
ATOM   1540  O   ASP   212      11.673  31.044   0.154  1.00  9.93           O  
ATOM   1541  CB  ASP   212      14.257  30.322  -1.670  1.00 11.35           C  
ATOM   1542  CG  ASP   212      13.113  29.499  -2.281  1.00 14.19           C  
ATOM   1543  OD1 ASP   212      12.306  30.036  -3.060  1.00 18.34           O  
ATOM   1544  OD2 ASP   212      12.958  28.348  -1.923  1.00 19.95           O  
ATOM   1545  N   TYR   213      13.533  30.877   1.375  1.00  9.34           N  
ATOM   1546  CA  TYR   213      12.773  30.636   2.621  1.00  9.28           C  
ATOM   1547  C   TYR   213      11.844  31.819   2.913  1.00 10.01           C  
ATOM   1548  O   TYR   213      10.654  31.633   3.166  1.00  9.71           O  
ATOM   1549  CB  TYR   213      13.741  30.430   3.765  1.00 10.44           C  
ATOM   1550  CG  TYR   213      13.072  30.316   5.104  1.00  9.68           C  
ATOM   1551  CD1 TYR   213      12.126  29.302   5.346  1.00 11.69           C  
ATOM   1552  CD2 TYR   213      13.423  31.187   6.162  1.00 11.29           C  
ATOM   1553  CE1 TYR   213      11.512  29.192   6.584  1.00 14.86           C  
ATOM   1554  CE2 TYR   213      12.818  31.065   7.378  1.00 12.39           C  
ATOM   1555  CZ  TYR   213      11.875  30.086   7.587  1.00 15.18           C  
ATOM   1556  OH  TYR   213      11.328  29.987   8.860  1.00 18.19           O  
ATOM   1557  N   PHE   214      12.362  33.044   2.825  1.00  9.20           N  
ATOM   1558  CA  PHE   214      11.530  34.208   3.131  1.00  9.42           C  
ATOM   1559  C   PHE   214      10.352  34.318   2.171  1.00 10.67           C  
ATOM   1560  O   PHE   214       9.267  34.633   2.596  1.00 10.12           O  
ATOM   1561  CB  PHE   214      12.333  35.500   3.002  1.00  9.95           C  
ATOM   1562  CG  PHE   214      13.394  35.690   4.060  1.00  8.70           C  
ATOM   1563  CD1 PHE   214      13.403  34.963   5.244  1.00  8.58           C  
ATOM   1564  CD2 PHE   214      14.387  36.661   3.852  1.00 10.59           C  
ATOM   1565  CE1 PHE   214      14.396  35.198   6.210  1.00 10.02           C  
ATOM   1566  CE2 PHE   214      15.386  36.898   4.808  1.00 10.61           C  
ATOM   1567  CZ  PHE   214      15.385  36.182   5.976  1.00 11.62           C  
ATOM   1568  N   LEU   215      10.583  34.056   0.879  1.00 10.25           N  
ATOM   1569  CA  LEU   215       9.506  34.231  -0.114  1.00 10.38           C  
ATOM   1570  C   LEU   215       8.566  33.038  -0.161  1.00 10.77           C  
ATOM   1571  O   LEU   215       7.339  33.174   0.017  1.00 11.28           O  
ATOM   1572  CB  LEU   215      10.121  34.485  -1.488  1.00 10.63           C  
ATOM   1573  CG  LEU   215       9.069  34.627  -2.612  1.00  9.43           C  
ATOM   1574  CD1 LEU   215       8.138  35.785  -2.313  1.00 12.74           C  
ATOM   1575  CD2 LEU   215       9.785  34.860  -3.967  1.00 12.27           C  
ATOM   1576  N   THR   216       9.131  31.865  -0.398  1.00 11.00           N  
ATOM   1577  CA  THR   216       8.307  30.671  -0.567  1.00 12.81           C  
ATOM   1578  C   THR   216       7.626  30.239   0.730  1.00 12.62           C  
ATOM   1579  O   THR   216       6.467  29.852   0.720  1.00 13.60           O  
ATOM   1580  CB  THR   216       9.152  29.534  -1.189  1.00 12.36           C  
ATOM   1581  OG1 THR   216       9.636  29.972  -2.460  1.00 14.69           O  
ATOM   1582  CG2 THR   216       8.319  28.262  -1.368  1.00 14.27           C  
ATOM   1583  N   ASP   217       8.359  30.285   1.847  1.00 13.20           N  
ATOM   1584  CA  ASP   217       7.882  29.746   3.104  1.00 12.92           C  
ATOM   1585  C   ASP   217       7.256  30.784   4.037  1.00 13.22           C  
ATOM   1586  O   ASP   217       6.143  30.582   4.550  1.00 15.48           O  
ATOM   1587  CB  ASP   217       9.011  28.934   3.761  1.00 13.79           C  
ATOM   1588  CG  ASP   217       9.519  27.832   2.822  1.00 16.22           C  
ATOM   1589  OD1 ASP   217       8.673  27.023   2.386  1.00 18.83           O  
ATOM   1590  OD2 ASP   217      10.702  27.797   2.466  1.00 15.17           O  
ATOM   1591  N   LEU   218       7.916  31.930   4.212  1.00 10.94           N  
ATOM   1592  CA  LEU   218       7.348  32.985   5.050  1.00 11.53           C  
ATOM   1593  C   LEU   218       6.392  33.937   4.297  1.00 11.62           C  
ATOM   1594  O   LEU   218       5.723  34.808   4.914  1.00 12.88           O  
ATOM   1595  CB  LEU   218       8.481  33.745   5.769  1.00 11.54           C  
ATOM   1596  CG  LEU   218       9.332  32.906   6.752  1.00 12.78           C  
ATOM   1597  CD1 LEU   218      10.272  33.818   7.514  1.00 12.03           C  
ATOM   1598  CD2 LEU   218       8.443  32.131   7.731  1.00 15.13           C  
ATOM   1599  N   LYS   219       6.339  33.766   2.979  1.00 11.24           N  
ATOM   1600  CA  LYS   219       5.419  34.528   2.134  1.00 12.22           C  
ATOM   1601  C   LYS   219       5.700  36.040   2.224  1.00 12.08           C  
ATOM   1602  O   LYS   219       4.752  36.851   2.263  1.00 12.49           O  
ATOM   1603  CB  LYS   219       3.949  34.225   2.515  1.00 14.45           C  
ATOM   1604  CG  LYS   219       3.542  32.732   2.601  1.00 17.85           C  
ATOM   1605  CD  LYS   219       3.793  31.984   1.282  1.00 19.35           C  
ATOM   1606  CE  LYS   219       3.347  30.499   1.371  1.00 22.17           C  
ATOM   1607  NZ  LYS   219       3.656  29.950   2.699  1.00 27.12           N  
ATOM   1608  N   CYS   220       7.000  36.404   2.185  1.00 11.26           N  
ATOM   1609  CA  CYS   220       7.395  37.824   2.261  0.80 11.17           C  
ATOM   1611  C   CYS   220       6.842  38.615   1.085  1.00 11.75           C  
ATOM   1612  O   CYS   220       6.593  38.082  -0.005  1.00 11.77           O  
ATOM   1613  CB  CYS   220       8.907  38.003   2.340  0.80 11.41           C  
ATOM   1615  SG  CYS   220       9.772  37.747   0.774  0.80 12.73           S  
ATOM   1617  N   SER   221       6.585  39.897   1.334  1.00 12.01           N  
ATOM   1618  CA  SER   221       6.150  40.778   0.265  1.00 13.09           C  
ATOM   1619  C   SER   221       7.377  41.226  -0.550  1.00 14.04           C  
ATOM   1620  O   SER   221       8.492  41.258  -0.029  1.00 14.60           O  
ATOM   1621  CB  SER   221       5.389  41.968   0.837  1.00 13.77           C  
ATOM   1622  OG  SER   221       6.180  42.739   1.729  1.00 13.35           O  
ATOM   1623  N   LEU   222       7.165  41.555  -1.822  1.00 15.54           N  
ATOM   1624  CA  LEU   222       8.265  41.947  -2.720  1.00 17.54           C  
ATOM   1625  C   LEU   222       7.970  43.329  -3.322  1.00 19.60           C  
ATOM   1626  O   LEU   222       6.825  43.619  -3.649  1.00 20.17           O  
ATOM   1627  CB  LEU   222       8.395  40.946  -3.869  1.00 17.61           C  
ATOM   1628  CG  LEU   222       8.783  39.513  -3.568  1.00 18.69           C  
ATOM   1629  CD1 LEU   222       8.813  38.720  -4.849  1.00 19.94           C  
ATOM   1630  CD2 LEU   222      10.141  39.432  -2.857  1.00 20.71           C  
ATOM   1631  N   PRO   223       9.006  44.170  -3.499  1.00 22.05           N  
ATOM   1632  CA  PRO   223       8.735  45.432  -4.199  1.00 23.24           C  
ATOM   1633  C   PRO   223       8.219  45.147  -5.644  1.00 24.73           C  
ATOM   1634  O   PRO   223       8.453  44.071  -6.172  1.00 23.36           O  
ATOM   1635  CB  PRO   223      10.102  46.129  -4.224  1.00 22.98           C  
ATOM   1636  CG  PRO   223      10.992  45.386  -3.256  1.00 23.58           C  
ATOM   1637  CD  PRO   223      10.414  43.998  -3.114  1.00 22.06           C  
ATOM   1638  N   ALA   224       7.538  46.118  -6.255  1.00 26.52           N  
ATOM   1639  CA  ALA   224       7.013  45.993  -7.628  1.00 27.20           C  
ATOM   1640  C   ALA   224       8.122  45.798  -8.679  1.00 27.32           C  
ATOM   1641  O   ALA   224       7.891  45.228  -9.744  1.00 27.65           O  
ATOM   1642  CB  ALA   224       6.187  47.210  -7.969  1.00 27.94           C  
ATOM   1643  N   THR   225       9.320  46.257  -8.349  1.00 27.06           N  
ATOM   1644  CA  THR   225      10.485  46.172  -9.227  1.00 27.45           C  
ATOM   1645  C   THR   225      11.260  44.855  -9.100  1.00 26.00           C  
ATOM   1646  O   THR   225      12.251  44.629  -9.804  1.00 26.66           O  
ATOM   1647  CB  THR   225      11.428  47.339  -8.900  1.00 28.46           C  
ATOM   1648  OG1 THR   225      11.377  47.607  -7.486  1.00 31.78           O  
ATOM   1649  CG2 THR   225      10.985  48.581  -9.650  1.00 30.14           C  
ATOM   1650  N   LEU   226      10.828  43.975  -8.199  1.00 23.06           N  
ATOM   1651  CA  LEU   226      11.565  42.749  -7.951  0.70 22.35           C  
ATOM   1653  C   LEU   226      10.794  41.516  -8.397  1.00 22.73           C  
ATOM   1654  O   LEU   226       9.766  41.165  -7.805  1.00 23.06           O  
ATOM   1655  CB  LEU   226      11.915  42.621  -6.462  0.70 22.21           C  
ATOM   1657  CG  LEU   226      12.645  41.357  -6.011  0.70 21.36           C  
ATOM   1659  CD1 LEU   226      14.027  41.305  -6.595  0.70 19.42           C  
ATOM   1661  CD2 LEU   226      12.727  41.337  -4.500  0.70 21.10           C  
ATOM   1663  N   SER   227      11.318  40.850  -9.417  1.00 21.25           N  
ATOM   1664  CA  SER   227      10.727  39.614  -9.908  1.00 20.51           C  
ATOM   1665  C   SER   227      11.064  38.461  -8.957  1.00 20.26           C  
ATOM   1666  O   SER   227      12.080  38.498  -8.239  1.00 19.13           O  
ATOM   1667  CB  SER   227      11.282  39.296 -11.304  1.00 20.26           C  
ATOM   1668  OG  SER   227      12.667  39.041 -11.219  1.00 20.10           O  
ATOM   1669  N   ARG   228      10.236  37.418  -8.960  1.00 20.07           N  
ATOM   1670  CA  ARG   228      10.622  36.175  -8.282  1.00 19.92           C  
ATOM   1671  C   ARG   228      11.911  35.579  -8.856  1.00 20.94           C  
ATOM   1672  O   ARG   228      12.730  35.000  -8.118  1.00 20.58           O  
ATOM   1673  CB  ARG   228       9.483  35.143  -8.344  1.00 19.92           C  
ATOM   1674  CG  ARG   228       8.135  35.696  -7.878  1.00 20.51           C  
ATOM   1675  CD  ARG   228       7.076  34.614  -7.959  1.00 21.49           C  
ATOM   1676  NE  ARG   228       7.084  33.695  -6.813  1.00 21.75           N  
ATOM   1677  CZ  ARG   228       6.488  33.960  -5.648  1.00 21.92           C  
ATOM   1678  NH1 ARG   228       6.549  33.053  -4.678  1.00 21.92           N  
ATOM   1679  NH2 ARG   228       5.858  35.129  -5.441  1.00 19.45           N  
ATOM   1680  N   SER   229      12.135  35.746 -10.171  1.00 20.25           N  
ATOM   1681  CA  SER   229      13.321  35.200 -10.798  1.00 20.93           C  
ATOM   1682  C   SER   229      14.635  35.825 -10.306  1.00 20.97           C  
ATOM   1683  O   SER   229      15.655  35.134 -10.249  1.00 20.98           O  
ATOM   1684  CB  SER   229      13.227  35.330 -12.319  1.00 21.06           C  
ATOM   1685  OG  SER   229      12.191  34.481 -12.787  1.00 21.93           O  
ATOM   1686  N   GLU   230      14.582  37.105  -9.951  1.00 21.77           N  
ATOM   1687  CA  GLU   230      15.745  37.842  -9.443  1.00 23.44           C  
ATOM   1688  C   GLU   230      16.241  37.121  -8.208  1.00 24.30           C  
ATOM   1689  O   GLU   230      17.427  36.822  -8.038  1.00 23.11           O  
ATOM   1690  CB  GLU   230      15.327  39.232  -8.986  1.00 24.88           C  
ATOM   1691  CG  GLU   230      16.446  39.964  -8.211  1.00 25.43           C  
ATOM   1692  CD  GLU   230      17.011  41.126  -8.957  1.00 26.89           C  
ATOM   1693  OE1 GLU   230      16.267  41.704  -9.768  1.00 24.08           O  
ATOM   1694  OE2 GLU   230      18.173  41.500  -8.684  1.00 27.40           O  
ATOM   1695  N   LEU   231      15.273  36.842  -7.355  1.00 24.65           N  
ATOM   1696  CA  LEU   231      15.505  36.472  -5.987  1.00 27.37           C  
ATOM   1697  C   LEU   231      16.227  35.128  -5.920  1.00 29.19           C  
ATOM   1698  O   LEU   231      17.116  34.926  -5.074  1.00 30.79           O  
ATOM   1699  CB  LEU   231      14.133  36.437  -5.258  1.00 26.15           C  
ATOM   1700  CG  LEU   231      14.103  35.965  -3.808  1.00 25.48           C  
ATOM   1701  CD1 LEU   231      13.097  36.817  -3.039  1.00 24.11           C  
ATOM   1702  CD2 LEU   231      13.722  34.484  -3.709  1.00 24.46           C  
ATOM   1703  N   MET   232      15.892  34.259  -6.869  1.00 31.30           N  
ATOM   1704  CA  MET   232      16.273  32.841  -6.802  0.50 32.60           C  
ATOM   1706  C   MET   232      17.579  32.519  -7.520  1.00 32.66           C  
ATOM   1707  O   MET   232      18.270  31.545  -7.156  1.00 33.58           O  
ATOM   1708  CB  MET   232      15.130  31.960  -7.316  0.50 32.48           C  
ATOM   1710  CG  MET   232      13.833  32.197  -6.556  0.50 33.23           C  
ATOM   1712  SD  MET   232      12.288  31.294  -7.301  0.50 34.88          SE  
ATOM   1714  CE  MET   232      12.824  29.439  -6.973  0.50 35.68           C  
ATOM   1716  N   SER   233      17.902  33.327  -8.515  1.00 32.34           N  
ATOM   1717  CA  SER   233      19.173  33.283  -9.197  1.00 32.73           C  
ATOM   1718  C   SER   233      19.526  34.735  -9.260  1.00 32.27           C  
ATOM   1719  O   SER   233      18.661  35.516  -9.653  1.00 33.00           O  
ATOM   1720  CB  SER   233      19.010  32.787 -10.617  1.00 33.04           C  
ATOM   1721  OG  SER   233      18.096  33.619 -11.336  1.00 37.07           O  
ATOM   1722  N   VAL   234      20.759  35.092  -8.861  1.00 30.11           N  
ATOM   1723  CA  VAL   234      21.353  36.417  -9.039  1.00 29.06           C  
ATOM   1724  C   VAL   234      21.759  36.972  -7.668  1.00 27.42           C  
ATOM   1725  O   VAL   234      20.861  37.292  -6.847  1.00 27.92           O  
ATOM   1726  CB  VAL   234      20.401  37.472  -9.761  1.00 30.12           C  
ATOM   1727  CG1 VAL   234      21.032  38.881  -9.755  1.00 32.18           C  
ATOM   1728  CG2 VAL   234      20.084  37.050 -11.177  1.00 30.59           C  
ATOM   1729  N   THR   235      23.084  37.044  -7.414  1.00 24.54           N  
ATOM   1730  CA  THR   235      23.611  37.828  -6.274  1.00 21.55           C  
ATOM   1731  C   THR   235      24.970  38.463  -6.580  1.00 20.36           C  
ATOM   1732  O   THR   235      25.994  37.787  -6.534  1.00 20.67           O  
ATOM   1733  CB  THR   235      23.793  36.967  -4.996  1.00 20.99           C  
ATOM   1734  OG1 THR   235      22.701  36.060  -4.860  1.00 21.81           O  
ATOM   1735  CG2 THR   235      23.909  37.893  -3.732  1.00 19.10           C  
ATOM   1736  N   PRO   236      24.994  39.767  -6.880  1.00 18.67           N  
ATOM   1737  CA  PRO   236      26.263  40.458  -7.209  1.00 17.30           C  
ATOM   1738  C   PRO   236      27.175  40.544  -5.981  1.00 16.11           C  
ATOM   1739  O   PRO   236      26.660  40.543  -4.861  1.00 15.24           O  
ATOM   1740  CB  PRO   236      25.813  41.883  -7.586  1.00 18.40           C  
ATOM   1741  CG  PRO   236      24.320  41.835  -7.742  1.00 19.11           C  
ATOM   1742  CD  PRO   236      23.824  40.662  -6.942  1.00 18.91           C  
ATOM   1743  N   ASN   237      28.495  40.623  -6.184  1.00 15.37           N  
ATOM   1744  CA  ASN   237      29.410  40.915  -5.067  1.00 14.60           C  
ATOM   1745  C   ASN   237      29.053  42.256  -4.406  1.00 13.70           C  
ATOM   1746  O   ASN   237      28.875  43.267  -5.093  1.00 15.31           O  
ATOM   1747  CB  ASN   237      30.871  40.917  -5.503  1.00 14.73           C  
ATOM   1748  CG  ASN   237      31.377  39.526  -5.865  1.00 15.52           C  
ATOM   1749  OD1 ASN   237      31.642  39.260  -7.037  1.00 19.53           O  
ATOM   1750  ND2 ASN   237      31.449  38.610  -4.870  1.00 14.35           N  
ATOM   1751  N   THR   238      28.974  42.244  -3.083  1.00 12.97           N  
ATOM   1752  CA  THR   238      28.441  43.358  -2.231  1.00 12.00           C  
ATOM   1753  C   THR   238      27.022  43.852  -2.533  1.00 13.36           C  
ATOM   1754  O   THR   238      26.633  44.940  -2.108  1.00 13.65           O  
ATOM   1755  CB  THR   238      29.436  44.556  -2.091  1.00 12.82           C  
ATOM   1756  OG1 THR   238      29.545  45.243  -3.343  1.00 14.76           O  
ATOM   1757  CG2 THR   238      30.807  44.035  -1.598  1.00 13.59           C  
ATOM   1758  N   GLY   239      26.268  43.034  -3.271  1.00 13.24           N  
ATOM   1759  CA  GLY   239      24.830  43.263  -3.519  1.00 13.93           C  
ATOM   1760  C   GLY   239      24.107  43.245  -2.182  1.00 13.74           C  
ATOM   1761  O   GLY   239      24.339  42.340  -1.368  1.00 14.21           O  
ATOM   1762  N   MET   240      23.242  44.239  -1.966  1.00 12.78           N  
ATOM   1763  CA  MET   240      22.584  44.447  -0.685  1.00 13.58           C  
ATOM   1764  C   MET   240      21.069  44.208  -0.750  1.00 13.24           C  
ATOM   1765  O   MET   240      20.395  44.680  -1.660  1.00 13.69           O  
ATOM   1766  CB  MET   240      22.806  45.896  -0.220  1.00 15.11           C  
ATOM   1767  CG  MET   240      24.272  46.251  -0.086  1.00 15.12           C  
ATOM   1768  SD  MET   240      24.362  48.070   0.611  1.00 18.77          SE  
ATOM   1769  CE  MET   240      26.264  48.246   0.501  1.00 18.08           C  
ATOM   1770  N   SER   241      20.549  43.509   0.255  1.00 13.14           N  
ATOM   1771  CA  SER   241      19.119  43.255   0.356  0.70 12.52           C  
ATOM   1773  C   SER   241      18.692  43.676   1.746  1.00 13.29           C  
ATOM   1774  O   SER   241      19.403  43.434   2.713  1.00 14.20           O  
ATOM   1775  CB  SER   241      18.850  41.760   0.131  0.70 12.45           C  
ATOM   1777  OG  SER   241      19.292  41.387  -1.161  0.70 10.80           O  
ATOM   1779  N   LEU   242      17.529  44.328   1.846  1.00 12.23           N  
ATOM   1780  CA  LEU   242      16.979  44.770   3.117  1.00 12.90           C  
ATOM   1781  C   LEU   242      15.586  44.170   3.282  1.00 11.83           C  
ATOM   1782  O   LEU   242      14.755  44.272   2.345  1.00 12.05           O  
ATOM   1783  CB  LEU   242      16.875  46.318   3.160  1.00 13.04           C  
ATOM   1784  CG  LEU   242      16.191  46.884   4.429  1.00 15.99           C  
ATOM   1785  CD1 LEU   242      16.974  46.593   5.720  1.00 15.29           C  
ATOM   1786  CD2 LEU   242      16.016  48.428   4.269  1.00 14.21           C  
ATOM   1787  N   PHE   243      15.361  43.622   4.482  1.00 11.67           N  
ATOM   1788  CA  PHE   243      14.080  43.045   4.930  1.00 12.76           C  
ATOM   1789  C   PHE   243      13.642  43.680   6.256  1.00 12.46           C  
ATOM   1790  O   PHE   243      14.480  43.930   7.155  1.00 12.87           O  
ATOM   1791  CB  PHE   243      14.219  41.532   5.128  1.00 12.81           C  
ATOM   1792  CG  PHE   243      14.701  40.822   3.892  1.00 13.64           C  
ATOM   1793  CD1 PHE   243      13.810  40.355   2.948  1.00 14.82           C  
ATOM   1794  CD2 PHE   243      16.068  40.676   3.672  1.00 15.31           C  
ATOM   1795  CE1 PHE   243      14.283  39.710   1.748  1.00 14.92           C  
ATOM   1796  CE2 PHE   243      16.548  40.066   2.540  1.00 12.18           C  
ATOM   1797  CZ  PHE   243      15.672  39.588   1.565  1.00 10.84           C  
ATOM   1798  N   ILE   244      12.335  43.896   6.398  1.00 12.62           N  
ATOM   1799  CA  ILE   244      11.789  44.211   7.698  1.00 12.69           C  
ATOM   1800  C   ILE   244      11.060  42.959   8.227  1.00 11.90           C  
ATOM   1801  O   ILE   244      10.181  42.396   7.558  1.00 12.22           O  
ATOM   1802  CB  ILE   244      10.846  45.460   7.683  1.00 13.59           C  
ATOM   1803  CG1 ILE   244      11.553  46.710   7.095  1.00 16.20           C  
ATOM   1804  CG2 ILE   244      10.370  45.738   9.092  1.00 14.97           C  
ATOM   1805  CD1 ILE   244      12.795  47.147   7.862  1.00 19.67           C  
ATOM   1806  N   ILE   245      11.453  42.509   9.412  1.00 11.60           N  
ATOM   1807  CA  ILE   245      10.858  41.320  10.032  1.00 11.68           C  
ATOM   1808  C   ILE   245       9.879  41.784  11.105  1.00 13.67           C  
ATOM   1809  O   ILE   245      10.246  42.595  11.946  1.00 13.43           O  
ATOM   1810  CB  ILE   245      11.944  40.445  10.706  1.00 11.82           C  
ATOM   1811  CG1 ILE   245      13.184  40.245   9.781  1.00 12.57           C  
ATOM   1812  CG2 ILE   245      11.358  39.134  11.191  1.00 13.22           C  
ATOM   1813  CD1 ILE   245      12.849  39.659   8.365  1.00 14.11           C  
ATOM   1814  N   ASN   246       8.674  41.220  11.116  1.00 12.98           N  
ATOM   1815  CA  ASN   246       7.570  41.742  11.953  1.00 14.16           C  
ATOM   1816  C   ASN   246       6.988  40.612  12.804  1.00 14.34           C  
ATOM   1817  O   ASN   246       6.585  39.556  12.275  1.00 13.56           O  
ATOM   1818  CB  ASN   246       6.425  42.270  11.045  1.00 15.39           C  
ATOM   1819  CG  ASN   246       6.871  43.351  10.067  1.00 18.81           C  
ATOM   1820  OD1 ASN   246       7.381  43.092   8.938  1.00 23.58           O  
ATOM   1821  ND2 ASN   246       6.644  44.593  10.475  1.00 22.31           N  
ATOM   1822  N   PHE   247       6.923  40.822  14.127  1.00 15.67           N  
ATOM   1823  CA  PHE   247       6.282  39.853  14.997  1.00 16.23           C  
ATOM   1824  C   PHE   247       5.077  40.508  15.677  1.00 18.30           C  
ATOM   1825  O   PHE   247       5.220  41.540  16.320  1.00 17.11           O  
ATOM   1826  CB  PHE   247       7.234  39.383  16.116  1.00 17.45           C  
ATOM   1827  CG  PHE   247       8.305  38.430  15.667  1.00 16.77           C  
ATOM   1828  CD1 PHE   247       8.106  37.063  15.754  1.00 17.77           C  
ATOM   1829  CD2 PHE   247       9.519  38.909  15.190  1.00 19.72           C  
ATOM   1830  CE1 PHE   247       9.088  36.164  15.310  1.00 19.81           C  
ATOM   1831  CE2 PHE   247      10.509  38.024  14.758  1.00 17.22           C  
ATOM   1832  CZ  PHE   247      10.293  36.657  14.829  1.00 18.61           C  
ATOM   1833  N   GLU   248       3.923  39.876  15.551  1.00 19.35           N  
ATOM   1834  CA  GLU   248       2.781  40.197  16.416  1.00 22.23           C  
ATOM   1835  C   GLU   248       3.103  39.774  17.853  1.00 22.71           C  
ATOM   1836  O   GLU   248       4.013  38.979  18.080  1.00 20.96           O  
ATOM   1837  CB  GLU   248       1.532  39.491  15.889  1.00 22.61           C  
ATOM   1838  CG  GLU   248       0.932  40.248  14.695  1.00 25.01           C  
ATOM   1839  CD  GLU   248      -0.290  39.602  14.050  1.00 26.62           C  
ATOM   1840  OE1 GLU   248      -0.802  38.579  14.550  1.00 32.28           O  
ATOM   1841  OE2 GLU   248      -0.744  40.145  13.015  1.00 33.12           O  
ATOM   1842  N   GLU   249       2.374  40.335  18.822  1.00 24.15           N  
ATOM   1843  CA  GLU   249       2.566  39.933  20.207  1.00 26.26           C  
ATOM   1844  C   GLU   249       2.084  38.503  20.390  1.00 24.94           C  
ATOM   1845  O   GLU   249       1.216  38.006  19.641  1.00 24.12           O  
ATOM   1846  CB  GLU   249       1.843  40.888  21.148  1.00 25.98           C  
ATOM   1847  CG  GLU   249       0.531  40.375  21.742  1.00 31.22           C  
ATOM   1848  CD  GLU   249      -0.230  41.493  22.450  1.00 30.94           C  
ATOM   1849  OE1 GLU   249       0.432  42.430  22.991  1.00 38.11           O  
ATOM   1850  OE2 GLU   249      -1.481  41.457  22.429  1.00 37.68           O  
ATOM   1851  N   GLY   250       2.678  37.831  21.362  1.00 24.73           N  
ATOM   1852  CA  GLY   250       2.268  36.496  21.738  1.00 25.76           C  
ATOM   1853  C   GLY   250       3.414  35.552  21.992  1.00 25.75           C  
ATOM   1854  O   GLY   250       4.567  35.989  22.161  1.00 25.79           O  
ATOM   1855  N   ARG   251       3.088  34.256  22.015  1.00 26.24           N  
ATOM   1856  CA  ARG   251       4.046  33.166  22.217  1.00 27.25           C  
ATOM   1857  C   ARG   251       4.241  32.399  20.920  1.00 27.77           C  
ATOM   1858  O   ARG   251       3.263  32.141  20.216  1.00 28.46           O  
ATOM   1859  CB  ARG   251       3.515  32.186  23.283  1.00 27.24           C  
ATOM   1860  CG  ARG   251       3.140  32.856  24.591  1.00 28.49           C  
ATOM   1861  CD  ARG   251       2.561  31.859  25.640  1.00 28.57           C  
ATOM   1862  NE  ARG   251       1.780  32.587  26.639  1.00 33.40           N  
ATOM   1863  CZ  ARG   251       2.276  33.080  27.773  1.00 34.86           C  
ATOM   1864  NH1 ARG   251       3.558  32.901  28.084  1.00 34.71           N  
ATOM   1865  NH2 ARG   251       1.480  33.746  28.602  1.00 36.04           N  
ATOM   1866  N   GLU   252       5.493  32.042  20.616  1.00 27.82           N  
ATOM   1867  CA  GLU   252       5.857  31.247  19.428  1.00 28.91           C  
ATOM   1868  C   GLU   252       5.214  31.815  18.146  1.00 26.70           C  
ATOM   1869  O   GLU   252       4.576  31.089  17.373  1.00 27.41           O  
ATOM   1870  CB  GLU   252       5.455  29.774  19.617  1.00 28.85           C  
ATOM   1871  CG  GLU   252       6.465  28.782  19.055  1.00 32.65           C  
ATOM   1872  CD  GLU   252       6.321  27.363  19.621  1.00 32.84           C  
ATOM   1873  OE1 GLU   252       7.240  26.561  19.360  1.00 40.25           O  
ATOM   1874  OE2 GLU   252       5.302  27.029  20.290  1.00 38.53           O  
ATOM   1875  N   VAL   253       5.371  33.117  17.958  1.00 25.17           N  
ATOM   1876  CA  VAL   253       4.775  33.851  16.836  1.00 22.77           C  
ATOM   1877  C   VAL   253       5.595  33.691  15.556  1.00 21.79           C  
ATOM   1878  O   VAL   253       6.816  33.855  15.559  1.00 21.90           O  
ATOM   1879  CB  VAL   253       4.580  35.341  17.196  1.00 22.33           C  
ATOM   1880  CG1 VAL   253       4.074  36.171  15.993  1.00 21.72           C  
ATOM   1881  CG2 VAL   253       3.605  35.476  18.387  1.00 24.21           C  
ATOM   1882  N   LYS   254       4.895  33.354  14.475  1.00 20.12           N  
ATOM   1883  CA  LYS   254       5.478  33.286  13.146  1.00 18.03           C  
ATOM   1884  C   LYS   254       5.614  34.706  12.594  1.00 17.17           C  
ATOM   1885  O   LYS   254       4.621  35.404  12.471  1.00 16.18           O  
ATOM   1886  CB  LYS   254       4.570  32.497  12.207  1.00 19.08           C  
ATOM   1887  CG  LYS   254       5.238  32.176  10.891  1.00 19.33           C  
ATOM   1888  CD  LYS   254       4.260  31.439   9.948  1.00 26.85           C  
ATOM   1889  CE  LYS   254       4.926  31.017   8.656  1.00 30.92           C  
ATOM   1890  NZ  LYS   254       3.996  30.199   7.841  1.00 34.45           N  
ATOM   1891  N   PRO   255       6.841  35.118  12.235  1.00 15.86           N  
ATOM   1892  CA  PRO   255       6.987  36.492  11.743  1.00 14.73           C  
ATOM   1893  C   PRO   255       6.441  36.684  10.334  1.00 14.00           C  
ATOM   1894  O   PRO   255       6.259  35.704   9.594  1.00 15.12           O  
ATOM   1895  CB  PRO   255       8.517  36.704  11.706  1.00 14.51           C  
ATOM   1896  CG  PRO   255       9.068  35.329  11.521  1.00 15.15           C  
ATOM   1897  CD  PRO   255       8.117  34.382  12.249  1.00 16.49           C  
ATOM   1898  N   THR   256       6.163  37.928   9.982  1.00 13.78           N  
ATOM   1899  CA  THR   256       5.953  38.277   8.570  1.00 13.57           C  
ATOM   1900  C   THR   256       7.164  39.079   8.096  1.00 13.58           C  
ATOM   1901  O   THR   256       7.872  39.668   8.915  1.00 14.02           O  
ATOM   1902  CB  THR   256       4.658  39.061   8.380  1.00 13.94           C  
ATOM   1903  OG1 THR   256       4.633  40.216   9.244  1.00 15.02           O  
ATOM   1904  CG2 THR   256       3.466  38.145   8.671  1.00 14.83           C  
ATOM   1905  N   VAL   257       7.398  39.098   6.782  1.00 11.39           N  
ATOM   1906  CA  VAL   257       8.633  39.673   6.254  1.00 11.79           C  
ATOM   1907  C   VAL   257       8.275  40.582   5.067  1.00 12.49           C  
ATOM   1908  O   VAL   257       7.431  40.238   4.259  1.00 11.88           O  
ATOM   1909  CB  VAL   257       9.603  38.560   5.797  1.00 12.20           C  
ATOM   1910  CG1 VAL   257      10.891  39.173   5.158  1.00 12.84           C  
ATOM   1911  CG2 VAL   257       9.926  37.554   6.989  1.00 11.37           C  
ATOM   1912  N   GLN   258       8.886  41.761   5.028  1.00 12.80           N  
ATOM   1913  CA  GLN   258       8.757  42.676   3.898  1.00 14.83           C  
ATOM   1914  C   GLN   258      10.146  42.821   3.279  1.00 13.10           C  
ATOM   1915  O   GLN   258      11.081  43.235   3.951  1.00 13.61           O  
ATOM   1916  CB  GLN   258       8.279  44.066   4.374  1.00 15.18           C  
ATOM   1917  CG  GLN   258       6.887  44.059   4.975  1.00 18.60           C  
ATOM   1918  CD  GLN   258       6.563  45.334   5.754  1.00 21.61           C  
ATOM   1919  OE1 GLN   258       7.172  45.643   6.800  1.00 26.56           O  
ATOM   1920  NE2 GLN   258       5.584  46.086   5.239  1.00 28.76           N  
ATOM   1921  N   CYS   259      10.274  42.453   2.014  1.00 13.04           N  
ATOM   1922  CA  CYS   259      11.499  42.712   1.287  1.00 12.61           C  
ATOM   1923  C   CYS   259      11.459  44.148   0.753  1.00 13.03           C  
ATOM   1924  O   CYS   259      10.541  44.511  -0.009  1.00 14.63           O  
ATOM   1925  CB  CYS   259      11.669  41.726   0.144  1.00 13.09           C  
ATOM   1926  SG  CYS   259      13.167  42.105  -0.790  1.00 14.63           S  
ATOM   1927  N   ILE   260      12.415  44.952   1.191  1.00 13.62           N  
ATOM   1928  CA  ILE   260      12.519  46.388   0.817  1.00 14.08           C  
ATOM   1929  C   ILE   260      13.311  46.576  -0.486  1.00 15.41           C  
ATOM   1930  O   ILE   260      12.898  47.347  -1.378  1.00 15.09           O  
ATOM   1931  CB  ILE   260      13.128  47.246   1.960  1.00 14.59           C  
ATOM   1932  CG1 ILE   260      12.328  47.110   3.275  1.00 13.59           C  
ATOM   1933  CG2 ILE   260      13.302  48.705   1.519  1.00 15.12           C  
ATOM   1934  CD1 ILE   260      10.798  47.437   3.184  1.00 17.11           C  
ATOM   1935  N   CYS   261      14.436  45.867  -0.603  1.00 14.81           N  
ATOM   1936  CA  CYS   261      15.202  45.843  -1.858  1.00 15.96           C  
ATOM   1937  C   CYS   261      16.019  44.575  -1.893  1.00 16.00           C  
ATOM   1938  O   CYS   261      16.188  43.935  -0.853  1.00 16.30           O  
ATOM   1939  CB  CYS   261      16.111  47.071  -1.964  1.00 16.22           C  
ATOM   1940  SG  CYS   261      17.350  47.186  -0.680  1.00 20.19           S  
ATOM   1941  N   MET   262      16.475  44.188  -3.076  1.00 16.20           N  
ATOM   1942  CA  MET   262      17.340  43.008  -3.196  1.00 17.67           C  
ATOM   1943  C   MET   262      18.416  43.285  -4.214  1.00 17.67           C  
ATOM   1944  O   MET   262      18.147  43.915  -5.245  1.00 17.51           O  
ATOM   1945  CB  MET   262      16.526  41.772  -3.601  1.00 17.55           C  
ATOM   1946  CG  MET   262      17.351  40.476  -3.744  1.00 20.14           C  
ATOM   1947  SD  MET   262      16.188  38.954  -3.853  1.00 20.86          SE  
ATOM   1948  CE  MET   262      15.557  39.102  -2.039  1.00 21.38           C  
ATOM   1949  N   ASN   263      19.633  42.828  -3.916  1.00 16.44           N  
ATOM   1950  CA  ASN   263      20.752  42.967  -4.856  1.00 17.08           C  
ATOM   1951  C   ASN   263      21.022  44.425  -5.263  1.00 18.00           C  
ATOM   1952  O   ASN   263      21.442  44.694  -6.418  1.00 19.37           O  
ATOM   1953  CB  ASN   263      20.519  42.091  -6.092  1.00 16.01           C  
ATOM   1954  CG  ASN   263      20.470  40.618  -5.748  1.00 17.20           C  
ATOM   1955  OD1 ASN   263      21.136  40.190  -4.797  1.00 16.42           O  
ATOM   1956  ND2 ASN   263      19.749  39.824  -6.544  1.00 20.11           N  
ATOM   1957  N   LEU   264      20.781  45.343  -4.337  1.00 18.06           N  
ATOM   1958  CA  LEU   264      21.088  46.764  -4.563  1.00 20.40           C  
ATOM   1959  C   LEU   264      22.596  46.926  -4.814  1.00 21.29           C  
ATOM   1960  O   LEU   264      23.418  46.399  -4.050  1.00 20.30           O  
ATOM   1961  CB  LEU   264      20.687  47.612  -3.350  1.00 20.35           C  
ATOM   1962  CG  LEU   264      20.446  49.114  -3.581  1.00 23.12           C  
ATOM   1963  CD1 LEU   264      19.371  49.296  -4.670  1.00 24.12           C  
ATOM   1964  CD2 LEU   264      20.018  49.775  -2.298  1.00 21.83           C  
ATOM   1965  N   GLN   265      22.955  47.657  -5.874  1.00 22.67           N  
ATOM   1966  CA  GLN   265      24.380  47.952  -6.140  1.00 25.66           C  
ATOM   1967  C   GLN   265      24.668  49.436  -6.393  1.00 26.47           C  
ATOM   1968  O   GLN   265      25.604  49.743  -7.139  1.00 27.18           O  
ATOM   1969  CB  GLN   265      24.925  47.188  -7.351  1.00 25.38           C  
ATOM   1970  CG  GLN   265      24.243  45.906  -7.762  1.00 28.61           C  
ATOM   1971  CD  GLN   265      24.906  45.265  -8.962  1.00 28.26           C  
ATOM   1972  OE1 GLN   265      26.146  45.211  -9.065  1.00 33.40           O  
ATOM   1973  NE2 GLN   265      24.092  44.746  -9.872  1.00 33.70           N  
ATOM   1974  N   ASP   266      23.903  50.326  -5.753  1.00 28.13           N  
ATOM   1975  CA  ASP   266      24.028  51.794  -5.906  1.00 30.32           C  
ATOM   1976  C   ASP   266      25.391  52.326  -5.456  1.00 30.83           C  
ATOM   1977  O   ASP   266      25.838  53.402  -5.891  1.00 31.49           O  
ATOM   1978  CB  ASP   266      22.934  52.499  -5.094  1.00 30.71           C  
ATOM   1979  CG  ASP   266      21.547  52.313  -5.687  1.00 32.76           C  
ATOM   1980  OD1 ASP   266      21.434  51.819  -6.830  1.00 35.90           O  
ATOM   1981  OD2 ASP   266      20.569  52.687  -5.007  1.00 35.33           O  
ATOM   1982  N   HIS   267      26.040  51.590  -4.563  1.00 29.75           N  
ATOM   1983  CA  HIS   267      27.378  51.928  -4.124  1.00 29.59           C  
ATOM   1984  C   HIS   267      28.480  51.599  -5.154  1.00 30.49           C  
ATOM   1985  O   HIS   267      29.633  52.004  -4.962  1.00 31.58           O  
ATOM   1986  CB  HIS   267      27.657  51.216  -2.800  1.00 28.97           C  
ATOM   1987  CG  HIS   267      27.627  49.725  -2.912  1.00 24.06           C  
ATOM   1988  ND1 HIS   267      26.469  49.026  -3.188  1.00 22.05           N  
ATOM   1989  CD2 HIS   267      28.611  48.804  -2.805  1.00 21.74           C  
ATOM   1990  CE1 HIS   267      26.745  47.732  -3.246  1.00 20.69           C  
ATOM   1991  NE2 HIS   267      28.039  47.574  -3.021  1.00 19.76           N  
ATOM   1992  N   LEU   268      28.151  50.870  -6.222  1.00 31.07           N  
ATOM   1993  CA  LEU   268      29.165  50.394  -7.182  1.00 32.45           C  
ATOM   1994  C   LEU   268      29.296  51.186  -8.499  1.00 34.57           C  
ATOM   1995  O   LEU   268      30.254  50.978  -9.247  1.00 34.93           O  
ATOM   1996  CB  LEU   268      28.976  48.905  -7.512  1.00 31.83           C  
ATOM   1997  CG  LEU   268      29.246  47.899  -6.388  1.00 30.13           C  
ATOM   1998  CD1 LEU   268      29.144  46.464  -6.905  1.00 30.71           C  
ATOM   1999  CD2 LEU   268      30.618  48.155  -5.758  1.00 30.78           C  
ATOM   2000  N   ASN   269      28.346  52.062  -8.794  1.00 36.54           N  
ATOM   2001  CA  ASN   269      28.369  52.782 -10.078  1.00 38.57           C  
ATOM   2002  C   ASN   269      29.384  53.929 -10.094  1.00 39.07           C  
ATOM   2003  O   ASN   269      30.600  53.710  -9.978  1.00 39.36           O  
ATOM   2004  CB  ASN   269      26.960  53.264 -10.476  1.00 39.59           C  
ATOM   2005  CG  ASN   269      26.201  53.925  -9.316  1.00 41.98           C  
ATOM   2006  OD1 ASN   269      26.802  54.562  -8.435  1.00 44.75           O  
ATOM   2007  ND2 ASN   269      24.873  53.793  -9.327  1.00 44.56           N  
END
