
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  262 ( 1955),  selected  262 , name 2rcy_A
# Molecule2: number of CA atoms  259 ( 2056),  selected  259 , name T0393.pdb
# PARAMETERS: 2rcy_A.T0393.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      S       4           #
LGA    X     2_A      I       5          3.426
LGA    E     3_A      E       6          2.662
LGA    N     4_A      D       7          1.726
LGA    I     5_A      T       8          1.676
LGA    K     6_A      P       9          1.767
LGA    L     7_A      I      10          1.907
LGA    G     8_A      V      11          1.371
LGA    F     9_A      L      12          0.478
LGA    X    10_A      I      13          0.574
LGA    G    11_A      G      14          1.382
LGA    L    12_A      A      15          0.733
LGA    G    13_A      G      16          2.296
LGA    Q    14_A      N      17          3.254
LGA    X    15_A      L      18          3.048
LGA    G    16_A      A      19          2.299
LGA    S    17_A      T      20          2.058
LGA    A    18_A      N      21          3.265
LGA    L    19_A      L      22          2.562
LGA    A    20_A      A      23          2.000
LGA    H    21_A      K      24          2.864
LGA    G    22_A      A      25          4.069
LGA    I    23_A      L      26          3.503
LGA    A    24_A      Y      27          3.600
LGA    N    25_A      -       -           -
LGA    A    26_A      -       -           -
LGA    N    27_A      R      28          2.007
LGA    I    28_A      K      29          1.343
LGA    I    29_A      G      30          2.215
LGA    K    30_A      F      31          4.234
LGA    K    31_A      -       -           -
LGA    E    32_A      R      32          5.196
LGA    N    33_A      I      33          3.591
LGA    L    34_A      V      34           #
LGA    F    35_A      Q      35          2.692
LGA    Y    36_A      V      36          0.914
LGA    Y    37_A      Y      37          1.420
LGA    G    38_A      S      38          2.044
LGA    P    39_A      R      39          3.564
LGA    S    40_A      T      40          3.164
LGA    K    41_A      E      41          2.899
LGA    K    42_A      E      42          3.591
LGA    -       -      S      43           -
LGA    -       -      A      44           -
LGA    -       -      R      45           -
LGA    N    43_A      E      46          1.324
LGA    T    44_A      L      47          2.385
LGA    -       -      A      48           -
LGA    -       -      Q      49           -
LGA    T    45_A      K      50          1.028
LGA    L    46_A      V      51          2.810
LGA    -       -      E      52           -
LGA    N    47_A      A      53          0.807
LGA    Y    48_A      E      54          2.060
LGA    X    49_A      Y      55          3.494
LGA    -       -      T      56           -
LGA    -       -      T      57           -
LGA    -       -      D      58           -
LGA    -       -      L      59           -
LGA    -       -      A      60           -
LGA    S    50_A      E      61          3.867
LGA    S    51_A      V      62          2.029
LGA    N    52_A      -       -           -
LGA    E    53_A      -       -           -
LGA    E    54_A      -       -           -
LGA    L    55_A      N      63          2.586
LGA    A    56_A      P      64          3.680
LGA    R    57_A      Y      65          1.650
LGA    H    58_A      -       -           -
LGA    C    59_A      A      66          2.126
LGA    D    60_A      K      67          1.915
LGA    I    61_A      L      68          1.531
LGA    I    62_A      Y      69          1.089
LGA    V    63_A      I      70          0.201
LGA    C    64_A      V      71          0.846
LGA    A    65_A      S      72          1.270
LGA    V    66_A      L      73          1.709
LGA    K    67_A      K      74          1.633
LGA    P    68_A      D      75          1.930
LGA    D    69_A      S      76          2.251
LGA    I    70_A      A      77          2.076
LGA    A    71_A      F      78          1.648
LGA    G    72_A      A      79          2.732
LGA    S    73_A      E      80          4.170
LGA    V    74_A      L      81          2.963
LGA    L    75_A      L      82          3.109
LGA    N    76_A      Q      83          1.473
LGA    N    77_A      G      84          2.468
LGA    I    78_A      I      85          3.737
LGA    K    79_A      V      86          2.699
LGA    -       -      E      87           -
LGA    P    80_A      G      88          3.760
LGA    Y    81_A      K      89          0.441
LGA    L    82_A      R      90          4.055
LGA    S    83_A      E      91          1.285
LGA    S    84_A      E      92          1.087
LGA    K    85_A      A      93          2.032
LGA    L    86_A      L      94          2.087
LGA    L    87_A      M      95          1.918
LGA    I    88_A      V      96          1.667
LGA    S    89_A      H      97          0.908
LGA    I    90_A      T      98          1.360
LGA    C    91_A      A      99          3.651
LGA    G    92_A      G     100          5.167
LGA    G    93_A      S     101          3.890
LGA    L    94_A      I     102          3.121
LGA    N    95_A      P     103          1.444
LGA    I    96_A      M     104          2.230
LGA    G    97_A      N     105          2.089
LGA    K    98_A      V     106          2.206
LGA    L    99_A      W     107          1.515
LGA    E   100_A      E     108          0.728
LGA    E   101_A      G     109          3.463
LGA    X   102_A      H     110          3.388
LGA    V   103_A      V     111          2.850
LGA    G   104_A      -       -           -
LGA    S   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    N   107_A      P     112          1.898
LGA    K   108_A      H     113          1.973
LGA    I   109_A      Y     114          1.405
LGA    V   110_A      G     115          1.402
LGA    W   111_A      V     116          1.245
LGA    V   112_A      F     117          2.739
LGA    X   113_A      Y     118          2.934
LGA    P   114_A      P     119          3.217
LGA    N   115_A      M     120          4.204
LGA    T   116_A      Q     121           #
LGA    P   117_A      T     122          3.191
LGA    C   118_A      F     123          5.112
LGA    L   119_A      S     124           #
LGA    -       -      K     125           -
LGA    -       -      Q     126           -
LGA    -       -      R     127           -
LGA    -       -      E     128           -
LGA    V   120_A      V     129          1.286
LGA    G   121_A      D     130          2.240
LGA    -       -      F     131           -
LGA    -       -      K     132           -
LGA    E   122_A      E     133           #
LGA    G   123_A      I     134          3.882
LGA    S   124_A      P     135          3.838
LGA    F   125_A      F     136          3.233
LGA    I   126_A      F     137          2.555
LGA    Y   127_A      I     138          2.832
LGA    C   128_A      E     139          1.976
LGA    S   129_A      A     140          2.006
LGA    N   130_A      S     141          2.069
LGA    K   131_A      S     142          2.854
LGA    N   132_A      T     143          5.631
LGA    V   133_A      E     144          3.924
LGA    N   134_A      D     145          4.090
LGA    S   135_A      A     146           #
LGA    T   136_A      A     147          3.482
LGA    D   137_A      F     148          1.039
LGA    K   138_A      L     149          3.851
LGA    K   139_A      K     150          3.181
LGA    Y   140_A      A     151          2.406
LGA    V   141_A      I     152          4.017
LGA    N   142_A      A     153          2.889
LGA    D   143_A      S     154          1.716
LGA    I   144_A      T     155          4.990
LGA    F   145_A      L     156          4.755
LGA    N   146_A      S     157          1.059
LGA    S   147_A      N     158           #
LGA    C   148_A      -       -           -
LGA    G   149_A      -       -           -
LGA    I   150_A      R     159          3.645
LGA    I   151_A      V     160          3.472
LGA    H   152_A      Y     161          2.500
LGA    E   153_A      D     162          1.768
LGA    I   154_A      A     163          1.496
LGA    K   155_A      D     164          2.285
LGA    E   156_A      S     165          2.480
LGA    K   157_A      E     166          1.963
LGA    D   158_A      Q     167          1.846
LGA    X   159_A      R     168          2.187
LGA    D   160_A      K     169          1.676
LGA    I   161_A      S     170          1.744
LGA    A   162_A      L     171          1.801
LGA    T   163_A      H     172          2.103
LGA    A   164_A      L     173          1.853
LGA    I   165_A      A     174          2.461
LGA    S   166_A      A     175          3.238
LGA    G   167_A      V     176           #
LGA    C   168_A      F     177           #
LGA    G   169_A      T     178          4.316
LGA    P   170_A      C     179          2.455
LGA    A   171_A      N     180          1.405
LGA    Y   172_A      F     181          1.489
LGA    V   173_A      T     182          2.079
LGA    Y   174_A      N     183          0.904
LGA    L   175_A      H     184          0.902
LGA    F   176_A      M     185          2.487
LGA    I   177_A      Y     186          2.351
LGA    E   178_A      A     187          2.354
LGA    S   179_A      L     188          3.541
LGA    L   180_A      A     189          4.331
LGA    I   181_A      -       -           -
LGA    D   182_A      -       -           -
LGA    A   183_A      A     190           #
LGA    G   184_A      E     191           -
LGA    V   185_A      L     192          5.310
LGA    K   186_A      L     193          4.691
LGA    N   187_A      K     194           -
LGA    -       -      K     195           -
LGA    G   188_A      Y     196           #
LGA    L   189_A      N     197           -
LGA    S   190_A      L     198          3.258
LGA    R   191_A      P     199          1.988
LGA    E   192_A      F     200          4.189
LGA    L   193_A      D     201          3.840
LGA    S   194_A      V     202          2.500
LGA    K   195_A      M     203          3.007
LGA    N   196_A      L     204          1.782
LGA    L   197_A      P     205          2.237
LGA    V   198_A      L     206          3.101
LGA    L   199_A      I     207          2.735
LGA    Q   200_A      D     208          1.757
LGA    T   201_A      E     209          1.712
LGA    I   202_A      T     210          2.807
LGA    K   203_A      A     211          3.498
LGA    G   204_A      R     212          1.977
LGA    S   205_A      K     213          1.618
LGA    V   206_A      V     214          3.505
LGA    E   207_A      H     215          3.173
LGA    X   208_A      E     216          2.303
LGA    V   209_A      L     217          4.128
LGA    K   210_A      -       -           -
LGA    K   211_A      -       -           -
LGA    S   212_A      -       -           -
LGA    D   213_A      -       -           -
LGA    Q   214_A      -       -           -
LGA    P   215_A      E     218          3.982
LGA    V   216_A      P     219          3.935
LGA    Q   217_A      K     220          3.183
LGA    Q   218_A      T     221          3.687
LGA    L   219_A      -       -           -
LGA    K   220_A      A     222          2.289
LGA    D   221_A      -       -           -
LGA    N   222_A      -       -           -
LGA    I   223_A      Q     223           #
LGA    V   224_A      -       -           -
LGA    S   225_A      -       -           -
LGA    P   226_A      -       -           -
LGA    G   227_A      -       -           -
LGA    G   228_A      -       -           -
LGA    I   229_A      -       -           -
LGA    T   230_A      T     224          4.118
LGA    A   231_A      G     225          5.362
LGA    V   232_A      P     226          2.515
LGA    G   233_A      A     227          4.073
LGA    L   234_A      I     228          2.833
LGA    Y   235_A      R     229          3.165
LGA    S   236_A      Y     230          4.139
LGA    -       -      D     231           -
LGA    -       -      E     232           -
LGA    -       -      N     233           -
LGA    -       -      V     234           -
LGA    -       -      I     235           -
LGA    -       -      G     236           -
LGA    -       -      N     237           -
LGA    -       -      H     238           -
LGA    -       -      L     239           -
LGA    -       -      R     240           -
LGA    -       -      M     241           -
LGA    -       -      L     242           -
LGA    -       -      A     243           -
LGA    -       -      D     244           -
LGA    -       -      D     245           -
LGA    -       -      P     246           -
LGA    -       -      A     247           -
LGA    -       -      M     248           -
LGA    -       -      Q     249           -
LGA    -       -      R     250           -
LGA    -       -      L     251           -
LGA    -       -      Y     252           -
LGA    -       -      E     253           -
LGA    -       -      L     254           -
LGA    L   237_A      L     255          4.973
LGA    E   238_A      S     256          4.609
LGA    K   239_A      R     257          2.386
LGA    N   240_A      -       -           -
LGA    S   241_A      S     258          1.622
LGA    F   242_A      -       -           -
LGA    K   243_A      I     259          5.326
LGA    Y   244_A      H     260           -
LGA    T   245_A      E     261           -
LGA    V   246_A      R     262           -
LGA    X   247_A      -       -           -
LGA    N   248_A      -       -           -
LGA    A   249_A      -       -           -
LGA    V   250_A      -       -           -
LGA    E   251_A      -       -           -
LGA    A   252_A      -       -           -
LGA    A   253_A      -       -           -
LGA    C   254_A      -       -           -
LGA    E   255_A      -       -           -
LGA    K   256_A      -       -           -
LGA    S   257_A      -       -           -
LGA    K   258_A      -       -           -
LGA    A   259_A      -       -           -
LGA    X   260_A      -       -           -
LGA    G   261_A      -       -           -
LGA    S   262_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  262  259    5.0    198    2.86    10.61     42.979     6.693

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.793862 * X  +  -0.310088 * Y  +   0.523096 * Z  +  54.970535
  Y_new =   0.189221 * X  +   0.691545 * Y  +   0.697109 * Z  + -10.076335
  Z_new =  -0.577909 * X  +   0.652389 * Y  +  -0.490315 * Z  +  36.843910 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.215301   -0.926292  [ DEG:   126.9274    -53.0726 ]
  Theta =   0.616165    2.525428  [ DEG:    35.3036    144.6964 ]
  Phi   =   2.907604   -0.233989  [ DEG:   166.5934    -13.4066 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rcy_A                                        
REMARK     2: T0393.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rcy_A.T0393.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  262  259   5.0  198   2.86   10.61  42.979
REMARK  ---------------------------------------------------------- 
MOLECULE 2rcy_A
HEADER    OXIDOREDUCTASE                          20-SEP-07   2RCY              
TITLE     CRYSTAL STRUCTURE OF PLASMODIUM FALCIPARUM PYRROLINE                  
TITLE    2 CARBOXYLATE REDUCTASE (MAL13P1.284) WITH NADP BOUND                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PYRROLINE CARBOXYLATE REDUCTASE;                           
COMPND   3 CHAIN: A, B, C, D, E;                                                
COMPND   4 EC: 1.5.1.2;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PLASMODIUM FALCIPARUM 3D7;                      
SOURCE   3 ORGANISM_COMMON: MALARIA PARASITE;                                   
SOURCE   4 STRAIN: 3D7;                                                         
SOURCE   5 GENE: MAL13P1.284;                                                   
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: DH5A;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: P15-TEV-LIC                               
KEYWDS    MALARIA, STRUCTURAL GENOMICS, PYRROLINE REDUCTASE,                    
KEYWDS   2 OXIDOREDUCTASE, STRUCTURAL GENOMICS CONSORTIUM, SGC                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.K.WERNIMONT,J.LEW,L.LIN,H.REN,X.SUN,C.KHUU,A.HASSANALI,             
AUTHOR   2 G.WASNEY,Y.ZHAO,I.KOZIERADZKI,M.SCHAPIRA,A.BOCHKAREV,                
AUTHOR   3 J.WEIGELT,M.SUNDSTROM,C.H.ARROWSMITH,A.M.EDWARDS,R.HUI,              
AUTHOR   4 J.D.ARTZ,M.AMANI,STRUCTURAL GENOMICS CONSORTIUM (SGC)                
REVDAT   1   23-OCT-07 2RCY    0                                                
JRNL        AUTH   A.K.WERNIMONT,J.LEW,L.LIN,H.REN,X.SUN,C.KHUU,                
JRNL        AUTH 2 A.HASSANALI,Y.ZHAO,I.KOZIERADZKI,M.SCHAPIRA,                 
JRNL        AUTH 3 A.BOCHKAREV,J.WEIGELT,M.SUNDSTROM,C.H.ARROWSMITH,            
JRNL        AUTH 4 A.M.EDWARDS,R.HUI,J.D.ARTZ,M.AMANI                           
JRNL        TITL   CRYSTAL STRUCTURE OF PLASMODIUM FALCIPARUM                   
JRNL        TITL 2 PYRROLINE CARBOXYLATE REDUCTASE (MAL13P1.284) WITH           
JRNL        TITL 3 NADP BOUND.                                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2RCY A    2   262  UNP    Q8IDC6   Q8IDC6_PLAF7     1    261             
DBREF  2RCY B    2   262  UNP    Q8IDC6   Q8IDC6_PLAF7     1    261             
DBREF  2RCY C    2   262  UNP    Q8IDC6   Q8IDC6_PLAF7     1    261             
DBREF  2RCY D    2   262  UNP    Q8IDC6   Q8IDC6_PLAF7     1    261             
DBREF  2RCY E    2   262  UNP    Q8IDC6   Q8IDC6_PLAF7     1    261             
SEQRES   1 A  262  GLY MSE GLU ASN ILE LYS LEU GLY PHE MSE GLY LEU GLY          
SEQRES   2 A  262  GLN MSE GLY SER ALA LEU ALA HIS GLY ILE ALA ASN ALA          
SEQRES   3 A  262  ASN ILE ILE LYS LYS GLU ASN LEU PHE TYR TYR GLY PRO          
SEQRES   4 A  262  SER LYS LYS ASN THR THR LEU ASN TYR MSE SER SER ASN          
SEQRES   5 A  262  GLU GLU LEU ALA ARG HIS CYS ASP ILE ILE VAL CYS ALA          
SEQRES   6 A  262  VAL LYS PRO ASP ILE ALA GLY SER VAL LEU ASN ASN ILE          
SEQRES   7 A  262  LYS PRO TYR LEU SER SER LYS LEU LEU ILE SER ILE CYS          
SEQRES   8 A  262  GLY GLY LEU ASN ILE GLY LYS LEU GLU GLU MSE VAL GLY          
SEQRES   9 A  262  SER GLU ASN LYS ILE VAL TRP VAL MSE PRO ASN THR PRO          
SEQRES  10 A  262  CYS LEU VAL GLY GLU GLY SER PHE ILE TYR CYS SER ASN          
SEQRES  11 A  262  LYS ASN VAL ASN SER THR ASP LYS LYS TYR VAL ASN ASP          
SEQRES  12 A  262  ILE PHE ASN SER CYS GLY ILE ILE HIS GLU ILE LYS GLU          
SEQRES  13 A  262  LYS ASP MSE ASP ILE ALA THR ALA ILE SER GLY CYS GLY          
SEQRES  14 A  262  PRO ALA TYR VAL TYR LEU PHE ILE GLU SER LEU ILE ASP          
SEQRES  15 A  262  ALA GLY VAL LYS ASN GLY LEU SER ARG GLU LEU SER LYS          
SEQRES  16 A  262  ASN LEU VAL LEU GLN THR ILE LYS GLY SER VAL GLU MSE          
SEQRES  17 A  262  VAL LYS LYS SER ASP GLN PRO VAL GLN GLN LEU LYS ASP          
SEQRES  18 A  262  ASN ILE VAL SER PRO GLY GLY ILE THR ALA VAL GLY LEU          
SEQRES  19 A  262  TYR SER LEU GLU LYS ASN SER PHE LYS TYR THR VAL MSE          
SEQRES  20 A  262  ASN ALA VAL GLU ALA ALA CYS GLU LYS SER LYS ALA MSE          
SEQRES  21 A  262  GLY SER                                                      
SEQRES   1 B  262  GLY MSE GLU ASN ILE LYS LEU GLY PHE MSE GLY LEU GLY          
SEQRES   2 B  262  GLN MSE GLY SER ALA LEU ALA HIS GLY ILE ALA ASN ALA          
SEQRES   3 B  262  ASN ILE ILE LYS LYS GLU ASN LEU PHE TYR TYR GLY PRO          
SEQRES   4 B  262  SER LYS LYS ASN THR THR LEU ASN TYR MSE SER SER ASN          
SEQRES   5 B  262  GLU GLU LEU ALA ARG HIS CYS ASP ILE ILE VAL CYS ALA          
SEQRES   6 B  262  VAL LYS PRO ASP ILE ALA GLY SER VAL LEU ASN ASN ILE          
SEQRES   7 B  262  LYS PRO TYR LEU SER SER LYS LEU LEU ILE SER ILE CYS          
SEQRES   8 B  262  GLY GLY LEU ASN ILE GLY LYS LEU GLU GLU MSE VAL GLY          
SEQRES   9 B  262  SER GLU ASN LYS ILE VAL TRP VAL MSE PRO ASN THR PRO          
SEQRES  10 B  262  CYS LEU VAL GLY GLU GLY SER PHE ILE TYR CYS SER ASN          
SEQRES  11 B  262  LYS ASN VAL ASN SER THR ASP LYS LYS TYR VAL ASN ASP          
SEQRES  12 B  262  ILE PHE ASN SER CYS GLY ILE ILE HIS GLU ILE LYS GLU          
SEQRES  13 B  262  LYS ASP MSE ASP ILE ALA THR ALA ILE SER GLY CYS GLY          
SEQRES  14 B  262  PRO ALA TYR VAL TYR LEU PHE ILE GLU SER LEU ILE ASP          
SEQRES  15 B  262  ALA GLY VAL LYS ASN GLY LEU SER ARG GLU LEU SER LYS          
SEQRES  16 B  262  ASN LEU VAL LEU GLN THR ILE LYS GLY SER VAL GLU MSE          
SEQRES  17 B  262  VAL LYS LYS SER ASP GLN PRO VAL GLN GLN LEU LYS ASP          
SEQRES  18 B  262  ASN ILE VAL SER PRO GLY GLY ILE THR ALA VAL GLY LEU          
SEQRES  19 B  262  TYR SER LEU GLU LYS ASN SER PHE LYS TYR THR VAL MSE          
SEQRES  20 B  262  ASN ALA VAL GLU ALA ALA CYS GLU LYS SER LYS ALA MSE          
SEQRES  21 B  262  GLY SER                                                      
SEQRES   1 C  262  GLY MSE GLU ASN ILE LYS LEU GLY PHE MSE GLY LEU GLY          
SEQRES   2 C  262  GLN MSE GLY SER ALA LEU ALA HIS GLY ILE ALA ASN ALA          
SEQRES   3 C  262  ASN ILE ILE LYS LYS GLU ASN LEU PHE TYR TYR GLY PRO          
SEQRES   4 C  262  SER LYS LYS ASN THR THR LEU ASN TYR MSE SER SER ASN          
SEQRES   5 C  262  GLU GLU LEU ALA ARG HIS CYS ASP ILE ILE VAL CYS ALA          
SEQRES   6 C  262  VAL LYS PRO ASP ILE ALA GLY SER VAL LEU ASN ASN ILE          
SEQRES   7 C  262  LYS PRO TYR LEU SER SER LYS LEU LEU ILE SER ILE CYS          
SEQRES   8 C  262  GLY GLY LEU ASN ILE GLY LYS LEU GLU GLU MSE VAL GLY          
SEQRES   9 C  262  SER GLU ASN LYS ILE VAL TRP VAL MSE PRO ASN THR PRO          
SEQRES  10 C  262  CYS LEU VAL GLY GLU GLY SER PHE ILE TYR CYS SER ASN          
SEQRES  11 C  262  LYS ASN VAL ASN SER THR ASP LYS LYS TYR VAL ASN ASP          
SEQRES  12 C  262  ILE PHE ASN SER CYS GLY ILE ILE HIS GLU ILE LYS GLU          
SEQRES  13 C  262  LYS ASP MSE ASP ILE ALA THR ALA ILE SER GLY CYS GLY          
SEQRES  14 C  262  PRO ALA TYR VAL TYR LEU PHE ILE GLU SER LEU ILE ASP          
SEQRES  15 C  262  ALA GLY VAL LYS ASN GLY LEU SER ARG GLU LEU SER LYS          
SEQRES  16 C  262  ASN LEU VAL LEU GLN THR ILE LYS GLY SER VAL GLU MSE          
SEQRES  17 C  262  VAL LYS LYS SER ASP GLN PRO VAL GLN GLN LEU LYS ASP          
SEQRES  18 C  262  ASN ILE VAL SER PRO GLY GLY ILE THR ALA VAL GLY LEU          
SEQRES  19 C  262  TYR SER LEU GLU LYS ASN SER PHE LYS TYR THR VAL MSE          
SEQRES  20 C  262  ASN ALA VAL GLU ALA ALA CYS GLU LYS SER LYS ALA MSE          
SEQRES  21 C  262  GLY SER                                                      
SEQRES   1 D  262  GLY MSE GLU ASN ILE LYS LEU GLY PHE MSE GLY LEU GLY          
SEQRES   2 D  262  GLN MSE GLY SER ALA LEU ALA HIS GLY ILE ALA ASN ALA          
SEQRES   3 D  262  ASN ILE ILE LYS LYS GLU ASN LEU PHE TYR TYR GLY PRO          
SEQRES   4 D  262  SER LYS LYS ASN THR THR LEU ASN TYR MSE SER SER ASN          
SEQRES   5 D  262  GLU GLU LEU ALA ARG HIS CYS ASP ILE ILE VAL CYS ALA          
SEQRES   6 D  262  VAL LYS PRO ASP ILE ALA GLY SER VAL LEU ASN ASN ILE          
SEQRES   7 D  262  LYS PRO TYR LEU SER SER LYS LEU LEU ILE SER ILE CYS          
SEQRES   8 D  262  GLY GLY LEU ASN ILE GLY LYS LEU GLU GLU MSE VAL GLY          
SEQRES   9 D  262  SER GLU ASN LYS ILE VAL TRP VAL MSE PRO ASN THR PRO          
SEQRES  10 D  262  CYS LEU VAL GLY GLU GLY SER PHE ILE TYR CYS SER ASN          
SEQRES  11 D  262  LYS ASN VAL ASN SER THR ASP LYS LYS TYR VAL ASN ASP          
SEQRES  12 D  262  ILE PHE ASN SER CYS GLY ILE ILE HIS GLU ILE LYS GLU          
SEQRES  13 D  262  LYS ASP MSE ASP ILE ALA THR ALA ILE SER GLY CYS GLY          
SEQRES  14 D  262  PRO ALA TYR VAL TYR LEU PHE ILE GLU SER LEU ILE ASP          
SEQRES  15 D  262  ALA GLY VAL LYS ASN GLY LEU SER ARG GLU LEU SER LYS          
SEQRES  16 D  262  ASN LEU VAL LEU GLN THR ILE LYS GLY SER VAL GLU MSE          
SEQRES  17 D  262  VAL LYS LYS SER ASP GLN PRO VAL GLN GLN LEU LYS ASP          
SEQRES  18 D  262  ASN ILE VAL SER PRO GLY GLY ILE THR ALA VAL GLY LEU          
SEQRES  19 D  262  TYR SER LEU GLU LYS ASN SER PHE LYS TYR THR VAL MSE          
SEQRES  20 D  262  ASN ALA VAL GLU ALA ALA CYS GLU LYS SER LYS ALA MSE          
SEQRES  21 D  262  GLY SER                                                      
SEQRES   1 E  262  GLY MSE GLU ASN ILE LYS LEU GLY PHE MSE GLY LEU GLY          
SEQRES   2 E  262  GLN MSE GLY SER ALA LEU ALA HIS GLY ILE ALA ASN ALA          
SEQRES   3 E  262  ASN ILE ILE LYS LYS GLU ASN LEU PHE TYR TYR GLY PRO          
SEQRES   4 E  262  SER LYS LYS ASN THR THR LEU ASN TYR MSE SER SER ASN          
SEQRES   5 E  262  GLU GLU LEU ALA ARG HIS CYS ASP ILE ILE VAL CYS ALA          
SEQRES   6 E  262  VAL LYS PRO ASP ILE ALA GLY SER VAL LEU ASN ASN ILE          
SEQRES   7 E  262  LYS PRO TYR LEU SER SER LYS LEU LEU ILE SER ILE CYS          
SEQRES   8 E  262  GLY GLY LEU ASN ILE GLY LYS LEU GLU GLU MSE VAL GLY          
SEQRES   9 E  262  SER GLU ASN LYS ILE VAL TRP VAL MSE PRO ASN THR PRO          
SEQRES  10 E  262  CYS LEU VAL GLY GLU GLY SER PHE ILE TYR CYS SER ASN          
SEQRES  11 E  262  LYS ASN VAL ASN SER THR ASP LYS LYS TYR VAL ASN ASP          
SEQRES  12 E  262  ILE PHE ASN SER CYS GLY ILE ILE HIS GLU ILE LYS GLU          
SEQRES  13 E  262  LYS ASP MSE ASP ILE ALA THR ALA ILE SER GLY CYS GLY          
SEQRES  14 E  262  PRO ALA TYR VAL TYR LEU PHE ILE GLU SER LEU ILE ASP          
SEQRES  15 E  262  ALA GLY VAL LYS ASN GLY LEU SER ARG GLU LEU SER LYS          
SEQRES  16 E  262  ASN LEU VAL LEU GLN THR ILE LYS GLY SER VAL GLU MSE          
SEQRES  17 E  262  VAL LYS LYS SER ASP GLN PRO VAL GLN GLN LEU LYS ASP          
SEQRES  18 E  262  ASN ILE VAL SER PRO GLY GLY ILE THR ALA VAL GLY LEU          
SEQRES  19 E  262  TYR SER LEU GLU LYS ASN SER PHE LYS TYR THR VAL MSE          
SEQRES  20 E  262  ASN ALA VAL GLU ALA ALA CYS GLU LYS SER LYS ALA MSE          
SEQRES  21 E  262  GLY SER                                                      
HET    MSE  A   2       8                                                       
HET    MSE  A  10       8                                                       
HET    MSE  A  15       8                                                       
HET    MSE  A  49       8                                                       
HET    MSE  A 102       8                                                       
HET    MSE  A 113       8                                                       
HET    MSE  A 159       8                                                       
HET    MSE  A 208       8                                                       
HET    MSE  A 247       8                                                       
HET    MSE  A 260       8                                                       
HET    MSE  B  10       8                                                       
HET    MSE  B  15       8                                                       
HET    MSE  B  49       8                                                       
HET    MSE  B 102       8                                                       
HET    MSE  B 113       8                                                       
HET    MSE  B 159       8                                                       
HET    MSE  B 208       8                                                       
HET    MSE  B 247       8                                                       
HET    MSE  B 260       8                                                       
HET    MSE  C   2       8                                                       
HET    MSE  C  10       8                                                       
HET    MSE  C  15       8                                                       
HET    MSE  C  49       8                                                       
HET    MSE  C 102       8                                                       
HET    MSE  C 113       8                                                       
HET    MSE  C 159       8                                                       
HET    MSE  C 208       8                                                       
HET    MSE  C 247       8                                                       
HET    MSE  C 260       8                                                       
HET    MSE  D  10       8                                                       
HET    MSE  D  15       8                                                       
HET    MSE  D  49       8                                                       
HET    MSE  D 102       8                                                       
HET    MSE  D 113       8                                                       
HET    MSE  D 159       8                                                       
HET    MSE  D 208       8                                                       
HET    MSE  D 247       8                                                       
HET    MSE  D 260       8                                                       
HET    MSE  E  10       8                                                       
HET    MSE  E  15       8                                                       
HET    MSE  E  49       8                                                       
HET    MSE  E 102       8                                                       
HET    MSE  E 113       8                                                       
HET    MSE  E 159       8                                                       
HET    MSE  E 208       8                                                       
HET    MSE  E 247       8                                                       
HET    MSE  E 260       8                                                       
HET     MG  A 263       1                                                       
HET     MG  B 263       1                                                       
HET     MG  D 263       1                                                       
HET     MG  E 263       1                                                       
HET    NAP  B 264      48                                                       
HET    NAP  A 264      48                                                       
HET    NAP  D 264      48                                                       
HET    NAP  E 264      48                                                       
HET    NAP  C 264      48                                                       
HET    GOL  A 265       6                                                       
HET    GOL  B 265       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     NAP NADP NICOTINAMIDE-ADENINE-DINUCLEOTIDE PHOSPHATE                 
HETNAM     GOL GLYCEROL                                                         
HETSYN     NAP 2'-MONOPHOSPHOADENOSINE 5'-DIPHOSPHORIBOSE                       
FORMUL   1  MSE    47(C5 H11 N O2 SE)                                           
FORMUL   6   MG    4(MG 2+)                                                     
FORMUL  10  NAP    5(C21 H28 N7 O17 P3)                                         
FORMUL  15  GOL    2(C3 H8 O3)                                                  
FORMUL  17  HOH   *427(H2 O)                                                    
CRYST1  160.207  113.741   82.651  90.00 105.71  90.00 C 1 2 1      20          
ATOM      1  N   GLY A   1      29.795  33.942  40.841  1.00 53.98           N  
ATOM      2  CA  GLY A   1      29.461  35.346  41.214  1.00 53.96           C  
ATOM      3  C   GLY A   1      28.567  36.033  40.202  1.00 53.92           C  
ATOM      4  O   GLY A   1      28.899  36.108  39.017  1.00 53.95           O  
HETATM    5  N   MSE A   2      27.428  36.529  40.680  1.00 53.87           N  
HETATM    6  CA  MSE A   2      26.464  37.259  39.855  1.00 53.88           C  
HETATM    7  C   MSE A   2      25.625  38.190  40.730  1.00 53.63           C  
HETATM    8  O   MSE A   2      24.755  38.914  40.238  1.00 53.62           O  
HETATM    9  CB  MSE A   2      25.562  36.280  39.100  1.00 53.91           C  
HETATM   10  CG  MSE A   2      24.853  36.877  37.895  1.00 54.02           C  
HETATM   11 SE   MSE A   2      24.409  35.549  36.549  0.80 54.39          SE  
HETATM   12  CE  MSE A   2      26.194  34.802  36.259  1.00 54.35           C  
ATOM     13  N   GLU A   3      25.908  38.171  42.028  1.00 53.42           N  
ATOM     14  CA  GLU A   3      25.143  38.920  43.024  1.00 53.19           C  
ATOM     15  C   GLU A   3      25.328  40.434  42.903  1.00 53.01           C  
ATOM     16  O   GLU A   3      24.477  41.202  43.354  1.00 53.01           O  
ATOM     17  CB  GLU A   3      25.514  38.458  44.439  1.00 53.18           C  
ATOM     18  CG  GLU A   3      25.293  36.967  44.712  1.00 53.13           C  
ATOM     19  CD  GLU A   3      26.420  36.077  44.193  1.00 53.22           C  
ATOM     20  OE1 GLU A   3      27.473  36.604  43.774  1.00 53.27           O  
ATOM     21  OE2 GLU A   3      26.250  34.841  44.207  1.00 53.37           O  
ATOM     22  N   ASN A   4      26.433  40.850  42.288  1.00 52.81           N  
ATOM     23  CA  ASN A   4      26.784  42.269  42.181  1.00 52.64           C  
ATOM     24  C   ASN A   4      26.251  42.999  40.951  1.00 52.45           C  
ATOM     25  O   ASN A   4      26.017  44.208  41.004  1.00 52.40           O  
ATOM     26  CB  ASN A   4      28.300  42.454  42.274  1.00 52.71           C  
ATOM     27  CG  ASN A   4      28.818  42.302  43.687  1.00 52.77           C  
ATOM     28  OD1 ASN A   4      28.270  42.875  44.630  1.00 52.83           O  
ATOM     29  ND2 ASN A   4      29.884  41.530  43.840  1.00 52.87           N  
ATOM     30  N   ILE A   5      26.071  42.272  39.849  1.00 52.28           N  
ATOM     31  CA  ILE A   5      25.588  42.878  38.605  1.00 52.11           C  
ATOM     32  C   ILE A   5      24.129  43.313  38.710  1.00 51.91           C  
ATOM     33  O   ILE A   5      23.319  42.664  39.376  1.00 51.90           O  
ATOM     34  CB  ILE A   5      25.782  41.967  37.361  1.00 52.14           C  
ATOM     35  CG1 ILE A   5      25.062  40.628  37.538  1.00 52.20           C  
ATOM     36  CG2 ILE A   5      27.267  41.773  37.060  1.00 52.21           C  
ATOM     37  CD1 ILE A   5      24.299  40.181  36.313  1.00 52.37           C  
ATOM     38  N   LYS A   6      23.810  44.422  38.052  1.00 51.67           N  
ATOM     39  CA  LYS A   6      22.478  45.005  38.120  1.00 51.44           C  
ATOM     40  C   LYS A   6      21.666  44.631  36.884  1.00 51.19           C  
ATOM     41  O   LYS A   6      22.082  44.889  35.751  1.00 51.13           O  
ATOM     42  CB  LYS A   6      22.569  46.524  38.286  1.00 51.48           C  
ATOM     43  CG  LYS A   6      23.447  46.959  39.452  1.00 51.60           C  
ATOM     44  CD  LYS A   6      23.816  48.428  39.357  1.00 51.98           C  
ATOM     45  CE  LYS A   6      25.002  48.762  40.251  1.00 52.19           C  
ATOM     46  NZ  LYS A   6      26.271  48.155  39.750  1.00 52.31           N  
ATOM     47  N   LEU A   7      20.514  44.007  37.119  1.00 50.90           N  
ATOM     48  CA  LEU A   7      19.633  43.556  36.048  1.00 50.64           C  
ATOM     49  C   LEU A   7      18.467  44.527  35.893  1.00 50.47           C  
ATOM     50  O   LEU A   7      17.815  44.888  36.876  1.00 50.46           O  
ATOM     51  CB  LEU A   7      19.109  42.147  36.350  1.00 50.64           C  
ATOM     52  CG  LEU A   7      19.167  41.062  35.267  1.00 50.60           C  
ATOM     53  CD1 LEU A   7      18.380  39.836  35.710  1.00 50.54           C  
ATOM     54  CD2 LEU A   7      18.660  41.551  33.922  1.00 50.53           C  
ATOM     55  N   GLY A   8      18.212  44.946  34.656  1.00 50.28           N  
ATOM     56  CA  GLY A   8      17.139  45.894  34.367  1.00 50.06           C  
ATOM     57  C   GLY A   8      16.126  45.367  33.371  1.00 49.90           C  
ATOM     58  O   GLY A   8      16.493  44.859  32.312  1.00 49.87           O  
ATOM     59  N   PHE A   9      14.849  45.498  33.717  1.00 49.77           N  
ATOM     60  CA  PHE A   9      13.759  45.030  32.865  1.00 49.61           C  
ATOM     61  C   PHE A   9      12.956  46.194  32.295  1.00 49.47           C  
ATOM     62  O   PHE A   9      12.232  46.881  33.018  1.00 49.40           O  
ATOM     63  CB  PHE A   9      12.845  44.068  33.633  1.00 49.63           C  
ATOM     64  CG  PHE A   9      13.461  42.723  33.890  1.00 49.64           C  
ATOM     65  CD1 PHE A   9      14.187  42.486  35.051  1.00 49.67           C  
ATOM     66  CD2 PHE A   9      13.315  41.692  32.967  1.00 49.72           C  
ATOM     67  CE1 PHE A   9      14.762  41.241  35.290  1.00 49.79           C  
ATOM     68  CE2 PHE A   9      13.886  40.444  33.195  1.00 49.64           C  
ATOM     69  CZ  PHE A   9      14.611  40.218  34.359  1.00 49.75           C  
HETATM   70  N   MSE A  10      13.097  46.411  30.990  1.00 49.33           N  
HETATM   71  CA  MSE A  10      12.353  47.457  30.299  1.00 49.26           C  
HETATM   72  C   MSE A  10      10.968  46.935  29.927  1.00 49.06           C  
HETATM   73  O   MSE A  10      10.783  46.321  28.875  1.00 49.08           O  
HETATM   74  CB  MSE A  10      13.123  47.953  29.069  1.00 49.24           C  
HETATM   75  CG  MSE A  10      14.532  48.445  29.389  1.00 49.41           C  
HETATM   76 SE   MSE A  10      15.414  49.435  27.958  0.80 49.50          SE  
HETATM   77  CE  MSE A  10      15.407  48.069  26.575  1.00 49.45           C  
ATOM     78  N   GLY A  11      10.007  47.175  30.816  1.00 48.82           N  
ATOM     79  CA  GLY A  11       8.646  46.665  30.666  1.00 48.53           C  
ATOM     80  C   GLY A  11       8.398  45.450  31.541  1.00 48.34           C  
ATOM     81  O   GLY A  11       9.171  44.490  31.513  1.00 48.28           O  
ATOM     82  N   LEU A  12       7.325  45.497  32.328  1.00 48.13           N  
ATOM     83  CA  LEU A  12       6.922  44.360  33.157  1.00 47.94           C  
ATOM     84  C   LEU A  12       5.504  43.895  32.839  1.00 47.78           C  
ATOM     85  O   LEU A  12       4.603  43.986  33.677  1.00 47.75           O  
ATOM     86  CB  LEU A  12       7.055  44.676  34.653  1.00 47.95           C  
ATOM     87  CG  LEU A  12       8.388  44.516  35.391  1.00 48.04           C  
ATOM     88  CD1 LEU A  12       8.106  44.355  36.874  1.00 47.99           C  
ATOM     89  CD2 LEU A  12       9.216  43.339  34.894  1.00 47.93           C  
ATOM     90  N   GLY A  13       5.314  43.395  31.622  1.00 47.61           N  
ATOM     91  CA  GLY A  13       4.021  42.869  31.202  1.00 47.40           C  
ATOM     92  C   GLY A  13       3.814  41.453  31.692  1.00 47.23           C  
ATOM     93  O   GLY A  13       4.186  41.116  32.815  1.00 47.27           O  
ATOM     94  N   GLN A  14       3.221  40.620  30.845  1.00 47.05           N  
ATOM     95  CA  GLN A  14       2.975  39.227  31.199  1.00 46.84           C  
ATOM     96  C   GLN A  14       4.252  38.394  31.162  1.00 46.73           C  
ATOM     97  O   GLN A  14       4.436  37.500  31.989  1.00 46.72           O  
ATOM     98  CB  GLN A  14       1.899  38.615  30.300  1.00 46.80           C  
ATOM     99  CG  GLN A  14       0.489  39.171  30.525  1.00 46.71           C  
ATOM    100  CD  GLN A  14      -0.121  38.772  31.864  1.00 46.44           C  
ATOM    101  OE1 GLN A  14       0.388  37.895  32.565  1.00 46.40           O  
ATOM    102  NE2 GLN A  14      -1.225  39.416  32.220  1.00 46.31           N  
HETATM  103  N   MSE A  15       5.130  38.692  30.208  1.00 46.57           N  
HETATM  104  CA  MSE A  15       6.402  37.987  30.100  1.00 46.44           C  
HETATM  105  C   MSE A  15       7.488  38.632  30.956  1.00 46.47           C  
HETATM  106  O   MSE A  15       8.292  37.932  31.575  1.00 46.45           O  
HETATM  107  CB  MSE A  15       6.860  37.893  28.644  1.00 46.31           C  
HETATM  108  CG  MSE A  15       8.022  36.932  28.434  1.00 46.04           C  
HETATM  109 SE   MSE A  15       7.594  35.110  28.984  0.80 44.80          SE  
HETATM  110  CE  MSE A  15       9.061  34.868  30.232  1.00 45.90           C  
ATOM    111  N   GLY A  16       7.505  39.964  30.981  1.00 46.50           N  
ATOM    112  CA  GLY A  16       8.469  40.722  31.775  1.00 46.52           C  
ATOM    113  C   GLY A  16       8.434  40.362  33.249  1.00 46.56           C  
ATOM    114  O   GLY A  16       9.475  40.084  33.844  1.00 46.52           O  
ATOM    115  N   SER A  17       7.234  40.360  33.828  1.00 46.60           N  
ATOM    116  CA  SER A  17       7.044  40.046  35.246  1.00 46.65           C  
ATOM    117  C   SER A  17       7.321  38.578  35.564  1.00 46.70           C  
ATOM    118  O   SER A  17       7.884  38.266  36.614  1.00 46.71           O  
ATOM    119  CB  SER A  17       5.633  40.425  35.701  1.00 46.63           C  
ATOM    120  OG  SER A  17       4.655  39.678  34.999  1.00 46.64           O  
ATOM    121  N   ALA A  18       6.925  37.686  34.656  1.00 46.76           N  
ATOM    122  CA  ALA A  18       7.166  36.250  34.814  1.00 46.84           C  
ATOM    123  C   ALA A  18       8.661  35.929  34.828  1.00 46.93           C  
ATOM    124  O   ALA A  18       9.114  35.087  35.604  1.00 46.89           O  
ATOM    125  CB  ALA A  18       6.461  35.464  33.719  1.00 46.76           C  
ATOM    126  N   LEU A  19       9.417  36.611  33.969  1.00 47.09           N  
ATOM    127  CA  LEU A  19      10.865  36.446  33.906  1.00 47.22           C  
ATOM    128  C   LEU A  19      11.551  37.112  35.094  1.00 47.35           C  
ATOM    129  O   LEU A  19      12.484  36.553  35.668  1.00 47.30           O  
ATOM    130  CB  LEU A  19      11.419  36.995  32.585  1.00 47.19           C  
ATOM    131  CG  LEU A  19      12.882  36.695  32.232  1.00 47.16           C  
ATOM    132  CD1 LEU A  19      13.112  35.201  32.010  1.00 47.06           C  
ATOM    133  CD2 LEU A  19      13.307  37.489  31.005  1.00 47.16           C  
ATOM    134  N   ALA A  20      11.077  38.303  35.455  1.00 47.56           N  
ATOM    135  CA  ALA A  20      11.641  39.068  36.564  1.00 47.81           C  
ATOM    136  C   ALA A  20      11.496  38.334  37.894  1.00 48.01           C  
ATOM    137  O   ALA A  20      12.465  38.210  38.646  1.00 47.99           O  
ATOM    138  CB  ALA A  20      10.999  40.447  36.638  1.00 47.74           C  
ATOM    139  N   HIS A  21      10.290  37.840  38.169  1.00 48.29           N  
ATOM    140  CA  HIS A  21      10.010  37.107  39.404  1.00 48.58           C  
ATOM    141  C   HIS A  21      10.598  35.697  39.391  1.00 48.74           C  
ATOM    142  O   HIS A  21      10.846  35.112  40.447  1.00 48.80           O  
ATOM    143  CB  HIS A  21       8.504  37.062  39.686  1.00 48.61           C  
ATOM    144  CG  HIS A  21       7.869  38.413  39.815  1.00 48.81           C  
ATOM    145  ND1 HIS A  21       6.750  38.780  39.099  1.00 48.92           N  
ATOM    146  CD2 HIS A  21       8.202  39.488  40.568  1.00 48.97           C  
ATOM    147  CE1 HIS A  21       6.417  40.020  39.410  1.00 48.99           C  
ATOM    148  NE2 HIS A  21       7.283  40.472  40.300  1.00 49.02           N  
ATOM    149  N   GLY A  22      10.819  35.160  38.193  1.00 48.92           N  
ATOM    150  CA  GLY A  22      11.463  33.860  38.027  1.00 49.20           C  
ATOM    151  C   GLY A  22      12.916  33.879  38.466  1.00 49.42           C  
ATOM    152  O   GLY A  22      13.396  32.928  39.088  1.00 49.42           O  
ATOM    153  N   ILE A  23      13.610  34.969  38.140  1.00 49.63           N  
ATOM    154  CA  ILE A  23      15.006  35.168  38.532  1.00 49.86           C  
ATOM    155  C   ILE A  23      15.093  35.615  39.995  1.00 50.05           C  
ATOM    156  O   ILE A  23      16.022  35.233  40.714  1.00 50.04           O  
ATOM    157  CB  ILE A  23      15.724  36.185  37.599  1.00 49.82           C  
ATOM    158  CG1 ILE A  23      15.608  35.741  36.136  1.00 49.80           C  
ATOM    159  CG2 ILE A  23      17.199  36.328  37.972  1.00 49.88           C  
ATOM    160  CD1 ILE A  23      15.805  36.855  35.120  1.00 49.77           C  
ATOM    161  N   ALA A  24      14.113  36.412  40.425  1.00 50.32           N  
ATOM    162  CA  ALA A  24      14.039  36.907  41.802  1.00 50.61           C  
ATOM    163  C   ALA A  24      13.903  35.778  42.825  1.00 50.84           C  
ATOM    164  O   ALA A  24      14.536  35.814  43.883  1.00 50.89           O  
ATOM    165  CB  ALA A  24      12.893  37.902  41.950  1.00 50.56           C  
ATOM    166  N   ASN A  25      13.081  34.782  42.498  1.00 51.10           N  
ATOM    167  CA  ASN A  25      12.868  33.624  43.365  1.00 51.36           C  
ATOM    168  C   ASN A  25      14.022  32.624  43.317  1.00 51.52           C  
ATOM    169  O   ASN A  25      14.202  31.827  44.242  1.00 51.58           O  
ATOM    170  CB  ASN A  25      11.546  32.929  43.022  1.00 51.38           C  
ATOM    171  CG  ASN A  25      10.328  33.785  43.341  1.00 51.53           C  
ATOM    172  OD1 ASN A  25      10.423  34.796  44.041  1.00 51.78           O  
ATOM    173  ND2 ASN A  25       9.172  33.379  42.828  1.00 51.55           N  
ATOM    174  N   ALA A  26      14.797  32.675  42.236  1.00 51.68           N  
ATOM    175  CA  ALA A  26      15.939  31.783  42.043  1.00 51.89           C  
ATOM    176  C   ALA A  26      17.140  32.177  42.907  1.00 52.03           C  
ATOM    177  O   ALA A  26      18.023  31.352  43.162  1.00 52.07           O  
ATOM    178  CB  ALA A  26      16.329  31.743  40.577  1.00 51.86           C  
ATOM    179  N   ASN A  27      17.155  33.435  43.348  1.00 52.19           N  
ATOM    180  CA  ASN A  27      18.230  33.997  44.174  1.00 52.34           C  
ATOM    181  C   ASN A  27      19.646  33.731  43.648  1.00 52.34           C  
ATOM    182  O   ASN A  27      20.394  32.918  44.201  1.00 52.44           O  
ATOM    183  CB  ASN A  27      18.086  33.575  45.645  1.00 52.42           C  
ATOM    184  CG  ASN A  27      16.973  34.322  46.359  1.00 52.65           C  
ATOM    185  OD1 ASN A  27      15.789  34.102  46.096  1.00 52.91           O  
ATOM    186  ND2 ASN A  27      17.349  35.209  47.275  1.00 52.76           N  
ATOM    187  N   ILE A  28      19.982  34.417  42.561  1.00 52.27           N  
ATOM    188  CA  ILE A  28      21.335  34.418  42.003  1.00 52.20           C  
ATOM    189  C   ILE A  28      21.876  35.847  41.998  1.00 52.16           C  
ATOM    190  O   ILE A  28      23.089  36.069  41.994  1.00 52.11           O  
ATOM    191  CB  ILE A  28      21.382  33.826  40.572  1.00 52.17           C  
ATOM    192  CG1 ILE A  28      20.209  34.341  39.726  1.00 52.19           C  
ATOM    193  CG2 ILE A  28      21.382  32.303  40.628  1.00 52.16           C  
ATOM    194  CD1 ILE A  28      20.448  34.288  38.233  1.00 52.23           C  
ATOM    195  N   ILE A  29      20.951  36.806  41.991  1.00 52.15           N  
ATOM    196  CA  ILE A  29      21.271  38.227  42.068  1.00 52.22           C  
ATOM    197  C   ILE A  29      20.473  38.838  43.221  1.00 52.23           C  
ATOM    198  O   ILE A  29      19.311  38.484  43.433  1.00 52.28           O  
ATOM    199  CB  ILE A  29      20.937  38.968  40.745  1.00 52.25           C  
ATOM    200  CG1 ILE A  29      21.514  38.221  39.535  1.00 52.25           C  
ATOM    201  CG2 ILE A  29      21.457  40.403  40.785  1.00 52.24           C  
ATOM    202  CD1 ILE A  29      20.900  38.606  38.202  1.00 52.18           C  
ATOM    203  N   LYS A  30      21.106  39.745  43.961  1.00 52.24           N  
ATOM    204  CA  LYS A  30      20.486  40.390  45.121  1.00 52.27           C  
ATOM    205  C   LYS A  30      19.240  41.194  44.748  1.00 52.21           C  
ATOM    206  O   LYS A  30      19.186  41.811  43.683  1.00 52.21           O  
ATOM    207  CB  LYS A  30      21.500  41.279  45.844  1.00 52.31           C  
ATOM    208  CG  LYS A  30      22.601  40.505  46.548  1.00 52.48           C  
ATOM    209  CD  LYS A  30      23.765  41.403  46.917  1.00 52.92           C  
ATOM    210  CE  LYS A  30      24.887  40.600  47.553  1.00 53.27           C  
ATOM    211  NZ  LYS A  30      26.127  41.403  47.708  1.00 53.36           N  
ATOM    212  N   LYS A  31      18.251  41.177  45.642  1.00 52.14           N  
ATOM    213  CA  LYS A  31      16.967  41.851  45.432  1.00 52.07           C  
ATOM    214  C   LYS A  31      17.115  43.338  45.114  1.00 52.04           C  
ATOM    215  O   LYS A  31      16.355  43.886  44.314  1.00 52.06           O  
ATOM    216  CB  LYS A  31      16.064  41.664  46.653  1.00 52.07           C  
ATOM    217  N   GLU A  32      18.101  43.979  45.740  1.00 52.00           N  
ATOM    218  CA  GLU A  32      18.375  45.401  45.526  1.00 51.94           C  
ATOM    219  C   GLU A  32      19.118  45.684  44.215  1.00 51.80           C  
ATOM    220  O   GLU A  32      19.437  46.835  43.910  1.00 51.81           O  
ATOM    221  CB  GLU A  32      19.124  46.011  46.724  1.00 52.04           C  
ATOM    222  CG  GLU A  32      20.339  45.217  47.221  1.00 52.19           C  
ATOM    223  CD  GLU A  32      19.981  44.129  48.228  1.00 52.48           C  
ATOM    224  OE1 GLU A  32      20.844  43.268  48.498  1.00 52.69           O  
ATOM    225  OE2 GLU A  32      18.843  44.130  48.750  1.00 52.37           O  
ATOM    226  N   ASN A  33      19.382  44.628  43.447  1.00 51.64           N  
ATOM    227  CA  ASN A  33      20.042  44.748  42.148  1.00 51.47           C  
ATOM    228  C   ASN A  33      19.139  44.379  40.963  1.00 51.39           C  
ATOM    229  O   ASN A  33      19.603  44.270  39.826  1.00 51.35           O  
ATOM    230  CB  ASN A  33      21.340  43.930  42.124  1.00 51.46           C  
ATOM    231  CG  ASN A  33      22.431  44.537  42.991  1.00 51.37           C  
ATOM    232  OD1 ASN A  33      22.399  45.725  43.319  1.00 51.29           O  
ATOM    233  ND2 ASN A  33      23.410  43.721  43.359  1.00 51.27           N  
ATOM    234  N   LEU A  34      17.851  44.188  41.242  1.00 51.23           N  
ATOM    235  CA  LEU A  34      16.853  43.969  40.198  1.00 51.30           C  
ATOM    236  C   LEU A  34      15.995  45.218  40.014  1.00 51.45           C  
ATOM    237  O   LEU A  34      15.355  45.688  40.958  1.00 51.36           O  
ATOM    238  CB  LEU A  34      15.981  42.749  40.517  1.00 51.17           C  
ATOM    239  CG  LEU A  34      16.377  41.395  39.919  1.00 51.32           C  
ATOM    240  CD1 LEU A  34      17.706  40.889  40.463  1.00 51.53           C  
ATOM    241  CD2 LEU A  34      15.283  40.368  40.170  1.00 51.34           C  
ATOM    242  N   PHE A  35      15.997  45.747  38.792  1.00 51.81           N  
ATOM    243  CA  PHE A  35      15.310  47.002  38.479  1.00 52.25           C  
ATOM    244  C   PHE A  35      14.342  46.851  37.307  1.00 52.52           C  
ATOM    245  O   PHE A  35      14.455  45.910  36.516  1.00 52.51           O  
ATOM    246  CB  PHE A  35      16.326  48.111  38.174  1.00 52.28           C  
ATOM    247  CG  PHE A  35      17.334  48.335  39.270  1.00 52.47           C  
ATOM    248  CD1 PHE A  35      18.584  47.723  39.218  1.00 52.71           C  
ATOM    249  CD2 PHE A  35      17.037  49.162  40.350  1.00 52.71           C  
ATOM    250  CE1 PHE A  35      19.521  47.928  40.227  1.00 52.89           C  
ATOM    251  CE2 PHE A  35      17.967  49.373  41.364  1.00 52.85           C  
ATOM    252  CZ  PHE A  35      19.212  48.755  41.302  1.00 52.75           C  
ATOM    253  N   TYR A  36      13.394  47.782  37.204  1.00 52.95           N  
ATOM    254  CA  TYR A  36      12.425  47.798  36.108  1.00 53.40           C  
ATOM    255  C   TYR A  36      11.881  49.200  35.823  1.00 53.75           C  
ATOM    256  O   TYR A  36      11.923  50.080  36.687  1.00 53.77           O  
ATOM    257  CB  TYR A  36      11.263  46.833  36.394  1.00 53.35           C  
ATOM    258  CG  TYR A  36      10.125  47.436  37.193  1.00 53.37           C  
ATOM    259  CD1 TYR A  36      10.193  47.530  38.583  1.00 53.35           C  
ATOM    260  CD2 TYR A  36       8.976  47.911  36.557  1.00 53.33           C  
ATOM    261  CE1 TYR A  36       9.148  48.085  39.319  1.00 53.30           C  
ATOM    262  CE2 TYR A  36       7.926  48.467  37.281  1.00 53.31           C  
ATOM    263  CZ  TYR A  36       8.018  48.551  38.661  1.00 53.33           C  
ATOM    264  OH  TYR A  36       6.982  49.099  39.381  1.00 53.36           O  
ATOM    265  N   TYR A  37      11.376  49.394  34.605  1.00 54.24           N  
ATOM    266  CA  TYR A  37      10.580  50.575  34.266  1.00 54.72           C  
ATOM    267  C   TYR A  37       9.357  50.217  33.425  1.00 55.33           C  
ATOM    268  O   TYR A  37       9.416  49.347  32.555  1.00 55.33           O  
ATOM    269  CB  TYR A  37      11.410  51.650  33.547  1.00 54.42           C  
ATOM    270  CG  TYR A  37      10.556  52.749  32.934  1.00 54.01           C  
ATOM    271  CD1 TYR A  37      10.019  53.767  33.722  1.00 53.61           C  
ATOM    272  CD2 TYR A  37      10.259  52.750  31.570  1.00 53.61           C  
ATOM    273  CE1 TYR A  37       9.223  54.765  33.165  1.00 53.50           C  
ATOM    274  CE2 TYR A  37       9.466  53.743  31.004  1.00 53.46           C  
ATOM    275  CZ  TYR A  37       8.952  54.746  31.807  1.00 53.61           C  
ATOM    276  OH  TYR A  37       8.168  55.729  31.250  1.00 53.79           O  
ATOM    277  N   GLY A  38       8.256  50.909  33.704  1.00 56.14           N  
ATOM    278  CA  GLY A  38       7.050  50.859  32.888  1.00 57.19           C  
ATOM    279  C   GLY A  38       6.324  52.191  32.975  1.00 58.01           C  
ATOM    280  O   GLY A  38       6.565  52.962  33.907  1.00 58.02           O  
ATOM    281  N   PRO A  39       5.430  52.477  32.006  1.00 58.71           N  
ATOM    282  CA  PRO A  39       4.634  53.709  32.037  1.00 59.34           C  
ATOM    283  C   PRO A  39       3.695  53.763  33.245  1.00 59.97           C  
ATOM    284  O   PRO A  39       3.182  54.831  33.583  1.00 60.05           O  
ATOM    285  CB  PRO A  39       3.831  53.643  30.733  1.00 59.32           C  
ATOM    286  CG  PRO A  39       3.816  52.205  30.358  1.00 59.08           C  
ATOM    287  CD  PRO A  39       5.124  51.656  30.822  1.00 58.78           C  
ATOM    288  N   SER A  40       3.483  52.610  33.875  1.00 60.71           N  
ATOM    289  CA  SER A  40       2.734  52.506  35.120  1.00 61.42           C  
ATOM    290  C   SER A  40       3.456  51.563  36.077  1.00 61.86           C  
ATOM    291  O   SER A  40       3.985  50.530  35.657  1.00 61.96           O  
ATOM    292  CB  SER A  40       1.316  51.999  34.855  1.00 61.42           C  
ATOM    293  OG  SER A  40       0.596  52.902  34.035  1.00 61.62           O  
ATOM    294  N   LYS A  41       3.480  51.930  37.358  1.00 62.40           N  
ATOM    295  CA  LYS A  41       4.114  51.113  38.395  1.00 62.89           C  
ATOM    296  C   LYS A  41       3.374  49.792  38.576  1.00 63.20           C  
ATOM    297  O   LYS A  41       2.143  49.747  38.516  1.00 63.29           O  
ATOM    298  CB  LYS A  41       4.185  51.872  39.723  1.00 62.93           C  
ATOM    299  CG  LYS A  41       5.201  53.004  39.746  1.00 62.96           C  
ATOM    300  CD  LYS A  41       5.402  53.546  41.153  1.00 63.02           C  
ATOM    301  CE  LYS A  41       6.430  54.668  41.164  1.00 63.06           C  
ATOM    302  NZ  LYS A  41       6.786  55.090  42.548  1.00 63.08           N  
ATOM    303  N   LYS A  42       4.133  48.723  38.795  1.00 63.54           N  
ATOM    304  CA  LYS A  42       3.569  47.380  38.869  1.00 63.81           C  
ATOM    305  C   LYS A  42       3.667  46.803  40.279  1.00 63.99           C  
ATOM    306  O   LYS A  42       4.539  47.193  41.060  1.00 64.05           O  
ATOM    307  CB  LYS A  42       4.278  46.460  37.870  1.00 63.83           C  
ATOM    308  CG  LYS A  42       3.339  45.630  37.007  1.00 63.90           C  
ATOM    309  CD  LYS A  42       2.787  46.448  35.842  1.00 64.03           C  
ATOM    310  CE  LYS A  42       1.835  45.630  34.987  1.00 64.09           C  
ATOM    311  NZ  LYS A  42       1.313  46.414  33.836  1.00 64.01           N  
ATOM    312  N   ASN A  43       2.758  45.884  40.601  1.00 64.19           N  
ATOM    313  CA  ASN A  43       2.812  45.156  41.865  1.00 64.36           C  
ATOM    314  C   ASN A  43       3.923  44.111  41.812  1.00 64.47           C  
ATOM    315  O   ASN A  43       3.696  42.959  41.430  1.00 64.48           O  
ATOM    316  CB  ASN A  43       1.459  44.511  42.180  1.00 64.34           C  
ATOM    317  N   THR A  44       5.130  44.533  42.186  1.00 64.64           N  
ATOM    318  CA  THR A  44       6.329  43.706  42.053  1.00 64.72           C  
ATOM    319  C   THR A  44       7.367  43.998  43.141  1.00 64.63           C  
ATOM    320  O   THR A  44       7.373  45.079  43.738  1.00 64.66           O  
ATOM    321  CB  THR A  44       6.969  43.861  40.643  1.00 64.77           C  
ATOM    322  OG1 THR A  44       8.175  43.090  40.566  1.00 64.92           O  
ATOM    323  CG2 THR A  44       7.282  45.320  40.338  1.00 64.88           C  
ATOM    324  N   THR A  45       8.239  43.022  43.388  1.00 64.47           N  
ATOM    325  CA  THR A  45       9.309  43.152  44.377  1.00 64.25           C  
ATOM    326  C   THR A  45      10.521  43.902  43.816  1.00 64.02           C  
ATOM    327  O   THR A  45      11.385  44.354  44.573  1.00 64.04           O  
ATOM    328  CB  THR A  45       9.759  41.772  44.919  1.00 64.32           C  
ATOM    329  OG1 THR A  45      10.148  40.927  43.829  1.00 64.26           O  
ATOM    330  CG2 THR A  45       8.634  41.103  45.703  1.00 64.27           C  
ATOM    331  N   LEU A  46      10.572  44.032  42.491  1.00 63.63           N  
ATOM    332  CA  LEU A  46      11.662  44.729  41.807  1.00 63.17           C  
ATOM    333  C   LEU A  46      11.613  46.237  42.025  1.00 62.79           C  
ATOM    334  O   LEU A  46      10.538  46.818  42.191  1.00 62.79           O  
ATOM    335  CB  LEU A  46      11.653  44.410  40.308  1.00 63.21           C  
ATOM    336  CG  LEU A  46      12.359  43.124  39.868  1.00 63.10           C  
ATOM    337  CD1 LEU A  46      11.489  41.889  40.082  1.00 63.11           C  
ATOM    338  CD2 LEU A  46      12.779  43.235  38.413  1.00 63.08           C  
ATOM    339  N   ASN A  47      12.790  46.860  42.023  1.00 62.23           N  
ATOM    340  CA  ASN A  47      12.918  48.292  42.281  1.00 61.68           C  
ATOM    341  C   ASN A  47      12.585  49.139  41.054  1.00 61.13           C  
ATOM    342  O   ASN A  47      13.178  48.965  39.988  1.00 61.07           O  
ATOM    343  CB  ASN A  47      14.327  48.618  42.791  1.00 61.80           C  
ATOM    344  CG  ASN A  47      14.673  47.873  44.069  1.00 62.03           C  
ATOM    345  OD1 ASN A  47      14.060  48.089  45.115  1.00 62.38           O  
ATOM    346  ND2 ASN A  47      15.664  46.992  43.988  1.00 62.35           N  
ATOM    347  N   TYR A  48      11.629  50.052  41.219  1.00 60.42           N  
ATOM    348  CA  TYR A  48      11.197  50.936  40.139  1.00 59.73           C  
ATOM    349  C   TYR A  48      12.263  51.973  39.796  1.00 59.00           C  
ATOM    350  O   TYR A  48      12.946  52.496  40.681  1.00 58.88           O  
ATOM    351  CB  TYR A  48       9.880  51.630  40.505  1.00 60.07           C  
ATOM    352  CG  TYR A  48       9.324  52.535  39.423  1.00 60.54           C  
ATOM    353  CD1 TYR A  48       8.557  52.016  38.379  1.00 61.02           C  
ATOM    354  CD2 TYR A  48       9.562  53.911  39.444  1.00 61.04           C  
ATOM    355  CE1 TYR A  48       8.046  52.843  37.381  1.00 61.23           C  
ATOM    356  CE2 TYR A  48       9.054  54.746  38.454  1.00 61.24           C  
ATOM    357  CZ  TYR A  48       8.296  54.206  37.426  1.00 61.09           C  
ATOM    358  OH  TYR A  48       7.792  55.028  36.444  1.00 60.96           O  
HETATM  359  N   MSE A  49      12.397  52.258  38.504  1.00 58.11           N  
HETATM  360  CA  MSE A  49      13.309  53.293  38.032  1.00 57.30           C  
HETATM  361  C   MSE A  49      12.567  54.291  37.146  1.00 57.00           C  
HETATM  362  O   MSE A  49      11.584  53.937  36.490  1.00 56.84           O  
HETATM  363  CB  MSE A  49      14.497  52.672  37.300  1.00 57.09           C  
HETATM  364  CG  MSE A  49      15.811  53.353  37.617  1.00 56.74           C  
HETATM  365 SE   MSE A  49      17.267  52.083  37.843  0.80 57.19          SE  
HETATM  366  CE  MSE A  49      18.397  53.160  39.014  1.00 56.20           C  
ATOM    367  N   SER A  50      13.046  55.534  37.138  1.00 56.73           N  
ATOM    368  CA  SER A  50      12.340  56.662  36.521  1.00 56.57           C  
ATOM    369  C   SER A  50      12.122  56.546  35.009  1.00 56.52           C  
ATOM    370  O   SER A  50      11.088  56.981  34.497  1.00 56.46           O  
ATOM    371  CB  SER A  50      13.054  57.975  36.852  1.00 56.49           C  
ATOM    372  OG  SER A  50      12.281  59.094  36.453  1.00 56.67           O  
ATOM    373  N   SER A  51      13.094  55.969  34.303  1.00 56.56           N  
ATOM    374  CA  SER A  51      13.013  55.803  32.849  1.00 56.67           C  
ATOM    375  C   SER A  51      13.866  54.633  32.357  1.00 56.78           C  
ATOM    376  O   SER A  51      14.653  54.066  33.118  1.00 56.79           O  
ATOM    377  CB  SER A  51      13.431  57.095  32.136  1.00 56.66           C  
ATOM    378  OG  SER A  51      14.787  57.414  32.396  1.00 56.61           O  
ATOM    379  N   ASN A  52      13.698  54.280  31.082  1.00 56.90           N  
ATOM    380  CA  ASN A  52      14.515  53.252  30.437  1.00 57.04           C  
ATOM    381  C   ASN A  52      15.968  53.683  30.275  1.00 57.07           C  
ATOM    382  O   ASN A  52      16.878  52.855  30.345  1.00 57.11           O  
ATOM    383  CB  ASN A  52      13.935  52.878  29.069  1.00 57.11           C  
ATOM    384  CG  ASN A  52      12.642  52.086  29.170  1.00 57.28           C  
ATOM    385  OD1 ASN A  52      11.721  52.288  28.380  1.00 57.43           O  
ATOM    386  ND2 ASN A  52      12.570  51.178  30.138  1.00 57.41           N  
ATOM    387  N   GLU A  53      16.171  54.980  30.056  1.00 57.10           N  
ATOM    388  CA  GLU A  53      17.503  55.562  29.881  1.00 57.09           C  
ATOM    389  C   GLU A  53      18.314  55.502  31.171  1.00 56.93           C  
ATOM    390  O   GLU A  53      19.495  55.151  31.153  1.00 56.93           O  
ATOM    391  CB  GLU A  53      17.403  57.012  29.395  1.00 57.18           C  
ATOM    392  CG  GLU A  53      16.801  57.184  27.999  1.00 57.57           C  
ATOM    393  CD  GLU A  53      15.285  57.343  28.000  1.00 57.99           C  
ATOM    394  OE1 GLU A  53      14.621  56.917  28.972  1.00 58.09           O  
ATOM    395  OE2 GLU A  53      14.751  57.897  27.016  1.00 58.22           O  
ATOM    396  N   GLU A  54      17.670  55.852  32.282  1.00 56.61           N  
ATOM    397  CA  GLU A  54      18.293  55.794  33.603  1.00 56.34           C  
ATOM    398  C   GLU A  54      18.450  54.353  34.083  1.00 56.05           C  
ATOM    399  O   GLU A  54      19.322  54.057  34.903  1.00 56.08           O  
ATOM    400  CB  GLU A  54      17.493  56.620  34.611  1.00 56.39           C  
ATOM    401  CG  GLU A  54      17.717  58.123  34.482  1.00 56.71           C  
ATOM    402  CD  GLU A  54      16.601  58.943  35.103  1.00 57.25           C  
ATOM    403  OE1 GLU A  54      15.424  58.718  34.748  1.00 57.48           O  
ATOM    404  OE2 GLU A  54      16.904  59.826  35.934  1.00 57.45           O  
ATOM    405  N   LEU A  55      17.600  53.466  33.566  1.00 55.66           N  
ATOM    406  CA  LEU A  55      17.722  52.031  33.802  1.00 55.27           C  
ATOM    407  C   LEU A  55      18.934  51.471  33.058  1.00 55.02           C  
ATOM    408  O   LEU A  55      19.683  50.666  33.606  1.00 55.03           O  
ATOM    409  CB  LEU A  55      16.440  51.305  33.374  1.00 55.28           C  
ATOM    410  CG  LEU A  55      16.328  49.782  33.531  1.00 55.18           C  
ATOM    411  CD1 LEU A  55      14.889  49.386  33.795  1.00 55.12           C  
ATOM    412  CD2 LEU A  55      16.869  49.046  32.309  1.00 55.07           C  
ATOM    413  N   ALA A  56      19.116  51.906  31.812  1.00 54.66           N  
ATOM    414  CA  ALA A  56      20.231  51.455  30.981  1.00 54.33           C  
ATOM    415  C   ALA A  56      21.568  52.021  31.454  1.00 54.08           C  
ATOM    416  O   ALA A  56      22.609  51.381  31.296  1.00 54.07           O  
ATOM    417  CB  ALA A  56      19.987  51.814  29.519  1.00 54.35           C  
ATOM    418  N   ARG A  57      21.530  53.220  32.032  1.00 53.79           N  
ATOM    419  CA  ARG A  57      22.730  53.888  32.537  1.00 53.43           C  
ATOM    420  C   ARG A  57      23.207  53.293  33.862  1.00 53.17           C  
ATOM    421  O   ARG A  57      24.394  53.364  34.187  1.00 53.18           O  
ATOM    422  CB  ARG A  57      22.479  55.389  32.697  1.00 53.43           C  
ATOM    423  N   HIS A  58      22.279  52.701  34.610  1.00 52.80           N  
ATOM    424  CA  HIS A  58      22.576  52.138  35.927  1.00 52.42           C  
ATOM    425  C   HIS A  58      22.915  50.649  35.863  1.00 52.04           C  
ATOM    426  O   HIS A  58      23.904  50.207  36.453  1.00 52.05           O  
ATOM    427  CB  HIS A  58      21.397  52.373  36.876  1.00 52.48           C  
ATOM    428  CG  HIS A  58      21.679  52.002  38.298  1.00 52.79           C  
ATOM    429  ND1 HIS A  58      22.438  52.789  39.137  1.00 53.12           N  
ATOM    430  CD2 HIS A  58      21.292  50.933  39.034  1.00 53.01           C  
ATOM    431  CE1 HIS A  58      22.512  52.218  40.326  1.00 53.17           C  
ATOM    432  NE2 HIS A  58      21.824  51.091  40.290  1.00 53.20           N  
ATOM    433  N   CYS A  59      22.093  49.888  35.141  1.00 51.50           N  
ATOM    434  CA  CYS A  59      22.213  48.433  35.084  1.00 50.95           C  
ATOM    435  C   CYS A  59      23.334  47.956  34.166  1.00 50.60           C  
ATOM    436  O   CYS A  59      23.736  48.662  33.241  1.00 50.54           O  
ATOM    437  CB  CYS A  59      20.883  47.809  34.663  1.00 50.96           C  
ATOM    438  SG  CYS A  59      19.520  48.219  35.764  1.00 50.90           S  
ATOM    439  N   ASP A  60      23.830  46.749  34.437  1.00 50.16           N  
ATOM    440  CA  ASP A  60      24.896  46.133  33.648  1.00 49.72           C  
ATOM    441  C   ASP A  60      24.319  45.269  32.530  1.00 49.39           C  
ATOM    442  O   ASP A  60      24.875  45.206  31.433  1.00 49.36           O  
ATOM    443  CB  ASP A  60      25.806  45.289  34.545  1.00 49.75           C  
ATOM    444  CG  ASP A  60      26.361  46.072  35.718  1.00 49.78           C  
ATOM    445  OD1 ASP A  60      27.233  46.941  35.501  1.00 49.99           O  
ATOM    446  OD2 ASP A  60      25.926  45.813  36.859  1.00 49.77           O  
ATOM    447  N   ILE A  61      23.210  44.597  32.831  1.00 48.97           N  
ATOM    448  CA  ILE A  61      22.481  43.800  31.849  1.00 48.51           C  
ATOM    449  C   ILE A  61      21.060  44.349  31.711  1.00 48.25           C  
ATOM    450  O   ILE A  61      20.328  44.464  32.697  1.00 48.12           O  
ATOM    451  CB  ILE A  61      22.475  42.289  32.211  1.00 48.53           C  
ATOM    452  CG1 ILE A  61      23.886  41.704  32.066  1.00 48.52           C  
ATOM    453  CG2 ILE A  61      21.483  41.519  31.336  1.00 48.40           C  
ATOM    454  CD1 ILE A  61      24.050  40.290  32.603  1.00 48.46           C  
ATOM    455  N   ILE A  62      20.691  44.696  30.480  1.00 47.93           N  
ATOM    456  CA  ILE A  62      19.391  45.298  30.191  1.00 47.68           C  
ATOM    457  C   ILE A  62      18.518  44.326  29.399  1.00 47.50           C  
ATOM    458  O   ILE A  62      18.954  43.762  28.394  1.00 47.47           O  
ATOM    459  CB  ILE A  62      19.536  46.649  29.428  1.00 47.63           C  
ATOM    460  CG1 ILE A  62      20.381  47.650  30.228  1.00 47.66           C  
ATOM    461  CG2 ILE A  62      18.176  47.265  29.143  1.00 47.63           C  
ATOM    462  CD1 ILE A  62      21.866  47.641  29.889  1.00 47.64           C  
ATOM    463  N   VAL A  63      17.289  44.131  29.871  1.00 47.36           N  
ATOM    464  CA  VAL A  63      16.330  43.244  29.216  1.00 47.25           C  
ATOM    465  C   VAL A  63      15.224  44.057  28.547  1.00 47.21           C  
ATOM    466  O   VAL A  63      14.527  44.834  29.204  1.00 47.13           O  
ATOM    467  CB  VAL A  63      15.707  42.220  30.205  1.00 47.21           C  
ATOM    468  CG1 VAL A  63      14.778  41.255  29.477  1.00 47.19           C  
ATOM    469  CG2 VAL A  63      16.790  41.447  30.932  1.00 47.10           C  
ATOM    470  N   CYS A  64      15.083  43.877  27.236  1.00 47.19           N  
ATOM    471  CA  CYS A  64      14.019  44.518  26.471  1.00 47.19           C  
ATOM    472  C   CYS A  64      12.773  43.638  26.489  1.00 47.21           C  
ATOM    473  O   CYS A  64      12.679  42.661  25.742  1.00 47.16           O  
ATOM    474  CB  CYS A  64      14.476  44.789  25.035  1.00 47.17           C  
ATOM    475  SG  CYS A  64      13.365  45.852  24.088  1.00 47.13           S  
ATOM    476  N   ALA A  65      11.825  43.989  27.354  1.00 47.29           N  
ATOM    477  CA  ALA A  65      10.625  43.179  27.570  1.00 47.36           C  
ATOM    478  C   ALA A  65       9.342  43.872  27.102  1.00 47.41           C  
ATOM    479  O   ALA A  65       8.253  43.596  27.610  1.00 47.44           O  
ATOM    480  CB  ALA A  65      10.520  42.771  29.039  1.00 47.27           C  
ATOM    481  N   VAL A  66       9.479  44.773  26.131  1.00 47.49           N  
ATOM    482  CA  VAL A  66       8.331  45.462  25.544  1.00 47.60           C  
ATOM    483  C   VAL A  66       7.821  44.718  24.311  1.00 47.74           C  
ATOM    484  O   VAL A  66       8.504  43.834  23.789  1.00 47.75           O  
ATOM    485  CB  VAL A  66       8.659  46.936  25.163  1.00 47.52           C  
ATOM    486  CG1 VAL A  66       8.927  47.768  26.403  1.00 47.47           C  
ATOM    487  CG2 VAL A  66       9.836  47.012  24.199  1.00 47.47           C  
ATOM    488  N   LYS A  67       6.621  45.078  23.857  1.00 47.94           N  
ATOM    489  CA  LYS A  67       6.079  44.583  22.593  1.00 48.14           C  
ATOM    490  C   LYS A  67       6.976  45.015  21.427  1.00 48.29           C  
ATOM    491  O   LYS A  67       7.537  46.112  21.457  1.00 48.26           O  
ATOM    492  CB  LYS A  67       4.648  45.092  22.392  1.00 48.16           C  
ATOM    493  CG  LYS A  67       3.591  44.325  23.190  1.00 48.19           C  
ATOM    494  CD  LYS A  67       2.281  45.103  23.306  1.00 48.24           C  
ATOM    495  CE  LYS A  67       1.559  45.206  21.969  1.00 48.54           C  
ATOM    496  NZ  LYS A  67       0.348  46.067  22.042  1.00 48.65           N  
ATOM    497  N   PRO A  68       7.123  44.150  20.403  1.00 48.49           N  
ATOM    498  CA  PRO A  68       8.054  44.399  19.295  1.00 48.69           C  
ATOM    499  C   PRO A  68       7.766  45.664  18.483  1.00 48.94           C  
ATOM    500  O   PRO A  68       8.686  46.229  17.886  1.00 48.98           O  
ATOM    501  CB  PRO A  68       7.885  43.157  18.411  1.00 48.68           C  
ATOM    502  CG  PRO A  68       7.332  42.117  19.318  1.00 48.55           C  
ATOM    503  CD  PRO A  68       6.420  42.867  20.229  1.00 48.49           C  
ATOM    504  N   ASP A  69       6.509  46.101  18.470  1.00 49.26           N  
ATOM    505  CA  ASP A  69       6.095  47.295  17.725  1.00 49.55           C  
ATOM    506  C   ASP A  69       6.591  48.603  18.349  1.00 49.71           C  
ATOM    507  O   ASP A  69       6.771  49.597  17.646  1.00 49.76           O  
ATOM    508  CB  ASP A  69       4.572  47.323  17.549  1.00 49.58           C  
ATOM    509  CG  ASP A  69       3.827  47.228  18.867  1.00 49.70           C  
ATOM    510  OD1 ASP A  69       3.663  48.268  19.538  1.00 49.70           O  
ATOM    511  OD2 ASP A  69       3.394  46.112  19.224  1.00 49.98           O  
ATOM    512  N   ILE A  70       6.806  48.596  19.663  1.00 49.93           N  
ATOM    513  CA  ILE A  70       7.345  49.764  20.371  1.00 50.15           C  
ATOM    514  C   ILE A  70       8.803  49.582  20.805  1.00 50.28           C  
ATOM    515  O   ILE A  70       9.389  50.472  21.427  1.00 50.27           O  
ATOM    516  CB  ILE A  70       6.482  50.166  21.600  1.00 50.14           C  
ATOM    517  CG1 ILE A  70       6.234  48.962  22.517  1.00 50.16           C  
ATOM    518  CG2 ILE A  70       5.176  50.810  21.147  1.00 50.23           C  
ATOM    519  CD1 ILE A  70       5.899  49.328  23.946  1.00 50.15           C  
ATOM    520  N   ALA A  71       9.382  48.433  20.463  1.00 50.47           N  
ATOM    521  CA  ALA A  71      10.771  48.123  20.804  1.00 50.66           C  
ATOM    522  C   ALA A  71      11.775  49.008  20.067  1.00 50.82           C  
ATOM    523  O   ALA A  71      12.864  49.269  20.576  1.00 50.83           O  
ATOM    524  CB  ALA A  71      11.065  46.655  20.544  1.00 50.60           C  
ATOM    525  N   GLY A  72      11.398  49.469  18.876  1.00 51.00           N  
ATOM    526  CA  GLY A  72      12.259  50.312  18.049  1.00 51.23           C  
ATOM    527  C   GLY A  72      12.581  51.667  18.652  1.00 51.41           C  
ATOM    528  O   GLY A  72      13.719  52.128  18.573  1.00 51.36           O  
ATOM    529  N   SER A  73      11.577  52.303  19.253  1.00 51.64           N  
ATOM    530  CA  SER A  73      11.752  53.613  19.880  1.00 51.86           C  
ATOM    531  C   SER A  73      12.452  53.505  21.234  1.00 52.02           C  
ATOM    532  O   SER A  73      13.333  54.310  21.545  1.00 52.03           O  
ATOM    533  CB  SER A  73      10.408  54.335  20.028  1.00 51.85           C  
ATOM    534  OG  SER A  73       9.537  53.633  20.897  1.00 51.85           O  
ATOM    535  N   VAL A  74      12.055  52.506  22.023  1.00 52.20           N  
ATOM    536  CA  VAL A  74      12.624  52.260  23.353  1.00 52.34           C  
ATOM    537  C   VAL A  74      14.130  51.990  23.272  1.00 52.45           C  
ATOM    538  O   VAL A  74      14.908  52.543  24.054  1.00 52.47           O  
ATOM    539  CB  VAL A  74      11.891  51.094  24.085  1.00 52.31           C  
ATOM    540  CG1 VAL A  74      12.629  50.686  25.356  1.00 52.27           C  
ATOM    541  CG2 VAL A  74      10.458  51.487  24.418  1.00 52.36           C  
ATOM    542  N   LEU A  75      14.530  51.155  22.317  1.00 52.61           N  
ATOM    543  CA  LEU A  75      15.938  50.821  22.113  1.00 52.80           C  
ATOM    544  C   LEU A  75      16.733  51.983  21.517  1.00 52.97           C  
ATOM    545  O   LEU A  75      17.934  52.110  21.764  1.00 52.99           O  
ATOM    546  CB  LEU A  75      16.080  49.568  21.241  1.00 52.76           C  
ATOM    547  CG  LEU A  75      15.734  48.215  21.876  1.00 52.74           C  
ATOM    548  CD1 LEU A  75      15.689  47.122  20.821  1.00 52.73           C  
ATOM    549  CD2 LEU A  75      16.713  47.850  22.985  1.00 52.68           C  
ATOM    550  N   ASN A  76      16.053  52.827  20.742  1.00 53.17           N  
ATOM    551  CA  ASN A  76      16.659  54.025  20.165  1.00 53.34           C  
ATOM    552  C   ASN A  76      16.935  55.093  21.226  1.00 53.43           C  
ATOM    553  O   ASN A  76      17.878  55.876  21.101  1.00 53.46           O  
ATOM    554  CB  ASN A  76      15.766  54.594  19.060  1.00 53.38           C  
ATOM    555  CG  ASN A  76      16.521  55.489  18.098  1.00 53.50           C  
ATOM    556  OD1 ASN A  76      16.861  56.628  18.423  1.00 53.40           O  
ATOM    557  ND2 ASN A  76      16.778  54.979  16.899  1.00 53.66           N  
ATOM    558  N   ASN A  77      16.103  55.112  22.265  1.00 53.52           N  
ATOM    559  CA  ASN A  77      16.265  56.042  23.380  1.00 53.61           C  
ATOM    560  C   ASN A  77      17.413  55.665  24.316  1.00 53.65           C  
ATOM    561  O   ASN A  77      18.056  56.540  24.900  1.00 53.66           O  
ATOM    562  CB  ASN A  77      14.957  56.166  24.167  1.00 53.60           C  
ATOM    563  CG  ASN A  77      13.858  56.863  23.376  1.00 53.74           C  
ATOM    564  OD1 ASN A  77      14.128  57.646  22.462  1.00 53.68           O  
ATOM    565  ND2 ASN A  77      12.609  56.582  23.732  1.00 53.75           N  
ATOM    566  N   ILE A  78      17.665  54.363  24.449  1.00 53.67           N  
ATOM    567  CA  ILE A  78      18.747  53.854  25.300  1.00 53.66           C  
ATOM    568  C   ILE A  78      20.026  53.571  24.502  1.00 53.68           C  
ATOM    569  O   ILE A  78      21.018  53.081  25.052  1.00 53.66           O  
ATOM    570  CB  ILE A  78      18.321  52.582  26.089  1.00 53.67           C  
ATOM    571  CG1 ILE A  78      18.115  51.389  25.146  1.00 53.64           C  
ATOM    572  CG2 ILE A  78      17.070  52.854  26.916  1.00 53.65           C  
ATOM    573  CD1 ILE A  78      18.455  50.049  25.769  1.00 53.72           C  
ATOM    574  N   LYS A  79      19.989  53.901  23.211  1.00 53.72           N  
ATOM    575  CA  LYS A  79      21.084  53.646  22.265  1.00 53.78           C  
ATOM    576  C   LYS A  79      22.483  54.102  22.731  1.00 53.73           C  
ATOM    577  O   LYS A  79      23.434  53.319  22.649  1.00 53.72           O  
ATOM    578  CB  LYS A  79      20.744  54.244  20.890  1.00 53.79           C  
ATOM    579  CG  LYS A  79      21.609  53.758  19.737  1.00 53.89           C  
ATOM    580  CD  LYS A  79      21.281  54.515  18.454  1.00 53.92           C  
ATOM    581  CE  LYS A  79      22.009  53.935  17.248  1.00 54.29           C  
ATOM    582  NZ  LYS A  79      23.482  54.162  17.292  1.00 54.35           N  
ATOM    583  N   PRO A  80      22.617  55.358  23.218  1.00 53.70           N  
ATOM    584  CA  PRO A  80      23.953  55.801  23.630  1.00 53.66           C  
ATOM    585  C   PRO A  80      24.384  55.324  25.025  1.00 53.59           C  
ATOM    586  O   PRO A  80      25.544  55.508  25.404  1.00 53.62           O  
ATOM    587  CB  PRO A  80      23.826  57.326  23.610  1.00 53.67           C  
ATOM    588  CG  PRO A  80      22.407  57.577  23.959  1.00 53.71           C  
ATOM    589  CD  PRO A  80      21.613  56.427  23.399  1.00 53.67           C  
ATOM    590  N   TYR A  81      23.465  54.712  25.770  1.00 53.48           N  
ATOM    591  CA  TYR A  81      23.733  54.290  27.148  1.00 53.34           C  
ATOM    592  C   TYR A  81      24.122  52.812  27.270  1.00 53.17           C  
ATOM    593  O   TYR A  81      24.303  52.303  28.379  1.00 53.19           O  
ATOM    594  CB  TYR A  81      22.527  54.596  28.046  1.00 53.44           C  
ATOM    595  CG  TYR A  81      22.001  56.011  27.925  1.00 53.64           C  
ATOM    596  CD1 TYR A  81      20.856  56.286  27.176  1.00 53.75           C  
ATOM    597  CD2 TYR A  81      22.648  57.076  28.556  1.00 53.79           C  
ATOM    598  CE1 TYR A  81      20.368  57.584  27.058  1.00 53.84           C  
ATOM    599  CE2 TYR A  81      22.167  58.378  28.443  1.00 53.84           C  
ATOM    600  CZ  TYR A  81      21.026  58.624  27.694  1.00 53.81           C  
ATOM    601  OH  TYR A  81      20.542  59.907  27.577  1.00 53.77           O  
ATOM    602  N   LEU A  82      24.260  52.135  26.131  1.00 52.92           N  
ATOM    603  CA  LEU A  82      24.562  50.701  26.103  1.00 52.64           C  
ATOM    604  C   LEU A  82      26.054  50.391  25.966  1.00 52.45           C  
ATOM    605  O   LEU A  82      26.434  49.247  25.699  1.00 52.44           O  
ATOM    606  CB  LEU A  82      23.781  50.014  24.977  1.00 52.64           C  
ATOM    607  CG  LEU A  82      22.286  49.764  25.178  1.00 52.63           C  
ATOM    608  CD1 LEU A  82      21.630  49.501  23.838  1.00 52.65           C  
ATOM    609  CD2 LEU A  82      22.036  48.605  26.139  1.00 52.65           C  
ATOM    610  N   SER A  83      26.889  51.411  26.159  1.00 52.15           N  
ATOM    611  CA  SER A  83      28.339  51.288  25.997  1.00 51.83           C  
ATOM    612  C   SER A  83      28.945  50.292  26.987  1.00 51.55           C  
ATOM    613  O   SER A  83      28.827  50.462  28.205  1.00 51.51           O  
ATOM    614  CB  SER A  83      29.008  52.658  26.140  1.00 51.89           C  
ATOM    615  OG  SER A  83      28.341  53.639  25.364  1.00 51.86           O  
ATOM    616  N   SER A  84      29.582  49.252  26.442  1.00 51.14           N  
ATOM    617  CA  SER A  84      30.223  48.173  27.218  1.00 50.72           C  
ATOM    618  C   SER A  84      29.245  47.269  27.982  1.00 50.39           C  
ATOM    619  O   SER A  84      29.665  46.392  28.742  1.00 50.39           O  
ATOM    620  CB  SER A  84      31.304  48.728  28.158  1.00 50.79           C  
ATOM    621  N   LYS A  85      27.947  47.474  27.760  1.00 49.89           N  
ATOM    622  CA  LYS A  85      26.903  46.762  28.498  1.00 49.34           C  
ATOM    623  C   LYS A  85      26.224  45.680  27.658  1.00 48.96           C  
ATOM    624  O   LYS A  85      26.261  45.723  26.425  1.00 48.95           O  
ATOM    625  CB  LYS A  85      25.870  47.753  29.040  1.00 49.35           C  
ATOM    626  CG  LYS A  85      26.472  48.807  29.955  1.00 49.28           C  
ATOM    627  CD  LYS A  85      25.413  49.635  30.640  1.00 49.06           C  
ATOM    628  CE  LYS A  85      26.046  50.584  31.640  1.00 49.09           C  
ATOM    629  NZ  LYS A  85      25.042  51.132  32.587  1.00 49.09           N  
ATOM    630  N   LEU A  86      25.611  44.711  28.334  1.00 48.40           N  
ATOM    631  CA  LEU A  86      24.935  43.604  27.659  1.00 47.86           C  
ATOM    632  C   LEU A  86      23.437  43.853  27.517  1.00 47.43           C  
ATOM    633  O   LEU A  86      22.731  44.057  28.507  1.00 47.33           O  
ATOM    634  CB  LEU A  86      25.195  42.280  28.390  1.00 47.89           C  
ATOM    635  CG  LEU A  86      24.675  40.988  27.747  1.00 47.81           C  
ATOM    636  CD1 LEU A  86      25.471  40.624  26.500  1.00 47.90           C  
ATOM    637  CD2 LEU A  86      24.711  39.848  28.749  1.00 47.88           C  
ATOM    638  N   LEU A  87      22.966  43.837  26.274  1.00 46.96           N  
ATOM    639  CA  LEU A  87      21.547  43.964  25.976  1.00 46.44           C  
ATOM    640  C   LEU A  87      20.964  42.604  25.609  1.00 46.08           C  
ATOM    641  O   LEU A  87      21.408  41.966  24.650  1.00 45.97           O  
ATOM    642  CB  LEU A  87      21.323  44.961  24.833  1.00 46.47           C  
ATOM    643  CG  LEU A  87      19.893  45.155  24.313  1.00 46.36           C  
ATOM    644  CD1 LEU A  87      19.046  45.960  25.292  1.00 46.26           C  
ATOM    645  CD2 LEU A  87      19.913  45.817  22.945  1.00 46.43           C  
ATOM    646  N   ILE A  88      19.978  42.160  26.386  1.00 45.65           N  
ATOM    647  CA  ILE A  88      19.254  40.931  26.065  1.00 45.25           C  
ATOM    648  C   ILE A  88      17.823  41.270  25.638  1.00 44.83           C  
ATOM    649  O   ILE A  88      17.114  42.006  26.329  1.00 44.77           O  
ATOM    650  CB  ILE A  88      19.329  39.846  27.209  1.00 45.30           C  
ATOM    651  CG1 ILE A  88      18.072  39.812  28.083  1.00 45.42           C  
ATOM    652  CG2 ILE A  88      20.587  40.008  28.064  1.00 45.27           C  
ATOM    653  CD1 ILE A  88      17.124  38.690  27.736  1.00 45.57           C  
ATOM    654  N   SER A  89      17.421  40.756  24.480  1.00 44.38           N  
ATOM    655  CA  SER A  89      16.088  41.020  23.943  1.00 43.91           C  
ATOM    656  C   SER A  89      15.232  39.762  23.965  1.00 43.58           C  
ATOM    657  O   SER A  89      15.659  38.703  23.501  1.00 43.49           O  
ATOM    658  CB  SER A  89      16.182  41.574  22.518  1.00 43.89           C  
ATOM    659  OG  SER A  89      14.898  41.868  21.999  1.00 43.65           O  
ATOM    660  N   ILE A  90      14.028  39.885  24.518  1.00 43.23           N  
ATOM    661  CA  ILE A  90      13.062  38.782  24.523  1.00 42.92           C  
ATOM    662  C   ILE A  90      11.927  39.012  23.520  1.00 42.74           C  
ATOM    663  O   ILE A  90      10.969  38.237  23.470  1.00 42.69           O  
ATOM    664  CB  ILE A  90      12.496  38.477  25.944  1.00 42.90           C  
ATOM    665  CG1 ILE A  90      11.710  39.670  26.501  1.00 42.79           C  
ATOM    666  CG2 ILE A  90      13.617  38.046  26.891  1.00 42.81           C  
ATOM    667  CD1 ILE A  90      10.726  39.310  27.596  1.00 42.54           C  
ATOM    668  N   CYS A  91      12.056  40.071  22.723  1.00 42.52           N  
ATOM    669  CA  CYS A  91      11.061  40.431  21.712  1.00 42.38           C  
ATOM    670  C   CYS A  91      10.926  39.359  20.638  1.00 42.16           C  
ATOM    671  O   CYS A  91      11.923  38.889  20.087  1.00 42.11           O  
ATOM    672  CB  CYS A  91      11.399  41.777  21.067  1.00 42.37           C  
ATOM    673  SG  CYS A  91      11.216  43.204  22.158  1.00 42.65           S  
ATOM    674  N   GLY A  92       9.683  38.977  20.360  1.00 41.99           N  
ATOM    675  CA  GLY A  92       9.381  37.971  19.349  1.00 41.82           C  
ATOM    676  C   GLY A  92       9.499  38.514  17.940  1.00 41.68           C  
ATOM    677  O   GLY A  92       9.025  39.614  17.646  1.00 41.63           O  
ATOM    678  N   GLY A  93      10.142  37.741  17.072  1.00 41.60           N  
ATOM    679  CA  GLY A  93      10.308  38.116  15.672  1.00 41.52           C  
ATOM    680  C   GLY A  93      11.553  38.936  15.395  1.00 41.46           C  
ATOM    681  O   GLY A  93      12.243  38.702  14.401  1.00 41.37           O  
ATOM    682  N   LEU A  94      11.840  39.892  16.276  1.00 41.46           N  
ATOM    683  CA  LEU A  94      12.964  40.811  16.096  1.00 41.50           C  
ATOM    684  C   LEU A  94      14.316  40.122  16.262  1.00 41.53           C  
ATOM    685  O   LEU A  94      14.795  39.922  17.381  1.00 41.49           O  
ATOM    686  CB  LEU A  94      12.846  42.018  17.040  1.00 41.50           C  
ATOM    687  CG  LEU A  94      11.646  42.961  16.887  1.00 41.56           C  
ATOM    688  CD1 LEU A  94      11.655  43.995  17.994  1.00 41.49           C  
ATOM    689  CD2 LEU A  94      11.615  43.642  15.516  1.00 41.61           C  
ATOM    690  N   ASN A  95      14.918  39.755  15.132  1.00 41.61           N  
ATOM    691  CA  ASN A  95      16.213  39.078  15.123  1.00 41.72           C  
ATOM    692  C   ASN A  95      17.399  40.023  15.304  1.00 41.82           C  
ATOM    693  O   ASN A  95      17.223  41.240  15.393  1.00 41.78           O  
ATOM    694  CB  ASN A  95      16.379  38.203  13.868  1.00 41.74           C  
ATOM    695  CG  ASN A  95      15.977  38.913  12.585  1.00 41.81           C  
ATOM    696  OD1 ASN A  95      15.058  38.480  11.892  1.00 41.90           O  
ATOM    697  ND2 ASN A  95      16.663  40.005  12.261  1.00 41.74           N  
ATOM    698  N   ILE A  96      18.601  39.451  15.360  1.00 42.00           N  
ATOM    699  CA  ILE A  96      19.835  40.203  15.604  1.00 42.15           C  
ATOM    700  C   ILE A  96      20.039  41.335  14.592  1.00 42.33           C  
ATOM    701  O   ILE A  96      20.419  42.441  14.971  1.00 42.35           O  
ATOM    702  CB  ILE A  96      21.073  39.264  15.652  1.00 42.15           C  
ATOM    703  CG1 ILE A  96      20.959  38.295  16.836  1.00 42.04           C  
ATOM    704  CG2 ILE A  96      22.371  40.068  15.740  1.00 42.13           C  
ATOM    705  CD1 ILE A  96      21.918  37.118  16.776  1.00 42.16           C  
ATOM    706  N   GLY A  97      19.769  41.052  13.318  1.00 42.50           N  
ATOM    707  CA  GLY A  97      19.869  42.049  12.252  1.00 42.76           C  
ATOM    708  C   GLY A  97      19.013  43.281  12.489  1.00 42.94           C  
ATOM    709  O   GLY A  97      19.480  44.408  12.318  1.00 42.91           O  
ATOM    710  N   LYS A  98      17.762  43.059  12.888  1.00 43.20           N  
ATOM    711  CA  LYS A  98      16.840  44.147  13.220  1.00 43.48           C  
ATOM    712  C   LYS A  98      17.222  44.855  14.518  1.00 43.59           C  
ATOM    713  O   LYS A  98      17.012  46.061  14.654  1.00 43.67           O  
ATOM    714  CB  LYS A  98      15.402  43.633  13.306  1.00 43.47           C  
ATOM    715  CG  LYS A  98      14.678  43.561  11.966  1.00 43.98           C  
ATOM    716  CD  LYS A  98      13.897  44.839  11.671  1.00 44.64           C  
ATOM    717  CE  LYS A  98      12.837  44.609  10.598  1.00 45.06           C  
ATOM    718  NZ  LYS A  98      11.764  43.661  11.034  1.00 45.17           N  
ATOM    719  N   LEU A  99      17.781  44.101  15.464  1.00 43.71           N  
ATOM    720  CA  LEU A  99      18.232  44.660  16.737  1.00 43.81           C  
ATOM    721  C   LEU A  99      19.498  45.498  16.564  1.00 43.93           C  
ATOM    722  O   LEU A  99      19.623  46.566  17.163  1.00 43.91           O  
ATOM    723  CB  LEU A  99      18.449  43.551  17.777  1.00 43.78           C  
ATOM    724  CG  LEU A  99      17.214  42.811  18.306  1.00 43.69           C  
ATOM    725  CD1 LEU A  99      17.616  41.504  18.976  1.00 43.59           C  
ATOM    726  CD2 LEU A  99      16.391  43.675  19.257  1.00 43.57           C  
ATOM    727  N   GLU A 100      20.424  45.013  15.735  1.00 44.11           N  
ATOM    728  CA  GLU A 100      21.639  45.757  15.383  1.00 44.35           C  
ATOM    729  C   GLU A 100      21.310  47.024  14.596  1.00 44.56           C  
ATOM    730  O   GLU A 100      22.088  47.977  14.580  1.00 44.61           O  
ATOM    731  CB  GLU A 100      22.601  44.881  14.574  1.00 44.29           C  
ATOM    732  CG  GLU A 100      23.353  43.847  15.399  1.00 44.25           C  
ATOM    733  CD  GLU A 100      24.269  42.965  14.570  1.00 44.29           C  
ATOM    734  OE1 GLU A 100      24.019  42.791  13.357  1.00 44.30           O  
ATOM    735  OE2 GLU A 100      25.242  42.432  15.140  1.00 44.29           O  
ATOM    736  N   GLU A 101      20.153  47.015  13.940  1.00 44.82           N  
ATOM    737  CA  GLU A 101      19.653  48.170  13.207  1.00 45.09           C  
ATOM    738  C   GLU A 101      19.061  49.196  14.174  1.00 45.11           C  
ATOM    739  O   GLU A 101      19.045  50.392  13.887  1.00 45.17           O  
ATOM    740  CB  GLU A 101      18.593  47.722  12.197  1.00 45.08           C  
ATOM    741  CG  GLU A 101      18.333  48.702  11.065  1.00 45.25           C  
ATOM    742  CD  GLU A 101      17.125  48.322  10.224  1.00 45.37           C  
ATOM    743  OE1 GLU A 101      16.925  47.113   9.957  1.00 45.28           O  
ATOM    744  OE2 GLU A 101      16.377  49.240   9.824  1.00 45.87           O  
HETATM  745  N   MSE A 102      18.585  48.712  15.321  1.00 45.23           N  
HETATM  746  CA  MSE A 102      17.926  49.551  16.324  1.00 45.29           C  
HETATM  747  C   MSE A 102      18.890  50.234  17.298  1.00 45.26           C  
HETATM  748  O   MSE A 102      18.658  51.378  17.697  1.00 45.28           O  
HETATM  749  CB  MSE A 102      16.886  48.736  17.101  1.00 45.30           C  
HETATM  750  CG  MSE A 102      15.606  48.460  16.329  1.00 45.43           C  
HETATM  751 SE   MSE A 102      14.418  47.212  17.243  0.80 45.43          SE  
HETATM  752  CE  MSE A 102      12.940  47.224  15.972  1.00 45.46           C  
ATOM    753  N   VAL A 103      19.961  49.538  17.681  1.00 45.18           N  
ATOM    754  CA  VAL A 103      20.910  50.067  18.673  1.00 45.15           C  
ATOM    755  C   VAL A 103      22.346  50.243  18.165  1.00 45.12           C  
ATOM    756  O   VAL A 103      23.128  50.989  18.757  1.00 45.17           O  
ATOM    757  CB  VAL A 103      20.922  49.236  19.993  1.00 45.15           C  
ATOM    758  CG1 VAL A 103      19.618  49.405  20.747  1.00 45.15           C  
ATOM    759  CG2 VAL A 103      21.209  47.764  19.726  1.00 45.10           C  
ATOM    760  N   GLY A 104      22.689  49.558  17.078  1.00 45.03           N  
ATOM    761  CA  GLY A 104      24.034  49.642  16.515  1.00 44.92           C  
ATOM    762  C   GLY A 104      24.787  48.329  16.594  1.00 44.84           C  
ATOM    763  O   GLY A 104      24.619  47.560  17.543  1.00 44.87           O  
ATOM    764  N   SER A 105      25.626  48.085  15.591  1.00 44.71           N  
ATOM    765  CA  SER A 105      26.391  46.844  15.484  1.00 44.55           C  
ATOM    766  C   SER A 105      27.512  46.744  16.518  1.00 44.45           C  
ATOM    767  O   SER A 105      28.021  45.653  16.781  1.00 44.42           O  
ATOM    768  CB  SER A 105      26.964  46.697  14.071  1.00 44.58           C  
ATOM    769  N   GLU A 106      27.887  47.884  17.099  1.00 44.30           N  
ATOM    770  CA  GLU A 106      28.973  47.957  18.080  1.00 44.12           C  
ATOM    771  C   GLU A 106      28.598  47.396  19.459  1.00 43.81           C  
ATOM    772  O   GLU A 106      29.478  47.043  20.250  1.00 43.80           O  
ATOM    773  CB  GLU A 106      29.500  49.399  18.203  1.00 44.23           C  
ATOM    774  CG  GLU A 106      28.589  50.382  18.957  1.00 44.75           C  
ATOM    775  CD  GLU A 106      27.467  50.970  18.103  1.00 45.53           C  
ATOM    776  OE1 GLU A 106      27.346  50.613  16.910  1.00 45.90           O  
ATOM    777  OE2 GLU A 106      26.700  51.802  18.635  1.00 45.71           O  
ATOM    778  N   ASN A 107      27.297  47.313  19.736  1.00 43.37           N  
ATOM    779  CA  ASN A 107      26.798  46.845  21.029  1.00 42.96           C  
ATOM    780  C   ASN A 107      26.814  45.323  21.191  1.00 42.57           C  
ATOM    781  O   ASN A 107      26.928  44.584  20.211  1.00 42.49           O  
ATOM    782  CB  ASN A 107      25.389  47.388  21.286  1.00 43.00           C  
ATOM    783  CG  ASN A 107      25.386  48.858  21.665  1.00 43.21           C  
ATOM    784  OD1 ASN A 107      26.083  49.277  22.590  1.00 43.35           O  
ATOM    785  ND2 ASN A 107      24.586  49.647  20.957  1.00 43.55           N  
ATOM    786  N   LYS A 108      26.710  44.871  22.440  1.00 42.12           N  
ATOM    787  CA  LYS A 108      26.598  43.450  22.764  1.00 41.72           C  
ATOM    788  C   LYS A 108      25.124  43.042  22.788  1.00 41.33           C  
ATOM    789  O   LYS A 108      24.375  43.417  23.700  1.00 41.21           O  
ATOM    790  CB  LYS A 108      27.261  43.146  24.113  1.00 41.76           C  
ATOM    791  CG  LYS A 108      28.779  43.252  24.109  1.00 41.78           C  
ATOM    792  CD  LYS A 108      29.349  43.051  25.506  1.00 41.82           C  
ATOM    793  CE  LYS A 108      30.866  42.904  25.483  1.00 42.09           C  
ATOM    794  NZ  LYS A 108      31.562  44.161  25.083  1.00 42.56           N  
ATOM    795  N   ILE A 109      24.714  42.281  21.775  1.00 40.76           N  
ATOM    796  CA  ILE A 109      23.305  41.921  21.601  1.00 40.24           C  
ATOM    797  C   ILE A 109      23.091  40.410  21.622  1.00 39.83           C  
ATOM    798  O   ILE A 109      23.689  39.669  20.837  1.00 39.77           O  
ATOM    799  CB  ILE A 109      22.709  42.531  20.300  1.00 40.28           C  
ATOM    800  CG1 ILE A 109      22.891  44.053  20.288  1.00 40.32           C  
ATOM    801  CG2 ILE A 109      21.227  42.173  20.161  1.00 40.11           C  
ATOM    802  CD1 ILE A 109      22.941  44.665  18.904  1.00 40.21           C  
ATOM    803  N   VAL A 110      22.230  39.971  22.535  1.00 39.28           N  
ATOM    804  CA  VAL A 110      21.832  38.569  22.627  1.00 38.82           C  
ATOM    805  C   VAL A 110      20.301  38.458  22.607  1.00 38.42           C  
ATOM    806  O   VAL A 110      19.608  39.160  23.345  1.00 38.36           O  
ATOM    807  CB  VAL A 110      22.479  37.855  23.864  1.00 38.82           C  
ATOM    808  CG1 VAL A 110      22.232  38.629  25.150  1.00 38.85           C  
ATOM    809  CG2 VAL A 110      22.000  36.418  23.993  1.00 38.78           C  
ATOM    810  N   TRP A 111      19.789  37.592  21.737  1.00 37.97           N  
ATOM    811  CA  TRP A 111      18.348  37.414  21.574  1.00 37.54           C  
ATOM    812  C   TRP A 111      17.870  36.130  22.251  1.00 37.37           C  
ATOM    813  O   TRP A 111      18.105  35.027  21.755  1.00 37.25           O  
ATOM    814  CB  TRP A 111      17.977  37.444  20.085  1.00 37.42           C  
ATOM    815  CG  TRP A 111      16.510  37.269  19.778  1.00 37.13           C  
ATOM    816  CD1 TRP A 111      15.450  37.614  20.570  1.00 36.94           C  
ATOM    817  CD2 TRP A 111      15.949  36.739  18.571  1.00 36.98           C  
ATOM    818  NE1 TRP A 111      14.267  37.312  19.941  1.00 36.93           N  
ATOM    819  CE2 TRP A 111      14.544  36.776  18.711  1.00 36.95           C  
ATOM    820  CE3 TRP A 111      16.498  36.224  17.388  1.00 36.86           C  
ATOM    821  CZ2 TRP A 111      13.678  36.322  17.711  1.00 37.11           C  
ATOM    822  CZ3 TRP A 111      15.636  35.773  16.394  1.00 36.96           C  
ATOM    823  CH2 TRP A 111      14.243  35.825  16.563  1.00 37.01           C  
ATOM    824  N   VAL A 112      17.202  36.295  23.390  1.00 37.19           N  
ATOM    825  CA  VAL A 112      16.719  35.173  24.193  1.00 37.09           C  
ATOM    826  C   VAL A 112      15.207  35.017  24.033  1.00 37.00           C  
ATOM    827  O   VAL A 112      14.465  36.000  24.082  1.00 36.95           O  
ATOM    828  CB  VAL A 112      17.070  35.361  25.696  1.00 37.11           C  
ATOM    829  CG1 VAL A 112      16.654  34.142  26.518  1.00 37.00           C  
ATOM    830  CG2 VAL A 112      18.559  35.633  25.875  1.00 37.22           C  
HETATM  831  N   MSE A 113      14.761  33.779  23.837  1.00 36.84           N  
HETATM  832  CA  MSE A 113      13.337  33.481  23.740  1.00 36.74           C  
HETATM  833  C   MSE A 113      12.868  32.631  24.925  1.00 36.42           C  
HETATM  834  O   MSE A 113      13.153  31.434  24.983  1.00 36.27           O  
HETATM  835  CB  MSE A 113      13.011  32.812  22.400  1.00 36.89           C  
HETATM  836  CG  MSE A 113      11.525  32.600  22.127  1.00 37.62           C  
HETATM  837 SE   MSE A 113      10.416  34.183  22.412  0.80 40.01          SE  
HETATM  838  CE  MSE A 113      11.357  35.465  21.281  1.00 38.86           C  
ATOM    839  N   PRO A 114      12.163  33.263  25.883  1.00 36.23           N  
ATOM    840  CA  PRO A 114      11.652  32.606  27.081  1.00 36.07           C  
ATOM    841  C   PRO A 114      10.198  32.142  26.966  1.00 35.88           C  
ATOM    842  O   PRO A 114       9.561  32.338  25.930  1.00 35.93           O  
ATOM    843  CB  PRO A 114      11.750  33.716  28.126  1.00 36.05           C  
ATOM    844  CG  PRO A 114      11.528  34.990  27.340  1.00 36.10           C  
ATOM    845  CD  PRO A 114      11.841  34.703  25.888  1.00 36.20           C  
ATOM    846  N   ASN A 115       9.697  31.517  28.029  1.00 35.67           N  
ATOM    847  CA  ASN A 115       8.264  31.282  28.198  1.00 35.49           C  
ATOM    848  C   ASN A 115       7.821  31.522  29.646  1.00 35.40           C  
ATOM    849  O   ASN A 115       8.658  31.561  30.547  1.00 35.38           O  
ATOM    850  CB  ASN A 115       7.842  29.896  27.678  1.00 35.43           C  
ATOM    851  CG  ASN A 115       8.560  28.746  28.373  1.00 35.32           C  
ATOM    852  OD1 ASN A 115       9.150  28.908  29.440  1.00 35.35           O  
ATOM    853  ND2 ASN A 115       8.498  27.568  27.764  1.00 34.91           N  
ATOM    854  N   THR A 116       6.514  31.682  29.861  1.00 35.34           N  
ATOM    855  CA  THR A 116       5.971  32.029  31.186  1.00 35.29           C  
ATOM    856  C   THR A 116       6.256  31.037  32.333  1.00 35.36           C  
ATOM    857  O   THR A 116       6.379  31.469  33.481  1.00 35.43           O  
ATOM    858  CB  THR A 116       4.452  32.358  31.144  1.00 35.25           C  
ATOM    859  OG1 THR A 116       3.726  31.256  30.587  1.00 35.12           O  
ATOM    860  CG2 THR A 116       4.190  33.615  30.322  1.00 35.12           C  
ATOM    861  N   PRO A 117       6.341  29.715  32.039  1.00 35.36           N  
ATOM    862  CA  PRO A 117       6.741  28.722  33.049  1.00 35.39           C  
ATOM    863  C   PRO A 117       7.995  29.045  33.872  1.00 35.43           C  
ATOM    864  O   PRO A 117       8.244  28.383  34.881  1.00 35.40           O  
ATOM    865  CB  PRO A 117       6.987  27.468  32.210  1.00 35.36           C  
ATOM    866  CG  PRO A 117       6.028  27.588  31.112  1.00 35.35           C  
ATOM    867  CD  PRO A 117       6.003  29.048  30.765  1.00 35.34           C  
ATOM    868  N   CYS A 118       8.772  30.040  33.447  1.00 35.51           N  
ATOM    869  CA  CYS A 118       9.958  30.471  34.191  1.00 35.57           C  
ATOM    870  C   CYS A 118       9.594  31.072  35.551  1.00 35.59           C  
ATOM    871  O   CYS A 118      10.424  31.106  36.463  1.00 35.63           O  
ATOM    872  CB  CYS A 118      10.783  31.463  33.369  1.00 35.58           C  
ATOM    873  SG  CYS A 118       9.981  33.052  33.078  1.00 35.86           S  
ATOM    874  N   LEU A 119       8.349  31.535  35.669  1.00 35.60           N  
ATOM    875  CA  LEU A 119       7.795  32.053  36.921  1.00 35.61           C  
ATOM    876  C   LEU A 119       7.860  31.018  38.045  1.00 35.61           C  
ATOM    877  O   LEU A 119       8.137  31.362  39.195  1.00 35.69           O  
ATOM    878  CB  LEU A 119       6.348  32.520  36.706  1.00 35.61           C  
ATOM    879  CG  LEU A 119       5.569  33.144  37.873  1.00 35.63           C  
ATOM    880  CD1 LEU A 119       6.121  34.515  38.249  1.00 35.69           C  
ATOM    881  CD2 LEU A 119       4.090  33.241  37.534  1.00 35.59           C  
ATOM    882  N   VAL A 120       7.603  29.756  37.704  1.00 35.59           N  
ATOM    883  CA  VAL A 120       7.704  28.653  38.665  1.00 35.58           C  
ATOM    884  C   VAL A 120       9.027  27.884  38.512  1.00 35.55           C  
ATOM    885  O   VAL A 120       9.135  26.717  38.899  1.00 35.56           O  
ATOM    886  CB  VAL A 120       6.468  27.699  38.608  1.00 35.54           C  
ATOM    887  CG1 VAL A 120       5.207  28.431  39.042  1.00 35.50           C  
ATOM    888  CG2 VAL A 120       6.288  27.095  37.215  1.00 35.62           C  
ATOM    889  N   GLY A 121      10.025  28.555  37.940  1.00 35.52           N  
ATOM    890  CA  GLY A 121      11.370  28.002  37.785  1.00 35.49           C  
ATOM    891  C   GLY A 121      11.482  26.852  36.802  1.00 35.47           C  
ATOM    892  O   GLY A 121      12.400  26.034  36.903  1.00 35.46           O  
ATOM    893  N   GLU A 122      10.557  26.799  35.846  1.00 35.43           N  
ATOM    894  CA  GLU A 122      10.494  25.699  34.886  1.00 35.48           C  
ATOM    895  C   GLU A 122      10.409  26.202  33.441  1.00 35.40           C  
ATOM    896  O   GLU A 122       9.771  25.583  32.585  1.00 35.33           O  
ATOM    897  CB  GLU A 122       9.314  24.779  35.220  1.00 35.54           C  
ATOM    898  CG  GLU A 122       9.564  23.303  34.924  1.00 35.98           C  
ATOM    899  CD  GLU A 122      10.670  22.706  35.780  1.00 36.31           C  
ATOM    900  OE1 GLU A 122      10.583  22.793  37.024  1.00 36.50           O  
ATOM    901  OE2 GLU A 122      11.626  22.141  35.204  1.00 36.58           O  
ATOM    902  N   GLY A 123      11.073  27.324  33.178  1.00 35.34           N  
ATOM    903  CA  GLY A 123      11.056  27.944  31.859  1.00 35.28           C  
ATOM    904  C   GLY A 123      11.897  27.225  30.826  1.00 35.26           C  
ATOM    905  O   GLY A 123      12.854  26.526  31.163  1.00 35.26           O  
ATOM    906  N   SER A 124      11.524  27.388  29.561  1.00 35.27           N  
ATOM    907  CA  SER A 124      12.325  26.896  28.450  1.00 35.34           C  
ATOM    908  C   SER A 124      12.863  28.085  27.667  1.00 35.48           C  
ATOM    909  O   SER A 124      12.114  28.999  27.312  1.00 35.45           O  
ATOM    910  CB  SER A 124      11.504  25.978  27.546  1.00 35.31           C  
ATOM    911  OG  SER A 124      12.315  25.409  26.535  1.00 34.95           O  
ATOM    912  N   PHE A 125      14.167  28.073  27.414  1.00 35.66           N  
ATOM    913  CA  PHE A 125      14.828  29.191  26.757  1.00 35.82           C  
ATOM    914  C   PHE A 125      15.675  28.735  25.576  1.00 36.08           C  
ATOM    915  O   PHE A 125      16.298  27.671  25.615  1.00 35.99           O  
ATOM    916  CB  PHE A 125      15.719  29.958  27.742  1.00 35.69           C  
ATOM    917  CG  PHE A 125      15.056  30.292  29.052  1.00 35.53           C  
ATOM    918  CD1 PHE A 125      15.161  29.428  30.140  1.00 35.31           C  
ATOM    919  CD2 PHE A 125      14.356  31.483  29.208  1.00 35.28           C  
ATOM    920  CE1 PHE A 125      14.556  29.737  31.357  1.00 35.22           C  
ATOM    921  CE2 PHE A 125      13.750  31.802  30.424  1.00 35.32           C  
ATOM    922  CZ  PHE A 125      13.853  30.926  31.500  1.00 35.33           C  
ATOM    923  N   ILE A 126      15.675  29.550  24.527  1.00 36.49           N  
ATOM    924  CA  ILE A 126      16.621  29.422  23.417  1.00 36.95           C  
ATOM    925  C   ILE A 126      17.236  30.786  23.131  1.00 37.33           C  
ATOM    926  O   ILE A 126      16.561  31.812  23.255  1.00 37.30           O  
ATOM    927  CB  ILE A 126      15.983  28.840  22.114  1.00 36.87           C  
ATOM    928  CG1 ILE A 126      14.728  29.625  21.677  1.00 36.70           C  
ATOM    929  CG2 ILE A 126      15.753  27.331  22.246  1.00 36.78           C  
ATOM    930  CD1 ILE A 126      13.411  29.213  22.336  1.00 36.55           C  
ATOM    931  N   TYR A 127      18.515  30.804  22.764  1.00 37.93           N  
ATOM    932  CA  TYR A 127      19.189  32.073  22.484  1.00 38.54           C  
ATOM    933  C   TYR A 127      20.251  32.018  21.396  1.00 38.99           C  
ATOM    934  O   TYR A 127      20.809  30.959  21.092  1.00 39.01           O  
ATOM    935  CB  TYR A 127      19.762  32.695  23.771  1.00 38.52           C  
ATOM    936  CG  TYR A 127      21.148  32.218  24.165  1.00 38.66           C  
ATOM    937  CD1 TYR A 127      22.279  32.973  23.857  1.00 38.64           C  
ATOM    938  CD2 TYR A 127      21.325  31.021  24.859  1.00 38.70           C  
ATOM    939  CE1 TYR A 127      23.553  32.544  24.222  1.00 38.78           C  
ATOM    940  CE2 TYR A 127      22.592  30.585  25.231  1.00 38.67           C  
ATOM    941  CZ  TYR A 127      23.701  31.349  24.908  1.00 38.78           C  
ATOM    942  OH  TYR A 127      24.959  30.919  25.274  1.00 38.91           O  
ATOM    943  N   CYS A 128      20.502  33.184  20.811  1.00 39.58           N  
ATOM    944  CA  CYS A 128      21.596  33.399  19.878  1.00 40.14           C  
ATOM    945  C   CYS A 128      22.163  34.786  20.164  1.00 40.69           C  
ATOM    946  O   CYS A 128      21.490  35.627  20.768  1.00 40.65           O  
ATOM    947  CB  CYS A 128      21.102  33.300  18.434  1.00 40.08           C  
ATOM    948  SG  CYS A 128      19.789  34.465  18.011  1.00 39.78           S  
ATOM    949  N   SER A 129      23.399  35.022  19.738  1.00 41.42           N  
ATOM    950  CA  SER A 129      24.075  36.282  20.025  1.00 42.18           C  
ATOM    951  C   SER A 129      24.894  36.777  18.839  1.00 42.73           C  
ATOM    952  O   SER A 129      25.271  35.994  17.964  1.00 42.79           O  
ATOM    953  CB  SER A 129      24.961  36.132  21.262  1.00 42.18           C  
ATOM    954  OG  SER A 129      25.922  35.108  21.081  1.00 42.28           O  
ATOM    955  N   ASN A 130      25.169  38.079  18.818  1.00 43.45           N  
ATOM    956  CA  ASN A 130      25.951  38.683  17.741  1.00 44.18           C  
ATOM    957  C   ASN A 130      27.459  38.458  17.891  1.00 44.71           C  
ATOM    958  O   ASN A 130      27.900  37.644  18.710  1.00 44.76           O  
ATOM    959  CB  ASN A 130      25.610  40.177  17.580  1.00 44.14           C  
ATOM    960  CG  ASN A 130      26.092  41.035  18.747  1.00 44.21           C  
ATOM    961  OD1 ASN A 130      26.475  40.529  19.802  1.00 44.35           O  
ATOM    962  ND2 ASN A 130      26.066  42.348  18.553  1.00 44.27           N  
ATOM    963  N   LYS A 131      28.237  39.184  17.090  1.00 45.36           N  
ATOM    964  CA  LYS A 131      29.690  39.054  17.060  1.00 46.04           C  
ATOM    965  C   LYS A 131      30.351  39.553  18.350  1.00 46.41           C  
ATOM    966  O   LYS A 131      31.398  39.043  18.752  1.00 46.46           O  
ATOM    967  CB  LYS A 131      30.248  39.811  15.848  1.00 46.00           C  
ATOM    968  CG  LYS A 131      31.628  39.363  15.392  1.00 46.21           C  
ATOM    969  CD  LYS A 131      32.075  40.143  14.164  1.00 46.20           C  
ATOM    970  N   ASN A 132      29.724  40.535  18.995  1.00 47.00           N  
ATOM    971  CA  ASN A 132      30.305  41.209  20.158  1.00 47.60           C  
ATOM    972  C   ASN A 132      30.066  40.529  21.511  1.00 48.04           C  
ATOM    973  O   ASN A 132      30.648  40.933  22.521  1.00 48.10           O  
ATOM    974  CB  ASN A 132      29.846  42.670  20.208  1.00 47.59           C  
ATOM    975  CG  ASN A 132      30.347  43.482  19.023  1.00 47.68           C  
ATOM    976  OD1 ASN A 132      31.450  43.265  18.520  1.00 47.57           O  
ATOM    977  ND2 ASN A 132      29.533  44.428  18.576  1.00 47.79           N  
ATOM    978  N   VAL A 133      29.217  39.505  21.529  1.00 48.62           N  
ATOM    979  CA  VAL A 133      28.966  38.736  22.749  1.00 49.16           C  
ATOM    980  C   VAL A 133      30.032  37.651  22.912  1.00 49.57           C  
ATOM    981  O   VAL A 133      30.156  36.751  22.074  1.00 49.63           O  
ATOM    982  CB  VAL A 133      27.538  38.129  22.769  1.00 49.12           C  
ATOM    983  CG1 VAL A 133      27.360  37.176  23.947  1.00 49.10           C  
ATOM    984  CG2 VAL A 133      26.490  39.232  22.823  1.00 49.14           C  
ATOM    985  N   ASN A 134      30.802  37.755  23.995  1.00 50.03           N  
ATOM    986  CA  ASN A 134      31.899  36.826  24.268  1.00 50.52           C  
ATOM    987  C   ASN A 134      31.516  35.688  25.218  1.00 50.79           C  
ATOM    988  O   ASN A 134      30.357  35.571  25.627  1.00 50.82           O  
ATOM    989  CB  ASN A 134      33.130  37.583  24.789  1.00 50.56           C  
ATOM    990  CG  ASN A 134      32.824  38.450  26.004  1.00 50.78           C  
ATOM    991  OD1 ASN A 134      32.158  38.016  26.947  1.00 50.92           O  
ATOM    992  ND2 ASN A 134      33.322  39.682  25.990  1.00 50.78           N  
ATOM    993  N   SER A 135      32.501  34.861  25.563  1.00 51.15           N  
ATOM    994  CA  SER A 135      32.305  33.698  26.431  1.00 51.47           C  
ATOM    995  C   SER A 135      31.881  34.060  27.857  1.00 51.64           C  
ATOM    996  O   SER A 135      31.110  33.329  28.481  1.00 51.66           O  
ATOM    997  CB  SER A 135      33.573  32.839  26.459  1.00 51.52           C  
ATOM    998  OG  SER A 135      34.715  33.627  26.747  1.00 51.62           O  
ATOM    999  N   THR A 136      32.385  35.184  28.364  1.00 51.87           N  
ATOM   1000  CA  THR A 136      32.034  35.649  29.708  1.00 52.14           C  
ATOM   1001  C   THR A 136      30.613  36.211  29.761  1.00 52.20           C  
ATOM   1002  O   THR A 136      29.955  36.149  30.801  1.00 52.23           O  
ATOM   1003  CB  THR A 136      33.033  36.703  30.251  1.00 52.18           C  
ATOM   1004  OG1 THR A 136      33.049  37.848  29.390  1.00 52.30           O  
ATOM   1005  CG2 THR A 136      34.441  36.119  30.353  1.00 52.29           C  
ATOM   1006  N   ASP A 137      30.152  36.760  28.638  1.00 52.29           N  
ATOM   1007  CA  ASP A 137      28.775  37.236  28.512  1.00 52.34           C  
ATOM   1008  C   ASP A 137      27.798  36.068  28.417  1.00 52.32           C  
ATOM   1009  O   ASP A 137      26.727  36.101  29.024  1.00 52.27           O  
ATOM   1010  CB  ASP A 137      28.623  38.148  27.291  1.00 52.40           C  
ATOM   1011  CG  ASP A 137      29.286  39.500  27.479  1.00 52.53           C  
ATOM   1012  OD1 ASP A 137      29.070  40.145  28.529  1.00 52.65           O  
ATOM   1013  OD2 ASP A 137      30.015  39.927  26.560  1.00 52.62           O  
ATOM   1014  N   LYS A 138      28.181  35.042  27.657  1.00 52.33           N  
ATOM   1015  CA  LYS A 138      27.372  33.833  27.491  1.00 52.35           C  
ATOM   1016  C   LYS A 138      27.261  33.040  28.790  1.00 52.37           C  
ATOM   1017  O   LYS A 138      26.271  32.339  29.011  1.00 52.35           O  
ATOM   1018  CB  LYS A 138      27.939  32.949  26.378  1.00 52.35           C  
ATOM   1019  CG  LYS A 138      27.741  33.513  24.980  1.00 52.48           C  
ATOM   1020  CD  LYS A 138      28.290  32.582  23.917  1.00 52.60           C  
ATOM   1021  CE  LYS A 138      28.243  33.234  22.547  1.00 52.65           C  
ATOM   1022  NZ  LYS A 138      28.728  32.320  21.478  1.00 52.82           N  
ATOM   1023  N   LYS A 139      28.281  33.157  29.639  1.00 52.37           N  
ATOM   1024  CA  LYS A 139      28.270  32.561  30.973  1.00 52.32           C  
ATOM   1025  C   LYS A 139      27.224  33.235  31.858  1.00 52.23           C  
ATOM   1026  O   LYS A 139      26.528  32.566  32.620  1.00 52.23           O  
ATOM   1027  CB  LYS A 139      29.653  32.652  31.620  1.00 52.36           C  
ATOM   1028  N   TYR A 140      27.120  34.559  31.745  1.00 52.15           N  
ATOM   1029  CA  TYR A 140      26.107  35.331  32.464  1.00 52.08           C  
ATOM   1030  C   TYR A 140      24.696  35.005  31.980  1.00 51.85           C  
ATOM   1031  O   TYR A 140      23.776  34.874  32.788  1.00 51.80           O  
ATOM   1032  CB  TYR A 140      26.374  36.836  32.344  1.00 52.29           C  
ATOM   1033  CG  TYR A 140      27.211  37.413  33.467  1.00 52.63           C  
ATOM   1034  CD1 TYR A 140      26.616  37.842  34.652  1.00 52.91           C  
ATOM   1035  CD2 TYR A 140      28.593  37.542  33.342  1.00 53.00           C  
ATOM   1036  CE1 TYR A 140      27.377  38.371  35.690  1.00 53.06           C  
ATOM   1037  CE2 TYR A 140      29.365  38.076  34.374  1.00 53.12           C  
ATOM   1038  CZ  TYR A 140      28.749  38.489  35.544  1.00 53.02           C  
ATOM   1039  OH  TYR A 140      29.503  39.017  36.569  1.00 52.90           O  
ATOM   1040  N   VAL A 141      24.540  34.874  30.663  1.00 51.53           N  
ATOM   1041  CA  VAL A 141      23.253  34.534  30.051  1.00 51.20           C  
ATOM   1042  C   VAL A 141      22.787  33.145  30.496  1.00 50.94           C  
ATOM   1043  O   VAL A 141      21.651  32.986  30.944  1.00 50.90           O  
ATOM   1044  CB  VAL A 141      23.306  34.641  28.496  1.00 51.26           C  
ATOM   1045  CG1 VAL A 141      22.033  34.087  27.858  1.00 51.31           C  
ATOM   1046  CG2 VAL A 141      23.521  36.086  28.066  1.00 51.15           C  
ATOM   1047  N   ASN A 142      23.674  32.156  30.390  1.00 50.61           N  
ATOM   1048  CA  ASN A 142      23.371  30.785  30.805  1.00 50.28           C  
ATOM   1049  C   ASN A 142      22.944  30.648  32.266  1.00 49.94           C  
ATOM   1050  O   ASN A 142      21.966  29.963  32.562  1.00 49.93           O  
ATOM   1051  CB  ASN A 142      24.549  29.850  30.512  1.00 50.37           C  
ATOM   1052  CG  ASN A 142      24.459  29.210  29.139  1.00 50.65           C  
ATOM   1053  OD1 ASN A 142      24.462  29.896  28.118  1.00 50.88           O  
ATOM   1054  ND2 ASN A 142      24.383  27.884  29.111  1.00 50.94           N  
ATOM   1055  N   ASP A 143      23.671  31.307  33.167  1.00 49.52           N  
ATOM   1056  CA  ASP A 143      23.411  31.205  34.606  1.00 49.11           C  
ATOM   1057  C   ASP A 143      22.115  31.892  35.032  1.00 48.72           C  
ATOM   1058  O   ASP A 143      21.461  31.452  35.980  1.00 48.72           O  
ATOM   1059  CB  ASP A 143      24.585  31.765  35.413  1.00 49.18           C  
ATOM   1060  CG  ASP A 143      25.883  31.006  35.178  1.00 49.32           C  
ATOM   1061  OD1 ASP A 143      25.848  29.886  34.621  1.00 49.33           O  
ATOM   1062  OD2 ASP A 143      26.947  31.541  35.555  1.00 49.52           O  
ATOM   1063  N   ILE A 144      21.762  32.974  34.338  1.00 48.21           N  
ATOM   1064  CA  ILE A 144      20.535  33.722  34.626  1.00 47.72           C  
ATOM   1065  C   ILE A 144      19.286  32.894  34.324  1.00 47.30           C  
ATOM   1066  O   ILE A 144      18.344  32.865  35.120  1.00 47.24           O  
ATOM   1067  CB  ILE A 144      20.496  35.085  33.872  1.00 47.76           C  
ATOM   1068  CG1 ILE A 144      21.419  36.097  34.558  1.00 47.76           C  
ATOM   1069  CG2 ILE A 144      19.073  35.647  33.815  1.00 47.70           C  
ATOM   1070  CD1 ILE A 144      21.708  37.352  33.744  1.00 47.78           C  
ATOM   1071  N   PHE A 145      19.297  32.207  33.184  1.00 46.76           N  
ATOM   1072  CA  PHE A 145      18.128  31.465  32.721  1.00 46.20           C  
ATOM   1073  C   PHE A 145      18.101  29.998  33.166  1.00 45.79           C  
ATOM   1074  O   PHE A 145      17.027  29.405  33.270  1.00 45.76           O  
ATOM   1075  CB  PHE A 145      17.961  31.615  31.204  1.00 46.19           C  
ATOM   1076  CG  PHE A 145      17.796  33.046  30.754  1.00 46.17           C  
ATOM   1077  CD1 PHE A 145      16.619  33.743  31.010  1.00 46.05           C  
ATOM   1078  CD2 PHE A 145      18.824  33.701  30.085  1.00 46.24           C  
ATOM   1079  CE1 PHE A 145      16.468  35.067  30.601  1.00 46.08           C  
ATOM   1080  CE2 PHE A 145      18.682  35.025  29.672  1.00 46.15           C  
ATOM   1081  CZ  PHE A 145      17.501  35.707  29.932  1.00 46.06           C  
ATOM   1082  N   ASN A 146      19.271  29.422  33.439  1.00 45.29           N  
ATOM   1083  CA  ASN A 146      19.347  28.078  34.027  1.00 44.79           C  
ATOM   1084  C   ASN A 146      18.934  28.045  35.500  1.00 44.34           C  
ATOM   1085  O   ASN A 146      18.693  26.971  36.059  1.00 44.32           O  
ATOM   1086  CB  ASN A 146      20.738  27.458  33.851  1.00 44.89           C  
ATOM   1087  CG  ASN A 146      20.892  26.715  32.531  1.00 45.08           C  
ATOM   1088  OD1 ASN A 146      19.964  26.056  32.055  1.00 45.13           O  
ATOM   1089  ND2 ASN A 146      22.079  26.807  31.941  1.00 45.34           N  
ATOM   1090  N   SER A 147      18.856  29.222  36.117  1.00 43.73           N  
ATOM   1091  CA  SER A 147      18.399  29.353  37.499  1.00 43.21           C  
ATOM   1092  C   SER A 147      16.879  29.213  37.609  1.00 42.81           C  
ATOM   1093  O   SER A 147      16.359  28.841  38.665  1.00 42.78           O  
ATOM   1094  CB  SER A 147      18.855  30.689  38.096  1.00 43.22           C  
ATOM   1095  OG  SER A 147      18.098  31.772  37.583  1.00 43.12           O  
ATOM   1096  N   CYS A 148      16.179  29.514  36.518  1.00 42.28           N  
ATOM   1097  CA  CYS A 148      14.719  29.417  36.474  1.00 41.76           C  
ATOM   1098  C   CYS A 148      14.215  28.606  35.271  1.00 41.35           C  
ATOM   1099  O   CYS A 148      13.087  28.800  34.808  1.00 41.27           O  
ATOM   1100  CB  CYS A 148      14.086  30.814  36.498  1.00 41.79           C  
ATOM   1101  SG  CYS A 148      14.532  31.876  35.103  1.00 41.86           S  
ATOM   1102  N   GLY A 149      15.052  27.695  34.777  1.00 40.84           N  
ATOM   1103  CA  GLY A 149      14.677  26.821  33.671  1.00 40.29           C  
ATOM   1104  C   GLY A 149      15.843  26.164  32.961  1.00 39.93           C  
ATOM   1105  O   GLY A 149      16.907  25.968  33.546  1.00 39.93           O  
ATOM   1106  N   ILE A 150      15.631  25.810  31.694  1.00 39.53           N  
ATOM   1107  CA  ILE A 150      16.660  25.176  30.867  1.00 39.14           C  
ATOM   1108  C   ILE A 150      16.881  25.987  29.590  1.00 38.86           C  
ATOM   1109  O   ILE A 150      15.942  26.229  28.830  1.00 38.82           O  
ATOM   1110  CB  ILE A 150      16.300  23.700  30.526  1.00 39.17           C  
ATOM   1111  CG1 ILE A 150      16.261  22.848  31.800  1.00 39.12           C  
ATOM   1112  CG2 ILE A 150      17.290  23.109  29.512  1.00 39.13           C  
ATOM   1113  CD1 ILE A 150      15.612  21.481  31.631  1.00 39.16           C  
ATOM   1114  N   ILE A 151      18.126  26.402  29.367  1.00 38.61           N  
ATOM   1115  CA  ILE A 151      18.476  27.225  28.209  1.00 38.32           C  
ATOM   1116  C   ILE A 151      19.378  26.494  27.207  1.00 38.14           C  
ATOM   1117  O   ILE A 151      20.300  25.770  27.593  1.00 38.11           O  
ATOM   1118  CB  ILE A 151      19.088  28.602  28.635  1.00 38.35           C  
ATOM   1119  CG1 ILE A 151      19.258  29.528  27.422  1.00 38.39           C  
ATOM   1120  CG2 ILE A 151      20.401  28.423  29.406  1.00 38.26           C  
ATOM   1121  CD1 ILE A 151      19.310  31.009  27.758  1.00 38.28           C  
ATOM   1122  N   HIS A 152      19.077  26.678  25.923  1.00 37.87           N  
ATOM   1123  CA  HIS A 152      19.895  26.152  24.834  1.00 37.66           C  
ATOM   1124  C   HIS A 152      20.410  27.300  23.974  1.00 37.52           C  
ATOM   1125  O   HIS A 152      19.712  28.296  23.779  1.00 37.49           O  
ATOM   1126  CB  HIS A 152      19.076  25.202  23.956  1.00 37.67           C  
ATOM   1127  CG  HIS A 152      18.558  23.998  24.678  1.00 37.78           C  
ATOM   1128  ND1 HIS A 152      19.200  22.779  24.646  1.00 37.80           N  
ATOM   1129  CD2 HIS A 152      17.456  23.823  25.443  1.00 37.55           C  
ATOM   1130  CE1 HIS A 152      18.517  21.906  25.364  1.00 37.62           C  
ATOM   1131  NE2 HIS A 152      17.455  22.514  25.859  1.00 37.50           N  
ATOM   1132  N   GLU A 153      21.631  27.162  23.466  1.00 37.38           N  
ATOM   1133  CA  GLU A 153      22.130  28.076  22.446  1.00 37.26           C  
ATOM   1134  C   GLU A 153      21.903  27.453  21.078  1.00 37.07           C  
ATOM   1135  O   GLU A 153      22.359  26.340  20.805  1.00 37.10           O  
ATOM   1136  CB  GLU A 153      23.610  28.409  22.644  1.00 37.25           C  
ATOM   1137  CG  GLU A 153      24.104  29.507  21.700  1.00 37.41           C  
ATOM   1138  CD  GLU A 153      25.562  29.886  21.906  1.00 37.62           C  
ATOM   1139  OE1 GLU A 153      26.329  29.085  22.487  1.00 37.95           O  
ATOM   1140  OE2 GLU A 153      25.940  30.995  21.471  1.00 37.98           O  
ATOM   1141  N   ILE A 154      21.183  28.176  20.226  1.00 36.84           N  
ATOM   1142  CA  ILE A 154      20.843  27.687  18.894  1.00 36.60           C  
ATOM   1143  C   ILE A 154      21.230  28.703  17.821  1.00 36.43           C  
ATOM   1144  O   ILE A 154      21.547  29.854  18.133  1.00 36.47           O  
ATOM   1145  CB  ILE A 154      19.332  27.331  18.777  1.00 36.60           C  
ATOM   1146  CG1 ILE A 154      18.455  28.578  18.942  1.00 36.52           C  
ATOM   1147  CG2 ILE A 154      18.947  26.246  19.788  1.00 36.60           C  
ATOM   1148  CD1 ILE A 154      17.051  28.418  18.401  1.00 36.36           C  
ATOM   1149  N   LYS A 155      21.206  28.267  16.563  1.00 36.23           N  
ATOM   1150  CA  LYS A 155      21.431  29.151  15.419  1.00 36.01           C  
ATOM   1151  C   LYS A 155      20.339  30.218  15.342  1.00 35.73           C  
ATOM   1152  O   LYS A 155      19.215  29.996  15.799  1.00 35.75           O  
ATOM   1153  CB  LYS A 155      21.460  28.345  14.119  1.00 36.09           C  
ATOM   1154  CG  LYS A 155      22.613  27.361  14.006  1.00 36.41           C  
ATOM   1155  CD  LYS A 155      22.443  26.466  12.788  1.00 37.09           C  
ATOM   1156  CE  LYS A 155      23.663  25.585  12.570  1.00 37.61           C  
ATOM   1157  NZ  LYS A 155      23.516  24.732  11.361  1.00 37.84           N  
ATOM   1158  N   GLU A 156      20.670  31.368  14.759  1.00 35.41           N  
ATOM   1159  CA  GLU A 156      19.708  32.461  14.613  1.00 35.19           C  
ATOM   1160  C   GLU A 156      18.538  32.084  13.700  1.00 34.91           C  
ATOM   1161  O   GLU A 156      17.397  32.481  13.949  1.00 34.83           O  
ATOM   1162  CB  GLU A 156      20.393  33.730  14.098  1.00 35.19           C  
ATOM   1163  CG  GLU A 156      19.554  34.992  14.267  1.00 35.17           C  
ATOM   1164  CD  GLU A 156      20.135  36.205  13.563  1.00 35.41           C  
ATOM   1165  OE1 GLU A 156      19.419  37.224  13.471  1.00 35.70           O  
ATOM   1166  OE2 GLU A 156      21.298  36.151  13.104  1.00 35.63           O  
ATOM   1167  N   LYS A 157      18.827  31.308  12.656  1.00 34.60           N  
ATOM   1168  CA  LYS A 157      17.806  30.878  11.698  1.00 34.40           C  
ATOM   1169  C   LYS A 157      16.796  29.894  12.300  1.00 34.08           C  
ATOM   1170  O   LYS A 157      15.697  29.724  11.765  1.00 34.12           O  
ATOM   1171  CB  LYS A 157      18.452  30.298  10.431  1.00 34.38           C  
ATOM   1172  CG  LYS A 157      19.189  28.971  10.622  1.00 34.62           C  
ATOM   1173  CD  LYS A 157      19.736  28.417   9.301  1.00 34.75           C  
ATOM   1174  CE  LYS A 157      18.628  27.992   8.333  1.00 35.40           C  
ATOM   1175  NZ  LYS A 157      17.773  26.890   8.868  1.00 35.84           N  
ATOM   1176  N   ASP A 158      17.172  29.261  13.411  1.00 33.70           N  
ATOM   1177  CA  ASP A 158      16.309  28.306  14.107  1.00 33.24           C  
ATOM   1178  C   ASP A 158      15.468  28.951  15.212  1.00 32.96           C  
ATOM   1179  O   ASP A 158      14.676  28.273  15.869  1.00 32.97           O  
ATOM   1180  CB  ASP A 158      17.144  27.163  14.696  1.00 33.19           C  
ATOM   1181  CG  ASP A 158      17.701  26.229  13.637  1.00 33.15           C  
ATOM   1182  OD1 ASP A 158      17.302  26.332  12.458  1.00 33.32           O  
ATOM   1183  OD2 ASP A 158      18.546  25.381  13.991  1.00 33.30           O  
HETATM 1184  N   MSE A 159      15.638  30.257  15.409  1.00 32.57           N  
HETATM 1185  CA  MSE A 159      14.955  30.981  16.484  1.00 32.21           C  
HETATM 1186  C   MSE A 159      13.448  31.094  16.281  1.00 31.75           C  
HETATM 1187  O   MSE A 159      12.689  31.132  17.251  1.00 31.69           O  
HETATM 1188  CB  MSE A 159      15.551  32.378  16.657  1.00 32.42           C  
HETATM 1189  CG  MSE A 159      16.897  32.420  17.371  1.00 32.98           C  
HETATM 1190 SE   MSE A 159      16.793  32.061  19.291  0.80 35.28          SE  
HETATM 1191  CE  MSE A 159      15.639  33.524  19.853  1.00 33.71           C  
ATOM   1192  N   ASP A 160      13.022  31.149  15.022  1.00 31.26           N  
ATOM   1193  CA  ASP A 160      11.612  31.335  14.682  1.00 30.74           C  
ATOM   1194  C   ASP A 160      10.765  30.097  14.982  1.00 30.33           C  
ATOM   1195  O   ASP A 160       9.679  30.212  15.552  1.00 30.19           O  
ATOM   1196  CB  ASP A 160      11.466  31.761  13.219  1.00 30.75           C  
ATOM   1197  CG  ASP A 160      12.262  33.017  12.896  1.00 30.84           C  
ATOM   1198  OD1 ASP A 160      11.922  34.099  13.421  1.00 30.68           O  
ATOM   1199  OD2 ASP A 160      13.225  32.920  12.108  1.00 31.05           O  
ATOM   1200  N   ILE A 161      11.270  28.924  14.601  1.00 29.79           N  
ATOM   1201  CA  ILE A 161      10.604  27.654  14.912  1.00 29.32           C  
ATOM   1202  C   ILE A 161      10.671  27.331  16.413  1.00 29.06           C  
ATOM   1203  O   ILE A 161       9.714  26.803  16.984  1.00 28.96           O  
ATOM   1204  CB  ILE A 161      11.125  26.466  14.025  1.00 29.30           C  
ATOM   1205  CG1 ILE A 161      10.455  25.138  14.406  1.00 29.07           C  
ATOM   1206  CG2 ILE A 161      12.644  26.337  14.087  1.00 29.10           C  
ATOM   1207  CD1 ILE A 161       8.970  25.087  14.130  1.00 28.72           C  
ATOM   1208  N   ALA A 162      11.796  27.668  17.041  1.00 28.73           N  
ATOM   1209  CA  ALA A 162      11.973  27.462  18.478  1.00 28.41           C  
ATOM   1210  C   ALA A 162      11.012  28.327  19.295  1.00 28.15           C  
ATOM   1211  O   ALA A 162      10.497  27.882  20.319  1.00 28.11           O  
ATOM   1212  CB  ALA A 162      13.408  27.729  18.876  1.00 28.38           C  
ATOM   1213  N   THR A 163      10.779  29.554  18.831  1.00 27.87           N  
ATOM   1214  CA  THR A 163       9.788  30.456  19.423  1.00 27.58           C  
ATOM   1215  C   THR A 163       8.392  29.840  19.341  1.00 27.40           C  
ATOM   1216  O   THR A 163       7.637  29.867  20.312  1.00 27.30           O  
ATOM   1217  CB  THR A 163       9.788  31.836  18.714  1.00 27.61           C  
ATOM   1218  OG1 THR A 163      11.110  32.390  18.732  1.00 27.74           O  
ATOM   1219  CG2 THR A 163       8.826  32.807  19.389  1.00 27.44           C  
ATOM   1220  N   ALA A 164       8.072  29.274  18.180  1.00 27.28           N  
ATOM   1221  CA  ALA A 164       6.779  28.640  17.926  1.00 27.08           C  
ATOM   1222  C   ALA A 164       6.510  27.439  18.835  1.00 26.96           C  
ATOM   1223  O   ALA A 164       5.362  27.170  19.185  1.00 27.02           O  
ATOM   1224  CB  ALA A 164       6.674  28.236  16.467  1.00 27.04           C  
ATOM   1225  N   ILE A 165       7.570  26.728  19.210  1.00 26.83           N  
ATOM   1226  CA  ILE A 165       7.469  25.554  20.080  1.00 26.66           C  
ATOM   1227  C   ILE A 165       7.656  25.916  21.556  1.00 26.55           C  
ATOM   1228  O   ILE A 165       6.799  25.614  22.386  1.00 26.46           O  
ATOM   1229  CB  ILE A 165       8.488  24.455  19.672  1.00 26.63           C  
ATOM   1230  CG1 ILE A 165       8.080  23.821  18.342  1.00 26.65           C  
ATOM   1231  CG2 ILE A 165       8.618  23.381  20.762  1.00 26.67           C  
ATOM   1232  CD1 ILE A 165       9.172  23.010  17.689  1.00 26.89           C  
ATOM   1233  N   SER A 166       8.777  26.558  21.869  1.00 26.43           N  
ATOM   1234  CA  SER A 166       9.142  26.847  23.252  1.00 26.33           C  
ATOM   1235  C   SER A 166       8.455  28.100  23.794  1.00 26.24           C  
ATOM   1236  O   SER A 166       7.919  28.082  24.899  1.00 26.34           O  
ATOM   1237  CB  SER A 166      10.663  26.951  23.387  1.00 26.31           C  
ATOM   1238  OG  SER A 166      11.039  27.385  24.680  1.00 26.43           O  
ATOM   1239  N   GLY A 167       8.475  29.180  23.015  1.00 26.17           N  
ATOM   1240  CA  GLY A 167       7.859  30.441  23.418  1.00 26.02           C  
ATOM   1241  C   GLY A 167       6.343  30.383  23.429  1.00 25.98           C  
ATOM   1242  O   GLY A 167       5.714  30.767  24.416  1.00 25.93           O  
ATOM   1243  N   CYS A 168       5.764  29.894  22.333  1.00 25.91           N  
ATOM   1244  CA  CYS A 168       4.309  29.810  22.170  1.00 25.86           C  
ATOM   1245  C   CYS A 168       3.717  28.531  22.749  1.00 25.81           C  
ATOM   1246  O   CYS A 168       2.521  28.474  23.044  1.00 25.86           O  
ATOM   1247  CB  CYS A 168       3.931  29.902  20.695  1.00 25.90           C  
ATOM   1248  SG  CYS A 168       4.438  31.410  19.894  1.00 25.84           S  
ATOM   1249  N   GLY A 169       4.563  27.514  22.899  1.00 25.75           N  
ATOM   1250  CA  GLY A 169       4.162  26.195  23.385  1.00 25.62           C  
ATOM   1251  C   GLY A 169       3.188  26.136  24.551  1.00 25.60           C  
ATOM   1252  O   GLY A 169       2.196  25.410  24.472  1.00 25.47           O  
ATOM   1253  N   PRO A 170       3.459  26.890  25.642  1.00 25.59           N  
ATOM   1254  CA  PRO A 170       2.550  26.846  26.789  1.00 25.59           C  
ATOM   1255  C   PRO A 170       1.080  27.002  26.408  1.00 25.58           C  
ATOM   1256  O   PRO A 170       0.235  26.294  26.952  1.00 25.67           O  
ATOM   1257  CB  PRO A 170       3.015  28.023  27.648  1.00 25.63           C  
ATOM   1258  CG  PRO A 170       4.456  28.143  27.345  1.00 25.51           C  
ATOM   1259  CD  PRO A 170       4.595  27.801  25.890  1.00 25.53           C  
ATOM   1260  N   ALA A 171       0.793  27.904  25.467  1.00 25.62           N  
ATOM   1261  CA  ALA A 171      -0.575  28.158  25.011  1.00 25.54           C  
ATOM   1262  C   ALA A 171      -1.243  26.923  24.407  1.00 25.46           C  
ATOM   1263  O   ALA A 171      -2.426  26.689  24.641  1.00 25.62           O  
ATOM   1264  CB  ALA A 171      -0.602  29.310  24.022  1.00 25.56           C  
ATOM   1265  N   TYR A 172      -0.485  26.142  23.635  1.00 25.39           N  
ATOM   1266  CA  TYR A 172      -1.010  24.910  23.041  1.00 25.25           C  
ATOM   1267  C   TYR A 172      -1.262  23.863  24.123  1.00 25.10           C  
ATOM   1268  O   TYR A 172      -2.256  23.137  24.075  1.00 25.03           O  
ATOM   1269  CB  TYR A 172      -0.063  24.324  21.980  1.00 25.30           C  
ATOM   1270  CG  TYR A 172       0.633  25.313  21.063  1.00 25.28           C  
ATOM   1271  CD1 TYR A 172       1.978  25.154  20.751  1.00 25.37           C  
ATOM   1272  CD2 TYR A 172      -0.051  26.392  20.495  1.00 25.47           C  
ATOM   1273  CE1 TYR A 172       2.631  26.039  19.910  1.00 25.53           C  
ATOM   1274  CE2 TYR A 172       0.599  27.291  19.652  1.00 25.43           C  
ATOM   1275  CZ  TYR A 172       1.941  27.105  19.366  1.00 25.53           C  
ATOM   1276  OH  TYR A 172       2.600  27.980  18.533  1.00 25.70           O  
ATOM   1277  N   VAL A 173      -0.348  23.797  25.091  1.00 24.90           N  
ATOM   1278  CA  VAL A 173      -0.460  22.875  26.220  1.00 24.73           C  
ATOM   1279  C   VAL A 173      -1.616  23.286  27.134  1.00 24.62           C  
ATOM   1280  O   VAL A 173      -2.408  22.440  27.544  1.00 24.62           O  
ATOM   1281  CB  VAL A 173       0.866  22.764  27.023  1.00 24.75           C  
ATOM   1282  CG1 VAL A 173       0.794  21.625  28.037  1.00 24.55           C  
ATOM   1283  CG2 VAL A 173       2.045  22.547  26.083  1.00 24.47           C  
ATOM   1284  N   TYR A 174      -1.718  24.583  27.431  1.00 24.56           N  
ATOM   1285  CA  TYR A 174      -2.838  25.122  28.211  1.00 24.47           C  
ATOM   1286  C   TYR A 174      -4.186  24.781  27.584  1.00 24.47           C  
ATOM   1287  O   TYR A 174      -5.118  24.398  28.291  1.00 24.58           O  
ATOM   1288  CB  TYR A 174      -2.731  26.642  28.386  1.00 24.34           C  
ATOM   1289  CG  TYR A 174      -1.633  27.119  29.317  1.00 24.41           C  
ATOM   1290  CD1 TYR A 174      -1.333  26.437  30.500  1.00 24.13           C  
ATOM   1291  CD2 TYR A 174      -0.914  28.278  29.028  1.00 24.50           C  
ATOM   1292  CE1 TYR A 174      -0.328  26.889  31.356  1.00 24.24           C  
ATOM   1293  CE2 TYR A 174       0.087  28.738  29.874  1.00 24.41           C  
ATOM   1294  CZ  TYR A 174       0.376  28.040  31.034  1.00 24.45           C  
ATOM   1295  OH  TYR A 174       1.367  28.506  31.864  1.00 24.27           O  
ATOM   1296  N   LEU A 175      -4.280  24.922  26.261  1.00 24.45           N  
ATOM   1297  CA  LEU A 175      -5.512  24.623  25.531  1.00 24.41           C  
ATOM   1298  C   LEU A 175      -5.785  23.122  25.479  1.00 24.34           C  
ATOM   1299  O   LEU A 175      -6.937  22.696  25.559  1.00 24.47           O  
ATOM   1300  CB  LEU A 175      -5.475  25.224  24.118  1.00 24.41           C  
ATOM   1301  CG  LEU A 175      -6.757  25.167  23.274  1.00 24.24           C  
ATOM   1302  CD1 LEU A 175      -7.902  25.945  23.914  1.00 24.22           C  
ATOM   1303  CD2 LEU A 175      -6.495  25.679  21.871  1.00 24.41           C  
ATOM   1304  N   PHE A 176      -4.722  22.332  25.339  1.00 24.31           N  
ATOM   1305  CA  PHE A 176      -4.795  20.873  25.418  1.00 24.24           C  
ATOM   1306  C   PHE A 176      -5.382  20.455  26.770  1.00 24.32           C  
ATOM   1307  O   PHE A 176      -6.360  19.706  26.822  1.00 24.24           O  
ATOM   1308  CB  PHE A 176      -3.396  20.278  25.214  1.00 24.22           C  
ATOM   1309  CG  PHE A 176      -3.369  18.779  25.059  1.00 24.19           C  
ATOM   1310  CD1 PHE A 176      -3.994  18.159  23.983  1.00 24.05           C  
ATOM   1311  CD2 PHE A 176      -2.672  17.993  25.971  1.00 24.40           C  
ATOM   1312  CE1 PHE A 176      -3.952  16.776  23.834  1.00 24.16           C  
ATOM   1313  CE2 PHE A 176      -2.619  16.607  25.828  1.00 24.32           C  
ATOM   1314  CZ  PHE A 176      -3.264  15.999  24.756  1.00 24.17           C  
ATOM   1315  N   ILE A 177      -4.793  20.975  27.849  1.00 24.39           N  
ATOM   1316  CA  ILE A 177      -5.272  20.754  29.218  1.00 24.46           C  
ATOM   1317  C   ILE A 177      -6.717  21.227  29.374  1.00 24.48           C  
ATOM   1318  O   ILE A 177      -7.542  20.534  29.971  1.00 24.47           O  
ATOM   1319  CB  ILE A 177      -4.357  21.460  30.265  1.00 24.46           C  
ATOM   1320  CG1 ILE A 177      -2.945  20.862  30.236  1.00 24.40           C  
ATOM   1321  CG2 ILE A 177      -4.945  21.363  31.676  1.00 24.32           C  
ATOM   1322  CD1 ILE A 177      -1.874  21.734  30.879  1.00 24.52           C  
ATOM   1323  N   GLU A 178      -7.007  22.404  28.820  1.00 24.60           N  
ATOM   1324  CA  GLU A 178      -8.351  22.983  28.825  1.00 24.71           C  
ATOM   1325  C   GLU A 178      -9.376  22.068  28.149  1.00 24.73           C  
ATOM   1326  O   GLU A 178     -10.469  21.863  28.678  1.00 24.83           O  
ATOM   1327  CB  GLU A 178      -8.325  24.352  28.138  1.00 24.70           C  
ATOM   1328  CG  GLU A 178      -9.638  25.124  28.154  1.00 24.77           C  
ATOM   1329  CD  GLU A 178      -9.592  26.374  27.286  1.00 24.91           C  
ATOM   1330  OE1 GLU A 178      -8.515  27.004  27.191  1.00 25.15           O  
ATOM   1331  OE2 GLU A 178     -10.638  26.735  26.703  1.00 24.95           O  
ATOM   1332  N   SER A 179      -9.008  21.522  26.992  1.00 24.77           N  
ATOM   1333  CA  SER A 179      -9.898  20.665  26.203  1.00 24.84           C  
ATOM   1334  C   SER A 179     -10.160  19.318  26.875  1.00 24.94           C  
ATOM   1335  O   SER A 179     -11.275  18.797  26.820  1.00 24.97           O  
ATOM   1336  CB  SER A 179      -9.323  20.440  24.802  1.00 24.79           C  
ATOM   1337  OG  SER A 179      -8.909  21.657  24.214  1.00 24.52           O  
ATOM   1338  N   LEU A 180      -9.127  18.760  27.502  1.00 25.06           N  
ATOM   1339  CA  LEU A 180      -9.240  17.476  28.193  1.00 25.13           C  
ATOM   1340  C   LEU A 180     -10.164  17.562  29.407  1.00 25.27           C  
ATOM   1341  O   LEU A 180     -10.978  16.663  29.634  1.00 25.38           O  
ATOM   1342  CB  LEU A 180      -7.858  16.955  28.597  1.00 25.06           C  
ATOM   1343  CG  LEU A 180      -6.955  16.379  27.501  1.00 24.84           C  
ATOM   1344  CD1 LEU A 180      -5.511  16.382  27.957  1.00 24.47           C  
ATOM   1345  CD2 LEU A 180      -7.390  14.975  27.093  1.00 24.65           C  
ATOM   1346  N   ILE A 181     -10.036  18.648  30.171  1.00 25.32           N  
ATOM   1347  CA  ILE A 181     -10.906  18.908  31.325  1.00 25.43           C  
ATOM   1348  C   ILE A 181     -12.372  19.052  30.895  1.00 25.51           C  
ATOM   1349  O   ILE A 181     -13.259  18.447  31.499  1.00 25.48           O  
ATOM   1350  CB  ILE A 181     -10.440  20.155  32.134  1.00 25.42           C  
ATOM   1351  CG1 ILE A 181      -9.066  19.896  32.768  1.00 25.39           C  
ATOM   1352  CG2 ILE A 181     -11.463  20.529  33.212  1.00 25.22           C  
ATOM   1353  CD1 ILE A 181      -8.351  21.149  33.269  1.00 25.47           C  
ATOM   1354  N   ASP A 182     -12.609  19.832  29.840  1.00 25.62           N  
ATOM   1355  CA  ASP A 182     -13.953  20.039  29.294  1.00 25.66           C  
ATOM   1356  C   ASP A 182     -14.624  18.745  28.841  1.00 25.60           C  
ATOM   1357  O   ASP A 182     -15.829  18.566  29.030  1.00 25.65           O  
ATOM   1358  CB  ASP A 182     -13.919  21.042  28.136  1.00 25.69           C  
ATOM   1359  CG  ASP A 182     -13.916  22.478  28.612  1.00 26.00           C  
ATOM   1360  OD1 ASP A 182     -14.313  22.732  29.768  1.00 26.77           O  
ATOM   1361  OD2 ASP A 182     -13.520  23.360  27.828  1.00 26.15           O  
ATOM   1362  N   ALA A 183     -13.835  17.855  28.242  1.00 25.54           N  
ATOM   1363  CA  ALA A 183     -14.310  16.538  27.835  1.00 25.54           C  
ATOM   1364  C   ALA A 183     -14.762  15.725  29.048  1.00 25.54           C  
ATOM   1365  O   ALA A 183     -15.759  15.002  28.983  1.00 25.47           O  
ATOM   1366  CB  ALA A 183     -13.223  15.802  27.069  1.00 25.54           C  
ATOM   1367  N   GLY A 184     -14.024  15.864  30.150  1.00 25.61           N  
ATOM   1368  CA  GLY A 184     -14.356  15.211  31.414  1.00 25.65           C  
ATOM   1369  C   GLY A 184     -15.575  15.801  32.092  1.00 25.69           C  
ATOM   1370  O   GLY A 184     -16.442  15.064  32.567  1.00 25.69           O  
ATOM   1371  N   VAL A 185     -15.638  17.131  32.138  1.00 25.82           N  
ATOM   1372  CA  VAL A 185     -16.777  17.842  32.728  1.00 25.91           C  
ATOM   1373  C   VAL A 185     -18.068  17.531  31.965  1.00 26.04           C  
ATOM   1374  O   VAL A 185     -19.111  17.313  32.577  1.00 26.17           O  
ATOM   1375  CB  VAL A 185     -16.545  19.378  32.800  1.00 25.85           C  
ATOM   1376  CG1 VAL A 185     -17.729  20.078  33.464  1.00 25.78           C  
ATOM   1377  CG2 VAL A 185     -15.270  19.696  33.561  1.00 25.83           C  
ATOM   1378  N   LYS A 186     -17.983  17.493  30.636  1.00 26.12           N  
ATOM   1379  CA  LYS A 186     -19.137  17.183  29.793  1.00 26.13           C  
ATOM   1380  C   LYS A 186     -19.709  15.793  30.079  1.00 26.26           C  
ATOM   1381  O   LYS A 186     -20.924  15.604  30.060  1.00 26.27           O  
ATOM   1382  CB  LYS A 186     -18.782  17.315  28.305  1.00 26.13           C  
ATOM   1383  CG  LYS A 186     -19.954  17.079  27.360  1.00 25.96           C  
ATOM   1384  CD  LYS A 186     -19.531  17.088  25.906  1.00 25.98           C  
ATOM   1385  CE  LYS A 186     -20.722  16.832  24.992  1.00 25.50           C  
ATOM   1386  NZ  LYS A 186     -21.111  15.400  24.922  1.00 25.51           N  
ATOM   1387  N   ASN A 187     -18.833  14.828  30.347  1.00 26.40           N  
ATOM   1388  CA  ASN A 187     -19.259  13.441  30.507  1.00 26.60           C  
ATOM   1389  C   ASN A 187     -19.393  12.947  31.958  1.00 26.76           C  
ATOM   1390  O   ASN A 187     -19.368  11.738  32.210  1.00 26.78           O  
ATOM   1391  CB  ASN A 187     -18.373  12.509  29.675  1.00 26.59           C  
ATOM   1392  CG  ASN A 187     -18.589  12.676  28.179  1.00 26.54           C  
ATOM   1393  OD1 ASN A 187     -17.745  13.229  27.476  1.00 26.90           O  
ATOM   1394  ND2 ASN A 187     -19.724  12.200  27.687  1.00 26.24           N  
ATOM   1395  N   GLY A 188     -19.544  13.875  32.902  1.00 26.86           N  
ATOM   1396  CA  GLY A 188     -19.913  13.512  34.272  1.00 27.22           C  
ATOM   1397  C   GLY A 188     -18.966  13.874  35.402  1.00 27.41           C  
ATOM   1398  O   GLY A 188     -19.400  14.017  36.546  1.00 27.49           O  
ATOM   1399  N   LEU A 189     -17.679  14.011  35.095  1.00 27.64           N  
ATOM   1400  CA  LEU A 189     -16.675  14.321  36.114  1.00 27.93           C  
ATOM   1401  C   LEU A 189     -16.739  15.782  36.547  1.00 28.23           C  
ATOM   1402  O   LEU A 189     -17.148  16.652  35.776  1.00 28.21           O  
ATOM   1403  CB  LEU A 189     -15.260  14.000  35.617  1.00 27.85           C  
ATOM   1404  CG  LEU A 189     -14.868  12.600  35.132  1.00 27.61           C  
ATOM   1405  CD1 LEU A 189     -13.395  12.591  34.759  1.00 27.28           C  
ATOM   1406  CD2 LEU A 189     -15.158  11.521  36.165  1.00 27.40           C  
ATOM   1407  N   SER A 190     -16.330  16.041  37.787  1.00 28.58           N  
ATOM   1408  CA  SER A 190     -16.206  17.405  38.290  1.00 28.91           C  
ATOM   1409  C   SER A 190     -15.008  18.082  37.629  1.00 29.20           C  
ATOM   1410  O   SER A 190     -14.111  17.406  37.121  1.00 29.19           O  
ATOM   1411  CB  SER A 190     -16.055  17.410  39.816  1.00 28.87           C  
ATOM   1412  OG  SER A 190     -14.750  17.016  40.213  1.00 28.89           O  
ATOM   1413  N   ARG A 191     -15.003  19.413  37.636  1.00 29.57           N  
ATOM   1414  CA  ARG A 191     -13.905  20.189  37.063  1.00 30.01           C  
ATOM   1415  C   ARG A 191     -12.599  19.978  37.835  1.00 30.19           C  
ATOM   1416  O   ARG A 191     -11.522  19.915  37.235  1.00 30.28           O  
ATOM   1417  CB  ARG A 191     -14.286  21.675  36.986  1.00 30.09           C  
ATOM   1418  CG  ARG A 191     -13.172  22.609  36.526  1.00 30.47           C  
ATOM   1419  CD  ARG A 191     -13.722  23.841  35.826  1.00 31.01           C  
ATOM   1420  NE  ARG A 191     -13.795  23.639  34.382  1.00 32.03           N  
ATOM   1421  CZ  ARG A 191     -14.918  23.484  33.683  1.00 32.11           C  
ATOM   1422  NH1 ARG A 191     -14.846  23.303  32.374  1.00 32.24           N  
ATOM   1423  NH2 ARG A 191     -16.105  23.520  34.276  1.00 32.34           N  
ATOM   1424  N   GLU A 192     -12.707  19.856  39.158  1.00 30.43           N  
ATOM   1425  CA  GLU A 192     -11.545  19.635  40.022  1.00 30.65           C  
ATOM   1426  C   GLU A 192     -10.885  18.287  39.737  1.00 30.41           C  
ATOM   1427  O   GLU A 192      -9.671  18.218  39.532  1.00 30.51           O  
ATOM   1428  CB  GLU A 192     -11.938  19.739  41.500  1.00 30.67           C  
ATOM   1429  CG  GLU A 192     -10.753  19.930  42.453  1.00 31.18           C  
ATOM   1430  CD  GLU A 192     -11.165  19.965  43.919  1.00 31.31           C  
ATOM   1431  OE1 GLU A 192     -10.868  20.976  44.594  1.00 32.22           O  
ATOM   1432  OE2 GLU A 192     -11.785  18.989  44.397  1.00 31.92           O  
ATOM   1433  N   LEU A 193     -11.692  17.227  39.718  1.00 30.24           N  
ATOM   1434  CA  LEU A 193     -11.202  15.876  39.451  1.00 30.05           C  
ATOM   1435  C   LEU A 193     -10.620  15.747  38.044  1.00 29.96           C  
ATOM   1436  O   LEU A 193      -9.551  15.164  37.866  1.00 29.99           O  
ATOM   1437  CB  LEU A 193     -12.310  14.839  39.669  1.00 30.05           C  
ATOM   1438  CG  LEU A 193     -12.004  13.372  39.345  1.00 29.93           C  
ATOM   1439  CD1 LEU A 193     -11.045  12.756  40.360  1.00 29.57           C  
ATOM   1440  CD2 LEU A 193     -13.291  12.577  39.272  1.00 29.98           C  
ATOM   1441  N   SER A 194     -11.331  16.295  37.057  1.00 29.91           N  
ATOM   1442  CA  SER A 194     -10.873  16.291  35.668  1.00 29.76           C  
ATOM   1443  C   SER A 194      -9.481  16.894  35.548  1.00 29.71           C  
ATOM   1444  O   SER A 194      -8.613  16.320  34.894  1.00 29.61           O  
ATOM   1445  CB  SER A 194     -11.855  17.038  34.763  1.00 29.76           C  
ATOM   1446  OG  SER A 194     -13.082  16.343  34.659  1.00 29.59           O  
ATOM   1447  N   LYS A 195      -9.279  18.040  36.198  1.00 29.77           N  
ATOM   1448  CA  LYS A 195      -7.983  18.718  36.228  1.00 29.87           C  
ATOM   1449  C   LYS A 195      -6.887  17.843  36.844  1.00 29.72           C  
ATOM   1450  O   LYS A 195      -5.798  17.730  36.282  1.00 29.84           O  
ATOM   1451  CB  LYS A 195      -8.091  20.061  36.962  1.00 29.87           C  
ATOM   1452  CG  LYS A 195      -6.805  20.887  36.963  1.00 30.10           C  
ATOM   1453  CD  LYS A 195      -7.024  22.308  37.479  1.00 30.22           C  
ATOM   1454  CE  LYS A 195      -7.163  22.350  38.995  1.00 31.09           C  
ATOM   1455  NZ  LYS A 195      -7.332  23.749  39.490  1.00 31.46           N  
ATOM   1456  N   ASN A 196      -7.184  17.221  37.986  1.00 29.61           N  
ATOM   1457  CA  ASN A 196      -6.240  16.316  38.650  1.00 29.48           C  
ATOM   1458  C   ASN A 196      -5.835  15.144  37.762  1.00 29.37           C  
ATOM   1459  O   ASN A 196      -4.649  14.837  37.628  1.00 29.39           O  
ATOM   1460  CB  ASN A 196      -6.820  15.789  39.966  1.00 29.52           C  
ATOM   1461  CG  ASN A 196      -6.996  16.875  41.009  1.00 29.61           C  
ATOM   1462  OD1 ASN A 196      -6.216  17.825  41.078  1.00 29.61           O  
ATOM   1463  ND2 ASN A 196      -8.027  16.731  41.837  1.00 29.75           N  
ATOM   1464  N   LEU A 197      -6.832  14.500  37.158  1.00 29.22           N  
ATOM   1465  CA  LEU A 197      -6.608  13.372  36.257  1.00 29.03           C  
ATOM   1466  C   LEU A 197      -5.841  13.759  34.995  1.00 28.90           C  
ATOM   1467  O   LEU A 197      -5.040  12.975  34.500  1.00 28.92           O  
ATOM   1468  CB  LEU A 197      -7.939  12.711  35.888  1.00 29.03           C  
ATOM   1469  CG  LEU A 197      -8.333  11.400  36.579  1.00 28.99           C  
ATOM   1470  CD1 LEU A 197      -8.277  11.485  38.098  1.00 29.06           C  
ATOM   1471  CD2 LEU A 197      -9.716  10.969  36.118  1.00 29.00           C  
ATOM   1472  N   VAL A 198      -6.091  14.962  34.484  1.00 28.74           N  
ATOM   1473  CA  VAL A 198      -5.403  15.464  33.292  1.00 28.61           C  
ATOM   1474  C   VAL A 198      -3.934  15.774  33.590  1.00 28.57           C  
ATOM   1475  O   VAL A 198      -3.039  15.277  32.900  1.00 28.49           O  
ATOM   1476  CB  VAL A 198      -6.127  16.704  32.683  1.00 28.58           C  
ATOM   1477  CG1 VAL A 198      -5.242  17.433  31.675  1.00 28.42           C  
ATOM   1478  CG2 VAL A 198      -7.431  16.284  32.030  1.00 28.40           C  
ATOM   1479  N   LEU A 199      -3.696  16.575  34.627  1.00 28.53           N  
ATOM   1480  CA  LEU A 199      -2.345  16.994  34.997  1.00 28.59           C  
ATOM   1481  C   LEU A 199      -1.436  15.823  35.372  1.00 28.72           C  
ATOM   1482  O   LEU A 199      -0.249  15.826  35.038  1.00 28.72           O  
ATOM   1483  CB  LEU A 199      -2.384  18.023  36.133  1.00 28.57           C  
ATOM   1484  CG  LEU A 199      -3.049  19.381  35.875  1.00 28.47           C  
ATOM   1485  CD1 LEU A 199      -3.037  20.215  37.143  1.00 28.18           C  
ATOM   1486  CD2 LEU A 199      -2.391  20.139  34.727  1.00 28.32           C  
ATOM   1487  N   GLN A 200      -2.000  14.826  36.054  1.00 28.81           N  
ATOM   1488  CA  GLN A 200      -1.252  13.636  36.456  1.00 28.92           C  
ATOM   1489  C   GLN A 200      -0.987  12.699  35.275  1.00 29.02           C  
ATOM   1490  O   GLN A 200       0.032  12.008  35.239  1.00 28.96           O  
ATOM   1491  CB  GLN A 200      -1.978  12.903  37.596  1.00 28.91           C  
ATOM   1492  CG  GLN A 200      -1.222  11.716  38.212  1.00 28.91           C  
ATOM   1493  CD  GLN A 200       0.204  12.047  38.636  1.00 28.99           C  
ATOM   1494  OE1 GLN A 200       0.502  13.163  39.067  1.00 29.09           O  
ATOM   1495  NE2 GLN A 200       1.093  11.067  38.517  1.00 29.05           N  
ATOM   1496  N   THR A 201      -1.908  12.691  34.313  1.00 29.21           N  
ATOM   1497  CA  THR A 201      -1.755  11.897  33.095  1.00 29.34           C  
ATOM   1498  C   THR A 201      -0.653  12.467  32.200  1.00 29.50           C  
ATOM   1499  O   THR A 201       0.121  11.714  31.606  1.00 29.54           O  
ATOM   1500  CB  THR A 201      -3.088  11.793  32.318  1.00 29.31           C  
ATOM   1501  OG1 THR A 201      -4.073  11.163  33.146  1.00 29.16           O  
ATOM   1502  CG2 THR A 201      -2.922  10.973  31.055  1.00 29.31           C  
ATOM   1503  N   ILE A 202      -0.584  13.793  32.115  1.00 29.74           N  
ATOM   1504  CA  ILE A 202       0.443  14.465  31.317  1.00 29.97           C  
ATOM   1505  C   ILE A 202       1.818  14.364  31.983  1.00 30.23           C  
ATOM   1506  O   ILE A 202       2.815  14.082  31.312  1.00 30.20           O  
ATOM   1507  CB  ILE A 202       0.082  15.945  31.026  1.00 29.93           C  
ATOM   1508  CG1 ILE A 202      -1.239  16.030  30.254  1.00 29.88           C  
ATOM   1509  CG2 ILE A 202       1.191  16.618  30.230  1.00 29.90           C  
ATOM   1510  CD1 ILE A 202      -1.817  17.428  30.152  1.00 29.86           C  
ATOM   1511  N   LYS A 203       1.857  14.582  33.298  1.00 30.57           N  
ATOM   1512  CA  LYS A 203       3.089  14.487  34.083  1.00 31.01           C  
ATOM   1513  C   LYS A 203       3.747  13.116  33.928  1.00 31.20           C  
ATOM   1514  O   LYS A 203       4.964  13.021  33.741  1.00 31.26           O  
ATOM   1515  CB  LYS A 203       2.811  14.786  35.560  1.00 30.95           C  
ATOM   1516  CG  LYS A 203       4.034  14.745  36.462  1.00 31.16           C  
ATOM   1517  CD  LYS A 203       3.711  15.256  37.861  1.00 31.31           C  
ATOM   1518  CE  LYS A 203       4.901  15.116  38.802  1.00 31.91           C  
ATOM   1519  NZ  LYS A 203       6.126  15.803  38.290  1.00 32.44           N  
ATOM   1520  N   GLY A 204       2.932  12.068  33.994  1.00 31.42           N  
ATOM   1521  CA  GLY A 204       3.407  10.700  33.834  1.00 31.82           C  
ATOM   1522  C   GLY A 204       3.884  10.387  32.428  1.00 32.12           C  
ATOM   1523  O   GLY A 204       4.863   9.663  32.251  1.00 32.14           O  
ATOM   1524  N   SER A 205       3.188  10.936  31.433  1.00 32.48           N  
ATOM   1525  CA  SER A 205       3.528  10.726  30.025  1.00 32.83           C  
ATOM   1526  C   SER A 205       4.871  11.354  29.651  1.00 33.14           C  
ATOM   1527  O   SER A 205       5.679  10.728  28.965  1.00 33.11           O  
ATOM   1528  CB  SER A 205       2.425  11.271  29.118  1.00 32.84           C  
ATOM   1529  OG  SER A 205       1.185  10.653  29.401  1.00 32.82           O  
ATOM   1530  N   VAL A 206       5.096  12.587  30.107  1.00 33.56           N  
ATOM   1531  CA  VAL A 206       6.359  13.299  29.884  1.00 34.02           C  
ATOM   1532  C   VAL A 206       7.532  12.534  30.503  1.00 34.36           C  
ATOM   1533  O   VAL A 206       8.575  12.360  29.867  1.00 34.38           O  
ATOM   1534  CB  VAL A 206       6.296  14.753  30.430  1.00 33.96           C  
ATOM   1535  CG1 VAL A 206       7.663  15.426  30.384  1.00 33.95           C  
ATOM   1536  CG2 VAL A 206       5.287  15.570  29.642  1.00 34.02           C  
ATOM   1537  N   GLU A 207       7.339  12.061  31.734  1.00 34.86           N  
ATOM   1538  CA  GLU A 207       8.353  11.295  32.454  1.00 35.38           C  
ATOM   1539  C   GLU A 207       8.707   9.992  31.740  1.00 35.55           C  
ATOM   1540  O   GLU A 207       9.869   9.579  31.730  1.00 35.67           O  
ATOM   1541  CB  GLU A 207       7.881  10.999  33.878  1.00 35.47           C  
ATOM   1542  CG  GLU A 207       9.003  10.972  34.905  1.00 36.21           C  
ATOM   1543  CD  GLU A 207       9.522  12.361  35.239  1.00 37.15           C  
ATOM   1544  OE1 GLU A 207       8.703  13.230  35.609  1.00 37.46           O  
ATOM   1545  OE2 GLU A 207      10.748  12.581  35.134  1.00 37.50           O  
HETATM 1546  N   MSE A 208       7.699   9.351  31.147  1.00 35.83           N  
HETATM 1547  CA  MSE A 208       7.889   8.128  30.370  1.00 36.08           C  
HETATM 1548  C   MSE A 208       8.783   8.363  29.155  1.00 36.19           C  
HETATM 1549  O   MSE A 208       9.644   7.543  28.852  1.00 36.17           O  
HETATM 1550  CB  MSE A 208       6.544   7.562  29.916  1.00 36.14           C  
HETATM 1551  CG  MSE A 208       5.710   6.915  31.015  1.00 36.45           C  
HETATM 1552 SE   MSE A 208       6.379   5.195  31.657  0.80 36.89          SE  
HETATM 1553  CE  MSE A 208       6.622   4.288  29.959  1.00 36.95           C  
ATOM   1554  N   VAL A 209       8.571   9.486  28.470  1.00 36.46           N  
ATOM   1555  CA  VAL A 209       9.374   9.861  27.305  1.00 36.68           C  
ATOM   1556  C   VAL A 209      10.836  10.089  27.699  1.00 36.85           C  
ATOM   1557  O   VAL A 209      11.751   9.621  27.018  1.00 36.86           O  
ATOM   1558  CB  VAL A 209       8.807  11.121  26.591  1.00 36.67           C  
ATOM   1559  CG1 VAL A 209       9.639  11.476  25.363  1.00 36.68           C  
ATOM   1560  CG2 VAL A 209       7.355  10.909  26.192  1.00 36.51           C  
ATOM   1561  N   LYS A 210      11.039  10.798  28.809  1.00 37.09           N  
ATOM   1562  CA  LYS A 210      12.376  11.136  29.298  1.00 37.25           C  
ATOM   1563  C   LYS A 210      13.175   9.908  29.719  1.00 37.38           C  
ATOM   1564  O   LYS A 210      14.353   9.783  29.382  1.00 37.47           O  
ATOM   1565  CB  LYS A 210      12.286  12.106  30.478  1.00 37.23           C  
ATOM   1566  CG  LYS A 210      11.804  13.497  30.124  1.00 37.28           C  
ATOM   1567  CD  LYS A 210      11.894  14.410  31.330  1.00 37.65           C  
ATOM   1568  CE  LYS A 210      11.479  15.825  30.980  1.00 38.07           C  
ATOM   1569  NZ  LYS A 210      11.636  16.745  32.141  1.00 38.40           N  
ATOM   1570  N   LYS A 211      12.521   9.004  30.443  1.00 37.50           N  
ATOM   1571  CA  LYS A 211      13.199   7.875  31.082  1.00 37.57           C  
ATOM   1572  C   LYS A 211      13.289   6.620  30.216  1.00 37.47           C  
ATOM   1573  O   LYS A 211      14.222   5.831  30.368  1.00 37.57           O  
ATOM   1574  CB  LYS A 211      12.539   7.547  32.424  1.00 37.63           C  
ATOM   1575  CG  LYS A 211      12.802   8.582  33.504  1.00 38.03           C  
ATOM   1576  CD  LYS A 211      12.075   8.238  34.789  1.00 38.58           C  
ATOM   1577  CE  LYS A 211      12.330   9.286  35.860  1.00 39.07           C  
ATOM   1578  NZ  LYS A 211      11.488   9.054  37.067  1.00 39.36           N  
ATOM   1579  N   SER A 212      12.326   6.438  29.318  1.00 37.35           N  
ATOM   1580  CA  SER A 212      12.295   5.254  28.459  1.00 37.21           C  
ATOM   1581  C   SER A 212      13.272   5.349  27.293  1.00 37.04           C  
ATOM   1582  O   SER A 212      13.539   6.437  26.776  1.00 37.08           O  
ATOM   1583  CB  SER A 212      10.880   4.994  27.935  1.00 37.20           C  
ATOM   1584  OG  SER A 212      10.854   3.889  27.048  1.00 37.24           O  
ATOM   1585  N   ASP A 213      13.800   4.191  26.900  1.00 36.93           N  
ATOM   1586  CA  ASP A 213      14.685   4.065  25.745  0.50 36.85           C  
ATOM   1588  C   ASP A 213      13.873   3.965  24.456  1.00 36.71           C  
ATOM   1589  O   ASP A 213      14.397   4.160  23.356  1.00 36.77           O  
ATOM   1590  CB  ASP A 213      15.596   2.840  25.899  0.50 36.90           C  
ATOM   1592  CG  ASP A 213      14.818   1.540  26.078  0.50 37.11           C  
ATOM   1594  OD1 ASP A 213      13.936   1.475  26.964  0.50 37.25           O  
ATOM   1596  OD2 ASP A 213      15.100   0.574  25.336  0.50 37.30           O  
ATOM   1598  N   GLN A 214      12.589   3.645  24.607  1.00 36.45           N  
ATOM   1599  CA  GLN A 214      11.652   3.552  23.492  1.00 36.08           C  
ATOM   1600  C   GLN A 214      11.258   4.954  23.016  1.00 35.69           C  
ATOM   1601  O   GLN A 214      11.134   5.871  23.834  1.00 35.64           O  
ATOM   1602  CB  GLN A 214      10.395   2.779  23.915  1.00 36.07           C  
ATOM   1603  CG  GLN A 214      10.649   1.358  24.410  1.00 36.14           C  
ATOM   1604  CD  GLN A 214       9.402   0.687  24.975  1.00 36.30           C  
ATOM   1605  OE1 GLN A 214       8.525   1.342  25.542  1.00 36.77           O  
ATOM   1606  NE2 GLN A 214       9.324  -0.631  24.826  1.00 36.36           N  
ATOM   1607  N   PRO A 215      11.067   5.129  21.693  1.00 35.31           N  
ATOM   1608  CA  PRO A 215      10.576   6.404  21.160  1.00 35.03           C  
ATOM   1609  C   PRO A 215       9.116   6.678  21.541  1.00 34.73           C  
ATOM   1610  O   PRO A 215       8.404   5.759  21.958  1.00 34.67           O  
ATOM   1611  CB  PRO A 215      10.711   6.225  19.645  1.00 35.04           C  
ATOM   1612  CG  PRO A 215      10.653   4.760  19.429  1.00 35.18           C  
ATOM   1613  CD  PRO A 215      11.319   4.148  20.621  1.00 35.30           C  
ATOM   1614  N   VAL A 216       8.690   7.934  21.396  1.00 34.35           N  
ATOM   1615  CA  VAL A 216       7.324   8.364  21.748  1.00 33.95           C  
ATOM   1616  C   VAL A 216       6.216   7.537  21.096  1.00 33.67           C  
ATOM   1617  O   VAL A 216       5.188   7.276  21.720  1.00 33.60           O  
ATOM   1618  CB  VAL A 216       7.066   9.865  21.424  1.00 33.96           C  
ATOM   1619  CG1 VAL A 216       7.675  10.754  22.479  1.00 33.94           C  
ATOM   1620  CG2 VAL A 216       7.579  10.240  20.033  1.00 33.85           C  
ATOM   1621  N   GLN A 217       6.435   7.137  19.846  1.00 33.35           N  
ATOM   1622  CA  GLN A 217       5.431   6.410  19.075  1.00 33.10           C  
ATOM   1623  C   GLN A 217       5.259   4.976  19.569  1.00 32.95           C  
ATOM   1624  O   GLN A 217       4.153   4.430  19.525  1.00 32.89           O  
ATOM   1625  CB  GLN A 217       5.773   6.418  17.584  1.00 33.06           C  
ATOM   1626  CG  GLN A 217       6.044   7.799  16.993  1.00 32.94           C  
ATOM   1627  CD  GLN A 217       7.526   8.140  16.928  1.00 33.04           C  
ATOM   1628  OE1 GLN A 217       8.306   7.772  17.809  1.00 33.06           O  
ATOM   1629  NE2 GLN A 217       7.921   8.848  15.874  1.00 32.76           N  
ATOM   1630  N   GLN A 218       6.353   4.371  20.030  1.00 32.76           N  
ATOM   1631  CA  GLN A 218       6.309   3.033  20.615  1.00 32.59           C  
ATOM   1632  C   GLN A 218       5.622   3.066  21.975  1.00 32.32           C  
ATOM   1633  O   GLN A 218       4.878   2.148  22.320  1.00 32.37           O  
ATOM   1634  CB  GLN A 218       7.709   2.436  20.748  1.00 32.57           C  
ATOM   1635  CG  GLN A 218       7.699   0.926  20.956  1.00 32.73           C  
ATOM   1636  CD  GLN A 218       9.066   0.350  21.257  1.00 32.83           C  
ATOM   1637  OE1 GLN A 218       9.192  -0.576  22.058  1.00 33.70           O  
ATOM   1638  NE2 GLN A 218      10.098   0.889  20.616  1.00 33.05           N  
ATOM   1639  N   LEU A 219       5.874   4.130  22.735  1.00 32.00           N  
ATOM   1640  CA  LEU A 219       5.215   4.343  24.018  1.00 31.72           C  
ATOM   1641  C   LEU A 219       3.711   4.519  23.825  1.00 31.64           C  
ATOM   1642  O   LEU A 219       2.915   4.079  24.658  1.00 31.69           O  
ATOM   1643  CB  LEU A 219       5.809   5.560  24.740  1.00 31.67           C  
ATOM   1644  CG  LEU A 219       7.271   5.490  25.198  1.00 31.47           C  
ATOM   1645  CD1 LEU A 219       7.764   6.860  25.623  1.00 31.28           C  
ATOM   1646  CD2 LEU A 219       7.463   4.484  26.324  1.00 31.23           C  
ATOM   1647  N   LYS A 220       3.342   5.159  22.717  1.00 31.45           N  
ATOM   1648  CA  LYS A 220       1.949   5.334  22.317  1.00 31.24           C  
ATOM   1649  C   LYS A 220       1.324   3.996  21.924  1.00 31.16           C  
ATOM   1650  O   LYS A 220       0.175   3.715  22.275  1.00 31.15           O  
ATOM   1651  CB  LYS A 220       1.866   6.308  21.141  1.00 31.26           C  
ATOM   1652  CG  LYS A 220       0.455   6.769  20.786  1.00 31.07           C  
ATOM   1653  CD  LYS A 220       0.192   6.651  19.287  1.00 30.88           C  
ATOM   1654  CE  LYS A 220       1.236   7.371  18.457  1.00 30.62           C  
ATOM   1655  NZ  LYS A 220       1.080   7.084  17.013  1.00 30.70           N  
ATOM   1656  N   ASP A 221       2.089   3.185  21.193  1.00 31.01           N  
ATOM   1657  CA  ASP A 221       1.651   1.859  20.754  1.00 30.78           C  
ATOM   1658  C   ASP A 221       1.354   0.932  21.928  1.00 30.68           C  
ATOM   1659  O   ASP A 221       0.376   0.180  21.895  1.00 30.76           O  
ATOM   1660  CB  ASP A 221       2.702   1.220  19.839  1.00 30.79           C  
ATOM   1661  CG  ASP A 221       2.682   1.784  18.423  1.00 30.58           C  
ATOM   1662  OD1 ASP A 221       1.882   2.702  18.136  1.00 30.34           O  
ATOM   1663  OD2 ASP A 221       3.474   1.302  17.590  1.00 30.47           O  
ATOM   1664  N   ASN A 222       2.197   1.001  22.960  1.00 30.51           N  
ATOM   1665  CA  ASN A 222       2.071   0.155  24.154  1.00 30.32           C  
ATOM   1666  C   ASN A 222       0.740   0.316  24.888  1.00 30.16           C  
ATOM   1667  O   ASN A 222       0.256  -0.622  25.524  1.00 30.23           O  
ATOM   1668  CB  ASN A 222       3.225   0.415  25.127  1.00 30.20           C  
ATOM   1669  CG  ASN A 222       4.591   0.083  24.539  1.00 30.15           C  
ATOM   1670  OD1 ASN A 222       5.602   0.650  24.949  1.00 30.10           O  
ATOM   1671  ND2 ASN A 222       4.627  -0.835  23.581  1.00 30.03           N  
ATOM   1672  N   ILE A 223       0.157   1.507  24.791  1.00 29.90           N  
ATOM   1673  CA  ILE A 223      -1.118   1.816  25.437  1.00 29.71           C  
ATOM   1674  C   ILE A 223      -2.316   1.231  24.681  1.00 29.52           C  
ATOM   1675  O   ILE A 223      -3.365   0.967  25.271  1.00 29.48           O  
ATOM   1676  CB  ILE A 223      -1.274   3.341  25.635  1.00 29.72           C  
ATOM   1677  CG1 ILE A 223      -0.229   3.832  26.634  1.00 29.76           C  
ATOM   1678  CG2 ILE A 223      -2.670   3.707  26.136  1.00 29.70           C  
ATOM   1679  CD1 ILE A 223      -0.159   5.307  26.748  1.00 29.85           C  
ATOM   1680  N   VAL A 224      -2.143   1.017  23.380  1.00 29.29           N  
ATOM   1681  CA  VAL A 224      -3.215   0.515  22.528  1.00 29.10           C  
ATOM   1682  C   VAL A 224      -3.383  -0.999  22.682  1.00 28.94           C  
ATOM   1683  O   VAL A 224      -2.705  -1.786  22.013  1.00 28.89           O  
ATOM   1684  CB  VAL A 224      -2.985   0.893  21.041  1.00 29.08           C  
ATOM   1685  CG1 VAL A 224      -4.216   0.585  20.212  1.00 29.04           C  
ATOM   1686  CG2 VAL A 224      -2.637   2.364  20.918  1.00 29.07           C  
ATOM   1687  N   SER A 225      -4.283  -1.393  23.583  1.00 28.74           N  
ATOM   1688  CA  SER A 225      -4.663  -2.795  23.749  1.00 28.59           C  
ATOM   1689  C   SER A 225      -5.499  -3.229  22.547  1.00 28.38           C  
ATOM   1690  O   SER A 225      -6.461  -2.547  22.191  1.00 28.39           O  
ATOM   1691  CB  SER A 225      -5.461  -2.997  25.043  1.00 28.59           C  
ATOM   1692  OG  SER A 225      -4.806  -2.420  26.160  1.00 28.90           O  
ATOM   1693  N   PRO A 226      -5.123  -4.356  21.909  1.00 28.21           N  
ATOM   1694  CA  PRO A 226      -5.822  -4.890  20.733  1.00 28.03           C  
ATOM   1695  C   PRO A 226      -7.339  -5.018  20.918  1.00 27.85           C  
ATOM   1696  O   PRO A 226      -7.802  -5.755  21.792  1.00 27.91           O  
ATOM   1697  CB  PRO A 226      -5.182  -6.268  20.549  1.00 28.03           C  
ATOM   1698  CG  PRO A 226      -3.814  -6.101  21.089  1.00 28.08           C  
ATOM   1699  CD  PRO A 226      -3.967  -5.194  22.274  1.00 28.13           C  
ATOM   1700  N   GLY A 227      -8.091  -4.292  20.093  1.00 27.62           N  
ATOM   1701  CA  GLY A 227      -9.553  -4.273  20.168  1.00 27.24           C  
ATOM   1702  C   GLY A 227     -10.092  -3.488  21.349  1.00 26.97           C  
ATOM   1703  O   GLY A 227     -11.218  -3.719  21.791  1.00 26.99           O  
ATOM   1704  N   GLY A 228      -9.297  -2.545  21.850  1.00 26.78           N  
ATOM   1705  CA  GLY A 228      -9.615  -1.842  23.091  1.00 26.51           C  
ATOM   1706  C   GLY A 228     -10.122  -0.417  22.963  1.00 26.30           C  
ATOM   1707  O   GLY A 228     -10.554   0.014  21.893  1.00 26.29           O  
ATOM   1708  N   ILE A 229     -10.049   0.308  24.078  1.00 26.13           N  
ATOM   1709  CA  ILE A 229     -10.626   1.647  24.220  1.00 25.89           C  
ATOM   1710  C   ILE A 229      -9.744   2.745  23.614  1.00 25.77           C  
ATOM   1711  O   ILE A 229     -10.243   3.639  22.925  1.00 25.74           O  
ATOM   1712  CB  ILE A 229     -10.913   1.963  25.713  1.00 25.91           C  
ATOM   1713  CG1 ILE A 229     -11.788   0.867  26.332  1.00 25.84           C  
ATOM   1714  CG2 ILE A 229     -11.569   3.334  25.866  1.00 25.94           C  
ATOM   1715  CD1 ILE A 229     -11.956   0.975  27.834  1.00 25.85           C  
ATOM   1716  N   THR A 230      -8.440   2.666  23.878  1.00 25.57           N  
ATOM   1717  CA  THR A 230      -7.466   3.651  23.408  1.00 25.36           C  
ATOM   1718  C   THR A 230      -7.402   3.712  21.883  1.00 25.24           C  
ATOM   1719  O   THR A 230      -7.229   4.788  21.301  1.00 25.16           O  
ATOM   1720  CB  THR A 230      -6.068   3.370  24.003  1.00 25.37           C  
ATOM   1721  OG1 THR A 230      -6.123   3.528  25.426  1.00 25.45           O  
ATOM   1722  CG2 THR A 230      -5.027   4.323  23.443  1.00 25.27           C  
ATOM   1723  N   ALA A 231      -7.561   2.554  21.248  1.00 25.07           N  
ATOM   1724  CA  ALA A 231      -7.585   2.447  19.793  1.00 24.92           C  
ATOM   1725  C   ALA A 231      -8.691   3.299  19.164  1.00 24.83           C  
ATOM   1726  O   ALA A 231      -8.492   3.899  18.110  1.00 24.82           O  
ATOM   1727  CB  ALA A 231      -7.734   0.992  19.381  1.00 24.90           C  
ATOM   1728  N   VAL A 232      -9.845   3.347  19.824  1.00 24.72           N  
ATOM   1729  CA  VAL A 232     -10.995   4.124  19.361  1.00 24.61           C  
ATOM   1730  C   VAL A 232     -10.763   5.635  19.523  1.00 24.56           C  
ATOM   1731  O   VAL A 232     -11.114   6.420  18.640  1.00 24.53           O  
ATOM   1732  CB  VAL A 232     -12.302   3.663  20.069  1.00 24.55           C  
ATOM   1733  CG1 VAL A 232     -13.453   4.620  19.798  1.00 24.49           C  
ATOM   1734  CG2 VAL A 232     -12.671   2.258  19.621  1.00 24.46           C  
ATOM   1735  N   GLY A 233     -10.158   6.025  20.643  1.00 24.55           N  
ATOM   1736  CA  GLY A 233      -9.806   7.421  20.901  1.00 24.49           C  
ATOM   1737  C   GLY A 233      -8.744   7.965  19.961  1.00 24.50           C  
ATOM   1738  O   GLY A 233      -8.805   9.127  19.553  1.00 24.51           O  
ATOM   1739  N   LEU A 234      -7.770   7.123  19.622  1.00 24.45           N  
ATOM   1740  CA  LEU A 234      -6.702   7.488  18.688  1.00 24.53           C  
ATOM   1741  C   LEU A 234      -7.190   7.569  17.246  1.00 24.55           C  
ATOM   1742  O   LEU A 234      -6.759   8.436  16.484  1.00 24.56           O  
ATOM   1743  CB  LEU A 234      -5.528   6.508  18.804  1.00 24.45           C  
ATOM   1744  CG  LEU A 234      -4.226   6.990  19.455  1.00 24.55           C  
ATOM   1745  CD1 LEU A 234      -4.455   7.937  20.631  1.00 24.63           C  
ATOM   1746  CD2 LEU A 234      -3.388   5.800  19.884  1.00 24.54           C  
ATOM   1747  N   TYR A 235      -8.085   6.651  16.887  1.00 24.59           N  
ATOM   1748  CA  TYR A 235      -8.749   6.622  15.585  1.00 24.62           C  
ATOM   1749  C   TYR A 235      -9.506   7.925  15.335  1.00 24.71           C  
ATOM   1750  O   TYR A 235      -9.527   8.438  14.214  1.00 24.79           O  
ATOM   1751  CB  TYR A 235      -9.711   5.434  15.557  1.00 24.65           C  
ATOM   1752  CG  TYR A 235     -10.396   5.140  14.242  1.00 24.58           C  
ATOM   1753  CD1 TYR A 235      -9.675   4.680  13.143  1.00 24.56           C  
ATOM   1754  CD2 TYR A 235     -11.779   5.271  14.116  1.00 24.52           C  
ATOM   1755  CE1 TYR A 235     -10.309   4.388  11.941  1.00 24.68           C  
ATOM   1756  CE2 TYR A 235     -12.423   4.978  12.921  1.00 24.39           C  
ATOM   1757  CZ  TYR A 235     -11.681   4.537  11.839  1.00 24.71           C  
ATOM   1758  OH  TYR A 235     -12.311   4.248  10.652  1.00 24.81           O  
ATOM   1759  N   SER A 236     -10.116   8.451  16.396  1.00 24.79           N  
ATOM   1760  CA  SER A 236     -10.833   9.719  16.351  1.00 24.91           C  
ATOM   1761  C   SER A 236      -9.890  10.899  16.102  1.00 25.01           C  
ATOM   1762  O   SER A 236     -10.221  11.808  15.341  1.00 24.99           O  
ATOM   1763  CB  SER A 236     -11.610   9.925  17.652  1.00 24.82           C  
ATOM   1764  OG  SER A 236     -12.283  11.171  17.658  1.00 25.07           O  
ATOM   1765  N   LEU A 237      -8.723  10.874  16.748  1.00 25.14           N  
ATOM   1766  CA  LEU A 237      -7.702  11.912  16.574  1.00 25.22           C  
ATOM   1767  C   LEU A 237      -7.139  11.925  15.156  1.00 25.35           C  
ATOM   1768  O   LEU A 237      -6.814  12.986  14.621  1.00 25.38           O  
ATOM   1769  CB  LEU A 237      -6.559  11.731  17.581  1.00 25.15           C  
ATOM   1770  CG  LEU A 237      -6.781  12.081  19.055  1.00 25.05           C  
ATOM   1771  CD1 LEU A 237      -5.546  11.716  19.863  1.00 25.03           C  
ATOM   1772  CD2 LEU A 237      -7.129  13.553  19.256  1.00 24.75           C  
ATOM   1773  N   GLU A 238      -7.022  10.741  14.560  1.00 25.49           N  
ATOM   1774  CA  GLU A 238      -6.560  10.601  13.181  1.00 25.72           C  
ATOM   1775  C   GLU A 238      -7.602  11.110  12.191  1.00 25.80           C  
ATOM   1776  O   GLU A 238      -7.261  11.753  11.198  1.00 25.92           O  
ATOM   1777  CB  GLU A 238      -6.210   9.140  12.870  1.00 25.69           C  
ATOM   1778  CG  GLU A 238      -5.051   8.572  13.679  1.00 26.05           C  
ATOM   1779  CD  GLU A 238      -3.752   9.341  13.501  1.00 26.59           C  
ATOM   1780  OE1 GLU A 238      -2.995   9.446  14.489  1.00 27.01           O  
ATOM   1781  OE2 GLU A 238      -3.478   9.831  12.382  1.00 26.72           O  
ATOM   1782  N   LYS A 239      -8.868  10.810  12.474  1.00 25.92           N  
ATOM   1783  CA  LYS A 239      -9.995  11.256  11.662  1.00 26.08           C  
ATOM   1784  C   LYS A 239     -10.015  12.777  11.543  1.00 26.02           C  
ATOM   1785  O   LYS A 239     -10.207  13.320  10.454  1.00 26.13           O  
ATOM   1786  CB  LYS A 239     -11.309  10.760  12.278  1.00 26.07           C  
ATOM   1787  CG  LYS A 239     -12.547  10.985  11.421  1.00 26.37           C  
ATOM   1788  CD  LYS A 239     -13.794  10.480  12.132  1.00 26.49           C  
ATOM   1789  CE  LYS A 239     -15.025  10.554  11.240  1.00 27.70           C  
ATOM   1790  NZ  LYS A 239     -15.472  11.953  10.980  1.00 28.32           N  
ATOM   1791  N   ASN A 240      -9.803  13.450  12.669  1.00 25.96           N  
ATOM   1792  CA  ASN A 240      -9.881  14.901  12.740  1.00 25.86           C  
ATOM   1793  C   ASN A 240      -8.525  15.595  12.583  1.00 25.84           C  
ATOM   1794  O   ASN A 240      -8.378  16.769  12.933  1.00 25.91           O  
ATOM   1795  CB  ASN A 240     -10.568  15.325  14.043  1.00 25.94           C  
ATOM   1796  CG  ASN A 240     -12.010  14.848  14.130  1.00 25.91           C  
ATOM   1797  OD1 ASN A 240     -12.708  14.748  13.121  1.00 26.27           O  
ATOM   1798  ND2 ASN A 240     -12.465  14.561  15.342  1.00 26.07           N  
ATOM   1799  N   SER A 241      -7.548  14.860  12.047  1.00 25.73           N  
ATOM   1800  CA  SER A 241      -6.213  15.382  11.736  1.00 25.66           C  
ATOM   1801  C   SER A 241      -5.562  16.114  12.910  1.00 25.59           C  
ATOM   1802  O   SER A 241      -5.113  17.254  12.769  1.00 25.59           O  
ATOM   1803  CB  SER A 241      -6.259  16.293  10.501  1.00 25.67           C  
ATOM   1804  OG  SER A 241      -6.790  15.614   9.382  1.00 25.74           O  
ATOM   1805  N   PHE A 242      -5.517  15.449  14.063  1.00 25.53           N  
ATOM   1806  CA  PHE A 242      -4.930  16.018  15.279  1.00 25.47           C  
ATOM   1807  C   PHE A 242      -3.470  16.411  15.072  1.00 25.51           C  
ATOM   1808  O   PHE A 242      -3.060  17.507  15.454  1.00 25.45           O  
ATOM   1809  CB  PHE A 242      -5.068  15.029  16.442  1.00 25.44           C  
ATOM   1810  CG  PHE A 242      -4.434  15.495  17.723  1.00 25.20           C  
ATOM   1811  CD1 PHE A 242      -5.056  16.450  18.518  1.00 25.16           C  
ATOM   1812  CD2 PHE A 242      -3.223  14.958  18.148  1.00 25.21           C  
ATOM   1813  CE1 PHE A 242      -4.475  16.872  19.709  1.00 25.25           C  
ATOM   1814  CE2 PHE A 242      -2.633  15.373  19.336  1.00 25.09           C  
ATOM   1815  CZ  PHE A 242      -3.261  16.332  20.118  1.00 25.26           C  
ATOM   1816  N   LYS A 243      -2.703  15.512  14.460  1.00 25.59           N  
ATOM   1817  CA  LYS A 243      -1.290  15.739  14.169  1.00 25.75           C  
ATOM   1818  C   LYS A 243      -1.077  16.972  13.292  1.00 25.88           C  
ATOM   1819  O   LYS A 243      -0.295  17.857  13.646  1.00 25.84           O  
ATOM   1820  CB  LYS A 243      -0.682  14.502  13.503  1.00 25.83           C  
ATOM   1821  CG  LYS A 243       0.834  14.514  13.425  1.00 25.88           C  
ATOM   1822  CD  LYS A 243       1.357  13.137  13.086  1.00 26.11           C  
ATOM   1823  CE  LYS A 243       2.717  12.910  13.694  1.00 26.01           C  
ATOM   1824  NZ  LYS A 243       3.357  11.685  13.155  1.00 26.14           N  
ATOM   1825  N   TYR A 244      -1.783  17.025  12.163  1.00 25.97           N  
ATOM   1826  CA  TYR A 244      -1.700  18.155  11.244  1.00 26.12           C  
ATOM   1827  C   TYR A 244      -2.116  19.469  11.902  1.00 26.24           C  
ATOM   1828  O   TYR A 244      -1.494  20.506  11.668  1.00 26.25           O  
ATOM   1829  CB  TYR A 244      -2.542  17.907   9.987  1.00 26.19           C  
ATOM   1830  CG  TYR A 244      -2.705  19.142   9.127  1.00 26.28           C  
ATOM   1831  CD1 TYR A 244      -1.650  19.616   8.349  1.00 26.24           C  
ATOM   1832  CD2 TYR A 244      -3.909  19.846   9.107  1.00 26.25           C  
ATOM   1833  CE1 TYR A 244      -1.791  20.754   7.566  1.00 26.30           C  
ATOM   1834  CE2 TYR A 244      -4.060  20.987   8.325  1.00 26.26           C  
ATOM   1835  CZ  TYR A 244      -2.995  21.435   7.559  1.00 26.36           C  
ATOM   1836  OH  TYR A 244      -3.134  22.561   6.780  1.00 26.87           O  
ATOM   1837  N   THR A 245      -3.170  19.414  12.714  1.00 26.27           N  
ATOM   1838  CA  THR A 245      -3.673  20.577  13.442  1.00 26.40           C  
ATOM   1839  C   THR A 245      -2.577  21.204  14.304  1.00 26.60           C  
ATOM   1840  O   THR A 245      -2.378  22.419  14.274  1.00 26.69           O  
ATOM   1841  CB  THR A 245      -4.906  20.204  14.303  1.00 26.30           C  
ATOM   1842  OG1 THR A 245      -5.985  19.823  13.444  1.00 25.84           O  
ATOM   1843  CG2 THR A 245      -5.356  21.367  15.177  1.00 26.21           C  
ATOM   1844  N   VAL A 246      -1.866  20.362  15.051  1.00 26.88           N  
ATOM   1845  CA  VAL A 246      -0.770  20.800  15.909  1.00 27.14           C  
ATOM   1846  C   VAL A 246       0.396  21.338  15.071  1.00 27.31           C  
ATOM   1847  O   VAL A 246       0.911  22.424  15.343  1.00 27.23           O  
ATOM   1848  CB  VAL A 246      -0.294  19.656  16.850  1.00 27.15           C  
ATOM   1849  CG1 VAL A 246       0.911  20.091  17.678  1.00 27.16           C  
ATOM   1850  CG2 VAL A 246      -1.426  19.205  17.764  1.00 27.16           C  
HETATM 1851  N   MSE A 247       0.787  20.577  14.050  1.00 27.58           N  
HETATM 1852  CA  MSE A 247       1.888  20.948  13.156  1.00 27.95           C  
HETATM 1853  C   MSE A 247       1.628  22.260  12.414  1.00 28.05           C  
HETATM 1854  O   MSE A 247       2.535  23.081  12.257  1.00 28.08           O  
HETATM 1855  CB  MSE A 247       2.165  19.832  12.145  1.00 27.93           C  
HETATM 1856  CG  MSE A 247       2.761  18.564  12.741  1.00 27.92           C  
HETATM 1857 SE   MSE A 247       3.241  17.270  11.364  0.80 28.29          SE  
HETATM 1858  CE  MSE A 247       4.764  18.216  10.594  1.00 27.90           C  
ATOM   1859  N   ASN A 248       0.388  22.439  11.964  1.00 28.23           N  
ATOM   1860  CA  ASN A 248      -0.041  23.650  11.268  1.00 28.35           C  
ATOM   1861  C   ASN A 248      -0.033  24.878  12.176  1.00 28.47           C  
ATOM   1862  O   ASN A 248       0.315  25.974  11.737  1.00 28.53           O  
ATOM   1863  CB  ASN A 248      -1.433  23.444  10.657  1.00 28.44           C  
ATOM   1864  CG  ASN A 248      -1.871  24.603   9.777  1.00 28.50           C  
ATOM   1865  OD1 ASN A 248      -2.886  25.244  10.044  1.00 28.86           O  
ATOM   1866  ND2 ASN A 248      -1.109  24.876   8.725  1.00 28.45           N  
ATOM   1867  N   ALA A 249      -0.411  24.685  13.438  1.00 28.59           N  
ATOM   1868  CA  ALA A 249      -0.391  25.759  14.432  1.00 28.76           C  
ATOM   1869  C   ALA A 249       1.025  26.258  14.703  1.00 28.83           C  
ATOM   1870  O   ALA A 249       1.268  27.466  14.741  1.00 28.90           O  
ATOM   1871  CB  ALA A 249      -1.041  25.301  15.717  1.00 28.74           C  
ATOM   1872  N   VAL A 250       1.948  25.317  14.890  1.00 28.90           N  
ATOM   1873  CA  VAL A 250       3.358  25.626  15.108  1.00 28.93           C  
ATOM   1874  C   VAL A 250       3.944  26.364  13.901  1.00 28.97           C  
ATOM   1875  O   VAL A 250       4.609  27.385  14.061  1.00 28.96           O  
ATOM   1876  CB  VAL A 250       4.181  24.345  15.416  1.00 28.91           C  
ATOM   1877  CG1 VAL A 250       5.665  24.663  15.532  1.00 28.77           C  
ATOM   1878  CG2 VAL A 250       3.687  23.681  16.696  1.00 28.83           C  
ATOM   1879  N   GLU A 251       3.675  25.848  12.702  1.00 29.06           N  
ATOM   1880  CA  GLU A 251       4.194  26.434  11.467  1.00 29.21           C  
ATOM   1881  C   GLU A 251       3.623  27.826  11.181  1.00 29.25           C  
ATOM   1882  O   GLU A 251       4.340  28.703  10.696  1.00 29.25           O  
ATOM   1883  CB  GLU A 251       3.958  25.493  10.281  1.00 29.22           C  
ATOM   1884  CG  GLU A 251       4.685  25.916   9.008  1.00 29.50           C  
ATOM   1885  CD  GLU A 251       4.847  24.792   8.006  1.00 29.83           C  
ATOM   1886  OE1 GLU A 251       5.102  23.640   8.421  1.00 30.27           O  
ATOM   1887  OE2 GLU A 251       4.739  25.067   6.795  1.00 30.18           O  
ATOM   1888  N   ALA A 252       2.340  28.020  11.486  1.00 29.32           N  
ATOM   1889  CA  ALA A 252       1.693  29.327  11.347  1.00 29.41           C  
ATOM   1890  C   ALA A 252       2.346  30.366  12.257  1.00 29.51           C  
ATOM   1891  O   ALA A 252       2.543  31.515  11.858  1.00 29.53           O  
ATOM   1892  CB  ALA A 252       0.204  29.225  11.638  1.00 29.34           C  
ATOM   1893  N   ALA A 253       2.675  29.946  13.478  1.00 29.67           N  
ATOM   1894  CA  ALA A 253       3.406  30.777  14.430  1.00 29.84           C  
ATOM   1895  C   ALA A 253       4.829  31.057  13.940  1.00 30.02           C  
ATOM   1896  O   ALA A 253       5.325  32.178  14.063  1.00 29.93           O  
ATOM   1897  CB  ALA A 253       3.426  30.117  15.800  1.00 29.74           C  
ATOM   1898  N   CYS A 254       5.469  30.035  13.371  1.00 30.25           N  
ATOM   1899  CA  CYS A 254       6.822  30.148  12.829  1.00 30.60           C  
ATOM   1900  C   CYS A 254       6.906  31.162  11.682  1.00 31.09           C  
ATOM   1901  O   CYS A 254       7.896  31.894  11.569  1.00 31.04           O  
ATOM   1902  CB  CYS A 254       7.325  28.776  12.374  1.00 30.52           C  
ATOM   1903  SG  CYS A 254       8.995  28.767  11.686  1.00 30.17           S  
ATOM   1904  N   GLU A 255       5.865  31.197  10.848  1.00 31.49           N  
ATOM   1905  CA  GLU A 255       5.770  32.140   9.731  0.50 31.84           C  
ATOM   1907  C   GLU A 255       5.582  33.571  10.224  1.00 32.00           C  
ATOM   1908  O   GLU A 255       6.103  34.519   9.632  1.00 32.03           O  
ATOM   1909  CB  GLU A 255       4.602  31.774   8.812  0.50 31.81           C  
ATOM   1911  CG  GLU A 255       4.834  30.562   7.921  0.50 31.96           C  
ATOM   1913  CD  GLU A 255       3.646  30.261   7.020  0.50 31.97           C  
ATOM   1915  OE1 GLU A 255       3.254  29.078   6.931  0.50 32.16           O  
ATOM   1917  OE2 GLU A 255       3.101  31.204   6.404  0.50 32.00           O  
ATOM   1919  N   LYS A 256       4.817  33.716  11.305  1.00 32.37           N  
ATOM   1920  CA  LYS A 256       4.540  35.023  11.900  1.00 32.87           C  
ATOM   1921  C   LYS A 256       5.802  35.613  12.529  1.00 33.36           C  
ATOM   1922  O   LYS A 256       6.039  36.820  12.438  1.00 33.35           O  
ATOM   1923  CB  LYS A 256       3.403  34.924  12.927  1.00 32.68           C  
ATOM   1924  CG  LYS A 256       3.082  36.220  13.677  1.00 32.51           C  
ATOM   1925  CD  LYS A 256       2.482  37.295  12.774  1.00 31.82           C  
ATOM   1926  CE  LYS A 256       2.194  38.561  13.558  1.00 31.52           C  
ATOM   1927  NZ  LYS A 256       1.474  39.581  12.751  1.00 31.39           N  
ATOM   1928  N   SER A 257       6.607  34.753  13.153  1.00 33.97           N  
ATOM   1929  CA  SER A 257       7.905  35.143  13.698  1.00 34.58           C  
ATOM   1930  C   SER A 257       8.848  35.631  12.594  1.00 35.11           C  
ATOM   1931  O   SER A 257       9.578  36.606  12.779  1.00 35.12           O  
ATOM   1932  CB  SER A 257       8.532  33.972  14.459  1.00 34.52           C  
ATOM   1933  OG  SER A 257       9.770  34.335  15.044  1.00 34.45           O  
ATOM   1934  N   LYS A 258       8.817  34.954  11.448  1.00 35.83           N  
ATOM   1935  CA  LYS A 258       9.640  35.322  10.296  1.00 36.61           C  
ATOM   1936  C   LYS A 258       9.117  36.554   9.561  1.00 37.16           C  
ATOM   1937  O   LYS A 258       9.900  37.319   8.997  1.00 37.24           O  
ATOM   1938  CB  LYS A 258       9.777  34.146   9.329  1.00 36.57           C  
ATOM   1939  CG  LYS A 258      10.748  33.083   9.806  1.00 36.68           C  
ATOM   1940  CD  LYS A 258      10.912  31.964   8.800  1.00 37.09           C  
ATOM   1941  CE  LYS A 258      11.926  30.945   9.295  1.00 37.36           C  
ATOM   1942  NZ  LYS A 258      12.059  29.789   8.364  1.00 37.87           N  
ATOM   1943  N   ALA A 259       7.797  36.740   9.571  1.00 37.90           N  
ATOM   1944  CA  ALA A 259       7.163  37.907   8.954  1.00 38.64           C  
ATOM   1945  C   ALA A 259       7.535  39.192   9.689  1.00 39.21           C  
ATOM   1946  O   ALA A 259       7.820  40.215   9.063  1.00 39.34           O  
ATOM   1947  CB  ALA A 259       5.648  37.735   8.912  1.00 38.58           C  
HETATM 1948  N   MSE A 260       7.528  39.128  11.019  1.00 39.89           N  
HETATM 1949  CA  MSE A 260       7.971  40.237  11.859  1.00 40.74           C  
HETATM 1950  C   MSE A 260       9.485  40.411  11.740  1.00 40.97           C  
HETATM 1951  O   MSE A 260      10.014  41.504  11.959  1.00 41.09           O  
HETATM 1952  CB  MSE A 260       7.571  39.998  13.319  1.00 40.65           C  
HETATM 1953  CG  MSE A 260       6.071  39.829  13.535  1.00 40.99           C  
HETATM 1954 SE   MSE A 260       5.617  39.100  15.289  0.80 41.69          SE  
HETATM 1955  CE  MSE A 260       5.579  40.762  16.308  1.00 41.61           C  
ATOM   1956  N   GLY A 261      10.167  39.323  11.379  1.00 41.36           N  
ATOM   1957  CA  GLY A 261      11.617  39.311  11.192  1.00 41.75           C  
ATOM   1958  C   GLY A 261      12.097  39.934   9.892  1.00 42.09           C  
ATOM   1959  O   GLY A 261      13.305  40.077   9.678  1.00 42.14           O  
ATOM   1960  N   SER A 262      11.155  40.298   9.025  1.00 42.30           N  
ATOM   1961  CA  SER A 262      11.466  40.971   7.767  1.00 42.55           C  
ATOM   1962  C   SER A 262      11.302  42.484   7.906  1.00 42.65           C  
ATOM   1963  O   SER A 262      12.152  43.256   7.461  1.00 42.79           O  
ATOM   1964  CB  SER A 262      10.577  40.441   6.639  1.00 42.59           C  
ATOM   1965  OG  SER A 262      10.797  39.058   6.423  1.00 42.70           O  
ATOM   1966  OXT SER A 262      10.322  42.974   8.471  1.00 42.71           O  
TER    1967      SER A 262                                                      
END
MOLECULE T0393.pdb
ATOM   2058  N   SER     4      30.978  38.926  41.915  1.00 56.97           N  
ATOM   2059  CA  SER     4      31.424  39.689  40.717  1.00 56.91           C  
ATOM   2060  C   SER     4      30.310  39.837  39.677  1.00 56.97           C  
ATOM   2061  O   SER     4      29.811  40.955  39.478  1.00 57.48           O  
ATOM   2062  CB  SER     4      32.707  39.071  40.105  1.00 57.44           C  
ATOM   2063  N   ILE     5      29.884  38.744  39.028  1.00 56.28           N  
ATOM   2064  CA  ILE     5      28.835  38.888  37.995  1.00 55.54           C  
ATOM   2065  C   ILE     5      27.466  39.292  38.571  1.00 55.08           C  
ATOM   2066  O   ILE     5      26.654  39.897  37.869  1.00 55.05           O  
ATOM   2067  CB  ILE     5      28.743  37.711  36.924  1.00 55.84           C  
ATOM   2068  CG1 ILE     5      28.177  38.262  35.599  1.00 55.66           C  
ATOM   2069  CG2 ILE     5      27.900  36.526  37.414  1.00 54.86           C  
ATOM   2070  CD1 ILE     5      28.434  37.428  34.360  1.00 55.28           C  
ATOM   2071  N   GLU     6      27.236  38.981  39.849  1.00 54.32           N  
ATOM   2072  CA  GLU     6      26.016  39.399  40.555  1.00 53.57           C  
ATOM   2073  C   GLU     6      25.992  40.913  40.789  1.00 52.65           C  
ATOM   2074  O   GLU     6      24.941  41.466  41.150  1.00 53.00           O  
ATOM   2075  CB  GLU     6      25.861  38.656  41.893  1.00 54.13           C  
ATOM   2076  CG  GLU     6      25.101  37.323  41.844  1.00 56.31           C  
ATOM   2077  CD  GLU     6      25.912  36.178  41.234  1.00 60.15           C  
ATOM   2078  OE1 GLU     6      26.448  36.356  40.122  1.00 62.07           O  
ATOM   2079  OE2 GLU     6      26.010  35.087  41.851  1.00 61.25           O  
ATOM   2080  N   ASP     7      27.137  41.576  40.600  1.00 50.91           N  
ATOM   2081  CA  ASP     7      27.204  43.041  40.696  1.00 49.84           C  
ATOM   2082  C   ASP     7      26.728  43.792  39.436  1.00 48.42           C  
ATOM   2083  O   ASP     7      26.710  45.007  39.436  1.00 48.90           O  
ATOM   2084  CB  ASP     7      28.607  43.512  41.087  1.00 50.15           C  
ATOM   2085  CG  ASP     7      29.094  42.920  42.432  1.00 51.03           C  
ATOM   2086  OD1 ASP     7      28.264  42.532  43.299  1.00 51.64           O  
ATOM   2087  OD2 ASP     7      30.330  42.854  42.610  1.00 51.66           O  
ATOM   2088  N   THR     8      26.334  43.069  38.387  1.00 46.38           N  
ATOM   2089  CA  THR     8      25.826  43.651  37.137  1.00 44.43           C  
ATOM   2090  C   THR     8      24.524  44.403  37.398  1.00 43.46           C  
ATOM   2091  O   THR     8      23.556  43.791  37.855  1.00 43.44           O  
ATOM   2092  CB  THR     8      25.525  42.525  36.133  1.00 44.49           C  
ATOM   2093  OG1 THR     8      26.698  41.750  35.937  1.00 43.78           O  
ATOM   2094  CG2 THR     8      25.033  43.051  34.786  1.00 44.69           C  
ATOM   2095  N   PRO     9      24.494  45.734  37.145  1.00 42.42           N  
ATOM   2096  CA  PRO     9      23.190  46.397  37.298  1.00 41.46           C  
ATOM   2097  C   PRO     9      22.307  46.118  36.095  1.00 40.41           C  
ATOM   2098  O   PRO     9      22.723  46.304  34.951  1.00 40.45           O  
ATOM   2099  CB  PRO     9      23.544  47.895  37.402  1.00 41.68           C  
ATOM   2100  CG  PRO     9      24.871  48.046  36.703  1.00 41.23           C  
ATOM   2101  CD  PRO     9      25.575  46.687  36.789  1.00 41.97           C  
ATOM   2102  N   ILE    10      21.097  45.674  36.373  1.00 39.50           N  
ATOM   2103  CA  ILE    10      20.165  45.243  35.335  1.00 39.43           C  
ATOM   2104  C   ILE    10      18.912  46.135  35.326  1.00 38.90           C  
ATOM   2105  O   ILE    10      18.370  46.438  36.384  1.00 38.18           O  
ATOM   2106  CB  ILE    10      19.750  43.753  35.566  1.00 39.22           C  
ATOM   2107  CG1 ILE    10      21.005  42.847  35.644  1.00 38.78           C  
ATOM   2108  CG2 ILE    10      18.742  43.302  34.510  1.00 38.03           C  
ATOM   2109  CD1 ILE    10      20.738  41.417  36.049  1.00 38.32           C  
ATOM   2110  N   VAL    11      18.464  46.532  34.130  1.00 38.78           N  
ATOM   2111  CA  VAL    11      17.141  47.196  33.939  1.00 38.74           C  
ATOM   2112  C   VAL    11      16.191  46.277  33.143  1.00 39.91           C  
ATOM   2113  O   VAL    11      16.605  45.615  32.168  1.00 39.30           O  
ATOM   2114  CB  VAL    11      17.311  48.565  33.251  1.00 38.62           C  
ATOM   2115  CG1 VAL    11      15.956  49.203  32.868  1.00 36.41           C  
ATOM   2116  CG2 VAL    11      18.129  49.523  34.145  1.00 35.90           C  
ATOM   2117  N   LEU    12      14.929  46.201  33.578  1.00 41.39           N  
ATOM   2118  CA  LEU    12      13.915  45.479  32.807  1.00 41.84           C  
ATOM   2119  C   LEU    12      13.024  46.459  32.119  1.00 40.76           C  
ATOM   2120  O   LEU    12      12.459  47.349  32.775  1.00 41.51           O  
ATOM   2121  CB  LEU    12      13.074  44.558  33.699  1.00 43.12           C  
ATOM   2122  CG  LEU    12      13.718  43.684  34.794  1.00 47.64           C  
ATOM   2123  CD1 LEU    12      12.672  42.663  35.113  1.00 53.63           C  
ATOM   2124  CD2 LEU    12      14.968  42.954  34.385  1.00 47.40           C  
ATOM   2125  N   ILE    13      12.900  46.310  30.797  1.00 39.74           N  
ATOM   2126  CA  ILE    13      12.005  47.122  29.989  1.00 38.21           C  
ATOM   2127  C   ILE    13      10.856  46.182  29.646  1.00 37.92           C  
ATOM   2128  O   ILE    13      10.960  45.342  28.722  1.00 37.20           O  
ATOM   2129  CB  ILE    13      12.683  47.713  28.696  1.00 38.69           C  
ATOM   2130  CG1 ILE    13      13.957  48.549  28.983  1.00 39.50           C  
ATOM   2131  CG2 ILE    13      11.708  48.531  27.906  1.00 37.96           C  
ATOM   2132  CD1 ILE    13      13.798  49.718  29.946  1.00 42.80           C  
ATOM   2133  N   GLY    14       9.777  46.291  30.410  1.00 36.44           N  
ATOM   2134  CA  GLY    14       8.684  45.332  30.306  1.00 36.99           C  
ATOM   2135  C   GLY    14       8.590  44.505  31.588  1.00 37.83           C  
ATOM   2136  O   GLY    14       9.613  44.065  32.133  1.00 37.90           O  
ATOM   2137  N   ALA    15       7.366  44.291  32.070  1.00 37.35           N  
ATOM   2138  CA  ALA    15       7.155  43.705  33.389  1.00 37.74           C  
ATOM   2139  C   ALA    15       6.084  42.603  33.353  1.00 38.09           C  
ATOM   2140  O   ALA    15       5.419  42.379  34.364  1.00 38.48           O  
ATOM   2141  CB  ALA    15       6.771  44.797  34.392  1.00 37.13           C  
ATOM   2142  N   GLY    16       5.935  41.921  32.206  1.00 37.89           N  
ATOM   2143  CA  GLY    16       4.889  40.904  32.012  1.00 37.41           C  
ATOM   2144  C   GLY    16       5.249  39.608  32.712  1.00 37.95           C  
ATOM   2145  O   GLY    16       6.088  39.619  33.633  1.00 37.84           O  
ATOM   2146  N   ASN    17       4.662  38.492  32.262  1.00 37.44           N  
ATOM   2147  CA  ASN    17       4.822  37.174  32.920  1.00 37.39           C  
ATOM   2148  C   ASN    17       6.247  36.663  32.962  1.00 37.29           C  
ATOM   2149  O   ASN    17       6.760  36.344  34.029  1.00 37.85           O  
ATOM   2150  CB  ASN    17       3.933  36.113  32.274  1.00 37.41           C  
ATOM   2151  CG  ASN    17       2.454  36.405  32.430  1.00 37.45           C  
ATOM   2152  OD1 ASN    17       2.045  37.198  33.268  1.00 38.41           O  
ATOM   2153  ND2 ASN    17       1.645  35.761  31.605  1.00 36.39           N  
ATOM   2154  N   LEU    18       6.886  36.606  31.799  1.00 37.69           N  
ATOM   2155  CA  LEU    18       8.279  36.157  31.654  1.00 37.72           C  
ATOM   2156  C   LEU    18       9.210  37.076  32.413  1.00 38.51           C  
ATOM   2157  O   LEU    18      10.061  36.618  33.171  1.00 39.19           O  
ATOM   2158  CB  LEU    18       8.673  36.062  30.154  1.00 37.40           C  
ATOM   2159  CG  LEU    18      10.114  35.661  29.741  1.00 37.12           C  
ATOM   2160  CD1 LEU    18      10.147  35.113  28.306  1.00 35.16           C  
ATOM   2161  CD2 LEU    18      11.132  36.791  29.904  1.00 33.87           C  
ATOM   2162  N   ALA    19       9.045  38.385  32.241  1.00 39.60           N  
ATOM   2163  CA  ALA    19       9.929  39.346  32.899  1.00 39.79           C  
ATOM   2164  C   ALA    19       9.816  39.256  34.438  1.00 40.34           C  
ATOM   2165  O   ALA    19      10.824  39.304  35.139  1.00 41.39           O  
ATOM   2166  CB  ALA    19       9.646  40.758  32.395  1.00 39.38           C  
ATOM   2167  N   THR    20       8.600  39.095  34.950  1.00 40.29           N  
ATOM   2168  CA  THR    20       8.357  38.945  36.385  1.00 40.47           C  
ATOM   2169  C   THR    20       9.126  37.751  36.945  1.00 40.78           C  
ATOM   2170  O   THR    20       9.887  37.884  37.905  1.00 42.25           O  
ATOM   2171  CB  THR    20       6.831  38.822  36.654  1.00 40.78           C  
ATOM   2172  OG1 THR    20       6.194  40.069  36.326  1.00 41.64           O  
ATOM   2173  CG2 THR    20       6.518  38.451  38.104  1.00 39.76           C  
ATOM   2174  N   ASN    21       8.973  36.599  36.309  1.00 40.05           N  
ATOM   2175  CA  ASN    21       9.664  35.396  36.735  1.00 40.58           C  
ATOM   2176  C   ASN    21      11.187  35.486  36.572  1.00 40.27           C  
ATOM   2177  O   ASN    21      11.926  35.105  37.464  1.00 40.73           O  
ATOM   2178  CB  ASN    21       9.097  34.177  35.988  1.00 39.85           C  
ATOM   2179  CG  ASN    21       7.739  33.734  36.539  1.00 41.27           C  
ATOM   2180  OD1 ASN    21       7.667  33.107  37.596  1.00 42.15           O  
ATOM   2181  ND2 ASN    21       6.658  34.062  35.824  1.00 40.18           N  
ATOM   2182  N   LEU    22      11.642  36.003  35.436  1.00 40.33           N  
ATOM   2183  CA  LEU    22      13.065  36.173  35.191  1.00 40.42           C  
ATOM   2184  C   LEU    22      13.645  37.178  36.169  1.00 40.95           C  
ATOM   2185  O   LEU    22      14.739  36.999  36.645  1.00 42.11           O  
ATOM   2186  CB  LEU    22      13.329  36.619  33.751  1.00 39.72           C  
ATOM   2187  CG  LEU    22      14.776  36.881  33.311  1.00 39.30           C  
ATOM   2188  CD1 LEU    22      15.707  35.661  33.538  1.00 36.76           C  
ATOM   2189  CD2 LEU    22      14.825  37.293  31.851  1.00 39.85           C  
ATOM   2190  N   ALA    23      12.919  38.246  36.468  1.00 41.90           N  
ATOM   2191  CA  ALA    23      13.419  39.216  37.468  1.00 42.73           C  
ATOM   2192  C   ALA    23      13.548  38.613  38.853  1.00 42.56           C  
ATOM   2193  O   ALA    23      14.542  38.843  39.518  1.00 44.61           O  
ATOM   2194  CB  ALA    23      12.561  40.502  37.499  1.00 41.95           C  
ATOM   2195  N   LYS    24      12.562  37.833  39.281  1.00 42.60           N  
ATOM   2196  CA  LYS    24      12.606  37.199  40.611  1.00 42.90           C  
ATOM   2197  C   LYS    24      13.779  36.210  40.759  1.00 42.79           C  
ATOM   2198  O   LYS    24      14.458  36.204  41.777  1.00 42.71           O  
ATOM   2199  CB  LYS    24      11.271  36.519  40.937  1.00 42.58           C  
ATOM   2200  CG  LYS    24      10.143  37.518  41.308  1.00 43.98           C  
ATOM   2201  CD  LYS    24       8.729  36.910  41.076  1.00 44.24           C  
ATOM   2202  CE  LYS    24       8.287  35.974  42.190  1.00 45.81           C  
ATOM   2203  NZ  LYS    24       6.834  35.598  42.107  1.00 45.29           N  
ATOM   2204  N   ALA    25      14.029  35.414  39.716  1.00 41.97           N  
ATOM   2205  CA  ALA    25      15.119  34.460  39.710  1.00 41.81           C  
ATOM   2206  C   ALA    25      16.482  35.171  39.787  1.00 42.01           C  
ATOM   2207  O   ALA    25      17.358  34.739  40.538  1.00 41.79           O  
ATOM   2208  CB  ALA    25      15.028  33.564  38.494  1.00 41.48           C  
ATOM   2209  N   LEU    26      16.645  36.269  39.040  1.00 41.82           N  
ATOM   2210  CA  LEU    26      17.871  37.091  39.133  1.00 40.95           C  
ATOM   2211  C   LEU    26      18.076  37.688  40.521  1.00 41.90           C  
ATOM   2212  O   LEU    26      19.155  37.574  41.076  1.00 42.21           O  
ATOM   2213  CB  LEU    26      17.858  38.195  38.089  1.00 40.38           C  
ATOM   2214  CG  LEU    26      17.952  37.723  36.628  1.00 40.93           C  
ATOM   2215  CD1 LEU    26      17.419  38.817  35.675  1.00 36.17           C  
ATOM   2216  CD2 LEU    26      19.391  37.344  36.321  1.00 39.06           C  
ATOM   2217  N   TYR    27      17.032  38.333  41.053  1.00 42.47           N  
ATOM   2218  CA  TYR    27      16.983  38.884  42.425  1.00 42.71           C  
ATOM   2219  C   TYR    27      17.314  37.861  43.533  1.00 43.36           C  
ATOM   2220  O   TYR    27      18.064  38.157  44.476  1.00 43.37           O  
ATOM   2221  CB  TYR    27      15.591  39.509  42.642  1.00 41.59           C  
ATOM   2222  CG  TYR    27      15.252  39.915  44.038  1.00 41.40           C  
ATOM   2223  CD1 TYR    27      15.798  41.070  44.600  1.00 39.12           C  
ATOM   2224  CD2 TYR    27      14.357  39.164  44.800  1.00 41.40           C  
ATOM   2225  CE1 TYR    27      15.478  41.457  45.872  1.00 42.09           C  
ATOM   2226  CE2 TYR    27      14.026  39.542  46.079  1.00 40.85           C  
ATOM   2227  CZ  TYR    27      14.586  40.689  46.616  1.00 42.11           C  
ATOM   2228  OH  TYR    27      14.270  41.081  47.896  1.00 42.35           O  
ATOM   2229  N   ARG    28      16.751  36.660  43.422  1.00 44.56           N  
ATOM   2230  CA  ARG    28      17.025  35.588  44.380  1.00 45.33           C  
ATOM   2231  C   ARG    28      18.465  35.092  44.312  1.00 45.34           C  
ATOM   2232  O   ARG    28      19.022  34.642  45.325  1.00 45.62           O  
ATOM   2233  CB  ARG    28      16.051  34.423  44.194  1.00 45.71           C  
ATOM   2234  CG  ARG    28      14.666  34.736  44.721  1.00 48.15           C  
ATOM   2235  CD  ARG    28      13.618  33.785  44.183  1.00 51.53           C  
ATOM   2236  NE  ARG    28      12.308  34.144  44.733  1.00 55.11           N  
ATOM   2237  CZ  ARG    28      11.136  33.902  44.146  1.00 57.09           C  
ATOM   2238  NH1 ARG    28      11.078  33.302  42.957  1.00 57.21           N  
ATOM   2239  NH2 ARG    28      10.012  34.278  44.750  1.00 57.37           N  
ATOM   2240  N   LYS    29      19.063  35.168  43.129  1.00 45.11           N  
ATOM   2241  CA  LYS    29      20.460  34.775  42.958  1.00 45.22           C  
ATOM   2242  C   LYS    29      21.434  35.882  43.328  1.00 45.01           C  
ATOM   2243  O   LYS    29      22.663  35.687  43.300  1.00 45.23           O  
ATOM   2244  CB  LYS    29      20.725  34.262  41.545  1.00 45.06           C  
ATOM   2245  CG  LYS    29      20.217  32.850  41.331  1.00 47.42           C  
ATOM   2246  CD  LYS    29      20.889  31.817  42.266  1.00 49.31           C  
ATOM   2247  CE  LYS    29      20.134  30.492  42.235  1.00 51.00           C  
ATOM   2248  NZ  LYS    29      20.871  29.398  42.947  1.00 51.98           N  
ATOM   2249  N   GLY    30      20.889  37.037  43.695  1.00 44.95           N  
ATOM   2250  CA  GLY    30      21.700  38.114  44.238  1.00 44.67           C  
ATOM   2251  C   GLY    30      22.048  39.191  43.240  1.00 44.86           C  
ATOM   2252  O   GLY    30      22.862  40.048  43.549  1.00 44.39           O  
ATOM   2253  N   PHE    31      21.434  39.157  42.050  1.00 44.81           N  
ATOM   2254  CA  PHE    31      21.636  40.219  41.050  1.00 44.70           C  
ATOM   2255  C   PHE    31      20.919  41.495  41.458  1.00 45.04           C  
ATOM   2256  O   PHE    31      19.962  41.461  42.233  1.00 45.31           O  
ATOM   2257  CB  PHE    31      21.161  39.808  39.651  1.00 44.38           C  
ATOM   2258  CG  PHE    31      22.093  38.870  38.943  1.00 44.25           C  
ATOM   2259  CD1 PHE    31      22.003  37.499  39.141  1.00 41.84           C  
ATOM   2260  CD2 PHE    31      23.066  39.368  38.071  1.00 44.24           C  
ATOM   2261  CE1 PHE    31      22.882  36.631  38.499  1.00 43.24           C  
ATOM   2262  CE2 PHE    31      23.947  38.516  37.422  1.00 43.10           C  
ATOM   2263  CZ  PHE    31      23.857  37.142  37.635  1.00 43.41           C  
ATOM   2264  N   ARG    32      21.398  42.611  40.920  1.00 45.53           N  
ATOM   2265  CA  ARG    32      20.887  43.931  41.221  1.00 46.65           C  
ATOM   2266  C   ARG    32      19.989  44.441  40.087  1.00 45.63           C  
ATOM   2267  O   ARG    32      20.457  44.808  39.015  1.00 45.57           O  
ATOM   2268  CB  ARG    32      22.051  44.889  41.470  1.00 47.40           C  
ATOM   2269  CG  ARG    32      21.637  46.293  41.875  1.00 52.25           C  
ATOM   2270  CD  ARG    32      22.836  47.039  42.495  1.00 59.14           C  
ATOM   2271  NE  ARG    32      22.886  48.458  42.116  1.00 64.21           N  
ATOM   2272  CZ  ARG    32      23.879  49.034  41.427  1.00 66.65           C  
ATOM   2273  NH1 ARG    32      24.939  48.333  41.030  1.00 68.11           N  
ATOM   2274  NH2 ARG    32      23.818  50.329  41.137  1.00 67.22           N  
ATOM   2275  N   ILE    33      18.691  44.439  40.344  1.00 44.91           N  
ATOM   2276  CA  ILE    33      17.730  45.000  39.412  1.00 44.78           C  
ATOM   2277  C   ILE    33      17.501  46.435  39.855  1.00 44.51           C  
ATOM   2278  O   ILE    33      16.899  46.668  40.903  1.00 44.41           O  
ATOM   2279  CB  ILE    33      16.421  44.148  39.379  1.00 44.51           C  
ATOM   2280  CG1 ILE    33      16.747  42.759  38.809  1.00 45.72           C  
ATOM   2281  CG2 ILE    33      15.383  44.804  38.510  1.00 42.88           C  
ATOM   2282  CD1 ILE    33      16.286  41.668  39.664  1.00 48.52           C  
ATOM   2283  N   VAL    34      17.988  47.397  39.073  1.00 44.11           N  
ATOM   2284  CA  VAL    34      17.955  48.777  39.542  1.00 44.62           C  
ATOM   2285  C   VAL    34      16.586  49.416  39.357  1.00 45.04           C  
ATOM   2286  O   VAL    34      16.148  50.196  40.221  1.00 45.06           O  
ATOM   2287  CB  VAL    34      19.117  49.654  38.981  1.00 44.84           C  
ATOM   2288  CG1 VAL    34      20.464  48.994  39.292  1.00 43.57           C  
ATOM   2289  CG2 VAL    34      18.977  49.866  37.503  1.00 45.80           C  
ATOM   2290  N   GLN    35      15.911  49.081  38.249  1.00 44.42           N  
ATOM   2291  CA  GLN    35      14.555  49.545  38.021  1.00 44.04           C  
ATOM   2292  C   GLN    35      13.840  48.777  36.939  1.00 44.04           C  
ATOM   2293  O   GLN    35      14.439  48.067  36.127  1.00 44.08           O  
ATOM   2294  CB  GLN    35      14.482  51.047  37.712  1.00 44.85           C  
ATOM   2295  CG  GLN    35      14.924  51.382  36.346  1.00 44.92           C  
ATOM   2296  CD  GLN    35      14.385  52.674  35.802  1.00 43.30           C  
ATOM   2297  OE1 GLN    35      14.489  52.890  34.617  1.00 46.66           O  
ATOM   2298  NE2 GLN    35      13.842  53.546  36.641  1.00 43.75           N  
ATOM   2299  N   VAL    36      12.528  48.940  36.951  1.00 43.24           N  
ATOM   2300  CA  VAL    36      11.629  48.246  36.065  1.00 41.76           C  
ATOM   2301  C   VAL    36      10.861  49.328  35.331  1.00 41.87           C  
ATOM   2302  O   VAL    36      10.379  50.276  35.950  1.00 40.01           O  
ATOM   2303  CB  VAL    36      10.629  47.388  36.916  1.00 41.97           C  
ATOM   2304  CG1 VAL    36       9.463  46.827  36.069  1.00 41.36           C  
ATOM   2305  CG2 VAL    36      11.372  46.270  37.664  1.00 40.56           C  
ATOM   2306  N   TYR    37      10.736  49.166  34.012  1.00 42.31           N  
ATOM   2307  CA  TYR    37       9.849  49.979  33.204  1.00 41.79           C  
ATOM   2308  C   TYR    37       8.648  49.134  32.761  1.00 42.82           C  
ATOM   2309  O   TYR    37       8.797  47.960  32.389  1.00 43.02           O  
ATOM   2310  CB  TYR    37      10.572  50.537  31.967  1.00 41.11           C  
ATOM   2311  CG  TYR    37       9.588  50.970  30.919  1.00 40.40           C  
ATOM   2312  CD1 TYR    37       9.069  52.271  30.920  1.00 37.28           C  
ATOM   2313  CD2 TYR    37       9.111  50.056  29.966  1.00 39.55           C  
ATOM   2314  CE1 TYR    37       8.141  52.663  29.985  1.00 38.97           C  
ATOM   2315  CE2 TYR    37       8.158  50.432  29.032  1.00 38.74           C  
ATOM   2316  CZ  TYR    37       7.680  51.737  29.053  1.00 39.48           C  
ATOM   2317  OH  TYR    37       6.757  52.125  28.122  1.00 40.76           O  
ATOM   2318  N   SER    38       7.455  49.728  32.785  1.00 43.61           N  
ATOM   2319  CA  SER    38       6.288  49.105  32.164  1.00 44.35           C  
ATOM   2320  C   SER    38       5.405  50.197  31.652  1.00 44.97           C  
ATOM   2321  O   SER    38       5.481  51.319  32.147  1.00 44.35           O  
ATOM   2322  CB  SER    38       5.522  48.263  33.183  1.00 44.52           C  
ATOM   2323  OG  SER    38       4.433  47.593  32.585  1.00 46.66           O  
ATOM   2324  N   ARG    39       4.564  49.873  30.669  1.00 46.07           N  
ATOM   2325  CA  ARG    39       3.621  50.857  30.154  0.50 46.90           C  
ATOM   2327  C   ARG    39       2.554  51.242  31.196  1.00 46.84           C  
ATOM   2328  O   ARG    39       2.108  52.392  31.226  1.00 46.82           O  
ATOM   2329  CB  ARG    39       3.042  50.408  28.794  0.50 46.89           C  
ATOM   2331  CG  ARG    39       3.997  50.754  27.642  0.50 47.71           C  
ATOM   2333  CD  ARG    39       3.945  49.830  26.399  0.50 48.18           C  
ATOM   2335  NE  ARG    39       4.247  48.424  26.677  0.50 49.32           N  
ATOM   2337  CZ  ARG    39       3.368  47.429  26.547  0.50 50.56           C  
ATOM   2339  NH1 ARG    39       2.124  47.664  26.126  0.50 50.55           N  
ATOM   2341  NH2 ARG    39       3.736  46.185  26.831  0.50 51.88           N  
ATOM   2343  N   THR    40       2.183  50.311  32.075  1.00 46.94           N  
ATOM   2344  CA  THR    40       1.184  50.613  33.113  1.00 47.67           C  
ATOM   2345  C   THR    40       1.770  50.630  34.531  1.00 46.64           C  
ATOM   2346  O   THR    40       2.534  49.753  34.904  1.00 46.56           O  
ATOM   2347  CB  THR    40      -0.039  49.659  33.055  1.00 48.14           C  
ATOM   2348  OG1 THR    40       0.406  48.307  33.204  1.00 50.40           O  
ATOM   2349  CG2 THR    40      -0.777  49.791  31.702  1.00 49.92           C  
ATOM   2350  N   GLU    41       1.384  51.630  35.310  1.00 45.66           N  
ATOM   2351  CA  GLU    41       1.903  51.808  36.653  1.00 45.74           C  
ATOM   2352  C   GLU    41       1.758  50.578  37.556  1.00 44.53           C  
ATOM   2353  O   GLU    41       2.662  50.235  38.292  1.00 44.26           O  
ATOM   2354  CB  GLU    41       1.265  53.046  37.307  1.00 45.83           C  
ATOM   2355  CG  GLU    41       1.770  53.279  38.713  1.00 48.23           C  
ATOM   2356  CD  GLU    41       1.855  54.737  39.082  1.00 51.14           C  
ATOM   2357  OE1 GLU    41       0.830  55.442  38.945  1.00 52.02           O  
ATOM   2358  OE2 GLU    41       2.943  55.168  39.536  1.00 51.13           O  
ATOM   2359  N   GLU    42       0.614  49.924  37.481  1.00 44.41           N  
ATOM   2360  CA  GLU    42       0.298  48.742  38.287  0.50 44.33           C  
ATOM   2362  C   GLU    42       1.322  47.622  38.075  1.00 44.22           C  
ATOM   2363  O   GLU    42       1.788  46.988  39.037  1.00 44.53           O  
ATOM   2364  CB  GLU    42      -1.120  48.272  37.924  0.50 44.42           C  
ATOM   2366  CG  GLU    42      -1.656  47.041  38.649  0.50 44.78           C  
ATOM   2368  CD  GLU    42      -3.046  46.647  38.151  0.50 44.53           C  
ATOM   2370  OE1 GLU    42      -3.146  45.927  37.131  0.50 44.82           O  
ATOM   2372  OE2 GLU    42      -4.039  47.060  38.777  0.50 44.35           O  
ATOM   2374  N   SER    43       1.662  47.369  36.805  1.00 43.38           N  
ATOM   2375  CA  SER    43       2.610  46.294  36.437  1.00 43.00           C  
ATOM   2376  C   SER    43       4.056  46.638  36.781  1.00 42.56           C  
ATOM   2377  O   SER    43       4.803  45.788  37.279  1.00 41.73           O  
ATOM   2378  CB  SER    43       2.509  45.961  34.951  1.00 43.28           C  
ATOM   2379  OG  SER    43       1.194  45.505  34.661  1.00 44.78           O  
ATOM   2380  N   ALA    44       4.441  47.886  36.518  1.00 41.77           N  
ATOM   2381  CA  ALA    44       5.757  48.376  36.874  1.00 41.46           C  
ATOM   2382  C   ALA    44       5.963  48.283  38.407  1.00 40.83           C  
ATOM   2383  O   ALA    44       6.949  47.726  38.865  1.00 41.43           O  
ATOM   2384  CB  ALA    44       5.929  49.805  36.368  1.00 41.39           C  
ATOM   2385  N   ARG    45       4.988  48.757  39.177  1.00 39.99           N  
ATOM   2386  CA  ARG    45       5.080  48.776  40.640  0.50 39.65           C  
ATOM   2388  C   ARG    45       5.074  47.380  41.251  1.00 39.71           C  
ATOM   2389  O   ARG    45       5.908  47.065  42.088  1.00 39.67           O  
ATOM   2390  CB  ARG    45       3.943  49.610  41.245  0.50 39.60           C  
ATOM   2392  CG  ARG    45       3.998  49.724  42.785  0.50 39.22           C  
ATOM   2394  CD  ARG    45       2.692  50.229  43.408  0.50 39.38           C  
ATOM   2396  NE  ARG    45       1.502  49.712  42.737  0.50 38.08           N  
ATOM   2398  CZ  ARG    45       0.577  50.471  42.152  0.50 39.36           C  
ATOM   2400  NH1 ARG    45       0.680  51.799  42.164  0.50 39.25           N  
ATOM   2402  NH2 ARG    45      -0.466  49.903  41.560  0.50 39.82           N  
ATOM   2404  N   GLU    46       4.125  46.549  40.841  1.00 40.38           N  
ATOM   2405  CA  GLU    46       4.026  45.176  41.337  1.00 41.80           C  
ATOM   2406  C   GLU    46       5.358  44.489  41.216  1.00 40.76           C  
ATOM   2407  O   GLU    46       5.862  43.922  42.186  1.00 40.65           O  
ATOM   2408  CB  GLU    46       2.950  44.378  40.583  1.00 41.34           C  
ATOM   2409  CG  GLU    46       1.561  44.600  41.122  1.00 44.04           C  
ATOM   2410  CD  GLU    46       0.477  43.853  40.329  1.00 45.88           C  
ATOM   2411  OE1 GLU    46      -0.720  44.060  40.681  1.00 50.21           O  
ATOM   2412  OE2 GLU    46       0.803  43.066  39.386  1.00 48.16           O  
ATOM   2413  N   LEU    47       5.949  44.557  40.034  1.00 40.17           N  
ATOM   2414  CA  LEU    47       7.240  43.893  39.856  1.00 40.86           C  
ATOM   2415  C   LEU    47       8.381  44.548  40.655  1.00 40.52           C  
ATOM   2416  O   LEU    47       9.207  43.857  41.229  1.00 40.83           O  
ATOM   2417  CB  LEU    47       7.619  43.730  38.367  1.00 39.86           C  
ATOM   2418  CG  LEU    47       8.967  43.009  38.146  1.00 41.61           C  
ATOM   2419  CD1 LEU    47       9.068  41.668  38.953  1.00 39.36           C  
ATOM   2420  CD2 LEU    47       9.193  42.779  36.659  1.00 39.84           C  
ATOM   2421  N   ALA    48       8.436  45.874  40.675  1.00 41.55           N  
ATOM   2422  CA  ALA    48       9.526  46.576  41.376  1.00 41.63           C  
ATOM   2423  C   ALA    48       9.567  46.284  42.863  1.00 41.82           C  
ATOM   2424  O   ALA    48      10.641  46.193  43.470  1.00 41.50           O  
ATOM   2425  CB  ALA    48       9.432  48.073  41.133  1.00 41.65           C  
ATOM   2426  N   GLN    49       8.398  46.144  43.467  1.00 42.34           N  
ATOM   2427  CA  GLN    49       8.321  45.822  44.894  1.00 42.57           C  
ATOM   2428  C   GLN    49       8.850  44.442  45.201  1.00 42.17           C  
ATOM   2429  O   GLN    49       9.346  44.201  46.307  1.00 41.96           O  
ATOM   2430  CB  GLN    49       6.889  45.805  45.345  1.00 43.09           C  
ATOM   2431  CG  GLN    49       6.296  47.120  45.579  1.00 45.31           C  
ATOM   2432  CD  GLN    49       4.871  46.951  46.029  1.00 48.31           C  
ATOM   2433  OE1 GLN    49       3.964  47.578  45.483  1.00 48.15           O  
ATOM   2434  NE2 GLN    49       4.658  46.055  47.011  1.00 48.87           N  
ATOM   2435  N   LYS    50       8.693  43.518  44.248  1.00 41.47           N  
ATOM   2436  CA  LYS    50       9.121  42.145  44.462  1.00 40.66           C  
ATOM   2437  C   LYS    50      10.648  42.024  44.467  1.00 40.32           C  
ATOM   2438  O   LYS    50      11.201  41.132  45.105  1.00 40.14           O  
ATOM   2439  CB  LYS    50       8.505  41.215  43.411  1.00 41.29           C  
ATOM   2440  CG  LYS    50       6.994  40.996  43.592  1.00 41.33           C  
ATOM   2441  CD  LYS    50       6.358  40.456  42.311  1.00 43.77           C  
ATOM   2442  CE  LYS    50       4.829  40.334  42.416  1.00 43.86           C  
ATOM   2443  NZ  LYS    50       4.293  39.809  41.103  1.00 47.01           N  
ATOM   2444  N   VAL    51      11.325  42.929  43.770  1.00 39.58           N  
ATOM   2445  CA  VAL    51      12.749  42.772  43.506  1.00 39.53           C  
ATOM   2446  C   VAL    51      13.494  43.995  43.982  1.00 39.79           C  
ATOM   2447  O   VAL    51      14.636  44.262  43.543  1.00 39.53           O  
ATOM   2448  CB  VAL    51      13.049  42.532  42.002  1.00 39.28           C  
ATOM   2449  CG1 VAL    51      12.414  41.204  41.523  1.00 40.82           C  
ATOM   2450  CG2 VAL    51      12.562  43.709  41.153  1.00 39.58           C  
ATOM   2451  N   GLU    52      12.824  44.725  44.879  1.00 39.72           N  
ATOM   2452  CA  GLU    52      13.341  45.930  45.525  1.00 39.99           C  
ATOM   2453  C   GLU    52      13.955  46.929  44.567  1.00 40.08           C  
ATOM   2454  O   GLU    52      15.066  47.381  44.801  1.00 40.83           O  
ATOM   2455  CB  GLU    52      14.343  45.556  46.646  1.00 39.91           C  
ATOM   2456  CG  GLU    52      13.672  44.781  47.770  1.00 38.37           C  
ATOM   2457  CD  GLU    52      14.632  44.322  48.826  1.00 40.45           C  
ATOM   2458  OE1 GLU    52      15.287  43.263  48.638  1.00 39.98           O  
ATOM   2459  OE2 GLU    52      14.707  45.006  49.869  1.00 41.19           O  
ATOM   2460  N   ALA    53      13.213  47.289  43.521  1.00 40.85           N  
ATOM   2461  CA  ALA    53      13.700  48.152  42.424  1.00 41.24           C  
ATOM   2462  C   ALA    53      12.913  49.431  42.343  1.00 41.40           C  
ATOM   2463  O   ALA    53      11.781  49.474  42.816  1.00 42.11           O  
ATOM   2464  CB  ALA    53      13.548  47.414  41.076  1.00 40.75           C  
ATOM   2465  N   GLU    54      13.488  50.448  41.697  1.00 41.77           N  
ATOM   2466  CA  GLU    54      12.750  51.656  41.284  1.00 42.88           C  
ATOM   2467  C   GLU    54      11.877  51.285  40.103  1.00 42.14           C  
ATOM   2468  O   GLU    54      12.082  50.244  39.500  1.00 42.22           O  
ATOM   2469  CB  GLU    54      13.709  52.767  40.827  1.00 42.85           C  
ATOM   2470  CG  GLU    54      14.674  53.275  41.884  1.00 44.22           C  
ATOM   2471  CD  GLU    54      15.376  54.566  41.461  1.00 46.89           C  
ATOM   2472  OE1 GLU    54      15.563  54.800  40.234  1.00 52.45           O  
ATOM   2473  OE2 GLU    54      15.735  55.362  42.358  1.00 51.81           O  
ATOM   2474  N   TYR    55      10.882  52.107  39.769  1.00 41.52           N  
ATOM   2475  CA  TYR    55      10.156  51.870  38.527  1.00 41.03           C  
ATOM   2476  C   TYR    55       9.796  53.146  37.813  1.00 41.35           C  
ATOM   2477  O   TYR    55       9.732  54.222  38.409  1.00 40.99           O  
ATOM   2478  CB  TYR    55       8.900  50.998  38.734  1.00 40.18           C  
ATOM   2479  CG  TYR    55       7.720  51.716  39.345  1.00 39.87           C  
ATOM   2480  CD1 TYR    55       6.798  52.405  38.544  1.00 39.09           C  
ATOM   2481  CD2 TYR    55       7.515  51.693  40.710  1.00 38.43           C  
ATOM   2482  CE1 TYR    55       5.719  53.043  39.089  1.00 38.20           C  
ATOM   2483  CE2 TYR    55       6.427  52.351  41.286  1.00 39.89           C  
ATOM   2484  CZ  TYR    55       5.536  53.020  40.473  1.00 40.15           C  
ATOM   2485  OH  TYR    55       4.457  53.653  41.041  1.00 38.56           O  
ATOM   2486  N   THR    56       9.543  53.021  36.518  1.00 41.67           N  
ATOM   2487  CA  THR    56       9.008  54.151  35.770  1.00 41.67           C  
ATOM   2488  C   THR    56       8.014  53.623  34.724  1.00 41.19           C  
ATOM   2489  O   THR    56       8.064  52.438  34.360  1.00 39.63           O  
ATOM   2490  CB  THR    56      10.144  54.992  35.112  1.00 41.22           C  
ATOM   2491  OG1 THR    56       9.583  56.172  34.526  1.00 41.50           O  
ATOM   2492  CG2 THR    56      10.835  54.176  34.009  1.00 41.46           C  
ATOM   2493  N   THR    57       7.117  54.494  34.265  1.00 40.61           N  
ATOM   2494  CA  THR    57       6.278  54.189  33.097  1.00 41.88           C  
ATOM   2495  C   THR    57       6.638  55.123  31.945  1.00 42.49           C  
ATOM   2496  O   THR    57       5.906  55.222  30.961  1.00 41.73           O  
ATOM   2497  CB  THR    57       4.770  54.363  33.385  1.00 41.29           C  
ATOM   2498  OG1 THR    57       4.534  55.710  33.789  1.00 42.67           O  
ATOM   2499  CG2 THR    57       4.304  53.438  34.476  1.00 41.02           C  
ATOM   2500  N   ASP    58       7.768  55.814  32.092  1.00 43.36           N  
ATOM   2501  CA  ASP    58       8.221  56.782  31.109  1.00 44.52           C  
ATOM   2502  C   ASP    58       9.627  56.416  30.738  1.00 44.82           C  
ATOM   2503  O   ASP    58      10.515  56.448  31.598  1.00 45.29           O  
ATOM   2504  CB  ASP    58       8.183  58.192  31.714  1.00 45.25           C  
ATOM   2505  CG  ASP    58       8.615  59.290  30.737  1.00 46.33           C  
ATOM   2506  OD1 ASP    58       9.116  58.997  29.637  1.00 49.97           O  
ATOM   2507  OD2 ASP    58       8.455  60.475  31.082  1.00 49.75           O  
ATOM   2508  N   LEU    59       9.836  56.077  29.465  1.00 44.87           N  
ATOM   2509  CA  LEU    59      11.171  55.694  28.972  1.00 45.45           C  
ATOM   2510  C   LEU    59      12.218  56.791  29.158  1.00 46.08           C  
ATOM   2511  O   LEU    59      13.409  56.511  29.273  1.00 47.27           O  
ATOM   2512  CB  LEU    59      11.113  55.292  27.500  1.00 45.38           C  
ATOM   2513  CG  LEU    59      10.318  54.009  27.246  1.00 45.87           C  
ATOM   2514  CD1 LEU    59       9.984  53.819  25.779  1.00 44.70           C  
ATOM   2515  CD2 LEU    59      11.079  52.805  27.810  1.00 42.06           C  
ATOM   2516  N   ALA    60      11.777  58.041  29.196  1.00 45.38           N  
ATOM   2517  CA  ALA    60      12.692  59.154  29.391  1.00 45.27           C  
ATOM   2518  C   ALA    60      13.285  59.137  30.802  1.00 44.80           C  
ATOM   2519  O   ALA    60      14.332  59.724  31.047  1.00 44.86           O  
ATOM   2520  CB  ALA    60      11.978  60.471  29.101  1.00 44.33           C  
ATOM   2521  N   GLU    61      12.595  58.467  31.724  0.50 44.54           N  
ATOM   2523  CA  GLU    61      13.056  58.336  33.110  0.50 43.90           C  
ATOM   2525  C   GLU    61      13.898  57.074  33.345  0.50 43.82           C  
ATOM   2527  O   GLU    61      14.350  56.828  34.467  0.50 43.94           O  
ATOM   2529  CB  GLU    61      11.864  58.324  34.071  0.50 44.12           C  
ATOM   2531  CG  GLU    61      11.365  59.682  34.533  0.50 42.95           C  
ATOM   2533  CD  GLU    61      10.134  59.578  35.440  0.50 43.14           C  
ATOM   2535  OE1 GLU    61       9.761  58.450  35.836  0.50 37.66           O  
ATOM   2537  OE2 GLU    61       9.537  60.641  35.760  0.50 43.76           O  
ATOM   2539  N   VAL    62      14.108  56.286  32.293  1.00 43.53           N  
ATOM   2540  CA  VAL    62      14.820  54.995  32.405  1.00 43.35           C  
ATOM   2541  C   VAL    62      16.294  55.194  32.763  1.00 42.92           C  
ATOM   2542  O   VAL    62      16.980  55.999  32.127  1.00 43.00           O  
ATOM   2543  CB  VAL    62      14.701  54.145  31.121  1.00 43.14           C  
ATOM   2544  CG1 VAL    62      15.801  53.062  31.041  1.00 42.64           C  
ATOM   2545  CG2 VAL    62      13.323  53.462  31.062  1.00 44.65           C  
ATOM   2546  N   ASN    63      16.750  54.462  33.783  1.00 42.24           N  
ATOM   2547  CA  ASN    63      18.116  54.540  34.287  1.00 41.65           C  
ATOM   2548  C   ASN    63      19.099  54.198  33.174  1.00 41.35           C  
ATOM   2549  O   ASN    63      19.066  53.095  32.637  1.00 41.36           O  
ATOM   2550  CB  ASN    63      18.274  53.619  35.495  1.00 41.83           C  
ATOM   2551  CG  ASN    63      19.678  53.618  36.064  1.00 42.59           C  
ATOM   2552  OD1 ASN    63      20.663  53.485  35.334  1.00 41.88           O  
ATOM   2553  ND2 ASN    63      19.777  53.750  37.388  1.00 42.91           N  
ATOM   2554  N   PRO    64      19.940  55.178  32.782  1.00 40.84           N  
ATOM   2555  CA  PRO    64      20.879  55.012  31.667  1.00 39.37           C  
ATOM   2556  C   PRO    64      22.246  54.442  32.062  1.00 38.59           C  
ATOM   2557  O   PRO    64      23.160  54.420  31.215  1.00 38.34           O  
ATOM   2558  CB  PRO    64      21.055  56.445  31.170  1.00 39.22           C  
ATOM   2559  CG  PRO    64      20.978  57.252  32.421  1.00 40.61           C  
ATOM   2560  CD  PRO    64      19.991  56.545  33.340  1.00 39.88           C  
ATOM   2561  N   TYR    65      22.390  53.982  33.299  1.00 37.02           N  
ATOM   2562  CA  TYR    65      23.725  53.658  33.833  1.00 37.57           C  
ATOM   2563  C   TYR    65      23.988  52.153  34.020  1.00 38.41           C  
ATOM   2564  O   TYR    65      25.075  51.765  34.443  1.00 38.02           O  
ATOM   2565  CB  TYR    65      24.030  54.451  35.126  1.00 36.44           C  
ATOM   2566  CG  TYR    65      23.772  55.931  34.990  1.00 35.17           C  
ATOM   2567  CD1 TYR    65      24.535  56.731  34.118  1.00 34.22           C  
ATOM   2568  CD2 TYR    65      22.760  56.537  35.715  1.00 33.88           C  
ATOM   2569  CE1 TYR    65      24.278  58.097  33.989  1.00 34.38           C  
ATOM   2570  CE2 TYR    65      22.500  57.883  35.592  1.00 35.24           C  
ATOM   2571  CZ  TYR    65      23.256  58.664  34.734  1.00 35.41           C  
ATOM   2572  OH  TYR    65      22.958  60.020  34.640  1.00 35.60           O  
ATOM   2573  N   ALA    66      23.003  51.330  33.635  1.00 39.14           N  
ATOM   2574  CA  ALA    66      23.060  49.887  33.785  1.00 39.88           C  
ATOM   2575  C   ALA    66      23.866  49.217  32.673  1.00 40.50           C  
ATOM   2576  O   ALA    66      24.062  49.785  31.584  1.00 41.64           O  
ATOM   2577  CB  ALA    66      21.631  49.307  33.844  1.00 39.46           C  
ATOM   2578  N   LYS    67      24.279  47.989  32.950  1.00 40.40           N  
ATOM   2579  CA  LYS    67      25.076  47.170  32.048  1.00 40.77           C  
ATOM   2580  C   LYS    67      24.205  46.287  31.161  1.00 40.31           C  
ATOM   2581  O   LYS    67      24.565  45.968  30.023  1.00 40.79           O  
ATOM   2582  CB  LYS    67      26.045  46.318  32.898  1.00 41.50           C  
ATOM   2583  CG  LYS    67      26.800  45.219  32.182  1.00 42.29           C  
ATOM   2584  CD  LYS    67      27.780  45.703  31.139  1.00 43.21           C  
ATOM   2585  CE  LYS    67      28.135  44.509  30.235  1.00 45.53           C  
ATOM   2586  NZ  LYS    67      29.080  44.791  29.116  1.00 48.16           N  
ATOM   2587  N   LEU    68      23.045  45.898  31.675  1.00 39.42           N  
ATOM   2588  CA  LEU    68      22.172  45.002  30.951  1.00 38.70           C  
ATOM   2589  C   LEU    68      20.734  45.496  30.986  1.00 38.53           C  
ATOM   2590  O   LEU    68      20.186  45.770  32.057  1.00 37.70           O  
ATOM   2591  CB  LEU    68      22.273  43.571  31.515  1.00 38.72           C  
ATOM   2592  CG  LEU    68      21.402  42.510  30.825  1.00 37.81           C  
ATOM   2593  CD1 LEU    68      21.897  42.281  29.397  1.00 36.39           C  
ATOM   2594  CD2 LEU    68      21.407  41.183  31.601  1.00 38.05           C  
ATOM   2595  N   TYR    69      20.149  45.596  29.795  1.00 38.52           N  
ATOM   2596  CA  TYR    69      18.778  45.980  29.604  1.00 39.16           C  
ATOM   2597  C   TYR    69      18.013  44.802  29.001  1.00 39.55           C  
ATOM   2598  O   TYR    69      18.286  44.382  27.866  1.00 38.99           O  
ATOM   2599  CB  TYR    69      18.715  47.201  28.693  1.00 39.43           C  
ATOM   2600  CG  TYR    69      19.300  48.437  29.357  1.00 41.34           C  
ATOM   2601  CD1 TYR    69      18.470  49.318  30.052  1.00 41.32           C  
ATOM   2602  CD2 TYR    69      20.676  48.716  29.306  1.00 41.88           C  
ATOM   2603  CE1 TYR    69      18.978  50.448  30.680  1.00 43.36           C  
ATOM   2604  CE2 TYR    69      21.194  49.864  29.924  1.00 43.25           C  
ATOM   2605  CZ  TYR    69      20.330  50.708  30.611  1.00 41.28           C  
ATOM   2606  OH  TYR    69      20.776  51.819  31.235  1.00 42.17           O  
ATOM   2607  N   ILE    70      17.078  44.260  29.780  1.00 40.31           N  
ATOM   2608  CA  ILE    70      16.284  43.104  29.353  1.00 40.26           C  
ATOM   2609  C   ILE    70      14.929  43.578  28.869  1.00 40.82           C  
ATOM   2610  O   ILE    70      14.129  44.102  29.650  1.00 40.30           O  
ATOM   2611  CB  ILE    70      16.103  42.059  30.464  1.00 41.04           C  
ATOM   2612  CG1 ILE    70      17.474  41.603  31.010  1.00 40.03           C  
ATOM   2613  CG2 ILE    70      15.246  40.857  29.904  1.00 39.63           C  
ATOM   2614  CD1 ILE    70      17.402  40.703  32.220  1.00 40.52           C  
ATOM   2615  N   VAL    71      14.703  43.429  27.570  1.00 40.87           N  
ATOM   2616  CA  VAL    71      13.538  43.992  26.926  1.00 42.29           C  
ATOM   2617  C   VAL    71      12.543  42.875  26.635  1.00 43.98           C  
ATOM   2618  O   VAL    71      12.840  41.919  25.918  1.00 42.56           O  
ATOM   2619  CB  VAL    71      13.936  44.800  25.661  1.00 42.15           C  
ATOM   2620  CG1 VAL    71      12.740  45.468  25.033  1.00 40.21           C  
ATOM   2621  CG2 VAL    71      15.058  45.831  26.005  1.00 40.97           C  
ATOM   2622  N   SER    72      11.376  42.993  27.267  1.00 46.92           N  
ATOM   2623  CA  SER    72      10.273  42.050  27.105  1.00 49.48           C  
ATOM   2624  C   SER    72       9.053  42.829  26.653  1.00 51.56           C  
ATOM   2625  O   SER    72       8.189  43.167  27.463  1.00 53.64           O  
ATOM   2626  CB  SER    72       9.954  41.374  28.441  1.00 49.14           C  
ATOM   2627  OG  SER    72      11.023  40.584  28.896  1.00 50.14           O  
ATOM   2628  N   LEU    73       8.976  43.151  25.382  1.00 53.57           N  
ATOM   2629  CA  LEU    73       7.871  43.949  24.897  1.00 55.85           C  
ATOM   2630  C   LEU    73       7.309  43.337  23.612  1.00 57.40           C  
ATOM   2631  O   LEU    73       8.026  42.644  22.886  1.00 57.74           O  
ATOM   2632  CB  LEU    73       8.315  45.405  24.673  1.00 55.59           C  
ATOM   2633  CG  LEU    73       8.566  46.349  25.865  1.00 56.48           C  
ATOM   2634  CD1 LEU    73       8.976  47.759  25.401  1.00 56.41           C  
ATOM   2635  CD2 LEU    73       7.362  46.443  26.807  1.00 55.29           C  
ATOM   2636  N   LYS    74       6.023  43.583  23.347  1.00 59.05           N  
ATOM   2637  CA  LYS    74       5.398  43.185  22.094  1.00 60.68           C  
ATOM   2638  C   LYS    74       6.101  43.891  20.929  1.00 61.83           C  
ATOM   2639  O   LYS    74       6.957  44.763  21.145  1.00 61.63           O  
ATOM   2640  CB  LYS    74       3.906  43.522  22.120  1.00 60.95           C  
ATOM   2641  N   ASP    75       5.765  43.498  19.701  1.00 63.22           N  
ATOM   2642  CA  ASP    75       6.309  44.155  18.506  1.00 64.88           C  
ATOM   2643  C   ASP    75       5.857  45.632  18.426  1.00 65.80           C  
ATOM   2644  O   ASP    75       6.690  46.540  18.301  1.00 66.31           O  
ATOM   2645  CB  ASP    75       5.923  43.397  17.221  1.00 65.19           C  
ATOM   2646  CG  ASP    75       6.338  41.919  17.240  1.00 65.41           C  
ATOM   2647  OD1 ASP    75       7.029  41.490  16.291  1.00 64.77           O  
ATOM   2648  OD2 ASP    75       5.965  41.184  18.185  1.00 66.10           O  
ATOM   2649  N   SER    76       4.546  45.867  18.530  1.00 66.70           N  
ATOM   2650  CA  SER    76       3.960  47.220  18.434  1.00 67.21           C  
ATOM   2651  C   SER    76       4.568  48.273  19.379  1.00 67.58           C  
ATOM   2652  O   SER    76       4.486  49.485  19.120  1.00 67.93           O  
ATOM   2653  CB  SER    76       2.440  47.148  18.614  1.00 67.66           C  
ATOM   2654  N   ALA    77       5.174  47.814  20.471  1.00 67.65           N  
ATOM   2655  CA  ALA    77       5.874  48.710  21.389  1.00 67.34           C  
ATOM   2656  C   ALA    77       7.388  48.824  21.075  1.00 66.79           C  
ATOM   2657  O   ALA    77       8.023  49.826  21.410  1.00 66.33           O  
ATOM   2658  CB  ALA    77       5.635  48.275  22.835  1.00 67.64           C  
ATOM   2659  N   PHE    78       7.942  47.812  20.407  1.00 66.18           N  
ATOM   2660  CA  PHE    78       9.355  47.798  20.027  1.00 65.60           C  
ATOM   2661  C   PHE    78       9.754  49.035  19.225  1.00 65.20           C  
ATOM   2662  O   PHE    78      10.440  49.877  19.761  1.00 65.23           O  
ATOM   2663  CB  PHE    78       9.731  46.514  19.271  1.00 66.07           C  
ATOM   2664  CG  PHE    78      10.894  45.767  19.883  1.00 66.67           C  
ATOM   2665  CD1 PHE    78      12.205  46.194  19.677  1.00 66.92           C  
ATOM   2666  CD2 PHE    78      10.668  44.634  20.685  1.00 67.25           C  
ATOM   2667  CE1 PHE    78      13.280  45.511  20.265  1.00 66.92           C  
ATOM   2668  CE2 PHE    78      11.734  43.933  21.278  1.00 66.03           C  
ATOM   2669  CZ  PHE    78      13.044  44.376  21.068  1.00 66.42           C  
ATOM   2670  N   ALA    79       9.323  49.151  17.962  1.00 64.62           N  
ATOM   2671  CA  ALA    79       9.701  50.284  17.089  1.00 63.94           C  
ATOM   2672  C   ALA    79       9.486  51.604  17.766  1.00 63.50           C  
ATOM   2673  O   ALA    79      10.403  52.414  17.895  1.00 62.43           O  
ATOM   2674  CB  ALA    79       8.900  50.272  15.813  1.00 64.10           C  
ATOM   2675  N   GLU    80       8.229  51.796  18.156  1.00 63.63           N  
ATOM   2676  CA  GLU    80       7.755  52.941  18.901  1.00 63.80           C  
ATOM   2677  C   GLU    80       8.771  53.360  19.951  1.00 63.29           C  
ATOM   2678  O   GLU    80       9.037  54.552  20.133  1.00 63.04           O  
ATOM   2679  CB  GLU    80       6.420  52.578  19.572  1.00 63.73           C  
ATOM   2680  CG  GLU    80       5.830  53.694  20.439  1.00 64.98           C  
ATOM   2681  CD  GLU    80       4.551  53.309  21.186  1.00 65.33           C  
ATOM   2682  OE1 GLU    80       3.785  52.441  20.701  1.00 67.93           O  
ATOM   2683  OE2 GLU    80       4.310  53.902  22.265  1.00 67.54           O  
ATOM   2684  N   LEU    81       9.354  52.363  20.615  1.00 62.96           N  
ATOM   2685  CA  LEU    81      10.094  52.595  21.848  1.00 62.67           C  
ATOM   2686  C   LEU    81      11.582  52.276  21.774  1.00 61.60           C  
ATOM   2687  O   LEU    81      12.313  52.494  22.737  1.00 61.69           O  
ATOM   2688  CB  LEU    81       9.425  51.828  23.002  1.00 63.16           C  
ATOM   2689  CG  LEU    81       7.905  51.989  23.242  1.00 64.05           C  
ATOM   2690  CD1 LEU    81       7.481  51.155  24.451  1.00 64.86           C  
ATOM   2691  CD2 LEU    81       7.443  53.451  23.396  1.00 64.35           C  
ATOM   2692  N   LEU    82      12.019  51.798  20.620  1.00 60.35           N  
ATOM   2693  CA  LEU    82      13.372  51.317  20.429  1.00 59.39           C  
ATOM   2694  C   LEU    82      14.425  52.361  20.733  1.00 58.77           C  
ATOM   2695  O   LEU    82      15.338  52.071  21.486  1.00 58.86           O  
ATOM   2696  CB  LEU    82      13.566  50.767  19.013  1.00 59.08           C  
ATOM   2697  CG  LEU    82      14.893  50.061  18.715  1.00 59.81           C  
ATOM   2698  CD1 LEU    82      15.271  49.070  19.809  1.00 60.66           C  
ATOM   2699  CD2 LEU    82      14.867  49.351  17.363  1.00 59.78           C  
ATOM   2700  N   GLN    83      14.294  53.561  20.159  1.00 58.50           N  
ATOM   2701  CA  GLN    83      15.311  54.596  20.324  0.50 58.17           C  
ATOM   2703  C   GLN    83      15.252  55.258  21.701  1.00 58.45           C  
ATOM   2704  O   GLN    83      16.279  55.728  22.214  1.00 58.12           O  
ATOM   2705  CB  GLN    83      15.245  55.621  19.193  0.50 58.13           C  
ATOM   2707  CG  GLN    83      15.842  55.117  17.875  0.50 57.07           C  
ATOM   2709  CD  GLN    83      14.988  54.049  17.202  0.50 55.84           C  
ATOM   2711  OE1 GLN    83      13.913  54.335  16.673  0.50 54.70           O  
ATOM   2713  NE2 GLN    83      15.469  52.813  17.222  0.50 54.79           N  
ATOM   2715  N   GLY    84      14.053  55.269  22.292  1.00 58.47           N  
ATOM   2716  CA  GLY    84      13.837  55.702  23.667  1.00 58.69           C  
ATOM   2717  C   GLY    84      14.477  54.711  24.629  1.00 59.11           C  
ATOM   2718  O   GLY    84      14.897  55.084  25.731  1.00 59.59           O  
ATOM   2719  N   ILE    85      14.574  53.447  24.206  1.00 58.72           N  
ATOM   2720  CA  ILE    85      15.306  52.432  24.974  1.00 58.16           C  
ATOM   2721  C   ILE    85      16.822  52.601  24.841  1.00 58.10           C  
ATOM   2722  O   ILE    85      17.553  52.433  25.827  1.00 58.03           O  
ATOM   2723  CB  ILE    85      14.926  50.982  24.570  1.00 58.14           C  
ATOM   2724  CG1 ILE    85      13.453  50.672  24.928  1.00 57.08           C  
ATOM   2725  CG2 ILE    85      15.939  49.955  25.194  1.00 57.60           C  
ATOM   2726  CD1 ILE    85      12.776  49.654  24.002  1.00 53.14           C  
ATOM   2727  N   VAL    86      17.294  52.926  23.632  1.00 57.28           N  
ATOM   2728  CA  VAL    86      18.740  52.880  23.362  1.00 56.20           C  
ATOM   2729  C   VAL    86      19.600  54.140  23.554  1.00 55.24           C  
ATOM   2730  O   VAL    86      20.807  54.004  23.758  1.00 55.84           O  
ATOM   2731  CB  VAL    86      19.069  52.211  21.979  1.00 56.71           C  
ATOM   2732  CG1 VAL    86      18.318  50.882  21.840  1.00 55.37           C  
ATOM   2733  CG2 VAL    86      18.790  53.157  20.789  1.00 55.39           C  
ATOM   2734  N   GLU    87      18.996  55.329  23.507  0.50 54.62           N  
ATOM   2736  CA  GLU    87      19.752  56.602  23.581  0.50 53.56           C  
ATOM   2738  C   GLU    87      20.348  56.910  24.969  0.50 52.84           C  
ATOM   2740  O   GLU    87      19.730  56.607  25.994  0.50 52.68           O  
ATOM   2742  CB  GLU    87      18.888  57.780  23.098  0.50 53.66           C  
ATOM   2744  CG  GLU    87      18.716  57.859  21.583  0.50 53.10           C  
ATOM   2746  CD  GLU    87      17.730  58.931  21.145  0.50 52.99           C  
ATOM   2748  OE1 GLU    87      16.651  59.068  21.766  0.50 52.05           O  
ATOM   2750  OE2 GLU    87      18.033  59.634  20.164  0.50 52.28           O  
ATOM   2752  N   GLY    88      21.545  57.505  24.982  1.00 52.45           N  
ATOM   2753  CA  GLY    88      22.237  57.904  26.232  1.00 50.68           C  
ATOM   2754  C   GLY    88      22.772  56.807  27.160  1.00 49.63           C  
ATOM   2755  O   GLY    88      23.036  57.059  28.358  1.00 48.49           O  
ATOM   2756  N   LYS    89      22.924  55.587  26.626  1.00 48.04           N  
ATOM   2757  CA  LYS    89      23.423  54.452  27.416  1.00 46.62           C  
ATOM   2758  C   LYS    89      24.930  54.348  27.308  1.00 45.54           C  
ATOM   2759  O   LYS    89      25.549  54.956  26.436  1.00 45.22           O  
ATOM   2760  CB  LYS    89      22.800  53.116  26.972  1.00 46.76           C  
ATOM   2761  CG  LYS    89      21.319  53.140  26.774  1.00 46.73           C  
ATOM   2762  CD  LYS    89      20.552  53.334  28.058  1.00 47.67           C  
ATOM   2763  CE  LYS    89      19.182  53.878  27.706  1.00 49.38           C  
ATOM   2764  NZ  LYS    89      18.175  53.423  28.645  1.00 52.31           N  
ATOM   2765  N   ARG    90      25.520  53.555  28.193  1.00 44.92           N  
ATOM   2766  CA  ARG    90      26.949  53.284  28.120  1.00 44.15           C  
ATOM   2767  C   ARG    90      27.227  52.493  26.848  1.00 44.93           C  
ATOM   2768  O   ARG    90      26.414  51.656  26.427  1.00 43.56           O  
ATOM   2769  CB  ARG    90      27.403  52.483  29.349  1.00 43.88           C  
ATOM   2770  CG  ARG    90      27.117  53.168  30.681  1.00 40.61           C  
ATOM   2771  CD  ARG    90      27.012  52.148  31.805  1.00 38.70           C  
ATOM   2772  NE  ARG    90      28.232  51.330  31.947  1.00 37.62           N  
ATOM   2773  CZ  ARG    90      28.325  50.249  32.717  1.00 37.10           C  
ATOM   2774  NH1 ARG    90      27.285  49.854  33.449  1.00 37.70           N  
ATOM   2775  NH2 ARG    90      29.470  49.577  32.795  1.00 38.16           N  
ATOM   2776  N   GLU    91      28.379  52.762  26.245  1.00 45.70           N  
ATOM   2777  CA  GLU    91      28.846  52.031  25.080  1.00 47.06           C  
ATOM   2778  C   GLU    91      28.828  50.508  25.310  1.00 46.39           C  
ATOM   2779  O   GLU    91      28.374  49.751  24.454  1.00 46.29           O  
ATOM   2780  CB  GLU    91      30.255  52.491  24.741  1.00 47.81           C  
ATOM   2781  CG  GLU    91      30.413  52.992  23.327  1.00 52.84           C  
ATOM   2782  CD  GLU    91      30.831  51.914  22.339  1.00 58.35           C  
ATOM   2783  OE1 GLU    91      30.618  52.137  21.126  1.00 61.93           O  
ATOM   2784  OE2 GLU    91      31.377  50.855  22.747  1.00 61.95           O  
ATOM   2785  N   GLU    92      29.288  50.065  26.476  1.00 46.08           N  
ATOM   2786  CA  GLU    92      29.327  48.617  26.792  1.00 46.30           C  
ATOM   2787  C   GLU    92      28.012  48.002  27.289  1.00 45.02           C  
ATOM   2788  O   GLU    92      27.978  46.810  27.571  1.00 44.72           O  
ATOM   2789  CB  GLU    92      30.414  48.334  27.832  1.00 46.56           C  
ATOM   2790  CG  GLU    92      30.054  48.879  29.198  1.00 49.31           C  
ATOM   2791  CD  GLU    92      31.148  48.679  30.225  1.00 52.94           C  
ATOM   2792  OE1 GLU    92      31.774  49.692  30.593  1.00 50.68           O  
ATOM   2793  OE2 GLU    92      31.366  47.513  30.658  1.00 56.24           O  
ATOM   2794  N   ALA    93      26.961  48.802  27.465  1.00 44.10           N  
ATOM   2795  CA  ALA    93      25.657  48.240  27.873  1.00 44.22           C  
ATOM   2796  C   ALA    93      25.182  47.203  26.860  1.00 43.71           C  
ATOM   2797  O   ALA    93      25.384  47.358  25.655  1.00 43.69           O  
ATOM   2798  CB  ALA    93      24.619  49.328  28.035  1.00 44.02           C  
ATOM   2799  N   LEU    94      24.580  46.133  27.354  1.00 43.26           N  
ATOM   2800  CA  LEU    94      24.067  45.091  26.480  1.00 43.37           C  
ATOM   2801  C   LEU    94      22.542  45.185  26.403  1.00 42.13           C  
ATOM   2802  O   LEU    94      21.873  45.172  27.448  1.00 42.34           O  
ATOM   2803  CB  LEU    94      24.575  43.739  27.020  1.00 43.64           C  
ATOM   2804  CG  LEU    94      24.436  42.361  26.381  1.00 45.74           C  
ATOM   2805  CD1 LEU    94      24.473  42.407  24.870  1.00 48.47           C  
ATOM   2806  CD2 LEU    94      25.515  41.377  26.913  1.00 44.07           C  
ATOM   2807  N   MET    95      21.988  45.347  25.198  1.00 41.41           N  
ATOM   2808  CA  MET    95      20.509  45.271  25.031  1.00 41.20           C  
ATOM   2809  C   MET    95      20.119  43.920  24.499  1.00 40.33           C  
ATOM   2810  O   MET    95      20.565  43.503  23.418  1.00 39.52           O  
ATOM   2811  CB  MET    95      19.868  46.318  24.101  1.00 41.63           C  
ATOM   2812  CG  MET    95      20.711  47.437  23.608  1.00 46.59           C  
ATOM   2813  SD  MET    95      21.507  48.506  24.988  0.50 54.54          SE  
ATOM   2814  CE  MET    95      19.864  48.955  25.893  1.00 42.54           C  
ATOM   2815  N   VAL    96      19.279  43.243  25.262  1.00 39.48           N  
ATOM   2816  CA  VAL    96      18.744  41.955  24.853  1.00 38.49           C  
ATOM   2817  C   VAL    96      17.224  41.972  24.861  1.00 39.02           C  
ATOM   2818  O   VAL    96      16.592  42.731  25.600  1.00 38.29           O  
ATOM   2819  CB  VAL    96      19.298  40.780  25.730  1.00 38.97           C  
ATOM   2820  CG1 VAL    96      20.824  40.795  25.742  1.00 37.37           C  
ATOM   2821  CG2 VAL    96      18.734  40.813  27.159  1.00 36.79           C  
ATOM   2822  N   HIS    97      16.631  41.151  24.005  1.00 39.58           N  
ATOM   2823  CA  HIS    97      15.209  40.888  24.129  1.00 39.83           C  
ATOM   2824  C   HIS    97      14.992  39.431  24.479  1.00 39.75           C  
ATOM   2825  O   HIS    97      15.928  38.639  24.452  1.00 39.35           O  
ATOM   2826  CB  HIS    97      14.440  41.327  22.898  1.00 39.04           C  
ATOM   2827  CG  HIS    97      14.737  40.533  21.678  1.00 40.59           C  
ATOM   2828  ND1 HIS    97      14.258  39.249  21.492  1.00 41.27           N  
ATOM   2829  CD2 HIS    97      15.441  40.839  20.562  1.00 42.20           C  
ATOM   2830  CE1 HIS    97      14.647  38.806  20.308  1.00 39.75           C  
ATOM   2831  NE2 HIS    97      15.369  39.747  19.727  1.00 42.68           N  
ATOM   2832  N   THR    98      13.763  39.098  24.839  1.00 40.21           N  
ATOM   2833  CA  THR    98      13.435  37.782  25.366  1.00 40.90           C  
ATOM   2834  C   THR    98      12.452  37.014  24.480  1.00 40.93           C  
ATOM   2835  O   THR    98      11.802  36.057  24.939  1.00 42.21           O  
ATOM   2836  CB  THR    98      12.820  37.927  26.744  1.00 40.35           C  
ATOM   2837  OG1 THR    98      11.733  38.848  26.667  1.00 39.48           O  
ATOM   2838  CG2 THR    98      13.840  38.488  27.724  1.00 41.17           C  
ATOM   2839  N   ALA    99      12.290  37.446  23.237  1.00 41.09           N  
ATOM   2840  CA  ALA    99      11.270  36.847  22.379  1.00 40.78           C  
ATOM   2841  C   ALA    99      11.818  35.662  21.606  1.00 41.89           C  
ATOM   2842  O   ALA    99      12.921  35.718  21.073  1.00 41.67           O  
ATOM   2843  CB  ALA    99      10.700  37.850  21.449  1.00 40.01           C  
ATOM   2844  N   GLY   100      11.020  34.593  21.539  1.00 42.84           N  
ATOM   2845  CA  GLY   100      11.353  33.407  20.754  1.00 43.50           C  
ATOM   2846  C   GLY   100      11.374  33.645  19.248  1.00 44.54           C  
ATOM   2847  O   GLY   100      12.170  33.037  18.521  1.00 44.33           O  
ATOM   2848  N   SER   101      10.500  34.522  18.766  1.00 44.19           N  
ATOM   2849  CA  SER   101      10.281  34.597  17.332  1.00 44.00           C  
ATOM   2850  C   SER   101      10.628  35.981  16.783  1.00 44.60           C  
ATOM   2851  O   SER   101      10.150  36.363  15.727  1.00 45.14           O  
ATOM   2852  CB  SER   101       8.852  34.178  16.976  1.00 43.98           C  
ATOM   2853  OG  SER   101       8.670  32.765  17.074  1.00 42.41           O  
ATOM   2854  N   ILE   102      11.454  36.727  17.507  1.00 44.50           N  
ATOM   2855  CA  ILE   102      12.000  37.982  16.995  1.00 44.98           C  
ATOM   2856  C   ILE   102      13.488  37.769  16.733  1.00 45.12           C  
ATOM   2857  O   ILE   102      14.207  37.315  17.621  1.00 45.38           O  
ATOM   2858  CB  ILE   102      11.808  39.145  17.985  1.00 44.58           C  
ATOM   2859  CG1 ILE   102      10.331  39.482  18.171  1.00 45.19           C  
ATOM   2860  CG2 ILE   102      12.548  40.401  17.528  1.00 44.85           C  
ATOM   2861  CD1 ILE   102      10.134  40.592  19.254  1.00 45.71           C  
ATOM   2862  N   PRO   103      13.963  38.105  15.521  1.00 46.08           N  
ATOM   2863  CA  PRO   103      15.386  37.898  15.225  1.00 46.35           C  
ATOM   2864  C   PRO   103      16.264  38.803  16.069  1.00 47.12           C  
ATOM   2865  O   PRO   103      15.821  39.885  16.475  1.00 47.65           O  
ATOM   2866  CB  PRO   103      15.505  38.274  13.746  1.00 46.19           C  
ATOM   2867  CG  PRO   103      14.313  39.060  13.433  1.00 46.26           C  
ATOM   2868  CD  PRO   103      13.230  38.695  14.383  1.00 45.85           C  
ATOM   2869  N   MET   104      17.496  38.375  16.344  1.00 47.79           N  
ATOM   2870  CA  MET   104      18.452  39.229  17.057  1.00 48.61           C  
ATOM   2871  C   MET   104      18.745  40.522  16.307  1.00 49.12           C  
ATOM   2872  O   MET   104      19.045  41.539  16.932  1.00 49.62           O  
ATOM   2873  CB  MET   104      19.765  38.496  17.293  1.00 48.82           C  
ATOM   2874  CG  MET   104      20.760  39.269  18.127  1.00 48.62           C  
ATOM   2875  SD  MET   104      22.404  38.280  18.428  0.70 49.29          SE  
ATOM   2876  CE  MET   104      23.167  38.328  16.657  1.00 48.28           C  
ATOM   2877  N   ASN   105      18.636  40.480  14.979  1.00 49.51           N  
ATOM   2878  CA  ASN   105      19.038  41.608  14.116  1.00 50.45           C  
ATOM   2879  C   ASN   105      18.216  42.882  14.293  1.00 50.46           C  
ATOM   2880  O   ASN   105      18.594  43.922  13.772  1.00 51.36           O  
ATOM   2881  CB  ASN   105      19.112  41.206  12.623  1.00 50.34           C  
ATOM   2882  CG  ASN   105      17.742  40.829  12.030  1.00 51.94           C  
ATOM   2883  OD1 ASN   105      16.691  41.247  12.524  1.00 54.12           O  
ATOM   2884  ND2 ASN   105      17.759  40.034  10.964  1.00 52.45           N  
ATOM   2885  N   VAL   106      17.108  42.814  15.030  1.00 50.32           N  
ATOM   2886  CA  VAL   106      16.393  44.041  15.378  1.00 49.62           C  
ATOM   2887  C   VAL   106      17.354  45.101  15.899  1.00 49.27           C  
ATOM   2888  O   VAL   106      17.287  46.258  15.495  1.00 49.30           O  
ATOM   2889  CB  VAL   106      15.229  43.815  16.383  1.00 49.73           C  
ATOM   2890  CG1 VAL   106      14.226  42.990  15.754  1.00 49.91           C  
ATOM   2891  CG2 VAL   106      15.691  43.150  17.699  1.00 49.70           C  
ATOM   2892  N   TRP   107      18.270  44.691  16.771  1.00 48.94           N  
ATOM   2893  CA  TRP   107      19.205  45.613  17.401  1.00 48.75           C  
ATOM   2894  C   TRP   107      20.324  46.155  16.525  1.00 48.90           C  
ATOM   2895  O   TRP   107      20.946  47.150  16.892  1.00 48.37           O  
ATOM   2896  CB  TRP   107      19.867  44.928  18.581  1.00 48.29           C  
ATOM   2897  CG  TRP   107      18.930  44.481  19.640  1.00 48.56           C  
ATOM   2898  CD1 TRP   107      18.627  43.190  19.988  1.00 48.11           C  
ATOM   2899  CD2 TRP   107      18.189  45.322  20.522  1.00 48.06           C  
ATOM   2900  NE1 TRP   107      17.738  43.181  21.036  1.00 46.42           N  
ATOM   2901  CE2 TRP   107      17.454  44.476  21.386  1.00 47.33           C  
ATOM   2902  CE3 TRP   107      18.079  46.713  20.675  1.00 46.91           C  
ATOM   2903  CZ2 TRP   107      16.614  44.975  22.384  1.00 46.51           C  
ATOM   2904  CZ3 TRP   107      17.231  47.204  21.670  1.00 48.02           C  
ATOM   2905  CH2 TRP   107      16.513  46.333  22.508  1.00 47.64           C  
ATOM   2906  N   GLU   108      20.629  45.474  15.419  1.00 49.59           N  
ATOM   2907  CA  GLU   108      21.853  45.777  14.687  1.00 50.52           C  
ATOM   2908  C   GLU   108      21.797  47.143  14.007  1.00 49.94           C  
ATOM   2909  O   GLU   108      20.795  47.503  13.380  1.00 49.99           O  
ATOM   2910  CB  GLU   108      22.243  44.647  13.726  1.00 50.90           C  
ATOM   2911  CG  GLU   108      21.760  44.757  12.283  1.00 52.68           C  
ATOM   2912  CD  GLU   108      22.488  43.785  11.365  1.00 52.75           C  
ATOM   2913  OE1 GLU   108      23.707  43.967  11.179  1.00 55.86           O  
ATOM   2914  OE2 GLU   108      21.851  42.843  10.828  1.00 55.45           O  
ATOM   2915  N   GLY   109      22.873  47.911  14.166  1.00 49.40           N  
ATOM   2916  CA  GLY   109      22.891  49.293  13.702  1.00 48.52           C  
ATOM   2917  C   GLY   109      22.395  50.261  14.767  1.00 48.12           C  
ATOM   2918  O   GLY   109      22.694  51.456  14.705  1.00 48.12           O  
ATOM   2919  N   HIS   110      21.646  49.754  15.752  1.00 47.32           N  
ATOM   2920  CA  HIS   110      21.107  50.601  16.829  1.00 46.51           C  
ATOM   2921  C   HIS   110      22.008  50.692  18.055  1.00 45.57           C  
ATOM   2922  O   HIS   110      22.113  51.758  18.666  1.00 46.01           O  
ATOM   2923  CB  HIS   110      19.694  50.151  17.217  1.00 46.84           C  
ATOM   2924  CG  HIS   110      18.694  50.311  16.114  1.00 47.76           C  
ATOM   2925  ND1 HIS   110      18.083  49.240  15.497  1.00 49.70           N  
ATOM   2926  CD2 HIS   110      18.211  51.419  15.504  1.00 47.97           C  
ATOM   2927  CE1 HIS   110      17.269  49.678  14.552  1.00 49.18           C  
ATOM   2928  NE2 HIS   110      17.324  51.000  14.541  1.00 48.83           N  
ATOM   2929  N   VAL   111      22.639  49.580  18.426  1.00 44.05           N  
ATOM   2930  CA  VAL   111      23.565  49.543  19.567  1.00 42.90           C  
ATOM   2931  C   VAL   111      24.768  48.659  19.297  1.00 42.23           C  
ATOM   2932  O   VAL   111      24.685  47.701  18.530  1.00 42.36           O  
ATOM   2933  CB  VAL   111      22.894  49.045  20.891  1.00 43.83           C  
ATOM   2934  CG1 VAL   111      22.079  50.164  21.543  1.00 42.39           C  
ATOM   2935  CG2 VAL   111      22.066  47.799  20.662  1.00 41.44           C  
ATOM   2936  N   PRO   112      25.912  49.002  19.890  1.00 41.97           N  
ATOM   2937  CA  PRO   112      27.081  48.153  19.683  1.00 41.49           C  
ATOM   2938  C   PRO   112      27.034  46.755  20.327  1.00 41.10           C  
ATOM   2939  O   PRO   112      27.692  45.870  19.822  1.00 40.54           O  
ATOM   2940  CB  PRO   112      28.237  48.982  20.257  1.00 41.35           C  
ATOM   2941  CG  PRO   112      27.586  49.982  21.167  1.00 41.71           C  
ATOM   2942  CD  PRO   112      26.222  50.233  20.654  1.00 41.97           C  
ATOM   2943  N   HIS   113      26.312  46.574  21.437  1.00 40.22           N  
ATOM   2944  CA  HIS   113      26.264  45.282  22.112  1.00 40.09           C  
ATOM   2945  C   HIS   113      24.792  44.904  22.332  1.00 41.21           C  
ATOM   2946  O   HIS   113      23.985  45.696  22.873  1.00 40.06           O  
ATOM   2947  CB  HIS   113      27.068  45.287  23.419  1.00 39.82           C  
ATOM   2948  CG  HIS   113      28.470  45.788  23.260  1.00 38.80           C  
ATOM   2949  ND1 HIS   113      29.534  44.952  22.989  1.00 39.06           N  
ATOM   2950  CD2 HIS   113      28.977  47.049  23.272  1.00 38.08           C  
ATOM   2951  CE1 HIS   113      30.636  45.673  22.867  1.00 38.49           C  
ATOM   2952  NE2 HIS   113      30.327  46.945  23.046  1.00 36.36           N  
ATOM   2953  N   TYR   114      24.446  43.697  21.882  1.00 40.83           N  
ATOM   2954  CA  TYR   114      23.052  43.284  21.830  1.00 41.43           C  
ATOM   2955  C   TYR   114      22.962  41.761  21.706  1.00 41.37           C  
ATOM   2956  O   TYR   114      23.966  41.102  21.419  1.00 42.39           O  
ATOM   2957  CB  TYR   114      22.323  43.980  20.684  1.00 41.32           C  
ATOM   2958  CG  TYR   114      22.872  43.694  19.307  1.00 41.59           C  
ATOM   2959  CD1 TYR   114      22.477  42.554  18.603  1.00 43.05           C  
ATOM   2960  CD2 TYR   114      23.757  44.579  18.693  1.00 42.67           C  
ATOM   2961  CE1 TYR   114      22.978  42.279  17.333  1.00 43.53           C  
ATOM   2962  CE2 TYR   114      24.261  44.333  17.406  1.00 41.67           C  
ATOM   2963  CZ  TYR   114      23.868  43.178  16.740  1.00 43.27           C  
ATOM   2964  OH  TYR   114      24.348  42.911  15.479  1.00 43.40           O  
ATOM   2965  N   GLY   115      21.775  41.213  21.916  1.00 40.86           N  
ATOM   2966  CA  GLY   115      21.609  39.768  21.936  1.00 40.96           C  
ATOM   2967  C   GLY   115      20.204  39.357  22.279  1.00 41.11           C  
ATOM   2968  O   GLY   115      19.311  40.193  22.374  1.00 40.96           O  
ATOM   2969  N   VAL   116      20.009  38.049  22.425  1.00 40.99           N  
ATOM   2970  CA  VAL   116      18.722  37.470  22.760  1.00 40.04           C  
ATOM   2971  C   VAL   116      18.975  36.615  23.986  1.00 39.87           C  
ATOM   2972  O   VAL   116      19.954  35.889  24.045  1.00 39.51           O  
ATOM   2973  CB  VAL   116      18.168  36.609  21.597  1.00 40.73           C  
ATOM   2974  CG1 VAL   116      16.837  35.945  21.976  1.00 38.78           C  
ATOM   2975  CG2 VAL   116      17.999  37.454  20.353  1.00 41.21           C  
ATOM   2976  N   PHE   117      18.102  36.738  24.969  1.00 40.10           N  
ATOM   2977  CA  PHE   117      18.239  36.104  26.273  1.00 40.27           C  
ATOM   2978  C   PHE   117      16.893  35.404  26.507  1.00 40.39           C  
ATOM   2979  O   PHE   117      16.011  35.975  27.153  1.00 39.48           O  
ATOM   2980  CB  PHE   117      18.442  37.221  27.288  1.00 40.84           C  
ATOM   2981  CG  PHE   117      19.000  36.794  28.612  1.00 41.34           C  
ATOM   2982  CD1 PHE   117      20.247  36.184  28.712  1.00 41.64           C  
ATOM   2983  CD2 PHE   117      18.317  37.104  29.774  1.00 43.58           C  
ATOM   2984  CE1 PHE   117      20.773  35.829  29.942  1.00 43.04           C  
ATOM   2985  CE2 PHE   117      18.842  36.766  31.032  1.00 46.06           C  
ATOM   2986  CZ  PHE   117      20.080  36.130  31.115  1.00 44.12           C  
ATOM   2987  N   TYR   118      16.732  34.190  25.957  1.00 40.32           N  
ATOM   2988  CA  TYR   118      15.401  33.544  25.824  1.00 40.80           C  
ATOM   2989  C   TYR   118      15.169  32.329  26.753  1.00 40.29           C  
ATOM   2990  O   TYR   118      15.610  31.239  26.444  1.00 39.52           O  
ATOM   2991  CB  TYR   118      15.194  33.103  24.366  1.00 40.50           C  
ATOM   2992  CG  TYR   118      13.890  32.360  24.071  1.00 41.23           C  
ATOM   2993  CD1 TYR   118      12.631  32.908  24.408  1.00 38.66           C  
ATOM   2994  CD2 TYR   118      13.912  31.157  23.366  1.00 39.00           C  
ATOM   2995  CE1 TYR   118      11.451  32.227  24.111  1.00 38.50           C  
ATOM   2996  CE2 TYR   118      12.748  30.483  23.042  1.00 39.24           C  
ATOM   2997  CZ  TYR   118      11.530  31.009  23.413  1.00 40.47           C  
ATOM   2998  OH  TYR   118      10.407  30.307  23.067  1.00 42.18           O  
ATOM   2999  N   PRO   119      14.522  32.529  27.907  1.00 40.09           N  
ATOM   3000  CA  PRO   119      14.137  31.362  28.702  1.00 39.73           C  
ATOM   3001  C   PRO   119      12.793  30.810  28.220  1.00 38.83           C  
ATOM   3002  O   PRO   119      11.805  31.527  28.247  1.00 39.34           O  
ATOM   3003  CB  PRO   119      14.023  31.920  30.125  1.00 39.95           C  
ATOM   3004  CG  PRO   119      13.660  33.386  29.955  1.00 39.68           C  
ATOM   3005  CD  PRO   119      14.158  33.807  28.560  1.00 40.67           C  
ATOM   3006  N   MET   120      12.777  29.558  27.763  1.00 37.72           N  
ATOM   3007  CA  MET   120      11.598  28.960  27.120  1.00 37.14           C  
ATOM   3008  C   MET   120      10.853  28.141  28.155  1.00 36.75           C  
ATOM   3009  O   MET   120      11.307  27.091  28.600  1.00 36.04           O  
ATOM   3010  CB  MET   120      12.039  28.058  25.956  1.00 37.12           C  
ATOM   3011  CG  MET   120      10.921  27.627  25.021  1.00 36.58           C  
ATOM   3012  SD  MET   120      11.575  26.507  23.570  0.50 35.65          SE  
ATOM   3013  CE  MET   120      12.229  25.056  24.668  1.00 39.08           C  
ATOM   3014  N   GLN   121       9.713  28.651  28.561  1.00 37.30           N  
ATOM   3015  CA  GLN   121       8.892  28.027  29.582  1.00 37.13           C  
ATOM   3016  C   GLN   121       7.595  28.793  29.573  1.00 37.81           C  
ATOM   3017  O   GLN   121       7.555  29.932  29.134  1.00 38.72           O  
ATOM   3018  CB  GLN   121       9.578  28.123  30.967  1.00 37.24           C  
ATOM   3019  CG  GLN   121       8.924  27.332  32.128  1.00 35.95           C  
ATOM   3020  CD  GLN   121       8.537  25.914  31.736  1.00 38.05           C  
ATOM   3021  OE1 GLN   121       7.573  25.705  30.993  1.00 35.77           O  
ATOM   3022  NE2 GLN   121       9.297  24.933  32.215  1.00 37.35           N  
ATOM   3023  N   THR   122       6.532  28.164  30.049  1.00 38.34           N  
ATOM   3024  CA  THR   122       5.273  28.838  30.218  1.00 39.24           C  
ATOM   3025  C   THR   122       5.367  29.613  31.548  1.00 40.23           C  
ATOM   3026  O   THR   122       5.745  29.051  32.590  1.00 40.26           O  
ATOM   3027  CB  THR   122       4.114  27.827  30.121  1.00 38.04           C  
ATOM   3028  OG1 THR   122       2.871  28.472  30.347  1.00 38.82           O  
ATOM   3029  CG2 THR   122       4.278  26.678  31.097  1.00 38.62           C  
ATOM   3030  N   PHE   123       5.078  30.911  31.507  1.00 40.84           N  
ATOM   3031  CA  PHE   123       5.238  31.764  32.714  1.00 41.13           C  
ATOM   3032  C   PHE   123       3.925  32.412  33.073  1.00 41.80           C  
ATOM   3033  O   PHE   123       3.161  32.776  32.201  1.00 42.81           O  
ATOM   3034  CB  PHE   123       6.251  32.890  32.475  1.00 39.96           C  
ATOM   3035  CG  PHE   123       7.669  32.422  32.313  1.00 39.60           C  
ATOM   3036  CD1 PHE   123       8.387  31.913  33.400  1.00 36.79           C  
ATOM   3037  CD2 PHE   123       8.289  32.498  31.084  1.00 36.36           C  
ATOM   3038  CE1 PHE   123       9.680  31.513  33.257  1.00 36.18           C  
ATOM   3039  CE2 PHE   123       9.598  32.091  30.936  1.00 39.30           C  
ATOM   3040  CZ  PHE   123      10.295  31.602  32.018  1.00 37.43           C  
ATOM   3041  N   SER   124       3.666  32.562  34.357  1.00 43.39           N  
ATOM   3042  CA  SER   124       2.500  33.295  34.833  1.00 44.81           C  
ATOM   3043  C   SER   124       2.977  34.029  36.063  1.00 45.17           C  
ATOM   3044  O   SER   124       3.857  33.543  36.765  1.00 44.63           O  
ATOM   3045  CB  SER   124       1.349  32.353  35.209  1.00 45.38           C  
ATOM   3046  OG  SER   124       0.740  31.780  34.055  1.00 47.12           O  
ATOM   3047  N   LYS   125       2.403  35.197  36.311  1.00 46.33           N  
ATOM   3048  CA  LYS   125       2.820  36.044  37.429  1.00 48.08           C  
ATOM   3049  C   LYS   125       2.584  35.408  38.800  1.00 48.39           C  
ATOM   3050  O   LYS   125       3.453  35.474  39.670  1.00 48.41           O  
ATOM   3051  CB  LYS   125       2.124  37.409  37.364  1.00 47.88           C  
ATOM   3052  CG  LYS   125       2.800  38.348  36.389  1.00 48.58           C  
ATOM   3053  CD  LYS   125       2.200  39.718  36.440  1.00 48.86           C  
ATOM   3054  CE  LYS   125       2.583  40.492  35.192  1.00 49.71           C  
ATOM   3055  NZ  LYS   125       1.763  41.730  35.053  1.00 50.39           N  
ATOM   3056  N   GLN   126       1.428  34.778  38.967  1.00 48.93           N  
ATOM   3057  CA  GLN   126       0.991  34.186  40.230  0.50 49.78           C  
ATOM   3059  C   GLN   126       1.584  32.795  40.482  1.00 50.29           C  
ATOM   3060  O   GLN   126       1.150  32.095  41.400  1.00 51.02           O  
ATOM   3061  CB  GLN   126      -0.539  34.033  40.242  0.50 49.75           C  
ATOM   3063  CG  GLN   126      -1.356  35.181  39.654  0.50 50.04           C  
ATOM   3065  CD  GLN   126      -2.783  34.754  39.309  0.50 49.84           C  
ATOM   3067  OE1 GLN   126      -3.268  34.997  38.201  0.50 49.37           O  
ATOM   3069  NE2 GLN   126      -3.455  34.104  40.258  0.50 49.58           N  
ATOM   3071  N   ARG   127       2.530  32.368  39.650  1.00 50.48           N  
ATOM   3072  CA  ARG   127       3.006  30.991  39.677  1.00 51.11           C  
ATOM   3073  C   ARG   127       4.537  30.925  39.599  1.00 51.48           C  
ATOM   3074  O   ARG   127       5.155  31.419  38.640  1.00 51.33           O  
ATOM   3075  CB  ARG   127       2.321  30.201  38.545  1.00 51.25           C  
ATOM   3076  CG  ARG   127       3.002  28.942  38.089  1.00 51.77           C  
ATOM   3077  CD  ARG   127       2.693  27.750  38.959  1.00 51.75           C  
ATOM   3078  NE  ARG   127       3.584  26.663  38.591  1.00 53.51           N  
ATOM   3079  CZ  ARG   127       3.813  25.582  39.332  1.00 55.89           C  
ATOM   3080  NH1 ARG   127       3.200  25.417  40.505  1.00 55.82           N  
ATOM   3081  NH2 ARG   127       4.667  24.666  38.892  1.00 55.87           N  
ATOM   3082  N   GLU   128       5.127  30.320  40.629  1.00 51.49           N  
ATOM   3083  CA  GLU   128       6.581  30.209  40.785  1.00 51.82           C  
ATOM   3084  C   GLU   128       7.109  29.024  40.003  1.00 51.26           C  
ATOM   3085  O   GLU   128       6.481  27.960  39.992  1.00 51.71           O  
ATOM   3086  CB  GLU   128       6.944  30.008  42.266  1.00 52.54           C  
ATOM   3087  CG  GLU   128       6.566  31.165  43.201  1.00 54.26           C  
ATOM   3088  CD  GLU   128       7.524  32.345  43.096  1.00 57.63           C  
ATOM   3089  OE1 GLU   128       8.297  32.419  42.105  1.00 57.63           O  
ATOM   3090  OE2 GLU   128       7.503  33.200  44.015  1.00 58.10           O  
ATOM   3091  N   VAL   129       8.251  29.191  39.353  1.00 50.57           N  
ATOM   3092  CA  VAL   129       8.853  28.080  38.603  1.00 50.16           C  
ATOM   3093  C   VAL   129      10.315  27.920  38.938  1.00 49.84           C  
ATOM   3094  O   VAL   129      11.015  28.901  39.157  1.00 49.54           O  
ATOM   3095  CB  VAL   129       8.724  28.213  37.050  1.00 49.95           C  
ATOM   3096  CG1 VAL   129       7.302  28.102  36.641  1.00 50.92           C  
ATOM   3097  CG2 VAL   129       9.309  29.510  36.553  1.00 49.12           C  
ATOM   3098  N   ASP   130      10.766  26.671  38.964  1.00 48.95           N  
ATOM   3099  CA  ASP   130      12.165  26.383  39.113  1.00 48.26           C  
ATOM   3100  C   ASP   130      12.887  26.694  37.799  1.00 47.57           C  
ATOM   3101  O   ASP   130      12.751  25.954  36.789  1.00 47.44           O  
ATOM   3102  CB  ASP   130      12.354  24.919  39.507  1.00 48.92           C  
ATOM   3103  CG  ASP   130      13.700  24.665  40.177  1.00 51.09           C  
ATOM   3104  OD1 ASP   130      14.444  25.653  40.452  1.00 49.91           O  
ATOM   3105  OD2 ASP   130      13.995  23.471  40.443  1.00 53.88           O  
ATOM   3106  N   PHE   131      13.629  27.803  37.808  1.00 46.39           N  
ATOM   3107  CA  PHE   131      14.548  28.133  36.719  1.00 45.41           C  
ATOM   3108  C   PHE   131      15.652  27.109  36.432  1.00 45.27           C  
ATOM   3109  O   PHE   131      16.146  27.055  35.299  1.00 45.03           O  
ATOM   3110  CB  PHE   131      15.141  29.522  36.915  1.00 45.36           C  
ATOM   3111  CG  PHE   131      14.396  30.574  36.184  1.00 44.06           C  
ATOM   3112  CD1 PHE   131      13.172  31.042  36.677  1.00 42.17           C  
ATOM   3113  CD2 PHE   131      14.879  31.057  34.976  1.00 42.92           C  
ATOM   3114  CE1 PHE   131      12.467  32.001  35.989  1.00 43.81           C  
ATOM   3115  CE2 PHE   131      14.177  32.018  34.262  1.00 42.75           C  
ATOM   3116  CZ  PHE   131      12.969  32.490  34.765  1.00 45.03           C  
ATOM   3117  N   LYS   132      16.015  26.286  37.423  1.00 45.11           N  
ATOM   3118  CA  LYS   132      17.085  25.297  37.230  1.00 45.56           C  
ATOM   3119  C   LYS   132      16.881  24.423  35.992  1.00 45.36           C  
ATOM   3120  O   LYS   132      17.849  24.113  35.282  1.00 45.30           O  
ATOM   3121  CB  LYS   132      17.335  24.434  38.474  1.00 46.12           C  
ATOM   3122  CG  LYS   132      17.956  25.217  39.652  1.00 46.90           C  
ATOM   3123  CD  LYS   132      19.432  25.576  39.422  1.00 49.25           C  
ATOM   3124  CE  LYS   132      19.918  26.630  40.435  1.00 51.21           C  
ATOM   3125  NZ  LYS   132      21.374  26.932  40.298  1.00 52.67           N  
ATOM   3126  N   GLU   133      15.639  24.057  35.700  1.00 45.02           N  
ATOM   3127  CA  GLU   133      15.417  23.211  34.530  1.00 45.64           C  
ATOM   3128  C   GLU   133      14.839  23.881  33.267  1.00 44.06           C  
ATOM   3129  O   GLU   133      14.432  23.189  32.331  1.00 44.26           O  
ATOM   3130  CB  GLU   133      14.673  21.938  34.926  1.00 46.62           C  
ATOM   3131  CG  GLU   133      15.609  20.947  35.645  1.00 49.87           C  
ATOM   3132  CD  GLU   133      16.749  20.427  34.751  1.00 53.58           C  
ATOM   3133  OE1 GLU   133      16.446  19.713  33.774  1.00 56.68           O  
ATOM   3134  OE2 GLU   133      17.941  20.706  35.028  1.00 54.21           O  
ATOM   3135  N   ILE   134      14.866  25.208  33.234  1.00 42.45           N  
ATOM   3136  CA  ILE   134      14.392  25.972  32.083  1.00 42.02           C  
ATOM   3137  C   ILE   134      15.444  26.070  30.960  1.00 41.58           C  
ATOM   3138  O   ILE   134      16.546  26.592  31.165  1.00 41.50           O  
ATOM   3139  CB  ILE   134      13.831  27.389  32.491  1.00 42.06           C  
ATOM   3140  CG1 ILE   134      12.671  27.217  33.498  1.00 41.51           C  
ATOM   3141  CG2 ILE   134      13.334  28.134  31.262  1.00 40.90           C  
ATOM   3142  CD1 ILE   134      12.052  28.524  34.025  1.00 41.84           C  
ATOM   3143  N   PRO   135      15.116  25.540  29.772  1.00 41.56           N  
ATOM   3144  CA  PRO   135      15.998  25.794  28.623  1.00 41.37           C  
ATOM   3145  C   PRO   135      16.160  27.308  28.367  1.00 40.93           C  
ATOM   3146  O   PRO   135      15.166  28.019  28.150  1.00 40.48           O  
ATOM   3147  CB  PRO   135      15.265  25.129  27.453  1.00 41.70           C  
ATOM   3148  CG  PRO   135      14.291  24.172  28.077  1.00 42.14           C  
ATOM   3149  CD  PRO   135      13.947  24.706  29.424  1.00 41.12           C  
ATOM   3150  N   PHE   136      17.400  27.786  28.417  1.00 40.62           N  
ATOM   3151  CA  PHE   136      17.702  29.199  28.238  1.00 41.48           C  
ATOM   3152  C   PHE   136      18.550  29.331  26.963  1.00 41.93           C  
ATOM   3153  O   PHE   136      19.686  28.891  26.952  1.00 42.11           O  
ATOM   3154  CB  PHE   136      18.552  29.645  29.420  1.00 41.45           C  
ATOM   3155  CG  PHE   136      18.104  30.887  30.085  1.00 42.52           C  
ATOM   3156  CD1 PHE   136      18.152  32.109  29.436  1.00 42.23           C  
ATOM   3157  CD2 PHE   136      17.702  30.847  31.408  1.00 43.39           C  
ATOM   3158  CE1 PHE   136      17.773  33.258  30.095  1.00 45.31           C  
ATOM   3159  CE2 PHE   136      17.333  31.990  32.079  1.00 42.38           C  
ATOM   3160  CZ  PHE   136      17.363  33.192  31.442  1.00 43.35           C  
ATOM   3161  N   PHE   137      18.018  29.947  25.909  1.00 41.84           N  
ATOM   3162  CA  PHE   137      18.749  30.117  24.649  1.00 41.43           C  
ATOM   3163  C   PHE   137      19.336  31.499  24.482  1.00 42.11           C  
ATOM   3164  O   PHE   137      18.650  32.514  24.731  1.00 42.15           O  
ATOM   3165  CB  PHE   137      17.856  29.763  23.476  1.00 40.54           C  
ATOM   3166  CG  PHE   137      17.221  28.424  23.632  1.00 41.34           C  
ATOM   3167  CD1 PHE   137      17.892  27.274  23.221  1.00 40.03           C  
ATOM   3168  CD2 PHE   137      15.977  28.300  24.250  1.00 39.77           C  
ATOM   3169  CE1 PHE   137      17.326  26.034  23.385  1.00 40.45           C  
ATOM   3170  CE2 PHE   137      15.418  27.066  24.424  1.00 39.44           C  
ATOM   3171  CZ  PHE   137      16.089  25.930  23.988  1.00 40.69           C  
ATOM   3172  N   ILE   138      20.614  31.522  24.078  1.00 42.42           N  
ATOM   3173  CA  ILE   138      21.437  32.739  24.072  1.00 42.78           C  
ATOM   3174  C   ILE   138      22.000  32.962  22.690  1.00 42.75           C  
ATOM   3175  O   ILE   138      22.514  32.035  22.050  1.00 42.49           O  
ATOM   3176  CB  ILE   138      22.638  32.646  25.065  1.00 43.32           C  
ATOM   3177  CG1 ILE   138      22.186  32.455  26.529  1.00 44.13           C  
ATOM   3178  CG2 ILE   138      23.622  33.866  24.920  1.00 43.52           C  
ATOM   3179  CD1 ILE   138      21.073  33.277  26.987  1.00 44.73           C  
ATOM   3180  N   GLU   139      21.877  34.201  22.240  1.00 42.62           N  
ATOM   3181  CA  GLU   139      22.535  34.696  21.036  1.00 42.73           C  
ATOM   3182  C   GLU   139      23.059  36.088  21.422  1.00 42.50           C  
ATOM   3183  O   GLU   139      22.441  36.763  22.255  1.00 42.13           O  
ATOM   3184  CB  GLU   139      21.502  34.794  19.905  1.00 42.54           C  
ATOM   3185  CG  GLU   139      22.031  34.502  18.511  1.00 42.46           C  
ATOM   3186  CD  GLU   139      20.990  34.790  17.444  1.00 42.94           C  
ATOM   3187  OE1 GLU   139      19.830  35.067  17.818  1.00 46.15           O  
ATOM   3188  OE2 GLU   139      21.319  34.737  16.235  1.00 43.30           O  
ATOM   3189  N   ALA   140      24.213  36.496  20.883  1.00 42.26           N  
ATOM   3190  CA  ALA   140      24.714  37.863  21.082  1.00 41.99           C  
ATOM   3191  C   ALA   140      25.579  38.348  19.917  1.00 42.32           C  
ATOM   3192  O   ALA   140      26.047  37.552  19.110  1.00 41.23           O  
ATOM   3193  CB  ALA   140      25.457  37.994  22.402  1.00 42.63           C  
ATOM   3194  N   SER   141      25.768  39.666  19.850  1.00 42.71           N  
ATOM   3195  CA  SER   141      26.560  40.348  18.806  1.00 42.92           C  
ATOM   3196  C   SER   141      28.052  40.015  18.790  1.00 43.96           C  
ATOM   3197  O   SER   141      28.734  40.306  17.813  1.00 44.43           O  
ATOM   3198  CB  SER   141      26.419  41.854  18.955  1.00 41.98           C  
ATOM   3199  OG  SER   141      26.752  42.216  20.286  1.00 40.34           O  
ATOM   3200  N   SER   142      28.562  39.432  19.870  1.00 44.72           N  
ATOM   3201  CA  SER   142      29.935  38.936  19.901  1.00 45.42           C  
ATOM   3202  C   SER   142      30.054  37.783  20.879  1.00 46.27           C  
ATOM   3203  O   SER   142      29.196  37.599  21.746  1.00 46.65           O  
ATOM   3204  CB  SER   142      30.901  40.052  20.314  1.00 45.43           C  
ATOM   3205  OG  SER   142      30.653  40.444  21.650  1.00 45.87           O  
ATOM   3206  N   THR   143      31.136  37.025  20.748  1.00 47.10           N  
ATOM   3207  CA  THR   143      31.437  35.889  21.615  1.00 48.29           C  
ATOM   3208  C   THR   143      31.560  36.319  23.081  1.00 48.54           C  
ATOM   3209  O   THR   143      31.147  35.598  23.985  1.00 49.12           O  
ATOM   3210  CB  THR   143      32.753  35.157  21.154  1.00 48.60           C  
ATOM   3211  OG1 THR   143      33.169  35.653  19.875  1.00 49.54           O  
ATOM   3212  CG2 THR   143      32.539  33.671  21.034  1.00 48.89           C  
ATOM   3213  N   GLU   144      32.126  37.500  23.305  1.00 48.74           N  
ATOM   3214  CA  GLU   144      32.330  38.024  24.639  1.00 49.41           C  
ATOM   3215  C   GLU   144      30.985  38.447  25.269  1.00 48.55           C  
ATOM   3216  O   GLU   144      30.773  38.257  26.469  1.00 48.25           O  
ATOM   3217  CB  GLU   144      33.295  39.216  24.587  1.00 50.84           C  
ATOM   3218  CG  GLU   144      34.691  38.897  23.945  1.00 54.06           C  
ATOM   3219  CD  GLU   144      34.634  38.624  22.425  1.00 58.94           C  
ATOM   3220  OE1 GLU   144      34.157  39.500  21.669  1.00 60.91           O  
ATOM   3221  OE2 GLU   144      35.069  37.524  21.983  1.00 61.96           O  
ATOM   3222  N   ASP   145      30.092  39.023  24.465  1.00 46.93           N  
ATOM   3223  CA  ASP   145      28.736  39.330  24.942  1.00 46.62           C  
ATOM   3224  C   ASP   145      27.937  38.043  25.210  1.00 45.80           C  
ATOM   3225  O   ASP   145      27.206  37.957  26.203  1.00 45.64           O  
ATOM   3226  CB  ASP   145      27.989  40.240  23.957  1.00 46.37           C  
ATOM   3227  CG  ASP   145      28.546  41.679  23.923  1.00 47.65           C  
ATOM   3228  OD1 ASP   145      28.624  42.323  25.002  1.00 45.69           O  
ATOM   3229  OD2 ASP   145      28.876  42.171  22.810  1.00 47.44           O  
ATOM   3230  N   ALA   146      28.083  37.045  24.330  1.00 45.05           N  
ATOM   3231  CA  ALA   146      27.444  35.735  24.534  1.00 44.53           C  
ATOM   3232  C   ALA   146      27.959  35.024  25.788  1.00 44.25           C  
ATOM   3233  O   ALA   146      27.155  34.432  26.515  1.00 44.47           O  
ATOM   3234  CB  ALA   146      27.584  34.829  23.296  1.00 44.62           C  
ATOM   3235  N   ALA   147      29.276  35.071  26.036  1.00 42.86           N  
ATOM   3236  CA  ALA   147      29.849  34.494  27.255  1.00 42.59           C  
ATOM   3237  C   ALA   147      29.307  35.160  28.517  1.00 42.63           C  
ATOM   3238  O   ALA   147      29.002  34.489  29.509  1.00 42.53           O  
ATOM   3239  CB  ALA   147      31.404  34.557  27.237  1.00 43.24           C  
ATOM   3240  N   PHE   148      29.193  36.478  28.470  1.00 42.52           N  
ATOM   3241  CA  PHE   148      28.567  37.257  29.530  1.00 43.18           C  
ATOM   3242  C   PHE   148      27.106  36.861  29.811  1.00 42.71           C  
ATOM   3243  O   PHE   148      26.742  36.621  30.964  1.00 43.26           O  
ATOM   3244  CB  PHE   148      28.635  38.739  29.168  1.00 43.70           C  
ATOM   3245  CG  PHE   148      28.093  39.634  30.220  1.00 45.02           C  
ATOM   3246  CD1 PHE   148      28.780  39.811  31.419  1.00 48.91           C  
ATOM   3247  CD2 PHE   148      26.913  40.320  30.021  1.00 45.47           C  
ATOM   3248  CE1 PHE   148      28.273  40.652  32.420  1.00 47.63           C  
ATOM   3249  CE2 PHE   148      26.407  41.160  31.012  1.00 46.46           C  
ATOM   3250  CZ  PHE   148      27.101  41.314  32.216  1.00 46.60           C  
ATOM   3251  N   LEU   149      26.266  36.826  28.773  1.00 42.09           N  
ATOM   3252  CA  LEU   149      24.853  36.370  28.921  1.00 41.66           C  
ATOM   3253  C   LEU   149      24.745  34.929  29.444  1.00 41.78           C  
ATOM   3254  O   LEU   149      23.976  34.650  30.350  1.00 41.62           O  
ATOM   3255  CB  LEU   149      24.069  36.524  27.608  1.00 41.03           C  
ATOM   3256  CG  LEU   149      23.786  37.931  27.069  1.00 41.36           C  
ATOM   3257  CD1 LEU   149      23.169  37.899  25.673  1.00 38.88           C  
ATOM   3258  CD2 LEU   149      22.904  38.765  28.041  1.00 40.39           C  
ATOM   3259  N   LYS   150      25.536  34.021  28.885  1.00 42.10           N  
ATOM   3260  CA  LYS   150      25.537  32.636  29.348  1.00 43.32           C  
ATOM   3261  C   LYS   150      25.947  32.474  30.811  1.00 42.74           C  
ATOM   3262  O   LYS   150      25.420  31.621  31.525  1.00 42.71           O  
ATOM   3263  CB  LYS   150      26.434  31.780  28.458  1.00 43.35           C  
ATOM   3264  CG  LYS   150      25.825  31.549  27.089  1.00 46.98           C  
ATOM   3265  CD  LYS   150      26.886  31.060  26.082  1.00 50.50           C  
ATOM   3266  CE  LYS   150      27.367  29.684  26.422  1.00 52.40           C  
ATOM   3267  NZ  LYS   150      28.480  29.314  25.506  1.00 56.38           N  
ATOM   3268  N   ALA   151      26.883  33.299  31.245  1.00 42.76           N  
ATOM   3269  CA  ALA   151      27.334  33.267  32.611  1.00 43.09           C  
ATOM   3270  C   ALA   151      26.205  33.707  33.529  1.00 43.28           C  
ATOM   3271  O   ALA   151      25.983  33.088  34.578  1.00 43.70           O  
ATOM   3272  CB  ALA   151      28.573  34.141  32.791  1.00 42.67           C  
ATOM   3273  N   ILE   152      25.476  34.752  33.128  1.00 43.11           N  
ATOM   3274  CA  ILE   152      24.293  35.190  33.876  1.00 42.12           C  
ATOM   3275  C   ILE   152      23.256  34.079  33.877  1.00 41.94           C  
ATOM   3276  O   ILE   152      22.782  33.700  34.944  1.00 41.48           O  
ATOM   3277  CB  ILE   152      23.656  36.480  33.310  1.00 42.43           C  
ATOM   3278  CG1 ILE   152      24.615  37.664  33.483  1.00 43.84           C  
ATOM   3279  CG2 ILE   152      22.314  36.768  34.008  1.00 41.66           C  
ATOM   3280  CD1 ILE   152      24.127  38.948  32.803  1.00 42.18           C  
ATOM   3281  N   ALA   153      22.908  33.566  32.691  1.00 41.03           N  
ATOM   3282  CA  ALA   153      21.880  32.509  32.579  1.00 41.40           C  
ATOM   3283  C   ALA   153      22.240  31.217  33.344  1.00 41.00           C  
ATOM   3284  O   ALA   153      21.357  30.588  33.922  1.00 40.62           O  
ATOM   3285  CB  ALA   153      21.518  32.210  31.115  1.00 40.63           C  
ATOM   3286  N   SER   154      23.528  30.862  33.382  1.00 41.04           N  
ATOM   3287  CA  SER   154      24.008  29.670  34.123  1.00 41.86           C  
ATOM   3288  C   SER   154      23.857  29.739  35.646  1.00 41.77           C  
ATOM   3289  O   SER   154      23.843  28.700  36.304  1.00 41.91           O  
ATOM   3290  CB  SER   154      25.467  29.358  33.776  1.00 42.16           C  
ATOM   3291  OG  SER   154      25.580  29.047  32.393  1.00 44.01           O  
ATOM   3292  N   THR   155      23.761  30.947  36.210  1.00 41.64           N  
ATOM   3293  CA  THR   155      23.505  31.081  37.643  1.00 41.69           C  
ATOM   3294  C   THR   155      22.047  30.676  37.918  1.00 41.64           C  
ATOM   3295  O   THR   155      21.687  30.354  39.042  1.00 41.77           O  
ATOM   3296  CB  THR   155      23.803  32.504  38.198  1.00 41.44           C  
ATOM   3297  OG1 THR   155      22.865  33.443  37.675  1.00 41.92           O  
ATOM   3298  CG2 THR   155      25.200  32.976  37.820  1.00 42.45           C  
ATOM   3299  N   LEU   156      21.223  30.662  36.876  1.00 41.17           N  
ATOM   3300  CA  LEU   156      19.786  30.418  37.053  1.00 41.24           C  
ATOM   3301  C   LEU   156      19.349  29.019  36.630  1.00 41.20           C  
ATOM   3302  O   LEU   156      18.555  28.382  37.327  1.00 41.52           O  
ATOM   3303  CB  LEU   156      18.950  31.461  36.301  1.00 40.28           C  
ATOM   3304  CG  LEU   156      19.200  32.962  36.491  1.00 41.31           C  
ATOM   3305  CD1 LEU   156      18.288  33.763  35.563  1.00 37.98           C  
ATOM   3306  CD2 LEU   156      19.049  33.440  37.953  1.00 38.54           C  
ATOM   3307  N   SER   157      19.849  28.587  35.471  1.00 40.80           N  
ATOM   3308  CA  SER   157      19.450  27.370  34.808  1.00 40.57           C  
ATOM   3309  C   SER   157      20.654  26.438  34.567  1.00 40.99           C  
ATOM   3310  O   SER   157      21.766  26.897  34.254  1.00 39.96           O  
ATOM   3311  CB  SER   157      18.823  27.727  33.460  1.00 41.31           C  
ATOM   3312  OG  SER   157      18.616  26.567  32.651  1.00 41.36           O  
ATOM   3313  N   ASN   158      20.421  25.136  34.693  1.00 40.67           N  
ATOM   3314  CA  ASN   158      21.402  24.126  34.264  1.00 41.31           C  
ATOM   3315  C   ASN   158      21.294  23.761  32.787  1.00 41.16           C  
ATOM   3316  O   ASN   158      21.995  22.859  32.336  1.00 41.48           O  
ATOM   3317  CB  ASN   158      21.205  22.835  35.054  1.00 41.68           C  
ATOM   3318  CG  ASN   158      21.430  23.017  36.534  1.00 43.24           C  
ATOM   3319  OD1 ASN   158      22.319  23.755  36.953  1.00 43.70           O  
ATOM   3320  ND2 ASN   158      20.627  22.322  37.342  1.00 45.57           N  
ATOM   3321  N   ARG   159      20.388  24.429  32.064  1.00 40.82           N  
ATOM   3322  CA  ARG   159      20.146  24.133  30.650  0.50 41.12           C  
ATOM   3324  C   ARG   159      20.314  25.374  29.785  1.00 40.55           C  
ATOM   3325  O   ARG   159      19.356  25.897  29.223  1.00 41.29           O  
ATOM   3326  CB  ARG   159      18.759  23.504  30.442  0.50 40.81           C  
ATOM   3328  CG  ARG   159      18.717  21.981  30.616  0.50 41.49           C  
ATOM   3330  CD  ARG   159      17.380  21.408  30.119  0.50 42.10           C  
ATOM   3332  NE  ARG   159      17.435  19.972  29.833  0.50 43.37           N  
ATOM   3334  CZ  ARG   159      17.436  19.435  28.613  0.50 44.55           C  
ATOM   3336  NH1 ARG   159      17.377  20.201  27.528  0.50 43.90           N  
ATOM   3338  NH2 ARG   159      17.493  18.116  28.476  0.50 46.57           N  
ATOM   3340  N   VAL   160      21.544  25.829  29.666  1.00 40.41           N  
ATOM   3341  CA  VAL   160      21.864  27.077  28.954  1.00 40.27           C  
ATOM   3342  C   VAL   160      22.481  26.725  27.602  1.00 40.46           C  
ATOM   3343  O   VAL   160      23.474  26.007  27.551  1.00 40.08           O  
ATOM   3344  CB  VAL   160      22.830  27.943  29.831  1.00 40.92           C  
ATOM   3345  CG1 VAL   160      23.366  29.235  29.089  1.00 39.99           C  
ATOM   3346  CG2 VAL   160      22.115  28.305  31.120  1.00 38.61           C  
ATOM   3347  N   TYR   161      21.878  27.193  26.515  1.00 40.13           N  
ATOM   3348  CA  TYR   161      22.295  26.761  25.182  1.00 40.57           C  
ATOM   3349  C   TYR   161      22.537  27.951  24.283  1.00 41.12           C  
ATOM   3350  O   TYR   161      21.835  28.958  24.389  1.00 40.92           O  
ATOM   3351  CB  TYR   161      21.230  25.879  24.530  1.00 40.67           C  
ATOM   3352  CG  TYR   161      20.835  24.675  25.350  1.00 41.24           C  
ATOM   3353  CD1 TYR   161      21.745  23.662  25.611  1.00 41.24           C  
ATOM   3354  CD2 TYR   161      19.545  24.562  25.879  1.00 42.21           C  
ATOM   3355  CE1 TYR   161      21.389  22.565  26.363  1.00 41.64           C  
ATOM   3356  CE2 TYR   161      19.173  23.455  26.637  1.00 41.58           C  
ATOM   3357  CZ  TYR   161      20.102  22.466  26.869  1.00 41.45           C  
ATOM   3358  OH  TYR   161      19.752  21.363  27.600  1.00 41.32           O  
ATOM   3359  N   ASP   162      23.548  27.841  23.422  1.00 40.31           N  
ATOM   3360  CA  ASP   162      23.743  28.791  22.336  1.00 40.03           C  
ATOM   3361  C   ASP   162      22.797  28.361  21.238  1.00 39.80           C  
ATOM   3362  O   ASP   162      22.805  27.194  20.808  1.00 39.06           O  
ATOM   3363  CB  ASP   162      25.159  28.678  21.774  1.00 40.49           C  
ATOM   3364  CG  ASP   162      26.224  29.136  22.746  1.00 40.73           C  
ATOM   3365  OD1 ASP   162      26.370  30.351  22.914  1.00 44.25           O  
ATOM   3366  OD2 ASP   162      26.935  28.282  23.328  1.00 44.15           O  
ATOM   3367  N   ALA   163      21.983  29.290  20.759  1.00 39.43           N  
ATOM   3368  CA  ALA   163      21.133  28.973  19.601  1.00 39.18           C  
ATOM   3369  C   ALA   163      20.957  30.201  18.710  1.00 39.10           C  
ATOM   3370  O   ALA   163      20.928  31.334  19.219  1.00 39.80           O  
ATOM   3371  CB  ALA   163      19.773  28.402  20.068  1.00 37.74           C  
ATOM   3372  N   ASP   164      20.886  30.002  17.399  1.00 38.93           N  
ATOM   3373  CA  ASP   164      20.642  31.057  16.401  0.50 39.79           C  
ATOM   3375  C   ASP   164      19.179  31.482  16.363  1.00 40.10           C  
ATOM   3376  O   ASP   164      18.316  30.782  16.917  1.00 40.06           O  
ATOM   3377  CB  ASP   164      20.997  30.537  15.011  0.50 39.75           C  
ATOM   3379  CG  ASP   164      22.471  30.601  14.728  0.50 40.68           C  
ATOM   3381  OD1 ASP   164      23.222  31.139  15.580  0.50 42.32           O  
ATOM   3383  OD2 ASP   164      22.878  30.124  13.646  0.50 40.31           O  
ATOM   3385  N   SER   165      18.881  32.573  15.656  1.00 40.17           N  
ATOM   3386  CA  SER   165      17.508  33.061  15.589  1.00 41.29           C  
ATOM   3387  C   SER   165      16.614  32.036  14.885  1.00 41.96           C  
ATOM   3388  O   SER   165      15.426  31.892  15.212  1.00 41.57           O  
ATOM   3389  CB  SER   165      17.443  34.433  14.914  1.00 41.39           C  
ATOM   3390  OG  SER   165      17.741  35.473  15.845  1.00 42.04           O  
ATOM   3391  N   GLU   166      17.234  31.315  13.943  1.00 41.91           N  
ATOM   3392  CA  GLU   166      16.587  30.302  13.124  1.00 42.23           C  
ATOM   3393  C   GLU   166      16.236  29.077  13.964  1.00 40.78           C  
ATOM   3394  O   GLU   166      15.092  28.651  13.979  1.00 40.98           O  
ATOM   3395  CB  GLU   166      17.478  29.950  11.911  1.00 41.60           C  
ATOM   3396  CG  GLU   166      16.955  28.800  11.045  1.00 43.76           C  
ATOM   3397  CD  GLU   166      17.620  28.725   9.663  1.00 45.10           C  
ATOM   3398  OE1 GLU   166      18.741  29.274   9.482  1.00 49.49           O  
ATOM   3399  OE2 GLU   166      17.021  28.104   8.747  1.00 49.25           O  
ATOM   3400  N   GLN   167      17.201  28.520  14.684  1.00 40.46           N  
ATOM   3401  CA  GLN   167      16.887  27.455  15.641  1.00 39.55           C  
ATOM   3402  C   GLN   167      15.816  27.907  16.637  1.00 39.76           C  
ATOM   3403  O   GLN   167      14.951  27.122  17.007  1.00 40.85           O  
ATOM   3404  CB  GLN   167      18.125  27.015  16.423  1.00 39.73           C  
ATOM   3405  CG  GLN   167      19.229  26.242  15.668  1.00 39.93           C  
ATOM   3406  CD  GLN   167      20.523  26.161  16.496  1.00 39.28           C  
ATOM   3407  OE1 GLN   167      20.940  27.155  17.093  1.00 38.35           O  
ATOM   3408  NE2 GLN   167      21.137  24.978  16.553  1.00 35.06           N  
ATOM   3409  N   ARG   168      15.877  29.156  17.086  1.00 39.14           N  
ATOM   3410  CA  ARG   168      15.015  29.614  18.190  1.00 39.39           C  
ATOM   3411  C   ARG   168      13.547  29.764  17.718  1.00 39.16           C  
ATOM   3412  O   ARG   168      12.607  29.432  18.432  1.00 38.04           O  
ATOM   3413  CB  ARG   168      15.563  30.909  18.811  1.00 38.40           C  
ATOM   3414  CG  ARG   168      14.762  31.428  20.012  1.00 40.96           C  
ATOM   3415  CD  ARG   168      15.310  32.732  20.594  1.00 40.36           C  
ATOM   3416  NE  ARG   168      15.252  33.866  19.663  1.00 41.23           N  
ATOM   3417  CZ  ARG   168      16.305  34.353  19.012  1.00 42.01           C  
ATOM   3418  NH1 ARG   168      17.508  33.817  19.197  1.00 41.36           N  
ATOM   3419  NH2 ARG   168      16.155  35.389  18.188  1.00 42.75           N  
ATOM   3420  N   LYS   169      13.365  30.252  16.500  1.00 39.62           N  
ATOM   3421  CA  LYS   169      12.037  30.273  15.907  1.00 40.41           C  
ATOM   3422  C   LYS   169      11.434  28.875  15.856  1.00 39.66           C  
ATOM   3423  O   LYS   169      10.281  28.689  16.221  1.00 39.87           O  
ATOM   3424  CB  LYS   169      12.050  30.886  14.506  1.00 40.61           C  
ATOM   3425  CG  LYS   169      11.340  32.207  14.432  1.00 43.40           C  
ATOM   3426  CD  LYS   169      10.548  32.380  13.112  1.00 46.39           C  
ATOM   3427  CE  LYS   169      11.472  32.365  11.889  1.00 44.99           C  
ATOM   3428  NZ  LYS   169      10.682  32.379  10.610  1.00 47.60           N  
ATOM   3429  N   SER   170      12.232  27.913  15.398  1.00 39.20           N  
ATOM   3430  CA  SER   170      11.850  26.508  15.328  1.00 38.67           C  
ATOM   3431  C   SER   170      11.389  25.958  16.682  1.00 38.24           C  
ATOM   3432  O   SER   170      10.364  25.288  16.772  1.00 39.00           O  
ATOM   3433  CB  SER   170      13.035  25.695  14.822  1.00 38.26           C  
ATOM   3434  OG  SER   170      13.185  25.865  13.416  1.00 39.88           O  
ATOM   3435  N   LEU   171      12.159  26.235  17.728  1.00 38.09           N  
ATOM   3436  CA  LEU   171      11.836  25.765  19.064  1.00 38.36           C  
ATOM   3437  C   LEU   171      10.541  26.421  19.528  1.00 37.99           C  
ATOM   3438  O   LEU   171       9.675  25.763  20.087  1.00 38.73           O  
ATOM   3439  CB  LEU   171      12.972  26.093  20.025  1.00 37.50           C  
ATOM   3440  CG  LEU   171      14.247  25.278  19.820  1.00 38.24           C  
ATOM   3441  CD1 LEU   171      15.417  25.992  20.506  1.00 36.19           C  
ATOM   3442  CD2 LEU   171      14.090  23.847  20.363  1.00 33.32           C  
ATOM   3443  N   HIS   172      10.417  27.720  19.287  1.00 37.18           N  
ATOM   3444  CA  HIS   172       9.231  28.447  19.695  1.00 36.69           C  
ATOM   3445  C   HIS   172       7.982  27.922  19.003  1.00 36.34           C  
ATOM   3446  O   HIS   172       6.930  27.799  19.628  1.00 36.97           O  
ATOM   3447  CB  HIS   172       9.403  29.973  19.492  1.00 36.50           C  
ATOM   3448  CG  HIS   172       8.260  30.785  20.035  1.00 35.97           C  
ATOM   3449  ND1 HIS   172       7.906  32.017  19.529  1.00 34.95           N  
ATOM   3450  CD2 HIS   172       7.371  30.522  21.023  1.00 36.67           C  
ATOM   3451  CE1 HIS   172       6.864  32.486  20.187  1.00 34.59           C  
ATOM   3452  NE2 HIS   172       6.516  31.599  21.102  1.00 36.73           N  
ATOM   3453  N   LEU   173       8.082  27.588  17.724  1.00 35.55           N  
ATOM   3454  CA  LEU   173       6.920  27.024  17.030  1.00 34.54           C  
ATOM   3455  C   LEU   173       6.470  25.725  17.678  1.00 34.82           C  
ATOM   3456  O   LEU   173       5.281  25.528  17.949  1.00 35.18           O  
ATOM   3457  CB  LEU   173       7.190  26.819  15.530  1.00 34.84           C  
ATOM   3458  CG  LEU   173       6.146  26.018  14.726  1.00 34.57           C  
ATOM   3459  CD1 LEU   173       4.827  26.779  14.521  1.00 34.46           C  
ATOM   3460  CD2 LEU   173       6.709  25.592  13.382  1.00 33.65           C  
ATOM   3461  N   ALA   174       7.426  24.838  17.937  1.00 34.33           N  
ATOM   3462  CA  ALA   174       7.134  23.588  18.638  1.00 33.48           C  
ATOM   3463  C   ALA   174       6.563  23.828  20.051  1.00 32.32           C  
ATOM   3464  O   ALA   174       5.700  23.094  20.518  1.00 32.42           O  
ATOM   3465  CB  ALA   174       8.402  22.717  18.682  1.00 33.08           C  
ATOM   3466  N   ALA   175       7.046  24.869  20.721  1.00 32.31           N  
ATOM   3467  CA  ALA   175       6.593  25.229  22.082  1.00 31.15           C  
ATOM   3468  C   ALA   175       5.177  25.751  22.051  1.00 30.67           C  
ATOM   3469  O   ALA   175       4.472  25.673  23.044  1.00 29.78           O  
ATOM   3470  CB  ALA   175       7.530  26.302  22.705  1.00 30.18           C  
ATOM   3471  N   VAL   176       4.760  26.358  20.942  1.00 30.78           N  
ATOM   3472  CA  VAL   176       3.372  26.830  20.916  1.00 31.49           C  
ATOM   3473  C   VAL   176       2.421  25.620  20.959  1.00 31.85           C  
ATOM   3474  O   VAL   176       1.424  25.625  21.716  1.00 32.35           O  
ATOM   3475  CB  VAL   176       3.055  27.786  19.720  1.00 31.96           C  
ATOM   3476  CG1 VAL   176       1.538  28.023  19.614  1.00 32.87           C  
ATOM   3477  CG2 VAL   176       3.795  29.102  19.847  1.00 29.41           C  
ATOM   3478  N   PHE   177       2.721  24.585  20.163  1.00 32.01           N  
ATOM   3479  CA  PHE   177       1.980  23.306  20.270  1.00 32.76           C  
ATOM   3480  C   PHE   177       2.094  22.727  21.652  1.00 33.49           C  
ATOM   3481  O   PHE   177       1.106  22.365  22.301  1.00 33.59           O  
ATOM   3482  CB  PHE   177       2.513  22.279  19.254  1.00 32.53           C  
ATOM   3483  CG  PHE   177       2.076  22.552  17.848  1.00 31.75           C  
ATOM   3484  CD1 PHE   177       0.870  22.041  17.378  1.00 30.98           C  
ATOM   3485  CD2 PHE   177       2.837  23.367  17.014  1.00 29.59           C  
ATOM   3486  CE1 PHE   177       0.446  22.309  16.065  1.00 29.84           C  
ATOM   3487  CE2 PHE   177       2.420  23.638  15.700  1.00 31.89           C  
ATOM   3488  CZ  PHE   177       1.216  23.107  15.235  1.00 29.37           C  
ATOM   3489  N   THR   178       3.332  22.614  22.105  1.00 35.06           N  
ATOM   3490  CA  THR   178       3.591  21.917  23.355  1.00 36.03           C  
ATOM   3491  C   THR   178       2.915  22.557  24.549  1.00 36.40           C  
ATOM   3492  O   THR   178       2.431  21.838  25.429  1.00 37.51           O  
ATOM   3493  CB  THR   178       5.089  21.772  23.624  1.00 35.31           C  
ATOM   3494  OG1 THR   178       5.642  20.952  22.590  1.00 36.95           O  
ATOM   3495  CG2 THR   178       5.306  21.090  24.957  1.00 35.07           C  
ATOM   3496  N   CYS   179       2.917  23.886  24.608  1.00 36.81           N  
ATOM   3497  CA  CYS   179       2.445  24.596  25.812  1.00 38.46           C  
ATOM   3498  C   CYS   179       1.111  25.293  25.613  1.00 37.91           C  
ATOM   3499  O   CYS   179       0.198  25.177  26.442  1.00 38.79           O  
ATOM   3500  CB  CYS   179       3.425  25.704  26.208  1.00 39.37           C  
ATOM   3501  SG  CYS   179       5.092  25.214  26.727  1.00 46.23           S  
ATOM   3502  N   ASN   180       1.039  26.113  24.565  1.00 36.96           N  
ATOM   3503  CA  ASN   180      -0.104  26.999  24.371  1.00 35.53           C  
ATOM   3504  C   ASN   180      -1.336  26.204  23.989  1.00 34.98           C  
ATOM   3505  O   ASN   180      -2.393  26.383  24.600  1.00 35.16           O  
ATOM   3506  CB  ASN   180       0.190  28.032  23.275  1.00 36.21           C  
ATOM   3507  CG  ASN   180       1.294  29.005  23.652  1.00 34.76           C  
ATOM   3508  OD1 ASN   180       1.804  29.719  22.792  1.00 35.37           O  
ATOM   3509  ND2 ASN   180       1.670  29.038  24.934  1.00 34.20           N  
ATOM   3510  N   PHE   181      -1.203  25.346  22.969  1.00 33.32           N  
ATOM   3511  CA  PHE   181      -2.338  24.559  22.465  1.00 32.78           C  
ATOM   3512  C   PHE   181      -2.750  23.466  23.471  1.00 33.18           C  
ATOM   3513  O   PHE   181      -3.915  23.112  23.580  1.00 32.46           O  
ATOM   3514  CB  PHE   181      -2.041  23.938  21.097  1.00 30.42           C  
ATOM   3515  CG  PHE   181      -1.799  24.957  19.997  1.00 31.17           C  
ATOM   3516  CD1 PHE   181      -2.128  26.298  20.178  1.00 27.75           C  
ATOM   3517  CD2 PHE   181      -1.268  24.562  18.770  1.00 28.79           C  
ATOM   3518  CE1 PHE   181      -1.914  27.228  19.156  1.00 29.46           C  
ATOM   3519  CE2 PHE   181      -1.062  25.485  17.735  1.00 30.82           C  
ATOM   3520  CZ  PHE   181      -1.387  26.821  17.932  1.00 29.47           C  
ATOM   3521  N   THR   182      -1.765  22.916  24.169  1.00 34.56           N  
ATOM   3522  CA  THR   182      -2.015  21.934  25.210  1.00 35.83           C  
ATOM   3523  C   THR   182      -2.842  22.542  26.332  1.00 36.49           C  
ATOM   3524  O   THR   182      -3.859  21.976  26.736  1.00 37.80           O  
ATOM   3525  CB  THR   182      -0.700  21.384  25.763  1.00 36.19           C  
ATOM   3526  OG1 THR   182      -0.116  20.489  24.792  1.00 37.08           O  
ATOM   3527  CG2 THR   182      -0.978  20.589  27.075  1.00 36.59           C  
ATOM   3528  N   ASN   183      -2.429  23.701  26.836  1.00 37.35           N  
ATOM   3529  CA  ASN   183      -3.206  24.359  27.894  1.00 37.98           C  
ATOM   3530  C   ASN   183      -4.611  24.685  27.391  1.00 38.08           C  
ATOM   3531  O   ASN   183      -5.576  24.564  28.143  1.00 38.03           O  
ATOM   3532  CB  ASN   183      -2.509  25.635  28.415  1.00 37.52           C  
ATOM   3533  CG  ASN   183      -3.260  26.259  29.566  1.00 38.37           C  
ATOM   3534  OD1 ASN   183      -3.121  25.838  30.725  1.00 38.92           O  
ATOM   3535  ND2 ASN   183      -4.094  27.242  29.256  1.00 34.78           N  
ATOM   3536  N   HIS   184      -4.734  25.070  26.116  1.00 38.87           N  
ATOM   3537  CA  HIS   184      -6.069  25.333  25.537  1.00 38.98           C  
ATOM   3538  C   HIS   184      -6.952  24.089  25.579  1.00 39.39           C  
ATOM   3539  O   HIS   184      -8.137  24.202  25.839  1.00 40.05           O  
ATOM   3540  CB  HIS   184      -5.999  25.892  24.110  1.00 39.01           C  
ATOM   3541  CG  HIS   184      -7.329  26.342  23.572  1.00 38.81           C  
ATOM   3542  ND1 HIS   184      -8.085  27.326  24.175  1.00 38.68           N  
ATOM   3543  CD2 HIS   184      -8.041  25.933  22.495  1.00 37.69           C  
ATOM   3544  CE1 HIS   184      -9.203  27.507  23.489  1.00 37.46           C  
ATOM   3545  NE2 HIS   184      -9.200  26.672  22.467  1.00 37.67           N  
ATOM   3546  N   MET   185      -6.379  22.900  25.364  1.00 39.50           N  
ATOM   3547  CA  MET   185      -7.156  21.650  25.507  1.00 39.21           C  
ATOM   3548  C   MET   185      -7.713  21.481  26.914  1.00 39.56           C  
ATOM   3549  O   MET   185      -8.852  21.000  27.098  1.00 40.28           O  
ATOM   3550  CB  MET   185      -6.320  20.410  25.124  1.00 39.15           C  
ATOM   3551  CG  MET   185      -5.744  20.412  23.714  1.00 37.86           C  
ATOM   3552  SD  MET   185      -7.152  20.502  22.397  0.50 31.80          SE  
ATOM   3553  CE  MET   185      -7.221  22.351  21.980  1.00 35.31           C  
ATOM   3554  N   TYR   186      -6.906  21.851  27.905  1.00 39.59           N  
ATOM   3555  CA  TYR   186      -7.334  21.880  29.310  1.00 39.58           C  
ATOM   3556  C   TYR   186      -8.457  22.870  29.502  1.00 40.11           C  
ATOM   3557  O   TYR   186      -9.384  22.605  30.271  1.00 40.58           O  
ATOM   3558  CB  TYR   186      -6.201  22.302  30.273  1.00 39.13           C  
ATOM   3559  CG  TYR   186      -4.916  21.485  30.241  1.00 38.07           C  
ATOM   3560  CD1 TYR   186      -4.874  20.188  29.723  1.00 38.11           C  
ATOM   3561  CD2 TYR   186      -3.749  22.025  30.770  1.00 38.85           C  
ATOM   3562  CE1 TYR   186      -3.684  19.475  29.695  1.00 38.24           C  
ATOM   3563  CE2 TYR   186      -2.568  21.329  30.780  1.00 40.01           C  
ATOM   3564  CZ  TYR   186      -2.524  20.060  30.233  1.00 39.60           C  
ATOM   3565  OH  TYR   186      -1.303  19.404  30.256  1.00 39.66           O  
ATOM   3566  N   ALA   187      -8.350  24.028  28.838  1.00 40.87           N  
ATOM   3567  CA  ALA   187      -9.347  25.112  28.958  1.00 40.88           C  
ATOM   3568  C   ALA   187     -10.717  24.729  28.401  1.00 41.52           C  
ATOM   3569  O   ALA   187     -11.739  25.073  28.991  1.00 41.97           O  
ATOM   3570  CB  ALA   187      -8.847  26.380  28.305  1.00 40.53           C  
ATOM   3571  N   LEU   188     -10.719  24.050  27.252  1.00 41.53           N  
ATOM   3572  CA  LEU   188     -11.928  23.536  26.622  1.00 41.69           C  
ATOM   3573  C   LEU   188     -12.575  22.454  27.479  1.00 42.24           C  
ATOM   3574  O   LEU   188     -13.773  22.509  27.711  1.00 42.75           O  
ATOM   3575  CB  LEU   188     -11.631  22.987  25.231  1.00 41.00           C  
ATOM   3576  CG  LEU   188     -11.198  24.015  24.181  1.00 40.49           C  
ATOM   3577  CD1 LEU   188     -10.894  23.306  22.881  1.00 39.18           C  
ATOM   3578  CD2 LEU   188     -12.274  25.084  23.998  1.00 41.11           C  
ATOM   3579  N   ALA   189     -11.786  21.484  27.941  1.00 42.37           N  
ATOM   3580  CA  ALA   189     -12.279  20.484  28.882  1.00 43.25           C  
ATOM   3581  C   ALA   189     -12.949  21.184  30.064  1.00 43.92           C  
ATOM   3582  O   ALA   189     -14.067  20.816  30.417  1.00 45.18           O  
ATOM   3583  CB  ALA   189     -11.166  19.566  29.351  1.00 42.56           C  
ATOM   3584  N   ALA   190     -12.294  22.198  30.649  1.00 43.79           N  
ATOM   3585  CA  ALA   190     -12.885  22.976  31.745  1.00 44.57           C  
ATOM   3586  C   ALA   190     -14.212  23.641  31.379  1.00 44.99           C  
ATOM   3587  O   ALA   190     -15.136  23.648  32.191  1.00 44.87           O  
ATOM   3588  CB  ALA   190     -11.903  24.041  32.289  1.00 43.61           C  
ATOM   3589  N   GLU   191     -14.279  24.233  30.183  1.00 45.47           N  
ATOM   3590  CA  GLU   191     -15.504  24.876  29.692  1.00 46.12           C  
ATOM   3591  C   GLU   191     -16.639  23.878  29.642  1.00 45.92           C  
ATOM   3592  O   GLU   191     -17.771  24.186  30.032  1.00 45.77           O  
ATOM   3593  CB  GLU   191     -15.305  25.489  28.297  1.00 46.03           C  
ATOM   3594  CG  GLU   191     -14.561  26.823  28.303  1.00 46.81           C  
ATOM   3595  CD  GLU   191     -14.425  27.431  26.906  1.00 47.53           C  
ATOM   3596  OE1 GLU   191     -13.450  28.199  26.671  1.00 49.76           O  
ATOM   3597  OE2 GLU   191     -15.293  27.147  26.046  1.00 49.47           O  
ATOM   3598  N   LEU   192     -16.308  22.689  29.145  1.00 46.20           N  
ATOM   3599  CA  LEU   192     -17.259  21.594  29.002  0.50 46.08           C  
ATOM   3601  C   LEU   192     -17.738  21.093  30.362  1.00 46.36           C  
ATOM   3602  O   LEU   192     -18.939  20.941  30.583  1.00 46.45           O  
ATOM   3603  CB  LEU   192     -16.626  20.455  28.200  0.50 45.89           C  
ATOM   3605  CG  LEU   192     -17.326  19.097  28.105  0.50 45.41           C  
ATOM   3607  CD1 LEU   192     -18.559  19.150  27.220  0.50 45.53           C  
ATOM   3609  CD2 LEU   192     -16.340  18.087  27.583  0.50 45.16           C  
ATOM   3611  N   LEU   193     -16.796  20.842  31.264  1.00 46.64           N  
ATOM   3612  CA  LEU   193     -17.126  20.359  32.599  1.00 47.01           C  
ATOM   3613  C   LEU   193     -18.021  21.352  33.355  1.00 47.59           C  
ATOM   3614  O   LEU   193     -18.945  20.934  34.053  1.00 47.76           O  
ATOM   3615  CB  LEU   193     -15.854  20.004  33.390  1.00 46.83           C  
ATOM   3616  CG  LEU   193     -15.061  18.761  32.938  1.00 46.20           C  
ATOM   3617  CD1 LEU   193     -13.636  18.757  33.469  1.00 44.43           C  
ATOM   3618  CD2 LEU   193     -15.762  17.457  33.299  1.00 45.95           C  
ATOM   3619  N   LYS   194     -17.765  22.651  33.181  1.00 47.63           N  
ATOM   3620  CA  LYS   194     -18.589  23.713  33.761  1.00 48.38           C  
ATOM   3621  C   LYS   194     -20.023  23.707  33.216  1.00 49.05           C  
ATOM   3622  O   LYS   194     -20.988  23.909  33.971  1.00 48.75           O  
ATOM   3623  CB  LYS   194     -17.945  25.089  33.523  1.00 48.99           C  
ATOM   3624  CG  LYS   194     -18.608  26.252  34.283  1.00 49.15           C  
ATOM   3625  CD  LYS   194     -17.873  27.575  34.029  1.00 48.91           C  
ATOM   3626  CE  LYS   194     -18.738  28.779  34.422  1.00 47.62           C  
ATOM   3627  NZ  LYS   194     -18.012  30.058  34.126  1.00 48.96           N  
ATOM   3628  N   LYS   195     -20.166  23.474  31.913  1.00 49.17           N  
ATOM   3629  CA  LYS   195     -21.488  23.371  31.306  1.00 49.85           C  
ATOM   3630  C   LYS   195     -22.305  22.228  31.941  1.00 49.39           C  
ATOM   3631  O   LYS   195     -23.542  22.257  31.936  1.00 49.67           O  
ATOM   3632  CB  LYS   195     -21.365  23.201  29.787  1.00 49.92           C  
ATOM   3633  CG  LYS   195     -22.693  22.925  29.057  1.00 51.09           C  
ATOM   3634  CD  LYS   195     -22.498  22.943  27.538  1.00 51.51           C  
ATOM   3635  CE  LYS   195     -23.635  22.187  26.837  1.00 54.48           C  
ATOM   3636  NZ  LYS   195     -23.619  22.440  25.363  1.00 56.21           N  
ATOM   3637  N   TYR   196     -21.602  21.240  32.495  1.00 49.06           N  
ATOM   3638  CA  TYR   196     -22.218  20.087  33.173  1.00 48.20           C  
ATOM   3639  C   TYR   196     -21.974  20.095  34.678  1.00 47.97           C  
ATOM   3640  O   TYR   196     -21.955  19.039  35.313  1.00 48.10           O  
ATOM   3641  CB  TYR   196     -21.688  18.788  32.578  1.00 48.58           C  
ATOM   3642  CG  TYR   196     -22.226  18.525  31.208  1.00 48.11           C  
ATOM   3643  CD1 TYR   196     -23.434  17.845  31.039  1.00 48.06           C  
ATOM   3644  CD2 TYR   196     -21.551  18.972  30.084  1.00 46.60           C  
ATOM   3645  CE1 TYR   196     -23.952  17.610  29.777  1.00 48.36           C  
ATOM   3646  CE2 TYR   196     -22.056  18.739  28.812  1.00 47.63           C  
ATOM   3647  CZ  TYR   196     -23.263  18.065  28.665  1.00 48.79           C  
ATOM   3648  OH  TYR   196     -23.774  17.823  27.406  1.00 50.13           O  
ATOM   3649  N   ASN   197     -21.776  21.286  35.240  1.00 47.65           N  
ATOM   3650  CA  ASN   197     -21.661  21.468  36.696  1.00 47.77           C  
ATOM   3651  C   ASN   197     -20.696  20.486  37.353  1.00 47.37           C  
ATOM   3652  O   ASN   197     -21.007  19.852  38.360  1.00 46.58           O  
ATOM   3653  CB  ASN   197     -23.050  21.421  37.367  1.00 47.81           C  
ATOM   3654  CG  ASN   197     -24.035  22.375  36.721  1.00 48.36           C  
ATOM   3655  OD1 ASN   197     -25.088  21.959  36.251  1.00 49.32           O  
ATOM   3656  ND2 ASN   197     -23.674  23.654  36.651  1.00 48.31           N  
ATOM   3657  N   LEU   198     -19.521  20.365  36.739  1.00 47.41           N  
ATOM   3658  CA  LEU   198     -18.438  19.538  37.249  1.00 46.62           C  
ATOM   3659  C   LEU   198     -17.177  20.383  37.255  1.00 46.68           C  
ATOM   3660  O   LEU   198     -16.979  21.203  36.342  1.00 45.56           O  
ATOM   3661  CB  LEU   198     -18.257  18.283  36.393  1.00 46.58           C  
ATOM   3662  CG  LEU   198     -19.316  17.186  36.535  1.00 46.09           C  
ATOM   3663  CD1 LEU   198     -19.156  16.146  35.436  1.00 45.18           C  
ATOM   3664  CD2 LEU   198     -19.271  16.538  37.912  1.00 45.93           C  
ATOM   3665  N   PRO   199     -16.344  20.222  38.305  1.00 46.92           N  
ATOM   3666  CA  PRO   199     -15.124  21.018  38.397  1.00 47.23           C  
ATOM   3667  C   PRO   199     -14.012  20.493  37.466  1.00 47.53           C  
ATOM   3668  O   PRO   199     -13.929  19.285  37.192  1.00 47.37           O  
ATOM   3669  CB  PRO   199     -14.723  20.894  39.863  1.00 47.24           C  
ATOM   3670  CG  PRO   199     -15.350  19.626  40.341  1.00 47.33           C  
ATOM   3671  CD  PRO   199     -16.506  19.300  39.446  1.00 46.73           C  
ATOM   3672  N   PHE   200     -13.171  21.413  37.000  1.00 47.12           N  
ATOM   3673  CA  PHE   200     -12.068  21.071  36.121  1.00 46.64           C  
ATOM   3674  C   PHE   200     -11.110  20.090  36.787  1.00 46.52           C  
ATOM   3675  O   PHE   200     -10.538  19.233  36.126  1.00 46.15           O  
ATOM   3676  CB  PHE   200     -11.320  22.333  35.686  1.00 46.19           C  
ATOM   3677  CG  PHE   200      -9.943  22.054  35.159  1.00 46.01           C  
ATOM   3678  CD1 PHE   200      -9.774  21.463  33.892  1.00 42.70           C  
ATOM   3679  CD2 PHE   200      -8.811  22.327  35.949  1.00 44.85           C  
ATOM   3680  CE1 PHE   200      -8.493  21.169  33.418  1.00 44.50           C  
ATOM   3681  CE2 PHE   200      -7.511  22.046  35.473  1.00 43.90           C  
ATOM   3682  CZ  PHE   200      -7.358  21.460  34.213  1.00 43.54           C  
ATOM   3683  N   ASP   201     -10.973  20.222  38.099  1.00 46.58           N  
ATOM   3684  CA  ASP   201     -10.004  19.484  38.912  1.00 47.27           C  
ATOM   3685  C   ASP   201     -10.006  17.966  38.748  1.00 46.52           C  
ATOM   3686  O   ASP   201      -8.988  17.325  39.017  1.00 46.46           O  
ATOM   3687  CB  ASP   201     -10.217  19.835  40.389  1.00 47.81           C  
ATOM   3688  CG  ASP   201     -10.126  21.331  40.646  1.00 51.95           C  
ATOM   3689  OD1 ASP   201      -8.983  21.863  40.703  1.00 55.97           O  
ATOM   3690  OD2 ASP   201     -11.200  21.977  40.779  1.00 54.90           O  
ATOM   3691  N   VAL   202     -11.139  17.397  38.326  1.00 45.99           N  
ATOM   3692  CA  VAL   202     -11.254  15.943  38.114  1.00 45.66           C  
ATOM   3693  C   VAL   202     -10.338  15.453  36.979  1.00 45.24           C  
ATOM   3694  O   VAL   202     -10.137  14.248  36.795  1.00 45.23           O  
ATOM   3695  CB  VAL   202     -12.735  15.475  37.829  1.00 45.91           C  
ATOM   3696  CG1 VAL   202     -13.639  15.766  39.004  1.00 45.29           C  
ATOM   3697  CG2 VAL   202     -13.310  16.087  36.522  1.00 45.34           C  
ATOM   3698  N   MET   203      -9.800  16.407  36.225  1.00 44.72           N  
ATOM   3699  CA  MET   203      -8.967  16.123  35.070  1.00 44.18           C  
ATOM   3700  C   MET   203      -7.495  15.999  35.448  1.00 44.28           C  
ATOM   3701  O   MET   203      -6.725  15.393  34.716  1.00 45.06           O  
ATOM   3702  CB  MET   203      -9.145  17.224  34.014  1.00 43.95           C  
ATOM   3703  CG  MET   203     -10.470  17.197  33.251  1.00 42.46           C  
ATOM   3704  SD  MET   203     -10.775  15.635  32.109  0.50 43.46          SE  
ATOM   3705  CE  MET   203     -12.187  14.872  33.152  1.00 39.22           C  
ATOM   3706  N   LEU   204      -7.113  16.561  36.592  1.00 44.06           N  
ATOM   3707  CA  LEU   204      -5.705  16.663  36.986  1.00 44.32           C  
ATOM   3708  C   LEU   204      -4.908  15.350  36.982  1.00 44.92           C  
ATOM   3709  O   LEU   204      -3.820  15.319  36.407  1.00 45.89           O  
ATOM   3710  CB  LEU   204      -5.523  17.443  38.312  1.00 43.67           C  
ATOM   3711  CG  LEU   204      -5.945  18.924  38.297  1.00 43.03           C  
ATOM   3712  CD1 LEU   204      -5.960  19.515  39.730  1.00 42.97           C  
ATOM   3713  CD2 LEU   204      -5.101  19.782  37.339  1.00 38.07           C  
ATOM   3714  N   PRO   205      -5.427  14.276  37.620  1.00 44.73           N  
ATOM   3715  CA  PRO   205      -4.802  12.947  37.507  1.00 44.73           C  
ATOM   3716  C   PRO   205      -4.481  12.528  36.068  1.00 44.57           C  
ATOM   3717  O   PRO   205      -3.399  11.979  35.817  1.00 44.30           O  
ATOM   3718  CB  PRO   205      -5.883  11.995  38.063  1.00 44.42           C  
ATOM   3719  CG  PRO   205      -6.638  12.795  39.030  1.00 44.75           C  
ATOM   3720  CD  PRO   205      -6.597  14.247  38.523  1.00 44.74           C  
ATOM   3721  N   LEU   206      -5.419  12.774  35.148  1.00 44.12           N  
ATOM   3722  CA  LEU   206      -5.256  12.399  33.740  1.00 43.81           C  
ATOM   3723  C   LEU   206      -4.252  13.300  33.022  1.00 42.44           C  
ATOM   3724  O   LEU   206      -3.481  12.846  32.174  1.00 41.16           O  
ATOM   3725  CB  LEU   206      -6.620  12.405  33.026  1.00 44.69           C  
ATOM   3726  CG  LEU   206      -7.719  11.520  33.658  1.00 45.45           C  
ATOM   3727  CD1 LEU   206      -9.032  11.646  32.905  1.00 47.08           C  
ATOM   3728  CD2 LEU   206      -7.291  10.081  33.691  1.00 46.58           C  
ATOM   3729  N   ILE   207      -4.286  14.578  33.373  1.00 41.80           N  
ATOM   3730  CA  ILE   207      -3.329  15.582  32.871  1.00 41.79           C  
ATOM   3731  C   ILE   207      -1.896  15.198  33.257  1.00 41.75           C  
ATOM   3732  O   ILE   207      -0.979  15.249  32.417  1.00 41.58           O  
ATOM   3733  CB  ILE   207      -3.692  17.011  33.399  1.00 41.39           C  
ATOM   3734  CG1 ILE   207      -4.917  17.538  32.641  1.00 41.98           C  
ATOM   3735  CG2 ILE   207      -2.498  17.988  33.283  1.00 41.74           C  
ATOM   3736  CD1 ILE   207      -5.443  18.849  33.119  1.00 41.94           C  
ATOM   3737  N   ASP   208      -1.731  14.804  34.522  1.00 41.62           N  
ATOM   3738  CA  ASP   208      -0.459  14.336  35.054  1.00 43.15           C  
ATOM   3739  C   ASP   208       0.043  13.076  34.359  1.00 43.18           C  
ATOM   3740  O   ASP   208       1.211  13.019  33.981  1.00 43.70           O  
ATOM   3741  CB  ASP   208      -0.552  14.063  36.559  1.00 43.18           C  
ATOM   3742  CG  ASP   208      -0.671  15.329  37.376  1.00 45.49           C  
ATOM   3743  OD1 ASP   208      -0.628  16.463  36.806  1.00 47.76           O  
ATOM   3744  OD2 ASP   208      -0.809  15.187  38.603  1.00 47.44           O  
ATOM   3745  N   GLU   209      -0.826  12.075  34.211  1.00 43.38           N  
ATOM   3746  CA  GLU   209      -0.504  10.811  33.524  0.50 44.09           C  
ATOM   3748  C   GLU   209      -0.047  11.069  32.092  1.00 43.53           C  
ATOM   3749  O   GLU   209       0.931  10.511  31.620  1.00 44.79           O  
ATOM   3750  CB  GLU   209      -1.730   9.876  33.515  0.50 43.76           C  
ATOM   3752  CG  GLU   209      -1.477   8.436  32.992  0.50 45.12           C  
ATOM   3754  CD  GLU   209      -2.770   7.600  32.812  0.50 45.56           C  
ATOM   3756  OE1 GLU   209      -3.823   8.168  32.442  0.50 48.02           O  
ATOM   3758  OE2 GLU   209      -2.735   6.364  33.026  0.50 46.93           O  
ATOM   3760  N   THR   210      -0.794  11.919  31.395  1.00 43.49           N  
ATOM   3761  CA  THR   210      -0.541  12.204  29.976  1.00 42.70           C  
ATOM   3762  C   THR   210       0.834  12.842  29.779  1.00 42.23           C  
ATOM   3763  O   THR   210       1.561  12.474  28.857  1.00 42.26           O  
ATOM   3764  CB  THR   210      -1.665  13.094  29.402  1.00 42.89           C  
ATOM   3765  OG1 THR   210      -2.908  12.414  29.594  1.00 42.64           O  
ATOM   3766  CG2 THR   210      -1.468  13.388  27.933  1.00 41.11           C  
ATOM   3767  N   ALA   211       1.191  13.769  30.660  1.00 41.57           N  
ATOM   3768  CA  ALA   211       2.515  14.385  30.634  1.00 41.58           C  
ATOM   3769  C   ALA   211       3.627  13.397  31.008  1.00 42.04           C  
ATOM   3770  O   ALA   211       4.629  13.293  30.291  1.00 41.86           O  
ATOM   3771  CB  ALA   211       2.551  15.609  31.533  1.00 41.16           C  
ATOM   3772  N   ARG   212       3.448  12.665  32.112  1.00 42.71           N  
ATOM   3773  CA  ARG   212       4.505  11.749  32.567  0.50 43.22           C  
ATOM   3775  C   ARG   212       4.796  10.629  31.561  1.00 43.43           C  
ATOM   3776  O   ARG   212       5.932  10.189  31.456  1.00 44.28           O  
ATOM   3777  CB  ARG   212       4.246  11.219  33.991  0.50 42.98           C  
ATOM   3779  CG  ARG   212       3.164  10.175  34.131  0.50 42.39           C  
ATOM   3781  CD  ARG   212       3.731   8.799  34.478  0.50 40.24           C  
ATOM   3783  NE  ARG   212       2.767   7.765  34.126  0.50 38.45           N  
ATOM   3785  CZ  ARG   212       3.008   6.728  33.327  0.50 37.12           C  
ATOM   3787  NH1 ARG   212       4.210   6.524  32.796  0.50 35.66           N  
ATOM   3789  NH2 ARG   212       2.028   5.880  33.073  0.50 36.62           N  
ATOM   3791  N   LYS   213       3.790  10.224  30.799  1.00 43.77           N  
ATOM   3792  CA  LYS   213       3.907   9.172  29.785  1.00 44.65           C  
ATOM   3793  C   LYS   213       4.978   9.453  28.712  1.00 44.32           C  
ATOM   3794  O   LYS   213       5.649   8.520  28.241  1.00 43.84           O  
ATOM   3795  CB  LYS   213       2.541   9.016  29.112  1.00 45.24           C  
ATOM   3796  CG  LYS   213       2.019   7.611  28.974  1.00 48.46           C  
ATOM   3797  CD  LYS   213       0.496   7.627  29.130  1.00 52.69           C  
ATOM   3798  CE  LYS   213      -0.133   6.325  28.666  1.00 55.45           C  
ATOM   3799  NZ  LYS   213      -1.464   6.121  29.336  1.00 57.42           N  
ATOM   3800  N   VAL   214       5.137  10.724  28.321  1.00 43.56           N  
ATOM   3801  CA  VAL   214       6.035  11.060  27.206  1.00 43.38           C  
ATOM   3802  C   VAL   214       7.487  11.205  27.628  1.00 43.99           C  
ATOM   3803  O   VAL   214       8.353  11.467  26.791  1.00 43.71           O  
ATOM   3804  CB  VAL   214       5.571  12.285  26.335  1.00 43.54           C  
ATOM   3805  CG1 VAL   214       4.338  11.909  25.500  1.00 42.67           C  
ATOM   3806  CG2 VAL   214       5.322  13.516  27.183  1.00 41.62           C  
ATOM   3807  N   HIS   215       7.748  11.060  28.926  1.00 44.67           N  
ATOM   3808  CA  HIS   215       9.123  10.887  29.403  1.00 45.81           C  
ATOM   3809  C   HIS   215       9.647   9.507  28.980  1.00 46.63           C  
ATOM   3810  O   HIS   215      10.809   9.362  28.619  1.00 46.86           O  
ATOM   3811  CB  HIS   215       9.187  11.017  30.922  1.00 46.00           C  
ATOM   3812  CG  HIS   215       9.078  12.426  31.417  1.00 44.86           C  
ATOM   3813  ND1 HIS   215      10.125  13.080  32.024  1.00 44.25           N  
ATOM   3814  CD2 HIS   215       8.044  13.300  31.407  1.00 45.64           C  
ATOM   3815  CE1 HIS   215       9.744  14.297  32.373  1.00 45.16           C  
ATOM   3816  NE2 HIS   215       8.483  14.458  32.007  1.00 46.88           N  
ATOM   3817  N   GLU   216       8.769   8.508  29.032  0.50 47.30           N  
ATOM   3819  CA  GLU   216       9.117   7.127  28.698  0.50 48.16           C  
ATOM   3821  C   GLU   216       8.921   6.838  27.207  0.50 48.54           C  
ATOM   3823  O   GLU   216       9.810   6.306  26.552  0.50 48.64           O  
ATOM   3825  CB  GLU   216       8.294   6.148  29.550  0.50 48.03           C  
ATOM   3827  CG  GLU   216       8.747   6.022  31.012  0.50 48.66           C  
ATOM   3829  CD  GLU   216       8.514   7.283  31.843  0.50 49.62           C  
ATOM   3831  OE1 GLU   216       7.501   7.989  31.603  0.50 49.85           O  
ATOM   3833  OE2 GLU   216       9.349   7.565  32.739  0.50 49.28           O  
ATOM   3835  N   LEU   217       7.759   7.214  26.679  1.00 49.13           N  
ATOM   3836  CA  LEU   217       7.363   6.859  25.308  1.00 49.90           C  
ATOM   3837  C   LEU   217       7.443   8.060  24.394  1.00 50.70           C  
ATOM   3838  O   LEU   217       7.203   9.202  24.825  1.00 51.46           O  
ATOM   3839  CB  LEU   217       5.924   6.296  25.272  1.00 49.67           C  
ATOM   3840  CG  LEU   217       5.458   5.275  26.311  1.00 50.11           C  
ATOM   3841  CD1 LEU   217       3.953   5.036  26.204  1.00 50.14           C  
ATOM   3842  CD2 LEU   217       6.225   3.947  26.189  1.00 50.71           C  
ATOM   3843  N   GLU   218       7.778   7.814  23.132  1.00 51.05           N  
ATOM   3844  CA  GLU   218       7.546   8.815  22.092  1.00 51.67           C  
ATOM   3845  C   GLU   218       6.037   9.151  22.073  1.00 51.60           C  
ATOM   3846  O   GLU   218       5.210   8.251  22.254  1.00 50.48           O  
ATOM   3847  CB  GLU   218       8.003   8.263  20.736  1.00 51.63           C  
ATOM   3848  CG  GLU   218       9.531   8.291  20.517  1.00 52.72           C  
ATOM   3849  CD  GLU   218       9.930   7.889  19.102  1.00 54.07           C  
ATOM   3850  OE1 GLU   218       9.096   8.005  18.179  1.00 58.45           O  
ATOM   3851  OE2 GLU   218      11.081   7.449  18.895  1.00 58.82           O  
ATOM   3852  N   PRO   219       5.670  10.445  21.889  1.00 51.86           N  
ATOM   3853  CA  PRO   219       4.244  10.812  21.818  1.00 52.05           C  
ATOM   3854  C   PRO   219       3.423   9.948  20.868  1.00 53.10           C  
ATOM   3855  O   PRO   219       2.292   9.561  21.209  1.00 52.65           O  
ATOM   3856  CB  PRO   219       4.280  12.264  21.332  1.00 51.92           C  
ATOM   3857  CG  PRO   219       5.548  12.786  21.907  1.00 51.37           C  
ATOM   3858  CD  PRO   219       6.535  11.636  21.764  1.00 51.51           C  
ATOM   3859  N   LYS   220       3.990   9.624  19.700  1.00 53.89           N  
ATOM   3860  CA  LYS   220       3.317   8.764  18.728  1.00 54.47           C  
ATOM   3861  C   LYS   220       2.948   7.395  19.288  1.00 54.47           C  
ATOM   3862  O   LYS   220       1.908   6.827  18.928  1.00 54.57           O  
ATOM   3863  CB  LYS   220       4.175   8.581  17.474  1.00 54.79           C  
ATOM   3864  CG  LYS   220       3.559   9.264  16.255  1.00 56.61           C  
ATOM   3865  CD  LYS   220       4.381   9.077  14.951  1.00 56.04           C  
ATOM   3866  CE  LYS   220       4.015  10.205  13.942  1.00 57.77           C  
ATOM   3867  NZ  LYS   220       3.508  11.476  14.662  1.00 51.23           N  
ATOM   3868  N   THR   221       3.825   6.857  20.135  1.00 54.33           N  
ATOM   3869  CA  THR   221       3.618   5.549  20.772  1.00 53.89           C  
ATOM   3870  C   THR   221       2.621   5.657  21.946  1.00 53.38           C  
ATOM   3871  O   THR   221       1.881   4.712  22.239  1.00 53.18           O  
ATOM   3872  CB  THR   221       4.977   4.950  21.221  1.00 53.88           C  
ATOM   3873  OG1 THR   221       5.853   4.899  20.091  1.00 54.62           O  
ATOM   3874  CG2 THR   221       4.822   3.520  21.768  1.00 53.13           C  
ATOM   3875  N   ALA   222       2.596   6.829  22.574  1.00 52.64           N  
ATOM   3876  CA  ALA   222       1.792   7.105  23.758  1.00 52.54           C  
ATOM   3877  C   ALA   222       0.323   7.370  23.432  1.00 52.49           C  
ATOM   3878  O   ALA   222      -0.541   7.196  24.286  1.00 53.01           O  
ATOM   3879  CB  ALA   222       2.393   8.325  24.512  1.00 52.10           C  
ATOM   3880  N   GLN   223       0.049   7.813  22.206  1.00 52.57           N  
ATOM   3881  CA  GLN   223      -1.308   8.148  21.757  1.00 53.09           C  
ATOM   3882  C   GLN   223      -2.311   7.030  22.052  1.00 53.89           C  
ATOM   3883  O   GLN   223      -2.095   5.867  21.674  1.00 53.21           O  
ATOM   3884  CB  GLN   223      -1.293   8.451  20.256  1.00 52.76           C  
ATOM   3885  CG  GLN   223      -2.569   9.086  19.719  1.00 53.69           C  
ATOM   3886  CD  GLN   223      -2.793  10.491  20.266  1.00 53.50           C  
ATOM   3887  OE1 GLN   223      -1.953  11.370  20.090  1.00 55.81           O  
ATOM   3888  NE2 GLN   223      -3.910  10.696  20.947  1.00 48.94           N  
ATOM   3889  N   THR   224      -3.379   7.386  22.767  1.00 54.90           N  
ATOM   3890  CA  THR   224      -4.504   6.486  23.026  1.00 55.56           C  
ATOM   3891  C   THR   224      -5.798   7.157  22.528  1.00 55.70           C  
ATOM   3892  O   THR   224      -5.759   8.285  21.995  1.00 55.68           O  
ATOM   3893  CB  THR   224      -4.616   6.086  24.537  1.00 56.01           C  
ATOM   3894  OG1 THR   224      -4.703   7.256  25.359  1.00 58.47           O  
ATOM   3895  CG2 THR   224      -3.415   5.257  24.988  1.00 56.48           C  
ATOM   3896  N   GLY   225      -6.934   6.476  22.675  1.00 55.28           N  
ATOM   3897  CA  GLY   225      -8.228   7.094  22.389  1.00 55.64           C  
ATOM   3898  C   GLY   225      -8.933   6.674  21.111  1.00 56.11           C  
ATOM   3899  O   GLY   225      -8.371   5.935  20.303  1.00 55.93           O  
ATOM   3900  N   PRO   226     -10.186   7.141  20.920  1.00 56.68           N  
ATOM   3901  CA  PRO   226     -11.038   6.591  19.848  1.00 57.30           C  
ATOM   3902  C   PRO   226     -10.703   7.082  18.427  1.00 57.55           C  
ATOM   3903  O   PRO   226     -11.299   6.625  17.456  1.00 57.43           O  
ATOM   3904  CB  PRO   226     -12.440   7.021  20.271  1.00 56.83           C  
ATOM   3905  CG  PRO   226     -12.194   8.348  21.004  1.00 56.89           C  
ATOM   3906  CD  PRO   226     -10.890   8.166  21.721  1.00 56.59           C  
ATOM   3907  N   ALA   227      -9.740   7.983  18.313  1.00 58.23           N  
ATOM   3908  CA  ALA   227      -9.394   8.582  17.019  1.00 59.12           C  
ATOM   3909  C   ALA   227      -8.446   7.710  16.189  1.00 59.42           C  
ATOM   3910  O   ALA   227      -8.438   7.772  14.959  1.00 59.37           O  
ATOM   3911  CB  ALA   227      -8.811   9.991  17.224  1.00 58.46           C  
ATOM   3912  N   ILE   228      -7.655   6.903  16.885  1.00 60.49           N  
ATOM   3913  CA  ILE   228      -6.687   6.004  16.275  1.00 61.48           C  
ATOM   3914  C   ILE   228      -7.351   5.105  15.240  1.00 62.70           C  
ATOM   3915  O   ILE   228      -6.878   4.996  14.096  1.00 62.43           O  
ATOM   3916  CB  ILE   228      -5.972   5.171  17.365  1.00 61.48           C  
ATOM   3917  CG1 ILE   228      -4.935   6.053  18.070  1.00 60.95           C  
ATOM   3918  CG2 ILE   228      -5.300   3.919  16.775  1.00 60.87           C  
ATOM   3919  CD1 ILE   228      -4.742   5.729  19.525  1.00 60.47           C  
ATOM   3920  N   ARG   229      -8.456   4.481  15.651  1.00 63.99           N  
ATOM   3921  CA  ARG   229      -9.229   3.594  14.799  1.00 65.06           C  
ATOM   3922  C   ARG   229     -10.260   4.376  13.994  1.00 65.76           C  
ATOM   3923  O   ARG   229     -10.807   3.880  13.016  1.00 65.78           O  
ATOM   3924  CB  ARG   229      -9.939   2.557  15.670  1.00 65.34           C  
ATOM   3925  CG  ARG   229      -9.002   1.720  16.542  1.00 66.20           C  
ATOM   3926  CD  ARG   229      -8.356   0.591  15.750  1.00 66.26           C  
ATOM   3927  NE  ARG   229      -9.351  -0.381  15.317  1.00 66.47           N  
ATOM   3928  CZ  ARG   229      -9.307  -1.038  14.162  1.00 66.61           C  
ATOM   3929  NH1 ARG   229      -8.316  -0.821  13.303  1.00 66.31           N  
ATOM   3930  NH2 ARG   229     -10.263  -1.907  13.865  1.00 66.50           N  
ATOM   3931  N   TYR   230     -10.492   5.617  14.408  1.00 66.94           N  
ATOM   3932  CA  TYR   230     -11.658   6.416  13.998  1.00 67.86           C  
ATOM   3933  C   TYR   230     -12.991   5.718  14.335  1.00 67.79           C  
ATOM   3934  O   TYR   230     -13.860   5.506  13.471  1.00 67.58           O  
ATOM   3935  CB  TYR   230     -11.581   6.943  12.544  1.00 68.43           C  
ATOM   3936  CG  TYR   230     -12.141   8.356  12.457  1.00 69.38           C  
ATOM   3937  CD1 TYR   230     -11.391   9.450  12.913  1.00 69.39           C  
ATOM   3938  CD2 TYR   230     -13.442   8.593  11.976  1.00 70.33           C  
ATOM   3939  CE1 TYR   230     -11.903  10.746  12.868  1.00 70.10           C  
ATOM   3940  CE2 TYR   230     -13.970   9.893  11.923  1.00 70.28           C  
ATOM   3941  CZ  TYR   230     -13.192  10.964  12.372  1.00 70.64           C  
ATOM   3942  OH  TYR   230     -13.695  12.252  12.332  1.00 70.46           O  
ATOM   3943  N   ASP   231     -13.100   5.370  15.621  1.00 67.75           N  
ATOM   3944  CA  ASP   231     -14.302   4.847  16.269  1.00 67.62           C  
ATOM   3945  C   ASP   231     -15.460   5.817  16.030  1.00 67.38           C  
ATOM   3946  O   ASP   231     -15.658   6.765  16.797  1.00 67.37           O  
ATOM   3947  CB  ASP   231     -14.012   4.712  17.769  1.00 67.45           C  
ATOM   3948  CG  ASP   231     -14.963   3.759  18.493  1.00 68.36           C  
ATOM   3949  OD1 ASP   231     -16.109   3.515  18.038  1.00 66.15           O  
ATOM   3950  OD2 ASP   231     -14.539   3.264  19.562  1.00 69.84           O  
ATOM   3951  N   GLU   232     -16.204   5.580  14.953  1.00 66.88           N  
ATOM   3952  CA  GLU   232     -17.200   6.536  14.457  1.00 66.94           C  
ATOM   3953  C   GLU   232     -18.460   6.658  15.322  1.00 66.56           C  
ATOM   3954  O   GLU   232     -19.178   7.664  15.249  1.00 66.61           O  
ATOM   3955  CB  GLU   232     -17.566   6.219  12.999  1.00 67.25           C  
ATOM   3956  CG  GLU   232     -16.634   6.912  11.995  1.00 68.25           C  
ATOM   3957  CD  GLU   232     -16.339   6.071  10.752  1.00 69.15           C  
ATOM   3958  OE1 GLU   232     -17.267   5.412  10.239  1.00 68.38           O  
ATOM   3959  OE2 GLU   232     -15.171   6.077  10.287  1.00 70.27           O  
ATOM   3960  N   ASN   233     -18.725   5.633  16.128  1.00 65.70           N  
ATOM   3961  CA  ASN   233     -19.743   5.715  17.166  1.00 65.01           C  
ATOM   3962  C   ASN   233     -19.356   6.798  18.198  1.00 64.20           C  
ATOM   3963  O   ASN   233     -20.021   7.862  18.316  1.00 64.27           O  
ATOM   3964  CB  ASN   233     -19.892   4.355  17.846  1.00 65.39           C  
ATOM   3965  CG  ASN   233     -20.974   4.347  18.900  1.00 66.74           C  
ATOM   3966  OD1 ASN   233     -22.304   4.187  18.502  1.00 66.79           O  
ATOM   3967  ND2 ASN   233     -20.503   4.430  20.213  1.00 67.61           N  
ATOM   3968  N   VAL   234     -18.259   6.554  18.923  1.00 62.56           N  
ATOM   3969  CA  VAL   234     -17.903   7.478  19.981  1.00 61.51           C  
ATOM   3970  C   VAL   234     -17.638   8.875  19.413  1.00 60.52           C  
ATOM   3971  O   VAL   234     -18.070   9.866  20.000  1.00 59.86           O  
ATOM   3972  CB  VAL   234     -16.754   6.959  20.868  1.00 61.60           C  
ATOM   3973  CG1 VAL   234     -17.101   5.595  21.440  1.00 61.28           C  
ATOM   3974  CG2 VAL   234     -15.496   6.871  20.101  1.00 62.28           C  
ATOM   3975  N   ILE   235     -17.005   8.938  18.239  1.00 59.61           N  
ATOM   3976  CA  ILE   235     -16.702  10.218  17.579  1.00 59.26           C  
ATOM   3977  C   ILE   235     -17.985  10.943  17.145  1.00 59.21           C  
ATOM   3978  O   ILE   235     -18.112  12.149  17.321  1.00 59.17           O  
ATOM   3979  CB  ILE   235     -15.645  10.065  16.433  1.00 58.88           C  
ATOM   3980  CG1 ILE   235     -14.284   9.729  17.041  1.00 57.94           C  
ATOM   3981  CG2 ILE   235     -15.538  11.340  15.618  1.00 58.46           C  
ATOM   3982  CD1 ILE   235     -13.254   9.243  16.074  1.00 55.98           C  
ATOM   3983  N   GLY   236     -18.934  10.193  16.608  1.00 59.44           N  
ATOM   3984  CA  GLY   236     -20.248  10.728  16.285  1.00 59.72           C  
ATOM   3985  C   GLY   236     -20.941  11.275  17.520  1.00 59.60           C  
ATOM   3986  O   GLY   236     -21.372  12.435  17.530  1.00 59.40           O  
ATOM   3987  N   ASN   237     -21.048  10.427  18.558  1.00 59.52           N  
ATOM   3988  CA  ASN   237     -21.584  10.839  19.861  1.00 59.22           C  
ATOM   3989  C   ASN   237     -20.910  12.113  20.395  1.00 58.55           C  
ATOM   3990  O   ASN   237     -21.579  13.044  20.838  1.00 58.58           O  
ATOM   3991  CB  ASN   237     -21.471   9.688  20.866  1.00 59.00           C  
ATOM   3992  CG  ASN   237     -22.436   8.529  20.546  1.00 61.65           C  
ATOM   3993  OD1 ASN   237     -23.403   8.685  19.785  1.00 61.75           O  
ATOM   3994  ND2 ASN   237     -22.177   7.358  21.140  1.00 62.10           N  
ATOM   3995  N   HIS   238     -19.586  12.166  20.321  1.00 58.09           N  
ATOM   3996  CA  HIS   238     -18.858  13.339  20.788  1.00 57.94           C  
ATOM   3997  C   HIS   238     -19.131  14.607  19.971  1.00 58.34           C  
ATOM   3998  O   HIS   238     -19.284  15.688  20.524  1.00 58.58           O  
ATOM   3999  CB  HIS   238     -17.366  13.040  20.906  1.00 57.27           C  
ATOM   4000  CG  HIS   238     -17.030  12.184  22.090  1.00 57.08           C  
ATOM   4001  ND1 HIS   238     -15.777  11.648  22.301  1.00 55.51           N  
ATOM   4002  CD2 HIS   238     -17.802  11.755  23.122  1.00 56.36           C  
ATOM   4003  CE1 HIS   238     -15.787  10.936  23.414  1.00 56.98           C  
ATOM   4004  NE2 HIS   238     -17.004  10.985  23.933  1.00 55.83           N  
ATOM   4005  N   LEU   239     -19.222  14.472  18.658  1.00 58.79           N  
ATOM   4006  CA  LEU   239     -19.549  15.610  17.814  1.00 59.33           C  
ATOM   4007  C   LEU   239     -20.972  16.090  18.112  1.00 59.94           C  
ATOM   4008  O   LEU   239     -21.237  17.299  18.168  1.00 60.00           O  
ATOM   4009  CB  LEU   239     -19.360  15.249  16.334  1.00 59.24           C  
ATOM   4010  CG  LEU   239     -17.897  14.976  15.927  1.00 59.36           C  
ATOM   4011  CD1 LEU   239     -17.816  14.299  14.547  1.00 60.50           C  
ATOM   4012  CD2 LEU   239     -17.055  16.242  15.967  1.00 58.88           C  
ATOM   4013  N   ARG   240     -21.864  15.128  18.340  1.00 60.08           N  
ATOM   4014  CA  ARG   240     -23.246  15.392  18.730  1.00 60.66           C  
ATOM   4015  C   ARG   240     -23.294  16.251  20.006  1.00 60.37           C  
ATOM   4016  O   ARG   240     -24.028  17.228  20.066  1.00 59.91           O  
ATOM   4017  CB  ARG   240     -23.995  14.060  18.901  1.00 60.64           C  
ATOM   4018  CG  ARG   240     -25.504  14.121  18.699  1.00 63.39           C  
ATOM   4019  CD  ARG   240     -26.077  12.770  18.200  1.00 66.38           C  
ATOM   4020  NE  ARG   240     -25.539  12.419  16.875  1.00 68.99           N  
ATOM   4021  CZ  ARG   240     -24.972  11.252  16.551  1.00 69.36           C  
ATOM   4022  NH1 ARG   240     -24.881  10.265  17.439  1.00 69.00           N  
ATOM   4023  NH2 ARG   240     -24.510  11.063  15.319  1.00 68.50           N  
ATOM   4024  N   MET   241     -22.478  15.908  21.000  1.00 60.58           N  
ATOM   4025  CA  MET   241     -22.394  16.683  22.242  1.00 61.43           C  
ATOM   4026  C   MET   241     -21.949  18.134  22.076  1.00 60.76           C  
ATOM   4027  O   MET   241     -22.359  19.009  22.843  1.00 60.65           O  
ATOM   4028  CB  MET   241     -21.488  15.987  23.247  1.00 61.04           C  
ATOM   4029  CG  MET   241     -22.249  15.105  24.185  1.00 62.49           C  
ATOM   4030  SD  MET   241     -21.166  14.342  25.591  0.50 64.12          SE  
ATOM   4031  CE  MET   241     -20.782  12.653  24.722  1.00 61.74           C  
ATOM   4032  N   LEU   242     -21.121  18.379  21.067  1.00 60.65           N  
ATOM   4033  CA  LEU   242     -20.550  19.697  20.814  1.00 60.38           C  
ATOM   4034  C   LEU   242     -21.325  20.523  19.773  1.00 60.53           C  
ATOM   4035  O   LEU   242     -20.844  21.570  19.309  1.00 60.94           O  
ATOM   4036  CB  LEU   242     -19.101  19.530  20.372  1.00 60.55           C  
ATOM   4037  CG  LEU   242     -18.153  18.744  21.273  1.00 60.53           C  
ATOM   4038  CD1 LEU   242     -16.890  18.441  20.489  1.00 59.97           C  
ATOM   4039  CD2 LEU   242     -17.830  19.513  22.541  1.00 57.92           C  
ATOM   4040  N   ALA   243     -22.516  20.053  19.408  1.00 60.40           N  
ATOM   4041  CA  ALA   243     -23.381  20.743  18.446  1.00 60.38           C  
ATOM   4042  C   ALA   243     -23.637  22.204  18.822  1.00 60.35           C  
ATOM   4043  O   ALA   243     -23.699  23.065  17.943  1.00 60.72           O  
ATOM   4044  CB  ALA   243     -24.703  19.985  18.277  1.00 59.98           C  
ATOM   4045  N   ASP   244     -23.783  22.466  20.124  1.00 60.26           N  
ATOM   4046  CA  ASP   244     -23.913  23.820  20.683  1.00 60.07           C  
ATOM   4047  C   ASP   244     -22.714  24.730  20.377  1.00 59.23           C  
ATOM   4048  O   ASP   244     -22.813  25.956  20.495  1.00 58.48           O  
ATOM   4049  CB  ASP   244     -24.054  23.748  22.207  1.00 60.76           C  
ATOM   4050  CG  ASP   244     -25.497  23.628  22.681  1.00 63.13           C  
ATOM   4051  OD1 ASP   244     -26.445  23.478  21.859  1.00 66.84           O  
ATOM   4052  OD2 ASP   244     -25.684  23.690  23.920  1.00 65.28           O  
ATOM   4053  N   ASP   245     -21.581  24.139  20.007  1.00 58.58           N  
ATOM   4054  CA  ASP   245     -20.378  24.918  19.771  1.00 58.12           C  
ATOM   4055  C   ASP   245     -19.675  24.482  18.482  1.00 57.89           C  
ATOM   4056  O   ASP   245     -18.680  23.748  18.539  1.00 58.08           O  
ATOM   4057  CB  ASP   245     -19.450  24.812  20.987  1.00 58.30           C  
ATOM   4058  CG  ASP   245     -18.391  25.930  21.047  1.00 59.64           C  
ATOM   4059  OD1 ASP   245     -17.897  26.405  19.986  1.00 58.91           O  
ATOM   4060  OD2 ASP   245     -18.039  26.319  22.187  1.00 59.91           O  
ATOM   4061  N   PRO   246     -20.183  24.940  17.313  1.00 57.39           N  
ATOM   4062  CA  PRO   246     -19.610  24.627  15.998  1.00 56.91           C  
ATOM   4063  C   PRO   246     -18.068  24.700  15.930  1.00 56.27           C  
ATOM   4064  O   PRO   246     -17.438  23.803  15.364  1.00 56.00           O  
ATOM   4065  CB  PRO   246     -20.232  25.693  15.086  1.00 56.86           C  
ATOM   4066  CG  PRO   246     -21.532  25.980  15.689  1.00 57.02           C  
ATOM   4067  CD  PRO   246     -21.372  25.807  17.182  1.00 57.56           C  
ATOM   4068  N   ALA   247     -17.473  25.750  16.494  1.00 55.78           N  
ATOM   4069  CA  ALA   247     -16.014  25.922  16.430  1.00 55.24           C  
ATOM   4070  C   ALA   247     -15.303  24.846  17.250  1.00 55.06           C  
ATOM   4071  O   ALA   247     -14.292  24.286  16.815  1.00 54.36           O  
ATOM   4072  CB  ALA   247     -15.599  27.312  16.889  1.00 55.06           C  
ATOM   4073  N   MET   248     -15.837  24.553  18.430  1.00 55.01           N  
ATOM   4074  CA  MET   248     -15.270  23.496  19.253  1.00 55.62           C  
ATOM   4075  C   MET   248     -15.521  22.122  18.633  1.00 55.89           C  
ATOM   4076  O   MET   248     -14.688  21.226  18.748  1.00 56.37           O  
ATOM   4077  CB  MET   248     -15.826  23.541  20.668  1.00 56.12           C  
ATOM   4078  CG  MET   248     -14.944  22.824  21.658  1.00 55.71           C  
ATOM   4079  SD  MET   248     -15.733  22.760  23.390  0.50 55.49          SE  
ATOM   4080  CE  MET   248     -16.082  24.637  23.633  1.00 55.32           C  
ATOM   4081  N   GLN   249     -16.667  21.983  17.976  1.00 55.64           N  
ATOM   4082  CA  GLN   249     -17.050  20.772  17.281  1.00 55.70           C  
ATOM   4083  C   GLN   249     -16.091  20.495  16.108  1.00 56.26           C  
ATOM   4084  O   GLN   249     -15.633  19.363  15.935  1.00 56.64           O  
ATOM   4085  CB  GLN   249     -18.496  20.930  16.795  1.00 55.58           C  
ATOM   4086  CG  GLN   249     -19.162  19.698  16.240  1.00 55.05           C  
ATOM   4087  CD  GLN   249     -20.581  19.984  15.702  1.00 55.88           C  
ATOM   4088  OE1 GLN   249     -21.562  19.361  16.140  1.00 56.39           O  
ATOM   4089  NE2 GLN   249     -20.689  20.919  14.754  1.00 52.57           N  
ATOM   4090  N   ARG   250     -15.771  21.527  15.324  1.00 56.02           N  
ATOM   4091  CA  ARG   250     -14.827  21.385  14.209  1.00 56.46           C  
ATOM   4092  C   ARG   250     -13.394  21.036  14.675  1.00 55.98           C  
ATOM   4093  O   ARG   250     -12.709  20.239  14.021  1.00 55.95           O  
ATOM   4094  CB  ARG   250     -14.853  22.629  13.288  1.00 56.33           C  
ATOM   4095  CG  ARG   250     -14.107  22.472  11.933  1.00 56.98           C  
ATOM   4096  CD  ARG   250     -13.950  23.812  11.191  1.00 57.18           C  
ATOM   4097  NE  ARG   250     -12.895  23.781  10.160  1.00 59.94           N  
ATOM   4098  CZ  ARG   250     -12.720  24.698   9.202  1.00 58.46           C  
ATOM   4099  NH1 ARG   250     -13.542  25.739   9.118  1.00 59.04           N  
ATOM   4100  NH2 ARG   250     -11.724  24.576   8.323  1.00 56.38           N  
ATOM   4101  N   LEU   251     -12.951  21.621  15.794  1.00 55.62           N  
ATOM   4102  CA  LEU   251     -11.633  21.307  16.364  1.00 55.07           C  
ATOM   4103  C   LEU   251     -11.532  19.821  16.715  1.00 55.24           C  
ATOM   4104  O   LEU   251     -10.543  19.145  16.369  1.00 55.16           O  
ATOM   4105  CB  LEU   251     -11.334  22.146  17.618  1.00 54.29           C  
ATOM   4106  CG  LEU   251     -10.831  23.564  17.387  1.00 54.76           C  
ATOM   4107  CD1 LEU   251     -10.651  24.273  18.713  1.00 54.25           C  
ATOM   4108  CD2 LEU   251      -9.520  23.568  16.537  1.00 50.14           C  
ATOM   4109  N   TYR   252     -12.557  19.321  17.409  1.00 54.69           N  
ATOM   4110  CA  TYR   252     -12.605  17.910  17.784  1.00 54.79           C  
ATOM   4111  C   TYR   252     -12.443  17.031  16.529  1.00 55.22           C  
ATOM   4112  O   TYR   252     -11.675  16.065  16.527  1.00 55.55           O  
ATOM   4113  CB  TYR   252     -13.916  17.581  18.523  1.00 54.20           C  
ATOM   4114  CG  TYR   252     -14.007  16.138  18.986  1.00 54.05           C  
ATOM   4115  CD1 TYR   252     -13.764  15.799  20.320  1.00 54.30           C  
ATOM   4116  CD2 TYR   252     -14.327  15.108  18.086  1.00 53.48           C  
ATOM   4117  CE1 TYR   252     -13.835  14.470  20.756  1.00 54.08           C  
ATOM   4118  CE2 TYR   252     -14.401  13.773  18.514  1.00 53.73           C  
ATOM   4119  CZ  TYR   252     -14.146  13.466  19.845  1.00 53.37           C  
ATOM   4120  OH  TYR   252     -14.209  12.165  20.274  1.00 53.46           O  
ATOM   4121  N   GLU   253     -13.161  17.382  15.466  1.00 55.29           N  
ATOM   4122  CA  GLU   253     -13.183  16.578  14.252  1.00 55.68           C  
ATOM   4123  C   GLU   253     -11.826  16.543  13.552  1.00 55.17           C  
ATOM   4124  O   GLU   253     -11.347  15.476  13.174  1.00 55.43           O  
ATOM   4125  CB  GLU   253     -14.283  17.078  13.316  1.00 55.57           C  
ATOM   4126  CG  GLU   253     -14.101  16.668  11.873  1.00 58.46           C  
ATOM   4127  CD  GLU   253     -15.361  16.815  11.074  1.00 60.58           C  
ATOM   4128  OE1 GLU   253     -16.271  17.560  11.506  1.00 61.78           O  
ATOM   4129  OE2 GLU   253     -15.442  16.169  10.014  1.00 63.05           O  
ATOM   4130  N   LEU   254     -11.209  17.713  13.405  1.00 55.01           N  
ATOM   4131  CA  LEU   254      -9.906  17.842  12.749  1.00 54.20           C  
ATOM   4132  C   LEU   254      -8.749  17.276  13.592  1.00 53.80           C  
ATOM   4133  O   LEU   254      -7.833  16.660  13.065  1.00 53.12           O  
ATOM   4134  CB  LEU   254      -9.656  19.304  12.380  1.00 54.37           C  
ATOM   4135  CG  LEU   254     -10.587  19.947  11.343  1.00 54.47           C  
ATOM   4136  CD1 LEU   254     -10.285  21.428  11.292  1.00 54.67           C  
ATOM   4137  CD2 LEU   254     -10.462  19.325   9.948  1.00 51.29           C  
ATOM   4138  N   LEU   255      -8.809  17.462  14.904  1.00 53.39           N  
ATOM   4139  CA  LEU   255      -7.840  16.823  15.805  1.00 53.06           C  
ATOM   4140  C   LEU   255      -7.942  15.291  15.734  1.00 52.57           C  
ATOM   4141  O   LEU   255      -6.927  14.590  15.696  1.00 52.43           O  
ATOM   4142  CB  LEU   255      -8.000  17.337  17.253  1.00 52.52           C  
ATOM   4143  CG  LEU   255      -7.546  18.791  17.484  1.00 52.29           C  
ATOM   4144  CD1 LEU   255      -8.164  19.445  18.751  1.00 54.49           C  
ATOM   4145  CD2 LEU   255      -6.017  18.929  17.527  1.00 52.47           C  
ATOM   4146  N   SER   256      -9.168  14.778  15.695  1.00 52.55           N  
ATOM   4147  CA  SER   256      -9.395  13.338  15.572  1.00 52.58           C  
ATOM   4148  C   SER   256      -8.870  12.878  14.213  1.00 52.92           C  
ATOM   4149  O   SER   256      -8.105  11.920  14.131  1.00 52.81           O  
ATOM   4150  CB  SER   256     -10.884  13.005  15.724  1.00 52.75           C  
ATOM   4151  OG  SER   256     -11.318  13.240  17.053  1.00 52.62           O  
ATOM   4152  N   ARG   257      -9.266  13.588  13.156  1.00 53.12           N  
ATOM   4153  CA  ARG   257      -8.803  13.318  11.800  1.00 53.95           C  
ATOM   4154  C   ARG   257      -7.284  13.256  11.810  1.00 53.63           C  
ATOM   4155  O   ARG   257      -6.692  12.372  11.195  1.00 53.32           O  
ATOM   4156  CB  ARG   257      -9.274  14.434  10.866  1.00 53.68           C  
ATOM   4157  CG  ARG   257      -9.182  14.129   9.380  1.00 56.33           C  
ATOM   4158  CD  ARG   257      -9.742  15.273   8.509  1.00 55.92           C  
ATOM   4159  NE  ARG   257     -11.176  15.502   8.727  1.00 58.75           N  
ATOM   4160  CZ  ARG   257     -11.924  16.345   8.009  1.00 59.76           C  
ATOM   4161  NH1 ARG   257     -11.379  17.053   7.014  1.00 59.57           N  
ATOM   4162  NH2 ARG   257     -13.221  16.482   8.284  1.00 57.85           N  
ATOM   4163  N   SER   258      -6.674  14.185  12.558  1.00 53.47           N  
ATOM   4164  CA  SER   258      -5.241  14.391  12.574  1.00 52.86           C  
ATOM   4165  C   SER   258      -4.526  13.240  13.264  1.00 53.11           C  
ATOM   4166  O   SER   258      -3.494  12.769  12.774  1.00 52.94           O  
ATOM   4167  CB  SER   258      -4.904  15.718  13.268  1.00 53.07           C  
ATOM   4168  OG  SER   258      -3.531  16.018  13.128  1.00 51.90           O  
ATOM   4169  N   ILE   259      -5.061  12.801  14.408  1.00 53.44           N  
ATOM   4170  CA  ILE   259      -4.536  11.619  15.097  1.00 52.89           C  
ATOM   4171  C   ILE   259      -4.606  10.422  14.133  1.00 53.37           C  
ATOM   4172  O   ILE   259      -3.611   9.725  13.934  1.00 53.49           O  
ATOM   4173  CB  ILE   259      -5.297  11.336  16.414  1.00 52.80           C  
ATOM   4174  CG1 ILE   259      -4.952  12.372  17.505  1.00 51.47           C  
ATOM   4175  CG2 ILE   259      -5.055   9.885  16.903  1.00 52.55           C  
ATOM   4176  CD1 ILE   259      -6.058  12.555  18.534  1.00 48.66           C  
ATOM   4177  N   HIS   260      -5.775  10.219  13.518  1.00 53.55           N  
ATOM   4178  CA  HIS   260      -6.009   9.111  12.585  1.00 53.50           C  
ATOM   4179  C   HIS   260      -4.987   9.013  11.445  1.00 53.98           C  
ATOM   4180  O   HIS   260      -4.524   7.912  11.136  1.00 53.59           O  
ATOM   4181  CB  HIS   260      -7.440   9.154  12.038  1.00 53.33           C  
ATOM   4182  CG  HIS   260      -7.834   7.923  11.276  1.00 54.13           C  
ATOM   4183  ND1 HIS   260      -7.777   6.658  11.822  1.00 54.55           N  
ATOM   4184  CD2 HIS   260      -8.285   7.765  10.008  1.00 53.69           C  
ATOM   4185  CE1 HIS   260      -8.172   5.773  10.922  1.00 55.29           C  
ATOM   4186  NE2 HIS   260      -8.484   6.418   9.813  1.00 55.14           N  
ATOM   4187  N   GLU   261      -4.622  10.148  10.838  1.00 54.55           N  
ATOM   4188  CA  GLU   261      -3.609  10.144   9.759  1.00 55.72           C  
ATOM   4189  C   GLU   261      -2.222   9.683  10.233  1.00 55.40           C  
ATOM   4190  O   GLU   261      -1.458   9.155   9.449  1.00 55.46           O  
ATOM   4191  CB  GLU   261      -3.460  11.504   9.033  1.00 55.93           C  
ATOM   4192  CG  GLU   261      -4.732  12.253   8.599  1.00 57.92           C  
ATOM   4193  CD  GLU   261      -5.814  11.373   7.993  1.00 61.50           C  
ATOM   4194  OE1 GLU   261      -5.689  10.989   6.805  1.00 62.42           O  
ATOM   4195  OE2 GLU   261      -6.819  11.094   8.702  1.00 63.25           O  
ATOM   4196  N   ARG   262      -1.915   9.872  11.511  1.00 55.71           N  
ATOM   4197  CA  ARG   262      -0.565   9.623  12.033  1.00 55.68           C  
ATOM   4198  C   ARG   262      -0.456   8.381  12.911  1.00 56.18           C  
ATOM   4199  O   ARG   262      -0.498   7.251  12.411  1.00 56.31           O  
ATOM   4200  CB  ARG   262      -0.077  10.846  12.793  1.00 55.91           C  
ATOM   4201  CG  ARG   262       0.053  12.059  11.904  1.00 55.21           C  
ATOM   4202  CD  ARG   262      -0.059  13.314  12.680  1.00 54.25           C  
ATOM   4203  NE  ARG   262       0.474  14.444  11.926  1.00 55.47           N  
ATOM   4204  CZ  ARG   262      -0.248  15.205  11.110  1.00 56.90           C  
ATOM   4205  NH1 ARG   262      -1.532  14.937  10.933  1.00 58.11           N  
ATOM   4206  NH2 ARG   262       0.314  16.218  10.454  1.00 56.72           N  
END
