
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  130 ( 1992),  selected  130 , name 2jza_A
# Molecule2: number of CA atoms  136 ( 1099),  selected  136 , name T0391.pdb
# PARAMETERS: 2jza_A.T0391.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      K      14           -
LGA    S     2_A      -       -           -
LGA    Q     3_A      Y      15          5.087
LGA    -       -      T      16           -
LGA    W     4_A      S      17          1.979
LGA    T     5_A      V      18          1.880
LGA    T     6_A      C      19          1.380
LGA    V     7_A      V      20          1.788
LGA    C     8_A      G      21          2.038
LGA    K     9_A      R      22          1.657
LGA    L    10_A      E      23          2.132
LGA    D    11_A      E      24          1.847
LGA    D    12_A      D      25          1.642
LGA    I    13_A      I      26          1.851
LGA    -       -      R      27           -
LGA    L    14_A      K      28          3.143
LGA    P    15_A      S      29          3.678
LGA    G    16_A      E      30          3.928
LGA    T    17_A      -       -           -
LGA    G    18_A      R      31          2.197
LGA    V    19_A      M      32          3.412
LGA    C    20_A      T      33          2.423
LGA    A    21_A      A      34          1.555
LGA    L    22_A      V      35          1.272
LGA    V    23_A      V      36          1.140
LGA    E    24_A      H      37          1.518
LGA    Q    25_A      D      38          2.159
LGA    Q    26_A      R      39          0.727
LGA    Q    27_A      E      40          0.775
LGA    I    28_A      V      41          0.942
LGA    A    29_A      V      42          0.337
LGA    V    30_A      I      43          0.684
LGA    F    31_A      F      44          0.930
LGA    R    32_A      Y      45          1.863
LGA    P    33_A      H      46          1.978
LGA    R    34_A      K      47          4.650
LGA    N    35_A      -       -           -
LGA    D    36_A      -       -           -
LGA    E    37_A      G      48           #
LGA    Q    38_A      E      49          2.318
LGA    V    39_A      Y      50          1.277
LGA    Y    40_A      H      51          0.841
LGA    A    41_A      A      52          1.367
LGA    I    42_A      M      53          1.405
LGA    S    43_A      D      54          1.175
LGA    N    44_A      I      55          3.165
LGA    I    45_A      R      56          1.449
LGA    D    46_A      C      57          3.882
LGA    -       -      Y      58           -
LGA    -       -      H      59           -
LGA    P    47_A      S      60          5.998
LGA    F    48_A      G      61          4.782
LGA    A    49_A      G      62          5.413
LGA    Q    50_A      -       -           -
LGA    A    51_A      -       -           -
LGA    S    52_A      -       -           -
LGA    V    53_A      P      63          2.413
LGA    L    54_A      L      64          1.516
LGA    S    55_A      H      65          3.153
LGA    R    56_A      L      66          2.775
LGA    G    57_A      G      67          1.698
LGA    I    58_A      E      68          1.933
LGA    V    59_A      I      69          0.844
LGA    A    60_A      E      70          1.899
LGA    E    61_A      D      71          1.703
LGA    H    62_A      F      72          1.331
LGA    Q    63_A      N      73          2.345
LGA    D    64_A      G      74          2.000
LGA    D    65_A      Q      75          2.499
LGA    L    66_A      S      76          1.330
LGA    W    67_A      C      77          1.295
LGA    V    68_A      I      78          1.604
LGA    A    69_A      V      79          1.930
LGA    S    70_A      C      80          2.032
LGA    P    71_A      P      81          1.991
LGA    L    72_A      W      82          1.444
LGA    K    73_A      H      83          1.910
LGA    K    74_A      K      84          1.199
LGA    Q    75_A      Y      85          1.484
LGA    H    76_A      K      86          1.140
LGA    F    77_A      I      87          0.680
LGA    R    78_A      T      88          0.606
LGA    L    79_A      L      89          0.283
LGA    Y    80_A      A      90          1.340
LGA    D    81_A      T      91          0.598
LGA    G    82_A      G      92          0.360
LGA    F    83_A      E      93          0.965
LGA    C    84_A      G      94          0.756
LGA    L    85_A      L      95          0.507
LGA    E    86_A      Y      96          3.798
LGA    -       -      Q      97           -
LGA    -       -      S      98           -
LGA    -       -      I      99           -
LGA    -       -      N     100           -
LGA    -       -      P     101           -
LGA    -       -      K     107           -
LGA    -       -      P     108           -
LGA    -       -      K     109           -
LGA    -       -      W     110           -
LGA    -       -      C     111           -
LGA    -       -      S     112           -
LGA    D    87_A      K     113          3.521
LGA    G    88_A      G     114          5.274
LGA    A    89_A      -       -           -
LGA    Y    90_A      -       -           -
LGA    S    91_A      V     115          4.960
LGA    -       -      K     116           -
LGA    V    92_A      Q     117          0.894
LGA    A    93_A      R     118          0.298
LGA    A    94_A      I     119          0.573
LGA    Y    95_A      H     120          1.511
LGA    D    96_A      T     121          1.729
LGA    T    97_A      V     122          1.515
LGA    Q    98_A      K     123          0.948
LGA    V    99_A      V     124          0.754
LGA    T   100_A      D     125          1.094
LGA    N   101_A      N     126          1.451
LGA    G   102_A      G     127          1.206
LGA    N   103_A      N     128          1.418
LGA    V   104_A      I     129          1.404
LGA    Q   105_A      Y     130          1.127
LGA    I   106_A      V     131          2.022
LGA    S   107_A      T     132          2.051
LGA    I   108_A      L     133          2.778
LGA    A   109_A      S     134          4.464
LGA    D   110_A      -       -           -
LGA    S   111_A      K     135           #
LGA    -       -      E     136           -
LGA    -       -      P     137           -
LGA    -       -      F     138           -
LGA    -       -      K     139           -
LGA    -       -      C     140           -
LGA    -       -      D     141           -
LGA    -       -      S     142           -
LGA    D   112_A      D     143          5.817
LGA    V   113_A      Y     144           -
LGA    -       -      Y     145           -
LGA    -       -      A     146           -
LGA    -       -      T     147           -
LGA    A   114_A      G     148          3.046
LGA    V   115_A      E     149           #
LGA    D   116_A      F     150           -
LGA    N   117_A      K     151           -
LGA    S   118_A      V     152           -
LGA    Q   119_A      I     153           -
LGA    P   120_A      Q     154           -
LGA    L   121_A      -       -           -
LGA    P   122_A      -       -           -
LGA    L   123_A      -       -           -
LGA    E   124_A      -       -           -
LGA    H   125_A      -       -           -
LGA    H   126_A      -       -           -
LGA    H   127_A      -       -           -
LGA    H   128_A      -       -           -
LGA    H   129_A      -       -           -
LGA    H   130_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  130  136    5.0    100    2.37    20.00     53.837     4.045

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.709644 * X  +   0.662249 * Y  +  -0.240482 * Z  +  11.745957
  Y_new =   0.114205 * X  +   0.444930 * Y  +   0.888254 * Z  + -14.287235
  Z_new =   0.695243 * X  +   0.602880 * Y  +  -0.391374 * Z  +   8.987951 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.146591   -0.995002  [ DEG:   122.9906    -57.0094 ]
  Theta =  -0.768758   -2.372835  [ DEG:   -44.0466   -135.9534 ]
  Phi   =   2.982028   -0.159565  [ DEG:   170.8576     -9.1424 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2jza_A                                        
REMARK     2: T0391.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2jza_A.T0391.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  130  136   5.0  100   2.37   20.00  53.837
REMARK  ---------------------------------------------------------- 
MOLECULE 2jza_A
HEADER    OXIDOREDUCTASE                          31-DEC-07   2JZA              
TITLE     SOLUTION NMR STRUCTURE OF NITRITE REDUCTASE [NAD(P)H] SMALL           
TITLE    2 SUBUNIT FROM ERWINIA CAROTOVORA. NORTHEAST STRUCTURAL                
TITLE    3 GENOMICS CONSORTIUM TARGET EWR120                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NITRITE REDUCTASE [NAD(P)H] SMALL SUBUNIT;                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 1.7.1.4;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ERWINIA CAROTOVORA SUBSP. ATROSEPTICA           
SOURCE   3 SCRI1043;                                                            
SOURCE   4 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   5 GENUS: /;                                                            
SOURCE   6 STRAIN: SCRI 1043;                                                   
SOURCE   7 ATCC: BAA-672;                                                       
SOURCE   8 GENE: NIRD, ECA4080;                                                 
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE  11 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  12 EXPRESSION_SYSTEM_PLASMID: PET21-23C                                 
KEYWDS    ISP DOMAIN, RIESKE IRON-SULFUR PROTEIN, 3-LAYER BETA-                 
KEYWDS   2 SANDWICH, STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE              
KEYWDS   3 INITIATIVE, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM, NESG,          
KEYWDS   4 NIRD, OXIDOREDUCTASE                                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    B.SATHYAMOORTHY,A.ELETSKY,D.WANG,K.STOKES,L.OWENS,R.XIAO,             
AUTHOR   2 J.LIU,M.C.BARAN,G.V.T.SWAPNA,T.B.ACTON,B.ROST,                       
AUTHOR   3 G.T.MONTELIONE,T.SZYPERSKI,NORTHEAST STRUCTURAL GENOMICS             
AUTHOR   4 CONSORTIUM (NESG)                                                    
REVDAT   2   18-MAR-08 2JZA    1       AUTHOR JRNL                              
REVDAT   1   22-JAN-08 2JZA    0                                                
JRNL        AUTH   B.SATHYAMOORTHY,A.ELETSKY,D.WANG,K.STOKES,L.OWENS,           
JRNL        AUTH 2 R.XIAO,J.LIU,M.C.BARAN,G.V.T.SWAPNA,T.B.ACTON,               
JRNL        AUTH 3 B.ROST,G.T.MONTELIONE,T.SZYPERSKI                            
JRNL        TITL   SOLUTION NMR STRUCTURE OF NITRITE REDUCTASE                  
JRNL        TITL 2 [NAD(P)H] SMALL SUBUNIT FROM ERWINIA CAROTOVORA.             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JZA A    1   122  UNP    Q6CZS1   Q6CZS1_ERWCT     1    122             
SEQRES   1 A  130  MET SER GLN TRP THR THR VAL CYS LYS LEU ASP ASP ILE          
SEQRES   2 A  130  LEU PRO GLY THR GLY VAL CYS ALA LEU VAL GLU GLN GLN          
SEQRES   3 A  130  GLN ILE ALA VAL PHE ARG PRO ARG ASN ASP GLU GLN VAL          
SEQRES   4 A  130  TYR ALA ILE SER ASN ILE ASP PRO PHE ALA GLN ALA SER          
SEQRES   5 A  130  VAL LEU SER ARG GLY ILE VAL ALA GLU HIS GLN ASP ASP          
SEQRES   6 A  130  LEU TRP VAL ALA SER PRO LEU LYS LYS GLN HIS PHE ARG          
SEQRES   7 A  130  LEU TYR ASP GLY PHE CYS LEU GLU ASP GLY ALA TYR SER          
SEQRES   8 A  130  VAL ALA ALA TYR ASP THR GLN VAL THR ASN GLY ASN VAL          
SEQRES   9 A  130  GLN ILE SER ILE ALA ASP SER ASP VAL ALA VAL ASP ASN          
SEQRES  10 A  130  SER GLN PRO LEU PRO LEU GLU HIS HIS HIS HIS HIS HIS          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      19.848 -13.463 -12.359  1.00 24.05           N  
ATOM      2  CA  MET A   1      19.159 -14.507 -11.564  1.00 74.41           C  
ATOM      3  C   MET A   1      19.586 -15.898 -12.018  1.00 34.42           C  
ATOM      4  O   MET A   1      19.200 -16.357 -13.093  1.00 33.31           O  
ATOM      5  CB  MET A   1      17.640 -14.370 -11.707  1.00 70.42           C  
ATOM      6  CG  MET A   1      16.861 -15.416 -10.926  1.00  3.40           C  
ATOM      7  SD  MET A   1      15.104 -15.429 -11.331  1.00  2.11           S  
ATOM      8  CE  MET A   1      15.157 -15.912 -13.058  1.00 65.30           C  
ATOM      9  H1  MET A   1      19.533 -13.501 -13.353  1.00 37.86           H  
ATOM     10  H2  MET A   1      20.879 -13.619 -12.332  1.00 37.86           H  
ATOM     11  H3  MET A   1      19.644 -12.518 -11.972  1.00 37.86           H  
ATOM     12  HA  MET A   1      19.430 -14.379 -10.528  1.00 51.22           H  
ATOM     13  HB2 MET A   1      17.342 -13.394 -11.352  1.00 37.86           H  
ATOM     14  HB3 MET A   1      17.376 -14.460 -12.750  1.00 37.86           H  
ATOM     15  HG2 MET A   1      17.274 -16.389 -11.145  1.00 37.86           H  
ATOM     16  HG3 MET A   1      16.972 -15.209  -9.871  1.00 37.86           H  
ATOM     17  HE1 MET A   1      15.729 -15.187 -13.618  1.00 37.86           H  
ATOM     18  HE2 MET A   1      14.151 -15.955 -13.447  1.00 37.86           H  
ATOM     19  HE3 MET A   1      15.618 -16.884 -13.147  1.00 37.86           H  
ATOM     20  N   SER A   2      20.393 -16.562 -11.204  1.00 52.24           N  
ATOM     21  CA  SER A   2      20.846 -17.909 -11.515  1.00 74.43           C  
ATOM     22  C   SER A   2      20.314 -18.902 -10.478  1.00 65.21           C  
ATOM     23  O   SER A   2      19.408 -19.687 -10.757  1.00  5.01           O  
ATOM     24  CB  SER A   2      22.381 -17.946 -11.574  1.00 41.41           C  
ATOM     25  OG  SER A   2      22.856 -19.221 -11.965  1.00 12.31           O  
ATOM     26  H   SER A   2      20.703 -16.131 -10.381  1.00 20.32           H  
ATOM     27  HA  SER A   2      20.451 -18.175 -12.486  1.00 53.54           H  
ATOM     28  HB2 SER A   2      22.728 -17.214 -12.288  1.00 37.86           H  
ATOM     29  HB3 SER A   2      22.779 -17.711 -10.599  1.00 37.86           H  
ATOM     30  HG  SER A   2      23.464 -19.123 -12.706  1.00 63.52           H  
ATOM     31  N   GLN A   3      20.855 -18.835  -9.268  1.00 25.04           N  
ATOM     32  CA  GLN A   3      20.429 -19.710  -8.180  1.00 73.01           C  
ATOM     33  C   GLN A   3      19.592 -18.925  -7.177  1.00 52.11           C  
ATOM     34  O   GLN A   3      19.442 -19.311  -6.016  1.00 40.44           O  
ATOM     35  CB  GLN A   3      21.649 -20.322  -7.494  1.00  1.30           C  
ATOM     36  CG  GLN A   3      22.659 -19.292  -7.015  1.00 42.03           C  
ATOM     37  CD  GLN A   3      23.835 -19.927  -6.309  1.00 53.31           C  
ATOM     38  OE1 GLN A   3      23.816 -20.117  -5.093  1.00 61.32           O  
ATOM     39  NE2 GLN A   3      24.871 -20.257  -7.063  1.00 33.54           N  
ATOM     40  H   GLN A   3      21.564 -18.184  -9.100  1.00 74.23           H  
ATOM     41  HA  GLN A   3      19.825 -20.499  -8.600  1.00  2.54           H  
ATOM     42  HB2 GLN A   3      21.320 -20.895  -6.641  1.00 37.86           H  
ATOM     43  HB3 GLN A   3      22.146 -20.982  -8.191  1.00 37.86           H  
ATOM     44  HG2 GLN A   3      23.025 -18.744  -7.871  1.00 37.86           H  
ATOM     45  HG3 GLN A   3      22.168 -18.613  -6.335  1.00 37.86           H  
ATOM     46 HE21 GLN A   3      24.819 -20.076  -8.026  1.00 37.86           H  
ATOM     47 HE22 GLN A   3      25.643 -20.677  -6.630  1.00 37.86           H  
ATOM     48  N   TRP A   4      19.036 -17.826  -7.654  1.00 52.41           N  
ATOM     49  CA  TRP A   4      18.269 -16.920  -6.820  1.00 13.43           C  
ATOM     50  C   TRP A   4      16.781 -17.199  -6.972  1.00 70.23           C  
ATOM     51  O   TRP A   4      16.209 -16.987  -8.041  1.00 54.41           O  
ATOM     52  CB  TRP A   4      18.585 -15.478  -7.206  1.00 23.42           C  
ATOM     53  CG  TRP A   4      20.042 -15.153  -7.088  1.00 62.42           C  
ATOM     54  CD1 TRP A   4      21.018 -15.399  -8.012  1.00 44.04           C  
ATOM     55  CD2 TRP A   4      20.688 -14.519  -5.984  1.00 31.35           C  
ATOM     56  NE1 TRP A   4      22.230 -14.957  -7.543  1.00 41.44           N  
ATOM     57  CE2 TRP A   4      22.054 -14.409  -6.302  1.00 53.23           C  
ATOM     58  CE3 TRP A   4      20.239 -14.031  -4.759  1.00 44.35           C  
ATOM     59  CZ2 TRP A   4      22.974 -13.833  -5.434  1.00 72.54           C  
ATOM     60  CZ3 TRP A   4      21.154 -13.457  -3.896  1.00 15.54           C  
ATOM     61  CH2 TRP A   4      22.508 -13.360  -4.239  1.00 30.11           C  
ATOM     62  H   TRP A   4      19.133 -17.628  -8.605  1.00 42.11           H  
ATOM     63  HA  TRP A   4      18.558 -17.081  -5.791  1.00 11.43           H  
ATOM     64  HB2 TRP A   4      18.285 -15.311  -8.230  1.00 37.86           H  
ATOM     65  HB3 TRP A   4      18.038 -14.807  -6.560  1.00 37.86           H  
ATOM     66  HD1 TRP A   4      20.847 -15.872  -8.966  1.00 61.31           H  
ATOM     67  HE1 TRP A   4      23.091 -15.021  -8.027  1.00 33.52           H  
ATOM     68  HE3 TRP A   4      19.198 -14.105  -4.476  1.00 23.23           H  
ATOM     69  HZ2 TRP A   4      24.020 -13.752  -5.683  1.00 11.24           H  
ATOM     70  HZ3 TRP A   4      20.823 -13.075  -2.941  1.00 64.34           H  
ATOM     71  HH2 TRP A   4      23.188 -12.905  -3.533  1.00 44.15           H  
ATOM     72  N   THR A   5      16.170 -17.695  -5.912  1.00 40.24           N  
ATOM     73  CA  THR A   5      14.764 -18.046  -5.936  1.00 52.14           C  
ATOM     74  C   THR A   5      13.920 -16.939  -5.311  1.00 54.11           C  
ATOM     75  O   THR A   5      14.299 -16.365  -4.289  1.00 44.23           O  
ATOM     76  CB  THR A   5      14.529 -19.369  -5.188  1.00 31.12           C  
ATOM     77  OG1 THR A   5      15.426 -20.364  -5.689  1.00 73.33           O  
ATOM     78  CG2 THR A   5      13.095 -19.850  -5.352  1.00 42.32           C  
ATOM     79  H   THR A   5      16.683 -17.829  -5.084  1.00 65.02           H  
ATOM     80  HA  THR A   5      14.470 -18.177  -6.966  1.00  1.44           H  
ATOM     81  HB  THR A   5      14.724 -19.214  -4.137  1.00 34.13           H  
ATOM     82  HG1 THR A   5      15.391 -20.372  -6.659  1.00 11.33           H  
ATOM     83 HG21 THR A   5      12.976 -20.800  -4.854  1.00 37.86           H  
ATOM     84 HG22 THR A   5      12.870 -19.963  -6.402  1.00 37.86           H  
ATOM     85 HG23 THR A   5      12.420 -19.127  -4.915  1.00 37.86           H  
ATOM     86  N   THR A   6      12.792 -16.636  -5.935  1.00 53.20           N  
ATOM     87  CA  THR A   6      11.901 -15.597  -5.455  1.00 11.55           C  
ATOM     88  C   THR A   6      11.195 -16.038  -4.176  1.00 20.41           C  
ATOM     89  O   THR A   6      10.667 -17.148  -4.101  1.00 12.13           O  
ATOM     90  CB  THR A   6      10.847 -15.259  -6.523  1.00 62.43           C  
ATOM     91  OG1 THR A   6      11.465 -15.215  -7.815  1.00 24.24           O  
ATOM     92  CG2 THR A   6      10.187 -13.920  -6.230  1.00 20.11           C  
ATOM     93  H   THR A   6      12.547 -17.130  -6.751  1.00 10.41           H  
ATOM     94  HA  THR A   6      12.484 -14.712  -5.254  1.00 65.31           H  
ATOM     95  HB  THR A   6      10.089 -16.027  -6.518  1.00 21.31           H  
ATOM     96  HG1 THR A   6      11.526 -16.115  -8.175  1.00  5.12           H  
ATOM     97 HG21 THR A   6       9.731 -13.953  -5.252  1.00 37.86           H  
ATOM     98 HG22 THR A   6       9.431 -13.719  -6.976  1.00 37.86           H  
ATOM     99 HG23 THR A   6      10.933 -13.141  -6.253  1.00 37.86           H  
ATOM    100  N   VAL A   7      11.201 -15.177  -3.169  1.00 21.00           N  
ATOM    101  CA  VAL A   7      10.508 -15.467  -1.923  1.00 22.23           C  
ATOM    102  C   VAL A   7       9.056 -15.016  -2.020  1.00 23.25           C  
ATOM    103  O   VAL A   7       8.143 -15.838  -2.097  1.00 30.34           O  
ATOM    104  CB  VAL A   7      11.176 -14.766  -0.720  1.00 24.31           C  
ATOM    105  CG1 VAL A   7      10.515 -15.187   0.584  1.00  3.33           C  
ATOM    106  CG2 VAL A   7      12.667 -15.062  -0.682  1.00 62.12           C  
ATOM    107  H   VAL A   7      11.683 -14.324  -3.266  1.00 64.44           H  
ATOM    108  HA  VAL A   7      10.538 -16.535  -1.760  1.00 35.15           H  
ATOM    109  HB  VAL A   7      11.046 -13.698  -0.836  1.00  1.53           H  
ATOM    110 HG11 VAL A   7      10.980 -14.666   1.407  1.00 37.86           H  
ATOM    111 HG12 VAL A   7      10.631 -16.252   0.720  1.00 37.86           H  
ATOM    112 HG13 VAL A   7       9.464 -14.942   0.549  1.00 37.86           H  
ATOM    113 HG21 VAL A   7      13.105 -14.591   0.186  1.00 37.86           H  
ATOM    114 HG22 VAL A   7      13.134 -14.676  -1.577  1.00 37.86           H  
ATOM    115 HG23 VAL A   7      12.820 -16.129  -0.628  1.00 37.86           H  
ATOM    116  N   CYS A   8       8.858 -13.703  -2.031  1.00 73.40           N  
ATOM    117  CA  CYS A   8       7.529 -13.113  -2.133  1.00 25.24           C  
ATOM    118  C   CYS A   8       7.628 -11.721  -2.742  1.00 14.04           C  
ATOM    119  O   CYS A   8       8.728 -11.247  -3.044  1.00  1.32           O  
ATOM    120  CB  CYS A   8       6.856 -13.023  -0.758  1.00 42.23           C  
ATOM    121  SG  CYS A   8       6.475 -14.624  -0.005  1.00 32.11           S  
ATOM    122  H   CYS A   8       9.633 -13.107  -1.978  1.00 11.34           H  
ATOM    123  HA  CYS A   8       6.933 -13.738  -2.780  1.00 22.23           H  
ATOM    124  HB2 CYS A   8       7.508 -12.492  -0.083  1.00 37.86           H  
ATOM    125  HB3 CYS A   8       5.930 -12.477  -0.858  1.00 37.86           H  
ATOM    126  HG  CYS A   8       7.007 -15.565  -0.774  1.00 52.32           H  
ATOM    127  N   LYS A   9       6.484 -11.071  -2.924  1.00 14.11           N  
ATOM    128  CA  LYS A   9       6.463  -9.710  -3.435  1.00 33.41           C  
ATOM    129  C   LYS A   9       6.823  -8.743  -2.320  1.00 34.21           C  
ATOM    130  O   LYS A   9       6.454  -8.957  -1.167  1.00  5.02           O  
ATOM    131  CB  LYS A   9       5.085  -9.348  -3.992  1.00 75.34           C  
ATOM    132  CG  LYS A   9       4.519 -10.369  -4.959  1.00 65.14           C  
ATOM    133  CD  LYS A   9       3.257  -9.853  -5.624  1.00 33.14           C  
ATOM    134  CE  LYS A   9       2.488 -10.973  -6.298  1.00 22.31           C  
ATOM    135  NZ  LYS A   9       1.910 -11.920  -5.304  1.00 44.42           N  
ATOM    136  H   LYS A   9       5.638 -11.512  -2.702  1.00 12.02           H  
ATOM    137  HA  LYS A   9       7.198  -9.635  -4.222  1.00 14.21           H  
ATOM    138  HB2 LYS A   9       4.394  -9.244  -3.168  1.00 37.86           H  
ATOM    139  HB3 LYS A   9       5.160  -8.401  -4.505  1.00 37.86           H  
ATOM    140  HG2 LYS A   9       5.255 -10.575  -5.721  1.00 37.86           H  
ATOM    141  HG3 LYS A   9       4.288 -11.278  -4.422  1.00 37.86           H  
ATOM    142  HD2 LYS A   9       2.627  -9.398  -4.873  1.00 37.86           H  
ATOM    143  HD3 LYS A   9       3.531  -9.118  -6.364  1.00 37.86           H  
ATOM    144  HE2 LYS A   9       1.688 -10.544  -6.884  1.00 37.86           H  
ATOM    145  HE3 LYS A   9       3.159 -11.515  -6.949  1.00 37.86           H  
ATOM    146  HZ1 LYS A   9       1.136 -11.459  -4.777  1.00 37.86           H  
ATOM    147  HZ2 LYS A   9       2.642 -12.219  -4.624  1.00 37.86           H  
ATOM    148  HZ3 LYS A   9       1.536 -12.766  -5.785  1.00 37.86           H  
ATOM    149  N   LEU A  10       7.537  -7.685  -2.668  1.00 11.11           N  
ATOM    150  CA  LEU A  10       7.936  -6.673  -1.701  1.00 10.45           C  
ATOM    151  C   LEU A  10       6.715  -5.968  -1.123  1.00 30.34           C  
ATOM    152  O   LEU A  10       6.660  -5.661   0.066  1.00 33.41           O  
ATOM    153  CB  LEU A  10       8.845  -5.646  -2.376  1.00 71.22           C  
ATOM    154  CG  LEU A  10       9.320  -4.502  -1.483  1.00 71.31           C  
ATOM    155  CD1 LEU A  10      10.338  -5.003  -0.471  1.00  5.11           C  
ATOM    156  CD2 LEU A  10       9.894  -3.378  -2.329  1.00 50.02           C  
ATOM    157  H   LEU A  10       7.801  -7.576  -3.609  1.00  0.21           H  
ATOM    158  HA  LEU A  10       8.479  -7.159  -0.904  1.00 12.31           H  
ATOM    159  HB2 LEU A  10       9.714  -6.162  -2.757  1.00 37.86           H  
ATOM    160  HB3 LEU A  10       8.308  -5.220  -3.210  1.00 37.86           H  
ATOM    161  HG  LEU A  10       8.473  -4.110  -0.936  1.00 61.52           H  
ATOM    162 HD11 LEU A  10       9.879  -5.749   0.164  1.00 37.86           H  
ATOM    163 HD12 LEU A  10      10.680  -4.179   0.135  1.00 37.86           H  
ATOM    164 HD13 LEU A  10      11.178  -5.440  -0.991  1.00 37.86           H  
ATOM    165 HD21 LEU A  10      10.715  -3.757  -2.919  1.00 37.86           H  
ATOM    166 HD22 LEU A  10      10.252  -2.588  -1.684  1.00 37.86           H  
ATOM    167 HD23 LEU A  10       9.128  -2.990  -2.984  1.00 37.86           H  
ATOM    168  N   ASP A  11       5.729  -5.743  -1.979  1.00 25.21           N  
ATOM    169  CA  ASP A  11       4.551  -4.960  -1.626  1.00 14.23           C  
ATOM    170  C   ASP A  11       3.633  -5.739  -0.698  1.00 53.34           C  
ATOM    171  O   ASP A  11       2.981  -5.162   0.172  1.00 41.33           O  
ATOM    172  CB  ASP A  11       3.789  -4.547  -2.885  1.00 41.41           C  
ATOM    173  CG  ASP A  11       2.588  -3.681  -2.577  1.00 22.12           C  
ATOM    174  OD1 ASP A  11       2.780  -2.479  -2.293  1.00 54.03           O  
ATOM    175  OD2 ASP A  11       1.450  -4.192  -2.627  1.00 63.11           O  
ATOM    176  H   ASP A  11       5.790  -6.126  -2.879  1.00 41.33           H  
ATOM    177  HA  ASP A  11       4.887  -4.073  -1.114  1.00  2.44           H  
ATOM    178  HB2 ASP A  11       4.450  -3.990  -3.531  1.00 37.86           H  
ATOM    179  HB3 ASP A  11       3.448  -5.435  -3.400  1.00 37.86           H  
ATOM    180  N   ASP A  12       3.597  -7.054  -0.876  1.00 23.12           N  
ATOM    181  CA  ASP A  12       2.777  -7.910  -0.030  1.00 70.44           C  
ATOM    182  C   ASP A  12       3.341  -7.964   1.377  1.00 23.00           C  
ATOM    183  O   ASP A  12       2.655  -8.363   2.320  1.00 43.13           O  
ATOM    184  CB  ASP A  12       2.665  -9.324  -0.602  1.00 32.15           C  
ATOM    185  CG  ASP A  12       1.675  -9.415  -1.744  1.00 32.25           C  
ATOM    186  OD1 ASP A  12       0.551  -8.884  -1.610  1.00 31.31           O  
ATOM    187  OD2 ASP A  12       2.002 -10.036  -2.774  1.00 72.24           O  
ATOM    188  H   ASP A  12       4.138  -7.457  -1.586  1.00 63.12           H  
ATOM    189  HA  ASP A  12       1.788  -7.474   0.014  1.00 73.25           H  
ATOM    190  HB2 ASP A  12       3.633  -9.634  -0.965  1.00 37.86           H  
ATOM    191  HB3 ASP A  12       2.346  -9.997   0.181  1.00 37.86           H  
ATOM    192  N   ILE A  13       4.592  -7.558   1.523  1.00 70.11           N  
ATOM    193  CA  ILE A  13       5.215  -7.521   2.835  1.00 25.51           C  
ATOM    194  C   ILE A  13       4.971  -6.163   3.484  1.00 33.01           C  
ATOM    195  O   ILE A  13       5.463  -5.139   3.012  1.00 50.34           O  
ATOM    196  CB  ILE A  13       6.733  -7.806   2.766  1.00 41.25           C  
ATOM    197  CG1 ILE A  13       6.997  -9.127   2.029  1.00 13.33           C  
ATOM    198  CG2 ILE A  13       7.333  -7.849   4.169  1.00 10.41           C  
ATOM    199  CD1 ILE A  13       6.353 -10.331   2.684  1.00 33.41           C  
ATOM    200  H   ILE A  13       5.101  -7.263   0.731  1.00 64.04           H  
ATOM    201  HA  ILE A  13       4.750  -8.285   3.443  1.00 20.13           H  
ATOM    202  HB  ILE A  13       7.203  -7.000   2.226  1.00 42.41           H  
ATOM    203 HG12 ILE A  13       6.610  -9.054   1.023  1.00 37.86           H  
ATOM    204 HG13 ILE A  13       8.063  -9.303   1.987  1.00 37.86           H  
ATOM    205 HG21 ILE A  13       6.828  -8.601   4.758  1.00 37.86           H  
ATOM    206 HG22 ILE A  13       7.214  -6.884   4.641  1.00 37.86           H  
ATOM    207 HG23 ILE A  13       8.385  -8.089   4.105  1.00 37.86           H  
ATOM    208 HD11 ILE A  13       5.283 -10.191   2.721  1.00 37.86           H  
ATOM    209 HD12 ILE A  13       6.736 -10.441   3.687  1.00 37.86           H  
ATOM    210 HD13 ILE A  13       6.581 -11.217   2.112  1.00 37.86           H  
ATOM    211  N   LEU A  14       4.183  -6.158   4.547  1.00 62.44           N  
ATOM    212  CA  LEU A  14       3.846  -4.929   5.248  1.00 34.14           C  
ATOM    213  C   LEU A  14       5.066  -4.345   5.952  1.00 72.53           C  
ATOM    214  O   LEU A  14       5.811  -5.067   6.618  1.00  5.42           O  
ATOM    215  CB  LEU A  14       2.738  -5.194   6.268  1.00 33.04           C  
ATOM    216  CG  LEU A  14       1.398  -5.637   5.676  1.00 74.34           C  
ATOM    217  CD1 LEU A  14       0.398  -5.937   6.781  1.00 52.52           C  
ATOM    218  CD2 LEU A  14       0.852  -4.570   4.740  1.00 21.51           C  
ATOM    219  H   LEU A  14       3.813  -7.003   4.869  1.00 72.21           H  
ATOM    220  HA  LEU A  14       3.489  -4.219   4.517  1.00 73.41           H  
ATOM    221  HB2 LEU A  14       3.080  -5.961   6.946  1.00 37.86           H  
ATOM    222  HB3 LEU A  14       2.573  -4.290   6.829  1.00 37.86           H  
ATOM    223  HG  LEU A  14       1.546  -6.543   5.105  1.00 64.10           H  
ATOM    224 HD11 LEU A  14       0.223  -5.041   7.359  1.00 37.86           H  
ATOM    225 HD12 LEU A  14       0.791  -6.709   7.425  1.00 37.86           H  
ATOM    226 HD13 LEU A  14      -0.531  -6.271   6.343  1.00 37.86           H  
ATOM    227 HD21 LEU A  14       1.551  -4.403   3.934  1.00 37.86           H  
ATOM    228 HD22 LEU A  14       0.710  -3.650   5.288  1.00 37.86           H  
ATOM    229 HD23 LEU A  14      -0.095  -4.896   4.334  1.00 37.86           H  
ATOM    230  N   PRO A  15       5.287  -3.027   5.805  1.00 74.04           N  
ATOM    231  CA  PRO A  15       6.390  -2.326   6.472  1.00 33.22           C  
ATOM    232  C   PRO A  15       6.361  -2.517   7.988  1.00  4.00           C  
ATOM    233  O   PRO A  15       5.310  -2.406   8.626  1.00 24.23           O  
ATOM    234  CB  PRO A  15       6.161  -0.855   6.105  1.00 40.21           C  
ATOM    235  CG  PRO A  15       5.359  -0.901   4.851  1.00 15.13           C  
ATOM    236  CD  PRO A  15       4.485  -2.118   4.966  1.00 32.42           C  
ATOM    237  HA  PRO A  15       7.347  -2.649   6.092  1.00 22.33           H  
ATOM    238  HB2 PRO A  15       5.625  -0.360   6.902  1.00 37.86           H  
ATOM    239  HB3 PRO A  15       7.114  -0.369   5.948  1.00 37.86           H  
ATOM    240  HG2 PRO A  15       4.755  -0.009   4.768  1.00 37.86           H  
ATOM    241  HG3 PRO A  15       6.015  -0.991   3.999  1.00 37.86           H  
ATOM    242  HD2 PRO A  15       3.550  -1.868   5.447  1.00 37.86           H  
ATOM    243  HD3 PRO A  15       4.309  -2.549   3.993  1.00 37.86           H  
ATOM    244  N   GLY A  16       7.519  -2.831   8.547  1.00 62.14           N  
ATOM    245  CA  GLY A  16       7.633  -3.085   9.968  1.00 53.23           C  
ATOM    246  C   GLY A  16       7.182  -4.486  10.326  1.00 63.23           C  
ATOM    247  O   GLY A  16       6.735  -4.732  11.447  1.00 10.20           O  
ATOM    248  H   GLY A  16       8.317  -2.909   7.978  1.00 32.12           H  
ATOM    249  HA2 GLY A  16       8.665  -2.958  10.265  1.00 37.86           H  
ATOM    250  HA3 GLY A  16       7.022  -2.374  10.503  1.00 37.86           H  
ATOM    251  N   THR A  17       7.311  -5.417   9.378  1.00 74.22           N  
ATOM    252  CA  THR A  17       6.768  -6.761   9.563  1.00  4.11           C  
ATOM    253  C   THR A  17       7.600  -7.788   8.797  1.00 45.43           C  
ATOM    254  O   THR A  17       8.545  -7.428   8.095  1.00 14.42           O  
ATOM    255  CB  THR A  17       5.296  -6.839   9.083  1.00 15.33           C  
ATOM    256  OG1 THR A  17       4.633  -5.588   9.323  1.00 32.43           O  
ATOM    257  CG2 THR A  17       4.537  -7.944   9.806  1.00 22.13           C  
ATOM    258  H   THR A  17       7.815  -5.206   8.547  1.00 51.03           H  
ATOM    259  HA  THR A  17       6.798  -6.994  10.618  1.00 13.21           H  
ATOM    260  HB  THR A  17       5.288  -7.049   8.024  1.00 40.44           H  
ATOM    261  HG1 THR A  17       5.031  -4.910   8.766  1.00 24.54           H  
ATOM    262 HG21 THR A  17       4.516  -7.731  10.864  1.00 37.86           H  
ATOM    263 HG22 THR A  17       5.030  -8.890   9.639  1.00 37.86           H  
ATOM    264 HG23 THR A  17       3.526  -7.993   9.428  1.00 37.86           H  
ATOM    265  N   GLY A  18       7.244  -9.060   8.933  1.00 74.30           N  
ATOM    266  CA  GLY A  18       7.942 -10.108   8.221  1.00  1.04           C  
ATOM    267  C   GLY A  18       7.468 -11.487   8.626  1.00 54.01           C  
ATOM    268  O   GLY A  18       7.384 -11.795   9.819  1.00 34.40           O  
ATOM    269  H   GLY A  18       6.502  -9.291   9.527  1.00 45.34           H  
ATOM    270  HA2 GLY A  18       7.779  -9.979   7.161  1.00 37.86           H  
ATOM    271  HA3 GLY A  18       8.999 -10.027   8.427  1.00 37.86           H  
ATOM    272  N   VAL A  19       7.147 -12.320   7.644  1.00 72.32           N  
ATOM    273  CA  VAL A  19       6.677 -13.671   7.919  1.00 61.35           C  
ATOM    274  C   VAL A  19       7.527 -14.702   7.192  1.00 32.23           C  
ATOM    275  O   VAL A  19       8.268 -14.361   6.268  1.00 71.13           O  
ATOM    276  CB  VAL A  19       5.190 -13.865   7.544  1.00 54.00           C  
ATOM    277  CG1 VAL A  19       4.296 -12.975   8.400  1.00 50.12           C  
ATOM    278  CG2 VAL A  19       4.963 -13.594   6.063  1.00 51.41           C  
ATOM    279  H   VAL A  19       7.243 -12.027   6.713  1.00  1.41           H  
ATOM    280  HA  VAL A  19       6.782 -13.835   8.978  1.00 22.20           H  
ATOM    281  HB  VAL A  19       4.923 -14.892   7.742  1.00 34.35           H  
ATOM    282 HG11 VAL A  19       4.456 -13.202   9.445  1.00 37.86           H  
ATOM    283 HG12 VAL A  19       3.262 -13.155   8.148  1.00 37.86           H  
ATOM    284 HG13 VAL A  19       4.537 -11.939   8.215  1.00 37.86           H  
ATOM    285 HG21 VAL A  19       5.222 -12.571   5.840  1.00 37.86           H  
ATOM    286 HG22 VAL A  19       3.925 -13.766   5.822  1.00 37.86           H  
ATOM    287 HG23 VAL A  19       5.584 -14.259   5.478  1.00 37.86           H  
ATOM    288  N   CYS A  20       7.443 -15.954   7.631  1.00 33.53           N  
ATOM    289  CA  CYS A  20       8.202 -17.022   7.011  1.00 63.40           C  
ATOM    290  C   CYS A  20       7.445 -17.631   5.840  1.00 31.35           C  
ATOM    291  O   CYS A  20       6.214 -17.725   5.855  1.00 42.13           O  
ATOM    292  CB  CYS A  20       8.519 -18.101   8.042  1.00 42.41           C  
ATOM    293  SG  CYS A  20       7.069 -18.725   8.921  1.00  4.04           S  
ATOM    294  H   CYS A  20       6.863 -16.170   8.402  1.00 52.32           H  
ATOM    295  HA  CYS A  20       9.130 -16.600   6.649  1.00  4.11           H  
ATOM    296  HB2 CYS A  20       8.986 -18.939   7.547  1.00 37.86           H  
ATOM    297  HB3 CYS A  20       9.201 -17.697   8.775  1.00 37.86           H  
ATOM    298  HG  CYS A  20       6.949 -20.017   8.643  1.00 23.43           H  
ATOM    299  N   ALA A  21       8.187 -18.018   4.821  1.00 52.32           N  
ATOM    300  CA  ALA A  21       7.631 -18.742   3.698  1.00 74.11           C  
ATOM    301  C   ALA A  21       8.451 -19.995   3.446  1.00 25.43           C  
ATOM    302  O   ALA A  21       9.658 -20.019   3.709  1.00 13.41           O  
ATOM    303  CB  ALA A  21       7.603 -17.857   2.460  1.00 15.12           C  
ATOM    304  H   ALA A  21       9.145 -17.799   4.818  1.00 44.03           H  
ATOM    305  HA  ALA A  21       6.616 -19.021   3.943  1.00 44.11           H  
ATOM    306  HB1 ALA A  21       7.149 -18.396   1.642  1.00 37.86           H  
ATOM    307  HB2 ALA A  21       8.612 -17.581   2.192  1.00 37.86           H  
ATOM    308  HB3 ALA A  21       7.028 -16.968   2.668  1.00 37.86           H  
ATOM    309  N   LEU A  22       7.796 -21.038   2.966  1.00 64.33           N  
ATOM    310  CA  LEU A  22       8.484 -22.274   2.632  1.00 13.45           C  
ATOM    311  C   LEU A  22       9.201 -22.089   1.301  1.00 42.42           C  
ATOM    312  O   LEU A  22       8.606 -22.241   0.237  1.00 62.24           O  
ATOM    313  CB  LEU A  22       7.482 -23.441   2.565  1.00 52.15           C  
ATOM    314  CG  LEU A  22       8.073 -24.858   2.681  1.00 21.23           C  
ATOM    315  CD1 LEU A  22       8.870 -25.241   1.441  1.00  2.20           C  
ATOM    316  CD2 LEU A  22       8.942 -24.970   3.924  1.00 60.03           C  
ATOM    317  H   LEU A  22       6.822 -20.974   2.826  1.00 40.34           H  
ATOM    318  HA  LEU A  22       9.215 -22.472   3.405  1.00 54.44           H  
ATOM    319  HB2 LEU A  22       6.766 -23.312   3.364  1.00 37.86           H  
ATOM    320  HB3 LEU A  22       6.955 -23.375   1.625  1.00 37.86           H  
ATOM    321  HG  LEU A  22       7.262 -25.566   2.782  1.00 23.54           H  
ATOM    322 HD11 LEU A  22       9.685 -24.545   1.308  1.00 37.86           H  
ATOM    323 HD12 LEU A  22       8.226 -25.212   0.575  1.00 37.86           H  
ATOM    324 HD13 LEU A  22       9.268 -26.239   1.562  1.00 37.86           H  
ATOM    325 HD21 LEU A  22       9.748 -24.252   3.866  1.00 37.86           H  
ATOM    326 HD22 LEU A  22       9.353 -25.967   3.986  1.00 37.86           H  
ATOM    327 HD23 LEU A  22       8.346 -24.769   4.802  1.00 37.86           H  
ATOM    328  N   VAL A  23      10.472 -21.727   1.372  1.00 64.14           N  
ATOM    329  CA  VAL A  23      11.255 -21.481   0.177  1.00 60.33           C  
ATOM    330  C   VAL A  23      12.034 -22.728  -0.215  1.00 70.21           C  
ATOM    331  O   VAL A  23      13.128 -22.982   0.305  1.00 42.44           O  
ATOM    332  CB  VAL A  23      12.232 -20.298   0.355  1.00  3.21           C  
ATOM    333  CG1 VAL A  23      12.967 -20.012  -0.945  1.00 40.24           C  
ATOM    334  CG2 VAL A  23      11.492 -19.059   0.835  1.00 14.34           C  
ATOM    335  H   VAL A  23      10.897 -21.628   2.251  1.00 13.40           H  
ATOM    336  HA  VAL A  23      10.570 -21.235  -0.622  1.00 35.24           H  
ATOM    337  HB  VAL A  23      12.962 -20.569   1.103  1.00 61.22           H  
ATOM    338 HG11 VAL A  23      13.533 -20.884  -1.237  1.00 37.86           H  
ATOM    339 HG12 VAL A  23      13.637 -19.177  -0.805  1.00 37.86           H  
ATOM    340 HG13 VAL A  23      12.252 -19.773  -1.717  1.00 37.86           H  
ATOM    341 HG21 VAL A  23      11.027 -19.265   1.789  1.00 37.86           H  
ATOM    342 HG22 VAL A  23      10.734 -18.790   0.115  1.00 37.86           H  
ATOM    343 HG23 VAL A  23      12.191 -18.242   0.945  1.00 37.86           H  
ATOM    344  N   GLU A  24      11.438 -23.511  -1.109  1.00 13.23           N  
ATOM    345  CA  GLU A  24      12.056 -24.715  -1.659  1.00 52.15           C  
ATOM    346  C   GLU A  24      12.295 -25.785  -0.589  1.00 32.24           C  
ATOM    347  O   GLU A  24      11.524 -26.740  -0.470  1.00 54.52           O  
ATOM    348  CB  GLU A  24      13.367 -24.366  -2.368  1.00  2.04           C  
ATOM    349  CG  GLU A  24      13.186 -23.412  -3.535  1.00 11.22           C  
ATOM    350  CD  GLU A  24      12.230 -23.950  -4.576  1.00 23.14           C  
ATOM    351  OE1 GLU A  24      12.603 -24.898  -5.298  1.00 13.55           O  
ATOM    352  OE2 GLU A  24      11.102 -23.429  -4.679  1.00 14.30           O  
ATOM    353  H   GLU A  24      10.538 -23.259  -1.424  1.00 60.23           H  
ATOM    354  HA  GLU A  24      11.372 -25.119  -2.391  1.00 54.03           H  
ATOM    355  HB2 GLU A  24      14.039 -23.909  -1.656  1.00 37.86           H  
ATOM    356  HB3 GLU A  24      13.816 -25.275  -2.741  1.00 37.86           H  
ATOM    357  HG2 GLU A  24      12.800 -22.475  -3.163  1.00 37.86           H  
ATOM    358  HG3 GLU A  24      14.147 -23.246  -4.001  1.00 37.86           H  
ATOM    359  N   GLN A  25      13.357 -25.618   0.189  1.00 12.23           N  
ATOM    360  CA  GLN A  25      13.735 -26.599   1.203  1.00 30.12           C  
ATOM    361  C   GLN A  25      13.744 -25.985   2.600  1.00 22.13           C  
ATOM    362  O   GLN A  25      13.651 -26.698   3.594  1.00 54.34           O  
ATOM    363  CB  GLN A  25      15.124 -27.186   0.912  1.00 42.14           C  
ATOM    364  CG  GLN A  25      15.134 -28.351  -0.071  1.00 70.24           C  
ATOM    365  CD  GLN A  25      15.642 -27.977  -1.455  1.00 25.23           C  
ATOM    366  OE1 GLN A  25      16.268 -28.790  -2.137  1.00 41.24           O  
ATOM    367  NE2 GLN A  25      15.367 -26.759  -1.887  1.00 55.01           N  
ATOM    368  H   GLN A  25      13.886 -24.795   0.097  1.00 72.22           H  
ATOM    369  HA  GLN A  25      13.006 -27.396   1.180  1.00 31.41           H  
ATOM    370  HB2 GLN A  25      15.751 -26.405   0.509  1.00 37.86           H  
ATOM    371  HB3 GLN A  25      15.554 -27.530   1.842  1.00 37.86           H  
ATOM    372  HG2 GLN A  25      15.769 -29.130   0.325  1.00 37.86           H  
ATOM    373  HG3 GLN A  25      14.126 -28.729  -0.166  1.00 37.86           H  
ATOM    374 HE21 GLN A  25      14.860 -26.165  -1.300  1.00 37.86           H  
ATOM    375 HE22 GLN A  25      15.667 -26.507  -2.790  1.00 37.86           H  
ATOM    376  N   GLN A  26      13.856 -24.668   2.677  1.00 71.05           N  
ATOM    377  CA  GLN A  26      14.071 -24.004   3.949  1.00 31.24           C  
ATOM    378  C   GLN A  26      13.044 -22.899   4.176  1.00 15.20           C  
ATOM    379  O   GLN A  26      12.607 -22.246   3.229  1.00 72.24           O  
ATOM    380  CB  GLN A  26      15.482 -23.415   3.972  1.00 25.53           C  
ATOM    381  CG  GLN A  26      16.582 -24.453   3.797  1.00 41.24           C  
ATOM    382  CD  GLN A  26      17.956 -23.841   3.599  1.00 52.14           C  
ATOM    383  OE1 GLN A  26      18.970 -24.430   3.968  1.00 53.12           O  
ATOM    384  NE2 GLN A  26      18.006 -22.658   3.006  1.00  4.04           N  
ATOM    385  H   GLN A  26      13.781 -24.123   1.866  1.00 43.25           H  
ATOM    386  HA  GLN A  26      13.983 -24.741   4.732  1.00 24.44           H  
ATOM    387  HB2 GLN A  26      15.568 -22.690   3.175  1.00 37.86           H  
ATOM    388  HB3 GLN A  26      15.630 -22.918   4.911  1.00 37.86           H  
ATOM    389  HG2 GLN A  26      16.609 -25.077   4.677  1.00 37.86           H  
ATOM    390  HG3 GLN A  26      16.347 -25.060   2.935  1.00 37.86           H  
ATOM    391 HE21 GLN A  26      17.163 -22.243   2.730  1.00 37.86           H  
ATOM    392 HE22 GLN A  26      18.883 -22.249   2.868  1.00 37.86           H  
ATOM    393  N   GLN A  27      12.656 -22.689   5.430  1.00 42.44           N  
ATOM    394  CA  GLN A  27      11.775 -21.580   5.767  1.00  2.51           C  
ATOM    395  C   GLN A  27      12.582 -20.300   5.925  1.00 14.00           C  
ATOM    396  O   GLN A  27      13.598 -20.274   6.622  1.00  2.14           O  
ATOM    397  CB  GLN A  27      10.982 -21.849   7.048  1.00 65.32           C  
ATOM    398  CG  GLN A  27       9.858 -22.857   6.877  1.00  5.25           C  
ATOM    399  CD  GLN A  27       8.784 -22.710   7.941  1.00  2.22           C  
ATOM    400  OE1 GLN A  27       7.832 -21.951   7.767  1.00  2.20           O  
ATOM    401  NE2 GLN A  27       8.922 -23.431   9.044  1.00 72.41           N  
ATOM    402  H   GLN A  27      12.973 -23.285   6.139  1.00 54.02           H  
ATOM    403  HA  GLN A  27      11.081 -21.452   4.947  1.00 25.31           H  
ATOM    404  HB2 GLN A  27      11.659 -22.223   7.802  1.00 37.86           H  
ATOM    405  HB3 GLN A  27      10.554 -20.920   7.392  1.00 37.86           H  
ATOM    406  HG2 GLN A  27       9.405 -22.713   5.907  1.00 37.86           H  
ATOM    407  HG3 GLN A  27      10.271 -23.853   6.936  1.00 37.86           H  
ATOM    408 HE21 GLN A  27       9.698 -24.022   9.123  1.00 37.86           H  
ATOM    409 HE22 GLN A  27       8.234 -23.341   9.741  1.00 37.86           H  
ATOM    410  N   ILE A  28      12.139 -19.247   5.260  1.00 24.21           N  
ATOM    411  CA  ILE A  28      12.828 -17.971   5.305  1.00 52.02           C  
ATOM    412  C   ILE A  28      11.858 -16.858   5.682  1.00 43.21           C  
ATOM    413  O   ILE A  28      10.749 -16.788   5.151  1.00 62.24           O  
ATOM    414  CB  ILE A  28      13.494 -17.657   3.945  1.00  5.41           C  
ATOM    415  CG1 ILE A  28      14.557 -18.713   3.616  1.00 22.53           C  
ATOM    416  CG2 ILE A  28      14.112 -16.269   3.952  1.00 32.51           C  
ATOM    417  CD1 ILE A  28      15.233 -18.512   2.276  1.00 34.35           C  
ATOM    418  H   ILE A  28      11.321 -19.330   4.721  1.00 74.54           H  
ATOM    419  HA  ILE A  28      13.602 -18.032   6.061  1.00 42.42           H  
ATOM    420  HB  ILE A  28      12.729 -17.680   3.183  1.00 32.51           H  
ATOM    421 HG12 ILE A  28      15.323 -18.691   4.376  1.00 37.86           H  
ATOM    422 HG13 ILE A  28      14.093 -19.690   3.609  1.00 37.86           H  
ATOM    423 HG21 ILE A  28      14.568 -16.074   2.992  1.00 37.86           H  
ATOM    424 HG22 ILE A  28      14.863 -16.214   4.725  1.00 37.86           H  
ATOM    425 HG23 ILE A  28      13.343 -15.535   4.143  1.00 37.86           H  
ATOM    426 HD11 ILE A  28      15.985 -19.274   2.133  1.00 37.86           H  
ATOM    427 HD12 ILE A  28      15.698 -17.537   2.251  1.00 37.86           H  
ATOM    428 HD13 ILE A  28      14.498 -18.580   1.487  1.00 37.86           H  
ATOM    429  N   ALA A  29      12.272 -16.015   6.615  1.00 32.30           N  
ATOM    430  CA  ALA A  29      11.460 -14.898   7.064  1.00 52.31           C  
ATOM    431  C   ALA A  29      11.985 -13.607   6.461  1.00 30.10           C  
ATOM    432  O   ALA A  29      13.196 -13.417   6.357  1.00 34.50           O  
ATOM    433  CB  ALA A  29      11.467 -14.820   8.579  1.00 70.15           C  
ATOM    434  H   ALA A  29      13.170 -16.131   6.999  1.00  1.20           H  
ATOM    435  HA  ALA A  29      10.444 -15.061   6.732  1.00 20.51           H  
ATOM    436  HB1 ALA A  29      12.478 -14.663   8.926  1.00 37.86           H  
ATOM    437  HB2 ALA A  29      11.084 -15.742   8.990  1.00 37.86           H  
ATOM    438  HB3 ALA A  29      10.842 -13.998   8.900  1.00 37.86           H  
ATOM    439  N   VAL A  30      11.085 -12.722   6.068  1.00 73.12           N  
ATOM    440  CA  VAL A  30      11.487 -11.499   5.374  1.00 53.22           C  
ATOM    441  C   VAL A  30      11.186 -10.259   6.207  1.00 74.02           C  
ATOM    442  O   VAL A  30      10.046  -9.810   6.272  1.00 45.02           O  
ATOM    443  CB  VAL A  30      10.780 -11.365   4.006  1.00  2.13           C  
ATOM    444  CG1 VAL A  30      11.280 -10.137   3.255  1.00 53.32           C  
ATOM    445  CG2 VAL A  30      10.984 -12.618   3.171  1.00 33.33           C  
ATOM    446  H   VAL A  30      10.128 -12.888   6.254  1.00 42.01           H  
ATOM    447  HA  VAL A  30      12.555 -11.551   5.201  1.00 45.30           H  
ATOM    448  HB  VAL A  30       9.721 -11.243   4.181  1.00 74.04           H  
ATOM    449 HG11 VAL A  30      12.342 -10.228   3.081  1.00 37.86           H  
ATOM    450 HG12 VAL A  30      11.085  -9.252   3.843  1.00 37.86           H  
ATOM    451 HG13 VAL A  30      10.766 -10.060   2.308  1.00 37.86           H  
ATOM    452 HG21 VAL A  30      10.573 -13.470   3.691  1.00 37.86           H  
ATOM    453 HG22 VAL A  30      12.041 -12.772   3.004  1.00 37.86           H  
ATOM    454 HG23 VAL A  30      10.484 -12.501   2.221  1.00 37.86           H  
ATOM    455  N   PHE A  31      12.215  -9.716   6.840  1.00 24.11           N  
ATOM    456  CA  PHE A  31      12.087  -8.488   7.611  1.00 63.41           C  
ATOM    457  C   PHE A  31      11.946  -7.298   6.675  1.00 14.10           C  
ATOM    458  O   PHE A  31      12.852  -7.023   5.888  1.00 62.10           O  
ATOM    459  CB  PHE A  31      13.326  -8.255   8.483  1.00 54.30           C  
ATOM    460  CG  PHE A  31      13.607  -9.315   9.510  1.00 31.25           C  
ATOM    461  CD1 PHE A  31      14.263 -10.485   9.162  1.00 71.21           C  
ATOM    462  CD2 PHE A  31      13.239  -9.125  10.831  1.00 74.34           C  
ATOM    463  CE1 PHE A  31      14.540 -11.447  10.111  1.00 62.10           C  
ATOM    464  CE2 PHE A  31      13.520 -10.082  11.785  1.00 15.42           C  
ATOM    465  CZ  PHE A  31      14.170 -11.245  11.423  1.00 54.44           C  
ATOM    466  H   PHE A  31      13.098 -10.152   6.777  1.00 71.40           H  
ATOM    467  HA  PHE A  31      11.211  -8.561   8.236  1.00 10.35           H  
ATOM    468  HB2 PHE A  31      14.191  -8.194   7.841  1.00 37.86           H  
ATOM    469  HB3 PHE A  31      13.211  -7.313   9.001  1.00 37.86           H  
ATOM    470  HD1 PHE A  31      14.554 -10.642   8.134  1.00  3.11           H  
ATOM    471  HD2 PHE A  31      12.727  -8.216  11.113  1.00  2.34           H  
ATOM    472  HE1 PHE A  31      15.049 -12.356   9.826  1.00 71.25           H  
ATOM    473  HE2 PHE A  31      13.228  -9.923  12.813  1.00 55.32           H  
ATOM    474  HZ  PHE A  31      14.391 -11.996  12.169  1.00 62.33           H  
ATOM    475  N   ARG A  32      10.829  -6.595   6.743  1.00 14.35           N  
ATOM    476  CA  ARG A  32      10.706  -5.351   6.005  1.00  5.35           C  
ATOM    477  C   ARG A  32      10.658  -4.176   6.962  1.00 72.23           C  
ATOM    478  O   ARG A  32       9.645  -3.941   7.605  1.00 72.24           O  
ATOM    479  CB  ARG A  32       9.484  -5.332   5.086  1.00 43.22           C  
ATOM    480  CG  ARG A  32       9.535  -4.176   4.097  1.00 51.21           C  
ATOM    481  CD  ARG A  32       8.388  -4.196   3.099  1.00 64.15           C  
ATOM    482  NE  ARG A  32       8.587  -3.201   2.041  1.00 54.43           N  
ATOM    483  CZ  ARG A  32       7.612  -2.696   1.282  1.00 70.54           C  
ATOM    484  NH1 ARG A  32       6.349  -3.067   1.457  1.00 74.34           N  
ATOM    485  NH2 ARG A  32       7.909  -1.817   0.334  1.00 41.34           N  
ATOM    486  H   ARG A  32      10.078  -6.918   7.293  1.00  1.51           H  
ATOM    487  HA  ARG A  32      11.586  -5.253   5.407  1.00 10.13           H  
ATOM    488  HB2 ARG A  32       9.442  -6.259   4.532  1.00 37.86           H  
ATOM    489  HB3 ARG A  32       8.591  -5.232   5.685  1.00 37.86           H  
ATOM    490  HG2 ARG A  32       9.498  -3.249   4.646  1.00 37.86           H  
ATOM    491  HG3 ARG A  32      10.470  -4.231   3.554  1.00 37.86           H  
ATOM    492  HD2 ARG A  32       8.329  -5.177   2.654  1.00 37.86           H  
ATOM    493  HD3 ARG A  32       7.467  -3.977   3.619  1.00 37.86           H  
ATOM    494  HE  ARG A  32       9.509  -2.898   1.884  1.00 41.02           H  
ATOM    495 HH11 ARG A  32       6.112  -3.743   2.165  1.00 37.86           H  
ATOM    496 HH12 ARG A  32       5.620  -2.678   0.877  1.00 37.86           H  
ATOM    497 HH21 ARG A  32       8.862  -1.537   0.182  1.00 37.86           H  
ATOM    498 HH22 ARG A  32       7.180  -1.417  -0.226  1.00 37.86           H  
ATOM    499  N   PRO A  33      11.770  -3.438   7.087  1.00 50.32           N  
ATOM    500  CA  PRO A  33      11.852  -2.276   7.975  1.00  3.30           C  
ATOM    501  C   PRO A  33      11.023  -1.098   7.464  1.00 74.25           C  
ATOM    502  O   PRO A  33      10.154  -0.584   8.167  1.00  3.04           O  
ATOM    503  CB  PRO A  33      13.347  -1.914   7.975  1.00  1.40           C  
ATOM    504  CG  PRO A  33      14.043  -3.065   7.326  1.00 51.51           C  
ATOM    505  CD  PRO A  33      13.041  -3.682   6.395  1.00  5.51           C  
ATOM    506  HA  PRO A  33      11.539  -2.525   8.981  1.00 71.45           H  
ATOM    507  HB2 PRO A  33      13.497  -1.001   7.418  1.00 37.86           H  
ATOM    508  HB3 PRO A  33      13.683  -1.776   8.993  1.00 37.86           H  
ATOM    509  HG2 PRO A  33      14.901  -2.711   6.774  1.00 37.86           H  
ATOM    510  HG3 PRO A  33      14.347  -3.779   8.076  1.00 37.86           H  
ATOM    511  HD2 PRO A  33      13.061  -3.187   5.434  1.00 37.86           H  
ATOM    512  HD3 PRO A  33      13.225  -4.740   6.283  1.00 37.86           H  
ATOM    513  N   ARG A  34      11.285  -0.688   6.227  1.00 64.34           N  
ATOM    514  CA  ARG A  34      10.607   0.460   5.633  1.00 31.54           C  
ATOM    515  C   ARG A  34       9.910   0.057   4.342  1.00 61.45           C  
ATOM    516  O   ARG A  34       9.904  -1.115   3.976  1.00 22.01           O  
ATOM    517  CB  ARG A  34      11.609   1.580   5.340  1.00 73.11           C  
ATOM    518  CG  ARG A  34      12.196   2.233   6.579  1.00 51.14           C  
ATOM    519  CD  ARG A  34      13.276   3.238   6.211  1.00 23.22           C  
ATOM    520  NE  ARG A  34      12.816   4.189   5.199  1.00 74.33           N  
ATOM    521  CZ  ARG A  34      13.613   4.758   4.295  1.00 72.12           C  
ATOM    522  NH1 ARG A  34      14.915   4.479   4.277  1.00 70.13           N  
ATOM    523  NH2 ARG A  34      13.097   5.598   3.403  1.00 52.21           N  
ATOM    524  H   ARG A  34      11.940  -1.182   5.693  1.00 61.25           H  
ATOM    525  HA  ARG A  34       9.870   0.818   6.337  1.00  5.32           H  
ATOM    526  HB2 ARG A  34      12.421   1.173   4.758  1.00 37.86           H  
ATOM    527  HB3 ARG A  34      11.112   2.345   4.759  1.00 37.86           H  
ATOM    528  HG2 ARG A  34      11.408   2.742   7.114  1.00 37.86           H  
ATOM    529  HG3 ARG A  34      12.627   1.469   7.208  1.00 37.86           H  
ATOM    530  HD2 ARG A  34      13.561   3.783   7.099  1.00 37.86           H  
ATOM    531  HD3 ARG A  34      14.132   2.703   5.827  1.00 37.86           H  
ATOM    532  HE  ARG A  34      11.855   4.414   5.193  1.00 34.00           H  
ATOM    533 HH11 ARG A  34      15.305   3.830   4.946  1.00 37.86           H  
ATOM    534 HH12 ARG A  34      15.522   4.915   3.601  1.00 37.86           H  
ATOM    535 HH21 ARG A  34      12.112   5.798   3.410  1.00 37.86           H  
ATOM    536 HH22 ARG A  34      13.691   6.041   2.717  1.00 37.86           H  
ATOM    537  N   ASN A  35       9.342   1.040   3.650  1.00 11.04           N  
ATOM    538  CA  ASN A  35       8.688   0.814   2.358  1.00 73.52           C  
ATOM    539  C   ASN A  35       9.732   0.710   1.240  1.00 71.21           C  
ATOM    540  O   ASN A  35       9.408   0.741   0.052  1.00 21.42           O  
ATOM    541  CB  ASN A  35       7.709   1.958   2.058  1.00 73.23           C  
ATOM    542  CG  ASN A  35       6.785   1.665   0.887  1.00 24.30           C  
ATOM    543  OD1 ASN A  35       6.398   0.520   0.651  1.00 72.01           O  
ATOM    544  ND2 ASN A  35       6.426   2.699   0.140  1.00 54.33           N  
ATOM    545  H   ASN A  35       9.344   1.950   4.027  1.00 14.35           H  
ATOM    546  HA  ASN A  35       8.143  -0.115   2.416  1.00 63.14           H  
ATOM    547  HB2 ASN A  35       7.099   2.135   2.931  1.00 37.86           H  
ATOM    548  HB3 ASN A  35       8.271   2.853   1.833  1.00 37.86           H  
ATOM    549 HD21 ASN A  35       6.771   3.591   0.381  1.00 37.86           H  
ATOM    550 HD22 ASN A  35       5.831   2.534  -0.624  1.00 37.86           H  
ATOM    551  N   ASP A  36      10.992   0.574   1.635  1.00  4.30           N  
ATOM    552  CA  ASP A  36      12.092   0.429   0.688  1.00 51.13           C  
ATOM    553  C   ASP A  36      12.093  -0.989   0.124  1.00 61.05           C  
ATOM    554  O   ASP A  36      11.265  -1.820   0.512  1.00 71.41           O  
ATOM    555  CB  ASP A  36      13.429   0.722   1.388  1.00 24.54           C  
ATOM    556  CG  ASP A  36      14.578   0.994   0.431  1.00 31.03           C  
ATOM    557  OD1 ASP A  36      15.181   0.032  -0.088  1.00 62.33           O  
ATOM    558  OD2 ASP A  36      14.907   2.176   0.216  1.00 71.32           O  
ATOM    559  H   ASP A  36      11.187   0.558   2.590  1.00 45.30           H  
ATOM    560  HA  ASP A  36      11.946   1.132  -0.118  1.00 53.34           H  
ATOM    561  HB2 ASP A  36      13.306   1.587   2.011  1.00 37.86           H  
ATOM    562  HB3 ASP A  36      13.694  -0.123   2.007  1.00 37.86           H  
ATOM    563  N   GLU A  37      13.021  -1.262  -0.773  1.00 64.33           N  
ATOM    564  CA  GLU A  37      13.150  -2.580  -1.369  1.00 72.43           C  
ATOM    565  C   GLU A  37      14.143  -3.420  -0.579  1.00 11.04           C  
ATOM    566  O   GLU A  37      14.116  -4.650  -0.635  1.00 55.10           O  
ATOM    567  CB  GLU A  37      13.614  -2.474  -2.819  1.00  5.30           C  
ATOM    568  CG  GLU A  37      12.645  -1.730  -3.722  1.00 44.41           C  
ATOM    569  CD  GLU A  37      13.035  -1.814  -5.182  1.00 64.31           C  
ATOM    570  OE1 GLU A  37      13.962  -1.086  -5.597  1.00 60.24           O  
ATOM    571  OE2 GLU A  37      12.418  -2.609  -5.924  1.00 30.30           O  
ATOM    572  H   GLU A  37      13.660  -0.559  -1.022  1.00 61.24           H  
ATOM    573  HA  GLU A  37      12.182  -3.059  -1.340  1.00 21.12           H  
ATOM    574  HB2 GLU A  37      14.562  -1.957  -2.844  1.00 37.86           H  
ATOM    575  HB3 GLU A  37      13.749  -3.467  -3.211  1.00 37.86           H  
ATOM    576  HG2 GLU A  37      11.662  -2.160  -3.602  1.00 37.86           H  
ATOM    577  HG3 GLU A  37      12.623  -0.689  -3.429  1.00 37.86           H  
ATOM    578  N   GLN A  38      15.025  -2.745   0.148  1.00 33.01           N  
ATOM    579  CA  GLN A  38      16.030  -3.426   0.946  1.00 52.31           C  
ATOM    580  C   GLN A  38      15.400  -4.075   2.170  1.00 72.34           C  
ATOM    581  O   GLN A  38      15.120  -3.413   3.173  1.00  3.32           O  
ATOM    582  CB  GLN A  38      17.140  -2.466   1.376  1.00 30.55           C  
ATOM    583  CG  GLN A  38      17.913  -1.861   0.216  1.00 63.32           C  
ATOM    584  CD  GLN A  38      19.142  -1.104   0.675  1.00 34.41           C  
ATOM    585  OE1 GLN A  38      20.227  -1.673   0.783  1.00 41.52           O  
ATOM    586  NE2 GLN A  38      18.982   0.179   0.957  1.00 73.12           N  
ATOM    587  H   GLN A  38      15.000  -1.759   0.146  1.00 23.45           H  
ATOM    588  HA  GLN A  38      16.462  -4.203   0.332  1.00 44.24           H  
ATOM    589  HB2 GLN A  38      16.702  -1.660   1.947  1.00 37.86           H  
ATOM    590  HB3 GLN A  38      17.838  -3.001   2.005  1.00 37.86           H  
ATOM    591  HG2 GLN A  38      18.225  -2.656  -0.444  1.00 37.86           H  
ATOM    592  HG3 GLN A  38      17.267  -1.180  -0.318  1.00 37.86           H  
ATOM    593 HE21 GLN A  38      18.088   0.569   0.853  1.00 37.86           H  
ATOM    594 HE22 GLN A  38      19.766   0.687   1.261  1.00 37.86           H  
ATOM    595  N   VAL A  39      15.153  -5.368   2.060  1.00 54.31           N  
ATOM    596  CA  VAL A  39      14.603  -6.144   3.152  1.00 13.13           C  
ATOM    597  C   VAL A  39      15.613  -7.182   3.615  1.00 44.31           C  
ATOM    598  O   VAL A  39      16.705  -7.284   3.057  1.00 51.14           O  
ATOM    599  CB  VAL A  39      13.295  -6.850   2.744  1.00 12.33           C  
ATOM    600  CG1 VAL A  39      12.211  -5.833   2.433  1.00 61.43           C  
ATOM    601  CG2 VAL A  39      13.528  -7.769   1.553  1.00 41.02           C  
ATOM    602  H   VAL A  39      15.345  -5.818   1.211  1.00  2.41           H  
ATOM    603  HA  VAL A  39      14.389  -5.471   3.968  1.00 63.41           H  
ATOM    604  HB  VAL A  39      12.963  -7.453   3.576  1.00 62.33           H  
ATOM    605 HG11 VAL A  39      11.311  -6.348   2.134  1.00 37.86           H  
ATOM    606 HG12 VAL A  39      12.541  -5.187   1.632  1.00 37.86           H  
ATOM    607 HG13 VAL A  39      12.010  -5.241   3.314  1.00 37.86           H  
ATOM    608 HG21 VAL A  39      14.203  -8.563   1.838  1.00 37.86           H  
ATOM    609 HG22 VAL A  39      13.959  -7.204   0.740  1.00 37.86           H  
ATOM    610 HG23 VAL A  39      12.586  -8.193   1.237  1.00 37.86           H  
ATOM    611  N   TYR A  40      15.248  -7.950   4.628  1.00 63.34           N  
ATOM    612  CA  TYR A  40      16.137  -8.964   5.170  1.00 23.53           C  
ATOM    613  C   TYR A  40      15.452 -10.317   5.189  1.00 12.24           C  
ATOM    614  O   TYR A  40      14.624 -10.591   6.053  1.00 21.14           O  
ATOM    615  CB  TYR A  40      16.584  -8.580   6.581  1.00 21.14           C  
ATOM    616  CG  TYR A  40      17.400  -7.306   6.630  1.00 32.31           C  
ATOM    617  CD1 TYR A  40      18.781  -7.336   6.484  1.00 13.42           C  
ATOM    618  CD2 TYR A  40      16.785  -6.071   6.816  1.00 22.21           C  
ATOM    619  CE1 TYR A  40      19.525  -6.171   6.523  1.00 13.52           C  
ATOM    620  CE2 TYR A  40      17.523  -4.905   6.856  1.00  2.12           C  
ATOM    621  CZ  TYR A  40      18.893  -4.960   6.707  1.00 65.43           C  
ATOM    622  OH  TYR A  40      19.630  -3.798   6.748  1.00 54.30           O  
ATOM    623  H   TYR A  40      14.353  -7.838   5.019  1.00 55.35           H  
ATOM    624  HA  TYR A  40      17.007  -9.022   4.530  1.00 70.01           H  
ATOM    625  HB2 TYR A  40      15.709  -8.438   7.200  1.00 37.86           H  
ATOM    626  HB3 TYR A  40      17.181  -9.381   6.991  1.00 37.86           H  
ATOM    627  HD1 TYR A  40      19.274  -8.284   6.340  1.00 71.12           H  
ATOM    628  HD2 TYR A  40      15.711  -6.032   6.934  1.00 65.31           H  
ATOM    629  HE1 TYR A  40      20.598  -6.214   6.408  1.00 50.12           H  
ATOM    630  HE2 TYR A  40      17.027  -3.957   6.998  1.00  3.14           H  
ATOM    631  HH  TYR A  40      20.313  -3.828   6.074  1.00 35.34           H  
ATOM    632  N   ALA A  41      15.781 -11.147   4.220  1.00 44.13           N  
ATOM    633  CA  ALA A  41      15.193 -12.467   4.122  1.00 51.13           C  
ATOM    634  C   ALA A  41      16.171 -13.522   4.615  1.00  3.24           C  
ATOM    635  O   ALA A  41      17.052 -13.967   3.879  1.00 70.34           O  
ATOM    636  CB  ALA A  41      14.761 -12.753   2.693  1.00 23.22           C  
ATOM    637  H   ALA A  41      16.457 -10.870   3.563  1.00 23.55           H  
ATOM    638  HA  ALA A  41      14.316 -12.484   4.750  1.00 35.43           H  
ATOM    639  HB1 ALA A  41      14.049 -12.004   2.375  1.00 37.86           H  
ATOM    640  HB2 ALA A  41      14.306 -13.730   2.642  1.00 37.86           H  
ATOM    641  HB3 ALA A  41      15.624 -12.724   2.045  1.00 37.86           H  
ATOM    642  N   ILE A  42      16.024 -13.910   5.872  1.00 53.41           N  
ATOM    643  CA  ILE A  42      16.937 -14.860   6.484  1.00 20.42           C  
ATOM    644  C   ILE A  42      16.164 -15.966   7.193  1.00 21.24           C  
ATOM    645  O   ILE A  42      14.943 -15.891   7.334  1.00 42.43           O  
ATOM    646  CB  ILE A  42      17.882 -14.174   7.500  1.00 32.34           C  
ATOM    647  CG1 ILE A  42      17.080 -13.578   8.659  1.00 50.43           C  
ATOM    648  CG2 ILE A  42      18.715 -13.096   6.818  1.00 22.12           C  
ATOM    649  CD1 ILE A  42      17.941 -13.018   9.775  1.00 61.44           C  
ATOM    650  H   ILE A  42      15.269 -13.560   6.397  1.00 40.42           H  
ATOM    651  HA  ILE A  42      17.538 -15.297   5.700  1.00 70.21           H  
ATOM    652  HB  ILE A  42      18.558 -14.921   7.888  1.00 42.20           H  
ATOM    653 HG12 ILE A  42      16.463 -12.775   8.283  1.00 37.86           H  
ATOM    654 HG13 ILE A  42      16.447 -14.345   9.080  1.00 37.86           H  
ATOM    655 HG21 ILE A  42      18.060 -12.375   6.351  1.00 37.86           H  
ATOM    656 HG22 ILE A  42      19.348 -13.548   6.069  1.00 37.86           H  
ATOM    657 HG23 ILE A  42      19.327 -12.600   7.555  1.00 37.86           H  
ATOM    658 HD11 ILE A  42      18.555 -12.217   9.390  1.00 37.86           H  
ATOM    659 HD12 ILE A  42      18.574 -13.799  10.168  1.00 37.86           H  
ATOM    660 HD13 ILE A  42      17.309 -12.636  10.566  1.00 37.86           H  
ATOM    661  N   SER A  43      16.872 -16.985   7.647  1.00 21.54           N  
ATOM    662  CA  SER A  43      16.244 -18.080   8.361  1.00 23.43           C  
ATOM    663  C   SER A  43      16.186 -17.772   9.851  1.00 53.11           C  
ATOM    664  O   SER A  43      17.099 -18.116  10.602  1.00 54.21           O  
ATOM    665  CB  SER A  43      17.001 -19.382   8.112  1.00 14.25           C  
ATOM    666  OG  SER A  43      16.976 -19.730   6.738  1.00  1.20           O  
ATOM    667  H   SER A  43      17.847 -16.993   7.517  1.00 72.13           H  
ATOM    668  HA  SER A  43      15.236 -18.181   7.987  1.00 70.52           H  
ATOM    669  HB2 SER A  43      18.029 -19.262   8.424  1.00 37.86           H  
ATOM    670  HB3 SER A  43      16.543 -20.175   8.682  1.00 37.86           H  
ATOM    671  HG  SER A  43      16.067 -19.700   6.421  1.00 55.25           H  
ATOM    672  N   ASN A  44      15.126 -17.090  10.260  1.00 52.33           N  
ATOM    673  CA  ASN A  44      14.925 -16.739  11.660  1.00 54.23           C  
ATOM    674  C   ASN A  44      13.573 -17.258  12.135  1.00  5.42           C  
ATOM    675  O   ASN A  44      12.572 -16.537  12.136  1.00 41.54           O  
ATOM    676  CB  ASN A  44      15.028 -15.223  11.851  1.00 42.02           C  
ATOM    677  CG  ASN A  44      14.924 -14.807  13.305  1.00 42.24           C  
ATOM    678  OD1 ASN A  44      15.260 -15.568  14.207  1.00  3.22           O  
ATOM    679  ND2 ASN A  44      14.470 -13.586  13.540  1.00 61.44           N  
ATOM    680  H   ASN A  44      14.456 -16.812   9.597  1.00 34.30           H  
ATOM    681  HA  ASN A  44      15.702 -17.218  12.239  1.00 61.12           H  
ATOM    682  HB2 ASN A  44      15.978 -14.884  11.470  1.00 37.86           H  
ATOM    683  HB3 ASN A  44      14.233 -14.745  11.299  1.00 37.86           H  
ATOM    684 HD21 ASN A  44      14.227 -13.026  12.772  1.00 37.86           H  
ATOM    685 HD22 ASN A  44      14.402 -13.289  14.472  1.00 37.86           H  
ATOM    686  N   ILE A  45      13.549 -18.531  12.498  1.00 51.51           N  
ATOM    687  CA  ILE A  45      12.321 -19.205  12.885  1.00 61.34           C  
ATOM    688  C   ILE A  45      12.457 -19.764  14.294  1.00 25.42           C  
ATOM    689  O   ILE A  45      13.522 -20.250  14.669  1.00 62.01           O  
ATOM    690  CB  ILE A  45      12.007 -20.372  11.915  1.00 33.34           C  
ATOM    691  CG1 ILE A  45      11.977 -19.882  10.463  1.00  2.41           C  
ATOM    692  CG2 ILE A  45      10.693 -21.045  12.278  1.00  2.44           C  
ATOM    693  CD1 ILE A  45      10.956 -18.798  10.208  1.00 13.41           C  
ATOM    694  H   ILE A  45      14.390 -19.037  12.515  1.00 34.51           H  
ATOM    695  HA  ILE A  45      11.504 -18.494  12.854  1.00 10.31           H  
ATOM    696  HB  ILE A  45      12.793 -21.107  12.018  1.00 14.01           H  
ATOM    697 HG12 ILE A  45      12.949 -19.490  10.203  1.00 37.86           H  
ATOM    698 HG13 ILE A  45      11.745 -20.714   9.817  1.00 37.86           H  
ATOM    699 HG21 ILE A  45      10.748 -21.420  13.289  1.00 37.86           H  
ATOM    700 HG22 ILE A  45      10.513 -21.865  11.599  1.00 37.86           H  
ATOM    701 HG23 ILE A  45       9.888 -20.330  12.201  1.00 37.86           H  
ATOM    702 HD11 ILE A  45      11.003 -18.494   9.174  1.00 37.86           H  
ATOM    703 HD12 ILE A  45      11.167 -17.951  10.843  1.00 37.86           H  
ATOM    704 HD13 ILE A  45       9.966 -19.176  10.428  1.00 37.86           H  
ATOM    705  N   ASP A  46      11.389 -19.686  15.071  1.00 61.42           N  
ATOM    706  CA  ASP A  46      11.394 -20.257  16.410  1.00 15.14           C  
ATOM    707  C   ASP A  46      10.841 -21.674  16.360  1.00 10.32           C  
ATOM    708  O   ASP A  46       9.723 -21.890  15.887  1.00 40.15           O  
ATOM    709  CB  ASP A  46      10.562 -19.405  17.363  1.00 61.32           C  
ATOM    710  CG  ASP A  46      10.765 -19.795  18.813  1.00 15.54           C  
ATOM    711  OD1 ASP A  46      10.219 -20.836  19.239  1.00 55.21           O  
ATOM    712  OD2 ASP A  46      11.473 -19.060  19.530  1.00 43.51           O  
ATOM    713  H   ASP A  46      10.579 -19.246  14.736  1.00 31.41           H  
ATOM    714  HA  ASP A  46      12.417 -20.289  16.757  1.00  5.33           H  
ATOM    715  HB2 ASP A  46      10.843 -18.369  17.247  1.00 37.86           H  
ATOM    716  HB3 ASP A  46       9.516 -19.520  17.121  1.00 37.86           H  
ATOM    717  N   PRO A  47      11.613 -22.657  16.844  1.00  3.53           N  
ATOM    718  CA  PRO A  47      11.244 -24.078  16.769  1.00 51.04           C  
ATOM    719  C   PRO A  47       9.991 -24.425  17.575  1.00 54.53           C  
ATOM    720  O   PRO A  47       9.459 -25.529  17.460  1.00 24.03           O  
ATOM    721  CB  PRO A  47      12.464 -24.805  17.348  1.00 61.20           C  
ATOM    722  CG  PRO A  47      13.570 -23.806  17.324  1.00 63.51           C  
ATOM    723  CD  PRO A  47      12.918 -22.468  17.495  1.00 24.35           C  
ATOM    724  HA  PRO A  47      11.099 -24.386  15.743  1.00 11.32           H  
ATOM    725  HB2 PRO A  47      12.247 -25.128  18.354  1.00 37.86           H  
ATOM    726  HB3 PRO A  47      12.697 -25.662  16.734  1.00 37.86           H  
ATOM    727  HG2 PRO A  47      14.255 -23.994  18.138  1.00 37.86           H  
ATOM    728  HG3 PRO A  47      14.089 -23.853  16.377  1.00 37.86           H  
ATOM    729  HD2 PRO A  47      12.797 -22.236  18.543  1.00 37.86           H  
ATOM    730  HD3 PRO A  47      13.489 -21.700  16.997  1.00 37.86           H  
ATOM    731  N   PHE A  48       9.521 -23.490  18.392  1.00 33.54           N  
ATOM    732  CA  PHE A  48       8.328 -23.716  19.197  1.00 35.34           C  
ATOM    733  C   PHE A  48       7.087 -23.169  18.489  1.00 61.33           C  
ATOM    734  O   PHE A  48       5.956 -23.489  18.861  1.00 12.41           O  
ATOM    735  CB  PHE A  48       8.492 -23.062  20.578  1.00 42.41           C  
ATOM    736  CG  PHE A  48       7.358 -23.332  21.528  1.00 24.34           C  
ATOM    737  CD1 PHE A  48       7.222 -24.573  22.125  1.00 54.42           C  
ATOM    738  CD2 PHE A  48       6.433 -22.346  21.824  1.00  3.43           C  
ATOM    739  CE1 PHE A  48       6.180 -24.827  22.996  1.00  4.23           C  
ATOM    740  CE2 PHE A  48       5.389 -22.593  22.694  1.00 32.44           C  
ATOM    741  CZ  PHE A  48       5.264 -23.835  23.281  1.00  1.33           C  
ATOM    742  H   PHE A  48       9.992 -22.629  18.464  1.00 55.34           H  
ATOM    743  HA  PHE A  48       8.211 -24.780  19.324  1.00 70.34           H  
ATOM    744  HB2 PHE A  48       9.398 -23.431  21.034  1.00 37.86           H  
ATOM    745  HB3 PHE A  48       8.571 -21.992  20.452  1.00 37.86           H  
ATOM    746  HD1 PHE A  48       7.939 -25.351  21.905  1.00 50.45           H  
ATOM    747  HD2 PHE A  48       6.529 -21.373  21.363  1.00 65.21           H  
ATOM    748  HE1 PHE A  48       6.083 -25.800  23.455  1.00 61.42           H  
ATOM    749  HE2 PHE A  48       4.675 -21.815  22.916  1.00  5.14           H  
ATOM    750  HZ  PHE A  48       4.448 -24.030  23.963  1.00 34.24           H  
ATOM    751  N   ALA A  49       7.298 -22.369  17.449  1.00 22.31           N  
ATOM    752  CA  ALA A  49       6.190 -21.703  16.773  1.00 74.41           C  
ATOM    753  C   ALA A  49       6.129 -22.071  15.296  1.00 11.24           C  
ATOM    754  O   ALA A  49       5.064 -22.008  14.683  1.00 12.44           O  
ATOM    755  CB  ALA A  49       6.302 -20.196  16.934  1.00 53.14           C  
ATOM    756  H   ALA A  49       8.214 -22.238  17.118  1.00 55.21           H  
ATOM    757  HA  ALA A  49       5.273 -22.022  17.250  1.00 12.32           H  
ATOM    758  HB1 ALA A  49       7.177 -19.839  16.409  1.00 37.86           H  
ATOM    759  HB2 ALA A  49       6.389 -19.951  17.982  1.00 37.86           H  
ATOM    760  HB3 ALA A  49       5.420 -19.721  16.527  1.00 37.86           H  
ATOM    761  N   GLN A  50       7.286 -22.429  14.737  1.00 51.42           N  
ATOM    762  CA  GLN A  50       7.412 -22.817  13.326  1.00 24.44           C  
ATOM    763  C   GLN A  50       7.179 -21.624  12.392  1.00 43.30           C  
ATOM    764  O   GLN A  50       7.036 -21.790  11.182  1.00 44.21           O  
ATOM    765  CB  GLN A  50       6.443 -23.952  12.973  1.00 13.11           C  
ATOM    766  CG  GLN A  50       6.647 -25.221  13.786  1.00 52.31           C  
ATOM    767  CD  GLN A  50       8.036 -25.810  13.622  1.00 24.41           C  
ATOM    768  OE1 GLN A  50       8.668 -25.673  12.575  1.00 33.34           O  
ATOM    769  NE2 GLN A  50       8.513 -26.478  14.658  1.00 25.22           N  
ATOM    770  H   GLN A  50       8.095 -22.431  15.294  1.00 41.13           H  
ATOM    771  HA  GLN A  50       8.422 -23.168  13.183  1.00 73.10           H  
ATOM    772  HB2 GLN A  50       5.431 -23.608  13.135  1.00 37.86           H  
ATOM    773  HB3 GLN A  50       6.565 -24.197  11.927  1.00 37.86           H  
ATOM    774  HG2 GLN A  50       6.494 -24.991  14.830  1.00 37.86           H  
ATOM    775  HG3 GLN A  50       5.921 -25.955  13.471  1.00 37.86           H  
ATOM    776 HE21 GLN A  50       7.953 -26.550  15.467  1.00 37.86           H  
ATOM    777 HE22 GLN A  50       9.407 -26.869  14.584  1.00 37.86           H  
ATOM    778  N   ALA A  51       7.168 -20.427  12.964  1.00 71.00           N  
ATOM    779  CA  ALA A  51       6.922 -19.207  12.208  1.00  3.15           C  
ATOM    780  C   ALA A  51       7.942 -18.139  12.567  1.00 21.35           C  
ATOM    781  O   ALA A  51       8.782 -18.331  13.455  1.00  1.41           O  
ATOM    782  CB  ALA A  51       5.512 -18.699  12.472  1.00 65.32           C  
ATOM    783  H   ALA A  51       7.331 -20.364  13.925  1.00 50.13           H  
ATOM    784  HA  ALA A  51       7.009 -19.427  11.147  1.00 61.23           H  
ATOM    785  HB1 ALA A  51       4.804 -19.484  12.260  1.00 37.86           H  
ATOM    786  HB2 ALA A  51       5.310 -17.850  11.833  1.00 37.86           H  
ATOM    787  HB3 ALA A  51       5.423 -18.401  13.506  1.00 37.86           H  
ATOM    788  N   SER A  52       7.847 -17.010  11.892  1.00 35.24           N  
ATOM    789  CA  SER A  52       8.776 -15.909  12.074  1.00 23.12           C  
ATOM    790  C   SER A  52       8.412 -15.061  13.292  1.00  3.23           C  
ATOM    791  O   SER A  52       8.408 -13.832  13.227  1.00 13.03           O  
ATOM    792  CB  SER A  52       8.761 -15.046  10.820  1.00  0.22           C  
ATOM    793  OG  SER A  52       7.433 -14.690  10.483  1.00  4.00           O  
ATOM    794  H   SER A  52       7.123 -16.910  11.236  1.00 72.43           H  
ATOM    795  HA  SER A  52       9.765 -16.318  12.209  1.00 11.43           H  
ATOM    796  HB2 SER A  52       9.332 -14.146  10.996  1.00 37.86           H  
ATOM    797  HB3 SER A  52       9.193 -15.597   9.998  1.00 37.86           H  
ATOM    798  HG  SER A  52       7.342 -13.729  10.523  1.00 75.54           H  
ATOM    799  N   VAL A  53       8.149 -15.713  14.416  1.00 42.24           N  
ATOM    800  CA  VAL A  53       7.770 -14.997  15.629  1.00 34.25           C  
ATOM    801  C   VAL A  53       8.968 -14.234  16.176  1.00  3.45           C  
ATOM    802  O   VAL A  53       8.823 -13.255  16.907  1.00  5.32           O  
ATOM    803  CB  VAL A  53       7.206 -15.940  16.713  1.00 55.13           C  
ATOM    804  CG1 VAL A  53       5.929 -16.606  16.225  1.00 44.03           C  
ATOM    805  CG2 VAL A  53       8.232 -16.985  17.115  1.00 73.03           C  
ATOM    806  H   VAL A  53       8.226 -16.694  14.430  1.00 61.11           H  
ATOM    807  HA  VAL A  53       6.999 -14.285  15.364  1.00 71.41           H  
ATOM    808  HB  VAL A  53       6.965 -15.348  17.584  1.00  1.35           H  
ATOM    809 HG11 VAL A  53       5.198 -15.849  15.982  1.00 37.86           H  
ATOM    810 HG12 VAL A  53       5.539 -17.248  17.001  1.00 37.86           H  
ATOM    811 HG13 VAL A  53       6.145 -17.194  15.345  1.00 37.86           H  
ATOM    812 HG21 VAL A  53       9.100 -16.495  17.530  1.00 37.86           H  
ATOM    813 HG22 VAL A  53       8.521 -17.555  16.246  1.00 37.86           H  
ATOM    814 HG23 VAL A  53       7.803 -17.646  17.855  1.00 37.86           H  
ATOM    815  N   LEU A  54      10.152 -14.682  15.778  1.00 40.11           N  
ATOM    816  CA  LEU A  54      11.394 -14.021  16.138  1.00 72.32           C  
ATOM    817  C   LEU A  54      11.657 -12.851  15.197  1.00  1.34           C  
ATOM    818  O   LEU A  54      12.564 -12.053  15.414  1.00 30.23           O  
ATOM    819  CB  LEU A  54      12.557 -15.015  16.070  1.00  5.42           C  
ATOM    820  CG  LEU A  54      12.458 -16.209  17.022  1.00 63.11           C  
ATOM    821  CD1 LEU A  54      13.658 -17.122  16.848  1.00 50.12           C  
ATOM    822  CD2 LEU A  54      12.351 -15.736  18.464  1.00  3.31           C  
ATOM    823  H   LEU A  54      10.189 -15.489  15.226  1.00 73.24           H  
ATOM    824  HA  LEU A  54      11.298 -13.650  17.147  1.00 13.34           H  
ATOM    825  HB2 LEU A  54      12.616 -15.393  15.060  1.00 37.86           H  
ATOM    826  HB3 LEU A  54      13.473 -14.485  16.287  1.00 37.86           H  
ATOM    827  HG  LEU A  54      11.569 -16.774  16.787  1.00 30.33           H  
ATOM    828 HD11 LEU A  54      14.564 -16.566  17.032  1.00 37.86           H  
ATOM    829 HD12 LEU A  54      13.671 -17.512  15.840  1.00 37.86           H  
ATOM    830 HD13 LEU A  54      13.590 -17.942  17.549  1.00 37.86           H  
ATOM    831 HD21 LEU A  54      13.227 -15.158  18.719  1.00 37.86           H  
ATOM    832 HD22 LEU A  54      12.282 -16.591  19.120  1.00 37.86           H  
ATOM    833 HD23 LEU A  54      11.470 -15.122  18.578  1.00 37.86           H  
ATOM    834  N   SER A  55      10.852 -12.764  14.145  1.00 23.03           N  
ATOM    835  CA  SER A  55      10.999 -11.719  13.145  1.00 71.33           C  
ATOM    836  C   SER A  55       9.948 -10.629  13.344  1.00 34.31           C  
ATOM    837  O   SER A  55      10.100  -9.509  12.862  1.00 71.40           O  
ATOM    838  CB  SER A  55      10.863 -12.323  11.750  1.00 42.35           C  
ATOM    839  OG  SER A  55      11.707 -13.453  11.603  1.00 12.22           O  
ATOM    840  H   SER A  55      10.132 -13.422  14.039  1.00  4.31           H  
ATOM    841  HA  SER A  55      11.982 -11.288  13.250  1.00 44.25           H  
ATOM    842  HB2 SER A  55       9.841 -12.630  11.589  1.00 37.86           H  
ATOM    843  HB3 SER A  55      11.138 -11.584  11.012  1.00 37.86           H  
ATOM    844  HG  SER A  55      12.023 -13.729  12.466  1.00 25.31           H  
ATOM    845  N   ARG A  56       8.889 -10.964  14.070  1.00 24.24           N  
ATOM    846  CA  ARG A  56       7.798 -10.028  14.303  1.00 14.43           C  
ATOM    847  C   ARG A  56       8.015  -9.293  15.624  1.00 23.51           C  
ATOM    848  O   ARG A  56       7.084  -8.730  16.204  1.00 41.13           O  
ATOM    849  CB  ARG A  56       6.463 -10.777  14.314  1.00 11.53           C  
ATOM    850  CG  ARG A  56       5.259  -9.886  14.050  1.00 11.41           C  
ATOM    851  CD  ARG A  56       3.972 -10.689  13.981  1.00 44.00           C  
ATOM    852  NE  ARG A  56       2.839  -9.868  13.555  1.00 23.30           N  
ATOM    853  CZ  ARG A  56       1.714 -10.363  13.043  1.00 11.43           C  
ATOM    854  NH1 ARG A  56       1.546 -11.681  12.941  1.00 32.41           N  
ATOM    855  NH2 ARG A  56       0.750  -9.542  12.645  1.00 21.02           N  
ATOM    856  H   ARG A  56       8.839 -11.861  14.459  1.00 25.41           H  
ATOM    857  HA  ARG A  56       7.796  -9.310  13.497  1.00 61.42           H  
ATOM    858  HB2 ARG A  56       6.489 -11.544  13.554  1.00 37.86           H  
ATOM    859  HB3 ARG A  56       6.332 -11.243  15.279  1.00 37.86           H  
ATOM    860  HG2 ARG A  56       5.178  -9.164  14.848  1.00 37.86           H  
ATOM    861  HG3 ARG A  56       5.405  -9.372  13.110  1.00 37.86           H  
ATOM    862  HD2 ARG A  56       4.104 -11.496  13.276  1.00 37.86           H  
ATOM    863  HD3 ARG A  56       3.763 -11.096  14.959  1.00 37.86           H  
ATOM    864  HE  ARG A  56       2.934  -8.888  13.645  1.00  0.24           H  
ATOM    865 HH11 ARG A  56       2.266 -12.312  13.256  1.00 37.86           H  
ATOM    866 HH12 ARG A  56       0.706 -12.056  12.532  1.00 37.86           H  
ATOM    867 HH21 ARG A  56       0.865  -8.542  12.723  1.00 37.86           H  
ATOM    868 HH22 ARG A  56      -0.107  -9.915  12.268  1.00 37.86           H  
ATOM    869  N   GLY A  57       9.258  -9.299  16.087  1.00 74.34           N  
ATOM    870  CA  GLY A  57       9.598  -8.626  17.323  1.00 11.41           C  
ATOM    871  C   GLY A  57       9.814  -7.139  17.121  1.00 44.33           C  
ATOM    872  O   GLY A  57       9.239  -6.535  16.210  1.00 24.31           O  
ATOM    873  H   GLY A  57       9.958  -9.753  15.574  1.00 23.51           H  
ATOM    874  HA2 GLY A  57       8.795  -8.773  18.031  1.00 37.86           H  
ATOM    875  HA3 GLY A  57      10.502  -9.061  17.724  1.00 37.86           H  
ATOM    876  N   ILE A  58      10.650  -6.549  17.957  1.00 33.32           N  
ATOM    877  CA  ILE A  58      10.906  -5.120  17.883  1.00 61.33           C  
ATOM    878  C   ILE A  58      12.080  -4.842  16.957  1.00 34.12           C  
ATOM    879  O   ILE A  58      13.240  -5.067  17.310  1.00 44.30           O  
ATOM    880  CB  ILE A  58      11.184  -4.490  19.276  1.00  2.35           C  
ATOM    881  CG1 ILE A  58       9.996  -4.690  20.231  1.00  4.04           C  
ATOM    882  CG2 ILE A  58      11.492  -3.003  19.138  1.00 23.42           C  
ATOM    883  CD1 ILE A  58       9.904  -6.079  20.836  1.00 12.41           C  
ATOM    884  H   ILE A  58      11.113  -7.087  18.636  1.00 55.21           H  
ATOM    885  HA  ILE A  58      10.027  -4.649  17.464  1.00 42.11           H  
ATOM    886  HB  ILE A  58      12.055  -4.973  19.690  1.00 30.32           H  
ATOM    887 HG12 ILE A  58      10.076  -3.985  21.045  1.00 37.86           H  
ATOM    888 HG13 ILE A  58       9.077  -4.503  19.694  1.00 37.86           H  
ATOM    889 HG21 ILE A  58      10.648  -2.498  18.689  1.00 37.86           H  
ATOM    890 HG22 ILE A  58      12.365  -2.869  18.518  1.00 37.86           H  
ATOM    891 HG23 ILE A  58      11.679  -2.585  20.117  1.00 37.86           H  
ATOM    892 HD11 ILE A  58      10.772  -6.263  21.451  1.00 37.86           H  
ATOM    893 HD12 ILE A  58       9.864  -6.812  20.044  1.00 37.86           H  
ATOM    894 HD13 ILE A  58       9.011  -6.153  21.440  1.00 37.86           H  
ATOM    895  N   VAL A  59      11.760  -4.376  15.762  1.00 44.23           N  
ATOM    896  CA  VAL A  59      12.758  -4.020  14.777  1.00 12.53           C  
ATOM    897  C   VAL A  59      13.171  -2.570  14.977  1.00 62.04           C  
ATOM    898  O   VAL A  59      12.424  -1.646  14.646  1.00 62.01           O  
ATOM    899  CB  VAL A  59      12.221  -4.219  13.345  1.00 50.21           C  
ATOM    900  CG1 VAL A  59      13.247  -3.771  12.310  1.00 61.02           C  
ATOM    901  CG2 VAL A  59      11.828  -5.674  13.122  1.00 11.35           C  
ATOM    902  H   VAL A  59      10.819  -4.258  15.541  1.00 13.11           H  
ATOM    903  HA  VAL A  59      13.620  -4.658  14.914  1.00 45.43           H  
ATOM    904  HB  VAL A  59      11.334  -3.611  13.233  1.00 10.51           H  
ATOM    905 HG11 VAL A  59      13.453  -2.719  12.442  1.00 37.86           H  
ATOM    906 HG12 VAL A  59      12.858  -3.940  11.316  1.00 37.86           H  
ATOM    907 HG13 VAL A  59      14.160  -4.335  12.440  1.00 37.86           H  
ATOM    908 HG21 VAL A  59      11.437  -5.793  12.123  1.00 37.86           H  
ATOM    909 HG22 VAL A  59      11.071  -5.954  13.840  1.00 37.86           H  
ATOM    910 HG23 VAL A  59      12.695  -6.306  13.248  1.00 37.86           H  
ATOM    911  N   ALA A  60      14.344  -2.381  15.553  1.00 23.44           N  
ATOM    912  CA  ALA A  60      14.843  -1.049  15.862  1.00 33.52           C  
ATOM    913  C   ALA A  60      16.360  -0.999  15.768  1.00 72.01           C  
ATOM    914  O   ALA A  60      17.017  -2.015  15.541  1.00 41.11           O  
ATOM    915  CB  ALA A  60      14.384  -0.617  17.248  1.00  2.23           C  
ATOM    916  H   ALA A  60      14.899  -3.164  15.774  1.00 11.44           H  
ATOM    917  HA  ALA A  60      14.427  -0.362  15.141  1.00 72.41           H  
ATOM    918  HB1 ALA A  60      13.309  -0.682  17.308  1.00 37.86           H  
ATOM    919  HB2 ALA A  60      14.692   0.403  17.425  1.00 37.86           H  
ATOM    920  HB3 ALA A  60      14.828  -1.261  17.992  1.00 37.86           H  
ATOM    921  N   GLU A  61      16.911   0.187  15.932  1.00 13.33           N  
ATOM    922  CA  GLU A  61      18.350   0.371  15.903  1.00 32.02           C  
ATOM    923  C   GLU A  61      18.935   0.176  17.295  1.00 61.22           C  
ATOM    924  O   GLU A  61      18.596   0.905  18.228  1.00 71.33           O  
ATOM    925  CB  GLU A  61      18.679   1.765  15.385  1.00 64.55           C  
ATOM    926  CG  GLU A  61      20.162   2.074  15.316  1.00 70.52           C  
ATOM    927  CD  GLU A  61      20.417   3.542  15.071  1.00 32.53           C  
ATOM    928  OE1 GLU A  61      20.326   3.982  13.907  1.00 42.31           O  
ATOM    929  OE2 GLU A  61      20.678   4.272  16.051  1.00 21.24           O  
ATOM    930  H   GLU A  61      16.333   0.967  16.076  1.00 44.43           H  
ATOM    931  HA  GLU A  61      18.770  -0.366  15.235  1.00 34.23           H  
ATOM    932  HB2 GLU A  61      18.268   1.869  14.391  1.00 37.86           H  
ATOM    933  HB3 GLU A  61      18.213   2.494  16.032  1.00 37.86           H  
ATOM    934  HG2 GLU A  61      20.625   1.790  16.250  1.00 37.86           H  
ATOM    935  HG3 GLU A  61      20.600   1.506  14.508  1.00 37.86           H  
ATOM    936  N   HIS A  62      19.818  -0.799  17.431  1.00 44.11           N  
ATOM    937  CA  HIS A  62      20.401  -1.113  18.728  1.00 73.24           C  
ATOM    938  C   HIS A  62      21.619  -0.235  18.991  1.00 72.41           C  
ATOM    939  O   HIS A  62      21.889   0.149  20.127  1.00 32.43           O  
ATOM    940  CB  HIS A  62      20.779  -2.598  18.791  1.00 40.04           C  
ATOM    941  CG  HIS A  62      21.552  -2.997  20.012  1.00 50.31           C  
ATOM    942  ND1 HIS A  62      20.923  -3.334  21.184  1.00  0.33           N  
ATOM    943  CD2 HIS A  62      22.892  -3.095  20.182  1.00 72.24           C  
ATOM    944  CE1 HIS A  62      21.890  -3.622  22.040  1.00 63.40           C  
ATOM    945  NE2 HIS A  62      23.100  -3.490  21.479  1.00  2.55           N  
ATOM    946  H   HIS A  62      20.095  -1.311  16.638  1.00 62.22           H  
ATOM    947  HA  HIS A  62      19.656  -0.907  19.483  1.00 22.52           H  
ATOM    948  HB2 HIS A  62      19.876  -3.190  18.769  1.00 37.86           H  
ATOM    949  HB3 HIS A  62      21.377  -2.842  17.926  1.00 37.86           H  
ATOM    950  HD2 HIS A  62      23.653  -2.899  19.441  1.00 24.23           H  
ATOM    951  HE1 HIS A  62      21.723  -3.925  23.063  1.00 14.22           H  
ATOM    952  HE2 HIS A  62      23.957  -3.419  21.968  1.00 37.86           H  
ATOM    953  N   GLN A  63      22.340   0.092  17.931  1.00  0.03           N  
ATOM    954  CA  GLN A  63      23.552   0.884  18.051  1.00 24.43           C  
ATOM    955  C   GLN A  63      23.771   1.694  16.783  1.00 25.34           C  
ATOM    956  O   GLN A  63      23.716   2.921  16.793  1.00 42.24           O  
ATOM    957  CB  GLN A  63      24.756  -0.029  18.302  1.00  2.12           C  
ATOM    958  CG  GLN A  63      26.064   0.717  18.507  1.00 51.14           C  
ATOM    959  CD  GLN A  63      27.259  -0.212  18.613  1.00 31.11           C  
ATOM    960  OE1 GLN A  63      27.286  -1.286  18.011  1.00 12.44           O  
ATOM    961  NE2 GLN A  63      28.253   0.190  19.387  1.00 22.14           N  
ATOM    962  H   GLN A  63      22.042  -0.192  17.045  1.00 71.41           H  
ATOM    963  HA  GLN A  63      23.434   1.558  18.889  1.00 51.53           H  
ATOM    964  HB2 GLN A  63      24.564  -0.623  19.184  1.00 37.86           H  
ATOM    965  HB3 GLN A  63      24.871  -0.689  17.455  1.00 37.86           H  
ATOM    966  HG2 GLN A  63      26.220   1.380  17.670  1.00 37.86           H  
ATOM    967  HG3 GLN A  63      25.997   1.296  19.416  1.00 37.86           H  
ATOM    968 HE21 GLN A  63      28.160   1.059  19.848  1.00 37.86           H  
ATOM    969 HE22 GLN A  63      29.037  -0.392  19.475  1.00 37.86           H  
ATOM    970  N   ASP A  64      24.008   0.988  15.691  1.00 22.24           N  
ATOM    971  CA  ASP A  64      24.290   1.624  14.413  1.00 61.44           C  
ATOM    972  C   ASP A  64      23.490   0.972  13.292  1.00 54.41           C  
ATOM    973  O   ASP A  64      23.222   1.585  12.259  1.00 74.22           O  
ATOM    974  CB  ASP A  64      25.787   1.518  14.122  1.00 60.24           C  
ATOM    975  CG  ASP A  64      26.148   1.885  12.698  1.00 61.33           C  
ATOM    976  OD1 ASP A  64      26.354   3.086  12.428  1.00 21.52           O  
ATOM    977  OD2 ASP A  64      26.246   0.969  11.851  1.00  3.25           O  
ATOM    978  H   ASP A  64      24.017   0.009  15.747  1.00 74.25           H  
ATOM    979  HA  ASP A  64      24.015   2.665  14.484  1.00 21.12           H  
ATOM    980  HB2 ASP A  64      26.321   2.181  14.786  1.00 37.86           H  
ATOM    981  HB3 ASP A  64      26.107   0.501  14.305  1.00 37.86           H  
ATOM    982  N   ASP A  65      23.085  -0.265  13.516  1.00 10.13           N  
ATOM    983  CA  ASP A  65      22.476  -1.060  12.467  1.00 63.21           C  
ATOM    984  C   ASP A  65      21.063  -1.463  12.863  1.00  4.43           C  
ATOM    985  O   ASP A  65      20.564  -1.040  13.908  1.00 42.24           O  
ATOM    986  CB  ASP A  65      23.329  -2.301  12.201  1.00 53.24           C  
ATOM    987  CG  ASP A  65      23.226  -2.775  10.768  1.00 63.43           C  
ATOM    988  OD1 ASP A  65      22.255  -3.484  10.437  1.00 63.24           O  
ATOM    989  OD2 ASP A  65      24.120  -2.437   9.969  1.00 55.53           O  
ATOM    990  H   ASP A  65      23.176  -0.648  14.414  1.00 32.51           H  
ATOM    991  HA  ASP A  65      22.432  -0.458  11.571  1.00 72.14           H  
ATOM    992  HB2 ASP A  65      24.364  -2.070  12.410  1.00 37.86           H  
ATOM    993  HB3 ASP A  65      23.005  -3.100  12.850  1.00 37.86           H  
ATOM    994  N   LEU A  66      20.434  -2.284  12.042  1.00 12.23           N  
ATOM    995  CA  LEU A  66      19.071  -2.719  12.292  1.00 71.21           C  
ATOM    996  C   LEU A  66      19.065  -4.047  13.036  1.00 13.22           C  
ATOM    997  O   LEU A  66      19.609  -5.046  12.558  1.00 63.42           O  
ATOM    998  CB  LEU A  66      18.306  -2.841  10.975  1.00 71.43           C  
ATOM    999  CG  LEU A  66      18.180  -1.540  10.178  1.00 25.40           C  
ATOM   1000  CD1 LEU A  66      17.443  -1.784   8.873  1.00 60.24           C  
ATOM   1001  CD2 LEU A  66      17.466  -0.474  10.995  1.00 32.20           C  
ATOM   1002  H   LEU A  66      20.908  -2.625  11.246  1.00 53.32           H  
ATOM   1003  HA  LEU A  66      18.594  -1.973  12.909  1.00 10.34           H  
ATOM   1004  HB2 LEU A  66      18.811  -3.570  10.358  1.00 37.86           H  
ATOM   1005  HB3 LEU A  66      17.313  -3.202  11.194  1.00 37.86           H  
ATOM   1006  HG  LEU A  66      19.168  -1.173   9.940  1.00  1.24           H  
ATOM   1007 HD11 LEU A  66      17.981  -2.513   8.288  1.00 37.86           H  
ATOM   1008 HD12 LEU A  66      17.373  -0.858   8.320  1.00 37.86           H  
ATOM   1009 HD13 LEU A  66      16.451  -2.152   9.084  1.00 37.86           H  
ATOM   1010 HD21 LEU A  66      16.471  -0.817  11.241  1.00 37.86           H  
ATOM   1011 HD22 LEU A  66      17.400   0.437  10.420  1.00 37.86           H  
ATOM   1012 HD23 LEU A  66      18.017  -0.288  11.904  1.00 37.86           H  
ATOM   1013  N   TRP A  67      18.470  -4.044  14.218  1.00 21.32           N  
ATOM   1014  CA  TRP A  67      18.417  -5.230  15.056  1.00 34.41           C  
ATOM   1015  C   TRP A  67      16.967  -5.589  15.354  1.00 11.44           C  
ATOM   1016  O   TRP A  67      16.089  -4.723  15.348  1.00 75.21           O  
ATOM   1017  CB  TRP A  67      19.151  -4.997  16.384  1.00 13.31           C  
ATOM   1018  CG  TRP A  67      20.617  -4.683  16.258  1.00 42.42           C  
ATOM   1019  CD1 TRP A  67      21.189  -3.646  15.576  1.00 34.21           C  
ATOM   1020  CD2 TRP A  67      21.698  -5.396  16.871  1.00 52.20           C  
ATOM   1021  NE1 TRP A  67      22.554  -3.675  15.725  1.00 50.54           N  
ATOM   1022  CE2 TRP A  67      22.888  -4.739  16.517  1.00 13.13           C  
ATOM   1023  CE3 TRP A  67      21.773  -6.528  17.689  1.00 24.30           C  
ATOM   1024  CZ2 TRP A  67      24.139  -5.178  16.948  1.00 64.31           C  
ATOM   1025  CZ3 TRP A  67      23.014  -6.958  18.117  1.00 71.42           C  
ATOM   1026  CH2 TRP A  67      24.179  -6.283  17.749  1.00  5.21           C  
ATOM   1027  H   TRP A  67      18.037  -3.218  14.536  1.00 71.21           H  
ATOM   1028  HA  TRP A  67      18.884  -6.045  14.526  1.00  1.05           H  
ATOM   1029  HB2 TRP A  67      18.683  -4.171  16.895  1.00 37.86           H  
ATOM   1030  HB3 TRP A  67      19.052  -5.885  16.993  1.00 37.86           H  
ATOM   1031  HD1 TRP A  67      20.635  -2.919  14.999  1.00 64.20           H  
ATOM   1032  HE1 TRP A  67      23.189  -3.034  15.333  1.00 13.21           H  
ATOM   1033  HE3 TRP A  67      20.884  -7.064  17.986  1.00 52.21           H  
ATOM   1034  HZ2 TRP A  67      25.050  -4.667  16.676  1.00 22.50           H  
ATOM   1035  HZ3 TRP A  67      23.091  -7.828  18.753  1.00 20.12           H  
ATOM   1036  HH2 TRP A  67      25.127  -6.656  18.111  1.00 54.00           H  
ATOM   1037  N   VAL A  68      16.713  -6.858  15.610  1.00 32.51           N  
ATOM   1038  CA  VAL A  68      15.394  -7.284  16.028  1.00  2.33           C  
ATOM   1039  C   VAL A  68      15.443  -7.812  17.460  1.00 11.21           C  
ATOM   1040  O   VAL A  68      16.225  -8.709  17.790  1.00 61.25           O  
ATOM   1041  CB  VAL A  68      14.793  -8.344  15.072  1.00 31.20           C  
ATOM   1042  CG1 VAL A  68      15.650  -9.601  15.014  1.00  1.51           C  
ATOM   1043  CG2 VAL A  68      13.369  -8.687  15.478  1.00 73.44           C  
ATOM   1044  H   VAL A  68      17.431  -7.527  15.514  1.00 61.21           H  
ATOM   1045  HA  VAL A  68      14.752  -6.415  16.010  1.00 51.01           H  
ATOM   1046  HB  VAL A  68      14.763  -7.918  14.079  1.00 14.52           H  
ATOM   1047 HG11 VAL A  68      16.638  -9.348  14.659  1.00 37.86           H  
ATOM   1048 HG12 VAL A  68      15.199 -10.316  14.341  1.00 37.86           H  
ATOM   1049 HG13 VAL A  68      15.721 -10.033  16.002  1.00 37.86           H  
ATOM   1050 HG21 VAL A  68      12.750  -7.806  15.401  1.00 37.86           H  
ATOM   1051 HG22 VAL A  68      13.363  -9.045  16.496  1.00 37.86           H  
ATOM   1052 HG23 VAL A  68      12.983  -9.456  14.824  1.00 37.86           H  
ATOM   1053  N   ALA A  69      14.644  -7.207  18.322  1.00 23.02           N  
ATOM   1054  CA  ALA A  69      14.544  -7.646  19.698  1.00 71.34           C  
ATOM   1055  C   ALA A  69      13.526  -8.768  19.812  1.00 12.14           C  
ATOM   1056  O   ALA A  69      12.335  -8.564  19.559  1.00 43.44           O  
ATOM   1057  CB  ALA A  69      14.169  -6.483  20.604  1.00 71.12           C  
ATOM   1058  H   ALA A  69      14.109  -6.436  18.022  1.00  3.44           H  
ATOM   1059  HA  ALA A  69      15.513  -8.016  20.003  1.00 24.03           H  
ATOM   1060  HB1 ALA A  69      14.908  -5.703  20.511  1.00 37.86           H  
ATOM   1061  HB2 ALA A  69      14.133  -6.824  21.629  1.00 37.86           H  
ATOM   1062  HB3 ALA A  69      13.200  -6.101  20.318  1.00 37.86           H  
ATOM   1063  N   SER A  70      14.002  -9.955  20.164  1.00 15.30           N  
ATOM   1064  CA  SER A  70      13.134 -11.106  20.316  1.00  4.42           C  
ATOM   1065  C   SER A  70      12.133 -10.878  21.449  1.00  3.42           C  
ATOM   1066  O   SER A  70      12.515 -10.512  22.565  1.00 30.25           O  
ATOM   1067  CB  SER A  70      13.971 -12.361  20.586  1.00 33.53           C  
ATOM   1068  OG  SER A  70      13.149 -13.506  20.754  1.00  0.32           O  
ATOM   1069  H   SER A  70      14.964 -10.057  20.319  1.00 34.24           H  
ATOM   1070  HA  SER A  70      12.591 -11.236  19.392  1.00 62.20           H  
ATOM   1071  HB2 SER A  70      14.637 -12.531  19.755  1.00 37.86           H  
ATOM   1072  HB3 SER A  70      14.548 -12.213  21.487  1.00 37.86           H  
ATOM   1073  HG  SER A  70      13.228 -14.067  19.973  1.00 35.55           H  
ATOM   1074  N   PRO A  71      10.839 -11.076  21.167  1.00 34.04           N  
ATOM   1075  CA  PRO A  71       9.781 -10.916  22.167  1.00 33.35           C  
ATOM   1076  C   PRO A  71       9.852 -11.983  23.259  1.00 24.42           C  
ATOM   1077  O   PRO A  71       9.509 -11.732  24.415  1.00  5.42           O  
ATOM   1078  CB  PRO A  71       8.489 -11.064  21.355  1.00 44.34           C  
ATOM   1079  CG  PRO A  71       8.880 -11.826  20.135  1.00 62.54           C  
ATOM   1080  CD  PRO A  71      10.307 -11.457  19.847  1.00  2.13           C  
ATOM   1081  HA  PRO A  71       9.813  -9.937  22.623  1.00 54.03           H  
ATOM   1082  HB2 PRO A  71       7.758 -11.604  21.938  1.00 37.86           H  
ATOM   1083  HB3 PRO A  71       8.105 -10.087  21.102  1.00 37.86           H  
ATOM   1084  HG2 PRO A  71       8.799 -12.886  20.323  1.00 37.86           H  
ATOM   1085  HG3 PRO A  71       8.246 -11.541  19.307  1.00 37.86           H  
ATOM   1086  HD2 PRO A  71      10.842 -12.305  19.446  1.00 37.86           H  
ATOM   1087  HD3 PRO A  71      10.350 -10.624  19.160  1.00 37.86           H  
ATOM   1088  N   LEU A  72      10.319 -13.168  22.888  1.00 32.41           N  
ATOM   1089  CA  LEU A  72      10.387 -14.284  23.822  1.00 43.10           C  
ATOM   1090  C   LEU A  72      11.796 -14.455  24.375  1.00 23.12           C  
ATOM   1091  O   LEU A  72      12.004 -14.419  25.584  1.00  0.13           O  
ATOM   1092  CB  LEU A  72       9.941 -15.582  23.140  1.00  4.44           C  
ATOM   1093  CG  LEU A  72       8.528 -15.567  22.552  1.00 53.21           C  
ATOM   1094  CD1 LEU A  72       8.231 -16.885  21.856  1.00 14.14           C  
ATOM   1095  CD2 LEU A  72       7.498 -15.302  23.640  1.00 33.32           C  
ATOM   1096  H   LEU A  72      10.619 -13.294  21.965  1.00 41.55           H  
ATOM   1097  HA  LEU A  72       9.716 -14.071  24.640  1.00 73.31           H  
ATOM   1098  HB2 LEU A  72      10.638 -15.802  22.344  1.00 37.86           H  
ATOM   1099  HB3 LEU A  72       9.994 -16.377  23.868  1.00 37.86           H  
ATOM   1100  HG  LEU A  72       8.457 -14.776  21.821  1.00 62.15           H  
ATOM   1101 HD11 LEU A  72       8.298 -17.693  22.569  1.00 37.86           H  
ATOM   1102 HD12 LEU A  72       8.947 -17.043  21.064  1.00 37.86           H  
ATOM   1103 HD13 LEU A  72       7.235 -16.853  21.441  1.00 37.86           H  
ATOM   1104 HD21 LEU A  72       6.508 -15.307  23.208  1.00 37.86           H  
ATOM   1105 HD22 LEU A  72       7.689 -14.338  24.089  1.00 37.86           H  
ATOM   1106 HD23 LEU A  72       7.565 -16.071  24.395  1.00 37.86           H  
ATOM   1107  N   LYS A  73      12.765 -14.619  23.482  1.00 51.31           N  
ATOM   1108  CA  LYS A  73      14.135 -14.929  23.887  1.00  5.25           C  
ATOM   1109  C   LYS A  73      14.912 -13.663  24.248  1.00 52.43           C  
ATOM   1110  O   LYS A  73      15.938 -13.733  24.922  1.00  3.21           O  
ATOM   1111  CB  LYS A  73      14.861 -15.717  22.784  1.00 64.12           C  
ATOM   1112  CG  LYS A  73      14.500 -17.204  22.738  1.00 62.54           C  
ATOM   1113  CD  LYS A  73      13.013 -17.431  22.488  1.00 12.41           C  
ATOM   1114  CE  LYS A  73      12.630 -18.900  22.606  1.00 63.42           C  
ATOM   1115  NZ  LYS A  73      13.102 -19.700  21.447  1.00 23.12           N  
ATOM   1116  H   LYS A  73      12.558 -14.529  22.527  1.00 30.31           H  
ATOM   1117  HA  LYS A  73      14.075 -15.551  24.769  1.00 63.01           H  
ATOM   1118  HB2 LYS A  73      14.618 -15.282  21.827  1.00 37.86           H  
ATOM   1119  HB3 LYS A  73      15.925 -15.635  22.947  1.00 37.86           H  
ATOM   1120  HG2 LYS A  73      15.062 -17.672  21.944  1.00 37.86           H  
ATOM   1121  HG3 LYS A  73      14.768 -17.656  23.682  1.00 37.86           H  
ATOM   1122  HD2 LYS A  73      12.447 -16.866  23.210  1.00 37.86           H  
ATOM   1123  HD3 LYS A  73      12.772 -17.088  21.492  1.00 37.86           H  
ATOM   1124  HE2 LYS A  73      13.068 -19.301  23.508  1.00 37.86           H  
ATOM   1125  HE3 LYS A  73      11.553 -18.973  22.670  1.00 37.86           H  
ATOM   1126  HZ1 LYS A  73      14.139 -19.681  21.392  1.00 37.86           H  
ATOM   1127  HZ2 LYS A  73      12.705 -19.315  20.559  1.00 37.86           H  
ATOM   1128  HZ3 LYS A  73      12.788 -20.690  21.545  1.00 37.86           H  
ATOM   1129  N   LYS A  74      14.422 -12.519  23.767  1.00 24.22           N  
ATOM   1130  CA  LYS A  74      14.944 -11.189  24.129  1.00 63.30           C  
ATOM   1131  C   LYS A  74      16.311 -10.875  23.503  1.00 41.13           C  
ATOM   1132  O   LYS A  74      16.659  -9.704  23.352  1.00 75.42           O  
ATOM   1133  CB  LYS A  74      14.978 -11.021  25.653  1.00  4.31           C  
ATOM   1134  CG  LYS A  74      15.427  -9.645  26.132  1.00 21.52           C  
ATOM   1135  CD  LYS A  74      14.645  -8.502  25.482  1.00  4.42           C  
ATOM   1136  CE  LYS A  74      13.182  -8.450  25.909  1.00 12.12           C  
ATOM   1137  NZ  LYS A  74      12.352  -9.481  25.227  1.00 31.55           N  
ATOM   1138  H   LYS A  74      13.668 -12.566  23.144  1.00 11.31           H  
ATOM   1139  HA  LYS A  74      14.240 -10.469  23.735  1.00 22.40           H  
ATOM   1140  HB2 LYS A  74      13.988 -11.202  26.040  1.00 37.86           H  
ATOM   1141  HB3 LYS A  74      15.652 -11.755  26.065  1.00 37.86           H  
ATOM   1142  HG2 LYS A  74      15.291  -9.591  27.201  1.00 37.86           H  
ATOM   1143  HG3 LYS A  74      16.476  -9.524  25.899  1.00 37.86           H  
ATOM   1144  HD2 LYS A  74      15.113  -7.569  25.755  1.00 37.86           H  
ATOM   1145  HD3 LYS A  74      14.691  -8.624  24.409  1.00 37.86           H  
ATOM   1146  HE2 LYS A  74      13.126  -8.610  26.976  1.00 37.86           H  
ATOM   1147  HE3 LYS A  74      12.787  -7.474  25.675  1.00 37.86           H  
ATOM   1148  HZ1 LYS A  74      12.661  -9.600  24.240  1.00 37.86           H  
ATOM   1149  HZ2 LYS A  74      11.350  -9.186  25.223  1.00 37.86           H  
ATOM   1150  HZ3 LYS A  74      12.428 -10.397  25.722  1.00 37.86           H  
ATOM   1151  N   GLN A  75      17.073 -11.902  23.134  1.00 20.33           N  
ATOM   1152  CA  GLN A  75      18.356 -11.705  22.454  1.00 25.12           C  
ATOM   1153  C   GLN A  75      18.206 -10.753  21.267  1.00 23.52           C  
ATOM   1154  O   GLN A  75      17.164 -10.732  20.606  1.00  1.41           O  
ATOM   1155  CB  GLN A  75      18.924 -13.044  21.981  1.00 64.32           C  
ATOM   1156  CG  GLN A  75      19.474 -13.910  23.104  1.00 75.21           C  
ATOM   1157  CD  GLN A  75      20.678 -13.287  23.783  1.00 74.22           C  
ATOM   1158  OE1 GLN A  75      21.817 -13.487  23.363  1.00 42.21           O  
ATOM   1159  NE2 GLN A  75      20.437 -12.533  24.842  1.00 52.34           N  
ATOM   1160  H   GLN A  75      16.776 -12.812  23.343  1.00 73.24           H  
ATOM   1161  HA  GLN A  75      19.039 -11.267  23.165  1.00 72.31           H  
ATOM   1162  HB2 GLN A  75      18.142 -13.599  21.481  1.00 37.86           H  
ATOM   1163  HB3 GLN A  75      19.724 -12.855  21.278  1.00 37.86           H  
ATOM   1164  HG2 GLN A  75      18.700 -14.054  23.845  1.00 37.86           H  
ATOM   1165  HG3 GLN A  75      19.765 -14.867  22.698  1.00 37.86           H  
ATOM   1166 HE21 GLN A  75      19.500 -12.416  25.129  1.00 37.86           H  
ATOM   1167 HE22 GLN A  75      21.202 -12.130  25.314  1.00 37.86           H  
ATOM   1168  N   HIS A  76      19.238  -9.957  21.005  1.00 13.21           N  
ATOM   1169  CA  HIS A  76      19.164  -8.950  19.952  1.00 31.31           C  
ATOM   1170  C   HIS A  76      19.855  -9.436  18.690  1.00 31.55           C  
ATOM   1171  O   HIS A  76      21.078  -9.484  18.620  1.00 74.13           O  
ATOM   1172  CB  HIS A  76      19.780  -7.624  20.414  1.00 41.25           C  
ATOM   1173  CG  HIS A  76      18.889  -6.814  21.307  1.00  4.34           C  
ATOM   1174  ND1 HIS A  76      19.051  -5.459  21.507  1.00 30.14           N  
ATOM   1175  CD2 HIS A  76      17.816  -7.172  22.051  1.00 22.41           C  
ATOM   1176  CE1 HIS A  76      18.120  -5.024  22.334  1.00 71.33           C  
ATOM   1177  NE2 HIS A  76      17.359  -6.041  22.677  1.00 52.42           N  
ATOM   1178  H   HIS A  76      20.078 -10.067  21.515  1.00 42.41           H  
ATOM   1179  HA  HIS A  76      18.120  -8.787  19.727  1.00 33.10           H  
ATOM   1180  HB2 HIS A  76      20.691  -7.831  20.958  1.00 37.86           H  
ATOM   1181  HB3 HIS A  76      20.017  -7.025  19.547  1.00 37.86           H  
ATOM   1182  HD1 HIS A  76      19.754  -4.894  21.109  1.00 21.32           H  
ATOM   1183  HD2 HIS A  76      17.398  -8.166  22.135  1.00  3.21           H  
ATOM   1184  HE1 HIS A  76      18.004  -4.004  22.673  1.00 64.03           H  
ATOM   1185  HE2 HIS A  76      16.691  -6.025  23.408  1.00 37.86           H  
ATOM   1186  N   PHE A  77      19.067  -9.799  17.697  1.00 41.54           N  
ATOM   1187  CA  PHE A  77      19.609 -10.302  16.446  1.00 70.31           C  
ATOM   1188  C   PHE A  77      19.854  -9.153  15.480  1.00  2.50           C  
ATOM   1189  O   PHE A  77      18.934  -8.403  15.167  1.00 34.04           O  
ATOM   1190  CB  PHE A  77      18.640 -11.292  15.790  1.00 63.23           C  
ATOM   1191  CG  PHE A  77      18.217 -12.440  16.664  1.00 72.54           C  
ATOM   1192  CD1 PHE A  77      17.188 -12.287  17.582  1.00 42.42           C  
ATOM   1193  CD2 PHE A  77      18.832 -13.675  16.553  1.00 41.01           C  
ATOM   1194  CE1 PHE A  77      16.784 -13.345  18.374  1.00 13.11           C  
ATOM   1195  CE2 PHE A  77      18.432 -14.735  17.343  1.00 54.43           C  
ATOM   1196  CZ  PHE A  77      17.409 -14.570  18.255  1.00 63.44           C  
ATOM   1197  H   PHE A  77      18.092  -9.724  17.802  1.00 73.33           H  
ATOM   1198  HA  PHE A  77      20.545 -10.798  16.655  1.00 25.10           H  
ATOM   1199  HB2 PHE A  77      17.749 -10.763  15.497  1.00 37.86           H  
ATOM   1200  HB3 PHE A  77      19.109 -11.704  14.907  1.00 37.86           H  
ATOM   1201  HD1 PHE A  77      16.700 -11.329  17.676  1.00 71.55           H  
ATOM   1202  HD2 PHE A  77      19.634 -13.807  15.840  1.00  0.54           H  
ATOM   1203  HE1 PHE A  77      15.983 -13.212  19.087  1.00  4.34           H  
ATOM   1204  HE2 PHE A  77      18.922 -15.694  17.249  1.00 41.11           H  
ATOM   1205  HZ  PHE A  77      17.095 -15.400  18.873  1.00 33.24           H  
ATOM   1206  N   ARG A  78      21.087  -8.996  15.022  1.00 24.13           N  
ATOM   1207  CA  ARG A  78      21.355  -8.044  13.955  1.00 62.13           C  
ATOM   1208  C   ARG A  78      20.886  -8.660  12.645  1.00 34.42           C  
ATOM   1209  O   ARG A  78      21.342  -9.742  12.273  1.00 65.55           O  
ATOM   1210  CB  ARG A  78      22.841  -7.665  13.897  1.00 10.33           C  
ATOM   1211  CG  ARG A  78      23.123  -6.495  12.966  1.00 34.33           C  
ATOM   1212  CD  ARG A  78      24.505  -5.892  13.189  1.00 54.30           C  
ATOM   1213  NE  ARG A  78      25.588  -6.773  12.750  1.00 54.11           N  
ATOM   1214  CZ  ARG A  78      26.809  -6.340  12.432  1.00 70.34           C  
ATOM   1215  NH1 ARG A  78      27.101  -5.046  12.521  1.00 75.15           N  
ATOM   1216  NH2 ARG A  78      27.738  -7.197  12.026  1.00 62.52           N  
ATOM   1217  H   ARG A  78      21.818  -9.528  15.402  1.00 51.51           H  
ATOM   1218  HA  ARG A  78      20.768  -7.156  14.149  1.00 72.42           H  
ATOM   1219  HB2 ARG A  78      23.172  -7.396  14.890  1.00 37.86           H  
ATOM   1220  HB3 ARG A  78      23.408  -8.517  13.555  1.00 37.86           H  
ATOM   1221  HG2 ARG A  78      23.059  -6.839  11.945  1.00 37.86           H  
ATOM   1222  HG3 ARG A  78      22.376  -5.731  13.135  1.00 37.86           H  
ATOM   1223  HD2 ARG A  78      24.571  -4.965  12.640  1.00 37.86           H  
ATOM   1224  HD3 ARG A  78      24.627  -5.692  14.241  1.00 37.86           H  
ATOM   1225  HE  ARG A  78      25.392  -7.730  12.681  1.00 31.14           H  
ATOM   1226 HH11 ARG A  78      26.410  -4.392  12.830  1.00 37.86           H  
ATOM   1227 HH12 ARG A  78      28.013  -4.714  12.260  1.00 37.86           H  
ATOM   1228 HH21 ARG A  78      27.527  -8.186  11.951  1.00 37.86           H  
ATOM   1229 HH22 ARG A  78      28.665  -6.868  11.790  1.00 37.86           H  
ATOM   1230  N   LEU A  79      19.979  -7.967  11.962  1.00 72.51           N  
ATOM   1231  CA  LEU A  79      19.196  -8.545  10.864  1.00 43.25           C  
ATOM   1232  C   LEU A  79      20.049  -9.243   9.802  1.00 70.22           C  
ATOM   1233  O   LEU A  79      19.774 -10.380   9.434  1.00 34.52           O  
ATOM   1234  CB  LEU A  79      18.334  -7.462  10.209  1.00 73.21           C  
ATOM   1235  CG  LEU A  79      17.314  -6.797  11.137  1.00 65.12           C  
ATOM   1236  CD1 LEU A  79      16.459  -5.802  10.369  1.00 63.13           C  
ATOM   1237  CD2 LEU A  79      16.442  -7.844  11.810  1.00 43.42           C  
ATOM   1238  H   LEU A  79      19.826  -7.026  12.202  1.00 32.14           H  
ATOM   1239  HA  LEU A  79      18.536  -9.280  11.296  1.00 71.14           H  
ATOM   1240  HB2 LEU A  79      18.990  -6.697   9.820  1.00 37.86           H  
ATOM   1241  HB3 LEU A  79      17.799  -7.908   9.384  1.00 37.86           H  
ATOM   1242  HG  LEU A  79      17.842  -6.254  11.909  1.00  3.41           H  
ATOM   1243 HD11 LEU A  79      15.926  -6.318   9.583  1.00 37.86           H  
ATOM   1244 HD12 LEU A  79      17.091  -5.041   9.935  1.00 37.86           H  
ATOM   1245 HD13 LEU A  79      15.750  -5.340  11.042  1.00 37.86           H  
ATOM   1246 HD21 LEU A  79      17.068  -8.536  12.358  1.00 37.86           H  
ATOM   1247 HD22 LEU A  79      15.882  -8.382  11.061  1.00 37.86           H  
ATOM   1248 HD23 LEU A  79      15.760  -7.360  12.492  1.00 37.86           H  
ATOM   1249  N   TYR A  80      21.081  -8.572   9.318  1.00 22.21           N  
ATOM   1250  CA  TYR A  80      21.886  -9.112   8.228  1.00 14.24           C  
ATOM   1251  C   TYR A  80      23.039  -9.965   8.761  1.00 61.45           C  
ATOM   1252  O   TYR A  80      23.786 -10.571   7.994  1.00 44.05           O  
ATOM   1253  CB  TYR A  80      22.420  -7.961   7.364  1.00 64.41           C  
ATOM   1254  CG  TYR A  80      23.089  -8.400   6.078  1.00 22.22           C  
ATOM   1255  CD1 TYR A  80      22.343  -8.908   5.020  1.00 52.15           C  
ATOM   1256  CD2 TYR A  80      24.466  -8.308   5.925  1.00 74.21           C  
ATOM   1257  CE1 TYR A  80      22.952  -9.310   3.846  1.00 54.31           C  
ATOM   1258  CE2 TYR A  80      25.081  -8.707   4.756  1.00 72.12           C  
ATOM   1259  CZ  TYR A  80      24.322  -9.208   3.720  1.00 21.42           C  
ATOM   1260  OH  TYR A  80      24.938  -9.606   2.553  1.00 30.23           O  
ATOM   1261  H   TYR A  80      21.306  -7.689   9.696  1.00 25.50           H  
ATOM   1262  HA  TYR A  80      21.245  -9.735   7.623  1.00  2.13           H  
ATOM   1263  HB2 TYR A  80      21.599  -7.312   7.101  1.00 37.86           H  
ATOM   1264  HB3 TYR A  80      23.142  -7.397   7.939  1.00 37.86           H  
ATOM   1265  HD1 TYR A  80      21.270  -8.985   5.124  1.00 51.22           H  
ATOM   1266  HD2 TYR A  80      25.060  -7.915   6.738  1.00 53.12           H  
ATOM   1267  HE1 TYR A  80      22.354  -9.702   3.034  1.00  5.00           H  
ATOM   1268  HE2 TYR A  80      26.154  -8.627   4.656  1.00 14.31           H  
ATOM   1269  HH  TYR A  80      24.442  -9.263   1.792  1.00 54.55           H  
ATOM   1270  N   ASP A  81      23.164 -10.040  10.081  1.00 43.53           N  
ATOM   1271  CA  ASP A  81      24.286 -10.744  10.686  1.00 11.31           C  
ATOM   1272  C   ASP A  81      23.850 -12.104  11.207  1.00 13.03           C  
ATOM   1273  O   ASP A  81      24.350 -13.138  10.766  1.00 11.24           O  
ATOM   1274  CB  ASP A  81      24.890  -9.927  11.824  1.00 64.13           C  
ATOM   1275  CG  ASP A  81      26.263 -10.429  12.218  1.00 50.44           C  
ATOM   1276  OD1 ASP A  81      26.353 -11.440  12.945  1.00 44.22           O  
ATOM   1277  OD2 ASP A  81      27.260  -9.796  11.815  1.00 43.41           O  
ATOM   1278  H   ASP A  81      22.475  -9.639  10.654  1.00 51.21           H  
ATOM   1279  HA  ASP A  81      25.034 -10.889   9.923  1.00 75.30           H  
ATOM   1280  HB2 ASP A  81      24.978  -8.897  11.515  1.00 37.86           H  
ATOM   1281  HB3 ASP A  81      24.244  -9.987  12.687  1.00 37.86           H  
ATOM   1282  N   GLY A  82      22.913 -12.097  12.145  1.00 70.11           N  
ATOM   1283  CA  GLY A  82      22.402 -13.341  12.683  1.00 13.51           C  
ATOM   1284  C   GLY A  82      22.828 -13.603  14.116  1.00 33.24           C  
ATOM   1285  O   GLY A  82      22.197 -14.404  14.810  1.00 34.45           O  
ATOM   1286  H   GLY A  82      22.551 -11.240  12.462  1.00 75.51           H  
ATOM   1287  HA2 GLY A  82      21.324 -13.318  12.642  1.00 37.86           H  
ATOM   1288  HA3 GLY A  82      22.754 -14.153  12.062  1.00 37.86           H  
ATOM   1289  N   PHE A  83      23.890 -12.941  14.570  1.00 73.53           N  
ATOM   1290  CA  PHE A  83      24.385 -13.162  15.929  1.00 31.54           C  
ATOM   1291  C   PHE A  83      23.481 -12.464  16.944  1.00 34.04           C  
ATOM   1292  O   PHE A  83      22.767 -11.512  16.607  1.00 61.13           O  
ATOM   1293  CB  PHE A  83      25.844 -12.701  16.075  1.00 70.35           C  
ATOM   1294  CG  PHE A  83      26.029 -11.251  16.441  1.00 21.04           C  
ATOM   1295  CD1 PHE A  83      25.671 -10.240  15.565  1.00 71.33           C  
ATOM   1296  CD2 PHE A  83      26.589 -10.908  17.660  1.00 43.20           C  
ATOM   1297  CE1 PHE A  83      25.864  -8.915  15.900  1.00 24.25           C  
ATOM   1298  CE2 PHE A  83      26.782  -9.587  18.000  1.00 71.10           C  
ATOM   1299  CZ  PHE A  83      26.421  -8.588  17.121  1.00 10.55           C  
ATOM   1300  H   PHE A  83      24.350 -12.304  13.983  1.00 43.42           H  
ATOM   1301  HA  PHE A  83      24.338 -14.227  16.114  1.00 52.24           H  
ATOM   1302  HB2 PHE A  83      26.322 -13.290  16.843  1.00 37.86           H  
ATOM   1303  HB3 PHE A  83      26.355 -12.871  15.138  1.00 37.86           H  
ATOM   1304  HD1 PHE A  83      25.232 -10.498  14.609  1.00  5.30           H  
ATOM   1305  HD2 PHE A  83      26.873 -11.687  18.350  1.00 31.21           H  
ATOM   1306  HE1 PHE A  83      25.581  -8.135  15.207  1.00 10.43           H  
ATOM   1307  HE2 PHE A  83      27.217  -9.334  18.954  1.00 42.54           H  
ATOM   1308  HZ  PHE A  83      26.573  -7.553  17.387  1.00 33.12           H  
ATOM   1309  N   CYS A  84      23.516 -12.936  18.184  1.00 61.23           N  
ATOM   1310  CA  CYS A  84      22.572 -12.487  19.199  1.00 24.55           C  
ATOM   1311  C   CYS A  84      23.232 -11.604  20.251  1.00 10.30           C  
ATOM   1312  O   CYS A  84      23.797 -12.113  21.216  1.00 62.31           O  
ATOM   1313  CB  CYS A  84      21.947 -13.699  19.885  1.00 24.25           C  
ATOM   1314  SG  CYS A  84      21.422 -14.992  18.744  1.00 74.21           S  
ATOM   1315  H   CYS A  84      24.193 -13.600  18.424  1.00 54.13           H  
ATOM   1316  HA  CYS A  84      21.793 -11.924  18.707  1.00 11.31           H  
ATOM   1317  HB2 CYS A  84      22.668 -14.132  20.562  1.00 37.86           H  
ATOM   1318  HB3 CYS A  84      21.080 -13.379  20.443  1.00 37.86           H  
ATOM   1319  HG  CYS A  84      21.398 -14.476  17.522  1.00 62.12           H  
ATOM   1320  N   LEU A  85      23.153 -10.288  20.045  1.00 60.44           N  
ATOM   1321  CA  LEU A  85      23.596  -9.286  21.024  1.00 30.42           C  
ATOM   1322  C   LEU A  85      25.092  -9.382  21.319  1.00 25.22           C  
ATOM   1323  O   LEU A  85      25.884  -8.575  20.832  1.00  5.31           O  
ATOM   1324  CB  LEU A  85      22.786  -9.420  22.318  1.00 74.25           C  
ATOM   1325  CG  LEU A  85      23.100  -8.387  23.403  1.00 43.22           C  
ATOM   1326  CD1 LEU A  85      22.824  -6.978  22.902  1.00 53.32           C  
ATOM   1327  CD2 LEU A  85      22.286  -8.673  24.653  1.00 54.32           C  
ATOM   1328  H   LEU A  85      22.771  -9.972  19.195  1.00 21.11           H  
ATOM   1329  HA  LEU A  85      23.399  -8.315  20.598  1.00 23.50           H  
ATOM   1330  HB2 LEU A  85      21.737  -9.340  22.070  1.00 37.86           H  
ATOM   1331  HB3 LEU A  85      22.966 -10.402  22.727  1.00 37.86           H  
ATOM   1332  HG  LEU A  85      24.148  -8.452  23.663  1.00 42.40           H  
ATOM   1333 HD11 LEU A  85      21.778  -6.885  22.645  1.00 37.86           H  
ATOM   1334 HD12 LEU A  85      23.428  -6.780  22.029  1.00 37.86           H  
ATOM   1335 HD13 LEU A  85      23.068  -6.267  23.678  1.00 37.86           H  
ATOM   1336 HD21 LEU A  85      22.520  -9.663  25.017  1.00 37.86           H  
ATOM   1337 HD22 LEU A  85      21.233  -8.616  24.418  1.00 37.86           H  
ATOM   1338 HD23 LEU A  85      22.525  -7.943  25.414  1.00 37.86           H  
ATOM   1339  N   GLU A  86      25.469 -10.354  22.125  1.00 52.42           N  
ATOM   1340  CA  GLU A  86      26.868 -10.560  22.470  1.00 72.31           C  
ATOM   1341  C   GLU A  86      27.238 -12.032  22.294  1.00 33.53           C  
ATOM   1342  O   GLU A  86      28.158 -12.367  21.551  1.00 35.32           O  
ATOM   1343  CB  GLU A  86      27.133 -10.114  23.915  1.00 52.22           C  
ATOM   1344  CG  GLU A  86      28.470  -9.406  24.118  1.00 71.12           C  
ATOM   1345  CD  GLU A  86      29.675 -10.257  23.757  1.00  3.11           C  
ATOM   1346  OE1 GLU A  86      30.199 -10.966  24.642  1.00 24.11           O  
ATOM   1347  OE2 GLU A  86      30.119 -10.203  22.591  1.00 62.11           O  
ATOM   1348  H   GLU A  86      24.781 -10.963  22.492  1.00 23.41           H  
ATOM   1349  HA  GLU A  86      27.467  -9.963  21.798  1.00 34.03           H  
ATOM   1350  HB2 GLU A  86      26.348  -9.438  24.221  1.00 37.86           H  
ATOM   1351  HB3 GLU A  86      27.112 -10.983  24.554  1.00 37.86           H  
ATOM   1352  HG2 GLU A  86      28.486  -8.518  23.505  1.00 37.86           H  
ATOM   1353  HG3 GLU A  86      28.552  -9.121  25.157  1.00 37.86           H  
ATOM   1354  N   ASP A  87      26.496 -12.905  22.965  1.00 24.55           N  
ATOM   1355  CA  ASP A  87      26.769 -14.337  22.923  1.00 71.22           C  
ATOM   1356  C   ASP A  87      25.821 -15.035  21.957  1.00 42.43           C  
ATOM   1357  O   ASP A  87      24.610 -15.093  22.183  1.00 61.30           O  
ATOM   1358  CB  ASP A  87      26.645 -14.946  24.323  1.00 44.21           C  
ATOM   1359  CG  ASP A  87      26.854 -16.449  24.327  1.00 53.33           C  
ATOM   1360  OD1 ASP A  87      28.007 -16.898  24.153  1.00 74.44           O  
ATOM   1361  OD2 ASP A  87      25.865 -17.189  24.501  1.00 53.13           O  
ATOM   1362  H   ASP A  87      25.730 -12.579  23.493  1.00 61.10           H  
ATOM   1363  HA  ASP A  87      27.783 -14.470  22.571  1.00 14.43           H  
ATOM   1364  HB2 ASP A  87      27.385 -14.497  24.969  1.00 37.86           H  
ATOM   1365  HB3 ASP A  87      25.659 -14.738  24.715  1.00 37.86           H  
ATOM   1366  N   GLY A  88      26.383 -15.561  20.879  1.00  1.23           N  
ATOM   1367  CA  GLY A  88      25.586 -16.198  19.851  1.00 13.42           C  
ATOM   1368  C   GLY A  88      25.246 -17.640  20.177  1.00 73.34           C  
ATOM   1369  O   GLY A  88      25.748 -18.564  19.538  1.00 50.12           O  
ATOM   1370  H   GLY A  88      27.355 -15.518  20.783  1.00 41.52           H  
ATOM   1371  HA2 GLY A  88      24.669 -15.641  19.729  1.00 37.86           H  
ATOM   1372  HA3 GLY A  88      26.137 -16.171  18.922  1.00 37.86           H  
ATOM   1373  N   ALA A  89      24.396 -17.836  21.174  1.00 22.01           N  
ATOM   1374  CA  ALA A  89      23.951 -19.172  21.554  1.00 55.21           C  
ATOM   1375  C   ALA A  89      22.636 -19.522  20.867  1.00 20.50           C  
ATOM   1376  O   ALA A  89      22.021 -20.552  21.157  1.00 63.42           O  
ATOM   1377  CB  ALA A  89      23.796 -19.266  23.063  1.00 54.51           C  
ATOM   1378  H   ALA A  89      24.068 -17.059  21.680  1.00 30.11           H  
ATOM   1379  HA  ALA A  89      24.708 -19.880  21.246  1.00 72.11           H  
ATOM   1380  HB1 ALA A  89      24.737 -19.031  23.537  1.00 37.86           H  
ATOM   1381  HB2 ALA A  89      23.498 -20.269  23.334  1.00 37.86           H  
ATOM   1382  HB3 ALA A  89      23.042 -18.565  23.392  1.00 37.86           H  
ATOM   1383  N   TYR A  90      22.212 -18.658  19.957  1.00 52.14           N  
ATOM   1384  CA  TYR A  90      20.942 -18.833  19.263  1.00 60.20           C  
ATOM   1385  C   TYR A  90      20.998 -18.152  17.894  1.00 12.24           C  
ATOM   1386  O   TYR A  90      19.985 -17.704  17.363  1.00 62.30           O  
ATOM   1387  CB  TYR A  90      19.815 -18.247  20.121  1.00  4.24           C  
ATOM   1388  CG  TYR A  90      18.426 -18.691  19.719  1.00 23.34           C  
ATOM   1389  CD1 TYR A  90      18.136 -20.035  19.518  1.00 22.03           C  
ATOM   1390  CD2 TYR A  90      17.405 -17.768  19.549  1.00 52.33           C  
ATOM   1391  CE1 TYR A  90      16.866 -20.444  19.159  1.00 72.42           C  
ATOM   1392  CE2 TYR A  90      16.134 -18.169  19.195  1.00 45.14           C  
ATOM   1393  CZ  TYR A  90      15.870 -19.506  19.000  1.00 50.12           C  
ATOM   1394  OH  TYR A  90      14.601 -19.906  18.654  1.00 51.52           O  
ATOM   1395  H   TYR A  90      22.764 -17.876  19.748  1.00 70.32           H  
ATOM   1396  HA  TYR A  90      20.775 -19.890  19.126  1.00  1.34           H  
ATOM   1397  HB2 TYR A  90      19.968 -18.542  21.148  1.00 37.86           H  
ATOM   1398  HB3 TYR A  90      19.852 -17.168  20.056  1.00 37.86           H  
ATOM   1399  HD1 TYR A  90      18.921 -20.766  19.642  1.00 51.15           H  
ATOM   1400  HD2 TYR A  90      17.614 -16.720  19.698  1.00 72.42           H  
ATOM   1401  HE1 TYR A  90      16.659 -21.494  19.005  1.00 30.33           H  
ATOM   1402  HE2 TYR A  90      15.350 -17.436  19.068  1.00 42.02           H  
ATOM   1403  HH  TYR A  90      14.289 -19.381  17.909  1.00 21.42           H  
ATOM   1404  N   SER A  91      22.199 -18.098  17.328  1.00  1.34           N  
ATOM   1405  CA  SER A  91      22.429 -17.421  16.056  1.00 44.54           C  
ATOM   1406  C   SER A  91      21.665 -18.102  14.919  1.00 12.35           C  
ATOM   1407  O   SER A  91      21.568 -19.329  14.867  1.00  3.41           O  
ATOM   1408  CB  SER A  91      23.926 -17.403  15.752  1.00  1.32           C  
ATOM   1409  OG  SER A  91      24.659 -16.928  16.872  1.00 11.34           O  
ATOM   1410  H   SER A  91      22.953 -18.535  17.769  1.00  1.13           H  
ATOM   1411  HA  SER A  91      22.080 -16.406  16.152  1.00 34.21           H  
ATOM   1412  HB2 SER A  91      24.259 -18.403  15.514  1.00 37.86           H  
ATOM   1413  HB3 SER A  91      24.113 -16.751  14.912  1.00 37.86           H  
ATOM   1414  HG  SER A  91      25.544 -16.656  16.586  1.00 53.24           H  
ATOM   1415  N   VAL A  92      21.121 -17.297  14.014  1.00 71.01           N  
ATOM   1416  CA  VAL A  92      20.341 -17.813  12.895  1.00 55.43           C  
ATOM   1417  C   VAL A  92      21.146 -17.778  11.596  1.00 32.10           C  
ATOM   1418  O   VAL A  92      22.305 -17.366  11.589  1.00 52.13           O  
ATOM   1419  CB  VAL A  92      19.029 -17.023  12.713  1.00 20.04           C  
ATOM   1420  CG1 VAL A  92      18.127 -17.203  13.925  1.00 74.43           C  
ATOM   1421  CG2 VAL A  92      19.312 -15.544  12.468  1.00 14.23           C  
ATOM   1422  H   VAL A  92      21.254 -16.327  14.097  1.00 61.23           H  
ATOM   1423  HA  VAL A  92      20.086 -18.840  13.117  1.00 22.35           H  
ATOM   1424  HB  VAL A  92      18.512 -17.417  11.847  1.00 15.11           H  
ATOM   1425 HG11 VAL A  92      17.898 -18.251  14.049  1.00 37.86           H  
ATOM   1426 HG12 VAL A  92      17.212 -16.649  13.778  1.00 37.86           H  
ATOM   1427 HG13 VAL A  92      18.633 -16.840  14.807  1.00 37.86           H  
ATOM   1428 HG21 VAL A  92      19.928 -15.437  11.587  1.00 37.86           H  
ATOM   1429 HG22 VAL A  92      19.827 -15.129  13.320  1.00 37.86           H  
ATOM   1430 HG23 VAL A  92      18.379 -15.018  12.321  1.00 37.86           H  
ATOM   1431  N   ALA A  93      20.528 -18.203  10.500  1.00 32.34           N  
ATOM   1432  CA  ALA A  93      21.215 -18.274   9.217  1.00 20.41           C  
ATOM   1433  C   ALA A  93      20.849 -17.091   8.331  1.00 50.12           C  
ATOM   1434  O   ALA A  93      19.670 -16.786   8.142  1.00 50.32           O  
ATOM   1435  CB  ALA A  93      20.888 -19.582   8.516  1.00 34.52           C  
ATOM   1436  H   ALA A  93      19.584 -18.468  10.554  1.00 44.04           H  
ATOM   1437  HA  ALA A  93      22.279 -18.252   9.407  1.00 72.14           H  
ATOM   1438  HB1 ALA A  93      21.071 -20.407   9.189  1.00 37.86           H  
ATOM   1439  HB2 ALA A  93      21.510 -19.689   7.638  1.00 37.86           H  
ATOM   1440  HB3 ALA A  93      19.849 -19.582   8.223  1.00 37.86           H  
ATOM   1441  N   ALA A  94      21.863 -16.443   7.774  1.00 34.23           N  
ATOM   1442  CA  ALA A  94      21.664 -15.262   6.954  1.00 70.33           C  
ATOM   1443  C   ALA A  94      22.154 -15.509   5.534  1.00 71.22           C  
ATOM   1444  O   ALA A  94      23.359 -15.561   5.278  1.00 21.43           O  
ATOM   1445  CB  ALA A  94      22.374 -14.062   7.566  1.00 43.43           C  
ATOM   1446  H   ALA A  94      22.769 -16.778   7.905  1.00 52.05           H  
ATOM   1447  HA  ALA A  94      20.605 -15.052   6.925  1.00 34.22           H  
ATOM   1448  HB1 ALA A  94      23.438 -14.245   7.590  1.00 37.86           H  
ATOM   1449  HB2 ALA A  94      22.014 -13.903   8.572  1.00 37.86           H  
ATOM   1450  HB3 ALA A  94      22.174 -13.184   6.969  1.00 37.86           H  
ATOM   1451  N   TYR A  95      21.213 -15.691   4.628  1.00 72.50           N  
ATOM   1452  CA  TYR A  95      21.526 -15.889   3.220  1.00 33.25           C  
ATOM   1453  C   TYR A  95      21.453 -14.560   2.479  1.00 21.11           C  
ATOM   1454  O   TYR A  95      20.805 -13.621   2.946  1.00 32.00           O  
ATOM   1455  CB  TYR A  95      20.561 -16.900   2.596  1.00 35.15           C  
ATOM   1456  CG  TYR A  95      20.667 -18.292   3.182  1.00  5.50           C  
ATOM   1457  CD1 TYR A  95      21.557 -19.219   2.661  1.00 61.32           C  
ATOM   1458  CD2 TYR A  95      19.876 -18.679   4.259  1.00 23.12           C  
ATOM   1459  CE1 TYR A  95      21.654 -20.491   3.192  1.00 71.42           C  
ATOM   1460  CE2 TYR A  95      19.968 -19.949   4.794  1.00 31.51           C  
ATOM   1461  CZ  TYR A  95      20.857 -20.851   4.258  1.00 13.33           C  
ATOM   1462  OH  TYR A  95      20.950 -22.119   4.790  1.00 73.21           O  
ATOM   1463  H   TYR A  95      20.279 -15.680   4.912  1.00 64.23           H  
ATOM   1464  HA  TYR A  95      22.533 -16.272   3.152  1.00 24.21           H  
ATOM   1465  HB2 TYR A  95      19.548 -16.558   2.744  1.00 37.86           H  
ATOM   1466  HB3 TYR A  95      20.758 -16.970   1.536  1.00 37.86           H  
ATOM   1467  HD1 TYR A  95      22.183 -18.936   1.827  1.00 73.01           H  
ATOM   1468  HD2 TYR A  95      19.177 -17.970   4.677  1.00 75.35           H  
ATOM   1469  HE1 TYR A  95      22.352 -21.199   2.770  1.00 72.33           H  
ATOM   1470  HE2 TYR A  95      19.344 -20.230   5.629  1.00 54.42           H  
ATOM   1471  HH  TYR A  95      20.067 -22.461   4.970  1.00 75.42           H  
ATOM   1472  N   ASP A  96      22.121 -14.478   1.334  1.00 12.33           N  
ATOM   1473  CA  ASP A  96      22.160 -13.239   0.563  1.00 75.20           C  
ATOM   1474  C   ASP A  96      20.913 -13.102  -0.308  1.00 15.34           C  
ATOM   1475  O   ASP A  96      20.330 -14.103  -0.739  1.00 72.24           O  
ATOM   1476  CB  ASP A  96      23.424 -13.180  -0.297  1.00 22.14           C  
ATOM   1477  CG  ASP A  96      23.613 -11.829  -0.960  1.00 24.52           C  
ATOM   1478  OD1 ASP A  96      23.188 -10.810  -0.381  1.00 11.13           O  
ATOM   1479  OD2 ASP A  96      24.216 -11.776  -2.052  1.00  4.44           O  
ATOM   1480  H   ASP A  96      22.597 -15.270   0.997  1.00 75.30           H  
ATOM   1481  HA  ASP A  96      22.178 -12.418   1.265  1.00 31.44           H  
ATOM   1482  HB2 ASP A  96      24.286 -13.376   0.324  1.00 37.86           H  
ATOM   1483  HB3 ASP A  96      23.362 -13.934  -1.069  1.00 37.86           H  
ATOM   1484  N   THR A  97      20.525 -11.863  -0.575  1.00 51.41           N  
ATOM   1485  CA  THR A  97      19.273 -11.569  -1.256  1.00 33.04           C  
ATOM   1486  C   THR A  97      19.473 -10.533  -2.360  1.00 33.43           C  
ATOM   1487  O   THR A  97      20.366  -9.690  -2.274  1.00  2.41           O  
ATOM   1488  CB  THR A  97      18.237 -11.024  -0.254  1.00 20.22           C  
ATOM   1489  OG1 THR A  97      18.805  -9.946   0.507  1.00 24.44           O  
ATOM   1490  CG2 THR A  97      17.768 -12.111   0.693  1.00 65.22           C  
ATOM   1491  H   THR A  97      21.113 -11.117  -0.320  1.00 54.51           H  
ATOM   1492  HA  THR A  97      18.886 -12.485  -1.686  1.00 11.43           H  
ATOM   1493  HB  THR A  97      17.383 -10.656  -0.805  1.00 74.01           H  
ATOM   1494  HG1 THR A  97      19.446  -9.471  -0.036  1.00 35.04           H  
ATOM   1495 HG21 THR A  97      17.288 -12.895   0.126  1.00 37.86           H  
ATOM   1496 HG22 THR A  97      17.065 -11.694   1.399  1.00 37.86           H  
ATOM   1497 HG23 THR A  97      18.616 -12.517   1.224  1.00 37.86           H  
ATOM   1498  N   GLN A  98      18.641 -10.599  -3.392  1.00 72.25           N  
ATOM   1499  CA  GLN A  98      18.631  -9.582  -4.436  1.00 45.22           C  
ATOM   1500  C   GLN A  98      17.196  -9.199  -4.776  1.00 61.51           C  
ATOM   1501  O   GLN A  98      16.264  -9.960  -4.516  1.00 23.42           O  
ATOM   1502  CB  GLN A  98      19.354 -10.054  -5.703  1.00  0.33           C  
ATOM   1503  CG  GLN A  98      18.668 -11.206  -6.425  1.00 13.01           C  
ATOM   1504  CD  GLN A  98      19.135 -11.357  -7.864  1.00 51.54           C  
ATOM   1505  OE1 GLN A  98      19.175 -12.461  -8.407  1.00 43.52           O  
ATOM   1506  NE2 GLN A  98      19.482 -10.247  -8.499  1.00 74.20           N  
ATOM   1507  H   GLN A  98      18.007 -11.351  -3.450  1.00 41.33           H  
ATOM   1508  HA  GLN A  98      19.137  -8.709  -4.047  1.00 33.32           H  
ATOM   1509  HB2 GLN A  98      19.426  -9.223  -6.389  1.00 37.86           H  
ATOM   1510  HB3 GLN A  98      20.350 -10.371  -5.434  1.00 37.86           H  
ATOM   1511  HG2 GLN A  98      18.880 -12.124  -5.896  1.00 37.86           H  
ATOM   1512  HG3 GLN A  98      17.604 -11.030  -6.425  1.00 37.86           H  
ATOM   1513 HE21 GLN A  98      19.422  -9.395  -8.017  1.00 37.86           H  
ATOM   1514 HE22 GLN A  98      19.772 -10.324  -9.438  1.00 37.86           H  
ATOM   1515  N   VAL A  99      17.019  -8.018  -5.346  1.00 70.24           N  
ATOM   1516  CA  VAL A  99      15.702  -7.557  -5.758  1.00 43.31           C  
ATOM   1517  C   VAL A  99      15.659  -7.392  -7.271  1.00 53.15           C  
ATOM   1518  O   VAL A  99      16.279  -6.483  -7.822  1.00 52.22           O  
ATOM   1519  CB  VAL A  99      15.330  -6.215  -5.090  1.00 64.15           C  
ATOM   1520  CG1 VAL A  99      13.922  -5.790  -5.475  1.00 14.12           C  
ATOM   1521  CG2 VAL A  99      15.464  -6.310  -3.579  1.00 22.05           C  
ATOM   1522  H   VAL A  99      17.799  -7.437  -5.499  1.00 65.23           H  
ATOM   1523  HA  VAL A  99      14.975  -8.303  -5.466  1.00 32.34           H  
ATOM   1524  HB  VAL A  99      16.017  -5.460  -5.442  1.00 70.12           H  
ATOM   1525 HG11 VAL A  99      13.861  -5.673  -6.546  1.00 37.86           H  
ATOM   1526 HG12 VAL A  99      13.687  -4.851  -4.996  1.00 37.86           H  
ATOM   1527 HG13 VAL A  99      13.217  -6.543  -5.154  1.00 37.86           H  
ATOM   1528 HG21 VAL A  99      15.225  -5.353  -3.138  1.00 37.86           H  
ATOM   1529 HG22 VAL A  99      16.478  -6.582  -3.324  1.00 37.86           H  
ATOM   1530 HG23 VAL A  99      14.785  -7.060  -3.203  1.00 37.86           H  
ATOM   1531  N   THR A 100      14.943  -8.285  -7.940  1.00 41.55           N  
ATOM   1532  CA  THR A 100      14.845  -8.244  -9.391  1.00  1.53           C  
ATOM   1533  C   THR A 100      13.926  -7.108  -9.855  1.00 71.52           C  
ATOM   1534  O   THR A 100      14.397  -6.068 -10.317  1.00 14.50           O  
ATOM   1535  CB  THR A 100      14.388  -9.608  -9.974  1.00 63.54           C  
ATOM   1536  OG1 THR A 100      14.045  -9.475 -11.357  1.00 63.42           O  
ATOM   1537  CG2 THR A 100      13.208 -10.191  -9.206  1.00 40.33           C  
ATOM   1538  H   THR A 100      14.469  -8.987  -7.444  1.00 21.44           H  
ATOM   1539  HA  THR A 100      15.830  -8.043  -9.768  1.00 53.51           H  
ATOM   1540  HB  THR A 100      15.216 -10.300  -9.893  1.00 14.53           H  
ATOM   1541  HG1 THR A 100      14.195 -10.325 -11.805  1.00 71.43           H  
ATOM   1542 HG21 THR A 100      13.500 -10.371  -8.183  1.00 37.86           H  
ATOM   1543 HG22 THR A 100      12.904 -11.119  -9.665  1.00 37.86           H  
ATOM   1544 HG23 THR A 100      12.385  -9.491  -9.228  1.00 37.86           H  
ATOM   1545  N   ASN A 101      12.629  -7.306  -9.722  1.00  4.14           N  
ATOM   1546  CA  ASN A 101      11.645  -6.286 -10.071  1.00 12.34           C  
ATOM   1547  C   ASN A 101      10.476  -6.344  -9.104  1.00 60.11           C  
ATOM   1548  O   ASN A 101       9.505  -7.063  -9.331  1.00 62.23           O  
ATOM   1549  CB  ASN A 101      11.129  -6.449 -11.508  1.00 71.32           C  
ATOM   1550  CG  ASN A 101      12.148  -6.051 -12.557  1.00  2.00           C  
ATOM   1551  OD1 ASN A 101      12.261  -4.877 -12.915  1.00  4.11           O  
ATOM   1552  ND2 ASN A 101      12.885  -7.026 -13.066  1.00 71.54           N  
ATOM   1553  H   ASN A 101      12.321  -8.166  -9.376  1.00 72.14           H  
ATOM   1554  HA  ASN A 101      12.124  -5.323  -9.976  1.00 44.25           H  
ATOM   1555  HB2 ASN A 101      10.864  -7.484 -11.672  1.00 37.86           H  
ATOM   1556  HB3 ASN A 101      10.250  -5.835 -11.638  1.00 37.86           H  
ATOM   1557 HD21 ASN A 101      12.735  -7.938 -12.738  1.00 37.86           H  
ATOM   1558 HD22 ASN A 101      13.541  -6.800 -13.760  1.00 37.86           H  
ATOM   1559  N   GLY A 102      10.602  -5.624  -7.998  1.00 33.44           N  
ATOM   1560  CA  GLY A 102       9.544  -5.589  -7.003  1.00 64.32           C  
ATOM   1561  C   GLY A 102       9.447  -6.872  -6.200  1.00 34.43           C  
ATOM   1562  O   GLY A 102       8.618  -6.985  -5.301  1.00 73.24           O  
ATOM   1563  H   GLY A 102      11.423  -5.096  -7.858  1.00 71.35           H  
ATOM   1564  HA2 GLY A 102       9.732  -4.769  -6.327  1.00 37.86           H  
ATOM   1565  HA3 GLY A 102       8.602  -5.421  -7.503  1.00 37.86           H  
ATOM   1566  N   ASN A 103      10.298  -7.833  -6.519  1.00  1.14           N  
ATOM   1567  CA  ASN A 103      10.284  -9.123  -5.846  1.00 14.12           C  
ATOM   1568  C   ASN A 103      11.667  -9.435  -5.301  1.00 31.22           C  
ATOM   1569  O   ASN A 103      12.675  -9.146  -5.951  1.00 14.55           O  
ATOM   1570  CB  ASN A 103       9.834 -10.235  -6.799  1.00 22.33           C  
ATOM   1571  CG  ASN A 103       8.369 -10.130  -7.187  1.00 44.12           C  
ATOM   1572  OD1 ASN A 103       7.539  -9.673  -6.405  1.00 24.31           O  
ATOM   1573  ND2 ASN A 103       8.043 -10.552  -8.400  1.00  3.52           N  
ATOM   1574  H   ASN A 103      10.957  -7.670  -7.220  1.00 10.32           H  
ATOM   1575  HA  ASN A 103       9.589  -9.059  -5.021  1.00 72.44           H  
ATOM   1576  HB2 ASN A 103      10.427 -10.189  -7.698  1.00 37.86           H  
ATOM   1577  HB3 ASN A 103       9.991 -11.192  -6.320  1.00 37.86           H  
ATOM   1578 HD21 ASN A 103       8.753 -10.906  -8.978  1.00 37.86           H  
ATOM   1579 HD22 ASN A 103       7.102 -10.488  -8.675  1.00 37.86           H  
ATOM   1580  N   VAL A 104      11.712 -10.017  -4.114  1.00  5.32           N  
ATOM   1581  CA  VAL A 104      12.976 -10.310  -3.454  1.00  4.01           C  
ATOM   1582  C   VAL A 104      13.341 -11.780  -3.618  1.00 72.52           C  
ATOM   1583  O   VAL A 104      12.504 -12.664  -3.421  1.00  4.01           O  
ATOM   1584  CB  VAL A 104      12.919  -9.960  -1.953  1.00 44.14           C  
ATOM   1585  CG1 VAL A 104      14.280 -10.161  -1.296  1.00  2.34           C  
ATOM   1586  CG2 VAL A 104      12.435  -8.531  -1.758  1.00 62.51           C  
ATOM   1587  H   VAL A 104      10.874 -10.264  -3.669  1.00  3.50           H  
ATOM   1588  HA  VAL A 104      13.742  -9.703  -3.916  1.00 75.02           H  
ATOM   1589  HB  VAL A 104      12.210 -10.624  -1.476  1.00 23.15           H  
ATOM   1590 HG11 VAL A 104      14.209  -9.930  -0.244  1.00 37.86           H  
ATOM   1591 HG12 VAL A 104      15.003  -9.505  -1.760  1.00 37.86           H  
ATOM   1592 HG13 VAL A 104      14.593 -11.187  -1.421  1.00 37.86           H  
ATOM   1593 HG21 VAL A 104      12.389  -8.308  -0.703  1.00 37.86           H  
ATOM   1594 HG22 VAL A 104      11.453  -8.419  -2.193  1.00 37.86           H  
ATOM   1595 HG23 VAL A 104      13.121  -7.849  -2.240  1.00 37.86           H  
ATOM   1596  N   GLN A 105      14.589 -12.033  -3.986  1.00 10.33           N  
ATOM   1597  CA  GLN A 105      15.067 -13.388  -4.195  1.00 12.25           C  
ATOM   1598  C   GLN A 105      16.277 -13.657  -3.309  1.00 42.11           C  
ATOM   1599  O   GLN A 105      17.017 -12.736  -2.967  1.00 53.24           O  
ATOM   1600  CB  GLN A 105      15.448 -13.593  -5.662  1.00 44.21           C  
ATOM   1601  CG  GLN A 105      14.417 -13.066  -6.643  1.00 54.15           C  
ATOM   1602  CD  GLN A 105      14.743 -13.431  -8.073  1.00  4.34           C  
ATOM   1603  OE1 GLN A 105      15.475 -12.720  -8.757  1.00 32.54           O  
ATOM   1604  NE2 GLN A 105      14.176 -14.528  -8.543  1.00 55.02           N  
ATOM   1605  H   GLN A 105      15.215 -11.283  -4.116  1.00 23.03           H  
ATOM   1606  HA  GLN A 105      14.275 -14.072  -3.933  1.00 45.23           H  
ATOM   1607  HB2 GLN A 105      16.385 -13.087  -5.851  1.00 37.86           H  
ATOM   1608  HB3 GLN A 105      15.579 -14.649  -5.843  1.00 37.86           H  
ATOM   1609  HG2 GLN A 105      13.451 -13.481  -6.391  1.00 37.86           H  
ATOM   1610  HG3 GLN A 105      14.377 -11.990  -6.561  1.00 37.86           H  
ATOM   1611 HE21 GLN A 105      13.580 -15.034  -7.950  1.00 37.86           H  
ATOM   1612 HE22 GLN A 105      14.375 -14.792  -9.467  1.00 37.86           H  
ATOM   1613  N   ILE A 106      16.472 -14.911  -2.936  1.00 53.12           N  
ATOM   1614  CA  ILE A 106      17.611 -15.297  -2.113  1.00 52.10           C  
ATOM   1615  C   ILE A 106      18.440 -16.358  -2.824  1.00 44.14           C  
ATOM   1616  O   ILE A 106      17.934 -17.078  -3.687  1.00 60.42           O  
ATOM   1617  CB  ILE A 106      17.190 -15.843  -0.719  1.00 61.33           C  
ATOM   1618  CG1 ILE A 106      16.640 -17.277  -0.803  1.00 21.11           C  
ATOM   1619  CG2 ILE A 106      16.160 -14.932  -0.072  1.00  1.21           C  
ATOM   1620  CD1 ILE A 106      15.309 -17.406  -1.512  1.00 23.20           C  
ATOM   1621  H   ILE A 106      15.840 -15.597  -3.223  1.00 73.11           H  
ATOM   1622  HA  ILE A 106      18.223 -14.420  -1.964  1.00 12.24           H  
ATOM   1623  HB  ILE A 106      18.068 -15.845  -0.089  1.00  0.14           H  
ATOM   1624 HG12 ILE A 106      17.349 -17.893  -1.332  1.00 37.86           H  
ATOM   1625 HG13 ILE A 106      16.518 -17.662   0.199  1.00 37.86           H  
ATOM   1626 HG21 ILE A 106      16.583 -13.947   0.061  1.00 37.86           H  
ATOM   1627 HG22 ILE A 106      15.876 -15.335   0.888  1.00 37.86           H  
ATOM   1628 HG23 ILE A 106      15.289 -14.866  -0.707  1.00 37.86           H  
ATOM   1629 HD11 ILE A 106      15.013 -18.445  -1.531  1.00 37.86           H  
ATOM   1630 HD12 ILE A 106      15.403 -17.041  -2.525  1.00 37.86           H  
ATOM   1631 HD13 ILE A 106      14.562 -16.828  -0.989  1.00 37.86           H  
ATOM   1632  N   SER A 107      19.712 -16.439  -2.472  1.00 22.35           N  
ATOM   1633  CA  SER A 107      20.579 -17.471  -3.005  1.00 21.32           C  
ATOM   1634  C   SER A 107      20.391 -18.746  -2.184  1.00 43.01           C  
ATOM   1635  O   SER A 107      20.902 -18.855  -1.066  1.00 42.33           O  
ATOM   1636  CB  SER A 107      22.039 -17.002  -2.959  1.00  3.52           C  
ATOM   1637  OG  SER A 107      22.881 -17.814  -3.764  1.00 62.11           O  
ATOM   1638  H   SER A 107      20.074 -15.787  -1.831  1.00 64.12           H  
ATOM   1639  HA  SER A 107      20.292 -17.661  -4.029  1.00 33.00           H  
ATOM   1640  HB2 SER A 107      22.098 -15.985  -3.318  1.00 37.86           H  
ATOM   1641  HB3 SER A 107      22.393 -17.041  -1.941  1.00 37.86           H  
ATOM   1642  HG  SER A 107      22.650 -18.743  -3.641  1.00 43.13           H  
ATOM   1643  N   ILE A 108      19.629 -19.694  -2.718  1.00 25.14           N  
ATOM   1644  CA  ILE A 108      19.272 -20.885  -1.959  1.00  1.13           C  
ATOM   1645  C   ILE A 108      20.398 -21.915  -1.926  1.00 13.54           C  
ATOM   1646  O   ILE A 108      20.474 -22.821  -2.758  1.00 64.33           O  
ATOM   1647  CB  ILE A 108      17.971 -21.552  -2.462  1.00  3.33           C  
ATOM   1648  CG1 ILE A 108      18.029 -21.827  -3.967  1.00 60.12           C  
ATOM   1649  CG2 ILE A 108      16.769 -20.685  -2.124  1.00 50.13           C  
ATOM   1650  CD1 ILE A 108      16.935 -22.756  -4.445  1.00 34.02           C  
ATOM   1651  H   ILE A 108      19.304 -19.591  -3.637  1.00 12.25           H  
ATOM   1652  HA  ILE A 108      19.094 -20.563  -0.941  1.00 74.54           H  
ATOM   1653  HB  ILE A 108      17.856 -22.491  -1.941  1.00 22.01           H  
ATOM   1654 HG12 ILE A 108      17.932 -20.893  -4.500  1.00 37.86           H  
ATOM   1655 HG13 ILE A 108      18.978 -22.279  -4.209  1.00 37.86           H  
ATOM   1656 HG21 ILE A 108      15.870 -21.165  -2.481  1.00 37.86           H  
ATOM   1657 HG22 ILE A 108      16.875 -19.721  -2.597  1.00 37.86           H  
ATOM   1658 HG23 ILE A 108      16.708 -20.556  -1.053  1.00 37.86           H  
ATOM   1659 HD11 ILE A 108      15.970 -22.323  -4.226  1.00 37.86           H  
ATOM   1660 HD12 ILE A 108      17.027 -23.705  -3.941  1.00 37.86           H  
ATOM   1661 HD13 ILE A 108      17.029 -22.905  -5.512  1.00 37.86           H  
ATOM   1662  N   ALA A 109      21.287 -21.749  -0.969  1.00 51.23           N  
ATOM   1663  CA  ALA A 109      22.287 -22.755  -0.680  1.00 53.54           C  
ATOM   1664  C   ALA A 109      21.815 -23.580   0.508  1.00 24.03           C  
ATOM   1665  O   ALA A 109      22.002 -23.184   1.659  1.00 42.45           O  
ATOM   1666  CB  ALA A 109      23.639 -22.113  -0.394  1.00 21.24           C  
ATOM   1667  H   ALA A 109      21.273 -20.922  -0.441  1.00 15.33           H  
ATOM   1668  HA  ALA A 109      22.383 -23.396  -1.544  1.00 23.23           H  
ATOM   1669  HB1 ALA A 109      23.943 -21.522  -1.245  1.00 37.86           H  
ATOM   1670  HB2 ALA A 109      24.373 -22.883  -0.211  1.00 37.86           H  
ATOM   1671  HB3 ALA A 109      23.559 -21.477   0.475  1.00 37.86           H  
ATOM   1672  N   ASP A 110      21.152 -24.697   0.228  1.00 72.33           N  
ATOM   1673  CA  ASP A 110      20.562 -25.514   1.284  1.00 34.13           C  
ATOM   1674  C   ASP A 110      21.633 -26.072   2.210  1.00  1.11           C  
ATOM   1675  O   ASP A 110      22.561 -26.758   1.778  1.00 71.13           O  
ATOM   1676  CB  ASP A 110      19.700 -26.644   0.705  1.00 32.23           C  
ATOM   1677  CG  ASP A 110      20.453 -27.573  -0.230  1.00 62.31           C  
ATOM   1678  OD1 ASP A 110      20.592 -27.239  -1.429  1.00 51.32           O  
ATOM   1679  OD2 ASP A 110      20.894 -28.650   0.222  1.00 51.44           O  
ATOM   1680  H   ASP A 110      21.063 -24.982  -0.706  1.00  4.03           H  
ATOM   1681  HA  ASP A 110      19.924 -24.864   1.866  1.00 64.25           H  
ATOM   1682  HB2 ASP A 110      19.310 -27.236   1.521  1.00 37.86           H  
ATOM   1683  HB3 ASP A 110      18.876 -26.206   0.165  1.00 37.86           H  
ATOM   1684  N   SER A 111      21.494 -25.765   3.488  1.00 41.22           N  
ATOM   1685  CA  SER A 111      22.483 -26.148   4.480  1.00 41.23           C  
ATOM   1686  C   SER A 111      21.979 -27.316   5.319  1.00 21.41           C  
ATOM   1687  O   SER A 111      22.640 -28.349   5.422  1.00 20.24           O  
ATOM   1688  CB  SER A 111      22.806 -24.949   5.376  1.00 54.21           C  
ATOM   1689  OG  SER A 111      23.089 -23.798   4.595  1.00 62.33           O  
ATOM   1690  H   SER A 111      20.695 -25.266   3.773  1.00 13.00           H  
ATOM   1691  HA  SER A 111      23.379 -26.450   3.958  1.00 21.33           H  
ATOM   1692  HB2 SER A 111      21.960 -24.740   6.015  1.00 37.86           H  
ATOM   1693  HB3 SER A 111      23.669 -25.178   5.985  1.00 37.86           H  
ATOM   1694  HG  SER A 111      22.287 -23.250   4.529  1.00 44.31           H  
ATOM   1695  N   ASP A 112      20.804 -27.149   5.911  1.00  4.44           N  
ATOM   1696  CA  ASP A 112      20.203 -28.194   6.728  1.00 35.51           C  
ATOM   1697  C   ASP A 112      18.719 -28.315   6.404  1.00 73.42           C  
ATOM   1698  O   ASP A 112      17.926 -27.429   6.729  1.00 33.01           O  
ATOM   1699  CB  ASP A 112      20.395 -27.887   8.217  1.00 73.41           C  
ATOM   1700  CG  ASP A 112      20.055 -29.060   9.114  1.00 20.44           C  
ATOM   1701  OD1 ASP A 112      18.858 -29.301   9.375  1.00  1.22           O  
ATOM   1702  OD2 ASP A 112      20.991 -29.741   9.583  1.00 43.14           O  
ATOM   1703  H   ASP A 112      20.326 -26.297   5.800  1.00  0.51           H  
ATOM   1704  HA  ASP A 112      20.693 -29.127   6.488  1.00 34.52           H  
ATOM   1705  HB2 ASP A 112      21.426 -27.620   8.391  1.00 37.86           H  
ATOM   1706  HB3 ASP A 112      19.762 -27.056   8.489  1.00 37.86           H  
ATOM   1707  N   VAL A 113      18.356 -29.397   5.738  1.00 31.22           N  
ATOM   1708  CA  VAL A 113      16.977 -29.619   5.331  1.00  1.33           C  
ATOM   1709  C   VAL A 113      16.315 -30.668   6.217  1.00 13.03           C  
ATOM   1710  O   VAL A 113      16.850 -31.760   6.412  1.00 54.22           O  
ATOM   1711  CB  VAL A 113      16.893 -30.071   3.859  1.00 43.30           C  
ATOM   1712  CG1 VAL A 113      15.444 -30.186   3.408  1.00 12.51           C  
ATOM   1713  CG2 VAL A 113      17.666 -29.119   2.958  1.00 21.42           C  
ATOM   1714  H   VAL A 113      19.040 -30.071   5.510  1.00 22.44           H  
ATOM   1715  HA  VAL A 113      16.442 -28.686   5.431  1.00 24.22           H  
ATOM   1716  HB  VAL A 113      17.344 -31.048   3.785  1.00 11.23           H  
ATOM   1717 HG11 VAL A 113      14.930 -30.908   4.027  1.00 37.86           H  
ATOM   1718 HG12 VAL A 113      15.415 -30.511   2.379  1.00 37.86           H  
ATOM   1719 HG13 VAL A 113      14.963 -29.225   3.497  1.00 37.86           H  
ATOM   1720 HG21 VAL A 113      18.697 -29.080   3.275  1.00 37.86           H  
ATOM   1721 HG22 VAL A 113      17.231 -28.132   3.019  1.00 37.86           H  
ATOM   1722 HG23 VAL A 113      17.617 -29.470   1.937  1.00 37.86           H  
ATOM   1723  N   ALA A 114      15.154 -30.328   6.749  1.00  3.41           N  
ATOM   1724  CA  ALA A 114      14.422 -31.224   7.632  1.00 62.40           C  
ATOM   1725  C   ALA A 114      13.083 -31.611   7.018  1.00 71.31           C  
ATOM   1726  O   ALA A 114      12.630 -30.995   6.052  1.00 34.01           O  
ATOM   1727  CB  ALA A 114      14.218 -30.570   8.994  1.00 63.21           C  
ATOM   1728  H   ALA A 114      14.770 -29.454   6.532  1.00 61.23           H  
ATOM   1729  HA  ALA A 114      15.016 -32.116   7.770  1.00  3.50           H  
ATOM   1730  HB1 ALA A 114      13.601 -29.691   8.879  1.00 37.86           H  
ATOM   1731  HB2 ALA A 114      15.175 -30.285   9.406  1.00 37.86           H  
ATOM   1732  HB3 ALA A 114      13.732 -31.267   9.662  1.00 37.86           H  
ATOM   1733  N   VAL A 115      12.456 -32.635   7.575  1.00 24.31           N  
ATOM   1734  CA  VAL A 115      11.166 -33.096   7.081  1.00 14.41           C  
ATOM   1735  C   VAL A 115      10.032 -32.296   7.725  1.00 34.41           C  
ATOM   1736  O   VAL A 115      10.149 -31.845   8.869  1.00  1.45           O  
ATOM   1737  CB  VAL A 115      10.969 -34.612   7.337  1.00 62.34           C  
ATOM   1738  CG1 VAL A 115      10.865 -34.915   8.822  1.00 61.21           C  
ATOM   1739  CG2 VAL A 115       9.752 -35.137   6.591  1.00  3.42           C  
ATOM   1740  H   VAL A 115      12.868 -33.092   8.347  1.00 60.00           H  
ATOM   1741  HA  VAL A 115      11.144 -32.928   6.014  1.00 32.33           H  
ATOM   1742  HB  VAL A 115      11.839 -35.128   6.956  1.00 13.53           H  
ATOM   1743 HG11 VAL A 115       9.996 -34.422   9.230  1.00 37.86           H  
ATOM   1744 HG12 VAL A 115      11.751 -34.559   9.324  1.00 37.86           H  
ATOM   1745 HG13 VAL A 115      10.776 -35.983   8.965  1.00 37.86           H  
ATOM   1746 HG21 VAL A 115       9.608 -36.180   6.831  1.00 37.86           H  
ATOM   1747 HG22 VAL A 115       9.908 -35.030   5.528  1.00 37.86           H  
ATOM   1748 HG23 VAL A 115       8.878 -34.575   6.885  1.00 37.86           H  
ATOM   1749  N   ASP A 116       8.947 -32.100   6.981  1.00 51.32           N  
ATOM   1750  CA  ASP A 116       7.809 -31.330   7.475  1.00 42.21           C  
ATOM   1751  C   ASP A 116       7.125 -32.058   8.629  1.00  2.35           C  
ATOM   1752  O   ASP A 116       7.083 -33.290   8.662  1.00 74.12           O  
ATOM   1753  CB  ASP A 116       6.806 -31.061   6.350  1.00 45.43           C  
ATOM   1754  CG  ASP A 116       5.657 -30.181   6.803  1.00 44.24           C  
ATOM   1755  OD1 ASP A 116       5.879 -29.305   7.665  1.00 20.43           O  
ATOM   1756  OD2 ASP A 116       4.526 -30.362   6.305  1.00 50.31           O  
ATOM   1757  H   ASP A 116       8.907 -32.486   6.084  1.00 71.15           H  
ATOM   1758  HA  ASP A 116       8.187 -30.384   7.837  1.00 42.21           H  
ATOM   1759  HB2 ASP A 116       7.313 -30.568   5.534  1.00 37.86           H  
ATOM   1760  HB3 ASP A 116       6.402 -32.001   6.005  1.00 37.86           H  
ATOM   1761  N   ASN A 117       6.583 -31.288   9.560  1.00 75.15           N  
ATOM   1762  CA  ASN A 117       6.026 -31.836  10.789  1.00 25.41           C  
ATOM   1763  C   ASN A 117       4.585 -32.282  10.583  1.00  1.54           C  
ATOM   1764  O   ASN A 117       3.854 -31.714   9.771  1.00 10.12           O  
ATOM   1765  CB  ASN A 117       6.090 -30.797  11.918  1.00 44.44           C  
ATOM   1766  CG  ASN A 117       5.204 -29.589  11.663  1.00 74.13           C  
ATOM   1767  OD1 ASN A 117       4.026 -29.578  12.023  1.00 32.41           O  
ATOM   1768  ND2 ASN A 117       5.769 -28.554  11.058  1.00 12.32           N  
ATOM   1769  H   ASN A 117       6.524 -30.320   9.397  1.00  0.22           H  
ATOM   1770  HA  ASN A 117       6.619 -32.693  11.069  1.00 75.52           H  
ATOM   1771  HB2 ASN A 117       5.776 -31.257  12.842  1.00 37.86           H  
ATOM   1772  HB3 ASN A 117       7.110 -30.454  12.020  1.00 37.86           H  
ATOM   1773 HD21 ASN A 117       6.716 -28.621  10.812  1.00 37.86           H  
ATOM   1774 HD22 ASN A 117       5.217 -27.765  10.875  1.00 37.86           H  
ATOM   1775  N   SER A 118       4.183 -33.307  11.315  1.00 22.45           N  
ATOM   1776  CA  SER A 118       2.804 -33.755  11.291  1.00  0.41           C  
ATOM   1777  C   SER A 118       2.126 -33.357  12.594  1.00 43.42           C  
ATOM   1778  O   SER A 118       1.934 -34.177  13.497  1.00 20.54           O  
ATOM   1779  CB  SER A 118       2.724 -35.270  11.075  1.00  5.41           C  
ATOM   1780  OG  SER A 118       1.390 -35.688  10.831  1.00 34.23           O  
ATOM   1781  H   SER A 118       4.829 -33.770  11.895  1.00 35.43           H  
ATOM   1782  HA  SER A 118       2.308 -33.252  10.473  1.00 63.33           H  
ATOM   1783  HB2 SER A 118       3.334 -35.543  10.226  1.00 37.86           H  
ATOM   1784  HB3 SER A 118       3.090 -35.774  11.957  1.00 37.86           H  
ATOM   1785  HG  SER A 118       1.300 -35.938   9.895  1.00 73.43           H  
ATOM   1786  N   GLN A 119       1.826 -32.076  12.705  1.00 44.31           N  
ATOM   1787  CA  GLN A 119       1.188 -31.530  13.891  1.00 63.30           C  
ATOM   1788  C   GLN A 119      -0.310 -31.397  13.667  1.00 63.52           C  
ATOM   1789  O   GLN A 119      -0.752 -31.090  12.556  1.00  2.31           O  
ATOM   1790  CB  GLN A 119       1.785 -30.161  14.229  1.00 65.54           C  
ATOM   1791  CG  GLN A 119       2.521 -30.105  15.562  1.00  4.01           C  
ATOM   1792  CD  GLN A 119       3.808 -30.913  15.583  1.00  1.42           C  
ATOM   1793  OE1 GLN A 119       3.937 -31.935  14.911  1.00 74.12           O  
ATOM   1794  NE2 GLN A 119       4.773 -30.454  16.362  1.00 12.03           N  
ATOM   1795  H   GLN A 119       2.047 -31.473  11.965  1.00 75.43           H  
ATOM   1796  HA  GLN A 119       1.364 -32.209  14.711  1.00 22.43           H  
ATOM   1797  HB2 GLN A 119       2.481 -29.889  13.451  1.00 37.86           H  
ATOM   1798  HB3 GLN A 119       0.986 -29.434  14.253  1.00 37.86           H  
ATOM   1799  HG2 GLN A 119       2.763 -29.075  15.778  1.00 37.86           H  
ATOM   1800  HG3 GLN A 119       1.865 -30.485  16.333  1.00 37.86           H  
ATOM   1801 HE21 GLN A 119       4.608 -29.630  16.869  1.00 37.86           H  
ATOM   1802 HE22 GLN A 119       5.615 -30.961  16.406  1.00 37.86           H  
ATOM   1803  N   PRO A 120      -1.112 -31.642  14.710  1.00 13.10           N  
ATOM   1804  CA  PRO A 120      -2.562 -31.479  14.635  1.00 41.54           C  
ATOM   1805  C   PRO A 120      -2.939 -30.024  14.382  1.00 61.55           C  
ATOM   1806  O   PRO A 120      -2.574 -29.136  15.158  1.00 42.01           O  
ATOM   1807  CB  PRO A 120      -3.060 -31.931  16.015  1.00 71.54           C  
ATOM   1808  CG  PRO A 120      -1.927 -32.692  16.620  1.00 41.53           C  
ATOM   1809  CD  PRO A 120      -0.674 -32.106  16.038  1.00 53.13           C  
ATOM   1810  HA  PRO A 120      -2.990 -32.103  13.864  1.00 63.12           H  
ATOM   1811  HB2 PRO A 120      -3.312 -31.065  16.608  1.00 37.86           H  
ATOM   1812  HB3 PRO A 120      -3.934 -32.556  15.897  1.00 37.86           H  
ATOM   1813  HG2 PRO A 120      -1.936 -32.571  17.693  1.00 37.86           H  
ATOM   1814  HG3 PRO A 120      -2.005 -33.738  16.359  1.00 37.86           H  
ATOM   1815  HD2 PRO A 120      -0.326 -31.280  16.643  1.00 37.86           H  
ATOM   1816  HD3 PRO A 120       0.093 -32.861  15.950  1.00 37.86           H  
ATOM   1817  N   LEU A 121      -3.661 -29.784  13.292  1.00 52.42           N  
ATOM   1818  CA  LEU A 121      -4.041 -28.433  12.894  1.00 30.12           C  
ATOM   1819  C   LEU A 121      -4.982 -27.800  13.920  1.00 30.30           C  
ATOM   1820  O   LEU A 121      -5.565 -28.504  14.750  1.00 65.55           O  
ATOM   1821  CB  LEU A 121      -4.711 -28.458  11.515  1.00 62.21           C  
ATOM   1822  CG  LEU A 121      -3.823 -28.927  10.361  1.00 12.13           C  
ATOM   1823  CD1 LEU A 121      -4.606 -28.918   9.058  1.00 65.20           C  
ATOM   1824  CD2 LEU A 121      -2.590 -28.045  10.243  1.00 25.13           C  
ATOM   1825  H   LEU A 121      -3.952 -30.540  12.740  1.00 12.14           H  
ATOM   1826  HA  LEU A 121      -3.141 -27.840  12.834  1.00 55.33           H  
ATOM   1827  HB2 LEU A 121      -5.570 -29.111  11.569  1.00 37.86           H  
ATOM   1828  HB3 LEU A 121      -5.054 -27.460  11.290  1.00 37.86           H  
ATOM   1829  HG  LEU A 121      -3.497 -29.941  10.548  1.00 42.15           H  
ATOM   1830 HD11 LEU A 121      -5.451 -29.585   9.142  1.00 37.86           H  
ATOM   1831 HD12 LEU A 121      -3.967 -29.245   8.253  1.00 37.86           H  
ATOM   1832 HD13 LEU A 121      -4.956 -27.916   8.857  1.00 37.86           H  
ATOM   1833 HD21 LEU A 121      -2.032 -28.083  11.167  1.00 37.86           H  
ATOM   1834 HD22 LEU A 121      -2.895 -27.027  10.047  1.00 37.86           H  
ATOM   1835 HD23 LEU A 121      -1.969 -28.397   9.433  1.00 37.86           H  
ATOM   1836  N   PRO A 122      -5.121 -26.460  13.890  1.00 40.34           N  
ATOM   1837  CA  PRO A 122      -6.022 -25.728  14.785  1.00 70.53           C  
ATOM   1838  C   PRO A 122      -7.423 -26.329  14.826  1.00 54.14           C  
ATOM   1839  O   PRO A 122      -8.065 -26.519  13.792  1.00 64.02           O  
ATOM   1840  CB  PRO A 122      -6.059 -24.327  14.177  1.00  4.23           C  
ATOM   1841  CG  PRO A 122      -4.745 -24.181  13.497  1.00 33.32           C  
ATOM   1842  CD  PRO A 122      -4.393 -25.548  12.983  1.00 21.35           C  
ATOM   1843  HA  PRO A 122      -5.624 -25.676  15.786  1.00 74.35           H  
ATOM   1844  HB2 PRO A 122      -6.877 -24.257  13.477  1.00 37.86           H  
ATOM   1845  HB3 PRO A 122      -6.182 -23.593  14.960  1.00 37.86           H  
ATOM   1846  HG2 PRO A 122      -4.833 -23.483  12.676  1.00 37.86           H  
ATOM   1847  HG3 PRO A 122      -4.000 -23.842  14.202  1.00 37.86           H  
ATOM   1848  HD2 PRO A 122      -4.734 -25.668  11.964  1.00 37.86           H  
ATOM   1849  HD3 PRO A 122      -3.328 -25.713  13.045  1.00 37.86           H  
ATOM   1850  N   LEU A 123      -7.875 -26.646  16.026  1.00 64.32           N  
ATOM   1851  CA  LEU A 123      -9.190 -27.232  16.219  1.00 75.35           C  
ATOM   1852  C   LEU A 123     -10.196 -26.150  16.593  1.00  0.43           C  
ATOM   1853  O   LEU A 123      -9.947 -25.342  17.494  1.00 74.33           O  
ATOM   1854  CB  LEU A 123      -9.133 -28.306  17.309  1.00 31.54           C  
ATOM   1855  CG  LEU A 123     -10.443 -29.053  17.571  1.00 71.22           C  
ATOM   1856  CD1 LEU A 123     -10.878 -29.832  16.340  1.00  1.22           C  
ATOM   1857  CD2 LEU A 123     -10.292 -29.980  18.763  1.00 10.53           C  
ATOM   1858  H   LEU A 123      -7.308 -26.479  16.809  1.00 62.10           H  
ATOM   1859  HA  LEU A 123      -9.492 -27.685  15.288  1.00  1.25           H  
ATOM   1860  HB2 LEU A 123      -8.381 -29.030  17.029  1.00 37.86           H  
ATOM   1861  HB3 LEU A 123      -8.826 -27.834  18.230  1.00 37.86           H  
ATOM   1862  HG  LEU A 123     -11.220 -28.337  17.801  1.00 51.50           H  
ATOM   1863 HD11 LEU A 123     -11.792 -30.367  16.553  1.00 37.86           H  
ATOM   1864 HD12 LEU A 123     -10.105 -30.534  16.066  1.00 37.86           H  
ATOM   1865 HD13 LEU A 123     -11.047 -29.146  15.523  1.00 37.86           H  
ATOM   1866 HD21 LEU A 123     -11.220 -30.506  18.931  1.00 37.86           H  
ATOM   1867 HD22 LEU A 123     -10.043 -29.400  19.640  1.00 37.86           H  
ATOM   1868 HD23 LEU A 123      -9.505 -30.693  18.568  1.00 37.86           H  
ATOM   1869  N   GLU A 124     -11.323 -26.130  15.893  1.00 23.43           N  
ATOM   1870  CA  GLU A 124     -12.366 -25.146  16.146  1.00 32.30           C  
ATOM   1871  C   GLU A 124     -13.056 -25.406  17.482  1.00 45.23           C  
ATOM   1872  O   GLU A 124     -13.383 -26.547  17.817  1.00 54.15           O  
ATOM   1873  CB  GLU A 124     -13.410 -25.152  15.022  1.00 63.42           C  
ATOM   1874  CG  GLU A 124     -12.902 -24.639  13.680  1.00 24.44           C  
ATOM   1875  CD  GLU A 124     -11.914 -25.575  13.011  1.00 11.44           C  
ATOM   1876  OE1 GLU A 124     -12.113 -26.807  13.085  1.00  5.23           O  
ATOM   1877  OE2 GLU A 124     -10.958 -25.079  12.376  1.00  1.42           O  
ATOM   1878  H   GLU A 124     -11.455 -26.791  15.180  1.00 63.21           H  
ATOM   1879  HA  GLU A 124     -11.899 -24.174  16.182  1.00 32.03           H  
ATOM   1880  HB2 GLU A 124     -13.758 -26.164  14.880  1.00 37.86           H  
ATOM   1881  HB3 GLU A 124     -14.247 -24.536  15.322  1.00 37.86           H  
ATOM   1882  HG2 GLU A 124     -13.745 -24.505  13.020  1.00 37.86           H  
ATOM   1883  HG3 GLU A 124     -12.419 -23.685  13.837  1.00 37.86           H  
ATOM   1884  N   HIS A 125     -13.260 -24.342  18.245  1.00 65.35           N  
ATOM   1885  CA  HIS A 125     -13.993 -24.430  19.499  1.00 51.31           C  
ATOM   1886  C   HIS A 125     -15.485 -24.319  19.228  1.00 21.32           C  
ATOM   1887  O   HIS A 125     -16.006 -23.218  19.057  1.00 12.10           O  
ATOM   1888  CB  HIS A 125     -13.574 -23.319  20.470  1.00 24.41           C  
ATOM   1889  CG  HIS A 125     -12.197 -23.480  21.032  1.00 42.01           C  
ATOM   1890  ND1 HIS A 125     -11.943 -23.571  22.386  1.00 64.14           N  
ATOM   1891  CD2 HIS A 125     -10.991 -23.541  20.422  1.00 75.30           C  
ATOM   1892  CE1 HIS A 125     -10.643 -23.680  22.580  1.00 13.14           C  
ATOM   1893  NE2 HIS A 125     -10.046 -23.668  21.406  1.00 61.23           N  
ATOM   1894  H   HIS A 125     -12.916 -23.468  17.951  1.00 55.20           H  
ATOM   1895  HA  HIS A 125     -13.782 -25.390  19.944  1.00 51.20           H  
ATOM   1896  HB2 HIS A 125     -13.612 -22.371  19.956  1.00 37.86           H  
ATOM   1897  HB3 HIS A 125     -14.270 -23.296  21.298  1.00 37.86           H  
ATOM   1898  HD1 HIS A 125     -12.621 -23.556  23.104  1.00 60.02           H  
ATOM   1899  HD2 HIS A 125     -10.807 -23.496  19.358  1.00 54.22           H  
ATOM   1900  HE1 HIS A 125     -10.150 -23.762  23.538  1.00 54.35           H  
ATOM   1901  HE2 HIS A 125      -9.078 -23.802  21.257  1.00 37.86           H  
ATOM   1902  N   HIS A 126     -16.162 -25.456  19.157  1.00 12.22           N  
ATOM   1903  CA  HIS A 126     -17.602 -25.455  18.927  1.00 30.41           C  
ATOM   1904  C   HIS A 126     -18.335 -24.926  20.154  1.00  1.34           C  
ATOM   1905  O   HIS A 126     -18.099 -25.379  21.275  1.00 65.23           O  
ATOM   1906  CB  HIS A 126     -18.123 -26.850  18.522  1.00 13.03           C  
ATOM   1907  CG  HIS A 126     -17.686 -27.982  19.404  1.00 23.21           C  
ATOM   1908  ND1 HIS A 126     -18.439 -28.462  20.453  1.00 33.51           N  
ATOM   1909  CD2 HIS A 126     -16.579 -28.759  19.357  1.00 11.55           C  
ATOM   1910  CE1 HIS A 126     -17.812 -29.479  21.014  1.00 12.50           C  
ATOM   1911  NE2 HIS A 126     -16.682 -29.681  20.366  1.00 63.35           N  
ATOM   1912  H   HIS A 126     -15.686 -26.304  19.266  1.00 10.40           H  
ATOM   1913  HA  HIS A 126     -17.788 -24.773  18.108  1.00 41.02           H  
ATOM   1914  HB2 HIS A 126     -19.201 -26.833  18.530  1.00 37.86           H  
ATOM   1915  HB3 HIS A 126     -17.786 -27.066  17.519  1.00 37.86           H  
ATOM   1916  HD1 HIS A 126     -19.314 -28.103  20.751  1.00 61.43           H  
ATOM   1917  HD2 HIS A 126     -15.764 -28.669  18.652  1.00 11.35           H  
ATOM   1918  HE1 HIS A 126     -18.166 -30.053  21.857  1.00 24.12           H  
ATOM   1919  HE2 HIS A 126     -15.948 -30.257  20.683  1.00 37.86           H  
ATOM   1920  N   HIS A 127     -19.201 -23.943  19.923  1.00 53.21           N  
ATOM   1921  CA  HIS A 127     -19.896 -23.236  21.001  1.00 55.32           C  
ATOM   1922  C   HIS A 127     -20.671 -24.195  21.905  1.00  3.14           C  
ATOM   1923  O   HIS A 127     -21.433 -25.037  21.435  1.00 30.31           O  
ATOM   1924  CB  HIS A 127     -20.840 -22.157  20.434  1.00 13.31           C  
ATOM   1925  CG  HIS A 127     -21.966 -22.682  19.587  1.00 24.22           C  
ATOM   1926  ND1 HIS A 127     -23.288 -22.349  19.797  1.00  1.13           N  
ATOM   1927  CD2 HIS A 127     -21.958 -23.513  18.517  1.00 35.04           C  
ATOM   1928  CE1 HIS A 127     -24.040 -22.954  18.896  1.00 23.01           C  
ATOM   1929  NE2 HIS A 127     -23.257 -23.666  18.106  1.00 12.34           N  
ATOM   1930  H   HIS A 127     -19.372 -23.678  18.996  1.00 70.12           H  
ATOM   1931  HA  HIS A 127     -19.142 -22.748  21.597  1.00 70.45           H  
ATOM   1932  HB2 HIS A 127     -21.280 -21.613  21.255  1.00 37.86           H  
ATOM   1933  HB3 HIS A 127     -20.262 -21.472  19.829  1.00 37.86           H  
ATOM   1934  HD1 HIS A 127     -23.628 -21.731  20.490  1.00 53.50           H  
ATOM   1935  HD2 HIS A 127     -21.086 -23.969  18.069  1.00 32.30           H  
ATOM   1936  HE1 HIS A 127     -25.116 -22.880  18.818  1.00 54.43           H  
ATOM   1937  HE2 HIS A 127     -23.533 -24.058  17.241  1.00 37.86           H  
ATOM   1938  N   HIS A 128     -20.461 -24.051  23.202  1.00 55.15           N  
ATOM   1939  CA  HIS A 128     -21.150 -24.868  24.192  1.00 54.22           C  
ATOM   1940  C   HIS A 128     -22.326 -24.089  24.756  1.00 51.50           C  
ATOM   1941  O   HIS A 128     -22.133 -23.013  25.329  1.00 21.01           O  
ATOM   1942  CB  HIS A 128     -20.203 -25.250  25.336  1.00 13.42           C  
ATOM   1943  CG  HIS A 128     -18.944 -25.923  24.890  1.00 43.11           C  
ATOM   1944  ND1 HIS A 128     -17.785 -25.232  24.616  1.00 72.24           N  
ATOM   1945  CD2 HIS A 128     -18.658 -27.229  24.688  1.00 53.05           C  
ATOM   1946  CE1 HIS A 128     -16.842 -26.081  24.263  1.00 31.12           C  
ATOM   1947  NE2 HIS A 128     -17.345 -27.300  24.296  1.00 54.12           N  
ATOM   1948  H   HIS A 128     -19.837 -23.360  23.509  1.00  3.15           H  
ATOM   1949  HA  HIS A 128     -21.510 -25.764  23.705  1.00 10.21           H  
ATOM   1950  HB2 HIS A 128     -19.925 -24.356  25.874  1.00 37.86           H  
ATOM   1951  HB3 HIS A 128     -20.718 -25.921  26.009  1.00 37.86           H  
ATOM   1952  HD1 HIS A 128     -17.674 -24.252  24.664  1.00  3.01           H  
ATOM   1953  HD2 HIS A 128     -19.338 -28.061  24.809  1.00 63.21           H  
ATOM   1954  HE1 HIS A 128     -15.830 -25.821  23.990  1.00 22.05           H  
ATOM   1955  HE2 HIS A 128     -16.835 -28.131  24.142  1.00 37.86           H  
ATOM   1956  N   HIS A 129     -23.532 -24.633  24.582  1.00 33.14           N  
ATOM   1957  CA  HIS A 129     -24.770 -23.991  25.041  1.00 11.44           C  
ATOM   1958  C   HIS A 129     -25.094 -22.748  24.206  1.00 61.13           C  
ATOM   1959  O   HIS A 129     -24.199 -22.080  23.686  1.00 32.40           O  
ATOM   1960  CB  HIS A 129     -24.680 -23.629  26.536  1.00  1.14           C  
ATOM   1961  CG  HIS A 129     -25.927 -23.019  27.098  1.00  5.43           C  
ATOM   1962  ND1 HIS A 129     -26.096 -21.660  27.256  1.00 24.25           N  
ATOM   1963  CD2 HIS A 129     -27.067 -23.591  27.544  1.00 42.23           C  
ATOM   1964  CE1 HIS A 129     -27.287 -21.426  27.771  1.00  1.30           C  
ATOM   1965  NE2 HIS A 129     -27.894 -22.579  27.953  1.00 72.12           N  
ATOM   1966  H   HIS A 129     -23.592 -25.506  24.132  1.00 11.30           H  
ATOM   1967  HA  HIS A 129     -25.571 -24.705  24.909  1.00 61.03           H  
ATOM   1968  HB2 HIS A 129     -24.469 -24.521  27.102  1.00 37.86           H  
ATOM   1969  HB3 HIS A 129     -23.874 -22.923  26.678  1.00 37.86           H  
ATOM   1970  HD1 HIS A 129     -25.439 -20.965  27.020  1.00 41.50           H  
ATOM   1971  HD2 HIS A 129     -27.285 -24.650  27.569  1.00 33.45           H  
ATOM   1972  HE1 HIS A 129     -27.695 -20.452  28.000  1.00 62.45           H  
ATOM   1973  HE2 HIS A 129     -28.793 -22.696  28.348  1.00 37.86           H  
ATOM   1974  N   HIS A 130     -26.380 -22.470  24.050  1.00 32.25           N  
ATOM   1975  CA  HIS A 130     -26.820 -21.250  23.389  1.00 11.53           C  
ATOM   1976  C   HIS A 130     -27.036 -20.158  24.427  1.00 11.12           C  
ATOM   1977  O   HIS A 130     -28.197 -19.945  24.830  1.00 37.86           O  
ATOM   1978  CB  HIS A 130     -28.116 -21.481  22.605  1.00 13.30           C  
ATOM   1979  CG  HIS A 130     -27.976 -22.411  21.440  1.00 71.32           C  
ATOM   1980  ND1 HIS A 130     -27.907 -21.975  20.137  1.00  1.35           N  
ATOM   1981  CD2 HIS A 130     -27.917 -23.762  21.384  1.00 60.14           C  
ATOM   1982  CE1 HIS A 130     -27.819 -23.011  19.330  1.00 60.13           C  
ATOM   1983  NE2 HIS A 130     -27.823 -24.110  20.061  1.00 63.42           N  
ATOM   1984  OXT HIS A 130     -26.039 -19.547  24.862  1.00 37.86           O  
ATOM   1985  H   HIS A 130     -27.052 -23.105  24.383  1.00 31.15           H  
ATOM   1986  HA  HIS A 130     -26.042 -20.940  22.706  1.00 10.25           H  
ATOM   1987  HB2 HIS A 130     -28.860 -21.895  23.270  1.00 37.86           H  
ATOM   1988  HB3 HIS A 130     -28.471 -20.533  22.229  1.00 37.86           H  
ATOM   1989  HD1 HIS A 130     -27.923 -21.034  19.845  1.00 12.53           H  
ATOM   1990  HD2 HIS A 130     -27.931 -24.439  22.226  1.00 71.44           H  
ATOM   1991  HE1 HIS A 130     -27.749 -22.970  18.254  1.00 21.02           H  
ATOM   1992  HE2 HIS A 130     -27.927 -25.027  19.708  1.00 37.86           H  
TER    1993      HIS A 130                                                      
END
MOLECULE T0391.pdb
ATOM      1  N   LYS    14      20.058 -27.031  -4.627  1.00 60.80           N  
ATOM      2  CA  LYS    14      18.878 -26.160  -4.323  1.00 60.75           C  
ATOM      3  C   LYS    14      19.298 -24.755  -3.828  1.00 60.82           C  
ATOM      4  O   LYS    14      18.794 -24.243  -2.809  1.00 60.89           O  
ATOM      5  CB  LYS    14      17.912 -26.875  -3.349  1.00 60.75           C  
ATOM      6  CG  LYS    14      18.148 -26.678  -1.832  1.00 60.46           C  
ATOM      7  CD  LYS    14      19.239 -27.549  -1.251  1.00 60.49           C  
ATOM      8  CE  LYS    14      19.374 -27.296   0.246  1.00 60.57           C  
ATOM      9  NZ  LYS    14      20.401 -28.172   0.889  1.00 60.29           N  
ATOM     10  N   TYR    15      20.208 -24.127  -4.570  1.00 60.44           N  
ATOM     11  CA  TYR    15      20.748 -22.827  -4.172  1.00 60.31           C  
ATOM     12  C   TYR    15      20.596 -21.697  -5.214  1.00 60.11           C  
ATOM     13  O   TYR    15      21.466 -20.821  -5.310  1.00 60.31           O  
ATOM     14  CB  TYR    15      22.220 -22.960  -3.731  1.00 60.66           C  
ATOM     15  CG  TYR    15      22.442 -23.716  -2.429  1.00 60.97           C  
ATOM     16  CD1 TYR    15      22.806 -25.063  -2.440  1.00 60.98           C  
ATOM     17  CD2 TYR    15      22.302 -23.081  -1.190  1.00 60.95           C  
ATOM     18  CE1 TYR    15      23.019 -25.762  -1.253  1.00 61.49           C  
ATOM     19  CE2 TYR    15      22.510 -23.773   0.005  1.00 60.54           C  
ATOM     20  CZ  TYR    15      22.870 -25.113  -0.036  1.00 61.22           C  
ATOM     21  OH  TYR    15      23.090 -25.813   1.132  1.00 61.20           O  
ATOM     22  N   THR    16      19.512 -21.700  -5.992  1.00 59.68           N  
ATOM     23  CA  THR    16      19.188 -20.514  -6.815  1.00 59.63           C  
ATOM     24  C   THR    16      17.836 -19.878  -6.426  1.00 58.97           C  
ATOM     25  O   THR    16      17.024 -20.493  -5.734  1.00 58.66           O  
ATOM     26  CB  THR    16      19.340 -20.760  -8.367  1.00 59.50           C  
ATOM     27  OG1 THR    16      20.712 -21.057  -8.684  1.00 60.71           O  
ATOM     28  CG2 THR    16      18.927 -19.524  -9.191  1.00 59.37           C  
ATOM     29  N   SER    17      17.657 -18.629  -6.856  1.00 59.10           N  
ATOM     30  CA  SER    17      16.500 -17.778  -6.591  1.00 59.12           C  
ATOM     31  C   SER    17      15.164 -18.496  -6.522  1.00 59.74           C  
ATOM     32  O   SER    17      14.808 -19.277  -7.416  1.00 58.25           O  
ATOM     33  CB  SER    17      16.366 -16.691  -7.673  1.00 59.23           C  
ATOM     34  OG  SER    17      17.578 -15.976  -7.871  1.00 60.17           O  
ATOM     35  N   VAL    18      14.428 -18.199  -5.452  1.00 59.57           N  
ATOM     36  CA  VAL    18      13.002 -18.454  -5.422  1.00 59.94           C  
ATOM     37  C   VAL    18      12.366 -17.085  -5.284  1.00 60.39           C  
ATOM     38  O   VAL    18      12.744 -16.309  -4.419  1.00 59.98           O  
ATOM     39  CB  VAL    18      12.613 -19.377  -4.253  1.00 59.90           C  
ATOM     40  CG1 VAL    18      11.086 -19.572  -4.178  1.00 59.62           C  
ATOM     41  CG2 VAL    18      13.318 -20.729  -4.393  1.00 59.73           C  
ATOM     42  N   CYS    19      11.436 -16.772  -6.177  1.00 62.03           N  
ATOM     43  CA  CYS    19      10.675 -15.546  -6.087  1.00 62.30           C  
ATOM     44  C   CYS    19       9.657 -15.686  -4.943  1.00 62.67           C  
ATOM     45  O   CYS    19       8.778 -16.538  -4.994  1.00 63.44           O  
ATOM     46  CB  CYS    19       9.969 -15.293  -7.396  1.00 62.62           C  
ATOM     47  SG  CYS    19       9.161 -13.703  -7.475  1.00 64.96           S  
ATOM     48  N   VAL    20       9.769 -14.851  -3.922  1.00 61.58           N  
ATOM     49  CA  VAL    20       8.958 -15.045  -2.708  1.00 61.49           C  
ATOM     50  C   VAL    20       7.766 -14.103  -2.702  1.00 62.35           C  
ATOM     51  O   VAL    20       6.872 -14.191  -1.856  1.00 63.15           O  
ATOM     52  CB  VAL    20       9.817 -14.911  -1.438  1.00 61.03           C  
ATOM     53  CG1 VAL    20      10.940 -15.911  -1.487  1.00 60.15           C  
ATOM     54  CG2 VAL    20      10.377 -13.514  -1.277  1.00 59.18           C  
ATOM     55  N   GLY    21       7.748 -13.211  -3.677  1.00 62.13           N  
ATOM     56  CA  GLY    21       6.681 -12.283  -3.790  1.00 62.19           C  
ATOM     57  C   GLY    21       7.038 -10.922  -4.329  1.00 62.64           C  
ATOM     58  O   GLY    21       8.104 -10.689  -4.947  1.00 62.35           O  
ATOM     59  N   ARG    22       6.090 -10.026  -4.089  1.00 62.17           N  
ATOM     60  CA  ARG    22       6.044  -8.731  -4.705  1.00 62.01           C  
ATOM     61  C   ARG    22       6.671  -7.685  -3.777  1.00 61.91           C  
ATOM     62  O   ARG    22       6.357  -7.629  -2.585  1.00 60.50           O  
ATOM     63  CB  ARG    22       4.576  -8.423  -4.962  1.00 62.52           C  
ATOM     64  CG  ARG    22       4.336  -7.596  -6.112  1.00 62.38           C  
ATOM     65  CD  ARG    22       2.862  -7.377  -6.307  1.00 63.37           C  
ATOM     66  NE  ARG    22       2.766  -6.247  -7.197  1.00 63.29           N  
ATOM     67  CZ  ARG    22       1.689  -5.863  -7.852  1.00 63.14           C  
ATOM     68  NH1 ARG    22       0.531  -6.515  -7.735  1.00 64.35           N  
ATOM     69  NH2 ARG    22       1.798  -4.807  -8.631  1.00 63.71           N  
ATOM     70  N   GLU    23       7.582  -6.874  -4.323  1.00 62.10           N  
ATOM     71  CA  GLU    23       8.103  -5.723  -3.602  1.00 62.33           C  
ATOM     72  C   GLU    23       6.970  -4.911  -2.955  1.00 62.52           C  
ATOM     73  O   GLU    23       7.045  -4.564  -1.781  1.00 63.44           O  
ATOM     74  CB  GLU    23       8.955  -4.850  -4.518  1.00 62.11           C  
ATOM     75  CG  GLU    23       9.910  -3.962  -3.752  1.00 63.73           C  
ATOM     76  CD  GLU    23      11.098  -3.492  -4.568  1.00 66.02           C  
ATOM     77  OE1 GLU    23      10.913  -3.119  -5.754  1.00 65.65           O  
ATOM     78  OE2 GLU    23      12.214  -3.482  -4.000  1.00 68.05           O  
ATOM     79  N   GLU    24       5.899  -4.665  -3.694  1.00 62.66           N  
ATOM     80  CA  GLU    24       4.773  -3.927  -3.141  1.00 63.27           C  
ATOM     81  C   GLU    24       4.077  -4.577  -1.938  1.00 63.16           C  
ATOM     82  O   GLU    24       3.586  -3.872  -1.053  1.00 63.14           O  
ATOM     83  CB  GLU    24       3.737  -3.650  -4.220  1.00 63.14           C  
ATOM     84  CG  GLU    24       4.183  -2.647  -5.259  1.00 65.00           C  
ATOM     85  CD  GLU    24       3.009  -2.112  -6.065  1.00 65.66           C  
ATOM     86  OE1 GLU    24       1.919  -2.735  -5.998  1.00 65.11           O  
ATOM     87  OE2 GLU    24       3.167  -1.071  -6.749  1.00 66.96           O  
ATOM     88  N   ASP    25       4.034  -5.902  -1.911  0.70 63.36           N  
ATOM     90  CA  ASP    25       3.305  -6.600  -0.868  0.70 63.79           C  
ATOM     92  C   ASP    25       4.028  -6.560   0.493  0.70 64.46           C  
ATOM     94  O   ASP    25       3.372  -6.638   1.542  0.70 64.77           O  
ATOM     96  CB  ASP    25       2.955  -8.031  -1.327  0.70 63.62           C  
ATOM     98  CG  ASP    25       1.892  -8.063  -2.468  0.70 63.86           C  
ATOM    100  OD1 ASP    25       1.400  -6.997  -2.932  0.70 61.48           O  
ATOM    102  OD2 ASP    25       1.538  -9.184  -2.900  0.70 64.42           O  
ATOM    104  N   ILE    26       5.358  -6.389   0.475  1.00 64.67           N  
ATOM    105  CA  ILE    26       6.187  -6.428   1.701  1.00 65.33           C  
ATOM    106  C   ILE    26       6.448  -5.038   2.254  1.00 66.28           C  
ATOM    107  O   ILE    26       6.715  -4.879   3.435  1.00 65.81           O  
ATOM    108  CB  ILE    26       7.568  -7.115   1.511  1.00 65.79           C  
ATOM    109  CG1 ILE    26       8.114  -7.590   2.873  1.00 65.49           C  
ATOM    110  CG2 ILE    26       8.578  -6.164   0.865  1.00 65.24           C  
ATOM    111  CD1 ILE    26       9.526  -8.114   2.841  1.00 64.46           C  
ATOM    112  N   ARG    27       6.376  -4.026   1.393  1.00 67.72           N  
ATOM    113  CA  ARG    27       6.661  -2.672   1.844  1.00 68.35           C  
ATOM    114  C   ARG    27       5.635  -2.232   2.887  1.00 68.20           C  
ATOM    115  O   ARG    27       6.004  -1.667   3.921  1.00 68.03           O  
ATOM    116  CB  ARG    27       6.823  -1.716   0.661  1.00 68.79           C  
ATOM    117  CG  ARG    27       8.136  -2.014  -0.065  1.00 70.71           C  
ATOM    118  CD  ARG    27       8.676  -0.888  -0.957  1.00 74.28           C  
ATOM    119  NE  ARG    27      10.113  -1.118  -1.136  1.00 76.73           N  
ATOM    120  CZ  ARG    27      10.900  -0.543  -2.046  1.00 77.51           C  
ATOM    121  NH1 ARG    27      10.418   0.335  -2.925  1.00 77.15           N  
ATOM    122  NH2 ARG    27      12.190  -0.862  -2.073  1.00 77.51           N  
ATOM    123  N   LYS    28       4.372  -2.577   2.641  1.00 68.05           N  
ATOM    124  CA  LYS    28       3.278  -2.331   3.573  1.00 67.84           C  
ATOM    125  C   LYS    28       3.515  -2.907   4.993  1.00 67.37           C  
ATOM    126  O   LYS    28       3.664  -2.148   5.957  1.00 67.14           O  
ATOM    127  CB  LYS    28       1.968  -2.845   2.957  1.00 68.52           C  
ATOM    128  CG  LYS    28       0.709  -2.558   3.781  1.00 69.95           C  
ATOM    129  CD  LYS    28      -0.479  -2.274   2.855  1.00 72.90           C  
ATOM    130  CE  LYS    28      -1.783  -2.048   3.625  1.00 74.32           C  
ATOM    131  NZ  LYS    28      -2.286  -3.344   4.158  1.00 76.24           N  
ATOM    132  N   SER    29       3.569  -4.235   5.119  1.00 66.72           N  
ATOM    133  CA  SER    29       3.748  -4.885   6.425  1.00 66.15           C  
ATOM    134  C   SER    29       5.187  -4.873   6.935  1.00 64.97           C  
ATOM    135  O   SER    29       5.459  -5.154   8.118  1.00 65.03           O  
ATOM    136  CB  SER    29       3.311  -6.336   6.336  1.00 66.89           C  
ATOM    137  OG  SER    29       4.355  -7.108   5.765  1.00 69.45           O  
ATOM    138  N   GLU    30       6.122  -4.606   6.034  1.00 62.79           N  
ATOM    139  CA  GLU    30       7.546  -4.652   6.367  1.00 60.91           C  
ATOM    140  C   GLU    30       8.128  -6.009   6.779  1.00 58.63           C  
ATOM    141  O   GLU    30       9.300  -6.064   7.176  1.00 57.90           O  
ATOM    142  CB  GLU    30       7.939  -3.541   7.349  1.00 61.73           C  
ATOM    143  CG  GLU    30       8.166  -2.226   6.596  1.00 64.11           C  
ATOM    144  CD  GLU    30       8.775  -1.124   7.442  1.00 68.01           C  
ATOM    145  OE1 GLU    30       8.252  -0.881   8.554  1.00 68.86           O  
ATOM    146  OE2 GLU    30       9.756  -0.484   6.970  1.00 69.07           O  
ATOM    147  N   ARG    31       7.333  -7.073   6.654  1.00 55.43           N  
ATOM    148  CA  ARG    31       7.814  -8.461   6.773  1.00 54.94           C  
ATOM    149  C   ARG    31       6.873  -9.468   6.122  1.00 55.34           C  
ATOM    150  O   ARG    31       5.669  -9.251   6.054  1.00 53.56           O  
ATOM    151  CB  ARG    31       8.017  -8.868   8.213  1.00 53.83           C  
ATOM    152  CG  ARG    31       6.689  -9.135   8.913  1.00 56.18           C  
ATOM    153  CD  ARG    31       6.870  -9.241  10.351  1.00 54.41           C  
ATOM    154  NE  ARG    31       7.484  -8.051  10.931  1.00 47.57           N  
ATOM    155  CZ  ARG    31       7.953  -8.038  12.168  1.00 43.51           C  
ATOM    156  NH1 ARG    31       7.864  -9.153  12.893  1.00 42.00           N  
ATOM    157  NH2 ARG    31       8.477  -6.939  12.679  1.00 40.05           N  
ATOM    158  N   MET    32       7.432 -10.587   5.679  1.00 57.33           N  
ATOM    159  CA  MET    32       6.647 -11.708   5.128  1.00 60.41           C  
ATOM    160  C   MET    32       7.435 -12.995   5.296  1.00 59.05           C  
ATOM    161  O   MET    32       8.664 -12.974   5.342  1.00 60.30           O  
ATOM    162  CB  MET    32       6.358 -11.492   3.619  1.00 59.37           C  
ATOM    163  CG  MET    32       7.571 -11.596   2.693  1.00 63.82           C  
ATOM    164  SD  MET    32       7.112 -11.204   0.978  1.00 69.27           S  
ATOM    165  CE  MET    32       5.647 -10.216   1.194  1.00 68.77           C  
ATOM    166  N   THR    33       6.752 -14.125   5.326  1.00 57.39           N  
ATOM    167  CA  THR    33       7.468 -15.385   5.383  1.00 55.82           C  
ATOM    168  C   THR    33       7.420 -16.058   3.993  1.00 56.31           C  
ATOM    169  O   THR    33       6.532 -15.751   3.131  1.00 54.99           O  
ATOM    170  CB  THR    33       6.882 -16.321   6.457  1.00 56.65           C  
ATOM    171  OG1 THR    33       5.603 -16.815   5.987  1.00 56.10           O  
ATOM    172  CG2 THR    33       6.697 -15.553   7.836  1.00 55.74           C  
ATOM    173  N   ALA    34       8.335 -16.989   3.761  1.00 54.34           N  
ATOM    174  CA  ALA    34       8.184 -17.826   2.570  1.00 54.83           C  
ATOM    175  C   ALA    34       8.807 -19.181   2.790  1.00 53.98           C  
ATOM    176  O   ALA    34       9.635 -19.352   3.681  1.00 53.23           O  
ATOM    177  CB  ALA    34       8.816 -17.148   1.365  1.00 55.64           C  
ATOM    178  N   VAL    35       8.422 -20.150   1.969  1.00 52.71           N  
ATOM    179  CA  VAL    35       9.146 -21.419   1.963  1.00 51.53           C  
ATOM    180  C   VAL    35      10.059 -21.440   0.736  1.00 50.48           C  
ATOM    181  O   VAL    35       9.597 -21.267  -0.405  1.00 50.86           O  
ATOM    182  CB  VAL    35       8.199 -22.656   2.139  1.00 51.55           C  
ATOM    183  CG1 VAL    35       8.927 -23.938   1.867  1.00 51.62           C  
ATOM    184  CG2 VAL    35       7.649 -22.678   3.595  1.00 51.89           C  
ATOM    185  N   VAL    36      11.358 -21.607   0.993  1.00 47.93           N  
ATOM    186  CA  VAL    36      12.369 -21.552  -0.052  1.00 46.54           C  
ATOM    187  C   VAL    36      13.108 -22.885  -0.044  1.00 46.09           C  
ATOM    188  O   VAL    36      13.795 -23.191   0.917  1.00 45.92           O  
ATOM    189  CB  VAL    36      13.329 -20.352   0.148  1.00 46.45           C  
ATOM    190  CG1 VAL    36      14.517 -20.414  -0.842  1.00 45.45           C  
ATOM    191  CG2 VAL    36      12.561 -19.045  -0.018  1.00 43.17           C  
ATOM    192  N   HIS    37      12.900 -23.698  -1.086  1.00 45.65           N  
ATOM    193  CA  HIS    37      13.449 -25.056  -1.162  1.00 45.17           C  
ATOM    194  C   HIS    37      13.275 -25.825   0.164  1.00 45.04           C  
ATOM    195  O   HIS    37      14.256 -26.313   0.741  1.00 45.28           O  
ATOM    196  CB  HIS    37      14.941 -25.015  -1.540  1.00 45.31           C  
ATOM    197  CG  HIS    37      15.243 -24.292  -2.824  1.00 45.88           C  
ATOM    198  ND1 HIS    37      14.568 -24.534  -4.004  1.00 46.39           N  
ATOM    199  CD2 HIS    37      16.190 -23.367  -3.117  1.00 46.19           C  
ATOM    200  CE1 HIS    37      15.074 -23.775  -4.962  1.00 46.61           C  
ATOM    201  NE2 HIS    37      16.058 -23.055  -4.449  1.00 45.87           N  
ATOM    202  N   ASP    38      12.041 -25.892   0.661  1.00 44.85           N  
ATOM    203  CA  ASP    38      11.706 -26.553   1.941  1.00 45.31           C  
ATOM    204  C   ASP    38      12.339 -25.925   3.206  1.00 45.08           C  
ATOM    205  O   ASP    38      12.315 -26.535   4.284  1.00 45.02           O  
ATOM    206  CB  ASP    38      12.026 -28.055   1.910  1.00 45.77           C  
ATOM    207  CG  ASP    38      11.383 -28.776   0.726  1.00 49.13           C  
ATOM    208  OD1 ASP    38      10.128 -28.791   0.650  1.00 51.40           O  
ATOM    209  OD2 ASP    38      12.135 -29.334  -0.124  1.00 51.32           O  
ATOM    210  N   ARG    39      12.917 -24.729   3.081  1.00 43.95           N  
ATOM    211  CA  ARG    39      13.413 -24.021   4.257  1.00 43.30           C  
ATOM    212  C   ARG    39      12.521 -22.812   4.452  1.00 42.56           C  
ATOM    213  O   ARG    39      12.335 -22.011   3.534  1.00 42.90           O  
ATOM    214  CB  ARG    39      14.865 -23.605   4.108  1.00 43.37           C  
ATOM    215  CG  ARG    39      15.608 -23.594   5.429  1.00 43.77           C  
ATOM    216  CD  ARG    39      17.029 -23.142   5.261  1.00 45.03           C  
ATOM    217  NE  ARG    39      17.674 -23.029   6.560  1.00 45.90           N  
ATOM    218  CZ  ARG    39      18.700 -23.769   6.945  1.00 43.80           C  
ATOM    219  NH1 ARG    39      19.211 -24.648   6.103  1.00 43.43           N  
ATOM    220  NH2 ARG    39      19.216 -23.604   8.157  1.00 40.35           N  
ATOM    221  N   GLU    40      11.915 -22.727   5.625  1.00 41.87           N  
ATOM    222  CA  GLU    40      11.019 -21.619   5.932  1.00 40.70           C  
ATOM    223  C   GLU    40      11.814 -20.418   6.451  1.00 40.21           C  
ATOM    224  O   GLU    40      12.671 -20.553   7.321  1.00 39.91           O  
ATOM    225  CB  GLU    40       9.926 -22.041   6.911  1.00 41.02           C  
ATOM    226  CG  GLU    40       8.775 -21.074   6.870  1.00 41.02           C  
ATOM    227  CD  GLU    40       7.670 -21.402   7.819  1.00 45.48           C  
ATOM    228  OE1 GLU    40       7.862 -22.213   8.771  1.00 46.20           O  
ATOM    229  OE2 GLU    40       6.581 -20.845   7.575  1.00 44.48           O  
ATOM    230  N   VAL    41      11.578 -19.259   5.838  1.00 39.09           N  
ATOM    231  CA  VAL    41      12.354 -18.057   6.115  1.00 37.88           C  
ATOM    232  C   VAL    41      11.436 -16.887   6.414  1.00 37.27           C  
ATOM    233  O   VAL    41      10.267 -16.869   6.008  1.00 36.57           O  
ATOM    234  CB  VAL    41      13.326 -17.655   4.896  1.00 37.87           C  
ATOM    235  CG1 VAL    41      14.182 -18.804   4.466  1.00 36.47           C  
ATOM    236  CG2 VAL    41      12.531 -17.210   3.656  1.00 38.60           C  
ATOM    237  N   VAL    42      11.998 -15.867   7.049  1.00 36.63           N  
ATOM    238  CA  VAL    42      11.308 -14.631   7.203  1.00 35.76           C  
ATOM    239  C   VAL    42      12.103 -13.576   6.456  1.00 36.42           C  
ATOM    240  O   VAL    42      13.302 -13.561   6.538  1.00 34.56           O  
ATOM    241  CB  VAL    42      11.050 -14.279   8.729  1.00 36.00           C  
ATOM    242  CG1 VAL    42      12.356 -14.284   9.550  1.00 31.47           C  
ATOM    243  CG2 VAL    42      10.244 -12.935   8.858  1.00 36.12           C  
ATOM    244  N   ILE    43      11.423 -12.711   5.705  1.00 36.07           N  
ATOM    245  CA  ILE    43      12.088 -11.573   5.057  1.00 35.72           C  
ATOM    246  C   ILE    43      11.611 -10.312   5.753  1.00 35.08           C  
ATOM    247  O   ILE    43      10.425 -10.130   5.901  1.00 34.92           O  
ATOM    248  CB  ILE    43      11.748 -11.420   3.540  1.00 36.04           C  
ATOM    249  CG1 ILE    43      12.131 -12.678   2.760  1.00 38.38           C  
ATOM    250  CG2 ILE    43      12.503 -10.221   2.900  1.00 35.84           C  
ATOM    251  CD1 ILE    43      10.953 -13.665   2.645  1.00 41.98           C  
ATOM    252  N   PHE    44      12.540  -9.455   6.170  1.00 35.27           N  
ATOM    253  CA  PHE    44      12.207  -8.159   6.750  1.00 35.90           C  
ATOM    254  C   PHE    44      12.611  -7.070   5.764  1.00 36.03           C  
ATOM    255  O   PHE    44      13.695  -7.104   5.206  1.00 36.06           O  
ATOM    256  CB  PHE    44      12.996  -7.939   8.051  1.00 35.55           C  
ATOM    257  CG  PHE    44      12.675  -8.944   9.149  1.00 35.15           C  
ATOM    258  CD1 PHE    44      11.461  -8.863   9.856  1.00 33.52           C  
ATOM    259  CD2 PHE    44      13.555  -9.953   9.456  1.00 35.10           C  
ATOM    260  CE1 PHE    44      11.145  -9.775  10.840  1.00 31.22           C  
ATOM    261  CE2 PHE    44      13.260 -10.834  10.490  1.00 33.69           C  
ATOM    262  CZ  PHE    44      12.043 -10.747  11.155  1.00 34.12           C  
ATOM    263  N   TYR    45      11.744  -6.094   5.576  1.00 36.13           N  
ATOM    264  CA  TYR    45      12.120  -4.861   4.896  1.00 37.49           C  
ATOM    265  C   TYR    45      12.253  -3.757   5.917  1.00 37.07           C  
ATOM    266  O   TYR    45      11.271  -3.380   6.534  1.00 38.99           O  
ATOM    267  CB  TYR    45      11.055  -4.484   3.898  1.00 36.98           C  
ATOM    268  CG  TYR    45      11.334  -3.182   3.158  1.00 39.78           C  
ATOM    269  CD1 TYR    45      12.338  -3.109   2.209  1.00 40.79           C  
ATOM    270  CD2 TYR    45      10.595  -2.037   3.421  1.00 38.05           C  
ATOM    271  CE1 TYR    45      12.605  -1.935   1.531  1.00 41.88           C  
ATOM    272  CE2 TYR    45      10.858  -0.857   2.763  1.00 41.50           C  
ATOM    273  CZ  TYR    45      11.862  -0.805   1.807  1.00 40.93           C  
ATOM    274  OH  TYR    45      12.120   0.387   1.114  1.00 40.29           O  
ATOM    275  N   HIS    46      13.443  -3.229   6.111  1.00 36.34           N  
ATOM    276  CA  HIS    46      13.652  -2.224   7.156  1.00 36.95           C  
ATOM    277  C   HIS    46      14.640  -1.131   6.693  1.00 37.04           C  
ATOM    278  O   HIS    46      15.718  -1.438   6.160  1.00 36.11           O  
ATOM    279  CB  HIS    46      14.162  -2.927   8.432  1.00 37.03           C  
ATOM    280  CG  HIS    46      14.389  -2.016   9.605  1.00 38.48           C  
ATOM    281  ND1 HIS    46      13.356  -1.460  10.337  1.00 40.30           N  
ATOM    282  CD2 HIS    46      15.530  -1.603  10.200  1.00 36.98           C  
ATOM    283  CE1 HIS    46      13.855  -0.725  11.315  1.00 38.56           C  
ATOM    284  NE2 HIS    46      15.171  -0.791  11.249  1.00 38.82           N  
ATOM    285  N   LYS    47      14.275   0.138   6.920  1.00 36.95           N  
ATOM    286  CA  LYS    47      15.099   1.269   6.525  1.00 37.47           C  
ATOM    287  C   LYS    47      15.604   1.065   5.095  1.00 37.40           C  
ATOM    288  O   LYS    47      16.817   1.170   4.821  1.00 36.64           O  
ATOM    289  CB  LYS    47      16.293   1.452   7.465  1.00 38.17           C  
ATOM    290  CG  LYS    47      15.974   1.813   8.904  1.00 40.46           C  
ATOM    291  CD  LYS    47      17.211   2.484   9.503  1.00 45.27           C  
ATOM    292  CE  LYS    47      17.181   2.580  11.022  1.00 47.38           C  
ATOM    293  NZ  LYS    47      17.861   1.421  11.685  1.00 50.94           N  
ATOM    294  N   GLY    48      14.674   0.731   4.194  1.00 37.40           N  
ATOM    295  CA  GLY    48      15.000   0.560   2.776  1.00 37.40           C  
ATOM    296  C   GLY    48      15.856  -0.636   2.402  1.00 37.80           C  
ATOM    297  O   GLY    48      16.304  -0.738   1.278  1.00 38.04           O  
ATOM    298  N   GLU    49      16.085  -1.556   3.336  1.00 38.38           N  
ATOM    299  CA  GLU    49      16.829  -2.797   3.029  1.00 38.96           C  
ATOM    300  C   GLU    49      16.071  -4.079   3.366  1.00 37.40           C  
ATOM    301  O   GLU    49      15.276  -4.102   4.272  1.00 37.65           O  
ATOM    302  CB  GLU    49      18.154  -2.817   3.788  1.00 38.83           C  
ATOM    303  CG  GLU    49      18.937  -1.583   3.524  1.00 43.50           C  
ATOM    304  CD  GLU    49      20.402  -1.850   3.556  1.00 48.39           C  
ATOM    305  OE1 GLU    49      20.835  -2.546   4.503  1.00 49.17           O  
ATOM    306  OE2 GLU    49      21.094  -1.373   2.622  1.00 51.30           O  
ATOM    307  N   TYR    50      16.403  -5.145   2.652  1.00 37.51           N  
ATOM    308  CA  TYR    50      15.783  -6.447   2.770  1.00 37.42           C  
ATOM    309  C   TYR    50      16.698  -7.402   3.513  1.00 37.93           C  
ATOM    310  O   TYR    50      17.897  -7.407   3.283  1.00 36.23           O  
ATOM    311  CB  TYR    50      15.475  -6.971   1.367  1.00 38.36           C  
ATOM    312  CG  TYR    50      14.401  -6.171   0.692  1.00 38.71           C  
ATOM    313  CD1 TYR    50      13.052  -6.451   0.947  1.00 41.30           C  
ATOM    314  CD2 TYR    50      14.714  -5.109  -0.176  1.00 39.45           C  
ATOM    315  CE1 TYR    50      12.043  -5.728   0.367  1.00 39.50           C  
ATOM    316  CE2 TYR    50      13.689  -4.361  -0.778  1.00 41.37           C  
ATOM    317  CZ  TYR    50      12.347  -4.688  -0.495  1.00 41.85           C  
ATOM    318  OH  TYR    50      11.300  -3.995  -1.058  1.00 39.83           O  
ATOM    319  N   HIS    51      16.156  -8.162   4.451  1.00 37.00           N  
ATOM    320  CA  HIS    51      16.962  -9.128   5.154  1.00 37.66           C  
ATOM    321  C   HIS    51      16.187 -10.409   5.256  1.00 38.22           C  
ATOM    322  O   HIS    51      15.034 -10.396   5.749  1.00 40.63           O  
ATOM    323  CB  HIS    51      17.362  -8.635   6.576  1.00 38.17           C  
ATOM    324  CG  HIS    51      17.992  -7.280   6.598  1.00 36.35           C  
ATOM    325  ND1 HIS    51      19.324  -7.072   6.311  1.00 36.15           N  
ATOM    326  CD2 HIS    51      17.462  -6.060   6.834  1.00 36.39           C  
ATOM    327  CE1 HIS    51      19.587  -5.780   6.377  1.00 36.16           C  
ATOM    328  NE2 HIS    51      18.475  -5.144   6.699  1.00 36.78           N  
ATOM    329  N   ALA    52      16.783 -11.510   4.813  1.00 36.23           N  
ATOM    330  CA  ALA    52      16.191 -12.852   4.974  1.00 35.83           C  
ATOM    331  C   ALA    52      16.956 -13.725   5.994  1.00 35.84           C  
ATOM    332  O   ALA    52      18.162 -13.772   5.971  1.00 35.96           O  
ATOM    333  CB  ALA    52      16.112 -13.564   3.635  1.00 34.44           C  
ATOM    334  N   MET    53      16.230 -14.425   6.860  1.00 35.98           N  
ATOM    335  CA  MET    53      16.856 -15.383   7.786  1.00 35.97           C  
ATOM    336  C   MET    53      15.895 -16.513   8.097  1.00 34.34           C  
ATOM    337  O   MET    53      14.698 -16.423   7.816  1.00 34.06           O  
ATOM    338  CB  MET    53      17.275 -14.682   9.102  1.00 34.38           C  
ATOM    339  CG  MET    53      16.059 -14.042   9.793  1.00 36.38           C  
ATOM    340  SD  MET    53      16.365 -13.290  11.396  1.00 37.83           S  
ATOM    341  CE  MET    53      17.224 -11.779  10.901  1.00 31.98           C  
ATOM    342  N   ASP    54      16.437 -17.570   8.692  1.00 35.49           N  
ATOM    343  CA  ASP    54      15.663 -18.709   9.166  1.00 35.03           C  
ATOM    344  C   ASP    54      14.594 -18.178  10.077  1.00 35.41           C  
ATOM    345  O   ASP    54      14.838 -17.266  10.883  1.00 36.46           O  
ATOM    346  CB  ASP    54      16.555 -19.680   9.974  1.00 36.35           C  
ATOM    347  CG  ASP    54      17.394 -20.595   9.089  1.00 37.52           C  
ATOM    348  OD1 ASP    54      17.092 -20.730   7.865  1.00 42.19           O  
ATOM    349  OD2 ASP    54      18.379 -21.187   9.608  1.00 36.00           O  
ATOM    350  N   ILE    55      13.400 -18.736   9.977  1.00 33.76           N  
ATOM    351  CA  ILE    55      12.271 -18.163  10.687  1.00 33.72           C  
ATOM    352  C   ILE    55      12.256 -18.488  12.189  1.00 34.09           C  
ATOM    353  O   ILE    55      11.846 -17.651  12.987  1.00 35.22           O  
ATOM    354  CB  ILE    55      10.909 -18.575  10.023  1.00 32.75           C  
ATOM    355  CG1 ILE    55       9.729 -17.838  10.671  1.00 34.08           C  
ATOM    356  CG2 ILE    55      10.649 -20.098  10.162  1.00 32.55           C  
ATOM    357  CD1 ILE    55       8.426 -17.928   9.803  1.00 33.04           C  
ATOM    358  N   ARG    56      12.676 -19.701  12.554  1.00 34.32           N  
ATOM    359  CA  ARG    56      12.678 -20.122  13.949  0.50 34.27           C  
ATOM    361  C   ARG    56      13.979 -19.728  14.679  1.00 35.02           C  
ATOM    362  O   ARG    56      15.105 -19.999  14.216  1.00 34.05           O  
ATOM    363  CB  ARG    56      12.392 -21.611  14.064  0.50 33.71           C  
ATOM    365  CG  ARG    56      11.174 -22.056  13.253  0.50 33.20           C  
ATOM    367  CD  ARG    56       9.863 -21.458  13.767  0.50 34.41           C  
ATOM    369  NE  ARG    56       8.811 -21.580  12.749  0.50 33.94           N  
ATOM    371  CZ  ARG    56       7.540 -21.219  12.904  0.50 33.39           C  
ATOM    373  NH1 ARG    56       7.124 -20.701  14.053  0.50 33.15           N  
ATOM    375  NH2 ARG    56       6.684 -21.388  11.901  0.50 30.53           N  
ATOM    377  N   CYS    57      13.782 -19.059  15.804  1.00 34.89           N  
ATOM    378  CA  CYS    57      14.857 -18.517  16.622  1.00 34.84           C  
ATOM    379  C   CYS    57      15.820 -19.605  17.046  1.00 35.33           C  
ATOM    380  O   CYS    57      15.405 -20.619  17.585  1.00 34.76           O  
ATOM    381  CB  CYS    57      14.258 -17.828  17.853  1.00 35.43           C  
ATOM    382  SG  CYS    57      15.469 -17.137  18.937  1.00 35.67           S  
ATOM    383  N   TYR    58      17.109 -19.375  16.835  1.00 33.56           N  
ATOM    384  CA  TYR    58      18.141 -20.335  17.256  1.00 34.44           C  
ATOM    385  C   TYR    58      18.123 -20.742  18.712  1.00 34.87           C  
ATOM    386  O   TYR    58      18.677 -21.797  19.032  1.00 35.22           O  
ATOM    387  CB  TYR    58      19.564 -19.805  16.955  1.00 32.35           C  
ATOM    388  CG  TYR    58      20.078 -18.730  17.956  1.00 32.86           C  
ATOM    389  CD1 TYR    58      19.791 -17.386  17.764  1.00 32.31           C  
ATOM    390  CD2 TYR    58      20.892 -19.078  19.025  1.00 26.69           C  
ATOM    391  CE1 TYR    58      20.280 -16.385  18.653  1.00 36.22           C  
ATOM    392  CE2 TYR    58      21.337 -18.112  19.962  1.00 32.60           C  
ATOM    393  CZ  TYR    58      21.100 -16.767  19.710  1.00 32.41           C  
ATOM    394  OH  TYR    58      21.552 -15.812  20.596  1.00 35.59           O  
ATOM    395  N   HIS    59      17.583 -19.901  19.596  1.00 34.43           N  
ATOM    396  CA  HIS    59      17.668 -20.152  21.034  1.00 33.97           C  
ATOM    397  C   HIS    59      16.815 -21.395  21.360  1.00 34.28           C  
ATOM    398  O   HIS    59      17.331 -22.404  21.833  1.00 33.47           O  
ATOM    399  CB  HIS    59      17.194 -18.912  21.838  1.00 34.01           C  
ATOM    400  CG  HIS    59      17.046 -19.170  23.316  1.00 31.90           C  
ATOM    401  ND1 HIS    59      15.913 -18.854  24.030  1.00 32.75           N  
ATOM    402  CD2 HIS    59      17.922 -19.688  24.212  1.00 31.88           C  
ATOM    403  CE1 HIS    59      16.070 -19.221  25.292  1.00 36.93           C  
ATOM    404  NE2 HIS    59      17.286 -19.723  25.432  1.00 36.41           N  
ATOM    405  N   SER    60      15.504 -21.309  21.140  1.00 34.09           N  
ATOM    406  CA  SER    60      14.580 -22.404  21.464  1.00 35.56           C  
ATOM    407  C   SER    60      13.520 -22.620  20.402  1.00 35.00           C  
ATOM    408  O   SER    60      12.473 -23.273  20.676  1.00 34.15           O  
ATOM    409  CB  SER    60      13.793 -22.101  22.766  1.00 35.66           C  
ATOM    410  OG  SER    60      14.529 -22.465  23.868  1.00 40.94           O  
ATOM    411  N   GLY    61      13.725 -22.050  19.227  1.00 33.78           N  
ATOM    412  CA  GLY    61      12.734 -22.180  18.151  1.00 33.83           C  
ATOM    413  C   GLY    61      11.537 -21.216  18.082  1.00 33.58           C  
ATOM    414  O   GLY    61      10.581 -21.489  17.382  1.00 33.89           O  
ATOM    415  N   GLY    62      11.592 -20.060  18.752  1.00 34.29           N  
ATOM    416  CA  GLY    62      10.503 -19.064  18.703  1.00 33.30           C  
ATOM    417  C   GLY    62      10.292 -18.403  17.339  1.00 34.18           C  
ATOM    418  O   GLY    62      11.131 -18.485  16.449  1.00 34.46           O  
ATOM    419  N   PRO    63       9.131 -17.779  17.156  1.00 34.28           N  
ATOM    420  CA  PRO    63       8.647 -17.233  15.855  1.00 34.13           C  
ATOM    421  C   PRO    63       9.249 -15.820  15.609  1.00 35.32           C  
ATOM    422  O   PRO    63       8.683 -14.844  16.083  1.00 35.94           O  
ATOM    423  CB  PRO    63       7.098 -17.165  16.070  1.00 34.92           C  
ATOM    424  CG  PRO    63       6.909 -17.071  17.597  1.00 34.02           C  
ATOM    425  CD  PRO    63       8.162 -17.613  18.267  1.00 32.77           C  
ATOM    426  N   LEU    64      10.409 -15.724  14.939  1.00 33.85           N  
ATOM    427  CA  LEU    64      11.035 -14.426  14.722  1.00 35.10           C  
ATOM    428  C   LEU    64      10.190 -13.455  13.888  1.00 35.51           C  
ATOM    429  O   LEU    64      10.282 -12.231  14.090  1.00 35.60           O  
ATOM    430  CB  LEU    64      12.420 -14.584  14.076  1.00 33.19           C  
ATOM    431  CG  LEU    64      13.471 -15.228  14.956  1.00 33.67           C  
ATOM    432  CD1 LEU    64      14.780 -15.303  14.169  1.00 31.32           C  
ATOM    433  CD2 LEU    64      13.683 -14.567  16.368  1.00 32.77           C  
ATOM    434  N   HIS    65       9.310 -14.009  13.014  1.00 36.13           N  
ATOM    435  CA  HIS    65       8.382 -13.207  12.206  1.00 35.49           C  
ATOM    436  C   HIS    65       7.333 -12.496  13.062  1.00 36.08           C  
ATOM    437  O   HIS    65       6.658 -11.607  12.549  1.00 36.02           O  
ATOM    438  CB  HIS    65       7.719 -14.047  11.080  1.00 34.87           C  
ATOM    439  CG  HIS    65       6.740 -15.075  11.579  1.00 34.80           C  
ATOM    440  ND1 HIS    65       7.104 -16.108  12.425  1.00 32.82           N  
ATOM    441  CD2 HIS    65       5.425 -15.270  11.294  1.00 35.42           C  
ATOM    442  CE1 HIS    65       6.030 -16.818  12.735  1.00 35.35           C  
ATOM    443  NE2 HIS    65       5.003 -16.349  12.044  1.00 34.51           N  
ATOM    444  N   LEU    66       7.226 -12.856  14.351  1.00 35.16           N  
ATOM    445  CA  LEU    66       6.321 -12.166  15.276  1.00 34.56           C  
ATOM    446  C   LEU    66       7.126 -11.259  16.209  1.00 34.99           C  
ATOM    447  O   LEU    66       6.571 -10.695  17.130  1.00 34.13           O  
ATOM    448  CB  LEU    66       5.499 -13.148  16.118  1.00 35.06           C  
ATOM    449  CG  LEU    66       4.672 -14.209  15.366  1.00 36.17           C  
ATOM    450  CD1 LEU    66       3.790 -14.925  16.316  1.00 36.21           C  
ATOM    451  CD2 LEU    66       3.919 -13.613  14.176  1.00 33.70           C  
ATOM    452  N   GLY    67       8.431 -11.107  15.993  1.00 32.27           N  
ATOM    453  CA  GLY    67       9.167 -10.210  16.887  1.00 33.66           C  
ATOM    454  C   GLY    67       9.179  -8.750  16.492  1.00 34.02           C  
ATOM    455  O   GLY    67       8.704  -8.397  15.403  1.00 34.86           O  
ATOM    456  N   GLU    68       9.706  -7.884  17.364  1.00 34.92           N  
ATOM    457  CA  GLU    68       9.815  -6.470  17.032  0.50 34.77           C  
ATOM    459  C   GLU    68      11.234  -6.174  16.546  1.00 36.04           C  
ATOM    460  O   GLU    68      12.222  -6.826  16.990  1.00 34.69           O  
ATOM    461  CB  GLU    68       9.482  -5.582  18.246  0.50 34.98           C  
ATOM    463  CG  GLU    68       8.148  -5.870  18.980  0.50 33.52           C  
ATOM    465  CD  GLU    68       6.963  -5.201  18.371  0.50 31.29           C  
ATOM    467  OE1 GLU    68       6.995  -4.840  17.191  0.50 32.99           O  
ATOM    469  OE2 GLU    68       5.968  -5.014  19.089  0.50 35.61           O  
ATOM    471  N   ILE    69      11.358  -5.184  15.662  1.00 36.24           N  
ATOM    472  CA  ILE    69      12.690  -4.749  15.196  1.00 39.01           C  
ATOM    473  C   ILE    69      13.122  -3.516  16.002  1.00 40.20           C  
ATOM    474  O   ILE    69      12.326  -2.588  16.158  1.00 38.19           O  
ATOM    475  CB  ILE    69      12.670  -4.427  13.673  1.00 39.84           C  
ATOM    476  CG1 ILE    69      12.411  -5.733  12.873  1.00 41.79           C  
ATOM    477  CG2 ILE    69      14.002  -3.705  13.233  1.00 39.07           C  
ATOM    478  CD1 ILE    69      12.138  -5.498  11.381  1.00 39.19           C  
ATOM    479  N   GLU    70      14.336  -3.532  16.564  1.00 40.88           N  
ATOM    480  CA  GLU    70      14.914  -2.358  17.235  1.00 44.15           C  
ATOM    481  C   GLU    70      16.417  -2.296  17.027  1.00 42.63           C  
ATOM    482  O   GLU    70      17.083  -3.326  16.854  1.00 40.70           O  
ATOM    483  CB  GLU    70      14.727  -2.352  18.758  1.00 44.02           C  
ATOM    484  CG  GLU    70      13.479  -2.956  19.319  1.00 49.17           C  
ATOM    485  CD  GLU    70      13.403  -2.778  20.857  1.00 50.66           C  
ATOM    486  OE1 GLU    70      13.816  -1.656  21.361  1.00 57.14           O  
ATOM    487  OE2 GLU    70      12.923  -3.748  21.533  1.00 53.10           O  
ATOM    488  N   ASP    71      16.941  -1.081  17.146  1.00 42.60           N  
ATOM    489  CA  ASP    71      18.382  -0.850  17.089  1.00 43.31           C  
ATOM    490  C   ASP    71      19.025  -1.001  18.446  1.00 43.56           C  
ATOM    491  O   ASP    71      18.527  -0.452  19.446  1.00 44.12           O  
ATOM    492  CB  ASP    71      18.695   0.530  16.502  1.00 43.80           C  
ATOM    493  CG  ASP    71      18.390   0.615  15.022  1.00 45.66           C  
ATOM    494  OD1 ASP    71      17.523  -0.130  14.518  1.00 46.85           O  
ATOM    495  OD2 ASP    71      19.031   1.442  14.340  1.00 50.54           O  
ATOM    496  N   PHE    72      20.119  -1.763  18.480  1.00 42.87           N  
ATOM    497  CA  PHE    72      20.968  -1.887  19.651  1.00 42.59           C  
ATOM    498  C   PHE    72      22.398  -1.763  19.142  1.00 42.61           C  
ATOM    499  O   PHE    72      22.744  -2.358  18.120  1.00 41.94           O  
ATOM    500  CB  PHE    72      20.781  -3.235  20.371  1.00 43.24           C  
ATOM    501  CG  PHE    72      19.348  -3.523  20.793  1.00 45.32           C  
ATOM    502  CD1 PHE    72      18.843  -3.025  21.994  1.00 47.35           C  
ATOM    503  CD2 PHE    72      18.501  -4.280  19.983  1.00 44.73           C  
ATOM    504  CE1 PHE    72      17.503  -3.279  22.376  1.00 48.24           C  
ATOM    505  CE2 PHE    72      17.168  -4.525  20.359  1.00 39.75           C  
ATOM    506  CZ  PHE    72      16.683  -4.035  21.549  1.00 45.38           C  
ATOM    507  N   ASN    73      23.206  -0.973  19.850  1.00 43.10           N  
ATOM    508  CA  ASN    73      24.606  -0.660  19.467  1.00 43.65           C  
ATOM    509  C   ASN    73      24.686  -0.152  18.023  1.00 43.70           C  
ATOM    510  O   ASN    73      25.601  -0.496  17.283  1.00 43.14           O  
ATOM    511  CB  ASN    73      25.513  -1.889  19.657  1.00 43.42           C  
ATOM    512  CG  ASN    73      27.003  -1.519  19.856  1.00 46.43           C  
ATOM    513  OD1 ASN    73      27.353  -0.367  20.187  1.00 43.42           O  
ATOM    514  ND2 ASN    73      27.889  -2.518  19.667  1.00 48.36           N  
ATOM    515  N   GLY    74      23.677   0.609  17.606  1.00 44.40           N  
ATOM    516  CA  GLY    74      23.611   1.082  16.214  1.00 44.51           C  
ATOM    517  C   GLY    74      23.381   0.008  15.147  1.00 44.46           C  
ATOM    518  O   GLY    74      23.531   0.291  13.971  1.00 44.76           O  
ATOM    519  N   GLN    75      23.016  -1.212  15.556  1.00 43.78           N  
ATOM    520  CA  GLN    75      22.635  -2.297  14.632  1.00 42.82           C  
ATOM    521  C   GLN    75      21.157  -2.669  14.762  1.00 40.89           C  
ATOM    522  O   GLN    75      20.649  -2.890  15.865  1.00 40.71           O  
ATOM    523  CB  GLN    75      23.479  -3.545  14.896  1.00 42.81           C  
ATOM    524  CG  GLN    75      24.968  -3.400  14.622  1.00 46.95           C  
ATOM    525  CD  GLN    75      25.797  -4.451  15.386  1.00 50.89           C  
ATOM    526  OE1 GLN    75      26.011  -4.339  16.595  1.00 52.08           O  
ATOM    527  NE2 GLN    75      26.257  -5.474  14.673  1.00 51.59           N  
ATOM    528  N   SER    76      20.470  -2.740  13.621  1.00 39.88           N  
ATOM    529  CA  SER    76      19.081  -3.185  13.538  1.00 38.27           C  
ATOM    530  C   SER    76      18.980  -4.683  13.879  1.00 36.85           C  
ATOM    531  O   SER    76      19.722  -5.479  13.320  1.00 36.22           O  
ATOM    532  CB  SER    76      18.554  -2.935  12.130  1.00 38.31           C  
ATOM    533  OG  SER    76      18.478  -1.527  11.875  1.00 43.22           O  
ATOM    534  N   CYS    77      18.072  -5.043  14.789  1.00 35.33           N  
ATOM    535  CA  CYS    77      17.930  -6.402  15.313  1.00 34.59           C  
ATOM    536  C   CYS    77      16.462  -6.789  15.272  1.00 35.71           C  
ATOM    537  O   CYS    77      15.620  -5.957  15.526  1.00 35.64           O  
ATOM    538  CB  CYS    77      18.356  -6.451  16.776  1.00 33.34           C  
ATOM    539  SG  CYS    77      20.163  -6.333  16.976  1.00 35.65           S  
ATOM    540  N   ILE    78      16.190  -8.059  15.007  1.00 34.76           N  
ATOM    541  CA  ILE    78      14.973  -8.688  15.377  1.00 34.18           C  
ATOM    542  C   ILE    78      15.061  -9.169  16.864  1.00 34.62           C  
ATOM    543  O   ILE    78      16.054  -9.721  17.287  1.00 34.47           O  
ATOM    544  CB  ILE    78      14.535  -9.826  14.318  1.00 33.81           C  
ATOM    545  CG1 ILE    78      13.138 -10.355  14.634  1.00 32.87           C  
ATOM    546  CG2 ILE    78      15.569 -10.982  14.211  1.00 31.11           C  
ATOM    547  CD1 ILE    78      12.031  -9.303  14.448  1.00 29.85           C  
ATOM    548  N   VAL    79      14.017  -8.921  17.655  1.00 32.69           N  
ATOM    549  CA  VAL    79      13.972  -9.370  19.046  1.00 33.62           C  
ATOM    550  C   VAL    79      12.967 -10.495  19.058  1.00 33.60           C  
ATOM    551  O   VAL    79      11.792 -10.239  18.739  1.00 33.36           O  
ATOM    552  CB  VAL    79      13.518  -8.218  19.996  1.00 34.49           C  
ATOM    553  CG1 VAL    79      13.462  -8.703  21.467  1.00 35.62           C  
ATOM    554  CG2 VAL    79      14.427  -6.975  19.840  1.00 30.87           C  
ATOM    555  N   CYS    80      13.411 -11.721  19.355  1.00 34.05           N  
ATOM    556  CA  CYS    80      12.533 -12.854  19.471  1.00 34.02           C  
ATOM    557  C   CYS    80      11.430 -12.582  20.492  1.00 33.64           C  
ATOM    558  O   CYS    80      11.698 -12.131  21.600  1.00 32.90           O  
ATOM    559  CB  CYS    80      13.294 -14.109  19.911  1.00 34.77           C  
ATOM    560  SG  CYS    80      12.168 -15.548  19.926  1.00 35.45           S  
ATOM    561  N   PRO    81      10.148 -12.867  20.137  1.00 34.47           N  
ATOM    562  CA  PRO    81       9.161 -12.521  21.164  1.00 33.40           C  
ATOM    563  C   PRO    81       9.158 -13.389  22.422  1.00 32.58           C  
ATOM    564  O   PRO    81       8.508 -12.988  23.398  1.00 32.43           O  
ATOM    565  CB  PRO    81       7.805 -12.649  20.450  1.00 33.95           C  
ATOM    566  CG  PRO    81       8.086 -13.625  19.318  1.00 33.95           C  
ATOM    567  CD  PRO    81       9.559 -13.452  18.920  1.00 33.50           C  
ATOM    568  N   TRP    82       9.802 -14.554  22.398  1.00 32.23           N  
ATOM    569  CA  TRP    82       9.754 -15.550  23.533  1.00 31.38           C  
ATOM    570  C   TRP    82      10.749 -15.130  24.528  1.00 30.48           C  
ATOM    571  O   TRP    82      10.362 -14.756  25.596  1.00 29.33           O  
ATOM    572  CB  TRP    82       9.982 -16.993  23.023  1.00 32.45           C  
ATOM    573  CG  TRP    82       8.799 -17.617  22.294  1.00 34.89           C  
ATOM    574  CD1 TRP    82       7.596 -17.007  21.998  1.00 36.46           C  
ATOM    575  CD2 TRP    82       8.669 -18.981  21.835  1.00 35.91           C  
ATOM    576  NE1 TRP    82       6.751 -17.904  21.374  1.00 34.16           N  
ATOM    577  CE2 TRP    82       7.387 -19.107  21.242  1.00 35.08           C  
ATOM    578  CE3 TRP    82       9.521 -20.105  21.855  1.00 36.77           C  
ATOM    579  CZ2 TRP    82       6.925 -20.325  20.657  1.00 37.12           C  
ATOM    580  CZ3 TRP    82       9.077 -21.308  21.279  1.00 35.69           C  
ATOM    581  CH2 TRP    82       7.782 -21.405  20.693  1.00 37.21           C  
ATOM    582  N   HIS    83      12.068 -15.103  24.216  1.00 30.38           N  
ATOM    583  CA  HIS    83      12.919 -14.743  25.348  1.00 29.88           C  
ATOM    584  C   HIS    83      13.741 -13.485  25.057  1.00 31.78           C  
ATOM    585  O   HIS    83      14.746 -13.232  25.722  1.00 31.83           O  
ATOM    586  CB  HIS    83      13.781 -15.895  25.841  1.00 31.04           C  
ATOM    587  CG  HIS    83      13.026 -17.192  25.969  1.00 31.61           C  
ATOM    588  ND1 HIS    83      12.949 -18.098  24.940  1.00 32.84           N  
ATOM    589  CD2 HIS    83      12.222 -17.671  26.946  1.00 34.43           C  
ATOM    590  CE1 HIS    83      12.170 -19.111  25.295  1.00 32.77           C  
ATOM    591  NE2 HIS    83      11.701 -18.859  26.499  1.00 34.54           N  
ATOM    592  N   LYS    84      13.272 -12.695  24.087  1.00 31.89           N  
ATOM    593  CA  LYS    84      13.801 -11.347  23.806  1.00 31.70           C  
ATOM    594  C   LYS    84      15.293 -11.389  23.412  1.00 33.14           C  
ATOM    595  O   LYS    84      15.999 -10.409  23.572  1.00 32.10           O  
ATOM    596  CB  LYS    84      13.572 -10.417  24.989  1.00 31.06           C  
ATOM    597  CG  LYS    84      12.064 -10.399  25.517  1.00 30.64           C  
ATOM    598  CD  LYS    84      11.050 -10.263  24.434  1.00 32.36           C  
ATOM    599  CE  LYS    84       9.644  -9.933  25.085  1.00 38.66           C  
ATOM    600  NZ  LYS    84       8.482 -10.388  24.213  1.00 42.06           N  
ATOM    601  N   TYR    85      15.749 -12.497  22.829  1.00 33.63           N  
ATOM    602  CA  TYR    85      17.115 -12.501  22.289  1.00 34.59           C  
ATOM    603  C   TYR    85      17.175 -11.542  21.081  1.00 35.22           C  
ATOM    604  O   TYR    85      16.204 -11.416  20.329  1.00 34.27           O  
ATOM    605  CB  TYR    85      17.601 -13.871  21.873  1.00 34.05           C  
ATOM    606  CG  TYR    85      18.069 -14.735  23.013  1.00 33.39           C  
ATOM    607  CD1 TYR    85      17.518 -14.603  24.318  1.00 33.28           C  
ATOM    608  CD2 TYR    85      19.020 -15.705  22.782  1.00 33.67           C  
ATOM    609  CE1 TYR    85      17.960 -15.396  25.370  1.00 32.12           C  
ATOM    610  CE2 TYR    85      19.448 -16.533  23.802  1.00 36.57           C  
ATOM    611  CZ  TYR    85      18.910 -16.370  25.089  1.00 35.84           C  
ATOM    612  OH  TYR    85      19.383 -17.144  26.067  1.00 31.52           O  
ATOM    613  N   LYS    86      18.305 -10.876  20.931  1.00 34.93           N  
ATOM    614  CA  LYS    86      18.469  -9.853  19.904  1.00 36.39           C  
ATOM    615  C   LYS    86      19.354 -10.424  18.841  1.00 36.21           C  
ATOM    616  O   LYS    86      20.454 -10.888  19.121  1.00 35.92           O  
ATOM    617  CB  LYS    86      19.109  -8.620  20.483  1.00 36.57           C  
ATOM    618  CG  LYS    86      18.377  -8.041  21.744  1.00 38.21           C  
ATOM    619  CD  LYS    86      19.382  -6.992  22.306  1.00 41.31           C  
ATOM    620  CE  LYS    86      18.733  -6.100  23.324  1.00 46.04           C  
ATOM    621  NZ  LYS    86      18.598  -6.744  24.662  1.00 46.41           N  
ATOM    622  N   ILE    87      18.849 -10.420  17.612  1.00 35.80           N  
ATOM    623  CA  ILE    87      19.600 -10.980  16.491  1.00 34.37           C  
ATOM    624  C   ILE    87      19.777  -9.927  15.419  1.00 35.24           C  
ATOM    625  O   ILE    87      18.772  -9.368  14.953  1.00 33.39           O  
ATOM    626  CB  ILE    87      18.816 -12.178  15.906  1.00 35.19           C  
ATOM    627  CG1 ILE    87      18.756 -13.254  17.013  1.00 32.85           C  
ATOM    628  CG2 ILE    87      19.485 -12.672  14.587  1.00 32.28           C  
ATOM    629  CD1 ILE    87      17.647 -14.305  16.840  1.00 33.74           C  
ATOM    630  N   THR    88      21.023  -9.680  15.000  1.00 32.82           N  
ATOM    631  CA  THR    88      21.230  -8.635  13.996  1.00 34.57           C  
ATOM    632  C   THR    88      20.607  -9.068  12.656  1.00 34.38           C  
ATOM    633  O   THR    88      20.650 -10.224  12.304  1.00 34.53           O  
ATOM    634  CB  THR    88      22.724  -8.301  13.763  1.00 34.35           C  
ATOM    635  OG1 THR    88      23.409  -9.475  13.340  1.00 35.21           O  
ATOM    636  CG2 THR    88      23.392  -7.774  15.039  1.00 33.63           C  
ATOM    637  N   LEU    89      19.976  -8.125  11.981  1.00 34.00           N  
ATOM    638  CA  LEU    89      19.322  -8.356  10.695  1.00 35.35           C  
ATOM    639  C   LEU    89      20.380  -8.672   9.650  1.00 35.40           C  
ATOM    640  O   LEU    89      20.181  -9.579   8.837  1.00 36.23           O  
ATOM    641  CB  LEU    89      18.529  -7.081  10.287  1.00 33.99           C  
ATOM    642  CG  LEU    89      17.230  -6.790  11.094  1.00 32.97           C  
ATOM    643  CD1 LEU    89      16.426  -5.700  10.357  1.00 31.94           C  
ATOM    644  CD2 LEU    89      16.393  -8.003  11.336  1.00 30.27           C  
ATOM    645  N   ALA    90      21.509  -7.975   9.727  1.00 34.20           N  
ATOM    646  CA  ALA    90      22.519  -8.019   8.678  1.00 36.25           C  
ATOM    647  C   ALA    90      23.387  -9.263   8.793  1.00 36.66           C  
ATOM    648  O   ALA    90      23.758  -9.810   7.776  1.00 36.43           O  
ATOM    649  CB  ALA    90      23.415  -6.759   8.683  1.00 35.66           C  
ATOM    650  N   THR    91      23.685  -9.717  10.027  1.00 34.82           N  
ATOM    651  CA  THR    91      24.589 -10.858  10.183  1.00 35.01           C  
ATOM    652  C   THR    91      24.116 -12.087  10.991  1.00 35.56           C  
ATOM    653  O   THR    91      24.853 -13.077  11.052  1.00 36.37           O  
ATOM    654  CB  THR    91      25.960 -10.390  10.761  1.00 34.11           C  
ATOM    655  OG1 THR    91      25.737  -9.613  11.957  1.00 35.18           O  
ATOM    656  CG2 THR    91      26.699  -9.568   9.732  1.00 33.96           C  
ATOM    657  N   GLY    92      22.938 -12.026  11.618  1.00 33.49           N  
ATOM    658  CA  GLY    92      22.460 -13.150  12.383  1.00 34.48           C  
ATOM    659  C   GLY    92      23.227 -13.354  13.680  1.00 35.00           C  
ATOM    660  O   GLY    92      23.222 -14.444  14.230  1.00 34.54           O  
ATOM    661  N   GLU    93      23.805 -12.274  14.204  1.00 35.53           N  
ATOM    662  CA  GLU    93      24.569 -12.353  15.436  1.00 36.08           C  
ATOM    663  C   GLU    93      23.607 -12.161  16.603  1.00 37.33           C  
ATOM    664  O   GLU    93      22.883 -11.187  16.639  1.00 34.20           O  
ATOM    665  CB  GLU    93      25.642 -11.255  15.497  1.00 35.02           C  
ATOM    666  CG  GLU    93      26.854 -11.393  14.533  1.00 31.69           C  
ATOM    667  CD  GLU    93      27.731 -10.176  14.562  1.00 34.65           C  
ATOM    668  OE1 GLU    93      28.431  -9.935  15.578  1.00 37.63           O  
ATOM    669  OE2 GLU    93      27.761  -9.438  13.567  1.00 33.35           O  
ATOM    670  N   GLY    94      23.689 -13.064  17.584  1.00 39.26           N  
ATOM    671  CA  GLY    94      23.199 -12.833  18.957  1.00 39.94           C  
ATOM    672  C   GLY    94      23.965 -11.705  19.616  1.00 40.96           C  
ATOM    673  O   GLY    94      25.195 -11.754  19.743  1.00 41.85           O  
ATOM    674  N   LEU    95      23.262 -10.662  20.036  1.00 41.80           N  
ATOM    675  CA  LEU    95      23.912  -9.522  20.705  1.00 43.32           C  
ATOM    676  C   LEU    95      23.481  -9.430  22.157  1.00 44.62           C  
ATOM    677  O   LEU    95      22.305  -9.712  22.518  1.00 44.46           O  
ATOM    678  CB  LEU    95      23.514  -8.202  20.035  1.00 43.50           C  
ATOM    679  CG  LEU    95      23.999  -7.851  18.663  1.00 43.89           C  
ATOM    680  CD1 LEU    95      23.548  -6.420  18.448  1.00 42.62           C  
ATOM    681  CD2 LEU    95      25.548  -7.911  18.639  1.00 46.24           C  
ATOM    682  N   TYR    96      24.422  -9.008  22.993  1.00 45.03           N  
ATOM    683  CA  TYR    96      24.140  -8.751  24.398  1.00 45.51           C  
ATOM    684  C   TYR    96      25.061  -7.662  24.986  1.00 45.91           C  
ATOM    685  O   TYR    96      26.169  -7.340  24.467  1.00 45.16           O  
ATOM    686  CB  TYR    96      24.236 -10.057  25.240  1.00 45.83           C  
ATOM    687  CG  TYR    96      25.604 -10.654  25.208  1.00 44.27           C  
ATOM    688  CD1 TYR    96      26.031 -11.370  24.071  1.00 50.00           C  
ATOM    689  CD2 TYR    96      26.502 -10.491  26.263  1.00 46.02           C  
ATOM    690  CE1 TYR    96      27.349 -11.916  23.981  1.00 47.47           C  
ATOM    691  CE2 TYR    96      27.839 -11.074  26.200  1.00 46.29           C  
ATOM    692  CZ  TYR    96      28.231 -11.777  25.050  1.00 44.35           C  
ATOM    693  OH  TYR    96      29.492 -12.321  24.908  1.00 45.24           O  
ATOM    694  N   GLN    97      24.585  -7.086  26.087  1.00 46.30           N  
ATOM    695  CA  GLN    97      25.427  -6.235  26.908  1.00 46.58           C  
ATOM    696  C   GLN    97      26.028  -7.040  28.046  1.00 45.88           C  
ATOM    697  O   GLN    97      25.322  -7.760  28.753  1.00 44.56           O  
ATOM    698  CB  GLN    97      24.642  -5.078  27.499  1.00 47.22           C  
ATOM    699  CG  GLN    97      24.144  -4.011  26.589  1.00 48.64           C  
ATOM    700  CD  GLN    97      23.318  -3.005  27.411  1.00 52.59           C  
ATOM    701  OE1 GLN    97      23.868  -2.091  28.035  1.00 53.02           O  
ATOM    702  NE2 GLN    97      22.001  -3.214  27.457  1.00 51.22           N  
ATOM    703  N   SER    98      27.332  -6.892  28.210  1.00 45.90           N  
ATOM    704  CA  SER    98      28.032  -7.433  29.337  1.00 47.24           C  
ATOM    705  C   SER    98      28.166  -6.335  30.376  1.00 49.34           C  
ATOM    706  O   SER    98      28.757  -5.280  30.106  1.00 49.89           O  
ATOM    707  CB  SER    98      29.421  -7.930  28.921  1.00 47.10           C  
ATOM    708  OG  SER    98      30.102  -8.443  30.055  1.00 45.34           O  
ATOM    709  N   ILE    99      27.643  -6.611  31.572  1.00 51.39           N  
ATOM    710  CA  ILE    99      27.521  -5.639  32.677  1.00 52.93           C  
ATOM    711  C   ILE    99      28.393  -6.106  33.858  1.00 54.29           C  
ATOM    712  O   ILE    99      28.399  -7.298  34.199  1.00 54.71           O  
ATOM    713  CB  ILE    99      26.001  -5.470  33.104  1.00 52.30           C  
ATOM    714  CG1 ILE    99      25.131  -5.046  31.911  1.00 51.54           C  
ATOM    715  CG2 ILE    99      25.821  -4.493  34.288  1.00 53.70           C  
ATOM    716  CD1 ILE    99      23.807  -5.799  31.805  1.00 46.37           C  
ATOM    717  N   ASN   100      29.145  -5.184  34.459  1.00 55.52           N  
ATOM    718  CA  ASN   100      29.915  -5.522  35.654  1.00 56.83           C  
ATOM    719  C   ASN   100      29.368  -4.911  36.948  1.00 57.31           C  
ATOM    720  O   ASN   100      29.767  -3.798  37.320  1.00 57.84           O  
ATOM    721  CB  ASN   100      31.395  -5.180  35.492  1.00 57.18           C  
ATOM    722  CG  ASN   100      32.279  -5.978  36.445  1.00 58.52           C  
ATOM    723  OD1 ASN   100      32.301  -5.729  37.666  1.00 55.73           O  
ATOM    724  ND2 ASN   100      32.999  -6.966  35.887  1.00 59.65           N  
ATOM    725  N   PRO   101      28.505  -5.669  37.671  1.00 57.70           N  
ATOM    726  CA  PRO   101      27.715  -5.252  38.861  1.00 57.67           C  
ATOM    727  C   PRO   101      28.494  -4.456  39.916  1.00 57.26           C  
ATOM    728  O   PRO   101      29.706  -4.632  40.048  1.00 57.24           O  
ATOM    729  CB  PRO   101      27.268  -6.589  39.470  1.00 57.78           C  
ATOM    730  CG  PRO   101      28.071  -7.663  38.736  1.00 57.63           C  
ATOM    731  CD  PRO   101      28.294  -7.099  37.376  1.00 57.45           C  
ATOM    732  N   LYS   107      29.692   1.272  32.920  1.00 52.92           N  
ATOM    733  CA  LYS   107      29.148   1.413  31.570  1.00 53.38           C  
ATOM    734  C   LYS   107      29.016   0.059  30.807  1.00 53.00           C  
ATOM    735  O   LYS   107      30.028  -0.555  30.445  1.00 53.19           O  
ATOM    736  CB  LYS   107      30.007   2.402  30.785  1.00 53.22           C  
ATOM    737  CG  LYS   107      29.300   3.062  29.608  1.00 54.17           C  
ATOM    738  CD  LYS   107      30.302   3.782  28.676  1.00 54.72           C  
ATOM    739  CE  LYS   107      30.830   2.874  27.551  1.00 56.01           C  
ATOM    740  NZ  LYS   107      29.758   2.104  26.827  1.00 56.35           N  
ATOM    741  N   PRO   108      27.766  -0.424  30.589  1.00 52.64           N  
ATOM    742  CA  PRO   108      27.527  -1.639  29.776  1.00 52.07           C  
ATOM    743  C   PRO   108      28.149  -1.649  28.357  1.00 51.06           C  
ATOM    744  O   PRO   108      28.077  -0.662  27.610  1.00 51.00           O  
ATOM    745  CB  PRO   108      25.986  -1.740  29.709  1.00 52.11           C  
ATOM    746  CG  PRO   108      25.470  -0.398  30.166  1.00 52.53           C  
ATOM    747  CD  PRO   108      26.501   0.106  31.141  1.00 52.95           C  
ATOM    748  N   LYS   109      28.747  -2.780  28.007  1.00 49.63           N  
ATOM    749  CA  LYS   109      29.417  -2.927  26.728  1.00 48.39           C  
ATOM    750  C   LYS   109      28.752  -4.014  25.903  1.00 47.32           C  
ATOM    751  O   LYS   109      28.409  -5.079  26.408  1.00 46.47           O  
ATOM    752  CB  LYS   109      30.908  -3.231  26.929  1.00 48.48           C  
ATOM    753  CG  LYS   109      31.675  -2.169  27.706  1.00 48.27           C  
ATOM    754  CD  LYS   109      32.101  -0.976  26.816  1.00 48.40           C  
ATOM    755  CE  LYS   109      32.829   0.130  27.608  1.00 48.03           C  
ATOM    756  NZ  LYS   109      34.057  -0.306  28.331  1.00 48.01           N  
ATOM    757  N   TRP   110      28.577  -3.715  24.624  1.00 46.18           N  
ATOM    758  CA  TRP   110      27.922  -4.607  23.689  1.00 45.75           C  
ATOM    759  C   TRP   110      28.888  -5.683  23.197  1.00 44.56           C  
ATOM    760  O   TRP   110      30.046  -5.391  22.911  1.00 42.89           O  
ATOM    761  CB  TRP   110      27.375  -3.803  22.515  1.00 45.61           C  
ATOM    762  CG  TRP   110      26.203  -3.031  22.904  1.00 46.40           C  
ATOM    763  CD1 TRP   110      26.153  -1.699  23.258  1.00 45.90           C  
ATOM    764  CD2 TRP   110      24.869  -3.540  23.026  1.00 45.33           C  
ATOM    765  NE1 TRP   110      24.843  -1.349  23.573  1.00 45.91           N  
ATOM    766  CE2 TRP   110      24.038  -2.454  23.441  1.00 46.03           C  
ATOM    767  CE3 TRP   110      24.291  -4.803  22.822  1.00 45.31           C  
ATOM    768  CZ2 TRP   110      22.634  -2.600  23.654  1.00 46.18           C  
ATOM    769  CZ3 TRP   110      22.872  -4.949  23.031  1.00 46.50           C  
ATOM    770  CH2 TRP   110      22.082  -3.853  23.464  1.00 44.84           C  
ATOM    771  N   CYS   111      28.361  -6.904  23.104  1.00 43.73           N  
ATOM    772  CA  CYS   111      29.114  -8.133  22.804  1.00 43.51           C  
ATOM    773  C   CYS   111      28.372  -9.074  21.871  1.00 42.24           C  
ATOM    774  O   CYS   111      27.149  -9.058  21.816  1.00 41.79           O  
ATOM    775  CB  CYS   111      29.376  -8.905  24.099  1.00 43.86           C  
ATOM    776  SG  CYS   111      30.478  -8.046  25.204  1.00 46.60           S  
ATOM    777  N   SER   112      29.104  -9.937  21.181  1.00 40.36           N  
ATOM    778  CA  SER   112      28.489 -10.890  20.233  1.00 38.78           C  
ATOM    779  C   SER   112      29.045 -12.287  20.444  1.00 38.54           C  
ATOM    780  O   SER   112      30.236 -12.465  20.784  1.00 37.11           O  
ATOM    781  CB  SER   112      28.784 -10.442  18.777  1.00 38.60           C  
ATOM    782  OG  SER   112      28.526 -11.474  17.829  1.00 36.33           O  
ATOM    783  N   LYS   113      28.240 -13.294  20.134  1.00 39.27           N  
ATOM    784  CA  LYS   113      28.809 -14.664  20.073  1.00 39.20           C  
ATOM    785  C   LYS   113      28.966 -15.206  18.665  1.00 37.38           C  
ATOM    786  O   LYS   113      29.110 -16.411  18.469  1.00 37.70           O  
ATOM    787  CB  LYS   113      27.989 -15.639  20.921  1.00 42.14           C  
ATOM    788  CG  LYS   113      28.737 -16.266  22.147  1.00 43.01           C  
ATOM    789  CD  LYS   113      27.629 -16.659  23.119  1.00 49.68           C  
ATOM    790  CE  LYS   113      28.098 -16.891  24.541  1.00 52.37           C  
ATOM    791  NZ  LYS   113      26.895 -17.361  25.347  1.00 52.14           N  
ATOM    792  N   GLY   114      29.001 -14.319  17.685  1.00 35.65           N  
ATOM    793  CA  GLY   114      29.233 -14.768  16.320  1.00 33.82           C  
ATOM    794  C   GLY   114      27.873 -15.014  15.692  1.00 33.37           C  
ATOM    795  O   GLY   114      26.853 -14.701  16.302  1.00 33.36           O  
ATOM    796  N   VAL   115      27.846 -15.649  14.525  1.00 32.79           N  
ATOM    797  CA  VAL   115      26.561 -15.900  13.774  1.00 33.84           C  
ATOM    798  C   VAL   115      25.799 -17.031  14.496  1.00 34.57           C  
ATOM    799  O   VAL   115      26.361 -18.137  14.767  1.00 34.43           O  
ATOM    800  CB  VAL   115      26.845 -16.293  12.300  1.00 33.90           C  
ATOM    801  CG1 VAL   115      25.555 -16.622  11.522  1.00 31.20           C  
ATOM    802  CG2 VAL   115      27.703 -15.199  11.551  1.00 33.60           C  
ATOM    803  N   LYS   116      24.574 -16.720  14.899  1.00 33.94           N  
ATOM    804  CA  LYS   116      23.689 -17.683  15.526  1.00 34.60           C  
ATOM    805  C   LYS   116      22.534 -18.002  14.584  1.00 36.35           C  
ATOM    806  O   LYS   116      22.037 -19.147  14.525  1.00 36.12           O  
ATOM    807  CB  LYS   116      23.137 -17.076  16.830  1.00 34.93           C  
ATOM    808  CG  LYS   116      24.158 -16.962  17.967  1.00 36.71           C  
ATOM    809  CD  LYS   116      24.828 -18.295  18.150  1.00 37.08           C  
ATOM    810  CE  LYS   116      25.508 -18.443  19.482  1.00 39.69           C  
ATOM    811  NZ  LYS   116      25.820 -19.872  19.666  1.00 39.79           N  
ATOM    812  N   GLN   117      22.067 -16.972  13.876  1.00 36.23           N  
ATOM    813  CA  GLN   117      20.877 -17.109  13.025  1.00 37.34           C  
ATOM    814  C   GLN   117      21.271 -17.048  11.555  1.00 37.69           C  
ATOM    815  O   GLN   117      21.845 -16.036  11.090  1.00 37.71           O  
ATOM    816  CB  GLN   117      19.869 -15.988  13.312  1.00 36.96           C  
ATOM    817  CG  GLN   117      18.463 -16.279  12.769  1.00 36.32           C  
ATOM    818  CD  GLN   117      17.735 -17.310  13.592  1.00 35.64           C  
ATOM    819  OE1 GLN   117      18.100 -17.589  14.764  1.00 33.21           O  
ATOM    820  NE2 GLN   117      16.695 -17.910  12.990  1.00 32.46           N  
ATOM    821  N   ARG   118      20.991 -18.126  10.825  1.00 37.71           N  
ATOM    822  CA  ARG   118      21.418 -18.190   9.418  1.00 37.98           C  
ATOM    823  C   ARG   118      20.741 -17.092   8.573  1.00 37.27           C  
ATOM    824  O   ARG   118      19.476 -17.000   8.499  1.00 37.04           O  
ATOM    825  CB  ARG   118      21.179 -19.576   8.789  1.00 38.02           C  
ATOM    826  CG  ARG   118      21.819 -19.735   7.378  1.00 39.40           C  
ATOM    827  CD  ARG   118      21.777 -21.175   6.875  1.00 38.52           C  
ATOM    828  NE  ARG   118      22.687 -22.033   7.665  1.00 38.06           N  
ATOM    829  CZ  ARG   118      24.022 -22.129   7.515  1.00 37.93           C  
ATOM    830  NH1 ARG   118      24.691 -21.440   6.593  1.00 34.56           N  
ATOM    831  NH2 ARG   118      24.703 -22.923   8.333  1.00 38.47           N  
ATOM    832  N   ILE   119      21.582 -16.256   7.956  1.00 36.09           N  
ATOM    833  CA  ILE   119      21.119 -15.156   7.094  1.00 36.00           C  
ATOM    834  C   ILE   119      21.166 -15.659   5.666  1.00 36.74           C  
ATOM    835  O   ILE   119      22.181 -16.133   5.235  1.00 36.50           O  
ATOM    836  CB  ILE   119      22.024 -13.877   7.212  1.00 35.96           C  
ATOM    837  CG1 ILE   119      22.022 -13.307   8.650  1.00 34.90           C  
ATOM    838  CG2 ILE   119      21.682 -12.825   6.125  1.00 35.15           C  
ATOM    839  CD1 ILE   119      20.602 -12.885   9.187  1.00 30.88           C  
ATOM    840  N   HIS   120      20.053 -15.565   4.942  1.00 36.85           N  
ATOM    841  CA  HIS   120      20.040 -15.841   3.493  1.00 38.96           C  
ATOM    842  C   HIS   120      20.138 -14.559   2.630  1.00 39.25           C  
ATOM    843  O   HIS   120      20.005 -13.427   3.128  1.00 40.02           O  
ATOM    844  CB  HIS   120      18.777 -16.660   3.144  1.00 38.05           C  
ATOM    845  CG  HIS   120      18.561 -17.800   4.089  1.00 38.96           C  
ATOM    846  ND1 HIS   120      19.418 -18.878   4.150  1.00 36.58           N  
ATOM    847  CD2 HIS   120      17.627 -18.000   5.053  1.00 35.27           C  
ATOM    848  CE1 HIS   120      19.003 -19.709   5.090  1.00 38.50           C  
ATOM    849  NE2 HIS   120      17.934 -19.192   5.668  1.00 35.36           N  
ATOM    850  N   THR   121      20.333 -14.756   1.338  1.00 39.59           N  
ATOM    851  CA  THR   121      20.491 -13.659   0.402  1.00 40.27           C  
ATOM    852  C   THR   121      19.199 -13.159  -0.273  1.00 40.15           C  
ATOM    853  O   THR   121      18.438 -13.936  -0.858  1.00 39.80           O  
ATOM    854  CB  THR   121      21.500 -14.066  -0.671  1.00 40.22           C  
ATOM    855  OG1 THR   121      22.749 -14.397  -0.034  1.00 41.98           O  
ATOM    856  CG2 THR   121      21.706 -12.937  -1.682  1.00 41.72           C  
ATOM    857  N   VAL   122      19.007 -11.839  -0.253  1.00 41.00           N  
ATOM    858  CA  VAL   122      17.854 -11.203  -0.869  1.00 41.58           C  
ATOM    859  C   VAL   122      18.258 -10.178  -1.930  1.00 43.48           C  
ATOM    860  O   VAL   122      19.146  -9.338  -1.698  1.00 43.53           O  
ATOM    861  CB  VAL   122      16.981 -10.464   0.162  1.00 41.71           C  
ATOM    862  CG1 VAL   122      15.644 -10.073  -0.474  1.00 38.28           C  
ATOM    863  CG2 VAL   122      16.765 -11.303   1.363  1.00 40.94           C  
ATOM    864  N   LYS   123      17.587 -10.270  -3.081  1.00 44.58           N  
ATOM    865  CA  LYS   123      17.739  -9.350  -4.214  1.00 46.35           C  
ATOM    866  C   LYS   123      16.342  -8.962  -4.683  1.00 46.16           C  
ATOM    867  O   LYS   123      15.405  -9.785  -4.628  1.00 46.09           O  
ATOM    868  CB  LYS   123      18.475 -10.028  -5.365  1.00 45.73           C  
ATOM    869  CG  LYS   123      19.758 -10.697  -4.915  1.00 49.43           C  
ATOM    870  CD  LYS   123      20.670 -11.185  -6.033  1.00 49.00           C  
ATOM    871  CE  LYS   123      21.765 -12.074  -5.411  1.00 53.31           C  
ATOM    872  NZ  LYS   123      23.006 -11.341  -5.004  1.00 54.10           N  
ATOM    873  N   VAL   124      16.198  -7.705  -5.112  1.00 46.40           N  
ATOM    874  CA  VAL   124      15.000  -7.293  -5.832  1.00 46.88           C  
ATOM    875  C   VAL   124      15.379  -7.052  -7.277  1.00 46.74           C  
ATOM    876  O   VAL   124      16.504  -6.635  -7.570  1.00 46.43           O  
ATOM    877  CB  VAL   124      14.232  -6.080  -5.185  1.00 47.39           C  
ATOM    878  CG1 VAL   124      13.900  -6.365  -3.711  1.00 46.38           C  
ATOM    879  CG2 VAL   124      15.003  -4.779  -5.323  1.00 48.38           C  
ATOM    880  N   ASP   125      14.456  -7.392  -8.164  1.00 46.24           N  
ATOM    881  CA  ASP   125      14.604  -7.198  -9.603  1.00 46.97           C  
ATOM    882  C   ASP   125      13.200  -7.131 -10.144  1.00 46.60           C  
ATOM    883  O   ASP   125      12.381  -8.010  -9.868  1.00 46.64           O  
ATOM    884  CB  ASP   125      15.365  -8.366 -10.243  1.00 47.02           C  
ATOM    885  CG  ASP   125      15.581  -8.179 -11.735  1.00 48.06           C  
ATOM    886  OD1 ASP   125      16.409  -7.324 -12.127  1.00 47.94           O  
ATOM    887  OD2 ASP   125      14.925  -8.901 -12.522  1.00 49.86           O  
ATOM    888  N   ASN   126      12.915  -6.066 -10.880  1.00 46.65           N  
ATOM    889  CA  ASN   126      11.595  -5.865 -11.459  1.00 46.94           C  
ATOM    890  C   ASN   126      10.482  -5.772 -10.414  1.00 46.29           C  
ATOM    891  O   ASN   126       9.341  -6.151 -10.691  1.00 46.38           O  
ATOM    892  CB  ASN   126      11.265  -6.996 -12.440  1.00 47.56           C  
ATOM    893  CG  ASN   126      11.881  -6.790 -13.785  1.00 48.66           C  
ATOM    894  OD1 ASN   126      13.106  -6.718 -13.920  1.00 51.64           O  
ATOM    895  ND2 ASN   126      11.040  -6.693 -14.802  1.00 48.83           N  
ATOM    896  N   GLY   127      10.816  -5.281  -9.221  1.00 45.49           N  
ATOM    897  CA  GLY   127       9.850  -5.254  -8.121  1.00 44.79           C  
ATOM    898  C   GLY   127       9.414  -6.632  -7.616  1.00 43.72           C  
ATOM    899  O   GLY   127       8.267  -6.769  -7.095  1.00 44.18           O  
ATOM    900  N   ASN   128      10.302  -7.652  -7.804  1.00 41.82           N  
ATOM    901  CA  ASN   128      10.065  -8.957  -7.237  1.00 40.23           C  
ATOM    902  C   ASN   128      11.127  -9.241  -6.198  1.00 40.41           C  
ATOM    903  O   ASN   128      12.298  -8.871  -6.378  1.00 39.02           O  
ATOM    904  CB  ASN   128      10.104 -10.042  -8.298  1.00 40.14           C  
ATOM    905  CG  ASN   128       8.857 -10.065  -9.183  1.00 40.64           C  
ATOM    906  OD1 ASN   128       7.774  -9.582  -8.797  1.00 42.50           O  
ATOM    907  ND2 ASN   128       9.001 -10.667 -10.368  1.00 35.86           N  
ATOM    908  N   ILE   129      10.736  -9.889  -5.104  1.00 39.25           N  
ATOM    909  CA  ILE   129      11.724 -10.264  -4.089  1.00 39.89           C  
ATOM    910  C   ILE   129      12.189 -11.689  -4.363  1.00 39.72           C  
ATOM    911  O   ILE   129      11.367 -12.580  -4.538  1.00 40.66           O  
ATOM    912  CB  ILE   129      11.177 -10.050  -2.666  1.00 40.15           C  
ATOM    913  CG1 ILE   129      10.646  -8.609  -2.563  1.00 39.73           C  
ATOM    914  CG2 ILE   129      12.289 -10.383  -1.574  1.00 38.54           C  
ATOM    915  CD1 ILE   129       9.946  -8.267  -1.304  1.00 41.42           C  
ATOM    916  N   TYR   130      13.505 -11.885  -4.456  1.00 39.44           N  
ATOM    917  CA  TYR   130      14.075 -13.199  -4.695  1.00 39.04           C  
ATOM    918  C   TYR   130      14.927 -13.622  -3.518  1.00 39.32           C  
ATOM    919  O   TYR   130      15.779 -12.858  -3.059  1.00 40.79           O  
ATOM    920  CB  TYR   130      14.921 -13.200  -5.984  1.00 38.38           C  
ATOM    921  CG  TYR   130      14.096 -13.000  -7.267  1.00 37.81           C  
ATOM    922  CD1 TYR   130      13.542 -14.087  -7.933  1.00 36.33           C  
ATOM    923  CD2 TYR   130      13.858 -11.725  -7.789  1.00 36.31           C  
ATOM    924  CE1 TYR   130      12.789 -13.923  -9.121  1.00 38.63           C  
ATOM    925  CE2 TYR   130      13.089 -11.540  -8.988  1.00 38.25           C  
ATOM    926  CZ  TYR   130      12.559 -12.647  -9.645  1.00 38.04           C  
ATOM    927  OH  TYR   130      11.771 -12.507 -10.806  1.00 40.74           O  
ATOM    928  N   VAL   131      14.753 -14.852  -3.063  1.00 38.99           N  
ATOM    929  CA  VAL   131      15.594 -15.364  -1.979  1.00 39.24           C  
ATOM    930  C   VAL   131      16.495 -16.532  -2.447  1.00 39.70           C  
ATOM    931  O   VAL   131      16.069 -17.417  -3.165  1.00 38.44           O  
ATOM    932  CB  VAL   131      14.755 -15.722  -0.681  1.00 40.15           C  
ATOM    933  CG1 VAL   131      15.672 -16.298   0.427  1.00 38.58           C  
ATOM    934  CG2 VAL   131      14.018 -14.500  -0.156  1.00 38.05           C  
ATOM    935  N   THR   132      17.747 -16.518  -2.008  1.00 40.04           N  
ATOM    936  CA  THR   132      18.662 -17.596  -2.286  1.00 40.59           C  
ATOM    937  C   THR   132      19.160 -18.076  -0.934  1.00 41.95           C  
ATOM    938  O   THR   132      19.635 -17.260  -0.131  1.00 42.01           O  
ATOM    939  CB  THR   132      19.816 -17.068  -3.200  1.00 40.85           C  
ATOM    940  OG1 THR   132      19.228 -16.494  -4.379  1.00 36.46           O  
ATOM    941  CG2 THR   132      20.793 -18.173  -3.591  1.00 40.09           C  
ATOM    942  N   LEU   133      19.006 -19.376  -0.646  1.00 43.00           N  
ATOM    943  CA  LEU   133      19.478 -19.932   0.642  1.00 43.84           C  
ATOM    944  C   LEU   133      21.003 -19.800   0.731  1.00 45.22           C  
ATOM    945  O   LEU   133      21.701 -19.944  -0.277  1.00 45.17           O  
ATOM    946  CB  LEU   133      19.037 -21.390   0.842  1.00 42.75           C  
ATOM    947  CG  LEU   133      17.561 -21.744   1.009  1.00 43.41           C  
ATOM    948  CD1 LEU   133      17.355 -23.248   1.217  1.00 40.34           C  
ATOM    949  CD2 LEU   133      16.914 -20.945   2.158  1.00 38.38           C  
ATOM    950  N   SER   134      21.518 -19.499   1.921  1.00 46.77           N  
ATOM    951  CA  SER   134      22.947 -19.315   2.087  1.00 48.93           C  
ATOM    952  C   SER   134      23.636 -20.617   2.454  1.00 50.30           C  
ATOM    953  O   SER   134      23.052 -21.430   3.178  1.00 50.76           O  
ATOM    954  CB  SER   134      23.217 -18.359   3.212  1.00 48.46           C  
ATOM    955  OG  SER   134      23.246 -19.084   4.431  1.00 51.29           O  
ATOM    956  N   LYS   135      24.888 -20.776   1.999  1.00 51.51           N  
ATOM    957  CA  LYS   135      25.747 -21.898   2.405  1.00 52.31           C  
ATOM    958  C   LYS   135      26.749 -21.454   3.469  1.00 53.22           C  
ATOM    959  O   LYS   135      27.278 -22.269   4.220  1.00 53.31           O  
ATOM    960  CB  LYS   135      26.517 -22.448   1.204  1.00 52.38           C  
ATOM    961  CG  LYS   135      25.832 -22.306  -0.127  1.00 52.11           C  
ATOM    962  CD  LYS   135      26.629 -23.075  -1.207  1.00 52.26           C  
ATOM    963  CE  LYS   135      26.349 -22.568  -2.623  1.00 51.66           C  
ATOM    964  NZ  LYS   135      27.234 -23.237  -3.657  1.00 51.02           N  
ATOM    965  N   GLU   136      27.006 -20.152   3.518  1.00 54.27           N  
ATOM    966  CA  GLU   136      27.956 -19.560   4.457  1.00 55.33           C  
ATOM    967  C   GLU   136      27.206 -19.019   5.694  1.00 55.09           C  
ATOM    968  O   GLU   136      26.128 -18.427   5.545  1.00 56.28           O  
ATOM    969  CB  GLU   136      28.719 -18.437   3.723  1.00 55.83           C  
ATOM    970  CG  GLU   136      29.997 -17.945   4.391  1.00 57.12           C  
ATOM    971  CD  GLU   136      31.278 -18.520   3.788  1.00 61.09           C  
ATOM    972  OE1 GLU   136      32.107 -19.071   4.568  1.00 61.63           O  
ATOM    973  OE2 GLU   136      31.476 -18.395   2.549  1.00 61.99           O  
ATOM    974  N   PRO   137      27.715 -19.267   6.936  1.00 55.06           N  
ATOM    975  CA  PRO   137      28.830 -20.105   7.419  1.00 54.23           C  
ATOM    976  C   PRO   137      28.458 -21.596   7.460  1.00 53.34           C  
ATOM    977  O   PRO   137      27.266 -21.937   7.390  1.00 53.31           O  
ATOM    978  CB  PRO   137      29.047 -19.593   8.848  1.00 53.86           C  
ATOM    979  CG  PRO   137      27.741 -19.181   9.281  1.00 54.97           C  
ATOM    980  CD  PRO   137      27.050 -18.585   8.071  1.00 54.57           C  
ATOM    981  N   PHE   138      29.459 -22.466   7.614  1.00 51.43           N  
ATOM    982  CA  PHE   138      29.223 -23.905   7.498  1.00 50.12           C  
ATOM    983  C   PHE   138      28.121 -24.426   8.435  1.00 48.87           C  
ATOM    984  O   PHE   138      27.243 -25.166   7.987  1.00 48.71           O  
ATOM    985  CB  PHE   138      30.543 -24.770   7.566  1.00 50.26           C  
ATOM    986  CG  PHE   138      30.222 -26.220   7.875  1.00 49.81           C  
ATOM    987  CD1 PHE   138      29.654 -27.076   6.745  1.00 51.49           C  
ATOM    988  CD2 PHE   138      30.384 -26.741   9.264  1.00 51.50           C  
ATOM    989  CE1 PHE   138      29.370 -28.414   7.051  1.00 51.29           C  
ATOM    990  CE2 PHE   138      30.105 -28.080   9.579  1.00 50.91           C  
ATOM    991  CZ  PHE   138      29.521 -28.922   8.458  1.00 51.61           C  
ATOM    992  N   LYS   139      28.144 -24.002   9.701  1.00 48.30           N  
ATOM    993  CA  LYS   139      27.051 -24.305  10.665  1.00 47.27           C  
ATOM    994  C   LYS   139      26.547 -23.108  11.510  1.00 45.92           C  
ATOM    995  O   LYS   139      27.349 -22.313  11.982  1.00 44.08           O  
ATOM    996  CB  LYS   139      27.496 -25.468  11.566  1.00 47.34           C  
ATOM    997  CG  LYS   139      26.480 -25.899  12.624  1.00 48.98           C  
ATOM    998  CD  LYS   139      27.075 -27.027  13.507  1.00 49.64           C  
ATOM    999  CE  LYS   139      26.266 -27.148  14.818  1.00 54.05           C  
ATOM   1000  NZ  LYS   139      26.806 -28.256  15.668  1.00 56.44           N  
ATOM   1001  N   CYS   140      25.210 -22.982  11.655  1.00 45.92           N  
ATOM   1002  CA  CYS   140      24.511 -22.004  12.540  1.00 46.22           C  
ATOM   1003  C   CYS   140      23.654 -22.698  13.584  1.00 45.35           C  
ATOM   1004  O   CYS   140      23.116 -23.767  13.310  1.00 46.60           O  
ATOM   1005  CB  CYS   140      23.596 -21.043  11.775  1.00 45.85           C  
ATOM   1006  SG  CYS   140      24.500 -20.055  10.567  1.00 48.91           S  
ATOM   1007  N   ASP   141      23.543 -22.117  14.776  1.00 44.08           N  
ATOM   1008  CA  ASP   141      22.661 -22.691  15.792  1.00 44.62           C  
ATOM   1009  C   ASP   141      21.209 -22.781  15.266  1.00 44.81           C  
ATOM   1010  O   ASP   141      20.514 -23.715  15.642  1.00 45.32           O  
ATOM   1011  CB  ASP   141      22.668 -21.877  17.082  1.00 44.12           C  
ATOM   1012  CG  ASP   141      23.859 -22.159  17.927  1.00 46.44           C  
ATOM   1013  OD1 ASP   141      24.743 -22.891  17.458  1.00 44.54           O  
ATOM   1014  OD2 ASP   141      23.923 -21.655  19.069  1.00 46.27           O  
ATOM   1015  N   SER   142      20.778 -21.871  14.383  1.00 43.14           N  
ATOM   1016  CA  SER   142      19.386 -21.945  13.855  1.00 44.31           C  
ATOM   1017  C   SER   142      19.056 -23.136  12.964  1.00 44.24           C  
ATOM   1018  O   SER   142      17.855 -23.430  12.753  1.00 44.10           O  
ATOM   1019  CB  SER   142      18.968 -20.672  13.109  1.00 42.51           C  
ATOM   1020  OG  SER   142      19.724 -20.520  11.920  1.00 44.57           O  
ATOM   1021  N   ASP   143      20.096 -23.789  12.422  1.00 45.06           N  
ATOM   1022  CA  ASP   143      19.920 -24.950  11.547  1.00 45.46           C  
ATOM   1023  C   ASP   143      19.147 -26.078  12.227  1.00 46.54           C  
ATOM   1024  O   ASP   143      18.376 -26.748  11.569  1.00 46.75           O  
ATOM   1025  CB  ASP   143      21.271 -25.513  11.043  1.00 45.66           C  
ATOM   1026  CG  ASP   143      22.036 -24.532  10.155  1.00 44.83           C  
ATOM   1027  OD1 ASP   143      21.419 -23.599   9.598  1.00 42.43           O  
ATOM   1028  OD2 ASP   143      23.265 -24.707  10.002  1.00 42.61           O  
ATOM   1029  N   TYR   144      19.381 -26.312  13.524  1.00 47.69           N  
ATOM   1030  CA  TYR   144      18.623 -27.347  14.256  1.00 48.61           C  
ATOM   1031  C   TYR   144      17.099 -27.159  14.128  1.00 48.69           C  
ATOM   1032  O   TYR   144      16.365 -28.135  13.991  1.00 47.78           O  
ATOM   1033  CB  TYR   144      18.997 -27.374  15.736  1.00 49.29           C  
ATOM   1034  CG  TYR   144      18.236 -28.431  16.549  1.00 50.70           C  
ATOM   1035  CD1 TYR   144      18.607 -29.785  16.506  1.00 52.62           C  
ATOM   1036  CD2 TYR   144      17.137 -28.072  17.355  1.00 50.86           C  
ATOM   1037  CE1 TYR   144      17.910 -30.757  17.256  1.00 53.14           C  
ATOM   1038  CE2 TYR   144      16.437 -29.036  18.096  1.00 50.65           C  
ATOM   1039  CZ  TYR   144      16.825 -30.359  18.054  1.00 51.92           C  
ATOM   1040  OH  TYR   144      16.129 -31.298  18.797  1.00 51.39           O  
ATOM   1041  N   TYR   145      16.644 -25.905  14.171  1.00 48.97           N  
ATOM   1042  CA  TYR   145      15.207 -25.585  14.134  1.00 49.21           C  
ATOM   1043  C   TYR   145      14.692 -25.435  12.713  1.00 49.99           C  
ATOM   1044  O   TYR   145      13.494 -25.243  12.506  1.00 50.05           O  
ATOM   1045  CB  TYR   145      14.899 -24.356  15.003  1.00 50.10           C  
ATOM   1046  CG  TYR   145      15.084 -24.675  16.463  1.00 49.20           C  
ATOM   1047  CD1 TYR   145      14.246 -25.591  17.080  1.00 50.84           C  
ATOM   1048  CD2 TYR   145      16.103 -24.109  17.212  1.00 45.52           C  
ATOM   1049  CE1 TYR   145      14.402 -25.937  18.406  1.00 51.72           C  
ATOM   1050  CE2 TYR   145      16.267 -24.456  18.567  1.00 47.36           C  
ATOM   1051  CZ  TYR   145      15.403 -25.363  19.144  1.00 50.04           C  
ATOM   1052  OH  TYR   145      15.524 -25.798  20.451  1.00 53.65           O  
ATOM   1053  N   ALA   146      15.602 -25.555  11.741  1.00 49.88           N  
ATOM   1054  CA  ALA   146      15.292 -25.302  10.345  1.00 50.90           C  
ATOM   1055  C   ALA   146      14.972 -26.581   9.602  1.00 52.22           C  
ATOM   1056  O   ALA   146      14.408 -26.522   8.507  1.00 52.25           O  
ATOM   1057  CB  ALA   146      16.440 -24.593   9.653  1.00 50.05           C  
ATOM   1058  N   THR   147      15.340 -27.724  10.190  1.00 53.87           N  
ATOM   1059  CA  THR   147      15.284 -29.020   9.494  1.00 54.91           C  
ATOM   1060  C   THR   147      14.885 -30.235  10.356  1.00 55.97           C  
ATOM   1061  O   THR   147      15.363 -30.403  11.483  1.00 55.90           O  
ATOM   1062  CB  THR   147      16.649 -29.340   8.805  1.00 55.15           C  
ATOM   1063  OG1 THR   147      17.733 -29.043   9.703  1.00 54.95           O  
ATOM   1064  CG2 THR   147      16.822 -28.514   7.524  1.00 55.67           C  
ATOM   1065  N   GLY   148      14.020 -31.085   9.788  1.00 57.03           N  
ATOM   1066  CA  GLY   148      13.682 -32.405  10.340  1.00 58.17           C  
ATOM   1067  C   GLY   148      12.993 -32.442  11.697  1.00 59.08           C  
ATOM   1068  O   GLY   148      12.159 -31.584  12.016  1.00 59.21           O  
ATOM   1069  N   GLU   149      13.354 -33.452  12.490  1.00 59.79           N  
ATOM   1070  CA  GLU   149      12.780 -33.700  13.825  1.00 60.24           C  
ATOM   1071  C   GLU   149      13.243 -32.700  14.895  1.00 60.72           C  
ATOM   1072  O   GLU   149      14.424 -32.708  15.283  1.00 61.14           O  
ATOM   1073  CB  GLU   149      13.135 -35.121  14.287  1.00 60.50           C  
ATOM   1074  CG  GLU   149      12.122 -36.220  13.932  1.00 60.05           C  
ATOM   1075  CD  GLU   149      11.038 -36.365  14.988  1.00 59.99           C  
ATOM   1076  OE1 GLU   149      10.594 -37.506  15.238  1.00 58.25           O  
ATOM   1077  OE2 GLU   149      10.638 -35.330  15.575  1.00 60.64           O  
ATOM   1078  N   PHE   150      12.312 -31.853  15.361  1.00 60.39           N  
ATOM   1079  CA  PHE   150      12.536 -30.943  16.513  1.00 60.35           C  
ATOM   1080  C   PHE   150      11.287 -30.683  17.391  1.00 59.56           C  
ATOM   1081  O   PHE   150      10.146 -30.940  16.985  1.00 59.84           O  
ATOM   1082  CB  PHE   150      13.215 -29.610  16.101  1.00 60.16           C  
ATOM   1083  CG  PHE   150      12.466 -28.833  15.057  1.00 61.05           C  
ATOM   1084  CD1 PHE   150      11.587 -27.820  15.425  1.00 62.70           C  
ATOM   1085  CD2 PHE   150      12.659 -29.093  13.697  1.00 62.07           C  
ATOM   1086  CE1 PHE   150      10.890 -27.086  14.451  1.00 62.87           C  
ATOM   1087  CE2 PHE   150      11.957 -28.387  12.708  1.00 63.06           C  
ATOM   1088  CZ  PHE   150      11.069 -27.377  13.087  1.00 63.13           C  
ATOM   1089  N   LYS   151      11.531 -30.222  18.613  1.00 58.08           N  
ATOM   1090  CA  LYS   151      10.482 -29.702  19.473  1.00 56.42           C  
ATOM   1091  C   LYS   151      10.831 -28.252  19.769  1.00 55.24           C  
ATOM   1092  O   LYS   151      12.015 -27.902  19.798  1.00 54.83           O  
ATOM   1093  CB  LYS   151      10.362 -30.540  20.750  1.00 57.09           C  
ATOM   1094  CG  LYS   151       9.370 -31.678  20.611  1.00 56.58           C  
ATOM   1095  CD  LYS   151       8.705 -31.985  21.949  1.00 59.54           C  
ATOM   1096  CE  LYS   151       7.414 -32.786  21.781  1.00 59.45           C  
ATOM   1097  NZ  LYS   151       6.864 -33.245  23.089  1.00 61.73           N  
ATOM   1098  N   VAL   152       9.824 -27.397  19.929  1.00 53.60           N  
ATOM   1099  CA  VAL   152      10.101 -25.999  20.303  1.00 53.08           C  
ATOM   1100  C   VAL   152       9.768 -25.697  21.790  1.00 52.22           C  
ATOM   1101  O   VAL   152       8.860 -26.281  22.367  1.00 51.30           O  
ATOM   1102  CB  VAL   152       9.599 -24.922  19.235  1.00 52.74           C  
ATOM   1103  CG1 VAL   152      10.068 -25.286  17.829  1.00 52.40           C  
ATOM   1104  CG2 VAL   152       8.128 -24.765  19.228  1.00 52.79           C  
ATOM   1105  N   ILE   153      10.568 -24.835  22.417  1.00 52.29           N  
ATOM   1106  CA  ILE   153      10.422 -24.558  23.848  1.00 52.31           C  
ATOM   1107  C   ILE   153      10.173 -23.064  24.121  1.00 51.77           C  
ATOM   1108  O   ILE   153      10.922 -22.204  23.637  1.00 51.74           O  
ATOM   1109  CB  ILE   153      11.666 -24.997  24.592  1.00 52.99           C  
ATOM   1110  CG1 ILE   153      11.771 -26.531  24.594  1.00 52.49           C  
ATOM   1111  CG2 ILE   153      11.651 -24.415  26.010  1.00 55.15           C  
ATOM   1112  CD1 ILE   153      13.034 -27.088  25.334  1.00 53.41           C  
ATOM   1113  N   GLN   154       9.086 -22.744  24.829  1.00 50.54           N  
ATOM   1114  CA  GLN   154       8.852 -21.355  25.219  1.00 49.09           C  
ATOM   1115  C   GLN   154       9.033 -21.316  26.726  1.00 48.53           C  
ATOM   1116  O   GLN   154       8.355 -22.092  27.425  1.00 47.25           O  
ATOM   1117  CB  GLN   154       7.471 -20.847  24.760  1.00 48.43           C  
ATOM   1118  CG  GLN   154       7.220 -19.364  25.065  1.00 49.16           C  
ATOM   1119  CD  GLN   154       5.802 -18.889  24.709  1.00 50.58           C  
ATOM   1120  OE1 GLN   154       4.958 -19.678  24.258  1.00 53.72           O  
ATOM   1121  NE2 GLN   154       5.535 -17.587  24.925  1.00 50.75           N  
END
