
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  107 (  794),  selected  107 , name 2de7_E
# Molecule2: number of CA atoms  136 ( 1099),  selected  136 , name T0391.pdb
# PARAMETERS: 2de7_E.T0391.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Q     3_E      K      14          4.491
LGA    -       -      Y      15           -
LGA    I     4_E      T      16          0.886
LGA    W     5_E      S      17          0.925
LGA    L     6_E      V      18          1.387
LGA    K     7_E      C      19          0.985
LGA    V     8_E      V      20          1.120
LGA    C     9_E      G      21          1.236
LGA    A    10_E      R      22          1.149
LGA    A    11_E      E      23          1.139
LGA    S    12_E      E      24          1.022
LGA    D    13_E      D      25          0.895
LGA    M    14_E      I      26          1.554
LGA    Q    15_E      R      27          2.548
LGA    P    16_E      K      28           #
LGA    G    17_E      S      29           #
LGA    T    18_E      E      30          2.324
LGA    I    19_E      R      31          2.094
LGA    R    20_E      M      32          1.570
LGA    R    21_E      T      33          1.647
LGA    V    22_E      A      34          1.653
LGA    N    23_E      V      35          2.618
LGA    R    24_E      V      36          3.966
LGA    V    25_E      H      37           #
LGA    G    26_E      D      38          3.479
LGA    A    27_E      R      39          3.096
LGA    A    28_E      -       -           -
LGA    P    29_E      E      40          1.604
LGA    L    30_E      V      41          1.083
LGA    A    31_E      V      42          1.312
LGA    V    32_E      I      43          0.715
LGA    Y    33_E      F      44          0.884
LGA    R    34_E      Y      45          0.627
LGA    V    35_E      H      46          1.257
LGA    G    36_E      K      47          2.035
LGA    D    37_E      G      48          1.749
LGA    Q    38_E      E      49          1.247
LGA    F    39_E      Y      50          0.556
LGA    Y    40_E      H      51          1.092
LGA    A    41_E      A      52          1.023
LGA    T    42_E      M      53          1.172
LGA    E    43_E      D      54          1.062
LGA    D    44_E      I      55          1.102
LGA    T    45_E      R      56          1.209
LGA    C    46_E      C      57          0.887
LGA    T    47_E      Y      58          0.940
LGA    H    48_E      H      59          0.727
LGA    G    49_E      S      60          0.958
LGA    I    50_E      G      61          1.014
LGA    A    51_E      G      62          0.306
LGA    S    52_E      P      63          1.320
LGA    L    53_E      L      64          0.525
LGA    S    54_E      H      65          0.595
LGA    E    55_E      L      66          0.904
LGA    G    56_E      G      67          0.562
LGA    T    57_E      E      68          0.585
LGA    L    58_E      I      69          1.264
LGA    D    59_E      E      70          1.838
LGA    G    60_E      D      71          5.027
LGA    -       -      F      72           -
LGA    -       -      N      73           -
LGA    -       -      G      74           -
LGA    -       -      Q      75           -
LGA    D    61_E      S      76          2.058
LGA    V    62_E      C      77          1.044
LGA    I    63_E      I      78          0.490
LGA    E    64_E      V      79          0.350
LGA    C    65_E      C      80          0.337
LGA    P    66_E      P      81          0.325
LGA    F    67_E      W      82          0.353
LGA    H    68_E      H      83          0.559
LGA    G    69_E      K      84          0.699
LGA    G    70_E      Y      85          0.609
LGA    A    71_E      K      86          0.836
LGA    F    72_E      I      87          0.831
LGA    N    73_E      T      88          0.862
LGA    V    74_E      L      89          0.441
LGA    C    75_E      A      90          0.580
LGA    T    76_E      T      91          1.283
LGA    G    77_E      G      92          1.197
LGA    M    78_E      E      93          1.045
LGA    P    79_E      G      94          1.309
LGA    A    80_E      L      95          2.177
LGA    S    81_E      Y      96          3.666
LGA    S    82_E      Q      97          7.216
LGA    P    83_E      S      98           -
LGA    C    84_E      I      99           -
LGA    -       -      N     100           -
LGA    -       -      P     101           -
LGA    -       -      K     107           -
LGA    -       -      P     108           -
LGA    -       -      K     109           -
LGA    -       -      W     110           -
LGA    -       -      C     111           -
LGA    T    85_E      S     112          6.728
LGA    V    86_E      K     113          5.917
LGA    -       -      G     114           -
LGA    -       -      V     115           -
LGA    P    87_E      K     116          1.746
LGA    L    88_E      Q     117          1.091
LGA    G    89_E      R     118          1.001
LGA    V    90_E      I     119          1.003
LGA    F    91_E      H     120          0.617
LGA    E    92_E      T     121          0.929
LGA    V    93_E      V     122          0.371
LGA    E    94_E      K     123          0.225
LGA    V    95_E      V     124          0.464
LGA    K    96_E      D     125          1.119
LGA    E    97_E      N     126          0.607
LGA    G    98_E      G     127          0.666
LGA    E    99_E      N     128          0.380
LGA    V   100_E      I     129          0.509
LGA    Y   101_E      Y     130          0.660
LGA    V   102_E      V     131          0.950
LGA    A   103_E      T     132          0.762
LGA    G   104_E      L     133          2.425
LGA    E   105_E      S     134          2.953
LGA    K   106_E      -       -           -
LGA    K   107_E      K     135          4.602
LGA    L   108_E      E     136          1.291
LGA    E   109_E      P     137           #
LGA    -       -      F     138           -
LGA    -       -      K     139           -
LGA    -       -      C     140           -
LGA    -       -      D     141           -
LGA    -       -      S     142           -
LGA    -       -      D     143           -
LGA    -       -      Y     144           -
LGA    -       -      Y     145           -
LGA    -       -      A     146           -
LGA    -       -      T     147           -
LGA    -       -      G     148           -
LGA    -       -      E     149           -
LGA    -       -      F     150           -
LGA    -       -      K     151           -
LGA    -       -      V     152           -
LGA    -       -      I     153           -
LGA    -       -      Q     154           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  107  136    5.0     99    1.97    19.19     65.065     4.794

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.419388 * X  +   0.560907 * Y  +   0.713791 * Z  +   5.337760
  Y_new =   0.128983 * X  +  -0.741486 * Y  +   0.658454 * Z  + -32.367348
  Z_new =   0.898597 * X  +   0.368214 * Y  +   0.238623 * Z  +  35.644527 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.995790   -2.145803  [ DEG:    57.0545   -122.9455 ]
  Theta =  -1.116562   -2.025030  [ DEG:   -63.9743   -116.0257 ]
  Phi   =   2.843224   -0.298368  [ DEG:   162.9048    -17.0952 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2de7_E                                        
REMARK     2: T0391.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2de7_E.T0391.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  107  136   5.0   99   1.97   19.19  65.065
REMARK  ---------------------------------------------------------- 
MOLECULE 2de7_E
HEADER    OXIDOREDUCTASE                          08-FEB-06   2DE7              
TITLE     THE SUBSTRATE-BOUND COMPLEX BETWEEN OXYGENASE AND                     
TITLE    2 FERREDOXIN IN CARBAZOLE 1,9A-DIOXYGENASE                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TERMINAL OXYGENASE COMPONENT OF CARBAZOLE;                 
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: TERMINAL OXYGENASE COMPONENT OF CARBAZOLE 1,9A-             
COMPND   5 DIOXYGENASE;                                                         
COMPND   6 EC: 1.14.12.-;                                                       
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: FERREDOXIN COMPONENT OF CARBAZOLE;                         
COMPND  10 CHAIN: D, E, F;                                                      
COMPND  11 SYNONYM: FERREDOXIN COMPONENT OF CARBAZOLE 1,9A-                     
COMPND  12 DIOXYGENASE;                                                         
COMPND  13 EC: 1.14.12.-;                                                       
COMPND  14 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: JANTHINOBACTERIUM;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: J3;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PEJ3AAC;                                  
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: PSEUDOMONAS RESINOVORANS;                       
SOURCE  12 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  13 STRAIN: CA10;                                                        
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PECAC1                                    
KEYWDS    ELECTRON TRANSFER COMPLEX, RIESKE NON-HEME IRON OXYGENASE             
KEYWDS   2 SYSTEM, TERMINAL OXYGENASE, RIESKE-TYPE FERREDOXIN,                  
KEYWDS   3 CARBAZOLE 1,9A-DIOXYGENASE                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.ASHIKAWA,H.NOJIRI                                                   
REVDAT   2   16-JAN-07 2DE7    1       JRNL                                     
REVDAT   1   05-DEC-06 2DE7    0                                                
JRNL        AUTH   Y.ASHIKAWA,Z.FUJIMOTO,H.NOGUCHI,H.HABE,T.OMORI,              
JRNL        AUTH 2 H.YAMANE,H.NOJIRI                                            
JRNL        TITL   ELECTRON TRANSFER COMPLEX FORMATION BETWEEN                  
JRNL        TITL 2 OXYGENASE AND FERREDOXIN COMPONENTS IN RIESKE                
JRNL        TITL 3 NONHEME IRON OXYGENASE SYSTEM                                
JRNL        REF    STRUCTURE                     V.  14  1779 2006              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2DE7 A    1   384  GB     28201207 BAC56742         1    384             
DBREF  2DE7 B    1   384  GB     28201207 BAC56742         1    384             
DBREF  2DE7 C    1   384  GB     28201207 BAC56742         1    384             
DBREF  2DE7 D    1   107  GB     27228521 NP_758571        1    107             
DBREF  2DE7 E    1   107  GB     27228521 NP_758571        1    107             
DBREF  2DE7 F    1   107  GB     27228521 NP_758571        1    107             
SEQRES   1 A  392  MET ALA ASN VAL ASP GLU ALA ILE LEU LYS ARG VAL LYS          
SEQRES   2 A  392  GLY TRP ALA PRO TYR VAL ASP ALA LYS LEU GLY PHE ARG          
SEQRES   3 A  392  ASN HIS TRP TYR PRO VAL MET PHE SER LYS GLU ILE ASN          
SEQRES   4 A  392  GLU GLY GLU PRO LYS THR LEU LYS LEU LEU GLY GLU ASN          
SEQRES   5 A  392  LEU LEU VAL ASN ARG ILE ASP GLY LYS LEU TYR CYS LEU          
SEQRES   6 A  392  LYS ASP ARG CYS LEU HIS ARG GLY VAL GLN LEU SER VAL          
SEQRES   7 A  392  LYS VAL GLU CYS LYS THR LYS SER THR ILE THR CYS TRP          
SEQRES   8 A  392  TYR HIS ALA TRP THR TYR ARG TRP GLU ASP GLY VAL LEU          
SEQRES   9 A  392  CYS ASP ILE LEU THR ASN PRO THR SER ALA GLN ILE GLY          
SEQRES  10 A  392  ARG GLN LYS LEU LYS THR TYR PRO VAL GLN GLU ALA LYS          
SEQRES  11 A  392  GLY CYS VAL PHE ILE TYR LEU GLY ASP GLY ASP PRO PRO          
SEQRES  12 A  392  PRO LEU ALA ARG ASP THR PRO PRO ASN PHE LEU ASP ASP          
SEQRES  13 A  392  ASP MET GLU ILE LEU GLY LYS ASN GLN ILE ILE LYS SER          
SEQRES  14 A  392  ASN TRP ARG LEU ALA VAL GLU ASN GLY PHE ASP PRO SER          
SEQRES  15 A  392  HIS ILE TYR ILE HIS LYS ASP SER ILE LEU VAL LYS ASP          
SEQRES  16 A  392  ASN ASP LEU ALA LEU PRO LEU GLY PHE ALA PRO GLY GLY          
SEQRES  17 A  392  ASP ARG LYS GLN GLN THR ARG VAL VAL ASP ASP ASP VAL          
SEQRES  18 A  392  VAL GLY ARG LYS GLY VAL TYR ASP LEU ILE GLY GLU HIS          
SEQRES  19 A  392  GLY VAL PRO VAL PHE GLU GLY THR ILE GLY GLY GLU VAL          
SEQRES  20 A  392  VAL ARG GLU GLY ALA TYR GLY GLU LYS ILE VAL ALA ASN          
SEQRES  21 A  392  ASP ILE SER ILE TRP LEU PRO GLY VAL LEU LYS VAL ASN          
SEQRES  22 A  392  PRO PHE PRO ASN PRO ASP MET MET GLN PHE GLU TRP TYR          
SEQRES  23 A  392  VAL PRO ILE ASP GLU ASN THR HIS TYR TYR PHE GLN THR          
SEQRES  24 A  392  LEU GLY LYS PRO CYS ALA ASN ASP GLU GLU ARG LYS LYS          
SEQRES  25 A  392  TYR GLU GLN GLU PHE GLU SER LYS TRP LYS PRO MET ALA          
SEQRES  26 A  392  LEU GLU GLY PHE ASN ASN ASP ASP ILE TRP ALA ARG GLU          
SEQRES  27 A  392  ALA MET VAL ASP PHE TYR ALA ASP ASP LYS GLY TRP VAL          
SEQRES  28 A  392  ASN GLU ILE LEU PHE GLU SER ASP GLU ALA ILE VAL ALA          
SEQRES  29 A  392  TRP ARG LYS LEU ALA SER GLU HIS ASN GLN GLY ILE GLN          
SEQRES  30 A  392  THR GLN ALA HIS VAL SER GLY LEU GLU HIS HIS HIS HIS          
SEQRES  31 A  392  HIS HIS                                                      
SEQRES   1 B  392  MET ALA ASN VAL ASP GLU ALA ILE LEU LYS ARG VAL LYS          
SEQRES   2 B  392  GLY TRP ALA PRO TYR VAL ASP ALA LYS LEU GLY PHE ARG          
SEQRES   3 B  392  ASN HIS TRP TYR PRO VAL MET PHE SER LYS GLU ILE ASN          
SEQRES   4 B  392  GLU GLY GLU PRO LYS THR LEU LYS LEU LEU GLY GLU ASN          
SEQRES   5 B  392  LEU LEU VAL ASN ARG ILE ASP GLY LYS LEU TYR CYS LEU          
SEQRES   6 B  392  LYS ASP ARG CYS LEU HIS ARG GLY VAL GLN LEU SER VAL          
SEQRES   7 B  392  LYS VAL GLU CYS LYS THR LYS SER THR ILE THR CYS TRP          
SEQRES   8 B  392  TYR HIS ALA TRP THR TYR ARG TRP GLU ASP GLY VAL LEU          
SEQRES   9 B  392  CYS ASP ILE LEU THR ASN PRO THR SER ALA GLN ILE GLY          
SEQRES  10 B  392  ARG GLN LYS LEU LYS THR TYR PRO VAL GLN GLU ALA LYS          
SEQRES  11 B  392  GLY CYS VAL PHE ILE TYR LEU GLY ASP GLY ASP PRO PRO          
SEQRES  12 B  392  PRO LEU ALA ARG ASP THR PRO PRO ASN PHE LEU ASP ASP          
SEQRES  13 B  392  ASP MET GLU ILE LEU GLY LYS ASN GLN ILE ILE LYS SER          
SEQRES  14 B  392  ASN TRP ARG LEU ALA VAL GLU ASN GLY PHE ASP PRO SER          
SEQRES  15 B  392  HIS ILE TYR ILE HIS LYS ASP SER ILE LEU VAL LYS ASP          
SEQRES  16 B  392  ASN ASP LEU ALA LEU PRO LEU GLY PHE ALA PRO GLY GLY          
SEQRES  17 B  392  ASP ARG LYS GLN GLN THR ARG VAL VAL ASP ASP ASP VAL          
SEQRES  18 B  392  VAL GLY ARG LYS GLY VAL TYR ASP LEU ILE GLY GLU HIS          
SEQRES  19 B  392  GLY VAL PRO VAL PHE GLU GLY THR ILE GLY GLY GLU VAL          
SEQRES  20 B  392  VAL ARG GLU GLY ALA TYR GLY GLU LYS ILE VAL ALA ASN          
SEQRES  21 B  392  ASP ILE SER ILE TRP LEU PRO GLY VAL LEU LYS VAL ASN          
SEQRES  22 B  392  PRO PHE PRO ASN PRO ASP MET MET GLN PHE GLU TRP TYR          
SEQRES  23 B  392  VAL PRO ILE ASP GLU ASN THR HIS TYR TYR PHE GLN THR          
SEQRES  24 B  392  LEU GLY LYS PRO CYS ALA ASN ASP GLU GLU ARG LYS LYS          
SEQRES  25 B  392  TYR GLU GLN GLU PHE GLU SER LYS TRP LYS PRO MET ALA          
SEQRES  26 B  392  LEU GLU GLY PHE ASN ASN ASP ASP ILE TRP ALA ARG GLU          
SEQRES  27 B  392  ALA MET VAL ASP PHE TYR ALA ASP ASP LYS GLY TRP VAL          
SEQRES  28 B  392  ASN GLU ILE LEU PHE GLU SER ASP GLU ALA ILE VAL ALA          
SEQRES  29 B  392  TRP ARG LYS LEU ALA SER GLU HIS ASN GLN GLY ILE GLN          
SEQRES  30 B  392  THR GLN ALA HIS VAL SER GLY LEU GLU HIS HIS HIS HIS          
SEQRES  31 B  392  HIS HIS                                                      
SEQRES   1 C  392  MET ALA ASN VAL ASP GLU ALA ILE LEU LYS ARG VAL LYS          
SEQRES   2 C  392  GLY TRP ALA PRO TYR VAL ASP ALA LYS LEU GLY PHE ARG          
SEQRES   3 C  392  ASN HIS TRP TYR PRO VAL MET PHE SER LYS GLU ILE ASN          
SEQRES   4 C  392  GLU GLY GLU PRO LYS THR LEU LYS LEU LEU GLY GLU ASN          
SEQRES   5 C  392  LEU LEU VAL ASN ARG ILE ASP GLY LYS LEU TYR CYS LEU          
SEQRES   6 C  392  LYS ASP ARG CYS LEU HIS ARG GLY VAL GLN LEU SER VAL          
SEQRES   7 C  392  LYS VAL GLU CYS LYS THR LYS SER THR ILE THR CYS TRP          
SEQRES   8 C  392  TYR HIS ALA TRP THR TYR ARG TRP GLU ASP GLY VAL LEU          
SEQRES   9 C  392  CYS ASP ILE LEU THR ASN PRO THR SER ALA GLN ILE GLY          
SEQRES  10 C  392  ARG GLN LYS LEU LYS THR TYR PRO VAL GLN GLU ALA LYS          
SEQRES  11 C  392  GLY CYS VAL PHE ILE TYR LEU GLY ASP GLY ASP PRO PRO          
SEQRES  12 C  392  PRO LEU ALA ARG ASP THR PRO PRO ASN PHE LEU ASP ASP          
SEQRES  13 C  392  ASP MET GLU ILE LEU GLY LYS ASN GLN ILE ILE LYS SER          
SEQRES  14 C  392  ASN TRP ARG LEU ALA VAL GLU ASN GLY PHE ASP PRO SER          
SEQRES  15 C  392  HIS ILE TYR ILE HIS LYS ASP SER ILE LEU VAL LYS ASP          
SEQRES  16 C  392  ASN ASP LEU ALA LEU PRO LEU GLY PHE ALA PRO GLY GLY          
SEQRES  17 C  392  ASP ARG LYS GLN GLN THR ARG VAL VAL ASP ASP ASP VAL          
SEQRES  18 C  392  VAL GLY ARG LYS GLY VAL TYR ASP LEU ILE GLY GLU HIS          
SEQRES  19 C  392  GLY VAL PRO VAL PHE GLU GLY THR ILE GLY GLY GLU VAL          
SEQRES  20 C  392  VAL ARG GLU GLY ALA TYR GLY GLU LYS ILE VAL ALA ASN          
SEQRES  21 C  392  ASP ILE SER ILE TRP LEU PRO GLY VAL LEU LYS VAL ASN          
SEQRES  22 C  392  PRO PHE PRO ASN PRO ASP MET MET GLN PHE GLU TRP TYR          
SEQRES  23 C  392  VAL PRO ILE ASP GLU ASN THR HIS TYR TYR PHE GLN THR          
SEQRES  24 C  392  LEU GLY LYS PRO CYS ALA ASN ASP GLU GLU ARG LYS LYS          
SEQRES  25 C  392  TYR GLU GLN GLU PHE GLU SER LYS TRP LYS PRO MET ALA          
SEQRES  26 C  392  LEU GLU GLY PHE ASN ASN ASP ASP ILE TRP ALA ARG GLU          
SEQRES  27 C  392  ALA MET VAL ASP PHE TYR ALA ASP ASP LYS GLY TRP VAL          
SEQRES  28 C  392  ASN GLU ILE LEU PHE GLU SER ASP GLU ALA ILE VAL ALA          
SEQRES  29 C  392  TRP ARG LYS LEU ALA SER GLU HIS ASN GLN GLY ILE GLN          
SEQRES  30 C  392  THR GLN ALA HIS VAL SER GLY LEU GLU HIS HIS HIS HIS          
SEQRES  31 C  392  HIS HIS                                                      
SEQRES   1 D  115  MET ASN GLN ILE TRP LEU LYS VAL CYS ALA ALA SER ASP          
SEQRES   2 D  115  MET GLN PRO GLY THR ILE ARG ARG VAL ASN ARG VAL GLY          
SEQRES   3 D  115  ALA ALA PRO LEU ALA VAL TYR ARG VAL GLY ASP GLN PHE          
SEQRES   4 D  115  TYR ALA THR GLU ASP THR CYS THR HIS GLY ILE ALA SER          
SEQRES   5 D  115  LEU SER GLU GLY THR LEU ASP GLY ASP VAL ILE GLU CYS          
SEQRES   6 D  115  PRO PHE HIS GLY GLY ALA PHE ASN VAL CYS THR GLY MET          
SEQRES   7 D  115  PRO ALA SER SER PRO CYS THR VAL PRO LEU GLY VAL PHE          
SEQRES   8 D  115  GLU VAL GLU VAL LYS GLU GLY GLU VAL TYR VAL ALA GLY          
SEQRES   9 D  115  GLU LYS LYS LEU GLU HIS HIS HIS HIS HIS HIS                  
SEQRES   1 E  115  MET ASN GLN ILE TRP LEU LYS VAL CYS ALA ALA SER ASP          
SEQRES   2 E  115  MET GLN PRO GLY THR ILE ARG ARG VAL ASN ARG VAL GLY          
SEQRES   3 E  115  ALA ALA PRO LEU ALA VAL TYR ARG VAL GLY ASP GLN PHE          
SEQRES   4 E  115  TYR ALA THR GLU ASP THR CYS THR HIS GLY ILE ALA SER          
SEQRES   5 E  115  LEU SER GLU GLY THR LEU ASP GLY ASP VAL ILE GLU CYS          
SEQRES   6 E  115  PRO PHE HIS GLY GLY ALA PHE ASN VAL CYS THR GLY MET          
SEQRES   7 E  115  PRO ALA SER SER PRO CYS THR VAL PRO LEU GLY VAL PHE          
SEQRES   8 E  115  GLU VAL GLU VAL LYS GLU GLY GLU VAL TYR VAL ALA GLY          
SEQRES   9 E  115  GLU LYS LYS LEU GLU HIS HIS HIS HIS HIS HIS                  
SEQRES   1 F  115  MET ASN GLN ILE TRP LEU LYS VAL CYS ALA ALA SER ASP          
SEQRES   2 F  115  MET GLN PRO GLY THR ILE ARG ARG VAL ASN ARG VAL GLY          
SEQRES   3 F  115  ALA ALA PRO LEU ALA VAL TYR ARG VAL GLY ASP GLN PHE          
SEQRES   4 F  115  TYR ALA THR GLU ASP THR CYS THR HIS GLY ILE ALA SER          
SEQRES   5 F  115  LEU SER GLU GLY THR LEU ASP GLY ASP VAL ILE GLU CYS          
SEQRES   6 F  115  PRO PHE HIS GLY GLY ALA PHE ASN VAL CYS THR GLY MET          
SEQRES   7 F  115  PRO ALA SER SER PRO CYS THR VAL PRO LEU GLY VAL PHE          
SEQRES   8 F  115  GLU VAL GLU VAL LYS GLU GLY GLU VAL TYR VAL ALA GLY          
SEQRES   9 F  115  GLU LYS LYS LEU GLU HIS HIS HIS HIS HIS HIS                  
HET    FE2  A 501       1                                                       
HET    FE2  B 501       1                                                       
HET    FE2  C 501       1                                                       
HET    FES  A 401       4                                                       
HET    FES  B 401       4                                                       
HET    FES  C 401       4                                                       
HET    FES  D 201       4                                                       
HET    FES  E 201       4                                                       
HET    FES  F 201       4                                                       
HET    9CA   2001      13                                                       
HET    9CA   2002      13                                                       
HETNAM     FE2 FE (II) ION                                                      
HETNAM     FES FE2/S2 (INORGANIC) CLUSTER                                       
HETNAM     9CA 9H-CARBAZOLE                                                     
FORMUL   7  FE2    3(FE 2+)                                                     
FORMUL  10  FES    6(FE2 S2)                                                    
FORMUL  16  9CA    2(C12 H9 N)                                                  
FORMUL  18  HOH   *978(H2 O)                                                    
CRYST1   97.862   89.403  104.665  90.00 104.18  90.00 P 1 21 1      6          
ATOM  10179  N   GLN E   3      16.119 -23.750  -7.680  1.00 43.77           N  
ATOM  10180  CA  GLN E   3      15.863 -23.443  -6.245  1.00 43.50           C  
ATOM  10181  C   GLN E   3      16.837 -22.388  -5.732  1.00 42.28           C  
ATOM  10182  O   GLN E   3      16.701 -21.906  -4.608  1.00 43.14           O  
ATOM  10183  CB  GLN E   3      15.999 -24.716  -5.404  1.00 44.59           C  
ATOM  10184  CG  GLN E   3      15.124 -25.866  -5.877  1.00 46.30           C  
ATOM  10185  CD  GLN E   3      15.270 -27.109  -5.016  1.00 48.38           C  
ATOM  10186  OE1 GLN E   3      14.788 -28.187  -5.375  1.00 48.99           O  
ATOM  10187  NE2 GLN E   3      15.931 -26.963  -3.867  1.00 48.31           N  
ATOM  10188  N   ILE E   4      17.815 -22.033  -6.561  1.00 40.99           N  
ATOM  10189  CA  ILE E   4      18.826 -21.042  -6.203  1.00 38.37           C  
ATOM  10190  C   ILE E   4      18.221 -19.796  -5.549  1.00 37.02           C  
ATOM  10191  O   ILE E   4      18.603 -19.426  -4.439  1.00 36.09           O  
ATOM  10192  CB  ILE E   4      19.648 -20.623  -7.447  1.00 39.45           C  
ATOM  10193  CG1 ILE E   4      20.756 -19.663  -7.029  1.00 38.71           C  
ATOM  10194  CG2 ILE E   4      18.740 -19.999  -8.498  1.00 40.50           C  
ATOM  10195  CD1 ILE E   4      21.766 -20.296  -6.097  1.00 40.78           C  
ATOM  10196  N   TRP E   5      17.294 -19.143  -6.242  1.00 35.01           N  
ATOM  10197  CA  TRP E   5      16.632 -17.964  -5.694  1.00 34.49           C  
ATOM  10198  C   TRP E   5      15.155 -18.305  -5.524  1.00 35.50           C  
ATOM  10199  O   TRP E   5      14.543 -18.896  -6.414  1.00 36.33           O  
ATOM  10200  CB  TRP E   5      16.776 -16.748  -6.624  1.00 32.87           C  
ATOM  10201  CG  TRP E   5      18.181 -16.220  -6.764  1.00 31.34           C  
ATOM  10202  CD1 TRP E   5      19.066 -16.504  -7.767  1.00 31.42           C  
ATOM  10203  CD2 TRP E   5      18.864 -15.327  -5.868  1.00 30.20           C  
ATOM  10204  NE1 TRP E   5      20.253 -15.843  -7.554  1.00 30.77           N  
ATOM  10205  CE2 TRP E   5      20.157 -15.113  -6.398  1.00 30.24           C  
ATOM  10206  CE3 TRP E   5      18.507 -14.687  -4.673  1.00 30.74           C  
ATOM  10207  CZ2 TRP E   5      21.100 -14.284  -5.772  1.00 30.25           C  
ATOM  10208  CZ3 TRP E   5      19.446 -13.861  -4.047  1.00 31.17           C  
ATOM  10209  CH2 TRP E   5      20.727 -13.668  -4.602  1.00 30.77           C  
ATOM  10210  N   LEU E   6      14.596 -17.945  -4.373  1.00 35.71           N  
ATOM  10211  CA  LEU E   6      13.190 -18.204  -4.070  1.00 36.30           C  
ATOM  10212  C   LEU E   6      12.384 -16.923  -4.227  1.00 36.21           C  
ATOM  10213  O   LEU E   6      12.748 -15.884  -3.685  1.00 35.36           O  
ATOM  10214  CB  LEU E   6      13.040 -18.714  -2.634  1.00 36.04           C  
ATOM  10215  CG  LEU E   6      12.705 -20.189  -2.399  1.00 36.61           C  
ATOM  10216  CD1 LEU E   6      11.324 -20.493  -2.976  1.00 36.44           C  
ATOM  10217  CD2 LEU E   6      13.771 -21.069  -3.033  1.00 35.40           C  
ATOM  10218  N   LYS E   7      11.291 -16.993  -4.977  1.00 37.98           N  
ATOM  10219  CA  LYS E   7      10.452 -15.822  -5.168  1.00 38.47           C  
ATOM  10220  C   LYS E   7       9.666 -15.630  -3.879  1.00 38.55           C  
ATOM  10221  O   LYS E   7       8.963 -16.536  -3.433  1.00 38.27           O  
ATOM  10222  CB  LYS E   7       9.495 -16.036  -6.349  1.00 40.02           C  
ATOM  10223  CG  LYS E   7       8.714 -14.787  -6.756  1.00 42.20           C  
ATOM  10224  CD  LYS E   7       7.896 -15.018  -8.031  1.00 43.08           C  
ATOM  10225  CE  LYS E   7       6.856 -16.122  -7.845  1.00 43.72           C  
ATOM  10226  NZ  LYS E   7       6.057 -16.369  -9.087  1.00 44.46           N  
ATOM  10227  N   VAL E   8       9.801 -14.454  -3.274  1.00 38.14           N  
ATOM  10228  CA  VAL E   8       9.103 -14.164  -2.032  1.00 38.21           C  
ATOM  10229  C   VAL E   8       7.828 -13.376  -2.303  1.00 39.54           C  
ATOM  10230  O   VAL E   8       6.722 -13.871  -2.078  1.00 39.57           O  
ATOM  10231  CB  VAL E   8       9.991 -13.351  -1.071  1.00 36.97           C  
ATOM  10232  CG1 VAL E   8       9.270 -13.140   0.255  1.00 37.76           C  
ATOM  10233  CG2 VAL E   8      11.310 -14.077  -0.850  1.00 35.59           C  
ATOM  10234  N   CYS E   9       7.992 -12.151  -2.793  1.00 40.25           N  
ATOM  10235  CA  CYS E   9       6.861 -11.280  -3.092  1.00 41.32           C  
ATOM  10236  C   CYS E   9       7.358 -10.024  -3.799  1.00 41.64           C  
ATOM  10237  O   CYS E   9       8.552  -9.877  -4.058  1.00 41.78           O  
ATOM  10238  CB  CYS E   9       6.163 -10.875  -1.797  1.00 42.00           C  
ATOM  10239  SG  CYS E   9       7.222  -9.892  -0.703  1.00 43.67           S  
ATOM  10240  N   ALA E  10       6.437  -9.119  -4.111  1.00 41.43           N  
ATOM  10241  CA  ALA E  10       6.803  -7.870  -4.760  1.00 41.68           C  
ATOM  10242  C   ALA E  10       7.347  -6.962  -3.671  1.00 41.46           C  
ATOM  10243  O   ALA E  10       6.832  -6.956  -2.553  1.00 41.89           O  
ATOM  10244  CB  ALA E  10       5.580  -7.230  -5.416  1.00 41.26           C  
ATOM  10245  N   ALA E  11       8.390  -6.203  -3.990  1.00 40.89           N  
ATOM  10246  CA  ALA E  11       8.980  -5.294  -3.015  1.00 41.41           C  
ATOM  10247  C   ALA E  11       7.892  -4.381  -2.474  1.00 42.62           C  
ATOM  10248  O   ALA E  11       8.046  -3.765  -1.418  1.00 44.06           O  
ATOM  10249  CB  ALA E  11      10.081  -4.468  -3.666  1.00 41.14           C  
ATOM  10250  N   SER E  12       6.786  -4.311  -3.209  1.00 43.49           N  
ATOM  10251  CA  SER E  12       5.643  -3.479  -2.845  1.00 43.67           C  
ATOM  10252  C   SER E  12       4.791  -4.068  -1.727  1.00 43.41           C  
ATOM  10253  O   SER E  12       4.157  -3.334  -0.967  1.00 43.19           O  
ATOM  10254  CB  SER E  12       4.763  -3.246  -4.074  1.00 43.60           C  
ATOM  10255  OG  SER E  12       3.490  -2.755  -3.690  1.00 44.76           O  
ATOM  10256  N   ASP E  13       4.770  -5.391  -1.635  1.00 43.58           N  
ATOM  10257  CA  ASP E  13       3.981  -6.070  -0.616  1.00 43.92           C  
ATOM  10258  C   ASP E  13       4.538  -5.879   0.793  1.00 43.30           C  
ATOM  10259  O   ASP E  13       3.955  -6.365   1.761  1.00 43.00           O  
ATOM  10260  CB  ASP E  13       3.905  -7.567  -0.925  1.00 46.43           C  
ATOM  10261  CG  ASP E  13       3.315  -7.854  -2.289  1.00 48.95           C  
ATOM  10262  OD1 ASP E  13       2.130  -7.521  -2.506  1.00 51.06           O  
ATOM  10263  OD2 ASP E  13       4.033  -8.415  -3.148  1.00 50.10           O  
ATOM  10264  N   MET E  14       5.659  -5.177   0.915  1.00 42.95           N  
ATOM  10265  CA  MET E  14       6.263  -4.967   2.226  1.00 43.27           C  
ATOM  10266  C   MET E  14       6.571  -3.514   2.555  1.00 43.05           C  
ATOM  10267  O   MET E  14       7.258  -2.825   1.798  1.00 43.33           O  
ATOM  10268  CB  MET E  14       7.557  -5.781   2.356  1.00 43.38           C  
ATOM  10269  CG  MET E  14       7.375  -7.287   2.339  1.00 43.77           C  
ATOM  10270  SD  MET E  14       8.934  -8.134   2.700  1.00 44.22           S  
ATOM  10271  CE  MET E  14       8.833  -8.255   4.499  1.00 44.14           C  
ATOM  10272  N   GLN E  15       6.063  -3.064   3.699  1.00 42.59           N  
ATOM  10273  CA  GLN E  15       6.288  -1.704   4.172  1.00 41.16           C  
ATOM  10274  C   GLN E  15       7.566  -1.697   5.000  1.00 40.76           C  
ATOM  10275  O   GLN E  15       7.949  -2.718   5.573  1.00 41.31           O  
ATOM  10276  CB  GLN E  15       5.120  -1.238   5.051  1.00 42.83           C  
ATOM  10277  CG  GLN E  15       3.838  -0.903   4.301  1.00 42.43           C  
ATOM  10278  CD  GLN E  15       3.992   0.313   3.399  1.00 43.42           C  
ATOM  10279  OE1 GLN E  15       4.305   1.411   3.864  1.00 43.04           O  
ATOM  10280  NE2 GLN E  15       3.769   0.120   2.101  1.00 42.63           N  
ATOM  10281  N   PRO E  16       8.246  -0.545   5.071  1.00 39.91           N  
ATOM  10282  CA  PRO E  16       9.484  -0.447   5.850  1.00 39.61           C  
ATOM  10283  C   PRO E  16       9.262  -0.915   7.285  1.00 40.14           C  
ATOM  10284  O   PRO E  16       8.225  -0.629   7.881  1.00 40.51           O  
ATOM  10285  CB  PRO E  16       9.814   1.041   5.785  1.00 39.07           C  
ATOM  10286  CG  PRO E  16       9.295   1.439   4.437  1.00 39.30           C  
ATOM  10287  CD  PRO E  16       7.961   0.720   4.367  1.00 39.08           C  
ATOM  10288  N   GLY E  17      10.234  -1.640   7.829  1.00 39.73           N  
ATOM  10289  CA  GLY E  17      10.126  -2.112   9.201  1.00 38.55           C  
ATOM  10290  C   GLY E  17       9.210  -3.298   9.433  1.00 37.88           C  
ATOM  10291  O   GLY E  17       8.740  -3.510  10.552  1.00 38.31           O  
ATOM  10292  N   THR E  18       8.945  -4.080   8.394  1.00 37.60           N  
ATOM  10293  CA  THR E  18       8.084  -5.243   8.549  1.00 36.82           C  
ATOM  10294  C   THR E  18       8.876  -6.524   8.339  1.00 36.58           C  
ATOM  10295  O   THR E  18      10.032  -6.485   7.917  1.00 37.07           O  
ATOM  10296  CB  THR E  18       6.901  -5.212   7.562  1.00 37.01           C  
ATOM  10297  OG1 THR E  18       7.396  -5.127   6.220  1.00 37.88           O  
ATOM  10298  CG2 THR E  18       6.005  -4.013   7.848  1.00 36.67           C  
ATOM  10299  N   ILE E  19       8.245  -7.656   8.638  1.00 36.54           N  
ATOM  10300  CA  ILE E  19       8.880  -8.961   8.504  1.00 36.23           C  
ATOM  10301  C   ILE E  19       7.930  -9.940   7.828  1.00 35.47           C  
ATOM  10302  O   ILE E  19       6.724  -9.898   8.056  1.00 36.14           O  
ATOM  10303  CB  ILE E  19       9.247  -9.538   9.885  1.00 36.02           C  
ATOM  10304  CG1 ILE E  19       9.990  -8.485  10.704  1.00 36.40           C  
ATOM  10305  CG2 ILE E  19      10.113 -10.781   9.719  1.00 36.51           C  
ATOM  10306  CD1 ILE E  19      10.082  -8.819  12.174  1.00 37.32           C  
ATOM  10307  N   ARG E  20       8.481 -10.829   7.010  1.00 35.48           N  
ATOM  10308  CA  ARG E  20       7.685 -11.814   6.301  1.00 34.56           C  
ATOM  10309  C   ARG E  20       8.316 -13.197   6.414  1.00 34.44           C  
ATOM  10310  O   ARG E  20       9.498 -13.391   6.162  1.00 34.57           O  
ATOM  10311  CB  ARG E  20       7.606 -11.396   4.832  1.00 36.25           C  
ATOM  10312  CG  ARG E  20       6.476 -12.104   4.086  1.00 38.18           C  
ATOM  10313  CD  ARG E  20       6.474 -11.767   2.590  1.00 40.35           C  
ATOM  10314  NE  ARG E  20       5.224 -12.205   1.964  1.00 42.82           N  
ATOM  10315  CZ  ARG E  20       4.273 -11.273   1.766  1.00 44.62           C  
ATOM  10316  NH1 ARG E  20       4.486 -10.019   2.128  1.00 45.81           N  
ATOM  10317  NH2 ARG E  20       3.119 -11.618   1.190  1.00 42.85           N  
ATOM  10318  N   ARG E  21       7.526 -14.193   6.799  1.00 33.89           N  
ATOM  10319  CA  ARG E  21       8.029 -15.555   6.922  1.00 34.03           C  
ATOM  10320  C   ARG E  21       7.938 -16.286   5.589  1.00 34.23           C  
ATOM  10321  O   ARG E  21       6.901 -16.263   4.928  1.00 34.31           O  
ATOM  10322  CB  ARG E  21       7.237 -16.321   7.984  1.00 33.99           C  
ATOM  10323  CG  ARG E  21       7.579 -17.809   8.072  1.00 34.22           C  
ATOM  10324  CD  ARG E  21       6.928 -18.458   9.291  1.00 34.82           C  
ATOM  10325  NE  ARG E  21       7.184 -19.898   9.360  1.00 35.08           N  
ATOM  10326  CZ  ARG E  21       6.839 -20.668  10.389  1.00 36.46           C  
ATOM  10327  NH1 ARG E  21       6.229 -20.137  11.443  1.00 36.41           N  
ATOM  10328  NH2 ARG E  21       7.092 -21.971  10.364  1.00 35.38           N  
ATOM  10329  N   VAL E  22       9.032 -16.933   5.201  1.00 33.74           N  
ATOM  10330  CA  VAL E  22       9.082 -17.681   3.951  1.00 33.43           C  
ATOM  10331  C   VAL E  22       9.203 -19.177   4.232  1.00 34.36           C  
ATOM  10332  O   VAL E  22      10.283 -19.672   4.553  1.00 34.42           O  
ATOM  10333  CB  VAL E  22      10.284 -17.236   3.089  1.00 33.50           C  
ATOM  10334  CG1 VAL E  22      10.353 -18.064   1.816  1.00 34.18           C  
ATOM  10335  CG2 VAL E  22      10.162 -15.763   2.756  1.00 31.53           C  
ATOM  10336  N   ASN E  23       8.089 -19.894   4.109  1.00 35.87           N  
ATOM  10337  CA  ASN E  23       8.080 -21.332   4.352  1.00 37.56           C  
ATOM  10338  C   ASN E  23       8.643 -22.089   3.154  1.00 38.38           C  
ATOM  10339  O   ASN E  23       8.264 -21.832   2.011  1.00 39.31           O  
ATOM  10340  CB  ASN E  23       6.658 -21.808   4.652  1.00 39.45           C  
ATOM  10341  CG  ASN E  23       6.123 -21.255   5.958  1.00 42.07           C  
ATOM  10342  OD1 ASN E  23       6.699 -21.485   7.027  1.00 42.01           O  
ATOM  10343  ND2 ASN E  23       5.014 -20.521   5.882  1.00 42.87           N  
ATOM  10344  N   ARG E  24       9.545 -23.026   3.424  1.00 38.02           N  
ATOM  10345  CA  ARG E  24      10.173 -23.802   2.365  1.00 38.84           C  
ATOM  10346  C   ARG E  24       9.919 -25.297   2.497  1.00 39.55           C  
ATOM  10347  O   ARG E  24      10.008 -25.863   3.589  1.00 40.31           O  
ATOM  10348  CB  ARG E  24      11.680 -23.544   2.357  1.00 37.53           C  
ATOM  10349  CG  ARG E  24      12.055 -22.083   2.169  1.00 36.92           C  
ATOM  10350  CD  ARG E  24      13.558 -21.926   2.127  1.00 35.37           C  
ATOM  10351  NE  ARG E  24      14.184 -22.380   3.363  1.00 34.03           N  
ATOM  10352  CZ  ARG E  24      15.484 -22.621   3.494  1.00 34.91           C  
ATOM  10353  NH1 ARG E  24      16.294 -22.454   2.458  1.00 35.15           N  
ATOM  10354  NH2 ARG E  24      15.975 -23.022   4.660  1.00 35.03           N  
ATOM  10355  N   VAL E  25       9.609 -25.934   1.372  1.00 39.78           N  
ATOM  10356  CA  VAL E  25       9.349 -27.368   1.357  1.00 40.32           C  
ATOM  10357  C   VAL E  25      10.605 -28.169   1.698  1.00 40.24           C  
ATOM  10358  O   VAL E  25      11.640 -28.036   1.041  1.00 41.22           O  
ATOM  10359  CB  VAL E  25       8.815 -27.822  -0.027  1.00 40.12           C  
ATOM  10360  CG1 VAL E  25       9.751 -27.348  -1.130  1.00 41.15           C  
ATOM  10361  CG2 VAL E  25       8.682 -29.342  -0.062  1.00 38.89           C  
ATOM  10362  N   GLY E  26      10.509 -28.991   2.738  1.00 40.74           N  
ATOM  10363  CA  GLY E  26      11.634 -29.815   3.147  1.00 41.12           C  
ATOM  10364  C   GLY E  26      12.792 -29.088   3.808  1.00 41.30           C  
ATOM  10365  O   GLY E  26      13.866 -29.667   3.981  1.00 42.19           O  
ATOM  10366  N   ALA E  27      12.592 -27.827   4.178  1.00 40.59           N  
ATOM  10367  CA  ALA E  27      13.651 -27.055   4.822  1.00 38.67           C  
ATOM  10368  C   ALA E  27      13.084 -26.092   5.858  1.00 37.47           C  
ATOM  10369  O   ALA E  27      11.886 -25.806   5.863  1.00 37.15           O  
ATOM  10370  CB  ALA E  27      14.451 -26.288   3.777  1.00 39.07           C  
ATOM  10371  N   ALA E  28      13.954 -25.598   6.734  1.00 35.47           N  
ATOM  10372  CA  ALA E  28      13.555 -24.668   7.783  1.00 34.99           C  
ATOM  10373  C   ALA E  28      13.140 -23.330   7.179  1.00 33.81           C  
ATOM  10374  O   ALA E  28      13.653 -22.924   6.142  1.00 35.12           O  
ATOM  10375  CB  ALA E  28      14.707 -24.466   8.771  1.00 34.89           C  
ATOM  10376  N   PRO E  29      12.195 -22.632   7.826  1.00 32.84           N  
ATOM  10377  CA  PRO E  29      11.701 -21.334   7.356  1.00 30.71           C  
ATOM  10378  C   PRO E  29      12.688 -20.180   7.466  1.00 30.56           C  
ATOM  10379  O   PRO E  29      13.578 -20.177   8.318  1.00 29.57           O  
ATOM  10380  CB  PRO E  29      10.457 -21.107   8.214  1.00 31.71           C  
ATOM  10381  CG  PRO E  29      10.802 -21.804   9.492  1.00 32.78           C  
ATOM  10382  CD  PRO E  29      11.425 -23.090   8.997  1.00 32.76           C  
ATOM  10383  N   LEU E  30      12.503 -19.197   6.592  1.00 28.63           N  
ATOM  10384  CA  LEU E  30      13.340 -18.009   6.560  1.00 29.20           C  
ATOM  10385  C   LEU E  30      12.504 -16.807   6.952  1.00 29.46           C  
ATOM  10386  O   LEU E  30      11.272 -16.868   6.949  1.00 31.23           O  
ATOM  10387  CB  LEU E  30      13.887 -17.771   5.147  1.00 28.20           C  
ATOM  10388  CG  LEU E  30      14.724 -18.872   4.499  1.00 29.46           C  
ATOM  10389  CD1 LEU E  30      15.235 -18.390   3.134  1.00 28.07           C  
ATOM  10390  CD2 LEU E  30      15.886 -19.221   5.414  1.00 27.26           C  
ATOM  10391  N   ALA E  31      13.184 -15.716   7.278  1.00 29.39           N  
ATOM  10392  CA  ALA E  31      12.533 -14.468   7.642  1.00 29.54           C  
ATOM  10393  C   ALA E  31      13.154 -13.365   6.792  1.00 30.16           C  
ATOM  10394  O   ALA E  31      14.374 -13.193   6.779  1.00 30.37           O  
ATOM  10395  CB  ALA E  31      12.744 -14.163   9.124  1.00 27.34           C  
ATOM  10396  N   VAL E  32      12.312 -12.636   6.068  1.00 30.92           N  
ATOM  10397  CA  VAL E  32      12.781 -11.539   5.231  1.00 31.18           C  
ATOM  10398  C   VAL E  32      12.388 -10.234   5.912  1.00 31.69           C  
ATOM  10399  O   VAL E  32      11.220 -10.021   6.223  1.00 33.57           O  
ATOM  10400  CB  VAL E  32      12.148 -11.604   3.826  1.00 31.26           C  
ATOM  10401  CG1 VAL E  32      12.582 -10.411   2.999  1.00 30.48           C  
ATOM  10402  CG2 VAL E  32      12.551 -12.902   3.140  1.00 30.17           C  
ATOM  10403  N   TYR E  33      13.364  -9.370   6.160  1.00 32.39           N  
ATOM  10404  CA  TYR E  33      13.087  -8.100   6.817  1.00 33.86           C  
ATOM  10405  C   TYR E  33      13.355  -6.939   5.875  1.00 35.63           C  
ATOM  10406  O   TYR E  33      14.321  -6.963   5.111  1.00 35.15           O  
ATOM  10407  CB  TYR E  33      13.973  -7.905   8.052  1.00 32.27           C  
ATOM  10408  CG  TYR E  33      14.224  -9.137   8.892  1.00 31.18           C  
ATOM  10409  CD1 TYR E  33      15.117 -10.124   8.474  1.00 29.85           C  
ATOM  10410  CD2 TYR E  33      13.591  -9.301  10.123  1.00 30.51           C  
ATOM  10411  CE1 TYR E  33      15.378 -11.245   9.268  1.00 30.22           C  
ATOM  10412  CE2 TYR E  33      13.842 -10.413  10.922  1.00 29.64           C  
ATOM  10413  CZ  TYR E  33      14.736 -11.380  10.492  1.00 29.81           C  
ATOM  10414  OH  TYR E  33      14.995 -12.468  11.295  1.00 28.62           O  
ATOM  10415  N   ARG E  34      12.499  -5.925   5.928  1.00 36.87           N  
ATOM  10416  CA  ARG E  34      12.701  -4.744   5.103  1.00 37.83           C  
ATOM  10417  C   ARG E  34      13.073  -3.584   6.011  1.00 38.01           C  
ATOM  10418  O   ARG E  34      12.258  -3.115   6.804  1.00 39.74           O  
ATOM  10419  CB  ARG E  34      11.445  -4.387   4.303  1.00 38.37           C  
ATOM  10420  CG  ARG E  34      11.593  -3.042   3.603  1.00 40.24           C  
ATOM  10421  CD  ARG E  34      10.548  -2.785   2.540  1.00 40.66           C  
ATOM  10422  NE  ARG E  34      10.768  -1.485   1.909  1.00 40.85           N  
ATOM  10423  CZ  ARG E  34      10.229  -1.110   0.753  1.00 40.84           C  
ATOM  10424  NH1 ARG E  34       9.431  -1.940   0.090  1.00 39.90           N  
ATOM  10425  NH2 ARG E  34      10.489   0.095   0.259  1.00 41.27           N  
ATOM  10426  N   VAL E  35      14.320  -3.142   5.909  1.00 38.56           N  
ATOM  10427  CA  VAL E  35      14.811  -2.035   6.709  1.00 38.90           C  
ATOM  10428  C   VAL E  35      14.899  -0.842   5.764  1.00 40.70           C  
ATOM  10429  O   VAL E  35      15.863  -0.704   5.006  1.00 40.86           O  
ATOM  10430  CB  VAL E  35      16.204  -2.354   7.291  1.00 39.49           C  
ATOM  10431  CG1 VAL E  35      16.696  -1.195   8.145  1.00 38.38           C  
ATOM  10432  CG2 VAL E  35      16.133  -3.635   8.113  1.00 37.74           C  
ATOM  10433  N   GLY E  36      13.883   0.014   5.812  1.00 41.08           N  
ATOM  10434  CA  GLY E  36      13.845   1.161   4.926  1.00 40.63           C  
ATOM  10435  C   GLY E  36      13.491   0.641   3.546  1.00 40.86           C  
ATOM  10436  O   GLY E  36      12.401   0.108   3.340  1.00 40.60           O  
ATOM  10437  N   ASP E  37      14.417   0.785   2.600  1.00 41.58           N  
ATOM  10438  CA  ASP E  37      14.203   0.304   1.240  1.00 41.99           C  
ATOM  10439  C   ASP E  37      15.061  -0.920   0.952  1.00 41.24           C  
ATOM  10440  O   ASP E  37      15.037  -1.462  -0.156  1.00 41.16           O  
ATOM  10441  CB  ASP E  37      14.531   1.404   0.231  1.00 44.46           C  
ATOM  10442  CG  ASP E  37      13.357   2.322  -0.023  1.00 47.39           C  
ATOM  10443  OD1 ASP E  37      12.756   2.806   0.961  1.00 48.09           O  
ATOM  10444  OD2 ASP E  37      13.038   2.556  -1.211  1.00 49.14           O  
ATOM  10445  N   GLN E  38      15.818  -1.351   1.957  1.00 40.18           N  
ATOM  10446  CA  GLN E  38      16.693  -2.512   1.823  1.00 38.87           C  
ATOM  10447  C   GLN E  38      16.048  -3.777   2.385  1.00 38.33           C  
ATOM  10448  O   GLN E  38      15.231  -3.716   3.305  1.00 37.77           O  
ATOM  10449  CB  GLN E  38      18.012  -2.251   2.545  1.00 40.10           C  
ATOM  10450  CG  GLN E  38      18.750  -1.011   2.065  1.00 42.70           C  
ATOM  10451  CD  GLN E  38      19.074  -1.070   0.586  1.00 44.74           C  
ATOM  10452  OE1 GLN E  38      19.788  -1.968   0.128  1.00 46.13           O  
ATOM  10453  NE2 GLN E  38      18.547  -0.114  -0.173  1.00 45.79           N  
ATOM  10454  N   PHE E  39      16.421  -4.925   1.827  1.00 37.60           N  
ATOM  10455  CA  PHE E  39      15.889  -6.203   2.282  1.00 37.00           C  
ATOM  10456  C   PHE E  39      16.998  -7.127   2.759  1.00 36.72           C  
ATOM  10457  O   PHE E  39      18.061  -7.214   2.143  1.00 37.01           O  
ATOM  10458  CB  PHE E  39      15.115  -6.906   1.163  1.00 36.95           C  
ATOM  10459  CG  PHE E  39      13.866  -6.191   0.747  1.00 38.37           C  
ATOM  10460  CD1 PHE E  39      13.932  -5.050  -0.048  1.00 38.24           C  
ATOM  10461  CD2 PHE E  39      12.617  -6.655   1.158  1.00 37.28           C  
ATOM  10462  CE1 PHE E  39      12.770  -4.381  -0.430  1.00 38.66           C  
ATOM  10463  CE2 PHE E  39      11.452  -5.993   0.781  1.00 37.52           C  
ATOM  10464  CZ  PHE E  39      11.528  -4.854  -0.015  1.00 37.57           C  
ATOM  10465  N   TYR E  40      16.736  -7.819   3.862  1.00 35.85           N  
ATOM  10466  CA  TYR E  40      17.691  -8.758   4.430  1.00 34.32           C  
ATOM  10467  C   TYR E  40      16.919 -10.013   4.799  1.00 32.90           C  
ATOM  10468  O   TYR E  40      15.690  -9.996   4.841  1.00 33.49           O  
ATOM  10469  CB  TYR E  40      18.354  -8.151   5.666  1.00 33.33           C  
ATOM  10470  CG  TYR E  40      19.073  -6.852   5.375  1.00 35.27           C  
ATOM  10471  CD1 TYR E  40      20.254  -6.835   4.628  1.00 35.53           C  
ATOM  10472  CD2 TYR E  40      18.555  -5.635   5.814  1.00 33.82           C  
ATOM  10473  CE1 TYR E  40      20.898  -5.633   4.323  1.00 36.36           C  
ATOM  10474  CE2 TYR E  40      19.187  -4.432   5.515  1.00 35.88           C  
ATOM  10475  CZ  TYR E  40      20.356  -4.438   4.770  1.00 36.43           C  
ATOM  10476  OH  TYR E  40      20.976  -3.247   4.466  1.00 39.59           O  
ATOM  10477  N   ALA E  41      17.628 -11.106   5.055  1.00 31.07           N  
ATOM  10478  CA  ALA E  41      16.963 -12.348   5.419  1.00 31.83           C  
ATOM  10479  C   ALA E  41      17.852 -13.253   6.262  1.00 31.98           C  
ATOM  10480  O   ALA E  41      19.076 -13.248   6.126  1.00 33.00           O  
ATOM  10481  CB  ALA E  41      16.503 -13.085   4.164  1.00 30.31           C  
ATOM  10482  N   THR E  42      17.218 -14.018   7.144  1.00 31.59           N  
ATOM  10483  CA  THR E  42      17.921 -14.951   8.019  1.00 30.39           C  
ATOM  10484  C   THR E  42      17.002 -16.143   8.224  1.00 29.08           C  
ATOM  10485  O   THR E  42      15.899 -16.185   7.669  1.00 28.39           O  
ATOM  10486  CB  THR E  42      18.182 -14.337   9.404  1.00 31.03           C  
ATOM  10487  OG1 THR E  42      16.935 -14.205  10.103  1.00 30.15           O  
ATOM  10488  CG2 THR E  42      18.825 -12.962   9.270  1.00 32.36           C  
ATOM  10489  N   GLU E  43      17.455 -17.116   9.008  1.00 28.03           N  
ATOM  10490  CA  GLU E  43      16.614 -18.261   9.317  1.00 27.81           C  
ATOM  10491  C   GLU E  43      15.500 -17.591  10.118  1.00 26.97           C  
ATOM  10492  O   GLU E  43      15.729 -16.561  10.754  1.00 24.96           O  
ATOM  10493  CB  GLU E  43      17.327 -19.250  10.240  1.00 30.74           C  
ATOM  10494  CG  GLU E  43      18.744 -19.619   9.856  1.00 34.64           C  
ATOM  10495  CD  GLU E  43      19.467 -20.307  11.001  1.00 36.95           C  
ATOM  10496  OE1 GLU E  43      19.123 -21.463  11.322  1.00 39.33           O  
ATOM  10497  OE2 GLU E  43      20.368 -19.684  11.595  1.00 37.95           O  
ATOM  10498  N   ASP E  44      14.307 -18.165  10.093  1.00 26.66           N  
ATOM  10499  CA  ASP E  44      13.201 -17.592  10.837  1.00 26.15           C  
ATOM  10500  C   ASP E  44      13.228 -18.029  12.297  1.00 25.06           C  
ATOM  10501  O   ASP E  44      12.768 -17.306  13.174  1.00 25.39           O  
ATOM  10502  CB  ASP E  44      11.871 -18.015  10.220  1.00 24.75           C  
ATOM  10503  CG  ASP E  44      10.684 -17.523  11.027  1.00 25.53           C  
ATOM  10504  OD1 ASP E  44      10.522 -16.291  11.137  1.00 25.33           O  
ATOM  10505  OD2 ASP E  44       9.927 -18.366  11.553  1.00 26.25           O  
ATOM  10506  N   THR E  45      13.776 -19.212  12.550  1.00 26.37           N  
ATOM  10507  CA  THR E  45      13.831 -19.762  13.901  1.00 25.74           C  
ATOM  10508  C   THR E  45      14.956 -19.187  14.752  1.00 25.36           C  
ATOM  10509  O   THR E  45      16.132 -19.276  14.390  1.00 25.11           O  
ATOM  10510  CB  THR E  45      14.000 -21.290  13.858  1.00 26.54           C  
ATOM  10511  OG1 THR E  45      13.065 -21.844  12.926  1.00 28.51           O  
ATOM  10512  CG2 THR E  45      13.754 -21.899  15.238  1.00 26.18           C  
ATOM  10513  N   CYS E  46      14.592 -18.605  15.892  1.00 23.53           N  
ATOM  10514  CA  CYS E  46      15.583 -18.039  16.797  1.00 22.34           C  
ATOM  10515  C   CYS E  46      16.590 -19.137  17.135  1.00 22.28           C  
ATOM  10516  O   CYS E  46      16.208 -20.270  17.425  1.00 22.55           O  
ATOM  10517  CB  CYS E  46      14.905 -17.537  18.077  1.00 20.59           C  
ATOM  10518  SG  CYS E  46      16.044 -16.759  19.224  1.00 21.42           S  
ATOM  10519  N   THR E  47      17.878 -18.807  17.110  1.00 22.68           N  
ATOM  10520  CA  THR E  47      18.907 -19.809  17.395  1.00 23.28           C  
ATOM  10521  C   THR E  47      18.946 -20.229  18.860  1.00 24.01           C  
ATOM  10522  O   THR E  47      19.546 -21.250  19.211  1.00 24.64           O  
ATOM  10523  CB  THR E  47      20.298 -19.299  16.997  1.00 23.72           C  
ATOM  10524  OG1 THR E  47      20.671 -18.204  17.840  1.00 23.01           O  
ATOM  10525  CG2 THR E  47      20.295 -18.836  15.537  1.00 24.16           C  
ATOM  10526  N   HIS E  48      18.283 -19.454  19.711  1.00 24.04           N  
ATOM  10527  CA  HIS E  48      18.253 -19.735  21.141  1.00 24.62           C  
ATOM  10528  C   HIS E  48      17.128 -20.689  21.528  1.00 24.88           C  
ATOM  10529  O   HIS E  48      17.042 -21.127  22.672  1.00 24.19           O  
ATOM  10530  CB  HIS E  48      18.121 -18.413  21.911  1.00 25.23           C  
ATOM  10531  CG  HIS E  48      18.044 -18.573  23.399  1.00 26.28           C  
ATOM  10532  ND1 HIS E  48      16.858 -18.482  24.097  1.00 24.08           N  
ATOM  10533  CD2 HIS E  48      19.006 -18.811  24.322  1.00 23.88           C  
ATOM  10534  CE1 HIS E  48      17.094 -18.652  25.386  1.00 23.46           C  
ATOM  10535  NE2 HIS E  48      18.390 -18.854  25.549  1.00 23.85           N  
ATOM  10536  N   GLY E  49      16.264 -21.019  20.574  1.00 25.86           N  
ATOM  10537  CA  GLY E  49      15.167 -21.915  20.886  1.00 25.44           C  
ATOM  10538  C   GLY E  49      14.341 -22.338  19.690  1.00 24.88           C  
ATOM  10539  O   GLY E  49      14.892 -22.706  18.657  1.00 27.01           O  
ATOM  10540  N   ILE E  50      13.020 -22.291  19.835  1.00 25.82           N  
ATOM  10541  CA  ILE E  50      12.102 -22.682  18.765  1.00 24.85           C  
ATOM  10542  C   ILE E  50      11.144 -21.563  18.360  1.00 25.13           C  
ATOM  10543  O   ILE E  50      10.154 -21.806  17.679  1.00 26.23           O  
ATOM  10544  CB  ILE E  50      11.249 -23.911  19.175  1.00 25.83           C  
ATOM  10545  CG1 ILE E  50      10.459 -23.598  20.452  1.00 25.46           C  
ATOM  10546  CG2 ILE E  50      12.146 -25.137  19.383  1.00 25.99           C  
ATOM  10547  CD1 ILE E  50       9.386 -24.641  20.773  1.00 26.52           C  
ATOM  10548  N   ALA E  51      11.433 -20.338  18.773  1.00 25.60           N  
ATOM  10549  CA  ALA E  51      10.567 -19.212  18.442  1.00 26.52           C  
ATOM  10550  C   ALA E  51      10.696 -18.780  16.983  1.00 26.94           C  
ATOM  10551  O   ALA E  51      11.708 -19.046  16.337  1.00 25.95           O  
ATOM  10552  CB  ALA E  51      10.888 -18.044  19.344  1.00 25.57           C  
ATOM  10553  N   SER E  52       9.661 -18.112  16.474  1.00 26.05           N  
ATOM  10554  CA  SER E  52       9.668 -17.604  15.105  1.00 26.57           C  
ATOM  10555  C   SER E  52       9.979 -16.113  15.173  1.00 26.81           C  
ATOM  10556  O   SER E  52       9.177 -15.329  15.686  1.00 28.27           O  
ATOM  10557  CB  SER E  52       8.307 -17.814  14.438  1.00 27.85           C  
ATOM  10558  OG  SER E  52       8.256 -17.151  13.189  1.00 27.05           O  
ATOM  10559  N   LEU E  53      11.142 -15.721  14.660  1.00 24.95           N  
ATOM  10560  CA  LEU E  53      11.549 -14.322  14.689  1.00 27.00           C  
ATOM  10561  C   LEU E  53      10.601 -13.428  13.902  1.00 28.16           C  
ATOM  10562  O   LEU E  53      10.509 -12.235  14.172  1.00 29.10           O  
ATOM  10563  CB  LEU E  53      12.970 -14.160  14.139  1.00 26.83           C  
ATOM  10564  CG  LEU E  53      14.094 -14.847  14.924  1.00 28.73           C  
ATOM  10565  CD1 LEU E  53      15.408 -14.647  14.190  1.00 28.80           C  
ATOM  10566  CD2 LEU E  53      14.175 -14.277  16.343  1.00 27.62           C  
ATOM  10567  N   SER E  54       9.900 -14.003  12.930  1.00 30.08           N  
ATOM  10568  CA  SER E  54       8.972 -13.222  12.125  1.00 32.47           C  
ATOM  10569  C   SER E  54       7.791 -12.770  12.981  1.00 33.34           C  
ATOM  10570  O   SER E  54       7.031 -11.892  12.581  1.00 35.09           O  
ATOM  10571  CB  SER E  54       8.485 -14.036  10.920  1.00 32.06           C  
ATOM  10572  OG  SER E  54       7.796 -15.199  11.330  1.00 36.70           O  
ATOM  10573  N   GLU E  55       7.647 -13.373  14.160  1.00 33.19           N  
ATOM  10574  CA  GLU E  55       6.576 -13.013  15.086  1.00 32.75           C  
ATOM  10575  C   GLU E  55       7.134 -12.089  16.164  1.00 32.05           C  
ATOM  10576  O   GLU E  55       6.469 -11.805  17.164  1.00 31.65           O  
ATOM  10577  CB  GLU E  55       5.980 -14.262  15.744  1.00 34.10           C  
ATOM  10578  CG  GLU E  55       5.124 -15.124  14.822  1.00 37.59           C  
ATOM  10579  CD  GLU E  55       4.588 -16.370  15.513  1.00 40.11           C  
ATOM  10580  OE1 GLU E  55       4.084 -16.254  16.650  1.00 43.64           O  
ATOM  10581  OE2 GLU E  55       4.659 -17.467  14.919  1.00 42.62           O  
ATOM  10582  N   GLY E  56       8.361 -11.625  15.952  1.00 31.08           N  
ATOM  10583  CA  GLY E  56       9.001 -10.747  16.913  1.00 31.19           C  
ATOM  10584  C   GLY E  56       8.856  -9.281  16.563  1.00 31.42           C  
ATOM  10585  O   GLY E  56       7.987  -8.903  15.776  1.00 32.86           O  
ATOM  10586  N   THR E  57       9.716  -8.454  17.141  1.00 31.84           N  
ATOM  10587  CA  THR E  57       9.672  -7.020  16.892  1.00 32.90           C  
ATOM  10588  C   THR E  57      10.944  -6.508  16.230  1.00 33.15           C  
ATOM  10589  O   THR E  57      12.052  -6.730  16.723  1.00 33.25           O  
ATOM  10590  CB  THR E  57       9.454  -6.241  18.201  1.00 33.54           C  
ATOM  10591  OG1 THR E  57       8.262  -6.712  18.841  1.00 33.44           O  
ATOM  10592  CG2 THR E  57       9.323  -4.749  17.919  1.00 34.65           C  
ATOM  10593  N   LEU E  58      10.771  -5.815  15.110  1.00 33.62           N  
ATOM  10594  CA  LEU E  58      11.888  -5.260  14.363  1.00 34.83           C  
ATOM  10595  C   LEU E  58      12.154  -3.830  14.841  1.00 35.95           C  
ATOM  10596  O   LEU E  58      11.268  -2.976  14.806  1.00 36.51           O  
ATOM  10597  CB  LEU E  58      11.559  -5.281  12.865  1.00 34.98           C  
ATOM  10598  CG  LEU E  58      12.660  -5.017  11.829  1.00 36.10           C  
ATOM  10599  CD1 LEU E  58      13.808  -6.001  12.008  1.00 36.27           C  
ATOM  10600  CD2 LEU E  58      12.069  -5.153  10.435  1.00 35.63           C  
ATOM  10601  N   ASP E  59      13.374  -3.585  15.304  1.00 36.96           N  
ATOM  10602  CA  ASP E  59      13.779  -2.270  15.793  1.00 37.18           C  
ATOM  10603  C   ASP E  59      14.921  -1.807  14.900  1.00 36.92           C  
ATOM  10604  O   ASP E  59      16.091  -2.044  15.209  1.00 37.02           O  
ATOM  10605  CB  ASP E  59      14.276  -2.378  17.237  1.00 38.87           C  
ATOM  10606  CG  ASP E  59      14.480  -1.023  17.897  1.00 41.78           C  
ATOM  10607  OD1 ASP E  59      15.016  -0.098  17.247  1.00 42.57           O  
ATOM  10608  OD2 ASP E  59      14.116  -0.888  19.086  1.00 44.74           O  
ATOM  10609  N   GLY E  60      14.589  -1.144  13.798  1.00 36.55           N  
ATOM  10610  CA  GLY E  60      15.626  -0.695  12.888  1.00 36.53           C  
ATOM  10611  C   GLY E  60      16.174  -1.917  12.173  1.00 35.33           C  
ATOM  10612  O   GLY E  60      15.452  -2.564  11.420  1.00 35.77           O  
ATOM  10613  N   ASP E  61      17.437  -2.247  12.413  1.00 36.31           N  
ATOM  10614  CA  ASP E  61      18.034  -3.419  11.782  1.00 37.06           C  
ATOM  10615  C   ASP E  61      18.262  -4.533  12.807  1.00 36.38           C  
ATOM  10616  O   ASP E  61      19.057  -5.450  12.584  1.00 35.78           O  
ATOM  10617  CB  ASP E  61      19.352  -3.041  11.091  1.00 39.27           C  
ATOM  10618  CG  ASP E  61      20.427  -2.609  12.066  1.00 41.37           C  
ATOM  10619  OD1 ASP E  61      20.088  -2.086  13.147  1.00 43.54           O  
ATOM  10620  OD2 ASP E  61      21.620  -2.780  11.739  1.00 42.84           O  
ATOM  10621  N   VAL E  62      17.556  -4.445  13.930  1.00 35.31           N  
ATOM  10622  CA  VAL E  62      17.666  -5.447  14.985  1.00 34.80           C  
ATOM  10623  C   VAL E  62      16.321  -6.123  15.225  1.00 34.51           C  
ATOM  10624  O   VAL E  62      15.311  -5.456  15.458  1.00 34.57           O  
ATOM  10625  CB  VAL E  62      18.148  -4.824  16.315  1.00 34.49           C  
ATOM  10626  CG1 VAL E  62      18.130  -5.876  17.420  1.00 32.84           C  
ATOM  10627  CG2 VAL E  62      19.547  -4.268  16.151  1.00 34.75           C  
ATOM  10628  N   ILE E  63      16.312  -7.451  15.157  1.00 32.84           N  
ATOM  10629  CA  ILE E  63      15.093  -8.213  15.380  1.00 30.62           C  
ATOM  10630  C   ILE E  63      15.101  -8.787  16.801  1.00 30.28           C  
ATOM  10631  O   ILE E  63      16.090  -9.379  17.238  1.00 29.50           O  
ATOM  10632  CB  ILE E  63      14.956  -9.361  14.347  1.00 30.13           C  
ATOM  10633  CG1 ILE E  63      13.703 -10.182  14.638  1.00 30.09           C  
ATOM  10634  CG2 ILE E  63      16.198 -10.238  14.361  1.00 30.11           C  
ATOM  10635  CD1 ILE E  63      12.401  -9.395  14.496  1.00 31.06           C  
ATOM  10636  N   GLU E  64      13.999  -8.589  17.519  1.00 29.45           N  
ATOM  10637  CA  GLU E  64      13.870  -9.074  18.890  1.00 29.63           C  
ATOM  10638  C   GLU E  64      12.963 -10.293  18.959  1.00 28.92           C  
ATOM  10639  O   GLU E  64      11.802 -10.243  18.541  1.00 28.90           O  
ATOM  10640  CB  GLU E  64      13.311  -7.973  19.796  1.00 30.75           C  
ATOM  10641  CG  GLU E  64      12.839  -8.490  21.153  1.00 36.95           C  
ATOM  10642  CD  GLU E  64      12.196  -7.411  22.012  1.00 39.80           C  
ATOM  10643  OE1 GLU E  64      12.936  -6.611  22.626  1.00 42.46           O  
ATOM  10644  OE2 GLU E  64      10.949  -7.359  22.067  1.00 40.98           O  
ATOM  10645  N   CYS E  65      13.494 -11.390  19.489  1.00 26.72           N  
ATOM  10646  CA  CYS E  65      12.729 -12.621  19.616  1.00 26.79           C  
ATOM  10647  C   CYS E  65      11.581 -12.448  20.624  1.00 27.04           C  
ATOM  10648  O   CYS E  65      11.771 -11.883  21.699  1.00 27.26           O  
ATOM  10649  CB  CYS E  65      13.649 -13.754  20.062  1.00 25.66           C  
ATOM  10650  SG  CYS E  65      12.782 -15.275  20.389  1.00 26.87           S  
ATOM  10651  N   PRO E  66      10.379 -12.951  20.289  1.00 27.57           N  
ATOM  10652  CA  PRO E  66       9.203 -12.843  21.164  1.00 28.38           C  
ATOM  10653  C   PRO E  66       9.182 -13.744  22.403  1.00 28.37           C  
ATOM  10654  O   PRO E  66       8.403 -13.512  23.325  1.00 30.36           O  
ATOM  10655  CB  PRO E  66       8.047 -13.153  20.217  1.00 28.88           C  
ATOM  10656  CG  PRO E  66       8.644 -14.187  19.318  1.00 29.04           C  
ATOM  10657  CD  PRO E  66      10.023 -13.606  19.016  1.00 27.83           C  
ATOM  10658  N   PHE E  67      10.028 -14.767  22.427  1.00 27.25           N  
ATOM  10659  CA  PHE E  67      10.075 -15.693  23.558  1.00 27.44           C  
ATOM  10660  C   PHE E  67      10.798 -15.152  24.795  1.00 27.26           C  
ATOM  10661  O   PHE E  67      10.213 -15.056  25.875  1.00 26.54           O  
ATOM  10662  CB  PHE E  67      10.774 -16.995  23.151  1.00 27.68           C  
ATOM  10663  CG  PHE E  67       9.856 -18.056  22.612  1.00 28.40           C  
ATOM  10664  CD1 PHE E  67       8.701 -17.725  21.906  1.00 28.74           C  
ATOM  10665  CD2 PHE E  67      10.187 -19.402  22.762  1.00 27.89           C  
ATOM  10666  CE1 PHE E  67       7.892 -18.725  21.354  1.00 28.99           C  
ATOM  10667  CE2 PHE E  67       9.392 -20.403  22.215  1.00 27.33           C  
ATOM  10668  CZ  PHE E  67       8.239 -20.064  21.508  1.00 29.22           C  
ATOM  10669  N   HIS E  68      12.072 -14.807  24.630  1.00 26.06           N  
ATOM  10670  CA  HIS E  68      12.889 -14.354  25.749  1.00 24.98           C  
ATOM  10671  C   HIS E  68      13.505 -12.969  25.622  1.00 24.93           C  
ATOM  10672  O   HIS E  68      14.276 -12.556  26.488  1.00 25.75           O  
ATOM  10673  CB  HIS E  68      14.009 -15.364  25.990  1.00 24.85           C  
ATOM  10674  CG  HIS E  68      13.524 -16.766  26.184  1.00 24.11           C  
ATOM  10675  ND1 HIS E  68      13.924 -17.809  25.378  1.00 23.74           N  
ATOM  10676  CD2 HIS E  68      12.681 -17.299  27.098  1.00 23.76           C  
ATOM  10677  CE1 HIS E  68      13.349 -18.925  25.786  1.00 25.20           C  
ATOM  10678  NE2 HIS E  68      12.589 -18.644  26.831  1.00 26.22           N  
ATOM  10679  N   GLY E  69      13.189 -12.262  24.545  1.00 25.34           N  
ATOM  10680  CA  GLY E  69      13.737 -10.933  24.366  1.00 25.98           C  
ATOM  10681  C   GLY E  69      15.117 -10.898  23.748  1.00 26.29           C  
ATOM  10682  O   GLY E  69      15.740  -9.840  23.689  1.00 29.00           O  
ATOM  10683  N   GLY E  70      15.616 -12.047  23.307  1.00 26.83           N  
ATOM  10684  CA  GLY E  70      16.919 -12.066  22.667  1.00 26.17           C  
ATOM  10685  C   GLY E  70      16.782 -11.292  21.365  1.00 25.72           C  
ATOM  10686  O   GLY E  70      15.662 -11.006  20.940  1.00 25.80           O  
ATOM  10687  N   ALA E  71      17.895 -10.950  20.725  1.00 25.10           N  
ATOM  10688  CA  ALA E  71      17.836 -10.192  19.475  1.00 25.36           C  
ATOM  10689  C   ALA E  71      19.057 -10.424  18.593  1.00 26.01           C  
ATOM  10690  O   ALA E  71      20.109 -10.864  19.069  1.00 25.33           O  
ATOM  10691  CB  ALA E  71      17.698  -8.689  19.777  1.00 24.68           C  
ATOM  10692  N   PHE E  72      18.912 -10.115  17.308  1.00 26.08           N  
ATOM  10693  CA  PHE E  72      20.008 -10.269  16.350  1.00 26.72           C  
ATOM  10694  C   PHE E  72      20.005  -9.104  15.370  1.00 27.47           C  
ATOM  10695  O   PHE E  72      18.988  -8.447  15.175  1.00 28.97           O  
ATOM  10696  CB  PHE E  72      19.856 -11.543  15.504  1.00 26.27           C  
ATOM  10697  CG  PHE E  72      19.690 -12.809  16.291  1.00 25.73           C  
ATOM  10698  CD1 PHE E  72      18.455 -13.158  16.824  1.00 27.13           C  
ATOM  10699  CD2 PHE E  72      20.758 -13.686  16.448  1.00 26.43           C  
ATOM  10700  CE1 PHE E  72      18.284 -14.369  17.500  1.00 25.94           C  
ATOM  10701  CE2 PHE E  72      20.596 -14.893  17.120  1.00 27.15           C  
ATOM  10702  CZ  PHE E  72      19.354 -15.234  17.645  1.00 25.44           C  
ATOM  10703  N   ASN E  73      21.149  -8.853  14.749  1.00 30.29           N  
ATOM  10704  CA  ASN E  73      21.235  -7.814  13.733  1.00 31.08           C  
ATOM  10705  C   ASN E  73      20.821  -8.567  12.466  1.00 31.47           C  
ATOM  10706  O   ASN E  73      21.430  -9.577  12.117  1.00 30.65           O  
ATOM  10707  CB  ASN E  73      22.669  -7.304  13.608  1.00 33.17           C  
ATOM  10708  CG  ASN E  73      22.812  -6.244  12.540  1.00 35.67           C  
ATOM  10709  OD1 ASN E  73      22.600  -6.512  11.359  1.00 37.37           O  
ATOM  10710  ND2 ASN E  73      23.165  -5.026  12.950  1.00 35.85           N  
ATOM  10711  N   VAL E  74      19.774  -8.101  11.792  1.00 31.12           N  
ATOM  10712  CA  VAL E  74      19.289  -8.786  10.602  1.00 32.11           C  
ATOM  10713  C   VAL E  74      20.241  -8.779   9.405  1.00 33.96           C  
ATOM  10714  O   VAL E  74      20.107  -9.611   8.507  1.00 34.30           O  
ATOM  10715  CB  VAL E  74      17.924  -8.221  10.151  1.00 30.71           C  
ATOM  10716  CG1 VAL E  74      16.914  -8.336  11.297  1.00 31.44           C  
ATOM  10717  CG2 VAL E  74      18.071  -6.773   9.706  1.00 30.26           C  
ATOM  10718  N   CYS E  75      21.199  -7.857   9.400  1.00 35.50           N  
ATOM  10719  CA  CYS E  75      22.162  -7.758   8.303  1.00 37.04           C  
ATOM  10720  C   CYS E  75      23.337  -8.728   8.443  1.00 35.76           C  
ATOM  10721  O   CYS E  75      23.742  -9.370   7.473  1.00 36.32           O  
ATOM  10722  CB  CYS E  75      22.723  -6.337   8.214  1.00 39.48           C  
ATOM  10723  SG  CYS E  75      21.489  -5.024   8.098  1.00 44.83           S  
ATOM  10724  N   THR E  76      23.885  -8.818   9.650  1.00 34.98           N  
ATOM  10725  CA  THR E  76      25.031  -9.685   9.912  1.00 34.04           C  
ATOM  10726  C   THR E  76      24.630 -11.000  10.567  1.00 32.85           C  
ATOM  10727  O   THR E  76      25.404 -11.957  10.571  1.00 31.17           O  
ATOM  10728  CB  THR E  76      26.035  -9.002  10.850  1.00 35.22           C  
ATOM  10729  OG1 THR E  76      25.441  -8.858  12.147  1.00 35.08           O  
ATOM  10730  CG2 THR E  76      26.424  -7.625  10.317  1.00 34.41           C  
ATOM  10731  N   GLY E  77      23.429 -11.032  11.134  1.00 31.70           N  
ATOM  10732  CA  GLY E  77      22.952 -12.227  11.801  1.00 30.36           C  
ATOM  10733  C   GLY E  77      23.573 -12.430  13.176  1.00 30.24           C  
ATOM  10734  O   GLY E  77      23.251 -13.395  13.862  1.00 30.68           O  
ATOM  10735  N   MET E  78      24.449 -11.522  13.592  1.00 29.91           N  
ATOM  10736  CA  MET E  78      25.105 -11.639  14.894  1.00 31.55           C  
ATOM  10737  C   MET E  78      24.179 -11.301  16.067  1.00 30.48           C  
ATOM  10738  O   MET E  78      23.279 -10.477  15.941  1.00 29.62           O  
ATOM  10739  CB  MET E  78      26.333 -10.726  14.948  1.00 32.93           C  
ATOM  10740  CG  MET E  78      27.427 -11.094  13.955  1.00 35.39           C  
ATOM  10741  SD  MET E  78      28.032 -12.768  14.207  1.00 38.57           S  
ATOM  10742  CE  MET E  78      29.110 -12.517  15.626  1.00 39.42           C  
ATOM  10743  N   PRO E  79      24.388 -11.951  17.221  1.00 30.93           N  
ATOM  10744  CA  PRO E  79      23.561 -11.701  18.409  1.00 30.76           C  
ATOM  10745  C   PRO E  79      23.668 -10.241  18.848  1.00 31.48           C  
ATOM  10746  O   PRO E  79      24.760  -9.680  18.875  1.00 33.35           O  
ATOM  10747  CB  PRO E  79      24.150 -12.657  19.439  1.00 30.86           C  
ATOM  10748  CG  PRO E  79      24.598 -13.810  18.592  1.00 30.88           C  
ATOM  10749  CD  PRO E  79      25.269 -13.111  17.435  1.00 30.87           C  
ATOM  10750  N   ALA E  80      22.538  -9.624  19.184  1.00 31.43           N  
ATOM  10751  CA  ALA E  80      22.540  -8.229  19.616  1.00 31.07           C  
ATOM  10752  C   ALA E  80      22.083  -8.096  21.070  1.00 30.75           C  
ATOM  10753  O   ALA E  80      22.422  -7.130  21.755  1.00 31.72           O  
ATOM  10754  CB  ALA E  80      21.645  -7.394  18.698  1.00 30.35           C  
ATOM  10755  N   SER E  81      21.313  -9.074  21.532  1.00 30.16           N  
ATOM  10756  CA  SER E  81      20.812  -9.090  22.898  1.00 29.03           C  
ATOM  10757  C   SER E  81      20.837 -10.500  23.462  1.00 27.90           C  
ATOM  10758  O   SER E  81      20.571 -11.471  22.749  1.00 27.60           O  
ATOM  10759  CB  SER E  81      19.367  -8.570  22.959  1.00 30.38           C  
ATOM  10760  OG  SER E  81      19.301  -7.162  22.824  1.00 30.53           O  
ATOM  10761  N   SER E  82      21.165 -10.603  24.744  1.00 26.37           N  
ATOM  10762  CA  SER E  82      21.186 -11.884  25.435  1.00 25.48           C  
ATOM  10763  C   SER E  82      19.719 -12.285  25.491  1.00 24.38           C  
ATOM  10764  O   SER E  82      18.841 -11.426  25.401  1.00 24.53           O  
ATOM  10765  CB  SER E  82      21.725 -11.694  26.850  1.00 25.80           C  
ATOM  10766  OG  SER E  82      20.958 -10.709  27.531  1.00 27.77           O  
ATOM  10767  N   PRO E  83      19.420 -13.578  25.677  1.00 23.74           N  
ATOM  10768  CA  PRO E  83      20.308 -14.729  25.865  1.00 23.79           C  
ATOM  10769  C   PRO E  83      20.914 -15.333  24.589  1.00 24.41           C  
ATOM  10770  O   PRO E  83      21.631 -16.325  24.657  1.00 24.70           O  
ATOM  10771  CB  PRO E  83      19.412 -15.715  26.589  1.00 24.47           C  
ATOM  10772  CG  PRO E  83      18.086 -15.499  25.876  1.00 25.45           C  
ATOM  10773  CD  PRO E  83      18.004 -13.986  25.758  1.00 23.19           C  
ATOM  10774  N   CYS E  84      20.628 -14.744  23.432  1.00 25.29           N  
ATOM  10775  CA  CYS E  84      21.161 -15.261  22.170  1.00 25.14           C  
ATOM  10776  C   CYS E  84      22.686 -15.179  22.085  1.00 26.12           C  
ATOM  10777  O   CYS E  84      23.282 -14.159  22.433  1.00 26.54           O  
ATOM  10778  CB  CYS E  84      20.534 -14.516  20.993  1.00 24.17           C  
ATOM  10779  SG  CYS E  84      18.740 -14.752  20.891  1.00 26.82           S  
ATOM  10780  N   THR E  85      23.303 -16.265  21.625  1.00 26.30           N  
ATOM  10781  CA  THR E  85      24.758 -16.348  21.481  1.00 26.74           C  
ATOM  10782  C   THR E  85      25.171 -16.975  20.143  1.00 27.39           C  
ATOM  10783  O   THR E  85      26.285 -16.749  19.668  1.00 27.99           O  
ATOM  10784  CB  THR E  85      25.392 -17.200  22.597  1.00 25.39           C  
ATOM  10785  OG1 THR E  85      24.829 -18.518  22.562  1.00 27.29           O  
ATOM  10786  CG2 THR E  85      25.139 -16.577  23.966  1.00 26.13           C  
ATOM  10787  N   VAL E  86      24.288 -17.776  19.548  1.00 26.83           N  
ATOM  10788  CA  VAL E  86      24.597 -18.406  18.268  1.00 25.41           C  
ATOM  10789  C   VAL E  86      24.113 -17.531  17.116  1.00 26.55           C  
ATOM  10790  O   VAL E  86      22.939 -17.149  17.058  1.00 26.20           O  
ATOM  10791  CB  VAL E  86      23.932 -19.793  18.130  1.00 25.94           C  
ATOM  10792  CG1 VAL E  86      24.381 -20.459  16.825  1.00 24.27           C  
ATOM  10793  CG2 VAL E  86      24.282 -20.659  19.321  1.00 26.37           C  
ATOM  10794  N   PRO E  87      25.020 -17.187  16.193  1.00 26.62           N  
ATOM  10795  CA  PRO E  87      24.705 -16.353  15.029  1.00 27.21           C  
ATOM  10796  C   PRO E  87      23.649 -16.986  14.132  1.00 26.25           C  
ATOM  10797  O   PRO E  87      23.601 -18.205  13.984  1.00 24.15           O  
ATOM  10798  CB  PRO E  87      26.045 -16.242  14.314  1.00 28.23           C  
ATOM  10799  CG  PRO E  87      27.033 -16.304  15.444  1.00 28.85           C  
ATOM  10800  CD  PRO E  87      26.475 -17.415  16.295  1.00 27.27           C  
ATOM  10801  N   LEU E  88      22.802 -16.146  13.549  1.00 26.50           N  
ATOM  10802  CA  LEU E  88      21.764 -16.610  12.634  1.00 28.60           C  
ATOM  10803  C   LEU E  88      22.392 -16.833  11.268  1.00 29.71           C  
ATOM  10804  O   LEU E  88      23.348 -16.154  10.904  1.00 30.97           O  
ATOM  10805  CB  LEU E  88      20.676 -15.546  12.473  1.00 27.44           C  
ATOM  10806  CG  LEU E  88      19.539 -15.439  13.487  1.00 25.81           C  
ATOM  10807  CD1 LEU E  88      18.777 -14.150  13.240  1.00 23.11           C  
ATOM  10808  CD2 LEU E  88      18.615 -16.644  13.354  1.00 25.29           C  
ATOM  10809  N   GLY E  89      21.857 -17.784  10.512  1.00 31.30           N  
ATOM  10810  CA  GLY E  89      22.370 -18.000   9.173  1.00 31.12           C  
ATOM  10811  C   GLY E  89      21.759 -16.874   8.354  1.00 31.59           C  
ATOM  10812  O   GLY E  89      20.582 -16.559   8.538  1.00 29.84           O  
ATOM  10813  N   VAL E  90      22.542 -16.248   7.476  1.00 31.39           N  
ATOM  10814  CA  VAL E  90      22.024 -15.158   6.662  1.00 32.22           C  
ATOM  10815  C   VAL E  90      21.857 -15.576   5.210  1.00 32.35           C  
ATOM  10816  O   VAL E  90      22.705 -16.272   4.644  1.00 31.82           O  
ATOM  10817  CB  VAL E  90      22.939 -13.912   6.717  1.00 33.11           C  
ATOM  10818  CG1 VAL E  90      23.112 -13.461   8.158  1.00 35.05           C  
ATOM  10819  CG2 VAL E  90      24.286 -14.219   6.087  1.00 36.71           C  
ATOM  10820  N   PHE E  91      20.752 -15.155   4.612  1.00 30.92           N  
ATOM  10821  CA  PHE E  91      20.470 -15.487   3.228  1.00 31.98           C  
ATOM  10822  C   PHE E  91      20.387 -14.213   2.399  1.00 31.97           C  
ATOM  10823  O   PHE E  91      19.675 -13.272   2.750  1.00 32.38           O  
ATOM  10824  CB  PHE E  91      19.165 -16.280   3.140  1.00 32.06           C  
ATOM  10825  CG  PHE E  91      19.193 -17.578   3.909  1.00 31.96           C  
ATOM  10826  CD1 PHE E  91      19.314 -17.579   5.297  1.00 32.37           C  
ATOM  10827  CD2 PHE E  91      19.116 -18.798   3.246  1.00 32.38           C  
ATOM  10828  CE1 PHE E  91      19.359 -18.779   6.015  1.00 31.41           C  
ATOM  10829  CE2 PHE E  91      19.159 -20.003   3.950  1.00 32.15           C  
ATOM  10830  CZ  PHE E  91      19.281 -19.992   5.339  1.00 31.42           C  
ATOM  10831  N   GLU E  92      21.139 -14.186   1.305  1.00 32.41           N  
ATOM  10832  CA  GLU E  92      21.174 -13.030   0.420  1.00 31.66           C  
ATOM  10833  C   GLU E  92      19.800 -12.773  -0.188  1.00 31.60           C  
ATOM  10834  O   GLU E  92      19.056 -13.707  -0.493  1.00 31.00           O  
ATOM  10835  CB  GLU E  92      22.191 -13.268  -0.705  1.00 32.14           C  
ATOM  10836  CG  GLU E  92      22.471 -12.056  -1.580  1.00 32.31           C  
ATOM  10837  CD  GLU E  92      23.228 -10.964  -0.844  1.00 31.55           C  
ATOM  10838  OE1 GLU E  92      23.734 -11.231   0.265  1.00 32.66           O  
ATOM  10839  OE2 GLU E  92      23.330  -9.841  -1.376  1.00 33.15           O  
ATOM  10840  N   VAL E  93      19.467 -11.499  -0.346  1.00 32.03           N  
ATOM  10841  CA  VAL E  93      18.202 -11.102  -0.951  1.00 33.62           C  
ATOM  10842  C   VAL E  93      18.507 -10.144  -2.102  1.00 34.38           C  
ATOM  10843  O   VAL E  93      19.428  -9.332  -2.014  1.00 35.26           O  
ATOM  10844  CB  VAL E  93      17.286 -10.361   0.054  1.00 33.29           C  
ATOM  10845  CG1 VAL E  93      15.952 -10.045  -0.604  1.00 33.60           C  
ATOM  10846  CG2 VAL E  93      17.071 -11.207   1.302  1.00 33.22           C  
ATOM  10847  N   GLU E  94      17.751 -10.255  -3.187  1.00 35.45           N  
ATOM  10848  CA  GLU E  94      17.931  -9.364  -4.329  1.00 35.87           C  
ATOM  10849  C   GLU E  94      16.577  -9.103  -4.973  1.00 36.66           C  
ATOM  10850  O   GLU E  94      15.696  -9.965  -4.952  1.00 35.88           O  
ATOM  10851  CB  GLU E  94      18.894  -9.967  -5.367  1.00 35.22           C  
ATOM  10852  CG  GLU E  94      18.420 -11.258  -6.031  1.00 37.68           C  
ATOM  10853  CD  GLU E  94      19.294 -11.660  -7.219  1.00 38.36           C  
ATOM  10854  OE1 GLU E  94      20.524 -11.436  -7.159  1.00 38.75           O  
ATOM  10855  OE2 GLU E  94      18.756 -12.209  -8.205  1.00 38.79           O  
ATOM  10856  N   VAL E  95      16.416  -7.909  -5.535  1.00 37.58           N  
ATOM  10857  CA  VAL E  95      15.174  -7.526  -6.194  1.00 38.42           C  
ATOM  10858  C   VAL E  95      15.357  -7.414  -7.711  1.00 39.65           C  
ATOM  10859  O   VAL E  95      16.106  -6.564  -8.193  1.00 40.00           O  
ATOM  10860  CB  VAL E  95      14.657  -6.167  -5.659  1.00 38.03           C  
ATOM  10861  CG1 VAL E  95      13.390  -5.753  -6.403  1.00 37.06           C  
ATOM  10862  CG2 VAL E  95      14.386  -6.266  -4.157  1.00 38.30           C  
ATOM  10863  N   LYS E  96      14.684  -8.287  -8.458  1.00 41.40           N  
ATOM  10864  CA  LYS E  96      14.752  -8.262  -9.915  1.00 42.44           C  
ATOM  10865  C   LYS E  96      13.401  -7.815 -10.455  1.00 43.38           C  
ATOM  10866  O   LYS E  96      12.403  -8.534 -10.342  1.00 43.20           O  
ATOM  10867  CB  LYS E  96      15.098  -9.643 -10.483  1.00 42.42           C  
ATOM  10868  CG  LYS E  96      16.505 -10.116 -10.163  1.00 42.81           C  
ATOM  10869  CD  LYS E  96      17.047 -11.088 -11.222  1.00 43.55           C  
ATOM  10870  CE  LYS E  96      16.176 -12.335 -11.396  1.00 44.14           C  
ATOM  10871  NZ  LYS E  96      14.947 -12.081 -12.202  1.00 43.89           N  
ATOM  10872  N   GLU E  97      13.379  -6.619 -11.033  1.00 44.86           N  
ATOM  10873  CA  GLU E  97      12.159  -6.048 -11.589  1.00 45.61           C  
ATOM  10874  C   GLU E  97      11.062  -5.893 -10.536  1.00 45.23           C  
ATOM  10875  O   GLU E  97       9.912  -6.277 -10.756  1.00 46.21           O  
ATOM  10876  CB  GLU E  97      11.663  -6.906 -12.755  1.00 46.84           C  
ATOM  10877  CG  GLU E  97      12.569  -6.841 -13.977  1.00 48.49           C  
ATOM  10878  CD  GLU E  97      12.855  -5.407 -14.405  1.00 50.43           C  
ATOM  10879  OE1 GLU E  97      11.890  -4.677 -14.726  1.00 50.57           O  
ATOM  10880  OE2 GLU E  97      14.044  -5.008 -14.414  1.00 49.84           O  
ATOM  10881  N   GLY E  98      11.428  -5.323  -9.392  1.00 44.33           N  
ATOM  10882  CA  GLY E  98      10.469  -5.112  -8.321  1.00 43.35           C  
ATOM  10883  C   GLY E  98      10.011  -6.376  -7.616  1.00 41.88           C  
ATOM  10884  O   GLY E  98       9.017  -6.357  -6.890  1.00 42.74           O  
ATOM  10885  N   GLU E  99      10.731  -7.474  -7.819  1.00 41.07           N  
ATOM  10886  CA  GLU E  99      10.373  -8.740  -7.188  1.00 39.98           C  
ATOM  10887  C   GLU E  99      11.444  -9.144  -6.175  1.00 38.68           C  
ATOM  10888  O   GLU E  99      12.632  -9.160  -6.492  1.00 39.13           O  
ATOM  10889  CB  GLU E  99      10.227  -9.828  -8.250  1.00 41.09           C  
ATOM  10890  CG  GLU E  99       9.427 -11.029  -7.785  1.00 44.94           C  
ATOM  10891  CD  GLU E  99       7.955 -10.703  -7.609  1.00 47.35           C  
ATOM  10892  OE1 GLU E  99       7.641  -9.735  -6.884  1.00 47.40           O  
ATOM  10893  OE2 GLU E  99       7.113 -11.417  -8.198  1.00 50.27           O  
ATOM  10894  N   VAL E 100      11.027  -9.469  -4.955  1.00 37.42           N  
ATOM  10895  CA  VAL E 100      11.982  -9.858  -3.923  1.00 35.97           C  
ATOM  10896  C   VAL E 100      12.351 -11.334  -4.018  1.00 35.72           C  
ATOM  10897  O   VAL E 100      11.481 -12.200  -4.113  1.00 35.82           O  
ATOM  10898  CB  VAL E 100      11.429  -9.575  -2.505  1.00 35.91           C  
ATOM  10899  CG1 VAL E 100      12.448 -10.004  -1.449  1.00 36.04           C  
ATOM  10900  CG2 VAL E 100      11.113  -8.092  -2.358  1.00 35.08           C  
ATOM  10901  N   TYR E 101      13.648 -11.614  -4.006  1.00 33.97           N  
ATOM  10902  CA  TYR E 101      14.123 -12.988  -4.072  1.00 33.33           C  
ATOM  10903  C   TYR E 101      15.064 -13.259  -2.911  1.00 31.55           C  
ATOM  10904  O   TYR E 101      15.873 -12.409  -2.548  1.00 31.54           O  
ATOM  10905  CB  TYR E 101      14.869 -13.259  -5.383  1.00 34.26           C  
ATOM  10906  CG  TYR E 101      14.002 -13.226  -6.620  1.00 35.69           C  
ATOM  10907  CD1 TYR E 101      13.722 -12.024  -7.267  1.00 34.44           C  
ATOM  10908  CD2 TYR E 101      13.458 -14.399  -7.142  1.00 35.41           C  
ATOM  10909  CE1 TYR E 101      12.921 -11.990  -8.412  1.00 37.26           C  
ATOM  10910  CE2 TYR E 101      12.655 -14.376  -8.284  1.00 37.55           C  
ATOM  10911  CZ  TYR E 101      12.392 -13.170  -8.912  1.00 36.78           C  
ATOM  10912  OH  TYR E 101      11.603 -13.144 -10.040  1.00 38.99           O  
ATOM  10913  N   VAL E 102      14.951 -14.449  -2.334  1.00 31.02           N  
ATOM  10914  CA  VAL E 102      15.810 -14.831  -1.223  1.00 29.60           C  
ATOM  10915  C   VAL E 102      16.574 -16.092  -1.604  1.00 28.59           C  
ATOM  10916  O   VAL E 102      16.008 -17.022  -2.179  1.00 29.04           O  
ATOM  10917  CB  VAL E 102      14.986 -15.079   0.080  1.00 27.43           C  
ATOM  10918  CG1 VAL E 102      13.970 -16.198  -0.134  1.00 26.21           C  
ATOM  10919  CG2 VAL E 102      15.924 -15.410   1.231  1.00 27.17           C  
ATOM  10920  N   ALA E 103      17.865 -16.111  -1.291  1.00 29.83           N  
ATOM  10921  CA  ALA E 103      18.719 -17.251  -1.609  1.00 30.28           C  
ATOM  10922  C   ALA E 103      18.237 -18.530  -0.934  1.00 31.66           C  
ATOM  10923  O   ALA E 103      17.672 -18.490   0.158  1.00 32.15           O  
ATOM  10924  CB  ALA E 103      20.154 -16.950  -1.195  1.00 30.48           C  
ATOM  10925  N   GLY E 104      18.459 -19.664  -1.593  1.00 31.97           N  
ATOM  10926  CA  GLY E 104      18.048 -20.939  -1.038  1.00 32.59           C  
ATOM  10927  C   GLY E 104      19.115 -21.523  -0.133  1.00 32.64           C  
ATOM  10928  O   GLY E 104      18.869 -22.485   0.590  1.00 34.90           O  
ATOM  10929  N   GLU E 105      20.308 -20.942  -0.181  1.00 31.65           N  
ATOM  10930  CA  GLU E 105      21.425 -21.392   0.641  1.00 30.99           C  
ATOM  10931  C   GLU E 105      21.961 -20.187   1.389  1.00 30.21           C  
ATOM  10932  O   GLU E 105      21.974 -19.078   0.859  1.00 29.81           O  
ATOM  10933  CB  GLU E 105      22.538 -21.985  -0.227  1.00 31.31           C  
ATOM  10934  CG  GLU E 105      22.224 -23.341  -0.826  1.00 34.82           C  
ATOM  10935  CD  GLU E 105      22.031 -24.414   0.235  1.00 36.46           C  
ATOM  10936  OE1 GLU E 105      22.558 -24.250   1.361  1.00 35.97           O  
ATOM  10937  OE2 GLU E 105      21.367 -25.426  -0.068  1.00 37.25           O  
ATOM  10938  N   LYS E 106      22.406 -20.402   2.621  1.00 29.48           N  
ATOM  10939  CA  LYS E 106      22.929 -19.305   3.421  1.00 30.01           C  
ATOM  10940  C   LYS E 106      24.375 -19.006   3.060  1.00 30.50           C  
ATOM  10941  O   LYS E 106      25.070 -19.851   2.492  1.00 28.33           O  
ATOM  10942  CB  LYS E 106      22.845 -19.644   4.913  1.00 31.10           C  
ATOM  10943  CG  LYS E 106      23.801 -20.742   5.363  1.00 33.51           C  
ATOM  10944  CD  LYS E 106      23.718 -20.958   6.872  1.00 36.01           C  
ATOM  10945  CE  LYS E 106      24.771 -21.944   7.368  1.00 38.77           C  
ATOM  10946  NZ  LYS E 106      24.650 -23.288   6.729  1.00 40.06           N  
ATOM  10947  N   LYS E 107      24.815 -17.796   3.389  1.00 32.08           N  
ATOM  10948  CA  LYS E 107      26.189 -17.377   3.142  1.00 36.06           C  
ATOM  10949  C   LYS E 107      27.109 -18.245   3.993  1.00 37.05           C  
ATOM  10950  O   LYS E 107      26.769 -18.589   5.125  1.00 37.85           O  
ATOM  10951  CB  LYS E 107      26.377 -15.920   3.554  1.00 37.45           C  
ATOM  10952  CG  LYS E 107      25.538 -14.933   2.783  1.00 41.45           C  
ATOM  10953  CD  LYS E 107      26.038 -14.779   1.361  1.00 42.81           C  
ATOM  10954  CE  LYS E 107      25.395 -13.573   0.726  1.00 43.75           C  
ATOM  10955  NZ  LYS E 107      25.530 -12.393   1.626  1.00 45.25           N  
ATOM  10956  N   LEU E 108      28.277 -18.589   3.462  1.00 39.71           N  
ATOM  10957  CA  LEU E 108      29.215 -19.430   4.201  1.00 41.33           C  
ATOM  10958  C   LEU E 108      30.035 -18.650   5.228  1.00 43.59           C  
ATOM  10959  O   LEU E 108      29.740 -18.707   6.424  1.00 43.38           O  
ATOM  10960  CB  LEU E 108      30.141 -20.162   3.225  1.00 41.55           C  
ATOM  10961  CG  LEU E 108      29.462 -21.213   2.339  1.00 41.69           C  
ATOM  10962  CD1 LEU E 108      30.493 -21.852   1.422  1.00 41.75           C  
ATOM  10963  CD2 LEU E 108      28.796 -22.269   3.210  1.00 42.84           C  
ATOM  10964  N   GLU E 109      31.060 -17.939   4.755  1.00 45.60           N  
ATOM  10965  CA  GLU E 109      31.958 -17.126   5.589  1.00 48.00           C  
ATOM  10966  C   GLU E 109      33.422 -17.320   5.194  1.00 49.31           C  
ATOM  10967  O   GLU E 109      33.706 -18.160   4.310  1.00 50.07           O  
ATOM  10968  CB  GLU E 109      31.786 -17.458   7.081  1.00 48.76           C  
ATOM  10969  CG  GLU E 109      32.625 -16.619   8.032  1.00 47.89           C  
ATOM  10970  CD  GLU E 109      32.543 -15.134   7.733  1.00 49.02           C  
ATOM  10971  OE1 GLU E 109      31.415 -14.610   7.587  1.00 48.63           O  
ATOM  10972  OE2 GLU E 109      33.614 -14.491   7.651  1.00 48.57           O  
TER   10973      GLU E 109                                                      
END
MOLECULE T0391.pdb
ATOM      1  N   LYS    14      20.058 -27.031  -4.627  1.00 60.80           N  
ATOM      2  CA  LYS    14      18.878 -26.160  -4.323  1.00 60.75           C  
ATOM      3  C   LYS    14      19.298 -24.755  -3.828  1.00 60.82           C  
ATOM      4  O   LYS    14      18.794 -24.243  -2.809  1.00 60.89           O  
ATOM      5  CB  LYS    14      17.912 -26.875  -3.349  1.00 60.75           C  
ATOM      6  CG  LYS    14      18.148 -26.678  -1.832  1.00 60.46           C  
ATOM      7  CD  LYS    14      19.239 -27.549  -1.251  1.00 60.49           C  
ATOM      8  CE  LYS    14      19.374 -27.296   0.246  1.00 60.57           C  
ATOM      9  NZ  LYS    14      20.401 -28.172   0.889  1.00 60.29           N  
ATOM     10  N   TYR    15      20.208 -24.127  -4.570  1.00 60.44           N  
ATOM     11  CA  TYR    15      20.748 -22.827  -4.172  1.00 60.31           C  
ATOM     12  C   TYR    15      20.596 -21.697  -5.214  1.00 60.11           C  
ATOM     13  O   TYR    15      21.466 -20.821  -5.310  1.00 60.31           O  
ATOM     14  CB  TYR    15      22.220 -22.960  -3.731  1.00 60.66           C  
ATOM     15  CG  TYR    15      22.442 -23.716  -2.429  1.00 60.97           C  
ATOM     16  CD1 TYR    15      22.806 -25.063  -2.440  1.00 60.98           C  
ATOM     17  CD2 TYR    15      22.302 -23.081  -1.190  1.00 60.95           C  
ATOM     18  CE1 TYR    15      23.019 -25.762  -1.253  1.00 61.49           C  
ATOM     19  CE2 TYR    15      22.510 -23.773   0.005  1.00 60.54           C  
ATOM     20  CZ  TYR    15      22.870 -25.113  -0.036  1.00 61.22           C  
ATOM     21  OH  TYR    15      23.090 -25.813   1.132  1.00 61.20           O  
ATOM     22  N   THR    16      19.512 -21.700  -5.992  1.00 59.68           N  
ATOM     23  CA  THR    16      19.188 -20.514  -6.815  1.00 59.63           C  
ATOM     24  C   THR    16      17.836 -19.878  -6.426  1.00 58.97           C  
ATOM     25  O   THR    16      17.024 -20.493  -5.734  1.00 58.66           O  
ATOM     26  CB  THR    16      19.340 -20.760  -8.367  1.00 59.50           C  
ATOM     27  OG1 THR    16      20.712 -21.057  -8.684  1.00 60.71           O  
ATOM     28  CG2 THR    16      18.927 -19.524  -9.191  1.00 59.37           C  
ATOM     29  N   SER    17      17.657 -18.629  -6.856  1.00 59.10           N  
ATOM     30  CA  SER    17      16.500 -17.778  -6.591  1.00 59.12           C  
ATOM     31  C   SER    17      15.164 -18.496  -6.522  1.00 59.74           C  
ATOM     32  O   SER    17      14.808 -19.277  -7.416  1.00 58.25           O  
ATOM     33  CB  SER    17      16.366 -16.691  -7.673  1.00 59.23           C  
ATOM     34  OG  SER    17      17.578 -15.976  -7.871  1.00 60.17           O  
ATOM     35  N   VAL    18      14.428 -18.199  -5.452  1.00 59.57           N  
ATOM     36  CA  VAL    18      13.002 -18.454  -5.422  1.00 59.94           C  
ATOM     37  C   VAL    18      12.366 -17.085  -5.284  1.00 60.39           C  
ATOM     38  O   VAL    18      12.744 -16.309  -4.419  1.00 59.98           O  
ATOM     39  CB  VAL    18      12.613 -19.377  -4.253  1.00 59.90           C  
ATOM     40  CG1 VAL    18      11.086 -19.572  -4.178  1.00 59.62           C  
ATOM     41  CG2 VAL    18      13.318 -20.729  -4.393  1.00 59.73           C  
ATOM     42  N   CYS    19      11.436 -16.772  -6.177  1.00 62.03           N  
ATOM     43  CA  CYS    19      10.675 -15.546  -6.087  1.00 62.30           C  
ATOM     44  C   CYS    19       9.657 -15.686  -4.943  1.00 62.67           C  
ATOM     45  O   CYS    19       8.778 -16.538  -4.994  1.00 63.44           O  
ATOM     46  CB  CYS    19       9.969 -15.293  -7.396  1.00 62.62           C  
ATOM     47  SG  CYS    19       9.161 -13.703  -7.475  1.00 64.96           S  
ATOM     48  N   VAL    20       9.769 -14.851  -3.922  1.00 61.58           N  
ATOM     49  CA  VAL    20       8.958 -15.045  -2.708  1.00 61.49           C  
ATOM     50  C   VAL    20       7.766 -14.103  -2.702  1.00 62.35           C  
ATOM     51  O   VAL    20       6.872 -14.191  -1.856  1.00 63.15           O  
ATOM     52  CB  VAL    20       9.817 -14.911  -1.438  1.00 61.03           C  
ATOM     53  CG1 VAL    20      10.940 -15.911  -1.487  1.00 60.15           C  
ATOM     54  CG2 VAL    20      10.377 -13.514  -1.277  1.00 59.18           C  
ATOM     55  N   GLY    21       7.748 -13.211  -3.677  1.00 62.13           N  
ATOM     56  CA  GLY    21       6.681 -12.283  -3.790  1.00 62.19           C  
ATOM     57  C   GLY    21       7.038 -10.922  -4.329  1.00 62.64           C  
ATOM     58  O   GLY    21       8.104 -10.689  -4.947  1.00 62.35           O  
ATOM     59  N   ARG    22       6.090 -10.026  -4.089  1.00 62.17           N  
ATOM     60  CA  ARG    22       6.044  -8.731  -4.705  1.00 62.01           C  
ATOM     61  C   ARG    22       6.671  -7.685  -3.777  1.00 61.91           C  
ATOM     62  O   ARG    22       6.357  -7.629  -2.585  1.00 60.50           O  
ATOM     63  CB  ARG    22       4.576  -8.423  -4.962  1.00 62.52           C  
ATOM     64  CG  ARG    22       4.336  -7.596  -6.112  1.00 62.38           C  
ATOM     65  CD  ARG    22       2.862  -7.377  -6.307  1.00 63.37           C  
ATOM     66  NE  ARG    22       2.766  -6.247  -7.197  1.00 63.29           N  
ATOM     67  CZ  ARG    22       1.689  -5.863  -7.852  1.00 63.14           C  
ATOM     68  NH1 ARG    22       0.531  -6.515  -7.735  1.00 64.35           N  
ATOM     69  NH2 ARG    22       1.798  -4.807  -8.631  1.00 63.71           N  
ATOM     70  N   GLU    23       7.582  -6.874  -4.323  1.00 62.10           N  
ATOM     71  CA  GLU    23       8.103  -5.723  -3.602  1.00 62.33           C  
ATOM     72  C   GLU    23       6.970  -4.911  -2.955  1.00 62.52           C  
ATOM     73  O   GLU    23       7.045  -4.564  -1.781  1.00 63.44           O  
ATOM     74  CB  GLU    23       8.955  -4.850  -4.518  1.00 62.11           C  
ATOM     75  CG  GLU    23       9.910  -3.962  -3.752  1.00 63.73           C  
ATOM     76  CD  GLU    23      11.098  -3.492  -4.568  1.00 66.02           C  
ATOM     77  OE1 GLU    23      10.913  -3.119  -5.754  1.00 65.65           O  
ATOM     78  OE2 GLU    23      12.214  -3.482  -4.000  1.00 68.05           O  
ATOM     79  N   GLU    24       5.899  -4.665  -3.694  1.00 62.66           N  
ATOM     80  CA  GLU    24       4.773  -3.927  -3.141  1.00 63.27           C  
ATOM     81  C   GLU    24       4.077  -4.577  -1.938  1.00 63.16           C  
ATOM     82  O   GLU    24       3.586  -3.872  -1.053  1.00 63.14           O  
ATOM     83  CB  GLU    24       3.737  -3.650  -4.220  1.00 63.14           C  
ATOM     84  CG  GLU    24       4.183  -2.647  -5.259  1.00 65.00           C  
ATOM     85  CD  GLU    24       3.009  -2.112  -6.065  1.00 65.66           C  
ATOM     86  OE1 GLU    24       1.919  -2.735  -5.998  1.00 65.11           O  
ATOM     87  OE2 GLU    24       3.167  -1.071  -6.749  1.00 66.96           O  
ATOM     88  N   ASP    25       4.034  -5.902  -1.911  0.70 63.36           N  
ATOM     90  CA  ASP    25       3.305  -6.600  -0.868  0.70 63.79           C  
ATOM     92  C   ASP    25       4.028  -6.560   0.493  0.70 64.46           C  
ATOM     94  O   ASP    25       3.372  -6.638   1.542  0.70 64.77           O  
ATOM     96  CB  ASP    25       2.955  -8.031  -1.327  0.70 63.62           C  
ATOM     98  CG  ASP    25       1.892  -8.063  -2.468  0.70 63.86           C  
ATOM    100  OD1 ASP    25       1.400  -6.997  -2.932  0.70 61.48           O  
ATOM    102  OD2 ASP    25       1.538  -9.184  -2.900  0.70 64.42           O  
ATOM    104  N   ILE    26       5.358  -6.389   0.475  1.00 64.67           N  
ATOM    105  CA  ILE    26       6.187  -6.428   1.701  1.00 65.33           C  
ATOM    106  C   ILE    26       6.448  -5.038   2.254  1.00 66.28           C  
ATOM    107  O   ILE    26       6.715  -4.879   3.435  1.00 65.81           O  
ATOM    108  CB  ILE    26       7.568  -7.115   1.511  1.00 65.79           C  
ATOM    109  CG1 ILE    26       8.114  -7.590   2.873  1.00 65.49           C  
ATOM    110  CG2 ILE    26       8.578  -6.164   0.865  1.00 65.24           C  
ATOM    111  CD1 ILE    26       9.526  -8.114   2.841  1.00 64.46           C  
ATOM    112  N   ARG    27       6.376  -4.026   1.393  1.00 67.72           N  
ATOM    113  CA  ARG    27       6.661  -2.672   1.844  1.00 68.35           C  
ATOM    114  C   ARG    27       5.635  -2.232   2.887  1.00 68.20           C  
ATOM    115  O   ARG    27       6.004  -1.667   3.921  1.00 68.03           O  
ATOM    116  CB  ARG    27       6.823  -1.716   0.661  1.00 68.79           C  
ATOM    117  CG  ARG    27       8.136  -2.014  -0.065  1.00 70.71           C  
ATOM    118  CD  ARG    27       8.676  -0.888  -0.957  1.00 74.28           C  
ATOM    119  NE  ARG    27      10.113  -1.118  -1.136  1.00 76.73           N  
ATOM    120  CZ  ARG    27      10.900  -0.543  -2.046  1.00 77.51           C  
ATOM    121  NH1 ARG    27      10.418   0.335  -2.925  1.00 77.15           N  
ATOM    122  NH2 ARG    27      12.190  -0.862  -2.073  1.00 77.51           N  
ATOM    123  N   LYS    28       4.372  -2.577   2.641  1.00 68.05           N  
ATOM    124  CA  LYS    28       3.278  -2.331   3.573  1.00 67.84           C  
ATOM    125  C   LYS    28       3.515  -2.907   4.993  1.00 67.37           C  
ATOM    126  O   LYS    28       3.664  -2.148   5.957  1.00 67.14           O  
ATOM    127  CB  LYS    28       1.968  -2.845   2.957  1.00 68.52           C  
ATOM    128  CG  LYS    28       0.709  -2.558   3.781  1.00 69.95           C  
ATOM    129  CD  LYS    28      -0.479  -2.274   2.855  1.00 72.90           C  
ATOM    130  CE  LYS    28      -1.783  -2.048   3.625  1.00 74.32           C  
ATOM    131  NZ  LYS    28      -2.286  -3.344   4.158  1.00 76.24           N  
ATOM    132  N   SER    29       3.569  -4.235   5.119  1.00 66.72           N  
ATOM    133  CA  SER    29       3.748  -4.885   6.425  1.00 66.15           C  
ATOM    134  C   SER    29       5.187  -4.873   6.935  1.00 64.97           C  
ATOM    135  O   SER    29       5.459  -5.154   8.118  1.00 65.03           O  
ATOM    136  CB  SER    29       3.311  -6.336   6.336  1.00 66.89           C  
ATOM    137  OG  SER    29       4.355  -7.108   5.765  1.00 69.45           O  
ATOM    138  N   GLU    30       6.122  -4.606   6.034  1.00 62.79           N  
ATOM    139  CA  GLU    30       7.546  -4.652   6.367  1.00 60.91           C  
ATOM    140  C   GLU    30       8.128  -6.009   6.779  1.00 58.63           C  
ATOM    141  O   GLU    30       9.300  -6.064   7.176  1.00 57.90           O  
ATOM    142  CB  GLU    30       7.939  -3.541   7.349  1.00 61.73           C  
ATOM    143  CG  GLU    30       8.166  -2.226   6.596  1.00 64.11           C  
ATOM    144  CD  GLU    30       8.775  -1.124   7.442  1.00 68.01           C  
ATOM    145  OE1 GLU    30       8.252  -0.881   8.554  1.00 68.86           O  
ATOM    146  OE2 GLU    30       9.756  -0.484   6.970  1.00 69.07           O  
ATOM    147  N   ARG    31       7.333  -7.073   6.654  1.00 55.43           N  
ATOM    148  CA  ARG    31       7.814  -8.461   6.773  1.00 54.94           C  
ATOM    149  C   ARG    31       6.873  -9.468   6.122  1.00 55.34           C  
ATOM    150  O   ARG    31       5.669  -9.251   6.054  1.00 53.56           O  
ATOM    151  CB  ARG    31       8.017  -8.868   8.213  1.00 53.83           C  
ATOM    152  CG  ARG    31       6.689  -9.135   8.913  1.00 56.18           C  
ATOM    153  CD  ARG    31       6.870  -9.241  10.351  1.00 54.41           C  
ATOM    154  NE  ARG    31       7.484  -8.051  10.931  1.00 47.57           N  
ATOM    155  CZ  ARG    31       7.953  -8.038  12.168  1.00 43.51           C  
ATOM    156  NH1 ARG    31       7.864  -9.153  12.893  1.00 42.00           N  
ATOM    157  NH2 ARG    31       8.477  -6.939  12.679  1.00 40.05           N  
ATOM    158  N   MET    32       7.432 -10.587   5.679  1.00 57.33           N  
ATOM    159  CA  MET    32       6.647 -11.708   5.128  1.00 60.41           C  
ATOM    160  C   MET    32       7.435 -12.995   5.296  1.00 59.05           C  
ATOM    161  O   MET    32       8.664 -12.974   5.342  1.00 60.30           O  
ATOM    162  CB  MET    32       6.358 -11.492   3.619  1.00 59.37           C  
ATOM    163  CG  MET    32       7.571 -11.596   2.693  1.00 63.82           C  
ATOM    164  SD  MET    32       7.112 -11.204   0.978  1.00 69.27           S  
ATOM    165  CE  MET    32       5.647 -10.216   1.194  1.00 68.77           C  
ATOM    166  N   THR    33       6.752 -14.125   5.326  1.00 57.39           N  
ATOM    167  CA  THR    33       7.468 -15.385   5.383  1.00 55.82           C  
ATOM    168  C   THR    33       7.420 -16.058   3.993  1.00 56.31           C  
ATOM    169  O   THR    33       6.532 -15.751   3.131  1.00 54.99           O  
ATOM    170  CB  THR    33       6.882 -16.321   6.457  1.00 56.65           C  
ATOM    171  OG1 THR    33       5.603 -16.815   5.987  1.00 56.10           O  
ATOM    172  CG2 THR    33       6.697 -15.553   7.836  1.00 55.74           C  
ATOM    173  N   ALA    34       8.335 -16.989   3.761  1.00 54.34           N  
ATOM    174  CA  ALA    34       8.184 -17.826   2.570  1.00 54.83           C  
ATOM    175  C   ALA    34       8.807 -19.181   2.790  1.00 53.98           C  
ATOM    176  O   ALA    34       9.635 -19.352   3.681  1.00 53.23           O  
ATOM    177  CB  ALA    34       8.816 -17.148   1.365  1.00 55.64           C  
ATOM    178  N   VAL    35       8.422 -20.150   1.969  1.00 52.71           N  
ATOM    179  CA  VAL    35       9.146 -21.419   1.963  1.00 51.53           C  
ATOM    180  C   VAL    35      10.059 -21.440   0.736  1.00 50.48           C  
ATOM    181  O   VAL    35       9.597 -21.267  -0.405  1.00 50.86           O  
ATOM    182  CB  VAL    35       8.199 -22.656   2.139  1.00 51.55           C  
ATOM    183  CG1 VAL    35       8.927 -23.938   1.867  1.00 51.62           C  
ATOM    184  CG2 VAL    35       7.649 -22.678   3.595  1.00 51.89           C  
ATOM    185  N   VAL    36      11.358 -21.607   0.993  1.00 47.93           N  
ATOM    186  CA  VAL    36      12.369 -21.552  -0.052  1.00 46.54           C  
ATOM    187  C   VAL    36      13.108 -22.885  -0.044  1.00 46.09           C  
ATOM    188  O   VAL    36      13.795 -23.191   0.917  1.00 45.92           O  
ATOM    189  CB  VAL    36      13.329 -20.352   0.148  1.00 46.45           C  
ATOM    190  CG1 VAL    36      14.517 -20.414  -0.842  1.00 45.45           C  
ATOM    191  CG2 VAL    36      12.561 -19.045  -0.018  1.00 43.17           C  
ATOM    192  N   HIS    37      12.900 -23.698  -1.086  1.00 45.65           N  
ATOM    193  CA  HIS    37      13.449 -25.056  -1.162  1.00 45.17           C  
ATOM    194  C   HIS    37      13.275 -25.825   0.164  1.00 45.04           C  
ATOM    195  O   HIS    37      14.256 -26.313   0.741  1.00 45.28           O  
ATOM    196  CB  HIS    37      14.941 -25.015  -1.540  1.00 45.31           C  
ATOM    197  CG  HIS    37      15.243 -24.292  -2.824  1.00 45.88           C  
ATOM    198  ND1 HIS    37      14.568 -24.534  -4.004  1.00 46.39           N  
ATOM    199  CD2 HIS    37      16.190 -23.367  -3.117  1.00 46.19           C  
ATOM    200  CE1 HIS    37      15.074 -23.775  -4.962  1.00 46.61           C  
ATOM    201  NE2 HIS    37      16.058 -23.055  -4.449  1.00 45.87           N  
ATOM    202  N   ASP    38      12.041 -25.892   0.661  1.00 44.85           N  
ATOM    203  CA  ASP    38      11.706 -26.553   1.941  1.00 45.31           C  
ATOM    204  C   ASP    38      12.339 -25.925   3.206  1.00 45.08           C  
ATOM    205  O   ASP    38      12.315 -26.535   4.284  1.00 45.02           O  
ATOM    206  CB  ASP    38      12.026 -28.055   1.910  1.00 45.77           C  
ATOM    207  CG  ASP    38      11.383 -28.776   0.726  1.00 49.13           C  
ATOM    208  OD1 ASP    38      10.128 -28.791   0.650  1.00 51.40           O  
ATOM    209  OD2 ASP    38      12.135 -29.334  -0.124  1.00 51.32           O  
ATOM    210  N   ARG    39      12.917 -24.729   3.081  1.00 43.95           N  
ATOM    211  CA  ARG    39      13.413 -24.021   4.257  1.00 43.30           C  
ATOM    212  C   ARG    39      12.521 -22.812   4.452  1.00 42.56           C  
ATOM    213  O   ARG    39      12.335 -22.011   3.534  1.00 42.90           O  
ATOM    214  CB  ARG    39      14.865 -23.605   4.108  1.00 43.37           C  
ATOM    215  CG  ARG    39      15.608 -23.594   5.429  1.00 43.77           C  
ATOM    216  CD  ARG    39      17.029 -23.142   5.261  1.00 45.03           C  
ATOM    217  NE  ARG    39      17.674 -23.029   6.560  1.00 45.90           N  
ATOM    218  CZ  ARG    39      18.700 -23.769   6.945  1.00 43.80           C  
ATOM    219  NH1 ARG    39      19.211 -24.648   6.103  1.00 43.43           N  
ATOM    220  NH2 ARG    39      19.216 -23.604   8.157  1.00 40.35           N  
ATOM    221  N   GLU    40      11.915 -22.727   5.625  1.00 41.87           N  
ATOM    222  CA  GLU    40      11.019 -21.619   5.932  1.00 40.70           C  
ATOM    223  C   GLU    40      11.814 -20.418   6.451  1.00 40.21           C  
ATOM    224  O   GLU    40      12.671 -20.553   7.321  1.00 39.91           O  
ATOM    225  CB  GLU    40       9.926 -22.041   6.911  1.00 41.02           C  
ATOM    226  CG  GLU    40       8.775 -21.074   6.870  1.00 41.02           C  
ATOM    227  CD  GLU    40       7.670 -21.402   7.819  1.00 45.48           C  
ATOM    228  OE1 GLU    40       7.862 -22.213   8.771  1.00 46.20           O  
ATOM    229  OE2 GLU    40       6.581 -20.845   7.575  1.00 44.48           O  
ATOM    230  N   VAL    41      11.578 -19.259   5.838  1.00 39.09           N  
ATOM    231  CA  VAL    41      12.354 -18.057   6.115  1.00 37.88           C  
ATOM    232  C   VAL    41      11.436 -16.887   6.414  1.00 37.27           C  
ATOM    233  O   VAL    41      10.267 -16.869   6.008  1.00 36.57           O  
ATOM    234  CB  VAL    41      13.326 -17.655   4.896  1.00 37.87           C  
ATOM    235  CG1 VAL    41      14.182 -18.804   4.466  1.00 36.47           C  
ATOM    236  CG2 VAL    41      12.531 -17.210   3.656  1.00 38.60           C  
ATOM    237  N   VAL    42      11.998 -15.867   7.049  1.00 36.63           N  
ATOM    238  CA  VAL    42      11.308 -14.631   7.203  1.00 35.76           C  
ATOM    239  C   VAL    42      12.103 -13.576   6.456  1.00 36.42           C  
ATOM    240  O   VAL    42      13.302 -13.561   6.538  1.00 34.56           O  
ATOM    241  CB  VAL    42      11.050 -14.279   8.729  1.00 36.00           C  
ATOM    242  CG1 VAL    42      12.356 -14.284   9.550  1.00 31.47           C  
ATOM    243  CG2 VAL    42      10.244 -12.935   8.858  1.00 36.12           C  
ATOM    244  N   ILE    43      11.423 -12.711   5.705  1.00 36.07           N  
ATOM    245  CA  ILE    43      12.088 -11.573   5.057  1.00 35.72           C  
ATOM    246  C   ILE    43      11.611 -10.312   5.753  1.00 35.08           C  
ATOM    247  O   ILE    43      10.425 -10.130   5.901  1.00 34.92           O  
ATOM    248  CB  ILE    43      11.748 -11.420   3.540  1.00 36.04           C  
ATOM    249  CG1 ILE    43      12.131 -12.678   2.760  1.00 38.38           C  
ATOM    250  CG2 ILE    43      12.503 -10.221   2.900  1.00 35.84           C  
ATOM    251  CD1 ILE    43      10.953 -13.665   2.645  1.00 41.98           C  
ATOM    252  N   PHE    44      12.540  -9.455   6.170  1.00 35.27           N  
ATOM    253  CA  PHE    44      12.207  -8.159   6.750  1.00 35.90           C  
ATOM    254  C   PHE    44      12.611  -7.070   5.764  1.00 36.03           C  
ATOM    255  O   PHE    44      13.695  -7.104   5.206  1.00 36.06           O  
ATOM    256  CB  PHE    44      12.996  -7.939   8.051  1.00 35.55           C  
ATOM    257  CG  PHE    44      12.675  -8.944   9.149  1.00 35.15           C  
ATOM    258  CD1 PHE    44      11.461  -8.863   9.856  1.00 33.52           C  
ATOM    259  CD2 PHE    44      13.555  -9.953   9.456  1.00 35.10           C  
ATOM    260  CE1 PHE    44      11.145  -9.775  10.840  1.00 31.22           C  
ATOM    261  CE2 PHE    44      13.260 -10.834  10.490  1.00 33.69           C  
ATOM    262  CZ  PHE    44      12.043 -10.747  11.155  1.00 34.12           C  
ATOM    263  N   TYR    45      11.744  -6.094   5.576  1.00 36.13           N  
ATOM    264  CA  TYR    45      12.120  -4.861   4.896  1.00 37.49           C  
ATOM    265  C   TYR    45      12.253  -3.757   5.917  1.00 37.07           C  
ATOM    266  O   TYR    45      11.271  -3.380   6.534  1.00 38.99           O  
ATOM    267  CB  TYR    45      11.055  -4.484   3.898  1.00 36.98           C  
ATOM    268  CG  TYR    45      11.334  -3.182   3.158  1.00 39.78           C  
ATOM    269  CD1 TYR    45      12.338  -3.109   2.209  1.00 40.79           C  
ATOM    270  CD2 TYR    45      10.595  -2.037   3.421  1.00 38.05           C  
ATOM    271  CE1 TYR    45      12.605  -1.935   1.531  1.00 41.88           C  
ATOM    272  CE2 TYR    45      10.858  -0.857   2.763  1.00 41.50           C  
ATOM    273  CZ  TYR    45      11.862  -0.805   1.807  1.00 40.93           C  
ATOM    274  OH  TYR    45      12.120   0.387   1.114  1.00 40.29           O  
ATOM    275  N   HIS    46      13.443  -3.229   6.111  1.00 36.34           N  
ATOM    276  CA  HIS    46      13.652  -2.224   7.156  1.00 36.95           C  
ATOM    277  C   HIS    46      14.640  -1.131   6.693  1.00 37.04           C  
ATOM    278  O   HIS    46      15.718  -1.438   6.160  1.00 36.11           O  
ATOM    279  CB  HIS    46      14.162  -2.927   8.432  1.00 37.03           C  
ATOM    280  CG  HIS    46      14.389  -2.016   9.605  1.00 38.48           C  
ATOM    281  ND1 HIS    46      13.356  -1.460  10.337  1.00 40.30           N  
ATOM    282  CD2 HIS    46      15.530  -1.603  10.200  1.00 36.98           C  
ATOM    283  CE1 HIS    46      13.855  -0.725  11.315  1.00 38.56           C  
ATOM    284  NE2 HIS    46      15.171  -0.791  11.249  1.00 38.82           N  
ATOM    285  N   LYS    47      14.275   0.138   6.920  1.00 36.95           N  
ATOM    286  CA  LYS    47      15.099   1.269   6.525  1.00 37.47           C  
ATOM    287  C   LYS    47      15.604   1.065   5.095  1.00 37.40           C  
ATOM    288  O   LYS    47      16.817   1.170   4.821  1.00 36.64           O  
ATOM    289  CB  LYS    47      16.293   1.452   7.465  1.00 38.17           C  
ATOM    290  CG  LYS    47      15.974   1.813   8.904  1.00 40.46           C  
ATOM    291  CD  LYS    47      17.211   2.484   9.503  1.00 45.27           C  
ATOM    292  CE  LYS    47      17.181   2.580  11.022  1.00 47.38           C  
ATOM    293  NZ  LYS    47      17.861   1.421  11.685  1.00 50.94           N  
ATOM    294  N   GLY    48      14.674   0.731   4.194  1.00 37.40           N  
ATOM    295  CA  GLY    48      15.000   0.560   2.776  1.00 37.40           C  
ATOM    296  C   GLY    48      15.856  -0.636   2.402  1.00 37.80           C  
ATOM    297  O   GLY    48      16.304  -0.738   1.278  1.00 38.04           O  
ATOM    298  N   GLU    49      16.085  -1.556   3.336  1.00 38.38           N  
ATOM    299  CA  GLU    49      16.829  -2.797   3.029  1.00 38.96           C  
ATOM    300  C   GLU    49      16.071  -4.079   3.366  1.00 37.40           C  
ATOM    301  O   GLU    49      15.276  -4.102   4.272  1.00 37.65           O  
ATOM    302  CB  GLU    49      18.154  -2.817   3.788  1.00 38.83           C  
ATOM    303  CG  GLU    49      18.937  -1.583   3.524  1.00 43.50           C  
ATOM    304  CD  GLU    49      20.402  -1.850   3.556  1.00 48.39           C  
ATOM    305  OE1 GLU    49      20.835  -2.546   4.503  1.00 49.17           O  
ATOM    306  OE2 GLU    49      21.094  -1.373   2.622  1.00 51.30           O  
ATOM    307  N   TYR    50      16.403  -5.145   2.652  1.00 37.51           N  
ATOM    308  CA  TYR    50      15.783  -6.447   2.770  1.00 37.42           C  
ATOM    309  C   TYR    50      16.698  -7.402   3.513  1.00 37.93           C  
ATOM    310  O   TYR    50      17.897  -7.407   3.283  1.00 36.23           O  
ATOM    311  CB  TYR    50      15.475  -6.971   1.367  1.00 38.36           C  
ATOM    312  CG  TYR    50      14.401  -6.171   0.692  1.00 38.71           C  
ATOM    313  CD1 TYR    50      13.052  -6.451   0.947  1.00 41.30           C  
ATOM    314  CD2 TYR    50      14.714  -5.109  -0.176  1.00 39.45           C  
ATOM    315  CE1 TYR    50      12.043  -5.728   0.367  1.00 39.50           C  
ATOM    316  CE2 TYR    50      13.689  -4.361  -0.778  1.00 41.37           C  
ATOM    317  CZ  TYR    50      12.347  -4.688  -0.495  1.00 41.85           C  
ATOM    318  OH  TYR    50      11.300  -3.995  -1.058  1.00 39.83           O  
ATOM    319  N   HIS    51      16.156  -8.162   4.451  1.00 37.00           N  
ATOM    320  CA  HIS    51      16.962  -9.128   5.154  1.00 37.66           C  
ATOM    321  C   HIS    51      16.187 -10.409   5.256  1.00 38.22           C  
ATOM    322  O   HIS    51      15.034 -10.396   5.749  1.00 40.63           O  
ATOM    323  CB  HIS    51      17.362  -8.635   6.576  1.00 38.17           C  
ATOM    324  CG  HIS    51      17.992  -7.280   6.598  1.00 36.35           C  
ATOM    325  ND1 HIS    51      19.324  -7.072   6.311  1.00 36.15           N  
ATOM    326  CD2 HIS    51      17.462  -6.060   6.834  1.00 36.39           C  
ATOM    327  CE1 HIS    51      19.587  -5.780   6.377  1.00 36.16           C  
ATOM    328  NE2 HIS    51      18.475  -5.144   6.699  1.00 36.78           N  
ATOM    329  N   ALA    52      16.783 -11.510   4.813  1.00 36.23           N  
ATOM    330  CA  ALA    52      16.191 -12.852   4.974  1.00 35.83           C  
ATOM    331  C   ALA    52      16.956 -13.725   5.994  1.00 35.84           C  
ATOM    332  O   ALA    52      18.162 -13.772   5.971  1.00 35.96           O  
ATOM    333  CB  ALA    52      16.112 -13.564   3.635  1.00 34.44           C  
ATOM    334  N   MET    53      16.230 -14.425   6.860  1.00 35.98           N  
ATOM    335  CA  MET    53      16.856 -15.383   7.786  1.00 35.97           C  
ATOM    336  C   MET    53      15.895 -16.513   8.097  1.00 34.34           C  
ATOM    337  O   MET    53      14.698 -16.423   7.816  1.00 34.06           O  
ATOM    338  CB  MET    53      17.275 -14.682   9.102  1.00 34.38           C  
ATOM    339  CG  MET    53      16.059 -14.042   9.793  1.00 36.38           C  
ATOM    340  SD  MET    53      16.365 -13.290  11.396  1.00 37.83           S  
ATOM    341  CE  MET    53      17.224 -11.779  10.901  1.00 31.98           C  
ATOM    342  N   ASP    54      16.437 -17.570   8.692  1.00 35.49           N  
ATOM    343  CA  ASP    54      15.663 -18.709   9.166  1.00 35.03           C  
ATOM    344  C   ASP    54      14.594 -18.178  10.077  1.00 35.41           C  
ATOM    345  O   ASP    54      14.838 -17.266  10.883  1.00 36.46           O  
ATOM    346  CB  ASP    54      16.555 -19.680   9.974  1.00 36.35           C  
ATOM    347  CG  ASP    54      17.394 -20.595   9.089  1.00 37.52           C  
ATOM    348  OD1 ASP    54      17.092 -20.730   7.865  1.00 42.19           O  
ATOM    349  OD2 ASP    54      18.379 -21.187   9.608  1.00 36.00           O  
ATOM    350  N   ILE    55      13.400 -18.736   9.977  1.00 33.76           N  
ATOM    351  CA  ILE    55      12.271 -18.163  10.687  1.00 33.72           C  
ATOM    352  C   ILE    55      12.256 -18.488  12.189  1.00 34.09           C  
ATOM    353  O   ILE    55      11.846 -17.651  12.987  1.00 35.22           O  
ATOM    354  CB  ILE    55      10.909 -18.575  10.023  1.00 32.75           C  
ATOM    355  CG1 ILE    55       9.729 -17.838  10.671  1.00 34.08           C  
ATOM    356  CG2 ILE    55      10.649 -20.098  10.162  1.00 32.55           C  
ATOM    357  CD1 ILE    55       8.426 -17.928   9.803  1.00 33.04           C  
ATOM    358  N   ARG    56      12.676 -19.701  12.554  1.00 34.32           N  
ATOM    359  CA  ARG    56      12.678 -20.122  13.949  0.50 34.27           C  
ATOM    361  C   ARG    56      13.979 -19.728  14.679  1.00 35.02           C  
ATOM    362  O   ARG    56      15.105 -19.999  14.216  1.00 34.05           O  
ATOM    363  CB  ARG    56      12.392 -21.611  14.064  0.50 33.71           C  
ATOM    365  CG  ARG    56      11.174 -22.056  13.253  0.50 33.20           C  
ATOM    367  CD  ARG    56       9.863 -21.458  13.767  0.50 34.41           C  
ATOM    369  NE  ARG    56       8.811 -21.580  12.749  0.50 33.94           N  
ATOM    371  CZ  ARG    56       7.540 -21.219  12.904  0.50 33.39           C  
ATOM    373  NH1 ARG    56       7.124 -20.701  14.053  0.50 33.15           N  
ATOM    375  NH2 ARG    56       6.684 -21.388  11.901  0.50 30.53           N  
ATOM    377  N   CYS    57      13.782 -19.059  15.804  1.00 34.89           N  
ATOM    378  CA  CYS    57      14.857 -18.517  16.622  1.00 34.84           C  
ATOM    379  C   CYS    57      15.820 -19.605  17.046  1.00 35.33           C  
ATOM    380  O   CYS    57      15.405 -20.619  17.585  1.00 34.76           O  
ATOM    381  CB  CYS    57      14.258 -17.828  17.853  1.00 35.43           C  
ATOM    382  SG  CYS    57      15.469 -17.137  18.937  1.00 35.67           S  
ATOM    383  N   TYR    58      17.109 -19.375  16.835  1.00 33.56           N  
ATOM    384  CA  TYR    58      18.141 -20.335  17.256  1.00 34.44           C  
ATOM    385  C   TYR    58      18.123 -20.742  18.712  1.00 34.87           C  
ATOM    386  O   TYR    58      18.677 -21.797  19.032  1.00 35.22           O  
ATOM    387  CB  TYR    58      19.564 -19.805  16.955  1.00 32.35           C  
ATOM    388  CG  TYR    58      20.078 -18.730  17.956  1.00 32.86           C  
ATOM    389  CD1 TYR    58      19.791 -17.386  17.764  1.00 32.31           C  
ATOM    390  CD2 TYR    58      20.892 -19.078  19.025  1.00 26.69           C  
ATOM    391  CE1 TYR    58      20.280 -16.385  18.653  1.00 36.22           C  
ATOM    392  CE2 TYR    58      21.337 -18.112  19.962  1.00 32.60           C  
ATOM    393  CZ  TYR    58      21.100 -16.767  19.710  1.00 32.41           C  
ATOM    394  OH  TYR    58      21.552 -15.812  20.596  1.00 35.59           O  
ATOM    395  N   HIS    59      17.583 -19.901  19.596  1.00 34.43           N  
ATOM    396  CA  HIS    59      17.668 -20.152  21.034  1.00 33.97           C  
ATOM    397  C   HIS    59      16.815 -21.395  21.360  1.00 34.28           C  
ATOM    398  O   HIS    59      17.331 -22.404  21.833  1.00 33.47           O  
ATOM    399  CB  HIS    59      17.194 -18.912  21.838  1.00 34.01           C  
ATOM    400  CG  HIS    59      17.046 -19.170  23.316  1.00 31.90           C  
ATOM    401  ND1 HIS    59      15.913 -18.854  24.030  1.00 32.75           N  
ATOM    402  CD2 HIS    59      17.922 -19.688  24.212  1.00 31.88           C  
ATOM    403  CE1 HIS    59      16.070 -19.221  25.292  1.00 36.93           C  
ATOM    404  NE2 HIS    59      17.286 -19.723  25.432  1.00 36.41           N  
ATOM    405  N   SER    60      15.504 -21.309  21.140  1.00 34.09           N  
ATOM    406  CA  SER    60      14.580 -22.404  21.464  1.00 35.56           C  
ATOM    407  C   SER    60      13.520 -22.620  20.402  1.00 35.00           C  
ATOM    408  O   SER    60      12.473 -23.273  20.676  1.00 34.15           O  
ATOM    409  CB  SER    60      13.793 -22.101  22.766  1.00 35.66           C  
ATOM    410  OG  SER    60      14.529 -22.465  23.868  1.00 40.94           O  
ATOM    411  N   GLY    61      13.725 -22.050  19.227  1.00 33.78           N  
ATOM    412  CA  GLY    61      12.734 -22.180  18.151  1.00 33.83           C  
ATOM    413  C   GLY    61      11.537 -21.216  18.082  1.00 33.58           C  
ATOM    414  O   GLY    61      10.581 -21.489  17.382  1.00 33.89           O  
ATOM    415  N   GLY    62      11.592 -20.060  18.752  1.00 34.29           N  
ATOM    416  CA  GLY    62      10.503 -19.064  18.703  1.00 33.30           C  
ATOM    417  C   GLY    62      10.292 -18.403  17.339  1.00 34.18           C  
ATOM    418  O   GLY    62      11.131 -18.485  16.449  1.00 34.46           O  
ATOM    419  N   PRO    63       9.131 -17.779  17.156  1.00 34.28           N  
ATOM    420  CA  PRO    63       8.647 -17.233  15.855  1.00 34.13           C  
ATOM    421  C   PRO    63       9.249 -15.820  15.609  1.00 35.32           C  
ATOM    422  O   PRO    63       8.683 -14.844  16.083  1.00 35.94           O  
ATOM    423  CB  PRO    63       7.098 -17.165  16.070  1.00 34.92           C  
ATOM    424  CG  PRO    63       6.909 -17.071  17.597  1.00 34.02           C  
ATOM    425  CD  PRO    63       8.162 -17.613  18.267  1.00 32.77           C  
ATOM    426  N   LEU    64      10.409 -15.724  14.939  1.00 33.85           N  
ATOM    427  CA  LEU    64      11.035 -14.426  14.722  1.00 35.10           C  
ATOM    428  C   LEU    64      10.190 -13.455  13.888  1.00 35.51           C  
ATOM    429  O   LEU    64      10.282 -12.231  14.090  1.00 35.60           O  
ATOM    430  CB  LEU    64      12.420 -14.584  14.076  1.00 33.19           C  
ATOM    431  CG  LEU    64      13.471 -15.228  14.956  1.00 33.67           C  
ATOM    432  CD1 LEU    64      14.780 -15.303  14.169  1.00 31.32           C  
ATOM    433  CD2 LEU    64      13.683 -14.567  16.368  1.00 32.77           C  
ATOM    434  N   HIS    65       9.310 -14.009  13.014  1.00 36.13           N  
ATOM    435  CA  HIS    65       8.382 -13.207  12.206  1.00 35.49           C  
ATOM    436  C   HIS    65       7.333 -12.496  13.062  1.00 36.08           C  
ATOM    437  O   HIS    65       6.658 -11.607  12.549  1.00 36.02           O  
ATOM    438  CB  HIS    65       7.719 -14.047  11.080  1.00 34.87           C  
ATOM    439  CG  HIS    65       6.740 -15.075  11.579  1.00 34.80           C  
ATOM    440  ND1 HIS    65       7.104 -16.108  12.425  1.00 32.82           N  
ATOM    441  CD2 HIS    65       5.425 -15.270  11.294  1.00 35.42           C  
ATOM    442  CE1 HIS    65       6.030 -16.818  12.735  1.00 35.35           C  
ATOM    443  NE2 HIS    65       5.003 -16.349  12.044  1.00 34.51           N  
ATOM    444  N   LEU    66       7.226 -12.856  14.351  1.00 35.16           N  
ATOM    445  CA  LEU    66       6.321 -12.166  15.276  1.00 34.56           C  
ATOM    446  C   LEU    66       7.126 -11.259  16.209  1.00 34.99           C  
ATOM    447  O   LEU    66       6.571 -10.695  17.130  1.00 34.13           O  
ATOM    448  CB  LEU    66       5.499 -13.148  16.118  1.00 35.06           C  
ATOM    449  CG  LEU    66       4.672 -14.209  15.366  1.00 36.17           C  
ATOM    450  CD1 LEU    66       3.790 -14.925  16.316  1.00 36.21           C  
ATOM    451  CD2 LEU    66       3.919 -13.613  14.176  1.00 33.70           C  
ATOM    452  N   GLY    67       8.431 -11.107  15.993  1.00 32.27           N  
ATOM    453  CA  GLY    67       9.167 -10.210  16.887  1.00 33.66           C  
ATOM    454  C   GLY    67       9.179  -8.750  16.492  1.00 34.02           C  
ATOM    455  O   GLY    67       8.704  -8.397  15.403  1.00 34.86           O  
ATOM    456  N   GLU    68       9.706  -7.884  17.364  1.00 34.92           N  
ATOM    457  CA  GLU    68       9.815  -6.470  17.032  0.50 34.77           C  
ATOM    459  C   GLU    68      11.234  -6.174  16.546  1.00 36.04           C  
ATOM    460  O   GLU    68      12.222  -6.826  16.990  1.00 34.69           O  
ATOM    461  CB  GLU    68       9.482  -5.582  18.246  0.50 34.98           C  
ATOM    463  CG  GLU    68       8.148  -5.870  18.980  0.50 33.52           C  
ATOM    465  CD  GLU    68       6.963  -5.201  18.371  0.50 31.29           C  
ATOM    467  OE1 GLU    68       6.995  -4.840  17.191  0.50 32.99           O  
ATOM    469  OE2 GLU    68       5.968  -5.014  19.089  0.50 35.61           O  
ATOM    471  N   ILE    69      11.358  -5.184  15.662  1.00 36.24           N  
ATOM    472  CA  ILE    69      12.690  -4.749  15.196  1.00 39.01           C  
ATOM    473  C   ILE    69      13.122  -3.516  16.002  1.00 40.20           C  
ATOM    474  O   ILE    69      12.326  -2.588  16.158  1.00 38.19           O  
ATOM    475  CB  ILE    69      12.670  -4.427  13.673  1.00 39.84           C  
ATOM    476  CG1 ILE    69      12.411  -5.733  12.873  1.00 41.79           C  
ATOM    477  CG2 ILE    69      14.002  -3.705  13.233  1.00 39.07           C  
ATOM    478  CD1 ILE    69      12.138  -5.498  11.381  1.00 39.19           C  
ATOM    479  N   GLU    70      14.336  -3.532  16.564  1.00 40.88           N  
ATOM    480  CA  GLU    70      14.914  -2.358  17.235  1.00 44.15           C  
ATOM    481  C   GLU    70      16.417  -2.296  17.027  1.00 42.63           C  
ATOM    482  O   GLU    70      17.083  -3.326  16.854  1.00 40.70           O  
ATOM    483  CB  GLU    70      14.727  -2.352  18.758  1.00 44.02           C  
ATOM    484  CG  GLU    70      13.479  -2.956  19.319  1.00 49.17           C  
ATOM    485  CD  GLU    70      13.403  -2.778  20.857  1.00 50.66           C  
ATOM    486  OE1 GLU    70      13.816  -1.656  21.361  1.00 57.14           O  
ATOM    487  OE2 GLU    70      12.923  -3.748  21.533  1.00 53.10           O  
ATOM    488  N   ASP    71      16.941  -1.081  17.146  1.00 42.60           N  
ATOM    489  CA  ASP    71      18.382  -0.850  17.089  1.00 43.31           C  
ATOM    490  C   ASP    71      19.025  -1.001  18.446  1.00 43.56           C  
ATOM    491  O   ASP    71      18.527  -0.452  19.446  1.00 44.12           O  
ATOM    492  CB  ASP    71      18.695   0.530  16.502  1.00 43.80           C  
ATOM    493  CG  ASP    71      18.390   0.615  15.022  1.00 45.66           C  
ATOM    494  OD1 ASP    71      17.523  -0.130  14.518  1.00 46.85           O  
ATOM    495  OD2 ASP    71      19.031   1.442  14.340  1.00 50.54           O  
ATOM    496  N   PHE    72      20.119  -1.763  18.480  1.00 42.87           N  
ATOM    497  CA  PHE    72      20.968  -1.887  19.651  1.00 42.59           C  
ATOM    498  C   PHE    72      22.398  -1.763  19.142  1.00 42.61           C  
ATOM    499  O   PHE    72      22.744  -2.358  18.120  1.00 41.94           O  
ATOM    500  CB  PHE    72      20.781  -3.235  20.371  1.00 43.24           C  
ATOM    501  CG  PHE    72      19.348  -3.523  20.793  1.00 45.32           C  
ATOM    502  CD1 PHE    72      18.843  -3.025  21.994  1.00 47.35           C  
ATOM    503  CD2 PHE    72      18.501  -4.280  19.983  1.00 44.73           C  
ATOM    504  CE1 PHE    72      17.503  -3.279  22.376  1.00 48.24           C  
ATOM    505  CE2 PHE    72      17.168  -4.525  20.359  1.00 39.75           C  
ATOM    506  CZ  PHE    72      16.683  -4.035  21.549  1.00 45.38           C  
ATOM    507  N   ASN    73      23.206  -0.973  19.850  1.00 43.10           N  
ATOM    508  CA  ASN    73      24.606  -0.660  19.467  1.00 43.65           C  
ATOM    509  C   ASN    73      24.686  -0.152  18.023  1.00 43.70           C  
ATOM    510  O   ASN    73      25.601  -0.496  17.283  1.00 43.14           O  
ATOM    511  CB  ASN    73      25.513  -1.889  19.657  1.00 43.42           C  
ATOM    512  CG  ASN    73      27.003  -1.519  19.856  1.00 46.43           C  
ATOM    513  OD1 ASN    73      27.353  -0.367  20.187  1.00 43.42           O  
ATOM    514  ND2 ASN    73      27.889  -2.518  19.667  1.00 48.36           N  
ATOM    515  N   GLY    74      23.677   0.609  17.606  1.00 44.40           N  
ATOM    516  CA  GLY    74      23.611   1.082  16.214  1.00 44.51           C  
ATOM    517  C   GLY    74      23.381   0.008  15.147  1.00 44.46           C  
ATOM    518  O   GLY    74      23.531   0.291  13.971  1.00 44.76           O  
ATOM    519  N   GLN    75      23.016  -1.212  15.556  1.00 43.78           N  
ATOM    520  CA  GLN    75      22.635  -2.297  14.632  1.00 42.82           C  
ATOM    521  C   GLN    75      21.157  -2.669  14.762  1.00 40.89           C  
ATOM    522  O   GLN    75      20.649  -2.890  15.865  1.00 40.71           O  
ATOM    523  CB  GLN    75      23.479  -3.545  14.896  1.00 42.81           C  
ATOM    524  CG  GLN    75      24.968  -3.400  14.622  1.00 46.95           C  
ATOM    525  CD  GLN    75      25.797  -4.451  15.386  1.00 50.89           C  
ATOM    526  OE1 GLN    75      26.011  -4.339  16.595  1.00 52.08           O  
ATOM    527  NE2 GLN    75      26.257  -5.474  14.673  1.00 51.59           N  
ATOM    528  N   SER    76      20.470  -2.740  13.621  1.00 39.88           N  
ATOM    529  CA  SER    76      19.081  -3.185  13.538  1.00 38.27           C  
ATOM    530  C   SER    76      18.980  -4.683  13.879  1.00 36.85           C  
ATOM    531  O   SER    76      19.722  -5.479  13.320  1.00 36.22           O  
ATOM    532  CB  SER    76      18.554  -2.935  12.130  1.00 38.31           C  
ATOM    533  OG  SER    76      18.478  -1.527  11.875  1.00 43.22           O  
ATOM    534  N   CYS    77      18.072  -5.043  14.789  1.00 35.33           N  
ATOM    535  CA  CYS    77      17.930  -6.402  15.313  1.00 34.59           C  
ATOM    536  C   CYS    77      16.462  -6.789  15.272  1.00 35.71           C  
ATOM    537  O   CYS    77      15.620  -5.957  15.526  1.00 35.64           O  
ATOM    538  CB  CYS    77      18.356  -6.451  16.776  1.00 33.34           C  
ATOM    539  SG  CYS    77      20.163  -6.333  16.976  1.00 35.65           S  
ATOM    540  N   ILE    78      16.190  -8.059  15.007  1.00 34.76           N  
ATOM    541  CA  ILE    78      14.973  -8.688  15.377  1.00 34.18           C  
ATOM    542  C   ILE    78      15.061  -9.169  16.864  1.00 34.62           C  
ATOM    543  O   ILE    78      16.054  -9.721  17.287  1.00 34.47           O  
ATOM    544  CB  ILE    78      14.535  -9.826  14.318  1.00 33.81           C  
ATOM    545  CG1 ILE    78      13.138 -10.355  14.634  1.00 32.87           C  
ATOM    546  CG2 ILE    78      15.569 -10.982  14.211  1.00 31.11           C  
ATOM    547  CD1 ILE    78      12.031  -9.303  14.448  1.00 29.85           C  
ATOM    548  N   VAL    79      14.017  -8.921  17.655  1.00 32.69           N  
ATOM    549  CA  VAL    79      13.972  -9.370  19.046  1.00 33.62           C  
ATOM    550  C   VAL    79      12.967 -10.495  19.058  1.00 33.60           C  
ATOM    551  O   VAL    79      11.792 -10.239  18.739  1.00 33.36           O  
ATOM    552  CB  VAL    79      13.518  -8.218  19.996  1.00 34.49           C  
ATOM    553  CG1 VAL    79      13.462  -8.703  21.467  1.00 35.62           C  
ATOM    554  CG2 VAL    79      14.427  -6.975  19.840  1.00 30.87           C  
ATOM    555  N   CYS    80      13.411 -11.721  19.355  1.00 34.05           N  
ATOM    556  CA  CYS    80      12.533 -12.854  19.471  1.00 34.02           C  
ATOM    557  C   CYS    80      11.430 -12.582  20.492  1.00 33.64           C  
ATOM    558  O   CYS    80      11.698 -12.131  21.600  1.00 32.90           O  
ATOM    559  CB  CYS    80      13.294 -14.109  19.911  1.00 34.77           C  
ATOM    560  SG  CYS    80      12.168 -15.548  19.926  1.00 35.45           S  
ATOM    561  N   PRO    81      10.148 -12.867  20.137  1.00 34.47           N  
ATOM    562  CA  PRO    81       9.161 -12.521  21.164  1.00 33.40           C  
ATOM    563  C   PRO    81       9.158 -13.389  22.422  1.00 32.58           C  
ATOM    564  O   PRO    81       8.508 -12.988  23.398  1.00 32.43           O  
ATOM    565  CB  PRO    81       7.805 -12.649  20.450  1.00 33.95           C  
ATOM    566  CG  PRO    81       8.086 -13.625  19.318  1.00 33.95           C  
ATOM    567  CD  PRO    81       9.559 -13.452  18.920  1.00 33.50           C  
ATOM    568  N   TRP    82       9.802 -14.554  22.398  1.00 32.23           N  
ATOM    569  CA  TRP    82       9.754 -15.550  23.533  1.00 31.38           C  
ATOM    570  C   TRP    82      10.749 -15.130  24.528  1.00 30.48           C  
ATOM    571  O   TRP    82      10.362 -14.756  25.596  1.00 29.33           O  
ATOM    572  CB  TRP    82       9.982 -16.993  23.023  1.00 32.45           C  
ATOM    573  CG  TRP    82       8.799 -17.617  22.294  1.00 34.89           C  
ATOM    574  CD1 TRP    82       7.596 -17.007  21.998  1.00 36.46           C  
ATOM    575  CD2 TRP    82       8.669 -18.981  21.835  1.00 35.91           C  
ATOM    576  NE1 TRP    82       6.751 -17.904  21.374  1.00 34.16           N  
ATOM    577  CE2 TRP    82       7.387 -19.107  21.242  1.00 35.08           C  
ATOM    578  CE3 TRP    82       9.521 -20.105  21.855  1.00 36.77           C  
ATOM    579  CZ2 TRP    82       6.925 -20.325  20.657  1.00 37.12           C  
ATOM    580  CZ3 TRP    82       9.077 -21.308  21.279  1.00 35.69           C  
ATOM    581  CH2 TRP    82       7.782 -21.405  20.693  1.00 37.21           C  
ATOM    582  N   HIS    83      12.068 -15.103  24.216  1.00 30.38           N  
ATOM    583  CA  HIS    83      12.919 -14.743  25.348  1.00 29.88           C  
ATOM    584  C   HIS    83      13.741 -13.485  25.057  1.00 31.78           C  
ATOM    585  O   HIS    83      14.746 -13.232  25.722  1.00 31.83           O  
ATOM    586  CB  HIS    83      13.781 -15.895  25.841  1.00 31.04           C  
ATOM    587  CG  HIS    83      13.026 -17.192  25.969  1.00 31.61           C  
ATOM    588  ND1 HIS    83      12.949 -18.098  24.940  1.00 32.84           N  
ATOM    589  CD2 HIS    83      12.222 -17.671  26.946  1.00 34.43           C  
ATOM    590  CE1 HIS    83      12.170 -19.111  25.295  1.00 32.77           C  
ATOM    591  NE2 HIS    83      11.701 -18.859  26.499  1.00 34.54           N  
ATOM    592  N   LYS    84      13.272 -12.695  24.087  1.00 31.89           N  
ATOM    593  CA  LYS    84      13.801 -11.347  23.806  1.00 31.70           C  
ATOM    594  C   LYS    84      15.293 -11.389  23.412  1.00 33.14           C  
ATOM    595  O   LYS    84      15.999 -10.409  23.572  1.00 32.10           O  
ATOM    596  CB  LYS    84      13.572 -10.417  24.989  1.00 31.06           C  
ATOM    597  CG  LYS    84      12.064 -10.399  25.517  1.00 30.64           C  
ATOM    598  CD  LYS    84      11.050 -10.263  24.434  1.00 32.36           C  
ATOM    599  CE  LYS    84       9.644  -9.933  25.085  1.00 38.66           C  
ATOM    600  NZ  LYS    84       8.482 -10.388  24.213  1.00 42.06           N  
ATOM    601  N   TYR    85      15.749 -12.497  22.829  1.00 33.63           N  
ATOM    602  CA  TYR    85      17.115 -12.501  22.289  1.00 34.59           C  
ATOM    603  C   TYR    85      17.175 -11.542  21.081  1.00 35.22           C  
ATOM    604  O   TYR    85      16.204 -11.416  20.329  1.00 34.27           O  
ATOM    605  CB  TYR    85      17.601 -13.871  21.873  1.00 34.05           C  
ATOM    606  CG  TYR    85      18.069 -14.735  23.013  1.00 33.39           C  
ATOM    607  CD1 TYR    85      17.518 -14.603  24.318  1.00 33.28           C  
ATOM    608  CD2 TYR    85      19.020 -15.705  22.782  1.00 33.67           C  
ATOM    609  CE1 TYR    85      17.960 -15.396  25.370  1.00 32.12           C  
ATOM    610  CE2 TYR    85      19.448 -16.533  23.802  1.00 36.57           C  
ATOM    611  CZ  TYR    85      18.910 -16.370  25.089  1.00 35.84           C  
ATOM    612  OH  TYR    85      19.383 -17.144  26.067  1.00 31.52           O  
ATOM    613  N   LYS    86      18.305 -10.876  20.931  1.00 34.93           N  
ATOM    614  CA  LYS    86      18.469  -9.853  19.904  1.00 36.39           C  
ATOM    615  C   LYS    86      19.354 -10.424  18.841  1.00 36.21           C  
ATOM    616  O   LYS    86      20.454 -10.888  19.121  1.00 35.92           O  
ATOM    617  CB  LYS    86      19.109  -8.620  20.483  1.00 36.57           C  
ATOM    618  CG  LYS    86      18.377  -8.041  21.744  1.00 38.21           C  
ATOM    619  CD  LYS    86      19.382  -6.992  22.306  1.00 41.31           C  
ATOM    620  CE  LYS    86      18.733  -6.100  23.324  1.00 46.04           C  
ATOM    621  NZ  LYS    86      18.598  -6.744  24.662  1.00 46.41           N  
ATOM    622  N   ILE    87      18.849 -10.420  17.612  1.00 35.80           N  
ATOM    623  CA  ILE    87      19.600 -10.980  16.491  1.00 34.37           C  
ATOM    624  C   ILE    87      19.777  -9.927  15.419  1.00 35.24           C  
ATOM    625  O   ILE    87      18.772  -9.368  14.953  1.00 33.39           O  
ATOM    626  CB  ILE    87      18.816 -12.178  15.906  1.00 35.19           C  
ATOM    627  CG1 ILE    87      18.756 -13.254  17.013  1.00 32.85           C  
ATOM    628  CG2 ILE    87      19.485 -12.672  14.587  1.00 32.28           C  
ATOM    629  CD1 ILE    87      17.647 -14.305  16.840  1.00 33.74           C  
ATOM    630  N   THR    88      21.023  -9.680  15.000  1.00 32.82           N  
ATOM    631  CA  THR    88      21.230  -8.635  13.996  1.00 34.57           C  
ATOM    632  C   THR    88      20.607  -9.068  12.656  1.00 34.38           C  
ATOM    633  O   THR    88      20.650 -10.224  12.304  1.00 34.53           O  
ATOM    634  CB  THR    88      22.724  -8.301  13.763  1.00 34.35           C  
ATOM    635  OG1 THR    88      23.409  -9.475  13.340  1.00 35.21           O  
ATOM    636  CG2 THR    88      23.392  -7.774  15.039  1.00 33.63           C  
ATOM    637  N   LEU    89      19.976  -8.125  11.981  1.00 34.00           N  
ATOM    638  CA  LEU    89      19.322  -8.356  10.695  1.00 35.35           C  
ATOM    639  C   LEU    89      20.380  -8.672   9.650  1.00 35.40           C  
ATOM    640  O   LEU    89      20.181  -9.579   8.837  1.00 36.23           O  
ATOM    641  CB  LEU    89      18.529  -7.081  10.287  1.00 33.99           C  
ATOM    642  CG  LEU    89      17.230  -6.790  11.094  1.00 32.97           C  
ATOM    643  CD1 LEU    89      16.426  -5.700  10.357  1.00 31.94           C  
ATOM    644  CD2 LEU    89      16.393  -8.003  11.336  1.00 30.27           C  
ATOM    645  N   ALA    90      21.509  -7.975   9.727  1.00 34.20           N  
ATOM    646  CA  ALA    90      22.519  -8.019   8.678  1.00 36.25           C  
ATOM    647  C   ALA    90      23.387  -9.263   8.793  1.00 36.66           C  
ATOM    648  O   ALA    90      23.758  -9.810   7.776  1.00 36.43           O  
ATOM    649  CB  ALA    90      23.415  -6.759   8.683  1.00 35.66           C  
ATOM    650  N   THR    91      23.685  -9.717  10.027  1.00 34.82           N  
ATOM    651  CA  THR    91      24.589 -10.858  10.183  1.00 35.01           C  
ATOM    652  C   THR    91      24.116 -12.087  10.991  1.00 35.56           C  
ATOM    653  O   THR    91      24.853 -13.077  11.052  1.00 36.37           O  
ATOM    654  CB  THR    91      25.960 -10.390  10.761  1.00 34.11           C  
ATOM    655  OG1 THR    91      25.737  -9.613  11.957  1.00 35.18           O  
ATOM    656  CG2 THR    91      26.699  -9.568   9.732  1.00 33.96           C  
ATOM    657  N   GLY    92      22.938 -12.026  11.618  1.00 33.49           N  
ATOM    658  CA  GLY    92      22.460 -13.150  12.383  1.00 34.48           C  
ATOM    659  C   GLY    92      23.227 -13.354  13.680  1.00 35.00           C  
ATOM    660  O   GLY    92      23.222 -14.444  14.230  1.00 34.54           O  
ATOM    661  N   GLU    93      23.805 -12.274  14.204  1.00 35.53           N  
ATOM    662  CA  GLU    93      24.569 -12.353  15.436  1.00 36.08           C  
ATOM    663  C   GLU    93      23.607 -12.161  16.603  1.00 37.33           C  
ATOM    664  O   GLU    93      22.883 -11.187  16.639  1.00 34.20           O  
ATOM    665  CB  GLU    93      25.642 -11.255  15.497  1.00 35.02           C  
ATOM    666  CG  GLU    93      26.854 -11.393  14.533  1.00 31.69           C  
ATOM    667  CD  GLU    93      27.731 -10.176  14.562  1.00 34.65           C  
ATOM    668  OE1 GLU    93      28.431  -9.935  15.578  1.00 37.63           O  
ATOM    669  OE2 GLU    93      27.761  -9.438  13.567  1.00 33.35           O  
ATOM    670  N   GLY    94      23.689 -13.064  17.584  1.00 39.26           N  
ATOM    671  CA  GLY    94      23.199 -12.833  18.957  1.00 39.94           C  
ATOM    672  C   GLY    94      23.965 -11.705  19.616  1.00 40.96           C  
ATOM    673  O   GLY    94      25.195 -11.754  19.743  1.00 41.85           O  
ATOM    674  N   LEU    95      23.262 -10.662  20.036  1.00 41.80           N  
ATOM    675  CA  LEU    95      23.912  -9.522  20.705  1.00 43.32           C  
ATOM    676  C   LEU    95      23.481  -9.430  22.157  1.00 44.62           C  
ATOM    677  O   LEU    95      22.305  -9.712  22.518  1.00 44.46           O  
ATOM    678  CB  LEU    95      23.514  -8.202  20.035  1.00 43.50           C  
ATOM    679  CG  LEU    95      23.999  -7.851  18.663  1.00 43.89           C  
ATOM    680  CD1 LEU    95      23.548  -6.420  18.448  1.00 42.62           C  
ATOM    681  CD2 LEU    95      25.548  -7.911  18.639  1.00 46.24           C  
ATOM    682  N   TYR    96      24.422  -9.008  22.993  1.00 45.03           N  
ATOM    683  CA  TYR    96      24.140  -8.751  24.398  1.00 45.51           C  
ATOM    684  C   TYR    96      25.061  -7.662  24.986  1.00 45.91           C  
ATOM    685  O   TYR    96      26.169  -7.340  24.467  1.00 45.16           O  
ATOM    686  CB  TYR    96      24.236 -10.057  25.240  1.00 45.83           C  
ATOM    687  CG  TYR    96      25.604 -10.654  25.208  1.00 44.27           C  
ATOM    688  CD1 TYR    96      26.031 -11.370  24.071  1.00 50.00           C  
ATOM    689  CD2 TYR    96      26.502 -10.491  26.263  1.00 46.02           C  
ATOM    690  CE1 TYR    96      27.349 -11.916  23.981  1.00 47.47           C  
ATOM    691  CE2 TYR    96      27.839 -11.074  26.200  1.00 46.29           C  
ATOM    692  CZ  TYR    96      28.231 -11.777  25.050  1.00 44.35           C  
ATOM    693  OH  TYR    96      29.492 -12.321  24.908  1.00 45.24           O  
ATOM    694  N   GLN    97      24.585  -7.086  26.087  1.00 46.30           N  
ATOM    695  CA  GLN    97      25.427  -6.235  26.908  1.00 46.58           C  
ATOM    696  C   GLN    97      26.028  -7.040  28.046  1.00 45.88           C  
ATOM    697  O   GLN    97      25.322  -7.760  28.753  1.00 44.56           O  
ATOM    698  CB  GLN    97      24.642  -5.078  27.499  1.00 47.22           C  
ATOM    699  CG  GLN    97      24.144  -4.011  26.589  1.00 48.64           C  
ATOM    700  CD  GLN    97      23.318  -3.005  27.411  1.00 52.59           C  
ATOM    701  OE1 GLN    97      23.868  -2.091  28.035  1.00 53.02           O  
ATOM    702  NE2 GLN    97      22.001  -3.214  27.457  1.00 51.22           N  
ATOM    703  N   SER    98      27.332  -6.892  28.210  1.00 45.90           N  
ATOM    704  CA  SER    98      28.032  -7.433  29.337  1.00 47.24           C  
ATOM    705  C   SER    98      28.166  -6.335  30.376  1.00 49.34           C  
ATOM    706  O   SER    98      28.757  -5.280  30.106  1.00 49.89           O  
ATOM    707  CB  SER    98      29.421  -7.930  28.921  1.00 47.10           C  
ATOM    708  OG  SER    98      30.102  -8.443  30.055  1.00 45.34           O  
ATOM    709  N   ILE    99      27.643  -6.611  31.572  1.00 51.39           N  
ATOM    710  CA  ILE    99      27.521  -5.639  32.677  1.00 52.93           C  
ATOM    711  C   ILE    99      28.393  -6.106  33.858  1.00 54.29           C  
ATOM    712  O   ILE    99      28.399  -7.298  34.199  1.00 54.71           O  
ATOM    713  CB  ILE    99      26.001  -5.470  33.104  1.00 52.30           C  
ATOM    714  CG1 ILE    99      25.131  -5.046  31.911  1.00 51.54           C  
ATOM    715  CG2 ILE    99      25.821  -4.493  34.288  1.00 53.70           C  
ATOM    716  CD1 ILE    99      23.807  -5.799  31.805  1.00 46.37           C  
ATOM    717  N   ASN   100      29.145  -5.184  34.459  1.00 55.52           N  
ATOM    718  CA  ASN   100      29.915  -5.522  35.654  1.00 56.83           C  
ATOM    719  C   ASN   100      29.368  -4.911  36.948  1.00 57.31           C  
ATOM    720  O   ASN   100      29.767  -3.798  37.320  1.00 57.84           O  
ATOM    721  CB  ASN   100      31.395  -5.180  35.492  1.00 57.18           C  
ATOM    722  CG  ASN   100      32.279  -5.978  36.445  1.00 58.52           C  
ATOM    723  OD1 ASN   100      32.301  -5.729  37.666  1.00 55.73           O  
ATOM    724  ND2 ASN   100      32.999  -6.966  35.887  1.00 59.65           N  
ATOM    725  N   PRO   101      28.505  -5.669  37.671  1.00 57.70           N  
ATOM    726  CA  PRO   101      27.715  -5.252  38.861  1.00 57.67           C  
ATOM    727  C   PRO   101      28.494  -4.456  39.916  1.00 57.26           C  
ATOM    728  O   PRO   101      29.706  -4.632  40.048  1.00 57.24           O  
ATOM    729  CB  PRO   101      27.268  -6.589  39.470  1.00 57.78           C  
ATOM    730  CG  PRO   101      28.071  -7.663  38.736  1.00 57.63           C  
ATOM    731  CD  PRO   101      28.294  -7.099  37.376  1.00 57.45           C  
ATOM    732  N   LYS   107      29.692   1.272  32.920  1.00 52.92           N  
ATOM    733  CA  LYS   107      29.148   1.413  31.570  1.00 53.38           C  
ATOM    734  C   LYS   107      29.016   0.059  30.807  1.00 53.00           C  
ATOM    735  O   LYS   107      30.028  -0.555  30.445  1.00 53.19           O  
ATOM    736  CB  LYS   107      30.007   2.402  30.785  1.00 53.22           C  
ATOM    737  CG  LYS   107      29.300   3.062  29.608  1.00 54.17           C  
ATOM    738  CD  LYS   107      30.302   3.782  28.676  1.00 54.72           C  
ATOM    739  CE  LYS   107      30.830   2.874  27.551  1.00 56.01           C  
ATOM    740  NZ  LYS   107      29.758   2.104  26.827  1.00 56.35           N  
ATOM    741  N   PRO   108      27.766  -0.424  30.589  1.00 52.64           N  
ATOM    742  CA  PRO   108      27.527  -1.639  29.776  1.00 52.07           C  
ATOM    743  C   PRO   108      28.149  -1.649  28.357  1.00 51.06           C  
ATOM    744  O   PRO   108      28.077  -0.662  27.610  1.00 51.00           O  
ATOM    745  CB  PRO   108      25.986  -1.740  29.709  1.00 52.11           C  
ATOM    746  CG  PRO   108      25.470  -0.398  30.166  1.00 52.53           C  
ATOM    747  CD  PRO   108      26.501   0.106  31.141  1.00 52.95           C  
ATOM    748  N   LYS   109      28.747  -2.780  28.007  1.00 49.63           N  
ATOM    749  CA  LYS   109      29.417  -2.927  26.728  1.00 48.39           C  
ATOM    750  C   LYS   109      28.752  -4.014  25.903  1.00 47.32           C  
ATOM    751  O   LYS   109      28.409  -5.079  26.408  1.00 46.47           O  
ATOM    752  CB  LYS   109      30.908  -3.231  26.929  1.00 48.48           C  
ATOM    753  CG  LYS   109      31.675  -2.169  27.706  1.00 48.27           C  
ATOM    754  CD  LYS   109      32.101  -0.976  26.816  1.00 48.40           C  
ATOM    755  CE  LYS   109      32.829   0.130  27.608  1.00 48.03           C  
ATOM    756  NZ  LYS   109      34.057  -0.306  28.331  1.00 48.01           N  
ATOM    757  N   TRP   110      28.577  -3.715  24.624  1.00 46.18           N  
ATOM    758  CA  TRP   110      27.922  -4.607  23.689  1.00 45.75           C  
ATOM    759  C   TRP   110      28.888  -5.683  23.197  1.00 44.56           C  
ATOM    760  O   TRP   110      30.046  -5.391  22.911  1.00 42.89           O  
ATOM    761  CB  TRP   110      27.375  -3.803  22.515  1.00 45.61           C  
ATOM    762  CG  TRP   110      26.203  -3.031  22.904  1.00 46.40           C  
ATOM    763  CD1 TRP   110      26.153  -1.699  23.258  1.00 45.90           C  
ATOM    764  CD2 TRP   110      24.869  -3.540  23.026  1.00 45.33           C  
ATOM    765  NE1 TRP   110      24.843  -1.349  23.573  1.00 45.91           N  
ATOM    766  CE2 TRP   110      24.038  -2.454  23.441  1.00 46.03           C  
ATOM    767  CE3 TRP   110      24.291  -4.803  22.822  1.00 45.31           C  
ATOM    768  CZ2 TRP   110      22.634  -2.600  23.654  1.00 46.18           C  
ATOM    769  CZ3 TRP   110      22.872  -4.949  23.031  1.00 46.50           C  
ATOM    770  CH2 TRP   110      22.082  -3.853  23.464  1.00 44.84           C  
ATOM    771  N   CYS   111      28.361  -6.904  23.104  1.00 43.73           N  
ATOM    772  CA  CYS   111      29.114  -8.133  22.804  1.00 43.51           C  
ATOM    773  C   CYS   111      28.372  -9.074  21.871  1.00 42.24           C  
ATOM    774  O   CYS   111      27.149  -9.058  21.816  1.00 41.79           O  
ATOM    775  CB  CYS   111      29.376  -8.905  24.099  1.00 43.86           C  
ATOM    776  SG  CYS   111      30.478  -8.046  25.204  1.00 46.60           S  
ATOM    777  N   SER   112      29.104  -9.937  21.181  1.00 40.36           N  
ATOM    778  CA  SER   112      28.489 -10.890  20.233  1.00 38.78           C  
ATOM    779  C   SER   112      29.045 -12.287  20.444  1.00 38.54           C  
ATOM    780  O   SER   112      30.236 -12.465  20.784  1.00 37.11           O  
ATOM    781  CB  SER   112      28.784 -10.442  18.777  1.00 38.60           C  
ATOM    782  OG  SER   112      28.526 -11.474  17.829  1.00 36.33           O  
ATOM    783  N   LYS   113      28.240 -13.294  20.134  1.00 39.27           N  
ATOM    784  CA  LYS   113      28.809 -14.664  20.073  1.00 39.20           C  
ATOM    785  C   LYS   113      28.966 -15.206  18.665  1.00 37.38           C  
ATOM    786  O   LYS   113      29.110 -16.411  18.469  1.00 37.70           O  
ATOM    787  CB  LYS   113      27.989 -15.639  20.921  1.00 42.14           C  
ATOM    788  CG  LYS   113      28.737 -16.266  22.147  1.00 43.01           C  
ATOM    789  CD  LYS   113      27.629 -16.659  23.119  1.00 49.68           C  
ATOM    790  CE  LYS   113      28.098 -16.891  24.541  1.00 52.37           C  
ATOM    791  NZ  LYS   113      26.895 -17.361  25.347  1.00 52.14           N  
ATOM    792  N   GLY   114      29.001 -14.319  17.685  1.00 35.65           N  
ATOM    793  CA  GLY   114      29.233 -14.768  16.320  1.00 33.82           C  
ATOM    794  C   GLY   114      27.873 -15.014  15.692  1.00 33.37           C  
ATOM    795  O   GLY   114      26.853 -14.701  16.302  1.00 33.36           O  
ATOM    796  N   VAL   115      27.846 -15.649  14.525  1.00 32.79           N  
ATOM    797  CA  VAL   115      26.561 -15.900  13.774  1.00 33.84           C  
ATOM    798  C   VAL   115      25.799 -17.031  14.496  1.00 34.57           C  
ATOM    799  O   VAL   115      26.361 -18.137  14.767  1.00 34.43           O  
ATOM    800  CB  VAL   115      26.845 -16.293  12.300  1.00 33.90           C  
ATOM    801  CG1 VAL   115      25.555 -16.622  11.522  1.00 31.20           C  
ATOM    802  CG2 VAL   115      27.703 -15.199  11.551  1.00 33.60           C  
ATOM    803  N   LYS   116      24.574 -16.720  14.899  1.00 33.94           N  
ATOM    804  CA  LYS   116      23.689 -17.683  15.526  1.00 34.60           C  
ATOM    805  C   LYS   116      22.534 -18.002  14.584  1.00 36.35           C  
ATOM    806  O   LYS   116      22.037 -19.147  14.525  1.00 36.12           O  
ATOM    807  CB  LYS   116      23.137 -17.076  16.830  1.00 34.93           C  
ATOM    808  CG  LYS   116      24.158 -16.962  17.967  1.00 36.71           C  
ATOM    809  CD  LYS   116      24.828 -18.295  18.150  1.00 37.08           C  
ATOM    810  CE  LYS   116      25.508 -18.443  19.482  1.00 39.69           C  
ATOM    811  NZ  LYS   116      25.820 -19.872  19.666  1.00 39.79           N  
ATOM    812  N   GLN   117      22.067 -16.972  13.876  1.00 36.23           N  
ATOM    813  CA  GLN   117      20.877 -17.109  13.025  1.00 37.34           C  
ATOM    814  C   GLN   117      21.271 -17.048  11.555  1.00 37.69           C  
ATOM    815  O   GLN   117      21.845 -16.036  11.090  1.00 37.71           O  
ATOM    816  CB  GLN   117      19.869 -15.988  13.312  1.00 36.96           C  
ATOM    817  CG  GLN   117      18.463 -16.279  12.769  1.00 36.32           C  
ATOM    818  CD  GLN   117      17.735 -17.310  13.592  1.00 35.64           C  
ATOM    819  OE1 GLN   117      18.100 -17.589  14.764  1.00 33.21           O  
ATOM    820  NE2 GLN   117      16.695 -17.910  12.990  1.00 32.46           N  
ATOM    821  N   ARG   118      20.991 -18.126  10.825  1.00 37.71           N  
ATOM    822  CA  ARG   118      21.418 -18.190   9.418  1.00 37.98           C  
ATOM    823  C   ARG   118      20.741 -17.092   8.573  1.00 37.27           C  
ATOM    824  O   ARG   118      19.476 -17.000   8.499  1.00 37.04           O  
ATOM    825  CB  ARG   118      21.179 -19.576   8.789  1.00 38.02           C  
ATOM    826  CG  ARG   118      21.819 -19.735   7.378  1.00 39.40           C  
ATOM    827  CD  ARG   118      21.777 -21.175   6.875  1.00 38.52           C  
ATOM    828  NE  ARG   118      22.687 -22.033   7.665  1.00 38.06           N  
ATOM    829  CZ  ARG   118      24.022 -22.129   7.515  1.00 37.93           C  
ATOM    830  NH1 ARG   118      24.691 -21.440   6.593  1.00 34.56           N  
ATOM    831  NH2 ARG   118      24.703 -22.923   8.333  1.00 38.47           N  
ATOM    832  N   ILE   119      21.582 -16.256   7.956  1.00 36.09           N  
ATOM    833  CA  ILE   119      21.119 -15.156   7.094  1.00 36.00           C  
ATOM    834  C   ILE   119      21.166 -15.659   5.666  1.00 36.74           C  
ATOM    835  O   ILE   119      22.181 -16.133   5.235  1.00 36.50           O  
ATOM    836  CB  ILE   119      22.024 -13.877   7.212  1.00 35.96           C  
ATOM    837  CG1 ILE   119      22.022 -13.307   8.650  1.00 34.90           C  
ATOM    838  CG2 ILE   119      21.682 -12.825   6.125  1.00 35.15           C  
ATOM    839  CD1 ILE   119      20.602 -12.885   9.187  1.00 30.88           C  
ATOM    840  N   HIS   120      20.053 -15.565   4.942  1.00 36.85           N  
ATOM    841  CA  HIS   120      20.040 -15.841   3.493  1.00 38.96           C  
ATOM    842  C   HIS   120      20.138 -14.559   2.630  1.00 39.25           C  
ATOM    843  O   HIS   120      20.005 -13.427   3.128  1.00 40.02           O  
ATOM    844  CB  HIS   120      18.777 -16.660   3.144  1.00 38.05           C  
ATOM    845  CG  HIS   120      18.561 -17.800   4.089  1.00 38.96           C  
ATOM    846  ND1 HIS   120      19.418 -18.878   4.150  1.00 36.58           N  
ATOM    847  CD2 HIS   120      17.627 -18.000   5.053  1.00 35.27           C  
ATOM    848  CE1 HIS   120      19.003 -19.709   5.090  1.00 38.50           C  
ATOM    849  NE2 HIS   120      17.934 -19.192   5.668  1.00 35.36           N  
ATOM    850  N   THR   121      20.333 -14.756   1.338  1.00 39.59           N  
ATOM    851  CA  THR   121      20.491 -13.659   0.402  1.00 40.27           C  
ATOM    852  C   THR   121      19.199 -13.159  -0.273  1.00 40.15           C  
ATOM    853  O   THR   121      18.438 -13.936  -0.858  1.00 39.80           O  
ATOM    854  CB  THR   121      21.500 -14.066  -0.671  1.00 40.22           C  
ATOM    855  OG1 THR   121      22.749 -14.397  -0.034  1.00 41.98           O  
ATOM    856  CG2 THR   121      21.706 -12.937  -1.682  1.00 41.72           C  
ATOM    857  N   VAL   122      19.007 -11.839  -0.253  1.00 41.00           N  
ATOM    858  CA  VAL   122      17.854 -11.203  -0.869  1.00 41.58           C  
ATOM    859  C   VAL   122      18.258 -10.178  -1.930  1.00 43.48           C  
ATOM    860  O   VAL   122      19.146  -9.338  -1.698  1.00 43.53           O  
ATOM    861  CB  VAL   122      16.981 -10.464   0.162  1.00 41.71           C  
ATOM    862  CG1 VAL   122      15.644 -10.073  -0.474  1.00 38.28           C  
ATOM    863  CG2 VAL   122      16.765 -11.303   1.363  1.00 40.94           C  
ATOM    864  N   LYS   123      17.587 -10.270  -3.081  1.00 44.58           N  
ATOM    865  CA  LYS   123      17.739  -9.350  -4.214  1.00 46.35           C  
ATOM    866  C   LYS   123      16.342  -8.962  -4.683  1.00 46.16           C  
ATOM    867  O   LYS   123      15.405  -9.785  -4.628  1.00 46.09           O  
ATOM    868  CB  LYS   123      18.475 -10.028  -5.365  1.00 45.73           C  
ATOM    869  CG  LYS   123      19.758 -10.697  -4.915  1.00 49.43           C  
ATOM    870  CD  LYS   123      20.670 -11.185  -6.033  1.00 49.00           C  
ATOM    871  CE  LYS   123      21.765 -12.074  -5.411  1.00 53.31           C  
ATOM    872  NZ  LYS   123      23.006 -11.341  -5.004  1.00 54.10           N  
ATOM    873  N   VAL   124      16.198  -7.705  -5.112  1.00 46.40           N  
ATOM    874  CA  VAL   124      15.000  -7.293  -5.832  1.00 46.88           C  
ATOM    875  C   VAL   124      15.379  -7.052  -7.277  1.00 46.74           C  
ATOM    876  O   VAL   124      16.504  -6.635  -7.570  1.00 46.43           O  
ATOM    877  CB  VAL   124      14.232  -6.080  -5.185  1.00 47.39           C  
ATOM    878  CG1 VAL   124      13.900  -6.365  -3.711  1.00 46.38           C  
ATOM    879  CG2 VAL   124      15.003  -4.779  -5.323  1.00 48.38           C  
ATOM    880  N   ASP   125      14.456  -7.392  -8.164  1.00 46.24           N  
ATOM    881  CA  ASP   125      14.604  -7.198  -9.603  1.00 46.97           C  
ATOM    882  C   ASP   125      13.200  -7.131 -10.144  1.00 46.60           C  
ATOM    883  O   ASP   125      12.381  -8.010  -9.868  1.00 46.64           O  
ATOM    884  CB  ASP   125      15.365  -8.366 -10.243  1.00 47.02           C  
ATOM    885  CG  ASP   125      15.581  -8.179 -11.735  1.00 48.06           C  
ATOM    886  OD1 ASP   125      16.409  -7.324 -12.127  1.00 47.94           O  
ATOM    887  OD2 ASP   125      14.925  -8.901 -12.522  1.00 49.86           O  
ATOM    888  N   ASN   126      12.915  -6.066 -10.880  1.00 46.65           N  
ATOM    889  CA  ASN   126      11.595  -5.865 -11.459  1.00 46.94           C  
ATOM    890  C   ASN   126      10.482  -5.772 -10.414  1.00 46.29           C  
ATOM    891  O   ASN   126       9.341  -6.151 -10.691  1.00 46.38           O  
ATOM    892  CB  ASN   126      11.265  -6.996 -12.440  1.00 47.56           C  
ATOM    893  CG  ASN   126      11.881  -6.790 -13.785  1.00 48.66           C  
ATOM    894  OD1 ASN   126      13.106  -6.718 -13.920  1.00 51.64           O  
ATOM    895  ND2 ASN   126      11.040  -6.693 -14.802  1.00 48.83           N  
ATOM    896  N   GLY   127      10.816  -5.281  -9.221  1.00 45.49           N  
ATOM    897  CA  GLY   127       9.850  -5.254  -8.121  1.00 44.79           C  
ATOM    898  C   GLY   127       9.414  -6.632  -7.616  1.00 43.72           C  
ATOM    899  O   GLY   127       8.267  -6.769  -7.095  1.00 44.18           O  
ATOM    900  N   ASN   128      10.302  -7.652  -7.804  1.00 41.82           N  
ATOM    901  CA  ASN   128      10.065  -8.957  -7.237  1.00 40.23           C  
ATOM    902  C   ASN   128      11.127  -9.241  -6.198  1.00 40.41           C  
ATOM    903  O   ASN   128      12.298  -8.871  -6.378  1.00 39.02           O  
ATOM    904  CB  ASN   128      10.104 -10.042  -8.298  1.00 40.14           C  
ATOM    905  CG  ASN   128       8.857 -10.065  -9.183  1.00 40.64           C  
ATOM    906  OD1 ASN   128       7.774  -9.582  -8.797  1.00 42.50           O  
ATOM    907  ND2 ASN   128       9.001 -10.667 -10.368  1.00 35.86           N  
ATOM    908  N   ILE   129      10.736  -9.889  -5.104  1.00 39.25           N  
ATOM    909  CA  ILE   129      11.724 -10.264  -4.089  1.00 39.89           C  
ATOM    910  C   ILE   129      12.189 -11.689  -4.363  1.00 39.72           C  
ATOM    911  O   ILE   129      11.367 -12.580  -4.538  1.00 40.66           O  
ATOM    912  CB  ILE   129      11.177 -10.050  -2.666  1.00 40.15           C  
ATOM    913  CG1 ILE   129      10.646  -8.609  -2.563  1.00 39.73           C  
ATOM    914  CG2 ILE   129      12.289 -10.383  -1.574  1.00 38.54           C  
ATOM    915  CD1 ILE   129       9.946  -8.267  -1.304  1.00 41.42           C  
ATOM    916  N   TYR   130      13.505 -11.885  -4.456  1.00 39.44           N  
ATOM    917  CA  TYR   130      14.075 -13.199  -4.695  1.00 39.04           C  
ATOM    918  C   TYR   130      14.927 -13.622  -3.518  1.00 39.32           C  
ATOM    919  O   TYR   130      15.779 -12.858  -3.059  1.00 40.79           O  
ATOM    920  CB  TYR   130      14.921 -13.200  -5.984  1.00 38.38           C  
ATOM    921  CG  TYR   130      14.096 -13.000  -7.267  1.00 37.81           C  
ATOM    922  CD1 TYR   130      13.542 -14.087  -7.933  1.00 36.33           C  
ATOM    923  CD2 TYR   130      13.858 -11.725  -7.789  1.00 36.31           C  
ATOM    924  CE1 TYR   130      12.789 -13.923  -9.121  1.00 38.63           C  
ATOM    925  CE2 TYR   130      13.089 -11.540  -8.988  1.00 38.25           C  
ATOM    926  CZ  TYR   130      12.559 -12.647  -9.645  1.00 38.04           C  
ATOM    927  OH  TYR   130      11.771 -12.507 -10.806  1.00 40.74           O  
ATOM    928  N   VAL   131      14.753 -14.852  -3.063  1.00 38.99           N  
ATOM    929  CA  VAL   131      15.594 -15.364  -1.979  1.00 39.24           C  
ATOM    930  C   VAL   131      16.495 -16.532  -2.447  1.00 39.70           C  
ATOM    931  O   VAL   131      16.069 -17.417  -3.165  1.00 38.44           O  
ATOM    932  CB  VAL   131      14.755 -15.722  -0.681  1.00 40.15           C  
ATOM    933  CG1 VAL   131      15.672 -16.298   0.427  1.00 38.58           C  
ATOM    934  CG2 VAL   131      14.018 -14.500  -0.156  1.00 38.05           C  
ATOM    935  N   THR   132      17.747 -16.518  -2.008  1.00 40.04           N  
ATOM    936  CA  THR   132      18.662 -17.596  -2.286  1.00 40.59           C  
ATOM    937  C   THR   132      19.160 -18.076  -0.934  1.00 41.95           C  
ATOM    938  O   THR   132      19.635 -17.260  -0.131  1.00 42.01           O  
ATOM    939  CB  THR   132      19.816 -17.068  -3.200  1.00 40.85           C  
ATOM    940  OG1 THR   132      19.228 -16.494  -4.379  1.00 36.46           O  
ATOM    941  CG2 THR   132      20.793 -18.173  -3.591  1.00 40.09           C  
ATOM    942  N   LEU   133      19.006 -19.376  -0.646  1.00 43.00           N  
ATOM    943  CA  LEU   133      19.478 -19.932   0.642  1.00 43.84           C  
ATOM    944  C   LEU   133      21.003 -19.800   0.731  1.00 45.22           C  
ATOM    945  O   LEU   133      21.701 -19.944  -0.277  1.00 45.17           O  
ATOM    946  CB  LEU   133      19.037 -21.390   0.842  1.00 42.75           C  
ATOM    947  CG  LEU   133      17.561 -21.744   1.009  1.00 43.41           C  
ATOM    948  CD1 LEU   133      17.355 -23.248   1.217  1.00 40.34           C  
ATOM    949  CD2 LEU   133      16.914 -20.945   2.158  1.00 38.38           C  
ATOM    950  N   SER   134      21.518 -19.499   1.921  1.00 46.77           N  
ATOM    951  CA  SER   134      22.947 -19.315   2.087  1.00 48.93           C  
ATOM    952  C   SER   134      23.636 -20.617   2.454  1.00 50.30           C  
ATOM    953  O   SER   134      23.052 -21.430   3.178  1.00 50.76           O  
ATOM    954  CB  SER   134      23.217 -18.359   3.212  1.00 48.46           C  
ATOM    955  OG  SER   134      23.246 -19.084   4.431  1.00 51.29           O  
ATOM    956  N   LYS   135      24.888 -20.776   1.999  1.00 51.51           N  
ATOM    957  CA  LYS   135      25.747 -21.898   2.405  1.00 52.31           C  
ATOM    958  C   LYS   135      26.749 -21.454   3.469  1.00 53.22           C  
ATOM    959  O   LYS   135      27.278 -22.269   4.220  1.00 53.31           O  
ATOM    960  CB  LYS   135      26.517 -22.448   1.204  1.00 52.38           C  
ATOM    961  CG  LYS   135      25.832 -22.306  -0.127  1.00 52.11           C  
ATOM    962  CD  LYS   135      26.629 -23.075  -1.207  1.00 52.26           C  
ATOM    963  CE  LYS   135      26.349 -22.568  -2.623  1.00 51.66           C  
ATOM    964  NZ  LYS   135      27.234 -23.237  -3.657  1.00 51.02           N  
ATOM    965  N   GLU   136      27.006 -20.152   3.518  1.00 54.27           N  
ATOM    966  CA  GLU   136      27.956 -19.560   4.457  1.00 55.33           C  
ATOM    967  C   GLU   136      27.206 -19.019   5.694  1.00 55.09           C  
ATOM    968  O   GLU   136      26.128 -18.427   5.545  1.00 56.28           O  
ATOM    969  CB  GLU   136      28.719 -18.437   3.723  1.00 55.83           C  
ATOM    970  CG  GLU   136      29.997 -17.945   4.391  1.00 57.12           C  
ATOM    971  CD  GLU   136      31.278 -18.520   3.788  1.00 61.09           C  
ATOM    972  OE1 GLU   136      32.107 -19.071   4.568  1.00 61.63           O  
ATOM    973  OE2 GLU   136      31.476 -18.395   2.549  1.00 61.99           O  
ATOM    974  N   PRO   137      27.715 -19.267   6.936  1.00 55.06           N  
ATOM    975  CA  PRO   137      28.830 -20.105   7.419  1.00 54.23           C  
ATOM    976  C   PRO   137      28.458 -21.596   7.460  1.00 53.34           C  
ATOM    977  O   PRO   137      27.266 -21.937   7.390  1.00 53.31           O  
ATOM    978  CB  PRO   137      29.047 -19.593   8.848  1.00 53.86           C  
ATOM    979  CG  PRO   137      27.741 -19.181   9.281  1.00 54.97           C  
ATOM    980  CD  PRO   137      27.050 -18.585   8.071  1.00 54.57           C  
ATOM    981  N   PHE   138      29.459 -22.466   7.614  1.00 51.43           N  
ATOM    982  CA  PHE   138      29.223 -23.905   7.498  1.00 50.12           C  
ATOM    983  C   PHE   138      28.121 -24.426   8.435  1.00 48.87           C  
ATOM    984  O   PHE   138      27.243 -25.166   7.987  1.00 48.71           O  
ATOM    985  CB  PHE   138      30.543 -24.770   7.566  1.00 50.26           C  
ATOM    986  CG  PHE   138      30.222 -26.220   7.875  1.00 49.81           C  
ATOM    987  CD1 PHE   138      29.654 -27.076   6.745  1.00 51.49           C  
ATOM    988  CD2 PHE   138      30.384 -26.741   9.264  1.00 51.50           C  
ATOM    989  CE1 PHE   138      29.370 -28.414   7.051  1.00 51.29           C  
ATOM    990  CE2 PHE   138      30.105 -28.080   9.579  1.00 50.91           C  
ATOM    991  CZ  PHE   138      29.521 -28.922   8.458  1.00 51.61           C  
ATOM    992  N   LYS   139      28.144 -24.002   9.701  1.00 48.30           N  
ATOM    993  CA  LYS   139      27.051 -24.305  10.665  1.00 47.27           C  
ATOM    994  C   LYS   139      26.547 -23.108  11.510  1.00 45.92           C  
ATOM    995  O   LYS   139      27.349 -22.313  11.982  1.00 44.08           O  
ATOM    996  CB  LYS   139      27.496 -25.468  11.566  1.00 47.34           C  
ATOM    997  CG  LYS   139      26.480 -25.899  12.624  1.00 48.98           C  
ATOM    998  CD  LYS   139      27.075 -27.027  13.507  1.00 49.64           C  
ATOM    999  CE  LYS   139      26.266 -27.148  14.818  1.00 54.05           C  
ATOM   1000  NZ  LYS   139      26.806 -28.256  15.668  1.00 56.44           N  
ATOM   1001  N   CYS   140      25.210 -22.982  11.655  1.00 45.92           N  
ATOM   1002  CA  CYS   140      24.511 -22.004  12.540  1.00 46.22           C  
ATOM   1003  C   CYS   140      23.654 -22.698  13.584  1.00 45.35           C  
ATOM   1004  O   CYS   140      23.116 -23.767  13.310  1.00 46.60           O  
ATOM   1005  CB  CYS   140      23.596 -21.043  11.775  1.00 45.85           C  
ATOM   1006  SG  CYS   140      24.500 -20.055  10.567  1.00 48.91           S  
ATOM   1007  N   ASP   141      23.543 -22.117  14.776  1.00 44.08           N  
ATOM   1008  CA  ASP   141      22.661 -22.691  15.792  1.00 44.62           C  
ATOM   1009  C   ASP   141      21.209 -22.781  15.266  1.00 44.81           C  
ATOM   1010  O   ASP   141      20.514 -23.715  15.642  1.00 45.32           O  
ATOM   1011  CB  ASP   141      22.668 -21.877  17.082  1.00 44.12           C  
ATOM   1012  CG  ASP   141      23.859 -22.159  17.927  1.00 46.44           C  
ATOM   1013  OD1 ASP   141      24.743 -22.891  17.458  1.00 44.54           O  
ATOM   1014  OD2 ASP   141      23.923 -21.655  19.069  1.00 46.27           O  
ATOM   1015  N   SER   142      20.778 -21.871  14.383  1.00 43.14           N  
ATOM   1016  CA  SER   142      19.386 -21.945  13.855  1.00 44.31           C  
ATOM   1017  C   SER   142      19.056 -23.136  12.964  1.00 44.24           C  
ATOM   1018  O   SER   142      17.855 -23.430  12.753  1.00 44.10           O  
ATOM   1019  CB  SER   142      18.968 -20.672  13.109  1.00 42.51           C  
ATOM   1020  OG  SER   142      19.724 -20.520  11.920  1.00 44.57           O  
ATOM   1021  N   ASP   143      20.096 -23.789  12.422  1.00 45.06           N  
ATOM   1022  CA  ASP   143      19.920 -24.950  11.547  1.00 45.46           C  
ATOM   1023  C   ASP   143      19.147 -26.078  12.227  1.00 46.54           C  
ATOM   1024  O   ASP   143      18.376 -26.748  11.569  1.00 46.75           O  
ATOM   1025  CB  ASP   143      21.271 -25.513  11.043  1.00 45.66           C  
ATOM   1026  CG  ASP   143      22.036 -24.532  10.155  1.00 44.83           C  
ATOM   1027  OD1 ASP   143      21.419 -23.599   9.598  1.00 42.43           O  
ATOM   1028  OD2 ASP   143      23.265 -24.707  10.002  1.00 42.61           O  
ATOM   1029  N   TYR   144      19.381 -26.312  13.524  1.00 47.69           N  
ATOM   1030  CA  TYR   144      18.623 -27.347  14.256  1.00 48.61           C  
ATOM   1031  C   TYR   144      17.099 -27.159  14.128  1.00 48.69           C  
ATOM   1032  O   TYR   144      16.365 -28.135  13.991  1.00 47.78           O  
ATOM   1033  CB  TYR   144      18.997 -27.374  15.736  1.00 49.29           C  
ATOM   1034  CG  TYR   144      18.236 -28.431  16.549  1.00 50.70           C  
ATOM   1035  CD1 TYR   144      18.607 -29.785  16.506  1.00 52.62           C  
ATOM   1036  CD2 TYR   144      17.137 -28.072  17.355  1.00 50.86           C  
ATOM   1037  CE1 TYR   144      17.910 -30.757  17.256  1.00 53.14           C  
ATOM   1038  CE2 TYR   144      16.437 -29.036  18.096  1.00 50.65           C  
ATOM   1039  CZ  TYR   144      16.825 -30.359  18.054  1.00 51.92           C  
ATOM   1040  OH  TYR   144      16.129 -31.298  18.797  1.00 51.39           O  
ATOM   1041  N   TYR   145      16.644 -25.905  14.171  1.00 48.97           N  
ATOM   1042  CA  TYR   145      15.207 -25.585  14.134  1.00 49.21           C  
ATOM   1043  C   TYR   145      14.692 -25.435  12.713  1.00 49.99           C  
ATOM   1044  O   TYR   145      13.494 -25.243  12.506  1.00 50.05           O  
ATOM   1045  CB  TYR   145      14.899 -24.356  15.003  1.00 50.10           C  
ATOM   1046  CG  TYR   145      15.084 -24.675  16.463  1.00 49.20           C  
ATOM   1047  CD1 TYR   145      14.246 -25.591  17.080  1.00 50.84           C  
ATOM   1048  CD2 TYR   145      16.103 -24.109  17.212  1.00 45.52           C  
ATOM   1049  CE1 TYR   145      14.402 -25.937  18.406  1.00 51.72           C  
ATOM   1050  CE2 TYR   145      16.267 -24.456  18.567  1.00 47.36           C  
ATOM   1051  CZ  TYR   145      15.403 -25.363  19.144  1.00 50.04           C  
ATOM   1052  OH  TYR   145      15.524 -25.798  20.451  1.00 53.65           O  
ATOM   1053  N   ALA   146      15.602 -25.555  11.741  1.00 49.88           N  
ATOM   1054  CA  ALA   146      15.292 -25.302  10.345  1.00 50.90           C  
ATOM   1055  C   ALA   146      14.972 -26.581   9.602  1.00 52.22           C  
ATOM   1056  O   ALA   146      14.408 -26.522   8.507  1.00 52.25           O  
ATOM   1057  CB  ALA   146      16.440 -24.593   9.653  1.00 50.05           C  
ATOM   1058  N   THR   147      15.340 -27.724  10.190  1.00 53.87           N  
ATOM   1059  CA  THR   147      15.284 -29.020   9.494  1.00 54.91           C  
ATOM   1060  C   THR   147      14.885 -30.235  10.356  1.00 55.97           C  
ATOM   1061  O   THR   147      15.363 -30.403  11.483  1.00 55.90           O  
ATOM   1062  CB  THR   147      16.649 -29.340   8.805  1.00 55.15           C  
ATOM   1063  OG1 THR   147      17.733 -29.043   9.703  1.00 54.95           O  
ATOM   1064  CG2 THR   147      16.822 -28.514   7.524  1.00 55.67           C  
ATOM   1065  N   GLY   148      14.020 -31.085   9.788  1.00 57.03           N  
ATOM   1066  CA  GLY   148      13.682 -32.405  10.340  1.00 58.17           C  
ATOM   1067  C   GLY   148      12.993 -32.442  11.697  1.00 59.08           C  
ATOM   1068  O   GLY   148      12.159 -31.584  12.016  1.00 59.21           O  
ATOM   1069  N   GLU   149      13.354 -33.452  12.490  1.00 59.79           N  
ATOM   1070  CA  GLU   149      12.780 -33.700  13.825  1.00 60.24           C  
ATOM   1071  C   GLU   149      13.243 -32.700  14.895  1.00 60.72           C  
ATOM   1072  O   GLU   149      14.424 -32.708  15.283  1.00 61.14           O  
ATOM   1073  CB  GLU   149      13.135 -35.121  14.287  1.00 60.50           C  
ATOM   1074  CG  GLU   149      12.122 -36.220  13.932  1.00 60.05           C  
ATOM   1075  CD  GLU   149      11.038 -36.365  14.988  1.00 59.99           C  
ATOM   1076  OE1 GLU   149      10.594 -37.506  15.238  1.00 58.25           O  
ATOM   1077  OE2 GLU   149      10.638 -35.330  15.575  1.00 60.64           O  
ATOM   1078  N   PHE   150      12.312 -31.853  15.361  1.00 60.39           N  
ATOM   1079  CA  PHE   150      12.536 -30.943  16.513  1.00 60.35           C  
ATOM   1080  C   PHE   150      11.287 -30.683  17.391  1.00 59.56           C  
ATOM   1081  O   PHE   150      10.146 -30.940  16.985  1.00 59.84           O  
ATOM   1082  CB  PHE   150      13.215 -29.610  16.101  1.00 60.16           C  
ATOM   1083  CG  PHE   150      12.466 -28.833  15.057  1.00 61.05           C  
ATOM   1084  CD1 PHE   150      11.587 -27.820  15.425  1.00 62.70           C  
ATOM   1085  CD2 PHE   150      12.659 -29.093  13.697  1.00 62.07           C  
ATOM   1086  CE1 PHE   150      10.890 -27.086  14.451  1.00 62.87           C  
ATOM   1087  CE2 PHE   150      11.957 -28.387  12.708  1.00 63.06           C  
ATOM   1088  CZ  PHE   150      11.069 -27.377  13.087  1.00 63.13           C  
ATOM   1089  N   LYS   151      11.531 -30.222  18.613  1.00 58.08           N  
ATOM   1090  CA  LYS   151      10.482 -29.702  19.473  1.00 56.42           C  
ATOM   1091  C   LYS   151      10.831 -28.252  19.769  1.00 55.24           C  
ATOM   1092  O   LYS   151      12.015 -27.902  19.798  1.00 54.83           O  
ATOM   1093  CB  LYS   151      10.362 -30.540  20.750  1.00 57.09           C  
ATOM   1094  CG  LYS   151       9.370 -31.678  20.611  1.00 56.58           C  
ATOM   1095  CD  LYS   151       8.705 -31.985  21.949  1.00 59.54           C  
ATOM   1096  CE  LYS   151       7.414 -32.786  21.781  1.00 59.45           C  
ATOM   1097  NZ  LYS   151       6.864 -33.245  23.089  1.00 61.73           N  
ATOM   1098  N   VAL   152       9.824 -27.397  19.929  1.00 53.60           N  
ATOM   1099  CA  VAL   152      10.101 -25.999  20.303  1.00 53.08           C  
ATOM   1100  C   VAL   152       9.768 -25.697  21.790  1.00 52.22           C  
ATOM   1101  O   VAL   152       8.860 -26.281  22.367  1.00 51.30           O  
ATOM   1102  CB  VAL   152       9.599 -24.922  19.235  1.00 52.74           C  
ATOM   1103  CG1 VAL   152      10.068 -25.286  17.829  1.00 52.40           C  
ATOM   1104  CG2 VAL   152       8.128 -24.765  19.228  1.00 52.79           C  
ATOM   1105  N   ILE   153      10.568 -24.835  22.417  1.00 52.29           N  
ATOM   1106  CA  ILE   153      10.422 -24.558  23.848  1.00 52.31           C  
ATOM   1107  C   ILE   153      10.173 -23.064  24.121  1.00 51.77           C  
ATOM   1108  O   ILE   153      10.922 -22.204  23.637  1.00 51.74           O  
ATOM   1109  CB  ILE   153      11.666 -24.997  24.592  1.00 52.99           C  
ATOM   1110  CG1 ILE   153      11.771 -26.531  24.594  1.00 52.49           C  
ATOM   1111  CG2 ILE   153      11.651 -24.415  26.010  1.00 55.15           C  
ATOM   1112  CD1 ILE   153      13.034 -27.088  25.334  1.00 53.41           C  
ATOM   1113  N   GLN   154       9.086 -22.744  24.829  1.00 50.54           N  
ATOM   1114  CA  GLN   154       8.852 -21.355  25.219  1.00 49.09           C  
ATOM   1115  C   GLN   154       9.033 -21.316  26.726  1.00 48.53           C  
ATOM   1116  O   GLN   154       8.355 -22.092  27.425  1.00 47.25           O  
ATOM   1117  CB  GLN   154       7.471 -20.847  24.760  1.00 48.43           C  
ATOM   1118  CG  GLN   154       7.220 -19.364  25.065  1.00 49.16           C  
ATOM   1119  CD  GLN   154       5.802 -18.889  24.709  1.00 50.58           C  
ATOM   1120  OE1 GLN   154       4.958 -19.678  24.258  1.00 53.72           O  
ATOM   1121  NE2 GLN   154       5.535 -17.587  24.925  1.00 50.75           N  
END
