
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  142 ( 2060),  selected  142 , name 2i85_A
# Molecule2: number of CA atoms  130 ( 1084),  selected  130 , name T0390.pdb
# PARAMETERS: 2i85_A.T0390.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    S     3_A      A      29          4.158
LGA    I     4_A      D      30          2.863
LGA    V     5_A      R      31          3.244
LGA    L     6_A      H      32          1.944
LGA    E     7_A      T      33          2.584
LGA    P     8_A      V      34          4.141
LGA    I     9_A      F      35          2.765
LGA    Y    10_A      -       -           -
LGA    W    11_A      W      36           #
LGA    N    12_A      N      37          4.595
LGA    -       -      S      38           -
LGA    S    13_A      S      39           #
LGA    S    14_A      N      40          5.263
LGA    N    15_A      P      41           #
LGA    S    16_A      -       -           -
LGA    K    17_A      -       -           -
LGA    F    18_A      K      42          1.826
LGA    L    19_A      F      43          2.607
LGA    P    20_A      R      44           #
LGA    G    21_A      N      45          1.472
LGA    Q    22_A      E      46          1.766
LGA    G    23_A      D      47          4.943
LGA    L    24_A      Y      48          2.998
LGA    V    25_A      T      49          1.397
LGA    L    26_A      I      50          2.768
LGA    Y    27_A      H      51          2.294
LGA    P    28_A      V      52          3.343
LGA    Q    29_A      Q      53          0.726
LGA    I    30_A      L      54          3.037
LGA    G    31_A      N      55           #
LGA    D    32_A      D      56          3.331
LGA    K    33_A      Y      57          2.856
LGA    L    34_A      V      58          2.523
LGA    D    35_A      D      59          2.191
LGA    I    36_A      I      60          2.625
LGA    I    37_A      I      61          2.920
LGA    C    38_A      C      62          2.649
LGA    P    39_A      P      63          5.096
LGA    K    40_A      H      64          4.080
LGA    V    41_A      Y      65           #
LGA    D    42_A      -       -           -
LGA    S    43_A      -       -           -
LGA    K    44_A      E      66          3.787
LGA    T    45_A      S      69          4.437
LGA    V    46_A      V      70          1.988
LGA    G    47_A      A      71           #
LGA    Q    48_A      D      72          3.820
LGA    Y    49_A      A      73          1.814
LGA    -       -      A      74           -
LGA    -       -      M      75           -
LGA    E    50_A      E      76          3.046
LGA    Y    51_A      Q      77          1.147
LGA    Y    52_A      Y      78          1.453
LGA    K    53_A      I      79          1.563
LGA    V    54_A      L      80          1.808
LGA    Y    55_A      Y      81          0.624
LGA    M    56_A      L      82          1.332
LGA    V    57_A      V      83          1.775
LGA    D    58_A      E      84          2.233
LGA    K    59_A      H      85          2.734
LGA    D    60_A      E      86          2.198
LGA    Q    61_A      E      87          2.029
LGA    A    62_A      Y      88          2.908
LGA    D    63_A      Q      89          3.487
LGA    R    64_A      L      90          3.257
LGA    C    65_A      C      91          3.313
LGA    T    66_A      Q      92          2.135
LGA    I    67_A      P      93          1.363
LGA    K    68_A      Q      94          1.638
LGA    K    69_A      S      95          2.097
LGA    E    70_A      K      96          3.225
LGA    N    71_A      D      97          2.989
LGA    T    72_A      Q      98           #
LGA    P    73_A      V      99          3.312
LGA    L    74_A      R     100          3.655
LGA    L    75_A      W     101          3.387
LGA    N    76_A      Q     102           #
LGA    C    77_A      C     103          1.452
LGA    A    78_A      N     104          2.226
LGA    K    79_A      -       -           -
LGA    P    80_A      -       -           -
LGA    D    81_A      R     105          4.816
LGA    Q    82_A      P     106          5.107
LGA    D    83_A      S     107           #
LGA    -       -      A     108           -
LGA    -       -      K     109           -
LGA    -       -      H     110           -
LGA    -       -      G     111           -
LGA    -       -      P     112           -
LGA    I    84_A      E     113          1.581
LGA    K    85_A      K     114          2.050
LGA    F    86_A      L     115          3.378
LGA    T    87_A      S     116          3.051
LGA    I    88_A      E     117          3.843
LGA    K    89_A      K     118          4.562
LGA    F    90_A      F     119          4.869
LGA    Q    91_A      Q     120           #
LGA    E    92_A      R     121           #
LGA    F    93_A      -       -           -
LGA    S    94_A      -       -           -
LGA    P    95_A      -       -           -
LGA    N    96_A      -       -           -
LGA    L    97_A      -       -           -
LGA    W    98_A      F     122          3.055
LGA    G    99_A      T     123          3.984
LGA    L   100_A      P     124           -
LGA    E   101_A      F     125           -
LGA    -       -      T     126           -
LGA    -       -      L     127           -
LGA    -       -      G     128           -
LGA    -       -      K     129           -
LGA    F   102_A      E     130          4.982
LGA    Q   103_A      F     131          3.600
LGA    K   104_A      K     132          2.775
LGA    -       -      E     133           -
LGA    N   105_A      G     134          3.875
LGA    K   106_A      H     135          2.718
LGA    D   107_A      S     136          2.508
LGA    Y   108_A      Y     137          1.490
LGA    Y   109_A      Y     138          1.807
LGA    I   110_A      Y     139          1.900
LGA    I   111_A      I     140          1.503
LGA    S   112_A      S     141          1.809
LGA    T   113_A      K     142          2.751
LGA    S   114_A      P     143          4.490
LGA    -       -      I     144           -
LGA    -       -      H     145           -
LGA    -       -      Q     146           -
LGA    N   115_A      H     147          3.896
LGA    G   116_A      E     148          3.523
LGA    S   117_A      -       -           -
LGA    L   118_A      -       -           -
LGA    E   119_A      -       -           -
LGA    G   120_A      -       -           -
LGA    L   121_A      -       -           -
LGA    D   122_A      -       -           -
LGA    N   123_A      -       -           -
LGA    Q   124_A      -       -           -
LGA    E   125_A      -       -           -
LGA    G   126_A      -       -           -
LGA    G   127_A      D     149           #
LGA    V   128_A      R     150          2.439
LGA    C   129_A      C     151          2.452
LGA    Q   130_A      -       -           -
LGA    T   131_A      -       -           -
LGA    R   132_A      -       -           -
LGA    A   133_A      -       -           -
LGA    M   134_A      L     152          1.659
LGA    K   135_A      R     153          1.366
LGA    I   136_A      L     154          1.489
LGA    L   137_A      K     155          1.469
LGA    M   138_A      V     156          2.331
LGA    K   139_A      T     157          2.397
LGA    V   140_A      V     158          3.061
LGA    G   141_A      S     159           #
LGA    Q   142_A      G     160          4.327

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  142  130    5.0     98    3.00    25.51     44.235     3.157

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.171582 * X  +   0.840566 * Y  +  -0.513817 * Z  + -31.670187
  Y_new =  -0.118137 * X  +   0.500233 * Y  +   0.857794 * Z  + -22.296072
  Z_new =   0.978061 * X  +   0.207883 * Y  +   0.013471 * Z  +  12.510710 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.506086   -1.635507  [ DEG:    86.2923    -93.7077 ]
  Theta =  -1.360940   -1.780652  [ DEG:   -77.9761   -102.0239 ]
  Phi   =  -2.538615    0.602978  [ DEG:  -145.4519     34.5481 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i85_A                                        
REMARK     2: T0390.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i85_A.T0390.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  142  130   5.0   98   3.00   25.51  44.235
REMARK  ---------------------------------------------------------- 
MOLECULE 2i85_A
HEADER    SIGNALING PROTEIN                       01-SEP-06   2I85              
TITLE     NMR SOLUTION STRUCTURE OF HUMAN EPHRINB2 ECTODOMAIN                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: EPHRIN-B2;                                                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: ECTODOMAIN, RESIDUES 1-142;                                
COMPND   5 SYNONYM: EPH-RELATED RECEPTOR TYROSINE KINASE LIGAND 5,              
COMPND   6 LERK-5, HTK LIGAND, HTK-L;                                           
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 CELL_LINE: HELA CELLS;                                               
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET-32A                                   
KEYWDS    EPHRINB2 ECTODOMAIN, NMR SOLUTION STRUCTURE, SIGNALING                
KEYWDS   2 PROTEIN                                                              
EXPDTA    NMR, 10 STRUCTURES                                                    
AUTHOR    X.RAN,J.FAN,J.SONG                                                    
REVDAT   1   04-SEP-07 2I85    0                                                
JRNL        AUTH   X.RAN,J.FAN,J.SONG                                           
JRNL        TITL   NMR SOLUTION STRUCTURE OF HUMAN EPHRINB2 ECTODOMAIN          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2I85 A    1   142  UNP    P52799   EFNB2_HUMAN     25    166             
SEQRES   1 A  142  SER LYS SER ILE VAL LEU GLU PRO ILE TYR TRP ASN SER          
SEQRES   2 A  142  SER ASN SER LYS PHE LEU PRO GLY GLN GLY LEU VAL LEU          
SEQRES   3 A  142  TYR PRO GLN ILE GLY ASP LYS LEU ASP ILE ILE CYS PRO          
SEQRES   4 A  142  LYS VAL ASP SER LYS THR VAL GLY GLN TYR GLU TYR TYR          
SEQRES   5 A  142  LYS VAL TYR MET VAL ASP LYS ASP GLN ALA ASP ARG CYS          
SEQRES   6 A  142  THR ILE LYS LYS GLU ASN THR PRO LEU LEU ASN CYS ALA          
SEQRES   7 A  142  LYS PRO ASP GLN ASP ILE LYS PHE THR ILE LYS PHE GLN          
SEQRES   8 A  142  GLU PHE SER PRO ASN LEU TRP GLY LEU GLU PHE GLN LYS          
SEQRES   9 A  142  ASN LYS ASP TYR TYR ILE ILE SER THR SER ASN GLY SER          
SEQRES  10 A  142  LEU GLU GLY LEU ASP ASN GLN GLU GLY GLY VAL CYS GLN          
SEQRES  11 A  142  THR ARG ALA MET LYS ILE LEU MET LYS VAL GLY GLN              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   SER A   1     -23.396   1.392   9.461  1.00  0.00           N  
ATOM      2  CA  SER A   1     -24.654   0.630   9.272  1.00  0.00           C  
ATOM      3  C   SER A   1     -24.685  -0.063   7.902  1.00  0.00           C  
ATOM      4  O   SER A   1     -25.306   0.413   6.946  1.00  0.00           O  
ATOM      5  CB  SER A   1     -25.881   1.534   9.493  1.00  0.00           C  
ATOM      6  OG  SER A   1     -25.714   2.787   8.838  1.00  0.00           O  
ATOM      7  H1  SER A   1     -22.734   1.409   8.698  1.00  0.00           H  
ATOM      8  HA  SER A   1     -24.700  -0.157  10.028  1.00  0.00           H  
ATOM      9  HB3 SER A   1     -26.004   1.715  10.563  1.00  0.00           H  
ATOM     10  HG  SER A   1     -26.550   3.290   8.923  1.00  0.00           H  
ATOM     11  N   LYS A   2     -23.997  -1.210   7.783  1.00  0.00           N  
ATOM     12  CA  LYS A   2     -23.977  -2.052   6.564  1.00  0.00           C  
ATOM     13  C   LYS A   2     -25.202  -2.990   6.515  1.00  0.00           C  
ATOM     14  O   LYS A   2     -25.855  -3.188   7.541  1.00  0.00           O  
ATOM     15  CB  LYS A   2     -22.625  -2.801   6.515  1.00  0.00           C  
ATOM     16  CG  LYS A   2     -22.059  -2.950   5.093  1.00  0.00           C  
ATOM     17  CD  LYS A   2     -20.523  -3.012   5.133  1.00  0.00           C  
ATOM     18  CE  LYS A   2     -19.937  -3.217   3.729  1.00  0.00           C  
ATOM     19  NZ  LYS A   2     -18.765  -2.330   3.476  1.00  0.00           N  
ATOM     20  H   LYS A   2     -23.541  -1.585   8.606  1.00  0.00           H  
ATOM     21  HA  LYS A   2     -24.039  -1.396   5.695  1.00  0.00           H  
ATOM     22  HB3 LYS A   2     -22.712  -3.788   6.968  1.00  0.00           H  
ATOM     23  HG3 LYS A   2     -22.340  -2.087   4.489  1.00  0.00           H  
ATOM     24  HD3 LYS A   2     -20.202  -3.830   5.781  1.00  0.00           H  
ATOM     25  HE3 LYS A   2     -20.714  -3.016   2.986  1.00  0.00           H  
ATOM     26  HZ1 LYS A   2     -18.363  -2.516   2.567  1.00  0.00           H  
ATOM     27  HZ2 LYS A   2     -19.034  -1.356   3.492  1.00  0.00           H  
ATOM     28  HZ3 LYS A   2     -18.040  -2.468   4.166  1.00  0.00           H  
ATOM     29  N   SER A   3     -25.502  -3.562   5.343  1.00  0.00           N  
ATOM     30  CA  SER A   3     -26.607  -4.522   5.118  1.00  0.00           C  
ATOM     31  C   SER A   3     -26.325  -5.427   3.901  1.00  0.00           C  
ATOM     32  O   SER A   3     -26.929  -5.260   2.838  1.00  0.00           O  
ATOM     33  CB  SER A   3     -27.960  -3.792   4.953  1.00  0.00           C  
ATOM     34  OG  SER A   3     -28.505  -3.414   6.208  1.00  0.00           O  
ATOM     35  H   SER A   3     -24.913  -3.336   4.554  1.00  0.00           H  
ATOM     36  HA  SER A   3     -26.693  -5.178   5.989  1.00  0.00           H  
ATOM     37  HB3 SER A   3     -28.673  -4.463   4.470  1.00  0.00           H  
ATOM     38  HG  SER A   3     -29.365  -2.982   6.054  1.00  0.00           H  
ATOM     39  N   ILE A   4     -25.401  -6.387   4.039  1.00  0.00           N  
ATOM     40  CA  ILE A   4     -25.263  -7.523   3.098  1.00  0.00           C  
ATOM     41  C   ILE A   4     -26.312  -8.632   3.396  1.00  0.00           C  
ATOM     42  O   ILE A   4     -27.332  -8.383   4.039  1.00  0.00           O  
ATOM     43  CB  ILE A   4     -23.805  -8.054   3.047  1.00  0.00           C  
ATOM     44  CG1 ILE A   4     -23.290  -8.583   4.405  1.00  0.00           C  
ATOM     45  CG2 ILE A   4     -22.886  -7.025   2.361  1.00  0.00           C  
ATOM     46  CD1 ILE A   4     -22.373  -7.638   5.190  1.00  0.00           C  
ATOM     47  H   ILE A   4     -24.955  -6.467   4.947  1.00  0.00           H  
ATOM     48  HA  ILE A   4     -25.490  -7.173   2.088  1.00  0.00           H  
ATOM     49  HB  ILE A   4     -23.780  -8.908   2.374  1.00  0.00           H  
ATOM     50 HG13 ILE A   4     -22.735  -9.510   4.242  1.00  0.00           H  
ATOM     51 HG21 ILE A   4     -23.244  -6.825   1.346  1.00  0.00           H  
ATOM     52 HG22 ILE A   4     -22.880  -6.086   2.915  1.00  0.00           H  
ATOM     53 HG23 ILE A   4     -21.865  -7.412   2.291  1.00  0.00           H  
ATOM     54 HD11 ILE A   4     -22.251  -8.009   6.211  1.00  0.00           H  
ATOM     55 HD12 ILE A   4     -21.385  -7.595   4.720  1.00  0.00           H  
ATOM     56 HD13 ILE A   4     -22.792  -6.630   5.226  1.00  0.00           H  
ATOM     57  N   VAL A   5     -26.084  -9.847   2.887  1.00  0.00           N  
ATOM     58  CA  VAL A   5     -26.973 -11.020   2.918  1.00  0.00           C  
ATOM     59  C   VAL A   5     -26.136 -12.303   3.033  1.00  0.00           C  
ATOM     60  O   VAL A   5     -25.568 -12.776   2.047  1.00  0.00           O  
ATOM     61  CB  VAL A   5     -27.898 -11.072   1.675  1.00  0.00           C  
ATOM     62  CG1 VAL A   5     -29.239 -10.386   1.951  1.00  0.00           C  
ATOM     63  CG2 VAL A   5     -27.306 -10.449   0.398  1.00  0.00           C  
ATOM     64  H   VAL A   5     -25.214  -9.973   2.395  1.00  0.00           H  
ATOM     65  HA  VAL A   5     -27.602 -10.968   3.803  1.00  0.00           H  
ATOM     66  HB  VAL A   5     -28.124 -12.113   1.461  1.00  0.00           H  
ATOM     67 HG11 VAL A   5     -29.704 -10.830   2.831  1.00  0.00           H  
ATOM     68 HG12 VAL A   5     -29.094  -9.319   2.119  1.00  0.00           H  
ATOM     69 HG13 VAL A   5     -29.909 -10.534   1.103  1.00  0.00           H  
ATOM     70 HG21 VAL A   5     -27.958 -10.659  -0.451  1.00  0.00           H  
ATOM     71 HG22 VAL A   5     -27.221  -9.368   0.507  1.00  0.00           H  
ATOM     72 HG23 VAL A   5     -26.321 -10.871   0.196  1.00  0.00           H  
ATOM     73  N   LEU A   6     -26.067 -12.882   4.235  1.00  0.00           N  
ATOM     74  CA  LEU A   6     -25.486 -14.200   4.539  1.00  0.00           C  
ATOM     75  C   LEU A   6     -26.594 -15.182   4.951  1.00  0.00           C  
ATOM     76  O   LEU A   6     -27.783 -14.863   4.913  1.00  0.00           O  
ATOM     77  CB  LEU A   6     -24.409 -14.069   5.642  1.00  0.00           C  
ATOM     78  CG  LEU A   6     -23.117 -13.353   5.215  1.00  0.00           C  
ATOM     79  CD1 LEU A   6     -22.192 -13.176   6.420  1.00  0.00           C  
ATOM     80  CD2 LEU A   6     -22.337 -14.184   4.190  1.00  0.00           C  
ATOM     81  H   LEU A   6     -26.549 -12.417   4.998  1.00  0.00           H  
ATOM     82  HA  LEU A   6     -25.025 -14.625   3.651  1.00  0.00           H  
ATOM     83  HB3 LEU A   6     -24.127 -15.054   6.010  1.00  0.00           H  
ATOM     84  HG  LEU A   6     -23.346 -12.375   4.790  1.00  0.00           H  
ATOM     85 HD11 LEU A   6     -22.682 -12.566   7.173  1.00  0.00           H  
ATOM     86 HD12 LEU A   6     -21.953 -14.146   6.852  1.00  0.00           H  
ATOM     87 HD13 LEU A   6     -21.272 -12.676   6.117  1.00  0.00           H  
ATOM     88 HD21 LEU A   6     -21.393 -13.691   3.958  1.00  0.00           H  
ATOM     89 HD22 LEU A   6     -22.129 -15.176   4.594  1.00  0.00           H  
ATOM     90 HD23 LEU A   6     -22.907 -14.277   3.268  1.00  0.00           H  
ATOM     91  N   GLU A   7     -26.196 -16.405   5.313  1.00  0.00           N  
ATOM     92  CA  GLU A   7     -27.080 -17.551   5.550  1.00  0.00           C  
ATOM     93  C   GLU A   7     -28.228 -17.686   4.506  1.00  0.00           C  
ATOM     94  O   GLU A   7     -29.397 -17.760   4.888  1.00  0.00           O  
ATOM     95  CB  GLU A   7     -27.594 -17.467   7.006  1.00  0.00           C  
ATOM     96  CG  GLU A   7     -27.879 -18.839   7.633  1.00  0.00           C  
ATOM     97  CD  GLU A   7     -29.244 -19.016   8.353  1.00  0.00           C  
ATOM     98  OE1 GLU A   7     -30.137 -18.136   8.305  1.00  0.00           O  
ATOM     99  OE2 GLU A   7     -29.433 -20.078   8.994  1.00  0.00           O  
ATOM    100  H   GLU A   7     -25.202 -16.580   5.326  1.00  0.00           H  
ATOM    101  HA  GLU A   7     -26.466 -18.449   5.457  1.00  0.00           H  
ATOM    102  HB3 GLU A   7     -28.481 -16.846   7.021  1.00  0.00           H  
ATOM    103  HG3 GLU A   7     -27.079 -19.047   8.341  1.00  0.00           H  
ATOM    104  N   PRO A   8     -27.958 -17.630   3.180  1.00  0.00           N  
ATOM    105  CA  PRO A   8     -29.005 -17.584   2.160  1.00  0.00           C  
ATOM    106  C   PRO A   8     -29.710 -18.943   2.034  1.00  0.00           C  
ATOM    107  O   PRO A   8     -29.188 -19.864   1.400  1.00  0.00           O  
ATOM    108  CB  PRO A   8     -28.297 -17.154   0.871  1.00  0.00           C  
ATOM    109  CG  PRO A   8     -26.871 -17.674   1.036  1.00  0.00           C  
ATOM    110  CD  PRO A   8     -26.644 -17.626   2.546  1.00  0.00           C  
ATOM    111  HA  PRO A   8     -29.747 -16.827   2.419  1.00  0.00           H  
ATOM    112  HB3 PRO A   8     -28.278 -16.064   0.810  1.00  0.00           H  
ATOM    113  HG3 PRO A   8     -26.153 -17.045   0.506  1.00  0.00           H  
ATOM    114  HD3 PRO A   8     -26.120 -16.703   2.777  1.00  0.00           H  
ATOM    115  N   ILE A   9     -30.885 -19.096   2.657  1.00  0.00           N  
ATOM    116  CA  ILE A   9     -31.657 -20.347   2.635  1.00  0.00           C  
ATOM    117  C   ILE A   9     -32.773 -20.200   1.605  1.00  0.00           C  
ATOM    118  O   ILE A   9     -33.753 -19.490   1.827  1.00  0.00           O  
ATOM    119  CB  ILE A   9     -32.226 -20.756   4.014  1.00  0.00           C  
ATOM    120  CG1 ILE A   9     -31.317 -20.446   5.220  1.00  0.00           C  
ATOM    121  CG2 ILE A   9     -32.586 -22.249   4.012  1.00  0.00           C  
ATOM    122  CD1 ILE A   9     -29.926 -21.088   5.157  1.00  0.00           C  
ATOM    123  H   ILE A   9     -31.256 -18.310   3.184  1.00  0.00           H  
ATOM    124  HA  ILE A   9     -31.000 -21.157   2.317  1.00  0.00           H  
ATOM    125  HB  ILE A   9     -33.147 -20.209   4.174  1.00  0.00           H  
ATOM    126 HG13 ILE A   9     -31.793 -20.783   6.140  1.00  0.00           H  
ATOM    127 HG21 ILE A   9     -33.350 -22.450   3.260  1.00  0.00           H  
ATOM    128 HG22 ILE A   9     -31.708 -22.856   3.797  1.00  0.00           H  
ATOM    129 HG23 ILE A   9     -32.982 -22.538   4.986  1.00  0.00           H  
ATOM    130 HD11 ILE A   9     -29.338 -20.716   5.987  1.00  0.00           H  
ATOM    131 HD12 ILE A   9     -29.999 -22.169   5.255  1.00  0.00           H  
ATOM    132 HD13 ILE A   9     -29.422 -20.834   4.227  1.00  0.00           H  
ATOM    133  N   TYR A  10     -32.623 -20.897   0.482  1.00  0.00           N  
ATOM    134  CA  TYR A  10     -33.589 -20.947  -0.618  1.00  0.00           C  
ATOM    135  C   TYR A  10     -34.094 -22.384  -0.758  1.00  0.00           C  
ATOM    136  O   TYR A  10     -33.708 -23.119  -1.670  1.00  0.00           O  
ATOM    137  CB  TYR A  10     -32.981 -20.398  -1.920  1.00  0.00           C  
ATOM    138  CG  TYR A  10     -32.327 -19.031  -1.819  1.00  0.00           C  
ATOM    139  CD1 TYR A  10     -33.074 -17.915  -1.391  1.00  0.00           C  
ATOM    140  CD2 TYR A  10     -30.977 -18.879  -2.185  1.00  0.00           C  
ATOM    141  CE1 TYR A  10     -32.466 -16.643  -1.329  1.00  0.00           C  
ATOM    142  CE2 TYR A  10     -30.373 -17.610  -2.143  1.00  0.00           C  
ATOM    143  CZ  TYR A  10     -31.112 -16.490  -1.708  1.00  0.00           C  
ATOM    144  OH  TYR A  10     -30.515 -15.268  -1.665  1.00  0.00           O  
ATOM    145  H   TYR A  10     -31.766 -21.417   0.368  1.00  0.00           H  
ATOM    146  HA  TYR A  10     -34.453 -20.327  -0.376  1.00  0.00           H  
ATOM    147  HB3 TYR A  10     -33.769 -20.344  -2.674  1.00  0.00           H  
ATOM    148  HD1 TYR A  10     -34.113 -18.029  -1.108  1.00  0.00           H  
ATOM    149  HD2 TYR A  10     -30.402 -19.737  -2.514  1.00  0.00           H  
ATOM    150  HE1 TYR A  10     -33.033 -15.787  -0.992  1.00  0.00           H  
ATOM    151  HE2 TYR A  10     -29.338 -17.488  -2.434  1.00  0.00           H  
ATOM    152  HH  TYR A  10     -31.117 -14.573  -1.352  1.00  0.00           H  
ATOM    153  N   TRP A  11     -34.885 -22.807   0.237  1.00  0.00           N  
ATOM    154  CA  TRP A  11     -35.571 -24.103   0.340  1.00  0.00           C  
ATOM    155  C   TRP A  11     -34.620 -25.234   0.756  1.00  0.00           C  
ATOM    156  O   TRP A  11     -34.806 -25.834   1.814  1.00  0.00           O  
ATOM    157  CB  TRP A  11     -36.341 -24.410  -0.967  1.00  0.00           C  
ATOM    158  CG  TRP A  11     -37.003 -23.239  -1.654  1.00  0.00           C  
ATOM    159  CD1 TRP A  11     -37.597 -22.180  -1.051  1.00  0.00           C  
ATOM    160  CD2 TRP A  11     -37.029 -22.926  -3.084  1.00  0.00           C  
ATOM    161  NE1 TRP A  11     -37.990 -21.254  -1.995  1.00  0.00           N  
ATOM    162  CE2 TRP A  11     -37.639 -21.645  -3.268  1.00  0.00           C  
ATOM    163  CE3 TRP A  11     -36.564 -23.580  -4.245  1.00  0.00           C  
ATOM    164  CZ2 TRP A  11     -37.764 -21.039  -4.527  1.00  0.00           C  
ATOM    165  CZ3 TRP A  11     -36.690 -22.989  -5.520  1.00  0.00           C  
ATOM    166  CH2 TRP A  11     -37.283 -21.724  -5.659  1.00  0.00           C  
ATOM    167  H   TRP A  11     -35.109 -22.130   0.961  1.00  0.00           H  
ATOM    168  HA  TRP A  11     -36.305 -24.015   1.141  1.00  0.00           H  
ATOM    169  HB3 TRP A  11     -37.085 -25.179  -0.764  1.00  0.00           H  
ATOM    170  HD1 TRP A  11     -37.694 -22.056   0.020  1.00  0.00           H  
ATOM    171  HE1 TRP A  11     -38.444 -20.378  -1.760  1.00  0.00           H  
ATOM    172  HE3 TRP A  11     -36.092 -24.547  -4.147  1.00  0.00           H  
ATOM    173  HZ2 TRP A  11     -38.212 -20.060  -4.622  1.00  0.00           H  
ATOM    174  HZ3 TRP A  11     -36.316 -23.508  -6.395  1.00  0.00           H  
ATOM    175  HH2 TRP A  11     -37.367 -21.269  -6.639  1.00  0.00           H  
ATOM    176  N   ASN A  12     -33.574 -25.469  -0.042  1.00  0.00           N  
ATOM    177  CA  ASN A  12     -32.453 -26.384   0.210  1.00  0.00           C  
ATOM    178  C   ASN A  12     -31.307 -26.108  -0.798  1.00  0.00           C  
ATOM    179  O   ASN A  12     -31.012 -26.932  -1.670  1.00  0.00           O  
ATOM    180  CB  ASN A  12     -32.945 -27.846   0.174  1.00  0.00           C  
ATOM    181  CG  ASN A  12     -31.898 -28.795   0.733  1.00  0.00           C  
ATOM    182  OD1 ASN A  12     -31.685 -28.877   1.935  1.00  0.00           O  
ATOM    183  ND2 ASN A  12     -31.200 -29.529  -0.102  1.00  0.00           N  
ATOM    184  H   ASN A  12     -33.524 -24.896  -0.878  1.00  0.00           H  
ATOM    185  HA  ASN A  12     -32.060 -26.178   1.209  1.00  0.00           H  
ATOM    186  HB3 ASN A  12     -33.216 -28.132  -0.844  1.00  0.00           H  
ATOM    187 HD21 ASN A  12     -31.312 -29.395  -1.096  1.00  0.00           H  
ATOM    188 HD22 ASN A  12     -30.496 -30.146   0.271  1.00  0.00           H  
ATOM    189  N   SER A  13     -30.702 -24.915  -0.736  1.00  0.00           N  
ATOM    190  CA  SER A  13     -29.621 -24.490  -1.646  1.00  0.00           C  
ATOM    191  C   SER A  13     -28.232 -24.617  -1.002  1.00  0.00           C  
ATOM    192  O   SER A  13     -28.103 -24.760   0.220  1.00  0.00           O  
ATOM    193  CB  SER A  13     -29.871 -23.058  -2.130  1.00  0.00           C  
ATOM    194  OG  SER A  13     -29.103 -22.809  -3.298  1.00  0.00           O  
ATOM    195  H   SER A  13     -30.955 -24.295   0.016  1.00  0.00           H  
ATOM    196  HA  SER A  13     -29.625 -25.129  -2.531  1.00  0.00           H  
ATOM    197  HB3 SER A  13     -29.610 -22.345  -1.345  1.00  0.00           H  
ATOM    198  HG  SER A  13     -29.336 -21.928  -3.647  1.00  0.00           H  
ATOM    199  N   SER A  14     -27.177 -24.562  -1.820  1.00  0.00           N  
ATOM    200  CA  SER A  14     -25.786 -24.568  -1.351  1.00  0.00           C  
ATOM    201  C   SER A  14     -25.468 -23.293  -0.559  1.00  0.00           C  
ATOM    202  O   SER A  14     -25.915 -22.200  -0.918  1.00  0.00           O  
ATOM    203  CB  SER A  14     -24.831 -24.706  -2.540  1.00  0.00           C  
ATOM    204  OG  SER A  14     -23.590 -25.210  -2.077  1.00  0.00           O  
ATOM    205  H   SER A  14     -27.357 -24.354  -2.793  1.00  0.00           H  
ATOM    206  HA  SER A  14     -25.646 -25.434  -0.700  1.00  0.00           H  
ATOM    207  HB3 SER A  14     -24.689 -23.736  -3.021  1.00  0.00           H  
ATOM    208  HG  SER A  14     -23.031 -25.419  -2.850  1.00  0.00           H  
ATOM    209  N   ASN A  15     -24.678 -23.422   0.509  1.00  0.00           N  
ATOM    210  CA  ASN A  15     -24.289 -22.325   1.402  1.00  0.00           C  
ATOM    211  C   ASN A  15     -22.763 -22.102   1.372  1.00  0.00           C  
ATOM    212  O   ASN A  15     -22.023 -22.921   0.828  1.00  0.00           O  
ATOM    213  CB  ASN A  15     -24.825 -22.631   2.817  1.00  0.00           C  
ATOM    214  CG  ASN A  15     -25.490 -21.408   3.413  1.00  0.00           C  
ATOM    215  OD1 ASN A  15     -24.834 -20.488   3.880  1.00  0.00           O  
ATOM    216  ND2 ASN A  15     -26.800 -21.343   3.377  1.00  0.00           N  
ATOM    217  H   ASN A  15     -24.302 -24.340   0.701  1.00  0.00           H  
ATOM    218  HA  ASN A  15     -24.749 -21.398   1.054  1.00  0.00           H  
ATOM    219  HB3 ASN A  15     -24.016 -22.943   3.480  1.00  0.00           H  
ATOM    220 HD21 ASN A  15     -27.330 -22.078   2.936  1.00  0.00           H  
ATOM    221 HD22 ASN A  15     -27.256 -20.524   3.735  1.00  0.00           H  
ATOM    222  N   SER A  16     -22.269 -21.022   1.991  1.00  0.00           N  
ATOM    223  CA  SER A  16     -20.818 -20.754   2.095  1.00  0.00           C  
ATOM    224  C   SER A  16     -20.079 -21.900   2.813  1.00  0.00           C  
ATOM    225  O   SER A  16     -19.017 -22.350   2.368  1.00  0.00           O  
ATOM    226  CB  SER A  16     -20.579 -19.385   2.764  1.00  0.00           C  
ATOM    227  OG  SER A  16     -19.604 -19.420   3.796  1.00  0.00           O  
ATOM    228  H   SER A  16     -22.912 -20.388   2.448  1.00  0.00           H  
ATOM    229  HA  SER A  16     -20.408 -20.698   1.085  1.00  0.00           H  
ATOM    230  HB3 SER A  16     -21.516 -19.019   3.189  1.00  0.00           H  
ATOM    231  HG  SER A  16     -19.489 -18.515   4.142  1.00  0.00           H  
ATOM    232  N   LYS A  17     -20.685 -22.420   3.890  1.00  0.00           N  
ATOM    233  CA  LYS A  17     -20.154 -23.516   4.714  1.00  0.00           C  
ATOM    234  C   LYS A  17     -20.433 -24.907   4.133  1.00  0.00           C  
ATOM    235  O   LYS A  17     -19.585 -25.785   4.274  1.00  0.00           O  
ATOM    236  CB  LYS A  17     -20.703 -23.363   6.147  1.00  0.00           C  
ATOM    237  CG  LYS A  17     -20.174 -22.093   6.840  1.00  0.00           C  
ATOM    238  CD  LYS A  17     -18.712 -22.215   7.304  1.00  0.00           C  
ATOM    239  CE  LYS A  17     -18.125 -20.832   7.618  1.00  0.00           C  
ATOM    240  NZ  LYS A  17     -16.787 -20.933   8.266  1.00  0.00           N  
ATOM    241  H   LYS A  17     -21.523 -21.951   4.203  1.00  0.00           H  
ATOM    242  HA  LYS A  17     -19.066 -23.435   4.745  1.00  0.00           H  
ATOM    243  HB3 LYS A  17     -20.431 -24.225   6.751  1.00  0.00           H  
ATOM    244  HG3 LYS A  17     -20.798 -21.897   7.709  1.00  0.00           H  
ATOM    245  HD3 LYS A  17     -18.103 -22.679   6.528  1.00  0.00           H  
ATOM    246  HE3 LYS A  17     -18.813 -20.287   8.270  1.00  0.00           H  
ATOM    247  HZ1 LYS A  17     -16.397 -20.015   8.433  1.00  0.00           H  
ATOM    248  HZ2 LYS A  17     -16.837 -21.407   9.156  1.00  0.00           H  
ATOM    249  HZ3 LYS A  17     -16.133 -21.436   7.683  1.00  0.00           H  
ATOM    250  N   PHE A  18     -21.571 -25.091   3.450  1.00  0.00           N  
ATOM    251  CA  PHE A  18     -21.994 -26.341   2.784  1.00  0.00           C  
ATOM    252  C   PHE A  18     -21.727 -27.608   3.638  1.00  0.00           C  
ATOM    253  O   PHE A  18     -20.903 -28.454   3.290  1.00  0.00           O  
ATOM    254  CB  PHE A  18     -21.406 -26.371   1.355  1.00  0.00           C  
ATOM    255  CG  PHE A  18     -21.657 -27.649   0.570  1.00  0.00           C  
ATOM    256  CD1 PHE A  18     -22.952 -27.980   0.125  1.00  0.00           C  
ATOM    257  CD2 PHE A  18     -20.592 -28.544   0.334  1.00  0.00           C  
ATOM    258  CE1 PHE A  18     -23.184 -29.209  -0.525  1.00  0.00           C  
ATOM    259  CE2 PHE A  18     -20.822 -29.777  -0.302  1.00  0.00           C  
ATOM    260  CZ  PHE A  18     -22.120 -30.108  -0.732  1.00  0.00           C  
ATOM    261  H   PHE A  18     -22.171 -24.289   3.354  1.00  0.00           H  
ATOM    262  HA  PHE A  18     -23.078 -26.295   2.669  1.00  0.00           H  
ATOM    263  HB3 PHE A  18     -20.329 -26.201   1.411  1.00  0.00           H  
ATOM    264  HD1 PHE A  18     -23.775 -27.298   0.292  1.00  0.00           H  
ATOM    265  HD2 PHE A  18     -19.598 -28.306   0.690  1.00  0.00           H  
ATOM    266  HE1 PHE A  18     -24.184 -29.469  -0.855  1.00  0.00           H  
ATOM    267  HE2 PHE A  18     -20.005 -30.475  -0.445  1.00  0.00           H  
ATOM    268  HZ  PHE A  18     -22.301 -31.060  -1.215  1.00  0.00           H  
ATOM    269  N   LEU A  19     -22.379 -27.704   4.811  1.00  0.00           N  
ATOM    270  CA  LEU A  19     -22.211 -28.758   5.835  1.00  0.00           C  
ATOM    271  C   LEU A  19     -20.747 -29.257   5.985  1.00  0.00           C  
ATOM    272  O   LEU A  19     -20.419 -30.390   5.624  1.00  0.00           O  
ATOM    273  CB  LEU A  19     -23.309 -29.844   5.715  1.00  0.00           C  
ATOM    274  CG  LEU A  19     -23.199 -30.850   4.546  1.00  0.00           C  
ATOM    275  CD1 LEU A  19     -22.940 -32.273   5.057  1.00  0.00           C  
ATOM    276  CD2 LEU A  19     -24.498 -30.906   3.738  1.00  0.00           C  
ATOM    277  H   LEU A  19     -23.015 -26.953   5.050  1.00  0.00           H  
ATOM    278  HA  LEU A  19     -22.431 -28.285   6.790  1.00  0.00           H  
ATOM    279  HB3 LEU A  19     -24.268 -29.329   5.650  1.00  0.00           H  
ATOM    280  HG  LEU A  19     -22.397 -30.562   3.871  1.00  0.00           H  
ATOM    281 HD11 LEU A  19     -22.052 -32.291   5.685  1.00  0.00           H  
ATOM    282 HD12 LEU A  19     -23.786 -32.621   5.647  1.00  0.00           H  
ATOM    283 HD13 LEU A  19     -22.783 -32.945   4.215  1.00  0.00           H  
ATOM    284 HD21 LEU A  19     -24.391 -31.621   2.921  1.00  0.00           H  
ATOM    285 HD22 LEU A  19     -25.324 -31.214   4.382  1.00  0.00           H  
ATOM    286 HD23 LEU A  19     -24.710 -29.921   3.321  1.00  0.00           H  
ATOM    287  N   PRO A  20     -19.824 -28.417   6.506  1.00  0.00           N  
ATOM    288  CA  PRO A  20     -18.383 -28.707   6.513  1.00  0.00           C  
ATOM    289  C   PRO A  20     -17.970 -29.828   7.497  1.00  0.00           C  
ATOM    290  O   PRO A  20     -16.805 -30.231   7.527  1.00  0.00           O  
ATOM    291  CB  PRO A  20     -17.708 -27.373   6.860  1.00  0.00           C  
ATOM    292  CG  PRO A  20     -18.749 -26.621   7.685  1.00  0.00           C  
ATOM    293  CD  PRO A  20     -20.090 -27.148   7.173  1.00  0.00           C  
ATOM    294  HA  PRO A  20     -18.073 -29.000   5.507  1.00  0.00           H  
ATOM    295  HB3 PRO A  20     -17.508 -26.818   5.941  1.00  0.00           H  
ATOM    296  HG3 PRO A  20     -18.659 -25.542   7.545  1.00  0.00           H  
ATOM    297  HD3 PRO A  20     -20.533 -26.449   6.475  1.00  0.00           H  
ATOM    298  N   GLY A  21     -18.919 -30.326   8.301  1.00  0.00           N  
ATOM    299  CA  GLY A  21     -18.744 -31.315   9.374  1.00  0.00           C  
ATOM    300  C   GLY A  21     -19.470 -30.923  10.676  1.00  0.00           C  
ATOM    301  O   GLY A  21     -19.564 -31.739  11.592  1.00  0.00           O  
ATOM    302  H   GLY A  21     -19.862 -30.021   8.105  1.00  0.00           H  
ATOM    303  HA2 GLY A  21     -19.157 -32.263   9.027  1.00  0.00           H  
ATOM    304  N   GLN A  22     -20.010 -29.695  10.736  1.00  0.00           N  
ATOM    305  CA  GLN A  22     -20.782 -29.128  11.853  1.00  0.00           C  
ATOM    306  C   GLN A  22     -22.216 -28.729  11.450  1.00  0.00           C  
ATOM    307  O   GLN A  22     -23.137 -28.894  12.249  1.00  0.00           O  
ATOM    308  CB  GLN A  22     -19.975 -27.949  12.436  1.00  0.00           C  
ATOM    309  CG  GLN A  22     -20.821 -26.933  13.222  1.00  0.00           C  
ATOM    310  CD  GLN A  22     -19.964 -25.839  13.833  1.00  0.00           C  
ATOM    311  OE1 GLN A  22     -19.788 -24.776  13.261  1.00  0.00           O  
ATOM    312  NE2 GLN A  22     -19.395 -26.048  14.999  1.00  0.00           N  
ATOM    313  H   GLN A  22     -19.760 -29.076   9.982  1.00  0.00           H  
ATOM    314  HA  GLN A  22     -20.878 -29.875  12.640  1.00  0.00           H  
ATOM    315  HB3 GLN A  22     -19.470 -27.413  11.628  1.00  0.00           H  
ATOM    316  HG3 GLN A  22     -21.363 -27.443  14.012  1.00  0.00           H  
ATOM    317 HE21 GLN A  22     -19.503 -26.928  15.474  1.00  0.00           H  
ATOM    318 HE22 GLN A  22     -18.833 -25.310  15.388  1.00  0.00           H  
ATOM    319  N   GLY A  23     -22.413 -28.182  10.245  1.00  0.00           N  
ATOM    320  CA  GLY A  23     -23.720 -27.771   9.720  1.00  0.00           C  
ATOM    321  C   GLY A  23     -23.658 -26.413   9.041  1.00  0.00           C  
ATOM    322  O   GLY A  23     -23.280 -26.325   7.873  1.00  0.00           O  
ATOM    323  H   GLY A  23     -21.617 -28.064   9.642  1.00  0.00           H  
ATOM    324  HA2 GLY A  23     -24.053 -28.495   8.975  1.00  0.00           H  
ATOM    325  N   LEU A  24     -23.997 -25.345   9.765  1.00  0.00           N  
ATOM    326  CA  LEU A  24     -24.051 -24.000   9.198  1.00  0.00           C  
ATOM    327  C   LEU A  24     -23.619 -22.943  10.221  1.00  0.00           C  
ATOM    328  O   LEU A  24     -24.299 -22.707  11.214  1.00  0.00           O  
ATOM    329  CB  LEU A  24     -25.470 -23.752   8.644  1.00  0.00           C  
ATOM    330  CG  LEU A  24     -25.443 -23.068   7.261  1.00  0.00           C  
ATOM    331  CD1 LEU A  24     -26.170 -23.928   6.230  1.00  0.00           C  
ATOM    332  CD2 LEU A  24     -26.118 -21.706   7.318  1.00  0.00           C  
ATOM    333  H   LEU A  24     -24.295 -25.478  10.728  1.00  0.00           H  
ATOM    334  HA  LEU A  24     -23.338 -23.960   8.374  1.00  0.00           H  
ATOM    335  HB3 LEU A  24     -26.053 -23.158   9.350  1.00  0.00           H  
ATOM    336  HG  LEU A  24     -24.418 -22.918   6.916  1.00  0.00           H  
ATOM    337 HD11 LEU A  24     -25.661 -24.891   6.137  1.00  0.00           H  
ATOM    338 HD12 LEU A  24     -27.201 -24.095   6.540  1.00  0.00           H  
ATOM    339 HD13 LEU A  24     -26.165 -23.437   5.262  1.00  0.00           H  
ATOM    340 HD21 LEU A  24     -26.063 -21.229   6.340  1.00  0.00           H  
ATOM    341 HD22 LEU A  24     -27.162 -21.821   7.610  1.00  0.00           H  
ATOM    342 HD23 LEU A  24     -25.604 -21.075   8.043  1.00  0.00           H  
ATOM    343  N   VAL A  25     -22.462 -22.320  10.000  1.00  0.00           N  
ATOM    344  CA  VAL A  25     -21.954 -21.228  10.849  1.00  0.00           C  
ATOM    345  C   VAL A  25     -22.699 -19.938  10.516  1.00  0.00           C  
ATOM    346  O   VAL A  25     -22.876 -19.603   9.341  1.00  0.00           O  
ATOM    347  CB  VAL A  25     -20.440 -21.032  10.647  1.00  0.00           C  
ATOM    348  CG1 VAL A  25     -19.866 -19.879  11.480  1.00  0.00           C  
ATOM    349  CG2 VAL A  25     -19.682 -22.303  11.046  1.00  0.00           C  
ATOM    350  H   VAL A  25     -21.963 -22.533   9.150  1.00  0.00           H  
ATOM    351  HA  VAL A  25     -22.125 -21.472  11.898  1.00  0.00           H  
ATOM    352  HB  VAL A  25     -20.243 -20.819   9.599  1.00  0.00           H  
ATOM    353 HG11 VAL A  25     -20.247 -18.926  11.111  1.00  0.00           H  
ATOM    354 HG12 VAL A  25     -20.139 -19.998  12.529  1.00  0.00           H  
ATOM    355 HG13 VAL A  25     -18.778 -19.856  11.394  1.00  0.00           H  
ATOM    356 HG21 VAL A  25     -18.612 -22.177  10.875  1.00  0.00           H  
ATOM    357 HG22 VAL A  25     -19.851 -22.503  12.103  1.00  0.00           H  
ATOM    358 HG23 VAL A  25     -20.023 -23.159  10.463  1.00  0.00           H  
ATOM    359  N   LEU A  26     -23.103 -19.201  11.549  1.00  0.00           N  
ATOM    360  CA  LEU A  26     -23.685 -17.864  11.429  1.00  0.00           C  
ATOM    361  C   LEU A  26     -22.642 -16.793  11.771  1.00  0.00           C  
ATOM    362  O   LEU A  26     -21.654 -17.050  12.461  1.00  0.00           O  
ATOM    363  CB  LEU A  26     -24.928 -17.765  12.341  1.00  0.00           C  
ATOM    364  CG  LEU A  26     -26.280 -18.089  11.680  1.00  0.00           C  
ATOM    365  CD1 LEU A  26     -26.650 -17.056  10.617  1.00  0.00           C  
ATOM    366  CD2 LEU A  26     -26.310 -19.482  11.053  1.00  0.00           C  
ATOM    367  H   LEU A  26     -22.866 -19.519  12.482  1.00  0.00           H  
ATOM    368  HA  LEU A  26     -23.987 -17.686  10.397  1.00  0.00           H  
ATOM    369  HB3 LEU A  26     -25.003 -16.753  12.743  1.00  0.00           H  
ATOM    370  HG  LEU A  26     -27.047 -18.053  12.455  1.00  0.00           H  
ATOM    371 HD11 LEU A  26     -26.629 -16.056  11.050  1.00  0.00           H  
ATOM    372 HD12 LEU A  26     -25.964 -17.098   9.773  1.00  0.00           H  
ATOM    373 HD13 LEU A  26     -27.661 -17.258  10.260  1.00  0.00           H  
ATOM    374 HD21 LEU A  26     -27.328 -19.727  10.755  1.00  0.00           H  
ATOM    375 HD22 LEU A  26     -25.658 -19.528  10.182  1.00  0.00           H  
ATOM    376 HD23 LEU A  26     -25.974 -20.217  11.779  1.00  0.00           H  
ATOM    377  N   TYR A  27     -22.904 -15.568  11.315  1.00  0.00           N  
ATOM    378  CA  TYR A  27     -22.073 -14.386  11.541  1.00  0.00           C  
ATOM    379  C   TYR A  27     -22.831 -13.393  12.437  1.00  0.00           C  
ATOM    380  O   TYR A  27     -23.597 -12.570  11.929  1.00  0.00           O  
ATOM    381  CB  TYR A  27     -21.623 -13.773  10.202  1.00  0.00           C  
ATOM    382  CG  TYR A  27     -20.191 -14.120   9.847  1.00  0.00           C  
ATOM    383  CD1 TYR A  27     -19.140 -13.492  10.547  1.00  0.00           C  
ATOM    384  CD2 TYR A  27     -19.906 -15.059   8.838  1.00  0.00           C  
ATOM    385  CE1 TYR A  27     -17.800 -13.785  10.223  1.00  0.00           C  
ATOM    386  CE2 TYR A  27     -18.568 -15.347   8.503  1.00  0.00           C  
ATOM    387  CZ  TYR A  27     -17.513 -14.708   9.192  1.00  0.00           C  
ATOM    388  OH  TYR A  27     -16.223 -14.990   8.860  1.00  0.00           O  
ATOM    389  H   TYR A  27     -23.757 -15.436  10.791  1.00  0.00           H  
ATOM    390  HA  TYR A  27     -21.162 -14.675  12.061  1.00  0.00           H  
ATOM    391  HB3 TYR A  27     -21.677 -12.683  10.252  1.00  0.00           H  
ATOM    392  HD1 TYR A  27     -19.361 -12.783  11.334  1.00  0.00           H  
ATOM    393  HD2 TYR A  27     -20.713 -15.556   8.313  1.00  0.00           H  
ATOM    394  HE1 TYR A  27     -16.996 -13.299  10.758  1.00  0.00           H  
ATOM    395  HE2 TYR A  27     -18.340 -16.051   7.715  1.00  0.00           H  
ATOM    396  HH  TYR A  27     -15.583 -14.490   9.395  1.00  0.00           H  
ATOM    397  N   PRO A  28     -22.670 -13.475  13.776  1.00  0.00           N  
ATOM    398  CA  PRO A  28     -23.296 -12.560  14.725  1.00  0.00           C  
ATOM    399  C   PRO A  28     -22.613 -11.173  14.738  1.00  0.00           C  
ATOM    400  O   PRO A  28     -22.048 -10.738  15.744  1.00  0.00           O  
ATOM    401  CB  PRO A  28     -23.287 -13.284  16.074  1.00  0.00           C  
ATOM    402  CG  PRO A  28     -22.048 -14.163  15.970  1.00  0.00           C  
ATOM    403  CD  PRO A  28     -21.917 -14.497  14.490  1.00  0.00           C  
ATOM    404  HA  PRO A  28     -24.329 -12.433  14.421  1.00  0.00           H  
ATOM    405  HB3 PRO A  28     -24.170 -13.913  16.146  1.00  0.00           H  
ATOM    406  HG3 PRO A  28     -22.139 -15.047  16.590  1.00  0.00           H  
ATOM    407  HD3 PRO A  28     -22.349 -15.475  14.298  1.00  0.00           H  
ATOM    408  N   GLN A  29     -22.627 -10.488  13.592  1.00  0.00           N  
ATOM    409  CA  GLN A  29     -21.913  -9.234  13.330  1.00  0.00           C  
ATOM    410  C   GLN A  29     -22.850  -8.158  12.764  1.00  0.00           C  
ATOM    411  O   GLN A  29     -23.591  -8.387  11.805  1.00  0.00           O  
ATOM    412  CB  GLN A  29     -20.725  -9.500  12.376  1.00  0.00           C  
ATOM    413  CG  GLN A  29     -19.365  -9.486  13.097  1.00  0.00           C  
ATOM    414  CD  GLN A  29     -18.902  -8.078  13.497  1.00  0.00           C  
ATOM    415  OE1 GLN A  29     -19.671  -7.219  13.909  1.00  0.00           O  
ATOM    416  NE2 GLN A  29     -17.626  -7.772  13.383  1.00  0.00           N  
ATOM    417  H   GLN A  29     -23.131 -10.901  12.815  1.00  0.00           H  
ATOM    418  HA  GLN A  29     -21.525  -8.851  14.274  1.00  0.00           H  
ATOM    419  HB3 GLN A  29     -20.704  -8.746  11.586  1.00  0.00           H  
ATOM    420  HG3 GLN A  29     -18.625  -9.917  12.420  1.00  0.00           H  
ATOM    421 HE21 GLN A  29     -16.961  -8.451  13.046  1.00  0.00           H  
ATOM    422 HE22 GLN A  29     -17.338  -6.839  13.637  1.00  0.00           H  
ATOM    423  N   ILE A  30     -22.807  -6.969  13.373  1.00  0.00           N  
ATOM    424  CA  ILE A  30     -23.612  -5.801  12.981  1.00  0.00           C  
ATOM    425  C   ILE A  30     -23.144  -5.294  11.613  1.00  0.00           C  
ATOM    426  O   ILE A  30     -21.978  -4.931  11.438  1.00  0.00           O  
ATOM    427  CB  ILE A  30     -23.558  -4.696  14.062  1.00  0.00           C  
ATOM    428  CG1 ILE A  30     -23.844  -5.208  15.499  1.00  0.00           C  
ATOM    429  CG2 ILE A  30     -24.541  -3.565  13.707  1.00  0.00           C  
ATOM    430  CD1 ILE A  30     -25.248  -5.774  15.762  1.00  0.00           C  
ATOM    431  H   ILE A  30     -22.095  -6.835  14.080  1.00  0.00           H  
ATOM    432  HA  ILE A  30     -24.644  -6.116  12.883  1.00  0.00           H  
ATOM    433  HB  ILE A  30     -22.551  -4.277  14.067  1.00  0.00           H  
ATOM    434 HG13 ILE A  30     -23.686  -4.380  16.193  1.00  0.00           H  
ATOM    435 HG21 ILE A  30     -24.274  -3.109  12.755  1.00  0.00           H  
ATOM    436 HG22 ILE A  30     -25.557  -3.952  13.636  1.00  0.00           H  
ATOM    437 HG23 ILE A  30     -24.515  -2.793  14.477  1.00  0.00           H  
ATOM    438 HD11 ILE A  30     -25.292  -6.170  16.777  1.00  0.00           H  
ATOM    439 HD12 ILE A  30     -26.002  -4.995  15.659  1.00  0.00           H  
ATOM    440 HD13 ILE A  30     -25.464  -6.582  15.069  1.00  0.00           H  
ATOM    441  N   GLY A  31     -24.045  -5.332  10.632  1.00  0.00           N  
ATOM    442  CA  GLY A  31     -23.743  -5.086   9.218  1.00  0.00           C  
ATOM    443  C   GLY A  31     -24.326  -6.137   8.261  1.00  0.00           C  
ATOM    444  O   GLY A  31     -24.383  -5.922   7.053  1.00  0.00           O  
ATOM    445  H   GLY A  31     -24.996  -5.571  10.878  1.00  0.00           H  
ATOM    446  HA2 GLY A  31     -24.139  -4.110   8.957  1.00  0.00           H  
ATOM    447  N   ASP A  32     -24.766  -7.272   8.794  1.00  0.00           N  
ATOM    448  CA  ASP A  32     -25.229  -8.431   8.037  1.00  0.00           C  
ATOM    449  C   ASP A  32     -26.724  -8.720   8.280  1.00  0.00           C  
ATOM    450  O   ASP A  32     -27.342  -8.219   9.224  1.00  0.00           O  
ATOM    451  CB  ASP A  32     -24.311  -9.611   8.392  1.00  0.00           C  
ATOM    452  CG  ASP A  32     -24.765 -10.902   7.718  1.00  0.00           C  
ATOM    453  OD1 ASP A  32     -24.986 -10.869   6.481  1.00  0.00           O  
ATOM    454  OD2 ASP A  32     -24.945 -11.916   8.435  1.00  0.00           O  
ATOM    455  H   ASP A  32     -24.680  -7.400   9.792  1.00  0.00           H  
ATOM    456  HA  ASP A  32     -25.119  -8.244   6.971  1.00  0.00           H  
ATOM    457  HB3 ASP A  32     -24.300  -9.739   9.476  1.00  0.00           H  
ATOM    458  N   LYS A  33     -27.332  -9.523   7.404  1.00  0.00           N  
ATOM    459  CA  LYS A  33     -28.726  -9.956   7.465  1.00  0.00           C  
ATOM    460  C   LYS A  33     -28.815 -11.401   6.998  1.00  0.00           C  
ATOM    461  O   LYS A  33     -28.039 -11.825   6.141  1.00  0.00           O  
ATOM    462  CB  LYS A  33     -29.613  -9.074   6.568  1.00  0.00           C  
ATOM    463  CG  LYS A  33     -29.332  -7.558   6.657  1.00  0.00           C  
ATOM    464  CD  LYS A  33     -30.360  -6.726   5.878  1.00  0.00           C  
ATOM    465  CE  LYS A  33     -30.347  -7.033   4.372  1.00  0.00           C  
ATOM    466  NZ  LYS A  33     -31.682  -7.494   3.897  1.00  0.00           N  
ATOM    467  H   LYS A  33     -26.747  -9.974   6.702  1.00  0.00           H  
ATOM    468  HA  LYS A  33     -29.085  -9.912   8.490  1.00  0.00           H  
ATOM    469  HB3 LYS A  33     -30.658  -9.250   6.828  1.00  0.00           H  
ATOM    470  HG3 LYS A  33     -28.342  -7.339   6.255  1.00  0.00           H  
ATOM    471  HD3 LYS A  33     -30.137  -5.670   6.025  1.00  0.00           H  
ATOM    472  HE3 LYS A  33     -29.590  -7.797   4.169  1.00  0.00           H  
ATOM    473  HZ1 LYS A  33     -31.659  -7.711   2.909  1.00  0.00           H  
ATOM    474  HZ2 LYS A  33     -31.979  -8.329   4.389  1.00  0.00           H  
ATOM    475  HZ3 LYS A  33     -32.385  -6.781   4.038  1.00  0.00           H  
ATOM    476  N   LEU A  34     -29.795 -12.132   7.510  1.00  0.00           N  
ATOM    477  CA  LEU A  34     -30.055 -13.514   7.128  1.00  0.00           C  
ATOM    478  C   LEU A  34     -31.552 -13.772   6.941  1.00  0.00           C  
ATOM    479  O   LEU A  34     -32.394 -13.427   7.773  1.00  0.00           O  
ATOM    480  CB  LEU A  34     -29.382 -14.528   8.077  1.00  0.00           C  
ATOM    481  CG  LEU A  34     -29.095 -14.261   9.563  1.00  0.00           C  
ATOM    482  CD1 LEU A  34     -27.894 -13.337   9.763  1.00  0.00           C  
ATOM    483  CD2 LEU A  34     -30.297 -13.779  10.367  1.00  0.00           C  
ATOM    484  H   LEU A  34     -30.441 -11.683   8.151  1.00  0.00           H  
ATOM    485  HA  LEU A  34     -29.615 -13.683   6.142  1.00  0.00           H  
ATOM    486  HB3 LEU A  34     -28.428 -14.766   7.622  1.00  0.00           H  
ATOM    487  HG  LEU A  34     -28.804 -15.221   9.989  1.00  0.00           H  
ATOM    488 HD11 LEU A  34     -27.127 -13.548   9.020  1.00  0.00           H  
ATOM    489 HD12 LEU A  34     -28.192 -12.297   9.676  1.00  0.00           H  
ATOM    490 HD13 LEU A  34     -27.465 -13.501  10.746  1.00  0.00           H  
ATOM    491 HD21 LEU A  34     -30.029 -13.724  11.424  1.00  0.00           H  
ATOM    492 HD22 LEU A  34     -30.602 -12.798  10.022  1.00  0.00           H  
ATOM    493 HD23 LEU A  34     -31.120 -14.482  10.244  1.00  0.00           H  
ATOM    494  N   ASP A  35     -31.858 -14.417   5.816  1.00  0.00           N  
ATOM    495  CA  ASP A  35     -33.198 -14.714   5.323  1.00  0.00           C  
ATOM    496  C   ASP A  35     -33.373 -16.228   5.156  1.00  0.00           C  
ATOM    497  O   ASP A  35     -32.758 -16.860   4.292  1.00  0.00           O  
ATOM    498  CB  ASP A  35     -33.521 -13.934   4.030  1.00  0.00           C  
ATOM    499  CG  ASP A  35     -32.394 -13.904   2.977  1.00  0.00           C  
ATOM    500  OD1 ASP A  35     -31.542 -12.986   3.044  1.00  0.00           O  
ATOM    501  OD2 ASP A  35     -32.387 -14.741   2.042  1.00  0.00           O  
ATOM    502  H   ASP A  35     -31.089 -14.680   5.218  1.00  0.00           H  
ATOM    503  HA  ASP A  35     -33.926 -14.386   6.062  1.00  0.00           H  
ATOM    504  HB3 ASP A  35     -33.759 -12.906   4.308  1.00  0.00           H  
ATOM    505  N   ILE A  36     -34.209 -16.809   6.022  1.00  0.00           N  
ATOM    506  CA  ILE A  36     -34.659 -18.189   5.890  1.00  0.00           C  
ATOM    507  C   ILE A  36     -35.959 -18.216   5.085  1.00  0.00           C  
ATOM    508  O   ILE A  36     -36.898 -17.482   5.394  1.00  0.00           O  
ATOM    509  CB  ILE A  36     -34.757 -18.895   7.262  1.00  0.00           C  
ATOM    510  CG1 ILE A  36     -34.794 -20.422   7.042  1.00  0.00           C  
ATOM    511  CG2 ILE A  36     -35.947 -18.433   8.120  1.00  0.00           C  
ATOM    512  CD1 ILE A  36     -34.532 -21.222   8.317  1.00  0.00           C  
ATOM    513  H   ILE A  36     -34.708 -16.212   6.676  1.00  0.00           H  
ATOM    514  HA  ILE A  36     -33.901 -18.714   5.324  1.00  0.00           H  
ATOM    515  HB  ILE A  36     -33.841 -18.656   7.809  1.00  0.00           H  
ATOM    516 HG13 ILE A  36     -34.019 -20.693   6.332  1.00  0.00           H  
ATOM    517 HG21 ILE A  36     -36.008 -17.347   8.132  1.00  0.00           H  
ATOM    518 HG22 ILE A  36     -36.882 -18.842   7.735  1.00  0.00           H  
ATOM    519 HG23 ILE A  36     -35.805 -18.769   9.143  1.00  0.00           H  
ATOM    520 HD11 ILE A  36     -34.393 -22.271   8.067  1.00  0.00           H  
ATOM    521 HD12 ILE A  36     -33.638 -20.851   8.816  1.00  0.00           H  
ATOM    522 HD13 ILE A  36     -35.380 -21.131   8.981  1.00  0.00           H  
ATOM    523  N   ILE A  37     -36.004 -19.048   4.045  1.00  0.00           N  
ATOM    524  CA  ILE A  37     -37.167 -19.283   3.183  1.00  0.00           C  
ATOM    525  C   ILE A  37     -37.237 -20.793   2.925  1.00  0.00           C  
ATOM    526  O   ILE A  37     -36.290 -21.388   2.406  1.00  0.00           O  
ATOM    527  CB  ILE A  37     -37.045 -18.486   1.856  1.00  0.00           C  
ATOM    528  CG1 ILE A  37     -37.045 -16.950   2.055  1.00  0.00           C  
ATOM    529  CG2 ILE A  37     -38.196 -18.850   0.896  1.00  0.00           C  
ATOM    530  CD1 ILE A  37     -36.299 -16.215   0.935  1.00  0.00           C  
ATOM    531  H   ILE A  37     -35.160 -19.550   3.803  1.00  0.00           H  
ATOM    532  HA  ILE A  37     -38.076 -18.963   3.688  1.00  0.00           H  
ATOM    533  HB  ILE A  37     -36.112 -18.770   1.372  1.00  0.00           H  
ATOM    534 HG13 ILE A  37     -36.543 -16.682   2.980  1.00  0.00           H  
ATOM    535 HG21 ILE A  37     -38.156 -19.904   0.635  1.00  0.00           H  
ATOM    536 HG22 ILE A  37     -39.157 -18.635   1.361  1.00  0.00           H  
ATOM    537 HG23 ILE A  37     -38.114 -18.278  -0.028  1.00  0.00           H  
ATOM    538 HD11 ILE A  37     -36.377 -15.139   1.098  1.00  0.00           H  
ATOM    539 HD12 ILE A  37     -35.247 -16.498   0.956  1.00  0.00           H  
ATOM    540 HD13 ILE A  37     -36.719 -16.457  -0.040  1.00  0.00           H  
ATOM    541  N   CYS A  38     -38.368 -21.413   3.258  1.00  0.00           N  
ATOM    542  CA  CYS A  38     -38.663 -22.820   2.976  1.00  0.00           C  
ATOM    543  C   CYS A  38     -40.107 -22.952   2.441  1.00  0.00           C  
ATOM    544  O   CYS A  38     -41.003 -22.276   2.955  1.00  0.00           O  
ATOM    545  CB  CYS A  38     -38.410 -23.661   4.238  1.00  0.00           C  
ATOM    546  SG  CYS A  38     -39.709 -23.578   5.495  1.00  0.00           S  
ATOM    547  H   CYS A  38     -39.091 -20.872   3.724  1.00  0.00           H  
ATOM    548  HA  CYS A  38     -37.967 -23.163   2.217  1.00  0.00           H  
ATOM    549  HB3 CYS A  38     -37.468 -23.344   4.686  1.00  0.00           H  
ATOM    550  N   PRO A  39     -40.369 -23.780   1.407  1.00  0.00           N  
ATOM    551  CA  PRO A  39     -41.691 -23.903   0.806  1.00  0.00           C  
ATOM    552  C   PRO A  39     -42.538 -24.961   1.524  1.00  0.00           C  
ATOM    553  O   PRO A  39     -43.736 -24.756   1.697  1.00  0.00           O  
ATOM    554  CB  PRO A  39     -41.423 -24.304  -0.649  1.00  0.00           C  
ATOM    555  CG  PRO A  39     -40.113 -25.091  -0.596  1.00  0.00           C  
ATOM    556  CD  PRO A  39     -39.416 -24.598   0.677  1.00  0.00           C  
ATOM    557  HA  PRO A  39     -42.224 -22.949   0.824  1.00  0.00           H  
ATOM    558  HB3 PRO A  39     -41.276 -23.405  -1.247  1.00  0.00           H  
ATOM    559  HG3 PRO A  39     -39.505 -24.884  -1.476  1.00  0.00           H  
ATOM    560  HD3 PRO A  39     -38.567 -23.992   0.405  1.00  0.00           H  
ATOM    561  N   LYS A  40     -41.897 -26.055   1.978  1.00  0.00           N  
ATOM    562  CA  LYS A  40     -42.493 -27.314   2.458  1.00  0.00           C  
ATOM    563  C   LYS A  40     -43.311 -28.058   1.379  1.00  0.00           C  
ATOM    564  O   LYS A  40     -43.734 -27.502   0.364  1.00  0.00           O  
ATOM    565  CB  LYS A  40     -43.271 -27.057   3.779  1.00  0.00           C  
ATOM    566  CG  LYS A  40     -42.887 -28.007   4.932  1.00  0.00           C  
ATOM    567  CD  LYS A  40     -43.716 -29.300   4.986  1.00  0.00           C  
ATOM    568  CE  LYS A  40     -44.869 -29.217   5.994  1.00  0.00           C  
ATOM    569  NZ  LYS A  40     -46.195 -29.451   5.351  1.00  0.00           N  
ATOM    570  H   LYS A  40     -40.899 -26.065   1.820  1.00  0.00           H  
ATOM    571  HA  LYS A  40     -41.652 -27.970   2.691  1.00  0.00           H  
ATOM    572  HB3 LYS A  40     -44.346 -27.097   3.600  1.00  0.00           H  
ATOM    573  HG3 LYS A  40     -42.996 -27.477   5.880  1.00  0.00           H  
ATOM    574  HD3 LYS A  40     -43.062 -30.119   5.285  1.00  0.00           H  
ATOM    575  HE3 LYS A  40     -44.855 -28.235   6.476  1.00  0.00           H  
ATOM    576  HZ1 LYS A  40     -46.956 -29.426   6.019  1.00  0.00           H  
ATOM    577  HZ2 LYS A  40     -46.386 -28.757   4.640  1.00  0.00           H  
ATOM    578  HZ3 LYS A  40     -46.225 -30.347   4.878  1.00  0.00           H  
ATOM    579  N   VAL A  41     -43.492 -29.362   1.589  1.00  0.00           N  
ATOM    580  CA  VAL A  41     -44.481 -30.217   0.906  1.00  0.00           C  
ATOM    581  C   VAL A  41     -45.911 -29.823   1.318  1.00  0.00           C  
ATOM    582  O   VAL A  41     -46.268 -29.912   2.493  1.00  0.00           O  
ATOM    583  CB  VAL A  41     -44.178 -31.714   1.165  1.00  0.00           C  
ATOM    584  CG1 VAL A  41     -43.834 -32.089   2.612  1.00  0.00           C  
ATOM    585  CG2 VAL A  41     -45.304 -32.639   0.697  1.00  0.00           C  
ATOM    586  H   VAL A  41     -43.023 -29.750   2.392  1.00  0.00           H  
ATOM    587  HA  VAL A  41     -44.392 -30.055  -0.167  1.00  0.00           H  
ATOM    588  HB  VAL A  41     -43.302 -31.957   0.571  1.00  0.00           H  
ATOM    589 HG11 VAL A  41     -42.933 -31.568   2.934  1.00  0.00           H  
ATOM    590 HG12 VAL A  41     -44.660 -31.853   3.280  1.00  0.00           H  
ATOM    591 HG13 VAL A  41     -43.632 -33.157   2.665  1.00  0.00           H  
ATOM    592 HG21 VAL A  41     -44.986 -33.678   0.754  1.00  0.00           H  
ATOM    593 HG22 VAL A  41     -46.189 -32.517   1.323  1.00  0.00           H  
ATOM    594 HG23 VAL A  41     -45.555 -32.410  -0.331  1.00  0.00           H  
ATOM    595  N   ASP A  42     -46.730 -29.381   0.357  1.00  0.00           N  
ATOM    596  CA  ASP A  42     -48.135 -28.978   0.565  1.00  0.00           C  
ATOM    597  C   ASP A  42     -48.980 -28.983  -0.734  1.00  0.00           C  
ATOM    598  O   ASP A  42     -49.607 -29.988  -1.064  1.00  0.00           O  
ATOM    599  CB  ASP A  42     -48.191 -27.620   1.295  1.00  0.00           C  
ATOM    600  CG  ASP A  42     -47.168 -26.581   0.805  1.00  0.00           C  
ATOM    601  OD1 ASP A  42     -47.180 -26.187  -0.386  1.00  0.00           O  
ATOM    602  OD2 ASP A  42     -46.391 -26.098   1.646  1.00  0.00           O  
ATOM    603  H   ASP A  42     -46.347 -29.275  -0.569  1.00  0.00           H  
ATOM    604  HA  ASP A  42     -48.604 -29.709   1.228  1.00  0.00           H  
ATOM    605  HB3 ASP A  42     -48.019 -27.802   2.359  1.00  0.00           H  
ATOM    606  N   SER A  43     -48.989 -27.875  -1.480  1.00  0.00           N  
ATOM    607  CA  SER A  43     -49.599 -27.667  -2.799  1.00  0.00           C  
ATOM    608  C   SER A  43     -48.714 -28.242  -3.918  1.00  0.00           C  
ATOM    609  O   SER A  43     -49.218 -28.799  -4.899  1.00  0.00           O  
ATOM    610  CB  SER A  43     -49.759 -26.147  -2.983  1.00  0.00           C  
ATOM    611  OG  SER A  43     -50.201 -25.805  -4.288  1.00  0.00           O  
ATOM    612  H   SER A  43     -48.440 -27.098  -1.126  1.00  0.00           H  
ATOM    613  HA  SER A  43     -50.585 -28.135  -2.840  1.00  0.00           H  
ATOM    614  HB3 SER A  43     -48.799 -25.660  -2.797  1.00  0.00           H  
ATOM    615  HG  SER A  43     -50.243 -24.832  -4.355  1.00  0.00           H  
ATOM    616  N   LYS A  44     -47.386 -28.126  -3.760  1.00  0.00           N  
ATOM    617  CA  LYS A  44     -46.377 -28.566  -4.746  1.00  0.00           C  
ATOM    618  C   LYS A  44     -46.140 -30.085  -4.730  1.00  0.00           C  
ATOM    619  O   LYS A  44     -45.741 -30.659  -5.743  1.00  0.00           O  
ATOM    620  CB  LYS A  44     -45.053 -27.804  -4.508  1.00  0.00           C  
ATOM    621  CG  LYS A  44     -45.184 -26.286  -4.289  1.00  0.00           C  
ATOM    622  CD  LYS A  44     -45.988 -25.553  -5.375  1.00  0.00           C  
ATOM    623  CE  LYS A  44     -46.122 -24.064  -5.025  1.00  0.00           C  
ATOM    624  NZ  LYS A  44     -45.531 -23.186  -6.071  1.00  0.00           N  
ATOM    625  H   LYS A  44     -47.066 -27.636  -2.935  1.00  0.00           H  
ATOM    626  HA  LYS A  44     -46.737 -28.324  -5.749  1.00  0.00           H  
ATOM    627  HB3 LYS A  44     -44.402 -27.970  -5.368  1.00  0.00           H  
ATOM    628  HG3 LYS A  44     -44.179 -25.857  -4.251  1.00  0.00           H  
ATOM    629  HD3 LYS A  44     -46.993 -25.971  -5.438  1.00  0.00           H  
ATOM    630  HE3 LYS A  44     -45.635 -23.877  -4.063  1.00  0.00           H  
ATOM    631  HZ1 LYS A  44     -45.641 -22.210  -5.829  1.00  0.00           H  
ATOM    632  HZ2 LYS A  44     -44.542 -23.364  -6.186  1.00  0.00           H  
ATOM    633  HZ3 LYS A  44     -45.982 -23.330  -6.965  1.00  0.00           H  
ATOM    634  N   THR A  45     -46.397 -30.718  -3.582  1.00  0.00           N  
ATOM    635  CA  THR A  45     -46.347 -32.173  -3.327  1.00  0.00           C  
ATOM    636  C   THR A  45     -45.066 -32.866  -3.835  1.00  0.00           C  
ATOM    637  O   THR A  45     -45.107 -33.875  -4.543  1.00  0.00           O  
ATOM    638  CB  THR A  45     -47.653 -32.874  -3.762  1.00  0.00           C  
ATOM    639  OG1 THR A  45     -48.771 -32.038  -3.535  1.00  0.00           O  
ATOM    640  CG2 THR A  45     -47.912 -34.147  -2.953  1.00  0.00           C  
ATOM    641  H   THR A  45     -46.816 -30.149  -2.866  1.00  0.00           H  
ATOM    642  HA  THR A  45     -46.317 -32.269  -2.245  1.00  0.00           H  
ATOM    643  HB  THR A  45     -47.606 -33.108  -4.825  1.00  0.00           H  
ATOM    644  HG1 THR A  45     -49.570 -32.509  -3.831  1.00  0.00           H  
ATOM    645 HG21 THR A  45     -48.845 -34.608  -3.278  1.00  0.00           H  
ATOM    646 HG22 THR A  45     -47.106 -34.859  -3.112  1.00  0.00           H  
ATOM    647 HG23 THR A  45     -47.981 -33.917  -1.889  1.00  0.00           H  
ATOM    648  N   VAL A  46     -43.900 -32.309  -3.470  1.00  0.00           N  
ATOM    649  CA  VAL A  46     -42.549 -32.734  -3.934  1.00  0.00           C  
ATOM    650  C   VAL A  46     -41.628 -33.233  -2.814  1.00  0.00           C  
ATOM    651  O   VAL A  46     -40.943 -34.239  -3.007  1.00  0.00           O  
ATOM    652  CB  VAL A  46     -41.809 -31.624  -4.726  1.00  0.00           C  
ATOM    653  CG1 VAL A  46     -41.940 -31.875  -6.230  1.00  0.00           C  
ATOM    654  CG2 VAL A  46     -42.282 -30.193  -4.430  1.00  0.00           C  
ATOM    655  H   VAL A  46     -43.960 -31.469  -2.916  1.00  0.00           H  
ATOM    656  HA  VAL A  46     -42.664 -33.587  -4.606  1.00  0.00           H  
ATOM    657  HB  VAL A  46     -40.743 -31.664  -4.488  1.00  0.00           H  
ATOM    658 HG11 VAL A  46     -41.482 -32.834  -6.476  1.00  0.00           H  
ATOM    659 HG12 VAL A  46     -42.992 -31.889  -6.518  1.00  0.00           H  
ATOM    660 HG13 VAL A  46     -41.420 -31.094  -6.784  1.00  0.00           H  
ATOM    661 HG21 VAL A  46     -41.635 -29.477  -4.938  1.00  0.00           H  
ATOM    662 HG22 VAL A  46     -43.296 -30.057  -4.801  1.00  0.00           H  
ATOM    663 HG23 VAL A  46     -42.246 -29.989  -3.359  1.00  0.00           H  
ATOM    664  N   GLY A  47     -41.647 -32.610  -1.628  1.00  0.00           N  
ATOM    665  CA  GLY A  47     -40.898 -33.089  -0.452  1.00  0.00           C  
ATOM    666  C   GLY A  47     -41.364 -34.460   0.069  1.00  0.00           C  
ATOM    667  O   GLY A  47     -40.574 -35.172   0.684  1.00  0.00           O  
ATOM    668  H   GLY A  47     -42.172 -31.754  -1.539  1.00  0.00           H  
ATOM    669  HA2 GLY A  47     -39.836 -33.158  -0.706  1.00  0.00           H  
ATOM    670  N   GLN A  48     -42.614 -34.857  -0.230  1.00  0.00           N  
ATOM    671  CA  GLN A  48     -43.227 -36.156   0.105  1.00  0.00           C  
ATOM    672  C   GLN A  48     -43.102 -36.542   1.594  1.00  0.00           C  
ATOM    673  O   GLN A  48     -42.289 -37.388   1.968  1.00  0.00           O  
ATOM    674  CB  GLN A  48     -42.711 -37.243  -0.861  1.00  0.00           C  
ATOM    675  CG  GLN A  48     -43.460 -37.204  -2.201  1.00  0.00           C  
ATOM    676  CD  GLN A  48     -42.758 -38.022  -3.285  1.00  0.00           C  
ATOM    677  OE1 GLN A  48     -42.255 -39.117  -3.065  1.00  0.00           O  
ATOM    678  NE2 GLN A  48     -42.690 -37.520  -4.501  1.00  0.00           N  
ATOM    679  H   GLN A  48     -43.174 -34.211  -0.766  1.00  0.00           H  
ATOM    680  HA  GLN A  48     -44.299 -36.067  -0.074  1.00  0.00           H  
ATOM    681  HB3 GLN A  48     -42.862 -38.230  -0.424  1.00  0.00           H  
ATOM    682  HG3 GLN A  48     -43.548 -36.170  -2.536  1.00  0.00           H  
ATOM    683 HE21 GLN A  48     -43.096 -36.619  -4.699  1.00  0.00           H  
ATOM    684 HE22 GLN A  48     -42.208 -38.050  -5.212  1.00  0.00           H  
ATOM    685  N   TYR A  49     -43.940 -35.915   2.439  1.00  0.00           N  
ATOM    686  CA  TYR A  49     -43.933 -36.073   3.900  1.00  0.00           C  
ATOM    687  C   TYR A  49     -42.511 -35.889   4.488  1.00  0.00           C  
ATOM    688  O   TYR A  49     -41.856 -36.811   4.976  1.00  0.00           O  
ATOM    689  CB  TYR A  49     -44.703 -37.353   4.299  1.00  0.00           C  
ATOM    690  CG  TYR A  49     -44.386 -37.916   5.676  1.00  0.00           C  
ATOM    691  CD1 TYR A  49     -44.628 -37.156   6.839  1.00  0.00           C  
ATOM    692  CD2 TYR A  49     -43.731 -39.160   5.769  1.00  0.00           C  
ATOM    693  CE1 TYR A  49     -44.178 -37.629   8.089  1.00  0.00           C  
ATOM    694  CE2 TYR A  49     -43.272 -39.631   7.015  1.00  0.00           C  
ATOM    695  CZ  TYR A  49     -43.485 -38.857   8.178  1.00  0.00           C  
ATOM    696  OH  TYR A  49     -43.004 -39.274   9.383  1.00  0.00           O  
ATOM    697  H   TYR A  49     -44.616 -35.278   2.044  1.00  0.00           H  
ATOM    698  HA  TYR A  49     -44.511 -35.246   4.313  1.00  0.00           H  
ATOM    699  HB3 TYR A  49     -44.501 -38.128   3.558  1.00  0.00           H  
ATOM    700  HD1 TYR A  49     -45.115 -36.191   6.770  1.00  0.00           H  
ATOM    701  HD2 TYR A  49     -43.521 -39.731   4.872  1.00  0.00           H  
ATOM    702  HE1 TYR A  49     -44.333 -37.049   8.987  1.00  0.00           H  
ATOM    703  HE2 TYR A  49     -42.730 -40.566   7.075  1.00  0.00           H  
ATOM    704  HH  TYR A  49     -42.506 -40.106   9.315  1.00  0.00           H  
ATOM    705  N   GLU A  50     -42.011 -34.652   4.416  1.00  0.00           N  
ATOM    706  CA  GLU A  50     -40.756 -34.242   5.052  1.00  0.00           C  
ATOM    707  C   GLU A  50     -40.855 -32.810   5.588  1.00  0.00           C  
ATOM    708  O   GLU A  50     -41.147 -31.866   4.851  1.00  0.00           O  
ATOM    709  CB  GLU A  50     -39.556 -34.390   4.090  1.00  0.00           C  
ATOM    710  CG  GLU A  50     -38.738 -35.678   4.292  1.00  0.00           C  
ATOM    711  CD  GLU A  50     -38.101 -35.826   5.696  1.00  0.00           C  
ATOM    712  OE1 GLU A  50     -38.338 -34.989   6.599  1.00  0.00           O  
ATOM    713  OE2 GLU A  50     -37.362 -36.821   5.913  1.00  0.00           O  
ATOM    714  H   GLU A  50     -42.565 -33.925   3.989  1.00  0.00           H  
ATOM    715  HA  GLU A  50     -40.602 -34.884   5.915  1.00  0.00           H  
ATOM    716  HB3 GLU A  50     -38.878 -33.544   4.209  1.00  0.00           H  
ATOM    717  HG3 GLU A  50     -37.942 -35.687   3.546  1.00  0.00           H  
ATOM    718  N   TYR A  51     -40.627 -32.672   6.891  1.00  0.00           N  
ATOM    719  CA  TYR A  51     -40.653 -31.428   7.651  1.00  0.00           C  
ATOM    720  C   TYR A  51     -39.582 -31.499   8.747  1.00  0.00           C  
ATOM    721  O   TYR A  51     -39.263 -32.580   9.253  1.00  0.00           O  
ATOM    722  CB  TYR A  51     -42.061 -31.212   8.232  1.00  0.00           C  
ATOM    723  CG  TYR A  51     -42.432 -32.120   9.386  1.00  0.00           C  
ATOM    724  CD1 TYR A  51     -42.148 -31.726  10.708  1.00  0.00           C  
ATOM    725  CD2 TYR A  51     -43.065 -33.352   9.133  1.00  0.00           C  
ATOM    726  CE1 TYR A  51     -42.510 -32.560  11.783  1.00  0.00           C  
ATOM    727  CE2 TYR A  51     -43.439 -34.181  10.208  1.00  0.00           C  
ATOM    728  CZ  TYR A  51     -43.166 -33.784  11.537  1.00  0.00           C  
ATOM    729  OH  TYR A  51     -43.541 -34.570  12.579  1.00  0.00           O  
ATOM    730  H   TYR A  51     -40.335 -33.493   7.404  1.00  0.00           H  
ATOM    731  HA  TYR A  51     -40.417 -30.590   6.990  1.00  0.00           H  
ATOM    732  HB3 TYR A  51     -42.796 -31.331   7.434  1.00  0.00           H  
ATOM    733  HD1 TYR A  51     -41.638 -30.788  10.901  1.00  0.00           H  
ATOM    734  HD2 TYR A  51     -43.278 -33.654   8.116  1.00  0.00           H  
ATOM    735  HE1 TYR A  51     -42.290 -32.270  12.802  1.00  0.00           H  
ATOM    736  HE2 TYR A  51     -43.942 -35.118  10.021  1.00  0.00           H  
ATOM    737  HH  TYR A  51     -43.954 -35.398  12.293  1.00  0.00           H  
ATOM    738  N   TYR A  52     -39.040 -30.346   9.131  1.00  0.00           N  
ATOM    739  CA  TYR A  52     -37.908 -30.217  10.052  1.00  0.00           C  
ATOM    740  C   TYR A  52     -38.174 -29.113  11.085  1.00  0.00           C  
ATOM    741  O   TYR A  52     -38.990 -28.216  10.864  1.00  0.00           O  
ATOM    742  CB  TYR A  52     -36.621 -29.923   9.257  1.00  0.00           C  
ATOM    743  CG  TYR A  52     -36.207 -30.919   8.184  1.00  0.00           C  
ATOM    744  CD1 TYR A  52     -36.304 -32.306   8.406  1.00  0.00           C  
ATOM    745  CD2 TYR A  52     -35.687 -30.447   6.960  1.00  0.00           C  
ATOM    746  CE1 TYR A  52     -35.895 -33.213   7.412  1.00  0.00           C  
ATOM    747  CE2 TYR A  52     -35.270 -31.355   5.964  1.00  0.00           C  
ATOM    748  CZ  TYR A  52     -35.376 -32.746   6.189  1.00  0.00           C  
ATOM    749  OH  TYR A  52     -34.981 -33.634   5.231  1.00  0.00           O  
ATOM    750  H   TYR A  52     -39.446 -29.491   8.764  1.00  0.00           H  
ATOM    751  HA  TYR A  52     -37.766 -31.146  10.603  1.00  0.00           H  
ATOM    752  HB3 TYR A  52     -35.791 -29.841   9.961  1.00  0.00           H  
ATOM    753  HD1 TYR A  52     -36.690 -32.689   9.342  1.00  0.00           H  
ATOM    754  HD2 TYR A  52     -35.599 -29.386   6.786  1.00  0.00           H  
ATOM    755  HE1 TYR A  52     -35.973 -34.277   7.582  1.00  0.00           H  
ATOM    756  HE2 TYR A  52     -34.866 -30.988   5.032  1.00  0.00           H  
ATOM    757  HH  TYR A  52     -34.614 -33.199   4.447  1.00  0.00           H  
ATOM    758  N   LYS A  53     -37.465 -29.175  12.217  1.00  0.00           N  
ATOM    759  CA  LYS A  53     -37.692 -28.322  13.392  1.00  0.00           C  
ATOM    760  C   LYS A  53     -36.382 -27.912  14.070  1.00  0.00           C  
ATOM    761  O   LYS A  53     -35.938 -28.511  15.048  1.00  0.00           O  
ATOM    762  CB  LYS A  53     -38.748 -28.943  14.327  1.00  0.00           C  
ATOM    763  CG  LYS A  53     -38.576 -30.438  14.645  1.00  0.00           C  
ATOM    764  CD  LYS A  53     -39.651 -30.925  15.632  1.00  0.00           C  
ATOM    765  CE  LYS A  53     -39.872 -32.432  15.471  1.00  0.00           C  
ATOM    766  NZ  LYS A  53     -40.821 -32.954  16.489  1.00  0.00           N  
ATOM    767  H   LYS A  53     -36.787 -29.921  12.305  1.00  0.00           H  
ATOM    768  HA  LYS A  53     -38.136 -27.388  13.054  1.00  0.00           H  
ATOM    769  HB3 LYS A  53     -39.717 -28.827  13.839  1.00  0.00           H  
ATOM    770  HG3 LYS A  53     -37.589 -30.624  15.070  1.00  0.00           H  
ATOM    771  HD3 LYS A  53     -40.591 -30.406  15.443  1.00  0.00           H  
ATOM    772  HE3 LYS A  53     -38.913 -32.946  15.554  1.00  0.00           H  
ATOM    773  HZ1 LYS A  53     -41.006 -33.933  16.323  1.00  0.00           H  
ATOM    774  HZ2 LYS A  53     -40.443 -32.873  17.424  1.00  0.00           H  
ATOM    775  HZ3 LYS A  53     -41.702 -32.458  16.466  1.00  0.00           H  
ATOM    776  N   VAL A  54     -35.762 -26.874  13.507  1.00  0.00           N  
ATOM    777  CA  VAL A  54     -34.613 -26.158  14.091  1.00  0.00           C  
ATOM    778  C   VAL A  54     -35.031 -25.544  15.427  1.00  0.00           C  
ATOM    779  O   VAL A  54     -36.091 -24.924  15.510  1.00  0.00           O  
ATOM    780  CB  VAL A  54     -34.103 -25.076  13.109  1.00  0.00           C  
ATOM    781  CG1 VAL A  54     -33.492 -23.828  13.741  1.00  0.00           C  
ATOM    782  CG2 VAL A  54     -33.032 -25.663  12.185  1.00  0.00           C  
ATOM    783  H   VAL A  54     -36.251 -26.440  12.734  1.00  0.00           H  
ATOM    784  HA  VAL A  54     -33.805 -26.864  14.284  1.00  0.00           H  
ATOM    785  HB  VAL A  54     -34.930 -24.735  12.501  1.00  0.00           H  
ATOM    786 HG11 VAL A  54     -34.247 -23.258  14.284  1.00  0.00           H  
ATOM    787 HG12 VAL A  54     -32.725 -24.155  14.425  1.00  0.00           H  
ATOM    788 HG13 VAL A  54     -33.052 -23.187  12.974  1.00  0.00           H  
ATOM    789 HG21 VAL A  54     -32.838 -24.985  11.352  1.00  0.00           H  
ATOM    790 HG22 VAL A  54     -32.107 -25.814  12.739  1.00  0.00           H  
ATOM    791 HG23 VAL A  54     -33.361 -26.619  11.789  1.00  0.00           H  
ATOM    792  N   TYR A  55     -34.189 -25.679  16.456  1.00  0.00           N  
ATOM    793  CA  TYR A  55     -34.432 -25.139  17.799  1.00  0.00           C  
ATOM    794  C   TYR A  55     -33.128 -24.773  18.527  1.00  0.00           C  
ATOM    795  O   TYR A  55     -32.170 -25.550  18.552  1.00  0.00           O  
ATOM    796  CB  TYR A  55     -35.168 -26.195  18.626  1.00  0.00           C  
ATOM    797  CG  TYR A  55     -36.662 -26.338  18.394  1.00  0.00           C  
ATOM    798  CD1 TYR A  55     -37.533 -25.308  18.797  1.00  0.00           C  
ATOM    799  CD2 TYR A  55     -37.191 -27.551  17.906  1.00  0.00           C  
ATOM    800  CE1 TYR A  55     -38.927 -25.524  18.800  1.00  0.00           C  
ATOM    801  CE2 TYR A  55     -38.583 -27.766  17.909  1.00  0.00           C  
ATOM    802  CZ  TYR A  55     -39.455 -26.759  18.375  1.00  0.00           C  
ATOM    803  OH  TYR A  55     -40.799 -26.969  18.421  1.00  0.00           O  
ATOM    804  H   TYR A  55     -33.362 -26.256  16.330  1.00  0.00           H  
ATOM    805  HA  TYR A  55     -35.051 -24.243  17.732  1.00  0.00           H  
ATOM    806  HB3 TYR A  55     -35.037 -25.953  19.681  1.00  0.00           H  
ATOM    807  HD1 TYR A  55     -37.129 -24.366  19.147  1.00  0.00           H  
ATOM    808  HD2 TYR A  55     -36.526 -28.333  17.564  1.00  0.00           H  
ATOM    809  HE1 TYR A  55     -39.603 -24.751  19.131  1.00  0.00           H  
ATOM    810  HE2 TYR A  55     -38.986 -28.708  17.574  1.00  0.00           H  
ATOM    811  HH  TYR A  55     -41.061 -27.847  18.100  1.00  0.00           H  
ATOM    812  N   MET A  56     -33.094 -23.583  19.136  1.00  0.00           N  
ATOM    813  CA  MET A  56     -31.952 -23.107  19.928  1.00  0.00           C  
ATOM    814  C   MET A  56     -31.790 -23.891  21.242  1.00  0.00           C  
ATOM    815  O   MET A  56     -32.713 -23.955  22.056  1.00  0.00           O  
ATOM    816  CB  MET A  56     -32.030 -21.587  20.168  1.00  0.00           C  
ATOM    817  CG  MET A  56     -33.336 -21.096  20.802  1.00  0.00           C  
ATOM    818  SD  MET A  56     -33.179 -19.508  21.661  1.00  0.00           S  
ATOM    819  CE  MET A  56     -34.683 -19.608  22.664  1.00  0.00           C  
ATOM    820  H   MET A  56     -33.920 -23.003  19.094  1.00  0.00           H  
ATOM    821  HA  MET A  56     -31.054 -23.281  19.349  1.00  0.00           H  
ATOM    822  HB3 MET A  56     -31.897 -21.069  19.220  1.00  0.00           H  
ATOM    823  HG3 MET A  56     -33.684 -21.825  21.528  1.00  0.00           H  
ATOM    824  HE1 MET A  56     -34.748 -18.741  23.323  1.00  0.00           H  
ATOM    825  HE2 MET A  56     -35.554 -19.629  22.014  1.00  0.00           H  
ATOM    826  HE3 MET A  56     -34.667 -20.516  23.268  1.00  0.00           H  
ATOM    827  N   VAL A  57     -30.612 -24.486  21.445  1.00  0.00           N  
ATOM    828  CA  VAL A  57     -30.252 -25.312  22.611  1.00  0.00           C  
ATOM    829  C   VAL A  57     -28.730 -25.337  22.810  1.00  0.00           C  
ATOM    830  O   VAL A  57     -27.976 -25.129  21.863  1.00  0.00           O  
ATOM    831  CB  VAL A  57     -30.748 -26.767  22.467  1.00  0.00           C  
ATOM    832  CG1 VAL A  57     -32.270 -26.931  22.441  1.00  0.00           C  
ATOM    833  CG2 VAL A  57     -30.192 -27.507  21.247  1.00  0.00           C  
ATOM    834  H   VAL A  57     -29.875 -24.321  20.772  1.00  0.00           H  
ATOM    835  HA  VAL A  57     -30.700 -24.882  23.507  1.00  0.00           H  
ATOM    836  HB  VAL A  57     -30.408 -27.284  23.356  1.00  0.00           H  
ATOM    837 HG11 VAL A  57     -32.715 -26.377  23.268  1.00  0.00           H  
ATOM    838 HG12 VAL A  57     -32.671 -26.563  21.497  1.00  0.00           H  
ATOM    839 HG13 VAL A  57     -32.510 -27.987  22.540  1.00  0.00           H  
ATOM    840 HG21 VAL A  57     -30.596 -28.518  21.221  1.00  0.00           H  
ATOM    841 HG22 VAL A  57     -30.470 -26.989  20.332  1.00  0.00           H  
ATOM    842 HG23 VAL A  57     -29.106 -27.576  21.316  1.00  0.00           H  
ATOM    843  N   ASP A  58     -28.260 -25.615  24.029  1.00  0.00           N  
ATOM    844  CA  ASP A  58     -26.824 -25.662  24.364  1.00  0.00           C  
ATOM    845  C   ASP A  58     -26.057 -26.785  23.629  1.00  0.00           C  
ATOM    846  O   ASP A  58     -26.651 -27.756  23.145  1.00  0.00           O  
ATOM    847  CB  ASP A  58     -26.659 -25.852  25.883  1.00  0.00           C  
ATOM    848  CG  ASP A  58     -27.440 -24.808  26.698  1.00  0.00           C  
ATOM    849  OD1 ASP A  58     -26.923 -23.684  26.898  1.00  0.00           O  
ATOM    850  OD2 ASP A  58     -28.575 -25.113  27.134  1.00  0.00           O  
ATOM    851  H   ASP A  58     -28.921 -25.786  24.771  1.00  0.00           H  
ATOM    852  HA  ASP A  58     -26.372 -24.706  24.090  1.00  0.00           H  
ATOM    853  HB3 ASP A  58     -25.599 -25.778  26.135  1.00  0.00           H  
ATOM    854  N   LYS A  59     -24.713 -26.732  23.639  1.00  0.00           N  
ATOM    855  CA  LYS A  59     -23.854 -27.834  23.149  1.00  0.00           C  
ATOM    856  C   LYS A  59     -24.171 -29.191  23.799  1.00  0.00           C  
ATOM    857  O   LYS A  59     -23.996 -30.228  23.171  1.00  0.00           O  
ATOM    858  CB  LYS A  59     -22.355 -27.486  23.299  1.00  0.00           C  
ATOM    859  CG  LYS A  59     -21.832 -27.671  24.737  1.00  0.00           C  
ATOM    860  CD  LYS A  59     -20.341 -27.357  24.897  1.00  0.00           C  
ATOM    861  CE  LYS A  59     -19.871 -27.924  26.247  1.00  0.00           C  
ATOM    862  NZ  LYS A  59     -18.822 -27.087  26.882  1.00  0.00           N  
ATOM    863  H   LYS A  59     -24.266 -25.910  24.022  1.00  0.00           H  
ATOM    864  HA  LYS A  59     -24.052 -27.952  22.083  1.00  0.00           H  
ATOM    865  HB3 LYS A  59     -22.180 -26.461  22.966  1.00  0.00           H  
ATOM    866  HG3 LYS A  59     -21.972 -28.712  25.030  1.00  0.00           H  
ATOM    867  HD3 LYS A  59     -20.199 -26.276  24.851  1.00  0.00           H  
ATOM    868  HE3 LYS A  59     -19.497 -28.940  26.082  1.00  0.00           H  
ATOM    869  HZ1 LYS A  59     -18.507 -27.504  27.748  1.00  0.00           H  
ATOM    870  HZ2 LYS A  59     -18.017 -26.980  26.282  1.00  0.00           H  
ATOM    871  HZ3 LYS A  59     -19.175 -26.167  27.103  1.00  0.00           H  
ATOM    872  N   ASP A  60     -24.656 -29.191  25.044  1.00  0.00           N  
ATOM    873  CA  ASP A  60     -25.030 -30.396  25.798  1.00  0.00           C  
ATOM    874  C   ASP A  60     -26.197 -31.155  25.139  1.00  0.00           C  
ATOM    875  O   ASP A  60     -26.207 -32.386  25.070  1.00  0.00           O  
ATOM    876  CB  ASP A  60     -25.393 -29.974  27.231  1.00  0.00           C  
ATOM    877  CG  ASP A  60     -25.298 -31.155  28.206  1.00  0.00           C  
ATOM    878  OD1 ASP A  60     -24.166 -31.501  28.619  1.00  0.00           O  
ATOM    879  OD2 ASP A  60     -26.350 -31.731  28.575  1.00  0.00           O  
ATOM    880  H   ASP A  60     -24.751 -28.295  25.495  1.00  0.00           H  
ATOM    881  HA  ASP A  60     -24.168 -31.067  25.837  1.00  0.00           H  
ATOM    882  HB3 ASP A  60     -26.398 -29.547  27.242  1.00  0.00           H  
ATOM    883  N   GLN A  61     -27.146 -30.405  24.575  1.00  0.00           N  
ATOM    884  CA  GLN A  61     -28.249 -30.936  23.777  1.00  0.00           C  
ATOM    885  C   GLN A  61     -27.790 -31.357  22.367  1.00  0.00           C  
ATOM    886  O   GLN A  61     -28.224 -32.396  21.866  1.00  0.00           O  
ATOM    887  CB  GLN A  61     -29.344 -29.864  23.720  1.00  0.00           C  
ATOM    888  CG  GLN A  61     -30.042 -29.557  25.062  1.00  0.00           C  
ATOM    889  CD  GLN A  61     -30.677 -30.750  25.785  1.00  0.00           C  
ATOM    890  OE1 GLN A  61     -30.941 -31.808  25.240  1.00  0.00           O  
ATOM    891  NE2 GLN A  61     -30.968 -30.624  27.061  1.00  0.00           N  
ATOM    892  H   GLN A  61     -27.035 -29.399  24.600  1.00  0.00           H  
ATOM    893  HA  GLN A  61     -28.643 -31.831  24.260  1.00  0.00           H  
ATOM    894  HB3 GLN A  61     -30.086 -30.148  22.988  1.00  0.00           H  
ATOM    895  HG3 GLN A  61     -30.837 -28.837  24.879  1.00  0.00           H  
ATOM    896 HE21 GLN A  61     -30.773 -29.766  27.549  1.00  0.00           H  
ATOM    897 HE22 GLN A  61     -31.385 -31.417  27.524  1.00  0.00           H  
ATOM    898  N   ALA A  62     -26.838 -30.625  21.765  1.00  0.00           N  
ATOM    899  CA  ALA A  62     -26.122 -31.070  20.561  1.00  0.00           C  
ATOM    900  C   ALA A  62     -25.348 -32.392  20.761  1.00  0.00           C  
ATOM    901  O   ALA A  62     -25.179 -33.164  19.818  1.00  0.00           O  
ATOM    902  CB  ALA A  62     -25.185 -29.954  20.073  1.00  0.00           C  
ATOM    903  H   ALA A  62     -26.551 -29.761  22.205  1.00  0.00           H  
ATOM    904  HA  ALA A  62     -26.864 -31.254  19.785  1.00  0.00           H  
ATOM    905  HB1 ALA A  62     -24.918 -30.135  19.033  1.00  0.00           H  
ATOM    906  HB2 ALA A  62     -25.665 -28.979  20.146  1.00  0.00           H  
ATOM    907  HB3 ALA A  62     -24.271 -29.941  20.661  1.00  0.00           H  
ATOM    908  N   ASP A  63     -24.901 -32.674  21.988  1.00  0.00           N  
ATOM    909  CA  ASP A  63     -24.198 -33.906  22.361  1.00  0.00           C  
ATOM    910  C   ASP A  63     -25.149 -35.113  22.502  1.00  0.00           C  
ATOM    911  O   ASP A  63     -24.834 -36.214  22.039  1.00  0.00           O  
ATOM    912  CB  ASP A  63     -23.420 -33.670  23.671  1.00  0.00           C  
ATOM    913  CG  ASP A  63     -22.122 -34.490  23.723  1.00  0.00           C  
ATOM    914  OD1 ASP A  63     -21.223 -34.254  22.881  1.00  0.00           O  
ATOM    915  OD2 ASP A  63     -21.981 -35.353  24.623  1.00  0.00           O  
ATOM    916  H   ASP A  63     -24.965 -31.944  22.685  1.00  0.00           H  
ATOM    917  HA  ASP A  63     -23.483 -34.134  21.572  1.00  0.00           H  
ATOM    918  HB3 ASP A  63     -24.059 -33.915  24.524  1.00  0.00           H  
ATOM    919  N   ARG A  64     -26.340 -34.898  23.086  1.00  0.00           N  
ATOM    920  CA  ARG A  64     -27.430 -35.893  23.177  1.00  0.00           C  
ATOM    921  C   ARG A  64     -28.213 -36.099  21.877  1.00  0.00           C  
ATOM    922  O   ARG A  64     -28.866 -37.132  21.727  1.00  0.00           O  
ATOM    923  CB  ARG A  64     -28.411 -35.500  24.303  1.00  0.00           C  
ATOM    924  CG  ARG A  64     -28.005 -36.019  25.692  1.00  0.00           C  
ATOM    925  CD  ARG A  64     -27.989 -37.560  25.724  1.00  0.00           C  
ATOM    926  NE  ARG A  64     -28.645 -38.108  26.925  1.00  0.00           N  
ATOM    927  CZ  ARG A  64     -28.785 -39.388  27.217  1.00  0.00           C  
ATOM    928  NH1 ARG A  64     -28.270 -40.332  26.479  1.00  0.00           N  
ATOM    929  NH2 ARG A  64     -29.462 -39.755  28.268  1.00  0.00           N  
ATOM    930  H   ARG A  64     -26.500 -33.975  23.476  1.00  0.00           H  
ATOM    931  HA  ARG A  64     -26.994 -36.868  23.397  1.00  0.00           H  
ATOM    932  HB3 ARG A  64     -29.393 -35.922  24.085  1.00  0.00           H  
ATOM    933  HG3 ARG A  64     -28.734 -35.645  26.413  1.00  0.00           H  
ATOM    934  HD3 ARG A  64     -26.950 -37.894  25.676  1.00  0.00           H  
ATOM    935  HE  ARG A  64     -29.071 -37.449  27.557  1.00  0.00           H  
ATOM    936 HH11 ARG A  64     -27.737 -40.082  25.664  1.00  0.00           H  
ATOM    937 HH12 ARG A  64     -28.389 -41.299  26.727  1.00  0.00           H  
ATOM    938 HH21 ARG A  64     -29.895 -39.066  28.858  1.00  0.00           H  
ATOM    939 HH22 ARG A  64     -29.575 -40.731  28.482  1.00  0.00           H  
ATOM    940  N   CYS A  65     -28.146 -35.151  20.943  1.00  0.00           N  
ATOM    941  CA  CYS A  65     -29.006 -35.083  19.760  1.00  0.00           C  
ATOM    942  C   CYS A  65     -30.502 -34.967  20.084  1.00  0.00           C  
ATOM    943  O   CYS A  65     -31.356 -35.552  19.414  1.00  0.00           O  
ATOM    944  CB  CYS A  65     -28.653 -36.215  18.778  1.00  0.00           C  
ATOM    945  SG  CYS A  65     -28.452 -35.666  17.070  1.00  0.00           S  
ATOM    946  H   CYS A  65     -27.613 -34.325  21.178  1.00  0.00           H  
ATOM    947  HA  CYS A  65     -28.770 -34.129  19.295  1.00  0.00           H  
ATOM    948  HB3 CYS A  65     -29.419 -36.991  18.822  1.00  0.00           H  
ATOM    949  N   THR A  66     -30.823 -34.199  21.126  1.00  0.00           N  
ATOM    950  CA  THR A  66     -32.194 -33.987  21.596  1.00  0.00           C  
ATOM    951  C   THR A  66     -32.487 -32.507  21.814  1.00  0.00           C  
ATOM    952  O   THR A  66     -31.590 -31.727  22.117  1.00  0.00           O  
ATOM    953  CB  THR A  66     -32.497 -34.803  22.869  1.00  0.00           C  
ATOM    954  OG1 THR A  66     -31.593 -34.513  23.907  1.00  0.00           O  
ATOM    955  CG2 THR A  66     -32.379 -36.308  22.630  1.00  0.00           C  
ATOM    956  H   THR A  66     -30.084 -33.718  21.627  1.00  0.00           H  
ATOM    957  HA  THR A  66     -32.867 -34.319  20.816  1.00  0.00           H  
ATOM    958  HB  THR A  66     -33.506 -34.573  23.211  1.00  0.00           H  
ATOM    959  HG1 THR A  66     -31.936 -34.915  24.722  1.00  0.00           H  
ATOM    960 HG21 THR A  66     -32.807 -36.851  23.475  1.00  0.00           H  
ATOM    961 HG22 THR A  66     -32.914 -36.579  21.724  1.00  0.00           H  
ATOM    962 HG23 THR A  66     -31.334 -36.597  22.513  1.00  0.00           H  
ATOM    963  N   ILE A  67     -33.734 -32.083  21.612  1.00  0.00           N  
ATOM    964  CA  ILE A  67     -34.164 -30.697  21.850  1.00  0.00           C  
ATOM    965  C   ILE A  67     -34.653 -30.571  23.308  1.00  0.00           C  
ATOM    966  O   ILE A  67     -35.143 -31.536  23.897  1.00  0.00           O  
ATOM    967  CB  ILE A  67     -35.234 -30.249  20.816  1.00  0.00           C  
ATOM    968  CG1 ILE A  67     -34.950 -30.673  19.351  1.00  0.00           C  
ATOM    969  CG2 ILE A  67     -35.403 -28.728  20.881  1.00  0.00           C  
ATOM    970  CD1 ILE A  67     -33.594 -30.230  18.793  1.00  0.00           C  
ATOM    971  H   ILE A  67     -34.436 -32.780  21.398  1.00  0.00           H  
ATOM    972  HA  ILE A  67     -33.304 -30.037  21.726  1.00  0.00           H  
ATOM    973  HB  ILE A  67     -36.201 -30.676  21.080  1.00  0.00           H  
ATOM    974 HG13 ILE A  67     -35.735 -30.271  18.708  1.00  0.00           H  
ATOM    975 HG21 ILE A  67     -35.825 -28.425  21.839  1.00  0.00           H  
ATOM    976 HG22 ILE A  67     -34.450 -28.222  20.724  1.00  0.00           H  
ATOM    977 HG23 ILE A  67     -36.104 -28.420  20.111  1.00  0.00           H  
ATOM    978 HD11 ILE A  67     -33.521 -30.512  17.744  1.00  0.00           H  
ATOM    979 HD12 ILE A  67     -33.471 -29.151  18.861  1.00  0.00           H  
ATOM    980 HD13 ILE A  67     -32.798 -30.721  19.342  1.00  0.00           H  
ATOM    981  N   LYS A  68     -34.536 -29.386  23.919  1.00  0.00           N  
ATOM    982  CA  LYS A  68     -35.098 -29.109  25.250  1.00  0.00           C  
ATOM    983  C   LYS A  68     -36.615 -28.901  25.138  1.00  0.00           C  
ATOM    984  O   LYS A  68     -37.048 -28.131  24.286  1.00  0.00           O  
ATOM    985  CB  LYS A  68     -34.392 -27.866  25.844  1.00  0.00           C  
ATOM    986  CG  LYS A  68     -33.789 -28.142  27.228  1.00  0.00           C  
ATOM    987  CD  LYS A  68     -34.848 -28.268  28.333  1.00  0.00           C  
ATOM    988  CE  LYS A  68     -34.242 -28.703  29.674  1.00  0.00           C  
ATOM    989  NZ  LYS A  68     -33.609 -27.570  30.407  1.00  0.00           N  
ATOM    990  H   LYS A  68     -34.160 -28.616  23.389  1.00  0.00           H  
ATOM    991  HA  LYS A  68     -34.915 -29.977  25.888  1.00  0.00           H  
ATOM    992  HB3 LYS A  68     -35.079 -27.020  25.901  1.00  0.00           H  
ATOM    993  HG3 LYS A  68     -33.109 -27.329  27.479  1.00  0.00           H  
ATOM    994  HD3 LYS A  68     -35.578 -29.024  28.047  1.00  0.00           H  
ATOM    995  HE3 LYS A  68     -33.512 -29.496  29.491  1.00  0.00           H  
ATOM    996  HZ1 LYS A  68     -33.209 -27.890  31.281  1.00  0.00           H  
ATOM    997  HZ2 LYS A  68     -32.866 -27.146  29.872  1.00  0.00           H  
ATOM    998  HZ3 LYS A  68     -34.287 -26.853  30.630  1.00  0.00           H  
ATOM    999  N   LYS A  69     -37.429 -29.493  26.022  1.00  0.00           N  
ATOM   1000  CA  LYS A  69     -38.895 -29.253  26.080  1.00  0.00           C  
ATOM   1001  C   LYS A  69     -39.294 -27.789  26.338  1.00  0.00           C  
ATOM   1002  O   LYS A  69     -40.426 -27.394  26.060  1.00  0.00           O  
ATOM   1003  CB  LYS A  69     -39.553 -30.186  27.115  1.00  0.00           C  
ATOM   1004  CG  LYS A  69     -39.301 -29.742  28.566  1.00  0.00           C  
ATOM   1005  CD  LYS A  69     -39.986 -30.651  29.598  1.00  0.00           C  
ATOM   1006  CE  LYS A  69     -40.582 -29.790  30.724  1.00  0.00           C  
ATOM   1007  NZ  LYS A  69     -40.437 -30.425  32.060  1.00  0.00           N  
ATOM   1008  H   LYS A  69     -37.033 -30.191  26.635  1.00  0.00           H  
ATOM   1009  HA  LYS A  69     -39.306 -29.511  25.101  1.00  0.00           H  
ATOM   1010  HB3 LYS A  69     -39.195 -31.206  26.976  1.00  0.00           H  
ATOM   1011  HG3 LYS A  69     -39.682 -28.728  28.688  1.00  0.00           H  
ATOM   1012  HD3 LYS A  69     -39.247 -31.352  29.986  1.00  0.00           H  
ATOM   1013  HE3 LYS A  69     -41.638 -29.616  30.500  1.00  0.00           H  
ATOM   1014  HZ1 LYS A  69     -40.873 -29.856  32.774  1.00  0.00           H  
ATOM   1015  HZ2 LYS A  69     -40.869 -31.336  32.087  1.00  0.00           H  
ATOM   1016  HZ3 LYS A  69     -39.464 -30.527  32.310  1.00  0.00           H  
ATOM   1017  N   GLU A  70     -38.373 -26.990  26.886  1.00  0.00           N  
ATOM   1018  CA  GLU A  70     -38.513 -25.536  27.083  1.00  0.00           C  
ATOM   1019  C   GLU A  70     -38.335 -24.723  25.779  1.00  0.00           C  
ATOM   1020  O   GLU A  70     -38.392 -23.489  25.792  1.00  0.00           O  
ATOM   1021  CB  GLU A  70     -37.547 -25.059  28.183  1.00  0.00           C  
ATOM   1022  CG  GLU A  70     -37.804 -25.771  29.522  1.00  0.00           C  
ATOM   1023  CD  GLU A  70     -37.194 -24.994  30.703  1.00  0.00           C  
ATOM   1024  OE1 GLU A  70     -35.945 -24.959  30.833  1.00  0.00           O  
ATOM   1025  OE2 GLU A  70     -37.965 -24.429  31.522  1.00  0.00           O  
ATOM   1026  H   GLU A  70     -37.502 -27.418  27.148  1.00  0.00           H  
ATOM   1027  HA  GLU A  70     -39.527 -25.332  27.426  1.00  0.00           H  
ATOM   1028  HB3 GLU A  70     -37.696 -23.989  28.333  1.00  0.00           H  
ATOM   1029  HG3 GLU A  70     -37.381 -26.776  29.489  1.00  0.00           H  
ATOM   1030  N   ASN A  71     -38.147 -25.408  24.645  1.00  0.00           N  
ATOM   1031  CA  ASN A  71     -38.313 -24.863  23.303  1.00  0.00           C  
ATOM   1032  C   ASN A  71     -39.723 -24.282  23.037  1.00  0.00           C  
ATOM   1033  O   ASN A  71     -40.668 -24.472  23.806  1.00  0.00           O  
ATOM   1034  CB  ASN A  71     -37.920 -25.940  22.270  1.00  0.00           C  
ATOM   1035  CG  ASN A  71     -38.888 -27.119  22.130  1.00  0.00           C  
ATOM   1036  OD1 ASN A  71     -39.844 -27.302  22.868  1.00  0.00           O  
ATOM   1037  ND2 ASN A  71     -38.689 -27.965  21.148  1.00  0.00           N  
ATOM   1038  H   ASN A  71     -38.065 -26.414  24.712  1.00  0.00           H  
ATOM   1039  HA  ASN A  71     -37.606 -24.039  23.198  1.00  0.00           H  
ATOM   1040  HB3 ASN A  71     -36.927 -26.323  22.502  1.00  0.00           H  
ATOM   1041 HD21 ASN A  71     -37.968 -27.793  20.467  1.00  0.00           H  
ATOM   1042 HD22 ASN A  71     -39.353 -28.713  21.031  1.00  0.00           H  
ATOM   1043  N   THR A  72     -39.827 -23.564  21.915  1.00  0.00           N  
ATOM   1044  CA  THR A  72     -41.012 -22.856  21.384  1.00  0.00           C  
ATOM   1045  C   THR A  72     -40.722 -22.214  20.012  1.00  0.00           C  
ATOM   1046  O   THR A  72     -41.545 -22.384  19.110  1.00  0.00           O  
ATOM   1047  CB  THR A  72     -41.555 -21.809  22.396  1.00  0.00           C  
ATOM   1048  OG1 THR A  72     -42.658 -22.343  23.102  1.00  0.00           O  
ATOM   1049  CG2 THR A  72     -42.068 -20.481  21.827  1.00  0.00           C  
ATOM   1050  H   THR A  72     -38.997 -23.531  21.345  1.00  0.00           H  
ATOM   1051  HA  THR A  72     -41.794 -23.601  21.219  1.00  0.00           H  
ATOM   1052  HB  THR A  72     -40.766 -21.579  23.113  1.00  0.00           H  
ATOM   1053  HG1 THR A  72     -42.756 -21.822  23.921  1.00  0.00           H  
ATOM   1054 HG21 THR A  72     -42.480 -19.872  22.634  1.00  0.00           H  
ATOM   1055 HG22 THR A  72     -41.249 -19.921  21.380  1.00  0.00           H  
ATOM   1056 HG23 THR A  72     -42.845 -20.657  21.081  1.00  0.00           H  
ATOM   1057  N   PRO A  73     -39.579 -21.519  19.784  1.00  0.00           N  
ATOM   1058  CA  PRO A  73     -39.271 -20.865  18.509  1.00  0.00           C  
ATOM   1059  C   PRO A  73     -38.704 -21.866  17.487  1.00  0.00           C  
ATOM   1060  O   PRO A  73     -37.516 -21.857  17.157  1.00  0.00           O  
ATOM   1061  CB  PRO A  73     -38.326 -19.706  18.856  1.00  0.00           C  
ATOM   1062  CG  PRO A  73     -37.567 -20.209  20.078  1.00  0.00           C  
ATOM   1063  CD  PRO A  73     -38.540 -21.176  20.756  1.00  0.00           C  
ATOM   1064  HA  PRO A  73     -40.180 -20.440  18.082  1.00  0.00           H  
ATOM   1065  HB3 PRO A  73     -38.921 -18.837  19.140  1.00  0.00           H  
ATOM   1066  HG3 PRO A  73     -37.315 -19.378  20.737  1.00  0.00           H  
ATOM   1067  HD3 PRO A  73     -38.980 -20.697  21.629  1.00  0.00           H  
ATOM   1068  N   LEU A  74     -39.563 -22.777  17.019  1.00  0.00           N  
ATOM   1069  CA  LEU A  74     -39.254 -23.743  15.962  1.00  0.00           C  
ATOM   1070  C   LEU A  74     -38.965 -23.017  14.630  1.00  0.00           C  
ATOM   1071  O   LEU A  74     -39.615 -22.022  14.293  1.00  0.00           O  
ATOM   1072  CB  LEU A  74     -40.375 -24.813  15.907  1.00  0.00           C  
ATOM   1073  CG  LEU A  74     -41.296 -24.847  14.682  1.00  0.00           C  
ATOM   1074  CD1 LEU A  74     -40.626 -25.639  13.558  1.00  0.00           C  
ATOM   1075  CD2 LEU A  74     -42.614 -25.542  15.027  1.00  0.00           C  
ATOM   1076  H   LEU A  74     -40.515 -22.742  17.363  1.00  0.00           H  
ATOM   1077  HA  LEU A  74     -38.339 -24.258  16.254  1.00  0.00           H  
ATOM   1078  HB3 LEU A  74     -40.990 -24.715  16.802  1.00  0.00           H  
ATOM   1079  HG  LEU A  74     -41.523 -23.837  14.352  1.00  0.00           H  
ATOM   1080 HD11 LEU A  74     -39.560 -25.488  13.560  1.00  0.00           H  
ATOM   1081 HD12 LEU A  74     -40.791 -26.703  13.701  1.00  0.00           H  
ATOM   1082 HD13 LEU A  74     -41.022 -25.320  12.590  1.00  0.00           H  
ATOM   1083 HD21 LEU A  74     -43.277 -25.528  14.166  1.00  0.00           H  
ATOM   1084 HD22 LEU A  74     -42.418 -26.575  15.323  1.00  0.00           H  
ATOM   1085 HD23 LEU A  74     -43.101 -25.027  15.854  1.00  0.00           H  
ATOM   1086  N   LEU A  75     -38.012 -23.540  13.860  1.00  0.00           N  
ATOM   1087  CA  LEU A  75     -37.663 -23.076  12.513  1.00  0.00           C  
ATOM   1088  C   LEU A  75     -37.395 -24.259  11.551  1.00  0.00           C  
ATOM   1089  O   LEU A  75     -37.778 -25.386  11.833  1.00  0.00           O  
ATOM   1090  CB  LEU A  75     -36.481 -22.079  12.635  1.00  0.00           C  
ATOM   1091  CG  LEU A  75     -36.740 -20.652  12.105  1.00  0.00           C  
ATOM   1092  CD1 LEU A  75     -35.380 -19.990  11.866  1.00  0.00           C  
ATOM   1093  CD2 LEU A  75     -37.573 -20.572  10.820  1.00  0.00           C  
ATOM   1094  H   LEU A  75     -37.475 -24.307  14.247  1.00  0.00           H  
ATOM   1095  HA  LEU A  75     -38.534 -22.565  12.107  1.00  0.00           H  
ATOM   1096  HB3 LEU A  75     -35.604 -22.490  12.137  1.00  0.00           H  
ATOM   1097  HG  LEU A  75     -37.265 -20.082  12.873  1.00  0.00           H  
ATOM   1098 HD11 LEU A  75     -34.828 -19.951  12.804  1.00  0.00           H  
ATOM   1099 HD12 LEU A  75     -34.798 -20.558  11.143  1.00  0.00           H  
ATOM   1100 HD13 LEU A  75     -35.517 -18.971  11.502  1.00  0.00           H  
ATOM   1101 HD21 LEU A  75     -37.521 -19.569  10.402  1.00  0.00           H  
ATOM   1102 HD22 LEU A  75     -37.234 -21.292  10.083  1.00  0.00           H  
ATOM   1103 HD23 LEU A  75     -38.622 -20.757  11.047  1.00  0.00           H  
ATOM   1104  N   ASN A  76     -36.728 -24.026  10.417  1.00  0.00           N  
ATOM   1105  CA  ASN A  76     -36.379 -24.983   9.352  1.00  0.00           C  
ATOM   1106  C   ASN A  76     -37.541 -25.188   8.359  1.00  0.00           C  
ATOM   1107  O   ASN A  76     -37.355 -24.783   7.216  1.00  0.00           O  
ATOM   1108  CB  ASN A  76     -35.829 -26.324   9.901  1.00  0.00           C  
ATOM   1109  CG  ASN A  76     -34.775 -27.018   9.049  1.00  0.00           C  
ATOM   1110  OD1 ASN A  76     -33.973 -27.783   9.563  1.00  0.00           O  
ATOM   1111  ND2 ASN A  76     -34.726 -26.817   7.753  1.00  0.00           N  
ATOM   1112  H   ASN A  76     -36.426 -23.072  10.270  1.00  0.00           H  
ATOM   1113  HA  ASN A  76     -35.565 -24.510   8.797  1.00  0.00           H  
ATOM   1114  HB3 ASN A  76     -36.655 -27.019  10.050  1.00  0.00           H  
ATOM   1115 HD21 ASN A  76     -35.374 -26.207   7.282  1.00  0.00           H  
ATOM   1116 HD22 ASN A  76     -33.991 -27.280   7.244  1.00  0.00           H  
ATOM   1117  N   CYS A  77     -38.683 -25.770   8.783  1.00  0.00           N  
ATOM   1118  CA  CYS A  77     -39.961 -25.960   8.046  1.00  0.00           C  
ATOM   1119  C   CYS A  77     -40.927 -26.955   8.753  1.00  0.00           C  
ATOM   1120  O   CYS A  77     -40.832 -28.160   8.510  1.00  0.00           O  
ATOM   1121  CB  CYS A  77     -39.756 -26.396   6.570  1.00  0.00           C  
ATOM   1122  SG  CYS A  77     -40.631 -25.356   5.373  1.00  0.00           S  
ATOM   1123  H   CYS A  77     -38.681 -26.090   9.748  1.00  0.00           H  
ATOM   1124  HA  CYS A  77     -40.462 -24.989   8.031  1.00  0.00           H  
ATOM   1125  HB3 CYS A  77     -40.105 -27.416   6.425  1.00  0.00           H  
ATOM   1126  N   ALA A  78     -41.866 -26.503   9.602  1.00  0.00           N  
ATOM   1127  CA  ALA A  78     -42.863 -27.367  10.265  1.00  0.00           C  
ATOM   1128  C   ALA A  78     -44.130 -27.655   9.435  1.00  0.00           C  
ATOM   1129  O   ALA A  78     -44.509 -26.890   8.546  1.00  0.00           O  
ATOM   1130  CB  ALA A  78     -43.269 -26.744  11.602  1.00  0.00           C  
ATOM   1131  H   ALA A  78     -41.925 -25.513   9.774  1.00  0.00           H  
ATOM   1132  HA  ALA A  78     -42.401 -28.327  10.483  1.00  0.00           H  
ATOM   1133  HB1 ALA A  78     -44.216 -27.144  11.955  1.00  0.00           H  
ATOM   1134  HB2 ALA A  78     -42.515 -26.992  12.344  1.00  0.00           H  
ATOM   1135  HB3 ALA A  78     -43.363 -25.663  11.506  1.00  0.00           H  
ATOM   1136  N   LYS A  79     -44.831 -28.748   9.784  1.00  0.00           N  
ATOM   1137  CA  LYS A  79     -46.195 -29.065   9.302  1.00  0.00           C  
ATOM   1138  C   LYS A  79     -47.269 -28.027   9.689  1.00  0.00           C  
ATOM   1139  O   LYS A  79     -47.805 -27.413   8.763  1.00  0.00           O  
ATOM   1140  CB  LYS A  79     -46.606 -30.504   9.693  1.00  0.00           C  
ATOM   1141  CG  LYS A  79     -46.136 -31.533   8.654  1.00  0.00           C  
ATOM   1142  CD  LYS A  79     -46.493 -32.977   9.040  1.00  0.00           C  
ATOM   1143  CE  LYS A  79     -47.989 -33.275   8.870  1.00  0.00           C  
ATOM   1144  NZ  LYS A  79     -48.324 -34.655   9.326  1.00  0.00           N  
ATOM   1145  H   LYS A  79     -44.444 -29.344  10.505  1.00  0.00           H  
ATOM   1146  HA  LYS A  79     -46.181 -29.022   8.218  1.00  0.00           H  
ATOM   1147  HB3 LYS A  79     -47.698 -30.561   9.759  1.00  0.00           H  
ATOM   1148  HG3 LYS A  79     -45.057 -31.452   8.548  1.00  0.00           H  
ATOM   1149  HD3 LYS A  79     -46.192 -33.154  10.074  1.00  0.00           H  
ATOM   1150  HE3 LYS A  79     -48.248 -33.166   7.812  1.00  0.00           H  
ATOM   1151  HZ1 LYS A  79     -49.302 -34.863   9.162  1.00  0.00           H  
ATOM   1152  HZ2 LYS A  79     -47.780 -35.351   8.835  1.00  0.00           H  
ATOM   1153  HZ3 LYS A  79     -48.152 -34.765  10.318  1.00  0.00           H  
ATOM   1154  N   PRO A  80     -47.556 -27.751  10.980  1.00  0.00           N  
ATOM   1155  CA  PRO A  80     -48.559 -26.761  11.411  1.00  0.00           C  
ATOM   1156  C   PRO A  80     -48.063 -25.302  11.285  1.00  0.00           C  
ATOM   1157  O   PRO A  80     -48.138 -24.502  12.221  1.00  0.00           O  
ATOM   1158  CB  PRO A  80     -48.937 -27.179  12.838  1.00  0.00           C  
ATOM   1159  CG  PRO A  80     -47.643 -27.782  13.379  1.00  0.00           C  
ATOM   1160  CD  PRO A  80     -47.075 -28.485  12.147  1.00  0.00           C  
ATOM   1161  HA  PRO A  80     -49.446 -26.850  10.781  1.00  0.00           H  
ATOM   1162  HB3 PRO A  80     -49.705 -27.955  12.788  1.00  0.00           H  
ATOM   1163  HG3 PRO A  80     -47.841 -28.484  14.191  1.00  0.00           H  
ATOM   1164  HD3 PRO A  80     -47.457 -29.503  12.123  1.00  0.00           H  
ATOM   1165  N   ASP A  81     -47.513 -24.955  10.121  1.00  0.00           N  
ATOM   1166  CA  ASP A  81     -47.004 -23.618   9.779  1.00  0.00           C  
ATOM   1167  C   ASP A  81     -46.850 -23.389   8.257  1.00  0.00           C  
ATOM   1168  O   ASP A  81     -46.825 -22.244   7.803  1.00  0.00           O  
ATOM   1169  CB  ASP A  81     -45.648 -23.392  10.478  1.00  0.00           C  
ATOM   1170  CG  ASP A  81     -45.612 -22.103  11.325  1.00  0.00           C  
ATOM   1171  OD1 ASP A  81     -46.220 -21.077  10.939  1.00  0.00           O  
ATOM   1172  OD2 ASP A  81     -44.956 -22.112  12.395  1.00  0.00           O  
ATOM   1173  H   ASP A  81     -47.551 -25.651   9.387  1.00  0.00           H  
ATOM   1174  HA  ASP A  81     -47.727 -22.885  10.138  1.00  0.00           H  
ATOM   1175  HB3 ASP A  81     -44.856 -23.361   9.729  1.00  0.00           H  
ATOM   1176  N   GLN A  82     -46.800 -24.468   7.461  1.00  0.00           N  
ATOM   1177  CA  GLN A  82     -46.564 -24.448   6.010  1.00  0.00           C  
ATOM   1178  C   GLN A  82     -45.222 -23.766   5.635  1.00  0.00           C  
ATOM   1179  O   GLN A  82     -44.223 -23.954   6.338  1.00  0.00           O  
ATOM   1180  CB  GLN A  82     -47.810 -23.896   5.277  1.00  0.00           C  
ATOM   1181  CG  GLN A  82     -47.895 -24.496   3.866  1.00  0.00           C  
ATOM   1182  CD  GLN A  82     -48.547 -23.600   2.814  1.00  0.00           C  
ATOM   1183  OE1 GLN A  82     -49.505 -22.872   3.056  1.00  0.00           O  
ATOM   1184  NE2 GLN A  82     -48.043 -23.633   1.599  1.00  0.00           N  
ATOM   1185  H   GLN A  82     -46.763 -25.374   7.904  1.00  0.00           H  
ATOM   1186  HA  GLN A  82     -46.457 -25.492   5.712  1.00  0.00           H  
ATOM   1187  HB3 GLN A  82     -47.754 -22.809   5.226  1.00  0.00           H  
ATOM   1188  HG3 GLN A  82     -48.414 -25.454   3.900  1.00  0.00           H  
ATOM   1189 HE21 GLN A  82     -47.270 -24.272   1.410  1.00  0.00           H  
ATOM   1190 HE22 GLN A  82     -48.426 -23.033   0.888  1.00  0.00           H  
ATOM   1191  N   ASP A  83     -45.159 -23.030   4.518  1.00  0.00           N  
ATOM   1192  CA  ASP A  83     -43.990 -22.253   4.106  1.00  0.00           C  
ATOM   1193  C   ASP A  83     -43.559 -21.284   5.217  1.00  0.00           C  
ATOM   1194  O   ASP A  83     -44.361 -20.470   5.691  1.00  0.00           O  
ATOM   1195  CB  ASP A  83     -44.251 -21.518   2.774  1.00  0.00           C  
ATOM   1196  CG  ASP A  83     -45.311 -20.402   2.849  1.00  0.00           C  
ATOM   1197  OD1 ASP A  83     -46.514 -20.713   2.997  1.00  0.00           O  
ATOM   1198  OD2 ASP A  83     -44.946 -19.208   2.691  1.00  0.00           O  
ATOM   1199  H   ASP A  83     -46.011 -22.882   3.997  1.00  0.00           H  
ATOM   1200  HA  ASP A  83     -43.175 -22.955   3.936  1.00  0.00           H  
ATOM   1201  HB3 ASP A  83     -44.559 -22.239   2.018  1.00  0.00           H  
ATOM   1202  N   ILE A  84     -42.293 -21.365   5.636  1.00  0.00           N  
ATOM   1203  CA  ILE A  84     -41.713 -20.434   6.607  1.00  0.00           C  
ATOM   1204  C   ILE A  84     -40.820 -19.455   5.864  1.00  0.00           C  
ATOM   1205  O   ILE A  84     -40.004 -19.831   5.017  1.00  0.00           O  
ATOM   1206  CB  ILE A  84     -41.040 -21.166   7.804  1.00  0.00           C  
ATOM   1207  CG1 ILE A  84     -41.556 -20.611   9.150  1.00  0.00           C  
ATOM   1208  CG2 ILE A  84     -39.501 -21.071   7.866  1.00  0.00           C  
ATOM   1209  CD1 ILE A  84     -43.026 -20.937   9.417  1.00  0.00           C  
ATOM   1210  H   ILE A  84     -41.672 -22.008   5.160  1.00  0.00           H  
ATOM   1211  HA  ILE A  84     -42.522 -19.835   7.017  1.00  0.00           H  
ATOM   1212  HB  ILE A  84     -41.299 -22.227   7.760  1.00  0.00           H  
ATOM   1213 HG13 ILE A  84     -41.417 -19.526   9.178  1.00  0.00           H  
ATOM   1214 HG21 ILE A  84     -39.048 -21.342   6.916  1.00  0.00           H  
ATOM   1215 HG22 ILE A  84     -39.186 -20.060   8.126  1.00  0.00           H  
ATOM   1216 HG23 ILE A  84     -39.129 -21.764   8.621  1.00  0.00           H  
ATOM   1217 HD11 ILE A  84     -43.297 -20.567  10.405  1.00  0.00           H  
ATOM   1218 HD12 ILE A  84     -43.682 -20.472   8.681  1.00  0.00           H  
ATOM   1219 HD13 ILE A  84     -43.160 -22.014   9.388  1.00  0.00           H  
ATOM   1220  N   LYS A  85     -40.994 -18.178   6.192  1.00  0.00           N  
ATOM   1221  CA  LYS A  85     -40.153 -17.086   5.720  1.00  0.00           C  
ATOM   1222  C   LYS A  85     -39.909 -16.136   6.885  1.00  0.00           C  
ATOM   1223  O   LYS A  85     -40.848 -15.709   7.558  1.00  0.00           O  
ATOM   1224  CB  LYS A  85     -40.753 -16.445   4.447  1.00  0.00           C  
ATOM   1225  CG  LYS A  85     -42.028 -15.606   4.649  1.00  0.00           C  
ATOM   1226  CD  LYS A  85     -41.722 -14.140   5.020  1.00  0.00           C  
ATOM   1227  CE  LYS A  85     -42.710 -13.626   6.076  1.00  0.00           C  
ATOM   1228  NZ  LYS A  85     -42.233 -12.363   6.703  1.00  0.00           N  
ATOM   1229  H   LYS A  85     -41.710 -17.959   6.870  1.00  0.00           H  
ATOM   1230  HA  LYS A  85     -39.196 -17.510   5.435  1.00  0.00           H  
ATOM   1231  HB3 LYS A  85     -40.986 -17.250   3.750  1.00  0.00           H  
ATOM   1232  HG3 LYS A  85     -42.647 -16.075   5.415  1.00  0.00           H  
ATOM   1233  HD3 LYS A  85     -41.779 -13.520   4.124  1.00  0.00           H  
ATOM   1234  HE3 LYS A  85     -42.815 -14.391   6.852  1.00  0.00           H  
ATOM   1235  HZ1 LYS A  85     -42.903 -12.023   7.382  1.00  0.00           H  
ATOM   1236  HZ2 LYS A  85     -41.361 -12.509   7.190  1.00  0.00           H  
ATOM   1237  HZ3 LYS A  85     -42.095 -11.636   6.013  1.00  0.00           H  
ATOM   1238  N   PHE A  86     -38.647 -15.825   7.139  1.00  0.00           N  
ATOM   1239  CA  PHE A  86     -38.236 -14.845   8.140  1.00  0.00           C  
ATOM   1240  C   PHE A  86     -36.907 -14.224   7.715  1.00  0.00           C  
ATOM   1241  O   PHE A  86     -35.968 -14.933   7.353  1.00  0.00           O  
ATOM   1242  CB  PHE A  86     -38.144 -15.490   9.542  1.00  0.00           C  
ATOM   1243  CG  PHE A  86     -39.156 -14.936  10.530  1.00  0.00           C  
ATOM   1244  CD1 PHE A  86     -39.099 -13.579  10.910  1.00  0.00           C  
ATOM   1245  CD2 PHE A  86     -40.155 -15.768  11.077  1.00  0.00           C  
ATOM   1246  CE1 PHE A  86     -40.042 -13.055  11.815  1.00  0.00           C  
ATOM   1247  CE2 PHE A  86     -41.092 -15.245  11.990  1.00  0.00           C  
ATOM   1248  CZ  PHE A  86     -41.037 -13.888  12.354  1.00  0.00           C  
ATOM   1249  H   PHE A  86     -37.924 -16.260   6.572  1.00  0.00           H  
ATOM   1250  HA  PHE A  86     -38.978 -14.049   8.172  1.00  0.00           H  
ATOM   1251  HB3 PHE A  86     -37.149 -15.324   9.958  1.00  0.00           H  
ATOM   1252  HD1 PHE A  86     -38.329 -12.934  10.508  1.00  0.00           H  
ATOM   1253  HD2 PHE A  86     -40.205 -16.813  10.799  1.00  0.00           H  
ATOM   1254  HE1 PHE A  86     -39.996 -12.010  12.100  1.00  0.00           H  
ATOM   1255  HE2 PHE A  86     -41.854 -15.890  12.413  1.00  0.00           H  
ATOM   1256  HZ  PHE A  86     -41.762 -13.486  13.051  1.00  0.00           H  
ATOM   1257  N   THR A  87     -36.820 -12.898   7.781  1.00  0.00           N  
ATOM   1258  CA  THR A  87     -35.579 -12.157   7.553  1.00  0.00           C  
ATOM   1259  C   THR A  87     -35.254 -11.343   8.796  1.00  0.00           C  
ATOM   1260  O   THR A  87     -36.082 -10.578   9.300  1.00  0.00           O  
ATOM   1261  CB  THR A  87     -35.627 -11.332   6.255  1.00  0.00           C  
ATOM   1262  OG1 THR A  87     -34.370 -10.729   6.039  1.00  0.00           O  
ATOM   1263  CG2 THR A  87     -36.692 -10.231   6.210  1.00  0.00           C  
ATOM   1264  H   THR A  87     -37.625 -12.371   8.088  1.00  0.00           H  
ATOM   1265  HA  THR A  87     -34.765 -12.862   7.413  1.00  0.00           H  
ATOM   1266  HB  THR A  87     -35.826 -12.019   5.430  1.00  0.00           H  
ATOM   1267  HG1 THR A  87     -34.368 -10.358   5.140  1.00  0.00           H  
ATOM   1268 HG21 THR A  87     -36.713  -9.782   5.215  1.00  0.00           H  
ATOM   1269 HG22 THR A  87     -37.674 -10.655   6.418  1.00  0.00           H  
ATOM   1270 HG23 THR A  87     -36.469  -9.454   6.943  1.00  0.00           H  
ATOM   1271  N   ILE A  88     -34.053 -11.561   9.326  1.00  0.00           N  
ATOM   1272  CA  ILE A  88     -33.483 -10.812  10.442  1.00  0.00           C  
ATOM   1273  C   ILE A  88     -32.323  -9.984   9.897  1.00  0.00           C  
ATOM   1274  O   ILE A  88     -31.503 -10.458   9.109  1.00  0.00           O  
ATOM   1275  CB  ILE A  88     -33.086 -11.762  11.603  1.00  0.00           C  
ATOM   1276  CG1 ILE A  88     -34.338 -11.987  12.484  1.00  0.00           C  
ATOM   1277  CG2 ILE A  88     -31.890 -11.242  12.432  1.00  0.00           C  
ATOM   1278  CD1 ILE A  88     -34.103 -12.766  13.786  1.00  0.00           C  
ATOM   1279  H   ILE A  88     -33.437 -12.203   8.836  1.00  0.00           H  
ATOM   1280  HA  ILE A  88     -34.217 -10.103  10.821  1.00  0.00           H  
ATOM   1281  HB  ILE A  88     -32.787 -12.727  11.187  1.00  0.00           H  
ATOM   1282 HG13 ILE A  88     -35.082 -12.523  11.897  1.00  0.00           H  
ATOM   1283 HG21 ILE A  88     -31.012 -11.092  11.805  1.00  0.00           H  
ATOM   1284 HG22 ILE A  88     -32.144 -10.308  12.937  1.00  0.00           H  
ATOM   1285 HG23 ILE A  88     -31.607 -11.990  13.170  1.00  0.00           H  
ATOM   1286 HD11 ILE A  88     -35.060 -12.944  14.277  1.00  0.00           H  
ATOM   1287 HD12 ILE A  88     -33.625 -13.720  13.573  1.00  0.00           H  
ATOM   1288 HD13 ILE A  88     -33.480 -12.185  14.467  1.00  0.00           H  
ATOM   1289  N   LYS A  89     -32.253  -8.739  10.361  1.00  0.00           N  
ATOM   1290  CA  LYS A  89     -31.249  -7.748   9.981  1.00  0.00           C  
ATOM   1291  C   LYS A  89     -30.560  -7.240  11.242  1.00  0.00           C  
ATOM   1292  O   LYS A  89     -31.226  -6.818  12.189  1.00  0.00           O  
ATOM   1293  CB  LYS A  89     -31.924  -6.665   9.116  1.00  0.00           C  
ATOM   1294  CG  LYS A  89     -32.953  -5.763   9.823  1.00  0.00           C  
ATOM   1295  CD  LYS A  89     -34.018  -5.265   8.832  1.00  0.00           C  
ATOM   1296  CE  LYS A  89     -34.717  -4.004   9.350  1.00  0.00           C  
ATOM   1297  NZ  LYS A  89     -35.948  -3.703   8.566  1.00  0.00           N  
ATOM   1298  H   LYS A  89     -32.959  -8.451  11.026  1.00  0.00           H  
ATOM   1299  HA  LYS A  89     -30.488  -8.232   9.368  1.00  0.00           H  
ATOM   1300  HB3 LYS A  89     -32.424  -7.181   8.294  1.00  0.00           H  
ATOM   1301  HG3 LYS A  89     -32.429  -4.917  10.265  1.00  0.00           H  
ATOM   1302  HD3 LYS A  89     -34.750  -6.063   8.690  1.00  0.00           H  
ATOM   1303  HE3 LYS A  89     -34.014  -3.169   9.276  1.00  0.00           H  
ATOM   1304  HZ1 LYS A  89     -36.350  -2.820   8.845  1.00  0.00           H  
ATOM   1305  HZ2 LYS A  89     -35.752  -3.650   7.575  1.00  0.00           H  
ATOM   1306  HZ3 LYS A  89     -36.651  -4.415   8.704  1.00  0.00           H  
ATOM   1307  N   PHE A  90     -29.232  -7.348  11.283  1.00  0.00           N  
ATOM   1308  CA  PHE A  90     -28.408  -6.948  12.424  1.00  0.00           C  
ATOM   1309  C   PHE A  90     -28.319  -5.416  12.479  1.00  0.00           C  
ATOM   1310  O   PHE A  90     -27.325  -4.815  12.064  1.00  0.00           O  
ATOM   1311  CB  PHE A  90     -27.024  -7.618  12.391  1.00  0.00           C  
ATOM   1312  CG  PHE A  90     -26.968  -9.084  12.806  1.00  0.00           C  
ATOM   1313  CD1 PHE A  90     -27.763 -10.066  12.174  1.00  0.00           C  
ATOM   1314  CD2 PHE A  90     -26.158  -9.446  13.899  1.00  0.00           C  
ATOM   1315  CE1 PHE A  90     -27.778 -11.385  12.663  1.00  0.00           C  
ATOM   1316  CE2 PHE A  90     -26.164 -10.761  14.383  1.00  0.00           C  
ATOM   1317  CZ  PHE A  90     -26.959 -11.736  13.754  1.00  0.00           C  
ATOM   1318  H   PHE A  90     -28.749  -7.695  10.460  1.00  0.00           H  
ATOM   1319  HA  PHE A  90     -28.896  -7.276  13.344  1.00  0.00           H  
ATOM   1320  HB3 PHE A  90     -26.428  -7.072  13.114  1.00  0.00           H  
ATOM   1321  HD1 PHE A  90     -28.375  -9.812  11.324  1.00  0.00           H  
ATOM   1322  HD2 PHE A  90     -25.555  -8.701  14.406  1.00  0.00           H  
ATOM   1323  HE1 PHE A  90     -28.435 -12.119  12.224  1.00  0.00           H  
ATOM   1324  HE2 PHE A  90     -25.594 -11.005  15.275  1.00  0.00           H  
ATOM   1325  HZ  PHE A  90     -26.970 -12.746  14.134  1.00  0.00           H  
ATOM   1326  N   GLN A  91     -29.400  -4.781  12.931  1.00  0.00           N  
ATOM   1327  CA  GLN A  91     -29.509  -3.333  13.100  1.00  0.00           C  
ATOM   1328  C   GLN A  91     -28.854  -2.863  14.413  1.00  0.00           C  
ATOM   1329  O   GLN A  91     -28.658  -3.647  15.344  1.00  0.00           O  
ATOM   1330  CB  GLN A  91     -30.999  -2.932  13.017  1.00  0.00           C  
ATOM   1331  CG  GLN A  91     -31.221  -1.630  12.228  1.00  0.00           C  
ATOM   1332  CD  GLN A  91     -30.842  -1.767  10.748  1.00  0.00           C  
ATOM   1333  OE1 GLN A  91     -31.537  -2.387   9.956  1.00  0.00           O  
ATOM   1334  NE2 GLN A  91     -29.724  -1.219  10.314  1.00  0.00           N  
ATOM   1335  H   GLN A  91     -30.203  -5.348  13.182  1.00  0.00           H  
ATOM   1336  HA  GLN A  91     -28.965  -2.869  12.279  1.00  0.00           H  
ATOM   1337  HB3 GLN A  91     -31.403  -2.818  14.024  1.00  0.00           H  
ATOM   1338  HG3 GLN A  91     -30.657  -0.817  12.687  1.00  0.00           H  
ATOM   1339 HE21 GLN A  91     -29.137  -0.672  10.923  1.00  0.00           H  
ATOM   1340 HE22 GLN A  91     -29.475  -1.364   9.345  1.00  0.00           H  
ATOM   1341  N   GLU A  92     -28.499  -1.576  14.497  1.00  0.00           N  
ATOM   1342  CA  GLU A  92     -27.722  -1.028  15.621  1.00  0.00           C  
ATOM   1343  C   GLU A  92     -28.497  -1.041  16.954  1.00  0.00           C  
ATOM   1344  O   GLU A  92     -27.954  -1.414  17.994  1.00  0.00           O  
ATOM   1345  CB  GLU A  92     -27.280   0.411  15.285  1.00  0.00           C  
ATOM   1346  CG  GLU A  92     -25.849   0.700  15.765  1.00  0.00           C  
ATOM   1347  CD  GLU A  92     -25.722   2.114  16.361  1.00  0.00           C  
ATOM   1348  OE1 GLU A  92     -25.806   3.113  15.605  1.00  0.00           O  
ATOM   1349  OE2 GLU A  92     -25.533   2.238  17.597  1.00  0.00           O  
ATOM   1350  H   GLU A  92     -28.687  -0.970  13.714  1.00  0.00           H  
ATOM   1351  HA  GLU A  92     -26.836  -1.654  15.748  1.00  0.00           H  
ATOM   1352  HB3 GLU A  92     -27.976   1.116  15.742  1.00  0.00           H  
ATOM   1353  HG3 GLU A  92     -25.169   0.587  14.917  1.00  0.00           H  
ATOM   1354  N   PHE A  93     -29.780  -0.664  16.896  1.00  0.00           N  
ATOM   1355  CA  PHE A  93     -30.735  -0.597  18.006  1.00  0.00           C  
ATOM   1356  C   PHE A  93     -32.104  -1.070  17.504  1.00  0.00           C  
ATOM   1357  O   PHE A  93     -32.478  -0.785  16.360  1.00  0.00           O  
ATOM   1358  CB  PHE A  93     -30.813   0.847  18.560  1.00  0.00           C  
ATOM   1359  CG  PHE A  93     -30.226   1.019  19.951  1.00  0.00           C  
ATOM   1360  CD1 PHE A  93     -28.834   0.925  20.150  1.00  0.00           C  
ATOM   1361  CD2 PHE A  93     -31.068   1.274  21.054  1.00  0.00           C  
ATOM   1362  CE1 PHE A  93     -28.291   1.046  21.443  1.00  0.00           C  
ATOM   1363  CE2 PHE A  93     -30.523   1.413  22.345  1.00  0.00           C  
ATOM   1364  CZ  PHE A  93     -29.136   1.287  22.541  1.00  0.00           C  
ATOM   1365  H   PHE A  93     -30.140  -0.410  15.988  1.00  0.00           H  
ATOM   1366  HA  PHE A  93     -30.419  -1.264  18.804  1.00  0.00           H  
ATOM   1367  HB3 PHE A  93     -31.860   1.161  18.589  1.00  0.00           H  
ATOM   1368  HD1 PHE A  93     -28.178   0.752  19.309  1.00  0.00           H  
ATOM   1369  HD2 PHE A  93     -32.137   1.366  20.913  1.00  0.00           H  
ATOM   1370  HE1 PHE A  93     -27.221   0.952  21.590  1.00  0.00           H  
ATOM   1371  HE2 PHE A  93     -31.172   1.610  23.189  1.00  0.00           H  
ATOM   1372  HZ  PHE A  93     -28.718   1.376  23.536  1.00  0.00           H  
ATOM   1373  N   SER A  94     -32.867  -1.763  18.352  1.00  0.00           N  
ATOM   1374  CA  SER A  94     -34.200  -2.280  18.024  1.00  0.00           C  
ATOM   1375  C   SER A  94     -35.213  -1.897  19.109  1.00  0.00           C  
ATOM   1376  O   SER A  94     -35.305  -2.574  20.140  1.00  0.00           O  
ATOM   1377  CB  SER A  94     -34.190  -3.786  17.772  1.00  0.00           C  
ATOM   1378  OG  SER A  94     -35.441  -4.111  17.190  1.00  0.00           O  
ATOM   1379  H   SER A  94     -32.495  -1.964  19.281  1.00  0.00           H  
ATOM   1380  HA  SER A  94     -34.519  -1.848  17.079  1.00  0.00           H  
ATOM   1381  HB3 SER A  94     -34.047  -4.339  18.700  1.00  0.00           H  
ATOM   1382  HG  SER A  94     -35.328  -4.895  16.628  1.00  0.00           H  
ATOM   1383  N   PRO A  95     -35.982  -0.805  18.914  1.00  0.00           N  
ATOM   1384  CA  PRO A  95     -36.998  -0.365  19.872  1.00  0.00           C  
ATOM   1385  C   PRO A  95     -38.221  -1.306  19.923  1.00  0.00           C  
ATOM   1386  O   PRO A  95     -39.022  -1.213  20.857  1.00  0.00           O  
ATOM   1387  CB  PRO A  95     -37.369   1.058  19.436  1.00  0.00           C  
ATOM   1388  CG  PRO A  95     -37.116   1.068  17.929  1.00  0.00           C  
ATOM   1389  CD  PRO A  95     -35.980   0.064  17.739  1.00  0.00           C  
ATOM   1390  HA  PRO A  95     -36.567  -0.323  20.873  1.00  0.00           H  
ATOM   1391  HB3 PRO A  95     -36.691   1.766  19.914  1.00  0.00           H  
ATOM   1392  HG3 PRO A  95     -36.833   2.063  17.579  1.00  0.00           H  
ATOM   1393  HD3 PRO A  95     -35.028   0.587  17.669  1.00  0.00           H  
ATOM   1394  N   ASN A  96     -38.371  -2.218  18.951  1.00  0.00           N  
ATOM   1395  CA  ASN A  96     -39.465  -3.189  18.905  1.00  0.00           C  
ATOM   1396  C   ASN A  96     -39.270  -4.337  19.917  1.00  0.00           C  
ATOM   1397  O   ASN A  96     -40.181  -4.621  20.698  1.00  0.00           O  
ATOM   1398  CB  ASN A  96     -39.600  -3.708  17.459  1.00  0.00           C  
ATOM   1399  CG  ASN A  96     -40.997  -4.244  17.184  1.00  0.00           C  
ATOM   1400  OD1 ASN A  96     -41.992  -3.548  17.338  1.00  0.00           O  
ATOM   1401  ND2 ASN A  96     -41.136  -5.480  16.766  1.00  0.00           N  
ATOM   1402  H   ASN A  96     -37.686  -2.239  18.209  1.00  0.00           H  
ATOM   1403  HA  ASN A  96     -40.390  -2.671  19.175  1.00  0.00           H  
ATOM   1404  HB3 ASN A  96     -38.853  -4.480  17.264  1.00  0.00           H  
ATOM   1405 HD21 ASN A  96     -40.327  -6.066  16.623  1.00  0.00           H  
ATOM   1406 HD22 ASN A  96     -42.067  -5.811  16.566  1.00  0.00           H  
ATOM   1407  N   LEU A  97     -38.090  -4.978  19.923  1.00  0.00           N  
ATOM   1408  CA  LEU A  97     -37.711  -6.033  20.876  1.00  0.00           C  
ATOM   1409  C   LEU A  97     -36.187  -6.257  20.872  1.00  0.00           C  
ATOM   1410  O   LEU A  97     -35.578  -6.441  19.815  1.00  0.00           O  
ATOM   1411  CB  LEU A  97     -38.466  -7.344  20.518  1.00  0.00           C  
ATOM   1412  CG  LEU A  97     -38.933  -8.249  21.680  1.00  0.00           C  
ATOM   1413  CD1 LEU A  97     -37.802  -8.973  22.413  1.00  0.00           C  
ATOM   1414  CD2 LEU A  97     -39.779  -7.512  22.720  1.00  0.00           C  
ATOM   1415  H   LEU A  97     -37.390  -4.690  19.251  1.00  0.00           H  
ATOM   1416  HA  LEU A  97     -38.004  -5.696  21.870  1.00  0.00           H  
ATOM   1417  HB3 LEU A  97     -37.853  -7.938  19.836  1.00  0.00           H  
ATOM   1418  HG  LEU A  97     -39.565  -9.019  21.240  1.00  0.00           H  
ATOM   1419 HD11 LEU A  97     -37.236  -9.572  21.702  1.00  0.00           H  
ATOM   1420 HD12 LEU A  97     -37.155  -8.269  22.931  1.00  0.00           H  
ATOM   1421 HD13 LEU A  97     -38.233  -9.648  23.153  1.00  0.00           H  
ATOM   1422 HD21 LEU A  97     -40.247  -8.236  23.386  1.00  0.00           H  
ATOM   1423 HD22 LEU A  97     -39.168  -6.836  23.318  1.00  0.00           H  
ATOM   1424 HD23 LEU A  97     -40.562  -6.943  22.220  1.00  0.00           H  
ATOM   1425  N   TRP A  98     -35.576  -6.325  22.060  1.00  0.00           N  
ATOM   1426  CA  TRP A  98     -34.144  -6.617  22.261  1.00  0.00           C  
ATOM   1427  C   TRP A  98     -33.674  -7.996  21.747  1.00  0.00           C  
ATOM   1428  O   TRP A  98     -32.474  -8.265  21.719  1.00  0.00           O  
ATOM   1429  CB  TRP A  98     -33.781  -6.424  23.752  1.00  0.00           C  
ATOM   1430  CG  TRP A  98     -32.667  -5.461  24.038  1.00  0.00           C  
ATOM   1431  CD1 TRP A  98     -32.545  -4.226  23.497  1.00  0.00           C  
ATOM   1432  CD2 TRP A  98     -31.530  -5.604  24.954  1.00  0.00           C  
ATOM   1433  NE1 TRP A  98     -31.415  -3.609  23.992  1.00  0.00           N  
ATOM   1434  CE2 TRP A  98     -30.756  -4.397  24.909  1.00  0.00           C  
ATOM   1435  CE3 TRP A  98     -31.074  -6.617  25.825  1.00  0.00           C  
ATOM   1436  CZ2 TRP A  98     -29.608  -4.209  25.688  1.00  0.00           C  
ATOM   1437  CZ3 TRP A  98     -29.916  -6.440  26.615  1.00  0.00           C  
ATOM   1438  CH2 TRP A  98     -29.188  -5.242  26.549  1.00  0.00           C  
ATOM   1439  H   TRP A  98     -36.131  -6.146  22.884  1.00  0.00           H  
ATOM   1440  HA  TRP A  98     -33.582  -5.884  21.678  1.00  0.00           H  
ATOM   1441  HB3 TRP A  98     -33.519  -7.392  24.186  1.00  0.00           H  
ATOM   1442  HD1 TRP A  98     -33.229  -3.790  22.775  1.00  0.00           H  
ATOM   1443  HE1 TRP A  98     -31.104  -2.697  23.669  1.00  0.00           H  
ATOM   1444  HE3 TRP A  98     -31.625  -7.544  25.890  1.00  0.00           H  
ATOM   1445  HZ2 TRP A  98     -29.053  -3.282  25.630  1.00  0.00           H  
ATOM   1446  HZ3 TRP A  98     -29.590  -7.232  27.281  1.00  0.00           H  
ATOM   1447  HH2 TRP A  98     -28.306  -5.110  27.163  1.00  0.00           H  
ATOM   1448  N   GLY A  99     -34.593  -8.863  21.300  1.00  0.00           N  
ATOM   1449  CA  GLY A  99     -34.299 -10.130  20.618  1.00  0.00           C  
ATOM   1450  C   GLY A  99     -33.731  -9.968  19.197  1.00  0.00           C  
ATOM   1451  O   GLY A  99     -33.014 -10.857  18.729  1.00  0.00           O  
ATOM   1452  H   GLY A  99     -35.560  -8.587  21.375  1.00  0.00           H  
ATOM   1453  HA2 GLY A  99     -33.594 -10.710  21.218  1.00  0.00           H  
ATOM   1454  N   LEU A 100     -34.012  -8.844  18.515  1.00  0.00           N  
ATOM   1455  CA  LEU A 100     -33.368  -8.475  17.241  1.00  0.00           C  
ATOM   1456  C   LEU A 100     -32.009  -7.781  17.424  1.00  0.00           C  
ATOM   1457  O   LEU A 100     -31.206  -7.756  16.490  1.00  0.00           O  
ATOM   1458  CB  LEU A 100     -34.279  -7.536  16.432  1.00  0.00           C  
ATOM   1459  CG  LEU A 100     -35.548  -8.163  15.833  1.00  0.00           C  
ATOM   1460  CD1 LEU A 100     -36.231  -7.118  14.943  1.00  0.00           C  
ATOM   1461  CD2 LEU A 100     -35.249  -9.383  14.964  1.00  0.00           C  
ATOM   1462  H   LEU A 100     -34.631  -8.168  18.947  1.00  0.00           H  
ATOM   1463  HA  LEU A 100     -33.173  -9.376  16.660  1.00  0.00           H  
ATOM   1464  HB3 LEU A 100     -33.688  -7.133  15.604  1.00  0.00           H  
ATOM   1465  HG  LEU A 100     -36.235  -8.451  16.631  1.00  0.00           H  
ATOM   1466 HD11 LEU A 100     -36.520  -6.256  15.541  1.00  0.00           H  
ATOM   1467 HD12 LEU A 100     -35.552  -6.798  14.149  1.00  0.00           H  
ATOM   1468 HD13 LEU A 100     -37.130  -7.542  14.491  1.00  0.00           H  
ATOM   1469 HD21 LEU A 100     -36.151  -9.702  14.442  1.00  0.00           H  
ATOM   1470 HD22 LEU A 100     -34.475  -9.142  14.234  1.00  0.00           H  
ATOM   1471 HD23 LEU A 100     -34.915 -10.210  15.588  1.00  0.00           H  
ATOM   1472  N   GLU A 101     -31.735  -7.209  18.597  1.00  0.00           N  
ATOM   1473  CA  GLU A 101     -30.370  -6.835  18.976  1.00  0.00           C  
ATOM   1474  C   GLU A 101     -29.554  -8.072  19.385  1.00  0.00           C  
ATOM   1475  O   GLU A 101     -30.096  -9.103  19.795  1.00  0.00           O  
ATOM   1476  CB  GLU A 101     -30.372  -5.784  20.100  1.00  0.00           C  
ATOM   1477  CG  GLU A 101     -30.742  -4.401  19.549  1.00  0.00           C  
ATOM   1478  CD  GLU A 101     -30.582  -3.292  20.605  1.00  0.00           C  
ATOM   1479  OE1 GLU A 101     -29.489  -3.158  21.206  1.00  0.00           O  
ATOM   1480  OE2 GLU A 101     -31.551  -2.518  20.799  1.00  0.00           O  
ATOM   1481  H   GLU A 101     -32.418  -7.291  19.334  1.00  0.00           H  
ATOM   1482  HA  GLU A 101     -29.865  -6.396  18.115  1.00  0.00           H  
ATOM   1483  HB3 GLU A 101     -29.371  -5.728  20.526  1.00  0.00           H  
ATOM   1484  HG3 GLU A 101     -31.773  -4.433  19.195  1.00  0.00           H  
ATOM   1485  N   PHE A 102     -28.228  -7.957  19.295  1.00  0.00           N  
ATOM   1486  CA  PHE A 102     -27.273  -9.010  19.642  1.00  0.00           C  
ATOM   1487  C   PHE A 102     -26.199  -8.450  20.578  1.00  0.00           C  
ATOM   1488  O   PHE A 102     -25.841  -7.271  20.499  1.00  0.00           O  
ATOM   1489  CB  PHE A 102     -26.656  -9.600  18.362  1.00  0.00           C  
ATOM   1490  CG  PHE A 102     -27.686 -10.167  17.403  1.00  0.00           C  
ATOM   1491  CD1 PHE A 102     -28.135 -11.497  17.551  1.00  0.00           C  
ATOM   1492  CD2 PHE A 102     -28.217  -9.357  16.380  1.00  0.00           C  
ATOM   1493  CE1 PHE A 102     -29.109 -12.012  16.674  1.00  0.00           C  
ATOM   1494  CE2 PHE A 102     -29.187  -9.875  15.502  1.00  0.00           C  
ATOM   1495  CZ  PHE A 102     -29.636 -11.198  15.656  1.00  0.00           C  
ATOM   1496  H   PHE A 102     -27.841  -7.083  18.970  1.00  0.00           H  
ATOM   1497  HA  PHE A 102     -27.786  -9.815  20.169  1.00  0.00           H  
ATOM   1498  HB3 PHE A 102     -25.962 -10.396  18.639  1.00  0.00           H  
ATOM   1499  HD1 PHE A 102     -27.738 -12.119  18.341  1.00  0.00           H  
ATOM   1500  HD2 PHE A 102     -27.873  -8.340  16.258  1.00  0.00           H  
ATOM   1501  HE1 PHE A 102     -29.454 -13.032  16.786  1.00  0.00           H  
ATOM   1502  HE2 PHE A 102     -29.580  -9.260  14.703  1.00  0.00           H  
ATOM   1503  HZ  PHE A 102     -30.379 -11.597  14.982  1.00  0.00           H  
ATOM   1504  N   GLN A 103     -25.684  -9.300  21.468  1.00  0.00           N  
ATOM   1505  CA  GLN A 103     -24.708  -8.920  22.491  1.00  0.00           C  
ATOM   1506  C   GLN A 103     -23.342  -9.548  22.197  1.00  0.00           C  
ATOM   1507  O   GLN A 103     -23.249 -10.609  21.573  1.00  0.00           O  
ATOM   1508  CB  GLN A 103     -25.200  -9.350  23.884  1.00  0.00           C  
ATOM   1509  CG  GLN A 103     -26.580  -8.784  24.274  1.00  0.00           C  
ATOM   1510  CD  GLN A 103     -27.595  -9.902  24.509  1.00  0.00           C  
ATOM   1511  OE1 GLN A 103     -28.414 -10.228  23.661  1.00  0.00           O  
ATOM   1512  NE2 GLN A 103     -27.553 -10.559  25.652  1.00  0.00           N  
ATOM   1513  H   GLN A 103     -25.982 -10.266  21.437  1.00  0.00           H  
ATOM   1514  HA  GLN A 103     -24.586  -7.837  22.503  1.00  0.00           H  
ATOM   1515  HB3 GLN A 103     -24.474  -9.012  24.625  1.00  0.00           H  
ATOM   1516  HG3 GLN A 103     -26.960  -8.112  23.505  1.00  0.00           H  
ATOM   1517 HE21 GLN A 103     -26.892 -10.296  26.365  1.00  0.00           H  
ATOM   1518 HE22 GLN A 103     -28.210 -11.312  25.796  1.00  0.00           H  
ATOM   1519  N   LYS A 104     -22.282  -8.893  22.674  1.00  0.00           N  
ATOM   1520  CA  LYS A 104     -20.893  -9.361  22.553  1.00  0.00           C  
ATOM   1521  C   LYS A 104     -20.481 -10.221  23.752  1.00  0.00           C  
ATOM   1522  O   LYS A 104     -21.194 -10.277  24.756  1.00  0.00           O  
ATOM   1523  CB  LYS A 104     -19.964  -8.151  22.339  1.00  0.00           C  
ATOM   1524  CG  LYS A 104     -20.295  -7.408  21.028  1.00  0.00           C  
ATOM   1525  CD  LYS A 104     -20.973  -6.050  21.270  1.00  0.00           C  
ATOM   1526  CE  LYS A 104     -21.776  -5.618  20.036  1.00  0.00           C  
ATOM   1527  NZ  LYS A 104     -22.078  -4.161  20.061  1.00  0.00           N  
ATOM   1528  H   LYS A 104     -22.453  -8.059  23.217  1.00  0.00           H  
ATOM   1529  HA  LYS A 104     -20.817 -10.009  21.682  1.00  0.00           H  
ATOM   1530  HB3 LYS A 104     -18.939  -8.506  22.279  1.00  0.00           H  
ATOM   1531  HG3 LYS A 104     -20.934  -8.033  20.403  1.00  0.00           H  
ATOM   1532  HD3 LYS A 104     -20.199  -5.316  21.494  1.00  0.00           H  
ATOM   1533  HE3 LYS A 104     -22.707  -6.194  20.011  1.00  0.00           H  
ATOM   1534  HZ1 LYS A 104     -22.690  -3.905  19.298  1.00  0.00           H  
ATOM   1535  HZ2 LYS A 104     -22.532  -3.890  20.921  1.00  0.00           H  
ATOM   1536  HZ3 LYS A 104     -21.234  -3.614  19.967  1.00  0.00           H  
ATOM   1537  N   ASN A 105     -19.339 -10.905  23.640  1.00  0.00           N  
ATOM   1538  CA  ASN A 105     -18.885 -11.951  24.575  1.00  0.00           C  
ATOM   1539  C   ASN A 105     -19.946 -13.050  24.836  1.00  0.00           C  
ATOM   1540  O   ASN A 105     -20.072 -13.572  25.948  1.00  0.00           O  
ATOM   1541  CB  ASN A 105     -18.295 -11.291  25.844  1.00  0.00           C  
ATOM   1542  CG  ASN A 105     -16.862 -10.825  25.654  1.00  0.00           C  
ATOM   1543  OD1 ASN A 105     -16.509 -10.145  24.700  1.00  0.00           O  
ATOM   1544  ND2 ASN A 105     -15.975 -11.205  26.548  1.00  0.00           N  
ATOM   1545  H   ASN A 105     -18.821 -10.800  22.780  1.00  0.00           H  
ATOM   1546  HA  ASN A 105     -18.070 -12.486  24.081  1.00  0.00           H  
ATOM   1547  HB3 ASN A 105     -18.300 -12.014  26.659  1.00  0.00           H  
ATOM   1548 HD21 ASN A 105     -16.258 -11.780  27.328  1.00  0.00           H  
ATOM   1549 HD22 ASN A 105     -15.017 -10.916  26.432  1.00  0.00           H  
ATOM   1550  N   LYS A 106     -20.719 -13.404  23.799  1.00  0.00           N  
ATOM   1551  CA  LYS A 106     -21.801 -14.401  23.824  1.00  0.00           C  
ATOM   1552  C   LYS A 106     -21.598 -15.430  22.714  1.00  0.00           C  
ATOM   1553  O   LYS A 106     -20.982 -15.160  21.683  1.00  0.00           O  
ATOM   1554  CB  LYS A 106     -23.176 -13.700  23.704  1.00  0.00           C  
ATOM   1555  CG  LYS A 106     -24.004 -13.645  25.001  1.00  0.00           C  
ATOM   1556  CD  LYS A 106     -23.295 -12.998  26.201  1.00  0.00           C  
ATOM   1557  CE  LYS A 106     -24.316 -12.391  27.171  1.00  0.00           C  
ATOM   1558  NZ  LYS A 106     -23.782 -12.296  28.560  1.00  0.00           N  
ATOM   1559  H   LYS A 106     -20.492 -12.999  22.896  1.00  0.00           H  
ATOM   1560  HA  LYS A 106     -21.769 -14.955  24.763  1.00  0.00           H  
ATOM   1561  HB3 LYS A 106     -23.783 -14.221  22.963  1.00  0.00           H  
ATOM   1562  HG3 LYS A 106     -24.294 -14.660  25.283  1.00  0.00           H  
ATOM   1563  HD3 LYS A 106     -22.629 -12.206  25.863  1.00  0.00           H  
ATOM   1564  HE3 LYS A 106     -25.221 -13.005  27.169  1.00  0.00           H  
ATOM   1565  HZ1 LYS A 106     -24.436 -11.818  29.167  1.00  0.00           H  
ATOM   1566  HZ2 LYS A 106     -23.625 -13.213  28.953  1.00  0.00           H  
ATOM   1567  HZ3 LYS A 106     -22.909 -11.788  28.586  1.00  0.00           H  
ATOM   1568  N   ASP A 107     -22.149 -16.614  22.941  1.00  0.00           N  
ATOM   1569  CA  ASP A 107     -22.107 -17.754  22.035  1.00  0.00           C  
ATOM   1570  C   ASP A 107     -23.482 -18.436  22.048  1.00  0.00           C  
ATOM   1571  O   ASP A 107     -24.043 -18.716  23.112  1.00  0.00           O  
ATOM   1572  CB  ASP A 107     -20.957 -18.684  22.456  1.00  0.00           C  
ATOM   1573  CG  ASP A 107     -21.019 -20.056  21.768  1.00  0.00           C  
ATOM   1574  OD1 ASP A 107     -21.665 -20.976  22.323  1.00  0.00           O  
ATOM   1575  OD2 ASP A 107     -20.406 -20.219  20.689  1.00  0.00           O  
ATOM   1576  H   ASP A 107     -22.637 -16.749  23.813  1.00  0.00           H  
ATOM   1577  HA  ASP A 107     -21.912 -17.408  21.024  1.00  0.00           H  
ATOM   1578  HB3 ASP A 107     -20.987 -18.828  23.535  1.00  0.00           H  
ATOM   1579  N   TYR A 108     -24.031 -18.669  20.855  1.00  0.00           N  
ATOM   1580  CA  TYR A 108     -25.327 -19.319  20.645  1.00  0.00           C  
ATOM   1581  C   TYR A 108     -25.131 -20.609  19.850  1.00  0.00           C  
ATOM   1582  O   TYR A 108     -24.398 -20.649  18.857  1.00  0.00           O  
ATOM   1583  CB  TYR A 108     -26.311 -18.376  19.927  1.00  0.00           C  
ATOM   1584  CG  TYR A 108     -27.112 -17.463  20.835  1.00  0.00           C  
ATOM   1585  CD1 TYR A 108     -26.480 -16.391  21.498  1.00  0.00           C  
ATOM   1586  CD2 TYR A 108     -28.498 -17.665  20.985  1.00  0.00           C  
ATOM   1587  CE1 TYR A 108     -27.233 -15.528  22.318  1.00  0.00           C  
ATOM   1588  CE2 TYR A 108     -29.256 -16.801  21.800  1.00  0.00           C  
ATOM   1589  CZ  TYR A 108     -28.623 -15.730  22.470  1.00  0.00           C  
ATOM   1590  OH  TYR A 108     -29.342 -14.887  23.259  1.00  0.00           O  
ATOM   1591  H   TYR A 108     -23.498 -18.423  20.030  1.00  0.00           H  
ATOM   1592  HA  TYR A 108     -25.771 -19.587  21.603  1.00  0.00           H  
ATOM   1593  HB3 TYR A 108     -27.018 -18.984  19.357  1.00  0.00           H  
ATOM   1594  HD1 TYR A 108     -25.417 -16.223  21.370  1.00  0.00           H  
ATOM   1595  HD2 TYR A 108     -28.987 -18.480  20.464  1.00  0.00           H  
ATOM   1596  HE1 TYR A 108     -26.758 -14.702  22.828  1.00  0.00           H  
ATOM   1597  HE2 TYR A 108     -30.323 -16.955  21.902  1.00  0.00           H  
ATOM   1598  HH  TYR A 108     -30.287 -15.114  23.285  1.00  0.00           H  
ATOM   1599  N   TYR A 109     -25.844 -21.647  20.287  1.00  0.00           N  
ATOM   1600  CA  TYR A 109     -25.944 -22.950  19.639  1.00  0.00           C  
ATOM   1601  C   TYR A 109     -27.420 -23.237  19.339  1.00  0.00           C  
ATOM   1602  O   TYR A 109     -28.335 -22.815  20.055  1.00  0.00           O  
ATOM   1603  CB  TYR A 109     -25.316 -24.054  20.514  1.00  0.00           C  
ATOM   1604  CG  TYR A 109     -23.875 -24.418  20.196  1.00  0.00           C  
ATOM   1605  CD1 TYR A 109     -22.860 -23.442  20.220  1.00  0.00           C  
ATOM   1606  CD2 TYR A 109     -23.546 -25.759  19.905  1.00  0.00           C  
ATOM   1607  CE1 TYR A 109     -21.526 -23.798  19.941  1.00  0.00           C  
ATOM   1608  CE2 TYR A 109     -22.211 -26.123  19.632  1.00  0.00           C  
ATOM   1609  CZ  TYR A 109     -21.198 -25.137  19.641  1.00  0.00           C  
ATOM   1610  OH  TYR A 109     -19.904 -25.469  19.378  1.00  0.00           O  
ATOM   1611  H   TYR A 109     -26.450 -21.499  21.083  1.00  0.00           H  
ATOM   1612  HA  TYR A 109     -25.410 -22.930  18.693  1.00  0.00           H  
ATOM   1613  HB3 TYR A 109     -25.906 -24.961  20.380  1.00  0.00           H  
ATOM   1614  HD1 TYR A 109     -23.093 -22.415  20.464  1.00  0.00           H  
ATOM   1615  HD2 TYR A 109     -24.318 -26.517  19.896  1.00  0.00           H  
ATOM   1616  HE1 TYR A 109     -20.746 -23.050  19.971  1.00  0.00           H  
ATOM   1617  HE2 TYR A 109     -21.963 -27.153  19.421  1.00  0.00           H  
ATOM   1618  HH  TYR A 109     -19.790 -26.420  19.210  1.00  0.00           H  
ATOM   1619  N   ILE A 110     -27.647 -23.947  18.237  1.00  0.00           N  
ATOM   1620  CA  ILE A 110     -28.959 -24.358  17.719  1.00  0.00           C  
ATOM   1621  C   ILE A 110     -28.758 -25.711  17.055  1.00  0.00           C  
ATOM   1622  O   ILE A 110     -27.741 -25.888  16.389  1.00  0.00           O  
ATOM   1623  CB  ILE A 110     -29.471 -23.337  16.670  1.00  0.00           C  
ATOM   1624  CG1 ILE A 110     -29.523 -21.882  17.204  1.00  0.00           C  
ATOM   1625  CG2 ILE A 110     -30.820 -23.721  16.064  1.00  0.00           C  
ATOM   1626  CD1 ILE A 110     -30.316 -20.846  16.394  1.00  0.00           C  
ATOM   1627  H   ILE A 110     -26.840 -24.239  17.699  1.00  0.00           H  
ATOM   1628  HA  ILE A 110     -29.665 -24.485  18.535  1.00  0.00           H  
ATOM   1629  HB  ILE A 110     -28.770 -23.378  15.842  1.00  0.00           H  
ATOM   1630 HG13 ILE A 110     -28.509 -21.516  17.299  1.00  0.00           H  
ATOM   1631 HG21 ILE A 110     -30.828 -24.753  15.722  1.00  0.00           H  
ATOM   1632 HG22 ILE A 110     -31.631 -23.553  16.769  1.00  0.00           H  
ATOM   1633 HG23 ILE A 110     -30.976 -23.106  15.180  1.00  0.00           H  
ATOM   1634 HD11 ILE A 110     -30.162 -19.855  16.826  1.00  0.00           H  
ATOM   1635 HD12 ILE A 110     -29.992 -20.844  15.349  1.00  0.00           H  
ATOM   1636 HD13 ILE A 110     -31.380 -21.080  16.443  1.00  0.00           H  
ATOM   1637  N   ILE A 111     -29.707 -26.638  17.186  1.00  0.00           N  
ATOM   1638  CA  ILE A 111     -29.625 -27.966  16.557  1.00  0.00           C  
ATOM   1639  C   ILE A 111     -30.954 -28.300  15.863  1.00  0.00           C  
ATOM   1640  O   ILE A 111     -31.983 -27.664  16.106  1.00  0.00           O  
ATOM   1641  CB  ILE A 111     -29.141 -29.060  17.555  1.00  0.00           C  
ATOM   1642  CG1 ILE A 111     -30.283 -29.735  18.349  1.00  0.00           C  
ATOM   1643  CG2 ILE A 111     -28.037 -28.525  18.490  1.00  0.00           C  
ATOM   1644  CD1 ILE A 111     -29.822 -30.824  19.332  1.00  0.00           C  
ATOM   1645  H   ILE A 111     -30.558 -26.401  17.688  1.00  0.00           H  
ATOM   1646  HA  ILE A 111     -28.877 -27.934  15.764  1.00  0.00           H  
ATOM   1647  HB  ILE A 111     -28.680 -29.850  16.957  1.00  0.00           H  
ATOM   1648 HG13 ILE A 111     -30.944 -30.232  17.639  1.00  0.00           H  
ATOM   1649 HG21 ILE A 111     -27.193 -28.162  17.907  1.00  0.00           H  
ATOM   1650 HG22 ILE A 111     -28.400 -27.716  19.122  1.00  0.00           H  
ATOM   1651 HG23 ILE A 111     -27.678 -29.313  19.135  1.00  0.00           H  
ATOM   1652 HD11 ILE A 111     -30.672 -31.430  19.638  1.00  0.00           H  
ATOM   1653 HD12 ILE A 111     -29.088 -31.481  18.861  1.00  0.00           H  
ATOM   1654 HD13 ILE A 111     -29.391 -30.368  20.221  1.00  0.00           H  
ATOM   1655  N   SER A 112     -30.932 -29.308  14.998  1.00  0.00           N  
ATOM   1656  CA  SER A 112     -32.120 -29.829  14.318  1.00  0.00           C  
ATOM   1657  C   SER A 112     -32.043 -31.345  14.155  1.00  0.00           C  
ATOM   1658  O   SER A 112     -30.987 -31.968  14.306  1.00  0.00           O  
ATOM   1659  CB  SER A 112     -32.271 -29.152  12.955  1.00  0.00           C  
ATOM   1660  OG  SER A 112     -33.581 -29.349  12.446  1.00  0.00           O  
ATOM   1661  H   SER A 112     -30.042 -29.739  14.780  1.00  0.00           H  
ATOM   1662  HA  SER A 112     -33.009 -29.602  14.912  1.00  0.00           H  
ATOM   1663  HB3 SER A 112     -31.534 -29.561  12.264  1.00  0.00           H  
ATOM   1664  HG  SER A 112     -33.630 -28.931  11.567  1.00  0.00           H  
ATOM   1665  N   THR A 113     -33.187 -31.939  13.827  1.00  0.00           N  
ATOM   1666  CA  THR A 113     -33.436 -33.385  13.833  1.00  0.00           C  
ATOM   1667  C   THR A 113     -33.879 -33.870  12.450  1.00  0.00           C  
ATOM   1668  O   THR A 113     -34.772 -34.704  12.322  1.00  0.00           O  
ATOM   1669  CB  THR A 113     -34.419 -33.765  14.959  1.00  0.00           C  
ATOM   1670  OG1 THR A 113     -35.659 -33.105  14.821  1.00  0.00           O  
ATOM   1671  CG2 THR A 113     -33.874 -33.378  16.333  1.00  0.00           C  
ATOM   1672  H   THR A 113     -33.988 -31.331  13.705  1.00  0.00           H  
ATOM   1673  HA  THR A 113     -32.500 -33.904  14.042  1.00  0.00           H  
ATOM   1674  HB  THR A 113     -34.578 -34.842  14.927  1.00  0.00           H  
ATOM   1675  HG1 THR A 113     -36.289 -33.587  15.383  1.00  0.00           H  
ATOM   1676 HG21 THR A 113     -34.522 -33.781  17.111  1.00  0.00           H  
ATOM   1677 HG22 THR A 113     -32.869 -33.772  16.467  1.00  0.00           H  
ATOM   1678 HG23 THR A 113     -33.851 -32.296  16.433  1.00  0.00           H  
ATOM   1679  N   SER A 114     -33.227 -33.365  11.393  1.00  0.00           N  
ATOM   1680  CA  SER A 114     -33.502 -33.679   9.976  1.00  0.00           C  
ATOM   1681  C   SER A 114     -33.450 -35.183   9.596  1.00  0.00           C  
ATOM   1682  O   SER A 114     -33.949 -35.592   8.545  1.00  0.00           O  
ATOM   1683  CB  SER A 114     -32.618 -32.769   9.103  1.00  0.00           C  
ATOM   1684  OG  SER A 114     -32.578 -33.122   7.737  1.00  0.00           O  
ATOM   1685  H   SER A 114     -32.520 -32.670  11.591  1.00  0.00           H  
ATOM   1686  HA  SER A 114     -34.528 -33.378   9.792  1.00  0.00           H  
ATOM   1687  HB3 SER A 114     -31.595 -32.784   9.467  1.00  0.00           H  
ATOM   1688  HG  SER A 114     -32.042 -32.471   7.249  1.00  0.00           H  
ATOM   1689  N   ASN A 115     -32.958 -36.065  10.483  1.00  0.00           N  
ATOM   1690  CA  ASN A 115     -33.085 -37.519  10.313  1.00  0.00           C  
ATOM   1691  C   ASN A 115     -34.533 -38.019  10.503  1.00  0.00           C  
ATOM   1692  O   ASN A 115     -34.886 -39.078   9.982  1.00  0.00           O  
ATOM   1693  CB  ASN A 115     -32.147 -38.245  11.305  1.00  0.00           C  
ATOM   1694  CG  ASN A 115     -31.624 -39.567  10.758  1.00  0.00           C  
ATOM   1695  OD1 ASN A 115     -31.211 -39.675   9.613  1.00  0.00           O  
ATOM   1696  ND2 ASN A 115     -31.573 -40.604  11.563  1.00  0.00           N  
ATOM   1697  H   ASN A 115     -32.584 -35.707  11.346  1.00  0.00           H  
ATOM   1698  HA  ASN A 115     -32.781 -37.761   9.292  1.00  0.00           H  
ATOM   1699  HB3 ASN A 115     -32.679 -38.414  12.243  1.00  0.00           H  
ATOM   1700 HD21 ASN A 115     -31.897 -40.549  12.513  1.00  0.00           H  
ATOM   1701 HD22 ASN A 115     -31.197 -41.464  11.195  1.00  0.00           H  
ATOM   1702  N   GLY A 116     -35.346 -37.280  11.274  1.00  0.00           N  
ATOM   1703  CA  GLY A 116     -36.708 -37.621  11.703  1.00  0.00           C  
ATOM   1704  C   GLY A 116     -36.881 -39.081  12.137  1.00  0.00           C  
ATOM   1705  O   GLY A 116     -37.816 -39.750  11.687  1.00  0.00           O  
ATOM   1706  H   GLY A 116     -34.982 -36.392  11.606  1.00  0.00           H  
ATOM   1707  HA2 GLY A 116     -36.952 -36.997  12.564  1.00  0.00           H  
ATOM   1708  N   SER A 117     -35.934 -39.596  12.941  1.00  0.00           N  
ATOM   1709  CA  SER A 117     -35.912 -40.984  13.443  1.00  0.00           C  
ATOM   1710  C   SER A 117     -37.234 -41.362  14.120  1.00  0.00           C  
ATOM   1711  O   SER A 117     -37.899 -40.489  14.669  1.00  0.00           O  
ATOM   1712  CB  SER A 117     -34.759 -41.153  14.439  1.00  0.00           C  
ATOM   1713  OG  SER A 117     -34.675 -42.500  14.867  1.00  0.00           O  
ATOM   1714  H   SER A 117     -35.235 -38.955  13.287  1.00  0.00           H  
ATOM   1715  HA  SER A 117     -35.743 -41.655  12.602  1.00  0.00           H  
ATOM   1716  HB3 SER A 117     -34.926 -40.506  15.305  1.00  0.00           H  
ATOM   1717  HG  SER A 117     -33.921 -42.593  15.483  1.00  0.00           H  
ATOM   1718  N   LEU A 118     -37.621 -42.643  14.147  1.00  0.00           N  
ATOM   1719  CA  LEU A 118     -38.887 -43.086  14.753  1.00  0.00           C  
ATOM   1720  C   LEU A 118     -38.999 -42.679  16.238  1.00  0.00           C  
ATOM   1721  O   LEU A 118     -40.042 -42.184  16.668  1.00  0.00           O  
ATOM   1722  CB  LEU A 118     -39.032 -44.604  14.515  1.00  0.00           C  
ATOM   1723  CG  LEU A 118     -40.442 -45.223  14.639  1.00  0.00           C  
ATOM   1724  CD1 LEU A 118     -41.022 -45.210  16.053  1.00  0.00           C  
ATOM   1725  CD2 LEU A 118     -41.456 -44.569  13.694  1.00  0.00           C  
ATOM   1726  H   LEU A 118     -37.007 -43.334  13.741  1.00  0.00           H  
ATOM   1727  HA  LEU A 118     -39.686 -42.571  14.223  1.00  0.00           H  
ATOM   1728  HB3 LEU A 118     -38.356 -45.132  15.189  1.00  0.00           H  
ATOM   1729  HG  LEU A 118     -40.346 -46.268  14.344  1.00  0.00           H  
ATOM   1730 HD11 LEU A 118     -40.260 -45.512  16.771  1.00  0.00           H  
ATOM   1731 HD12 LEU A 118     -41.399 -44.226  16.310  1.00  0.00           H  
ATOM   1732 HD13 LEU A 118     -41.850 -45.915  16.106  1.00  0.00           H  
ATOM   1733 HD21 LEU A 118     -42.393 -45.122  13.729  1.00  0.00           H  
ATOM   1734 HD22 LEU A 118     -41.643 -43.538  13.991  1.00  0.00           H  
ATOM   1735 HD23 LEU A 118     -41.072 -44.590  12.674  1.00  0.00           H  
ATOM   1736  N   GLU A 119     -37.918 -42.791  17.017  1.00  0.00           N  
ATOM   1737  CA  GLU A 119     -37.897 -42.313  18.414  1.00  0.00           C  
ATOM   1738  C   GLU A 119     -38.099 -40.787  18.542  1.00  0.00           C  
ATOM   1739  O   GLU A 119     -38.695 -40.316  19.510  1.00  0.00           O  
ATOM   1740  CB  GLU A 119     -36.592 -42.727  19.117  1.00  0.00           C  
ATOM   1741  CG  GLU A 119     -36.483 -44.247  19.311  1.00  0.00           C  
ATOM   1742  CD  GLU A 119     -35.723 -44.594  20.605  1.00  0.00           C  
ATOM   1743  OE1 GLU A 119     -34.468 -44.659  20.589  1.00  0.00           O  
ATOM   1744  OE2 GLU A 119     -36.375 -44.825  21.653  1.00  0.00           O  
ATOM   1745  H   GLU A 119     -37.074 -43.180  16.623  1.00  0.00           H  
ATOM   1746  HA  GLU A 119     -38.726 -42.773  18.950  1.00  0.00           H  
ATOM   1747  HB3 GLU A 119     -36.577 -42.250  20.098  1.00  0.00           H  
ATOM   1748  HG3 GLU A 119     -35.980 -44.682  18.444  1.00  0.00           H  
ATOM   1749  N   GLY A 120     -37.664 -40.015  17.538  1.00  0.00           N  
ATOM   1750  CA  GLY A 120     -37.704 -38.549  17.490  1.00  0.00           C  
ATOM   1751  C   GLY A 120     -38.680 -37.967  16.461  1.00  0.00           C  
ATOM   1752  O   GLY A 120     -38.529 -36.811  16.061  1.00  0.00           O  
ATOM   1753  H   GLY A 120     -37.274 -40.485  16.733  1.00  0.00           H  
ATOM   1754  HA2 GLY A 120     -37.947 -38.143  18.473  1.00  0.00           H  
ATOM   1755  N   LEU A 121     -39.658 -38.758  15.997  1.00  0.00           N  
ATOM   1756  CA  LEU A 121     -40.564 -38.379  14.903  1.00  0.00           C  
ATOM   1757  C   LEU A 121     -41.440 -37.178  15.312  1.00  0.00           C  
ATOM   1758  O   LEU A 121     -41.657 -36.246  14.540  1.00  0.00           O  
ATOM   1759  CB  LEU A 121     -41.346 -39.640  14.446  1.00  0.00           C  
ATOM   1760  CG  LEU A 121     -42.848 -39.730  14.795  1.00  0.00           C  
ATOM   1761  CD1 LEU A 121     -43.708 -39.013  13.748  1.00  0.00           C  
ATOM   1762  CD2 LEU A 121     -43.319 -41.184  14.856  1.00  0.00           C  
ATOM   1763  H   LEU A 121     -39.645 -39.725  16.295  1.00  0.00           H  
ATOM   1764  HA  LEU A 121     -39.946 -38.058  14.064  1.00  0.00           H  
ATOM   1765  HB3 LEU A 121     -40.852 -40.520  14.855  1.00  0.00           H  
ATOM   1766  HG  LEU A 121     -43.039 -39.303  15.777  1.00  0.00           H  
ATOM   1767 HD11 LEU A 121     -43.399 -37.977  13.645  1.00  0.00           H  
ATOM   1768 HD12 LEU A 121     -43.604 -39.503  12.779  1.00  0.00           H  
ATOM   1769 HD13 LEU A 121     -44.755 -39.034  14.051  1.00  0.00           H  
ATOM   1770 HD21 LEU A 121     -44.379 -41.217  15.115  1.00  0.00           H  
ATOM   1771 HD22 LEU A 121     -43.163 -41.674  13.895  1.00  0.00           H  
ATOM   1772 HD23 LEU A 121     -42.761 -41.713  15.630  1.00  0.00           H  
ATOM   1773  N   ASP A 122     -41.856 -37.181  16.577  1.00  0.00           N  
ATOM   1774  CA  ASP A 122     -42.675 -36.169  17.248  1.00  0.00           C  
ATOM   1775  C   ASP A 122     -42.006 -35.719  18.557  1.00  0.00           C  
ATOM   1776  O   ASP A 122     -42.032 -34.529  18.884  1.00  0.00           O  
ATOM   1777  CB  ASP A 122     -44.068 -36.758  17.504  1.00  0.00           C  
ATOM   1778  CG  ASP A 122     -44.985 -35.758  18.226  1.00  0.00           C  
ATOM   1779  OD1 ASP A 122     -45.355 -34.726  17.617  1.00  0.00           O  
ATOM   1780  OD2 ASP A 122     -45.340 -36.004  19.404  1.00  0.00           O  
ATOM   1781  H   ASP A 122     -41.604 -37.999  17.108  1.00  0.00           H  
ATOM   1782  HA  ASP A 122     -42.795 -35.292  16.609  1.00  0.00           H  
ATOM   1783  HB3 ASP A 122     -43.968 -37.671  18.097  1.00  0.00           H  
ATOM   1784  N   ASN A 123     -41.323 -36.641  19.253  1.00  0.00           N  
ATOM   1785  CA  ASN A 123     -40.460 -36.317  20.383  1.00  0.00           C  
ATOM   1786  C   ASN A 123     -39.251 -35.464  19.966  1.00  0.00           C  
ATOM   1787  O   ASN A 123     -38.902 -35.324  18.790  1.00  0.00           O  
ATOM   1788  CB  ASN A 123     -40.018 -37.617  21.095  1.00  0.00           C  
ATOM   1789  CG  ASN A 123     -39.748 -37.420  22.583  1.00  0.00           C  
ATOM   1790  OD1 ASN A 123     -40.240 -36.497  23.217  1.00  0.00           O  
ATOM   1791  ND2 ASN A 123     -38.943 -38.245  23.201  1.00  0.00           N  
ATOM   1792  H   ASN A 123     -41.333 -37.598  18.936  1.00  0.00           H  
ATOM   1793  HA  ASN A 123     -41.058 -35.715  21.071  1.00  0.00           H  
ATOM   1794  HB3 ASN A 123     -39.112 -37.991  20.620  1.00  0.00           H  
ATOM   1795 HD21 ASN A 123     -38.408 -38.946  22.684  1.00  0.00           H  
ATOM   1796 HD22 ASN A 123     -38.810 -38.131  24.191  1.00  0.00           H  
ATOM   1797  N   GLN A 124     -38.578 -34.919  20.966  1.00  0.00           N  
ATOM   1798  CA  GLN A 124     -37.425 -34.036  20.857  1.00  0.00           C  
ATOM   1799  C   GLN A 124     -36.097 -34.765  20.560  1.00  0.00           C  
ATOM   1800  O   GLN A 124     -35.128 -34.553  21.275  1.00  0.00           O  
ATOM   1801  CB  GLN A 124     -37.406 -33.215  22.159  1.00  0.00           C  
ATOM   1802  CG  GLN A 124     -37.148 -34.027  23.450  1.00  0.00           C  
ATOM   1803  CD  GLN A 124     -37.782 -33.424  24.705  1.00  0.00           C  
ATOM   1804  OE1 GLN A 124     -38.320 -32.327  24.727  1.00  0.00           O  
ATOM   1805  NE2 GLN A 124     -37.777 -34.147  25.806  1.00  0.00           N  
ATOM   1806  H   GLN A 124     -38.926 -35.096  21.899  1.00  0.00           H  
ATOM   1807  HA  GLN A 124     -37.595 -33.349  20.029  1.00  0.00           H  
ATOM   1808  HB3 GLN A 124     -38.366 -32.700  22.228  1.00  0.00           H  
ATOM   1809  HG3 GLN A 124     -36.073 -34.103  23.620  1.00  0.00           H  
ATOM   1810 HE21 GLN A 124     -37.351 -35.060  25.810  1.00  0.00           H  
ATOM   1811 HE22 GLN A 124     -38.236 -33.776  26.624  1.00  0.00           H  
ATOM   1812  N   GLU A 125     -36.013 -35.646  19.557  1.00  0.00           N  
ATOM   1813  CA  GLU A 125     -34.814 -36.477  19.317  1.00  0.00           C  
ATOM   1814  C   GLU A 125     -34.419 -36.552  17.836  1.00  0.00           C  
ATOM   1815  O   GLU A 125     -35.239 -36.331  16.943  1.00  0.00           O  
ATOM   1816  CB  GLU A 125     -35.004 -37.904  19.882  1.00  0.00           C  
ATOM   1817  CG  GLU A 125     -35.594 -38.000  21.300  1.00  0.00           C  
ATOM   1818  CD  GLU A 125     -35.762 -39.460  21.762  1.00  0.00           C  
ATOM   1819  OE1 GLU A 125     -34.769 -40.229  21.760  1.00  0.00           O  
ATOM   1820  OE2 GLU A 125     -36.886 -39.844  22.168  1.00  0.00           O  
ATOM   1821  H   GLU A 125     -36.811 -35.759  18.940  1.00  0.00           H  
ATOM   1822  HA  GLU A 125     -33.962 -36.032  19.825  1.00  0.00           H  
ATOM   1823  HB3 GLU A 125     -34.028 -38.396  19.875  1.00  0.00           H  
ATOM   1824  HG3 GLU A 125     -36.571 -37.512  21.313  1.00  0.00           H  
ATOM   1825  N   GLY A 126     -33.157 -36.889  17.552  1.00  0.00           N  
ATOM   1826  CA  GLY A 126     -32.621 -37.005  16.196  1.00  0.00           C  
ATOM   1827  C   GLY A 126     -31.374 -37.881  16.085  1.00  0.00           C  
ATOM   1828  O   GLY A 126     -30.810 -38.344  17.078  1.00  0.00           O  
ATOM   1829  H   GLY A 126     -32.495 -36.977  18.317  1.00  0.00           H  
ATOM   1830  HA2 GLY A 126     -33.387 -37.407  15.530  1.00  0.00           H  
ATOM   1831  N   GLY A 127     -30.930 -38.072  14.840  1.00  0.00           N  
ATOM   1832  CA  GLY A 127     -29.657 -38.715  14.474  1.00  0.00           C  
ATOM   1833  C   GLY A 127     -28.823 -37.892  13.480  1.00  0.00           C  
ATOM   1834  O   GLY A 127     -27.694 -38.259  13.159  1.00  0.00           O  
ATOM   1835  H   GLY A 127     -31.530 -37.760  14.093  1.00  0.00           H  
ATOM   1836  HA2 GLY A 127     -29.048 -38.890  15.365  1.00  0.00           H  
ATOM   1837  N   VAL A 128     -29.352 -36.753  13.001  1.00  0.00           N  
ATOM   1838  CA  VAL A 128     -28.685 -35.885  12.015  1.00  0.00           C  
ATOM   1839  C   VAL A 128     -27.556 -35.100  12.669  1.00  0.00           C  
ATOM   1840  O   VAL A 128     -26.454 -35.090  12.129  1.00  0.00           O  
ATOM   1841  CB  VAL A 128     -29.697 -34.972  11.280  1.00  0.00           C  
ATOM   1842  CG1 VAL A 128     -29.273 -33.505  11.180  1.00  0.00           C  
ATOM   1843  CG2 VAL A 128     -29.954 -35.515   9.871  1.00  0.00           C  
ATOM   1844  H   VAL A 128     -30.236 -36.455  13.383  1.00  0.00           H  
ATOM   1845  HA  VAL A 128     -28.205 -36.515  11.267  1.00  0.00           H  
ATOM   1846  HB  VAL A 128     -30.643 -34.982  11.817  1.00  0.00           H  
ATOM   1847 HG11 VAL A 128     -29.276 -33.058  12.172  1.00  0.00           H  
ATOM   1848 HG12 VAL A 128     -28.287 -33.410  10.731  1.00  0.00           H  
ATOM   1849 HG13 VAL A 128     -29.966 -32.942  10.570  1.00  0.00           H  
ATOM   1850 HG21 VAL A 128     -30.698 -34.912   9.353  1.00  0.00           H  
ATOM   1851 HG22 VAL A 128     -29.056 -35.491   9.279  1.00  0.00           H  
ATOM   1852 HG23 VAL A 128     -30.299 -36.542   9.907  1.00  0.00           H  
ATOM   1853  N   CYS A 129     -27.764 -34.510  13.852  1.00  0.00           N  
ATOM   1854  CA  CYS A 129     -26.694 -33.802  14.574  1.00  0.00           C  
ATOM   1855  C   CYS A 129     -25.484 -34.724  14.872  1.00  0.00           C  
ATOM   1856  O   CYS A 129     -24.348 -34.259  14.980  1.00  0.00           O  
ATOM   1857  CB  CYS A 129     -27.264 -33.149  15.841  1.00  0.00           C  
ATOM   1858  SG  CYS A 129     -27.120 -34.174  17.317  1.00  0.00           S  
ATOM   1859  H   CYS A 129     -28.688 -34.538  14.265  1.00  0.00           H  
ATOM   1860  HA  CYS A 129     -26.345 -32.994  13.937  1.00  0.00           H  
ATOM   1861  HB3 CYS A 129     -28.309 -32.875  15.690  1.00  0.00           H  
ATOM   1862  N   GLN A 130     -25.742 -36.037  14.947  1.00  0.00           N  
ATOM   1863  CA  GLN A 130     -24.772 -37.106  15.170  1.00  0.00           C  
ATOM   1864  C   GLN A 130     -23.938 -37.485  13.922  1.00  0.00           C  
ATOM   1865  O   GLN A 130     -22.845 -38.033  14.083  1.00  0.00           O  
ATOM   1866  CB  GLN A 130     -25.532 -38.349  15.690  1.00  0.00           C  
ATOM   1867  CG  GLN A 130     -24.807 -39.000  16.879  1.00  0.00           C  
ATOM   1868  CD  GLN A 130     -25.184 -40.471  17.047  1.00  0.00           C  
ATOM   1869  OE1 GLN A 130     -26.347 -40.843  17.151  1.00  0.00           O  
ATOM   1870  NE2 GLN A 130     -24.224 -41.374  17.063  1.00  0.00           N  
ATOM   1871  H   GLN A 130     -26.704 -36.320  14.842  1.00  0.00           H  
ATOM   1872  HA  GLN A 130     -24.083 -36.768  15.946  1.00  0.00           H  
ATOM   1873  HB3 GLN A 130     -25.631 -39.076  14.883  1.00  0.00           H  
ATOM   1874  HG3 GLN A 130     -25.062 -38.458  17.793  1.00  0.00           H  
ATOM   1875 HE21 GLN A 130     -23.260 -41.093  16.962  1.00  0.00           H  
ATOM   1876 HE22 GLN A 130     -24.480 -42.344  17.156  1.00  0.00           H  
ATOM   1877  N   THR A 131     -24.418 -37.191  12.699  1.00  0.00           N  
ATOM   1878  CA  THR A 131     -23.808 -37.665  11.430  1.00  0.00           C  
ATOM   1879  C   THR A 131     -23.777 -36.612  10.314  1.00  0.00           C  
ATOM   1880  O   THR A 131     -22.684 -36.205   9.909  1.00  0.00           O  
ATOM   1881  CB  THR A 131     -24.515 -38.937  10.913  1.00  0.00           C  
ATOM   1882  OG1 THR A 131     -24.395 -39.988  11.854  1.00  0.00           O  
ATOM   1883  CG2 THR A 131     -23.928 -39.444   9.589  1.00  0.00           C  
ATOM   1884  H   THR A 131     -25.305 -36.709  12.655  1.00  0.00           H  
ATOM   1885  HA  THR A 131     -22.768 -37.934  11.621  1.00  0.00           H  
ATOM   1886  HB  THR A 131     -25.572 -38.722  10.761  1.00  0.00           H  
ATOM   1887  HG1 THR A 131     -24.897 -40.746  11.512  1.00  0.00           H  
ATOM   1888 HG21 THR A 131     -24.379 -40.397   9.318  1.00  0.00           H  
ATOM   1889 HG22 THR A 131     -24.141 -38.734   8.790  1.00  0.00           H  
ATOM   1890 HG23 THR A 131     -22.847 -39.568   9.679  1.00  0.00           H  
ATOM   1891  N   ARG A 132     -24.933 -36.120   9.825  1.00  0.00           N  
ATOM   1892  CA  ARG A 132     -25.005 -34.956   8.904  1.00  0.00           C  
ATOM   1893  C   ARG A 132     -24.346 -33.714   9.509  1.00  0.00           C  
ATOM   1894  O   ARG A 132     -23.814 -32.878   8.777  1.00  0.00           O  
ATOM   1895  CB  ARG A 132     -26.473 -34.588   8.618  1.00  0.00           C  
ATOM   1896  CG  ARG A 132     -27.117 -35.174   7.351  1.00  0.00           C  
ATOM   1897  CD  ARG A 132     -27.354 -36.696   7.358  1.00  0.00           C  
ATOM   1898  NE  ARG A 132     -28.708 -37.054   6.866  1.00  0.00           N  
ATOM   1899  CZ  ARG A 132     -29.209 -36.895   5.651  1.00  0.00           C  
ATOM   1900  NH1 ARG A 132     -28.500 -36.439   4.656  1.00  0.00           N  
ATOM   1901  NH2 ARG A 132     -30.452 -37.199   5.405  1.00  0.00           N  
ATOM   1902  H   ARG A 132     -25.794 -36.470  10.221  1.00  0.00           H  
ATOM   1903  HA  ARG A 132     -24.478 -35.172   7.971  1.00  0.00           H  
ATOM   1904  HB3 ARG A 132     -26.551 -33.501   8.509  1.00  0.00           H  
ATOM   1905  HG3 ARG A 132     -26.514 -34.907   6.485  1.00  0.00           H  
ATOM   1906  HD3 ARG A 132     -27.262 -37.061   8.379  1.00  0.00           H  
ATOM   1907  HE  ARG A 132     -29.339 -37.459   7.540  1.00  0.00           H  
ATOM   1908 HH11 ARG A 132     -27.532 -36.217   4.805  1.00  0.00           H  
ATOM   1909 HH12 ARG A 132     -28.911 -36.324   3.745  1.00  0.00           H  
ATOM   1910 HH21 ARG A 132     -31.048 -37.539   6.141  1.00  0.00           H  
ATOM   1911 HH22 ARG A 132     -30.835 -37.064   4.483  1.00  0.00           H  
ATOM   1912  N   ALA A 133     -24.434 -33.616  10.836  1.00  0.00           N  
ATOM   1913  CA  ALA A 133     -24.232 -32.434  11.649  1.00  0.00           C  
ATOM   1914  C   ALA A 133     -25.116 -31.270  11.164  1.00  0.00           C  
ATOM   1915  O   ALA A 133     -24.751 -30.513  10.268  1.00  0.00           O  
ATOM   1916  CB  ALA A 133     -22.733 -32.140  11.759  1.00  0.00           C  
ATOM   1917  H   ALA A 133     -24.918 -34.378  11.290  1.00  0.00           H  
ATOM   1918  HA  ALA A 133     -24.558 -32.683  12.660  1.00  0.00           H  
ATOM   1919  HB1 ALA A 133     -22.566 -31.420  12.555  1.00  0.00           H  
ATOM   1920  HB2 ALA A 133     -22.191 -33.051  12.013  1.00  0.00           H  
ATOM   1921  HB3 ALA A 133     -22.352 -31.749  10.818  1.00  0.00           H  
ATOM   1922  N   MET A 134     -26.314 -31.139  11.745  1.00  0.00           N  
ATOM   1923  CA  MET A 134     -27.194 -29.977  11.567  1.00  0.00           C  
ATOM   1924  C   MET A 134     -27.297 -29.208  12.883  1.00  0.00           C  
ATOM   1925  O   MET A 134     -28.310 -29.246  13.585  1.00  0.00           O  
ATOM   1926  CB  MET A 134     -28.551 -30.374  10.976  1.00  0.00           C  
ATOM   1927  CG  MET A 134     -29.319 -29.169  10.432  1.00  0.00           C  
ATOM   1928  SD  MET A 134     -30.753 -29.650   9.433  1.00  0.00           S  
ATOM   1929  CE  MET A 134     -30.918 -28.163   8.413  1.00  0.00           C  
ATOM   1930  H   MET A 134     -26.608 -31.845  12.403  1.00  0.00           H  
ATOM   1931  HA  MET A 134     -26.734 -29.297  10.849  1.00  0.00           H  
ATOM   1932  HB3 MET A 134     -29.162 -30.864  11.732  1.00  0.00           H  
ATOM   1933  HG3 MET A 134     -28.646 -28.586   9.802  1.00  0.00           H  
ATOM   1934  HE1 MET A 134     -31.711 -28.311   7.680  1.00  0.00           H  
ATOM   1935  HE2 MET A 134     -31.164 -27.307   9.042  1.00  0.00           H  
ATOM   1936  HE3 MET A 134     -29.981 -27.972   7.887  1.00  0.00           H  
ATOM   1937  N   LYS A 135     -26.200 -28.524  13.216  1.00  0.00           N  
ATOM   1938  CA  LYS A 135     -26.182 -27.481  14.239  1.00  0.00           C  
ATOM   1939  C   LYS A 135     -25.619 -26.173  13.689  1.00  0.00           C  
ATOM   1940  O   LYS A 135     -25.014 -26.141  12.612  1.00  0.00           O  
ATOM   1941  CB  LYS A 135     -25.479 -27.980  15.519  1.00  0.00           C  
ATOM   1942  CG  LYS A 135     -23.959 -28.193  15.421  1.00  0.00           C  
ATOM   1943  CD  LYS A 135     -23.552 -29.672  15.491  1.00  0.00           C  
ATOM   1944  CE  LYS A 135     -22.019 -29.785  15.561  1.00  0.00           C  
ATOM   1945  NZ  LYS A 135     -21.579 -30.874  16.478  1.00  0.00           N  
ATOM   1946  H   LYS A 135     -25.383 -28.595  12.617  1.00  0.00           H  
ATOM   1947  HA  LYS A 135     -27.212 -27.253  14.504  1.00  0.00           H  
ATOM   1948  HB3 LYS A 135     -25.965 -28.898  15.853  1.00  0.00           H  
ATOM   1949  HG3 LYS A 135     -23.492 -27.673  16.263  1.00  0.00           H  
ATOM   1950  HD3 LYS A 135     -23.921 -30.203  14.612  1.00  0.00           H  
ATOM   1951  HE3 LYS A 135     -21.612 -28.835  15.916  1.00  0.00           H  
ATOM   1952  HZ1 LYS A 135     -20.567 -30.935  16.514  1.00  0.00           H  
ATOM   1953  HZ2 LYS A 135     -21.900 -30.706  17.422  1.00  0.00           H  
ATOM   1954  HZ3 LYS A 135     -21.929 -31.777  16.183  1.00  0.00           H  
ATOM   1955  N   ILE A 136     -25.817 -25.100  14.444  1.00  0.00           N  
ATOM   1956  CA  ILE A 136     -25.278 -23.771  14.154  1.00  0.00           C  
ATOM   1957  C   ILE A 136     -24.433 -23.297  15.334  1.00  0.00           C  
ATOM   1958  O   ILE A 136     -24.669 -23.674  16.483  1.00  0.00           O  
ATOM   1959  CB  ILE A 136     -26.368 -22.749  13.709  1.00  0.00           C  
ATOM   1960  CG1 ILE A 136     -26.958 -21.852  14.825  1.00  0.00           C  
ATOM   1961  CG2 ILE A 136     -27.518 -23.415  12.920  1.00  0.00           C  
ATOM   1962  CD1 ILE A 136     -26.319 -20.468  14.966  1.00  0.00           C  
ATOM   1963  H   ILE A 136     -26.346 -25.230  15.300  1.00  0.00           H  
ATOM   1964  HA  ILE A 136     -24.590 -23.872  13.317  1.00  0.00           H  
ATOM   1965  HB  ILE A 136     -25.885 -22.075  13.012  1.00  0.00           H  
ATOM   1966 HG13 ILE A 136     -26.875 -22.360  15.787  1.00  0.00           H  
ATOM   1967 HG21 ILE A 136     -27.112 -24.013  12.102  1.00  0.00           H  
ATOM   1968 HG22 ILE A 136     -28.123 -24.052  13.566  1.00  0.00           H  
ATOM   1969 HG23 ILE A 136     -28.163 -22.648  12.490  1.00  0.00           H  
ATOM   1970 HD11 ILE A 136     -26.753 -19.967  15.827  1.00  0.00           H  
ATOM   1971 HD12 ILE A 136     -25.246 -20.529  15.107  1.00  0.00           H  
ATOM   1972 HD13 ILE A 136     -26.532 -19.871  14.083  1.00  0.00           H  
ATOM   1973  N   LEU A 137     -23.459 -22.446  15.034  1.00  0.00           N  
ATOM   1974  CA  LEU A 137     -22.587 -21.783  15.997  1.00  0.00           C  
ATOM   1975  C   LEU A 137     -22.502 -20.300  15.607  1.00  0.00           C  
ATOM   1976  O   LEU A 137     -22.353 -19.953  14.431  1.00  0.00           O  
ATOM   1977  CB  LEU A 137     -21.240 -22.550  16.041  1.00  0.00           C  
ATOM   1978  CG  LEU A 137     -19.941 -21.727  16.111  1.00  0.00           C  
ATOM   1979  CD1 LEU A 137     -19.702 -21.042  17.456  1.00  0.00           C  
ATOM   1980  CD2 LEU A 137     -18.738 -22.649  15.896  1.00  0.00           C  
ATOM   1981  H   LEU A 137     -23.345 -22.188  14.064  1.00  0.00           H  
ATOM   1982  HA  LEU A 137     -23.033 -21.841  16.994  1.00  0.00           H  
ATOM   1983  HB3 LEU A 137     -21.170 -23.181  15.155  1.00  0.00           H  
ATOM   1984  HG  LEU A 137     -19.936 -20.981  15.319  1.00  0.00           H  
ATOM   1985 HD11 LEU A 137     -20.516 -20.373  17.711  1.00  0.00           H  
ATOM   1986 HD12 LEU A 137     -19.605 -21.787  18.245  1.00  0.00           H  
ATOM   1987 HD13 LEU A 137     -18.782 -20.463  17.407  1.00  0.00           H  
ATOM   1988 HD21 LEU A 137     -17.812 -22.073  15.951  1.00  0.00           H  
ATOM   1989 HD22 LEU A 137     -18.729 -23.429  16.660  1.00  0.00           H  
ATOM   1990 HD23 LEU A 137     -18.803 -23.098  14.906  1.00  0.00           H  
ATOM   1991  N   MET A 138     -22.628 -19.435  16.611  1.00  0.00           N  
ATOM   1992  CA  MET A 138     -22.518 -17.977  16.534  1.00  0.00           C  
ATOM   1993  C   MET A 138     -21.390 -17.521  17.478  1.00  0.00           C  
ATOM   1994  O   MET A 138     -21.565 -17.577  18.695  1.00  0.00           O  
ATOM   1995  CB  MET A 138     -23.870 -17.342  16.933  1.00  0.00           C  
ATOM   1996  CG  MET A 138     -24.718 -16.949  15.724  1.00  0.00           C  
ATOM   1997  SD  MET A 138     -26.166 -15.919  16.095  1.00  0.00           S  
ATOM   1998  CE  MET A 138     -27.450 -17.181  16.257  1.00  0.00           C  
ATOM   1999  H   MET A 138     -22.836 -19.826  17.523  1.00  0.00           H  
ATOM   2000  HA  MET A 138     -22.263 -17.671  15.516  1.00  0.00           H  
ATOM   2001  HB3 MET A 138     -23.698 -16.446  17.530  1.00  0.00           H  
ATOM   2002  HG3 MET A 138     -25.043 -17.853  15.218  1.00  0.00           H  
ATOM   2003  HE1 MET A 138     -28.395 -16.706  16.525  1.00  0.00           H  
ATOM   2004  HE2 MET A 138     -27.574 -17.699  15.306  1.00  0.00           H  
ATOM   2005  HE3 MET A 138     -27.177 -17.898  17.031  1.00  0.00           H  
ATOM   2006  N   LYS A 139     -20.254 -17.064  16.924  1.00  0.00           N  
ATOM   2007  CA  LYS A 139     -19.091 -16.555  17.678  1.00  0.00           C  
ATOM   2008  C   LYS A 139     -18.994 -15.027  17.578  1.00  0.00           C  
ATOM   2009  O   LYS A 139     -18.734 -14.492  16.500  1.00  0.00           O  
ATOM   2010  CB  LYS A 139     -17.811 -17.246  17.157  1.00  0.00           C  
ATOM   2011  CG  LYS A 139     -16.522 -16.751  17.856  1.00  0.00           C  
ATOM   2012  CD  LYS A 139     -15.499 -16.140  16.882  1.00  0.00           C  
ATOM   2013  CE  LYS A 139     -14.688 -17.216  16.140  1.00  0.00           C  
ATOM   2014  NZ  LYS A 139     -13.312 -17.358  16.694  1.00  0.00           N  
ATOM   2015  H   LYS A 139     -20.195 -17.067  15.914  1.00  0.00           H  
ATOM   2016  HA  LYS A 139     -19.198 -16.816  18.731  1.00  0.00           H  
ATOM   2017  HB3 LYS A 139     -17.735 -17.094  16.080  1.00  0.00           H  
ATOM   2018  HG3 LYS A 139     -16.056 -17.581  18.389  1.00  0.00           H  
ATOM   2019  HD3 LYS A 139     -14.824 -15.485  17.436  1.00  0.00           H  
ATOM   2020  HE3 LYS A 139     -14.630 -16.945  15.082  1.00  0.00           H  
ATOM   2021  HZ1 LYS A 139     -12.807 -18.102  16.230  1.00  0.00           H  
ATOM   2022  HZ2 LYS A 139     -12.778 -16.507  16.563  1.00  0.00           H  
ATOM   2023  HZ3 LYS A 139     -13.327 -17.565  17.682  1.00  0.00           H  
ATOM   2024  N   VAL A 140     -19.148 -14.340  18.711  1.00  0.00           N  
ATOM   2025  CA  VAL A 140     -18.977 -12.885  18.870  1.00  0.00           C  
ATOM   2026  C   VAL A 140     -18.300 -12.579  20.214  1.00  0.00           C  
ATOM   2027  O   VAL A 140     -18.913 -12.633  21.282  1.00  0.00           O  
ATOM   2028  CB  VAL A 140     -20.304 -12.115  18.664  1.00  0.00           C  
ATOM   2029  CG1 VAL A 140     -21.505 -12.665  19.445  1.00  0.00           C  
ATOM   2030  CG2 VAL A 140     -20.152 -10.607  18.894  1.00  0.00           C  
ATOM   2031  H   VAL A 140     -19.401 -14.865  19.539  1.00  0.00           H  
ATOM   2032  HA  VAL A 140     -18.302 -12.530  18.089  1.00  0.00           H  
ATOM   2033  HB  VAL A 140     -20.551 -12.200  17.615  1.00  0.00           H  
ATOM   2034 HG11 VAL A 140     -21.674 -13.710  19.195  1.00  0.00           H  
ATOM   2035 HG12 VAL A 140     -21.341 -12.576  20.517  1.00  0.00           H  
ATOM   2036 HG13 VAL A 140     -22.402 -12.106  19.183  1.00  0.00           H  
ATOM   2037 HG21 VAL A 140     -21.120 -10.119  18.777  1.00  0.00           H  
ATOM   2038 HG22 VAL A 140     -19.766 -10.405  19.889  1.00  0.00           H  
ATOM   2039 HG23 VAL A 140     -19.465 -10.194  18.157  1.00  0.00           H  
ATOM   2040  N   GLY A 141     -17.007 -12.263  20.151  1.00  0.00           N  
ATOM   2041  CA  GLY A 141     -16.178 -11.824  21.280  1.00  0.00           C  
ATOM   2042  C   GLY A 141     -15.983 -10.302  21.248  1.00  0.00           C  
ATOM   2043  O   GLY A 141     -16.968  -9.561  21.191  1.00  0.00           O  
ATOM   2044  H   GLY A 141     -16.575 -12.250  19.237  1.00  0.00           H  
ATOM   2045  HA2 GLY A 141     -16.635 -12.100  22.230  1.00  0.00           H  
ATOM   2046  N   GLN A 142     -14.722  -9.847  21.254  1.00  0.00           N  
ATOM   2047  CA  GLN A 142     -14.305  -8.448  21.024  1.00  0.00           C  
ATOM   2048  C   GLN A 142     -14.940  -7.811  19.774  1.00  0.00           C  
ATOM   2049  O   GLN A 142     -15.425  -6.658  19.877  1.00  0.00           O  
ATOM   2050  CB  GLN A 142     -12.765  -8.407  20.952  1.00  0.00           C  
ATOM   2051  CG  GLN A 142     -12.139  -8.321  22.357  1.00  0.00           C  
ATOM   2052  CD  GLN A 142     -10.696  -8.841  22.465  1.00  0.00           C  
ATOM   2053  OE1 GLN A 142     -10.114  -9.415  21.553  1.00  0.00           O  
ATOM   2054  NE2 GLN A 142     -10.057  -8.681  23.607  1.00  0.00           N  
ATOM   2055  H   GLN A 142     -13.991 -10.540  21.295  1.00  0.00           H  
ATOM   2056  HA  GLN A 142     -14.628  -7.844  21.874  1.00  0.00           H  
ATOM   2057  HB3 GLN A 142     -12.450  -7.534  20.376  1.00  0.00           H  
ATOM   2058  HG3 GLN A 142     -12.748  -8.883  23.066  1.00  0.00           H  
ATOM   2059 HE21 GLN A 142     -10.506  -8.213  24.378  1.00  0.00           H  
ATOM   2060 HE22 GLN A 142      -9.122  -9.056  23.690  1.00  0.00           H  
TER    2061      GLN A 142                                                      
END
MOLECULE T0390.pdb
ATOM   1417  N   ALA    29     -25.126  -7.662   1.817  1.00100.22           N  
ATOM   1418  CA  ALA    29     -24.203  -6.752   2.561  1.00102.70           C  
ATOM   1419  CB  ALA    29     -24.370  -5.286   2.082  1.00105.39           C  
ATOM   1420  C   ALA    29     -24.440  -6.859   4.069  1.00100.61           C  
ATOM   1421  O   ALA    29     -23.542  -6.584   4.874  1.00103.55           O  
ATOM   1422  N   ASP    30     -25.642  -7.297   4.438  1.00 95.26           N  
ATOM   1423  CA  ASP    30     -26.174  -7.076   5.775  1.00 90.56           C  
ATOM   1424  CB  ASP    30     -27.168  -5.921   5.687  1.00 92.74           C  
ATOM   1425  CG  ASP    30     -27.589  -5.421   7.032  1.00 94.90           C  
ATOM   1426  OD1 ASP    30     -26.753  -5.488   7.957  1.00 97.71           O  
ATOM   1427  OD2 ASP    30     -28.748  -4.962   7.166  1.00 95.01           O  
ATOM   1428  C   ASP    30     -26.877  -8.312   6.349  1.00 85.08           C  
ATOM   1429  O   ASP    30     -26.918  -8.504   7.567  1.00 84.01           O  
ATOM   1430  N   ARG    31     -27.450  -9.130   5.464  1.00 79.52           N  
ATOM   1431  CA  ARG    31     -28.160 -10.341   5.860  1.00 73.24           C  
ATOM   1432  CB  ARG    31     -29.676 -10.248   5.558  1.00 73.02           C  
ATOM   1433  CG  ARG    31     -30.128  -9.281   4.458  1.00 71.63           C  
ATOM   1434  CD  ARG    31     -31.576  -8.824   4.658  1.00 70.77           C  
ATOM   1435  NE  ARG    31     -32.323  -9.800   5.444  1.00 70.30           N  
ATOM   1436  CZ  ARG    31     -33.224  -9.495   6.379  1.00 69.91           C  
ATOM   1437  NH1 ARG    31     -33.825 -10.465   7.068  1.00 64.29           N  
ATOM   1438  NH2 ARG    31     -33.513  -8.226   6.639  1.00 66.83           N  
ATOM   1439  C   ARG    31     -27.541 -11.632   5.309  1.00 70.84           C  
ATOM   1440  O   ARG    31     -27.034 -11.668   4.203  1.00 72.53           O  
ATOM   1441  N   HIS    32     -27.579 -12.687   6.107  1.00 67.66           N  
ATOM   1442  CA  HIS    32     -26.995 -13.968   5.743  1.00 65.70           C  
ATOM   1443  CB  HIS    32     -26.038 -14.432   6.839  1.00 64.57           C  
ATOM   1444  CG  HIS    32     -25.079 -13.377   7.294  1.00 65.98           C  
ATOM   1445  ND1 HIS    32     -23.753 -13.361   6.918  1.00 68.45           N  
ATOM   1446  CE1 HIS    32     -23.147 -12.327   7.473  1.00 68.52           C  
ATOM   1447  NE2 HIS    32     -24.034 -11.668   8.197  1.00 70.63           N  
ATOM   1448  CD2 HIS    32     -25.247 -12.309   8.110  1.00 68.60           C  
ATOM   1449  C   HIS    32     -28.097 -15.016   5.529  1.00 64.32           C  
ATOM   1450  O   HIS    32     -29.034 -15.140   6.326  1.00 64.73           O  
ATOM   1451  N   THR    33     -27.991 -15.763   4.443  1.00 64.18           N  
ATOM   1452  CA  THR    33     -29.026 -16.716   4.069  1.00 61.66           C  
ATOM   1453  CB  THR    33     -29.371 -16.572   2.588  1.00 60.48           C  
ATOM   1454  OG1 THR    33     -29.757 -15.222   2.336  1.00 64.06           O  
ATOM   1455  CG2 THR    33     -30.515 -17.473   2.204  1.00 60.36           C  
ATOM   1456  C   THR    33     -28.563 -18.133   4.345  1.00 60.90           C  
ATOM   1457  O   THR    33     -27.470 -18.523   3.937  1.00 61.38           O  
ATOM   1458  N   VAL    34     -29.394 -18.893   5.050  1.00 59.79           N  
ATOM   1459  CA  VAL    34     -29.129 -20.304   5.279  1.00 58.71           C  
ATOM   1460  CB  VAL    34     -28.924 -20.615   6.781  1.00 58.54           C  
ATOM   1461  CG1 VAL    34     -28.753 -22.122   7.003  1.00 54.88           C  
ATOM   1462  CG2 VAL    34     -27.724 -19.842   7.322  1.00 58.10           C  
ATOM   1463  C   VAL    34     -30.292 -21.119   4.737  1.00 58.02           C  
ATOM   1464  O   VAL    34     -31.439 -20.929   5.132  1.00 57.92           O  
ATOM   1465  N   PHE    35     -29.997 -22.021   3.816  1.00 58.93           N  
ATOM   1466  CA  PHE    35     -31.014 -22.945   3.330  1.00 57.38           C  
ATOM   1467  CB  PHE    35     -30.754 -23.313   1.873  1.00 56.05           C  
ATOM   1468  CG  PHE    35     -30.974 -22.168   0.935  1.00 57.38           C  
ATOM   1469  CD1 PHE    35     -29.944 -21.264   0.661  1.00 58.82           C  
ATOM   1470  CE1 PHE    35     -30.149 -20.180  -0.191  1.00 57.97           C  
ATOM   1471  CZ  PHE    35     -31.402 -19.989  -0.771  1.00 58.81           C  
ATOM   1472  CE2 PHE    35     -32.447 -20.877  -0.492  1.00 56.51           C  
ATOM   1473  CD2 PHE    35     -32.230 -21.953   0.363  1.00 58.39           C  
ATOM   1474  C   PHE    35     -31.087 -24.155   4.248  1.00 58.31           C  
ATOM   1475  O   PHE    35     -30.221 -25.039   4.194  1.00 59.87           O  
ATOM   1476  N   TRP    36     -32.103 -24.175   5.118  1.00 56.23           N  
ATOM   1477  CA  TRP    36     -32.240 -25.269   6.062  1.00 54.10           C  
ATOM   1478  CB  TRP    36     -33.030 -24.851   7.307  1.00 52.43           C  
ATOM   1479  CG  TRP    36     -32.664 -25.690   8.480  1.00 50.06           C  
ATOM   1480  CD1 TRP    36     -33.078 -26.955   8.722  1.00 50.33           C  
ATOM   1481  NE1 TRP    36     -32.518 -27.428   9.883  1.00 54.82           N  
ATOM   1482  CE2 TRP    36     -31.709 -26.461  10.418  1.00 54.47           C  
ATOM   1483  CD2 TRP    36     -31.769 -25.344   9.551  1.00 52.76           C  
ATOM   1484  CE3 TRP    36     -31.039 -24.192   9.881  1.00 53.93           C  
ATOM   1485  CZ3 TRP    36     -30.269 -24.199  11.060  1.00 53.49           C  
ATOM   1486  CH2 TRP    36     -30.216 -25.339  11.891  1.00 51.75           C  
ATOM   1487  CZ2 TRP    36     -30.924 -26.476  11.588  1.00 51.62           C  
ATOM   1488  C   TRP    36     -32.884 -26.471   5.415  1.00 54.79           C  
ATOM   1489  O   TRP    36     -34.088 -26.652   5.506  1.00 55.66           O  
ATOM   1490  N   ASN    37     -32.095 -27.299   4.748  1.00 57.05           N  
ATOM   1491  CA  ASN    37     -32.637 -28.573   4.245  1.00 59.69           C  
ATOM   1492  CB  ASN    37     -33.492 -28.399   2.962  1.00 59.25           C  
ATOM   1493  CG  ASN    37     -32.663 -28.102   1.708  1.00 63.24           C  
ATOM   1494  OD1 ASN    37     -31.855 -28.934   1.251  1.00 65.74           O  
ATOM   1495  ND2 ASN    37     -32.895 -26.924   1.119  1.00 67.21           N  
ATOM   1496  C   ASN    37     -31.539 -29.627   4.114  1.00 60.96           C  
ATOM   1497  O   ASN    37     -30.354 -29.274   4.027  1.00 62.64           O  
ATOM   1498  N   SER    38     -31.916 -30.903   4.110  1.00 60.38           N  
ATOM   1499  CA  SER    38     -30.911 -31.965   4.214  1.00 63.35           C  
ATOM   1500  CB  SER    38     -31.532 -33.268   4.692  1.00 64.11           C  
ATOM   1501  OG  SER    38     -32.155 -33.900   3.602  1.00 70.02           O  
ATOM   1502  C   SER    38     -30.080 -32.216   2.954  1.00 63.69           C  
ATOM   1503  O   SER    38     -29.178 -33.033   2.998  1.00 63.92           O  
ATOM   1504  N   SER    39     -30.385 -31.519   1.856  1.00 63.86           N  
ATOM   1505  CA  SER    39     -29.558 -31.551   0.639  1.00 64.78           C  
ATOM   1506  CB  SER    39     -30.398 -31.342  -0.618  1.00 63.72           C  
ATOM   1507  OG  SER    39     -31.246 -32.437  -0.826  1.00 67.02           O  
ATOM   1508  C   SER    39     -28.510 -30.464   0.641  1.00 64.68           C  
ATOM   1509  O   SER    39     -27.688 -30.405  -0.267  1.00 68.02           O  
ATOM   1510  N   ASN    40     -28.573 -29.562   1.611  1.00 62.24           N  
ATOM   1511  CA  ASN    40     -27.614 -28.481   1.656  1.00 61.94           C  
ATOM   1512  CB  ASN    40     -28.096 -27.368   2.590  1.00 59.83           C  
ATOM   1513  CG  ASN    40     -27.194 -26.152   2.559  1.00 59.19           C  
ATOM   1514  OD1 ASN    40     -26.036 -26.220   2.101  1.00 59.05           O  
ATOM   1515  ND2 ASN    40     -27.716 -25.020   3.038  1.00 52.18           N  
ATOM   1516  C   ASN    40     -26.279 -29.030   2.130  1.00 62.98           C  
ATOM   1517  O   ASN    40     -26.143 -29.337   3.314  1.00 65.11           O  
ATOM   1518  N   PRO    41     -25.284 -29.124   1.226  1.00 63.55           N  
ATOM   1519  CA  PRO    41     -24.003 -29.741   1.548  1.00 64.85           C  
ATOM   1520  CB  PRO    41     -23.161 -29.492   0.286  1.00 66.12           C  
ATOM   1521  CG  PRO    41     -24.138 -29.321  -0.799  1.00 65.91           C  
ATOM   1522  CD  PRO    41     -25.298 -28.614  -0.158  1.00 64.70           C  
ATOM   1523  C   PRO    41     -23.309 -29.122   2.757  1.00 65.52           C  
ATOM   1524  O   PRO    41     -22.517 -29.791   3.419  1.00 66.69           O  
ATOM   1525  N   LYS    42     -23.600 -27.861   3.053  1.00 62.16           N  
ATOM   1526  CA  LYS    42     -22.900 -27.169   4.135  1.00 64.34           C  
ATOM   1527  CB  LYS    42     -23.244 -25.682   4.133  1.00 63.63           C  
ATOM   1528  CG  LYS    42     -22.820 -25.020   2.851  1.00 62.79           C  
ATOM   1529  CD  LYS    42     -22.705 -23.542   3.001  1.00 64.18           C  
ATOM   1530  CE  LYS    42     -22.140 -22.977   1.727  1.00 68.95           C  
ATOM   1531  NZ  LYS    42     -22.825 -21.712   1.400  1.00 74.60           N  
ATOM   1532  C   LYS    42     -23.112 -27.783   5.511  1.00 65.92           C  
ATOM   1533  O   LYS    42     -22.289 -27.611   6.401  1.00 68.21           O  
ATOM   1534  N   PHE    43     -24.204 -28.528   5.656  1.00 67.42           N  
ATOM   1535  CA  PHE    43     -24.552 -29.227   6.882  1.00 69.26           C  
ATOM   1536  CB  PHE    43     -26.053 -29.547   6.881  1.00 68.78           C  
ATOM   1537  CG  PHE    43     -26.924 -28.367   7.194  1.00 70.15           C  
ATOM   1538  CD1 PHE    43     -26.880 -27.767   8.448  1.00 70.44           C  
ATOM   1539  CE1 PHE    43     -27.676 -26.680   8.742  1.00 72.10           C  
ATOM   1540  CZ  PHE    43     -28.537 -26.175   7.786  1.00 70.06           C  
ATOM   1541  CE2 PHE    43     -28.591 -26.758   6.534  1.00 70.66           C  
ATOM   1542  CD2 PHE    43     -27.787 -27.853   6.240  1.00 69.34           C  
ATOM   1543  C   PHE    43     -23.773 -30.525   7.054  1.00 72.65           C  
ATOM   1544  O   PHE    43     -23.779 -31.128   8.144  1.00 74.80           O  
ATOM   1545  N   ARG    44     -23.136 -30.972   5.972  1.00 73.67           N  
ATOM   1546  CA  ARG    44     -22.502 -32.284   5.941  1.00 77.35           C  
ATOM   1547  CB  ARG    44     -22.077 -32.683   4.518  1.00 77.02           C  
ATOM   1548  CG  ARG    44     -21.282 -33.978   4.439  1.00 80.74           C  
ATOM   1549  CD  ARG    44     -21.486 -34.745   3.146  1.00 81.73           C  
ATOM   1550  NE  ARG    44     -21.030 -33.978   1.996  1.00 76.92           N  
ATOM   1551  CZ  ARG    44     -21.830 -33.528   1.042  1.00 71.12           C  
ATOM   1552  NH1 ARG    44     -23.122 -33.781   1.075  1.00 65.89           N  
ATOM   1553  NH2 ARG    44     -21.329 -32.832   0.046  1.00 73.50           N  
ATOM   1554  C   ARG    44     -21.350 -32.397   6.936  1.00 81.28           C  
ATOM   1555  O   ARG    44     -21.137 -33.462   7.494  1.00 84.45           O  
ATOM   1556  N   ASN    45     -20.623 -31.320   7.196  1.00 83.31           N  
ATOM   1557  CA  ASN    45     -19.516 -31.458   8.129  1.00 89.14           C  
ATOM   1558  CB  ASN    45     -18.325 -30.589   7.706  1.00 90.67           C  
ATOM   1562  C   ASN    45     -19.916 -31.277   9.611  1.00 91.62           C  
ATOM   1563  O   ASN    45     -19.147 -31.615  10.520  1.00 93.86           O  
ATOM   1564  N   GLU    46     -21.134 -30.775   9.842  1.00 91.09           N  
ATOM   1565  CA  GLU    46     -21.671 -30.506  11.198  1.00 92.01           C  
ATOM   1566  CB  GLU    46     -21.888 -31.807  11.993  1.00 94.29           C  
ATOM   1567  CG  GLU    46     -22.673 -32.872  11.210  1.00 95.61           C  
ATOM   1568  CD  GLU    46     -23.036 -34.121  12.024  1.00 99.79           C  
ATOM   1569  OE1 GLU    46     -22.526 -34.300  13.160  1.00103.61           O  
ATOM   1570  OE2 GLU    46     -23.840 -34.935  11.507  1.00101.22           O  
ATOM   1571  C   GLU    46     -20.797 -29.487  11.942  1.00 91.41           C  
ATOM   1572  O   GLU    46     -20.872 -29.328  13.166  1.00 92.29           O  
ATOM   1573  N   ASP    47     -19.977 -28.798  11.151  1.00 89.12           N  
ATOM   1574  CA  ASP    47     -19.143 -27.686  11.586  1.00 87.14           C  
ATOM   1575  CB  ASP    47     -17.695 -27.903  11.124  1.00 89.68           C  
ATOM   1576  CG  ASP    47     -17.562 -28.039   9.587  1.00 90.74           C  
ATOM   1577  OD1 ASP    47     -18.585 -28.119   8.855  1.00 86.38           O  
ATOM   1578  OD2 ASP    47     -16.405 -28.084   9.107  1.00 97.26           O  
ATOM   1579  C   ASP    47     -19.679 -26.375  10.998  1.00 82.03           C  
ATOM   1580  O   ASP    47     -19.103 -25.319  11.209  1.00 81.44           O  
ATOM   1581  N   TYR    48     -20.770 -26.462  10.242  1.00 77.20           N  
ATOM   1582  CA  TYR    48     -21.382 -25.302   9.609  1.00 74.21           C  
ATOM   1583  CB  TYR    48     -22.776 -25.676   9.067  1.00 73.30           C  
ATOM   1584  CG  TYR    48     -23.420 -24.667   8.120  1.00 71.47           C  
ATOM   1585  CD1 TYR    48     -24.744 -24.834   7.695  1.00 70.66           C  
ATOM   1586  CE1 TYR    48     -25.343 -23.923   6.819  1.00 68.10           C  
ATOM   1587  CZ  TYR    48     -24.620 -22.830   6.373  1.00 68.15           C  
ATOM   1588  OH  TYR    48     -25.197 -21.932   5.519  1.00 67.00           O  
ATOM   1589  CE2 TYR    48     -23.306 -22.637   6.772  1.00 68.50           C  
ATOM   1590  CD2 TYR    48     -22.712 -23.550   7.644  1.00 70.49           C  
ATOM   1591  C   TYR    48     -21.477 -24.102  10.558  1.00 73.61           C  
ATOM   1592  O   TYR    48     -22.263 -24.101  11.524  1.00 75.01           O  
ATOM   1593  N   THR    49     -20.664 -23.088  10.297  1.00 70.93           N  
ATOM   1594  CA  THR    49     -20.736 -21.870  11.090  1.00 69.64           C  
ATOM   1595  CB  THR    49     -19.715 -21.855  12.277  1.00 71.04           C  
ATOM   1596  OG1 THR    49     -19.033 -20.605  12.302  1.00 71.14           O  
ATOM   1597  CG2 THR    49     -18.697 -22.930  12.166  1.00 68.82           C  
ATOM   1598  C   THR    49     -20.658 -20.593  10.240  1.00 67.14           C  
ATOM   1599  O   THR    49     -19.863 -20.517   9.341  1.00 65.65           O  
ATOM   1600  N   ILE    50     -21.514 -19.613  10.523  1.00 66.24           N  
ATOM   1601  CA  ILE    50     -21.489 -18.336   9.811  1.00 64.98           C  
ATOM   1602  CB  ILE    50     -22.823 -18.008   9.090  1.00 65.33           C  
ATOM   1603  CG1 ILE    50     -23.910 -17.657  10.099  1.00 65.90           C  
ATOM   1604  CD1 ILE    50     -25.306 -17.700   9.521  1.00 73.93           C  
ATOM   1605  CG2 ILE    50     -23.256 -19.148   8.131  1.00 61.42           C  
ATOM   1606  C   ILE    50     -21.133 -17.213  10.787  1.00 65.67           C  
ATOM   1607  O   ILE    50     -21.490 -17.266  11.967  1.00 67.03           O  
ATOM   1608  N   HIS    51     -20.416 -16.212  10.284  1.00 64.25           N  
ATOM   1609  CA  HIS    51     -19.943 -15.105  11.084  1.00 63.60           C  
ATOM   1610  CB  HIS    51     -18.461 -14.901  10.835  1.00 65.49           C  
ATOM   1611  CG  HIS    51     -17.630 -16.088  11.195  1.00 70.79           C  
ATOM   1612  ND1 HIS    51     -16.951 -16.185  12.391  1.00 72.94           N  
ATOM   1613  CE1 HIS    51     -16.306 -17.337  12.435  1.00 74.97           C  
ATOM   1614  NE2 HIS    51     -16.554 -17.996  11.315  1.00 76.53           N  
ATOM   1615  CD2 HIS    51     -17.379 -17.236  10.521  1.00 73.32           C  
ATOM   1616  C   HIS    51     -20.703 -13.827  10.766  1.00 62.09           C  
ATOM   1617  O   HIS    51     -20.801 -13.415   9.603  1.00 61.03           O  
ATOM   1618  N   VAL    52     -21.230 -13.201  11.812  1.00 69.61           N  
ATOM   1619  CA  VAL    52     -22.065 -12.016  11.665  1.00 70.27           C  
ATOM   1620  CB  VAL    52     -23.525 -12.331  12.044  1.00 67.94           C  
ATOM   1621  CG1 VAL    52     -24.048 -13.516  11.256  1.00 63.91           C  
ATOM   1622  CG2 VAL    52     -23.629 -12.617  13.529  1.00 68.74           C  
ATOM   1623  C   VAL    52     -21.559 -10.871  12.551  1.00 73.22           C  
ATOM   1624  O   VAL    52     -20.790 -11.094  13.483  1.00 76.04           O  
ATOM   1625  N   GLN    53     -21.982  -9.646  12.255  1.00 74.46           N  
ATOM   1626  CA  GLN    53     -21.798  -8.534  13.178  1.00 75.33           C  
ATOM   1627  CB  GLN    53     -21.370  -7.303  12.422  1.00 77.79           C  
ATOM   1628  CG  GLN    53     -19.888  -7.222  12.255  1.00 84.78           C  
ATOM   1629  CD  GLN    53     -19.520  -6.296  11.150  1.00 89.93           C  
ATOM   1630  OE1 GLN    53     -18.901  -5.262  11.383  1.00 95.34           O  
ATOM   1631  NE2 GLN    53     -19.918  -6.641   9.926  1.00 90.84           N  
ATOM   1632  C   GLN    53     -23.100  -8.246  13.889  1.00 73.89           C  
ATOM   1633  O   GLN    53     -24.169  -8.667  13.432  1.00 71.87           O  
ATOM   1634  N   LEU    54     -23.025  -7.517  15.000  1.00 73.96           N  
ATOM   1635  CA  LEU    54     -24.246  -7.075  15.664  1.00 71.54           C  
ATOM   1636  CB  LEU    54     -23.954  -6.115  16.806  1.00 71.37           C  
ATOM   1637  CG  LEU    54     -23.720  -6.645  18.210  1.00 72.19           C  
ATOM   1638  CD1 LEU    54     -23.657  -5.431  19.127  1.00 73.28           C  
ATOM   1639  CD2 LEU    54     -24.804  -7.628  18.678  1.00 67.76           C  
ATOM   1640  C   LEU    54     -25.153  -6.381  14.666  1.00 70.96           C  
ATOM   1641  O   LEU    54     -24.707  -5.548  13.849  1.00 71.38           O  
ATOM   1642  N   ASN    55     -26.428  -6.742  14.736  1.00 69.55           N  
ATOM   1643  CA  ASN    55     -27.474  -6.128  13.911  1.00 69.72           C  
ATOM   1644  CB  ASN    55     -27.358  -4.594  13.915  1.00 68.97           C  
ATOM   1645  CG  ASN    55     -27.478  -3.990  15.318  1.00 68.73           C  
ATOM   1646  OD1 ASN    55     -28.078  -4.564  16.239  1.00 67.86           O  
ATOM   1647  ND2 ASN    55     -26.916  -2.809  15.474  1.00 63.22           N  
ATOM   1648  C   ASN    55     -27.554  -6.673  12.476  1.00 68.55           C  
ATOM   1649  O   ASN    55     -28.342  -6.181  11.669  1.00 70.93           O  
ATOM   1650  N   ASP    56     -26.726  -7.665  12.166  1.00 66.57           N  
ATOM   1651  CA  ASP    56     -26.859  -8.418  10.942  1.00 65.55           C  
ATOM   1652  CB  ASP    56     -25.652  -9.322  10.761  1.00 65.62           C  
ATOM   1653  CG  ASP    56     -24.514  -8.651  10.026  1.00 68.09           C  
ATOM   1654  OD1 ASP    56     -24.612  -7.445   9.702  1.00 66.77           O  
ATOM   1655  OD2 ASP    56     -23.516  -9.357   9.761  1.00 67.96           O  
ATOM   1656  C   ASP    56     -28.089  -9.293  11.110  1.00 65.11           C  
ATOM   1657  O   ASP    56     -28.506  -9.552  12.236  1.00 66.56           O  
ATOM   1658  N   TYR    57     -28.674  -9.730  10.000  1.00 63.82           N  
ATOM   1659  CA  TYR    57     -29.793 -10.661  10.019  1.00 60.75           C  
ATOM   1660  CB  TYR    57     -30.909 -10.165   9.111  1.00 60.51           C  
ATOM   1661  CG  TYR    57     -31.478  -8.826   9.488  1.00 60.28           C  
ATOM   1662  CD1 TYR    57     -30.823  -7.665   9.124  1.00 59.46           C  
ATOM   1663  CE1 TYR    57     -31.331  -6.431   9.445  1.00 61.40           C  
ATOM   1664  CZ  TYR    57     -32.522  -6.335  10.141  1.00 63.64           C  
ATOM   1665  OH  TYR    57     -32.970  -5.069  10.441  1.00 64.74           O  
ATOM   1666  CE2 TYR    57     -33.214  -7.481  10.538  1.00 56.59           C  
ATOM   1667  CD2 TYR    57     -32.685  -8.721  10.207  1.00 56.20           C  
ATOM   1668  C   TYR    57     -29.340 -12.004   9.493  1.00 61.12           C  
ATOM   1669  O   TYR    57     -28.496 -12.082   8.592  1.00 62.46           O  
ATOM   1670  N   VAL    58     -29.890 -13.064  10.059  1.00 60.56           N  
ATOM   1671  CA  VAL    58     -29.754 -14.388   9.476  1.00 61.46           C  
ATOM   1672  CB  VAL    58     -29.112 -15.394  10.452  1.00 62.00           C  
ATOM   1673  CG1 VAL    58     -29.223 -16.821   9.915  1.00 62.86           C  
ATOM   1674  CG2 VAL    58     -27.636 -15.015  10.717  1.00 63.40           C  
ATOM   1675  C   VAL    58     -31.146 -14.830   9.040  1.00 61.87           C  
ATOM   1676  O   VAL    58     -32.103 -14.802   9.834  1.00 61.13           O  
ATOM   1677  N   ASP    59     -31.259 -15.175   7.759  1.00 61.42           N  
ATOM   1678  CA  ASP    59     -32.509 -15.634   7.188  1.00 60.73           C  
ATOM   1679  CB  ASP    59     -32.779 -14.965   5.841  1.00 59.72           C  
ATOM   1680  CG  ASP    59     -33.157 -13.529   5.976  1.00 62.55           C  
ATOM   1681  OD1 ASP    59     -33.782 -13.172   6.996  1.00 64.16           O  
ATOM   1682  OD2 ASP    59     -32.827 -12.745   5.059  1.00 62.03           O  
ATOM   1683  C   ASP    59     -32.407 -17.135   7.001  1.00 61.61           C  
ATOM   1684  O   ASP    59     -31.683 -17.625   6.098  1.00 62.81           O  
ATOM   1685  N   ILE    60     -33.113 -17.875   7.851  1.00 60.05           N  
ATOM   1686  CA  ILE    60     -33.134 -19.316   7.706  1.00 58.69           C  
ATOM   1687  CB  ILE    60     -33.207 -20.005   9.061  1.00 58.77           C  
ATOM   1688  CG1 ILE    60     -31.917 -19.708   9.836  1.00 57.57           C  
ATOM   1689  CD1 ILE    60     -31.964 -20.141  11.282  1.00 62.49           C  
ATOM   1690  CG2 ILE    60     -33.386 -21.487   8.896  1.00 51.16           C  
ATOM   1691  C   ILE    60     -34.311 -19.610   6.811  1.00 59.83           C  
ATOM   1692  O   ILE    60     -35.418 -19.114   7.034  1.00 62.33           O  
ATOM   1693  N   ILE    61     -34.053 -20.361   5.753  1.00 59.42           N  
ATOM   1694  CA  ILE    61     -35.051 -20.588   4.715  1.00 57.99           C  
ATOM   1695  CB  ILE    61     -34.537 -20.065   3.359  1.00 58.11           C  
ATOM   1696  CG1 ILE    61     -34.261 -18.561   3.510  1.00 59.93           C  
ATOM   1697  CD1 ILE    61     -34.251 -17.783   2.223  1.00 68.98           C  
ATOM   1698  CG2 ILE    61     -35.531 -20.369   2.238  1.00 54.24           C  
ATOM   1699  C   ILE    61     -35.520 -22.048   4.711  1.00 57.94           C  
ATOM   1700  O   ILE    61     -34.737 -22.976   4.495  1.00 57.11           O  
ATOM   1701  N   CYS    62     -36.799 -22.234   5.020  1.00 57.55           N  
ATOM   1702  CA  CYS    62     -37.363 -23.561   5.162  1.00 57.79           C  
ATOM   1703  CB  CYS    62     -38.765 -23.461   5.742  1.00 58.68           C  
ATOM   1704  SG  CYS    62     -38.799 -22.883   7.422  1.00 66.56           S  
ATOM   1705  C   CYS    62     -37.433 -24.289   3.819  1.00 57.44           C  
ATOM   1706  O   CYS    62     -37.503 -23.648   2.745  1.00 55.57           O  
ATOM   1707  N   PRO    63     -37.446 -25.630   3.867  1.00 56.37           N  
ATOM   1708  CA  PRO    63     -37.635 -26.391   2.631  1.00 56.48           C  
ATOM   1709  CB  PRO    63     -37.788 -27.822   3.122  1.00 55.81           C  
ATOM   1710  CG  PRO    63     -37.139 -27.837   4.468  1.00 55.54           C  
ATOM   1711  CD  PRO    63     -37.321 -26.490   5.058  1.00 54.90           C  
ATOM   1712  C   PRO    63     -38.929 -25.913   1.958  1.00 57.83           C  
ATOM   1713  O   PRO    63     -39.911 -25.648   2.654  1.00 59.36           O  
ATOM   1714  N   HIS    64     -38.914 -25.745   0.638  1.00 58.32           N  
ATOM   1715  CA  HIS    64     -40.073 -25.230  -0.081  1.00 61.05           C  
ATOM   1716  CB  HIS    64     -40.011 -23.704  -0.172  1.00 61.33           C  
ATOM   1717  CG  HIS    64     -41.251 -23.101  -0.744  1.00 66.07           C  
ATOM   1718  ND1 HIS    64     -41.315 -22.614  -2.034  1.00 66.04           N  
ATOM   1719  CE1 HIS    64     -42.541 -22.187  -2.279  1.00 64.89           C  
ATOM   1720  NE2 HIS    64     -43.281 -22.399  -1.205  1.00 65.72           N  
ATOM   1721  CD2 HIS    64     -42.499 -22.973  -0.231  1.00 66.30           C  
ATOM   1722  C   HIS    64     -40.197 -25.864  -1.480  1.00 64.10           C  
ATOM   1723  O   HIS    64     -39.187 -26.138  -2.125  1.00 67.04           O  
ATOM   1724  N   TYR    65     -41.428 -26.104  -1.937  1.00 72.57           N  
ATOM   1725  CA  TYR    65     -41.699 -26.882  -3.156  1.00 76.38           C  
ATOM   1726  CB  TYR    65     -42.080 -28.311  -2.754  1.00 72.47           C  
ATOM   1727  CG  TYR    65     -41.120 -29.016  -1.817  1.00 70.31           C  
ATOM   1728  CD1 TYR    65     -40.185 -29.943  -2.306  1.00 67.92           C  
ATOM   1729  CE1 TYR    65     -39.299 -30.600  -1.441  1.00 63.29           C  
ATOM   1730  CZ  TYR    65     -39.348 -30.339  -0.074  1.00 63.03           C  
ATOM   1731  OH  TYR    65     -38.483 -30.981   0.779  1.00 63.79           O  
ATOM   1732  CE2 TYR    65     -40.263 -29.430   0.441  1.00 59.33           C  
ATOM   1733  CD2 TYR    65     -41.156 -28.783  -0.429  1.00 64.70           C  
ATOM   1734  C   TYR    65     -42.867 -26.320  -3.985  1.00 83.17           C  
ATOM   1735  O   TYR    65     -43.901 -25.969  -3.419  1.00 84.72           O  
ATOM   1736  N   GLU    66     -42.738 -26.257  -5.312  1.00 90.45           N  
ATOM   1737  CA  GLU    66     -43.927 -26.059  -6.179  1.00 98.45           C  
ATOM   1738  CB  GLU    66     -44.130 -24.595  -6.612  1.00102.82           C  
ATOM   1739  CG  GLU    66     -43.040 -23.979  -7.503  1.00111.20           C  
ATOM   1740  CD  GLU    66     -42.169 -22.963  -6.758  1.00114.90           C  
ATOM   1741  OE1 GLU    66     -40.926 -23.075  -6.824  1.00115.44           O  
ATOM   1742  OE2 GLU    66     -42.724 -22.050  -6.102  1.00117.13           O  
ATOM   1743  C   GLU    66     -43.980 -27.002  -7.387  1.00102.18           C  
ATOM   1744  O   GLU    66     -44.502 -28.115  -7.289  1.00104.08           O  
ATOM   1745  N   SER    69     -43.697 -30.660  -8.211  1.00101.20           N  
ATOM   1746  CA  SER    69     -44.454 -31.494  -7.282  1.00 99.05           C  
ATOM   1747  CB  SER    69     -45.901 -31.685  -7.755  1.00102.51           C  
ATOM   1748  OG  SER    69     -46.792 -30.960  -6.923  1.00102.15           O  
ATOM   1749  C   SER    69     -43.814 -32.847  -6.967  1.00 97.17           C  
ATOM   1750  O   SER    69     -43.726 -33.722  -7.819  1.00 97.34           O  
ATOM   1751  N   VAL    70     -43.349 -32.973  -5.724  1.00 93.77           N  
ATOM   1752  CA  VAL    70     -43.077 -34.264  -5.088  1.00 91.09           C  
ATOM   1753  CB  VAL    70     -41.686 -34.279  -4.362  1.00 88.12           C  
ATOM   1754  CG1 VAL    70     -41.781 -33.761  -2.949  1.00 81.91           C  
ATOM   1755  CG2 VAL    70     -40.646 -33.473  -5.150  1.00 88.49           C  
ATOM   1756  C   VAL    70     -44.264 -34.534  -4.133  1.00 89.28           C  
ATOM   1757  O   VAL    70     -45.079 -33.638  -3.896  1.00 88.69           O  
ATOM   1758  N   ALA    71     -44.386 -35.759  -3.618  1.00 88.48           N  
ATOM   1759  CA  ALA    71     -45.512 -36.123  -2.738  1.00 87.33           C  
ATOM   1760  CB  ALA    71     -45.593 -37.634  -2.538  1.00 87.21           C  
ATOM   1761  C   ALA    71     -45.417 -35.405  -1.391  1.00 83.85           C  
ATOM   1762  O   ALA    71     -44.327 -35.003  -0.963  1.00 80.71           O  
ATOM   1763  N   ASP    72     -46.558 -35.250  -0.725  1.00 83.63           N  
ATOM   1764  CA  ASP    72     -46.614 -34.429   0.474  1.00 80.95           C  
ATOM   1765  CB  ASP    72     -48.051 -34.287   0.985  1.00 82.60           C  
ATOM   1766  CG  ASP    72     -48.947 -33.501   0.017  1.00 87.82           C  
ATOM   1767  OD1 ASP    72     -48.434 -32.765  -0.860  1.00 87.73           O  
ATOM   1768  OD2 ASP    72     -50.184 -33.624   0.121  1.00 95.01           O  
ATOM   1769  C   ASP    72     -45.661 -34.957   1.530  1.00 77.55           C  
ATOM   1770  O   ASP    72     -44.869 -34.195   2.083  1.00 76.39           O  
ATOM   1771  N   ALA    73     -45.705 -36.274   1.729  1.00 77.84           N  
ATOM   1772  CA  ALA    73     -44.862 -37.023   2.666  1.00 75.61           C  
ATOM   1773  CB  ALA    73     -45.247 -38.531   2.639  1.00 76.99           C  
ATOM   1774  C   ALA    73     -43.356 -36.865   2.430  1.00 73.95           C  
ATOM   1775  O   ALA    73     -42.561 -37.082   3.347  1.00 73.95           O  
ATOM   1776  N   ALA    74     -42.968 -36.506   1.211  1.00 74.52           N  
ATOM   1777  CA  ALA    74     -41.553 -36.360   0.861  1.00 73.72           C  
ATOM   1778  CB  ALA    74     -41.306 -36.775  -0.591  1.00 75.34           C  
ATOM   1779  C   ALA    74     -41.030 -34.949   1.105  1.00 71.93           C  
ATOM   1780  O   ALA    74     -39.824 -34.717   1.057  1.00 72.75           O  
ATOM   1781  N   MET    75     -41.934 -34.009   1.355  1.00 70.52           N  
ATOM   1782  CA  MET    75     -41.547 -32.625   1.621  1.00 68.82           C  
ATOM   1783  CB  MET    75     -42.743 -31.690   1.429  1.00 68.84           C  
ATOM   1784  CG  MET    75     -43.196 -31.636  -0.008  1.00 72.32           C  
ATOM   1785  SD  MET    75     -44.675 -30.673  -0.173  1.00 75.06           S  
ATOM   1786  CE  MET    75     -45.027 -30.899  -1.910  1.00 77.34           C  
ATOM   1787  C   MET    75     -40.969 -32.503   3.022  1.00 66.12           C  
ATOM   1788  O   MET    75     -41.580 -32.964   3.987  1.00 67.76           O  
ATOM   1789  N   GLU    76     -39.783 -31.904   3.125  1.00 64.15           N  
ATOM   1790  CA  GLU    76     -39.064 -31.797   4.391  1.00 59.73           C  
ATOM   1791  CB  GLU    76     -37.593 -31.439   4.153  1.00 57.36           C  
ATOM   1792  CG  GLU    76     -36.784 -32.590   3.629  1.00 59.39           C  
ATOM   1793  CD  GLU    76     -35.304 -32.277   3.423  1.00 62.61           C  
ATOM   1794  OE1 GLU    76     -34.775 -31.364   4.072  1.00 67.17           O  
ATOM   1795  OE2 GLU    76     -34.657 -32.958   2.596  1.00 68.04           O  
ATOM   1796  C   GLU    76     -39.736 -30.778   5.293  1.00 59.34           C  
ATOM   1797  O   GLU    76     -40.135 -29.705   4.828  1.00 59.93           O  
ATOM   1798  N   GLN    77     -39.882 -31.144   6.572  1.00 59.36           N  
ATOM   1799  CA  GLN    77     -40.472 -30.296   7.619  1.00 57.88           C  
ATOM   1800  CB  GLN    77     -41.919 -30.704   7.882  1.00 57.46           C  
ATOM   1801  CG  GLN    77     -42.835 -30.354   6.717  1.00 58.86           C  
ATOM   1802  CD  GLN    77     -44.317 -30.511   7.033  1.00 59.59           C  
ATOM   1803  OE1 GLN    77     -44.847 -29.870   7.936  1.00 63.94           O  
ATOM   1804  NE2 GLN    77     -44.992 -31.342   6.266  1.00 55.64           N  
ATOM   1805  C   GLN    77     -39.649 -30.348   8.910  1.00 57.23           C  
ATOM   1806  O   GLN    77     -39.163 -31.411   9.298  1.00 60.33           O  
ATOM   1807  N   TYR    78     -39.485 -29.206   9.573  1.00 55.69           N  
ATOM   1808  CA  TYR    78     -38.585 -29.122  10.726  1.00 54.25           C  
ATOM   1809  CB  TYR    78     -37.189 -28.585  10.334  1.00 53.16           C  
ATOM   1810  CG  TYR    78     -36.440 -29.474   9.362  1.00 53.66           C  
ATOM   1811  CD1 TYR    78     -36.418 -29.181   7.994  1.00 54.30           C  
ATOM   1812  CE1 TYR    78     -35.739 -30.006   7.087  1.00 54.63           C  
ATOM   1813  CZ  TYR    78     -35.081 -31.136   7.552  1.00 53.74           C  
ATOM   1814  OH  TYR    78     -34.428 -31.941   6.658  1.00 57.55           O  
ATOM   1815  CE2 TYR    78     -35.082 -31.453   8.907  1.00 50.12           C  
ATOM   1816  CD2 TYR    78     -35.762 -30.617   9.804  1.00 52.20           C  
ATOM   1817  C   TYR    78     -39.156 -28.230  11.797  1.00 54.51           C  
ATOM   1818  O   TYR    78     -39.933 -27.312  11.507  1.00 56.08           O  
ATOM   1819  N   ILE    79     -38.766 -28.514  13.035  1.00 51.82           N  
ATOM   1820  CA  ILE    79     -38.847 -27.546  14.104  1.00 51.12           C  
ATOM   1821  CB  ILE    79     -39.334 -28.221  15.370  1.00 51.00           C  
ATOM   1822  CG1 ILE    79     -40.703 -28.835  15.118  1.00 49.34           C  
ATOM   1823  CD1 ILE    79     -41.115 -29.806  16.168  1.00 50.72           C  
ATOM   1824  CG2 ILE    79     -39.395 -27.223  16.509  1.00 50.32           C  
ATOM   1825  C   ILE    79     -37.424 -27.002  14.286  1.00 51.25           C  
ATOM   1826  O   ILE    79     -36.473 -27.789  14.393  1.00 51.15           O  
ATOM   1827  N   LEU    80     -37.264 -25.678  14.247  1.00 51.43           N  
ATOM   1828  CA  LEU    80     -35.970 -25.052  14.544  1.00 51.30           C  
ATOM   1829  CB  LEU    80     -35.733 -23.773  13.747  1.00 50.95           C  
ATOM   1830  CG  LEU    80     -35.744 -23.937  12.244  1.00 60.64           C  
ATOM   1831  CD1 LEU    80     -35.792 -22.573  11.544  1.00 61.99           C  
ATOM   1832  CD2 LEU    80     -34.546 -24.797  11.786  1.00 63.14           C  
ATOM   1833  C   LEU    80     -35.969 -24.674  16.006  1.00 50.47           C  
ATOM   1834  O   LEU    80     -36.946 -24.102  16.507  1.00 48.99           O  
ATOM   1835  N   TYR    81     -34.853 -24.968  16.666  1.00 49.53           N  
ATOM   1836  CA  TYR    81     -34.639 -24.601  18.040  1.00 49.40           C  
ATOM   1837  CB  TYR    81     -34.361 -25.849  18.868  1.00 49.48           C  
ATOM   1838  CG  TYR    81     -35.456 -26.905  18.856  1.00 47.03           C  
ATOM   1839  CD1 TYR    81     -35.465 -27.922  17.897  1.00 45.23           C  
ATOM   1840  CE1 TYR    81     -36.455 -28.906  17.906  1.00 46.90           C  
ATOM   1841  CZ  TYR    81     -37.454 -28.867  18.884  1.00 47.72           C  
ATOM   1842  OH  TYR    81     -38.450 -29.810  18.909  1.00 46.06           O  
ATOM   1843  CE2 TYR    81     -37.466 -27.866  19.832  1.00 44.80           C  
ATOM   1844  CD2 TYR    81     -36.468 -26.892  19.813  1.00 44.50           C  
ATOM   1845  C   TYR    81     -33.436 -23.681  18.136  1.00 50.84           C  
ATOM   1846  O   TYR    81     -32.490 -23.797  17.359  1.00 50.00           O  
ATOM   1847  N   LEU    82     -33.482 -22.759  19.091  1.00 51.39           N  
ATOM   1848  CA  LEU    82     -32.329 -21.943  19.401  1.00 50.54           C  
ATOM   1849  CB  LEU    82     -32.675 -20.462  19.332  1.00 51.46           C  
ATOM   1850  CG  LEU    82     -31.645 -19.457  19.872  1.00 51.59           C  
ATOM   1851  CD1 LEU    82     -30.399 -19.422  19.001  1.00 47.87           C  
ATOM   1852  CD2 LEU    82     -32.281 -18.073  19.963  1.00 49.07           C  
ATOM   1853  C   LEU    82     -31.879 -22.343  20.803  1.00 53.80           C  
ATOM   1854  O   LEU    82     -32.631 -22.182  21.768  1.00 54.04           O  
ATOM   1855  N   VAL    83     -30.652 -22.864  20.892  1.00 54.38           N  
ATOM   1856  CA  VAL    83     -30.192 -23.633  22.038  1.00 55.15           C  
ATOM   1857  CB  VAL    83     -30.160 -25.178  21.716  1.00 56.46           C  
ATOM   1858  CG1 VAL    83     -31.544 -25.722  21.351  1.00 55.39           C  
ATOM   1859  CG2 VAL    83     -29.123 -25.511  20.636  1.00 51.14           C  
ATOM   1860  C   VAL    83     -28.786 -23.248  22.465  1.00 57.18           C  
ATOM   1861  O   VAL    83     -28.015 -22.688  21.679  1.00 59.96           O  
ATOM   1862  N   GLU    84     -28.447 -23.609  23.698  1.00 58.16           N  
ATOM   1863  CA  GLU    84     -27.095 -23.449  24.241  1.00 59.82           C  
ATOM   1864  CB  GLU    84     -27.160 -23.477  25.766  1.00 61.80           C  
ATOM   1865  CG  GLU    84     -26.808 -22.172  26.402  1.00 70.34           C  
ATOM   1866  CD  GLU    84     -28.000 -21.311  26.688  1.00 76.51           C  
ATOM   1867  OE1 GLU    84     -28.225 -21.041  27.881  1.00 86.83           O  
ATOM   1868  OE2 GLU    84     -28.711 -20.886  25.749  1.00 78.44           O  
ATOM   1869  C   GLU    84     -26.093 -24.502  23.704  1.00 59.28           C  
ATOM   1870  O   GLU    84     -26.508 -25.525  23.141  1.00 56.78           O  
ATOM   1871  N   HIS    85     -24.791 -24.253  23.887  1.00 60.18           N  
ATOM   1872  CA  HIS    85     -23.742 -25.108  23.332  1.00 62.00           C  
ATOM   1873  CB  HIS    85     -22.362 -24.689  23.847  1.00 65.71           C  
ATOM   1874  CG  HIS    85     -21.220 -25.432  23.214  1.00 71.02           C  
ATOM   1875  ND1 HIS    85     -20.571 -24.981  22.082  1.00 75.54           N  
ATOM   1876  CE1 HIS    85     -19.606 -25.827  21.758  1.00 78.42           C  
ATOM   1877  NE2 HIS    85     -19.607 -26.812  22.640  1.00 78.22           N  
ATOM   1878  CD2 HIS    85     -20.598 -26.584  23.567  1.00 74.86           C  
ATOM   1879  C   HIS    85     -23.976 -26.598  23.597  1.00 63.27           C  
ATOM   1880  O   HIS    85     -23.889 -27.416  22.680  1.00 63.02           O  
ATOM   1881  N   GLU    86     -24.288 -26.955  24.838  1.00 65.23           N  
ATOM   1882  CA  GLU    86     -24.501 -28.359  25.162  1.00 67.93           C  
ATOM   1883  CB  GLU    86     -24.722 -28.557  26.653  1.00 71.08           C  
ATOM   1884  CG  GLU    86     -23.952 -29.758  27.155  1.00 83.00           C  
ATOM   1885  CD  GLU    86     -24.657 -30.510  28.268  1.00 92.71           C  
ATOM   1886  OE1 GLU    86     -25.911 -30.519  28.292  1.00 94.13           O  
ATOM   1887  OE2 GLU    86     -23.948 -31.111  29.113  1.00100.40           O  
ATOM   1888  C   GLU    86     -25.607 -29.063  24.346  1.00 66.02           C  
ATOM   1889  O   GLU    86     -25.435 -30.228  23.956  1.00 66.88           O  
ATOM   1890  N   GLU    87     -26.722 -28.377  24.081  1.00 62.99           N  
ATOM   1891  CA  GLU    87     -27.796 -29.011  23.323  1.00 63.50           C  
ATOM   1892  CB  GLU    87     -29.175 -28.323  23.429  1.00 63.04           C  
ATOM   1893  CG  GLU    87     -29.412 -27.243  24.487  1.00 68.38           C  
ATOM   1894  CD  GLU    87     -29.167 -27.664  25.892  1.00 74.69           C  
ATOM   1895  OE1 GLU    87     -29.010 -28.876  26.187  1.00 81.64           O  
ATOM   1896  OE2 GLU    87     -29.126 -26.745  26.719  1.00 79.95           O  
ATOM   1897  C   GLU    87     -27.386 -29.126  21.867  1.00 62.34           C  
ATOM   1898  O   GLU    87     -27.805 -30.059  21.181  1.00 64.45           O  
ATOM   1899  N   TYR    88     -26.550 -28.187  21.423  1.00 63.12           N  
ATOM   1900  CA  TYR    88     -25.912 -28.205  20.104  1.00 61.10           C  
ATOM   1901  CB  TYR    88     -25.154 -26.896  19.903  1.00 59.37           C  
ATOM   1902  CG  TYR    88     -24.260 -26.797  18.695  1.00 57.11           C  
ATOM   1903  CD1 TYR    88     -24.757 -26.339  17.475  1.00 55.05           C  
ATOM   1904  CE1 TYR    88     -23.923 -26.200  16.363  1.00 56.54           C  
ATOM   1905  CZ  TYR    88     -22.569 -26.521  16.470  1.00 59.03           C  
ATOM   1906  OH  TYR    88     -21.755 -26.397  15.374  1.00 59.09           O  
ATOM   1907  CE2 TYR    88     -22.047 -26.968  17.672  1.00 57.27           C  
ATOM   1908  CD2 TYR    88     -22.899 -27.091  18.785  1.00 58.95           C  
ATOM   1909  C   TYR    88     -24.962 -29.388  19.956  1.00 63.46           C  
ATOM   1910  O   TYR    88     -24.987 -30.068  18.935  1.00 63.63           O  
ATOM   1911  N   GLN    89     -24.129 -29.631  20.965  1.00 65.05           N  
ATOM   1912  CA  GLN    89     -23.289 -30.835  20.982  1.00 68.40           C  
ATOM   1913  CB  GLN    89     -22.433 -30.922  22.254  1.00 70.53           C  
ATOM   1914  CG  GLN    89     -21.312 -29.896  22.351  1.00 75.85           C  
ATOM   1915  CD  GLN    89     -20.242 -30.052  21.266  1.00 82.46           C  
ATOM   1916  OE1 GLN    89     -20.487 -29.788  20.078  1.00 81.02           O  
ATOM   1917  NE2 GLN    89     -19.039 -30.461  21.680  1.00 84.77           N  
ATOM   1918  C   GLN    89     -24.117 -32.109  20.830  1.00 68.19           C  
ATOM   1919  O   GLN    89     -23.823 -32.942  19.982  1.00 68.29           O  
ATOM   1920  N   LEU    90     -25.164 -32.247  21.639  1.00 67.73           N  
ATOM   1921  CA  LEU    90     -25.990 -33.437  21.594  1.00 68.47           C  
ATOM   1922  CB  LEU    90     -26.854 -33.542  22.841  1.00 67.62           C  
ATOM   1923  CG  LEU    90     -26.189 -33.669  24.196  1.00 71.02           C  
ATOM   1924  CD1 LEU    90     -27.305 -33.768  25.225  1.00 72.66           C  
ATOM   1925  CD2 LEU    90     -25.252 -34.868  24.238  1.00 67.89           C  
ATOM   1926  C   LEU    90     -26.901 -33.449  20.382  1.00 68.71           C  
ATOM   1927  O   LEU    90     -27.480 -34.485  20.045  1.00 70.32           O  
ATOM   1928  N   CYS    91     -27.041 -32.298  19.736  1.00 68.07           N  
ATOM   1929  CA  CYS    91     -28.023 -32.114  18.667  1.00 67.06           C  
ATOM   1930  CB  CYS    91     -27.667 -32.918  17.423  1.00 67.58           C  
ATOM   1931  SG  CYS    91     -28.387 -32.185  15.936  1.00 69.63           S  
ATOM   1932  C   CYS    91     -29.428 -32.469  19.133  1.00 66.19           C  
ATOM   1933  O   CYS    91     -30.171 -33.173  18.432  1.00 66.09           O  
ATOM   1934  N   GLN    92     -29.782 -31.987  20.325  1.00 64.97           N  
ATOM   1935  CA  GLN    92     -31.077 -32.297  20.923  1.00 63.97           C  
ATOM   1936  CB  GLN    92     -30.985 -33.573  21.748  1.00 64.98           C  
ATOM   1937  CG  GLN    92     -30.941 -34.800  20.877  1.00 69.42           C  
ATOM   1938  CD  GLN    92     -30.910 -36.068  21.655  1.00 74.34           C  
ATOM   1939  OE1 GLN    92     -31.110 -36.082  22.871  1.00 77.65           O  
ATOM   1940  NE2 GLN    92     -30.660 -37.159  20.962  1.00 73.77           N  
ATOM   1941  C   GLN    92     -31.580 -31.154  21.767  1.00 60.67           C  
ATOM   1942  O   GLN    92     -30.831 -30.623  22.558  1.00 63.52           O  
ATOM   1943  N   PRO    93     -32.863 -30.786  21.616  1.00 57.68           N  
ATOM   1944  CA  PRO    93     -33.422 -29.677  22.366  1.00 54.76           C  
ATOM   1945  CB  PRO    93     -34.789 -29.477  21.711  1.00 54.66           C  
ATOM   1946  CG  PRO    93     -35.181 -30.858  21.276  1.00 55.28           C  
ATOM   1947  CD  PRO    93     -33.881 -31.441  20.772  1.00 57.25           C  
ATOM   1948  C   PRO    93     -33.605 -30.090  23.812  1.00 55.78           C  
ATOM   1949  O   PRO    93     -33.749 -31.275  24.103  1.00 55.61           O  
ATOM   1950  N   GLN    94     -33.587 -29.116  24.712  1.00 57.59           N  
ATOM   1951  CA  GLN    94     -33.746 -29.379  26.135  1.00 59.55           C  
ATOM   1952  CB  GLN    94     -32.842 -28.453  26.950  1.00 59.04           C  
ATOM   1953  CG  GLN    94     -32.957 -28.628  28.458  1.00 66.00           C  
ATOM   1954  CD  GLN    94     -32.433 -27.414  29.230  1.00 73.20           C  
ATOM   1955  OE1 GLN    94     -31.541 -27.545  30.064  1.00 75.62           O  
ATOM   1956  NE2 GLN    94     -32.990 -26.227  28.953  1.00 73.53           N  
ATOM   1957  C   GLN    94     -35.229 -29.195  26.512  1.00 60.25           C  
ATOM   1958  O   GLN    94     -35.777 -29.989  27.294  1.00 61.46           O  
ATOM   1959  N   SER    95     -35.879 -28.180  25.933  1.00 56.75           N  
ATOM   1960  CA  SER    95     -37.274 -27.932  26.237  1.00 59.42           C  
ATOM   1961  CB  SER    95     -37.426 -27.257  27.612  1.00 59.78           C  
ATOM   1962  OG  SER    95     -37.322 -25.853  27.508  1.00 58.11           O  
ATOM   1963  C   SER    95     -38.037 -27.125  25.190  1.00 59.95           C  
ATOM   1964  O   SER    95     -37.461 -26.438  24.342  1.00 60.33           O  
ATOM   1965  N   LYS    96     -39.355 -27.206  25.304  1.00 60.01           N  
ATOM   1966  CA  LYS    96     -40.290 -26.413  24.539  1.00 58.91           C  
ATOM   1967  CB  LYS    96     -41.626 -26.516  25.233  1.00 60.61           C  
ATOM   1968  CG  LYS    96     -42.782 -26.032  24.442  1.00 68.37           C  
ATOM   1969  CD  LYS    96     -43.784 -25.347  25.378  1.00 75.00           C  
ATOM   1970  CE  LYS    96     -43.730 -25.909  26.778  1.00 74.45           C  
ATOM   1971  NZ  LYS    96     -44.618 -25.093  27.628  1.00 79.21           N  
ATOM   1972  C   LYS    96     -39.896 -24.940  24.421  1.00 56.09           C  
ATOM   1973  O   LYS    96     -40.043 -24.355  23.365  1.00 56.18           O  
ATOM   1974  N   ASP    97     -39.395 -24.345  25.497  1.00 55.95           N  
ATOM   1975  CA  ASP    97     -38.973 -22.935  25.490  1.00 55.13           C  
ATOM   1976  CB  ASP    97     -38.387 -22.528  26.830  1.00 55.07           C  
ATOM   1977  CG  ASP    97     -39.370 -22.695  27.965  1.00 61.58           C  
ATOM   1978  OD1 ASP    97     -40.576 -22.939  27.713  1.00 63.49           O  
ATOM   1979  OD2 ASP    97     -38.937 -22.581  29.125  1.00 69.18           O  
ATOM   1980  C   ASP    97     -37.964 -22.609  24.416  1.00 53.95           C  
ATOM   1981  O   ASP    97     -37.852 -21.479  24.022  1.00 56.06           O  
ATOM   1982  N   GLN    98     -37.239 -23.598  23.934  1.00 53.79           N  
ATOM   1983  CA  GLN    98     -36.216 -23.355  22.944  1.00 54.00           C  
ATOM   1984  CB  GLN    98     -35.071 -24.352  23.148  1.00 55.66           C  
ATOM   1985  CG  GLN    98     -34.318 -24.166  24.470  1.00 54.03           C  
ATOM   1986  CD  GLN    98     -33.256 -25.216  24.661  1.00 59.65           C  
ATOM   1987  OE1 GLN    98     -33.483 -26.405  24.401  1.00 60.28           O  
ATOM   1988  NE2 GLN    98     -32.075 -24.791  25.105  1.00 61.36           N  
ATOM   1989  C   GLN    98     -36.723 -23.401  21.496  1.00 54.76           C  
ATOM   1990  O   GLN    98     -35.970 -23.060  20.568  1.00 56.93           O  
ATOM   1991  N   VAL    99     -37.969 -23.844  21.286  1.00 52.58           N  
ATOM   1992  CA  VAL    99     -38.594 -23.762  19.965  1.00 50.25           C  
ATOM   1993  CB  VAL    99     -40.076 -24.225  19.984  1.00 50.43           C  
ATOM   1994  CG1 VAL    99     -40.706 -24.043  18.610  1.00 47.21           C  
ATOM   1995  CG2 VAL    99     -40.194 -25.701  20.411  1.00 49.23           C  
ATOM   1996  C   VAL    99     -38.484 -22.330  19.388  1.00 50.18           C  
ATOM   1997  O   VAL    99     -38.962 -21.373  19.984  1.00 52.07           O  
ATOM   1998  N   ARG   100     -37.853 -22.196  18.228  1.00 51.16           N  
ATOM   1999  CA  ARG   100     -37.633 -20.899  17.587  1.00 50.11           C  
ATOM   2000  CB  ARG   100     -36.235 -20.867  16.976  1.00 48.55           C  
ATOM   2001  CG  ARG   100     -35.839 -19.509  16.445  1.00 49.91           C  
ATOM   2002  CD  ARG   100     -35.920 -18.464  17.561  1.00 46.32           C  
ATOM   2003  NE  ARG   100     -35.676 -17.115  17.061  1.00 45.11           N  
ATOM   2004  CZ  ARG   100     -36.629 -16.253  16.719  1.00 45.48           C  
ATOM   2005  NH1 ARG   100     -37.913 -16.587  16.825  1.00 43.32           N  
ATOM   2006  NH2 ARG   100     -36.291 -15.047  16.267  1.00 44.04           N  
ATOM   2007  C   ARG   100     -38.638 -20.601  16.482  1.00 50.90           C  
ATOM   2008  O   ARG   100     -39.062 -19.444  16.295  1.00 51.44           O  
ATOM   2009  N   TRP   101     -38.968 -21.638  15.720  1.00 50.41           N  
ATOM   2010  CA  TRP   101     -39.852 -21.510  14.569  1.00 50.37           C  
ATOM   2011  CB  TRP   101     -39.224 -20.627  13.482  1.00 47.28           C  
ATOM   2012  CG  TRP   101     -40.273 -20.006  12.575  1.00 46.27           C  
ATOM   2013  CD1 TRP   101     -40.521 -20.311  11.254  1.00 43.91           C  
ATOM   2014  NE1 TRP   101     -41.561 -19.550  10.783  1.00 42.25           N  
ATOM   2015  CE2 TRP   101     -42.007 -18.734  11.793  1.00 43.80           C  
ATOM   2016  CD2 TRP   101     -41.222 -19.001  12.938  1.00 41.79           C  
ATOM   2017  CE3 TRP   101     -41.482 -18.290  14.123  1.00 42.59           C  
ATOM   2018  CZ3 TRP   101     -42.506 -17.349  14.130  1.00 43.83           C  
ATOM   2019  CH2 TRP   101     -43.271 -17.105  12.971  1.00 45.72           C  
ATOM   2020  CZ2 TRP   101     -43.040 -17.787  11.798  1.00 45.42           C  
ATOM   2021  C   TRP   101     -40.176 -22.889  14.007  1.00 51.33           C  
ATOM   2022  O   TRP   101     -39.530 -23.867  14.362  1.00 53.74           O  
ATOM   2023  N   GLN   102     -41.186 -22.977  13.155  1.00 53.13           N  
ATOM   2024  CA  GLN   102     -41.510 -24.248  12.529  1.00 56.47           C  
ATOM   2025  CB  GLN   102     -42.823 -24.769  13.050  1.00 58.58           C  
ATOM   2026  CG  GLN   102     -42.719 -25.076  14.531  1.00 66.85           C  
ATOM   2027  CD  GLN   102     -43.742 -26.074  14.997  1.00 73.38           C  
ATOM   2028  OE1 GLN   102     -43.587 -27.286  14.820  1.00 80.09           O  
ATOM   2029  NE2 GLN   102     -44.795 -25.571  15.609  1.00 75.87           N  
ATOM   2030  C   GLN   102     -41.514 -24.181  11.022  1.00 57.45           C  
ATOM   2031  O   GLN   102     -42.105 -23.277  10.454  1.00 57.22           O  
ATOM   2032  N   CYS   103     -40.808 -25.115  10.383  1.00 56.18           N  
ATOM   2033  CA  CYS   103     -40.872 -25.268   8.940  1.00 56.68           C  
ATOM   2034  CB  CYS   103     -39.542 -25.711   8.356  1.00 57.17           C  
ATOM   2035  SG  CYS   103     -38.285 -24.514   8.632  1.00 64.06           S  
ATOM   2036  C   CYS   103     -41.930 -26.288   8.660  1.00 55.99           C  
ATOM   2037  O   CYS   103     -41.637 -27.431   8.275  1.00 56.24           O  
ATOM   2038  N   ASN   104     -43.172 -25.869   8.856  1.00 56.52           N  
ATOM   2039  CA  ASN   104     -44.287 -26.761   8.665  1.00 57.46           C  
ATOM   2040  CB  ASN   104     -45.009 -27.003   9.992  1.00 55.61           C  
ATOM   2041  CG  ASN   104     -45.675 -25.762  10.538  1.00 56.96           C  
ATOM   2042  OD1 ASN   104     -45.472 -24.663  10.051  1.00 59.86           O  
ATOM   2043  ND2 ASN   104     -46.487 -25.941  11.555  1.00 57.18           N  
ATOM   2044  C   ASN   104     -45.217 -26.255   7.573  1.00 60.54           C  
ATOM   2045  O   ASN   104     -46.400 -26.543   7.575  1.00 63.29           O  
ATOM   2046  N   ARG   105     -44.664 -25.509   6.628  1.00 62.17           N  
ATOM   2047  CA  ARG   105     -45.421 -25.062   5.465  1.00 65.71           C  
ATOM   2048  CB  ARG   105     -45.931 -23.631   5.670  1.00 67.60           C  
ATOM   2049  CG  ARG   105     -47.074 -23.602   6.680  1.00 75.21           C  
ATOM   2050  CD  ARG   105     -47.412 -22.219   7.107  1.00 83.04           C  
ATOM   2051  NE  ARG   105     -47.651 -21.397   5.932  1.00 91.36           N  
ATOM   2052  CZ  ARG   105     -47.781 -20.073   5.948  1.00 97.78           C  
ATOM   2053  NH1 ARG   105     -47.985 -19.436   4.800  1.00 98.04           N  
ATOM   2054  NH2 ARG   105     -47.712 -19.387   7.097  1.00 94.61           N  
ATOM   2055  C   ARG   105     -44.589 -25.241   4.194  1.00 65.66           C  
ATOM   2056  O   ARG   105     -44.198 -24.270   3.544  1.00 67.33           O  
ATOM   2057  N   PRO   106     -44.314 -26.506   3.838  1.00 64.89           N  
ATOM   2058  CA  PRO   106     -43.414 -26.796   2.748  1.00 64.10           C  
ATOM   2059  CB  PRO   106     -43.311 -28.313   2.795  1.00 61.91           C  
ATOM   2060  CG  PRO   106     -44.583 -28.753   3.411  1.00 61.26           C  
ATOM   2061  CD  PRO   106     -44.843 -27.744   4.441  1.00 63.43           C  
ATOM   2062  C   PRO   106     -43.945 -26.360   1.392  1.00 66.96           C  
ATOM   2063  O   PRO   106     -43.167 -26.291   0.437  1.00 68.20           O  
ATOM   2064  N   SER   107     -45.241 -26.073   1.271  1.00 68.77           N  
ATOM   2065  CA  SER   107     -45.742 -25.726  -0.077  1.00 70.58           C  
ATOM   2066  CB  SER   107     -46.329 -26.944  -0.815  1.00 70.55           C  
ATOM   2067  OG  SER   107     -47.527 -27.384  -0.225  1.00 69.80           O  
ATOM   2068  C   SER   107     -46.645 -24.493  -0.140  1.00 71.96           C  
ATOM   2069  O   SER   107     -47.411 -24.291  -1.091  1.00 73.54           O  
ATOM   2070  N   ALA   108     -46.505 -23.665   0.884  1.00 72.27           N  
ATOM   2071  CA  ALA   108     -47.066 -22.335   0.930  1.00 73.55           C  
ATOM   2072  CB  ALA   108     -46.320 -21.559   1.979  1.00 73.53           C  
ATOM   2073  C   ALA   108     -46.967 -21.624  -0.432  1.00 76.63           C  
ATOM   2074  O   ALA   108     -45.893 -21.532  -1.033  1.00 75.59           O  
ATOM   2075  N   LYS   109     -48.094 -21.112  -0.917  1.00 81.01           N  
ATOM   2076  CA  LYS   109     -48.118 -20.389  -2.188  1.00 82.67           C  
ATOM   2077  CB  LYS   109     -49.563 -20.159  -2.664  1.00 85.17           C  
ATOM   2082  C   LYS   109     -47.324 -19.076  -2.137  1.00 83.71           C  
ATOM   2083  O   LYS   109     -46.754 -18.673  -3.149  1.00 85.36           O  
ATOM   2084  N   HIS   110     -47.275 -18.434  -0.971  0.50 83.61           N  
ATOM   2086  CA  HIS   110     -46.653 -17.106  -0.834  0.50 85.44           C  
ATOM   2088  CB  HIS   110     -47.170 -16.396   0.429  0.50 86.22           C  
ATOM   2090  CG  HIS   110     -48.625 -16.046   0.382  0.50 86.31           C  
ATOM   2092  ND1 HIS   110     -49.095 -14.788   0.685  0.50 88.73           N  
ATOM   2094  CE1 HIS   110     -50.410 -14.770   0.564  0.50 90.79           C  
ATOM   2096  NE2 HIS   110     -50.812 -15.971   0.190  0.50 87.13           N  
ATOM   2098  CD2 HIS   110     -49.715 -16.788   0.072  0.50 85.88           C  
ATOM   2100  C   HIS   110     -45.108 -17.095  -0.858  0.50 84.28           C  
ATOM   2102  O   HIS   110     -44.493 -16.028  -0.768  0.50 86.17           O  
ATOM   2104  N   GLY   111     -44.491 -18.270  -0.980  1.00 82.38           N  
ATOM   2105  CA  GLY   111     -43.020 -18.387  -1.011  1.00 79.93           C  
ATOM   2106  C   GLY   111     -42.566 -19.306   0.116  1.00 76.67           C  
ATOM   2107  O   GLY   111     -43.411 -19.872   0.818  1.00 77.64           O  
ATOM   2108  N   PRO   112     -41.242 -19.462   0.316  1.00 73.97           N  
ATOM   2109  CA  PRO   112     -40.800 -20.374   1.380  1.00 69.94           C  
ATOM   2110  CB  PRO   112     -39.284 -20.484   1.155  1.00 70.11           C  
ATOM   2111  CG  PRO   112     -39.017 -19.835  -0.179  1.00 71.17           C  
ATOM   2112  CD  PRO   112     -40.100 -18.823  -0.355  1.00 74.32           C  
ATOM   2113  C   PRO   112     -41.055 -19.734   2.728  1.00 68.32           C  
ATOM   2114  O   PRO   112     -41.049 -18.514   2.833  1.00 68.74           O  
ATOM   2115  N   GLU   113     -41.296 -20.554   3.738  1.00 68.03           N  
ATOM   2116  CA  GLU   113     -41.397 -20.072   5.101  1.00 65.88           C  
ATOM   2117  CB  GLU   113     -42.000 -21.158   5.995  1.00 65.23           C  
ATOM   2118  CG  GLU   113     -42.259 -20.757   7.436  1.00 64.92           C  
ATOM   2119  CD  GLU   113     -43.418 -19.811   7.581  1.00 68.45           C  
ATOM   2120  OE1 GLU   113     -43.386 -18.985   8.518  1.00 72.82           O  
ATOM   2121  OE2 GLU   113     -44.362 -19.880   6.763  1.00 72.64           O  
ATOM   2122  C   GLU   113     -39.990 -19.701   5.555  1.00 64.54           C  
ATOM   2123  O   GLU   113     -39.019 -20.358   5.188  1.00 66.12           O  
ATOM   2124  N   LYS   114     -39.881 -18.665   6.371  1.00 64.40           N  
ATOM   2125  CA  LYS   114     -38.593 -18.041   6.646  1.00 64.05           C  
ATOM   2126  CB  LYS   114     -38.414 -16.911   5.629  1.00 65.16           C  
ATOM   2127  CG  LYS   114     -37.179 -16.062   5.742  1.00 70.29           C  
ATOM   2128  CD  LYS   114     -37.256 -14.909   4.722  1.00 73.48           C  
ATOM   2129  CE  LYS   114     -38.129 -13.755   5.235  1.00 79.32           C  
ATOM   2130  NZ  LYS   114     -38.024 -12.564   4.346  1.00 86.89           N  
ATOM   2131  C   LYS   114     -38.510 -17.525   8.099  1.00 61.34           C  
ATOM   2132  O   LYS   114     -39.401 -16.795   8.570  1.00 61.87           O  
ATOM   2133  N   LEU   115     -37.466 -17.942   8.816  1.00 58.06           N  
ATOM   2134  CA  LEU   115     -37.124 -17.352  10.112  1.00 56.46           C  
ATOM   2135  CB  LEU   115     -36.612 -18.423  11.087  1.00 55.24           C  
ATOM   2136  CG  LEU   115     -36.414 -18.079  12.571  1.00 55.58           C  
ATOM   2137  CD1 LEU   115     -35.114 -17.372  12.765  1.00 56.14           C  
ATOM   2138  CD2 LEU   115     -37.571 -17.227  13.152  1.00 51.27           C  
ATOM   2139  C   LEU   115     -36.067 -16.255   9.915  1.00 56.26           C  
ATOM   2140  O   LEU   115     -34.931 -16.558   9.563  1.00 57.13           O  
ATOM   2141  N   SER   116     -36.447 -14.991  10.119  1.00 55.73           N  
ATOM   2142  CA  SER   116     -35.484 -13.866  10.078  1.00 54.72           C  
ATOM   2143  CB  SER   116     -36.058 -12.675   9.318  1.00 53.24           C  
ATOM   2144  OG  SER   116     -36.231 -13.009   7.962  1.00 59.50           O  
ATOM   2145  C   SER   116     -35.078 -13.419  11.482  1.00 53.76           C  
ATOM   2146  O   SER   116     -35.840 -12.760  12.162  1.00 54.96           O  
ATOM   2147  N   GLU   117     -33.873 -13.783  11.888  1.00 53.29           N  
ATOM   2148  CA  GLU   117     -33.348 -13.483  13.202  1.00 55.01           C  
ATOM   2149  CB  GLU   117     -32.501 -14.679  13.692  1.00 54.38           C  
ATOM   2150  CG  GLU   117     -31.960 -14.505  15.075  1.00 53.87           C  
ATOM   2151  CD  GLU   117     -32.976 -14.909  16.118  1.00 59.77           C  
ATOM   2152  OE1 GLU   117     -33.040 -16.118  16.398  1.00 54.27           O  
ATOM   2153  OE2 GLU   117     -33.714 -14.022  16.654  1.00 63.09           O  
ATOM   2154  C   GLU   117     -32.451 -12.254  13.113  1.00 57.04           C  
ATOM   2155  O   GLU   117     -31.441 -12.286  12.407  1.00 61.60           O  
ATOM   2156  N   LYS   118     -32.777 -11.175  13.815  1.00 57.57           N  
ATOM   2157  CA  LYS   118     -31.843 -10.047  13.876  1.00 56.25           C  
ATOM   2158  CB  LYS   118     -32.563  -8.713  13.901  1.00 56.23           C  
ATOM   2159  CG  LYS   118     -31.618  -7.534  13.868  1.00 55.68           C  
ATOM   2160  CD  LYS   118     -32.364  -6.236  14.014  1.00 60.62           C  
ATOM   2161  CE  LYS   118     -31.459  -5.063  13.761  1.00 63.49           C  
ATOM   2162  NZ  LYS   118     -32.307  -3.873  13.602  1.00 66.60           N  
ATOM   2163  C   LYS   118     -30.969 -10.176  15.103  1.00 58.01           C  
ATOM   2164  O   LYS   118     -31.471 -10.341  16.217  1.00 61.22           O  
ATOM   2165  N   PHE   119     -29.660 -10.088  14.909  1.00 57.70           N  
ATOM   2166  CA  PHE   119     -28.732 -10.224  16.011  1.00 57.85           C  
ATOM   2167  CB  PHE   119     -27.428 -10.844  15.494  1.00 58.57           C  
ATOM   2168  CG  PHE   119     -27.559 -12.328  15.221  1.00 58.68           C  
ATOM   2169  CD1 PHE   119     -28.338 -12.791  14.166  1.00 59.09           C  
ATOM   2170  CE1 PHE   119     -28.502 -14.151  13.939  1.00 58.27           C  
ATOM   2171  CZ  PHE   119     -27.888 -15.067  14.769  1.00 58.62           C  
ATOM   2172  CE2 PHE   119     -27.106 -14.622  15.825  1.00 59.67           C  
ATOM   2173  CD2 PHE   119     -26.953 -13.260  16.048  1.00 60.42           C  
ATOM   2174  C   PHE   119     -28.573  -8.927  16.824  1.00 60.49           C  
ATOM   2175  O   PHE   119     -27.512  -8.304  16.846  1.00 62.69           O  
ATOM   2176  N   GLN   120     -29.670  -8.525  17.466  1.00 60.88           N  
ATOM   2177  CA  GLN   120     -29.747  -7.338  18.311  1.00 64.08           C  
ATOM   2178  CB  GLN   120     -31.186  -7.147  18.736  1.00 65.47           C  
ATOM   2179  CG  GLN   120     -32.132  -6.431  17.828  1.00 71.77           C  
ATOM   2180  CD  GLN   120     -33.544  -6.479  18.418  1.00 77.29           C  
ATOM   2181  OE1 GLN   120     -33.995  -7.532  18.888  1.00 75.97           O  
ATOM   2182  NE2 GLN   120     -34.234  -5.334  18.427  1.00 82.70           N  
ATOM   2183  C   GLN   120     -29.014  -7.592  19.618  1.00 66.37           C  
ATOM   2184  O   GLN   120     -28.935  -8.734  20.066  1.00 68.81           O  
ATOM   2185  N   ARG   121     -28.550  -6.534  20.280  1.00 68.12           N  
ATOM   2186  CA  ARG   121     -28.049  -6.671  21.642  1.00 69.56           C  
ATOM   2187  CB  ARG   121     -27.005  -5.591  21.982  1.00 73.03           C  
ATOM   2188  CG  ARG   121     -25.964  -6.019  23.055  1.00 76.86           C  
ATOM   2189  CD  ARG   121     -26.436  -5.615  24.406  1.00 84.36           C  
ATOM   2190  NE  ARG   121     -25.839  -6.289  25.563  1.00 92.25           N  
ATOM   2191  CZ  ARG   121     -26.404  -7.293  26.240  1.00 95.25           C  
ATOM   2192  NH1 ARG   121     -27.569  -7.810  25.850  1.00 91.64           N  
ATOM   2193  NH2 ARG   121     -25.791  -7.798  27.306  1.00 98.78           N  
ATOM   2194  C   ARG   121     -29.187  -6.655  22.657  1.00 70.48           C  
ATOM   2195  O   ARG   121     -29.072  -7.272  23.710  1.00 71.66           O  
ATOM   2196  N   PHE   122     -30.276  -5.954  22.347  1.00 61.20           N  
ATOM   2197  CA  PHE   122     -31.381  -5.819  23.293  1.00 60.75           C  
ATOM   2198  CB  PHE   122     -31.403  -4.418  23.897  1.00 58.60           C  
ATOM   2199  CG  PHE   122     -30.183  -4.059  24.692  1.00 55.90           C  
ATOM   2200  CD1 PHE   122     -29.306  -3.083  24.228  1.00 54.44           C  
ATOM   2201  CE1 PHE   122     -28.172  -2.721  24.978  1.00 54.40           C  
ATOM   2202  CZ  PHE   122     -27.923  -3.334  26.216  1.00 52.99           C  
ATOM   2203  CE2 PHE   122     -28.811  -4.305  26.694  1.00 54.00           C  
ATOM   2204  CD2 PHE   122     -29.937  -4.653  25.933  1.00 54.71           C  
ATOM   2205  C   PHE   122     -32.737  -6.058  22.642  1.00 62.50           C  
ATOM   2206  O   PHE   122     -32.961  -5.561  21.536  1.00 62.87           O  
ATOM   2207  N   THR   123     -33.623  -6.804  23.325  1.00 62.78           N  
ATOM   2208  CA  THR   123     -35.036  -6.962  22.919  1.00 64.29           C  
ATOM   2209  CB  THR   123     -35.596  -8.415  23.030  1.00 64.98           C  
ATOM   2210  OG1 THR   123     -34.571  -9.339  23.418  1.00 68.38           O  
ATOM   2211  CG2 THR   123     -36.347  -8.842  21.760  1.00 66.72           C  
ATOM   2212  C   THR   123     -35.935  -6.295  23.926  1.00 63.38           C  
ATOM   2213  O   THR   123     -35.648  -6.333  25.122  1.00 62.17           O  
ATOM   2214  N   PRO   124     -37.071  -5.759  23.455  1.00 63.85           N  
ATOM   2215  CA  PRO   124     -38.192  -5.496  24.349  1.00 64.11           C  
ATOM   2216  CB  PRO   124     -39.047  -4.519  23.544  1.00 63.16           C  
ATOM   2217  CG  PRO   124     -38.774  -4.886  22.115  1.00 62.79           C  
ATOM   2218  CD  PRO   124     -37.369  -5.378  22.058  1.00 63.83           C  
ATOM   2219  C   PRO   124     -38.989  -6.783  24.635  1.00 65.71           C  
ATOM   2220  O   PRO   124     -39.777  -6.811  25.575  1.00 65.67           O  
ATOM   2221  N   PHE   125     -38.799  -7.834  23.830  1.00 67.48           N  
ATOM   2222  CA  PHE   125     -39.646  -9.025  23.963  1.00 68.12           C  
ATOM   2223  CB  PHE   125     -40.131  -9.572  22.622  1.00 65.98           C  
ATOM   2224  CG  PHE   125     -41.287 -10.510  22.754  1.00 67.79           C  
ATOM   2225  CD1 PHE   125     -41.169 -11.841  22.369  1.00 66.48           C  
ATOM   2226  CE1 PHE   125     -42.241 -12.720  22.495  1.00 65.01           C  
ATOM   2227  CZ  PHE   125     -43.453 -12.281  23.039  1.00 65.56           C  
ATOM   2228  CE2 PHE   125     -43.581 -10.955  23.447  1.00 66.67           C  
ATOM   2229  CD2 PHE   125     -42.500 -10.072  23.297  1.00 68.36           C  
ATOM   2230  C   PHE   125     -39.028 -10.121  24.816  1.00 69.36           C  
ATOM   2231  O   PHE   125     -37.988 -10.675  24.505  1.00 73.04           O  
ATOM   2232  N   THR   126     -39.722 -10.441  25.889  1.00 69.96           N  
ATOM   2233  CA  THR   126     -39.165 -11.208  26.981  1.00 68.85           C  
ATOM   2234  CB  THR   126     -40.046 -10.959  28.226  1.00 68.67           C  
ATOM   2235  OG1 THR   126     -39.214 -10.762  29.367  1.00 75.15           O  
ATOM   2236  CG2 THR   126     -41.043 -12.049  28.459  1.00 65.36           C  
ATOM   2237  C   THR   126     -38.905 -12.693  26.639  1.00 68.68           C  
ATOM   2238  O   THR   126     -38.144 -13.374  27.319  1.00 68.27           O  
ATOM   2239  N   LEU   127     -39.507 -13.159  25.548  1.00 69.14           N  
ATOM   2240  CA  LEU   127     -39.357 -14.539  25.061  1.00 69.56           C  
ATOM   2241  CB  LEU   127     -40.690 -15.040  24.498  1.00 68.06           C  
ATOM   2242  CG  LEU   127     -41.745 -15.722  25.381  1.00 67.52           C  
ATOM   2243  CD1 LEU   127     -41.707 -15.252  26.804  1.00 64.96           C  
ATOM   2244  CD2 LEU   127     -43.142 -15.547  24.789  1.00 67.52           C  
ATOM   2245  C   LEU   127     -38.284 -14.664  23.971  1.00 71.45           C  
ATOM   2246  O   LEU   127     -37.988 -15.766  23.523  1.00 72.49           O  
ATOM   2247  N   GLY   128     -37.725 -13.534  23.536  1.00 70.94           N  
ATOM   2248  CA  GLY   128     -36.696 -13.526  22.509  1.00 71.72           C  
ATOM   2249  C   GLY   128     -35.307 -13.517  23.113  1.00 71.86           C  
ATOM   2250  O   GLY   128     -35.160 -13.397  24.327  1.00 72.73           O  
ATOM   2251  N   LYS   129     -34.288 -13.655  22.265  1.00 71.49           N  
ATOM   2252  CA  LYS   129     -32.902 -13.778  22.712  1.00 70.95           C  
ATOM   2253  CB  LYS   129     -32.228 -14.955  22.001  1.00 71.86           C  
ATOM   2254  CG  LYS   129     -31.407 -15.887  22.907  1.00 76.61           C  
ATOM   2255  CD  LYS   129     -29.935 -15.452  23.062  1.00 77.08           C  
ATOM   2256  CE  LYS   129     -29.113 -16.483  23.848  1.00 74.75           C  
ATOM   2258  C   LYS   129     -32.115 -12.486  22.445  1.00 69.43           C  
ATOM   2259  O   LYS   129     -32.398 -11.740  21.490  1.00 69.19           O  
ATOM   2260  N   GLU   130     -31.133 -12.219  23.295  1.00 66.53           N  
ATOM   2261  CA  GLU   130     -30.216 -11.111  23.069  1.00 63.18           C  
ATOM   2262  CB  GLU   130     -30.119 -10.259  24.310  1.00 60.46           C  
ATOM   2263  CG  GLU   130     -31.446  -9.677  24.676  1.00 58.67           C  
ATOM   2264  CD  GLU   130     -31.343  -8.581  25.707  1.00 64.53           C  
ATOM   2265  OE1 GLU   130     -30.511  -8.684  26.652  1.00 63.02           O  
ATOM   2266  OE2 GLU   130     -32.116  -7.611  25.571  1.00 66.51           O  
ATOM   2267  C   GLU   130     -28.860 -11.652  22.646  1.00 63.11           C  
ATOM   2268  O   GLU   130     -28.440 -12.728  23.084  1.00 65.06           O  
ATOM   2269  N   PHE   131     -28.190 -10.916  21.774  1.00 63.03           N  
ATOM   2270  CA  PHE   131     -26.963 -11.396  21.171  1.00 61.16           C  
ATOM   2271  CB  PHE   131     -27.161 -11.547  19.656  1.00 58.51           C  
ATOM   2272  CG  PHE   131     -28.257 -12.503  19.284  1.00 55.20           C  
ATOM   2273  CD1 PHE   131     -28.003 -13.873  19.198  1.00 51.84           C  
ATOM   2274  CE1 PHE   131     -29.026 -14.768  18.870  1.00 53.42           C  
ATOM   2275  CZ  PHE   131     -30.332 -14.290  18.634  1.00 51.71           C  
ATOM   2276  CE2 PHE   131     -30.592 -12.923  18.741  1.00 53.28           C  
ATOM   2277  CD2 PHE   131     -29.559 -12.040  19.058  1.00 53.90           C  
ATOM   2278  C   PHE   131     -25.827 -10.437  21.480  1.00 63.92           C  
ATOM   2279  O   PHE   131     -25.998  -9.235  21.371  1.00 65.92           O  
ATOM   2280  N   LYS   132     -24.670 -10.970  21.860  1.00 65.44           N  
ATOM   2281  CA  LYS   132     -23.542 -10.152  22.310  1.00 68.20           C  
ATOM   2282  CB  LYS   132     -23.222 -10.464  23.772  1.00 68.50           C  
ATOM   2283  CG  LYS   132     -24.290 -10.012  24.726  1.00 73.51           C  
ATOM   2284  CD  LYS   132     -24.607 -11.080  25.752  1.00 80.61           C  
ATOM   2285  CE  LYS   132     -23.876 -10.832  27.070  1.00 86.59           C  
ATOM   2286  NZ  LYS   132     -24.433 -11.694  28.161  1.00 88.30           N  
ATOM   2287  C   LYS   132     -22.309 -10.378  21.457  1.00 68.97           C  
ATOM   2288  O   LYS   132     -22.055 -11.497  21.017  1.00 68.20           O  
ATOM   2289  N   GLU   133     -21.544  -9.311  21.234  1.00 72.55           N  
ATOM   2290  CA  GLU   133     -20.260  -9.392  20.521  1.00 74.52           C  
ATOM   2291  CB  GLU   133     -19.611  -8.009  20.415  1.00 76.37           C  
ATOM   2292  CG  GLU   133     -20.269  -7.123  19.363  1.00 81.52           C  
ATOM   2293  CD  GLU   133     -19.519  -5.821  19.099  1.00 86.20           C  
ATOM   2294  OE1 GLU   133     -18.317  -5.875  18.747  1.00 96.41           O  
ATOM   2295  OE2 GLU   133     -20.134  -4.734  19.224  1.00 92.30           O  
ATOM   2296  C   GLU   133     -19.304 -10.367  21.191  1.00 72.05           C  
ATOM   2297  O   GLU   133     -19.186 -10.376  22.407  1.00 72.26           O  
ATOM   2298  N   GLY   134     -18.645 -11.199  20.390  1.00 70.84           N  
ATOM   2299  CA  GLY   134     -17.705 -12.198  20.893  1.00 69.51           C  
ATOM   2300  C   GLY   134     -18.303 -13.537  21.292  1.00 68.24           C  
ATOM   2301  O   GLY   134     -17.573 -14.451  21.639  1.00 68.55           O  
ATOM   2302  N   HIS   135     -19.626 -13.659  21.257  1.00 66.41           N  
ATOM   2303  CA  HIS   135     -20.292 -14.907  21.621  1.00 65.15           C  
ATOM   2304  CB  HIS   135     -21.487 -14.628  22.535  1.00 65.77           C  
ATOM   2305  CG  HIS   135     -21.103 -14.116  23.884  1.00 71.66           C  
ATOM   2306  ND1 HIS   135     -20.438 -12.919  24.066  1.00 75.73           N  
ATOM   2307  CE1 HIS   135     -20.231 -12.724  25.357  1.00 76.62           C  
ATOM   2308  NE2 HIS   135     -20.746 -13.745  26.018  1.00 77.98           N  
ATOM   2309  CD2 HIS   135     -21.296 -14.632  25.120  1.00 73.15           C  
ATOM   2310  C   HIS   135     -20.757 -15.690  20.396  1.00 62.81           C  
ATOM   2311  O   HIS   135     -20.812 -15.161  19.280  1.00 63.13           O  
ATOM   2312  N   SER   136     -21.099 -16.953  20.621  1.00 60.44           N  
ATOM   2313  CA  SER   136     -21.619 -17.814  19.576  1.00 58.65           C  
ATOM   2314  CB  SER   136     -20.678 -18.997  19.352  1.00 59.69           C  
ATOM   2315  OG  SER   136     -19.527 -18.622  18.596  1.00 61.55           O  
ATOM   2316  C   SER   136     -23.020 -18.292  19.955  1.00 57.92           C  
ATOM   2317  O   SER   136     -23.352 -18.401  21.137  1.00 56.83           O  
ATOM   2318  N   TYR   137     -23.854 -18.552  18.954  1.00 57.02           N  
ATOM   2319  CA  TYR   137     -25.235 -18.979  19.198  1.00 56.00           C  
ATOM   2320  CB  TYR   137     -26.194 -17.809  18.951  1.00 56.33           C  
ATOM   2321  CG  TYR   137     -25.840 -16.674  19.876  1.00 58.56           C  
ATOM   2322  CD1 TYR   137     -24.865 -15.726  19.518  1.00 58.33           C  
ATOM   2323  CE1 TYR   137     -24.493 -14.719  20.391  1.00 61.81           C  
ATOM   2324  CZ  TYR   137     -25.087 -14.654  21.654  1.00 63.16           C  
ATOM   2325  OH  TYR   137     -24.739 -13.657  22.546  1.00 63.56           O  
ATOM   2326  CE2 TYR   137     -26.041 -15.596  22.032  1.00 60.91           C  
ATOM   2327  CD2 TYR   137     -26.401 -16.602  21.151  1.00 57.19           C  
ATOM   2328  C   TYR   137     -25.497 -20.190  18.337  1.00 54.88           C  
ATOM   2329  O   TYR   137     -24.769 -20.423  17.387  1.00 57.89           O  
ATOM   2330  N   TYR   138     -26.479 -21.000  18.693  1.00 54.02           N  
ATOM   2331  CA  TYR   138     -26.600 -22.323  18.077  1.00 53.58           C  
ATOM   2332  CB  TYR   138     -26.047 -23.415  18.997  1.00 53.48           C  
ATOM   2333  CG  TYR   138     -24.676 -23.098  19.544  1.00 56.27           C  
ATOM   2334  CD1 TYR   138     -24.530 -22.469  20.779  1.00 56.27           C  
ATOM   2335  CE1 TYR   138     -23.286 -22.160  21.278  1.00 54.11           C  
ATOM   2336  CZ  TYR   138     -22.169 -22.470  20.546  1.00 56.08           C  
ATOM   2337  OH  TYR   138     -20.928 -22.166  21.051  1.00 61.04           O  
ATOM   2338  CE2 TYR   138     -22.279 -23.090  19.317  1.00 56.79           C  
ATOM   2339  CD2 TYR   138     -23.529 -23.396  18.819  1.00 55.12           C  
ATOM   2340  C   TYR   138     -28.026 -22.648  17.764  1.00 53.46           C  
ATOM   2341  O   TYR   138     -28.903 -22.512  18.643  1.00 52.33           O  
ATOM   2342  N   TYR   139     -28.246 -23.076  16.516  1.00 52.60           N  
ATOM   2343  CA  TYR   139     -29.530 -23.587  16.079  1.00 51.05           C  
ATOM   2344  CB  TYR   139     -29.997 -22.871  14.817  1.00 50.69           C  
ATOM   2345  CG  TYR   139     -30.236 -21.390  14.980  1.00 53.13           C  
ATOM   2346  CD1 TYR   139     -29.183 -20.481  14.864  1.00 54.96           C  
ATOM   2347  CE1 TYR   139     -29.386 -19.107  14.988  1.00 53.90           C  
ATOM   2348  CZ  TYR   139     -30.658 -18.625  15.251  1.00 56.28           C  
ATOM   2349  OH  TYR   139     -30.846 -17.257  15.382  1.00 53.37           O  
ATOM   2350  CE2 TYR   139     -31.732 -19.519  15.384  1.00 54.77           C  
ATOM   2351  CD2 TYR   139     -31.515 -20.890  15.239  1.00 52.78           C  
ATOM   2352  C   TYR   139     -29.422 -25.074  15.798  1.00 52.04           C  
ATOM   2353  O   TYR   139     -28.415 -25.551  15.236  1.00 52.43           O  
ATOM   2354  N   ILE   140     -30.473 -25.802  16.170  1.00 51.19           N  
ATOM   2355  CA  ILE   140     -30.638 -27.207  15.747  1.00 52.22           C  
ATOM   2356  CB  ILE   140     -30.321 -28.223  16.894  1.00 52.57           C  
ATOM   2357  CG1 ILE   140     -31.370 -28.115  18.016  1.00 50.46           C  
ATOM   2358  CD1 ILE   140     -31.233 -29.136  19.121  1.00 50.31           C  
ATOM   2359  CG2 ILE   140     -28.886 -28.042  17.403  1.00 49.16           C  
ATOM   2360  C   ILE   140     -32.072 -27.438  15.228  1.00 53.15           C  
ATOM   2361  O   ILE   140     -32.980 -26.626  15.473  1.00 54.39           O  
ATOM   2362  N   SER   141     -32.288 -28.544  14.521  1.00 51.34           N  
ATOM   2363  CA  SER   141     -33.649 -28.880  14.134  1.00 49.78           C  
ATOM   2364  CB  SER   141     -33.873 -28.602  12.657  1.00 47.58           C  
ATOM   2365  OG  SER   141     -33.020 -29.391  11.875  1.00 52.50           O  
ATOM   2366  C   SER   141     -34.015 -30.322  14.472  1.00 49.85           C  
ATOM   2367  O   SER   141     -33.152 -31.160  14.743  1.00 51.45           O  
ATOM   2368  N   LYS   142     -35.304 -30.609  14.475  1.00 48.16           N  
ATOM   2369  CA  LYS   142     -35.737 -31.993  14.412  1.00 47.37           C  
ATOM   2370  CB  LYS   142     -36.346 -32.422  15.743  1.00 47.41           C  
ATOM   2371  CG  LYS   142     -35.316 -32.537  16.860  1.00 47.19           C  
ATOM   2372  CD  LYS   142     -34.342 -33.648  16.548  1.00 43.53           C  
ATOM   2373  CE  LYS   142     -33.274 -33.717  17.562  1.00 47.73           C  
ATOM   2374  NZ  LYS   142     -32.273 -34.713  17.167  1.00 48.82           N  
ATOM   2375  C   LYS   142     -36.728 -32.125  13.276  1.00 47.80           C  
ATOM   2376  O   LYS   142     -37.497 -31.202  13.034  1.00 48.97           O  
ATOM   2377  N   PRO   143     -36.738 -33.274  12.577  1.00 48.61           N  
ATOM   2378  CA  PRO   143     -37.716 -33.399  11.502  1.00 47.89           C  
ATOM   2379  CB  PRO   143     -37.321 -34.714  10.821  1.00 49.14           C  
ATOM   2380  CG  PRO   143     -36.032 -35.122  11.405  1.00 50.27           C  
ATOM   2381  CD  PRO   143     -35.966 -34.513  12.758  1.00 48.34           C  
ATOM   2382  C   PRO   143     -39.127 -33.556  12.100  1.00 48.96           C  
ATOM   2383  O   PRO   143     -39.270 -34.143  13.179  1.00 47.48           O  
ATOM   2384  N   ILE   144     -40.156 -33.040  11.423  1.00 48.74           N  
ATOM   2385  CA  ILE   144     -41.517 -33.289  11.867  1.00 46.74           C  
ATOM   2386  CB  ILE   144     -42.472 -32.127  11.522  1.00 45.78           C  
ATOM   2387  CG1 ILE   144     -41.951 -30.828  12.131  1.00 44.71           C  
ATOM   2388  CD1 ILE   144     -42.820 -29.613  11.765  1.00 46.74           C  
ATOM   2389  CG2 ILE   144     -43.862 -32.381  12.092  1.00 37.44           C  
ATOM   2390  C   ILE   144     -42.018 -34.634  11.319  1.00 49.22           C  
ATOM   2391  O   ILE   144     -42.501 -34.723  10.175  1.00 49.54           O  
ATOM   2392  N   HIS   145     -41.901 -35.668  12.157  1.00 48.28           N  
ATOM   2393  CA  HIS   145     -42.348 -37.042  11.841  1.00 50.71           C  
ATOM   2394  CB  HIS   145     -43.857 -37.150  11.576  1.00 48.39           C  
ATOM   2395  CG  HIS   145     -44.717 -36.301  12.464  1.00 51.57           C  
ATOM   2396  ND1 HIS   145     -44.745 -36.432  13.836  1.00 50.86           N  
ATOM   2397  CE1 HIS   145     -45.610 -35.574  14.341  1.00 43.42           C  
ATOM   2398  NE2 HIS   145     -46.159 -34.904  13.345  1.00 46.64           N  
ATOM   2399  CD2 HIS   145     -45.631 -35.349  12.162  1.00 50.88           C  
ATOM   2400  C   HIS   145     -41.646 -37.628  10.636  1.00 52.43           C  
ATOM   2401  O   HIS   145     -42.296 -38.244   9.797  1.00 54.54           O  
ATOM   2402  N   GLN   146     -40.336 -37.442  10.536  1.00 52.92           N  
ATOM   2403  CA  GLN   146     -39.592 -37.881   9.349  1.00 55.41           C  
ATOM   2404  CB  GLN   146     -39.410 -36.722   8.359  1.00 53.53           C  
ATOM   2405  CG  GLN   146     -40.630 -36.348   7.574  1.00 55.08           C  
ATOM   2406  CD  GLN   146     -40.487 -35.032   6.825  1.00 56.54           C  
ATOM   2407  OE1 GLN   146     -39.637 -34.174   7.132  1.00 58.07           O  
ATOM   2408  NE2 GLN   146     -41.331 -34.862   5.839  1.00 57.67           N  
ATOM   2409  C   GLN   146     -38.220 -38.398   9.751  1.00 55.25           C  
ATOM   2410  O   GLN   146     -37.792 -38.164  10.873  1.00 55.18           O  
ATOM   2411  N   HIS   147     -37.550 -39.080   8.823  1.00 56.32           N  
ATOM   2412  CA  HIS   147     -36.165 -39.498   8.982  1.00 59.99           C  
ATOM   2413  CB  HIS   147     -35.621 -40.136   7.690  1.00 60.94           C  
ATOM   2414  CG  HIS   147     -36.204 -41.471   7.365  1.00 65.97           C  
ATOM   2415  ND1 HIS   147     -36.970 -42.195   8.253  1.00 72.70           N  
ATOM   2416  CE1 HIS   147     -37.334 -43.338   7.694  1.00 75.02           C  
ATOM   2417  NE2 HIS   147     -36.824 -43.385   6.475  1.00 74.43           N  
ATOM   2418  CD2 HIS   147     -36.103 -42.235   6.249  1.00 74.39           C  
ATOM   2419  C   HIS   147     -35.246 -38.334   9.381  1.00 59.32           C  
ATOM   2420  O   HIS   147     -35.282 -37.252   8.774  1.00 58.68           O  
ATOM   2421  N   GLU   148     -34.464 -38.563  10.436  1.00 60.00           N  
ATOM   2422  CA  GLU   148     -33.312 -37.729  10.771  1.00 60.66           C  
ATOM   2423  CB  GLU   148     -33.266 -37.478  12.272  1.00 57.72           C  
ATOM   2424  CG  GLU   148     -32.379 -36.290  12.637  1.00 60.69           C  
ATOM   2425  CD  GLU   148     -32.251 -36.078  14.125  1.00 60.94           C  
ATOM   2426  OE1 GLU   148     -32.855 -36.869  14.889  1.00 66.02           O  
ATOM   2427  OE2 GLU   148     -31.542 -35.131  14.528  1.00 56.46           O  
ATOM   2428  C   GLU   148     -32.038 -38.457  10.308  1.00 63.17           C  
ATOM   2429  O   GLU   148     -31.486 -39.293  11.023  1.00 65.37           O  
ATOM   2430  N   ASP   149     -31.601 -38.179   9.093  1.00 64.91           N  
ATOM   2431  CA  ASP   149     -30.511 -38.938   8.483  1.00 69.10           C  
ATOM   2432  CB  ASP   149     -30.521 -38.711   6.977  1.00 71.16           C  
ATOM   2433  CG  ASP   149     -31.526 -39.594   6.254  1.00 77.97           C  
ATOM   2434  OD1 ASP   149     -32.290 -40.349   6.911  1.00 81.56           O  
ATOM   2435  OD2 ASP   149     -31.535 -39.541   5.005  1.00 83.32           O  
ATOM   2436  C   ASP   149     -29.162 -38.512   9.026  1.00 69.28           C  
ATOM   2437  O   ASP   149     -28.202 -39.270   9.020  1.00 72.00           O  
ATOM   2438  N   ARG   150     -29.136 -37.285   9.519  1.00 68.22           N  
ATOM   2439  CA  ARG   150     -27.950 -36.510   9.775  1.00 68.79           C  
ATOM   2440  CB  ARG   150     -27.475 -35.918   8.451  1.00 69.51           C  
ATOM   2441  CG  ARG   150     -26.577 -34.704   8.486  1.00 70.21           C  
ATOM   2442  CD  ARG   150     -26.370 -34.182   7.042  1.00 72.26           C  
ATOM   2443  NE  ARG   150     -25.942 -35.232   6.111  1.00 73.68           N  
ATOM   2447  C   ARG   150     -28.481 -35.431  10.690  1.00 66.74           C  
ATOM   2448  O   ARG   150     -29.646 -35.030  10.583  1.00 65.37           O  
ATOM   2449  N   CYS   151     -27.648 -34.988  11.617  1.00 67.67           N  
ATOM   2450  CA  CYS   151     -28.016 -33.908  12.512  1.00 64.82           C  
ATOM   2451  CB  CYS   151     -27.158 -33.980  13.774  1.00 65.20           C  
ATOM   2452  SG  CYS   151     -26.876 -32.371  14.535  1.00 71.95           S  
ATOM   2453  C   CYS   151     -27.840 -32.566  11.782  1.00 62.66           C  
ATOM   2454  O   CYS   151     -26.786 -32.310  11.183  1.00 63.69           O  
ATOM   2455  N   LEU   152     -28.863 -31.719  11.819  1.00 57.45           N  
ATOM   2456  CA  LEU   152     -28.754 -30.404  11.198  1.00 55.46           C  
ATOM   2457  CB  LEU   152     -29.965 -30.112  10.314  1.00 53.30           C  
ATOM   2458  CG  LEU   152     -30.230 -31.058   9.136  1.00 57.13           C  
ATOM   2459  CD1 LEU   152     -31.555 -30.734   8.480  1.00 54.70           C  
ATOM   2460  CD2 LEU   152     -29.124 -31.036   8.088  1.00 55.89           C  
ATOM   2461  C   LEU   152     -28.583 -29.329  12.283  1.00 54.42           C  
ATOM   2462  O   LEU   152     -29.484 -29.115  13.102  1.00 55.22           O  
ATOM   2463  N   ARG   153     -27.428 -28.663  12.295  1.00 52.31           N  
ATOM   2464  CA  ARG   153     -27.144 -27.612  13.278  1.00 51.68           C  
ATOM   2465  CB  ARG   153     -26.373 -28.172  14.477  1.00 52.51           C  
ATOM   2466  CG  ARG   153     -25.083 -28.892  14.125  1.00 50.80           C  
ATOM   2467  CD  ARG   153     -24.542 -29.622  15.333  1.00 53.69           C  
ATOM   2468  NE  ARG   153     -23.105 -29.850  15.200  1.00 63.01           N  
ATOM   2469  CZ  ARG   153     -22.323 -30.400  16.126  1.00 64.47           C  
ATOM   2470  NH1 ARG   153     -21.023 -30.546  15.886  1.00 68.07           N  
ATOM   2471  NH2 ARG   153     -22.829 -30.798  17.284  1.00 63.45           N  
ATOM   2472  C   ARG   153     -26.386 -26.451  12.648  1.00 52.21           C  
ATOM   2473  O   ARG   153     -25.879 -26.578  11.547  1.00 53.85           O  
ATOM   2474  N   LEU   154     -26.319 -25.315  13.336  1.00 51.57           N  
ATOM   2475  CA  LEU   154     -25.680 -24.130  12.766  1.00 52.35           C  
ATOM   2476  CB  LEU   154     -26.721 -23.231  12.090  1.00 52.38           C  
ATOM   2477  CG  LEU   154     -26.467 -22.286  10.901  1.00 52.33           C  
ATOM   2478  CD1 LEU   154     -27.189 -20.956  11.106  1.00 47.55           C  
ATOM   2479  CD2 LEU   154     -25.026 -22.063  10.579  1.00 48.79           C  
ATOM   2480  C   LEU   154     -25.072 -23.360  13.896  1.00 52.80           C  
ATOM   2481  O   LEU   154     -25.697 -23.188  14.942  1.00 53.27           O  
ATOM   2482  N   LYS   155     -23.857 -22.884  13.695  1.00 54.03           N  
ATOM   2483  CA  LYS   155     -23.210 -22.072  14.698  1.00 53.75           C  
ATOM   2484  CB  LYS   155     -21.808 -22.611  14.979  1.00 55.85           C  
ATOM   2485  CG  LYS   155     -20.962 -21.753  15.901  1.00 57.65           C  
ATOM   2486  CD  LYS   155     -19.797 -22.552  16.432  1.00 58.41           C  
ATOM   2487  CE  LYS   155     -19.025 -21.762  17.482  1.00 61.53           C  
ATOM   2488  NZ  LYS   155     -17.729 -22.434  17.833  1.00 61.73           N  
ATOM   2489  C   LYS   155     -23.165 -20.676  14.117  1.00 53.84           C  
ATOM   2490  O   LYS   155     -22.699 -20.499  12.988  1.00 55.18           O  
ATOM   2491  N   VAL   156     -23.674 -19.700  14.862  1.00 52.45           N  
ATOM   2492  CA  VAL   156     -23.556 -18.300  14.472  1.00 54.93           C  
ATOM   2493  CB  VAL   156     -24.930 -17.581  14.360  1.00 54.69           C  
ATOM   2494  CG1 VAL   156     -24.741 -16.232  13.689  1.00 56.14           C  
ATOM   2495  CG2 VAL   156     -25.951 -18.416  13.576  1.00 49.56           C  
ATOM   2496  C   VAL   156     -22.632 -17.561  15.461  1.00 58.78           C  
ATOM   2497  O   VAL   156     -22.924 -17.498  16.665  1.00 60.84           O  
ATOM   2498  N   THR   157     -21.513 -17.033  14.962  1.00 58.75           N  
ATOM   2499  CA  THR   157     -20.559 -16.320  15.798  1.00 60.81           C  
ATOM   2500  CB  THR   157     -19.108 -16.854  15.583  1.00 62.18           C  
ATOM   2501  OG1 THR   157     -19.027 -18.220  16.000  1.00 58.31           O  
ATOM   2502  CG2 THR   157     -18.095 -16.036  16.379  1.00 62.08           C  
ATOM   2503  C   THR   157     -20.625 -14.811  15.527  1.00 63.37           C  
ATOM   2504  O   THR   157     -20.504 -14.370  14.388  1.00 63.80           O  
ATOM   2505  N   VAL   158     -20.828 -14.022  16.576  1.00 66.77           N  
ATOM   2506  CA  VAL   158     -20.822 -12.551  16.450  1.00 70.21           C  
ATOM   2507  CB  VAL   158     -21.831 -11.874  17.422  1.00 69.55           C  
ATOM   2508  CG1 VAL   158     -21.914 -10.371  17.168  1.00 69.21           C  
ATOM   2509  CG2 VAL   158     -23.219 -12.517  17.312  1.00 67.10           C  
ATOM   2510  C   VAL   158     -19.409 -11.981  16.672  1.00 73.89           C  
ATOM   2511  O   VAL   158     -18.845 -12.102  17.757  1.00 75.32           O  
ATOM   2512  N   SER   159     -18.835 -11.372  15.644  1.00 77.42           N  
ATOM   2513  CA  SER   159     -17.496 -10.820  15.775  1.00 83.01           C  
ATOM   2514  CB  SER   159     -16.788 -10.776  14.420  1.00 85.68           C  
ATOM   2515  OG  SER   159     -17.666 -10.308  13.413  1.00 90.57           O  
ATOM   2516  C   SER   159     -17.541  -9.437  16.394  1.00 84.74           C  
ATOM   2517  O   SER   159     -18.626  -8.866  16.577  1.00 83.29           O  
ATOM   2518  N   GLY   160     -16.354  -8.920  16.723  1.00 87.89           N  
ATOM   2519  CA  GLY   160     -16.183  -7.557  17.229  1.00 90.83           C  
ATOM   2520  C   GLY   160     -15.287  -7.479  18.454  1.00 93.62           C  
ATOM   2521  O   GLY   160     -15.753  -7.589  19.593  1.00 92.80           O  
END
