
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  880),  selected   98 , name 1pcs_A
# Molecule2: number of CA atoms  130 ( 1084),  selected  130 , name T0390.pdb
# PARAMETERS: 1pcs_A.T0390.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A      29           -
LGA    A    -2_A      D      30          2.841
LGA    N    -1_A      R      31          1.186
LGA    A     1_A      H      32          0.586
LGA    T     2_A      T      33          1.132
LGA    V     3_A      V      34          0.923
LGA    K     4_A      F      35          0.930
LGA    M     5_A      W      36          1.640
LGA    G     6_A      N      37          1.416
LGA    S     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    G    10_A      S      38           #
LGA    A    11_A      S      39          1.804
LGA    L    12_A      N      40           #
LGA    V    13_A      P      41           #
LGA    -       -      K      42           -
LGA    F    14_A      F      43           #
LGA    E    15_A      R      44           -
LGA    P    16_A      N      45           -
LGA    -       -      E      46           -
LGA    -       -      D      47           -
LGA    S    17_A      Y      48          3.623
LGA    T    18_A      T      49          2.326
LGA    V    19_A      I      50          1.664
LGA    T    20_A      H      51          1.291
LGA    I    21_A      V      52          0.950
LGA    K    22_A      Q      53          0.472
LGA    A    23_A      L      54          1.091
LGA    G    24_A      N      55          1.468
LGA    E    25_A      D      56          1.510
LGA    E    26_A      Y      57          1.331
LGA    V    27_A      V      58          0.819
LGA    K    28_A      D      59          1.035
LGA    W    29_A      I      60          1.142
LGA    V    30_A      I      61          1.381
LGA    N    31_A      C      62          1.649
LGA    N    32_A      P      63          2.952
LGA    K    33_A      H      64          4.913
LGA    -       -      Y      65           -
LGA    -       -      E      66           -
LGA    -       -      S      69           -
LGA    -       -      V      70           -
LGA    -       -      A      71           -
LGA    -       -      D      72           -
LGA    -       -      A      73           -
LGA    -       -      A      74           -
LGA    L    34_A      M      75          4.134
LGA    S    35_A      E      76          1.934
LGA    P    36_A      Q      77          0.855
LGA    H    37_A      Y      78          2.135
LGA    N    38_A      I      79          2.919
LGA    I    39_A      L      80          1.594
LGA    V    40_A      Y      81          0.529
LGA    F    41_A      L      82          1.683
LGA    D    42_A      V      83          1.746
LGA    A    43_A      E      84          1.732
LGA    D    44_A      H      85          2.742
LGA    G    45_A      E      86           -
LGA    V    46_A      E      87           -
LGA    P    47_A      Y      88           -
LGA    -       -      Q      89           -
LGA    -       -      L      90           -
LGA    -       -      C      91           -
LGA    -       -      Q      92           -
LGA    -       -      P      93           -
LGA    A    48_A      Q      94           #
LGA    D    50_A      S      95           -
LGA    T    51_A      K      96           -
LGA    A    52_A      D      97           #
LGA    A    53_A      Q      98          3.855
LGA    K    54_A      -       -           -
LGA    L    55_A      -       -           -
LGA    S    56_A      V      99          4.779
LGA    H    57_A      R     100          2.102
LGA    K    58_A      W     101          3.537
LGA    G    61_A      Q     102          2.636
LGA    L    62_A      C     103          3.241
LGA    L    63_A      N     104          2.814
LGA    F    64_A      R     105          2.205
LGA    -       -      P     106           -
LGA    A    65_A      S     107          2.668
LGA    A    66_A      A     108          6.104
LGA    -       -      K     109           -
LGA    -       -      H     110           -
LGA    G    67_A      G     111          3.280
LGA    E    68_A      P     112          2.737
LGA    -       -      E     113           -
LGA    S    69_A      K     114          0.759
LGA    F    70_A      L     115          1.256
LGA    T    71_A      S     116          1.089
LGA    S    72_A      E     117          1.172
LGA    T    73_A      K     118          1.283
LGA    F    74_A      F     119          1.442
LGA    T    75_A      Q     120          2.261
LGA    -       -      R     121           -
LGA    -       -      F     122           -
LGA    -       -      T     123           -
LGA    -       -      P     124           -
LGA    -       -      F     125           -
LGA    -       -      T     126           -
LGA    -       -      L     127           -
LGA    -       -      G     128           -
LGA    -       -      K     129           -
LGA    -       -      E     130           -
LGA    E    76_A      F     131          1.961
LGA    P    77_A      K     132          2.913
LGA    -       -      E     133           -
LGA    -       -      G     134           -
LGA    G    78_A      H     135          1.673
LGA    T    79_A      S     136          1.138
LGA    Y    80_A      Y     137          1.236
LGA    T    81_A      Y     138          1.748
LGA    Y    82_A      Y     139          1.410
LGA    Y    83_A      I     140          1.094
LGA    C    84_A      S     141          1.184
LGA    E    85_A      K     142          1.486
LGA    P    86_A      P     143          1.566
LGA    H    87_A      I     144           #
LGA    R    88_A      H     145           -
LGA    -       -      Q     146           -
LGA    -       -      H     147           -
LGA    G    89_A      E     148          3.583
LGA    A    90_A      D     149          2.538
LGA    G    91_A      R     150          2.673
LGA    -       -      C     151           -
LGA    M    92_A      L     152          1.495
LGA    V    93_A      R     153          1.507
LGA    G    94_A      L     154          1.481
LGA    K    95_A      K     155          1.583
LGA    V    96_A      V     156          1.242
LGA    V    97_A      T     157          1.349
LGA    V    98_A      V     158          1.597
LGA    E    99_A      S     159          1.766
LGA    -       -      G     160           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98  130    5.0     78    2.21    16.67     41.735     3.370

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.233276 * X  +  -0.404966 * Y  +  -0.884073 * Z  +  20.301167
  Y_new =  -0.914381 * X  +  -0.218016 * Y  +   0.341140 * Z  + -18.904007
  Z_new =  -0.330892 * X  +   0.887959 * Y  +  -0.319435 * Z  +  18.304213 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.916122   -1.225470  [ DEG:   109.7857    -70.2143 ]
  Theta =   0.337248    2.804344  [ DEG:    19.3229    160.6771 ]
  Phi   =  -1.820587    1.321005  [ DEG:  -104.3120     75.6880 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1pcs_A                                        
REMARK     2: T0390.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1pcs_A.T0390.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98  130   5.0   78   2.21   16.67  41.735
REMARK  ---------------------------------------------------------- 
MOLECULE 1pcs_A
HEADER    ELECTRON TRANSPORT                      17-JUN-97   1PCS              
TITLE     THE 2.15 A CRYSTAL STRUCTURE OF A TRIPLE MUTANT                       
TITLE    2 PLASTOCYANIN FROM THE CYANOBACTERIUM SYNECHOCYSTIS SP. PCC           
TITLE    3 6803                                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PLASTOCYANIN;                                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SYNECHOCYSTIS SP.;                              
SOURCE   3 STRAIN: PCC 6803;                                                    
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: DH-5A;                                     
SOURCE   6 EXPRESSION_SYSTEM_CELLULAR_LOCATION: PERIPLASM;                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR: PBLUESCRIPT II (SK+)                       
KEYWDS    ELECTRON TRANSPORT, PLASTOCYANIN                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.ROMERO,B.DE LA CERDA,P.F.VARELA,J.A.NAVARRO,M.HERVAS,               
AUTHOR   2 M.A.DE LA ROSA                                                       
REVDAT   1   17-DEC-97 1PCS    0                                                
JRNL        AUTH   A.ROMERO,B.DE LA CERDA,P.F.VARELA,J.A.NAVARRO,               
JRNL        AUTH 2 M.HERVAS,M.A.DE LA ROSA                                      
JRNL        TITL   THE 2.15 A CRYSTAL STRUCTURE OF A TRIPLE MUTANT              
JRNL        TITL 2 PLASTOCYANIN FROM THE CYANOBACTERIUM SYNECHOCYSTIS           
JRNL        TITL 3 SP. PCC 6803.                                                
JRNL        REF    J.MOL.BIOL.                   V. 275   327 1998              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.15 ANGSTROMS.                                          
DBREF  1PCS A   -2    99  UNP    P21697   PLAS_SYNY3      29    126             
SEQRES   1 A   98  ALA ASN ALA THR VAL LYS MET GLY SER ASP SER GLY ALA          
SEQRES   2 A   98  LEU VAL PHE GLU PRO SER THR VAL THR ILE LYS ALA GLY          
SEQRES   3 A   98  GLU GLU VAL LYS TRP VAL ASN ASN LYS LEU SER PRO HIS          
SEQRES   4 A   98  ASN ILE VAL PHE ASP ALA ASP GLY VAL PRO ALA ASP THR          
SEQRES   5 A   98  ALA ALA LYS LEU SER HIS LYS GLY LEU LEU PHE ALA ALA          
SEQRES   6 A   98  GLY GLU SER PHE THR SER THR PHE THR GLU PRO GLY THR          
SEQRES   7 A   98  TYR THR TYR TYR CYS GLU PRO HIS ARG GLY ALA GLY MET          
SEQRES   8 A   98  VAL GLY LYS VAL VAL VAL GLU                                  
HET     CU    275       1                                                       
HETNAM      CU COPPER (II) ION                                                  
FORMUL   2   CU    CU 2+                                                        
FORMUL   3  HOH   *75(H2 O)                                                     
CRYST1   34.300   34.300  111.800  90.00  90.00 120.00 P 32 2 1      6          
ATOM      1  N   ALA A  -2     -22.721  -9.196   7.075  1.00 19.58           N  
ATOM      2  CA  ALA A  -2     -23.951  -8.741   6.371  1.00 20.93           C  
ATOM      3  C   ALA A  -2     -25.082  -9.669   6.788  1.00 21.42           C  
ATOM      4  O   ALA A  -2     -24.834 -10.686   7.436  1.00 20.85           O  
ATOM      5  CB  ALA A  -2     -23.744  -8.811   4.868  1.00 21.51           C  
ATOM      6  H1  ALA A  -2     -22.658 -10.204   6.799  1.00 15.00           H  
ATOM      7  H2  ALA A  -2     -21.896  -8.645   6.789  1.00 15.00           H  
ATOM      8  H3  ALA A  -2     -22.933  -9.164   8.085  1.00 15.00           H  
ATOM      9  N   ASN A  -1     -26.317  -9.291   6.472  1.00 21.57           N  
ATOM     10  CA  ASN A  -1     -27.469 -10.124   6.799  1.00 21.74           C  
ATOM     11  C   ASN A  -1     -27.289 -11.420   6.024  1.00 19.62           C  
ATOM     12  O   ASN A  -1     -26.764 -11.414   4.913  1.00 20.65           O  
ATOM     13  CB  ASN A  -1     -28.780  -9.434   6.407  1.00 23.15           C  
ATOM     14  CG  ASN A  -1     -29.108  -8.249   7.305  1.00 26.97           C  
ATOM     15  OD1 ASN A  -1     -28.714  -8.207   8.471  1.00 25.94           O  
ATOM     16  ND2 ASN A  -1     -29.837  -7.281   6.765  1.00 29.91           N  
ATOM     17  H   ASN A  -1     -26.453  -8.439   6.007  1.00 15.00           H  
ATOM     18 HD21 ASN A  -1     -30.052  -6.507   7.330  1.00 15.00           H  
ATOM     19 HD22 ASN A  -1     -30.125  -7.378   5.835  1.00 15.00           H  
ATOM     20  N   ALA A   1     -27.680 -12.534   6.626  1.00 17.70           N  
ATOM     21  CA  ALA A   1     -27.510 -13.823   5.983  1.00 14.71           C  
ATOM     22  C   ALA A   1     -28.818 -14.539   5.701  1.00 13.38           C  
ATOM     23  O   ALA A   1     -29.813 -14.350   6.402  1.00 12.47           O  
ATOM     24  CB  ALA A   1     -26.606 -14.703   6.833  1.00 14.40           C  
ATOM     25  H   ALA A   1     -28.115 -12.477   7.507  1.00 15.00           H  
ATOM     26  N   THR A   2     -28.813 -15.343   4.648  1.00 11.60           N  
ATOM     27  CA  THR A   2     -29.974 -16.133   4.279  1.00 11.23           C  
ATOM     28  C   THR A   2     -29.496 -17.572   4.295  1.00  9.81           C  
ATOM     29  O   THR A   2     -28.412 -17.867   3.793  1.00 10.79           O  
ATOM     30  CB  THR A   2     -30.497 -15.767   2.887  1.00 12.44           C  
ATOM     31  OG1 THR A   2     -30.913 -14.399   2.894  1.00 12.56           O  
ATOM     32  CG2 THR A   2     -31.690 -16.646   2.516  1.00 12.55           C  
ATOM     33  H   THR A   2     -28.015 -15.440   4.088  1.00 15.00           H  
ATOM     34  HG1 THR A   2     -31.557 -14.280   3.599  1.00 15.00           H  
ATOM     35  N   VAL A   3     -30.245 -18.432   4.973  1.00  7.06           N  
ATOM     36  CA  VAL A   3     -29.902 -19.844   5.074  1.00  4.99           C  
ATOM     37  C   VAL A   3     -31.053 -20.677   4.531  1.00  4.55           C  
ATOM     38  O   VAL A   3     -32.217 -20.463   4.898  1.00  2.27           O  
ATOM     39  CB  VAL A   3     -29.632 -20.256   6.543  1.00  5.02           C  
ATOM     40  CG1 VAL A   3     -29.171 -21.711   6.609  1.00  2.69           C  
ATOM     41  CG2 VAL A   3     -28.591 -19.346   7.163  1.00  2.00           C  
ATOM     42  H   VAL A   3     -31.076 -18.136   5.400  1.00 15.00           H  
ATOM     43  N   LYS A   4     -30.736 -21.580   3.606  1.00  4.15           N  
ATOM     44  CA  LYS A   4     -31.743 -22.459   3.017  1.00  5.42           C  
ATOM     45  C   LYS A   4     -31.935 -23.653   3.939  1.00  3.47           C  
ATOM     46  O   LYS A   4     -30.958 -24.228   4.431  1.00  2.22           O  
ATOM     47  CB  LYS A   4     -31.288 -23.027   1.671  1.00  3.52           C  
ATOM     48  CG  LYS A   4     -30.725 -22.062   0.663  1.00  7.71           C  
ATOM     49  CD  LYS A   4     -30.186 -22.879  -0.499  1.00 10.57           C  
ATOM     50  CE  LYS A   4     -29.154 -22.128  -1.295  1.00 16.15           C  
ATOM     51  NZ  LYS A   4     -28.424 -23.065  -2.190  1.00 15.19           N  
ATOM     52  H   LYS A   4     -29.810 -21.651   3.308  1.00 15.00           H  
ATOM     53  HZ1 LYS A   4     -29.110 -23.548  -2.799  1.00 15.00           H  
ATOM     54  HZ2 LYS A   4     -27.743 -22.538  -2.771  1.00 15.00           H  
ATOM     55  HZ3 LYS A   4     -27.920 -23.761  -1.609  1.00 15.00           H  
ATOM     56  N   MET A   5     -33.185 -24.021   4.172  1.00  4.81           N  
ATOM     57  CA  MET A   5     -33.482 -25.183   4.994  1.00  5.21           C  
ATOM     58  C   MET A   5     -33.741 -26.281   3.973  1.00  4.31           C  
ATOM     59  O   MET A   5     -34.750 -26.251   3.259  1.00  3.88           O  
ATOM     60  CB  MET A   5     -34.696 -24.915   5.882  1.00  6.71           C  
ATOM     61  CG  MET A   5     -34.430 -23.829   6.915  1.00  8.96           C  
ATOM     62  SD  MET A   5     -35.682 -23.723   8.204  1.00 14.53           S  
ATOM     63  CE  MET A   5     -36.978 -22.972   7.315  1.00  5.37           C  
ATOM     64  H   MET A   5     -33.917 -23.514   3.767  1.00 15.00           H  
ATOM     65  N   GLY A   6     -32.788 -27.204   3.864  1.00  5.16           N  
ATOM     66  CA  GLY A   6     -32.872 -28.272   2.882  1.00  4.60           C  
ATOM     67  C   GLY A   6     -32.068 -27.744   1.700  1.00  8.28           C  
ATOM     68  O   GLY A   6     -32.396 -26.684   1.147  1.00  7.76           O  
ATOM     69  H   GLY A   6     -31.992 -27.142   4.429  1.00 15.00           H  
ATOM     70  N   SER A   7     -30.994 -28.437   1.330  1.00  8.33           N  
ATOM     71  CA  SER A   7     -30.136 -27.984   0.230  1.00 12.13           C  
ATOM     72  C   SER A   7     -30.727 -28.192  -1.164  1.00 12.74           C  
ATOM     73  O   SER A   7     -31.641 -28.999  -1.346  1.00 13.47           O  
ATOM     74  CB  SER A   7     -28.782 -28.690   0.297  1.00 10.35           C  
ATOM     75  OG  SER A   7     -28.939 -30.077   0.062  1.00 10.69           O  
ATOM     76  H   SER A   7     -30.783 -29.282   1.779  1.00 15.00           H  
ATOM     77  HG  SER A   7     -28.060 -30.447  -0.110  1.00 15.00           H  
ATOM     78  N   ASP A   8     -30.197 -27.455  -2.145  1.00 13.84           N  
ATOM     79  CA  ASP A   8     -30.635 -27.590  -3.537  1.00 14.56           C  
ATOM     80  C   ASP A   8     -30.307 -29.008  -4.012  1.00 13.20           C  
ATOM     81  O   ASP A   8     -31.008 -29.570  -4.843  1.00 13.43           O  
ATOM     82  CB  ASP A   8     -29.921 -26.579  -4.448  1.00 13.50           C  
ATOM     83  CG  ASP A   8     -30.412 -25.149  -4.255  1.00 14.61           C  
ATOM     84  OD1 ASP A   8     -31.580 -24.950  -3.867  1.00 13.21           O  
ATOM     85  OD2 ASP A   8     -29.623 -24.213  -4.513  1.00 17.65           O  
ATOM     86  H   ASP A   8     -29.506 -26.802  -1.922  1.00 15.00           H  
ATOM     87  N   SER A   9     -29.228 -29.575  -3.482  1.00 15.94           N  
ATOM     88  CA  SER A   9     -28.819 -30.927  -3.837  1.00 18.36           C  
ATOM     89  C   SER A   9     -29.715 -31.980  -3.176  1.00 18.75           C  
ATOM     90  O   SER A   9     -29.488 -33.179  -3.329  1.00 23.16           O  
ATOM     91  CB  SER A   9     -27.347 -31.154  -3.474  1.00 17.01           C  
ATOM     92  OG  SER A   9     -27.079 -30.831  -2.117  1.00 21.00           O  
ATOM     93  H   SER A   9     -28.672 -29.116  -2.823  1.00 15.00           H  
ATOM     94  HG  SER A   9     -26.146 -31.044  -1.997  1.00 15.00           H  
ATOM     95  N   GLY A  10     -30.728 -31.529  -2.442  1.00 17.92           N  
ATOM     96  CA  GLY A  10     -31.648 -32.451  -1.799  1.00 16.58           C  
ATOM     97  C   GLY A  10     -31.144 -33.189  -0.570  1.00 15.25           C  
ATOM     98  O   GLY A  10     -31.376 -34.393  -0.427  1.00 16.39           O  
ATOM     99  H   GLY A  10     -30.883 -30.578  -2.299  1.00 15.00           H  
ATOM    100  N   ALA A  11     -30.478 -32.469   0.326  1.00 13.06           N  
ATOM    101  CA  ALA A  11     -29.962 -33.048   1.561  1.00 12.04           C  
ATOM    102  C   ALA A  11     -30.597 -32.347   2.770  1.00 10.41           C  
ATOM    103  O   ALA A  11     -30.934 -31.159   2.708  1.00  8.63           O  
ATOM    104  CB  ALA A  11     -28.437 -32.923   1.608  1.00 10.97           C  
ATOM    105  H   ALA A  11     -30.330 -31.513   0.166  1.00 15.00           H  
ATOM    106  N   LEU A  12     -30.788 -33.091   3.855  1.00  9.90           N  
ATOM    107  CA  LEU A  12     -31.369 -32.539   5.076  1.00  9.63           C  
ATOM    108  C   LEU A  12     -30.299 -31.737   5.810  1.00  9.03           C  
ATOM    109  O   LEU A  12     -29.743 -32.188   6.817  1.00  5.72           O  
ATOM    110  CB  LEU A  12     -31.906 -33.660   5.978  1.00 10.29           C  
ATOM    111  CG  LEU A  12     -33.170 -34.378   5.503  1.00  9.72           C  
ATOM    112  CD1 LEU A  12     -33.502 -35.520   6.444  1.00 11.87           C  
ATOM    113  CD2 LEU A  12     -34.330 -33.399   5.430  1.00  9.55           C  
ATOM    114  H   LEU A  12     -30.502 -34.029   3.845  1.00 15.00           H  
ATOM    115  N   VAL A  13     -30.008 -30.549   5.292  1.00  5.00           N  
ATOM    116  CA  VAL A  13     -28.994 -29.691   5.879  1.00  8.39           C  
ATOM    117  C   VAL A  13     -29.367 -28.215   5.766  1.00  6.89           C  
ATOM    118  O   VAL A  13     -30.269 -27.835   5.013  1.00  8.96           O  
ATOM    119  CB  VAL A  13     -27.598 -29.867   5.179  1.00  7.14           C  
ATOM    120  CG1 VAL A  13     -27.096 -31.300   5.281  1.00  7.17           C  
ATOM    121  CG2 VAL A  13     -27.673 -29.432   3.719  1.00  8.82           C  
ATOM    122  H   VAL A  13     -30.491 -30.228   4.501  1.00 15.00           H  
ATOM    123  N   PHE A  14     -28.700 -27.402   6.573  1.00  7.70           N  
ATOM    124  CA  PHE A  14     -28.876 -25.964   6.538  1.00  6.46           C  
ATOM    125  C   PHE A  14     -27.739 -25.540   5.625  1.00  5.07           C  
ATOM    126  O   PHE A  14     -26.591 -25.947   5.825  1.00  6.55           O  
ATOM    127  CB  PHE A  14     -28.703 -25.354   7.934  1.00  5.23           C  
ATOM    128  CG  PHE A  14     -29.888 -25.563   8.831  1.00  4.89           C  
ATOM    129  CD1 PHE A  14     -31.066 -24.857   8.614  1.00  4.83           C  
ATOM    130  CD2 PHE A  14     -29.836 -26.479   9.871  1.00  2.18           C  
ATOM    131  CE1 PHE A  14     -32.178 -25.066   9.421  1.00  6.19           C  
ATOM    132  CE2 PHE A  14     -30.939 -26.694  10.683  1.00  3.40           C  
ATOM    133  CZ  PHE A  14     -32.114 -25.987  10.458  1.00  4.75           C  
ATOM    134  H   PHE A  14     -28.049 -27.780   7.199  1.00 15.00           H  
ATOM    135  N   GLU A  15     -28.064 -24.780   4.591  1.00  5.69           N  
ATOM    136  CA  GLU A  15     -27.055 -24.334   3.641  1.00  5.49           C  
ATOM    137  C   GLU A  15     -27.097 -22.816   3.498  1.00  5.06           C  
ATOM    138  O   GLU A  15     -28.083 -22.263   3.012  1.00  4.82           O  
ATOM    139  CB  GLU A  15     -27.297 -25.010   2.283  1.00  8.78           C  
ATOM    140  CG  GLU A  15     -26.336 -24.603   1.165  1.00 13.68           C  
ATOM    141  CD  GLU A  15     -24.883 -24.937   1.466  1.00 16.79           C  
ATOM    142  OE1 GLU A  15     -24.576 -26.107   1.773  1.00 21.93           O  
ATOM    143  OE2 GLU A  15     -24.042 -24.024   1.379  1.00 21.55           O  
ATOM    144  H   GLU A  15     -28.999 -24.505   4.464  1.00 15.00           H  
ATOM    145  N   PRO A  16     -26.028 -22.120   3.915  1.00  5.14           N  
ATOM    146  CA  PRO A  16     -24.804 -22.667   4.505  1.00  5.04           C  
ATOM    147  C   PRO A  16     -24.988 -23.043   5.977  1.00  6.61           C  
ATOM    148  O   PRO A  16     -25.726 -22.382   6.705  1.00  5.47           O  
ATOM    149  CB  PRO A  16     -23.812 -21.521   4.326  1.00  6.91           C  
ATOM    150  CG  PRO A  16     -24.667 -20.321   4.482  1.00  6.03           C  
ATOM    151  CD  PRO A  16     -25.907 -20.667   3.699  1.00  6.43           C  
ATOM    152  N   SER A  17     -24.323 -24.113   6.403  1.00  7.00           N  
ATOM    153  CA  SER A  17     -24.426 -24.600   7.775  1.00  8.91           C  
ATOM    154  C   SER A  17     -23.894 -23.615   8.817  1.00 10.83           C  
ATOM    155  O   SER A  17     -24.406 -23.554   9.933  1.00 14.18           O  
ATOM    156  CB  SER A  17     -23.716 -25.946   7.905  1.00  7.33           C  
ATOM    157  OG  SER A  17     -22.408 -25.870   7.370  1.00 13.00           O  
ATOM    158  H   SER A  17     -23.743 -24.587   5.766  1.00 15.00           H  
ATOM    159  HG  SER A  17     -22.429 -26.041   6.415  1.00 15.00           H  
ATOM    160  N   THR A  18     -22.864 -22.857   8.457  1.00  9.64           N  
ATOM    161  CA  THR A  18     -22.289 -21.868   9.358  1.00  8.06           C  
ATOM    162  C   THR A  18     -22.293 -20.511   8.668  1.00  9.46           C  
ATOM    163  O   THR A  18     -21.892 -20.402   7.507  1.00  7.67           O  
ATOM    164  CB  THR A  18     -20.824 -22.209   9.742  1.00  7.81           C  
ATOM    165  OG1 THR A  18     -20.771 -23.487  10.391  1.00 11.70           O  
ATOM    166  CG2 THR A  18     -20.259 -21.151  10.684  1.00  8.05           C  
ATOM    167  H   THR A  18     -22.466 -22.946   7.569  1.00 15.00           H  
ATOM    168  HG1 THR A  18     -19.848 -23.735  10.465  1.00 15.00           H  
ATOM    169  N   VAL A  19     -22.808 -19.499   9.365  1.00  7.93           N  
ATOM    170  CA  VAL A  19     -22.836 -18.133   8.856  1.00  8.15           C  
ATOM    171  C   VAL A  19     -22.240 -17.224   9.922  1.00  8.78           C  
ATOM    172  O   VAL A  19     -22.302 -17.524  11.121  1.00  4.91           O  
ATOM    173  CB  VAL A  19     -24.269 -17.628   8.530  1.00  9.95           C  
ATOM    174  CG1 VAL A  19     -24.848 -18.380   7.346  1.00 14.19           C  
ATOM    175  CG2 VAL A  19     -25.172 -17.759   9.741  1.00 13.21           C  
ATOM    176  H   VAL A  19     -23.182 -19.663  10.260  1.00 15.00           H  
ATOM    177  N   THR A  20     -21.628 -16.135   9.483  1.00  8.07           N  
ATOM    178  CA  THR A  20     -21.034 -15.178  10.398  1.00  7.35           C  
ATOM    179  C   THR A  20     -21.617 -13.806  10.121  1.00  6.61           C  
ATOM    180  O   THR A  20     -21.616 -13.342   8.980  1.00  6.63           O  
ATOM    181  CB  THR A  20     -19.518 -15.130  10.243  1.00  8.73           C  
ATOM    182  OG1 THR A  20     -18.985 -16.442  10.459  1.00 12.12           O  
ATOM    183  CG2 THR A  20     -18.908 -14.168  11.262  1.00 11.14           C  
ATOM    184  H   THR A  20     -21.568 -15.956   8.519  1.00 15.00           H  
ATOM    185  HG1 THR A  20     -19.350 -16.736  11.304  1.00 15.00           H  
ATOM    186  N   ILE A  21     -22.174 -13.193  11.158  1.00  5.08           N  
ATOM    187  CA  ILE A  21     -22.762 -11.873  11.036  1.00  6.70           C  
ATOM    188  C   ILE A  21     -22.228 -10.942  12.125  1.00  6.43           C  
ATOM    189  O   ILE A  21     -21.476 -11.357  13.008  1.00  7.35           O  
ATOM    190  CB  ILE A  21     -24.312 -11.915  11.133  1.00  6.49           C  
ATOM    191  CG1 ILE A  21     -24.752 -12.579  12.441  1.00  8.63           C  
ATOM    192  CG2 ILE A  21     -24.911 -12.636   9.936  1.00  7.39           C  
ATOM    193  CD1 ILE A  21     -26.237 -12.449  12.706  1.00  2.83           C  
ATOM    194  H   ILE A  21     -22.155 -13.610  12.046  1.00 15.00           H  
ATOM    195  N   LYS A  22     -22.597  -9.673  12.019  1.00  7.86           N  
ATOM    196  CA  LYS A  22     -22.211  -8.658  12.987  1.00  9.97           C  
ATOM    197  C   LYS A  22     -23.388  -8.492  13.942  1.00  7.96           C  
ATOM    198  O   LYS A  22     -24.548  -8.620  13.528  1.00  8.21           O  
ATOM    199  CB  LYS A  22     -21.931  -7.321  12.287  1.00 11.97           C  
ATOM    200  CG  LYS A  22     -20.632  -7.290  11.494  1.00 17.77           C  
ATOM    201  CD  LYS A  22     -20.216  -5.857  11.177  1.00 23.43           C  
ATOM    202  CE  LYS A  22     -20.807  -5.372   9.869  1.00 28.19           C  
ATOM    203  NZ  LYS A  22     -20.118  -6.027   8.718  1.00 31.47           N  
ATOM    204  H   LYS A  22     -23.206  -9.417  11.318  1.00 15.00           H  
ATOM    205  HZ1 LYS A  22     -19.104  -5.797   8.750  1.00 15.00           H  
ATOM    206  HZ2 LYS A  22     -20.243  -7.056   8.781  1.00 15.00           H  
ATOM    207  HZ3 LYS A  22     -20.523  -5.678   7.826  1.00 15.00           H  
ATOM    208  N   ALA A  23     -23.094  -8.211  15.206  1.00  5.95           N  
ATOM    209  CA  ALA A  23     -24.128  -8.011  16.212  1.00  7.05           C  
ATOM    210  C   ALA A  23     -25.090  -6.959  15.692  1.00  5.94           C  
ATOM    211  O   ALA A  23     -24.667  -5.954  15.128  1.00  7.93           O  
ATOM    212  CB  ALA A  23     -23.505  -7.561  17.530  1.00  5.27           C  
ATOM    213  H   ALA A  23     -22.159  -8.139  15.469  1.00 15.00           H  
ATOM    214  N   GLY A  24     -26.380  -7.212  15.847  1.00  4.80           N  
ATOM    215  CA  GLY A  24     -27.378  -6.279  15.368  1.00  5.37           C  
ATOM    216  C   GLY A  24     -28.002  -6.736  14.063  1.00  6.95           C  
ATOM    217  O   GLY A  24     -29.108  -6.310  13.729  1.00  7.44           O  
ATOM    218  H   GLY A  24     -26.642  -8.030  16.271  1.00 15.00           H  
ATOM    219  N   GLU A  25     -27.309  -7.601  13.324  1.00  8.75           N  
ATOM    220  CA  GLU A  25     -27.832  -8.098  12.051  1.00  9.76           C  
ATOM    221  C   GLU A  25     -28.778  -9.282  12.224  1.00  9.94           C  
ATOM    222  O   GLU A  25     -28.910  -9.841  13.317  1.00  9.33           O  
ATOM    223  CB  GLU A  25     -26.692  -8.453  11.097  1.00  9.57           C  
ATOM    224  CG  GLU A  25     -25.838  -7.254  10.731  1.00 11.97           C  
ATOM    225  CD  GLU A  25     -24.794  -7.561   9.683  1.00 12.08           C  
ATOM    226  OE1 GLU A  25     -24.159  -8.638   9.753  1.00 12.53           O  
ATOM    227  OE2 GLU A  25     -24.605  -6.715   8.787  1.00 14.47           O  
ATOM    228  H   GLU A  25     -26.447  -7.941  13.640  1.00 15.00           H  
ATOM    229  N   GLU A  26     -29.435  -9.671  11.140  1.00  9.80           N  
ATOM    230  CA  GLU A  26     -30.382 -10.766  11.209  1.00 12.44           C  
ATOM    231  C   GLU A  26     -30.076 -11.889  10.239  1.00 11.89           C  
ATOM    232  O   GLU A  26     -29.260 -11.743   9.320  1.00 12.20           O  
ATOM    233  CB  GLU A  26     -31.801 -10.248  10.985  1.00 14.48           C  
ATOM    234  CG  GLU A  26     -32.015  -9.596   9.641  1.00 23.10           C  
ATOM    235  CD  GLU A  26     -33.309  -8.818   9.580  1.00 27.42           C  
ATOM    236  OE1 GLU A  26     -33.422  -7.805  10.304  1.00 30.60           O  
ATOM    237  OE2 GLU A  26     -34.209  -9.211   8.809  1.00 26.67           O  
ATOM    238  H   GLU A  26     -29.259  -9.242  10.274  1.00 15.00           H  
ATOM    239  N   VAL A  27     -30.689 -13.034  10.502  1.00  8.47           N  
ATOM    240  CA  VAL A  27     -30.530 -14.211   9.669  1.00  6.65           C  
ATOM    241  C   VAL A  27     -31.935 -14.651   9.296  1.00  6.57           C  
ATOM    242  O   VAL A  27     -32.837 -14.676  10.140  1.00  5.82           O  
ATOM    243  CB  VAL A  27     -29.833 -15.364  10.429  1.00  6.62           C  
ATOM    244  CG1 VAL A  27     -29.744 -16.596   9.545  1.00  5.44           C  
ATOM    245  CG2 VAL A  27     -28.438 -14.940  10.886  1.00  6.11           C  
ATOM    246  H   VAL A  27     -31.286 -13.093  11.278  1.00 15.00           H  
ATOM    247  N   LYS A  28     -32.142 -14.924   8.019  1.00  5.81           N  
ATOM    248  CA  LYS A  28     -33.438 -15.376   7.565  1.00  5.27           C  
ATOM    249  C   LYS A  28     -33.296 -16.798   7.051  1.00  7.03           C  
ATOM    250  O   LYS A  28     -32.420 -17.075   6.226  1.00  7.35           O  
ATOM    251  CB  LYS A  28     -33.983 -14.477   6.454  1.00  5.02           C  
ATOM    252  CG  LYS A  28     -35.372 -14.886   6.001  1.00  7.45           C  
ATOM    253  CD  LYS A  28     -36.087 -13.809   5.198  1.00 13.04           C  
ATOM    254  CE  LYS A  28     -35.673 -13.802   3.740  1.00 15.10           C  
ATOM    255  NZ  LYS A  28     -36.641 -12.993   2.931  1.00 16.32           N  
ATOM    256  H   LYS A  28     -31.414 -14.835   7.370  1.00 15.00           H  
ATOM    257  HZ1 LYS A  28     -37.594 -13.393   3.042  1.00 15.00           H  
ATOM    258  HZ2 LYS A  28     -36.641 -12.007   3.261  1.00 15.00           H  
ATOM    259  HZ3 LYS A  28     -36.368 -13.026   1.928  1.00 15.00           H  
ATOM    260  N   TRP A  29     -34.106 -17.701   7.596  1.00  4.05           N  
ATOM    261  CA  TRP A  29     -34.116 -19.091   7.169  1.00  4.66           C  
ATOM    262  C   TRP A  29     -35.295 -19.232   6.218  1.00  6.45           C  
ATOM    263  O   TRP A  29     -36.419 -18.830   6.544  1.00  7.42           O  
ATOM    264  CB  TRP A  29     -34.300 -20.034   8.359  1.00  4.29           C  
ATOM    265  CG  TRP A  29     -33.100 -20.129   9.239  1.00  5.04           C  
ATOM    266  CD1 TRP A  29     -32.054 -20.986   9.103  1.00  2.23           C  
ATOM    267  CD2 TRP A  29     -32.815 -19.326  10.388  1.00  4.97           C  
ATOM    268  NE1 TRP A  29     -31.130 -20.770  10.094  1.00  4.03           N  
ATOM    269  CE2 TRP A  29     -31.570 -19.755  10.898  1.00  3.98           C  
ATOM    270  CE3 TRP A  29     -33.491 -18.283  11.034  1.00  5.87           C  
ATOM    271  CZ2 TRP A  29     -30.982 -19.178  12.023  1.00  4.54           C  
ATOM    272  CZ3 TRP A  29     -32.906 -17.706  12.155  1.00  9.28           C  
ATOM    273  CH2 TRP A  29     -31.661 -18.157  12.637  1.00  8.69           C  
ATOM    274  H   TRP A  29     -34.729 -17.411   8.293  1.00 15.00           H  
ATOM    275  HE1 TRP A  29     -30.282 -21.270  10.178  1.00 15.00           H  
ATOM    276  N   VAL A  30     -35.032 -19.771   5.034  1.00  7.64           N  
ATOM    277  CA  VAL A  30     -36.065 -19.952   4.027  1.00  5.51           C  
ATOM    278  C   VAL A  30     -36.234 -21.443   3.735  1.00  8.37           C  
ATOM    279  O   VAL A  30     -35.260 -22.151   3.455  1.00  5.04           O  
ATOM    280  CB  VAL A  30     -35.705 -19.207   2.714  1.00  5.39           C  
ATOM    281  CG1 VAL A  30     -36.864 -19.268   1.735  1.00  4.53           C  
ATOM    282  CG2 VAL A  30     -35.337 -17.750   3.006  1.00  3.34           C  
ATOM    283  H   VAL A  30     -34.123 -20.084   4.839  1.00 15.00           H  
ATOM    284  N   ASN A  31     -37.472 -21.915   3.848  1.00  7.56           N  
ATOM    285  CA  ASN A  31     -37.809 -23.311   3.594  1.00  9.49           C  
ATOM    286  C   ASN A  31     -37.556 -23.593   2.116  1.00 10.11           C  
ATOM    287  O   ASN A  31     -38.153 -22.945   1.254  1.00 10.31           O  
ATOM    288  CB  ASN A  31     -39.284 -23.547   3.916  1.00  9.33           C  
ATOM    289  CG  ASN A  31     -39.622 -25.010   4.049  1.00  8.90           C  
ATOM    290  OD1 ASN A  31     -38.758 -25.832   4.352  1.00 10.38           O  
ATOM    291  ND2 ASN A  31     -40.887 -25.345   3.839  1.00  7.53           N  
ATOM    292  H   ASN A  31     -38.175 -21.299   4.107  1.00 15.00           H  
ATOM    293 HD21 ASN A  31     -41.160 -26.285   3.898  1.00 15.00           H  
ATOM    294 HD22 ASN A  31     -41.498 -24.616   3.614  1.00 15.00           H  
ATOM    295  N   ASN A  32     -36.687 -24.557   1.825  1.00  9.80           N  
ATOM    296  CA  ASN A  32     -36.351 -24.881   0.444  1.00  9.21           C  
ATOM    297  C   ASN A  32     -36.830 -26.260  -0.026  1.00  8.54           C  
ATOM    298  O   ASN A  32     -37.746 -26.356  -0.842  1.00 10.03           O  
ATOM    299  CB  ASN A  32     -34.841 -24.733   0.227  1.00  8.38           C  
ATOM    300  CG  ASN A  32     -34.441 -24.840  -1.243  1.00 12.48           C  
ATOM    301  OD1 ASN A  32     -35.157 -24.369  -2.139  1.00  9.58           O  
ATOM    302  ND2 ASN A  32     -33.294 -25.459  -1.496  1.00  6.29           N  
ATOM    303  H   ASN A  32     -36.273 -25.078   2.550  1.00 15.00           H  
ATOM    304 HD21 ASN A  32     -33.025 -25.543  -2.428  1.00 15.00           H  
ATOM    305 HD22 ASN A  32     -32.792 -25.803  -0.721  1.00 15.00           H  
ATOM    306  N   LYS A  33     -36.211 -27.321   0.478  1.00  9.76           N  
ATOM    307  CA  LYS A  33     -36.582 -28.682   0.092  1.00 11.02           C  
ATOM    308  C   LYS A  33     -36.661 -29.623   1.285  1.00 10.97           C  
ATOM    309  O   LYS A  33     -36.091 -29.346   2.338  1.00 10.66           O  
ATOM    310  CB  LYS A  33     -35.570 -29.264  -0.903  1.00  9.62           C  
ATOM    311  CG  LYS A  33     -35.746 -28.812  -2.339  1.00 16.31           C  
ATOM    312  CD  LYS A  33     -34.775 -29.540  -3.263  1.00 20.44           C  
ATOM    313  CE  LYS A  33     -34.996 -29.138  -4.716  1.00 23.98           C  
ATOM    314  NZ  LYS A  33     -34.109 -29.874  -5.659  1.00 27.05           N  
ATOM    315  H   LYS A  33     -35.513 -27.209   1.163  1.00 15.00           H  
ATOM    316  HZ1 LYS A  33     -34.263 -30.899  -5.566  1.00 15.00           H  
ATOM    317  HZ2 LYS A  33     -34.319 -29.581  -6.635  1.00 15.00           H  
ATOM    318  HZ3 LYS A  33     -33.116 -29.653  -5.442  1.00 15.00           H  
ATOM    319  N   LEU A  34     -37.365 -30.738   1.091  1.00 10.28           N  
ATOM    320  CA  LEU A  34     -37.527 -31.787   2.099  1.00  9.23           C  
ATOM    321  C   LEU A  34     -38.153 -31.324   3.412  1.00  9.27           C  
ATOM    322  O   LEU A  34     -37.664 -31.632   4.500  1.00  8.57           O  
ATOM    323  CB  LEU A  34     -36.186 -32.495   2.337  1.00 10.25           C  
ATOM    324  CG  LEU A  34     -35.616 -33.260   1.131  1.00  9.44           C  
ATOM    325  CD1 LEU A  34     -34.220 -33.768   1.415  1.00  6.58           C  
ATOM    326  CD2 LEU A  34     -36.530 -34.414   0.778  1.00  9.08           C  
ATOM    327  H   LEU A  34     -37.827 -30.862   0.233  1.00 15.00           H  
ATOM    328  N   SER A  35     -39.272 -30.618   3.293  1.00 11.56           N  
ATOM    329  CA  SER A  35     -39.999 -30.105   4.447  1.00 13.59           C  
ATOM    330  C   SER A  35     -40.522 -31.262   5.300  1.00 14.08           C  
ATOM    331  O   SER A  35     -40.620 -32.399   4.818  1.00 16.25           O  
ATOM    332  CB  SER A  35     -41.160 -29.241   3.965  1.00 13.04           C  
ATOM    333  OG  SER A  35     -40.688 -28.245   3.076  1.00 20.14           O  
ATOM    334  H   SER A  35     -39.641 -30.443   2.406  1.00 15.00           H  
ATOM    335  HG  SER A  35     -39.945 -27.772   3.485  1.00 15.00           H  
ATOM    336  N   PRO A  36     -40.915 -30.985   6.557  1.00 11.98           N  
ATOM    337  CA  PRO A  36     -40.904 -29.676   7.219  1.00 10.92           C  
ATOM    338  C   PRO A  36     -39.616 -29.414   8.001  1.00  7.77           C  
ATOM    339  O   PRO A  36     -38.841 -30.337   8.278  1.00  7.61           O  
ATOM    340  CB  PRO A  36     -42.103 -29.778   8.155  1.00 11.79           C  
ATOM    341  CG  PRO A  36     -41.981 -31.193   8.654  1.00 12.52           C  
ATOM    342  CD  PRO A  36     -41.585 -31.991   7.405  1.00 12.80           C  
ATOM    343  N   HIS A  37     -39.387 -28.152   8.352  1.00  6.05           N  
ATOM    344  CA  HIS A  37     -38.198 -27.774   9.115  1.00  5.27           C  
ATOM    345  C   HIS A  37     -38.547 -26.710  10.143  1.00  4.44           C  
ATOM    346  O   HIS A  37     -39.560 -26.024  10.020  1.00  6.83           O  
ATOM    347  CB  HIS A  37     -37.117 -27.186   8.200  1.00  3.64           C  
ATOM    348  CG  HIS A  37     -36.737 -28.060   7.044  1.00  6.19           C  
ATOM    349  ND1 HIS A  37     -35.939 -29.175   7.181  1.00  5.83           N  
ATOM    350  CD2 HIS A  37     -36.982 -27.933   5.719  1.00  4.96           C  
ATOM    351  CE1 HIS A  37     -35.704 -29.694   5.989  1.00  7.75           C  
ATOM    352  NE2 HIS A  37     -36.325 -28.958   5.086  1.00  6.90           N  
ATOM    353  H   HIS A  37     -40.033 -27.447   8.111  1.00 15.00           H  
ATOM    354  HE2 HIS A  37     -36.301 -29.107   4.119  1.00 15.00           H  
ATOM    355  N   ASN A  38     -37.701 -26.587  11.158  1.00  6.68           N  
ATOM    356  CA  ASN A  38     -37.856 -25.573  12.194  1.00  6.65           C  
ATOM    357  C   ASN A  38     -36.461 -25.257  12.733  1.00  8.14           C  
ATOM    358  O   ASN A  38     -35.480 -25.907  12.341  1.00  4.75           O  
ATOM    359  CB  ASN A  38     -38.836 -26.005  13.300  1.00  5.57           C  
ATOM    360  CG  ASN A  38     -38.276 -27.070  14.231  1.00  6.82           C  
ATOM    361  OD1 ASN A  38     -37.214 -27.647  13.993  1.00  6.01           O  
ATOM    362  ND2 ASN A  38     -39.014 -27.345  15.303  1.00  6.18           N  
ATOM    363  H   ASN A  38     -36.911 -27.162  11.272  1.00 15.00           H  
ATOM    364 HD21 ASN A  38     -38.680 -27.996  15.946  1.00 15.00           H  
ATOM    365 HD22 ASN A  38     -39.867 -26.863  15.401  1.00 15.00           H  
ATOM    366  N   ILE A  39     -36.361 -24.222  13.568  1.00  8.37           N  
ATOM    367  CA  ILE A  39     -35.073 -23.805  14.121  1.00  9.70           C  
ATOM    368  C   ILE A  39     -35.109 -23.796  15.642  1.00  7.87           C  
ATOM    369  O   ILE A  39     -35.876 -23.043  16.245  1.00 10.32           O  
ATOM    370  CB  ILE A  39     -34.667 -22.357  13.648  1.00 11.23           C  
ATOM    371  CG1 ILE A  39     -34.644 -22.256  12.125  1.00 10.98           C  
ATOM    372  CG2 ILE A  39     -33.287 -21.986  14.180  1.00  9.00           C  
ATOM    373  CD1 ILE A  39     -35.963 -21.845  11.518  1.00 16.34           C  
ATOM    374  H   ILE A  39     -37.176 -23.751  13.842  1.00 15.00           H  
ATOM    375  N   VAL A  40     -34.278 -24.620  16.264  1.00  5.71           N  
ATOM    376  CA  VAL A  40     -34.226 -24.662  17.715  1.00  6.60           C  
ATOM    377  C   VAL A  40     -32.780 -24.473  18.155  1.00  5.16           C  
ATOM    378  O   VAL A  40     -31.909 -25.256  17.789  1.00  4.74           O  
ATOM    379  CB  VAL A  40     -34.770 -26.004  18.262  1.00  8.94           C  
ATOM    380  CG1 VAL A  40     -34.575 -26.077  19.780  1.00  7.05           C  
ATOM    381  CG2 VAL A  40     -36.252 -26.158  17.899  1.00  7.08           C  
ATOM    382  H   VAL A  40     -33.709 -25.229  15.745  1.00 15.00           H  
ATOM    383  N   PHE A  41     -32.514 -23.406  18.897  1.00  4.59           N  
ATOM    384  CA  PHE A  41     -31.157 -23.150  19.369  1.00  6.25           C  
ATOM    385  C   PHE A  41     -30.899 -23.886  20.672  1.00  7.03           C  
ATOM    386  O   PHE A  41     -31.774 -23.952  21.530  1.00  9.02           O  
ATOM    387  CB  PHE A  41     -30.930 -21.652  19.565  1.00  4.19           C  
ATOM    388  CG  PHE A  41     -30.718 -20.900  18.286  1.00  5.31           C  
ATOM    389  CD1 PHE A  41     -31.801 -20.423  17.552  1.00  5.90           C  
ATOM    390  CD2 PHE A  41     -29.431 -20.665  17.810  1.00  4.53           C  
ATOM    391  CE1 PHE A  41     -31.604 -19.719  16.361  1.00  3.88           C  
ATOM    392  CE2 PHE A  41     -29.225 -19.965  16.625  1.00  3.78           C  
ATOM    393  CZ  PHE A  41     -30.315 -19.491  15.899  1.00  4.60           C  
ATOM    394  H   PHE A  41     -33.242 -22.805  19.156  1.00 15.00           H  
ATOM    395  N   ASP A  42     -29.741 -24.522  20.792  1.00  9.72           N  
ATOM    396  CA  ASP A  42     -29.429 -25.203  22.036  1.00 14.57           C  
ATOM    397  C   ASP A  42     -28.865 -24.129  22.975  1.00 15.76           C  
ATOM    398  O   ASP A  42     -28.366 -23.098  22.521  1.00 15.34           O  
ATOM    399  CB  ASP A  42     -28.475 -26.385  21.822  1.00 17.00           C  
ATOM    400  CG  ASP A  42     -27.284 -26.035  20.975  1.00 20.70           C  
ATOM    401  OD1 ASP A  42     -26.506 -25.149  21.387  1.00 23.91           O  
ATOM    402  OD2 ASP A  42     -27.120 -26.653  19.901  1.00 19.06           O  
ATOM    403  H   ASP A  42     -29.093 -24.498  20.051  1.00 15.00           H  
ATOM    404  N   ALA A  43     -28.957 -24.356  24.277  1.00 17.73           N  
ATOM    405  CA  ALA A  43     -28.511 -23.353  25.234  1.00 19.27           C  
ATOM    406  C   ALA A  43     -27.098 -23.451  25.790  1.00 18.13           C  
ATOM    407  O   ALA A  43     -26.804 -22.837  26.812  1.00 22.50           O  
ATOM    408  CB  ALA A  43     -29.515 -23.257  26.375  1.00 17.33           C  
ATOM    409  H   ALA A  43     -29.342 -25.196  24.599  1.00 15.00           H  
ATOM    410  N   ASP A  44     -26.210 -24.197  25.150  1.00 18.75           N  
ATOM    411  CA  ASP A  44     -24.860 -24.280  25.695  1.00 21.27           C  
ATOM    412  C   ASP A  44     -23.985 -23.169  25.121  1.00 19.24           C  
ATOM    413  O   ASP A  44     -23.936 -22.965  23.906  1.00 20.81           O  
ATOM    414  CB  ASP A  44     -24.243 -25.675  25.493  1.00 24.88           C  
ATOM    415  CG  ASP A  44     -23.735 -25.906  24.084  1.00 28.39           C  
ATOM    416  OD1 ASP A  44     -24.547 -25.874  23.136  1.00 30.60           O  
ATOM    417  OD2 ASP A  44     -22.514 -26.130  23.931  1.00 27.95           O  
ATOM    418  H   ASP A  44     -26.432 -24.643  24.310  1.00 15.00           H  
ATOM    419  N   GLY A  45     -23.382 -22.386  26.008  1.00 17.16           N  
ATOM    420  CA  GLY A  45     -22.525 -21.295  25.570  1.00 15.05           C  
ATOM    421  C   GLY A  45     -23.222 -19.953  25.445  1.00 11.18           C  
ATOM    422  O   GLY A  45     -22.569 -18.921  25.306  1.00 11.83           O  
ATOM    423  H   GLY A  45     -23.540 -22.531  26.965  1.00 15.00           H  
ATOM    424  N   VAL A  46     -24.546 -19.957  25.471  1.00 10.69           N  
ATOM    425  CA  VAL A  46     -25.319 -18.725  25.376  1.00  9.36           C  
ATOM    426  C   VAL A  46     -26.422 -18.794  26.428  1.00  9.09           C  
ATOM    427  O   VAL A  46     -26.707 -19.866  26.956  1.00  8.01           O  
ATOM    428  CB  VAL A  46     -25.949 -18.532  23.962  1.00  8.35           C  
ATOM    429  CG1 VAL A  46     -24.859 -18.329  22.923  1.00  8.58           C  
ATOM    430  CG2 VAL A  46     -26.826 -19.719  23.591  1.00  8.45           C  
ATOM    431  H   VAL A  46     -25.061 -20.785  25.585  1.00 15.00           H  
ATOM    432  N   PRO A  47     -26.993 -17.642  26.811  1.00 10.72           N  
ATOM    433  CA  PRO A  47     -28.057 -17.642  27.814  1.00 11.13           C  
ATOM    434  C   PRO A  47     -29.242 -18.464  27.338  1.00 12.25           C  
ATOM    435  O   PRO A  47     -29.678 -18.325  26.196  1.00 13.86           O  
ATOM    436  CB  PRO A  47     -28.411 -16.165  27.919  1.00 10.86           C  
ATOM    437  CG  PRO A  47     -27.093 -15.508  27.688  1.00 11.98           C  
ATOM    438  CD  PRO A  47     -26.576 -16.266  26.498  1.00 11.28           C  
ATOM    439  N   ALA A  48     -29.770 -19.304  28.223  1.00 12.16           N  
ATOM    440  CA  ALA A  48     -30.905 -20.161  27.894  1.00 11.67           C  
ATOM    441  C   ALA A  48     -32.095 -19.400  27.311  1.00 11.79           C  
ATOM    442  O   ALA A  48     -32.670 -19.815  26.299  1.00 11.68           O  
ATOM    443  CB  ALA A  48     -31.330 -20.960  29.115  1.00 10.29           C  
ATOM    444  H   ALA A  48     -29.364 -19.354  29.110  1.00 15.00           H  
ATOM    445  N   ASP A  50     -32.444 -18.270  27.918  1.00 10.25           N  
ATOM    446  CA  ASP A  50     -33.576 -17.489  27.427  1.00 12.55           C  
ATOM    447  C   ASP A  50     -33.363 -16.802  26.081  1.00 10.98           C  
ATOM    448  O   ASP A  50     -34.310 -16.638  25.311  1.00  8.78           O  
ATOM    449  CB  ASP A  50     -34.078 -16.516  28.495  1.00 13.40           C  
ATOM    450  CG  ASP A  50     -34.973 -17.196  29.522  1.00 18.87           C  
ATOM    451  OD1 ASP A  50     -34.994 -18.448  29.575  1.00 17.26           O  
ATOM    452  OD2 ASP A  50     -35.678 -16.484  30.269  1.00 20.48           O  
ATOM    453  H   ASP A  50     -31.945 -17.956  28.704  1.00 15.00           H  
ATOM    454  N   THR A  51     -32.123 -16.429  25.783  1.00 11.35           N  
ATOM    455  CA  THR A  51     -31.813 -15.804  24.503  1.00 11.86           C  
ATOM    456  C   THR A  51     -32.018 -16.864  23.420  1.00 10.08           C  
ATOM    457  O   THR A  51     -32.675 -16.612  22.409  1.00 11.16           O  
ATOM    458  CB  THR A  51     -30.364 -15.308  24.469  1.00 12.21           C  
ATOM    459  OG1 THR A  51     -30.132 -14.456  25.596  1.00 16.85           O  
ATOM    460  CG2 THR A  51     -30.092 -14.531  23.188  1.00 14.22           C  
ATOM    461  H   THR A  51     -31.402 -16.543  26.433  1.00 15.00           H  
ATOM    462  HG1 THR A  51     -30.811 -13.770  25.574  1.00 15.00           H  
ATOM    463  N   ALA A  52     -31.502 -18.065  23.673  1.00  9.50           N  
ATOM    464  CA  ALA A  52     -31.627 -19.190  22.750  1.00  9.03           C  
ATOM    465  C   ALA A  52     -33.104 -19.465  22.448  1.00 10.01           C  
ATOM    466  O   ALA A  52     -33.480 -19.707  21.300  1.00  9.84           O  
ATOM    467  CB  ALA A  52     -30.962 -20.431  23.344  1.00  8.63           C  
ATOM    468  H   ALA A  52     -31.015 -18.208  24.515  1.00 15.00           H  
ATOM    469  N   ALA A  53     -33.940 -19.399  23.480  1.00 11.03           N  
ATOM    470  CA  ALA A  53     -35.374 -19.612  23.325  1.00 10.75           C  
ATOM    471  C   ALA A  53     -36.009 -18.512  22.467  1.00 11.53           C  
ATOM    472  O   ALA A  53     -36.821 -18.791  21.586  1.00 11.64           O  
ATOM    473  CB  ALA A  53     -36.047 -19.671  24.693  1.00 12.35           C  
ATOM    474  H   ALA A  53     -33.576 -19.222  24.372  1.00 15.00           H  
ATOM    475  N   LYS A  54     -35.632 -17.261  22.717  1.00 12.02           N  
ATOM    476  CA  LYS A  54     -36.180 -16.140  21.959  1.00 10.72           C  
ATOM    477  C   LYS A  54     -35.801 -16.182  20.481  1.00  8.94           C  
ATOM    478  O   LYS A  54     -36.519 -15.644  19.635  1.00  5.52           O  
ATOM    479  CB  LYS A  54     -35.731 -14.809  22.565  1.00 14.97           C  
ATOM    480  CG  LYS A  54     -36.444 -14.426  23.850  1.00 20.59           C  
ATOM    481  CD  LYS A  54     -35.994 -13.046  24.314  1.00 24.89           C  
ATOM    482  CE  LYS A  54     -34.600 -13.069  24.938  1.00 27.07           C  
ATOM    483  NZ  LYS A  54     -34.637 -13.492  26.374  1.00 28.00           N  
ATOM    484  H   LYS A  54     -34.981 -17.076  23.429  1.00 15.00           H  
ATOM    485  HZ1 LYS A  54     -35.047 -14.445  26.449  1.00 15.00           H  
ATOM    486  HZ2 LYS A  54     -33.674 -13.495  26.767  1.00 15.00           H  
ATOM    487  HZ3 LYS A  54     -35.228 -12.822  26.908  1.00 15.00           H  
ATOM    488  N   LEU A  55     -34.658 -16.792  20.179  1.00  5.68           N  
ATOM    489  CA  LEU A  55     -34.178 -16.904  18.804  1.00  5.49           C  
ATOM    490  C   LEU A  55     -34.803 -18.080  18.054  1.00  5.67           C  
ATOM    491  O   LEU A  55     -34.840 -18.095  16.823  1.00  6.82           O  
ATOM    492  CB  LEU A  55     -32.652 -17.051  18.793  1.00  6.00           C  
ATOM    493  CG  LEU A  55     -31.817 -15.856  19.263  1.00  7.46           C  
ATOM    494  CD1 LEU A  55     -30.377 -16.274  19.460  1.00  6.00           C  
ATOM    495  CD2 LEU A  55     -31.917 -14.726  18.255  1.00  7.36           C  
ATOM    496  H   LEU A  55     -34.109 -17.151  20.907  1.00 15.00           H  
ATOM    497  N   SER A  56     -35.294 -19.063  18.795  1.00  5.85           N  
ATOM    498  CA  SER A  56     -35.883 -20.250  18.188  1.00  3.78           C  
ATOM    499  C   SER A  56     -37.236 -19.985  17.550  1.00  5.57           C  
ATOM    500  O   SER A  56     -37.942 -19.033  17.906  1.00  3.49           O  
ATOM    501  CB  SER A  56     -36.032 -21.358  19.230  1.00  2.00           C  
ATOM    502  OG  SER A  56     -34.790 -21.670  19.836  1.00  2.72           O  
ATOM    503  H   SER A  56     -35.285 -18.988  19.768  1.00 15.00           H  
ATOM    504  HG  SER A  56     -34.399 -20.848  20.164  1.00 15.00           H  
ATOM    505  N   HIS A  57     -37.571 -20.829  16.581  1.00  5.84           N  
ATOM    506  CA  HIS A  57     -38.842 -20.774  15.872  1.00  6.01           C  
ATOM    507  C   HIS A  57     -39.251 -22.243  15.815  1.00  7.59           C  
ATOM    508  O   HIS A  57     -38.837 -22.979  14.916  1.00  6.56           O  
ATOM    509  CB  HIS A  57     -38.654 -20.197  14.463  1.00  8.13           C  
ATOM    510  CG  HIS A  57     -38.235 -18.757  14.445  1.00  8.42           C  
ATOM    511  ND1 HIS A  57     -39.139 -17.717  14.425  1.00  9.64           N  
ATOM    512  CD2 HIS A  57     -37.007 -18.186  14.459  1.00  8.79           C  
ATOM    513  CE1 HIS A  57     -38.489 -16.567  14.433  1.00 10.50           C  
ATOM    514  NE2 HIS A  57     -37.193 -16.824  14.453  1.00 10.90           N  
ATOM    515  H   HIS A  57     -36.940 -21.536  16.341  1.00 15.00           H  
ATOM    516  HD1 HIS A  57     -40.110 -17.784  14.404  1.00 15.00           H  
ATOM    517  HE2 HIS A  57     -36.464 -16.162  14.477  1.00 15.00           H  
ATOM    518  N   LYS A  58     -39.993 -22.681  16.828  1.00  8.09           N  
ATOM    519  CA  LYS A  58     -40.430 -24.070  16.940  1.00 10.03           C  
ATOM    520  C   LYS A  58     -41.488 -24.552  15.946  1.00  9.97           C  
ATOM    521  O   LYS A  58     -41.587 -25.751  15.684  1.00 11.90           O  
ATOM    522  CB  LYS A  58     -40.871 -24.372  18.374  1.00 12.79           C  
ATOM    523  CG  LYS A  58     -39.722 -24.472  19.377  1.00 17.24           C  
ATOM    524  CD  LYS A  58     -40.233 -24.937  20.740  1.00 22.92           C  
ATOM    525  CE  LYS A  58     -39.115 -25.089  21.776  1.00 26.76           C  
ATOM    526  NZ  LYS A  58     -38.211 -26.253  21.523  1.00 27.79           N  
ATOM    527  H   LYS A  58     -40.247 -22.053  17.543  1.00 15.00           H  
ATOM    528  HZ1 LYS A  58     -38.766 -27.132  21.533  1.00 15.00           H  
ATOM    529  HZ2 LYS A  58     -37.752 -26.143  20.596  1.00 15.00           H  
ATOM    530  HZ3 LYS A  58     -37.486 -26.291  22.267  1.00 15.00           H  
ATOM    531  N   GLY A  61     -42.286 -23.634  15.410  1.00 10.92           N  
ATOM    532  CA  GLY A  61     -43.308 -24.011  14.443  1.00 11.00           C  
ATOM    533  C   GLY A  61     -42.689 -24.546  13.158  1.00 12.98           C  
ATOM    534  O   GLY A  61     -41.677 -24.016  12.677  1.00 12.10           O  
ATOM    535  H   GLY A  61     -42.174 -22.699  15.654  1.00 15.00           H  
ATOM    536  N   LEU A  62     -43.299 -25.584  12.594  1.00 11.19           N  
ATOM    537  CA  LEU A  62     -42.799 -26.204  11.372  1.00  9.92           C  
ATOM    538  C   LEU A  62     -43.223 -25.479  10.098  1.00  9.22           C  
ATOM    539  O   LEU A  62     -44.369 -25.042   9.968  1.00  5.80           O  
ATOM    540  CB  LEU A  62     -43.240 -27.669  11.298  1.00 11.48           C  
ATOM    541  CG  LEU A  62     -42.697 -28.618  12.372  1.00 15.36           C  
ATOM    542  CD1 LEU A  62     -43.276 -30.002  12.160  1.00 17.35           C  
ATOM    543  CD2 LEU A  62     -41.172 -28.666  12.337  1.00 15.87           C  
ATOM    544  H   LEU A  62     -44.132 -25.916  12.990  1.00 15.00           H  
ATOM    545  N   LEU A  63     -42.282 -25.344   9.169  1.00  8.32           N  
ATOM    546  CA  LEU A  63     -42.539 -24.698   7.887  1.00 10.63           C  
ATOM    547  C   LEU A  63     -42.686 -25.791   6.833  1.00 10.24           C  
ATOM    548  O   LEU A  63     -41.855 -26.708   6.755  1.00  9.75           O  
ATOM    549  CB  LEU A  63     -41.394 -23.748   7.508  1.00 11.61           C  
ATOM    550  CG  LEU A  63     -41.215 -22.452   8.310  1.00 13.93           C  
ATOM    551  CD1 LEU A  63     -40.100 -21.630   7.687  1.00 12.38           C  
ATOM    552  CD2 LEU A  63     -42.511 -21.641   8.324  1.00 16.62           C  
ATOM    553  H   LEU A  63     -41.380 -25.677   9.356  1.00 15.00           H  
ATOM    554  N   PHE A  64     -43.747 -25.700   6.035  1.00 10.74           N  
ATOM    555  CA  PHE A  64     -44.014 -26.695   5.001  1.00 11.29           C  
ATOM    556  C   PHE A  64     -43.819 -26.218   3.559  1.00 11.57           C  
ATOM    557  O   PHE A  64     -43.138 -26.876   2.781  1.00 14.56           O  
ATOM    558  CB  PHE A  64     -45.423 -27.266   5.175  1.00  9.72           C  
ATOM    559  CG  PHE A  64     -45.615 -28.039   6.454  1.00 10.94           C  
ATOM    560  CD1 PHE A  64     -45.871 -27.378   7.655  1.00 10.20           C  
ATOM    561  CD2 PHE A  64     -45.561 -29.431   6.454  1.00  9.62           C  
ATOM    562  CE1 PHE A  64     -46.073 -28.094   8.843  1.00 10.65           C  
ATOM    563  CE2 PHE A  64     -45.761 -30.155   7.634  1.00  9.43           C  
ATOM    564  CZ  PHE A  64     -46.017 -29.486   8.830  1.00  8.80           C  
ATOM    565  H   PHE A  64     -44.371 -24.963   6.176  1.00 15.00           H  
ATOM    566  N   ALA A  65     -44.406 -25.082   3.203  1.00 10.82           N  
ATOM    567  CA  ALA A  65     -44.295 -24.564   1.840  1.00 10.73           C  
ATOM    568  C   ALA A  65     -42.928 -23.963   1.526  1.00 10.67           C  
ATOM    569  O   ALA A  65     -42.286 -23.364   2.394  1.00  9.46           O  
ATOM    570  CB  ALA A  65     -45.377 -23.542   1.585  1.00  7.84           C  
ATOM    571  H   ALA A  65     -44.920 -24.576   3.857  1.00 15.00           H  
ATOM    572  N   ALA A  66     -42.476 -24.157   0.290  1.00 11.58           N  
ATOM    573  CA  ALA A  66     -41.197 -23.610  -0.160  1.00 11.20           C  
ATOM    574  C   ALA A  66     -41.336 -22.089  -0.232  1.00 10.74           C  
ATOM    575  O   ALA A  66     -42.340 -21.565  -0.735  1.00  9.35           O  
ATOM    576  CB  ALA A  66     -40.833 -24.179  -1.527  1.00  9.33           C  
ATOM    577  H   ALA A  66     -43.022 -24.693  -0.321  1.00 15.00           H  
ATOM    578  N   GLY A  67     -40.347 -21.374   0.287  1.00 12.05           N  
ATOM    579  CA  GLY A  67     -40.422 -19.924   0.271  1.00 14.12           C  
ATOM    580  C   GLY A  67     -40.806 -19.324   1.613  1.00 15.38           C  
ATOM    581  O   GLY A  67     -40.649 -18.117   1.812  1.00 17.78           O  
ATOM    582  H   GLY A  67     -39.565 -21.820   0.676  1.00 15.00           H  
ATOM    583  N   GLU A  68     -41.362 -20.132   2.517  1.00 14.48           N  
ATOM    584  CA  GLU A  68     -41.723 -19.638   3.849  1.00 12.85           C  
ATOM    585  C   GLU A  68     -40.420 -19.336   4.583  1.00  9.94           C  
ATOM    586  O   GLU A  68     -39.400 -19.980   4.325  1.00  7.87           O  
ATOM    587  CB  GLU A  68     -42.512 -20.691   4.636  1.00 14.35           C  
ATOM    588  CG  GLU A  68     -43.921 -20.930   4.131  1.00 19.70           C  
ATOM    589  CD  GLU A  68     -44.699 -21.920   4.988  1.00 21.96           C  
ATOM    590  OE1 GLU A  68     -44.148 -22.974   5.368  1.00 20.89           O  
ATOM    591  OE2 GLU A  68     -45.879 -21.645   5.273  1.00 25.35           O  
ATOM    592  H   GLU A  68     -41.523 -21.071   2.293  1.00 15.00           H  
ATOM    593  N   SER A  69     -40.450 -18.388   5.510  1.00  8.80           N  
ATOM    594  CA  SER A  69     -39.232 -18.044   6.237  1.00  9.52           C  
ATOM    595  C   SER A  69     -39.455 -17.622   7.685  1.00  6.95           C  
ATOM    596  O   SER A  69     -40.585 -17.426   8.130  1.00  6.85           O  
ATOM    597  CB  SER A  69     -38.473 -16.938   5.492  1.00  8.04           C  
ATOM    598  OG  SER A  69     -39.221 -15.730   5.469  1.00  9.45           O  
ATOM    599  H   SER A  69     -41.268 -17.897   5.729  1.00 15.00           H  
ATOM    600  HG  SER A  69     -40.057 -15.866   4.985  1.00 15.00           H  
ATOM    601  N   PHE A  70     -38.350 -17.533   8.413  1.00  7.59           N  
ATOM    602  CA  PHE A  70     -38.318 -17.116   9.805  1.00  6.66           C  
ATOM    603  C   PHE A  70     -37.112 -16.197   9.894  1.00  8.55           C  
ATOM    604  O   PHE A  70     -36.103 -16.433   9.220  1.00  6.87           O  
ATOM    605  CB  PHE A  70     -38.078 -18.314  10.731  1.00 10.41           C  
ATOM    606  CG  PHE A  70     -39.326 -19.091  11.076  1.00 15.22           C  
ATOM    607  CD1 PHE A  70     -40.499 -18.432  11.437  1.00 15.64           C  
ATOM    608  CD2 PHE A  70     -39.314 -20.484  11.074  1.00 16.11           C  
ATOM    609  CE1 PHE A  70     -41.645 -19.149  11.793  1.00 19.20           C  
ATOM    610  CE2 PHE A  70     -40.450 -21.211  11.429  1.00 17.49           C  
ATOM    611  CZ  PHE A  70     -41.620 -20.541  11.790  1.00 18.25           C  
ATOM    612  H   PHE A  70     -37.485 -17.744   7.992  1.00 15.00           H  
ATOM    613  N   THR A  71     -37.208 -15.160  10.719  1.00  7.36           N  
ATOM    614  CA  THR A  71     -36.107 -14.221  10.898  1.00  8.01           C  
ATOM    615  C   THR A  71     -35.822 -14.036  12.381  1.00  6.56           C  
ATOM    616  O   THR A  71     -36.745 -14.016  13.198  1.00  5.70           O  
ATOM    617  CB  THR A  71     -36.440 -12.815  10.316  1.00  9.27           C  
ATOM    618  OG1 THR A  71     -36.797 -12.929   8.933  1.00 10.07           O  
ATOM    619  CG2 THR A  71     -35.236 -11.878  10.445  1.00  8.69           C  
ATOM    620  H   THR A  71     -38.039 -14.999  11.216  1.00 15.00           H  
ATOM    621  HG1 THR A  71     -36.588 -12.095   8.475  1.00 15.00           H  
ATOM    622  N   SER A  72     -34.539 -13.945  12.716  1.00  6.66           N  
ATOM    623  CA  SER A  72     -34.093 -13.705  14.080  1.00  7.47           C  
ATOM    624  C   SER A  72     -32.986 -12.661  14.004  1.00  8.28           C  
ATOM    625  O   SER A  72     -32.152 -12.697  13.086  1.00  5.45           O  
ATOM    626  CB  SER A  72     -33.562 -14.987  14.729  1.00  5.93           C  
ATOM    627  OG  SER A  72     -34.631 -15.852  15.074  1.00 12.01           O  
ATOM    628  H   SER A  72     -33.846 -14.046  12.023  1.00 15.00           H  
ATOM    629  HG  SER A  72     -35.016 -15.495  15.886  1.00 15.00           H  
ATOM    630  N   THR A  73     -33.038 -11.692  14.917  1.00  7.32           N  
ATOM    631  CA  THR A  73     -32.050 -10.623  15.003  1.00  4.70           C  
ATOM    632  C   THR A  73     -31.111 -10.997  16.147  1.00  5.25           C  
ATOM    633  O   THR A  73     -31.567 -11.305  17.243  1.00  4.53           O  
ATOM    634  CB  THR A  73     -32.723  -9.267  15.331  1.00  8.43           C  
ATOM    635  OG1 THR A  73     -33.703  -8.955  14.333  1.00  6.49           O  
ATOM    636  CG2 THR A  73     -31.686  -8.145  15.395  1.00  5.18           C  
ATOM    637  H   THR A  73     -33.753 -11.687  15.591  1.00 15.00           H  
ATOM    638  HG1 THR A  73     -34.468  -9.534  14.481  1.00 15.00           H  
ATOM    639  N   PHE A  74     -29.807 -10.999  15.887  1.00  7.80           N  
ATOM    640  CA  PHE A  74     -28.823 -11.348  16.911  1.00 10.21           C  
ATOM    641  C   PHE A  74     -28.088 -10.090  17.367  1.00 13.09           C  
ATOM    642  O   PHE A  74     -27.171  -9.629  16.686  1.00 14.08           O  
ATOM    643  CB  PHE A  74     -27.809 -12.363  16.358  1.00  9.14           C  
ATOM    644  CG  PHE A  74     -28.414 -13.684  15.969  1.00  7.83           C  
ATOM    645  CD1 PHE A  74     -29.262 -13.782  14.866  1.00  7.50           C  
ATOM    646  CD2 PHE A  74     -28.136 -14.830  16.703  1.00  6.37           C  
ATOM    647  CE1 PHE A  74     -29.823 -15.005  14.503  1.00  9.64           C  
ATOM    648  CE2 PHE A  74     -28.692 -16.061  16.348  1.00  6.39           C  
ATOM    649  CZ  PHE A  74     -29.536 -16.147  15.246  1.00  6.54           C  
ATOM    650  H   PHE A  74     -29.477 -10.753  14.993  1.00 15.00           H  
ATOM    651  N   THR A  75     -28.474  -9.543  18.515  1.00 13.23           N  
ATOM    652  CA  THR A  75     -27.841  -8.326  19.021  1.00 14.05           C  
ATOM    653  C   THR A  75     -26.670  -8.574  19.957  1.00 13.86           C  
ATOM    654  O   THR A  75     -25.894  -7.658  20.235  1.00 16.03           O  
ATOM    655  CB  THR A  75     -28.853  -7.413  19.751  1.00 15.70           C  
ATOM    656  OG1 THR A  75     -29.360  -8.086  20.908  1.00 15.92           O  
ATOM    657  CG2 THR A  75     -30.011  -7.055  18.831  1.00 14.60           C  
ATOM    658  H   THR A  75     -29.173  -9.965  19.062  1.00 15.00           H  
ATOM    659  HG1 THR A  75     -29.993  -7.506  21.357  1.00 15.00           H  
ATOM    660  N   GLU A  76     -26.532  -9.807  20.430  1.00 13.52           N  
ATOM    661  CA  GLU A  76     -25.463 -10.146  21.359  1.00 13.44           C  
ATOM    662  C   GLU A  76     -24.451 -11.083  20.711  1.00 13.75           C  
ATOM    663  O   GLU A  76     -24.831 -12.092  20.115  1.00 15.09           O  
ATOM    664  CB  GLU A  76     -26.065 -10.806  22.605  1.00 14.27           C  
ATOM    665  CG  GLU A  76     -25.118 -10.935  23.790  1.00 19.34           C  
ATOM    666  CD  GLU A  76     -24.838  -9.610  24.488  1.00 19.72           C  
ATOM    667  OE1 GLU A  76     -25.746  -8.756  24.542  1.00 22.03           O  
ATOM    668  OE2 GLU A  76     -23.711  -9.429  24.998  1.00 22.07           O  
ATOM    669  H   GLU A  76     -27.162 -10.510  20.156  1.00 15.00           H  
ATOM    670  N   PRO A  77     -23.151 -10.746  20.794  1.00 13.74           N  
ATOM    671  CA  PRO A  77     -22.054 -11.541  20.226  1.00 11.91           C  
ATOM    672  C   PRO A  77     -21.972 -12.946  20.824  1.00 12.84           C  
ATOM    673  O   PRO A  77     -22.244 -13.136  22.007  1.00 14.22           O  
ATOM    674  CB  PRO A  77     -20.818 -10.727  20.607  1.00 11.38           C  
ATOM    675  CG  PRO A  77     -21.333  -9.320  20.612  1.00 13.83           C  
ATOM    676  CD  PRO A  77     -22.640  -9.476  21.340  1.00 11.71           C  
ATOM    677  N   GLY A  78     -21.595 -13.925  20.008  1.00 11.27           N  
ATOM    678  CA  GLY A  78     -21.477 -15.283  20.502  1.00 10.68           C  
ATOM    679  C   GLY A  78     -21.585 -16.327  19.409  1.00 10.96           C  
ATOM    680  O   GLY A  78     -21.687 -15.993  18.226  1.00  9.07           O  
ATOM    681  H   GLY A  78     -21.409 -13.745  19.062  1.00 15.00           H  
ATOM    682  N   THR A  79     -21.514 -17.592  19.809  1.00 10.43           N  
ATOM    683  CA  THR A  79     -21.622 -18.723  18.891  1.00 10.93           C  
ATOM    684  C   THR A  79     -22.917 -19.446  19.242  1.00  8.15           C  
ATOM    685  O   THR A  79     -23.045 -19.998  20.333  1.00  7.23           O  
ATOM    686  CB  THR A  79     -20.436 -19.686  19.067  1.00 12.23           C  
ATOM    687  OG1 THR A  79     -19.218 -18.991  18.777  1.00 16.01           O  
ATOM    688  CG2 THR A  79     -20.573 -20.889  18.142  1.00 13.11           C  
ATOM    689  H   THR A  79     -21.376 -17.779  20.761  1.00 15.00           H  
ATOM    690  HG1 THR A  79     -19.236 -18.669  17.869  1.00 15.00           H  
ATOM    691  N   TYR A  80     -23.877 -19.408  18.328  1.00  5.88           N  
ATOM    692  CA  TYR A  80     -25.181 -20.019  18.534  1.00  6.49           C  
ATOM    693  C   TYR A  80     -25.400 -21.240  17.647  1.00  6.54           C  
ATOM    694  O   TYR A  80     -25.573 -21.111  16.434  1.00  7.02           O  
ATOM    695  CB  TYR A  80     -26.287 -19.003  18.232  1.00  7.77           C  
ATOM    696  CG  TYR A  80     -26.214 -17.707  19.012  1.00  9.96           C  
ATOM    697  CD1 TYR A  80     -25.227 -16.756  18.743  1.00  8.23           C  
ATOM    698  CD2 TYR A  80     -27.154 -17.419  19.997  1.00 11.20           C  
ATOM    699  CE1 TYR A  80     -25.183 -15.549  19.439  1.00 12.97           C  
ATOM    700  CE2 TYR A  80     -27.122 -16.216  20.697  1.00 13.77           C  
ATOM    701  CZ  TYR A  80     -26.136 -15.284  20.416  1.00 12.97           C  
ATOM    702  OH  TYR A  80     -26.125 -14.089  21.097  1.00 12.65           O  
ATOM    703  H   TYR A  80     -23.717 -18.948  17.482  1.00 15.00           H  
ATOM    704  HH  TYR A  80     -25.255 -13.689  20.971  1.00 15.00           H  
ATOM    705  N   THR A  81     -25.389 -22.420  18.248  1.00  4.44           N  
ATOM    706  CA  THR A  81     -25.615 -23.648  17.504  1.00  4.54           C  
ATOM    707  C   THR A  81     -27.103 -23.980  17.602  1.00  5.49           C  
ATOM    708  O   THR A  81     -27.740 -23.716  18.630  1.00  3.91           O  
ATOM    709  CB  THR A  81     -24.735 -24.800  18.038  1.00  4.23           C  
ATOM    710  OG1 THR A  81     -24.892 -24.917  19.455  1.00  7.30           O  
ATOM    711  CG2 THR A  81     -23.277 -24.518  17.754  1.00  4.44           C  
ATOM    712  H   THR A  81     -25.303 -22.450  19.225  1.00 15.00           H  
ATOM    713  HG1 THR A  81     -24.748 -24.076  19.911  1.00 15.00           H  
ATOM    714  N   TYR A  82     -27.659 -24.529  16.526  1.00  4.41           N  
ATOM    715  CA  TYR A  82     -29.075 -24.859  16.483  1.00  3.37           C  
ATOM    716  C   TYR A  82     -29.324 -26.115  15.656  1.00  4.31           C  
ATOM    717  O   TYR A  82     -28.397 -26.672  15.066  1.00  4.00           O  
ATOM    718  CB  TYR A  82     -29.873 -23.683  15.903  1.00  4.98           C  
ATOM    719  CG  TYR A  82     -29.543 -23.339  14.463  1.00  5.59           C  
ATOM    720  CD1 TYR A  82     -28.462 -22.520  14.151  1.00  5.59           C  
ATOM    721  CD2 TYR A  82     -30.321 -23.824  13.414  1.00  7.40           C  
ATOM    722  CE1 TYR A  82     -28.163 -22.193  12.835  1.00  3.96           C  
ATOM    723  CE2 TYR A  82     -30.030 -23.503  12.095  1.00  5.45           C  
ATOM    724  CZ  TYR A  82     -28.950 -22.687  11.814  1.00  6.73           C  
ATOM    725  OH  TYR A  82     -28.661 -22.364  10.509  1.00  5.41           O  
ATOM    726  H   TYR A  82     -27.100 -24.751  15.751  1.00 15.00           H  
ATOM    727  HH  TYR A  82     -27.891 -21.778  10.474  1.00 15.00           H  
ATOM    728  N   TYR A  83     -30.575 -26.550  15.597  1.00  3.05           N  
ATOM    729  CA  TYR A  83     -30.915 -27.745  14.835  1.00  5.58           C  
ATOM    730  C   TYR A  83     -32.369 -27.766  14.420  1.00  5.12           C  
ATOM    731  O   TYR A  83     -33.187 -26.980  14.910  1.00  3.63           O  
ATOM    732  CB  TYR A  83     -30.606 -29.011  15.653  1.00  5.83           C  
ATOM    733  CG  TYR A  83     -31.364 -29.101  16.967  1.00 11.69           C  
ATOM    734  CD1 TYR A  83     -32.660 -29.621  17.018  1.00 12.89           C  
ATOM    735  CD2 TYR A  83     -30.794 -28.648  18.152  1.00  9.89           C  
ATOM    736  CE1 TYR A  83     -33.370 -29.679  18.216  1.00 12.26           C  
ATOM    737  CE2 TYR A  83     -31.495 -28.704  19.355  1.00 14.04           C  
ATOM    738  CZ  TYR A  83     -32.782 -29.220  19.379  1.00 13.56           C  
ATOM    739  OH  TYR A  83     -33.481 -29.266  20.563  1.00 14.56           O  
ATOM    740  H   TYR A  83     -31.295 -26.087  16.078  1.00 15.00           H  
ATOM    741  HH  TYR A  83     -34.347 -29.651  20.417  1.00 15.00           H  
ATOM    742  N   CYS A  84     -32.668 -28.668  13.495  1.00  4.80           N  
ATOM    743  CA  CYS A  84     -34.015 -28.878  13.008  1.00  5.50           C  
ATOM    744  C   CYS A  84     -34.529 -30.111  13.767  1.00  7.59           C  
ATOM    745  O   CYS A  84     -34.068 -31.230  13.518  1.00  4.91           O  
ATOM    746  CB  CYS A  84     -33.976 -29.163  11.514  1.00  3.83           C  
ATOM    747  SG  CYS A  84     -35.635 -29.535  11.031  1.00  7.32           S  
ATOM    748  H   CYS A  84     -31.953 -29.232  13.127  1.00 15.00           H  
ATOM    749  N   GLU A  85     -35.482 -29.911  14.674  1.00  7.56           N  
ATOM    750  CA  GLU A  85     -36.020 -31.007  15.487  1.00  9.80           C  
ATOM    751  C   GLU A  85     -36.374 -32.298  14.754  1.00  8.25           C  
ATOM    752  O   GLU A  85     -35.810 -33.351  15.049  1.00  9.33           O  
ATOM    753  CB  GLU A  85     -37.227 -30.545  16.320  1.00 14.95           C  
ATOM    754  CG  GLU A  85     -36.878 -29.634  17.490  1.00 22.07           C  
ATOM    755  CD  GLU A  85     -38.073 -29.318  18.383  1.00 23.22           C  
ATOM    756  OE1 GLU A  85     -39.203 -29.168  17.865  1.00 25.25           O  
ATOM    757  OE2 GLU A  85     -37.875 -29.213  19.612  1.00 26.48           O  
ATOM    758  H   GLU A  85     -35.828 -28.995  14.755  1.00 15.00           H  
ATOM    759  N   PRO A  86     -37.279 -32.237  13.763  1.00  6.85           N  
ATOM    760  CA  PRO A  86     -37.625 -33.480  13.063  1.00  8.52           C  
ATOM    761  C   PRO A  86     -36.494 -34.130  12.282  1.00  8.51           C  
ATOM    762  O   PRO A  86     -36.585 -35.302  11.926  1.00 12.03           O  
ATOM    763  CB  PRO A  86     -38.772 -33.053  12.148  1.00  8.42           C  
ATOM    764  CG  PRO A  86     -38.458 -31.626  11.856  1.00 10.54           C  
ATOM    765  CD  PRO A  86     -38.022 -31.096  13.201  1.00  7.99           C  
ATOM    766  N   HIS A  87     -35.412 -33.395  12.049  1.00  9.62           N  
ATOM    767  CA  HIS A  87     -34.300 -33.936  11.286  1.00  7.84           C  
ATOM    768  C   HIS A  87     -32.979 -33.974  12.036  1.00  7.25           C  
ATOM    769  O   HIS A  87     -31.912 -34.058  11.423  1.00  8.60           O  
ATOM    770  CB  HIS A  87     -34.163 -33.164   9.977  1.00  5.60           C  
ATOM    771  CG  HIS A  87     -35.376 -33.258   9.108  1.00  6.33           C  
ATOM    772  ND1 HIS A  87     -35.949 -32.162   8.505  1.00  7.73           N  
ATOM    773  CD2 HIS A  87     -36.135 -34.321   8.752  1.00  7.23           C  
ATOM    774  CE1 HIS A  87     -37.009 -32.544   7.815  1.00  7.36           C  
ATOM    775  NE2 HIS A  87     -37.143 -33.850   7.949  1.00  4.40           N  
ATOM    776  H   HIS A  87     -35.319 -32.498  12.435  1.00 15.00           H  
ATOM    777  HE2 HIS A  87     -37.843 -34.394   7.519  1.00 15.00           H  
ATOM    778  N   ARG A  88     -33.050 -33.962  13.362  1.00  7.92           N  
ATOM    779  CA  ARG A  88     -31.848 -33.988  14.182  1.00  9.95           C  
ATOM    780  C   ARG A  88     -31.035 -35.255  13.915  1.00 10.12           C  
ATOM    781  O   ARG A  88     -29.814 -35.195  13.763  1.00 10.68           O  
ATOM    782  CB  ARG A  88     -32.205 -33.881  15.667  1.00 11.90           C  
ATOM    783  CG  ARG A  88     -31.001 -33.627  16.554  1.00 13.75           C  
ATOM    784  CD  ARG A  88     -31.392 -33.476  18.007  1.00 19.09           C  
ATOM    785  NE  ARG A  88     -30.290 -32.935  18.800  1.00 19.67           N  
ATOM    786  CZ  ARG A  88     -30.427 -32.407  20.013  1.00 23.65           C  
ATOM    787  NH1 ARG A  88     -31.624 -32.341  20.585  1.00 24.94           N  
ATOM    788  NH2 ARG A  88     -29.363 -31.951  20.658  1.00 24.83           N  
ATOM    789  H   ARG A  88     -33.923 -33.904  13.800  1.00 15.00           H  
ATOM    790  HE  ARG A  88     -29.389 -32.961  18.415  1.00 15.00           H  
ATOM    791 HH11 ARG A  88     -32.434 -32.689  20.113  1.00 15.00           H  
ATOM    792 HH12 ARG A  88     -31.714 -31.942  21.497  1.00 15.00           H  
ATOM    793 HH21 ARG A  88     -28.460 -32.005  20.230  1.00 15.00           H  
ATOM    794 HH22 ARG A  88     -29.463 -31.553  21.570  1.00 15.00           H  
ATOM    795  N   GLY A  89     -31.723 -36.389  13.811  1.00 12.20           N  
ATOM    796  CA  GLY A  89     -31.052 -37.652  13.550  1.00 10.24           C  
ATOM    797  C   GLY A  89     -30.288 -37.643  12.238  1.00  8.97           C  
ATOM    798  O   GLY A  89     -29.215 -38.229  12.132  1.00  6.58           O  
ATOM    799  H   GLY A  89     -32.698 -36.376  13.896  1.00 15.00           H  
ATOM    800  N   ALA A  90     -30.837 -36.971  11.235  1.00  8.37           N  
ATOM    801  CA  ALA A  90     -30.189 -36.880   9.932  1.00  7.23           C  
ATOM    802  C   ALA A  90     -29.017 -35.898   9.982  1.00  9.13           C  
ATOM    803  O   ALA A  90     -28.309 -35.711   8.990  1.00  6.77           O  
ATOM    804  CB  ALA A  90     -31.197 -36.457   8.869  1.00  7.15           C  
ATOM    805  H   ALA A  90     -31.706 -36.534  11.374  1.00 15.00           H  
ATOM    806  N   GLY A  91     -28.831 -35.251  11.129  1.00  9.18           N  
ATOM    807  CA  GLY A  91     -27.735 -34.313  11.281  1.00  7.44           C  
ATOM    808  C   GLY A  91     -27.980 -32.921  10.733  1.00  4.86           C  
ATOM    809  O   GLY A  91     -27.034 -32.238  10.348  1.00  4.94           O  
ATOM    810  H   GLY A  91     -29.428 -35.395  11.887  1.00 15.00           H  
ATOM    811  N   MET A  92     -29.238 -32.496  10.687  1.00  5.98           N  
ATOM    812  CA  MET A  92     -29.556 -31.163  10.191  1.00  3.49           C  
ATOM    813  C   MET A  92     -29.320 -30.160  11.322  1.00  6.65           C  
ATOM    814  O   MET A  92     -30.226 -29.855  12.108  1.00  5.05           O  
ATOM    815  CB  MET A  92     -31.001 -31.096   9.696  1.00  3.61           C  
ATOM    816  CG  MET A  92     -31.317 -29.834   8.895  1.00  3.82           C  
ATOM    817  SD  MET A  92     -32.946 -29.885   8.088  1.00  6.33           S  
ATOM    818  CE  MET A  92     -32.914 -28.277   7.315  1.00  4.74           C  
ATOM    819  H   MET A  92     -29.968 -33.075  10.995  1.00 15.00           H  
ATOM    820  N   VAL A  93     -28.076 -29.708  11.433  1.00  4.99           N  
ATOM    821  CA  VAL A  93     -27.675 -28.757  12.455  1.00  5.76           C  
ATOM    822  C   VAL A  93     -26.983 -27.555  11.808  1.00  6.51           C  
ATOM    823  O   VAL A  93     -26.507 -27.634  10.671  1.00  4.56           O  
ATOM    824  CB  VAL A  93     -26.727 -29.410  13.476  1.00  6.69           C  
ATOM    825  CG1 VAL A  93     -27.454 -30.530  14.221  1.00  7.96           C  
ATOM    826  CG2 VAL A  93     -25.490 -29.952  12.775  1.00  6.66           C  
ATOM    827  H   VAL A  93     -27.403 -30.014  10.784  1.00 15.00           H  
ATOM    828  N   GLY A  94     -26.929 -26.447  12.538  1.00  4.41           N  
ATOM    829  CA  GLY A  94     -26.307 -25.245  12.021  1.00  3.75           C  
ATOM    830  C   GLY A  94     -25.605 -24.460  13.106  1.00  4.75           C  
ATOM    831  O   GLY A  94     -25.637 -24.834  14.288  1.00  3.41           O  
ATOM    832  H   GLY A  94     -27.272 -26.442  13.455  1.00 15.00           H  
ATOM    833  N   LYS A  95     -25.045 -23.321  12.715  1.00  5.18           N  
ATOM    834  CA  LYS A  95     -24.311 -22.463  13.630  1.00  4.27           C  
ATOM    835  C   LYS A  95     -24.285 -21.034  13.109  1.00  3.35           C  
ATOM    836  O   LYS A  95     -24.164 -20.807  11.904  1.00  2.35           O  
ATOM    837  CB  LYS A  95     -22.894 -23.024  13.755  1.00  5.47           C  
ATOM    838  CG  LYS A  95     -21.858 -22.209  14.498  1.00  6.43           C  
ATOM    839  CD  LYS A  95     -20.606 -23.074  14.599  1.00  8.12           C  
ATOM    840  CE  LYS A  95     -19.392 -22.337  15.093  1.00  9.99           C  
ATOM    841  NZ  LYS A  95     -18.273 -23.299  15.291  1.00 12.58           N  
ATOM    842  H   LYS A  95     -25.096 -23.056  11.772  1.00 15.00           H  
ATOM    843  HZ1 LYS A  95     -18.076 -23.793  14.399  1.00 15.00           H  
ATOM    844  HZ2 LYS A  95     -17.420 -22.790  15.601  1.00 15.00           H  
ATOM    845  HZ3 LYS A  95     -18.542 -23.996  16.016  1.00 15.00           H  
ATOM    846  N   VAL A  96     -24.486 -20.079  14.012  1.00  5.64           N  
ATOM    847  CA  VAL A  96     -24.444 -18.656  13.680  1.00  4.99           C  
ATOM    848  C   VAL A  96     -23.398 -18.026  14.593  1.00  6.72           C  
ATOM    849  O   VAL A  96     -23.456 -18.188  15.814  1.00  6.34           O  
ATOM    850  CB  VAL A  96     -25.802 -17.943  13.925  1.00  4.13           C  
ATOM    851  CG1 VAL A  96     -25.697 -16.461  13.550  1.00  2.00           C  
ATOM    852  CG2 VAL A  96     -26.909 -18.603  13.117  1.00  3.27           C  
ATOM    853  H   VAL A  96     -24.668 -20.324  14.941  1.00 15.00           H  
ATOM    854  N   VAL A  97     -22.393 -17.388  14.003  1.00  5.53           N  
ATOM    855  CA  VAL A  97     -21.351 -16.732  14.787  1.00  5.95           C  
ATOM    856  C   VAL A  97     -21.626 -15.240  14.671  1.00  6.66           C  
ATOM    857  O   VAL A  97     -21.678 -14.699  13.566  1.00  7.90           O  
ATOM    858  CB  VAL A  97     -19.922 -17.052  14.259  1.00  5.68           C  
ATOM    859  CG1 VAL A  97     -18.872 -16.251  15.036  1.00  3.91           C  
ATOM    860  CG2 VAL A  97     -19.627 -18.546  14.388  1.00  2.63           C  
ATOM    861  H   VAL A  97     -22.364 -17.329  13.029  1.00 15.00           H  
ATOM    862  N   VAL A  98     -21.876 -14.594  15.805  1.00  7.12           N  
ATOM    863  CA  VAL A  98     -22.162 -13.161  15.829  1.00  5.94           C  
ATOM    864  C   VAL A  98     -20.959 -12.457  16.448  1.00  6.15           C  
ATOM    865  O   VAL A  98     -20.534 -12.807  17.550  1.00  4.66           O  
ATOM    866  CB  VAL A  98     -23.439 -12.871  16.649  1.00  5.01           C  
ATOM    867  CG1 VAL A  98     -23.838 -11.417  16.516  1.00  3.32           C  
ATOM    868  CG2 VAL A  98     -24.579 -13.777  16.181  1.00  2.00           C  
ATOM    869  H   VAL A  98     -21.857 -15.085  16.643  1.00 15.00           H  
ATOM    870  N   GLU A  99     -20.384 -11.504  15.720  1.00  9.18           N  
ATOM    871  CA  GLU A  99     -19.209 -10.778  16.201  1.00 14.59           C  
ATOM    872  C   GLU A  99     -19.419  -9.273  16.351  1.00 14.37           C  
ATOM    873  O   GLU A  99     -20.409  -8.741  15.815  1.00 13.96           O  
ATOM    874  CB  GLU A  99     -18.011 -11.029  15.281  1.00 16.04           C  
ATOM    875  CG  GLU A  99     -17.663 -12.493  15.092  1.00 19.23           C  
ATOM    876  CD  GLU A  99     -16.256 -12.698  14.570  1.00 20.71           C  
ATOM    877  OE1 GLU A  99     -15.885 -12.059  13.562  1.00 19.87           O  
ATOM    878  OE2 GLU A  99     -15.520 -13.507  15.173  1.00 23.36           O  
ATOM    879  OXT GLU A  99     -18.567  -8.639  17.003  1.00 18.20           O  
ATOM    880  H   GLU A  99     -20.746 -11.248  14.845  1.00 15.00           H  
TER     881      GLU A  99                                                      
END
MOLECULE T0390.pdb
ATOM   1417  N   ALA    29     -25.126  -7.662   1.817  1.00100.22           N  
ATOM   1418  CA  ALA    29     -24.203  -6.752   2.561  1.00102.70           C  
ATOM   1419  CB  ALA    29     -24.370  -5.286   2.082  1.00105.39           C  
ATOM   1420  C   ALA    29     -24.440  -6.859   4.069  1.00100.61           C  
ATOM   1421  O   ALA    29     -23.542  -6.584   4.874  1.00103.55           O  
ATOM   1422  N   ASP    30     -25.642  -7.297   4.438  1.00 95.26           N  
ATOM   1423  CA  ASP    30     -26.174  -7.076   5.775  1.00 90.56           C  
ATOM   1424  CB  ASP    30     -27.168  -5.921   5.687  1.00 92.74           C  
ATOM   1425  CG  ASP    30     -27.589  -5.421   7.032  1.00 94.90           C  
ATOM   1426  OD1 ASP    30     -26.753  -5.488   7.957  1.00 97.71           O  
ATOM   1427  OD2 ASP    30     -28.748  -4.962   7.166  1.00 95.01           O  
ATOM   1428  C   ASP    30     -26.877  -8.312   6.349  1.00 85.08           C  
ATOM   1429  O   ASP    30     -26.918  -8.504   7.567  1.00 84.01           O  
ATOM   1430  N   ARG    31     -27.450  -9.130   5.464  1.00 79.52           N  
ATOM   1431  CA  ARG    31     -28.160 -10.341   5.860  1.00 73.24           C  
ATOM   1432  CB  ARG    31     -29.676 -10.248   5.558  1.00 73.02           C  
ATOM   1433  CG  ARG    31     -30.128  -9.281   4.458  1.00 71.63           C  
ATOM   1434  CD  ARG    31     -31.576  -8.824   4.658  1.00 70.77           C  
ATOM   1435  NE  ARG    31     -32.323  -9.800   5.444  1.00 70.30           N  
ATOM   1436  CZ  ARG    31     -33.224  -9.495   6.379  1.00 69.91           C  
ATOM   1437  NH1 ARG    31     -33.825 -10.465   7.068  1.00 64.29           N  
ATOM   1438  NH2 ARG    31     -33.513  -8.226   6.639  1.00 66.83           N  
ATOM   1439  C   ARG    31     -27.541 -11.632   5.309  1.00 70.84           C  
ATOM   1440  O   ARG    31     -27.034 -11.668   4.203  1.00 72.53           O  
ATOM   1441  N   HIS    32     -27.579 -12.687   6.107  1.00 67.66           N  
ATOM   1442  CA  HIS    32     -26.995 -13.968   5.743  1.00 65.70           C  
ATOM   1443  CB  HIS    32     -26.038 -14.432   6.839  1.00 64.57           C  
ATOM   1444  CG  HIS    32     -25.079 -13.377   7.294  1.00 65.98           C  
ATOM   1445  ND1 HIS    32     -23.753 -13.361   6.918  1.00 68.45           N  
ATOM   1446  CE1 HIS    32     -23.147 -12.327   7.473  1.00 68.52           C  
ATOM   1447  NE2 HIS    32     -24.034 -11.668   8.197  1.00 70.63           N  
ATOM   1448  CD2 HIS    32     -25.247 -12.309   8.110  1.00 68.60           C  
ATOM   1449  C   HIS    32     -28.097 -15.016   5.529  1.00 64.32           C  
ATOM   1450  O   HIS    32     -29.034 -15.140   6.326  1.00 64.73           O  
ATOM   1451  N   THR    33     -27.991 -15.763   4.443  1.00 64.18           N  
ATOM   1452  CA  THR    33     -29.026 -16.716   4.069  1.00 61.66           C  
ATOM   1453  CB  THR    33     -29.371 -16.572   2.588  1.00 60.48           C  
ATOM   1454  OG1 THR    33     -29.757 -15.222   2.336  1.00 64.06           O  
ATOM   1455  CG2 THR    33     -30.515 -17.473   2.204  1.00 60.36           C  
ATOM   1456  C   THR    33     -28.563 -18.133   4.345  1.00 60.90           C  
ATOM   1457  O   THR    33     -27.470 -18.523   3.937  1.00 61.38           O  
ATOM   1458  N   VAL    34     -29.394 -18.893   5.050  1.00 59.79           N  
ATOM   1459  CA  VAL    34     -29.129 -20.304   5.279  1.00 58.71           C  
ATOM   1460  CB  VAL    34     -28.924 -20.615   6.781  1.00 58.54           C  
ATOM   1461  CG1 VAL    34     -28.753 -22.122   7.003  1.00 54.88           C  
ATOM   1462  CG2 VAL    34     -27.724 -19.842   7.322  1.00 58.10           C  
ATOM   1463  C   VAL    34     -30.292 -21.119   4.737  1.00 58.02           C  
ATOM   1464  O   VAL    34     -31.439 -20.929   5.132  1.00 57.92           O  
ATOM   1465  N   PHE    35     -29.997 -22.021   3.816  1.00 58.93           N  
ATOM   1466  CA  PHE    35     -31.014 -22.945   3.330  1.00 57.38           C  
ATOM   1467  CB  PHE    35     -30.754 -23.313   1.873  1.00 56.05           C  
ATOM   1468  CG  PHE    35     -30.974 -22.168   0.935  1.00 57.38           C  
ATOM   1469  CD1 PHE    35     -29.944 -21.264   0.661  1.00 58.82           C  
ATOM   1470  CE1 PHE    35     -30.149 -20.180  -0.191  1.00 57.97           C  
ATOM   1471  CZ  PHE    35     -31.402 -19.989  -0.771  1.00 58.81           C  
ATOM   1472  CE2 PHE    35     -32.447 -20.877  -0.492  1.00 56.51           C  
ATOM   1473  CD2 PHE    35     -32.230 -21.953   0.363  1.00 58.39           C  
ATOM   1474  C   PHE    35     -31.087 -24.155   4.248  1.00 58.31           C  
ATOM   1475  O   PHE    35     -30.221 -25.039   4.194  1.00 59.87           O  
ATOM   1476  N   TRP    36     -32.103 -24.175   5.118  1.00 56.23           N  
ATOM   1477  CA  TRP    36     -32.240 -25.269   6.062  1.00 54.10           C  
ATOM   1478  CB  TRP    36     -33.030 -24.851   7.307  1.00 52.43           C  
ATOM   1479  CG  TRP    36     -32.664 -25.690   8.480  1.00 50.06           C  
ATOM   1480  CD1 TRP    36     -33.078 -26.955   8.722  1.00 50.33           C  
ATOM   1481  NE1 TRP    36     -32.518 -27.428   9.883  1.00 54.82           N  
ATOM   1482  CE2 TRP    36     -31.709 -26.461  10.418  1.00 54.47           C  
ATOM   1483  CD2 TRP    36     -31.769 -25.344   9.551  1.00 52.76           C  
ATOM   1484  CE3 TRP    36     -31.039 -24.192   9.881  1.00 53.93           C  
ATOM   1485  CZ3 TRP    36     -30.269 -24.199  11.060  1.00 53.49           C  
ATOM   1486  CH2 TRP    36     -30.216 -25.339  11.891  1.00 51.75           C  
ATOM   1487  CZ2 TRP    36     -30.924 -26.476  11.588  1.00 51.62           C  
ATOM   1488  C   TRP    36     -32.884 -26.471   5.415  1.00 54.79           C  
ATOM   1489  O   TRP    36     -34.088 -26.652   5.506  1.00 55.66           O  
ATOM   1490  N   ASN    37     -32.095 -27.299   4.748  1.00 57.05           N  
ATOM   1491  CA  ASN    37     -32.637 -28.573   4.245  1.00 59.69           C  
ATOM   1492  CB  ASN    37     -33.492 -28.399   2.962  1.00 59.25           C  
ATOM   1493  CG  ASN    37     -32.663 -28.102   1.708  1.00 63.24           C  
ATOM   1494  OD1 ASN    37     -31.855 -28.934   1.251  1.00 65.74           O  
ATOM   1495  ND2 ASN    37     -32.895 -26.924   1.119  1.00 67.21           N  
ATOM   1496  C   ASN    37     -31.539 -29.627   4.114  1.00 60.96           C  
ATOM   1497  O   ASN    37     -30.354 -29.274   4.027  1.00 62.64           O  
ATOM   1498  N   SER    38     -31.916 -30.903   4.110  1.00 60.38           N  
ATOM   1499  CA  SER    38     -30.911 -31.965   4.214  1.00 63.35           C  
ATOM   1500  CB  SER    38     -31.532 -33.268   4.692  1.00 64.11           C  
ATOM   1501  OG  SER    38     -32.155 -33.900   3.602  1.00 70.02           O  
ATOM   1502  C   SER    38     -30.080 -32.216   2.954  1.00 63.69           C  
ATOM   1503  O   SER    38     -29.178 -33.033   2.998  1.00 63.92           O  
ATOM   1504  N   SER    39     -30.385 -31.519   1.856  1.00 63.86           N  
ATOM   1505  CA  SER    39     -29.558 -31.551   0.639  1.00 64.78           C  
ATOM   1506  CB  SER    39     -30.398 -31.342  -0.618  1.00 63.72           C  
ATOM   1507  OG  SER    39     -31.246 -32.437  -0.826  1.00 67.02           O  
ATOM   1508  C   SER    39     -28.510 -30.464   0.641  1.00 64.68           C  
ATOM   1509  O   SER    39     -27.688 -30.405  -0.267  1.00 68.02           O  
ATOM   1510  N   ASN    40     -28.573 -29.562   1.611  1.00 62.24           N  
ATOM   1511  CA  ASN    40     -27.614 -28.481   1.656  1.00 61.94           C  
ATOM   1512  CB  ASN    40     -28.096 -27.368   2.590  1.00 59.83           C  
ATOM   1513  CG  ASN    40     -27.194 -26.152   2.559  1.00 59.19           C  
ATOM   1514  OD1 ASN    40     -26.036 -26.220   2.101  1.00 59.05           O  
ATOM   1515  ND2 ASN    40     -27.716 -25.020   3.038  1.00 52.18           N  
ATOM   1516  C   ASN    40     -26.279 -29.030   2.130  1.00 62.98           C  
ATOM   1517  O   ASN    40     -26.143 -29.337   3.314  1.00 65.11           O  
ATOM   1518  N   PRO    41     -25.284 -29.124   1.226  1.00 63.55           N  
ATOM   1519  CA  PRO    41     -24.003 -29.741   1.548  1.00 64.85           C  
ATOM   1520  CB  PRO    41     -23.161 -29.492   0.286  1.00 66.12           C  
ATOM   1521  CG  PRO    41     -24.138 -29.321  -0.799  1.00 65.91           C  
ATOM   1522  CD  PRO    41     -25.298 -28.614  -0.158  1.00 64.70           C  
ATOM   1523  C   PRO    41     -23.309 -29.122   2.757  1.00 65.52           C  
ATOM   1524  O   PRO    41     -22.517 -29.791   3.419  1.00 66.69           O  
ATOM   1525  N   LYS    42     -23.600 -27.861   3.053  1.00 62.16           N  
ATOM   1526  CA  LYS    42     -22.900 -27.169   4.135  1.00 64.34           C  
ATOM   1527  CB  LYS    42     -23.244 -25.682   4.133  1.00 63.63           C  
ATOM   1528  CG  LYS    42     -22.820 -25.020   2.851  1.00 62.79           C  
ATOM   1529  CD  LYS    42     -22.705 -23.542   3.001  1.00 64.18           C  
ATOM   1530  CE  LYS    42     -22.140 -22.977   1.727  1.00 68.95           C  
ATOM   1531  NZ  LYS    42     -22.825 -21.712   1.400  1.00 74.60           N  
ATOM   1532  C   LYS    42     -23.112 -27.783   5.511  1.00 65.92           C  
ATOM   1533  O   LYS    42     -22.289 -27.611   6.401  1.00 68.21           O  
ATOM   1534  N   PHE    43     -24.204 -28.528   5.656  1.00 67.42           N  
ATOM   1535  CA  PHE    43     -24.552 -29.227   6.882  1.00 69.26           C  
ATOM   1536  CB  PHE    43     -26.053 -29.547   6.881  1.00 68.78           C  
ATOM   1537  CG  PHE    43     -26.924 -28.367   7.194  1.00 70.15           C  
ATOM   1538  CD1 PHE    43     -26.880 -27.767   8.448  1.00 70.44           C  
ATOM   1539  CE1 PHE    43     -27.676 -26.680   8.742  1.00 72.10           C  
ATOM   1540  CZ  PHE    43     -28.537 -26.175   7.786  1.00 70.06           C  
ATOM   1541  CE2 PHE    43     -28.591 -26.758   6.534  1.00 70.66           C  
ATOM   1542  CD2 PHE    43     -27.787 -27.853   6.240  1.00 69.34           C  
ATOM   1543  C   PHE    43     -23.773 -30.525   7.054  1.00 72.65           C  
ATOM   1544  O   PHE    43     -23.779 -31.128   8.144  1.00 74.80           O  
ATOM   1545  N   ARG    44     -23.136 -30.972   5.972  1.00 73.67           N  
ATOM   1546  CA  ARG    44     -22.502 -32.284   5.941  1.00 77.35           C  
ATOM   1547  CB  ARG    44     -22.077 -32.683   4.518  1.00 77.02           C  
ATOM   1548  CG  ARG    44     -21.282 -33.978   4.439  1.00 80.74           C  
ATOM   1549  CD  ARG    44     -21.486 -34.745   3.146  1.00 81.73           C  
ATOM   1550  NE  ARG    44     -21.030 -33.978   1.996  1.00 76.92           N  
ATOM   1551  CZ  ARG    44     -21.830 -33.528   1.042  1.00 71.12           C  
ATOM   1552  NH1 ARG    44     -23.122 -33.781   1.075  1.00 65.89           N  
ATOM   1553  NH2 ARG    44     -21.329 -32.832   0.046  1.00 73.50           N  
ATOM   1554  C   ARG    44     -21.350 -32.397   6.936  1.00 81.28           C  
ATOM   1555  O   ARG    44     -21.137 -33.462   7.494  1.00 84.45           O  
ATOM   1556  N   ASN    45     -20.623 -31.320   7.196  1.00 83.31           N  
ATOM   1557  CA  ASN    45     -19.516 -31.458   8.129  1.00 89.14           C  
ATOM   1558  CB  ASN    45     -18.325 -30.589   7.706  1.00 90.67           C  
ATOM   1562  C   ASN    45     -19.916 -31.277   9.611  1.00 91.62           C  
ATOM   1563  O   ASN    45     -19.147 -31.615  10.520  1.00 93.86           O  
ATOM   1564  N   GLU    46     -21.134 -30.775   9.842  1.00 91.09           N  
ATOM   1565  CA  GLU    46     -21.671 -30.506  11.198  1.00 92.01           C  
ATOM   1566  CB  GLU    46     -21.888 -31.807  11.993  1.00 94.29           C  
ATOM   1567  CG  GLU    46     -22.673 -32.872  11.210  1.00 95.61           C  
ATOM   1568  CD  GLU    46     -23.036 -34.121  12.024  1.00 99.79           C  
ATOM   1569  OE1 GLU    46     -22.526 -34.300  13.160  1.00103.61           O  
ATOM   1570  OE2 GLU    46     -23.840 -34.935  11.507  1.00101.22           O  
ATOM   1571  C   GLU    46     -20.797 -29.487  11.942  1.00 91.41           C  
ATOM   1572  O   GLU    46     -20.872 -29.328  13.166  1.00 92.29           O  
ATOM   1573  N   ASP    47     -19.977 -28.798  11.151  1.00 89.12           N  
ATOM   1574  CA  ASP    47     -19.143 -27.686  11.586  1.00 87.14           C  
ATOM   1575  CB  ASP    47     -17.695 -27.903  11.124  1.00 89.68           C  
ATOM   1576  CG  ASP    47     -17.562 -28.039   9.587  1.00 90.74           C  
ATOM   1577  OD1 ASP    47     -18.585 -28.119   8.855  1.00 86.38           O  
ATOM   1578  OD2 ASP    47     -16.405 -28.084   9.107  1.00 97.26           O  
ATOM   1579  C   ASP    47     -19.679 -26.375  10.998  1.00 82.03           C  
ATOM   1580  O   ASP    47     -19.103 -25.319  11.209  1.00 81.44           O  
ATOM   1581  N   TYR    48     -20.770 -26.462  10.242  1.00 77.20           N  
ATOM   1582  CA  TYR    48     -21.382 -25.302   9.609  1.00 74.21           C  
ATOM   1583  CB  TYR    48     -22.776 -25.676   9.067  1.00 73.30           C  
ATOM   1584  CG  TYR    48     -23.420 -24.667   8.120  1.00 71.47           C  
ATOM   1585  CD1 TYR    48     -24.744 -24.834   7.695  1.00 70.66           C  
ATOM   1586  CE1 TYR    48     -25.343 -23.923   6.819  1.00 68.10           C  
ATOM   1587  CZ  TYR    48     -24.620 -22.830   6.373  1.00 68.15           C  
ATOM   1588  OH  TYR    48     -25.197 -21.932   5.519  1.00 67.00           O  
ATOM   1589  CE2 TYR    48     -23.306 -22.637   6.772  1.00 68.50           C  
ATOM   1590  CD2 TYR    48     -22.712 -23.550   7.644  1.00 70.49           C  
ATOM   1591  C   TYR    48     -21.477 -24.102  10.558  1.00 73.61           C  
ATOM   1592  O   TYR    48     -22.263 -24.101  11.524  1.00 75.01           O  
ATOM   1593  N   THR    49     -20.664 -23.088  10.297  1.00 70.93           N  
ATOM   1594  CA  THR    49     -20.736 -21.870  11.090  1.00 69.64           C  
ATOM   1595  CB  THR    49     -19.715 -21.855  12.277  1.00 71.04           C  
ATOM   1596  OG1 THR    49     -19.033 -20.605  12.302  1.00 71.14           O  
ATOM   1597  CG2 THR    49     -18.697 -22.930  12.166  1.00 68.82           C  
ATOM   1598  C   THR    49     -20.658 -20.593  10.240  1.00 67.14           C  
ATOM   1599  O   THR    49     -19.863 -20.517   9.341  1.00 65.65           O  
ATOM   1600  N   ILE    50     -21.514 -19.613  10.523  1.00 66.24           N  
ATOM   1601  CA  ILE    50     -21.489 -18.336   9.811  1.00 64.98           C  
ATOM   1602  CB  ILE    50     -22.823 -18.008   9.090  1.00 65.33           C  
ATOM   1603  CG1 ILE    50     -23.910 -17.657  10.099  1.00 65.90           C  
ATOM   1604  CD1 ILE    50     -25.306 -17.700   9.521  1.00 73.93           C  
ATOM   1605  CG2 ILE    50     -23.256 -19.148   8.131  1.00 61.42           C  
ATOM   1606  C   ILE    50     -21.133 -17.213  10.787  1.00 65.67           C  
ATOM   1607  O   ILE    50     -21.490 -17.266  11.967  1.00 67.03           O  
ATOM   1608  N   HIS    51     -20.416 -16.212  10.284  1.00 64.25           N  
ATOM   1609  CA  HIS    51     -19.943 -15.105  11.084  1.00 63.60           C  
ATOM   1610  CB  HIS    51     -18.461 -14.901  10.835  1.00 65.49           C  
ATOM   1611  CG  HIS    51     -17.630 -16.088  11.195  1.00 70.79           C  
ATOM   1612  ND1 HIS    51     -16.951 -16.185  12.391  1.00 72.94           N  
ATOM   1613  CE1 HIS    51     -16.306 -17.337  12.435  1.00 74.97           C  
ATOM   1614  NE2 HIS    51     -16.554 -17.996  11.315  1.00 76.53           N  
ATOM   1615  CD2 HIS    51     -17.379 -17.236  10.521  1.00 73.32           C  
ATOM   1616  C   HIS    51     -20.703 -13.827  10.766  1.00 62.09           C  
ATOM   1617  O   HIS    51     -20.801 -13.415   9.603  1.00 61.03           O  
ATOM   1618  N   VAL    52     -21.230 -13.201  11.812  1.00 69.61           N  
ATOM   1619  CA  VAL    52     -22.065 -12.016  11.665  1.00 70.27           C  
ATOM   1620  CB  VAL    52     -23.525 -12.331  12.044  1.00 67.94           C  
ATOM   1621  CG1 VAL    52     -24.048 -13.516  11.256  1.00 63.91           C  
ATOM   1622  CG2 VAL    52     -23.629 -12.617  13.529  1.00 68.74           C  
ATOM   1623  C   VAL    52     -21.559 -10.871  12.551  1.00 73.22           C  
ATOM   1624  O   VAL    52     -20.790 -11.094  13.483  1.00 76.04           O  
ATOM   1625  N   GLN    53     -21.982  -9.646  12.255  1.00 74.46           N  
ATOM   1626  CA  GLN    53     -21.798  -8.534  13.178  1.00 75.33           C  
ATOM   1627  CB  GLN    53     -21.370  -7.303  12.422  1.00 77.79           C  
ATOM   1628  CG  GLN    53     -19.888  -7.222  12.255  1.00 84.78           C  
ATOM   1629  CD  GLN    53     -19.520  -6.296  11.150  1.00 89.93           C  
ATOM   1630  OE1 GLN    53     -18.901  -5.262  11.383  1.00 95.34           O  
ATOM   1631  NE2 GLN    53     -19.918  -6.641   9.926  1.00 90.84           N  
ATOM   1632  C   GLN    53     -23.100  -8.246  13.889  1.00 73.89           C  
ATOM   1633  O   GLN    53     -24.169  -8.667  13.432  1.00 71.87           O  
ATOM   1634  N   LEU    54     -23.025  -7.517  15.000  1.00 73.96           N  
ATOM   1635  CA  LEU    54     -24.246  -7.075  15.664  1.00 71.54           C  
ATOM   1636  CB  LEU    54     -23.954  -6.115  16.806  1.00 71.37           C  
ATOM   1637  CG  LEU    54     -23.720  -6.645  18.210  1.00 72.19           C  
ATOM   1638  CD1 LEU    54     -23.657  -5.431  19.127  1.00 73.28           C  
ATOM   1639  CD2 LEU    54     -24.804  -7.628  18.678  1.00 67.76           C  
ATOM   1640  C   LEU    54     -25.153  -6.381  14.666  1.00 70.96           C  
ATOM   1641  O   LEU    54     -24.707  -5.548  13.849  1.00 71.38           O  
ATOM   1642  N   ASN    55     -26.428  -6.742  14.736  1.00 69.55           N  
ATOM   1643  CA  ASN    55     -27.474  -6.128  13.911  1.00 69.72           C  
ATOM   1644  CB  ASN    55     -27.358  -4.594  13.915  1.00 68.97           C  
ATOM   1645  CG  ASN    55     -27.478  -3.990  15.318  1.00 68.73           C  
ATOM   1646  OD1 ASN    55     -28.078  -4.564  16.239  1.00 67.86           O  
ATOM   1647  ND2 ASN    55     -26.916  -2.809  15.474  1.00 63.22           N  
ATOM   1648  C   ASN    55     -27.554  -6.673  12.476  1.00 68.55           C  
ATOM   1649  O   ASN    55     -28.342  -6.181  11.669  1.00 70.93           O  
ATOM   1650  N   ASP    56     -26.726  -7.665  12.166  1.00 66.57           N  
ATOM   1651  CA  ASP    56     -26.859  -8.418  10.942  1.00 65.55           C  
ATOM   1652  CB  ASP    56     -25.652  -9.322  10.761  1.00 65.62           C  
ATOM   1653  CG  ASP    56     -24.514  -8.651  10.026  1.00 68.09           C  
ATOM   1654  OD1 ASP    56     -24.612  -7.445   9.702  1.00 66.77           O  
ATOM   1655  OD2 ASP    56     -23.516  -9.357   9.761  1.00 67.96           O  
ATOM   1656  C   ASP    56     -28.089  -9.293  11.110  1.00 65.11           C  
ATOM   1657  O   ASP    56     -28.506  -9.552  12.236  1.00 66.56           O  
ATOM   1658  N   TYR    57     -28.674  -9.730  10.000  1.00 63.82           N  
ATOM   1659  CA  TYR    57     -29.793 -10.661  10.019  1.00 60.75           C  
ATOM   1660  CB  TYR    57     -30.909 -10.165   9.111  1.00 60.51           C  
ATOM   1661  CG  TYR    57     -31.478  -8.826   9.488  1.00 60.28           C  
ATOM   1662  CD1 TYR    57     -30.823  -7.665   9.124  1.00 59.46           C  
ATOM   1663  CE1 TYR    57     -31.331  -6.431   9.445  1.00 61.40           C  
ATOM   1664  CZ  TYR    57     -32.522  -6.335  10.141  1.00 63.64           C  
ATOM   1665  OH  TYR    57     -32.970  -5.069  10.441  1.00 64.74           O  
ATOM   1666  CE2 TYR    57     -33.214  -7.481  10.538  1.00 56.59           C  
ATOM   1667  CD2 TYR    57     -32.685  -8.721  10.207  1.00 56.20           C  
ATOM   1668  C   TYR    57     -29.340 -12.004   9.493  1.00 61.12           C  
ATOM   1669  O   TYR    57     -28.496 -12.082   8.592  1.00 62.46           O  
ATOM   1670  N   VAL    58     -29.890 -13.064  10.059  1.00 60.56           N  
ATOM   1671  CA  VAL    58     -29.754 -14.388   9.476  1.00 61.46           C  
ATOM   1672  CB  VAL    58     -29.112 -15.394  10.452  1.00 62.00           C  
ATOM   1673  CG1 VAL    58     -29.223 -16.821   9.915  1.00 62.86           C  
ATOM   1674  CG2 VAL    58     -27.636 -15.015  10.717  1.00 63.40           C  
ATOM   1675  C   VAL    58     -31.146 -14.830   9.040  1.00 61.87           C  
ATOM   1676  O   VAL    58     -32.103 -14.802   9.834  1.00 61.13           O  
ATOM   1677  N   ASP    59     -31.259 -15.175   7.759  1.00 61.42           N  
ATOM   1678  CA  ASP    59     -32.509 -15.634   7.188  1.00 60.73           C  
ATOM   1679  CB  ASP    59     -32.779 -14.965   5.841  1.00 59.72           C  
ATOM   1680  CG  ASP    59     -33.157 -13.529   5.976  1.00 62.55           C  
ATOM   1681  OD1 ASP    59     -33.782 -13.172   6.996  1.00 64.16           O  
ATOM   1682  OD2 ASP    59     -32.827 -12.745   5.059  1.00 62.03           O  
ATOM   1683  C   ASP    59     -32.407 -17.135   7.001  1.00 61.61           C  
ATOM   1684  O   ASP    59     -31.683 -17.625   6.098  1.00 62.81           O  
ATOM   1685  N   ILE    60     -33.113 -17.875   7.851  1.00 60.05           N  
ATOM   1686  CA  ILE    60     -33.134 -19.316   7.706  1.00 58.69           C  
ATOM   1687  CB  ILE    60     -33.207 -20.005   9.061  1.00 58.77           C  
ATOM   1688  CG1 ILE    60     -31.917 -19.708   9.836  1.00 57.57           C  
ATOM   1689  CD1 ILE    60     -31.964 -20.141  11.282  1.00 62.49           C  
ATOM   1690  CG2 ILE    60     -33.386 -21.487   8.896  1.00 51.16           C  
ATOM   1691  C   ILE    60     -34.311 -19.610   6.811  1.00 59.83           C  
ATOM   1692  O   ILE    60     -35.418 -19.114   7.034  1.00 62.33           O  
ATOM   1693  N   ILE    61     -34.053 -20.361   5.753  1.00 59.42           N  
ATOM   1694  CA  ILE    61     -35.051 -20.588   4.715  1.00 57.99           C  
ATOM   1695  CB  ILE    61     -34.537 -20.065   3.359  1.00 58.11           C  
ATOM   1696  CG1 ILE    61     -34.261 -18.561   3.510  1.00 59.93           C  
ATOM   1697  CD1 ILE    61     -34.251 -17.783   2.223  1.00 68.98           C  
ATOM   1698  CG2 ILE    61     -35.531 -20.369   2.238  1.00 54.24           C  
ATOM   1699  C   ILE    61     -35.520 -22.048   4.711  1.00 57.94           C  
ATOM   1700  O   ILE    61     -34.737 -22.976   4.495  1.00 57.11           O  
ATOM   1701  N   CYS    62     -36.799 -22.234   5.020  1.00 57.55           N  
ATOM   1702  CA  CYS    62     -37.363 -23.561   5.162  1.00 57.79           C  
ATOM   1703  CB  CYS    62     -38.765 -23.461   5.742  1.00 58.68           C  
ATOM   1704  SG  CYS    62     -38.799 -22.883   7.422  1.00 66.56           S  
ATOM   1705  C   CYS    62     -37.433 -24.289   3.819  1.00 57.44           C  
ATOM   1706  O   CYS    62     -37.503 -23.648   2.745  1.00 55.57           O  
ATOM   1707  N   PRO    63     -37.446 -25.630   3.867  1.00 56.37           N  
ATOM   1708  CA  PRO    63     -37.635 -26.391   2.631  1.00 56.48           C  
ATOM   1709  CB  PRO    63     -37.788 -27.822   3.122  1.00 55.81           C  
ATOM   1710  CG  PRO    63     -37.139 -27.837   4.468  1.00 55.54           C  
ATOM   1711  CD  PRO    63     -37.321 -26.490   5.058  1.00 54.90           C  
ATOM   1712  C   PRO    63     -38.929 -25.913   1.958  1.00 57.83           C  
ATOM   1713  O   PRO    63     -39.911 -25.648   2.654  1.00 59.36           O  
ATOM   1714  N   HIS    64     -38.914 -25.745   0.638  1.00 58.32           N  
ATOM   1715  CA  HIS    64     -40.073 -25.230  -0.081  1.00 61.05           C  
ATOM   1716  CB  HIS    64     -40.011 -23.704  -0.172  1.00 61.33           C  
ATOM   1717  CG  HIS    64     -41.251 -23.101  -0.744  1.00 66.07           C  
ATOM   1718  ND1 HIS    64     -41.315 -22.614  -2.034  1.00 66.04           N  
ATOM   1719  CE1 HIS    64     -42.541 -22.187  -2.279  1.00 64.89           C  
ATOM   1720  NE2 HIS    64     -43.281 -22.399  -1.205  1.00 65.72           N  
ATOM   1721  CD2 HIS    64     -42.499 -22.973  -0.231  1.00 66.30           C  
ATOM   1722  C   HIS    64     -40.197 -25.864  -1.480  1.00 64.10           C  
ATOM   1723  O   HIS    64     -39.187 -26.138  -2.125  1.00 67.04           O  
ATOM   1724  N   TYR    65     -41.428 -26.104  -1.937  1.00 72.57           N  
ATOM   1725  CA  TYR    65     -41.699 -26.882  -3.156  1.00 76.38           C  
ATOM   1726  CB  TYR    65     -42.080 -28.311  -2.754  1.00 72.47           C  
ATOM   1727  CG  TYR    65     -41.120 -29.016  -1.817  1.00 70.31           C  
ATOM   1728  CD1 TYR    65     -40.185 -29.943  -2.306  1.00 67.92           C  
ATOM   1729  CE1 TYR    65     -39.299 -30.600  -1.441  1.00 63.29           C  
ATOM   1730  CZ  TYR    65     -39.348 -30.339  -0.074  1.00 63.03           C  
ATOM   1731  OH  TYR    65     -38.483 -30.981   0.779  1.00 63.79           O  
ATOM   1732  CE2 TYR    65     -40.263 -29.430   0.441  1.00 59.33           C  
ATOM   1733  CD2 TYR    65     -41.156 -28.783  -0.429  1.00 64.70           C  
ATOM   1734  C   TYR    65     -42.867 -26.320  -3.985  1.00 83.17           C  
ATOM   1735  O   TYR    65     -43.901 -25.969  -3.419  1.00 84.72           O  
ATOM   1736  N   GLU    66     -42.738 -26.257  -5.312  1.00 90.45           N  
ATOM   1737  CA  GLU    66     -43.927 -26.059  -6.179  1.00 98.45           C  
ATOM   1738  CB  GLU    66     -44.130 -24.595  -6.612  1.00102.82           C  
ATOM   1739  CG  GLU    66     -43.040 -23.979  -7.503  1.00111.20           C  
ATOM   1740  CD  GLU    66     -42.169 -22.963  -6.758  1.00114.90           C  
ATOM   1741  OE1 GLU    66     -40.926 -23.075  -6.824  1.00115.44           O  
ATOM   1742  OE2 GLU    66     -42.724 -22.050  -6.102  1.00117.13           O  
ATOM   1743  C   GLU    66     -43.980 -27.002  -7.387  1.00102.18           C  
ATOM   1744  O   GLU    66     -44.502 -28.115  -7.289  1.00104.08           O  
ATOM   1745  N   SER    69     -43.697 -30.660  -8.211  1.00101.20           N  
ATOM   1746  CA  SER    69     -44.454 -31.494  -7.282  1.00 99.05           C  
ATOM   1747  CB  SER    69     -45.901 -31.685  -7.755  1.00102.51           C  
ATOM   1748  OG  SER    69     -46.792 -30.960  -6.923  1.00102.15           O  
ATOM   1749  C   SER    69     -43.814 -32.847  -6.967  1.00 97.17           C  
ATOM   1750  O   SER    69     -43.726 -33.722  -7.819  1.00 97.34           O  
ATOM   1751  N   VAL    70     -43.349 -32.973  -5.724  1.00 93.77           N  
ATOM   1752  CA  VAL    70     -43.077 -34.264  -5.088  1.00 91.09           C  
ATOM   1753  CB  VAL    70     -41.686 -34.279  -4.362  1.00 88.12           C  
ATOM   1754  CG1 VAL    70     -41.781 -33.761  -2.949  1.00 81.91           C  
ATOM   1755  CG2 VAL    70     -40.646 -33.473  -5.150  1.00 88.49           C  
ATOM   1756  C   VAL    70     -44.264 -34.534  -4.133  1.00 89.28           C  
ATOM   1757  O   VAL    70     -45.079 -33.638  -3.896  1.00 88.69           O  
ATOM   1758  N   ALA    71     -44.386 -35.759  -3.618  1.00 88.48           N  
ATOM   1759  CA  ALA    71     -45.512 -36.123  -2.738  1.00 87.33           C  
ATOM   1760  CB  ALA    71     -45.593 -37.634  -2.538  1.00 87.21           C  
ATOM   1761  C   ALA    71     -45.417 -35.405  -1.391  1.00 83.85           C  
ATOM   1762  O   ALA    71     -44.327 -35.003  -0.963  1.00 80.71           O  
ATOM   1763  N   ASP    72     -46.558 -35.250  -0.725  1.00 83.63           N  
ATOM   1764  CA  ASP    72     -46.614 -34.429   0.474  1.00 80.95           C  
ATOM   1765  CB  ASP    72     -48.051 -34.287   0.985  1.00 82.60           C  
ATOM   1766  CG  ASP    72     -48.947 -33.501   0.017  1.00 87.82           C  
ATOM   1767  OD1 ASP    72     -48.434 -32.765  -0.860  1.00 87.73           O  
ATOM   1768  OD2 ASP    72     -50.184 -33.624   0.121  1.00 95.01           O  
ATOM   1769  C   ASP    72     -45.661 -34.957   1.530  1.00 77.55           C  
ATOM   1770  O   ASP    72     -44.869 -34.195   2.083  1.00 76.39           O  
ATOM   1771  N   ALA    73     -45.705 -36.274   1.729  1.00 77.84           N  
ATOM   1772  CA  ALA    73     -44.862 -37.023   2.666  1.00 75.61           C  
ATOM   1773  CB  ALA    73     -45.247 -38.531   2.639  1.00 76.99           C  
ATOM   1774  C   ALA    73     -43.356 -36.865   2.430  1.00 73.95           C  
ATOM   1775  O   ALA    73     -42.561 -37.082   3.347  1.00 73.95           O  
ATOM   1776  N   ALA    74     -42.968 -36.506   1.211  1.00 74.52           N  
ATOM   1777  CA  ALA    74     -41.553 -36.360   0.861  1.00 73.72           C  
ATOM   1778  CB  ALA    74     -41.306 -36.775  -0.591  1.00 75.34           C  
ATOM   1779  C   ALA    74     -41.030 -34.949   1.105  1.00 71.93           C  
ATOM   1780  O   ALA    74     -39.824 -34.717   1.057  1.00 72.75           O  
ATOM   1781  N   MET    75     -41.934 -34.009   1.355  1.00 70.52           N  
ATOM   1782  CA  MET    75     -41.547 -32.625   1.621  1.00 68.82           C  
ATOM   1783  CB  MET    75     -42.743 -31.690   1.429  1.00 68.84           C  
ATOM   1784  CG  MET    75     -43.196 -31.636  -0.008  1.00 72.32           C  
ATOM   1785  SD  MET    75     -44.675 -30.673  -0.173  1.00 75.06           S  
ATOM   1786  CE  MET    75     -45.027 -30.899  -1.910  1.00 77.34           C  
ATOM   1787  C   MET    75     -40.969 -32.503   3.022  1.00 66.12           C  
ATOM   1788  O   MET    75     -41.580 -32.964   3.987  1.00 67.76           O  
ATOM   1789  N   GLU    76     -39.783 -31.904   3.125  1.00 64.15           N  
ATOM   1790  CA  GLU    76     -39.064 -31.797   4.391  1.00 59.73           C  
ATOM   1791  CB  GLU    76     -37.593 -31.439   4.153  1.00 57.36           C  
ATOM   1792  CG  GLU    76     -36.784 -32.590   3.629  1.00 59.39           C  
ATOM   1793  CD  GLU    76     -35.304 -32.277   3.423  1.00 62.61           C  
ATOM   1794  OE1 GLU    76     -34.775 -31.364   4.072  1.00 67.17           O  
ATOM   1795  OE2 GLU    76     -34.657 -32.958   2.596  1.00 68.04           O  
ATOM   1796  C   GLU    76     -39.736 -30.778   5.293  1.00 59.34           C  
ATOM   1797  O   GLU    76     -40.135 -29.705   4.828  1.00 59.93           O  
ATOM   1798  N   GLN    77     -39.882 -31.144   6.572  1.00 59.36           N  
ATOM   1799  CA  GLN    77     -40.472 -30.296   7.619  1.00 57.88           C  
ATOM   1800  CB  GLN    77     -41.919 -30.704   7.882  1.00 57.46           C  
ATOM   1801  CG  GLN    77     -42.835 -30.354   6.717  1.00 58.86           C  
ATOM   1802  CD  GLN    77     -44.317 -30.511   7.033  1.00 59.59           C  
ATOM   1803  OE1 GLN    77     -44.847 -29.870   7.936  1.00 63.94           O  
ATOM   1804  NE2 GLN    77     -44.992 -31.342   6.266  1.00 55.64           N  
ATOM   1805  C   GLN    77     -39.649 -30.348   8.910  1.00 57.23           C  
ATOM   1806  O   GLN    77     -39.163 -31.411   9.298  1.00 60.33           O  
ATOM   1807  N   TYR    78     -39.485 -29.206   9.573  1.00 55.69           N  
ATOM   1808  CA  TYR    78     -38.585 -29.122  10.726  1.00 54.25           C  
ATOM   1809  CB  TYR    78     -37.189 -28.585  10.334  1.00 53.16           C  
ATOM   1810  CG  TYR    78     -36.440 -29.474   9.362  1.00 53.66           C  
ATOM   1811  CD1 TYR    78     -36.418 -29.181   7.994  1.00 54.30           C  
ATOM   1812  CE1 TYR    78     -35.739 -30.006   7.087  1.00 54.63           C  
ATOM   1813  CZ  TYR    78     -35.081 -31.136   7.552  1.00 53.74           C  
ATOM   1814  OH  TYR    78     -34.428 -31.941   6.658  1.00 57.55           O  
ATOM   1815  CE2 TYR    78     -35.082 -31.453   8.907  1.00 50.12           C  
ATOM   1816  CD2 TYR    78     -35.762 -30.617   9.804  1.00 52.20           C  
ATOM   1817  C   TYR    78     -39.156 -28.230  11.797  1.00 54.51           C  
ATOM   1818  O   TYR    78     -39.933 -27.312  11.507  1.00 56.08           O  
ATOM   1819  N   ILE    79     -38.766 -28.514  13.035  1.00 51.82           N  
ATOM   1820  CA  ILE    79     -38.847 -27.546  14.104  1.00 51.12           C  
ATOM   1821  CB  ILE    79     -39.334 -28.221  15.370  1.00 51.00           C  
ATOM   1822  CG1 ILE    79     -40.703 -28.835  15.118  1.00 49.34           C  
ATOM   1823  CD1 ILE    79     -41.115 -29.806  16.168  1.00 50.72           C  
ATOM   1824  CG2 ILE    79     -39.395 -27.223  16.509  1.00 50.32           C  
ATOM   1825  C   ILE    79     -37.424 -27.002  14.286  1.00 51.25           C  
ATOM   1826  O   ILE    79     -36.473 -27.789  14.393  1.00 51.15           O  
ATOM   1827  N   LEU    80     -37.264 -25.678  14.247  1.00 51.43           N  
ATOM   1828  CA  LEU    80     -35.970 -25.052  14.544  1.00 51.30           C  
ATOM   1829  CB  LEU    80     -35.733 -23.773  13.747  1.00 50.95           C  
ATOM   1830  CG  LEU    80     -35.744 -23.937  12.244  1.00 60.64           C  
ATOM   1831  CD1 LEU    80     -35.792 -22.573  11.544  1.00 61.99           C  
ATOM   1832  CD2 LEU    80     -34.546 -24.797  11.786  1.00 63.14           C  
ATOM   1833  C   LEU    80     -35.969 -24.674  16.006  1.00 50.47           C  
ATOM   1834  O   LEU    80     -36.946 -24.102  16.507  1.00 48.99           O  
ATOM   1835  N   TYR    81     -34.853 -24.968  16.666  1.00 49.53           N  
ATOM   1836  CA  TYR    81     -34.639 -24.601  18.040  1.00 49.40           C  
ATOM   1837  CB  TYR    81     -34.361 -25.849  18.868  1.00 49.48           C  
ATOM   1838  CG  TYR    81     -35.456 -26.905  18.856  1.00 47.03           C  
ATOM   1839  CD1 TYR    81     -35.465 -27.922  17.897  1.00 45.23           C  
ATOM   1840  CE1 TYR    81     -36.455 -28.906  17.906  1.00 46.90           C  
ATOM   1841  CZ  TYR    81     -37.454 -28.867  18.884  1.00 47.72           C  
ATOM   1842  OH  TYR    81     -38.450 -29.810  18.909  1.00 46.06           O  
ATOM   1843  CE2 TYR    81     -37.466 -27.866  19.832  1.00 44.80           C  
ATOM   1844  CD2 TYR    81     -36.468 -26.892  19.813  1.00 44.50           C  
ATOM   1845  C   TYR    81     -33.436 -23.681  18.136  1.00 50.84           C  
ATOM   1846  O   TYR    81     -32.490 -23.797  17.359  1.00 50.00           O  
ATOM   1847  N   LEU    82     -33.482 -22.759  19.091  1.00 51.39           N  
ATOM   1848  CA  LEU    82     -32.329 -21.943  19.401  1.00 50.54           C  
ATOM   1849  CB  LEU    82     -32.675 -20.462  19.332  1.00 51.46           C  
ATOM   1850  CG  LEU    82     -31.645 -19.457  19.872  1.00 51.59           C  
ATOM   1851  CD1 LEU    82     -30.399 -19.422  19.001  1.00 47.87           C  
ATOM   1852  CD2 LEU    82     -32.281 -18.073  19.963  1.00 49.07           C  
ATOM   1853  C   LEU    82     -31.879 -22.343  20.803  1.00 53.80           C  
ATOM   1854  O   LEU    82     -32.631 -22.182  21.768  1.00 54.04           O  
ATOM   1855  N   VAL    83     -30.652 -22.864  20.892  1.00 54.38           N  
ATOM   1856  CA  VAL    83     -30.192 -23.633  22.038  1.00 55.15           C  
ATOM   1857  CB  VAL    83     -30.160 -25.178  21.716  1.00 56.46           C  
ATOM   1858  CG1 VAL    83     -31.544 -25.722  21.351  1.00 55.39           C  
ATOM   1859  CG2 VAL    83     -29.123 -25.511  20.636  1.00 51.14           C  
ATOM   1860  C   VAL    83     -28.786 -23.248  22.465  1.00 57.18           C  
ATOM   1861  O   VAL    83     -28.015 -22.688  21.679  1.00 59.96           O  
ATOM   1862  N   GLU    84     -28.447 -23.609  23.698  1.00 58.16           N  
ATOM   1863  CA  GLU    84     -27.095 -23.449  24.241  1.00 59.82           C  
ATOM   1864  CB  GLU    84     -27.160 -23.477  25.766  1.00 61.80           C  
ATOM   1865  CG  GLU    84     -26.808 -22.172  26.402  1.00 70.34           C  
ATOM   1866  CD  GLU    84     -28.000 -21.311  26.688  1.00 76.51           C  
ATOM   1867  OE1 GLU    84     -28.225 -21.041  27.881  1.00 86.83           O  
ATOM   1868  OE2 GLU    84     -28.711 -20.886  25.749  1.00 78.44           O  
ATOM   1869  C   GLU    84     -26.093 -24.502  23.704  1.00 59.28           C  
ATOM   1870  O   GLU    84     -26.508 -25.525  23.141  1.00 56.78           O  
ATOM   1871  N   HIS    85     -24.791 -24.253  23.887  1.00 60.18           N  
ATOM   1872  CA  HIS    85     -23.742 -25.108  23.332  1.00 62.00           C  
ATOM   1873  CB  HIS    85     -22.362 -24.689  23.847  1.00 65.71           C  
ATOM   1874  CG  HIS    85     -21.220 -25.432  23.214  1.00 71.02           C  
ATOM   1875  ND1 HIS    85     -20.571 -24.981  22.082  1.00 75.54           N  
ATOM   1876  CE1 HIS    85     -19.606 -25.827  21.758  1.00 78.42           C  
ATOM   1877  NE2 HIS    85     -19.607 -26.812  22.640  1.00 78.22           N  
ATOM   1878  CD2 HIS    85     -20.598 -26.584  23.567  1.00 74.86           C  
ATOM   1879  C   HIS    85     -23.976 -26.598  23.597  1.00 63.27           C  
ATOM   1880  O   HIS    85     -23.889 -27.416  22.680  1.00 63.02           O  
ATOM   1881  N   GLU    86     -24.288 -26.955  24.838  1.00 65.23           N  
ATOM   1882  CA  GLU    86     -24.501 -28.359  25.162  1.00 67.93           C  
ATOM   1883  CB  GLU    86     -24.722 -28.557  26.653  1.00 71.08           C  
ATOM   1884  CG  GLU    86     -23.952 -29.758  27.155  1.00 83.00           C  
ATOM   1885  CD  GLU    86     -24.657 -30.510  28.268  1.00 92.71           C  
ATOM   1886  OE1 GLU    86     -25.911 -30.519  28.292  1.00 94.13           O  
ATOM   1887  OE2 GLU    86     -23.948 -31.111  29.113  1.00100.40           O  
ATOM   1888  C   GLU    86     -25.607 -29.063  24.346  1.00 66.02           C  
ATOM   1889  O   GLU    86     -25.435 -30.228  23.956  1.00 66.88           O  
ATOM   1890  N   GLU    87     -26.722 -28.377  24.081  1.00 62.99           N  
ATOM   1891  CA  GLU    87     -27.796 -29.011  23.323  1.00 63.50           C  
ATOM   1892  CB  GLU    87     -29.175 -28.323  23.429  1.00 63.04           C  
ATOM   1893  CG  GLU    87     -29.412 -27.243  24.487  1.00 68.38           C  
ATOM   1894  CD  GLU    87     -29.167 -27.664  25.892  1.00 74.69           C  
ATOM   1895  OE1 GLU    87     -29.010 -28.876  26.187  1.00 81.64           O  
ATOM   1896  OE2 GLU    87     -29.126 -26.745  26.719  1.00 79.95           O  
ATOM   1897  C   GLU    87     -27.386 -29.126  21.867  1.00 62.34           C  
ATOM   1898  O   GLU    87     -27.805 -30.059  21.181  1.00 64.45           O  
ATOM   1899  N   TYR    88     -26.550 -28.187  21.423  1.00 63.12           N  
ATOM   1900  CA  TYR    88     -25.912 -28.205  20.104  1.00 61.10           C  
ATOM   1901  CB  TYR    88     -25.154 -26.896  19.903  1.00 59.37           C  
ATOM   1902  CG  TYR    88     -24.260 -26.797  18.695  1.00 57.11           C  
ATOM   1903  CD1 TYR    88     -24.757 -26.339  17.475  1.00 55.05           C  
ATOM   1904  CE1 TYR    88     -23.923 -26.200  16.363  1.00 56.54           C  
ATOM   1905  CZ  TYR    88     -22.569 -26.521  16.470  1.00 59.03           C  
ATOM   1906  OH  TYR    88     -21.755 -26.397  15.374  1.00 59.09           O  
ATOM   1907  CE2 TYR    88     -22.047 -26.968  17.672  1.00 57.27           C  
ATOM   1908  CD2 TYR    88     -22.899 -27.091  18.785  1.00 58.95           C  
ATOM   1909  C   TYR    88     -24.962 -29.388  19.956  1.00 63.46           C  
ATOM   1910  O   TYR    88     -24.987 -30.068  18.935  1.00 63.63           O  
ATOM   1911  N   GLN    89     -24.129 -29.631  20.965  1.00 65.05           N  
ATOM   1912  CA  GLN    89     -23.289 -30.835  20.982  1.00 68.40           C  
ATOM   1913  CB  GLN    89     -22.433 -30.922  22.254  1.00 70.53           C  
ATOM   1914  CG  GLN    89     -21.312 -29.896  22.351  1.00 75.85           C  
ATOM   1915  CD  GLN    89     -20.242 -30.052  21.266  1.00 82.46           C  
ATOM   1916  OE1 GLN    89     -20.487 -29.788  20.078  1.00 81.02           O  
ATOM   1917  NE2 GLN    89     -19.039 -30.461  21.680  1.00 84.77           N  
ATOM   1918  C   GLN    89     -24.117 -32.109  20.830  1.00 68.19           C  
ATOM   1919  O   GLN    89     -23.823 -32.942  19.982  1.00 68.29           O  
ATOM   1920  N   LEU    90     -25.164 -32.247  21.639  1.00 67.73           N  
ATOM   1921  CA  LEU    90     -25.990 -33.437  21.594  1.00 68.47           C  
ATOM   1922  CB  LEU    90     -26.854 -33.542  22.841  1.00 67.62           C  
ATOM   1923  CG  LEU    90     -26.189 -33.669  24.196  1.00 71.02           C  
ATOM   1924  CD1 LEU    90     -27.305 -33.768  25.225  1.00 72.66           C  
ATOM   1925  CD2 LEU    90     -25.252 -34.868  24.238  1.00 67.89           C  
ATOM   1926  C   LEU    90     -26.901 -33.449  20.382  1.00 68.71           C  
ATOM   1927  O   LEU    90     -27.480 -34.485  20.045  1.00 70.32           O  
ATOM   1928  N   CYS    91     -27.041 -32.298  19.736  1.00 68.07           N  
ATOM   1929  CA  CYS    91     -28.023 -32.114  18.667  1.00 67.06           C  
ATOM   1930  CB  CYS    91     -27.667 -32.918  17.423  1.00 67.58           C  
ATOM   1931  SG  CYS    91     -28.387 -32.185  15.936  1.00 69.63           S  
ATOM   1932  C   CYS    91     -29.428 -32.469  19.133  1.00 66.19           C  
ATOM   1933  O   CYS    91     -30.171 -33.173  18.432  1.00 66.09           O  
ATOM   1934  N   GLN    92     -29.782 -31.987  20.325  1.00 64.97           N  
ATOM   1935  CA  GLN    92     -31.077 -32.297  20.923  1.00 63.97           C  
ATOM   1936  CB  GLN    92     -30.985 -33.573  21.748  1.00 64.98           C  
ATOM   1937  CG  GLN    92     -30.941 -34.800  20.877  1.00 69.42           C  
ATOM   1938  CD  GLN    92     -30.910 -36.068  21.655  1.00 74.34           C  
ATOM   1939  OE1 GLN    92     -31.110 -36.082  22.871  1.00 77.65           O  
ATOM   1940  NE2 GLN    92     -30.660 -37.159  20.962  1.00 73.77           N  
ATOM   1941  C   GLN    92     -31.580 -31.154  21.767  1.00 60.67           C  
ATOM   1942  O   GLN    92     -30.831 -30.623  22.558  1.00 63.52           O  
ATOM   1943  N   PRO    93     -32.863 -30.786  21.616  1.00 57.68           N  
ATOM   1944  CA  PRO    93     -33.422 -29.677  22.366  1.00 54.76           C  
ATOM   1945  CB  PRO    93     -34.789 -29.477  21.711  1.00 54.66           C  
ATOM   1946  CG  PRO    93     -35.181 -30.858  21.276  1.00 55.28           C  
ATOM   1947  CD  PRO    93     -33.881 -31.441  20.772  1.00 57.25           C  
ATOM   1948  C   PRO    93     -33.605 -30.090  23.812  1.00 55.78           C  
ATOM   1949  O   PRO    93     -33.749 -31.275  24.103  1.00 55.61           O  
ATOM   1950  N   GLN    94     -33.587 -29.116  24.712  1.00 57.59           N  
ATOM   1951  CA  GLN    94     -33.746 -29.379  26.135  1.00 59.55           C  
ATOM   1952  CB  GLN    94     -32.842 -28.453  26.950  1.00 59.04           C  
ATOM   1953  CG  GLN    94     -32.957 -28.628  28.458  1.00 66.00           C  
ATOM   1954  CD  GLN    94     -32.433 -27.414  29.230  1.00 73.20           C  
ATOM   1955  OE1 GLN    94     -31.541 -27.545  30.064  1.00 75.62           O  
ATOM   1956  NE2 GLN    94     -32.990 -26.227  28.953  1.00 73.53           N  
ATOM   1957  C   GLN    94     -35.229 -29.195  26.512  1.00 60.25           C  
ATOM   1958  O   GLN    94     -35.777 -29.989  27.294  1.00 61.46           O  
ATOM   1959  N   SER    95     -35.879 -28.180  25.933  1.00 56.75           N  
ATOM   1960  CA  SER    95     -37.274 -27.932  26.237  1.00 59.42           C  
ATOM   1961  CB  SER    95     -37.426 -27.257  27.612  1.00 59.78           C  
ATOM   1962  OG  SER    95     -37.322 -25.853  27.508  1.00 58.11           O  
ATOM   1963  C   SER    95     -38.037 -27.125  25.190  1.00 59.95           C  
ATOM   1964  O   SER    95     -37.461 -26.438  24.342  1.00 60.33           O  
ATOM   1965  N   LYS    96     -39.355 -27.206  25.304  1.00 60.01           N  
ATOM   1966  CA  LYS    96     -40.290 -26.413  24.539  1.00 58.91           C  
ATOM   1967  CB  LYS    96     -41.626 -26.516  25.233  1.00 60.61           C  
ATOM   1968  CG  LYS    96     -42.782 -26.032  24.442  1.00 68.37           C  
ATOM   1969  CD  LYS    96     -43.784 -25.347  25.378  1.00 75.00           C  
ATOM   1970  CE  LYS    96     -43.730 -25.909  26.778  1.00 74.45           C  
ATOM   1971  NZ  LYS    96     -44.618 -25.093  27.628  1.00 79.21           N  
ATOM   1972  C   LYS    96     -39.896 -24.940  24.421  1.00 56.09           C  
ATOM   1973  O   LYS    96     -40.043 -24.355  23.365  1.00 56.18           O  
ATOM   1974  N   ASP    97     -39.395 -24.345  25.497  1.00 55.95           N  
ATOM   1975  CA  ASP    97     -38.973 -22.935  25.490  1.00 55.13           C  
ATOM   1976  CB  ASP    97     -38.387 -22.528  26.830  1.00 55.07           C  
ATOM   1977  CG  ASP    97     -39.370 -22.695  27.965  1.00 61.58           C  
ATOM   1978  OD1 ASP    97     -40.576 -22.939  27.713  1.00 63.49           O  
ATOM   1979  OD2 ASP    97     -38.937 -22.581  29.125  1.00 69.18           O  
ATOM   1980  C   ASP    97     -37.964 -22.609  24.416  1.00 53.95           C  
ATOM   1981  O   ASP    97     -37.852 -21.479  24.022  1.00 56.06           O  
ATOM   1982  N   GLN    98     -37.239 -23.598  23.934  1.00 53.79           N  
ATOM   1983  CA  GLN    98     -36.216 -23.355  22.944  1.00 54.00           C  
ATOM   1984  CB  GLN    98     -35.071 -24.352  23.148  1.00 55.66           C  
ATOM   1985  CG  GLN    98     -34.318 -24.166  24.470  1.00 54.03           C  
ATOM   1986  CD  GLN    98     -33.256 -25.216  24.661  1.00 59.65           C  
ATOM   1987  OE1 GLN    98     -33.483 -26.405  24.401  1.00 60.28           O  
ATOM   1988  NE2 GLN    98     -32.075 -24.791  25.105  1.00 61.36           N  
ATOM   1989  C   GLN    98     -36.723 -23.401  21.496  1.00 54.76           C  
ATOM   1990  O   GLN    98     -35.970 -23.060  20.568  1.00 56.93           O  
ATOM   1991  N   VAL    99     -37.969 -23.844  21.286  1.00 52.58           N  
ATOM   1992  CA  VAL    99     -38.594 -23.762  19.965  1.00 50.25           C  
ATOM   1993  CB  VAL    99     -40.076 -24.225  19.984  1.00 50.43           C  
ATOM   1994  CG1 VAL    99     -40.706 -24.043  18.610  1.00 47.21           C  
ATOM   1995  CG2 VAL    99     -40.194 -25.701  20.411  1.00 49.23           C  
ATOM   1996  C   VAL    99     -38.484 -22.330  19.388  1.00 50.18           C  
ATOM   1997  O   VAL    99     -38.962 -21.373  19.984  1.00 52.07           O  
ATOM   1998  N   ARG   100     -37.853 -22.196  18.228  1.00 51.16           N  
ATOM   1999  CA  ARG   100     -37.633 -20.899  17.587  1.00 50.11           C  
ATOM   2000  CB  ARG   100     -36.235 -20.867  16.976  1.00 48.55           C  
ATOM   2001  CG  ARG   100     -35.839 -19.509  16.445  1.00 49.91           C  
ATOM   2002  CD  ARG   100     -35.920 -18.464  17.561  1.00 46.32           C  
ATOM   2003  NE  ARG   100     -35.676 -17.115  17.061  1.00 45.11           N  
ATOM   2004  CZ  ARG   100     -36.629 -16.253  16.719  1.00 45.48           C  
ATOM   2005  NH1 ARG   100     -37.913 -16.587  16.825  1.00 43.32           N  
ATOM   2006  NH2 ARG   100     -36.291 -15.047  16.267  1.00 44.04           N  
ATOM   2007  C   ARG   100     -38.638 -20.601  16.482  1.00 50.90           C  
ATOM   2008  O   ARG   100     -39.062 -19.444  16.295  1.00 51.44           O  
ATOM   2009  N   TRP   101     -38.968 -21.638  15.720  1.00 50.41           N  
ATOM   2010  CA  TRP   101     -39.852 -21.510  14.569  1.00 50.37           C  
ATOM   2011  CB  TRP   101     -39.224 -20.627  13.482  1.00 47.28           C  
ATOM   2012  CG  TRP   101     -40.273 -20.006  12.575  1.00 46.27           C  
ATOM   2013  CD1 TRP   101     -40.521 -20.311  11.254  1.00 43.91           C  
ATOM   2014  NE1 TRP   101     -41.561 -19.550  10.783  1.00 42.25           N  
ATOM   2015  CE2 TRP   101     -42.007 -18.734  11.793  1.00 43.80           C  
ATOM   2016  CD2 TRP   101     -41.222 -19.001  12.938  1.00 41.79           C  
ATOM   2017  CE3 TRP   101     -41.482 -18.290  14.123  1.00 42.59           C  
ATOM   2018  CZ3 TRP   101     -42.506 -17.349  14.130  1.00 43.83           C  
ATOM   2019  CH2 TRP   101     -43.271 -17.105  12.971  1.00 45.72           C  
ATOM   2020  CZ2 TRP   101     -43.040 -17.787  11.798  1.00 45.42           C  
ATOM   2021  C   TRP   101     -40.176 -22.889  14.007  1.00 51.33           C  
ATOM   2022  O   TRP   101     -39.530 -23.867  14.362  1.00 53.74           O  
ATOM   2023  N   GLN   102     -41.186 -22.977  13.155  1.00 53.13           N  
ATOM   2024  CA  GLN   102     -41.510 -24.248  12.529  1.00 56.47           C  
ATOM   2025  CB  GLN   102     -42.823 -24.769  13.050  1.00 58.58           C  
ATOM   2026  CG  GLN   102     -42.719 -25.076  14.531  1.00 66.85           C  
ATOM   2027  CD  GLN   102     -43.742 -26.074  14.997  1.00 73.38           C  
ATOM   2028  OE1 GLN   102     -43.587 -27.286  14.820  1.00 80.09           O  
ATOM   2029  NE2 GLN   102     -44.795 -25.571  15.609  1.00 75.87           N  
ATOM   2030  C   GLN   102     -41.514 -24.181  11.022  1.00 57.45           C  
ATOM   2031  O   GLN   102     -42.105 -23.277  10.454  1.00 57.22           O  
ATOM   2032  N   CYS   103     -40.808 -25.115  10.383  1.00 56.18           N  
ATOM   2033  CA  CYS   103     -40.872 -25.268   8.940  1.00 56.68           C  
ATOM   2034  CB  CYS   103     -39.542 -25.711   8.356  1.00 57.17           C  
ATOM   2035  SG  CYS   103     -38.285 -24.514   8.632  1.00 64.06           S  
ATOM   2036  C   CYS   103     -41.930 -26.288   8.660  1.00 55.99           C  
ATOM   2037  O   CYS   103     -41.637 -27.431   8.275  1.00 56.24           O  
ATOM   2038  N   ASN   104     -43.172 -25.869   8.856  1.00 56.52           N  
ATOM   2039  CA  ASN   104     -44.287 -26.761   8.665  1.00 57.46           C  
ATOM   2040  CB  ASN   104     -45.009 -27.003   9.992  1.00 55.61           C  
ATOM   2041  CG  ASN   104     -45.675 -25.762  10.538  1.00 56.96           C  
ATOM   2042  OD1 ASN   104     -45.472 -24.663  10.051  1.00 59.86           O  
ATOM   2043  ND2 ASN   104     -46.487 -25.941  11.555  1.00 57.18           N  
ATOM   2044  C   ASN   104     -45.217 -26.255   7.573  1.00 60.54           C  
ATOM   2045  O   ASN   104     -46.400 -26.543   7.575  1.00 63.29           O  
ATOM   2046  N   ARG   105     -44.664 -25.509   6.628  1.00 62.17           N  
ATOM   2047  CA  ARG   105     -45.421 -25.062   5.465  1.00 65.71           C  
ATOM   2048  CB  ARG   105     -45.931 -23.631   5.670  1.00 67.60           C  
ATOM   2049  CG  ARG   105     -47.074 -23.602   6.680  1.00 75.21           C  
ATOM   2050  CD  ARG   105     -47.412 -22.219   7.107  1.00 83.04           C  
ATOM   2051  NE  ARG   105     -47.651 -21.397   5.932  1.00 91.36           N  
ATOM   2052  CZ  ARG   105     -47.781 -20.073   5.948  1.00 97.78           C  
ATOM   2053  NH1 ARG   105     -47.985 -19.436   4.800  1.00 98.04           N  
ATOM   2054  NH2 ARG   105     -47.712 -19.387   7.097  1.00 94.61           N  
ATOM   2055  C   ARG   105     -44.589 -25.241   4.194  1.00 65.66           C  
ATOM   2056  O   ARG   105     -44.198 -24.270   3.544  1.00 67.33           O  
ATOM   2057  N   PRO   106     -44.314 -26.506   3.838  1.00 64.89           N  
ATOM   2058  CA  PRO   106     -43.414 -26.796   2.748  1.00 64.10           C  
ATOM   2059  CB  PRO   106     -43.311 -28.313   2.795  1.00 61.91           C  
ATOM   2060  CG  PRO   106     -44.583 -28.753   3.411  1.00 61.26           C  
ATOM   2061  CD  PRO   106     -44.843 -27.744   4.441  1.00 63.43           C  
ATOM   2062  C   PRO   106     -43.945 -26.360   1.392  1.00 66.96           C  
ATOM   2063  O   PRO   106     -43.167 -26.291   0.437  1.00 68.20           O  
ATOM   2064  N   SER   107     -45.241 -26.073   1.271  1.00 68.77           N  
ATOM   2065  CA  SER   107     -45.742 -25.726  -0.077  1.00 70.58           C  
ATOM   2066  CB  SER   107     -46.329 -26.944  -0.815  1.00 70.55           C  
ATOM   2067  OG  SER   107     -47.527 -27.384  -0.225  1.00 69.80           O  
ATOM   2068  C   SER   107     -46.645 -24.493  -0.140  1.00 71.96           C  
ATOM   2069  O   SER   107     -47.411 -24.291  -1.091  1.00 73.54           O  
ATOM   2070  N   ALA   108     -46.505 -23.665   0.884  1.00 72.27           N  
ATOM   2071  CA  ALA   108     -47.066 -22.335   0.930  1.00 73.55           C  
ATOM   2072  CB  ALA   108     -46.320 -21.559   1.979  1.00 73.53           C  
ATOM   2073  C   ALA   108     -46.967 -21.624  -0.432  1.00 76.63           C  
ATOM   2074  O   ALA   108     -45.893 -21.532  -1.033  1.00 75.59           O  
ATOM   2075  N   LYS   109     -48.094 -21.112  -0.917  1.00 81.01           N  
ATOM   2076  CA  LYS   109     -48.118 -20.389  -2.188  1.00 82.67           C  
ATOM   2077  CB  LYS   109     -49.563 -20.159  -2.664  1.00 85.17           C  
ATOM   2082  C   LYS   109     -47.324 -19.076  -2.137  1.00 83.71           C  
ATOM   2083  O   LYS   109     -46.754 -18.673  -3.149  1.00 85.36           O  
ATOM   2084  N   HIS   110     -47.275 -18.434  -0.971  0.50 83.61           N  
ATOM   2086  CA  HIS   110     -46.653 -17.106  -0.834  0.50 85.44           C  
ATOM   2088  CB  HIS   110     -47.170 -16.396   0.429  0.50 86.22           C  
ATOM   2090  CG  HIS   110     -48.625 -16.046   0.382  0.50 86.31           C  
ATOM   2092  ND1 HIS   110     -49.095 -14.788   0.685  0.50 88.73           N  
ATOM   2094  CE1 HIS   110     -50.410 -14.770   0.564  0.50 90.79           C  
ATOM   2096  NE2 HIS   110     -50.812 -15.971   0.190  0.50 87.13           N  
ATOM   2098  CD2 HIS   110     -49.715 -16.788   0.072  0.50 85.88           C  
ATOM   2100  C   HIS   110     -45.108 -17.095  -0.858  0.50 84.28           C  
ATOM   2102  O   HIS   110     -44.493 -16.028  -0.768  0.50 86.17           O  
ATOM   2104  N   GLY   111     -44.491 -18.270  -0.980  1.00 82.38           N  
ATOM   2105  CA  GLY   111     -43.020 -18.387  -1.011  1.00 79.93           C  
ATOM   2106  C   GLY   111     -42.566 -19.306   0.116  1.00 76.67           C  
ATOM   2107  O   GLY   111     -43.411 -19.872   0.818  1.00 77.64           O  
ATOM   2108  N   PRO   112     -41.242 -19.462   0.316  1.00 73.97           N  
ATOM   2109  CA  PRO   112     -40.800 -20.374   1.380  1.00 69.94           C  
ATOM   2110  CB  PRO   112     -39.284 -20.484   1.155  1.00 70.11           C  
ATOM   2111  CG  PRO   112     -39.017 -19.835  -0.179  1.00 71.17           C  
ATOM   2112  CD  PRO   112     -40.100 -18.823  -0.355  1.00 74.32           C  
ATOM   2113  C   PRO   112     -41.055 -19.734   2.728  1.00 68.32           C  
ATOM   2114  O   PRO   112     -41.049 -18.514   2.833  1.00 68.74           O  
ATOM   2115  N   GLU   113     -41.296 -20.554   3.738  1.00 68.03           N  
ATOM   2116  CA  GLU   113     -41.397 -20.072   5.101  1.00 65.88           C  
ATOM   2117  CB  GLU   113     -42.000 -21.158   5.995  1.00 65.23           C  
ATOM   2118  CG  GLU   113     -42.259 -20.757   7.436  1.00 64.92           C  
ATOM   2119  CD  GLU   113     -43.418 -19.811   7.581  1.00 68.45           C  
ATOM   2120  OE1 GLU   113     -43.386 -18.985   8.518  1.00 72.82           O  
ATOM   2121  OE2 GLU   113     -44.362 -19.880   6.763  1.00 72.64           O  
ATOM   2122  C   GLU   113     -39.990 -19.701   5.555  1.00 64.54           C  
ATOM   2123  O   GLU   113     -39.019 -20.358   5.188  1.00 66.12           O  
ATOM   2124  N   LYS   114     -39.881 -18.665   6.371  1.00 64.40           N  
ATOM   2125  CA  LYS   114     -38.593 -18.041   6.646  1.00 64.05           C  
ATOM   2126  CB  LYS   114     -38.414 -16.911   5.629  1.00 65.16           C  
ATOM   2127  CG  LYS   114     -37.179 -16.062   5.742  1.00 70.29           C  
ATOM   2128  CD  LYS   114     -37.256 -14.909   4.722  1.00 73.48           C  
ATOM   2129  CE  LYS   114     -38.129 -13.755   5.235  1.00 79.32           C  
ATOM   2130  NZ  LYS   114     -38.024 -12.564   4.346  1.00 86.89           N  
ATOM   2131  C   LYS   114     -38.510 -17.525   8.099  1.00 61.34           C  
ATOM   2132  O   LYS   114     -39.401 -16.795   8.570  1.00 61.87           O  
ATOM   2133  N   LEU   115     -37.466 -17.942   8.816  1.00 58.06           N  
ATOM   2134  CA  LEU   115     -37.124 -17.352  10.112  1.00 56.46           C  
ATOM   2135  CB  LEU   115     -36.612 -18.423  11.087  1.00 55.24           C  
ATOM   2136  CG  LEU   115     -36.414 -18.079  12.571  1.00 55.58           C  
ATOM   2137  CD1 LEU   115     -35.114 -17.372  12.765  1.00 56.14           C  
ATOM   2138  CD2 LEU   115     -37.571 -17.227  13.152  1.00 51.27           C  
ATOM   2139  C   LEU   115     -36.067 -16.255   9.915  1.00 56.26           C  
ATOM   2140  O   LEU   115     -34.931 -16.558   9.563  1.00 57.13           O  
ATOM   2141  N   SER   116     -36.447 -14.991  10.119  1.00 55.73           N  
ATOM   2142  CA  SER   116     -35.484 -13.866  10.078  1.00 54.72           C  
ATOM   2143  CB  SER   116     -36.058 -12.675   9.318  1.00 53.24           C  
ATOM   2144  OG  SER   116     -36.231 -13.009   7.962  1.00 59.50           O  
ATOM   2145  C   SER   116     -35.078 -13.419  11.482  1.00 53.76           C  
ATOM   2146  O   SER   116     -35.840 -12.760  12.162  1.00 54.96           O  
ATOM   2147  N   GLU   117     -33.873 -13.783  11.888  1.00 53.29           N  
ATOM   2148  CA  GLU   117     -33.348 -13.483  13.202  1.00 55.01           C  
ATOM   2149  CB  GLU   117     -32.501 -14.679  13.692  1.00 54.38           C  
ATOM   2150  CG  GLU   117     -31.960 -14.505  15.075  1.00 53.87           C  
ATOM   2151  CD  GLU   117     -32.976 -14.909  16.118  1.00 59.77           C  
ATOM   2152  OE1 GLU   117     -33.040 -16.118  16.398  1.00 54.27           O  
ATOM   2153  OE2 GLU   117     -33.714 -14.022  16.654  1.00 63.09           O  
ATOM   2154  C   GLU   117     -32.451 -12.254  13.113  1.00 57.04           C  
ATOM   2155  O   GLU   117     -31.441 -12.286  12.407  1.00 61.60           O  
ATOM   2156  N   LYS   118     -32.777 -11.175  13.815  1.00 57.57           N  
ATOM   2157  CA  LYS   118     -31.843 -10.047  13.876  1.00 56.25           C  
ATOM   2158  CB  LYS   118     -32.563  -8.713  13.901  1.00 56.23           C  
ATOM   2159  CG  LYS   118     -31.618  -7.534  13.868  1.00 55.68           C  
ATOM   2160  CD  LYS   118     -32.364  -6.236  14.014  1.00 60.62           C  
ATOM   2161  CE  LYS   118     -31.459  -5.063  13.761  1.00 63.49           C  
ATOM   2162  NZ  LYS   118     -32.307  -3.873  13.602  1.00 66.60           N  
ATOM   2163  C   LYS   118     -30.969 -10.176  15.103  1.00 58.01           C  
ATOM   2164  O   LYS   118     -31.471 -10.341  16.217  1.00 61.22           O  
ATOM   2165  N   PHE   119     -29.660 -10.088  14.909  1.00 57.70           N  
ATOM   2166  CA  PHE   119     -28.732 -10.224  16.011  1.00 57.85           C  
ATOM   2167  CB  PHE   119     -27.428 -10.844  15.494  1.00 58.57           C  
ATOM   2168  CG  PHE   119     -27.559 -12.328  15.221  1.00 58.68           C  
ATOM   2169  CD1 PHE   119     -28.338 -12.791  14.166  1.00 59.09           C  
ATOM   2170  CE1 PHE   119     -28.502 -14.151  13.939  1.00 58.27           C  
ATOM   2171  CZ  PHE   119     -27.888 -15.067  14.769  1.00 58.62           C  
ATOM   2172  CE2 PHE   119     -27.106 -14.622  15.825  1.00 59.67           C  
ATOM   2173  CD2 PHE   119     -26.953 -13.260  16.048  1.00 60.42           C  
ATOM   2174  C   PHE   119     -28.573  -8.927  16.824  1.00 60.49           C  
ATOM   2175  O   PHE   119     -27.512  -8.304  16.846  1.00 62.69           O  
ATOM   2176  N   GLN   120     -29.670  -8.525  17.466  1.00 60.88           N  
ATOM   2177  CA  GLN   120     -29.747  -7.338  18.311  1.00 64.08           C  
ATOM   2178  CB  GLN   120     -31.186  -7.147  18.736  1.00 65.47           C  
ATOM   2179  CG  GLN   120     -32.132  -6.431  17.828  1.00 71.77           C  
ATOM   2180  CD  GLN   120     -33.544  -6.479  18.418  1.00 77.29           C  
ATOM   2181  OE1 GLN   120     -33.995  -7.532  18.888  1.00 75.97           O  
ATOM   2182  NE2 GLN   120     -34.234  -5.334  18.427  1.00 82.70           N  
ATOM   2183  C   GLN   120     -29.014  -7.592  19.618  1.00 66.37           C  
ATOM   2184  O   GLN   120     -28.935  -8.734  20.066  1.00 68.81           O  
ATOM   2185  N   ARG   121     -28.550  -6.534  20.280  1.00 68.12           N  
ATOM   2186  CA  ARG   121     -28.049  -6.671  21.642  1.00 69.56           C  
ATOM   2187  CB  ARG   121     -27.005  -5.591  21.982  1.00 73.03           C  
ATOM   2188  CG  ARG   121     -25.964  -6.019  23.055  1.00 76.86           C  
ATOM   2189  CD  ARG   121     -26.436  -5.615  24.406  1.00 84.36           C  
ATOM   2190  NE  ARG   121     -25.839  -6.289  25.563  1.00 92.25           N  
ATOM   2191  CZ  ARG   121     -26.404  -7.293  26.240  1.00 95.25           C  
ATOM   2192  NH1 ARG   121     -27.569  -7.810  25.850  1.00 91.64           N  
ATOM   2193  NH2 ARG   121     -25.791  -7.798  27.306  1.00 98.78           N  
ATOM   2194  C   ARG   121     -29.187  -6.655  22.657  1.00 70.48           C  
ATOM   2195  O   ARG   121     -29.072  -7.272  23.710  1.00 71.66           O  
ATOM   2196  N   PHE   122     -30.276  -5.954  22.347  1.00 61.20           N  
ATOM   2197  CA  PHE   122     -31.381  -5.819  23.293  1.00 60.75           C  
ATOM   2198  CB  PHE   122     -31.403  -4.418  23.897  1.00 58.60           C  
ATOM   2199  CG  PHE   122     -30.183  -4.059  24.692  1.00 55.90           C  
ATOM   2200  CD1 PHE   122     -29.306  -3.083  24.228  1.00 54.44           C  
ATOM   2201  CE1 PHE   122     -28.172  -2.721  24.978  1.00 54.40           C  
ATOM   2202  CZ  PHE   122     -27.923  -3.334  26.216  1.00 52.99           C  
ATOM   2203  CE2 PHE   122     -28.811  -4.305  26.694  1.00 54.00           C  
ATOM   2204  CD2 PHE   122     -29.937  -4.653  25.933  1.00 54.71           C  
ATOM   2205  C   PHE   122     -32.737  -6.058  22.642  1.00 62.50           C  
ATOM   2206  O   PHE   122     -32.961  -5.561  21.536  1.00 62.87           O  
ATOM   2207  N   THR   123     -33.623  -6.804  23.325  1.00 62.78           N  
ATOM   2208  CA  THR   123     -35.036  -6.962  22.919  1.00 64.29           C  
ATOM   2209  CB  THR   123     -35.596  -8.415  23.030  1.00 64.98           C  
ATOM   2210  OG1 THR   123     -34.571  -9.339  23.418  1.00 68.38           O  
ATOM   2211  CG2 THR   123     -36.347  -8.842  21.760  1.00 66.72           C  
ATOM   2212  C   THR   123     -35.935  -6.295  23.926  1.00 63.38           C  
ATOM   2213  O   THR   123     -35.648  -6.333  25.122  1.00 62.17           O  
ATOM   2214  N   PRO   124     -37.071  -5.759  23.455  1.00 63.85           N  
ATOM   2215  CA  PRO   124     -38.192  -5.496  24.349  1.00 64.11           C  
ATOM   2216  CB  PRO   124     -39.047  -4.519  23.544  1.00 63.16           C  
ATOM   2217  CG  PRO   124     -38.774  -4.886  22.115  1.00 62.79           C  
ATOM   2218  CD  PRO   124     -37.369  -5.378  22.058  1.00 63.83           C  
ATOM   2219  C   PRO   124     -38.989  -6.783  24.635  1.00 65.71           C  
ATOM   2220  O   PRO   124     -39.777  -6.811  25.575  1.00 65.67           O  
ATOM   2221  N   PHE   125     -38.799  -7.834  23.830  1.00 67.48           N  
ATOM   2222  CA  PHE   125     -39.646  -9.025  23.963  1.00 68.12           C  
ATOM   2223  CB  PHE   125     -40.131  -9.572  22.622  1.00 65.98           C  
ATOM   2224  CG  PHE   125     -41.287 -10.510  22.754  1.00 67.79           C  
ATOM   2225  CD1 PHE   125     -41.169 -11.841  22.369  1.00 66.48           C  
ATOM   2226  CE1 PHE   125     -42.241 -12.720  22.495  1.00 65.01           C  
ATOM   2227  CZ  PHE   125     -43.453 -12.281  23.039  1.00 65.56           C  
ATOM   2228  CE2 PHE   125     -43.581 -10.955  23.447  1.00 66.67           C  
ATOM   2229  CD2 PHE   125     -42.500 -10.072  23.297  1.00 68.36           C  
ATOM   2230  C   PHE   125     -39.028 -10.121  24.816  1.00 69.36           C  
ATOM   2231  O   PHE   125     -37.988 -10.675  24.505  1.00 73.04           O  
ATOM   2232  N   THR   126     -39.722 -10.441  25.889  1.00 69.96           N  
ATOM   2233  CA  THR   126     -39.165 -11.208  26.981  1.00 68.85           C  
ATOM   2234  CB  THR   126     -40.046 -10.959  28.226  1.00 68.67           C  
ATOM   2235  OG1 THR   126     -39.214 -10.762  29.367  1.00 75.15           O  
ATOM   2236  CG2 THR   126     -41.043 -12.049  28.459  1.00 65.36           C  
ATOM   2237  C   THR   126     -38.905 -12.693  26.639  1.00 68.68           C  
ATOM   2238  O   THR   126     -38.144 -13.374  27.319  1.00 68.27           O  
ATOM   2239  N   LEU   127     -39.507 -13.159  25.548  1.00 69.14           N  
ATOM   2240  CA  LEU   127     -39.357 -14.539  25.061  1.00 69.56           C  
ATOM   2241  CB  LEU   127     -40.690 -15.040  24.498  1.00 68.06           C  
ATOM   2242  CG  LEU   127     -41.745 -15.722  25.381  1.00 67.52           C  
ATOM   2243  CD1 LEU   127     -41.707 -15.252  26.804  1.00 64.96           C  
ATOM   2244  CD2 LEU   127     -43.142 -15.547  24.789  1.00 67.52           C  
ATOM   2245  C   LEU   127     -38.284 -14.664  23.971  1.00 71.45           C  
ATOM   2246  O   LEU   127     -37.988 -15.766  23.523  1.00 72.49           O  
ATOM   2247  N   GLY   128     -37.725 -13.534  23.536  1.00 70.94           N  
ATOM   2248  CA  GLY   128     -36.696 -13.526  22.509  1.00 71.72           C  
ATOM   2249  C   GLY   128     -35.307 -13.517  23.113  1.00 71.86           C  
ATOM   2250  O   GLY   128     -35.160 -13.397  24.327  1.00 72.73           O  
ATOM   2251  N   LYS   129     -34.288 -13.655  22.265  1.00 71.49           N  
ATOM   2252  CA  LYS   129     -32.902 -13.778  22.712  1.00 70.95           C  
ATOM   2253  CB  LYS   129     -32.228 -14.955  22.001  1.00 71.86           C  
ATOM   2254  CG  LYS   129     -31.407 -15.887  22.907  1.00 76.61           C  
ATOM   2255  CD  LYS   129     -29.935 -15.452  23.062  1.00 77.08           C  
ATOM   2256  CE  LYS   129     -29.113 -16.483  23.848  1.00 74.75           C  
ATOM   2258  C   LYS   129     -32.115 -12.486  22.445  1.00 69.43           C  
ATOM   2259  O   LYS   129     -32.398 -11.740  21.490  1.00 69.19           O  
ATOM   2260  N   GLU   130     -31.133 -12.219  23.295  1.00 66.53           N  
ATOM   2261  CA  GLU   130     -30.216 -11.111  23.069  1.00 63.18           C  
ATOM   2262  CB  GLU   130     -30.119 -10.259  24.310  1.00 60.46           C  
ATOM   2263  CG  GLU   130     -31.446  -9.677  24.676  1.00 58.67           C  
ATOM   2264  CD  GLU   130     -31.343  -8.581  25.707  1.00 64.53           C  
ATOM   2265  OE1 GLU   130     -30.511  -8.684  26.652  1.00 63.02           O  
ATOM   2266  OE2 GLU   130     -32.116  -7.611  25.571  1.00 66.51           O  
ATOM   2267  C   GLU   130     -28.860 -11.652  22.646  1.00 63.11           C  
ATOM   2268  O   GLU   130     -28.440 -12.728  23.084  1.00 65.06           O  
ATOM   2269  N   PHE   131     -28.190 -10.916  21.774  1.00 63.03           N  
ATOM   2270  CA  PHE   131     -26.963 -11.396  21.171  1.00 61.16           C  
ATOM   2271  CB  PHE   131     -27.161 -11.547  19.656  1.00 58.51           C  
ATOM   2272  CG  PHE   131     -28.257 -12.503  19.284  1.00 55.20           C  
ATOM   2273  CD1 PHE   131     -28.003 -13.873  19.198  1.00 51.84           C  
ATOM   2274  CE1 PHE   131     -29.026 -14.768  18.870  1.00 53.42           C  
ATOM   2275  CZ  PHE   131     -30.332 -14.290  18.634  1.00 51.71           C  
ATOM   2276  CE2 PHE   131     -30.592 -12.923  18.741  1.00 53.28           C  
ATOM   2277  CD2 PHE   131     -29.559 -12.040  19.058  1.00 53.90           C  
ATOM   2278  C   PHE   131     -25.827 -10.437  21.480  1.00 63.92           C  
ATOM   2279  O   PHE   131     -25.998  -9.235  21.371  1.00 65.92           O  
ATOM   2280  N   LYS   132     -24.670 -10.970  21.860  1.00 65.44           N  
ATOM   2281  CA  LYS   132     -23.542 -10.152  22.310  1.00 68.20           C  
ATOM   2282  CB  LYS   132     -23.222 -10.464  23.772  1.00 68.50           C  
ATOM   2283  CG  LYS   132     -24.290 -10.012  24.726  1.00 73.51           C  
ATOM   2284  CD  LYS   132     -24.607 -11.080  25.752  1.00 80.61           C  
ATOM   2285  CE  LYS   132     -23.876 -10.832  27.070  1.00 86.59           C  
ATOM   2286  NZ  LYS   132     -24.433 -11.694  28.161  1.00 88.30           N  
ATOM   2287  C   LYS   132     -22.309 -10.378  21.457  1.00 68.97           C  
ATOM   2288  O   LYS   132     -22.055 -11.497  21.017  1.00 68.20           O  
ATOM   2289  N   GLU   133     -21.544  -9.311  21.234  1.00 72.55           N  
ATOM   2290  CA  GLU   133     -20.260  -9.392  20.521  1.00 74.52           C  
ATOM   2291  CB  GLU   133     -19.611  -8.009  20.415  1.00 76.37           C  
ATOM   2292  CG  GLU   133     -20.269  -7.123  19.363  1.00 81.52           C  
ATOM   2293  CD  GLU   133     -19.519  -5.821  19.099  1.00 86.20           C  
ATOM   2294  OE1 GLU   133     -18.317  -5.875  18.747  1.00 96.41           O  
ATOM   2295  OE2 GLU   133     -20.134  -4.734  19.224  1.00 92.30           O  
ATOM   2296  C   GLU   133     -19.304 -10.367  21.191  1.00 72.05           C  
ATOM   2297  O   GLU   133     -19.186 -10.376  22.407  1.00 72.26           O  
ATOM   2298  N   GLY   134     -18.645 -11.199  20.390  1.00 70.84           N  
ATOM   2299  CA  GLY   134     -17.705 -12.198  20.893  1.00 69.51           C  
ATOM   2300  C   GLY   134     -18.303 -13.537  21.292  1.00 68.24           C  
ATOM   2301  O   GLY   134     -17.573 -14.451  21.639  1.00 68.55           O  
ATOM   2302  N   HIS   135     -19.626 -13.659  21.257  1.00 66.41           N  
ATOM   2303  CA  HIS   135     -20.292 -14.907  21.621  1.00 65.15           C  
ATOM   2304  CB  HIS   135     -21.487 -14.628  22.535  1.00 65.77           C  
ATOM   2305  CG  HIS   135     -21.103 -14.116  23.884  1.00 71.66           C  
ATOM   2306  ND1 HIS   135     -20.438 -12.919  24.066  1.00 75.73           N  
ATOM   2307  CE1 HIS   135     -20.231 -12.724  25.357  1.00 76.62           C  
ATOM   2308  NE2 HIS   135     -20.746 -13.745  26.018  1.00 77.98           N  
ATOM   2309  CD2 HIS   135     -21.296 -14.632  25.120  1.00 73.15           C  
ATOM   2310  C   HIS   135     -20.757 -15.690  20.396  1.00 62.81           C  
ATOM   2311  O   HIS   135     -20.812 -15.161  19.280  1.00 63.13           O  
ATOM   2312  N   SER   136     -21.099 -16.953  20.621  1.00 60.44           N  
ATOM   2313  CA  SER   136     -21.619 -17.814  19.576  1.00 58.65           C  
ATOM   2314  CB  SER   136     -20.678 -18.997  19.352  1.00 59.69           C  
ATOM   2315  OG  SER   136     -19.527 -18.622  18.596  1.00 61.55           O  
ATOM   2316  C   SER   136     -23.020 -18.292  19.955  1.00 57.92           C  
ATOM   2317  O   SER   136     -23.352 -18.401  21.137  1.00 56.83           O  
ATOM   2318  N   TYR   137     -23.854 -18.552  18.954  1.00 57.02           N  
ATOM   2319  CA  TYR   137     -25.235 -18.979  19.198  1.00 56.00           C  
ATOM   2320  CB  TYR   137     -26.194 -17.809  18.951  1.00 56.33           C  
ATOM   2321  CG  TYR   137     -25.840 -16.674  19.876  1.00 58.56           C  
ATOM   2322  CD1 TYR   137     -24.865 -15.726  19.518  1.00 58.33           C  
ATOM   2323  CE1 TYR   137     -24.493 -14.719  20.391  1.00 61.81           C  
ATOM   2324  CZ  TYR   137     -25.087 -14.654  21.654  1.00 63.16           C  
ATOM   2325  OH  TYR   137     -24.739 -13.657  22.546  1.00 63.56           O  
ATOM   2326  CE2 TYR   137     -26.041 -15.596  22.032  1.00 60.91           C  
ATOM   2327  CD2 TYR   137     -26.401 -16.602  21.151  1.00 57.19           C  
ATOM   2328  C   TYR   137     -25.497 -20.190  18.337  1.00 54.88           C  
ATOM   2329  O   TYR   137     -24.769 -20.423  17.387  1.00 57.89           O  
ATOM   2330  N   TYR   138     -26.479 -21.000  18.693  1.00 54.02           N  
ATOM   2331  CA  TYR   138     -26.600 -22.323  18.077  1.00 53.58           C  
ATOM   2332  CB  TYR   138     -26.047 -23.415  18.997  1.00 53.48           C  
ATOM   2333  CG  TYR   138     -24.676 -23.098  19.544  1.00 56.27           C  
ATOM   2334  CD1 TYR   138     -24.530 -22.469  20.779  1.00 56.27           C  
ATOM   2335  CE1 TYR   138     -23.286 -22.160  21.278  1.00 54.11           C  
ATOM   2336  CZ  TYR   138     -22.169 -22.470  20.546  1.00 56.08           C  
ATOM   2337  OH  TYR   138     -20.928 -22.166  21.051  1.00 61.04           O  
ATOM   2338  CE2 TYR   138     -22.279 -23.090  19.317  1.00 56.79           C  
ATOM   2339  CD2 TYR   138     -23.529 -23.396  18.819  1.00 55.12           C  
ATOM   2340  C   TYR   138     -28.026 -22.648  17.764  1.00 53.46           C  
ATOM   2341  O   TYR   138     -28.903 -22.512  18.643  1.00 52.33           O  
ATOM   2342  N   TYR   139     -28.246 -23.076  16.516  1.00 52.60           N  
ATOM   2343  CA  TYR   139     -29.530 -23.587  16.079  1.00 51.05           C  
ATOM   2344  CB  TYR   139     -29.997 -22.871  14.817  1.00 50.69           C  
ATOM   2345  CG  TYR   139     -30.236 -21.390  14.980  1.00 53.13           C  
ATOM   2346  CD1 TYR   139     -29.183 -20.481  14.864  1.00 54.96           C  
ATOM   2347  CE1 TYR   139     -29.386 -19.107  14.988  1.00 53.90           C  
ATOM   2348  CZ  TYR   139     -30.658 -18.625  15.251  1.00 56.28           C  
ATOM   2349  OH  TYR   139     -30.846 -17.257  15.382  1.00 53.37           O  
ATOM   2350  CE2 TYR   139     -31.732 -19.519  15.384  1.00 54.77           C  
ATOM   2351  CD2 TYR   139     -31.515 -20.890  15.239  1.00 52.78           C  
ATOM   2352  C   TYR   139     -29.422 -25.074  15.798  1.00 52.04           C  
ATOM   2353  O   TYR   139     -28.415 -25.551  15.236  1.00 52.43           O  
ATOM   2354  N   ILE   140     -30.473 -25.802  16.170  1.00 51.19           N  
ATOM   2355  CA  ILE   140     -30.638 -27.207  15.747  1.00 52.22           C  
ATOM   2356  CB  ILE   140     -30.321 -28.223  16.894  1.00 52.57           C  
ATOM   2357  CG1 ILE   140     -31.370 -28.115  18.016  1.00 50.46           C  
ATOM   2358  CD1 ILE   140     -31.233 -29.136  19.121  1.00 50.31           C  
ATOM   2359  CG2 ILE   140     -28.886 -28.042  17.403  1.00 49.16           C  
ATOM   2360  C   ILE   140     -32.072 -27.438  15.228  1.00 53.15           C  
ATOM   2361  O   ILE   140     -32.980 -26.626  15.473  1.00 54.39           O  
ATOM   2362  N   SER   141     -32.288 -28.544  14.521  1.00 51.34           N  
ATOM   2363  CA  SER   141     -33.649 -28.880  14.134  1.00 49.78           C  
ATOM   2364  CB  SER   141     -33.873 -28.602  12.657  1.00 47.58           C  
ATOM   2365  OG  SER   141     -33.020 -29.391  11.875  1.00 52.50           O  
ATOM   2366  C   SER   141     -34.015 -30.322  14.472  1.00 49.85           C  
ATOM   2367  O   SER   141     -33.152 -31.160  14.743  1.00 51.45           O  
ATOM   2368  N   LYS   142     -35.304 -30.609  14.475  1.00 48.16           N  
ATOM   2369  CA  LYS   142     -35.737 -31.993  14.412  1.00 47.37           C  
ATOM   2370  CB  LYS   142     -36.346 -32.422  15.743  1.00 47.41           C  
ATOM   2371  CG  LYS   142     -35.316 -32.537  16.860  1.00 47.19           C  
ATOM   2372  CD  LYS   142     -34.342 -33.648  16.548  1.00 43.53           C  
ATOM   2373  CE  LYS   142     -33.274 -33.717  17.562  1.00 47.73           C  
ATOM   2374  NZ  LYS   142     -32.273 -34.713  17.167  1.00 48.82           N  
ATOM   2375  C   LYS   142     -36.728 -32.125  13.276  1.00 47.80           C  
ATOM   2376  O   LYS   142     -37.497 -31.202  13.034  1.00 48.97           O  
ATOM   2377  N   PRO   143     -36.738 -33.274  12.577  1.00 48.61           N  
ATOM   2378  CA  PRO   143     -37.716 -33.399  11.502  1.00 47.89           C  
ATOM   2379  CB  PRO   143     -37.321 -34.714  10.821  1.00 49.14           C  
ATOM   2380  CG  PRO   143     -36.032 -35.122  11.405  1.00 50.27           C  
ATOM   2381  CD  PRO   143     -35.966 -34.513  12.758  1.00 48.34           C  
ATOM   2382  C   PRO   143     -39.127 -33.556  12.100  1.00 48.96           C  
ATOM   2383  O   PRO   143     -39.270 -34.143  13.179  1.00 47.48           O  
ATOM   2384  N   ILE   144     -40.156 -33.040  11.423  1.00 48.74           N  
ATOM   2385  CA  ILE   144     -41.517 -33.289  11.867  1.00 46.74           C  
ATOM   2386  CB  ILE   144     -42.472 -32.127  11.522  1.00 45.78           C  
ATOM   2387  CG1 ILE   144     -41.951 -30.828  12.131  1.00 44.71           C  
ATOM   2388  CD1 ILE   144     -42.820 -29.613  11.765  1.00 46.74           C  
ATOM   2389  CG2 ILE   144     -43.862 -32.381  12.092  1.00 37.44           C  
ATOM   2390  C   ILE   144     -42.018 -34.634  11.319  1.00 49.22           C  
ATOM   2391  O   ILE   144     -42.501 -34.723  10.175  1.00 49.54           O  
ATOM   2392  N   HIS   145     -41.901 -35.668  12.157  1.00 48.28           N  
ATOM   2393  CA  HIS   145     -42.348 -37.042  11.841  1.00 50.71           C  
ATOM   2394  CB  HIS   145     -43.857 -37.150  11.576  1.00 48.39           C  
ATOM   2395  CG  HIS   145     -44.717 -36.301  12.464  1.00 51.57           C  
ATOM   2396  ND1 HIS   145     -44.745 -36.432  13.836  1.00 50.86           N  
ATOM   2397  CE1 HIS   145     -45.610 -35.574  14.341  1.00 43.42           C  
ATOM   2398  NE2 HIS   145     -46.159 -34.904  13.345  1.00 46.64           N  
ATOM   2399  CD2 HIS   145     -45.631 -35.349  12.162  1.00 50.88           C  
ATOM   2400  C   HIS   145     -41.646 -37.628  10.636  1.00 52.43           C  
ATOM   2401  O   HIS   145     -42.296 -38.244   9.797  1.00 54.54           O  
ATOM   2402  N   GLN   146     -40.336 -37.442  10.536  1.00 52.92           N  
ATOM   2403  CA  GLN   146     -39.592 -37.881   9.349  1.00 55.41           C  
ATOM   2404  CB  GLN   146     -39.410 -36.722   8.359  1.00 53.53           C  
ATOM   2405  CG  GLN   146     -40.630 -36.348   7.574  1.00 55.08           C  
ATOM   2406  CD  GLN   146     -40.487 -35.032   6.825  1.00 56.54           C  
ATOM   2407  OE1 GLN   146     -39.637 -34.174   7.132  1.00 58.07           O  
ATOM   2408  NE2 GLN   146     -41.331 -34.862   5.839  1.00 57.67           N  
ATOM   2409  C   GLN   146     -38.220 -38.398   9.751  1.00 55.25           C  
ATOM   2410  O   GLN   146     -37.792 -38.164  10.873  1.00 55.18           O  
ATOM   2411  N   HIS   147     -37.550 -39.080   8.823  1.00 56.32           N  
ATOM   2412  CA  HIS   147     -36.165 -39.498   8.982  1.00 59.99           C  
ATOM   2413  CB  HIS   147     -35.621 -40.136   7.690  1.00 60.94           C  
ATOM   2414  CG  HIS   147     -36.204 -41.471   7.365  1.00 65.97           C  
ATOM   2415  ND1 HIS   147     -36.970 -42.195   8.253  1.00 72.70           N  
ATOM   2416  CE1 HIS   147     -37.334 -43.338   7.694  1.00 75.02           C  
ATOM   2417  NE2 HIS   147     -36.824 -43.385   6.475  1.00 74.43           N  
ATOM   2418  CD2 HIS   147     -36.103 -42.235   6.249  1.00 74.39           C  
ATOM   2419  C   HIS   147     -35.246 -38.334   9.381  1.00 59.32           C  
ATOM   2420  O   HIS   147     -35.282 -37.252   8.774  1.00 58.68           O  
ATOM   2421  N   GLU   148     -34.464 -38.563  10.436  1.00 60.00           N  
ATOM   2422  CA  GLU   148     -33.312 -37.729  10.771  1.00 60.66           C  
ATOM   2423  CB  GLU   148     -33.266 -37.478  12.272  1.00 57.72           C  
ATOM   2424  CG  GLU   148     -32.379 -36.290  12.637  1.00 60.69           C  
ATOM   2425  CD  GLU   148     -32.251 -36.078  14.125  1.00 60.94           C  
ATOM   2426  OE1 GLU   148     -32.855 -36.869  14.889  1.00 66.02           O  
ATOM   2427  OE2 GLU   148     -31.542 -35.131  14.528  1.00 56.46           O  
ATOM   2428  C   GLU   148     -32.038 -38.457  10.308  1.00 63.17           C  
ATOM   2429  O   GLU   148     -31.486 -39.293  11.023  1.00 65.37           O  
ATOM   2430  N   ASP   149     -31.601 -38.179   9.093  1.00 64.91           N  
ATOM   2431  CA  ASP   149     -30.511 -38.938   8.483  1.00 69.10           C  
ATOM   2432  CB  ASP   149     -30.521 -38.711   6.977  1.00 71.16           C  
ATOM   2433  CG  ASP   149     -31.526 -39.594   6.254  1.00 77.97           C  
ATOM   2434  OD1 ASP   149     -32.290 -40.349   6.911  1.00 81.56           O  
ATOM   2435  OD2 ASP   149     -31.535 -39.541   5.005  1.00 83.32           O  
ATOM   2436  C   ASP   149     -29.162 -38.512   9.026  1.00 69.28           C  
ATOM   2437  O   ASP   149     -28.202 -39.270   9.020  1.00 72.00           O  
ATOM   2438  N   ARG   150     -29.136 -37.285   9.519  1.00 68.22           N  
ATOM   2439  CA  ARG   150     -27.950 -36.510   9.775  1.00 68.79           C  
ATOM   2440  CB  ARG   150     -27.475 -35.918   8.451  1.00 69.51           C  
ATOM   2441  CG  ARG   150     -26.577 -34.704   8.486  1.00 70.21           C  
ATOM   2442  CD  ARG   150     -26.370 -34.182   7.042  1.00 72.26           C  
ATOM   2443  NE  ARG   150     -25.942 -35.232   6.111  1.00 73.68           N  
ATOM   2447  C   ARG   150     -28.481 -35.431  10.690  1.00 66.74           C  
ATOM   2448  O   ARG   150     -29.646 -35.030  10.583  1.00 65.37           O  
ATOM   2449  N   CYS   151     -27.648 -34.988  11.617  1.00 67.67           N  
ATOM   2450  CA  CYS   151     -28.016 -33.908  12.512  1.00 64.82           C  
ATOM   2451  CB  CYS   151     -27.158 -33.980  13.774  1.00 65.20           C  
ATOM   2452  SG  CYS   151     -26.876 -32.371  14.535  1.00 71.95           S  
ATOM   2453  C   CYS   151     -27.840 -32.566  11.782  1.00 62.66           C  
ATOM   2454  O   CYS   151     -26.786 -32.310  11.183  1.00 63.69           O  
ATOM   2455  N   LEU   152     -28.863 -31.719  11.819  1.00 57.45           N  
ATOM   2456  CA  LEU   152     -28.754 -30.404  11.198  1.00 55.46           C  
ATOM   2457  CB  LEU   152     -29.965 -30.112  10.314  1.00 53.30           C  
ATOM   2458  CG  LEU   152     -30.230 -31.058   9.136  1.00 57.13           C  
ATOM   2459  CD1 LEU   152     -31.555 -30.734   8.480  1.00 54.70           C  
ATOM   2460  CD2 LEU   152     -29.124 -31.036   8.088  1.00 55.89           C  
ATOM   2461  C   LEU   152     -28.583 -29.329  12.283  1.00 54.42           C  
ATOM   2462  O   LEU   152     -29.484 -29.115  13.102  1.00 55.22           O  
ATOM   2463  N   ARG   153     -27.428 -28.663  12.295  1.00 52.31           N  
ATOM   2464  CA  ARG   153     -27.144 -27.612  13.278  1.00 51.68           C  
ATOM   2465  CB  ARG   153     -26.373 -28.172  14.477  1.00 52.51           C  
ATOM   2466  CG  ARG   153     -25.083 -28.892  14.125  1.00 50.80           C  
ATOM   2467  CD  ARG   153     -24.542 -29.622  15.333  1.00 53.69           C  
ATOM   2468  NE  ARG   153     -23.105 -29.850  15.200  1.00 63.01           N  
ATOM   2469  CZ  ARG   153     -22.323 -30.400  16.126  1.00 64.47           C  
ATOM   2470  NH1 ARG   153     -21.023 -30.546  15.886  1.00 68.07           N  
ATOM   2471  NH2 ARG   153     -22.829 -30.798  17.284  1.00 63.45           N  
ATOM   2472  C   ARG   153     -26.386 -26.451  12.648  1.00 52.21           C  
ATOM   2473  O   ARG   153     -25.879 -26.578  11.547  1.00 53.85           O  
ATOM   2474  N   LEU   154     -26.319 -25.315  13.336  1.00 51.57           N  
ATOM   2475  CA  LEU   154     -25.680 -24.130  12.766  1.00 52.35           C  
ATOM   2476  CB  LEU   154     -26.721 -23.231  12.090  1.00 52.38           C  
ATOM   2477  CG  LEU   154     -26.467 -22.286  10.901  1.00 52.33           C  
ATOM   2478  CD1 LEU   154     -27.189 -20.956  11.106  1.00 47.55           C  
ATOM   2479  CD2 LEU   154     -25.026 -22.063  10.579  1.00 48.79           C  
ATOM   2480  C   LEU   154     -25.072 -23.360  13.896  1.00 52.80           C  
ATOM   2481  O   LEU   154     -25.697 -23.188  14.942  1.00 53.27           O  
ATOM   2482  N   LYS   155     -23.857 -22.884  13.695  1.00 54.03           N  
ATOM   2483  CA  LYS   155     -23.210 -22.072  14.698  1.00 53.75           C  
ATOM   2484  CB  LYS   155     -21.808 -22.611  14.979  1.00 55.85           C  
ATOM   2485  CG  LYS   155     -20.962 -21.753  15.901  1.00 57.65           C  
ATOM   2486  CD  LYS   155     -19.797 -22.552  16.432  1.00 58.41           C  
ATOM   2487  CE  LYS   155     -19.025 -21.762  17.482  1.00 61.53           C  
ATOM   2488  NZ  LYS   155     -17.729 -22.434  17.833  1.00 61.73           N  
ATOM   2489  C   LYS   155     -23.165 -20.676  14.117  1.00 53.84           C  
ATOM   2490  O   LYS   155     -22.699 -20.499  12.988  1.00 55.18           O  
ATOM   2491  N   VAL   156     -23.674 -19.700  14.862  1.00 52.45           N  
ATOM   2492  CA  VAL   156     -23.556 -18.300  14.472  1.00 54.93           C  
ATOM   2493  CB  VAL   156     -24.930 -17.581  14.360  1.00 54.69           C  
ATOM   2494  CG1 VAL   156     -24.741 -16.232  13.689  1.00 56.14           C  
ATOM   2495  CG2 VAL   156     -25.951 -18.416  13.576  1.00 49.56           C  
ATOM   2496  C   VAL   156     -22.632 -17.561  15.461  1.00 58.78           C  
ATOM   2497  O   VAL   156     -22.924 -17.498  16.665  1.00 60.84           O  
ATOM   2498  N   THR   157     -21.513 -17.033  14.962  1.00 58.75           N  
ATOM   2499  CA  THR   157     -20.559 -16.320  15.798  1.00 60.81           C  
ATOM   2500  CB  THR   157     -19.108 -16.854  15.583  1.00 62.18           C  
ATOM   2501  OG1 THR   157     -19.027 -18.220  16.000  1.00 58.31           O  
ATOM   2502  CG2 THR   157     -18.095 -16.036  16.379  1.00 62.08           C  
ATOM   2503  C   THR   157     -20.625 -14.811  15.527  1.00 63.37           C  
ATOM   2504  O   THR   157     -20.504 -14.370  14.388  1.00 63.80           O  
ATOM   2505  N   VAL   158     -20.828 -14.022  16.576  1.00 66.77           N  
ATOM   2506  CA  VAL   158     -20.822 -12.551  16.450  1.00 70.21           C  
ATOM   2507  CB  VAL   158     -21.831 -11.874  17.422  1.00 69.55           C  
ATOM   2508  CG1 VAL   158     -21.914 -10.371  17.168  1.00 69.21           C  
ATOM   2509  CG2 VAL   158     -23.219 -12.517  17.312  1.00 67.10           C  
ATOM   2510  C   VAL   158     -19.409 -11.981  16.672  1.00 73.89           C  
ATOM   2511  O   VAL   158     -18.845 -12.102  17.757  1.00 75.32           O  
ATOM   2512  N   SER   159     -18.835 -11.372  15.644  1.00 77.42           N  
ATOM   2513  CA  SER   159     -17.496 -10.820  15.775  1.00 83.01           C  
ATOM   2514  CB  SER   159     -16.788 -10.776  14.420  1.00 85.68           C  
ATOM   2515  OG  SER   159     -17.666 -10.308  13.413  1.00 90.57           O  
ATOM   2516  C   SER   159     -17.541  -9.437  16.394  1.00 84.74           C  
ATOM   2517  O   SER   159     -18.626  -8.866  16.577  1.00 83.29           O  
ATOM   2518  N   GLY   160     -16.354  -8.920  16.723  1.00 87.89           N  
ATOM   2519  CA  GLY   160     -16.183  -7.557  17.229  1.00 90.83           C  
ATOM   2520  C   GLY   160     -15.287  -7.479  18.454  1.00 93.62           C  
ATOM   2521  O   GLY   160     -15.753  -7.589  19.593  1.00 92.80           O  
END
