
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  106 (  790),  selected  106 , name 2gim_A
# Molecule2: number of CA atoms  130 ( 1084),  selected  130 , name T0390.pdb
# PARAMETERS: 2gim_A.T0390.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     0_A      A      29           #
LGA    E     1_A      D      30          1.538
LGA    T     2_A      R      31          1.215
LGA    Y     3_A      H      32          1.028
LGA    T     4_A      T      33          0.916
LGA    V     5_A      V      34          0.645
LGA    K     6_A      F      35          0.586
LGA    L     7_A      W      36          1.630
LGA    G     8_A      N      37          1.341
LGA    -       -      S      38           -
LGA    -       -      S      39           -
LGA    S     9_A      N      40          2.324
LGA    D    10_A      P      41           #
LGA    K    11_A      K      42           -
LGA    G    12_A      -       -           -
LGA    L    13_A      -       -           -
LGA    L    14_A      -       -           -
LGA    V    15_A      F      43          4.141
LGA    F    16_A      R      44           -
LGA    E    17_A      N      45           -
LGA    P    18_A      E      46           -
LGA    A    19_A      D      47           #
LGA    K    20_A      Y      48          3.243
LGA    -       -      T      49           -
LGA    L    21_A      I      50          0.816
LGA    T    22_A      H      51          0.752
LGA    I    23_A      V      52          0.703
LGA    K    24_A      Q      53          1.440
LGA    P    25_A      L      54          1.995
LGA    G    26_A      N      55          1.430
LGA    D    27_A      D      56          1.413
LGA    T    28_A      Y      57          1.088
LGA    V    29_A      V      58          0.948
LGA    E    30_A      D      59          0.918
LGA    F    31_A      I      60          1.304
LGA    L    32_A      I      61          1.177
LGA    N    33_A      C      62          1.890
LGA    N    34_A      P      63          3.083
LGA    K    35_A      H      64          5.747
LGA    -       -      Y      65           -
LGA    -       -      E      66           -
LGA    -       -      S      69           -
LGA    -       -      V      70           -
LGA    -       -      A      71           -
LGA    -       -      D      72           -
LGA    -       -      A      73           -
LGA    -       -      A      74           -
LGA    V    36_A      M      75          4.665
LGA    P    37_A      E      76          0.757
LGA    P    38_A      Q      77          0.736
LGA    H    39_A      Y      78          2.128
LGA    N    40_A      I      79          2.902
LGA    V    41_A      L      80          1.700
LGA    V    42_A      Y      81          0.862
LGA    F    43_A      L      82          1.219
LGA    D    44_A      V      83          1.325
LGA    A    45_A      -       -           -
LGA    A    46_A      E      84          2.549
LGA    L    47_A      H      85          1.890
LGA    N    48_A      E      86           -
LGA    P    49_A      E      87           -
LGA    A    50_A      Y      88           -
LGA    K    51_A      Q      89           -
LGA    S    52_A      L      90           -
LGA    -       -      C      91           -
LGA    -       -      Q      92           -
LGA    -       -      P      93           -
LGA    -       -      Q      94           -
LGA    -       -      S      95           -
LGA    -       -      K      96           -
LGA    A    53_A      D      97           #
LGA    D    54_A      -       -           -
LGA    L    55_A      -       -           -
LGA    A    56_A      Q      98          5.408
LGA    K    57_A      V      99          5.505
LGA    S    58_A      -       -           -
LGA    L    59_A      -       -           -
LGA    S    60_A      R     100          1.856
LGA    H    61_A      W     101          1.179
LGA    K    62_A      Q     102          4.276
LGA    Q    63_A      -       -           -
LGA    L    64_A      C     103          3.011
LGA    L    65_A      N     104          2.966
LGA    M    66_A      R     105          1.383
LGA    S    67_A      P     106          3.213
LGA    P    68_A      S     107          2.915
LGA    G    69_A      A     108          6.645
LGA    -       -      K     109           -
LGA    -       -      H     110           -
LGA    -       -      G     111           -
LGA    Q    70_A      P     112          2.282
LGA    S    71_A      E     113          2.785
LGA    -       -      K     114           -
LGA    T    72_A      L     115          2.214
LGA    S    73_A      S     116          1.233
LGA    T    74_A      E     117          1.221
LGA    T    75_A      K     118          1.415
LGA    F    76_A      F     119          1.839
LGA    P    77_A      Q     120          1.843
LGA    A    78_A      R     121          2.490
LGA    -       -      F     122           -
LGA    -       -      T     123           -
LGA    -       -      P     124           -
LGA    -       -      F     125           -
LGA    -       -      T     126           -
LGA    -       -      L     127           -
LGA    -       -      G     128           -
LGA    -       -      K     129           -
LGA    D    79_A      E     130          5.283
LGA    A    80_A      F     131          1.025
LGA    P    81_A      K     132          1.802
LGA    A    82_A      E     133          3.339
LGA    -       -      G     134           -
LGA    G    83_A      H     135          1.924
LGA    E    84_A      S     136          1.798
LGA    Y    85_A      Y     137          1.361
LGA    T    86_A      Y     138          1.726
LGA    F    87_A      Y     139          1.132
LGA    Y    88_A      I     140          1.138
LGA    C    89_A      S     141          1.346
LGA    E    90_A      K     142          1.093
LGA    P    91_A      P     143          1.411
LGA    -       -      I     144           -
LGA    -       -      H     145           -
LGA    -       -      Q     146           -
LGA    H    92_A      H     147           #
LGA    R    93_A      E     148          5.649
LGA    G    94_A      D     149          5.833
LGA    A    95_A      R     150          1.947
LGA    G    96_A      C     151          1.916
LGA    M    97_A      L     152          1.211
LGA    V    98_A      R     153          1.461
LGA    G    99_A      L     154          1.453
LGA    K   100_A      K     155          1.219
LGA    I   101_A      V     156          1.013
LGA    T   102_A      T     157          1.055
LGA    V   103_A      V     158          1.451
LGA    A   104_A      S     159          1.500
LGA    G   105_A      G     160          2.099

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  106  130    5.0     83    2.49    14.46     44.356     3.200

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.660609 * X  +  -0.710011 * Y  +   0.243886 * Z  + -26.146576
  Y_new =  -0.743841 * X  +   0.662955 * Y  +  -0.084805 * Z  + -19.882601
  Z_new =  -0.101473 * X  +  -0.237435 * Y  +  -0.966089 * Z  +  -0.753348 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.900600    0.240993  [ DEG:  -166.1921     13.8079 ]
  Theta =   0.101648    3.039945  [ DEG:     5.8240    174.1760 ]
  Phi   =  -2.297001    0.844592  [ DEG:  -131.6084     48.3916 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gim_A                                        
REMARK     2: T0390.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gim_A.T0390.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  106  130   5.0   83   2.49   14.46  44.356
REMARK  ---------------------------------------------------------- 
MOLECULE 2gim_A
HEADER    ELECTRON TRANSPORT                      29-MAR-06   2GIM              
TITLE     1.6 ANGSTROM STRUCTURE OF PLASTOCYANIN FROM ANABAENA                  
TITLE    2 VARIABILIS                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PLASTOCYANIN;                                              
COMPND   3 CHAIN: A, C;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ANABAENA VARIABILIS;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PETE;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21G-(DE3);                               
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_VECTOR: PET3A                                      
KEYWDS    BETA SHEET, CU, HELIX                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    L.SCHMIDT,P.HARRIS,H.E.M.CHRISTENSEN                                  
REVDAT   2   05-SEP-06 2GIM    1       JRNL                                     
REVDAT   1   11-APR-06 2GIM    0                                                
JRNL        AUTH   L.SCHMIDT,H.E.CHRISTENSEN,P.HARRIS                           
JRNL        TITL   STRUCTURE OF PLASTOCYANIN FROM THE CYANOBACTERIUM            
JRNL        TITL 2 ANABAENA VARIABILIS.                                         
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  62  1022 2006              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2GIM A    1   105  UNP    P0C178   PLAS_ANAVA       1    105             
DBREF  2GIM C    1   105  UNP    P0C178   PLAS_ANAVA       1    105             
SEQRES   1 A  106  MET GLU THR TYR THR VAL LYS LEU GLY SER ASP LYS GLY          
SEQRES   2 A  106  LEU LEU VAL PHE GLU PRO ALA LYS LEU THR ILE LYS PRO          
SEQRES   3 A  106  GLY ASP THR VAL GLU PHE LEU ASN ASN LYS VAL PRO PRO          
SEQRES   4 A  106  HIS ASN VAL VAL PHE ASP ALA ALA LEU ASN PRO ALA LYS          
SEQRES   5 A  106  SER ALA ASP LEU ALA LYS SER LEU SER HIS LYS GLN LEU          
SEQRES   6 A  106  LEU MET SER PRO GLY GLN SER THR SER THR THR PHE PRO          
SEQRES   7 A  106  ALA ASP ALA PRO ALA GLY GLU TYR THR PHE TYR CYS GLU          
SEQRES   8 A  106  PRO HIS ARG GLY ALA GLY MET VAL GLY LYS ILE THR VAL          
SEQRES   9 A  106  ALA GLY                                                      
SEQRES   1 C  106  MET GLU THR TYR THR VAL LYS LEU GLY SER ASP LYS GLY          
SEQRES   2 C  106  LEU LEU VAL PHE GLU PRO ALA LYS LEU THR ILE LYS PRO          
SEQRES   3 C  106  GLY ASP THR VAL GLU PHE LEU ASN ASN LYS VAL PRO PRO          
SEQRES   4 C  106  HIS ASN VAL VAL PHE ASP ALA ALA LEU ASN PRO ALA LYS          
SEQRES   5 C  106  SER ALA ASP LEU ALA LYS SER LEU SER HIS LYS GLN LEU          
SEQRES   6 C  106  LEU MET SER PRO GLY GLN SER THR SER THR THR PHE PRO          
SEQRES   7 C  106  ALA ASP ALA PRO ALA GLY GLU TYR THR PHE TYR CYS GLU          
SEQRES   8 C  106  PRO HIS ARG GLY ALA GLY MET VAL GLY LYS ILE THR VAL          
SEQRES   9 C  106  ALA GLY                                                      
HET     CU  A 106       1                                                       
HET     CU  C 107       1                                                       
HETNAM      CU COPPER (II) ION                                                  
FORMUL   3   CU    2(CU 2+)                                                     
FORMUL   5  HOH   *315(H2 O)                                                    
CRYST1   67.850   45.810   63.410  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   MET A   0     -26.254  -3.254   8.896  1.00 32.17           N  
ATOM      2  CA  MET A   0     -27.032  -4.479   9.250  1.00 32.46           C  
ATOM      3  C   MET A   0     -27.229  -5.301   7.997  1.00 30.90           C  
ATOM      4  O   MET A   0     -27.499  -4.769   6.912  1.00 31.56           O  
ATOM      5  CB  MET A   0     -28.375  -4.115   9.879  1.00 34.49           C  
ATOM      6  CG  MET A   0     -28.579  -2.628   9.915  1.00 35.99           C  
ATOM      7  SD  MET A   0     -28.496  -1.955  11.597  1.00 40.28           S  
ATOM      8  CE  MET A   0     -27.871  -3.335  12.575  1.00 38.41           C  
ATOM      9  N   GLU A   1     -27.077  -6.604   8.138  1.00 25.58           N  
ATOM     10  CA  GLU A   1     -27.059  -7.455   6.974  1.00 22.39           C  
ATOM     11  C   GLU A   1     -28.049  -8.570   7.152  1.00 19.50           C  
ATOM     12  O   GLU A   1     -28.354  -8.942   8.287  1.00 18.74           O  
ATOM     13  CB  GLU A   1     -25.683  -8.077   6.831  1.00 24.29           C  
ATOM     14  CG  GLU A   1     -24.551  -7.041   6.674  1.00 26.73           C  
ATOM     15  CD  GLU A   1     -24.545  -6.378   5.298  1.00 30.22           C  
ATOM     16  OE1 GLU A   1     -24.747  -7.091   4.299  1.00 31.26           O  
ATOM     17  OE2 GLU A   1     -24.338  -5.146   5.209  1.00 30.74           O  
ATOM     18  N   THR A   2     -28.531  -9.100   6.029  1.00 16.31           N  
ATOM     19  CA  THR A   2     -29.363 -10.294   6.023  1.00 17.47           C  
ATOM     20  C   THR A   2     -28.620 -11.448   5.362  1.00 15.77           C  
ATOM     21  O   THR A   2     -28.061 -11.348   4.233  1.00 16.87           O  
ATOM     22  CB  THR A   2     -30.756 -10.036   5.398  1.00 16.92           C  
ATOM     23  OG1 THR A   2     -31.456  -9.151   6.273  1.00 18.40           O  
ATOM     24  CG2 THR A   2     -31.583 -11.328   5.272  1.00 17.81           C  
ATOM     25  N   TYR A   3     -28.558 -12.542   6.103  1.00 15.37           N  
ATOM     26  CA  TYR A   3     -27.989 -13.768   5.573  1.00 15.68           C  
ATOM     27  C   TYR A   3     -29.026 -14.860   5.485  1.00 16.69           C  
ATOM     28  O   TYR A   3     -29.787 -15.097   6.416  1.00 18.82           O  
ATOM     29  CB  TYR A   3     -26.886 -14.290   6.466  1.00 19.24           C  
ATOM     30  CG  TYR A   3     -25.783 -13.297   6.702  1.00 20.30           C  
ATOM     31  CD1 TYR A   3     -25.774 -12.495   7.845  1.00 19.62           C  
ATOM     32  CD2 TYR A   3     -24.764 -13.150   5.783  1.00 22.72           C  
ATOM     33  CE1 TYR A   3     -24.752 -11.582   8.080  1.00 20.99           C  
ATOM     34  CE2 TYR A   3     -23.727 -12.223   6.010  1.00 22.82           C  
ATOM     35  CZ  TYR A   3     -23.729 -11.461   7.171  1.00 21.64           C  
ATOM     36  OH  TYR A   3     -22.696 -10.555   7.433  1.00 22.78           O  
ATOM     37  N   THR A   4     -28.953 -15.602   4.402  1.00 15.85           N  
ATOM     38  CA  THR A   4     -29.934 -16.609   4.117  1.00 16.14           C  
ATOM     39  C   THR A   4     -29.337 -17.991   4.295  1.00 16.29           C  
ATOM     40  O   THR A   4     -28.198 -18.284   3.894  1.00 14.17           O  
ATOM     41  CB  THR A   4     -30.500 -16.459   2.711  1.00 18.80           C  
ATOM     42  OG1 THR A   4     -31.059 -15.142   2.576  1.00 19.15           O  
ATOM     43  CG2 THR A   4     -31.585 -17.494   2.421  1.00 19.38           C  
ATOM     44  N   VAL A   5     -30.126 -18.805   4.974  1.00 13.72           N  
ATOM     45  CA  VAL A   5     -29.761 -20.185   5.237  1.00 13.81           C  
ATOM     46  C   VAL A   5     -30.883 -21.008   4.663  1.00 14.45           C  
ATOM     47  O   VAL A   5     -32.037 -20.846   5.044  1.00 15.01           O  
ATOM     48  CB  VAL A   5     -29.701 -20.459   6.741  1.00 14.05           C  
ATOM     49  CG1 VAL A   5     -29.588 -21.973   6.975  1.00 12.87           C  
ATOM     50  CG2 VAL A   5     -28.526 -19.762   7.338  1.00 12.50           C  
ATOM     51  N   LYS A   6     -30.559 -21.854   3.698  1.00 11.81           N  
ATOM     52  CA  LYS A   6     -31.529 -22.759   3.120  1.00 13.26           C  
ATOM     53  C   LYS A   6     -31.776 -23.934   4.062  1.00 13.72           C  
ATOM     54  O   LYS A   6     -30.851 -24.510   4.602  1.00 11.54           O  
ATOM     55  CB  LYS A   6     -31.066 -23.227   1.730  1.00 14.36           C  
ATOM     56  CG  LYS A   6     -31.134 -22.114   0.708  1.00 18.85           C  
ATOM     57  CD  LYS A   6     -30.207 -22.396  -0.471  1.00 21.14           C  
ATOM     58  CE  LYS A   6     -30.266 -21.308  -1.514  1.00 23.12           C  
ATOM     59  NZ  LYS A   6     -29.150 -21.504  -2.499  1.00 24.85           N  
ATOM     60  N   LEU A   7     -33.034 -24.300   4.198  1.00 14.37           N  
ATOM     61  CA  LEU A   7     -33.409 -25.462   4.943  1.00 15.07           C  
ATOM     62  C   LEU A   7     -33.597 -26.617   3.970  1.00 13.86           C  
ATOM     63  O   LEU A   7     -34.587 -26.678   3.201  1.00 12.41           O  
ATOM     64  CB  LEU A   7     -34.714 -25.222   5.703  1.00 13.05           C  
ATOM     65  CG  LEU A   7     -34.782 -23.968   6.574  1.00 16.01           C  
ATOM     66  CD1 LEU A   7     -36.204 -23.644   7.109  1.00 13.89           C  
ATOM     67  CD2 LEU A   7     -33.826 -24.072   7.759  1.00 16.08           C  
ATOM     68  N   GLY A   8     -32.613 -27.511   3.992  1.00 13.18           N  
ATOM     69  CA  GLY A   8     -32.438 -28.476   2.923  1.00 14.43           C  
ATOM     70  C   GLY A   8     -31.547 -27.830   1.881  1.00 17.98           C  
ATOM     71  O   GLY A   8     -31.849 -26.731   1.386  1.00 17.37           O  
ATOM     72  N   SER A   9     -30.447 -28.487   1.532  1.00 17.99           N  
ATOM     73  CA  SER A   9     -29.561 -27.922   0.517  1.00 16.17           C  
ATOM     74  C   SER A   9     -30.150 -28.029  -0.899  1.00 16.70           C  
ATOM     75  O   SER A   9     -31.004 -28.861  -1.156  1.00 14.51           O  
ATOM     76  CB  SER A   9     -28.222 -28.647   0.539  1.00 18.59           C  
ATOM     77  OG  SER A   9     -28.399 -29.992   0.121  1.00 16.85           O  
ATOM     78  N   ASP A  10     -29.619 -27.242  -1.838  1.00 16.30           N  
ATOM     79  CA  ASP A  10     -30.100 -27.371  -3.226  1.00 18.22           C  
ATOM     80  C   ASP A  10     -29.997 -28.806  -3.790  1.00 18.35           C  
ATOM     81  O   ASP A  10     -30.780 -29.219  -4.660  1.00 20.28           O  
ATOM     82  CB  ASP A  10     -29.376 -26.372  -4.116  1.00 17.95           C  
ATOM     83  CG  ASP A  10     -29.746 -24.911  -3.793  1.00 18.57           C  
ATOM     84  OD1 ASP A  10     -30.912 -24.668  -3.428  1.00 18.41           O  
ATOM     85  OD2 ASP A  10     -28.892 -24.022  -4.016  1.00 21.30           O  
ATOM     86  N   LYS A  11     -29.010 -29.549  -3.315  1.00 17.74           N  
ATOM     87  CA  LYS A  11     -28.804 -30.947  -3.711  1.00 19.21           C  
ATOM     88  C   LYS A  11     -29.694 -31.966  -2.954  1.00 19.22           C  
ATOM     89  O   LYS A  11     -29.584 -33.180  -3.118  1.00 20.18           O  
ATOM     90  CB  LYS A  11     -27.317 -31.310  -3.554  1.00 19.95           C  
ATOM     91  CG  LYS A  11     -26.360 -30.632  -4.580  1.00 19.57           C  
ATOM     92  CD  LYS A  11     -26.630 -31.019  -6.080  1.00 21.44           C  
ATOM     93  CE  LYS A  11     -26.351 -32.487  -6.384  1.00 21.84           C  
ATOM     94  NZ  LYS A  11     -26.793 -32.816  -7.798  1.00 19.40           N  
ATOM     95  N   GLY A  12     -30.579 -31.459  -2.093  1.00 17.79           N  
ATOM     96  CA  GLY A  12     -31.485 -32.309  -1.357  1.00 16.36           C  
ATOM     97  C   GLY A  12     -30.924 -33.004  -0.119  1.00 16.08           C  
ATOM     98  O   GLY A  12     -31.463 -34.048   0.303  1.00 17.36           O  
ATOM     99  N   LEU A  13     -29.873 -32.447   0.493  1.00 14.80           N  
ATOM    100  CA  LEU A  13     -29.321 -33.080   1.652  1.00 16.23           C  
ATOM    101  C   LEU A  13     -30.020 -32.473   2.834  1.00 15.43           C  
ATOM    102  O   LEU A  13     -30.434 -31.316   2.752  1.00 14.05           O  
ATOM    103  CB  LEU A  13     -27.837 -32.807   1.777  1.00 17.66           C  
ATOM    104  CG  LEU A  13     -27.022 -33.385   0.640  1.00 19.19           C  
ATOM    105  CD1 LEU A  13     -25.566 -33.350   1.120  1.00 20.03           C  
ATOM    106  CD2 LEU A  13     -27.533 -34.777   0.412  1.00 20.71           C  
ATOM    107  N   LEU A  14     -30.130 -33.245   3.918  1.00 15.43           N  
ATOM    108  CA  LEU A  14     -30.741 -32.771   5.141  1.00 12.80           C  
ATOM    109  C   LEU A  14     -29.734 -31.933   5.935  1.00 13.45           C  
ATOM    110  O   LEU A  14     -29.142 -32.374   6.932  1.00 11.56           O  
ATOM    111  CB  LEU A  14     -31.295 -33.912   5.982  1.00 14.30           C  
ATOM    112  CG  LEU A  14     -32.351 -34.793   5.294  1.00 14.95           C  
ATOM    113  CD1 LEU A  14     -32.653 -35.950   6.176  1.00 16.39           C  
ATOM    114  CD2 LEU A  14     -33.574 -33.951   5.073  1.00 16.73           C  
ATOM    115  N   VAL A  15     -29.512 -30.732   5.425  1.00 11.98           N  
ATOM    116  CA  VAL A  15     -28.574 -29.819   6.090  1.00 11.30           C  
ATOM    117  C   VAL A  15     -29.124 -28.426   5.951  1.00 11.53           C  
ATOM    118  O   VAL A  15     -30.044 -28.145   5.166  1.00 12.07           O  
ATOM    119  CB  VAL A  15     -27.174 -29.851   5.422  1.00 11.66           C  
ATOM    120  CG1 VAL A  15     -26.506 -31.213   5.699  1.00 13.16           C  
ATOM    121  CG2 VAL A  15     -27.192 -29.469   3.892  1.00 12.25           C  
ATOM    122  N   PHE A  16     -28.497 -27.558   6.702  1.00 12.47           N  
ATOM    123  CA  PHE A  16     -28.682 -26.142   6.506  1.00 11.32           C  
ATOM    124  C   PHE A  16     -27.638 -25.765   5.503  1.00 12.63           C  
ATOM    125  O   PHE A  16     -26.525 -26.277   5.569  1.00 14.22           O  
ATOM    126  CB  PHE A  16     -28.352 -25.447   7.813  1.00 10.16           C  
ATOM    127  CG  PHE A  16     -29.394 -25.659   8.913  1.00 12.24           C  
ATOM    128  CD1 PHE A  16     -30.642 -25.017   8.856  1.00 13.59           C  
ATOM    129  CD2 PHE A  16     -29.135 -26.553   9.966  1.00 12.32           C  
ATOM    130  CE1 PHE A  16     -31.617 -25.238   9.879  1.00 11.45           C  
ATOM    131  CE2 PHE A  16     -30.063 -26.755  10.983  1.00 12.34           C  
ATOM    132  CZ  PHE A  16     -31.330 -26.089  10.952  1.00 11.51           C  
ATOM    133  N   GLU A  17     -28.000 -24.906   4.550  1.00 13.00           N  
ATOM    134  CA  GLU A  17     -27.038 -24.435   3.544  1.00 13.16           C  
ATOM    135  C   GLU A  17     -26.981 -22.896   3.599  1.00 11.68           C  
ATOM    136  O   GLU A  17     -27.929 -22.249   3.171  1.00 14.57           O  
ATOM    137  CB  GLU A  17     -27.459 -24.879   2.134  1.00 13.88           C  
ATOM    138  CG  GLU A  17     -26.361 -24.611   1.120  1.00 19.05           C  
ATOM    139  CD  GLU A  17     -26.682 -25.142  -0.264  1.00 21.28           C  
ATOM    140  OE1 GLU A  17     -27.864 -25.434  -0.547  1.00 20.74           O  
ATOM    141  OE2 GLU A  17     -25.713 -25.285  -1.050  1.00 24.57           O  
ATOM    142  N   PRO A  18     -25.901 -22.303   4.129  1.00 13.99           N  
ATOM    143  CA  PRO A  18     -24.711 -22.924   4.718  1.00 13.61           C  
ATOM    144  C   PRO A  18     -25.002 -23.330   6.154  1.00 12.61           C  
ATOM    145  O   PRO A  18     -26.039 -22.969   6.713  1.00 14.26           O  
ATOM    146  CB  PRO A  18     -23.713 -21.793   4.738  1.00 13.99           C  
ATOM    147  CG  PRO A  18     -24.583 -20.570   4.935  1.00 14.29           C  
ATOM    148  CD  PRO A  18     -25.836 -20.821   4.211  1.00 13.99           C  
ATOM    149  N   ALA A  19     -24.131 -24.164   6.703  1.00 14.70           N  
ATOM    150  CA  ALA A  19     -24.333 -24.713   8.049  1.00 14.01           C  
ATOM    151  C   ALA A  19     -23.588 -23.939   9.129  1.00 15.55           C  
ATOM    152  O   ALA A  19     -23.749 -24.212  10.342  1.00 16.27           O  
ATOM    153  CB  ALA A  19     -23.973 -26.206   8.113  1.00 17.09           C  
ATOM    154  N   LYS A  20     -22.740 -23.022   8.705  1.00 15.47           N  
ATOM    155  CA  LYS A  20     -22.068 -22.132   9.622  1.00 16.38           C  
ATOM    156  C   LYS A  20     -22.031 -20.767   9.007  1.00 15.17           C  
ATOM    157  O   LYS A  20     -21.839 -20.618   7.797  1.00 16.57           O  
ATOM    158  CB  LYS A  20     -20.661 -22.635   9.929  1.00 20.30           C  
ATOM    159  CG  LYS A  20     -19.738 -22.625   8.781  1.00 23.94           C  
ATOM    160  CD  LYS A  20     -18.434 -23.408   9.080  1.00 26.39           C  
ATOM    161  CE  LYS A  20     -17.526 -23.381   7.825  1.00 28.57           C  
ATOM    162  NZ  LYS A  20     -16.102 -23.802   8.055  1.00 30.26           N  
ATOM    163  N   LEU A  21     -22.276 -19.763   9.827  1.00 14.71           N  
ATOM    164  CA  LEU A  21     -22.163 -18.402   9.356  1.00 14.27           C  
ATOM    165  C   LEU A  21     -21.718 -17.543  10.512  1.00 14.21           C  
ATOM    166  O   LEU A  21     -22.021 -17.872  11.658  1.00 14.32           O  
ATOM    167  CB  LEU A  21     -23.489 -17.899   8.798  1.00 15.83           C  
ATOM    168  CG  LEU A  21     -24.833 -18.129   9.468  1.00 18.12           C  
ATOM    169  CD1 LEU A  21     -25.806 -17.159   8.846  1.00 18.38           C  
ATOM    170  CD2 LEU A  21     -25.379 -19.595   9.389  1.00 20.48           C  
ATOM    171  N   THR A  22     -21.031 -16.437  10.197  1.00 12.68           N  
ATOM    172  CA  THR A  22     -20.607 -15.439  11.195  1.00 14.10           C  
ATOM    173  C   THR A  22     -21.284 -14.141  10.888  1.00 14.81           C  
ATOM    174  O   THR A  22     -21.334 -13.706   9.732  1.00 15.67           O  
ATOM    175  CB  THR A  22     -19.095 -15.230  11.178  1.00 14.70           C  
ATOM    176  OG1 THR A  22     -18.446 -16.432  11.597  1.00 15.14           O  
ATOM    177  CG2 THR A  22     -18.670 -14.092  12.098  1.00 15.20           C  
ATOM    178  N   ILE A  23     -21.878 -13.541  11.903  1.00 11.85           N  
ATOM    179  CA  ILE A  23     -22.680 -12.355  11.696  1.00 11.06           C  
ATOM    180  C   ILE A  23     -22.357 -11.352  12.818  1.00 13.96           C  
ATOM    181  O   ILE A  23     -21.604 -11.670  13.744  1.00 12.30           O  
ATOM    182  CB  ILE A  23     -24.144 -12.683  11.750  1.00 10.92           C  
ATOM    183  CG1 ILE A  23     -24.530 -13.090  13.176  1.00 11.12           C  
ATOM    184  CG2 ILE A  23     -24.517 -13.832  10.779  1.00 10.30           C  
ATOM    185  CD1 ILE A  23     -26.046 -13.320  13.485  1.00 12.08           C  
ATOM    186  N   LYS A  24     -22.968 -10.179  12.741  1.00 12.32           N  
ATOM    187  CA  LYS A  24     -22.861  -9.225  13.862  1.00 15.40           C  
ATOM    188  C   LYS A  24     -24.154  -9.184  14.617  1.00 15.46           C  
ATOM    189  O   LYS A  24     -25.210  -9.533  14.080  1.00 15.45           O  
ATOM    190  CB  LYS A  24     -22.552  -7.805  13.321  1.00 16.44           C  
ATOM    191  CG  LYS A  24     -21.209  -7.689  12.623  1.00 18.80           C  
ATOM    192  CD  LYS A  24     -21.092  -6.359  11.866  1.00 18.06           C  
ATOM    193  CE  LYS A  24     -19.831  -6.298  10.899  1.00 19.61           C  
ATOM    194  NZ  LYS A  24     -19.791  -5.024   9.988  1.00 20.48           N  
ATOM    195  N   PRO A  25     -24.095  -8.750  15.858  1.00 14.81           N  
ATOM    196  CA  PRO A  25     -25.365  -8.492  16.512  1.00 16.06           C  
ATOM    197  C   PRO A  25     -26.136  -7.495  15.685  1.00 15.39           C  
ATOM    198  O   PRO A  25     -25.532  -6.618  15.038  1.00 14.05           O  
ATOM    199  CB  PRO A  25     -24.979  -7.898  17.863  1.00 15.74           C  
ATOM    200  CG  PRO A  25     -23.538  -7.671  17.864  1.00 17.62           C  
ATOM    201  CD  PRO A  25     -22.927  -8.412  16.700  1.00 15.73           C  
ATOM    202  N   GLY A  26     -27.462  -7.629  15.703  1.00 16.02           N  
ATOM    203  CA  GLY A  26     -28.318  -6.784  14.861  1.00 15.21           C  
ATOM    204  C   GLY A  26     -28.517  -7.314  13.442  1.00 16.48           C  
ATOM    205  O   GLY A  26     -29.347  -6.811  12.642  1.00 19.05           O  
ATOM    206  N   ASP A  27     -27.767  -8.326  13.094  1.00 15.40           N  
ATOM    207  CA  ASP A  27     -27.926  -8.864  11.753  1.00 13.95           C  
ATOM    208  C   ASP A  27     -29.133  -9.814  11.740  1.00 12.85           C  
ATOM    209  O   ASP A  27     -29.548 -10.267  12.786  1.00 15.35           O  
ATOM    210  CB  ASP A  27     -26.684  -9.623  11.362  1.00 13.91           C  
ATOM    211  CG  ASP A  27     -25.576  -8.740  10.849  1.00 15.53           C  
ATOM    212  OD1 ASP A  27     -25.756  -7.513  10.635  1.00 16.21           O  
ATOM    213  OD2 ASP A  27     -24.499  -9.295  10.697  1.00 16.46           O  
ATOM    214  N   THR A  28     -29.593 -10.169  10.528  1.00 12.00           N  
ATOM    215  CA  THR A  28     -30.730 -11.083  10.376  1.00 11.90           C  
ATOM    216  C   THR A  28     -30.288 -12.323   9.622  1.00 12.43           C  
ATOM    217  O   THR A  28     -29.570 -12.211   8.640  1.00 13.05           O  
ATOM    218  CB  THR A  28     -31.904 -10.404   9.686  1.00 12.04           C  
ATOM    219  OG1 THR A  28     -32.352  -9.259  10.480  1.00 14.62           O  
ATOM    220  CG2 THR A  28     -33.061 -11.374   9.535  1.00 13.03           C  
ATOM    221  N   VAL A  29     -30.755 -13.476  10.102  1.00 14.25           N  
ATOM    222  CA  VAL A  29     -30.627 -14.754   9.437  1.00 13.13           C  
ATOM    223  C   VAL A  29     -32.028 -15.136   8.998  1.00 13.21           C  
ATOM    224  O   VAL A  29     -32.942 -15.233   9.804  1.00 11.65           O  
ATOM    225  CB  VAL A  29     -30.034 -15.827  10.376  1.00 14.90           C  
ATOM    226  CG1 VAL A  29     -29.735 -17.053   9.565  1.00 13.44           C  
ATOM    227  CG2 VAL A  29     -28.734 -15.285  11.022  1.00 11.71           C  
ATOM    228  N   GLU A  30     -32.177 -15.278   7.690  1.00 13.44           N  
ATOM    229  CA  GLU A  30     -33.417 -15.729   7.095  1.00 13.00           C  
ATOM    230  C   GLU A  30     -33.323 -17.215   6.860  1.00 14.05           C  
ATOM    231  O   GLU A  30     -32.375 -17.654   6.266  1.00 14.80           O  
ATOM    232  CB  GLU A  30     -33.581 -15.085   5.733  1.00 13.94           C  
ATOM    233  CG  GLU A  30     -34.817 -15.585   4.997  1.00 20.87           C  
ATOM    234  CD  GLU A  30     -34.772 -15.299   3.500  1.00 24.83           C  
ATOM    235  OE1 GLU A  30     -33.729 -14.854   2.974  1.00 26.73           O  
ATOM    236  OE2 GLU A  30     -35.800 -15.536   2.835  1.00 28.35           O  
ATOM    237  N   PHE A  31     -34.284 -17.990   7.359  1.00 12.49           N  
ATOM    238  CA  PHE A  31     -34.304 -19.418   7.138  1.00 12.73           C  
ATOM    239  C   PHE A  31     -35.368 -19.703   6.098  1.00 14.22           C  
ATOM    240  O   PHE A  31     -36.540 -19.353   6.288  1.00 16.96           O  
ATOM    241  CB  PHE A  31     -34.580 -20.154   8.436  1.00 14.68           C  
ATOM    242  CG  PHE A  31     -33.549 -19.921   9.463  1.00 14.07           C  
ATOM    243  CD1 PHE A  31     -33.691 -18.889  10.387  1.00 14.03           C  
ATOM    244  CD2 PHE A  31     -32.413 -20.729   9.506  1.00 16.43           C  
ATOM    245  CE1 PHE A  31     -32.719 -18.684  11.346  1.00 16.46           C  
ATOM    246  CE2 PHE A  31     -31.459 -20.539  10.483  1.00 14.17           C  
ATOM    247  CZ  PHE A  31     -31.582 -19.515  11.376  1.00 16.19           C  
ATOM    248  N   LEU A  32     -34.964 -20.348   5.004  1.00 13.58           N  
ATOM    249  CA  LEU A  32     -35.847 -20.487   3.854  1.00 14.27           C  
ATOM    250  C   LEU A  32     -36.108 -21.954   3.550  1.00 14.63           C  
ATOM    251  O   LEU A  32     -35.164 -22.712   3.377  1.00 12.95           O  
ATOM    252  CB  LEU A  32     -35.151 -19.850   2.659  1.00 17.37           C  
ATOM    253  CG  LEU A  32     -35.793 -19.459   1.352  1.00 18.95           C  
ATOM    254  CD1 LEU A  32     -37.116 -18.719   1.605  1.00 17.97           C  
ATOM    255  CD2 LEU A  32     -34.749 -18.570   0.592  1.00 16.22           C  
ATOM    256  N   ASN A  33     -37.377 -22.366   3.605  1.00 14.24           N  
ATOM    257  CA  ASN A  33     -37.732 -23.741   3.317  1.00 14.75           C  
ATOM    258  C   ASN A  33     -37.324 -24.025   1.869  1.00 16.05           C  
ATOM    259  O   ASN A  33     -37.715 -23.302   0.985  1.00 18.12           O  
ATOM    260  CB  ASN A  33     -39.225 -23.918   3.536  1.00 14.40           C  
ATOM    261  CG  ASN A  33     -39.655 -25.364   3.643  1.00 16.11           C  
ATOM    262  OD1 ASN A  33     -38.897 -26.244   4.081  1.00 17.90           O  
ATOM    263  ND2 ASN A  33     -40.891 -25.621   3.254  1.00 16.60           N  
ATOM    264  N   ASN A  34     -36.515 -25.073   1.633  1.00 17.18           N  
ATOM    265  CA  ASN A  34     -35.894 -25.291   0.336  1.00 19.80           C  
ATOM    266  C   ASN A  34     -36.187 -26.709  -0.157  1.00 21.23           C  
ATOM    267  O   ASN A  34     -37.079 -26.929  -0.983  1.00 22.10           O  
ATOM    268  CB  ASN A  34     -34.378 -25.060   0.455  1.00 19.57           C  
ATOM    269  CG  ASN A  34     -33.665 -25.018  -0.872  1.00 20.57           C  
ATOM    270  OD1 ASN A  34     -34.162 -24.465  -1.863  1.00 22.65           O  
ATOM    271  ND2 ASN A  34     -32.446 -25.494  -0.867  1.00 20.15           N  
ATOM    272  N   LYS A  35     -35.481 -27.692   0.368  1.00 20.94           N  
ATOM    273  CA  LYS A  35     -35.780 -29.050  -0.085  1.00 21.70           C  
ATOM    274  C   LYS A  35     -36.029 -29.999   1.073  1.00 20.90           C  
ATOM    275  O   LYS A  35     -35.609 -29.730   2.211  1.00 17.89           O  
ATOM    276  CB  LYS A  35     -34.651 -29.554  -0.989  1.00 24.26           C  
ATOM    277  CG  LYS A  35     -34.465 -28.749  -2.241  1.00 27.47           C  
ATOM    278  CD  LYS A  35     -35.145 -29.378  -3.429  1.00 30.33           C  
ATOM    279  CE  LYS A  35     -34.999 -28.515  -4.687  1.00 31.41           C  
ATOM    280  NZ  LYS A  35     -33.567 -28.471  -5.165  1.00 33.59           N  
ATOM    281  N   VAL A  36     -36.659 -31.137   0.771  1.00 19.90           N  
ATOM    282  CA  VAL A  36     -36.898 -32.241   1.711  1.00 21.35           C  
ATOM    283  C   VAL A  36     -37.499 -31.890   3.082  1.00 21.84           C  
ATOM    284  O   VAL A  36     -36.857 -32.027   4.096  1.00 21.65           O  
ATOM    285  CB  VAL A  36     -35.656 -33.153   1.857  1.00 23.26           C  
ATOM    286  CG1 VAL A  36     -34.398 -32.339   2.230  1.00 24.77           C  
ATOM    287  CG2 VAL A  36     -35.938 -34.305   2.853  1.00 24.39           C  
ATOM    288  N   PRO A  37     -38.782 -31.505   3.111  1.00 23.32           N  
ATOM    289  CA  PRO A  37     -39.449 -31.146   4.361  1.00 22.38           C  
ATOM    290  C   PRO A  37     -39.614 -32.353   5.330  1.00 21.83           C  
ATOM    291  O   PRO A  37     -39.452 -33.523   4.945  1.00 21.49           O  
ATOM    292  CB  PRO A  37     -40.796 -30.630   3.890  1.00 22.17           C  
ATOM    293  CG  PRO A  37     -41.054 -31.401   2.633  1.00 23.74           C  
ATOM    294  CD  PRO A  37     -39.704 -31.456   1.963  1.00 22.36           C  
ATOM    295  N   PRO A  38     -39.956 -32.085   6.581  1.00 21.91           N  
ATOM    296  CA  PRO A  38     -40.289 -30.763   7.080  1.00 22.00           C  
ATOM    297  C   PRO A  38     -39.126 -30.255   7.935  1.00 19.95           C  
ATOM    298  O   PRO A  38     -38.427 -31.071   8.582  1.00 22.23           O  
ATOM    299  CB  PRO A  38     -41.499 -31.066   7.973  1.00 21.59           C  
ATOM    300  CG  PRO A  38     -41.196 -32.559   8.540  1.00 21.82           C  
ATOM    301  CD  PRO A  38     -40.087 -33.125   7.625  1.00 20.69           C  
ATOM    302  N   HIS A  39     -38.946 -28.935   8.004  1.00 14.36           N  
ATOM    303  CA  HIS A  39     -37.877 -28.430   8.842  1.00 14.58           C  
ATOM    304  C   HIS A  39     -38.391 -27.408   9.843  1.00 13.20           C  
ATOM    305  O   HIS A  39     -39.301 -26.646   9.571  1.00 16.75           O  
ATOM    306  CB  HIS A  39     -36.852 -27.675   8.008  1.00 13.96           C  
ATOM    307  CG  HIS A  39     -36.360 -28.442   6.834  1.00 13.59           C  
ATOM    308  ND1 HIS A  39     -35.637 -29.605   6.957  1.00 15.67           N  
ATOM    309  CD2 HIS A  39     -36.482 -28.210   5.514  1.00 14.14           C  
ATOM    310  CE1 HIS A  39     -35.348 -30.071   5.753  1.00 15.31           C  
ATOM    311  NE2 HIS A  39     -35.846 -29.241   4.859  1.00 14.91           N  
ATOM    312  N   ASN A  40     -37.702 -27.325  10.949  1.00 12.87           N  
ATOM    313  CA  ASN A  40     -37.818 -26.118  11.797  1.00 12.58           C  
ATOM    314  C   ASN A  40     -36.421 -25.651  12.216  1.00 12.79           C  
ATOM    315  O   ASN A  40     -35.413 -26.131  11.670  1.00 13.54           O  
ATOM    316  CB  ASN A  40     -38.745 -26.312  12.991  1.00 12.48           C  
ATOM    317  CG  ASN A  40     -38.224 -27.349  14.035  1.00 13.76           C  
ATOM    318  OD1 ASN A  40     -37.136 -27.920  13.909  1.00 14.05           O  
ATOM    319  ND2 ASN A  40     -39.032 -27.580  15.092  1.00 14.68           N  
ATOM    320  N   VAL A  41     -36.364 -24.678  13.127  1.00 11.36           N  
ATOM    321  CA  VAL A  41     -35.073 -24.079  13.477  1.00 12.01           C  
ATOM    322  C   VAL A  41     -35.129 -23.832  14.950  1.00 12.21           C  
ATOM    323  O   VAL A  41     -35.640 -22.822  15.330  1.00 13.21           O  
ATOM    324  CB  VAL A  41     -34.898 -22.689  12.870  1.00 13.32           C  
ATOM    325  CG1 VAL A  41     -33.489 -22.117  13.213  1.00 14.81           C  
ATOM    326  CG2 VAL A  41     -35.120 -22.734  11.342  1.00 13.53           C  
ATOM    327  N   VAL A  42     -34.480 -24.679  15.727  1.00 11.88           N  
ATOM    328  CA  VAL A  42     -34.470 -24.589  17.194  1.00 11.15           C  
ATOM    329  C   VAL A  42     -33.057 -24.300  17.693  1.00 12.67           C  
ATOM    330  O   VAL A  42     -32.080 -25.041  17.404  1.00 13.05           O  
ATOM    331  CB  VAL A  42     -34.997 -25.862  17.836  1.00 11.56           C  
ATOM    332  CG1 VAL A  42     -34.973 -25.713  19.329  1.00 14.05           C  
ATOM    333  CG2 VAL A  42     -36.439 -26.062  17.332  1.00 13.24           C  
ATOM    334  N   PHE A  43     -32.918 -23.154  18.355  1.00 11.67           N  
ATOM    335  CA  PHE A  43     -31.641 -22.850  18.967  1.00 12.17           C  
ATOM    336  C   PHE A  43     -31.426 -23.645  20.263  1.00 12.71           C  
ATOM    337  O   PHE A  43     -32.340 -23.823  21.047  1.00 15.01           O  
ATOM    338  CB  PHE A  43     -31.512 -21.352  19.153  1.00 11.60           C  
ATOM    339  CG  PHE A  43     -31.110 -20.641  17.869  1.00 11.84           C  
ATOM    340  CD1 PHE A  43     -32.043 -20.361  16.905  1.00 10.99           C  
ATOM    341  CD2 PHE A  43     -29.801 -20.244  17.683  1.00 12.76           C  
ATOM    342  CE1 PHE A  43     -31.651 -19.674  15.756  1.00 11.45           C  
ATOM    343  CE2 PHE A  43     -29.421 -19.593  16.546  1.00 12.46           C  
ATOM    344  CZ  PHE A  43     -30.351 -19.324  15.575  1.00 13.86           C  
ATOM    345  N   ASP A  44     -30.208 -24.124  20.492  1.00 14.48           N  
ATOM    346  CA  ASP A  44     -29.964 -24.900  21.722  1.00 16.25           C  
ATOM    347  C   ASP A  44     -29.971 -24.025  22.953  1.00 17.71           C  
ATOM    348  O   ASP A  44     -29.357 -22.962  22.983  1.00 17.61           O  
ATOM    349  CB  ASP A  44     -28.617 -25.638  21.620  1.00 18.35           C  
ATOM    350  CG  ASP A  44     -28.452 -26.707  22.667  1.00 20.26           C  
ATOM    351  OD1 ASP A  44     -28.239 -26.371  23.873  1.00 20.72           O  
ATOM    352  OD2 ASP A  44     -28.533 -27.903  22.283  1.00 21.74           O  
ATOM    353  N   ALA A  45     -30.624 -24.493  24.010  1.00 18.99           N  
ATOM    354  CA  ALA A  45     -30.814 -23.658  25.204  1.00 20.12           C  
ATOM    355  C   ALA A  45     -29.564 -23.455  26.012  1.00 18.68           C  
ATOM    356  O   ALA A  45     -29.458 -22.544  26.833  1.00 22.35           O  
ATOM    357  CB  ALA A  45     -31.873 -24.251  26.095  1.00 21.94           C  
ATOM    358  N   ALA A  46     -28.616 -24.343  25.819  1.00 17.12           N  
ATOM    359  CA  ALA A  46     -27.444 -24.298  26.619  1.00 16.55           C  
ATOM    360  C   ALA A  46     -26.263 -23.820  25.757  1.00 18.05           C  
ATOM    361  O   ALA A  46     -25.374 -23.126  26.240  1.00 18.68           O  
ATOM    362  CB  ALA A  46     -27.208 -25.685  27.229  1.00 18.04           C  
ATOM    363  N   LEU A  47     -26.280 -24.171  24.466  1.00 15.50           N  
ATOM    364  CA  LEU A  47     -25.142 -23.872  23.617  1.00 15.63           C  
ATOM    365  C   LEU A  47     -25.289 -22.510  22.992  1.00 14.62           C  
ATOM    366  O   LEU A  47     -25.323 -22.380  21.790  1.00 14.65           O  
ATOM    367  CB  LEU A  47     -24.987 -24.936  22.527  1.00 15.64           C  
ATOM    368  CG  LEU A  47     -24.727 -26.371  23.012  1.00 18.30           C  
ATOM    369  CD1 LEU A  47     -24.754 -27.381  21.847  1.00 19.00           C  
ATOM    370  CD2 LEU A  47     -23.440 -26.437  23.864  1.00 20.88           C  
ATOM    371  N   ASN A  48     -25.473 -21.494  23.813  1.00 13.63           N  
ATOM    372  CA  ASN A  48     -25.323 -20.137  23.281  1.00 13.73           C  
ATOM    373  C   ASN A  48     -24.559 -19.441  24.354  1.00 13.34           C  
ATOM    374  O   ASN A  48     -24.438 -19.930  25.477  1.00 14.05           O  
ATOM    375  CB  ASN A  48     -26.670 -19.462  23.070  1.00 14.73           C  
ATOM    376  CG  ASN A  48     -27.518 -19.493  24.310  1.00 13.44           C  
ATOM    377  OD1 ASN A  48     -27.298 -18.718  25.253  1.00 15.42           O  
ATOM    378  ND2 ASN A  48     -28.510 -20.411  24.335  1.00 13.50           N  
ATOM    379  N   PRO A  49     -23.980 -18.291  24.009  1.00 14.39           N  
ATOM    380  CA  PRO A  49     -22.972 -17.751  24.914  1.00 13.14           C  
ATOM    381  C   PRO A  49     -23.451 -17.385  26.318  1.00 15.99           C  
ATOM    382  O   PRO A  49     -22.636 -17.459  27.258  1.00 19.40           O  
ATOM    383  CB  PRO A  49     -22.443 -16.516  24.160  1.00 14.41           C  
ATOM    384  CG  PRO A  49     -22.717 -16.814  22.750  1.00 14.84           C  
ATOM    385  CD  PRO A  49     -24.081 -17.468  22.799  1.00 14.51           C  
ATOM    386  N   ALA A  50     -24.721 -17.037  26.465  1.00 17.90           N  
ATOM    387  CA  ALA A  50     -25.282 -16.714  27.776  1.00 18.96           C  
ATOM    388  C   ALA A  50     -25.773 -17.989  28.453  1.00 19.61           C  
ATOM    389  O   ALA A  50     -26.195 -17.945  29.606  1.00 19.58           O  
ATOM    390  CB  ALA A  50     -26.445 -15.707  27.643  1.00 20.77           C  
ATOM    391  N   LYS A  51     -25.779 -19.109  27.730  1.00 14.39           N  
ATOM    392  CA  LYS A  51     -26.419 -20.338  28.233  1.00 16.40           C  
ATOM    393  C   LYS A  51     -27.862 -20.094  28.686  1.00 17.55           C  
ATOM    394  O   LYS A  51     -28.334 -20.668  29.668  1.00 18.08           O  
ATOM    395  CB  LYS A  51     -25.564 -20.941  29.349  1.00 18.27           C  
ATOM    396  CG  LYS A  51     -24.230 -21.322  28.846  1.00 20.53           C  
ATOM    397  CD  LYS A  51     -23.458 -22.111  29.864  1.00 19.72           C  
ATOM    398  CE  LYS A  51     -22.103 -22.561  29.231  1.00 23.28           C  
ATOM    399  NZ  LYS A  51     -22.384 -23.353  27.993  1.00 27.14           N  
ATOM    400  N   SER A  52     -28.546 -19.234  27.944  1.00 16.37           N  
ATOM    401  CA  SER A  52     -29.858 -18.744  28.269  1.00 18.48           C  
ATOM    402  C   SER A  52     -30.909 -19.451  27.444  1.00 17.26           C  
ATOM    403  O   SER A  52     -30.990 -19.246  26.244  1.00 16.61           O  
ATOM    404  CB  SER A  52     -29.973 -17.263  27.963  1.00 17.34           C  
ATOM    405  OG  SER A  52     -31.329 -16.798  28.101  1.00 19.75           O  
ATOM    406  N   ALA A  53     -31.804 -20.167  28.098  1.00 17.95           N  
ATOM    407  CA  ALA A  53     -32.917 -20.755  27.377  1.00 16.88           C  
ATOM    408  C   ALA A  53     -33.860 -19.710  26.749  1.00 18.58           C  
ATOM    409  O   ALA A  53     -34.470 -19.946  25.683  1.00 18.86           O  
ATOM    410  CB  ALA A  53     -33.697 -21.715  28.308  1.00 17.08           C  
ATOM    411  N   ASP A  54     -33.959 -18.545  27.372  1.00 19.28           N  
ATOM    412  CA  ASP A  54     -34.844 -17.494  26.861  1.00 18.96           C  
ATOM    413  C   ASP A  54     -34.263 -16.855  25.605  1.00 19.41           C  
ATOM    414  O   ASP A  54     -34.980 -16.535  24.668  1.00 18.81           O  
ATOM    415  CB  ASP A  54     -35.020 -16.421  27.895  1.00 22.84           C  
ATOM    416  CG  ASP A  54     -35.888 -16.864  29.028  1.00 25.28           C  
ATOM    417  OD1 ASP A  54     -35.805 -16.229  30.090  1.00 26.93           O  
ATOM    418  OD2 ASP A  54     -36.644 -17.853  28.851  1.00 27.60           O  
ATOM    419  N   LEU A  55     -32.957 -16.653  25.602  1.00 15.57           N  
ATOM    420  CA  LEU A  55     -32.320 -16.160  24.378  1.00 15.54           C  
ATOM    421  C   LEU A  55     -32.575 -17.169  23.285  1.00 16.27           C  
ATOM    422  O   LEU A  55     -33.050 -16.792  22.214  1.00 15.28           O  
ATOM    423  CB  LEU A  55     -30.827 -15.897  24.596  1.00 15.81           C  
ATOM    424  CG  LEU A  55     -29.958 -15.447  23.391  1.00 17.46           C  
ATOM    425  CD1 LEU A  55     -30.611 -14.254  22.756  1.00 16.66           C  
ATOM    426  CD2 LEU A  55     -28.514 -15.128  23.796  1.00 17.32           C  
ATOM    427  N   ALA A  56     -32.274 -18.436  23.528  1.00 13.06           N  
ATOM    428  CA  ALA A  56     -32.490 -19.459  22.512  1.00 12.22           C  
ATOM    429  C   ALA A  56     -33.962 -19.492  22.035  1.00 12.06           C  
ATOM    430  O   ALA A  56     -34.207 -19.542  20.846  1.00 14.65           O  
ATOM    431  CB  ALA A  56     -32.023 -20.856  22.978  1.00 12.53           C  
ATOM    432  N   LYS A  57     -34.933 -19.489  22.953  1.00 14.23           N  
ATOM    433  CA  LYS A  57     -36.340 -19.446  22.534  1.00 16.32           C  
ATOM    434  C   LYS A  57     -36.605 -18.231  21.631  1.00 17.23           C  
ATOM    435  O   LYS A  57     -37.271 -18.321  20.561  1.00 16.25           O  
ATOM    436  CB  LYS A  57     -37.279 -19.405  23.749  1.00 19.97           C  
ATOM    437  CG  LYS A  57     -37.437 -20.754  24.431  1.00 22.70           C  
ATOM    438  CD  LYS A  57     -38.401 -20.694  25.640  1.00 23.63           C  
ATOM    439  CE  LYS A  57     -38.112 -21.906  26.528  1.00 26.75           C  
ATOM    440  NZ  LYS A  57     -36.627 -21.861  26.784  1.00 28.55           N  
ATOM    441  N   SER A  58     -36.086 -17.076  22.056  1.00 15.22           N  
ATOM    442  CA  SER A  58     -36.362 -15.859  21.287  1.00 16.32           C  
ATOM    443  C   SER A  58     -35.840 -15.915  19.823  1.00 17.16           C  
ATOM    444  O   SER A  58     -36.384 -15.207  18.957  1.00 19.77           O  
ATOM    445  CB  SER A  58     -35.800 -14.634  21.991  1.00 16.97           C  
ATOM    446  OG  SER A  58     -34.424 -14.509  21.739  1.00 15.75           O  
ATOM    447  N   LEU A  59     -34.819 -16.732  19.543  1.00 14.36           N  
ATOM    448  CA  LEU A  59     -34.210 -16.799  18.176  1.00 12.46           C  
ATOM    449  C   LEU A  59     -34.779 -17.942  17.326  1.00 13.72           C  
ATOM    450  O   LEU A  59     -34.505 -18.034  16.157  1.00 14.66           O  
ATOM    451  CB  LEU A  59     -32.690 -17.032  18.249  1.00 11.03           C  
ATOM    452  CG  LEU A  59     -31.885 -16.029  19.080  1.00 11.13           C  
ATOM    453  CD1 LEU A  59     -30.631 -16.688  19.551  1.00 11.96           C  
ATOM    454  CD2 LEU A  59     -31.620 -14.695  18.354  1.00 14.43           C  
ATOM    455  N   SER A  60     -35.557 -18.818  17.953  1.00 14.48           N  
ATOM    456  CA  SER A  60     -36.000 -20.055  17.335  1.00 12.78           C  
ATOM    457  C   SER A  60     -37.335 -19.922  16.625  1.00 14.19           C  
ATOM    458  O   SER A  60     -38.089 -18.962  16.867  1.00 13.59           O  
ATOM    459  CB  SER A  60     -36.192 -21.067  18.444  1.00 11.84           C  
ATOM    460  OG  SER A  60     -34.956 -21.423  18.964  1.00 10.87           O  
ATOM    461  N   HIS A  61     -37.579 -20.855  15.682  0.55 13.27           N  
ATOM    463  CA  HIS A  61     -38.883 -21.040  15.050  0.55 13.53           C  
ATOM    465  C   HIS A  61     -39.256 -22.502  15.211  0.55 12.95           C  
ATOM    467  O   HIS A  61     -38.866 -23.376  14.408  0.55 12.32           O  
ATOM    469  CB  HIS A  61     -38.844 -20.700  13.556  0.55 13.56           C  
ATOM    471  CG  HIS A  61     -40.200 -20.513  12.941  0.55 14.22           C  
ATOM    473  ND1 HIS A  61     -41.006 -21.567  12.560  0.55 15.11           N  
ATOM    475  CD2 HIS A  61     -40.882 -19.387  12.624  0.55 14.61           C  
ATOM    477  CE1 HIS A  61     -42.130 -21.095  12.056  0.55 13.24           C  
ATOM    479  NE2 HIS A  61     -42.076 -19.775  12.072  0.55 14.59           N  
ATOM    481  N   LYS A  62     -39.991 -22.782  16.270  1.00 12.30           N  
ATOM    482  CA  LYS A  62     -40.296 -24.156  16.628  1.00 14.18           C  
ATOM    483  C   LYS A  62     -41.301 -24.813  15.688  1.00 12.90           C  
ATOM    484  O   LYS A  62     -41.304 -26.046  15.534  1.00 13.21           O  
ATOM    485  CB  LYS A  62     -40.840 -24.177  18.043  1.00 17.35           C  
ATOM    486  CG  LYS A  62     -39.774 -24.625  19.015  1.00 21.77           C  
ATOM    487  CD  LYS A  62     -38.915 -23.472  19.468  1.00 25.23           C  
ATOM    488  CE  LYS A  62     -37.871 -23.918  20.492  1.00 24.92           C  
ATOM    489  NZ  LYS A  62     -37.407 -22.753  21.280  1.00 23.33           N  
ATOM    490  N   GLN A  63     -42.161 -23.995  15.091  1.00 11.54           N  
ATOM    491  CA  GLN A  63     -43.159 -24.532  14.153  1.00 13.89           C  
ATOM    492  C   GLN A  63     -42.500 -24.996  12.874  1.00 15.42           C  
ATOM    493  O   GLN A  63     -41.690 -24.284  12.289  1.00 16.92           O  
ATOM    494  CB  GLN A  63     -44.222 -23.486  13.840  1.00 17.35           C  
ATOM    495  CG  GLN A  63     -45.496 -24.055  13.373  1.00 23.73           C  
ATOM    496  CD  GLN A  63     -46.575 -23.016  13.220  1.00 26.12           C  
ATOM    497  OE1 GLN A  63     -46.604 -22.255  12.229  1.00 27.75           O  
ATOM    498  NE2 GLN A  63     -47.483 -22.964  14.204  1.00 27.81           N  
ATOM    499  N   LEU A  64     -42.812 -26.212  12.448  1.00 14.97           N  
ATOM    500  CA  LEU A  64     -42.352 -26.664  11.159  1.00 13.23           C  
ATOM    501  C   LEU A  64     -42.846 -25.730  10.040  1.00 14.05           C  
ATOM    502  O   LEU A  64     -44.000 -25.270  10.040  1.00 14.86           O  
ATOM    503  CB  LEU A  64     -42.892 -28.074  10.929  1.00 14.11           C  
ATOM    504  CG  LEU A  64     -42.405 -29.171  11.847  1.00 13.89           C  
ATOM    505  CD1 LEU A  64     -43.113 -30.524  11.504  1.00 14.27           C  
ATOM    506  CD2 LEU A  64     -40.876 -29.350  11.740  1.00 16.37           C  
ATOM    507  N   LEU A  65     -41.960 -25.411   9.120  1.00 14.01           N  
ATOM    508  CA  LEU A  65     -42.347 -24.647   7.912  1.00 12.52           C  
ATOM    509  C   LEU A  65     -43.079 -25.530   6.886  1.00 15.34           C  
ATOM    510  O   LEU A  65     -42.461 -26.357   6.215  1.00 14.56           O  
ATOM    511  CB  LEU A  65     -41.114 -23.945   7.325  1.00 14.45           C  
ATOM    512  CG  LEU A  65     -40.515 -22.834   8.227  1.00 15.11           C  
ATOM    513  CD1 LEU A  65     -39.564 -23.302   9.368  1.00 16.01           C  
ATOM    514  CD2 LEU A  65     -39.750 -21.888   7.357  1.00 15.01           C  
ATOM    515  N   MET A  66     -44.396 -25.336   6.757  1.00 15.04           N  
ATOM    516  CA  MET A  66     -45.229 -26.316   6.015  1.00 14.92           C  
ATOM    517  C   MET A  66     -45.651 -25.886   4.630  1.00 15.90           C  
ATOM    518  O   MET A  66     -46.494 -26.512   4.018  1.00 15.40           O  
ATOM    519  CB  MET A  66     -46.500 -26.606   6.813  1.00 15.73           C  
ATOM    520  CG  MET A  66     -46.225 -27.275   8.103  1.00 15.64           C  
ATOM    521  SD  MET A  66     -45.402 -28.893   7.946  1.00 16.42           S  
ATOM    522  CE  MET A  66     -46.767 -29.876   7.297  1.00 18.11           C  
ATOM    523  N   SER A  67     -45.121 -24.775   4.147  1.00 17.49           N  
ATOM    524  CA  SER A  67     -45.459 -24.319   2.806  1.00 19.34           C  
ATOM    525  C   SER A  67     -44.183 -24.236   2.014  1.00 17.74           C  
ATOM    526  O   SER A  67     -43.129 -23.876   2.545  1.00 17.21           O  
ATOM    527  CB  SER A  67     -46.072 -22.923   2.876  1.00 20.09           C  
ATOM    528  OG  SER A  67     -47.376 -23.024   3.410  1.00 20.25           O  
ATOM    529  N   PRO A  68     -44.282 -24.514   0.718  1.00 18.69           N  
ATOM    530  CA  PRO A  68     -43.126 -24.445  -0.170  1.00 20.26           C  
ATOM    531  C   PRO A  68     -42.548 -23.053  -0.142  1.00 19.62           C  
ATOM    532  O   PRO A  68     -43.299 -22.081  -0.289  1.00 21.00           O  
ATOM    533  CB  PRO A  68     -43.723 -24.683  -1.551  1.00 19.81           C  
ATOM    534  CG  PRO A  68     -45.061 -25.341  -1.334  1.00 21.91           C  
ATOM    535  CD  PRO A  68     -45.540 -24.866   0.032  1.00 21.01           C  
ATOM    536  N   GLY A  69     -41.228 -22.965   0.044  1.00 20.13           N  
ATOM    537  CA  GLY A  69     -40.507 -21.694   0.076  1.00 18.23           C  
ATOM    538  C   GLY A  69     -40.885 -20.740   1.197  1.00 17.84           C  
ATOM    539  O   GLY A  69     -40.537 -19.545   1.146  1.00 18.84           O  
ATOM    540  N   GLN A  70     -41.602 -21.251   2.195  1.00 14.36           N  
ATOM    541  CA  GLN A  70     -41.900 -20.447   3.379  1.00 13.91           C  
ATOM    542  C   GLN A  70     -40.593 -19.983   3.974  1.00 14.75           C  
ATOM    543  O   GLN A  70     -39.626 -20.766   4.024  1.00 14.92           O  
ATOM    544  CB  GLN A  70     -42.656 -21.304   4.427  1.00 14.93           C  
ATOM    545  CG  GLN A  70     -43.107 -20.533   5.671  1.00 14.71           C  
ATOM    546  CD  GLN A  70     -44.003 -21.372   6.548  1.00 15.83           C  
ATOM    547  OE1 GLN A  70     -44.540 -22.407   6.112  1.00 16.39           O  
ATOM    548  NE2 GLN A  70     -44.128 -20.980   7.824  1.00 15.82           N  
ATOM    549  N   SER A  71     -40.599 -18.741   4.461  1.00 12.98           N  
ATOM    550  CA  SER A  71     -39.467 -18.064   5.072  1.00 14.31           C  
ATOM    551  C   SER A  71     -39.793 -17.730   6.534  1.00 15.35           C  
ATOM    552  O   SER A  71     -40.909 -17.395   6.877  1.00 14.97           O  
ATOM    553  CB  SER A  71     -39.251 -16.717   4.356  1.00 16.39           C  
ATOM    554  OG  SER A  71     -38.208 -15.972   4.956  1.00 21.79           O  
ATOM    555  N   THR A  72     -38.771 -17.824   7.368  1.00 13.04           N  
ATOM    556  CA  THR A  72     -38.805 -17.188   8.681  1.00 13.37           C  
ATOM    557  C   THR A  72     -37.449 -16.525   8.875  1.00 15.06           C  
ATOM    558  O   THR A  72     -36.515 -16.806   8.122  1.00 15.37           O  
ATOM    559  CB  THR A  72     -39.127 -18.183   9.793  1.00 14.41           C  
ATOM    560  OG1 THR A  72     -39.251 -17.450  11.013  1.00 14.97           O  
ATOM    561  CG2 THR A  72     -37.996 -19.258   9.961  1.00 12.44           C  
ATOM    562  N   SER A  73     -37.373 -15.585   9.827  1.00 14.88           N  
ATOM    563  CA  SER A  73     -36.125 -14.920  10.068  1.00 14.84           C  
ATOM    564  C   SER A  73     -35.922 -14.607  11.531  1.00 15.48           C  
ATOM    565  O   SER A  73     -36.874 -14.564  12.319  1.00 16.51           O  
ATOM    566  CB  SER A  73     -36.015 -13.671   9.218  1.00 16.19           C  
ATOM    567  OG  SER A  73     -36.932 -12.720   9.718  1.00 18.13           O  
ATOM    568  N   THR A  74     -34.649 -14.554  11.903  1.00 13.90           N  
ATOM    569  CA  THR A  74     -34.274 -14.274  13.283  1.00 15.08           C  
ATOM    570  C   THR A  74     -33.422 -13.044  13.216  1.00 16.17           C  
ATOM    571  O   THR A  74     -32.305 -13.089  12.683  1.00 14.67           O  
ATOM    572  CB  THR A  74     -33.458 -15.439  13.879  1.00 16.62           C  
ATOM    573  OG1 THR A  74     -34.351 -16.551  14.059  1.00 18.98           O  
ATOM    574  CG2 THR A  74     -32.849 -15.042  15.211  1.00 19.10           C  
ATOM    575  N   THR A  75     -33.937 -11.936  13.724  1.00 15.03           N  
ATOM    576  CA  THR A  75     -33.065 -10.760  13.838  1.00 14.70           C  
ATOM    577  C   THR A  75     -32.382 -10.779  15.194  1.00 16.57           C  
ATOM    578  O   THR A  75     -33.045 -10.751  16.244  1.00 17.23           O  
ATOM    579  CB  THR A  75     -33.833  -9.470  13.665  1.00 16.70           C  
ATOM    580  OG1 THR A  75     -34.260  -9.364  12.298  1.00 18.33           O  
ATOM    581  CG2 THR A  75     -32.927  -8.300  13.987  1.00 15.89           C  
ATOM    582  N   PHE A  76     -31.060 -10.920  15.194  1.00 13.85           N  
ATOM    583  CA  PHE A  76     -30.335 -11.001  16.466  1.00 14.72           C  
ATOM    584  C   PHE A  76     -30.370  -9.710  17.251  1.00 14.23           C  
ATOM    585  O   PHE A  76     -30.166  -8.646  16.691  1.00 16.18           O  
ATOM    586  CB  PHE A  76     -28.892 -11.423  16.219  1.00 13.29           C  
ATOM    587  CG  PHE A  76     -28.744 -12.926  16.107  1.00 13.28           C  
ATOM    588  CD1 PHE A  76     -29.335 -13.622  15.020  1.00 10.10           C  
ATOM    589  CD2 PHE A  76     -28.050 -13.657  17.081  1.00 11.75           C  
ATOM    590  CE1 PHE A  76     -29.206 -14.999  14.950  1.00  9.73           C  
ATOM    591  CE2 PHE A  76     -27.964 -15.013  16.987  1.00 11.43           C  
ATOM    592  CZ  PHE A  76     -28.508 -15.681  15.927  1.00 13.83           C  
ATOM    593  N   PRO A  77     -30.602  -9.807  18.565  1.00 15.04           N  
ATOM    594  CA  PRO A  77     -30.644  -8.574  19.343  1.00 15.56           C  
ATOM    595  C   PRO A  77     -29.342  -7.770  19.214  1.00 13.70           C  
ATOM    596  O   PRO A  77     -28.260  -8.328  18.994  1.00 14.91           O  
ATOM    597  CB  PRO A  77     -30.848  -9.048  20.789  1.00 17.28           C  
ATOM    598  CG  PRO A  77     -31.267 -10.484  20.690  1.00 16.53           C  
ATOM    599  CD  PRO A  77     -30.749 -11.020  19.374  1.00 16.97           C  
ATOM    600  N   ALA A  78     -29.465  -6.451  19.315  1.00 13.62           N  
ATOM    601  CA  ALA A  78     -28.309  -5.570  19.424  1.00 14.91           C  
ATOM    602  C   ALA A  78     -27.368  -6.009  20.535  1.00 13.89           C  
ATOM    603  O   ALA A  78     -26.150  -5.912  20.413  1.00 17.55           O  
ATOM    604  CB  ALA A  78     -28.785  -4.120  19.691  1.00 13.56           C  
ATOM    605  N   ASP A  79     -27.930  -6.439  21.643  1.00 16.37           N  
ATOM    606  CA  ASP A  79     -27.060  -6.890  22.705  1.00 15.51           C  
ATOM    607  C   ASP A  79     -26.720  -8.376  22.657  1.00 15.64           C  
ATOM    608  O   ASP A  79     -26.237  -8.910  23.660  1.00 14.43           O  
ATOM    609  CB  ASP A  79     -27.600  -6.491  24.089  1.00 18.25           C  
ATOM    610  CG  ASP A  79     -28.897  -7.168  24.436  1.00 21.09           C  
ATOM    611  OD1 ASP A  79     -29.451  -7.936  23.614  1.00 22.29           O  
ATOM    612  OD2 ASP A  79     -29.395  -6.921  25.557  1.00 23.60           O  
ATOM    613  N   ALA A  80     -26.917  -9.034  21.501  1.00 13.71           N  
ATOM    614  CA  ALA A  80     -26.585 -10.477  21.421  1.00 14.47           C  
ATOM    615  C   ALA A  80     -25.111 -10.681  21.791  1.00 15.60           C  
ATOM    616  O   ALA A  80     -24.225 -10.062  21.192  1.00 13.95           O  
ATOM    617  CB  ALA A  80     -26.841 -11.008  20.006  1.00 15.21           C  
ATOM    618  N   PRO A  81     -24.842 -11.558  22.784  1.00 14.40           N  
ATOM    619  CA  PRO A  81     -23.429 -11.736  23.162  1.00 14.78           C  
ATOM    620  C   PRO A  81     -22.580 -12.446  22.086  1.00 13.22           C  
ATOM    621  O   PRO A  81     -23.091 -13.309  21.321  1.00 11.96           O  
ATOM    622  CB  PRO A  81     -23.503 -12.528  24.481  1.00 16.50           C  
ATOM    623  CG  PRO A  81     -24.781 -13.340  24.322  1.00 16.41           C  
ATOM    624  CD  PRO A  81     -25.759 -12.388  23.575  1.00 15.10           C  
ATOM    625  N   ALA A  82     -21.287 -12.098  22.059  1.00 11.94           N  
ATOM    626  CA  ALA A  82     -20.342 -12.681  21.090  1.00 11.11           C  
ATOM    627  C   ALA A  82     -20.253 -14.143  21.390  1.00 11.57           C  
ATOM    628  O   ALA A  82     -20.222 -14.558  22.565  1.00 12.99           O  
ATOM    629  CB  ALA A  82     -18.954 -12.069  21.226  1.00  9.66           C  
ATOM    630  N   GLY A  83     -20.204 -14.936  20.333  1.00 11.25           N  
ATOM    631  CA  GLY A  83     -19.837 -16.345  20.426  1.00 11.66           C  
ATOM    632  C   GLY A  83     -20.715 -17.260  19.607  1.00 11.33           C  
ATOM    633  O   GLY A  83     -21.375 -16.817  18.697  1.00 12.42           O  
ATOM    634  N   GLU A  84     -20.750 -18.541  20.001  1.00 12.80           N  
ATOM    635  CA  GLU A  84     -21.391 -19.551  19.171  1.00 13.78           C  
ATOM    636  C   GLU A  84     -22.828 -19.776  19.600  1.00 13.93           C  
ATOM    637  O   GLU A  84     -23.129 -19.775  20.805  1.00 15.87           O  
ATOM    638  CB  GLU A  84     -20.630 -20.868  19.290  1.00 14.13           C  
ATOM    639  CG  GLU A  84     -19.239 -20.752  18.726  1.00 14.68           C  
ATOM    640  CD  GLU A  84     -18.489 -22.044  18.841  1.00 16.76           C  
ATOM    641  OE1 GLU A  84     -19.113 -23.093  19.109  1.00 16.48           O  
ATOM    642  OE2 GLU A  84     -17.265 -22.005  18.664  1.00 22.28           O  
ATOM    643  N   TYR A  85     -23.692 -19.943  18.601  1.00 14.21           N  
ATOM    644  CA  TYR A  85     -25.097 -20.262  18.765  1.00 12.35           C  
ATOM    645  C   TYR A  85     -25.421 -21.492  17.941  1.00 13.94           C  
ATOM    646  O   TYR A  85     -25.513 -21.430  16.695  1.00 14.15           O  
ATOM    647  CB  TYR A  85     -25.977 -19.130  18.259  1.00 12.32           C  
ATOM    648  CG  TYR A  85     -25.840 -17.838  19.067  1.00  9.53           C  
ATOM    649  CD1 TYR A  85     -24.698 -17.050  18.981  1.00 10.39           C  
ATOM    650  CD2 TYR A  85     -26.892 -17.396  19.867  1.00  9.56           C  
ATOM    651  CE1 TYR A  85     -24.609 -15.827  19.716  1.00 11.37           C  
ATOM    652  CE2 TYR A  85     -26.803 -16.219  20.574  1.00 10.84           C  
ATOM    653  CZ  TYR A  85     -25.670 -15.444  20.483  1.00 11.79           C  
ATOM    654  OH  TYR A  85     -25.636 -14.254  21.201  1.00 12.96           O  
ATOM    655  N   THR A  86     -25.575 -22.621  18.627  1.00 14.39           N  
ATOM    656  CA  THR A  86     -25.879 -23.887  17.961  1.00 14.26           C  
ATOM    657  C   THR A  86     -27.391 -23.995  17.743  1.00 15.02           C  
ATOM    658  O   THR A  86     -28.182 -23.674  18.645  1.00 12.48           O  
ATOM    659  CB  THR A  86     -25.362 -25.016  18.842  1.00 15.86           C  
ATOM    660  OG1 THR A  86     -23.943 -24.992  18.735  1.00 14.31           O  
ATOM    661  CG2 THR A  86     -25.914 -26.409  18.466  1.00 19.75           C  
ATOM    662  N   PHE A  87     -27.777 -24.452  16.564  1.00 12.29           N  
ATOM    663  CA  PHE A  87     -29.192 -24.650  16.275  1.00 13.24           C  
ATOM    664  C   PHE A  87     -29.414 -25.903  15.487  1.00 13.38           C  
ATOM    665  O   PHE A  87     -28.503 -26.396  14.834  1.00 11.44           O  
ATOM    666  CB  PHE A  87     -29.794 -23.426  15.592  1.00 11.04           C  
ATOM    667  CG  PHE A  87     -29.213 -23.128  14.245  1.00 10.83           C  
ATOM    668  CD1 PHE A  87     -29.826 -23.636  13.117  1.00 10.91           C  
ATOM    669  CD2 PHE A  87     -28.054 -22.389  14.119  1.00 11.08           C  
ATOM    670  CE1 PHE A  87     -29.363 -23.384  11.864  1.00 11.46           C  
ATOM    671  CE2 PHE A  87     -27.524 -22.167  12.808  1.00  9.13           C  
ATOM    672  CZ  PHE A  87     -28.212 -22.658  11.702  1.00 11.57           C  
ATOM    673  N   TYR A  88     -30.633 -26.417  15.473  1.00 14.17           N  
ATOM    674  CA  TYR A  88     -30.839 -27.613  14.703  1.00 14.74           C  
ATOM    675  C   TYR A  88     -32.273 -27.688  14.236  1.00 15.04           C  
ATOM    676  O   TYR A  88     -33.136 -26.946  14.724  1.00 14.36           O  
ATOM    677  CB  TYR A  88     -30.500 -28.830  15.597  1.00 16.03           C  
ATOM    678  CG  TYR A  88     -31.174 -28.795  16.970  1.00 18.59           C  
ATOM    679  CD1 TYR A  88     -30.470 -28.402  18.109  1.00 18.36           C  
ATOM    680  CD2 TYR A  88     -32.499 -29.147  17.123  1.00 18.36           C  
ATOM    681  CE1 TYR A  88     -31.112 -28.367  19.404  1.00 18.96           C  
ATOM    682  CE2 TYR A  88     -33.133 -29.108  18.370  1.00 20.44           C  
ATOM    683  CZ  TYR A  88     -32.437 -28.707  19.497  1.00 18.46           C  
ATOM    684  OH  TYR A  88     -33.094 -28.688  20.735  1.00 21.71           O  
ATOM    685  N   CYS A  89     -32.498 -28.602  13.285  1.00 14.09           N  
ATOM    686  CA  CYS A  89     -33.838 -28.912  12.801  1.00 13.68           C  
ATOM    687  C   CYS A  89     -34.253 -30.121  13.641  1.00 15.54           C  
ATOM    688  O   CYS A  89     -33.488 -31.070  13.776  1.00 16.24           O  
ATOM    689  CB  CYS A  89     -33.799 -29.264  11.323  1.00 17.70           C  
ATOM    690  SG  CYS A  89     -35.317 -30.009  10.772  1.00 15.30           S  
ATOM    691  N   GLU A  90     -35.440 -30.081  14.234  1.00 16.16           N  
ATOM    692  CA  GLU A  90     -35.823 -31.176  15.133  1.00 17.79           C  
ATOM    693  C   GLU A  90     -36.022 -32.503  14.429  1.00 18.23           C  
ATOM    694  O   GLU A  90     -35.416 -33.508  14.835  1.00 19.53           O  
ATOM    695  CB  GLU A  90     -37.061 -30.825  15.945  1.00 19.06           C  
ATOM    696  CG  GLU A  90     -36.655 -29.946  17.098  1.00 22.07           C  
ATOM    697  CD  GLU A  90     -37.814 -29.462  17.924  1.00 24.64           C  
ATOM    698  OE1 GLU A  90     -37.534 -29.217  19.103  1.00 24.44           O  
ATOM    699  OE2 GLU A  90     -38.959 -29.296  17.397  1.00 25.90           O  
ATOM    700  N   PRO A  91     -36.890 -32.525  13.409  1.00 17.32           N  
ATOM    701  CA  PRO A  91     -37.034 -33.784  12.677  1.00 17.34           C  
ATOM    702  C   PRO A  91     -35.740 -34.378  12.208  1.00 17.58           C  
ATOM    703  O   PRO A  91     -35.572 -35.596  12.313  1.00 17.87           O  
ATOM    704  CB  PRO A  91     -37.909 -33.432  11.466  1.00 18.61           C  
ATOM    705  CG  PRO A  91     -38.347 -32.013  11.592  1.00 17.58           C  
ATOM    706  CD  PRO A  91     -37.867 -31.500  12.976  1.00 17.15           C  
ATOM    707  N   HIS A  92     -34.835 -33.532  11.725  1.00 15.63           N  
ATOM    708  CA  HIS A  92     -33.624 -33.990  11.033  1.00 14.84           C  
ATOM    709  C   HIS A  92     -32.349 -33.922  11.847  1.00 14.67           C  
ATOM    710  O   HIS A  92     -31.252 -34.218  11.328  1.00 12.89           O  
ATOM    711  CB  HIS A  92     -33.464 -33.225   9.756  1.00 17.19           C  
ATOM    712  CG  HIS A  92     -34.570 -33.470   8.803  1.00 15.30           C  
ATOM    713  ND1 HIS A  92     -35.163 -32.466   8.064  1.00 11.09           N  
ATOM    714  CD2 HIS A  92     -35.236 -34.613   8.501  1.00 15.38           C  
ATOM    715  CE1 HIS A  92     -36.125 -32.981   7.328  1.00 14.23           C  
ATOM    716  NE2 HIS A  92     -36.166 -34.289   7.536  1.00 14.53           N  
ATOM    717  N   ARG A  93     -32.486 -33.587  13.112  1.00 14.55           N  
ATOM    718  CA  ARG A  93     -31.357 -33.522  13.994  1.00 16.52           C  
ATOM    719  C   ARG A  93     -30.486 -34.780  13.944  1.00 16.00           C  
ATOM    720  O   ARG A  93     -29.257 -34.689  13.891  1.00 18.02           O  
ATOM    721  CB  ARG A  93     -31.818 -33.234  15.422  1.00 17.13           C  
ATOM    722  CG  ARG A  93     -30.700 -33.008  16.381  1.00 18.01           C  
ATOM    723  CD  ARG A  93     -31.313 -32.641  17.706  1.00 18.18           C  
ATOM    724  NE  ARG A  93     -30.350 -32.043  18.616  1.00 21.11           N  
ATOM    725  CZ  ARG A  93     -30.628 -31.857  19.903  1.00 19.68           C  
ATOM    726  NH1 ARG A  93     -31.808 -32.225  20.356  1.00 23.07           N  
ATOM    727  NH2 ARG A  93     -29.756 -31.327  20.732  1.00 21.67           N  
ATOM    728  N   GLY A  94     -31.122 -35.943  13.976  1.00 14.28           N  
ATOM    729  CA  GLY A  94     -30.383 -37.198  14.049  1.00 14.22           C  
ATOM    730  C   GLY A  94     -29.803 -37.578  12.687  1.00 16.01           C  
ATOM    731  O   GLY A  94     -28.939 -38.442  12.600  1.00 15.95           O  
ATOM    732  N   ALA A  95     -30.299 -36.945  11.623  1.00 13.06           N  
ATOM    733  CA  ALA A  95     -29.740 -37.079  10.286  1.00 14.95           C  
ATOM    734  C   ALA A  95     -28.587 -36.105  10.045  1.00 15.15           C  
ATOM    735  O   ALA A  95     -27.947 -36.123   8.996  1.00 15.49           O  
ATOM    736  CB  ALA A  95     -30.853 -36.911   9.235  1.00 17.32           C  
ATOM    737  N   GLY A  96     -28.306 -35.244  11.022  1.00 15.95           N  
ATOM    738  CA  GLY A  96     -27.157 -34.335  10.854  1.00 14.98           C  
ATOM    739  C   GLY A  96     -27.502 -32.856  10.717  1.00 16.58           C  
ATOM    740  O   GLY A  96     -26.572 -32.021  10.617  1.00 15.62           O  
ATOM    741  N   MET A  97     -28.793 -32.521  10.725  1.00 13.32           N  
ATOM    742  CA  MET A  97     -29.220 -31.163  10.377  1.00 11.71           C  
ATOM    743  C   MET A  97     -29.026 -30.266  11.568  1.00 15.39           C  
ATOM    744  O   MET A  97     -29.933 -30.033  12.380  1.00 12.44           O  
ATOM    745  CB  MET A  97     -30.676 -31.142   9.878  1.00 11.35           C  
ATOM    746  CG  MET A  97     -31.056 -29.792   9.287  1.00 12.96           C  
ATOM    747  SD  MET A  97     -32.359 -29.915   8.031  1.00 12.66           S  
ATOM    748  CE  MET A  97     -32.687 -28.197   7.696  1.00 12.78           C  
ATOM    749  N   VAL A  98     -27.796 -29.773  11.670  1.00 13.46           N  
ATOM    750  CA  VAL A  98     -27.370 -28.976  12.804  1.00 13.10           C  
ATOM    751  C   VAL A  98     -26.546 -27.827  12.237  1.00 13.64           C  
ATOM    752  O   VAL A  98     -25.813 -27.977  11.209  1.00 12.96           O  
ATOM    753  CB  VAL A  98     -26.461 -29.791  13.781  1.00 12.61           C  
ATOM    754  CG1 VAL A  98     -25.871 -28.891  14.875  1.00 12.42           C  
ATOM    755  CG2 VAL A  98     -27.258 -30.925  14.416  1.00 12.80           C  
ATOM    756  N   GLY A  99     -26.700 -26.660  12.854  1.00 12.37           N  
ATOM    757  CA  GLY A  99     -25.956 -25.500  12.368  1.00 12.20           C  
ATOM    758  C   GLY A  99     -25.359 -24.672  13.450  1.00 13.12           C  
ATOM    759  O   GLY A  99     -25.588 -24.903  14.626  1.00 13.57           O  
ATOM    760  N   LYS A 100     -24.548 -23.695  13.060  1.00 15.50           N  
ATOM    761  CA  LYS A 100     -23.907 -22.861  14.082  1.00 12.31           C  
ATOM    762  C   LYS A 100     -23.694 -21.431  13.554  1.00 13.46           C  
ATOM    763  O   LYS A 100     -23.118 -21.212  12.484  1.00 14.45           O  
ATOM    764  CB  LYS A 100     -22.593 -23.464  14.551  1.00 13.56           C  
ATOM    765  CG  LYS A 100     -21.903 -22.633  15.687  1.00 15.85           C  
ATOM    766  CD  LYS A 100     -20.475 -23.136  15.771  1.00 16.14           C  
ATOM    767  CE  LYS A 100     -20.375 -24.441  16.560  1.00 18.55           C  
ATOM    768  NZ  LYS A 100     -18.889 -24.713  16.732  1.00 17.09           N  
ATOM    769  N   ILE A 101     -24.215 -20.485  14.298  1.00 11.87           N  
ATOM    770  CA  ILE A 101     -24.023 -19.074  14.015  1.00 13.08           C  
ATOM    771  C   ILE A 101     -22.995 -18.567  15.007  1.00 13.28           C  
ATOM    772  O   ILE A 101     -23.076 -18.874  16.176  1.00 15.00           O  
ATOM    773  CB  ILE A 101     -25.346 -18.323  14.128  1.00 14.13           C  
ATOM    774  CG1 ILE A 101     -26.195 -18.653  12.878  1.00 15.37           C  
ATOM    775  CG2 ILE A 101     -25.108 -16.814  14.244  1.00 15.68           C  
ATOM    776  CD1 ILE A 101     -27.651 -18.398  13.032  1.00 19.01           C  
ATOM    777  N   THR A 102     -22.004 -17.819  14.546  1.00 14.18           N  
ATOM    778  CA  THR A 102     -21.101 -17.156  15.449  1.00 12.93           C  
ATOM    779  C   THR A 102     -21.368 -15.686  15.352  1.00 12.60           C  
ATOM    780  O   THR A 102     -21.410 -15.115  14.262  1.00 13.11           O  
ATOM    781  CB  THR A 102     -19.639 -17.410  15.057  1.00 14.24           C  
ATOM    782  OG1 THR A 102     -19.378 -18.802  15.201  1.00 15.81           O  
ATOM    783  CG2 THR A 102     -18.709 -16.586  15.919  1.00 11.06           C  
ATOM    784  N   VAL A 103     -21.606 -15.087  16.499  1.00 10.20           N  
ATOM    785  CA  VAL A 103     -21.766 -13.647  16.570  1.00 12.08           C  
ATOM    786  C   VAL A 103     -20.423 -13.071  16.961  1.00 14.40           C  
ATOM    787  O   VAL A 103     -19.779 -13.527  17.935  1.00 16.16           O  
ATOM    788  CB  VAL A 103     -22.834 -13.254  17.619  1.00 12.27           C  
ATOM    789  CG1 VAL A 103     -22.872 -11.782  17.794  1.00 10.80           C  
ATOM    790  CG2 VAL A 103     -24.209 -13.795  17.162  1.00 12.09           C  
ATOM    791  N   ALA A 104     -20.000 -12.081  16.201  1.00 14.41           N  
ATOM    792  CA  ALA A 104     -18.716 -11.419  16.409  1.00 15.42           C  
ATOM    793  C   ALA A 104     -18.911  -9.932  16.041  1.00 14.94           C  
ATOM    794  O   ALA A 104     -19.960  -9.533  15.524  1.00 13.92           O  
ATOM    795  CB  ALA A 104     -17.664 -12.054  15.499  1.00 13.39           C  
ATOM    796  N   GLY A 105     -17.880  -9.119  16.313  1.00 16.33           N  
ATOM    797  CA  GLY A 105     -17.916  -7.683  16.051  1.00 16.04           C  
ATOM    798  C   GLY A 105     -17.893  -7.221  14.604  1.00 17.12           C  
ATOM    799  O   GLY A 105     -17.993  -6.006  14.339  1.00 14.62           O  
ATOM    800  OXT GLY A 105     -17.732  -8.024  13.659  1.00 17.60           O  
TER     801      GLY A 105                                                      
END
MOLECULE T0390.pdb
ATOM   1417  N   ALA    29     -25.126  -7.662   1.817  1.00100.22           N  
ATOM   1418  CA  ALA    29     -24.203  -6.752   2.561  1.00102.70           C  
ATOM   1419  CB  ALA    29     -24.370  -5.286   2.082  1.00105.39           C  
ATOM   1420  C   ALA    29     -24.440  -6.859   4.069  1.00100.61           C  
ATOM   1421  O   ALA    29     -23.542  -6.584   4.874  1.00103.55           O  
ATOM   1422  N   ASP    30     -25.642  -7.297   4.438  1.00 95.26           N  
ATOM   1423  CA  ASP    30     -26.174  -7.076   5.775  1.00 90.56           C  
ATOM   1424  CB  ASP    30     -27.168  -5.921   5.687  1.00 92.74           C  
ATOM   1425  CG  ASP    30     -27.589  -5.421   7.032  1.00 94.90           C  
ATOM   1426  OD1 ASP    30     -26.753  -5.488   7.957  1.00 97.71           O  
ATOM   1427  OD2 ASP    30     -28.748  -4.962   7.166  1.00 95.01           O  
ATOM   1428  C   ASP    30     -26.877  -8.312   6.349  1.00 85.08           C  
ATOM   1429  O   ASP    30     -26.918  -8.504   7.567  1.00 84.01           O  
ATOM   1430  N   ARG    31     -27.450  -9.130   5.464  1.00 79.52           N  
ATOM   1431  CA  ARG    31     -28.160 -10.341   5.860  1.00 73.24           C  
ATOM   1432  CB  ARG    31     -29.676 -10.248   5.558  1.00 73.02           C  
ATOM   1433  CG  ARG    31     -30.128  -9.281   4.458  1.00 71.63           C  
ATOM   1434  CD  ARG    31     -31.576  -8.824   4.658  1.00 70.77           C  
ATOM   1435  NE  ARG    31     -32.323  -9.800   5.444  1.00 70.30           N  
ATOM   1436  CZ  ARG    31     -33.224  -9.495   6.379  1.00 69.91           C  
ATOM   1437  NH1 ARG    31     -33.825 -10.465   7.068  1.00 64.29           N  
ATOM   1438  NH2 ARG    31     -33.513  -8.226   6.639  1.00 66.83           N  
ATOM   1439  C   ARG    31     -27.541 -11.632   5.309  1.00 70.84           C  
ATOM   1440  O   ARG    31     -27.034 -11.668   4.203  1.00 72.53           O  
ATOM   1441  N   HIS    32     -27.579 -12.687   6.107  1.00 67.66           N  
ATOM   1442  CA  HIS    32     -26.995 -13.968   5.743  1.00 65.70           C  
ATOM   1443  CB  HIS    32     -26.038 -14.432   6.839  1.00 64.57           C  
ATOM   1444  CG  HIS    32     -25.079 -13.377   7.294  1.00 65.98           C  
ATOM   1445  ND1 HIS    32     -23.753 -13.361   6.918  1.00 68.45           N  
ATOM   1446  CE1 HIS    32     -23.147 -12.327   7.473  1.00 68.52           C  
ATOM   1447  NE2 HIS    32     -24.034 -11.668   8.197  1.00 70.63           N  
ATOM   1448  CD2 HIS    32     -25.247 -12.309   8.110  1.00 68.60           C  
ATOM   1449  C   HIS    32     -28.097 -15.016   5.529  1.00 64.32           C  
ATOM   1450  O   HIS    32     -29.034 -15.140   6.326  1.00 64.73           O  
ATOM   1451  N   THR    33     -27.991 -15.763   4.443  1.00 64.18           N  
ATOM   1452  CA  THR    33     -29.026 -16.716   4.069  1.00 61.66           C  
ATOM   1453  CB  THR    33     -29.371 -16.572   2.588  1.00 60.48           C  
ATOM   1454  OG1 THR    33     -29.757 -15.222   2.336  1.00 64.06           O  
ATOM   1455  CG2 THR    33     -30.515 -17.473   2.204  1.00 60.36           C  
ATOM   1456  C   THR    33     -28.563 -18.133   4.345  1.00 60.90           C  
ATOM   1457  O   THR    33     -27.470 -18.523   3.937  1.00 61.38           O  
ATOM   1458  N   VAL    34     -29.394 -18.893   5.050  1.00 59.79           N  
ATOM   1459  CA  VAL    34     -29.129 -20.304   5.279  1.00 58.71           C  
ATOM   1460  CB  VAL    34     -28.924 -20.615   6.781  1.00 58.54           C  
ATOM   1461  CG1 VAL    34     -28.753 -22.122   7.003  1.00 54.88           C  
ATOM   1462  CG2 VAL    34     -27.724 -19.842   7.322  1.00 58.10           C  
ATOM   1463  C   VAL    34     -30.292 -21.119   4.737  1.00 58.02           C  
ATOM   1464  O   VAL    34     -31.439 -20.929   5.132  1.00 57.92           O  
ATOM   1465  N   PHE    35     -29.997 -22.021   3.816  1.00 58.93           N  
ATOM   1466  CA  PHE    35     -31.014 -22.945   3.330  1.00 57.38           C  
ATOM   1467  CB  PHE    35     -30.754 -23.313   1.873  1.00 56.05           C  
ATOM   1468  CG  PHE    35     -30.974 -22.168   0.935  1.00 57.38           C  
ATOM   1469  CD1 PHE    35     -29.944 -21.264   0.661  1.00 58.82           C  
ATOM   1470  CE1 PHE    35     -30.149 -20.180  -0.191  1.00 57.97           C  
ATOM   1471  CZ  PHE    35     -31.402 -19.989  -0.771  1.00 58.81           C  
ATOM   1472  CE2 PHE    35     -32.447 -20.877  -0.492  1.00 56.51           C  
ATOM   1473  CD2 PHE    35     -32.230 -21.953   0.363  1.00 58.39           C  
ATOM   1474  C   PHE    35     -31.087 -24.155   4.248  1.00 58.31           C  
ATOM   1475  O   PHE    35     -30.221 -25.039   4.194  1.00 59.87           O  
ATOM   1476  N   TRP    36     -32.103 -24.175   5.118  1.00 56.23           N  
ATOM   1477  CA  TRP    36     -32.240 -25.269   6.062  1.00 54.10           C  
ATOM   1478  CB  TRP    36     -33.030 -24.851   7.307  1.00 52.43           C  
ATOM   1479  CG  TRP    36     -32.664 -25.690   8.480  1.00 50.06           C  
ATOM   1480  CD1 TRP    36     -33.078 -26.955   8.722  1.00 50.33           C  
ATOM   1481  NE1 TRP    36     -32.518 -27.428   9.883  1.00 54.82           N  
ATOM   1482  CE2 TRP    36     -31.709 -26.461  10.418  1.00 54.47           C  
ATOM   1483  CD2 TRP    36     -31.769 -25.344   9.551  1.00 52.76           C  
ATOM   1484  CE3 TRP    36     -31.039 -24.192   9.881  1.00 53.93           C  
ATOM   1485  CZ3 TRP    36     -30.269 -24.199  11.060  1.00 53.49           C  
ATOM   1486  CH2 TRP    36     -30.216 -25.339  11.891  1.00 51.75           C  
ATOM   1487  CZ2 TRP    36     -30.924 -26.476  11.588  1.00 51.62           C  
ATOM   1488  C   TRP    36     -32.884 -26.471   5.415  1.00 54.79           C  
ATOM   1489  O   TRP    36     -34.088 -26.652   5.506  1.00 55.66           O  
ATOM   1490  N   ASN    37     -32.095 -27.299   4.748  1.00 57.05           N  
ATOM   1491  CA  ASN    37     -32.637 -28.573   4.245  1.00 59.69           C  
ATOM   1492  CB  ASN    37     -33.492 -28.399   2.962  1.00 59.25           C  
ATOM   1493  CG  ASN    37     -32.663 -28.102   1.708  1.00 63.24           C  
ATOM   1494  OD1 ASN    37     -31.855 -28.934   1.251  1.00 65.74           O  
ATOM   1495  ND2 ASN    37     -32.895 -26.924   1.119  1.00 67.21           N  
ATOM   1496  C   ASN    37     -31.539 -29.627   4.114  1.00 60.96           C  
ATOM   1497  O   ASN    37     -30.354 -29.274   4.027  1.00 62.64           O  
ATOM   1498  N   SER    38     -31.916 -30.903   4.110  1.00 60.38           N  
ATOM   1499  CA  SER    38     -30.911 -31.965   4.214  1.00 63.35           C  
ATOM   1500  CB  SER    38     -31.532 -33.268   4.692  1.00 64.11           C  
ATOM   1501  OG  SER    38     -32.155 -33.900   3.602  1.00 70.02           O  
ATOM   1502  C   SER    38     -30.080 -32.216   2.954  1.00 63.69           C  
ATOM   1503  O   SER    38     -29.178 -33.033   2.998  1.00 63.92           O  
ATOM   1504  N   SER    39     -30.385 -31.519   1.856  1.00 63.86           N  
ATOM   1505  CA  SER    39     -29.558 -31.551   0.639  1.00 64.78           C  
ATOM   1506  CB  SER    39     -30.398 -31.342  -0.618  1.00 63.72           C  
ATOM   1507  OG  SER    39     -31.246 -32.437  -0.826  1.00 67.02           O  
ATOM   1508  C   SER    39     -28.510 -30.464   0.641  1.00 64.68           C  
ATOM   1509  O   SER    39     -27.688 -30.405  -0.267  1.00 68.02           O  
ATOM   1510  N   ASN    40     -28.573 -29.562   1.611  1.00 62.24           N  
ATOM   1511  CA  ASN    40     -27.614 -28.481   1.656  1.00 61.94           C  
ATOM   1512  CB  ASN    40     -28.096 -27.368   2.590  1.00 59.83           C  
ATOM   1513  CG  ASN    40     -27.194 -26.152   2.559  1.00 59.19           C  
ATOM   1514  OD1 ASN    40     -26.036 -26.220   2.101  1.00 59.05           O  
ATOM   1515  ND2 ASN    40     -27.716 -25.020   3.038  1.00 52.18           N  
ATOM   1516  C   ASN    40     -26.279 -29.030   2.130  1.00 62.98           C  
ATOM   1517  O   ASN    40     -26.143 -29.337   3.314  1.00 65.11           O  
ATOM   1518  N   PRO    41     -25.284 -29.124   1.226  1.00 63.55           N  
ATOM   1519  CA  PRO    41     -24.003 -29.741   1.548  1.00 64.85           C  
ATOM   1520  CB  PRO    41     -23.161 -29.492   0.286  1.00 66.12           C  
ATOM   1521  CG  PRO    41     -24.138 -29.321  -0.799  1.00 65.91           C  
ATOM   1522  CD  PRO    41     -25.298 -28.614  -0.158  1.00 64.70           C  
ATOM   1523  C   PRO    41     -23.309 -29.122   2.757  1.00 65.52           C  
ATOM   1524  O   PRO    41     -22.517 -29.791   3.419  1.00 66.69           O  
ATOM   1525  N   LYS    42     -23.600 -27.861   3.053  1.00 62.16           N  
ATOM   1526  CA  LYS    42     -22.900 -27.169   4.135  1.00 64.34           C  
ATOM   1527  CB  LYS    42     -23.244 -25.682   4.133  1.00 63.63           C  
ATOM   1528  CG  LYS    42     -22.820 -25.020   2.851  1.00 62.79           C  
ATOM   1529  CD  LYS    42     -22.705 -23.542   3.001  1.00 64.18           C  
ATOM   1530  CE  LYS    42     -22.140 -22.977   1.727  1.00 68.95           C  
ATOM   1531  NZ  LYS    42     -22.825 -21.712   1.400  1.00 74.60           N  
ATOM   1532  C   LYS    42     -23.112 -27.783   5.511  1.00 65.92           C  
ATOM   1533  O   LYS    42     -22.289 -27.611   6.401  1.00 68.21           O  
ATOM   1534  N   PHE    43     -24.204 -28.528   5.656  1.00 67.42           N  
ATOM   1535  CA  PHE    43     -24.552 -29.227   6.882  1.00 69.26           C  
ATOM   1536  CB  PHE    43     -26.053 -29.547   6.881  1.00 68.78           C  
ATOM   1537  CG  PHE    43     -26.924 -28.367   7.194  1.00 70.15           C  
ATOM   1538  CD1 PHE    43     -26.880 -27.767   8.448  1.00 70.44           C  
ATOM   1539  CE1 PHE    43     -27.676 -26.680   8.742  1.00 72.10           C  
ATOM   1540  CZ  PHE    43     -28.537 -26.175   7.786  1.00 70.06           C  
ATOM   1541  CE2 PHE    43     -28.591 -26.758   6.534  1.00 70.66           C  
ATOM   1542  CD2 PHE    43     -27.787 -27.853   6.240  1.00 69.34           C  
ATOM   1543  C   PHE    43     -23.773 -30.525   7.054  1.00 72.65           C  
ATOM   1544  O   PHE    43     -23.779 -31.128   8.144  1.00 74.80           O  
ATOM   1545  N   ARG    44     -23.136 -30.972   5.972  1.00 73.67           N  
ATOM   1546  CA  ARG    44     -22.502 -32.284   5.941  1.00 77.35           C  
ATOM   1547  CB  ARG    44     -22.077 -32.683   4.518  1.00 77.02           C  
ATOM   1548  CG  ARG    44     -21.282 -33.978   4.439  1.00 80.74           C  
ATOM   1549  CD  ARG    44     -21.486 -34.745   3.146  1.00 81.73           C  
ATOM   1550  NE  ARG    44     -21.030 -33.978   1.996  1.00 76.92           N  
ATOM   1551  CZ  ARG    44     -21.830 -33.528   1.042  1.00 71.12           C  
ATOM   1552  NH1 ARG    44     -23.122 -33.781   1.075  1.00 65.89           N  
ATOM   1553  NH2 ARG    44     -21.329 -32.832   0.046  1.00 73.50           N  
ATOM   1554  C   ARG    44     -21.350 -32.397   6.936  1.00 81.28           C  
ATOM   1555  O   ARG    44     -21.137 -33.462   7.494  1.00 84.45           O  
ATOM   1556  N   ASN    45     -20.623 -31.320   7.196  1.00 83.31           N  
ATOM   1557  CA  ASN    45     -19.516 -31.458   8.129  1.00 89.14           C  
ATOM   1558  CB  ASN    45     -18.325 -30.589   7.706  1.00 90.67           C  
ATOM   1562  C   ASN    45     -19.916 -31.277   9.611  1.00 91.62           C  
ATOM   1563  O   ASN    45     -19.147 -31.615  10.520  1.00 93.86           O  
ATOM   1564  N   GLU    46     -21.134 -30.775   9.842  1.00 91.09           N  
ATOM   1565  CA  GLU    46     -21.671 -30.506  11.198  1.00 92.01           C  
ATOM   1566  CB  GLU    46     -21.888 -31.807  11.993  1.00 94.29           C  
ATOM   1567  CG  GLU    46     -22.673 -32.872  11.210  1.00 95.61           C  
ATOM   1568  CD  GLU    46     -23.036 -34.121  12.024  1.00 99.79           C  
ATOM   1569  OE1 GLU    46     -22.526 -34.300  13.160  1.00103.61           O  
ATOM   1570  OE2 GLU    46     -23.840 -34.935  11.507  1.00101.22           O  
ATOM   1571  C   GLU    46     -20.797 -29.487  11.942  1.00 91.41           C  
ATOM   1572  O   GLU    46     -20.872 -29.328  13.166  1.00 92.29           O  
ATOM   1573  N   ASP    47     -19.977 -28.798  11.151  1.00 89.12           N  
ATOM   1574  CA  ASP    47     -19.143 -27.686  11.586  1.00 87.14           C  
ATOM   1575  CB  ASP    47     -17.695 -27.903  11.124  1.00 89.68           C  
ATOM   1576  CG  ASP    47     -17.562 -28.039   9.587  1.00 90.74           C  
ATOM   1577  OD1 ASP    47     -18.585 -28.119   8.855  1.00 86.38           O  
ATOM   1578  OD2 ASP    47     -16.405 -28.084   9.107  1.00 97.26           O  
ATOM   1579  C   ASP    47     -19.679 -26.375  10.998  1.00 82.03           C  
ATOM   1580  O   ASP    47     -19.103 -25.319  11.209  1.00 81.44           O  
ATOM   1581  N   TYR    48     -20.770 -26.462  10.242  1.00 77.20           N  
ATOM   1582  CA  TYR    48     -21.382 -25.302   9.609  1.00 74.21           C  
ATOM   1583  CB  TYR    48     -22.776 -25.676   9.067  1.00 73.30           C  
ATOM   1584  CG  TYR    48     -23.420 -24.667   8.120  1.00 71.47           C  
ATOM   1585  CD1 TYR    48     -24.744 -24.834   7.695  1.00 70.66           C  
ATOM   1586  CE1 TYR    48     -25.343 -23.923   6.819  1.00 68.10           C  
ATOM   1587  CZ  TYR    48     -24.620 -22.830   6.373  1.00 68.15           C  
ATOM   1588  OH  TYR    48     -25.197 -21.932   5.519  1.00 67.00           O  
ATOM   1589  CE2 TYR    48     -23.306 -22.637   6.772  1.00 68.50           C  
ATOM   1590  CD2 TYR    48     -22.712 -23.550   7.644  1.00 70.49           C  
ATOM   1591  C   TYR    48     -21.477 -24.102  10.558  1.00 73.61           C  
ATOM   1592  O   TYR    48     -22.263 -24.101  11.524  1.00 75.01           O  
ATOM   1593  N   THR    49     -20.664 -23.088  10.297  1.00 70.93           N  
ATOM   1594  CA  THR    49     -20.736 -21.870  11.090  1.00 69.64           C  
ATOM   1595  CB  THR    49     -19.715 -21.855  12.277  1.00 71.04           C  
ATOM   1596  OG1 THR    49     -19.033 -20.605  12.302  1.00 71.14           O  
ATOM   1597  CG2 THR    49     -18.697 -22.930  12.166  1.00 68.82           C  
ATOM   1598  C   THR    49     -20.658 -20.593  10.240  1.00 67.14           C  
ATOM   1599  O   THR    49     -19.863 -20.517   9.341  1.00 65.65           O  
ATOM   1600  N   ILE    50     -21.514 -19.613  10.523  1.00 66.24           N  
ATOM   1601  CA  ILE    50     -21.489 -18.336   9.811  1.00 64.98           C  
ATOM   1602  CB  ILE    50     -22.823 -18.008   9.090  1.00 65.33           C  
ATOM   1603  CG1 ILE    50     -23.910 -17.657  10.099  1.00 65.90           C  
ATOM   1604  CD1 ILE    50     -25.306 -17.700   9.521  1.00 73.93           C  
ATOM   1605  CG2 ILE    50     -23.256 -19.148   8.131  1.00 61.42           C  
ATOM   1606  C   ILE    50     -21.133 -17.213  10.787  1.00 65.67           C  
ATOM   1607  O   ILE    50     -21.490 -17.266  11.967  1.00 67.03           O  
ATOM   1608  N   HIS    51     -20.416 -16.212  10.284  1.00 64.25           N  
ATOM   1609  CA  HIS    51     -19.943 -15.105  11.084  1.00 63.60           C  
ATOM   1610  CB  HIS    51     -18.461 -14.901  10.835  1.00 65.49           C  
ATOM   1611  CG  HIS    51     -17.630 -16.088  11.195  1.00 70.79           C  
ATOM   1612  ND1 HIS    51     -16.951 -16.185  12.391  1.00 72.94           N  
ATOM   1613  CE1 HIS    51     -16.306 -17.337  12.435  1.00 74.97           C  
ATOM   1614  NE2 HIS    51     -16.554 -17.996  11.315  1.00 76.53           N  
ATOM   1615  CD2 HIS    51     -17.379 -17.236  10.521  1.00 73.32           C  
ATOM   1616  C   HIS    51     -20.703 -13.827  10.766  1.00 62.09           C  
ATOM   1617  O   HIS    51     -20.801 -13.415   9.603  1.00 61.03           O  
ATOM   1618  N   VAL    52     -21.230 -13.201  11.812  1.00 69.61           N  
ATOM   1619  CA  VAL    52     -22.065 -12.016  11.665  1.00 70.27           C  
ATOM   1620  CB  VAL    52     -23.525 -12.331  12.044  1.00 67.94           C  
ATOM   1621  CG1 VAL    52     -24.048 -13.516  11.256  1.00 63.91           C  
ATOM   1622  CG2 VAL    52     -23.629 -12.617  13.529  1.00 68.74           C  
ATOM   1623  C   VAL    52     -21.559 -10.871  12.551  1.00 73.22           C  
ATOM   1624  O   VAL    52     -20.790 -11.094  13.483  1.00 76.04           O  
ATOM   1625  N   GLN    53     -21.982  -9.646  12.255  1.00 74.46           N  
ATOM   1626  CA  GLN    53     -21.798  -8.534  13.178  1.00 75.33           C  
ATOM   1627  CB  GLN    53     -21.370  -7.303  12.422  1.00 77.79           C  
ATOM   1628  CG  GLN    53     -19.888  -7.222  12.255  1.00 84.78           C  
ATOM   1629  CD  GLN    53     -19.520  -6.296  11.150  1.00 89.93           C  
ATOM   1630  OE1 GLN    53     -18.901  -5.262  11.383  1.00 95.34           O  
ATOM   1631  NE2 GLN    53     -19.918  -6.641   9.926  1.00 90.84           N  
ATOM   1632  C   GLN    53     -23.100  -8.246  13.889  1.00 73.89           C  
ATOM   1633  O   GLN    53     -24.169  -8.667  13.432  1.00 71.87           O  
ATOM   1634  N   LEU    54     -23.025  -7.517  15.000  1.00 73.96           N  
ATOM   1635  CA  LEU    54     -24.246  -7.075  15.664  1.00 71.54           C  
ATOM   1636  CB  LEU    54     -23.954  -6.115  16.806  1.00 71.37           C  
ATOM   1637  CG  LEU    54     -23.720  -6.645  18.210  1.00 72.19           C  
ATOM   1638  CD1 LEU    54     -23.657  -5.431  19.127  1.00 73.28           C  
ATOM   1639  CD2 LEU    54     -24.804  -7.628  18.678  1.00 67.76           C  
ATOM   1640  C   LEU    54     -25.153  -6.381  14.666  1.00 70.96           C  
ATOM   1641  O   LEU    54     -24.707  -5.548  13.849  1.00 71.38           O  
ATOM   1642  N   ASN    55     -26.428  -6.742  14.736  1.00 69.55           N  
ATOM   1643  CA  ASN    55     -27.474  -6.128  13.911  1.00 69.72           C  
ATOM   1644  CB  ASN    55     -27.358  -4.594  13.915  1.00 68.97           C  
ATOM   1645  CG  ASN    55     -27.478  -3.990  15.318  1.00 68.73           C  
ATOM   1646  OD1 ASN    55     -28.078  -4.564  16.239  1.00 67.86           O  
ATOM   1647  ND2 ASN    55     -26.916  -2.809  15.474  1.00 63.22           N  
ATOM   1648  C   ASN    55     -27.554  -6.673  12.476  1.00 68.55           C  
ATOM   1649  O   ASN    55     -28.342  -6.181  11.669  1.00 70.93           O  
ATOM   1650  N   ASP    56     -26.726  -7.665  12.166  1.00 66.57           N  
ATOM   1651  CA  ASP    56     -26.859  -8.418  10.942  1.00 65.55           C  
ATOM   1652  CB  ASP    56     -25.652  -9.322  10.761  1.00 65.62           C  
ATOM   1653  CG  ASP    56     -24.514  -8.651  10.026  1.00 68.09           C  
ATOM   1654  OD1 ASP    56     -24.612  -7.445   9.702  1.00 66.77           O  
ATOM   1655  OD2 ASP    56     -23.516  -9.357   9.761  1.00 67.96           O  
ATOM   1656  C   ASP    56     -28.089  -9.293  11.110  1.00 65.11           C  
ATOM   1657  O   ASP    56     -28.506  -9.552  12.236  1.00 66.56           O  
ATOM   1658  N   TYR    57     -28.674  -9.730  10.000  1.00 63.82           N  
ATOM   1659  CA  TYR    57     -29.793 -10.661  10.019  1.00 60.75           C  
ATOM   1660  CB  TYR    57     -30.909 -10.165   9.111  1.00 60.51           C  
ATOM   1661  CG  TYR    57     -31.478  -8.826   9.488  1.00 60.28           C  
ATOM   1662  CD1 TYR    57     -30.823  -7.665   9.124  1.00 59.46           C  
ATOM   1663  CE1 TYR    57     -31.331  -6.431   9.445  1.00 61.40           C  
ATOM   1664  CZ  TYR    57     -32.522  -6.335  10.141  1.00 63.64           C  
ATOM   1665  OH  TYR    57     -32.970  -5.069  10.441  1.00 64.74           O  
ATOM   1666  CE2 TYR    57     -33.214  -7.481  10.538  1.00 56.59           C  
ATOM   1667  CD2 TYR    57     -32.685  -8.721  10.207  1.00 56.20           C  
ATOM   1668  C   TYR    57     -29.340 -12.004   9.493  1.00 61.12           C  
ATOM   1669  O   TYR    57     -28.496 -12.082   8.592  1.00 62.46           O  
ATOM   1670  N   VAL    58     -29.890 -13.064  10.059  1.00 60.56           N  
ATOM   1671  CA  VAL    58     -29.754 -14.388   9.476  1.00 61.46           C  
ATOM   1672  CB  VAL    58     -29.112 -15.394  10.452  1.00 62.00           C  
ATOM   1673  CG1 VAL    58     -29.223 -16.821   9.915  1.00 62.86           C  
ATOM   1674  CG2 VAL    58     -27.636 -15.015  10.717  1.00 63.40           C  
ATOM   1675  C   VAL    58     -31.146 -14.830   9.040  1.00 61.87           C  
ATOM   1676  O   VAL    58     -32.103 -14.802   9.834  1.00 61.13           O  
ATOM   1677  N   ASP    59     -31.259 -15.175   7.759  1.00 61.42           N  
ATOM   1678  CA  ASP    59     -32.509 -15.634   7.188  1.00 60.73           C  
ATOM   1679  CB  ASP    59     -32.779 -14.965   5.841  1.00 59.72           C  
ATOM   1680  CG  ASP    59     -33.157 -13.529   5.976  1.00 62.55           C  
ATOM   1681  OD1 ASP    59     -33.782 -13.172   6.996  1.00 64.16           O  
ATOM   1682  OD2 ASP    59     -32.827 -12.745   5.059  1.00 62.03           O  
ATOM   1683  C   ASP    59     -32.407 -17.135   7.001  1.00 61.61           C  
ATOM   1684  O   ASP    59     -31.683 -17.625   6.098  1.00 62.81           O  
ATOM   1685  N   ILE    60     -33.113 -17.875   7.851  1.00 60.05           N  
ATOM   1686  CA  ILE    60     -33.134 -19.316   7.706  1.00 58.69           C  
ATOM   1687  CB  ILE    60     -33.207 -20.005   9.061  1.00 58.77           C  
ATOM   1688  CG1 ILE    60     -31.917 -19.708   9.836  1.00 57.57           C  
ATOM   1689  CD1 ILE    60     -31.964 -20.141  11.282  1.00 62.49           C  
ATOM   1690  CG2 ILE    60     -33.386 -21.487   8.896  1.00 51.16           C  
ATOM   1691  C   ILE    60     -34.311 -19.610   6.811  1.00 59.83           C  
ATOM   1692  O   ILE    60     -35.418 -19.114   7.034  1.00 62.33           O  
ATOM   1693  N   ILE    61     -34.053 -20.361   5.753  1.00 59.42           N  
ATOM   1694  CA  ILE    61     -35.051 -20.588   4.715  1.00 57.99           C  
ATOM   1695  CB  ILE    61     -34.537 -20.065   3.359  1.00 58.11           C  
ATOM   1696  CG1 ILE    61     -34.261 -18.561   3.510  1.00 59.93           C  
ATOM   1697  CD1 ILE    61     -34.251 -17.783   2.223  1.00 68.98           C  
ATOM   1698  CG2 ILE    61     -35.531 -20.369   2.238  1.00 54.24           C  
ATOM   1699  C   ILE    61     -35.520 -22.048   4.711  1.00 57.94           C  
ATOM   1700  O   ILE    61     -34.737 -22.976   4.495  1.00 57.11           O  
ATOM   1701  N   CYS    62     -36.799 -22.234   5.020  1.00 57.55           N  
ATOM   1702  CA  CYS    62     -37.363 -23.561   5.162  1.00 57.79           C  
ATOM   1703  CB  CYS    62     -38.765 -23.461   5.742  1.00 58.68           C  
ATOM   1704  SG  CYS    62     -38.799 -22.883   7.422  1.00 66.56           S  
ATOM   1705  C   CYS    62     -37.433 -24.289   3.819  1.00 57.44           C  
ATOM   1706  O   CYS    62     -37.503 -23.648   2.745  1.00 55.57           O  
ATOM   1707  N   PRO    63     -37.446 -25.630   3.867  1.00 56.37           N  
ATOM   1708  CA  PRO    63     -37.635 -26.391   2.631  1.00 56.48           C  
ATOM   1709  CB  PRO    63     -37.788 -27.822   3.122  1.00 55.81           C  
ATOM   1710  CG  PRO    63     -37.139 -27.837   4.468  1.00 55.54           C  
ATOM   1711  CD  PRO    63     -37.321 -26.490   5.058  1.00 54.90           C  
ATOM   1712  C   PRO    63     -38.929 -25.913   1.958  1.00 57.83           C  
ATOM   1713  O   PRO    63     -39.911 -25.648   2.654  1.00 59.36           O  
ATOM   1714  N   HIS    64     -38.914 -25.745   0.638  1.00 58.32           N  
ATOM   1715  CA  HIS    64     -40.073 -25.230  -0.081  1.00 61.05           C  
ATOM   1716  CB  HIS    64     -40.011 -23.704  -0.172  1.00 61.33           C  
ATOM   1717  CG  HIS    64     -41.251 -23.101  -0.744  1.00 66.07           C  
ATOM   1718  ND1 HIS    64     -41.315 -22.614  -2.034  1.00 66.04           N  
ATOM   1719  CE1 HIS    64     -42.541 -22.187  -2.279  1.00 64.89           C  
ATOM   1720  NE2 HIS    64     -43.281 -22.399  -1.205  1.00 65.72           N  
ATOM   1721  CD2 HIS    64     -42.499 -22.973  -0.231  1.00 66.30           C  
ATOM   1722  C   HIS    64     -40.197 -25.864  -1.480  1.00 64.10           C  
ATOM   1723  O   HIS    64     -39.187 -26.138  -2.125  1.00 67.04           O  
ATOM   1724  N   TYR    65     -41.428 -26.104  -1.937  1.00 72.57           N  
ATOM   1725  CA  TYR    65     -41.699 -26.882  -3.156  1.00 76.38           C  
ATOM   1726  CB  TYR    65     -42.080 -28.311  -2.754  1.00 72.47           C  
ATOM   1727  CG  TYR    65     -41.120 -29.016  -1.817  1.00 70.31           C  
ATOM   1728  CD1 TYR    65     -40.185 -29.943  -2.306  1.00 67.92           C  
ATOM   1729  CE1 TYR    65     -39.299 -30.600  -1.441  1.00 63.29           C  
ATOM   1730  CZ  TYR    65     -39.348 -30.339  -0.074  1.00 63.03           C  
ATOM   1731  OH  TYR    65     -38.483 -30.981   0.779  1.00 63.79           O  
ATOM   1732  CE2 TYR    65     -40.263 -29.430   0.441  1.00 59.33           C  
ATOM   1733  CD2 TYR    65     -41.156 -28.783  -0.429  1.00 64.70           C  
ATOM   1734  C   TYR    65     -42.867 -26.320  -3.985  1.00 83.17           C  
ATOM   1735  O   TYR    65     -43.901 -25.969  -3.419  1.00 84.72           O  
ATOM   1736  N   GLU    66     -42.738 -26.257  -5.312  1.00 90.45           N  
ATOM   1737  CA  GLU    66     -43.927 -26.059  -6.179  1.00 98.45           C  
ATOM   1738  CB  GLU    66     -44.130 -24.595  -6.612  1.00102.82           C  
ATOM   1739  CG  GLU    66     -43.040 -23.979  -7.503  1.00111.20           C  
ATOM   1740  CD  GLU    66     -42.169 -22.963  -6.758  1.00114.90           C  
ATOM   1741  OE1 GLU    66     -40.926 -23.075  -6.824  1.00115.44           O  
ATOM   1742  OE2 GLU    66     -42.724 -22.050  -6.102  1.00117.13           O  
ATOM   1743  C   GLU    66     -43.980 -27.002  -7.387  1.00102.18           C  
ATOM   1744  O   GLU    66     -44.502 -28.115  -7.289  1.00104.08           O  
ATOM   1745  N   SER    69     -43.697 -30.660  -8.211  1.00101.20           N  
ATOM   1746  CA  SER    69     -44.454 -31.494  -7.282  1.00 99.05           C  
ATOM   1747  CB  SER    69     -45.901 -31.685  -7.755  1.00102.51           C  
ATOM   1748  OG  SER    69     -46.792 -30.960  -6.923  1.00102.15           O  
ATOM   1749  C   SER    69     -43.814 -32.847  -6.967  1.00 97.17           C  
ATOM   1750  O   SER    69     -43.726 -33.722  -7.819  1.00 97.34           O  
ATOM   1751  N   VAL    70     -43.349 -32.973  -5.724  1.00 93.77           N  
ATOM   1752  CA  VAL    70     -43.077 -34.264  -5.088  1.00 91.09           C  
ATOM   1753  CB  VAL    70     -41.686 -34.279  -4.362  1.00 88.12           C  
ATOM   1754  CG1 VAL    70     -41.781 -33.761  -2.949  1.00 81.91           C  
ATOM   1755  CG2 VAL    70     -40.646 -33.473  -5.150  1.00 88.49           C  
ATOM   1756  C   VAL    70     -44.264 -34.534  -4.133  1.00 89.28           C  
ATOM   1757  O   VAL    70     -45.079 -33.638  -3.896  1.00 88.69           O  
ATOM   1758  N   ALA    71     -44.386 -35.759  -3.618  1.00 88.48           N  
ATOM   1759  CA  ALA    71     -45.512 -36.123  -2.738  1.00 87.33           C  
ATOM   1760  CB  ALA    71     -45.593 -37.634  -2.538  1.00 87.21           C  
ATOM   1761  C   ALA    71     -45.417 -35.405  -1.391  1.00 83.85           C  
ATOM   1762  O   ALA    71     -44.327 -35.003  -0.963  1.00 80.71           O  
ATOM   1763  N   ASP    72     -46.558 -35.250  -0.725  1.00 83.63           N  
ATOM   1764  CA  ASP    72     -46.614 -34.429   0.474  1.00 80.95           C  
ATOM   1765  CB  ASP    72     -48.051 -34.287   0.985  1.00 82.60           C  
ATOM   1766  CG  ASP    72     -48.947 -33.501   0.017  1.00 87.82           C  
ATOM   1767  OD1 ASP    72     -48.434 -32.765  -0.860  1.00 87.73           O  
ATOM   1768  OD2 ASP    72     -50.184 -33.624   0.121  1.00 95.01           O  
ATOM   1769  C   ASP    72     -45.661 -34.957   1.530  1.00 77.55           C  
ATOM   1770  O   ASP    72     -44.869 -34.195   2.083  1.00 76.39           O  
ATOM   1771  N   ALA    73     -45.705 -36.274   1.729  1.00 77.84           N  
ATOM   1772  CA  ALA    73     -44.862 -37.023   2.666  1.00 75.61           C  
ATOM   1773  CB  ALA    73     -45.247 -38.531   2.639  1.00 76.99           C  
ATOM   1774  C   ALA    73     -43.356 -36.865   2.430  1.00 73.95           C  
ATOM   1775  O   ALA    73     -42.561 -37.082   3.347  1.00 73.95           O  
ATOM   1776  N   ALA    74     -42.968 -36.506   1.211  1.00 74.52           N  
ATOM   1777  CA  ALA    74     -41.553 -36.360   0.861  1.00 73.72           C  
ATOM   1778  CB  ALA    74     -41.306 -36.775  -0.591  1.00 75.34           C  
ATOM   1779  C   ALA    74     -41.030 -34.949   1.105  1.00 71.93           C  
ATOM   1780  O   ALA    74     -39.824 -34.717   1.057  1.00 72.75           O  
ATOM   1781  N   MET    75     -41.934 -34.009   1.355  1.00 70.52           N  
ATOM   1782  CA  MET    75     -41.547 -32.625   1.621  1.00 68.82           C  
ATOM   1783  CB  MET    75     -42.743 -31.690   1.429  1.00 68.84           C  
ATOM   1784  CG  MET    75     -43.196 -31.636  -0.008  1.00 72.32           C  
ATOM   1785  SD  MET    75     -44.675 -30.673  -0.173  1.00 75.06           S  
ATOM   1786  CE  MET    75     -45.027 -30.899  -1.910  1.00 77.34           C  
ATOM   1787  C   MET    75     -40.969 -32.503   3.022  1.00 66.12           C  
ATOM   1788  O   MET    75     -41.580 -32.964   3.987  1.00 67.76           O  
ATOM   1789  N   GLU    76     -39.783 -31.904   3.125  1.00 64.15           N  
ATOM   1790  CA  GLU    76     -39.064 -31.797   4.391  1.00 59.73           C  
ATOM   1791  CB  GLU    76     -37.593 -31.439   4.153  1.00 57.36           C  
ATOM   1792  CG  GLU    76     -36.784 -32.590   3.629  1.00 59.39           C  
ATOM   1793  CD  GLU    76     -35.304 -32.277   3.423  1.00 62.61           C  
ATOM   1794  OE1 GLU    76     -34.775 -31.364   4.072  1.00 67.17           O  
ATOM   1795  OE2 GLU    76     -34.657 -32.958   2.596  1.00 68.04           O  
ATOM   1796  C   GLU    76     -39.736 -30.778   5.293  1.00 59.34           C  
ATOM   1797  O   GLU    76     -40.135 -29.705   4.828  1.00 59.93           O  
ATOM   1798  N   GLN    77     -39.882 -31.144   6.572  1.00 59.36           N  
ATOM   1799  CA  GLN    77     -40.472 -30.296   7.619  1.00 57.88           C  
ATOM   1800  CB  GLN    77     -41.919 -30.704   7.882  1.00 57.46           C  
ATOM   1801  CG  GLN    77     -42.835 -30.354   6.717  1.00 58.86           C  
ATOM   1802  CD  GLN    77     -44.317 -30.511   7.033  1.00 59.59           C  
ATOM   1803  OE1 GLN    77     -44.847 -29.870   7.936  1.00 63.94           O  
ATOM   1804  NE2 GLN    77     -44.992 -31.342   6.266  1.00 55.64           N  
ATOM   1805  C   GLN    77     -39.649 -30.348   8.910  1.00 57.23           C  
ATOM   1806  O   GLN    77     -39.163 -31.411   9.298  1.00 60.33           O  
ATOM   1807  N   TYR    78     -39.485 -29.206   9.573  1.00 55.69           N  
ATOM   1808  CA  TYR    78     -38.585 -29.122  10.726  1.00 54.25           C  
ATOM   1809  CB  TYR    78     -37.189 -28.585  10.334  1.00 53.16           C  
ATOM   1810  CG  TYR    78     -36.440 -29.474   9.362  1.00 53.66           C  
ATOM   1811  CD1 TYR    78     -36.418 -29.181   7.994  1.00 54.30           C  
ATOM   1812  CE1 TYR    78     -35.739 -30.006   7.087  1.00 54.63           C  
ATOM   1813  CZ  TYR    78     -35.081 -31.136   7.552  1.00 53.74           C  
ATOM   1814  OH  TYR    78     -34.428 -31.941   6.658  1.00 57.55           O  
ATOM   1815  CE2 TYR    78     -35.082 -31.453   8.907  1.00 50.12           C  
ATOM   1816  CD2 TYR    78     -35.762 -30.617   9.804  1.00 52.20           C  
ATOM   1817  C   TYR    78     -39.156 -28.230  11.797  1.00 54.51           C  
ATOM   1818  O   TYR    78     -39.933 -27.312  11.507  1.00 56.08           O  
ATOM   1819  N   ILE    79     -38.766 -28.514  13.035  1.00 51.82           N  
ATOM   1820  CA  ILE    79     -38.847 -27.546  14.104  1.00 51.12           C  
ATOM   1821  CB  ILE    79     -39.334 -28.221  15.370  1.00 51.00           C  
ATOM   1822  CG1 ILE    79     -40.703 -28.835  15.118  1.00 49.34           C  
ATOM   1823  CD1 ILE    79     -41.115 -29.806  16.168  1.00 50.72           C  
ATOM   1824  CG2 ILE    79     -39.395 -27.223  16.509  1.00 50.32           C  
ATOM   1825  C   ILE    79     -37.424 -27.002  14.286  1.00 51.25           C  
ATOM   1826  O   ILE    79     -36.473 -27.789  14.393  1.00 51.15           O  
ATOM   1827  N   LEU    80     -37.264 -25.678  14.247  1.00 51.43           N  
ATOM   1828  CA  LEU    80     -35.970 -25.052  14.544  1.00 51.30           C  
ATOM   1829  CB  LEU    80     -35.733 -23.773  13.747  1.00 50.95           C  
ATOM   1830  CG  LEU    80     -35.744 -23.937  12.244  1.00 60.64           C  
ATOM   1831  CD1 LEU    80     -35.792 -22.573  11.544  1.00 61.99           C  
ATOM   1832  CD2 LEU    80     -34.546 -24.797  11.786  1.00 63.14           C  
ATOM   1833  C   LEU    80     -35.969 -24.674  16.006  1.00 50.47           C  
ATOM   1834  O   LEU    80     -36.946 -24.102  16.507  1.00 48.99           O  
ATOM   1835  N   TYR    81     -34.853 -24.968  16.666  1.00 49.53           N  
ATOM   1836  CA  TYR    81     -34.639 -24.601  18.040  1.00 49.40           C  
ATOM   1837  CB  TYR    81     -34.361 -25.849  18.868  1.00 49.48           C  
ATOM   1838  CG  TYR    81     -35.456 -26.905  18.856  1.00 47.03           C  
ATOM   1839  CD1 TYR    81     -35.465 -27.922  17.897  1.00 45.23           C  
ATOM   1840  CE1 TYR    81     -36.455 -28.906  17.906  1.00 46.90           C  
ATOM   1841  CZ  TYR    81     -37.454 -28.867  18.884  1.00 47.72           C  
ATOM   1842  OH  TYR    81     -38.450 -29.810  18.909  1.00 46.06           O  
ATOM   1843  CE2 TYR    81     -37.466 -27.866  19.832  1.00 44.80           C  
ATOM   1844  CD2 TYR    81     -36.468 -26.892  19.813  1.00 44.50           C  
ATOM   1845  C   TYR    81     -33.436 -23.681  18.136  1.00 50.84           C  
ATOM   1846  O   TYR    81     -32.490 -23.797  17.359  1.00 50.00           O  
ATOM   1847  N   LEU    82     -33.482 -22.759  19.091  1.00 51.39           N  
ATOM   1848  CA  LEU    82     -32.329 -21.943  19.401  1.00 50.54           C  
ATOM   1849  CB  LEU    82     -32.675 -20.462  19.332  1.00 51.46           C  
ATOM   1850  CG  LEU    82     -31.645 -19.457  19.872  1.00 51.59           C  
ATOM   1851  CD1 LEU    82     -30.399 -19.422  19.001  1.00 47.87           C  
ATOM   1852  CD2 LEU    82     -32.281 -18.073  19.963  1.00 49.07           C  
ATOM   1853  C   LEU    82     -31.879 -22.343  20.803  1.00 53.80           C  
ATOM   1854  O   LEU    82     -32.631 -22.182  21.768  1.00 54.04           O  
ATOM   1855  N   VAL    83     -30.652 -22.864  20.892  1.00 54.38           N  
ATOM   1856  CA  VAL    83     -30.192 -23.633  22.038  1.00 55.15           C  
ATOM   1857  CB  VAL    83     -30.160 -25.178  21.716  1.00 56.46           C  
ATOM   1858  CG1 VAL    83     -31.544 -25.722  21.351  1.00 55.39           C  
ATOM   1859  CG2 VAL    83     -29.123 -25.511  20.636  1.00 51.14           C  
ATOM   1860  C   VAL    83     -28.786 -23.248  22.465  1.00 57.18           C  
ATOM   1861  O   VAL    83     -28.015 -22.688  21.679  1.00 59.96           O  
ATOM   1862  N   GLU    84     -28.447 -23.609  23.698  1.00 58.16           N  
ATOM   1863  CA  GLU    84     -27.095 -23.449  24.241  1.00 59.82           C  
ATOM   1864  CB  GLU    84     -27.160 -23.477  25.766  1.00 61.80           C  
ATOM   1865  CG  GLU    84     -26.808 -22.172  26.402  1.00 70.34           C  
ATOM   1866  CD  GLU    84     -28.000 -21.311  26.688  1.00 76.51           C  
ATOM   1867  OE1 GLU    84     -28.225 -21.041  27.881  1.00 86.83           O  
ATOM   1868  OE2 GLU    84     -28.711 -20.886  25.749  1.00 78.44           O  
ATOM   1869  C   GLU    84     -26.093 -24.502  23.704  1.00 59.28           C  
ATOM   1870  O   GLU    84     -26.508 -25.525  23.141  1.00 56.78           O  
ATOM   1871  N   HIS    85     -24.791 -24.253  23.887  1.00 60.18           N  
ATOM   1872  CA  HIS    85     -23.742 -25.108  23.332  1.00 62.00           C  
ATOM   1873  CB  HIS    85     -22.362 -24.689  23.847  1.00 65.71           C  
ATOM   1874  CG  HIS    85     -21.220 -25.432  23.214  1.00 71.02           C  
ATOM   1875  ND1 HIS    85     -20.571 -24.981  22.082  1.00 75.54           N  
ATOM   1876  CE1 HIS    85     -19.606 -25.827  21.758  1.00 78.42           C  
ATOM   1877  NE2 HIS    85     -19.607 -26.812  22.640  1.00 78.22           N  
ATOM   1878  CD2 HIS    85     -20.598 -26.584  23.567  1.00 74.86           C  
ATOM   1879  C   HIS    85     -23.976 -26.598  23.597  1.00 63.27           C  
ATOM   1880  O   HIS    85     -23.889 -27.416  22.680  1.00 63.02           O  
ATOM   1881  N   GLU    86     -24.288 -26.955  24.838  1.00 65.23           N  
ATOM   1882  CA  GLU    86     -24.501 -28.359  25.162  1.00 67.93           C  
ATOM   1883  CB  GLU    86     -24.722 -28.557  26.653  1.00 71.08           C  
ATOM   1884  CG  GLU    86     -23.952 -29.758  27.155  1.00 83.00           C  
ATOM   1885  CD  GLU    86     -24.657 -30.510  28.268  1.00 92.71           C  
ATOM   1886  OE1 GLU    86     -25.911 -30.519  28.292  1.00 94.13           O  
ATOM   1887  OE2 GLU    86     -23.948 -31.111  29.113  1.00100.40           O  
ATOM   1888  C   GLU    86     -25.607 -29.063  24.346  1.00 66.02           C  
ATOM   1889  O   GLU    86     -25.435 -30.228  23.956  1.00 66.88           O  
ATOM   1890  N   GLU    87     -26.722 -28.377  24.081  1.00 62.99           N  
ATOM   1891  CA  GLU    87     -27.796 -29.011  23.323  1.00 63.50           C  
ATOM   1892  CB  GLU    87     -29.175 -28.323  23.429  1.00 63.04           C  
ATOM   1893  CG  GLU    87     -29.412 -27.243  24.487  1.00 68.38           C  
ATOM   1894  CD  GLU    87     -29.167 -27.664  25.892  1.00 74.69           C  
ATOM   1895  OE1 GLU    87     -29.010 -28.876  26.187  1.00 81.64           O  
ATOM   1896  OE2 GLU    87     -29.126 -26.745  26.719  1.00 79.95           O  
ATOM   1897  C   GLU    87     -27.386 -29.126  21.867  1.00 62.34           C  
ATOM   1898  O   GLU    87     -27.805 -30.059  21.181  1.00 64.45           O  
ATOM   1899  N   TYR    88     -26.550 -28.187  21.423  1.00 63.12           N  
ATOM   1900  CA  TYR    88     -25.912 -28.205  20.104  1.00 61.10           C  
ATOM   1901  CB  TYR    88     -25.154 -26.896  19.903  1.00 59.37           C  
ATOM   1902  CG  TYR    88     -24.260 -26.797  18.695  1.00 57.11           C  
ATOM   1903  CD1 TYR    88     -24.757 -26.339  17.475  1.00 55.05           C  
ATOM   1904  CE1 TYR    88     -23.923 -26.200  16.363  1.00 56.54           C  
ATOM   1905  CZ  TYR    88     -22.569 -26.521  16.470  1.00 59.03           C  
ATOM   1906  OH  TYR    88     -21.755 -26.397  15.374  1.00 59.09           O  
ATOM   1907  CE2 TYR    88     -22.047 -26.968  17.672  1.00 57.27           C  
ATOM   1908  CD2 TYR    88     -22.899 -27.091  18.785  1.00 58.95           C  
ATOM   1909  C   TYR    88     -24.962 -29.388  19.956  1.00 63.46           C  
ATOM   1910  O   TYR    88     -24.987 -30.068  18.935  1.00 63.63           O  
ATOM   1911  N   GLN    89     -24.129 -29.631  20.965  1.00 65.05           N  
ATOM   1912  CA  GLN    89     -23.289 -30.835  20.982  1.00 68.40           C  
ATOM   1913  CB  GLN    89     -22.433 -30.922  22.254  1.00 70.53           C  
ATOM   1914  CG  GLN    89     -21.312 -29.896  22.351  1.00 75.85           C  
ATOM   1915  CD  GLN    89     -20.242 -30.052  21.266  1.00 82.46           C  
ATOM   1916  OE1 GLN    89     -20.487 -29.788  20.078  1.00 81.02           O  
ATOM   1917  NE2 GLN    89     -19.039 -30.461  21.680  1.00 84.77           N  
ATOM   1918  C   GLN    89     -24.117 -32.109  20.830  1.00 68.19           C  
ATOM   1919  O   GLN    89     -23.823 -32.942  19.982  1.00 68.29           O  
ATOM   1920  N   LEU    90     -25.164 -32.247  21.639  1.00 67.73           N  
ATOM   1921  CA  LEU    90     -25.990 -33.437  21.594  1.00 68.47           C  
ATOM   1922  CB  LEU    90     -26.854 -33.542  22.841  1.00 67.62           C  
ATOM   1923  CG  LEU    90     -26.189 -33.669  24.196  1.00 71.02           C  
ATOM   1924  CD1 LEU    90     -27.305 -33.768  25.225  1.00 72.66           C  
ATOM   1925  CD2 LEU    90     -25.252 -34.868  24.238  1.00 67.89           C  
ATOM   1926  C   LEU    90     -26.901 -33.449  20.382  1.00 68.71           C  
ATOM   1927  O   LEU    90     -27.480 -34.485  20.045  1.00 70.32           O  
ATOM   1928  N   CYS    91     -27.041 -32.298  19.736  1.00 68.07           N  
ATOM   1929  CA  CYS    91     -28.023 -32.114  18.667  1.00 67.06           C  
ATOM   1930  CB  CYS    91     -27.667 -32.918  17.423  1.00 67.58           C  
ATOM   1931  SG  CYS    91     -28.387 -32.185  15.936  1.00 69.63           S  
ATOM   1932  C   CYS    91     -29.428 -32.469  19.133  1.00 66.19           C  
ATOM   1933  O   CYS    91     -30.171 -33.173  18.432  1.00 66.09           O  
ATOM   1934  N   GLN    92     -29.782 -31.987  20.325  1.00 64.97           N  
ATOM   1935  CA  GLN    92     -31.077 -32.297  20.923  1.00 63.97           C  
ATOM   1936  CB  GLN    92     -30.985 -33.573  21.748  1.00 64.98           C  
ATOM   1937  CG  GLN    92     -30.941 -34.800  20.877  1.00 69.42           C  
ATOM   1938  CD  GLN    92     -30.910 -36.068  21.655  1.00 74.34           C  
ATOM   1939  OE1 GLN    92     -31.110 -36.082  22.871  1.00 77.65           O  
ATOM   1940  NE2 GLN    92     -30.660 -37.159  20.962  1.00 73.77           N  
ATOM   1941  C   GLN    92     -31.580 -31.154  21.767  1.00 60.67           C  
ATOM   1942  O   GLN    92     -30.831 -30.623  22.558  1.00 63.52           O  
ATOM   1943  N   PRO    93     -32.863 -30.786  21.616  1.00 57.68           N  
ATOM   1944  CA  PRO    93     -33.422 -29.677  22.366  1.00 54.76           C  
ATOM   1945  CB  PRO    93     -34.789 -29.477  21.711  1.00 54.66           C  
ATOM   1946  CG  PRO    93     -35.181 -30.858  21.276  1.00 55.28           C  
ATOM   1947  CD  PRO    93     -33.881 -31.441  20.772  1.00 57.25           C  
ATOM   1948  C   PRO    93     -33.605 -30.090  23.812  1.00 55.78           C  
ATOM   1949  O   PRO    93     -33.749 -31.275  24.103  1.00 55.61           O  
ATOM   1950  N   GLN    94     -33.587 -29.116  24.712  1.00 57.59           N  
ATOM   1951  CA  GLN    94     -33.746 -29.379  26.135  1.00 59.55           C  
ATOM   1952  CB  GLN    94     -32.842 -28.453  26.950  1.00 59.04           C  
ATOM   1953  CG  GLN    94     -32.957 -28.628  28.458  1.00 66.00           C  
ATOM   1954  CD  GLN    94     -32.433 -27.414  29.230  1.00 73.20           C  
ATOM   1955  OE1 GLN    94     -31.541 -27.545  30.064  1.00 75.62           O  
ATOM   1956  NE2 GLN    94     -32.990 -26.227  28.953  1.00 73.53           N  
ATOM   1957  C   GLN    94     -35.229 -29.195  26.512  1.00 60.25           C  
ATOM   1958  O   GLN    94     -35.777 -29.989  27.294  1.00 61.46           O  
ATOM   1959  N   SER    95     -35.879 -28.180  25.933  1.00 56.75           N  
ATOM   1960  CA  SER    95     -37.274 -27.932  26.237  1.00 59.42           C  
ATOM   1961  CB  SER    95     -37.426 -27.257  27.612  1.00 59.78           C  
ATOM   1962  OG  SER    95     -37.322 -25.853  27.508  1.00 58.11           O  
ATOM   1963  C   SER    95     -38.037 -27.125  25.190  1.00 59.95           C  
ATOM   1964  O   SER    95     -37.461 -26.438  24.342  1.00 60.33           O  
ATOM   1965  N   LYS    96     -39.355 -27.206  25.304  1.00 60.01           N  
ATOM   1966  CA  LYS    96     -40.290 -26.413  24.539  1.00 58.91           C  
ATOM   1967  CB  LYS    96     -41.626 -26.516  25.233  1.00 60.61           C  
ATOM   1968  CG  LYS    96     -42.782 -26.032  24.442  1.00 68.37           C  
ATOM   1969  CD  LYS    96     -43.784 -25.347  25.378  1.00 75.00           C  
ATOM   1970  CE  LYS    96     -43.730 -25.909  26.778  1.00 74.45           C  
ATOM   1971  NZ  LYS    96     -44.618 -25.093  27.628  1.00 79.21           N  
ATOM   1972  C   LYS    96     -39.896 -24.940  24.421  1.00 56.09           C  
ATOM   1973  O   LYS    96     -40.043 -24.355  23.365  1.00 56.18           O  
ATOM   1974  N   ASP    97     -39.395 -24.345  25.497  1.00 55.95           N  
ATOM   1975  CA  ASP    97     -38.973 -22.935  25.490  1.00 55.13           C  
ATOM   1976  CB  ASP    97     -38.387 -22.528  26.830  1.00 55.07           C  
ATOM   1977  CG  ASP    97     -39.370 -22.695  27.965  1.00 61.58           C  
ATOM   1978  OD1 ASP    97     -40.576 -22.939  27.713  1.00 63.49           O  
ATOM   1979  OD2 ASP    97     -38.937 -22.581  29.125  1.00 69.18           O  
ATOM   1980  C   ASP    97     -37.964 -22.609  24.416  1.00 53.95           C  
ATOM   1981  O   ASP    97     -37.852 -21.479  24.022  1.00 56.06           O  
ATOM   1982  N   GLN    98     -37.239 -23.598  23.934  1.00 53.79           N  
ATOM   1983  CA  GLN    98     -36.216 -23.355  22.944  1.00 54.00           C  
ATOM   1984  CB  GLN    98     -35.071 -24.352  23.148  1.00 55.66           C  
ATOM   1985  CG  GLN    98     -34.318 -24.166  24.470  1.00 54.03           C  
ATOM   1986  CD  GLN    98     -33.256 -25.216  24.661  1.00 59.65           C  
ATOM   1987  OE1 GLN    98     -33.483 -26.405  24.401  1.00 60.28           O  
ATOM   1988  NE2 GLN    98     -32.075 -24.791  25.105  1.00 61.36           N  
ATOM   1989  C   GLN    98     -36.723 -23.401  21.496  1.00 54.76           C  
ATOM   1990  O   GLN    98     -35.970 -23.060  20.568  1.00 56.93           O  
ATOM   1991  N   VAL    99     -37.969 -23.844  21.286  1.00 52.58           N  
ATOM   1992  CA  VAL    99     -38.594 -23.762  19.965  1.00 50.25           C  
ATOM   1993  CB  VAL    99     -40.076 -24.225  19.984  1.00 50.43           C  
ATOM   1994  CG1 VAL    99     -40.706 -24.043  18.610  1.00 47.21           C  
ATOM   1995  CG2 VAL    99     -40.194 -25.701  20.411  1.00 49.23           C  
ATOM   1996  C   VAL    99     -38.484 -22.330  19.388  1.00 50.18           C  
ATOM   1997  O   VAL    99     -38.962 -21.373  19.984  1.00 52.07           O  
ATOM   1998  N   ARG   100     -37.853 -22.196  18.228  1.00 51.16           N  
ATOM   1999  CA  ARG   100     -37.633 -20.899  17.587  1.00 50.11           C  
ATOM   2000  CB  ARG   100     -36.235 -20.867  16.976  1.00 48.55           C  
ATOM   2001  CG  ARG   100     -35.839 -19.509  16.445  1.00 49.91           C  
ATOM   2002  CD  ARG   100     -35.920 -18.464  17.561  1.00 46.32           C  
ATOM   2003  NE  ARG   100     -35.676 -17.115  17.061  1.00 45.11           N  
ATOM   2004  CZ  ARG   100     -36.629 -16.253  16.719  1.00 45.48           C  
ATOM   2005  NH1 ARG   100     -37.913 -16.587  16.825  1.00 43.32           N  
ATOM   2006  NH2 ARG   100     -36.291 -15.047  16.267  1.00 44.04           N  
ATOM   2007  C   ARG   100     -38.638 -20.601  16.482  1.00 50.90           C  
ATOM   2008  O   ARG   100     -39.062 -19.444  16.295  1.00 51.44           O  
ATOM   2009  N   TRP   101     -38.968 -21.638  15.720  1.00 50.41           N  
ATOM   2010  CA  TRP   101     -39.852 -21.510  14.569  1.00 50.37           C  
ATOM   2011  CB  TRP   101     -39.224 -20.627  13.482  1.00 47.28           C  
ATOM   2012  CG  TRP   101     -40.273 -20.006  12.575  1.00 46.27           C  
ATOM   2013  CD1 TRP   101     -40.521 -20.311  11.254  1.00 43.91           C  
ATOM   2014  NE1 TRP   101     -41.561 -19.550  10.783  1.00 42.25           N  
ATOM   2015  CE2 TRP   101     -42.007 -18.734  11.793  1.00 43.80           C  
ATOM   2016  CD2 TRP   101     -41.222 -19.001  12.938  1.00 41.79           C  
ATOM   2017  CE3 TRP   101     -41.482 -18.290  14.123  1.00 42.59           C  
ATOM   2018  CZ3 TRP   101     -42.506 -17.349  14.130  1.00 43.83           C  
ATOM   2019  CH2 TRP   101     -43.271 -17.105  12.971  1.00 45.72           C  
ATOM   2020  CZ2 TRP   101     -43.040 -17.787  11.798  1.00 45.42           C  
ATOM   2021  C   TRP   101     -40.176 -22.889  14.007  1.00 51.33           C  
ATOM   2022  O   TRP   101     -39.530 -23.867  14.362  1.00 53.74           O  
ATOM   2023  N   GLN   102     -41.186 -22.977  13.155  1.00 53.13           N  
ATOM   2024  CA  GLN   102     -41.510 -24.248  12.529  1.00 56.47           C  
ATOM   2025  CB  GLN   102     -42.823 -24.769  13.050  1.00 58.58           C  
ATOM   2026  CG  GLN   102     -42.719 -25.076  14.531  1.00 66.85           C  
ATOM   2027  CD  GLN   102     -43.742 -26.074  14.997  1.00 73.38           C  
ATOM   2028  OE1 GLN   102     -43.587 -27.286  14.820  1.00 80.09           O  
ATOM   2029  NE2 GLN   102     -44.795 -25.571  15.609  1.00 75.87           N  
ATOM   2030  C   GLN   102     -41.514 -24.181  11.022  1.00 57.45           C  
ATOM   2031  O   GLN   102     -42.105 -23.277  10.454  1.00 57.22           O  
ATOM   2032  N   CYS   103     -40.808 -25.115  10.383  1.00 56.18           N  
ATOM   2033  CA  CYS   103     -40.872 -25.268   8.940  1.00 56.68           C  
ATOM   2034  CB  CYS   103     -39.542 -25.711   8.356  1.00 57.17           C  
ATOM   2035  SG  CYS   103     -38.285 -24.514   8.632  1.00 64.06           S  
ATOM   2036  C   CYS   103     -41.930 -26.288   8.660  1.00 55.99           C  
ATOM   2037  O   CYS   103     -41.637 -27.431   8.275  1.00 56.24           O  
ATOM   2038  N   ASN   104     -43.172 -25.869   8.856  1.00 56.52           N  
ATOM   2039  CA  ASN   104     -44.287 -26.761   8.665  1.00 57.46           C  
ATOM   2040  CB  ASN   104     -45.009 -27.003   9.992  1.00 55.61           C  
ATOM   2041  CG  ASN   104     -45.675 -25.762  10.538  1.00 56.96           C  
ATOM   2042  OD1 ASN   104     -45.472 -24.663  10.051  1.00 59.86           O  
ATOM   2043  ND2 ASN   104     -46.487 -25.941  11.555  1.00 57.18           N  
ATOM   2044  C   ASN   104     -45.217 -26.255   7.573  1.00 60.54           C  
ATOM   2045  O   ASN   104     -46.400 -26.543   7.575  1.00 63.29           O  
ATOM   2046  N   ARG   105     -44.664 -25.509   6.628  1.00 62.17           N  
ATOM   2047  CA  ARG   105     -45.421 -25.062   5.465  1.00 65.71           C  
ATOM   2048  CB  ARG   105     -45.931 -23.631   5.670  1.00 67.60           C  
ATOM   2049  CG  ARG   105     -47.074 -23.602   6.680  1.00 75.21           C  
ATOM   2050  CD  ARG   105     -47.412 -22.219   7.107  1.00 83.04           C  
ATOM   2051  NE  ARG   105     -47.651 -21.397   5.932  1.00 91.36           N  
ATOM   2052  CZ  ARG   105     -47.781 -20.073   5.948  1.00 97.78           C  
ATOM   2053  NH1 ARG   105     -47.985 -19.436   4.800  1.00 98.04           N  
ATOM   2054  NH2 ARG   105     -47.712 -19.387   7.097  1.00 94.61           N  
ATOM   2055  C   ARG   105     -44.589 -25.241   4.194  1.00 65.66           C  
ATOM   2056  O   ARG   105     -44.198 -24.270   3.544  1.00 67.33           O  
ATOM   2057  N   PRO   106     -44.314 -26.506   3.838  1.00 64.89           N  
ATOM   2058  CA  PRO   106     -43.414 -26.796   2.748  1.00 64.10           C  
ATOM   2059  CB  PRO   106     -43.311 -28.313   2.795  1.00 61.91           C  
ATOM   2060  CG  PRO   106     -44.583 -28.753   3.411  1.00 61.26           C  
ATOM   2061  CD  PRO   106     -44.843 -27.744   4.441  1.00 63.43           C  
ATOM   2062  C   PRO   106     -43.945 -26.360   1.392  1.00 66.96           C  
ATOM   2063  O   PRO   106     -43.167 -26.291   0.437  1.00 68.20           O  
ATOM   2064  N   SER   107     -45.241 -26.073   1.271  1.00 68.77           N  
ATOM   2065  CA  SER   107     -45.742 -25.726  -0.077  1.00 70.58           C  
ATOM   2066  CB  SER   107     -46.329 -26.944  -0.815  1.00 70.55           C  
ATOM   2067  OG  SER   107     -47.527 -27.384  -0.225  1.00 69.80           O  
ATOM   2068  C   SER   107     -46.645 -24.493  -0.140  1.00 71.96           C  
ATOM   2069  O   SER   107     -47.411 -24.291  -1.091  1.00 73.54           O  
ATOM   2070  N   ALA   108     -46.505 -23.665   0.884  1.00 72.27           N  
ATOM   2071  CA  ALA   108     -47.066 -22.335   0.930  1.00 73.55           C  
ATOM   2072  CB  ALA   108     -46.320 -21.559   1.979  1.00 73.53           C  
ATOM   2073  C   ALA   108     -46.967 -21.624  -0.432  1.00 76.63           C  
ATOM   2074  O   ALA   108     -45.893 -21.532  -1.033  1.00 75.59           O  
ATOM   2075  N   LYS   109     -48.094 -21.112  -0.917  1.00 81.01           N  
ATOM   2076  CA  LYS   109     -48.118 -20.389  -2.188  1.00 82.67           C  
ATOM   2077  CB  LYS   109     -49.563 -20.159  -2.664  1.00 85.17           C  
ATOM   2082  C   LYS   109     -47.324 -19.076  -2.137  1.00 83.71           C  
ATOM   2083  O   LYS   109     -46.754 -18.673  -3.149  1.00 85.36           O  
ATOM   2084  N   HIS   110     -47.275 -18.434  -0.971  0.50 83.61           N  
ATOM   2086  CA  HIS   110     -46.653 -17.106  -0.834  0.50 85.44           C  
ATOM   2088  CB  HIS   110     -47.170 -16.396   0.429  0.50 86.22           C  
ATOM   2090  CG  HIS   110     -48.625 -16.046   0.382  0.50 86.31           C  
ATOM   2092  ND1 HIS   110     -49.095 -14.788   0.685  0.50 88.73           N  
ATOM   2094  CE1 HIS   110     -50.410 -14.770   0.564  0.50 90.79           C  
ATOM   2096  NE2 HIS   110     -50.812 -15.971   0.190  0.50 87.13           N  
ATOM   2098  CD2 HIS   110     -49.715 -16.788   0.072  0.50 85.88           C  
ATOM   2100  C   HIS   110     -45.108 -17.095  -0.858  0.50 84.28           C  
ATOM   2102  O   HIS   110     -44.493 -16.028  -0.768  0.50 86.17           O  
ATOM   2104  N   GLY   111     -44.491 -18.270  -0.980  1.00 82.38           N  
ATOM   2105  CA  GLY   111     -43.020 -18.387  -1.011  1.00 79.93           C  
ATOM   2106  C   GLY   111     -42.566 -19.306   0.116  1.00 76.67           C  
ATOM   2107  O   GLY   111     -43.411 -19.872   0.818  1.00 77.64           O  
ATOM   2108  N   PRO   112     -41.242 -19.462   0.316  1.00 73.97           N  
ATOM   2109  CA  PRO   112     -40.800 -20.374   1.380  1.00 69.94           C  
ATOM   2110  CB  PRO   112     -39.284 -20.484   1.155  1.00 70.11           C  
ATOM   2111  CG  PRO   112     -39.017 -19.835  -0.179  1.00 71.17           C  
ATOM   2112  CD  PRO   112     -40.100 -18.823  -0.355  1.00 74.32           C  
ATOM   2113  C   PRO   112     -41.055 -19.734   2.728  1.00 68.32           C  
ATOM   2114  O   PRO   112     -41.049 -18.514   2.833  1.00 68.74           O  
ATOM   2115  N   GLU   113     -41.296 -20.554   3.738  1.00 68.03           N  
ATOM   2116  CA  GLU   113     -41.397 -20.072   5.101  1.00 65.88           C  
ATOM   2117  CB  GLU   113     -42.000 -21.158   5.995  1.00 65.23           C  
ATOM   2118  CG  GLU   113     -42.259 -20.757   7.436  1.00 64.92           C  
ATOM   2119  CD  GLU   113     -43.418 -19.811   7.581  1.00 68.45           C  
ATOM   2120  OE1 GLU   113     -43.386 -18.985   8.518  1.00 72.82           O  
ATOM   2121  OE2 GLU   113     -44.362 -19.880   6.763  1.00 72.64           O  
ATOM   2122  C   GLU   113     -39.990 -19.701   5.555  1.00 64.54           C  
ATOM   2123  O   GLU   113     -39.019 -20.358   5.188  1.00 66.12           O  
ATOM   2124  N   LYS   114     -39.881 -18.665   6.371  1.00 64.40           N  
ATOM   2125  CA  LYS   114     -38.593 -18.041   6.646  1.00 64.05           C  
ATOM   2126  CB  LYS   114     -38.414 -16.911   5.629  1.00 65.16           C  
ATOM   2127  CG  LYS   114     -37.179 -16.062   5.742  1.00 70.29           C  
ATOM   2128  CD  LYS   114     -37.256 -14.909   4.722  1.00 73.48           C  
ATOM   2129  CE  LYS   114     -38.129 -13.755   5.235  1.00 79.32           C  
ATOM   2130  NZ  LYS   114     -38.024 -12.564   4.346  1.00 86.89           N  
ATOM   2131  C   LYS   114     -38.510 -17.525   8.099  1.00 61.34           C  
ATOM   2132  O   LYS   114     -39.401 -16.795   8.570  1.00 61.87           O  
ATOM   2133  N   LEU   115     -37.466 -17.942   8.816  1.00 58.06           N  
ATOM   2134  CA  LEU   115     -37.124 -17.352  10.112  1.00 56.46           C  
ATOM   2135  CB  LEU   115     -36.612 -18.423  11.087  1.00 55.24           C  
ATOM   2136  CG  LEU   115     -36.414 -18.079  12.571  1.00 55.58           C  
ATOM   2137  CD1 LEU   115     -35.114 -17.372  12.765  1.00 56.14           C  
ATOM   2138  CD2 LEU   115     -37.571 -17.227  13.152  1.00 51.27           C  
ATOM   2139  C   LEU   115     -36.067 -16.255   9.915  1.00 56.26           C  
ATOM   2140  O   LEU   115     -34.931 -16.558   9.563  1.00 57.13           O  
ATOM   2141  N   SER   116     -36.447 -14.991  10.119  1.00 55.73           N  
ATOM   2142  CA  SER   116     -35.484 -13.866  10.078  1.00 54.72           C  
ATOM   2143  CB  SER   116     -36.058 -12.675   9.318  1.00 53.24           C  
ATOM   2144  OG  SER   116     -36.231 -13.009   7.962  1.00 59.50           O  
ATOM   2145  C   SER   116     -35.078 -13.419  11.482  1.00 53.76           C  
ATOM   2146  O   SER   116     -35.840 -12.760  12.162  1.00 54.96           O  
ATOM   2147  N   GLU   117     -33.873 -13.783  11.888  1.00 53.29           N  
ATOM   2148  CA  GLU   117     -33.348 -13.483  13.202  1.00 55.01           C  
ATOM   2149  CB  GLU   117     -32.501 -14.679  13.692  1.00 54.38           C  
ATOM   2150  CG  GLU   117     -31.960 -14.505  15.075  1.00 53.87           C  
ATOM   2151  CD  GLU   117     -32.976 -14.909  16.118  1.00 59.77           C  
ATOM   2152  OE1 GLU   117     -33.040 -16.118  16.398  1.00 54.27           O  
ATOM   2153  OE2 GLU   117     -33.714 -14.022  16.654  1.00 63.09           O  
ATOM   2154  C   GLU   117     -32.451 -12.254  13.113  1.00 57.04           C  
ATOM   2155  O   GLU   117     -31.441 -12.286  12.407  1.00 61.60           O  
ATOM   2156  N   LYS   118     -32.777 -11.175  13.815  1.00 57.57           N  
ATOM   2157  CA  LYS   118     -31.843 -10.047  13.876  1.00 56.25           C  
ATOM   2158  CB  LYS   118     -32.563  -8.713  13.901  1.00 56.23           C  
ATOM   2159  CG  LYS   118     -31.618  -7.534  13.868  1.00 55.68           C  
ATOM   2160  CD  LYS   118     -32.364  -6.236  14.014  1.00 60.62           C  
ATOM   2161  CE  LYS   118     -31.459  -5.063  13.761  1.00 63.49           C  
ATOM   2162  NZ  LYS   118     -32.307  -3.873  13.602  1.00 66.60           N  
ATOM   2163  C   LYS   118     -30.969 -10.176  15.103  1.00 58.01           C  
ATOM   2164  O   LYS   118     -31.471 -10.341  16.217  1.00 61.22           O  
ATOM   2165  N   PHE   119     -29.660 -10.088  14.909  1.00 57.70           N  
ATOM   2166  CA  PHE   119     -28.732 -10.224  16.011  1.00 57.85           C  
ATOM   2167  CB  PHE   119     -27.428 -10.844  15.494  1.00 58.57           C  
ATOM   2168  CG  PHE   119     -27.559 -12.328  15.221  1.00 58.68           C  
ATOM   2169  CD1 PHE   119     -28.338 -12.791  14.166  1.00 59.09           C  
ATOM   2170  CE1 PHE   119     -28.502 -14.151  13.939  1.00 58.27           C  
ATOM   2171  CZ  PHE   119     -27.888 -15.067  14.769  1.00 58.62           C  
ATOM   2172  CE2 PHE   119     -27.106 -14.622  15.825  1.00 59.67           C  
ATOM   2173  CD2 PHE   119     -26.953 -13.260  16.048  1.00 60.42           C  
ATOM   2174  C   PHE   119     -28.573  -8.927  16.824  1.00 60.49           C  
ATOM   2175  O   PHE   119     -27.512  -8.304  16.846  1.00 62.69           O  
ATOM   2176  N   GLN   120     -29.670  -8.525  17.466  1.00 60.88           N  
ATOM   2177  CA  GLN   120     -29.747  -7.338  18.311  1.00 64.08           C  
ATOM   2178  CB  GLN   120     -31.186  -7.147  18.736  1.00 65.47           C  
ATOM   2179  CG  GLN   120     -32.132  -6.431  17.828  1.00 71.77           C  
ATOM   2180  CD  GLN   120     -33.544  -6.479  18.418  1.00 77.29           C  
ATOM   2181  OE1 GLN   120     -33.995  -7.532  18.888  1.00 75.97           O  
ATOM   2182  NE2 GLN   120     -34.234  -5.334  18.427  1.00 82.70           N  
ATOM   2183  C   GLN   120     -29.014  -7.592  19.618  1.00 66.37           C  
ATOM   2184  O   GLN   120     -28.935  -8.734  20.066  1.00 68.81           O  
ATOM   2185  N   ARG   121     -28.550  -6.534  20.280  1.00 68.12           N  
ATOM   2186  CA  ARG   121     -28.049  -6.671  21.642  1.00 69.56           C  
ATOM   2187  CB  ARG   121     -27.005  -5.591  21.982  1.00 73.03           C  
ATOM   2188  CG  ARG   121     -25.964  -6.019  23.055  1.00 76.86           C  
ATOM   2189  CD  ARG   121     -26.436  -5.615  24.406  1.00 84.36           C  
ATOM   2190  NE  ARG   121     -25.839  -6.289  25.563  1.00 92.25           N  
ATOM   2191  CZ  ARG   121     -26.404  -7.293  26.240  1.00 95.25           C  
ATOM   2192  NH1 ARG   121     -27.569  -7.810  25.850  1.00 91.64           N  
ATOM   2193  NH2 ARG   121     -25.791  -7.798  27.306  1.00 98.78           N  
ATOM   2194  C   ARG   121     -29.187  -6.655  22.657  1.00 70.48           C  
ATOM   2195  O   ARG   121     -29.072  -7.272  23.710  1.00 71.66           O  
ATOM   2196  N   PHE   122     -30.276  -5.954  22.347  1.00 61.20           N  
ATOM   2197  CA  PHE   122     -31.381  -5.819  23.293  1.00 60.75           C  
ATOM   2198  CB  PHE   122     -31.403  -4.418  23.897  1.00 58.60           C  
ATOM   2199  CG  PHE   122     -30.183  -4.059  24.692  1.00 55.90           C  
ATOM   2200  CD1 PHE   122     -29.306  -3.083  24.228  1.00 54.44           C  
ATOM   2201  CE1 PHE   122     -28.172  -2.721  24.978  1.00 54.40           C  
ATOM   2202  CZ  PHE   122     -27.923  -3.334  26.216  1.00 52.99           C  
ATOM   2203  CE2 PHE   122     -28.811  -4.305  26.694  1.00 54.00           C  
ATOM   2204  CD2 PHE   122     -29.937  -4.653  25.933  1.00 54.71           C  
ATOM   2205  C   PHE   122     -32.737  -6.058  22.642  1.00 62.50           C  
ATOM   2206  O   PHE   122     -32.961  -5.561  21.536  1.00 62.87           O  
ATOM   2207  N   THR   123     -33.623  -6.804  23.325  1.00 62.78           N  
ATOM   2208  CA  THR   123     -35.036  -6.962  22.919  1.00 64.29           C  
ATOM   2209  CB  THR   123     -35.596  -8.415  23.030  1.00 64.98           C  
ATOM   2210  OG1 THR   123     -34.571  -9.339  23.418  1.00 68.38           O  
ATOM   2211  CG2 THR   123     -36.347  -8.842  21.760  1.00 66.72           C  
ATOM   2212  C   THR   123     -35.935  -6.295  23.926  1.00 63.38           C  
ATOM   2213  O   THR   123     -35.648  -6.333  25.122  1.00 62.17           O  
ATOM   2214  N   PRO   124     -37.071  -5.759  23.455  1.00 63.85           N  
ATOM   2215  CA  PRO   124     -38.192  -5.496  24.349  1.00 64.11           C  
ATOM   2216  CB  PRO   124     -39.047  -4.519  23.544  1.00 63.16           C  
ATOM   2217  CG  PRO   124     -38.774  -4.886  22.115  1.00 62.79           C  
ATOM   2218  CD  PRO   124     -37.369  -5.378  22.058  1.00 63.83           C  
ATOM   2219  C   PRO   124     -38.989  -6.783  24.635  1.00 65.71           C  
ATOM   2220  O   PRO   124     -39.777  -6.811  25.575  1.00 65.67           O  
ATOM   2221  N   PHE   125     -38.799  -7.834  23.830  1.00 67.48           N  
ATOM   2222  CA  PHE   125     -39.646  -9.025  23.963  1.00 68.12           C  
ATOM   2223  CB  PHE   125     -40.131  -9.572  22.622  1.00 65.98           C  
ATOM   2224  CG  PHE   125     -41.287 -10.510  22.754  1.00 67.79           C  
ATOM   2225  CD1 PHE   125     -41.169 -11.841  22.369  1.00 66.48           C  
ATOM   2226  CE1 PHE   125     -42.241 -12.720  22.495  1.00 65.01           C  
ATOM   2227  CZ  PHE   125     -43.453 -12.281  23.039  1.00 65.56           C  
ATOM   2228  CE2 PHE   125     -43.581 -10.955  23.447  1.00 66.67           C  
ATOM   2229  CD2 PHE   125     -42.500 -10.072  23.297  1.00 68.36           C  
ATOM   2230  C   PHE   125     -39.028 -10.121  24.816  1.00 69.36           C  
ATOM   2231  O   PHE   125     -37.988 -10.675  24.505  1.00 73.04           O  
ATOM   2232  N   THR   126     -39.722 -10.441  25.889  1.00 69.96           N  
ATOM   2233  CA  THR   126     -39.165 -11.208  26.981  1.00 68.85           C  
ATOM   2234  CB  THR   126     -40.046 -10.959  28.226  1.00 68.67           C  
ATOM   2235  OG1 THR   126     -39.214 -10.762  29.367  1.00 75.15           O  
ATOM   2236  CG2 THR   126     -41.043 -12.049  28.459  1.00 65.36           C  
ATOM   2237  C   THR   126     -38.905 -12.693  26.639  1.00 68.68           C  
ATOM   2238  O   THR   126     -38.144 -13.374  27.319  1.00 68.27           O  
ATOM   2239  N   LEU   127     -39.507 -13.159  25.548  1.00 69.14           N  
ATOM   2240  CA  LEU   127     -39.357 -14.539  25.061  1.00 69.56           C  
ATOM   2241  CB  LEU   127     -40.690 -15.040  24.498  1.00 68.06           C  
ATOM   2242  CG  LEU   127     -41.745 -15.722  25.381  1.00 67.52           C  
ATOM   2243  CD1 LEU   127     -41.707 -15.252  26.804  1.00 64.96           C  
ATOM   2244  CD2 LEU   127     -43.142 -15.547  24.789  1.00 67.52           C  
ATOM   2245  C   LEU   127     -38.284 -14.664  23.971  1.00 71.45           C  
ATOM   2246  O   LEU   127     -37.988 -15.766  23.523  1.00 72.49           O  
ATOM   2247  N   GLY   128     -37.725 -13.534  23.536  1.00 70.94           N  
ATOM   2248  CA  GLY   128     -36.696 -13.526  22.509  1.00 71.72           C  
ATOM   2249  C   GLY   128     -35.307 -13.517  23.113  1.00 71.86           C  
ATOM   2250  O   GLY   128     -35.160 -13.397  24.327  1.00 72.73           O  
ATOM   2251  N   LYS   129     -34.288 -13.655  22.265  1.00 71.49           N  
ATOM   2252  CA  LYS   129     -32.902 -13.778  22.712  1.00 70.95           C  
ATOM   2253  CB  LYS   129     -32.228 -14.955  22.001  1.00 71.86           C  
ATOM   2254  CG  LYS   129     -31.407 -15.887  22.907  1.00 76.61           C  
ATOM   2255  CD  LYS   129     -29.935 -15.452  23.062  1.00 77.08           C  
ATOM   2256  CE  LYS   129     -29.113 -16.483  23.848  1.00 74.75           C  
ATOM   2258  C   LYS   129     -32.115 -12.486  22.445  1.00 69.43           C  
ATOM   2259  O   LYS   129     -32.398 -11.740  21.490  1.00 69.19           O  
ATOM   2260  N   GLU   130     -31.133 -12.219  23.295  1.00 66.53           N  
ATOM   2261  CA  GLU   130     -30.216 -11.111  23.069  1.00 63.18           C  
ATOM   2262  CB  GLU   130     -30.119 -10.259  24.310  1.00 60.46           C  
ATOM   2263  CG  GLU   130     -31.446  -9.677  24.676  1.00 58.67           C  
ATOM   2264  CD  GLU   130     -31.343  -8.581  25.707  1.00 64.53           C  
ATOM   2265  OE1 GLU   130     -30.511  -8.684  26.652  1.00 63.02           O  
ATOM   2266  OE2 GLU   130     -32.116  -7.611  25.571  1.00 66.51           O  
ATOM   2267  C   GLU   130     -28.860 -11.652  22.646  1.00 63.11           C  
ATOM   2268  O   GLU   130     -28.440 -12.728  23.084  1.00 65.06           O  
ATOM   2269  N   PHE   131     -28.190 -10.916  21.774  1.00 63.03           N  
ATOM   2270  CA  PHE   131     -26.963 -11.396  21.171  1.00 61.16           C  
ATOM   2271  CB  PHE   131     -27.161 -11.547  19.656  1.00 58.51           C  
ATOM   2272  CG  PHE   131     -28.257 -12.503  19.284  1.00 55.20           C  
ATOM   2273  CD1 PHE   131     -28.003 -13.873  19.198  1.00 51.84           C  
ATOM   2274  CE1 PHE   131     -29.026 -14.768  18.870  1.00 53.42           C  
ATOM   2275  CZ  PHE   131     -30.332 -14.290  18.634  1.00 51.71           C  
ATOM   2276  CE2 PHE   131     -30.592 -12.923  18.741  1.00 53.28           C  
ATOM   2277  CD2 PHE   131     -29.559 -12.040  19.058  1.00 53.90           C  
ATOM   2278  C   PHE   131     -25.827 -10.437  21.480  1.00 63.92           C  
ATOM   2279  O   PHE   131     -25.998  -9.235  21.371  1.00 65.92           O  
ATOM   2280  N   LYS   132     -24.670 -10.970  21.860  1.00 65.44           N  
ATOM   2281  CA  LYS   132     -23.542 -10.152  22.310  1.00 68.20           C  
ATOM   2282  CB  LYS   132     -23.222 -10.464  23.772  1.00 68.50           C  
ATOM   2283  CG  LYS   132     -24.290 -10.012  24.726  1.00 73.51           C  
ATOM   2284  CD  LYS   132     -24.607 -11.080  25.752  1.00 80.61           C  
ATOM   2285  CE  LYS   132     -23.876 -10.832  27.070  1.00 86.59           C  
ATOM   2286  NZ  LYS   132     -24.433 -11.694  28.161  1.00 88.30           N  
ATOM   2287  C   LYS   132     -22.309 -10.378  21.457  1.00 68.97           C  
ATOM   2288  O   LYS   132     -22.055 -11.497  21.017  1.00 68.20           O  
ATOM   2289  N   GLU   133     -21.544  -9.311  21.234  1.00 72.55           N  
ATOM   2290  CA  GLU   133     -20.260  -9.392  20.521  1.00 74.52           C  
ATOM   2291  CB  GLU   133     -19.611  -8.009  20.415  1.00 76.37           C  
ATOM   2292  CG  GLU   133     -20.269  -7.123  19.363  1.00 81.52           C  
ATOM   2293  CD  GLU   133     -19.519  -5.821  19.099  1.00 86.20           C  
ATOM   2294  OE1 GLU   133     -18.317  -5.875  18.747  1.00 96.41           O  
ATOM   2295  OE2 GLU   133     -20.134  -4.734  19.224  1.00 92.30           O  
ATOM   2296  C   GLU   133     -19.304 -10.367  21.191  1.00 72.05           C  
ATOM   2297  O   GLU   133     -19.186 -10.376  22.407  1.00 72.26           O  
ATOM   2298  N   GLY   134     -18.645 -11.199  20.390  1.00 70.84           N  
ATOM   2299  CA  GLY   134     -17.705 -12.198  20.893  1.00 69.51           C  
ATOM   2300  C   GLY   134     -18.303 -13.537  21.292  1.00 68.24           C  
ATOM   2301  O   GLY   134     -17.573 -14.451  21.639  1.00 68.55           O  
ATOM   2302  N   HIS   135     -19.626 -13.659  21.257  1.00 66.41           N  
ATOM   2303  CA  HIS   135     -20.292 -14.907  21.621  1.00 65.15           C  
ATOM   2304  CB  HIS   135     -21.487 -14.628  22.535  1.00 65.77           C  
ATOM   2305  CG  HIS   135     -21.103 -14.116  23.884  1.00 71.66           C  
ATOM   2306  ND1 HIS   135     -20.438 -12.919  24.066  1.00 75.73           N  
ATOM   2307  CE1 HIS   135     -20.231 -12.724  25.357  1.00 76.62           C  
ATOM   2308  NE2 HIS   135     -20.746 -13.745  26.018  1.00 77.98           N  
ATOM   2309  CD2 HIS   135     -21.296 -14.632  25.120  1.00 73.15           C  
ATOM   2310  C   HIS   135     -20.757 -15.690  20.396  1.00 62.81           C  
ATOM   2311  O   HIS   135     -20.812 -15.161  19.280  1.00 63.13           O  
ATOM   2312  N   SER   136     -21.099 -16.953  20.621  1.00 60.44           N  
ATOM   2313  CA  SER   136     -21.619 -17.814  19.576  1.00 58.65           C  
ATOM   2314  CB  SER   136     -20.678 -18.997  19.352  1.00 59.69           C  
ATOM   2315  OG  SER   136     -19.527 -18.622  18.596  1.00 61.55           O  
ATOM   2316  C   SER   136     -23.020 -18.292  19.955  1.00 57.92           C  
ATOM   2317  O   SER   136     -23.352 -18.401  21.137  1.00 56.83           O  
ATOM   2318  N   TYR   137     -23.854 -18.552  18.954  1.00 57.02           N  
ATOM   2319  CA  TYR   137     -25.235 -18.979  19.198  1.00 56.00           C  
ATOM   2320  CB  TYR   137     -26.194 -17.809  18.951  1.00 56.33           C  
ATOM   2321  CG  TYR   137     -25.840 -16.674  19.876  1.00 58.56           C  
ATOM   2322  CD1 TYR   137     -24.865 -15.726  19.518  1.00 58.33           C  
ATOM   2323  CE1 TYR   137     -24.493 -14.719  20.391  1.00 61.81           C  
ATOM   2324  CZ  TYR   137     -25.087 -14.654  21.654  1.00 63.16           C  
ATOM   2325  OH  TYR   137     -24.739 -13.657  22.546  1.00 63.56           O  
ATOM   2326  CE2 TYR   137     -26.041 -15.596  22.032  1.00 60.91           C  
ATOM   2327  CD2 TYR   137     -26.401 -16.602  21.151  1.00 57.19           C  
ATOM   2328  C   TYR   137     -25.497 -20.190  18.337  1.00 54.88           C  
ATOM   2329  O   TYR   137     -24.769 -20.423  17.387  1.00 57.89           O  
ATOM   2330  N   TYR   138     -26.479 -21.000  18.693  1.00 54.02           N  
ATOM   2331  CA  TYR   138     -26.600 -22.323  18.077  1.00 53.58           C  
ATOM   2332  CB  TYR   138     -26.047 -23.415  18.997  1.00 53.48           C  
ATOM   2333  CG  TYR   138     -24.676 -23.098  19.544  1.00 56.27           C  
ATOM   2334  CD1 TYR   138     -24.530 -22.469  20.779  1.00 56.27           C  
ATOM   2335  CE1 TYR   138     -23.286 -22.160  21.278  1.00 54.11           C  
ATOM   2336  CZ  TYR   138     -22.169 -22.470  20.546  1.00 56.08           C  
ATOM   2337  OH  TYR   138     -20.928 -22.166  21.051  1.00 61.04           O  
ATOM   2338  CE2 TYR   138     -22.279 -23.090  19.317  1.00 56.79           C  
ATOM   2339  CD2 TYR   138     -23.529 -23.396  18.819  1.00 55.12           C  
ATOM   2340  C   TYR   138     -28.026 -22.648  17.764  1.00 53.46           C  
ATOM   2341  O   TYR   138     -28.903 -22.512  18.643  1.00 52.33           O  
ATOM   2342  N   TYR   139     -28.246 -23.076  16.516  1.00 52.60           N  
ATOM   2343  CA  TYR   139     -29.530 -23.587  16.079  1.00 51.05           C  
ATOM   2344  CB  TYR   139     -29.997 -22.871  14.817  1.00 50.69           C  
ATOM   2345  CG  TYR   139     -30.236 -21.390  14.980  1.00 53.13           C  
ATOM   2346  CD1 TYR   139     -29.183 -20.481  14.864  1.00 54.96           C  
ATOM   2347  CE1 TYR   139     -29.386 -19.107  14.988  1.00 53.90           C  
ATOM   2348  CZ  TYR   139     -30.658 -18.625  15.251  1.00 56.28           C  
ATOM   2349  OH  TYR   139     -30.846 -17.257  15.382  1.00 53.37           O  
ATOM   2350  CE2 TYR   139     -31.732 -19.519  15.384  1.00 54.77           C  
ATOM   2351  CD2 TYR   139     -31.515 -20.890  15.239  1.00 52.78           C  
ATOM   2352  C   TYR   139     -29.422 -25.074  15.798  1.00 52.04           C  
ATOM   2353  O   TYR   139     -28.415 -25.551  15.236  1.00 52.43           O  
ATOM   2354  N   ILE   140     -30.473 -25.802  16.170  1.00 51.19           N  
ATOM   2355  CA  ILE   140     -30.638 -27.207  15.747  1.00 52.22           C  
ATOM   2356  CB  ILE   140     -30.321 -28.223  16.894  1.00 52.57           C  
ATOM   2357  CG1 ILE   140     -31.370 -28.115  18.016  1.00 50.46           C  
ATOM   2358  CD1 ILE   140     -31.233 -29.136  19.121  1.00 50.31           C  
ATOM   2359  CG2 ILE   140     -28.886 -28.042  17.403  1.00 49.16           C  
ATOM   2360  C   ILE   140     -32.072 -27.438  15.228  1.00 53.15           C  
ATOM   2361  O   ILE   140     -32.980 -26.626  15.473  1.00 54.39           O  
ATOM   2362  N   SER   141     -32.288 -28.544  14.521  1.00 51.34           N  
ATOM   2363  CA  SER   141     -33.649 -28.880  14.134  1.00 49.78           C  
ATOM   2364  CB  SER   141     -33.873 -28.602  12.657  1.00 47.58           C  
ATOM   2365  OG  SER   141     -33.020 -29.391  11.875  1.00 52.50           O  
ATOM   2366  C   SER   141     -34.015 -30.322  14.472  1.00 49.85           C  
ATOM   2367  O   SER   141     -33.152 -31.160  14.743  1.00 51.45           O  
ATOM   2368  N   LYS   142     -35.304 -30.609  14.475  1.00 48.16           N  
ATOM   2369  CA  LYS   142     -35.737 -31.993  14.412  1.00 47.37           C  
ATOM   2370  CB  LYS   142     -36.346 -32.422  15.743  1.00 47.41           C  
ATOM   2371  CG  LYS   142     -35.316 -32.537  16.860  1.00 47.19           C  
ATOM   2372  CD  LYS   142     -34.342 -33.648  16.548  1.00 43.53           C  
ATOM   2373  CE  LYS   142     -33.274 -33.717  17.562  1.00 47.73           C  
ATOM   2374  NZ  LYS   142     -32.273 -34.713  17.167  1.00 48.82           N  
ATOM   2375  C   LYS   142     -36.728 -32.125  13.276  1.00 47.80           C  
ATOM   2376  O   LYS   142     -37.497 -31.202  13.034  1.00 48.97           O  
ATOM   2377  N   PRO   143     -36.738 -33.274  12.577  1.00 48.61           N  
ATOM   2378  CA  PRO   143     -37.716 -33.399  11.502  1.00 47.89           C  
ATOM   2379  CB  PRO   143     -37.321 -34.714  10.821  1.00 49.14           C  
ATOM   2380  CG  PRO   143     -36.032 -35.122  11.405  1.00 50.27           C  
ATOM   2381  CD  PRO   143     -35.966 -34.513  12.758  1.00 48.34           C  
ATOM   2382  C   PRO   143     -39.127 -33.556  12.100  1.00 48.96           C  
ATOM   2383  O   PRO   143     -39.270 -34.143  13.179  1.00 47.48           O  
ATOM   2384  N   ILE   144     -40.156 -33.040  11.423  1.00 48.74           N  
ATOM   2385  CA  ILE   144     -41.517 -33.289  11.867  1.00 46.74           C  
ATOM   2386  CB  ILE   144     -42.472 -32.127  11.522  1.00 45.78           C  
ATOM   2387  CG1 ILE   144     -41.951 -30.828  12.131  1.00 44.71           C  
ATOM   2388  CD1 ILE   144     -42.820 -29.613  11.765  1.00 46.74           C  
ATOM   2389  CG2 ILE   144     -43.862 -32.381  12.092  1.00 37.44           C  
ATOM   2390  C   ILE   144     -42.018 -34.634  11.319  1.00 49.22           C  
ATOM   2391  O   ILE   144     -42.501 -34.723  10.175  1.00 49.54           O  
ATOM   2392  N   HIS   145     -41.901 -35.668  12.157  1.00 48.28           N  
ATOM   2393  CA  HIS   145     -42.348 -37.042  11.841  1.00 50.71           C  
ATOM   2394  CB  HIS   145     -43.857 -37.150  11.576  1.00 48.39           C  
ATOM   2395  CG  HIS   145     -44.717 -36.301  12.464  1.00 51.57           C  
ATOM   2396  ND1 HIS   145     -44.745 -36.432  13.836  1.00 50.86           N  
ATOM   2397  CE1 HIS   145     -45.610 -35.574  14.341  1.00 43.42           C  
ATOM   2398  NE2 HIS   145     -46.159 -34.904  13.345  1.00 46.64           N  
ATOM   2399  CD2 HIS   145     -45.631 -35.349  12.162  1.00 50.88           C  
ATOM   2400  C   HIS   145     -41.646 -37.628  10.636  1.00 52.43           C  
ATOM   2401  O   HIS   145     -42.296 -38.244   9.797  1.00 54.54           O  
ATOM   2402  N   GLN   146     -40.336 -37.442  10.536  1.00 52.92           N  
ATOM   2403  CA  GLN   146     -39.592 -37.881   9.349  1.00 55.41           C  
ATOM   2404  CB  GLN   146     -39.410 -36.722   8.359  1.00 53.53           C  
ATOM   2405  CG  GLN   146     -40.630 -36.348   7.574  1.00 55.08           C  
ATOM   2406  CD  GLN   146     -40.487 -35.032   6.825  1.00 56.54           C  
ATOM   2407  OE1 GLN   146     -39.637 -34.174   7.132  1.00 58.07           O  
ATOM   2408  NE2 GLN   146     -41.331 -34.862   5.839  1.00 57.67           N  
ATOM   2409  C   GLN   146     -38.220 -38.398   9.751  1.00 55.25           C  
ATOM   2410  O   GLN   146     -37.792 -38.164  10.873  1.00 55.18           O  
ATOM   2411  N   HIS   147     -37.550 -39.080   8.823  1.00 56.32           N  
ATOM   2412  CA  HIS   147     -36.165 -39.498   8.982  1.00 59.99           C  
ATOM   2413  CB  HIS   147     -35.621 -40.136   7.690  1.00 60.94           C  
ATOM   2414  CG  HIS   147     -36.204 -41.471   7.365  1.00 65.97           C  
ATOM   2415  ND1 HIS   147     -36.970 -42.195   8.253  1.00 72.70           N  
ATOM   2416  CE1 HIS   147     -37.334 -43.338   7.694  1.00 75.02           C  
ATOM   2417  NE2 HIS   147     -36.824 -43.385   6.475  1.00 74.43           N  
ATOM   2418  CD2 HIS   147     -36.103 -42.235   6.249  1.00 74.39           C  
ATOM   2419  C   HIS   147     -35.246 -38.334   9.381  1.00 59.32           C  
ATOM   2420  O   HIS   147     -35.282 -37.252   8.774  1.00 58.68           O  
ATOM   2421  N   GLU   148     -34.464 -38.563  10.436  1.00 60.00           N  
ATOM   2422  CA  GLU   148     -33.312 -37.729  10.771  1.00 60.66           C  
ATOM   2423  CB  GLU   148     -33.266 -37.478  12.272  1.00 57.72           C  
ATOM   2424  CG  GLU   148     -32.379 -36.290  12.637  1.00 60.69           C  
ATOM   2425  CD  GLU   148     -32.251 -36.078  14.125  1.00 60.94           C  
ATOM   2426  OE1 GLU   148     -32.855 -36.869  14.889  1.00 66.02           O  
ATOM   2427  OE2 GLU   148     -31.542 -35.131  14.528  1.00 56.46           O  
ATOM   2428  C   GLU   148     -32.038 -38.457  10.308  1.00 63.17           C  
ATOM   2429  O   GLU   148     -31.486 -39.293  11.023  1.00 65.37           O  
ATOM   2430  N   ASP   149     -31.601 -38.179   9.093  1.00 64.91           N  
ATOM   2431  CA  ASP   149     -30.511 -38.938   8.483  1.00 69.10           C  
ATOM   2432  CB  ASP   149     -30.521 -38.711   6.977  1.00 71.16           C  
ATOM   2433  CG  ASP   149     -31.526 -39.594   6.254  1.00 77.97           C  
ATOM   2434  OD1 ASP   149     -32.290 -40.349   6.911  1.00 81.56           O  
ATOM   2435  OD2 ASP   149     -31.535 -39.541   5.005  1.00 83.32           O  
ATOM   2436  C   ASP   149     -29.162 -38.512   9.026  1.00 69.28           C  
ATOM   2437  O   ASP   149     -28.202 -39.270   9.020  1.00 72.00           O  
ATOM   2438  N   ARG   150     -29.136 -37.285   9.519  1.00 68.22           N  
ATOM   2439  CA  ARG   150     -27.950 -36.510   9.775  1.00 68.79           C  
ATOM   2440  CB  ARG   150     -27.475 -35.918   8.451  1.00 69.51           C  
ATOM   2441  CG  ARG   150     -26.577 -34.704   8.486  1.00 70.21           C  
ATOM   2442  CD  ARG   150     -26.370 -34.182   7.042  1.00 72.26           C  
ATOM   2443  NE  ARG   150     -25.942 -35.232   6.111  1.00 73.68           N  
ATOM   2447  C   ARG   150     -28.481 -35.431  10.690  1.00 66.74           C  
ATOM   2448  O   ARG   150     -29.646 -35.030  10.583  1.00 65.37           O  
ATOM   2449  N   CYS   151     -27.648 -34.988  11.617  1.00 67.67           N  
ATOM   2450  CA  CYS   151     -28.016 -33.908  12.512  1.00 64.82           C  
ATOM   2451  CB  CYS   151     -27.158 -33.980  13.774  1.00 65.20           C  
ATOM   2452  SG  CYS   151     -26.876 -32.371  14.535  1.00 71.95           S  
ATOM   2453  C   CYS   151     -27.840 -32.566  11.782  1.00 62.66           C  
ATOM   2454  O   CYS   151     -26.786 -32.310  11.183  1.00 63.69           O  
ATOM   2455  N   LEU   152     -28.863 -31.719  11.819  1.00 57.45           N  
ATOM   2456  CA  LEU   152     -28.754 -30.404  11.198  1.00 55.46           C  
ATOM   2457  CB  LEU   152     -29.965 -30.112  10.314  1.00 53.30           C  
ATOM   2458  CG  LEU   152     -30.230 -31.058   9.136  1.00 57.13           C  
ATOM   2459  CD1 LEU   152     -31.555 -30.734   8.480  1.00 54.70           C  
ATOM   2460  CD2 LEU   152     -29.124 -31.036   8.088  1.00 55.89           C  
ATOM   2461  C   LEU   152     -28.583 -29.329  12.283  1.00 54.42           C  
ATOM   2462  O   LEU   152     -29.484 -29.115  13.102  1.00 55.22           O  
ATOM   2463  N   ARG   153     -27.428 -28.663  12.295  1.00 52.31           N  
ATOM   2464  CA  ARG   153     -27.144 -27.612  13.278  1.00 51.68           C  
ATOM   2465  CB  ARG   153     -26.373 -28.172  14.477  1.00 52.51           C  
ATOM   2466  CG  ARG   153     -25.083 -28.892  14.125  1.00 50.80           C  
ATOM   2467  CD  ARG   153     -24.542 -29.622  15.333  1.00 53.69           C  
ATOM   2468  NE  ARG   153     -23.105 -29.850  15.200  1.00 63.01           N  
ATOM   2469  CZ  ARG   153     -22.323 -30.400  16.126  1.00 64.47           C  
ATOM   2470  NH1 ARG   153     -21.023 -30.546  15.886  1.00 68.07           N  
ATOM   2471  NH2 ARG   153     -22.829 -30.798  17.284  1.00 63.45           N  
ATOM   2472  C   ARG   153     -26.386 -26.451  12.648  1.00 52.21           C  
ATOM   2473  O   ARG   153     -25.879 -26.578  11.547  1.00 53.85           O  
ATOM   2474  N   LEU   154     -26.319 -25.315  13.336  1.00 51.57           N  
ATOM   2475  CA  LEU   154     -25.680 -24.130  12.766  1.00 52.35           C  
ATOM   2476  CB  LEU   154     -26.721 -23.231  12.090  1.00 52.38           C  
ATOM   2477  CG  LEU   154     -26.467 -22.286  10.901  1.00 52.33           C  
ATOM   2478  CD1 LEU   154     -27.189 -20.956  11.106  1.00 47.55           C  
ATOM   2479  CD2 LEU   154     -25.026 -22.063  10.579  1.00 48.79           C  
ATOM   2480  C   LEU   154     -25.072 -23.360  13.896  1.00 52.80           C  
ATOM   2481  O   LEU   154     -25.697 -23.188  14.942  1.00 53.27           O  
ATOM   2482  N   LYS   155     -23.857 -22.884  13.695  1.00 54.03           N  
ATOM   2483  CA  LYS   155     -23.210 -22.072  14.698  1.00 53.75           C  
ATOM   2484  CB  LYS   155     -21.808 -22.611  14.979  1.00 55.85           C  
ATOM   2485  CG  LYS   155     -20.962 -21.753  15.901  1.00 57.65           C  
ATOM   2486  CD  LYS   155     -19.797 -22.552  16.432  1.00 58.41           C  
ATOM   2487  CE  LYS   155     -19.025 -21.762  17.482  1.00 61.53           C  
ATOM   2488  NZ  LYS   155     -17.729 -22.434  17.833  1.00 61.73           N  
ATOM   2489  C   LYS   155     -23.165 -20.676  14.117  1.00 53.84           C  
ATOM   2490  O   LYS   155     -22.699 -20.499  12.988  1.00 55.18           O  
ATOM   2491  N   VAL   156     -23.674 -19.700  14.862  1.00 52.45           N  
ATOM   2492  CA  VAL   156     -23.556 -18.300  14.472  1.00 54.93           C  
ATOM   2493  CB  VAL   156     -24.930 -17.581  14.360  1.00 54.69           C  
ATOM   2494  CG1 VAL   156     -24.741 -16.232  13.689  1.00 56.14           C  
ATOM   2495  CG2 VAL   156     -25.951 -18.416  13.576  1.00 49.56           C  
ATOM   2496  C   VAL   156     -22.632 -17.561  15.461  1.00 58.78           C  
ATOM   2497  O   VAL   156     -22.924 -17.498  16.665  1.00 60.84           O  
ATOM   2498  N   THR   157     -21.513 -17.033  14.962  1.00 58.75           N  
ATOM   2499  CA  THR   157     -20.559 -16.320  15.798  1.00 60.81           C  
ATOM   2500  CB  THR   157     -19.108 -16.854  15.583  1.00 62.18           C  
ATOM   2501  OG1 THR   157     -19.027 -18.220  16.000  1.00 58.31           O  
ATOM   2502  CG2 THR   157     -18.095 -16.036  16.379  1.00 62.08           C  
ATOM   2503  C   THR   157     -20.625 -14.811  15.527  1.00 63.37           C  
ATOM   2504  O   THR   157     -20.504 -14.370  14.388  1.00 63.80           O  
ATOM   2505  N   VAL   158     -20.828 -14.022  16.576  1.00 66.77           N  
ATOM   2506  CA  VAL   158     -20.822 -12.551  16.450  1.00 70.21           C  
ATOM   2507  CB  VAL   158     -21.831 -11.874  17.422  1.00 69.55           C  
ATOM   2508  CG1 VAL   158     -21.914 -10.371  17.168  1.00 69.21           C  
ATOM   2509  CG2 VAL   158     -23.219 -12.517  17.312  1.00 67.10           C  
ATOM   2510  C   VAL   158     -19.409 -11.981  16.672  1.00 73.89           C  
ATOM   2511  O   VAL   158     -18.845 -12.102  17.757  1.00 75.32           O  
ATOM   2512  N   SER   159     -18.835 -11.372  15.644  1.00 77.42           N  
ATOM   2513  CA  SER   159     -17.496 -10.820  15.775  1.00 83.01           C  
ATOM   2514  CB  SER   159     -16.788 -10.776  14.420  1.00 85.68           C  
ATOM   2515  OG  SER   159     -17.666 -10.308  13.413  1.00 90.57           O  
ATOM   2516  C   SER   159     -17.541  -9.437  16.394  1.00 84.74           C  
ATOM   2517  O   SER   159     -18.626  -8.866  16.577  1.00 83.29           O  
ATOM   2518  N   GLY   160     -16.354  -8.920  16.723  1.00 87.89           N  
ATOM   2519  CA  GLY   160     -16.183  -7.557  17.229  1.00 90.83           C  
ATOM   2520  C   GLY   160     -15.287  -7.479  18.454  1.00 93.62           C  
ATOM   2521  O   GLY   160     -15.753  -7.589  19.593  1.00 92.80           O  
END
