
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  129 (  967),  selected  129 , name 1cuo_A
# Molecule2: number of CA atoms  130 ( 1084),  selected  130 , name T0390.pdb
# PARAMETERS: 1cuo_A.T0390.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      A      29          4.756
LGA    S     2_A      D      30          0.928
LGA    C     3_A      -       -           -
LGA    E     4_A      R      31          1.576
LGA    T     5_A      H      32          1.764
LGA    T     6_A      T      33          1.683
LGA    V     7_A      V      34          1.420
LGA    T     8_A      F      35          1.377
LGA    S     9_A      W      36          3.324
LGA    G    10_A      N      37          3.962
LGA    D    11_A      -       -           -
LGA    T    12_A      -       -           -
LGA    M    13_A      S      38          2.661
LGA    T    14_A      S      39          5.074
LGA    Y    15_A      N      40          4.397
LGA    S    16_A      P      41           #
LGA    T    17_A      K      42          4.081
LGA    -       -      F      43           -
LGA    -       -      R      44           -
LGA    -       -      N      45           -
LGA    -       -      E      46           -
LGA    -       -      D      47           -
LGA    R    18_A      Y      48          2.257
LGA    S    19_A      T      49          2.051
LGA    I    20_A      I      50          1.789
LGA    S    21_A      H      51          1.441
LGA    V    22_A      V      52          1.333
LGA    P    23_A      Q      53          1.188
LGA    A    24_A      L      54          2.928
LGA    S    25_A      -       -           -
LGA    C    26_A      -       -           -
LGA    A    27_A      N      55          2.921
LGA    E    28_A      -       -           -
LGA    F    29_A      D      56          3.594
LGA    T    30_A      Y      57          2.784
LGA    V    31_A      V      58          2.656
LGA    N    32_A      D      59          2.354
LGA    F    33_A      I      60          2.813
LGA    E    34_A      I      61          2.646
LGA    H    35_A      C      62          3.422
LGA    K    36_A      P      63          4.173
LGA    G    37_A      H      64          5.010
LGA    H    38_A      Y      65          4.336
LGA    -       -      E      66           -
LGA    -       -      S      69           -
LGA    -       -      V      70           -
LGA    -       -      A      71           -
LGA    -       -      D      72           -
LGA    -       -      A      73           -
LGA    M    39_A      A      74          3.361
LGA    P    40_A      M      75          3.725
LGA    K    41_A      -       -           -
LGA    T    42_A      -       -           -
LGA    G    43_A      -       -           -
LGA    M    44_A      E      76          2.653
LGA    G    45_A      Q      77          0.602
LGA    H    46_A      Y      78          2.130
LGA    N    47_A      I      79          4.124
LGA    W    48_A      L      80          3.560
LGA    V    49_A      Y      81          2.890
LGA    L    50_A      L      82          2.649
LGA    A    51_A      V      83          2.335
LGA    K    52_A      E      84          2.567
LGA    S    53_A      H      85          1.460
LGA    A    54_A      E      86          2.157
LGA    D    55_A      E      87          3.576
LGA    V    56_A      Y      88          3.282
LGA    -       -      Q      89           -
LGA    G    57_A      L      90          4.043
LGA    D    58_A      C      91           -
LGA    V    59_A      Q      92           #
LGA    A    60_A      P      93          1.573
LGA    K    61_A      Q      94          4.687
LGA    E    62_A      S      95          3.473
LGA    G    63_A      -       -           -
LGA    A    64_A      -       -           -
LGA    H    65_A      -       -           -
LGA    A    66_A      -       -           -
LGA    G    67_A      -       -           -
LGA    A    68_A      -       -           -
LGA    D    69_A      -       -           -
LGA    N    70_A      -       -           -
LGA    N    71_A      -       -           -
LGA    F    72_A      -       -           -
LGA    V    73_A      -       -           -
LGA    T    74_A      K      96          0.555
LGA    P    75_A      D      97          4.048
LGA    G    76_A      -       -           -
LGA    D    77_A      -       -           -
LGA    K    78_A      -       -           -
LGA    R    79_A      -       -           -
LGA    V    80_A      Q      98          3.739
LGA    I    81_A      V      99           -
LGA    A    82_A      -       -           -
LGA    F    83_A      R     100          2.238
LGA    T    84_A      W     101          2.339
LGA    P    85_A      Q     102          2.083
LGA    I    86_A      C     103          2.299
LGA    I    87_A      N     104          3.105
LGA    G    88_A      R     105          4.121
LGA    G    89_A      P     106          2.685
LGA    G    90_A      S     107          3.547
LGA    -       -      A     108           -
LGA    -       -      K     109           -
LGA    -       -      H     110           -
LGA    -       -      G     111           -
LGA    E    91_A      P     112          3.127
LGA    K    92_A      E     113          1.774
LGA    T    93_A      K     114          1.617
LGA    S    94_A      L     115          2.119
LGA    V    95_A      S     116          2.524
LGA    K    96_A      E     117          2.722
LGA    F    97_A      K     118          3.142
LGA    K    98_A      F     119          3.901
LGA    V    99_A      Q     120          2.683
LGA    S   100_A      R     121          1.245
LGA    -       -      F     122           -
LGA    -       -      T     123           -
LGA    -       -      P     124           -
LGA    -       -      F     125           -
LGA    -       -      T     126           -
LGA    -       -      L     127           -
LGA    -       -      G     128           -
LGA    -       -      K     129           -
LGA    A   101_A      E     130          1.622
LGA    L   102_A      F     131          2.038
LGA    S   103_A      K     132          3.044
LGA    K   104_A      E     133          4.129
LGA    D   105_A      G     134          5.198
LGA    E   106_A      H     135          3.902
LGA    A   107_A      S     136          3.395
LGA    Y   108_A      Y     137          2.414
LGA    T   109_A      Y     138          1.966
LGA    Y   110_A      Y     139          1.708
LGA    F   111_A      I     140          1.583
LGA    C   112_A      S     141          1.111
LGA    S   113_A      K     142          3.008
LGA    Y   114_A      P     143          3.112
LGA    P   115_A      I     144          5.806
LGA    -       -      H     145           -
LGA    -       -      Q     146           -
LGA    G   116_A      H     147           #
LGA    H   117_A      E     148          4.133
LGA    F   118_A      D     149           -
LGA    S   119_A      R     150          5.269
LGA    M   120_A      C     151          1.834
LGA    M   121_A      L     152          0.646
LGA    R   122_A      R     153          0.966
LGA    G   123_A      L     154          1.982
LGA    T   124_A      K     155          1.455
LGA    L   125_A      V     156          0.875
LGA    K   126_A      T     157          0.330
LGA    L   127_A      V     158          0.552
LGA    E   128_A      S     159          2.003
LGA    E   129_A      G     160          1.839

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  129  130    5.0     98    2.94    10.20     42.178     3.219

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.204089 * X  +   0.085102 * Y  +  -0.975246 * Z  + -19.197460
  Y_new =   0.753551 * X  +  -0.622269 * Y  +  -0.211996 * Z  + -24.168301
  Z_new =  -0.624907 * X  +  -0.778164 * Y  +   0.062869 * Z  +  16.432447 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.490180    1.651413  [ DEG:   -85.3810     94.6190 ]
  Theta =   0.675012    2.466581  [ DEG:    38.6753    141.3247 ]
  Phi   =   1.835288   -1.306305  [ DEG:   105.1543    -74.8457 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1cuo_A                                        
REMARK     2: T0390.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1cuo_A.T0390.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  129  130   5.0   98   2.94   10.20  42.178
REMARK  ---------------------------------------------------------- 
MOLECULE 1cuo_A
HEADER    ELECTRON TRANSPORT                      21-AUG-99   1CUO              
TITLE     CRYSTAL STRUCTURE ANALYSIS OF ISOMER-2 AZURIN FROM                    
TITLE    2 METHYLOMONAS J                                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN (AZURIN ISO-2);                                    
COMPND   3 CHAIN: A                                                             
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHYLOMONAS J;                                 
SOURCE   3 ORGANISM_COMMON: BACTERIA                                            
KEYWDS    BETA BARREL, PERIPLASMIC, ELECTRON TRANSPORT                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.INOUE,N.NISHIO,Y.KAI,S.SUZUKI,K.KATAOKA                             
REVDAT   2   29-MAR-05 1CUO    1       JRNL   REMARK MASTER                     
REVDAT   1   23-AUG-00 1CUO    0                                                
JRNL        AUTH   T.INOUE,S.SUZUKI,N.NISHIO,K.YAMAGUCHI,K.KATAOKA,             
JRNL        AUTH 2 J.TOBARI,X.YONG,S.HAMANAKA,H.MATSUMURA,Y.KAI                 
JRNL        TITL   THE SIGNIFICANCE OF THE FLEXIBLE LOOP IN THE                 
JRNL        TITL 2 AZURIN (AZ-ISO2) FROM THE OBLIGATE METHYLOTROPH              
JRNL        TITL 3 METHYLOMONAS SP. STRAIN J.                                   
JRNL        REF    J.MOL.BIOL.                   V. 333   117 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  1CUO A    1   129  UNP    P12335   AZUR2_METJ       1    129             
SEQRES   1 A  129  ALA SER CYS GLU THR THR VAL THR SER GLY ASP THR MET          
SEQRES   2 A  129  THR TYR SER THR ARG SER ILE SER VAL PRO ALA SER CYS          
SEQRES   3 A  129  ALA GLU PHE THR VAL ASN PHE GLU HIS LYS GLY HIS MET          
SEQRES   4 A  129  PRO LYS THR GLY MET GLY HIS ASN TRP VAL LEU ALA LYS          
SEQRES   5 A  129  SER ALA ASP VAL GLY ASP VAL ALA LYS GLU GLY ALA HIS          
SEQRES   6 A  129  ALA GLY ALA ASP ASN ASN PHE VAL THR PRO GLY ASP LYS          
SEQRES   7 A  129  ARG VAL ILE ALA PHE THR PRO ILE ILE GLY GLY GLY GLU          
SEQRES   8 A  129  LYS THR SER VAL LYS PHE LYS VAL SER ALA LEU SER LYS          
SEQRES   9 A  129  ASP GLU ALA TYR THR TYR PHE CYS SER TYR PRO GLY HIS          
SEQRES  10 A  129  PHE SER MET MET ARG GLY THR LEU LYS LEU GLU GLU              
HET     CU    130       1                                                       
HETNAM      CU COPPER (II) ION                                                  
FORMUL   2   CU    CU 2+                                                        
FORMUL   3  HOH   *82(H2 O)                                                     
CRYST1   32.960   33.670   47.340  90.00 101.35  90.00 P 1 21 1      2          
ATOM      1  N   ALA A   1     -21.514  -5.391   5.492  1.00 35.13           N  
ATOM      2  CA  ALA A   1     -22.416  -4.802   6.514  1.00 33.15           C  
ATOM      3  C   ALA A   1     -23.860  -5.183   6.179  1.00 32.21           C  
ATOM      4  O   ALA A   1     -24.786  -4.390   6.343  1.00 33.71           O  
ATOM      5  CB  ALA A   1     -22.306  -3.298   6.664  1.00 33.63           C  
ATOM      6  N   SER A   2     -23.983  -6.407   5.680  1.00 29.45           N  
ATOM      7  CA  SER A   2     -25.327  -6.945   5.420  1.00 25.58           C  
ATOM      8  C   SER A   2     -25.775  -7.578   6.735  1.00 23.36           C  
ATOM      9  O   SER A   2     -25.047  -8.352   7.375  1.00 25.39           O  
ATOM     10  CB  SER A   2     -25.337  -7.910   4.251  1.00 26.93           C  
ATOM     11  OG  SER A   2     -26.411  -8.838   4.301  1.00 28.19           O  
ATOM     12  N   CYS A   3     -27.030  -7.286   7.100  1.00 19.80           N  
ATOM     13  CA  CYS A   3     -27.558  -7.812   8.364  1.00 17.19           C  
ATOM     14  C   CYS A   3     -28.674  -8.832   8.129  1.00 16.17           C  
ATOM     15  O   CYS A   3     -29.607  -8.940   8.902  1.00 16.17           O  
ATOM     16  CB  CYS A   3     -28.053  -6.628   9.192  1.00 17.90           C  
ATOM     17  SG  CYS A   3     -26.760  -5.430   9.619  1.00 18.62           S  
ATOM     18  N   GLU A   4     -28.526  -9.526   7.003  1.00 16.66           N  
ATOM     19  CA  GLU A   4     -29.519 -10.556   6.628  1.00 17.73           C  
ATOM     20  C   GLU A   4     -28.776 -11.663   5.889  1.00 18.28           C  
ATOM     21  O   GLU A   4     -27.735 -11.408   5.282  1.00 20.15           O  
ATOM     22  CB  GLU A   4     -30.564  -9.932   5.717  1.00 20.81           C  
ATOM     23  CG  GLU A   4     -31.748 -10.756   5.262  1.00 28.76           C  
ATOM     24  CD  GLU A   4     -32.624  -9.984   4.285  1.00 30.99           C  
ATOM     25  OE1 GLU A   4     -32.075  -9.199   3.471  1.00 32.49           O  
ATOM     26  OE2 GLU A   4     -33.863 -10.167   4.323  1.00 33.29           O  
ATOM     27  N   THR A   5     -29.288 -12.880   6.030  1.00 15.98           N  
ATOM     28  CA  THR A   5     -28.709 -14.002   5.329  1.00 15.38           C  
ATOM     29  C   THR A   5     -29.850 -14.980   5.007  1.00 15.44           C  
ATOM     30  O   THR A   5     -30.896 -14.852   5.612  1.00 15.23           O  
ATOM     31  CB  THR A   5     -27.589 -14.725   6.075  1.00 17.49           C  
ATOM     32  OG1 THR A   5     -26.920 -15.550   5.097  1.00 20.60           O  
ATOM     33  CG2 THR A   5     -28.056 -15.582   7.229  1.00 16.90           C  
ATOM     34  N   THR A   6     -29.620 -15.808   4.003  1.00 14.91           N  
ATOM     35  CA  THR A   6     -30.650 -16.781   3.630  1.00 14.54           C  
ATOM     36  C   THR A   6     -30.065 -18.183   3.748  1.00 15.08           C  
ATOM     37  O   THR A   6     -28.950 -18.452   3.243  1.00 16.07           O  
ATOM     38  CB  THR A   6     -31.110 -16.524   2.194  1.00 15.17           C  
ATOM     39  OG1 THR A   6     -31.747 -15.245   2.134  1.00 15.93           O  
ATOM     40  CG2 THR A   6     -32.083 -17.608   1.734  1.00 15.73           C  
ATOM     41  N   VAL A   7     -30.786 -19.047   4.449  1.00 10.80           N  
ATOM     42  CA  VAL A   7     -30.396 -20.432   4.650  1.00 12.76           C  
ATOM     43  C   VAL A   7     -31.490 -21.280   3.988  1.00 14.47           C  
ATOM     44  O   VAL A   7     -32.671 -21.033   4.239  1.00 15.75           O  
ATOM     45  CB  VAL A   7     -30.334 -20.800   6.147  1.00 13.83           C  
ATOM     46  CG1 VAL A   7     -30.106 -22.282   6.380  1.00 14.94           C  
ATOM     47  CG2 VAL A   7     -29.311 -19.927   6.883  1.00 15.80           C  
ATOM     48  N   THR A   8     -31.117 -22.221   3.142  1.00 13.34           N  
ATOM     49  CA  THR A   8     -32.131 -23.099   2.540  1.00 14.54           C  
ATOM     50  C   THR A   8     -31.933 -24.520   3.001  1.00 14.74           C  
ATOM     51  O   THR A   8     -30.922 -24.994   3.521  1.00 16.02           O  
ATOM     52  CB  THR A   8     -32.154 -23.038   0.997  1.00 17.67           C  
ATOM     53  OG1 THR A   8     -30.970 -23.650   0.505  1.00 21.21           O  
ATOM     54  CG2 THR A   8     -32.213 -21.604   0.510  1.00 18.97           C  
ATOM     55  N   SER A   9     -33.021 -25.279   2.837  1.00 14.23           N  
ATOM     56  CA  SER A   9     -33.134 -26.680   3.188  1.00 14.52           C  
ATOM     57  C   SER A   9     -33.995 -27.336   2.101  1.00 14.04           C  
ATOM     58  O   SER A   9     -34.517 -26.659   1.226  1.00 14.89           O  
ATOM     59  CB  SER A   9     -33.771 -26.891   4.556  1.00 17.41           C  
ATOM     60  OG  SER A   9     -35.131 -26.410   4.567  1.00 20.24           O  
ATOM     61  N   GLY A  10     -34.100 -28.652   2.145  1.00 16.41           N  
ATOM     62  CA  GLY A  10     -34.919 -29.295   1.088  1.00 14.88           C  
ATOM     63  C   GLY A  10     -35.337 -30.623   1.656  1.00 15.33           C  
ATOM     64  O   GLY A  10     -35.565 -30.806   2.859  1.00 18.09           O  
ATOM     65  N   ASP A  11     -35.416 -31.640   0.777  1.00 15.03           N  
ATOM     66  CA  ASP A  11     -35.864 -32.942   1.207  1.00 16.83           C  
ATOM     67  C   ASP A  11     -34.802 -33.842   1.808  1.00 20.72           C  
ATOM     68  O   ASP A  11     -34.975 -35.053   1.937  1.00 24.65           O  
ATOM     69  CB  ASP A  11     -36.603 -33.642   0.049  1.00 15.53           C  
ATOM     70  CG  ASP A  11     -37.907 -32.971  -0.347  1.00 14.96           C  
ATOM     71  OD1 ASP A  11     -38.243 -33.026  -1.561  1.00 14.07           O  
ATOM     72  OD2 ASP A  11     -38.590 -32.359   0.506  1.00 14.22           O  
ATOM     73  N   THR A  12     -33.715 -33.246   2.270  1.00 23.01           N  
ATOM     74  CA  THR A  12     -32.610 -33.910   2.936  1.00 25.51           C  
ATOM     75  C   THR A  12     -32.465 -33.378   4.360  1.00 26.26           C  
ATOM     76  O   THR A  12     -33.257 -32.532   4.794  1.00 25.91           O  
ATOM     77  CB  THR A  12     -31.288 -33.602   2.212  1.00 25.84           C  
ATOM     78  OG1 THR A  12     -30.975 -32.215   2.389  1.00 28.97           O  
ATOM     79  CG2 THR A  12     -31.380 -33.844   0.711  1.00 28.43           C  
ATOM     80  N   MET A  13     -31.476 -33.874   5.104  1.00 26.63           N  
ATOM     81  CA  MET A  13     -31.280 -33.347   6.458  1.00 27.29           C  
ATOM     82  C   MET A  13     -30.022 -32.502   6.564  1.00 26.32           C  
ATOM     83  O   MET A  13     -29.241 -32.638   7.505  1.00 27.36           O  
ATOM     84  CB  MET A  13     -31.294 -34.465   7.506  1.00 29.94           C  
ATOM     85  CG  MET A  13     -32.694 -35.024   7.742  1.00 33.35           C  
ATOM     86  SD  MET A  13     -32.699 -36.304   9.015  1.00 38.82           S  
ATOM     87  CE  MET A  13     -34.093 -37.283   8.441  1.00 37.63           C  
ATOM     88  N   THR A  14     -29.832 -31.578   5.647  1.00 25.14           N  
ATOM     89  CA  THR A  14     -28.727 -30.653   5.564  1.00 24.31           C  
ATOM     90  C   THR A  14     -29.171 -29.210   5.310  1.00 22.91           C  
ATOM     91  O   THR A  14     -30.082 -28.971   4.513  1.00 23.67           O  
ATOM     92  CB  THR A  14     -27.810 -30.994   4.357  1.00 26.05           C  
ATOM     93  OG1 THR A  14     -28.569 -30.877   3.136  1.00 28.95           O  
ATOM     94  CG2 THR A  14     -27.192 -32.368   4.429  1.00 28.10           C  
ATOM     95  N   TYR A  15     -28.508 -28.219   5.896  1.00 18.39           N  
ATOM     96  CA  TYR A  15     -28.707 -26.823   5.579  1.00 17.02           C  
ATOM     97  C   TYR A  15     -27.754 -26.471   4.431  1.00 16.91           C  
ATOM     98  O   TYR A  15     -26.716 -27.108   4.242  1.00 19.81           O  
ATOM     99  CB  TYR A  15     -28.367 -25.913   6.768  1.00 15.22           C  
ATOM    100  CG  TYR A  15     -29.291 -25.942   7.960  1.00 13.37           C  
ATOM    101  CD1 TYR A  15     -30.598 -25.453   7.822  1.00 15.49           C  
ATOM    102  CD2 TYR A  15     -28.869 -26.342   9.204  1.00 12.30           C  
ATOM    103  CE1 TYR A  15     -31.463 -25.409   8.919  1.00 14.35           C  
ATOM    104  CE2 TYR A  15     -29.711 -26.331  10.313  1.00 12.72           C  
ATOM    105  CZ  TYR A  15     -30.989 -25.830  10.143  1.00 14.01           C  
ATOM    106  OH  TYR A  15     -31.813 -25.790  11.254  1.00 14.11           O  
ATOM    107  N   SER A  16     -28.021 -25.383   3.741  1.00 16.00           N  
ATOM    108  CA  SER A  16     -27.220 -24.934   2.607  1.00 16.14           C  
ATOM    109  C   SER A  16     -25.877 -24.376   3.061  1.00 17.51           C  
ATOM    110  O   SER A  16     -24.964 -24.271   2.252  1.00 19.48           O  
ATOM    111  CB  SER A  16     -27.976 -23.893   1.789  1.00 15.40           C  
ATOM    112  OG  SER A  16     -28.293 -22.767   2.624  1.00 16.33           O  
ATOM    113  N   THR A  17     -25.744 -23.995   4.325  1.00 17.74           N  
ATOM    114  CA  THR A  17     -24.492 -23.481   4.854  1.00 19.08           C  
ATOM    115  C   THR A  17     -24.379 -23.955   6.296  1.00 19.16           C  
ATOM    116  O   THR A  17     -25.413 -24.090   6.968  1.00 19.54           O  
ATOM    117  CB  THR A  17     -24.376 -21.956   4.784  1.00 19.63           C  
ATOM    118  OG1 THR A  17     -23.104 -21.599   5.378  1.00 22.11           O  
ATOM    119  CG2 THR A  17     -25.505 -21.203   5.461  1.00 20.64           C  
ATOM    120  N   ARG A  18     -23.168 -24.213   6.755  1.00 18.81           N  
ATOM    121  CA  ARG A  18     -22.954 -24.654   8.125  1.00 18.59           C  
ATOM    122  C   ARG A  18     -22.232 -23.617   9.003  1.00 16.20           C  
ATOM    123  O   ARG A  18     -21.947 -23.930  10.153  1.00 14.82           O  
ATOM    124  CB  ARG A  18     -22.230 -26.014   8.144  1.00 21.64           C  
ATOM    125  CG  ARG A  18     -23.085 -27.048   7.391  1.00 25.15           C  
ATOM    126  CD  ARG A  18     -22.638 -28.462   7.657  1.00 29.00           C  
ATOM    127  NE  ARG A  18     -22.870 -28.821   9.059  1.00 31.27           N  
ATOM    128  CZ  ARG A  18     -22.503 -29.995   9.548  1.00 32.71           C  
ATOM    129  NH1 ARG A  18     -22.728 -30.268  10.824  1.00 32.90           N  
ATOM    130  NH2 ARG A  18     -21.902 -30.866   8.743  1.00 33.74           N  
ATOM    131  N   SER A  19     -22.116 -22.414   8.487  1.00 15.98           N  
ATOM    132  CA  SER A  19     -21.541 -21.331   9.282  1.00 17.19           C  
ATOM    133  C   SER A  19     -22.178 -20.020   8.864  1.00 18.69           C  
ATOM    134  O   SER A  19     -22.473 -19.707   7.699  1.00 20.56           O  
ATOM    135  CB  SER A  19     -20.008 -21.339   9.234  1.00 20.57           C  
ATOM    136  OG  SER A  19     -19.597 -20.790   7.990  1.00 26.65           O  
ATOM    137  N   ILE A  20     -22.625 -19.283   9.873  1.00 16.58           N  
ATOM    138  CA  ILE A  20     -23.237 -17.968   9.705  1.00 16.52           C  
ATOM    139  C   ILE A  20     -22.428 -16.970  10.548  1.00 17.37           C  
ATOM    140  O   ILE A  20     -22.219 -17.237  11.730  1.00 17.75           O  
ATOM    141  CB  ILE A  20     -24.711 -17.943  10.176  1.00 16.10           C  
ATOM    142  CG1 ILE A  20     -25.514 -18.912   9.294  1.00 16.24           C  
ATOM    143  CG2 ILE A  20     -25.287 -16.540  10.112  1.00 18.09           C  
ATOM    144  CD1 ILE A  20     -26.953 -19.114   9.752  1.00 16.91           C  
ATOM    145  N   SER A  21     -22.018 -15.876   9.928  1.00 20.40           N  
ATOM    146  CA  SER A  21     -21.285 -14.826  10.639  1.00 22.18           C  
ATOM    147  C   SER A  21     -22.205 -13.622  10.813  1.00 20.96           C  
ATOM    148  O   SER A  21     -22.780 -13.143   9.853  1.00 23.00           O  
ATOM    149  CB  SER A  21     -20.020 -14.378   9.898  1.00 24.26           C  
ATOM    150  OG  SER A  21     -19.152 -15.486   9.715  1.00 28.74           O  
ATOM    151  N   VAL A  22     -22.380 -13.152  12.043  1.00 20.92           N  
ATOM    152  CA  VAL A  22     -23.222 -11.996  12.326  1.00 20.00           C  
ATOM    153  C   VAL A  22     -22.292 -10.803  12.598  1.00 21.59           C  
ATOM    154  O   VAL A  22     -21.529 -10.886  13.558  1.00 20.36           O  
ATOM    155  CB  VAL A  22     -24.109 -12.284  13.547  1.00 19.73           C  
ATOM    156  CG1 VAL A  22     -24.959 -11.135  14.037  1.00 19.62           C  
ATOM    157  CG2 VAL A  22     -25.041 -13.473  13.230  1.00 21.01           C  
ATOM    158  N   PRO A  23     -22.385  -9.773  11.786  1.00 21.34           N  
ATOM    159  CA  PRO A  23     -21.573  -8.579  12.012  1.00 22.64           C  
ATOM    160  C   PRO A  23     -21.980  -7.923  13.311  1.00 22.73           C  
ATOM    161  O   PRO A  23     -23.156  -7.642  13.571  1.00 23.70           O  
ATOM    162  CB  PRO A  23     -21.847  -7.696  10.817  1.00 22.66           C  
ATOM    163  CG  PRO A  23     -22.665  -8.489   9.855  1.00 24.05           C  
ATOM    164  CD  PRO A  23     -23.299  -9.608  10.637  1.00 22.43           C  
ATOM    165  N   ALA A  24     -21.017  -7.616  14.194  1.00 23.86           N  
ATOM    166  CA  ALA A  24     -21.328  -6.948  15.457  1.00 24.97           C  
ATOM    167  C   ALA A  24     -21.817  -5.517  15.226  1.00 25.61           C  
ATOM    168  O   ALA A  24     -22.435  -4.935  16.117  1.00 26.79           O  
ATOM    169  CB  ALA A  24     -20.121  -6.942  16.394  1.00 25.34           C  
ATOM    170  N   SER A  25     -21.644  -4.966  14.039  1.00 25.53           N  
ATOM    171  CA  SER A  25     -22.114  -3.646  13.673  1.00 26.47           C  
ATOM    172  C   SER A  25     -23.612  -3.643  13.389  1.00 25.35           C  
ATOM    173  O   SER A  25     -24.235  -2.580  13.296  1.00 24.99           O  
ATOM    174  CB  SER A  25     -21.348  -3.151  12.439  1.00 27.50           C  
ATOM    175  OG  SER A  25     -21.777  -3.887  11.310  1.00 30.72           O  
ATOM    176  N   CYS A  26     -24.202  -4.841  13.242  1.00 22.97           N  
ATOM    177  CA  CYS A  26     -25.648  -4.899  13.031  1.00 21.10           C  
ATOM    178  C   CYS A  26     -26.409  -4.717  14.324  1.00 19.59           C  
ATOM    179  O   CYS A  26     -26.021  -5.313  15.331  1.00 22.03           O  
ATOM    180  CB  CYS A  26     -26.001  -6.273  12.441  1.00 18.60           C  
ATOM    181  SG  CYS A  26     -25.471  -6.499  10.757  1.00 18.07           S  
ATOM    182  N   ALA A  27     -27.490  -3.958  14.339  1.00 21.12           N  
ATOM    183  CA  ALA A  27     -28.319  -3.852  15.535  1.00 21.91           C  
ATOM    184  C   ALA A  27     -29.258  -5.071  15.572  1.00 19.96           C  
ATOM    185  O   ALA A  27     -29.514  -5.605  16.632  1.00 19.68           O  
ATOM    186  CB  ALA A  27     -29.157  -2.586  15.590  1.00 23.41           C  
ATOM    187  N   GLU A  28     -29.732  -5.490  14.397  1.00 20.03           N  
ATOM    188  CA  GLU A  28     -30.620  -6.661  14.357  1.00 19.79           C  
ATOM    189  C   GLU A  28     -30.156  -7.526  13.182  1.00 17.46           C  
ATOM    190  O   GLU A  28     -29.567  -6.984  12.247  1.00 17.53           O  
ATOM    191  CB  GLU A  28     -32.062  -6.254  14.150  1.00 22.73           C  
ATOM    192  CG  GLU A  28     -32.800  -5.767  15.395  1.00 27.91           C  
ATOM    193  CD  GLU A  28     -34.185  -5.284  14.973  1.00 29.85           C  
ATOM    194  OE1 GLU A  28     -35.151  -5.575  15.681  1.00 32.81           O  
ATOM    195  OE2 GLU A  28     -34.294  -4.641  13.907  1.00 32.17           O  
ATOM    196  N   PHE A  29     -30.432  -8.824  13.278  1.00 14.12           N  
ATOM    197  CA  PHE A  29     -29.979  -9.696  12.185  1.00 13.37           C  
ATOM    198  C   PHE A  29     -31.174 -10.597  11.793  1.00 13.50           C  
ATOM    199  O   PHE A  29     -31.879 -11.038  12.687  1.00 14.74           O  
ATOM    200  CB  PHE A  29     -28.817 -10.545  12.666  1.00 15.00           C  
ATOM    201  CG  PHE A  29     -28.096 -11.262  11.556  1.00 16.19           C  
ATOM    202  CD1 PHE A  29     -28.387 -12.589  11.278  1.00 17.19           C  
ATOM    203  CD2 PHE A  29     -27.145 -10.609  10.794  1.00 16.74           C  
ATOM    204  CE1 PHE A  29     -27.741 -13.252  10.253  1.00 17.62           C  
ATOM    205  CE2 PHE A  29     -26.495 -11.260   9.768  1.00 17.51           C  
ATOM    206  CZ  PHE A  29     -26.782 -12.587   9.494  1.00 17.98           C  
ATOM    207  N   THR A  30     -31.313 -10.760  10.500  1.00 12.08           N  
ATOM    208  CA  THR A  30     -32.434 -11.543   9.987  1.00 12.61           C  
ATOM    209  C   THR A  30     -31.913 -12.795   9.299  1.00 11.72           C  
ATOM    210  O   THR A  30     -31.011 -12.730   8.445  1.00 13.62           O  
ATOM    211  CB  THR A  30     -33.250 -10.738   8.962  1.00 12.98           C  
ATOM    212  OG1 THR A  30     -33.886  -9.639   9.645  1.00 15.31           O  
ATOM    213  CG2 THR A  30     -34.332 -11.568   8.273  1.00 14.83           C  
ATOM    214  N   VAL A  31     -32.530 -13.909   9.668  1.00 11.38           N  
ATOM    215  CA  VAL A  31     -32.246 -15.175   9.003  1.00 10.80           C  
ATOM    216  C   VAL A  31     -33.494 -15.558   8.180  1.00 12.04           C  
ATOM    217  O   VAL A  31     -34.527 -15.793   8.807  1.00 13.22           O  
ATOM    218  CB  VAL A  31     -31.897 -16.312   9.964  1.00 11.91           C  
ATOM    219  CG1 VAL A  31     -31.782 -17.629   9.223  1.00 14.10           C  
ATOM    220  CG2 VAL A  31     -30.572 -15.938  10.674  1.00 13.98           C  
ATOM    221  N   ASN A  32     -33.392 -15.580   6.863  1.00 10.12           N  
ATOM    222  CA  ASN A  32     -34.520 -16.034   6.032  1.00 11.21           C  
ATOM    223  C   ASN A  32     -34.320 -17.533   5.820  1.00 12.75           C  
ATOM    224  O   ASN A  32     -33.194 -17.927   5.611  1.00 12.97           O  
ATOM    225  CB  ASN A  32     -34.487 -15.366   4.659  1.00 13.63           C  
ATOM    226  CG  ASN A  32     -34.586 -13.871   4.725  1.00 15.38           C  
ATOM    227  OD1 ASN A  32     -33.614 -13.143   4.416  1.00 20.33           O  
ATOM    228  ND2 ASN A  32     -35.708 -13.350   5.134  1.00 16.38           N  
ATOM    229  N   PHE A  33     -35.413 -18.310   5.912  1.00 10.02           N  
ATOM    230  CA  PHE A  33     -35.202 -19.757   5.851  1.00 11.99           C  
ATOM    231  C   PHE A  33     -36.227 -20.313   4.878  1.00 11.18           C  
ATOM    232  O   PHE A  33     -37.383 -19.984   4.991  1.00 14.10           O  
ATOM    233  CB  PHE A  33     -35.348 -20.341   7.254  1.00 13.06           C  
ATOM    234  CG  PHE A  33     -35.209 -21.835   7.314  1.00 14.12           C  
ATOM    235  CD1 PHE A  33     -36.229 -22.619   7.816  1.00 14.87           C  
ATOM    236  CD2 PHE A  33     -34.063 -22.467   6.815  1.00 15.40           C  
ATOM    237  CE1 PHE A  33     -36.112 -24.001   7.869  1.00 16.68           C  
ATOM    238  CE2 PHE A  33     -33.965 -23.833   6.864  1.00 16.73           C  
ATOM    239  CZ  PHE A  33     -34.973 -24.623   7.375  1.00 15.84           C  
ATOM    240  N   GLU A  34     -35.740 -21.105   3.898  1.00 12.06           N  
ATOM    241  CA  GLU A  34     -36.657 -21.568   2.854  1.00 13.57           C  
ATOM    242  C   GLU A  34     -36.533 -23.085   2.703  1.00 14.17           C  
ATOM    243  O   GLU A  34     -35.450 -23.632   2.909  1.00 14.88           O  
ATOM    244  CB  GLU A  34     -36.268 -20.951   1.492  1.00 17.63           C  
ATOM    245  CG  GLU A  34     -36.269 -19.426   1.487  1.00 22.55           C  
ATOM    246  CD  GLU A  34     -36.039 -18.792   0.124  1.00 26.54           C  
ATOM    247  OE1 GLU A  34     -35.951 -17.542   0.059  1.00 29.12           O  
ATOM    248  OE2 GLU A  34     -35.947 -19.536  -0.867  1.00 29.33           O  
ATOM    249  N   HIS A  35     -37.648 -23.717   2.362  1.00 11.14           N  
ATOM    250  CA  HIS A  35     -37.615 -25.197   2.167  1.00 10.74           C  
ATOM    251  C   HIS A  35     -37.945 -25.437   0.694  1.00 11.66           C  
ATOM    252  O   HIS A  35     -39.039 -25.126   0.263  1.00 12.80           O  
ATOM    253  CB  HIS A  35     -38.647 -25.827   3.088  1.00 10.21           C  
ATOM    254  CG  HIS A  35     -38.663 -27.315   3.116  1.00  8.27           C  
ATOM    255  ND1 HIS A  35     -38.467 -28.097   1.989  1.00 10.84           N  
ATOM    256  CD2 HIS A  35     -38.940 -28.155   4.146  1.00 10.00           C  
ATOM    257  CE1 HIS A  35     -38.630 -29.366   2.354  1.00  9.99           C  
ATOM    258  NE2 HIS A  35     -38.902 -29.449   3.656  1.00 11.73           N  
ATOM    259  N   LYS A  36     -36.910 -25.879  -0.036  1.00 11.86           N  
ATOM    260  CA  LYS A  36     -37.060 -26.000  -1.483  1.00 14.39           C  
ATOM    261  C   LYS A  36     -37.429 -27.425  -1.905  1.00 13.63           C  
ATOM    262  O   LYS A  36     -37.404 -27.662  -3.123  1.00 15.23           O  
ATOM    263  CB  LYS A  36     -35.765 -25.558  -2.191  1.00 18.21           C  
ATOM    264  CG  LYS A  36     -35.434 -24.070  -1.966  1.00 22.64           C  
ATOM    265  CD  LYS A  36     -34.563 -23.528  -3.099  1.00 26.98           C  
ATOM    266  CE  LYS A  36     -33.674 -22.407  -2.583  1.00 29.39           C  
ATOM    267  NZ  LYS A  36     -32.782 -21.811  -3.621  1.00 32.71           N  
ATOM    268  N   GLY A  37     -37.753 -28.295  -0.966  1.00 10.99           N  
ATOM    269  CA  GLY A  37     -38.144 -29.669  -1.377  1.00 10.39           C  
ATOM    270  C   GLY A  37     -39.623 -29.735  -1.796  1.00 11.80           C  
ATOM    271  O   GLY A  37     -40.334 -28.740  -1.840  1.00 12.64           O  
ATOM    272  N   HIS A  38     -40.044 -30.980  -2.062  1.00 11.99           N  
ATOM    273  CA  HIS A  38     -41.477 -31.143  -2.386  1.00 11.90           C  
ATOM    274  C   HIS A  38     -42.201 -31.905  -1.306  1.00 13.01           C  
ATOM    275  O   HIS A  38     -43.403 -32.137  -1.537  1.00 15.04           O  
ATOM    276  CB  HIS A  38     -41.687 -31.825  -3.753  1.00 12.57           C  
ATOM    277  CG  HIS A  38     -41.194 -33.233  -3.790  1.00 13.22           C  
ATOM    278  ND1 HIS A  38     -39.917 -33.505  -4.252  1.00 13.25           N  
ATOM    279  CD2 HIS A  38     -41.777 -34.418  -3.506  1.00 13.20           C  
ATOM    280  CE1 HIS A  38     -39.737 -34.814  -4.186  1.00 12.71           C  
ATOM    281  NE2 HIS A  38     -40.831 -35.398  -3.745  1.00 14.33           N  
ATOM    282  N   MET A  39     -41.600 -32.334  -0.215  1.00 13.92           N  
ATOM    283  CA  MET A  39     -42.306 -33.085   0.830  1.00 15.23           C  
ATOM    284  C   MET A  39     -42.838 -32.133   1.868  1.00 14.87           C  
ATOM    285  O   MET A  39     -42.215 -31.079   2.112  1.00 12.95           O  
ATOM    286  CB  MET A  39     -41.333 -34.127   1.399  1.00 17.53           C  
ATOM    287  CG  MET A  39     -40.707 -34.986   0.285  1.00 22.21           C  
ATOM    288  SD  MET A  39     -39.519 -36.173   0.911  1.00 27.62           S  
ATOM    289  CE  MET A  39     -38.739 -36.771  -0.590  1.00 27.28           C  
ATOM    290  N   PRO A  40     -44.001 -32.386   2.439  1.00 14.92           N  
ATOM    291  CA  PRO A  40     -44.618 -31.444   3.367  1.00 14.45           C  
ATOM    292  C   PRO A  40     -44.045 -31.540   4.756  1.00 13.81           C  
ATOM    293  O   PRO A  40     -43.229 -32.412   5.080  1.00 15.31           O  
ATOM    294  CB  PRO A  40     -46.092 -31.881   3.267  1.00 15.20           C  
ATOM    295  CG  PRO A  40     -45.974 -33.361   3.125  1.00 17.25           C  
ATOM    296  CD  PRO A  40     -44.862 -33.556   2.103  1.00 16.94           C  
ATOM    297  N   LYS A  41     -44.481 -30.672   5.681  1.00 13.85           N  
ATOM    298  CA  LYS A  41     -43.955 -30.654   7.043  1.00 14.64           C  
ATOM    299  C   LYS A  41     -44.311 -31.888   7.857  1.00 16.13           C  
ATOM    300  O   LYS A  41     -43.647 -32.154   8.862  1.00 17.02           O  
ATOM    301  CB  LYS A  41     -44.377 -29.361   7.747  1.00 16.39           C  
ATOM    302  CG  LYS A  41     -45.888 -29.222   7.941  1.00 17.43           C  
ATOM    303  CD  LYS A  41     -46.064 -27.839   8.603  1.00 20.42           C  
ATOM    304  CE  LYS A  41     -47.520 -27.508   8.869  1.00 22.34           C  
ATOM    305  NZ  LYS A  41     -47.630 -26.052   9.227  1.00 20.85           N  
ATOM    306  N   THR A  42     -45.348 -32.643   7.471  1.00 16.11           N  
ATOM    307  CA  THR A  42     -45.658 -33.910   8.099  1.00 17.38           C  
ATOM    308  C   THR A  42     -44.784 -34.962   7.418  1.00 19.39           C  
ATOM    309  O   THR A  42     -45.089 -35.534   6.356  1.00 21.01           O  
ATOM    310  CB  THR A  42     -47.149 -34.298   7.890  1.00 19.43           C  
ATOM    311  OG1 THR A  42     -47.320 -34.384   6.472  1.00 24.63           O  
ATOM    312  CG2 THR A  42     -48.013 -33.226   8.494  1.00 19.03           C  
ATOM    313  N   GLY A  43     -43.568 -35.094   7.948  1.00 18.84           N  
ATOM    314  CA  GLY A  43     -42.571 -36.019   7.481  1.00 19.80           C  
ATOM    315  C   GLY A  43     -41.260 -35.345   7.097  1.00 18.34           C  
ATOM    316  O   GLY A  43     -40.210 -35.970   7.243  1.00 21.10           O  
ATOM    317  N   MET A  44     -41.303 -34.097   6.618  1.00 15.68           N  
ATOM    318  CA  MET A  44     -40.038 -33.480   6.197  1.00 16.96           C  
ATOM    319  C   MET A  44     -40.003 -32.007   6.593  1.00 14.96           C  
ATOM    320  O   MET A  44     -39.552 -31.160   5.834  1.00 15.83           O  
ATOM    321  CB  MET A  44     -39.812 -33.672   4.710  1.00 18.75           C  
ATOM    322  CG  MET A  44     -38.414 -33.310   4.228  1.00 22.09           C  
ATOM    323  SD  MET A  44     -37.109 -34.093   5.198  1.00 26.86           S  
ATOM    324  CE  MET A  44     -37.550 -35.819   4.973  1.00 27.04           C  
ATOM    325  N   GLY A  45     -40.526 -31.726   7.765  1.00 12.98           N  
ATOM    326  CA  GLY A  45     -40.525 -30.329   8.218  1.00 12.12           C  
ATOM    327  C   GLY A  45     -39.121 -29.952   8.698  1.00 11.67           C  
ATOM    328  O   GLY A  45     -38.390 -30.769   9.245  1.00 14.59           O  
ATOM    329  N   HIS A  46     -38.824 -28.662   8.611  1.00 10.44           N  
ATOM    330  CA  HIS A  46     -37.551 -28.160   9.132  1.00 11.70           C  
ATOM    331  C   HIS A  46     -37.809 -26.793   9.778  1.00 11.65           C  
ATOM    332  O   HIS A  46     -38.675 -26.034   9.349  1.00 10.86           O  
ATOM    333  CB  HIS A  46     -36.477 -27.881   8.082  1.00 12.58           C  
ATOM    334  CG  HIS A  46     -36.094 -29.055   7.216  1.00 13.04           C  
ATOM    335  ND1 HIS A  46     -35.568 -30.185   7.749  1.00 13.02           N  
ATOM    336  CD2 HIS A  46     -36.141 -29.220   5.874  1.00 13.52           C  
ATOM    337  CE1 HIS A  46     -35.276 -31.032   6.763  1.00 14.58           C  
ATOM    338  NE2 HIS A  46     -35.616 -30.468   5.609  1.00 13.64           N  
ATOM    339  N   ASN A  47     -36.934 -26.501  10.749  1.00 11.67           N  
ATOM    340  CA  ASN A  47     -36.958 -25.148  11.331  1.00 12.54           C  
ATOM    341  C   ASN A  47     -35.489 -24.749  11.586  1.00 12.62           C  
ATOM    342  O   ASN A  47     -34.619 -25.514  11.169  1.00 11.73           O  
ATOM    343  CB  ASN A  47     -37.763 -24.991  12.612  1.00 13.33           C  
ATOM    344  CG  ASN A  47     -37.330 -25.914  13.715  1.00 14.61           C  
ATOM    345  OD1 ASN A  47     -36.310 -26.632  13.626  1.00 13.51           O  
ATOM    346  ND2 ASN A  47     -38.036 -26.003  14.859  1.00 16.10           N  
ATOM    347  N   TRP A  48     -35.297 -23.575  12.169  1.00 11.05           N  
ATOM    348  CA  TRP A  48     -33.944 -23.041  12.418  1.00 10.81           C  
ATOM    349  C   TRP A  48     -34.034 -22.517  13.865  1.00 10.97           C  
ATOM    350  O   TRP A  48     -34.898 -21.670  14.113  1.00 12.65           O  
ATOM    351  CB  TRP A  48     -33.640 -21.943  11.428  1.00 11.36           C  
ATOM    352  CG  TRP A  48     -32.241 -21.375  11.552  1.00 12.00           C  
ATOM    353  CD1 TRP A  48     -31.155 -21.765  10.826  1.00 13.13           C  
ATOM    354  CD2 TRP A  48     -31.849 -20.279  12.374  1.00 13.25           C  
ATOM    355  NE1 TRP A  48     -30.077 -20.959  11.165  1.00 11.98           N  
ATOM    356  CE2 TRP A  48     -30.473 -20.087  12.150  1.00 13.25           C  
ATOM    357  CE3 TRP A  48     -32.494 -19.462  13.310  1.00 13.02           C  
ATOM    358  CZ2 TRP A  48     -29.718 -19.106  12.796  1.00 13.26           C  
ATOM    359  CZ3 TRP A  48     -31.735 -18.484  13.960  1.00 12.69           C  
ATOM    360  CH2 TRP A  48     -30.385 -18.308  13.703  1.00 13.96           C  
ATOM    361  N   VAL A  49     -33.321 -23.165  14.748  1.00  9.81           N  
ATOM    362  CA  VAL A  49     -33.342 -22.804  16.184  1.00  8.62           C  
ATOM    363  C   VAL A  49     -31.933 -22.411  16.644  1.00 11.46           C  
ATOM    364  O   VAL A  49     -30.991 -23.113  16.288  1.00 12.64           O  
ATOM    365  CB  VAL A  49     -33.745 -24.013  16.992  1.00 10.29           C  
ATOM    366  CG1 VAL A  49     -33.850 -23.684  18.474  1.00  9.55           C  
ATOM    367  CG2 VAL A  49     -35.146 -24.553  16.580  1.00 10.75           C  
ATOM    368  N   LEU A  50     -31.826 -21.295  17.393  1.00 10.66           N  
ATOM    369  CA  LEU A  50     -30.484 -20.878  17.826  1.00 11.20           C  
ATOM    370  C   LEU A  50     -30.323 -20.985  19.333  1.00 11.39           C  
ATOM    371  O   LEU A  50     -31.197 -20.520  20.078  1.00 11.28           O  
ATOM    372  CB  LEU A  50     -30.298 -19.430  17.315  1.00 10.99           C  
ATOM    373  CG  LEU A  50     -28.998 -18.731  17.779  1.00 12.30           C  
ATOM    374  CD1 LEU A  50     -27.818 -19.434  17.110  1.00 15.52           C  
ATOM    375  CD2 LEU A  50     -29.028 -17.248  17.460  1.00 14.40           C  
ATOM    376  N   ALA A  51     -29.243 -21.609  19.788  1.00  9.55           N  
ATOM    377  CA  ALA A  51     -29.021 -21.779  21.234  1.00 10.07           C  
ATOM    378  C   ALA A  51     -27.516 -21.731  21.510  1.00 10.39           C  
ATOM    379  O   ALA A  51     -26.776 -21.863  20.548  1.00 13.56           O  
ATOM    380  CB  ALA A  51     -29.559 -23.087  21.776  1.00 11.96           C  
ATOM    381  N   LYS A  52     -27.138 -21.522  22.777  1.00 11.62           N  
ATOM    382  CA  LYS A  52     -25.672 -21.694  23.024  1.00 13.61           C  
ATOM    383  C   LYS A  52     -25.384 -23.158  22.745  1.00 13.23           C  
ATOM    384  O   LYS A  52     -26.237 -24.046  22.919  1.00 13.18           O  
ATOM    385  CB  LYS A  52     -25.403 -21.446  24.502  1.00 16.26           C  
ATOM    386  CG  LYS A  52     -25.579 -20.015  24.992  1.00 21.12           C  
ATOM    387  CD  LYS A  52     -25.443 -20.051  26.516  1.00 24.59           C  
ATOM    388  CE  LYS A  52     -26.268 -18.947  27.174  1.00 27.50           C  
ATOM    389  NZ  LYS A  52     -25.784 -18.745  28.585  1.00 30.53           N  
ATOM    390  N   SER A  53     -24.178 -23.466  22.263  1.00 12.38           N  
ATOM    391  CA  SER A  53     -23.811 -24.833  21.900  1.00 13.95           C  
ATOM    392  C   SER A  53     -23.965 -25.830  23.046  1.00 14.31           C  
ATOM    393  O   SER A  53     -24.401 -26.970  22.803  1.00 17.19           O  
ATOM    394  CB  SER A  53     -22.369 -24.844  21.371  1.00 15.04           C  
ATOM    395  OG  SER A  53     -22.219 -24.058  20.210  1.00 15.90           O  
ATOM    396  N   ALA A  54     -23.742 -25.412  24.279  1.00 15.00           N  
ATOM    397  CA  ALA A  54     -23.860 -26.316  25.420  1.00 17.77           C  
ATOM    398  C   ALA A  54     -25.305 -26.694  25.717  1.00 19.19           C  
ATOM    399  O   ALA A  54     -25.525 -27.661  26.449  1.00 19.89           O  
ATOM    400  CB  ALA A  54     -23.259 -25.709  26.682  1.00 19.39           C  
ATOM    401  N   ASP A  55     -26.258 -25.921  25.203  1.00 16.79           N  
ATOM    402  CA  ASP A  55     -27.660 -26.155  25.471  1.00 18.21           C  
ATOM    403  C   ASP A  55     -28.364 -26.936  24.389  1.00 16.75           C  
ATOM    404  O   ASP A  55     -29.553 -27.282  24.578  1.00 17.83           O  
ATOM    405  CB  ASP A  55     -28.379 -24.811  25.664  1.00 17.00           C  
ATOM    406  CG  ASP A  55     -28.026 -24.076  26.939  1.00 18.24           C  
ATOM    407  OD1 ASP A  55     -27.593 -24.759  27.903  1.00 22.50           O  
ATOM    408  OD2 ASP A  55     -28.201 -22.845  26.981  1.00 18.88           O  
ATOM    409  N   VAL A  56     -27.772 -27.192  23.237  1.00 16.75           N  
ATOM    410  CA  VAL A  56     -28.466 -27.843  22.133  1.00 16.43           C  
ATOM    411  C   VAL A  56     -29.101 -29.168  22.503  1.00 17.91           C  
ATOM    412  O   VAL A  56     -30.278 -29.384  22.187  1.00 16.66           O  
ATOM    413  CB  VAL A  56     -27.504 -28.043  20.929  1.00 17.60           C  
ATOM    414  CG1 VAL A  56     -28.107 -28.946  19.865  1.00 18.88           C  
ATOM    415  CG2 VAL A  56     -27.192 -26.665  20.386  1.00 18.04           C  
ATOM    416  N   GLY A  57     -28.327 -30.038  23.152  1.00 16.69           N  
ATOM    417  CA  GLY A  57     -28.851 -31.341  23.533  1.00 17.39           C  
ATOM    418  C   GLY A  57     -30.156 -31.274  24.317  1.00 16.69           C  
ATOM    419  O   GLY A  57     -31.108 -31.997  23.976  1.00 19.28           O  
ATOM    420  N   ASP A  58     -30.182 -30.457  25.365  1.00 16.28           N  
ATOM    421  CA  ASP A  58     -31.411 -30.372  26.182  1.00 18.24           C  
ATOM    422  C   ASP A  58     -32.530 -29.700  25.417  1.00 17.65           C  
ATOM    423  O   ASP A  58     -33.686 -30.121  25.585  1.00 17.16           O  
ATOM    424  CB  ASP A  58     -31.127 -29.653  27.498  1.00 21.16           C  
ATOM    425  CG  ASP A  58     -30.435 -30.545  28.524  1.00 24.47           C  
ATOM    426  OD1 ASP A  58     -30.230 -31.733  28.259  1.00 24.54           O  
ATOM    427  OD2 ASP A  58     -30.107 -30.027  29.616  1.00 27.43           O  
ATOM    428  N   VAL A  59     -32.236 -28.652  24.626  1.00 15.41           N  
ATOM    429  CA  VAL A  59     -33.308 -28.005  23.861  1.00 15.95           C  
ATOM    430  C   VAL A  59     -33.933 -28.992  22.881  1.00 16.18           C  
ATOM    431  O   VAL A  59     -35.166 -29.050  22.733  1.00 16.05           O  
ATOM    432  CB  VAL A  59     -32.819 -26.752  23.120  1.00 15.08           C  
ATOM    433  CG1 VAL A  59     -33.835 -26.181  22.140  1.00 16.05           C  
ATOM    434  CG2 VAL A  59     -32.450 -25.693  24.160  1.00 15.90           C  
ATOM    435  N   ALA A  60     -33.112 -29.773  22.203  1.00 17.65           N  
ATOM    436  CA  ALA A  60     -33.570 -30.796  21.271  1.00 18.61           C  
ATOM    437  C   ALA A  60     -34.344 -31.881  21.994  1.00 18.87           C  
ATOM    438  O   ALA A  60     -35.412 -32.261  21.479  1.00 18.73           O  
ATOM    439  CB  ALA A  60     -32.364 -31.409  20.561  1.00 17.71           C  
ATOM    440  N   LYS A  61     -33.884 -32.371  23.140  1.00 20.13           N  
ATOM    441  CA  LYS A  61     -34.621 -33.393  23.881  1.00 22.12           C  
ATOM    442  C   LYS A  61     -36.017 -32.939  24.289  1.00 22.20           C  
ATOM    443  O   LYS A  61     -36.977 -33.714  24.151  1.00 24.15           O  
ATOM    444  CB  LYS A  61     -33.955 -33.802  25.203  1.00 23.10           C  
ATOM    445  CG  LYS A  61     -32.765 -34.720  25.124  1.00 23.23           C  
ATOM    446  CD  LYS A  61     -32.246 -35.046  26.525  1.00 23.00           C  
ATOM    447  CE  LYS A  61     -31.216 -36.172  26.456  1.00 22.20           C  
ATOM    448  NZ  LYS A  61     -30.168 -35.869  25.437  1.00 25.36           N  
ATOM    449  N   GLU A  62     -36.149 -31.779  24.894  1.00 20.53           N  
ATOM    450  CA  GLU A  62     -37.438 -31.286  25.351  1.00 21.83           C  
ATOM    451  C   GLU A  62     -38.317 -30.873  24.195  1.00 21.21           C  
ATOM    452  O   GLU A  62     -39.530 -31.105  24.151  1.00 20.63           O  
ATOM    453  CB  GLU A  62     -37.211 -30.130  26.344  1.00 24.82           C  
ATOM    454  CG  GLU A  62     -36.401 -30.664  27.533  1.00 27.53           C  
ATOM    455  CD  GLU A  62     -36.651 -29.873  28.794  1.00 30.36           C  
ATOM    456  OE1 GLU A  62     -36.088 -28.771  28.906  1.00 30.80           O  
ATOM    457  OE2 GLU A  62     -37.412 -30.373  29.665  1.00 30.72           O  
ATOM    458  N   GLY A  63     -37.675 -30.239  23.204  1.00 18.34           N  
ATOM    459  CA  GLY A  63     -38.409 -29.804  22.020  1.00 18.73           C  
ATOM    460  C   GLY A  63     -39.050 -30.976  21.285  1.00 18.51           C  
ATOM    461  O   GLY A  63     -40.178 -30.815  20.787  1.00 18.70           O  
ATOM    462  N   ALA A  64     -38.417 -32.146  21.215  1.00 20.44           N  
ATOM    463  CA  ALA A  64     -39.012 -33.256  20.460  1.00 21.84           C  
ATOM    464  C   ALA A  64     -40.343 -33.664  21.057  1.00 22.08           C  
ATOM    465  O   ALA A  64     -41.270 -34.056  20.330  1.00 23.51           O  
ATOM    466  CB  ALA A  64     -37.994 -34.397  20.399  1.00 22.42           C  
ATOM    467  N   HIS A  65     -40.523 -33.503  22.367  1.00 23.38           N  
ATOM    468  CA  HIS A  65     -41.784 -33.782  23.033  1.00 26.35           C  
ATOM    469  C   HIS A  65     -42.767 -32.639  23.109  1.00 26.71           C  
ATOM    470  O   HIS A  65     -43.888 -32.806  23.618  1.00 28.67           O  
ATOM    471  CB  HIS A  65     -41.493 -34.257  24.471  1.00 28.14           C  
ATOM    472  CG  HIS A  65     -40.711 -35.533  24.445  1.00 30.21           C  
ATOM    473  ND1 HIS A  65     -39.351 -35.578  24.627  1.00 31.05           N  
ATOM    474  CD2 HIS A  65     -41.120 -36.807  24.224  1.00 31.62           C  
ATOM    475  CE1 HIS A  65     -38.946 -36.836  24.537  1.00 32.62           C  
ATOM    476  NE2 HIS A  65     -40.000 -37.598  24.294  1.00 33.06           N  
ATOM    477  N   ALA A  66     -42.437 -31.452  22.599  1.00 24.51           N  
ATOM    478  CA  ALA A  66     -43.337 -30.313  22.650  1.00 22.95           C  
ATOM    479  C   ALA A  66     -44.419 -30.394  21.577  1.00 22.18           C  
ATOM    480  O   ALA A  66     -45.433 -29.707  21.661  1.00 22.30           O  
ATOM    481  CB  ALA A  66     -42.576 -29.004  22.527  1.00 20.89           C  
ATOM    482  N   GLY A  67     -44.209 -31.218  20.554  1.00 23.06           N  
ATOM    483  CA  GLY A  67     -45.236 -31.357  19.542  1.00 22.30           C  
ATOM    484  C   GLY A  67     -45.080 -30.375  18.392  1.00 22.45           C  
ATOM    485  O   GLY A  67     -44.563 -29.262  18.501  1.00 19.39           O  
ATOM    486  N   ALA A  68     -45.688 -30.823  17.276  1.00 22.39           N  
ATOM    487  CA  ALA A  68     -45.678 -30.051  16.057  1.00 23.59           C  
ATOM    488  C   ALA A  68     -46.392 -28.730  16.224  1.00 22.53           C  
ATOM    489  O   ALA A  68     -45.972 -27.752  15.613  1.00 22.02           O  
ATOM    490  CB  ALA A  68     -46.281 -30.809  14.876  1.00 24.63           C  
ATOM    491  N   ASP A  69     -47.439 -28.662  17.067  1.00 24.05           N  
ATOM    492  CA  ASP A  69     -48.123 -27.394  17.262  1.00 25.79           C  
ATOM    493  C   ASP A  69     -47.265 -26.371  18.000  1.00 24.17           C  
ATOM    494  O   ASP A  69     -47.541 -25.176  17.890  1.00 24.20           O  
ATOM    495  CB  ASP A  69     -49.466 -27.567  17.986  1.00 30.31           C  
ATOM    496  CG  ASP A  69     -50.602 -27.818  17.015  1.00 34.64           C  
ATOM    497  OD1 ASP A  69     -51.157 -28.942  16.986  1.00 37.20           O  
ATOM    498  OD2 ASP A  69     -50.976 -26.883  16.269  1.00 37.13           O  
ATOM    499  N   ASN A  70     -46.217 -26.798  18.700  1.00 20.79           N  
ATOM    500  CA  ASN A  70     -45.282 -25.901  19.350  1.00 18.29           C  
ATOM    501  C   ASN A  70     -43.971 -25.825  18.547  1.00 15.37           C  
ATOM    502  O   ASN A  70     -42.937 -25.377  19.080  1.00 15.07           O  
ATOM    503  CB  ASN A  70     -44.924 -26.331  20.780  1.00 19.46           C  
ATOM    504  CG  ASN A  70     -46.092 -26.085  21.730  1.00 21.42           C  
ATOM    505  OD1 ASN A  70     -46.590 -24.969  21.750  1.00 22.04           O  
ATOM    506  ND2 ASN A  70     -46.460 -27.116  22.456  1.00 25.25           N  
ATOM    507  N   ASN A  71     -44.012 -26.216  17.285  1.00 14.68           N  
ATOM    508  CA  ASN A  71     -42.824 -26.156  16.407  1.00 13.34           C  
ATOM    509  C   ASN A  71     -41.646 -26.909  16.944  1.00 13.16           C  
ATOM    510  O   ASN A  71     -40.485 -26.570  16.629  1.00 12.38           O  
ATOM    511  CB  ASN A  71     -42.467 -24.701  16.073  1.00 13.57           C  
ATOM    512  CG  ASN A  71     -43.608 -24.077  15.283  1.00 13.88           C  
ATOM    513  OD1 ASN A  71     -44.300 -23.176  15.793  1.00 16.23           O  
ATOM    514  ND2 ASN A  71     -43.817 -24.509  14.085  1.00 11.07           N  
ATOM    515  N   PHE A  72     -41.857 -27.939  17.757  1.00 11.51           N  
ATOM    516  CA  PHE A  72     -40.841 -28.756  18.382  1.00 12.81           C  
ATOM    517  C   PHE A  72     -39.868 -27.900  19.184  1.00 12.77           C  
ATOM    518  O   PHE A  72     -38.678 -28.187  19.261  1.00 13.53           O  
ATOM    519  CB  PHE A  72     -40.162 -29.671  17.381  1.00 13.96           C  
ATOM    520  CG  PHE A  72     -41.129 -30.623  16.731  1.00 15.62           C  
ATOM    521  CD1 PHE A  72     -41.630 -31.711  17.440  1.00 16.45           C  
ATOM    522  CD2 PHE A  72     -41.520 -30.432  15.422  1.00 16.64           C  
ATOM    523  CE1 PHE A  72     -42.545 -32.556  16.802  1.00 17.34           C  
ATOM    524  CE2 PHE A  72     -42.407 -31.290  14.802  1.00 19.43           C  
ATOM    525  CZ  PHE A  72     -42.922 -32.368  15.495  1.00 17.44           C  
ATOM    526  N   VAL A  73     -40.418 -26.888  19.864  1.00 12.34           N  
ATOM    527  CA  VAL A  73     -39.643 -26.050  20.778  1.00 14.34           C  
ATOM    528  C   VAL A  73     -40.501 -25.903  22.054  1.00 15.76           C  
ATOM    529  O   VAL A  73     -41.682 -25.587  21.940  1.00 15.85           O  
ATOM    530  CB  VAL A  73     -39.295 -24.677  20.212  1.00 13.78           C  
ATOM    531  CG1 VAL A  73     -38.594 -23.838  21.283  1.00 15.96           C  
ATOM    532  CG2 VAL A  73     -38.369 -24.767  18.989  1.00 16.41           C  
ATOM    533  N   THR A  74     -39.899 -26.175  23.202  1.00 17.37           N  
ATOM    534  CA  THR A  74     -40.692 -26.041  24.449  1.00 17.75           C  
ATOM    535  C   THR A  74     -41.184 -24.630  24.604  1.00 19.19           C  
ATOM    536  O   THR A  74     -40.401 -23.686  24.579  1.00 16.79           O  
ATOM    537  CB  THR A  74     -39.836 -26.466  25.654  1.00 18.15           C  
ATOM    538  OG1 THR A  74     -39.381 -27.798  25.453  1.00 21.31           O  
ATOM    539  CG2 THR A  74     -40.654 -26.383  26.941  1.00 19.49           C  
ATOM    540  N   PRO A  75     -42.475 -24.417  24.880  1.00 20.72           N  
ATOM    541  CA  PRO A  75     -42.996 -23.072  25.057  1.00 23.53           C  
ATOM    542  C   PRO A  75     -42.256 -22.331  26.165  1.00 26.10           C  
ATOM    543  O   PRO A  75     -42.005 -22.897  27.229  1.00 28.47           O  
ATOM    544  CB  PRO A  75     -44.471 -23.262  25.349  1.00 24.55           C  
ATOM    545  CG  PRO A  75     -44.784 -24.683  25.063  1.00 23.47           C  
ATOM    546  CD  PRO A  75     -43.517 -25.463  24.939  1.00 23.11           C  
ATOM    547  N   GLY A  76     -41.759 -21.139  25.863  1.00 27.98           N  
ATOM    548  CA  GLY A  76     -41.017 -20.305  26.783  1.00 27.58           C  
ATOM    549  C   GLY A  76     -39.620 -20.776  27.136  1.00 28.37           C  
ATOM    550  O   GLY A  76     -39.076 -20.482  28.216  1.00 29.00           O  
ATOM    551  N   ASP A  77     -39.028 -21.612  26.278  1.00 25.53           N  
ATOM    552  CA  ASP A  77     -37.700 -22.144  26.553  1.00 23.92           C  
ATOM    553  C   ASP A  77     -36.726 -20.970  26.593  1.00 22.70           C  
ATOM    554  O   ASP A  77     -36.404 -20.391  25.568  1.00 21.81           O  
ATOM    555  CB  ASP A  77     -37.266 -23.134  25.460  1.00 23.10           C  
ATOM    556  CG  ASP A  77     -36.055 -23.946  25.878  1.00 23.05           C  
ATOM    557  OD1 ASP A  77     -35.170 -23.388  26.545  1.00 22.10           O  
ATOM    558  OD2 ASP A  77     -35.979 -25.159  25.567  1.00 23.55           O  
ATOM    559  N   LYS A  78     -36.203 -20.666  27.784  1.00 22.07           N  
ATOM    560  CA  LYS A  78     -35.271 -19.566  27.917  1.00 23.32           C  
ATOM    561  C   LYS A  78     -33.918 -19.850  27.271  1.00 21.19           C  
ATOM    562  O   LYS A  78     -33.172 -18.867  27.098  1.00 22.62           O  
ATOM    563  CB  LYS A  78     -35.020 -19.192  29.388  1.00 25.93           C  
ATOM    564  CG  LYS A  78     -34.161 -20.189  30.134  1.00 29.93           C  
ATOM    565  CD  LYS A  78     -34.957 -21.351  30.708  1.00 32.41           C  
ATOM    566  CE  LYS A  78     -35.463 -21.030  32.113  1.00 34.80           C  
ATOM    567  NZ  LYS A  78     -34.354 -20.954  33.105  1.00 35.96           N  
ATOM    568  N   ARG A  79     -33.644 -21.094  26.905  1.00 18.08           N  
ATOM    569  CA  ARG A  79     -32.341 -21.372  26.269  1.00 16.02           C  
ATOM    570  C   ARG A  79     -32.366 -21.085  24.773  1.00 16.76           C  
ATOM    571  O   ARG A  79     -31.346 -21.119  24.088  1.00 16.24           O  
ATOM    572  CB  ARG A  79     -31.909 -22.810  26.517  1.00 17.31           C  
ATOM    573  CG  ARG A  79     -31.909 -23.261  27.963  1.00 19.65           C  
ATOM    574  CD  ARG A  79     -31.982 -24.773  28.059  1.00 21.41           C  
ATOM    575  NE  ARG A  79     -33.301 -25.272  27.679  1.00 22.88           N  
ATOM    576  CZ  ARG A  79     -33.826 -26.454  27.974  1.00 24.39           C  
ATOM    577  NH1 ARG A  79     -33.145 -27.302  28.726  1.00 24.31           N  
ATOM    578  NH2 ARG A  79     -35.046 -26.753  27.527  1.00 25.24           N  
ATOM    579  N   VAL A  80     -33.548 -20.912  24.209  1.00 14.73           N  
ATOM    580  CA  VAL A  80     -33.680 -20.612  22.786  1.00 14.34           C  
ATOM    581  C   VAL A  80     -33.592 -19.130  22.559  1.00 13.77           C  
ATOM    582  O   VAL A  80     -34.446 -18.331  22.996  1.00 17.67           O  
ATOM    583  CB  VAL A  80     -34.980 -21.229  22.223  1.00 14.24           C  
ATOM    584  CG1 VAL A  80     -35.190 -20.791  20.782  1.00 16.47           C  
ATOM    585  CG2 VAL A  80     -34.889 -22.751  22.290  1.00 16.46           C  
ATOM    586  N   ILE A  81     -32.557 -18.677  21.842  1.00 13.29           N  
ATOM    587  CA  ILE A  81     -32.385 -17.248  21.584  1.00 14.79           C  
ATOM    588  C   ILE A  81     -33.333 -16.765  20.490  1.00 15.16           C  
ATOM    589  O   ILE A  81     -33.836 -15.657  20.570  1.00 15.53           O  
ATOM    590  CB  ILE A  81     -30.922 -16.964  21.181  1.00 16.37           C  
ATOM    591  CG1 ILE A  81     -29.997 -17.405  22.319  1.00 19.60           C  
ATOM    592  CG2 ILE A  81     -30.709 -15.519  20.741  1.00 16.73           C  
ATOM    593  CD1 ILE A  81     -30.167 -16.654  23.623  1.00 24.55           C  
ATOM    594  N   ALA A  82     -33.482 -17.566  19.428  1.00 12.73           N  
ATOM    595  CA  ALA A  82     -34.383 -17.193  18.346  1.00 13.26           C  
ATOM    596  C   ALA A  82     -34.733 -18.484  17.600  1.00 12.72           C  
ATOM    597  O   ALA A  82     -33.969 -19.451  17.687  1.00 13.00           O  
ATOM    598  CB  ALA A  82     -33.709 -16.228  17.399  1.00 15.08           C  
ATOM    599  N   PHE A  83     -35.950 -18.519  17.025  1.00 10.28           N  
ATOM    600  CA  PHE A  83     -36.269 -19.719  16.263  1.00  9.92           C  
ATOM    601  C   PHE A  83     -37.292 -19.372  15.188  1.00  9.98           C  
ATOM    602  O   PHE A  83     -37.893 -18.303  15.230  1.00 11.07           O  
ATOM    603  CB  PHE A  83     -36.828 -20.834  17.126  1.00 11.38           C  
ATOM    604  CG  PHE A  83     -38.184 -20.637  17.728  1.00 13.30           C  
ATOM    605  CD1 PHE A  83     -39.259 -21.337  17.224  1.00 16.76           C  
ATOM    606  CD2 PHE A  83     -38.357 -19.838  18.844  1.00 16.57           C  
ATOM    607  CE1 PHE A  83     -40.517 -21.207  17.769  1.00 18.75           C  
ATOM    608  CE2 PHE A  83     -39.622 -19.704  19.406  1.00 18.23           C  
ATOM    609  CZ  PHE A  83     -40.692 -20.402  18.882  1.00 19.55           C  
ATOM    610  N   THR A  84     -37.435 -20.244  14.212  1.00 10.41           N  
ATOM    611  CA  THR A  84     -38.524 -20.123  13.235  1.00 11.30           C  
ATOM    612  C   THR A  84     -39.474 -21.308  13.483  1.00  8.91           C  
ATOM    613  O   THR A  84     -39.086 -22.372  13.958  1.00  9.93           O  
ATOM    614  CB  THR A  84     -38.015 -20.245  11.771  1.00 11.05           C  
ATOM    615  OG1 THR A  84     -37.640 -21.587  11.441  1.00 12.72           O  
ATOM    616  CG2 THR A  84     -36.803 -19.353  11.470  1.00 12.33           C  
ATOM    617  N   PRO A  85     -40.726 -21.120  13.028  1.00 11.52           N  
ATOM    618  CA  PRO A  85     -41.642 -22.215  12.962  1.00 12.00           C  
ATOM    619  C   PRO A  85     -41.137 -23.263  11.951  1.00 11.72           C  
ATOM    620  O   PRO A  85     -40.294 -23.007  11.080  1.00 11.75           O  
ATOM    621  CB  PRO A  85     -42.898 -21.564  12.341  1.00 11.53           C  
ATOM    622  CG  PRO A  85     -42.774 -20.119  12.718  1.00 13.95           C  
ATOM    623  CD  PRO A  85     -41.271 -19.819  12.575  1.00 13.16           C  
ATOM    624  N   ILE A  86     -41.687 -24.452  12.100  1.00 10.78           N  
ATOM    625  CA  ILE A  86     -41.471 -25.532  11.144  1.00 10.77           C  
ATOM    626  C   ILE A  86     -42.136 -25.176   9.817  1.00 12.20           C  
ATOM    627  O   ILE A  86     -43.305 -24.713   9.685  1.00 12.53           O  
ATOM    628  CB  ILE A  86     -42.105 -26.820  11.715  1.00 13.01           C  
ATOM    629  CG1 ILE A  86     -41.372 -27.275  12.968  1.00 13.06           C  
ATOM    630  CG2 ILE A  86     -42.148 -27.940  10.675  1.00 15.30           C  
ATOM    631  CD1 ILE A  86     -40.038 -27.996  12.741  1.00 15.16           C  
ATOM    632  N   ILE A  87     -41.464 -25.453   8.719  1.00  9.82           N  
ATOM    633  CA  ILE A  87     -41.906 -25.259   7.355  1.00 10.21           C  
ATOM    634  C   ILE A  87     -41.662 -26.549   6.564  1.00 10.80           C  
ATOM    635  O   ILE A  87     -40.791 -27.318   6.893  1.00 11.76           O  
ATOM    636  CB  ILE A  87     -41.292 -24.075   6.595  1.00 12.08           C  
ATOM    637  CG1 ILE A  87     -39.761 -24.119   6.630  1.00 12.94           C  
ATOM    638  CG2 ILE A  87     -41.760 -22.743   7.216  1.00 13.49           C  
ATOM    639  CD1 ILE A  87     -39.101 -23.018   5.824  1.00 13.62           C  
ATOM    640  N   GLY A  88     -42.585 -26.733   5.637  1.00  9.53           N  
ATOM    641  CA  GLY A  88     -42.492 -27.856   4.694  1.00  9.20           C  
ATOM    642  C   GLY A  88     -42.192 -27.333   3.300  1.00  9.73           C  
ATOM    643  O   GLY A  88     -41.931 -26.157   3.007  1.00 10.59           O  
ATOM    644  N   GLY A  89     -42.087 -28.258   2.345  1.00  7.84           N  
ATOM    645  CA  GLY A  89     -41.748 -27.899   0.954  1.00  9.60           C  
ATOM    646  C   GLY A  89     -42.513 -26.761   0.353  1.00 11.34           C  
ATOM    647  O   GLY A  89     -43.748 -26.672   0.446  1.00 11.09           O  
ATOM    648  N   GLY A  90     -41.812 -25.802  -0.259  1.00 10.87           N  
ATOM    649  CA  GLY A  90     -42.459 -24.668  -0.906  1.00 11.41           C  
ATOM    650  C   GLY A  90     -42.844 -23.540   0.063  1.00 13.79           C  
ATOM    651  O   GLY A  90     -43.408 -22.557  -0.419  1.00 16.02           O  
ATOM    652  N   GLU A  91     -42.467 -23.701   1.321  1.00 12.59           N  
ATOM    653  CA  GLU A  91     -42.734 -22.650   2.306  1.00 12.08           C  
ATOM    654  C   GLU A  91     -41.476 -21.882   2.684  1.00 12.26           C  
ATOM    655  O   GLU A  91     -40.359 -22.291   2.439  1.00 12.33           O  
ATOM    656  CB  GLU A  91     -43.369 -23.193   3.576  1.00  9.89           C  
ATOM    657  CG  GLU A  91     -44.718 -23.862   3.288  1.00 12.15           C  
ATOM    658  CD  GLU A  91     -45.372 -24.373   4.548  1.00 13.71           C  
ATOM    659  OE1 GLU A  91     -46.655 -24.385   4.550  1.00 17.16           O  
ATOM    660  OE2 GLU A  91     -44.789 -24.894   5.504  1.00 13.86           O  
ATOM    661  N   LYS A  92     -41.701 -20.655   3.154  1.00 12.00           N  
ATOM    662  CA  LYS A  92     -40.608 -19.760   3.543  1.00 12.58           C  
ATOM    663  C   LYS A  92     -40.940 -19.108   4.887  1.00 12.30           C  
ATOM    664  O   LYS A  92     -42.118 -18.927   5.197  1.00 12.95           O  
ATOM    665  CB  LYS A  92     -40.418 -18.656   2.492  1.00 14.65           C  
ATOM    666  CG  LYS A  92     -40.084 -19.162   1.085  1.00 18.41           C  
ATOM    667  CD  LYS A  92     -40.078 -18.027   0.067  1.00 23.49           C  
ATOM    668  CE  LYS A  92     -40.060 -18.562  -1.355  1.00 26.20           C  
ATOM    669  NZ  LYS A  92     -40.320 -17.488  -2.364  1.00 30.55           N  
ATOM    670  N   THR A  93     -39.910 -18.760   5.664  1.00 11.06           N  
ATOM    671  CA  THR A  93     -40.185 -18.059   6.931  1.00  9.52           C  
ATOM    672  C   THR A  93     -38.931 -17.240   7.269  1.00 11.70           C  
ATOM    673  O   THR A  93     -38.004 -17.215   6.465  1.00 10.88           O  
ATOM    674  CB  THR A  93     -40.550 -19.042   8.037  1.00 12.40           C  
ATOM    675  OG1 THR A  93     -40.995 -18.272   9.197  1.00 12.86           O  
ATOM    676  CG2 THR A  93     -39.456 -19.987   8.474  1.00 13.08           C  
ATOM    677  N   SER A  94     -38.923 -16.570   8.415  1.00  9.99           N  
ATOM    678  CA  SER A  94     -37.671 -15.834   8.737  1.00  9.55           C  
ATOM    679  C   SER A  94     -37.752 -15.546  10.229  1.00 11.11           C  
ATOM    680  O   SER A  94     -38.781 -15.740  10.849  1.00 11.99           O  
ATOM    681  CB  SER A  94     -37.482 -14.567   7.927  1.00 12.68           C  
ATOM    682  OG  SER A  94     -38.551 -13.670   8.168  1.00 15.10           O  
ATOM    683  N   VAL A  95     -36.634 -15.047  10.758  1.00 10.19           N  
ATOM    684  CA  VAL A  95     -36.649 -14.644  12.177  1.00 10.30           C  
ATOM    685  C   VAL A  95     -35.622 -13.504  12.253  1.00 12.19           C  
ATOM    686  O   VAL A  95     -34.593 -13.532  11.580  1.00 14.54           O  
ATOM    687  CB  VAL A  95     -36.282 -15.776  13.146  1.00 12.47           C  
ATOM    688  CG1 VAL A  95     -34.937 -16.401  12.815  1.00 13.35           C  
ATOM    689  CG2 VAL A  95     -36.346 -15.339  14.615  1.00 14.64           C  
ATOM    690  N   LYS A  96     -35.984 -12.516  13.053  1.00 13.05           N  
ATOM    691  CA  LYS A  96     -35.071 -11.377  13.251  1.00 13.59           C  
ATOM    692  C   LYS A  96     -34.762 -11.296  14.726  1.00 15.56           C  
ATOM    693  O   LYS A  96     -35.675 -11.423  15.540  1.00 18.12           O  
ATOM    694  CB  LYS A  96     -35.705 -10.076  12.729  1.00 16.75           C  
ATOM    695  CG  LYS A  96     -34.836  -8.844  13.036  1.00 21.18           C  
ATOM    696  CD  LYS A  96     -35.254  -7.661  12.176  1.00 24.50           C  
ATOM    697  CE  LYS A  96     -36.712  -7.286  12.345  1.00 27.59           C  
ATOM    698  NZ  LYS A  96     -37.041  -5.979  11.688  1.00 30.12           N  
ATOM    699  N   PHE A  97     -33.510 -11.098  15.102  1.00 14.53           N  
ATOM    700  CA  PHE A  97     -33.184 -11.036  16.540  1.00 15.89           C  
ATOM    701  C   PHE A  97     -32.190  -9.905  16.793  1.00 16.57           C  
ATOM    702  O   PHE A  97     -31.541  -9.437  15.863  1.00 16.46           O  
ATOM    703  CB  PHE A  97     -32.606 -12.347  17.049  1.00 16.90           C  
ATOM    704  CG  PHE A  97     -31.456 -12.918  16.300  1.00 19.85           C  
ATOM    705  CD1 PHE A  97     -31.678 -13.787  15.231  1.00 18.85           C  
ATOM    706  CD2 PHE A  97     -30.151 -12.600  16.642  1.00 19.15           C  
ATOM    707  CE1 PHE A  97     -30.595 -14.298  14.527  1.00 19.96           C  
ATOM    708  CE2 PHE A  97     -29.081 -13.128  15.953  1.00 21.96           C  
ATOM    709  CZ  PHE A  97     -29.308 -13.989  14.890  1.00 20.94           C  
ATOM    710  N   LYS A  98     -32.157  -9.485  18.052  1.00 16.74           N  
ATOM    711  CA  LYS A  98     -31.230  -8.394  18.385  1.00 18.45           C  
ATOM    712  C   LYS A  98     -29.847  -8.966  18.613  1.00 16.58           C  
ATOM    713  O   LYS A  98     -29.684  -9.943  19.333  1.00 18.82           O  
ATOM    714  CB  LYS A  98     -31.752  -7.691  19.643  1.00 21.62           C  
ATOM    715  CG  LYS A  98     -32.804  -6.634  19.284  1.00 24.91           C  
ATOM    716  CD  LYS A  98     -33.358  -6.027  20.569  1.00 29.11           C  
ATOM    717  CE  LYS A  98     -34.869  -5.847  20.416  1.00 31.37           C  
ATOM    718  NZ  LYS A  98     -35.486  -7.160  20.045  1.00 33.27           N  
ATOM    719  N   VAL A  99     -28.859  -8.327  17.989  1.00 16.99           N  
ATOM    720  CA  VAL A  99     -27.461  -8.720  18.060  1.00 18.52           C  
ATOM    721  C   VAL A  99     -26.911  -8.544  19.477  1.00 20.01           C  
ATOM    722  O   VAL A  99     -26.086  -9.361  19.906  1.00 19.39           O  
ATOM    723  CB  VAL A  99     -26.614  -7.985  17.020  1.00 19.66           C  
ATOM    724  CG1 VAL A  99     -25.110  -8.243  17.170  1.00 22.94           C  
ATOM    725  CG2 VAL A  99     -26.975  -8.387  15.587  1.00 21.22           C  
ATOM    726  N   SER A 100     -27.536  -7.696  20.284  1.00 21.41           N  
ATOM    727  CA  SER A 100     -27.166  -7.547  21.697  1.00 22.72           C  
ATOM    728  C   SER A 100     -27.504  -8.745  22.551  1.00 22.84           C  
ATOM    729  O   SER A 100     -27.010  -8.932  23.687  1.00 23.80           O  
ATOM    730  CB  SER A 100     -27.837  -6.272  22.240  1.00 24.08           C  
ATOM    731  OG  SER A 100     -29.244  -6.479  22.344  1.00 23.58           O  
ATOM    732  N   ALA A 101     -28.340  -9.678  22.079  1.00 21.21           N  
ATOM    733  CA  ALA A 101     -28.630 -10.903  22.800  1.00 21.76           C  
ATOM    734  C   ALA A 101     -27.462 -11.879  22.722  1.00 22.18           C  
ATOM    735  O   ALA A 101     -27.433 -12.832  23.509  1.00 25.85           O  
ATOM    736  CB  ALA A 101     -29.907 -11.546  22.241  1.00 21.74           C  
ATOM    737  N   LEU A 102     -26.496 -11.669  21.844  1.00 19.45           N  
ATOM    738  CA  LEU A 102     -25.363 -12.544  21.696  1.00 21.28           C  
ATOM    739  C   LEU A 102     -24.142 -11.970  22.436  1.00 22.14           C  
ATOM    740  O   LEU A 102     -23.941 -10.769  22.512  1.00 22.73           O  
ATOM    741  CB  LEU A 102     -24.973 -12.728  20.236  1.00 20.16           C  
ATOM    742  CG  LEU A 102     -26.123 -13.176  19.306  1.00 22.00           C  
ATOM    743  CD1 LEU A 102     -25.597 -13.324  17.893  1.00 21.38           C  
ATOM    744  CD2 LEU A 102     -26.709 -14.487  19.823  1.00 22.21           C  
ATOM    745  N   SER A 103     -23.326 -12.908  22.868  1.00 22.98           N  
ATOM    746  CA  SER A 103     -22.098 -12.519  23.566  1.00 23.48           C  
ATOM    747  C   SER A 103     -20.901 -12.985  22.759  1.00 23.94           C  
ATOM    748  O   SER A 103     -20.906 -14.037  22.119  1.00 21.84           O  
ATOM    749  CB  SER A 103     -22.095 -13.170  24.946  1.00 25.13           C  
ATOM    750  OG  SER A 103     -20.803 -12.927  25.516  1.00 25.21           O  
ATOM    751  N   LYS A 104     -19.793 -12.261  22.920  1.00 23.55           N  
ATOM    752  CA  LYS A 104     -18.528 -12.670  22.339  1.00 24.14           C  
ATOM    753  C   LYS A 104     -17.869 -13.760  23.184  1.00 22.73           C  
ATOM    754  O   LYS A 104     -16.915 -14.401  22.733  1.00 22.68           O  
ATOM    755  CB  LYS A 104     -17.596 -11.447  22.275  1.00 26.62           C  
ATOM    756  CG  LYS A 104     -18.082 -10.386  21.288  1.00 29.72           C  
ATOM    757  CD  LYS A 104     -17.059  -9.270  21.135  1.00 33.53           C  
ATOM    758  CE  LYS A 104     -17.362  -8.428  19.899  1.00 35.12           C  
ATOM    759  NZ  LYS A 104     -16.323  -7.369  19.707  1.00 36.54           N  
ATOM    760  N   ASP A 105     -18.367 -14.048  24.391  1.00 19.44           N  
ATOM    761  CA  ASP A 105     -17.762 -15.059  25.232  1.00 20.46           C  
ATOM    762  C   ASP A 105     -18.277 -16.474  25.045  1.00 21.65           C  
ATOM    763  O   ASP A 105     -17.688 -17.421  25.564  1.00 22.45           O  
ATOM    764  CB  ASP A 105     -18.004 -14.603  26.692  1.00 21.56           C  
ATOM    765  CG  ASP A 105     -17.322 -13.268  26.953  1.00 21.96           C  
ATOM    766  OD1 ASP A 105     -16.353 -12.925  26.241  1.00 21.93           O  
ATOM    767  OD2 ASP A 105     -17.730 -12.540  27.887  1.00 23.33           O  
ATOM    768  N   GLU A 106     -19.362 -16.627  24.261  1.00 19.64           N  
ATOM    769  CA  GLU A 106     -20.042 -17.890  24.123  1.00 22.04           C  
ATOM    770  C   GLU A 106     -20.018 -18.506  22.734  1.00 18.43           C  
ATOM    771  O   GLU A 106     -19.748 -17.747  21.824  1.00 19.41           O  
ATOM    772  CB  GLU A 106     -21.544 -17.585  24.436  1.00 24.77           C  
ATOM    773  CG  GLU A 106     -21.739 -17.492  25.947  1.00 30.29           C  
ATOM    774  CD  GLU A 106     -21.663 -18.875  26.575  1.00 32.65           C  
ATOM    775  OE1 GLU A 106     -21.363 -19.848  25.840  1.00 35.04           O  
ATOM    776  OE2 GLU A 106     -21.910 -19.000  27.797  1.00 35.00           O  
ATOM    777  N   ALA A 107     -20.273 -19.814  22.643  1.00 17.18           N  
ATOM    778  CA  ALA A 107     -20.335 -20.425  21.326  1.00 14.74           C  
ATOM    779  C   ALA A 107     -21.818 -20.733  21.007  1.00 12.97           C  
ATOM    780  O   ALA A 107     -22.481 -21.103  21.963  1.00 13.73           O  
ATOM    781  CB  ALA A 107     -19.563 -21.728  21.312  1.00 17.08           C  
ATOM    782  N   TYR A 108     -22.180 -20.564  19.752  1.00 12.88           N  
ATOM    783  CA  TYR A 108     -23.614 -20.755  19.416  1.00 11.41           C  
ATOM    784  C   TYR A 108     -23.777 -21.783  18.300  1.00 12.68           C  
ATOM    785  O   TYR A 108     -22.910 -21.936  17.448  1.00 14.53           O  
ATOM    786  CB  TYR A 108     -24.253 -19.447  18.927  1.00 12.23           C  
ATOM    787  CG  TYR A 108     -24.264 -18.371  20.000  1.00 14.98           C  
ATOM    788  CD1 TYR A 108     -25.207 -18.412  21.012  1.00 14.94           C  
ATOM    789  CD2 TYR A 108     -23.292 -17.384  20.005  1.00 16.28           C  
ATOM    790  CE1 TYR A 108     -25.203 -17.441  22.018  1.00 16.56           C  
ATOM    791  CE2 TYR A 108     -23.281 -16.423  21.001  1.00 17.79           C  
ATOM    792  CZ  TYR A 108     -24.234 -16.480  21.991  1.00 18.92           C  
ATOM    793  OH  TYR A 108     -24.196 -15.486  22.958  1.00 21.88           O  
ATOM    794  N   THR A 109     -24.930 -22.463  18.321  1.00 10.73           N  
ATOM    795  CA  THR A 109     -25.200 -23.474  17.315  1.00 11.50           C  
ATOM    796  C   THR A 109     -26.653 -23.279  16.818  1.00 11.20           C  
ATOM    797  O   THR A 109     -27.433 -22.990  17.706  1.00 12.77           O  
ATOM    798  CB  THR A 109     -25.142 -24.871  17.930  1.00 12.58           C  
ATOM    799  OG1 THR A 109     -23.796 -25.158  18.415  1.00 14.77           O  
ATOM    800  CG2 THR A 109     -25.540 -25.984  16.944  1.00 12.61           C  
ATOM    801  N   TYR A 110     -26.810 -23.416  15.513  1.00  9.85           N  
ATOM    802  CA  TYR A 110     -28.213 -23.347  15.020  1.00  9.78           C  
ATOM    803  C   TYR A 110     -28.504 -24.767  14.565  1.00 10.39           C  
ATOM    804  O   TYR A 110     -27.637 -25.535  14.156  1.00  9.96           O  
ATOM    805  CB  TYR A 110     -28.473 -22.340  13.943  1.00 10.28           C  
ATOM    806  CG  TYR A 110     -27.658 -22.474  12.686  1.00  9.86           C  
ATOM    807  CD1 TYR A 110     -26.479 -21.714  12.589  1.00 13.31           C  
ATOM    808  CD2 TYR A 110     -27.986 -23.315  11.644  1.00 10.44           C  
ATOM    809  CE1 TYR A 110     -25.690 -21.798  11.453  1.00 14.58           C  
ATOM    810  CE2 TYR A 110     -27.189 -23.393  10.506  1.00 12.53           C  
ATOM    811  CZ  TYR A 110     -26.049 -22.619  10.427  1.00 15.09           C  
ATOM    812  OH  TYR A 110     -25.272 -22.689   9.291  1.00 17.08           O  
ATOM    813  N   PHE A 111     -29.775 -25.221  14.708  1.00  9.77           N  
ATOM    814  CA  PHE A 111     -30.062 -26.613  14.397  1.00 10.18           C  
ATOM    815  C   PHE A 111     -31.584 -26.749  14.180  1.00 11.16           C  
ATOM    816  O   PHE A 111     -32.304 -25.798  14.421  1.00  9.83           O  
ATOM    817  CB  PHE A 111     -29.686 -27.560  15.552  1.00 11.58           C  
ATOM    818  CG  PHE A 111     -30.424 -27.225  16.851  1.00 14.15           C  
ATOM    819  CD1 PHE A 111     -29.964 -26.148  17.618  1.00 16.77           C  
ATOM    820  CD2 PHE A 111     -31.521 -27.947  17.253  1.00 16.80           C  
ATOM    821  CE1 PHE A 111     -30.615 -25.806  18.793  1.00 18.80           C  
ATOM    822  CE2 PHE A 111     -32.162 -27.616  18.450  1.00 18.49           C  
ATOM    823  CZ  PHE A 111     -31.714 -26.540  19.187  1.00 17.33           C  
ATOM    824  N   CYS A 112     -31.927 -27.882  13.584  1.00 10.01           N  
ATOM    825  CA  CYS A 112     -33.360 -28.173  13.327  1.00 11.24           C  
ATOM    826  C   CYS A 112     -33.886 -29.055  14.431  1.00 11.16           C  
ATOM    827  O   CYS A 112     -33.277 -30.086  14.766  1.00 12.93           O  
ATOM    828  CB  CYS A 112     -33.378 -28.877  11.966  1.00 10.13           C  
ATOM    829  SG  CYS A 112     -35.068 -29.376  11.455  1.00 11.67           S  
ATOM    830  N   SER A 113     -35.075 -28.753  15.060  1.00 12.41           N  
ATOM    831  CA  SER A 113     -35.540 -29.546  16.151  1.00 13.00           C  
ATOM    832  C   SER A 113     -36.655 -30.569  15.800  1.00 13.37           C  
ATOM    833  O   SER A 113     -37.118 -31.176  16.746  1.00 14.60           O  
ATOM    834  CB  SER A 113     -36.040 -28.707  17.354  1.00 13.27           C  
ATOM    835  OG  SER A 113     -37.050 -27.838  16.926  1.00 13.97           O  
ATOM    836  N   TYR A 114     -36.942 -30.665  14.506  1.00 16.85           N  
ATOM    837  CA  TYR A 114     -37.916 -31.716  14.113  1.00 18.01           C  
ATOM    838  C   TYR A 114     -37.304 -33.025  14.571  1.00 19.75           C  
ATOM    839  O   TYR A 114     -36.103 -33.262  14.330  1.00 20.07           O  
ATOM    840  CB  TYR A 114     -38.008 -31.665  12.582  1.00 17.40           C  
ATOM    841  CG  TYR A 114     -39.034 -32.632  12.018  1.00 20.29           C  
ATOM    842  CD1 TYR A 114     -38.648 -33.944  11.742  1.00 21.10           C  
ATOM    843  CD2 TYR A 114     -40.325 -32.227  11.773  1.00 20.53           C  
ATOM    844  CE1 TYR A 114     -39.576 -34.838  11.235  1.00 23.08           C  
ATOM    845  CE2 TYR A 114     -41.265 -33.132  11.283  1.00 22.58           C  
ATOM    846  CZ  TYR A 114     -40.862 -34.413  11.005  1.00 24.84           C  
ATOM    847  OH  TYR A 114     -41.796 -35.317  10.502  1.00 26.70           O  
ATOM    848  N   PRO A 115     -38.067 -33.912  15.176  1.00 20.79           N  
ATOM    849  CA  PRO A 115     -37.567 -35.179  15.680  1.00 22.44           C  
ATOM    850  C   PRO A 115     -36.641 -35.894  14.718  1.00 23.75           C  
ATOM    851  O   PRO A 115     -36.922 -36.080  13.533  1.00 24.90           O  
ATOM    852  CB  PRO A 115     -38.839 -35.987  15.950  1.00 23.17           C  
ATOM    853  CG  PRO A 115     -39.824 -34.945  16.349  1.00 22.42           C  
ATOM    854  CD  PRO A 115     -39.506 -33.740  15.511  1.00 22.08           C  
ATOM    855  N   GLY A 116     -35.430 -36.149  15.216  1.00 24.61           N  
ATOM    856  CA  GLY A 116     -34.420 -36.872  14.464  1.00 25.22           C  
ATOM    857  C   GLY A 116     -33.544 -36.093  13.525  1.00 25.56           C  
ATOM    858  O   GLY A 116     -32.723 -36.731  12.842  1.00 28.26           O  
ATOM    859  N   HIS A 117     -33.673 -34.780  13.391  1.00 23.11           N  
ATOM    860  CA  HIS A 117     -32.889 -33.985  12.469  1.00 22.10           C  
ATOM    861  C   HIS A 117     -31.678 -33.308  13.102  1.00 22.96           C  
ATOM    862  O   HIS A 117     -30.723 -32.959  12.401  1.00 22.51           O  
ATOM    863  CB  HIS A 117     -33.780 -32.876  11.884  1.00 20.75           C  
ATOM    864  CG  HIS A 117     -34.809 -33.352  10.887  1.00 20.61           C  
ATOM    865  ND1 HIS A 117     -35.389 -32.493   9.993  1.00 20.88           N  
ATOM    866  CD2 HIS A 117     -35.346 -34.563  10.642  1.00 20.83           C  
ATOM    867  CE1 HIS A 117     -36.269 -33.139   9.256  1.00 21.69           C  
ATOM    868  NE2 HIS A 117     -36.262 -34.416   9.620  1.00 20.91           N  
ATOM    869  N   PHE A 118     -31.697 -33.100  14.432  1.00 24.25           N  
ATOM    870  CA  PHE A 118     -30.626 -32.296  15.013  1.00 27.29           C  
ATOM    871  C   PHE A 118     -29.225 -32.839  14.838  1.00 28.31           C  
ATOM    872  O   PHE A 118     -28.332 -31.989  14.656  1.00 29.07           O  
ATOM    873  CB  PHE A 118     -30.911 -31.880  16.453  1.00 28.75           C  
ATOM    874  CG  PHE A 118     -30.312 -32.679  17.562  1.00 29.85           C  
ATOM    875  CD1 PHE A 118     -30.792 -33.920  17.916  1.00 31.47           C  
ATOM    876  CD2 PHE A 118     -29.247 -32.154  18.278  1.00 31.34           C  
ATOM    877  CE1 PHE A 118     -30.217 -34.634  18.957  1.00 32.95           C  
ATOM    878  CE2 PHE A 118     -28.677 -32.844  19.324  1.00 31.72           C  
ATOM    879  CZ  PHE A 118     -29.160 -34.092  19.659  1.00 31.99           C  
ATOM    880  N   SER A 119     -29.007 -34.142  14.827  1.00 29.23           N  
ATOM    881  CA  SER A 119     -27.639 -34.639  14.690  1.00 30.88           C  
ATOM    882  C   SER A 119     -26.926 -34.259  13.415  1.00 30.88           C  
ATOM    883  O   SER A 119     -25.687 -34.143  13.449  1.00 31.19           O  
ATOM    884  CB  SER A 119     -27.611 -36.162  14.879  1.00 32.98           C  
ATOM    885  OG  SER A 119     -28.294 -36.806  13.828  1.00 35.62           O  
ATOM    886  N   MET A 120     -27.596 -34.078  12.280  1.00 28.57           N  
ATOM    887  CA  MET A 120     -26.964 -33.742  11.019  1.00 27.93           C  
ATOM    888  C   MET A 120     -27.214 -32.307  10.570  1.00 24.99           C  
ATOM    889  O   MET A 120     -26.444 -31.639   9.866  1.00 23.96           O  
ATOM    890  CB  MET A 120     -27.487 -34.691   9.913  1.00 31.47           C  
ATOM    891  CG  MET A 120     -26.524 -35.801   9.531  1.00 35.08           C  
ATOM    892  SD  MET A 120     -27.306 -36.990   8.398  1.00 39.17           S  
ATOM    893  CE  MET A 120     -27.738 -38.250   9.605  1.00 37.63           C  
ATOM    894  N   MET A 121     -28.390 -31.820  10.960  1.00 20.37           N  
ATOM    895  CA  MET A 121     -28.828 -30.493  10.562  1.00 17.01           C  
ATOM    896  C   MET A 121     -28.483 -29.485  11.643  1.00 15.63           C  
ATOM    897  O   MET A 121     -29.251 -29.156  12.546  1.00 15.27           O  
ATOM    898  CB  MET A 121     -30.322 -30.610  10.277  1.00 20.71           C  
ATOM    899  CG  MET A 121     -30.859 -29.487   9.422  1.00 22.68           C  
ATOM    900  SD  MET A 121     -32.365 -30.129   8.587  1.00 23.80           S  
ATOM    901  CE  MET A 121     -32.606 -28.685   7.551  1.00 23.19           C  
ATOM    902  N   ARG A 122     -27.256 -28.991  11.533  1.00 15.14           N  
ATOM    903  CA  ARG A 122     -26.745 -28.043  12.511  1.00 14.73           C  
ATOM    904  C   ARG A 122     -25.577 -27.262  11.923  1.00 17.40           C  
ATOM    905  O   ARG A 122     -25.007 -27.724  10.940  1.00 19.77           O  
ATOM    906  CB  ARG A 122     -26.292 -28.764  13.774  1.00 16.48           C  
ATOM    907  CG  ARG A 122     -25.266 -29.881  13.540  1.00 20.17           C  
ATOM    908  CD  ARG A 122     -25.177 -30.749  14.786  1.00 21.65           C  
ATOM    909  NE  ARG A 122     -24.680 -29.983  15.924  1.00 23.62           N  
ATOM    910  CZ  ARG A 122     -24.826 -30.308  17.194  1.00 25.78           C  
ATOM    911  NH1 ARG A 122     -25.490 -31.422  17.500  1.00 28.58           N  
ATOM    912  NH2 ARG A 122     -24.328 -29.548  18.151  1.00 25.86           N  
ATOM    913  N   GLY A 123     -25.318 -26.111  12.532  1.00 13.78           N  
ATOM    914  CA  GLY A 123     -24.241 -25.261  12.005  1.00 13.95           C  
ATOM    915  C   GLY A 123     -23.746 -24.377  13.144  1.00 14.17           C  
ATOM    916  O   GLY A 123     -24.311 -24.431  14.241  1.00 13.83           O  
ATOM    917  N   THR A 124     -22.712 -23.594  12.845  1.00 14.29           N  
ATOM    918  CA  THR A 124     -22.187 -22.696  13.873  1.00 15.64           C  
ATOM    919  C   THR A 124     -22.504 -21.257  13.501  1.00 12.50           C  
ATOM    920  O   THR A 124     -22.552 -20.857  12.346  1.00 12.38           O  
ATOM    921  CB  THR A 124     -20.651 -22.862  14.012  1.00 19.24           C  
ATOM    922  OG1 THR A 124     -20.216 -21.927  15.019  1.00 22.78           O  
ATOM    923  CG2 THR A 124     -19.968 -22.529  12.698  1.00 20.40           C  
ATOM    924  N   LEU A 125     -22.829 -20.448  14.519  1.00 14.01           N  
ATOM    925  CA  LEU A 125     -23.088 -19.024  14.321  1.00 15.21           C  
ATOM    926  C   LEU A 125     -22.089 -18.268  15.208  1.00 15.48           C  
ATOM    927  O   LEU A 125     -21.926 -18.627  16.377  1.00 16.82           O  
ATOM    928  CB  LEU A 125     -24.519 -18.609  14.697  1.00 15.38           C  
ATOM    929  CG  LEU A 125     -24.913 -17.148  14.494  1.00 15.93           C  
ATOM    930  CD1 LEU A 125     -26.341 -17.012  13.960  1.00 15.81           C  
ATOM    931  CD2 LEU A 125     -24.825 -16.348  15.796  1.00 17.83           C  
ATOM    932  N   LYS A 126     -21.463 -17.234  14.656  1.00 19.21           N  
ATOM    933  CA  LYS A 126     -20.542 -16.480  15.510  1.00 22.81           C  
ATOM    934  C   LYS A 126     -20.683 -14.999  15.156  1.00 21.90           C  
ATOM    935  O   LYS A 126     -21.000 -14.648  14.034  1.00 18.68           O  
ATOM    936  CB  LYS A 126     -19.088 -16.893  15.355  1.00 26.28           C  
ATOM    937  CG  LYS A 126     -18.713 -17.270  13.925  1.00 29.02           C  
ATOM    938  CD  LYS A 126     -18.804 -18.789  13.748  1.00 31.88           C  
ATOM    939  CE  LYS A 126     -17.629 -19.481  14.422  1.00 33.97           C  
ATOM    940  NZ  LYS A 126     -17.685 -20.967  14.295  1.00 35.28           N  
ATOM    941  N   LEU A 127     -20.415 -14.219  16.182  1.00 24.74           N  
ATOM    942  CA  LEU A 127     -20.426 -12.769  16.133  1.00 27.64           C  
ATOM    943  C   LEU A 127     -19.067 -12.368  15.572  1.00 30.28           C  
ATOM    944  O   LEU A 127     -18.045 -12.838  16.094  1.00 29.81           O  
ATOM    945  CB  LEU A 127     -20.602 -12.235  17.554  1.00 28.01           C  
ATOM    946  CG  LEU A 127     -21.232 -10.869  17.774  1.00 29.35           C  
ATOM    947  CD1 LEU A 127     -22.613 -10.798  17.139  1.00 28.52           C  
ATOM    948  CD2 LEU A 127     -21.323 -10.575  19.267  1.00 29.45           C  
ATOM    949  N   GLU A 128     -19.081 -11.635  14.478  1.00 33.22           N  
ATOM    950  CA  GLU A 128     -17.860 -11.162  13.835  1.00 37.76           C  
ATOM    951  C   GLU A 128     -17.628  -9.720  14.306  1.00 40.18           C  
ATOM    952  O   GLU A 128     -18.478  -8.858  14.125  1.00 39.38           O  
ATOM    953  CB  GLU A 128     -17.955 -11.185  12.321  1.00 39.58           C  
ATOM    954  CG  GLU A 128     -17.293 -12.367  11.636  1.00 42.62           C  
ATOM    955  CD  GLU A 128     -17.187 -12.115  10.138  1.00 44.25           C  
ATOM    956  OE1 GLU A 128     -18.122 -11.518   9.558  1.00 45.49           O  
ATOM    957  OE2 GLU A 128     -16.153 -12.514   9.565  1.00 45.69           O  
ATOM    958  N   GLU A 129     -16.486  -9.516  14.916  1.00 43.37           N  
ATOM    959  CA  GLU A 129     -16.059  -8.298  15.550  1.00 46.84           C  
ATOM    960  C   GLU A 129     -16.231  -6.999  14.792  1.00 47.68           C  
ATOM    961  O   GLU A 129     -16.627  -6.941  13.615  1.00 48.31           O  
ATOM    962  CB  GLU A 129     -14.575  -8.444  15.962  1.00 47.91           C  
ATOM    963  CG  GLU A 129     -14.344  -9.459  17.069  1.00 49.36           C  
ATOM    964  CD  GLU A 129     -14.300 -10.898  16.602  1.00 49.95           C  
ATOM    965  OE1 GLU A 129     -14.347 -11.815  17.459  1.00 50.86           O  
ATOM    966  OE2 GLU A 129     -14.209 -11.133  15.377  1.00 50.19           O  
ATOM    967  OXT GLU A 129     -15.934  -5.968  15.456  1.00 49.17           O  
TER     968      GLU A 129                                                      
END
MOLECULE T0390.pdb
ATOM   1417  N   ALA    29     -25.126  -7.662   1.817  1.00100.22           N  
ATOM   1418  CA  ALA    29     -24.203  -6.752   2.561  1.00102.70           C  
ATOM   1419  CB  ALA    29     -24.370  -5.286   2.082  1.00105.39           C  
ATOM   1420  C   ALA    29     -24.440  -6.859   4.069  1.00100.61           C  
ATOM   1421  O   ALA    29     -23.542  -6.584   4.874  1.00103.55           O  
ATOM   1422  N   ASP    30     -25.642  -7.297   4.438  1.00 95.26           N  
ATOM   1423  CA  ASP    30     -26.174  -7.076   5.775  1.00 90.56           C  
ATOM   1424  CB  ASP    30     -27.168  -5.921   5.687  1.00 92.74           C  
ATOM   1425  CG  ASP    30     -27.589  -5.421   7.032  1.00 94.90           C  
ATOM   1426  OD1 ASP    30     -26.753  -5.488   7.957  1.00 97.71           O  
ATOM   1427  OD2 ASP    30     -28.748  -4.962   7.166  1.00 95.01           O  
ATOM   1428  C   ASP    30     -26.877  -8.312   6.349  1.00 85.08           C  
ATOM   1429  O   ASP    30     -26.918  -8.504   7.567  1.00 84.01           O  
ATOM   1430  N   ARG    31     -27.450  -9.130   5.464  1.00 79.52           N  
ATOM   1431  CA  ARG    31     -28.160 -10.341   5.860  1.00 73.24           C  
ATOM   1432  CB  ARG    31     -29.676 -10.248   5.558  1.00 73.02           C  
ATOM   1433  CG  ARG    31     -30.128  -9.281   4.458  1.00 71.63           C  
ATOM   1434  CD  ARG    31     -31.576  -8.824   4.658  1.00 70.77           C  
ATOM   1435  NE  ARG    31     -32.323  -9.800   5.444  1.00 70.30           N  
ATOM   1436  CZ  ARG    31     -33.224  -9.495   6.379  1.00 69.91           C  
ATOM   1437  NH1 ARG    31     -33.825 -10.465   7.068  1.00 64.29           N  
ATOM   1438  NH2 ARG    31     -33.513  -8.226   6.639  1.00 66.83           N  
ATOM   1439  C   ARG    31     -27.541 -11.632   5.309  1.00 70.84           C  
ATOM   1440  O   ARG    31     -27.034 -11.668   4.203  1.00 72.53           O  
ATOM   1441  N   HIS    32     -27.579 -12.687   6.107  1.00 67.66           N  
ATOM   1442  CA  HIS    32     -26.995 -13.968   5.743  1.00 65.70           C  
ATOM   1443  CB  HIS    32     -26.038 -14.432   6.839  1.00 64.57           C  
ATOM   1444  CG  HIS    32     -25.079 -13.377   7.294  1.00 65.98           C  
ATOM   1445  ND1 HIS    32     -23.753 -13.361   6.918  1.00 68.45           N  
ATOM   1446  CE1 HIS    32     -23.147 -12.327   7.473  1.00 68.52           C  
ATOM   1447  NE2 HIS    32     -24.034 -11.668   8.197  1.00 70.63           N  
ATOM   1448  CD2 HIS    32     -25.247 -12.309   8.110  1.00 68.60           C  
ATOM   1449  C   HIS    32     -28.097 -15.016   5.529  1.00 64.32           C  
ATOM   1450  O   HIS    32     -29.034 -15.140   6.326  1.00 64.73           O  
ATOM   1451  N   THR    33     -27.991 -15.763   4.443  1.00 64.18           N  
ATOM   1452  CA  THR    33     -29.026 -16.716   4.069  1.00 61.66           C  
ATOM   1453  CB  THR    33     -29.371 -16.572   2.588  1.00 60.48           C  
ATOM   1454  OG1 THR    33     -29.757 -15.222   2.336  1.00 64.06           O  
ATOM   1455  CG2 THR    33     -30.515 -17.473   2.204  1.00 60.36           C  
ATOM   1456  C   THR    33     -28.563 -18.133   4.345  1.00 60.90           C  
ATOM   1457  O   THR    33     -27.470 -18.523   3.937  1.00 61.38           O  
ATOM   1458  N   VAL    34     -29.394 -18.893   5.050  1.00 59.79           N  
ATOM   1459  CA  VAL    34     -29.129 -20.304   5.279  1.00 58.71           C  
ATOM   1460  CB  VAL    34     -28.924 -20.615   6.781  1.00 58.54           C  
ATOM   1461  CG1 VAL    34     -28.753 -22.122   7.003  1.00 54.88           C  
ATOM   1462  CG2 VAL    34     -27.724 -19.842   7.322  1.00 58.10           C  
ATOM   1463  C   VAL    34     -30.292 -21.119   4.737  1.00 58.02           C  
ATOM   1464  O   VAL    34     -31.439 -20.929   5.132  1.00 57.92           O  
ATOM   1465  N   PHE    35     -29.997 -22.021   3.816  1.00 58.93           N  
ATOM   1466  CA  PHE    35     -31.014 -22.945   3.330  1.00 57.38           C  
ATOM   1467  CB  PHE    35     -30.754 -23.313   1.873  1.00 56.05           C  
ATOM   1468  CG  PHE    35     -30.974 -22.168   0.935  1.00 57.38           C  
ATOM   1469  CD1 PHE    35     -29.944 -21.264   0.661  1.00 58.82           C  
ATOM   1470  CE1 PHE    35     -30.149 -20.180  -0.191  1.00 57.97           C  
ATOM   1471  CZ  PHE    35     -31.402 -19.989  -0.771  1.00 58.81           C  
ATOM   1472  CE2 PHE    35     -32.447 -20.877  -0.492  1.00 56.51           C  
ATOM   1473  CD2 PHE    35     -32.230 -21.953   0.363  1.00 58.39           C  
ATOM   1474  C   PHE    35     -31.087 -24.155   4.248  1.00 58.31           C  
ATOM   1475  O   PHE    35     -30.221 -25.039   4.194  1.00 59.87           O  
ATOM   1476  N   TRP    36     -32.103 -24.175   5.118  1.00 56.23           N  
ATOM   1477  CA  TRP    36     -32.240 -25.269   6.062  1.00 54.10           C  
ATOM   1478  CB  TRP    36     -33.030 -24.851   7.307  1.00 52.43           C  
ATOM   1479  CG  TRP    36     -32.664 -25.690   8.480  1.00 50.06           C  
ATOM   1480  CD1 TRP    36     -33.078 -26.955   8.722  1.00 50.33           C  
ATOM   1481  NE1 TRP    36     -32.518 -27.428   9.883  1.00 54.82           N  
ATOM   1482  CE2 TRP    36     -31.709 -26.461  10.418  1.00 54.47           C  
ATOM   1483  CD2 TRP    36     -31.769 -25.344   9.551  1.00 52.76           C  
ATOM   1484  CE3 TRP    36     -31.039 -24.192   9.881  1.00 53.93           C  
ATOM   1485  CZ3 TRP    36     -30.269 -24.199  11.060  1.00 53.49           C  
ATOM   1486  CH2 TRP    36     -30.216 -25.339  11.891  1.00 51.75           C  
ATOM   1487  CZ2 TRP    36     -30.924 -26.476  11.588  1.00 51.62           C  
ATOM   1488  C   TRP    36     -32.884 -26.471   5.415  1.00 54.79           C  
ATOM   1489  O   TRP    36     -34.088 -26.652   5.506  1.00 55.66           O  
ATOM   1490  N   ASN    37     -32.095 -27.299   4.748  1.00 57.05           N  
ATOM   1491  CA  ASN    37     -32.637 -28.573   4.245  1.00 59.69           C  
ATOM   1492  CB  ASN    37     -33.492 -28.399   2.962  1.00 59.25           C  
ATOM   1493  CG  ASN    37     -32.663 -28.102   1.708  1.00 63.24           C  
ATOM   1494  OD1 ASN    37     -31.855 -28.934   1.251  1.00 65.74           O  
ATOM   1495  ND2 ASN    37     -32.895 -26.924   1.119  1.00 67.21           N  
ATOM   1496  C   ASN    37     -31.539 -29.627   4.114  1.00 60.96           C  
ATOM   1497  O   ASN    37     -30.354 -29.274   4.027  1.00 62.64           O  
ATOM   1498  N   SER    38     -31.916 -30.903   4.110  1.00 60.38           N  
ATOM   1499  CA  SER    38     -30.911 -31.965   4.214  1.00 63.35           C  
ATOM   1500  CB  SER    38     -31.532 -33.268   4.692  1.00 64.11           C  
ATOM   1501  OG  SER    38     -32.155 -33.900   3.602  1.00 70.02           O  
ATOM   1502  C   SER    38     -30.080 -32.216   2.954  1.00 63.69           C  
ATOM   1503  O   SER    38     -29.178 -33.033   2.998  1.00 63.92           O  
ATOM   1504  N   SER    39     -30.385 -31.519   1.856  1.00 63.86           N  
ATOM   1505  CA  SER    39     -29.558 -31.551   0.639  1.00 64.78           C  
ATOM   1506  CB  SER    39     -30.398 -31.342  -0.618  1.00 63.72           C  
ATOM   1507  OG  SER    39     -31.246 -32.437  -0.826  1.00 67.02           O  
ATOM   1508  C   SER    39     -28.510 -30.464   0.641  1.00 64.68           C  
ATOM   1509  O   SER    39     -27.688 -30.405  -0.267  1.00 68.02           O  
ATOM   1510  N   ASN    40     -28.573 -29.562   1.611  1.00 62.24           N  
ATOM   1511  CA  ASN    40     -27.614 -28.481   1.656  1.00 61.94           C  
ATOM   1512  CB  ASN    40     -28.096 -27.368   2.590  1.00 59.83           C  
ATOM   1513  CG  ASN    40     -27.194 -26.152   2.559  1.00 59.19           C  
ATOM   1514  OD1 ASN    40     -26.036 -26.220   2.101  1.00 59.05           O  
ATOM   1515  ND2 ASN    40     -27.716 -25.020   3.038  1.00 52.18           N  
ATOM   1516  C   ASN    40     -26.279 -29.030   2.130  1.00 62.98           C  
ATOM   1517  O   ASN    40     -26.143 -29.337   3.314  1.00 65.11           O  
ATOM   1518  N   PRO    41     -25.284 -29.124   1.226  1.00 63.55           N  
ATOM   1519  CA  PRO    41     -24.003 -29.741   1.548  1.00 64.85           C  
ATOM   1520  CB  PRO    41     -23.161 -29.492   0.286  1.00 66.12           C  
ATOM   1521  CG  PRO    41     -24.138 -29.321  -0.799  1.00 65.91           C  
ATOM   1522  CD  PRO    41     -25.298 -28.614  -0.158  1.00 64.70           C  
ATOM   1523  C   PRO    41     -23.309 -29.122   2.757  1.00 65.52           C  
ATOM   1524  O   PRO    41     -22.517 -29.791   3.419  1.00 66.69           O  
ATOM   1525  N   LYS    42     -23.600 -27.861   3.053  1.00 62.16           N  
ATOM   1526  CA  LYS    42     -22.900 -27.169   4.135  1.00 64.34           C  
ATOM   1527  CB  LYS    42     -23.244 -25.682   4.133  1.00 63.63           C  
ATOM   1528  CG  LYS    42     -22.820 -25.020   2.851  1.00 62.79           C  
ATOM   1529  CD  LYS    42     -22.705 -23.542   3.001  1.00 64.18           C  
ATOM   1530  CE  LYS    42     -22.140 -22.977   1.727  1.00 68.95           C  
ATOM   1531  NZ  LYS    42     -22.825 -21.712   1.400  1.00 74.60           N  
ATOM   1532  C   LYS    42     -23.112 -27.783   5.511  1.00 65.92           C  
ATOM   1533  O   LYS    42     -22.289 -27.611   6.401  1.00 68.21           O  
ATOM   1534  N   PHE    43     -24.204 -28.528   5.656  1.00 67.42           N  
ATOM   1535  CA  PHE    43     -24.552 -29.227   6.882  1.00 69.26           C  
ATOM   1536  CB  PHE    43     -26.053 -29.547   6.881  1.00 68.78           C  
ATOM   1537  CG  PHE    43     -26.924 -28.367   7.194  1.00 70.15           C  
ATOM   1538  CD1 PHE    43     -26.880 -27.767   8.448  1.00 70.44           C  
ATOM   1539  CE1 PHE    43     -27.676 -26.680   8.742  1.00 72.10           C  
ATOM   1540  CZ  PHE    43     -28.537 -26.175   7.786  1.00 70.06           C  
ATOM   1541  CE2 PHE    43     -28.591 -26.758   6.534  1.00 70.66           C  
ATOM   1542  CD2 PHE    43     -27.787 -27.853   6.240  1.00 69.34           C  
ATOM   1543  C   PHE    43     -23.773 -30.525   7.054  1.00 72.65           C  
ATOM   1544  O   PHE    43     -23.779 -31.128   8.144  1.00 74.80           O  
ATOM   1545  N   ARG    44     -23.136 -30.972   5.972  1.00 73.67           N  
ATOM   1546  CA  ARG    44     -22.502 -32.284   5.941  1.00 77.35           C  
ATOM   1547  CB  ARG    44     -22.077 -32.683   4.518  1.00 77.02           C  
ATOM   1548  CG  ARG    44     -21.282 -33.978   4.439  1.00 80.74           C  
ATOM   1549  CD  ARG    44     -21.486 -34.745   3.146  1.00 81.73           C  
ATOM   1550  NE  ARG    44     -21.030 -33.978   1.996  1.00 76.92           N  
ATOM   1551  CZ  ARG    44     -21.830 -33.528   1.042  1.00 71.12           C  
ATOM   1552  NH1 ARG    44     -23.122 -33.781   1.075  1.00 65.89           N  
ATOM   1553  NH2 ARG    44     -21.329 -32.832   0.046  1.00 73.50           N  
ATOM   1554  C   ARG    44     -21.350 -32.397   6.936  1.00 81.28           C  
ATOM   1555  O   ARG    44     -21.137 -33.462   7.494  1.00 84.45           O  
ATOM   1556  N   ASN    45     -20.623 -31.320   7.196  1.00 83.31           N  
ATOM   1557  CA  ASN    45     -19.516 -31.458   8.129  1.00 89.14           C  
ATOM   1558  CB  ASN    45     -18.325 -30.589   7.706  1.00 90.67           C  
ATOM   1562  C   ASN    45     -19.916 -31.277   9.611  1.00 91.62           C  
ATOM   1563  O   ASN    45     -19.147 -31.615  10.520  1.00 93.86           O  
ATOM   1564  N   GLU    46     -21.134 -30.775   9.842  1.00 91.09           N  
ATOM   1565  CA  GLU    46     -21.671 -30.506  11.198  1.00 92.01           C  
ATOM   1566  CB  GLU    46     -21.888 -31.807  11.993  1.00 94.29           C  
ATOM   1567  CG  GLU    46     -22.673 -32.872  11.210  1.00 95.61           C  
ATOM   1568  CD  GLU    46     -23.036 -34.121  12.024  1.00 99.79           C  
ATOM   1569  OE1 GLU    46     -22.526 -34.300  13.160  1.00103.61           O  
ATOM   1570  OE2 GLU    46     -23.840 -34.935  11.507  1.00101.22           O  
ATOM   1571  C   GLU    46     -20.797 -29.487  11.942  1.00 91.41           C  
ATOM   1572  O   GLU    46     -20.872 -29.328  13.166  1.00 92.29           O  
ATOM   1573  N   ASP    47     -19.977 -28.798  11.151  1.00 89.12           N  
ATOM   1574  CA  ASP    47     -19.143 -27.686  11.586  1.00 87.14           C  
ATOM   1575  CB  ASP    47     -17.695 -27.903  11.124  1.00 89.68           C  
ATOM   1576  CG  ASP    47     -17.562 -28.039   9.587  1.00 90.74           C  
ATOM   1577  OD1 ASP    47     -18.585 -28.119   8.855  1.00 86.38           O  
ATOM   1578  OD2 ASP    47     -16.405 -28.084   9.107  1.00 97.26           O  
ATOM   1579  C   ASP    47     -19.679 -26.375  10.998  1.00 82.03           C  
ATOM   1580  O   ASP    47     -19.103 -25.319  11.209  1.00 81.44           O  
ATOM   1581  N   TYR    48     -20.770 -26.462  10.242  1.00 77.20           N  
ATOM   1582  CA  TYR    48     -21.382 -25.302   9.609  1.00 74.21           C  
ATOM   1583  CB  TYR    48     -22.776 -25.676   9.067  1.00 73.30           C  
ATOM   1584  CG  TYR    48     -23.420 -24.667   8.120  1.00 71.47           C  
ATOM   1585  CD1 TYR    48     -24.744 -24.834   7.695  1.00 70.66           C  
ATOM   1586  CE1 TYR    48     -25.343 -23.923   6.819  1.00 68.10           C  
ATOM   1587  CZ  TYR    48     -24.620 -22.830   6.373  1.00 68.15           C  
ATOM   1588  OH  TYR    48     -25.197 -21.932   5.519  1.00 67.00           O  
ATOM   1589  CE2 TYR    48     -23.306 -22.637   6.772  1.00 68.50           C  
ATOM   1590  CD2 TYR    48     -22.712 -23.550   7.644  1.00 70.49           C  
ATOM   1591  C   TYR    48     -21.477 -24.102  10.558  1.00 73.61           C  
ATOM   1592  O   TYR    48     -22.263 -24.101  11.524  1.00 75.01           O  
ATOM   1593  N   THR    49     -20.664 -23.088  10.297  1.00 70.93           N  
ATOM   1594  CA  THR    49     -20.736 -21.870  11.090  1.00 69.64           C  
ATOM   1595  CB  THR    49     -19.715 -21.855  12.277  1.00 71.04           C  
ATOM   1596  OG1 THR    49     -19.033 -20.605  12.302  1.00 71.14           O  
ATOM   1597  CG2 THR    49     -18.697 -22.930  12.166  1.00 68.82           C  
ATOM   1598  C   THR    49     -20.658 -20.593  10.240  1.00 67.14           C  
ATOM   1599  O   THR    49     -19.863 -20.517   9.341  1.00 65.65           O  
ATOM   1600  N   ILE    50     -21.514 -19.613  10.523  1.00 66.24           N  
ATOM   1601  CA  ILE    50     -21.489 -18.336   9.811  1.00 64.98           C  
ATOM   1602  CB  ILE    50     -22.823 -18.008   9.090  1.00 65.33           C  
ATOM   1603  CG1 ILE    50     -23.910 -17.657  10.099  1.00 65.90           C  
ATOM   1604  CD1 ILE    50     -25.306 -17.700   9.521  1.00 73.93           C  
ATOM   1605  CG2 ILE    50     -23.256 -19.148   8.131  1.00 61.42           C  
ATOM   1606  C   ILE    50     -21.133 -17.213  10.787  1.00 65.67           C  
ATOM   1607  O   ILE    50     -21.490 -17.266  11.967  1.00 67.03           O  
ATOM   1608  N   HIS    51     -20.416 -16.212  10.284  1.00 64.25           N  
ATOM   1609  CA  HIS    51     -19.943 -15.105  11.084  1.00 63.60           C  
ATOM   1610  CB  HIS    51     -18.461 -14.901  10.835  1.00 65.49           C  
ATOM   1611  CG  HIS    51     -17.630 -16.088  11.195  1.00 70.79           C  
ATOM   1612  ND1 HIS    51     -16.951 -16.185  12.391  1.00 72.94           N  
ATOM   1613  CE1 HIS    51     -16.306 -17.337  12.435  1.00 74.97           C  
ATOM   1614  NE2 HIS    51     -16.554 -17.996  11.315  1.00 76.53           N  
ATOM   1615  CD2 HIS    51     -17.379 -17.236  10.521  1.00 73.32           C  
ATOM   1616  C   HIS    51     -20.703 -13.827  10.766  1.00 62.09           C  
ATOM   1617  O   HIS    51     -20.801 -13.415   9.603  1.00 61.03           O  
ATOM   1618  N   VAL    52     -21.230 -13.201  11.812  1.00 69.61           N  
ATOM   1619  CA  VAL    52     -22.065 -12.016  11.665  1.00 70.27           C  
ATOM   1620  CB  VAL    52     -23.525 -12.331  12.044  1.00 67.94           C  
ATOM   1621  CG1 VAL    52     -24.048 -13.516  11.256  1.00 63.91           C  
ATOM   1622  CG2 VAL    52     -23.629 -12.617  13.529  1.00 68.74           C  
ATOM   1623  C   VAL    52     -21.559 -10.871  12.551  1.00 73.22           C  
ATOM   1624  O   VAL    52     -20.790 -11.094  13.483  1.00 76.04           O  
ATOM   1625  N   GLN    53     -21.982  -9.646  12.255  1.00 74.46           N  
ATOM   1626  CA  GLN    53     -21.798  -8.534  13.178  1.00 75.33           C  
ATOM   1627  CB  GLN    53     -21.370  -7.303  12.422  1.00 77.79           C  
ATOM   1628  CG  GLN    53     -19.888  -7.222  12.255  1.00 84.78           C  
ATOM   1629  CD  GLN    53     -19.520  -6.296  11.150  1.00 89.93           C  
ATOM   1630  OE1 GLN    53     -18.901  -5.262  11.383  1.00 95.34           O  
ATOM   1631  NE2 GLN    53     -19.918  -6.641   9.926  1.00 90.84           N  
ATOM   1632  C   GLN    53     -23.100  -8.246  13.889  1.00 73.89           C  
ATOM   1633  O   GLN    53     -24.169  -8.667  13.432  1.00 71.87           O  
ATOM   1634  N   LEU    54     -23.025  -7.517  15.000  1.00 73.96           N  
ATOM   1635  CA  LEU    54     -24.246  -7.075  15.664  1.00 71.54           C  
ATOM   1636  CB  LEU    54     -23.954  -6.115  16.806  1.00 71.37           C  
ATOM   1637  CG  LEU    54     -23.720  -6.645  18.210  1.00 72.19           C  
ATOM   1638  CD1 LEU    54     -23.657  -5.431  19.127  1.00 73.28           C  
ATOM   1639  CD2 LEU    54     -24.804  -7.628  18.678  1.00 67.76           C  
ATOM   1640  C   LEU    54     -25.153  -6.381  14.666  1.00 70.96           C  
ATOM   1641  O   LEU    54     -24.707  -5.548  13.849  1.00 71.38           O  
ATOM   1642  N   ASN    55     -26.428  -6.742  14.736  1.00 69.55           N  
ATOM   1643  CA  ASN    55     -27.474  -6.128  13.911  1.00 69.72           C  
ATOM   1644  CB  ASN    55     -27.358  -4.594  13.915  1.00 68.97           C  
ATOM   1645  CG  ASN    55     -27.478  -3.990  15.318  1.00 68.73           C  
ATOM   1646  OD1 ASN    55     -28.078  -4.564  16.239  1.00 67.86           O  
ATOM   1647  ND2 ASN    55     -26.916  -2.809  15.474  1.00 63.22           N  
ATOM   1648  C   ASN    55     -27.554  -6.673  12.476  1.00 68.55           C  
ATOM   1649  O   ASN    55     -28.342  -6.181  11.669  1.00 70.93           O  
ATOM   1650  N   ASP    56     -26.726  -7.665  12.166  1.00 66.57           N  
ATOM   1651  CA  ASP    56     -26.859  -8.418  10.942  1.00 65.55           C  
ATOM   1652  CB  ASP    56     -25.652  -9.322  10.761  1.00 65.62           C  
ATOM   1653  CG  ASP    56     -24.514  -8.651  10.026  1.00 68.09           C  
ATOM   1654  OD1 ASP    56     -24.612  -7.445   9.702  1.00 66.77           O  
ATOM   1655  OD2 ASP    56     -23.516  -9.357   9.761  1.00 67.96           O  
ATOM   1656  C   ASP    56     -28.089  -9.293  11.110  1.00 65.11           C  
ATOM   1657  O   ASP    56     -28.506  -9.552  12.236  1.00 66.56           O  
ATOM   1658  N   TYR    57     -28.674  -9.730  10.000  1.00 63.82           N  
ATOM   1659  CA  TYR    57     -29.793 -10.661  10.019  1.00 60.75           C  
ATOM   1660  CB  TYR    57     -30.909 -10.165   9.111  1.00 60.51           C  
ATOM   1661  CG  TYR    57     -31.478  -8.826   9.488  1.00 60.28           C  
ATOM   1662  CD1 TYR    57     -30.823  -7.665   9.124  1.00 59.46           C  
ATOM   1663  CE1 TYR    57     -31.331  -6.431   9.445  1.00 61.40           C  
ATOM   1664  CZ  TYR    57     -32.522  -6.335  10.141  1.00 63.64           C  
ATOM   1665  OH  TYR    57     -32.970  -5.069  10.441  1.00 64.74           O  
ATOM   1666  CE2 TYR    57     -33.214  -7.481  10.538  1.00 56.59           C  
ATOM   1667  CD2 TYR    57     -32.685  -8.721  10.207  1.00 56.20           C  
ATOM   1668  C   TYR    57     -29.340 -12.004   9.493  1.00 61.12           C  
ATOM   1669  O   TYR    57     -28.496 -12.082   8.592  1.00 62.46           O  
ATOM   1670  N   VAL    58     -29.890 -13.064  10.059  1.00 60.56           N  
ATOM   1671  CA  VAL    58     -29.754 -14.388   9.476  1.00 61.46           C  
ATOM   1672  CB  VAL    58     -29.112 -15.394  10.452  1.00 62.00           C  
ATOM   1673  CG1 VAL    58     -29.223 -16.821   9.915  1.00 62.86           C  
ATOM   1674  CG2 VAL    58     -27.636 -15.015  10.717  1.00 63.40           C  
ATOM   1675  C   VAL    58     -31.146 -14.830   9.040  1.00 61.87           C  
ATOM   1676  O   VAL    58     -32.103 -14.802   9.834  1.00 61.13           O  
ATOM   1677  N   ASP    59     -31.259 -15.175   7.759  1.00 61.42           N  
ATOM   1678  CA  ASP    59     -32.509 -15.634   7.188  1.00 60.73           C  
ATOM   1679  CB  ASP    59     -32.779 -14.965   5.841  1.00 59.72           C  
ATOM   1680  CG  ASP    59     -33.157 -13.529   5.976  1.00 62.55           C  
ATOM   1681  OD1 ASP    59     -33.782 -13.172   6.996  1.00 64.16           O  
ATOM   1682  OD2 ASP    59     -32.827 -12.745   5.059  1.00 62.03           O  
ATOM   1683  C   ASP    59     -32.407 -17.135   7.001  1.00 61.61           C  
ATOM   1684  O   ASP    59     -31.683 -17.625   6.098  1.00 62.81           O  
ATOM   1685  N   ILE    60     -33.113 -17.875   7.851  1.00 60.05           N  
ATOM   1686  CA  ILE    60     -33.134 -19.316   7.706  1.00 58.69           C  
ATOM   1687  CB  ILE    60     -33.207 -20.005   9.061  1.00 58.77           C  
ATOM   1688  CG1 ILE    60     -31.917 -19.708   9.836  1.00 57.57           C  
ATOM   1689  CD1 ILE    60     -31.964 -20.141  11.282  1.00 62.49           C  
ATOM   1690  CG2 ILE    60     -33.386 -21.487   8.896  1.00 51.16           C  
ATOM   1691  C   ILE    60     -34.311 -19.610   6.811  1.00 59.83           C  
ATOM   1692  O   ILE    60     -35.418 -19.114   7.034  1.00 62.33           O  
ATOM   1693  N   ILE    61     -34.053 -20.361   5.753  1.00 59.42           N  
ATOM   1694  CA  ILE    61     -35.051 -20.588   4.715  1.00 57.99           C  
ATOM   1695  CB  ILE    61     -34.537 -20.065   3.359  1.00 58.11           C  
ATOM   1696  CG1 ILE    61     -34.261 -18.561   3.510  1.00 59.93           C  
ATOM   1697  CD1 ILE    61     -34.251 -17.783   2.223  1.00 68.98           C  
ATOM   1698  CG2 ILE    61     -35.531 -20.369   2.238  1.00 54.24           C  
ATOM   1699  C   ILE    61     -35.520 -22.048   4.711  1.00 57.94           C  
ATOM   1700  O   ILE    61     -34.737 -22.976   4.495  1.00 57.11           O  
ATOM   1701  N   CYS    62     -36.799 -22.234   5.020  1.00 57.55           N  
ATOM   1702  CA  CYS    62     -37.363 -23.561   5.162  1.00 57.79           C  
ATOM   1703  CB  CYS    62     -38.765 -23.461   5.742  1.00 58.68           C  
ATOM   1704  SG  CYS    62     -38.799 -22.883   7.422  1.00 66.56           S  
ATOM   1705  C   CYS    62     -37.433 -24.289   3.819  1.00 57.44           C  
ATOM   1706  O   CYS    62     -37.503 -23.648   2.745  1.00 55.57           O  
ATOM   1707  N   PRO    63     -37.446 -25.630   3.867  1.00 56.37           N  
ATOM   1708  CA  PRO    63     -37.635 -26.391   2.631  1.00 56.48           C  
ATOM   1709  CB  PRO    63     -37.788 -27.822   3.122  1.00 55.81           C  
ATOM   1710  CG  PRO    63     -37.139 -27.837   4.468  1.00 55.54           C  
ATOM   1711  CD  PRO    63     -37.321 -26.490   5.058  1.00 54.90           C  
ATOM   1712  C   PRO    63     -38.929 -25.913   1.958  1.00 57.83           C  
ATOM   1713  O   PRO    63     -39.911 -25.648   2.654  1.00 59.36           O  
ATOM   1714  N   HIS    64     -38.914 -25.745   0.638  1.00 58.32           N  
ATOM   1715  CA  HIS    64     -40.073 -25.230  -0.081  1.00 61.05           C  
ATOM   1716  CB  HIS    64     -40.011 -23.704  -0.172  1.00 61.33           C  
ATOM   1717  CG  HIS    64     -41.251 -23.101  -0.744  1.00 66.07           C  
ATOM   1718  ND1 HIS    64     -41.315 -22.614  -2.034  1.00 66.04           N  
ATOM   1719  CE1 HIS    64     -42.541 -22.187  -2.279  1.00 64.89           C  
ATOM   1720  NE2 HIS    64     -43.281 -22.399  -1.205  1.00 65.72           N  
ATOM   1721  CD2 HIS    64     -42.499 -22.973  -0.231  1.00 66.30           C  
ATOM   1722  C   HIS    64     -40.197 -25.864  -1.480  1.00 64.10           C  
ATOM   1723  O   HIS    64     -39.187 -26.138  -2.125  1.00 67.04           O  
ATOM   1724  N   TYR    65     -41.428 -26.104  -1.937  1.00 72.57           N  
ATOM   1725  CA  TYR    65     -41.699 -26.882  -3.156  1.00 76.38           C  
ATOM   1726  CB  TYR    65     -42.080 -28.311  -2.754  1.00 72.47           C  
ATOM   1727  CG  TYR    65     -41.120 -29.016  -1.817  1.00 70.31           C  
ATOM   1728  CD1 TYR    65     -40.185 -29.943  -2.306  1.00 67.92           C  
ATOM   1729  CE1 TYR    65     -39.299 -30.600  -1.441  1.00 63.29           C  
ATOM   1730  CZ  TYR    65     -39.348 -30.339  -0.074  1.00 63.03           C  
ATOM   1731  OH  TYR    65     -38.483 -30.981   0.779  1.00 63.79           O  
ATOM   1732  CE2 TYR    65     -40.263 -29.430   0.441  1.00 59.33           C  
ATOM   1733  CD2 TYR    65     -41.156 -28.783  -0.429  1.00 64.70           C  
ATOM   1734  C   TYR    65     -42.867 -26.320  -3.985  1.00 83.17           C  
ATOM   1735  O   TYR    65     -43.901 -25.969  -3.419  1.00 84.72           O  
ATOM   1736  N   GLU    66     -42.738 -26.257  -5.312  1.00 90.45           N  
ATOM   1737  CA  GLU    66     -43.927 -26.059  -6.179  1.00 98.45           C  
ATOM   1738  CB  GLU    66     -44.130 -24.595  -6.612  1.00102.82           C  
ATOM   1739  CG  GLU    66     -43.040 -23.979  -7.503  1.00111.20           C  
ATOM   1740  CD  GLU    66     -42.169 -22.963  -6.758  1.00114.90           C  
ATOM   1741  OE1 GLU    66     -40.926 -23.075  -6.824  1.00115.44           O  
ATOM   1742  OE2 GLU    66     -42.724 -22.050  -6.102  1.00117.13           O  
ATOM   1743  C   GLU    66     -43.980 -27.002  -7.387  1.00102.18           C  
ATOM   1744  O   GLU    66     -44.502 -28.115  -7.289  1.00104.08           O  
ATOM   1745  N   SER    69     -43.697 -30.660  -8.211  1.00101.20           N  
ATOM   1746  CA  SER    69     -44.454 -31.494  -7.282  1.00 99.05           C  
ATOM   1747  CB  SER    69     -45.901 -31.685  -7.755  1.00102.51           C  
ATOM   1748  OG  SER    69     -46.792 -30.960  -6.923  1.00102.15           O  
ATOM   1749  C   SER    69     -43.814 -32.847  -6.967  1.00 97.17           C  
ATOM   1750  O   SER    69     -43.726 -33.722  -7.819  1.00 97.34           O  
ATOM   1751  N   VAL    70     -43.349 -32.973  -5.724  1.00 93.77           N  
ATOM   1752  CA  VAL    70     -43.077 -34.264  -5.088  1.00 91.09           C  
ATOM   1753  CB  VAL    70     -41.686 -34.279  -4.362  1.00 88.12           C  
ATOM   1754  CG1 VAL    70     -41.781 -33.761  -2.949  1.00 81.91           C  
ATOM   1755  CG2 VAL    70     -40.646 -33.473  -5.150  1.00 88.49           C  
ATOM   1756  C   VAL    70     -44.264 -34.534  -4.133  1.00 89.28           C  
ATOM   1757  O   VAL    70     -45.079 -33.638  -3.896  1.00 88.69           O  
ATOM   1758  N   ALA    71     -44.386 -35.759  -3.618  1.00 88.48           N  
ATOM   1759  CA  ALA    71     -45.512 -36.123  -2.738  1.00 87.33           C  
ATOM   1760  CB  ALA    71     -45.593 -37.634  -2.538  1.00 87.21           C  
ATOM   1761  C   ALA    71     -45.417 -35.405  -1.391  1.00 83.85           C  
ATOM   1762  O   ALA    71     -44.327 -35.003  -0.963  1.00 80.71           O  
ATOM   1763  N   ASP    72     -46.558 -35.250  -0.725  1.00 83.63           N  
ATOM   1764  CA  ASP    72     -46.614 -34.429   0.474  1.00 80.95           C  
ATOM   1765  CB  ASP    72     -48.051 -34.287   0.985  1.00 82.60           C  
ATOM   1766  CG  ASP    72     -48.947 -33.501   0.017  1.00 87.82           C  
ATOM   1767  OD1 ASP    72     -48.434 -32.765  -0.860  1.00 87.73           O  
ATOM   1768  OD2 ASP    72     -50.184 -33.624   0.121  1.00 95.01           O  
ATOM   1769  C   ASP    72     -45.661 -34.957   1.530  1.00 77.55           C  
ATOM   1770  O   ASP    72     -44.869 -34.195   2.083  1.00 76.39           O  
ATOM   1771  N   ALA    73     -45.705 -36.274   1.729  1.00 77.84           N  
ATOM   1772  CA  ALA    73     -44.862 -37.023   2.666  1.00 75.61           C  
ATOM   1773  CB  ALA    73     -45.247 -38.531   2.639  1.00 76.99           C  
ATOM   1774  C   ALA    73     -43.356 -36.865   2.430  1.00 73.95           C  
ATOM   1775  O   ALA    73     -42.561 -37.082   3.347  1.00 73.95           O  
ATOM   1776  N   ALA    74     -42.968 -36.506   1.211  1.00 74.52           N  
ATOM   1777  CA  ALA    74     -41.553 -36.360   0.861  1.00 73.72           C  
ATOM   1778  CB  ALA    74     -41.306 -36.775  -0.591  1.00 75.34           C  
ATOM   1779  C   ALA    74     -41.030 -34.949   1.105  1.00 71.93           C  
ATOM   1780  O   ALA    74     -39.824 -34.717   1.057  1.00 72.75           O  
ATOM   1781  N   MET    75     -41.934 -34.009   1.355  1.00 70.52           N  
ATOM   1782  CA  MET    75     -41.547 -32.625   1.621  1.00 68.82           C  
ATOM   1783  CB  MET    75     -42.743 -31.690   1.429  1.00 68.84           C  
ATOM   1784  CG  MET    75     -43.196 -31.636  -0.008  1.00 72.32           C  
ATOM   1785  SD  MET    75     -44.675 -30.673  -0.173  1.00 75.06           S  
ATOM   1786  CE  MET    75     -45.027 -30.899  -1.910  1.00 77.34           C  
ATOM   1787  C   MET    75     -40.969 -32.503   3.022  1.00 66.12           C  
ATOM   1788  O   MET    75     -41.580 -32.964   3.987  1.00 67.76           O  
ATOM   1789  N   GLU    76     -39.783 -31.904   3.125  1.00 64.15           N  
ATOM   1790  CA  GLU    76     -39.064 -31.797   4.391  1.00 59.73           C  
ATOM   1791  CB  GLU    76     -37.593 -31.439   4.153  1.00 57.36           C  
ATOM   1792  CG  GLU    76     -36.784 -32.590   3.629  1.00 59.39           C  
ATOM   1793  CD  GLU    76     -35.304 -32.277   3.423  1.00 62.61           C  
ATOM   1794  OE1 GLU    76     -34.775 -31.364   4.072  1.00 67.17           O  
ATOM   1795  OE2 GLU    76     -34.657 -32.958   2.596  1.00 68.04           O  
ATOM   1796  C   GLU    76     -39.736 -30.778   5.293  1.00 59.34           C  
ATOM   1797  O   GLU    76     -40.135 -29.705   4.828  1.00 59.93           O  
ATOM   1798  N   GLN    77     -39.882 -31.144   6.572  1.00 59.36           N  
ATOM   1799  CA  GLN    77     -40.472 -30.296   7.619  1.00 57.88           C  
ATOM   1800  CB  GLN    77     -41.919 -30.704   7.882  1.00 57.46           C  
ATOM   1801  CG  GLN    77     -42.835 -30.354   6.717  1.00 58.86           C  
ATOM   1802  CD  GLN    77     -44.317 -30.511   7.033  1.00 59.59           C  
ATOM   1803  OE1 GLN    77     -44.847 -29.870   7.936  1.00 63.94           O  
ATOM   1804  NE2 GLN    77     -44.992 -31.342   6.266  1.00 55.64           N  
ATOM   1805  C   GLN    77     -39.649 -30.348   8.910  1.00 57.23           C  
ATOM   1806  O   GLN    77     -39.163 -31.411   9.298  1.00 60.33           O  
ATOM   1807  N   TYR    78     -39.485 -29.206   9.573  1.00 55.69           N  
ATOM   1808  CA  TYR    78     -38.585 -29.122  10.726  1.00 54.25           C  
ATOM   1809  CB  TYR    78     -37.189 -28.585  10.334  1.00 53.16           C  
ATOM   1810  CG  TYR    78     -36.440 -29.474   9.362  1.00 53.66           C  
ATOM   1811  CD1 TYR    78     -36.418 -29.181   7.994  1.00 54.30           C  
ATOM   1812  CE1 TYR    78     -35.739 -30.006   7.087  1.00 54.63           C  
ATOM   1813  CZ  TYR    78     -35.081 -31.136   7.552  1.00 53.74           C  
ATOM   1814  OH  TYR    78     -34.428 -31.941   6.658  1.00 57.55           O  
ATOM   1815  CE2 TYR    78     -35.082 -31.453   8.907  1.00 50.12           C  
ATOM   1816  CD2 TYR    78     -35.762 -30.617   9.804  1.00 52.20           C  
ATOM   1817  C   TYR    78     -39.156 -28.230  11.797  1.00 54.51           C  
ATOM   1818  O   TYR    78     -39.933 -27.312  11.507  1.00 56.08           O  
ATOM   1819  N   ILE    79     -38.766 -28.514  13.035  1.00 51.82           N  
ATOM   1820  CA  ILE    79     -38.847 -27.546  14.104  1.00 51.12           C  
ATOM   1821  CB  ILE    79     -39.334 -28.221  15.370  1.00 51.00           C  
ATOM   1822  CG1 ILE    79     -40.703 -28.835  15.118  1.00 49.34           C  
ATOM   1823  CD1 ILE    79     -41.115 -29.806  16.168  1.00 50.72           C  
ATOM   1824  CG2 ILE    79     -39.395 -27.223  16.509  1.00 50.32           C  
ATOM   1825  C   ILE    79     -37.424 -27.002  14.286  1.00 51.25           C  
ATOM   1826  O   ILE    79     -36.473 -27.789  14.393  1.00 51.15           O  
ATOM   1827  N   LEU    80     -37.264 -25.678  14.247  1.00 51.43           N  
ATOM   1828  CA  LEU    80     -35.970 -25.052  14.544  1.00 51.30           C  
ATOM   1829  CB  LEU    80     -35.733 -23.773  13.747  1.00 50.95           C  
ATOM   1830  CG  LEU    80     -35.744 -23.937  12.244  1.00 60.64           C  
ATOM   1831  CD1 LEU    80     -35.792 -22.573  11.544  1.00 61.99           C  
ATOM   1832  CD2 LEU    80     -34.546 -24.797  11.786  1.00 63.14           C  
ATOM   1833  C   LEU    80     -35.969 -24.674  16.006  1.00 50.47           C  
ATOM   1834  O   LEU    80     -36.946 -24.102  16.507  1.00 48.99           O  
ATOM   1835  N   TYR    81     -34.853 -24.968  16.666  1.00 49.53           N  
ATOM   1836  CA  TYR    81     -34.639 -24.601  18.040  1.00 49.40           C  
ATOM   1837  CB  TYR    81     -34.361 -25.849  18.868  1.00 49.48           C  
ATOM   1838  CG  TYR    81     -35.456 -26.905  18.856  1.00 47.03           C  
ATOM   1839  CD1 TYR    81     -35.465 -27.922  17.897  1.00 45.23           C  
ATOM   1840  CE1 TYR    81     -36.455 -28.906  17.906  1.00 46.90           C  
ATOM   1841  CZ  TYR    81     -37.454 -28.867  18.884  1.00 47.72           C  
ATOM   1842  OH  TYR    81     -38.450 -29.810  18.909  1.00 46.06           O  
ATOM   1843  CE2 TYR    81     -37.466 -27.866  19.832  1.00 44.80           C  
ATOM   1844  CD2 TYR    81     -36.468 -26.892  19.813  1.00 44.50           C  
ATOM   1845  C   TYR    81     -33.436 -23.681  18.136  1.00 50.84           C  
ATOM   1846  O   TYR    81     -32.490 -23.797  17.359  1.00 50.00           O  
ATOM   1847  N   LEU    82     -33.482 -22.759  19.091  1.00 51.39           N  
ATOM   1848  CA  LEU    82     -32.329 -21.943  19.401  1.00 50.54           C  
ATOM   1849  CB  LEU    82     -32.675 -20.462  19.332  1.00 51.46           C  
ATOM   1850  CG  LEU    82     -31.645 -19.457  19.872  1.00 51.59           C  
ATOM   1851  CD1 LEU    82     -30.399 -19.422  19.001  1.00 47.87           C  
ATOM   1852  CD2 LEU    82     -32.281 -18.073  19.963  1.00 49.07           C  
ATOM   1853  C   LEU    82     -31.879 -22.343  20.803  1.00 53.80           C  
ATOM   1854  O   LEU    82     -32.631 -22.182  21.768  1.00 54.04           O  
ATOM   1855  N   VAL    83     -30.652 -22.864  20.892  1.00 54.38           N  
ATOM   1856  CA  VAL    83     -30.192 -23.633  22.038  1.00 55.15           C  
ATOM   1857  CB  VAL    83     -30.160 -25.178  21.716  1.00 56.46           C  
ATOM   1858  CG1 VAL    83     -31.544 -25.722  21.351  1.00 55.39           C  
ATOM   1859  CG2 VAL    83     -29.123 -25.511  20.636  1.00 51.14           C  
ATOM   1860  C   VAL    83     -28.786 -23.248  22.465  1.00 57.18           C  
ATOM   1861  O   VAL    83     -28.015 -22.688  21.679  1.00 59.96           O  
ATOM   1862  N   GLU    84     -28.447 -23.609  23.698  1.00 58.16           N  
ATOM   1863  CA  GLU    84     -27.095 -23.449  24.241  1.00 59.82           C  
ATOM   1864  CB  GLU    84     -27.160 -23.477  25.766  1.00 61.80           C  
ATOM   1865  CG  GLU    84     -26.808 -22.172  26.402  1.00 70.34           C  
ATOM   1866  CD  GLU    84     -28.000 -21.311  26.688  1.00 76.51           C  
ATOM   1867  OE1 GLU    84     -28.225 -21.041  27.881  1.00 86.83           O  
ATOM   1868  OE2 GLU    84     -28.711 -20.886  25.749  1.00 78.44           O  
ATOM   1869  C   GLU    84     -26.093 -24.502  23.704  1.00 59.28           C  
ATOM   1870  O   GLU    84     -26.508 -25.525  23.141  1.00 56.78           O  
ATOM   1871  N   HIS    85     -24.791 -24.253  23.887  1.00 60.18           N  
ATOM   1872  CA  HIS    85     -23.742 -25.108  23.332  1.00 62.00           C  
ATOM   1873  CB  HIS    85     -22.362 -24.689  23.847  1.00 65.71           C  
ATOM   1874  CG  HIS    85     -21.220 -25.432  23.214  1.00 71.02           C  
ATOM   1875  ND1 HIS    85     -20.571 -24.981  22.082  1.00 75.54           N  
ATOM   1876  CE1 HIS    85     -19.606 -25.827  21.758  1.00 78.42           C  
ATOM   1877  NE2 HIS    85     -19.607 -26.812  22.640  1.00 78.22           N  
ATOM   1878  CD2 HIS    85     -20.598 -26.584  23.567  1.00 74.86           C  
ATOM   1879  C   HIS    85     -23.976 -26.598  23.597  1.00 63.27           C  
ATOM   1880  O   HIS    85     -23.889 -27.416  22.680  1.00 63.02           O  
ATOM   1881  N   GLU    86     -24.288 -26.955  24.838  1.00 65.23           N  
ATOM   1882  CA  GLU    86     -24.501 -28.359  25.162  1.00 67.93           C  
ATOM   1883  CB  GLU    86     -24.722 -28.557  26.653  1.00 71.08           C  
ATOM   1884  CG  GLU    86     -23.952 -29.758  27.155  1.00 83.00           C  
ATOM   1885  CD  GLU    86     -24.657 -30.510  28.268  1.00 92.71           C  
ATOM   1886  OE1 GLU    86     -25.911 -30.519  28.292  1.00 94.13           O  
ATOM   1887  OE2 GLU    86     -23.948 -31.111  29.113  1.00100.40           O  
ATOM   1888  C   GLU    86     -25.607 -29.063  24.346  1.00 66.02           C  
ATOM   1889  O   GLU    86     -25.435 -30.228  23.956  1.00 66.88           O  
ATOM   1890  N   GLU    87     -26.722 -28.377  24.081  1.00 62.99           N  
ATOM   1891  CA  GLU    87     -27.796 -29.011  23.323  1.00 63.50           C  
ATOM   1892  CB  GLU    87     -29.175 -28.323  23.429  1.00 63.04           C  
ATOM   1893  CG  GLU    87     -29.412 -27.243  24.487  1.00 68.38           C  
ATOM   1894  CD  GLU    87     -29.167 -27.664  25.892  1.00 74.69           C  
ATOM   1895  OE1 GLU    87     -29.010 -28.876  26.187  1.00 81.64           O  
ATOM   1896  OE2 GLU    87     -29.126 -26.745  26.719  1.00 79.95           O  
ATOM   1897  C   GLU    87     -27.386 -29.126  21.867  1.00 62.34           C  
ATOM   1898  O   GLU    87     -27.805 -30.059  21.181  1.00 64.45           O  
ATOM   1899  N   TYR    88     -26.550 -28.187  21.423  1.00 63.12           N  
ATOM   1900  CA  TYR    88     -25.912 -28.205  20.104  1.00 61.10           C  
ATOM   1901  CB  TYR    88     -25.154 -26.896  19.903  1.00 59.37           C  
ATOM   1902  CG  TYR    88     -24.260 -26.797  18.695  1.00 57.11           C  
ATOM   1903  CD1 TYR    88     -24.757 -26.339  17.475  1.00 55.05           C  
ATOM   1904  CE1 TYR    88     -23.923 -26.200  16.363  1.00 56.54           C  
ATOM   1905  CZ  TYR    88     -22.569 -26.521  16.470  1.00 59.03           C  
ATOM   1906  OH  TYR    88     -21.755 -26.397  15.374  1.00 59.09           O  
ATOM   1907  CE2 TYR    88     -22.047 -26.968  17.672  1.00 57.27           C  
ATOM   1908  CD2 TYR    88     -22.899 -27.091  18.785  1.00 58.95           C  
ATOM   1909  C   TYR    88     -24.962 -29.388  19.956  1.00 63.46           C  
ATOM   1910  O   TYR    88     -24.987 -30.068  18.935  1.00 63.63           O  
ATOM   1911  N   GLN    89     -24.129 -29.631  20.965  1.00 65.05           N  
ATOM   1912  CA  GLN    89     -23.289 -30.835  20.982  1.00 68.40           C  
ATOM   1913  CB  GLN    89     -22.433 -30.922  22.254  1.00 70.53           C  
ATOM   1914  CG  GLN    89     -21.312 -29.896  22.351  1.00 75.85           C  
ATOM   1915  CD  GLN    89     -20.242 -30.052  21.266  1.00 82.46           C  
ATOM   1916  OE1 GLN    89     -20.487 -29.788  20.078  1.00 81.02           O  
ATOM   1917  NE2 GLN    89     -19.039 -30.461  21.680  1.00 84.77           N  
ATOM   1918  C   GLN    89     -24.117 -32.109  20.830  1.00 68.19           C  
ATOM   1919  O   GLN    89     -23.823 -32.942  19.982  1.00 68.29           O  
ATOM   1920  N   LEU    90     -25.164 -32.247  21.639  1.00 67.73           N  
ATOM   1921  CA  LEU    90     -25.990 -33.437  21.594  1.00 68.47           C  
ATOM   1922  CB  LEU    90     -26.854 -33.542  22.841  1.00 67.62           C  
ATOM   1923  CG  LEU    90     -26.189 -33.669  24.196  1.00 71.02           C  
ATOM   1924  CD1 LEU    90     -27.305 -33.768  25.225  1.00 72.66           C  
ATOM   1925  CD2 LEU    90     -25.252 -34.868  24.238  1.00 67.89           C  
ATOM   1926  C   LEU    90     -26.901 -33.449  20.382  1.00 68.71           C  
ATOM   1927  O   LEU    90     -27.480 -34.485  20.045  1.00 70.32           O  
ATOM   1928  N   CYS    91     -27.041 -32.298  19.736  1.00 68.07           N  
ATOM   1929  CA  CYS    91     -28.023 -32.114  18.667  1.00 67.06           C  
ATOM   1930  CB  CYS    91     -27.667 -32.918  17.423  1.00 67.58           C  
ATOM   1931  SG  CYS    91     -28.387 -32.185  15.936  1.00 69.63           S  
ATOM   1932  C   CYS    91     -29.428 -32.469  19.133  1.00 66.19           C  
ATOM   1933  O   CYS    91     -30.171 -33.173  18.432  1.00 66.09           O  
ATOM   1934  N   GLN    92     -29.782 -31.987  20.325  1.00 64.97           N  
ATOM   1935  CA  GLN    92     -31.077 -32.297  20.923  1.00 63.97           C  
ATOM   1936  CB  GLN    92     -30.985 -33.573  21.748  1.00 64.98           C  
ATOM   1937  CG  GLN    92     -30.941 -34.800  20.877  1.00 69.42           C  
ATOM   1938  CD  GLN    92     -30.910 -36.068  21.655  1.00 74.34           C  
ATOM   1939  OE1 GLN    92     -31.110 -36.082  22.871  1.00 77.65           O  
ATOM   1940  NE2 GLN    92     -30.660 -37.159  20.962  1.00 73.77           N  
ATOM   1941  C   GLN    92     -31.580 -31.154  21.767  1.00 60.67           C  
ATOM   1942  O   GLN    92     -30.831 -30.623  22.558  1.00 63.52           O  
ATOM   1943  N   PRO    93     -32.863 -30.786  21.616  1.00 57.68           N  
ATOM   1944  CA  PRO    93     -33.422 -29.677  22.366  1.00 54.76           C  
ATOM   1945  CB  PRO    93     -34.789 -29.477  21.711  1.00 54.66           C  
ATOM   1946  CG  PRO    93     -35.181 -30.858  21.276  1.00 55.28           C  
ATOM   1947  CD  PRO    93     -33.881 -31.441  20.772  1.00 57.25           C  
ATOM   1948  C   PRO    93     -33.605 -30.090  23.812  1.00 55.78           C  
ATOM   1949  O   PRO    93     -33.749 -31.275  24.103  1.00 55.61           O  
ATOM   1950  N   GLN    94     -33.587 -29.116  24.712  1.00 57.59           N  
ATOM   1951  CA  GLN    94     -33.746 -29.379  26.135  1.00 59.55           C  
ATOM   1952  CB  GLN    94     -32.842 -28.453  26.950  1.00 59.04           C  
ATOM   1953  CG  GLN    94     -32.957 -28.628  28.458  1.00 66.00           C  
ATOM   1954  CD  GLN    94     -32.433 -27.414  29.230  1.00 73.20           C  
ATOM   1955  OE1 GLN    94     -31.541 -27.545  30.064  1.00 75.62           O  
ATOM   1956  NE2 GLN    94     -32.990 -26.227  28.953  1.00 73.53           N  
ATOM   1957  C   GLN    94     -35.229 -29.195  26.512  1.00 60.25           C  
ATOM   1958  O   GLN    94     -35.777 -29.989  27.294  1.00 61.46           O  
ATOM   1959  N   SER    95     -35.879 -28.180  25.933  1.00 56.75           N  
ATOM   1960  CA  SER    95     -37.274 -27.932  26.237  1.00 59.42           C  
ATOM   1961  CB  SER    95     -37.426 -27.257  27.612  1.00 59.78           C  
ATOM   1962  OG  SER    95     -37.322 -25.853  27.508  1.00 58.11           O  
ATOM   1963  C   SER    95     -38.037 -27.125  25.190  1.00 59.95           C  
ATOM   1964  O   SER    95     -37.461 -26.438  24.342  1.00 60.33           O  
ATOM   1965  N   LYS    96     -39.355 -27.206  25.304  1.00 60.01           N  
ATOM   1966  CA  LYS    96     -40.290 -26.413  24.539  1.00 58.91           C  
ATOM   1967  CB  LYS    96     -41.626 -26.516  25.233  1.00 60.61           C  
ATOM   1968  CG  LYS    96     -42.782 -26.032  24.442  1.00 68.37           C  
ATOM   1969  CD  LYS    96     -43.784 -25.347  25.378  1.00 75.00           C  
ATOM   1970  CE  LYS    96     -43.730 -25.909  26.778  1.00 74.45           C  
ATOM   1971  NZ  LYS    96     -44.618 -25.093  27.628  1.00 79.21           N  
ATOM   1972  C   LYS    96     -39.896 -24.940  24.421  1.00 56.09           C  
ATOM   1973  O   LYS    96     -40.043 -24.355  23.365  1.00 56.18           O  
ATOM   1974  N   ASP    97     -39.395 -24.345  25.497  1.00 55.95           N  
ATOM   1975  CA  ASP    97     -38.973 -22.935  25.490  1.00 55.13           C  
ATOM   1976  CB  ASP    97     -38.387 -22.528  26.830  1.00 55.07           C  
ATOM   1977  CG  ASP    97     -39.370 -22.695  27.965  1.00 61.58           C  
ATOM   1978  OD1 ASP    97     -40.576 -22.939  27.713  1.00 63.49           O  
ATOM   1979  OD2 ASP    97     -38.937 -22.581  29.125  1.00 69.18           O  
ATOM   1980  C   ASP    97     -37.964 -22.609  24.416  1.00 53.95           C  
ATOM   1981  O   ASP    97     -37.852 -21.479  24.022  1.00 56.06           O  
ATOM   1982  N   GLN    98     -37.239 -23.598  23.934  1.00 53.79           N  
ATOM   1983  CA  GLN    98     -36.216 -23.355  22.944  1.00 54.00           C  
ATOM   1984  CB  GLN    98     -35.071 -24.352  23.148  1.00 55.66           C  
ATOM   1985  CG  GLN    98     -34.318 -24.166  24.470  1.00 54.03           C  
ATOM   1986  CD  GLN    98     -33.256 -25.216  24.661  1.00 59.65           C  
ATOM   1987  OE1 GLN    98     -33.483 -26.405  24.401  1.00 60.28           O  
ATOM   1988  NE2 GLN    98     -32.075 -24.791  25.105  1.00 61.36           N  
ATOM   1989  C   GLN    98     -36.723 -23.401  21.496  1.00 54.76           C  
ATOM   1990  O   GLN    98     -35.970 -23.060  20.568  1.00 56.93           O  
ATOM   1991  N   VAL    99     -37.969 -23.844  21.286  1.00 52.58           N  
ATOM   1992  CA  VAL    99     -38.594 -23.762  19.965  1.00 50.25           C  
ATOM   1993  CB  VAL    99     -40.076 -24.225  19.984  1.00 50.43           C  
ATOM   1994  CG1 VAL    99     -40.706 -24.043  18.610  1.00 47.21           C  
ATOM   1995  CG2 VAL    99     -40.194 -25.701  20.411  1.00 49.23           C  
ATOM   1996  C   VAL    99     -38.484 -22.330  19.388  1.00 50.18           C  
ATOM   1997  O   VAL    99     -38.962 -21.373  19.984  1.00 52.07           O  
ATOM   1998  N   ARG   100     -37.853 -22.196  18.228  1.00 51.16           N  
ATOM   1999  CA  ARG   100     -37.633 -20.899  17.587  1.00 50.11           C  
ATOM   2000  CB  ARG   100     -36.235 -20.867  16.976  1.00 48.55           C  
ATOM   2001  CG  ARG   100     -35.839 -19.509  16.445  1.00 49.91           C  
ATOM   2002  CD  ARG   100     -35.920 -18.464  17.561  1.00 46.32           C  
ATOM   2003  NE  ARG   100     -35.676 -17.115  17.061  1.00 45.11           N  
ATOM   2004  CZ  ARG   100     -36.629 -16.253  16.719  1.00 45.48           C  
ATOM   2005  NH1 ARG   100     -37.913 -16.587  16.825  1.00 43.32           N  
ATOM   2006  NH2 ARG   100     -36.291 -15.047  16.267  1.00 44.04           N  
ATOM   2007  C   ARG   100     -38.638 -20.601  16.482  1.00 50.90           C  
ATOM   2008  O   ARG   100     -39.062 -19.444  16.295  1.00 51.44           O  
ATOM   2009  N   TRP   101     -38.968 -21.638  15.720  1.00 50.41           N  
ATOM   2010  CA  TRP   101     -39.852 -21.510  14.569  1.00 50.37           C  
ATOM   2011  CB  TRP   101     -39.224 -20.627  13.482  1.00 47.28           C  
ATOM   2012  CG  TRP   101     -40.273 -20.006  12.575  1.00 46.27           C  
ATOM   2013  CD1 TRP   101     -40.521 -20.311  11.254  1.00 43.91           C  
ATOM   2014  NE1 TRP   101     -41.561 -19.550  10.783  1.00 42.25           N  
ATOM   2015  CE2 TRP   101     -42.007 -18.734  11.793  1.00 43.80           C  
ATOM   2016  CD2 TRP   101     -41.222 -19.001  12.938  1.00 41.79           C  
ATOM   2017  CE3 TRP   101     -41.482 -18.290  14.123  1.00 42.59           C  
ATOM   2018  CZ3 TRP   101     -42.506 -17.349  14.130  1.00 43.83           C  
ATOM   2019  CH2 TRP   101     -43.271 -17.105  12.971  1.00 45.72           C  
ATOM   2020  CZ2 TRP   101     -43.040 -17.787  11.798  1.00 45.42           C  
ATOM   2021  C   TRP   101     -40.176 -22.889  14.007  1.00 51.33           C  
ATOM   2022  O   TRP   101     -39.530 -23.867  14.362  1.00 53.74           O  
ATOM   2023  N   GLN   102     -41.186 -22.977  13.155  1.00 53.13           N  
ATOM   2024  CA  GLN   102     -41.510 -24.248  12.529  1.00 56.47           C  
ATOM   2025  CB  GLN   102     -42.823 -24.769  13.050  1.00 58.58           C  
ATOM   2026  CG  GLN   102     -42.719 -25.076  14.531  1.00 66.85           C  
ATOM   2027  CD  GLN   102     -43.742 -26.074  14.997  1.00 73.38           C  
ATOM   2028  OE1 GLN   102     -43.587 -27.286  14.820  1.00 80.09           O  
ATOM   2029  NE2 GLN   102     -44.795 -25.571  15.609  1.00 75.87           N  
ATOM   2030  C   GLN   102     -41.514 -24.181  11.022  1.00 57.45           C  
ATOM   2031  O   GLN   102     -42.105 -23.277  10.454  1.00 57.22           O  
ATOM   2032  N   CYS   103     -40.808 -25.115  10.383  1.00 56.18           N  
ATOM   2033  CA  CYS   103     -40.872 -25.268   8.940  1.00 56.68           C  
ATOM   2034  CB  CYS   103     -39.542 -25.711   8.356  1.00 57.17           C  
ATOM   2035  SG  CYS   103     -38.285 -24.514   8.632  1.00 64.06           S  
ATOM   2036  C   CYS   103     -41.930 -26.288   8.660  1.00 55.99           C  
ATOM   2037  O   CYS   103     -41.637 -27.431   8.275  1.00 56.24           O  
ATOM   2038  N   ASN   104     -43.172 -25.869   8.856  1.00 56.52           N  
ATOM   2039  CA  ASN   104     -44.287 -26.761   8.665  1.00 57.46           C  
ATOM   2040  CB  ASN   104     -45.009 -27.003   9.992  1.00 55.61           C  
ATOM   2041  CG  ASN   104     -45.675 -25.762  10.538  1.00 56.96           C  
ATOM   2042  OD1 ASN   104     -45.472 -24.663  10.051  1.00 59.86           O  
ATOM   2043  ND2 ASN   104     -46.487 -25.941  11.555  1.00 57.18           N  
ATOM   2044  C   ASN   104     -45.217 -26.255   7.573  1.00 60.54           C  
ATOM   2045  O   ASN   104     -46.400 -26.543   7.575  1.00 63.29           O  
ATOM   2046  N   ARG   105     -44.664 -25.509   6.628  1.00 62.17           N  
ATOM   2047  CA  ARG   105     -45.421 -25.062   5.465  1.00 65.71           C  
ATOM   2048  CB  ARG   105     -45.931 -23.631   5.670  1.00 67.60           C  
ATOM   2049  CG  ARG   105     -47.074 -23.602   6.680  1.00 75.21           C  
ATOM   2050  CD  ARG   105     -47.412 -22.219   7.107  1.00 83.04           C  
ATOM   2051  NE  ARG   105     -47.651 -21.397   5.932  1.00 91.36           N  
ATOM   2052  CZ  ARG   105     -47.781 -20.073   5.948  1.00 97.78           C  
ATOM   2053  NH1 ARG   105     -47.985 -19.436   4.800  1.00 98.04           N  
ATOM   2054  NH2 ARG   105     -47.712 -19.387   7.097  1.00 94.61           N  
ATOM   2055  C   ARG   105     -44.589 -25.241   4.194  1.00 65.66           C  
ATOM   2056  O   ARG   105     -44.198 -24.270   3.544  1.00 67.33           O  
ATOM   2057  N   PRO   106     -44.314 -26.506   3.838  1.00 64.89           N  
ATOM   2058  CA  PRO   106     -43.414 -26.796   2.748  1.00 64.10           C  
ATOM   2059  CB  PRO   106     -43.311 -28.313   2.795  1.00 61.91           C  
ATOM   2060  CG  PRO   106     -44.583 -28.753   3.411  1.00 61.26           C  
ATOM   2061  CD  PRO   106     -44.843 -27.744   4.441  1.00 63.43           C  
ATOM   2062  C   PRO   106     -43.945 -26.360   1.392  1.00 66.96           C  
ATOM   2063  O   PRO   106     -43.167 -26.291   0.437  1.00 68.20           O  
ATOM   2064  N   SER   107     -45.241 -26.073   1.271  1.00 68.77           N  
ATOM   2065  CA  SER   107     -45.742 -25.726  -0.077  1.00 70.58           C  
ATOM   2066  CB  SER   107     -46.329 -26.944  -0.815  1.00 70.55           C  
ATOM   2067  OG  SER   107     -47.527 -27.384  -0.225  1.00 69.80           O  
ATOM   2068  C   SER   107     -46.645 -24.493  -0.140  1.00 71.96           C  
ATOM   2069  O   SER   107     -47.411 -24.291  -1.091  1.00 73.54           O  
ATOM   2070  N   ALA   108     -46.505 -23.665   0.884  1.00 72.27           N  
ATOM   2071  CA  ALA   108     -47.066 -22.335   0.930  1.00 73.55           C  
ATOM   2072  CB  ALA   108     -46.320 -21.559   1.979  1.00 73.53           C  
ATOM   2073  C   ALA   108     -46.967 -21.624  -0.432  1.00 76.63           C  
ATOM   2074  O   ALA   108     -45.893 -21.532  -1.033  1.00 75.59           O  
ATOM   2075  N   LYS   109     -48.094 -21.112  -0.917  1.00 81.01           N  
ATOM   2076  CA  LYS   109     -48.118 -20.389  -2.188  1.00 82.67           C  
ATOM   2077  CB  LYS   109     -49.563 -20.159  -2.664  1.00 85.17           C  
ATOM   2082  C   LYS   109     -47.324 -19.076  -2.137  1.00 83.71           C  
ATOM   2083  O   LYS   109     -46.754 -18.673  -3.149  1.00 85.36           O  
ATOM   2084  N   HIS   110     -47.275 -18.434  -0.971  0.50 83.61           N  
ATOM   2086  CA  HIS   110     -46.653 -17.106  -0.834  0.50 85.44           C  
ATOM   2088  CB  HIS   110     -47.170 -16.396   0.429  0.50 86.22           C  
ATOM   2090  CG  HIS   110     -48.625 -16.046   0.382  0.50 86.31           C  
ATOM   2092  ND1 HIS   110     -49.095 -14.788   0.685  0.50 88.73           N  
ATOM   2094  CE1 HIS   110     -50.410 -14.770   0.564  0.50 90.79           C  
ATOM   2096  NE2 HIS   110     -50.812 -15.971   0.190  0.50 87.13           N  
ATOM   2098  CD2 HIS   110     -49.715 -16.788   0.072  0.50 85.88           C  
ATOM   2100  C   HIS   110     -45.108 -17.095  -0.858  0.50 84.28           C  
ATOM   2102  O   HIS   110     -44.493 -16.028  -0.768  0.50 86.17           O  
ATOM   2104  N   GLY   111     -44.491 -18.270  -0.980  1.00 82.38           N  
ATOM   2105  CA  GLY   111     -43.020 -18.387  -1.011  1.00 79.93           C  
ATOM   2106  C   GLY   111     -42.566 -19.306   0.116  1.00 76.67           C  
ATOM   2107  O   GLY   111     -43.411 -19.872   0.818  1.00 77.64           O  
ATOM   2108  N   PRO   112     -41.242 -19.462   0.316  1.00 73.97           N  
ATOM   2109  CA  PRO   112     -40.800 -20.374   1.380  1.00 69.94           C  
ATOM   2110  CB  PRO   112     -39.284 -20.484   1.155  1.00 70.11           C  
ATOM   2111  CG  PRO   112     -39.017 -19.835  -0.179  1.00 71.17           C  
ATOM   2112  CD  PRO   112     -40.100 -18.823  -0.355  1.00 74.32           C  
ATOM   2113  C   PRO   112     -41.055 -19.734   2.728  1.00 68.32           C  
ATOM   2114  O   PRO   112     -41.049 -18.514   2.833  1.00 68.74           O  
ATOM   2115  N   GLU   113     -41.296 -20.554   3.738  1.00 68.03           N  
ATOM   2116  CA  GLU   113     -41.397 -20.072   5.101  1.00 65.88           C  
ATOM   2117  CB  GLU   113     -42.000 -21.158   5.995  1.00 65.23           C  
ATOM   2118  CG  GLU   113     -42.259 -20.757   7.436  1.00 64.92           C  
ATOM   2119  CD  GLU   113     -43.418 -19.811   7.581  1.00 68.45           C  
ATOM   2120  OE1 GLU   113     -43.386 -18.985   8.518  1.00 72.82           O  
ATOM   2121  OE2 GLU   113     -44.362 -19.880   6.763  1.00 72.64           O  
ATOM   2122  C   GLU   113     -39.990 -19.701   5.555  1.00 64.54           C  
ATOM   2123  O   GLU   113     -39.019 -20.358   5.188  1.00 66.12           O  
ATOM   2124  N   LYS   114     -39.881 -18.665   6.371  1.00 64.40           N  
ATOM   2125  CA  LYS   114     -38.593 -18.041   6.646  1.00 64.05           C  
ATOM   2126  CB  LYS   114     -38.414 -16.911   5.629  1.00 65.16           C  
ATOM   2127  CG  LYS   114     -37.179 -16.062   5.742  1.00 70.29           C  
ATOM   2128  CD  LYS   114     -37.256 -14.909   4.722  1.00 73.48           C  
ATOM   2129  CE  LYS   114     -38.129 -13.755   5.235  1.00 79.32           C  
ATOM   2130  NZ  LYS   114     -38.024 -12.564   4.346  1.00 86.89           N  
ATOM   2131  C   LYS   114     -38.510 -17.525   8.099  1.00 61.34           C  
ATOM   2132  O   LYS   114     -39.401 -16.795   8.570  1.00 61.87           O  
ATOM   2133  N   LEU   115     -37.466 -17.942   8.816  1.00 58.06           N  
ATOM   2134  CA  LEU   115     -37.124 -17.352  10.112  1.00 56.46           C  
ATOM   2135  CB  LEU   115     -36.612 -18.423  11.087  1.00 55.24           C  
ATOM   2136  CG  LEU   115     -36.414 -18.079  12.571  1.00 55.58           C  
ATOM   2137  CD1 LEU   115     -35.114 -17.372  12.765  1.00 56.14           C  
ATOM   2138  CD2 LEU   115     -37.571 -17.227  13.152  1.00 51.27           C  
ATOM   2139  C   LEU   115     -36.067 -16.255   9.915  1.00 56.26           C  
ATOM   2140  O   LEU   115     -34.931 -16.558   9.563  1.00 57.13           O  
ATOM   2141  N   SER   116     -36.447 -14.991  10.119  1.00 55.73           N  
ATOM   2142  CA  SER   116     -35.484 -13.866  10.078  1.00 54.72           C  
ATOM   2143  CB  SER   116     -36.058 -12.675   9.318  1.00 53.24           C  
ATOM   2144  OG  SER   116     -36.231 -13.009   7.962  1.00 59.50           O  
ATOM   2145  C   SER   116     -35.078 -13.419  11.482  1.00 53.76           C  
ATOM   2146  O   SER   116     -35.840 -12.760  12.162  1.00 54.96           O  
ATOM   2147  N   GLU   117     -33.873 -13.783  11.888  1.00 53.29           N  
ATOM   2148  CA  GLU   117     -33.348 -13.483  13.202  1.00 55.01           C  
ATOM   2149  CB  GLU   117     -32.501 -14.679  13.692  1.00 54.38           C  
ATOM   2150  CG  GLU   117     -31.960 -14.505  15.075  1.00 53.87           C  
ATOM   2151  CD  GLU   117     -32.976 -14.909  16.118  1.00 59.77           C  
ATOM   2152  OE1 GLU   117     -33.040 -16.118  16.398  1.00 54.27           O  
ATOM   2153  OE2 GLU   117     -33.714 -14.022  16.654  1.00 63.09           O  
ATOM   2154  C   GLU   117     -32.451 -12.254  13.113  1.00 57.04           C  
ATOM   2155  O   GLU   117     -31.441 -12.286  12.407  1.00 61.60           O  
ATOM   2156  N   LYS   118     -32.777 -11.175  13.815  1.00 57.57           N  
ATOM   2157  CA  LYS   118     -31.843 -10.047  13.876  1.00 56.25           C  
ATOM   2158  CB  LYS   118     -32.563  -8.713  13.901  1.00 56.23           C  
ATOM   2159  CG  LYS   118     -31.618  -7.534  13.868  1.00 55.68           C  
ATOM   2160  CD  LYS   118     -32.364  -6.236  14.014  1.00 60.62           C  
ATOM   2161  CE  LYS   118     -31.459  -5.063  13.761  1.00 63.49           C  
ATOM   2162  NZ  LYS   118     -32.307  -3.873  13.602  1.00 66.60           N  
ATOM   2163  C   LYS   118     -30.969 -10.176  15.103  1.00 58.01           C  
ATOM   2164  O   LYS   118     -31.471 -10.341  16.217  1.00 61.22           O  
ATOM   2165  N   PHE   119     -29.660 -10.088  14.909  1.00 57.70           N  
ATOM   2166  CA  PHE   119     -28.732 -10.224  16.011  1.00 57.85           C  
ATOM   2167  CB  PHE   119     -27.428 -10.844  15.494  1.00 58.57           C  
ATOM   2168  CG  PHE   119     -27.559 -12.328  15.221  1.00 58.68           C  
ATOM   2169  CD1 PHE   119     -28.338 -12.791  14.166  1.00 59.09           C  
ATOM   2170  CE1 PHE   119     -28.502 -14.151  13.939  1.00 58.27           C  
ATOM   2171  CZ  PHE   119     -27.888 -15.067  14.769  1.00 58.62           C  
ATOM   2172  CE2 PHE   119     -27.106 -14.622  15.825  1.00 59.67           C  
ATOM   2173  CD2 PHE   119     -26.953 -13.260  16.048  1.00 60.42           C  
ATOM   2174  C   PHE   119     -28.573  -8.927  16.824  1.00 60.49           C  
ATOM   2175  O   PHE   119     -27.512  -8.304  16.846  1.00 62.69           O  
ATOM   2176  N   GLN   120     -29.670  -8.525  17.466  1.00 60.88           N  
ATOM   2177  CA  GLN   120     -29.747  -7.338  18.311  1.00 64.08           C  
ATOM   2178  CB  GLN   120     -31.186  -7.147  18.736  1.00 65.47           C  
ATOM   2179  CG  GLN   120     -32.132  -6.431  17.828  1.00 71.77           C  
ATOM   2180  CD  GLN   120     -33.544  -6.479  18.418  1.00 77.29           C  
ATOM   2181  OE1 GLN   120     -33.995  -7.532  18.888  1.00 75.97           O  
ATOM   2182  NE2 GLN   120     -34.234  -5.334  18.427  1.00 82.70           N  
ATOM   2183  C   GLN   120     -29.014  -7.592  19.618  1.00 66.37           C  
ATOM   2184  O   GLN   120     -28.935  -8.734  20.066  1.00 68.81           O  
ATOM   2185  N   ARG   121     -28.550  -6.534  20.280  1.00 68.12           N  
ATOM   2186  CA  ARG   121     -28.049  -6.671  21.642  1.00 69.56           C  
ATOM   2187  CB  ARG   121     -27.005  -5.591  21.982  1.00 73.03           C  
ATOM   2188  CG  ARG   121     -25.964  -6.019  23.055  1.00 76.86           C  
ATOM   2189  CD  ARG   121     -26.436  -5.615  24.406  1.00 84.36           C  
ATOM   2190  NE  ARG   121     -25.839  -6.289  25.563  1.00 92.25           N  
ATOM   2191  CZ  ARG   121     -26.404  -7.293  26.240  1.00 95.25           C  
ATOM   2192  NH1 ARG   121     -27.569  -7.810  25.850  1.00 91.64           N  
ATOM   2193  NH2 ARG   121     -25.791  -7.798  27.306  1.00 98.78           N  
ATOM   2194  C   ARG   121     -29.187  -6.655  22.657  1.00 70.48           C  
ATOM   2195  O   ARG   121     -29.072  -7.272  23.710  1.00 71.66           O  
ATOM   2196  N   PHE   122     -30.276  -5.954  22.347  1.00 61.20           N  
ATOM   2197  CA  PHE   122     -31.381  -5.819  23.293  1.00 60.75           C  
ATOM   2198  CB  PHE   122     -31.403  -4.418  23.897  1.00 58.60           C  
ATOM   2199  CG  PHE   122     -30.183  -4.059  24.692  1.00 55.90           C  
ATOM   2200  CD1 PHE   122     -29.306  -3.083  24.228  1.00 54.44           C  
ATOM   2201  CE1 PHE   122     -28.172  -2.721  24.978  1.00 54.40           C  
ATOM   2202  CZ  PHE   122     -27.923  -3.334  26.216  1.00 52.99           C  
ATOM   2203  CE2 PHE   122     -28.811  -4.305  26.694  1.00 54.00           C  
ATOM   2204  CD2 PHE   122     -29.937  -4.653  25.933  1.00 54.71           C  
ATOM   2205  C   PHE   122     -32.737  -6.058  22.642  1.00 62.50           C  
ATOM   2206  O   PHE   122     -32.961  -5.561  21.536  1.00 62.87           O  
ATOM   2207  N   THR   123     -33.623  -6.804  23.325  1.00 62.78           N  
ATOM   2208  CA  THR   123     -35.036  -6.962  22.919  1.00 64.29           C  
ATOM   2209  CB  THR   123     -35.596  -8.415  23.030  1.00 64.98           C  
ATOM   2210  OG1 THR   123     -34.571  -9.339  23.418  1.00 68.38           O  
ATOM   2211  CG2 THR   123     -36.347  -8.842  21.760  1.00 66.72           C  
ATOM   2212  C   THR   123     -35.935  -6.295  23.926  1.00 63.38           C  
ATOM   2213  O   THR   123     -35.648  -6.333  25.122  1.00 62.17           O  
ATOM   2214  N   PRO   124     -37.071  -5.759  23.455  1.00 63.85           N  
ATOM   2215  CA  PRO   124     -38.192  -5.496  24.349  1.00 64.11           C  
ATOM   2216  CB  PRO   124     -39.047  -4.519  23.544  1.00 63.16           C  
ATOM   2217  CG  PRO   124     -38.774  -4.886  22.115  1.00 62.79           C  
ATOM   2218  CD  PRO   124     -37.369  -5.378  22.058  1.00 63.83           C  
ATOM   2219  C   PRO   124     -38.989  -6.783  24.635  1.00 65.71           C  
ATOM   2220  O   PRO   124     -39.777  -6.811  25.575  1.00 65.67           O  
ATOM   2221  N   PHE   125     -38.799  -7.834  23.830  1.00 67.48           N  
ATOM   2222  CA  PHE   125     -39.646  -9.025  23.963  1.00 68.12           C  
ATOM   2223  CB  PHE   125     -40.131  -9.572  22.622  1.00 65.98           C  
ATOM   2224  CG  PHE   125     -41.287 -10.510  22.754  1.00 67.79           C  
ATOM   2225  CD1 PHE   125     -41.169 -11.841  22.369  1.00 66.48           C  
ATOM   2226  CE1 PHE   125     -42.241 -12.720  22.495  1.00 65.01           C  
ATOM   2227  CZ  PHE   125     -43.453 -12.281  23.039  1.00 65.56           C  
ATOM   2228  CE2 PHE   125     -43.581 -10.955  23.447  1.00 66.67           C  
ATOM   2229  CD2 PHE   125     -42.500 -10.072  23.297  1.00 68.36           C  
ATOM   2230  C   PHE   125     -39.028 -10.121  24.816  1.00 69.36           C  
ATOM   2231  O   PHE   125     -37.988 -10.675  24.505  1.00 73.04           O  
ATOM   2232  N   THR   126     -39.722 -10.441  25.889  1.00 69.96           N  
ATOM   2233  CA  THR   126     -39.165 -11.208  26.981  1.00 68.85           C  
ATOM   2234  CB  THR   126     -40.046 -10.959  28.226  1.00 68.67           C  
ATOM   2235  OG1 THR   126     -39.214 -10.762  29.367  1.00 75.15           O  
ATOM   2236  CG2 THR   126     -41.043 -12.049  28.459  1.00 65.36           C  
ATOM   2237  C   THR   126     -38.905 -12.693  26.639  1.00 68.68           C  
ATOM   2238  O   THR   126     -38.144 -13.374  27.319  1.00 68.27           O  
ATOM   2239  N   LEU   127     -39.507 -13.159  25.548  1.00 69.14           N  
ATOM   2240  CA  LEU   127     -39.357 -14.539  25.061  1.00 69.56           C  
ATOM   2241  CB  LEU   127     -40.690 -15.040  24.498  1.00 68.06           C  
ATOM   2242  CG  LEU   127     -41.745 -15.722  25.381  1.00 67.52           C  
ATOM   2243  CD1 LEU   127     -41.707 -15.252  26.804  1.00 64.96           C  
ATOM   2244  CD2 LEU   127     -43.142 -15.547  24.789  1.00 67.52           C  
ATOM   2245  C   LEU   127     -38.284 -14.664  23.971  1.00 71.45           C  
ATOM   2246  O   LEU   127     -37.988 -15.766  23.523  1.00 72.49           O  
ATOM   2247  N   GLY   128     -37.725 -13.534  23.536  1.00 70.94           N  
ATOM   2248  CA  GLY   128     -36.696 -13.526  22.509  1.00 71.72           C  
ATOM   2249  C   GLY   128     -35.307 -13.517  23.113  1.00 71.86           C  
ATOM   2250  O   GLY   128     -35.160 -13.397  24.327  1.00 72.73           O  
ATOM   2251  N   LYS   129     -34.288 -13.655  22.265  1.00 71.49           N  
ATOM   2252  CA  LYS   129     -32.902 -13.778  22.712  1.00 70.95           C  
ATOM   2253  CB  LYS   129     -32.228 -14.955  22.001  1.00 71.86           C  
ATOM   2254  CG  LYS   129     -31.407 -15.887  22.907  1.00 76.61           C  
ATOM   2255  CD  LYS   129     -29.935 -15.452  23.062  1.00 77.08           C  
ATOM   2256  CE  LYS   129     -29.113 -16.483  23.848  1.00 74.75           C  
ATOM   2258  C   LYS   129     -32.115 -12.486  22.445  1.00 69.43           C  
ATOM   2259  O   LYS   129     -32.398 -11.740  21.490  1.00 69.19           O  
ATOM   2260  N   GLU   130     -31.133 -12.219  23.295  1.00 66.53           N  
ATOM   2261  CA  GLU   130     -30.216 -11.111  23.069  1.00 63.18           C  
ATOM   2262  CB  GLU   130     -30.119 -10.259  24.310  1.00 60.46           C  
ATOM   2263  CG  GLU   130     -31.446  -9.677  24.676  1.00 58.67           C  
ATOM   2264  CD  GLU   130     -31.343  -8.581  25.707  1.00 64.53           C  
ATOM   2265  OE1 GLU   130     -30.511  -8.684  26.652  1.00 63.02           O  
ATOM   2266  OE2 GLU   130     -32.116  -7.611  25.571  1.00 66.51           O  
ATOM   2267  C   GLU   130     -28.860 -11.652  22.646  1.00 63.11           C  
ATOM   2268  O   GLU   130     -28.440 -12.728  23.084  1.00 65.06           O  
ATOM   2269  N   PHE   131     -28.190 -10.916  21.774  1.00 63.03           N  
ATOM   2270  CA  PHE   131     -26.963 -11.396  21.171  1.00 61.16           C  
ATOM   2271  CB  PHE   131     -27.161 -11.547  19.656  1.00 58.51           C  
ATOM   2272  CG  PHE   131     -28.257 -12.503  19.284  1.00 55.20           C  
ATOM   2273  CD1 PHE   131     -28.003 -13.873  19.198  1.00 51.84           C  
ATOM   2274  CE1 PHE   131     -29.026 -14.768  18.870  1.00 53.42           C  
ATOM   2275  CZ  PHE   131     -30.332 -14.290  18.634  1.00 51.71           C  
ATOM   2276  CE2 PHE   131     -30.592 -12.923  18.741  1.00 53.28           C  
ATOM   2277  CD2 PHE   131     -29.559 -12.040  19.058  1.00 53.90           C  
ATOM   2278  C   PHE   131     -25.827 -10.437  21.480  1.00 63.92           C  
ATOM   2279  O   PHE   131     -25.998  -9.235  21.371  1.00 65.92           O  
ATOM   2280  N   LYS   132     -24.670 -10.970  21.860  1.00 65.44           N  
ATOM   2281  CA  LYS   132     -23.542 -10.152  22.310  1.00 68.20           C  
ATOM   2282  CB  LYS   132     -23.222 -10.464  23.772  1.00 68.50           C  
ATOM   2283  CG  LYS   132     -24.290 -10.012  24.726  1.00 73.51           C  
ATOM   2284  CD  LYS   132     -24.607 -11.080  25.752  1.00 80.61           C  
ATOM   2285  CE  LYS   132     -23.876 -10.832  27.070  1.00 86.59           C  
ATOM   2286  NZ  LYS   132     -24.433 -11.694  28.161  1.00 88.30           N  
ATOM   2287  C   LYS   132     -22.309 -10.378  21.457  1.00 68.97           C  
ATOM   2288  O   LYS   132     -22.055 -11.497  21.017  1.00 68.20           O  
ATOM   2289  N   GLU   133     -21.544  -9.311  21.234  1.00 72.55           N  
ATOM   2290  CA  GLU   133     -20.260  -9.392  20.521  1.00 74.52           C  
ATOM   2291  CB  GLU   133     -19.611  -8.009  20.415  1.00 76.37           C  
ATOM   2292  CG  GLU   133     -20.269  -7.123  19.363  1.00 81.52           C  
ATOM   2293  CD  GLU   133     -19.519  -5.821  19.099  1.00 86.20           C  
ATOM   2294  OE1 GLU   133     -18.317  -5.875  18.747  1.00 96.41           O  
ATOM   2295  OE2 GLU   133     -20.134  -4.734  19.224  1.00 92.30           O  
ATOM   2296  C   GLU   133     -19.304 -10.367  21.191  1.00 72.05           C  
ATOM   2297  O   GLU   133     -19.186 -10.376  22.407  1.00 72.26           O  
ATOM   2298  N   GLY   134     -18.645 -11.199  20.390  1.00 70.84           N  
ATOM   2299  CA  GLY   134     -17.705 -12.198  20.893  1.00 69.51           C  
ATOM   2300  C   GLY   134     -18.303 -13.537  21.292  1.00 68.24           C  
ATOM   2301  O   GLY   134     -17.573 -14.451  21.639  1.00 68.55           O  
ATOM   2302  N   HIS   135     -19.626 -13.659  21.257  1.00 66.41           N  
ATOM   2303  CA  HIS   135     -20.292 -14.907  21.621  1.00 65.15           C  
ATOM   2304  CB  HIS   135     -21.487 -14.628  22.535  1.00 65.77           C  
ATOM   2305  CG  HIS   135     -21.103 -14.116  23.884  1.00 71.66           C  
ATOM   2306  ND1 HIS   135     -20.438 -12.919  24.066  1.00 75.73           N  
ATOM   2307  CE1 HIS   135     -20.231 -12.724  25.357  1.00 76.62           C  
ATOM   2308  NE2 HIS   135     -20.746 -13.745  26.018  1.00 77.98           N  
ATOM   2309  CD2 HIS   135     -21.296 -14.632  25.120  1.00 73.15           C  
ATOM   2310  C   HIS   135     -20.757 -15.690  20.396  1.00 62.81           C  
ATOM   2311  O   HIS   135     -20.812 -15.161  19.280  1.00 63.13           O  
ATOM   2312  N   SER   136     -21.099 -16.953  20.621  1.00 60.44           N  
ATOM   2313  CA  SER   136     -21.619 -17.814  19.576  1.00 58.65           C  
ATOM   2314  CB  SER   136     -20.678 -18.997  19.352  1.00 59.69           C  
ATOM   2315  OG  SER   136     -19.527 -18.622  18.596  1.00 61.55           O  
ATOM   2316  C   SER   136     -23.020 -18.292  19.955  1.00 57.92           C  
ATOM   2317  O   SER   136     -23.352 -18.401  21.137  1.00 56.83           O  
ATOM   2318  N   TYR   137     -23.854 -18.552  18.954  1.00 57.02           N  
ATOM   2319  CA  TYR   137     -25.235 -18.979  19.198  1.00 56.00           C  
ATOM   2320  CB  TYR   137     -26.194 -17.809  18.951  1.00 56.33           C  
ATOM   2321  CG  TYR   137     -25.840 -16.674  19.876  1.00 58.56           C  
ATOM   2322  CD1 TYR   137     -24.865 -15.726  19.518  1.00 58.33           C  
ATOM   2323  CE1 TYR   137     -24.493 -14.719  20.391  1.00 61.81           C  
ATOM   2324  CZ  TYR   137     -25.087 -14.654  21.654  1.00 63.16           C  
ATOM   2325  OH  TYR   137     -24.739 -13.657  22.546  1.00 63.56           O  
ATOM   2326  CE2 TYR   137     -26.041 -15.596  22.032  1.00 60.91           C  
ATOM   2327  CD2 TYR   137     -26.401 -16.602  21.151  1.00 57.19           C  
ATOM   2328  C   TYR   137     -25.497 -20.190  18.337  1.00 54.88           C  
ATOM   2329  O   TYR   137     -24.769 -20.423  17.387  1.00 57.89           O  
ATOM   2330  N   TYR   138     -26.479 -21.000  18.693  1.00 54.02           N  
ATOM   2331  CA  TYR   138     -26.600 -22.323  18.077  1.00 53.58           C  
ATOM   2332  CB  TYR   138     -26.047 -23.415  18.997  1.00 53.48           C  
ATOM   2333  CG  TYR   138     -24.676 -23.098  19.544  1.00 56.27           C  
ATOM   2334  CD1 TYR   138     -24.530 -22.469  20.779  1.00 56.27           C  
ATOM   2335  CE1 TYR   138     -23.286 -22.160  21.278  1.00 54.11           C  
ATOM   2336  CZ  TYR   138     -22.169 -22.470  20.546  1.00 56.08           C  
ATOM   2337  OH  TYR   138     -20.928 -22.166  21.051  1.00 61.04           O  
ATOM   2338  CE2 TYR   138     -22.279 -23.090  19.317  1.00 56.79           C  
ATOM   2339  CD2 TYR   138     -23.529 -23.396  18.819  1.00 55.12           C  
ATOM   2340  C   TYR   138     -28.026 -22.648  17.764  1.00 53.46           C  
ATOM   2341  O   TYR   138     -28.903 -22.512  18.643  1.00 52.33           O  
ATOM   2342  N   TYR   139     -28.246 -23.076  16.516  1.00 52.60           N  
ATOM   2343  CA  TYR   139     -29.530 -23.587  16.079  1.00 51.05           C  
ATOM   2344  CB  TYR   139     -29.997 -22.871  14.817  1.00 50.69           C  
ATOM   2345  CG  TYR   139     -30.236 -21.390  14.980  1.00 53.13           C  
ATOM   2346  CD1 TYR   139     -29.183 -20.481  14.864  1.00 54.96           C  
ATOM   2347  CE1 TYR   139     -29.386 -19.107  14.988  1.00 53.90           C  
ATOM   2348  CZ  TYR   139     -30.658 -18.625  15.251  1.00 56.28           C  
ATOM   2349  OH  TYR   139     -30.846 -17.257  15.382  1.00 53.37           O  
ATOM   2350  CE2 TYR   139     -31.732 -19.519  15.384  1.00 54.77           C  
ATOM   2351  CD2 TYR   139     -31.515 -20.890  15.239  1.00 52.78           C  
ATOM   2352  C   TYR   139     -29.422 -25.074  15.798  1.00 52.04           C  
ATOM   2353  O   TYR   139     -28.415 -25.551  15.236  1.00 52.43           O  
ATOM   2354  N   ILE   140     -30.473 -25.802  16.170  1.00 51.19           N  
ATOM   2355  CA  ILE   140     -30.638 -27.207  15.747  1.00 52.22           C  
ATOM   2356  CB  ILE   140     -30.321 -28.223  16.894  1.00 52.57           C  
ATOM   2357  CG1 ILE   140     -31.370 -28.115  18.016  1.00 50.46           C  
ATOM   2358  CD1 ILE   140     -31.233 -29.136  19.121  1.00 50.31           C  
ATOM   2359  CG2 ILE   140     -28.886 -28.042  17.403  1.00 49.16           C  
ATOM   2360  C   ILE   140     -32.072 -27.438  15.228  1.00 53.15           C  
ATOM   2361  O   ILE   140     -32.980 -26.626  15.473  1.00 54.39           O  
ATOM   2362  N   SER   141     -32.288 -28.544  14.521  1.00 51.34           N  
ATOM   2363  CA  SER   141     -33.649 -28.880  14.134  1.00 49.78           C  
ATOM   2364  CB  SER   141     -33.873 -28.602  12.657  1.00 47.58           C  
ATOM   2365  OG  SER   141     -33.020 -29.391  11.875  1.00 52.50           O  
ATOM   2366  C   SER   141     -34.015 -30.322  14.472  1.00 49.85           C  
ATOM   2367  O   SER   141     -33.152 -31.160  14.743  1.00 51.45           O  
ATOM   2368  N   LYS   142     -35.304 -30.609  14.475  1.00 48.16           N  
ATOM   2369  CA  LYS   142     -35.737 -31.993  14.412  1.00 47.37           C  
ATOM   2370  CB  LYS   142     -36.346 -32.422  15.743  1.00 47.41           C  
ATOM   2371  CG  LYS   142     -35.316 -32.537  16.860  1.00 47.19           C  
ATOM   2372  CD  LYS   142     -34.342 -33.648  16.548  1.00 43.53           C  
ATOM   2373  CE  LYS   142     -33.274 -33.717  17.562  1.00 47.73           C  
ATOM   2374  NZ  LYS   142     -32.273 -34.713  17.167  1.00 48.82           N  
ATOM   2375  C   LYS   142     -36.728 -32.125  13.276  1.00 47.80           C  
ATOM   2376  O   LYS   142     -37.497 -31.202  13.034  1.00 48.97           O  
ATOM   2377  N   PRO   143     -36.738 -33.274  12.577  1.00 48.61           N  
ATOM   2378  CA  PRO   143     -37.716 -33.399  11.502  1.00 47.89           C  
ATOM   2379  CB  PRO   143     -37.321 -34.714  10.821  1.00 49.14           C  
ATOM   2380  CG  PRO   143     -36.032 -35.122  11.405  1.00 50.27           C  
ATOM   2381  CD  PRO   143     -35.966 -34.513  12.758  1.00 48.34           C  
ATOM   2382  C   PRO   143     -39.127 -33.556  12.100  1.00 48.96           C  
ATOM   2383  O   PRO   143     -39.270 -34.143  13.179  1.00 47.48           O  
ATOM   2384  N   ILE   144     -40.156 -33.040  11.423  1.00 48.74           N  
ATOM   2385  CA  ILE   144     -41.517 -33.289  11.867  1.00 46.74           C  
ATOM   2386  CB  ILE   144     -42.472 -32.127  11.522  1.00 45.78           C  
ATOM   2387  CG1 ILE   144     -41.951 -30.828  12.131  1.00 44.71           C  
ATOM   2388  CD1 ILE   144     -42.820 -29.613  11.765  1.00 46.74           C  
ATOM   2389  CG2 ILE   144     -43.862 -32.381  12.092  1.00 37.44           C  
ATOM   2390  C   ILE   144     -42.018 -34.634  11.319  1.00 49.22           C  
ATOM   2391  O   ILE   144     -42.501 -34.723  10.175  1.00 49.54           O  
ATOM   2392  N   HIS   145     -41.901 -35.668  12.157  1.00 48.28           N  
ATOM   2393  CA  HIS   145     -42.348 -37.042  11.841  1.00 50.71           C  
ATOM   2394  CB  HIS   145     -43.857 -37.150  11.576  1.00 48.39           C  
ATOM   2395  CG  HIS   145     -44.717 -36.301  12.464  1.00 51.57           C  
ATOM   2396  ND1 HIS   145     -44.745 -36.432  13.836  1.00 50.86           N  
ATOM   2397  CE1 HIS   145     -45.610 -35.574  14.341  1.00 43.42           C  
ATOM   2398  NE2 HIS   145     -46.159 -34.904  13.345  1.00 46.64           N  
ATOM   2399  CD2 HIS   145     -45.631 -35.349  12.162  1.00 50.88           C  
ATOM   2400  C   HIS   145     -41.646 -37.628  10.636  1.00 52.43           C  
ATOM   2401  O   HIS   145     -42.296 -38.244   9.797  1.00 54.54           O  
ATOM   2402  N   GLN   146     -40.336 -37.442  10.536  1.00 52.92           N  
ATOM   2403  CA  GLN   146     -39.592 -37.881   9.349  1.00 55.41           C  
ATOM   2404  CB  GLN   146     -39.410 -36.722   8.359  1.00 53.53           C  
ATOM   2405  CG  GLN   146     -40.630 -36.348   7.574  1.00 55.08           C  
ATOM   2406  CD  GLN   146     -40.487 -35.032   6.825  1.00 56.54           C  
ATOM   2407  OE1 GLN   146     -39.637 -34.174   7.132  1.00 58.07           O  
ATOM   2408  NE2 GLN   146     -41.331 -34.862   5.839  1.00 57.67           N  
ATOM   2409  C   GLN   146     -38.220 -38.398   9.751  1.00 55.25           C  
ATOM   2410  O   GLN   146     -37.792 -38.164  10.873  1.00 55.18           O  
ATOM   2411  N   HIS   147     -37.550 -39.080   8.823  1.00 56.32           N  
ATOM   2412  CA  HIS   147     -36.165 -39.498   8.982  1.00 59.99           C  
ATOM   2413  CB  HIS   147     -35.621 -40.136   7.690  1.00 60.94           C  
ATOM   2414  CG  HIS   147     -36.204 -41.471   7.365  1.00 65.97           C  
ATOM   2415  ND1 HIS   147     -36.970 -42.195   8.253  1.00 72.70           N  
ATOM   2416  CE1 HIS   147     -37.334 -43.338   7.694  1.00 75.02           C  
ATOM   2417  NE2 HIS   147     -36.824 -43.385   6.475  1.00 74.43           N  
ATOM   2418  CD2 HIS   147     -36.103 -42.235   6.249  1.00 74.39           C  
ATOM   2419  C   HIS   147     -35.246 -38.334   9.381  1.00 59.32           C  
ATOM   2420  O   HIS   147     -35.282 -37.252   8.774  1.00 58.68           O  
ATOM   2421  N   GLU   148     -34.464 -38.563  10.436  1.00 60.00           N  
ATOM   2422  CA  GLU   148     -33.312 -37.729  10.771  1.00 60.66           C  
ATOM   2423  CB  GLU   148     -33.266 -37.478  12.272  1.00 57.72           C  
ATOM   2424  CG  GLU   148     -32.379 -36.290  12.637  1.00 60.69           C  
ATOM   2425  CD  GLU   148     -32.251 -36.078  14.125  1.00 60.94           C  
ATOM   2426  OE1 GLU   148     -32.855 -36.869  14.889  1.00 66.02           O  
ATOM   2427  OE2 GLU   148     -31.542 -35.131  14.528  1.00 56.46           O  
ATOM   2428  C   GLU   148     -32.038 -38.457  10.308  1.00 63.17           C  
ATOM   2429  O   GLU   148     -31.486 -39.293  11.023  1.00 65.37           O  
ATOM   2430  N   ASP   149     -31.601 -38.179   9.093  1.00 64.91           N  
ATOM   2431  CA  ASP   149     -30.511 -38.938   8.483  1.00 69.10           C  
ATOM   2432  CB  ASP   149     -30.521 -38.711   6.977  1.00 71.16           C  
ATOM   2433  CG  ASP   149     -31.526 -39.594   6.254  1.00 77.97           C  
ATOM   2434  OD1 ASP   149     -32.290 -40.349   6.911  1.00 81.56           O  
ATOM   2435  OD2 ASP   149     -31.535 -39.541   5.005  1.00 83.32           O  
ATOM   2436  C   ASP   149     -29.162 -38.512   9.026  1.00 69.28           C  
ATOM   2437  O   ASP   149     -28.202 -39.270   9.020  1.00 72.00           O  
ATOM   2438  N   ARG   150     -29.136 -37.285   9.519  1.00 68.22           N  
ATOM   2439  CA  ARG   150     -27.950 -36.510   9.775  1.00 68.79           C  
ATOM   2440  CB  ARG   150     -27.475 -35.918   8.451  1.00 69.51           C  
ATOM   2441  CG  ARG   150     -26.577 -34.704   8.486  1.00 70.21           C  
ATOM   2442  CD  ARG   150     -26.370 -34.182   7.042  1.00 72.26           C  
ATOM   2443  NE  ARG   150     -25.942 -35.232   6.111  1.00 73.68           N  
ATOM   2447  C   ARG   150     -28.481 -35.431  10.690  1.00 66.74           C  
ATOM   2448  O   ARG   150     -29.646 -35.030  10.583  1.00 65.37           O  
ATOM   2449  N   CYS   151     -27.648 -34.988  11.617  1.00 67.67           N  
ATOM   2450  CA  CYS   151     -28.016 -33.908  12.512  1.00 64.82           C  
ATOM   2451  CB  CYS   151     -27.158 -33.980  13.774  1.00 65.20           C  
ATOM   2452  SG  CYS   151     -26.876 -32.371  14.535  1.00 71.95           S  
ATOM   2453  C   CYS   151     -27.840 -32.566  11.782  1.00 62.66           C  
ATOM   2454  O   CYS   151     -26.786 -32.310  11.183  1.00 63.69           O  
ATOM   2455  N   LEU   152     -28.863 -31.719  11.819  1.00 57.45           N  
ATOM   2456  CA  LEU   152     -28.754 -30.404  11.198  1.00 55.46           C  
ATOM   2457  CB  LEU   152     -29.965 -30.112  10.314  1.00 53.30           C  
ATOM   2458  CG  LEU   152     -30.230 -31.058   9.136  1.00 57.13           C  
ATOM   2459  CD1 LEU   152     -31.555 -30.734   8.480  1.00 54.70           C  
ATOM   2460  CD2 LEU   152     -29.124 -31.036   8.088  1.00 55.89           C  
ATOM   2461  C   LEU   152     -28.583 -29.329  12.283  1.00 54.42           C  
ATOM   2462  O   LEU   152     -29.484 -29.115  13.102  1.00 55.22           O  
ATOM   2463  N   ARG   153     -27.428 -28.663  12.295  1.00 52.31           N  
ATOM   2464  CA  ARG   153     -27.144 -27.612  13.278  1.00 51.68           C  
ATOM   2465  CB  ARG   153     -26.373 -28.172  14.477  1.00 52.51           C  
ATOM   2466  CG  ARG   153     -25.083 -28.892  14.125  1.00 50.80           C  
ATOM   2467  CD  ARG   153     -24.542 -29.622  15.333  1.00 53.69           C  
ATOM   2468  NE  ARG   153     -23.105 -29.850  15.200  1.00 63.01           N  
ATOM   2469  CZ  ARG   153     -22.323 -30.400  16.126  1.00 64.47           C  
ATOM   2470  NH1 ARG   153     -21.023 -30.546  15.886  1.00 68.07           N  
ATOM   2471  NH2 ARG   153     -22.829 -30.798  17.284  1.00 63.45           N  
ATOM   2472  C   ARG   153     -26.386 -26.451  12.648  1.00 52.21           C  
ATOM   2473  O   ARG   153     -25.879 -26.578  11.547  1.00 53.85           O  
ATOM   2474  N   LEU   154     -26.319 -25.315  13.336  1.00 51.57           N  
ATOM   2475  CA  LEU   154     -25.680 -24.130  12.766  1.00 52.35           C  
ATOM   2476  CB  LEU   154     -26.721 -23.231  12.090  1.00 52.38           C  
ATOM   2477  CG  LEU   154     -26.467 -22.286  10.901  1.00 52.33           C  
ATOM   2478  CD1 LEU   154     -27.189 -20.956  11.106  1.00 47.55           C  
ATOM   2479  CD2 LEU   154     -25.026 -22.063  10.579  1.00 48.79           C  
ATOM   2480  C   LEU   154     -25.072 -23.360  13.896  1.00 52.80           C  
ATOM   2481  O   LEU   154     -25.697 -23.188  14.942  1.00 53.27           O  
ATOM   2482  N   LYS   155     -23.857 -22.884  13.695  1.00 54.03           N  
ATOM   2483  CA  LYS   155     -23.210 -22.072  14.698  1.00 53.75           C  
ATOM   2484  CB  LYS   155     -21.808 -22.611  14.979  1.00 55.85           C  
ATOM   2485  CG  LYS   155     -20.962 -21.753  15.901  1.00 57.65           C  
ATOM   2486  CD  LYS   155     -19.797 -22.552  16.432  1.00 58.41           C  
ATOM   2487  CE  LYS   155     -19.025 -21.762  17.482  1.00 61.53           C  
ATOM   2488  NZ  LYS   155     -17.729 -22.434  17.833  1.00 61.73           N  
ATOM   2489  C   LYS   155     -23.165 -20.676  14.117  1.00 53.84           C  
ATOM   2490  O   LYS   155     -22.699 -20.499  12.988  1.00 55.18           O  
ATOM   2491  N   VAL   156     -23.674 -19.700  14.862  1.00 52.45           N  
ATOM   2492  CA  VAL   156     -23.556 -18.300  14.472  1.00 54.93           C  
ATOM   2493  CB  VAL   156     -24.930 -17.581  14.360  1.00 54.69           C  
ATOM   2494  CG1 VAL   156     -24.741 -16.232  13.689  1.00 56.14           C  
ATOM   2495  CG2 VAL   156     -25.951 -18.416  13.576  1.00 49.56           C  
ATOM   2496  C   VAL   156     -22.632 -17.561  15.461  1.00 58.78           C  
ATOM   2497  O   VAL   156     -22.924 -17.498  16.665  1.00 60.84           O  
ATOM   2498  N   THR   157     -21.513 -17.033  14.962  1.00 58.75           N  
ATOM   2499  CA  THR   157     -20.559 -16.320  15.798  1.00 60.81           C  
ATOM   2500  CB  THR   157     -19.108 -16.854  15.583  1.00 62.18           C  
ATOM   2501  OG1 THR   157     -19.027 -18.220  16.000  1.00 58.31           O  
ATOM   2502  CG2 THR   157     -18.095 -16.036  16.379  1.00 62.08           C  
ATOM   2503  C   THR   157     -20.625 -14.811  15.527  1.00 63.37           C  
ATOM   2504  O   THR   157     -20.504 -14.370  14.388  1.00 63.80           O  
ATOM   2505  N   VAL   158     -20.828 -14.022  16.576  1.00 66.77           N  
ATOM   2506  CA  VAL   158     -20.822 -12.551  16.450  1.00 70.21           C  
ATOM   2507  CB  VAL   158     -21.831 -11.874  17.422  1.00 69.55           C  
ATOM   2508  CG1 VAL   158     -21.914 -10.371  17.168  1.00 69.21           C  
ATOM   2509  CG2 VAL   158     -23.219 -12.517  17.312  1.00 67.10           C  
ATOM   2510  C   VAL   158     -19.409 -11.981  16.672  1.00 73.89           C  
ATOM   2511  O   VAL   158     -18.845 -12.102  17.757  1.00 75.32           O  
ATOM   2512  N   SER   159     -18.835 -11.372  15.644  1.00 77.42           N  
ATOM   2513  CA  SER   159     -17.496 -10.820  15.775  1.00 83.01           C  
ATOM   2514  CB  SER   159     -16.788 -10.776  14.420  1.00 85.68           C  
ATOM   2515  OG  SER   159     -17.666 -10.308  13.413  1.00 90.57           O  
ATOM   2516  C   SER   159     -17.541  -9.437  16.394  1.00 84.74           C  
ATOM   2517  O   SER   159     -18.626  -8.866  16.577  1.00 83.29           O  
ATOM   2518  N   GLY   160     -16.354  -8.920  16.723  1.00 87.89           N  
ATOM   2519  CA  GLY   160     -16.183  -7.557  17.229  1.00 90.83           C  
ATOM   2520  C   GLY   160     -15.287  -7.479  18.454  1.00 93.62           C  
ATOM   2521  O   GLY   160     -15.753  -7.589  19.593  1.00 92.80           O  
END
