
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  132 (  998),  selected  132 , name 2hhg_A
# Molecule2: number of CA atoms  134 ( 1020),  selected  134 , name T0389.pdb
# PARAMETERS: 2hhg_A.T0389.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    P     2_A      -       -           -
LGA    Q     3_A      -       -           -
LGA    T     4_A      -       -           -
LGA    I     5_A      -       -           -
LGA    T     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    G     8_A      -       -           -
LGA    I     9_A      -       -           -
LGA    K    10_A      -       -           -
LGA    A    11_A      -       -           -
LGA    X    12_A      -       -           -
LGA    L    13_A      -       -           -
LGA    D    14_A      -       -           -
LGA    E    15_A      M       1           #
LGA    A    16_A      -       -           -
LGA    N    17_A      -       -           -
LGA    S    18_A      -       -           -
LGA    S    19_A      I       2          2.473
LGA    I    20_A      G       3          2.107
LGA    E    21_A      T       4          2.259
LGA    T    22_A      Q       5          0.667
LGA    L    23_A      I       6          0.302
LGA    T    24_A      V       7          0.872
LGA    T    25_A      T       8          0.973
LGA    A    26_A      E       9          0.537
LGA    D    27_A      R      10          0.608
LGA    A    28_A      L      11          0.942
LGA    I    29_A      V      12          1.862
LGA    A    30_A      A      13          2.124
LGA    L    31_A      L      14          1.836
LGA    H    32_A      L      15          2.336
LGA    K    33_A      E      16          2.917
LGA    S    34_A      S      17          2.996
LGA    G    35_A      G      18           #
LGA    A    36_A      T      19           -
LGA    S    37_A      E      20          3.811
LGA    D    38_A      K      21          2.006
LGA    V    39_A      V      22          1.393
LGA    V    40_A      L      23          0.340
LGA    I    41_A      L      24          0.425
LGA    V    42_A      I      25          0.472
LGA    D    43_A      D      26          0.530
LGA    I    44_A      S      27          0.449
LGA    R    45_A      R      28          0.532
LGA    D    46_A      P      29          0.365
LGA    P    47_A      F      30          0.860
LGA    R    48_A      V      31          1.735
LGA    E    49_A      E      32          1.690
LGA    I    50_A      Y      33          1.904
LGA    E    51_A      N      34          3.296
LGA    R    52_A      T      35          3.512
LGA    D    53_A      -       -           -
LGA    G    54_A      S      36          0.452
LGA    K    55_A      H      37          0.608
LGA    I    56_A      I      38          0.769
LGA    P    57_A      L      39          0.885
LGA    G    58_A      E      40          0.804
LGA    S    59_A      A      41          0.969
LGA    F    60_A      I      42          0.859
LGA    S    61_A      N      43          0.816
LGA    C    62_A      I      44          0.572
LGA    T    63_A      N      45          2.047
LGA    R    64_A      C      46          3.388
LGA    G    65_A      S      47          3.393
LGA    -       -      K      48           -
LGA    -       -      L      49           -
LGA    -       -      M      50           -
LGA    X    66_A      K      51          4.803
LGA    L    67_A      R      52           -
LGA    E    68_A      R      53           #
LGA    F    69_A      L      54          3.662
LGA    -       -      Q      55           -
LGA    -       -      Q      56           -
LGA    -       -      D      57           -
LGA    -       -      K      58           -
LGA    W    70_A      V      59          5.002
LGA    -       -      L      60           -
LGA    I    71_A      I      61          0.634
LGA    D    72_A      T      62           #
LGA    P    73_A      -       -           -
LGA    Q    74_A      -       -           -
LGA    S    75_A      -       -           -
LGA    P    76_A      -       -           -
LGA    Y    77_A      -       -           -
LGA    A    78_A      E      63          2.182
LGA    K    79_A      L      64          3.749
LGA    P    80_A      I      65           #
LGA    I    81_A      Q      66          4.281
LGA    F    82_A      H      67           -
LGA    Q    83_A      S      68           -
LGA    -       -      A      69           -
LGA    -       -      K      70           -
LGA    -       -      H      71           -
LGA    -       -      K      72           -
LGA    -       -      V      73           -
LGA    -       -      D      74           -
LGA    E    84_A      I      75          2.311
LGA    D    85_A      D      76          2.290
LGA    -       -      C      77           -
LGA    K    86_A      S      78          3.168
LGA    K    87_A      Q      79          3.238
LGA    -       -      K      80           -
LGA    F    88_A      V      81          1.289
LGA    V    89_A      V      82          0.804
LGA    F    90_A      V      83          0.346
LGA    Y    91_A      Y      84          0.871
LGA    C    92_A      D      85          1.014
LGA    A    93_A      Q      86          0.977
LGA    G    94_A      S      87          0.707
LGA    G    95_A      S      88          2.399
LGA    L    96_A      Q      89          5.365
LGA    R    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    A    99_A      D      90          5.462
LGA    L   100_A      V      91          5.500
LGA    -       -      A      92           -
LGA    -       -      S      93           -
LGA    -       -      L      94           -
LGA    -       -      S      95           -
LGA    -       -      S      96           -
LGA    -       -      D      97           -
LGA    -       -      C      98           -
LGA    -       -      F      99           -
LGA    -       -      L     100           -
LGA    -       -      T     101           -
LGA    A   101_A      V     102           #
LGA    A   102_A      L     103           #
LGA    K   103_A      L     104          3.444
LGA    T   104_A      G     105          2.051
LGA    A   105_A      K     106          2.568
LGA    Q   106_A      L     107          4.744
LGA    D   107_A      E     108           #
LGA    X   108_A      K     109          4.006
LGA    G   109_A      S     110          4.577
LGA    L   110_A      F     111          3.462
LGA    K   111_A      N     112          2.334
LGA    P   112_A      S     113          1.648
LGA    V   113_A      V     114          0.468
LGA    A   114_A      H     115          0.562
LGA    H   115_A      L     116          1.225
LGA    I   116_A      L     117          0.806
LGA    E   117_A      A     118          0.627
LGA    G   118_A      G     119          0.457
LGA    G   119_A      G     120          0.582
LGA    F   120_A      F     121          0.709
LGA    G   121_A      A     122          0.746
LGA    A   122_A      E     123          0.639
LGA    W   123_A      F     124          0.568
LGA    R   124_A      S     125          1.241
LGA    D   125_A      R     126          1.326
LGA    A   126_A      C     127          0.975
LGA    G   127_A      F     128          2.025
LGA    G   128_A      P     129          4.601
LGA    -       -      G     130           -
LGA    P   129_A      L     131          0.553
LGA    I   130_A      C     132          0.782
LGA    E   131_A      E     133          0.613
LGA    -       -      G     134           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  132  134    5.0     94    2.33    19.15     50.530     3.868

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.446079 * X  +   0.163841 * Y  +   0.879869 * Z  + -21.267878
  Y_new =   0.187986 * X  +   0.944018 * Y  +  -0.271092 * Z  +  -7.967219
  Z_new =  -0.875029 * X  +   0.286331 * Y  +   0.390307 * Z  +  -3.810861 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.632926   -2.508667  [ DEG:    36.2640   -143.7360 ]
  Theta =   1.065495    2.076098  [ DEG:    61.0484    118.9516 ]
  Phi   =   0.398833   -2.742760  [ DEG:    22.8514   -157.1486 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hhg_A                                        
REMARK     2: T0389.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hhg_A.T0389.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  132  134   5.0   94   2.33   19.15  50.530
REMARK  ---------------------------------------------------------- 
MOLECULE 2hhg_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   28-JUN-06   2HHG              
TITLE     STRUCTURE OF PROTEIN OF UNKNOWN FUNCTION RPA3614, POSSIBLE            
TITLE    2 TYROSINE PHOSPHATASE, FROM RHODOPSEUDOMONAS PALUSTRIS                
TITLE    3 CGA009                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN RPA3614;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHODOPSEUDOMONAS PALUSTRIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: CGA009;                                                      
SOURCE   5 GENE: RPA3614;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    MCSG, STRUCTURAL GENOMICS, HYPOTHETICAL PROTEIN,                      
KEYWDS   2 ROHOPSEUDOMONAS PALUSTRIS, PSI-2, PROTEIN STRUCTURE                  
KEYWDS   3 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.A.BINKOWSKI,E.EVDOKIMOVA,A.SACHECKO,A.EDWARDS,                      
AUTHOR   2 A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   1   25-JUL-06 2HHG    0                                                
JRNL        AUTH   T.A.BINKOWSKI,E.EVDOKIMOVA,A.SACHECKO,A.EDWARDS,             
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   HYPOTHETICAL PROTEIN RPA3614 FROM RHODOPSEUDOMONAS           
JRNL        TITL 2 PALUSTRIS CGA009                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.20 ANGSTROMS.                                          
DBREF  2HHG A    1   138  UNP    Q6N3S9   Q6N3S9_RHOPA     1    138             
SEQRES   1 A  139  GLY MSE PRO GLN THR ILE THR ARG GLY ILE LYS ALA MSE          
SEQRES   2 A  139  LEU ASP GLU ALA ASN SER SER ILE GLU THR LEU THR THR          
SEQRES   3 A  139  ALA ASP ALA ILE ALA LEU HIS LYS SER GLY ALA SER ASP          
SEQRES   4 A  139  VAL VAL ILE VAL ASP ILE ARG ASP PRO ARG GLU ILE GLU          
SEQRES   5 A  139  ARG ASP GLY LYS ILE PRO GLY SER PHE SER CYS THR ARG          
SEQRES   6 A  139  GLY MSE LEU GLU PHE TRP ILE ASP PRO GLN SER PRO TYR          
SEQRES   7 A  139  ALA LYS PRO ILE PHE GLN GLU ASP LYS LYS PHE VAL PHE          
SEQRES   8 A  139  TYR CYS ALA GLY GLY LEU ARG SER ALA LEU ALA ALA LYS          
SEQRES   9 A  139  THR ALA GLN ASP MSE GLY LEU LYS PRO VAL ALA HIS ILE          
SEQRES  10 A  139  GLU GLY GLY PHE GLY ALA TRP ARG ASP ALA GLY GLY PRO          
SEQRES  11 A  139  ILE GLU ALA TRP ALA PRO LYS LYS LYS                          
HET    MSE  A   1       8                                                       
HET    MSE  A  12       8                                                       
HET    MSE  A  66       8                                                       
HET    MSE  A 108       8                                                       
HET    PO4   4285       5                                                       
HET     NA      1       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM      NA SODIUM ION                                                       
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2  PO4    O4 P 3-                                                      
FORMUL   3   NA    NA 1+                                                        
FORMUL   4  HOH   *168(H2 O)                                                    
CRYST1   66.118   42.505   42.251  90.00 105.19  90.00 C 1 2 1       4          
ATOM      1  N   GLY A   0     -36.704   4.241  23.659  1.00 17.18           N  
ATOM      2  CA  GLY A   0     -37.071   3.412  22.541  1.00 16.20           C  
ATOM      3  C   GLY A   0     -35.879   2.520  22.147  1.00 15.55           C  
ATOM      4  O   GLY A   0     -34.836   2.654  22.688  1.00 15.17           O  
HETATM    5  N   MSE A   1     -36.098   1.576  21.252  1.00 20.00           N  
HETATM    6  CA  MSE A   1     -35.028   0.655  20.862  1.00 20.00           C  
HETATM    7  C   MSE A   1     -34.050   1.401  19.994  1.00 20.00           C  
HETATM    8  O   MSE A   1     -34.447   2.120  19.120  1.00 14.81           O  
HETATM    9  CB  MSE A   1     -35.577  -0.513  20.022  1.00 20.00           C  
HETATM   10  CG  MSE A   1     -36.579  -1.459  20.781  1.00 20.00           C  
HETATM   11 SE   MSE A   1     -35.528  -2.505  22.035  1.00 20.00          SE  
HETATM   12  CE  MSE A   1     -34.469  -3.578  20.762  1.00 20.00           C  
ATOM     13  N   PRO A   2     -32.770   1.189  20.183  1.00 13.32           N  
ATOM     14  CA  PRO A   2     -31.771   1.948  19.444  1.00 13.32           C  
ATOM     15  C   PRO A   2     -31.666   1.396  18.020  1.00 12.80           C  
ATOM     16  O   PRO A   2     -32.159   0.345  17.702  1.00 13.23           O  
ATOM     17  CB  PRO A   2     -30.536   1.713  20.231  1.00 13.61           C  
ATOM     18  CG  PRO A   2     -30.689   0.357  20.814  1.00 13.13           C  
ATOM     19  CD  PRO A   2     -32.164   0.286  21.161  1.00 13.23           C  
ATOM     20  N   GLN A   3     -31.008   2.176  17.191  1.00 12.03           N  
ATOM     21  CA  GLN A   3     -30.655   1.720  15.864  1.00 11.20           C  
ATOM     22  C   GLN A   3     -29.693   0.559  15.988  1.00 11.33           C  
ATOM     23  O   GLN A   3     -28.851   0.540  16.892  1.00 12.34           O  
ATOM     24  CB  GLN A   3     -29.979   2.852  15.101  1.00 10.58           C  
ATOM     25  CG  GLN A   3     -30.900   4.018  14.803  1.00  9.35           C  
ATOM     26  CD  GLN A   3     -31.847   3.727  13.649  1.00  8.87           C  
ATOM     27  OE1 GLN A   3     -31.580   2.875  12.793  1.00  9.31           O  
ATOM     28  NE2 GLN A   3     -32.952   4.450  13.614  1.00 10.09           N  
ATOM     29  N   THR A   4     -29.815  -0.404  15.081  1.00 11.52           N  
ATOM     30  CA  THR A   4     -28.925  -1.550  15.098  0.50 12.25           C  
ATOM     32  C   THR A   4     -28.007  -1.530  13.879  1.00 12.05           C  
ATOM     33  O   THR A   4     -28.428  -1.735  12.738  1.00 12.29           O  
ATOM     34  CB  THR A   4     -29.702  -2.882  15.303  0.50 12.62           C  
ATOM     36  OG1 THR A   4     -28.889  -4.005  14.936  0.50 13.06           O  
ATOM     38  CG2 THR A   4     -30.987  -2.885  14.509  0.50 13.89           C  
ATOM     40  N   ILE A   5     -26.743  -1.246  14.144  1.00 11.63           N  
ATOM     41  CA  ILE A   5     -25.766  -1.170  13.094  1.00 11.92           C  
ATOM     42  C   ILE A   5     -25.163  -2.558  12.945  1.00 11.71           C  
ATOM     43  O   ILE A   5     -24.637  -3.142  13.903  1.00 12.56           O  
ATOM     44  CB  ILE A   5     -24.712  -0.069  13.373  1.00 12.06           C  
ATOM     45  CG1 ILE A   5     -25.396   1.312  13.470  1.00 12.03           C  
ATOM     46  CG2 ILE A   5     -23.597  -0.096  12.330  1.00 12.64           C  
ATOM     47  CD1 ILE A   5     -26.311   1.679  12.292  1.00 11.88           C  
ATOM     48  N   THR A   6     -25.288  -3.092  11.738  1.00 11.26           N  
ATOM     49  CA  THR A   6     -24.827  -4.436  11.429  1.00 11.66           C  
ATOM     50  C   THR A   6     -23.591  -4.454  10.527  1.00 11.89           C  
ATOM     51  O   THR A   6     -22.948  -5.493  10.381  1.00 12.78           O  
ATOM     52  CB  THR A   6     -25.966  -5.254  10.821  1.00 11.52           C  
ATOM     53  OG1 THR A   6     -26.642  -4.461   9.837  1.00 12.09           O  
ATOM     54  CG2 THR A   6     -26.960  -5.643  11.918  1.00 12.53           C  
ATOM     55  N   ARG A   7     -23.261  -3.306   9.937  1.00 11.51           N  
ATOM     56  CA  ARG A   7     -22.029  -3.133   9.167  1.00 11.73           C  
ATOM     57  C   ARG A   7     -21.427  -1.804   9.581  1.00 11.53           C  
ATOM     58  O   ARG A   7     -21.972  -0.736   9.283  1.00 11.65           O  
ATOM     59  CB  ARG A   7     -22.309  -3.163   7.665  1.00 12.18           C  
ATOM     60  CG  ARG A   7     -21.105  -2.834   6.788  1.00 13.69           C  
ATOM     61  CD  ARG A   7     -21.463  -2.968   5.317  1.00 15.41           C  
ATOM     62  NE  ARG A   7     -20.433  -2.410   4.442  1.00 16.07           N  
ATOM     63  CZ  ARG A   7     -19.319  -3.044   4.085  1.00 16.23           C  
ATOM     64  NH1 ARG A   7     -19.064  -4.268   4.533  1.00 16.42           N  
ATOM     65  NH2 ARG A   7     -18.450  -2.445   3.278  1.00 17.69           N  
ATOM     66  N   GLY A   8     -20.318  -1.875  10.304  1.00 10.92           N  
ATOM     67  CA  GLY A   8     -19.696  -0.686  10.854  1.00 11.28           C  
ATOM     68  C   GLY A   8     -18.357  -0.380  10.221  1.00 10.65           C  
ATOM     69  O   GLY A   8     -17.946  -1.016   9.239  1.00 11.18           O  
ATOM     70  N   ILE A   9     -17.664   0.597  10.793  1.00 10.45           N  
ATOM     71  CA  ILE A   9     -16.384   1.017  10.235  1.00 10.13           C  
ATOM     72  C   ILE A   9     -15.322  -0.077  10.304  1.00 10.09           C  
ATOM     73  O   ILE A   9     -14.450  -0.133   9.437  1.00  9.74           O  
ATOM     74  CB  ILE A   9     -15.858   2.348  10.835  1.00 10.06           C  
ATOM     75  CG1 ILE A   9     -15.511   2.192  12.320  1.00 11.06           C  
ATOM     76  CG2 ILE A   9     -16.852   3.491  10.580  1.00 11.08           C  
ATOM     77  CD1 ILE A   9     -14.689   3.346  12.892  1.00 12.78           C  
ATOM     78  N   LYS A  10     -15.405  -0.960  11.297  1.00 10.25           N  
ATOM     79  CA  LYS A  10     -14.436  -2.050  11.387  1.00 11.47           C  
ATOM     80  C   LYS A  10     -14.447  -2.905  10.115  1.00 11.51           C  
ATOM     81  O   LYS A  10     -13.394  -3.156   9.526  1.00 11.74           O  
ATOM     82  CB  LYS A  10     -14.689  -2.900  12.631  1.00 11.96           C  
ATOM     83  CG  LYS A  10     -13.642  -3.976  12.856  1.00 14.86           C  
ATOM     84  CD  LYS A  10     -13.897  -4.739  14.146  1.00 18.39           C  
ATOM     85  CE  LYS A  10     -12.723  -5.632  14.501  1.00 19.52           C  
ATOM     86  NZ  LYS A  10     -12.421  -6.587  13.407  1.00 22.02           N  
ATOM     87  N   ALA A  11     -15.637  -3.321   9.683  1.00 11.50           N  
ATOM     88  CA  ALA A  11     -15.782  -4.105   8.456  1.00 11.53           C  
ATOM     89  C   ALA A  11     -15.322  -3.324   7.231  1.00 11.31           C  
ATOM     90  O   ALA A  11     -14.607  -3.854   6.382  1.00 11.36           O  
ATOM     91  CB  ALA A  11     -17.221  -4.563   8.277  1.00 12.15           C  
HETATM   92  N   MSE A  12     -15.731  -2.064   7.147  1.00 10.68           N  
HETATM   93  CA  MSE A  12     -15.376  -1.226   6.003  1.00 10.30           C  
HETATM   94  C   MSE A  12     -13.879  -0.992   5.898  1.00 10.19           C  
HETATM   95  O   MSE A  12     -13.318  -1.029   4.800  1.00 10.35           O  
HETATM   96  CB  MSE A  12     -16.086   0.118   6.065  1.00 10.75           C  
HETATM   97  CG  MSE A  12     -17.589   0.023   6.008  1.00 12.26           C  
HETATM   98 SE   MSE A  12     -18.308   1.772   6.343  1.00 21.50          SE  
HETATM   99  CE  MSE A  12     -20.083   1.223   6.866  1.00 20.25           C  
ATOM    100  N   LEU A  13     -13.244  -0.743   7.040  1.00  9.82           N  
ATOM    101  CA  LEU A  13     -11.813  -0.475   7.088  1.00 10.36           C  
ATOM    102  C   LEU A  13     -10.985  -1.716   6.774  1.00 11.59           C  
ATOM    103  O   LEU A  13      -9.963  -1.620   6.087  1.00 11.68           O  
ATOM    104  CB  LEU A  13     -11.422   0.130   8.437  1.00 10.41           C  
ATOM    105  CG  LEU A  13     -11.872   1.580   8.644  1.00  9.94           C  
ATOM    106  CD1 LEU A  13     -11.775   1.968  10.106  1.00 10.80           C  
ATOM    107  CD2 LEU A  13     -11.072   2.548   7.769  1.00 10.46           C  
ATOM    108  N   ASP A  14     -11.431  -2.875   7.259  1.00 12.45           N  
ATOM    109  CA  ASP A  14     -10.766  -4.138   6.954  0.50 13.15           C  
ATOM    111  C   ASP A  14     -10.756  -4.375   5.449  1.00 13.13           C  
ATOM    112  O   ASP A  14      -9.709  -4.684   4.865  1.00 13.78           O  
ATOM    113  CB  ASP A  14     -11.455  -5.309   7.661  0.50 13.68           C  
ATOM    115  CG  ASP A  14     -10.900  -6.656   7.227  0.50 14.78           C  
ATOM    117  OD1 ASP A  14      -9.677  -6.866   7.356  0.50 15.96           O  
ATOM    119  OD2 ASP A  14     -11.685  -7.497   6.745  0.50 16.77           O  
ATOM    121  N   GLU A  15     -11.922  -4.218   4.824  1.00 12.91           N  
ATOM    122  CA  GLU A  15     -12.066  -4.386   3.379  1.00 12.85           C  
ATOM    123  C   GLU A  15     -11.171  -3.421   2.606  1.00 12.16           C  
ATOM    124  O   GLU A  15     -10.544  -3.805   1.615  1.00 12.49           O  
ATOM    125  CB  GLU A  15     -13.517  -4.168   2.949  1.00 13.46           C  
ATOM    126  CG  GLU A  15     -14.479  -5.284   3.326  1.00 15.78           C  
ATOM    127  CD  GLU A  15     -15.935  -4.929   3.049  1.00 17.93           C  
ATOM    128  OE1 GLU A  15     -16.200  -3.962   2.304  1.00 19.12           O  
ATOM    129  OE2 GLU A  15     -16.822  -5.620   3.587  1.00 20.80           O  
ATOM    130  N   ALA A  16     -11.124  -2.171   3.059  1.00 11.24           N  
ATOM    131  CA  ALA A  16     -10.308  -1.157   2.410  1.00 11.05           C  
ATOM    132  C   ALA A  16      -8.820  -1.444   2.587  1.00 11.43           C  
ATOM    133  O   ALA A  16      -8.079  -1.524   1.600  1.00 10.77           O  
ATOM    134  CB  ALA A  16     -10.658   0.223   2.941  1.00 10.70           C  
ATOM    135  N   ASN A  17      -8.396  -1.610   3.838  1.00 12.36           N  
ATOM    136  CA  ASN A  17      -6.984  -1.834   4.149  1.00 13.50           C  
ATOM    137  C   ASN A  17      -6.356  -2.982   3.375  1.00 13.66           C  
ATOM    138  O   ASN A  17      -5.222  -2.860   2.899  1.00 14.14           O  
ATOM    139  CB  ASN A  17      -6.784  -2.048   5.647  1.00 14.05           C  
ATOM    140  CG  ASN A  17      -6.881  -0.766   6.435  1.00 16.49           C  
ATOM    141  OD1 ASN A  17      -6.492   0.301   5.962  1.00 20.85           O  
ATOM    142  ND2 ASN A  17      -7.391  -0.863   7.656  1.00 17.24           N  
ATOM    143  N   SER A  18      -7.084  -4.082   3.233  1.00 13.71           N  
ATOM    144  CA  SER A  18      -6.541  -5.273   2.584  1.00 13.79           C  
ATOM    145  C   SER A  18      -6.511  -5.179   1.057  1.00 13.01           C  
ATOM    146  O   SER A  18      -5.956  -6.052   0.387  1.00 13.01           O  
ATOM    147  CB  SER A  18      -7.312  -6.516   3.027  1.00 15.03           C  
ATOM    148  OG  SER A  18      -8.638  -6.470   2.551  1.00 16.75           O  
ATOM    149  N   SER A  19      -7.104  -4.115   0.519  1.00 11.68           N  
ATOM    150  CA  SER A  19      -7.209  -3.904  -0.923  1.00 11.34           C  
ATOM    151  C   SER A  19      -6.323  -2.764  -1.425  1.00 10.01           C  
ATOM    152  O   SER A  19      -6.137  -2.622  -2.632  1.00  9.65           O  
ATOM    153  CB  SER A  19      -8.665  -3.600  -1.300  1.00 12.23           C  
ATOM    154  OG  SER A  19      -9.501  -4.731  -1.127  1.00 16.07           O  
ATOM    155  N   ILE A  20      -5.808  -1.940  -0.512  1.00  9.18           N  
ATOM    156  CA  ILE A  20      -5.085  -0.731  -0.900  1.00  8.71           C  
ATOM    157  C   ILE A  20      -3.662  -0.671  -0.358  1.00  9.01           C  
ATOM    158  O   ILE A  20      -3.318  -1.364   0.596  1.00  9.11           O  
ATOM    159  CB  ILE A  20      -5.843   0.553  -0.455  1.00  8.55           C  
ATOM    160  CG1 ILE A  20      -5.796   0.697   1.075  1.00  9.83           C  
ATOM    161  CG2 ILE A  20      -7.272   0.559  -1.004  1.00  8.97           C  
ATOM    162  CD1 ILE A  20      -6.518   1.923   1.615  1.00  9.93           C  
ATOM    163  N   GLU A  21      -2.854   0.181  -0.978  1.00  8.83           N  
ATOM    164  CA  GLU A  21      -1.533   0.509  -0.468  1.00  9.25           C  
ATOM    165  C   GLU A  21      -1.638   1.463   0.713  1.00  8.98           C  
ATOM    166  O   GLU A  21      -2.147   2.588   0.575  1.00  8.71           O  
ATOM    167  CB  GLU A  21      -0.681   1.147  -1.564  1.00  9.37           C  
ATOM    168  CG  GLU A  21       0.674   1.636  -1.047  1.00  8.92           C  
ATOM    169  CD  GLU A  21       1.542   2.318  -2.092  1.00  9.67           C  
ATOM    170  OE1 GLU A  21       1.168   2.353  -3.280  1.00 11.02           O  
ATOM    171  OE2 GLU A  21       2.618   2.816  -1.708  1.00 11.24           O  
ATOM    172  N   THR A  22      -1.144   1.023   1.865  1.00  9.43           N  
ATOM    173  CA  THR A  22      -0.932   1.921   2.987  1.00 10.79           C  
ATOM    174  C   THR A  22       0.526   2.333   2.959  1.00 10.45           C  
ATOM    175  O   THR A  22       1.443   1.528   3.190  1.00 10.49           O  
ATOM    176  CB  THR A  22      -1.312   1.298   4.342  1.00 11.30           C  
ATOM    177  OG1 THR A  22      -2.714   1.012   4.346  1.00 14.04           O  
ATOM    178  CG2 THR A  22      -1.022   2.272   5.480  1.00 13.37           C  
ATOM    179  N   LEU A  23       0.728   3.596   2.636  1.00 10.61           N  
ATOM    180  CA  LEU A  23       2.042   4.173   2.544  1.00 11.26           C  
ATOM    181  C   LEU A  23       2.441   4.620   3.947  1.00 10.98           C  
ATOM    182  O   LEU A  23       1.693   5.355   4.591  1.00 11.28           O  
ATOM    183  CB  LEU A  23       1.942   5.352   1.580  1.00 11.87           C  
ATOM    184  CG  LEU A  23       3.143   6.150   1.115  1.00 12.69           C  
ATOM    185  CD1 LEU A  23       4.160   5.274   0.402  1.00 11.46           C  
ATOM    186  CD2 LEU A  23       2.643   7.254   0.195  1.00 13.68           C  
ATOM    187  N   THR A  24       3.598   4.172   4.440  1.00 11.22           N  
ATOM    188  CA  THR A  24       4.039   4.603   5.773  1.00 11.39           C  
ATOM    189  C   THR A  24       4.229   6.115   5.797  1.00 10.95           C  
ATOM    190  O   THR A  24       4.487   6.738   4.763  1.00 10.05           O  
ATOM    191  CB  THR A  24       5.353   3.939   6.242  1.00 11.90           C  
ATOM    192  OG1 THR A  24       6.444   4.403   5.443  1.00 12.08           O  
ATOM    193  CG2 THR A  24       5.266   2.420   6.184  1.00 13.12           C  
ATOM    194  N   THR A  25       4.091   6.701   6.977  1.00 10.89           N  
ATOM    195  CA  THR A  25       4.261   8.135   7.117  1.00 11.57           C  
ATOM    196  C   THR A  25       5.638   8.561   6.606  1.00 10.92           C  
ATOM    197  O   THR A  25       5.751   9.541   5.865  1.00 10.67           O  
ATOM    198  CB  THR A  25       4.055   8.570   8.569  1.00 11.80           C  
ATOM    199  OG1 THR A  25       2.934   7.863   9.118  1.00 13.36           O  
ATOM    200  CG2 THR A  25       3.801  10.056   8.642  1.00 13.18           C  
ATOM    201  N   ALA A  26       6.674   7.797   6.960  1.00 11.00           N  
ATOM    202  CA  ALA A  26       8.038   8.124   6.561  1.00 10.98           C  
ATOM    203  C   ALA A  26       8.214   8.049   5.045  1.00 10.52           C  
ATOM    204  O   ALA A  26       8.858   8.909   4.446  1.00 10.45           O  
ATOM    205  CB  ALA A  26       9.039   7.221   7.265  1.00 11.58           C  
ATOM    206  N   ASP A  27       7.631   7.030   4.420  1.00 10.01           N  
ATOM    207  CA  ASP A  27       7.706   6.908   2.969  1.00  9.94           C  
ATOM    208  C   ASP A  27       6.963   8.042   2.257  1.00  8.91           C  
ATOM    209  O   ASP A  27       7.428   8.554   1.243  1.00  8.96           O  
ATOM    210  CB  ASP A  27       7.165   5.558   2.500  1.00 10.26           C  
ATOM    211  CG  ASP A  27       8.088   4.405   2.834  1.00 12.28           C  
ATOM    212  OD1 ASP A  27       9.240   4.646   3.256  1.00 15.40           O  
ATOM    213  OD2 ASP A  27       7.652   3.246   2.672  1.00 13.25           O  
ATOM    214  N   ALA A  28       5.809   8.428   2.798  1.00  8.40           N  
ATOM    215  CA  ALA A  28       5.042   9.536   2.234  1.00  7.94           C  
ATOM    216  C   ALA A  28       5.802  10.865   2.338  1.00  8.01           C  
ATOM    217  O   ALA A  28       5.813  11.662   1.399  1.00  7.70           O  
ATOM    218  CB  ALA A  28       3.685   9.632   2.907  1.00  8.23           C  
ATOM    219  N   ILE A  29       6.443  11.088   3.482  1.00  8.56           N  
ATOM    220  CA  ILE A  29       7.259  12.280   3.675  1.00  8.83           C  
ATOM    221  C   ILE A  29       8.431  12.293   2.681  1.00  8.63           C  
ATOM    222  O   ILE A  29       8.700  13.317   2.039  1.00  8.44           O  
ATOM    223  CB  ILE A  29       7.724  12.413   5.146  1.00  8.68           C  
ATOM    224  CG1 ILE A  29       6.513  12.740   6.032  1.00  9.21           C  
ATOM    225  CG2 ILE A  29       8.816  13.479   5.286  1.00  9.03           C  
ATOM    226  CD1 ILE A  29       6.783  12.673   7.521  1.00 10.52           C  
ATOM    227  N   ALA A  30       9.104  11.152   2.531  1.00  8.95           N  
ATOM    228  CA  ALA A  30      10.217  11.054   1.585  1.00  9.46           C  
ATOM    229  C   ALA A  30       9.748  11.299   0.155  1.00  9.31           C  
ATOM    230  O   ALA A  30      10.419  11.983  -0.612  1.00  9.46           O  
ATOM    231  CB  ALA A  30      10.919   9.708   1.693  1.00 10.35           C  
ATOM    232  N   LEU A  31       8.581  10.753  -0.191  1.00  9.44           N  
ATOM    233  CA  LEU A  31       7.980  10.967  -1.505  1.00  9.59           C  
ATOM    234  C   LEU A  31       7.743  12.458  -1.762  1.00  9.03           C  
ATOM    235  O   LEU A  31       8.044  12.976  -2.835  1.00  9.27           O  
ATOM    236  CB  LEU A  31       6.662  10.189  -1.622  1.00 10.43           C  
ATOM    237  CG  LEU A  31       5.899  10.286  -2.948  1.00 11.35           C  
ATOM    238  CD1 LEU A  31       6.736   9.730  -4.095  1.00 13.29           C  
ATOM    239  CD2 LEU A  31       4.567   9.555  -2.852  1.00 12.80           C  
ATOM    240  N   HIS A  32       7.179  13.139  -0.773  1.00  8.43           N  
ATOM    241  CA  HIS A  32       6.919  14.565  -0.880  1.00  8.68           C  
ATOM    242  C   HIS A  32       8.212  15.360  -1.080  1.00  8.58           C  
ATOM    243  O   HIS A  32       8.279  16.237  -1.935  1.00  8.66           O  
ATOM    244  CB  HIS A  32       6.180  15.044   0.361  1.00  8.59           C  
ATOM    245  CG  HIS A  32       5.731  16.466   0.286  1.00  8.41           C  
ATOM    246  ND1 HIS A  32       6.539  17.519   0.660  1.00  9.68           N  
ATOM    247  CD2 HIS A  32       4.557  17.007  -0.109  1.00 10.28           C  
ATOM    248  CE1 HIS A  32       5.878  18.651   0.494  1.00 10.19           C  
ATOM    249  NE2 HIS A  32       4.671  18.368   0.034  1.00 10.02           N  
ATOM    250  N   LYS A  33       9.235  15.045  -0.291  1.00  8.53           N  
ATOM    251  CA  LYS A  33      10.520  15.734  -0.396  1.00  9.71           C  
ATOM    252  C   LYS A  33      11.215  15.521  -1.741  1.00 10.30           C  
ATOM    253  O   LYS A  33      11.982  16.377  -2.189  1.00 10.15           O  
ATOM    254  CB  LYS A  33      11.443  15.342   0.755  1.00  9.80           C  
ATOM    255  CG  LYS A  33      10.962  15.860   2.096  1.00 10.17           C  
ATOM    256  CD  LYS A  33      11.817  15.323   3.220  1.00 10.81           C  
ATOM    257  CE  LYS A  33      11.375  15.864   4.562  1.00 11.69           C  
ATOM    258  NZ  LYS A  33      12.162  15.260   5.670  1.00 12.48           N  
ATOM    259  N   SER A  34      10.930  14.394  -2.390  1.00 10.90           N  
ATOM    260  CA  SER A  34      11.527  14.084  -3.687  1.00 12.33           C  
ATOM    261  C   SER A  34      10.926  14.937  -4.808  1.00 13.44           C  
ATOM    262  O   SER A  34      11.452  14.956  -5.926  1.00 14.51           O  
ATOM    263  CB  SER A  34      11.382  12.588  -4.010  1.00 12.75           C  
ATOM    264  OG  SER A  34      10.061  12.274  -4.412  1.00 13.33           O  
ATOM    265  N   GLY A  35       9.825  15.624  -4.504  1.00 14.46           N  
ATOM    266  CA  GLY A  35       9.105  16.441  -5.478  1.00 15.94           C  
ATOM    267  C   GLY A  35       7.776  15.824  -5.885  1.00 17.10           C  
ATOM    268  O   GLY A  35       7.010  16.430  -6.639  1.00 17.79           O  
ATOM    269  N   ALA A  36       7.511  14.615  -5.383  1.00 18.15           N  
ATOM    270  CA  ALA A  36       6.278  13.866  -5.669  1.00 18.91           C  
ATOM    271  C   ALA A  36       5.913  13.835  -7.161  1.00 19.35           C  
ATOM    272  O   ALA A  36       4.761  14.084  -7.543  1.00 19.80           O  
ATOM    273  CB  ALA A  36       5.114  14.388  -4.816  1.00 19.13           C  
ATOM    274  N   SER A  37       6.904  13.524  -7.996  1.00 19.83           N  
ATOM    275  CA  SER A  37       6.704  13.425  -9.438  1.00 20.10           C  
ATOM    276  C   SER A  37       5.731  12.297  -9.766  1.00 19.52           C  
ATOM    277  O   SER A  37       5.834  11.191  -9.224  1.00 19.91           O  
ATOM    278  CB  SER A  37       8.032  13.220 -10.171  1.00 20.46           C  
ATOM    279  OG  SER A  37       8.831  14.390 -10.107  1.00 22.31           O  
ATOM    280  N   ASP A  38       4.782  12.601 -10.645  1.00 18.93           N  
ATOM    281  CA  ASP A  38       3.707  11.672 -11.016  1.00 18.12           C  
ATOM    282  C   ASP A  38       2.887  11.193  -9.806  1.00 16.72           C  
ATOM    283  O   ASP A  38       2.443  10.042  -9.755  1.00 16.03           O  
ATOM    284  CB  ASP A  38       4.247  10.483 -11.830  1.00 19.07           C  
ATOM    285  CG  ASP A  38       4.840  10.905 -13.167  1.00 20.92           C  
ATOM    286  OD1 ASP A  38       4.275  11.805 -13.828  1.00 22.92           O  
ATOM    287  OD2 ASP A  38       5.877  10.327 -13.557  1.00 24.31           O  
ATOM    288  N   VAL A  39       2.712  12.085  -8.833  1.00 15.00           N  
ATOM    289  CA  VAL A  39       1.883  11.827  -7.656  1.00 14.03           C  
ATOM    290  C   VAL A  39       0.989  13.042  -7.426  1.00 12.85           C  
ATOM    291  O   VAL A  39       1.422  14.184  -7.613  1.00 12.81           O  
ATOM    292  CB  VAL A  39       2.750  11.539  -6.386  1.00 14.62           C  
ATOM    293  CG1 VAL A  39       1.895  11.491  -5.118  1.00 15.13           C  
ATOM    294  CG2 VAL A  39       3.533  10.234  -6.540  1.00 15.77           C  
ATOM    295  N   VAL A  40      -0.263  12.782  -7.056  1.00 11.31           N  
ATOM    296  CA  VAL A  40      -1.165  13.816  -6.572  1.00 10.70           C  
ATOM    297  C   VAL A  40      -1.541  13.427  -5.148  1.00  9.83           C  
ATOM    298  O   VAL A  40      -2.080  12.334  -4.916  1.00  9.52           O  
ATOM    299  CB  VAL A  40      -2.439  13.937  -7.443  1.00 10.77           C  
ATOM    300  CG1 VAL A  40      -3.390  14.982  -6.863  1.00 11.52           C  
ATOM    301  CG2 VAL A  40      -2.086  14.278  -8.884  1.00 12.39           C  
ATOM    302  N   ILE A  41      -1.235  14.310  -4.202  1.00  9.22           N  
ATOM    303  CA  ILE A  41      -1.597  14.097  -2.808  1.00  9.01           C  
ATOM    304  C   ILE A  41      -2.918  14.810  -2.565  1.00  8.78           C  
ATOM    305  O   ILE A  41      -3.022  16.012  -2.771  1.00  9.17           O  
ATOM    306  CB  ILE A  41      -0.485  14.579  -1.847  1.00  9.04           C  
ATOM    307  CG1 ILE A  41       0.830  13.828  -2.136  1.00  9.58           C  
ATOM    308  CG2 ILE A  41      -0.906  14.374  -0.403  1.00  9.93           C  
ATOM    309  CD1 ILE A  41       2.041  14.307  -1.342  1.00 12.40           C  
ATOM    310  N   VAL A  42      -3.919  14.041  -2.151  1.00  7.97           N  
ATOM    311  CA  VAL A  42      -5.292  14.521  -2.026  1.00  7.63           C  
ATOM    312  C   VAL A  42      -5.698  14.580  -0.556  1.00  7.32           C  
ATOM    313  O   VAL A  42      -5.745  13.558   0.120  1.00  7.39           O  
ATOM    314  CB  VAL A  42      -6.286  13.620  -2.799  1.00  7.71           C  
ATOM    315  CG1 VAL A  42      -7.705  14.154  -2.672  1.00  8.27           C  
ATOM    316  CG2 VAL A  42      -5.878  13.509  -4.273  1.00  8.95           C  
ATOM    317  N   ASP A  43      -5.973  15.791  -0.078  1.00  6.95           N  
ATOM    318  CA  ASP A  43      -6.434  16.033   1.284  1.00  7.07           C  
ATOM    319  C   ASP A  43      -7.952  15.944   1.302  1.00  6.90           C  
ATOM    320  O   ASP A  43      -8.619  16.751   0.672  1.00  6.73           O  
ATOM    321  CB  ASP A  43      -5.993  17.445   1.676  1.00  7.27           C  
ATOM    322  CG  ASP A  43      -6.201  17.773   3.148  1.00  7.64           C  
ATOM    323  OD1 ASP A  43      -7.014  17.132   3.840  1.00  7.68           O  
ATOM    324  OD2 ASP A  43      -5.528  18.730   3.598  1.00  8.74           O  
ATOM    325  N   ILE A  44      -8.490  14.970   2.026  1.00  6.72           N  
ATOM    326  CA  ILE A  44      -9.935  14.751   2.030  1.00  6.87           C  
ATOM    327  C   ILE A  44     -10.635  15.296   3.278  1.00  6.55           C  
ATOM    328  O   ILE A  44     -11.834  15.062   3.473  1.00  7.14           O  
ATOM    329  CB  ILE A  44     -10.287  13.270   1.810  1.00  7.02           C  
ATOM    330  CG1 ILE A  44      -9.884  12.425   3.026  1.00  7.83           C  
ATOM    331  CG2 ILE A  44      -9.670  12.773   0.505  1.00  7.94           C  
ATOM    332  CD1 ILE A  44     -10.277  10.973   2.935  1.00  9.00           C  
ATOM    333  N   ARG A  45      -9.899  16.043   4.100  1.00  6.81           N  
ATOM    334  CA  ARG A  45     -10.442  16.592   5.343  1.00  7.10           C  
ATOM    335  C   ARG A  45     -11.462  17.702   5.127  1.00  7.42           C  
ATOM    336  O   ARG A  45     -11.502  18.349   4.084  1.00  7.32           O  
ATOM    337  CB  ARG A  45      -9.313  17.115   6.229  1.00  7.52           C  
ATOM    338  CG  ARG A  45      -8.408  16.011   6.764  1.00  7.93           C  
ATOM    339  CD  ARG A  45      -7.252  16.578   7.546  1.00  9.07           C  
ATOM    340  NE  ARG A  45      -6.412  17.396   6.683  1.00  8.63           N  
ATOM    341  CZ  ARG A  45      -5.552  18.312   7.109  1.00  8.85           C  
ATOM    342  NH1 ARG A  45      -5.386  18.529   8.407  1.00 10.25           N  
ATOM    343  NH2 ARG A  45      -4.846  18.999   6.226  1.00  8.96           N  
ATOM    344  N   ASP A  46     -12.289  17.909   6.144  1.00  7.88           N  
ATOM    345  CA  ASP A  46     -13.166  19.060   6.199  1.00  8.32           C  
ATOM    346  C   ASP A  46     -12.284  20.323   6.247  1.00  8.17           C  
ATOM    347  O   ASP A  46     -11.220  20.316   6.882  1.00  8.23           O  
ATOM    348  CB  ASP A  46     -14.048  18.936   7.445  1.00  9.24           C  
ATOM    349  CG  ASP A  46     -15.042  20.068   7.587  1.00 10.82           C  
ATOM    350  OD1 ASP A  46     -14.644  21.182   7.977  1.00  9.20           O  
ATOM    351  OD2 ASP A  46     -16.244  19.842   7.330  1.00 12.80           O  
ATOM    352  N   PRO A  47     -12.703  21.410   5.572  1.00  8.48           N  
ATOM    353  CA  PRO A  47     -11.888  22.631   5.551  1.00  9.06           C  
ATOM    354  C   PRO A  47     -11.583  23.201   6.941  1.00  8.95           C  
ATOM    355  O   PRO A  47     -10.573  23.889   7.118  1.00  9.76           O  
ATOM    356  CB  PRO A  47     -12.753  23.614   4.745  1.00  9.25           C  
ATOM    357  CG  PRO A  47     -14.141  23.068   4.841  1.00  9.51           C  
ATOM    358  CD  PRO A  47     -13.950  21.591   4.806  1.00  9.05           C  
ATOM    359  N   ARG A  48     -12.432  22.914   7.922  1.00  8.71           N  
ATOM    360  CA  ARG A  48     -12.217  23.408   9.279  1.00  9.26           C  
ATOM    361  C   ARG A  48     -11.076  22.663   9.982  1.00  9.71           C  
ATOM    362  O   ARG A  48     -10.358  23.237  10.804  1.00 10.19           O  
ATOM    363  CB  ARG A  48     -13.517  23.337  10.076  1.00  9.14           C  
ATOM    364  CG  ARG A  48     -14.603  24.255   9.535  1.00  9.68           C  
ATOM    365  CD  ARG A  48     -15.976  23.938  10.104  1.00 10.14           C  
ATOM    366  NE  ARG A  48     -16.487  22.671   9.589  1.00  8.75           N  
ATOM    367  CZ  ARG A  48     -17.711  22.203   9.810  1.00  9.50           C  
ATOM    368  NH1 ARG A  48     -18.579  22.901  10.537  1.00  9.08           N  
ATOM    369  NH2 ARG A  48     -18.072  21.042   9.285  1.00  9.95           N  
ATOM    370  N   GLU A  49     -10.890  21.396   9.638  1.00  9.30           N  
ATOM    371  CA  GLU A  49      -9.715  20.642  10.075  1.00  9.51           C  
ATOM    372  C   GLU A  49      -8.444  21.234   9.463  1.00 10.07           C  
ATOM    373  O   GLU A  49      -7.416  21.389  10.139  1.00 10.29           O  
ATOM    374  CB  GLU A  49      -9.826  19.179   9.652  1.00  9.04           C  
ATOM    375  CG  GLU A  49     -10.947  18.393  10.276  1.00  9.68           C  
ATOM    376  CD  GLU A  49     -11.006  16.990   9.725  1.00 10.06           C  
ATOM    377  OE1 GLU A  49     -11.644  16.775   8.677  1.00  9.16           O  
ATOM    378  OE2 GLU A  49     -10.406  16.094  10.337  1.00 11.42           O  
ATOM    379  N   ILE A  50      -8.508  21.536   8.170  1.00 10.50           N  
ATOM    380  CA  ILE A  50      -7.365  22.084   7.438  1.00 11.75           C  
ATOM    381  C   ILE A  50      -6.973  23.452   8.003  1.00 12.75           C  
ATOM    382  O   ILE A  50      -5.786  23.727   8.231  1.00 13.31           O  
ATOM    383  CB  ILE A  50      -7.663  22.180   5.920  1.00 11.34           C  
ATOM    384  CG1 ILE A  50      -8.040  20.804   5.350  1.00 11.89           C  
ATOM    385  CG2 ILE A  50      -6.468  22.780   5.167  1.00 12.19           C  
ATOM    386  CD1 ILE A  50      -8.503  20.822   3.902  1.00 12.79           C  
ATOM    387  N   GLU A  51      -7.969  24.295   8.260  1.00 13.54           N  
ATOM    388  CA  GLU A  51      -7.703  25.611   8.840  1.00 15.10           C  
ATOM    389  C   GLU A  51      -7.000  25.503  10.194  1.00 15.39           C  
ATOM    390  O   GLU A  51      -6.043  26.240  10.457  1.00 15.86           O  
ATOM    391  CB  GLU A  51      -8.985  26.441   8.952  1.00 15.54           C  
ATOM    392  CG  GLU A  51      -8.746  27.840   9.537  1.00 18.32           C  
ATOM    393  CD  GLU A  51      -9.967  28.736   9.483  1.00 21.65           C  
ATOM    394  OE1 GLU A  51     -11.055  28.264   9.091  1.00 23.54           O  
ATOM    395  OE2 GLU A  51      -9.828  29.927   9.833  1.00 23.99           O  
ATOM    396  N   ARG A  52      -7.452  24.572  11.029  1.00 15.76           N  
ATOM    397  CA  ARG A  52      -6.905  24.402  12.373  1.00 16.10           C  
ATOM    398  C   ARG A  52      -5.475  23.859  12.371  1.00 15.66           C  
ATOM    399  O   ARG A  52      -4.603  24.381  13.076  1.00 16.13           O  
ATOM    400  CB  ARG A  52      -7.821  23.488  13.196  1.00 16.56           C  
ATOM    401  CG  ARG A  52      -7.381  23.273  14.642  1.00 18.24           C  
ATOM    402  CD  ARG A  52      -8.180  22.171  15.330  1.00 21.72           C  
ATOM    403  NE  ARG A  52      -8.081  20.894  14.625  1.00 24.34           N  
ATOM    404  CZ  ARG A  52      -9.084  20.301  13.980  1.00 25.11           C  
ATOM    405  NH1 ARG A  52     -10.294  20.850  13.945  1.00 26.38           N  
ATOM    406  NH2 ARG A  52      -8.873  19.146  13.368  1.00 23.89           N  
ATOM    407  N   ASP A  53      -5.236  22.832  11.561  1.00 15.01           N  
ATOM    408  CA  ASP A  53      -4.019  22.032  11.673  1.00 14.93           C  
ATOM    409  C   ASP A  53      -2.981  22.261  10.576  1.00 14.31           C  
ATOM    410  O   ASP A  53      -1.834  21.824  10.708  1.00 14.74           O  
ATOM    411  CB  ASP A  53      -4.385  20.544  11.736  1.00 15.06           C  
ATOM    412  CG  ASP A  53      -5.147  20.180  12.999  1.00 16.42           C  
ATOM    413  OD1 ASP A  53      -4.834  20.738  14.074  1.00 18.27           O  
ATOM    414  OD2 ASP A  53      -6.053  19.325  12.918  1.00 16.85           O  
ATOM    415  N   GLY A  54      -3.372  22.942   9.506  1.00 13.12           N  
ATOM    416  CA  GLY A  54      -2.520  23.070   8.328  1.00 12.39           C  
ATOM    417  C   GLY A  54      -2.668  21.870   7.408  1.00 11.05           C  
ATOM    418  O   GLY A  54      -3.543  21.019   7.618  1.00 10.99           O  
ATOM    419  N   LYS A  55      -1.803  21.796   6.398  1.00 10.66           N  
ATOM    420  CA  LYS A  55      -1.911  20.787   5.349  1.00 10.54           C  
ATOM    421  C   LYS A  55      -0.548  20.409   4.772  1.00 10.17           C  
ATOM    422  O   LYS A  55       0.473  21.072   5.023  1.00 10.22           O  
ATOM    423  CB  LYS A  55      -2.819  21.302   4.227  1.00 10.86           C  
ATOM    424  CG  LYS A  55      -2.275  22.517   3.485  1.00 12.50           C  
ATOM    425  CD  LYS A  55      -3.266  22.988   2.446  1.00 15.24           C  
ATOM    426  CE  LYS A  55      -2.861  24.334   1.885  1.00 17.94           C  
ATOM    427  NZ  LYS A  55      -3.813  24.803   0.846  1.00 20.05           N  
ATOM    428  N   ILE A  56      -0.533  19.341   3.986  1.00  9.47           N  
ATOM    429  CA  ILE A  56       0.657  18.949   3.255  1.00  9.25           C  
ATOM    430  C   ILE A  56       0.828  19.920   2.081  1.00  9.23           C  
ATOM    431  O   ILE A  56      -0.102  20.116   1.303  1.00  9.08           O  
ATOM    432  CB  ILE A  56       0.539  17.488   2.783  1.00  8.91           C  
ATOM    433  CG1 ILE A  56       0.508  16.559   4.003  1.00  9.49           C  
ATOM    434  CG2 ILE A  56       1.686  17.132   1.854  1.00  9.87           C  
ATOM    435  CD1 ILE A  56       0.298  15.084   3.682  1.00  9.88           C  
ATOM    436  N   PRO A  57       2.003  20.569   1.972  1.00  9.71           N  
ATOM    437  CA  PRO A  57       2.198  21.538   0.897  1.00  9.82           C  
ATOM    438  C   PRO A  57       1.946  20.948  -0.481  1.00 10.00           C  
ATOM    439  O   PRO A  57       2.380  19.836  -0.784  1.00 10.02           O  
ATOM    440  CB  PRO A  57       3.667  21.952   1.061  1.00  9.95           C  
ATOM    441  CG  PRO A  57       3.960  21.721   2.502  1.00 10.55           C  
ATOM    442  CD  PRO A  57       3.189  20.481   2.844  1.00  9.94           C  
ATOM    443  N   GLY A  58       1.212  21.690  -1.297  1.00 10.59           N  
ATOM    444  CA  GLY A  58       0.957  21.275  -2.662  1.00 11.02           C  
ATOM    445  C   GLY A  58      -0.158  20.250  -2.800  1.00 10.60           C  
ATOM    446  O   GLY A  58      -0.445  19.806  -3.909  1.00 12.28           O  
ATOM    447  N   SER A  59      -0.789  19.869  -1.689  1.00 10.36           N  
ATOM    448  CA  SER A  59      -1.895  18.912  -1.750  1.00  9.94           C  
ATOM    449  C   SER A  59      -3.131  19.526  -2.401  1.00  9.57           C  
ATOM    450  O   SER A  59      -3.321  20.743  -2.384  1.00 10.01           O  
ATOM    451  CB  SER A  59      -2.230  18.373  -0.360  1.00 10.71           C  
ATOM    452  OG  SER A  59      -2.654  19.410   0.494  1.00 12.76           O  
ATOM    453  N   PHE A  60      -3.958  18.659  -2.976  1.00  9.10           N  
ATOM    454  CA  PHE A  60      -5.202  19.052  -3.608  1.00  8.85           C  
ATOM    455  C   PHE A  60      -6.358  18.716  -2.668  1.00  8.63           C  
ATOM    456  O   PHE A  60      -6.486  17.576  -2.215  1.00  8.48           O  
ATOM    457  CB  PHE A  60      -5.351  18.318  -4.945  1.00  9.64           C  
ATOM    458  CG  PHE A  60      -6.614  18.659  -5.686  1.00 10.53           C  
ATOM    459  CD1 PHE A  60      -6.727  19.865  -6.368  1.00 11.57           C  
ATOM    460  CD2 PHE A  60      -7.694  17.777  -5.699  1.00 11.64           C  
ATOM    461  CE1 PHE A  60      -7.901  20.191  -7.046  1.00 13.28           C  
ATOM    462  CE2 PHE A  60      -8.874  18.100  -6.384  1.00 12.11           C  
ATOM    463  CZ  PHE A  60      -8.973  19.308  -7.052  1.00 13.38           C  
ATOM    464  N   SER A  61      -7.194  19.706  -2.365  1.00  8.18           N  
ATOM    465  CA  SER A  61      -8.311  19.503  -1.444  1.00  8.38           C  
ATOM    466  C   SER A  61      -9.550  19.015  -2.168  1.00  8.07           C  
ATOM    467  O   SER A  61     -10.082  19.698  -3.039  1.00  8.85           O  
ATOM    468  CB  SER A  61      -8.638  20.794  -0.680  1.00  8.58           C  
ATOM    469  OG  SER A  61      -9.880  20.700   0.012  1.00 10.03           O  
ATOM    470  N   CYS A  62     -10.006  17.831  -1.785  1.00  7.49           N  
ATOM    471  CA  CYS A  62     -11.300  17.329  -2.217  1.00  7.97           C  
ATOM    472  C   CYS A  62     -11.892  16.602  -1.033  1.00  7.44           C  
ATOM    473  O   CYS A  62     -11.394  15.552  -0.631  1.00  7.48           O  
ATOM    474  CB  CYS A  62     -11.192  16.372  -3.410  1.00  8.56           C  
ATOM    475  SG  CYS A  62     -12.806  15.711  -3.923  1.00 10.83           S  
ATOM    476  N   THR A  63     -12.937  17.171  -0.445  1.00  7.44           N  
ATOM    477  CA  THR A  63     -13.532  16.534   0.729  1.00  7.84           C  
ATOM    478  C   THR A  63     -14.032  15.134   0.369  1.00  7.16           C  
ATOM    479  O   THR A  63     -14.448  14.873  -0.766  1.00  7.36           O  
ATOM    480  CB  THR A  63     -14.659  17.368   1.362  1.00  8.32           C  
ATOM    481  OG1 THR A  63     -15.748  17.490   0.439  1.00  9.97           O  
ATOM    482  CG2 THR A  63     -14.164  18.755   1.770  1.00  9.17           C  
ATOM    483  N   ARG A  64     -13.966  14.222   1.330  1.00  7.17           N  
ATOM    484  CA  ARG A  64     -14.300  12.839   1.047  1.00  7.66           C  
ATOM    485  C   ARG A  64     -15.703  12.711   0.456  1.00  7.41           C  
ATOM    486  O   ARG A  64     -15.923  11.924  -0.466  1.00  7.69           O  
ATOM    487  CB  ARG A  64     -14.144  11.962   2.288  1.00  7.60           C  
ATOM    488  CG  ARG A  64     -14.583  10.530   2.045  1.00  7.73           C  
ATOM    489  CD  ARG A  64     -14.226   9.554   3.173  1.00  7.51           C  
ATOM    490  NE  ARG A  64     -14.897   8.287   2.873  1.00  7.22           N  
ATOM    491  CZ  ARG A  64     -15.954   7.797   3.516  1.00  6.88           C  
ATOM    492  NH1 ARG A  64     -16.424   8.377   4.612  1.00  8.04           N  
ATOM    493  NH2 ARG A  64     -16.521   6.681   3.082  1.00  7.96           N  
ATOM    494  N   GLY A  65     -16.637  13.513   0.960  1.00  7.19           N  
ATOM    495  CA  GLY A  65     -18.023  13.430   0.529  1.00  7.82           C  
ATOM    496  C   GLY A  65     -18.285  13.869  -0.898  1.00  7.73           C  
ATOM    497  O   GLY A  65     -19.362  13.596  -1.432  1.00  8.08           O  
HETATM  498  N   MSE A  66     -17.307  14.534  -1.515  1.00  7.87           N  
HETATM  499  CA  MSE A  66     -17.401  14.980  -2.910  1.00  8.49           C  
HETATM  500  C   MSE A  66     -16.606  14.117  -3.879  1.00  7.83           C  
HETATM  501  O   MSE A  66     -16.674  14.327  -5.098  1.00  7.95           O  
HETATM  502  CB  MSE A  66     -16.879  16.407  -3.024  1.00  9.76           C  
HETATM  503  CG  MSE A  66     -17.790  17.403  -2.382  1.00 12.97           C  
HETATM  504 SE   MSE A  66     -17.238  19.196  -2.711  1.00 21.80          SE  
HETATM  505  CE  MSE A  66     -18.458  20.053  -1.459  1.00 19.16           C  
ATOM    506  N   LEU A  67     -15.855  13.157  -3.351  1.00  7.97           N  
ATOM    507  CA  LEU A  67     -14.831  12.460  -4.127  1.00  8.45           C  
ATOM    508  C   LEU A  67     -15.340  11.871  -5.438  1.00  8.04           C  
ATOM    509  O   LEU A  67     -14.764  12.116  -6.503  1.00  8.37           O  
ATOM    510  CB  LEU A  67     -14.194  11.366  -3.274  1.00  9.17           C  
ATOM    511  CG  LEU A  67     -12.934  10.697  -3.812  1.00 12.75           C  
ATOM    512  CD1 LEU A  67     -11.794  11.712  -3.927  1.00 15.90           C  
ATOM    513  CD2 LEU A  67     -12.543   9.526  -2.922  1.00 15.48           C  
ATOM    514  N   GLU A  68     -16.423  11.105  -5.364  1.00  7.81           N  
ATOM    515  CA  GLU A  68     -16.931  10.414  -6.550  1.00  7.81           C  
ATOM    516  C   GLU A  68     -17.336  11.399  -7.635  1.00  7.59           C  
ATOM    517  O   GLU A  68     -17.139  11.143  -8.826  1.00  7.80           O  
ATOM    518  CB  GLU A  68     -18.116   9.512  -6.193  1.00  8.36           C  
ATOM    519  CG  GLU A  68     -17.802   8.444  -5.140  1.00  8.92           C  
ATOM    520  CD  GLU A  68     -18.059   8.880  -3.698  1.00  8.45           C  
ATOM    521  OE1 GLU A  68     -17.999  10.086  -3.396  1.00  8.91           O  
ATOM    522  OE2 GLU A  68     -18.313   7.997  -2.859  1.00  9.26           O  
ATOM    523  N   PHE A  69     -17.894  12.527  -7.202  1.00  7.63           N  
ATOM    524  CA  PHE A  69     -18.392  13.569  -8.090  1.00  8.16           C  
ATOM    525  C   PHE A  69     -17.288  14.353  -8.773  1.00  8.08           C  
ATOM    526  O   PHE A  69     -17.505  14.911  -9.850  1.00  8.98           O  
ATOM    527  CB  PHE A  69     -19.327  14.489  -7.310  1.00  8.45           C  
ATOM    528  CG  PHE A  69     -20.522  13.767  -6.800  1.00  8.81           C  
ATOM    529  CD1 PHE A  69     -21.641  13.616  -7.604  1.00  9.76           C  
ATOM    530  CD2 PHE A  69     -20.497  13.152  -5.559  1.00  9.09           C  
ATOM    531  CE1 PHE A  69     -22.733  12.887  -7.163  1.00  9.93           C  
ATOM    532  CE2 PHE A  69     -21.582  12.422  -5.114  1.00  9.94           C  
ATOM    533  CZ  PHE A  69     -22.704  12.297  -5.909  1.00  9.90           C  
ATOM    534  N   TRP A  70     -16.113  14.401  -8.152  1.00  7.84           N  
ATOM    535  CA  TRP A  70     -14.964  15.068  -8.757  1.00  8.17           C  
ATOM    536  C   TRP A  70     -14.103  14.095  -9.563  1.00  7.99           C  
ATOM    537  O   TRP A  70     -13.475  14.498 -10.537  1.00  8.41           O  
ATOM    538  CB  TRP A  70     -14.142  15.785  -7.683  1.00  8.42           C  
ATOM    539  CG  TRP A  70     -14.796  17.029  -7.133  1.00  8.74           C  
ATOM    540  CD1 TRP A  70     -16.119  17.388  -7.216  1.00  9.09           C  
ATOM    541  CD2 TRP A  70     -14.149  18.068  -6.398  1.00  9.57           C  
ATOM    542  NE1 TRP A  70     -16.326  18.596  -6.591  1.00 10.47           N  
ATOM    543  CE2 TRP A  70     -15.132  19.029  -6.077  1.00  9.16           C  
ATOM    544  CE3 TRP A  70     -12.827  18.291  -5.994  1.00  9.61           C  
ATOM    545  CZ2 TRP A  70     -14.832  20.187  -5.364  1.00 10.26           C  
ATOM    546  CZ3 TRP A  70     -12.537  19.439  -5.277  1.00 10.37           C  
ATOM    547  CH2 TRP A  70     -13.535  20.374  -4.975  1.00 10.33           C  
ATOM    548  N   ILE A  71     -14.072  12.823  -9.169  1.00  7.77           N  
ATOM    549  CA  ILE A  71     -13.288  11.831  -9.907  1.00  8.13           C  
ATOM    550  C   ILE A  71     -13.903  11.481 -11.266  1.00  8.10           C  
ATOM    551  O   ILE A  71     -13.204  11.434 -12.283  1.00  8.25           O  
ATOM    552  CB  ILE A  71     -13.110  10.541  -9.094  1.00  7.76           C  
ATOM    553  CG1 ILE A  71     -12.138  10.776  -7.934  1.00  8.52           C  
ATOM    554  CG2 ILE A  71     -12.609   9.398  -9.982  1.00  8.46           C  
ATOM    555  CD1 ILE A  71     -11.984   9.591  -7.005  1.00  9.63           C  
ATOM    556  N   ASP A  72     -15.203  11.204 -11.275  1.00  8.30           N  
ATOM    557  CA  ASP A  72     -15.869  10.658 -12.450  1.00  8.95           C  
ATOM    558  C   ASP A  72     -15.915  11.684 -13.576  1.00  9.28           C  
ATOM    559  O   ASP A  72     -16.545  12.721 -13.422  1.00  8.95           O  
ATOM    560  CB  ASP A  72     -17.281  10.229 -12.061  1.00  9.16           C  
ATOM    561  CG  ASP A  72     -18.055   9.614 -13.203  1.00  9.49           C  
ATOM    562  OD1 ASP A  72     -17.528   9.479 -14.331  1.00  9.86           O  
ATOM    563  OD2 ASP A  72     -19.227   9.270 -12.963  1.00 11.14           O  
ATOM    564  N   PRO A  73     -15.256  11.396 -14.721  1.00 10.35           N  
ATOM    565  CA  PRO A  73     -15.263  12.387 -15.799  1.00 11.50           C  
ATOM    566  C   PRO A  73     -16.656  12.624 -16.397  1.00 12.44           C  
ATOM    567  O   PRO A  73     -16.871  13.636 -17.070  1.00 13.51           O  
ATOM    568  CB  PRO A  73     -14.310  11.786 -16.839  1.00 11.50           C  
ATOM    569  CG  PRO A  73     -14.328  10.330 -16.581  1.00 11.40           C  
ATOM    570  CD  PRO A  73     -14.489  10.191 -15.089  1.00 10.14           C  
ATOM    571  N   GLN A  74     -17.585  11.703 -16.145  1.00 13.13           N  
ATOM    572  CA  GLN A  74     -18.970  11.838 -16.598  1.00 14.26           C  
ATOM    573  C   GLN A  74     -19.861  12.569 -15.595  1.00 14.35           C  
ATOM    574  O   GLN A  74     -21.072  12.700 -15.810  1.00 15.21           O  
ATOM    575  CB  GLN A  74     -19.571  10.465 -16.911  1.00 14.67           C  
ATOM    576  CG  GLN A  74     -18.816   9.652 -17.964  1.00 17.68           C  
ATOM    577  CD  GLN A  74     -18.579  10.420 -19.249  1.00 21.18           C  
ATOM    578  OE1 GLN A  74     -19.462  11.128 -19.736  1.00 22.18           O  
ATOM    579  NE2 GLN A  74     -17.377  10.287 -19.804  1.00 22.83           N  
ATOM    580  N   SER A  75     -19.272  13.014 -14.488  1.00 13.94           N  
ATOM    581  CA  SER A  75     -19.979  13.843 -13.526  1.00 13.85           C  
ATOM    582  C   SER A  75     -19.962  15.294 -13.990  1.00 14.40           C  
ATOM    583  O   SER A  75     -18.952  15.763 -14.509  1.00 14.12           O  
ATOM    584  CB  SER A  75     -19.331  13.742 -12.145  1.00 13.40           C  
ATOM    585  OG  SER A  75     -19.792  14.779 -11.288  1.00 12.85           O  
ATOM    586  N   PRO A  76     -21.081  16.015 -13.790  1.00 15.16           N  
ATOM    587  CA  PRO A  76     -21.103  17.448 -14.072  1.00 15.80           C  
ATOM    588  C   PRO A  76     -20.037  18.227 -13.290  1.00 15.63           C  
ATOM    589  O   PRO A  76     -19.665  19.333 -13.681  1.00 16.74           O  
ATOM    590  CB  PRO A  76     -22.509  17.869 -13.624  1.00 16.06           C  
ATOM    591  CG  PRO A  76     -23.317  16.629 -13.706  1.00 15.99           C  
ATOM    592  CD  PRO A  76     -22.386  15.531 -13.306  1.00 15.52           C  
ATOM    593  N   TYR A  77     -19.528  17.628 -12.215  1.00 14.84           N  
ATOM    594  CA  TYR A  77     -18.613  18.296 -11.288  1.00 14.21           C  
ATOM    595  C   TYR A  77     -17.180  17.751 -11.377  1.00 13.09           C  
ATOM    596  O   TYR A  77     -16.342  18.022 -10.509  1.00 12.81           O  
ATOM    597  CB  TYR A  77     -19.186  18.201  -9.863  1.00 14.79           C  
ATOM    598  CG  TYR A  77     -20.699  18.351  -9.851  1.00 15.74           C  
ATOM    599  CD1 TYR A  77     -21.295  19.611  -9.909  1.00 17.27           C  
ATOM    600  CD2 TYR A  77     -21.533  17.233  -9.827  1.00 16.53           C  
ATOM    601  CE1 TYR A  77     -22.687  19.752  -9.924  1.00 17.63           C  
ATOM    602  CE2 TYR A  77     -22.925  17.363  -9.842  1.00 18.02           C  
ATOM    603  CZ  TYR A  77     -23.490  18.625  -9.890  1.00 18.52           C  
ATOM    604  OH  TYR A  77     -24.862  18.755  -9.901  1.00 19.44           O  
ATOM    605  N   ALA A  78     -16.910  17.006 -12.452  1.00 12.35           N  
ATOM    606  CA  ALA A  78     -15.608  16.388 -12.698  1.00 12.14           C  
ATOM    607  C   ALA A  78     -14.453  17.374 -12.612  1.00 12.00           C  
ATOM    608  O   ALA A  78     -14.547  18.507 -13.105  1.00 12.26           O  
ATOM    609  CB  ALA A  78     -15.599  15.713 -14.052  1.00 12.65           C  
ATOM    610  N   LYS A  79     -13.357  16.938 -12.001  1.00 11.41           N  
ATOM    611  CA  LYS A  79     -12.146  17.742 -11.937  1.00 11.09           C  
ATOM    612  C   LYS A  79     -11.072  17.020 -12.733  1.00 11.25           C  
ATOM    613  O   LYS A  79     -10.798  15.842 -12.477  1.00 11.12           O  
ATOM    614  CB  LYS A  79     -11.703  17.947 -10.492  1.00 11.49           C  
ATOM    615  CG  LYS A  79     -12.743  18.620  -9.621  1.00 12.06           C  
ATOM    616  CD  LYS A  79     -13.003  20.058 -10.036  1.00 14.31           C  
ATOM    617  CE  LYS A  79     -14.014  20.700  -9.093  1.00 14.93           C  
ATOM    618  NZ  LYS A  79     -15.418  20.383  -9.438  1.00 17.98           N  
ATOM    619  N   PRO A  80     -10.467  17.711 -13.719  1.00 11.44           N  
ATOM    620  CA  PRO A  80      -9.503  17.071 -14.612  1.00 11.53           C  
ATOM    621  C   PRO A  80      -8.268  16.498 -13.938  1.00 10.58           C  
ATOM    622  O   PRO A  80      -7.636  15.609 -14.510  1.00 10.37           O  
ATOM    623  CB  PRO A  80      -9.101  18.192 -15.574  1.00 12.36           C  
ATOM    624  CG  PRO A  80     -10.153  19.202 -15.468  1.00 13.67           C  
ATOM    625  CD  PRO A  80     -10.710  19.115 -14.093  1.00 11.72           C  
ATOM    626  N   ILE A  81      -7.918  16.994 -12.752  1.00 10.48           N  
ATOM    627  CA  ILE A  81      -6.773  16.453 -12.015  1.00 10.24           C  
ATOM    628  C   ILE A  81      -6.908  14.940 -11.780  1.00  9.69           C  
ATOM    629  O   ILE A  81      -5.913  14.220 -11.796  1.00  9.39           O  
ATOM    630  CB  ILE A  81      -6.514  17.222 -10.685  1.00 10.68           C  
ATOM    631  CG1 ILE A  81      -5.139  16.864 -10.105  1.00 11.68           C  
ATOM    632  CG2 ILE A  81      -7.634  16.989  -9.659  1.00 10.90           C  
ATOM    633  CD1 ILE A  81      -4.687  17.801  -8.997  1.00 14.23           C  
ATOM    634  N   PHE A  82      -8.139  14.462 -11.603  1.00  8.75           N  
ATOM    635  CA  PHE A  82      -8.376  13.042 -11.355  1.00  8.76           C  
ATOM    636  C   PHE A  82      -8.286  12.175 -12.608  1.00  8.95           C  
ATOM    637  O   PHE A  82      -8.417  10.959 -12.525  1.00  9.23           O  
ATOM    638  CB  PHE A  82      -9.717  12.831 -10.650  1.00  8.57           C  
ATOM    639  CG  PHE A  82      -9.693  13.207  -9.202  1.00  8.40           C  
ATOM    640  CD1 PHE A  82      -8.848  12.541  -8.311  1.00  8.98           C  
ATOM    641  CD2 PHE A  82     -10.511  14.226  -8.720  1.00  8.68           C  
ATOM    642  CE1 PHE A  82      -8.823  12.885  -6.965  1.00 10.22           C  
ATOM    643  CE2 PHE A  82     -10.492  14.570  -7.371  1.00 10.48           C  
ATOM    644  CZ  PHE A  82      -9.643  13.904  -6.499  1.00 11.91           C  
ATOM    645  N   GLN A  83      -8.077  12.800 -13.761  1.00  9.26           N  
ATOM    646  CA  GLN A  83      -7.883  12.057 -15.003  1.00 10.19           C  
ATOM    647  C   GLN A  83      -6.403  11.859 -15.325  1.00 10.58           C  
ATOM    648  O   GLN A  83      -6.057  11.145 -16.269  1.00 10.89           O  
ATOM    649  CB  GLN A  83      -8.609  12.755 -16.154  1.00 10.66           C  
ATOM    650  CG  GLN A  83     -10.095  12.417 -16.208  1.00 11.66           C  
ATOM    651  CD  GLN A  83     -10.350  11.048 -16.797  1.00 12.34           C  
ATOM    652  OE1 GLN A  83     -10.682  10.097 -16.085  1.00 13.62           O  
ATOM    653  NE2 GLN A  83     -10.189  10.934 -18.108  1.00 11.69           N  
ATOM    654  N   GLU A  84      -5.530  12.472 -14.530  1.00 10.84           N  
ATOM    655  CA  GLU A  84      -4.091  12.431 -14.783  1.00 11.89           C  
ATOM    656  C   GLU A  84      -3.492  11.056 -14.537  1.00 11.82           C  
ATOM    657  O   GLU A  84      -3.943  10.309 -13.667  1.00 10.89           O  
ATOM    658  CB  GLU A  84      -3.367  13.492 -13.956  1.00 12.21           C  
ATOM    659  CG  GLU A  84      -3.725  14.904 -14.396  1.00 14.75           C  
ATOM    660  CD  GLU A  84      -3.006  15.988 -13.627  1.00 18.28           C  
ATOM    661  OE1 GLU A  84      -2.117  15.676 -12.808  1.00 19.81           O  
ATOM    662  OE2 GLU A  84      -3.347  17.168 -13.843  1.00 18.97           O  
ATOM    663  N   ASP A  85      -2.463  10.746 -15.320  1.00 12.89           N  
ATOM    664  CA  ASP A  85      -1.761   9.475 -15.274  1.00 14.03           C  
ATOM    665  C   ASP A  85      -0.736   9.495 -14.134  1.00 13.84           C  
ATOM    666  O   ASP A  85       0.477   9.529 -14.366  1.00 14.77           O  
ATOM    667  CB  ASP A  85      -1.092   9.244 -16.638  1.00 15.00           C  
ATOM    668  CG  ASP A  85      -0.320   7.939 -16.714  1.00 17.15           C  
ATOM    669  OD1 ASP A  85      -0.779   6.931 -16.137  1.00 19.97           O  
ATOM    670  OD2 ASP A  85       0.746   7.926 -17.369  1.00 20.47           O  
ATOM    671  N   LYS A  86      -1.242   9.477 -12.901  1.00 13.23           N  
ATOM    672  CA  LYS A  86      -0.427   9.638 -11.697  1.00 12.87           C  
ATOM    673  C   LYS A  86      -0.921   8.717 -10.595  1.00 12.24           C  
ATOM    674  O   LYS A  86      -2.017   8.166 -10.690  1.00 12.29           O  
ATOM    675  CB  LYS A  86      -0.478  11.097 -11.227  1.00 12.97           C  
ATOM    676  CG  LYS A  86       0.239  12.061 -12.173  1.00 14.11           C  
ATOM    677  CD  LYS A  86       0.171  13.491 -11.700  1.00 16.26           C  
ATOM    678  CE  LYS A  86       1.021  14.395 -12.579  1.00 18.37           C  
ATOM    679  NZ  LYS A  86       0.878  15.817 -12.172  1.00 20.61           N  
ATOM    680  N   LYS A  87      -0.105   8.550  -9.557  1.00 11.62           N  
ATOM    681  CA  LYS A  87      -0.532   7.877  -8.338  1.00 11.25           C  
ATOM    682  C   LYS A  87      -1.233   8.882  -7.418  1.00 10.32           C  
ATOM    683  O   LYS A  87      -0.721   9.974  -7.175  1.00 11.08           O  
ATOM    684  CB  LYS A  87       0.656   7.220  -7.619  1.00 11.56           C  
ATOM    685  CG  LYS A  87       0.262   6.533  -6.305  1.00 12.04           C  
ATOM    686  CD  LYS A  87       1.385   5.711  -5.673  1.00 12.88           C  
ATOM    687  CE  LYS A  87       1.468   4.319  -6.285  1.00 13.52           C  
ATOM    688  NZ  LYS A  87       2.349   3.399  -5.510  1.00 12.31           N  
ATOM    689  N   PHE A  88      -2.403   8.496  -6.913  1.00  9.68           N  
ATOM    690  CA  PHE A  88      -3.196   9.344  -6.026  1.00  8.50           C  
ATOM    691  C   PHE A  88      -3.063   8.863  -4.600  1.00  8.36           C  
ATOM    692  O   PHE A  88      -3.430   7.731  -4.281  1.00  9.01           O  
ATOM    693  CB  PHE A  88      -4.657   9.382  -6.479  1.00  8.28           C  
ATOM    694  CG  PHE A  88      -4.838  10.093  -7.776  1.00  8.97           C  
ATOM    695  CD1 PHE A  88      -5.168  11.439  -7.806  1.00  9.38           C  
ATOM    696  CD2 PHE A  88      -4.617   9.434  -8.982  1.00  9.60           C  
ATOM    697  CE1 PHE A  88      -5.298  12.111  -9.013  1.00 10.06           C  
ATOM    698  CE2 PHE A  88      -4.749  10.095 -10.196  1.00 10.26           C  
ATOM    699  CZ  PHE A  88      -5.088  11.442 -10.206  1.00 10.27           C  
ATOM    700  N   VAL A  89      -2.499   9.723  -3.760  1.00  7.83           N  
ATOM    701  CA  VAL A  89      -2.249   9.423  -2.364  1.00  7.72           C  
ATOM    702  C   VAL A  89      -3.213  10.252  -1.522  1.00  7.45           C  
ATOM    703  O   VAL A  89      -3.088  11.476  -1.454  1.00  8.01           O  
ATOM    704  CB  VAL A  89      -0.787   9.744  -1.993  1.00  7.91           C  
ATOM    705  CG1 VAL A  89      -0.538   9.505  -0.505  1.00  9.32           C  
ATOM    706  CG2 VAL A  89       0.173   8.941  -2.853  1.00  9.14           C  
ATOM    707  N   PHE A  90      -4.168   9.585  -0.876  1.00  7.38           N  
ATOM    708  CA  PHE A  90      -5.201  10.268  -0.099  1.00  7.11           C  
ATOM    709  C   PHE A  90      -4.781  10.379   1.347  1.00  7.18           C  
ATOM    710  O   PHE A  90      -4.149   9.472   1.879  1.00  7.79           O  
ATOM    711  CB  PHE A  90      -6.525   9.502  -0.198  1.00  7.69           C  
ATOM    712  CG  PHE A  90      -7.075   9.436  -1.593  1.00  7.23           C  
ATOM    713  CD1 PHE A  90      -7.920  10.433  -2.068  1.00  7.80           C  
ATOM    714  CD2 PHE A  90      -6.730   8.387  -2.448  1.00  8.25           C  
ATOM    715  CE1 PHE A  90      -8.414  10.387  -3.366  1.00  8.21           C  
ATOM    716  CE2 PHE A  90      -7.221   8.336  -3.744  1.00  8.06           C  
ATOM    717  CZ  PHE A  90      -8.067   9.337  -4.202  1.00  8.50           C  
ATOM    718  N   TYR A  91      -5.128  11.486   1.991  1.00  7.04           N  
ATOM    719  CA  TYR A  91      -4.893  11.587   3.430  1.00  7.33           C  
ATOM    720  C   TYR A  91      -5.999  12.323   4.159  1.00  7.62           C  
ATOM    721  O   TYR A  91      -6.667  13.190   3.604  1.00  7.74           O  
ATOM    722  CB  TYR A  91      -3.518  12.187   3.758  1.00  7.60           C  
ATOM    723  CG  TYR A  91      -3.407  13.687   3.630  1.00  8.02           C  
ATOM    724  CD1 TYR A  91      -3.513  14.509   4.749  1.00  7.87           C  
ATOM    725  CD2 TYR A  91      -3.150  14.281   2.399  1.00  8.38           C  
ATOM    726  CE1 TYR A  91      -3.395  15.895   4.639  1.00  8.08           C  
ATOM    727  CE2 TYR A  91      -3.022  15.665   2.282  1.00  8.05           C  
ATOM    728  CZ  TYR A  91      -3.134  16.457   3.407  1.00  8.03           C  
ATOM    729  OH  TYR A  91      -2.995  17.825   3.294  1.00  8.61           O  
ATOM    730  N   CYS A  92      -6.178  11.943   5.415  1.00  7.65           N  
ATOM    731  CA  CYS A  92      -7.148  12.577   6.291  1.00  8.53           C  
ATOM    732  C   CYS A  92      -6.431  12.884   7.606  1.00  8.60           C  
ATOM    733  O   CYS A  92      -5.201  12.961   7.626  1.00  9.53           O  
ATOM    734  CB  CYS A  92      -8.372  11.672   6.494  1.00  8.70           C  
ATOM    735  SG  CYS A  92      -8.002  10.033   7.202  1.00  9.76           S  
ATOM    736  N   ALA A  93      -7.168  13.066   8.700  1.00  8.96           N  
ATOM    737  CA  ALA A  93      -6.533  13.391   9.981  1.00  9.93           C  
ATOM    738  C   ALA A  93      -5.815  12.217  10.648  1.00 10.56           C  
ATOM    739  O   ALA A  93      -4.745  12.400  11.240  1.00 10.80           O  
ATOM    740  CB  ALA A  93      -7.545  14.017  10.945  1.00 10.76           C  
ATOM    741  N   GLY A  94      -6.385  11.021  10.556  1.00 10.86           N  
ATOM    742  CA  GLY A  94      -5.861   9.868  11.288  1.00 11.35           C  
ATOM    743  C   GLY A  94      -5.681   8.590  10.494  1.00 11.20           C  
ATOM    744  O   GLY A  94      -5.262   7.572  11.047  1.00 12.01           O  
ATOM    745  N   GLY A  95      -5.988   8.634   9.202  1.00 10.83           N  
ATOM    746  CA  GLY A  95      -5.772   7.488   8.321  1.00 10.95           C  
ATOM    747  C   GLY A  95      -7.000   6.657   7.987  1.00 11.01           C  
ATOM    748  O   GLY A  95      -6.955   5.818   7.086  1.00 12.55           O  
ATOM    749  N   LEU A  96      -8.113   6.890   8.680  1.00 10.07           N  
ATOM    750  CA  LEU A  96      -9.285   6.024   8.522  1.00  9.81           C  
ATOM    751  C   LEU A  96     -10.160   6.413   7.334  1.00  9.37           C  
ATOM    752  O   LEU A  96     -10.378   5.592   6.444  1.00  9.09           O  
ATOM    753  CB  LEU A  96     -10.091   5.923   9.823  1.00 10.48           C  
ATOM    754  CG  LEU A  96      -9.304   5.489  11.069  1.00 11.85           C  
ATOM    755  CD1 LEU A  96     -10.235   5.272  12.250  1.00 12.76           C  
ATOM    756  CD2 LEU A  96      -8.454   4.240  10.829  1.00 13.43           C  
ATOM    757  N   ARG A  97     -10.646   7.655   7.303  1.00  8.59           N  
ATOM    758  CA  ARG A  97     -11.422   8.145   6.160  1.00  8.51           C  
ATOM    759  C   ARG A  97     -10.656   7.938   4.865  1.00  7.84           C  
ATOM    760  O   ARG A  97     -11.236   7.605   3.834  1.00  7.40           O  
ATOM    761  CB  ARG A  97     -11.761   9.632   6.303  1.00  8.72           C  
ATOM    762  CG  ARG A  97     -12.957   9.945   7.177  1.00  9.39           C  
ATOM    763  CD  ARG A  97     -13.057  11.443   7.432  1.00  9.14           C  
ATOM    764  NE  ARG A  97     -11.975  11.896   8.303  1.00  9.51           N  
ATOM    765  CZ  ARG A  97     -11.614  13.159   8.504  1.00  9.06           C  
ATOM    766  NH1 ARG A  97     -12.208  14.155   7.859  1.00  9.46           N  
ATOM    767  NH2 ARG A  97     -10.620  13.423   9.345  1.00  9.71           N  
ATOM    768  N   SER A  98      -9.345   8.161   4.914  1.00  8.04           N  
ATOM    769  CA  SER A  98      -8.543   8.058   3.697  1.00  8.26           C  
ATOM    770  C   SER A  98      -8.401   6.631   3.187  1.00  7.66           C  
ATOM    771  O   SER A  98      -8.248   6.424   1.984  1.00  7.26           O  
ATOM    772  CB  SER A  98      -7.181   8.727   3.861  1.00  9.16           C  
ATOM    773  OG  SER A  98      -6.480   8.195   4.960  1.00 10.97           O  
ATOM    774  N   ALA A  99      -8.453   5.645   4.083  1.00  7.52           N  
ATOM    775  CA  ALA A  99      -8.495   4.249   3.641  1.00  7.74           C  
ATOM    776  C   ALA A  99      -9.790   4.002   2.870  1.00  7.26           C  
ATOM    777  O   ALA A  99      -9.784   3.397   1.794  1.00  7.56           O  
ATOM    778  CB  ALA A  99      -8.377   3.295   4.816  1.00  8.53           C  
ATOM    779  N   LEU A 100     -10.907   4.479   3.415  1.00  7.30           N  
ATOM    780  CA  LEU A 100     -12.189   4.322   2.728  1.00  7.45           C  
ATOM    781  C   LEU A 100     -12.196   5.068   1.402  1.00  7.43           C  
ATOM    782  O   LEU A 100     -12.680   4.551   0.404  1.00  7.16           O  
ATOM    783  CB  LEU A 100     -13.358   4.779   3.603  1.00  7.83           C  
ATOM    784  CG  LEU A 100     -13.529   4.084   4.954  1.00  7.82           C  
ATOM    785  CD1 LEU A 100     -14.843   4.521   5.565  1.00  9.84           C  
ATOM    786  CD2 LEU A 100     -13.464   2.558   4.837  1.00  9.34           C  
ATOM    787  N   ALA A 101     -11.632   6.273   1.386  1.00  7.39           N  
ATOM    788  CA  ALA A 101     -11.594   7.090   0.171  1.00  7.69           C  
ATOM    789  C   ALA A 101     -10.751   6.440  -0.921  1.00  7.73           C  
ATOM    790  O   ALA A 101     -11.155   6.393  -2.079  1.00  7.60           O  
ATOM    791  CB  ALA A 101     -11.073   8.479   0.473  1.00  7.81           C  
ATOM    792  N   ALA A 102      -9.572   5.937  -0.553  1.00  7.62           N  
ATOM    793  CA  ALA A 102      -8.711   5.239  -1.507  1.00  7.87           C  
ATOM    794  C   ALA A 102      -9.412   4.013  -2.081  1.00  7.51           C  
ATOM    795  O   ALA A 102      -9.353   3.767  -3.284  1.00  7.39           O  
ATOM    796  CB  ALA A 102      -7.392   4.852  -0.853  1.00  7.84           C  
ATOM    797  N   LYS A 103     -10.097   3.265  -1.224  1.00  7.55           N  
ATOM    798  CA  LYS A 103     -10.842   2.099  -1.678  1.00  7.75           C  
ATOM    799  C   LYS A 103     -11.976   2.492  -2.636  1.00  7.30           C  
ATOM    800  O   LYS A 103     -12.160   1.852  -3.672  1.00  7.64           O  
ATOM    801  CB  LYS A 103     -11.365   1.315  -0.478  1.00  7.69           C  
ATOM    802  CG  LYS A 103     -12.173   0.061  -0.824  1.00  8.91           C  
ATOM    803  CD  LYS A 103     -11.376  -0.956  -1.635  1.00 10.61           C  
ATOM    804  CE  LYS A 103     -12.041  -2.325  -1.624  1.00 11.91           C  
ATOM    805  NZ  LYS A 103     -13.451  -2.316  -2.087  1.00 12.93           N  
ATOM    806  N   THR A 104     -12.723   3.541  -2.302  1.00  7.35           N  
ATOM    807  CA  THR A 104     -13.762   4.040  -3.202  1.00  7.62           C  
ATOM    808  C   THR A 104     -13.180   4.409  -4.569  1.00  7.56           C  
ATOM    809  O   THR A 104     -13.700   4.006  -5.611  1.00  7.82           O  
ATOM    810  CB  THR A 104     -14.455   5.259  -2.594  1.00  7.92           C  
ATOM    811  OG1 THR A 104     -15.127   4.861  -1.394  1.00  8.18           O  
ATOM    812  CG2 THR A 104     -15.457   5.875  -3.567  1.00  9.40           C  
ATOM    813  N   ALA A 105     -12.093   5.170  -4.557  1.00  7.76           N  
ATOM    814  CA  ALA A 105     -11.466   5.605  -5.799  1.00  7.67           C  
ATOM    815  C   ALA A 105     -11.003   4.397  -6.615  1.00  8.30           C  
ATOM    816  O   ALA A 105     -11.227   4.325  -7.824  1.00  8.18           O  
ATOM    817  CB  ALA A 105     -10.311   6.534  -5.501  1.00  7.80           C  
ATOM    818  N   GLN A 106     -10.396   3.429  -5.943  1.00  8.23           N  
ATOM    819  CA  GLN A 106      -9.933   2.224  -6.617  1.00  8.97           C  
ATOM    820  C   GLN A 106     -11.102   1.426  -7.211  1.00  9.00           C  
ATOM    821  O   GLN A 106     -11.004   0.932  -8.345  1.00  9.38           O  
ATOM    822  CB  GLN A 106      -9.142   1.370  -5.639  1.00  9.18           C  
ATOM    823  CG  GLN A 106      -8.375   0.237  -6.288  1.00  9.88           C  
ATOM    824  CD  GLN A 106      -7.506  -0.472  -5.292  1.00  9.46           C  
ATOM    825  OE1 GLN A 106      -7.963  -1.365  -4.569  1.00 11.96           O  
ATOM    826  NE2 GLN A 106      -6.255  -0.082  -5.232  1.00  8.21           N  
ATOM    827  N   ASP A 107     -12.199   1.313  -6.454  1.00  9.35           N  
ATOM    828  CA  ASP A 107     -13.422   0.660  -6.920  1.00 10.30           C  
ATOM    829  C   ASP A 107     -13.975   1.308  -8.189  1.00  9.63           C  
ATOM    830  O   ASP A 107     -14.591   0.640  -9.013  1.00 10.78           O  
ATOM    831  CB  ASP A 107     -14.514   0.702  -5.844  1.00 10.62           C  
ATOM    832  CG  ASP A 107     -14.255  -0.245  -4.684  1.00 12.24           C  
ATOM    833  OD1 ASP A 107     -13.355  -1.099  -4.768  1.00 12.87           O  
ATOM    834  OD2 ASP A 107     -14.980  -0.121  -3.673  1.00 14.06           O  
HETATM  835  N   MSE A 108     -13.772   2.614  -8.332  1.00  9.25           N  
HETATM  836  CA  MSE A 108     -14.245   3.347  -9.503  1.00  9.14           C  
HETATM  837  C   MSE A 108     -13.371   3.107 -10.719  1.00  8.85           C  
HETATM  838  O   MSE A 108     -13.803   3.334 -11.848  1.00  8.98           O  
HETATM  839  CB  MSE A 108     -14.293   4.847  -9.213  1.00  9.18           C  
HETATM  840  CG  MSE A 108     -15.298   5.212  -8.158  1.00  9.94           C  
HETATM  841 SE   MSE A 108     -15.275   7.101  -7.774  1.00 13.82          SE  
HETATM  842  CE  MSE A 108     -16.046   7.738  -9.442  1.00 11.62           C  
ATOM    843  N   GLY A 109     -12.133   2.680 -10.477  1.00  8.93           N  
ATOM    844  CA  GLY A 109     -11.156   2.493 -11.549  1.00  9.32           C  
ATOM    845  C   GLY A 109      -9.927   3.388 -11.473  1.00  8.92           C  
ATOM    846  O   GLY A 109      -9.008   3.235 -12.279  1.00  9.76           O  
ATOM    847  N   LEU A 110      -9.882   4.320 -10.517  1.00  8.71           N  
ATOM    848  CA  LEU A 110      -8.689   5.156 -10.341  1.00  8.82           C  
ATOM    849  C   LEU A 110      -7.517   4.264  -9.934  1.00  9.11           C  
ATOM    850  O   LEU A 110      -7.667   3.418  -9.057  1.00  9.50           O  
ATOM    851  CB  LEU A 110      -8.920   6.240  -9.286  1.00  8.55           C  
ATOM    852  CG  LEU A 110      -8.016   7.479  -9.370  1.00  8.61           C  
ATOM    853  CD1 LEU A 110      -8.382   8.336 -10.563  1.00  9.31           C  
ATOM    854  CD2 LEU A 110      -8.093   8.319  -8.103  1.00  8.66           C  
ATOM    855  N   LYS A 111      -6.365   4.450 -10.571  1.00 10.27           N  
ATOM    856  CA  LYS A 111      -5.210   3.563 -10.364  1.00 11.31           C  
ATOM    857  C   LYS A 111      -3.928   4.296 -10.718  1.00 10.68           C  
ATOM    858  O   LYS A 111      -3.890   4.993 -11.724  1.00 10.42           O  
ATOM    859  CB  LYS A 111      -5.280   2.347 -11.300  1.00 12.98           C  
ATOM    860  CG  LYS A 111      -6.319   1.297 -11.025  1.00 17.00           C  
ATOM    861  CD  LYS A 111      -6.210   0.197 -12.077  1.00 21.01           C  
ATOM    862  CE  LYS A 111      -7.417  -0.724 -12.085  1.00 22.51           C  
ATOM    863  NZ  LYS A 111      -8.666  -0.007 -12.451  1.00 24.05           N  
ATOM    864  N   PRO A 112      -2.854   4.112  -9.930  1.00 10.28           N  
ATOM    865  CA  PRO A 112      -2.788   3.461  -8.629  1.00 10.02           C  
ATOM    866  C   PRO A 112      -3.153   4.437  -7.512  1.00  9.53           C  
ATOM    867  O   PRO A 112      -2.971   5.647  -7.671  1.00  9.62           O  
ATOM    868  CB  PRO A 112      -1.318   3.051  -8.530  1.00 10.25           C  
ATOM    869  CG  PRO A 112      -0.593   4.085  -9.313  1.00 10.79           C  
ATOM    870  CD  PRO A 112      -1.527   4.573 -10.382  1.00 10.45           C  
ATOM    871  N   VAL A 113      -3.664   3.914  -6.401  1.00  8.88           N  
ATOM    872  CA  VAL A 113      -4.014   4.758  -5.266  1.00  8.99           C  
ATOM    873  C   VAL A 113      -3.341   4.259  -3.999  1.00  8.54           C  
ATOM    874  O   VAL A 113      -2.940   3.087  -3.905  1.00  8.61           O  
ATOM    875  CB  VAL A 113      -5.551   4.862  -5.027  1.00  8.90           C  
ATOM    876  CG1 VAL A 113      -6.284   5.313  -6.283  1.00  9.70           C  
ATOM    877  CG2 VAL A 113      -6.126   3.555  -4.538  1.00  9.09           C  
ATOM    878  N   ALA A 114      -3.240   5.150  -3.020  1.00  8.25           N  
ATOM    879  CA  ALA A 114      -2.703   4.810  -1.720  1.00  8.35           C  
ATOM    880  C   ALA A 114      -3.266   5.771  -0.698  1.00  8.45           C  
ATOM    881  O   ALA A 114      -3.902   6.766  -1.049  1.00  8.61           O  
ATOM    882  CB  ALA A 114      -1.185   4.881  -1.740  1.00  8.58           C  
ATOM    883  N   HIS A 115      -3.036   5.482   0.572  1.00  8.57           N  
ATOM    884  CA  HIS A 115      -3.311   6.460   1.608  1.00  8.85           C  
ATOM    885  C   HIS A 115      -2.151   6.489   2.598  1.00  8.67           C  
ATOM    886  O   HIS A 115      -1.313   5.584   2.604  1.00  9.11           O  
ATOM    887  CB  HIS A 115      -4.679   6.230   2.266  1.00  9.21           C  
ATOM    888  CG  HIS A 115      -4.667   5.260   3.401  1.00  9.69           C  
ATOM    889  ND1 HIS A 115      -4.215   3.962   3.291  1.00 11.28           N  
ATOM    890  CD2 HIS A 115      -5.083   5.408   4.678  1.00  9.25           C  
ATOM    891  CE1 HIS A 115      -4.339   3.359   4.461  1.00 10.87           C  
ATOM    892  NE2 HIS A 115      -4.861   4.216   5.318  1.00 13.25           N  
ATOM    893  N   ILE A 116      -2.086   7.551   3.396  1.00  8.76           N  
ATOM    894  CA  ILE A 116      -0.974   7.751   4.319  1.00  9.53           C  
ATOM    895  C   ILE A 116      -1.305   7.179   5.695  1.00  9.90           C  
ATOM    896  O   ILE A 116      -2.244   7.621   6.359  1.00  9.33           O  
ATOM    897  CB  ILE A 116      -0.597   9.248   4.442  1.00  9.43           C  
ATOM    898  CG1 ILE A 116      -0.267   9.838   3.063  1.00  9.86           C  
ATOM    899  CG2 ILE A 116       0.580   9.432   5.417  1.00 10.24           C  
ATOM    900  CD1 ILE A 116       0.148  11.308   3.067  1.00  9.76           C  
ATOM    901  N   GLU A 117      -0.513   6.201   6.125  1.00 11.03           N  
ATOM    902  CA  GLU A 117      -0.679   5.608   7.445  1.00 12.19           C  
ATOM    903  C   GLU A 117      -0.677   6.678   8.535  1.00 11.83           C  
ATOM    904  O   GLU A 117       0.215   7.523   8.589  1.00 11.79           O  
ATOM    905  CB  GLU A 117       0.422   4.581   7.712  1.00 13.18           C  
ATOM    906  CG  GLU A 117       0.162   3.689   8.928  1.00 16.24           C  
ATOM    907  CD  GLU A 117       1.085   2.479   8.992  1.00 20.00           C  
ATOM    908  OE1 GLU A 117       2.175   2.518   8.380  1.00 22.84           O  
ATOM    909  OE2 GLU A 117       0.721   1.489   9.667  1.00 23.02           O  
ATOM    910  N   GLY A 118      -1.703   6.640   9.379  1.00 11.42           N  
ATOM    911  CA  GLY A 118      -1.825   7.553  10.506  1.00 11.21           C  
ATOM    912  C   GLY A 118      -2.232   8.973  10.158  1.00 10.73           C  
ATOM    913  O   GLY A 118      -2.353   9.813  11.040  1.00 11.00           O  
ATOM    914  N   GLY A 119      -2.431   9.257   8.873  1.00 10.52           N  
ATOM    915  CA  GLY A 119      -2.938  10.556   8.445  1.00  9.92           C  
ATOM    916  C   GLY A 119      -2.030  11.737   8.736  1.00  9.84           C  
ATOM    917  O   GLY A 119      -0.824  11.583   8.984  1.00 10.26           O  
ATOM    918  N   PHE A 120      -2.626  12.921   8.711  1.00  9.66           N  
ATOM    919  CA  PHE A 120      -1.903  14.149   8.960  1.00 10.46           C  
ATOM    920  C   PHE A 120      -1.380  14.220  10.394  1.00 10.43           C  
ATOM    921  O   PHE A 120      -0.348  14.837  10.642  1.00 10.47           O  
ATOM    922  CB  PHE A 120      -2.780  15.361   8.646  1.00 10.66           C  
ATOM    923  CG  PHE A 120      -2.016  16.646   8.574  1.00 11.52           C  
ATOM    924  CD1 PHE A 120      -1.074  16.854   7.570  1.00 13.27           C  
ATOM    925  CD2 PHE A 120      -2.229  17.649   9.508  1.00 13.21           C  
ATOM    926  CE1 PHE A 120      -0.355  18.052   7.501  1.00 13.98           C  
ATOM    927  CE2 PHE A 120      -1.516  18.845   9.443  1.00 14.90           C  
ATOM    928  CZ  PHE A 120      -0.586  19.045   8.436  1.00 14.35           C  
ATOM    929  N   GLY A 121      -2.082  13.585  11.331  1.00 10.38           N  
ATOM    930  CA  GLY A 121      -1.619  13.513  12.720  1.00 11.30           C  
ATOM    931  C   GLY A 121      -0.241  12.875  12.826  1.00 11.33           C  
ATOM    932  O   GLY A 121       0.663  13.423  13.473  1.00 11.61           O  
ATOM    933  N   ALA A 122      -0.067  11.728  12.176  1.00 11.55           N  
ATOM    934  CA  ALA A 122       1.229  11.045  12.147  1.00 11.88           C  
ATOM    935  C   ALA A 122       2.286  11.829  11.364  1.00 11.69           C  
ATOM    936  O   ALA A 122       3.461  11.859  11.745  1.00 12.69           O  
ATOM    937  CB  ALA A 122       1.076   9.652  11.575  1.00 11.73           C  
ATOM    938  N   TRP A 123       1.858  12.452  10.266  1.00 11.26           N  
ATOM    939  CA  TRP A 123       2.714  13.323   9.456  1.00 11.05           C  
ATOM    940  C   TRP A 123       3.290  14.453  10.310  1.00 11.62           C  
ATOM    941  O   TRP A 123       4.502  14.688  10.312  1.00 11.93           O  
ATOM    942  CB  TRP A 123       1.893  13.888   8.299  1.00  9.91           C  
ATOM    943  CG  TRP A 123       2.627  14.762   7.325  1.00  9.08           C  
ATOM    944  CD1 TRP A 123       2.927  16.082   7.475  1.00  9.41           C  
ATOM    945  CD2 TRP A 123       3.069  14.392   6.017  1.00  7.92           C  
ATOM    946  NE1 TRP A 123       3.567  16.552   6.355  1.00  9.16           N  
ATOM    947  CE2 TRP A 123       3.667  15.534   5.445  1.00  8.28           C  
ATOM    948  CE3 TRP A 123       3.035  13.202   5.278  1.00  8.76           C  
ATOM    949  CZ2 TRP A 123       4.211  15.525   4.164  1.00  8.71           C  
ATOM    950  CZ3 TRP A 123       3.572  13.195   4.007  1.00  8.85           C  
ATOM    951  CH2 TRP A 123       4.157  14.348   3.463  1.00  8.61           C  
ATOM    952  N   ARG A 124       2.414  15.152  11.025  1.00 12.80           N  
ATOM    953  CA  ARG A 124       2.816  16.216  11.945  1.00 14.57           C  
ATOM    954  C   ARG A 124       3.742  15.721  13.059  1.00 14.87           C  
ATOM    955  O   ARG A 124       4.751  16.371  13.370  1.00 15.29           O  
ATOM    956  CB  ARG A 124       1.574  16.875  12.540  1.00 15.00           C  
ATOM    957  CG  ARG A 124       1.861  18.024  13.493  1.00 17.66           C  
ATOM    958  CD  ARG A 124       0.579  18.721  13.907  1.00 21.46           C  
ATOM    959  NE  ARG A 124      -0.352  17.807  14.566  1.00 24.03           N  
ATOM    960  CZ  ARG A 124      -1.630  18.082  14.815  1.00 25.27           C  
ATOM    961  NH1 ARG A 124      -2.149  19.254  14.465  1.00 25.46           N  
ATOM    962  NH2 ARG A 124      -2.393  17.182  15.420  1.00 26.23           N  
ATOM    963  N   ASP A 125       3.404  14.578  13.651  1.00 15.49           N  
ATOM    964  CA  ASP A 125       4.213  14.003  14.729  1.00 16.30           C  
ATOM    965  C   ASP A 125       5.639  13.692  14.271  1.00 16.18           C  
ATOM    966  O   ASP A 125       6.584  13.814  15.050  1.00 16.37           O  
ATOM    967  CB  ASP A 125       3.556  12.743  15.294  1.00 17.05           C  
ATOM    968  CG  ASP A 125       2.309  13.040  16.116  1.00 19.20           C  
ATOM    969  OD1 ASP A 125       2.103  14.206  16.523  1.00 22.10           O  
ATOM    970  OD2 ASP A 125       1.528  12.095  16.348  1.00 22.96           O  
ATOM    971  N   ALA A 126       5.782  13.303  13.006  1.00 15.78           N  
ATOM    972  CA  ALA A 126       7.081  12.973  12.422  1.00 15.68           C  
ATOM    973  C   ALA A 126       7.852  14.210  11.949  1.00 15.40           C  
ATOM    974  O   ALA A 126       8.993  14.097  11.491  1.00 15.94           O  
ATOM    975  CB  ALA A 126       6.899  11.989  11.276  1.00 15.89           C  
ATOM    976  N   GLY A 127       7.229  15.378  12.067  1.00 14.68           N  
ATOM    977  CA  GLY A 127       7.834  16.637  11.644  1.00 14.20           C  
ATOM    978  C   GLY A 127       7.826  16.838  10.140  1.00 13.53           C  
ATOM    979  O   GLY A 127       8.684  17.535   9.600  1.00 13.75           O  
ATOM    980  N   GLY A 128       6.842  16.249   9.457  1.00 12.66           N  
ATOM    981  CA  GLY A 128       6.710  16.405   8.007  1.00 12.09           C  
ATOM    982  C   GLY A 128       6.435  17.834   7.571  1.00 11.67           C  
ATOM    983  O   GLY A 128       5.996  18.654   8.378  1.00 12.38           O  
ATOM    984  N   PRO A 129       6.711  18.150   6.292  1.00 11.18           N  
ATOM    985  CA  PRO A 129       6.427  19.481   5.746  1.00 11.42           C  
ATOM    986  C   PRO A 129       4.973  19.902   5.971  1.00 11.53           C  
ATOM    987  O   PRO A 129       4.050  19.131   5.685  1.00 11.08           O  
ATOM    988  CB  PRO A 129       6.712  19.310   4.249  1.00 11.43           C  
ATOM    989  CG  PRO A 129       7.725  18.215   4.192  1.00 11.52           C  
ATOM    990  CD  PRO A 129       7.336  17.267   5.291  1.00 11.01           C  
ATOM    991  N   ILE A 130       4.772  21.107   6.496  1.00 12.12           N  
ATOM    992  CA  ILE A 130       3.428  21.619   6.761  1.00 13.49           C  
ATOM    993  C   ILE A 130       3.283  23.042   6.245  1.00 13.78           C  
ATOM    994  O   ILE A 130       4.174  23.884   6.431  1.00 13.93           O  
ATOM    995  CB  ILE A 130       3.061  21.566   8.269  1.00 13.93           C  
ATOM    996  CG1 ILE A 130       2.947  20.117   8.753  1.00 15.61           C  
ATOM    997  CG2 ILE A 130       1.740  22.301   8.541  1.00 14.44           C  
ATOM    998  CD1 ILE A 130       2.781  19.981  10.258  1.00 18.60           C  
ATOM    999  N   GLU A 131       2.157  23.294   5.587  1.00 14.11           N  
ATOM   1000  CA  GLU A 131       1.743  24.639   5.217  1.00 15.01           C  
ATOM   1001  C   GLU A 131       0.565  25.049   6.094  1.00 15.17           C  
ATOM   1002  O   GLU A 131      -0.418  24.311   6.219  1.00 15.24           O  
ATOM   1003  CB  GLU A 131       1.347  24.690   3.743  1.00 15.49           C  
ATOM   1004  CG  GLU A 131       0.744  26.022   3.312  1.00 17.36           C  
ATOM   1005  CD  GLU A 131       0.260  26.012   1.880  1.00 20.83           C  
ATOM   1006  OE1 GLU A 131       0.648  25.099   1.124  1.00 21.03           O  
ATOM   1007  OE2 GLU A 131      -0.511  26.922   1.510  1.00 22.89           O  
TER    1008      GLU A 131                                                      
END
MOLECULE T0389.pdb
ATOM      1  N   MET     1     -12.667  -2.302  -4.836  1.00 55.55           N
ATOM      2  CA  MET     1     -11.589  -1.542  -4.213  1.00 48.91           C
ATOM      3  C   MET     1     -10.667  -2.462  -3.418  1.00 39.03           C
ATOM      4  CB  MET     1     -12.164  -0.437  -3.316  1.00 53.74           C
ATOM      5  CG  MET     1     -11.124   0.477  -2.677  1.00 52.32           C
ATOM      6  SD  MET     1     -10.775   0.077  -0.956  1.00 54.50           S
ATOM      7  CE  MET     1     -12.164   0.851  -0.138  1.00 28.92           C
ATOM      8  O   MET     1     -11.122  -3.259  -2.597  1.00 39.35           O
ATOM      9  N   ILE     2      -9.368  -2.352  -3.675  1.00 32.95           N
ATOM     10  CA  ILE     2      -8.372  -3.158  -2.974  1.00 30.36           C
ATOM     11  C   ILE     2      -8.041  -2.529  -1.625  1.00 33.96           C
ATOM     12  CB  ILE     2      -7.083  -3.290  -3.800  1.00 28.62           C
ATOM     13  CG1 ILE     2      -7.403  -3.853  -5.190  1.00 40.56           C
ATOM     14  CG2 ILE     2      -6.082  -4.163  -3.075  1.00 22.68           C
ATOM     15  CD1 ILE     2      -6.203  -4.036  -6.084  1.00 40.80           C
ATOM     16  O   ILE     2      -8.323  -3.100  -0.574  1.00 30.04           O
ATOM     17  N   GLY     3      -7.450  -1.339  -1.667  1.00 32.32           N
ATOM     18  CA  GLY     3      -7.142  -0.596  -0.462  1.00 22.40           C
ATOM     19  C   GLY     3      -5.764  -0.925   0.066  1.00 28.54           C
ATOM     20  O   GLY     3      -5.538  -1.999   0.621  1.00 31.36           O
ATOM     21  N   THR     4      -4.831  -0.001  -0.113  1.00 29.91           N
ATOM     22  CA  THR     4      -3.493  -0.186   0.417  1.00 28.43           C
ATOM     23  C   THR     4      -3.037   1.082   1.112  1.00 25.62           C
ATOM     24  CB  THR     4      -2.492  -0.584  -0.678  1.00 33.32           C
ATOM     25  OG1 THR     4      -2.581   0.340  -1.765  1.00 41.72           O
ATOM     26  CG2 THR     4      -2.814  -1.976  -1.192  1.00 25.85           C
ATOM     27  O   THR     4      -3.677   2.128   0.997  1.00 20.81           O
ATOM     28  N   GLN     5      -1.937   0.984   1.848  1.00 25.25           N
ATOM     29  CA  GLN     5      -1.455   2.118   2.622  1.00 27.71           C
ATOM     30  C   GLN     5      -0.006   2.443   2.303  1.00 24.41           C
ATOM     31  CB  GLN     5      -1.603   1.867   4.131  1.00 30.89           C
ATOM     32  CG  GLN     5      -3.040   1.710   4.619  1.00 40.66           C
ATOM     33  CD  GLN     5      -3.456   0.258   4.771  1.00 44.87           C
ATOM     34  OE1 GLN     5      -2.697  -0.562   5.287  1.00 59.13           O
ATOM     35  NE2 GLN     5      -4.668  -0.063   4.335  1.00 32.63           N
ATOM     36  O   GLN     5       0.718   1.629   1.722  1.00 26.24           O
ATOM     37  N   ILE     6       0.391   3.651   2.686  1.00 21.74           N
ATOM     38  CA  ILE     6       1.781   4.080   2.665  1.00 26.93           C
ATOM     39  C   ILE     6       2.039   4.804   3.988  1.00 27.71           C
ATOM     40  CB  ILE     6       2.045   5.007   1.464  1.00 23.63           C
ATOM     41  CG1 ILE     6       3.531   5.361   1.368  1.00 23.13           C
ATOM     42  CG2 ILE     6       1.150   6.249   1.533  1.00 14.06           C
ATOM     43  CD1 ILE     6       3.920   6.017   0.047  1.00 15.88           C
ATOM     44  O   ILE     6       1.178   5.546   4.462  1.00 26.43           O
ATOM     45  N   VAL     7       3.190   4.569   4.615  1.00 28.81           N
ATOM     46  CA  VAL     7       3.473   5.258   5.874  1.00 27.28           C
ATOM     47  C   VAL     7       4.177   6.586   5.632  1.00 27.58           C
ATOM     48  CB  VAL     7       4.276   4.396   6.883  1.00 24.61           C
ATOM     49  CG1 VAL     7       3.589   3.057   7.105  1.00 23.84           C
ATOM     50  CG2 VAL     7       5.722   4.211   6.424  1.00 17.37           C
ATOM     51  O   VAL     7       4.771   6.805   4.574  1.00 31.93           O
ATOM     52  N   THR     8       4.095   7.468   6.622  1.00 25.79           N
ATOM     53  CA  THR     8       4.656   8.812   6.540  1.00 18.76           C
ATOM     54  C   THR     8       6.079   8.829   5.980  1.00 24.70           C
ATOM     55  CB  THR     8       4.626   9.492   7.924  1.00 32.05           C
ATOM     56  OG1 THR     8       3.268   9.629   8.357  1.00 35.84           O
ATOM     57  CG2 THR     8       5.259  10.861   7.865  1.00 41.25           C
ATOM     58  O   THR     8       6.363   9.530   5.010  1.00 27.45           O
ATOM     59  N   GLU     9       6.971   8.058   6.593  1.00 26.50           N
ATOM     60  CA  GLU     9       8.360   7.994   6.152  1.00 28.73           C
ATOM     61  C   GLU     9       8.492   7.664   4.671  1.00 31.92           C
ATOM     62  CB  GLU     9       9.141   6.960   6.967  1.00 36.59           C
ATOM     63  CG  GLU     9       9.497   7.401   8.372  1.00 49.60           C
ATOM     64  CD  GLU     9      10.430   6.420   9.050  1.00 64.99           C
ATOM     65  OE1 GLU     9      10.333   6.254  10.285  1.00 70.43           O
ATOM     66  OE2 GLU     9      11.257   5.807   8.340  1.00 71.66           O
ATOM     67  O   GLU     9       9.344   8.222   3.975  1.00 37.29           O
ATOM     68  N   ARG    10       7.666   6.740   4.194  1.00 27.84           N
ATOM     69  CA  ARG    10       7.731   6.326   2.796  1.00 30.93           C
ATOM     70  C   ARG    10       7.116   7.362   1.843  1.00 36.13           C
ATOM     71  CB  ARG    10       7.096   4.948   2.608  1.00 31.11           C
ATOM     72  CG  ARG    10       7.797   3.848   3.390  1.00 32.70           C
ATOM     73  CD  ARG    10       9.312   3.937   3.233  1.00 28.58           C
ATOM     74  NE  ARG    10       9.748   3.693   1.861  1.00 28.21           N
ATOM     75  CZ  ARG    10      10.905   4.115   1.357  1.00 34.98           C
ATOM     76  NH1 ARG    10      11.219   3.853   0.095  1.00 39.15           N
ATOM     77  NH2 ARG    10      11.749   4.810   2.110  1.00 32.83           N
ATOM     78  O   ARG    10       7.559   7.499   0.700  1.00 30.64           O
ATOM     79  N   LEU    11       6.104   8.093   2.310  1.00 29.78           N
ATOM     80  CA  LEU    11       5.545   9.187   1.518  1.00 23.47           C
ATOM     81  C   LEU    11       6.600  10.268   1.311  1.00 31.97           C
ATOM     82  CB  LEU    11       4.315   9.789   2.202  1.00 20.62           C
ATOM     83  CG  LEU    11       3.738  11.063   1.572  1.00 19.29           C
ATOM     84  CD1 LEU    11       3.365  10.846   0.103  1.00 20.17           C
ATOM     85  CD2 LEU    11       2.535  11.556   2.363  1.00 20.79           C
ATOM     86  O   LEU    11       6.774  10.788   0.209  1.00 33.78           O
ATOM     87  N   VAL    12       7.304  10.605   2.384  1.00 36.47           N
ATOM     88  CA  VAL    12       8.350  11.617   2.319  1.00 35.64           C
ATOM     89  C   VAL    12       9.499  11.145   1.431  1.00 31.72           C
ATOM     90  CB  VAL    12       8.861  11.981   3.725  1.00 34.77           C
ATOM     91  CG1 VAL    12      10.043  12.914   3.631  1.00 27.99           C
ATOM     92  CG2 VAL    12       7.740  12.616   4.539  1.00 33.81           C
ATOM     93  O   VAL    12      10.086  11.932   0.685  1.00 34.55           O
ATOM     94  N   ALA    13       9.812   9.855   1.507  1.00 32.57           N
ATOM     95  CA  ALA    13      10.798   9.258   0.611  1.00 33.94           C
ATOM     96  CB  ALA    13      10.978   7.789   0.927  1.00 28.20           C
ATOM     97  C   ALA    13      10.341   9.432  -0.829  1.00 35.69           C
ATOM     98  O   ALA    13      11.142   9.699  -1.722  1.00 39.08           O
ATOM     99  N   LEU    14       9.038   9.281  -1.035  1.00 38.07           N
ATOM    100  CA  LEU    14       8.427   9.402  -2.353  1.00 41.39           C
ATOM    101  C   LEU    14       8.460  10.838  -2.853  1.00 46.48           C
ATOM    102  CB  LEU    14       6.978   8.914  -2.305  1.00 34.61           C
ATOM    103  CG  LEU    14       6.193   8.940  -3.612  1.00 29.09           C
ATOM    104  CD1 LEU    14       6.848   8.053  -4.660  1.00 30.96           C
ATOM    105  CD2 LEU    14       4.778   8.493  -3.351  1.00 29.73           C
ATOM    106  O   LEU    14       8.775  11.095  -4.015  1.00 52.43           O
ATOM    107  N   LEU    15       8.119  11.771  -1.972  1.00 41.37           N
ATOM    108  CA  LEU    15       8.124  13.181  -2.326  1.00 36.74           C
ATOM    109  C   LEU    15       9.536  13.666  -2.628  1.00 36.74           C
ATOM    110  CB  LEU    15       7.486  14.022  -1.217  1.00 31.50           C
ATOM    111  CG  LEU    15       5.963  13.936  -1.119  1.00 32.92           C
ATOM    112  CD1 LEU    15       5.468  14.531   0.188  1.00 34.02           C
ATOM    113  CD2 LEU    15       5.310  14.624  -2.312  1.00 35.86           C
ATOM    114  O   LEU    15       9.742  14.407  -3.583  1.00 44.67           O
ATOM    115  N   GLU    16      10.506  13.235  -1.824  1.00 43.81           N
ATOM    116  CA  GLU    16      11.891  13.695  -1.968  1.00 47.85           C
ATOM    117  C   GLU    16      12.610  13.199  -3.221  1.00 58.37           C
ATOM    118  CB  GLU    16      12.712  13.346  -0.728  1.00 41.05           C
ATOM    119  CG  GLU    16      12.933  14.525   0.190  1.00 50.25           C
ATOM    120  CD  GLU    16      13.825  14.185   1.356  1.00 65.46           C
ATOM    121  OE1 GLU    16      13.853  12.997   1.744  1.00 69.66           O
ATOM    122  OE2 GLU    16      14.492  15.101   1.886  1.00 71.48           O
ATOM    123  O   GLU    16      13.700  13.671  -3.545  1.00 66.22           O
ATOM    124  N   SER    17      12.005  12.249  -3.922  1.00 63.43           N
ATOM    125  CA  SER    17      12.617  11.687  -5.118  1.00 63.80           C
ATOM    126  C   SER    17      11.997  12.278  -6.373  1.00 72.15           C
ATOM    127  CB  SER    17      12.462  10.164  -5.144  1.00 58.09           C
ATOM    128  OG  SER    17      11.170   9.787  -5.598  1.00 50.16           O
ATOM    129  O   SER    17      10.788  12.521  -6.434  1.00 66.74           O
ATOM    130  N   GLY    18      12.835  12.512  -7.374  1.00 83.22           N
ATOM    131  CA  GLY    18      12.354  12.915  -8.678  1.00 89.19           C
ATOM    132  C   GLY    18      11.966  11.670  -9.443  1.00 93.43           C
ATOM    133  O   GLY    18      11.991  11.647 -10.671  1.00100.51           O
ATOM    134  N   THR    19      11.610  10.627  -8.699  1.00 90.42           N
ATOM    135  CA  THR    19      11.266   9.331  -9.272  1.00 86.37           C
ATOM    136  C   THR    19       9.834   9.297  -9.796  1.00 83.10           C
ATOM    137  CB  THR    19      11.425   8.214  -8.229  1.00 84.81           C
ATOM    138  OG1 THR    19      12.783   8.176  -7.773  1.00 87.60           O
ATOM    139  CG2 THR    19      11.048   6.864  -8.823  1.00 83.70           C
ATOM    140  O   THR    19       9.580   8.869 -10.926  1.00 75.59           O
ATOM    141  N   GLU    20       8.901   9.749  -8.964  1.00 81.85           N
ATOM    142  CA  GLU    20       7.489   9.698  -9.307  1.00 75.24           C
ATOM    143  C   GLU    20       6.802  11.037  -9.056  1.00 68.06           C
ATOM    144  CB  GLU    20       6.794   8.590  -8.506  1.00 77.31           C
ATOM    145  CG  GLU    20       7.364   7.191  -8.732  1.00 78.54           C
ATOM    146  CD  GLU    20       6.812   6.520  -9.979  1.00 82.72           C
ATOM    147  OE1 GLU    20       5.853   7.055 -10.579  1.00 84.74           O
ATOM    148  OE2 GLU    20       7.331   5.448 -10.353  1.00 84.11           O
ATOM    149  O   GLU    20       7.222  11.808  -8.189  1.00 73.59           O
ATOM    150  N   LYS    21       5.753  11.306  -9.830  1.00 58.21           N
ATOM    151  CA  LYS    21       4.899  12.470  -9.614  1.00 51.59           C
ATOM    152  C   LYS    21       3.724  12.082  -8.718  1.00 41.64           C
ATOM    153  CB  LYS    21       4.406  13.042 -10.949  1.00 59.84           C
ATOM    154  CG  LYS    21       3.188  13.961 -10.842  1.00 73.25           C
ATOM    155  CD  LYS    21       3.407  15.113  -9.862  1.00 80.49           C
ATOM    156  CE  LYS    21       2.083  15.785  -9.492  1.00 77.21           C
ATOM    157  NZ  LYS    21       2.217  16.767  -8.373  1.00 73.38           N
ATOM    158  O   LYS    21       3.002  11.126  -8.995  1.00 40.62           O
ATOM    159  N   VAL    22       3.547  12.827  -7.634  1.00 34.84           N
ATOM    160  CA  VAL    22       2.559  12.483  -6.630  1.00 32.92           C
ATOM    161  CB  VAL    22       3.178  12.499  -5.223  1.00 33.83           C
ATOM    162  CG1 VAL    22       2.158  12.050  -4.189  1.00 32.39           C
ATOM    163  CG2 VAL    22       4.408  11.616  -5.181  1.00 29.83           C
ATOM    164  C   VAL    22       1.376  13.436  -6.637  1.00 35.42           C
ATOM    165  O   VAL    22       1.540  14.654  -6.733  1.00 32.38           O
ATOM    166  N   LEU    23       0.180  12.868  -6.539  1.00 29.16           N
ATOM    167  CA  LEU    23      -1.019  13.649  -6.315  1.00 22.29           C
ATOM    168  CB  LEU    23      -2.137  13.202  -7.248  1.00 24.35           C
ATOM    169  CG  LEU    23      -3.434  13.983  -7.039  1.00 28.17           C
ATOM    170  CD1 LEU    23      -3.195  15.456  -7.311  1.00 33.44           C
ATOM    171  CD2 LEU    23      -4.536  13.448  -7.925  1.00 26.20           C
ATOM    172  C   LEU    23      -1.438  13.457  -4.861  1.00 34.22           C
ATOM    173  O   LEU    23      -1.862  12.369  -4.474  1.00 38.14           O
ATOM    174  N   LEU    24      -1.299  14.514  -4.062  1.00 32.70           N
ATOM    175  CA  LEU    24      -1.611  14.484  -2.634  1.00 26.80           C
ATOM    176  CB  LEU    24      -0.582  15.331  -1.886  1.00 35.00           C
ATOM    177  CG  LEU    24      -0.148  15.018  -0.457  1.00 32.33           C
ATOM    178  CD1 LEU    24       0.273  13.578  -0.346  1.00 30.91           C
ATOM    179  CD2 LEU    24       1.003  15.943  -0.066  1.00 27.96           C
ATOM    180  C   LEU    24      -3.016  15.044  -2.403  1.00 31.48           C
ATOM    181  O   LEU    24      -3.297  16.178  -2.790  1.00 34.33           O
ATOM    182  N   ILE    25      -3.891  14.253  -1.777  1.00 32.49           N
ATOM    183  CA  ILE    25      -5.294  14.631  -1.567  1.00 26.03           C
ATOM    184  CB  ILE    25      -6.252  13.685  -2.331  1.00 24.67           C
ATOM    185  CG1 ILE    25      -6.097  13.880  -3.839  1.00 24.12           C
ATOM    186  CD1 ILE    25      -6.742  12.797  -4.655  1.00 30.90           C
ATOM    187  CG2 ILE    25      -7.705  13.907  -1.899  1.00 24.27           C
ATOM    188  C   ILE    25      -5.692  14.630  -0.094  1.00 29.64           C
ATOM    189  O   ILE    25      -5.531  13.627   0.597  1.00 37.44           O
ATOM    190  N   ASP    26      -6.215  15.760   0.371  1.00 29.68           N
ATOM    191  CA  ASP    26      -6.656  15.925   1.753  1.00 24.45           C
ATOM    192  CB  ASP    26      -6.211  17.295   2.279  1.00 30.07           C
ATOM    193  CG  ASP    26      -6.509  17.493   3.762  1.00 35.56           C
ATOM    194  OD1 ASP    26      -7.443  16.853   4.288  1.00 36.46           O
ATOM    195  OD2 ASP    26      -5.804  18.303   4.404  1.00 36.73           O
ATOM    196  C   ASP    26      -8.172  15.818   1.770  1.00 28.11           C
ATOM    197  O   ASP    26      -8.863  16.668   1.213  1.00 39.19           O
ATOM    198  N   SER    27      -8.691  14.773   2.404  1.00 26.21           N
ATOM    199  CA  SER    27     -10.122  14.491   2.344  1.00 30.84           C
ATOM    200  CB  SER    27     -10.362  12.995   2.144  1.00 29.15           C
ATOM    201  OG  SER    27      -9.935  12.266   3.282  1.00 32.12           O
ATOM    202  C   SER    27     -10.868  14.958   3.584  1.00 38.49           C
ATOM    203  O   SER    27     -11.964  14.477   3.869  1.00 51.88           O
ATOM    204  N   ARG    28     -10.277  15.888   4.323  1.00 33.93           N
ATOM    205  CA  ARG    28     -10.906  16.408   5.529  1.00 28.78           C
ATOM    206  CB  ARG    28      -9.846  16.751   6.568  1.00 24.59           C
ATOM    207  CG  ARG    28      -8.951  15.601   6.952  1.00 22.07           C
ATOM    208  CD  ARG    28      -7.786  16.128   7.764  1.00 31.07           C
ATOM    209  NE  ARG    28      -7.133  17.248   7.092  1.00 34.53           N
ATOM    210  CZ  ARG    28      -6.299  18.092   7.689  1.00 30.99           C
ATOM    211  NH1 ARG    28      -5.748  19.083   7.000  1.00 26.34           N
ATOM    212  NH2 ARG    28      -6.024  17.949   8.978  1.00 26.99           N
ATOM    213  C   ARG    28     -11.716  17.653   5.208  1.00 37.19           C
ATOM    214  O   ARG    28     -11.609  18.197   4.110  1.00 39.32           O
ATOM    215  N   PRO    29     -12.541  18.105   6.168  1.00 42.94           N
ATOM    216  CA  PRO    29     -13.241  19.391   6.066  1.00 45.51           C
ATOM    217  CB  PRO    29     -13.932  19.512   7.424  1.00 43.05           C
ATOM    218  CG  PRO    29     -14.140  18.106   7.856  1.00 37.04           C
ATOM    219  CD  PRO    29     -12.935  17.360   7.377  1.00 37.00           C
ATOM    220  C   PRO    29     -12.264  20.554   5.862  1.00 52.51           C
ATOM    221  O   PRO    29     -11.130  20.520   6.368  1.00 40.37           O
ATOM    222  N   PHE    30     -12.716  21.574   5.134  1.00 59.85           N
ATOM    223  CA  PHE    30     -11.850  22.671   4.693  1.00 63.12           C
ATOM    224  CB  PHE    30     -12.592  23.583   3.710  1.00 70.28           C
ATOM    225  CG  PHE    30     -13.681  24.401   4.344  1.00 83.28           C
ATOM    226  CD1 PHE    30     -13.490  25.750   4.603  1.00 87.85           C
ATOM    227  CE1 PHE    30     -14.490  26.509   5.189  1.00 90.43           C
ATOM    228  CZ  PHE    30     -15.696  25.921   5.524  1.00 93.98           C
ATOM    229  CE2 PHE    30     -15.899  24.576   5.272  1.00 94.92           C
ATOM    230  CD2 PHE    30     -14.895  23.823   4.686  1.00 89.84           C
ATOM    231  C   PHE    30     -11.235  23.499   5.826  1.00 54.89           C
ATOM    232  O   PHE    30     -10.140  24.036   5.678  1.00 53.57           O
ATOM    233  N   VAL    31     -11.935  23.614   6.949  1.00 49.26           N
ATOM    234  CA  VAL    31     -11.399  24.359   8.080  1.00 45.90           C
ATOM    235  CB  VAL    31     -12.383  24.412   9.250  1.00 44.22           C
ATOM    236  CG1 VAL    31     -11.872  25.376  10.309  1.00 49.72           C
ATOM    237  CG2 VAL    31     -13.758  24.824   8.767  1.00 46.00           C
ATOM    238  C   VAL    31     -10.111  23.706   8.553  1.00 47.30           C
ATOM    239  O   VAL    31      -9.142  24.387   8.882  1.00 49.53           O
ATOM    240  N   GLU    32     -10.113  22.377   8.585  1.00 48.26           N
ATOM    241  CA  GLU    32      -8.927  21.615   8.941  1.00 46.25           C
ATOM    242  CB  GLU    32      -9.251  20.127   9.001  1.00 45.40           C
ATOM    243  CG  GLU    32     -10.257  19.756  10.068  1.00 53.40           C
ATOM    244  CD  GLU    32     -10.411  18.258  10.211  1.00 67.62           C
ATOM    245  OE1 GLU    32      -9.380  17.564  10.336  1.00 74.98           O
ATOM    246  OE2 GLU    32     -11.561  17.773  10.199  1.00 72.48           O
ATOM    247  C   GLU    32      -7.837  21.856   7.913  1.00 45.03           C
ATOM    248  O   GLU    32      -6.712  22.221   8.257  1.00 43.27           O
ATOM    249  N   TYR    33      -8.181  21.644   6.647  1.00 41.98           N
ATOM    250  CA  TYR    33      -7.246  21.862   5.551  1.00 42.07           C
ATOM    251  CB  TYR    33      -7.939  21.628   4.206  1.00 41.75           C
ATOM    252  CG  TYR    33      -7.124  22.051   3.001  1.00 46.31           C
ATOM    253  CD1 TYR    33      -6.028  21.311   2.587  1.00 46.83           C
ATOM    254  CE1 TYR    33      -5.284  21.692   1.487  1.00 47.88           C
ATOM    255  CZ  TYR    33      -5.634  22.821   0.780  1.00 45.75           C
ATOM    256  OH  TYR    33      -4.886  23.194  -0.314  1.00 49.06           O
ATOM    257  CE2 TYR    33      -6.722  23.571   1.165  1.00 43.19           C
ATOM    258  CD2 TYR    33      -7.461  23.185   2.269  1.00 45.94           C
ATOM    259  C   TYR    33      -6.643  23.264   5.616  1.00 39.90           C
ATOM    260  O   TYR    33      -5.429  23.416   5.724  1.00 35.50           O
ATOM    261  N   ASN    34      -7.498  24.283   5.567  1.00 41.06           N
ATOM    262  CA  ASN    34      -7.050  25.671   5.610  1.00 44.50           C
ATOM    263  CB  ASN    34      -8.239  26.629   5.529  1.00 48.47           C
ATOM    264  CG  ASN    34      -8.921  26.596   4.175  1.00 65.44           C
ATOM    265  OD1 ASN    34      -8.309  26.239   3.166  1.00 71.56           O
ATOM    266  ND2 ASN    34     -10.195  26.970   4.144  1.00 71.13           N
ATOM    267  C   ASN    34      -6.226  25.965   6.853  1.00 51.02           C
ATOM    268  O   ASN    34      -5.295  26.771   6.815  1.00 53.72           O
ATOM    269  N   THR    35      -6.572  25.303   7.952  1.00 52.53           N
ATOM    270  CA  THR    35      -5.828  25.448   9.198  1.00 55.06           C
ATOM    271  CB  THR    35      -6.522  24.708  10.352  1.00 48.81           C
ATOM    272  OG1 THR    35      -7.653  25.470  10.792  1.00 50.83           O
ATOM    273  CG2 THR    35      -5.569  24.519  11.513  1.00 46.15           C
ATOM    274  C   THR    35      -4.397  24.935   9.047  1.00 58.99           C
ATOM    275  O   THR    35      -3.436  25.617   9.409  1.00 59.86           O
ATOM    276  N   SER    36      -4.266  23.728   8.508  1.00 57.80           N
ATOM    277  CA  SER    36      -2.962  23.130   8.255  1.00 44.32           C
ATOM    278  CB  SER    36      -2.239  22.839   9.569  1.00 41.58           C
ATOM    279  OG  SER    36      -0.905  22.417   9.343  1.00 42.17           O
ATOM    280  C   SER    36      -3.125  21.849   7.450  1.00 41.50           C
ATOM    281  O   SER    36      -4.073  21.089   7.648  1.00 41.29           O
ATOM    282  N   HIS    37      -2.199  21.617   6.533  1.00 39.31           N
ATOM    283  CA  HIS    37      -2.235  20.422   5.711  1.00 36.95           C
ATOM    284  CB  HIS    37      -3.221  20.597   4.557  1.00 37.03           C
ATOM    285  CG  HIS    37      -2.976  21.820   3.727  1.00 40.92           C
ATOM    286  ND1 HIS    37      -3.591  23.028   3.980  1.00 42.94           N
ATOM    287  CE1 HIS    37      -3.196  23.918   3.089  1.00 42.20           C
ATOM    288  NE2 HIS    37      -2.347  23.333   2.262  1.00 39.83           N
ATOM    289  CD2 HIS    37      -2.193  22.020   2.640  1.00 40.89           C
ATOM    290  C   HIS    37      -0.843  20.141   5.180  1.00 37.63           C
ATOM    291  O   HIS    37       0.064  20.947   5.354  1.00 36.89           O
ATOM    292  N   ILE    38      -0.671  18.994   4.539  1.00 41.55           N
ATOM    293  CA  ILE    38       0.616  18.639   3.958  1.00 37.60           C
ATOM    294  CB  ILE    38       0.675  17.134   3.639  1.00 30.71           C
ATOM    295  CG1 ILE    38       0.259  16.325   4.874  1.00 27.77           C
ATOM    296  CD1 ILE    38       0.168  14.832   4.637  1.00 22.41           C
ATOM    297  CG2 ILE    38       2.068  16.735   3.159  1.00 25.86           C
ATOM    298  C   ILE    38       0.872  19.480   2.705  1.00 35.63           C
ATOM    299  O   ILE    38      -0.035  19.695   1.901  1.00 32.64           O
ATOM    300  N   LEU    39       2.099  19.967   2.546  1.00 40.56           N
ATOM    301  CA  LEU    39       2.412  20.870   1.436  1.00 48.63           C
ATOM    302  CB  LEU    39       3.922  21.157   1.332  1.00 49.42           C
ATOM    303  CG  LEU    39       4.947  20.017   1.273  1.00 56.26           C
ATOM    304  CD1 LEU    39       4.808  19.181   0.011  1.00 57.74           C
ATOM    305  CD2 LEU    39       6.363  20.577   1.378  1.00 64.17           C
ATOM    306  C   LEU    39       1.857  20.374   0.104  1.00 47.80           C
ATOM    307  O   LEU    39       1.971  19.196  -0.236  1.00 55.06           O
ATOM    308  N   GLU    40       1.241  21.283  -0.639  1.00 45.55           N
ATOM    309  CA  GLU    40       0.723  20.961  -1.960  1.00 52.91           C
ATOM    310  CB  GLU    40       1.867  20.613  -2.918  1.00 61.40           C
ATOM    311  CG  GLU    40       2.642  21.827  -3.418  1.00 81.82           C
ATOM    312  CD  GLU    40       3.678  21.467  -4.467  1.00 94.83           C
ATOM    313  OE1 GLU    40       4.364  20.435  -4.296  1.00 97.63           O
ATOM    314  OE2 GLU    40       3.809  22.218  -5.460  1.00 98.12           O
ATOM    315  C   GLU    40      -0.298  19.832  -1.933  1.00 51.57           C
ATOM    316  O   GLU    40      -0.360  19.028  -2.862  1.00 61.01           O
ATOM    317  N   ALA    41      -1.093  19.763  -0.871  1.00 41.75           N
ATOM    318  CA  ALA    41      -2.187  18.803  -0.832  1.00 33.55           C
ATOM    319  CB  ALA    41      -2.421  18.295   0.577  1.00 30.22           C
ATOM    320  C   ALA    41      -3.436  19.466  -1.379  1.00 35.11           C
ATOM    321  O   ALA    41      -3.708  20.629  -1.081  1.00 33.51           O
ATOM    322  N   ILE    42      -4.180  18.722  -2.193  1.00 34.36           N
ATOM    323  CA  ILE    42      -5.415  19.206  -2.790  1.00 28.06           C
ATOM    324  CB  ILE    42      -5.636  18.595  -4.194  1.00 36.87           C
ATOM    325  CG1 ILE    42      -4.595  19.131  -5.181  1.00 40.30           C
ATOM    326  CD1 ILE    42      -4.813  18.677  -6.612  1.00 45.01           C
ATOM    327  CG2 ILE    42      -7.047  18.878  -4.701  1.00 36.92           C
ATOM    328  C   ILE    42      -6.594  18.864  -1.890  1.00 32.24           C
ATOM    329  O   ILE    42      -6.788  17.710  -1.512  1.00 33.40           O
ATOM    330  N   ASN    43      -7.380  19.872  -1.542  1.00 29.34           N
ATOM    331  CA  ASN    43      -8.510  19.653  -0.667  1.00 25.86           C
ATOM    332  CB  ASN    43      -8.889  20.947   0.044  1.00 33.60           C
ATOM    333  CG  ASN    43      -9.821  20.715   1.216  1.00 34.17           C
ATOM    334  OD1 ASN    43     -10.557  21.611   1.625  1.00 36.36           O
ATOM    335  ND2 ASN    43      -9.795  19.506   1.761  1.00 36.56           N
ATOM    336  C   ASN    43      -9.697  19.109  -1.438  1.00 34.70           C
ATOM    337  O   ASN    43     -10.195  19.753  -2.359  1.00 33.23           O
ATOM    338  N   ILE    44     -10.137  17.911  -1.072  1.00 41.22           N
ATOM    339  CA  ILE    44     -11.353  17.349  -1.648  1.00 51.00           C
ATOM    340  CB  ILE    44     -11.096  15.995  -2.361  1.00 33.87           C
ATOM    341  CG1 ILE    44     -10.543  16.248  -3.760  1.00 35.46           C
ATOM    342  CD1 ILE    44     -10.673  15.065  -4.684  1.00 40.96           C
ATOM    343  CG2 ILE    44     -12.368  15.184  -2.489  1.00 35.59           C
ATOM    344  C   ILE    44     -12.437  17.256  -0.575  1.00 57.35           C
ATOM    345  O   ILE    44     -12.371  16.422   0.326  1.00 55.31           O
ATOM    346  N   ASN    45     -13.419  18.146  -0.683  1.00 69.12           N
ATOM    347  CA  ASN    45     -14.475  18.302   0.313  1.00 80.69           C
ATOM    348  C   ASN    45     -15.091  16.983   0.775  1.00 77.66           C
ATOM    349  CB  ASN    45     -15.573  19.217  -0.236  1.00 92.37           C
ATOM    350  CG  ASN    45     -16.517  19.705   0.841  1.00 97.46           C
ATOM    351  OD1 ASN    45     -16.111  19.922   1.985  1.00 98.67           O
ATOM    352  ND2 ASN    45     -17.785  19.885   0.481  1.00 96.06           N
ATOM    353  O   ASN    45     -15.590  16.207  -0.040  1.00 82.94           O
ATOM    354  N   CYS    46     -15.073  16.750   2.085  1.00 67.08           N
ATOM    355  CA  CYS    46     -15.598  15.515   2.669  1.00 62.47           C
ATOM    356  C   CYS    46     -17.125  15.529   2.814  1.00 62.17           C
ATOM    357  CB  CYS    46     -14.951  15.277   4.040  1.00 59.73           C
ATOM    358  SG  CYS    46     -15.230  13.636   4.766  1.00106.57           S
ATOM    359  O   CYS    46     -17.658  15.093   3.832  1.00 71.02           O
ATOM    360  N   SER    47     -17.825  16.011   1.791  1.00 53.92           N
ATOM    361  CA  SER    47     -19.259  16.273   1.909  1.00 51.97           C
ATOM    362  C   SER    47     -20.132  15.032   1.738  1.00 45.27           C
ATOM    363  CB  SER    47     -19.687  17.360   0.918  1.00 54.06           C
ATOM    364  OG  SER    47     -21.041  17.724   1.118  1.00 54.99           O
ATOM    365  O   SER    47     -19.829  14.150   0.937  1.00 51.10           O
ATOM    366  N   LYS    48     -21.223  14.977   2.495  1.00 41.59           N
ATOM    367  CA  LYS    48     -22.188  13.888   2.374  1.00 41.93           C
ATOM    368  C   LYS    48     -22.929  13.983   1.048  1.00 35.27           C
ATOM    369  CB  LYS    48     -23.191  13.925   3.526  1.00 42.50           C
ATOM    370  CG  LYS    48     -24.331  12.935   3.373  1.00 48.77           C
ATOM    371  O   LYS    48     -23.354  12.976   0.480  1.00 26.58           O
ATOM    372  N   LEU    49     -23.087  15.211   0.566  1.00 38.61           N
ATOM    373  CA  LEU    49     -23.676  15.449  -0.741  1.00 38.50           C
ATOM    374  C   LEU    49     -22.740  14.992  -1.847  1.00 38.28           C
ATOM    375  CB  LEU    49     -24.007  16.929  -0.922  1.00 39.79           C
ATOM    376  CG  LEU    49     -25.456  17.296  -0.618  1.00 42.29           C
ATOM    377  CD1 LEU    49     -25.764  17.087   0.855  1.00 47.32           C
ATOM    378  CD2 LEU    49     -25.728  18.726  -1.038  1.00 42.96           C
ATOM    379  O   LEU    49     -23.153  14.307  -2.783  1.00 37.28           O
ATOM    380  N   MET    50     -21.475  15.376  -1.737  1.00 42.28           N
ATOM    381  CA  MET    50     -20.492  15.014  -2.745  1.00 37.99           C
ATOM    382  CB  MET    50     -19.161  15.716  -2.492  1.00 38.85           C
ATOM    383  CG  MET    50     -18.174  15.571  -3.644  1.00 43.10           C
ATOM    384  SD  MET    50     -18.756  16.316  -5.183  1.00 49.92           S
ATOM    385  CE  MET    50     -18.899  18.036  -4.706  1.00 35.64           C
ATOM    386  C   MET    50     -20.293  13.505  -2.805  1.00 34.27           C
ATOM    387  O   MET    50     -20.042  12.954  -3.872  1.00 43.24           O
ATOM    388  N   LYS    51     -20.409  12.838  -1.661  1.00 32.27           N
ATOM    389  CA  LYS    51     -20.316  11.383  -1.629  1.00 32.79           C
ATOM    390  C   LYS    51     -21.427  10.757  -2.471  1.00 30.43           C
ATOM    391  CB  LYS    51     -20.397  10.861  -0.194  1.00 36.87           C
ATOM    392  CG  LYS    51     -20.241   9.350  -0.097  1.00 39.71           C
ATOM    393  CD  LYS    51     -20.381   8.859   1.329  1.00 41.39           C
ATOM    394  CE  LYS    51     -21.813   8.935   1.803  1.00 42.82           C
ATOM    395  NZ  LYS    51     -21.967   8.281   3.129  1.00 51.50           N
ATOM    396  O   LYS    51     -21.196   9.813  -3.222  1.00 31.73           O
ATOM    397  N   ARG    52     -22.632  11.296  -2.335  1.00 24.42           N
ATOM    398  CA  ARG    52     -23.786  10.810  -3.082  1.00 34.25           C
ATOM    399  C   ARG    52     -23.603  10.993  -4.589  1.00 38.67           C
ATOM    400  CB  ARG    52     -25.062  11.518  -2.602  1.00 36.38           C
ATOM    401  CG  ARG    52     -26.269  11.362  -3.516  1.00 40.51           C
ATOM    402  CD  ARG    52     -26.730   9.923  -3.584  1.00 47.64           C
ATOM    403  NE  ARG    52     -27.173   9.434  -2.283  1.00 60.47           N
ATOM    404  CZ  ARG    52     -28.441   9.428  -1.878  1.00 68.99           C
ATOM    405  NH1 ARG    52     -28.748   8.961  -0.673  1.00 70.98           N
ATOM    406  NH2 ARG    52     -29.402   9.885  -2.677  1.00 59.63           N
ATOM    407  O   ARG    52     -23.931  10.106  -5.375  1.00 38.99           O
ATOM    408  N   ARG    53     -23.076  12.143  -4.991  1.00 37.78           N
ATOM    409  CA  ARG    53     -22.926  12.441  -6.408  1.00 27.97           C
ATOM    410  CB  ARG    53     -22.643  13.925  -6.619  1.00 30.07           C
ATOM    411  CG  ARG    53     -23.701  14.835  -6.027  1.00 32.32           C
ATOM    412  CD  ARG    53     -23.223  16.270  -6.028  1.00 34.30           C
ATOM    413  NE  ARG    53     -23.065  16.769  -7.386  1.00 37.14           N
ATOM    414  CZ  ARG    53     -22.296  17.799  -7.718  1.00 41.11           C
ATOM    415  NH1 ARG    53     -21.601  18.441  -6.787  1.00 41.03           N
ATOM    416  NH2 ARG    53     -22.215  18.181  -8.984  1.00 50.49           N
ATOM    417  C   ARG    53     -21.828  11.598  -7.034  1.00 26.58           C
ATOM    418  O   ARG    53     -21.929  11.219  -8.198  1.00 33.31           O
ATOM    419  N   LEU    54     -20.783  11.302  -6.263  1.00 23.11           N
ATOM    420  CA  LEU    54     -19.707  10.430  -6.739  1.00 26.22           C
ATOM    421  CB  LEU    54     -18.529  10.417  -5.767  1.00 26.60           C
ATOM    422  CG  LEU    54     -17.546  11.584  -5.815  1.00 28.36           C
ATOM    423  CD1 LEU    54     -16.705  11.573  -4.562  1.00 31.64           C
ATOM    424  CD2 LEU    54     -16.668  11.506  -7.047  1.00 25.92           C
ATOM    425  C   LEU    54     -20.201   9.007  -6.942  1.00 32.23           C
ATOM    426  O   LEU    54     -19.881   8.372  -7.947  1.00 39.27           O
ATOM    427  N   GLN    55     -20.975   8.501  -5.987  1.00 32.69           N
ATOM    428  CA  GLN    55     -21.512   7.149  -6.117  1.00 39.72           C
ATOM    429  CB  GLN    55     -21.870   6.542  -4.756  1.00 36.87           C
ATOM    430  CG  GLN    55     -22.697   7.409  -3.846  1.00 39.89           C
ATOM    431  CD  GLN    55     -22.716   6.873  -2.427  1.00 50.23           C
ATOM    432  OE1 GLN    55     -23.337   7.454  -1.535  1.00 61.14           O
ATOM    433  NE2 GLN    55     -22.026   5.759  -2.211  1.00 47.60           N
ATOM    434  C   GLN    55     -22.677   7.065  -7.106  1.00 42.85           C
ATOM    435  O   GLN    55     -22.957   6.000  -7.650  1.00 44.76           O
ATOM    436  N   GLN    56     -23.347   8.190  -7.344  1.00 46.82           N
ATOM    437  CA  GLN    56     -24.323   8.276  -8.426  1.00 45.42           C
ATOM    438  CB  GLN    56     -25.273   9.453  -8.211  1.00 50.60           C
ATOM    439  CG  GLN    56     -26.336   9.183  -7.174  1.00 59.55           C
ATOM    440  CD  GLN    56     -27.059   7.880  -7.431  1.00 68.75           C
ATOM    441  OE1 GLN    56     -27.391   7.554  -8.573  1.00 69.19           O
ATOM    442  NE2 GLN    56     -27.305   7.122  -6.369  1.00 73.71           N
ATOM    443  C   GLN    56     -23.606   8.424  -9.762  1.00 49.15           C
ATOM    444  O   GLN    56     -24.227   8.383 -10.825  1.00 50.61           O
ATOM    445  N   ASP    57     -22.290   8.595  -9.691  1.00 50.01           N
ATOM    446  CA  ASP    57     -21.457   8.794 -10.870  1.00 50.90           C
ATOM    447  C   ASP    57     -21.863  10.036 -11.669  1.00 48.47           C
ATOM    448  CB  ASP    57     -21.457   7.541 -11.753  1.00 63.04           C
ATOM    449  CG  ASP    57     -20.622   6.411 -11.164  1.00 74.02           C
ATOM    450  OD1 ASP    57     -19.612   6.702 -10.484  1.00 69.32           O
ATOM    451  OD2 ASP    57     -20.971   5.231 -11.387  1.00 83.00           O
ATOM    452  O   ASP    57     -21.687  10.082 -12.890  1.00 49.58           O
ATOM    453  N   LYS    58     -22.395  11.041 -10.973  1.00 43.80           N
ATOM    454  CA  LYS    58     -22.780  12.306 -11.604  1.00 39.90           C
ATOM    455  CB  LYS    58     -24.050  12.877 -10.971  1.00 36.58           C
ATOM    456  CG  LYS    58     -25.286  12.043 -11.247  1.00 39.76           C
ATOM    457  CD  LYS    58     -25.431  11.760 -12.733  1.00 49.52           C
ATOM    458  CE  LYS    58     -26.482  10.694 -12.996  1.00 56.22           C
ATOM    459  NZ  LYS    58     -26.491  10.267 -14.423  1.00 61.47           N
ATOM    460  C   LYS    58     -21.647  13.319 -11.523  1.00 42.27           C
ATOM    461  O   LYS    58     -21.711  14.387 -12.131  1.00 51.90           O
ATOM    462  N   VAL    59     -20.623  12.971 -10.751  1.00 33.26           N
ATOM    463  CA  VAL    59     -19.376  13.719 -10.688  1.00 29.60           C
ATOM    464  CB  VAL    59     -19.187  14.431  -9.324  1.00 28.62           C
ATOM    465  CG1 VAL    59     -17.858  15.162  -9.289  1.00 29.32           C
ATOM    466  CG2 VAL    59     -20.323  15.396  -9.049  1.00 29.12           C
ATOM    467  C   VAL    59     -18.260  12.698 -10.855  1.00 34.05           C
ATOM    468  O   VAL    59     -18.344  11.597 -10.305  1.00 35.30           O
ATOM    469  N   LEU    60     -17.229  13.042 -11.625  1.00 37.50           N
ATOM    470  CA  LEU    60     -16.067  12.166 -11.772  1.00 42.21           C
ATOM    471  CB  LEU    60     -15.575  12.135 -13.221  1.00 45.41           C
ATOM    472  CG  LEU    60     -16.498  11.491 -14.257  1.00 47.20           C
ATOM    473  CD1 LEU    60     -15.752  11.303 -15.561  1.00 52.01           C
ATOM    474  CD2 LEU    60     -17.049  10.161 -13.759  1.00 43.24           C
ATOM    475  C   LEU    60     -14.946  12.619 -10.847  1.00 41.66           C
ATOM    476  O   LEU    60     -14.722  13.816 -10.683  1.00 40.31           O
ATOM    477  N   ILE    61     -14.246  11.666 -10.239  1.00 38.19           N
ATOM    478  CA  ILE    61     -13.184  12.014  -9.309  1.00 32.87           C
ATOM    479  CB  ILE    61     -12.527  10.765  -8.670  1.00 29.11           C
ATOM    480  CG1 ILE    61     -11.690  11.173  -7.459  1.00 25.84           C
ATOM    481  CD1 ILE    61     -12.436  12.039  -6.466  1.00 29.15           C
ATOM    482  CG2 ILE    61     -11.687  10.010  -9.676  1.00 20.82           C
ATOM    483  C   ILE    61     -12.143  12.914  -9.978  1.00 30.86           C
ATOM    484  O   ILE    61     -11.636  13.849  -9.355  1.00 30.96           O
ATOM    485  N   THR    62     -11.843  12.647 -11.248  1.00 34.08           N
ATOM    486  CA  THR    62     -10.919  13.491 -12.012  1.00 35.89           C
ATOM    487  CB  THR    62     -10.602  12.902 -13.407  1.00 39.01           C
ATOM    488  OG1 THR    62     -11.811  12.457 -14.037  1.00 44.98           O
ATOM    489  CG2 THR    62      -9.630  11.731 -13.291  1.00 29.67           C
ATOM    490  C   THR    62     -11.467  14.907 -12.178  1.00 40.36           C
ATOM    491  O   THR    62     -10.713  15.877 -12.242  1.00 44.86           O
ATOM    492  N   GLU    63     -12.788  15.013 -12.247  1.00 40.84           N
ATOM    493  CA  GLU    63     -13.456  16.299 -12.348  1.00 38.96           C
ATOM    494  CB  GLU    63     -14.904  16.078 -12.780  1.00 48.16           C
ATOM    495  CG  GLU    63     -15.704  17.342 -13.020  1.00 66.32           C
ATOM    496  CD  GLU    63     -17.144  17.044 -13.401  1.00 78.42           C
ATOM    497  OE1 GLU    63     -17.461  15.858 -13.645  1.00 72.66           O
ATOM    498  OE2 GLU    63     -17.957  17.995 -13.457  1.00 87.86           O
ATOM    499  C   GLU    63     -13.399  17.044 -11.010  1.00 40.37           C
ATOM    500  O   GLU    63     -13.166  18.248 -10.961  1.00 45.37           O
ATOM    501  N   LEU    64     -13.607  16.315  -9.922  1.00 37.95           N
ATOM    502  CA  LEU    64     -13.612  16.904  -8.590  1.00 35.93           C
ATOM    503  CB  LEU    64     -14.094  15.865  -7.577  1.00 40.45           C
ATOM    504  CG  LEU    64     -14.491  16.330  -6.179  1.00 44.49           C
ATOM    505  CD1 LEU    64     -15.480  17.482  -6.245  1.00 40.87           C
ATOM    506  CD2 LEU    64     -15.073  15.151  -5.417  1.00 47.40           C
ATOM    507  C   LEU    64     -12.219  17.409  -8.215  1.00 38.16           C
ATOM    508  O   LEU    64     -12.072  18.501  -7.672  1.00 39.82           O
ATOM    509  N   ILE    65     -11.204  16.603  -8.514  1.00 37.64           N
ATOM    510  CA  ILE    65      -9.811  16.944  -8.235  1.00 39.92           C
ATOM    511  CB  ILE    65      -8.864  15.860  -8.779  1.00 35.24           C
ATOM    512  CG1 ILE    65      -8.873  14.636  -7.861  1.00 29.71           C
ATOM    513  CD1 ILE    65      -8.242  13.402  -8.481  1.00 28.25           C
ATOM    514  CG2 ILE    65      -7.453  16.416  -8.947  1.00 30.91           C
ATOM    515  C   ILE    65      -9.393  18.280  -8.838  1.00 46.48           C
ATOM    516  O   ILE    65      -8.794  19.118  -8.162  1.00 45.83           O
ATOM    517  N   GLN    66      -9.709  18.463 -10.118  1.00 56.22           N
ATOM    518  CA  GLN    66      -9.350  19.670 -10.857  1.00 54.55           C
ATOM    519  CB  GLN    66      -9.550  19.444 -12.353  1.00 60.28           C
ATOM    520  CG  GLN    66      -9.064  20.585 -13.211  1.00 72.01           C
ATOM    521  CD  GLN    66      -7.578  20.511 -13.468  1.00 85.30           C
ATOM    522  OE1 GLN    66      -6.823  21.403 -13.077  1.00 92.06           O
ATOM    523  NE2 GLN    66      -7.146  19.439 -14.124  1.00 86.93           N
ATOM    524  C   GLN    66     -10.155  20.893 -10.417  1.00 50.28           C
ATOM    525  O   GLN    66      -9.648  22.016 -10.437  1.00 55.72           O
ATOM    526  N   HIS    67     -11.411  20.675 -10.033  1.00 43.67           N
ATOM    527  CA  HIS    67     -12.275  21.762  -9.582  1.00 44.40           C
ATOM    528  CB  HIS    67     -13.738  21.313  -9.541  1.00 40.90           C
ATOM    529  C   HIS    67     -11.839  22.212  -8.200  1.00 49.95           C
ATOM    530  O   HIS    67     -12.064  23.357  -7.807  1.00 53.24           O
ATOM    531  N   SER    68     -11.210  21.291  -7.475  1.00 47.00           N
ATOM    532  CA  SER    68     -10.787  21.524  -6.102  1.00 45.77           C
ATOM    533  C   SER    68      -9.403  22.158  -6.042  1.00 53.15           C
ATOM    534  CB  SER    68     -10.788  20.205  -5.325  1.00 42.58           C
ATOM    535  OG  SER    68     -12.075  19.607  -5.330  1.00 48.44           O
ATOM    536  O   SER    68      -8.946  22.576  -4.981  1.00 61.48           O
ATOM    537  O   ALA    69      -7.891  24.743  -8.426  1.00 78.32           O
ATOM    538  N   ALA    69      -8.737  22.232  -7.184  1.00 59.34           N
ATOM    539  CA  ALA    69      -7.374  22.733  -7.216  1.00 73.24           C
ATOM    540  C   ALA    69      -7.323  24.234  -7.457  1.00 80.42           C
ATOM    541  CB  ALA    69      -6.559  21.992  -8.271  1.00 80.03           C
ATOM    542  N   LYS    70      -6.648  24.938  -6.555  1.00 88.75           N
ATOM    543  CA  LYS    70      -6.339  26.342  -6.763  1.00 91.54           C
ATOM    544  C   LYS    70      -5.386  26.422  -7.948  1.00 93.60           C
ATOM    545  CB  LYS    70      -5.701  26.941  -5.509  1.00 87.53           C
ATOM    546  CG  LYS    70      -6.579  26.853  -4.267  1.00 82.32           C
ATOM    547  O   LYS    70      -5.556  27.247  -8.846  1.00 95.71           O
ATOM    548  N   HIS    71      -4.388  25.543  -7.944  1.00 91.55           N
ATOM    549  CA  HIS    71      -3.513  25.361  -9.093  1.00 89.14           C
ATOM    550  C   HIS    71      -4.298  24.694 -10.219  1.00 90.61           C
ATOM    551  CB  HIS    71      -2.315  24.487  -8.708  1.00 81.33           C
ATOM    552  O   HIS    71      -5.423  24.235 -10.013  1.00 92.67           O
ATOM    553  N   LYS    72      -3.720  24.650 -11.414  1.00 87.36           N
ATOM    554  CA  LYS    72      -4.278  23.819 -12.472  1.00 83.80           C
ATOM    555  C   LYS    72      -3.679  22.426 -12.311  1.00 83.67           C
ATOM    556  CB  LYS    72      -3.963  24.393 -13.854  1.00 80.30           C
ATOM    557  O   LYS    72      -2.520  22.198 -12.662  1.00 86.83           O
ATOM    558  N   VAL    73      -4.462  21.504 -11.756  1.00 76.29           N
ATOM    559  CA  VAL    73      -3.961  20.177 -11.401  1.00 62.44           C
ATOM    560  C   VAL    73      -3.731  19.279 -12.615  1.00 55.24           C
ATOM    561  CB  VAL    73      -4.903  19.460 -10.407  1.00 53.77           C
ATOM    562  O   VAL    73      -4.500  19.301 -13.577  1.00 50.98           O
ATOM    563  N   ASP    74      -2.660  18.494 -12.564  1.00 56.44           N
ATOM    564  CA  ASP    74      -2.386  17.505 -13.597  1.00 58.76           C
ATOM    565  C   ASP    74      -3.122  16.221 -13.275  1.00 50.96           C
ATOM    566  CB  ASP    74      -0.886  17.215 -13.700  1.00 70.12           C
ATOM    567  CG  ASP    74      -0.582  15.975 -14.535  1.00 78.77           C
ATOM    568  OD1 ASP    74      -1.282  15.747 -15.546  1.00 84.78           O
ATOM    569  OD2 ASP    74       0.363  15.234 -14.181  1.00 76.70           O
ATOM    570  O   ASP    74      -2.873  15.590 -12.250  1.00 48.16           O
ATOM    571  N   ILE    75      -4.046  15.840 -14.144  1.00 51.11           N
ATOM    572  CA  ILE    75      -4.667  14.536 -14.022  1.00 50.32           C
ATOM    573  C   ILE    75      -3.983  13.601 -15.007  1.00 53.98           C
ATOM    574  CB  ILE    75      -6.189  14.585 -14.241  1.00 48.96           C
ATOM    575  CG1 ILE    75      -6.521  14.994 -15.681  1.00 54.90           C
ATOM    576  CG2 ILE    75      -6.833  15.531 -13.230  1.00 40.78           C
ATOM    577  CD1 ILE    75      -7.903  14.562 -16.139  1.00 53.82           C
ATOM    578  O   ILE    75      -3.904  13.873 -16.208  1.00 58.19           O
ATOM    579  N   ASP    76      -3.458  12.510 -14.472  1.00 46.59           N
ATOM    580  CA  ASP    76      -2.659  11.582 -15.243  1.00 39.95           C
ATOM    581  C   ASP    76      -2.639  10.291 -14.449  1.00 39.99           C
ATOM    582  CB  ASP    76      -1.253  12.145 -15.415  1.00 46.24           C
ATOM    583  CG  ASP    76      -0.300  11.160 -16.044  1.00 62.54           C
ATOM    584  OD1 ASP    76      -0.767  10.150 -16.611  1.00 58.76           O
ATOM    585  OD2 ASP    76       0.924  11.403 -15.971  1.00 78.13           O
ATOM    586  O   ASP    76      -2.167  10.268 -13.313  1.00 43.30           O
ATOM    587  N   CYS    77      -3.170   9.224 -15.038  1.00 32.09           N
ATOM    588  CA  CYS    77      -3.415   7.989 -14.299  1.00 29.25           C
ATOM    589  C   CYS    77      -2.139   7.293 -13.817  1.00 30.94           C
ATOM    590  CB  CYS    77      -4.292   7.029 -15.115  1.00 24.46           C
ATOM    591  SG  CYS    77      -3.488   6.287 -16.538  1.00 32.77           S
ATOM    592  O   CYS    77      -2.204   6.267 -13.143  1.00 34.92           O
ATOM    593  N   SER    78      -0.983   7.861 -14.148  1.00 32.37           N
ATOM    594  CA  SER    78       0.297   7.305 -13.715  1.00 33.84           C
ATOM    595  C   SER    78       0.796   7.964 -12.427  1.00 39.45           C
ATOM    596  CB  SER    78       1.338   7.474 -14.814  1.00 39.39           C
ATOM    597  OG  SER    78       1.506   8.846 -15.119  1.00 45.95           O
ATOM    598  O   SER    78       1.759   7.500 -11.814  1.00 39.60           O
ATOM    599  N   GLN    79       0.142   9.051 -12.025  1.00 38.96           N
ATOM    600  CA  GLN    79       0.479   9.743 -10.784  1.00 33.59           C
ATOM    601  C   GLN    79       0.225   8.863  -9.578  1.00 33.66           C
ATOM    602  CB  GLN    79      -0.364  11.005 -10.632  1.00 35.24           C
ATOM    603  CG  GLN    79       0.194  12.221 -11.328  1.00 45.10           C
ATOM    604  CD  GLN    79      -0.737  13.395 -11.211  1.00 52.62           C
ATOM    605  OE1 GLN    79      -0.378  14.437 -10.664  1.00 61.12           O
ATOM    606  NE2 GLN    79      -1.958  13.225 -11.700  1.00 49.63           N
ATOM    607  O   GLN    79      -0.851   8.277  -9.452  1.00 42.02           O
ATOM    608  N   LYS    80       1.206   8.776  -8.686  1.00 25.19           N
ATOM    609  CA  LYS    80       0.990   8.094  -7.424  1.00 23.95           C
ATOM    610  C   LYS    80       0.098   8.990  -6.581  1.00 26.27           C
ATOM    611  CB  LYS    80       2.309   7.823  -6.709  1.00 27.50           C
ATOM    612  CG  LYS    80       3.383   7.190  -7.587  1.00 35.39           C
ATOM    613  CD  LYS    80       2.995   5.798  -8.046  1.00 42.35           C
ATOM    614  CE  LYS    80       4.053   5.225  -8.976  1.00 58.22           C
ATOM    615  NZ  LYS    80       3.737   3.844  -9.433  1.00 69.00           N
ATOM    616  O   LYS    80       0.456  10.131  -6.291  1.00 30.53           O
ATOM    617  N   VAL    81      -1.074   8.480  -6.213  1.00 22.03           N
ATOM    618  CA  VAL    81      -2.047   9.257  -5.448  1.00 29.89           C
ATOM    619  CB  VAL    81      -3.468   9.155  -6.065  1.00 29.34           C
ATOM    620  CG1 VAL    81      -4.430  10.081  -5.349  1.00 27.61           C
ATOM    621  CG2 VAL    81      -3.430   9.479  -7.554  1.00 26.33           C
ATOM    622  C   VAL    81      -2.084   8.812  -3.983  1.00 32.41           C
ATOM    623  O   VAL    81      -2.341   7.647  -3.690  1.00 34.11           O
ATOM    624  N   VAL    82      -1.806   9.737  -3.071  1.00 30.28           N
ATOM    625  CA  VAL    82      -1.886   9.450  -1.647  1.00 24.58           C
ATOM    626  CB  VAL    82      -0.584   9.814  -0.917  1.00 27.13           C
ATOM    627  CG1 VAL    82      -0.712   9.520   0.570  1.00 27.30           C
ATOM    628  CG2 VAL    82       0.596   9.060  -1.518  1.00 18.42           C
ATOM    629  C   VAL    82      -3.029  10.247  -1.037  1.00 27.75           C
ATOM    630  O   VAL    82      -3.064  11.468  -1.140  1.00 27.86           O
ATOM    631  N   VAL    83      -3.970   9.548  -0.414  1.00 25.86           N
ATOM    632  CA  VAL    83      -5.099  10.198   0.224  1.00 26.95           C
ATOM    633  CB  VAL    83      -6.426   9.521  -0.152  1.00 33.42           C
ATOM    634  CG1 VAL    83      -7.609  10.406   0.243  1.00 31.46           C
ATOM    635  CG2 VAL    83      -6.454   9.226  -1.636  1.00 37.17           C
ATOM    636  C   VAL    83      -4.929  10.118   1.727  1.00 29.97           C
ATOM    637  O   VAL    83      -4.300   9.192   2.236  1.00 33.29           O
ATOM    638  N   TYR    84      -5.489  11.090   2.437  1.00 28.76           N
ATOM    639  CA  TYR    84      -5.437  11.088   3.892  1.00 22.70           C
ATOM    640  CB  TYR    84      -4.109  11.673   4.394  1.00 23.70           C
ATOM    641  CG  TYR    84      -3.922  13.174   4.208  1.00 22.59           C
ATOM    642  CD1 TYR    84      -4.302  14.067   5.204  1.00 25.05           C
ATOM    643  CE1 TYR    84      -4.120  15.433   5.057  1.00 24.38           C
ATOM    644  CZ  TYR    84      -3.543  15.924   3.908  1.00 29.29           C
ATOM    645  OH  TYR    84      -3.365  17.283   3.771  1.00 28.86           O
ATOM    646  CE2 TYR    84      -3.144  15.060   2.901  1.00 29.54           C
ATOM    647  CD2 TYR    84      -3.328  13.691   3.059  1.00 27.85           C
ATOM    648  C   TYR    84      -6.625  11.808   4.524  1.00 25.65           C
ATOM    649  O   TYR    84      -7.168  12.754   3.955  1.00 28.74           O
ATOM    650  N   ASP    85      -7.043  11.321   5.687  1.00 28.55           N
ATOM    651  CA  ASP    85      -7.975  12.047   6.542  1.00 29.47           C
ATOM    652  CB  ASP    85      -9.270  11.258   6.788  1.00 31.81           C
ATOM    653  CG  ASP    85      -9.031   9.917   7.460  1.00 41.96           C
ATOM    654  OD1 ASP    85      -7.857   9.555   7.677  1.00 44.75           O
ATOM    655  OD2 ASP    85     -10.029   9.224   7.767  1.00 44.78           O
ATOM    656  C   ASP    85      -7.261  12.385   7.847  1.00 32.18           C
ATOM    657  O   ASP    85      -6.040  12.518   7.871  1.00 29.69           O
ATOM    658  N   GLN    86      -8.004  12.518   8.936  1.00 37.70           N
ATOM    659  CA  GLN    86      -7.394  12.974  10.178  1.00 36.77           C
ATOM    660  CB  GLN    86      -8.448  13.568  11.124  1.00 38.36           C
ATOM    661  CG  GLN    86      -7.866  14.223  12.381  1.00 39.57           C
ATOM    662  CD  GLN    86      -6.771  15.242  12.079  1.00 48.25           C
ATOM    663  OE1 GLN    86      -6.795  15.917  11.048  1.00 56.78           O
ATOM    664  NE2 GLN    86      -5.805  15.359  12.989  1.00 44.21           N
ATOM    665  C   GLN    86      -6.548  11.906  10.883  1.00 33.44           C
ATOM    666  O   GLN    86      -5.439  12.195  11.344  1.00 33.95           O
ATOM    667  N   SER    87      -7.048  10.675  10.960  1.00 29.04           N
ATOM    668  CA  SER    87      -6.357   9.666  11.751  1.00 30.16           C
ATOM    669  C   SER    87      -6.733   8.222  11.443  1.00 31.65           C
ATOM    670  CB  SER    87      -6.600   9.929  13.235  1.00 42.21           C
ATOM    671  OG  SER    87      -7.980   9.814  13.535  1.00 47.86           O
ATOM    672  O   SER    87      -6.716   7.383  12.339  1.00 41.52           O
ATOM    673  N   SER    88      -7.066   7.918  10.194  1.00 25.57           N
ATOM    674  CA  SER    88      -7.368   6.535   9.838  1.00 29.73           C
ATOM    675  CB  SER    88      -8.165   6.458   8.536  1.00 32.47           C
ATOM    676  OG  SER    88      -9.444   7.050   8.689  1.00 28.42           O
ATOM    677  C   SER    88      -6.079   5.725   9.738  1.00 36.38           C
ATOM    678  O   SER    88      -5.134   6.126   9.059  1.00 36.76           O
ATOM    679  N   GLN    89      -6.040   4.590  10.429  1.00 40.94           N
ATOM    680  CA  GLN    89      -4.831   3.769  10.487  1.00 45.01           C
ATOM    681  CB  GLN    89      -4.840   2.883  11.737  1.00 46.68           C
ATOM    682  CG  GLN    89      -4.791   3.658  13.040  1.00 54.54           C
ATOM    683  CD  GLN    89      -3.625   4.627  13.098  1.00 61.94           C
ATOM    684  OE1 GLN    89      -2.534   4.332  12.606  1.00 68.37           O
ATOM    685  NE2 GLN    89      -3.848   5.792  13.702  1.00 61.72           N
ATOM    686  C   GLN    89      -4.640   2.913   9.233  1.00 45.74           C
ATOM    687  O   GLN    89      -3.521   2.760   8.741  1.00 45.36           O
ATOM    688  N   ASP    90      -5.735   2.349   8.732  1.00 44.80           N
ATOM    689  CA  ASP    90      -5.703   1.572   7.497  1.00 43.06           C
ATOM    690  CB  ASP    90      -5.192   0.149   7.745  1.00 46.67           C
ATOM    691  CG  ASP    90      -5.937  -0.558   8.859  1.00 46.76           C
ATOM    692  OD1 ASP    90      -7.177  -0.668   8.781  1.00 49.99           O
ATOM    693  OD2 ASP    90      -5.272  -1.019   9.811  1.00 53.06           O
ATOM    694  C   ASP    90      -7.075   1.539   6.849  1.00 32.85           C
ATOM    695  O   ASP    90      -8.063   1.953   7.447  1.00 28.16           O
ATOM    696  N   VAL    91      -7.128   1.050   5.618  1.00 31.60           N
ATOM    697  CA  VAL    91      -8.381   0.989   4.883  1.00 37.21           C
ATOM    698  CB  VAL    91      -8.144   0.520   3.436  1.00 30.78           C
ATOM    699  CG1 VAL    91      -9.463   0.413   2.677  1.00 30.65           C
ATOM    700  CG2 VAL    91      -7.200   1.476   2.735  1.00 27.13           C
ATOM    701  C   VAL    91      -9.409   0.084   5.568  1.00 38.53           C
ATOM    702  O   VAL    91     -10.610   0.355   5.526  1.00 41.48           O
ATOM    703  N   ALA    92      -8.934  -0.980   6.210  1.00 35.68           N
ATOM    704  CA  ALA    92      -9.822  -1.979   6.798  1.00 37.95           C
ATOM    705  CB  ALA    92      -9.032  -3.210   7.230  1.00 33.32           C
ATOM    706  C   ALA    92     -10.618  -1.417   7.967  1.00 49.30           C
ATOM    707  O   ALA    92     -11.691  -1.923   8.294  1.00 62.43           O
ATOM    708  N   SER    93     -10.094  -0.367   8.590  1.00 48.60           N
ATOM    709  CA  SER    93     -10.744   0.231   9.751  1.00 49.77           C
ATOM    710  CB  SER    93      -9.705   0.868  10.683  1.00 54.51           C
ATOM    711  OG  SER    93      -9.043   1.956  10.059  1.00 51.65           O
ATOM    712  C   SER    93     -11.811   1.251   9.351  1.00 53.89           C
ATOM    713  O   SER    93     -12.320   1.995  10.189  1.00 54.84           O
ATOM    714  N   LEU    94     -12.148   1.276   8.066  1.00 55.73           N
ATOM    715  CA  LEU    94     -13.170   2.180   7.551  1.00 48.66           C
ATOM    716  CB  LEU    94     -12.729   2.765   6.210  1.00 42.08           C
ATOM    717  CG  LEU    94     -11.468   3.615   6.262  1.00 35.36           C
ATOM    718  CD1 LEU    94     -11.105   4.100   4.870  1.00 27.43           C
ATOM    719  CD2 LEU    94     -11.684   4.780   7.217  1.00 36.03           C
ATOM    720  C   LEU    94     -14.495   1.451   7.372  1.00 48.47           C
ATOM    721  O   LEU    94     -14.514   0.230   7.178  1.00 40.01           O
ATOM    722  N   SER    95     -15.596   2.201   7.442  1.00 52.46           N
ATOM    723  CA  SER    95     -16.925   1.651   7.190  1.00 50.63           C
ATOM    724  C   SER    95     -17.159   1.596   5.690  1.00 56.42           C
ATOM    725  CB  SER    95     -18.010   2.498   7.851  1.00 50.78           C
ATOM    726  OG  SER    95     -18.616   3.374   6.917  1.00 50.30           O
ATOM    727  O   SER    95     -16.715   2.476   4.953  1.00 61.75           O
ATOM    728  N   SER    96     -17.871   0.568   5.244  1.00 56.64           N
ATOM    729  CA  SER    96     -18.013   0.286   3.819  1.00 55.58           C
ATOM    730  C   SER    96     -18.658   1.406   2.998  1.00 53.11           C
ATOM    731  CB  SER    96     -18.778  -1.023   3.621  1.00 62.80           C
ATOM    732  OG  SER    96     -19.796  -1.164   4.596  1.00 71.52           O
ATOM    733  O   SER    96     -18.521   1.436   1.772  1.00 47.25           O
ATOM    734  N   ASP    97     -19.340   2.330   3.669  1.00 55.96           N
ATOM    735  CA  ASP    97     -20.147   3.327   2.969  1.00 61.79           C
ATOM    736  C   ASP    97     -19.734   4.777   3.230  1.00 59.32           C
ATOM    737  CB  ASP    97     -21.625   3.146   3.328  1.00 72.30           C
ATOM    738  CG  ASP    97     -22.550   3.818   2.334  1.00 80.18           C
ATOM    739  OD1 ASP    97     -22.475   3.476   1.134  1.00 79.71           O
ATOM    740  OD2 ASP    97     -23.353   4.681   2.753  1.00 83.47           O
ATOM    741  O   ASP    97     -20.390   5.706   2.756  1.00 58.99           O
ATOM    742  N   CYS    98     -18.658   4.981   3.982  1.00 56.40           N
ATOM    743  CA  CYS    98     -18.234   6.340   4.303  1.00 47.18           C
ATOM    744  C   CYS    98     -17.609   7.024   3.093  1.00 41.73           C
ATOM    745  CB  CYS    98     -17.273   6.357   5.491  1.00 46.59           C
ATOM    746  SG  CYS    98     -15.637   5.727   5.117  1.00 45.29           S
ATOM    747  O   CYS    98     -17.382   6.397   2.057  1.00 37.79           O
ATOM    748  N   PHE    99     -17.336   8.315   3.233  1.00 41.90           N
ATOM    749  CA  PHE    99     -16.868   9.119   2.113  1.00 41.40           C
ATOM    750  CB  PHE    99     -16.879  10.598   2.481  1.00 36.21           C
ATOM    751  CG  PHE    99     -16.312  11.488   1.417  1.00 34.62           C
ATOM    752  CD1 PHE    99     -17.057  11.801   0.294  1.00 32.58           C
ATOM    753  CE1 PHE    99     -16.541  12.625  -0.685  1.00 37.40           C
ATOM    754  CZ  PHE    99     -15.265  13.148  -0.549  1.00 40.15           C
ATOM    755  CE2 PHE    99     -14.509  12.846   0.571  1.00 31.64           C
ATOM    756  CD2 PHE    99     -15.034  12.018   1.546  1.00 30.29           C
ATOM    757  C   PHE    99     -15.480   8.705   1.636  1.00 42.36           C
ATOM    758  O   PHE    99     -15.273   8.459   0.448  1.00 44.78           O
ATOM    759  N   LEU   100     -14.535   8.637   2.566  1.00 34.66           N
ATOM    760  CA  LEU   100     -13.169   8.226   2.259  1.00 35.24           C
ATOM    761  CB  LEU   100     -12.367   8.110   3.552  1.00 38.29           C
ATOM    762  CG  LEU   100     -10.927   7.639   3.387  1.00 36.62           C
ATOM    763  CD1 LEU   100     -10.255   8.408   2.258  1.00 34.17           C
ATOM    764  CD2 LEU   100     -10.178   7.813   4.692  1.00 36.62           C
ATOM    765  C   LEU   100     -13.117   6.900   1.493  1.00 34.33           C
ATOM    766  O   LEU   100     -12.376   6.755   0.520  1.00 34.59           O
ATOM    767  N   THR   101     -13.912   5.940   1.952  1.00 38.35           N
ATOM    768  CA  THR   101     -14.047   4.633   1.313  1.00 37.66           C
ATOM    769  CB  THR   101     -15.000   3.735   2.123  1.00 41.40           C
ATOM    770  OG1 THR   101     -14.321   3.245   3.286  1.00 40.00           O
ATOM    771  CG2 THR   101     -15.471   2.559   1.281  1.00 44.07           C
ATOM    772  C   THR   101     -14.579   4.752  -0.112  1.00 36.46           C
ATOM    773  O   THR   101     -14.073   4.110  -1.034  1.00 35.84           O
ATOM    774  N   VAL   102     -15.620   5.563  -0.278  1.00 35.16           N
ATOM    775  CA  VAL   102     -16.142   5.894  -1.597  1.00 33.01           C
ATOM    776  CB  VAL   102     -17.358   6.826  -1.492  1.00 29.72           C
ATOM    777  CG1 VAL   102     -17.696   7.412  -2.863  1.00 24.15           C
ATOM    778  CG2 VAL   102     -18.539   6.075  -0.910  1.00 26.78           C
ATOM    779  C   VAL   102     -15.080   6.582  -2.449  1.00 38.67           C
ATOM    780  O   VAL   102     -14.932   6.287  -3.633  1.00 44.93           O
ATOM    781  N   LEU   103     -14.346   7.504  -1.836  1.00 32.39           N
ATOM    782  CA  LEU   103     -13.302   8.248  -2.524  1.00 21.76           C
ATOM    783  CB  LEU   103     -12.702   9.295  -1.585  1.00 18.67           C
ATOM    784  CG  LEU   103     -11.684  10.243  -2.219  1.00 29.54           C
ATOM    785  CD1 LEU   103     -12.369  11.155  -3.225  1.00 33.17           C
ATOM    786  CD2 LEU   103     -10.969  11.053  -1.147  1.00 33.15           C
ATOM    787  C   LEU   103     -12.209   7.318  -3.059  1.00 29.60           C
ATOM    788  O   LEU   103     -11.760   7.469  -4.194  1.00 30.18           O
ATOM    789  N   LEU   104     -11.792   6.355  -2.239  1.00 34.80           N
ATOM    790  CA  LEU   104     -10.746   5.408  -2.631  1.00 37.26           C
ATOM    791  CB  LEU   104     -10.338   4.519  -1.447  1.00 31.68           C
ATOM    792  CG  LEU   104      -9.508   5.198  -0.353  1.00 31.71           C
ATOM    793  CD1 LEU   104      -9.511   4.384   0.941  1.00 25.38           C
ATOM    794  CD2 LEU   104      -8.082   5.450  -0.835  1.00 16.05           C
ATOM    795  C   LEU   104     -11.158   4.546  -3.825  1.00 32.47           C
ATOM    796  O   LEU   104     -10.351   4.270  -4.714  1.00 28.79           O
ATOM    797  N   GLY   105     -12.416   4.121  -3.840  1.00 33.19           N
ATOM    798  CA  GLY   105     -12.933   3.326  -4.937  1.00 32.37           C
ATOM    799  C   GLY   105     -12.839   4.080  -6.251  1.00 33.24           C
ATOM    800  O   GLY   105     -12.283   3.581  -7.227  1.00 35.42           O
ATOM    801  N   LYS   106     -13.382   5.292  -6.270  1.00 25.29           N
ATOM    802  CA  LYS   106     -13.349   6.124  -7.466  1.00 26.60           C
ATOM    803  C   LYS   106     -11.919   6.386  -7.925  1.00 23.49           C
ATOM    804  CB  LYS   106     -14.073   7.449  -7.212  1.00 28.36           C
ATOM    805  CG  LYS   106     -15.549   7.285  -6.949  1.00 23.75           C
ATOM    806  CD  LYS   106     -16.165   6.468  -8.058  1.00 36.12           C
ATOM    807  CE  LYS   106     -17.453   5.799  -7.621  1.00 44.68           C
ATOM    808  NZ  LYS   106     -18.068   5.065  -8.758  1.00 52.89           N
ATOM    809  O   LYS   106     -11.634   6.390  -9.121  1.00 29.67           O
ATOM    810  N   LEU   107     -11.024   6.607  -6.965  1.00 27.45           N
ATOM    811  CA  LEU   107      -9.634   6.912  -7.273  1.00 27.78           C
ATOM    812  CB  LEU   107      -8.902   7.415  -6.032  1.00 26.49           C
ATOM    813  CG  LEU   107      -9.120   8.866  -5.625  1.00 21.02           C
ATOM    814  CD1 LEU   107      -8.520   9.101  -4.249  1.00 20.09           C
ATOM    815  CD2 LEU   107      -8.500   9.805  -6.647  1.00 18.87           C
ATOM    816  C   LEU   107      -8.906   5.696  -7.827  1.00 27.48           C
ATOM    817  O   LEU   107      -8.111   5.816  -8.761  1.00 29.63           O
ATOM    818  N   GLU   108      -9.170   4.528  -7.247  1.00 24.78           N
ATOM    819  CA  GLU   108      -8.494   3.311  -7.684  1.00 33.49           C
ATOM    820  CB  GLU   108      -8.763   2.137  -6.741  1.00 30.59           C
ATOM    821  CG  GLU   108      -7.745   2.007  -5.626  1.00 34.19           C
ATOM    822  CD  GLU   108      -7.806   0.656  -4.941  1.00 42.70           C
ATOM    823  OE1 GLU   108      -8.359  -0.295  -5.543  1.00 43.25           O
ATOM    824  OE2 GLU   108      -7.297   0.549  -3.804  1.00 37.85           O
ATOM    825  C   GLU   108      -8.888   2.950  -9.106  1.00 37.32           C
ATOM    826  O   GLU   108      -8.174   2.203  -9.777  1.00 40.34           O
ATOM    827  N   LYS   109     -10.020   3.488  -9.558  1.00 27.96           N
ATOM    828  CA  LYS   109     -10.499   3.251 -10.917  1.00 26.39           C
ATOM    829  C   LYS   109      -9.851   4.188 -11.940  1.00 18.13           C
ATOM    830  CB  LYS   109     -12.026   3.373 -10.987  1.00 27.54           C
ATOM    831  CG  LYS   109     -12.787   2.140 -10.518  1.00 39.68           C
ATOM    832  CD  LYS   109     -14.001   1.886 -11.408  1.00 58.02           C
ATOM    833  CE  LYS   109     -14.878   0.764 -10.872  1.00 71.99           C
ATOM    834  NZ  LYS   109     -15.717   1.215  -9.719  1.00 82.27           N
ATOM    835  O   LYS   109      -9.703   3.835 -13.100  1.00 25.33           O
ATOM    836  N   SER   110      -9.469   5.382 -11.501  1.00 22.12           N
ATOM    837  CA  SER   110      -8.904   6.387 -12.394  1.00 22.40           C
ATOM    838  CB  SER   110      -9.524   7.765 -12.118  1.00 23.58           C
ATOM    839  OG  SER   110     -10.836   7.851 -12.651  1.00 27.93           O
ATOM    840  C   SER   110      -7.383   6.469 -12.297  1.00 28.42           C
ATOM    841  O   SER   110      -6.734   7.035 -13.183  1.00 22.84           O
ATOM    842  N   PHE   111      -6.824   5.911 -11.222  1.00 33.62           N
ATOM    843  CA  PHE   111      -5.373   5.888 -11.012  1.00 29.22           C
ATOM    844  CB  PHE   111      -4.973   6.876  -9.915  1.00 31.53           C
ATOM    845  CG  PHE   111      -5.332   8.299 -10.221  1.00 32.74           C
ATOM    846  CD1 PHE   111      -6.556   8.822  -9.817  1.00 28.97           C
ATOM    847  CE1 PHE   111      -6.892  10.137 -10.096  1.00 21.53           C
ATOM    848  CZ  PHE   111      -6.001  10.942 -10.787  1.00 22.95           C
ATOM    849  CE2 PHE   111      -4.774  10.429 -11.199  1.00 24.35           C
ATOM    850  CD2 PHE   111      -4.447   9.116 -10.912  1.00 27.86           C
ATOM    851  C   PHE   111      -4.851   4.494 -10.657  1.00 25.54           C
ATOM    852  O   PHE   111      -5.482   3.755  -9.902  1.00 27.19           O
ATOM    853  N   ASN   112      -3.682   4.154 -11.190  1.00 23.97           N
ATOM    854  CA  ASN   112      -3.085   2.834 -10.995  1.00 31.83           C
ATOM    855  CB  ASN   112      -1.892   2.642 -11.935  1.00 39.41           C
ATOM    856  CG  ASN   112      -2.288   2.637 -13.395  1.00 32.74           C
ATOM    857  OD1 ASN   112      -3.321   2.074 -13.774  1.00 29.58           O
ATOM    858  ND2 ASN   112      -1.456   3.257 -14.229  1.00 25.56           N
ATOM    859  C   ASN   112      -2.621   2.569  -9.570  1.00 27.70           C
ATOM    860  O   ASN   112      -2.783   1.465  -9.052  1.00 36.92           O
ATOM    861  N   SER   113      -2.017   3.581  -8.955  1.00 27.06           N
ATOM    862  CA  SER   113      -1.507   3.470  -7.592  1.00 28.53           C
ATOM    863  CB  SER   113       0.005   3.727  -7.555  1.00 36.90           C
ATOM    864  OG  SER   113       0.738   2.519  -7.673  1.00 53.38           O
ATOM    865  C   SER   113      -2.212   4.441  -6.666  1.00 24.37           C
ATOM    866  O   SER   113      -1.966   5.644  -6.718  1.00 29.81           O
ATOM    867  N   VAL   114      -3.088   3.911  -5.819  1.00 30.18           N
ATOM    868  CA  VAL   114      -3.810   4.722  -4.847  1.00 29.32           C
ATOM    869  CB  VAL   114      -5.326   4.729  -5.129  1.00 30.16           C
ATOM    870  CG1 VAL   114      -6.069   5.530  -4.054  1.00 29.59           C
ATOM    871  CG2 VAL   114      -5.604   5.285  -6.515  1.00 29.04           C
ATOM    872  C   VAL   114      -3.564   4.186  -3.441  1.00 22.61           C
ATOM    873  O   VAL   114      -3.823   3.018  -3.170  1.00 27.56           O
ATOM    874  N   HIS   115      -3.074   5.047  -2.552  1.00 24.69           N
ATOM    875  CA  HIS   115      -2.744   4.638  -1.187  1.00 28.03           C
ATOM    876  CB  HIS   115      -1.233   4.452  -1.051  1.00 24.44           C
ATOM    877  CG  HIS   115      -0.667   3.516  -2.067  1.00 24.97           C
ATOM    878  ND1 HIS   115      -0.853   2.151  -2.004  1.00 36.98           N
ATOM    879  CE1 HIS   115      -0.262   1.577  -3.036  1.00 37.25           C
ATOM    880  NE2 HIS   115       0.295   2.523  -3.773  1.00 28.51           N
ATOM    881  CD2 HIS   115       0.052   3.744  -3.192  1.00 21.83           C
ATOM    882  C   HIS   115      -3.261   5.580  -0.110  1.00 24.77           C
ATOM    883  O   HIS   115      -3.231   6.800  -0.261  1.00 24.97           O
ATOM    884  N   LEU   116      -3.739   4.992   0.981  1.00 22.93           N
ATOM    885  CA  LEU   116      -4.151   5.751   2.148  1.00 23.17           C
ATOM    886  CB  LEU   116      -5.210   4.967   2.928  1.00 22.44           C
ATOM    887  CG  LEU   116      -5.790   5.538   4.227  1.00 33.60           C
ATOM    888  CD1 LEU   116      -6.558   6.831   3.978  1.00 35.46           C
ATOM    889  CD2 LEU   116      -6.696   4.509   4.891  1.00 34.38           C
ATOM    890  C   LEU   116      -2.926   5.991   3.024  1.00 27.32           C
ATOM    891  O   LEU   116      -2.084   5.110   3.176  1.00 28.52           O
ATOM    892  N   LEU   117      -2.821   7.180   3.601  1.00 20.78           N
ATOM    893  CA  LEU   117      -1.708   7.467   4.490  1.00 22.95           C
ATOM    894  CB  LEU   117      -1.441   8.971   4.573  1.00 31.00           C
ATOM    895  CG  LEU   117      -0.196   9.387   5.365  1.00 28.22           C
ATOM    896  CD1 LEU   117       1.073   8.961   4.650  1.00 25.66           C
ATOM    897  CD2 LEU   117      -0.200  10.885   5.593  1.00 31.88           C
ATOM    898  C   LEU   117      -1.988   6.892   5.875  1.00 24.73           C
ATOM    899  O   LEU   117      -3.001   7.206   6.495  1.00 18.25           O
ATOM    900  N   ALA   118      -1.086   6.039   6.347  1.00 30.02           N
ATOM    901  CA  ALA   118      -1.235   5.397   7.643  1.00 28.97           C
ATOM    902  CB  ALA   118      -0.176   4.317   7.809  1.00 28.11           C
ATOM    903  C   ALA   118      -1.142   6.426   8.772  1.00 29.45           C
ATOM    904  O   ALA   118      -0.091   7.029   8.988  1.00 36.88           O
ATOM    905  N   GLY   119      -2.247   6.632   9.479  1.00 26.95           N
ATOM    906  CA  GLY   119      -2.270   7.547  10.608  1.00 22.59           C
ATOM    907  C   GLY   119      -2.792   8.930  10.267  1.00 21.17           C
ATOM    908  O   GLY   119      -3.057   9.739  11.151  1.00 30.70           O
ATOM    909  N   GLY   120      -2.931   9.208   8.977  1.00 19.11           N
ATOM    910  CA  GLY   120      -3.505  10.463   8.534  1.00 19.09           C
ATOM    911  C   GLY   120      -2.672  11.682   8.872  1.00 25.59           C
ATOM    912  O   GLY   120      -1.493  11.575   9.217  1.00 27.42           O
ATOM    913  N   PHE   121      -3.297  12.851   8.767  1.00 31.24           N
ATOM    914  CA  PHE   121      -2.609  14.112   8.999  1.00 33.12           C
ATOM    915  CB  PHE   121      -3.539  15.304   8.727  1.00 34.46           C
ATOM    916  CG  PHE   121      -2.867  16.635   8.891  1.00 34.02           C
ATOM    917  CD1 PHE   121      -1.989  17.104   7.925  1.00 26.81           C
ATOM    918  CE1 PHE   121      -1.356  18.318   8.078  1.00 21.42           C
ATOM    919  CZ  PHE   121      -1.586  19.078   9.208  1.00 24.76           C
ATOM    920  CE2 PHE   121      -2.454  18.622  10.181  1.00 26.53           C
ATOM    921  CD2 PHE   121      -3.089  17.404  10.021  1.00 32.65           C
ATOM    922  C   PHE   121      -2.058  14.178  10.419  1.00 32.13           C
ATOM    923  O   PHE   121      -1.028  14.804  10.663  1.00 26.92           O
ATOM    924  N   ALA   122      -2.757  13.521  11.344  1.00 36.55           N
ATOM    925  CA  ALA   122      -2.364  13.475  12.751  1.00 39.32           C
ATOM    926  CB  ALA   122      -3.326  12.594  13.546  1.00 42.38           C
ATOM    927  C   ALA   122      -0.936  12.980  12.925  1.00 40.07           C
ATOM    928  O   ALA   122      -0.118  13.634  13.573  1.00 47.62           O
ATOM    929  N   GLU   123      -0.637  11.819  12.356  1.00 39.23           N
ATOM    930  CA  GLU   123       0.718  11.301  12.432  1.00 34.22           C
ATOM    931  CB  GLU   123       0.788   9.824  12.062  1.00 38.22           C
ATOM    932  CG  GLU   123       2.210   9.299  12.072  1.00 58.96           C
ATOM    933  CD  GLU   123       2.283   7.791  12.133  1.00 79.25           C
ATOM    934  OE1 GLU   123       1.242   7.160  12.412  1.00 85.83           O
ATOM    935  OE2 GLU   123       3.383   7.239  11.907  1.00 86.33           O
ATOM    936  C   GLU   123       1.673  12.098  11.560  1.00 38.00           C
ATOM    937  O   GLU   123       2.773  12.424  11.993  1.00 48.50           O
ATOM    938  N   PHE   124       1.266  12.422  10.336  1.00 35.64           N
ATOM    939  CA  PHE   124       2.173  13.151   9.454  1.00 33.86           C
ATOM    940  CB  PHE   124       1.583  13.379   8.066  1.00 27.80           C
ATOM    941  CG  PHE   124       2.552  14.028   7.116  1.00 30.57           C
ATOM    942  CD1 PHE   124       3.429  13.258   6.365  1.00 27.33           C
ATOM    943  CE1 PHE   124       4.335  13.852   5.498  1.00 27.90           C
ATOM    944  CZ  PHE   124       4.382  15.231   5.384  1.00 28.09           C
ATOM    945  CE2 PHE   124       3.519  16.009   6.135  1.00 34.46           C
ATOM    946  CD2 PHE   124       2.615  15.406   7.002  1.00 31.74           C
ATOM    947  C   PHE   124       2.614  14.491  10.040  1.00 35.06           C
ATOM    948  O   PHE   124       3.802  14.819  10.037  1.00 32.65           O
ATOM    949  N   SER   125       1.652  15.268  10.523  1.00 32.61           N
ATOM    950  CA  SER   125       1.959  16.560  11.115  1.00 37.08           C
ATOM    951  C   SER   125       2.790  16.394  12.394  1.00 45.32           C
ATOM    952  CB  SER   125       0.674  17.339  11.396  1.00 32.14           C
ATOM    953  OG  SER   125      -0.150  16.649  12.316  1.00 39.87           O
ATOM    954  O   SER   125       3.545  17.290  12.779  1.00 40.44           O
ATOM    955  N   ARG   126       2.653  15.235  13.034  1.00 49.39           N
ATOM    956  CA  ARG   126       3.380  14.923  14.261  1.00 47.74           C
ATOM    957  C   ARG   126       4.867  14.679  13.992  1.00 46.97           C
ATOM    958  CB  ARG   126       2.751  13.702  14.945  1.00 54.45           C
ATOM    959  CG  ARG   126       3.395  13.301  16.268  1.00 69.39           C
ATOM    960  CD  ARG   126       2.634  12.166  16.952  1.00 76.01           C
ATOM    961  NE  ARG   126       2.514  10.989  16.093  1.00 84.08           N
ATOM    962  CZ  ARG   126       3.371   9.972  16.086  1.00 87.77           C
ATOM    963  NH1 ARG   126       4.420   9.976  16.898  1.00 87.98           N
ATOM    964  NH2 ARG   126       3.178   8.948  15.266  1.00 87.62           N
ATOM    965  O   ARG   126       5.716  14.975  14.835  1.00 46.55           O
ATOM    966  N   CYS   127       5.173  14.152  12.808  1.00 46.74           N
ATOM    967  CA  CYS   127       6.541  13.785  12.432  1.00 43.63           C
ATOM    968  CB  CYS   127       6.548  12.464  11.651  1.00 49.03           C
ATOM    969  SG  CYS   127       5.830  11.039  12.508  1.00 50.28           S
ATOM    970  C   CYS   127       7.248  14.860  11.600  1.00 40.55           C
ATOM    971  O   CYS   127       8.428  15.146  11.811  1.00 47.00           O
ATOM    972  N   PHE   128       6.530  15.438  10.644  1.00 33.20           N
ATOM    973  CA  PHE   128       7.105  16.447   9.764  1.00 27.30           C
ATOM    974  CB  PHE   128       7.208  15.914   8.341  1.00 24.79           C
ATOM    975  CG  PHE   128       8.040  14.673   8.228  1.00 34.58           C
ATOM    976  CD1 PHE   128       7.446  13.423   8.233  1.00 39.61           C
ATOM    977  CE1 PHE   128       8.218  12.272   8.133  1.00 43.30           C
ATOM    978  CZ  PHE   128       9.593  12.367   8.032  1.00 37.85           C
ATOM    979  CE2 PHE   128      10.196  13.610   8.032  1.00 32.24           C
ATOM    980  CD2 PHE   128       9.422  14.754   8.131  1.00 33.74           C
ATOM    981  C   PHE   128       6.281  17.715   9.782  1.00 34.76           C
ATOM    982  O   PHE   128       5.480  17.954   8.884  1.00 37.57           O
ATOM    983  N   PRO   129       6.476  18.534  10.819  1.00 44.79           N
ATOM    984  CA  PRO   129       5.737  19.788  10.969  1.00 41.52           C
ATOM    985  CB  PRO   129       6.122  20.254  12.380  1.00 37.72           C
ATOM    986  CG  PRO   129       6.759  19.052  13.043  1.00 40.79           C
ATOM    987  CD  PRO   129       7.405  18.305  11.936  1.00 45.11           C
ATOM    988  C   PRO   129       6.190  20.807   9.927  1.00 45.62           C
ATOM    989  O   PRO   129       5.386  21.643   9.495  1.00 42.72           O
ATOM    990  N   GLY   130       7.462  20.729   9.532  1.00 40.66           N
ATOM    991  CA  GLY   130       8.015  21.630   8.536  1.00 40.82           C
ATOM    992  C   GLY   130       7.479  21.374   7.138  1.00 42.73           C
ATOM    993  O   GLY   130       7.751  22.134   6.208  1.00 40.06           O
ATOM    994  N   LEU   131       6.702  20.304   6.992  1.00 46.45           N
ATOM    995  CA  LEU   131       6.125  19.943   5.702  1.00 38.75           C
ATOM    996  CB  LEU   131       6.449  18.487   5.372  1.00 40.26           C
ATOM    997  CG  LEU   131       7.953  18.241   5.246  1.00 41.66           C
ATOM    998  CD1 LEU   131       8.237  16.782   4.943  1.00 38.33           C
ATOM    999  CD2 LEU   131       8.553  19.156   4.181  1.00 41.19           C
ATOM   1000  C   LEU   131       4.618  20.195   5.640  1.00 31.58           C
ATOM   1001  O   LEU   131       3.929  19.700   4.746  1.00 26.81           O
ATOM   1002  N   CYS   132       4.116  20.975   6.591  1.00 38.06           N
ATOM   1003  CA  CYS   132       2.708  21.348   6.619  1.00 46.30           C
ATOM   1004  CB  CYS   132       2.057  20.898   7.932  1.00 50.21           C
ATOM   1005  SG  CYS   132       2.349  19.160   8.367  1.00 37.07           S
ATOM   1006  C   CYS   132       2.535  22.857   6.418  1.00 47.00           C
ATOM   1007  O   CYS   132       3.378  23.651   6.836  1.00 53.23           O
ATOM   1008  N   GLU   133       1.439  23.238   5.771  1.00 44.36           N
ATOM   1009  CA  GLU   133       1.173  24.631   5.441  1.00 48.73           C
ATOM   1010  C   GLU   133      -0.093  25.086   6.145  1.00 52.20           C
ATOM   1011  CB  GLU   133       1.006  24.796   3.929  1.00 53.88           C
ATOM   1012  CG  GLU   133       2.196  24.327   3.105  1.00 68.87           C
ATOM   1013  CD  GLU   133       1.926  24.361   1.606  1.00 85.09           C
ATOM   1014  OE1 GLU   133       0.743  24.482   1.208  1.00 87.01           O
ATOM   1015  OE2 GLU   133       2.899  24.263   0.824  1.00 92.18           O
ATOM   1016  O   GLU   133      -1.108  24.398   6.105  1.00 51.09           O
ATOM   1017  N   GLY   134      -0.034  26.251   6.781  1.00 65.46           N
ATOM   1018  CA  GLY   134      -1.159  26.755   7.548  1.00 68.23           C
ATOM   1019  C   GLY   134      -1.799  27.989   6.946  1.00 65.42           C
ATOM   1020  O   GLY   134      -2.452  28.761   7.650  1.00 62.45           O
END
