
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  164 ( 1325),  selected  164 , name 2p5r_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2p5r_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     6_A      E       1           -
LGA    K     7_A      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    -       -      Q       6           -
LGA    -       -      S       7           -
LGA    N     8_A      M       8          3.476
LGA    P     9_A      I       9          1.892
LGA    E    10_A      N      10          1.901
LGA    S    11_A      S      11          0.960
LGA    V    12_A      F      12          0.684
LGA    H    13_A      Y      13          1.576
LGA    D    14_A      A      14          1.362
LGA    F    15_A      F      15          0.380
LGA    T    16_A      E      16          0.398
LGA    V    17_A      V      17          0.358
LGA    K    18_A      K      18          0.415
LGA    D    19_A      D      19          0.769
LGA    A    20_A      A      20          0.513
LGA    K    21_A      K      21          0.786
LGA    E    22_A      G      22          0.927
LGA    N    23_A      R      23          1.215
LGA    D    24_A      T      24          1.019
LGA    V    25_A      V      25          1.164
LGA    D    26_A      S      26          0.708
LGA    L    27_A      L      27          0.898
LGA    S    28_A      E      28          0.746
LGA    I    29_A      K      29          0.696
LGA    F    30_A      Y      30          0.622
LGA    K    31_A      K      31          0.625
LGA    G    32_A      G      32          0.824
LGA    K    33_A      K      33          0.337
LGA    V    34_A      V      34          0.281
LGA    L    35_A      S      35          0.520
LGA    L    36_A      L      36          0.473
LGA    I    37_A      V      37          0.137
LGA    V    38_A      V      38          0.293
LGA    N    39_A      N      39          0.167
LGA    V    40_A      V      40          0.414
LGA    A    41_A      A      41          1.103
LGA    S    42_A      S      42          5.115
LGA    K    43_A      -       -           -
LGA    C    44_A      D      43          5.375
LGA    G    45_A      C      44           -
LGA    -       -      Q      45           -
LGA    -       -      L      46           -
LGA    M    46_A      T      47          5.219
LGA    T    47_A      D      48          2.702
LGA    N    48_A      -       -           -
LGA    S    49_A      R      49          0.413
LGA    N    50_A      N      50          0.718
LGA    Y    51_A      Y      51          0.610
LGA    A    52_A      L      52          0.372
LGA    E    53_A      G      53          0.682
LGA    M    54_A      L      54          0.631
LGA    N    55_A      K      55          0.599
LGA    Q    56_A      E      56          0.689
LGA    L    57_A      L      57          0.707
LGA    Y    58_A      H      58          0.940
LGA    E    59_A      K      59          0.917
LGA    K    60_A      E      60          0.655
LGA    Y    61_A      F      61          0.993
LGA    K    62_A      G      62          0.896
LGA    D    63_A      P      63          3.845
LGA    Q    64_A      S      64          4.912
LGA    G    65_A      H      65          0.708
LGA    L    66_A      F      66          0.758
LGA    E    67_A      S      67          0.743
LGA    I    68_A      V      68          0.984
LGA    L    69_A      L      69          0.630
LGA    A    70_A      A      70          0.312
LGA    F    71_A      F      71          0.388
LGA    P    72_A      P      72          0.379
LGA    C    73_A      C      73          0.304
LGA    N    74_A      N      74          0.577
LGA    Q    75_A      Q      75          0.483
LGA    F    76_A      F      76          0.558
LGA    G    77_A      G      77          0.694
LGA    E    78_A      E      78          1.324
LGA    E    79_A      S      79           #
LGA    E    80_A      E      80           -
LGA    P    81_A      -       -           -
LGA    G    82_A      -       -           -
LGA    T    83_A      -       -           -
LGA    N    84_A      -       -           -
LGA    D    85_A      -       -           -
LGA    Q    86_A      -       -           -
LGA    I    87_A      -       -           -
LGA    T    88_A      -       -           -
LGA    D    89_A      P      81           #
LGA    F    90_A      R      82          4.193
LGA    V    91_A      P      83          3.756
LGA    C    92_A      S      84           #
LGA    T    93_A      K      85          4.012
LGA    R    94_A      E      86          2.224
LGA    F    95_A      V      87          3.552
LGA    -       -      E      88           -
LGA    -       -      S      89           -
LGA    -       -      F      90           -
LGA    K    96_A      A      91          2.562
LGA    S    97_A      R      92          3.350
LGA    -       -      K      93           -
LGA    -       -      N      94           -
LGA    -       -      Y      95           -
LGA    -       -      G      96           -
LGA    -       -      V      97           -
LGA    E    98_A      T      98          1.525
LGA    F    99_A      F      99          1.085
LGA    P   100_A      P     100          1.017
LGA    I   101_A      I     101          0.550
LGA    F   102_A      F     102          0.561
LGA    D   103_A      H     103          0.415
LGA    K   104_A      K     104          0.484
LGA    I   105_A      I     105          0.387
LGA    D   106_A      K     106          0.862
LGA    V   107_A      I     107          1.150
LGA    N   108_A      L     108          1.222
LGA    G   109_A      G     109          1.072
LGA    E   110_A      S     110          0.971
LGA    N   111_A      E     111          1.079
LGA    A   112_A      G     112          0.826
LGA    S   113_A      E     113          0.635
LGA    P   114_A      P     114          0.313
LGA    L   115_A      A     115          1.070
LGA    Y   116_A      F     116          1.722
LGA    R   117_A      R     117          1.493
LGA    F   118_A      F     118          1.052
LGA    L   119_A      L     119          1.053
LGA    K   120_A      V     120          1.488
LGA    L   121_A      D     121          2.051
LGA    G   122_A      S     122          1.504
LGA    K   123_A      -       -           -
LGA    W   124_A      -       -           -
LGA    G   125_A      -       -           -
LGA    I   126_A      -       -           -
LGA    F   127_A      S     123          2.019
LGA    G   128_A      K     124          1.578
LGA    D   129_A      K     125          2.645
LGA    D   130_A      E     126          1.932
LGA    I   131_A      P     127          0.697
LGA    Q   132_A      R     128          1.384
LGA    W   133_A      W     129          0.571
LGA    N   134_A      N     130          0.318
LGA    F   135_A      F     131          0.153
LGA    A   136_A      W     132          0.167
LGA    K   137_A      K     133          0.288
LGA    F   138_A      Y     134          0.266
LGA    L   139_A      L     135          0.394
LGA    V   140_A      V     136          0.315
LGA    N   141_A      N     137          0.405
LGA    K   142_A      P     138          0.451
LGA    D   143_A      E     139          0.618
LGA    G   144_A      G     140          0.627
LGA    Q   145_A      Q     141          0.727
LGA    V   146_A      V     142          0.669
LGA    V   147_A      V     143          0.588
LGA    D   148_A      K     144          0.645
LGA    R   149_A      F     145          0.638
LGA    Y   150_A      W     146          0.662
LGA    Y   151_A      R     147          0.616
LGA    P   152_A      P     148          1.256
LGA    T   153_A      E     149          0.956
LGA    T   154_A      E     150          1.116
LGA    S   155_A      P     151          2.329
LGA    P   156_A      I     152          3.086
LGA    L   157_A      E     153          3.859
LGA    S   158_A      V     154          2.235
LGA    L   159_A      I     155          0.801
LGA    E   160_A      R     156          0.787
LGA    R   161_A      P     157          0.611
LGA    D   162_A      D     158          0.344
LGA    I   163_A      I     159          0.407
LGA    K   164_A      A     160          1.123
LGA    Q   165_A      A     161          1.285
LGA    L   166_A      L     162          0.988
LGA    L   167_A      V     163          0.971
LGA    E   168_A      R     164          1.766
LGA    I   169_A      Q     165          6.037
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  164  174    5.0    143    1.68    40.56     77.380     8.031

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.918587 * X  +   0.358286 * Y  +   0.166822 * Z  +  35.925163
  Y_new =   0.087111 * X  +  -0.595265 * Y  +   0.798794 * Z  + 116.584206
  Z_new =   0.385500 * X  +  -0.719229 * Y  +  -0.578013 * Z  +  30.960846 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.247763    0.893830  [ DEG:  -128.7873     51.2127 ]
  Theta =  -0.395750   -2.745843  [ DEG:   -22.6748   -157.3252 ]
  Phi   =   0.094548   -3.047044  [ DEG:     5.4172   -174.5828 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p5r_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p5r_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  164  174   5.0  143   1.68   40.56  77.380
REMARK  ---------------------------------------------------------- 
MOLECULE 2p5r_A
HEADER    OXIDOREDUCTASE                          16-MAR-07   2P5R              
TITLE     CRYSTAL STRUCTURE OF THE POPLAR GLUTATHIONE PEROXIDASE 5 IN           
TITLE    2 THE OXIDIZED FORM                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLUTATHIONE PEROXIDASE 5;                                  
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 1.11.1.-;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: POPULUS TRICHOCARPA X POPULUS                   
SOURCE   3 DELTOIDES;                                                           
SOURCE   4 GENE: PTGPX5;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3) PSBET;                          
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET-3D                                    
KEYWDS    THIOREDOXIN FOLD                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.S.KOH,C.DIDIERJEAN,N.NAVROT,S.PANJIKAR,G.MULLIERT,                  
AUTHOR   2 N.ROUHIER,J.-P.JACQUOT,A.AUBRY,O.SHAWKATALY,C.CORBIER                
REVDAT   1   24-JUL-07 2P5R    0                                                
JRNL        AUTH   C.S.KOH,C.DIDIERJEAN,N.NAVROT,S.PANJIKAR,                    
JRNL        AUTH 2 G.MULLIERT,N.ROUHIER,J.P.JACQUOT,A.AUBRY,                    
JRNL        AUTH 3 O.SHAWKATALY,C.CORBIER                                       
JRNL        TITL   CRYSTAL STRUCTURES OF A POPLAR THIOREDOXIN                   
JRNL        TITL 2 PEROXIDASE THAT EXHIBITS THE STRUCTURE OF                    
JRNL        TITL 3 GLUTATHIONE PEROXIDASES: INSIGHTS INTO                       
JRNL        TITL 4 REDOX-DRIVEN CONFORMATIONAL CHANGES.                         
JRNL        REF    J.MOL.BIOL.                   V. 370   512 2007              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.45 ANGSTROMS.                                          
DBREF  2P5R A    1   170  UNP    A3FNZ8   A3FNZ8_9ROSI     1    170             
DBREF  2P5R B    1   170  UNP    A3FNZ8   A3FNZ8_9ROSI     1    170             
SEQRES   1 A  170  MET ALA THR GLN THR SER LYS ASN PRO GLU SER VAL HIS          
SEQRES   2 A  170  ASP PHE THR VAL LYS ASP ALA LYS GLU ASN ASP VAL ASP          
SEQRES   3 A  170  LEU SER ILE PHE LYS GLY LYS VAL LEU LEU ILE VAL ASN          
SEQRES   4 A  170  VAL ALA SER LYS CYS GLY MET THR ASN SER ASN TYR ALA          
SEQRES   5 A  170  GLU MET ASN GLN LEU TYR GLU LYS TYR LYS ASP GLN GLY          
SEQRES   6 A  170  LEU GLU ILE LEU ALA PHE PRO CYS ASN GLN PHE GLY GLU          
SEQRES   7 A  170  GLU GLU PRO GLY THR ASN ASP GLN ILE THR ASP PHE VAL          
SEQRES   8 A  170  CYS THR ARG PHE LYS SER GLU PHE PRO ILE PHE ASP LYS          
SEQRES   9 A  170  ILE ASP VAL ASN GLY GLU ASN ALA SER PRO LEU TYR ARG          
SEQRES  10 A  170  PHE LEU LYS LEU GLY LYS TRP GLY ILE PHE GLY ASP ASP          
SEQRES  11 A  170  ILE GLN TRP ASN PHE ALA LYS PHE LEU VAL ASN LYS ASP          
SEQRES  12 A  170  GLY GLN VAL VAL ASP ARG TYR TYR PRO THR THR SER PRO          
SEQRES  13 A  170  LEU SER LEU GLU ARG ASP ILE LYS GLN LEU LEU GLU ILE          
SEQRES  14 A  170  SER                                                          
SEQRES   1 B  170  MET ALA THR GLN THR SER LYS ASN PRO GLU SER VAL HIS          
SEQRES   2 B  170  ASP PHE THR VAL LYS ASP ALA LYS GLU ASN ASP VAL ASP          
SEQRES   3 B  170  LEU SER ILE PHE LYS GLY LYS VAL LEU LEU ILE VAL ASN          
SEQRES   4 B  170  VAL ALA SER LYS CYS GLY MET THR ASN SER ASN TYR ALA          
SEQRES   5 B  170  GLU MET ASN GLN LEU TYR GLU LYS TYR LYS ASP GLN GLY          
SEQRES   6 B  170  LEU GLU ILE LEU ALA PHE PRO CYS ASN GLN PHE GLY GLU          
SEQRES   7 B  170  GLU GLU PRO GLY THR ASN ASP GLN ILE THR ASP PHE VAL          
SEQRES   8 B  170  CYS THR ARG PHE LYS SER GLU PHE PRO ILE PHE ASP LYS          
SEQRES   9 B  170  ILE ASP VAL ASN GLY GLU ASN ALA SER PRO LEU TYR ARG          
SEQRES  10 B  170  PHE LEU LYS LEU GLY LYS TRP GLY ILE PHE GLY ASP ASP          
SEQRES  11 B  170  ILE GLN TRP ASN PHE ALA LYS PHE LEU VAL ASN LYS ASP          
SEQRES  12 B  170  GLY GLN VAL VAL ASP ARG TYR TYR PRO THR THR SER PRO          
SEQRES  13 B  170  LEU SER LEU GLU ARG ASP ILE LYS GLN LEU LEU GLU ILE          
SEQRES  14 B  170  SER                                                          
HET     CA    301       1                                                       
HET     CA    302       1                                                       
HET     CA    303       1                                                       
HET     CA    304       1                                                       
HET     CA    305       1                                                       
HETNAM      CA CALCIUM ION                                                      
FORMUL   3   CA    5(CA 2+)                                                     
FORMUL   8  HOH   *224(H2 O)                                                    
CRYST1   71.580   71.580  117.820  90.00  90.00 120.00 P 31 2 1     12          
ATOM      1  N   SER A   6      42.091 108.610 -11.271  1.00 68.58           N  
ATOM      2  CA  SER A   6      41.599 107.981 -10.010  1.00 68.48           C  
ATOM      3  C   SER A   6      40.169 107.461 -10.177  1.00 68.07           C  
ATOM      4  O   SER A   6      39.343 107.587  -9.270  1.00 68.02           O  
ATOM      5  CB  SER A   6      41.654 108.997  -8.863  1.00 69.23           C  
ATOM      6  OG  SER A   6      41.351 108.390  -7.617  1.00 70.08           O  
ATOM      7  N   LYS A   7      39.889 106.879 -11.344  1.00 67.01           N  
ATOM      8  CA  LYS A   7      38.569 106.332 -11.653  1.00 65.00           C  
ATOM      9  C   LYS A   7      38.059 105.452 -10.516  1.00 63.00           C  
ATOM     10  O   LYS A   7      36.962 105.673  -9.989  1.00 63.64           O  
ATOM     11  CB  LYS A   7      38.629 105.527 -12.956  1.00 66.43           C  
ATOM     12  CG  LYS A   7      37.325 104.839 -13.353  1.00 69.03           C  
ATOM     13  CD  LYS A   7      37.069 103.572 -12.544  1.00 70.22           C  
ATOM     14  CE  LYS A   7      35.772 102.906 -12.961  1.00 71.03           C  
ATOM     15  NZ  LYS A   7      34.621 103.827 -12.779  1.00 72.89           N  
ATOM     16  N   ASN A   8      38.853 104.452 -10.147  1.00 58.94           N  
ATOM     17  CA  ASN A   8      38.484 103.549  -9.068  1.00 54.94           C  
ATOM     18  C   ASN A   8      38.680 104.236  -7.716  1.00 51.46           C  
ATOM     19  O   ASN A   8      39.762 104.738  -7.409  1.00 51.65           O  
ATOM     20  CB  ASN A   8      39.315 102.272  -9.147  1.00 56.18           C  
ATOM     21  CG  ASN A   8      38.457 101.040  -9.361  1.00 58.21           C  
ATOM     22  OD1 ASN A   8      37.589 101.022 -10.239  1.00 58.79           O  
ATOM     23  ND2 ASN A   8      38.696  99.999  -8.562  1.00 57.25           N  
ATOM     24  N   PRO A   9      37.627 104.254  -6.886  1.00 47.20           N  
ATOM     25  CA  PRO A   9      37.652 104.879  -5.564  1.00 44.05           C  
ATOM     26  C   PRO A   9      38.753 104.380  -4.652  1.00 41.63           C  
ATOM     27  O   PRO A   9      38.923 103.178  -4.471  1.00 42.49           O  
ATOM     28  CB  PRO A   9      36.266 104.572  -5.017  1.00 44.49           C  
ATOM     29  CG  PRO A   9      35.950 103.261  -5.652  1.00 46.01           C  
ATOM     30  CD  PRO A   9      36.386 103.484  -7.068  1.00 45.70           C  
ATOM     31  N   GLU A  10      39.500 105.319  -4.084  1.00 37.81           N  
ATOM     32  CA  GLU A  10      40.582 105.000  -3.174  1.00 37.24           C  
ATOM     33  C   GLU A  10      40.149 105.303  -1.753  1.00 36.09           C  
ATOM     34  O   GLU A  10      40.713 104.769  -0.804  1.00 38.01           O  
ATOM     35  CB  GLU A  10      41.820 105.836  -3.492  1.00 39.37           C  
ATOM     36  CG  GLU A  10      42.290 105.746  -4.926  1.00 45.74           C  
ATOM     37  CD  GLU A  10      43.526 106.589  -5.185  1.00 47.34           C  
ATOM     38  OE1 GLU A  10      43.853 106.800  -6.365  1.00 47.89           O  
ATOM     39  OE2 GLU A  10      44.171 107.035  -4.209  1.00 50.58           O  
ATOM     40  N   SER A  11      39.154 106.174  -1.605  1.00 34.13           N  
ATOM     41  CA  SER A  11      38.671 106.545  -0.281  1.00 30.97           C  
ATOM     42  C   SER A  11      37.194 106.930  -0.231  1.00 27.95           C  
ATOM     43  O   SER A  11      36.523 107.083  -1.250  1.00 28.23           O  
ATOM     44  CB  SER A  11      39.485 107.713   0.271  1.00 30.31           C  
ATOM     45  OG  SER A  11      39.021 108.936  -0.272  1.00 33.25           O  
ATOM     46  N   VAL A  12      36.711 107.097   0.989  1.00 25.08           N  
ATOM     47  CA  VAL A  12      35.339 107.477   1.241  1.00 23.37           C  
ATOM     48  C   VAL A  12      35.076 108.850   0.636  1.00 24.43           C  
ATOM     49  O   VAL A  12      33.939 109.185   0.306  1.00 24.59           O  
ATOM     50  CB  VAL A  12      35.075 107.487   2.761  1.00 20.34           C  
ATOM     51  CG1 VAL A  12      33.850 108.310   3.097  1.00 20.01           C  
ATOM     52  CG2 VAL A  12      34.901 106.059   3.236  1.00 17.63           C  
ATOM     53  N   HIS A  13      36.138 109.634   0.480  1.00 24.45           N  
ATOM     54  CA  HIS A  13      36.022 110.966  -0.091  1.00 25.32           C  
ATOM     55  C   HIS A  13      35.715 110.879  -1.581  1.00 25.33           C  
ATOM     56  O   HIS A  13      35.280 111.841  -2.181  1.00 26.56           O  
ATOM     57  CB  HIS A  13      37.322 111.748   0.124  1.00 24.84           C  
ATOM     58  CG  HIS A  13      37.651 111.982   1.565  1.00 26.88           C  
ATOM     59  ND1 HIS A  13      38.931 112.239   2.004  1.00 27.58           N  
ATOM     60  CD2 HIS A  13      36.869 111.971   2.671  1.00 25.26           C  
ATOM     61  CE1 HIS A  13      38.926 112.371   3.318  1.00 24.45           C  
ATOM     62  NE2 HIS A  13      37.688 112.212   3.749  1.00 23.96           N  
ATOM     63  N   ASP A  14      35.928 109.718  -2.182  1.00 25.51           N  
ATOM     64  CA  ASP A  14      35.660 109.591  -3.601  1.00 26.13           C  
ATOM     65  C   ASP A  14      34.211 109.250  -3.931  1.00 27.28           C  
ATOM     66  O   ASP A  14      33.905 108.798  -5.039  1.00 25.89           O  
ATOM     67  CB  ASP A  14      36.616 108.568  -4.207  1.00 25.60           C  
ATOM     68  CG  ASP A  14      38.050 109.025  -4.131  1.00 27.30           C  
ATOM     69  OD1 ASP A  14      38.288 110.216  -4.399  1.00 28.49           O  
ATOM     70  OD2 ASP A  14      38.935 108.217  -3.807  1.00 29.97           O  
ATOM     71  N   PHE A  15      33.320 109.487  -2.969  1.00 27.32           N  
ATOM     72  CA  PHE A  15      31.902 109.207  -3.151  1.00 28.58           C  
ATOM     73  C   PHE A  15      31.003 110.422  -2.975  1.00 30.03           C  
ATOM     74  O   PHE A  15      31.286 111.321  -2.185  1.00 31.94           O  
ATOM     75  CB  PHE A  15      31.440 108.115  -2.186  1.00 26.20           C  
ATOM     76  CG  PHE A  15      31.997 106.777  -2.498  1.00 25.23           C  
ATOM     77  CD1 PHE A  15      33.094 106.288  -1.801  1.00 24.76           C  
ATOM     78  CD2 PHE A  15      31.460 106.018  -3.533  1.00 23.58           C  
ATOM     79  CE1 PHE A  15      33.653 105.058  -2.139  1.00 25.56           C  
ATOM     80  CE2 PHE A  15      32.013 104.791  -3.876  1.00 22.65           C  
ATOM     81  CZ  PHE A  15      33.111 104.309  -3.180  1.00 23.80           C  
ATOM     82  N   THR A  16      29.911 110.428  -3.727  1.00 30.41           N  
ATOM     83  CA  THR A  16      28.930 111.492  -3.658  1.00 31.96           C  
ATOM     84  C   THR A  16      27.598 110.829  -3.338  1.00 31.70           C  
ATOM     85  O   THR A  16      27.174 109.899  -4.024  1.00 33.93           O  
ATOM     86  CB  THR A  16      28.858 112.266  -4.985  1.00 30.56           C  
ATOM     87  OG1 THR A  16      30.077 112.995  -5.158  1.00 34.43           O  
ATOM     88  CG2 THR A  16      27.691 113.248  -4.982  1.00 31.84           C  
ATOM     89  N   VAL A  17      26.950 111.294  -2.280  1.00 30.30           N  
ATOM     90  CA  VAL A  17      25.684 110.711  -1.859  1.00 29.04           C  
ATOM     91  C   VAL A  17      24.610 111.774  -1.778  1.00 29.29           C  
ATOM     92  O   VAL A  17      24.910 112.958  -1.653  1.00 30.25           O  
ATOM     93  CB  VAL A  17      25.832 110.048  -0.474  1.00 29.17           C  
ATOM     94  CG1 VAL A  17      26.978 109.051  -0.500  1.00 26.76           C  
ATOM     95  CG2 VAL A  17      26.078 111.109   0.594  1.00 26.12           C  
ATOM     96  N   LYS A  18      23.355 111.352  -1.850  1.00 30.56           N  
ATOM     97  CA  LYS A  18      22.248 112.297  -1.772  1.00 31.65           C  
ATOM     98  C   LYS A  18      21.899 112.531  -0.308  1.00 31.49           C  
ATOM     99  O   LYS A  18      21.982 111.618   0.504  1.00 31.44           O  
ATOM    100  CB  LYS A  18      21.013 111.745  -2.484  1.00 33.19           C  
ATOM    101  CG  LYS A  18      21.181 111.442  -3.954  1.00 35.50           C  
ATOM    102  CD  LYS A  18      21.043 112.677  -4.800  1.00 38.88           C  
ATOM    103  CE  LYS A  18      20.992 112.307  -6.268  1.00 41.39           C  
ATOM    104  NZ  LYS A  18      20.980 113.521  -7.133  1.00 46.08           N  
ATOM    105  N   ASP A  19      21.524 113.757   0.034  1.00 32.89           N  
ATOM    106  CA  ASP A  19      21.130 114.050   1.400  1.00 32.48           C  
ATOM    107  C   ASP A  19      19.615 113.951   1.464  1.00 33.68           C  
ATOM    108  O   ASP A  19      18.962 113.702   0.451  1.00 29.97           O  
ATOM    109  CB  ASP A  19      21.607 115.442   1.842  1.00 33.22           C  
ATOM    110  CG  ASP A  19      21.033 116.577   1.003  1.00 34.27           C  
ATOM    111  OD1 ASP A  19      21.456 117.727   1.240  1.00 36.65           O  
ATOM    112  OD2 ASP A  19      20.175 116.345   0.124  1.00 32.81           O  
ATOM    113  N   ALA A  20      19.067 114.132   2.661  1.00 37.41           N  
ATOM    114  CA  ALA A  20      17.631 114.049   2.879  1.00 39.88           C  
ATOM    115  C   ALA A  20      16.825 114.798   1.827  1.00 41.61           C  
ATOM    116  O   ALA A  20      15.717 114.389   1.499  1.00 42.99           O  
ATOM    117  CB  ALA A  20      17.290 114.567   4.268  1.00 40.87           C  
ATOM    118  N   LYS A  21      17.372 115.887   1.293  1.00 43.57           N  
ATOM    119  CA  LYS A  21      16.658 116.649   0.272  1.00 46.46           C  
ATOM    120  C   LYS A  21      17.140 116.422  -1.161  1.00 47.40           C  
ATOM    121  O   LYS A  21      16.987 117.290  -2.020  1.00 48.31           O  
ATOM    122  CB  LYS A  21      16.697 118.147   0.587  1.00 47.96           C  
ATOM    123  CG  LYS A  21      18.077 118.728   0.791  1.00 50.16           C  
ATOM    124  CD  LYS A  21      18.324 119.031   2.263  1.00 54.18           C  
ATOM    125  CE  LYS A  21      17.240 119.946   2.839  1.00 55.31           C  
ATOM    126  NZ  LYS A  21      17.115 121.222   2.075  1.00 58.30           N  
ATOM    127  N   GLU A  22      17.713 115.250  -1.413  1.00 49.37           N  
ATOM    128  CA  GLU A  22      18.210 114.878  -2.738  1.00 51.26           C  
ATOM    129  C   GLU A  22      19.170 115.855  -3.426  1.00 50.32           C  
ATOM    130  O   GLU A  22      19.078 116.089  -4.630  1.00 51.24           O  
ATOM    131  CB  GLU A  22      17.026 114.562  -3.658  1.00 53.02           C  
ATOM    132  CG  GLU A  22      16.348 113.243  -3.297  1.00 56.58           C  
ATOM    133  CD  GLU A  22      15.074 112.977  -4.079  1.00 60.27           C  
ATOM    134  OE1 GLU A  22      14.535 111.855  -3.957  1.00 60.92           O  
ATOM    135  OE2 GLU A  22      14.605 113.885  -4.805  1.00 62.52           O  
ATOM    136  N   ASN A  23      20.092 116.415  -2.649  1.00 48.82           N  
ATOM    137  CA  ASN A  23      21.099 117.329  -3.176  1.00 47.75           C  
ATOM    138  C   ASN A  23      22.415 116.567  -3.068  1.00 45.60           C  
ATOM    139  O   ASN A  23      22.785 116.125  -1.987  1.00 46.02           O  
ATOM    140  CB  ASN A  23      21.173 118.606  -2.331  1.00 50.61           C  
ATOM    141  CG  ASN A  23      19.890 119.424  -2.384  1.00 53.83           C  
ATOM    142  OD1 ASN A  23      19.805 120.500  -1.792  1.00 55.06           O  
ATOM    143  ND2 ASN A  23      18.888 118.917  -3.093  1.00 55.50           N  
ATOM    144  N   ASP A  24      23.118 116.398  -4.179  1.00 43.05           N  
ATOM    145  CA  ASP A  24      24.376 115.668  -4.137  1.00 40.90           C  
ATOM    146  C   ASP A  24      25.367 116.230  -3.129  1.00 39.46           C  
ATOM    147  O   ASP A  24      25.519 117.447  -2.995  1.00 41.77           O  
ATOM    148  CB  ASP A  24      25.021 115.629  -5.519  1.00 40.77           C  
ATOM    149  CG  ASP A  24      24.222 114.807  -6.500  1.00 42.43           C  
ATOM    150  OD1 ASP A  24      23.676 113.762  -6.085  1.00 40.40           O  
ATOM    151  OD2 ASP A  24      24.150 115.196  -7.686  1.00 44.64           O  
ATOM    152  N   VAL A  25      26.036 115.330  -2.415  1.00 35.61           N  
ATOM    153  CA  VAL A  25      27.027 115.715  -1.419  1.00 31.93           C  
ATOM    154  C   VAL A  25      28.317 114.934  -1.611  1.00 28.83           C  
ATOM    155  O   VAL A  25      28.344 113.719  -1.469  1.00 27.20           O  
ATOM    156  CB  VAL A  25      26.529 115.456   0.014  1.00 32.25           C  
ATOM    157  CG1 VAL A  25      27.692 115.615   0.994  1.00 29.49           C  
ATOM    158  CG2 VAL A  25      25.407 116.420   0.360  1.00 28.92           C  
ATOM    159  N   ASP A  26      29.384 115.645  -1.939  1.00 27.50           N  
ATOM    160  CA  ASP A  26      30.676 115.019  -2.139  1.00 27.81           C  
ATOM    161  C   ASP A  26      31.368 114.828  -0.795  1.00 26.77           C  
ATOM    162  O   ASP A  26      31.622 115.798  -0.085  1.00 25.45           O  
ATOM    163  CB  ASP A  26      31.548 115.891  -3.029  1.00 27.70           C  
ATOM    164  CG  ASP A  26      32.848 115.222  -3.375  1.00 28.18           C  
ATOM    165  OD1 ASP A  26      33.507 114.697  -2.461  1.00 28.24           O  
ATOM    166  OD2 ASP A  26      33.212 115.212  -4.555  1.00 29.18           O  
ATOM    167  N   LEU A  27      31.702 113.591  -0.453  1.00 25.53           N  
ATOM    168  CA  LEU A  27      32.335 113.348   0.839  1.00 26.47           C  
ATOM    169  C   LEU A  27      33.676 114.053   1.043  1.00 26.29           C  
ATOM    170  O   LEU A  27      34.201 114.081   2.161  1.00 24.78           O  
ATOM    171  CB  LEU A  27      32.463 111.843   1.094  1.00 25.86           C  
ATOM    172  CG  LEU A  27      31.111 111.113   1.141  1.00 26.67           C  
ATOM    173  CD1 LEU A  27      31.288 109.814   1.882  1.00 28.42           C  
ATOM    174  CD2 LEU A  27      30.063 111.949   1.853  1.00 24.17           C  
ATOM    175  N   SER A  28      34.214 114.636  -0.029  1.00 25.46           N  
ATOM    176  CA  SER A  28      35.470 115.379   0.055  1.00 24.89           C  
ATOM    177  C   SER A  28      35.353 116.578   0.996  1.00 23.63           C  
ATOM    178  O   SER A  28      36.337 116.990   1.605  1.00 24.87           O  
ATOM    179  CB  SER A  28      35.913 115.865  -1.330  1.00 23.92           C  
ATOM    180  OG  SER A  28      36.585 114.839  -2.035  1.00 27.23           O  
ATOM    181  N   ILE A  29      34.156 117.136   1.123  1.00 23.24           N  
ATOM    182  CA  ILE A  29      33.964 118.276   2.010  1.00 24.99           C  
ATOM    183  C   ILE A  29      34.161 117.852   3.464  1.00 27.02           C  
ATOM    184  O   ILE A  29      34.075 118.673   4.380  1.00 29.44           O  
ATOM    185  CB  ILE A  29      32.557 118.901   1.852  1.00 23.67           C  
ATOM    186  CG1 ILE A  29      31.487 117.884   2.240  1.00 25.20           C  
ATOM    187  CG2 ILE A  29      32.344 119.358   0.415  1.00 23.31           C  
ATOM    188  CD1 ILE A  29      30.087 118.447   2.256  1.00 26.31           C  
ATOM    189  N   PHE A  30      34.428 116.568   3.676  1.00 27.79           N  
ATOM    190  CA  PHE A  30      34.654 116.061   5.026  1.00 27.28           C  
ATOM    191  C   PHE A  30      36.111 115.665   5.275  1.00 27.17           C  
ATOM    192  O   PHE A  30      36.454 115.172   6.354  1.00 27.79           O  
ATOM    193  CB  PHE A  30      33.729 114.878   5.312  1.00 26.84           C  
ATOM    194  CG  PHE A  30      32.273 115.240   5.319  1.00 24.16           C  
ATOM    195  CD1 PHE A  30      31.379 114.608   4.460  1.00 23.03           C  
ATOM    196  CD2 PHE A  30      31.792 116.228   6.166  1.00 24.82           C  
ATOM    197  CE1 PHE A  30      30.029 114.963   4.445  1.00 21.30           C  
ATOM    198  CE2 PHE A  30      30.441 116.586   6.153  1.00 23.02           C  
ATOM    199  CZ  PHE A  30      29.562 115.953   5.290  1.00 18.32           C  
ATOM    200  N   LYS A  31      36.974 115.882   4.286  1.00 27.46           N  
ATOM    201  CA  LYS A  31      38.387 115.557   4.461  1.00 29.75           C  
ATOM    202  C   LYS A  31      38.880 116.422   5.621  1.00 31.72           C  
ATOM    203  O   LYS A  31      38.479 117.578   5.750  1.00 34.08           O  
ATOM    204  CB  LYS A  31      39.182 115.883   3.192  1.00 28.57           C  
ATOM    205  CG  LYS A  31      40.533 115.171   3.089  1.00 26.19           C  
ATOM    206  CD  LYS A  31      41.370 115.729   1.955  1.00 28.68           C  
ATOM    207  CE  LYS A  31      42.671 114.963   1.770  1.00 28.63           C  
ATOM    208  NZ  LYS A  31      42.485 113.726   0.966  1.00 30.35           N  
ATOM    209  N   GLY A  32      39.737 115.870   6.473  1.00 33.89           N  
ATOM    210  CA  GLY A  32      40.223 116.638   7.607  1.00 33.94           C  
ATOM    211  C   GLY A  32      39.307 116.489   8.810  1.00 35.25           C  
ATOM    212  O   GLY A  32      39.479 117.157   9.826  1.00 38.24           O  
ATOM    213  N   LYS A  33      38.319 115.614   8.692  1.00 34.23           N  
ATOM    214  CA  LYS A  33      37.390 115.368   9.779  1.00 34.88           C  
ATOM    215  C   LYS A  33      37.211 113.868   9.972  1.00 35.44           C  
ATOM    216  O   LYS A  33      37.253 113.104   9.005  1.00 35.52           O  
ATOM    217  CB  LYS A  33      36.034 116.005   9.473  1.00 36.11           C  
ATOM    218  CG  LYS A  33      35.908 117.469   9.859  1.00 36.26           C  
ATOM    219  CD  LYS A  33      34.630 118.060   9.300  1.00 37.11           C  
ATOM    220  CE  LYS A  33      34.334 119.455   9.852  1.00 38.27           C  
ATOM    221  NZ  LYS A  33      33.407 119.431  11.026  1.00 36.35           N  
ATOM    222  N   VAL A  34      37.025 113.446  11.219  1.00 34.01           N  
ATOM    223  CA  VAL A  34      36.817 112.033  11.500  1.00 32.34           C  
ATOM    224  C   VAL A  34      35.343 111.796  11.300  1.00 32.07           C  
ATOM    225  O   VAL A  34      34.517 112.581  11.760  1.00 34.33           O  
ATOM    226  CB  VAL A  34      37.199 111.662  12.940  1.00 32.07           C  
ATOM    227  CG1 VAL A  34      36.741 110.234  13.246  1.00 30.66           C  
ATOM    228  CG2 VAL A  34      38.704 111.776  13.114  1.00 28.32           C  
ATOM    229  N   LEU A  35      35.009 110.718  10.607  1.00 30.52           N  
ATOM    230  CA  LEU A  35      33.617 110.428  10.330  1.00 30.11           C  
ATOM    231  C   LEU A  35      33.055 109.196  11.019  1.00 28.55           C  
ATOM    232  O   LEU A  35      33.697 108.152  11.075  1.00 31.02           O  
ATOM    233  CB  LEU A  35      33.415 110.300   8.819  1.00 30.94           C  
ATOM    234  CG  LEU A  35      33.314 111.589   7.989  1.00 33.98           C  
ATOM    235  CD1 LEU A  35      34.433 112.551   8.325  1.00 33.05           C  
ATOM    236  CD2 LEU A  35      33.343 111.219   6.506  1.00 35.59           C  
ATOM    237  N   LEU A  36      31.849 109.348  11.557  1.00 25.53           N  
ATOM    238  CA  LEU A  36      31.116 108.269  12.201  1.00 23.54           C  
ATOM    239  C   LEU A  36      29.947 107.997  11.256  1.00 22.29           C  
ATOM    240  O   LEU A  36      29.011 108.797  11.173  1.00 21.77           O  
ATOM    241  CB  LEU A  36      30.596 108.702  13.582  1.00 22.41           C  
ATOM    242  CG  LEU A  36      29.584 107.808  14.323  1.00 20.52           C  
ATOM    243  CD1 LEU A  36      29.962 106.354  14.188  1.00 16.64           C  
ATOM    244  CD2 LEU A  36      29.507 108.229  15.806  1.00 20.66           C  
ATOM    245  N   ILE A  37      30.025 106.885  10.526  1.00 20.89           N  
ATOM    246  CA  ILE A  37      28.992 106.500   9.567  1.00 18.89           C  
ATOM    247  C   ILE A  37      28.079 105.448  10.183  1.00 18.73           C  
ATOM    248  O   ILE A  37      28.512 104.348  10.530  1.00 19.02           O  
ATOM    249  CB  ILE A  37      29.626 105.956   8.270  1.00 19.47           C  
ATOM    250  CG1 ILE A  37      30.519 107.039   7.649  1.00 19.43           C  
ATOM    251  CG2 ILE A  37      28.539 105.521   7.298  1.00 17.38           C  
ATOM    252  CD1 ILE A  37      31.222 106.641   6.368  1.00 18.07           C  
ATOM    253  N   VAL A  38      26.809 105.806  10.302  1.00 18.84           N  
ATOM    254  CA  VAL A  38      25.801 104.953  10.922  1.00 19.90           C  
ATOM    255  C   VAL A  38      24.570 104.750  10.043  1.00 19.07           C  
ATOM    256  O   VAL A  38      24.045 105.707   9.486  1.00 19.83           O  
ATOM    257  CB  VAL A  38      25.336 105.584  12.279  1.00 19.77           C  
ATOM    258  CG1 VAL A  38      24.267 104.730  12.938  1.00 18.56           C  
ATOM    259  CG2 VAL A  38      26.521 105.742  13.204  1.00 18.48           C  
ATOM    260  N   ASN A  39      24.116 103.504   9.916  1.00 19.54           N  
ATOM    261  CA  ASN A  39      22.917 103.224   9.132  1.00 20.80           C  
ATOM    262  C   ASN A  39      21.778 103.232  10.147  1.00 22.25           C  
ATOM    263  O   ASN A  39      21.855 102.574  11.184  1.00 22.57           O  
ATOM    264  CB  ASN A  39      22.998 101.865   8.436  1.00 18.15           C  
ATOM    265  CG  ASN A  39      23.155 100.736   9.399  1.00 17.46           C  
ATOM    266  OD1 ASN A  39      24.192 100.609  10.047  1.00 22.42           O  
ATOM    267  ND2 ASN A  39      22.124  99.906   9.516  1.00 15.96           N  
ATOM    268  N   VAL A  40      20.730 103.989   9.852  1.00 21.58           N  
ATOM    269  CA  VAL A  40      19.618 104.106  10.777  1.00 22.91           C  
ATOM    270  C   VAL A  40      18.328 103.507  10.233  1.00 23.18           C  
ATOM    271  O   VAL A  40      18.203 103.253   9.035  1.00 23.45           O  
ATOM    272  CB  VAL A  40      19.399 105.593  11.146  1.00 21.34           C  
ATOM    273  CG1 VAL A  40      20.663 106.157  11.812  1.00 18.37           C  
ATOM    274  CG2 VAL A  40      19.090 106.396   9.899  1.00 20.65           C  
ATOM    275  N   ALA A  41      17.379 103.254  11.125  1.00 24.52           N  
ATOM    276  CA  ALA A  41      16.099 102.696  10.711  1.00 27.01           C  
ATOM    277  C   ALA A  41      15.404 103.703   9.800  1.00 26.36           C  
ATOM    278  O   ALA A  41      15.603 104.913   9.912  1.00 25.71           O  
ATOM    279  CB  ALA A  41      15.230 102.385  11.930  1.00 27.87           C  
ATOM    280  N   SER A  42      14.596 103.199   8.884  1.00 27.48           N  
ATOM    281  CA  SER A  42      13.914 104.065   7.947  1.00 30.79           C  
ATOM    282  C   SER A  42      12.622 104.660   8.516  1.00 31.86           C  
ATOM    283  O   SER A  42      12.218 105.747   8.121  1.00 31.36           O  
ATOM    284  CB  SER A  42      13.620 103.296   6.665  1.00 30.36           C  
ATOM    285  OG  SER A  42      13.268 104.181   5.617  1.00 38.03           O  
ATOM    286  N   LYS A  43      11.989 103.960   9.452  1.00 33.42           N  
ATOM    287  CA  LYS A  43      10.749 104.441  10.038  1.00 36.58           C  
ATOM    288  C   LYS A  43      10.958 105.689  10.891  1.00 37.72           C  
ATOM    289  O   LYS A  43      12.090 106.053  11.211  1.00 37.79           O  
ATOM    290  CB  LYS A  43      10.091 103.329  10.859  1.00 38.20           C  
ATOM    291  CG  LYS A  43      10.997 102.698  11.889  1.00 43.39           C  
ATOM    292  CD  LYS A  43      10.297 101.559  12.616  1.00 47.05           C  
ATOM    293  CE  LYS A  43      11.228 100.885  13.627  1.00 50.12           C  
ATOM    294  NZ  LYS A  43      10.549  99.806  14.422  1.00 50.24           N  
ATOM    295  N   CYS A  44       9.863 106.349  11.248  1.00 37.48           N  
ATOM    296  CA  CYS A  44       9.932 107.559  12.059  1.00 39.15           C  
ATOM    297  C   CYS A  44      10.101 107.189  13.515  1.00 40.59           C  
ATOM    298  O   CYS A  44       9.646 106.138  13.947  1.00 41.24           O  
ATOM    299  CB  CYS A  44       8.652 108.365  11.925  1.00 39.72           C  
ATOM    300  SG  CYS A  44       8.204 108.869  10.235  1.00 41.13           S  
ATOM    301  N   GLY A  45      10.754 108.057  14.274  1.00 42.45           N  
ATOM    302  CA  GLY A  45      10.953 107.782  15.685  1.00 46.75           C  
ATOM    303  C   GLY A  45      12.403 107.728  16.133  1.00 48.67           C  
ATOM    304  O   GLY A  45      13.135 106.799  15.784  1.00 49.50           O  
ATOM    305  N   MET A  46      12.816 108.728  16.906  1.00 49.33           N  
ATOM    306  CA  MET A  46      14.178 108.788  17.420  1.00 50.69           C  
ATOM    307  C   MET A  46      14.166 108.214  18.832  1.00 50.05           C  
ATOM    308  O   MET A  46      14.898 108.689  19.699  1.00 50.88           O  
ATOM    309  CB  MET A  46      14.676 110.237  17.492  1.00 52.70           C  
ATOM    310  CG  MET A  46      14.450 111.080  16.241  1.00 55.51           C  
ATOM    311  SD  MET A  46      15.734 110.958  14.986  1.00 57.44           S  
ATOM    312  CE  MET A  46      15.006 109.713  13.926  1.00 54.72           C  
ATOM    313  N   THR A  47      13.329 107.204  19.061  1.00 48.99           N  
ATOM    314  CA  THR A  47      13.216 106.586  20.379  1.00 49.14           C  
ATOM    315  C   THR A  47      14.321 105.573  20.675  1.00 48.40           C  
ATOM    316  O   THR A  47      14.673 105.354  21.833  1.00 48.47           O  
ATOM    317  CB  THR A  47      11.857 105.885  20.549  1.00 50.37           C  
ATOM    318  OG1 THR A  47      11.763 104.787  19.634  1.00 52.57           O  
ATOM    319  CG2 THR A  47      10.716 106.865  20.274  1.00 51.63           C  
ATOM    320  N   ASN A  48      14.856 104.945  19.632  1.00 46.40           N  
ATOM    321  CA  ASN A  48      15.933 103.975  19.806  1.00 44.02           C  
ATOM    322  C   ASN A  48      17.031 104.719  20.571  1.00 43.16           C  
ATOM    323  O   ASN A  48      17.284 105.896  20.298  1.00 44.49           O  
ATOM    324  CB  ASN A  48      16.438 103.502  18.430  1.00 43.49           C  
ATOM    325  CG  ASN A  48      17.516 102.434  18.525  1.00 40.59           C  
ATOM    326  OD1 ASN A  48      18.642 102.706  18.938  1.00 40.41           O  
ATOM    327  ND2 ASN A  48      17.171 101.214  18.144  1.00 38.66           N  
ATOM    328  N   SER A  49      17.663 104.047  21.532  1.00 39.21           N  
ATOM    329  CA  SER A  49      18.706 104.674  22.344  1.00 37.62           C  
ATOM    330  C   SER A  49      19.886 105.239  21.561  1.00 36.87           C  
ATOM    331  O   SER A  49      20.481 106.235  21.969  1.00 37.66           O  
ATOM    332  CB  SER A  49      19.214 103.694  23.409  1.00 37.17           C  
ATOM    333  OG  SER A  49      19.363 102.382  22.890  1.00 39.94           O  
ATOM    334  N   ASN A  50      20.224 104.613  20.439  1.00 35.00           N  
ATOM    335  CA  ASN A  50      21.342 105.076  19.621  1.00 33.65           C  
ATOM    336  C   ASN A  50      21.285 106.579  19.320  1.00 34.02           C  
ATOM    337  O   ASN A  50      22.308 107.268  19.379  1.00 33.75           O  
ATOM    338  CB  ASN A  50      21.394 104.277  18.308  1.00 32.76           C  
ATOM    339  CG  ASN A  50      22.192 102.985  18.437  1.00 32.07           C  
ATOM    340  OD1 ASN A  50      23.423 103.001  18.428  1.00 32.89           O  
ATOM    341  ND2 ASN A  50      21.492 101.865  18.566  1.00 28.13           N  
ATOM    342  N   TYR A  51      20.095 107.091  19.018  1.00 33.07           N  
ATOM    343  CA  TYR A  51      19.953 108.506  18.694  1.00 32.74           C  
ATOM    344  C   TYR A  51      20.450 109.446  19.780  1.00 33.93           C  
ATOM    345  O   TYR A  51      21.226 110.372  19.504  1.00 34.47           O  
ATOM    346  CB  TYR A  51      18.493 108.846  18.352  1.00 30.66           C  
ATOM    347  CG  TYR A  51      18.051 108.335  16.994  1.00 28.64           C  
ATOM    348  CD1 TYR A  51      17.317 107.159  16.876  1.00 26.21           C  
ATOM    349  CD2 TYR A  51      18.437 108.991  15.824  1.00 27.59           C  
ATOM    350  CE1 TYR A  51      16.981 106.639  15.625  1.00 29.03           C  
ATOM    351  CE2 TYR A  51      18.107 108.481  14.565  1.00 28.53           C  
ATOM    352  CZ  TYR A  51      17.382 107.304  14.471  1.00 29.68           C  
ATOM    353  OH  TYR A  51      17.064 106.784  13.231  1.00 29.23           O  
ATOM    354  N   ALA A  52      20.008 109.207  21.013  1.00 34.21           N  
ATOM    355  CA  ALA A  52      20.393 110.056  22.134  1.00 33.75           C  
ATOM    356  C   ALA A  52      21.894 110.038  22.321  1.00 33.62           C  
ATOM    357  O   ALA A  52      22.510 111.073  22.541  1.00 32.52           O  
ATOM    358  CB  ALA A  52      19.702 109.595  23.402  1.00 33.44           C  
ATOM    359  N   GLU A  53      22.485 108.858  22.211  1.00 35.41           N  
ATOM    360  CA  GLU A  53      23.921 108.733  22.383  1.00 36.98           C  
ATOM    361  C   GLU A  53      24.717 109.442  21.284  1.00 36.89           C  
ATOM    362  O   GLU A  53      25.736 110.088  21.571  1.00 36.61           O  
ATOM    363  CB  GLU A  53      24.299 107.254  22.486  1.00 37.99           C  
ATOM    364  CG  GLU A  53      23.525 106.535  23.586  1.00 38.67           C  
ATOM    365  CD  GLU A  53      24.226 105.302  24.096  1.00 41.08           C  
ATOM    366  OE1 GLU A  53      23.649 104.599  24.956  1.00 40.11           O  
ATOM    367  OE2 GLU A  53      25.360 105.036  23.642  1.00 45.00           O  
ATOM    368  N   MET A  54      24.259 109.342  20.035  1.00 34.90           N  
ATOM    369  CA  MET A  54      24.954 110.014  18.941  1.00 33.94           C  
ATOM    370  C   MET A  54      24.768 111.509  19.158  1.00 34.97           C  
ATOM    371  O   MET A  54      25.687 112.300  18.928  1.00 35.27           O  
ATOM    372  CB  MET A  54      24.384 109.598  17.579  1.00 34.77           C  
ATOM    373  CG  MET A  54      24.617 108.125  17.200  1.00 34.16           C  
ATOM    374  SD  MET A  54      24.030 107.704  15.529  1.00 36.32           S  
ATOM    375  CE  MET A  54      22.356 107.176  15.873  1.00 32.16           C  
ATOM    376  N   ASN A  55      23.573 111.891  19.607  1.00 35.73           N  
ATOM    377  CA  ASN A  55      23.274 113.292  19.886  1.00 37.89           C  
ATOM    378  C   ASN A  55      24.300 113.806  20.894  1.00 38.51           C  
ATOM    379  O   ASN A  55      24.894 114.872  20.714  1.00 36.43           O  
ATOM    380  CB  ASN A  55      21.864 113.430  20.468  1.00 39.69           C  
ATOM    381  CG  ASN A  55      20.792 113.541  19.395  1.00 41.41           C  
ATOM    382  OD1 ASN A  55      19.621 113.252  19.639  1.00 39.96           O  
ATOM    383  ND2 ASN A  55      21.187 113.982  18.209  1.00 43.05           N  
ATOM    384  N   GLN A  56      24.507 113.035  21.956  1.00 39.79           N  
ATOM    385  CA  GLN A  56      25.474 113.415  22.978  1.00 42.42           C  
ATOM    386  C   GLN A  56      26.851 113.482  22.329  1.00 42.52           C  
ATOM    387  O   GLN A  56      27.541 114.493  22.436  1.00 45.12           O  
ATOM    388  CB  GLN A  56      25.496 112.392  24.120  1.00 43.13           C  
ATOM    389  CG  GLN A  56      24.128 112.051  24.703  1.00 43.73           C  
ATOM    390  CD  GLN A  56      24.219 111.022  25.812  1.00 45.39           C  
ATOM    391  OE1 GLN A  56      23.287 110.246  26.040  1.00 45.78           O  
ATOM    392  NE2 GLN A  56      25.347 111.014  26.517  1.00 45.62           N  
ATOM    393  N   LEU A  57      27.245 112.407  21.650  1.00 41.61           N  
ATOM    394  CA  LEU A  57      28.542 112.367  20.990  1.00 41.19           C  
ATOM    395  C   LEU A  57      28.779 113.613  20.161  1.00 40.73           C  
ATOM    396  O   LEU A  57      29.839 114.227  20.221  1.00 40.78           O  
ATOM    397  CB  LEU A  57      28.643 111.157  20.065  1.00 41.65           C  
ATOM    398  CG  LEU A  57      29.073 109.821  20.648  1.00 41.40           C  
ATOM    399  CD1 LEU A  57      29.139 108.788  19.530  1.00 42.08           C  
ATOM    400  CD2 LEU A  57      30.426 109.973  21.312  1.00 41.47           C  
ATOM    401  N   TYR A  58      27.773 113.976  19.380  1.00 41.48           N  
ATOM    402  CA  TYR A  58      27.873 115.132  18.512  1.00 42.87           C  
ATOM    403  C   TYR A  58      28.063 116.438  19.271  1.00 45.20           C  
ATOM    404  O   TYR A  58      28.944 117.235  18.934  1.00 44.82           O  
ATOM    405  CB  TYR A  58      26.627 115.238  17.637  1.00 41.51           C  
ATOM    406  CG  TYR A  58      26.886 115.948  16.331  1.00 39.99           C  
ATOM    407  CD1 TYR A  58      25.896 116.706  15.717  1.00 39.62           C  
ATOM    408  CD2 TYR A  58      28.127 115.853  15.703  1.00 40.65           C  
ATOM    409  CE1 TYR A  58      26.136 117.356  14.512  1.00 39.80           C  
ATOM    410  CE2 TYR A  58      28.375 116.496  14.497  1.00 40.30           C  
ATOM    411  CZ  TYR A  58      27.375 117.248  13.910  1.00 37.78           C  
ATOM    412  OH  TYR A  58      27.625 117.907  12.736  1.00 36.80           O  
ATOM    413  N   GLU A  59      27.237 116.663  20.290  1.00 47.87           N  
ATOM    414  CA  GLU A  59      27.312 117.896  21.070  1.00 49.77           C  
ATOM    415  C   GLU A  59      28.701 118.064  21.666  1.00 49.91           C  
ATOM    416  O   GLU A  59      29.205 119.180  21.815  1.00 50.99           O  
ATOM    417  CB  GLU A  59      26.274 117.884  22.199  1.00 52.18           C  
ATOM    418  CG  GLU A  59      25.987 119.262  22.805  1.00 55.05           C  
ATOM    419  CD  GLU A  59      24.978 120.063  21.991  1.00 57.58           C  
ATOM    420  OE1 GLU A  59      25.046 121.315  22.007  1.00 57.39           O  
ATOM    421  OE2 GLU A  59      24.105 119.437  21.349  1.00 59.05           O  
ATOM    422  N   LYS A  60      29.329 116.944  21.983  1.00 49.28           N  
ATOM    423  CA  LYS A  60      30.645 116.951  22.592  1.00 48.82           C  
ATOM    424  C   LYS A  60      31.821 116.886  21.613  1.00 49.46           C  
ATOM    425  O   LYS A  60      32.971 117.017  22.033  1.00 49.53           O  
ATOM    426  CB  LYS A  60      30.712 115.785  23.586  1.00 47.52           C  
ATOM    427  CG  LYS A  60      32.033 115.566  24.310  1.00 46.33           C  
ATOM    428  CD  LYS A  60      31.889 114.381  25.268  1.00 45.86           C  
ATOM    429  CE  LYS A  60      33.176 114.056  26.013  1.00 47.22           C  
ATOM    430  NZ  LYS A  60      32.995 112.865  26.895  1.00 44.64           N  
ATOM    431  N   TYR A  61      31.553 116.710  20.319  1.00 50.05           N  
ATOM    432  CA  TYR A  61      32.646 116.595  19.345  1.00 51.16           C  
ATOM    433  C   TYR A  61      32.488 117.248  17.956  1.00 52.43           C  
ATOM    434  O   TYR A  61      33.456 117.304  17.191  1.00 51.73           O  
ATOM    435  CB  TYR A  61      32.997 115.111  19.159  1.00 49.81           C  
ATOM    436  CG  TYR A  61      33.682 114.470  20.351  1.00 48.71           C  
ATOM    437  CD1 TYR A  61      35.025 114.730  20.630  1.00 48.76           C  
ATOM    438  CD2 TYR A  61      32.989 113.619  21.204  1.00 46.61           C  
ATOM    439  CE1 TYR A  61      35.660 114.157  21.730  1.00 47.69           C  
ATOM    440  CE2 TYR A  61      33.614 113.042  22.309  1.00 47.00           C  
ATOM    441  CZ  TYR A  61      34.950 113.315  22.568  1.00 47.93           C  
ATOM    442  OH  TYR A  61      35.575 112.754  23.666  1.00 47.36           O  
ATOM    443  N   LYS A  62      31.296 117.730  17.615  1.00 53.91           N  
ATOM    444  CA  LYS A  62      31.104 118.355  16.307  1.00 55.43           C  
ATOM    445  C   LYS A  62      32.174 119.417  16.106  1.00 56.42           C  
ATOM    446  O   LYS A  62      32.749 119.548  15.025  1.00 55.53           O  
ATOM    447  CB  LYS A  62      29.724 119.006  16.202  1.00 55.83           C  
ATOM    448  CG  LYS A  62      29.470 120.087  17.232  1.00 58.06           C  
ATOM    449  CD  LYS A  62      28.203 120.870  16.925  1.00 61.06           C  
ATOM    450  CE  LYS A  62      26.966 119.991  16.959  1.00 61.84           C  
ATOM    451  NZ  LYS A  62      25.737 120.790  16.700  1.00 63.39           N  
ATOM    452  N   ASP A  63      32.441 120.168  17.167  1.00 58.11           N  
ATOM    453  CA  ASP A  63      33.436 121.226  17.124  1.00 59.28           C  
ATOM    454  C   ASP A  63      34.773 120.741  17.685  1.00 58.43           C  
ATOM    455  O   ASP A  63      35.282 121.276  18.670  1.00 59.87           O  
ATOM    456  CB  ASP A  63      32.926 122.444  17.903  1.00 61.31           C  
ATOM    457  CG  ASP A  63      31.610 122.981  17.347  1.00 63.75           C  
ATOM    458  OD1 ASP A  63      31.583 123.365  16.156  1.00 64.84           O  
ATOM    459  OD2 ASP A  63      30.604 123.017  18.093  1.00 64.07           O  
ATOM    460  N   GLN A  64      35.315 119.706  17.049  1.00 56.63           N  
ATOM    461  CA  GLN A  64      36.599 119.108  17.409  1.00 53.94           C  
ATOM    462  C   GLN A  64      37.076 118.239  16.243  1.00 50.90           C  
ATOM    463  O   GLN A  64      38.210 117.756  16.230  1.00 49.99           O  
ATOM    464  CB  GLN A  64      36.488 118.269  18.691  1.00 56.00           C  
ATOM    465  CG  GLN A  64      36.356 119.097  19.969  1.00 57.96           C  
ATOM    466  CD  GLN A  64      36.546 118.278  21.239  1.00 59.82           C  
ATOM    467  OE1 GLN A  64      37.613 117.705  21.466  1.00 60.53           O  
ATOM    468  NE2 GLN A  64      35.512 118.229  22.077  1.00 59.26           N  
ATOM    469  N   GLY A  65      36.198 118.046  15.263  1.00 47.17           N  
ATOM    470  CA  GLY A  65      36.557 117.261  14.095  1.00 43.95           C  
ATOM    471  C   GLY A  65      35.676 116.064  13.784  1.00 41.32           C  
ATOM    472  O   GLY A  65      35.959 115.313  12.851  1.00 41.25           O  
ATOM    473  N   LEU A  66      34.610 115.876  14.555  1.00 37.59           N  
ATOM    474  CA  LEU A  66      33.725 114.746  14.325  1.00 35.08           C  
ATOM    475  C   LEU A  66      32.504 115.113  13.510  1.00 35.11           C  
ATOM    476  O   LEU A  66      31.835 116.110  13.781  1.00 37.25           O  
ATOM    477  CB  LEU A  66      33.270 114.140  15.653  1.00 34.19           C  
ATOM    478  CG  LEU A  66      32.212 113.036  15.573  1.00 33.64           C  
ATOM    479  CD1 LEU A  66      32.705 111.876  14.718  1.00 34.56           C  
ATOM    480  CD2 LEU A  66      31.887 112.562  16.978  1.00 35.26           C  
ATOM    481  N   GLU A  67      32.221 114.292  12.507  1.00 32.65           N  
ATOM    482  CA  GLU A  67      31.068 114.483  11.649  1.00 31.29           C  
ATOM    483  C   GLU A  67      30.319 113.160  11.679  1.00 30.64           C  
ATOM    484  O   GLU A  67      30.931 112.109  11.792  1.00 31.52           O  
ATOM    485  CB  GLU A  67      31.512 114.815  10.227  1.00 34.11           C  
ATOM    486  CG  GLU A  67      30.399 115.346   9.343  1.00 35.51           C  
ATOM    487  CD  GLU A  67      29.640 116.474  10.009  1.00 38.04           C  
ATOM    488  OE1 GLU A  67      28.777 116.184  10.873  1.00 36.81           O  
ATOM    489  OE2 GLU A  67      29.924 117.648   9.680  1.00 38.72           O  
ATOM    490  N   ILE A  68      28.999 113.209  11.602  1.00 30.42           N  
ATOM    491  CA  ILE A  68      28.210 111.992  11.637  1.00 30.18           C  
ATOM    492  C   ILE A  68      27.349 111.893  10.397  1.00 29.86           C  
ATOM    493  O   ILE A  68      26.556 112.779  10.110  1.00 32.57           O  
ATOM    494  CB  ILE A  68      27.297 111.941  12.886  1.00 30.57           C  
ATOM    495  CG1 ILE A  68      28.153 111.878  14.150  1.00 32.25           C  
ATOM    496  CG2 ILE A  68      26.387 110.726  12.826  1.00 30.15           C  
ATOM    497  CD1 ILE A  68      27.354 111.807  15.445  1.00 33.20           C  
ATOM    498  N   LEU A  69      27.527 110.818   9.646  1.00 29.55           N  
ATOM    499  CA  LEU A  69      26.744 110.610   8.441  1.00 27.24           C  
ATOM    500  C   LEU A  69      25.810 109.450   8.724  1.00 26.74           C  
ATOM    501  O   LEU A  69      26.221 108.289   8.758  1.00 24.38           O  
ATOM    502  CB  LEU A  69      27.659 110.315   7.242  1.00 27.90           C  
ATOM    503  CG  LEU A  69      28.556 111.491   6.808  1.00 29.59           C  
ATOM    504  CD1 LEU A  69      29.537 111.828   7.901  1.00 28.74           C  
ATOM    505  CD2 LEU A  69      29.303 111.140   5.545  1.00 31.62           C  
ATOM    506  N   ALA A  70      24.549 109.787   8.966  1.00 26.34           N  
ATOM    507  CA  ALA A  70      23.534 108.793   9.268  1.00 24.58           C  
ATOM    508  C   ALA A  70      22.752 108.518   7.997  1.00 23.51           C  
ATOM    509  O   ALA A  70      22.243 109.437   7.361  1.00 25.21           O  
ATOM    510  CB  ALA A  70      22.608 109.313  10.366  1.00 23.14           C  
ATOM    511  N   PHE A  71      22.661 107.246   7.634  1.00 22.14           N  
ATOM    512  CA  PHE A  71      21.955 106.834   6.432  1.00 20.37           C  
ATOM    513  C   PHE A  71      20.743 105.973   6.773  1.00 21.34           C  
ATOM    514  O   PHE A  71      20.872 104.907   7.384  1.00 19.43           O  
ATOM    515  CB  PHE A  71      22.903 106.043   5.523  1.00 19.56           C  
ATOM    516  CG  PHE A  71      23.986 106.875   4.901  1.00 17.29           C  
ATOM    517  CD1 PHE A  71      23.776 107.519   3.689  1.00 15.03           C  
ATOM    518  CD2 PHE A  71      25.211 107.027   5.534  1.00 17.91           C  
ATOM    519  CE1 PHE A  71      24.771 108.304   3.114  1.00 15.35           C  
ATOM    520  CE2 PHE A  71      26.209 107.813   4.961  1.00 18.53           C  
ATOM    521  CZ  PHE A  71      25.984 108.451   3.748  1.00 12.29           C  
ATOM    522  N   PRO A  72      19.543 106.431   6.387  1.00 21.58           N  
ATOM    523  CA  PRO A  72      18.315 105.683   6.661  1.00 21.77           C  
ATOM    524  C   PRO A  72      18.280 104.467   5.744  1.00 22.29           C  
ATOM    525  O   PRO A  72      18.727 104.543   4.592  1.00 22.23           O  
ATOM    526  CB  PRO A  72      17.203 106.680   6.306  1.00 20.07           C  
ATOM    527  CG  PRO A  72      17.867 108.008   6.393  1.00 21.64           C  
ATOM    528  CD  PRO A  72      19.225 107.735   5.789  1.00 22.29           C  
ATOM    529  N   CYS A  73      17.743 103.360   6.244  1.00 21.38           N  
ATOM    530  CA  CYS A  73      17.648 102.149   5.441  1.00 23.85           C  
ATOM    531  C   CYS A  73      16.478 101.319   5.968  1.00 24.60           C  
ATOM    532  O   CYS A  73      16.257 101.259   7.174  1.00 23.88           O  
ATOM    533  CB  CYS A  73      18.969 101.371   5.531  1.00 21.19           C  
ATOM    534  SG  CYS A  73      18.966  99.749   4.763  1.00 26.01           S  
ATOM    535  N   ASN A  74      15.723 100.687   5.079  1.00 27.49           N  
ATOM    536  CA  ASN A  74      14.593  99.885   5.536  1.00 31.10           C  
ATOM    537  C   ASN A  74      14.760  98.397   5.250  1.00 30.35           C  
ATOM    538  O   ASN A  74      13.782  97.680   5.084  1.00 29.88           O  
ATOM    539  CB  ASN A  74      13.279 100.399   4.913  1.00 35.09           C  
ATOM    540  CG  ASN A  74      12.935  99.717   3.603  1.00 39.78           C  
ATOM    541  OD1 ASN A  74      13.623  99.883   2.593  1.00 42.32           O  
ATOM    542  ND2 ASN A  74      11.859  98.935   3.616  1.00 43.22           N  
ATOM    543  N   GLN A  75      16.003  97.928   5.211  1.00 32.96           N  
ATOM    544  CA  GLN A  75      16.263  96.516   4.939  1.00 34.16           C  
ATOM    545  C   GLN A  75      16.142  95.643   6.185  1.00 35.97           C  
ATOM    546  O   GLN A  75      16.132  94.416   6.089  1.00 35.30           O  
ATOM    547  CB  GLN A  75      17.654  96.345   4.312  1.00 31.89           C  
ATOM    548  CG  GLN A  75      17.742  96.872   2.880  1.00 29.17           C  
ATOM    549  CD  GLN A  75      19.112  96.673   2.249  1.00 25.83           C  
ATOM    550  OE1 GLN A  75      20.092  97.296   2.657  1.00 25.42           O  
ATOM    551  NE2 GLN A  75      19.184  95.798   1.253  1.00 22.36           N  
ATOM    552  N   PHE A  76      16.038  96.276   7.349  1.00 38.39           N  
ATOM    553  CA  PHE A  76      15.929  95.537   8.599  1.00 43.14           C  
ATOM    554  C   PHE A  76      14.576  95.700   9.279  1.00 49.56           C  
ATOM    555  O   PHE A  76      14.171  96.807   9.627  1.00 49.85           O  
ATOM    556  CB  PHE A  76      17.057  95.950   9.550  1.00 36.71           C  
ATOM    557  CG  PHE A  76      18.407  95.957   8.900  1.00 31.26           C  
ATOM    558  CD1 PHE A  76      18.955  97.142   8.414  1.00 29.05           C  
ATOM    559  CD2 PHE A  76      19.103  94.765   8.704  1.00 29.32           C  
ATOM    560  CE1 PHE A  76      20.171  97.143   7.739  1.00 24.92           C  
ATOM    561  CE2 PHE A  76      20.315  94.752   8.032  1.00 25.92           C  
ATOM    562  CZ  PHE A  76      20.850  95.944   7.547  1.00 27.67           C  
ATOM    563  N   GLY A  77      13.885  94.575   9.450  1.00 58.01           N  
ATOM    564  CA  GLY A  77      12.583  94.562  10.091  1.00 67.65           C  
ATOM    565  C   GLY A  77      11.573  95.545   9.530  1.00 75.35           C  
ATOM    566  O   GLY A  77      10.890  96.231  10.291  1.00 76.17           O  
ATOM    567  N   GLU A  78      11.465  95.614   8.205  1.00 82.14           N  
ATOM    568  CA  GLU A  78      10.524  96.530   7.559  1.00 88.60           C  
ATOM    569  C   GLU A  78       9.078  96.192   7.913  1.00 92.72           C  
ATOM    570  O   GLU A  78       8.155  96.932   7.564  1.00 94.11           O  
ATOM    571  CB  GLU A  78      10.710  96.505   6.031  1.00 88.94           C  
ATOM    572  CG  GLU A  78      10.419  95.166   5.349  1.00 88.98           C  
ATOM    573  CD  GLU A  78       8.945  94.947   5.037  1.00 89.53           C  
ATOM    574  OE1 GLU A  78       8.598  93.851   4.550  1.00 89.65           O  
ATOM    575  OE2 GLU A  78       8.131  95.868   5.267  1.00 88.95           O  
ATOM    576  N   GLU A  79       8.894  95.077   8.614  1.00 96.41           N  
ATOM    577  CA  GLU A  79       7.569  94.622   9.017  1.00100.10           C  
ATOM    578  C   GLU A  79       7.216  95.056  10.443  1.00102.83           C  
ATOM    579  O   GLU A  79       6.263  94.543  11.032  1.00103.28           O  
ATOM    580  CB  GLU A  79       7.500  93.095   8.906  1.00100.41           C  
ATOM    581  CG  GLU A  79       6.130  92.501   9.189  1.00101.81           C  
ATOM    582  CD  GLU A  79       5.076  92.983   8.216  1.00102.03           C  
ATOM    583  OE1 GLU A  79       5.228  92.726   7.004  1.00102.62           O  
ATOM    584  OE2 GLU A  79       4.097  93.618   8.662  1.00102.33           O  
ATOM    585  N   GLU A  80       7.968  96.011  10.991  1.00105.46           N  
ATOM    586  CA  GLU A  80       7.716  96.480  12.356  1.00107.91           C  
ATOM    587  C   GLU A  80       6.449  97.321  12.549  1.00109.32           C  
ATOM    588  O   GLU A  80       5.517  96.889  13.231  1.00109.59           O  
ATOM    589  CB  GLU A  80       8.926  97.251  12.894  1.00108.03           C  
ATOM    590  CG  GLU A  80      10.202  96.434  12.974  1.00108.31           C  
ATOM    591  CD  GLU A  80       9.964  95.039  13.507  1.00108.45           C  
ATOM    592  OE1 GLU A  80       9.319  94.909  14.568  1.00108.70           O  
ATOM    593  OE2 GLU A  80      10.426  94.074  12.863  1.00108.10           O  
ATOM    594  N   PRO A  81       6.395  98.535  11.964  1.00110.66           N  
ATOM    595  CA  PRO A  81       5.181  99.338  12.154  1.00111.09           C  
ATOM    596  C   PRO A  81       3.905  98.547  11.855  1.00111.16           C  
ATOM    597  O   PRO A  81       3.813  97.870  10.828  1.00110.76           O  
ATOM    598  CB  PRO A  81       5.384 100.503  11.184  1.00110.89           C  
ATOM    599  CG  PRO A  81       6.872 100.674  11.173  1.00110.76           C  
ATOM    600  CD  PRO A  81       7.358  99.240  11.096  1.00110.98           C  
ATOM    601  N   GLY A  82       2.932  98.621  12.759  1.00111.24           N  
ATOM    602  CA  GLY A  82       1.685  97.914  12.538  1.00111.17           C  
ATOM    603  C   GLY A  82       1.203  98.227  11.136  1.00111.10           C  
ATOM    604  O   GLY A  82       0.613  97.384  10.459  1.00110.78           O  
ATOM    605  N   THR A  83       1.479  99.456  10.703  1.00111.17           N  
ATOM    606  CA  THR A  83       1.102  99.930   9.375  1.00111.14           C  
ATOM    607  C   THR A  83       2.345 100.404   8.613  1.00110.27           C  
ATOM    608  O   THR A  83       2.566 101.604   8.435  1.00110.19           O  
ATOM    609  CB  THR A  83       0.075 101.090   9.472  1.00111.65           C  
ATOM    610  OG1 THR A  83      -0.235 101.576   8.159  1.00111.58           O  
ATOM    611  CG2 THR A  83       0.630 102.228  10.326  1.00112.39           C  
ATOM    612  N   ASN A  84       3.158  99.447   8.173  1.00109.23           N  
ATOM    613  CA  ASN A  84       4.377  99.750   7.427  1.00107.66           C  
ATOM    614  C   ASN A  84       4.118  99.545   5.939  1.00105.86           C  
ATOM    615  O   ASN A  84       4.663 100.263   5.098  1.00106.31           O  
ATOM    616  CB  ASN A  84       5.515  98.828   7.871  1.00108.34           C  
ATOM    617  CG  ASN A  84       5.292  97.383   7.454  1.00108.75           C  
ATOM    618  OD1 ASN A  84       5.358  97.050   6.269  1.00108.69           O  
ATOM    619  ND2 ASN A  84       5.018  96.519   8.428  1.00109.32           N  
ATOM    620  N   ASP A  85       3.284  98.554   5.632  1.00103.04           N  
ATOM    621  CA  ASP A  85       2.922  98.217   4.258  1.00 99.68           C  
ATOM    622  C   ASP A  85       2.741  99.454   3.392  1.00 96.84           C  
ATOM    623  O   ASP A  85       3.038  99.436   2.198  1.00 96.74           O  
ATOM    624  CB  ASP A  85       1.626  97.407   4.247  1.00100.57           C  
ATOM    625  CG  ASP A  85       0.524  98.070   5.048  1.00101.40           C  
ATOM    626  OD1 ASP A  85       0.644  98.115   6.293  1.00101.39           O  
ATOM    627  OD2 ASP A  85      -0.457  98.558   4.440  1.00101.70           O  
ATOM    628  N   GLN A  86       2.251 100.527   4.006  1.00 92.99           N  
ATOM    629  CA  GLN A  86       2.009 101.783   3.310  1.00 88.80           C  
ATOM    630  C   GLN A  86       3.199 102.288   2.497  1.00 86.43           C  
ATOM    631  O   GLN A  86       4.258 102.592   3.049  1.00 86.01           O  
ATOM    632  CB  GLN A  86       1.586 102.857   4.316  1.00 87.72           C  
ATOM    633  CG  GLN A  86       0.220 103.464   4.033  1.00 86.85           C  
ATOM    634  CD  GLN A  86       0.179 104.243   2.728  1.00 85.99           C  
ATOM    635  OE1 GLN A  86       0.562 103.735   1.675  1.00 85.77           O  
ATOM    636  NE2 GLN A  86      -0.297 105.482   2.790  1.00 84.60           N  
ATOM    637  N   ILE A  87       3.010 102.366   1.181  1.00 83.51           N  
ATOM    638  CA  ILE A  87       4.034 102.857   0.262  1.00 80.79           C  
ATOM    639  C   ILE A  87       3.669 104.273  -0.176  1.00 79.26           C  
ATOM    640  O   ILE A  87       2.742 104.472  -0.961  1.00 79.98           O  
ATOM    641  CB  ILE A  87       4.148 101.982  -1.028  1.00 81.47           C  
ATOM    642  CG1 ILE A  87       4.977 100.726  -0.754  1.00 82.14           C  
ATOM    643  CG2 ILE A  87       4.779 102.792  -2.165  1.00 80.65           C  
ATOM    644  CD1 ILE A  87       5.198  99.852  -1.993  1.00 81.33           C  
ATOM    645  N   THR A  88       4.388 105.253   0.354  1.00 77.04           N  
ATOM    646  CA  THR A  88       4.180 106.650  -0.006  1.00 74.69           C  
ATOM    647  C   THR A  88       5.607 107.153  -0.125  1.00 73.92           C  
ATOM    648  O   THR A  88       5.858 108.304  -0.490  1.00 74.43           O  
ATOM    649  CB  THR A  88       3.449 107.436   1.105  1.00 73.91           C  
ATOM    650  OG1 THR A  88       2.440 106.611   1.692  1.00 73.83           O  
ATOM    651  CG2 THR A  88       2.776 108.675   0.526  1.00 70.89           C  
ATOM    652  N   ASP A  89       6.528 106.244   0.192  1.00 72.29           N  
ATOM    653  CA  ASP A  89       7.968 106.472   0.168  1.00 70.46           C  
ATOM    654  C   ASP A  89       8.654 105.248   0.793  1.00 70.17           C  
ATOM    655  O   ASP A  89       9.500 104.593   0.174  1.00 69.53           O  
ATOM    656  CB  ASP A  89       8.318 107.733   0.970  1.00 69.72           C  
ATOM    657  CG  ASP A  89       7.423 107.925   2.190  1.00 70.26           C  
ATOM    658  OD1 ASP A  89       6.318 108.489   2.048  1.00 69.89           O  
ATOM    659  OD2 ASP A  89       7.817 107.500   3.295  1.00 70.15           O  
ATOM    660  N   PHE A  90       8.255 104.953   2.027  1.00 68.95           N  
ATOM    661  CA  PHE A  90       8.769 103.845   2.828  1.00 66.21           C  
ATOM    662  C   PHE A  90       9.966 104.252   3.678  1.00 64.21           C  
ATOM    663  O   PHE A  90      10.723 103.406   4.152  1.00 64.45           O  
ATOM    664  CB  PHE A  90       9.123 102.635   1.961  1.00 67.49           C  
ATOM    665  CG  PHE A  90       8.591 101.344   2.506  1.00 68.89           C  
ATOM    666  CD1 PHE A  90       7.670 100.595   1.782  1.00 69.50           C  
ATOM    667  CD2 PHE A  90       8.976 100.899   3.768  1.00 69.20           C  
ATOM    668  CE1 PHE A  90       7.135  99.423   2.309  1.00 70.27           C  
ATOM    669  CE2 PHE A  90       8.449  99.728   4.307  1.00 69.88           C  
ATOM    670  CZ  PHE A  90       7.526  98.987   3.575  1.00 71.24           C  
ATOM    671  N   VAL A  91      10.115 105.558   3.867  1.00 60.59           N  
ATOM    672  CA  VAL A  91      11.185 106.125   4.679  1.00 58.30           C  
ATOM    673  C   VAL A  91      10.586 107.351   5.348  1.00 56.04           C  
ATOM    674  O   VAL A  91       9.817 108.080   4.725  1.00 57.01           O  
ATOM    675  CB  VAL A  91      12.376 106.559   3.817  1.00 58.87           C  
ATOM    676  CG1 VAL A  91      13.479 107.127   4.689  1.00 58.13           C  
ATOM    677  CG2 VAL A  91      12.883 105.377   3.035  1.00 60.38           C  
ATOM    678  N   CYS A  92      10.927 107.598   6.608  1.00 52.32           N  
ATOM    679  CA  CYS A  92      10.348 108.747   7.287  1.00 49.67           C  
ATOM    680  C   CYS A  92      10.615 110.068   6.576  1.00 49.57           C  
ATOM    681  O   CYS A  92      11.761 110.449   6.337  1.00 50.02           O  
ATOM    682  CB  CYS A  92      10.829 108.841   8.733  1.00 47.56           C  
ATOM    683  SG  CYS A  92       9.781 109.998   9.655  1.00 42.57           S  
ATOM    684  N   THR A  93       9.530 110.759   6.252  1.00 47.99           N  
ATOM    685  CA  THR A  93       9.588 112.039   5.565  1.00 47.52           C  
ATOM    686  C   THR A  93      10.260 113.128   6.404  1.00 47.42           C  
ATOM    687  O   THR A  93      10.562 114.203   5.898  1.00 47.14           O  
ATOM    688  CB  THR A  93       8.166 112.516   5.176  1.00 46.88           C  
ATOM    689  OG1 THR A  93       7.385 112.725   6.359  1.00 47.15           O  
ATOM    690  CG2 THR A  93       7.469 111.469   4.328  1.00 44.86           C  
ATOM    691  N   ARG A  94      10.490 112.856   7.685  1.00 48.06           N  
ATOM    692  CA  ARG A  94      11.133 113.832   8.561  1.00 50.68           C  
ATOM    693  C   ARG A  94      11.926 113.159   9.674  1.00 52.09           C  
ATOM    694  O   ARG A  94      11.420 112.288  10.373  1.00 52.68           O  
ATOM    695  CB  ARG A  94      10.087 114.774   9.165  1.00 51.76           C  
ATOM    696  CG  ARG A  94       9.057 114.090  10.054  1.00 51.02           C  
ATOM    697  CD  ARG A  94       7.675 114.676   9.818  1.00 49.87           C  
ATOM    698  NE  ARG A  94       7.589 116.084  10.185  1.00 48.30           N  
ATOM    699  CZ  ARG A  94       6.650 116.912   9.743  1.00 48.30           C  
ATOM    700  NH1 ARG A  94       5.715 116.475   8.908  1.00 47.39           N  
ATOM    701  NH2 ARG A  94       6.633 118.172  10.149  1.00 48.49           N  
ATOM    702  N   PHE A  95      13.175 113.577   9.836  1.00 53.86           N  
ATOM    703  CA  PHE A  95      14.048 113.018  10.859  1.00 55.62           C  
ATOM    704  C   PHE A  95      14.714 114.111  11.683  1.00 56.95           C  
ATOM    705  O   PHE A  95      15.792 114.577  11.330  1.00 58.59           O  
ATOM    706  CB  PHE A  95      15.132 112.160  10.205  1.00 55.23           C  
ATOM    707  CG  PHE A  95      14.709 110.750   9.921  1.00 55.89           C  
ATOM    708  CD1 PHE A  95      15.084 110.127   8.735  1.00 55.51           C  
ATOM    709  CD2 PHE A  95      13.974 110.028  10.853  1.00 56.67           C  
ATOM    710  CE1 PHE A  95      14.737 108.806   8.484  1.00 55.01           C  
ATOM    711  CE2 PHE A  95      13.621 108.705  10.612  1.00 56.92           C  
ATOM    712  CZ  PHE A  95      14.005 108.093   9.424  1.00 56.56           C  
ATOM    713  N   LYS A  96      14.084 114.521  12.777  1.00 58.19           N  
ATOM    714  CA  LYS A  96      14.658 115.559  13.629  1.00 58.86           C  
ATOM    715  C   LYS A  96      15.978 115.105  14.248  1.00 58.76           C  
ATOM    716  O   LYS A  96      16.016 114.132  15.000  1.00 58.78           O  
ATOM    717  CB  LYS A  96      13.675 115.947  14.743  1.00 60.46           C  
ATOM    718  CG  LYS A  96      13.088 114.772  15.537  1.00 61.57           C  
ATOM    719  CD  LYS A  96      11.990 114.044  14.759  1.00 61.51           C  
ATOM    720  CE  LYS A  96      11.371 112.921  15.581  1.00 61.96           C  
ATOM    721  NZ  LYS A  96      10.935 113.380  16.930  1.00 61.74           N  
ATOM    722  N   SER A  97      17.055 115.819  13.932  1.00 58.90           N  
ATOM    723  CA  SER A  97      18.379 115.492  14.451  1.00 59.50           C  
ATOM    724  C   SER A  97      19.425 116.551  14.085  1.00 60.52           C  
ATOM    725  O   SER A  97      19.438 117.060  12.964  1.00 60.90           O  
ATOM    726  CB  SER A  97      18.815 114.130  13.912  1.00 59.34           C  
ATOM    727  OG  SER A  97      20.174 113.881  14.205  1.00 60.69           O  
ATOM    728  N   GLU A  98      20.303 116.884  15.031  1.00 61.43           N  
ATOM    729  CA  GLU A  98      21.341 117.884  14.778  1.00 61.67           C  
ATOM    730  C   GLU A  98      22.294 117.377  13.716  1.00 59.69           C  
ATOM    731  O   GLU A  98      22.632 118.100  12.777  1.00 60.82           O  
ATOM    732  CB  GLU A  98      22.123 118.210  16.057  1.00 65.12           C  
ATOM    733  CG  GLU A  98      21.576 119.403  16.857  1.00 70.05           C  
ATOM    734  CD  GLU A  98      21.995 120.755  16.282  1.00 72.69           C  
ATOM    735  OE1 GLU A  98      21.588 121.795  16.844  1.00 74.33           O  
ATOM    736  OE2 GLU A  98      22.734 120.781  15.272  1.00 73.69           O  
ATOM    737  N   PHE A  99      22.736 116.133  13.870  1.00 56.73           N  
ATOM    738  CA  PHE A  99      23.638 115.543  12.897  1.00 52.61           C  
ATOM    739  C   PHE A  99      22.806 115.190  11.668  1.00 50.64           C  
ATOM    740  O   PHE A  99      21.674 114.717  11.788  1.00 50.10           O  
ATOM    741  CB  PHE A  99      24.351 114.307  13.478  1.00 51.57           C  
ATOM    742  CG  PHE A  99      23.429 113.186  13.885  1.00 49.33           C  
ATOM    743  CD1 PHE A  99      22.856 112.352  12.934  1.00 48.51           C  
ATOM    744  CD2 PHE A  99      23.147 112.959  15.225  1.00 48.30           C  
ATOM    745  CE1 PHE A  99      22.016 111.306  13.312  1.00 47.86           C  
ATOM    746  CE2 PHE A  99      22.307 111.914  15.610  1.00 47.61           C  
ATOM    747  CZ  PHE A  99      21.741 111.088  14.652  1.00 47.45           C  
ATOM    748  N   PRO A 100      23.357 115.432  10.472  1.00 47.90           N  
ATOM    749  CA  PRO A 100      22.739 115.181   9.163  1.00 46.92           C  
ATOM    750  C   PRO A 100      22.246 113.771   8.842  1.00 45.82           C  
ATOM    751  O   PRO A 100      22.960 112.780   9.040  1.00 48.04           O  
ATOM    752  CB  PRO A 100      23.815 115.647   8.183  1.00 47.14           C  
ATOM    753  CG  PRO A 100      25.089 115.407   8.932  1.00 46.55           C  
ATOM    754  CD  PRO A 100      24.748 115.892  10.311  1.00 46.55           C  
ATOM    755  N   ILE A 101      21.012 113.699   8.350  1.00 42.40           N  
ATOM    756  CA  ILE A 101      20.397 112.437   7.946  1.00 40.43           C  
ATOM    757  C   ILE A 101      20.305 112.500   6.420  1.00 39.18           C  
ATOM    758  O   ILE A 101      19.759 113.454   5.865  1.00 40.21           O  
ATOM    759  CB  ILE A 101      18.967 112.282   8.508  1.00 40.03           C  
ATOM    760  CG1 ILE A 101      18.976 112.428  10.035  1.00 40.21           C  
ATOM    761  CG2 ILE A 101      18.388 110.935   8.079  1.00 34.69           C  
ATOM    762  CD1 ILE A 101      19.545 111.243  10.802  1.00 37.80           C  
ATOM    763  N   PHE A 102      20.838 111.491   5.743  1.00 36.55           N  
ATOM    764  CA  PHE A 102      20.821 111.467   4.284  1.00 33.51           C  
ATOM    765  C   PHE A 102      19.645 110.701   3.684  1.00 32.66           C  
ATOM    766  O   PHE A 102      18.817 110.142   4.402  1.00 31.30           O  
ATOM    767  CB  PHE A 102      22.145 110.893   3.778  1.00 32.53           C  
ATOM    768  CG  PHE A 102      23.333 111.766   4.083  1.00 29.74           C  
ATOM    769  CD1 PHE A 102      23.859 112.614   3.113  1.00 26.22           C  
ATOM    770  CD2 PHE A 102      23.901 111.768   5.344  1.00 27.04           C  
ATOM    771  CE1 PHE A 102      24.928 113.448   3.399  1.00 24.99           C  
ATOM    772  CE2 PHE A 102      24.976 112.603   5.640  1.00 26.91           C  
ATOM    773  CZ  PHE A 102      25.488 113.441   4.666  1.00 26.29           C  
ATOM    774  N   ASP A 103      19.570 110.695   2.360  1.00 31.82           N  
ATOM    775  CA  ASP A 103      18.494 110.002   1.673  1.00 31.92           C  
ATOM    776  C   ASP A 103      18.603 108.515   1.987  1.00 31.00           C  
ATOM    777  O   ASP A 103      19.657 108.026   2.385  1.00 30.62           O  
ATOM    778  CB  ASP A 103      18.596 110.232   0.155  1.00 35.38           C  
ATOM    779  CG  ASP A 103      17.341 109.799  -0.599  1.00 37.79           C  
ATOM    780  OD1 ASP A 103      17.344 109.826  -1.848  1.00 39.98           O  
ATOM    781  OD2 ASP A 103      16.342 109.440   0.055  1.00 42.27           O  
ATOM    782  N   LYS A 104      17.501 107.805   1.812  1.00 30.06           N  
ATOM    783  CA  LYS A 104      17.452 106.373   2.057  1.00 30.32           C  
ATOM    784  C   LYS A 104      18.409 105.665   1.097  1.00 27.76           C  
ATOM    785  O   LYS A 104      18.573 106.088  -0.045  1.00 27.24           O  
ATOM    786  CB  LYS A 104      16.021 105.877   1.823  1.00 32.12           C  
ATOM    787  CG  LYS A 104      15.813 104.364   1.877  1.00 37.34           C  
ATOM    788  CD  LYS A 104      14.629 103.977   0.965  1.00 39.07           C  
ATOM    789  CE  LYS A 104      14.170 102.544   1.156  1.00 40.95           C  
ATOM    790  NZ  LYS A 104      13.188 102.124   0.095  1.00 42.76           N  
ATOM    791  N   ILE A 105      19.047 104.599   1.565  1.00 25.28           N  
ATOM    792  CA  ILE A 105      19.951 103.828   0.723  1.00 24.05           C  
ATOM    793  C   ILE A 105      19.890 102.366   1.127  1.00 24.49           C  
ATOM    794  O   ILE A 105      19.425 102.029   2.208  1.00 24.83           O  
ATOM    795  CB  ILE A 105      21.433 104.282   0.853  1.00 23.07           C  
ATOM    796  CG1 ILE A 105      21.935 104.067   2.286  1.00 22.91           C  
ATOM    797  CG2 ILE A 105      21.581 105.739   0.453  1.00 22.02           C  
ATOM    798  CD1 ILE A 105      23.452 104.228   2.442  1.00 17.71           C  
ATOM    799  N   ASP A 106      20.328 101.486   0.242  1.00 25.00           N  
ATOM    800  CA  ASP A 106      20.378 100.079   0.597  1.00 25.12           C  
ATOM    801  C   ASP A 106      21.807  99.860   1.076  1.00 23.95           C  
ATOM    802  O   ASP A 106      22.747 100.402   0.497  1.00 23.67           O  
ATOM    803  CB  ASP A 106      20.088  99.185  -0.616  1.00 25.53           C  
ATOM    804  CG  ASP A 106      18.609  98.854  -0.761  1.00 27.24           C  
ATOM    805  OD1 ASP A 106      18.260  98.074  -1.667  1.00 29.07           O  
ATOM    806  OD2 ASP A 106      17.795  99.370   0.032  1.00 29.17           O  
ATOM    807  N   VAL A 107      21.984  99.095   2.145  1.00 22.91           N  
ATOM    808  CA  VAL A 107      23.336  98.830   2.625  1.00 21.05           C  
ATOM    809  C   VAL A 107      23.799  97.433   2.208  1.00 20.39           C  
ATOM    810  O   VAL A 107      24.992  97.185   2.100  1.00 19.18           O  
ATOM    811  CB  VAL A 107      23.434  98.986   4.155  1.00 17.65           C  
ATOM    812  CG1 VAL A 107      23.231 100.429   4.525  1.00 17.78           C  
ATOM    813  CG2 VAL A 107      22.399  98.128   4.838  1.00 20.72           C  
ATOM    814  N   ASN A 108      22.848  96.531   1.978  1.00 20.46           N  
ATOM    815  CA  ASN A 108      23.163  95.172   1.550  1.00 21.59           C  
ATOM    816  C   ASN A 108      22.473  94.831   0.223  1.00 24.00           C  
ATOM    817  O   ASN A 108      21.455  95.431  -0.134  1.00 23.53           O  
ATOM    818  CB  ASN A 108      22.729  94.152   2.605  1.00 20.13           C  
ATOM    819  CG  ASN A 108      23.484  94.298   3.917  1.00 22.06           C  
ATOM    820  OD1 ASN A 108      24.637  94.714   3.935  1.00 23.04           O  
ATOM    821  ND2 ASN A 108      22.836  93.940   5.021  1.00 20.94           N  
ATOM    822  N   GLY A 109      23.042  93.883  -0.518  1.00 24.93           N  
ATOM    823  CA  GLY A 109      22.419  93.464  -1.765  1.00 27.82           C  
ATOM    824  C   GLY A 109      22.837  94.116  -3.067  1.00 30.67           C  
ATOM    825  O   GLY A 109      23.789  94.890  -3.118  1.00 30.95           O  
ATOM    826  N   GLU A 110      22.090  93.808  -4.127  1.00 33.59           N  
ATOM    827  CA  GLU A 110      22.379  94.322  -5.459  1.00 35.38           C  
ATOM    828  C   GLU A 110      22.262  95.832  -5.648  1.00 33.93           C  
ATOM    829  O   GLU A 110      22.727  96.358  -6.657  1.00 35.09           O  
ATOM    830  CB  GLU A 110      21.509  93.611  -6.497  1.00 38.30           C  
ATOM    831  CG  GLU A 110      20.016  93.754  -6.273  1.00 45.59           C  
ATOM    832  CD  GLU A 110      19.204  93.232  -7.449  1.00 51.50           C  
ATOM    833  OE1 GLU A 110      19.443  92.075  -7.875  1.00 53.39           O  
ATOM    834  OE2 GLU A 110      18.327  93.976  -7.947  1.00 54.02           O  
ATOM    835  N   ASN A 111      21.642  96.536  -4.708  1.00 30.91           N  
ATOM    836  CA  ASN A 111      21.540  97.988  -4.839  1.00 29.71           C  
ATOM    837  C   ASN A 111      22.213  98.715  -3.697  1.00 26.31           C  
ATOM    838  O   ASN A 111      21.925  99.881  -3.436  1.00 24.46           O  
ATOM    839  CB  ASN A 111      20.083  98.434  -4.924  1.00 32.05           C  
ATOM    840  CG  ASN A 111      19.429  97.987  -6.194  1.00 32.90           C  
ATOM    841  OD1 ASN A 111      18.519  97.157  -6.180  1.00 34.75           O  
ATOM    842  ND2 ASN A 111      19.897  98.523  -7.315  1.00 31.53           N  
ATOM    843  N   ALA A 112      23.106  98.016  -3.013  1.00 25.01           N  
ATOM    844  CA  ALA A 112      23.819  98.603  -1.899  1.00 23.22           C  
ATOM    845  C   ALA A 112      24.537  99.841  -2.390  1.00 22.55           C  
ATOM    846  O   ALA A 112      25.092  99.865  -3.490  1.00 23.13           O  
ATOM    847  CB  ALA A 112      24.820  97.607  -1.324  1.00 22.69           C  
ATOM    848  N   SER A 113      24.494 100.881  -1.573  1.00 22.13           N  
ATOM    849  CA  SER A 113      25.162 102.123  -1.888  1.00 22.18           C  
ATOM    850  C   SER A 113      26.645 101.866  -2.140  1.00 22.08           C  
ATOM    851  O   SER A 113      27.311 101.165  -1.365  1.00 19.72           O  
ATOM    852  CB  SER A 113      25.023 103.101  -0.729  1.00 24.36           C  
ATOM    853  OG  SER A 113      25.947 104.165  -0.868  1.00 27.27           O  
ATOM    854  N   PRO A 114      27.178 102.430  -3.235  1.00 20.53           N  
ATOM    855  CA  PRO A 114      28.589 102.270  -3.590  1.00 20.44           C  
ATOM    856  C   PRO A 114      29.502 102.591  -2.411  1.00 20.23           C  
ATOM    857  O   PRO A 114      30.598 102.048  -2.306  1.00 21.49           O  
ATOM    858  CB  PRO A 114      28.755 103.243  -4.750  1.00 19.84           C  
ATOM    859  CG  PRO A 114      27.433 103.135  -5.427  1.00 17.84           C  
ATOM    860  CD  PRO A 114      26.471 103.208  -4.264  1.00 18.05           C  
ATOM    861  N   LEU A 115      29.043 103.470  -1.524  1.00 20.09           N  
ATOM    862  CA  LEU A 115      29.815 103.842  -0.341  1.00 20.79           C  
ATOM    863  C   LEU A 115      29.896 102.661   0.623  1.00 20.75           C  
ATOM    864  O   LEU A 115      30.939 102.401   1.213  1.00 22.50           O  
ATOM    865  CB  LEU A 115      29.168 105.036   0.368  1.00 20.51           C  
ATOM    866  CG  LEU A 115      29.615 105.430   1.788  1.00 18.16           C  
ATOM    867  CD1 LEU A 115      31.068 105.893   1.813  1.00 16.31           C  
ATOM    868  CD2 LEU A 115      28.710 106.552   2.266  1.00 17.58           C  
ATOM    869  N   TYR A 116      28.798 101.939   0.781  1.00 19.37           N  
ATOM    870  CA  TYR A 116      28.820 100.812   1.682  1.00 19.22           C  
ATOM    871  C   TYR A 116      29.599  99.646   1.099  1.00 22.41           C  
ATOM    872  O   TYR A 116      30.112  98.817   1.840  1.00 24.87           O  
ATOM    873  CB  TYR A 116      27.394 100.413   2.085  1.00 18.94           C  
ATOM    874  CG  TYR A 116      26.972 101.096   3.371  1.00 15.96           C  
ATOM    875  CD1 TYR A 116      26.703 102.468   3.396  1.00 15.30           C  
ATOM    876  CD2 TYR A 116      26.953 100.396   4.585  1.00 14.44           C  
ATOM    877  CE1 TYR A 116      26.430 103.133   4.595  1.00 16.01           C  
ATOM    878  CE2 TYR A 116      26.683 101.051   5.792  1.00 15.15           C  
ATOM    879  CZ  TYR A 116      26.422 102.421   5.790  1.00 17.22           C  
ATOM    880  OH  TYR A 116      26.152 103.081   6.972  1.00 16.29           O  
ATOM    881  N   ARG A 117      29.693  99.572  -0.225  1.00 22.90           N  
ATOM    882  CA  ARG A 117      30.489  98.521  -0.835  1.00 23.62           C  
ATOM    883  C   ARG A 117      31.939  98.813  -0.423  1.00 22.92           C  
ATOM    884  O   ARG A 117      32.650  97.933   0.073  1.00 23.94           O  
ATOM    885  CB  ARG A 117      30.354  98.549  -2.361  1.00 24.20           C  
ATOM    886  CG  ARG A 117      28.978  98.142  -2.853  1.00 28.34           C  
ATOM    887  CD  ARG A 117      28.823  98.330  -4.350  1.00 30.65           C  
ATOM    888  NE  ARG A 117      27.440  98.128  -4.765  1.00 32.56           N  
ATOM    889  CZ  ARG A 117      26.880  96.942  -4.970  1.00 34.59           C  
ATOM    890  NH1 ARG A 117      25.604  96.867  -5.335  1.00 31.57           N  
ATOM    891  NH2 ARG A 117      27.601  95.835  -4.836  1.00 35.28           N  
ATOM    892  N   PHE A 118      32.355 100.065  -0.591  1.00 21.67           N  
ATOM    893  CA  PHE A 118      33.711 100.479  -0.241  1.00 22.08           C  
ATOM    894  C   PHE A 118      34.056 100.258   1.230  1.00 21.19           C  
ATOM    895  O   PHE A 118      35.118  99.736   1.540  1.00 20.01           O  
ATOM    896  CB  PHE A 118      33.938 101.952  -0.591  1.00 22.04           C  
ATOM    897  CG  PHE A 118      35.364 102.386  -0.445  1.00 21.96           C  
ATOM    898  CD1 PHE A 118      36.320 102.005  -1.385  1.00 21.19           C  
ATOM    899  CD2 PHE A 118      35.769 103.128   0.657  1.00 19.56           C  
ATOM    900  CE1 PHE A 118      37.658 102.357  -1.228  1.00 18.71           C  
ATOM    901  CE2 PHE A 118      37.112 103.484   0.825  1.00 19.53           C  
ATOM    902  CZ  PHE A 118      38.056 103.098  -0.120  1.00 16.95           C  
ATOM    903  N   LEU A 119      33.170 100.667   2.135  1.00 22.12           N  
ATOM    904  CA  LEU A 119      33.417 100.475   3.567  1.00 21.04           C  
ATOM    905  C   LEU A 119      33.549  98.977   3.893  1.00 21.19           C  
ATOM    906  O   LEU A 119      34.315  98.589   4.769  1.00 19.40           O  
ATOM    907  CB  LEU A 119      32.284 101.087   4.401  1.00 19.03           C  
ATOM    908  CG  LEU A 119      32.031 102.595   4.284  1.00 18.46           C  
ATOM    909  CD1 LEU A 119      30.731 102.930   4.977  1.00 19.55           C  
ATOM    910  CD2 LEU A 119      33.168 103.385   4.892  1.00 21.03           C  
ATOM    911  N   LYS A 120      32.811  98.141   3.176  1.00 21.27           N  
ATOM    912  CA  LYS A 120      32.875  96.700   3.404  1.00 24.56           C  
ATOM    913  C   LYS A 120      34.209  96.124   2.915  1.00 25.62           C  
ATOM    914  O   LYS A 120      34.506  94.945   3.118  1.00 26.17           O  
ATOM    915  CB  LYS A 120      31.729  95.992   2.674  1.00 24.15           C  
ATOM    916  CG  LYS A 120      30.372  96.177   3.295  1.00 21.69           C  
ATOM    917  CD  LYS A 120      29.360  95.373   2.525  1.00 19.18           C  
ATOM    918  CE  LYS A 120      27.939  95.676   2.962  1.00 17.80           C  
ATOM    919  NZ  LYS A 120      26.993  94.794   2.198  1.00 22.50           N  
ATOM    920  N   LEU A 121      34.997  96.967   2.263  1.00 24.38           N  
ATOM    921  CA  LEU A 121      36.297  96.576   1.729  1.00 25.32           C  
ATOM    922  C   LEU A 121      37.356  96.829   2.795  1.00 25.48           C  
ATOM    923  O   LEU A 121      38.429  96.228   2.778  1.00 26.63           O  
ATOM    924  CB  LEU A 121      36.612  97.427   0.500  1.00 24.77           C  
ATOM    925  CG  LEU A 121      37.018  96.827  -0.844  1.00 28.29           C  
ATOM    926  CD1 LEU A 121      36.153  95.628  -1.222  1.00 27.94           C  
ATOM    927  CD2 LEU A 121      36.898  97.938  -1.884  1.00 27.00           C  
ATOM    928  N   GLY A 122      37.032  97.724   3.720  1.00 22.28           N  
ATOM    929  CA  GLY A 122      37.954  98.092   4.776  1.00 22.24           C  
ATOM    930  C   GLY A 122      38.745  97.016   5.501  1.00 22.30           C  
ATOM    931  O   GLY A 122      38.268  95.904   5.726  1.00 19.15           O  
ATOM    932  N   LYS A 123      39.969  97.383   5.881  1.00 22.35           N  
ATOM    933  CA  LYS A 123      40.879  96.498   6.603  1.00 21.97           C  
ATOM    934  C   LYS A 123      41.022  95.143   5.941  1.00 22.36           C  
ATOM    935  O   LYS A 123      40.823  94.096   6.558  1.00 19.01           O  
ATOM    936  CB  LYS A 123      40.406  96.332   8.047  1.00 25.02           C  
ATOM    937  CG  LYS A 123      40.587  97.576   8.889  1.00 24.81           C  
ATOM    938  CD  LYS A 123      42.028  98.027   8.858  1.00 25.41           C  
ATOM    939  CE  LYS A 123      42.190  99.349   9.557  1.00 28.91           C  
ATOM    940  NZ  LYS A 123      43.608  99.778   9.489  1.00 32.89           N  
ATOM    941  N   TRP A 124      41.357  95.180   4.661  1.00 25.79           N  
ATOM    942  CA  TRP A 124      41.535  93.965   3.892  1.00 26.41           C  
ATOM    943  C   TRP A 124      40.403  92.967   4.058  1.00 25.47           C  
ATOM    944  O   TRP A 124      40.635  91.791   4.328  1.00 28.60           O  
ATOM    945  CB  TRP A 124      42.872  93.325   4.257  1.00 27.68           C  
ATOM    946  CG  TRP A 124      43.987  94.246   3.956  1.00 33.87           C  
ATOM    947  CD1 TRP A 124      44.428  95.279   4.732  1.00 35.27           C  
ATOM    948  CD2 TRP A 124      44.728  94.314   2.737  1.00 36.91           C  
ATOM    949  NE1 TRP A 124      45.394  95.990   4.068  1.00 36.85           N  
ATOM    950  CE2 TRP A 124      45.599  95.418   2.839  1.00 39.31           C  
ATOM    951  CE3 TRP A 124      44.741  93.548   1.564  1.00 39.90           C  
ATOM    952  CZ2 TRP A 124      46.472  95.780   1.806  1.00 42.09           C  
ATOM    953  CZ3 TRP A 124      45.607  93.907   0.539  1.00 40.32           C  
ATOM    954  CH2 TRP A 124      46.461  95.013   0.669  1.00 42.80           C  
ATOM    955  N   GLY A 125      39.175  93.434   3.886  1.00 22.18           N  
ATOM    956  CA  GLY A 125      38.043  92.536   3.996  1.00 21.72           C  
ATOM    957  C   GLY A 125      37.551  92.219   5.398  1.00 22.43           C  
ATOM    958  O   GLY A 125      36.488  91.607   5.552  1.00 23.40           O  
ATOM    959  N   ILE A 126      38.296  92.613   6.426  1.00 20.75           N  
ATOM    960  CA  ILE A 126      37.847  92.340   7.779  1.00 20.40           C  
ATOM    961  C   ILE A 126      36.457  92.937   8.004  1.00 21.36           C  
ATOM    962  O   ILE A 126      35.691  92.442   8.823  1.00 22.60           O  
ATOM    963  CB  ILE A 126      38.845  92.882   8.821  1.00 20.92           C  
ATOM    964  CG1 ILE A 126      40.083  91.986   8.825  1.00 20.77           C  
ATOM    965  CG2 ILE A 126      38.208  92.935  10.214  1.00 14.11           C  
ATOM    966  CD1 ILE A 126      41.170  92.462   9.735  1.00 25.17           C  
ATOM    967  N   PHE A 127      36.115  93.974   7.251  1.00 20.65           N  
ATOM    968  CA  PHE A 127      34.807  94.604   7.396  1.00 21.81           C  
ATOM    969  C   PHE A 127      33.857  94.121   6.307  1.00 23.16           C  
ATOM    970  O   PHE A 127      32.831  94.740   6.058  1.00 25.19           O  
ATOM    971  CB  PHE A 127      34.936  96.136   7.324  1.00 20.25           C  
ATOM    972  CG  PHE A 127      35.774  96.739   8.431  1.00 16.25           C  
ATOM    973  CD1 PHE A 127      36.276  98.027   8.309  1.00 15.88           C  
ATOM    974  CD2 PHE A 127      36.071  96.014   9.580  1.00 14.06           C  
ATOM    975  CE1 PHE A 127      37.074  98.593   9.323  1.00 16.52           C  
ATOM    976  CE2 PHE A 127      36.868  96.569  10.600  1.00 15.62           C  
ATOM    977  CZ  PHE A 127      37.369  97.857  10.468  1.00 13.38           C  
ATOM    978  N   GLY A 128      34.195  93.002   5.676  1.00 22.86           N  
ATOM    979  CA  GLY A 128      33.375  92.480   4.600  1.00 22.03           C  
ATOM    980  C   GLY A 128      31.974  92.000   4.925  1.00 22.74           C  
ATOM    981  O   GLY A 128      31.166  91.805   4.022  1.00 24.47           O  
ATOM    982  N   ASP A 129      31.673  91.800   6.199  1.00 22.97           N  
ATOM    983  CA  ASP A 129      30.351  91.330   6.593  1.00 23.52           C  
ATOM    984  C   ASP A 129      29.233  92.265   6.161  1.00 22.74           C  
ATOM    985  O   ASP A 129      29.403  93.479   6.161  1.00 22.19           O  
ATOM    986  CB  ASP A 129      30.275  91.175   8.114  1.00 23.97           C  
ATOM    987  CG  ASP A 129      31.302  90.208   8.654  1.00 25.23           C  
ATOM    988  OD1 ASP A 129      31.967  90.553   9.652  1.00 23.37           O  
ATOM    989  OD2 ASP A 129      31.441  89.107   8.086  1.00 24.40           O  
ATOM    990  N   ASP A 130      28.091  91.692   5.792  1.00 22.81           N  
ATOM    991  CA  ASP A 130      26.920  92.482   5.424  1.00 23.71           C  
ATOM    992  C   ASP A 130      26.533  93.246   6.692  1.00 22.82           C  
ATOM    993  O   ASP A 130      26.917  92.858   7.801  1.00 19.46           O  
ATOM    994  CB  ASP A 130      25.747  91.567   5.036  1.00 28.07           C  
ATOM    995  CG  ASP A 130      25.655  91.301   3.530  1.00 31.64           C  
ATOM    996  OD1 ASP A 130      24.944  90.349   3.158  1.00 33.29           O  
ATOM    997  OD2 ASP A 130      26.267  92.040   2.723  1.00 34.20           O  
ATOM    998  N   ILE A 131      25.784  94.333   6.539  1.00 23.06           N  
ATOM    999  CA  ILE A 131      25.345  95.082   7.702  1.00 22.28           C  
ATOM   1000  C   ILE A 131      24.388  94.139   8.434  1.00 24.10           C  
ATOM   1001  O   ILE A 131      23.427  93.622   7.848  1.00 22.40           O  
ATOM   1002  CB  ILE A 131      24.671  96.397   7.285  1.00 20.97           C  
ATOM   1003  CG1 ILE A 131      25.691  97.260   6.546  1.00 22.56           C  
ATOM   1004  CG2 ILE A 131      24.187  97.172   8.506  1.00 21.57           C  
ATOM   1005  CD1 ILE A 131      27.017  97.435   7.295  1.00 18.40           C  
ATOM   1006  N   GLN A 132      24.675  93.896   9.710  1.00 22.43           N  
ATOM   1007  CA  GLN A 132      23.878  92.961  10.491  1.00 23.26           C  
ATOM   1008  C   GLN A 132      22.486  93.418  10.861  1.00 23.28           C  
ATOM   1009  O   GLN A 132      21.578  92.601  10.944  1.00 21.38           O  
ATOM   1010  CB  GLN A 132      24.618  92.569  11.775  1.00 20.78           C  
ATOM   1011  CG  GLN A 132      25.959  91.950  11.530  1.00 19.65           C  
ATOM   1012  CD  GLN A 132      27.021  92.981  11.263  1.00 21.06           C  
ATOM   1013  OE1 GLN A 132      26.727  94.158  11.042  1.00 19.20           O  
ATOM   1014  NE2 GLN A 132      28.270  92.546  11.271  1.00 24.59           N  
ATOM   1015  N   TRP A 133      22.320  94.716  11.088  1.00 24.88           N  
ATOM   1016  CA  TRP A 133      21.026  95.234  11.488  1.00 26.60           C  
ATOM   1017  C   TRP A 133      21.091  96.748  11.501  1.00 27.11           C  
ATOM   1018  O   TRP A 133      22.048  97.334  11.006  1.00 30.05           O  
ATOM   1019  CB  TRP A 133      20.692  94.710  12.880  1.00 26.82           C  
ATOM   1020  CG  TRP A 133      19.252  94.804  13.266  1.00 29.82           C  
ATOM   1021  CD1 TRP A 133      18.722  95.551  14.281  1.00 29.03           C  
ATOM   1022  CD2 TRP A 133      18.161  94.097  12.675  1.00 29.20           C  
ATOM   1023  NE1 TRP A 133      17.369  95.347  14.359  1.00 29.31           N  
ATOM   1024  CE2 TRP A 133      16.996  94.459  13.385  1.00 29.38           C  
ATOM   1025  CE3 TRP A 133      18.051  93.190  11.614  1.00 31.67           C  
ATOM   1026  CZ2 TRP A 133      15.732  93.945  13.067  1.00 29.72           C  
ATOM   1027  CZ3 TRP A 133      16.793  92.677  11.298  1.00 31.97           C  
ATOM   1028  CH2 TRP A 133      15.651  93.059  12.026  1.00 31.11           C  
ATOM   1029  N   ASN A 134      20.066  97.384  12.049  1.00 26.07           N  
ATOM   1030  CA  ASN A 134      20.052  98.833  12.127  1.00 26.77           C  
ATOM   1031  C   ASN A 134      21.134  99.283  13.078  1.00 26.07           C  
ATOM   1032  O   ASN A 134      21.418  98.612  14.070  1.00 26.44           O  
ATOM   1033  CB  ASN A 134      18.719  99.344  12.673  1.00 27.17           C  
ATOM   1034  CG  ASN A 134      17.555  98.974  11.800  1.00 30.75           C  
ATOM   1035  OD1 ASN A 134      16.554  98.444  12.284  1.00 33.01           O  
ATOM   1036  ND2 ASN A 134      17.668  99.254  10.503  1.00 28.59           N  
ATOM   1037  N   PHE A 135      21.745 100.415  12.764  1.00 24.98           N  
ATOM   1038  CA  PHE A 135      22.752 100.998  13.636  1.00 25.23           C  
ATOM   1039  C   PHE A 135      24.132 100.345  13.725  1.00 24.36           C  
ATOM   1040  O   PHE A 135      24.702 100.234  14.808  1.00 25.47           O  
ATOM   1041  CB  PHE A 135      22.145 101.155  15.040  1.00 24.48           C  
ATOM   1042  CG  PHE A 135      20.839 101.916  15.047  1.00 25.94           C  
ATOM   1043  CD1 PHE A 135      20.819 103.293  14.873  1.00 26.31           C  
ATOM   1044  CD2 PHE A 135      19.627 101.247  15.184  1.00 28.75           C  
ATOM   1045  CE1 PHE A 135      19.611 103.997  14.831  1.00 27.83           C  
ATOM   1046  CE2 PHE A 135      18.413 101.940  15.142  1.00 28.94           C  
ATOM   1047  CZ  PHE A 135      18.405 103.312  14.966  1.00 28.17           C  
ATOM   1048  N   ALA A 136      24.671  99.902  12.596  1.00 21.80           N  
ATOM   1049  CA  ALA A 136      26.020  99.352  12.610  1.00 19.78           C  
ATOM   1050  C   ALA A 136      26.879 100.623  12.534  1.00 19.52           C  
ATOM   1051  O   ALA A 136      26.406 101.650  12.034  1.00 18.52           O  
ATOM   1052  CB  ALA A 136      26.250  98.477  11.399  1.00 20.20           C  
ATOM   1053  N   LYS A 137      28.111 100.579  13.035  1.00 17.06           N  
ATOM   1054  CA  LYS A 137      28.955 101.770  12.999  1.00 17.35           C  
ATOM   1055  C   LYS A 137      30.311 101.570  12.325  1.00 18.19           C  
ATOM   1056  O   LYS A 137      30.894 100.485  12.371  1.00 18.89           O  
ATOM   1057  CB  LYS A 137      29.206 102.316  14.416  1.00 17.81           C  
ATOM   1058  CG  LYS A 137      27.973 102.753  15.229  1.00 18.43           C  
ATOM   1059  CD  LYS A 137      27.293 101.558  15.904  1.00 21.48           C  
ATOM   1060  CE  LYS A 137      26.233 102.004  16.924  1.00 22.63           C  
ATOM   1061  NZ  LYS A 137      25.532 100.854  17.581  1.00 20.10           N  
ATOM   1062  N   PHE A 138      30.798 102.645  11.715  1.00 17.85           N  
ATOM   1063  CA  PHE A 138      32.093 102.692  11.052  1.00 18.26           C  
ATOM   1064  C   PHE A 138      32.747 104.008  11.458  1.00 21.29           C  
ATOM   1065  O   PHE A 138      32.074 105.033  11.595  1.00 23.49           O  
ATOM   1066  CB  PHE A 138      31.961 102.731   9.525  1.00 17.25           C  
ATOM   1067  CG  PHE A 138      31.542 101.444   8.899  1.00 15.79           C  
ATOM   1068  CD1 PHE A 138      32.486 100.547   8.434  1.00 15.53           C  
ATOM   1069  CD2 PHE A 138      30.196 101.148   8.721  1.00 19.79           C  
ATOM   1070  CE1 PHE A 138      32.101  99.375   7.791  1.00 16.54           C  
ATOM   1071  CE2 PHE A 138      29.798  99.972   8.080  1.00 15.70           C  
ATOM   1072  CZ  PHE A 138      30.753  99.091   7.615  1.00 16.90           C  
ATOM   1073  N   LEU A 139      34.057 103.980  11.649  1.00 23.23           N  
ATOM   1074  CA  LEU A 139      34.799 105.192  11.949  1.00 24.18           C  
ATOM   1075  C   LEU A 139      35.782 105.365  10.808  1.00 26.12           C  
ATOM   1076  O   LEU A 139      36.569 104.459  10.515  1.00 28.88           O  
ATOM   1077  CB  LEU A 139      35.556 105.073  13.261  1.00 25.05           C  
ATOM   1078  CG  LEU A 139      34.744 105.339  14.523  1.00 25.39           C  
ATOM   1079  CD1 LEU A 139      35.681 105.303  15.718  1.00 25.04           C  
ATOM   1080  CD2 LEU A 139      34.056 106.696  14.416  1.00 23.72           C  
ATOM   1081  N   VAL A 140      35.716 106.511  10.139  1.00 26.97           N  
ATOM   1082  CA  VAL A 140      36.621 106.791   9.031  1.00 26.70           C  
ATOM   1083  C   VAL A 140      37.532 107.925   9.474  1.00 28.21           C  
ATOM   1084  O   VAL A 140      37.068 108.878  10.098  1.00 28.85           O  
ATOM   1085  CB  VAL A 140      35.839 107.200   7.767  1.00 26.94           C  
ATOM   1086  CG1 VAL A 140      36.793 107.436   6.604  1.00 27.56           C  
ATOM   1087  CG2 VAL A 140      34.845 106.110   7.405  1.00 25.34           C  
ATOM   1088  N   ASN A 141      38.828 107.816   9.175  1.00 29.43           N  
ATOM   1089  CA  ASN A 141      39.787 108.843   9.578  1.00 28.96           C  
ATOM   1090  C   ASN A 141      39.756 110.071   8.692  1.00 30.03           C  
ATOM   1091  O   ASN A 141      39.063 110.104   7.672  1.00 29.42           O  
ATOM   1092  CB  ASN A 141      41.217 108.289   9.609  1.00 28.70           C  
ATOM   1093  CG  ASN A 141      41.703 107.813   8.245  1.00 29.04           C  
ATOM   1094  OD1 ASN A 141      41.397 108.403   7.205  1.00 27.81           O  
ATOM   1095  ND2 ASN A 141      42.487 106.748   8.252  1.00 28.84           N  
ATOM   1096  N   LYS A 142      40.529 111.073   9.098  1.00 30.51           N  
ATOM   1097  CA  LYS A 142      40.629 112.345   8.392  1.00 32.68           C  
ATOM   1098  C   LYS A 142      40.957 112.174   6.914  1.00 32.36           C  
ATOM   1099  O   LYS A 142      40.583 113.007   6.089  1.00 31.89           O  
ATOM   1100  CB  LYS A 142      41.711 113.213   9.042  1.00 34.58           C  
ATOM   1101  CG  LYS A 142      41.500 113.500  10.520  1.00 38.16           C  
ATOM   1102  CD  LYS A 142      42.748 114.132  11.125  1.00 41.89           C  
ATOM   1103  CE  LYS A 142      42.608 114.389  12.628  1.00 44.23           C  
ATOM   1104  NZ  LYS A 142      41.617 115.463  12.952  1.00 46.07           N  
ATOM   1105  N   ASP A 143      41.660 111.095   6.595  1.00 33.23           N  
ATOM   1106  CA  ASP A 143      42.072 110.803   5.227  1.00 35.92           C  
ATOM   1107  C   ASP A 143      41.034 110.086   4.367  1.00 35.22           C  
ATOM   1108  O   ASP A 143      41.234 109.914   3.168  1.00 36.76           O  
ATOM   1109  CB  ASP A 143      43.362 109.982   5.249  1.00 40.16           C  
ATOM   1110  CG  ASP A 143      44.558 110.788   5.731  1.00 43.28           C  
ATOM   1111  OD1 ASP A 143      45.571 110.167   6.133  1.00 44.93           O  
ATOM   1112  OD2 ASP A 143      44.489 112.039   5.698  1.00 44.79           O  
ATOM   1113  N   GLY A 144      39.937 109.649   4.970  1.00 35.02           N  
ATOM   1114  CA  GLY A 144      38.910 108.971   4.201  1.00 32.28           C  
ATOM   1115  C   GLY A 144      38.992 107.454   4.145  1.00 32.14           C  
ATOM   1116  O   GLY A 144      38.296 106.836   3.340  1.00 32.69           O  
ATOM   1117  N   GLN A 145      39.829 106.841   4.976  1.00 29.83           N  
ATOM   1118  CA  GLN A 145      39.927 105.382   4.974  1.00 31.28           C  
ATOM   1119  C   GLN A 145      39.162 104.836   6.175  1.00 30.29           C  
ATOM   1120  O   GLN A 145      39.107 105.482   7.218  1.00 29.68           O  
ATOM   1121  CB  GLN A 145      41.391 104.933   5.051  1.00 32.72           C  
ATOM   1122  CG  GLN A 145      42.290 105.550   3.985  1.00 36.25           C  
ATOM   1123  CD  GLN A 145      41.904 105.161   2.563  1.00 38.39           C  
ATOM   1124  OE1 GLN A 145      42.361 105.782   1.603  1.00 39.93           O  
ATOM   1125  NE2 GLN A 145      41.070 104.128   2.422  1.00 38.34           N  
ATOM   1126  N   VAL A 146      38.566 103.656   6.021  1.00 29.11           N  
ATOM   1127  CA  VAL A 146      37.814 103.032   7.110  1.00 27.41           C  
ATOM   1128  C   VAL A 146      38.804 102.412   8.071  1.00 24.83           C  
ATOM   1129  O   VAL A 146      39.669 101.660   7.653  1.00 25.30           O  
ATOM   1130  CB  VAL A 146      36.910 101.898   6.614  1.00 29.16           C  
ATOM   1131  CG1 VAL A 146      35.704 101.781   7.520  1.00 28.71           C  
ATOM   1132  CG2 VAL A 146      36.497 102.144   5.182  1.00 32.61           C  
ATOM   1133  N   VAL A 147      38.667 102.709   9.356  1.00 24.06           N  
ATOM   1134  CA  VAL A 147      39.577 102.169  10.356  1.00 22.24           C  
ATOM   1135  C   VAL A 147      38.895 101.324  11.429  1.00 22.27           C  
ATOM   1136  O   VAL A 147      39.552 100.526  12.095  1.00 23.33           O  
ATOM   1137  CB  VAL A 147      40.386 103.306  11.025  1.00 23.69           C  
ATOM   1138  CG1 VAL A 147      41.334 103.917  10.014  1.00 21.53           C  
ATOM   1139  CG2 VAL A 147      39.444 104.393  11.546  1.00 24.31           C  
ATOM   1140  N   ASP A 148      37.587 101.488  11.608  1.00 20.68           N  
ATOM   1141  CA  ASP A 148      36.870 100.691  12.604  1.00 19.05           C  
ATOM   1142  C   ASP A 148      35.459 100.323  12.190  1.00 17.01           C  
ATOM   1143  O   ASP A 148      34.843 101.001  11.383  1.00 17.85           O  
ATOM   1144  CB  ASP A 148      36.770 101.429  13.945  1.00 22.24           C  
ATOM   1145  CG  ASP A 148      38.111 101.606  14.627  1.00 23.48           C  
ATOM   1146  OD1 ASP A 148      38.670 102.724  14.567  1.00 19.52           O  
ATOM   1147  OD2 ASP A 148      38.598 100.617  15.218  1.00 25.13           O  
ATOM   1148  N   ARG A 149      34.954  99.239  12.751  1.00 14.90           N  
ATOM   1149  CA  ARG A 149      33.594  98.806  12.503  1.00 16.59           C  
ATOM   1150  C   ARG A 149      33.042  98.244  13.809  1.00 16.99           C  
ATOM   1151  O   ARG A 149      33.745  97.574  14.562  1.00 15.43           O  
ATOM   1152  CB  ARG A 149      33.515  97.740  11.400  1.00 18.90           C  
ATOM   1153  CG  ARG A 149      32.058  97.317  11.097  1.00 20.21           C  
ATOM   1154  CD  ARG A 149      31.912  96.384   9.893  1.00 19.98           C  
ATOM   1155  NE  ARG A 149      30.545  95.873   9.787  1.00 19.62           N  
ATOM   1156  CZ  ARG A 149      30.073  95.169   8.760  1.00 21.53           C  
ATOM   1157  NH1 ARG A 149      30.858  94.885   7.728  1.00 18.49           N  
ATOM   1158  NH2 ARG A 149      28.816  94.736   8.772  1.00 19.77           N  
ATOM   1159  N   TYR A 150      31.777  98.529  14.080  1.00 18.77           N  
ATOM   1160  CA  TYR A 150      31.152  98.060  15.303  1.00 17.70           C  
ATOM   1161  C   TYR A 150      29.827  97.387  15.007  1.00 19.82           C  
ATOM   1162  O   TYR A 150      29.146  97.725  14.039  1.00 21.79           O  
ATOM   1163  CB  TYR A 150      30.950  99.237  16.263  1.00 14.71           C  
ATOM   1164  CG  TYR A 150      32.201 100.071  16.464  1.00 14.15           C  
ATOM   1165  CD1 TYR A 150      32.603 100.997  15.516  1.00 12.27           C  
ATOM   1166  CD2 TYR A 150      33.005  99.893  17.589  1.00 17.59           C  
ATOM   1167  CE1 TYR A 150      33.770 101.725  15.674  1.00 16.74           C  
ATOM   1168  CE2 TYR A 150      34.177 100.611  17.763  1.00 15.81           C  
ATOM   1169  CZ  TYR A 150      34.560 101.526  16.802  1.00 19.21           C  
ATOM   1170  OH  TYR A 150      35.749 102.215  16.950  1.00 19.98           O  
ATOM   1171  N   TYR A 151      29.477  96.409  15.834  1.00 21.95           N  
ATOM   1172  CA  TYR A 151      28.217  95.703  15.680  1.00 22.04           C  
ATOM   1173  C   TYR A 151      27.124  96.651  16.126  1.00 23.17           C  
ATOM   1174  O   TYR A 151      27.363  97.543  16.937  1.00 23.22           O  
ATOM   1175  CB  TYR A 151      28.199  94.426  16.530  1.00 21.82           C  
ATOM   1176  CG  TYR A 151      28.863  93.271  15.839  1.00 22.60           C  
ATOM   1177  CD1 TYR A 151      30.252  93.203  15.736  1.00 24.14           C  
ATOM   1178  CD2 TYR A 151      28.106  92.323  15.153  1.00 24.62           C  
ATOM   1179  CE1 TYR A 151      30.869  92.230  14.950  1.00 24.15           C  
ATOM   1180  CE2 TYR A 151      28.712  91.348  14.368  1.00 23.64           C  
ATOM   1181  CZ  TYR A 151      30.094  91.315  14.268  1.00 22.62           C  
ATOM   1182  OH  TYR A 151      30.700  90.392  13.456  1.00 24.83           O  
ATOM   1183  N   PRO A 152      25.910  96.482  15.587  1.00 24.77           N  
ATOM   1184  CA  PRO A 152      24.779  97.345  15.948  1.00 24.48           C  
ATOM   1185  C   PRO A 152      24.653  97.494  17.462  1.00 23.72           C  
ATOM   1186  O   PRO A 152      24.405  98.584  17.970  1.00 22.26           O  
ATOM   1187  CB  PRO A 152      23.585  96.613  15.340  1.00 23.28           C  
ATOM   1188  CG  PRO A 152      24.188  95.979  14.102  1.00 24.53           C  
ATOM   1189  CD  PRO A 152      25.497  95.435  14.632  1.00 24.54           C  
ATOM   1190  N   THR A 153      24.860  96.385  18.166  1.00 23.45           N  
ATOM   1191  CA  THR A 153      24.755  96.337  19.621  1.00 24.92           C  
ATOM   1192  C   THR A 153      25.735  97.207  20.391  1.00 25.52           C  
ATOM   1193  O   THR A 153      25.529  97.464  21.568  1.00 27.52           O  
ATOM   1194  CB  THR A 153      24.908  94.902  20.135  1.00 24.44           C  
ATOM   1195  OG1 THR A 153      26.226  94.426  19.826  1.00 26.83           O  
ATOM   1196  CG2 THR A 153      23.863  93.990  19.483  1.00 23.04           C  
ATOM   1197  N   THR A 154      26.808  97.650  19.749  1.00 27.13           N  
ATOM   1198  CA  THR A 154      27.780  98.495  20.439  1.00 29.37           C  
ATOM   1199  C   THR A 154      27.245  99.919  20.511  1.00 30.01           C  
ATOM   1200  O   THR A 154      27.112 100.578  19.487  1.00 31.60           O  
ATOM   1201  CB  THR A 154      29.159  98.500  19.710  1.00 30.42           C  
ATOM   1202  OG1 THR A 154      29.755  97.196  19.791  1.00 27.89           O  
ATOM   1203  CG2 THR A 154      30.103  99.523  20.345  1.00 28.93           C  
ATOM   1204  N   SER A 155      26.928 100.390  21.715  1.00 31.18           N  
ATOM   1205  CA  SER A 155      26.398 101.744  21.870  1.00 31.59           C  
ATOM   1206  C   SER A 155      27.439 102.761  21.445  1.00 30.76           C  
ATOM   1207  O   SER A 155      28.636 102.543  21.598  1.00 29.79           O  
ATOM   1208  CB  SER A 155      25.988 102.022  23.317  1.00 32.59           C  
ATOM   1209  OG  SER A 155      27.120 102.249  24.133  1.00 34.73           O  
ATOM   1210  N   PRO A 156      26.985 103.893  20.900  1.00 30.69           N  
ATOM   1211  CA  PRO A 156      27.865 104.963  20.437  1.00 31.98           C  
ATOM   1212  C   PRO A 156      28.910 105.386  21.446  1.00 33.58           C  
ATOM   1213  O   PRO A 156      30.101 105.432  21.133  1.00 37.39           O  
ATOM   1214  CB  PRO A 156      26.891 106.087  20.108  1.00 32.60           C  
ATOM   1215  CG  PRO A 156      25.691 105.327  19.589  1.00 31.99           C  
ATOM   1216  CD  PRO A 156      25.574 104.208  20.610  1.00 31.30           C  
ATOM   1217  N   LEU A 157      28.461 105.695  22.656  1.00 34.05           N  
ATOM   1218  CA  LEU A 157      29.346 106.133  23.726  1.00 34.24           C  
ATOM   1219  C   LEU A 157      30.566 105.226  23.905  1.00 35.24           C  
ATOM   1220  O   LEU A 157      31.620 105.668  24.364  1.00 34.91           O  
ATOM   1221  CB  LEU A 157      28.554 106.216  25.027  1.00 36.13           C  
ATOM   1222  CG  LEU A 157      27.309 107.122  24.998  1.00 37.68           C  
ATOM   1223  CD1 LEU A 157      26.490 106.890  26.260  1.00 36.91           C  
ATOM   1224  CD2 LEU A 157      27.715 108.592  24.879  1.00 36.17           C  
ATOM   1225  N   SER A 158      30.428 103.956  23.538  1.00 34.28           N  
ATOM   1226  CA  SER A 158      31.532 103.018  23.661  1.00 33.84           C  
ATOM   1227  C   SER A 158      32.556 103.187  22.543  1.00 33.77           C  
ATOM   1228  O   SER A 158      33.522 102.438  22.470  1.00 34.32           O  
ATOM   1229  CB  SER A 158      31.015 101.582  23.659  1.00 34.51           C  
ATOM   1230  OG  SER A 158      30.302 101.299  24.853  1.00 36.84           O  
ATOM   1231  N   LEU A 159      32.340 104.171  21.678  1.00 31.13           N  
ATOM   1232  CA  LEU A 159      33.255 104.427  20.579  1.00 32.80           C  
ATOM   1233  C   LEU A 159      34.017 105.709  20.844  1.00 33.81           C  
ATOM   1234  O   LEU A 159      34.824 106.144  20.021  1.00 34.71           O  
ATOM   1235  CB  LEU A 159      32.493 104.583  19.255  1.00 33.71           C  
ATOM   1236  CG  LEU A 159      31.910 103.382  18.501  1.00 34.43           C  
ATOM   1237  CD1 LEU A 159      30.844 102.701  19.330  1.00 32.93           C  
ATOM   1238  CD2 LEU A 159      31.318 103.866  17.181  1.00 33.79           C  
ATOM   1239  N   GLU A 160      33.763 106.322  21.990  1.00 34.26           N  
ATOM   1240  CA  GLU A 160      34.414 107.581  22.303  1.00 34.47           C  
ATOM   1241  C   GLU A 160      35.935 107.500  22.309  1.00 34.36           C  
ATOM   1242  O   GLU A 160      36.608 108.379  21.759  1.00 34.35           O  
ATOM   1243  CB  GLU A 160      33.921 108.131  23.640  1.00 33.89           C  
ATOM   1244  CG  GLU A 160      34.098 109.641  23.743  1.00 37.12           C  
ATOM   1245  CD  GLU A 160      33.496 110.239  25.001  1.00 37.81           C  
ATOM   1246  OE1 GLU A 160      32.333 109.913  25.331  1.00 35.72           O  
ATOM   1247  OE2 GLU A 160      34.187 111.048  25.651  1.00 38.21           O  
ATOM   1248  N   ARG A 161      36.481 106.452  22.918  1.00 33.26           N  
ATOM   1249  CA  ARG A 161      37.928 106.312  22.979  1.00 33.17           C  
ATOM   1250  C   ARG A 161      38.540 106.364  21.588  1.00 33.69           C  
ATOM   1251  O   ARG A 161      39.505 107.099  21.352  1.00 33.75           O  
ATOM   1252  CB  ARG A 161      38.319 105.002  23.661  1.00 34.66           C  
ATOM   1253  CG  ARG A 161      39.824 104.809  23.784  1.00 35.47           C  
ATOM   1254  CD  ARG A 161      40.159 103.586  24.617  1.00 39.55           C  
ATOM   1255  NE  ARG A 161      41.600 103.407  24.758  1.00 46.33           N  
ATOM   1256  CZ  ARG A 161      42.432 103.174  23.744  1.00 48.89           C  
ATOM   1257  NH1 ARG A 161      43.732 103.030  23.972  1.00 49.28           N  
ATOM   1258  NH2 ARG A 161      41.969 103.080  22.504  1.00 49.70           N  
ATOM   1259  N   ASP A 162      37.974 105.589  20.667  1.00 31.58           N  
ATOM   1260  CA  ASP A 162      38.480 105.566  19.303  1.00 32.11           C  
ATOM   1261  C   ASP A 162      38.275 106.913  18.599  1.00 31.93           C  
ATOM   1262  O   ASP A 162      39.105 107.317  17.791  1.00 32.72           O  
ATOM   1263  CB  ASP A 162      37.828 104.422  18.511  1.00 30.10           C  
ATOM   1264  CG  ASP A 162      38.182 103.050  19.066  1.00 32.36           C  
ATOM   1265  OD1 ASP A 162      39.339 102.846  19.485  1.00 32.22           O  
ATOM   1266  OD2 ASP A 162      37.311 102.160  19.077  1.00 35.96           O  
ATOM   1267  N   ILE A 163      37.182 107.607  18.903  1.00 32.64           N  
ATOM   1268  CA  ILE A 163      36.921 108.914  18.301  1.00 34.14           C  
ATOM   1269  C   ILE A 163      38.033 109.872  18.729  1.00 36.80           C  
ATOM   1270  O   ILE A 163      38.698 110.484  17.890  1.00 36.69           O  
ATOM   1271  CB  ILE A 163      35.587 109.517  18.787  1.00 34.59           C  
ATOM   1272  CG1 ILE A 163      34.433 108.533  18.571  1.00 34.43           C  
ATOM   1273  CG2 ILE A 163      35.313 110.822  18.045  1.00 31.34           C  
ATOM   1274  CD1 ILE A 163      33.911 108.491  17.160  1.00 33.65           C  
ATOM   1275  N   LYS A 164      38.228 109.997  20.044  1.00 39.75           N  
ATOM   1276  CA  LYS A 164      39.264 110.879  20.585  1.00 42.50           C  
ATOM   1277  C   LYS A 164      40.618 110.521  20.002  1.00 43.74           C  
ATOM   1278  O   LYS A 164      41.417 111.402  19.682  1.00 42.93           O  
ATOM   1279  CB  LYS A 164      39.334 110.780  22.114  1.00 43.85           C  
ATOM   1280  CG  LYS A 164      38.120 111.342  22.835  1.00 47.23           C  
ATOM   1281  CD  LYS A 164      38.216 111.188  24.350  1.00 47.61           C  
ATOM   1282  CE  LYS A 164      39.276 112.100  24.958  1.00 50.88           C  
ATOM   1283  NZ  LYS A 164      39.227 112.104  26.460  1.00 50.53           N  
ATOM   1284  N   GLN A 165      40.866 109.222  19.857  1.00 44.39           N  
ATOM   1285  CA  GLN A 165      42.127 108.744  19.311  1.00 45.99           C  
ATOM   1286  C   GLN A 165      42.303 109.189  17.855  1.00 46.70           C  
ATOM   1287  O   GLN A 165      43.416 109.480  17.417  1.00 46.97           O  
ATOM   1288  CB  GLN A 165      42.193 107.222  19.412  1.00 47.84           C  
ATOM   1289  CG  GLN A 165      43.597 106.651  19.353  1.00 50.76           C  
ATOM   1290  CD  GLN A 165      43.615 105.135  19.443  1.00 53.92           C  
ATOM   1291  OE1 GLN A 165      42.977 104.542  20.321  1.00 52.86           O  
ATOM   1292  NE2 GLN A 165      44.357 104.496  18.537  1.00 55.18           N  
ATOM   1293  N   LEU A 166      41.210 109.249  17.102  1.00 46.20           N  
ATOM   1294  CA  LEU A 166      41.309 109.682  15.717  1.00 47.59           C  
ATOM   1295  C   LEU A 166      41.363 111.204  15.630  1.00 49.83           C  
ATOM   1296  O   LEU A 166      42.179 111.760  14.898  1.00 51.03           O  
ATOM   1297  CB  LEU A 166      40.140 109.139  14.895  1.00 46.29           C  
ATOM   1298  CG  LEU A 166      40.190 107.632  14.637  1.00 45.89           C  
ATOM   1299  CD1 LEU A 166      38.969 107.204  13.849  1.00 46.50           C  
ATOM   1300  CD2 LEU A 166      41.454 107.285  13.880  1.00 43.46           C  
ATOM   1301  N   LEU A 167      40.500 111.884  16.377  1.00 51.61           N  
ATOM   1302  CA  LEU A 167      40.498 113.343  16.370  1.00 52.56           C  
ATOM   1303  C   LEU A 167      41.792 113.803  17.023  1.00 55.86           C  
ATOM   1304  O   LEU A 167      42.184 114.966  16.901  1.00 56.17           O  
ATOM   1305  CB  LEU A 167      39.321 113.887  17.177  1.00 50.17           C  
ATOM   1306  CG  LEU A 167      37.900 113.512  16.758  1.00 48.91           C  
ATOM   1307  CD1 LEU A 167      36.930 113.982  17.815  1.00 47.65           C  
ATOM   1308  CD2 LEU A 167      37.568 114.131  15.418  1.00 46.39           C  
ATOM   1309  N   GLU A 168      42.449 112.870  17.713  1.00 58.96           N  
ATOM   1310  CA  GLU A 168      43.696 113.141  18.429  1.00 61.45           C  
ATOM   1311  C   GLU A 168      43.402 114.050  19.622  1.00 62.13           C  
ATOM   1312  O   GLU A 168      43.575 115.267  19.553  1.00 62.47           O  
ATOM   1313  CB  GLU A 168      44.720 113.788  17.493  1.00 61.73           C  
ATOM   1314  CG  GLU A 168      45.171 112.862  16.377  1.00 66.06           C  
ATOM   1315  CD  GLU A 168      46.024 113.561  15.331  1.00 68.95           C  
ATOM   1316  OE1 GLU A 168      45.506 114.484  14.663  1.00 70.94           O  
ATOM   1317  OE2 GLU A 168      47.208 113.188  15.175  1.00 69.07           O  
ATOM   1318  N   ILE A 169      42.939 113.445  20.714  1.00 62.83           N  
ATOM   1319  CA  ILE A 169      42.599 114.184  21.926  1.00 63.51           C  
ATOM   1320  C   ILE A 169      42.928 113.383  23.184  1.00 63.89           C  
ATOM   1321  O   ILE A 169      43.736 113.876  24.002  1.00 64.46           O  
ATOM   1322  CB  ILE A 169      41.099 114.533  21.957  1.00 63.51           C  
ATOM   1323  CG1 ILE A 169      40.714 115.310  20.699  1.00 63.17           C  
ATOM   1324  CG2 ILE A 169      40.782 115.358  23.200  1.00 64.03           C  
ATOM   1325  CD1 ILE A 169      39.236 115.568  20.578  1.00 61.40           C  
TER    1326      ILE A 169                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
