
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  188 ( 1508),  selected  188 , name 2ywo_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2ywo_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      E       1           -
LGA    L     2_A      N       2           -
LGA    Q     3_A      L       3           -
LGA    Y     4_A      Y       4           -
LGA    P     5_A      F       5           -
LGA    E     6_A      Q       6           -
LGA    L     7_A      S       7           -
LGA    P     8_A      M       8           -
LGA    L     9_A      -       -           -
LGA    E    10_A      -       -           -
LGA    S    11_A      -       -           -
LGA    P    12_A      I       9           #
LGA    -       -      N      10           -
LGA    L    13_A      S      11          3.155
LGA    I    14_A      F      12          3.336
LGA    D    15_A      Y      13          4.861
LGA    -       -      A      14           -
LGA    A    16_A      F      15          3.306
LGA    E    17_A      E      16          2.409
LGA    L    18_A      V      17          2.375
LGA    P    19_A      K      18          2.204
LGA    D    20_A      D      19          2.546
LGA    P    21_A      A      20          2.276
LGA    R    22_A      K      21          4.476
LGA    G    23_A      G      22           #
LGA    G    24_A      R      23          3.629
LGA    R    25_A      T      24          3.350
LGA    Y    26_A      V      25          2.624
LGA    R    27_A      S      26          2.617
LGA    L    28_A      L      27          2.551
LGA    S    29_A      E      28          2.891
LGA    Q    30_A      K      29          2.445
LGA    F    31_A      Y      30          1.167
LGA    H    32_A      K      31          2.885
LGA    E    33_A      G      32          4.208
LGA    P    34_A      K      33          2.777
LGA    L    35_A      V      34          0.923
LGA    L    36_A      S      35          1.524
LGA    A    37_A      L      36          1.507
LGA    V    38_A      V      37          0.999
LGA    V    39_A      V      38          1.012
LGA    F    40_A      N      39          1.150
LGA    X    41_A      V      40          1.269
LGA    C    42_A      A      41          1.242
LGA    N    43_A      S      42          1.133
LGA    H    44_A      D      43          1.360
LGA    C    45_A      C      44          1.651
LGA    P    46_A      Q      45          1.737
LGA    Y    47_A      L      46          1.520
LGA    V    48_A      T      47          2.782
LGA    K    49_A      D      48          1.886
LGA    G    50_A      R      49          1.293
LGA    S    51_A      N      50          1.873
LGA    I    52_A      Y      51          0.917
LGA    G    53_A      L      52          0.823
LGA    E    54_A      G      53          1.418
LGA    L    55_A      L      54          0.338
LGA    V    56_A      K      55          1.083
LGA    A    57_A      E      56          1.623
LGA    L    58_A      L      57          1.047
LGA    A    59_A      H      58          0.853
LGA    E    60_A      K      59          1.540
LGA    R    61_A      E      60          1.523
LGA    Y    62_A      F      61          1.511
LGA    R    63_A      G      62          1.923
LGA    -       -      P      63           -
LGA    G    64_A      S      64          0.740
LGA    K    65_A      H      65          1.285
LGA    V    66_A      F      66          0.583
LGA    A    67_A      S      67          1.894
LGA    F    68_A      V      68          1.709
LGA    V    69_A      L      69          0.682
LGA    G    70_A      A      70          0.140
LGA    I    71_A      F      71          0.422
LGA    N    72_A      P      72          1.147
LGA    A    73_A      C      73          2.313
LGA    N    74_A      N      74          1.545
LGA    D    75_A      Q      75          4.293
LGA    Y    76_A      F      76           -
LGA    E    77_A      G      77           -
LGA    K    78_A      E      78          5.134
LGA    Y    79_A      -       -           -
LGA    P    80_A      S      79           #
LGA    E    81_A      E      80          4.571
LGA    D    82_A      P      81          3.145
LGA    A    83_A      R      82          1.975
LGA    P    84_A      P      83          2.128
LGA    -       -      S      84           -
LGA    E    85_A      K      85          3.895
LGA    K    86_A      E      86          3.121
LGA    X    87_A      V      87          0.416
LGA    A    88_A      E      88          2.320
LGA    A    89_A      S      89          2.525
LGA    F    90_A      F      90          1.655
LGA    A    91_A      A      91          1.875
LGA    E    92_A      R      92          1.633
LGA    E    93_A      K      93          2.326
LGA    -       -      N      94           -
LGA    H    94_A      Y      95          1.417
LGA    G    95_A      G      96          1.660
LGA    I    96_A      V      97          2.382
LGA    F    97_A      T      98          1.348
LGA    F    98_A      F      99          1.693
LGA    P    99_A      P     100          1.403
LGA    Y   100_A      I     101          0.926
LGA    L   101_A      F     102          1.434
LGA    L   102_A      H     103          2.304
LGA    D   103_A      K     104          3.981
LGA    E   104_A      I     105          3.409
LGA    T   105_A      K     106          4.088
LGA    Q   106_A      I     107          3.355
LGA    -       -      L     108           -
LGA    -       -      G     109           -
LGA    -       -      S     110           -
LGA    -       -      E     111           -
LGA    E   107_A      G     112          1.231
LGA    V   108_A      E     113          2.413
LGA    -       -      P     114           -
LGA    A   109_A      A     115           #
LGA    K   110_A      F     116           #
LGA    A   111_A      R     117          1.085
LGA    -       -      F     118           -
LGA    Y   112_A      L     119          3.012
LGA    R   113_A      V     120          2.726
LGA    -       -      D     121           -
LGA    -       -      S     122           -
LGA    -       -      S     123           -
LGA    -       -      K     124           -
LGA    -       -      K     125           -
LGA    A   114_A      E     126          2.909
LGA    L   115_A      P     127          1.170
LGA    R   116_A      R     128          3.746
LGA    -       -      W     129           -
LGA    T   117_A      N     130          1.810
LGA    P   118_A      F     131          0.827
LGA    E   119_A      W     132          1.191
LGA    V   120_A      K     133          1.178
LGA    F   121_A      Y     134          1.036
LGA    L   122_A      L     135          1.002
LGA    F   123_A      V     136          1.458
LGA    D   124_A      N     137          1.489
LGA    E   125_A      P     138          1.937
LGA    R   126_A      E     139          2.036
LGA    R   127_A      G     140          1.989
LGA    L   128_A      Q     141          1.774
LGA    L   129_A      V     142          1.734
LGA    R   130_A      V     143          1.960
LGA    Y   131_A      K     144          1.830
LGA    H   132_A      F     145          0.925
LGA    G   133_A      W     146          0.868
LGA    R   134_A      R     147          3.790
LGA    -       -      P     148           -
LGA    -       -      E     149           -
LGA    V   135_A      E     150          5.210
LGA    N   136_A      P     151          1.286
LGA    D   137_A      I     152           #
LGA    N   138_A      -       -           -
LGA    P   139_A      -       -           -
LGA    K   140_A      -       -           -
LGA    D   141_A      -       -           -
LGA    P   142_A      -       -           -
LGA    S   143_A      -       -           -
LGA    K   144_A      -       -           -
LGA    V   145_A      -       -           -
LGA    Q   146_A      -       -           -
LGA    S   147_A      -       -           -
LGA    H   148_A      E     153          1.328
LGA    D   149_A      V     154          1.827
LGA    L   150_A      I     155          1.694
LGA    E   151_A      R     156          0.840
LGA    A   152_A      P     157          1.365
LGA    A   153_A      D     158          0.943
LGA    I   154_A      I     159          0.651
LGA    E   155_A      A     160          1.371
LGA    A   156_A      A     161          2.153
LGA    L   157_A      L     162          1.927
LGA    L   158_A      V     163          3.315
LGA    R   159_A      R     164          4.246
LGA    G   160_A      Q     165          4.574
LGA    E   161_A      V     166           -
LGA    E   162_A      I     167           -
LGA    P   163_A      I     168           -
LGA    P   164_A      K     169           -
LGA    L   165_A      K     170           -
LGA    K   166_A      K     171           -
LGA    E   167_A      E     172           -
LGA    A   168_A      D     173           -
LGA    P   169_A      L     174           -
LGA    A   170_A      -       -           -
LGA    I   171_A      -       -           -
LGA    G   172_A      -       -           -
LGA    C   173_A      -       -           -
LGA    T   174_A      -       -           -
LGA    I   175_A      -       -           -
LGA    K   176_A      -       -           -
LGA    W   177_A      -       -           -
LGA    R   178_A      -       -           -
LGA    P   179_A      -       -           -
LGA    G   180_A      -       -           -
LGA    N   181_A      -       -           -
LGA    E   182_A      -       -           -
LGA    P   183_A      -       -           -
LGA    E   184_A      -       -           -
LGA    V   185_A      -       -           -
LGA    R   186_A      -       -           -
LGA    I   187_A      -       -           -
LGA    G   188_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  188  174    5.0    130    2.31    17.69     50.985     5.386

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.578656 * X  +  -0.400495 * Y  +   0.710465 * Z  +   6.590581
  Y_new =  -0.815570 * X  +  -0.282748 * Y  +   0.504875 * Z  + 115.206764
  Z_new =  -0.001317 * X  +  -0.871583 * Y  +  -0.490246 * Z  +  28.558723 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.083169    1.058424  [ DEG:  -119.3568     60.6432 ]
  Theta =   0.001317    3.140275  [ DEG:     0.0755    179.9245 ]
  Phi   =  -0.953716    2.187877  [ DEG:   -54.6439    125.3561 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ywo_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ywo_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  188  174   5.0  130   2.31   17.69  50.985
REMARK  ---------------------------------------------------------- 
MOLECULE 2ywo_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   20-APR-07   2YWO              
TITLE     CRYSTAL STRUCTURE OF REDUCED THIOREDOXIN-LIKE PROTEIN FROM            
TITLE    2 THERMUS THERMOPHILUS HB8                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROBABLE THIOL-DISULFIDE ISOMERASE/THIOREDOXIN;            
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: THIOREDOXIN-LIKE PROTEIN;                                   
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: B834(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-11A                                   
KEYWDS    REDOX PROTEIN, NPPSFA, NATIONAL PROJECT ON PROTEIN                    
KEYWDS   2 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   3 GENOMICS/PROTEOMICS INITIATIVE, RSGI, STRUCTURAL GENOMICS,           
KEYWDS   4 UNKNOWN FUNCTION                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.EBIHARA,M.MANZOKU,S.YOKOYAMA,S.KURAMITSU,RIKEN STRUCTURAL           
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   23-OCT-07 2YWO    0                                                
JRNL        AUTH   A.EBIHARA,M.MANZOKU,S.YOKOYAMA,S.KURAMITSU                   
JRNL        TITL   CRYSTAL STRUCTURE OF REDUCED THIOREDOXIN-LIKE                
JRNL        TITL 2 PROTEIN FROM THERMUS THERMOPHILUS HB8                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2YWO A    1   188  UNP    Q5SKQ0   Q5SKQ0_THET8     1    188             
SEQRES   1 A  188  MSE LEU GLN TYR PRO GLU LEU PRO LEU GLU SER PRO LEU          
SEQRES   2 A  188  ILE ASP ALA GLU LEU PRO ASP PRO ARG GLY GLY ARG TYR          
SEQRES   3 A  188  ARG LEU SER GLN PHE HIS GLU PRO LEU LEU ALA VAL VAL          
SEQRES   4 A  188  PHE MSE CYS ASN HIS CYS PRO TYR VAL LYS GLY SER ILE          
SEQRES   5 A  188  GLY GLU LEU VAL ALA LEU ALA GLU ARG TYR ARG GLY LYS          
SEQRES   6 A  188  VAL ALA PHE VAL GLY ILE ASN ALA ASN ASP TYR GLU LYS          
SEQRES   7 A  188  TYR PRO GLU ASP ALA PRO GLU LYS MSE ALA ALA PHE ALA          
SEQRES   8 A  188  GLU GLU HIS GLY ILE PHE PHE PRO TYR LEU LEU ASP GLU          
SEQRES   9 A  188  THR GLN GLU VAL ALA LYS ALA TYR ARG ALA LEU ARG THR          
SEQRES  10 A  188  PRO GLU VAL PHE LEU PHE ASP GLU ARG ARG LEU LEU ARG          
SEQRES  11 A  188  TYR HIS GLY ARG VAL ASN ASP ASN PRO LYS ASP PRO SER          
SEQRES  12 A  188  LYS VAL GLN SER HIS ASP LEU GLU ALA ALA ILE GLU ALA          
SEQRES  13 A  188  LEU LEU ARG GLY GLU GLU PRO PRO LEU LYS GLU ALA PRO          
SEQRES  14 A  188  ALA ILE GLY CYS THR ILE LYS TRP ARG PRO GLY ASN GLU          
SEQRES  15 A  188  PRO GLU VAL ARG ILE GLY                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  41       8                                                       
HET    MSE  A  87       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *143(H2 O)                                                    
CRYST1   73.490   73.490   97.620  90.00  90.00  90.00 P 41 21 2     8          
HETATM    1  N   MSE A   1      32.751  79.970  -1.204  1.00 49.87           N  
HETATM    2  CA  MSE A   1      33.924  80.880  -1.043  1.00 49.47           C  
HETATM    3  C   MSE A   1      33.573  82.093  -0.179  1.00 45.46           C  
HETATM    4  O   MSE A   1      32.396  82.395   0.028  1.00 43.61           O  
HETATM    5  CB  MSE A   1      34.437  81.334  -2.412  1.00 55.97           C  
HETATM    6  CG  MSE A   1      33.434  82.136  -3.228  1.00 63.35           C  
HETATM    7 SE   MSE A   1      34.163  82.716  -4.922  1.00 75.04          SE  
HETATM    8  CE  MSE A   1      35.307  84.139  -4.281  1.00 70.91           C  
ATOM      9  N   LEU A   2      34.600  82.764   0.341  1.00 41.29           N  
ATOM     10  CA  LEU A   2      34.422  83.944   1.187  1.00 38.36           C  
ATOM     11  C   LEU A   2      33.553  84.995   0.497  1.00 36.01           C  
ATOM     12  O   LEU A   2      33.873  85.452  -0.602  1.00 35.12           O  
ATOM     13  CB  LEU A   2      35.785  84.547   1.536  1.00 39.24           C  
ATOM     14  CG  LEU A   2      35.814  85.775   2.447  1.00 39.52           C  
ATOM     15  CD1 LEU A   2      35.284  85.416   3.825  1.00 39.55           C  
ATOM     16  CD2 LEU A   2      37.238  86.300   2.547  1.00 40.74           C  
ATOM     17  N   GLN A   3      32.449  85.362   1.143  1.00 32.84           N  
ATOM     18  CA  GLN A   3      31.521  86.347   0.592  1.00 31.20           C  
ATOM     19  C   GLN A   3      31.045  87.356   1.635  1.00 29.67           C  
ATOM     20  O   GLN A   3      30.761  86.999   2.779  1.00 26.75           O  
ATOM     21  CB  GLN A   3      30.304  85.651  -0.026  1.00 32.96           C  
ATOM     22  CG  GLN A   3      30.609  84.825  -1.270  1.00 38.46           C  
ATOM     23  CD  GLN A   3      29.399  84.074  -1.788  1.00 39.83           C  
ATOM     24  OE1 GLN A   3      28.336  84.657  -2.008  1.00 42.00           O  
ATOM     25  NE2 GLN A   3      29.554  82.770  -1.989  1.00 42.08           N  
ATOM     26  N   TYR A   4      30.947  88.615   1.211  1.00 26.98           N  
ATOM     27  CA  TYR A   4      30.505  89.725   2.058  1.00 26.61           C  
ATOM     28  C   TYR A   4      31.295  89.880   3.363  1.00 26.49           C  
ATOM     29  O   TYR A   4      30.709  90.043   4.438  1.00 26.20           O  
ATOM     30  CB  TYR A   4      29.004  89.598   2.359  1.00 24.24           C  
ATOM     31  CG  TYR A   4      28.272  90.918   2.537  1.00 25.05           C  
ATOM     32  CD1 TYR A   4      27.931  91.705   1.432  1.00 24.30           C  
ATOM     33  CD2 TYR A   4      27.888  91.362   3.804  1.00 23.20           C  
ATOM     34  CE1 TYR A   4      27.222  92.900   1.585  1.00 22.46           C  
ATOM     35  CE2 TYR A   4      27.176  92.558   3.967  1.00 23.82           C  
ATOM     36  CZ  TYR A   4      26.846  93.317   2.856  1.00 23.31           C  
ATOM     37  OH  TYR A   4      26.123  94.483   3.016  1.00 23.98           O  
ATOM     38  N   PRO A   5      32.637  89.815   3.295  1.00 26.59           N  
ATOM     39  CA  PRO A   5      33.408  89.972   4.533  1.00 27.05           C  
ATOM     40  C   PRO A   5      33.331  91.438   4.960  1.00 25.34           C  
ATOM     41  O   PRO A   5      33.158  92.310   4.118  1.00 24.18           O  
ATOM     42  CB  PRO A   5      34.820  89.591   4.099  1.00 27.00           C  
ATOM     43  CG  PRO A   5      34.873  90.082   2.687  1.00 28.69           C  
ATOM     44  CD  PRO A   5      33.535  89.639   2.136  1.00 28.33           C  
ATOM     45  N   GLU A   6      33.444  91.708   6.257  1.00 26.39           N  
ATOM     46  CA  GLU A   6      33.371  93.086   6.742  1.00 25.83           C  
ATOM     47  C   GLU A   6      34.543  93.903   6.201  1.00 26.64           C  
ATOM     48  O   GLU A   6      35.574  93.345   5.811  1.00 26.54           O  
ATOM     49  CB  GLU A   6      33.383  93.127   8.274  1.00 26.00           C  
ATOM     50  CG  GLU A   6      34.753  92.850   8.894  1.00 27.50           C  
ATOM     51  CD  GLU A   6      34.792  93.034  10.403  1.00 29.58           C  
ATOM     52  OE1 GLU A   6      33.798  93.509  10.998  1.00 30.52           O  
ATOM     53  OE2 GLU A   6      35.838  92.701  10.993  1.00 30.46           O  
ATOM     54  N   LEU A   7      34.368  95.219   6.161  1.00 24.58           N  
ATOM     55  CA  LEU A   7      35.408  96.119   5.685  1.00 26.00           C  
ATOM     56  C   LEU A   7      36.534  96.052   6.719  1.00 25.54           C  
ATOM     57  O   LEU A   7      36.303  96.261   7.908  1.00 26.20           O  
ATOM     58  CB  LEU A   7      34.842  97.538   5.593  1.00 27.34           C  
ATOM     59  CG  LEU A   7      35.394  98.520   4.561  1.00 30.66           C  
ATOM     60  CD1 LEU A   7      35.306  97.923   3.162  1.00 30.48           C  
ATOM     61  CD2 LEU A   7      34.594  99.818   4.640  1.00 30.23           C  
ATOM     62  N   PRO A   8      37.757  95.703   6.288  1.00 25.35           N  
ATOM     63  CA  PRO A   8      38.880  95.614   7.229  1.00 24.89           C  
ATOM     64  C   PRO A   8      39.426  96.973   7.649  1.00 24.15           C  
ATOM     65  O   PRO A   8      39.304  97.953   6.915  1.00 24.25           O  
ATOM     66  CB  PRO A   8      39.917  94.823   6.434  1.00 26.00           C  
ATOM     67  CG  PRO A   8      39.695  95.310   5.041  1.00 26.97           C  
ATOM     68  CD  PRO A   8      38.176  95.318   4.928  1.00 25.84           C  
ATOM     69  N   LEU A   9      40.022  97.030   8.838  1.00 23.30           N  
ATOM     70  CA  LEU A   9      40.606  98.272   9.324  1.00 23.70           C  
ATOM     71  C   LEU A   9      41.667  98.732   8.324  1.00 24.74           C  
ATOM     72  O   LEU A   9      42.271  97.911   7.625  1.00 24.40           O  
ATOM     73  CB  LEU A   9      41.219  98.085  10.716  1.00 23.77           C  
ATOM     74  CG  LEU A   9      40.234  97.776  11.852  1.00 25.91           C  
ATOM     75  CD1 LEU A   9      40.977  97.728  13.183  1.00 27.38           C  
ATOM     76  CD2 LEU A   9      39.138  98.836  11.899  1.00 25.06           C  
ATOM     77  N   GLU A  10      41.848 100.047   8.245  1.00 24.47           N  
ATOM     78  CA  GLU A  10      42.789 100.698   7.338  1.00 26.40           C  
ATOM     79  C   GLU A  10      42.296 100.787   5.897  1.00 26.42           C  
ATOM     80  O   GLU A  10      42.983 101.334   5.033  1.00 26.37           O  
ATOM     81  CB  GLU A  10      44.188 100.065   7.398  1.00 27.62           C  
ATOM     82  CG  GLU A  10      44.926 100.295   8.719  1.00 29.98           C  
ATOM     83  CD  GLU A  10      44.994 101.765   9.129  1.00 30.93           C  
ATOM     84  OE1 GLU A  10      45.018 102.036  10.346  1.00 32.52           O  
ATOM     85  OE2 GLU A  10      45.031 102.650   8.249  1.00 31.56           O  
ATOM     86  N   SER A  11      41.106 100.255   5.633  1.00 26.49           N  
ATOM     87  CA  SER A  11      40.540 100.320   4.290  1.00 27.03           C  
ATOM     88  C   SER A  11      40.140 101.773   4.030  1.00 26.56           C  
ATOM     89  O   SER A  11      39.653 102.462   4.928  1.00 24.75           O  
ATOM     90  CB  SER A  11      39.325  99.394   4.161  1.00 28.81           C  
ATOM     91  OG  SER A  11      38.313  99.748   5.082  1.00 34.46           O  
ATOM     92  N   PRO A  12      40.392 102.273   2.811  1.00 25.95           N  
ATOM     93  CA  PRO A  12      40.056 103.653   2.447  1.00 25.61           C  
ATOM     94  C   PRO A  12      38.555 103.910   2.426  1.00 24.63           C  
ATOM     95  O   PRO A  12      37.758 102.996   2.205  1.00 23.64           O  
ATOM     96  CB  PRO A  12      40.648 103.787   1.040  1.00 27.99           C  
ATOM     97  CG  PRO A  12      41.767 102.776   1.033  1.00 28.89           C  
ATOM     98  CD  PRO A  12      41.120 101.608   1.718  1.00 27.88           C  
ATOM     99  N   LEU A  13      38.180 105.165   2.658  1.00 22.58           N  
ATOM    100  CA  LEU A  13      36.780 105.568   2.640  1.00 21.06           C  
ATOM    101  C   LEU A  13      36.166 105.216   1.288  1.00 22.80           C  
ATOM    102  O   LEU A  13      36.816 105.346   0.248  1.00 21.00           O  
ATOM    103  CB  LEU A  13      36.667 107.078   2.865  1.00 20.99           C  
ATOM    104  CG  LEU A  13      35.290 107.730   2.690  1.00 21.72           C  
ATOM    105  CD1 LEU A  13      34.378 107.349   3.848  1.00 21.90           C  
ATOM    106  CD2 LEU A  13      35.442 109.238   2.618  1.00 22.37           C  
ATOM    107  N   ILE A  14      34.951 104.683   1.317  1.00 21.99           N  
ATOM    108  CA  ILE A  14      34.237 104.346   0.092  1.00 23.89           C  
ATOM    109  C   ILE A  14      33.309 105.527  -0.139  1.00 23.62           C  
ATOM    110  O   ILE A  14      32.335 105.719   0.592  1.00 21.74           O  
ATOM    111  CB  ILE A  14      33.415 103.044   0.243  1.00 24.84           C  
ATOM    112  CG1 ILE A  14      34.357 101.854   0.454  1.00 26.25           C  
ATOM    113  CG2 ILE A  14      32.540 102.820  -0.988  1.00 24.81           C  
ATOM    114  CD1 ILE A  14      33.641 100.536   0.680  1.00 27.16           C  
ATOM    115  N   ASP A  15      33.633 106.340  -1.139  1.00 23.66           N  
ATOM    116  CA  ASP A  15      32.836 107.520  -1.425  1.00 24.05           C  
ATOM    117  C   ASP A  15      31.442 107.199  -1.946  1.00 24.18           C  
ATOM    118  O   ASP A  15      31.195 106.125  -2.502  1.00 24.98           O  
ATOM    119  CB  ASP A  15      33.577 108.442  -2.401  1.00 26.36           C  
ATOM    120  CG  ASP A  15      33.148 109.897  -2.278  1.00 26.92           C  
ATOM    121  OD1 ASP A  15      32.436 110.248  -1.311  1.00 25.57           O  
ATOM    122  OD2 ASP A  15      33.542 110.705  -3.147  1.00 28.20           O  
ATOM    123  N   ALA A  16      30.531 108.137  -1.731  1.00 22.50           N  
ATOM    124  CA  ALA A  16      29.150 108.005  -2.167  1.00 23.85           C  
ATOM    125  C   ALA A  16      28.493 109.371  -2.077  1.00 24.07           C  
ATOM    126  O   ALA A  16      28.884 110.207  -1.262  1.00 21.96           O  
ATOM    127  CB  ALA A  16      28.404 107.006  -1.281  1.00 24.95           C  
ATOM    128  N   GLU A  17      27.536 109.612  -2.963  1.00 23.88           N  
ATOM    129  CA  GLU A  17      26.802 110.865  -2.974  1.00 26.36           C  
ATOM    130  C   GLU A  17      25.348 110.468  -2.844  1.00 25.73           C  
ATOM    131  O   GLU A  17      24.833 109.694  -3.653  1.00 25.48           O  
ATOM    132  CB  GLU A  17      27.031 111.629  -4.279  1.00 30.63           C  
ATOM    133  CG  GLU A  17      26.301 112.961  -4.327  1.00 35.17           C  
ATOM    134  CD  GLU A  17      26.567 113.734  -5.603  1.00 39.15           C  
ATOM    135  OE1 GLU A  17      26.622 113.112  -6.686  1.00 40.89           O  
ATOM    136  OE2 GLU A  17      26.717 114.969  -5.521  1.00 42.44           O  
ATOM    137  N   LEU A  18      24.702 110.962  -1.796  1.00 23.20           N  
ATOM    138  CA  LEU A  18      23.311 110.632  -1.531  1.00 21.80           C  
ATOM    139  C   LEU A  18      22.536 111.865  -1.103  1.00 20.52           C  
ATOM    140  O   LEU A  18      23.111 112.842  -0.627  1.00 21.44           O  
ATOM    141  CB  LEU A  18      23.228 109.572  -0.428  1.00 19.12           C  
ATOM    142  CG  LEU A  18      23.944 108.235  -0.626  1.00 20.91           C  
ATOM    143  CD1 LEU A  18      23.911 107.464   0.688  1.00 20.62           C  
ATOM    144  CD2 LEU A  18      23.287 107.433  -1.743  1.00 19.35           C  
ATOM    145  N   PRO A  19      21.211 111.838  -1.282  1.00 21.64           N  
ATOM    146  CA  PRO A  19      20.367 112.968  -0.905  1.00 21.28           C  
ATOM    147  C   PRO A  19      19.867 112.897   0.534  1.00 21.95           C  
ATOM    148  O   PRO A  19      19.700 111.809   1.095  1.00 19.01           O  
ATOM    149  CB  PRO A  19      19.203 112.839  -1.876  1.00 22.43           C  
ATOM    150  CG  PRO A  19      19.012 111.358  -1.934  1.00 21.74           C  
ATOM    151  CD  PRO A  19      20.441 110.845  -2.058  1.00 22.64           C  
ATOM    152  N   ASP A  20      19.676 114.070   1.128  1.00 23.08           N  
ATOM    153  CA  ASP A  20      19.131 114.198   2.473  1.00 24.18           C  
ATOM    154  C   ASP A  20      17.701 114.656   2.188  1.00 25.89           C  
ATOM    155  O   ASP A  20      17.499 115.664   1.506  1.00 26.44           O  
ATOM    156  CB  ASP A  20      19.880 115.282   3.260  1.00 22.80           C  
ATOM    157  CG  ASP A  20      19.414 115.394   4.709  1.00 24.82           C  
ATOM    158  OD1 ASP A  20      18.190 115.475   4.963  1.00 23.24           O  
ATOM    159  OD2 ASP A  20      20.283 115.412   5.606  1.00 23.38           O  
ATOM    160  N   PRO A  21      16.693 113.922   2.694  1.00 26.62           N  
ATOM    161  CA  PRO A  21      15.277 114.259   2.487  1.00 27.67           C  
ATOM    162  C   PRO A  21      14.887 115.696   2.848  1.00 28.70           C  
ATOM    163  O   PRO A  21      13.876 116.207   2.368  1.00 27.87           O  
ATOM    164  CB  PRO A  21      14.548 113.228   3.356  1.00 28.47           C  
ATOM    165  CG  PRO A  21      15.576 112.853   4.399  1.00 28.41           C  
ATOM    166  CD  PRO A  21      16.821 112.746   3.568  1.00 27.26           C  
ATOM    167  N   ARG A  22      15.693 116.342   3.687  1.00 27.25           N  
ATOM    168  CA  ARG A  22      15.434 117.721   4.091  1.00 28.89           C  
ATOM    169  C   ARG A  22      15.898 118.702   3.015  1.00 29.99           C  
ATOM    170  O   ARG A  22      15.563 119.889   3.055  1.00 31.67           O  
ATOM    171  CB  ARG A  22      16.123 118.027   5.422  1.00 27.29           C  
ATOM    172  CG  ARG A  22      15.517 117.288   6.606  1.00 26.06           C  
ATOM    173  CD  ARG A  22      16.391 117.408   7.852  1.00 24.28           C  
ATOM    174  NE  ARG A  22      17.684 116.745   7.680  1.00 22.37           N  
ATOM    175  CZ  ARG A  22      18.631 116.695   8.615  1.00 24.01           C  
ATOM    176  NH1 ARG A  22      18.433 117.273   9.793  1.00 21.04           N  
ATOM    177  NH2 ARG A  22      19.770 116.059   8.375  1.00 18.43           N  
ATOM    178  N   GLY A  23      16.662 118.194   2.051  1.00 30.53           N  
ATOM    179  CA  GLY A  23      17.149 119.030   0.972  1.00 32.70           C  
ATOM    180  C   GLY A  23      18.634 118.887   0.712  1.00 33.06           C  
ATOM    181  O   GLY A  23      19.421 118.690   1.640  1.00 34.30           O  
ATOM    182  N   GLY A  24      19.008 118.964  -0.561  1.00 33.26           N  
ATOM    183  CA  GLY A  24      20.405 118.860  -0.945  1.00 32.32           C  
ATOM    184  C   GLY A  24      20.966 117.454  -1.033  1.00 32.27           C  
ATOM    185  O   GLY A  24      20.314 116.475  -0.660  1.00 31.94           O  
ATOM    186  N   ARG A  25      22.176 117.363  -1.576  1.00 31.29           N  
ATOM    187  CA  ARG A  25      22.883 116.099  -1.727  1.00 31.04           C  
ATOM    188  C   ARG A  25      24.236 116.239  -1.038  1.00 29.76           C  
ATOM    189  O   ARG A  25      24.781 117.343  -0.943  1.00 27.70           O  
ATOM    190  CB  ARG A  25      23.078 115.758  -3.207  1.00 33.49           C  
ATOM    191  CG  ARG A  25      21.780 115.560  -3.979  1.00 36.72           C  
ATOM    192  CD  ARG A  25      22.045 115.108  -5.407  1.00 39.40           C  
ATOM    193  NE  ARG A  25      22.677 113.791  -5.460  1.00 41.25           N  
ATOM    194  CZ  ARG A  25      22.017 112.636  -5.405  1.00 42.75           C  
ATOM    195  NH1 ARG A  25      20.693 112.622  -5.297  1.00 42.71           N  
ATOM    196  NH2 ARG A  25      22.683 111.490  -5.460  1.00 43.14           N  
ATOM    197  N   TYR A  26      24.760 115.126  -0.532  1.00 27.87           N  
ATOM    198  CA  TYR A  26      26.041 115.134   0.163  1.00 25.55           C  
ATOM    199  C   TYR A  26      26.948 114.003  -0.291  1.00 25.97           C  
ATOM    200  O   TYR A  26      26.495 112.876  -0.520  1.00 25.48           O  
ATOM    201  CB  TYR A  26      25.833 115.035   1.681  1.00 25.33           C  
ATOM    202  CG  TYR A  26      25.123 116.219   2.299  1.00 26.79           C  
ATOM    203  CD1 TYR A  26      25.841 117.235   2.936  1.00 27.19           C  
ATOM    204  CD2 TYR A  26      23.735 116.324   2.250  1.00 25.33           C  
ATOM    205  CE1 TYR A  26      25.191 118.327   3.508  1.00 27.25           C  
ATOM    206  CE2 TYR A  26      23.076 117.410   2.816  1.00 28.92           C  
ATOM    207  CZ  TYR A  26      23.805 118.408   3.442  1.00 28.17           C  
ATOM    208  OH  TYR A  26      23.145 119.481   3.997  1.00 29.54           O  
ATOM    209  N   ARG A  27      28.231 114.317  -0.427  1.00 24.31           N  
ATOM    210  CA  ARG A  27      29.232 113.342  -0.829  1.00 26.28           C  
ATOM    211  C   ARG A  27      30.096 113.080   0.405  1.00 25.64           C  
ATOM    212  O   ARG A  27      30.554 114.019   1.053  1.00 24.86           O  
ATOM    213  CB  ARG A  27      30.069 113.890  -1.991  1.00 28.31           C  
ATOM    214  CG  ARG A  27      31.075 112.903  -2.558  1.00 32.86           C  
ATOM    215  CD  ARG A  27      31.695 113.388  -3.873  1.00 36.49           C  
ATOM    216  NE  ARG A  27      30.806 113.204  -5.020  1.00 38.02           N  
ATOM    217  CZ  ARG A  27      30.592 112.039  -5.632  1.00 40.22           C  
ATOM    218  NH1 ARG A  27      31.203 110.934  -5.214  1.00 38.10           N  
ATOM    219  NH2 ARG A  27      29.762 111.978  -6.666  1.00 40.51           N  
ATOM    220  N   LEU A  28      30.300 111.809   0.741  1.00 24.65           N  
ATOM    221  CA  LEU A  28      31.084 111.451   1.923  1.00 23.24           C  
ATOM    222  C   LEU A  28      32.478 112.076   1.949  1.00 24.35           C  
ATOM    223  O   LEU A  28      32.963 112.473   3.007  1.00 24.64           O  
ATOM    224  CB  LEU A  28      31.177 109.929   2.074  1.00 22.13           C  
ATOM    225  CG  LEU A  28      29.852 109.160   2.188  1.00 19.65           C  
ATOM    226  CD1 LEU A  28      30.139 107.688   2.431  1.00 20.00           C  
ATOM    227  CD2 LEU A  28      28.995 109.719   3.315  1.00 19.21           C  
ATOM    228  N   SER A  29      33.097 112.217   0.781  1.00 23.75           N  
ATOM    229  CA  SER A  29      34.433 112.799   0.696  1.00 24.38           C  
ATOM    230  C   SER A  29      34.471 114.327   0.824  1.00 24.18           C  
ATOM    231  O   SER A  29      35.553 114.908   0.936  1.00 25.49           O  
ATOM    232  CB  SER A  29      35.108 112.376  -0.609  1.00 25.76           C  
ATOM    233  OG  SER A  29      34.385 112.864  -1.721  1.00 25.97           O  
ATOM    234  N   GLN A  30      33.305 114.972   0.832  1.00 23.20           N  
ATOM    235  CA  GLN A  30      33.234 116.434   0.939  1.00 23.61           C  
ATOM    236  C   GLN A  30      33.507 116.951   2.353  1.00 21.95           C  
ATOM    237  O   GLN A  30      33.851 118.118   2.535  1.00 20.23           O  
ATOM    238  CB  GLN A  30      31.870 116.956   0.470  1.00 24.84           C  
ATOM    239  CG  GLN A  30      30.776 116.957   1.549  1.00 27.47           C  
ATOM    240  CD  GLN A  30      29.466 117.547   1.064  1.00 28.46           C  
ATOM    241  OE1 GLN A  30      28.879 117.066   0.097  1.00 28.39           O  
ATOM    242  NE2 GLN A  30      29.001 118.595   1.738  1.00 30.23           N  
ATOM    243  N   PHE A  31      33.290 116.096   3.349  1.00 22.24           N  
ATOM    244  CA  PHE A  31      33.508 116.460   4.744  1.00 22.14           C  
ATOM    245  C   PHE A  31      35.002 116.425   5.006  1.00 22.84           C  
ATOM    246  O   PHE A  31      35.660 115.408   4.767  1.00 23.06           O  
ATOM    247  CB  PHE A  31      32.766 115.486   5.660  1.00 24.39           C  
ATOM    248  CG  PHE A  31      31.305 115.356   5.330  1.00 25.58           C  
ATOM    249  CD1 PHE A  31      30.437 116.419   5.542  1.00 25.91           C  
ATOM    250  CD2 PHE A  31      30.809 114.190   4.764  1.00 26.22           C  
ATOM    251  CE1 PHE A  31      29.096 116.324   5.187  1.00 27.65           C  
ATOM    252  CE2 PHE A  31      29.470 114.084   4.407  1.00 27.24           C  
ATOM    253  CZ  PHE A  31      28.613 115.153   4.618  1.00 27.67           C  
ATOM    254  N   HIS A  32      35.537 117.531   5.509  1.00 21.34           N  
ATOM    255  CA  HIS A  32      36.970 117.612   5.742  1.00 22.44           C  
ATOM    256  C   HIS A  32      37.458 117.677   7.186  1.00 21.78           C  
ATOM    257  O   HIS A  32      38.618 118.008   7.440  1.00 18.90           O  
ATOM    258  CB  HIS A  32      37.556 118.744   4.896  1.00 26.19           C  
ATOM    259  CG  HIS A  32      37.318 118.572   3.426  1.00 28.51           C  
ATOM    260  ND1 HIS A  32      36.687 119.526   2.656  1.00 29.91           N  
ATOM    261  CD2 HIS A  32      37.602 117.543   2.592  1.00 29.31           C  
ATOM    262  CE1 HIS A  32      36.591 119.093   1.412  1.00 29.98           C  
ATOM    263  NE2 HIS A  32      37.139 117.892   1.346  1.00 31.72           N  
ATOM    264  N   GLU A  33      36.588 117.321   8.127  1.00 20.74           N  
ATOM    265  CA  GLU A  33      36.965 117.299   9.541  1.00 18.87           C  
ATOM    266  C   GLU A  33      38.028 116.210   9.698  1.00 18.01           C  
ATOM    267  O   GLU A  33      38.120 115.309   8.862  1.00 18.90           O  
ATOM    268  CB  GLU A  33      35.754 116.958  10.423  1.00 19.27           C  
ATOM    269  CG  GLU A  33      34.803 118.120  10.719  1.00 22.88           C  
ATOM    270  CD  GLU A  33      33.903 118.516   9.546  1.00 25.10           C  
ATOM    271  OE1 GLU A  33      33.938 117.870   8.476  1.00 23.66           O  
ATOM    272  OE2 GLU A  33      33.145 119.493   9.707  1.00 31.13           O  
ATOM    273  N   PRO A  34      38.859 116.293  10.751  1.00 16.58           N  
ATOM    274  CA  PRO A  34      39.913 115.304  11.004  1.00 17.87           C  
ATOM    275  C   PRO A  34      39.378 113.878  10.973  1.00 17.56           C  
ATOM    276  O   PRO A  34      39.977 112.999  10.347  1.00 17.19           O  
ATOM    277  CB  PRO A  34      40.400 115.685  12.402  1.00 17.12           C  
ATOM    278  CG  PRO A  34      40.252 117.169  12.402  1.00 19.97           C  
ATOM    279  CD  PRO A  34      38.891 117.363  11.763  1.00 17.59           C  
ATOM    280  N   LEU A  35      38.244 113.659  11.636  1.00 16.47           N  
ATOM    281  CA  LEU A  35      37.623 112.334  11.680  1.00 16.37           C  
ATOM    282  C   LEU A  35      36.238 112.352  11.029  1.00 16.43           C  
ATOM    283  O   LEU A  35      35.581 113.392  10.964  1.00 15.44           O  
ATOM    284  CB  LEU A  35      37.510 111.842  13.131  1.00 16.08           C  
ATOM    285  CG  LEU A  35      38.770 111.880  14.011  1.00 18.98           C  
ATOM    286  CD1 LEU A  35      38.461 111.315  15.398  1.00 17.80           C  
ATOM    287  CD2 LEU A  35      39.897 111.084  13.364  1.00 19.58           C  
ATOM    288  N   LEU A  36      35.798 111.187  10.558  1.00 15.65           N  
ATOM    289  CA  LEU A  36      34.494 111.047   9.917  1.00 14.92           C  
ATOM    290  C   LEU A  36      33.827 109.770  10.406  1.00 14.54           C  
ATOM    291  O   LEU A  36      34.401 108.690  10.295  1.00 14.21           O  
ATOM    292  CB  LEU A  36      34.647 110.973   8.390  1.00 15.84           C  
ATOM    293  CG  LEU A  36      33.405 110.583   7.571  1.00 15.13           C  
ATOM    294  CD1 LEU A  36      32.320 111.649   7.683  1.00 16.51           C  
ATOM    295  CD2 LEU A  36      33.794 110.386   6.114  1.00 15.35           C  
ATOM    296  N   ALA A  37      32.613 109.905  10.929  1.00 13.80           N  
ATOM    297  CA  ALA A  37      31.849 108.767  11.431  1.00 12.91           C  
ATOM    298  C   ALA A  37      30.627 108.545  10.550  1.00 12.54           C  
ATOM    299  O   ALA A  37      29.731 109.392  10.490  1.00 15.19           O  
ATOM    300  CB  ALA A  37      31.414 109.021  12.884  1.00 12.23           C  
ATOM    301  N   VAL A  38      30.612 107.423   9.843  1.00 12.94           N  
ATOM    302  CA  VAL A  38      29.490 107.079   8.972  1.00 12.85           C  
ATOM    303  C   VAL A  38      28.641 106.064   9.732  1.00 12.38           C  
ATOM    304  O   VAL A  38      29.129 105.002  10.112  1.00 12.18           O  
ATOM    305  CB  VAL A  38      29.981 106.477   7.646  1.00 13.94           C  
ATOM    306  CG1 VAL A  38      28.786 106.139   6.751  1.00 15.75           C  
ATOM    307  CG2 VAL A  38      30.911 107.469   6.946  1.00 15.63           C  
ATOM    308  N   VAL A  39      27.375 106.399   9.956  1.00 12.29           N  
ATOM    309  CA  VAL A  39      26.491 105.524  10.716  1.00 12.58           C  
ATOM    310  C   VAL A  39      25.272 105.037   9.938  1.00 12.72           C  
ATOM    311  O   VAL A  39      24.422 105.831   9.536  1.00 15.10           O  
ATOM    312  CB  VAL A  39      25.977 106.235  11.997  1.00 13.23           C  
ATOM    313  CG1 VAL A  39      25.203 105.262  12.870  1.00 14.05           C  
ATOM    314  CG2 VAL A  39      27.133 106.855  12.772  1.00 14.70           C  
ATOM    315  N   PHE A  40      25.193 103.729   9.723  1.00 12.03           N  
ATOM    316  CA  PHE A  40      24.034 103.156   9.044  1.00 13.83           C  
ATOM    317  C   PHE A  40      22.969 103.011  10.109  1.00 13.61           C  
ATOM    318  O   PHE A  40      23.202 102.423  11.165  1.00 15.96           O  
ATOM    319  CB  PHE A  40      24.387 101.824   8.392  1.00 14.90           C  
ATOM    320  CG  PHE A  40      25.242 101.980   7.170  1.00 16.08           C  
ATOM    321  CD1 PHE A  40      24.656 102.147   5.920  1.00 14.81           C  
ATOM    322  CD2 PHE A  40      26.627 102.018   7.275  1.00 15.80           C  
ATOM    323  CE1 PHE A  40      25.443 102.354   4.790  1.00 17.17           C  
ATOM    324  CE2 PHE A  40      27.425 102.222   6.150  1.00 17.82           C  
ATOM    325  CZ  PHE A  40      26.829 102.393   4.905  1.00 18.16           C  
HETATM  326  N   MSE A  41      21.822 103.624   9.853  1.00 14.67           N  
HETATM  327  CA  MSE A  41      20.730 103.637  10.810  1.00 16.37           C  
HETATM  328  C   MSE A  41      19.378 103.669  10.103  1.00 18.18           C  
HETATM  329  O   MSE A  41      19.278 103.335   8.922  1.00 18.51           O  
HETATM  330  CB  MSE A  41      20.885 104.874  11.711  1.00 17.96           C  
HETATM  331  CG  MSE A  41      21.074 106.170  10.928  1.00 19.28           C  
HETATM  332 SE   MSE A  41      21.379 107.728  12.043  1.00 23.01          SE  
HETATM  333  CE  MSE A  41      19.564 108.037  12.578  1.00 17.45           C  
ATOM    334  N   CYS A  42      18.343 104.040  10.851  1.00 21.06           N  
ATOM    335  CA  CYS A  42      16.981 104.133  10.335  1.00 23.33           C  
ATOM    336  C   CYS A  42      16.110 104.860  11.360  1.00 25.15           C  
ATOM    337  O   CYS A  42      16.616 105.321  12.383  1.00 26.58           O  
ATOM    338  CB  CYS A  42      16.422 102.741  10.014  1.00 22.83           C  
ATOM    339  SG  CYS A  42      16.332 101.598  11.410  1.00 25.05           S  
ATOM    340  N   ASN A  43      14.808 104.946  11.100  1.00 25.82           N  
ATOM    341  CA  ASN A  43      13.891 105.658  11.993  1.00 28.83           C  
ATOM    342  C   ASN A  43      13.153 104.869  13.072  1.00 30.05           C  
ATOM    343  O   ASN A  43      12.717 105.456  14.061  1.00 32.30           O  
ATOM    344  CB  ASN A  43      12.805 106.384  11.189  1.00 26.94           C  
ATOM    345  CG  ASN A  43      13.354 107.276  10.101  1.00 27.63           C  
ATOM    346  OD1 ASN A  43      14.487 107.752  10.165  1.00 27.48           O  
ATOM    347  ND2 ASN A  43      12.532 107.520   9.089  1.00 26.46           N  
ATOM    348  N   HIS A  44      12.957 103.569  12.880  1.00 32.26           N  
ATOM    349  CA  HIS A  44      12.169 102.806  13.850  1.00 33.77           C  
ATOM    350  C   HIS A  44      12.858 101.777  14.736  1.00 32.16           C  
ATOM    351  O   HIS A  44      12.272 101.319  15.718  1.00 32.93           O  
ATOM    352  CB  HIS A  44      10.991 102.138  13.137  1.00 37.81           C  
ATOM    353  CG  HIS A  44      11.373 100.919  12.357  1.00 40.82           C  
ATOM    354  ND1 HIS A  44      12.232 100.961  11.281  1.00 42.71           N  
ATOM    355  CD2 HIS A  44      11.036  99.618  12.519  1.00 43.30           C  
ATOM    356  CE1 HIS A  44      12.411  99.737  10.816  1.00 43.88           C  
ATOM    357  NE2 HIS A  44      11.696  98.903  11.551  1.00 45.01           N  
ATOM    358  N   CYS A  45      14.077 101.390  14.384  1.00 29.50           N  
ATOM    359  CA  CYS A  45      14.807 100.395  15.162  1.00 28.23           C  
ATOM    360  C   CYS A  45      15.023 100.833  16.615  1.00 27.77           C  
ATOM    361  O   CYS A  45      15.520 101.928  16.869  1.00 27.22           O  
ATOM    362  CB  CYS A  45      16.154 100.111  14.499  1.00 29.38           C  
ATOM    363  SG  CYS A  45      17.117  98.844  15.317  1.00 31.06           S  
ATOM    364  N   PRO A  46      14.627  99.990  17.588  1.00 26.47           N  
ATOM    365  CA  PRO A  46      14.800 100.322  19.009  1.00 24.72           C  
ATOM    366  C   PRO A  46      16.267 100.550  19.388  1.00 23.62           C  
ATOM    367  O   PRO A  46      16.567 101.286  20.331  1.00 21.85           O  
ATOM    368  CB  PRO A  46      14.201  99.107  19.728  1.00 26.07           C  
ATOM    369  CG  PRO A  46      14.332  97.993  18.721  1.00 26.53           C  
ATOM    370  CD  PRO A  46      13.970  98.680  17.431  1.00 26.68           C  
ATOM    371  N   TYR A  47      17.175  99.922  18.643  1.00 20.80           N  
ATOM    372  CA  TYR A  47      18.606 100.075  18.886  1.00 20.20           C  
ATOM    373  C   TYR A  47      19.075 101.462  18.451  1.00 20.26           C  
ATOM    374  O   TYR A  47      19.999 102.025  19.040  1.00 19.62           O  
ATOM    375  CB  TYR A  47      19.394  98.987  18.155  1.00 20.84           C  
ATOM    376  CG  TYR A  47      19.111  97.601  18.681  1.00 20.89           C  
ATOM    377  CD1 TYR A  47      19.925  97.028  19.658  1.00 20.67           C  
ATOM    378  CD2 TYR A  47      18.012  96.873  18.225  1.00 21.39           C  
ATOM    379  CE1 TYR A  47      19.647  95.763  20.172  1.00 23.59           C  
ATOM    380  CE2 TYR A  47      17.725  95.606  18.735  1.00 22.32           C  
ATOM    381  CZ  TYR A  47      18.543  95.061  19.705  1.00 21.12           C  
ATOM    382  OH  TYR A  47      18.249  93.826  20.233  1.00 24.27           O  
ATOM    383  N   VAL A  48      18.447 102.002  17.408  1.00 18.63           N  
ATOM    384  CA  VAL A  48      18.783 103.340  16.934  1.00 19.27           C  
ATOM    385  C   VAL A  48      18.086 104.360  17.831  1.00 20.86           C  
ATOM    386  O   VAL A  48      18.694 105.349  18.245  1.00 20.72           O  
ATOM    387  CB  VAL A  48      18.358 103.559  15.466  1.00 19.23           C  
ATOM    388  CG1 VAL A  48      18.566 105.027  15.066  1.00 17.86           C  
ATOM    389  CG2 VAL A  48      19.166 102.655  14.558  1.00 15.92           C  
ATOM    390  N   LYS A  49      16.821 104.102  18.158  1.00 19.94           N  
ATOM    391  CA  LYS A  49      16.056 105.011  19.014  1.00 20.90           C  
ATOM    392  C   LYS A  49      16.703 105.203  20.381  1.00 20.81           C  
ATOM    393  O   LYS A  49      16.668 106.300  20.942  1.00 20.73           O  
ATOM    394  CB  LYS A  49      14.619 104.508  19.199  1.00 22.42           C  
ATOM    395  CG  LYS A  49      13.732 104.656  17.971  1.00 25.99           C  
ATOM    396  CD  LYS A  49      12.344 104.072  18.249  1.00 29.67           C  
ATOM    397  CE  LYS A  49      11.376 104.348  17.111  1.00 31.86           C  
ATOM    398  NZ  LYS A  49      10.005 103.838  17.413  1.00 34.17           N  
ATOM    399  N   GLY A  50      17.299 104.139  20.909  1.00 18.83           N  
ATOM    400  CA  GLY A  50      17.938 104.225  22.209  1.00 19.54           C  
ATOM    401  C   GLY A  50      19.357 104.768  22.192  1.00 18.83           C  
ATOM    402  O   GLY A  50      19.917 105.045  23.252  1.00 19.05           O  
ATOM    403  N   SER A  51      19.941 104.914  21.005  1.00 16.87           N  
ATOM    404  CA  SER A  51      21.315 105.416  20.891  1.00 16.13           C  
ATOM    405  C   SER A  51      21.460 106.701  20.083  1.00 16.94           C  
ATOM    406  O   SER A  51      22.541 107.300  20.061  1.00 15.47           O  
ATOM    407  CB  SER A  51      22.232 104.340  20.300  1.00 16.31           C  
ATOM    408  OG  SER A  51      21.873 104.043  18.960  1.00 19.43           O  
ATOM    409  N   ILE A  52      20.387 107.132  19.424  1.00 16.87           N  
ATOM    410  CA  ILE A  52      20.440 108.351  18.617  1.00 16.70           C  
ATOM    411  C   ILE A  52      20.737 109.585  19.481  1.00 18.05           C  
ATOM    412  O   ILE A  52      21.399 110.517  19.029  1.00 18.49           O  
ATOM    413  CB  ILE A  52      19.152 108.543  17.765  1.00 16.62           C  
ATOM    414  CG1 ILE A  52      19.319 109.726  16.803  1.00 18.33           C  
ATOM    415  CG2 ILE A  52      17.927 108.743  18.657  1.00 17.62           C  
ATOM    416  CD1 ILE A  52      20.490 109.576  15.840  1.00 16.70           C  
ATOM    417  N   GLY A  53      20.287 109.563  20.733  1.00 18.37           N  
ATOM    418  CA  GLY A  53      20.544 110.678  21.629  1.00 17.60           C  
ATOM    419  C   GLY A  53      22.037 110.833  21.837  1.00 18.39           C  
ATOM    420  O   GLY A  53      22.572 111.941  21.748  1.00 17.17           O  
ATOM    421  N   GLU A  54      22.711 109.707  22.074  1.00 17.03           N  
ATOM    422  CA  GLU A  54      24.153 109.683  22.281  1.00 16.76           C  
ATOM    423  C   GLU A  54      24.892 110.089  21.014  1.00 16.07           C  
ATOM    424  O   GLU A  54      25.862 110.843  21.074  1.00 13.72           O  
ATOM    425  CB  GLU A  54      24.611 108.291  22.729  1.00 16.65           C  
ATOM    426  CG  GLU A  54      26.126 108.171  22.887  1.00 16.85           C  
ATOM    427  CD  GLU A  54      26.575 106.892  23.581  1.00 18.44           C  
ATOM    428  OE1 GLU A  54      25.725 106.058  23.966  1.00 18.19           O  
ATOM    429  OE2 GLU A  54      27.796 106.725  23.746  1.00 14.84           O  
ATOM    430  N   LEU A  55      24.445 109.578  19.868  1.00 14.35           N  
ATOM    431  CA  LEU A  55      25.077 109.920  18.594  1.00 13.38           C  
ATOM    432  C   LEU A  55      25.015 111.431  18.340  1.00 13.02           C  
ATOM    433  O   LEU A  55      26.001 112.036  17.916  1.00 14.27           O  
ATOM    434  CB  LEU A  55      24.408 109.164  17.440  1.00 13.53           C  
ATOM    435  CG  LEU A  55      24.697 107.669  17.293  1.00 15.19           C  
ATOM    436  CD1 LEU A  55      23.830 107.084  16.176  1.00 16.48           C  
ATOM    437  CD2 LEU A  55      26.178 107.456  16.982  1.00 13.92           C  
ATOM    438  N   VAL A  56      23.857 112.037  18.596  1.00 13.00           N  
ATOM    439  CA  VAL A  56      23.701 113.476  18.389  1.00 13.06           C  
ATOM    440  C   VAL A  56      24.566 114.252  19.391  1.00 13.74           C  
ATOM    441  O   VAL A  56      25.189 115.257  19.038  1.00 14.08           O  
ATOM    442  CB  VAL A  56      22.215 113.903  18.485  1.00 15.68           C  
ATOM    443  CG1 VAL A  56      22.091 115.427  18.507  1.00 16.62           C  
ATOM    444  CG2 VAL A  56      21.428 113.333  17.284  1.00 12.99           C  
ATOM    445  N   ALA A  57      24.627 113.760  20.626  1.00 14.24           N  
ATOM    446  CA  ALA A  57      25.432 114.396  21.673  1.00 14.25           C  
ATOM    447  C   ALA A  57      26.920 114.332  21.315  1.00 16.11           C  
ATOM    448  O   ALA A  57      27.679 115.268  21.599  1.00 15.06           O  
ATOM    449  CB  ALA A  57      25.180 113.717  23.005  1.00 16.08           C  
ATOM    450  N   LEU A  58      27.334 113.225  20.697  1.00 14.33           N  
ATOM    451  CA  LEU A  58      28.725 113.054  20.282  1.00 15.84           C  
ATOM    452  C   LEU A  58      29.026 114.018  19.140  1.00 16.54           C  
ATOM    453  O   LEU A  58      30.061 114.691  19.142  1.00 16.67           O  
ATOM    454  CB  LEU A  58      28.996 111.610  19.836  1.00 15.41           C  
ATOM    455  CG  LEU A  58      29.067 110.547  20.938  1.00 16.69           C  
ATOM    456  CD1 LEU A  58      29.098 109.154  20.324  1.00 16.40           C  
ATOM    457  CD2 LEU A  58      30.305 110.771  21.805  1.00 16.78           C  
ATOM    458  N   ALA A  59      28.106 114.096  18.180  1.00 14.61           N  
ATOM    459  CA  ALA A  59      28.263 114.997  17.042  1.00 15.35           C  
ATOM    460  C   ALA A  59      28.382 116.438  17.535  1.00 14.91           C  
ATOM    461  O   ALA A  59      29.207 117.204  17.043  1.00 15.30           O  
ATOM    462  CB  ALA A  59      27.075 114.860  16.088  1.00 13.99           C  
ATOM    463  N   GLU A  60      27.574 116.783  18.532  1.00 16.57           N  
ATOM    464  CA  GLU A  60      27.577 118.126  19.110  1.00 18.31           C  
ATOM    465  C   GLU A  60      28.924 118.408  19.773  1.00 17.67           C  
ATOM    466  O   GLU A  60      29.581 119.408  19.472  1.00 15.50           O  
ATOM    467  CB  GLU A  60      26.440 118.253  20.131  1.00 20.05           C  
ATOM    468  CG  GLU A  60      26.270 119.641  20.741  1.00 27.32           C  
ATOM    469  CD  GLU A  60      25.990 120.721  19.707  1.00 30.10           C  
ATOM    470  OE1 GLU A  60      25.119 120.515  18.832  1.00 31.15           O  
ATOM    471  OE2 GLU A  60      26.639 121.788  19.777  1.00 35.03           O  
ATOM    472  N   ARG A  61      29.347 117.498  20.644  1.00 16.58           N  
ATOM    473  CA  ARG A  61      30.617 117.638  21.344  1.00 18.76           C  
ATOM    474  C   ARG A  61      31.811 117.743  20.398  1.00 16.95           C  
ATOM    475  O   ARG A  61      32.751 118.498  20.655  1.00 16.11           O  
ATOM    476  CB  ARG A  61      30.833 116.444  22.278  1.00 20.57           C  
ATOM    477  CG  ARG A  61      32.116 116.510  23.079  1.00 23.14           C  
ATOM    478  CD  ARG A  61      31.810 116.744  24.546  1.00 28.88           C  
ATOM    479  NE  ARG A  61      32.139 115.570  25.336  1.00 30.06           N  
ATOM    480  CZ  ARG A  61      31.836 115.408  26.619  1.00 27.72           C  
ATOM    481  NH1 ARG A  61      31.174 116.344  27.287  1.00 30.06           N  
ATOM    482  NH2 ARG A  61      32.236 114.314  27.244  1.00 29.36           N  
ATOM    483  N   TYR A  62      31.767 116.997  19.300  1.00 15.29           N  
ATOM    484  CA  TYR A  62      32.875 116.987  18.352  1.00 16.16           C  
ATOM    485  C   TYR A  62      32.741 117.858  17.111  1.00 15.93           C  
ATOM    486  O   TYR A  62      33.415 117.598  16.111  1.00 15.63           O  
ATOM    487  CB  TYR A  62      33.196 115.551  17.934  1.00 16.40           C  
ATOM    488  CG  TYR A  62      33.556 114.654  19.098  1.00 19.29           C  
ATOM    489  CD1 TYR A  62      34.578 115.000  19.985  1.00 19.41           C  
ATOM    490  CD2 TYR A  62      32.858 113.473  19.324  1.00 22.83           C  
ATOM    491  CE1 TYR A  62      34.890 114.188  21.071  1.00 23.44           C  
ATOM    492  CE2 TYR A  62      33.161 112.654  20.407  1.00 24.34           C  
ATOM    493  CZ  TYR A  62      34.172 113.014  21.272  1.00 24.63           C  
ATOM    494  OH  TYR A  62      34.463 112.190  22.331  1.00 29.26           O  
ATOM    495  N   ARG A  63      31.890 118.884  17.168  1.00 16.94           N  
ATOM    496  CA  ARG A  63      31.720 119.783  16.023  1.00 19.01           C  
ATOM    497  C   ARG A  63      33.092 120.315  15.618  1.00 19.15           C  
ATOM    498  O   ARG A  63      33.850 120.784  16.465  1.00 18.16           O  
ATOM    499  CB  ARG A  63      30.821 120.974  16.366  1.00 22.09           C  
ATOM    500  CG  ARG A  63      29.335 120.679  16.470  1.00 25.24           C  
ATOM    501  CD  ARG A  63      28.574 121.978  16.692  1.00 26.86           C  
ATOM    502  NE  ARG A  63      27.138 121.780  16.846  1.00 27.31           N  
ATOM    503  CZ  ARG A  63      26.246 121.971  15.879  1.00 28.12           C  
ATOM    504  NH1 ARG A  63      26.640 122.363  14.672  1.00 25.75           N  
ATOM    505  NH2 ARG A  63      24.955 121.796  16.127  1.00 27.55           N  
ATOM    506  N   GLY A  64      33.407 120.199  14.332  1.00 17.24           N  
ATOM    507  CA  GLY A  64      34.684 120.667  13.823  1.00 19.41           C  
ATOM    508  C   GLY A  64      35.822 119.669  13.958  1.00 18.93           C  
ATOM    509  O   GLY A  64      36.886 119.873  13.376  1.00 19.05           O  
ATOM    510  N   LYS A  65      35.595 118.588  14.709  1.00 18.25           N  
ATOM    511  CA  LYS A  65      36.612 117.551  14.920  1.00 16.90           C  
ATOM    512  C   LYS A  65      36.216 116.219  14.279  1.00 15.99           C  
ATOM    513  O   LYS A  65      37.054 115.530  13.699  1.00 16.82           O  
ATOM    514  CB  LYS A  65      36.856 117.338  16.418  1.00 19.36           C  
ATOM    515  CG  LYS A  65      37.353 118.575  17.171  1.00 22.70           C  
ATOM    516  CD  LYS A  65      37.684 118.221  18.618  1.00 26.49           C  
ATOM    517  CE  LYS A  65      38.265 119.406  19.386  1.00 27.78           C  
ATOM    518  NZ  LYS A  65      37.262 120.482  19.613  1.00 29.09           N  
ATOM    519  N   VAL A  66      34.948 115.843  14.441  1.00 14.90           N  
ATOM    520  CA  VAL A  66      34.416 114.604  13.878  1.00 15.13           C  
ATOM    521  C   VAL A  66      33.130 114.904  13.111  1.00 16.45           C  
ATOM    522  O   VAL A  66      32.155 115.387  13.683  1.00 16.67           O  
ATOM    523  CB  VAL A  66      34.062 113.560  14.974  1.00 15.41           C  
ATOM    524  CG1 VAL A  66      33.542 112.267  14.319  1.00 15.40           C  
ATOM    525  CG2 VAL A  66      35.280 113.256  15.850  1.00 15.42           C  
ATOM    526  N   ALA A  67      33.157 114.657  11.807  1.00 15.18           N  
ATOM    527  CA  ALA A  67      31.987 114.867  10.970  1.00 15.55           C  
ATOM    528  C   ALA A  67      31.135 113.606  11.077  1.00 15.22           C  
ATOM    529  O   ALA A  67      31.652 112.501  10.958  1.00 17.53           O  
ATOM    530  CB  ALA A  67      32.411 115.081   9.525  1.00 16.12           C  
ATOM    531  N   PHE A  68      29.845 113.776  11.342  1.00 14.49           N  
ATOM    532  CA  PHE A  68      28.925 112.647  11.440  1.00 13.03           C  
ATOM    533  C   PHE A  68      28.003 112.634  10.230  1.00 13.56           C  
ATOM    534  O   PHE A  68      27.612 113.689   9.722  1.00 13.67           O  
ATOM    535  CB  PHE A  68      28.073 112.743  12.709  1.00 13.94           C  
ATOM    536  CG  PHE A  68      28.729 112.162  13.928  1.00 14.08           C  
ATOM    537  CD1 PHE A  68      28.295 110.946  14.448  1.00 14.98           C  
ATOM    538  CD2 PHE A  68      29.771 112.826  14.557  1.00 14.80           C  
ATOM    539  CE1 PHE A  68      28.893 110.396  15.580  1.00 16.86           C  
ATOM    540  CE2 PHE A  68      30.378 112.285  15.695  1.00 14.67           C  
ATOM    541  CZ  PHE A  68      29.937 111.070  16.204  1.00 16.88           C  
ATOM    542  N   VAL A  69      27.653 111.436   9.780  1.00 13.96           N  
ATOM    543  CA  VAL A  69      26.754 111.266   8.641  1.00 15.06           C  
ATOM    544  C   VAL A  69      25.931 110.005   8.862  1.00 14.34           C  
ATOM    545  O   VAL A  69      26.487 108.929   9.072  1.00 15.73           O  
ATOM    546  CB  VAL A  69      27.518 111.089   7.309  1.00 16.66           C  
ATOM    547  CG1 VAL A  69      26.521 110.946   6.151  1.00 18.85           C  
ATOM    548  CG2 VAL A  69      28.443 112.258   7.054  1.00 18.61           C  
ATOM    549  N   GLY A  70      24.612 110.156   8.871  1.00 13.31           N  
ATOM    550  CA  GLY A  70      23.737 109.011   9.039  1.00 13.30           C  
ATOM    551  C   GLY A  70      23.243 108.556   7.678  1.00 14.93           C  
ATOM    552  O   GLY A  70      23.038 109.385   6.789  1.00 15.30           O  
ATOM    553  N   ILE A  71      23.103 107.245   7.490  1.00 14.61           N  
ATOM    554  CA  ILE A  71      22.620 106.697   6.224  1.00 15.34           C  
ATOM    555  C   ILE A  71      21.533 105.660   6.480  1.00 16.53           C  
ATOM    556  O   ILE A  71      21.748 104.705   7.225  1.00 17.96           O  
ATOM    557  CB  ILE A  71      23.744 106.013   5.413  1.00 14.39           C  
ATOM    558  CG1 ILE A  71      24.872 107.001   5.102  1.00 13.75           C  
ATOM    559  CG2 ILE A  71      23.177 105.438   4.107  1.00 16.33           C  
ATOM    560  CD1 ILE A  71      26.057 106.377   4.371  1.00 11.90           C  
ATOM    561  N   ASN A  72      20.358 105.885   5.895  1.00 15.30           N  
ATOM    562  CA  ASN A  72      19.230 104.963   6.016  1.00 17.49           C  
ATOM    563  C   ASN A  72      19.118 104.225   4.683  1.00 17.88           C  
ATOM    564  O   ASN A  72      18.848 104.840   3.654  1.00 18.71           O  
ATOM    565  CB  ASN A  72      17.933 105.731   6.298  1.00 16.54           C  
ATOM    566  CG  ASN A  72      16.690 104.844   6.215  1.00 20.45           C  
ATOM    567  OD1 ASN A  72      16.755 103.631   6.417  1.00 18.15           O  
ATOM    568  ND2 ASN A  72      15.556 105.454   5.906  1.00 22.65           N  
ATOM    569  N   ALA A  73      19.366 102.919   4.704  1.00 18.23           N  
ATOM    570  CA  ALA A  73      19.295 102.102   3.497  1.00 18.81           C  
ATOM    571  C   ALA A  73      18.074 101.183   3.476  1.00 20.44           C  
ATOM    572  O   ALA A  73      17.850 100.468   2.501  1.00 22.20           O  
ATOM    573  CB  ALA A  73      20.554 101.273   3.368  1.00 18.55           C  
ATOM    574  N   ASN A  74      17.270 101.230   4.533  1.00 19.84           N  
ATOM    575  CA  ASN A  74      16.097 100.364   4.655  1.00 20.05           C  
ATOM    576  C   ASN A  74      15.016 100.436   3.582  1.00 19.45           C  
ATOM    577  O   ASN A  74      14.733 101.493   3.014  1.00 20.08           O  
ATOM    578  CB  ASN A  74      15.457 100.527   6.036  1.00 20.45           C  
ATOM    579  CG  ASN A  74      16.273  99.878   7.141  1.00 19.57           C  
ATOM    580  OD1 ASN A  74      17.331  99.293   6.893  1.00 19.77           O  
ATOM    581  ND2 ASN A  74      15.777  99.967   8.370  1.00 21.22           N  
ATOM    582  N   ASP A  75      14.434  99.272   3.309  1.00 19.11           N  
ATOM    583  CA  ASP A  75      13.354  99.125   2.338  1.00 19.31           C  
ATOM    584  C   ASP A  75      12.126  99.774   2.974  1.00 18.85           C  
ATOM    585  O   ASP A  75      11.427  99.146   3.775  1.00 20.29           O  
ATOM    586  CB  ASP A  75      13.105  97.631   2.089  1.00 18.71           C  
ATOM    587  CG  ASP A  75      11.983  97.366   1.090  1.00 19.91           C  
ATOM    588  OD1 ASP A  75      11.075  98.207   0.925  1.00 19.41           O  
ATOM    589  OD2 ASP A  75      12.008  96.281   0.484  1.00 23.50           O  
ATOM    590  N   TYR A  76      11.855 101.021   2.599  1.00 19.84           N  
ATOM    591  CA  TYR A  76      10.727 101.742   3.171  1.00 21.82           C  
ATOM    592  C   TYR A  76       9.353 101.413   2.601  1.00 23.76           C  
ATOM    593  O   TYR A  76       8.337 101.874   3.124  1.00 23.88           O  
ATOM    594  CB  TYR A  76      10.978 103.255   3.191  1.00 21.55           C  
ATOM    595  CG  TYR A  76      11.238 103.900   1.852  1.00 23.59           C  
ATOM    596  CD1 TYR A  76      10.185 104.398   1.082  1.00 24.29           C  
ATOM    597  CD2 TYR A  76      12.539 104.052   1.369  1.00 21.53           C  
ATOM    598  CE1 TYR A  76      10.420 105.033  -0.136  1.00 26.23           C  
ATOM    599  CE2 TYR A  76      12.785 104.689   0.150  1.00 24.23           C  
ATOM    600  CZ  TYR A  76      11.722 105.174  -0.595  1.00 25.11           C  
ATOM    601  OH  TYR A  76      11.953 105.801  -1.800  1.00 26.19           O  
ATOM    602  N   GLU A  77       9.319 100.639   1.520  1.00 23.71           N  
ATOM    603  CA  GLU A  77       8.039 100.230   0.952  1.00 26.59           C  
ATOM    604  C   GLU A  77       7.464  99.195   1.917  1.00 26.64           C  
ATOM    605  O   GLU A  77       6.266  99.200   2.198  1.00 29.12           O  
ATOM    606  CB  GLU A  77       8.208  99.631  -0.450  1.00 26.56           C  
ATOM    607  CG  GLU A  77       8.272 100.662  -1.584  1.00 28.41           C  
ATOM    608  CD  GLU A  77       9.642 101.303  -1.775  1.00 28.61           C  
ATOM    609  OE1 GLU A  77      10.615 100.876  -1.123  1.00 30.69           O  
ATOM    610  OE2 GLU A  77       9.751 102.228  -2.611  1.00 30.04           O  
ATOM    611  N   LYS A  78       8.345  98.355   2.463  1.00 26.68           N  
ATOM    612  CA  LYS A  78       7.972  97.321   3.425  1.00 28.77           C  
ATOM    613  C   LYS A  78       7.961  97.886   4.850  1.00 29.95           C  
ATOM    614  O   LYS A  78       7.251  97.380   5.722  1.00 29.60           O  
ATOM    615  CB  LYS A  78       8.944  96.138   3.336  1.00 29.99           C  
ATOM    616  CG  LYS A  78       8.642  94.996   4.305  1.00 32.81           C  
ATOM    617  CD  LYS A  78       9.609  93.842   4.120  1.00 33.67           C  
ATOM    618  CE  LYS A  78       9.546  92.856   5.279  1.00 36.87           C  
ATOM    619  NZ  LYS A  78       8.209  92.227   5.441  1.00 38.95           N  
ATOM    620  N   TYR A  79       8.753  98.934   5.074  1.00 29.33           N  
ATOM    621  CA  TYR A  79       8.842  99.595   6.379  1.00 29.97           C  
ATOM    622  C   TYR A  79       8.592 101.090   6.205  1.00 29.02           C  
ATOM    623  O   TYR A  79       9.534 101.871   6.082  1.00 30.02           O  
ATOM    624  CB  TYR A  79      10.223  99.363   7.006  1.00 30.91           C  
ATOM    625  CG  TYR A  79      10.485  97.926   7.382  1.00 33.70           C  
ATOM    626  CD1 TYR A  79      10.171  97.451   8.654  1.00 34.02           C  
ATOM    627  CD2 TYR A  79      11.021  97.030   6.457  1.00 34.02           C  
ATOM    628  CE1 TYR A  79      10.382  96.120   8.995  1.00 37.06           C  
ATOM    629  CE2 TYR A  79      11.232  95.698   6.789  1.00 35.16           C  
ATOM    630  CZ  TYR A  79      10.911  95.250   8.058  1.00 35.74           C  
ATOM    631  OH  TYR A  79      11.112  93.931   8.388  1.00 37.83           O  
ATOM    632  N   PRO A  80       7.311 101.504   6.195  1.00 28.00           N  
ATOM    633  CA  PRO A  80       6.865 102.895   6.033  1.00 28.34           C  
ATOM    634  C   PRO A  80       7.485 103.880   7.022  1.00 27.94           C  
ATOM    635  O   PRO A  80       7.676 105.050   6.695  1.00 29.08           O  
ATOM    636  CB  PRO A  80       5.353 102.792   6.230  1.00 27.98           C  
ATOM    637  CG  PRO A  80       5.046 101.414   5.733  1.00 30.15           C  
ATOM    638  CD  PRO A  80       6.150 100.611   6.365  1.00 28.46           C  
ATOM    639  N   GLU A  81       7.790 103.406   8.228  1.00 28.10           N  
ATOM    640  CA  GLU A  81       8.393 104.256   9.255  1.00 30.12           C  
ATOM    641  C   GLU A  81       9.764 104.778   8.832  1.00 28.81           C  
ATOM    642  O   GLU A  81      10.256 105.760   9.384  1.00 29.84           O  
ATOM    643  CB  GLU A  81       8.526 103.500  10.580  1.00 32.46           C  
ATOM    644  CG  GLU A  81       7.211 103.220  11.293  1.00 36.52           C  
ATOM    645  CD  GLU A  81       7.422 102.695  12.707  1.00 38.96           C  
ATOM    646  OE1 GLU A  81       7.723 101.491  12.860  1.00 41.29           O  
ATOM    647  OE2 GLU A  81       7.293 103.489  13.666  1.00 40.57           O  
ATOM    648  N   ASP A  82      10.374 104.109   7.857  1.00 27.21           N  
ATOM    649  CA  ASP A  82      11.688 104.493   7.350  1.00 25.32           C  
ATOM    650  C   ASP A  82      11.647 105.298   6.049  1.00 24.69           C  
ATOM    651  O   ASP A  82      12.680 105.499   5.414  1.00 25.44           O  
ATOM    652  CB  ASP A  82      12.569 103.251   7.162  1.00 24.18           C  
ATOM    653  CG  ASP A  82      13.003 102.629   8.479  1.00 25.36           C  
ATOM    654  OD1 ASP A  82      13.096 103.353   9.493  1.00 28.20           O  
ATOM    655  OD2 ASP A  82      13.271 101.413   8.499  1.00 23.74           O  
ATOM    656  N   ALA A  83      10.466 105.769   5.660  1.00 24.33           N  
ATOM    657  CA  ALA A  83      10.320 106.555   4.432  1.00 26.08           C  
ATOM    658  C   ALA A  83      11.050 107.900   4.536  1.00 26.81           C  
ATOM    659  O   ALA A  83      11.262 108.409   5.633  1.00 27.11           O  
ATOM    660  CB  ALA A  83       8.841 106.777   4.124  1.00 27.42           C  
ATOM    661  N   PRO A  84      11.443 108.485   3.391  1.00 28.13           N  
ATOM    662  CA  PRO A  84      12.151 109.772   3.340  1.00 29.65           C  
ATOM    663  C   PRO A  84      11.481 110.894   4.139  1.00 32.32           C  
ATOM    664  O   PRO A  84      12.164 111.658   4.824  1.00 31.60           O  
ATOM    665  CB  PRO A  84      12.186 110.076   1.845  1.00 29.60           C  
ATOM    666  CG  PRO A  84      12.322 108.719   1.252  1.00 28.06           C  
ATOM    667  CD  PRO A  84      11.312 107.920   2.035  1.00 28.20           C  
ATOM    668  N   GLU A  85      10.156 110.999   4.052  1.00 33.65           N  
ATOM    669  CA  GLU A  85       9.432 112.027   4.802  1.00 35.79           C  
ATOM    670  C   GLU A  85       9.578 111.792   6.303  1.00 34.40           C  
ATOM    671  O   GLU A  85       9.781 112.735   7.074  1.00 35.15           O  
ATOM    672  CB  GLU A  85       7.953 112.061   4.407  1.00 39.91           C  
ATOM    673  CG  GLU A  85       7.689 112.794   3.094  1.00 45.87           C  
ATOM    674  CD  GLU A  85       6.209 112.927   2.764  1.00 50.02           C  
ATOM    675  OE1 GLU A  85       5.384 113.060   3.696  1.00 51.10           O  
ATOM    676  OE2 GLU A  85       5.872 112.909   1.559  1.00 52.64           O  
ATOM    677  N   LYS A  86       9.512 110.526   6.708  1.00 32.72           N  
ATOM    678  CA  LYS A  86       9.660 110.165   8.111  1.00 32.81           C  
ATOM    679  C   LYS A  86      11.074 110.479   8.600  1.00 31.95           C  
ATOM    680  O   LYS A  86      11.279 110.775   9.776  1.00 30.28           O  
ATOM    681  CB  LYS A  86       9.352 108.680   8.325  1.00 34.83           C  
ATOM    682  CG  LYS A  86       7.879 108.305   8.194  1.00 37.72           C  
ATOM    683  CD  LYS A  86       7.024 109.079   9.188  1.00 40.10           C  
ATOM    684  CE  LYS A  86       5.607 108.523   9.292  1.00 42.98           C  
ATOM    685  NZ  LYS A  86       5.550 107.238  10.053  1.00 44.40           N  
HETATM  686  N   MSE A  87      12.043 110.416   7.689  1.00 30.38           N  
HETATM  687  CA  MSE A  87      13.438 110.701   8.019  1.00 29.68           C  
HETATM  688  C   MSE A  87      13.601 112.152   8.453  1.00 28.80           C  
HETATM  689  O   MSE A  87      14.291 112.441   9.429  1.00 28.19           O  
HETATM  690  CB  MSE A  87      14.346 110.418   6.816  1.00 28.47           C  
HETATM  691  CG  MSE A  87      14.540 108.945   6.505  1.00 28.81           C  
HETATM  692 SE   MSE A  87      15.646 108.660   4.945  1.00 28.92          SE  
HETATM  693  CE  MSE A  87      17.260 109.562   5.543  1.00 27.92           C  
ATOM    694  N   ALA A  88      12.959 113.058   7.721  1.00 28.70           N  
ATOM    695  CA  ALA A  88      13.017 114.484   8.022  1.00 28.48           C  
ATOM    696  C   ALA A  88      12.430 114.785   9.401  1.00 29.17           C  
ATOM    697  O   ALA A  88      12.965 115.611  10.146  1.00 27.66           O  
ATOM    698  CB  ALA A  88      12.278 115.278   6.946  1.00 30.54           C  
ATOM    699  N   ALA A  89      11.335 114.104   9.735  1.00 28.98           N  
ATOM    700  CA  ALA A  89      10.668 114.284  11.021  1.00 28.44           C  
ATOM    701  C   ALA A  89      11.485 113.674  12.161  1.00 27.76           C  
ATOM    702  O   ALA A  89      11.501 114.199  13.277  1.00 26.92           O  
ATOM    703  CB  ALA A  89       9.270 113.669  10.980  1.00 30.35           C  
ATOM    704  N   PHE A  90      12.152 112.558  11.877  1.00 25.55           N  
ATOM    705  CA  PHE A  90      12.981 111.871  12.866  1.00 24.04           C  
ATOM    706  C   PHE A  90      14.178 112.756  13.222  1.00 23.66           C  
ATOM    707  O   PHE A  90      14.524 112.917  14.400  1.00 21.37           O  
ATOM    708  CB  PHE A  90      13.453 110.530  12.298  1.00 25.27           C  
ATOM    709  CG  PHE A  90      14.177 109.662  13.286  1.00 24.89           C  
ATOM    710  CD1 PHE A  90      13.476 108.949  14.255  1.00 25.96           C  
ATOM    711  CD2 PHE A  90      15.561 109.534  13.232  1.00 23.14           C  
ATOM    712  CE1 PHE A  90      14.145 108.119  15.153  1.00 23.30           C  
ATOM    713  CE2 PHE A  90      16.237 108.707  14.126  1.00 22.75           C  
ATOM    714  CZ  PHE A  90      15.529 107.998  15.087  1.00 23.68           C  
ATOM    715  N   ALA A  91      14.798 113.334  12.197  1.00 23.15           N  
ATOM    716  CA  ALA A  91      15.944 114.217  12.379  1.00 24.05           C  
ATOM    717  C   ALA A  91      15.538 115.444  13.195  1.00 25.28           C  
ATOM    718  O   ALA A  91      16.306 115.929  14.027  1.00 24.33           O  
ATOM    719  CB  ALA A  91      16.499 114.640  11.026  1.00 20.71           C  
ATOM    720  N   GLU A  92      14.323 115.932  12.956  1.00 27.00           N  
ATOM    721  CA  GLU A  92      13.793 117.091  13.672  1.00 29.66           C  
ATOM    722  C   GLU A  92      13.536 116.744  15.136  1.00 29.45           C  
ATOM    723  O   GLU A  92      13.908 117.500  16.033  1.00 29.64           O  
ATOM    724  CB  GLU A  92      12.501 117.576  13.000  1.00 33.24           C  
ATOM    725  CG  GLU A  92      11.662 118.563  13.814  1.00 38.77           C  
ATOM    726  CD  GLU A  92      12.344 119.902  14.033  1.00 43.23           C  
ATOM    727  OE1 GLU A  92      12.729 120.552  13.035  1.00 44.92           O  
ATOM    728  OE2 GLU A  92      12.479 120.312  15.206  1.00 45.39           O  
ATOM    729  N   GLU A  93      12.925 115.585  15.367  1.00 28.67           N  
ATOM    730  CA  GLU A  93      12.605 115.117  16.712  1.00 29.98           C  
ATOM    731  C   GLU A  93      13.835 114.828  17.576  1.00 27.70           C  
ATOM    732  O   GLU A  93      13.796 115.006  18.795  1.00 27.26           O  
ATOM    733  CB  GLU A  93      11.739 113.854  16.636  1.00 32.91           C  
ATOM    734  CG  GLU A  93      11.321 113.309  18.001  1.00 39.98           C  
ATOM    735  CD  GLU A  93      10.695 111.920  17.943  1.00 43.85           C  
ATOM    736  OE1 GLU A  93      10.731 111.270  16.872  1.00 46.42           O  
ATOM    737  OE2 GLU A  93      10.174 111.469  18.987  1.00 45.69           O  
ATOM    738  N   HIS A  94      14.924 114.400  16.947  1.00 24.89           N  
ATOM    739  CA  HIS A  94      16.140 114.064  17.684  1.00 23.42           C  
ATOM    740  C   HIS A  94      17.307 115.025  17.530  1.00 22.43           C  
ATOM    741  O   HIS A  94      18.414 114.736  17.987  1.00 24.31           O  
ATOM    742  CB  HIS A  94      16.574 112.644  17.340  1.00 21.82           C  
ATOM    743  CG  HIS A  94      15.574 111.610  17.741  1.00 23.21           C  
ATOM    744  ND1 HIS A  94      15.426 111.186  19.044  1.00 21.86           N  
ATOM    745  CD2 HIS A  94      14.642 110.946  17.019  1.00 22.96           C  
ATOM    746  CE1 HIS A  94      14.445 110.304  19.107  1.00 24.83           C  
ATOM    747  NE2 HIS A  94      13.952 110.140  17.892  1.00 23.04           N  
ATOM    748  N   GLY A  95      17.050 116.174  16.918  1.00 22.23           N  
ATOM    749  CA  GLY A  95      18.091 117.164  16.724  1.00 21.76           C  
ATOM    750  C   GLY A  95      19.273 116.690  15.896  1.00 22.08           C  
ATOM    751  O   GLY A  95      20.414 117.057  16.185  1.00 17.60           O  
ATOM    752  N   ILE A  96      19.012 115.861  14.884  1.00 19.88           N  
ATOM    753  CA  ILE A  96      20.076 115.361  14.013  1.00 19.42           C  
ATOM    754  C   ILE A  96      20.465 116.493  13.061  1.00 19.92           C  
ATOM    755  O   ILE A  96      19.899 116.633  11.971  1.00 18.97           O  
ATOM    756  CB  ILE A  96      19.622 114.110  13.201  1.00 17.30           C  
ATOM    757  CG1 ILE A  96      19.171 112.997  14.152  1.00 16.71           C  
ATOM    758  CG2 ILE A  96      20.777 113.600  12.338  1.00 17.83           C  
ATOM    759  CD1 ILE A  96      18.585 111.766  13.463  1.00 17.33           C  
ATOM    760  N   PHE A  97      21.405 117.327  13.501  1.00 19.19           N  
ATOM    761  CA  PHE A  97      21.847 118.464  12.700  1.00 18.74           C  
ATOM    762  C   PHE A  97      22.754 118.077  11.544  1.00 18.62           C  
ATOM    763  O   PHE A  97      22.883 118.829  10.575  1.00 17.81           O  
ATOM    764  CB  PHE A  97      22.535 119.518  13.580  1.00 20.10           C  
ATOM    765  CG  PHE A  97      23.820 119.050  14.208  1.00 19.63           C  
ATOM    766  CD1 PHE A  97      25.031 119.221  13.548  1.00 19.63           C  
ATOM    767  CD2 PHE A  97      23.818 118.453  15.462  1.00 19.67           C  
ATOM    768  CE1 PHE A  97      26.221 118.803  14.128  1.00 20.81           C  
ATOM    769  CE2 PHE A  97      25.008 118.030  16.053  1.00 20.49           C  
ATOM    770  CZ  PHE A  97      26.204 118.205  15.389  1.00 19.14           C  
ATOM    771  N   PHE A  98      23.401 116.922  11.664  1.00 16.69           N  
ATOM    772  CA  PHE A  98      24.302 116.443  10.628  1.00 16.90           C  
ATOM    773  C   PHE A  98      23.498 115.773   9.510  1.00 16.72           C  
ATOM    774  O   PHE A  98      22.316 115.464   9.693  1.00 17.04           O  
ATOM    775  CB  PHE A  98      25.373 115.510  11.225  1.00 15.54           C  
ATOM    776  CG  PHE A  98      24.823 114.347  12.014  1.00 16.24           C  
ATOM    777  CD1 PHE A  98      24.479 113.153  11.382  1.00 16.12           C  
ATOM    778  CD2 PHE A  98      24.714 114.421  13.402  1.00 17.50           C  
ATOM    779  CE1 PHE A  98      24.042 112.052  12.111  1.00 16.20           C  
ATOM    780  CE2 PHE A  98      24.279 113.325  14.146  1.00 16.86           C  
ATOM    781  CZ  PHE A  98      23.942 112.136  13.500  1.00 17.35           C  
ATOM    782  N   PRO A  99      24.113 115.560   8.336  1.00 16.55           N  
ATOM    783  CA  PRO A  99      23.394 114.929   7.226  1.00 16.14           C  
ATOM    784  C   PRO A  99      22.873 113.530   7.532  1.00 15.82           C  
ATOM    785  O   PRO A  99      23.564 112.715   8.143  1.00 15.51           O  
ATOM    786  CB  PRO A  99      24.444 114.897   6.114  1.00 18.29           C  
ATOM    787  CG  PRO A  99      25.305 116.072   6.426  1.00 19.81           C  
ATOM    788  CD  PRO A  99      25.470 115.948   7.915  1.00 18.13           C  
ATOM    789  N   TYR A 100      21.628 113.290   7.133  1.00 16.16           N  
ATOM    790  CA  TYR A 100      20.956 112.006   7.306  1.00 14.86           C  
ATOM    791  C   TYR A 100      20.543 111.665   5.870  1.00 15.49           C  
ATOM    792  O   TYR A 100      19.595 112.243   5.329  1.00 17.42           O  
ATOM    793  CB  TYR A 100      19.734 112.173   8.208  1.00 14.63           C  
ATOM    794  CG  TYR A 100      19.031 110.879   8.559  1.00 15.46           C  
ATOM    795  CD1 TYR A 100      19.678 109.648   8.431  1.00 13.67           C  
ATOM    796  CD2 TYR A 100      17.715 110.888   9.023  1.00 16.00           C  
ATOM    797  CE1 TYR A 100      19.028 108.459   8.755  1.00 14.39           C  
ATOM    798  CE2 TYR A 100      17.060 109.706   9.349  1.00 14.97           C  
ATOM    799  CZ  TYR A 100      17.721 108.500   9.212  1.00 13.43           C  
ATOM    800  OH  TYR A 100      17.069 107.332   9.526  1.00 15.94           O  
ATOM    801  N   LEU A 101      21.276 110.738   5.265  1.00 14.83           N  
ATOM    802  CA  LEU A 101      21.082 110.376   3.864  1.00 16.51           C  
ATOM    803  C   LEU A 101      20.308 109.095   3.548  1.00 17.26           C  
ATOM    804  O   LEU A 101      20.349 108.122   4.299  1.00 16.66           O  
ATOM    805  CB  LEU A 101      22.456 110.324   3.191  1.00 16.66           C  
ATOM    806  CG  LEU A 101      23.383 111.488   3.561  1.00 17.98           C  
ATOM    807  CD1 LEU A 101      24.776 111.261   3.001  1.00 16.20           C  
ATOM    808  CD2 LEU A 101      22.789 112.791   3.050  1.00 16.19           C  
ATOM    809  N   LEU A 102      19.604 109.121   2.418  1.00 17.68           N  
ATOM    810  CA  LEU A 102      18.822 107.984   1.950  1.00 19.81           C  
ATOM    811  C   LEU A 102      19.617 107.192   0.926  1.00 19.99           C  
ATOM    812  O   LEU A 102      20.080 107.744  -0.070  1.00 20.48           O  
ATOM    813  CB  LEU A 102      17.510 108.457   1.305  1.00 22.30           C  
ATOM    814  CG  LEU A 102      16.672 107.370   0.611  1.00 22.33           C  
ATOM    815  CD1 LEU A 102      16.084 106.412   1.638  1.00 22.57           C  
ATOM    816  CD2 LEU A 102      15.564 108.011  -0.212  1.00 25.14           C  
ATOM    817  N   ASP A 103      19.800 105.905   1.202  1.00 19.40           N  
ATOM    818  CA  ASP A 103      20.507 104.992   0.308  1.00 20.48           C  
ATOM    819  C   ASP A 103      19.405 104.117  -0.302  1.00 22.22           C  
ATOM    820  O   ASP A 103      19.220 102.956   0.077  1.00 21.16           O  
ATOM    821  CB  ASP A 103      21.510 104.153   1.113  1.00 19.69           C  
ATOM    822  CG  ASP A 103      22.278 103.144   0.261  1.00 20.01           C  
ATOM    823  OD1 ASP A 103      22.337 103.284  -0.976  1.00 18.89           O  
ATOM    824  OD2 ASP A 103      22.840 102.198   0.848  1.00 19.08           O  
ATOM    825  N   GLU A 104      18.672 104.704  -1.245  1.00 24.43           N  
ATOM    826  CA  GLU A 104      17.554 104.047  -1.923  1.00 26.26           C  
ATOM    827  C   GLU A 104      17.894 102.706  -2.580  1.00 26.84           C  
ATOM    828  O   GLU A 104      17.165 101.728  -2.408  1.00 27.53           O  
ATOM    829  CB  GLU A 104      16.941 105.007  -2.954  1.00 30.78           C  
ATOM    830  CG  GLU A 104      15.401 104.979  -3.049  1.00 34.47           C  
ATOM    831  CD  GLU A 104      14.854 103.819  -3.866  1.00 37.27           C  
ATOM    832  OE1 GLU A 104      15.622 103.206  -4.637  1.00 43.22           O  
ATOM    833  OE2 GLU A 104      13.644 103.532  -3.754  1.00 39.62           O  
ATOM    834  N   THR A 105      18.993 102.652  -3.326  1.00 24.73           N  
ATOM    835  CA  THR A 105      19.383 101.417  -4.003  1.00 25.11           C  
ATOM    836  C   THR A 105      20.023 100.396  -3.066  1.00 23.85           C  
ATOM    837  O   THR A 105      20.129  99.220  -3.410  1.00 21.74           O  
ATOM    838  CB  THR A 105      20.371 101.679  -5.154  1.00 25.06           C  
ATOM    839  OG1 THR A 105      21.616 102.144  -4.617  1.00 22.70           O  
ATOM    840  CG2 THR A 105      19.812 102.716  -6.118  1.00 25.87           C  
ATOM    841  N   GLN A 106      20.433 100.860  -1.885  1.00 22.26           N  
ATOM    842  CA  GLN A 106      21.086 100.036  -0.869  1.00 20.59           C  
ATOM    843  C   GLN A 106      22.500  99.630  -1.279  1.00 20.79           C  
ATOM    844  O   GLN A 106      23.129  98.809  -0.616  1.00 19.53           O  
ATOM    845  CB  GLN A 106      20.258  98.786  -0.533  1.00 22.25           C  
ATOM    846  CG  GLN A 106      18.830  99.081  -0.117  1.00 21.52           C  
ATOM    847  CD  GLN A 106      18.104  97.850   0.374  1.00 23.44           C  
ATOM    848  OE1 GLN A 106      18.262  96.758  -0.177  1.00 22.57           O  
ATOM    849  NE2 GLN A 106      17.310  98.016   1.423  1.00 23.55           N  
ATOM    850  N   GLU A 107      23.001 100.212  -2.368  1.00 19.55           N  
ATOM    851  CA  GLU A 107      24.343  99.891  -2.836  1.00 21.18           C  
ATOM    852  C   GLU A 107      25.446 100.472  -1.953  1.00 19.70           C  
ATOM    853  O   GLU A 107      26.551  99.939  -1.924  1.00 20.02           O  
ATOM    854  CB  GLU A 107      24.539 100.310  -4.300  1.00 26.06           C  
ATOM    855  CG  GLU A 107      23.665  99.537  -5.302  1.00 32.22           C  
ATOM    856  CD  GLU A 107      23.805  98.016  -5.196  1.00 37.03           C  
ATOM    857  OE1 GLU A 107      24.946  97.506  -5.120  1.00 38.80           O  
ATOM    858  OE2 GLU A 107      22.761  97.324  -5.199  1.00 40.68           O  
ATOM    859  N   VAL A 108      25.165 101.562  -1.238  1.00 17.93           N  
ATOM    860  CA  VAL A 108      26.193 102.128  -0.354  1.00 17.86           C  
ATOM    861  C   VAL A 108      26.366 101.177   0.830  1.00 17.39           C  
ATOM    862  O   VAL A 108      27.490 100.842   1.205  1.00 18.43           O  
ATOM    863  CB  VAL A 108      25.840 103.553   0.133  1.00 17.68           C  
ATOM    864  CG1 VAL A 108      26.952 104.093   1.038  1.00 17.45           C  
ATOM    865  CG2 VAL A 108      25.650 104.481  -1.059  1.00 19.15           C  
ATOM    866  N   ALA A 109      25.245 100.700   1.371  1.00 19.11           N  
ATOM    867  CA  ALA A 109      25.263  99.753   2.483  1.00 18.32           C  
ATOM    868  C   ALA A 109      25.991  98.483   2.047  1.00 21.08           C  
ATOM    869  O   ALA A 109      26.807  97.936   2.796  1.00 20.19           O  
ATOM    870  CB  ALA A 109      23.835  99.419   2.918  1.00 20.12           C  
ATOM    871  N   LYS A 110      25.695  98.023   0.830  1.00 20.76           N  
ATOM    872  CA  LYS A 110      26.336  96.828   0.292  1.00 22.84           C  
ATOM    873  C   LYS A 110      27.838  97.024   0.137  1.00 20.93           C  
ATOM    874  O   LYS A 110      28.616  96.140   0.495  1.00 21.33           O  
ATOM    875  CB  LYS A 110      25.734  96.439  -1.065  1.00 24.71           C  
ATOM    876  CG  LYS A 110      24.566  95.473  -0.996  1.00 32.76           C  
ATOM    877  CD  LYS A 110      24.097  95.116  -2.406  1.00 36.33           C  
ATOM    878  CE  LYS A 110      23.032  94.028  -2.405  1.00 39.18           C  
ATOM    879  NZ  LYS A 110      23.560  92.702  -1.959  1.00 41.18           N  
ATOM    880  N   ALA A 111      28.240  98.177  -0.399  1.00 19.64           N  
ATOM    881  CA  ALA A 111      29.659  98.484  -0.598  1.00 17.92           C  
ATOM    882  C   ALA A 111      30.411  98.469   0.731  1.00 17.26           C  
ATOM    883  O   ALA A 111      31.559  98.026   0.802  1.00 16.73           O  
ATOM    884  CB  ALA A 111      29.824  99.838  -1.287  1.00 18.11           C  
ATOM    885  N   TYR A 112      29.764  98.974   1.777  1.00 17.28           N  
ATOM    886  CA  TYR A 112      30.364  98.997   3.111  1.00 18.06           C  
ATOM    887  C   TYR A 112      30.248  97.647   3.803  1.00 18.43           C  
ATOM    888  O   TYR A 112      30.778  97.458   4.898  1.00 19.34           O  
ATOM    889  CB  TYR A 112      29.694 100.066   3.982  1.00 17.29           C  
ATOM    890  CG  TYR A 112      30.296 101.436   3.802  1.00 17.17           C  
ATOM    891  CD1 TYR A 112      31.169 101.964   4.756  1.00 19.22           C  
ATOM    892  CD2 TYR A 112      30.035 102.186   2.656  1.00 18.75           C  
ATOM    893  CE1 TYR A 112      31.777 103.210   4.565  1.00 20.08           C  
ATOM    894  CE2 TYR A 112      30.631 103.424   2.456  1.00 20.92           C  
ATOM    895  CZ  TYR A 112      31.503 103.929   3.411  1.00 21.63           C  
ATOM    896  OH  TYR A 112      32.114 105.140   3.192  1.00 22.21           O  
ATOM    897  N   ARG A 113      29.568  96.711   3.148  1.00 20.36           N  
ATOM    898  CA  ARG A 113      29.337  95.378   3.697  1.00 20.65           C  
ATOM    899  C   ARG A 113      28.675  95.465   5.074  1.00 19.50           C  
ATOM    900  O   ARG A 113      28.942  94.661   5.971  1.00 19.19           O  
ATOM    901  CB  ARG A 113      30.630  94.557   3.732  1.00 22.60           C  
ATOM    902  CG  ARG A 113      31.119  94.158   2.337  1.00 27.11           C  
ATOM    903  CD  ARG A 113      32.385  94.905   1.928  1.00 30.37           C  
ATOM    904  NE  ARG A 113      33.565  94.361   2.597  1.00 34.47           N  
ATOM    905  CZ  ARG A 113      34.793  94.355   2.085  1.00 34.78           C  
ATOM    906  NH1 ARG A 113      35.027  94.877   0.887  1.00 35.42           N  
ATOM    907  NH2 ARG A 113      35.784  93.787   2.759  1.00 33.82           N  
ATOM    908  N   ALA A 114      27.778  96.441   5.203  1.00 18.84           N  
ATOM    909  CA  ALA A 114      27.040  96.689   6.435  1.00 18.81           C  
ATOM    910  C   ALA A 114      25.969  95.622   6.636  1.00 18.64           C  
ATOM    911  O   ALA A 114      25.458  95.055   5.671  1.00 18.68           O  
ATOM    912  CB  ALA A 114      26.410  98.072   6.395  1.00 17.97           C  
ATOM    913  N   LEU A 115      25.599  95.377   7.889  1.00 16.92           N  
ATOM    914  CA  LEU A 115      24.605  94.355   8.194  1.00 16.85           C  
ATOM    915  C   LEU A 115      23.516  94.780   9.171  1.00 17.01           C  
ATOM    916  O   LEU A 115      22.395  94.273   9.107  1.00 16.46           O  
ATOM    917  CB  LEU A 115      25.302  93.108   8.762  1.00 17.43           C  
ATOM    918  CG  LEU A 115      26.236  92.300   7.851  1.00 20.23           C  
ATOM    919  CD1 LEU A 115      27.083  91.345   8.682  1.00 19.90           C  
ATOM    920  CD2 LEU A 115      25.410  91.540   6.820  1.00 20.51           C  
ATOM    921  N   ARG A 116      23.837  95.708  10.069  1.00 15.33           N  
ATOM    922  CA  ARG A 116      22.882  96.126  11.097  1.00 14.80           C  
ATOM    923  C   ARG A 116      22.752  97.635  11.291  1.00 14.10           C  
ATOM    924  O   ARG A 116      23.499  98.421  10.709  1.00 13.29           O  
ATOM    925  CB  ARG A 116      23.297  95.519  12.439  1.00 17.88           C  
ATOM    926  CG  ARG A 116      23.505  94.013  12.432  1.00 18.56           C  
ATOM    927  CD  ARG A 116      24.032  93.536  13.775  1.00 20.45           C  
ATOM    928  NE  ARG A 116      24.169  92.083  13.818  1.00 23.21           N  
ATOM    929  CZ  ARG A 116      25.325  91.431  13.725  1.00 27.53           C  
ATOM    930  NH1 ARG A 116      26.465  92.099  13.586  1.00 27.73           N  
ATOM    931  NH2 ARG A 116      25.344  90.105  13.777  1.00 28.20           N  
ATOM    932  N   THR A 117      21.794  98.011  12.138  1.00 14.96           N  
ATOM    933  CA  THR A 117      21.527  99.402  12.497  1.00 13.47           C  
ATOM    934  C   THR A 117      21.395  99.484  14.028  1.00 13.57           C  
ATOM    935  O   THR A 117      20.591  98.764  14.633  1.00 12.90           O  
ATOM    936  CB  THR A 117      20.209  99.924  11.872  1.00 15.40           C  
ATOM    937  OG1 THR A 117      19.107  99.150  12.360  1.00 17.38           O  
ATOM    938  CG2 THR A 117      20.248  99.823  10.344  1.00 15.51           C  
ATOM    939  N   PRO A 118      22.193 100.346  14.680  1.00 13.02           N  
ATOM    940  CA  PRO A 118      23.198 101.231  14.084  1.00 13.91           C  
ATOM    941  C   PRO A 118      24.550 100.536  13.932  1.00 13.44           C  
ATOM    942  O   PRO A 118      24.944  99.713  14.761  1.00 16.49           O  
ATOM    943  CB  PRO A 118      23.264 102.381  15.091  1.00 14.08           C  
ATOM    944  CG  PRO A 118      23.122 101.654  16.404  1.00 14.21           C  
ATOM    945  CD  PRO A 118      22.029 100.623  16.123  1.00 12.13           C  
ATOM    946  N   GLU A 119      25.245 100.844  12.844  1.00 14.49           N  
ATOM    947  CA  GLU A 119      26.554 100.268  12.577  1.00 12.35           C  
ATOM    948  C   GLU A 119      27.432 101.435  12.161  1.00 14.33           C  
ATOM    949  O   GLU A 119      27.140 102.120  11.180  1.00 13.33           O  
ATOM    950  CB  GLU A 119      26.466  99.224  11.465  1.00 12.57           C  
ATOM    951  CG  GLU A 119      27.792  98.547  11.153  1.00 13.15           C  
ATOM    952  CD  GLU A 119      27.639  97.348  10.233  1.00 15.23           C  
ATOM    953  OE1 GLU A 119      26.533  96.774  10.164  1.00 16.52           O  
ATOM    954  OE2 GLU A 119      28.632  96.974   9.587  1.00 15.13           O  
ATOM    955  N   VAL A 120      28.513 101.647  12.904  1.00 13.42           N  
ATOM    956  CA  VAL A 120      29.399 102.780  12.652  1.00 13.33           C  
ATOM    957  C   VAL A 120      30.739 102.448  12.019  1.00 13.94           C  
ATOM    958  O   VAL A 120      31.353 101.429  12.329  1.00 15.67           O  
ATOM    959  CB  VAL A 120      29.676 103.551  13.975  1.00 15.72           C  
ATOM    960  CG1 VAL A 120      30.393 104.874  13.693  1.00 15.67           C  
ATOM    961  CG2 VAL A 120      28.377 103.804  14.717  1.00 18.03           C  
ATOM    962  N   PHE A 121      31.186 103.345  11.146  1.00 12.29           N  
ATOM    963  CA  PHE A 121      32.471 103.240  10.458  1.00 12.63           C  
ATOM    964  C   PHE A 121      33.154 104.579  10.719  1.00 14.01           C  
ATOM    965  O   PHE A 121      32.659 105.621  10.286  1.00 14.39           O  
ATOM    966  CB  PHE A 121      32.270 103.063   8.949  1.00 12.97           C  
ATOM    967  CG  PHE A 121      31.668 101.742   8.559  1.00 11.71           C  
ATOM    968  CD1 PHE A 121      32.477 100.705   8.103  1.00 14.72           C  
ATOM    969  CD2 PHE A 121      30.293 101.538   8.630  1.00 14.34           C  
ATOM    970  CE1 PHE A 121      31.923  99.476   7.716  1.00 14.71           C  
ATOM    971  CE2 PHE A 121      29.725 100.312   8.247  1.00 13.02           C  
ATOM    972  CZ  PHE A 121      30.543  99.282   7.791  1.00 13.98           C  
ATOM    973  N   LEU A 122      34.254 104.549  11.465  1.00 13.99           N  
ATOM    974  CA  LEU A 122      34.993 105.761  11.810  1.00 14.89           C  
ATOM    975  C   LEU A 122      36.321 105.830  11.053  1.00 15.84           C  
ATOM    976  O   LEU A 122      37.176 104.952  11.196  1.00 14.38           O  
ATOM    977  CB  LEU A 122      35.233 105.808  13.324  1.00 13.90           C  
ATOM    978  CG  LEU A 122      36.015 106.990  13.894  1.00 15.20           C  
ATOM    979  CD1 LEU A 122      35.188 108.267  13.798  1.00 13.83           C  
ATOM    980  CD2 LEU A 122      36.383 106.690  15.345  1.00 15.82           C  
ATOM    981  N   PHE A 123      36.491 106.904  10.285  1.00 16.31           N  
ATOM    982  CA  PHE A 123      37.691 107.126   9.474  1.00 17.36           C  
ATOM    983  C   PHE A 123      38.550 108.262  10.028  1.00 18.62           C  
ATOM    984  O   PHE A 123      38.024 109.241  10.563  1.00 18.00           O  
ATOM    985  CB  PHE A 123      37.293 107.459   8.035  1.00 16.08           C  
ATOM    986  CG  PHE A 123      36.531 106.360   7.339  1.00 17.07           C  
ATOM    987  CD1 PHE A 123      37.202 105.402   6.584  1.00 17.72           C  
ATOM    988  CD2 PHE A 123      35.147 106.283   7.441  1.00 17.29           C  
ATOM    989  CE1 PHE A 123      36.502 104.381   5.941  1.00 18.97           C  
ATOM    990  CE2 PHE A 123      34.436 105.267   6.802  1.00 18.03           C  
ATOM    991  CZ  PHE A 123      35.117 104.314   6.051  1.00 17.59           C  
ATOM    992  N   ASP A 124      39.869 108.134   9.883  1.00 19.40           N  
ATOM    993  CA  ASP A 124      40.795 109.153  10.376  1.00 21.77           C  
ATOM    994  C   ASP A 124      41.105 110.245   9.347  1.00 22.28           C  
ATOM    995  O   ASP A 124      40.454 110.327   8.302  1.00 21.24           O  
ATOM    996  CB  ASP A 124      42.089 108.510  10.907  1.00 19.21           C  
ATOM    997  CG  ASP A 124      42.865 107.742   9.841  1.00 22.49           C  
ATOM    998  OD1 ASP A 124      42.596 107.901   8.630  1.00 22.03           O  
ATOM    999  OD2 ASP A 124      43.774 106.979  10.226  1.00 21.78           O  
ATOM   1000  N   GLU A 125      42.125 111.053   9.633  1.00 22.98           N  
ATOM   1001  CA  GLU A 125      42.522 112.154   8.756  1.00 25.32           C  
ATOM   1002  C   GLU A 125      43.004 111.721   7.375  1.00 25.74           C  
ATOM   1003  O   GLU A 125      42.968 112.505   6.429  1.00 25.16           O  
ATOM   1004  CB  GLU A 125      43.552 113.061   9.446  1.00 28.06           C  
ATOM   1005  CG  GLU A 125      44.898 112.420   9.750  1.00 32.28           C  
ATOM   1006  CD  GLU A 125      44.823 111.309  10.786  1.00 36.25           C  
ATOM   1007  OE1 GLU A 125      43.995 111.394  11.720  1.00 36.28           O  
ATOM   1008  OE2 GLU A 125      45.611 110.349  10.662  1.00 38.68           O  
ATOM   1009  N   ARG A 126      43.476 110.482   7.260  1.00 25.77           N  
ATOM   1010  CA  ARG A 126      43.908 109.952   5.968  1.00 25.33           C  
ATOM   1011  C   ARG A 126      42.742 109.170   5.365  1.00 25.04           C  
ATOM   1012  O   ARG A 126      42.883 108.486   4.346  1.00 24.63           O  
ATOM   1013  CB  ARG A 126      45.128 109.042   6.136  1.00 28.93           C  
ATOM   1014  CG  ARG A 126      46.399 109.783   6.518  1.00 30.95           C  
ATOM   1015  CD  ARG A 126      47.620 108.883   6.422  1.00 34.53           C  
ATOM   1016  NE  ARG A 126      47.585 107.795   7.397  1.00 37.28           N  
ATOM   1017  CZ  ARG A 126      48.469 106.802   7.445  1.00 40.20           C  
ATOM   1018  NH1 ARG A 126      49.467 106.750   6.568  1.00 39.17           N  
ATOM   1019  NH2 ARG A 126      48.361 105.862   8.376  1.00 39.26           N  
ATOM   1020  N   ARG A 127      41.577 109.323   5.993  1.00 23.30           N  
ATOM   1021  CA  ARG A 127      40.348 108.646   5.597  1.00 20.36           C  
ATOM   1022  C   ARG A 127      40.506 107.135   5.460  1.00 20.86           C  
ATOM   1023  O   ARG A 127      40.096 106.529   4.469  1.00 19.68           O  
ATOM   1024  CB  ARG A 127      39.730 109.281   4.347  1.00 20.90           C  
ATOM   1025  CG  ARG A 127      39.084 110.644   4.610  1.00 18.67           C  
ATOM   1026  CD  ARG A 127      38.035 110.568   5.732  1.00 17.10           C  
ATOM   1027  NE  ARG A 127      37.321 111.830   5.916  1.00 17.25           N  
ATOM   1028  CZ  ARG A 127      37.548 112.696   6.901  1.00 17.53           C  
ATOM   1029  NH1 ARG A 127      38.475 112.448   7.818  1.00 16.84           N  
ATOM   1030  NH2 ARG A 127      36.860 113.827   6.958  1.00 20.30           N  
ATOM   1031  N   LEU A 128      41.146 106.544   6.464  1.00 19.67           N  
ATOM   1032  CA  LEU A 128      41.347 105.101   6.530  1.00 18.63           C  
ATOM   1033  C   LEU A 128      40.503 104.631   7.712  1.00 18.75           C  
ATOM   1034  O   LEU A 128      40.373 105.349   8.702  1.00 19.64           O  
ATOM   1035  CB  LEU A 128      42.825 104.780   6.755  1.00 20.75           C  
ATOM   1036  CG  LEU A 128      43.745 105.269   5.632  1.00 20.19           C  
ATOM   1037  CD1 LEU A 128      45.193 104.914   5.942  1.00 22.41           C  
ATOM   1038  CD2 LEU A 128      43.310 104.648   4.312  1.00 21.78           C  
ATOM   1039  N   LEU A 129      39.912 103.446   7.602  1.00 18.57           N  
ATOM   1040  CA  LEU A 129      39.051 102.913   8.666  1.00 18.14           C  
ATOM   1041  C   LEU A 129      39.808 102.562   9.947  1.00 18.09           C  
ATOM   1042  O   LEU A 129      40.705 101.714   9.936  1.00 20.68           O  
ATOM   1043  CB  LEU A 129      38.275 101.696   8.151  1.00 17.27           C  
ATOM   1044  CG  LEU A 129      37.200 101.120   9.078  1.00 17.61           C  
ATOM   1045  CD1 LEU A 129      36.106 102.160   9.302  1.00 15.22           C  
ATOM   1046  CD2 LEU A 129      36.619  99.845   8.464  1.00 17.34           C  
ATOM   1047  N   ARG A 130      39.433 103.205  11.051  1.00 17.37           N  
ATOM   1048  CA  ARG A 130      40.085 102.970  12.339  1.00 16.08           C  
ATOM   1049  C   ARG A 130      39.225 102.230  13.360  1.00 16.86           C  
ATOM   1050  O   ARG A 130      39.757 101.595  14.269  1.00 16.14           O  
ATOM   1051  CB  ARG A 130      40.580 104.289  12.933  1.00 17.54           C  
ATOM   1052  CG  ARG A 130      41.598 105.005  12.056  1.00 19.13           C  
ATOM   1053  CD  ARG A 130      42.839 104.145  11.808  1.00 20.33           C  
ATOM   1054  NE  ARG A 130      43.634 103.988  13.022  1.00 22.06           N  
ATOM   1055  CZ  ARG A 130      44.421 104.935  13.524  1.00 23.10           C  
ATOM   1056  NH1 ARG A 130      44.527 106.111  12.914  1.00 22.73           N  
ATOM   1057  NH2 ARG A 130      45.073 104.721  14.658  1.00 24.57           N  
ATOM   1058  N   TYR A 131      37.907 102.371  13.254  1.00 15.55           N  
ATOM   1059  CA  TYR A 131      36.982 101.690  14.161  1.00 15.30           C  
ATOM   1060  C   TYR A 131      35.699 101.362  13.413  1.00 15.52           C  
ATOM   1061  O   TYR A 131      35.159 102.197  12.684  1.00 15.38           O  
ATOM   1062  CB  TYR A 131      36.660 102.541  15.402  1.00 15.35           C  
ATOM   1063  CG  TYR A 131      35.559 101.958  16.271  1.00 15.56           C  
ATOM   1064  CD1 TYR A 131      35.834 100.970  17.218  1.00 16.13           C  
ATOM   1065  CD2 TYR A 131      34.233 102.363  16.110  1.00 14.34           C  
ATOM   1066  CE1 TYR A 131      34.816 100.395  17.977  1.00 15.40           C  
ATOM   1067  CE2 TYR A 131      33.205 101.798  16.863  1.00 15.64           C  
ATOM   1068  CZ  TYR A 131      33.503 100.811  17.792  1.00 14.52           C  
ATOM   1069  OH  TYR A 131      32.488 100.226  18.508  1.00 15.15           O  
ATOM   1070  N   HIS A 132      35.214 100.143  13.614  1.00 15.15           N  
ATOM   1071  CA  HIS A 132      33.996  99.681  12.968  1.00 15.31           C  
ATOM   1072  C   HIS A 132      33.212  98.812  13.931  1.00 15.86           C  
ATOM   1073  O   HIS A 132      33.756  97.869  14.501  1.00 17.53           O  
ATOM   1074  CB  HIS A 132      34.337  98.869  11.713  1.00 14.67           C  
ATOM   1075  CG  HIS A 132      33.163  98.146  11.127  1.00 15.97           C  
ATOM   1076  ND1 HIS A 132      33.232  96.836  10.706  1.00 17.22           N  
ATOM   1077  CD2 HIS A 132      31.887  98.544  10.913  1.00 16.57           C  
ATOM   1078  CE1 HIS A 132      32.048  96.457  10.256  1.00 17.83           C  
ATOM   1079  NE2 HIS A 132      31.215  97.475  10.371  1.00 17.18           N  
ATOM   1080  N   GLY A 133      31.938  99.138  14.125  1.00 16.32           N  
ATOM   1081  CA  GLY A 133      31.128  98.337  15.018  1.00 15.44           C  
ATOM   1082  C   GLY A 133      29.972  99.036  15.693  1.00 15.45           C  
ATOM   1083  O   GLY A 133      29.264  99.838  15.089  1.00 15.84           O  
ATOM   1084  N   ARG A 134      29.804  98.731  16.976  1.00 15.20           N  
ATOM   1085  CA  ARG A 134      28.722  99.271  17.782  1.00 15.16           C  
ATOM   1086  C   ARG A 134      28.930 100.697  18.280  1.00 16.03           C  
ATOM   1087  O   ARG A 134      30.060 101.178  18.381  1.00 15.84           O  
ATOM   1088  CB  ARG A 134      28.491  98.353  18.987  1.00 15.88           C  
ATOM   1089  CG  ARG A 134      29.650  98.350  19.987  1.00 16.52           C  
ATOM   1090  CD  ARG A 134      29.514  97.234  21.015  1.00 18.14           C  
ATOM   1091  NE  ARG A 134      29.599  95.913  20.394  1.00 20.13           N  
ATOM   1092  CZ  ARG A 134      29.832  94.781  21.052  1.00 23.39           C  
ATOM   1093  NH1 ARG A 134      30.018  94.795  22.369  1.00 21.40           N  
ATOM   1094  NH2 ARG A 134      29.847  93.629  20.395  1.00 22.93           N  
ATOM   1095  N   VAL A 135      27.821 101.363  18.593  1.00 15.78           N  
ATOM   1096  CA  VAL A 135      27.867 102.712  19.142  1.00 15.64           C  
ATOM   1097  C   VAL A 135      28.257 102.543  20.616  1.00 16.26           C  
ATOM   1098  O   VAL A 135      29.115 103.257  21.135  1.00 15.96           O  
ATOM   1099  CB  VAL A 135      26.487 103.401  19.060  1.00 15.47           C  
ATOM   1100  CG1 VAL A 135      26.537 104.755  19.744  1.00 16.92           C  
ATOM   1101  CG2 VAL A 135      26.064 103.561  17.598  1.00 17.10           C  
ATOM   1102  N   ASN A 136      27.634 101.559  21.261  1.00 16.02           N  
ATOM   1103  CA  ASN A 136      27.877 101.230  22.666  1.00 16.52           C  
ATOM   1104  C   ASN A 136      27.433  99.782  22.888  1.00 18.86           C  
ATOM   1105  O   ASN A 136      26.907  99.155  21.962  1.00 17.82           O  
ATOM   1106  CB  ASN A 136      27.121 102.192  23.590  1.00 17.00           C  
ATOM   1107  CG  ASN A 136      25.621 102.181  23.362  1.00 18.15           C  
ATOM   1108  OD1 ASN A 136      25.002 101.123  23.229  1.00 19.14           O  
ATOM   1109  ND2 ASN A 136      25.029 103.364  23.318  1.00 16.80           N  
ATOM   1110  N   ASP A 137      27.620  99.242  24.092  1.00 17.95           N  
ATOM   1111  CA  ASP A 137      27.236  97.850  24.327  1.00 20.05           C  
ATOM   1112  C   ASP A 137      25.772  97.577  24.694  1.00 20.25           C  
ATOM   1113  O   ASP A 137      25.433  96.463  25.092  1.00 21.97           O  
ATOM   1114  CB  ASP A 137      28.185  97.171  25.324  1.00 21.23           C  
ATOM   1115  CG  ASP A 137      28.041  97.704  26.737  1.00 22.03           C  
ATOM   1116  OD1 ASP A 137      27.361  98.734  26.930  1.00 19.45           O  
ATOM   1117  OD2 ASP A 137      28.613  97.083  27.657  1.00 22.96           O  
ATOM   1118  N   ASN A 138      24.919  98.595  24.613  1.00 19.64           N  
ATOM   1119  CA  ASN A 138      23.486  98.421  24.879  1.00 21.09           C  
ATOM   1120  C   ASN A 138      22.733  99.571  24.227  1.00 19.42           C  
ATOM   1121  O   ASN A 138      22.170 100.435  24.903  1.00 20.50           O  
ATOM   1122  CB  ASN A 138      23.178  98.348  26.378  1.00 21.75           C  
ATOM   1123  CG  ASN A 138      21.885  97.599  26.666  1.00 23.31           C  
ATOM   1124  OD1 ASN A 138      20.798  98.042  26.291  1.00 22.69           O  
ATOM   1125  ND2 ASN A 138      22.002  96.444  27.311  1.00 24.01           N  
ATOM   1126  N   PRO A 139      22.698  99.577  22.886  1.00 19.72           N  
ATOM   1127  CA  PRO A 139      22.030 100.614  22.096  1.00 17.87           C  
ATOM   1128  C   PRO A 139      20.574 100.888  22.448  1.00 18.00           C  
ATOM   1129  O   PRO A 139      20.138 102.031  22.398  1.00 17.58           O  
ATOM   1130  CB  PRO A 139      22.193 100.108  20.661  1.00 18.23           C  
ATOM   1131  CG  PRO A 139      23.486  99.333  20.719  1.00 18.86           C  
ATOM   1132  CD  PRO A 139      23.304  98.559  22.007  1.00 18.23           C  
ATOM   1133  N   LYS A 140      19.829  99.852  22.829  1.00 17.64           N  
ATOM   1134  CA  LYS A 140      18.415 100.023  23.170  1.00 21.70           C  
ATOM   1135  C   LYS A 140      18.142 100.769  24.465  1.00 22.76           C  
ATOM   1136  O   LYS A 140      17.189 101.548  24.549  1.00 24.70           O  
ATOM   1137  CB  LYS A 140      17.708  98.668  23.259  1.00 23.24           C  
ATOM   1138  CG  LYS A 140      17.403  98.018  21.929  1.00 27.28           C  
ATOM   1139  CD  LYS A 140      16.564  96.757  22.118  1.00 29.38           C  
ATOM   1140  CE  LYS A 140      17.284  95.724  22.982  1.00 30.15           C  
ATOM   1141  NZ  LYS A 140      16.516  94.449  23.083  1.00 34.08           N  
ATOM   1142  N   ASP A 141      18.979 100.537  25.471  1.00 24.81           N  
ATOM   1143  CA  ASP A 141      18.774 101.152  26.773  1.00 25.10           C  
ATOM   1144  C   ASP A 141      20.024 101.819  27.338  1.00 23.76           C  
ATOM   1145  O   ASP A 141      20.937 101.141  27.813  1.00 23.67           O  
ATOM   1146  CB  ASP A 141      18.269 100.080  27.750  1.00 27.82           C  
ATOM   1147  CG  ASP A 141      17.706 100.661  29.045  1.00 30.39           C  
ATOM   1148  OD1 ASP A 141      17.918 101.858  29.339  1.00 30.21           O  
ATOM   1149  OD2 ASP A 141      17.038  99.899  29.776  1.00 30.88           O  
ATOM   1150  N   PRO A 142      20.056 103.163  27.334  1.00 24.50           N  
ATOM   1151  CA  PRO A 142      21.181 103.954  27.846  1.00 25.73           C  
ATOM   1152  C   PRO A 142      21.478 103.666  29.317  1.00 26.46           C  
ATOM   1153  O   PRO A 142      22.634 103.698  29.738  1.00 25.84           O  
ATOM   1154  CB  PRO A 142      20.695 105.391  27.665  1.00 25.39           C  
ATOM   1155  CG  PRO A 142      19.811 105.296  26.460  1.00 26.53           C  
ATOM   1156  CD  PRO A 142      19.032 104.040  26.739  1.00 26.00           C  
ATOM   1157  N   SER A 143      20.437 103.376  30.097  1.00 27.28           N  
ATOM   1158  CA  SER A 143      20.622 103.097  31.521  1.00 27.75           C  
ATOM   1159  C   SER A 143      21.388 101.797  31.771  1.00 26.96           C  
ATOM   1160  O   SER A 143      21.887 101.569  32.873  1.00 26.95           O  
ATOM   1161  CB  SER A 143      19.270 103.073  32.254  1.00 29.89           C  
ATOM   1162  OG  SER A 143      18.527 101.902  31.951  1.00 32.98           O  
ATOM   1163  N   LYS A 144      21.517 100.968  30.734  1.00 26.18           N  
ATOM   1164  CA  LYS A 144      22.219  99.687  30.853  1.00 25.60           C  
ATOM   1165  C   LYS A 144      23.570  99.626  30.138  1.00 23.98           C  
ATOM   1166  O   LYS A 144      24.242  98.591  30.150  1.00 22.27           O  
ATOM   1167  CB  LYS A 144      21.327  98.547  30.351  1.00 28.93           C  
ATOM   1168  CG  LYS A 144      20.040  98.371  31.138  1.00 33.28           C  
ATOM   1169  CD  LYS A 144      19.202  97.244  30.558  1.00 37.36           C  
ATOM   1170  CE  LYS A 144      17.908  97.062  31.339  1.00 39.60           C  
ATOM   1171  NZ  LYS A 144      17.079  95.967  30.766  1.00 41.33           N  
ATOM   1172  N   VAL A 145      23.964 100.726  29.506  1.00 22.84           N  
ATOM   1173  CA  VAL A 145      25.245 100.777  28.801  1.00 21.70           C  
ATOM   1174  C   VAL A 145      26.416 100.702  29.777  1.00 22.43           C  
ATOM   1175  O   VAL A 145      26.426 101.399  30.795  1.00 22.11           O  
ATOM   1176  CB  VAL A 145      25.386 102.082  27.976  1.00 21.17           C  
ATOM   1177  CG1 VAL A 145      26.787 102.183  27.376  1.00 20.37           C  
ATOM   1178  CG2 VAL A 145      24.332 102.133  26.883  1.00 19.61           C  
ATOM   1179  N   GLN A 146      27.387  99.843  29.471  1.00 21.12           N  
ATOM   1180  CA  GLN A 146      28.579  99.699  30.301  1.00 23.45           C  
ATOM   1181  C   GLN A 146      29.838 100.139  29.558  1.00 22.42           C  
ATOM   1182  O   GLN A 146      30.921 100.213  30.143  1.00 20.45           O  
ATOM   1183  CB  GLN A 146      28.736  98.261  30.798  1.00 25.31           C  
ATOM   1184  CG  GLN A 146      27.669  97.836  31.784  1.00 29.88           C  
ATOM   1185  CD  GLN A 146      27.934  96.462  32.366  1.00 33.77           C  
ATOM   1186  OE1 GLN A 146      29.067  96.133  32.726  1.00 36.99           O  
ATOM   1187  NE2 GLN A 146      26.888  95.652  32.467  1.00 37.59           N  
ATOM   1188  N   SER A 147      29.694 100.420  28.264  1.00 22.17           N  
ATOM   1189  CA  SER A 147      30.818 100.871  27.449  1.00 21.09           C  
ATOM   1190  C   SER A 147      30.331 101.723  26.289  1.00 20.13           C  
ATOM   1191  O   SER A 147      29.355 101.378  25.620  1.00 19.18           O  
ATOM   1192  CB  SER A 147      31.624  99.685  26.910  1.00 22.08           C  
ATOM   1193  OG  SER A 147      30.893  98.956  25.936  1.00 26.60           O  
ATOM   1194  N   HIS A 148      30.993 102.858  26.088  1.00 17.95           N  
ATOM   1195  CA  HIS A 148      30.665 103.769  24.999  1.00 16.68           C  
ATOM   1196  C   HIS A 148      31.800 103.615  23.996  1.00 17.43           C  
ATOM   1197  O   HIS A 148      32.729 104.424  23.938  1.00 15.37           O  
ATOM   1198  CB  HIS A 148      30.536 105.197  25.528  1.00 17.04           C  
ATOM   1199  CG  HIS A 148      29.446 105.352  26.543  1.00 16.64           C  
ATOM   1200  ND1 HIS A 148      28.183 105.798  26.219  1.00 16.80           N  
ATOM   1201  CD2 HIS A 148      29.419 105.082  27.871  1.00 18.30           C  
ATOM   1202  CE1 HIS A 148      27.424 105.795  27.300  1.00 18.44           C  
ATOM   1203  NE2 HIS A 148      28.151 105.364  28.317  1.00 15.91           N  
ATOM   1204  N   ASP A 149      31.712 102.529  23.233  1.00 14.01           N  
ATOM   1205  CA  ASP A 149      32.720 102.146  22.256  1.00 14.04           C  
ATOM   1206  C   ASP A 149      33.100 103.198  21.230  1.00 14.29           C  
ATOM   1207  O   ASP A 149      34.289 103.410  20.982  1.00 14.65           O  
ATOM   1208  CB  ASP A 149      32.309 100.843  21.567  1.00 15.11           C  
ATOM   1209  CG  ASP A 149      32.003  99.736  22.564  1.00 17.07           C  
ATOM   1210  OD1 ASP A 149      32.810  98.793  22.685  1.00 19.35           O  
ATOM   1211  OD2 ASP A 149      30.956  99.816  23.233  1.00 19.83           O  
ATOM   1212  N   LEU A 150      32.107 103.841  20.629  1.00 13.33           N  
ATOM   1213  CA  LEU A 150      32.383 104.876  19.630  1.00 13.24           C  
ATOM   1214  C   LEU A 150      33.085 106.061  20.275  1.00 14.13           C  
ATOM   1215  O   LEU A 150      34.068 106.572  19.737  1.00 13.17           O  
ATOM   1216  CB  LEU A 150      31.100 105.346  18.940  1.00 11.99           C  
ATOM   1217  CG  LEU A 150      31.290 106.487  17.925  1.00 13.91           C  
ATOM   1218  CD1 LEU A 150      32.349 106.112  16.884  1.00 14.82           C  
ATOM   1219  CD2 LEU A 150      29.966 106.800  17.260  1.00 13.93           C  
ATOM   1220  N   GLU A 151      32.588 106.492  21.433  1.00 13.30           N  
ATOM   1221  CA  GLU A 151      33.205 107.616  22.133  1.00 14.47           C  
ATOM   1222  C   GLU A 151      34.654 107.280  22.487  1.00 15.03           C  
ATOM   1223  O   GLU A 151      35.551 108.115  22.343  1.00 14.97           O  
ATOM   1224  CB  GLU A 151      32.439 107.966  23.407  1.00 13.66           C  
ATOM   1225  CG  GLU A 151      32.917 109.287  24.008  1.00 17.03           C  
ATOM   1226  CD  GLU A 151      32.439 109.530  25.424  1.00 19.07           C  
ATOM   1227  OE1 GLU A 151      31.409 108.958  25.844  1.00 18.99           O  
ATOM   1228  OE2 GLU A 151      33.115 110.308  26.122  1.00 20.69           O  
ATOM   1229  N   ALA A 152      34.873 106.055  22.960  1.00 14.15           N  
ATOM   1230  CA  ALA A 152      36.215 105.604  23.321  1.00 14.91           C  
ATOM   1231  C   ALA A 152      37.169 105.641  22.126  1.00 15.34           C  
ATOM   1232  O   ALA A 152      38.323 106.060  22.259  1.00 13.30           O  
ATOM   1233  CB  ALA A 152      36.160 104.192  23.905  1.00 17.14           C  
ATOM   1234  N   ALA A 153      36.687 105.209  20.960  1.00 12.53           N  
ATOM   1235  CA  ALA A 153      37.510 105.187  19.753  1.00 13.22           C  
ATOM   1236  C   ALA A 153      37.873 106.598  19.302  1.00 12.80           C  
ATOM   1237  O   ALA A 153      39.006 106.855  18.891  1.00 14.00           O  
ATOM   1238  CB  ALA A 153      36.786 104.440  18.626  1.00 13.19           C  
ATOM   1239  N   ILE A 154      36.900 107.504  19.352  1.00 13.77           N  
ATOM   1240  CA  ILE A 154      37.124 108.893  18.960  1.00 12.37           C  
ATOM   1241  C   ILE A 154      38.158 109.543  19.882  1.00 13.78           C  
ATOM   1242  O   ILE A 154      39.122 110.160  19.417  1.00 12.56           O  
ATOM   1243  CB  ILE A 154      35.801 109.698  18.988  1.00 12.97           C  
ATOM   1244  CG1 ILE A 154      34.870 109.193  17.873  1.00 13.20           C  
ATOM   1245  CG2 ILE A 154      36.078 111.197  18.826  1.00 14.62           C  
ATOM   1246  CD1 ILE A 154      33.445 109.759  17.924  1.00 13.28           C  
ATOM   1247  N   GLU A 155      37.977 109.371  21.187  1.00 14.16           N  
ATOM   1248  CA  GLU A 155      38.900 109.946  22.160  1.00 15.53           C  
ATOM   1249  C   GLU A 155      40.308 109.381  22.009  1.00 16.66           C  
ATOM   1250  O   GLU A 155      41.288 110.109  22.156  1.00 19.21           O  
ATOM   1251  CB  GLU A 155      38.381 109.738  23.582  1.00 18.11           C  
ATOM   1252  CG  GLU A 155      37.193 110.624  23.930  1.00 19.55           C  
ATOM   1253  CD  GLU A 155      37.541 112.105  23.918  1.00 23.61           C  
ATOM   1254  OE1 GLU A 155      38.692 112.467  24.252  1.00 23.50           O  
ATOM   1255  OE2 GLU A 155      36.655 112.911  23.580  1.00 27.35           O  
ATOM   1256  N   ALA A 156      40.408 108.094  21.684  1.00 15.57           N  
ATOM   1257  CA  ALA A 156      41.708 107.467  21.487  1.00 15.90           C  
ATOM   1258  C   ALA A 156      42.398 108.130  20.296  1.00 16.56           C  
ATOM   1259  O   ALA A 156      43.563 108.518  20.387  1.00 18.09           O  
ATOM   1260  CB  ALA A 156      41.554 105.969  21.255  1.00 16.77           C  
ATOM   1261  N   LEU A 157      41.660 108.304  19.199  1.00 14.48           N  
ATOM   1262  CA  LEU A 157      42.208 108.934  17.998  1.00 15.45           C  
ATOM   1263  C   LEU A 157      42.608 110.388  18.246  1.00 16.06           C  
ATOM   1264  O   LEU A 157      43.597 110.875  17.684  1.00 16.83           O  
ATOM   1265  CB  LEU A 157      41.211 108.845  16.833  1.00 16.95           C  
ATOM   1266  CG  LEU A 157      40.940 107.436  16.294  1.00 18.44           C  
ATOM   1267  CD1 LEU A 157      39.968 107.500  15.122  1.00 19.30           C  
ATOM   1268  CD2 LEU A 157      42.246 106.792  15.860  1.00 16.64           C  
ATOM   1269  N   LEU A 158      41.833 111.083  19.075  1.00 15.57           N  
ATOM   1270  CA  LEU A 158      42.131 112.472  19.405  1.00 17.75           C  
ATOM   1271  C   LEU A 158      43.415 112.599  20.232  1.00 18.58           C  
ATOM   1272  O   LEU A 158      44.054 113.655  20.226  1.00 19.33           O  
ATOM   1273  CB  LEU A 158      40.958 113.116  20.153  1.00 18.32           C  
ATOM   1274  CG  LEU A 158      39.660 113.255  19.347  1.00 20.11           C  
ATOM   1275  CD1 LEU A 158      38.617 113.983  20.189  1.00 22.33           C  
ATOM   1276  CD2 LEU A 158      39.912 113.997  18.050  1.00 20.66           C  
ATOM   1277  N   ARG A 159      43.761 111.544  20.968  1.00 18.46           N  
ATOM   1278  CA  ARG A 159      44.983 111.528  21.784  1.00 18.89           C  
ATOM   1279  C   ARG A 159      46.153 110.908  21.012  1.00 19.86           C  
ATOM   1280  O   ARG A 159      47.257 110.772  21.546  1.00 19.37           O  
ATOM   1281  CB  ARG A 159      44.765 110.750  23.089  1.00 20.71           C  
ATOM   1282  CG  ARG A 159      43.702 111.330  24.022  1.00 22.79           C  
ATOM   1283  CD  ARG A 159      43.657 110.595  25.360  1.00 23.80           C  
ATOM   1284  NE  ARG A 159      43.404 109.163  25.210  1.00 25.80           N  
ATOM   1285  CZ  ARG A 159      42.223 108.576  25.398  1.00 24.10           C  
ATOM   1286  NH1 ARG A 159      41.160 109.291  25.752  1.00 25.02           N  
ATOM   1287  NH2 ARG A 159      42.104 107.267  25.230  1.00 26.20           N  
ATOM   1288  N   GLY A 160      45.906 110.553  19.753  1.00 18.14           N  
ATOM   1289  CA  GLY A 160      46.930 109.944  18.920  1.00 20.30           C  
ATOM   1290  C   GLY A 160      47.157 108.477  19.236  1.00 21.85           C  
ATOM   1291  O   GLY A 160      48.173 107.899  18.842  1.00 21.42           O  
ATOM   1292  N   GLU A 161      46.210 107.872  19.945  1.00 20.43           N  
ATOM   1293  CA  GLU A 161      46.312 106.465  20.320  1.00 22.31           C  
ATOM   1294  C   GLU A 161      45.470 105.570  19.420  1.00 22.59           C  
ATOM   1295  O   GLU A 161      44.653 106.038  18.631  1.00 21.51           O  
ATOM   1296  CB  GLU A 161      45.857 106.263  21.765  1.00 23.54           C  
ATOM   1297  CG  GLU A 161      46.630 107.066  22.793  1.00 26.84           C  
ATOM   1298  CD  GLU A 161      46.095 106.877  24.193  1.00 27.75           C  
ATOM   1299  OE1 GLU A 161      44.862 106.754  24.359  1.00 29.02           O  
ATOM   1300  OE2 GLU A 161      46.910 106.847  25.137  1.00 31.25           O  
ATOM   1301  N   GLU A 162      45.667 104.270  19.572  1.00 22.71           N  
ATOM   1302  CA  GLU A 162      44.926 103.282  18.807  1.00 24.04           C  
ATOM   1303  C   GLU A 162      43.689 102.878  19.607  1.00 23.27           C  
ATOM   1304  O   GLU A 162      43.761 102.720  20.830  1.00 22.63           O  
ATOM   1305  CB  GLU A 162      45.817 102.061  18.563  1.00 25.91           C  
ATOM   1306  CG  GLU A 162      45.123 100.860  17.926  1.00 31.11           C  
ATOM   1307  CD  GLU A 162      44.715 101.077  16.472  1.00 33.14           C  
ATOM   1308  OE1 GLU A 162      43.883 100.278  15.983  1.00 31.78           O  
ATOM   1309  OE2 GLU A 162      45.223 102.022  15.821  1.00 30.94           O  
ATOM   1310  N   PRO A 163      42.521 102.788  18.944  1.00 22.76           N  
ATOM   1311  CA  PRO A 163      41.288 102.394  19.638  1.00 23.67           C  
ATOM   1312  C   PRO A 163      41.474 100.973  20.184  1.00 25.68           C  
ATOM   1313  O   PRO A 163      42.406 100.276  19.780  1.00 23.78           O  
ATOM   1314  CB  PRO A 163      40.251 102.419  18.515  1.00 23.20           C  
ATOM   1315  CG  PRO A 163      40.756 103.499  17.617  1.00 25.12           C  
ATOM   1316  CD  PRO A 163      42.232 103.190  17.556  1.00 23.89           C  
ATOM   1317  N   PRO A 164      40.604 100.534  21.116  1.00 27.67           N  
ATOM   1318  CA  PRO A 164      40.690  99.191  21.704  1.00 29.28           C  
ATOM   1319  C   PRO A 164      40.913  98.104  20.663  1.00 30.17           C  
ATOM   1320  O   PRO A 164      40.237  98.060  19.637  1.00 30.10           O  
ATOM   1321  CB  PRO A 164      39.340  99.046  22.396  1.00 29.86           C  
ATOM   1322  CG  PRO A 164      39.108 100.427  22.902  1.00 29.44           C  
ATOM   1323  CD  PRO A 164      39.472 101.277  21.698  1.00 27.68           C  
ATOM   1324  N   LEU A 165      41.878  97.233  20.936  1.00 30.19           N  
ATOM   1325  CA  LEU A 165      42.226  96.154  20.024  1.00 31.44           C  
ATOM   1326  C   LEU A 165      41.120  95.124  19.828  1.00 29.79           C  
ATOM   1327  O   LEU A 165      40.980  94.560  18.744  1.00 30.32           O  
ATOM   1328  CB  LEU A 165      43.513  95.472  20.495  1.00 34.36           C  
ATOM   1329  CG  LEU A 165      44.703  96.422  20.676  1.00 37.56           C  
ATOM   1330  CD1 LEU A 165      45.882  95.680  21.293  1.00 39.05           C  
ATOM   1331  CD2 LEU A 165      45.090  97.043  19.334  1.00 38.35           C  
ATOM   1332  N   LYS A 166      40.336  94.882  20.874  1.00 30.01           N  
ATOM   1333  CA  LYS A 166      39.249  93.916  20.792  1.00 29.49           C  
ATOM   1334  C   LYS A 166      38.092  94.479  19.974  1.00 26.79           C  
ATOM   1335  O   LYS A 166      37.522  95.511  20.319  1.00 26.23           O  
ATOM   1336  CB  LYS A 166      38.750  93.538  22.187  1.00 30.62           C  
ATOM   1337  CG  LYS A 166      37.670  92.462  22.163  1.00 33.35           C  
ATOM   1338  CD  LYS A 166      37.123  92.180  23.548  1.00 34.56           C  
ATOM   1339  CE  LYS A 166      36.131  91.028  23.509  1.00 37.15           C  
ATOM   1340  NZ  LYS A 166      35.555  90.740  24.854  1.00 38.54           N  
ATOM   1341  N   GLU A 167      37.744  93.786  18.897  1.00 27.15           N  
ATOM   1342  CA  GLU A 167      36.652  94.222  18.039  1.00 26.93           C  
ATOM   1343  C   GLU A 167      35.310  94.180  18.758  1.00 25.13           C  
ATOM   1344  O   GLU A 167      35.022  93.249  19.508  1.00 25.19           O  
ATOM   1345  CB  GLU A 167      36.590  93.367  16.773  1.00 29.34           C  
ATOM   1346  CG  GLU A 167      35.506  93.807  15.805  1.00 31.59           C  
ATOM   1347  CD  GLU A 167      35.525  93.030  14.516  1.00 35.53           C  
ATOM   1348  OE1 GLU A 167      35.176  91.832  14.532  1.00 37.95           O  
ATOM   1349  OE2 GLU A 167      35.887  93.623  13.482  1.00 36.43           O  
ATOM   1350  N   ALA A 168      34.516  95.227  18.561  1.00 21.52           N  
ATOM   1351  CA  ALA A 168      33.195  95.323  19.165  1.00 21.41           C  
ATOM   1352  C   ALA A 168      32.195  95.516  18.029  1.00 21.15           C  
ATOM   1353  O   ALA A 168      31.828  96.647  17.704  1.00 19.24           O  
ATOM   1354  CB  ALA A 168      33.140  96.501  20.128  1.00 18.27           C  
ATOM   1355  N   PRO A 169      31.762  94.407  17.399  1.00 20.88           N  
ATOM   1356  CA  PRO A 169      30.806  94.424  16.287  1.00 20.16           C  
ATOM   1357  C   PRO A 169      29.502  95.128  16.617  1.00 18.35           C  
ATOM   1358  O   PRO A 169      29.087  95.193  17.775  1.00 17.03           O  
ATOM   1359  CB  PRO A 169      30.570  92.937  16.016  1.00 21.80           C  
ATOM   1360  CG  PRO A 169      31.877  92.319  16.388  1.00 23.13           C  
ATOM   1361  CD  PRO A 169      32.184  93.024  17.688  1.00 21.46           C  
ATOM   1362  N   ALA A 170      28.842  95.617  15.572  1.00 16.68           N  
ATOM   1363  CA  ALA A 170      27.581  96.317  15.717  1.00 16.70           C  
ATOM   1364  C   ALA A 170      26.518  95.498  16.441  1.00 17.88           C  
ATOM   1365  O   ALA A 170      26.454  94.275  16.310  1.00 17.32           O  
ATOM   1366  CB  ALA A 170      27.066  96.741  14.354  1.00 18.27           C  
ATOM   1367  N   ILE A 171      25.715  96.190  17.239  1.00 15.94           N  
ATOM   1368  CA  ILE A 171      24.623  95.569  17.974  1.00 17.18           C  
ATOM   1369  C   ILE A 171      23.363  96.265  17.501  1.00 17.40           C  
ATOM   1370  O   ILE A 171      23.234  97.478  17.648  1.00 18.22           O  
ATOM   1371  CB  ILE A 171      24.753  95.793  19.500  1.00 16.26           C  
ATOM   1372  CG1 ILE A 171      26.012  95.103  20.031  1.00 17.74           C  
ATOM   1373  CG2 ILE A 171      23.494  95.296  20.216  1.00 16.77           C  
ATOM   1374  CD1 ILE A 171      26.269  95.376  21.513  1.00 19.27           C  
ATOM   1375  N   GLY A 172      22.453  95.510  16.898  1.00 17.04           N  
ATOM   1376  CA  GLY A 172      21.216  96.103  16.424  1.00 17.28           C  
ATOM   1377  C   GLY A 172      20.436  95.195  15.495  1.00 18.49           C  
ATOM   1378  O   GLY A 172      20.837  94.060  15.243  1.00 17.03           O  
ATOM   1379  N   CYS A 173      19.308  95.690  15.003  1.00 18.19           N  
ATOM   1380  CA  CYS A 173      18.481  94.920  14.081  1.00 21.23           C  
ATOM   1381  C   CYS A 173      19.179  94.874  12.727  1.00 20.53           C  
ATOM   1382  O   CYS A 173      19.999  95.735  12.410  1.00 18.02           O  
ATOM   1383  CB  CYS A 173      17.104  95.569  13.928  1.00 24.19           C  
ATOM   1384  SG  CYS A 173      16.092  95.568  15.431  1.00 32.59           S  
ATOM   1385  N   THR A 174      18.862  93.863  11.930  1.00 19.53           N  
ATOM   1386  CA  THR A 174      19.471  93.743  10.616  1.00 21.42           C  
ATOM   1387  C   THR A 174      18.905  94.801   9.679  1.00 19.66           C  
ATOM   1388  O   THR A 174      17.783  95.270   9.865  1.00 20.68           O  
ATOM   1389  CB  THR A 174      19.220  92.345  10.011  1.00 24.99           C  
ATOM   1390  OG1 THR A 174      17.815  92.062  10.031  1.00 26.34           O  
ATOM   1391  CG2 THR A 174      19.962  91.282  10.808  1.00 27.04           C  
ATOM   1392  N   ILE A 175      19.719  95.241   8.724  1.00 19.14           N  
ATOM   1393  CA  ILE A 175      19.275  96.225   7.741  1.00 18.03           C  
ATOM   1394  C   ILE A 175      18.142  95.552   6.954  1.00 19.15           C  
ATOM   1395  O   ILE A 175      18.186  94.346   6.716  1.00 17.31           O  
ATOM   1396  CB  ILE A 175      20.433  96.604   6.789  1.00 17.87           C  
ATOM   1397  CG1 ILE A 175      21.452  97.476   7.528  1.00 17.33           C  
ATOM   1398  CG2 ILE A 175      19.913  97.313   5.545  1.00 19.16           C  
ATOM   1399  CD1 ILE A 175      22.752  97.680   6.771  1.00 17.15           C  
ATOM   1400  N   LYS A 176      17.117  96.319   6.596  1.00 18.22           N  
ATOM   1401  CA  LYS A 176      15.984  95.766   5.856  1.00 19.15           C  
ATOM   1402  C   LYS A 176      16.236  95.808   4.354  1.00 17.73           C  
ATOM   1403  O   LYS A 176      15.934  96.787   3.671  1.00 18.48           O  
ATOM   1404  CB  LYS A 176      14.696  96.493   6.240  1.00 19.04           C  
ATOM   1405  CG  LYS A 176      14.460  96.522   7.755  1.00 21.32           C  
ATOM   1406  CD  LYS A 176      14.668  95.142   8.373  1.00 23.95           C  
ATOM   1407  CE  LYS A 176      14.501  95.165   9.893  1.00 28.39           C  
ATOM   1408  NZ  LYS A 176      15.037  93.912  10.517  1.00 30.71           N  
ATOM   1409  N   TRP A 177      16.819  94.728   3.856  1.00 19.19           N  
ATOM   1410  CA  TRP A 177      17.154  94.615   2.446  1.00 19.58           C  
ATOM   1411  C   TRP A 177      15.924  94.473   1.558  1.00 19.63           C  
ATOM   1412  O   TRP A 177      14.929  93.853   1.940  1.00 19.59           O  
ATOM   1413  CB  TRP A 177      18.080  93.419   2.239  1.00 20.92           C  
ATOM   1414  CG  TRP A 177      19.308  93.478   3.089  1.00 22.23           C  
ATOM   1415  CD1 TRP A 177      19.564  92.742   4.208  1.00 23.01           C  
ATOM   1416  CD2 TRP A 177      20.447  94.330   2.897  1.00 22.66           C  
ATOM   1417  NE1 TRP A 177      20.793  93.082   4.729  1.00 22.87           N  
ATOM   1418  CE2 TRP A 177      21.356  94.054   3.943  1.00 22.63           C  
ATOM   1419  CE3 TRP A 177      20.788  95.298   1.942  1.00 24.22           C  
ATOM   1420  CZ2 TRP A 177      22.587  94.710   4.061  1.00 21.85           C  
ATOM   1421  CZ3 TRP A 177      22.016  95.954   2.059  1.00 22.65           C  
ATOM   1422  CH2 TRP A 177      22.897  95.653   3.110  1.00 23.17           C  
ATOM   1423  N   ARG A 178      15.999  95.066   0.372  1.00 20.84           N  
ATOM   1424  CA  ARG A 178      14.913  94.980  -0.594  1.00 19.81           C  
ATOM   1425  C   ARG A 178      14.904  93.554  -1.133  1.00 19.74           C  
ATOM   1426  O   ARG A 178      15.897  92.832  -1.000  1.00 20.09           O  
ATOM   1427  CB  ARG A 178      15.140  95.995  -1.719  1.00 23.10           C  
ATOM   1428  CG  ARG A 178      14.988  97.429  -1.244  1.00 27.56           C  
ATOM   1429  CD  ARG A 178      15.364  98.468  -2.291  1.00 33.30           C  
ATOM   1430  NE  ARG A 178      15.029  99.814  -1.818  1.00 34.58           N  
ATOM   1431  CZ  ARG A 178      13.788 100.234  -1.591  1.00 35.57           C  
ATOM   1432  NH1 ARG A 178      12.762  99.418  -1.805  1.00 34.85           N  
ATOM   1433  NH2 ARG A 178      13.568 101.454  -1.111  1.00 35.30           N  
ATOM   1434  N   PRO A 179      13.770  93.106  -1.702  1.00 20.14           N  
ATOM   1435  CA  PRO A 179      13.711  91.741  -2.237  1.00 21.15           C  
ATOM   1436  C   PRO A 179      14.883  91.465  -3.183  1.00 21.89           C  
ATOM   1437  O   PRO A 179      15.154  92.249  -4.088  1.00 23.33           O  
ATOM   1438  CB  PRO A 179      12.377  91.730  -2.987  1.00 20.80           C  
ATOM   1439  CG  PRO A 179      11.530  92.665  -2.161  1.00 22.47           C  
ATOM   1440  CD  PRO A 179      12.490  93.809  -1.903  1.00 17.83           C  
ATOM   1441  N   GLY A 180      15.612  90.387  -2.915  1.00 24.53           N  
ATOM   1442  CA  GLY A 180      16.745  90.019  -3.749  1.00 26.73           C  
ATOM   1443  C   GLY A 180      18.048  90.728  -3.425  1.00 28.31           C  
ATOM   1444  O   GLY A 180      19.075  90.452  -4.044  1.00 29.40           O  
ATOM   1445  N   ASN A 181      18.014  91.640  -2.459  1.00 28.20           N  
ATOM   1446  CA  ASN A 181      19.207  92.386  -2.071  1.00 30.47           C  
ATOM   1447  C   ASN A 181      19.909  91.835  -0.839  1.00 30.85           C  
ATOM   1448  O   ASN A 181      20.950  92.354  -0.435  1.00 31.17           O  
ATOM   1449  CB  ASN A 181      18.872  93.861  -1.846  1.00 30.42           C  
ATOM   1450  CG  ASN A 181      19.216  94.726  -3.039  1.00 34.56           C  
ATOM   1451  OD1 ASN A 181      19.893  94.283  -3.969  1.00 35.68           O  
ATOM   1452  ND2 ASN A 181      18.762  95.976  -3.011  1.00 32.67           N  
ATOM   1453  N   GLU A 182      19.342  90.790  -0.242  1.00 30.89           N  
ATOM   1454  CA  GLU A 182      19.932  90.188   0.947  1.00 32.87           C  
ATOM   1455  C   GLU A 182      21.326  89.651   0.643  1.00 32.17           C  
ATOM   1456  O   GLU A 182      21.517  88.868  -0.286  1.00 30.83           O  
ATOM   1457  CB  GLU A 182      19.035  89.079   1.494  1.00 35.47           C  
ATOM   1458  CG  GLU A 182      19.537  88.476   2.797  1.00 40.46           C  
ATOM   1459  CD  GLU A 182      18.446  87.760   3.564  1.00 43.02           C  
ATOM   1460  OE1 GLU A 182      17.896  88.366   4.507  1.00 44.57           O  
ATOM   1461  OE2 GLU A 182      18.136  86.596   3.225  1.00 45.73           O  
ATOM   1462  N   PRO A 183      22.334  90.126   1.389  1.00 32.31           N  
ATOM   1463  CA  PRO A 183      23.721  89.702   1.209  1.00 31.51           C  
ATOM   1464  C   PRO A 183      23.926  88.244   1.592  1.00 30.49           C  
ATOM   1465  O   PRO A 183      23.390  87.771   2.595  1.00 30.08           O  
ATOM   1466  CB  PRO A 183      24.481  90.615   2.174  1.00 32.66           C  
ATOM   1467  CG  PRO A 183      23.619  91.828   2.252  1.00 34.42           C  
ATOM   1468  CD  PRO A 183      22.256  91.210   2.379  1.00 33.90           C  
ATOM   1469  N   GLU A 184      24.665  87.527   0.755  1.00 29.60           N  
ATOM   1470  CA  GLU A 184      24.977  86.134   1.021  1.00 29.80           C  
ATOM   1471  C   GLU A 184      26.330  86.169   1.724  1.00 26.52           C  
ATOM   1472  O   GLU A 184      27.356  86.420   1.094  1.00 27.64           O  
ATOM   1473  CB  GLU A 184      25.078  85.339  -0.285  1.00 33.19           C  
ATOM   1474  CG  GLU A 184      25.245  83.832  -0.082  1.00 37.23           C  
ATOM   1475  CD  GLU A 184      25.546  83.066  -1.369  1.00 40.13           C  
ATOM   1476  OE1 GLU A 184      25.317  83.602  -2.478  1.00 41.18           O  
ATOM   1477  OE2 GLU A 184      26.019  81.913  -1.269  1.00 42.02           O  
ATOM   1478  N   VAL A 185      26.312  86.013   3.042  1.00 24.04           N  
ATOM   1479  CA  VAL A 185      27.543  86.027   3.821  1.00 22.11           C  
ATOM   1480  C   VAL A 185      28.092  84.605   3.968  1.00 21.47           C  
ATOM   1481  O   VAL A 185      27.369  83.693   4.369  1.00 21.38           O  
ATOM   1482  CB  VAL A 185      27.316  86.619   5.232  1.00 22.58           C  
ATOM   1483  CG1 VAL A 185      28.643  86.728   5.971  1.00 22.49           C  
ATOM   1484  CG2 VAL A 185      26.636  87.983   5.140  1.00 23.65           C  
ATOM   1485  N   ARG A 186      29.363  84.425   3.620  1.00 20.76           N  
ATOM   1486  CA  ARG A 186      30.032  83.126   3.719  1.00 20.50           C  
ATOM   1487  C   ARG A 186      31.405  83.338   4.351  1.00 22.09           C  
ATOM   1488  O   ARG A 186      32.169  84.205   3.919  1.00 20.83           O  
ATOM   1489  CB  ARG A 186      30.181  82.480   2.338  1.00 22.19           C  
ATOM   1490  CG  ARG A 186      28.868  82.052   1.701  1.00 23.00           C  
ATOM   1491  CD  ARG A 186      28.223  80.904   2.481  1.00 27.02           C  
ATOM   1492  NE  ARG A 186      26.960  80.473   1.884  1.00 25.59           N  
ATOM   1493  CZ  ARG A 186      25.772  81.004   2.161  1.00 27.07           C  
ATOM   1494  NH1 ARG A 186      25.664  81.998   3.038  1.00 26.23           N  
ATOM   1495  NH2 ARG A 186      24.689  80.548   1.546  1.00 27.10           N  
ATOM   1496  N   ILE A 187      31.706  82.551   5.378  1.00 21.97           N  
ATOM   1497  CA  ILE A 187      32.974  82.667   6.095  1.00 24.74           C  
ATOM   1498  C   ILE A 187      34.174  82.046   5.384  1.00 27.68           C  
ATOM   1499  O   ILE A 187      35.310  82.185   5.839  1.00 28.87           O  
ATOM   1500  CB  ILE A 187      32.863  82.066   7.514  1.00 24.17           C  
ATOM   1501  CG1 ILE A 187      32.767  80.541   7.442  1.00 23.79           C  
ATOM   1502  CG2 ILE A 187      31.624  82.622   8.214  1.00 21.84           C  
ATOM   1503  CD1 ILE A 187      32.802  79.864   8.795  1.00 25.69           C  
ATOM   1504  N   GLY A 188      33.920  81.361   4.274  1.00 29.80           N  
ATOM   1505  CA  GLY A 188      35.002  80.738   3.530  1.00 33.15           C  
ATOM   1506  C   GLY A 188      34.520  79.942   2.334  1.00 34.57           C  
ATOM   1507  O   GLY A 188      33.315  80.020   2.006  1.00 35.77           O  
ATOM   1508  OXT GLY A 188      35.350  79.241   1.718  1.00 36.44           O  
TER    1509      GLY A 188                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
