
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  190 ( 1481),  selected  190 , name 2ywi_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2ywi_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     5_A      E       1           -
LGA    L     6_A      N       2           -
LGA    G     7_A      L       3           -
LGA    X     8_A      Y       4           -
LGA    P     9_A      F       5           -
LGA    A    10_A      Q       6           -
LGA    V    11_A      S       7           -
LGA    E    12_A      M       8           -
LGA    S    13_A      -       -           -
LGA    N    14_A      -       -           -
LGA    X    15_A      -       -           -
LGA    F    16_A      -       -           -
LGA    P    17_A      -       -           -
LGA    L    18_A      -       -           -
LGA    G    19_A      -       -           -
LGA    K    20_A      I       9           #
LGA    Q    21_A      N      10          4.011
LGA    -       -      S      11           -
LGA    A    22_A      F      12          2.935
LGA    P    23_A      Y      13           #
LGA    P    24_A      A      14          5.073
LGA    F    25_A      F      15          3.654
LGA    A    26_A      E      16          2.379
LGA    L    27_A      V      17          2.350
LGA    T    28_A      K      18          2.228
LGA    N    29_A      D      19          1.944
LGA    V    30_A      A      20          1.688
LGA    I    31_A      -       -           -
LGA    D    32_A      K      21          5.338
LGA    G    33_A      G      22          4.852
LGA    N    34_A      R      23          3.731
LGA    V    35_A      T      24          2.491
LGA    V    36_A      V      25          2.368
LGA    R    37_A      S      26          2.407
LGA    L    38_A      L      27          2.206
LGA    E    39_A      E      28          1.340
LGA    D    40_A      K      29          2.234
LGA    V    41_A      Y      30          1.902
LGA    K    42_A      K      31          1.919
LGA    S    43_A      G      32          2.572
LGA    D    44_A      -       -           -
LGA    A    45_A      K      33          4.154
LGA    A    46_A      V      34          1.036
LGA    T    47_A      S      35          1.662
LGA    V    48_A      L      36          1.578
LGA    I    49_A      V      37          0.886
LGA    X    50_A      V      38          1.039
LGA    F    51_A      N      39          0.920
LGA    I    52_A      V      40          1.002
LGA    C    53_A      A      41          0.978
LGA    N    54_A      S      42          0.992
LGA    H    55_A      D      43          0.935
LGA    C    56_A      C      44          1.151
LGA    P    57_A      Q      45          0.880
LGA    F    58_A      L      46          1.849
LGA    V    59_A      T      47          2.682
LGA    K    60_A      D      48          2.376
LGA    H    61_A      R      49          2.224
LGA    V    62_A      N      50          1.707
LGA    Q    63_A      Y      51          1.348
LGA    H    64_A      L      52          0.970
LGA    E    65_A      G      53          1.483
LGA    L    66_A      L      54          1.108
LGA    V    67_A      K      55          0.969
LGA    R    68_A      E      56          1.468
LGA    L    69_A      L      57          1.185
LGA    A    70_A      H      58          0.691
LGA    N    71_A      K      59          1.137
LGA    D    72_A      E      60          1.067
LGA    Y    73_A      F      61          1.115
LGA    X    74_A      G      62          0.908
LGA    P    75_A      P      63          3.811
LGA    K    76_A      S      64          4.847
LGA    G    77_A      H      65          1.408
LGA    V    78_A      F      66          0.811
LGA    S    79_A      S      67          2.291
LGA    F    80_A      V      68          2.061
LGA    V    81_A      L      69          0.730
LGA    A    82_A      A      70          0.207
LGA    I    83_A      F      71          0.314
LGA    N    84_A      P      72          1.107
LGA    S    85_A      C      73          2.554
LGA    N    86_A      N      74          1.849
LGA    D    87_A      Q      75          5.128
LGA    A    88_A      F      76           -
LGA    E    89_A      G      77           -
LGA    Q    90_A      E      78          5.436
LGA    Y    91_A      S      79          5.543
LGA    P    92_A      E      80           #
LGA    E    93_A      P      81          2.779
LGA    D    94_A      R      82          3.843
LGA    S    95_A      P      83          2.272
LGA    P    96_A      S      84          1.088
LGA    E    97_A      K      85          3.352
LGA    N    98_A      E      86          2.563
LGA    X    99_A      V      87          0.677
LGA    K   100_A      E      88          2.544
LGA    K   101_A      S      89          2.466
LGA    V   102_A      F      90          0.906
LGA    A   103_A      A      91          2.288
LGA    E   104_A      R      92          2.262
LGA    E   105_A      K      93          1.249
LGA    L   106_A      N      94          3.024
LGA    -       -      Y      95           -
LGA    G   107_A      G      96          1.842
LGA    Y   108_A      V      97          2.125
LGA    P   109_A      T      98          0.849
LGA    F   110_A      F      99          1.221
LGA    P   111_A      P     100          1.199
LGA    Y   112_A      I     101          0.856
LGA    L   113_A      F     102          1.154
LGA    Y   114_A      H     103          2.102
LGA    D   115_A      K     104          4.036
LGA    E   116_A      I     105          3.574
LGA    T   117_A      K     106          4.590
LGA    Q   118_A      I     107          3.753
LGA    -       -      L     108           -
LGA    -       -      G     109           -
LGA    -       -      S     110           -
LGA    -       -      E     111           -
LGA    -       -      G     112           -
LGA    E   119_A      E     113          2.278
LGA    V   120_A      P     114          3.751
LGA    A   121_A      A     115           #
LGA    K   122_A      F     116           #
LGA    A   123_A      R     117          0.707
LGA    Y   124_A      F     118          4.143
LGA    -       -      L     119           -
LGA    D   125_A      V     120          2.662
LGA    A   126_A      D     121           -
LGA    -       -      S     122           -
LGA    -       -      S     123           -
LGA    -       -      K     124           -
LGA    -       -      K     125           -
LGA    -       -      E     126           -
LGA    A   127_A      P     127          0.975
LGA    C   128_A      R     128          3.720
LGA    -       -      W     129           -
LGA    T   129_A      N     130          1.123
LGA    P   130_A      F     131          0.313
LGA    D   131_A      W     132          0.900
LGA    F   132_A      K     133          0.680
LGA    Y   133_A      Y     134          0.891
LGA    I   134_A      L     135          1.009
LGA    F   135_A      V     136          1.237
LGA    D   136_A      N     137          1.115
LGA    R   137_A      P     138          1.409
LGA    D   138_A      E     139          1.065
LGA    L   139_A      G     140          1.011
LGA    K   140_A      Q     141          1.221
LGA    C   141_A      V     142          1.337
LGA    V   142_A      V     143          1.577
LGA    Y   143_A      K     144          1.615
LGA    R   144_A      F     145          0.890
LGA    G   145_A      W     146          0.609
LGA    Q   146_A      R     147          4.169
LGA    -       -      P     148           -
LGA    L   147_A      E     149           #
LGA    D   148_A      E     150          3.890
LGA    D   149_A      P     151          3.499
LGA    S   150_A      -       -           -
LGA    R   151_A      -       -           -
LGA    P   152_A      -       -           -
LGA    N   153_A      -       -           -
LGA    N   154_A      -       -           -
LGA    G   155_A      -       -           -
LGA    I   156_A      -       -           -
LGA    P   157_A      -       -           -
LGA    V   158_A      -       -           -
LGA    T   159_A      -       -           -
LGA    G   160_A      I     152          1.788
LGA    E   161_A      E     153          2.007
LGA    S   162_A      V     154          2.170
LGA    I   163_A      I     155          2.262
LGA    R   164_A      R     156          1.479
LGA    A   165_A      P     157          0.511
LGA    A   166_A      D     158          0.593
LGA    L   167_A      I     159          1.405
LGA    D   168_A      A     160          1.409
LGA    A   169_A      A     161          1.065
LGA    L   170_A      L     162          0.967
LGA    L   171_A      V     163          2.502
LGA    E   172_A      R     164          2.874
LGA    G   173_A      Q     165          3.339
LGA    R   174_A      V     166           -
LGA    P   175_A      I     167           -
LGA    V   176_A      I     168           -
LGA    P   177_A      K     169           -
LGA    E   178_A      K     170           -
LGA    K   179_A      K     171           -
LGA    Q   180_A      E     172           -
LGA    K   181_A      D     173           -
LGA    P   182_A      L     174           -
LGA    S   183_A      -       -           -
LGA    I   184_A      -       -           -
LGA    G   185_A      -       -           -
LGA    C   186_A      -       -           -
LGA    S   187_A      -       -           -
LGA    I   188_A      -       -           -
LGA    K   189_A      -       -           -
LGA    W   190_A      -       -           -
LGA    K   191_A      -       -           -
LGA    P   192_A      -       -           -
LGA    S   193_A      -       -           -
LGA    A   194_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  190  174    5.0    133    2.38    18.80     52.124     5.354

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.902586 * X  +   0.403333 * Y  +   0.150539 * Z  +  -9.964159
  Y_new =  -0.298494 * X  +   0.334324 * Y  +   0.893940 * Z  +  64.230156
  Z_new =   0.310226 * X  +  -0.851792 * Y  +   0.422149 * Z  +  10.647676 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.110675    2.030918  [ DEG:   -63.6370    116.3630 ]
  Theta =  -0.315431   -2.826161  [ DEG:   -18.0729   -161.9271 ]
  Phi   =  -0.319388    2.822205  [ DEG:   -18.2996    161.7004 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ywi_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ywi_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  190  174   5.0  133   2.38   18.80  52.124
REMARK  ---------------------------------------------------------- 
MOLECULE 2ywi_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   20-APR-07   2YWI              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED CONSERVED PROTEIN FROM           
TITLE    2 GEOBACILLUS KAUSTOPHILUS                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL CONSERVED PROTEIN;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: UNCHARACTERIZED CONSERVED PROTEIN;                          
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: GEOBACILLUS KAUSTOPHILUS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HTA426;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS(DE3)-RIL-X;                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-15B                                   
KEYWDS    UNCHARACTERIZED CONSERVED PROTEIN, NPPSFA, NATIONAL PROJECT           
KEYWDS   2 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI, STRUCTURAL          
KEYWDS   4 GENOMICS, UNKNOWN FUNCTION                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.MANZOKU,A.EBIHARA,S.YOKOYAMA,S.KURAMITSU,RIKEN STRUCTURAL           
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   23-OCT-07 2YWI    0                                                
JRNL        AUTH   M.MANZOKU,A.EBIHARA,S.YOKOYAMA,S.KURAMITSU                   
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED CONSERVED               
JRNL        TITL 2 PROTEIN FROM GEOBACILLUS KAUSTOPHILUS                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2YWI A    1   194  UNP    Q5KZG6   Q5KZG6_GEOKA     1    194             
DBREF  2YWI B    1   194  UNP    Q5KZG6   Q5KZG6_GEOKA     1    194             
SEQRES   1 A  196  GLY HIS MSE GLU GLU ARG VAL LEU GLY MSE PRO ALA VAL          
SEQRES   2 A  196  GLU SER ASN MSE PHE PRO LEU GLY LYS GLN ALA PRO PRO          
SEQRES   3 A  196  PHE ALA LEU THR ASN VAL ILE ASP GLY ASN VAL VAL ARG          
SEQRES   4 A  196  LEU GLU ASP VAL LYS SER ASP ALA ALA THR VAL ILE MSE          
SEQRES   5 A  196  PHE ILE CYS ASN HIS CYS PRO PHE VAL LYS HIS VAL GLN          
SEQRES   6 A  196  HIS GLU LEU VAL ARG LEU ALA ASN ASP TYR MSE PRO LYS          
SEQRES   7 A  196  GLY VAL SER PHE VAL ALA ILE ASN SER ASN ASP ALA GLU          
SEQRES   8 A  196  GLN TYR PRO GLU ASP SER PRO GLU ASN MSE LYS LYS VAL          
SEQRES   9 A  196  ALA GLU GLU LEU GLY TYR PRO PHE PRO TYR LEU TYR ASP          
SEQRES  10 A  196  GLU THR GLN GLU VAL ALA LYS ALA TYR ASP ALA ALA CYS          
SEQRES  11 A  196  THR PRO ASP PHE TYR ILE PHE ASP ARG ASP LEU LYS CYS          
SEQRES  12 A  196  VAL TYR ARG GLY GLN LEU ASP ASP SER ARG PRO ASN ASN          
SEQRES  13 A  196  GLY ILE PRO VAL THR GLY GLU SER ILE ARG ALA ALA LEU          
SEQRES  14 A  196  ASP ALA LEU LEU GLU GLY ARG PRO VAL PRO GLU LYS GLN          
SEQRES  15 A  196  LYS PRO SER ILE GLY CYS SER ILE LYS TRP LYS PRO SER          
SEQRES  16 A  196  ALA                                                          
SEQRES   1 B  196  GLY HIS MSE GLU GLU ARG VAL LEU GLY MSE PRO ALA VAL          
SEQRES   2 B  196  GLU SER ASN MSE PHE PRO LEU GLY LYS GLN ALA PRO PRO          
SEQRES   3 B  196  PHE ALA LEU THR ASN VAL ILE ASP GLY ASN VAL VAL ARG          
SEQRES   4 B  196  LEU GLU ASP VAL LYS SER ASP ALA ALA THR VAL ILE MSE          
SEQRES   5 B  196  PHE ILE CYS ASN HIS CYS PRO PHE VAL LYS HIS VAL GLN          
SEQRES   6 B  196  HIS GLU LEU VAL ARG LEU ALA ASN ASP TYR MSE PRO LYS          
SEQRES   7 B  196  GLY VAL SER PHE VAL ALA ILE ASN SER ASN ASP ALA GLU          
SEQRES   8 B  196  GLN TYR PRO GLU ASP SER PRO GLU ASN MSE LYS LYS VAL          
SEQRES   9 B  196  ALA GLU GLU LEU GLY TYR PRO PHE PRO TYR LEU TYR ASP          
SEQRES  10 B  196  GLU THR GLN GLU VAL ALA LYS ALA TYR ASP ALA ALA CYS          
SEQRES  11 B  196  THR PRO ASP PHE TYR ILE PHE ASP ARG ASP LEU LYS CYS          
SEQRES  12 B  196  VAL TYR ARG GLY GLN LEU ASP ASP SER ARG PRO ASN ASN          
SEQRES  13 B  196  GLY ILE PRO VAL THR GLY GLU SER ILE ARG ALA ALA LEU          
SEQRES  14 B  196  ASP ALA LEU LEU GLU GLY ARG PRO VAL PRO GLU LYS GLN          
SEQRES  15 B  196  LYS PRO SER ILE GLY CYS SER ILE LYS TRP LYS PRO SER          
SEQRES  16 B  196  ALA                                                          
HET    MSE  A   8       8                                                       
HET    MSE  A  15       8                                                       
HET    MSE  A  50       8                                                       
HET    MSE  A  74       8                                                       
HET    MSE  A  99       8                                                       
HET    MSE  B   8       8                                                       
HET    MSE  B  15       8                                                       
HET    MSE  B  50       8                                                       
HET    MSE  B  74       8                                                       
HET    MSE  B  99       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   3  HOH   *412(H2 O)                                                    
CRYST1   47.382   57.223   79.526  90.00 107.15  90.00 P 1 21 1      4          
ATOM      1  N   VAL A   5       6.269  81.498  12.835  1.00 27.15           N  
ATOM      2  CA  VAL A   5       7.505  82.324  12.971  1.00 28.52           C  
ATOM      3  C   VAL A   5       7.219  83.790  12.659  1.00 26.81           C  
ATOM      4  O   VAL A   5       6.964  84.160  11.511  1.00 28.49           O  
ATOM      5  CB  VAL A   5       8.626  81.810  12.032  1.00 29.46           C  
ATOM      6  CG1 VAL A   5       9.019  80.392  12.426  1.00 31.06           C  
ATOM      7  CG2 VAL A   5       8.158  81.839  10.581  1.00 30.97           C  
ATOM      8  N   LEU A   6       7.259  84.623  13.692  1.00 24.62           N  
ATOM      9  CA  LEU A   6       6.996  86.043  13.534  1.00 20.52           C  
ATOM     10  C   LEU A   6       8.267  86.872  13.628  1.00 17.97           C  
ATOM     11  O   LEU A   6       9.180  86.546  14.386  1.00 15.94           O  
ATOM     12  CB  LEU A   6       6.013  86.525  14.605  1.00 21.69           C  
ATOM     13  CG  LEU A   6       4.581  85.992  14.544  1.00 23.45           C  
ATOM     14  CD1 LEU A   6       3.818  86.447  15.779  1.00 24.66           C  
ATOM     15  CD2 LEU A   6       3.898  86.488  13.277  1.00 24.17           C  
ATOM     16  N   GLY A   7       8.306  87.947  12.850  1.00 15.96           N  
ATOM     17  CA  GLY A   7       9.442  88.844  12.875  1.00 13.47           C  
ATOM     18  C   GLY A   7      10.697  88.346  12.202  1.00 13.48           C  
ATOM     19  O   GLY A   7      10.686  87.339  11.497  1.00 13.61           O  
HETATM   20  N   MSE A   8      11.788  89.066  12.448  1.00 13.03           N  
HETATM   21  CA  MSE A   8      13.094  88.767  11.874  1.00 14.46           C  
HETATM   22  C   MSE A   8      14.156  88.859  12.956  1.00 13.13           C  
HETATM   23  O   MSE A   8      14.088  89.722  13.829  1.00 12.44           O  
HETATM   24  CB  MSE A   8      13.441  89.784  10.790  1.00 17.47           C  
HETATM   25  CG  MSE A   8      12.444  89.897   9.658  1.00 24.27           C  
HETATM   26 SE   MSE A   8      13.002  91.273   8.420  1.00 38.91          SE  
HETATM   27  CE  MSE A   8      14.291  90.250   7.418  1.00 33.54           C  
ATOM     28  N   PRO A   9      15.162  87.979  12.903  1.00 12.02           N  
ATOM     29  CA  PRO A   9      16.215  88.025  13.916  1.00 11.86           C  
ATOM     30  C   PRO A   9      17.134  89.232  13.741  1.00 12.33           C  
ATOM     31  O   PRO A   9      17.245  89.796  12.646  1.00 12.77           O  
ATOM     32  CB  PRO A   9      16.942  86.697  13.717  1.00 13.18           C  
ATOM     33  CG  PRO A   9      16.765  86.433  12.252  1.00 14.28           C  
ATOM     34  CD  PRO A   9      15.326  86.810  12.019  1.00 12.20           C  
ATOM     35  N   ALA A  10      17.770  89.641  14.831  1.00 11.55           N  
ATOM     36  CA  ALA A  10      18.702  90.758  14.783  1.00 12.20           C  
ATOM     37  C   ALA A  10      19.967  90.212  14.127  1.00 11.44           C  
ATOM     38  O   ALA A  10      20.185  88.997  14.118  1.00 12.99           O  
ATOM     39  CB  ALA A  10      19.002  91.244  16.187  1.00 12.82           C  
ATOM     40  N   VAL A  11      20.780  91.099  13.561  1.00  9.89           N  
ATOM     41  CA  VAL A  11      22.026  90.694  12.911  1.00 10.72           C  
ATOM     42  C   VAL A  11      23.177  91.567  13.406  1.00  9.02           C  
ATOM     43  O   VAL A  11      22.958  92.689  13.851  1.00  8.40           O  
ATOM     44  CB  VAL A  11      21.924  90.805  11.377  1.00 13.74           C  
ATOM     45  CG1 VAL A  11      20.782  89.931  10.866  1.00 15.74           C  
ATOM     46  CG2 VAL A  11      21.703  92.247  10.977  1.00 14.40           C  
ATOM     47  N   GLU A  12      24.397  91.043  13.333  1.00 10.05           N  
ATOM     48  CA  GLU A  12      25.590  91.765  13.784  1.00 10.16           C  
ATOM     49  C   GLU A  12      26.365  92.373  12.630  1.00  9.52           C  
ATOM     50  O   GLU A  12      26.198  91.977  11.483  1.00 10.50           O  
ATOM     51  CB  GLU A  12      26.535  90.824  14.535  1.00 11.58           C  
ATOM     52  CG  GLU A  12      26.134  90.481  15.954  1.00 16.75           C  
ATOM     53  CD  GLU A  12      27.051  89.433  16.558  1.00 19.81           C  
ATOM     54  OE1 GLU A  12      28.273  89.473  16.284  1.00 23.60           O  
ATOM     55  OE2 GLU A  12      26.554  88.571  17.307  1.00 21.68           O  
ATOM     56  N   SER A  13      27.236  93.322  12.956  1.00  9.16           N  
ATOM     57  CA  SER A  13      28.071  93.985  11.961  1.00  8.74           C  
ATOM     58  C   SER A  13      28.885  92.955  11.177  1.00  9.87           C  
ATOM     59  O   SER A  13      29.188  91.873  11.685  1.00 11.58           O  
ATOM     60  CB  SER A  13      29.033  94.953  12.650  1.00  8.66           C  
ATOM     61  OG  SER A  13      28.323  95.948  13.359  1.00  6.90           O  
ATOM     62  N   ASN A  14      29.242  93.300   9.943  1.00  8.94           N  
ATOM     63  CA  ASN A  14      30.042  92.410   9.109  1.00  9.62           C  
ATOM     64  C   ASN A  14      31.520  92.750   9.228  1.00 10.34           C  
ATOM     65  O   ASN A  14      32.366  92.133   8.577  1.00 11.44           O  
ATOM     66  CB  ASN A  14      29.599  92.492   7.646  1.00  9.50           C  
ATOM     67  CG  ASN A  14      28.273  91.805   7.410  1.00 11.72           C  
ATOM     68  OD1 ASN A  14      27.982  90.784   8.029  1.00 11.34           O  
ATOM     69  ND2 ASN A  14      27.466  92.353   6.509  1.00 14.32           N  
HETATM   70  N   MSE A  15      31.809  93.737  10.073  1.00  9.87           N  
HETATM   71  CA  MSE A  15      33.159  94.200  10.359  1.00  9.61           C  
HETATM   72  C   MSE A  15      34.002  94.609   9.158  1.00 10.14           C  
HETATM   73  O   MSE A  15      34.965  93.933   8.788  1.00 10.71           O  
HETATM   74  CB  MSE A  15      33.907  93.153  11.196  1.00 11.59           C  
HETATM   75  CG  MSE A  15      33.226  92.838  12.537  1.00 11.32           C  
HETATM   76 SE   MSE A  15      32.727  94.403  13.546  1.00 14.78          SE  
HETATM   77  CE  MSE A  15      34.346  94.694  14.522  1.00 10.74           C  
ATOM     78  N   PHE A  16      33.626  95.733   8.560  1.00  8.98           N  
ATOM     79  CA  PHE A  16      34.350  96.300   7.424  1.00  9.15           C  
ATOM     80  C   PHE A  16      35.838  96.302   7.801  1.00  8.97           C  
ATOM     81  O   PHE A  16      36.196  96.672   8.919  1.00 10.41           O  
ATOM     82  CB  PHE A  16      33.854  97.731   7.200  1.00  7.77           C  
ATOM     83  CG  PHE A  16      34.379  98.379   5.956  1.00  7.08           C  
ATOM     84  CD1 PHE A  16      33.809  98.107   4.719  1.00  7.89           C  
ATOM     85  CD2 PHE A  16      35.420  99.301   6.030  1.00  8.48           C  
ATOM     86  CE1 PHE A  16      34.265  98.752   3.566  1.00  8.73           C  
ATOM     87  CE2 PHE A  16      35.881  99.948   4.886  1.00  7.01           C  
ATOM     88  CZ  PHE A  16      35.300  99.674   3.653  1.00  9.32           C  
ATOM     89  N   PRO A  17      36.725  95.914   6.867  1.00  8.76           N  
ATOM     90  CA  PRO A  17      38.179  95.847   7.073  1.00  9.64           C  
ATOM     91  C   PRO A  17      38.889  97.104   7.571  1.00 10.24           C  
ATOM     92  O   PRO A  17      38.752  98.185   6.997  1.00  8.45           O  
ATOM     93  CB  PRO A  17      38.712  95.440   5.694  1.00 10.19           C  
ATOM     94  CG  PRO A  17      37.568  94.751   5.054  1.00 11.39           C  
ATOM     95  CD  PRO A  17      36.383  95.571   5.477  1.00  8.80           C  
ATOM     96  N   LEU A  18      39.665  96.960   8.640  1.00 11.00           N  
ATOM     97  CA  LEU A  18      40.422  98.097   9.141  1.00  9.79           C  
ATOM     98  C   LEU A  18      41.454  98.417   8.058  1.00 11.01           C  
ATOM     99  O   LEU A  18      42.043  97.509   7.463  1.00 12.15           O  
ATOM    100  CB  LEU A  18      41.135  97.746  10.453  1.00  8.57           C  
ATOM    101  CG  LEU A  18      40.243  97.597  11.687  1.00  9.93           C  
ATOM    102  CD1 LEU A  18      41.076  97.107  12.863  1.00 12.97           C  
ATOM    103  CD2 LEU A  18      39.586  98.943  12.016  1.00  9.75           C  
ATOM    104  N   GLY A  19      41.646  99.703   7.789  1.00 10.92           N  
ATOM    105  CA  GLY A  19      42.610 100.117   6.785  1.00 10.69           C  
ATOM    106  C   GLY A  19      42.029 100.339   5.401  1.00 12.11           C  
ATOM    107  O   GLY A  19      42.657 100.976   4.552  1.00 11.75           O  
ATOM    108  N   LYS A  20      40.829  99.822   5.162  1.00 10.63           N  
ATOM    109  CA  LYS A  20      40.197  99.975   3.864  1.00  9.91           C  
ATOM    110  C   LYS A  20      39.587 101.363   3.684  1.00  9.48           C  
ATOM    111  O   LYS A  20      39.021 101.930   4.620  1.00  8.50           O  
ATOM    112  CB  LYS A  20      39.128  98.897   3.675  1.00 11.00           C  
ATOM    113  CG  LYS A  20      38.538  98.857   2.274  1.00 11.20           C  
ATOM    114  CD  LYS A  20      37.582  97.689   2.118  1.00 13.14           C  
ATOM    115  CE  LYS A  20      37.026  97.623   0.706  1.00 15.38           C  
ATOM    116  NZ  LYS A  20      38.111  97.331  -0.276  1.00 19.27           N  
ATOM    117  N   GLN A  21      39.714 101.900   2.473  1.00  8.44           N  
ATOM    118  CA  GLN A  21      39.189 103.221   2.139  1.00 10.16           C  
ATOM    119  C   GLN A  21      37.669 103.281   2.210  1.00  8.90           C  
ATOM    120  O   GLN A  21      36.979 102.358   1.775  1.00 10.23           O  
ATOM    121  CB  GLN A  21      39.615 103.620   0.724  1.00 12.94           C  
ATOM    122  CG  GLN A  21      41.097 103.892   0.544  1.00 18.70           C  
ATOM    123  CD  GLN A  21      41.561 105.100   1.327  1.00 22.79           C  
ATOM    124  OE1 GLN A  21      40.934 106.160   1.284  1.00 25.70           O  
ATOM    125  NE2 GLN A  21      42.670 104.953   2.041  1.00 24.06           N  
ATOM    126  N   ALA A  22      37.147 104.376   2.752  1.00  9.79           N  
ATOM    127  CA  ALA A  22      35.704 104.545   2.823  1.00  8.58           C  
ATOM    128  C   ALA A  22      35.182 104.576   1.389  1.00  9.34           C  
ATOM    129  O   ALA A  22      35.687 105.332   0.556  1.00  9.12           O  
ATOM    130  CB  ALA A  22      35.364 105.849   3.526  1.00  8.59           C  
ATOM    131  N   PRO A  23      34.184 103.736   1.074  1.00  9.72           N  
ATOM    132  CA  PRO A  23      33.631 103.718  -0.284  1.00 10.40           C  
ATOM    133  C   PRO A  23      32.973 105.055  -0.621  1.00 10.89           C  
ATOM    134  O   PRO A  23      32.511 105.774   0.259  1.00 10.81           O  
ATOM    135  CB  PRO A  23      32.615 102.584  -0.232  1.00 10.16           C  
ATOM    136  CG  PRO A  23      33.210 101.649   0.782  1.00  9.68           C  
ATOM    137  CD  PRO A  23      33.697 102.586   1.858  1.00  9.94           C  
ATOM    138  N   PRO A  24      32.921 105.405  -1.909  1.00 12.01           N  
ATOM    139  CA  PRO A  24      32.299 106.678  -2.265  1.00 12.17           C  
ATOM    140  C   PRO A  24      30.790 106.692  -2.071  1.00 11.12           C  
ATOM    141  O   PRO A  24      30.155 105.648  -1.910  1.00 11.41           O  
ATOM    142  CB  PRO A  24      32.689 106.847  -3.731  1.00 14.26           C  
ATOM    143  CG  PRO A  24      32.737 105.437  -4.224  1.00 14.96           C  
ATOM    144  CD  PRO A  24      33.434 104.709  -3.102  1.00 13.92           C  
ATOM    145  N   PHE A  25      30.229 107.893  -2.049  1.00 11.45           N  
ATOM    146  CA  PHE A  25      28.789 108.055  -1.944  1.00  9.23           C  
ATOM    147  C   PHE A  25      28.393 109.475  -2.313  1.00  8.86           C  
ATOM    148  O   PHE A  25      29.142 110.429  -2.082  1.00  9.39           O  
ATOM    149  CB  PHE A  25      28.256 107.656  -0.545  1.00  9.60           C  
ATOM    150  CG  PHE A  25      28.580 108.625   0.571  1.00  8.62           C  
ATOM    151  CD1 PHE A  25      27.947 109.866   0.657  1.00  9.24           C  
ATOM    152  CD2 PHE A  25      29.494 108.273   1.560  1.00  8.96           C  
ATOM    153  CE1 PHE A  25      28.220 110.740   1.713  1.00 11.47           C  
ATOM    154  CE2 PHE A  25      29.776 109.136   2.619  1.00 10.15           C  
ATOM    155  CZ  PHE A  25      29.139 110.374   2.698  1.00 11.77           C  
ATOM    156  N   ALA A  26      27.237 109.587  -2.954  1.00  7.24           N  
ATOM    157  CA  ALA A  26      26.674 110.869  -3.364  1.00  8.24           C  
ATOM    158  C   ALA A  26      25.197 110.645  -3.123  1.00  8.34           C  
ATOM    159  O   ALA A  26      24.515 110.013  -3.934  1.00  8.82           O  
ATOM    160  CB  ALA A  26      26.947 111.134  -4.847  1.00  8.27           C  
ATOM    161  N   LEU A  27      24.701 111.146  -1.996  1.00  8.12           N  
ATOM    162  CA  LEU A  27      23.306 110.923  -1.640  1.00  7.31           C  
ATOM    163  C   LEU A  27      22.601 112.167  -1.165  1.00  6.03           C  
ATOM    164  O   LEU A  27      23.216 113.067  -0.597  1.00  8.54           O  
ATOM    165  CB  LEU A  27      23.219 109.882  -0.528  1.00  6.83           C  
ATOM    166  CG  LEU A  27      23.895 108.527  -0.723  1.00  6.46           C  
ATOM    167  CD1 LEU A  27      23.958 107.805   0.626  1.00  7.10           C  
ATOM    168  CD2 LEU A  27      23.134 107.707  -1.751  1.00  8.07           C  
ATOM    169  N   THR A  28      21.291 112.191  -1.367  1.00  6.78           N  
ATOM    170  CA  THR A  28      20.487 113.322  -0.947  1.00  6.58           C  
ATOM    171  C   THR A  28      20.251 113.355   0.556  1.00  7.53           C  
ATOM    172  O   THR A  28      19.889 112.351   1.173  1.00  8.26           O  
ATOM    173  CB  THR A  28      19.124 113.320  -1.654  1.00  6.88           C  
ATOM    174  OG1 THR A  28      19.327 113.503  -3.062  1.00  9.42           O  
ATOM    175  CG2 THR A  28      18.238 114.454  -1.121  1.00  6.78           C  
ATOM    176  N   ASN A  29      20.482 114.531   1.131  1.00  8.41           N  
ATOM    177  CA  ASN A  29      20.276 114.789   2.551  1.00  8.21           C  
ATOM    178  C   ASN A  29      18.817 115.239   2.651  1.00  9.81           C  
ATOM    179  O   ASN A  29      18.427 116.225   2.018  1.00 10.70           O  
ATOM    180  CB  ASN A  29      21.228 115.910   3.000  1.00  7.47           C  
ATOM    181  CG  ASN A  29      21.012 116.332   4.441  1.00  7.93           C  
ATOM    182  OD1 ASN A  29      20.281 115.685   5.189  1.00  7.01           O  
ATOM    183  ND2 ASN A  29      21.662 117.425   4.841  1.00  7.20           N  
ATOM    184  N   VAL A  30      18.010 114.517   3.423  1.00  9.15           N  
ATOM    185  CA  VAL A  30      16.596 114.858   3.548  1.00  9.75           C  
ATOM    186  C   VAL A  30      16.327 116.141   4.320  1.00 10.66           C  
ATOM    187  O   VAL A  30      15.256 116.730   4.194  1.00 11.71           O  
ATOM    188  CB  VAL A  30      15.799 113.716   4.219  1.00  7.83           C  
ATOM    189  CG1 VAL A  30      15.902 112.460   3.369  1.00  9.21           C  
ATOM    190  CG2 VAL A  30      16.328 113.457   5.633  1.00  9.87           C  
ATOM    191  N   ILE A  31      17.293 116.579   5.116  1.00 10.61           N  
ATOM    192  CA  ILE A  31      17.097 117.785   5.906  1.00 11.73           C  
ATOM    193  C   ILE A  31      17.000 119.049   5.051  1.00 11.71           C  
ATOM    194  O   ILE A  31      16.183 119.921   5.335  1.00 13.20           O  
ATOM    195  CB  ILE A  31      18.210 117.923   6.974  1.00 11.96           C  
ATOM    196  CG1 ILE A  31      18.131 116.727   7.932  1.00 12.26           C  
ATOM    197  CG2 ILE A  31      18.040 119.226   7.763  1.00 11.95           C  
ATOM    198  CD1 ILE A  31      19.247 116.655   8.961  1.00 11.89           C  
ATOM    199  N   ASP A  32      17.814 119.151   4.003  1.00 12.65           N  
ATOM    200  CA  ASP A  32      17.758 120.333   3.146  1.00 12.44           C  
ATOM    201  C   ASP A  32      17.628 120.023   1.659  1.00 12.03           C  
ATOM    202  O   ASP A  32      17.486 120.931   0.846  1.00 12.25           O  
ATOM    203  CB  ASP A  32      18.977 121.239   3.381  1.00 15.09           C  
ATOM    204  CG  ASP A  32      20.301 120.533   3.139  1.00 16.08           C  
ATOM    205  OD1 ASP A  32      20.306 119.454   2.516  1.00 14.51           O  
ATOM    206  OD2 ASP A  32      21.341 121.074   3.571  1.00 19.16           O  
ATOM    207  N   GLY A  33      17.672 118.740   1.309  1.00 12.13           N  
ATOM    208  CA  GLY A  33      17.556 118.340  -0.083  1.00 10.76           C  
ATOM    209  C   GLY A  33      18.849 118.381  -0.879  1.00 10.82           C  
ATOM    210  O   GLY A  33      18.844 118.131  -2.082  1.00 11.44           O  
ATOM    211  N   ASN A  34      19.962 118.682  -0.220  1.00  9.79           N  
ATOM    212  CA  ASN A  34      21.252 118.759  -0.902  1.00  9.22           C  
ATOM    213  C   ASN A  34      21.870 117.388  -1.127  1.00  9.39           C  
ATOM    214  O   ASN A  34      21.703 116.484  -0.311  1.00  9.98           O  
ATOM    215  CB  ASN A  34      22.236 119.593  -0.080  1.00  8.97           C  
ATOM    216  CG  ASN A  34      22.145 121.077  -0.377  1.00 10.97           C  
ATOM    217  OD1 ASN A  34      21.138 121.566  -0.883  1.00 12.71           O  
ATOM    218  ND2 ASN A  34      23.203 121.804  -0.043  1.00 12.01           N  
ATOM    219  N   VAL A  35      22.581 117.237  -2.239  1.00  8.24           N  
ATOM    220  CA  VAL A  35      23.264 115.982  -2.513  1.00  7.69           C  
ATOM    221  C   VAL A  35      24.606 116.118  -1.788  1.00  9.37           C  
ATOM    222  O   VAL A  35      25.374 117.043  -2.053  1.00  9.02           O  
ATOM    223  CB  VAL A  35      23.484 115.771  -4.033  1.00  8.36           C  
ATOM    224  CG1 VAL A  35      24.394 114.556  -4.277  1.00  8.57           C  
ATOM    225  CG2 VAL A  35      22.131 115.563  -4.724  1.00  8.49           C  
ATOM    226  N   VAL A  36      24.862 115.210  -0.850  1.00  8.23           N  
ATOM    227  CA  VAL A  36      26.098 115.226  -0.071  1.00  8.38           C  
ATOM    228  C   VAL A  36      27.021 114.092  -0.504  1.00  8.09           C  
ATOM    229  O   VAL A  36      26.579 112.959  -0.685  1.00  8.51           O  
ATOM    230  CB  VAL A  36      25.786 115.089   1.435  1.00  7.00           C  
ATOM    231  CG1 VAL A  36      27.082 115.096   2.248  1.00  8.32           C  
ATOM    232  CG2 VAL A  36      24.882 116.236   1.874  1.00  9.88           C  
ATOM    233  N   ARG A  37      28.304 114.402  -0.667  1.00  9.83           N  
ATOM    234  CA  ARG A  37      29.289 113.411  -1.094  1.00 10.12           C  
ATOM    235  C   ARG A  37      30.336 113.124  -0.032  1.00 10.21           C  
ATOM    236  O   ARG A  37      30.542 113.916   0.883  1.00 10.27           O  
ATOM    237  CB  ARG A  37      29.979 113.891  -2.367  1.00 11.02           C  
ATOM    238  CG  ARG A  37      28.999 114.105  -3.497  1.00 10.98           C  
ATOM    239  CD  ARG A  37      29.568 114.954  -4.617  1.00 13.63           C  
ATOM    240  NE  ARG A  37      28.527 115.214  -5.606  1.00 15.63           N  
ATOM    241  CZ  ARG A  37      28.190 114.371  -6.577  1.00 16.52           C  
ATOM    242  NH1 ARG A  37      28.823 113.213  -6.712  1.00 18.52           N  
ATOM    243  NH2 ARG A  37      27.184 114.667  -7.389  1.00 15.86           N  
ATOM    244  N   LEU A  38      30.996 111.978  -0.166  1.00 11.35           N  
ATOM    245  CA  LEU A  38      32.033 111.581   0.776  1.00 11.53           C  
ATOM    246  C   LEU A  38      33.058 112.698   0.912  1.00 12.72           C  
ATOM    247  O   LEU A  38      33.489 113.027   2.013  1.00 10.66           O  
ATOM    248  CB  LEU A  38      32.722 110.306   0.289  1.00 11.51           C  
ATOM    249  CG  LEU A  38      33.909 109.820   1.125  1.00 12.38           C  
ATOM    250  CD1 LEU A  38      33.463 109.573   2.556  1.00 10.88           C  
ATOM    251  CD2 LEU A  38      34.478 108.548   0.506  1.00 13.25           C  
ATOM    252  N   GLU A  39      33.448 113.281  -0.216  1.00 12.95           N  
ATOM    253  CA  GLU A  39      34.426 114.360  -0.201  1.00 14.79           C  
ATOM    254  C   GLU A  39      33.964 115.539   0.660  1.00 15.54           C  
ATOM    255  O   GLU A  39      34.788 116.263   1.218  1.00 16.05           O  
ATOM    256  CB  GLU A  39      34.704 114.840  -1.631  1.00 16.46           C  
ATOM    257  CG  GLU A  39      35.350 113.796  -2.547  1.00 22.28           C  
ATOM    258  CD  GLU A  39      34.522 112.523  -2.696  1.00 25.41           C  
ATOM    259  OE1 GLU A  39      33.309 112.623  -2.986  1.00 22.11           O  
ATOM    260  OE2 GLU A  39      35.095 111.419  -2.531  1.00 27.35           O  
ATOM    261  N   ASP A  40      32.650 115.721   0.778  1.00 15.06           N  
ATOM    262  CA  ASP A  40      32.098 116.823   1.566  1.00 16.33           C  
ATOM    263  C   ASP A  40      32.216 116.604   3.075  1.00 16.29           C  
ATOM    264  O   ASP A  40      32.108 117.552   3.852  1.00 17.63           O  
ATOM    265  CB  ASP A  40      30.622 117.058   1.214  1.00 17.75           C  
ATOM    266  CG  ASP A  40      30.417 117.437  -0.243  1.00 19.97           C  
ATOM    267  OD1 ASP A  40      31.213 118.242  -0.769  1.00 21.70           O  
ATOM    268  OD2 ASP A  40      29.451 116.939  -0.859  1.00 18.43           O  
ATOM    269  N   VAL A  41      32.435 115.360   3.488  1.00 16.76           N  
ATOM    270  CA  VAL A  41      32.550 115.052   4.910  1.00 18.47           C  
ATOM    271  C   VAL A  41      33.951 114.609   5.331  1.00 18.90           C  
ATOM    272  O   VAL A  41      34.164 114.209   6.477  1.00 19.15           O  
ATOM    273  CB  VAL A  41      31.524 113.969   5.324  1.00 19.24           C  
ATOM    274  CG1 VAL A  41      30.116 114.463   5.030  1.00 21.64           C  
ATOM    275  CG2 VAL A  41      31.793 112.668   4.584  1.00 20.03           C  
ATOM    276  N   LYS A  42      34.909 114.673   4.410  1.00 18.36           N  
ATOM    277  CA  LYS A  42      36.278 114.295   4.744  1.00 19.40           C  
ATOM    278  C   LYS A  42      36.727 115.277   5.829  1.00 18.96           C  
ATOM    279  O   LYS A  42      36.520 116.483   5.705  1.00 18.49           O  
ATOM    280  CB  LYS A  42      37.179 114.404   3.510  1.00 20.98           C  
ATOM    281  CG  LYS A  42      38.584 113.853   3.715  1.00 23.08           C  
ATOM    282  CD  LYS A  42      39.407 113.968   2.444  1.00 25.45           C  
ATOM    283  CE  LYS A  42      40.784 113.346   2.616  1.00 27.74           C  
ATOM    284  NZ  LYS A  42      41.615 113.505   1.393  1.00 29.49           N  
ATOM    285  N   SER A  43      37.336 114.750   6.887  1.00 19.07           N  
ATOM    286  CA  SER A  43      37.772 115.562   8.021  1.00 18.18           C  
ATOM    287  C   SER A  43      39.281 115.526   8.245  1.00 17.87           C  
ATOM    288  O   SER A  43      39.970 114.635   7.759  1.00 18.99           O  
ATOM    289  CB  SER A  43      37.047 115.072   9.286  1.00 16.71           C  
ATOM    290  OG  SER A  43      37.561 115.656  10.469  1.00 19.66           O  
ATOM    291  N   ASP A  44      39.789 116.507   8.984  1.00 18.66           N  
ATOM    292  CA  ASP A  44      41.212 116.565   9.280  1.00 19.54           C  
ATOM    293  C   ASP A  44      41.547 115.582  10.390  1.00 18.90           C  
ATOM    294  O   ASP A  44      42.713 115.280  10.632  1.00 18.22           O  
ATOM    295  CB  ASP A  44      41.613 117.979   9.706  1.00 24.16           C  
ATOM    296  CG  ASP A  44      41.686 118.938   8.535  1.00 29.19           C  
ATOM    297  OD1 ASP A  44      42.504 118.691   7.621  1.00 32.91           O  
ATOM    298  OD2 ASP A  44      40.931 119.934   8.524  1.00 32.85           O  
ATOM    299  N   ALA A  45      40.514 115.073  11.057  1.00 17.05           N  
ATOM    300  CA  ALA A  45      40.717 114.133  12.151  1.00 15.34           C  
ATOM    301  C   ALA A  45      39.959 112.823  11.979  1.00 13.10           C  
ATOM    302  O   ALA A  45      40.564 111.756  11.907  1.00 13.82           O  
ATOM    303  CB  ALA A  45      40.326 114.785  13.472  1.00 17.88           C  
ATOM    304  N   ALA A  46      38.634 112.902  11.920  1.00 11.64           N  
ATOM    305  CA  ALA A  46      37.836 111.691  11.785  1.00  9.34           C  
ATOM    306  C   ALA A  46      36.473 111.929  11.162  1.00  9.57           C  
ATOM    307  O   ALA A  46      35.894 113.012  11.288  1.00  9.72           O  
ATOM    308  CB  ALA A  46      37.668 111.041  13.152  1.00  9.57           C  
ATOM    309  N   THR A  47      35.977 110.903  10.483  1.00  8.23           N  
ATOM    310  CA  THR A  47      34.670 110.943   9.843  1.00  9.14           C  
ATOM    311  C   THR A  47      33.882 109.747  10.359  1.00  7.79           C  
ATOM    312  O   THR A  47      34.311 108.603  10.199  1.00  8.43           O  
ATOM    313  CB  THR A  47      34.794 110.843   8.307  1.00  9.70           C  
ATOM    314  OG1 THR A  47      35.561 111.949   7.816  1.00 12.13           O  
ATOM    315  CG2 THR A  47      33.413 110.868   7.651  1.00 10.59           C  
ATOM    316  N   VAL A  48      32.745 110.014  10.996  1.00  7.93           N  
ATOM    317  CA  VAL A  48      31.899 108.953  11.536  1.00  6.92           C  
ATOM    318  C   VAL A  48      30.685 108.747  10.633  1.00  6.10           C  
ATOM    319  O   VAL A  48      29.913 109.681  10.390  1.00  7.05           O  
ATOM    320  CB  VAL A  48      31.398 109.309  12.956  1.00  6.92           C  
ATOM    321  CG1 VAL A  48      30.589 108.161  13.537  1.00  8.24           C  
ATOM    322  CG2 VAL A  48      32.581 109.630  13.858  1.00  5.84           C  
ATOM    323  N   ILE A  49      30.533 107.527  10.125  1.00  6.78           N  
ATOM    324  CA  ILE A  49      29.400 107.201   9.264  1.00  7.30           C  
ATOM    325  C   ILE A  49      28.517 106.215  10.018  1.00  7.63           C  
ATOM    326  O   ILE A  49      29.001 105.213  10.549  1.00  6.27           O  
ATOM    327  CB  ILE A  49      29.874 106.593   7.935  1.00  9.26           C  
ATOM    328  CG1 ILE A  49      30.813 107.591   7.242  1.00 11.32           C  
ATOM    329  CG2 ILE A  49      28.669 106.261   7.048  1.00  9.18           C  
ATOM    330  CD1 ILE A  49      31.349 107.140   5.905  1.00 15.11           C  
HETATM  331  N   MSE A  50      27.220 106.508  10.056  1.00  7.16           N  
HETATM  332  CA  MSE A  50      26.279 105.680  10.794  1.00  8.27           C  
HETATM  333  C   MSE A  50      25.096 105.221   9.947  1.00  7.49           C  
HETATM  334  O   MSE A  50      24.389 106.040   9.363  1.00  8.50           O  
HETATM  335  CB  MSE A  50      25.753 106.474  11.994  1.00  9.31           C  
HETATM  336  CG  MSE A  50      26.834 107.260  12.765  1.00 11.06           C  
HETATM  337 SE   MSE A  50      26.192 108.619  13.957  1.00 14.05          SE  
HETATM  338  CE  MSE A  50      25.835 109.985  12.679  1.00 11.74           C  
ATOM    339  N   PHE A  51      24.889 103.913   9.877  1.00  5.72           N  
ATOM    340  CA  PHE A  51      23.759 103.375   9.130  1.00  5.52           C  
ATOM    341  C   PHE A  51      22.646 103.131  10.141  1.00  5.35           C  
ATOM    342  O   PHE A  51      22.798 102.339  11.074  1.00  6.62           O  
ATOM    343  CB  PHE A  51      24.158 102.077   8.420  1.00  4.68           C  
ATOM    344  CG  PHE A  51      24.993 102.298   7.181  1.00  5.63           C  
ATOM    345  CD1 PHE A  51      24.388 102.418   5.932  1.00  6.66           C  
ATOM    346  CD2 PHE A  51      26.374 102.408   7.267  1.00  5.32           C  
ATOM    347  CE1 PHE A  51      25.150 102.647   4.781  1.00  5.51           C  
ATOM    348  CE2 PHE A  51      27.146 102.637   6.129  1.00  5.59           C  
ATOM    349  CZ  PHE A  51      26.530 102.757   4.882  1.00  7.74           C  
ATOM    350  N   ILE A  52      21.528 103.823   9.956  1.00  6.49           N  
ATOM    351  CA  ILE A  52      20.409 103.708  10.878  1.00  7.14           C  
ATOM    352  C   ILE A  52      19.083 103.672  10.129  1.00  8.52           C  
ATOM    353  O   ILE A  52      19.052 103.559   8.903  1.00  8.79           O  
ATOM    354  CB  ILE A  52      20.405 104.913  11.856  1.00  6.08           C  
ATOM    355  CG1 ILE A  52      20.185 106.224  11.084  1.00  6.06           C  
ATOM    356  CG2 ILE A  52      21.747 104.977  12.602  1.00  7.84           C  
ATOM    357  CD1 ILE A  52      20.078 107.459  11.968  1.00  5.78           C  
ATOM    358  N   CYS A  53      17.991 103.759  10.881  1.00  8.79           N  
ATOM    359  CA  CYS A  53      16.658 103.787  10.298  1.00 10.04           C  
ATOM    360  C   CYS A  53      15.730 104.441  11.323  1.00 10.75           C  
ATOM    361  O   CYS A  53      16.195 104.908  12.368  1.00 10.72           O  
ATOM    362  CB  CYS A  53      16.187 102.376   9.932  1.00 10.21           C  
ATOM    363  SG  CYS A  53      15.904 101.288  11.325  1.00 12.50           S  
ATOM    364  N   ASN A  54      14.433 104.472  11.045  1.00 10.08           N  
ATOM    365  CA  ASN A  54      13.505 105.134  11.958  1.00 12.01           C  
ATOM    366  C   ASN A  54      12.650 104.259  12.864  1.00 14.14           C  
ATOM    367  O   ASN A  54      12.093 104.753  13.842  1.00 15.10           O  
ATOM    368  CB  ASN A  54      12.587 106.074  11.169  1.00 12.19           C  
ATOM    369  CG  ASN A  54      13.362 107.081  10.334  1.00 12.69           C  
ATOM    370  OD1 ASN A  54      14.415 107.554  10.742  1.00 13.34           O  
ATOM    371  ND2 ASN A  54      12.834 107.417   9.161  1.00 14.24           N  
ATOM    372  N   HIS A  55      12.538 102.973  12.555  1.00 13.01           N  
ATOM    373  CA  HIS A  55      11.706 102.095  13.369  1.00 14.51           C  
ATOM    374  C   HIS A  55      12.417 100.786  13.706  1.00 13.29           C  
ATOM    375  O   HIS A  55      12.095  99.725  13.174  1.00 16.43           O  
ATOM    376  CB  HIS A  55      10.394 101.831  12.627  1.00 17.00           C  
ATOM    377  CG  HIS A  55       9.296 101.300  13.493  1.00 19.11           C  
ATOM    378  ND1 HIS A  55       9.073 101.757  14.775  1.00 19.88           N  
ATOM    379  CD2 HIS A  55       8.317 100.400  13.237  1.00 20.69           C  
ATOM    380  CE1 HIS A  55       8.002 101.162  15.270  1.00 19.77           C  
ATOM    381  NE2 HIS A  55       7.525 100.335  14.357  1.00 21.71           N  
ATOM    382  N   CYS A  56      13.402 100.887  14.590  1.00 12.22           N  
ATOM    383  CA  CYS A  56      14.201  99.748  15.040  1.00 10.10           C  
ATOM    384  C   CYS A  56      14.481  99.998  16.513  1.00  9.60           C  
ATOM    385  O   CYS A  56      14.905 101.089  16.885  1.00 10.01           O  
ATOM    386  CB  CYS A  56      15.522  99.688  14.263  1.00 10.95           C  
ATOM    387  SG  CYS A  56      16.780  98.613  15.002  1.00 11.96           S  
ATOM    388  N   PRO A  57      14.239  98.998  17.376  1.00  7.34           N  
ATOM    389  CA  PRO A  57      14.495  99.223  18.801  1.00  7.78           C  
ATOM    390  C   PRO A  57      15.955  99.477  19.151  1.00  6.48           C  
ATOM    391  O   PRO A  57      16.251 100.147  20.146  1.00  7.43           O  
ATOM    392  CB  PRO A  57      13.944  97.959  19.461  1.00  6.65           C  
ATOM    393  CG  PRO A  57      14.138  96.900  18.385  1.00  6.75           C  
ATOM    394  CD  PRO A  57      13.726  97.636  17.128  1.00  6.99           C  
ATOM    395  N   PHE A  58      16.861  98.942  18.337  1.00  7.11           N  
ATOM    396  CA  PHE A  58      18.293  99.123  18.571  1.00  6.50           C  
ATOM    397  C   PHE A  58      18.718 100.544  18.202  1.00  7.52           C  
ATOM    398  O   PHE A  58      19.662 101.097  18.789  1.00  6.96           O  
ATOM    399  CB  PHE A  58      19.080  98.068  17.784  1.00  7.88           C  
ATOM    400  CG  PHE A  58      18.842  96.658  18.270  1.00  5.04           C  
ATOM    401  CD1 PHE A  58      19.550  96.153  19.353  1.00  8.15           C  
ATOM    402  CD2 PHE A  58      17.874  95.848  17.668  1.00  7.59           C  
ATOM    403  CE1 PHE A  58      19.301  94.862  19.837  1.00  8.70           C  
ATOM    404  CE2 PHE A  58      17.619  94.561  18.142  1.00  7.70           C  
ATOM    405  CZ  PHE A  58      18.332  94.067  19.227  1.00  6.43           C  
ATOM    406  N   VAL A  59      18.023 101.141  17.239  1.00  6.34           N  
ATOM    407  CA  VAL A  59      18.314 102.515  16.860  1.00  6.95           C  
ATOM    408  C   VAL A  59      17.694 103.441  17.913  1.00  6.00           C  
ATOM    409  O   VAL A  59      18.323 104.407  18.348  1.00  6.73           O  
ATOM    410  CB  VAL A  59      17.734 102.875  15.467  1.00  6.83           C  
ATOM    411  CG1 VAL A  59      17.936 104.370  15.192  1.00  9.11           C  
ATOM    412  CG2 VAL A  59      18.432 102.053  14.379  1.00  9.62           C  
ATOM    413  N   LYS A  60      16.471 103.136  18.344  1.00  6.16           N  
ATOM    414  CA  LYS A  60      15.805 103.971  19.346  1.00  7.77           C  
ATOM    415  C   LYS A  60      16.647 104.010  20.619  1.00  8.11           C  
ATOM    416  O   LYS A  60      16.658 105.000  21.352  1.00 10.07           O  
ATOM    417  CB  LYS A  60      14.410 103.419  19.662  1.00  8.11           C  
ATOM    418  CG  LYS A  60      13.407 103.539  18.524  1.00  9.03           C  
ATOM    419  CD  LYS A  60      13.115 105.002  18.207  1.00 13.91           C  
ATOM    420  CE  LYS A  60      12.088 105.161  17.093  1.00 16.60           C  
ATOM    421  NZ  LYS A  60      10.714 104.736  17.488  1.00 17.98           N  
ATOM    422  N   HIS A  61      17.362 102.921  20.863  1.00  8.76           N  
ATOM    423  CA  HIS A  61      18.210 102.799  22.038  1.00  7.51           C  
ATOM    424  C   HIS A  61      19.359 103.806  22.032  1.00  7.90           C  
ATOM    425  O   HIS A  61      19.757 104.303  23.088  1.00  9.21           O  
ATOM    426  CB  HIS A  61      18.769 101.368  22.107  1.00  7.97           C  
ATOM    427  CG  HIS A  61      19.634 101.103  23.301  1.00  8.58           C  
ATOM    428  ND1 HIS A  61      21.009 101.037  23.228  1.00 12.49           N  
ATOM    429  CD2 HIS A  61      19.315 100.875  24.596  1.00  9.84           C  
ATOM    430  CE1 HIS A  61      21.500 100.779  24.427  1.00  9.32           C  
ATOM    431  NE2 HIS A  61      20.492 100.675  25.275  1.00 10.82           N  
ATOM    432  N   VAL A  62      19.872 104.124  20.843  1.00  6.36           N  
ATOM    433  CA  VAL A  62      21.008 105.030  20.717  1.00  7.43           C  
ATOM    434  C   VAL A  62      20.752 106.437  20.176  1.00  8.15           C  
ATOM    435  O   VAL A  62      21.657 107.269  20.201  1.00  8.01           O  
ATOM    436  CB  VAL A  62      22.095 104.411  19.817  1.00  8.42           C  
ATOM    437  CG1 VAL A  62      22.512 103.059  20.365  1.00  9.68           C  
ATOM    438  CG2 VAL A  62      21.570 104.271  18.386  1.00 11.43           C  
ATOM    439  N   GLN A  63      19.540 106.704  19.696  1.00  7.70           N  
ATOM    440  CA  GLN A  63      19.218 108.009  19.115  1.00  9.48           C  
ATOM    441  C   GLN A  63      19.630 109.239  19.917  1.00 10.23           C  
ATOM    442  O   GLN A  63      20.210 110.176  19.362  1.00 10.91           O  
ATOM    443  CB  GLN A  63      17.721 108.101  18.816  1.00 11.78           C  
ATOM    444  CG  GLN A  63      17.257 107.202  17.695  1.00 15.49           C  
ATOM    445  CD  GLN A  63      15.817 107.467  17.319  1.00 15.97           C  
ATOM    446  OE1 GLN A  63      14.971 107.666  18.184  1.00 17.61           O  
ATOM    447  NE2 GLN A  63      15.531 107.465  16.022  1.00 19.48           N  
ATOM    448  N   HIS A  64      19.312 109.244  21.207  1.00  8.99           N  
ATOM    449  CA  HIS A  64      19.644 110.376  22.069  1.00  9.98           C  
ATOM    450  C   HIS A  64      21.153 110.587  22.166  1.00  8.63           C  
ATOM    451  O   HIS A  64      21.625 111.724  22.152  1.00  9.99           O  
ATOM    452  CB  HIS A  64      19.059 110.157  23.466  1.00 12.99           C  
ATOM    453  CG  HIS A  64      19.284 111.301  24.405  1.00 18.08           C  
ATOM    454  ND1 HIS A  64      18.601 112.495  24.302  1.00 20.11           N  
ATOM    455  CD2 HIS A  64      20.122 111.435  25.461  1.00 18.86           C  
ATOM    456  CE1 HIS A  64      19.011 113.315  25.254  1.00 20.58           C  
ATOM    457  NE2 HIS A  64      19.932 112.698  25.971  1.00 19.76           N  
ATOM    458  N   GLU A  65      21.909 109.497  22.270  1.00  7.10           N  
ATOM    459  CA  GLU A  65      23.364 109.601  22.371  1.00  6.57           C  
ATOM    460  C   GLU A  65      23.980 110.067  21.056  1.00  8.25           C  
ATOM    461  O   GLU A  65      25.005 110.741  21.054  1.00  8.03           O  
ATOM    462  CB  GLU A  65      23.976 108.258  22.776  1.00  7.57           C  
ATOM    463  CG  GLU A  65      25.510 108.233  22.833  1.00  8.94           C  
ATOM    464  CD  GLU A  65      26.097 109.274  23.774  1.00 10.52           C  
ATOM    465  OE1 GLU A  65      25.421 109.645  24.755  1.00 10.53           O  
ATOM    466  OE2 GLU A  65      27.244 109.708  23.539  1.00  9.10           O  
ATOM    467  N   LEU A  66      23.363 109.704  19.936  1.00  8.13           N  
ATOM    468  CA  LEU A  66      23.897 110.123  18.641  1.00  8.49           C  
ATOM    469  C   LEU A  66      23.975 111.644  18.590  1.00  8.87           C  
ATOM    470  O   LEU A  66      24.933 112.214  18.065  1.00  8.43           O  
ATOM    471  CB  LEU A  66      23.012 109.632  17.495  1.00  9.84           C  
ATOM    472  CG  LEU A  66      22.889 108.122  17.304  1.00 11.63           C  
ATOM    473  CD1 LEU A  66      22.165 107.869  15.994  1.00 12.97           C  
ATOM    474  CD2 LEU A  66      24.259 107.471  17.284  1.00 11.69           C  
ATOM    475  N   VAL A  67      22.958 112.294  19.141  1.00  7.56           N  
ATOM    476  CA  VAL A  67      22.908 113.748  19.157  1.00  7.67           C  
ATOM    477  C   VAL A  67      23.898 114.304  20.163  1.00  7.84           C  
ATOM    478  O   VAL A  67      24.620 115.255  19.866  1.00  9.08           O  
ATOM    479  CB  VAL A  67      21.487 114.251  19.487  1.00  8.37           C  
ATOM    480  CG1 VAL A  67      21.481 115.768  19.621  1.00 10.08           C  
ATOM    481  CG2 VAL A  67      20.533 113.819  18.388  1.00 10.68           C  
ATOM    482  N   ARG A  68      23.948 113.702  21.348  1.00  6.79           N  
ATOM    483  CA  ARG A  68      24.873 114.156  22.378  1.00  7.80           C  
ATOM    484  C   ARG A  68      26.306 114.016  21.873  1.00  7.54           C  
ATOM    485  O   ARG A  68      27.115 114.925  22.027  1.00  7.55           O  
ATOM    486  CB  ARG A  68      24.685 113.339  23.668  1.00  9.09           C  
ATOM    487  CG  ARG A  68      25.746 113.602  24.735  1.00 11.13           C  
ATOM    488  CD  ARG A  68      25.468 112.841  26.038  1.00 14.68           C  
ATOM    489  NE  ARG A  68      26.647 112.827  26.900  1.00 15.78           N  
ATOM    490  CZ  ARG A  68      27.457 111.782  27.059  1.00 15.26           C  
ATOM    491  NH1 ARG A  68      27.216 110.645  26.422  1.00 17.19           N  
ATOM    492  NH2 ARG A  68      28.531 111.884  27.836  1.00 13.72           N  
ATOM    493  N   LEU A  69      26.601 112.879  21.252  1.00  7.33           N  
ATOM    494  CA  LEU A  69      27.937 112.602  20.728  1.00  6.60           C  
ATOM    495  C   LEU A  69      28.348 113.576  19.628  1.00  6.68           C  
ATOM    496  O   LEU A  69      29.461 114.101  19.632  1.00  6.13           O  
ATOM    497  CB  LEU A  69      27.995 111.175  20.182  1.00  9.39           C  
ATOM    498  CG  LEU A  69      29.328 110.717  19.585  1.00 11.07           C  
ATOM    499  CD1 LEU A  69      30.346 110.544  20.696  1.00 11.67           C  
ATOM    500  CD2 LEU A  69      29.134 109.403  18.839  1.00 12.92           C  
ATOM    501  N   ALA A  70      27.455 113.806  18.673  1.00  6.54           N  
ATOM    502  CA  ALA A  70      27.764 114.720  17.580  1.00  7.09           C  
ATOM    503  C   ALA A  70      27.946 116.149  18.101  1.00  8.46           C  
ATOM    504  O   ALA A  70      28.829 116.878  17.643  1.00  8.43           O  
ATOM    505  CB  ALA A  70      26.667 114.670  16.532  1.00  7.68           C  
ATOM    506  N   ASN A  71      27.115 116.556  19.056  1.00  6.98           N  
ATOM    507  CA  ASN A  71      27.244 117.902  19.602  1.00  7.07           C  
ATOM    508  C   ASN A  71      28.563 118.073  20.344  1.00  6.90           C  
ATOM    509  O   ASN A  71      29.111 119.175  20.389  1.00  8.21           O  
ATOM    510  CB  ASN A  71      26.082 118.233  20.543  1.00  8.03           C  
ATOM    511  CG  ASN A  71      24.793 118.523  19.802  1.00  9.04           C  
ATOM    512  OD1 ASN A  71      24.808 118.945  18.644  1.00 10.37           O  
ATOM    513  ND2 ASN A  71      23.664 118.321  20.479  1.00  9.89           N  
ATOM    514  N   ASP A  72      29.072 116.989  20.929  1.00  6.64           N  
ATOM    515  CA  ASP A  72      30.345 117.049  21.654  1.00  8.09           C  
ATOM    516  C   ASP A  72      31.540 117.049  20.708  1.00  9.19           C  
ATOM    517  O   ASP A  72      32.541 117.713  20.973  1.00  9.53           O  
ATOM    518  CB  ASP A  72      30.536 115.845  22.594  1.00  8.39           C  
ATOM    519  CG  ASP A  72      29.746 115.954  23.888  1.00 10.26           C  
ATOM    520  OD1 ASP A  72      29.322 117.068  24.247  1.00 12.32           O  
ATOM    521  OD2 ASP A  72      29.569 114.905  24.552  1.00  9.21           O  
ATOM    522  N   TYR A  73      31.451 116.309  19.607  1.00  8.13           N  
ATOM    523  CA  TYR A  73      32.601 116.218  18.717  1.00  7.83           C  
ATOM    524  C   TYR A  73      32.619 116.987  17.409  1.00  7.47           C  
ATOM    525  O   TYR A  73      33.694 117.197  16.843  1.00  6.95           O  
ATOM    526  CB  TYR A  73      32.940 114.744  18.460  1.00  6.40           C  
ATOM    527  CG  TYR A  73      33.522 114.061  19.682  1.00  6.43           C  
ATOM    528  CD1 TYR A  73      32.699 113.611  20.714  1.00  7.87           C  
ATOM    529  CD2 TYR A  73      34.900 113.920  19.829  1.00  6.34           C  
ATOM    530  CE1 TYR A  73      33.236 113.042  21.869  1.00 10.69           C  
ATOM    531  CE2 TYR A  73      35.448 113.348  20.975  1.00  7.11           C  
ATOM    532  CZ  TYR A  73      34.610 112.915  21.992  1.00 10.08           C  
ATOM    533  OH  TYR A  73      35.144 112.359  23.131  1.00  9.92           O  
HETATM  534  N   MSE A  74      31.464 117.403  16.906  1.00  7.25           N  
HETATM  535  CA  MSE A  74      31.490 118.184  15.673  1.00  7.92           C  
HETATM  536  C   MSE A  74      32.295 119.470  15.903  1.00  8.94           C  
HETATM  537  O   MSE A  74      33.044 119.902  15.023  1.00  8.27           O  
HETATM  538  CB  MSE A  74      30.069 118.480  15.186  1.00  7.82           C  
HETATM  539  CG  MSE A  74      29.417 117.262  14.510  1.00  9.70           C  
HETATM  540 SE   MSE A  74      27.636 117.481  13.858  1.00 13.59          SE  
HETATM  541  CE  MSE A  74      27.993 118.548  12.330  1.00 11.13           C  
ATOM    542  N   PRO A  75      32.165 120.095  17.087  1.00  9.76           N  
ATOM    543  CA  PRO A  75      32.940 121.321  17.321  1.00 10.21           C  
ATOM    544  C   PRO A  75      34.453 121.068  17.327  1.00 10.58           C  
ATOM    545  O   PRO A  75      35.245 121.997  17.143  1.00 11.75           O  
ATOM    546  CB  PRO A  75      32.442 121.791  18.686  1.00 10.24           C  
ATOM    547  CG  PRO A  75      31.024 121.319  18.703  1.00  9.28           C  
ATOM    548  CD  PRO A  75      31.146 119.921  18.141  1.00  8.33           C  
ATOM    549  N   LYS A  76      34.846 119.814  17.549  1.00  8.22           N  
ATOM    550  CA  LYS A  76      36.254 119.437  17.584  1.00  9.47           C  
ATOM    551  C   LYS A  76      36.770 119.114  16.187  1.00  9.36           C  
ATOM    552  O   LYS A  76      37.927 118.738  16.019  1.00 11.73           O  
ATOM    553  CB  LYS A  76      36.463 118.222  18.501  1.00  8.54           C  
ATOM    554  CG  LYS A  76      36.147 118.489  19.963  1.00 10.10           C  
ATOM    555  CD  LYS A  76      36.353 117.231  20.799  1.00 11.12           C  
ATOM    556  CE  LYS A  76      36.107 117.494  22.275  1.00 12.55           C  
ATOM    557  NZ  LYS A  76      37.164 118.378  22.847  1.00 14.57           N  
ATOM    558  N   GLY A  77      35.896 119.248  15.194  1.00  9.51           N  
ATOM    559  CA  GLY A  77      36.289 118.987  13.822  1.00  9.46           C  
ATOM    560  C   GLY A  77      35.928 117.620  13.273  1.00 11.30           C  
ATOM    561  O   GLY A  77      36.278 117.302  12.135  1.00 11.01           O  
ATOM    562  N   VAL A  78      35.240 116.809  14.068  1.00  7.97           N  
ATOM    563  CA  VAL A  78      34.838 115.476  13.612  1.00  7.81           C  
ATOM    564  C   VAL A  78      33.567 115.570  12.773  1.00  8.88           C  
ATOM    565  O   VAL A  78      32.626 116.284  13.132  1.00  9.30           O  
ATOM    566  CB  VAL A  78      34.568 114.526  14.804  1.00  7.09           C  
ATOM    567  CG1 VAL A  78      34.161 113.149  14.291  1.00  8.22           C  
ATOM    568  CG2 VAL A  78      35.812 114.411  15.672  1.00  8.88           C  
ATOM    569  N   SER A  79      33.546 114.857  11.649  1.00  8.69           N  
ATOM    570  CA  SER A  79      32.378 114.853  10.770  1.00  9.37           C  
ATOM    571  C   SER A  79      31.462 113.673  11.072  1.00  8.28           C  
ATOM    572  O   SER A  79      31.932 112.577  11.367  1.00  8.62           O  
ATOM    573  CB  SER A  79      32.819 114.796   9.307  1.00 11.76           C  
ATOM    574  OG  SER A  79      33.455 116.003   8.937  1.00 18.11           O  
ATOM    575  N   PHE A  80      30.152 113.914  11.024  1.00  7.77           N  
ATOM    576  CA  PHE A  80      29.158 112.871  11.277  1.00  8.29           C  
ATOM    577  C   PHE A  80      28.169 112.795  10.119  1.00  8.47           C  
ATOM    578  O   PHE A  80      27.754 113.816   9.577  1.00  9.29           O  
ATOM    579  CB  PHE A  80      28.372 113.153  12.564  1.00  8.60           C  
ATOM    580  CG  PHE A  80      29.144 112.893  13.824  1.00  8.55           C  
ATOM    581  CD1 PHE A  80      28.976 111.709  14.533  1.00  8.41           C  
ATOM    582  CD2 PHE A  80      30.036 113.836  14.308  1.00  8.27           C  
ATOM    583  CE1 PHE A  80      29.687 111.474  15.706  1.00 10.08           C  
ATOM    584  CE2 PHE A  80      30.750 113.610  15.476  1.00  8.24           C  
ATOM    585  CZ  PHE A  80      30.581 112.433  16.180  1.00 10.22           C  
ATOM    586  N   VAL A  81      27.799 111.575   9.741  1.00  7.60           N  
ATOM    587  CA  VAL A  81      26.845 111.373   8.662  1.00  9.40           C  
ATOM    588  C   VAL A  81      26.005 110.146   8.957  1.00  7.74           C  
ATOM    589  O   VAL A  81      26.547 109.084   9.254  1.00  7.83           O  
ATOM    590  CB  VAL A  81      27.546 111.135   7.307  1.00 10.69           C  
ATOM    591  CG1 VAL A  81      26.501 111.027   6.197  1.00 12.61           C  
ATOM    592  CG2 VAL A  81      28.526 112.256   7.020  1.00 14.55           C  
ATOM    593  N   ALA A  82      24.688 110.302   8.879  1.00  5.77           N  
ATOM    594  CA  ALA A  82      23.763 109.195   9.097  1.00  7.09           C  
ATOM    595  C   ALA A  82      23.186 108.811   7.738  1.00  6.03           C  
ATOM    596  O   ALA A  82      22.844 109.680   6.928  1.00  7.63           O  
ATOM    597  CB  ALA A  82      22.645 109.611  10.040  1.00  5.34           C  
ATOM    598  N   ILE A  83      23.095 107.512   7.484  1.00  5.21           N  
ATOM    599  CA  ILE A  83      22.568 107.018   6.218  1.00  6.36           C  
ATOM    600  C   ILE A  83      21.481 105.979   6.464  1.00  5.83           C  
ATOM    601  O   ILE A  83      21.648 105.074   7.285  1.00  6.61           O  
ATOM    602  CB  ILE A  83      23.686 106.370   5.360  1.00  5.68           C  
ATOM    603  CG1 ILE A  83      24.782 107.404   5.073  1.00  7.72           C  
ATOM    604  CG2 ILE A  83      23.105 105.847   4.048  1.00  8.50           C  
ATOM    605  CD1 ILE A  83      25.998 106.840   4.339  1.00  9.51           C  
ATOM    606  N   ASN A  84      20.365 106.126   5.751  1.00  7.20           N  
ATOM    607  CA  ASN A  84      19.244 105.197   5.858  1.00  6.53           C  
ATOM    608  C   ASN A  84      19.136 104.486   4.508  1.00  7.18           C  
ATOM    609  O   ASN A  84      18.794 105.108   3.500  1.00  9.07           O  
ATOM    610  CB  ASN A  84      17.947 105.966   6.158  1.00  6.54           C  
ATOM    611  CG  ASN A  84      16.788 105.049   6.487  1.00  8.90           C  
ATOM    612  OD1 ASN A  84      16.602 104.015   5.849  1.00  9.07           O  
ATOM    613  ND2 ASN A  84      15.991 105.433   7.480  1.00  7.48           N  
ATOM    614  N   SER A  85      19.434 103.187   4.493  1.00  6.37           N  
ATOM    615  CA  SER A  85      19.401 102.396   3.264  1.00  6.78           C  
ATOM    616  C   SER A  85      18.192 101.475   3.157  1.00  7.62           C  
ATOM    617  O   SER A  85      18.048 100.751   2.173  1.00  9.84           O  
ATOM    618  CB  SER A  85      20.670 101.544   3.160  1.00  6.10           C  
ATOM    619  OG  SER A  85      21.841 102.339   3.223  1.00  7.11           O  
ATOM    620  N   ASN A  86      17.326 101.490   4.161  1.00  6.53           N  
ATOM    621  CA  ASN A  86      16.158 100.616   4.136  1.00  7.92           C  
ATOM    622  C   ASN A  86      15.188 100.885   2.991  1.00  6.83           C  
ATOM    623  O   ASN A  86      14.924 102.036   2.630  1.00  7.86           O  
ATOM    624  CB  ASN A  86      15.403 100.702   5.464  1.00  7.07           C  
ATOM    625  CG  ASN A  86      16.124  99.995   6.593  1.00  6.88           C  
ATOM    626  OD1 ASN A  86      17.203  99.425   6.407  1.00  6.49           O  
ATOM    627  ND2 ASN A  86      15.526 100.024   7.773  1.00  6.35           N  
ATOM    628  N   ASP A  87      14.663  99.805   2.420  1.00  7.31           N  
ATOM    629  CA  ASP A  87      13.698  99.901   1.328  1.00  7.89           C  
ATOM    630  C   ASP A  87      12.415 100.528   1.874  1.00  8.26           C  
ATOM    631  O   ASP A  87      11.676  99.890   2.622  1.00  8.91           O  
ATOM    632  CB  ASP A  87      13.396  98.507   0.769  1.00  8.24           C  
ATOM    633  CG  ASP A  87      12.483  98.547  -0.446  1.00 11.28           C  
ATOM    634  OD1 ASP A  87      11.969  99.637  -0.771  1.00  9.97           O  
ATOM    635  OD2 ASP A  87      12.287  97.483  -1.072  1.00 11.29           O  
ATOM    636  N   ALA A  88      12.158 101.773   1.482  1.00  8.55           N  
ATOM    637  CA  ALA A  88      10.987 102.509   1.941  1.00  8.74           C  
ATOM    638  C   ALA A  88       9.664 101.949   1.433  1.00  8.15           C  
ATOM    639  O   ALA A  88       8.605 102.335   1.916  1.00  9.47           O  
ATOM    640  CB  ALA A  88      11.116 103.986   1.559  1.00  8.32           C  
ATOM    641  N   GLU A  89       9.718 101.052   0.454  1.00  9.74           N  
ATOM    642  CA  GLU A  89       8.485 100.456  -0.043  1.00  9.56           C  
ATOM    643  C   GLU A  89       8.052  99.360   0.921  1.00 11.15           C  
ATOM    644  O   GLU A  89       6.862  99.101   1.089  1.00 11.00           O  
ATOM    645  CB  GLU A  89       8.674  99.884  -1.449  1.00 10.87           C  
ATOM    646  CG  GLU A  89       8.930 100.957  -2.495  1.00 13.39           C  
ATOM    647  CD  GLU A  89       7.939 102.105  -2.388  1.00 15.27           C  
ATOM    648  OE1 GLU A  89       6.739 101.887  -2.650  1.00 16.73           O  
ATOM    649  OE2 GLU A  89       8.362 103.224  -2.029  1.00 20.10           O  
ATOM    650  N   GLN A  90       9.023  98.719   1.567  1.00 10.06           N  
ATOM    651  CA  GLN A  90       8.716  97.663   2.525  1.00 10.58           C  
ATOM    652  C   GLN A  90       8.512  98.288   3.901  1.00 11.07           C  
ATOM    653  O   GLN A  90       7.692  97.826   4.698  1.00 11.44           O  
ATOM    654  CB  GLN A  90       9.863  96.651   2.588  1.00  9.81           C  
ATOM    655  CG  GLN A  90      10.181  95.986   1.262  1.00  9.77           C  
ATOM    656  CD  GLN A  90      11.358  95.037   1.352  1.00 10.97           C  
ATOM    657  OE1 GLN A  90      12.324  95.154   0.595  1.00 12.90           O  
ATOM    658  NE2 GLN A  90      11.288  94.093   2.280  1.00 11.73           N  
ATOM    659  N   TYR A  91       9.261  99.353   4.168  1.00 11.33           N  
ATOM    660  CA  TYR A  91       9.189 100.047   5.445  1.00 12.38           C  
ATOM    661  C   TYR A  91       8.964 101.538   5.220  1.00 11.87           C  
ATOM    662  O   TYR A  91       9.910 102.321   5.184  1.00 12.37           O  
ATOM    663  CB  TYR A  91      10.486  99.795   6.217  1.00 13.94           C  
ATOM    664  CG  TYR A  91      10.646  98.341   6.598  1.00 18.34           C  
ATOM    665  CD1 TYR A  91      10.254  97.884   7.854  1.00 21.12           C  
ATOM    666  CD2 TYR A  91      11.134  97.408   5.680  1.00 21.22           C  
ATOM    667  CE1 TYR A  91      10.342  96.538   8.189  1.00 21.95           C  
ATOM    668  CE2 TYR A  91      11.223  96.057   6.006  1.00 23.03           C  
ATOM    669  CZ  TYR A  91      10.824  95.630   7.263  1.00 24.05           C  
ATOM    670  OH  TYR A  91      10.903  94.295   7.597  1.00 27.35           O  
ATOM    671  N   PRO A  92       7.692 101.942   5.059  1.00 12.40           N  
ATOM    672  CA  PRO A  92       7.287 103.333   4.826  1.00 12.19           C  
ATOM    673  C   PRO A  92       7.874 104.333   5.816  1.00 11.87           C  
ATOM    674  O   PRO A  92       8.082 105.498   5.479  1.00 11.96           O  
ATOM    675  CB  PRO A  92       5.762 103.267   4.905  1.00 12.23           C  
ATOM    676  CG  PRO A  92       5.466 101.888   4.406  1.00 14.99           C  
ATOM    677  CD  PRO A  92       6.514 101.057   5.109  1.00 13.38           C  
ATOM    678  N   GLU A  93       8.139 103.881   7.039  1.00 12.02           N  
ATOM    679  CA  GLU A  93       8.704 104.775   8.045  1.00 14.26           C  
ATOM    680  C   GLU A  93      10.099 105.262   7.660  1.00 13.81           C  
ATOM    681  O   GLU A  93      10.610 106.216   8.246  1.00 14.52           O  
ATOM    682  CB  GLU A  93       8.773 104.082   9.411  1.00 16.49           C  
ATOM    683  CG  GLU A  93       9.753 102.929   9.471  1.00 19.81           C  
ATOM    684  CD  GLU A  93       9.113 101.596   9.160  1.00 20.81           C  
ATOM    685  OE1 GLU A  93       8.192 101.555   8.313  1.00 21.99           O  
ATOM    686  OE2 GLU A  93       9.543 100.587   9.760  1.00 22.22           O  
ATOM    687  N   ASP A  94      10.714 104.616   6.675  1.00 12.54           N  
ATOM    688  CA  ASP A  94      12.048 105.008   6.242  1.00 11.56           C  
ATOM    689  C   ASP A  94      12.077 105.821   4.950  1.00 11.18           C  
ATOM    690  O   ASP A  94      13.137 106.031   4.354  1.00 11.21           O  
ATOM    691  CB  ASP A  94      12.936 103.766   6.133  1.00 12.29           C  
ATOM    692  CG  ASP A  94      13.226 103.157   7.489  1.00 11.04           C  
ATOM    693  OD1 ASP A  94      13.595 103.941   8.389  1.00 11.26           O  
ATOM    694  OD2 ASP A  94      13.088 101.925   7.668  1.00 10.61           O  
ATOM    695  N   SER A  95      10.910 106.293   4.525  1.00 11.43           N  
ATOM    696  CA  SER A  95      10.820 107.110   3.321  1.00 11.10           C  
ATOM    697  C   SER A  95      11.562 108.413   3.598  1.00 10.48           C  
ATOM    698  O   SER A  95      11.728 108.802   4.751  1.00 12.03           O  
ATOM    699  CB  SER A  95       9.360 107.436   3.007  1.00 11.52           C  
ATOM    700  OG  SER A  95       8.834 108.319   3.989  1.00 14.12           O  
ATOM    701  N   PRO A  96      12.018 109.105   2.544  1.00 10.84           N  
ATOM    702  CA  PRO A  96      12.731 110.364   2.771  1.00 10.25           C  
ATOM    703  C   PRO A  96      11.886 111.396   3.521  1.00 12.23           C  
ATOM    704  O   PRO A  96      12.402 112.122   4.371  1.00 13.54           O  
ATOM    705  CB  PRO A  96      13.089 110.815   1.354  1.00 10.91           C  
ATOM    706  CG  PRO A  96      13.332 109.502   0.658  1.00 12.00           C  
ATOM    707  CD  PRO A  96      12.163 108.664   1.145  1.00 10.64           C  
ATOM    708  N   GLU A  97      10.592 111.456   3.215  1.00 13.59           N  
ATOM    709  CA  GLU A  97       9.709 112.409   3.883  1.00 13.98           C  
ATOM    710  C   GLU A  97       9.649 112.133   5.389  1.00 12.73           C  
ATOM    711  O   GLU A  97       9.697 113.058   6.201  1.00 11.98           O  
ATOM    712  CB  GLU A  97       8.305 112.352   3.269  1.00 18.94           C  
ATOM    713  CG  GLU A  97       7.338 113.393   3.821  1.00 26.69           C  
ATOM    714  CD  GLU A  97       6.040 113.474   3.030  1.00 31.46           C  
ATOM    715  OE1 GLU A  97       6.096 113.792   1.822  1.00 34.55           O  
ATOM    716  OE2 GLU A  97       4.964 113.226   3.616  1.00 32.76           O  
ATOM    717  N   ASN A  98       9.547 110.863   5.763  1.00 12.76           N  
ATOM    718  CA  ASN A  98       9.501 110.493   7.171  1.00 11.68           C  
ATOM    719  C   ASN A  98      10.863 110.708   7.824  1.00 13.19           C  
ATOM    720  O   ASN A  98      10.954 111.077   8.992  1.00 12.09           O  
ATOM    721  CB  ASN A  98       9.067 109.035   7.317  1.00 15.06           C  
ATOM    722  CG  ASN A  98       7.565 108.861   7.187  1.00 18.06           C  
ATOM    723  OD1 ASN A  98       7.078 107.774   6.868  1.00 20.46           O  
ATOM    724  ND2 ASN A  98       6.819 109.933   7.450  1.00 19.98           N  
HETATM  725  N   MSE A  99      11.927 110.472   7.064  1.00 11.04           N  
HETATM  726  CA  MSE A  99      13.272 110.669   7.584  1.00 11.09           C  
HETATM  727  C   MSE A  99      13.428 112.133   7.964  1.00 11.49           C  
HETATM  728  O   MSE A  99      14.015 112.460   8.996  1.00 11.08           O  
HETATM  729  CB  MSE A  99      14.311 110.307   6.522  1.00 10.36           C  
HETATM  730  CG  MSE A  99      14.447 108.818   6.247  1.00  7.88           C  
HETATM  731 SE   MSE A  99      15.569 108.453   4.741  1.00  9.72          SE  
HETATM  732  CE  MSE A  99      17.146 109.292   5.387  1.00  5.37           C  
ATOM    733  N   LYS A 100      12.905 113.015   7.117  1.00 11.88           N  
ATOM    734  CA  LYS A 100      12.999 114.444   7.368  1.00 11.06           C  
ATOM    735  C   LYS A 100      12.304 114.797   8.682  1.00 11.63           C  
ATOM    736  O   LYS A 100      12.854 115.522   9.513  1.00 10.94           O  
ATOM    737  CB  LYS A 100      12.369 115.227   6.210  1.00 12.05           C  
ATOM    738  CG  LYS A 100      12.489 116.735   6.346  1.00 13.62           C  
ATOM    739  CD  LYS A 100      11.896 117.459   5.148  1.00 16.71           C  
ATOM    740  CE  LYS A 100      12.053 118.967   5.301  1.00 19.50           C  
ATOM    741  NZ  LYS A 100      11.425 119.716   4.179  1.00 24.29           N  
ATOM    742  N   LYS A 101      11.096 114.274   8.872  1.00 12.68           N  
ATOM    743  CA  LYS A 101      10.343 114.552  10.087  1.00 12.81           C  
ATOM    744  C   LYS A 101      11.093 114.073  11.322  1.00 12.16           C  
ATOM    745  O   LYS A 101      11.154 114.774  12.326  1.00 11.27           O  
ATOM    746  CB  LYS A 101       8.962 113.892  10.024  1.00 16.11           C  
ATOM    747  CG  LYS A 101       8.086 114.417   8.895  1.00 20.41           C  
ATOM    748  CD  LYS A 101       6.724 113.737   8.863  1.00 23.21           C  
ATOM    749  CE  LYS A 101       5.855 114.304   7.748  1.00 25.54           C  
ATOM    750  NZ  LYS A 101       4.495 113.684   7.713  1.00 28.21           N  
ATOM    751  N   VAL A 102      11.672 112.880  11.242  1.00 10.49           N  
ATOM    752  CA  VAL A 102      12.409 112.332  12.369  1.00 11.02           C  
ATOM    753  C   VAL A 102      13.629 113.181  12.704  1.00 10.83           C  
ATOM    754  O   VAL A 102      13.898 113.459  13.872  1.00 11.62           O  
ATOM    755  CB  VAL A 102      12.858 110.879  12.088  1.00 12.22           C  
ATOM    756  CG1 VAL A 102      13.842 110.416  13.147  1.00 11.73           C  
ATOM    757  CG2 VAL A 102      11.643 109.962  12.070  1.00 12.29           C  
ATOM    758  N   ALA A 103      14.364 113.601  11.680  1.00  9.52           N  
ATOM    759  CA  ALA A 103      15.552 114.418  11.903  1.00  9.67           C  
ATOM    760  C   ALA A 103      15.178 115.718  12.616  1.00 11.79           C  
ATOM    761  O   ALA A 103      15.911 116.196  13.478  1.00 11.02           O  
ATOM    762  CB  ALA A 103      16.239 114.723  10.574  1.00  9.51           C  
ATOM    763  N   GLU A 104      14.032 116.282  12.250  1.00 13.23           N  
ATOM    764  CA  GLU A 104      13.563 117.522  12.856  1.00 15.74           C  
ATOM    765  C   GLU A 104      13.126 117.291  14.303  1.00 15.80           C  
ATOM    766  O   GLU A 104      13.429 118.090  15.188  1.00 17.16           O  
ATOM    767  CB  GLU A 104      12.387 118.088  12.059  1.00 18.87           C  
ATOM    768  CG  GLU A 104      11.839 119.406  12.592  1.00 25.01           C  
ATOM    769  CD  GLU A 104      10.566 119.829  11.888  1.00 29.82           C  
ATOM    770  OE1 GLU A 104       9.584 119.055  11.929  1.00 32.91           O  
ATOM    771  OE2 GLU A 104      10.543 120.930  11.293  1.00 31.72           O  
ATOM    772  N   GLU A 105      12.415 116.194  14.537  1.00 15.39           N  
ATOM    773  CA  GLU A 105      11.933 115.876  15.879  1.00 17.31           C  
ATOM    774  C   GLU A 105      13.067 115.593  16.859  1.00 16.21           C  
ATOM    775  O   GLU A 105      13.017 116.012  18.018  1.00 17.04           O  
ATOM    776  CB  GLU A 105      10.989 114.670  15.828  1.00 19.54           C  
ATOM    777  CG  GLU A 105       9.815 114.846  14.875  1.00 26.34           C  
ATOM    778  CD  GLU A 105       8.827 113.694  14.934  1.00 28.98           C  
ATOM    779  OE1 GLU A 105       9.256 112.526  14.802  1.00 31.67           O  
ATOM    780  OE2 GLU A 105       7.618 113.959  15.108  1.00 32.70           O  
ATOM    781  N   LEU A 106      14.093 114.886  16.398  1.00 14.54           N  
ATOM    782  CA  LEU A 106      15.217 114.550  17.263  1.00 14.98           C  
ATOM    783  C   LEU A 106      16.324 115.588  17.194  1.00 15.31           C  
ATOM    784  O   LEU A 106      17.273 115.550  17.979  1.00 16.53           O  
ATOM    785  CB  LEU A 106      15.767 113.167  16.896  1.00 16.17           C  
ATOM    786  CG  LEU A 106      14.727 112.040  16.940  1.00 17.69           C  
ATOM    787  CD1 LEU A 106      15.392 110.703  16.641  1.00 18.80           C  
ATOM    788  CD2 LEU A 106      14.065 112.005  18.307  1.00 20.81           C  
ATOM    789  N   GLY A 107      16.197 116.519  16.255  1.00 12.82           N  
ATOM    790  CA  GLY A 107      17.200 117.556  16.109  1.00 13.62           C  
ATOM    791  C   GLY A 107      18.559 117.032  15.684  1.00 13.89           C  
ATOM    792  O   GLY A 107      19.586 117.442  16.232  1.00 12.25           O  
ATOM    793  N   TYR A 108      18.576 116.117  14.718  1.00 12.92           N  
ATOM    794  CA  TYR A 108      19.842 115.576  14.233  1.00 12.08           C  
ATOM    795  C   TYR A 108      20.690 116.729  13.703  1.00 10.96           C  
ATOM    796  O   TYR A 108      20.267 117.464  12.813  1.00 11.54           O  
ATOM    797  CB  TYR A 108      19.613 114.561  13.103  1.00 11.45           C  
ATOM    798  CG  TYR A 108      19.119 113.191  13.524  1.00 12.90           C  
ATOM    799  CD1 TYR A 108      19.243 112.744  14.839  1.00 13.31           C  
ATOM    800  CD2 TYR A 108      18.582 112.313  12.582  1.00 13.01           C  
ATOM    801  CE1 TYR A 108      18.849 111.457  15.202  1.00 15.82           C  
ATOM    802  CE2 TYR A 108      18.187 111.029  12.931  1.00 11.72           C  
ATOM    803  CZ  TYR A 108      18.323 110.602  14.241  1.00 14.63           C  
ATOM    804  OH  TYR A 108      17.954 109.320  14.582  1.00 15.61           O  
ATOM    805  N   PRO A 109      21.902 116.903  14.247  1.00 10.79           N  
ATOM    806  CA  PRO A 109      22.804 117.980  13.822  1.00 11.27           C  
ATOM    807  C   PRO A 109      23.693 117.601  12.639  1.00 11.57           C  
ATOM    808  O   PRO A 109      24.510 118.403  12.178  1.00 13.94           O  
ATOM    809  CB  PRO A 109      23.607 118.253  15.085  1.00 10.91           C  
ATOM    810  CG  PRO A 109      23.791 116.867  15.622  1.00 10.08           C  
ATOM    811  CD  PRO A 109      22.415 116.231  15.453  1.00  9.23           C  
ATOM    812  N   PHE A 110      23.528 116.375  12.154  1.00 10.77           N  
ATOM    813  CA  PHE A 110      24.308 115.875  11.029  1.00  9.53           C  
ATOM    814  C   PHE A 110      23.382 115.548   9.863  1.00  9.17           C  
ATOM    815  O   PHE A 110      22.175 115.435  10.033  1.00  8.56           O  
ATOM    816  CB  PHE A 110      25.086 114.622  11.457  1.00  9.30           C  
ATOM    817  CG  PHE A 110      24.302 113.701  12.349  1.00  8.75           C  
ATOM    818  CD1 PHE A 110      23.197 113.011  11.861  1.00  7.63           C  
ATOM    819  CD2 PHE A 110      24.636 113.567  13.691  1.00  8.71           C  
ATOM    820  CE1 PHE A 110      22.431 112.204  12.695  1.00 11.69           C  
ATOM    821  CE2 PHE A 110      23.880 112.766  14.541  1.00 10.25           C  
ATOM    822  CZ  PHE A 110      22.770 112.080  14.038  1.00 11.55           C  
ATOM    823  N   PRO A 111      23.940 115.417   8.654  1.00  8.98           N  
ATOM    824  CA  PRO A 111      23.099 115.097   7.496  1.00  8.04           C  
ATOM    825  C   PRO A 111      22.486 113.703   7.634  1.00  7.90           C  
ATOM    826  O   PRO A 111      23.091 112.805   8.220  1.00  6.46           O  
ATOM    827  CB  PRO A 111      24.078 115.163   6.322  1.00  7.88           C  
ATOM    828  CG  PRO A 111      25.151 116.095   6.802  1.00 13.00           C  
ATOM    829  CD  PRO A 111      25.326 115.696   8.243  1.00  9.27           C  
ATOM    830  N   TYR A 112      21.284 113.530   7.097  1.00  6.01           N  
ATOM    831  CA  TYR A 112      20.604 112.238   7.140  1.00  7.30           C  
ATOM    832  C   TYR A 112      20.326 111.929   5.677  1.00  6.84           C  
ATOM    833  O   TYR A 112      19.391 112.457   5.089  1.00  7.03           O  
ATOM    834  CB  TYR A 112      19.304 112.360   7.946  1.00  8.79           C  
ATOM    835  CG  TYR A 112      18.631 111.050   8.329  1.00  8.94           C  
ATOM    836  CD1 TYR A 112      19.303 109.823   8.233  1.00  8.30           C  
ATOM    837  CD2 TYR A 112      17.333 111.044   8.836  1.00  8.74           C  
ATOM    838  CE1 TYR A 112      18.689 108.627   8.637  1.00  9.21           C  
ATOM    839  CE2 TYR A 112      16.713 109.861   9.243  1.00  8.97           C  
ATOM    840  CZ  TYR A 112      17.392 108.658   9.141  1.00  8.98           C  
ATOM    841  OH  TYR A 112      16.764 107.498   9.548  1.00  9.41           O  
ATOM    842  N   LEU A 113      21.159 111.072   5.096  1.00  7.69           N  
ATOM    843  CA  LEU A 113      21.042 110.734   3.679  1.00  7.01           C  
ATOM    844  C   LEU A 113      20.287 109.442   3.406  1.00  6.30           C  
ATOM    845  O   LEU A 113      20.357 108.498   4.192  1.00  6.82           O  
ATOM    846  CB  LEU A 113      22.441 110.609   3.068  1.00  5.74           C  
ATOM    847  CG  LEU A 113      23.531 111.551   3.583  1.00  8.20           C  
ATOM    848  CD1 LEU A 113      24.833 111.205   2.893  1.00  8.36           C  
ATOM    849  CD2 LEU A 113      23.159 113.009   3.326  1.00  5.70           C  
ATOM    850  N   TYR A 114      19.554 109.404   2.294  1.00  8.20           N  
ATOM    851  CA  TYR A 114      18.852 108.184   1.923  1.00  8.27           C  
ATOM    852  C   TYR A 114      19.570 107.520   0.757  1.00  8.60           C  
ATOM    853  O   TYR A 114      19.890 108.155  -0.255  1.00  9.02           O  
ATOM    854  CB  TYR A 114      17.368 108.434   1.592  1.00  9.82           C  
ATOM    855  CG  TYR A 114      17.060 109.237   0.350  1.00 13.29           C  
ATOM    856  CD1 TYR A 114      16.982 110.631   0.397  1.00 13.22           C  
ATOM    857  CD2 TYR A 114      16.776 108.600  -0.860  1.00 14.17           C  
ATOM    858  CE1 TYR A 114      16.621 111.371  -0.732  1.00 14.14           C  
ATOM    859  CE2 TYR A 114      16.416 109.330  -1.996  1.00 13.87           C  
ATOM    860  CZ  TYR A 114      16.339 110.713  -1.924  1.00 13.72           C  
ATOM    861  OH  TYR A 114      15.976 111.438  -3.041  1.00 15.60           O  
ATOM    862  N   ASP A 115      19.844 106.232   0.939  1.00  8.00           N  
ATOM    863  CA  ASP A 115      20.546 105.393  -0.028  1.00  6.97           C  
ATOM    864  C   ASP A 115      19.489 104.474  -0.633  1.00  9.14           C  
ATOM    865  O   ASP A 115      19.359 103.319  -0.242  1.00  8.70           O  
ATOM    866  CB  ASP A 115      21.628 104.617   0.742  1.00  6.53           C  
ATOM    867  CG  ASP A 115      22.286 103.512  -0.062  1.00  6.11           C  
ATOM    868  OD1 ASP A 115      22.440 103.631  -1.297  1.00  8.33           O  
ATOM    869  OD2 ASP A 115      22.686 102.518   0.578  1.00  7.21           O  
ATOM    870  N   GLU A 116      18.731 105.002  -1.591  1.00  8.15           N  
ATOM    871  CA  GLU A 116      17.651 104.246  -2.217  1.00  8.65           C  
ATOM    872  C   GLU A 116      18.100 102.985  -2.949  1.00  9.55           C  
ATOM    873  O   GLU A 116      17.455 101.940  -2.834  1.00  9.04           O  
ATOM    874  CB  GLU A 116      16.867 105.154  -3.175  1.00  9.69           C  
ATOM    875  CG  GLU A 116      15.521 104.603  -3.640  1.00 13.35           C  
ATOM    876  CD  GLU A 116      15.645 103.374  -4.522  1.00 17.35           C  
ATOM    877  OE1 GLU A 116      16.422 103.414  -5.499  1.00 17.57           O  
ATOM    878  OE2 GLU A 116      14.958 102.367  -4.246  1.00 21.21           O  
ATOM    879  N   THR A 117      19.201 103.061  -3.692  1.00  9.60           N  
ATOM    880  CA  THR A 117      19.660 101.886  -4.429  1.00  8.90           C  
ATOM    881  C   THR A 117      20.296 100.831  -3.536  1.00  8.82           C  
ATOM    882  O   THR A 117      20.406  99.671  -3.928  1.00  9.71           O  
ATOM    883  CB  THR A 117      20.679 102.251  -5.532  1.00  7.76           C  
ATOM    884  OG1 THR A 117      21.940 102.593  -4.938  1.00  8.68           O  
ATOM    885  CG2 THR A 117      20.161 103.419  -6.362  1.00  9.64           C  
ATOM    886  N   GLN A 118      20.714 101.247  -2.342  1.00  9.02           N  
ATOM    887  CA  GLN A 118      21.355 100.370  -1.365  1.00  8.47           C  
ATOM    888  C   GLN A 118      22.771 100.004  -1.780  1.00  9.09           C  
ATOM    889  O   GLN A 118      23.420  99.174  -1.150  1.00  9.03           O  
ATOM    890  CB  GLN A 118      20.520  99.104  -1.135  1.00  8.23           C  
ATOM    891  CG  GLN A 118      19.072  99.417  -0.799  1.00  6.03           C  
ATOM    892  CD  GLN A 118      18.291  98.202  -0.345  1.00  7.36           C  
ATOM    893  OE1 GLN A 118      18.434  97.111  -0.900  1.00  7.90           O  
ATOM    894  NE2 GLN A 118      17.439  98.391   0.663  1.00  8.59           N  
ATOM    895  N   GLU A 119      23.251 100.645  -2.838  1.00  9.69           N  
ATOM    896  CA  GLU A 119      24.599 100.402  -3.330  1.00 10.20           C  
ATOM    897  C   GLU A 119      25.642 100.894  -2.323  1.00  9.20           C  
ATOM    898  O   GLU A 119      26.734 100.331  -2.221  1.00  8.97           O  
ATOM    899  CB  GLU A 119      24.799 101.110  -4.674  1.00 15.34           C  
ATOM    900  CG  GLU A 119      26.220 101.049  -5.216  1.00 21.34           C  
ATOM    901  CD  GLU A 119      26.339 101.642  -6.609  1.00 25.38           C  
ATOM    902  OE1 GLU A 119      25.913 102.799  -6.800  1.00 27.06           O  
ATOM    903  OE2 GLU A 119      26.862 100.952  -7.511  1.00 30.18           O  
ATOM    904  N   VAL A 120      25.315 101.941  -1.575  1.00  7.09           N  
ATOM    905  CA  VAL A 120      26.273 102.444  -0.597  1.00  6.04           C  
ATOM    906  C   VAL A 120      26.352 101.492   0.598  1.00  6.40           C  
ATOM    907  O   VAL A 120      27.435 101.215   1.108  1.00  6.12           O  
ATOM    908  CB  VAL A 120      25.901 103.867  -0.126  1.00  5.45           C  
ATOM    909  CG1 VAL A 120      26.921 104.360   0.890  1.00  7.43           C  
ATOM    910  CG2 VAL A 120      25.871 104.812  -1.330  1.00  7.75           C  
ATOM    911  N   ALA A 121      25.208 100.979   1.041  1.00  5.74           N  
ATOM    912  CA  ALA A 121      25.199 100.050   2.167  1.00  6.03           C  
ATOM    913  C   ALA A 121      25.979  98.792   1.787  1.00  7.71           C  
ATOM    914  O   ALA A 121      26.734  98.250   2.595  1.00  7.25           O  
ATOM    915  CB  ALA A 121      23.761  99.681   2.548  1.00  5.95           C  
ATOM    916  N   LYS A 122      25.792  98.321   0.559  1.00  7.08           N  
ATOM    917  CA  LYS A 122      26.513  97.132   0.116  1.00  9.02           C  
ATOM    918  C   LYS A 122      28.014  97.393   0.063  1.00  8.99           C  
ATOM    919  O   LYS A 122      28.808  96.531   0.438  1.00 10.30           O  
ATOM    920  CB  LYS A 122      26.004  96.676  -1.254  1.00  9.11           C  
ATOM    921  CG  LYS A 122      24.571  96.176  -1.210  1.00 11.48           C  
ATOM    922  CD  LYS A 122      24.028  95.883  -2.596  1.00 16.76           C  
ATOM    923  CE  LYS A 122      22.601  95.358  -2.517  1.00 19.19           C  
ATOM    924  NZ  LYS A 122      22.000  95.185  -3.871  1.00 19.83           N  
ATOM    925  N   ALA A 123      28.400  98.583  -0.388  1.00  9.34           N  
ATOM    926  CA  ALA A 123      29.817  98.938  -0.485  1.00  8.78           C  
ATOM    927  C   ALA A 123      30.496  99.024   0.883  1.00  9.47           C  
ATOM    928  O   ALA A 123      31.668  98.678   1.026  1.00  8.45           O  
ATOM    929  CB  ALA A 123      29.975 100.260  -1.233  1.00  9.45           C  
ATOM    930  N   TYR A 124      29.764  99.496   1.885  1.00  9.86           N  
ATOM    931  CA  TYR A 124      30.315  99.603   3.236  1.00  8.95           C  
ATOM    932  C   TYR A 124      30.068  98.295   3.970  1.00  7.91           C  
ATOM    933  O   TYR A 124      30.496  98.122   5.112  1.00  9.64           O  
ATOM    934  CB  TYR A 124      29.641 100.744   4.010  1.00  8.37           C  
ATOM    935  CG  TYR A 124      30.182 102.121   3.706  1.00  7.25           C  
ATOM    936  CD1 TYR A 124      30.007 102.704   2.453  1.00  8.06           C  
ATOM    937  CD2 TYR A 124      30.898 102.833   4.668  1.00  8.93           C  
ATOM    938  CE1 TYR A 124      30.531 103.957   2.165  1.00  7.31           C  
ATOM    939  CE2 TYR A 124      31.432 104.084   4.387  1.00  7.71           C  
ATOM    940  CZ  TYR A 124      31.248 104.638   3.132  1.00  7.37           C  
ATOM    941  OH  TYR A 124      31.819 105.851   2.824  1.00  7.21           O  
ATOM    942  N   ASP A 125      29.378  97.382   3.291  1.00  7.56           N  
ATOM    943  CA  ASP A 125      29.012  96.086   3.839  1.00  8.37           C  
ATOM    944  C   ASP A 125      28.273  96.279   5.155  1.00  7.05           C  
ATOM    945  O   ASP A 125      28.460  95.522   6.110  1.00  6.90           O  
ATOM    946  CB  ASP A 125      30.242  95.183   4.031  1.00  9.16           C  
ATOM    947  CG  ASP A 125      29.878  93.703   4.083  1.00 12.76           C  
ATOM    948  OD1 ASP A 125      28.755  93.342   3.652  1.00 12.16           O  
ATOM    949  OD2 ASP A 125      30.715  92.891   4.541  1.00 13.46           O  
ATOM    950  N   ALA A 126      27.441  97.315   5.199  1.00  6.58           N  
ATOM    951  CA  ALA A 126      26.635  97.596   6.383  1.00  7.43           C  
ATOM    952  C   ALA A 126      25.689  96.403   6.522  1.00  8.64           C  
ATOM    953  O   ALA A 126      25.210  95.871   5.526  1.00 10.50           O  
ATOM    954  CB  ALA A 126      25.844  98.882   6.187  1.00  6.85           C  
ATOM    955  N   ALA A 127      25.407  95.980   7.749  1.00  8.36           N  
ATOM    956  CA  ALA A 127      24.556  94.813   7.929  1.00  8.95           C  
ATOM    957  C   ALA A 127      23.322  95.062   8.771  1.00  8.53           C  
ATOM    958  O   ALA A 127      22.263  94.482   8.524  1.00  8.99           O  
ATOM    959  CB  ALA A 127      25.373  93.680   8.553  1.00 10.02           C  
ATOM    960  N   CYS A 128      23.464  95.930   9.761  1.00  8.88           N  
ATOM    961  CA  CYS A 128      22.372  96.221  10.673  1.00  8.21           C  
ATOM    962  C   CYS A 128      22.200  97.705  10.955  1.00  9.10           C  
ATOM    963  O   CYS A 128      22.972  98.543  10.498  1.00  8.66           O  
ATOM    964  CB  CYS A 128      22.621  95.495  11.999  1.00  7.72           C  
ATOM    965  SG  CYS A 128      24.214  95.917  12.805  1.00 11.15           S  
ATOM    966  N   THR A 129      21.159  98.014  11.717  1.00  7.79           N  
ATOM    967  CA  THR A 129      20.885  99.382  12.130  1.00  7.97           C  
ATOM    968  C   THR A 129      20.776  99.329  13.645  1.00  7.54           C  
ATOM    969  O   THR A 129      19.938  98.620  14.184  1.00  9.22           O  
ATOM    970  CB  THR A 129      19.564  99.916  11.532  1.00  9.27           C  
ATOM    971  OG1 THR A 129      18.482  99.037  11.862  1.00  9.10           O  
ATOM    972  CG2 THR A 129      19.686 100.032  10.021  1.00  9.09           C  
ATOM    973  N   PRO A 130      21.639 100.067  14.357  1.00  7.60           N  
ATOM    974  CA  PRO A 130      22.697 100.941  13.843  1.00  7.79           C  
ATOM    975  C   PRO A 130      24.008 100.207  13.568  1.00  6.42           C  
ATOM    976  O   PRO A 130      24.317  99.214  14.222  1.00  8.64           O  
ATOM    977  CB  PRO A 130      22.846 101.965  14.956  1.00  7.08           C  
ATOM    978  CG  PRO A 130      22.680 101.107  16.192  1.00  6.66           C  
ATOM    979  CD  PRO A 130      21.538 100.157  15.826  1.00  8.28           C  
ATOM    980  N   ASP A 131      24.775 100.699  12.595  1.00  5.56           N  
ATOM    981  CA  ASP A 131      26.073 100.116  12.263  1.00  6.46           C  
ATOM    982  C   ASP A 131      27.013 101.333  12.193  1.00  6.62           C  
ATOM    983  O   ASP A 131      26.761 102.281  11.442  1.00  7.22           O  
ATOM    984  CB  ASP A 131      26.010  99.369  10.913  1.00  7.26           C  
ATOM    985  CG  ASP A 131      26.795  98.057  10.930  1.00  8.17           C  
ATOM    986  OD1 ASP A 131      27.615  97.868  11.850  1.00  9.42           O  
ATOM    987  OD2 ASP A 131      26.602  97.212  10.026  1.00  9.21           O  
ATOM    988  N   PHE A 132      28.082 101.311  12.990  1.00  6.65           N  
ATOM    989  CA  PHE A 132      29.017 102.436  13.066  1.00  6.89           C  
ATOM    990  C   PHE A 132      30.382 102.254  12.412  1.00  6.74           C  
ATOM    991  O   PHE A 132      30.994 101.190  12.497  1.00  7.66           O  
ATOM    992  CB  PHE A 132      29.236 102.813  14.532  1.00  7.11           C  
ATOM    993  CG  PHE A 132      27.978 103.213  15.251  1.00  9.76           C  
ATOM    994  CD1 PHE A 132      27.499 104.513  15.167  1.00  9.76           C  
ATOM    995  CD2 PHE A 132      27.270 102.284  16.008  1.00  7.86           C  
ATOM    996  CE1 PHE A 132      26.333 104.886  15.829  1.00 11.17           C  
ATOM    997  CE2 PHE A 132      26.099 102.647  16.674  1.00  9.37           C  
ATOM    998  CZ  PHE A 132      25.631 103.949  16.584  1.00  8.86           C  
ATOM    999  N   TYR A 133      30.858 103.333  11.794  1.00  7.51           N  
ATOM   1000  CA  TYR A 133      32.150 103.357  11.119  1.00  6.41           C  
ATOM   1001  C   TYR A 133      32.893 104.652  11.432  1.00  7.03           C  
ATOM   1002  O   TYR A 133      32.277 105.709  11.541  1.00  7.10           O  
ATOM   1003  CB  TYR A 133      31.972 103.317   9.598  1.00  7.39           C  
ATOM   1004  CG  TYR A 133      31.263 102.112   9.037  1.00  7.39           C  
ATOM   1005  CD1 TYR A 133      31.970 101.111   8.372  1.00  7.66           C  
ATOM   1006  CD2 TYR A 133      29.877 101.999   9.123  1.00  4.97           C  
ATOM   1007  CE1 TYR A 133      31.309 100.029   7.799  1.00  6.57           C  
ATOM   1008  CE2 TYR A 133      29.212 100.923   8.558  1.00  7.06           C  
ATOM   1009  CZ  TYR A 133      29.932  99.944   7.897  1.00  7.43           C  
ATOM   1010  OH  TYR A 133      29.265  98.888   7.324  1.00  7.27           O  
ATOM   1011  N   ILE A 134      34.210 104.566  11.589  1.00  7.60           N  
ATOM   1012  CA  ILE A 134      35.021 105.761  11.804  1.00  6.53           C  
ATOM   1013  C   ILE A 134      36.205 105.652  10.849  1.00  6.89           C  
ATOM   1014  O   ILE A 134      36.862 104.614  10.787  1.00  7.29           O  
ATOM   1015  CB  ILE A 134      35.571 105.882  13.246  1.00  7.21           C  
ATOM   1016  CG1 ILE A 134      34.429 105.876  14.260  1.00  7.47           C  
ATOM   1017  CG2 ILE A 134      36.355 107.194  13.384  1.00  8.21           C  
ATOM   1018  CD1 ILE A 134      34.898 106.023  15.705  1.00  9.08           C  
ATOM   1019  N   PHE A 135      36.460 106.718  10.095  1.00  8.19           N  
ATOM   1020  CA  PHE A 135      37.570 106.752   9.136  1.00  7.35           C  
ATOM   1021  C   PHE A 135      38.493 107.908   9.499  1.00  9.33           C  
ATOM   1022  O   PHE A 135      38.032 108.936   9.985  1.00  8.33           O  
ATOM   1023  CB  PHE A 135      37.032 106.948   7.718  1.00  8.04           C  
ATOM   1024  CG  PHE A 135      36.122 105.843   7.262  1.00  7.10           C  
ATOM   1025  CD1 PHE A 135      36.636 104.708   6.640  1.00  8.44           C  
ATOM   1026  CD2 PHE A 135      34.751 105.915   7.497  1.00  8.66           C  
ATOM   1027  CE1 PHE A 135      35.794 103.660   6.260  1.00  8.72           C  
ATOM   1028  CE2 PHE A 135      33.909 104.876   7.122  1.00  8.25           C  
ATOM   1029  CZ  PHE A 135      34.429 103.748   6.503  1.00  7.88           C  
ATOM   1030  N   ASP A 136      39.793 107.747   9.267  1.00 10.39           N  
ATOM   1031  CA  ASP A 136      40.724 108.813   9.623  1.00 11.86           C  
ATOM   1032  C   ASP A 136      40.839 109.906   8.560  1.00 13.11           C  
ATOM   1033  O   ASP A 136      40.085 109.923   7.589  1.00 12.36           O  
ATOM   1034  CB  ASP A 136      42.112 108.242   9.965  1.00 11.60           C  
ATOM   1035  CG  ASP A 136      42.778 107.537   8.794  1.00 13.33           C  
ATOM   1036  OD1 ASP A 136      42.410 107.803   7.636  1.00 12.35           O  
ATOM   1037  OD2 ASP A 136      43.694 106.723   9.038  1.00 14.82           O  
ATOM   1038  N   ARG A 137      41.775 110.828   8.768  1.00 12.94           N  
ATOM   1039  CA  ARG A 137      41.981 111.943   7.845  1.00 16.38           C  
ATOM   1040  C   ARG A 137      42.213 111.495   6.408  1.00 14.99           C  
ATOM   1041  O   ARG A 137      41.946 112.244   5.466  1.00 14.45           O  
ATOM   1042  CB  ARG A 137      43.170 112.798   8.302  1.00 19.51           C  
ATOM   1043  CG  ARG A 137      44.514 112.095   8.178  1.00 25.68           C  
ATOM   1044  CD  ARG A 137      45.665 112.982   8.646  1.00 29.85           C  
ATOM   1045  NE  ARG A 137      45.718 114.251   7.924  1.00 32.73           N  
ATOM   1046  CZ  ARG A 137      46.711 115.129   8.030  1.00 33.39           C  
ATOM   1047  NH1 ARG A 137      47.740 114.876   8.827  1.00 35.35           N  
ATOM   1048  NH2 ARG A 137      46.673 116.262   7.346  1.00 34.07           N  
ATOM   1049  N   ASP A 138      42.717 110.277   6.238  1.00 13.91           N  
ATOM   1050  CA  ASP A 138      42.973 109.754   4.904  1.00 14.76           C  
ATOM   1051  C   ASP A 138      41.849 108.835   4.441  1.00 12.80           C  
ATOM   1052  O   ASP A 138      41.989 108.121   3.452  1.00 13.80           O  
ATOM   1053  CB  ASP A 138      44.308 109.009   4.884  1.00 15.74           C  
ATOM   1054  CG  ASP A 138      45.481 109.917   5.209  1.00 19.12           C  
ATOM   1055  OD1 ASP A 138      46.180 109.657   6.209  1.00 20.78           O  
ATOM   1056  OD2 ASP A 138      45.695 110.898   4.465  1.00 19.81           O  
ATOM   1057  N   LEU A 139      40.736 108.877   5.172  1.00 11.81           N  
ATOM   1058  CA  LEU A 139      39.550 108.071   4.887  1.00 10.86           C  
ATOM   1059  C   LEU A 139      39.769 106.567   4.978  1.00 10.47           C  
ATOM   1060  O   LEU A 139      39.115 105.789   4.288  1.00 10.00           O  
ATOM   1061  CB  LEU A 139      38.953 108.439   3.520  1.00 10.64           C  
ATOM   1062  CG  LEU A 139      38.246 109.802   3.474  1.00 12.63           C  
ATOM   1063  CD1 LEU A 139      37.615 110.013   2.100  1.00 15.52           C  
ATOM   1064  CD2 LEU A 139      37.170 109.866   4.557  1.00 13.79           C  
ATOM   1065  N   LYS A 140      40.691 106.162   5.844  1.00 11.47           N  
ATOM   1066  CA  LYS A 140      40.953 104.743   6.053  1.00 11.03           C  
ATOM   1067  C   LYS A 140      40.173 104.339   7.299  1.00  9.59           C  
ATOM   1068  O   LYS A 140      40.141 105.080   8.282  1.00  9.89           O  
ATOM   1069  CB  LYS A 140      42.442 104.493   6.280  1.00 13.42           C  
ATOM   1070  CG  LYS A 140      43.328 104.896   5.116  1.00 17.78           C  
ATOM   1071  CD  LYS A 140      44.790 104.705   5.474  1.00 23.47           C  
ATOM   1072  CE  LYS A 140      45.709 105.170   4.359  1.00 27.24           C  
ATOM   1073  NZ  LYS A 140      47.138 104.924   4.705  1.00 29.94           N  
ATOM   1074  N   CYS A 141      39.554 103.162   7.261  1.00  8.27           N  
ATOM   1075  CA  CYS A 141      38.770 102.694   8.396  1.00  8.56           C  
ATOM   1076  C   CYS A 141      39.655 102.366   9.599  1.00  9.51           C  
ATOM   1077  O   CYS A 141      40.570 101.549   9.507  1.00 10.10           O  
ATOM   1078  CB  CYS A 141      37.951 101.467   7.996  1.00  7.46           C  
ATOM   1079  SG  CYS A 141      36.890 100.855   9.315  1.00  9.38           S  
ATOM   1080  N   VAL A 142      39.382 103.023  10.724  1.00  8.46           N  
ATOM   1081  CA  VAL A 142      40.150 102.793  11.948  1.00  8.47           C  
ATOM   1082  C   VAL A 142      39.283 102.235  13.070  1.00  7.37           C  
ATOM   1083  O   VAL A 142      39.791 101.850  14.125  1.00  8.45           O  
ATOM   1084  CB  VAL A 142      40.841 104.087  12.439  1.00  7.13           C  
ATOM   1085  CG1 VAL A 142      41.992 104.437  11.507  1.00 10.30           C  
ATOM   1086  CG2 VAL A 142      39.843 105.228  12.495  1.00  8.34           C  
ATOM   1087  N   TYR A 143      37.974 102.205  12.843  1.00  6.93           N  
ATOM   1088  CA  TYR A 143      37.031 101.657  13.815  1.00  6.75           C  
ATOM   1089  C   TYR A 143      35.702 101.295  13.163  1.00  6.84           C  
ATOM   1090  O   TYR A 143      35.220 101.992  12.278  1.00  6.89           O  
ATOM   1091  CB  TYR A 143      36.731 102.651  14.952  1.00  7.41           C  
ATOM   1092  CG  TYR A 143      35.755 102.104  15.982  1.00  8.54           C  
ATOM   1093  CD1 TYR A 143      36.210 101.403  17.100  1.00  6.59           C  
ATOM   1094  CD2 TYR A 143      34.377 102.208  15.792  1.00  7.27           C  
ATOM   1095  CE1 TYR A 143      35.314 100.813  18.002  1.00  8.51           C  
ATOM   1096  CE2 TYR A 143      33.474 101.624  16.683  1.00  6.51           C  
ATOM   1097  CZ  TYR A 143      33.948 100.927  17.782  1.00  7.50           C  
ATOM   1098  OH  TYR A 143      33.058 100.330  18.646  1.00  8.91           O  
ATOM   1099  N   ARG A 144      35.118 100.191  13.609  1.00  7.57           N  
ATOM   1100  CA  ARG A 144      33.804  99.781  13.137  1.00  7.35           C  
ATOM   1101  C   ARG A 144      33.206  98.884  14.203  1.00  8.10           C  
ATOM   1102  O   ARG A 144      33.922  98.136  14.876  1.00  6.89           O  
ATOM   1103  CB  ARG A 144      33.864  99.053  11.781  1.00  7.18           C  
ATOM   1104  CG  ARG A 144      34.533  97.685  11.772  1.00  7.99           C  
ATOM   1105  CD  ARG A 144      36.047  97.800  11.813  1.00  7.45           C  
ATOM   1106  NE  ARG A 144      36.692  96.508  11.586  1.00  7.89           N  
ATOM   1107  CZ  ARG A 144      37.254  95.767  12.536  1.00 10.10           C  
ATOM   1108  NH1 ARG A 144      37.264  96.177  13.797  1.00 12.17           N  
ATOM   1109  NH2 ARG A 144      37.808  94.604  12.223  1.00 13.57           N  
ATOM   1110  N   GLY A 145      31.898  98.991  14.382  1.00  7.19           N  
ATOM   1111  CA  GLY A 145      31.235  98.175  15.376  1.00  8.17           C  
ATOM   1112  C   GLY A 145      30.201  98.915  16.197  1.00  7.56           C  
ATOM   1113  O   GLY A 145      29.483  99.779  15.691  1.00  8.00           O  
ATOM   1114  N   GLN A 146      30.145  98.570  17.480  1.00  7.20           N  
ATOM   1115  CA  GLN A 146      29.182  99.140  18.419  1.00  7.78           C  
ATOM   1116  C   GLN A 146      29.437 100.583  18.846  1.00  7.31           C  
ATOM   1117  O   GLN A 146      30.537 101.114  18.695  1.00  8.55           O  
ATOM   1118  CB  GLN A 146      29.143  98.279  19.681  1.00  5.48           C  
ATOM   1119  CG  GLN A 146      30.472  98.297  20.449  1.00  6.73           C  
ATOM   1120  CD  GLN A 146      30.379  97.627  21.800  1.00  6.14           C  
ATOM   1121  OE1 GLN A 146      29.690  96.627  21.953  1.00  8.30           O  
ATOM   1122  NE2 GLN A 146      31.094  98.166  22.785  1.00  6.61           N  
ATOM   1123  N   LEU A 147      28.395 101.199  19.397  1.00  5.67           N  
ATOM   1124  CA  LEU A 147      28.473 102.563  19.916  1.00  5.56           C  
ATOM   1125  C   LEU A 147      29.145 102.471  21.284  1.00  7.81           C  
ATOM   1126  O   LEU A 147      30.000 103.294  21.648  1.00  5.85           O  
ATOM   1127  CB  LEU A 147      27.062 103.134  20.082  1.00  7.93           C  
ATOM   1128  CG  LEU A 147      26.911 104.459  20.831  1.00  8.11           C  
ATOM   1129  CD1 LEU A 147      27.622 105.571  20.071  1.00  8.23           C  
ATOM   1130  CD2 LEU A 147      25.434 104.782  20.976  1.00 11.01           C  
ATOM   1131  N   ASP A 148      28.729 101.457  22.034  1.00  7.11           N  
ATOM   1132  CA  ASP A 148      29.243 101.175  23.368  1.00  6.88           C  
ATOM   1133  C   ASP A 148      28.713  99.802  23.791  1.00  6.60           C  
ATOM   1134  O   ASP A 148      28.078  99.110  22.987  1.00  6.88           O  
ATOM   1135  CB  ASP A 148      28.815 102.267  24.367  1.00  8.38           C  
ATOM   1136  CG  ASP A 148      27.310 102.455  24.438  1.00 11.24           C  
ATOM   1137  OD1 ASP A 148      26.578 101.456  24.303  1.00 10.15           O  
ATOM   1138  OD2 ASP A 148      26.853 103.604  24.649  1.00 10.55           O  
ATOM   1139  N   ASP A 149      28.967  99.409  25.037  1.00  7.93           N  
ATOM   1140  CA  ASP A 149      28.525  98.105  25.530  1.00  9.27           C  
ATOM   1141  C   ASP A 149      27.024  97.992  25.797  1.00  8.36           C  
ATOM   1142  O   ASP A 149      26.495  96.886  25.879  1.00 10.00           O  
ATOM   1143  CB  ASP A 149      29.246  97.732  26.834  1.00 10.99           C  
ATOM   1144  CG  ASP A 149      30.719  97.423  26.645  1.00 13.81           C  
ATOM   1145  OD1 ASP A 149      31.175  97.250  25.496  1.00 15.31           O  
ATOM   1146  OD2 ASP A 149      31.426  97.338  27.674  1.00 16.34           O  
ATOM   1147  N   SER A 150      26.336  99.121  25.941  1.00  7.46           N  
ATOM   1148  CA  SER A 150      24.907  99.082  26.230  1.00  8.35           C  
ATOM   1149  C   SER A 150      24.089  98.425  25.119  1.00  7.25           C  
ATOM   1150  O   SER A 150      24.432  98.512  23.941  1.00  8.96           O  
ATOM   1151  CB  SER A 150      24.376 100.497  26.504  1.00  6.97           C  
ATOM   1152  OG  SER A 150      24.242 101.243  25.309  1.00 12.04           O  
ATOM   1153  N   ARG A 151      23.007  97.762  25.519  1.00  6.86           N  
ATOM   1154  CA  ARG A 151      22.090  97.081  24.606  1.00  7.31           C  
ATOM   1155  C   ARG A 151      20.701  97.225  25.207  1.00  8.62           C  
ATOM   1156  O   ARG A 151      20.564  97.384  26.414  1.00  8.75           O  
ATOM   1157  CB  ARG A 151      22.434  95.593  24.505  1.00  7.66           C  
ATOM   1158  CG  ARG A 151      23.793  95.283  23.900  1.00  8.55           C  
ATOM   1159  CD  ARG A 151      23.821  95.525  22.398  1.00  9.21           C  
ATOM   1160  NE  ARG A 151      25.083  95.079  21.810  1.00  9.88           N  
ATOM   1161  CZ  ARG A 151      26.236  95.740  21.902  1.00 10.11           C  
ATOM   1162  NH1 ARG A 151      26.301  96.892  22.555  1.00  9.16           N  
ATOM   1163  NH2 ARG A 151      27.334  95.241  21.341  1.00  9.12           N  
ATOM   1164  N   PRO A 152      19.652  97.171  24.377  1.00  9.07           N  
ATOM   1165  CA  PRO A 152      18.300  97.301  24.921  1.00  9.70           C  
ATOM   1166  C   PRO A 152      17.999  96.310  26.044  1.00 10.12           C  
ATOM   1167  O   PRO A 152      17.179  96.587  26.917  1.00 12.15           O  
ATOM   1168  CB  PRO A 152      17.414  97.048  23.706  1.00  9.64           C  
ATOM   1169  CG  PRO A 152      18.231  97.574  22.576  1.00 10.29           C  
ATOM   1170  CD  PRO A 152      19.623  97.069  22.904  1.00  9.88           C  
ATOM   1171  N   ASN A 153      18.665  95.158  26.025  1.00 10.90           N  
ATOM   1172  CA  ASN A 153      18.414  94.131  27.030  1.00 11.75           C  
ATOM   1173  C   ASN A 153      19.398  93.984  28.190  1.00 12.34           C  
ATOM   1174  O   ASN A 153      19.251  93.049  28.976  1.00 14.30           O  
ATOM   1175  CB  ASN A 153      18.277  92.769  26.345  1.00 14.42           C  
ATOM   1176  CG  ASN A 153      19.572  92.309  25.706  1.00 17.42           C  
ATOM   1177  OD1 ASN A 153      20.232  93.073  25.001  1.00 21.85           O  
ATOM   1178  ND2 ASN A 153      19.938  91.055  25.941  1.00 19.60           N  
ATOM   1179  N   ASN A 154      20.382  94.872  28.336  1.00 12.67           N  
ATOM   1180  CA  ASN A 154      21.320  94.687  29.449  1.00 13.20           C  
ATOM   1181  C   ASN A 154      21.392  95.684  30.606  1.00 15.31           C  
ATOM   1182  O   ASN A 154      22.114  95.438  31.567  1.00 18.52           O  
ATOM   1183  CB  ASN A 154      22.749  94.449  28.929  1.00 12.99           C  
ATOM   1184  CG  ASN A 154      23.330  95.648  28.204  1.00  8.05           C  
ATOM   1185  OD1 ASN A 154      22.930  96.790  28.424  1.00  9.01           O  
ATOM   1186  ND2 ASN A 154      24.303  95.387  27.346  1.00 10.48           N  
ATOM   1187  N   GLY A 155      20.680  96.802  30.539  1.00 15.76           N  
ATOM   1188  CA  GLY A 155      20.729  97.734  31.663  1.00 15.42           C  
ATOM   1189  C   GLY A 155      21.937  98.652  31.818  1.00 15.00           C  
ATOM   1190  O   GLY A 155      21.953  99.505  32.709  1.00 15.35           O  
ATOM   1191  N   ILE A 156      22.956  98.480  30.985  1.00 11.40           N  
ATOM   1192  CA  ILE A 156      24.137  99.340  31.040  1.00 10.46           C  
ATOM   1193  C   ILE A 156      23.712 100.702  30.493  1.00  8.99           C  
ATOM   1194  O   ILE A 156      23.107 100.781  29.426  1.00 10.37           O  
ATOM   1195  CB  ILE A 156      25.277  98.775  30.156  1.00 10.51           C  
ATOM   1196  CG1 ILE A 156      25.797  97.470  30.753  1.00  9.58           C  
ATOM   1197  CG2 ILE A 156      26.407  99.790  30.029  1.00  9.24           C  
ATOM   1198  CD1 ILE A 156      26.845  96.769  29.888  1.00 10.57           C  
ATOM   1199  N   PRO A 157      23.997 101.794  31.222  1.00  7.25           N  
ATOM   1200  CA  PRO A 157      23.584 103.089  30.678  1.00  6.90           C  
ATOM   1201  C   PRO A 157      24.300 103.405  29.369  1.00  6.99           C  
ATOM   1202  O   PRO A 157      25.453 103.009  29.170  1.00  8.19           O  
ATOM   1203  CB  PRO A 157      23.966 104.071  31.784  1.00  6.23           C  
ATOM   1204  CG  PRO A 157      23.846 103.246  33.025  1.00  7.20           C  
ATOM   1205  CD  PRO A 157      24.474 101.932  32.610  1.00  6.74           C  
ATOM   1206  N   VAL A 158      23.612 104.119  28.484  1.00  7.01           N  
ATOM   1207  CA  VAL A 158      24.190 104.504  27.202  1.00  7.04           C  
ATOM   1208  C   VAL A 158      25.200 105.620  27.458  1.00  6.86           C  
ATOM   1209  O   VAL A 158      24.884 106.591  28.143  1.00  8.50           O  
ATOM   1210  CB  VAL A 158      23.115 105.027  26.233  1.00  7.18           C  
ATOM   1211  CG1 VAL A 158      23.760 105.428  24.913  1.00  9.28           C  
ATOM   1212  CG2 VAL A 158      22.059 103.964  26.008  1.00  6.87           C  
ATOM   1213  N   THR A 159      26.399 105.480  26.895  1.00  5.17           N  
ATOM   1214  CA  THR A 159      27.465 106.463  27.085  1.00  5.74           C  
ATOM   1215  C   THR A 159      28.207 106.858  25.806  1.00  7.72           C  
ATOM   1216  O   THR A 159      28.827 107.921  25.752  1.00  7.99           O  
ATOM   1217  CB  THR A 159      28.530 105.928  28.051  1.00  6.54           C  
ATOM   1218  OG1 THR A 159      29.139 104.764  27.478  1.00  7.87           O  
ATOM   1219  CG2 THR A 159      27.910 105.551  29.391  1.00  8.91           C  
ATOM   1220  N   GLY A 160      28.163 105.990  24.799  1.00  5.91           N  
ATOM   1221  CA  GLY A 160      28.873 106.250  23.554  1.00  7.75           C  
ATOM   1222  C   GLY A 160      30.373 106.078  23.743  1.00  7.61           C  
ATOM   1223  O   GLY A 160      31.173 106.484  22.895  1.00  7.28           O  
ATOM   1224  N   GLU A 161      30.750 105.441  24.848  1.00  8.15           N  
ATOM   1225  CA  GLU A 161      32.153 105.240  25.205  1.00  9.74           C  
ATOM   1226  C   GLU A 161      33.091 104.667  24.144  1.00  8.60           C  
ATOM   1227  O   GLU A 161      34.213 105.148  23.987  1.00  9.13           O  
ATOM   1228  CB  GLU A 161      32.251 104.377  26.468  1.00 11.35           C  
ATOM   1229  CG  GLU A 161      33.677 104.186  26.962  1.00 18.01           C  
ATOM   1230  CD  GLU A 161      33.749 103.444  28.285  1.00 21.29           C  
ATOM   1231  OE1 GLU A 161      33.259 103.979  29.302  1.00 23.12           O  
ATOM   1232  OE2 GLU A 161      34.298 102.321  28.305  1.00 27.34           O  
ATOM   1233  N   SER A 162      32.659 103.636  23.429  1.00  7.99           N  
ATOM   1234  CA  SER A 162      33.527 103.039  22.421  1.00  7.79           C  
ATOM   1235  C   SER A 162      33.920 104.019  21.321  1.00  8.04           C  
ATOM   1236  O   SER A 162      35.091 104.100  20.943  1.00  8.79           O  
ATOM   1237  CB  SER A 162      32.862 101.805  21.805  1.00  8.11           C  
ATOM   1238  OG  SER A 162      32.575 100.848  22.809  1.00  9.01           O  
ATOM   1239  N   ILE A 163      32.948 104.766  20.806  1.00  8.88           N  
ATOM   1240  CA  ILE A 163      33.243 105.734  19.754  1.00  7.89           C  
ATOM   1241  C   ILE A 163      33.990 106.945  20.320  1.00  7.59           C  
ATOM   1242  O   ILE A 163      34.904 107.472  19.683  1.00  7.49           O  
ATOM   1243  CB  ILE A 163      31.950 106.171  19.030  1.00  8.73           C  
ATOM   1244  CG1 ILE A 163      31.370 104.967  18.278  1.00 10.69           C  
ATOM   1245  CG2 ILE A 163      32.235 107.317  18.072  1.00  9.52           C  
ATOM   1246  CD1 ILE A 163      30.107 105.249  17.513  1.00 13.62           C  
ATOM   1247  N   ARG A 164      33.616 107.363  21.527  1.00  7.82           N  
ATOM   1248  CA  ARG A 164      34.274 108.494  22.177  1.00  7.17           C  
ATOM   1249  C   ARG A 164      35.760 108.209  22.377  1.00  8.20           C  
ATOM   1250  O   ARG A 164      36.599 109.074  22.140  1.00  9.19           O  
ATOM   1251  CB  ARG A 164      33.613 108.793  23.533  1.00  5.23           C  
ATOM   1252  CG  ARG A 164      32.277 109.496  23.409  1.00  6.24           C  
ATOM   1253  CD  ARG A 164      31.475 109.505  24.708  1.00  4.92           C  
ATOM   1254  NE  ARG A 164      30.197 110.182  24.491  1.00  5.47           N  
ATOM   1255  CZ  ARG A 164      30.029 111.502  24.489  1.00  7.39           C  
ATOM   1256  NH1 ARG A 164      31.056 112.317  24.721  1.00  7.94           N  
ATOM   1257  NH2 ARG A 164      28.842 112.013  24.188  1.00  7.45           N  
ATOM   1258  N   ALA A 165      36.080 106.992  22.804  1.00  8.29           N  
ATOM   1259  CA  ALA A 165      37.469 106.614  23.024  1.00  8.37           C  
ATOM   1260  C   ALA A 165      38.255 106.591  21.715  1.00  9.57           C  
ATOM   1261  O   ALA A 165      39.430 106.961  21.685  1.00 10.66           O  
ATOM   1262  CB  ALA A 165      37.543 105.258  23.695  1.00  6.70           C  
ATOM   1263  N   ALA A 166      37.608 106.153  20.640  1.00  8.89           N  
ATOM   1264  CA  ALA A 166      38.266 106.092  19.339  1.00  8.70           C  
ATOM   1265  C   ALA A 166      38.531 107.501  18.819  1.00  9.69           C  
ATOM   1266  O   ALA A 166      39.609 107.788  18.289  1.00  8.38           O  
ATOM   1267  CB  ALA A 166      37.401 105.324  18.347  1.00  8.46           C  
ATOM   1268  N   LEU A 167      37.542 108.377  18.972  1.00  8.71           N  
ATOM   1269  CA  LEU A 167      37.666 109.750  18.518  1.00  8.48           C  
ATOM   1270  C   LEU A 167      38.740 110.490  19.305  1.00  9.60           C  
ATOM   1271  O   LEU A 167      39.537 111.224  18.722  1.00  9.10           O  
ATOM   1272  CB  LEU A 167      36.319 110.475  18.636  1.00  8.58           C  
ATOM   1273  CG  LEU A 167      35.249 109.971  17.657  1.00  8.26           C  
ATOM   1274  CD1 LEU A 167      33.942 110.727  17.859  1.00  7.19           C  
ATOM   1275  CD2 LEU A 167      35.753 110.153  16.230  1.00  8.75           C  
ATOM   1276  N   ASP A 168      38.771 110.289  20.621  1.00  8.63           N  
ATOM   1277  CA  ASP A 168      39.780 110.942  21.448  1.00 10.71           C  
ATOM   1278  C   ASP A 168      41.175 110.517  20.999  1.00 11.29           C  
ATOM   1279  O   ASP A 168      42.080 111.343  20.899  1.00 13.02           O  
ATOM   1280  CB  ASP A 168      39.602 110.590  22.929  1.00 11.20           C  
ATOM   1281  CG  ASP A 168      38.382 111.246  23.544  1.00 13.56           C  
ATOM   1282  OD1 ASP A 168      37.891 112.245  22.974  1.00 13.94           O  
ATOM   1283  OD2 ASP A 168      37.923 110.769  24.608  1.00 11.99           O  
ATOM   1284  N   ALA A 169      41.340 109.227  20.731  1.00 10.07           N  
ATOM   1285  CA  ALA A 169      42.622 108.702  20.285  1.00 11.10           C  
ATOM   1286  C   ALA A 169      43.015 109.357  18.964  1.00 11.62           C  
ATOM   1287  O   ALA A 169      44.158 109.782  18.791  1.00 13.05           O  
ATOM   1288  CB  ALA A 169      42.540 107.182  20.126  1.00  9.49           C  
ATOM   1289  N   LEU A 170      42.062 109.444  18.039  1.00  9.10           N  
ATOM   1290  CA  LEU A 170      42.316 110.059  16.737  1.00 10.86           C  
ATOM   1291  C   LEU A 170      42.675 111.540  16.841  1.00 13.10           C  
ATOM   1292  O   LEU A 170      43.508 112.040  16.082  1.00 13.34           O  
ATOM   1293  CB  LEU A 170      41.096 109.887  15.829  1.00  9.86           C  
ATOM   1294  CG  LEU A 170      40.889 108.475  15.280  1.00 11.14           C  
ATOM   1295  CD1 LEU A 170      39.521 108.364  14.630  1.00 11.21           C  
ATOM   1296  CD2 LEU A 170      41.983 108.156  14.278  1.00 12.94           C  
ATOM   1297  N   LEU A 171      42.043 112.241  17.775  1.00 12.12           N  
ATOM   1298  CA  LEU A 171      42.306 113.664  17.966  1.00 13.94           C  
ATOM   1299  C   LEU A 171      43.628 113.904  18.684  1.00 16.02           C  
ATOM   1300  O   LEU A 171      44.226 114.971  18.550  1.00 17.12           O  
ATOM   1301  CB  LEU A 171      41.168 114.310  18.762  1.00 13.39           C  
ATOM   1302  CG  LEU A 171      39.818 114.376  18.046  1.00 12.54           C  
ATOM   1303  CD1 LEU A 171      38.710 114.626  19.055  1.00 12.45           C  
ATOM   1304  CD2 LEU A 171      39.852 115.462  16.982  1.00 12.75           C  
ATOM   1305  N   GLU A 172      44.081 112.913  19.445  1.00 18.09           N  
ATOM   1306  CA  GLU A 172      45.327 113.041  20.193  1.00 21.36           C  
ATOM   1307  C   GLU A 172      46.527 112.397  19.502  1.00 22.67           C  
ATOM   1308  O   GLU A 172      47.660 112.499  19.982  1.00 22.39           O  
ATOM   1309  CB  GLU A 172      45.147 112.453  21.594  1.00 23.15           C  
ATOM   1310  CG  GLU A 172      44.204 113.262  22.475  1.00 27.80           C  
ATOM   1311  CD  GLU A 172      43.935 112.604  23.816  1.00 31.31           C  
ATOM   1312  OE1 GLU A 172      44.900 112.114  24.443  1.00 33.75           O  
ATOM   1313  OE2 GLU A 172      42.763 112.584  24.247  1.00 32.23           O  
ATOM   1314  N   GLY A 173      46.279 111.738  18.376  1.00 22.46           N  
ATOM   1315  CA  GLY A 173      47.358 111.099  17.643  1.00 23.28           C  
ATOM   1316  C   GLY A 173      47.789 109.760  18.210  1.00 23.24           C  
ATOM   1317  O   GLY A 173      48.923 109.325  18.000  1.00 24.42           O  
ATOM   1318  N   ARG A 174      46.887 109.104  18.932  1.00 21.90           N  
ATOM   1319  CA  ARG A 174      47.169 107.801  19.523  1.00 20.87           C  
ATOM   1320  C   ARG A 174      46.399 106.731  18.754  1.00 19.71           C  
ATOM   1321  O   ARG A 174      45.403 107.025  18.093  1.00 17.31           O  
ATOM   1322  CB  ARG A 174      46.745 107.789  20.995  1.00 24.06           C  
ATOM   1323  CG  ARG A 174      47.471 108.815  21.848  1.00 27.39           C  
ATOM   1324  CD  ARG A 174      47.010 108.806  23.302  1.00 30.01           C  
ATOM   1325  NE  ARG A 174      45.641 109.289  23.479  1.00 31.23           N  
ATOM   1326  CZ  ARG A 174      44.558 108.516  23.458  1.00 30.82           C  
ATOM   1327  NH1 ARG A 174      44.673 107.209  23.265  1.00 29.57           N  
ATOM   1328  NH2 ARG A 174      43.359 109.052  23.637  1.00 30.21           N  
ATOM   1329  N   PRO A 175      46.861 105.475  18.815  1.00 19.40           N  
ATOM   1330  CA  PRO A 175      46.167 104.398  18.101  1.00 18.73           C  
ATOM   1331  C   PRO A 175      44.778 104.146  18.685  1.00 16.81           C  
ATOM   1332  O   PRO A 175      44.589 104.201  19.899  1.00 16.52           O  
ATOM   1333  CB  PRO A 175      47.090 103.198  18.307  1.00 20.49           C  
ATOM   1334  CG  PRO A 175      48.442 103.825  18.471  1.00 21.55           C  
ATOM   1335  CD  PRO A 175      48.146 105.002  19.358  1.00 20.02           C  
ATOM   1336  N   VAL A 176      43.803 103.878  17.823  1.00 15.47           N  
ATOM   1337  CA  VAL A 176      42.457 103.592  18.303  1.00 14.12           C  
ATOM   1338  C   VAL A 176      42.541 102.296  19.100  1.00 14.10           C  
ATOM   1339  O   VAL A 176      43.264 101.378  18.720  1.00 14.17           O  
ATOM   1340  CB  VAL A 176      41.472 103.398  17.131  1.00 13.69           C  
ATOM   1341  CG1 VAL A 176      40.166 102.799  17.634  1.00 13.69           C  
ATOM   1342  CG2 VAL A 176      41.211 104.731  16.448  1.00 14.68           C  
ATOM   1343  N   PRO A 177      41.819 102.206  20.225  1.00 13.78           N  
ATOM   1344  CA  PRO A 177      41.880 100.970  21.008  1.00 14.63           C  
ATOM   1345  C   PRO A 177      41.662  99.752  20.105  1.00 16.27           C  
ATOM   1346  O   PRO A 177      40.820  99.780  19.204  1.00 15.31           O  
ATOM   1347  CB  PRO A 177      40.760 101.158  22.026  1.00 14.92           C  
ATOM   1348  CG  PRO A 177      40.792 102.632  22.267  1.00 13.11           C  
ATOM   1349  CD  PRO A 177      40.930 103.193  20.864  1.00 13.06           C  
ATOM   1350  N   GLU A 178      42.424  98.689  20.346  1.00 18.35           N  
ATOM   1351  CA  GLU A 178      42.330  97.482  19.532  1.00 19.21           C  
ATOM   1352  C   GLU A 178      41.021  96.727  19.650  1.00 18.78           C  
ATOM   1353  O   GLU A 178      40.527  96.182  18.663  1.00 17.65           O  
ATOM   1354  CB  GLU A 178      43.484  96.526  19.855  1.00 23.26           C  
ATOM   1355  CG  GLU A 178      44.715  96.721  18.982  1.00 28.78           C  
ATOM   1356  CD  GLU A 178      45.793  95.686  19.250  1.00 30.90           C  
ATOM   1357  OE1 GLU A 178      45.455  94.483  19.316  1.00 33.13           O  
ATOM   1358  OE2 GLU A 178      46.977  96.072  19.383  1.00 31.93           O  
ATOM   1359  N   LYS A 179      40.459  96.690  20.853  1.00 17.58           N  
ATOM   1360  CA  LYS A 179      39.217  95.972  21.064  1.00 18.81           C  
ATOM   1361  C   LYS A 179      38.046  96.646  20.363  1.00 16.63           C  
ATOM   1362  O   LYS A 179      37.639  97.746  20.733  1.00 17.97           O  
ATOM   1363  CB  LYS A 179      38.929  95.841  22.560  1.00 22.29           C  
ATOM   1364  CG  LYS A 179      37.767  94.915  22.879  1.00 25.97           C  
ATOM   1365  CD  LYS A 179      37.664  94.653  24.373  1.00 30.63           C  
ATOM   1366  CE  LYS A 179      36.606  93.596  24.672  1.00 31.82           C  
ATOM   1367  NZ  LYS A 179      36.569  93.225  26.116  1.00 33.51           N  
ATOM   1368  N   GLN A 180      37.522  95.986  19.337  1.00 14.41           N  
ATOM   1369  CA  GLN A 180      36.386  96.508  18.588  1.00 12.06           C  
ATOM   1370  C   GLN A 180      35.351  95.396  18.447  1.00 11.70           C  
ATOM   1371  O   GLN A 180      35.598  94.361  17.821  1.00 13.35           O  
ATOM   1372  CB  GLN A 180      36.853  97.034  17.227  1.00 11.38           C  
ATOM   1373  CG  GLN A 180      37.774  98.241  17.369  1.00 10.38           C  
ATOM   1374  CD  GLN A 180      38.202  98.840  16.043  1.00 10.12           C  
ATOM   1375  OE1 GLN A 180      37.488  98.747  15.050  1.00  9.81           O  
ATOM   1376  NE2 GLN A 180      39.367  99.481  16.032  1.00 11.41           N  
ATOM   1377  N   LYS A 181      34.197  95.617  19.069  1.00 10.69           N  
ATOM   1378  CA  LYS A 181      33.106  94.646  19.081  1.00  9.55           C  
ATOM   1379  C   LYS A 181      32.009  95.019  18.087  1.00 10.11           C  
ATOM   1380  O   LYS A 181      31.703  96.192  17.904  1.00 10.07           O  
ATOM   1381  CB  LYS A 181      32.540  94.573  20.502  1.00 11.83           C  
ATOM   1382  CG  LYS A 181      33.645  94.477  21.551  1.00 16.52           C  
ATOM   1383  CD  LYS A 181      33.157  94.740  22.974  1.00 20.89           C  
ATOM   1384  CE  LYS A 181      32.429  93.545  23.561  1.00 25.11           C  
ATOM   1385  NZ  LYS A 181      32.101  93.761  25.003  1.00 27.58           N  
ATOM   1386  N   PRO A 182      31.399  94.016  17.436  1.00  9.07           N  
ATOM   1387  CA  PRO A 182      30.336  94.267  16.457  1.00  9.02           C  
ATOM   1388  C   PRO A 182      29.097  94.920  17.055  1.00 10.17           C  
ATOM   1389  O   PRO A 182      28.808  94.764  18.238  1.00  9.00           O  
ATOM   1390  CB  PRO A 182      30.004  92.869  15.920  1.00 11.01           C  
ATOM   1391  CG  PRO A 182      31.225  92.058  16.221  1.00 13.54           C  
ATOM   1392  CD  PRO A 182      31.648  92.570  17.573  1.00 11.19           C  
ATOM   1393  N   SER A 183      28.362  95.645  16.222  1.00  9.61           N  
ATOM   1394  CA  SER A 183      27.125  96.267  16.659  1.00  8.08           C  
ATOM   1395  C   SER A 183      26.077  95.199  16.378  1.00  8.35           C  
ATOM   1396  O   SER A 183      26.379  94.178  15.760  1.00  7.82           O  
ATOM   1397  CB  SER A 183      26.828  97.519  15.824  1.00  7.84           C  
ATOM   1398  OG  SER A 183      25.653  98.184  16.272  1.00  9.32           O  
ATOM   1399  N   ILE A 184      24.863  95.418  16.858  1.00  9.13           N  
ATOM   1400  CA  ILE A 184      23.769  94.494  16.622  1.00  7.52           C  
ATOM   1401  C   ILE A 184      22.510  95.331  16.475  1.00  7.84           C  
ATOM   1402  O   ILE A 184      22.383  96.395  17.087  1.00  9.19           O  
ATOM   1403  CB  ILE A 184      23.589  93.485  17.789  1.00  8.07           C  
ATOM   1404  CG1 ILE A 184      22.502  92.468  17.422  1.00 10.06           C  
ATOM   1405  CG2 ILE A 184      23.230  94.216  19.078  1.00 10.19           C  
ATOM   1406  CD1 ILE A 184      22.282  91.406  18.473  1.00 12.44           C  
ATOM   1407  N   GLY A 185      21.590  94.864  15.643  1.00  7.98           N  
ATOM   1408  CA  GLY A 185      20.356  95.591  15.435  1.00  8.65           C  
ATOM   1409  C   GLY A 185      19.517  94.925  14.370  1.00  8.92           C  
ATOM   1410  O   GLY A 185      19.790  93.793  13.985  1.00  9.29           O  
ATOM   1411  N   CYS A 186      18.484  95.620  13.909  1.00  8.54           N  
ATOM   1412  CA  CYS A 186      17.620  95.083  12.872  1.00  8.25           C  
ATOM   1413  C   CYS A 186      18.403  95.001  11.579  1.00  7.67           C  
ATOM   1414  O   CYS A 186      19.260  95.839  11.311  1.00  8.55           O  
ATOM   1415  CB  CYS A 186      16.407  95.986  12.669  1.00  7.31           C  
ATOM   1416  SG  CYS A 186      15.259  95.941  14.052  1.00 13.79           S  
ATOM   1417  N   SER A 187      18.122  93.980  10.779  1.00  8.43           N  
ATOM   1418  CA  SER A 187      18.822  93.851   9.522  1.00  9.09           C  
ATOM   1419  C   SER A 187      18.418  95.005   8.625  1.00 10.54           C  
ATOM   1420  O   SER A 187      17.294  95.494   8.705  1.00 10.89           O  
ATOM   1421  CB  SER A 187      18.456  92.537   8.832  1.00 11.88           C  
ATOM   1422  OG  SER A 187      18.951  92.529   7.501  1.00 16.31           O  
ATOM   1423  N   ILE A 188      19.349  95.461   7.799  1.00  8.83           N  
ATOM   1424  CA  ILE A 188      19.035  96.512   6.849  1.00 10.63           C  
ATOM   1425  C   ILE A 188      17.990  95.845   5.960  1.00 10.63           C  
ATOM   1426  O   ILE A 188      18.101  94.656   5.654  1.00 11.21           O  
ATOM   1427  CB  ILE A 188      20.292  96.911   6.048  1.00 10.07           C  
ATOM   1428  CG1 ILE A 188      21.206  97.749   6.946  1.00 12.82           C  
ATOM   1429  CG2 ILE A 188      19.908  97.685   4.794  1.00 11.69           C  
ATOM   1430  CD1 ILE A 188      22.500  98.175   6.307  1.00 13.43           C  
ATOM   1431  N   LYS A 189      16.962  96.594   5.577  1.00 10.62           N  
ATOM   1432  CA  LYS A 189      15.882  96.039   4.768  1.00 10.51           C  
ATOM   1433  C   LYS A 189      16.204  96.072   3.282  1.00 10.22           C  
ATOM   1434  O   LYS A 189      15.840  96.999   2.561  1.00  8.99           O  
ATOM   1435  CB  LYS A 189      14.591  96.798   5.076  1.00 12.99           C  
ATOM   1436  CG  LYS A 189      14.313  96.888   6.571  1.00 17.55           C  
ATOM   1437  CD  LYS A 189      14.347  95.512   7.223  1.00 19.81           C  
ATOM   1438  CE  LYS A 189      14.310  95.619   8.737  1.00 22.30           C  
ATOM   1439  NZ  LYS A 189      14.444  94.285   9.381  1.00 24.05           N  
ATOM   1440  N   TRP A 190      16.875  95.020   2.832  1.00 10.26           N  
ATOM   1441  CA  TRP A 190      17.292  94.903   1.448  1.00  8.73           C  
ATOM   1442  C   TRP A 190      16.141  94.736   0.466  1.00  8.54           C  
ATOM   1443  O   TRP A 190      15.118  94.122   0.777  1.00  9.18           O  
ATOM   1444  CB  TRP A 190      18.260  93.726   1.302  1.00  7.44           C  
ATOM   1445  CG  TRP A 190      19.409  93.774   2.282  1.00  7.28           C  
ATOM   1446  CD1 TRP A 190      19.546  93.043   3.427  1.00  7.63           C  
ATOM   1447  CD2 TRP A 190      20.559  94.624   2.207  1.00  7.13           C  
ATOM   1448  NE1 TRP A 190      20.713  93.385   4.072  1.00  7.20           N  
ATOM   1449  CE2 TRP A 190      21.354  94.354   3.342  1.00  7.25           C  
ATOM   1450  CE3 TRP A 190      20.996  95.593   1.288  1.00  8.82           C  
ATOM   1451  CZ2 TRP A 190      22.562  95.018   3.584  1.00  8.14           C  
ATOM   1452  CZ3 TRP A 190      22.195  96.252   1.530  1.00  9.91           C  
ATOM   1453  CH2 TRP A 190      22.964  95.959   2.670  1.00  9.34           C  
ATOM   1454  N   LYS A 191      16.324  95.299  -0.723  1.00  8.73           N  
ATOM   1455  CA  LYS A 191      15.343  95.181  -1.790  1.00 10.79           C  
ATOM   1456  C   LYS A 191      15.590  93.803  -2.393  1.00 11.51           C  
ATOM   1457  O   LYS A 191      16.630  93.189  -2.149  1.00 11.87           O  
ATOM   1458  CB  LYS A 191      15.584  96.251  -2.858  1.00 11.66           C  
ATOM   1459  CG  LYS A 191      15.419  97.680  -2.367  1.00 13.59           C  
ATOM   1460  CD  LYS A 191      16.019  98.680  -3.360  1.00 17.31           C  
ATOM   1461  CE  LYS A 191      15.349  98.603  -4.721  1.00 18.68           C  
ATOM   1462  NZ  LYS A 191      15.927  99.601  -5.669  1.00 21.20           N  
ATOM   1463  N   PRO A 192      14.634  93.291  -3.181  1.00 11.14           N  
ATOM   1464  CA  PRO A 192      14.811  91.973  -3.798  1.00 11.63           C  
ATOM   1465  C   PRO A 192      16.087  91.936  -4.636  1.00 14.09           C  
ATOM   1466  O   PRO A 192      16.454  92.934  -5.266  1.00 13.91           O  
ATOM   1467  CB  PRO A 192      13.564  91.834  -4.667  1.00 12.23           C  
ATOM   1468  CG  PRO A 192      12.544  92.626  -3.923  1.00 10.68           C  
ATOM   1469  CD  PRO A 192      13.309  93.849  -3.496  1.00 11.19           C  
ATOM   1470  N   SER A 193      16.759  90.787  -4.640  1.00 15.37           N  
ATOM   1471  CA  SER A 193      17.981  90.623  -5.413  1.00 20.02           C  
ATOM   1472  C   SER A 193      17.670  90.806  -6.892  1.00 21.96           C  
ATOM   1473  O   SER A 193      16.756  90.176  -7.431  1.00 21.82           O  
ATOM   1474  CB  SER A 193      18.575  89.235  -5.178  1.00 19.99           C  
ATOM   1475  OG  SER A 193      18.940  89.063  -3.820  1.00 25.62           O  
ATOM   1476  N   ALA A 194      18.434  91.672  -7.545  1.00 24.04           N  
ATOM   1477  CA  ALA A 194      18.238  91.942  -8.961  1.00 26.91           C  
ATOM   1478  C   ALA A 194      19.360  91.299  -9.762  1.00 28.76           C  
ATOM   1479  O   ALA A 194      20.216  92.051 -10.271  1.00 29.62           O  
ATOM   1480  CB  ALA A 194      18.207  93.449  -9.206  1.00 27.04           C  
ATOM   1481  OXT ALA A 194      19.377  90.051  -9.852  1.00 31.21           O  
TER    1482      ALA A 194                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
