
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  188 ( 1474),  selected  188 , name 2i3y_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2i3y_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D    31_A      E       1           -
LGA    C    32_A      N       2           -
LGA    H    33_A      L       3          6.079
LGA    K    34_A      Y       4          4.408
LGA    D    35_A      F       5          4.979
LGA    E    36_A      Q       6          5.691
LGA    K    37_A      S       7          2.732
LGA    -       -      M       8           -
LGA    G    38_A      I       9          1.546
LGA    T    39_A      N      10          2.371
LGA    I    40_A      S      11          2.911
LGA    -       -      F      12           -
LGA    Y    41_A      Y      13          2.889
LGA    D    42_A      A      14          2.953
LGA    Y    43_A      F      15          1.327
LGA    E    44_A      E      16          1.439
LGA    A    45_A      V      17          0.736
LGA    I    46_A      K      18          0.813
LGA    A    47_A      D      19          0.798
LGA    L    48_A      A      20          0.644
LGA    N    49_A      K      21          4.405
LGA    K    50_A      -       -           -
LGA    N    51_A      G      22          3.472
LGA    E    52_A      R      23          1.743
LGA    Y    53_A      T      24          1.194
LGA    V    54_A      V      25          1.264
LGA    S    55_A      S      26          1.075
LGA    F    56_A      L      27          1.335
LGA    K    57_A      E      28          1.276
LGA    Q    58_A      K      29          1.311
LGA    Y    59_A      Y      30          1.268
LGA    V    60_A      K      31          1.197
LGA    G    61_A      G      32          1.061
LGA    K    62_A      K      33          1.133
LGA    H    63_A      V      34          1.072
LGA    I    64_A      S      35          1.421
LGA    L    65_A      L      36          1.104
LGA    F    66_A      V      37          0.631
LGA    V    67_A      V      38          0.491
LGA    N    68_A      N      39          0.284
LGA    V    69_A      V      40          0.259
LGA    A    70_A      A      41          0.276
LGA    T    71_A      S      42          0.312
LGA    Y    72_A      D      43          0.899
LGA    C    73_A      C      44          0.952
LGA    G    74_A      Q      45          1.539
LGA    L    75_A      L      46          1.317
LGA    T    76_A      T      47          0.908
LGA    A    77_A      D      48          0.877
LGA    Q    78_A      R      49          2.634
LGA    -       -      N      50           -
LGA    Y    79_A      Y      51          0.633
LGA    P    80_A      L      52          2.331
LGA    E    81_A      G      53          1.942
LGA    L    82_A      L      54          0.969
LGA    N    83_A      K      55          1.418
LGA    A    84_A      E      56          1.620
LGA    L    85_A      L      57          0.630
LGA    Q    86_A      H      58          0.675
LGA    E    87_A      K      59          1.345
LGA    E    88_A      E      60          0.654
LGA    L    89_A      F      61          0.511
LGA    K    90_A      G      62          1.249
LGA    P    91_A      P      63          5.680
LGA    Y    92_A      S      64           #
LGA    G    93_A      H      65          0.901
LGA    L    94_A      F      66          0.940
LGA    V    95_A      S      67          1.372
LGA    V    96_A      V      68          0.990
LGA    L    97_A      L      69          0.549
LGA    G    98_A      A      70          0.436
LGA    F    99_A      F      71          0.410
LGA    P   100_A      P      72          0.458
LGA    C   101_A      C      73          0.309
LGA    N   102_A      N      74          0.463
LGA    Q   103_A      Q      75          0.742
LGA    F   104_A      F      76          0.716
LGA    G   105_A      G      77          0.693
LGA    K   106_A      E      78          0.520
LGA    Q   107_A      S      79          0.695
LGA    E   108_A      E      80          0.377
LGA    P   109_A      P      81          0.412
LGA    G   110_A      R      82          0.435
LGA    D   111_A      P      83          1.368
LGA    N   112_A      S      84          1.607
LGA    K   113_A      K      85          2.563
LGA    E   114_A      E      86          2.041
LGA    I   115_A      V      87          1.303
LGA    L   116_A      E      88          2.699
LGA    P   117_A      S      89          3.461
LGA    G   118_A      F      90          3.313
LGA    L   119_A      A      91          3.574
LGA    K   120_A      -       -           -
LGA    Y   121_A      -       -           -
LGA    V   122_A      -       -           -
LGA    R   123_A      -       -           -
LGA    P   124_A      -       -           -
LGA    G   125_A      -       -           -
LGA    G   126_A      -       -           -
LGA    G   127_A      -       -           -
LGA    F   128_A      -       -           -
LGA    V   129_A      R      92          1.356
LGA    P   130_A      K      93           -
LGA    -       -      N      94           -
LGA    -       -      Y      95           -
LGA    -       -      G      96           -
LGA    -       -      V      97           -
LGA    S   131_A      T      98          1.162
LGA    F   132_A      F      99          0.461
LGA    Q   133_A      P     100          0.487
LGA    L   134_A      I     101          0.806
LGA    F   135_A      F     102          0.909
LGA    E   136_A      H     103          0.865
LGA    K   137_A      K     104          0.758
LGA    G   138_A      I     105          1.602
LGA    D   139_A      K     106          1.042
LGA    V   140_A      I     107          1.040
LGA    N   141_A      L     108          1.183
LGA    G   142_A      G     109          1.499
LGA    E   143_A      S     110          1.682
LGA    K   144_A      E     111          1.531
LGA    E   145_A      G     112          1.072
LGA    Q   146_A      E     113          0.681
LGA    K   147_A      P     114          0.870
LGA    V   148_A      A     115          1.375
LGA    F   149_A      F     116          1.765
LGA    S   150_A      R     117          1.523
LGA    F   151_A      F     118          1.135
LGA    L   152_A      L     119          0.722
LGA    K   153_A      V     120          0.574
LGA    H   154_A      D     121          0.962
LGA    S   155_A      S     122          0.393
LGA    C   156_A      S     123          0.722
LGA    P   157_A      K     124          3.259
LGA    H   158_A      K     125          3.739
LGA    P   159_A      -       -           -
LGA    S   160_A      -       -           -
LGA    E   161_A      -       -           -
LGA    I   162_A      -       -           -
LGA    L   163_A      -       -           -
LGA    G   164_A      -       -           -
LGA    T   165_A      -       -           -
LGA    F   166_A      -       -           -
LGA    K   167_A      -       -           -
LGA    S   168_A      -       -           -
LGA    I   169_A      -       -           -
LGA    S   170_A      -       -           -
LGA    W   171_A      -       -           -
LGA    D   172_A      -       -           -
LGA    P   173_A      -       -           -
LGA    V   174_A      -       -           -
LGA    K   175_A      -       -           -
LGA    V   176_A      -       -           -
LGA    H   177_A      -       -           -
LGA    D   178_A      E     126          1.936
LGA    I   179_A      P     127          0.635
LGA    R   180_A      R     128          1.195
LGA    W   181_A      W     129          0.720
LGA    N   182_A      N     130          0.463
LGA    F   183_A      F     131          0.631
LGA    E   184_A      W     132          0.480
LGA    K   185_A      K     133          0.422
LGA    F   186_A      Y     134          0.430
LGA    L   187_A      L     135          0.841
LGA    V   188_A      V     136          0.967
LGA    G   189_A      N     137          0.912
LGA    P   190_A      P     138          0.797
LGA    D   191_A      E     139          0.864
LGA    G   192_A      G     140          1.193
LGA    I   193_A      Q     141          1.276
LGA    P   194_A      V     142          1.072
LGA    V   195_A      V     143          0.843
LGA    M   196_A      K     144          0.749
LGA    R   197_A      F     145          0.532
LGA    W   198_A      W     146          0.521
LGA    S   199_A      R     147          0.466
LGA    H   200_A      P     148          0.731
LGA    R   201_A      E     149          0.721
LGA    A   202_A      E     150          0.721
LGA    T   203_A      P     151          1.392
LGA    V   204_A      I     152          2.393
LGA    S   205_A      E     153          3.083
LGA    S   206_A      V     154          2.161
LGA    V   207_A      I     155          1.199
LGA    K   208_A      R     156          1.341
LGA    T   209_A      P     157          2.472
LGA    D   210_A      D     158          2.848
LGA    I   211_A      I     159          1.776
LGA    L   212_A      A     160          1.723
LGA    A   213_A      A     161          3.315
LGA    Y   214_A      L     162          3.839
LGA    L   215_A      V     163          3.824
LGA    K   216_A      R     164          4.613
LGA    Q   217_A      -       -           -
LGA    F   218_A      Q     165          1.604
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  188  174    5.0    154    1.87    35.71     81.559     7.827

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.159305 * X  +   0.981499 * Y  +   0.106219 * Z  +  18.568285
  Y_new =   0.941163 * X  +   0.118506 * Y  +   0.316495 * Z  +  34.155262
  Z_new =   0.298052 * X  +   0.150388 * Y  +  -0.942628 * Z  + -11.683348 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.983384   -0.158208  [ DEG:   170.9353     -9.0647 ]
  Theta =  -0.302651   -2.838941  [ DEG:   -17.3406   -162.6593 ]
  Phi   =   1.738471   -1.403122  [ DEG:    99.6070    -80.3930 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i3y_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i3y_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  188  174   5.0  154   1.87   35.71  81.559
REMARK  ---------------------------------------------------------- 
MOLECULE 2i3y_A
HEADER    OXIDOREDUCTASE                          21-AUG-06   2I3Y              
TITLE     CRYSTAL STRUCTURE OF HUMAN GLUTATHIONE PEROXIDASE 5                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: EPIDIDYMAL SECRETORY GLUTATHIONE PEROXIDASE;               
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: EPIDIDYMIS-SPECIFIC GLUTATHIONE PEROXIDASE-LIKE             
COMPND   5 PROTEIN, EGLP, GLUTATHIONE PEROXIDASE 5;                             
COMPND   6 EC: 1.11.1.9;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: GPX5;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC-BSA4 (PET DERIVATIVE)                
KEYWDS    THIOREDOXIN FOLD, EPIDIDYMAL ANDROGEN RELATED PROTEIN,                
KEYWDS   2 STRUCTURAL GENOMICS, STRUCTURAL GENOMICS CONSORTIUM, SGC             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.L.KAVANAGH,C.JOHANSSON,A.ROJKOVA,C.UMEANO,G.BUNKOCZI,               
AUTHOR   2 O.GILEADI,F.VON DELFT,J.WEIGELT,C.ARROWSMITH,M.SUNDSTROM,            
AUTHOR   3 A.EDWARDS,U.OPPERMANN,STRUCTURAL GENOMICS CONSORTIUM (SGC)           
REVDAT   1   12-SEP-06 2I3Y    0                                                
JRNL        AUTH   K.L.KAVANAGH,U.OPPERMANN                                     
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN GLUTATHIONE PEROXIDASE 5          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2I3Y A   28   220  UNP    O75715   GPX5_HUMAN      28    220             
SEQRES   1 A  215  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  215  GLY THR GLU ASN LEU TYR PHE GLN SER MET LYS MET ASP          
SEQRES   3 A  215  CYS HIS LYS ASP GLU LYS GLY THR ILE TYR ASP TYR GLU          
SEQRES   4 A  215  ALA ILE ALA LEU ASN LYS ASN GLU TYR VAL SER PHE LYS          
SEQRES   5 A  215  GLN TYR VAL GLY LYS HIS ILE LEU PHE VAL ASN VAL ALA          
SEQRES   6 A  215  THR TYR CYS GLY LEU THR ALA GLN TYR PRO GLU LEU ASN          
SEQRES   7 A  215  ALA LEU GLN GLU GLU LEU LYS PRO TYR GLY LEU VAL VAL          
SEQRES   8 A  215  LEU GLY PHE PRO CYS ASN GLN PHE GLY LYS GLN GLU PRO          
SEQRES   9 A  215  GLY ASP ASN LYS GLU ILE LEU PRO GLY LEU LYS TYR VAL          
SEQRES  10 A  215  ARG PRO GLY GLY GLY PHE VAL PRO SER PHE GLN LEU PHE          
SEQRES  11 A  215  GLU LYS GLY ASP VAL ASN GLY GLU LYS GLU GLN LYS VAL          
SEQRES  12 A  215  PHE SER PHE LEU LYS HIS SER CYS PRO HIS PRO SER GLU          
SEQRES  13 A  215  ILE LEU GLY THR PHE LYS SER ILE SER TRP ASP PRO VAL          
SEQRES  14 A  215  LYS VAL HIS ASP ILE ARG TRP ASN PHE GLU LYS PHE LEU          
SEQRES  15 A  215  VAL GLY PRO ASP GLY ILE PRO VAL MET ARG TRP SER HIS          
SEQRES  16 A  215  ARG ALA THR VAL SER SER VAL LYS THR ASP ILE LEU ALA          
SEQRES  17 A  215  TYR LEU LYS GLN PHE LYS THR                                  
HET    EDO    201       4                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   2  EDO    C2 H6 O2                                                     
FORMUL   3  HOH   *99(H2 O)                                                     
CRYST1  104.544  104.544   71.663  90.00  90.00 120.00 P 62 2 2     12          
ATOM      1  N   ASP A  31      54.111  99.915 -20.677  1.00 57.48           N  
ATOM      2  CA  ASP A  31      55.455 100.260 -20.110  1.00 58.04           C  
ATOM      3  C   ASP A  31      55.548 100.295 -18.559  1.00 54.57           C  
ATOM      4  O   ASP A  31      56.565  99.888 -17.957  1.00 37.16           O  
ATOM      5  CB  ASP A  31      55.825 101.655 -20.621  1.00 66.35           C  
ATOM      6  CG  ASP A  31      57.310 101.899 -20.615  1.00 68.98           C  
ATOM      7  OD1 ASP A  31      57.905 101.864 -21.720  1.00 57.06           O  
ATOM      8  OD2 ASP A  31      57.869 102.101 -19.512  1.00 81.62           O  
ATOM      9  N   CYS A  32      54.510 100.889 -17.957  1.00 49.65           N  
ATOM     10  CA  CYS A  32      54.430 101.192 -16.544  1.00 47.24           C  
ATOM     11  C   CYS A  32      52.934 101.134 -16.161  1.00 51.31           C  
ATOM     12  O   CYS A  32      52.082 101.666 -16.897  1.00 49.82           O  
ATOM     13  CB  CYS A  32      54.998 102.601 -16.262  1.00 51.03           C  
ATOM     14  SG  CYS A  32      54.685 103.305 -14.549  1.00 53.30           S  
ATOM     15  N   HIS A  33      52.605 100.449 -15.066  1.00 50.68           N  
ATOM     16  CA  HIS A  33      51.262 100.511 -14.518  1.00 56.18           C  
ATOM     17  C   HIS A  33      51.286 101.265 -13.174  1.00 56.48           C  
ATOM     18  O   HIS A  33      52.078 100.928 -12.282  1.00 48.73           O  
ATOM     19  CB  HIS A  33      50.636  99.118 -14.361  1.00 59.28           C  
ATOM     20  CG  HIS A  33      49.213  99.155 -13.875  1.00 67.77           C  
ATOM     21  ND1 HIS A  33      48.142  99.389 -14.715  1.00 74.94           N  
ATOM     22  CD2 HIS A  33      48.692  99.027 -12.628  1.00 73.31           C  
ATOM     23  CE1 HIS A  33      47.023  99.389 -14.007  1.00 80.15           C  
ATOM     24  NE2 HIS A  33      47.327  99.171 -12.739  1.00 75.52           N  
ATOM     25  N   LYS A  34      50.421 102.290 -13.071  1.00 55.88           N  
ATOM     26  CA  LYS A  34      50.172 103.042 -11.832  1.00 58.26           C  
ATOM     27  C   LYS A  34      48.915 102.459 -11.185  1.00 61.88           C  
ATOM     28  O   LYS A  34      47.842 102.474 -11.794  1.00 62.85           O  
ATOM     29  CB  LYS A  34      49.963 104.550 -12.131  1.00 54.73           C  
ATOM     30  N   ASP A  35      49.045 101.922  -9.973  1.00 65.89           N  
ATOM     31  CA  ASP A  35      47.876 101.403  -9.247  1.00 70.41           C  
ATOM     32  C   ASP A  35      47.047 102.545  -8.621  1.00 71.70           C  
ATOM     33  O   ASP A  35      47.536 103.243  -7.736  1.00 71.24           O  
ATOM     34  CB  ASP A  35      48.308 100.415  -8.157  1.00 68.01           C  
ATOM     35  CG  ASP A  35      47.137  99.603  -7.604  1.00 72.63           C  
ATOM     36  OD1 ASP A  35      46.466  98.876  -8.389  1.00 64.40           O  
ATOM     37  OD2 ASP A  35      46.902  99.689  -6.373  1.00 68.80           O  
ATOM     38  N   GLU A  36      45.802 102.713  -9.084  1.00 73.35           N  
ATOM     39  CA  GLU A  36      44.858 103.716  -8.531  1.00 72.49           C  
ATOM     40  C   GLU A  36      44.070 103.103  -7.359  1.00 70.90           C  
ATOM     41  O   GLU A  36      43.407 102.071  -7.531  1.00 69.77           O  
ATOM     42  CB  GLU A  36      43.896 104.227  -9.629  1.00 72.82           C  
ATOM     43  N   LYS A  37      44.158 103.735  -6.182  1.00 69.04           N  
ATOM     44  CA  LYS A  37      43.584 103.192  -4.929  1.00 69.67           C  
ATOM     45  C   LYS A  37      42.246 103.860  -4.506  1.00 68.26           C  
ATOM     46  O   LYS A  37      42.059 105.078  -4.667  1.00 70.03           O  
ATOM     47  CB  LYS A  37      44.610 103.299  -3.788  1.00 69.87           C  
ATOM     48  N   GLY A  38      41.334 103.052  -3.955  1.00 65.13           N  
ATOM     49  CA  GLY A  38      39.995 103.514  -3.543  1.00 60.27           C  
ATOM     50  C   GLY A  38      39.890 104.163  -2.162  1.00 53.07           C  
ATOM     51  O   GLY A  38      40.470 103.696  -1.191  1.00 46.56           O  
ATOM     52  N   THR A  39      39.137 105.257  -2.080  1.00 49.48           N  
ATOM     53  CA  THR A  39      38.868 105.928  -0.805  1.00 46.14           C  
ATOM     54  C   THR A  39      37.379 106.331  -0.693  1.00 46.36           C  
ATOM     55  O   THR A  39      36.607 106.228  -1.666  1.00 43.44           O  
ATOM     56  CB  THR A  39      39.696 107.209  -0.653  1.00 44.96           C  
ATOM     57  OG1 THR A  39      39.176 108.203  -1.548  1.00 43.94           O  
ATOM     58  CG2 THR A  39      41.182 106.944  -0.928  1.00 42.48           C  
ATOM     59  N   ILE A  40      37.007 106.833   0.485  1.00 44.99           N  
ATOM     60  CA  ILE A  40      35.662 107.352   0.721  1.00 45.97           C  
ATOM     61  C   ILE A  40      35.299 108.539  -0.195  1.00 46.66           C  
ATOM     62  O   ILE A  40      34.127 108.736  -0.542  1.00 46.58           O  
ATOM     63  CB  ILE A  40      35.479 107.735   2.227  1.00 47.98           C  
ATOM     64  CG1 ILE A  40      34.019 107.587   2.635  1.00 49.59           C  
ATOM     65  CG2 ILE A  40      35.991 109.126   2.516  1.00 45.59           C  
ATOM     66  CD1 ILE A  40      33.522 106.127   2.525  1.00 38.74           C  
ATOM     67  N   TYR A  41      36.313 109.293  -0.614  1.00 47.08           N  
ATOM     68  CA  TYR A  41      36.118 110.459  -1.473  1.00 46.81           C  
ATOM     69  C   TYR A  41      35.666 110.100  -2.898  1.00 48.73           C  
ATOM     70  O   TYR A  41      35.310 111.005  -3.671  1.00 48.17           O  
ATOM     71  CB  TYR A  41      37.399 111.317  -1.514  1.00 47.04           C  
ATOM     72  CG  TYR A  41      38.020 111.544  -0.142  1.00 48.11           C  
ATOM     73  CD1 TYR A  41      37.229 111.883   0.968  1.00 40.48           C  
ATOM     74  CD2 TYR A  41      39.391 111.386   0.056  1.00 43.95           C  
ATOM     75  CE1 TYR A  41      37.796 112.084   2.221  1.00 47.19           C  
ATOM     76  CE2 TYR A  41      39.966 111.578   1.310  1.00 43.72           C  
ATOM     77  CZ  TYR A  41      39.167 111.923   2.382  1.00 42.40           C  
ATOM     78  OH  TYR A  41      39.751 112.115   3.604  1.00 49.55           O  
ATOM     79  N   ASP A  42      35.653 108.800  -3.232  1.00 48.47           N  
ATOM     80  CA  ASP A  42      35.195 108.330  -4.545  1.00 46.91           C  
ATOM     81  C   ASP A  42      33.670 108.285  -4.603  1.00 47.40           C  
ATOM     82  O   ASP A  42      33.113 108.048  -5.667  1.00 46.94           O  
ATOM     83  CB  ASP A  42      35.710 106.905  -4.862  1.00 45.93           C  
ATOM     84  CG  ASP A  42      37.233 106.827  -5.126  1.00 51.92           C  
ATOM     85  OD1 ASP A  42      37.855 107.790  -5.621  1.00 52.51           O  
ATOM     86  OD2 ASP A  42      37.811 105.753  -4.854  1.00 57.53           O  
ATOM     87  N   TYR A  43      33.000 108.470  -3.465  1.00 46.71           N  
ATOM     88  CA  TYR A  43      31.537 108.345  -3.387  1.00 45.23           C  
ATOM     89  C   TYR A  43      30.815 109.626  -2.993  1.00 45.31           C  
ATOM     90  O   TYR A  43      31.425 110.618  -2.569  1.00 44.70           O  
ATOM     91  CB  TYR A  43      31.143 107.217  -2.433  1.00 42.37           C  
ATOM     92  CG  TYR A  43      31.897 105.967  -2.731  1.00 47.78           C  
ATOM     93  CD1 TYR A  43      31.408 105.027  -3.638  1.00 40.62           C  
ATOM     94  CD2 TYR A  43      33.143 105.752  -2.158  1.00 48.67           C  
ATOM     95  CE1 TYR A  43      32.147 103.876  -3.928  1.00 54.06           C  
ATOM     96  CE2 TYR A  43      33.883 104.633  -2.450  1.00 51.27           C  
ATOM     97  CZ  TYR A  43      33.391 103.697  -3.324  1.00 43.27           C  
ATOM     98  OH  TYR A  43      34.176 102.593  -3.587  1.00 46.71           O  
ATOM     99  N   GLU A  44      29.500 109.572  -3.167  1.00 44.22           N  
ATOM    100  CA  GLU A  44      28.607 110.683  -2.946  1.00 47.53           C  
ATOM    101  C   GLU A  44      27.185 110.170  -2.669  1.00 49.45           C  
ATOM    102  O   GLU A  44      26.839 109.001  -2.976  1.00 50.31           O  
ATOM    103  CB  GLU A  44      28.608 111.562  -4.188  1.00 51.17           C  
ATOM    104  CG  GLU A  44      28.393 110.771  -5.490  1.00 58.31           C  
ATOM    105  CD  GLU A  44      28.678 111.564  -6.749  1.00 55.69           C  
ATOM    106  OE1 GLU A  44      28.249 111.087  -7.824  1.00 77.43           O  
ATOM    107  OE2 GLU A  44      29.319 112.648  -6.680  1.00 74.42           O  
ATOM    108  N   ALA A  45      26.381 111.041  -2.066  1.00 44.66           N  
ATOM    109  CA  ALA A  45      25.002 110.747  -1.747  1.00 44.97           C  
ATOM    110  C   ALA A  45      24.164 112.047  -1.670  1.00 48.25           C  
ATOM    111  O   ALA A  45      24.713 113.165  -1.584  1.00 46.11           O  
ATOM    112  CB  ALA A  45      24.907 109.944  -0.464  1.00 45.20           C  
ATOM    113  N   ILE A  46      22.841 111.882  -1.739  1.00 43.70           N  
ATOM    114  CA  ILE A  46      21.905 112.995  -1.760  1.00 44.20           C  
ATOM    115  C   ILE A  46      21.427 113.262  -0.354  1.00 42.61           C  
ATOM    116  O   ILE A  46      20.903 112.362   0.318  1.00 44.61           O  
ATOM    117  CB  ILE A  46      20.705 112.718  -2.682  1.00 41.66           C  
ATOM    118  CG1 ILE A  46      21.199 112.332  -4.074  1.00 50.20           C  
ATOM    119  CG2 ILE A  46      19.763 113.973  -2.814  1.00 41.60           C  
ATOM    120  CD1 ILE A  46      20.071 112.200  -5.096  1.00 46.37           C  
ATOM    121  N   ALA A  47      21.647 114.490   0.096  1.00 43.70           N  
ATOM    122  CA  ALA A  47      21.215 114.924   1.408  1.00 43.77           C  
ATOM    123  C   ALA A  47      19.705 114.902   1.439  1.00 47.63           C  
ATOM    124  O   ALA A  47      19.026 115.128   0.426  1.00 46.45           O  
ATOM    125  CB  ALA A  47      21.731 116.326   1.724  1.00 44.83           C  
ATOM    126  N   LEU A  48      19.197 114.629   2.625  1.00 51.17           N  
ATOM    127  CA  LEU A  48      17.786 114.456   2.855  1.00 55.66           C  
ATOM    128  C   LEU A  48      17.074 115.813   2.838  1.00 63.45           C  
ATOM    129  O   LEU A  48      15.979 115.939   2.280  1.00 70.97           O  
ATOM    130  CB  LEU A  48      17.615 113.743   4.202  1.00 54.65           C  
ATOM    131  CG  LEU A  48      16.260 113.186   4.585  1.00 57.51           C  
ATOM    132  CD1 LEU A  48      15.801 112.128   3.576  1.00 52.20           C  
ATOM    133  CD2 LEU A  48      16.326 112.658   5.989  1.00 49.27           C  
ATOM    134  N   ASN A  49      17.741 116.828   3.389  1.00 67.91           N  
ATOM    135  CA  ASN A  49      17.118 118.108   3.784  1.00 74.58           C  
ATOM    136  C   ASN A  49      17.299 119.229   2.742  1.00 77.30           C  
ATOM    137  O   ASN A  49      16.450 120.124   2.623  1.00 79.68           O  
ATOM    138  CB  ASN A  49      17.658 118.539   5.154  1.00 75.54           C  
ATOM    139  CG  ASN A  49      19.156 118.312   5.284  1.00 79.12           C  
ATOM    140  OD1 ASN A  49      19.958 119.098   4.770  1.00 90.62           O  
ATOM    141  ND2 ASN A  49      19.538 117.218   5.946  1.00 79.99           N  
ATOM    142  N   LYS A  50      18.413 119.191   2.013  1.00 79.55           N  
ATOM    143  CA  LYS A  50      18.475 119.794   0.685  1.00 81.61           C  
ATOM    144  C   LYS A  50      17.914 118.742  -0.290  1.00 81.58           C  
ATOM    145  O   LYS A  50      17.445 117.684   0.130  1.00 80.53           O  
ATOM    146  CB  LYS A  50      19.912 120.171   0.318  1.00 81.71           C  
ATOM    147  N   ASN A  51      17.932 119.033  -1.583  1.00 81.32           N  
ATOM    148  CA  ASN A  51      17.720 117.993  -2.583  1.00 79.91           C  
ATOM    149  C   ASN A  51      18.985 117.913  -3.442  1.00 79.31           C  
ATOM    150  O   ASN A  51      18.897 117.824  -4.674  1.00 80.84           O  
ATOM    151  CB  ASN A  51      16.477 118.292  -3.429  1.00 79.18           C  
ATOM    152  N   GLU A  52      20.154 117.938  -2.782  1.00 73.85           N  
ATOM    153  CA  GLU A  52      21.437 118.155  -3.471  1.00 70.38           C  
ATOM    154  C   GLU A  52      22.490 117.117  -3.115  1.00 65.91           C  
ATOM    155  O   GLU A  52      22.574 116.683  -1.967  1.00 66.62           O  
ATOM    156  CB  GLU A  52      21.976 119.554  -3.157  1.00 71.28           C  
ATOM    157  N   TYR A  53      23.291 116.728  -4.109  1.00 61.21           N  
ATOM    158  CA  TYR A  53      24.350 115.732  -3.914  1.00 61.34           C  
ATOM    159  C   TYR A  53      25.520 116.310  -3.114  1.00 59.15           C  
ATOM    160  O   TYR A  53      25.901 117.479  -3.276  1.00 55.13           O  
ATOM    161  CB  TYR A  53      24.840 115.118  -5.249  1.00 62.47           C  
ATOM    162  CG  TYR A  53      24.412 113.668  -5.464  1.00 60.94           C  
ATOM    163  N   VAL A  54      26.060 115.466  -2.238  1.00 54.88           N  
ATOM    164  CA  VAL A  54      27.165 115.793  -1.359  1.00 53.62           C  
ATOM    165  C   VAL A  54      28.293 114.810  -1.627  1.00 53.29           C  
ATOM    166  O   VAL A  54      28.150 113.619  -1.360  1.00 51.34           O  
ATOM    167  CB  VAL A  54      26.723 115.665   0.107  1.00 54.07           C  
ATOM    168  CG1 VAL A  54      27.922 115.823   1.066  1.00 55.64           C  
ATOM    169  CG2 VAL A  54      25.592 116.676   0.409  1.00 46.69           C  
ATOM    170  N   SER A  55      29.401 115.285  -2.186  1.00 52.64           N  
ATOM    171  CA  SER A  55      30.564 114.411  -2.350  1.00 55.28           C  
ATOM    172  C   SER A  55      31.297 114.277  -1.032  1.00 53.39           C  
ATOM    173  O   SER A  55      31.459 115.255  -0.300  1.00 54.98           O  
ATOM    174  CB  SER A  55      31.547 114.927  -3.402  1.00 55.08           C  
ATOM    175  OG  SER A  55      32.670 114.063  -3.421  1.00 56.47           O  
ATOM    176  N   PHE A  56      31.773 113.074  -0.742  1.00 51.68           N  
ATOM    177  CA  PHE A  56      32.466 112.849   0.502  1.00 51.18           C  
ATOM    178  C   PHE A  56      33.850 113.504   0.528  1.00 52.60           C  
ATOM    179  O   PHE A  56      34.481 113.542   1.584  1.00 51.07           O  
ATOM    180  CB  PHE A  56      32.495 111.353   0.830  1.00 50.95           C  
ATOM    181  CG  PHE A  56      31.100 110.742   0.975  1.00 55.38           C  
ATOM    182  CD1 PHE A  56      30.089 111.419   1.646  1.00 53.37           C  
ATOM    183  CD2 PHE A  56      30.808 109.499   0.436  1.00 51.41           C  
ATOM    184  CE1 PHE A  56      28.823 110.868   1.775  1.00 54.93           C  
ATOM    185  CE2 PHE A  56      29.536 108.949   0.558  1.00 46.17           C  
ATOM    186  CZ  PHE A  56      28.552 109.638   1.241  1.00 46.33           C  
ATOM    187  N   LYS A  57      34.289 114.039  -0.620  1.00 53.67           N  
ATOM    188  CA  LYS A  57      35.450 114.933  -0.708  1.00 56.72           C  
ATOM    189  C   LYS A  57      35.310 116.143   0.214  1.00 55.55           C  
ATOM    190  O   LYS A  57      36.317 116.646   0.718  1.00 53.29           O  
ATOM    191  CB  LYS A  57      35.641 115.482  -2.134  1.00 58.36           C  
ATOM    192  CG  LYS A  57      35.917 114.468  -3.242  1.00 62.28           C  
ATOM    193  CD  LYS A  57      35.789 115.118  -4.638  1.00 59.49           C  
ATOM    194  CE  LYS A  57      35.594 114.065  -5.729  1.00 66.23           C  
ATOM    195  N   GLN A  58      34.074 116.629   0.397  1.00 52.79           N  
ATOM    196  CA  GLN A  58      33.770 117.667   1.398  1.00 52.10           C  
ATOM    197  C   GLN A  58      34.410 117.369   2.751  1.00 50.76           C  
ATOM    198  O   GLN A  58      34.792 118.282   3.499  1.00 51.23           O  
ATOM    199  CB  GLN A  58      32.265 117.775   1.639  1.00 52.78           C  
ATOM    200  CG  GLN A  58      31.472 118.475   0.558  1.00 57.56           C  
ATOM    201  CD  GLN A  58      30.065 118.841   1.019  1.00 56.86           C  
ATOM    202  OE1 GLN A  58      29.740 118.715   2.203  1.00 65.19           O  
ATOM    203  NE2 GLN A  58      29.227 119.305   0.085  1.00 50.63           N  
ATOM    204  N   TYR A  59      34.530 116.079   3.053  1.00 49.66           N  
ATOM    205  CA  TYR A  59      34.934 115.616   4.368  1.00 49.18           C  
ATOM    206  C   TYR A  59      36.420 115.213   4.409  1.00 46.92           C  
ATOM    207  O   TYR A  59      36.856 114.512   5.303  1.00 44.90           O  
ATOM    208  CB  TYR A  59      33.982 114.492   4.795  1.00 50.60           C  
ATOM    209  CG  TYR A  59      32.521 114.931   4.893  1.00 50.57           C  
ATOM    210  CD1 TYR A  59      31.509 114.266   4.204  1.00 50.88           C  
ATOM    211  CD2 TYR A  59      32.163 116.020   5.677  1.00 56.38           C  
ATOM    212  CE1 TYR A  59      30.167 114.682   4.302  1.00 50.31           C  
ATOM    213  CE2 TYR A  59      30.832 116.443   5.782  1.00 56.94           C  
ATOM    214  CZ  TYR A  59      29.835 115.777   5.104  1.00 55.35           C  
ATOM    215  OH  TYR A  59      28.524 116.226   5.246  1.00 53.25           O  
ATOM    216  N   VAL A  60      37.197 115.711   3.451  1.00 48.06           N  
ATOM    217  CA  VAL A  60      38.660 115.532   3.428  1.00 48.83           C  
ATOM    218  C   VAL A  60      39.328 116.040   4.721  1.00 47.67           C  
ATOM    219  O   VAL A  60      38.976 117.098   5.244  1.00 47.31           O  
ATOM    220  CB  VAL A  60      39.271 116.209   2.181  1.00 48.58           C  
ATOM    221  CG1 VAL A  60      39.096 117.746   2.230  1.00 55.04           C  
ATOM    222  CG2 VAL A  60      40.740 115.833   2.020  1.00 54.14           C  
ATOM    223  N   GLY A  61      40.257 115.252   5.260  1.00 49.88           N  
ATOM    224  CA  GLY A  61      40.920 115.572   6.537  1.00 48.55           C  
ATOM    225  C   GLY A  61      40.095 115.360   7.807  1.00 46.56           C  
ATOM    226  O   GLY A  61      40.562 115.660   8.906  1.00 45.95           O  
ATOM    227  N   LYS A  62      38.870 114.855   7.671  1.00 46.32           N  
ATOM    228  CA  LYS A  62      37.962 114.680   8.804  1.00 44.82           C  
ATOM    229  C   LYS A  62      37.792 113.196   9.092  1.00 44.67           C  
ATOM    230  O   LYS A  62      37.934 112.357   8.195  1.00 46.26           O  
ATOM    231  CB  LYS A  62      36.580 115.277   8.496  1.00 45.90           C  
ATOM    232  CG  LYS A  62      36.538 116.783   8.202  1.00 50.23           C  
ATOM    233  CD  LYS A  62      36.790 117.615   9.455  1.00 50.11           C  
ATOM    234  CE  LYS A  62      36.804 119.103   9.187  1.00 49.39           C  
ATOM    235  NZ  LYS A  62      37.750 119.779  10.146  1.00 63.08           N  
ATOM    236  N   HIS A  63      37.468 112.888  10.349  1.00 45.13           N  
ATOM    237  CA  HIS A  63      37.115 111.527  10.772  1.00 44.15           C  
ATOM    238  C   HIS A  63      35.615 111.374  10.610  1.00 45.36           C  
ATOM    239  O   HIS A  63      34.849 112.145  11.192  1.00 44.64           O  
ATOM    240  CB  HIS A  63      37.488 111.290  12.237  1.00 43.48           C  
ATOM    241  CG  HIS A  63      38.823 111.836  12.606  1.00 41.47           C  
ATOM    242  ND1 HIS A  63      39.990 111.157  12.359  1.00 41.32           N  
ATOM    243  CD2 HIS A  63      39.175 113.017  13.157  1.00 45.71           C  
ATOM    244  CE1 HIS A  63      41.008 111.893  12.755  1.00 47.18           C  
ATOM    245  NE2 HIS A  63      40.541 113.032  13.237  1.00 44.55           N  
ATOM    246  N   ILE A  64      35.185 110.395   9.817  1.00 46.65           N  
ATOM    247  CA  ILE A  64      33.778 110.313   9.441  1.00 42.38           C  
ATOM    248  C   ILE A  64      33.150 109.123  10.129  1.00 43.44           C  
ATOM    249  O   ILE A  64      33.666 108.033  10.023  1.00 43.34           O  
ATOM    250  CB  ILE A  64      33.586 110.186   7.894  1.00 45.39           C  
ATOM    251  CG1 ILE A  64      34.502 111.165   7.135  1.00 41.80           C  
ATOM    252  CG2 ILE A  64      32.085 110.377   7.532  1.00 46.37           C  
ATOM    253  CD1 ILE A  64      34.514 110.963   5.622  1.00 39.96           C  
ATOM    254  N   LEU A  65      32.061 109.344  10.859  1.00 47.08           N  
ATOM    255  CA  LEU A  65      31.282 108.244  11.430  1.00 45.38           C  
ATOM    256  C   LEU A  65      30.008 108.006  10.613  1.00 43.89           C  
ATOM    257  O   LEU A  65      29.103 108.829  10.633  1.00 46.41           O  
ATOM    258  CB  LEU A  65      30.944 108.487  12.921  1.00 43.87           C  
ATOM    259  CG  LEU A  65      30.207 107.309  13.614  1.00 47.55           C  
ATOM    260  CD1 LEU A  65      31.143 106.096  13.796  1.00 40.49           C  
ATOM    261  CD2 LEU A  65      29.661 107.752  14.941  1.00 45.07           C  
ATOM    262  N   PHE A  66      29.953 106.865   9.909  1.00 43.83           N  
ATOM    263  CA  PHE A  66      28.787 106.471   9.103  1.00 43.33           C  
ATOM    264  C   PHE A  66      27.905 105.604   9.968  1.00 46.08           C  
ATOM    265  O   PHE A  66      28.387 104.639  10.551  1.00 44.80           O  
ATOM    266  CB  PHE A  66      29.197 105.629   7.903  1.00 45.55           C  
ATOM    267  CG  PHE A  66      29.812 106.398   6.794  1.00 39.41           C  
ATOM    268  CD1 PHE A  66      29.107 106.621   5.604  1.00 43.08           C  
ATOM    269  CD2 PHE A  66      31.106 106.870   6.901  1.00 44.13           C  
ATOM    270  CE1 PHE A  66      29.691 107.321   4.551  1.00 41.32           C  
ATOM    271  CE2 PHE A  66      31.694 107.572   5.851  1.00 42.65           C  
ATOM    272  CZ  PHE A  66      30.967 107.802   4.679  1.00 42.60           C  
ATOM    273  N   VAL A  67      26.621 105.951  10.039  1.00 46.45           N  
ATOM    274  CA  VAL A  67      25.639 105.159  10.770  1.00 45.43           C  
ATOM    275  C   VAL A  67      24.461 104.915   9.829  1.00 45.02           C  
ATOM    276  O   VAL A  67      23.940 105.879   9.186  1.00 43.56           O  
ATOM    277  CB  VAL A  67      25.151 105.903  12.057  1.00 41.89           C  
ATOM    278  CG1 VAL A  67      24.273 104.981  12.945  1.00 38.77           C  
ATOM    279  CG2 VAL A  67      26.346 106.479  12.846  1.00 46.55           C  
ATOM    280  N   ASN A  68      24.034 103.649   9.723  1.00 44.10           N  
ATOM    281  CA  ASN A  68      22.755 103.355   9.061  1.00 40.69           C  
ATOM    282  C   ASN A  68      21.632 103.505  10.100  1.00 41.58           C  
ATOM    283  O   ASN A  68      21.738 102.976  11.229  1.00 44.72           O  
ATOM    284  CB  ASN A  68      22.729 102.004   8.322  1.00 38.87           C  
ATOM    285  CG  ASN A  68      22.964 100.823   9.221  1.00 49.05           C  
ATOM    286  OD1 ASN A  68      24.024 100.698   9.801  1.00 44.80           O  
ATOM    287  ND2 ASN A  68      21.980  99.942   9.330  1.00 41.93           N  
ATOM    288  N   VAL A  69      20.607 104.277   9.773  1.00 43.53           N  
ATOM    289  CA  VAL A  69      19.591 104.654  10.751  1.00 40.51           C  
ATOM    290  C   VAL A  69      18.165 104.173  10.367  1.00 46.14           C  
ATOM    291  O   VAL A  69      17.909 103.714   9.240  1.00 44.70           O  
ATOM    292  CB  VAL A  69      19.633 106.196  11.008  1.00 43.05           C  
ATOM    293  CG1 VAL A  69      21.081 106.650  11.472  1.00 37.10           C  
ATOM    294  CG2 VAL A  69      19.148 106.998   9.779  1.00 35.44           C  
ATOM    295  N   ALA A  70      17.268 104.241  11.343  1.00 44.91           N  
ATOM    296  CA  ALA A  70      15.851 103.870  11.188  1.00 44.15           C  
ATOM    297  C   ALA A  70      15.071 104.568  12.297  1.00 40.50           C  
ATOM    298  O   ALA A  70      15.622 104.884  13.367  1.00 41.53           O  
ATOM    299  CB  ALA A  70      15.635 102.353  11.279  1.00 39.02           C  
ATOM    300  N   THR A  71      13.771 104.748  12.063  1.00 43.04           N  
ATOM    301  CA  THR A  71      12.861 105.472  12.986  1.00 43.32           C  
ATOM    302  C   THR A  71      12.121 104.577  13.992  1.00 43.49           C  
ATOM    303  O   THR A  71      11.730 105.034  15.071  1.00 41.45           O  
ATOM    304  CB  THR A  71      11.834 106.300  12.181  1.00 48.17           C  
ATOM    305  OG1 THR A  71      12.529 107.220  11.312  1.00 44.81           O  
ATOM    306  CG2 THR A  71      10.855 107.088  13.130  1.00 40.79           C  
ATOM    307  N   TYR A  72      11.937 103.303  13.656  1.00 42.13           N  
ATOM    308  CA  TYR A  72      11.052 102.452  14.443  1.00 41.06           C  
ATOM    309  C   TYR A  72      11.797 101.249  14.960  1.00 40.48           C  
ATOM    310  O   TYR A  72      11.301 100.142  14.928  1.00 40.31           O  
ATOM    311  CB  TYR A  72       9.817 102.042  13.630  1.00 41.46           C  
ATOM    312  CG  TYR A  72       8.868 103.192  13.345  1.00 42.32           C  
ATOM    313  CD1 TYR A  72       7.971 103.632  14.314  1.00 36.10           C  
ATOM    314  CD2 TYR A  72       8.892 103.870  12.113  1.00 33.52           C  
ATOM    315  CE1 TYR A  72       7.119 104.684  14.056  1.00 39.34           C  
ATOM    316  CE2 TYR A  72       8.058 104.893  11.864  1.00 37.52           C  
ATOM    317  CZ  TYR A  72       7.151 105.301  12.834  1.00 38.77           C  
ATOM    318  OH  TYR A  72       6.252 106.333  12.573  1.00 39.57           O  
ATOM    319  N   CYS A  73      13.009 101.495  15.436  1.00 42.05           N  
ATOM    320  CA  CYS A  73      13.879 100.475  16.007  1.00 41.16           C  
ATOM    321  C   CYS A  73      13.993 100.816  17.475  1.00 43.08           C  
ATOM    322  O   CYS A  73      13.944 101.985  17.808  1.00 46.51           O  
ATOM    323  CB  CYS A  73      15.263 100.598  15.370  1.00 44.36           C  
ATOM    324  SG  CYS A  73      16.432  99.297  15.831  1.00 48.99           S  
ATOM    325  N   GLY A  74      14.160  99.821  18.349  1.00 43.82           N  
ATOM    326  CA  GLY A  74      14.571 100.060  19.736  1.00 41.90           C  
ATOM    327  C   GLY A  74      15.794 100.959  19.836  1.00 43.72           C  
ATOM    328  O   GLY A  74      15.879 101.822  20.715  1.00 44.22           O  
ATOM    329  N   LEU A  75      16.715 100.824  18.888  1.00 41.13           N  
ATOM    330  CA  LEU A  75      17.944 101.621  18.902  1.00 39.13           C  
ATOM    331  C   LEU A  75      17.734 103.096  18.513  1.00 41.67           C  
ATOM    332  O   LEU A  75      18.636 103.915  18.625  1.00 41.36           O  
ATOM    333  CB  LEU A  75      18.965 100.975  17.998  1.00 44.28           C  
ATOM    334  CG  LEU A  75      19.504  99.657  18.514  1.00 41.92           C  
ATOM    335  CD1 LEU A  75      20.225  98.889  17.388  1.00 48.34           C  
ATOM    336  CD2 LEU A  75      20.423  99.939  19.671  1.00 40.04           C  
ATOM    337  N   THR A  76      16.555 103.435  18.021  1.00 40.23           N  
ATOM    338  CA  THR A  76      16.252 104.816  17.579  1.00 39.09           C  
ATOM    339  C   THR A  76      16.417 105.795  18.740  1.00 43.13           C  
ATOM    340  O   THR A  76      16.759 106.966  18.527  1.00 39.83           O  
ATOM    341  CB  THR A  76      14.834 104.878  16.945  1.00 43.95           C  
ATOM    342  OG1 THR A  76      14.842 104.030  15.790  1.00 43.43           O  
ATOM    343  CG2 THR A  76      14.424 106.317  16.517  1.00 34.77           C  
ATOM    344  N   ALA A  77      16.202 105.275  19.959  1.00 41.92           N  
ATOM    345  CA  ALA A  77      16.467 105.968  21.229  1.00 41.97           C  
ATOM    346  C   ALA A  77      17.849 106.569  21.353  1.00 40.31           C  
ATOM    347  O   ALA A  77      18.033 107.464  22.181  1.00 37.59           O  
ATOM    348  CB  ALA A  77      16.264 104.994  22.405  1.00 40.10           C  
ATOM    349  N   GLN A  78      18.817 106.079  20.569  1.00 37.06           N  
ATOM    350  CA  GLN A  78      20.208 106.562  20.630  1.00 41.38           C  
ATOM    351  C   GLN A  78      20.502 107.794  19.795  1.00 40.32           C  
ATOM    352  O   GLN A  78      21.597 108.323  19.833  1.00 43.60           O  
ATOM    353  CB  GLN A  78      21.182 105.446  20.241  1.00 40.05           C  
ATOM    354  CG  GLN A  78      21.522 105.319  18.773  1.00 45.43           C  
ATOM    355  CD  GLN A  78      22.474 104.150  18.513  1.00 43.77           C  
ATOM    356  OE1 GLN A  78      23.341 104.216  17.635  1.00 43.62           O  
ATOM    357  NE2 GLN A  78      22.346 103.102  19.310  1.00 42.00           N  
ATOM    358  N   TYR A  79      19.524 108.249  19.035  1.00 38.87           N  
ATOM    359  CA  TYR A  79      19.661 109.463  18.245  1.00 39.24           C  
ATOM    360  C   TYR A  79      20.189 110.692  19.017  1.00 41.49           C  
ATOM    361  O   TYR A  79      21.069 111.397  18.527  1.00 40.39           O  
ATOM    362  CB  TYR A  79      18.295 109.787  17.615  1.00 43.13           C  
ATOM    363  CG  TYR A  79      18.192 109.511  16.131  1.00 40.78           C  
ATOM    364  CD1 TYR A  79      18.905 110.279  15.204  1.00 45.98           C  
ATOM    365  CD2 TYR A  79      17.341 108.515  15.638  1.00 45.13           C  
ATOM    366  CE1 TYR A  79      18.799 110.030  13.834  1.00 41.18           C  
ATOM    367  CE2 TYR A  79      17.228 108.269  14.270  1.00 42.95           C  
ATOM    368  CZ  TYR A  79      17.949 109.036  13.377  1.00 46.20           C  
ATOM    369  OH  TYR A  79      17.809 108.823  12.017  1.00 46.02           O  
ATOM    370  N   PRO A  80      19.629 110.973  20.206  1.00 38.98           N  
ATOM    371  CA  PRO A  80      20.168 112.059  21.021  1.00 41.89           C  
ATOM    372  C   PRO A  80      21.582 111.803  21.533  1.00 39.46           C  
ATOM    373  O   PRO A  80      22.324 112.757  21.824  1.00 40.45           O  
ATOM    374  CB  PRO A  80      19.161 112.194  22.171  1.00 39.47           C  
ATOM    375  CG  PRO A  80      18.401 110.971  22.180  1.00 44.55           C  
ATOM    376  CD  PRO A  80      18.444 110.357  20.825  1.00 41.94           C  
ATOM    377  N   GLU A  81      21.959 110.536  21.654  1.00 35.56           N  
ATOM    378  CA  GLU A  81      23.316 110.184  22.006  1.00 42.59           C  
ATOM    379  C   GLU A  81      24.250 110.446  20.838  1.00 41.76           C  
ATOM    380  O   GLU A  81      25.410 110.813  21.042  1.00 42.67           O  
ATOM    381  CB  GLU A  81      23.400 108.737  22.484  1.00 46.62           C  
ATOM    382  CG  GLU A  81      22.648 108.541  23.771  1.00 45.22           C  
ATOM    383  CD  GLU A  81      22.689 107.125  24.244  1.00 52.07           C  
ATOM    384  OE1 GLU A  81      23.738 106.731  24.787  1.00 71.18           O  
ATOM    385  OE2 GLU A  81      21.671 106.419  24.120  1.00 51.38           O  
ATOM    386  N   LEU A  82      23.731 110.326  19.625  1.00 38.91           N  
ATOM    387  CA  LEU A  82      24.501 110.608  18.424  1.00 38.24           C  
ATOM    388  C   LEU A  82      24.690 112.091  18.237  1.00 40.73           C  
ATOM    389  O   LEU A  82      25.770 112.531  17.863  1.00 38.07           O  
ATOM    390  CB  LEU A  82      23.871 109.958  17.196  1.00 41.51           C  
ATOM    391  CG  LEU A  82      23.983 108.421  17.118  1.00 41.82           C  
ATOM    392  CD1 LEU A  82      23.180 107.928  15.947  1.00 45.38           C  
ATOM    393  CD2 LEU A  82      25.447 107.954  17.038  1.00 44.08           C  
ATOM    394  N   ASN A  83      23.648 112.864  18.532  1.00 44.16           N  
ATOM    395  CA  ASN A  83      23.726 114.313  18.575  1.00 41.09           C  
ATOM    396  C   ASN A  83      24.793 114.777  19.549  1.00 39.84           C  
ATOM    397  O   ASN A  83      25.607 115.640  19.208  1.00 40.42           O  
ATOM    398  CB  ASN A  83      22.381 114.928  19.001  1.00 44.39           C  
ATOM    399  CG  ASN A  83      21.429 115.193  17.835  1.00 41.69           C  
ATOM    400  OD1 ASN A  83      21.539 114.604  16.765  1.00 40.85           O  
ATOM    401  ND2 ASN A  83      20.477 116.106  18.056  1.00 40.55           N  
ATOM    402  N   ALA A  84      24.780 114.206  20.756  1.00 38.92           N  
ATOM    403  CA  ALA A  84      25.761 114.528  21.804  1.00 40.37           C  
ATOM    404  C   ALA A  84      27.181 114.172  21.407  1.00 39.32           C  
ATOM    405  O   ALA A  84      28.116 114.940  21.657  1.00 38.99           O  
ATOM    406  CB  ALA A  84      25.403 113.837  23.082  1.00 41.37           C  
ATOM    407  N   LEU A  85      27.352 113.003  20.811  1.00 38.32           N  
ATOM    408  CA  LEU A  85      28.658 112.568  20.305  1.00 42.07           C  
ATOM    409  C   LEU A  85      29.216 113.590  19.298  1.00 41.30           C  
ATOM    410  O   LEU A  85      30.334 114.072  19.458  1.00 41.81           O  
ATOM    411  CB  LEU A  85      28.542 111.170  19.676  1.00 42.67           C  
ATOM    412  CG  LEU A  85      29.735 110.516  18.981  1.00 38.10           C  
ATOM    413  CD1 LEU A  85      30.962 110.476  19.856  1.00 51.39           C  
ATOM    414  CD2 LEU A  85      29.352 109.129  18.536  1.00 45.50           C  
ATOM    415  N   GLN A  86      28.394 113.927  18.297  1.00 42.26           N  
ATOM    416  CA  GLN A  86      28.713 114.931  17.275  1.00 39.94           C  
ATOM    417  C   GLN A  86      29.051 116.297  17.850  1.00 40.85           C  
ATOM    418  O   GLN A  86      30.051 116.907  17.453  1.00 42.82           O  
ATOM    419  CB  GLN A  86      27.537 115.085  16.295  1.00 40.15           C  
ATOM    420  CG  GLN A  86      27.731 116.153  15.190  1.00 39.54           C  
ATOM    421  CD  GLN A  86      28.922 115.883  14.254  1.00 39.57           C  
ATOM    422  OE1 GLN A  86      28.753 115.435  13.102  1.00 39.75           O  
ATOM    423  NE2 GLN A  86      30.132 116.134  14.754  1.00 36.24           N  
ATOM    424  N   GLU A  87      28.214 116.792  18.757  1.00 43.70           N  
ATOM    425  CA  GLU A  87      28.501 118.051  19.486  1.00 47.08           C  
ATOM    426  C   GLU A  87      29.879 118.025  20.145  1.00 49.09           C  
ATOM    427  O   GLU A  87      30.735 118.894  19.906  1.00 43.50           O  
ATOM    428  CB  GLU A  87      27.455 118.314  20.585  1.00 49.10           C  
ATOM    429  CG  GLU A  87      26.423 119.399  20.266  1.00 63.59           C  
ATOM    430  CD  GLU A  87      25.391 118.983  19.219  1.00 73.65           C  
ATOM    431  OE1 GLU A  87      24.440 118.224  19.553  1.00 72.43           O  
ATOM    432  OE2 GLU A  87      25.517 119.447  18.061  1.00 82.48           O  
ATOM    433  N   GLU A  88      30.056 117.028  21.004  1.00 51.23           N  
ATOM    434  CA  GLU A  88      31.273 116.840  21.784  1.00 52.19           C  
ATOM    435  C   GLU A  88      32.536 116.785  20.924  1.00 48.89           C  
ATOM    436  O   GLU A  88      33.525 117.374  21.265  1.00 46.68           O  
ATOM    437  CB  GLU A  88      31.185 115.514  22.545  1.00 56.95           C  
ATOM    438  CG  GLU A  88      30.940 115.565  24.046  1.00 62.06           C  
ATOM    439  CD  GLU A  88      31.638 114.379  24.740  1.00 59.55           C  
ATOM    440  OE1 GLU A  88      30.984 113.335  25.019  1.00 53.64           O  
ATOM    441  OE2 GLU A  88      32.868 114.481  24.940  1.00 49.69           O  
ATOM    442  N   LEU A  89      32.500 116.038  19.825  1.00 49.14           N  
ATOM    443  CA  LEU A  89      33.704 115.742  19.051  1.00 48.35           C  
ATOM    444  C   LEU A  89      33.836 116.512  17.726  1.00 49.25           C  
ATOM    445  O   LEU A  89      34.799 116.282  16.976  1.00 48.26           O  
ATOM    446  CB  LEU A  89      33.807 114.238  18.784  1.00 45.97           C  
ATOM    447  CG  LEU A  89      33.797 113.280  19.984  1.00 53.86           C  
ATOM    448  CD1 LEU A  89      34.302 111.907  19.575  1.00 57.13           C  
ATOM    449  CD2 LEU A  89      34.629 113.814  21.119  1.00 50.40           C  
ATOM    450  N   LYS A  90      32.909 117.425  17.435  1.00 48.71           N  
ATOM    451  CA  LYS A  90      33.053 118.254  16.236  1.00 49.16           C  
ATOM    452  C   LYS A  90      34.398 118.986  16.250  1.00 46.16           C  
ATOM    453  O   LYS A  90      35.101 118.971  15.246  1.00 43.72           O  
ATOM    454  CB  LYS A  90      31.901 119.256  16.052  1.00 48.36           C  
ATOM    455  CG  LYS A  90      31.888 119.921  14.663  1.00 50.36           C  
ATOM    456  CD  LYS A  90      30.538 120.626  14.331  1.00 51.32           C  
ATOM    457  CE  LYS A  90      29.566 119.738  13.574  1.00 47.11           C  
ATOM    458  N   PRO A  91      34.776 119.600  17.392  1.00 47.71           N  
ATOM    459  CA  PRO A  91      36.046 120.339  17.447  1.00 47.77           C  
ATOM    460  C   PRO A  91      37.303 119.496  17.171  1.00 47.33           C  
ATOM    461  O   PRO A  91      38.360 120.051  16.809  1.00 42.02           O  
ATOM    462  CB  PRO A  91      36.077 120.888  18.885  1.00 48.43           C  
ATOM    463  CG  PRO A  91      34.669 120.891  19.325  1.00 48.71           C  
ATOM    464  CD  PRO A  91      34.063 119.674  18.682  1.00 49.93           C  
ATOM    465  N   TYR A  92      37.178 118.185  17.353  1.00 43.35           N  
ATOM    466  CA  TYR A  92      38.248 117.230  17.131  1.00 45.82           C  
ATOM    467  C   TYR A  92      38.225 116.751  15.675  1.00 44.15           C  
ATOM    468  O   TYR A  92      39.007 115.876  15.305  1.00 42.68           O  
ATOM    469  CB  TYR A  92      38.054 116.006  18.062  1.00 54.04           C  
ATOM    470  CG  TYR A  92      38.212 116.281  19.548  1.00 62.95           C  
ATOM    471  CD1 TYR A  92      37.377 117.188  20.217  1.00 68.27           C  
ATOM    472  CD2 TYR A  92      39.211 115.636  20.294  1.00 76.79           C  
ATOM    473  CE1 TYR A  92      37.537 117.453  21.579  1.00 74.36           C  
ATOM    474  CE2 TYR A  92      39.379 115.893  21.662  1.00 78.88           C  
ATOM    475  CZ  TYR A  92      38.537 116.803  22.294  1.00 77.22           C  
ATOM    476  OH  TYR A  92      38.693 117.062  23.636  1.00 75.59           O  
ATOM    477  N   GLY A  93      37.281 117.253  14.870  1.00 43.20           N  
ATOM    478  CA  GLY A  93      37.204 116.910  13.445  1.00 42.63           C  
ATOM    479  C   GLY A  93      36.362 115.701  13.083  1.00 45.53           C  
ATOM    480  O   GLY A  93      36.556 115.106  12.020  1.00 46.79           O  
ATOM    481  N   LEU A  94      35.415 115.349  13.951  1.00 44.86           N  
ATOM    482  CA  LEU A  94      34.503 114.254  13.690  1.00 46.56           C  
ATOM    483  C   LEU A  94      33.257 114.772  12.990  1.00 42.50           C  
ATOM    484  O   LEU A  94      32.659 115.755  13.428  1.00 38.52           O  
ATOM    485  CB  LEU A  94      34.088 113.546  14.984  1.00 48.42           C  
ATOM    486  CG  LEU A  94      33.162 112.319  14.823  1.00 48.55           C  
ATOM    487  CD1 LEU A  94      33.982 111.046  14.637  1.00 49.86           C  
ATOM    488  CD2 LEU A  94      32.198 112.194  16.010  1.00 45.88           C  
ATOM    489  N   VAL A  95      32.875 114.075  11.922  1.00 43.06           N  
ATOM    490  CA  VAL A  95      31.611 114.297  11.213  1.00 42.29           C  
ATOM    491  C   VAL A  95      30.773 113.005  11.241  1.00 42.88           C  
ATOM    492  O   VAL A  95      31.236 111.964  10.777  1.00 44.79           O  
ATOM    493  CB  VAL A  95      31.894 114.701   9.723  1.00 40.38           C  
ATOM    494  CG1 VAL A  95      30.597 115.000   8.967  1.00 47.38           C  
ATOM    495  CG2 VAL A  95      32.872 115.881   9.647  1.00 42.74           C  
ATOM    496  N   VAL A  96      29.558 113.077  11.795  1.00 40.21           N  
ATOM    497  CA  VAL A  96      28.598 111.985  11.754  1.00 42.44           C  
ATOM    498  C   VAL A  96      27.672 112.074  10.498  1.00 40.55           C  
ATOM    499  O   VAL A  96      27.177 113.132  10.127  1.00 40.79           O  
ATOM    500  CB  VAL A  96      27.757 111.890  13.099  1.00 41.81           C  
ATOM    501  CG1 VAL A  96      26.842 110.681  13.106  1.00 44.56           C  
ATOM    502  CG2 VAL A  96      28.675 111.864  14.326  1.00 39.76           C  
ATOM    503  N   LEU A  97      27.470 110.946   9.835  1.00 37.54           N  
ATOM    504  CA  LEU A  97      26.620 110.876   8.639  1.00 38.03           C  
ATOM    505  C   LEU A  97      25.620 109.737   8.815  1.00 39.79           C  
ATOM    506  O   LEU A  97      26.014 108.620   9.135  1.00 42.07           O  
ATOM    507  CB  LEU A  97      27.462 110.604   7.386  1.00 41.65           C  
ATOM    508  CG  LEU A  97      28.610 111.558   7.049  1.00 42.11           C  
ATOM    509  CD1 LEU A  97      29.335 111.124   5.770  1.00 36.94           C  
ATOM    510  CD2 LEU A  97      28.072 112.990   6.965  1.00 39.94           C  
ATOM    511  N   GLY A  98      24.345 110.034   8.606  1.00 39.64           N  
ATOM    512  CA  GLY A  98      23.275 109.084   8.841  1.00 42.85           C  
ATOM    513  C   GLY A  98      22.583 108.685   7.574  1.00 41.77           C  
ATOM    514  O   GLY A  98      22.166 109.543   6.794  1.00 40.77           O  
ATOM    515  N   PHE A  99      22.407 107.371   7.427  1.00 43.26           N  
ATOM    516  CA  PHE A  99      21.903 106.741   6.221  1.00 44.21           C  
ATOM    517  C   PHE A  99      20.669 105.917   6.540  1.00 42.60           C  
ATOM    518  O   PHE A  99      20.776 104.816   7.083  1.00 42.06           O  
ATOM    519  CB  PHE A  99      23.017 105.895   5.592  1.00 45.74           C  
ATOM    520  CG  PHE A  99      24.058 106.744   4.911  1.00 46.24           C  
ATOM    521  CD1 PHE A  99      23.920 107.073   3.578  1.00 41.10           C  
ATOM    522  CD2 PHE A  99      25.140 107.258   5.617  1.00 46.93           C  
ATOM    523  CE1 PHE A  99      24.866 107.897   2.949  1.00 47.28           C  
ATOM    524  CE2 PHE A  99      26.078 108.096   4.999  1.00 41.11           C  
ATOM    525  CZ  PHE A  99      25.946 108.389   3.664  1.00 49.40           C  
ATOM    526  N   PRO A 100      19.485 106.487   6.279  1.00 43.14           N  
ATOM    527  CA  PRO A 100      18.252 105.720   6.472  1.00 43.21           C  
ATOM    528  C   PRO A 100      18.197 104.499   5.569  1.00 39.59           C  
ATOM    529  O   PRO A 100      18.548 104.542   4.365  1.00 44.30           O  
ATOM    530  CB  PRO A 100      17.136 106.706   6.084  1.00 45.48           C  
ATOM    531  CG  PRO A 100      17.792 108.102   6.233  1.00 39.33           C  
ATOM    532  CD  PRO A 100      19.222 107.857   5.807  1.00 42.20           C  
ATOM    533  N   CYS A 101      17.709 103.427   6.140  1.00 44.86           N  
ATOM    534  CA  CYS A 101      17.639 102.171   5.460  1.00 44.65           C  
ATOM    535  C   CYS A 101      16.431 101.373   5.998  1.00 47.54           C  
ATOM    536  O   CYS A 101      16.231 101.299   7.232  1.00 43.67           O  
ATOM    537  CB  CYS A 101      18.945 101.404   5.662  1.00 47.11           C  
ATOM    538  SG  CYS A 101      18.986  99.777   4.823  1.00 43.40           S  
ATOM    539  N   ASN A 102      15.682 100.738   5.088  1.00 43.14           N  
ATOM    540  CA  ASN A 102      14.466 100.007   5.455  1.00 39.55           C  
ATOM    541  C   ASN A 102      14.628  98.493   5.409  1.00 43.27           C  
ATOM    542  O   ASN A 102      13.645  97.782   5.290  1.00 42.08           O  
ATOM    543  CB  ASN A 102      13.300 100.440   4.542  1.00 45.09           C  
ATOM    544  CG  ASN A 102      11.926 100.101   5.107  1.00 43.09           C  
ATOM    545  OD1 ASN A 102      11.729 100.152   6.305  1.00 40.64           O  
ATOM    546  ND2 ASN A 102      10.950  99.775   4.220  1.00 38.60           N  
ATOM    547  N   GLN A 103      15.865  97.993   5.516  1.00 43.26           N  
ATOM    548  CA  GLN A 103      16.136  96.586   5.270  1.00 39.63           C  
ATOM    549  C   GLN A 103      16.114  95.730   6.505  1.00 41.84           C  
ATOM    550  O   GLN A 103      16.187  94.487   6.423  1.00 40.52           O  
ATOM    551  CB  GLN A 103      17.460  96.426   4.554  1.00 39.92           C  
ATOM    552  CG  GLN A 103      17.460  96.923   3.086  1.00 41.64           C  
ATOM    553  CD  GLN A 103      18.762  96.575   2.422  1.00 40.40           C  
ATOM    554  OE1 GLN A 103      19.816  97.080   2.791  1.00 42.97           O  
ATOM    555  NE2 GLN A 103      18.713  95.618   1.548  1.00 37.75           N  
ATOM    556  N   PHE A 104      15.992  96.384   7.659  1.00 41.76           N  
ATOM    557  CA  PHE A 104      16.192  95.705   8.930  1.00 41.40           C  
ATOM    558  C   PHE A 104      14.892  95.842   9.705  1.00 44.29           C  
ATOM    559  O   PHE A 104      14.665  96.811  10.426  1.00 40.99           O  
ATOM    560  CB  PHE A 104      17.385  96.332   9.666  1.00 40.73           C  
ATOM    561  CG  PHE A 104      18.630  96.374   8.845  1.00 38.90           C  
ATOM    562  CD1 PHE A 104      19.338  95.218   8.601  1.00 39.16           C  
ATOM    563  CD2 PHE A 104      19.069  97.555   8.269  1.00 42.64           C  
ATOM    564  CE1 PHE A 104      20.481  95.243   7.820  1.00 41.06           C  
ATOM    565  CE2 PHE A 104      20.231  97.574   7.512  1.00 39.73           C  
ATOM    566  CZ  PHE A 104      20.909  96.418   7.277  1.00 40.99           C  
ATOM    567  N   GLY A 105      14.021  94.867   9.506  1.00 42.48           N  
ATOM    568  CA  GLY A 105      12.726  94.839  10.175  1.00 43.82           C  
ATOM    569  C   GLY A 105      11.751  95.822   9.562  1.00 41.66           C  
ATOM    570  O   GLY A 105      10.712  96.109  10.154  1.00 41.33           O  
ATOM    571  N   LYS A 106      12.085  96.360   8.401  1.00 44.20           N  
ATOM    572  CA  LYS A 106      11.261  97.401   7.756  1.00 41.18           C  
ATOM    573  C   LYS A 106      10.923  98.519   8.733  1.00 42.20           C  
ATOM    574  O   LYS A 106       9.757  98.953   8.861  1.00 40.02           O  
ATOM    575  CB  LYS A 106       9.970  96.834   7.162  1.00 44.21           C  
ATOM    576  CG  LYS A 106      10.170  95.877   6.019  1.00 39.33           C  
ATOM    577  CD  LYS A 106       8.861  95.431   5.453  1.00 41.89           C  
ATOM    578  CE  LYS A 106       9.060  94.532   4.229  1.00 53.96           C  
ATOM    579  NZ  LYS A 106       8.550  93.175   4.519  1.00 69.79           N  
ATOM    580  N   GLN A 107      11.969  99.027   9.350  1.00 39.86           N  
ATOM    581  CA  GLN A 107      11.883 100.015  10.434  1.00 40.71           C  
ATOM    582  C   GLN A 107      12.147 101.449   9.994  1.00 44.12           C  
ATOM    583  O   GLN A 107      12.185 102.367  10.834  1.00 42.86           O  
ATOM    584  CB  GLN A 107      12.791  99.550  11.572  1.00 40.50           C  
ATOM    585  CG  GLN A 107      12.145  98.375  12.286  1.00 42.59           C  
ATOM    586  CD  GLN A 107      12.972  97.740  13.363  1.00 43.87           C  
ATOM    587  OE1 GLN A 107      14.040  98.228  13.722  1.00 49.71           O  
ATOM    588  NE2 GLN A 107      12.450  96.657  13.920  1.00 44.71           N  
ATOM    589  N   GLU A 108      12.287 101.638   8.670  1.00 41.45           N  
ATOM    590  CA  GLU A 108      12.302 102.986   8.035  1.00 42.74           C  
ATOM    591  C   GLU A 108      11.317 103.036   6.852  1.00 40.89           C  
ATOM    592  O   GLU A 108      11.695 103.147   5.667  1.00 44.18           O  
ATOM    593  CB  GLU A 108      13.707 103.399   7.633  1.00 38.87           C  
ATOM    594  CG  GLU A 108      13.867 104.842   7.313  1.00 39.01           C  
ATOM    595  CD  GLU A 108      13.950 105.729   8.560  1.00 46.44           C  
ATOM    596  OE1 GLU A 108      12.935 105.834   9.263  1.00 44.77           O  
ATOM    597  OE2 GLU A 108      15.043 106.300   8.820  1.00 47.29           O  
ATOM    598  N   PRO A 109      10.025 102.919   7.162  1.00 40.01           N  
ATOM    599  CA  PRO A 109       9.048 102.845   6.056  1.00 40.33           C  
ATOM    600  C   PRO A 109       8.807 104.161   5.309  1.00 42.20           C  
ATOM    601  O   PRO A 109       8.223 104.147   4.222  1.00 37.97           O  
ATOM    602  CB  PRO A 109       7.760 102.435   6.773  1.00 40.10           C  
ATOM    603  CG  PRO A 109       7.948 102.965   8.183  1.00 38.14           C  
ATOM    604  CD  PRO A 109       9.377 102.805   8.484  1.00 42.88           C  
ATOM    605  N   GLY A 110       9.196 105.287   5.910  1.00 43.27           N  
ATOM    606  CA  GLY A 110       8.834 106.600   5.399  1.00 40.50           C  
ATOM    607  C   GLY A 110       9.510 106.960   4.098  1.00 42.92           C  
ATOM    608  O   GLY A 110      10.655 106.569   3.850  1.00 45.52           O  
ATOM    609  N   ASP A 111       8.798 107.697   3.242  1.00 43.20           N  
ATOM    610  CA  ASP A 111       9.434 108.338   2.078  1.00 42.55           C  
ATOM    611  C   ASP A 111      10.453 109.379   2.577  1.00 44.56           C  
ATOM    612  O   ASP A 111      10.435 109.734   3.740  1.00 43.99           O  
ATOM    613  CB  ASP A 111       8.405 108.967   1.174  1.00 45.25           C  
ATOM    614  CG  ASP A 111       7.442 107.928   0.576  1.00 46.41           C  
ATOM    615  OD1 ASP A 111       7.805 106.732   0.460  1.00 54.30           O  
ATOM    616  OD2 ASP A 111       6.332 108.319   0.244  1.00 46.52           O  
ATOM    617  N   ASN A 112      11.352 109.849   1.721  1.00 45.04           N  
ATOM    618  CA  ASN A 112      12.440 110.703   2.207  1.00 44.42           C  
ATOM    619  C   ASN A 112      11.882 111.927   2.962  1.00 42.86           C  
ATOM    620  O   ASN A 112      12.320 112.198   4.081  1.00 42.29           O  
ATOM    621  CB  ASN A 112      13.373 111.108   1.068  1.00 45.96           C  
ATOM    622  CG  ASN A 112      14.231 109.958   0.569  1.00 44.37           C  
ATOM    623  OD1 ASN A 112      14.789 109.211   1.350  1.00 42.90           O  
ATOM    624  ND2 ASN A 112      14.332 109.820  -0.751  1.00 38.71           N  
ATOM    625  N   LYS A 113      10.871 112.588   2.387  1.00 43.55           N  
ATOM    626  CA  LYS A 113      10.187 113.763   3.003  1.00 45.57           C  
ATOM    627  C   LYS A 113       9.551 113.497   4.391  1.00 42.05           C  
ATOM    628  O   LYS A 113       9.272 114.426   5.150  1.00 38.76           O  
ATOM    629  CB  LYS A 113       9.119 114.316   2.058  1.00 46.44           C  
ATOM    630  CG  LYS A 113       7.969 113.292   1.861  1.00 58.55           C  
ATOM    631  CD  LYS A 113       6.769 113.743   1.036  1.00 56.53           C  
ATOM    632  CE  LYS A 113       5.831 112.547   0.847  1.00 57.25           C  
ATOM    633  N   GLU A 114       9.334 112.233   4.734  1.00 42.28           N  
ATOM    634  CA  GLU A 114       8.669 111.876   5.984  1.00 41.07           C  
ATOM    635  C   GLU A 114       9.642 111.563   7.125  1.00 41.18           C  
ATOM    636  O   GLU A 114       9.239 111.489   8.279  1.00 38.11           O  
ATOM    637  CB  GLU A 114       7.739 110.658   5.718  1.00 41.01           C  
ATOM    638  CG  GLU A 114       6.583 110.998   4.808  1.00 39.70           C  
ATOM    639  CD  GLU A 114       5.798 109.804   4.343  1.00 41.51           C  
ATOM    640  OE1 GLU A 114       6.336 108.681   4.303  1.00 38.54           O  
ATOM    641  OE2 GLU A 114       4.623 110.008   4.015  1.00 41.12           O  
ATOM    642  N   ILE A 115      10.922 111.363   6.805  1.00 40.68           N  
ATOM    643  CA  ILE A 115      11.876 110.865   7.772  1.00 42.48           C  
ATOM    644  C   ILE A 115      12.163 111.886   8.871  1.00 42.10           C  
ATOM    645  O   ILE A 115      12.037 111.565  10.041  1.00 45.99           O  
ATOM    646  CB  ILE A 115      13.153 110.375   7.082  1.00 41.72           C  
ATOM    647  CG1 ILE A 115      12.842 109.097   6.286  1.00 43.92           C  
ATOM    648  CG2 ILE A 115      14.262 110.123   8.093  1.00 39.96           C  
ATOM    649  CD1 ILE A 115      13.939 108.724   5.305  1.00 47.20           C  
ATOM    650  N   LEU A 116      12.505 113.120   8.520  1.00 40.88           N  
ATOM    651  CA  LEU A 116      12.755 114.139   9.561  1.00 41.28           C  
ATOM    652  C   LEU A 116      11.513 114.501  10.408  1.00 40.21           C  
ATOM    653  O   LEU A 116      11.615 114.570  11.627  1.00 39.40           O  
ATOM    654  CB  LEU A 116      13.405 115.410   8.965  1.00 40.69           C  
ATOM    655  CG  LEU A 116      14.851 115.177   8.506  1.00 36.78           C  
ATOM    656  CD1 LEU A 116      15.365 116.378   7.745  1.00 48.43           C  
ATOM    657  CD2 LEU A 116      15.749 114.851   9.671  1.00 45.91           C  
ATOM    658  N   PRO A 117      10.334 114.739   9.772  1.00 40.83           N  
ATOM    659  CA  PRO A 117       9.121 114.879  10.579  1.00 40.00           C  
ATOM    660  C   PRO A 117       8.846 113.702  11.542  1.00 40.92           C  
ATOM    661  O   PRO A 117       8.374 113.935  12.665  1.00 41.08           O  
ATOM    662  CB  PRO A 117       8.003 115.005   9.524  1.00 45.12           C  
ATOM    663  CG  PRO A 117       8.678 115.545   8.336  1.00 46.59           C  
ATOM    664  CD  PRO A 117      10.063 114.959   8.343  1.00 42.25           C  
ATOM    665  N   GLY A 118       9.155 112.466  11.125  1.00 39.07           N  
ATOM    666  CA  GLY A 118       8.938 111.308  11.973  1.00 38.47           C  
ATOM    667  C   GLY A 118       9.834 111.347  13.199  1.00 40.93           C  
ATOM    668  O   GLY A 118       9.406 111.014  14.295  1.00 38.49           O  
ATOM    669  N   LEU A 119      11.076 111.783  13.020  1.00 41.12           N  
ATOM    670  CA  LEU A 119      12.014 111.885  14.156  1.00 38.60           C  
ATOM    671  C   LEU A 119      11.595 112.987  15.110  1.00 37.87           C  
ATOM    672  O   LEU A 119      11.668 112.826  16.310  1.00 39.69           O  
ATOM    673  CB  LEU A 119      13.441 112.110  13.661  1.00 41.55           C  
ATOM    674  CG  LEU A 119      14.043 110.992  12.788  1.00 43.56           C  
ATOM    675  CD1 LEU A 119      15.309 111.460  12.096  1.00 46.57           C  
ATOM    676  CD2 LEU A 119      14.312 109.745  13.610  1.00 40.73           C  
ATOM    677  N   LYS A 120      11.116 114.098  14.566  1.00 39.02           N  
ATOM    678  CA  LYS A 120      10.754 115.260  15.370  1.00 40.67           C  
ATOM    679  C   LYS A 120       9.490 115.007  16.181  1.00 42.13           C  
ATOM    680  O   LYS A 120       9.399 115.440  17.346  1.00 35.48           O  
ATOM    681  CB  LYS A 120      10.543 116.472  14.455  1.00 42.79           C  
ATOM    682  CG  LYS A 120      10.322 117.788  15.160  1.00 40.96           C  
ATOM    683  CD  LYS A 120      10.198 118.908  14.155  1.00 43.52           C  
ATOM    684  CE  LYS A 120      10.424 120.263  14.797  1.00 51.61           C  
ATOM    685  NZ  LYS A 120      10.404 121.349  13.781  1.00 50.06           N  
ATOM    686  N   TYR A 121       8.526 114.301  15.579  1.00 39.31           N  
ATOM    687  CA  TYR A 121       7.181 114.243  16.139  1.00 37.05           C  
ATOM    688  C   TYR A 121       6.747 112.850  16.588  1.00 38.74           C  
ATOM    689  O   TYR A 121       5.711 112.719  17.233  1.00 39.25           O  
ATOM    690  CB  TYR A 121       6.190 114.783  15.112  1.00 39.20           C  
ATOM    691  CG  TYR A 121       6.324 116.272  14.804  1.00 39.39           C  
ATOM    692  CD1 TYR A 121       5.989 117.226  15.756  1.00 40.24           C  
ATOM    693  CD2 TYR A 121       6.745 116.722  13.549  1.00 38.46           C  
ATOM    694  CE1 TYR A 121       6.085 118.590  15.487  1.00 42.42           C  
ATOM    695  CE2 TYR A 121       6.844 118.102  13.270  1.00 37.00           C  
ATOM    696  CZ  TYR A 121       6.505 119.028  14.246  1.00 39.38           C  
ATOM    697  OH  TYR A 121       6.599 120.393  14.004  1.00 41.05           O  
ATOM    698  N   VAL A 122       7.506 111.807  16.239  1.00 39.12           N  
ATOM    699  CA  VAL A 122       7.069 110.446  16.529  1.00 40.74           C  
ATOM    700  C   VAL A 122       8.124 109.822  17.429  1.00 38.33           C  
ATOM    701  O   VAL A 122       7.893 109.611  18.612  1.00 39.06           O  
ATOM    702  CB  VAL A 122       6.776 109.593  15.209  1.00 38.01           C  
ATOM    703  CG1 VAL A 122       6.302 108.164  15.535  1.00 36.61           C  
ATOM    704  CG2 VAL A 122       5.722 110.276  14.303  1.00 41.23           C  
ATOM    705  N   ARG A 123       9.288 109.515  16.863  1.00 41.71           N  
ATOM    706  CA  ARG A 123      10.339 108.842  17.599  1.00 40.43           C  
ATOM    707  C   ARG A 123      11.689 109.285  17.076  1.00 41.00           C  
ATOM    708  O   ARG A 123      11.972 109.087  15.884  1.00 42.74           O  
ATOM    709  CB  ARG A 123      10.232 107.324  17.488  1.00 39.47           C  
ATOM    710  CG  ARG A 123      11.050 106.647  18.615  1.00 46.30           C  
ATOM    711  CD  ARG A 123      11.233 105.148  18.445  1.00 45.11           C  
ATOM    712  NE  ARG A 123       9.956 104.447  18.357  1.00 38.94           N  
ATOM    713  CZ  ARG A 123       9.849 103.144  18.145  1.00 44.64           C  
ATOM    714  NH1 ARG A 123       8.662 102.615  18.066  1.00 40.29           N  
ATOM    715  NH2 ARG A 123      10.939 102.376  18.027  1.00 46.78           N  
ATOM    716  N   PRO A 124      12.540 109.864  17.960  1.00 43.25           N  
ATOM    717  CA  PRO A 124      12.348 110.175  19.385  1.00 39.95           C  
ATOM    718  C   PRO A 124      11.169 111.084  19.758  1.00 41.39           C  
ATOM    719  O   PRO A 124      10.714 111.017  20.886  1.00 39.79           O  
ATOM    720  CB  PRO A 124      13.667 110.852  19.779  1.00 43.88           C  
ATOM    721  CG  PRO A 124      14.632 110.336  18.843  1.00 44.53           C  
ATOM    722  CD  PRO A 124      13.916 110.162  17.547  1.00 38.24           C  
ATOM    723  N   GLY A 125      10.682 111.912  18.844  1.00 39.09           N  
ATOM    724  CA  GLY A 125       9.633 112.859  19.179  1.00 43.30           C  
ATOM    725  C   GLY A 125      10.174 113.976  20.062  1.00 44.66           C  
ATOM    726  O   GLY A 125      11.383 114.130  20.211  1.00 45.39           O  
ATOM    727  N   GLY A 126       9.282 114.757  20.640  1.00 43.86           N  
ATOM    728  CA  GLY A 126       9.679 115.848  21.528  1.00 46.99           C  
ATOM    729  C   GLY A 126      10.359 117.042  20.870  1.00 46.86           C  
ATOM    730  O   GLY A 126      10.907 117.907  21.559  1.00 47.32           O  
ATOM    731  N   GLY A 127      10.305 117.106  19.542  1.00 43.91           N  
ATOM    732  CA  GLY A 127      10.995 118.151  18.780  1.00 44.22           C  
ATOM    733  C   GLY A 127      12.379 117.760  18.288  1.00 43.65           C  
ATOM    734  O   GLY A 127      13.132 118.620  17.824  1.00 43.04           O  
ATOM    735  N   PHE A 128      12.714 116.470  18.349  1.00 40.89           N  
ATOM    736  CA  PHE A 128      14.072 116.047  18.058  1.00 40.50           C  
ATOM    737  C   PHE A 128      14.424 116.385  16.612  1.00 42.21           C  
ATOM    738  O   PHE A 128      13.671 116.047  15.682  1.00 42.90           O  
ATOM    739  CB  PHE A 128      14.284 114.535  18.296  1.00 40.66           C  
ATOM    740  CG  PHE A 128      15.686 114.079  17.978  1.00 41.85           C  
ATOM    741  CD1 PHE A 128      16.705 114.264  18.896  1.00 43.96           C  
ATOM    742  CD2 PHE A 128      15.992 113.516  16.740  1.00 47.44           C  
ATOM    743  CE1 PHE A 128      17.989 113.893  18.605  1.00 42.67           C  
ATOM    744  CE2 PHE A 128      17.285 113.115  16.450  1.00 43.47           C  
ATOM    745  CZ  PHE A 128      18.286 113.312  17.387  1.00 41.50           C  
ATOM    746  N   VAL A 129      15.568 117.045  16.429  1.00 39.81           N  
ATOM    747  CA  VAL A 129      16.182 117.209  15.115  1.00 40.50           C  
ATOM    748  C   VAL A 129      17.637 116.700  15.170  1.00 41.39           C  
ATOM    749  O   VAL A 129      18.406 117.133  16.040  1.00 37.93           O  
ATOM    750  CB  VAL A 129      16.171 118.690  14.649  1.00 42.09           C  
ATOM    751  CG1 VAL A 129      16.691 118.801  13.211  1.00 45.43           C  
ATOM    752  CG2 VAL A 129      14.759 119.316  14.783  1.00 42.22           C  
ATOM    753  N   PRO A 130      18.038 115.802  14.232  1.00 43.28           N  
ATOM    754  CA  PRO A 130      19.448 115.389  14.199  1.00 42.85           C  
ATOM    755  C   PRO A 130      20.386 116.597  14.007  1.00 43.75           C  
ATOM    756  O   PRO A 130      20.032 117.537  13.295  1.00 46.19           O  
ATOM    757  CB  PRO A 130      19.523 114.423  12.997  1.00 45.52           C  
ATOM    758  CG  PRO A 130      18.112 114.016  12.704  1.00 47.50           C  
ATOM    759  CD  PRO A 130      17.256 115.172  13.145  1.00 47.20           C  
ATOM    760  N   SER A 131      21.540 116.601  14.673  1.00 42.66           N  
ATOM    761  CA  SER A 131      22.501 117.711  14.562  1.00 43.87           C  
ATOM    762  C   SER A 131      23.665 117.276  13.667  1.00 44.34           C  
ATOM    763  O   SER A 131      24.770 117.796  13.764  1.00 42.42           O  
ATOM    764  CB  SER A 131      23.009 118.133  15.944  1.00 42.75           C  
ATOM    765  OG  SER A 131      23.710 117.059  16.564  1.00 43.01           O  
ATOM    766  N   PHE A 132      23.394 116.293  12.812  1.00 44.18           N  
ATOM    767  CA  PHE A 132      24.333 115.807  11.811  1.00 44.74           C  
ATOM    768  C   PHE A 132      23.535 115.498  10.548  1.00 44.11           C  
ATOM    769  O   PHE A 132      22.314 115.402  10.597  1.00 46.64           O  
ATOM    770  CB  PHE A 132      25.083 114.564  12.321  1.00 44.14           C  
ATOM    771  CG  PHE A 132      24.191 113.441  12.744  1.00 45.44           C  
ATOM    772  CD1 PHE A 132      23.842 112.445  11.852  1.00 43.09           C  
ATOM    773  CD2 PHE A 132      23.718 113.368  14.042  1.00 41.89           C  
ATOM    774  CE1 PHE A 132      23.031 111.399  12.248  1.00 52.13           C  
ATOM    775  CE2 PHE A 132      22.897 112.327  14.441  1.00 43.26           C  
ATOM    776  CZ  PHE A 132      22.550 111.354  13.554  1.00 46.83           C  
ATOM    777  N   GLN A 133      24.242 115.320   9.440  1.00 46.09           N  
ATOM    778  CA  GLN A 133      23.645 115.188   8.109  1.00 47.09           C  
ATOM    779  C   GLN A 133      23.050 113.819   7.864  1.00 46.85           C  
ATOM    780  O   GLN A 133      23.754 112.816   7.965  1.00 42.02           O  
ATOM    781  CB  GLN A 133      24.739 115.447   7.058  1.00 54.37           C  
ATOM    782  CG  GLN A 133      24.273 115.619   5.604  1.00 49.94           C  
ATOM    783  CD  GLN A 133      23.330 116.766   5.444  1.00 57.37           C  
ATOM    784  OE1 GLN A 133      22.156 116.585   5.079  1.00 68.80           O  
ATOM    785  NE2 GLN A 133      23.814 117.958   5.734  1.00 45.36           N  
ATOM    786  N   LEU A 134      21.752 113.778   7.555  1.00 45.05           N  
ATOM    787  CA  LEU A 134      21.085 112.553   7.062  1.00 45.04           C  
ATOM    788  C   LEU A 134      20.980 112.590   5.532  1.00 43.45           C  
ATOM    789  O   LEU A 134      20.868 113.661   4.931  1.00 39.91           O  
ATOM    790  CB  LEU A 134      19.692 112.380   7.679  1.00 44.79           C  
ATOM    791  CG  LEU A 134      19.575 111.605   8.985  1.00 51.60           C  
ATOM    792  CD1 LEU A 134      20.557 112.130  10.030  1.00 54.68           C  
ATOM    793  CD2 LEU A 134      18.124 111.659   9.496  1.00 49.06           C  
ATOM    794  N   PHE A 135      21.034 111.420   4.912  1.00 44.21           N  
ATOM    795  CA  PHE A 135      20.906 111.288   3.452  1.00 43.43           C  
ATOM    796  C   PHE A 135      19.628 110.564   3.072  1.00 43.67           C  
ATOM    797  O   PHE A 135      18.924 110.032   3.939  1.00 44.30           O  
ATOM    798  CB  PHE A 135      22.135 110.589   2.876  1.00 41.84           C  
ATOM    799  CG  PHE A 135      23.414 111.379   3.098  1.00 45.28           C  
ATOM    800  CD1 PHE A 135      23.857 112.296   2.160  1.00 45.99           C  
ATOM    801  CD2 PHE A 135      24.121 111.259   4.289  1.00 44.47           C  
ATOM    802  CE1 PHE A 135      24.995 113.043   2.377  1.00 43.66           C  
ATOM    803  CE2 PHE A 135      25.266 112.008   4.510  1.00 48.58           C  
ATOM    804  CZ  PHE A 135      25.704 112.904   3.534  1.00 43.10           C  
ATOM    805  N   GLU A 136      19.317 110.569   1.772  1.00 40.44           N  
ATOM    806  CA  GLU A 136      18.189 109.824   1.258  1.00 41.02           C  
ATOM    807  C   GLU A 136      18.267 108.333   1.615  1.00 42.72           C  
ATOM    808  O   GLU A 136      19.359 107.759   1.832  1.00 43.17           O  
ATOM    809  CB  GLU A 136      18.083 109.983  -0.256  1.00 39.43           C  
ATOM    810  CG  GLU A 136      17.632 111.326  -0.643  1.00 44.21           C  
ATOM    811  CD  GLU A 136      17.231 111.379  -2.078  1.00 42.49           C  
ATOM    812  OE1 GLU A 136      17.530 110.412  -2.813  1.00 54.59           O  
ATOM    813  OE2 GLU A 136      16.648 112.391  -2.468  1.00 47.86           O  
ATOM    814  N   LYS A 137      17.088 107.731   1.722  1.00 43.47           N  
ATOM    815  CA  LYS A 137      16.967 106.326   2.155  1.00 42.06           C  
ATOM    816  C   LYS A 137      17.447 105.432   1.027  1.00 44.78           C  
ATOM    817  O   LYS A 137      17.252 105.753  -0.161  1.00 43.41           O  
ATOM    818  CB  LYS A 137      15.486 105.997   2.500  1.00 43.09           C  
ATOM    819  CG  LYS A 137      15.263 104.619   3.133  1.00 47.11           C  
ATOM    820  CD  LYS A 137      13.831 104.415   3.649  1.00 48.65           C  
ATOM    821  CE  LYS A 137      12.788 104.347   2.535  1.00 44.38           C  
ATOM    822  NZ  LYS A 137      11.407 104.047   3.039  1.00 37.66           N  
ATOM    823  N   GLY A 138      18.090 104.330   1.371  1.00 39.08           N  
ATOM    824  CA  GLY A 138      18.456 103.343   0.370  1.00 43.65           C  
ATOM    825  C   GLY A 138      18.991 102.086   1.031  1.00 39.99           C  
ATOM    826  O   GLY A 138      19.137 102.043   2.224  1.00 44.39           O  
ATOM    827  N   ASP A 139      19.252 101.059   0.228  1.00 41.74           N  
ATOM    828  CA  ASP A 139      19.796  99.795   0.678  1.00 42.93           C  
ATOM    829  C   ASP A 139      21.278  99.943   1.054  1.00 45.46           C  
ATOM    830  O   ASP A 139      22.006 100.739   0.464  1.00 44.56           O  
ATOM    831  CB  ASP A 139      19.616  98.731  -0.408  1.00 40.80           C  
ATOM    832  CG  ASP A 139      18.166  98.267  -0.539  1.00 48.21           C  
ATOM    833  OD1 ASP A 139      17.327  98.680   0.292  1.00 44.34           O  
ATOM    834  OD2 ASP A 139      17.893  97.465  -1.456  1.00 41.99           O  
ATOM    835  N   VAL A 140      21.663  99.209   2.093  1.00 43.34           N  
ATOM    836  CA  VAL A 140      23.043  99.038   2.527  1.00 43.96           C  
ATOM    837  C   VAL A 140      23.556  97.599   2.303  1.00 42.38           C  
ATOM    838  O   VAL A 140      24.770  97.363   2.398  1.00 44.20           O  
ATOM    839  CB  VAL A 140      23.251  99.423   4.050  1.00 42.66           C  
ATOM    840  CG1 VAL A 140      22.843 100.880   4.312  1.00 40.93           C  
ATOM    841  CG2 VAL A 140      22.567  98.485   5.008  1.00 41.26           C  
ATOM    842  N   ASN A 141      22.631  96.670   1.986  1.00 39.30           N  
ATOM    843  CA  ASN A 141      22.955  95.284   1.674  1.00 39.37           C  
ATOM    844  C   ASN A 141      22.244  94.829   0.424  1.00 41.35           C  
ATOM    845  O   ASN A 141      21.212  95.382   0.054  1.00 44.03           O  
ATOM    846  CB  ASN A 141      22.507  94.331   2.777  1.00 38.67           C  
ATOM    847  CG  ASN A 141      23.260  94.481   4.061  1.00 36.78           C  
ATOM    848  OD1 ASN A 141      24.455  94.803   4.092  1.00 40.27           O  
ATOM    849  ND2 ASN A 141      22.569  94.204   5.163  1.00 38.83           N  
ATOM    850  N   GLY A 142      22.750  93.738  -0.162  1.00 41.30           N  
ATOM    851  CA  GLY A 142      22.142  93.090  -1.293  1.00 42.66           C  
ATOM    852  C   GLY A 142      22.426  93.814  -2.611  1.00 43.81           C  
ATOM    853  O   GLY A 142      23.234  94.736  -2.689  1.00 43.64           O  
ATOM    854  N   GLU A 143      21.749  93.358  -3.650  1.00 44.62           N  
ATOM    855  CA  GLU A 143      21.997  93.771  -5.034  1.00 48.64           C  
ATOM    856  C   GLU A 143      21.934  95.292  -5.281  1.00 48.07           C  
ATOM    857  O   GLU A 143      22.666  95.816  -6.121  1.00 41.95           O  
ATOM    858  CB  GLU A 143      20.993  93.041  -5.925  1.00 48.78           C  
ATOM    859  CG  GLU A 143      20.934  93.472  -7.379  1.00 61.96           C  
ATOM    860  CD  GLU A 143      19.613  93.103  -8.050  1.00 63.08           C  
ATOM    861  OE1 GLU A 143      18.555  93.659  -7.654  1.00 82.31           O  
ATOM    862  OE2 GLU A 143      19.640  92.267  -8.985  1.00 79.17           O  
ATOM    863  N   LYS A 144      21.066  96.004  -4.569  1.00 45.21           N  
ATOM    864  CA  LYS A 144      20.883  97.430  -4.847  1.00 46.74           C  
ATOM    865  C   LYS A 144      21.539  98.255  -3.751  1.00 41.35           C  
ATOM    866  O   LYS A 144      21.206  99.425  -3.565  1.00 44.58           O  
ATOM    867  CB  LYS A 144      19.401  97.793  -4.943  1.00 47.43           C  
ATOM    868  CG  LYS A 144      18.600  97.036  -6.016  1.00 52.72           C  
ATOM    869  CD  LYS A 144      19.023  97.355  -7.455  1.00 61.92           C  
ATOM    870  N   GLU A 145      22.453  97.649  -3.002  1.00 43.06           N  
ATOM    871  CA  GLU A 145      23.141  98.389  -1.956  1.00 42.03           C  
ATOM    872  C   GLU A 145      23.858  99.613  -2.564  1.00 45.06           C  
ATOM    873  O   GLU A 145      24.338  99.570  -3.712  1.00 46.99           O  
ATOM    874  CB  GLU A 145      24.141  97.522  -1.228  1.00 44.61           C  
ATOM    875  CG  GLU A 145      25.313  97.045  -2.051  1.00 43.50           C  
ATOM    876  CD  GLU A 145      26.172  96.040  -1.322  1.00 48.95           C  
ATOM    877  OE1 GLU A 145      25.726  95.407  -0.332  1.00 48.22           O  
ATOM    878  OE2 GLU A 145      27.315  95.878  -1.754  1.00 46.88           O  
ATOM    879  N   GLN A 146      23.914 100.676  -1.770  1.00 42.76           N  
ATOM    880  CA  GLN A 146      24.696 101.873  -2.079  1.00 42.56           C  
ATOM    881  C   GLN A 146      26.189 101.567  -2.199  1.00 40.03           C  
ATOM    882  O   GLN A 146      26.740 100.789  -1.425  1.00 42.43           O  
ATOM    883  CB  GLN A 146      24.433 102.925  -1.015  1.00 40.90           C  
ATOM    884  CG  GLN A 146      22.967 103.406  -1.005  1.00 41.63           C  
ATOM    885  CD  GLN A 146      22.686 104.330   0.131  1.00 44.96           C  
ATOM    886  OE1 GLN A 146      23.087 105.478   0.086  1.00 45.45           O  
ATOM    887  NE2 GLN A 146      22.017 103.832   1.185  1.00 43.62           N  
ATOM    888  N   LYS A 147      26.845 102.153  -3.212  1.00 44.85           N  
ATOM    889  CA  LYS A 147      28.231 101.786  -3.508  1.00 45.73           C  
ATOM    890  C   LYS A 147      29.199 102.112  -2.350  1.00 47.77           C  
ATOM    891  O   LYS A 147      30.192 101.385  -2.154  1.00 44.08           O  
ATOM    892  CB  LYS A 147      28.701 102.359  -4.842  1.00 46.48           C  
ATOM    893  CG  LYS A 147      28.038 101.691  -6.044  1.00 53.64           C  
ATOM    894  CD  LYS A 147      28.478 100.227  -6.204  1.00 69.70           C  
ATOM    895  N   VAL A 148      28.874 103.130  -1.541  1.00 45.28           N  
ATOM    896  CA  VAL A 148      29.737 103.502  -0.422  1.00 47.25           C  
ATOM    897  C   VAL A 148      29.710 102.450   0.620  1.00 45.88           C  
ATOM    898  O   VAL A 148      30.701 102.243   1.310  1.00 46.76           O  
ATOM    899  CB  VAL A 148      29.401 104.896   0.221  1.00 50.28           C  
ATOM    900  CG1 VAL A 148      27.998 104.935   0.861  1.00 46.70           C  
ATOM    901  CG2 VAL A 148      30.503 105.288   1.246  1.00 39.49           C  
ATOM    902  N   PHE A 149      28.566 101.771   0.747  1.00 46.18           N  
ATOM    903  CA  PHE A 149      28.470 100.688   1.725  1.00 42.65           C  
ATOM    904  C   PHE A 149      29.196  99.426   1.243  1.00 41.27           C  
ATOM    905  O   PHE A 149      29.846  98.784   2.036  1.00 45.43           O  
ATOM    906  CB  PHE A 149      27.004 100.471   2.176  1.00 42.69           C  
ATOM    907  CG  PHE A 149      26.565 101.507   3.159  1.00 40.03           C  
ATOM    908  CD1 PHE A 149      25.943 102.656   2.749  1.00 44.08           C  
ATOM    909  CD2 PHE A 149      26.876 101.361   4.508  1.00 43.17           C  
ATOM    910  CE1 PHE A 149      25.600 103.657   3.658  1.00 45.66           C  
ATOM    911  CE2 PHE A 149      26.540 102.352   5.424  1.00 47.40           C  
ATOM    912  CZ  PHE A 149      25.907 103.503   5.000  1.00 44.48           C  
ATOM    913  N   SER A 150      29.139  99.089  -0.045  1.00 42.59           N  
ATOM    914  CA  SER A 150      30.070  98.040  -0.583  1.00 44.24           C  
ATOM    915  C   SER A 150      31.523  98.306  -0.154  1.00 43.74           C  
ATOM    916  O   SER A 150      32.211  97.438   0.354  1.00 47.79           O  
ATOM    917  CB  SER A 150      30.028  97.959  -2.120  1.00 40.81           C  
ATOM    918  OG  SER A 150      28.717  98.174  -2.635  1.00 51.17           O  
ATOM    919  N   PHE A 151      31.976  99.542  -0.355  1.00 41.47           N  
ATOM    920  CA  PHE A 151      33.335  99.958  -0.036  1.00 39.62           C  
ATOM    921  C   PHE A 151      33.637  99.792   1.432  1.00 42.72           C  
ATOM    922  O   PHE A 151      34.625  99.141   1.823  1.00 43.26           O  
ATOM    923  CB  PHE A 151      33.553 101.420  -0.481  1.00 43.31           C  
ATOM    924  CG  PHE A 151      34.898 101.976  -0.090  1.00 41.89           C  
ATOM    925  CD1 PHE A 151      36.057 101.521  -0.702  1.00 46.30           C  
ATOM    926  CD2 PHE A 151      35.004 102.920   0.912  1.00 35.70           C  
ATOM    927  CE1 PHE A 151      37.299 101.993  -0.310  1.00 47.49           C  
ATOM    928  CE2 PHE A 151      36.248 103.404   1.306  1.00 41.94           C  
ATOM    929  CZ  PHE A 151      37.394 102.938   0.697  1.00 43.96           C  
ATOM    930  N   LEU A 152      32.759 100.346   2.259  1.00 42.55           N  
ATOM    931  CA  LEU A 152      32.933 100.270   3.709  1.00 39.24           C  
ATOM    932  C   LEU A 152      32.956  98.831   4.181  1.00 43.54           C  
ATOM    933  O   LEU A 152      33.821  98.437   4.990  1.00 45.38           O  
ATOM    934  CB  LEU A 152      31.804 101.033   4.417  1.00 40.21           C  
ATOM    935  CG  LEU A 152      31.857 102.581   4.434  1.00 41.92           C  
ATOM    936  CD1 LEU A 152      30.527 103.152   4.985  1.00 39.61           C  
ATOM    937  CD2 LEU A 152      33.067 103.160   5.185  1.00 40.84           C  
ATOM    938  N   LYS A 153      31.997  98.046   3.696  1.00 43.66           N  
ATOM    939  CA  LYS A 153      31.852  96.668   4.168  1.00 41.71           C  
ATOM    940  C   LYS A 153      33.031  95.806   3.742  1.00 42.46           C  
ATOM    941  O   LYS A 153      33.479  94.947   4.504  1.00 45.14           O  
ATOM    942  CB  LYS A 153      30.537  96.078   3.672  1.00 43.85           C  
ATOM    943  CG  LYS A 153      29.310  96.741   4.296  1.00 42.91           C  
ATOM    944  CD  LYS A 153      28.026  96.066   3.897  1.00 37.49           C  
ATOM    945  CE  LYS A 153      27.706  96.106   2.428  1.00 43.24           C  
ATOM    946  NZ  LYS A 153      26.573  95.211   2.156  1.00 37.64           N  
ATOM    947  N   HIS A 154      33.527  96.029   2.530  1.00 45.07           N  
ATOM    948  CA  HIS A 154      34.662  95.282   1.995  1.00 49.73           C  
ATOM    949  C   HIS A 154      35.984  95.713   2.640  1.00 51.40           C  
ATOM    950  O   HIS A 154      36.954  94.955   2.621  1.00 49.68           O  
ATOM    951  CB  HIS A 154      34.758  95.445   0.476  1.00 52.15           C  
ATOM    952  CG  HIS A 154      33.763  94.625  -0.286  1.00 63.41           C  
ATOM    953  ND1 HIS A 154      32.495  95.077  -0.589  1.00 71.82           N  
ATOM    954  CD2 HIS A 154      33.852  93.377  -0.811  1.00 73.65           C  
ATOM    955  CE1 HIS A 154      31.846  94.147  -1.268  1.00 72.22           C  
ATOM    956  NE2 HIS A 154      32.646  93.104  -1.416  1.00 77.03           N  
ATOM    957  N   SER A 155      35.993  96.915   3.214  1.00 48.59           N  
ATOM    958  CA  SER A 155      37.183  97.528   3.802  1.00 50.47           C  
ATOM    959  C   SER A 155      37.386  97.155   5.240  1.00 48.34           C  
ATOM    960  O   SER A 155      38.518  97.089   5.687  1.00 51.22           O  
ATOM    961  CB  SER A 155      37.112  99.054   3.699  1.00 48.39           C  
ATOM    962  OG  SER A 155      37.029  99.447   2.344  1.00 52.45           O  
ATOM    963  N   CYS A 156      36.297  96.911   5.955  1.00 47.85           N  
ATOM    964  CA  CYS A 156      36.379  96.585   7.357  0.50 47.38           C  
ATOM    966  C   CYS A 156      35.438  95.450   7.766  1.00 49.96           C  
ATOM    967  O   CYS A 156      34.225  95.589   7.702  1.00 50.08           O  
ATOM    968  CB  CYS A 156      36.077  97.817   8.174  0.50 46.66           C  
ATOM    970  SG  CYS A 156      36.810  97.681   9.722  0.50 43.98           S  
ATOM    972  N   PRO A 157      36.018  94.301   8.176  1.00 49.74           N  
ATOM    973  CA  PRO A 157      35.187  93.194   8.694  1.00 51.34           C  
ATOM    974  C   PRO A 157      34.296  93.523   9.888  1.00 47.69           C  
ATOM    975  O   PRO A 157      34.661  94.335  10.710  1.00 47.64           O  
ATOM    976  CB  PRO A 157      36.230  92.159   9.127  1.00 52.58           C  
ATOM    977  CG  PRO A 157      37.435  92.442   8.238  1.00 54.90           C  
ATOM    978  CD  PRO A 157      37.438  93.912   8.025  1.00 50.69           C  
ATOM    979  N   HIS A 158      33.156  92.852   9.998  1.00 44.45           N  
ATOM    980  CA  HIS A 158      32.314  92.951  11.177  1.00 40.50           C  
ATOM    981  C   HIS A 158      32.952  92.120  12.245  1.00 43.31           C  
ATOM    982  O   HIS A 158      33.570  91.100  11.953  1.00 45.81           O  
ATOM    983  CB  HIS A 158      30.883  92.439  10.877  1.00 45.57           C  
ATOM    984  CG  HIS A 158      29.882  92.667  11.978  1.00 36.44           C  
ATOM    985  ND1 HIS A 158      29.794  91.862  13.089  1.00 44.83           N  
ATOM    986  CD2 HIS A 158      28.885  93.575  12.099  1.00 34.83           C  
ATOM    987  CE1 HIS A 158      28.808  92.281  13.860  1.00 36.69           C  
ATOM    988  NE2 HIS A 158      28.246  93.330  13.285  1.00 43.36           N  
ATOM    989  N   PRO A 159      32.855  92.569  13.497  1.00 43.71           N  
ATOM    990  CA  PRO A 159      33.477  91.832  14.594  1.00 45.11           C  
ATOM    991  C   PRO A 159      32.849  90.501  15.010  1.00 43.73           C  
ATOM    992  O   PRO A 159      33.500  89.728  15.658  1.00 43.84           O  
ATOM    993  CB  PRO A 159      33.393  92.840  15.748  1.00 46.11           C  
ATOM    994  CG  PRO A 159      32.164  93.583  15.467  1.00 41.69           C  
ATOM    995  CD  PRO A 159      32.257  93.831  13.979  1.00 44.52           C  
ATOM    996  N   SER A 160      31.593  90.243  14.672  1.00 44.90           N  
ATOM    997  CA  SER A 160      30.896  89.031  15.112  1.00 44.38           C  
ATOM    998  C   SER A 160      30.802  88.019  13.976  1.00 43.97           C  
ATOM    999  O   SER A 160      30.625  88.389  12.765  1.00 41.09           O  
ATOM   1000  CB  SER A 160      29.472  89.381  15.525  1.00 46.21           C  
ATOM   1001  OG  SER A 160      28.817  88.254  16.043  1.00 50.52           O  
ATOM   1002  N   GLU A 161      30.858  86.756  14.367  1.00 41.66           N  
ATOM   1003  CA  GLU A 161      30.584  85.633  13.470  1.00 45.63           C  
ATOM   1004  C   GLU A 161      29.080  85.517  13.131  1.00 44.33           C  
ATOM   1005  O   GLU A 161      28.721  84.860  12.162  1.00 42.46           O  
ATOM   1006  CB  GLU A 161      31.110  84.327  14.061  1.00 43.03           C  
ATOM   1007  CG  GLU A 161      30.290  83.826  15.227  1.00 47.02           C  
ATOM   1008  CD  GLU A 161      30.876  82.561  15.845  1.00 56.86           C  
ATOM   1009  OE1 GLU A 161      32.098  82.321  15.656  1.00 67.85           O  
ATOM   1010  OE2 GLU A 161      30.111  81.817  16.513  1.00 66.56           O  
ATOM   1011  N   ILE A 162      28.219  86.167  13.925  1.00 46.89           N  
ATOM   1012  CA  ILE A 162      26.782  86.135  13.714  1.00 46.25           C  
ATOM   1013  C   ILE A 162      26.384  87.155  12.681  1.00 42.99           C  
ATOM   1014  O   ILE A 162      26.652  88.357  12.806  1.00 40.95           O  
ATOM   1015  CB  ILE A 162      25.968  86.336  15.026  1.00 46.28           C  
ATOM   1016  CG1 ILE A 162      26.407  85.291  16.058  1.00 48.45           C  
ATOM   1017  CG2 ILE A 162      24.439  86.265  14.751  1.00 43.85           C  
ATOM   1018  CD1 ILE A 162      25.354  84.870  17.058  1.00 58.62           C  
ATOM   1019  N   LEU A 163      25.724  86.672  11.640  1.00 43.19           N  
ATOM   1020  CA  LEU A 163      25.236  87.547  10.573  1.00 44.37           C  
ATOM   1021  C   LEU A 163      23.768  87.837  10.806  1.00 42.77           C  
ATOM   1022  O   LEU A 163      23.254  88.916  10.531  1.00 44.76           O  
ATOM   1023  CB  LEU A 163      25.444  86.847   9.234  1.00 46.31           C  
ATOM   1024  CG  LEU A 163      25.162  87.698   8.007  1.00 58.36           C  
ATOM   1025  CD1 LEU A 163      26.057  88.933   8.028  1.00 49.38           C  
ATOM   1026  CD2 LEU A 163      25.404  86.865   6.790  1.00 57.21           C  
ATOM   1027  N   GLY A 164      23.054  86.852  11.303  1.00 45.73           N  
ATOM   1028  CA  GLY A 164      21.650  87.090  11.541  1.00 48.60           C  
ATOM   1029  C   GLY A 164      20.874  85.943  12.085  1.00 44.39           C  
ATOM   1030  O   GLY A 164      21.372  84.854  12.405  1.00 43.64           O  
ATOM   1031  N   THR A 165      19.600  86.226  12.191  1.00 50.55           N  
ATOM   1032  CA  THR A 165      18.597  85.191  12.267  1.00 57.39           C  
ATOM   1033  C   THR A 165      17.955  84.956  10.851  1.00 57.47           C  
ATOM   1034  O   THR A 165      18.059  85.810   9.902  1.00 56.70           O  
ATOM   1035  CB  THR A 165      17.634  85.637  13.323  1.00 52.54           C  
ATOM   1036  OG1 THR A 165      17.067  86.866  12.873  1.00 51.95           O  
ATOM   1037  CG2 THR A 165      18.479  85.961  14.596  1.00 59.12           C  
ATOM   1038  N   PHE A 166      17.329  83.794  10.696  1.00 57.54           N  
ATOM   1039  CA  PHE A 166      16.466  83.530   9.539  1.00 65.79           C  
ATOM   1040  C   PHE A 166      15.507  84.725   9.242  1.00 67.84           C  
ATOM   1041  O   PHE A 166      15.237  85.070   8.067  1.00 73.18           O  
ATOM   1042  CB  PHE A 166      15.649  82.252   9.759  1.00 69.91           C  
ATOM   1043  CG  PHE A 166      14.830  81.861   8.569  1.00 73.72           C  
ATOM   1044  CD1 PHE A 166      15.427  81.202   7.493  1.00 73.09           C  
ATOM   1045  CD2 PHE A 166      13.473  82.192   8.500  1.00 76.54           C  
ATOM   1046  CE1 PHE A 166      14.678  80.848   6.376  1.00 73.24           C  
ATOM   1047  CE2 PHE A 166      12.716  81.848   7.390  1.00 80.22           C  
ATOM   1048  CZ  PHE A 166      13.318  81.166   6.322  1.00 78.66           C  
ATOM   1049  N   LYS A 167      15.074  85.383  10.315  1.00 61.13           N  
ATOM   1050  CA  LYS A 167      14.170  86.504  10.245  1.00 59.56           C  
ATOM   1051  C   LYS A 167      14.844  87.807   9.793  1.00 55.98           C  
ATOM   1052  O   LYS A 167      14.314  88.529   8.958  1.00 56.92           O  
ATOM   1053  CB  LYS A 167      13.497  86.717  11.618  1.00 62.88           C  
ATOM   1054  CG  LYS A 167      14.319  86.321  12.864  1.00 66.58           C  
ATOM   1055  CD  LYS A 167      14.397  84.745  13.084  1.00 77.36           C  
ATOM   1056  CE  LYS A 167      14.312  84.304  14.550  1.00 74.98           C  
ATOM   1057  NZ  LYS A 167      14.851  85.303  15.539  1.00 67.20           N  
ATOM   1058  N   SER A 168      15.999  88.119  10.357  1.00 49.80           N  
ATOM   1059  CA  SER A 168      16.586  89.426  10.203  1.00 47.55           C  
ATOM   1060  C   SER A 168      17.127  89.693   8.790  1.00 45.54           C  
ATOM   1061  O   SER A 168      17.133  90.834   8.351  1.00 51.51           O  
ATOM   1062  CB  SER A 168      17.694  89.632  11.251  1.00 52.92           C  
ATOM   1063  OG  SER A 168      18.843  88.832  10.979  1.00 42.29           O  
ATOM   1064  N   ILE A 169      17.599  88.652   8.099  1.00 46.90           N  
ATOM   1065  CA  ILE A 169      18.187  88.784   6.760  1.00 47.66           C  
ATOM   1066  C   ILE A 169      17.035  88.897   5.759  1.00 50.09           C  
ATOM   1067  O   ILE A 169      16.206  88.004   5.669  1.00 49.15           O  
ATOM   1068  CB  ILE A 169      19.149  87.597   6.450  1.00 48.74           C  
ATOM   1069  CG1 ILE A 169      20.313  87.608   7.441  1.00 50.73           C  
ATOM   1070  CG2 ILE A 169      19.686  87.705   5.056  1.00 46.02           C  
ATOM   1071  CD1 ILE A 169      21.072  86.297   7.633  1.00 46.28           C  
ATOM   1072  N   SER A 170      16.946  90.026   5.063  1.00 46.75           N  
ATOM   1073  CA  SER A 170      15.811  90.307   4.157  1.00 47.30           C  
ATOM   1074  C   SER A 170      16.262  90.593   2.719  1.00 45.98           C  
ATOM   1075  O   SER A 170      15.460  90.938   1.880  1.00 44.08           O  
ATOM   1076  CB  SER A 170      15.047  91.531   4.681  1.00 45.52           C  
ATOM   1077  OG  SER A 170      15.862  92.735   4.640  1.00 49.79           O  
ATOM   1078  N   TRP A 171      17.553  90.445   2.451  1.00 42.36           N  
ATOM   1079  CA  TRP A 171      18.156  90.932   1.207  1.00 40.55           C  
ATOM   1080  C   TRP A 171      18.857  89.790   0.482  1.00 41.11           C  
ATOM   1081  O   TRP A 171      18.940  88.691   0.984  1.00 41.57           O  
ATOM   1082  CB  TRP A 171      19.132  92.064   1.507  1.00 44.32           C  
ATOM   1083  CG  TRP A 171      20.152  91.632   2.456  1.00 38.91           C  
ATOM   1084  CD1 TRP A 171      21.279  90.948   2.157  1.00 44.33           C  
ATOM   1085  CD2 TRP A 171      20.130  91.759   3.880  1.00 41.07           C  
ATOM   1086  NE1 TRP A 171      21.977  90.660   3.288  1.00 38.87           N  
ATOM   1087  CE2 TRP A 171      21.300  91.145   4.363  1.00 44.21           C  
ATOM   1088  CE3 TRP A 171      19.262  92.351   4.790  1.00 42.20           C  
ATOM   1089  CZ2 TRP A 171      21.614  91.096   5.712  1.00 41.89           C  
ATOM   1090  CZ3 TRP A 171      19.581  92.306   6.129  1.00 43.74           C  
ATOM   1091  CH2 TRP A 171      20.750  91.706   6.570  1.00 41.54           C  
ATOM   1092  N   ASP A 172      19.337  90.074  -0.720  1.00 41.14           N  
ATOM   1093  CA  ASP A 172      19.869  89.081  -1.619  1.00 43.32           C  
ATOM   1094  C   ASP A 172      20.838  89.775  -2.565  1.00 42.43           C  
ATOM   1095  O   ASP A 172      20.522  90.837  -3.109  1.00 41.79           O  
ATOM   1096  CB  ASP A 172      18.720  88.461  -2.403  1.00 46.59           C  
ATOM   1097  CG  ASP A 172      19.145  87.294  -3.248  1.00 49.90           C  
ATOM   1098  OD1 ASP A 172      19.857  86.437  -2.742  1.00 47.91           O  
ATOM   1099  OD2 ASP A 172      18.762  87.214  -4.427  1.00 66.86           O  
ATOM   1100  N   PRO A 173      22.042  89.224  -2.727  1.00 43.69           N  
ATOM   1101  CA  PRO A 173      22.628  88.097  -2.031  1.00 40.39           C  
ATOM   1102  C   PRO A 173      23.107  88.454  -0.630  1.00 40.30           C  
ATOM   1103  O   PRO A 173      23.102  89.629  -0.222  1.00 39.10           O  
ATOM   1104  CB  PRO A 173      23.803  87.733  -2.931  1.00 45.09           C  
ATOM   1105  CG  PRO A 173      24.246  89.067  -3.445  1.00 44.33           C  
ATOM   1106  CD  PRO A 173      22.961  89.750  -3.753  1.00 44.98           C  
ATOM   1107  N   VAL A 174      23.499  87.411   0.090  1.00 38.37           N  
ATOM   1108  CA  VAL A 174      23.923  87.499   1.480  1.00 40.64           C  
ATOM   1109  C   VAL A 174      25.421  87.218   1.528  1.00 38.38           C  
ATOM   1110  O   VAL A 174      25.884  86.223   0.994  1.00 39.80           O  
ATOM   1111  CB  VAL A 174      23.124  86.520   2.370  1.00 40.96           C  
ATOM   1112  CG1 VAL A 174      23.498  86.715   3.830  1.00 36.34           C  
ATOM   1113  CG2 VAL A 174      21.572  86.692   2.110  1.00 39.73           C  
ATOM   1114  N   LYS A 175      26.154  88.141   2.148  1.00 38.88           N  
ATOM   1115  CA  LYS A 175      27.610  88.112   2.193  1.00 38.26           C  
ATOM   1116  C   LYS A 175      28.079  88.292   3.626  1.00 36.94           C  
ATOM   1117  O   LYS A 175      27.433  88.955   4.425  1.00 37.45           O  
ATOM   1118  CB  LYS A 175      28.192  89.232   1.333  1.00 39.55           C  
ATOM   1119  CG  LYS A 175      27.806  89.151  -0.099  1.00 40.70           C  
ATOM   1120  CD  LYS A 175      28.457  90.221  -0.910  1.00 43.53           C  
ATOM   1121  CE  LYS A 175      27.964  90.196  -2.312  1.00 53.56           C  
ATOM   1122  NZ  LYS A 175      28.349  91.465  -2.979  1.00 62.52           N  
ATOM   1123  N   VAL A 176      29.241  87.749   3.918  1.00 36.41           N  
ATOM   1124  CA  VAL A 176      29.715  87.656   5.273  1.00 39.95           C  
ATOM   1125  C   VAL A 176      29.938  89.038   5.912  1.00 38.59           C  
ATOM   1126  O   VAL A 176      29.946  89.147   7.125  1.00 39.99           O  
ATOM   1127  CB  VAL A 176      31.027  86.771   5.362  1.00 37.70           C  
ATOM   1128  CG1 VAL A 176      30.720  85.321   4.907  1.00 35.46           C  
ATOM   1129  CG2 VAL A 176      32.207  87.407   4.563  1.00 40.14           C  
ATOM   1130  N   HIS A 177      30.161  90.060   5.099  1.00 42.52           N  
ATOM   1131  CA  HIS A 177      30.466  91.424   5.602  1.00 42.42           C  
ATOM   1132  C   HIS A 177      29.274  92.339   5.507  1.00 40.66           C  
ATOM   1133  O   HIS A 177      29.393  93.545   5.694  1.00 43.99           O  
ATOM   1134  CB  HIS A 177      31.695  92.053   4.911  1.00 45.46           C  
ATOM   1135  CG  HIS A 177      31.830  91.725   3.463  1.00 46.88           C  
ATOM   1136  ND1 HIS A 177      30.872  92.058   2.528  1.00 51.70           N  
ATOM   1137  CD2 HIS A 177      32.815  91.084   2.786  1.00 50.54           C  
ATOM   1138  CE1 HIS A 177      31.260  91.639   1.339  1.00 51.45           C  
ATOM   1139  NE2 HIS A 177      32.428  91.036   1.469  1.00 50.82           N  
ATOM   1140  N   ASP A 178      28.097  91.765   5.286  1.00 38.19           N  
ATOM   1141  CA  ASP A 178      26.865  92.560   5.335  1.00 38.65           C  
ATOM   1142  C   ASP A 178      26.642  93.243   6.677  1.00 39.76           C  
ATOM   1143  O   ASP A 178      27.060  92.758   7.721  1.00 43.10           O  
ATOM   1144  CB  ASP A 178      25.627  91.725   5.047  1.00 36.49           C  
ATOM   1145  CG  ASP A 178      25.514  91.255   3.638  1.00 47.30           C  
ATOM   1146  OD1 ASP A 178      26.121  91.817   2.687  1.00 47.16           O  
ATOM   1147  OD2 ASP A 178      24.744  90.293   3.488  1.00 42.90           O  
ATOM   1148  N   ILE A 179      25.939  94.368   6.628  1.00 42.91           N  
ATOM   1149  CA  ILE A 179      25.446  95.009   7.819  1.00 39.97           C  
ATOM   1150  C   ILE A 179      24.370  94.125   8.471  1.00 36.06           C  
ATOM   1151  O   ILE A 179      23.509  93.541   7.803  1.00 39.13           O  
ATOM   1152  CB  ILE A 179      24.982  96.454   7.469  1.00 39.50           C  
ATOM   1153  CG1 ILE A 179      26.227  97.344   7.253  1.00 41.92           C  
ATOM   1154  CG2 ILE A 179      24.099  97.030   8.596  1.00 42.51           C  
ATOM   1155  CD1 ILE A 179      25.987  98.624   6.371  1.00 40.85           C  
ATOM   1156  N   ARG A 180      24.448  93.961   9.789  1.00 42.87           N  
ATOM   1157  CA  ARG A 180      23.595  93.024  10.482  1.00 39.28           C  
ATOM   1158  C   ARG A 180      22.223  93.642  10.813  1.00 42.72           C  
ATOM   1159  O   ARG A 180      21.212  92.933  10.907  1.00 44.55           O  
ATOM   1160  CB  ARG A 180      24.270  92.609  11.789  1.00 44.78           C  
ATOM   1161  CG  ARG A 180      25.146  91.421  11.724  1.00 39.03           C  
ATOM   1162  CD  ARG A 180      26.282  91.529  10.759  1.00 37.87           C  
ATOM   1163  NE  ARG A 180      27.211  90.424  11.038  1.00 38.29           N  
ATOM   1164  CZ  ARG A 180      28.245  90.073  10.280  1.00 45.05           C  
ATOM   1165  NH1 ARG A 180      28.488  90.695   9.178  1.00 37.19           N  
ATOM   1166  NH2 ARG A 180      29.034  89.079  10.640  1.00 38.89           N  
ATOM   1167  N   TRP A 181      22.205  94.940  11.102  1.00 43.50           N  
ATOM   1168  CA  TRP A 181      20.985  95.576  11.649  1.00 42.26           C  
ATOM   1169  C   TRP A 181      21.072  97.097  11.628  1.00 43.06           C  
ATOM   1170  O   TRP A 181      22.046  97.687  11.150  1.00 44.30           O  
ATOM   1171  CB  TRP A 181      20.735  95.058  13.067  1.00 40.79           C  
ATOM   1172  CG  TRP A 181      19.334  95.218  13.563  1.00 40.96           C  
ATOM   1173  CD1 TRP A 181      18.915  96.014  14.583  1.00 43.65           C  
ATOM   1174  CD2 TRP A 181      18.168  94.588  13.037  1.00 40.84           C  
ATOM   1175  NE1 TRP A 181      17.557  95.898  14.752  1.00 44.10           N  
ATOM   1176  CE2 TRP A 181      17.073  95.016  13.821  1.00 38.92           C  
ATOM   1177  CE3 TRP A 181      17.940  93.663  11.996  1.00 41.67           C  
ATOM   1178  CZ2 TRP A 181      15.773  94.614  13.552  1.00 44.93           C  
ATOM   1179  CZ3 TRP A 181      16.652  93.241  11.758  1.00 46.22           C  
ATOM   1180  CH2 TRP A 181      15.584  93.711  12.529  1.00 42.28           C  
ATOM   1181  N   ASN A 182      19.988  97.736  12.048  1.00 39.39           N  
ATOM   1182  CA  ASN A 182      19.960  99.177  12.189  1.00 43.24           C  
ATOM   1183  C   ASN A 182      21.076  99.625  13.135  1.00 40.37           C  
ATOM   1184  O   ASN A 182      21.416  98.907  14.073  1.00 39.59           O  
ATOM   1185  CB  ASN A 182      18.604  99.600  12.746  1.00 42.46           C  
ATOM   1186  CG  ASN A 182      17.444  99.151  11.874  1.00 42.86           C  
ATOM   1187  OD1 ASN A 182      17.341  99.564  10.712  1.00 38.61           O  
ATOM   1188  ND2 ASN A 182      16.582  98.279  12.409  1.00 41.31           N  
ATOM   1189  N   PHE A 183      21.630 100.799  12.863  1.00 40.79           N  
ATOM   1190  CA  PHE A 183      22.577 101.520  13.749  1.00 43.11           C  
ATOM   1191  C   PHE A 183      23.922 100.829  13.915  1.00 45.70           C  
ATOM   1192  O   PHE A 183      24.567 100.968  14.950  1.00 41.58           O  
ATOM   1193  CB  PHE A 183      21.915 101.875  15.091  1.00 41.65           C  
ATOM   1194  CG  PHE A 183      20.807 102.872  14.955  1.00 41.43           C  
ATOM   1195  CD1 PHE A 183      21.058 104.219  15.005  1.00 43.55           C  
ATOM   1196  CD2 PHE A 183      19.507 102.459  14.746  1.00 48.23           C  
ATOM   1197  CE1 PHE A 183      20.008 105.156  14.857  1.00 40.62           C  
ATOM   1198  CE2 PHE A 183      18.470 103.369  14.596  1.00 40.22           C  
ATOM   1199  CZ  PHE A 183      18.732 104.727  14.652  1.00 41.85           C  
ATOM   1200  N   GLU A 184      24.358 100.122  12.855  1.00 45.12           N  
ATOM   1201  CA  GLU A 184      25.735  99.651  12.755  1.00 41.25           C  
ATOM   1202  C   GLU A 184      26.570 100.862  12.345  1.00 43.50           C  
ATOM   1203  O   GLU A 184      26.022 101.859  11.814  1.00 42.37           O  
ATOM   1204  CB  GLU A 184      25.812  98.513  11.763  1.00 46.79           C  
ATOM   1205  CG  GLU A 184      27.129  97.863  11.623  1.00 47.28           C  
ATOM   1206  CD  GLU A 184      27.037  96.498  10.943  1.00 48.10           C  
ATOM   1207  OE1 GLU A 184      26.149  95.681  11.316  1.00 42.28           O  
ATOM   1208  OE2 GLU A 184      27.901  96.237  10.080  1.00 46.11           O  
ATOM   1209  N   LYS A 185      27.863 100.825  12.628  1.00 44.83           N  
ATOM   1210  CA  LYS A 185      28.717 102.035  12.506  1.00 45.60           C  
ATOM   1211  C   LYS A 185      30.119 101.777  11.945  1.00 42.37           C  
ATOM   1212  O   LYS A 185      30.731 100.759  12.236  1.00 43.28           O  
ATOM   1213  CB  LYS A 185      28.842 102.712  13.865  1.00 43.26           C  
ATOM   1214  CG  LYS A 185      27.532 103.186  14.436  1.00 40.54           C  
ATOM   1215  CD  LYS A 185      27.661 103.700  15.868  1.00 41.82           C  
ATOM   1216  CE  LYS A 185      26.273 103.974  16.481  1.00 40.27           C  
ATOM   1217  NZ  LYS A 185      25.501 102.736  16.828  1.00 38.02           N  
ATOM   1218  N   PHE A 186      30.589 102.715  11.121  1.00 42.99           N  
ATOM   1219  CA  PHE A 186      31.921 102.675  10.555  1.00 42.35           C  
ATOM   1220  C   PHE A 186      32.622 104.002  10.796  1.00 42.38           C  
ATOM   1221  O   PHE A 186      32.024 105.062  10.625  1.00 42.10           O  
ATOM   1222  CB  PHE A 186      31.916 102.470   9.058  1.00 42.45           C  
ATOM   1223  CG  PHE A 186      31.264 101.217   8.594  1.00 41.38           C  
ATOM   1224  CD1 PHE A 186      32.032 100.140   8.179  1.00 44.43           C  
ATOM   1225  CD2 PHE A 186      29.874 101.135   8.490  1.00 42.76           C  
ATOM   1226  CE1 PHE A 186      31.409  98.964   7.685  1.00 51.79           C  
ATOM   1227  CE2 PHE A 186      29.260  99.952   8.018  1.00 45.21           C  
ATOM   1228  CZ  PHE A 186      30.048  98.878   7.619  1.00 44.49           C  
ATOM   1229  N   LEU A 187      33.902 103.923  11.163  1.00 44.52           N  
ATOM   1230  CA  LEU A 187      34.757 105.098  11.233  1.00 42.39           C  
ATOM   1231  C   LEU A 187      35.730 105.121  10.055  1.00 43.37           C  
ATOM   1232  O   LEU A 187      36.442 104.135   9.794  1.00 41.40           O  
ATOM   1233  CB  LEU A 187      35.520 105.134  12.554  1.00 42.91           C  
ATOM   1234  CG  LEU A 187      36.461 106.319  12.817  1.00 43.45           C  
ATOM   1235  CD1 LEU A 187      35.685 107.552  13.168  1.00 46.92           C  
ATOM   1236  CD2 LEU A 187      37.413 105.983  13.954  1.00 39.31           C  
ATOM   1237  N   VAL A 188      35.760 106.265   9.366  1.00 47.38           N  
ATOM   1238  CA  VAL A 188      36.687 106.518   8.258  1.00 43.62           C  
ATOM   1239  C   VAL A 188      37.692 107.578   8.717  1.00 45.87           C  
ATOM   1240  O   VAL A 188      37.309 108.596   9.315  1.00 43.87           O  
ATOM   1241  CB  VAL A 188      35.904 106.941   6.996  1.00 47.66           C  
ATOM   1242  CG1 VAL A 188      36.854 107.255   5.827  1.00 44.48           C  
ATOM   1243  CG2 VAL A 188      34.856 105.839   6.610  1.00 39.64           C  
ATOM   1244  N   GLY A 189      38.978 107.320   8.479  1.00 45.76           N  
ATOM   1245  CA  GLY A 189      40.042 108.250   8.887  1.00 45.98           C  
ATOM   1246  C   GLY A 189      40.098 109.527   8.048  1.00 47.80           C  
ATOM   1247  O   GLY A 189      39.317 109.686   7.088  1.00 45.97           O  
ATOM   1248  N   PRO A 190      41.015 110.462   8.410  1.00 45.73           N  
ATOM   1249  CA  PRO A 190      41.132 111.742   7.698  1.00 46.09           C  
ATOM   1250  C   PRO A 190      41.736 111.622   6.294  1.00 46.06           C  
ATOM   1251  O   PRO A 190      41.706 112.585   5.548  1.00 44.63           O  
ATOM   1252  CB  PRO A 190      42.002 112.592   8.629  1.00 44.62           C  
ATOM   1253  CG  PRO A 190      42.806 111.620   9.384  1.00 47.37           C  
ATOM   1254  CD  PRO A 190      41.982 110.364   9.516  1.00 46.35           C  
ATOM   1255  N   ASP A 191      42.205 110.426   5.936  1.00 48.75           N  
ATOM   1256  CA  ASP A 191      42.648 110.097   4.577  1.00 47.93           C  
ATOM   1257  C   ASP A 191      41.627 109.342   3.711  1.00 48.96           C  
ATOM   1258  O   ASP A 191      41.952 108.905   2.600  1.00 46.84           O  
ATOM   1259  CB  ASP A 191      43.937 109.276   4.658  1.00 49.17           C  
ATOM   1260  CG  ASP A 191      43.767 107.945   5.397  1.00 49.59           C  
ATOM   1261  OD1 ASP A 191      42.653 107.592   5.887  1.00 42.15           O  
ATOM   1262  OD2 ASP A 191      44.791 107.234   5.486  1.00 46.54           O  
ATOM   1263  N   GLY A 192      40.408 109.157   4.229  1.00 49.71           N  
ATOM   1264  CA  GLY A 192      39.346 108.469   3.495  1.00 47.06           C  
ATOM   1265  C   GLY A 192      39.405 106.946   3.528  1.00 45.60           C  
ATOM   1266  O   GLY A 192      38.613 106.276   2.863  1.00 46.36           O  
ATOM   1267  N   ILE A 193      40.327 106.382   4.298  1.00 45.21           N  
ATOM   1268  CA  ILE A 193      40.396 104.929   4.426  1.00 48.58           C  
ATOM   1269  C   ILE A 193      39.632 104.486   5.692  1.00 45.10           C  
ATOM   1270  O   ILE A 193      39.849 105.018   6.776  1.00 45.45           O  
ATOM   1271  CB  ILE A 193      41.856 104.408   4.424  1.00 49.65           C  
ATOM   1272  CG1 ILE A 193      42.506 104.724   3.069  1.00 53.70           C  
ATOM   1273  CG2 ILE A 193      41.892 102.884   4.686  1.00 45.60           C  
ATOM   1274  CD1 ILE A 193      43.980 104.371   2.995  1.00 53.89           C  
ATOM   1275  N   PRO A 194      38.707 103.533   5.546  1.00 44.19           N  
ATOM   1276  CA  PRO A 194      37.993 103.061   6.718  1.00 45.47           C  
ATOM   1277  C   PRO A 194      38.923 102.422   7.747  1.00 49.32           C  
ATOM   1278  O   PRO A 194      39.834 101.648   7.368  1.00 51.30           O  
ATOM   1279  CB  PRO A 194      37.055 102.018   6.147  1.00 44.06           C  
ATOM   1280  CG  PRO A 194      36.860 102.382   4.777  1.00 44.81           C  
ATOM   1281  CD  PRO A 194      38.201 102.888   4.333  1.00 47.21           C  
ATOM   1282  N   VAL A 195      38.693 102.746   9.020  1.00 49.28           N  
ATOM   1283  CA  VAL A 195      39.532 102.243  10.104  1.00 48.62           C  
ATOM   1284  C   VAL A 195      38.868 101.211  11.025  1.00 45.44           C  
ATOM   1285  O   VAL A 195      39.541 100.287  11.476  1.00 44.23           O  
ATOM   1286  CB  VAL A 195      40.192 103.405  10.962  1.00 52.70           C  
ATOM   1287  CG1 VAL A 195      40.916 104.372  10.054  1.00 54.30           C  
ATOM   1288  CG2 VAL A 195      39.188 104.148  11.842  1.00 54.02           C  
ATOM   1289  N   MET A 196      37.579 101.359  11.302  1.00 42.85           N  
ATOM   1290  CA  MET A 196      36.942 100.629  12.412  1.00 48.49           C  
ATOM   1291  C   MET A 196      35.464 100.424  12.120  1.00 42.36           C  
ATOM   1292  O   MET A 196      34.871 101.230  11.433  1.00 41.70           O  
ATOM   1293  CB  MET A 196      37.042 101.513  13.637  1.00 50.57           C  
ATOM   1294  CG  MET A 196      37.555 100.904  14.892  1.00 65.66           C  
ATOM   1295  SD  MET A 196      37.866 102.285  16.031  1.00 62.17           S  
ATOM   1296  CE  MET A 196      38.422 101.412  17.514  1.00 71.61           C  
ATOM   1297  N   ARG A 197      34.875  99.389  12.704  1.00 40.41           N  
ATOM   1298  CA  ARG A 197      33.474  99.089  12.551  1.00 42.09           C  
ATOM   1299  C   ARG A 197      32.950  98.537  13.847  1.00 42.37           C  
ATOM   1300  O   ARG A 197      33.547  97.635  14.402  1.00 41.69           O  
ATOM   1301  CB  ARG A 197      33.308  98.047  11.441  1.00 43.65           C  
ATOM   1302  CG  ARG A 197      31.909  97.618  11.063  1.00 43.44           C  
ATOM   1303  CD  ARG A 197      32.025  96.583   9.941  1.00 46.49           C  
ATOM   1304  NE  ARG A 197      30.742  96.090   9.485  1.00 44.78           N  
ATOM   1305  CZ  ARG A 197      30.529  95.326   8.395  1.00 45.47           C  
ATOM   1306  NH1 ARG A 197      31.513  94.952   7.582  1.00 43.07           N  
ATOM   1307  NH2 ARG A 197      29.295  94.930   8.120  1.00 45.48           N  
ATOM   1308  N   TRP A 198      31.807  99.050  14.283  1.00 40.70           N  
ATOM   1309  CA  TRP A 198      31.125  98.586  15.478  1.00 41.96           C  
ATOM   1310  C   TRP A 198      29.831  97.847  15.140  1.00 39.74           C  
ATOM   1311  O   TRP A 198      29.061  98.229  14.247  1.00 43.11           O  
ATOM   1312  CB  TRP A 198      30.766  99.768  16.395  1.00 42.47           C  
ATOM   1313  CG  TRP A 198      31.927 100.556  16.957  1.00 43.13           C  
ATOM   1314  CD1 TRP A 198      32.521 100.364  18.147  1.00 39.16           C  
ATOM   1315  CD2 TRP A 198      32.602 101.679  16.348  1.00 37.23           C  
ATOM   1316  NE1 TRP A 198      33.547 101.251  18.321  1.00 40.82           N  
ATOM   1317  CE2 TRP A 198      33.607 102.089  17.240  1.00 45.01           C  
ATOM   1318  CE3 TRP A 198      32.467 102.353  15.131  1.00 40.11           C  
ATOM   1319  CZ2 TRP A 198      34.482 103.167  16.966  1.00 45.50           C  
ATOM   1320  CZ3 TRP A 198      33.323 103.426  14.854  1.00 39.83           C  
ATOM   1321  CH2 TRP A 198      34.317 103.825  15.777  1.00 41.73           C  
ATOM   1322  N   SER A 199      29.582  96.789  15.900  1.00 40.88           N  
ATOM   1323  CA  SER A 199      28.266  96.188  15.964  1.00 40.31           C  
ATOM   1324  C   SER A 199      27.210  97.209  16.415  1.00 40.95           C  
ATOM   1325  O   SER A 199      27.524  98.168  17.130  1.00 43.16           O  
ATOM   1326  CB  SER A 199      28.328  95.018  16.949  1.00 43.88           C  
ATOM   1327  OG  SER A 199      27.024  94.574  17.248  1.00 42.23           O  
ATOM   1328  N   HIS A 200      25.966  97.007  15.955  1.00 40.95           N  
ATOM   1329  CA  HIS A 200      24.790  97.707  16.432  1.00 39.02           C  
ATOM   1330  C   HIS A 200      24.523  97.444  17.929  1.00 38.42           C  
ATOM   1331  O   HIS A 200      23.691  98.119  18.534  1.00 40.09           O  
ATOM   1332  CB  HIS A 200      23.546  97.309  15.590  1.00 40.01           C  
ATOM   1333  CG  HIS A 200      23.098  95.889  15.797  1.00 41.69           C  
ATOM   1334  ND1 HIS A 200      23.735  94.809  15.214  1.00 44.11           N  
ATOM   1335  CD2 HIS A 200      22.075  95.374  16.523  1.00 44.93           C  
ATOM   1336  CE1 HIS A 200      23.144  93.696  15.603  1.00 42.70           C  
ATOM   1337  NE2 HIS A 200      22.129  94.011  16.395  1.00 42.69           N  
ATOM   1338  N   ARG A 201      25.160  96.423  18.478  1.00 39.19           N  
ATOM   1339  CA  ARG A 201      25.002  96.043  19.867  1.00 39.32           C  
ATOM   1340  C   ARG A 201      25.859  96.928  20.799  1.00 38.28           C  
ATOM   1341  O   ARG A 201      25.675  96.865  21.989  1.00 39.07           O  
ATOM   1342  CB  ARG A 201      25.376  94.580  20.073  1.00 41.92           C  
ATOM   1343  CG  ARG A 201      24.383  93.607  19.392  1.00 44.86           C  
ATOM   1344  CD  ARG A 201      24.803  92.140  19.531  1.00 46.22           C  
ATOM   1345  NE  ARG A 201      24.939  91.704  20.932  1.00 51.53           N  
ATOM   1346  CZ  ARG A 201      23.989  91.043  21.609  1.00 66.35           C  
ATOM   1347  NH1 ARG A 201      22.832  90.716  21.019  1.00 65.14           N  
ATOM   1348  NH2 ARG A 201      24.184  90.705  22.892  1.00 55.45           N  
ATOM   1349  N   ALA A 202      26.795  97.699  20.242  1.00 38.03           N  
ATOM   1350  CA  ALA A 202      27.723  98.554  21.035  1.00 39.74           C  
ATOM   1351  C   ALA A 202      27.024  99.867  21.347  1.00 38.15           C  
ATOM   1352  O   ALA A 202      26.462 100.513  20.457  1.00 38.01           O  
ATOM   1353  CB  ALA A 202      29.001  98.811  20.255  1.00 37.34           C  
ATOM   1354  N   THR A 203      27.005 100.238  22.626  1.00 39.65           N  
ATOM   1355  CA  THR A 203      26.392 101.516  23.035  1.00 40.59           C  
ATOM   1356  C   THR A 203      27.145 102.685  22.425  1.00 36.43           C  
ATOM   1357  O   THR A 203      28.324 102.569  22.192  1.00 39.59           O  
ATOM   1358  CB  THR A 203      26.454 101.717  24.534  1.00 34.65           C  
ATOM   1359  OG1 THR A 203      27.820 101.707  24.895  1.00 33.08           O  
ATOM   1360  CG2 THR A 203      25.709 100.640  25.225  1.00 39.84           C  
ATOM   1361  N   VAL A 204      26.450 103.789  22.153  1.00 38.54           N  
ATOM   1362  CA  VAL A 204      27.091 105.023  21.685  1.00 38.79           C  
ATOM   1363  C   VAL A 204      28.172 105.531  22.656  1.00 35.32           C  
ATOM   1364  O   VAL A 204      29.146 106.155  22.229  1.00 37.78           O  
ATOM   1365  CB  VAL A 204      26.058 106.173  21.456  1.00 41.21           C  
ATOM   1366  CG1 VAL A 204      26.761 107.466  21.026  1.00 43.51           C  
ATOM   1367  CG2 VAL A 204      24.993 105.744  20.418  1.00 35.88           C  
ATOM   1368  N   SER A 205      27.996 105.277  23.951  1.00 35.31           N  
ATOM   1369  CA  SER A 205      29.016 105.616  24.930  1.00 37.17           C  
ATOM   1370  C   SER A 205      30.291 104.835  24.690  1.00 31.48           C  
ATOM   1371  O   SER A 205      31.361 105.376  24.843  1.00 29.07           O  
ATOM   1372  CB  SER A 205      28.544 105.369  26.360  1.00 36.98           C  
ATOM   1373  OG  SER A 205      27.374 106.090  26.629  1.00 40.39           O  
ATOM   1374  N   SER A 206      30.190 103.561  24.327  1.00 33.58           N  
ATOM   1375  CA  SER A 206      31.422 102.774  24.120  1.00 36.40           C  
ATOM   1376  C   SER A 206      32.075 103.197  22.785  1.00 34.89           C  
ATOM   1377  O   SER A 206      33.319 103.250  22.680  1.00 39.94           O  
ATOM   1378  CB  SER A 206      31.143 101.255  24.161  1.00 33.87           C  
ATOM   1379  OG  SER A 206      30.347 100.842  23.059  1.00 40.92           O  
ATOM   1380  N   VAL A 207      31.240 103.529  21.802  1.00 37.51           N  
ATOM   1381  CA  VAL A 207      31.719 104.063  20.522  1.00 36.89           C  
ATOM   1382  C   VAL A 207      32.498 105.357  20.776  1.00 41.10           C  
ATOM   1383  O   VAL A 207      33.625 105.495  20.304  1.00 41.12           O  
ATOM   1384  CB  VAL A 207      30.589 104.264  19.527  1.00 41.23           C  
ATOM   1385  CG1 VAL A 207      31.066 105.078  18.296  1.00 34.10           C  
ATOM   1386  CG2 VAL A 207      29.999 102.905  19.086  1.00 42.45           C  
ATOM   1387  N   LYS A 208      31.933 106.261  21.573  1.00 41.30           N  
ATOM   1388  CA  LYS A 208      32.623 107.495  21.939  1.00 43.61           C  
ATOM   1389  C   LYS A 208      33.969 107.204  22.602  1.00 40.85           C  
ATOM   1390  O   LYS A 208      35.015 107.746  22.193  1.00 40.06           O  
ATOM   1391  CB  LYS A 208      31.723 108.346  22.837  1.00 44.24           C  
ATOM   1392  CG  LYS A 208      32.319 109.689  23.238  1.00 49.90           C  
ATOM   1393  CD  LYS A 208      31.483 110.376  24.339  1.00 47.90           C  
ATOM   1394  CE  LYS A 208      30.140 110.882  23.813  1.00 55.25           C  
ATOM   1395  N   THR A 209      33.960 106.322  23.608  1.00 39.80           N  
ATOM   1396  CA  THR A 209      35.176 105.957  24.293  1.00 36.67           C  
ATOM   1397  C   THR A 209      36.235 105.415  23.351  1.00 36.45           C  
ATOM   1398  O   THR A 209      37.425 105.764  23.467  1.00 32.81           O  
ATOM   1399  CB  THR A 209      34.930 104.956  25.454  1.00 40.30           C  
ATOM   1400  OG1 THR A 209      34.031 105.544  26.403  1.00 45.95           O  
ATOM   1401  CG2 THR A 209      36.241 104.614  26.159  1.00 38.71           C  
ATOM   1402  N   ASP A 210      35.823 104.567  22.428  1.00 39.63           N  
ATOM   1403  CA  ASP A 210      36.741 104.049  21.400  1.00 42.08           C  
ATOM   1404  C   ASP A 210      37.291 105.158  20.465  1.00 40.55           C  
ATOM   1405  O   ASP A 210      38.495 105.201  20.162  1.00 36.05           O  
ATOM   1406  CB  ASP A 210      36.048 102.975  20.573  1.00 38.78           C  
ATOM   1407  CG  ASP A 210      35.765 101.707  21.345  1.00 38.81           C  
ATOM   1408  OD1 ASP A 210      36.215 101.564  22.485  1.00 38.14           O  
ATOM   1409  OD2 ASP A 210      35.074 100.838  20.785  1.00 37.46           O  
ATOM   1410  N   ILE A 211      36.406 106.055  20.041  1.00 38.60           N  
ATOM   1411  CA  ILE A 211      36.813 107.163  19.184  1.00 42.36           C  
ATOM   1412  C   ILE A 211      37.760 108.127  19.884  1.00 39.59           C  
ATOM   1413  O   ILE A 211      38.753 108.527  19.297  1.00 42.79           O  
ATOM   1414  CB  ILE A 211      35.600 107.929  18.609  1.00 42.53           C  
ATOM   1415  CG1 ILE A 211      34.918 107.070  17.549  1.00 39.36           C  
ATOM   1416  CG2 ILE A 211      36.049 109.260  17.988  1.00 41.88           C  
ATOM   1417  CD1 ILE A 211      33.561 107.624  17.080  1.00 40.82           C  
ATOM   1418  N   LEU A 212      37.477 108.464  21.139  1.00 39.93           N  
ATOM   1419  CA  LEU A 212      38.367 109.273  21.943  1.00 39.49           C  
ATOM   1420  C   LEU A 212      39.765 108.666  22.079  1.00 43.79           C  
ATOM   1421  O   LEU A 212      40.770 109.393  22.054  1.00 38.53           O  
ATOM   1422  CB  LEU A 212      37.754 109.533  23.332  1.00 39.74           C  
ATOM   1423  CG  LEU A 212      36.634 110.582  23.294  1.00 38.22           C  
ATOM   1424  CD1 LEU A 212      35.870 110.627  24.604  1.00 34.81           C  
ATOM   1425  CD2 LEU A 212      37.234 111.961  22.982  1.00 43.45           C  
ATOM   1426  N   ALA A 213      39.850 107.344  22.219  1.00 44.84           N  
ATOM   1427  CA  ALA A 213      41.165 106.697  22.329  1.00 45.42           C  
ATOM   1428  C   ALA A 213      41.875 106.711  20.967  1.00 45.70           C  
ATOM   1429  O   ALA A 213      43.077 106.795  20.917  1.00 43.87           O  
ATOM   1430  CB  ALA A 213      41.034 105.258  22.876  1.00 43.71           C  
ATOM   1431  N   TYR A 214      41.122 106.638  19.869  1.00 45.06           N  
ATOM   1432  CA  TYR A 214      41.700 106.667  18.501  1.00 46.64           C  
ATOM   1433  C   TYR A 214      42.243 108.056  18.140  1.00 47.93           C  
ATOM   1434  O   TYR A 214      43.290 108.182  17.478  1.00 45.43           O  
ATOM   1435  CB  TYR A 214      40.671 106.154  17.477  1.00 48.18           C  
ATOM   1436  CG  TYR A 214      40.660 106.806  16.090  1.00 48.72           C  
ATOM   1437  CD1 TYR A 214      41.355 106.239  15.015  1.00 46.31           C  
ATOM   1438  CD2 TYR A 214      39.918 107.964  15.853  1.00 44.75           C  
ATOM   1439  CE1 TYR A 214      41.339 106.837  13.740  1.00 49.88           C  
ATOM   1440  CE2 TYR A 214      39.892 108.576  14.579  1.00 48.92           C  
ATOM   1441  CZ  TYR A 214      40.603 108.011  13.527  1.00 48.08           C  
ATOM   1442  OH  TYR A 214      40.562 108.613  12.275  1.00 48.03           O  
ATOM   1443  N   LEU A 215      41.544 109.086  18.618  1.00 47.96           N  
ATOM   1444  CA  LEU A 215      41.898 110.470  18.350  1.00 49.04           C  
ATOM   1445  C   LEU A 215      43.187 110.914  19.053  1.00 51.99           C  
ATOM   1446  O   LEU A 215      43.758 111.948  18.697  1.00 52.45           O  
ATOM   1447  CB  LEU A 215      40.748 111.397  18.753  1.00 47.88           C  
ATOM   1448  CG  LEU A 215      39.492 111.361  17.885  1.00 45.57           C  
ATOM   1449  CD1 LEU A 215      38.421 112.256  18.486  1.00 41.96           C  
ATOM   1450  CD2 LEU A 215      39.803 111.747  16.453  1.00 47.30           C  
ATOM   1451  N   LYS A 216      43.641 110.140  20.037  1.00 55.60           N  
ATOM   1452  CA  LYS A 216      44.891 110.429  20.746  1.00 59.17           C  
ATOM   1453  C   LYS A 216      46.143 110.275  19.873  1.00 61.16           C  
ATOM   1454  O   LYS A 216      47.191 110.820  20.213  1.00 60.39           O  
ATOM   1455  CB  LYS A 216      45.022 109.554  21.997  1.00 58.53           C  
ATOM   1456  CG  LYS A 216      43.925 109.787  23.036  1.00 60.17           C  
ATOM   1457  CD  LYS A 216      44.419 109.545  24.463  1.00 61.32           C  
ATOM   1458  N   GLN A 217      46.038 109.557  18.754  1.00 63.65           N  
ATOM   1459  CA  GLN A 217      47.142 109.437  17.779  1.00 65.85           C  
ATOM   1460  C   GLN A 217      47.477 110.746  17.054  1.00 66.73           C  
ATOM   1461  O   GLN A 217      48.606 110.939  16.610  1.00 70.75           O  
ATOM   1462  CB  GLN A 217      46.791 108.448  16.668  1.00 67.62           C  
ATOM   1463  CG  GLN A 217      46.333 107.082  17.085  1.00 72.39           C  
ATOM   1464  CD  GLN A 217      45.607 106.402  15.948  1.00 72.32           C  
ATOM   1465  OE1 GLN A 217      46.163 106.233  14.857  1.00 75.72           O  
ATOM   1466  NE2 GLN A 217      44.355 106.034  16.182  1.00 72.61           N  
ATOM   1467  N   PHE A 218      46.495 111.630  16.909  1.00 67.24           N  
ATOM   1468  CA  PHE A 218      46.592 112.748  15.967  1.00 67.28           C  
ATOM   1469  C   PHE A 218      47.112 114.039  16.606  1.00 68.31           C  
ATOM   1470  O   PHE A 218      46.498 114.592  17.517  1.00 68.80           O  
ATOM   1471  CB  PHE A 218      45.220 112.967  15.305  1.00 67.28           C  
ATOM   1472  CG  PHE A 218      44.711 111.759  14.565  1.00 67.02           C  
ATOM   1473  CD1 PHE A 218      43.987 110.773  15.226  1.00 67.75           C  
ATOM   1474  CD2 PHE A 218      44.970 111.594  13.213  1.00 67.51           C  
ATOM   1475  CE1 PHE A 218      43.517 109.652  14.550  1.00 62.73           C  
ATOM   1476  CE2 PHE A 218      44.503 110.474  12.529  1.00 66.28           C  
ATOM   1477  CZ  PHE A 218      43.776 109.500  13.202  1.00 63.49           C  
TER    1478      PHE A 218                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
