
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  185 ( 1504),  selected  185 , name 2he3_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2he3_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     3_A      E       1           -
LGA    I     4_A      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    -       -      Q       6           -
LGA    A     5_A      S       7           #
LGA    K     6_A      M       8          3.384
LGA    S     7_A      I       9          3.718
LGA    -       -      N      10           -
LGA    -       -      S      11           -
LGA    F     8_A      F      12          2.209
LGA    Y     9_A      Y      13          2.561
LGA    D    10_A      A      14          1.501
LGA    L    11_A      F      15          0.943
LGA    S    12_A      E      16          2.111
LGA    A    13_A      V      17          1.397
LGA    I    14_A      K      18          1.380
LGA    N    15_A      D      19          1.323
LGA    L    16_A      A      20          0.914
LGA    D    17_A      K      21          2.640
LGA    G    18_A      G      22          2.830
LGA    E    19_A      R      23          3.372
LGA    K    20_A      T      24          3.099
LGA    V    21_A      V      25          2.962
LGA    D    22_A      S      26          1.434
LGA    F    23_A      L      27          1.710
LGA    N    24_A      E      28          1.406
LGA    T    25_A      K      29          1.337
LGA    F    26_A      Y      30          1.622
LGA    R    27_A      K      31          1.690
LGA    G    28_A      G      32          1.271
LGA    R    29_A      K      33          0.604
LGA    A    30_A      V      34          0.452
LGA    V    31_A      S      35          0.827
LGA    L    32_A      L      36          0.646
LGA    I    33_A      V      37          0.433
LGA    E    34_A      V      38          0.340
LGA    N    35_A      N      39          0.313
LGA    V    36_A      V      40          0.456
LGA    A    37_A      A      41          0.433
LGA    S    38_A      S      42          0.342
LGA    L    39_A      D      43          0.799
LGA    C    40_A      C      44          0.746
LGA    G    41_A      Q      45          0.595
LGA    T    42_A      L      46          0.983
LGA    T    43_A      T      47          0.428
LGA    T    44_A      D      48          0.645
LGA    R    45_A      R      49          0.786
LGA    D    46_A      N      50          0.488
LGA    F    47_A      Y      51          0.459
LGA    T    48_A      L      52          0.993
LGA    Q    49_A      G      53          1.100
LGA    L    50_A      L      54          1.034
LGA    N    51_A      K      55          1.170
LGA    E    52_A      E      56          1.207
LGA    L    53_A      L      57          1.077
LGA    Q    54_A      H      58          1.095
LGA    C    55_A      K      59          1.172
LGA    R    56_A      E      60          1.015
LGA    F    57_A      F      61          1.542
LGA    P    58_A      G      62          1.842
LGA    -       -      P      63           -
LGA    R    59_A      S      64          0.910
LGA    R    60_A      H      65          0.503
LGA    L    61_A      F      66          0.586
LGA    V    62_A      S      67          1.578
LGA    V    63_A      V      68          0.754
LGA    L    64_A      L      69          0.629
LGA    G    65_A      A      70          0.635
LGA    F    66_A      F      71          0.605
LGA    P    67_A      P      72          0.506
LGA    C    68_A      C      73          0.460
LGA    N    69_A      N      74          0.554
LGA    Q    70_A      Q      75          0.512
LGA    F    71_A      F      76          0.529
LGA    G    72_A      G      77          0.507
LGA    H    73_A      E      78          0.339
LGA    Q    74_A      S      79          0.556
LGA    E    75_A      E      80          0.502
LGA    N    76_A      P      81          0.473
LGA    C    77_A      R      82          0.468
LGA    Q    78_A      P      83          1.037
LGA    N    79_A      S      84          1.327
LGA    E    80_A      K      85          2.489
LGA    E    81_A      E      86          1.985
LGA    I    82_A      V      87          1.439
LGA    L    83_A      E      88          3.446
LGA    N    84_A      S      89          4.240
LGA    S    85_A      F      90          3.713
LGA    L    86_A      -       -           -
LGA    K    87_A      A      91          5.619
LGA    Y    88_A      R      92           -
LGA    V    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    P    91_A      -       -           -
LGA    G    92_A      -       -           -
LGA    G    93_A      K      93           #
LGA    G    94_A      N      94          3.870
LGA    Y    95_A      Y      95          2.406
LGA    Q    96_A      G      96          2.620
LGA    P    97_A      V      97          2.146
LGA    T    98_A      T      98          1.481
LGA    F    99_A      F      99          0.695
LGA    T   100_A      P     100          0.403
LGA    L   101_A      I     101          0.509
LGA    V   102_A      F     102          0.621
LGA    Q   103_A      H     103          0.623
LGA    K   104_A      K     104          0.659
LGA    C   105_A      I     105          0.810
LGA    E   106_A      K     106          0.780
LGA    V   107_A      I     107          0.921
LGA    N   108_A      L     108          0.985
LGA    G   109_A      G     109          0.820
LGA    Q   110_A      S     110          0.603
LGA    N   111_A      E     111          0.747
LGA    E   112_A      G     112          0.645
LGA    H   113_A      E     113          0.642
LGA    P   114_A      P     114          0.668
LGA    V   115_A      A     115          1.284
LGA    F   116_A      F     116          1.575
LGA    A   117_A      R     117          1.130
LGA    Y   118_A      F     118          0.640
LGA    L   119_A      L     119          0.716
LGA    K   120_A      V     120          0.660
LGA    D   121_A      D     121          0.642
LGA    K   122_A      S     122          0.497
LGA    L   123_A      S     123          0.219
LGA    P   124_A      K     124          0.683
LGA    Y   125_A      K     125          2.994
LGA    P   126_A      -       -           -
LGA    Y   127_A      -       -           -
LGA    D   128_A      -       -           -
LGA    D   129_A      -       -           -
LGA    P   130_A      -       -           -
LGA    F   131_A      -       -           -
LGA    S   132_A      -       -           -
LGA    L   133_A      -       -           -
LGA    M   134_A      -       -           -
LGA    T   135_A      -       -           -
LGA    D   136_A      -       -           -
LGA    P   137_A      -       -           -
LGA    K   138_A      -       -           -
LGA    L   139_A      -       -           -
LGA    I   140_A      -       -           -
LGA    I   141_A      -       -           -
LGA    W   142_A      -       -           -
LGA    S   143_A      -       -           -
LGA    P   144_A      -       -           -
LGA    V   145_A      -       -           -
LGA    R   146_A      -       -           -
LGA    R   147_A      -       -           -
LGA    S   148_A      -       -           -
LGA    D   149_A      E     126          2.471
LGA    V   150_A      P     127          1.140
LGA    A   151_A      R     128          0.639
LGA    W   152_A      W     129          0.425
LGA    N   153_A      N     130          0.295
LGA    F   154_A      F     131          0.353
LGA    E   155_A      W     132          0.253
LGA    K   156_A      K     133          0.252
LGA    F   157_A      Y     134          0.356
LGA    L   158_A      L     135          0.244
LGA    I   159_A      V     136          0.788
LGA    G   160_A      N     137          0.752
LGA    P   161_A      P     138          1.166
LGA    E   162_A      E     139          1.916
LGA    G   163_A      G     140          1.808
LGA    E   164_A      Q     141          1.530
LGA    P   165_A      V     142          0.929
LGA    F   166_A      V     143          0.418
LGA    R   167_A      K     144          0.547
LGA    R   168_A      F     145          0.992
LGA    Y   169_A      W     146          0.755
LGA    S   170_A      R     147          0.639
LGA    R   171_A      P     148          1.703
LGA    T   172_A      E     149          0.889
LGA    F   173_A      E     150          1.213
LGA    P   174_A      P     151          2.232
LGA    T   175_A      I     152          4.019
LGA    I   176_A      E     153          5.190
LGA    N   177_A      V     154          3.017
LGA    I   178_A      I     155          1.223
LGA    E   179_A      R     156          1.242
LGA    P   180_A      P     157          0.578
LGA    D   181_A      D     158          0.418
LGA    I   182_A      I     159          0.981
LGA    K   183_A      A     160          1.616
LGA    R   184_A      A     161          1.700
LGA    L   185_A      L     162          1.651
LGA    L   186_A      V     163          2.360
LGA    K   187_A      R     164          3.113
LGA    -       -      Q     165           -
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  185  174    5.0    152    1.64    33.55     81.382     8.757

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.096973 * X  +   0.971854 * Y  +   0.214700 * Z  +  -1.089269
  Y_new =   0.362581 * X  +   0.166398 * Y  +  -0.916977 * Z  + 138.273071
  Z_new =  -0.926893 * X  +   0.166768 * Y  +  -0.336240 * Z  +  23.534315 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.681167   -0.460425  [ DEG:   153.6196    -26.3804 ]
  Theta =   1.186049    1.955544  [ DEG:    67.9556    112.0444 ]
  Phi   =   1.309462   -1.832130  [ DEG:    75.0267   -104.9733 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2he3_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2he3_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  185  174   5.0  152   1.64   33.55  81.382
REMARK  ---------------------------------------------------------- 
MOLECULE 2he3_A
HEADER    OXIDOREDUCTASE                          21-JUN-06   2HE3              
TITLE     CRYSTAL STRUCTURE OF THE SELENOCYSTEINE TO CYSTEINE MUTANT            
TITLE    2 OF HUMAN GLUTATHIONINE PEROXIDASE 2 (GPX2)                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLUTATHIONE PEROXIDASE 2;                                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: GSHPX-2, GPX-2, GLUTATHIONE PEROXIDASE-                     
COMPND   5 GASTROINTESTINAL, GSHPX-GI, GLUTATHIONE PEROXIDASE-                  
COMPND   6 RELATED PROTEIN 2, GASTROINTESTINAL GLUTATHIONE PEROXIDASE,          
COMPND   7 GPRP;                                                                
COMPND   8 EC: 1.11.1.9;                                                        
COMPND   9 ENGINEERED: YES;                                                     
COMPND  10 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: GPX2;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: ROSETTA;                                   
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC-BSA4 (PET DERIVATIVE)                
KEYWDS    THIOREDOXIN FOLD, GASTROINTESTINAL GLUTATHIONE PEROXIDASE 2,          
KEYWDS   2 GPRP, GSHPX-GI, STRUCTURAL GENOMICS, STRUCTURAL GENOMICS             
KEYWDS   3 CONSORTIUM, SGC                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.JOHANSSON,K.L.KAVANAGH,A.ROJKOVA,O.GILEADI,F.VON DELFT,             
AUTHOR   2 C.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,A.EDWARDS,U.OPPERMANN,            
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   25-JUL-06 2HE3    0                                                
JRNL        AUTH   K.L.KAVANAGH,U.OPPERMANN                                     
JRNL        TITL   CRYSTAL STRUCTURE OF THE SELENOCYSTEINE TO                   
JRNL        TITL 2 CYSTEINE MUTANT OF HUMAN GLUTATHIONINE PEROXIDASE            
JRNL        TITL 3 2 (GPX2)                                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2HE3 A    4   188  UNP    P18283   GPX2_HUMAN       4    188             
SEQRES   1 A  208  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  208  GLY THR GLU ASN LEU TYR PHE GLN SER MET ILE ALA LYS          
SEQRES   3 A  208  SER PHE TYR ASP LEU SER ALA ILE ASN LEU ASP GLY GLU          
SEQRES   4 A  208  LYS VAL ASP PHE ASN THR PHE ARG GLY ARG ALA VAL LEU          
SEQRES   5 A  208  ILE GLU ASN VAL ALA SER LEU CYS GLY THR THR THR ARG          
SEQRES   6 A  208  ASP PHE THR GLN LEU ASN GLU LEU GLN CYS ARG PHE PRO          
SEQRES   7 A  208  ARG ARG LEU VAL VAL LEU GLY PHE PRO CYS ASN GLN PHE          
SEQRES   8 A  208  GLY HIS GLN GLU ASN CYS GLN ASN GLU GLU ILE LEU ASN          
SEQRES   9 A  208  SER LEU LYS TYR VAL ARG PRO GLY GLY GLY TYR GLN PRO          
SEQRES  10 A  208  THR PHE THR LEU VAL GLN LYS CYS GLU VAL ASN GLY GLN          
SEQRES  11 A  208  ASN GLU HIS PRO VAL PHE ALA TYR LEU LYS ASP LYS LEU          
SEQRES  12 A  208  PRO TYR PRO TYR ASP ASP PRO PHE SER LEU MET THR ASP          
SEQRES  13 A  208  PRO LYS LEU ILE ILE TRP SER PRO VAL ARG ARG SER ASP          
SEQRES  14 A  208  VAL ALA TRP ASN PHE GLU LYS PHE LEU ILE GLY PRO GLU          
SEQRES  15 A  208  GLY GLU PRO PHE ARG ARG TYR SER ARG THR PHE PRO THR          
SEQRES  16 A  208  ILE ASN ILE GLU PRO ASP ILE LYS ARG LEU LEU LYS VAL          
HET     CL      1       1                                                       
HET     CL      2       1                                                       
HETNAM      CL CHLORIDE ION                                                     
FORMUL   2   CL    2(CL 1-)                                                     
FORMUL   4  HOH   *135(H2 O)                                                    
CRYST1   41.308  117.212  120.157  90.00  90.00  90.00 I 2 2 2       8          
ATOM      1  N   MET A   3      33.950  98.569  -9.392  1.00 53.54           N  
ATOM      2  CA  MET A   3      32.761  98.961  -8.573  1.00 53.95           C  
ATOM      3  C   MET A   3      33.159  99.884  -7.409  1.00 52.83           C  
ATOM      4  O   MET A   3      32.702 101.025  -7.346  1.00 57.95           O  
ATOM      5  CB  MET A   3      32.034  97.712  -8.036  1.00 53.72           C  
ATOM      6  N   ILE A   4      34.029  99.392  -6.522  1.00 47.50           N  
ATOM      7  CA  ILE A   4      34.370 100.037  -5.230  1.00 44.06           C  
ATOM      8  C   ILE A   4      35.202 101.320  -5.460  1.00 40.37           C  
ATOM      9  O   ILE A   4      36.114 101.333  -6.298  1.00 35.62           O  
ATOM     10  CB  ILE A   4      35.190  99.037  -4.294  1.00 45.03           C  
ATOM     11  CG1 ILE A   4      34.432  97.719  -4.053  1.00 46.63           C  
ATOM     12  CG2 ILE A   4      35.549  99.654  -2.971  1.00 41.79           C  
ATOM     13  CD1 ILE A   4      33.040  97.909  -3.529  1.00 52.41           C  
ATOM     14  N   ALA A   5      34.895 102.390  -4.724  1.00 36.32           N  
ATOM     15  CA  ALA A   5      35.676 103.643  -4.827  1.00 36.03           C  
ATOM     16  C   ALA A   5      37.142 103.377  -4.497  1.00 36.21           C  
ATOM     17  O   ALA A   5      37.455 102.583  -3.606  1.00 37.86           O  
ATOM     18  CB  ALA A   5      35.112 104.736  -3.890  1.00 32.46           C  
ATOM     19  N   LYS A   6      38.044 104.053  -5.190  1.00 35.21           N  
ATOM     20  CA  LYS A   6      39.459 103.933  -4.869  1.00 36.73           C  
ATOM     21  C   LYS A   6      39.767 104.691  -3.574  1.00 32.66           C  
ATOM     22  O   LYS A   6      40.525 104.214  -2.748  1.00 35.05           O  
ATOM     23  CB  LYS A   6      40.331 104.447  -6.035  1.00 42.77           C  
ATOM     24  CG  LYS A   6      40.127 103.700  -7.367  1.00 54.75           C  
ATOM     25  CD  LYS A   6      40.444 102.198  -7.267  1.00 62.39           C  
ATOM     26  CE  LYS A   6      40.174 101.475  -8.588  1.00 62.33           C  
ATOM     27  NZ  LYS A   6      40.771 100.103  -8.619  1.00 63.11           N  
ATOM     28  N   SER A   7      39.154 105.853  -3.382  1.00 28.70           N  
ATOM     29  CA  SER A   7      39.326 106.629  -2.154  1.00 26.64           C  
ATOM     30  C   SER A   7      37.989 106.857  -1.481  1.00 24.99           C  
ATOM     31  O   SER A   7      36.953 107.055  -2.136  1.00 27.08           O  
ATOM     32  CB  SER A   7      40.020 107.977  -2.456  1.00 26.90           C  
ATOM     33  OG  SER A   7      40.096 108.831  -1.308  1.00 27.80           O  
ATOM     34  N   PHE A   8      38.016 106.826  -0.149  1.00 22.07           N  
ATOM     35  CA  PHE A   8      36.906 107.284   0.671  1.00 18.76           C  
ATOM     36  C   PHE A   8      36.410 108.673   0.208  1.00 18.45           C  
ATOM     37  O   PHE A   8      35.210 108.918   0.136  1.00 21.60           O  
ATOM     38  CB  PHE A   8      37.364 107.309   2.131  1.00 19.69           C  
ATOM     39  CG  PHE A   8      36.351 107.826   3.076  1.00 17.89           C  
ATOM     40  CD1 PHE A   8      35.225 107.081   3.383  1.00 16.89           C  
ATOM     41  CD2 PHE A   8      36.525 109.052   3.699  1.00 18.03           C  
ATOM     42  CE1 PHE A   8      34.278 107.560   4.289  1.00 21.04           C  
ATOM     43  CE2 PHE A   8      35.582 109.515   4.612  1.00 18.66           C  
ATOM     44  CZ  PHE A   8      34.456 108.769   4.896  1.00 21.04           C  
ATOM     45  N   TYR A   9      37.342 109.554  -0.156  1.00 18.97           N  
ATOM     46  CA  TYR A   9      37.014 110.923  -0.521  1.00 18.61           C  
ATOM     47  C   TYR A   9      36.339 111.064  -1.893  1.00 19.35           C  
ATOM     48  O   TYR A   9      35.809 112.117  -2.171  1.00 16.57           O  
ATOM     49  CB  TYR A   9      38.264 111.793  -0.434  1.00 19.62           C  
ATOM     50  CG  TYR A   9      38.839 111.819   0.943  1.00 17.25           C  
ATOM     51  CD1 TYR A   9      38.044 112.144   2.037  1.00 22.47           C  
ATOM     52  CD2 TYR A   9      40.186 111.514   1.174  1.00 20.29           C  
ATOM     53  CE1 TYR A   9      38.561 112.143   3.312  1.00 17.93           C  
ATOM     54  CE2 TYR A   9      40.727 111.537   2.480  1.00 17.29           C  
ATOM     55  CZ  TYR A   9      39.900 111.850   3.528  1.00 17.04           C  
ATOM     56  OH  TYR A   9      40.391 111.914   4.810  1.00 17.55           O  
ATOM     57  N   ASP A  10      36.311 109.989  -2.696  1.00 19.95           N  
ATOM     58  CA  ASP A  10      35.620 109.959  -3.990  1.00 22.52           C  
ATOM     59  C   ASP A  10      34.128 109.718  -3.829  1.00 23.09           C  
ATOM     60  O   ASP A  10      33.372 109.829  -4.787  1.00 24.11           O  
ATOM     61  CB  ASP A  10      36.156 108.830  -4.880  1.00 24.54           C  
ATOM     62  CG  ASP A  10      37.599 109.019  -5.271  1.00 25.00           C  
ATOM     63  OD1 ASP A  10      38.051 110.162  -5.278  1.00 24.44           O  
ATOM     64  OD2 ASP A  10      38.284 108.015  -5.547  1.00 32.89           O  
ATOM     65  N   LEU A  11      33.702 109.393  -2.622  1.00 20.29           N  
ATOM     66  CA  LEU A  11      32.318 109.094  -2.381  1.00 18.62           C  
ATOM     67  C   LEU A  11      31.468 110.346  -2.214  1.00 21.72           C  
ATOM     68  O   LEU A  11      31.969 111.455  -2.066  1.00 16.52           O  
ATOM     69  CB  LEU A  11      32.165 108.166  -1.169  1.00 14.94           C  
ATOM     70  CG  LEU A  11      32.824 106.770  -1.175  1.00 19.84           C  
ATOM     71  CD1 LEU A  11      32.977 106.198   0.274  1.00 24.33           C  
ATOM     72  CD2 LEU A  11      32.050 105.819  -2.079  1.00 16.12           C  
ATOM     73  N   SER A  12      30.153 110.141  -2.277  1.00 21.26           N  
ATOM     74  CA  SER A  12      29.209 111.180  -1.995  1.00 20.01           C  
ATOM     75  C   SER A  12      27.871 110.562  -1.677  1.00 20.38           C  
ATOM     76  O   SER A  12      27.644 109.361  -1.841  1.00 20.08           O  
ATOM     77  CB  SER A  12      29.033 112.102  -3.206  1.00 26.40           C  
ATOM     78  OG  SER A  12      28.443 111.395  -4.311  1.00 22.59           O  
ATOM     79  N   ALA A  13      26.977 111.419  -1.235  1.00 22.59           N  
ATOM     80  CA  ALA A  13      25.648 111.029  -0.819  1.00 23.34           C  
ATOM     81  C   ALA A  13      24.745 112.249  -1.026  1.00 23.85           C  
ATOM     82  O   ALA A  13      25.235 113.352  -1.263  1.00 22.56           O  
ATOM     83  CB  ALA A  13      25.681 110.597   0.635  1.00 20.13           C  
ATOM     84  N   ILE A  14      23.436 112.036  -1.002  1.00 24.61           N  
ATOM     85  CA  ILE A  14      22.457 113.101  -1.095  1.00 24.26           C  
ATOM     86  C   ILE A  14      21.756 113.227   0.266  1.00 22.09           C  
ATOM     87  O   ILE A  14      21.230 112.250   0.811  1.00 23.40           O  
ATOM     88  CB  ILE A  14      21.407 112.837  -2.221  1.00 23.05           C  
ATOM     89  CG1 ILE A  14      22.061 112.421  -3.528  1.00 29.33           C  
ATOM     90  CG2 ILE A  14      20.527 114.071  -2.446  1.00 20.81           C  
ATOM     91  CD1 ILE A  14      23.046 113.429  -4.068  1.00 35.13           C  
ATOM     92  N   ASN A  15      21.775 114.417   0.846  1.00 21.74           N  
ATOM     93  CA  ASN A  15      21.037 114.627   2.091  1.00 23.75           C  
ATOM     94  C   ASN A  15      19.527 114.770   1.854  1.00 22.28           C  
ATOM     95  O   ASN A  15      19.069 114.812   0.713  1.00 25.99           O  
ATOM     96  CB  ASN A  15      21.637 115.760   2.949  1.00 24.08           C  
ATOM     97  CG  ASN A  15      21.364 117.147   2.406  1.00 28.43           C  
ATOM     98  OD1 ASN A  15      20.406 117.380   1.669  1.00 29.33           O  
ATOM     99  ND2 ASN A  15      22.219 118.082   2.774  1.00 30.10           N  
ATOM    100  N   LEU A  16      18.769 114.840   2.940  1.00 29.21           N  
ATOM    101  CA  LEU A  16      17.307 114.832   2.870  1.00 30.91           C  
ATOM    102  C   LEU A  16      16.760 116.058   2.157  1.00 32.90           C  
ATOM    103  O   LEU A  16      15.678 115.986   1.568  1.00 36.83           O  
ATOM    104  CB  LEU A  16      16.670 114.689   4.255  1.00 32.88           C  
ATOM    105  CG  LEU A  16      16.823 113.370   5.013  1.00 28.38           C  
ATOM    106  CD1 LEU A  16      16.140 113.506   6.400  1.00 28.60           C  
ATOM    107  CD2 LEU A  16      16.268 112.184   4.221  1.00 30.79           C  
ATOM    108  N   ASP A  17      17.522 117.154   2.156  1.00 34.20           N  
ATOM    109  CA  ASP A  17      17.165 118.341   1.371  1.00 35.35           C  
ATOM    110  C   ASP A  17      17.587 118.251  -0.082  1.00 34.71           C  
ATOM    111  O   ASP A  17      17.408 119.206  -0.820  1.00 37.05           O  
ATOM    112  CB  ASP A  17      17.784 119.596   1.973  1.00 40.61           C  
ATOM    113  CG  ASP A  17      17.217 119.921   3.344  1.00 49.46           C  
ATOM    114  OD1 ASP A  17      15.998 119.701   3.544  1.00 54.02           O  
ATOM    115  OD2 ASP A  17      17.987 120.415   4.204  1.00 55.27           O  
ATOM    116  N   GLY A  18      18.126 117.111  -0.505  1.00 31.29           N  
ATOM    117  CA  GLY A  18      18.489 116.896  -1.911  1.00 29.63           C  
ATOM    118  C   GLY A  18      19.833 117.495  -2.287  1.00 27.24           C  
ATOM    119  O   GLY A  18      20.158 117.570  -3.461  1.00 32.01           O  
ATOM    120  N   GLU A  19      20.601 117.925  -1.288  1.00 28.17           N  
ATOM    121  CA  GLU A  19      21.935 118.483  -1.497  1.00 32.07           C  
ATOM    122  C   GLU A  19      23.010 117.397  -1.448  1.00 27.43           C  
ATOM    123  O   GLU A  19      22.948 116.480  -0.639  1.00 23.17           O  
ATOM    124  CB  GLU A  19      22.270 119.492  -0.413  1.00 31.04           C  
ATOM    125  CG  GLU A  19      21.327 120.670  -0.302  1.00 41.41           C  
ATOM    126  CD  GLU A  19      21.586 121.457   0.973  1.00 44.63           C  
ATOM    127  OE1 GLU A  19      21.188 120.990   2.069  1.00 58.54           O  
ATOM    128  OE2 GLU A  19      22.204 122.538   0.877  1.00 65.98           O  
ATOM    129  N   LYS A  20      24.011 117.544  -2.304  1.00 25.61           N  
ATOM    130  CA  LYS A  20      25.108 116.625  -2.365  1.00 29.05           C  
ATOM    131  C   LYS A  20      25.998 116.848  -1.152  1.00 27.70           C  
ATOM    132  O   LYS A  20      26.276 117.982  -0.759  1.00 34.15           O  
ATOM    133  CB  LYS A  20      25.898 116.817  -3.661  1.00 30.92           C  
ATOM    134  CG  LYS A  20      27.041 115.845  -3.840  1.00 34.12           C  
ATOM    135  CD  LYS A  20      27.842 116.185  -5.038  1.00 40.30           C  
ATOM    136  CE  LYS A  20      29.012 115.242  -5.190  1.00 41.65           C  
ATOM    137  NZ  LYS A  20      29.453 115.252  -6.636  1.00 43.45           N  
ATOM    138  N   VAL A  21      26.368 115.748  -0.526  1.00 25.56           N  
ATOM    139  CA  VAL A  21      27.382 115.705   0.507  1.00 24.06           C  
ATOM    140  C   VAL A  21      28.623 115.124  -0.153  1.00 23.07           C  
ATOM    141  O   VAL A  21      28.668 113.926  -0.455  1.00 22.06           O  
ATOM    142  CB  VAL A  21      26.941 114.804   1.656  1.00 24.81           C  
ATOM    143  CG1 VAL A  21      28.090 114.592   2.641  1.00 24.06           C  
ATOM    144  CG2 VAL A  21      25.683 115.364   2.343  1.00 22.75           C  
ATOM    145  N   ASP A  22      29.615 115.979  -0.394  1.00 18.71           N  
ATOM    146  CA  ASP A  22      30.846 115.584  -1.082  1.00 20.89           C  
ATOM    147  C   ASP A  22      31.855 115.119  -0.024  1.00 18.12           C  
ATOM    148  O   ASP A  22      32.207 115.873   0.859  1.00 22.01           O  
ATOM    149  CB  ASP A  22      31.414 116.759  -1.912  1.00 20.29           C  
ATOM    150  CG  ASP A  22      32.459 116.320  -2.943  1.00 22.01           C  
ATOM    151  OD1 ASP A  22      33.410 115.584  -2.574  1.00 23.27           O  
ATOM    152  OD2 ASP A  22      32.345 116.744  -4.124  1.00 28.91           O  
ATOM    153  N   PHE A  23      32.291 113.865  -0.097  1.00 17.41           N  
ATOM    154  CA  PHE A  23      33.187 113.349   0.913  1.00 17.75           C  
ATOM    155  C   PHE A  23      34.581 114.031   0.939  1.00 18.40           C  
ATOM    156  O   PHE A  23      35.319 113.818   1.870  1.00 17.96           O  
ATOM    157  CB  PHE A  23      33.346 111.838   0.801  1.00 18.59           C  
ATOM    158  CG  PHE A  23      32.206 111.043   1.408  1.00 15.23           C  
ATOM    159  CD1 PHE A  23      30.877 111.447   1.270  1.00 16.99           C  
ATOM    160  CD2 PHE A  23      32.460 109.852   2.038  1.00 19.45           C  
ATOM    161  CE1 PHE A  23      29.829 110.694   1.831  1.00 19.17           C  
ATOM    162  CE2 PHE A  23      31.435 109.090   2.576  1.00 20.35           C  
ATOM    163  CZ  PHE A  23      30.117 109.514   2.467  1.00 20.76           C  
ATOM    164  N   ASN A  24      34.941 114.825  -0.071  1.00 20.00           N  
ATOM    165  CA  ASN A  24      36.168 115.623   0.025  1.00 19.91           C  
ATOM    166  C   ASN A  24      36.132 116.569   1.203  1.00 16.80           C  
ATOM    167  O   ASN A  24      37.168 116.888   1.753  1.00 16.03           O  
ATOM    168  CB  ASN A  24      36.446 116.437  -1.249  1.00 15.59           C  
ATOM    169  CG  ASN A  24      37.177 115.637  -2.311  1.00 17.24           C  
ATOM    170  OD1 ASN A  24      38.164 114.930  -2.033  1.00 15.95           O  
ATOM    171  ND2 ASN A  24      36.714 115.751  -3.531  1.00 21.38           N  
ATOM    172  N   THR A  25      34.929 117.009   1.586  1.00 19.23           N  
ATOM    173  CA  THR A  25      34.769 117.898   2.722  1.00 20.21           C  
ATOM    174  C   THR A  25      35.113 117.183   4.028  1.00 20.20           C  
ATOM    175  O   THR A  25      35.230 117.829   5.066  1.00 20.99           O  
ATOM    176  CB  THR A  25      33.334 118.500   2.820  1.00 19.96           C  
ATOM    177  OG1 THR A  25      32.391 117.450   3.022  1.00 24.66           O  
ATOM    178  CG2 THR A  25      32.961 119.305   1.550  1.00 16.41           C  
ATOM    179  N   PHE A  26      35.284 115.857   3.982  1.00 20.38           N  
ATOM    180  CA  PHE A  26      35.667 115.106   5.183  1.00 18.83           C  
ATOM    181  C   PHE A  26      37.170 115.017   5.426  1.00 18.29           C  
ATOM    182  O   PHE A  26      37.557 114.439   6.407  1.00 18.74           O  
ATOM    183  CB  PHE A  26      35.098 113.694   5.173  1.00 20.89           C  
ATOM    184  CG  PHE A  26      33.609 113.615   5.021  1.00 16.81           C  
ATOM    185  CD1 PHE A  26      32.793 114.717   5.223  1.00 18.26           C  
ATOM    186  CD2 PHE A  26      33.011 112.400   4.701  1.00 20.97           C  
ATOM    187  CE1 PHE A  26      31.428 114.625   5.043  1.00 16.03           C  
ATOM    188  CE2 PHE A  26      31.653 112.298   4.566  1.00 21.05           C  
ATOM    189  CZ  PHE A  26      30.850 113.425   4.736  1.00 15.36           C  
ATOM    190  N   ARG A  27      38.010 115.605   4.566  1.00 20.83           N  
ATOM    191  CA  ARG A  27      39.472 115.484   4.719  1.00 19.69           C  
ATOM    192  C   ARG A  27      39.938 116.149   6.006  1.00 19.02           C  
ATOM    193  O   ARG A  27      39.554 117.257   6.306  1.00 20.14           O  
ATOM    194  CB  ARG A  27      40.203 116.083   3.514  1.00 15.67           C  
ATOM    195  CG  ARG A  27      39.992 115.306   2.255  1.00 15.92           C  
ATOM    196  CD  ARG A  27      40.494 116.026   1.073  1.00 16.46           C  
ATOM    197  NE  ARG A  27      40.283 115.274  -0.147  1.00 17.20           N  
ATOM    198  CZ  ARG A  27      41.126 114.373  -0.629  1.00 22.14           C  
ATOM    199  NH1 ARG A  27      42.244 114.081   0.011  1.00 23.68           N  
ATOM    200  NH2 ARG A  27      40.855 113.752  -1.761  1.00 22.34           N  
ATOM    201  N   GLY A  28      40.728 115.428   6.789  1.00 19.85           N  
ATOM    202  CA  GLY A  28      41.174 115.929   8.062  1.00 20.48           C  
ATOM    203  C   GLY A  28      40.169 115.733   9.176  1.00 20.42           C  
ATOM    204  O   GLY A  28      40.424 116.133  10.303  1.00 21.51           O  
ATOM    205  N   ARG A  29      39.029 115.124   8.873  1.00 22.46           N  
ATOM    206  CA  ARG A  29      38.010 114.855   9.888  0.50 19.43           C  
ATOM    208  C   ARG A  29      37.817 113.354  10.021  1.00 20.82           C  
ATOM    209  O   ARG A  29      37.901 112.632   9.044  1.00 23.68           O  
ATOM    210  CB  ARG A  29      36.686 115.555   9.538  0.50 17.94           C  
ATOM    212  CG  ARG A  29      36.801 117.071   9.427  0.50 16.72           C  
ATOM    214  CD  ARG A  29      35.516 117.740   8.933  0.50 11.69           C  
ATOM    216  NE  ARG A  29      35.475 119.160   9.288  0.50 24.88           N  
ATOM    218  CZ  ARG A  29      34.376 119.927   9.304  0.50 24.44           C  
ATOM    220  NH1 ARG A  29      33.181 119.442   8.972  0.50 25.49           N  
ATOM    222  NH2 ARG A  29      34.465 121.193   9.657  0.50 23.22           N  
ATOM    224  N   ALA A  30      37.600 112.903  11.259  1.00 20.94           N  
ATOM    225  CA  ALA A  30      37.084 111.587  11.524  1.00 20.10           C  
ATOM    226  C   ALA A  30      35.596 111.574  11.080  1.00 20.76           C  
ATOM    227  O   ALA A  30      34.887 112.614  11.177  1.00 18.21           O  
ATOM    228  CB  ALA A  30      37.206 111.223  13.013  1.00 13.22           C  
ATOM    229  N   VAL A  31      35.150 110.408  10.595  1.00 21.57           N  
ATOM    230  CA  VAL A  31      33.778 110.216  10.106  1.00 21.42           C  
ATOM    231  C   VAL A  31      33.173 108.972  10.750  1.00 20.54           C  
ATOM    232  O   VAL A  31      33.791 107.888  10.778  1.00 19.47           O  
ATOM    233  CB  VAL A  31      33.676 110.149   8.541  1.00 21.24           C  
ATOM    234  CG1 VAL A  31      32.190 110.084   8.048  1.00 14.47           C  
ATOM    235  CG2 VAL A  31      34.380 111.341   7.900  1.00 16.99           C  
ATOM    236  N   LEU A  32      31.984 109.162  11.331  1.00 18.13           N  
ATOM    237  CA  LEU A  32      31.172 108.083  11.857  1.00 18.39           C  
ATOM    238  C   LEU A  32      29.955 107.911  10.912  1.00 17.98           C  
ATOM    239  O   LEU A  32      29.174 108.834  10.716  1.00 17.01           O  
ATOM    240  CB  LEU A  32      30.737 108.362  13.297  1.00 21.52           C  
ATOM    241  CG  LEU A  32      29.916 107.229  13.949  1.00 24.64           C  
ATOM    242  CD1 LEU A  32      30.710 105.890  13.912  1.00 19.21           C  
ATOM    243  CD2 LEU A  32      29.437 107.620  15.381  1.00 20.61           C  
ATOM    244  N   ILE A  33      29.874 106.751  10.274  1.00 19.87           N  
ATOM    245  CA  ILE A  33      28.731 106.407   9.424  1.00 21.62           C  
ATOM    246  C   ILE A  33      27.960 105.265  10.084  1.00 21.92           C  
ATOM    247  O   ILE A  33      28.544 104.274  10.464  1.00 19.22           O  
ATOM    248  CB  ILE A  33      29.174 106.047   7.973  1.00 20.54           C  
ATOM    249  CG1 ILE A  33      29.736 107.307   7.282  1.00 19.39           C  
ATOM    250  CG2 ILE A  33      27.991 105.366   7.146  1.00 15.73           C  
ATOM    251  CD1 ILE A  33      30.453 107.093   5.931  1.00 19.73           C  
ATOM    252  N   GLU A  34      26.653 105.468  10.287  1.00 22.48           N  
ATOM    253  CA  GLU A  34      25.745 104.411  10.725  1.00 22.56           C  
ATOM    254  C   GLU A  34      24.593 104.273   9.723  1.00 21.20           C  
ATOM    255  O   GLU A  34      24.129 105.256   9.196  1.00 24.64           O  
ATOM    256  CB  GLU A  34      25.157 104.713  12.121  1.00 22.57           C  
ATOM    257  CG  GLU A  34      26.170 104.898  13.222  1.00 26.29           C  
ATOM    258  CD  GLU A  34      25.611 104.676  14.610  1.00 22.10           C  
ATOM    259  OE1 GLU A  34      24.467 104.237  14.757  1.00 27.09           O  
ATOM    260  OE2 GLU A  34      26.349 104.902  15.571  1.00 26.39           O  
ATOM    261  N   ASN A  35      24.146 103.054   9.471  1.00 20.45           N  
ATOM    262  CA  ASN A  35      22.810 102.822   8.910  1.00 17.37           C  
ATOM    263  C   ASN A  35      21.813 102.924  10.044  1.00 16.22           C  
ATOM    264  O   ASN A  35      22.012 102.334  11.112  1.00 19.99           O  
ATOM    265  CB  ASN A  35      22.667 101.476   8.149  1.00 20.20           C  
ATOM    266  CG  ASN A  35      22.913 100.252   9.036  1.00 18.58           C  
ATOM    267  OD1 ASN A  35      23.990 100.098   9.613  1.00 22.10           O  
ATOM    268  ND2 ASN A  35      21.903  99.383   9.144  1.00 14.67           N  
ATOM    269  N   VAL A  36      20.753 103.686   9.810  1.00 19.02           N  
ATOM    270  CA  VAL A  36      19.809 104.041  10.868  1.00 20.41           C  
ATOM    271  C   VAL A  36      18.386 103.646  10.475  1.00 23.71           C  
ATOM    272  O   VAL A  36      18.080 103.389   9.313  1.00 21.76           O  
ATOM    273  CB  VAL A  36      19.902 105.561  11.257  1.00 19.23           C  
ATOM    274  CG1 VAL A  36      21.311 105.922  11.660  1.00 16.25           C  
ATOM    275  CG2 VAL A  36      19.365 106.497  10.146  1.00 16.89           C  
ATOM    276  N   ALA A  37      17.523 103.551  11.464  1.00 24.38           N  
ATOM    277  CA  ALA A  37      16.127 103.327  11.198  1.00 27.63           C  
ATOM    278  C   ALA A  37      15.313 104.117  12.220  1.00 30.32           C  
ATOM    279  O   ALA A  37      15.657 104.150  13.388  1.00 28.11           O  
ATOM    280  CB  ALA A  37      15.811 101.831  11.234  1.00 22.35           C  
ATOM    281  N   SER A  38      14.245 104.769  11.764  1.00 40.15           N  
ATOM    282  CA  SER A  38      13.380 105.616  12.630  1.00 46.36           C  
ATOM    283  C   SER A  38      12.509 104.844  13.647  1.00 49.97           C  
ATOM    284  O   SER A  38      12.183 105.375  14.714  1.00 49.81           O  
ATOM    285  CB  SER A  38      12.445 106.492  11.767  1.00 44.94           C  
ATOM    286  OG  SER A  38      13.171 107.473  11.055  1.00 54.97           O  
ATOM    287  N   LEU A  39      12.092 103.627  13.307  1.00 51.84           N  
ATOM    288  CA  LEU A  39      11.211 102.862  14.184  1.00 55.27           C  
ATOM    289  C   LEU A  39      11.841 101.519  14.574  1.00 57.92           C  
ATOM    290  O   LEU A  39      11.194 100.460  14.484  1.00 58.31           O  
ATOM    291  CB  LEU A  39       9.817 102.711  13.543  1.00 56.69           C  
ATOM    292  CG  LEU A  39       8.828 103.875  13.768  1.00 59.67           C  
ATOM    293  CD1 LEU A  39       7.803 103.927  12.600  1.00 56.53           C  
ATOM    294  CD2 LEU A  39       8.098 103.840  15.171  1.00 44.74           C  
ATOM    295  N   CYS A  40      13.099 101.596  15.040  1.00 61.31           N  
ATOM    296  CA  CYS A  40      13.846 100.460  15.623  1.00 63.72           C  
ATOM    297  C   CYS A  40      13.798 100.490  17.178  1.00 65.77           C  
ATOM    298  O   CYS A  40      13.534 101.533  17.783  1.00 66.89           O  
ATOM    299  CB  CYS A  40      15.309 100.470  15.098  1.00 62.63           C  
ATOM    300  SG  CYS A  40      16.432  99.028  15.524  1.00 63.91           S  
ATOM    301  N   GLY A  41      14.035  99.341  17.815  1.00 67.37           N  
ATOM    302  CA  GLY A  41      14.174  99.262  19.285  1.00 68.16           C  
ATOM    303  C   GLY A  41      15.292 100.135  19.879  1.00 68.22           C  
ATOM    304  O   GLY A  41      15.152 100.652  21.002  1.00 67.53           O  
ATOM    305  N   THR A  42      16.401 100.288  19.137  1.00 66.47           N  
ATOM    306  CA  THR A  42      17.511 101.178  19.541  1.00 64.26           C  
ATOM    307  C   THR A  42      17.513 102.544  18.812  1.00 59.21           C  
ATOM    308  O   THR A  42      18.539 103.237  18.813  1.00 59.44           O  
ATOM    309  CB  THR A  42      18.922 100.506  19.376  1.00 65.78           C  
ATOM    310  OG1 THR A  42      19.227 100.313  17.986  1.00 67.84           O  
ATOM    311  CG2 THR A  42      19.004  99.170  20.121  1.00 65.62           C  
ATOM    312  N   THR A  43      16.380 102.938  18.218  1.00 52.40           N  
ATOM    313  CA  THR A  43      16.237 104.284  17.613  1.00 52.83           C  
ATOM    314  C   THR A  43      16.548 105.420  18.621  1.00 51.16           C  
ATOM    315  O   THR A  43      17.477 106.211  18.406  1.00 47.10           O  
ATOM    316  CB  THR A  43      14.814 104.517  16.958  1.00 54.24           C  
ATOM    317  OG1 THR A  43      14.667 103.687  15.784  1.00 45.95           O  
ATOM    318  CG2 THR A  43      14.595 106.016  16.579  1.00 49.58           C  
ATOM    319  N   THR A  44      15.792 105.494  19.718  1.00 48.83           N  
ATOM    320  CA  THR A  44      15.948 106.611  20.657  1.00 46.58           C  
ATOM    321  C   THR A  44      17.397 106.726  21.159  1.00 43.88           C  
ATOM    322  O   THR A  44      17.939 107.832  21.159  1.00 39.39           O  
ATOM    323  CB  THR A  44      14.929 106.541  21.819  1.00 44.21           C  
ATOM    324  OG1 THR A  44      13.612 106.601  21.268  1.00 44.70           O  
ATOM    325  CG2 THR A  44      15.121 107.708  22.822  1.00 40.88           C  
ATOM    326  N   ARG A  45      18.008 105.585  21.532  1.00 40.83           N  
ATOM    327  CA  ARG A  45      19.353 105.559  22.136  1.00 36.91           C  
ATOM    328  C   ARG A  45      20.406 105.968  21.141  1.00 32.76           C  
ATOM    329  O   ARG A  45      21.251 106.815  21.438  1.00 27.84           O  
ATOM    330  CB  ARG A  45      19.703 104.167  22.661  1.00 37.23           C  
ATOM    331  CG  ARG A  45      20.860 104.165  23.641  1.00 38.98           C  
ATOM    332  N   ASP A  46      20.368 105.374  19.949  1.00 29.52           N  
ATOM    333  CA  ASP A  46      21.388 105.676  18.962  1.00 29.18           C  
ATOM    334  C   ASP A  46      21.264 107.100  18.433  1.00 28.05           C  
ATOM    335  O   ASP A  46      22.287 107.760  18.248  1.00 24.53           O  
ATOM    336  CB  ASP A  46      21.403 104.653  17.848  1.00 35.09           C  
ATOM    337  CG  ASP A  46      22.087 103.339  18.270  1.00 31.53           C  
ATOM    338  OD1 ASP A  46      23.316 103.333  18.548  1.00 42.05           O  
ATOM    339  OD2 ASP A  46      21.378 102.323  18.333  1.00 44.44           O  
ATOM    340  N   PHE A  47      20.026 107.578  18.234  1.00 24.59           N  
ATOM    341  CA  PHE A  47      19.789 108.928  17.764  1.00 24.84           C  
ATOM    342  C   PHE A  47      20.242 109.998  18.765  1.00 23.84           C  
ATOM    343  O   PHE A  47      20.785 111.022  18.365  1.00 25.62           O  
ATOM    344  CB  PHE A  47      18.319 109.125  17.298  1.00 24.96           C  
ATOM    345  CG  PHE A  47      18.091 108.739  15.828  1.00 22.69           C  
ATOM    346  CD1 PHE A  47      18.437 109.604  14.807  1.00 33.54           C  
ATOM    347  CD2 PHE A  47      17.515 107.529  15.489  1.00 32.64           C  
ATOM    348  CE1 PHE A  47      18.219 109.266  13.490  1.00 30.50           C  
ATOM    349  CE2 PHE A  47      17.309 107.182  14.177  1.00 26.77           C  
ATOM    350  CZ  PHE A  47      17.668 108.032  13.181  1.00 27.39           C  
ATOM    351  N   THR A  48      20.018 109.745  20.049  1.00 23.74           N  
ATOM    352  CA  THR A  48      20.494 110.605  21.130  1.00 25.97           C  
ATOM    353  C   THR A  48      22.013 110.609  21.225  1.00 24.46           C  
ATOM    354  O   THR A  48      22.627 111.657  21.450  1.00 27.74           O  
ATOM    355  CB  THR A  48      19.921 110.142  22.503  1.00 28.97           C  
ATOM    356  OG1 THR A  48      18.493 110.260  22.483  1.00 42.99           O  
ATOM    357  CG2 THR A  48      20.465 111.001  23.647  1.00 41.90           C  
ATOM    358  N   GLN A  49      22.608 109.433  21.053  1.00 22.02           N  
ATOM    359  CA  GLN A  49      24.039 109.254  21.181  1.00 22.44           C  
ATOM    360  C   GLN A  49      24.753 109.795  19.942  1.00 22.05           C  
ATOM    361  O   GLN A  49      25.845 110.343  20.063  1.00 19.26           O  
ATOM    362  CB  GLN A  49      24.390 107.786  21.490  1.00 20.46           C  
ATOM    363  CG  GLN A  49      23.973 107.338  22.893  1.00 23.43           C  
ATOM    364  CD  GLN A  49      24.349 105.913  23.225  1.00 25.53           C  
ATOM    365  OE1 GLN A  49      24.953 105.203  22.426  1.00 25.51           O  
ATOM    366  NE2 GLN A  49      24.003 105.487  24.431  1.00 27.88           N  
ATOM    367  N   LEU A  50      24.123 109.697  18.762  1.00 22.20           N  
ATOM    368  CA  LEU A  50      24.692 110.307  17.554  1.00 20.09           C  
ATOM    369  C   LEU A  50      24.728 111.838  17.679  1.00 18.69           C  
ATOM    370  O   LEU A  50      25.698 112.478  17.287  1.00 19.52           O  
ATOM    371  CB  LEU A  50      23.943 109.872  16.282  1.00 19.04           C  
ATOM    372  CG  LEU A  50      24.103 108.405  15.868  1.00 24.88           C  
ATOM    373  CD1 LEU A  50      22.976 107.970  14.905  1.00 25.71           C  
ATOM    374  CD2 LEU A  50      25.492 108.221  15.264  1.00 23.71           C  
ATOM    375  N   ASN A  51      23.661 112.425  18.208  1.00 17.15           N  
ATOM    376  CA  ASN A  51      23.663 113.845  18.465  1.00 17.22           C  
ATOM    377  C   ASN A  51      24.773 114.250  19.446  1.00 21.43           C  
ATOM    378  O   ASN A  51      25.468 115.247  19.232  1.00 19.73           O  
ATOM    379  CB  ASN A  51      22.317 114.325  19.035  1.00 18.79           C  
ATOM    380  CG  ASN A  51      21.270 114.611  17.959  1.00 21.59           C  
ATOM    381  OD1 ASN A  51      21.447 114.302  16.788  1.00 26.81           O  
ATOM    382  ND2 ASN A  51      20.203 115.252  18.361  1.00 20.62           N  
ATOM    383  N   GLU A  52      24.893 113.504  20.539  1.00 19.21           N  
ATOM    384  CA  GLU A  52      25.871 113.809  21.557  1.00 19.18           C  
ATOM    385  C   GLU A  52      27.303 113.797  20.987  1.00 20.33           C  
ATOM    386  O   GLU A  52      28.057 114.750  21.175  1.00 20.88           O  
ATOM    387  CB  GLU A  52      25.738 112.841  22.709  1.00 22.35           C  
ATOM    388  CG  GLU A  52      26.548 113.266  23.914  1.00 30.01           C  
ATOM    389  CD  GLU A  52      26.127 112.530  25.168  1.00 42.90           C  
ATOM    390  OE1 GLU A  52      26.255 111.282  25.199  1.00 55.31           O  
ATOM    391  OE2 GLU A  52      25.651 113.195  26.113  1.00 42.09           O  
ATOM    392  N   LEU A  53      27.656 112.744  20.258  1.00 20.28           N  
ATOM    393  CA  LEU A  53      28.944 112.681  19.633  1.00 19.87           C  
ATOM    394  C   LEU A  53      29.210 113.819  18.687  1.00 21.09           C  
ATOM    395  O   LEU A  53      30.310 114.337  18.682  1.00 21.50           O  
ATOM    396  CB  LEU A  53      29.166 111.349  18.905  1.00 22.36           C  
ATOM    397  CG  LEU A  53      29.502 110.085  19.701  1.00 28.92           C  
ATOM    398  CD1 LEU A  53      29.575 108.954  18.705  1.00 22.28           C  
ATOM    399  CD2 LEU A  53      30.796 110.156  20.564  1.00 23.86           C  
ATOM    400  N   GLN A  54      28.239 114.194  17.851  1.00 20.04           N  
ATOM    401  CA  GLN A  54      28.457 115.282  16.894  1.00 23.12           C  
ATOM    402  C   GLN A  54      28.677 116.613  17.619  1.00 22.64           C  
ATOM    403  O   GLN A  54      29.511 117.426  17.185  1.00 22.45           O  
ATOM    404  CB  GLN A  54      27.289 115.422  15.901  1.00 18.62           C  
ATOM    405  CG  GLN A  54      27.517 116.494  14.835  1.00 24.84           C  
ATOM    406  CD  GLN A  54      28.695 116.150  13.895  1.00 22.65           C  
ATOM    407  OE1 GLN A  54      28.486 115.535  12.864  1.00 21.04           O  
ATOM    408  NE2 GLN A  54      29.919 116.515  14.275  1.00 26.01           N  
ATOM    409  N   CYS A  55      27.917 116.840  18.688  1.00 19.71           N  
ATOM    410  CA  CYS A  55      28.046 118.068  19.507  1.00 19.15           C  
ATOM    411  C   CYS A  55      29.358 118.130  20.298  1.00 17.98           C  
ATOM    412  O   CYS A  55      29.893 119.215  20.513  1.00 16.27           O  
ATOM    413  CB  CYS A  55      26.848 118.222  20.445  1.00 20.48           C  
ATOM    414  SG  CYS A  55      25.349 118.537  19.550  1.00 29.63           S  
ATOM    415  N   ARG A  56      29.879 116.971  20.696  1.00 17.48           N  
ATOM    416  CA  ARG A  56      31.193 116.874  21.355  1.00 17.02           C  
ATOM    417  C   ARG A  56      32.388 117.161  20.460  1.00 19.78           C  
ATOM    418  O   ARG A  56      33.417 117.677  20.933  1.00 18.74           O  
ATOM    419  CB  ARG A  56      31.387 115.496  21.946  1.00 14.82           C  
ATOM    420  CG  ARG A  56      30.545 115.247  23.123  1.00 18.42           C  
ATOM    421  CD  ARG A  56      30.885 113.936  23.773  1.00 20.65           C  
ATOM    422  NE  ARG A  56      29.994 113.704  24.899  1.00 22.04           N  
ATOM    423  CZ  ARG A  56      29.867 112.544  25.538  1.00 29.97           C  
ATOM    424  NH1 ARG A  56      30.596 111.505  25.172  1.00 31.07           N  
ATOM    425  NH2 ARG A  56      29.022 112.441  26.560  1.00 24.28           N  
ATOM    426  N   PHE A  57      32.267 116.781  19.191  1.00 20.15           N  
ATOM    427  CA  PHE A  57      33.302 117.027  18.191  1.00 19.84           C  
ATOM    428  C   PHE A  57      32.724 117.790  16.981  1.00 21.65           C  
ATOM    429  O   PHE A  57      32.736 117.275  15.865  1.00 18.79           O  
ATOM    430  CB  PHE A  57      33.937 115.689  17.735  1.00 26.75           C  
ATOM    431  CG  PHE A  57      34.495 114.857  18.865  1.00 25.23           C  
ATOM    432  CD1 PHE A  57      33.697 113.926  19.520  1.00 16.34           C  
ATOM    433  CD2 PHE A  57      35.795 115.028  19.293  1.00 20.64           C  
ATOM    434  CE1 PHE A  57      34.215 113.198  20.609  1.00 19.62           C  
ATOM    435  CE2 PHE A  57      36.304 114.291  20.342  1.00 26.85           C  
ATOM    436  CZ  PHE A  57      35.525 113.384  20.997  1.00 17.59           C  
ATOM    437  N   PRO A  58      32.253 119.048  17.187  1.00 17.89           N  
ATOM    438  CA  PRO A  58      31.525 119.688  16.097  1.00 17.30           C  
ATOM    439  C   PRO A  58      32.372 120.005  14.846  1.00 20.74           C  
ATOM    440  O   PRO A  58      31.817 120.087  13.768  1.00 23.68           O  
ATOM    441  CB  PRO A  58      30.978 120.961  16.753  1.00 16.95           C  
ATOM    442  CG  PRO A  58      32.014 121.297  17.807  1.00 20.22           C  
ATOM    443  CD  PRO A  58      32.364 119.930  18.361  1.00 16.61           C  
ATOM    444  N   ARG A  59      33.686 120.192  14.998  1.00 22.40           N  
ATOM    445  CA  ARG A  59      34.556 120.505  13.890  1.00 23.38           C  
ATOM    446  C   ARG A  59      35.396 119.315  13.415  1.00 22.00           C  
ATOM    447  O   ARG A  59      35.791 119.282  12.264  1.00 24.07           O  
ATOM    448  CB  ARG A  59      35.499 121.651  14.242  1.00 21.07           C  
ATOM    449  CG  ARG A  59      34.799 122.969  14.592  1.00 25.25           C  
ATOM    450  CD  ARG A  59      35.823 124.163  14.621  1.00 31.13           C  
ATOM    451  NE  ARG A  59      35.226 125.403  15.156  1.00 35.59           N  
ATOM    452  CZ  ARG A  59      34.474 126.278  14.467  1.00 44.16           C  
ATOM    453  NH1 ARG A  59      34.195 126.103  13.170  1.00 42.05           N  
ATOM    454  NH2 ARG A  59      33.987 127.357  15.089  1.00 45.73           N  
ATOM    455  N   ARG A  60      35.708 118.372  14.287  1.00 21.47           N  
ATOM    456  CA  ARG A  60      36.693 117.346  13.942  1.00 19.94           C  
ATOM    457  C   ARG A  60      36.089 116.008  13.561  1.00 18.10           C  
ATOM    458  O   ARG A  60      36.826 115.093  13.187  1.00 18.02           O  
ATOM    459  CB  ARG A  60      37.683 117.159  15.086  1.00 14.17           C  
ATOM    460  CG  ARG A  60      38.512 118.377  15.422  1.00 21.58           C  
ATOM    461  CD  ARG A  60      39.394 118.119  16.683  1.00 28.11           C  
ATOM    462  NE  ARG A  60      38.643 118.046  17.965  1.00 30.90           N  
ATOM    463  CZ  ARG A  60      39.067 117.432  19.083  1.00 34.17           C  
ATOM    464  NH1 ARG A  60      40.223 116.777  19.097  1.00 29.29           N  
ATOM    465  NH2 ARG A  60      38.327 117.451  20.199  1.00 29.51           N  
ATOM    466  N   LEU A  61      34.769 115.889  13.712  1.00 19.64           N  
ATOM    467  CA  LEU A  61      34.033 114.677  13.431  1.00 20.16           C  
ATOM    468  C   LEU A  61      32.865 115.035  12.517  1.00 18.20           C  
ATOM    469  O   LEU A  61      32.296 116.097  12.652  1.00 18.46           O  
ATOM    470  CB  LEU A  61      33.511 114.048  14.724  1.00 24.06           C  
ATOM    471  CG  LEU A  61      32.691 112.749  14.660  1.00 22.38           C  
ATOM    472  CD1 LEU A  61      33.540 111.540  14.172  1.00 13.70           C  
ATOM    473  CD2 LEU A  61      32.031 112.503  16.032  1.00 20.28           C  
ATOM    474  N   VAL A  62      32.584 114.161  11.555  1.00 19.46           N  
ATOM    475  CA  VAL A  62      31.330 114.177  10.826  1.00 17.63           C  
ATOM    476  C   VAL A  62      30.590 112.912  11.188  1.00 18.19           C  
ATOM    477  O   VAL A  62      31.133 111.826  11.026  1.00 20.42           O  
ATOM    478  CB  VAL A  62      31.546 114.252   9.291  1.00 22.55           C  
ATOM    479  CG1 VAL A  62      30.190 114.236   8.531  1.00 19.18           C  
ATOM    480  CG2 VAL A  62      32.362 115.501   8.921  1.00 17.45           C  
ATOM    481  N   VAL A  63      29.365 113.058  11.710  1.00 21.83           N  
ATOM    482  CA  VAL A  63      28.428 111.944  11.935  1.00 18.31           C  
ATOM    483  C   VAL A  63      27.401 111.929  10.781  1.00 19.05           C  
ATOM    484  O   VAL A  63      26.772 112.919  10.484  1.00 19.86           O  
ATOM    485  CB  VAL A  63      27.715 112.048  13.302  1.00 21.80           C  
ATOM    486  CG1 VAL A  63      26.822 110.848  13.539  1.00 22.71           C  
ATOM    487  CG2 VAL A  63      28.717 112.191  14.436  1.00 18.44           C  
ATOM    488  N   LEU A  64      27.251 110.791  10.117  1.00 19.19           N  
ATOM    489  CA  LEU A  64      26.396 110.696   8.954  1.00 23.00           C  
ATOM    490  C   LEU A  64      25.518 109.468   9.108  1.00 22.84           C  
ATOM    491  O   LEU A  64      26.023 108.371   9.383  1.00 22.22           O  
ATOM    492  CB  LEU A  64      27.312 110.639   7.707  1.00 28.98           C  
ATOM    493  CG  LEU A  64      26.919 110.903   6.254  1.00 36.22           C  
ATOM    494  CD1 LEU A  64      26.312 112.296   6.036  1.00 39.18           C  
ATOM    495  CD2 LEU A  64      28.213 110.730   5.405  1.00 28.50           C  
ATOM    496  N   GLY A  65      24.199 109.652   9.022  1.00 19.77           N  
ATOM    497  CA  GLY A  65      23.257 108.527   9.156  1.00 18.67           C  
ATOM    498  C   GLY A  65      22.563 108.212   7.852  1.00 20.35           C  
ATOM    499  O   GLY A  65      22.042 109.116   7.206  1.00 21.47           O  
ATOM    500  N   PHE A  66      22.557 106.932   7.479  1.00 17.30           N  
ATOM    501  CA  PHE A  66      21.918 106.440   6.296  1.00 15.61           C  
ATOM    502  C   PHE A  66      20.667 105.661   6.646  1.00 17.56           C  
ATOM    503  O   PHE A  66      20.761 104.510   7.061  1.00 18.36           O  
ATOM    504  CB  PHE A  66      22.866 105.540   5.489  1.00 16.92           C  
ATOM    505  CG  PHE A  66      23.987 106.287   4.801  1.00 15.38           C  
ATOM    506  CD1 PHE A  66      24.045 106.357   3.419  1.00 24.28           C  
ATOM    507  CD2 PHE A  66      24.998 106.862   5.531  1.00 18.41           C  
ATOM    508  CE1 PHE A  66      25.121 107.003   2.780  1.00 24.23           C  
ATOM    509  CE2 PHE A  66      26.070 107.504   4.909  1.00 23.02           C  
ATOM    510  CZ  PHE A  66      26.119 107.586   3.540  1.00 21.77           C  
ATOM    511  N   PRO A  67      19.487 106.286   6.475  1.00 19.95           N  
ATOM    512  CA  PRO A  67      18.239 105.549   6.728  1.00 21.19           C  
ATOM    513  C   PRO A  67      18.130 104.369   5.773  1.00 20.51           C  
ATOM    514  O   PRO A  67      18.533 104.468   4.618  1.00 20.72           O  
ATOM    515  CB  PRO A  67      17.147 106.581   6.483  1.00 18.30           C  
ATOM    516  CG  PRO A  67      17.813 107.932   6.597  1.00 20.02           C  
ATOM    517  CD  PRO A  67      19.235 107.697   6.100  1.00 21.97           C  
ATOM    518  N   CYS A  68      17.621 103.247   6.265  1.00 24.92           N  
ATOM    519  CA  CYS A  68      17.534 102.032   5.459  1.00 20.63           C  
ATOM    520  C   CYS A  68      16.379 101.168   5.978  1.00 22.64           C  
ATOM    521  O   CYS A  68      16.223 100.975   7.199  1.00 18.07           O  
ATOM    522  CB  CYS A  68      18.881 101.286   5.530  1.00 23.52           C  
ATOM    523  SG  CYS A  68      18.921  99.704   4.612  1.00 22.44           S  
ATOM    524  N   ASN A  69      15.604 100.622   5.037  1.00 22.68           N  
ATOM    525  CA  ASN A  69      14.419  99.804   5.327  1.00 21.41           C  
ATOM    526  C   ASN A  69      14.645  98.278   5.165  1.00 22.08           C  
ATOM    527  O   ASN A  69      13.709  97.503   5.113  1.00 20.35           O  
ATOM    528  CB  ASN A  69      13.274 100.281   4.418  1.00 24.22           C  
ATOM    529  CG  ASN A  69      11.929  99.889   4.938  1.00 34.77           C  
ATOM    530  OD1 ASN A  69      11.700  99.897   6.166  1.00 23.77           O  
ATOM    531  ND2 ASN A  69      11.017  99.524   4.020  1.00 30.85           N  
ATOM    532  N   GLN A  70      15.899  97.835   5.107  1.00 23.73           N  
ATOM    533  CA  GLN A  70      16.177  96.410   4.870  1.00 21.39           C  
ATOM    534  C   GLN A  70      16.123  95.480   6.094  1.00 18.40           C  
ATOM    535  O   GLN A  70      16.233  94.264   5.929  1.00 21.28           O  
ATOM    536  CB  GLN A  70      17.543  96.274   4.207  1.00 23.79           C  
ATOM    537  CG  GLN A  70      17.526  96.778   2.792  1.00 22.23           C  
ATOM    538  CD  GLN A  70      18.818  96.502   2.074  1.00 24.85           C  
ATOM    539  OE1 GLN A  70      19.882  96.909   2.530  1.00 23.97           O  
ATOM    540  NE2 GLN A  70      18.736  95.797   0.947  1.00 17.81           N  
ATOM    541  N   PHE A  71      15.969  96.049   7.297  1.00 21.00           N  
ATOM    542  CA  PHE A  71      16.104  95.318   8.552  1.00 21.01           C  
ATOM    543  C   PHE A  71      14.829  95.392   9.372  1.00 24.56           C  
ATOM    544  O   PHE A  71      14.650  96.280  10.202  1.00 28.30           O  
ATOM    545  CB  PHE A  71      17.325  95.798   9.330  1.00 19.50           C  
ATOM    546  CG  PHE A  71      18.570  95.863   8.491  1.00 23.15           C  
ATOM    547  CD1 PHE A  71      19.277  94.704   8.184  1.00 19.52           C  
ATOM    548  CD2 PHE A  71      18.991  97.074   7.934  1.00 18.06           C  
ATOM    549  CE1 PHE A  71      20.401  94.756   7.393  1.00 20.90           C  
ATOM    550  CE2 PHE A  71      20.116  97.117   7.138  1.00 20.69           C  
ATOM    551  CZ  PHE A  71      20.815  95.945   6.862  1.00 25.20           C  
ATOM    552  N   GLY A  72      13.934  94.441   9.118  1.00 24.96           N  
ATOM    553  CA  GLY A  72      12.632  94.440   9.787  1.00 28.83           C  
ATOM    554  C   GLY A  72      11.728  95.541   9.234  1.00 29.27           C  
ATOM    555  O   GLY A  72      10.716  95.856   9.837  1.00 30.41           O  
ATOM    556  N   HIS A  73      12.087  96.090   8.068  1.00 28.03           N  
ATOM    557  CA  HIS A  73      11.381  97.202   7.437  1.00 30.82           C  
ATOM    558  C   HIS A  73      11.118  98.340   8.419  1.00 31.27           C  
ATOM    559  O   HIS A  73       9.990  98.852   8.489  1.00 32.54           O  
ATOM    560  CB  HIS A  73      10.059  96.755   6.818  1.00 30.45           C  
ATOM    561  CG  HIS A  73      10.194  95.721   5.740  1.00 35.74           C  
ATOM    562  ND1 HIS A  73      10.491  96.042   4.429  1.00 51.08           N  
ATOM    563  CD2 HIS A  73      10.007  94.380   5.763  1.00 31.75           C  
ATOM    564  CE1 HIS A  73      10.511  94.937   3.703  1.00 50.95           C  
ATOM    565  NE2 HIS A  73      10.211  93.915   4.487  1.00 34.88           N  
ATOM    566  N   GLN A  74      12.157  98.757   9.154  1.00 28.96           N  
ATOM    567  CA  GLN A  74      11.975  99.715  10.248  1.00 25.87           C  
ATOM    568  C   GLN A  74      12.257 101.176   9.825  1.00 25.84           C  
ATOM    569  O   GLN A  74      12.532 102.057  10.647  1.00 26.13           O  
ATOM    570  CB  GLN A  74      12.794  99.255  11.449  1.00 25.45           C  
ATOM    571  CG  GLN A  74      12.257  97.949  11.993  1.00 27.28           C  
ATOM    572  CD  GLN A  74      13.025  97.422  13.140  1.00 30.76           C  
ATOM    573  OE1 GLN A  74      13.977  98.031  13.579  1.00 37.39           O  
ATOM    574  NE2 GLN A  74      12.612  96.279  13.649  1.00 36.82           N  
ATOM    575  N   GLU A  75      12.204 101.408   8.518  1.00 29.79           N  
ATOM    576  CA  GLU A  75      12.249 102.736   7.928  1.00 29.26           C  
ATOM    577  C   GLU A  75      11.335 102.776   6.686  1.00 30.40           C  
ATOM    578  O   GLU A  75      11.823 102.857   5.550  1.00 30.54           O  
ATOM    579  CB  GLU A  75      13.680 103.103   7.534  1.00 29.88           C  
ATOM    580  CG  GLU A  75      13.839 104.558   7.129  1.00 36.88           C  
ATOM    581  CD  GLU A  75      13.591 105.452   8.319  1.00 52.32           C  
ATOM    582  OE1 GLU A  75      14.514 105.532   9.155  1.00 47.55           O  
ATOM    583  OE2 GLU A  75      12.469 106.012   8.440  1.00 60.53           O  
ATOM    584  N   ASN A  76      10.025 102.693   6.898  1.00 30.47           N  
ATOM    585  CA  ASN A  76       9.032 102.741   5.774  1.00 37.17           C  
ATOM    586  C   ASN A  76       8.659 104.182   5.341  1.00 40.01           C  
ATOM    587  O   ASN A  76       7.973 104.400   4.322  1.00 43.52           O  
ATOM    588  CB  ASN A  76       7.753 101.937   6.131  1.00 35.40           C  
ATOM    589  CG  ASN A  76       7.967 100.402   6.095  1.00 29.48           C  
ATOM    590  OD1 ASN A  76       8.376  99.826   5.075  1.00 32.71           O  
ATOM    591  ND2 ASN A  76       7.664  99.746   7.204  1.00 33.24           N  
ATOM    592  N   CYS A  77       9.114 105.155   6.126  1.00 42.89           N  
ATOM    593  CA  CYS A  77       8.927 106.559   5.811  1.00 46.19           C  
ATOM    594  C   CYS A  77       9.550 106.886   4.454  1.00 44.12           C  
ATOM    595  O   CYS A  77      10.610 106.355   4.117  1.00 41.59           O  
ATOM    596  CB  CYS A  77       9.589 107.457   6.874  1.00 45.83           C  
ATOM    597  SG  CYS A  77       8.602 107.699   8.339  1.00 53.52           S  
ATOM    598  N   GLN A  78       8.852 107.741   3.699  1.00 37.30           N  
ATOM    599  CA  GLN A  78       9.439 108.510   2.616  1.00 33.26           C  
ATOM    600  C   GLN A  78      10.449 109.466   3.227  1.00 28.76           C  
ATOM    601  O   GLN A  78      10.375 109.804   4.419  1.00 23.55           O  
ATOM    602  CB  GLN A  78       8.383 109.334   1.876  1.00 34.71           C  
ATOM    603  CG  GLN A  78       7.230 108.540   1.247  1.00 45.83           C  
ATOM    604  CD  GLN A  78       7.712 107.369   0.406  1.00 61.81           C  
ATOM    605  OE1 GLN A  78       8.268 106.388   0.923  1.00 70.12           O  
ATOM    606  NE2 GLN A  78       7.499 107.462  -0.901  1.00 70.43           N  
ATOM    607  N   ASN A  79      11.384 109.912   2.402  1.00 25.60           N  
ATOM    608  CA  ASN A  79      12.426 110.822   2.841  1.00 26.54           C  
ATOM    609  C   ASN A  79      11.855 112.051   3.516  1.00 25.02           C  
ATOM    610  O   ASN A  79      12.342 112.452   4.569  1.00 24.25           O  
ATOM    611  CB  ASN A  79      13.328 111.223   1.664  1.00 26.99           C  
ATOM    612  CG  ASN A  79      14.300 110.124   1.263  1.00 29.49           C  
ATOM    613  OD1 ASN A  79      14.736 109.310   2.096  1.00 22.33           O  
ATOM    614  ND2 ASN A  79      14.657 110.099  -0.017  1.00 21.40           N  
ATOM    615  N   GLU A  80      10.798 112.614   2.930  1.00 24.77           N  
ATOM    616  CA  GLU A  80      10.121 113.812   3.471  1.00 28.63           C  
ATOM    617  C   GLU A  80       9.329 113.597   4.791  1.00 24.10           C  
ATOM    618  O   GLU A  80       8.835 114.553   5.376  1.00 25.64           O  
ATOM    619  CB  GLU A  80       9.199 114.469   2.404  1.00 32.65           C  
ATOM    620  CG  GLU A  80       8.548 113.524   1.391  1.00 44.56           C  
ATOM    621  CD  GLU A  80       9.559 112.978   0.371  1.00 47.56           C  
ATOM    622  OE1 GLU A  80      10.275 113.757  -0.305  1.00 57.75           O  
ATOM    623  OE2 GLU A  80       9.655 111.756   0.262  1.00 38.43           O  
ATOM    624  N   GLU A  81       9.211 112.361   5.250  1.00 23.55           N  
ATOM    625  CA  GLU A  81       8.499 112.028   6.491  1.00 21.97           C  
ATOM    626  C   GLU A  81       9.424 111.727   7.690  1.00 22.28           C  
ATOM    627  O   GLU A  81       8.975 111.770   8.847  1.00 21.35           O  
ATOM    628  CB  GLU A  81       7.585 110.829   6.239  1.00 23.04           C  
ATOM    629  CG  GLU A  81       6.484 111.093   5.183  1.00 19.99           C  
ATOM    630  CD  GLU A  81       5.715 109.831   4.789  1.00 21.20           C  
ATOM    631  OE1 GLU A  81       6.328 108.743   4.767  1.00 30.21           O  
ATOM    632  OE2 GLU A  81       4.503 109.926   4.491  1.00 28.39           O  
ATOM    633  N   ILE A  82      10.701 111.438   7.410  1.00 22.16           N  
ATOM    634  CA  ILE A  82      11.681 110.960   8.416  1.00 22.83           C  
ATOM    635  C   ILE A  82      11.891 111.944   9.576  1.00 21.67           C  
ATOM    636  O   ILE A  82      11.830 111.558  10.743  1.00 23.81           O  
ATOM    637  CB  ILE A  82      13.037 110.568   7.726  1.00 23.87           C  
ATOM    638  CG1 ILE A  82      12.835 109.306   6.865  1.00 35.71           C  
ATOM    639  CG2 ILE A  82      14.148 110.347   8.766  1.00 23.60           C  
ATOM    640  CD1 ILE A  82      14.058 108.802   6.058  1.00 27.21           C  
ATOM    641  N   LEU A  83      12.102 113.226   9.282  1.00 21.85           N  
ATOM    642  CA  LEU A  83      12.340 114.204  10.359  1.00 18.54           C  
ATOM    643  C   LEU A  83      11.120 114.361  11.245  1.00 21.01           C  
ATOM    644  O   LEU A  83      11.250 114.485  12.450  1.00 22.05           O  
ATOM    645  CB  LEU A  83      12.767 115.561   9.780  1.00 20.26           C  
ATOM    646  CG  LEU A  83      14.139 115.532   9.075  1.00 22.94           C  
ATOM    647  CD1 LEU A  83      14.523 116.960   8.461  1.00 21.75           C  
ATOM    648  CD2 LEU A  83      15.214 115.022  10.077  1.00 20.97           C  
ATOM    649  N   ASN A  84       9.926 114.361  10.638  1.00 19.80           N  
ATOM    650  CA  ASN A  84       8.648 114.351  11.378  1.00 18.17           C  
ATOM    651  C   ASN A  84       8.469 113.187  12.315  1.00 17.38           C  
ATOM    652  O   ASN A  84       8.024 113.348  13.448  1.00 20.04           O  
ATOM    653  CB  ASN A  84       7.458 114.383  10.408  1.00 19.71           C  
ATOM    654  CG  ASN A  84       7.202 115.763   9.878  1.00 20.58           C  
ATOM    655  OD1 ASN A  84       7.728 116.714  10.428  1.00 25.39           O  
ATOM    656  ND2 ASN A  84       6.384 115.890   8.826  1.00 20.91           N  
ATOM    657  N   SER A  85       8.816 112.011  11.825  1.00 18.51           N  
ATOM    658  CA  SER A  85       8.731 110.802  12.601  1.00 19.72           C  
ATOM    659  C   SER A  85       9.708 110.870  13.771  1.00 22.18           C  
ATOM    660  O   SER A  85       9.347 110.520  14.892  1.00 20.62           O  
ATOM    661  CB  SER A  85       8.996 109.595  11.712  1.00 21.05           C  
ATOM    662  OG  SER A  85       8.678 108.390  12.395  1.00 25.57           O  
ATOM    663  N   LEU A  86      10.930 111.364  13.529  1.00 22.99           N  
ATOM    664  CA  LEU A  86      11.910 111.491  14.617  1.00 22.84           C  
ATOM    665  C   LEU A  86      11.457 112.535  15.645  1.00 22.27           C  
ATOM    666  O   LEU A  86      11.647 112.371  16.849  1.00 21.44           O  
ATOM    667  CB  LEU A  86      13.302 111.849  14.080  1.00 21.57           C  
ATOM    668  CG  LEU A  86      13.989 110.814  13.207  1.00 20.86           C  
ATOM    669  CD1 LEU A  86      15.209 111.440  12.425  1.00 21.97           C  
ATOM    670  CD2 LEU A  86      14.372 109.549  14.011  1.00 26.68           C  
ATOM    671  N   LYS A  87      10.850 113.615  15.152  1.00 21.24           N  
ATOM    672  CA  LYS A  87      10.453 114.721  15.980  1.00 18.81           C  
ATOM    673  C   LYS A  87       9.211 114.463  16.792  1.00 20.36           C  
ATOM    674  O   LYS A  87       9.088 114.966  17.910  1.00 19.77           O  
ATOM    675  CB  LYS A  87      10.235 115.960  15.125  1.00 19.75           C  
ATOM    676  CG  LYS A  87       9.968 117.181  15.908  1.00 23.04           C  
ATOM    677  CD  LYS A  87      10.159 118.418  15.054  1.00 28.17           C  
ATOM    678  CE  LYS A  87       9.609 119.651  15.729  1.00 32.32           C  
ATOM    679  NZ  LYS A  87       9.983 120.863  14.935  1.00 45.33           N  
ATOM    680  N   TYR A  88       8.264 113.718  16.224  1.00 19.43           N  
ATOM    681  CA  TYR A  88       6.936 113.623  16.812  1.00 19.74           C  
ATOM    682  C   TYR A  88       6.560 112.231  17.254  1.00 17.20           C  
ATOM    683  O   TYR A  88       5.575 112.069  17.960  1.00 23.33           O  
ATOM    684  CB  TYR A  88       5.879 114.159  15.837  1.00 19.50           C  
ATOM    685  CG  TYR A  88       5.956 115.648  15.596  1.00 18.17           C  
ATOM    686  CD1 TYR A  88       5.581 116.555  16.586  1.00 24.66           C  
ATOM    687  CD2 TYR A  88       6.393 116.147  14.384  1.00 21.26           C  
ATOM    688  CE1 TYR A  88       5.652 117.916  16.366  1.00 30.86           C  
ATOM    689  CE2 TYR A  88       6.467 117.500  14.156  1.00 21.14           C  
ATOM    690  CZ  TYR A  88       6.094 118.382  15.147  1.00 31.10           C  
ATOM    691  OH  TYR A  88       6.165 119.741  14.910  1.00 30.79           O  
ATOM    692  N   VAL A  89       7.313 111.222  16.841  1.00 18.61           N  
ATOM    693  CA  VAL A  89       6.915 109.836  17.142  1.00 20.05           C  
ATOM    694  C   VAL A  89       7.967 109.134  18.014  1.00 20.75           C  
ATOM    695  O   VAL A  89       7.714 108.859  19.179  1.00 20.71           O  
ATOM    696  CB  VAL A  89       6.600 109.042  15.858  1.00 15.71           C  
ATOM    697  CG1 VAL A  89       6.195 107.595  16.198  1.00 18.54           C  
ATOM    698  CG2 VAL A  89       5.524 109.785  15.047  1.00 16.20           C  
ATOM    699  N   ARG A  90       9.132 108.867  17.438  1.00 23.68           N  
ATOM    700  CA  ARG A  90      10.204 108.187  18.143  1.00 27.41           C  
ATOM    701  C   ARG A  90      11.531 108.675  17.579  1.00 26.49           C  
ATOM    702  O   ARG A  90      11.765 108.502  16.393  1.00 24.18           O  
ATOM    703  CB  ARG A  90      10.108 106.672  17.959  1.00 26.56           C  
ATOM    704  CG  ARG A  90      11.149 105.923  18.806  1.00 30.94           C  
ATOM    705  CD  ARG A  90      11.301 104.463  18.431  1.00 39.37           C  
ATOM    706  NE  ARG A  90      10.096 103.690  18.709  1.00 43.09           N  
ATOM    707  CZ  ARG A  90       9.853 102.471  18.222  1.00 59.13           C  
ATOM    708  NH1 ARG A  90      10.749 101.850  17.456  1.00 65.32           N  
ATOM    709  NH2 ARG A  90       8.703 101.863  18.510  1.00 47.94           N  
ATOM    710  N   PRO A  91      12.399 109.285  18.422  1.00 26.70           N  
ATOM    711  CA  PRO A  91      12.303 109.595  19.850  1.00 25.32           C  
ATOM    712  C   PRO A  91      11.123 110.472  20.230  1.00 25.75           C  
ATOM    713  O   PRO A  91      10.610 110.386  21.340  1.00 24.93           O  
ATOM    714  CB  PRO A  91      13.599 110.378  20.126  1.00 27.80           C  
ATOM    715  CG  PRO A  91      14.503 109.983  19.078  1.00 23.36           C  
ATOM    716  CD  PRO A  91      13.684 109.741  17.876  1.00 25.86           C  
ATOM    717  N   GLY A  92      10.675 111.332  19.334  1.00 25.14           N  
ATOM    718  CA  GLY A  92       9.554 112.179  19.688  1.00 21.86           C  
ATOM    719  C   GLY A  92      10.046 113.285  20.580  1.00 22.95           C  
ATOM    720  O   GLY A  92      11.247 113.511  20.717  1.00 24.40           O  
ATOM    721  N   GLY A  93       9.101 114.008  21.150  1.00 25.54           N  
ATOM    722  CA  GLY A  93       9.389 115.062  22.111  1.00 26.57           C  
ATOM    723  C   GLY A  93      10.164 116.233  21.549  1.00 26.21           C  
ATOM    724  O   GLY A  93      10.749 116.987  22.298  1.00 27.40           O  
ATOM    725  N   GLY A  94      10.154 116.401  20.233  1.00 26.38           N  
ATOM    726  CA  GLY A  94      10.808 117.563  19.612  1.00 24.07           C  
ATOM    727  C   GLY A  94      12.215 117.262  19.177  1.00 21.35           C  
ATOM    728  O   GLY A  94      12.925 118.162  18.742  1.00 22.98           O  
ATOM    729  N   TYR A  95      12.596 115.986  19.237  1.00 22.62           N  
ATOM    730  CA  TYR A  95      13.916 115.558  18.831  1.00 23.34           C  
ATOM    731  C   TYR A  95      14.228 116.006  17.404  1.00 23.89           C  
ATOM    732  O   TYR A  95      13.428 115.804  16.470  1.00 24.43           O  
ATOM    733  CB  TYR A  95      14.070 114.036  18.923  1.00 21.28           C  
ATOM    734  CG  TYR A  95      15.351 113.571  18.312  1.00 22.90           C  
ATOM    735  CD1 TYR A  95      16.502 113.460  19.076  1.00 26.87           C  
ATOM    736  CD2 TYR A  95      15.430 113.276  16.951  1.00 26.29           C  
ATOM    737  CE1 TYR A  95      17.679 113.052  18.518  1.00 23.19           C  
ATOM    738  CE2 TYR A  95      16.599 112.885  16.390  1.00 17.40           C  
ATOM    739  CZ  TYR A  95      17.729 112.782  17.168  1.00 23.03           C  
ATOM    740  OH  TYR A  95      18.921 112.376  16.603  1.00 19.72           O  
ATOM    741  N   GLN A  96      15.407 116.597  17.237  1.00 24.23           N  
ATOM    742  CA  GLN A  96      15.935 116.903  15.921  1.00 28.11           C  
ATOM    743  C   GLN A  96      17.366 116.399  15.852  1.00 28.31           C  
ATOM    744  O   GLN A  96      18.110 116.508  16.843  1.00 20.83           O  
ATOM    745  CB  GLN A  96      15.892 118.403  15.675  1.00 30.17           C  
ATOM    746  CG  GLN A  96      14.478 118.931  15.561  1.00 37.87           C  
ATOM    747  CD  GLN A  96      14.405 120.440  15.413  1.00 34.26           C  
ATOM    748  OE1 GLN A  96      15.299 121.067  14.860  1.00 52.20           O  
ATOM    749  NE2 GLN A  96      13.325 121.023  15.908  1.00 54.34           N  
ATOM    750  N   PRO A  97      17.758 115.822  14.701  1.00 24.70           N  
ATOM    751  CA  PRO A  97      19.166 115.436  14.564  1.00 28.46           C  
ATOM    752  C   PRO A  97      20.110 116.643  14.449  1.00 26.95           C  
ATOM    753  O   PRO A  97      19.772 117.614  13.805  1.00 25.11           O  
ATOM    754  CB  PRO A  97      19.197 114.572  13.285  1.00 30.40           C  
ATOM    755  CG  PRO A  97      17.857 114.614  12.693  1.00 25.77           C  
ATOM    756  CD  PRO A  97      16.952 115.476  13.517  1.00 27.84           C  
ATOM    757  N   THR A  98      21.277 116.564  15.076  1.00 25.65           N  
ATOM    758  CA  THR A  98      22.311 117.597  14.950  1.00 26.54           C  
ATOM    759  C   THR A  98      23.374 117.127  13.946  1.00 29.47           C  
ATOM    760  O   THR A  98      24.348 117.815  13.680  1.00 26.27           O  
ATOM    761  CB  THR A  98      22.985 117.924  16.332  1.00 24.60           C  
ATOM    762  OG1 THR A  98      23.567 116.748  16.884  1.00 30.14           O  
ATOM    763  CG2 THR A  98      21.982 118.468  17.303  1.00 25.69           C  
ATOM    764  N   PHE A  99      23.153 115.954  13.366  1.00 31.79           N  
ATOM    765  CA  PHE A  99      24.083 115.361  12.425  1.00 30.44           C  
ATOM    766  C   PHE A  99      23.340 115.242  11.082  1.00 29.04           C  
ATOM    767  O   PHE A  99      22.146 115.503  11.000  1.00 31.67           O  
ATOM    768  CB  PHE A  99      24.584 114.010  12.964  1.00 28.36           C  
ATOM    769  CG  PHE A  99      23.515 112.985  13.102  1.00 26.55           C  
ATOM    770  CD1 PHE A  99      23.218 112.127  12.044  1.00 23.67           C  
ATOM    771  CD2 PHE A  99      22.786 112.880  14.276  1.00 30.00           C  
ATOM    772  CE1 PHE A  99      22.217 111.189  12.164  1.00 21.30           C  
ATOM    773  CE2 PHE A  99      21.763 111.937  14.403  1.00 22.19           C  
ATOM    774  CZ  PHE A  99      21.480 111.101  13.348  1.00 23.82           C  
ATOM    775  N   THR A 100      24.054 114.830  10.047  1.00 26.17           N  
ATOM    776  CA  THR A 100      23.532 114.810   8.704  1.00 27.44           C  
ATOM    777  C   THR A 100      22.873 113.470   8.457  1.00 22.42           C  
ATOM    778  O   THR A 100      23.516 112.442   8.620  1.00 21.11           O  
ATOM    779  CB  THR A 100      24.692 114.984   7.696  1.00 33.41           C  
ATOM    780  OG1 THR A 100      25.546 116.056   8.134  1.00 38.86           O  
ATOM    781  CG2 THR A 100      24.180 115.216   6.274  1.00 27.60           C  
ATOM    782  N   LEU A 101      21.603 113.498   8.062  1.00 21.50           N  
ATOM    783  CA  LEU A 101      20.890 112.340   7.556  1.00 28.79           C  
ATOM    784  C   LEU A 101      20.824 112.430   6.075  1.00 28.29           C  
ATOM    785  O   LEU A 101      20.532 113.493   5.516  1.00 31.37           O  
ATOM    786  CB  LEU A 101      19.447 112.275   8.050  1.00 28.28           C  
ATOM    787  CG  LEU A 101      19.179 111.840   9.470  1.00 32.31           C  
ATOM    788  CD1 LEU A 101      17.716 112.135   9.788  1.00 29.74           C  
ATOM    789  CD2 LEU A 101      19.549 110.346   9.680  1.00 27.08           C  
ATOM    790  N   VAL A 102      21.012 111.286   5.432  1.00 27.25           N  
ATOM    791  CA  VAL A 102      20.971 111.243   3.999  1.00 29.96           C  
ATOM    792  C   VAL A 102      19.674 110.564   3.532  1.00 25.68           C  
ATOM    793  O   VAL A 102      18.876 110.094   4.338  1.00 25.82           O  
ATOM    794  CB  VAL A 102      22.265 110.590   3.442  1.00 35.47           C  
ATOM    795  CG1 VAL A 102      23.501 111.419   3.909  1.00 29.75           C  
ATOM    796  CG2 VAL A 102      22.362 109.202   3.870  1.00 30.42           C  
ATOM    797  N   GLN A 103      19.447 110.585   2.232  1.00 25.94           N  
ATOM    798  CA  GLN A 103      18.281 109.940   1.662  1.00 25.85           C  
ATOM    799  C   GLN A 103      18.305 108.436   1.902  1.00 27.45           C  
ATOM    800  O   GLN A 103      19.366 107.817   1.934  1.00 27.42           O  
ATOM    801  CB  GLN A 103      18.211 110.234   0.195  1.00 23.84           C  
ATOM    802  CG  GLN A 103      17.740 111.633  -0.083  1.00 27.78           C  
ATOM    803  CD  GLN A 103      17.733 111.943  -1.550  1.00 28.11           C  
ATOM    804  OE1 GLN A 103      18.385 111.263  -2.346  1.00 32.72           O  
ATOM    805  NE2 GLN A 103      17.008 112.980  -1.919  1.00 22.65           N  
ATOM    806  N   LYS A 104      17.120 107.869   2.115  1.00 26.05           N  
ATOM    807  CA  LYS A 104      16.981 106.458   2.369  1.00 30.01           C  
ATOM    808  C   LYS A 104      17.678 105.663   1.236  1.00 29.04           C  
ATOM    809  O   LYS A 104      17.606 106.023   0.058  1.00 29.30           O  
ATOM    810  CB  LYS A 104      15.489 106.117   2.500  1.00 30.92           C  
ATOM    811  CG  LYS A 104      15.201 104.677   2.748  1.00 42.41           C  
ATOM    812  CD  LYS A 104      13.791 104.462   3.335  1.00 40.96           C  
ATOM    813  CE  LYS A 104      12.704 104.810   2.356  1.00 41.98           C  
ATOM    814  NZ  LYS A 104      11.430 104.171   2.761  1.00 42.33           N  
ATOM    815  N   CYS A 105      18.366 104.598   1.618  1.00 27.47           N  
ATOM    816  CA  CYS A 105      19.109 103.752   0.673  1.00 25.57           C  
ATOM    817  C   CYS A 105      19.027 102.285   1.065  1.00 20.93           C  
ATOM    818  O   CYS A 105      18.398 101.935   2.063  1.00 23.63           O  
ATOM    819  CB  CYS A 105      20.586 104.200   0.615  1.00 23.43           C  
ATOM    820  SG  CYS A 105      21.532 103.828   2.065  1.00 31.13           S  
ATOM    821  N   GLU A 106      19.632 101.437   0.233  1.00 23.36           N  
ATOM    822  CA  GLU A 106      19.933 100.055   0.574  1.00 20.29           C  
ATOM    823  C   GLU A 106      21.424  99.942   0.895  1.00 21.11           C  
ATOM    824  O   GLU A 106      22.265 100.606   0.280  1.00 22.52           O  
ATOM    825  CB  GLU A 106      19.470  99.111  -0.539  1.00 20.16           C  
ATOM    826  CG  GLU A 106      17.998  98.902  -0.448  1.00 21.51           C  
ATOM    827  CD  GLU A 106      17.392  98.190  -1.625  1.00 36.79           C  
ATOM    828  OE1 GLU A 106      18.136  97.665  -2.476  1.00 34.10           O  
ATOM    829  OE2 GLU A 106      16.147  98.123  -1.660  1.00 38.42           O  
ATOM    830  N   VAL A 107      21.742  99.209   1.961  1.00 21.64           N  
ATOM    831  CA  VAL A 107      23.139  98.995   2.393  1.00 22.33           C  
ATOM    832  C   VAL A 107      23.651  97.618   1.979  1.00 22.84           C  
ATOM    833  O   VAL A 107      24.876  97.391   1.981  1.00 22.41           O  
ATOM    834  CB  VAL A 107      23.341  99.209   3.943  1.00 19.24           C  
ATOM    835  CG1 VAL A 107      23.021 100.725   4.343  1.00 17.06           C  
ATOM    836  CG2 VAL A 107      22.530  98.194   4.779  1.00 26.12           C  
ATOM    837  N   ASN A 108      22.710  96.710   1.652  1.00 19.44           N  
ATOM    838  CA  ASN A 108      23.023  95.333   1.241  1.00 20.87           C  
ATOM    839  C   ASN A 108      22.368  95.026  -0.108  1.00 21.63           C  
ATOM    840  O   ASN A 108      21.350  95.611  -0.471  1.00 20.21           O  
ATOM    841  CB  ASN A 108      22.583  94.256   2.260  1.00 18.14           C  
ATOM    842  CG  ASN A 108      23.286  94.331   3.569  1.00 19.54           C  
ATOM    843  OD1 ASN A 108      24.454  94.686   3.631  1.00 19.29           O  
ATOM    844  ND2 ASN A 108      22.580  93.944   4.654  1.00 17.33           N  
ATOM    845  N   GLY A 109      22.991  94.111  -0.843  1.00 22.56           N  
ATOM    846  CA  GLY A 109      22.433  93.598  -2.076  1.00 23.68           C  
ATOM    847  C   GLY A 109      22.869  94.353  -3.323  1.00 23.15           C  
ATOM    848  O   GLY A 109      23.703  95.256  -3.277  1.00 19.37           O  
ATOM    849  N   GLN A 110      22.269  93.951  -4.436  1.00 19.47           N  
ATOM    850  CA  GLN A 110      22.567  94.479  -5.759  1.00 25.95           C  
ATOM    851  C   GLN A 110      22.537  96.023  -5.854  1.00 22.05           C  
ATOM    852  O   GLN A 110      23.351  96.606  -6.541  1.00 25.39           O  
ATOM    853  CB  GLN A 110      21.570  93.880  -6.743  1.00 24.42           C  
ATOM    854  CG  GLN A 110      21.948  94.036  -8.187  1.00 48.95           C  
ATOM    855  CD  GLN A 110      21.033  93.224  -9.083  1.00 61.47           C  
ATOM    856  OE1 GLN A 110      19.902  92.889  -8.701  1.00 64.33           O  
ATOM    857  NE2 GLN A 110      21.518  92.886 -10.271  1.00 74.32           N  
ATOM    858  N   ASN A 111      21.620  96.671  -5.151  1.00 21.70           N  
ATOM    859  CA  ASN A 111      21.500  98.138  -5.189  1.00 24.86           C  
ATOM    860  C   ASN A 111      22.069  98.859  -3.983  1.00 21.52           C  
ATOM    861  O   ASN A 111      21.656  99.957  -3.663  1.00 23.55           O  
ATOM    862  CB  ASN A 111      20.034  98.516  -5.354  1.00 25.83           C  
ATOM    863  CG  ASN A 111      19.433  97.886  -6.574  1.00 34.53           C  
ATOM    864  OD1 ASN A 111      18.387  97.255  -6.490  1.00 36.34           O  
ATOM    865  ND2 ASN A 111      20.128  97.996  -7.713  1.00 27.04           N  
ATOM    866  N   GLU A 112      23.008  98.236  -3.303  1.00 26.17           N  
ATOM    867  CA  GLU A 112      23.572  98.830  -2.098  1.00 25.08           C  
ATOM    868  C   GLU A 112      24.283 100.154  -2.438  1.00 22.15           C  
ATOM    869  O   GLU A 112      24.842 100.313  -3.502  1.00 21.60           O  
ATOM    870  CB  GLU A 112      24.534  97.872  -1.438  1.00 23.01           C  
ATOM    871  CG  GLU A 112      25.750  97.453  -2.302  1.00 26.98           C  
ATOM    872  CD  GLU A 112      26.584  96.344  -1.654  1.00 27.70           C  
ATOM    873  OE1 GLU A 112      26.104  95.700  -0.697  1.00 29.68           O  
ATOM    874  OE2 GLU A 112      27.722  96.116  -2.098  1.00 36.56           O  
ATOM    875  N   HIS A 113      24.253 101.094  -1.515  1.00 24.48           N  
ATOM    876  CA  HIS A 113      24.792 102.416  -1.747  1.00 22.51           C  
ATOM    877  C   HIS A 113      26.317 102.293  -1.933  1.00 24.22           C  
ATOM    878  O   HIS A 113      26.964 101.523  -1.232  1.00 18.48           O  
ATOM    879  CB  HIS A 113      24.464 103.310  -0.555  1.00 24.08           C  
ATOM    880  CG  HIS A 113      24.719 104.758  -0.798  1.00 24.48           C  
ATOM    881  ND1 HIS A 113      25.987 105.268  -0.981  1.00 23.01           N  
ATOM    882  CD2 HIS A 113      23.869 105.806  -0.890  1.00 26.81           C  
ATOM    883  CE1 HIS A 113      25.903 106.567  -1.199  1.00 27.36           C  
ATOM    884  NE2 HIS A 113      24.631 106.925  -1.119  1.00 30.67           N  
ATOM    885  N   PRO A 114      26.892 103.031  -2.901  1.00 20.45           N  
ATOM    886  CA  PRO A 114      28.352 102.976  -3.064  1.00 20.59           C  
ATOM    887  C   PRO A 114      29.178 103.176  -1.796  1.00 21.22           C  
ATOM    888  O   PRO A 114      30.261 102.591  -1.685  1.00 19.10           O  
ATOM    889  CB  PRO A 114      28.632 104.070  -4.097  1.00 23.44           C  
ATOM    890  CG  PRO A 114      27.399 104.173  -4.881  1.00 25.69           C  
ATOM    891  CD  PRO A 114      26.244 103.827  -3.961  1.00 23.84           C  
ATOM    892  N   VAL A 115      28.682 103.971  -0.849  1.00 18.21           N  
ATOM    893  CA  VAL A 115      29.404 104.219   0.426  1.00 20.06           C  
ATOM    894  C   VAL A 115      29.524 102.921   1.225  1.00 19.99           C  
ATOM    895  O   VAL A 115      30.597 102.595   1.767  1.00 21.91           O  
ATOM    896  CB  VAL A 115      28.693 105.319   1.248  1.00 20.28           C  
ATOM    897  CG1 VAL A 115      29.205 105.397   2.678  1.00 16.89           C  
ATOM    898  CG2 VAL A 115      28.788 106.668   0.521  1.00 12.63           C  
ATOM    899  N   PHE A 116      28.433 102.159   1.240  1.00 21.07           N  
ATOM    900  CA  PHE A 116      28.397 100.860   1.934  1.00 21.34           C  
ATOM    901  C   PHE A 116      29.112  99.751   1.187  1.00 21.42           C  
ATOM    902  O   PHE A 116      29.796  98.958   1.812  1.00 20.23           O  
ATOM    903  CB  PHE A 116      26.974 100.500   2.372  1.00 21.60           C  
ATOM    904  CG  PHE A 116      26.565 101.235   3.625  1.00 20.92           C  
ATOM    905  CD1 PHE A 116      26.119 102.543   3.561  1.00 25.78           C  
ATOM    906  CD2 PHE A 116      26.719 100.644   4.875  1.00 20.85           C  
ATOM    907  CE1 PHE A 116      25.798 103.232   4.715  1.00 21.19           C  
ATOM    908  CE2 PHE A 116      26.396 101.325   6.027  1.00 20.59           C  
ATOM    909  CZ  PHE A 116      25.937 102.617   5.965  1.00 21.74           C  
ATOM    910  N   ALA A 117      29.059  99.747  -0.144  1.00 19.06           N  
ATOM    911  CA  ALA A 117      29.941  98.836  -0.897  1.00 20.71           C  
ATOM    912  C   ALA A 117      31.419  99.051  -0.521  1.00 23.19           C  
ATOM    913  O   ALA A 117      32.158  98.075  -0.274  1.00 21.15           O  
ATOM    914  CB  ALA A 117      29.711  98.949  -2.404  1.00 17.46           C  
ATOM    915  N   TYR A 118      31.823 100.322  -0.413  1.00 20.48           N  
ATOM    916  CA  TYR A 118      33.187 100.674  -0.110  1.00 21.07           C  
ATOM    917  C   TYR A 118      33.553 100.255   1.334  1.00 19.80           C  
ATOM    918  O   TYR A 118      34.572  99.616   1.580  1.00 21.46           O  
ATOM    919  CB  TYR A 118      33.415 102.195  -0.298  1.00 20.43           C  
ATOM    920  CG  TYR A 118      34.759 102.670   0.260  1.00 20.68           C  
ATOM    921  CD1 TYR A 118      35.904 102.616  -0.512  1.00 18.95           C  
ATOM    922  CD2 TYR A 118      34.877 103.142   1.565  1.00 17.30           C  
ATOM    923  CE1 TYR A 118      37.124 103.032  -0.026  1.00 27.05           C  
ATOM    924  CE2 TYR A 118      36.099 103.591   2.058  1.00 16.77           C  
ATOM    925  CZ  TYR A 118      37.218 103.514   1.258  1.00 20.84           C  
ATOM    926  OH  TYR A 118      38.446 103.922   1.726  1.00 23.32           O  
ATOM    927  N   LEU A 119      32.715 100.625   2.273  1.00 19.48           N  
ATOM    928  CA  LEU A 119      33.013 100.398   3.691  1.00 21.17           C  
ATOM    929  C   LEU A 119      33.029  98.908   4.043  1.00 21.51           C  
ATOM    930  O   LEU A 119      33.880  98.478   4.822  1.00 19.65           O  
ATOM    931  CB  LEU A 119      32.027 101.155   4.591  1.00 19.69           C  
ATOM    932  CG  LEU A 119      32.151 102.688   4.633  1.00 24.33           C  
ATOM    933  CD1 LEU A 119      30.936 103.288   5.381  1.00 19.51           C  
ATOM    934  CD2 LEU A 119      33.474 103.197   5.252  1.00 21.66           C  
ATOM    935  N   LYS A 120      32.115  98.120   3.474  1.00 17.66           N  
ATOM    936  CA  LYS A 120      32.061  96.685   3.779  1.00 21.85           C  
ATOM    937  C   LYS A 120      33.238  95.925   3.168  1.00 21.22           C  
ATOM    938  O   LYS A 120      33.644  94.865   3.652  1.00 21.27           O  
ATOM    939  CB  LYS A 120      30.740  96.051   3.339  1.00 22.72           C  
ATOM    940  CG  LYS A 120      29.532  96.620   4.041  1.00 20.64           C  
ATOM    941  CD  LYS A 120      28.253  95.879   3.680  1.00 20.00           C  
ATOM    942  CE  LYS A 120      27.859  96.039   2.269  1.00 19.91           C  
ATOM    943  NZ  LYS A 120      26.624  95.250   1.911  1.00 19.30           N  
ATOM    944  N   ASP A 121      33.773  96.486   2.105  1.00 20.69           N  
ATOM    945  CA  ASP A 121      34.958  95.970   1.473  1.00 23.49           C  
ATOM    946  C   ASP A 121      36.200  96.247   2.298  1.00 23.06           C  
ATOM    947  O   ASP A 121      37.074  95.404   2.399  1.00 18.69           O  
ATOM    948  CB  ASP A 121      35.131  96.622   0.093  1.00 22.13           C  
ATOM    949  CG  ASP A 121      36.253  95.997  -0.684  1.00 28.73           C  
ATOM    950  OD1 ASP A 121      36.134  94.794  -1.024  1.00 41.11           O  
ATOM    951  OD2 ASP A 121      37.255  96.701  -0.933  1.00 32.62           O  
ATOM    952  N   LYS A 122      36.296  97.460   2.853  1.00 21.85           N  
ATOM    953  CA  LYS A 122      37.432  97.801   3.702  1.00 23.22           C  
ATOM    954  C   LYS A 122      37.310  97.157   5.065  1.00 22.61           C  
ATOM    955  O   LYS A 122      38.296  96.797   5.666  1.00 23.65           O  
ATOM    956  CB  LYS A 122      37.553  99.308   3.838  1.00 21.30           C  
ATOM    957  CG  LYS A 122      37.808  99.990   2.531  1.00 25.09           C  
ATOM    958  CD  LYS A 122      39.154  99.595   1.959  1.00 32.92           C  
ATOM    959  CE  LYS A 122      39.553 100.461   0.799  1.00 42.90           C  
ATOM    960  NZ  LYS A 122      41.058 100.517   0.657  1.00 55.62           N  
ATOM    961  N   LEU A 123      36.086  96.996   5.552  1.00 24.67           N  
ATOM    962  CA  LEU A 123      35.861  96.499   6.905  1.00 21.99           C  
ATOM    963  C   LEU A 123      34.784  95.411   6.848  1.00 23.32           C  
ATOM    964  O   LEU A 123      33.614  95.683   7.168  1.00 22.27           O  
ATOM    965  CB  LEU A 123      35.440  97.660   7.822  1.00 26.52           C  
ATOM    966  CG  LEU A 123      36.412  98.822   8.100  1.00 25.14           C  
ATOM    967  CD1 LEU A 123      35.602  99.980   8.675  1.00 24.71           C  
ATOM    968  CD2 LEU A 123      37.611  98.385   9.004  1.00 17.20           C  
ATOM    969  N   PRO A 124      35.167  94.187   6.401  1.00 22.31           N  
ATOM    970  CA  PRO A 124      34.206  93.115   6.089  1.00 23.16           C  
ATOM    971  C   PRO A 124      33.475  92.480   7.296  1.00 22.67           C  
ATOM    972  O   PRO A 124      32.487  91.778   7.100  1.00 19.83           O  
ATOM    973  CB  PRO A 124      35.058  92.081   5.329  1.00 23.43           C  
ATOM    974  CG  PRO A 124      36.469  92.375   5.652  1.00 29.88           C  
ATOM    975  CD  PRO A 124      36.569  93.776   6.174  1.00 25.56           C  
ATOM    976  N   TYR A 125      33.935  92.711   8.533  1.00 26.09           N  
ATOM    977  CA  TYR A 125      33.137  92.321   9.705  1.00 26.17           C  
ATOM    978  C   TYR A 125      33.314  93.241  10.895  1.00 24.70           C  
ATOM    979  O   TYR A 125      34.320  93.919  10.996  1.00 25.23           O  
ATOM    980  CB  TYR A 125      33.416  90.867  10.106  1.00 33.14           C  
ATOM    981  CG  TYR A 125      34.828  90.675  10.498  1.00 32.28           C  
ATOM    982  CD1 TYR A 125      35.260  91.035  11.798  1.00 40.42           C  
ATOM    983  CD2 TYR A 125      35.756  90.186   9.588  1.00 35.79           C  
ATOM    984  CE1 TYR A 125      36.589  90.906  12.188  1.00 46.96           C  
ATOM    985  CE2 TYR A 125      37.114  90.041   9.969  1.00 48.66           C  
ATOM    986  CZ  TYR A 125      37.514  90.405  11.269  1.00 44.68           C  
ATOM    987  OH  TYR A 125      38.823  90.266  11.661  1.00 51.41           O  
ATOM    988  N   PRO A 126      32.318  93.262  11.795  1.00 22.89           N  
ATOM    989  CA  PRO A 126      32.386  94.017  13.021  1.00 24.77           C  
ATOM    990  C   PRO A 126      33.445  93.487  13.968  1.00 25.50           C  
ATOM    991  O   PRO A 126      33.507  92.300  14.231  1.00 22.45           O  
ATOM    992  CB  PRO A 126      30.980  93.841  13.639  1.00 23.53           C  
ATOM    993  CG  PRO A 126      30.105  93.488  12.491  1.00 24.88           C  
ATOM    994  CD  PRO A 126      31.007  92.602  11.666  1.00 27.60           C  
ATOM    995  N   TYR A 127      34.248  94.402  14.476  1.00 25.83           N  
ATOM    996  CA  TYR A 127      35.314  94.116  15.408  1.00 25.03           C  
ATOM    997  C   TYR A 127      34.853  93.364  16.639  1.00 22.22           C  
ATOM    998  O   TYR A 127      35.536  92.449  17.056  1.00 23.84           O  
ATOM    999  CB  TYR A 127      35.948  95.440  15.834  1.00 25.51           C  
ATOM   1000  CG  TYR A 127      37.182  95.324  16.676  1.00 28.67           C  
ATOM   1001  CD1 TYR A 127      38.377  94.928  16.113  1.00 34.84           C  
ATOM   1002  CD2 TYR A 127      37.167  95.672  18.022  1.00 39.03           C  
ATOM   1003  CE1 TYR A 127      39.534  94.841  16.866  1.00 36.55           C  
ATOM   1004  CE2 TYR A 127      38.328  95.587  18.793  1.00 42.09           C  
ATOM   1005  CZ  TYR A 127      39.507  95.169  18.194  1.00 38.86           C  
ATOM   1006  OH  TYR A 127      40.675  95.079  18.922  1.00 45.39           O  
ATOM   1007  N   ASP A 128      33.724  93.782  17.214  1.00 22.20           N  
ATOM   1008  CA  ASP A 128      33.185  93.259  18.490  1.00 25.63           C  
ATOM   1009  C   ASP A 128      32.388  91.969  18.310  1.00 26.68           C  
ATOM   1010  O   ASP A 128      32.110  91.283  19.264  1.00 25.49           O  
ATOM   1011  CB  ASP A 128      32.252  94.295  19.152  1.00 27.27           C  
ATOM   1012  CG  ASP A 128      31.100  94.725  18.228  1.00 25.56           C  
ATOM   1013  OD1 ASP A 128      29.917  94.673  18.612  1.00 18.56           O  
ATOM   1014  OD2 ASP A 128      31.399  95.105  17.094  1.00 22.31           O  
ATOM   1015  N   ASP A 129      31.949  91.690  17.090  1.00 28.12           N  
ATOM   1016  CA  ASP A 129      31.141  90.506  16.824  1.00 26.21           C  
ATOM   1017  C   ASP A 129      31.335  90.161  15.359  1.00 24.41           C  
ATOM   1018  O   ASP A 129      30.516  90.534  14.493  1.00 24.48           O  
ATOM   1019  CB  ASP A 129      29.666  90.752  17.123  1.00 27.29           C  
ATOM   1020  CG  ASP A 129      28.801  89.520  16.836  1.00 32.92           C  
ATOM   1021  OD1 ASP A 129      29.328  88.527  16.281  1.00 27.74           O  
ATOM   1022  OD2 ASP A 129      27.604  89.545  17.171  1.00 35.28           O  
ATOM   1023  N   PRO A 130      32.441  89.476  15.066  1.00 26.05           N  
ATOM   1024  CA  PRO A 130      32.780  89.171  13.678  1.00 26.22           C  
ATOM   1025  C   PRO A 130      31.882  88.103  13.021  1.00 26.42           C  
ATOM   1026  O   PRO A 130      31.877  88.019  11.834  1.00 30.56           O  
ATOM   1027  CB  PRO A 130      34.223  88.629  13.770  1.00 26.01           C  
ATOM   1028  CG  PRO A 130      34.651  88.741  15.185  1.00 29.90           C  
ATOM   1029  CD  PRO A 130      33.426  88.944  16.020  1.00 24.24           C  
ATOM   1030  N   PHE A 131      31.157  87.280  13.768  1.00 22.69           N  
ATOM   1031  CA  PHE A 131      30.491  86.097  13.172  1.00 26.92           C  
ATOM   1032  C   PHE A 131      28.978  86.140  13.015  1.00 25.99           C  
ATOM   1033  O   PHE A 131      28.440  85.457  12.149  1.00 22.87           O  
ATOM   1034  CB  PHE A 131      30.849  84.873  13.982  1.00 36.53           C  
ATOM   1035  CG  PHE A 131      32.322  84.715  14.184  1.00 46.70           C  
ATOM   1036  CD1 PHE A 131      32.883  84.849  15.452  1.00 51.66           C  
ATOM   1037  CD2 PHE A 131      33.161  84.495  13.080  1.00 54.55           C  
ATOM   1038  CE1 PHE A 131      34.266  84.723  15.630  1.00 57.37           C  
ATOM   1039  CE2 PHE A 131      34.538  84.372  13.243  1.00 54.04           C  
ATOM   1040  CZ  PHE A 131      35.092  84.481  14.523  1.00 53.72           C  
ATOM   1041  N   SER A 132      28.273  86.898  13.860  1.00 25.65           N  
ATOM   1042  CA  SER A 132      26.808  86.870  13.833  1.00 22.73           C  
ATOM   1043  C   SER A 132      26.357  87.524  12.558  1.00 21.82           C  
ATOM   1044  O   SER A 132      26.978  88.485  12.109  1.00 23.58           O  
ATOM   1045  CB  SER A 132      26.208  87.650  14.997  1.00 22.75           C  
ATOM   1046  OG  SER A 132      26.709  87.184  16.203  1.00 25.97           O  
ATOM   1047  N   LEU A 133      25.302  86.996  11.956  1.00 24.12           N  
ATOM   1048  CA  LEU A 133      24.668  87.660  10.822  1.00 23.06           C  
ATOM   1049  C   LEU A 133      23.158  87.836  11.078  1.00 21.65           C  
ATOM   1050  O   LEU A 133      22.652  88.936  10.962  1.00 26.20           O  
ATOM   1051  CB  LEU A 133      24.951  86.935   9.494  1.00 20.79           C  
ATOM   1052  CG  LEU A 133      24.536  87.647   8.182  1.00 30.14           C  
ATOM   1053  CD1 LEU A 133      25.100  89.098   8.099  1.00 23.43           C  
ATOM   1054  CD2 LEU A 133      24.922  86.814   6.940  1.00 20.79           C  
ATOM   1055  N   MET A 134      22.446  86.766  11.415  1.00 23.54           N  
ATOM   1056  CA  MET A 134      20.994  86.846  11.645  1.00 19.84           C  
ATOM   1057  C   MET A 134      20.492  85.594  12.348  1.00 19.21           C  
ATOM   1058  O   MET A 134      20.790  84.507  11.938  1.00 22.36           O  
ATOM   1059  CB  MET A 134      20.235  87.025  10.305  1.00 21.13           C  
ATOM   1060  CG  MET A 134      18.823  87.602  10.448  1.00 24.21           C  
ATOM   1061  SD  MET A 134      18.820  89.418  10.610  1.00 23.07           S  
ATOM   1062  CE  MET A 134      19.250  90.000   8.942  1.00 23.18           C  
ATOM   1063  N   THR A 135      19.685  85.754  13.379  1.00 19.48           N  
ATOM   1064  CA  THR A 135      19.090  84.609  14.043  1.00 21.93           C  
ATOM   1065  C   THR A 135      17.969  84.009  13.159  1.00 23.19           C  
ATOM   1066  O   THR A 135      17.941  82.811  12.898  1.00 27.18           O  
ATOM   1067  CB  THR A 135      18.603  85.009  15.442  1.00 23.64           C  
ATOM   1068  OG1 THR A 135      19.734  85.493  16.165  1.00 28.14           O  
ATOM   1069  CG2 THR A 135      17.996  83.798  16.207  1.00 22.88           C  
ATOM   1070  N   ASP A 136      17.085  84.858  12.663  1.00 22.01           N  
ATOM   1071  CA  ASP A 136      15.942  84.418  11.876  1.00 20.18           C  
ATOM   1072  C   ASP A 136      16.245  84.638  10.394  1.00 16.38           C  
ATOM   1073  O   ASP A 136      16.309  85.780   9.948  1.00 21.12           O  
ATOM   1074  CB  ASP A 136      14.690  85.196  12.300  1.00 23.70           C  
ATOM   1075  CG  ASP A 136      13.453  84.871  11.452  1.00 30.13           C  
ATOM   1076  OD1 ASP A 136      13.475  83.906  10.639  1.00 28.52           O  
ATOM   1077  OD2 ASP A 136      12.443  85.596  11.623  1.00 31.11           O  
ATOM   1078  N   PRO A 137      16.453  83.541   9.629  1.00 14.94           N  
ATOM   1079  CA  PRO A 137      16.867  83.656   8.237  1.00 18.46           C  
ATOM   1080  C   PRO A 137      15.824  84.366   7.358  1.00 21.63           C  
ATOM   1081  O   PRO A 137      16.176  84.895   6.309  1.00 20.39           O  
ATOM   1082  CB  PRO A 137      17.095  82.191   7.824  1.00 13.05           C  
ATOM   1083  CG  PRO A 137      16.137  81.425   8.714  1.00 17.57           C  
ATOM   1084  CD  PRO A 137      16.309  82.129  10.026  1.00 15.97           C  
ATOM   1085  N   LYS A 138      14.566  84.414   7.810  1.00 20.50           N  
ATOM   1086  CA  LYS A 138      13.504  85.109   7.083  1.00 26.01           C  
ATOM   1087  C   LYS A 138      13.710  86.605   6.985  1.00 20.45           C  
ATOM   1088  O   LYS A 138      13.156  87.217   6.095  1.00 23.66           O  
ATOM   1089  CB  LYS A 138      12.138  84.867   7.730  1.00 24.95           C  
ATOM   1090  CG  LYS A 138      11.619  83.473   7.511  1.00 31.39           C  
ATOM   1091  CD  LYS A 138      10.087  83.390   7.841  1.00 38.37           C  
ATOM   1092  CE  LYS A 138       9.714  83.972   9.235  1.00 46.49           C  
ATOM   1093  NZ  LYS A 138      10.481  83.361  10.381  1.00 39.00           N  
ATOM   1094  N   LEU A 139      14.497  87.166   7.904  1.00 21.68           N  
ATOM   1095  CA  LEU A 139      14.835  88.591   7.936  1.00 20.35           C  
ATOM   1096  C   LEU A 139      15.923  88.978   6.948  1.00 20.34           C  
ATOM   1097  O   LEU A 139      16.157  90.180   6.710  1.00 23.08           O  
ATOM   1098  CB  LEU A 139      15.235  89.016   9.362  1.00 18.14           C  
ATOM   1099  CG  LEU A 139      14.132  88.932  10.432  1.00 26.82           C  
ATOM   1100  CD1 LEU A 139      14.671  89.208  11.875  1.00 23.41           C  
ATOM   1101  CD2 LEU A 139      12.954  89.861  10.096  1.00 19.94           C  
ATOM   1102  N   ILE A 140      16.535  87.988   6.308  1.00 17.41           N  
ATOM   1103  CA  ILE A 140      17.455  88.258   5.197  1.00 20.29           C  
ATOM   1104  C   ILE A 140      16.633  88.334   3.904  1.00 20.19           C  
ATOM   1105  O   ILE A 140      16.148  87.321   3.380  1.00 22.42           O  
ATOM   1106  CB  ILE A 140      18.564  87.198   5.106  1.00 20.49           C  
ATOM   1107  CG1 ILE A 140      19.333  87.136   6.408  1.00 21.79           C  
ATOM   1108  CG2 ILE A 140      19.533  87.530   3.976  1.00 14.99           C  
ATOM   1109  CD1 ILE A 140      20.268  85.953   6.486  1.00 21.89           C  
ATOM   1110  N   ILE A 141      16.447  89.554   3.418  1.00 21.36           N  
ATOM   1111  CA  ILE A 141      15.487  89.801   2.381  1.00 25.24           C  
ATOM   1112  C   ILE A 141      16.113  90.312   1.091  1.00 23.47           C  
ATOM   1113  O   ILE A 141      15.426  90.373   0.083  1.00 22.49           O  
ATOM   1114  CB  ILE A 141      14.339  90.743   2.859  1.00 24.68           C  
ATOM   1115  CG1 ILE A 141      14.881  92.107   3.307  1.00 29.70           C  
ATOM   1116  CG2 ILE A 141      13.452  90.017   3.958  1.00 20.67           C  
ATOM   1117  CD1 ILE A 141      13.801  93.190   3.472  1.00 29.64           C  
ATOM   1118  N   TRP A 142      17.416  90.585   1.123  1.00 21.99           N  
ATOM   1119  CA  TRP A 142      18.136  91.166  -0.000  1.00 20.94           C  
ATOM   1120  C   TRP A 142      18.855  90.101  -0.840  1.00 18.68           C  
ATOM   1121  O   TRP A 142      18.981  88.937  -0.454  1.00 22.60           O  
ATOM   1122  CB  TRP A 142      19.122  92.263   0.498  1.00 18.79           C  
ATOM   1123  CG  TRP A 142      20.059  91.774   1.510  1.00 17.58           C  
ATOM   1124  CD1 TRP A 142      21.273  91.170   1.282  1.00 19.62           C  
ATOM   1125  CD2 TRP A 142      19.863  91.748   2.936  1.00 18.65           C  
ATOM   1126  NE1 TRP A 142      21.824  90.765   2.473  1.00 19.95           N  
ATOM   1127  CE2 TRP A 142      20.981  91.094   3.500  1.00 18.33           C  
ATOM   1128  CE3 TRP A 142      18.835  92.183   3.784  1.00 14.43           C  
ATOM   1129  CZ2 TRP A 142      21.137  90.926   4.882  1.00 18.92           C  
ATOM   1130  CZ3 TRP A 142      18.991  92.001   5.178  1.00 24.73           C  
ATOM   1131  CH2 TRP A 142      20.130  91.371   5.697  1.00 17.06           C  
ATOM   1132  N   SER A 143      19.344  90.537  -1.994  1.00 20.62           N  
ATOM   1133  CA  SER A 143      20.006  89.677  -2.939  1.00 21.22           C  
ATOM   1134  C   SER A 143      21.074  90.480  -3.722  1.00 20.43           C  
ATOM   1135  O   SER A 143      20.818  91.585  -4.169  1.00 24.12           O  
ATOM   1136  CB  SER A 143      18.973  89.057  -3.891  1.00 21.25           C  
ATOM   1137  OG  SER A 143      19.628  88.169  -4.790  1.00 20.85           O  
ATOM   1138  N   PRO A 144      22.301  89.949  -3.847  1.00 21.19           N  
ATOM   1139  CA  PRO A 144      22.779  88.736  -3.206  1.00 17.58           C  
ATOM   1140  C   PRO A 144      23.114  88.990  -1.739  1.00 17.71           C  
ATOM   1141  O   PRO A 144      23.239  90.136  -1.276  1.00 17.40           O  
ATOM   1142  CB  PRO A 144      24.033  88.388  -4.008  1.00 20.47           C  
ATOM   1143  CG  PRO A 144      24.582  89.695  -4.447  1.00 23.59           C  
ATOM   1144  CD  PRO A 144      23.352  90.593  -4.659  1.00 22.81           C  
ATOM   1145  N   VAL A 145      23.255  87.893  -1.014  1.00 16.08           N  
ATOM   1146  CA  VAL A 145      23.710  87.894   0.370  1.00 17.51           C  
ATOM   1147  C   VAL A 145      25.206  87.578   0.371  1.00 17.00           C  
ATOM   1148  O   VAL A 145      25.670  86.638  -0.307  1.00 14.02           O  
ATOM   1149  CB  VAL A 145      22.939  86.842   1.192  1.00 15.61           C  
ATOM   1150  CG1 VAL A 145      23.206  87.000   2.716  1.00 14.47           C  
ATOM   1151  CG2 VAL A 145      21.428  86.908   0.863  1.00  9.55           C  
ATOM   1152  N   ARG A 146      25.940  88.426   1.082  1.00 18.82           N  
ATOM   1153  CA  ARG A 146      27.396  88.330   1.204  0.50 20.12           C  
ATOM   1155  C   ARG A 146      27.796  88.268   2.695  1.00 18.83           C  
ATOM   1156  O   ARG A 146      27.057  88.732   3.572  1.00 16.91           O  
ATOM   1157  CB  ARG A 146      28.066  89.505   0.468  0.50 20.38           C  
ATOM   1159  CG  ARG A 146      27.564  89.699  -0.989  0.50 19.47           C  
ATOM   1161  CD  ARG A 146      28.317  90.805  -1.701  0.50 25.12           C  
ATOM   1163  NE  ARG A 146      28.271  90.689  -3.163  0.50 39.71           N  
ATOM   1165  CZ  ARG A 146      28.810  91.573  -4.012  0.50 36.04           C  
ATOM   1167  NH1 ARG A 146      29.404  92.678  -3.572  0.50 36.60           N  
ATOM   1169  NH2 ARG A 146      28.726  91.359  -5.316  0.50 38.15           N  
ATOM   1171  N   ARG A 147      28.944  87.655   2.968  1.00 19.73           N  
ATOM   1172  CA  ARG A 147      29.430  87.405   4.344  1.00 16.88           C  
ATOM   1173  C   ARG A 147      29.705  88.699   5.115  1.00 17.09           C  
ATOM   1174  O   ARG A 147      29.651  88.737   6.339  1.00 20.96           O  
ATOM   1175  CB  ARG A 147      30.707  86.556   4.299  1.00 15.74           C  
ATOM   1176  CG  ARG A 147      30.564  85.226   3.599  1.00 12.54           C  
ATOM   1177  CD  ARG A 147      31.845  84.414   3.687  1.00 10.70           C  
ATOM   1178  NE  ARG A 147      31.740  83.165   2.950  1.00 17.28           N  
ATOM   1179  CZ  ARG A 147      31.183  82.054   3.432  1.00 20.27           C  
ATOM   1180  NH1 ARG A 147      30.700  82.033   4.654  1.00 13.37           N  
ATOM   1181  NH2 ARG A 147      31.073  80.972   2.676  1.00 12.64           N  
ATOM   1182  N   SER A 148      30.009  89.752   4.376  1.00 18.29           N  
ATOM   1183  CA  SER A 148      30.268  91.067   4.913  1.00 16.63           C  
ATOM   1184  C   SER A 148      29.045  91.947   5.095  1.00 15.94           C  
ATOM   1185  O   SER A 148      29.159  93.100   5.494  1.00 18.10           O  
ATOM   1186  CB  SER A 148      31.262  91.782   3.989  1.00 17.46           C  
ATOM   1187  OG  SER A 148      30.825  91.798   2.635  1.00 21.99           O  
ATOM   1188  N   ASP A 149      27.863  91.429   4.807  1.00 17.40           N  
ATOM   1189  CA  ASP A 149      26.661  92.252   4.862  1.00 17.22           C  
ATOM   1190  C   ASP A 149      26.357  92.886   6.229  1.00 17.45           C  
ATOM   1191  O   ASP A 149      26.629  92.302   7.311  1.00 18.38           O  
ATOM   1192  CB  ASP A 149      25.464  91.436   4.382  1.00 20.30           C  
ATOM   1193  CG  ASP A 149      25.413  91.283   2.862  1.00 16.42           C  
ATOM   1194  OD1 ASP A 149      26.173  91.965   2.113  1.00 20.68           O  
ATOM   1195  OD2 ASP A 149      24.589  90.457   2.423  1.00 21.43           O  
ATOM   1196  N   VAL A 150      25.827  94.107   6.192  1.00 17.11           N  
ATOM   1197  CA  VAL A 150      25.247  94.701   7.391  1.00 17.66           C  
ATOM   1198  C   VAL A 150      24.146  93.772   7.942  1.00 17.30           C  
ATOM   1199  O   VAL A 150      23.315  93.264   7.192  1.00 19.22           O  
ATOM   1200  CB  VAL A 150      24.767  96.140   7.137  1.00 18.98           C  
ATOM   1201  CG1 VAL A 150      23.961  96.695   8.344  1.00 17.16           C  
ATOM   1202  CG2 VAL A 150      25.956  97.009   6.841  1.00 18.03           C  
ATOM   1203  N   ALA A 151      24.184  93.548   9.256  1.00 16.94           N  
ATOM   1204  CA  ALA A 151      23.385  92.528   9.915  1.00 20.11           C  
ATOM   1205  C   ALA A 151      22.049  93.062  10.467  1.00 23.97           C  
ATOM   1206  O   ALA A 151      21.072  92.334  10.526  1.00 21.21           O  
ATOM   1207  CB  ALA A 151      24.210  91.832  11.032  1.00 15.73           C  
ATOM   1208  N   TRP A 152      22.019  94.327  10.865  1.00 21.42           N  
ATOM   1209  CA  TRP A 152      20.814  94.945  11.362  1.00 17.95           C  
ATOM   1210  C   TRP A 152      20.953  96.457  11.281  1.00 20.61           C  
ATOM   1211  O   TRP A 152      21.984  97.007  10.816  1.00 20.65           O  
ATOM   1212  CB  TRP A 152      20.514  94.484  12.808  1.00 20.14           C  
ATOM   1213  CG  TRP A 152      19.069  94.587  13.178  1.00 20.44           C  
ATOM   1214  CD1 TRP A 152      18.514  95.412  14.149  1.00 22.61           C  
ATOM   1215  CD2 TRP A 152      17.965  93.884  12.582  1.00 23.40           C  
ATOM   1216  NE1 TRP A 152      17.153  95.245  14.186  1.00 23.41           N  
ATOM   1217  CE2 TRP A 152      16.782  94.319  13.245  1.00 20.85           C  
ATOM   1218  CE3 TRP A 152      17.854  92.934  11.563  1.00 20.53           C  
ATOM   1219  CZ2 TRP A 152      15.514  93.827  12.918  1.00 21.94           C  
ATOM   1220  CZ3 TRP A 152      16.593  92.467  11.219  1.00 21.19           C  
ATOM   1221  CH2 TRP A 152      15.437  92.904  11.914  1.00 19.87           C  
ATOM   1222  N   ASN A 153      19.892  97.135  11.703  1.00 20.93           N  
ATOM   1223  CA  ASN A 153      19.924  98.582  11.840  1.00 22.57           C  
ATOM   1224  C   ASN A 153      21.047  98.936  12.800  1.00 22.66           C  
ATOM   1225  O   ASN A 153      21.302  98.179  13.740  1.00 19.18           O  
ATOM   1226  CB  ASN A 153      18.577  99.093  12.384  1.00 24.06           C  
ATOM   1227  CG  ASN A 153      17.432  98.699  11.522  1.00 22.39           C  
ATOM   1228  OD1 ASN A 153      17.380  99.067  10.342  1.00 19.83           O  
ATOM   1229  ND2 ASN A 153      16.519  97.898  12.071  1.00 20.44           N  
ATOM   1230  N   PHE A 154      21.696 100.072  12.564  1.00 21.45           N  
ATOM   1231  CA  PHE A 154      22.740 100.598  13.458  1.00 23.18           C  
ATOM   1232  C   PHE A 154      24.021  99.747  13.608  1.00 20.43           C  
ATOM   1233  O   PHE A 154      24.545  99.548  14.701  1.00 19.05           O  
ATOM   1234  CB  PHE A 154      22.146 100.978  14.813  1.00 21.29           C  
ATOM   1235  CG  PHE A 154      21.004 101.977  14.723  1.00 21.24           C  
ATOM   1236  CD1 PHE A 154      21.260 103.337  14.588  1.00 25.99           C  
ATOM   1237  CD2 PHE A 154      19.679 101.551  14.803  1.00 29.05           C  
ATOM   1238  CE1 PHE A 154      20.215 104.258  14.511  1.00 24.64           C  
ATOM   1239  CE2 PHE A 154      18.630 102.453  14.751  1.00 27.50           C  
ATOM   1240  CZ  PHE A 154      18.892 103.809  14.607  1.00 19.77           C  
ATOM   1241  N   GLU A 155      24.562  99.304  12.485  1.00 20.71           N  
ATOM   1242  CA  GLU A 155      25.986  99.050  12.423  1.00 18.47           C  
ATOM   1243  C   GLU A 155      26.707 100.395  12.197  1.00 16.27           C  
ATOM   1244  O   GLU A 155      26.117 101.363  11.738  1.00 19.86           O  
ATOM   1245  CB  GLU A 155      26.343  98.038  11.337  1.00 21.84           C  
ATOM   1246  CG  GLU A 155      25.933  96.636  11.695  1.00 20.68           C  
ATOM   1247  CD  GLU A 155      26.640  95.587  10.864  1.00 23.14           C  
ATOM   1248  OE1 GLU A 155      27.484  95.943  10.008  1.00 26.43           O  
ATOM   1249  OE2 GLU A 155      26.345  94.398  11.059  1.00 21.77           O  
ATOM   1250  N   LYS A 156      27.983 100.427  12.553  1.00 21.55           N  
ATOM   1251  CA  LYS A 156      28.735 101.660  12.738  1.00 17.77           C  
ATOM   1252  C   LYS A 156      30.106 101.461  12.094  1.00 17.74           C  
ATOM   1253  O   LYS A 156      30.693 100.403  12.222  1.00 17.21           O  
ATOM   1254  CB  LYS A 156      28.808 101.960  14.252  1.00 23.63           C  
ATOM   1255  CG  LYS A 156      27.499 101.459  14.954  1.00 27.66           C  
ATOM   1256  CD  LYS A 156      27.348 101.677  16.351  1.00 19.28           C  
ATOM   1257  CE  LYS A 156      25.864 101.416  16.801  1.00 23.74           C  
ATOM   1258  NZ  LYS A 156      25.599  99.981  17.089  1.00 17.03           N  
ATOM   1259  N   PHE A 157      30.560 102.464  11.334  1.00 19.37           N  
ATOM   1260  CA  PHE A 157      31.835 102.438  10.617  1.00 19.44           C  
ATOM   1261  C   PHE A 157      32.579 103.726  10.976  1.00 19.20           C  
ATOM   1262  O   PHE A 157      32.060 104.808  10.733  1.00 21.67           O  
ATOM   1263  CB  PHE A 157      31.602 102.409   9.103  1.00 22.16           C  
ATOM   1264  CG  PHE A 157      30.865 101.191   8.620  1.00 23.52           C  
ATOM   1265  CD1 PHE A 157      31.544 100.120   8.076  1.00 24.25           C  
ATOM   1266  CD2 PHE A 157      29.468 101.125   8.704  1.00 28.25           C  
ATOM   1267  CE1 PHE A 157      30.831  98.995   7.608  1.00 21.23           C  
ATOM   1268  CE2 PHE A 157      28.766 100.011   8.281  1.00 26.09           C  
ATOM   1269  CZ  PHE A 157      29.433  98.960   7.725  1.00 20.94           C  
ATOM   1270  N   LEU A 158      33.741 103.606  11.620  1.00 18.62           N  
ATOM   1271  CA  LEU A 158      34.564 104.753  11.920  1.00 19.79           C  
ATOM   1272  C   LEU A 158      35.733 104.854  10.922  1.00 20.87           C  
ATOM   1273  O   LEU A 158      36.473 103.875  10.736  1.00 19.30           O  
ATOM   1274  CB  LEU A 158      35.120 104.660  13.318  1.00 18.04           C  
ATOM   1275  CG  LEU A 158      35.934 105.850  13.818  1.00 18.97           C  
ATOM   1276  CD1 LEU A 158      35.111 107.198  13.785  1.00 18.01           C  
ATOM   1277  CD2 LEU A 158      36.486 105.532  15.194  1.00 19.92           C  
ATOM   1278  N   ILE A 159      35.886 106.037  10.320  1.00 19.35           N  
ATOM   1279  CA  ILE A 159      36.976 106.325   9.364  1.00 18.52           C  
ATOM   1280  C   ILE A 159      37.863 107.454   9.911  1.00 18.04           C  
ATOM   1281  O   ILE A 159      37.378 108.463  10.461  1.00 19.52           O  
ATOM   1282  CB  ILE A 159      36.414 106.733   7.991  1.00 18.20           C  
ATOM   1283  CG1 ILE A 159      35.388 105.693   7.489  1.00 22.33           C  
ATOM   1284  CG2 ILE A 159      37.562 107.014   6.950  1.00 19.68           C  
ATOM   1285  CD1 ILE A 159      33.849 105.999   7.916  1.00 14.67           C  
ATOM   1286  N   GLY A 160      39.170 107.289   9.761  1.00 19.17           N  
ATOM   1287  CA  GLY A 160      40.085 108.262  10.273  1.00 18.84           C  
ATOM   1288  C   GLY A 160      40.190 109.530   9.465  1.00 19.35           C  
ATOM   1289  O   GLY A 160      39.683 109.611   8.329  1.00 20.92           O  
ATOM   1290  N   PRO A 161      40.861 110.542  10.045  1.00 20.93           N  
ATOM   1291  CA  PRO A 161      41.039 111.861   9.414  1.00 24.58           C  
ATOM   1292  C   PRO A 161      41.871 111.874   8.102  1.00 22.84           C  
ATOM   1293  O   PRO A 161      41.847 112.850   7.343  1.00 21.10           O  
ATOM   1294  CB  PRO A 161      41.674 112.709  10.527  1.00 27.44           C  
ATOM   1295  CG  PRO A 161      42.287 111.697  11.493  1.00 24.41           C  
ATOM   1296  CD  PRO A 161      41.493 110.451  11.375  1.00 20.52           C  
ATOM   1297  N   GLU A 162      42.582 110.795   7.827  1.00 23.16           N  
ATOM   1298  CA  GLU A 162      43.281 110.669   6.567  1.00 26.07           C  
ATOM   1299  C   GLU A 162      42.545 109.779   5.555  1.00 23.54           C  
ATOM   1300  O   GLU A 162      43.052 109.538   4.471  1.00 24.20           O  
ATOM   1301  CB  GLU A 162      44.723 110.208   6.796  1.00 29.61           C  
ATOM   1302  CG  GLU A 162      45.636 111.271   7.435  1.00 35.78           C  
ATOM   1303  CD  GLU A 162      45.838 111.072   8.947  1.00 56.92           C  
ATOM   1304  OE1 GLU A 162      45.748 109.919   9.436  1.00 67.21           O  
ATOM   1305  OE2 GLU A 162      46.090 112.075   9.657  1.00 66.92           O  
ATOM   1306  N   GLY A 163      41.337 109.340   5.897  1.00 18.40           N  
ATOM   1307  CA  GLY A 163      40.439 108.687   4.945  1.00 20.83           C  
ATOM   1308  C   GLY A 163      40.463 107.182   4.960  1.00 19.43           C  
ATOM   1309  O   GLY A 163      39.850 106.554   4.104  1.00 22.60           O  
ATOM   1310  N   GLU A 164      41.154 106.592   5.931  1.00 21.56           N  
ATOM   1311  CA  GLU A 164      41.316 105.139   6.003  1.00 23.03           C  
ATOM   1312  C   GLU A 164      40.286 104.583   6.972  1.00 21.14           C  
ATOM   1313  O   GLU A 164      40.276 104.971   8.137  1.00 16.22           O  
ATOM   1314  CB  GLU A 164      42.741 104.784   6.470  1.00 24.30           C  
ATOM   1315  CG  GLU A 164      43.143 103.350   6.135  1.00 41.60           C  
ATOM   1316  CD  GLU A 164      42.973 102.995   4.636  1.00 53.41           C  
ATOM   1317  OE1 GLU A 164      43.276 103.849   3.754  1.00 46.12           O  
ATOM   1318  OE2 GLU A 164      42.527 101.853   4.354  1.00 60.21           O  
ATOM   1319  N   PRO A 165      39.354 103.742   6.485  1.00 22.97           N  
ATOM   1320  CA  PRO A 165      38.435 103.154   7.466  1.00 21.11           C  
ATOM   1321  C   PRO A 165      39.163 102.406   8.572  1.00 21.07           C  
ATOM   1322  O   PRO A 165      40.092 101.677   8.293  1.00 21.31           O  
ATOM   1323  CB  PRO A 165      37.560 102.242   6.622  1.00 19.96           C  
ATOM   1324  CG  PRO A 165      37.573 102.884   5.256  1.00 26.65           C  
ATOM   1325  CD  PRO A 165      39.005 103.339   5.107  1.00 23.01           C  
ATOM   1326  N   PHE A 166      38.720 102.599   9.816  1.00 19.69           N  
ATOM   1327  CA  PHE A 166      39.443 102.130  10.979  1.00 20.15           C  
ATOM   1328  C   PHE A 166      38.749 100.929  11.635  1.00 18.27           C  
ATOM   1329  O   PHE A 166      39.375  99.936  11.933  1.00 20.59           O  
ATOM   1330  CB  PHE A 166      39.612 103.260  12.008  1.00 21.37           C  
ATOM   1331  CG  PHE A 166      40.145 102.780  13.335  1.00 26.76           C  
ATOM   1332  CD1 PHE A 166      41.469 102.362  13.461  1.00 29.72           C  
ATOM   1333  CD2 PHE A 166      39.318 102.688  14.443  1.00 26.10           C  
ATOM   1334  CE1 PHE A 166      41.939 101.900  14.684  1.00 23.29           C  
ATOM   1335  CE2 PHE A 166      39.805 102.236  15.651  1.00 23.24           C  
ATOM   1336  CZ  PHE A 166      41.101 101.823  15.757  1.00 22.34           C  
ATOM   1337  N   ARG A 167      37.456 101.040  11.879  1.00 19.20           N  
ATOM   1338  CA  ARG A 167      36.756 100.012  12.598  1.00 17.49           C  
ATOM   1339  C   ARG A 167      35.268  99.995  12.291  1.00 18.30           C  
ATOM   1340  O   ARG A 167      34.633 101.045  12.082  1.00 21.68           O  
ATOM   1341  CB  ARG A 167      36.992 100.200  14.115  1.00 19.40           C  
ATOM   1342  CG  ARG A 167      36.502  99.078  14.981  1.00 19.26           C  
ATOM   1343  CD  ARG A 167      37.204  99.019  16.311  1.00 19.73           C  
ATOM   1344  NE  ARG A 167      38.579  98.624  16.141  1.00 20.82           N  
ATOM   1345  CZ  ARG A 167      39.529  98.721  17.066  1.00 28.56           C  
ATOM   1346  NH1 ARG A 167      39.298  99.253  18.266  1.00 24.72           N  
ATOM   1347  NH2 ARG A 167      40.739  98.289  16.761  1.00 25.33           N  
ATOM   1348  N   ARG A 168      34.721  98.781  12.295  1.00 18.05           N  
ATOM   1349  CA  ARG A 168      33.316  98.544  12.189  1.00 17.24           C  
ATOM   1350  C   ARG A 168      32.788  97.921  13.482  1.00 16.58           C  
ATOM   1351  O   ARG A 168      33.420  97.051  14.083  1.00 21.72           O  
ATOM   1352  CB  ARG A 168      33.046  97.688  10.952  1.00 16.91           C  
ATOM   1353  CG  ARG A 168      31.607  97.213  10.782  1.00 19.37           C  
ATOM   1354  CD  ARG A 168      31.623  96.217   9.642  1.00 18.09           C  
ATOM   1355  NE  ARG A 168      30.324  95.682   9.325  1.00 19.66           N  
ATOM   1356  CZ  ARG A 168      30.082  94.899   8.270  1.00 18.44           C  
ATOM   1357  NH1 ARG A 168      31.031  94.611   7.384  1.00 26.72           N  
ATOM   1358  NH2 ARG A 168      28.880  94.411   8.092  1.00 21.06           N  
ATOM   1359  N   TYR A 169      31.625  98.413  13.926  1.00 18.70           N  
ATOM   1360  CA  TYR A 169      30.998  97.993  15.177  1.00 20.27           C  
ATOM   1361  C   TYR A 169      29.584  97.456  14.895  1.00 21.30           C  
ATOM   1362  O   TYR A 169      28.866  97.959  14.029  1.00 19.93           O  
ATOM   1363  CB  TYR A 169      30.952  99.152  16.222  1.00 18.11           C  
ATOM   1364  CG  TYR A 169      32.220  99.966  16.347  1.00 20.17           C  
ATOM   1365  CD1 TYR A 169      33.094  99.792  17.434  1.00 19.41           C  
ATOM   1366  CD2 TYR A 169      32.563 100.910  15.375  1.00 18.51           C  
ATOM   1367  CE1 TYR A 169      34.223 100.544  17.558  1.00 24.43           C  
ATOM   1368  CE2 TYR A 169      33.707 101.652  15.484  1.00 17.96           C  
ATOM   1369  CZ  TYR A 169      34.519 101.494  16.578  1.00 16.81           C  
ATOM   1370  OH  TYR A 169      35.654 102.243  16.664  1.00 24.62           O  
ATOM   1371  N   SER A 170      29.190  96.437  15.651  1.00 23.86           N  
ATOM   1372  CA  SER A 170      27.955  95.731  15.415  1.00 23.87           C  
ATOM   1373  C   SER A 170      26.759  96.453  15.987  1.00 25.63           C  
ATOM   1374  O   SER A 170      26.902  97.448  16.702  1.00 20.39           O  
ATOM   1375  CB  SER A 170      28.020  94.290  15.971  1.00 29.07           C  
ATOM   1376  OG  SER A 170      27.732  94.234  17.358  1.00 19.82           O  
ATOM   1377  N   ARG A 171      25.582  95.933  15.619  1.00 25.14           N  
ATOM   1378  CA  ARG A 171      24.280  96.351  16.161  1.00 24.47           C  
ATOM   1379  C   ARG A 171      24.221  96.415  17.679  1.00 22.83           C  
ATOM   1380  O   ARG A 171      23.436  97.187  18.208  1.00 23.39           O  
ATOM   1381  CB  ARG A 171      23.172  95.413  15.677  1.00 22.47           C  
ATOM   1382  CG  ARG A 171      23.229  93.975  16.271  1.00 24.04           C  
ATOM   1383  CD  ARG A 171      22.133  93.064  15.746  1.00 25.94           C  
ATOM   1384  NE  ARG A 171      20.823  93.421  16.254  1.00 39.06           N  
ATOM   1385  CZ  ARG A 171      19.679  92.804  15.937  1.00 44.84           C  
ATOM   1386  NH1 ARG A 171      19.652  91.802  15.051  1.00 36.37           N  
ATOM   1387  NH2 ARG A 171      18.540  93.211  16.495  1.00 37.63           N  
ATOM   1388  N   THR A 172      25.045  95.631  18.380  1.00 21.53           N  
ATOM   1389  CA  THR A 172      25.024  95.632  19.856  1.00 25.33           C  
ATOM   1390  C   THR A 172      26.040  96.577  20.483  1.00 25.71           C  
ATOM   1391  O   THR A 172      25.994  96.798  21.676  1.00 25.87           O  
ATOM   1392  CB  THR A 172      25.260  94.216  20.442  1.00 26.40           C  
ATOM   1393  OG1 THR A 172      26.354  93.616  19.759  1.00 32.59           O  
ATOM   1394  CG2 THR A 172      24.004  93.329  20.293  1.00 25.36           C  
ATOM   1395  N   PHE A 173      26.935  97.161  19.685  1.00 25.98           N  
ATOM   1396  CA  PHE A 173      27.958  98.037  20.212  1.00 21.85           C  
ATOM   1397  C   PHE A 173      27.372  99.455  20.329  1.00 22.11           C  
ATOM   1398  O   PHE A 173      27.036 100.058  19.297  1.00 24.20           O  
ATOM   1399  CB  PHE A 173      29.191  98.038  19.298  1.00 22.57           C  
ATOM   1400  CG  PHE A 173      30.426  98.609  19.961  1.00 21.73           C  
ATOM   1401  CD1 PHE A 173      31.350  97.777  20.593  1.00 27.30           C  
ATOM   1402  CD2 PHE A 173      30.645  99.981  19.979  1.00 22.74           C  
ATOM   1403  CE1 PHE A 173      32.484  98.319  21.185  1.00 27.40           C  
ATOM   1404  CE2 PHE A 173      31.764 100.523  20.571  1.00 18.49           C  
ATOM   1405  CZ  PHE A 173      32.681  99.714  21.176  1.00 23.11           C  
ATOM   1406  N   PRO A 174      27.254 100.004  21.569  1.00 22.27           N  
ATOM   1407  CA  PRO A 174      26.716 101.345  21.728  1.00 21.95           C  
ATOM   1408  C   PRO A 174      27.495 102.430  20.993  1.00 24.12           C  
ATOM   1409  O   PRO A 174      28.733 102.443  21.036  1.00 20.53           O  
ATOM   1410  CB  PRO A 174      26.783 101.559  23.222  1.00 25.56           C  
ATOM   1411  CG  PRO A 174      26.634 100.176  23.780  1.00 26.28           C  
ATOM   1412  CD  PRO A 174      27.543  99.408  22.889  1.00 22.54           C  
ATOM   1413  N   THR A 175      26.755 103.302  20.304  1.00 18.91           N  
ATOM   1414  CA  THR A 175      27.314 104.434  19.596  1.00 21.70           C  
ATOM   1415  C   THR A 175      28.233 105.252  20.485  1.00 23.56           C  
ATOM   1416  O   THR A 175      29.354 105.538  20.116  1.00 19.46           O  
ATOM   1417  CB  THR A 175      26.182 105.306  19.032  1.00 23.60           C  
ATOM   1418  OG1 THR A 175      25.475 104.547  18.042  1.00 19.05           O  
ATOM   1419  CG2 THR A 175      26.690 106.565  18.403  1.00 18.89           C  
ATOM   1420  N   ILE A 176      27.772 105.592  21.689  1.00 21.40           N  
ATOM   1421  CA  ILE A 176      28.584 106.426  22.551  1.00 24.61           C  
ATOM   1422  C   ILE A 176      29.904 105.747  22.965  1.00 22.24           C  
ATOM   1423  O   ILE A 176      30.870 106.432  23.238  1.00 22.44           O  
ATOM   1424  CB  ILE A 176      27.796 106.882  23.784  1.00 25.49           C  
ATOM   1425  CG1 ILE A 176      28.292 108.272  24.215  1.00 25.55           C  
ATOM   1426  CG2 ILE A 176      27.804 105.773  24.833  1.00 22.78           C  
ATOM   1427  CD1 ILE A 176      27.932 109.359  23.180  1.00 16.82           C  
ATOM   1428  N   ASN A 177      29.964 104.415  22.943  1.00 23.97           N  
ATOM   1429  CA  ASN A 177      31.208 103.712  23.259  1.00 23.68           C  
ATOM   1430  C   ASN A 177      32.276 103.767  22.148  1.00 21.76           C  
ATOM   1431  O   ASN A 177      33.353 103.220  22.317  1.00 20.68           O  
ATOM   1432  CB  ASN A 177      30.922 102.248  23.594  1.00 25.24           C  
ATOM   1433  CG  ASN A 177      30.236 102.072  24.911  1.00 26.92           C  
ATOM   1434  OD1 ASN A 177      29.835 103.039  25.566  1.00 33.11           O  
ATOM   1435  ND2 ASN A 177      30.109 100.818  25.327  1.00 19.70           N  
ATOM   1436  N   ILE A 178      31.972 104.416  21.025  1.00 21.37           N  
ATOM   1437  CA  ILE A 178      32.936 104.608  19.944  1.00 18.59           C  
ATOM   1438  C   ILE A 178      33.854 105.792  20.248  1.00 19.87           C  
ATOM   1439  O   ILE A 178      34.920 105.944  19.631  1.00 19.74           O  
ATOM   1440  CB  ILE A 178      32.219 104.757  18.554  1.00 20.33           C  
ATOM   1441  CG1 ILE A 178      31.415 103.483  18.245  1.00 19.64           C  
ATOM   1442  CG2 ILE A 178      33.243 105.041  17.456  1.00 15.07           C  
ATOM   1443  CD1 ILE A 178      30.457 103.571  17.073  1.00 14.97           C  
ATOM   1444  N   GLU A 179      33.462 106.618  21.221  1.00 22.62           N  
ATOM   1445  CA  GLU A 179      34.211 107.808  21.524  1.00 22.61           C  
ATOM   1446  C   GLU A 179      35.715 107.620  21.797  1.00 21.61           C  
ATOM   1447  O   GLU A 179      36.515 108.377  21.283  1.00 17.93           O  
ATOM   1448  CB  GLU A 179      33.562 108.587  22.664  1.00 24.79           C  
ATOM   1449  CG  GLU A 179      34.172 109.974  22.816  1.00 30.70           C  
ATOM   1450  CD  GLU A 179      33.640 110.715  24.000  1.00 43.48           C  
ATOM   1451  OE1 GLU A 179      32.789 110.158  24.723  1.00 62.68           O  
ATOM   1452  OE2 GLU A 179      34.057 111.865  24.198  1.00 56.93           O  
ATOM   1453  N   PRO A 180      36.108 106.653  22.648  1.00 22.18           N  
ATOM   1454  CA  PRO A 180      37.558 106.470  22.832  1.00 23.63           C  
ATOM   1455  C   PRO A 180      38.334 106.298  21.523  1.00 21.18           C  
ATOM   1456  O   PRO A 180      39.440 106.807  21.394  1.00 20.25           O  
ATOM   1457  CB  PRO A 180      37.635 105.209  23.683  1.00 20.74           C  
ATOM   1458  CG  PRO A 180      36.374 105.282  24.477  1.00 21.06           C  
ATOM   1459  CD  PRO A 180      35.340 105.729  23.486  1.00 17.08           C  
ATOM   1460  N   ASP A 181      37.759 105.578  20.564  1.00 21.63           N  
ATOM   1461  CA  ASP A 181      38.414 105.393  19.254  1.00 22.83           C  
ATOM   1462  C   ASP A 181      38.416 106.661  18.429  1.00 20.47           C  
ATOM   1463  O   ASP A 181      39.394 106.938  17.731  1.00 20.26           O  
ATOM   1464  CB  ASP A 181      37.780 104.265  18.434  1.00 22.17           C  
ATOM   1465  CG  ASP A 181      38.021 102.872  19.040  1.00 28.58           C  
ATOM   1466  OD1 ASP A 181      38.993 102.695  19.800  1.00 27.24           O  
ATOM   1467  OD2 ASP A 181      37.219 101.962  18.734  1.00 31.66           O  
ATOM   1468  N   ILE A 182      37.349 107.437  18.523  1.00 17.71           N  
ATOM   1469  CA  ILE A 182      37.347 108.783  17.898  1.00 21.08           C  
ATOM   1470  C   ILE A 182      38.489 109.636  18.463  1.00 20.18           C  
ATOM   1471  O   ILE A 182      39.264 110.182  17.698  1.00 19.29           O  
ATOM   1472  CB  ILE A 182      35.980 109.477  18.011  1.00 14.92           C  
ATOM   1473  CG1 ILE A 182      34.939 108.722  17.164  1.00 18.01           C  
ATOM   1474  CG2 ILE A 182      36.033 110.989  17.640  1.00 19.23           C  
ATOM   1475  CD1 ILE A 182      33.519 109.151  17.544  1.00 18.40           C  
ATOM   1476  N   LYS A 183      38.621 109.700  19.785  1.00 23.65           N  
ATOM   1477  CA  LYS A 183      39.695 110.473  20.424  1.00 25.45           C  
ATOM   1478  C   LYS A 183      41.081 110.013  19.945  1.00 26.89           C  
ATOM   1479  O   LYS A 183      41.962 110.822  19.611  1.00 25.34           O  
ATOM   1480  CB  LYS A 183      39.605 110.343  21.948  1.00 26.76           C  
ATOM   1481  CG  LYS A 183      38.311 110.884  22.541  1.00 29.68           C  
ATOM   1482  CD  LYS A 183      38.473 111.370  24.017  1.00 37.01           C  
ATOM   1483  CE  LYS A 183      37.139 111.951  24.563  1.00 40.67           C  
ATOM   1484  NZ  LYS A 183      37.109 112.339  26.026  1.00 36.56           N  
ATOM   1485  N   ARG A 184      41.267 108.698  19.922  1.00 25.60           N  
ATOM   1486  CA  ARG A 184      42.518 108.101  19.488  1.00 29.68           C  
ATOM   1487  C   ARG A 184      42.849 108.539  18.062  1.00 26.82           C  
ATOM   1488  O   ARG A 184      43.981 108.944  17.782  1.00 24.85           O  
ATOM   1489  CB  ARG A 184      42.423 106.577  19.575  1.00 29.16           C  
ATOM   1490  CG  ARG A 184      43.385 105.850  18.650  1.00 46.17           C  
ATOM   1491  CD  ARG A 184      43.210 104.349  18.688  1.00 47.04           C  
ATOM   1492  NE  ARG A 184      44.086 103.705  17.707  1.00 53.91           N  
ATOM   1493  CZ  ARG A 184      44.209 102.385  17.565  1.00 59.65           C  
ATOM   1494  NH1 ARG A 184      45.046 101.898  16.652  1.00 54.95           N  
ATOM   1495  NH2 ARG A 184      43.497 101.544  18.327  1.00 54.39           N  
ATOM   1496  N   LEU A 185      41.863 108.457  17.162  1.00 23.26           N  
ATOM   1497  CA  LEU A 185      42.072 108.814  15.764  1.00 20.72           C  
ATOM   1498  C   LEU A 185      42.359 110.326  15.581  1.00 22.73           C  
ATOM   1499  O   LEU A 185      43.076 110.715  14.658  1.00 23.60           O  
ATOM   1500  CB  LEU A 185      40.868 108.365  14.898  1.00 23.66           C  
ATOM   1501  CG  LEU A 185      40.670 106.857  14.696  1.00 21.89           C  
ATOM   1502  CD1 LEU A 185      39.433 106.547  13.841  1.00 23.54           C  
ATOM   1503  CD2 LEU A 185      41.946 106.229  14.109  1.00 33.86           C  
ATOM   1504  N   LEU A 186      41.806 111.156  16.476  1.00 24.42           N  
ATOM   1505  CA  LEU A 186      42.013 112.605  16.483  1.00 26.84           C  
ATOM   1506  C   LEU A 186      43.273 113.113  17.215  1.00 28.08           C  
ATOM   1507  O   LEU A 186      43.520 114.314  17.191  1.00 31.10           O  
ATOM   1508  CB  LEU A 186      40.766 113.334  17.038  1.00 27.57           C  
ATOM   1509  CG  LEU A 186      39.471 113.180  16.240  1.00 22.22           C  
ATOM   1510  CD1 LEU A 186      38.342 113.898  16.963  1.00 15.17           C  
ATOM   1511  CD2 LEU A 186      39.687 113.667  14.804  1.00 14.67           C  
ATOM   1512  N   LYS A 187      44.075 112.237  17.821  1.00 29.42           N  
ATOM   1513  CA  LYS A 187      45.334 112.661  18.498  1.00 35.27           C  
ATOM   1514  C   LYS A 187      46.362 113.248  17.534  1.00 36.00           C  
ATOM   1515  O   LYS A 187      46.656 112.624  16.510  1.00 32.58           O  
ATOM   1516  CB  LYS A 187      46.006 111.488  19.233  1.00 37.61           C  
ATOM   1517  CG  LYS A 187      45.489 111.227  20.650  1.00 43.82           C  
ATOM   1518  CD  LYS A 187      46.247 110.058  21.318  1.00 46.25           C  
ATOM   1519  CE  LYS A 187      47.672 110.445  21.752  1.00 54.50           C  
ATOM   1520  NZ  LYS A 187      47.668 111.220  23.030  1.00 48.57           N  
TER    1521      LYS A 187                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
