
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  139 ( 1095),  selected  139 , name 2h1a_B
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2h1a_B.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    40_B      E       1           -
LGA    -       -      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    -       -      Q       6           -
LGA    D    41_B      S       7           #
LGA    A    42_B      M       8           -
LGA    -       -      I       9           -
LGA    -       -      N      10           -
LGA    -       -      S      11           -
LGA    P    43_B      F      12          4.726
LGA    -       -      Y      13           -
LGA    N    44_B      A      14          4.689
LGA    F    45_B      F      15          2.937
LGA    V    46_B      E      16          1.749
LGA    L    47_B      V      17          1.531
LGA    E    48_B      K      18          1.891
LGA    D    49_B      D      19          1.949
LGA    T    50_B      A      20          2.122
LGA    N    51_B      K      21          4.349
LGA    G    52_B      G      22          4.372
LGA    K    53_B      R      23          4.452
LGA    R    54_B      T      24          3.004
LGA    I    55_B      V      25          2.785
LGA    E    56_B      S      26          2.529
LGA    L    57_B      L      27          2.897
LGA    S    58_B      -       -           -
LGA    D    59_B      E      28          0.389
LGA    L    60_B      K      29          4.091
LGA    -       -      Y      30           -
LGA    K    61_B      K      31          1.708
LGA    G    62_B      G      32          0.831
LGA    K    63_B      K      33          0.842
LGA    G    64_B      V      34          0.822
LGA    V    65_B      S      35          1.155
LGA    F    66_B      L      36          0.871
LGA    L    67_B      V      37          0.732
LGA    N    68_B      V      38          0.767
LGA    F    69_B      N      39          1.183
LGA    W    70_B      V      40          1.644
LGA    G    71_B      A      41          1.813
LGA    T    72_B      S      42          1.986
LGA    W    73_B      D      43          3.304
LGA    A    74_B      C      44          3.202
LGA    E    75_B      Q      45          2.238
LGA    P    76_B      L      46          2.020
LGA    C    77_B      T      47          2.983
LGA    K    78_B      D      48          1.720
LGA    K    79_B      R      49          0.447
LGA    E    80_B      N      50          1.550
LGA    F    81_B      Y      51          1.026
LGA    P    82_B      L      52          1.365
LGA    Y    83_B      G      53          1.667
LGA    M    84_B      L      54          1.316
LGA    A    85_B      K      55          1.118
LGA    N    86_B      E      56          1.992
LGA    Q    87_B      L      57          2.068
LGA    Y    88_B      H      58          1.120
LGA    K    89_B      K      59          1.592
LGA    H    90_B      E      60          2.159
LGA    F    91_B      F      61          1.233
LGA    K    92_B      G      62          1.283
LGA    S    93_B      P      63          4.012
LGA    Q    94_B      S      64          4.690
LGA    G    95_B      H      65          0.585
LGA    V    96_B      F      66          0.665
LGA    E    97_B      S      67          1.705
LGA    I    98_B      V      68          1.551
LGA    V    99_B      L      69          0.918
LGA    A   100_B      A      70          0.509
LGA    V   101_B      F      71          0.823
LGA    N   102_B      P      72          0.853
LGA    V   103_B      C      73          1.397
LGA    G   104_B      -       -           -
LGA    E   105_B      N      74          4.929
LGA    -       -      Q      75           -
LGA    -       -      F      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      S      79           -
LGA    -       -      E      80           -
LGA    -       -      P      81           -
LGA    -       -      R      82           -
LGA    S   106_B      P      83          1.831
LGA    K   107_B      S      84          1.658
LGA    I   108_B      K      85          4.515
LGA    A   109_B      E      86          4.407
LGA    V   110_B      V      87          0.931
LGA    H   111_B      E      88          2.986
LGA    N   112_B      S      89          4.723
LGA    F   113_B      F      90          2.968
LGA    M   114_B      A      91          0.673
LGA    K   115_B      R      92          3.365
LGA    -       -      K      93           -
LGA    S   116_B      N      94          1.933
LGA    Y   117_B      Y      95          2.798
LGA    G   118_B      G      96          2.578
LGA    V   119_B      V      97          1.988
LGA    N   120_B      T      98          1.572
LGA    F   121_B      F      99          0.532
LGA    P   122_B      P     100          0.544
LGA    V   123_B      I     101          0.979
LGA    V   124_B      F     102          0.878
LGA    L   125_B      H     103          1.453
LGA    D   126_B      K     104          3.616
LGA    T   127_B      I     105          3.386
LGA    D   128_B      K     106          4.392
LGA    R   129_B      I     107          4.092
LGA    -       -      L     108           -
LGA    -       -      G     109           -
LGA    -       -      S     110           -
LGA    -       -      E     111           -
LGA    Q   130_B      G     112          2.138
LGA    V   131_B      E     113          2.141
LGA    L   132_B      P     114           #
LGA    D   133_B      A     115           -
LGA    -       -      F     116           -
LGA    A   134_B      R     117          1.525
LGA    Y   135_B      F     118          4.578
LGA    -       -      L     119           -
LGA    D   136_B      V     120          3.817
LGA    -       -      D     121           -
LGA    -       -      S     122           -
LGA    -       -      S     123           -
LGA    -       -      K     124           -
LGA    -       -      K     125           -
LGA    V   137_B      E     126          2.652
LGA    S   138_B      P     127          3.112
LGA    P   139_B      R     128          1.637
LGA    L   140_B      W     129          2.569
LGA    P   141_B      N     130          3.283
LGA    -       -      F     131           -
LGA    T   142_B      W     132          1.019
LGA    T   143_B      K     133          0.891
LGA    F   144_B      Y     134          0.901
LGA    L   145_B      L     135          0.381
LGA    I   146_B      V     136          0.609
LGA    N   147_B      N     137          0.512
LGA    P   148_B      P     138          0.489
LGA    E   149_B      E     139          1.170
LGA    G   150_B      G     140          1.163
LGA    K   151_B      Q     141          0.809
LGA    V   152_B      V     142          0.682
LGA    V   153_B      V     143          0.491
LGA    K   154_B      K     144          0.215
LGA    V   155_B      F     145          1.171
LGA    V   156_B      W     146          1.013
LGA    T   157_B      R     147          1.005
LGA    G   158_B      P     148          2.561
LGA    T   159_B      E     149          1.938
LGA    M   160_B      E     150          3.494
LGA    T   161_B      P     151          2.512
LGA    E   162_B      I     152          3.185
LGA    S   163_B      E     153          2.399
LGA    M   164_B      V     154          2.904
LGA    I   165_B      I     155          3.703
LGA    H   166_B      R     156          2.453
LGA    D   167_B      P     157          2.087
LGA    Y   168_B      D     158          3.414
LGA    M   169_B      I     159          2.090
LGA    N   170_B      A     160          1.477
LGA    L   171_B      A     161          3.789
LGA    I   172_B      L     162          3.249
LGA    K   173_B      V     163          1.973
LGA    P   174_B      R     164           #
LGA    -       -      Q     165           -
LGA    G   175_B      V     166          2.359
LGA    E   176_B      I     167          3.140
LGA    T   177_B      I     168           #
LGA    S   178_B      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  139  174    5.0    129    2.44    20.16     50.971     5.088

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.322303 * X  +  -0.159938 * Y  +   0.933028 * Z  +  30.701294
  Y_new =  -0.751508 * X  +   0.642573 * Y  +  -0.149451 * Z  + 108.378349
  Z_new =  -0.575636 * X  +  -0.749346 * Y  +  -0.327297 * Z  +  41.608410 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.982600    1.158993  [ DEG:  -113.5946     66.4054 ]
  Theta =   0.613381    2.528211  [ DEG:    35.1442    144.8558 ]
  Phi   =  -1.975944    1.165648  [ DEG:  -113.2133     66.7867 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2h1a_B                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2h1a_B.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  139  174   5.0  129   2.44   20.16  50.971
REMARK  ---------------------------------------------------------- 
MOLECULE 2h1a_B
HEADER    OXIDOREDUCTASE                          16-MAY-06   2H1A              
TITLE     RESA C74A VARIANT                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOL-DISULFIDE OXIDOREDUCTASE RESA;                       
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 GENE: RESA;                                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    RESA, C74A, MUTANT, VARIANT, THIOREDOXIN                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.LEWIN,A.CROW,A.OUBRIE,N.E.LE BRUN                                   
REVDAT   2   28-NOV-06 2H1A    1       JRNL                                     
REVDAT   1   19-SEP-06 2H1A    0                                                
JRNL        AUTH   A.LEWIN,A.CROW,A.OUBRIE,N.E.LE BRUN                          
JRNL        TITL   MOLECULAR BASIS FOR SPECIFICITY OF THE                       
JRNL        TITL 2 EXTRACYTOPLASMIC THIOREDOXIN RESA.                           
JRNL        REF    J.BIOL.CHEM.                  V. 281 35467 2006              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2H1A A   37   179  UNP    P35160   RESA_BACSU      37    179             
DBREF  2H1A B   37   179  UNP    P35160   RESA_BACSU      37    179             
SEQRES   1 A  143  SER GLU GLY SER ASP ALA PRO ASN PHE VAL LEU GLU ASP          
SEQRES   2 A  143  THR ASN GLY LYS ARG ILE GLU LEU SER ASP LEU LYS GLY          
SEQRES   3 A  143  LYS GLY VAL PHE LEU ASN PHE TRP GLY THR TRP ALA GLU          
SEQRES   4 A  143  PRO CYS LYS LYS GLU PHE PRO TYR MET ALA ASN GLN TYR          
SEQRES   5 A  143  LYS HIS PHE LYS SER GLN GLY VAL GLU ILE VAL ALA VAL          
SEQRES   6 A  143  ASN VAL GLY GLU SER LYS ILE ALA VAL HIS ASN PHE MET          
SEQRES   7 A  143  LYS SER TYR GLY VAL ASN PHE PRO VAL VAL LEU ASP THR          
SEQRES   8 A  143  ASP ARG GLN VAL LEU ASP ALA TYR ASP VAL SER PRO LEU          
SEQRES   9 A  143  PRO THR THR PHE LEU ILE ASN PRO GLU GLY LYS VAL VAL          
SEQRES  10 A  143  LYS VAL VAL THR GLY THR MET THR GLU SER MET ILE HIS          
SEQRES  11 A  143  ASP TYR MET ASN LEU ILE LYS PRO GLY GLU THR SER GLY          
SEQRES   1 B  143  SER GLU GLY SER ASP ALA PRO ASN PHE VAL LEU GLU ASP          
SEQRES   2 B  143  THR ASN GLY LYS ARG ILE GLU LEU SER ASP LEU LYS GLY          
SEQRES   3 B  143  LYS GLY VAL PHE LEU ASN PHE TRP GLY THR TRP ALA GLU          
SEQRES   4 B  143  PRO CYS LYS LYS GLU PHE PRO TYR MET ALA ASN GLN TYR          
SEQRES   5 B  143  LYS HIS PHE LYS SER GLN GLY VAL GLU ILE VAL ALA VAL          
SEQRES   6 B  143  ASN VAL GLY GLU SER LYS ILE ALA VAL HIS ASN PHE MET          
SEQRES   7 B  143  LYS SER TYR GLY VAL ASN PHE PRO VAL VAL LEU ASP THR          
SEQRES   8 B  143  ASP ARG GLN VAL LEU ASP ALA TYR ASP VAL SER PRO LEU          
SEQRES   9 B  143  PRO THR THR PHE LEU ILE ASN PRO GLU GLY LYS VAL VAL          
SEQRES  10 B  143  LYS VAL VAL THR GLY THR MET THR GLU SER MET ILE HIS          
SEQRES  11 B  143  ASP TYR MET ASN LEU ILE LYS PRO GLY GLU THR SER GLY          
HET    EDO    301       4                                                       
HET    EDO    302       4                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   3  EDO    2(C2 H6 O2)                                                  
FORMUL   5  HOH   *135(H2 O)                                                    
CRYST1   46.874   59.596  109.771  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1097  N   SER B  40      42.319  99.906   5.276  1.00 27.89           N  
ATOM   1098  CA  SER B  40      41.457  99.761   4.043  1.00 28.23           C  
ATOM   1099  C   SER B  40      40.580 100.996   3.678  1.00 27.54           C  
ATOM   1100  O   SER B  40      39.814 101.513   4.503  1.00 26.64           O  
ATOM   1101  CB  SER B  40      40.606  98.471   4.094  1.00 28.84           C  
ATOM   1102  OG  SER B  40      40.028  98.169   2.822  1.00 28.88           O  
ATOM   1103  N   ASP B  41      40.730 101.456   2.433  1.00 26.87           N  
ATOM   1104  CA  ASP B  41      39.987 102.613   1.929  1.00 27.14           C  
ATOM   1105  C   ASP B  41      38.480 102.467   2.036  1.00 25.24           C  
ATOM   1106  O   ASP B  41      37.953 101.382   1.801  1.00 25.80           O  
ATOM   1107  CB  ASP B  41      40.359 102.924   0.498  1.00 27.98           C  
ATOM   1108  CG  ASP B  41      41.818 103.130   0.343  1.00 31.26           C  
ATOM   1109  OD1 ASP B  41      42.581 102.167   0.593  1.00 37.82           O  
ATOM   1110  OD2 ASP B  41      42.207 104.255  -0.007  1.00 36.01           O  
ATOM   1111  N   ALA B  42      37.811 103.552   2.423  1.00 22.25           N  
ATOM   1112  CA  ALA B  42      36.384 103.501   2.643  1.00 19.27           C  
ATOM   1113  C   ALA B  42      35.743 103.728   1.270  1.00 17.42           C  
ATOM   1114  O   ALA B  42      36.066 104.725   0.613  1.00 17.02           O  
ATOM   1115  CB  ALA B  42      35.971 104.577   3.606  1.00 18.90           C  
ATOM   1116  N   PRO B  43      34.859 102.806   0.824  1.00 15.20           N  
ATOM   1117  CA  PRO B  43      34.176 103.034  -0.437  1.00 14.26           C  
ATOM   1118  C   PRO B  43      33.553 104.446  -0.529  1.00 13.38           C  
ATOM   1119  O   PRO B  43      32.832 104.858   0.369  1.00 13.79           O  
ATOM   1120  CB  PRO B  43      33.077 101.988  -0.417  1.00 13.90           C  
ATOM   1121  CG  PRO B  43      33.669 100.830   0.362  1.00 13.43           C  
ATOM   1122  CD  PRO B  43      34.469 101.524   1.443  1.00 14.69           C  
ATOM   1123  N   ASN B  44      33.836 105.158  -1.613  1.00 11.24           N  
ATOM   1124  CA  ASN B  44      33.329 106.486  -1.810  1.00 10.63           C  
ATOM   1125  C   ASN B  44      31.905 106.470  -2.331  1.00  9.94           C  
ATOM   1126  O   ASN B  44      31.503 105.512  -2.965  1.00  9.92           O  
ATOM   1127  CB  ASN B  44      34.240 107.210  -2.819  1.00  9.28           C  
ATOM   1128  CG  ASN B  44      34.116 108.698  -2.752  1.00  9.55           C  
ATOM   1129  OD1 ASN B  44      33.516 109.254  -1.805  1.00  9.32           O  
ATOM   1130  ND2 ASN B  44      34.688 109.383  -3.754  1.00  6.05           N  
ATOM   1131  N   PHE B  45      31.156 107.544  -2.095  1.00  9.00           N  
ATOM   1132  CA  PHE B  45      29.758 107.654  -2.544  1.00  9.12           C  
ATOM   1133  C   PHE B  45      29.291 109.097  -2.463  1.00  9.13           C  
ATOM   1134  O   PHE B  45      29.862 109.905  -1.754  1.00  8.13           O  
ATOM   1135  CB  PHE B  45      28.811 106.729  -1.744  1.00  8.61           C  
ATOM   1136  CG  PHE B  45      28.744 107.059  -0.293  1.00 10.78           C  
ATOM   1137  CD1 PHE B  45      27.946 108.106   0.168  1.00 10.05           C  
ATOM   1138  CD2 PHE B  45      29.521 106.356   0.628  1.00 10.44           C  
ATOM   1139  CE1 PHE B  45      27.907 108.414   1.534  1.00 12.44           C  
ATOM   1140  CE2 PHE B  45      29.457 106.647   2.000  1.00  9.20           C  
ATOM   1141  CZ  PHE B  45      28.656 107.677   2.449  1.00  9.01           C  
ATOM   1142  N   VAL B  46      28.260 109.399  -3.235  1.00 10.21           N  
ATOM   1143  CA  VAL B  46      27.589 110.681  -3.223  1.00 11.27           C  
ATOM   1144  C   VAL B  46      26.152 110.320  -2.935  1.00 12.70           C  
ATOM   1145  O   VAL B  46      25.565 109.476  -3.630  1.00 13.35           O  
ATOM   1146  CB  VAL B  46      27.603 111.435  -4.615  1.00 11.08           C  
ATOM   1147  CG1 VAL B  46      26.701 112.669  -4.559  1.00  9.55           C  
ATOM   1148  CG2 VAL B  46      29.035 111.868  -5.051  1.00 10.56           C  
ATOM   1149  N   LEU B  47      25.584 110.946  -1.917  1.00 13.84           N  
ATOM   1150  CA  LEU B  47      24.171 110.829  -1.609  1.00 14.79           C  
ATOM   1151  C   LEU B  47      23.643 112.227  -1.300  1.00 15.70           C  
ATOM   1152  O   LEU B  47      24.408 113.138  -1.042  1.00 15.47           O  
ATOM   1153  CB  LEU B  47      23.976 109.894  -0.388  1.00 13.21           C  
ATOM   1154  CG  LEU B  47      24.168 108.359  -0.510  1.00 12.01           C  
ATOM   1155  CD1 LEU B  47      23.879 107.636   0.840  1.00  7.84           C  
ATOM   1156  CD2 LEU B  47      23.328 107.709  -1.706  1.00  6.93           C  
ATOM   1157  N   GLU B  48      22.332 112.395  -1.302  1.00 16.98           N  
ATOM   1158  CA  GLU B  48      21.760 113.642  -0.851  1.00 18.71           C  
ATOM   1159  C   GLU B  48      21.447 113.637   0.630  1.00 18.51           C  
ATOM   1160  O   GLU B  48      20.873 112.666   1.141  1.00 18.10           O  
ATOM   1161  CB  GLU B  48      20.459 113.928  -1.581  1.00 19.63           C  
ATOM   1162  CG  GLU B  48      20.605 114.807  -2.800  1.00 24.92           C  
ATOM   1163  CD  GLU B  48      19.372 114.701  -3.713  1.00 32.88           C  
ATOM   1164  OE1 GLU B  48      18.238 114.593  -3.167  1.00 33.84           O  
ATOM   1165  OE2 GLU B  48      19.546 114.712  -4.960  1.00 35.36           O  
ATOM   1166  N   ASP B  49      21.798 114.738   1.306  1.00 18.25           N  
ATOM   1167  CA  ASP B  49      21.315 114.944   2.644  1.00 19.17           C  
ATOM   1168  C   ASP B  49      19.798 115.247   2.667  1.00 19.30           C  
ATOM   1169  O   ASP B  49      19.180 115.438   1.626  1.00 19.35           O  
ATOM   1170  CB  ASP B  49      22.201 115.934   3.411  1.00 18.64           C  
ATOM   1171  CG  ASP B  49      21.913 117.394   3.103  1.00 20.98           C  
ATOM   1172  OD1 ASP B  49      20.974 117.717   2.369  1.00 21.42           O  
ATOM   1173  OD2 ASP B  49      22.648 118.261   3.643  1.00 27.48           O  
ATOM   1174  N   THR B  50      19.203 115.246   3.849  1.00 19.90           N  
ATOM   1175  CA  THR B  50      17.755 115.455   3.995  1.00 20.32           C  
ATOM   1176  C   THR B  50      17.295 116.884   3.616  1.00 21.62           C  
ATOM   1177  O   THR B  50      16.096 117.180   3.623  1.00 21.78           O  
ATOM   1178  CB  THR B  50      17.264 115.104   5.423  1.00 19.90           C  
ATOM   1179  OG1 THR B  50      18.085 115.768   6.410  1.00 18.31           O  
ATOM   1180  CG2 THR B  50      17.281 113.594   5.623  1.00 17.72           C  
ATOM   1181  N   ASN B  51      18.251 117.758   3.297  1.00 22.11           N  
ATOM   1182  CA  ASN B  51      17.955 119.080   2.771  1.00 22.56           C  
ATOM   1183  C   ASN B  51      18.203 119.181   1.267  1.00 23.09           C  
ATOM   1184  O   ASN B  51      18.114 120.267   0.719  1.00 23.76           O  
ATOM   1185  CB  ASN B  51      18.845 120.109   3.454  1.00 23.15           C  
ATOM   1186  CG  ASN B  51      18.526 120.289   4.912  1.00 24.61           C  
ATOM   1187  OD1 ASN B  51      17.406 120.029   5.345  1.00 28.52           O  
ATOM   1188  ND2 ASN B  51      19.492 120.776   5.672  1.00 23.83           N  
ATOM   1189  N   GLY B  52      18.562 118.075   0.609  1.00 23.38           N  
ATOM   1190  CA  GLY B  52      18.746 118.059  -0.847  1.00 23.59           C  
ATOM   1191  C   GLY B  52      20.155 118.318  -1.314  1.00 24.00           C  
ATOM   1192  O   GLY B  52      20.425 118.323  -2.523  1.00 24.53           O  
ATOM   1193  N   LYS B  53      21.053 118.505  -0.349  1.00 23.89           N  
ATOM   1194  CA  LYS B  53      22.451 118.828  -0.601  1.00 23.64           C  
ATOM   1195  C   LYS B  53      23.281 117.552  -0.799  1.00 22.96           C  
ATOM   1196  O   LYS B  53      23.211 116.590  -0.014  1.00 22.38           O  
ATOM   1197  CB  LYS B  53      22.988 119.687   0.534  1.00 24.06           C  
ATOM   1198  CG  LYS B  53      24.359 120.311   0.318  1.00 26.21           C  
ATOM   1199  CD  LYS B  53      24.724 121.220   1.510  1.00 26.43           C  
ATOM   1200  CE  LYS B  53      25.376 120.456   2.664  1.00 30.69           C  
ATOM   1201  NZ  LYS B  53      26.826 120.341   2.359  1.00 33.41           N  
ATOM   1202  N   ARG B  54      24.048 117.581  -1.882  1.00 22.41           N  
ATOM   1203  CA  ARG B  54      24.899 116.498  -2.323  0.50 22.15           C  
ATOM   1205  C   ARG B  54      26.095 116.377  -1.376  1.00 21.72           C  
ATOM   1206  O   ARG B  54      26.757 117.377  -1.075  1.00 21.91           O  
ATOM   1207  CB  ARG B  54      25.338 116.813  -3.758  0.50 22.41           C  
ATOM   1209  CG  ARG B  54      26.529 116.042  -4.314  0.50 22.96           C  
ATOM   1211  CD  ARG B  54      27.136 116.795  -5.514  0.50 22.55           C  
ATOM   1213  NE  ARG B  54      27.813 115.895  -6.440  0.50 21.62           N  
ATOM   1215  CZ  ARG B  54      29.046 115.425  -6.274  0.50 19.97           C  
ATOM   1217  NH1 ARG B  54      29.766 115.771  -5.207  0.50 17.41           N  
ATOM   1219  NH2 ARG B  54      29.550 114.600  -7.185  0.50 18.49           N  
ATOM   1221  N   ILE B  55      26.367 115.175  -0.900  1.00 20.56           N  
ATOM   1222  CA  ILE B  55      27.481 114.978   0.006  1.00 19.13           C  
ATOM   1223  C   ILE B  55      28.310 113.845  -0.529  1.00 17.72           C  
ATOM   1224  O   ILE B  55      27.804 112.757  -0.714  1.00 17.53           O  
ATOM   1225  CB  ILE B  55      26.996 114.673   1.440  1.00 19.53           C  
ATOM   1226  CG1 ILE B  55      26.208 115.880   2.008  1.00 19.05           C  
ATOM   1227  CG2 ILE B  55      28.187 114.255   2.335  1.00 19.25           C  
ATOM   1228  CD1 ILE B  55      25.858 115.760   3.504  1.00 18.13           C  
ATOM   1229  N   GLU B  56      29.586 114.121  -0.772  1.00 16.18           N  
ATOM   1230  CA  GLU B  56      30.547 113.112  -1.215  1.00 14.95           C  
ATOM   1231  C   GLU B  56      31.544 112.766  -0.099  1.00 13.39           C  
ATOM   1232  O   GLU B  56      32.183 113.629   0.462  1.00 14.18           O  
ATOM   1233  CB  GLU B  56      31.221 113.599  -2.493  1.00 13.28           C  
ATOM   1234  CG  GLU B  56      32.249 112.661  -3.101  1.00 16.42           C  
ATOM   1235  CD  GLU B  56      32.542 112.921  -4.615  1.00 18.31           C  
ATOM   1236  OE1 GLU B  56      32.472 114.097  -5.072  1.00 25.68           O  
ATOM   1237  OE2 GLU B  56      32.799 111.934  -5.368  1.00 23.02           O  
ATOM   1238  N   LEU B  57      31.672 111.497   0.204  1.00 12.23           N  
ATOM   1239  CA  LEU B  57      32.483 111.031   1.306  1.00 10.93           C  
ATOM   1240  C   LEU B  57      33.936 111.528   1.227  1.00 11.58           C  
ATOM   1241  O   LEU B  57      34.500 111.966   2.239  1.00 12.53           O  
ATOM   1242  CB  LEU B  57      32.363 109.493   1.453  1.00  9.32           C  
ATOM   1243  CG  LEU B  57      33.142 108.855   2.624  1.00  9.38           C  
ATOM   1244  CD1 LEU B  57      32.719 109.399   4.001  1.00  4.30           C  
ATOM   1245  CD2 LEU B  57      33.142 107.326   2.593  1.00  7.08           C  
ATOM   1246  N   SER B  58      34.520 111.475   0.031  1.00 11.37           N  
ATOM   1247  CA  SER B  58      35.896 111.912  -0.231  1.00 10.93           C  
ATOM   1248  C   SER B  58      36.098 113.392   0.068  1.00 10.56           C  
ATOM   1249  O   SER B  58      37.168 113.789   0.434  1.00 11.59           O  
ATOM   1250  CB  SER B  58      36.270 111.641  -1.684  1.00 10.47           C  
ATOM   1251  OG  SER B  58      35.298 112.218  -2.563  1.00 12.45           O  
ATOM   1252  N   ASP B  59      35.078 114.218  -0.115  1.00 10.39           N  
ATOM   1253  CA  ASP B  59      35.104 115.622   0.319  1.00 10.59           C  
ATOM   1254  C   ASP B  59      35.316 115.847   1.826  1.00  9.92           C  
ATOM   1255  O   ASP B  59      35.518 116.969   2.226  1.00  9.99           O  
ATOM   1256  CB  ASP B  59      33.765 116.328   0.012  1.00 10.88           C  
ATOM   1257  CG  ASP B  59      33.562 116.691  -1.478  1.00 16.13           C  
ATOM   1258  OD1 ASP B  59      34.522 116.555  -2.327  1.00 18.51           O  
ATOM   1259  OD2 ASP B  59      32.402 117.142  -1.781  1.00 15.35           O  
ATOM   1260  N   LEU B  60      35.188 114.824   2.659  1.00  9.91           N  
ATOM   1261  CA  LEU B  60      35.376 114.992   4.096  1.00  9.91           C  
ATOM   1262  C   LEU B  60      36.762 114.571   4.522  1.00 10.53           C  
ATOM   1263  O   LEU B  60      36.998 114.406   5.726  1.00 10.44           O  
ATOM   1264  CB  LEU B  60      34.308 114.254   4.946  1.00  9.45           C  
ATOM   1265  CG  LEU B  60      32.814 114.531   4.692  1.00  8.46           C  
ATOM   1266  CD1 LEU B  60      31.927 113.512   5.332  1.00  6.80           C  
ATOM   1267  CD2 LEU B  60      32.422 115.899   5.197  1.00  9.28           C  
ATOM   1268  N   LYS B  61      37.687 114.401   3.566  1.00 10.64           N  
ATOM   1269  CA  LYS B  61      39.100 114.168   3.949  1.00 11.68           C  
ATOM   1270  C   LYS B  61      39.608 115.300   4.864  1.00 10.41           C  
ATOM   1271  O   LYS B  61      39.186 116.421   4.725  1.00 10.11           O  
ATOM   1272  CB  LYS B  61      39.994 113.950   2.732  1.00 12.77           C  
ATOM   1273  CG  LYS B  61      40.113 112.424   2.451  1.00 15.60           C  
ATOM   1274  CD  LYS B  61      40.934 112.114   1.219  1.00 20.18           C  
ATOM   1275  CE  LYS B  61      40.800 110.642   0.799  1.00 20.46           C  
ATOM   1276  NZ  LYS B  61      40.027 110.500  -0.472  1.00 23.45           N  
ATOM   1277  N   GLY B  62      40.469 114.985   5.824  1.00 10.33           N  
ATOM   1278  CA  GLY B  62      40.909 115.975   6.816  1.00 10.13           C  
ATOM   1279  C   GLY B  62      40.099 115.850   8.105  1.00  9.84           C  
ATOM   1280  O   GLY B  62      40.558 116.163   9.181  1.00 11.00           O  
ATOM   1281  N   LYS B  63      38.880 115.367   7.993  1.00  9.16           N  
ATOM   1282  CA  LYS B  63      38.008 115.148   9.127  1.00  7.95           C  
ATOM   1283  C   LYS B  63      37.857 113.670   9.406  1.00  7.31           C  
ATOM   1284  O   LYS B  63      37.942 112.850   8.485  1.00  7.36           O  
ATOM   1285  CB  LYS B  63      36.631 115.726   8.819  1.00  7.77           C  
ATOM   1286  CG  LYS B  63      36.605 117.244   8.764  1.00  8.46           C  
ATOM   1287  CD  LYS B  63      35.204 117.692   9.057  1.00 11.05           C  
ATOM   1288  CE  LYS B  63      35.072 119.195   9.046  1.00 15.06           C  
ATOM   1289  NZ  LYS B  63      33.641 119.544   9.240  1.00 15.20           N  
ATOM   1290  N   GLY B  64      37.629 113.326  10.671  1.00  6.30           N  
ATOM   1291  CA  GLY B  64      37.251 111.953  11.043  1.00  5.32           C  
ATOM   1292  C   GLY B  64      35.782 111.790  10.681  1.00  4.98           C  
ATOM   1293  O   GLY B  64      35.000 112.768  10.787  1.00  4.06           O  
ATOM   1294  N   VAL B  65      35.388 110.610  10.195  1.00  4.12           N  
ATOM   1295  CA  VAL B  65      33.948 110.434   9.785  1.00  2.88           C  
ATOM   1296  C   VAL B  65      33.337 109.264  10.544  1.00  2.97           C  
ATOM   1297  O   VAL B  65      33.881 108.131  10.521  1.00  2.57           O  
ATOM   1298  CB  VAL B  65      33.733 110.291   8.277  1.00  2.49           C  
ATOM   1299  CG1 VAL B  65      32.244 110.026   7.972  1.00  2.00           C  
ATOM   1300  CG2 VAL B  65      34.219 111.529   7.530  1.00  2.00           C  
ATOM   1301  N   PHE B  66      32.258 109.572  11.277  1.00  2.22           N  
ATOM   1302  CA  PHE B  66      31.511 108.578  12.034  1.00  2.57           C  
ATOM   1303  C   PHE B  66      30.378 108.183  11.066  1.00  3.68           C  
ATOM   1304  O   PHE B  66      29.360 108.892  10.921  1.00  3.34           O  
ATOM   1305  CB  PHE B  66      30.995 109.226  13.311  1.00  2.19           C  
ATOM   1306  CG  PHE B  66      30.341 108.260  14.304  1.00  2.45           C  
ATOM   1307  CD1 PHE B  66      29.017 107.899  14.166  1.00  2.00           C  
ATOM   1308  CD2 PHE B  66      31.050 107.795  15.420  1.00  2.00           C  
ATOM   1309  CE1 PHE B  66      28.439 107.039  15.071  1.00  2.70           C  
ATOM   1310  CE2 PHE B  66      30.463 106.968  16.345  1.00  2.00           C  
ATOM   1311  CZ  PHE B  66      29.157 106.584  16.170  1.00  2.11           C  
ATOM   1312  N   LEU B  67      30.591 107.086  10.336  1.00  3.78           N  
ATOM   1313  CA  LEU B  67      29.655 106.704   9.253  1.00  3.85           C  
ATOM   1314  C   LEU B  67      28.688 105.589   9.688  1.00  3.83           C  
ATOM   1315  O   LEU B  67      29.050 104.439   9.855  1.00  3.62           O  
ATOM   1316  CB  LEU B  67      30.409 106.356   7.958  1.00  4.16           C  
ATOM   1317  CG  LEU B  67      29.601 105.800   6.804  1.00  5.67           C  
ATOM   1318  CD1 LEU B  67      28.908 106.980   6.013  1.00  5.16           C  
ATOM   1319  CD2 LEU B  67      30.455 104.913   5.937  1.00  3.82           C  
ATOM   1320  N   ASN B  68      27.456 105.995   9.928  1.00  4.74           N  
ATOM   1321  CA  ASN B  68      26.465 105.191  10.620  1.00  5.93           C  
ATOM   1322  C   ASN B  68      25.315 104.803   9.672  1.00  5.99           C  
ATOM   1323  O   ASN B  68      24.612 105.683   9.124  1.00  6.33           O  
ATOM   1324  CB  ASN B  68      25.978 106.026  11.802  1.00  5.57           C  
ATOM   1325  CG  ASN B  68      24.918 105.355  12.598  1.00  8.63           C  
ATOM   1326  OD1 ASN B  68      23.770 105.823  12.650  1.00 13.19           O  
ATOM   1327  ND2 ASN B  68      25.276 104.263  13.248  1.00  8.74           N  
ATOM   1328  N   PHE B  69      25.156 103.490   9.453  1.00  5.28           N  
ATOM   1329  CA  PHE B  69      24.019 102.953   8.715  1.00  4.87           C  
ATOM   1330  C   PHE B  69      22.859 102.625   9.677  1.00  6.02           C  
ATOM   1331  O   PHE B  69      23.036 101.893  10.636  1.00  6.30           O  
ATOM   1332  CB  PHE B  69      24.440 101.726   7.909  1.00  4.43           C  
ATOM   1333  CG  PHE B  69      25.339 102.034   6.723  1.00  2.68           C  
ATOM   1334  CD1 PHE B  69      26.711 102.131   6.878  1.00  2.00           C  
ATOM   1335  CD2 PHE B  69      24.806 102.201   5.456  1.00  2.00           C  
ATOM   1336  CE1 PHE B  69      27.548 102.429   5.777  1.00  2.00           C  
ATOM   1337  CE2 PHE B  69      25.625 102.460   4.364  1.00  3.57           C  
ATOM   1338  CZ  PHE B  69      27.010 102.584   4.526  1.00  3.16           C  
ATOM   1339  N   TRP B  70      21.678 103.182   9.415  1.00  6.08           N  
ATOM   1340  CA  TRP B  70      20.556 103.092  10.346  1.00  6.13           C  
ATOM   1341  C   TRP B  70      19.207 102.974   9.617  1.00  7.15           C  
ATOM   1342  O   TRP B  70      19.111 103.303   8.416  1.00  7.28           O  
ATOM   1343  CB  TRP B  70      20.544 104.320  11.248  1.00  4.77           C  
ATOM   1344  CG  TRP B  70      20.205 105.585  10.564  1.00  3.17           C  
ATOM   1345  CD1 TRP B  70      21.016 106.304   9.740  1.00  2.67           C  
ATOM   1346  CD2 TRP B  70      18.963 106.303  10.624  1.00  2.17           C  
ATOM   1347  NE1 TRP B  70      20.375 107.415   9.300  1.00  2.00           N  
ATOM   1348  CE2 TRP B  70      19.105 107.436   9.814  1.00  2.00           C  
ATOM   1349  CE3 TRP B  70      17.747 106.107  11.304  1.00  4.05           C  
ATOM   1350  CZ2 TRP B  70      18.081 108.390   9.663  1.00  5.73           C  
ATOM   1351  CZ3 TRP B  70      16.712 107.078  11.153  1.00  2.47           C  
ATOM   1352  CH2 TRP B  70      16.885 108.171  10.340  1.00  5.59           C  
ATOM   1353  N   GLY B  71      18.190 102.488  10.348  1.00  7.78           N  
ATOM   1354  CA  GLY B  71      16.801 102.536   9.933  1.00  7.97           C  
ATOM   1355  C   GLY B  71      15.953 102.958  11.119  1.00  8.73           C  
ATOM   1356  O   GLY B  71      16.366 102.816  12.259  1.00  8.58           O  
ATOM   1357  N   THR B  72      14.757 103.485  10.857  1.00  9.55           N  
ATOM   1358  CA  THR B  72      13.823 103.834  11.963  1.00 10.64           C  
ATOM   1359  C   THR B  72      13.324 102.572  12.714  1.00 11.31           C  
ATOM   1360  O   THR B  72      12.799 102.624  13.801  1.00 12.09           O  
ATOM   1361  CB  THR B  72      12.611 104.552  11.482  1.00 10.28           C  
ATOM   1362  OG1 THR B  72      11.816 103.587  10.752  1.00 13.42           O  
ATOM   1363  CG2 THR B  72      13.011 105.768  10.598  1.00  5.66           C  
ATOM   1364  N   TRP B  73      13.530 101.411  12.131  1.00 12.34           N  
ATOM   1365  CA  TRP B  73      13.102 100.176  12.764  1.00 12.73           C  
ATOM   1366  C   TRP B  73      14.089  99.584  13.752  1.00 13.96           C  
ATOM   1367  O   TRP B  73      13.817  98.505  14.356  1.00 15.75           O  
ATOM   1368  CB  TRP B  73      12.923  99.106  11.700  1.00 12.04           C  
ATOM   1369  CG  TRP B  73      14.153  98.657  11.043  1.00 12.63           C  
ATOM   1370  CD1 TRP B  73      15.067  97.756  11.523  1.00 14.21           C  
ATOM   1371  CD2 TRP B  73      14.632  99.059   9.734  1.00 12.19           C  
ATOM   1372  NE1 TRP B  73      16.102  97.588  10.594  1.00 13.95           N  
ATOM   1373  CE2 TRP B  73      15.838  98.360   9.489  1.00 11.98           C  
ATOM   1374  CE3 TRP B  73      14.147  99.937   8.748  1.00 12.63           C  
ATOM   1375  CZ2 TRP B  73      16.572  98.507   8.283  1.00 14.51           C  
ATOM   1376  CZ3 TRP B  73      14.868 100.079   7.540  1.00 12.78           C  
ATOM   1377  CH2 TRP B  73      16.065  99.360   7.318  1.00 13.11           C  
ATOM   1378  N   ALA B  74      15.271 100.179  13.871  1.00 13.78           N  
ATOM   1379  CA  ALA B  74      16.271  99.600  14.728  1.00 13.07           C  
ATOM   1380  C   ALA B  74      16.117 100.285  16.066  1.00 13.32           C  
ATOM   1381  O   ALA B  74      16.353 101.494  16.181  1.00 12.63           O  
ATOM   1382  CB  ALA B  74      17.625  99.824  14.165  1.00 13.18           C  
ATOM   1383  N   GLU B  75      15.689  99.529  17.079  1.00 13.40           N  
ATOM   1384  CA  GLU B  75      15.470 100.153  18.377  1.00 12.45           C  
ATOM   1385  C   GLU B  75      16.763 100.758  18.961  1.00 11.62           C  
ATOM   1386  O   GLU B  75      16.717 101.789  19.583  1.00 11.78           O  
ATOM   1387  CB  GLU B  75      14.687  99.249  19.305  1.00 11.67           C  
ATOM   1388  CG  GLU B  75      13.329  98.858  18.811  1.00 11.24           C  
ATOM   1389  CD  GLU B  75      12.250  99.905  18.974  1.00 13.31           C  
ATOM   1390  OE1 GLU B  75      12.234 100.640  19.977  1.00 15.11           O  
ATOM   1391  OE2 GLU B  75      11.371  99.965  18.100  1.00 15.36           O  
ATOM   1392  N   PRO B  76      17.919 100.143  18.739  1.00 11.65           N  
ATOM   1393  CA  PRO B  76      19.134 100.831  19.226  1.00 11.56           C  
ATOM   1394  C   PRO B  76      19.278 102.312  18.710  1.00 11.69           C  
ATOM   1395  O   PRO B  76      19.690 103.189  19.475  1.00 12.18           O  
ATOM   1396  CB  PRO B  76      20.248  99.924  18.695  1.00 11.36           C  
ATOM   1397  CG  PRO B  76      19.594  98.576  18.760  1.00 12.53           C  
ATOM   1398  CD  PRO B  76      18.239  98.838  18.149  1.00 11.62           C  
ATOM   1399  N   CYS B  77      18.920 102.588  17.456  1.00 11.43           N  
ATOM   1400  CA  CYS B  77      19.048 103.925  16.906  1.00 11.88           C  
ATOM   1401  C   CYS B  77      18.250 104.880  17.710  1.00 12.53           C  
ATOM   1402  O   CYS B  77      18.567 106.070  17.767  1.00 12.22           O  
ATOM   1403  CB  CYS B  77      18.528 104.006  15.478  1.00 12.06           C  
ATOM   1404  SG  CYS B  77      19.573 103.081  14.454  1.00 14.29           S  
ATOM   1405  N   LYS B  78      17.171 104.376  18.299  1.00 13.27           N  
ATOM   1406  CA  LYS B  78      16.356 105.198  19.177  1.00 14.32           C  
ATOM   1407  C   LYS B  78      17.110 105.666  20.421  1.00 14.76           C  
ATOM   1408  O   LYS B  78      16.841 106.778  20.934  1.00 15.07           O  
ATOM   1409  CB  LYS B  78      15.091 104.480  19.625  1.00 14.52           C  
ATOM   1410  CG  LYS B  78      13.901 104.752  18.707  1.00 15.82           C  
ATOM   1411  CD  LYS B  78      12.713 103.881  19.080  1.00 15.99           C  
ATOM   1412  CE  LYS B  78      11.771 103.790  17.914  1.00 17.63           C  
ATOM   1413  NZ  LYS B  78      10.602 103.023  18.394  1.00 21.47           N  
ATOM   1414  N   LYS B  79      18.016 104.832  20.939  1.00 14.51           N  
ATOM   1415  CA  LYS B  79      18.843 105.182  22.112  0.50 15.06           C  
ATOM   1417  C   LYS B  79      20.055 105.973  21.653  1.00 14.20           C  
ATOM   1418  O   LYS B  79      20.433 106.986  22.234  1.00 14.30           O  
ATOM   1419  CB  LYS B  79      19.360 103.916  22.821  0.50 14.92           C  
ATOM   1421  CG  LYS B  79      18.749 103.589  24.189  0.50 17.18           C  
ATOM   1423  CD  LYS B  79      19.723 102.715  25.011  0.50 17.40           C  
ATOM   1425  CE  LYS B  79      19.546 102.915  26.517  0.50 20.31           C  
ATOM   1427  NZ  LYS B  79      20.379 101.958  27.329  0.50 21.50           N  
ATOM   1429  N   GLU B  80      20.677 105.468  20.607  1.00 13.02           N  
ATOM   1430  CA  GLU B  80      21.961 105.962  20.121  1.00 12.74           C  
ATOM   1431  C   GLU B  80      21.939 107.265  19.378  1.00 11.25           C  
ATOM   1432  O   GLU B  80      22.894 107.987  19.439  1.00 11.69           O  
ATOM   1433  CB  GLU B  80      22.627 104.893  19.252  1.00 12.19           C  
ATOM   1434  CG  GLU B  80      22.941 103.656  20.120  1.00 15.32           C  
ATOM   1435  CD  GLU B  80      23.383 102.410  19.339  1.00 16.13           C  
ATOM   1436  OE1 GLU B  80      23.990 102.504  18.222  1.00 18.69           O  
ATOM   1437  OE2 GLU B  80      23.128 101.324  19.908  1.00 20.73           O  
ATOM   1438  N   PHE B  81      20.860 107.583  18.667  1.00 10.00           N  
ATOM   1439  CA  PHE B  81      20.778 108.883  17.988  1.00  7.72           C  
ATOM   1440  C   PHE B  81      20.898 110.052  18.944  1.00  7.53           C  
ATOM   1441  O   PHE B  81      21.647 110.959  18.666  1.00  8.22           O  
ATOM   1442  CB  PHE B  81      19.556 108.982  17.062  1.00  5.92           C  
ATOM   1443  CG  PHE B  81      19.880 108.657  15.623  1.00  7.65           C  
ATOM   1444  CD1 PHE B  81      20.842 107.698  15.302  1.00  6.12           C  
ATOM   1445  CD2 PHE B  81      19.283 109.356  14.575  1.00 10.43           C  
ATOM   1446  CE1 PHE B  81      21.166 107.413  13.997  1.00  6.53           C  
ATOM   1447  CE2 PHE B  81      19.628 109.090  13.233  1.00  9.51           C  
ATOM   1448  CZ  PHE B  81      20.567 108.112  12.949  1.00  6.68           C  
ATOM   1449  N   PRO B  82      20.139 110.060  20.073  1.00  7.97           N  
ATOM   1450  CA  PRO B  82      20.404 111.065  21.127  1.00  7.06           C  
ATOM   1451  C   PRO B  82      21.871 111.154  21.651  1.00  7.42           C  
ATOM   1452  O   PRO B  82      22.359 112.256  21.927  1.00  7.66           O  
ATOM   1453  CB  PRO B  82      19.405 110.657  22.232  1.00  6.20           C  
ATOM   1454  CG  PRO B  82      18.253 110.093  21.482  1.00  6.85           C  
ATOM   1455  CD  PRO B  82      18.935 109.243  20.404  1.00  7.01           C  
ATOM   1456  N   TYR B  83      22.533 110.016  21.842  1.00  7.69           N  
ATOM   1457  CA  TYR B  83      23.938 109.960  22.279  1.00  7.69           C  
ATOM   1458  C   TYR B  83      24.918 110.588  21.269  1.00  7.82           C  
ATOM   1459  O   TYR B  83      25.804 111.356  21.635  1.00  6.67           O  
ATOM   1460  CB  TYR B  83      24.382 108.504  22.481  1.00  9.93           C  
ATOM   1461  CG  TYR B  83      23.677 107.717  23.626  1.00 11.15           C  
ATOM   1462  CD1 TYR B  83      22.996 108.387  24.628  1.00  8.09           C  
ATOM   1463  CD2 TYR B  83      23.728 106.323  23.669  1.00  9.26           C  
ATOM   1464  CE1 TYR B  83      22.381 107.707  25.632  1.00 11.36           C  
ATOM   1465  CE2 TYR B  83      23.116 105.624  24.680  1.00 12.46           C  
ATOM   1466  CZ  TYR B  83      22.453 106.334  25.673  1.00 12.98           C  
ATOM   1467  OH  TYR B  83      21.820 105.692  26.726  1.00 15.29           O  
ATOM   1468  N   MET B  84      24.751 110.220  20.003  1.00  6.98           N  
ATOM   1469  CA  MET B  84      25.476 110.794  18.891  1.00  7.29           C  
ATOM   1470  C   MET B  84      25.245 112.279  18.754  1.00  6.72           C  
ATOM   1471  O   MET B  84      26.182 113.024  18.522  1.00  7.05           O  
ATOM   1472  CB  MET B  84      25.076 110.092  17.571  1.00  7.80           C  
ATOM   1473  CG  MET B  84      25.524 108.650  17.440  1.00  5.85           C  
ATOM   1474  SD  MET B  84      24.630 107.879  16.047  1.00  8.52           S  
ATOM   1475  CE  MET B  84      25.037 108.868  14.627  1.00  2.00           C  
ATOM   1476  N   ALA B  85      24.000 112.714  18.907  1.00  6.83           N  
ATOM   1477  CA  ALA B  85      23.680 114.144  18.858  1.00  6.69           C  
ATOM   1478  C   ALA B  85      24.399 114.891  20.000  1.00  6.95           C  
ATOM   1479  O   ALA B  85      24.938 115.990  19.809  1.00  7.61           O  
ATOM   1480  CB  ALA B  85      22.150 114.368  18.911  1.00  4.63           C  
ATOM   1481  N   ASN B  86      24.382 114.292  21.183  1.00  6.71           N  
ATOM   1482  CA  ASN B  86      24.989 114.864  22.388  1.00  7.28           C  
ATOM   1483  C   ASN B  86      26.538 114.900  22.298  1.00  7.04           C  
ATOM   1484  O   ASN B  86      27.144 115.858  22.694  1.00  7.77           O  
ATOM   1485  CB  ASN B  86      24.508 114.019  23.598  1.00  7.31           C  
ATOM   1486  CG  ASN B  86      24.690 114.704  24.947  1.00  8.74           C  
ATOM   1487  OD1 ASN B  86      24.419 115.900  25.113  1.00 12.95           O  
ATOM   1488  ND2 ASN B  86      25.114 113.936  25.928  1.00  6.70           N  
ATOM   1489  N   GLN B  87      27.169 113.836  21.795  1.00  6.91           N  
ATOM   1490  CA  GLN B  87      28.603 113.824  21.537  1.00  6.45           C  
ATOM   1491  C   GLN B  87      29.005 114.751  20.365  1.00  6.94           C  
ATOM   1492  O   GLN B  87      30.047 115.388  20.431  1.00  6.86           O  
ATOM   1493  CB  GLN B  87      29.123 112.405  21.389  1.00  5.41           C  
ATOM   1494  CG  GLN B  87      28.886 111.539  22.627  1.00  6.07           C  
ATOM   1495  CD  GLN B  87      29.532 112.115  23.873  1.00  8.22           C  
ATOM   1496  OE1 GLN B  87      30.731 112.258  23.927  1.00  7.67           O  
ATOM   1497  NE2 GLN B  87      28.718 112.457  24.887  1.00 11.71           N  
ATOM   1498  N   TYR B  88      28.138 114.881  19.355  1.00  7.20           N  
ATOM   1499  CA  TYR B  88      28.381 115.783  18.248  1.00  7.26           C  
ATOM   1500  C   TYR B  88      28.483 117.252  18.648  1.00  7.53           C  
ATOM   1501  O   TYR B  88      29.202 117.990  18.003  1.00  8.30           O  
ATOM   1502  CB  TYR B  88      27.301 115.622  17.208  1.00  6.36           C  
ATOM   1503  CG  TYR B  88      27.578 116.270  15.860  1.00  5.00           C  
ATOM   1504  CD1 TYR B  88      28.650 115.879  15.073  1.00  2.47           C  
ATOM   1505  CD2 TYR B  88      26.718 117.195  15.346  1.00  3.57           C  
ATOM   1506  CE1 TYR B  88      28.834 116.403  13.820  1.00  2.00           C  
ATOM   1507  CE2 TYR B  88      26.936 117.753  14.079  1.00  2.29           C  
ATOM   1508  CZ  TYR B  88      28.000 117.348  13.351  1.00  2.00           C  
ATOM   1509  OH  TYR B  88      28.201 117.901  12.097  1.00  3.64           O  
ATOM   1510  N   LYS B  89      27.757 117.667  19.673  1.00  8.11           N  
ATOM   1511  CA  LYS B  89      27.914 119.004  20.251  1.00  9.21           C  
ATOM   1512  C   LYS B  89      29.378 119.279  20.632  1.00  9.44           C  
ATOM   1513  O   LYS B  89      29.845 120.430  20.541  1.00 10.00           O  
ATOM   1514  CB  LYS B  89      27.069 119.165  21.532  1.00  9.33           C  
ATOM   1515  CG  LYS B  89      25.578 119.247  21.335  1.00  9.49           C  
ATOM   1516  CD  LYS B  89      24.833 119.179  22.634  1.00 11.74           C  
ATOM   1517  CE  LYS B  89      23.307 119.075  22.273  1.00 18.93           C  
ATOM   1518  NZ  LYS B  89      22.459 118.163  23.153  1.00 18.03           N  
ATOM   1519  N   HIS B  90      30.094 118.242  21.078  1.00  8.71           N  
ATOM   1520  CA  HIS B  90      31.518 118.400  21.380  1.00  8.09           C  
ATOM   1521  C   HIS B  90      32.427 118.139  20.177  1.00  8.11           C  
ATOM   1522  O   HIS B  90      33.343 118.921  19.921  1.00  8.37           O  
ATOM   1523  CB  HIS B  90      31.977 117.568  22.564  1.00  6.85           C  
ATOM   1524  CG  HIS B  90      33.461 117.610  22.775  1.00  6.21           C  
ATOM   1525  ND1 HIS B  90      34.100 118.685  23.342  1.00  7.76           N  
ATOM   1526  CD2 HIS B  90      34.435 116.722  22.463  1.00  4.72           C  
ATOM   1527  CE1 HIS B  90      35.399 118.453  23.386  1.00  6.67           C  
ATOM   1528  NE2 HIS B  90      35.624 117.261  22.878  1.00  5.07           N  
ATOM   1529  N   PHE B  91      32.168 117.074  19.420  1.00  7.06           N  
ATOM   1530  CA  PHE B  91      33.087 116.664  18.380  1.00  6.43           C  
ATOM   1531  C   PHE B  91      33.036 117.382  17.041  1.00  6.99           C  
ATOM   1532  O   PHE B  91      34.021 117.374  16.300  1.00  7.45           O  
ATOM   1533  CB  PHE B  91      33.042 115.148  18.207  1.00  5.03           C  
ATOM   1534  CG  PHE B  91      33.651 114.388  19.360  1.00  3.27           C  
ATOM   1535  CD1 PHE B  91      35.022 114.052  19.347  1.00  2.00           C  
ATOM   1536  CD2 PHE B  91      32.857 114.005  20.455  1.00  2.00           C  
ATOM   1537  CE1 PHE B  91      35.600 113.359  20.396  1.00  2.00           C  
ATOM   1538  CE2 PHE B  91      33.404 113.310  21.513  1.00  2.00           C  
ATOM   1539  CZ  PHE B  91      34.798 112.984  21.501  1.00  2.00           C  
ATOM   1540  N   LYS B  92      31.917 118.008  16.727  1.00  7.57           N  
ATOM   1541  CA  LYS B  92      31.827 118.784  15.510  1.00  8.88           C  
ATOM   1542  C   LYS B  92      33.003 119.767  15.313  1.00  9.14           C  
ATOM   1543  O   LYS B  92      33.604 119.830  14.242  1.00 10.13           O  
ATOM   1544  CB  LYS B  92      30.497 119.543  15.448  1.00  8.95           C  
ATOM   1545  CG  LYS B  92      30.426 120.388  14.156  1.00  9.52           C  
ATOM   1546  CD  LYS B  92      29.069 120.864  13.776  1.00  9.50           C  
ATOM   1547  CE  LYS B  92      29.152 121.606  12.473  1.00 13.46           C  
ATOM   1548  NZ  LYS B  92      27.745 121.726  11.975  1.00 18.08           N  
ATOM   1549  N   SER B  93      33.285 120.549  16.344  1.00  8.86           N  
ATOM   1550  CA  SER B  93      34.319 121.564  16.304  1.00  8.83           C  
ATOM   1551  C   SER B  93      35.658 120.966  16.755  1.00  8.73           C  
ATOM   1552  O   SER B  93      36.618 121.685  17.048  1.00  9.49           O  
ATOM   1553  CB  SER B  93      33.901 122.737  17.177  1.00  8.95           C  
ATOM   1554  OG  SER B  93      33.844 122.341  18.523  1.00  8.92           O  
ATOM   1555  N   GLN B  94      35.718 119.628  16.804  1.00  8.03           N  
ATOM   1556  CA  GLN B  94      36.993 118.867  16.832  1.00  6.31           C  
ATOM   1557  C   GLN B  94      37.351 118.214  15.483  1.00  5.31           C  
ATOM   1558  O   GLN B  94      38.328 117.490  15.400  1.00  4.75           O  
ATOM   1559  CB  GLN B  94      36.959 117.756  17.896  1.00  5.32           C  
ATOM   1560  CG  GLN B  94      36.730 118.221  19.320  1.00  4.22           C  
ATOM   1561  CD  GLN B  94      37.914 118.974  19.880  1.00  6.19           C  
ATOM   1562  OE1 GLN B  94      39.042 118.485  19.818  1.00  7.78           O  
ATOM   1563  NE2 GLN B  94      37.679 120.195  20.386  1.00  2.00           N  
ATOM   1564  N   GLY B  95      36.554 118.454  14.444  1.00  4.81           N  
ATOM   1565  CA  GLY B  95      36.841 117.880  13.118  1.00  4.75           C  
ATOM   1566  C   GLY B  95      36.391 116.440  12.967  1.00  4.74           C  
ATOM   1567  O   GLY B  95      36.932 115.690  12.152  1.00  4.50           O  
ATOM   1568  N   VAL B  96      35.410 116.036  13.782  1.00  4.65           N  
ATOM   1569  CA  VAL B  96      34.653 114.826  13.497  1.00  3.70           C  
ATOM   1570  C   VAL B  96      33.351 115.172  12.752  1.00  4.21           C  
ATOM   1571  O   VAL B  96      32.585 116.031  13.169  1.00  5.06           O  
ATOM   1572  CB  VAL B  96      34.329 114.036  14.756  1.00  3.25           C  
ATOM   1573  CG1 VAL B  96      33.346 112.857  14.395  1.00  2.00           C  
ATOM   1574  CG2 VAL B  96      35.588 113.578  15.424  1.00  2.00           C  
ATOM   1575  N   GLU B  97      33.113 114.540  11.619  1.00  4.19           N  
ATOM   1576  CA  GLU B  97      31.802 114.627  10.986  1.00  4.33           C  
ATOM   1577  C   GLU B  97      30.994 113.333  11.185  1.00  4.41           C  
ATOM   1578  O   GLU B  97      31.568 112.219  11.215  1.00  5.24           O  
ATOM   1579  CB  GLU B  97      31.933 114.995   9.492  1.00  3.55           C  
ATOM   1580  CG  GLU B  97      30.611 115.420   8.797  1.00  6.12           C  
ATOM   1581  CD  GLU B  97      29.854 116.535   9.536  1.00  6.38           C  
ATOM   1582  OE1 GLU B  97      29.302 116.309  10.628  1.00  8.06           O  
ATOM   1583  OE2 GLU B  97      29.773 117.641   9.024  1.00  6.34           O  
ATOM   1584  N   ILE B  98      29.665 113.462  11.313  1.00  4.43           N  
ATOM   1585  CA  ILE B  98      28.803 112.279  11.315  1.00  3.45           C  
ATOM   1586  C   ILE B  98      28.179 112.234   9.924  1.00  4.27           C  
ATOM   1587  O   ILE B  98      27.709 113.278   9.429  1.00  4.15           O  
ATOM   1588  CB  ILE B  98      27.672 112.356  12.381  1.00  2.60           C  
ATOM   1589  CG1 ILE B  98      28.244 112.336  13.804  1.00  3.49           C  
ATOM   1590  CG2 ILE B  98      26.693 111.197  12.221  1.00  2.22           C  
ATOM   1591  CD1 ILE B  98      27.227 112.549  14.915  1.00  2.83           C  
ATOM   1592  N   VAL B  99      28.193 111.058   9.280  1.00  3.99           N  
ATOM   1593  CA  VAL B  99      27.337 110.808   8.129  1.00  4.01           C  
ATOM   1594  C   VAL B  99      26.364 109.674   8.461  1.00  4.12           C  
ATOM   1595  O   VAL B  99      26.771 108.522   8.561  1.00  3.78           O  
ATOM   1596  CB  VAL B  99      28.136 110.500   6.826  1.00  3.95           C  
ATOM   1597  CG1 VAL B  99      27.185 110.489   5.609  1.00  3.02           C  
ATOM   1598  CG2 VAL B  99      29.170 111.578   6.585  1.00  4.23           C  
ATOM   1599  N   ALA B 100      25.094 110.004   8.711  1.00  4.00           N  
ATOM   1600  CA  ALA B 100      24.119 108.954   9.134  1.00  3.46           C  
ATOM   1601  C   ALA B 100      23.310 108.536   7.906  1.00  4.08           C  
ATOM   1602  O   ALA B 100      22.448 109.285   7.433  1.00  3.87           O  
ATOM   1603  CB  ALA B 100      23.221 109.449  10.259  1.00  3.74           C  
ATOM   1604  N   VAL B 101      23.672 107.375   7.354  1.00  4.05           N  
ATOM   1605  CA  VAL B 101      23.079 106.850   6.117  1.00  3.59           C  
ATOM   1606  C   VAL B 101      21.803 106.055   6.450  1.00  4.15           C  
ATOM   1607  O   VAL B 101      21.833 104.979   7.034  1.00  2.32           O  
ATOM   1608  CB  VAL B 101      24.098 105.970   5.330  1.00  3.93           C  
ATOM   1609  CG1 VAL B 101      23.508 105.513   4.009  1.00  2.00           C  
ATOM   1610  CG2 VAL B 101      25.485 106.734   5.147  1.00  3.27           C  
ATOM   1611  N   ASN B 102      20.671 106.654   6.127  1.00  5.33           N  
ATOM   1612  CA  ASN B 102      19.414 105.962   6.230  1.00  6.42           C  
ATOM   1613  C   ASN B 102      19.294 104.981   5.069  1.00  7.66           C  
ATOM   1614  O   ASN B 102      19.520 105.338   3.893  1.00  7.43           O  
ATOM   1615  CB  ASN B 102      18.222 106.917   6.231  1.00  6.18           C  
ATOM   1616  CG  ASN B 102      16.918 106.150   6.216  1.00  6.62           C  
ATOM   1617  OD1 ASN B 102      16.466 105.729   5.155  1.00  5.00           O  
ATOM   1618  ND2 ASN B 102      16.383 105.859   7.391  1.00  5.47           N  
ATOM   1619  N   VAL B 103      18.923 103.760   5.409  1.00  8.29           N  
ATOM   1620  CA  VAL B 103      18.912 102.683   4.457  1.00  9.32           C  
ATOM   1621  C   VAL B 103      17.509 102.559   3.856  1.00 11.14           C  
ATOM   1622  O   VAL B 103      16.677 101.817   4.345  1.00 12.85           O  
ATOM   1623  CB  VAL B 103      19.380 101.401   5.165  1.00  8.51           C  
ATOM   1624  CG1 VAL B 103      19.042 100.159   4.375  1.00  8.65           C  
ATOM   1625  CG2 VAL B 103      20.871 101.520   5.455  1.00  8.62           C  
ATOM   1626  N   GLY B 104      17.207 103.323   2.826  1.00 11.71           N  
ATOM   1627  CA  GLY B 104      16.093 102.959   1.989  1.00 11.86           C  
ATOM   1628  C   GLY B 104      14.723 103.527   2.285  1.00 13.24           C  
ATOM   1629  O   GLY B 104      13.782 103.211   1.588  1.00 13.71           O  
ATOM   1630  N   GLU B 105      14.600 104.392   3.279  1.00 13.61           N  
ATOM   1631  CA  GLU B 105      13.308 104.823   3.752  1.00 14.12           C  
ATOM   1632  C   GLU B 105      12.926 106.126   3.094  1.00 15.72           C  
ATOM   1633  O   GLU B 105      13.786 106.787   2.497  1.00 16.71           O  
ATOM   1634  CB  GLU B 105      13.328 104.953   5.286  1.00 13.43           C  
ATOM   1635  CG  GLU B 105      13.412 103.577   5.968  1.00 13.59           C  
ATOM   1636  CD  GLU B 105      13.407 103.652   7.463  1.00 17.16           C  
ATOM   1637  OE1 GLU B 105      12.412 103.142   8.053  1.00 18.99           O  
ATOM   1638  OE2 GLU B 105      14.371 104.220   8.064  1.00 15.45           O  
ATOM   1639  N   SER B 106      11.651 106.510   3.185  1.00 16.70           N  
ATOM   1640  CA  SER B 106      11.195 107.742   2.544  1.00 17.96           C  
ATOM   1641  C   SER B 106      11.738 108.971   3.266  1.00 18.57           C  
ATOM   1642  O   SER B 106      12.047 108.923   4.458  1.00 18.90           O  
ATOM   1643  CB  SER B 106       9.668 107.834   2.481  1.00 16.85           C  
ATOM   1644  OG  SER B 106       9.165 107.984   3.785  1.00 16.98           O  
ATOM   1645  N   LYS B 107      11.839 110.079   2.540  1.00 19.37           N  
ATOM   1646  CA  LYS B 107      12.186 111.347   3.158  1.00 20.09           C  
ATOM   1647  C   LYS B 107      11.256 111.769   4.347  1.00 19.68           C  
ATOM   1648  O   LYS B 107      11.761 112.402   5.273  1.00 20.08           O  
ATOM   1649  CB  LYS B 107      12.429 112.437   2.093  1.00 21.02           C  
ATOM   1650  CG  LYS B 107      12.612 113.874   2.646  1.00 26.70           C  
ATOM   1651  CD  LYS B 107      13.764 114.669   1.977  1.00 31.42           C  
ATOM   1652  CE  LYS B 107      13.268 115.875   1.140  1.00 33.84           C  
ATOM   1653  NZ  LYS B 107      14.382 116.849   0.751  1.00 33.81           N  
ATOM   1654  N   ILE B 108       9.955 111.398   4.377  1.00 19.17           N  
ATOM   1655  CA  ILE B 108       9.139 111.724   5.558  1.00 18.81           C  
ATOM   1656  C   ILE B 108       9.401 110.850   6.750  1.00 17.69           C  
ATOM   1657  O   ILE B 108       9.414 111.369   7.853  1.00 18.20           O  
ATOM   1658  CB  ILE B 108       7.580 111.865   5.349  1.00 19.59           C  
ATOM   1659  CG1 ILE B 108       6.971 110.622   4.705  1.00 21.06           C  
ATOM   1660  CG2 ILE B 108       7.212 113.198   4.672  1.00 20.48           C  
ATOM   1661  CD1 ILE B 108       6.304 109.681   5.721  1.00 24.28           C  
ATOM   1662  N   ALA B 109       9.590 109.545   6.541  1.00 16.37           N  
ATOM   1663  CA  ALA B 109       9.861 108.600   7.607  1.00 15.24           C  
ATOM   1664  C   ALA B 109      11.156 108.992   8.319  1.00 15.69           C  
ATOM   1665  O   ALA B 109      11.309 108.838   9.542  1.00 16.25           O  
ATOM   1666  CB  ALA B 109       9.971 107.224   7.043  1.00 14.52           C  
ATOM   1667  N   VAL B 110      12.084 109.527   7.534  1.00 15.44           N  
ATOM   1668  CA  VAL B 110      13.391 109.981   8.020  1.00 14.96           C  
ATOM   1669  C   VAL B 110      13.257 111.314   8.784  1.00 16.01           C  
ATOM   1670  O   VAL B 110      13.822 111.454   9.908  1.00 15.40           O  
ATOM   1671  CB  VAL B 110      14.460 110.070   6.863  1.00 13.71           C  
ATOM   1672  CG1 VAL B 110      15.775 110.509   7.383  1.00 11.53           C  
ATOM   1673  CG2 VAL B 110      14.601 108.724   6.143  1.00 11.46           C  
ATOM   1674  N   HIS B 111      12.542 112.284   8.199  1.00 16.71           N  
ATOM   1675  CA  HIS B 111      12.299 113.570   8.899  0.70 18.05           C  
ATOM   1677  C   HIS B 111      11.513 113.369  10.203  1.00 17.87           C  
ATOM   1678  O   HIS B 111      11.764 114.066  11.189  1.00 18.32           O  
ATOM   1679  CB  HIS B 111      11.621 114.622   8.016  0.70 18.56           C  
ATOM   1681  CG  HIS B 111      10.991 115.747   8.789  0.70 23.63           C  
ATOM   1683  ND1 HIS B 111       9.869 115.576   9.582  0.70 26.64           N  
ATOM   1685  CD2 HIS B 111      11.317 117.065   8.883  0.70 27.03           C  
ATOM   1687  CE1 HIS B 111       9.547 116.731  10.144  0.70 28.59           C  
ATOM   1689  NE2 HIS B 111      10.407 117.652   9.733  0.70 28.19           N  
ATOM   1691  N   ASN B 112      10.588 112.408  10.232  1.00 17.73           N  
ATOM   1692  CA  ASN B 112       9.875 112.141  11.475  1.00 17.55           C  
ATOM   1693  C   ASN B 112      10.852 111.668  12.532  1.00 17.08           C  
ATOM   1694  O   ASN B 112      10.820 112.111  13.658  1.00 17.76           O  
ATOM   1695  CB  ASN B 112       8.754 111.096  11.298  1.00 17.19           C  
ATOM   1696  CG  ASN B 112       7.666 111.542  10.328  1.00 15.89           C  
ATOM   1697  OD1 ASN B 112       7.013 110.694   9.712  1.00 12.52           O  
ATOM   1698  ND2 ASN B 112       7.484 112.865  10.169  1.00 13.87           N  
ATOM   1699  N   PHE B 113      11.705 110.733  12.161  1.00 16.68           N  
ATOM   1700  CA  PHE B 113      12.656 110.169  13.103  1.00 16.30           C  
ATOM   1701  C   PHE B 113      13.606 111.242  13.627  1.00 16.43           C  
ATOM   1702  O   PHE B 113      13.857 111.318  14.805  1.00 16.29           O  
ATOM   1703  CB  PHE B 113      13.457 109.047  12.476  1.00 15.40           C  
ATOM   1704  CG  PHE B 113      14.051 108.096  13.485  1.00 15.66           C  
ATOM   1705  CD1 PHE B 113      15.370 108.290  13.981  1.00 16.72           C  
ATOM   1706  CD2 PHE B 113      13.312 107.015  13.947  1.00 13.73           C  
ATOM   1707  CE1 PHE B 113      15.934 107.394  14.895  1.00 10.59           C  
ATOM   1708  CE2 PHE B 113      13.864 106.113  14.853  1.00 13.26           C  
ATOM   1709  CZ  PHE B 113      15.185 106.313  15.328  1.00 12.66           C  
ATOM   1710  N   MET B 114      14.106 112.092  12.744  1.00 16.81           N  
ATOM   1711  CA  MET B 114      15.066 113.116  13.151  1.00 17.41           C  
ATOM   1712  C   MET B 114      14.472 114.088  14.170  1.00 18.76           C  
ATOM   1713  O   MET B 114      15.140 114.477  15.154  1.00 18.96           O  
ATOM   1714  CB  MET B 114      15.617 113.893  11.944  1.00 16.34           C  
ATOM   1715  CG  MET B 114      16.597 113.080  11.100  1.00 14.80           C  
ATOM   1716  SD  MET B 114      16.849 113.841   9.505  1.00 14.27           S  
ATOM   1717  CE  MET B 114      17.750 115.354   9.904  1.00 10.28           C  
ATOM   1718  N   LYS B 115      13.235 114.501  13.896  1.00 19.98           N  
ATOM   1719  CA  LYS B 115      12.459 115.355  14.778  1.00 21.03           C  
ATOM   1720  C   LYS B 115      12.221 114.707  16.119  1.00 20.55           C  
ATOM   1721  O   LYS B 115      12.397 115.360  17.128  1.00 20.92           O  
ATOM   1722  CB  LYS B 115      11.126 115.765  14.137  1.00 21.84           C  
ATOM   1723  CG  LYS B 115      10.271 116.647  15.009  1.00 24.67           C  
ATOM   1724  CD  LYS B 115       9.311 117.523  14.176  1.00 31.19           C  
ATOM   1725  CE  LYS B 115       8.325 118.353  15.059  1.00 30.58           C  
ATOM   1726  NZ  LYS B 115       7.302 119.194  14.295  1.00 31.72           N  
ATOM   1727  N   SER B 116      11.841 113.429  16.142  1.00 20.45           N  
ATOM   1728  CA  SER B 116      11.568 112.742  17.405  1.00 20.11           C  
ATOM   1729  C   SER B 116      12.810 112.525  18.271  1.00 20.34           C  
ATOM   1730  O   SER B 116      12.717 112.468  19.504  1.00 20.09           O  
ATOM   1731  CB  SER B 116      10.933 111.388  17.129  1.00 20.05           C  
ATOM   1732  OG  SER B 116       9.619 111.542  16.663  1.00 21.47           O  
ATOM   1733  N   TYR B 117      13.969 112.368  17.624  1.00 20.26           N  
ATOM   1734  CA  TYR B 117      15.198 111.995  18.338  1.00 19.46           C  
ATOM   1735  C   TYR B 117      16.285 113.092  18.432  1.00 19.17           C  
ATOM   1736  O   TYR B 117      17.420 112.827  18.788  1.00 19.25           O  
ATOM   1737  CB  TYR B 117      15.673 110.614  17.899  1.00 19.20           C  
ATOM   1738  CG  TYR B 117      14.625 109.597  18.293  1.00 19.68           C  
ATOM   1739  CD1 TYR B 117      14.550 109.129  19.601  1.00 19.15           C  
ATOM   1740  CD2 TYR B 117      13.649 109.179  17.384  1.00 19.01           C  
ATOM   1741  CE1 TYR B 117      13.563 108.247  20.000  1.00 20.15           C  
ATOM   1742  CE2 TYR B 117      12.667 108.277  17.765  1.00 19.86           C  
ATOM   1743  CZ  TYR B 117      12.622 107.819  19.077  1.00 20.78           C  
ATOM   1744  OH  TYR B 117      11.628 106.928  19.475  1.00 20.27           O  
ATOM   1745  N   GLY B 118      15.881 114.336  18.155  1.00 18.98           N  
ATOM   1746  CA  GLY B 118      16.708 115.531  18.380  1.00 18.21           C  
ATOM   1747  C   GLY B 118      17.979 115.582  17.534  1.00 18.01           C  
ATOM   1748  O   GLY B 118      19.033 116.042  18.020  1.00 19.00           O  
ATOM   1749  N   VAL B 119      17.888 115.116  16.280  1.00 16.04           N  
ATOM   1750  CA  VAL B 119      19.073 114.975  15.428  1.00 14.58           C  
ATOM   1751  C   VAL B 119      19.659 116.331  15.065  1.00 13.55           C  
ATOM   1752  O   VAL B 119      18.939 117.218  14.610  1.00 13.60           O  
ATOM   1753  CB  VAL B 119      18.806 114.116  14.171  1.00 14.08           C  
ATOM   1754  CG1 VAL B 119      19.968 114.256  13.183  1.00 14.66           C  
ATOM   1755  CG2 VAL B 119      18.604 112.669  14.571  1.00 12.64           C  
ATOM   1756  N   ASN B 120      20.967 116.483  15.280  1.00 12.32           N  
ATOM   1757  CA  ASN B 120      21.655 117.766  15.022  1.00 11.23           C  
ATOM   1758  C   ASN B 120      22.800 117.611  13.987  1.00 11.11           C  
ATOM   1759  O   ASN B 120      23.636 118.516  13.816  1.00 11.21           O  
ATOM   1760  CB  ASN B 120      22.159 118.382  16.333  1.00 10.22           C  
ATOM   1761  CG  ASN B 120      23.181 117.497  17.066  1.00  9.91           C  
ATOM   1762  OD1 ASN B 120      23.527 116.435  16.585  1.00 11.48           O  
ATOM   1763  ND2 ASN B 120      23.658 117.942  18.227  1.00  5.35           N  
ATOM   1764  N   PHE B 121      22.813 116.461  13.313  1.00  9.76           N  
ATOM   1765  CA  PHE B 121      23.939 116.061  12.478  1.00  8.81           C  
ATOM   1766  C   PHE B 121      23.494 115.643  11.097  1.00  8.58           C  
ATOM   1767  O   PHE B 121      22.309 115.455  10.856  1.00  9.79           O  
ATOM   1768  CB  PHE B 121      24.751 114.924  13.147  1.00  7.84           C  
ATOM   1769  CG  PHE B 121      23.932 113.734  13.548  1.00  5.92           C  
ATOM   1770  CD1 PHE B 121      23.526 112.797  12.591  1.00  4.89           C  
ATOM   1771  CD2 PHE B 121      23.570 113.534  14.878  1.00  3.42           C  
ATOM   1772  CE1 PHE B 121      22.800 111.699  12.951  1.00  2.88           C  
ATOM   1773  CE2 PHE B 121      22.825 112.400  15.271  1.00  2.53           C  
ATOM   1774  CZ  PHE B 121      22.431 111.494  14.302  1.00  5.31           C  
ATOM   1775  N   PRO B 122      24.444 115.514  10.164  1.00  8.28           N  
ATOM   1776  CA  PRO B 122      24.081 115.137   8.794  1.00  7.75           C  
ATOM   1777  C   PRO B 122      23.466 113.739   8.588  1.00  7.42           C  
ATOM   1778  O   PRO B 122      23.943 112.765   9.149  1.00  7.28           O  
ATOM   1779  CB  PRO B 122      25.393 115.329   8.039  1.00  8.03           C  
ATOM   1780  CG  PRO B 122      26.159 116.323   8.943  1.00  6.33           C  
ATOM   1781  CD  PRO B 122      25.883 115.797  10.282  1.00  6.52           C  
ATOM   1782  N   VAL B 123      22.377 113.683   7.805  1.00  6.78           N  
ATOM   1783  CA  VAL B 123      21.660 112.455   7.492  1.00  5.62           C  
ATOM   1784  C   VAL B 123      21.531 112.394   5.982  1.00  6.63           C  
ATOM   1785  O   VAL B 123      21.096 113.354   5.331  1.00  6.75           O  
ATOM   1786  CB  VAL B 123      20.240 112.418   8.194  1.00  6.10           C  
ATOM   1787  CG1 VAL B 123      19.317 111.217   7.677  1.00  2.00           C  
ATOM   1788  CG2 VAL B 123      20.388 112.407   9.706  1.00  3.25           C  
ATOM   1789  N   VAL B 124      21.910 111.268   5.408  1.00  7.09           N  
ATOM   1790  CA  VAL B 124      21.809 111.101   3.972  1.00  7.19           C  
ATOM   1791  C   VAL B 124      20.894 109.916   3.653  1.00  8.35           C  
ATOM   1792  O   VAL B 124      20.653 109.056   4.505  1.00  7.50           O  
ATOM   1793  CB  VAL B 124      23.210 110.986   3.318  1.00  7.45           C  
ATOM   1794  CG1 VAL B 124      23.992 112.322   3.466  1.00  7.23           C  
ATOM   1795  CG2 VAL B 124      24.010 109.845   3.911  1.00  3.64           C  
ATOM   1796  N   LEU B 125      20.383 109.898   2.422  1.00  9.25           N  
ATOM   1797  CA  LEU B 125      19.364 108.969   1.997  1.00  9.77           C  
ATOM   1798  C   LEU B 125      19.906 107.981   1.004  1.00 10.46           C  
ATOM   1799  O   LEU B 125      20.174 108.325  -0.157  1.00 11.18           O  
ATOM   1800  CB  LEU B 125      18.209 109.768   1.385  1.00 10.41           C  
ATOM   1801  CG  LEU B 125      17.610 110.829   2.351  1.00 11.25           C  
ATOM   1802  CD1 LEU B 125      16.680 111.683   1.600  1.00 10.49           C  
ATOM   1803  CD2 LEU B 125      16.916 110.184   3.542  1.00  8.80           C  
ATOM   1804  N   ASP B 126      20.077 106.753   1.458  1.00 11.27           N  
ATOM   1805  CA  ASP B 126      20.546 105.653   0.603  1.00 12.64           C  
ATOM   1806  C   ASP B 126      19.302 104.937   0.032  1.00 14.00           C  
ATOM   1807  O   ASP B 126      18.992 103.808   0.404  1.00 13.05           O  
ATOM   1808  CB  ASP B 126      21.433 104.711   1.433  1.00 10.93           C  
ATOM   1809  CG  ASP B 126      22.089 103.608   0.610  1.00 11.75           C  
ATOM   1810  OD1 ASP B 126      22.404 103.830  -0.592  1.00 10.43           O  
ATOM   1811  OD2 ASP B 126      22.313 102.496   1.181  1.00 11.18           O  
ATOM   1812  N   THR B 127      18.590 105.646  -0.847  1.00 16.35           N  
ATOM   1813  CA  THR B 127      17.276 105.233  -1.356  1.00 17.79           C  
ATOM   1814  C   THR B 127      17.257 103.906  -2.118  1.00 18.46           C  
ATOM   1815  O   THR B 127      16.297 103.179  -2.020  1.00 18.61           O  
ATOM   1816  CB  THR B 127      16.632 106.334  -2.212  1.00 17.76           C  
ATOM   1817  OG1 THR B 127      17.414 106.506  -3.409  1.00 17.69           O  
ATOM   1818  CG2 THR B 127      16.591 107.629  -1.436  1.00 16.69           C  
ATOM   1819  N   ASP B 128      18.295 103.600  -2.874  1.00 19.51           N  
ATOM   1820  CA  ASP B 128      18.355 102.374  -3.672  1.00 20.81           C  
ATOM   1821  C   ASP B 128      19.089 101.296  -2.889  1.00 20.13           C  
ATOM   1822  O   ASP B 128      19.274 100.168  -3.371  1.00 20.13           O  
ATOM   1823  CB  ASP B 128      19.092 102.653  -4.976  1.00 21.82           C  
ATOM   1824  CG  ASP B 128      20.386 103.546  -4.785  1.00 29.50           C  
ATOM   1825  OD1 ASP B 128      21.022 103.665  -3.662  1.00 31.59           O  
ATOM   1826  OD2 ASP B 128      20.767 104.170  -5.828  1.00 39.74           O  
ATOM   1827  N   ARG B 129      19.528 101.652  -1.680  1.00 19.44           N  
ATOM   1828  CA  ARG B 129      20.400 100.804  -0.824  1.00 18.42           C  
ATOM   1829  C   ARG B 129      21.781 100.429  -1.423  1.00 17.76           C  
ATOM   1830  O   ARG B 129      22.403  99.450  -1.019  1.00 17.76           O  
ATOM   1831  CB  ARG B 129      19.667  99.546  -0.335  1.00 17.78           C  
ATOM   1832  CG  ARG B 129      18.478  99.823   0.550  1.00 18.54           C  
ATOM   1833  CD  ARG B 129      17.513  98.655   0.600  1.00 21.34           C  
ATOM   1834  NE  ARG B 129      18.193  97.429   0.998  1.00 24.17           N  
ATOM   1835  CZ  ARG B 129      18.147  96.881   2.220  1.00 25.73           C  
ATOM   1836  NH1 ARG B 129      17.420  97.437   3.200  1.00 23.29           N  
ATOM   1837  NH2 ARG B 129      18.852  95.771   2.461  1.00 25.96           N  
ATOM   1838  N   GLN B 130      22.259 101.210  -2.378  1.00 17.00           N  
ATOM   1839  CA  GLN B 130      23.502 100.885  -3.044  1.00 17.19           C  
ATOM   1840  C   GLN B 130      24.764 101.138  -2.199  1.00 15.77           C  
ATOM   1841  O   GLN B 130      25.745 100.389  -2.288  1.00 15.74           O  
ATOM   1842  CB  GLN B 130      23.566 101.576  -4.397  1.00 17.73           C  
ATOM   1843  CG  GLN B 130      22.655 100.939  -5.458  1.00 18.61           C  
ATOM   1844  CD  GLN B 130      22.654 101.785  -6.706  1.00 22.71           C  
ATOM   1845  OE1 GLN B 130      23.706 102.330  -7.075  1.00 29.07           O  
ATOM   1846  NE2 GLN B 130      21.492 101.938  -7.351  1.00 20.75           N  
ATOM   1847  N   VAL B 131      24.714 102.156  -1.351  1.00 14.00           N  
ATOM   1848  CA  VAL B 131      25.799 102.439  -0.426  1.00 12.20           C  
ATOM   1849  C   VAL B 131      25.900 101.340   0.628  1.00 12.40           C  
ATOM   1850  O   VAL B 131      26.999 100.856   0.935  1.00 12.07           O  
ATOM   1851  CB  VAL B 131      25.653 103.847   0.187  1.00 10.76           C  
ATOM   1852  CG1 VAL B 131      26.793 104.108   1.150  1.00  8.94           C  
ATOM   1853  CG2 VAL B 131      25.623 104.860  -0.948  1.00  7.65           C  
ATOM   1854  N   LEU B 132      24.757 100.919   1.154  1.00 13.00           N  
ATOM   1855  CA  LEU B 132      24.723  99.813   2.094  1.00 13.88           C  
ATOM   1856  C   LEU B 132      25.341  98.538   1.517  1.00 14.28           C  
ATOM   1857  O   LEU B 132      26.082  97.851   2.212  1.00 14.32           O  
ATOM   1858  CB  LEU B 132      23.301  99.551   2.542  1.00 13.18           C  
ATOM   1859  CG  LEU B 132      23.060  98.233   3.278  1.00 13.84           C  
ATOM   1860  CD1 LEU B 132      22.825  98.526   4.739  1.00 12.53           C  
ATOM   1861  CD2 LEU B 132      21.861  97.417   2.653  1.00  9.46           C  
ATOM   1862  N   ASP B 133      25.022  98.220   0.260  1.00 15.11           N  
ATOM   1863  CA  ASP B 133      25.627  97.073  -0.424  1.00 15.92           C  
ATOM   1864  C   ASP B 133      27.106  97.291  -0.676  1.00 15.84           C  
ATOM   1865  O   ASP B 133      27.885  96.337  -0.601  1.00 15.80           O  
ATOM   1866  CB  ASP B 133      24.904  96.735  -1.734  1.00 15.50           C  
ATOM   1867  CG  ASP B 133      23.499  96.245  -1.520  1.00 17.26           C  
ATOM   1868  OD1 ASP B 133      23.152  95.792  -0.419  1.00 20.98           O  
ATOM   1869  OD2 ASP B 133      22.699  96.306  -2.464  1.00 21.13           O  
ATOM   1870  N   ALA B 134      27.485  98.536  -1.006  1.00 15.54           N  
ATOM   1871  CA  ALA B 134      28.888  98.878  -1.191  1.00 15.54           C  
ATOM   1872  C   ALA B 134      29.686  98.619   0.090  1.00 15.71           C  
ATOM   1873  O   ALA B 134      30.811  98.178   0.035  1.00 16.70           O  
ATOM   1874  CB  ALA B 134      29.022 100.314  -1.664  1.00 15.06           C  
ATOM   1875  N   TYR B 135      29.072  98.838   1.246  1.00 15.68           N  
ATOM   1876  CA  TYR B 135      29.729  98.605   2.519  1.00 15.45           C  
ATOM   1877  C   TYR B 135      29.542  97.226   3.098  1.00 17.26           C  
ATOM   1878  O   TYR B 135      30.129  96.886   4.112  1.00 17.43           O  
ATOM   1879  CB  TYR B 135      29.320  99.669   3.531  1.00 12.52           C  
ATOM   1880  CG  TYR B 135      30.152 100.879   3.367  1.00  8.45           C  
ATOM   1881  CD1 TYR B 135      29.930 101.743   2.310  1.00  2.51           C  
ATOM   1882  CD2 TYR B 135      31.222 101.129   4.214  1.00  5.03           C  
ATOM   1883  CE1 TYR B 135      30.684 102.828   2.136  1.00  3.14           C  
ATOM   1884  CE2 TYR B 135      32.005 102.248   4.038  1.00  2.82           C  
ATOM   1885  CZ  TYR B 135      31.727 103.089   3.007  1.00  5.39           C  
ATOM   1886  OH  TYR B 135      32.503 104.211   2.772  1.00  8.84           O  
ATOM   1887  N   ASP B 136      28.712  96.433   2.439  1.00 19.92           N  
ATOM   1888  CA  ASP B 136      28.411  95.046   2.835  1.00 22.26           C  
ATOM   1889  C   ASP B 136      27.819  94.959   4.230  1.00 22.45           C  
ATOM   1890  O   ASP B 136      28.278  94.190   5.051  1.00 23.00           O  
ATOM   1891  CB  ASP B 136      29.650  94.135   2.664  1.00 22.55           C  
ATOM   1892  CG  ASP B 136      29.300  92.627   2.695  1.00 27.10           C  
ATOM   1893  OD1 ASP B 136      28.171  92.227   2.269  1.00 25.71           O  
ATOM   1894  OD2 ASP B 136      30.190  91.833   3.123  1.00 31.11           O  
ATOM   1895  N   VAL B 137      26.759  95.717   4.469  1.00 23.45           N  
ATOM   1896  CA  VAL B 137      26.356  96.045   5.816  1.00 23.97           C  
ATOM   1897  C   VAL B 137      25.354  95.057   6.457  1.00 26.04           C  
ATOM   1898  O   VAL B 137      25.685  94.447   7.480  1.00 27.01           O  
ATOM   1899  CB  VAL B 137      25.863  97.538   5.897  1.00 23.23           C  
ATOM   1900  CG1 VAL B 137      25.147  97.812   7.145  1.00 21.77           C  
ATOM   1901  CG2 VAL B 137      27.006  98.484   5.793  1.00 21.85           C  
ATOM   1902  N   SER B 138      24.183  94.868   5.844  1.00 27.47           N  
ATOM   1903  CA  SER B 138      22.842  94.635   6.552  1.00 29.43           C  
ATOM   1904  C   SER B 138      22.369  94.310   8.030  1.00 29.53           C  
ATOM   1905  O   SER B 138      21.150  94.429   8.267  1.00 30.55           O  
ATOM   1906  CB  SER B 138      21.822  94.014   5.589  1.00 30.64           C  
ATOM   1907  OG  SER B 138      20.617  94.802   5.622  1.00 32.54           O  
ATOM   1908  N   PRO B 139      23.236  93.931   9.023  1.00 29.21           N  
ATOM   1909  CA  PRO B 139      22.621  94.118  10.378  1.00 28.00           C  
ATOM   1910  C   PRO B 139      22.653  95.635  10.821  1.00 25.72           C  
ATOM   1911  O   PRO B 139      23.740  96.268  10.847  1.00 25.86           O  
ATOM   1912  CB  PRO B 139      23.520  93.259  11.310  1.00 28.42           C  
ATOM   1913  CG  PRO B 139      24.916  93.331  10.660  1.00 29.00           C  
ATOM   1914  CD  PRO B 139      24.619  93.389   9.127  1.00 30.05           C  
ATOM   1915  N   LEU B 140      21.486  96.206  11.120  1.00 21.74           N  
ATOM   1916  CA  LEU B 140      21.401  97.615  11.488  1.00 18.09           C  
ATOM   1917  C   LEU B 140      21.230  97.802  12.983  1.00 16.44           C  
ATOM   1918  O   LEU B 140      20.487  97.080  13.603  1.00 16.60           O  
ATOM   1919  CB  LEU B 140      20.336  98.369  10.677  1.00 16.85           C  
ATOM   1920  CG  LEU B 140      20.685  98.415   9.192  1.00 14.03           C  
ATOM   1921  CD1 LEU B 140      19.891  99.453   8.555  1.00 16.11           C  
ATOM   1922  CD2 LEU B 140      22.164  98.710   8.946  1.00  9.82           C  
ATOM   1923  N   PRO B 141      21.978  98.746  13.574  1.00 14.63           N  
ATOM   1924  CA  PRO B 141      22.943  99.635  12.883  1.00 13.14           C  
ATOM   1925  C   PRO B 141      24.333  99.057  12.722  1.00 11.99           C  
ATOM   1926  O   PRO B 141      24.677  98.051  13.372  1.00 12.12           O  
ATOM   1927  CB  PRO B 141      22.990 100.886  13.778  1.00 13.60           C  
ATOM   1928  CG  PRO B 141      22.429 100.431  15.139  1.00 13.77           C  
ATOM   1929  CD  PRO B 141      21.888  99.024  15.017  1.00 14.19           C  
ATOM   1930  N   THR B 142      25.112  99.681  11.835  1.00 10.77           N  
ATOM   1931  CA  THR B 142      26.512  99.380  11.707  1.00  9.60           C  
ATOM   1932  C   THR B 142      27.243 100.699  11.565  1.00  9.08           C  
ATOM   1933  O   THR B 142      26.781 101.545  10.844  1.00  9.33           O  
ATOM   1934  CB  THR B 142      26.739  98.402  10.574  1.00  9.24           C  
ATOM   1935  OG1 THR B 142      26.108  97.174  10.950  1.00 11.74           O  
ATOM   1936  CG2 THR B 142      28.193  98.138  10.387  1.00  8.61           C  
ATOM   1937  N   THR B 143      28.370 100.869  12.267  1.00  8.27           N  
ATOM   1938  CA  THR B 143      29.157 102.086  12.156  1.00  7.68           C  
ATOM   1939  C   THR B 143      30.557 101.766  11.637  1.00  7.26           C  
ATOM   1940  O   THR B 143      31.197 100.832  12.110  1.00  6.74           O  
ATOM   1941  CB  THR B 143      29.213 102.851  13.491  1.00  6.44           C  
ATOM   1942  OG1 THR B 143      27.881 103.227  13.862  1.00  7.82           O  
ATOM   1943  CG2 THR B 143      30.024 104.064  13.347  1.00  6.20           C  
ATOM   1944  N   PHE B 144      30.989 102.538  10.638  1.00  6.95           N  
ATOM   1945  CA  PHE B 144      32.382 102.542  10.178  1.00  6.01           C  
ATOM   1946  C   PHE B 144      33.085 103.822  10.672  1.00  4.97           C  
ATOM   1947  O   PHE B 144      32.571 104.928  10.520  1.00  3.89           O  
ATOM   1948  CB  PHE B 144      32.450 102.394   8.645  1.00  6.26           C  
ATOM   1949  CG  PHE B 144      31.869 101.103   8.146  1.00  7.50           C  
ATOM   1950  CD1 PHE B 144      30.485 100.908   8.125  1.00  9.91           C  
ATOM   1951  CD2 PHE B 144      32.688 100.098   7.682  1.00  8.32           C  
ATOM   1952  CE1 PHE B 144      29.940  99.730   7.686  1.00 11.70           C  
ATOM   1953  CE2 PHE B 144      32.146  98.885   7.221  1.00 11.60           C  
ATOM   1954  CZ  PHE B 144      30.783  98.699   7.238  1.00 11.73           C  
ATOM   1955  N   LEU B 145      34.255 103.629  11.276  1.00  4.71           N  
ATOM   1956  CA  LEU B 145      35.076 104.704  11.804  1.00  4.02           C  
ATOM   1957  C   LEU B 145      36.145 105.001  10.770  1.00  4.29           C  
ATOM   1958  O   LEU B 145      36.962 104.150  10.425  1.00  4.14           O  
ATOM   1959  CB  LEU B 145      35.627 104.324  13.177  1.00  4.03           C  
ATOM   1960  CG  LEU B 145      34.475 104.056  14.204  1.00  2.20           C  
ATOM   1961  CD1 LEU B 145      35.032 103.679  15.459  1.00  2.00           C  
ATOM   1962  CD2 LEU B 145      33.576 105.284  14.416  1.00  2.00           C  
ATOM   1963  N   ILE B 146      36.039 106.180  10.170  1.00  4.05           N  
ATOM   1964  CA  ILE B 146      36.911 106.533   9.076  1.00  3.93           C  
ATOM   1965  C   ILE B 146      37.849 107.638   9.547  1.00  4.95           C  
ATOM   1966  O   ILE B 146      37.395 108.680  10.026  1.00  5.50           O  
ATOM   1967  CB  ILE B 146      36.103 106.924   7.828  1.00  3.25           C  
ATOM   1968  CG1 ILE B 146      35.323 105.681   7.305  1.00  4.04           C  
ATOM   1969  CG2 ILE B 146      37.012 107.471   6.758  1.00  2.00           C  
ATOM   1970  CD1 ILE B 146      34.109 105.944   6.488  1.00  2.00           C  
ATOM   1971  N   ASN B 147      39.153 107.419   9.391  1.00  5.82           N  
ATOM   1972  CA  ASN B 147      40.152 108.405   9.824  1.00  6.33           C  
ATOM   1973  C   ASN B 147      40.302 109.513   8.826  1.00  7.69           C  
ATOM   1974  O   ASN B 147      39.742 109.424   7.713  1.00  8.05           O  
ATOM   1975  CB  ASN B 147      41.493 107.735  10.204  1.00  6.31           C  
ATOM   1976  CG  ASN B 147      42.260 107.187   9.020  1.00  3.68           C  
ATOM   1977  OD1 ASN B 147      41.986 107.540   7.902  1.00  7.30           O  
ATOM   1978  ND2 ASN B 147      43.246 106.352   9.276  1.00  2.00           N  
ATOM   1979  N   PRO B 148      40.999 110.607   9.218  1.00  8.93           N  
ATOM   1980  CA  PRO B 148      41.123 111.768   8.328  1.00  9.18           C  
ATOM   1981  C   PRO B 148      41.775 111.484   6.979  1.00 10.82           C  
ATOM   1982  O   PRO B 148      41.620 112.270   6.043  1.00 11.24           O  
ATOM   1983  CB  PRO B 148      41.944 112.761   9.178  1.00  8.65           C  
ATOM   1984  CG  PRO B 148      41.656 112.398  10.529  1.00  6.76           C  
ATOM   1985  CD  PRO B 148      41.623 110.894  10.527  1.00  7.84           C  
ATOM   1986  N   GLU B 149      42.453 110.347   6.879  1.00 12.65           N  
ATOM   1987  CA  GLU B 149      43.067 109.855   5.644  1.00 14.57           C  
ATOM   1988  C   GLU B 149      42.074 109.104   4.703  1.00 14.73           C  
ATOM   1989  O   GLU B 149      42.422 108.800   3.542  1.00 15.67           O  
ATOM   1990  CB  GLU B 149      44.242 108.923   6.005  1.00 14.89           C  
ATOM   1991  CG  GLU B 149      45.500 109.556   6.766  1.00 18.49           C  
ATOM   1992  CD  GLU B 149      45.261 109.938   8.261  1.00 24.72           C  
ATOM   1993  OE1 GLU B 149      44.517 109.255   9.012  1.00 27.07           O  
ATOM   1994  OE2 GLU B 149      45.831 110.946   8.716  1.00 28.43           O  
ATOM   1995  N   GLY B 150      40.861 108.808   5.194  1.00 14.08           N  
ATOM   1996  CA  GLY B 150      39.816 108.148   4.391  1.00 13.19           C  
ATOM   1997  C   GLY B 150      39.858 106.634   4.492  1.00 13.01           C  
ATOM   1998  O   GLY B 150      39.371 105.935   3.612  1.00 13.49           O  
ATOM   1999  N   LYS B 151      40.457 106.130   5.561  1.00 12.26           N  
ATOM   2000  CA  LYS B 151      40.587 104.701   5.765  1.00 12.58           C  
ATOM   2001  C   LYS B 151      39.688 104.284   6.898  1.00 12.26           C  
ATOM   2002  O   LYS B 151      39.543 105.018   7.881  1.00 12.62           O  
ATOM   2003  CB  LYS B 151      42.032 104.347   6.137  1.00 12.86           C  
ATOM   2004  CG  LYS B 151      43.086 105.020   5.254  1.00 15.73           C  
ATOM   2005  CD  LYS B 151      43.080 104.417   3.883  1.00 19.43           C  
ATOM   2006  CE  LYS B 151      44.334 104.795   3.127  1.00 24.51           C  
ATOM   2007  NZ  LYS B 151      44.382 106.280   2.843  1.00 26.15           N  
ATOM   2008  N   VAL B 152      39.098 103.107   6.763  1.00 11.21           N  
ATOM   2009  CA  VAL B 152      38.290 102.511   7.800  1.00 10.54           C  
ATOM   2010  C   VAL B 152      39.250 102.016   8.864  1.00 11.44           C  
ATOM   2011  O   VAL B 152      40.137 101.183   8.590  1.00 12.24           O  
ATOM   2012  CB  VAL B 152      37.407 101.308   7.238  1.00 10.06           C  
ATOM   2013  CG1 VAL B 152      36.571 100.633   8.351  1.00  7.69           C  
ATOM   2014  CG2 VAL B 152      36.482 101.793   6.123  1.00  8.51           C  
ATOM   2015  N   VAL B 153      39.101 102.515  10.081  1.00 11.69           N  
ATOM   2016  CA  VAL B 153      39.932 102.003  11.176  1.00 11.59           C  
ATOM   2017  C   VAL B 153      39.191 100.999  12.103  1.00 11.94           C  
ATOM   2018  O   VAL B 153      39.837 100.244  12.870  1.00 11.96           O  
ATOM   2019  CB  VAL B 153      40.746 103.156  11.873  1.00 10.62           C  
ATOM   2020  CG1 VAL B 153      41.288 104.056  10.808  1.00 12.73           C  
ATOM   2021  CG2 VAL B 153      39.935 103.997  12.753  1.00  9.76           C  
ATOM   2022  N   LYS B 154      37.857 100.959  12.012  1.00 11.69           N  
ATOM   2023  CA  LYS B 154      37.048 100.107  12.899  1.00 11.19           C  
ATOM   2024  C   LYS B 154      35.632  99.979  12.383  1.00 11.23           C  
ATOM   2025  O   LYS B 154      35.054 100.937  11.914  1.00 11.34           O  
ATOM   2026  CB  LYS B 154      37.069 100.667  14.339  1.00 11.28           C  
ATOM   2027  CG  LYS B 154      36.201  99.965  15.328  1.00 11.37           C  
ATOM   2028  CD  LYS B 154      36.934  99.457  16.517  1.00 11.35           C  
ATOM   2029  CE  LYS B 154      36.262  98.188  17.034  1.00 13.44           C  
ATOM   2030  NZ  LYS B 154      37.033  97.618  18.192  1.00 16.59           N  
ATOM   2031  N   VAL B 155      35.094  98.773  12.469  1.00 11.40           N  
ATOM   2032  CA  VAL B 155      33.737  98.497  12.077  1.00 11.62           C  
ATOM   2033  C   VAL B 155      33.007  98.076  13.369  1.00 11.87           C  
ATOM   2034  O   VAL B 155      33.465  97.200  14.084  1.00 11.48           O  
ATOM   2035  CB  VAL B 155      33.637  97.381  10.931  1.00 12.29           C  
ATOM   2036  CG1 VAL B 155      32.178  97.124  10.536  1.00 12.56           C  
ATOM   2037  CG2 VAL B 155      34.487  97.746   9.669  1.00 11.72           C  
ATOM   2038  N   VAL B 156      31.883  98.732  13.666  1.00 11.63           N  
ATOM   2039  CA  VAL B 156      31.119  98.468  14.877  1.00 11.49           C  
ATOM   2040  C   VAL B 156      29.730  97.967  14.565  1.00 11.95           C  
ATOM   2041  O   VAL B 156      28.940  98.628  13.885  1.00 11.64           O  
ATOM   2042  CB  VAL B 156      30.961  99.752  15.752  1.00 11.75           C  
ATOM   2043  CG1 VAL B 156      30.187  99.431  17.015  1.00  9.55           C  
ATOM   2044  CG2 VAL B 156      32.312 100.363  16.036  1.00 12.49           C  
ATOM   2045  N   THR B 157      29.429  96.797  15.086  1.00 13.42           N  
ATOM   2046  CA  THR B 157      28.103  96.246  14.966  1.00 15.73           C  
ATOM   2047  C   THR B 157      27.589  96.037  16.377  1.00 16.38           C  
ATOM   2048  O   THR B 157      28.358  96.088  17.344  1.00 16.85           O  
ATOM   2049  CB  THR B 157      28.083  94.903  14.167  1.00 16.46           C  
ATOM   2050  OG1 THR B 157      28.762  93.893  14.923  1.00 20.98           O  
ATOM   2051  CG2 THR B 157      28.763  95.033  12.805  1.00 16.13           C  
ATOM   2052  N   GLY B 158      26.298  95.814  16.537  1.00 16.93           N  
ATOM   2053  CA  GLY B 158      25.818  95.662  17.908  1.00 18.45           C  
ATOM   2054  C   GLY B 158      25.732  96.970  18.694  1.00 19.09           C  
ATOM   2055  O   GLY B 158      25.455  98.051  18.130  1.00 21.56           O  
ATOM   2056  N   THR B 159      25.914  96.907  19.998  1.00 18.32           N  
ATOM   2057  CA  THR B 159      25.352  97.975  20.831  1.00 17.41           C  
ATOM   2058  C   THR B 159      26.384  99.002  21.288  1.00 15.77           C  
ATOM   2059  O   THR B 159      27.435  98.625  21.802  1.00 15.64           O  
ATOM   2060  CB  THR B 159      24.569  97.391  22.036  1.00 17.86           C  
ATOM   2061  OG1 THR B 159      23.259  97.980  22.070  1.00 21.74           O  
ATOM   2062  CG2 THR B 159      25.303  97.633  23.350  1.00 21.28           C  
ATOM   2063  N   MET B 160      26.084 100.297  21.109  1.00 13.59           N  
ATOM   2064  CA  MET B 160      26.964 101.354  21.586  1.00 12.39           C  
ATOM   2065  C   MET B 160      26.392 102.119  22.747  1.00 10.92           C  
ATOM   2066  O   MET B 160      25.292 102.632  22.665  1.00 10.99           O  
ATOM   2067  CB  MET B 160      27.309 102.336  20.475  1.00 11.31           C  
ATOM   2068  CG  MET B 160      28.472 101.907  19.635  1.00 13.53           C  
ATOM   2069  SD  MET B 160      28.921 102.967  18.244  1.00 16.35           S  
ATOM   2070  CE  MET B 160      27.390 103.131  17.344  1.00 14.85           C  
ATOM   2071  N   THR B 161      27.177 102.234  23.811  1.00  9.64           N  
ATOM   2072  CA  THR B 161      26.874 103.149  24.892  1.00  9.10           C  
ATOM   2073  C   THR B 161      27.335 104.547  24.511  1.00  8.07           C  
ATOM   2074  O   THR B 161      28.033 104.717  23.525  1.00  7.98           O  
ATOM   2075  CB  THR B 161      27.521 102.671  26.210  1.00  9.63           C  
ATOM   2076  OG1 THR B 161      28.957 102.706  26.082  1.00 11.37           O  
ATOM   2077  CG2 THR B 161      27.034 101.217  26.557  1.00  6.24           C  
ATOM   2078  N   GLU B 162      26.935 105.558  25.258  1.00  7.38           N  
ATOM   2079  CA  GLU B 162      27.372 106.910  24.937  1.00  6.97           C  
ATOM   2080  C   GLU B 162      28.879 107.029  25.149  1.00  5.74           C  
ATOM   2081  O   GLU B 162      29.579 107.783  24.508  1.00  4.89           O  
ATOM   2082  CB  GLU B 162      26.579 107.950  25.743  1.00  6.58           C  
ATOM   2083  CG  GLU B 162      26.689 109.326  25.110  1.00  6.87           C  
ATOM   2084  CD  GLU B 162      26.136 110.417  25.953  1.00  8.74           C  
ATOM   2085  OE1 GLU B 162      25.595 110.164  27.064  1.00 12.86           O  
ATOM   2086  OE2 GLU B 162      26.262 111.558  25.500  1.00 11.77           O  
ATOM   2087  N   SER B 163      29.355 106.219  26.056  1.00  6.11           N  
ATOM   2088  CA  SER B 163      30.767 106.184  26.429  1.00  7.22           C  
ATOM   2089  C   SER B 163      31.614 105.641  25.263  1.00  6.64           C  
ATOM   2090  O   SER B 163      32.668 106.153  24.940  1.00  6.61           O  
ATOM   2091  CB  SER B 163      30.875 105.283  27.651  1.00  6.46           C  
ATOM   2092  OG  SER B 163      32.200 105.147  28.057  1.00 12.55           O  
ATOM   2093  N   MET B 164      31.103 104.589  24.628  1.00  6.70           N  
ATOM   2094  CA  MET B 164      31.720 103.991  23.482  1.00  7.20           C  
ATOM   2095  C   MET B 164      31.659 104.905  22.297  1.00  6.57           C  
ATOM   2096  O   MET B 164      32.619 104.997  21.568  1.00  6.94           O  
ATOM   2097  CB  MET B 164      31.034 102.690  23.136  1.00  8.36           C  
ATOM   2098  CG  MET B 164      31.318 101.479  24.066  1.00  9.09           C  
ATOM   2099  SD  MET B 164      30.186 100.066  23.687  1.00 12.45           S  
ATOM   2100  CE  MET B 164      30.529  99.592  22.012  1.00 12.41           C  
ATOM   2101  N   ILE B 165      30.532 105.571  22.080  1.00  6.05           N  
ATOM   2102  CA  ILE B 165      30.443 106.620  21.037  1.00  5.96           C  
ATOM   2103  C   ILE B 165      31.478 107.746  21.225  1.00  7.05           C  
ATOM   2104  O   ILE B 165      32.194 108.068  20.274  1.00  8.01           O  
ATOM   2105  CB  ILE B 165      28.991 107.213  20.896  1.00  6.49           C  
ATOM   2106  CG1 ILE B 165      28.010 106.108  20.404  1.00  5.90           C  
ATOM   2107  CG2 ILE B 165      28.993 108.463  20.079  1.00  2.00           C  
ATOM   2108  CD1 ILE B 165      26.512 106.416  20.632  1.00  3.95           C  
ATOM   2109  N   HIS B 166      31.552 108.327  22.432  1.00  7.01           N  
ATOM   2110  CA  HIS B 166      32.615 109.249  22.829  1.00  6.98           C  
ATOM   2111  C   HIS B 166      33.996 108.737  22.440  1.00  6.98           C  
ATOM   2112  O   HIS B 166      34.786 109.466  21.872  1.00  6.83           O  
ATOM   2113  CB  HIS B 166      32.582 109.522  24.357  1.00  6.97           C  
ATOM   2114  CG  HIS B 166      33.699 110.427  24.850  1.00  6.51           C  
ATOM   2115  ND1 HIS B 166      34.950 109.953  25.193  1.00  6.74           N  
ATOM   2116  CD2 HIS B 166      33.756 111.772  25.034  1.00  5.15           C  
ATOM   2117  CE1 HIS B 166      35.732 110.959  25.551  1.00  2.00           C  
ATOM   2118  NE2 HIS B 166      35.031 112.073  25.473  1.00  5.63           N  
ATOM   2119  N   ASP B 167      34.278 107.473  22.749  1.00  7.78           N  
ATOM   2120  CA  ASP B 167      35.631 106.917  22.573  1.00  7.33           C  
ATOM   2121  C   ASP B 167      35.928 106.686  21.141  1.00  7.40           C  
ATOM   2122  O   ASP B 167      37.043 106.891  20.706  1.00  8.20           O  
ATOM   2123  CB  ASP B 167      35.824 105.674  23.430  1.00  6.03           C  
ATOM   2124  CG  ASP B 167      35.919 106.024  24.939  1.00  6.90           C  
ATOM   2125  OD1 ASP B 167      35.933 107.227  25.312  1.00  8.65           O  
ATOM   2126  OD2 ASP B 167      35.955 105.114  25.777  1.00  8.91           O  
ATOM   2127  N   TYR B 168      34.904 106.322  20.384  1.00  7.69           N  
ATOM   2128  CA  TYR B 168      35.052 106.111  18.958  1.00  7.30           C  
ATOM   2129  C   TYR B 168      35.219 107.410  18.185  1.00  7.28           C  
ATOM   2130  O   TYR B 168      35.899 107.435  17.153  1.00  7.11           O  
ATOM   2131  CB  TYR B 168      33.854 105.377  18.430  1.00  7.96           C  
ATOM   2132  CG  TYR B 168      33.799 103.922  18.808  1.00  8.89           C  
ATOM   2133  CD1 TYR B 168      34.949 103.180  18.981  1.00  9.11           C  
ATOM   2134  CD2 TYR B 168      32.575 103.280  18.937  1.00  9.43           C  
ATOM   2135  CE1 TYR B 168      34.871 101.840  19.288  1.00  9.87           C  
ATOM   2136  CE2 TYR B 168      32.487 101.976  19.236  1.00  9.17           C  
ATOM   2137  CZ  TYR B 168      33.630 101.246  19.404  1.00 10.84           C  
ATOM   2138  OH  TYR B 168      33.509  99.896  19.712  1.00 16.10           O  
ATOM   2139  N   MET B 169      34.604 108.495  18.659  1.00  6.96           N  
ATOM   2140  CA  MET B 169      34.850 109.802  18.050  1.00  7.14           C  
ATOM   2141  C   MET B 169      36.264 110.296  18.382  1.00  8.33           C  
ATOM   2142  O   MET B 169      36.945 110.913  17.563  1.00  8.25           O  
ATOM   2143  CB  MET B 169      33.800 110.825  18.487  1.00  6.13           C  
ATOM   2144  CG  MET B 169      32.415 110.490  17.981  1.00  5.09           C  
ATOM   2145  SD  MET B 169      31.163 111.729  18.266  1.00  6.27           S  
ATOM   2146  CE  MET B 169      29.821 111.085  17.238  1.00  6.41           C  
ATOM   2147  N   ASN B 170      36.693 110.023  19.602  1.00  9.62           N  
ATOM   2148  CA  ASN B 170      38.051 110.254  19.978  1.00 11.04           C  
ATOM   2149  C   ASN B 170      39.105 109.554  19.079  1.00 10.68           C  
ATOM   2150  O   ASN B 170      40.127 110.127  18.707  1.00 11.28           O  
ATOM   2151  CB  ASN B 170      38.232 109.819  21.431  1.00 11.76           C  
ATOM   2152  CG  ASN B 170      39.407 110.509  22.037  1.00 18.03           C  
ATOM   2153  OD1 ASN B 170      39.424 111.748  22.046  1.00 21.73           O  
ATOM   2154  ND2 ASN B 170      40.462 109.738  22.438  1.00 20.29           N  
ATOM   2155  N   LEU B 171      38.848 108.284  18.785  1.00 10.50           N  
ATOM   2156  CA  LEU B 171      39.634 107.484  17.864  1.00 10.14           C  
ATOM   2157  C   LEU B 171      39.911 108.203  16.518  1.00 10.49           C  
ATOM   2158  O   LEU B 171      41.031 108.184  16.029  1.00 11.22           O  
ATOM   2159  CB  LEU B 171      38.947 106.121  17.639  1.00  8.53           C  
ATOM   2160  CG  LEU B 171      39.591 105.165  16.635  1.00  8.20           C  
ATOM   2161  CD1 LEU B 171      41.117 104.923  16.898  1.00  3.39           C  
ATOM   2162  CD2 LEU B 171      38.839 103.866  16.605  1.00  7.05           C  
ATOM   2163  N   ILE B 172      38.892 108.810  15.929  1.00  9.99           N  
ATOM   2164  CA  ILE B 172      38.975 109.284  14.558  1.00  9.63           C  
ATOM   2165  C   ILE B 172      39.200 110.786  14.417  1.00 10.20           C  
ATOM   2166  O   ILE B 172      39.363 111.260  13.305  1.00  9.70           O  
ATOM   2167  CB  ILE B 172      37.705 108.863  13.701  1.00  9.28           C  
ATOM   2168  CG1 ILE B 172      36.382 109.303  14.349  1.00  7.54           C  
ATOM   2169  CG2 ILE B 172      37.680 107.384  13.452  1.00 11.38           C  
ATOM   2170  CD1 ILE B 172      35.147 108.909  13.588  1.00  7.83           C  
ATOM   2171  N   LYS B 173      39.170 111.543  15.509  1.00 10.64           N  
ATOM   2172  CA  LYS B 173      39.327 112.998  15.352  1.00 12.26           C  
ATOM   2173  C   LYS B 173      40.752 113.357  14.916  1.00 12.98           C  
ATOM   2174  O   LYS B 173      41.702 112.704  15.339  1.00 11.99           O  
ATOM   2175  CB  LYS B 173      38.856 113.827  16.558  1.00 11.24           C  
ATOM   2176  CG  LYS B 173      39.640 113.593  17.789  1.00 10.76           C  
ATOM   2177  CD  LYS B 173      39.244 114.576  18.897  1.00 13.05           C  
ATOM   2178  CE  LYS B 173      40.157 114.370  20.073  1.00 16.41           C  
ATOM   2179  NZ  LYS B 173      40.033 115.544  20.938  1.00 18.50           N  
ATOM   2180  N   PRO B 174      40.840 114.344  13.995  1.00 13.80           N  
ATOM   2181  CA  PRO B 174      41.988 114.917  13.343  1.00 15.45           C  
ATOM   2182  C   PRO B 174      43.099 115.190  14.356  1.00 17.53           C  
ATOM   2183  O   PRO B 174      44.072 114.427  14.377  1.00 19.14           O  
ATOM   2184  CB  PRO B 174      41.439 116.203  12.715  1.00 15.42           C  
ATOM   2185  CG  PRO B 174      40.068 115.966  12.479  1.00 14.79           C  
ATOM   2186  CD  PRO B 174      39.598 114.977  13.517  1.00 13.42           C  
ATOM   2187  N   GLY B 175      43.016 116.183  15.232  1.00 18.20           N  
ATOM   2188  CA  GLY B 175      44.063 116.075  16.307  1.00 20.17           C  
ATOM   2189  C   GLY B 175      43.540 116.185  17.725  1.00 20.36           C  
ATOM   2190  O   GLY B 175      42.948 115.237  18.254  1.00 20.61           O  
ATOM   2191  N   GLU B 176      43.821 117.341  18.320  1.00 20.34           N  
ATOM   2192  CA  GLU B 176      43.085 117.894  19.427  1.00 22.11           C  
ATOM   2193  C   GLU B 176      42.914 119.348  19.089  1.00 20.99           C  
ATOM   2194  O   GLU B 176      43.883 120.004  18.844  1.00 22.29           O  
ATOM   2195  CB  GLU B 176      43.904 117.814  20.699  1.00 22.71           C  
ATOM   2196  CG  GLU B 176      44.284 116.422  21.069  1.00 29.61           C  
ATOM   2197  CD  GLU B 176      45.660 116.405  21.656  1.00 39.28           C  
ATOM   2198  OE1 GLU B 176      46.609 115.955  20.946  1.00 42.41           O  
ATOM   2199  OE2 GLU B 176      45.789 116.891  22.815  1.00 43.83           O  
ATOM   2200  N   THR B 177      41.703 119.857  19.080  1.00 20.21           N  
ATOM   2201  CA  THR B 177      41.481 121.230  18.698  1.00 19.46           C  
ATOM   2202  C   THR B 177      41.075 121.979  19.950  1.00 21.05           C  
ATOM   2203  O   THR B 177      40.315 121.446  20.748  1.00 21.35           O  
ATOM   2204  CB  THR B 177      40.372 121.346  17.586  1.00 19.09           C  
ATOM   2205  OG1 THR B 177      40.684 120.490  16.463  1.00 16.17           O  
ATOM   2206  CG2 THR B 177      40.209 122.742  17.118  1.00 14.81           C  
ATOM   2207  N   SER B 178      41.613 123.193  20.133  1.00 22.34           N  
ATOM   2208  CA  SER B 178      41.107 124.182  21.101  1.00 22.94           C  
ATOM   2209  C   SER B 178      39.688 124.571  20.719  1.00 24.59           C  
ATOM   2210  O   SER B 178      39.040 125.362  21.430  1.00 27.16           O  
ATOM   2211  CB  SER B 178      41.949 125.455  21.053  1.00 22.27           C  
ATOM   2212  OG  SER B 178      43.300 125.109  21.000  1.00 21.34           O  
TER    2213      SER B 178                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
