
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  186 ( 1437),  selected  186 , name 2f8a_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2f8a_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E       1           -
LGA    -       -      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    -       -      Q       6           -
LGA    S    -1_A      S       7          1.438
LGA    M     0_A      M       8          5.058
LGA    Q    12_A      I       9          2.127
LGA    S    13_A      N      10          2.660
LGA    -       -      S      11           -
LGA    V    14_A      F      12          0.736
LGA    Y    15_A      Y      13          2.202
LGA    A    16_A      A      14          2.321
LGA    F    17_A      F      15          0.993
LGA    S    18_A      E      16          1.500
LGA    A    19_A      V      17          1.019
LGA    R    20_A      K      18          1.364
LGA    P    21_A      D      19          1.225
LGA    L    22_A      A      20          0.830
LGA    A    23_A      K      21          2.379
LGA    G    24_A      G      22          2.615
LGA    G    25_A      R      23          1.900
LGA    E    26_A      T      24          2.941
LGA    P    27_A      -       -           -
LGA    V    28_A      V      25          1.764
LGA    S    29_A      S      26          1.421
LGA    L    30_A      L      27          1.432
LGA    G    31_A      E      28          1.796
LGA    S    32_A      K      29          2.112
LGA    L    33_A      Y      30          1.562
LGA    R    34_A      K      31          1.535
LGA    G    35_A      G      32          1.019
LGA    K    36_A      K      33          0.324
LGA    V    37_A      V      34          0.330
LGA    L    38_A      S      35          0.627
LGA    L    39_A      L      36          0.399
LGA    I    40_A      V      37          0.220
LGA    E    41_A      V      38          0.110
LGA    N    42_A      N      39          0.296
LGA    V    43_A      V      40          0.198
LGA    A    44_A      A      41          0.218
LGA    S    45_A      S      42          0.389
LGA    L    46_A      D      43          0.942
LGA    G    47_A      C      44          1.027
LGA    G    48_A      Q      45          1.188
LGA    T    49_A      L      46          1.167
LGA    T    50_A      T      47          0.739
LGA    V    51_A      D      48          0.759
LGA    R    52_A      R      49          0.816
LGA    D    53_A      N      50          0.843
LGA    Y    54_A      Y      51          0.674
LGA    T    55_A      L      52          0.901
LGA    Q    56_A      G      53          1.024
LGA    M    57_A      L      54          0.887
LGA    N    58_A      K      55          0.966
LGA    E    59_A      E      56          0.921
LGA    L    60_A      L      57          0.911
LGA    Q    61_A      H      58          0.813
LGA    R    62_A      K      59          0.931
LGA    R    63_A      E      60          0.930
LGA    L    64_A      F      61          0.289
LGA    G    65_A      G      62          0.622
LGA    P    66_A      P      63          4.704
LGA    R    67_A      S      64           #
LGA    G    68_A      H      65          0.659
LGA    L    69_A      F      66          0.776
LGA    V    70_A      S      67          1.014
LGA    V    71_A      V      68          0.801
LGA    L    72_A      L      69          0.283
LGA    G    73_A      A      70          0.047
LGA    F    74_A      F      71          0.107
LGA    P    75_A      P      72          0.319
LGA    C    76_A      C      73          0.184
LGA    N    77_A      N      74          0.149
LGA    Q    78_A      Q      75          0.253
LGA    F    79_A      F      76          0.328
LGA    G    80_A      G      77          0.367
LGA    H    81_A      E      78          0.297
LGA    Q    82_A      S      79          0.297
LGA    E    83_A      E      80          0.082
LGA    N    84_A      P      81          0.124
LGA    A    85_A      R      82          0.460
LGA    K    86_A      P      83          0.686
LGA    N    87_A      S      84          1.191
LGA    E    88_A      K      85          2.285
LGA    E    89_A      E      86          1.669
LGA    I    90_A      V      87          1.424
LGA    L    91_A      E      88          3.360
LGA    N    92_A      S      89          3.962
LGA    S    93_A      F      90          3.368
LGA    L    94_A      A      91          3.681
LGA    K    95_A      R      92          5.513
LGA    Y    96_A      K      93          5.944
LGA    V    97_A      N      94           #
LGA    R    98_A      -       -           -
LGA    P    99_A      -       -           -
LGA    G   100_A      -       -           -
LGA    G   101_A      -       -           -
LGA    G   102_A      -       -           -
LGA    F   103_A      Y      95          2.336
LGA    E   104_A      G      96          2.345
LGA    P   105_A      V      97          1.896
LGA    N   106_A      T      98          1.360
LGA    F   107_A      F      99          0.118
LGA    M   108_A      P     100          0.382
LGA    L   109_A      I     101          0.725
LGA    F   110_A      F     102          0.406
LGA    E   111_A      H     103          0.373
LGA    K   112_A      K     104          0.329
LGA    C   113_A      I     105          0.393
LGA    E   114_A      K     106          0.663
LGA    V   115_A      I     107          1.019
LGA    N   116_A      L     108          1.233
LGA    G   117_A      G     109          0.952
LGA    A   118_A      S     110          0.610
LGA    G   119_A      E     111          0.911
LGA    A   120_A      G     112          0.567
LGA    H   121_A      E     113          0.241
LGA    P   122_A      P     114          0.221
LGA    L   123_A      A     115          1.112
LGA    F   124_A      F     116          1.527
LGA    A   125_A      R     117          1.305
LGA    F   126_A      F     118          1.260
LGA    L   127_A      L     119          0.924
LGA    R   128_A      V     120          0.627
LGA    E   129_A      D     121          0.922
LGA    A   130_A      S     122          0.551
LGA    L   131_A      S     123          0.198
LGA    P   132_A      K     124          0.946
LGA    A   133_A      K     125          3.085
LGA    P   134_A      -       -           -
LGA    S   135_A      -       -           -
LGA    D   136_A      -       -           -
LGA    D   137_A      -       -           -
LGA    A   138_A      -       -           -
LGA    T   139_A      -       -           -
LGA    A   140_A      -       -           -
LGA    L   141_A      -       -           -
LGA    M   142_A      -       -           -
LGA    T   143_A      -       -           -
LGA    D   144_A      -       -           -
LGA    P   145_A      -       -           -
LGA    K   146_A      -       -           -
LGA    L   147_A      -       -           -
LGA    I   148_A      -       -           -
LGA    T   149_A      -       -           -
LGA    W   150_A      -       -           -
LGA    S   151_A      -       -           -
LGA    P   152_A      -       -           -
LGA    V   153_A      -       -           -
LGA    C   154_A      -       -           -
LGA    R   155_A      -       -           -
LGA    N   156_A      -       -           -
LGA    D   157_A      E     126          2.394
LGA    V   158_A      P     127          0.983
LGA    A   159_A      R     128          0.554
LGA    W   160_A      W     129          0.289
LGA    N   161_A      N     130          0.218
LGA    F   162_A      F     131          0.282
LGA    E   163_A      W     132          0.184
LGA    K   164_A      K     133          0.232
LGA    F   165_A      Y     134          0.362
LGA    L   166_A      L     135          0.052
LGA    V   167_A      V     136          0.550
LGA    G   168_A      N     137          0.484
LGA    P   169_A      P     138          0.501
LGA    D   170_A      E     139          0.677
LGA    G   171_A      G     140          0.721
LGA    V   172_A      Q     141          0.796
LGA    P   173_A      V     142          0.733
LGA    L   174_A      V     143          0.482
LGA    R   175_A      K     144          0.652
LGA    R   176_A      F     145          0.981
LGA    Y   177_A      W     146          0.786
LGA    S   178_A      R     147          0.596
LGA    R   179_A      P     148          1.603
LGA    R   180_A      E     149          0.980
LGA    F   181_A      E     150          1.239
LGA    Q   182_A      P     151          2.429
LGA    T   183_A      I     152          3.924
LGA    I   184_A      E     153          4.824
LGA    D   185_A      V     154          2.783
LGA    I   186_A      I     155          0.806
LGA    E   187_A      R     156          0.798
LGA    P   188_A      P     157          0.313
LGA    D   189_A      D     158          0.450
LGA    I   190_A      I     159          0.863
LGA    E   191_A      A     160          1.128
LGA    A   192_A      A     161          1.211
LGA    L   193_A      L     162          0.911
LGA    L   194_A      V     163          1.304
LGA    S   195_A      R     164          1.770
LGA    -       -      Q     165           -
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  186  174    5.0    155    1.61    36.77     83.969     9.083

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.710206 * X  +  -0.124432 * Y  +   0.692910 * Z  +   3.771472
  Y_new =   0.608367 * X  +  -0.386806 * Y  +  -0.693015 * Z  + 128.021851
  Z_new =   0.354255 * X  +   0.913727 * Y  +  -0.199011 * Z  +  -0.764568 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.785249   -1.356344  [ DEG:   102.2872    -77.7128 ]
  Theta =  -0.362118   -2.779475  [ DEG:   -20.7478   -159.2522 ]
  Phi   =   0.708318   -2.433275  [ DEG:    40.5836   -139.4164 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f8a_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f8a_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  186  174   5.0  155   1.61   36.77  83.969
REMARK  ---------------------------------------------------------- 
MOLECULE 2f8a_A
HEADER    OXIDOREDUCTASE                          02-DEC-05   2F8A              
TITLE     CRYSTAL STRUCTURE OF THE SELENOCYSTEINE TO GLYCINE MUTANT             
TITLE    2 OF HUMAN GLUTATHIONE PEROXIDASE 1                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLUTATHIONE PEROXIDASE 1;                                  
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: RESIDUES 12-196;                                           
COMPND   5 SYNONYM: GSHPX-1, GPX-1, CELLULAR GLUTATHIONE PEROXIDASE;            
COMPND   6 EC: 1.11.1.9;                                                        
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: GPX1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET DERIVATIVE                            
KEYWDS    THIOREDOXIN FOLD, STRUCTURAL GENOMICS, STRUCTURAL GENOMICS            
KEYWDS   2 CONSORTIUM, SGC                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.L.KAVANAGH,C.JOHANSSON,C.SMEE,O.GILEADI,F.VON DELFT,                
AUTHOR   2 C.J.WEIGELT,M.SUNDSTROM,A.EDWARDS,U.OPPERMANN,STRUCTURAL             
AUTHOR   3 GENOMICS CONSORTIUM (SGC)                                            
REVDAT   1   13-DEC-05 2F8A    0                                                
JRNL        AUTH   K.L.KAVANAGH,C.JOHANSSON,C.SMEE,O.GILEADI,                   
JRNL        AUTH 2 F.VON DELFT,U.OPPERMANN                                      
JRNL        TITL   CRYSTAL STRUCTURE OF THE SELENOCYSTEINE TO GLYCINE           
JRNL        TITL 2 MUTANT OF HUMAN GLUTATHIONE PEROXIDASE 1                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2F8A A   12   196  UNP    P07203   GPX1_HUMAN      12    196             
DBREF  2F8A B   12   196  UNP    P07203   GPX1_HUMAN      12    196             
SEQRES   1 A  208  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  208  GLY THR GLU ASN LEU TYR PHE GLN SER MET GLN SER VAL          
SEQRES   3 A  208  TYR ALA PHE SER ALA ARG PRO LEU ALA GLY GLY GLU PRO          
SEQRES   4 A  208  VAL SER LEU GLY SER LEU ARG GLY LYS VAL LEU LEU ILE          
SEQRES   5 A  208  GLU ASN VAL ALA SER LEU GLY GLY THR THR VAL ARG ASP          
SEQRES   6 A  208  TYR THR GLN MET ASN GLU LEU GLN ARG ARG LEU GLY PRO          
SEQRES   7 A  208  ARG GLY LEU VAL VAL LEU GLY PHE PRO CYS ASN GLN PHE          
SEQRES   8 A  208  GLY HIS GLN GLU ASN ALA LYS ASN GLU GLU ILE LEU ASN          
SEQRES   9 A  208  SER LEU LYS TYR VAL ARG PRO GLY GLY GLY PHE GLU PRO          
SEQRES  10 A  208  ASN PHE MET LEU PHE GLU LYS CYS GLU VAL ASN GLY ALA          
SEQRES  11 A  208  GLY ALA HIS PRO LEU PHE ALA PHE LEU ARG GLU ALA LEU          
SEQRES  12 A  208  PRO ALA PRO SER ASP ASP ALA THR ALA LEU MET THR ASP          
SEQRES  13 A  208  PRO LYS LEU ILE THR TRP SER PRO VAL CYS ARG ASN ASP          
SEQRES  14 A  208  VAL ALA TRP ASN PHE GLU LYS PHE LEU VAL GLY PRO ASP          
SEQRES  15 A  208  GLY VAL PRO LEU ARG ARG TYR SER ARG ARG PHE GLN THR          
SEQRES  16 A  208  ILE ASP ILE GLU PRO ASP ILE GLU ALA LEU LEU SER GLN          
SEQRES   1 B  208  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 B  208  GLY THR GLU ASN LEU TYR PHE GLN SER MET GLN SER VAL          
SEQRES   3 B  208  TYR ALA PHE SER ALA ARG PRO LEU ALA GLY GLY GLU PRO          
SEQRES   4 B  208  VAL SER LEU GLY SER LEU ARG GLY LYS VAL LEU LEU ILE          
SEQRES   5 B  208  GLU ASN VAL ALA SER LEU GLY GLY THR THR VAL ARG ASP          
SEQRES   6 B  208  TYR THR GLN MET ASN GLU LEU GLN ARG ARG LEU GLY PRO          
SEQRES   7 B  208  ARG GLY LEU VAL VAL LEU GLY PHE PRO CYS ASN GLN PHE          
SEQRES   8 B  208  GLY HIS GLN GLU ASN ALA LYS ASN GLU GLU ILE LEU ASN          
SEQRES   9 B  208  SER LEU LYS TYR VAL ARG PRO GLY GLY GLY PHE GLU PRO          
SEQRES  10 B  208  ASN PHE MET LEU PHE GLU LYS CYS GLU VAL ASN GLY ALA          
SEQRES  11 B  208  GLY ALA HIS PRO LEU PHE ALA PHE LEU ARG GLU ALA LEU          
SEQRES  12 B  208  PRO ALA PRO SER ASP ASP ALA THR ALA LEU MET THR ASP          
SEQRES  13 B  208  PRO LYS LEU ILE THR TRP SER PRO VAL CYS ARG ASN ASP          
SEQRES  14 B  208  VAL ALA TRP ASN PHE GLU LYS PHE LEU VAL GLY PRO ASP          
SEQRES  15 B  208  GLY VAL PRO LEU ARG ARG TYR SER ARG ARG PHE GLN THR          
SEQRES  16 B  208  ILE ASP ILE GLU PRO ASP ILE GLU ALA LEU LEU SER GLN          
HET    MLA    501       7                                                       
HET    MLA    502       7                                                       
HETNAM     MLA MALONIC ACID                                                     
HETSYN     MLA DICARBOXYLIC ACID C3; PROPANEDIOLIC ACID;                        
HETSYN   2 MLA  METAHNEDICARBOXYLIC ACID                                        
FORMUL   3  MLA    2(C3 H4 O4)                                                  
FORMUL   5  HOH   *409(H2 O)                                                    
CRYST1  127.592   59.376   81.132  90.00 119.41  90.00 C 1 2 1       8          
ATOM      1  N   SER A  -1      45.538 101.324  -5.656  1.00 51.74           N  
ATOM      2  CA  SER A  -1      44.322 100.570  -6.095  1.00 52.26           C  
ATOM      3  C   SER A  -1      43.205 100.490  -5.051  1.00 48.97           C  
ATOM      4  O   SER A  -1      42.085 100.087  -5.375  1.00 48.77           O  
ATOM      5  CB  SER A  -1      44.689  99.148  -6.515  1.00 53.61           C  
ATOM      6  OG  SER A  -1      43.606  98.543  -7.212  1.00 61.77           O  
ATOM      7  N   MET A   0      43.502 100.846  -3.804  1.00 44.78           N  
ATOM      8  CA  MET A   0      42.471 100.883  -2.777  1.00 38.92           C  
ATOM      9  C   MET A   0      41.861 102.283  -2.728  1.00 28.47           C  
ATOM     10  O   MET A   0      42.573 103.265  -2.506  1.00 28.61           O  
ATOM     11  CB  MET A   0      43.054 100.522  -1.407  1.00 45.31           C  
ATOM     12  N   GLN A  12      40.541 102.357  -2.896  1.00 25.26           N  
ATOM     13  CA  GLN A  12      39.843 103.617  -2.716  1.00 18.84           C  
ATOM     14  C   GLN A  12      39.778 104.028  -1.244  1.00 20.09           C  
ATOM     15  O   GLN A  12      40.044 103.222  -0.347  1.00 18.71           O  
ATOM     16  CB  GLN A  12      38.444 103.531  -3.364  1.00 18.43           C  
ATOM     17  CG  GLN A  12      38.564 103.560  -4.886  1.00 20.99           C  
ATOM     18  CD  GLN A  12      37.252 103.366  -5.625  1.00 20.29           C  
ATOM     19  OE1 GLN A  12      36.345 102.680  -5.147  1.00 23.46           O  
ATOM     20  NE2 GLN A  12      37.158 103.945  -6.823  1.00 23.34           N  
ATOM     21  N   SER A  13      39.444 105.299  -1.010  1.00 17.17           N  
ATOM     22  CA  SER A  13      39.045 105.839   0.274  1.00 15.14           C  
ATOM     23  C   SER A  13      37.562 106.236   0.222  1.00 13.91           C  
ATOM     24  O   SER A  13      36.926 106.209  -0.852  1.00 15.96           O  
ATOM     25  CB  SER A  13      39.860 107.076   0.611  1.00 17.34           C  
ATOM     26  OG  SER A  13      39.351 108.240  -0.053  1.00 15.37           O  
ATOM     27  N   VAL A  14      36.986 106.631   1.366  1.00 16.07           N  
ATOM     28  CA  VAL A  14      35.592 107.046   1.352  1.00 16.07           C  
ATOM     29  C   VAL A  14      35.373 108.294   0.511  1.00 14.14           C  
ATOM     30  O   VAL A  14      34.246 108.580   0.115  1.00 15.19           O  
ATOM     31  CB  VAL A  14      34.974 107.258   2.743  1.00 20.80           C  
ATOM     32  CG1 VAL A  14      35.060 105.979   3.573  1.00 20.94           C  
ATOM     33  CG2 VAL A  14      35.605 108.449   3.442  1.00 17.63           C  
ATOM     34  N   TYR A  15      36.448 109.013   0.204  1.00 15.67           N  
ATOM     35  CA  TYR A  15      36.320 110.272  -0.527  1.00 15.68           C  
ATOM     36  C   TYR A  15      35.918 110.081  -1.986  1.00 15.12           C  
ATOM     37  O   TYR A  15      35.615 111.053  -2.686  1.00 15.88           O  
ATOM     38  CB  TYR A  15      37.626 111.076  -0.421  1.00 15.39           C  
ATOM     39  CG  TYR A  15      38.065 111.389   0.986  1.00 16.41           C  
ATOM     40  CD1 TYR A  15      37.136 111.654   1.985  1.00 15.07           C  
ATOM     41  CD2 TYR A  15      39.418 111.451   1.320  1.00 21.28           C  
ATOM     42  CE1 TYR A  15      37.534 111.950   3.283  1.00 16.28           C  
ATOM     43  CE2 TYR A  15      39.829 111.741   2.627  1.00 20.77           C  
ATOM     44  CZ  TYR A  15      38.876 111.990   3.604  1.00 16.79           C  
ATOM     45  OH  TYR A  15      39.302 112.290   4.895  1.00 22.54           O  
ATOM     46  N   ALA A  16      35.929 108.837  -2.456  1.00 14.00           N  
ATOM     47  CA  ALA A  16      35.468 108.528  -3.801  1.00 13.67           C  
ATOM     48  C   ALA A  16      33.970 108.679  -3.939  1.00 14.75           C  
ATOM     49  O   ALA A  16      33.479 108.736  -5.075  1.00 17.07           O  
ATOM     50  CB  ALA A  16      35.853 107.085  -4.194  1.00 15.61           C  
ATOM     51  N   PHE A  17      33.254 108.774  -2.819  1.00 15.88           N  
ATOM     52  CA  PHE A  17      31.794 108.631  -2.811  1.00 15.39           C  
ATOM     53  C   PHE A  17      31.056 109.901  -2.428  1.00 15.48           C  
ATOM     54  O   PHE A  17      31.614 110.780  -1.772  1.00 17.75           O  
ATOM     55  CB  PHE A  17      31.407 107.467  -1.900  1.00 17.29           C  
ATOM     56  CG  PHE A  17      32.127 106.222  -2.255  1.00 15.22           C  
ATOM     57  CD1 PHE A  17      31.830 105.560  -3.436  1.00 21.91           C  
ATOM     58  CD2 PHE A  17      33.165 105.768  -1.481  1.00 14.45           C  
ATOM     59  CE1 PHE A  17      32.548 104.444  -3.839  1.00 17.96           C  
ATOM     60  CE2 PHE A  17      33.907 104.664  -1.886  1.00 14.83           C  
ATOM     61  CZ  PHE A  17      33.577 103.989  -3.049  1.00 16.55           C  
ATOM     62  N   SER A  18      29.804 109.978  -2.885  1.00 18.63           N  
ATOM     63  CA  SER A  18      28.936 111.119  -2.613  0.50 18.50           C  
ATOM     65  C   SER A  18      27.538 110.635  -2.263  1.00 17.22           C  
ATOM     66  O   SER A  18      27.170 109.512  -2.588  1.00 19.32           O  
ATOM     67  CB  SER A  18      28.846 112.026  -3.831  0.50 22.27           C  
ATOM     69  OG  SER A  18      28.265 111.345  -4.923  0.50 20.12           O  
ATOM     71  N   ALA A  19      26.767 111.498  -1.618  1.00 17.16           N  
ATOM     72  CA  ALA A  19      25.393 111.171  -1.270  1.00 20.40           C  
ATOM     73  C   ALA A  19      24.565 112.440  -1.186  1.00 19.91           C  
ATOM     74  O   ALA A  19      25.085 113.517  -0.922  1.00 19.78           O  
ATOM     75  CB  ALA A  19      25.347 110.410   0.052  1.00 18.57           C  
ATOM     76  N   ARG A  20      23.265 112.298  -1.436  1.00 20.11           N  
ATOM     77  CA  ARG A  20      22.357 113.434  -1.454  1.00 19.21           C  
ATOM     78  C   ARG A  20      21.818 113.675  -0.054  1.00 17.76           C  
ATOM     79  O   ARG A  20      21.368 112.739   0.575  1.00 17.37           O  
ATOM     80  CB  ARG A  20      21.191 113.172  -2.401  1.00 22.66           C  
ATOM     81  CG  ARG A  20      21.567 113.103  -3.880  1.00 34.83           C  
ATOM     82  CD  ARG A  20      20.339 112.876  -4.772  1.00 36.31           C  
ATOM     83  NE  ARG A  20      20.719 112.505  -6.143  1.00 45.90           N  
ATOM     84  CZ  ARG A  20      20.962 113.363  -7.133  1.00 44.30           C  
ATOM     85  NH1 ARG A  20      20.892 114.679  -6.956  1.00 37.54           N  
ATOM     86  N   PRO A  21      21.825 114.929   0.425  1.00 17.51           N  
ATOM     87  CA  PRO A  21      21.220 115.255   1.703  1.00 17.96           C  
ATOM     88  C   PRO A  21      19.749 114.866   1.752  1.00 17.86           C  
ATOM     89  O   PRO A  21      19.070 114.847   0.734  1.00 18.92           O  
ATOM     90  CB  PRO A  21      21.373 116.784   1.787  1.00 23.90           C  
ATOM     91  CG  PRO A  21      22.555 117.066   0.932  1.00 21.78           C  
ATOM     92  CD  PRO A  21      22.384 116.138  -0.218  1.00 21.30           C  
ATOM     93  N   LEU A  22      19.264 114.554   2.947  1.00 16.53           N  
ATOM     94  CA  LEU A  22      17.878 114.141   3.136  1.00 17.26           C  
ATOM     95  C   LEU A  22      16.856 115.089   2.497  1.00 23.12           C  
ATOM     96  O   LEU A  22      15.858 114.628   1.928  1.00 23.37           O  
ATOM     97  CB  LEU A  22      17.601 113.965   4.635  1.00 15.59           C  
ATOM     98  CG  LEU A  22      16.240 113.437   5.040  1.00 17.05           C  
ATOM     99  CD1 LEU A  22      16.021 112.000   4.606  1.00 19.26           C  
ATOM    100  CD2 LEU A  22      16.104 113.554   6.558  1.00 18.53           C  
ATOM    101  N   ALA A  23      17.113 116.387   2.590  1.00 24.23           N  
ATOM    102  CA  ALA A  23      16.206 117.391   2.028  1.00 29.27           C  
ATOM    103  C   ALA A  23      16.246 117.421   0.499  1.00 33.26           C  
ATOM    104  O   ALA A  23      15.416 118.077  -0.133  1.00 35.84           O  
ATOM    105  CB  ALA A  23      16.542 118.769   2.583  1.00 29.20           C  
ATOM    106  N   GLY A  24      17.218 116.733  -0.095  1.00 31.70           N  
ATOM    107  CA  GLY A  24      17.338 116.647  -1.548  1.00 30.32           C  
ATOM    108  C   GLY A  24      18.371 117.619  -2.085  1.00 32.51           C  
ATOM    109  O   GLY A  24      19.053 118.311  -1.327  1.00 35.13           O  
ATOM    110  N   GLY A  25      18.490 117.675  -3.403  1.00 38.34           N  
ATOM    111  CA  GLY A  25      19.421 118.608  -4.033  1.00 41.59           C  
ATOM    112  C   GLY A  25      20.754 117.972  -4.377  1.00 43.22           C  
ATOM    113  O   GLY A  25      20.830 116.766  -4.632  1.00 45.97           O  
ATOM    114  N   GLU A  26      21.806 118.789  -4.385  1.00 44.12           N  
ATOM    115  CA  GLU A  26      23.093 118.393  -4.954  1.00 41.82           C  
ATOM    116  C   GLU A  26      23.832 117.410  -4.048  1.00 37.45           C  
ATOM    117  O   GLU A  26      23.973 117.662  -2.854  1.00 41.45           O  
ATOM    118  CB  GLU A  26      23.975 119.627  -5.193  1.00 42.98           C  
ATOM    119  N   PRO A  27      24.311 116.297  -4.615  1.00 36.37           N  
ATOM    120  CA  PRO A  27      25.182 115.389  -3.872  1.00 34.72           C  
ATOM    121  C   PRO A  27      26.349 116.090  -3.178  1.00 35.69           C  
ATOM    122  O   PRO A  27      26.970 116.998  -3.738  1.00 39.51           O  
ATOM    123  CB  PRO A  27      25.693 114.434  -4.950  1.00 37.85           C  
ATOM    124  CG  PRO A  27      24.630 114.428  -5.980  1.00 39.58           C  
ATOM    125  CD  PRO A  27      24.033 115.798  -5.972  1.00 38.51           C  
ATOM    126  N   VAL A  28      26.610 115.681  -1.949  1.00 29.38           N  
ATOM    127  CA  VAL A  28      27.758 116.101  -1.187  1.00 25.87           C  
ATOM    128  C   VAL A  28      28.812 115.016  -1.344  1.00 25.28           C  
ATOM    129  O   VAL A  28      28.562 113.853  -1.021  1.00 22.81           O  
ATOM    130  CB  VAL A  28      27.403 116.204   0.302  1.00 28.02           C  
ATOM    131  CG1 VAL A  28      28.658 116.380   1.176  1.00 32.52           C  
ATOM    132  CG2 VAL A  28      26.389 117.312   0.531  1.00 34.38           C  
ATOM    133  N   SER A  29      29.993 115.389  -1.818  1.00 22.02           N  
ATOM    134  CA  SER A  29      31.100 114.460  -1.886  1.00 21.31           C  
ATOM    135  C   SER A  29      31.753 114.392  -0.535  1.00 23.52           C  
ATOM    136  O   SER A  29      32.001 115.419   0.102  1.00 24.90           O  
ATOM    137  CB  SER A  29      32.139 114.916  -2.893  1.00 21.47           C  
ATOM    138  OG  SER A  29      33.349 114.203  -2.672  1.00 23.63           O  
ATOM    139  N   LEU A  30      32.082 113.195  -0.087  1.00 20.52           N  
ATOM    140  CA  LEU A  30      32.736 113.056   1.200  0.50 20.12           C  
ATOM    142  C   LEU A  30      34.169 113.601   1.158  1.00 17.31           C  
ATOM    143  O   LEU A  30      34.771 113.837   2.199  1.00 16.40           O  
ATOM    144  CB  LEU A  30      32.703 111.604   1.651  0.50 19.35           C  
ATOM    146  CG  LEU A  30      31.271 111.066   1.763  0.50 17.03           C  
ATOM    148  CD1 LEU A  30      31.276 109.620   2.205  0.50 19.32           C  
ATOM    150  CD2 LEU A  30      30.447 111.946   2.717  0.50 18.16           C  
ATOM    152  N   GLY A  31      34.709 113.826  -0.052  1.00 19.15           N  
ATOM    153  CA  GLY A  31      36.044 114.395  -0.198  1.00 17.27           C  
ATOM    154  C   GLY A  31      36.206 115.768   0.404  1.00 16.29           C  
ATOM    155  O   GLY A  31      37.320 116.204   0.692  1.00 17.67           O  
ATOM    156  N   SER A  32      35.091 116.454   0.604  1.00 18.67           N  
ATOM    157  CA  SER A  32      35.113 117.752   1.268  1.00 19.12           C  
ATOM    158  C   SER A  32      35.410 117.633   2.787  1.00 19.50           C  
ATOM    159  O   SER A  32      35.643 118.639   3.454  1.00 19.70           O  
ATOM    160  CB  SER A  32      33.759 118.435   1.084  1.00 22.99           C  
ATOM    161  OG  SER A  32      32.746 117.731   1.769  1.00 29.97           O  
ATOM    162  N   LEU A  33      35.418 116.414   3.310  1.00 16.52           N  
ATOM    163  CA  LEU A  33      35.598 116.167   4.748  1.00 18.48           C  
ATOM    164  C   LEU A  33      37.013 115.729   5.112  1.00 16.23           C  
ATOM    165  O   LEU A  33      37.246 115.242   6.219  1.00 18.17           O  
ATOM    166  CB  LEU A  33      34.573 115.131   5.205  1.00 18.23           C  
ATOM    167  CG  LEU A  33      33.120 115.528   4.950  1.00 18.00           C  
ATOM    168  CD1 LEU A  33      32.184 114.361   5.334  1.00 19.79           C  
ATOM    169  CD2 LEU A  33      32.765 116.799   5.736  1.00 21.89           C  
ATOM    170  N   ARG A  34      37.979 115.934   4.210  1.00 14.28           N  
ATOM    171  CA  ARG A  34      39.348 115.532   4.525  1.00 16.10           C  
ATOM    172  C   ARG A  34      39.785 116.235   5.807  1.00 15.17           C  
ATOM    173  O   ARG A  34      39.499 117.412   6.003  1.00 17.01           O  
ATOM    174  CB  ARG A  34      40.310 115.840   3.381  1.00 16.36           C  
ATOM    175  CG  ARG A  34      41.707 115.279   3.596  1.00 14.94           C  
ATOM    176  CD  ARG A  34      42.594 115.525   2.367  1.00 17.31           C  
ATOM    177  NE  ARG A  34      41.984 114.984   1.157  1.00 17.82           N  
ATOM    178  CZ  ARG A  34      42.146 113.742   0.713  1.00 18.98           C  
ATOM    179  NH1 ARG A  34      42.968 112.887   1.328  1.00 21.63           N  
ATOM    180  NH2 ARG A  34      41.499 113.346  -0.373  1.00 19.81           N  
ATOM    181  N   GLY A  35      40.458 115.497   6.694  1.00 18.43           N  
ATOM    182  CA  GLY A  35      40.918 116.066   7.949  1.00 17.48           C  
ATOM    183  C   GLY A  35      39.995 115.761   9.102  1.00 18.33           C  
ATOM    184  O   GLY A  35      40.383 115.886  10.262  1.00 21.28           O  
ATOM    185  N   LYS A  36      38.761 115.392   8.789  1.00 15.38           N  
ATOM    186  CA  LYS A  36      37.767 115.064   9.812  1.00 16.78           C  
ATOM    187  C   LYS A  36      37.742 113.571  10.094  1.00 17.17           C  
ATOM    188  O   LYS A  36      37.973 112.750   9.208  1.00 17.38           O  
ATOM    189  CB  LYS A  36      36.373 115.475   9.367  1.00 17.77           C  
ATOM    190  CG  LYS A  36      36.193 116.938   8.997  1.00 21.41           C  
ATOM    191  CD  LYS A  36      36.312 117.845  10.187  1.00 22.55           C  
ATOM    192  CE  LYS A  36      35.845 119.245   9.831  1.00 31.69           C  
ATOM    193  NZ  LYS A  36      35.567 120.067  11.040  1.00 35.29           N  
ATOM    194  N   VAL A  37      37.428 113.209  11.338  1.00 15.12           N  
ATOM    195  CA  VAL A  37      37.139 111.826  11.679  1.00 14.71           C  
ATOM    196  C   VAL A  37      35.643 111.634  11.436  1.00 15.48           C  
ATOM    197  O   VAL A  37      34.842 112.483  11.845  1.00 15.96           O  
ATOM    198  CB  VAL A  37      37.480 111.542  13.157  1.00 14.69           C  
ATOM    199  CG1 VAL A  37      37.019 110.159  13.570  1.00 16.47           C  
ATOM    200  CG2 VAL A  37      38.968 111.679  13.363  1.00 15.79           C  
ATOM    201  N   LEU A  38      35.274 110.548  10.756  1.00 14.62           N  
ATOM    202  CA  LEU A  38      33.876 110.322  10.412  1.00 14.10           C  
ATOM    203  C   LEU A  38      33.339 109.135  11.172  1.00 15.32           C  
ATOM    204  O   LEU A  38      34.001 108.105  11.277  1.00 15.31           O  
ATOM    205  CB  LEU A  38      33.675 110.046   8.914  1.00 15.80           C  
ATOM    206  CG  LEU A  38      34.393 110.945   7.921  1.00 16.05           C  
ATOM    207  CD1 LEU A  38      34.030 110.537   6.460  1.00 16.34           C  
ATOM    208  CD2 LEU A  38      34.050 112.400   8.177  1.00 16.18           C  
ATOM    209  N   LEU A  39      32.135 109.283  11.700  1.00 16.67           N  
ATOM    210  CA  LEU A  39      31.374 108.170  12.245  1.00 16.43           C  
ATOM    211  C   LEU A  39      30.151 108.036  11.354  1.00 14.92           C  
ATOM    212  O   LEU A  39      29.291 108.931  11.326  1.00 15.26           O  
ATOM    213  CB  LEU A  39      30.956 108.455  13.699  1.00 15.65           C  
ATOM    214  CG  LEU A  39      30.038 107.375  14.284  1.00 19.22           C  
ATOM    215  CD1 LEU A  39      30.770 106.070  14.314  1.00 19.12           C  
ATOM    216  CD2 LEU A  39      29.587 107.763  15.697  1.00 18.11           C  
ATOM    217  N   ILE A  40      30.087 106.928  10.621  1.00 14.84           N  
ATOM    218  CA  ILE A  40      29.013 106.674   9.669  1.00 14.74           C  
ATOM    219  C   ILE A  40      28.109 105.581  10.233  1.00 16.76           C  
ATOM    220  O   ILE A  40      28.608 104.528  10.664  1.00 14.72           O  
ATOM    221  CB  ILE A  40      29.623 106.213   8.320  1.00 14.07           C  
ATOM    222  CG1 ILE A  40      30.428 107.329   7.653  1.00 15.85           C  
ATOM    223  CG2 ILE A  40      28.536 105.694   7.377  1.00 16.90           C  
ATOM    224  CD1 ILE A  40      31.294 106.871   6.469  1.00 17.88           C  
ATOM    225  N   GLU A  41      26.798 105.814  10.256  1.00 14.20           N  
ATOM    226  CA  GLU A  41      25.835 104.814  10.694  1.00 13.96           C  
ATOM    227  C   GLU A  41      24.717 104.710   9.685  1.00 14.21           C  
ATOM    228  O   GLU A  41      24.311 105.722   9.114  1.00 15.90           O  
ATOM    229  CB  GLU A  41      25.221 105.190  12.050  1.00 15.86           C  
ATOM    230  CG  GLU A  41      26.250 105.452  13.148  1.00 14.24           C  
ATOM    231  CD  GLU A  41      25.761 105.250  14.588  1.00 14.96           C  
ATOM    232  OE1 GLU A  41      24.696 104.638  14.790  1.00 17.54           O  
ATOM    233  OE2 GLU A  41      26.492 105.726  15.511  1.00 15.78           O  
ATOM    234  N   ASN A  42      24.230 103.494   9.470  1.00 13.69           N  
ATOM    235  CA  ASN A  42      22.944 103.300   8.801  1.00 13.47           C  
ATOM    236  C   ASN A  42      21.906 103.446   9.883  1.00 16.39           C  
ATOM    237  O   ASN A  42      22.016 102.830  10.942  1.00 15.00           O  
ATOM    238  CB  ASN A  42      22.840 101.947   8.092  1.00 14.18           C  
ATOM    239  CG  ASN A  42      23.050 100.776   9.003  1.00 14.60           C  
ATOM    240  OD1 ASN A  42      24.147 100.597   9.561  1.00 15.08           O  
ATOM    241  ND2 ASN A  42      22.032  99.911   9.099  1.00 14.94           N  
ATOM    242  N   VAL A  43      20.880 104.255   9.629  1.00 15.91           N  
ATOM    243  CA  VAL A  43      19.905 104.602  10.655  1.00 14.38           C  
ATOM    244  C   VAL A  43      18.486 104.165  10.283  1.00 15.13           C  
ATOM    245  O   VAL A  43      18.201 103.799   9.139  1.00 15.56           O  
ATOM    246  CB  VAL A  43      19.939 106.126  10.988  1.00 14.22           C  
ATOM    247  CG1 VAL A  43      21.384 106.544  11.418  1.00 16.64           C  
ATOM    248  CG2 VAL A  43      19.491 106.944   9.784  1.00 16.77           C  
ATOM    249  N   ALA A  44      17.591 104.201  11.272  1.00 15.56           N  
ATOM    250  CA  ALA A  44      16.170 103.926  11.053  1.00 14.48           C  
ATOM    251  C   ALA A  44      15.400 104.637  12.122  1.00 14.99           C  
ATOM    252  O   ALA A  44      15.917 104.809  13.214  1.00 16.27           O  
ATOM    253  CB  ALA A  44      15.903 102.454  11.144  1.00 16.31           C  
ATOM    254  N   SER A  45      14.145 104.973  11.823  1.00 16.01           N  
ATOM    255  CA  SER A  45      13.345 105.791  12.732  0.25 16.74           C  
ATOM    257  C   SER A  45      12.471 104.985  13.698  1.00 15.70           C  
ATOM    258  O   SER A  45      12.000 105.538  14.683  1.00 15.80           O  
ATOM    259  CB  SER A  45      12.490 106.803  11.952  0.25 18.32           C  
ATOM    261  OG  SER A  45      11.645 106.173  11.001  0.25 25.46           O  
ATOM    263  N   LEU A  46      12.232 103.692  13.396  1.00 15.14           N  
ATOM    264  CA  LEU A  46      11.383 102.859  14.265  1.00 14.59           C  
ATOM    265  C   LEU A  46      12.077 101.540  14.581  1.00 16.27           C  
ATOM    266  O   LEU A  46      11.503 100.440  14.481  1.00 17.53           O  
ATOM    267  CB  LEU A  46       9.984 102.663  13.663  1.00 15.46           C  
ATOM    268  CG  LEU A  46       9.124 103.931  13.581  1.00 16.54           C  
ATOM    269  CD1 LEU A  46       7.837 103.640  12.777  1.00 16.59           C  
ATOM    270  CD2 LEU A  46       8.750 104.445  14.951  1.00 16.67           C  
ATOM    271  N   GLY A  47      13.312 101.696  15.050  1.00 16.67           N  
ATOM    272  CA  GLY A  47      14.127 100.580  15.490  1.00 19.13           C  
ATOM    273  C   GLY A  47      14.282 100.546  17.003  1.00 18.11           C  
ATOM    274  O   GLY A  47      14.079 101.529  17.711  1.00 17.26           O  
ATOM    275  N   GLY A  48      14.643  99.367  17.504  1.00 18.02           N  
ATOM    276  CA  GLY A  48      14.854  99.174  18.911  1.00 18.38           C  
ATOM    277  C   GLY A  48      15.968 100.017  19.511  1.00 19.04           C  
ATOM    278  O   GLY A  48      15.962 100.274  20.732  1.00 20.31           O  
ATOM    279  N   THR A  49      16.922 100.454  18.682  1.00 15.36           N  
ATOM    280  CA  THR A  49      17.969 101.346  19.176  1.00 15.79           C  
ATOM    281  C   THR A  49      17.902 102.763  18.574  1.00 16.58           C  
ATOM    282  O   THR A  49      18.823 103.565  18.730  1.00 16.41           O  
ATOM    283  CB  THR A  49      19.390 100.766  19.004  1.00 17.31           C  
ATOM    284  OG1 THR A  49      19.760 100.817  17.619  1.00 16.56           O  
ATOM    285  CG2 THR A  49      19.460  99.327  19.544  1.00 18.93           C  
ATOM    286  N   THR A  50      16.792 103.112  17.920  1.00 15.42           N  
ATOM    287  CA  THR A  50      16.630 104.460  17.384  1.00 14.24           C  
ATOM    288  C   THR A  50      16.895 105.533  18.443  1.00 14.07           C  
ATOM    289  O   THR A  50      17.657 106.461  18.222  1.00 16.61           O  
ATOM    290  CB  THR A  50      15.214 104.630  16.784  1.00 14.24           C  
ATOM    291  OG1 THR A  50      15.087 103.820  15.611  1.00 15.61           O  
ATOM    292  CG2 THR A  50      14.891 106.090  16.437  1.00 15.47           C  
ATOM    293  N   VAL A  51      16.260 105.402  19.603  1.00 15.54           N  
ATOM    294  CA  VAL A  51      16.416 106.467  20.613  1.00 13.77           C  
ATOM    295  C   VAL A  51      17.870 106.517  21.115  1.00 16.53           C  
ATOM    296  O   VAL A  51      18.509 107.588  21.168  1.00 16.52           O  
ATOM    297  CB  VAL A  51      15.441 106.325  21.795  1.00 16.22           C  
ATOM    298  CG1 VAL A  51      15.737 107.413  22.833  1.00 16.36           C  
ATOM    299  CG2 VAL A  51      14.024 106.408  21.308  1.00 16.76           C  
ATOM    300  N   ARG A  52      18.395 105.352  21.502  1.00 16.10           N  
ATOM    301  CA  ARG A  52      19.730 105.274  22.050  1.00 14.94           C  
ATOM    302  C   ARG A  52      20.775 105.797  21.058  1.00 15.86           C  
ATOM    303  O   ARG A  52      21.626 106.626  21.428  1.00 15.97           O  
ATOM    304  CB  ARG A  52      20.046 103.838  22.446  1.00 18.52           C  
ATOM    305  CG  ARG A  52      21.289 103.700  23.292  1.00 23.14           C  
ATOM    306  CD  ARG A  52      21.468 102.239  23.688  1.00 27.44           C  
ATOM    307  NE  ARG A  52      22.039 101.474  22.590  1.00 24.26           N  
ATOM    308  CZ  ARG A  52      22.152 100.150  22.573  1.00 29.87           C  
ATOM    309  NH1 ARG A  52      21.681  99.415  23.579  1.00 37.27           N  
ATOM    310  NH2 ARG A  52      22.739  99.564  21.553  1.00 27.57           N  
ATOM    311  N   ASP A  53      20.730 105.335  19.805  1.00 15.69           N  
ATOM    312  CA  ASP A  53      21.747 105.752  18.856  1.00 16.44           C  
ATOM    313  C   ASP A  53      21.586 107.201  18.401  1.00 14.49           C  
ATOM    314  O   ASP A  53      22.587 107.916  18.270  1.00 15.23           O  
ATOM    315  CB  ASP A  53      21.820 104.780  17.684  1.00 15.65           C  
ATOM    316  CG  ASP A  53      22.503 103.487  18.079  1.00 17.30           C  
ATOM    317  OD1 ASP A  53      23.649 103.546  18.569  1.00 16.87           O  
ATOM    318  OD2 ASP A  53      21.890 102.421  17.925  1.00 17.05           O  
ATOM    319  N   TYR A  54      20.371 107.668  18.169  1.00 15.58           N  
ATOM    320  CA  TYR A  54      20.220 109.068  17.760  1.00 16.08           C  
ATOM    321  C   TYR A  54      20.653 110.012  18.889  1.00 15.27           C  
ATOM    322  O   TYR A  54      21.334 111.016  18.628  1.00 15.34           O  
ATOM    323  CB  TYR A  54      18.806 109.399  17.300  1.00 14.65           C  
ATOM    324  CG  TYR A  54      18.581 109.300  15.820  1.00 14.40           C  
ATOM    325  CD1 TYR A  54      18.964 110.326  14.986  1.00 15.90           C  
ATOM    326  CD2 TYR A  54      17.958 108.193  15.253  1.00 15.77           C  
ATOM    327  CE1 TYR A  54      18.746 110.257  13.638  1.00 15.94           C  
ATOM    328  CE2 TYR A  54      17.736 108.132  13.866  1.00 14.69           C  
ATOM    329  CZ  TYR A  54      18.117 109.175  13.072  1.00 17.16           C  
ATOM    330  OH  TYR A  54      17.879 109.147  11.705  1.00 17.74           O  
ATOM    331  N   THR A  55      20.285 109.676  20.125  1.00 15.19           N  
ATOM    332  CA  THR A  55      20.665 110.540  21.235  1.00 15.48           C  
ATOM    333  C   THR A  55      22.190 110.555  21.418  1.00 15.40           C  
ATOM    334  O   THR A  55      22.782 111.626  21.637  1.00 15.80           O  
ATOM    335  CB  THR A  55      19.923 110.182  22.526  1.00 19.76           C  
ATOM    336  OG1 THR A  55      20.219 108.862  22.928  1.00 26.08           O  
ATOM    337  CG2 THR A  55      18.438 110.316  22.354  1.00 17.31           C  
ATOM    338  N   GLN A  56      22.814 109.384  21.291  1.00 14.94           N  
ATOM    339  CA  GLN A  56      24.249 109.268  21.450  1.00 14.68           C  
ATOM    340  C   GLN A  56      25.016 109.901  20.276  1.00 14.47           C  
ATOM    341  O   GLN A  56      26.073 110.521  20.475  1.00 15.48           O  
ATOM    342  CB  GLN A  56      24.650 107.805  21.684  1.00 15.87           C  
ATOM    343  CG  GLN A  56      24.156 107.290  23.043  1.00 14.60           C  
ATOM    344  CD  GLN A  56      24.431 105.836  23.260  1.00 16.87           C  
ATOM    345  OE1 GLN A  56      25.056 105.173  22.430  1.00 17.01           O  
ATOM    346  NE2 GLN A  56      23.973 105.312  24.425  1.00 18.36           N  
ATOM    347  N   MET A  57      24.485 109.779  19.064  1.00 14.00           N  
ATOM    348  CA  MET A  57      25.101 110.461  17.930  1.00 15.35           C  
ATOM    349  C   MET A  57      25.067 111.971  18.106  1.00 15.21           C  
ATOM    350  O   MET A  57      26.047 112.651  17.848  1.00 16.23           O  
ATOM    351  CB  MET A  57      24.423 110.047  16.618  1.00 15.98           C  
ATOM    352  CG  MET A  57      24.888 108.686  16.131  1.00 14.12           C  
ATOM    353  SD  MET A  57      24.305 108.389  14.413  1.00 23.07           S  
ATOM    354  CE  MET A  57      22.881 107.830  14.889  1.00 14.24           C  
ATOM    355  N   ASN A  58      23.927 112.491  18.562  1.00 14.53           N  
ATOM    356  CA  ASN A  58      23.823 113.930  18.842  1.00 15.02           C  
ATOM    357  C   ASN A  58      24.852 114.350  19.904  1.00 15.96           C  
ATOM    358  O   ASN A  58      25.480 115.414  19.779  1.00 17.48           O  
ATOM    359  CB  ASN A  58      22.418 114.327  19.328  1.00 15.45           C  
ATOM    360  CG  ASN A  58      21.517 114.804  18.212  1.00 17.39           C  
ATOM    361  OD1 ASN A  58      21.717 114.478  17.042  1.00 17.07           O  
ATOM    362  ND2 ASN A  58      20.506 115.596  18.580  1.00 19.35           N  
ATOM    363  N   GLU A  59      25.026 113.530  20.940  1.00 16.32           N  
ATOM    364  CA  GLU A  59      25.956 113.844  22.017  0.50 16.68           C  
ATOM    366  C   GLU A  59      27.385 113.896  21.493  1.00 16.45           C  
ATOM    367  O   GLU A  59      28.137 114.814  21.784  1.00 17.56           O  
ATOM    368  CB  GLU A  59      25.830 112.802  23.129  0.50 16.70           C  
ATOM    370  CG  GLU A  59      26.664 113.078  24.372  0.50 21.32           C  
ATOM    372  CD  GLU A  59      26.221 114.322  25.129  0.50 28.87           C  
ATOM    374  OE1 GLU A  59      25.004 114.595  25.194  0.50 32.86           O  
ATOM    376  OE2 GLU A  59      27.093 115.026  25.672  0.50 30.30           O  
ATOM    378  N   LEU A  60      27.766 112.895  20.714  1.00 15.94           N  
ATOM    379  CA  LEU A  60      29.137 112.892  20.177  1.00 16.26           C  
ATOM    380  C   LEU A  60      29.358 114.073  19.233  1.00 18.58           C  
ATOM    381  O   LEU A  60      30.404 114.734  19.258  1.00 17.01           O  
ATOM    382  CB  LEU A  60      29.447 111.595  19.431  1.00 16.50           C  
ATOM    383  CG  LEU A  60      29.569 110.329  20.252  1.00 17.18           C  
ATOM    384  CD1 LEU A  60      29.816 109.137  19.342  1.00 22.05           C  
ATOM    385  CD2 LEU A  60      30.680 110.454  21.284  1.00 19.82           C  
ATOM    386  N   GLN A  61      28.371 114.346  18.389  1.00 16.03           N  
ATOM    387  CA  GLN A  61      28.530 115.426  17.426  1.00 17.03           C  
ATOM    388  C   GLN A  61      28.700 116.757  18.151  1.00 17.59           C  
ATOM    389  O   GLN A  61      29.514 117.579  17.747  1.00 18.37           O  
ATOM    390  CB  GLN A  61      27.343 115.512  16.472  1.00 16.17           C  
ATOM    391  CG  GLN A  61      27.515 116.589  15.388  1.00 17.47           C  
ATOM    392  CD  GLN A  61      28.666 116.301  14.453  1.00 19.47           C  
ATOM    393  OE1 GLN A  61      28.514 115.571  13.494  1.00 19.46           O  
ATOM    394  NE2 GLN A  61      29.837 116.841  14.755  1.00 20.89           N  
ATOM    395  N   ARG A  62      27.926 116.959  19.217  1.00 17.24           N  
ATOM    396  CA  ARG A  62      27.951 118.211  19.973  1.00 20.94           C  
ATOM    397  C   ARG A  62      29.288 118.388  20.680  1.00 18.17           C  
ATOM    398  O   ARG A  62      29.911 119.464  20.630  1.00 21.98           O  
ATOM    399  CB  ARG A  62      26.798 118.195  20.995  1.00 20.68           C  
ATOM    400  CG  ARG A  62      26.667 119.399  21.878  1.00 34.30           C  
ATOM    401  CD  ARG A  62      25.304 119.413  22.603  1.00 32.12           C  
ATOM    402  NE  ARG A  62      24.804 118.095  23.025  1.00 43.76           N  
ATOM    403  CZ  ARG A  62      23.738 117.457  22.516  1.00 43.44           C  
ATOM    404  NH1 ARG A  62      23.384 116.276  22.996  1.00 30.30           N  
ATOM    405  NH2 ARG A  62      23.013 117.967  21.529  1.00 48.85           N  
ATOM    406  N   ARG A  63      29.757 117.325  21.316  1.00 18.67           N  
ATOM    407  CA  ARG A  63      30.941 117.422  22.150  1.00 21.11           C  
ATOM    408  C   ARG A  63      32.237 117.354  21.361  1.00 19.13           C  
ATOM    409  O   ARG A  63      33.189 118.093  21.664  1.00 19.98           O  
ATOM    410  CB  ARG A  63      30.942 116.347  23.222  1.00 19.48           C  
ATOM    411  CG  ARG A  63      29.895 116.593  24.324  1.00 29.33           C  
ATOM    412  CD  ARG A  63      30.221 115.873  25.647  1.00 32.91           C  
ATOM    413  NE  ARG A  63      29.951 114.430  25.592  1.00 40.01           N  
ATOM    414  CZ  ARG A  63      30.813 113.505  25.162  1.00 46.48           C  
ATOM    415  NH1 ARG A  63      32.037 113.839  24.756  1.00 43.79           N  
ATOM    416  NH2 ARG A  63      30.448 112.223  25.145  1.00 30.64           N  
ATOM    417  N   LEU A  64      32.282 116.483  20.353  1.00 19.05           N  
ATOM    418  CA  LEU A  64      33.524 116.251  19.598  1.00 16.68           C  
ATOM    419  C   LEU A  64      33.562 116.910  18.224  1.00 18.82           C  
ATOM    420  O   LEU A  64      34.611 116.949  17.599  1.00 18.29           O  
ATOM    421  CB  LEU A  64      33.791 114.754  19.485  1.00 18.36           C  
ATOM    422  CG  LEU A  64      33.935 114.019  20.826  1.00 18.74           C  
ATOM    423  CD1 LEU A  64      34.090 112.501  20.618  1.00 20.81           C  
ATOM    424  CD2 LEU A  64      35.096 114.588  21.660  1.00 21.27           C  
ATOM    425  N   GLY A  65      32.444 117.457  17.770  1.00 18.19           N  
ATOM    426  CA  GLY A  65      32.416 118.207  16.519  1.00 19.46           C  
ATOM    427  C   GLY A  65      33.455 119.312  16.421  1.00 19.43           C  
ATOM    428  O   GLY A  65      34.190 119.398  15.433  1.00 19.95           O  
ATOM    429  N   PRO A  66      33.534 120.176  17.445  1.00 20.95           N  
ATOM    430  CA  PRO A  66      34.531 121.246  17.398  1.00 20.86           C  
ATOM    431  C   PRO A  66      35.972 120.763  17.299  1.00 20.20           C  
ATOM    432  O   PRO A  66      36.846 121.536  16.904  1.00 24.81           O  
ATOM    433  CB  PRO A  66      34.330 121.970  18.728  1.00 22.80           C  
ATOM    434  CG  PRO A  66      32.962 121.662  19.118  1.00 23.52           C  
ATOM    435  CD  PRO A  66      32.714 120.259  18.662  1.00 21.01           C  
ATOM    436  N   ARG A  67      36.230 119.514  17.662  1.00 18.42           N  
ATOM    437  CA  ARG A  67      37.555 118.934  17.563  1.00 17.53           C  
ATOM    438  C   ARG A  67      37.816 118.070  16.330  1.00 20.45           C  
ATOM    439  O   ARG A  67      38.903 117.499  16.190  1.00 21.87           O  
ATOM    440  CB  ARG A  67      37.831 118.136  18.817  1.00 21.32           C  
ATOM    441  CG  ARG A  67      37.968 119.050  20.031  1.00 28.61           C  
ATOM    442  CD  ARG A  67      38.171 118.235  21.265  1.00 28.41           C  
ATOM    443  NE  ARG A  67      39.338 117.384  21.087  1.00 31.09           N  
ATOM    444  CZ  ARG A  67      39.492 116.190  21.638  1.00 26.86           C  
ATOM    445  NH1 ARG A  67      38.541 115.686  22.417  1.00 28.78           N  
ATOM    446  NH2 ARG A  67      40.603 115.501  21.400  1.00 29.25           N  
ATOM    447  N   GLY A  68      36.822 117.951  15.454  1.00 18.77           N  
ATOM    448  CA  GLY A  68      37.026 117.298  14.164  1.00 17.02           C  
ATOM    449  C   GLY A  68      36.154 116.101  13.839  1.00 18.28           C  
ATOM    450  O   GLY A  68      36.340 115.500  12.793  1.00 19.24           O  
ATOM    451  N   LEU A  69      35.201 115.752  14.699  1.00 15.17           N  
ATOM    452  CA  LEU A  69      34.272 114.651  14.418  1.00 16.56           C  
ATOM    453  C   LEU A  69      33.125 115.119  13.549  1.00 15.50           C  
ATOM    454  O   LEU A  69      32.513 116.151  13.812  1.00 16.40           O  
ATOM    455  CB  LEU A  69      33.686 114.052  15.709  1.00 14.64           C  
ATOM    456  CG  LEU A  69      32.689 112.890  15.491  1.00 15.88           C  
ATOM    457  CD1 LEU A  69      33.358 111.690  14.795  1.00 15.87           C  
ATOM    458  CD2 LEU A  69      32.040 112.469  16.818  1.00 16.38           C  
ATOM    459  N   VAL A  70      32.804 114.327  12.524  1.00 15.25           N  
ATOM    460  CA  VAL A  70      31.587 114.513  11.745  1.00 14.28           C  
ATOM    461  C   VAL A  70      30.817 113.213  11.763  1.00 16.03           C  
ATOM    462  O   VAL A  70      31.353 112.175  11.359  1.00 15.88           O  
ATOM    463  CB  VAL A  70      31.907 114.938  10.274  1.00 14.98           C  
ATOM    464  CG1 VAL A  70      30.631 114.999   9.439  1.00 15.99           C  
ATOM    465  CG2 VAL A  70      32.632 116.307  10.238  1.00 16.98           C  
ATOM    466  N   VAL A  71      29.580 113.275  12.252  1.00 15.39           N  
ATOM    467  CA  VAL A  71      28.679 112.119  12.262  1.00 14.89           C  
ATOM    468  C   VAL A  71      27.786 112.185  11.004  1.00 15.30           C  
ATOM    469  O   VAL A  71      27.276 113.270  10.635  1.00 16.64           O  
ATOM    470  CB  VAL A  71      27.797 112.108  13.521  1.00 16.50           C  
ATOM    471  CG1 VAL A  71      26.867 110.898  13.491  1.00 17.48           C  
ATOM    472  CG2 VAL A  71      28.665 112.125  14.800  1.00 17.14           C  
ATOM    473  N   LEU A  72      27.640 111.048  10.324  1.00 15.78           N  
ATOM    474  CA  LEU A  72      26.876 110.968   9.085  1.00 15.78           C  
ATOM    475  C   LEU A  72      25.903 109.808   9.192  1.00 16.49           C  
ATOM    476  O   LEU A  72      26.322 108.695   9.462  1.00 16.85           O  
ATOM    477  CB  LEU A  72      27.813 110.714   7.905  1.00 16.71           C  
ATOM    478  CG  LEU A  72      28.916 111.737   7.634  1.00 17.74           C  
ATOM    479  CD1 LEU A  72      29.766 111.243   6.508  1.00 19.31           C  
ATOM    480  CD2 LEU A  72      28.278 113.100   7.312  1.00 17.98           C  
ATOM    481  N   GLY A  73      24.616 110.078   8.987  1.00 14.91           N  
ATOM    482  CA  GLY A  73      23.578 109.056   9.087  1.00 15.06           C  
ATOM    483  C   GLY A  73      22.912 108.770   7.754  1.00 14.97           C  
ATOM    484  O   GLY A  73      22.608 109.708   6.995  1.00 14.87           O  
ATOM    485  N   PHE A  74      22.750 107.474   7.463  1.00 14.72           N  
ATOM    486  CA  PHE A  74      22.195 107.007   6.209  1.00 15.58           C  
ATOM    487  C   PHE A  74      20.945 106.196   6.493  1.00 14.39           C  
ATOM    488  O   PHE A  74      21.051 105.042   6.874  1.00 15.11           O  
ATOM    489  CB  PHE A  74      23.228 106.177   5.417  1.00 14.94           C  
ATOM    490  CG  PHE A  74      24.370 106.985   4.895  1.00 15.80           C  
ATOM    491  CD1 PHE A  74      24.343 107.458   3.604  1.00 17.13           C  
ATOM    492  CD2 PHE A  74      25.459 107.300   5.707  1.00 17.69           C  
ATOM    493  CE1 PHE A  74      25.391 108.215   3.121  1.00 19.33           C  
ATOM    494  CE2 PHE A  74      26.496 108.071   5.237  1.00 18.49           C  
ATOM    495  CZ  PHE A  74      26.458 108.528   3.950  1.00 19.55           C  
ATOM    496  N   PRO A  75      19.745 106.787   6.349  1.00 14.27           N  
ATOM    497  CA  PRO A  75      18.507 106.021   6.536  1.00 14.92           C  
ATOM    498  C   PRO A  75      18.451 104.827   5.601  1.00 16.22           C  
ATOM    499  O   PRO A  75      18.821 104.940   4.431  1.00 15.21           O  
ATOM    500  CB  PRO A  75      17.418 107.044   6.209  1.00 14.95           C  
ATOM    501  CG  PRO A  75      18.070 108.415   6.459  1.00 16.44           C  
ATOM    502  CD  PRO A  75      19.477 108.196   6.005  1.00 16.58           C  
ATOM    503  N   CYS A  76      17.961 103.707   6.106  1.00 14.87           N  
ATOM    504  CA  CYS A  76      17.892 102.490   5.331  1.00 14.61           C  
ATOM    505  C   CYS A  76      16.717 101.641   5.809  1.00 15.42           C  
ATOM    506  O   CYS A  76      16.559 101.439   7.019  1.00 15.33           O  
ATOM    507  CB  CYS A  76      19.194 101.731   5.468  1.00 15.41           C  
ATOM    508  SG  CYS A  76      19.242 100.127   4.630  1.00 17.24           S  
ATOM    509  N   ASN A  77      15.936 101.119   4.846  1.00 14.61           N  
ATOM    510  CA  ASN A  77      14.736 100.362   5.136  1.00 14.42           C  
ATOM    511  C   ASN A  77      14.904  98.863   4.957  1.00 16.33           C  
ATOM    512  O   ASN A  77      13.908  98.152   4.818  1.00 16.22           O  
ATOM    513  CB  ASN A  77      13.597 100.849   4.231  1.00 14.35           C  
ATOM    514  CG  ASN A  77      12.234 100.514   4.779  1.00 15.75           C  
ATOM    515  OD1 ASN A  77      12.035 100.456   5.997  1.00 15.06           O  
ATOM    516  ND2 ASN A  77      11.260 100.302   3.880  1.00 16.13           N  
ATOM    517  N   GLN A  78      16.131  98.354   5.012  1.00 14.99           N  
ATOM    518  CA  GLN A  78      16.345  96.937   4.754  1.00 15.27           C  
ATOM    519  C   GLN A  78      16.232  96.017   5.958  1.00 15.70           C  
ATOM    520  O   GLN A  78      16.366  94.783   5.795  1.00 15.94           O  
ATOM    521  CB  GLN A  78      17.701  96.687   4.076  1.00 13.89           C  
ATOM    522  CG  GLN A  78      17.770  97.249   2.665  1.00 15.86           C  
ATOM    523  CD  GLN A  78      19.079  96.957   1.981  1.00 15.87           C  
ATOM    524  OE1 GLN A  78      20.138  97.409   2.443  1.00 16.94           O  
ATOM    525  NE2 GLN A  78      19.034  96.209   0.862  1.00 16.04           N  
ATOM    526  N   PHE A  79      15.988  96.555   7.155  1.00 14.51           N  
ATOM    527  CA  PHE A  79      16.069  95.789   8.403  1.00 15.25           C  
ATOM    528  C   PHE A  79      14.739  95.872   9.152  1.00 16.01           C  
ATOM    529  O   PHE A  79      14.491  96.805   9.930  1.00 16.54           O  
ATOM    530  CB  PHE A  79      17.258  96.299   9.227  1.00 16.48           C  
ATOM    531  CG  PHE A  79      18.523  96.301   8.435  1.00 16.73           C  
ATOM    532  CD1 PHE A  79      19.131  95.119   8.079  1.00 15.48           C  
ATOM    533  CD2 PHE A  79      19.064  97.483   7.985  1.00 16.92           C  
ATOM    534  CE1 PHE A  79      20.286  95.105   7.293  1.00 16.15           C  
ATOM    535  CE2 PHE A  79      20.193  97.506   7.168  1.00 15.67           C  
ATOM    536  CZ  PHE A  79      20.832  96.321   6.840  1.00 15.06           C  
ATOM    537  N   GLY A  80      13.866  94.906   8.875  1.00 16.18           N  
ATOM    538  CA  GLY A  80      12.535  94.918   9.489  1.00 15.67           C  
ATOM    539  C   GLY A  80      11.674  96.046   8.974  1.00 15.57           C  
ATOM    540  O   GLY A  80      10.703  96.460   9.652  1.00 15.17           O  
ATOM    541  N   HIS A  81      12.024  96.584   7.788  1.00 14.71           N  
ATOM    542  CA  HIS A  81      11.367  97.784   7.219  1.00 15.61           C  
ATOM    543  C   HIS A  81      11.203  98.875   8.294  1.00 13.73           C  
ATOM    544  O   HIS A  81      10.116  99.448   8.470  1.00 14.89           O  
ATOM    545  CB  HIS A  81      10.007  97.478   6.606  1.00 15.07           C  
ATOM    546  CG  HIS A  81       9.991  96.388   5.586  1.00 17.38           C  
ATOM    547  ND1 HIS A  81       9.638  95.102   5.913  1.00 17.28           N  
ATOM    548  CD2 HIS A  81      10.172  96.406   4.242  1.00 21.38           C  
ATOM    549  CE1 HIS A  81       9.644  94.355   4.814  1.00 19.52           C  
ATOM    550  NE2 HIS A  81       9.961  95.120   3.788  1.00 20.77           N  
ATOM    551  N   GLN A  82      12.298  99.199   8.987  1.00 13.76           N  
ATOM    552  CA  GLN A  82      12.206 100.130  10.114  1.00 14.67           C  
ATOM    553  C   GLN A  82      12.467 101.586   9.715  1.00 15.75           C  
ATOM    554  O   GLN A  82      12.543 102.479  10.546  1.00 15.94           O  
ATOM    555  CB  GLN A  82      13.038  99.630  11.293  1.00 16.85           C  
ATOM    556  CG  GLN A  82      12.341  98.444  11.924  1.00 16.02           C  
ATOM    557  CD  GLN A  82      13.067  97.752  13.049  1.00 17.42           C  
ATOM    558  OE1 GLN A  82      14.169  98.140  13.428  1.00 18.44           O  
ATOM    559  NE2 GLN A  82      12.427  96.689  13.583  1.00 18.63           N  
ATOM    560  N   GLU A  83      12.539 101.821   8.400  1.00 14.68           N  
ATOM    561  CA  GLU A  83      12.587 103.176   7.815  1.00 15.34           C  
ATOM    562  C   GLU A  83      11.583 103.254   6.676  1.00 14.55           C  
ATOM    563  O   GLU A  83      11.941 103.556   5.526  1.00 14.94           O  
ATOM    564  CB  GLU A  83      13.989 103.556   7.341  1.00 15.75           C  
ATOM    565  CG  GLU A  83      14.162 105.024   7.051  1.00 17.21           C  
ATOM    566  CD  GLU A  83      14.309 105.823   8.344  1.00 18.63           C  
ATOM    567  OE1 GLU A  83      13.286 105.970   9.057  1.00 18.71           O  
ATOM    568  OE2 GLU A  83      15.440 106.243   8.655  1.00 20.16           O  
ATOM    569  N   ASN A  84      10.306 103.028   6.978  1.00 15.34           N  
ATOM    570  CA  ASN A  84       9.253 103.053   5.955  1.00 14.86           C  
ATOM    571  C   ASN A  84       8.849 104.450   5.520  1.00 16.74           C  
ATOM    572  O   ASN A  84       8.312 104.627   4.407  1.00 20.66           O  
ATOM    573  CB  ASN A  84       7.990 102.306   6.394  1.00 14.05           C  
ATOM    574  CG  ASN A  84       8.045 100.811   6.102  1.00 16.78           C  
ATOM    575  OD1 ASN A  84       8.453 100.382   5.008  1.00 15.46           O  
ATOM    576  ND2 ASN A  84       7.553 100.005   7.061  1.00 17.24           N  
ATOM    577  N   ALA A  85       9.088 105.433   6.379  1.00 15.77           N  
ATOM    578  CA  ALA A  85       8.726 106.817   6.052  1.00 18.06           C  
ATOM    579  C   ALA A  85       9.526 107.310   4.847  1.00 16.80           C  
ATOM    580  O   ALA A  85      10.662 106.888   4.643  1.00 17.72           O  
ATOM    581  CB  ALA A  85       8.961 107.734   7.262  1.00 22.90           C  
ATOM    582  N   LYS A  86       8.928 108.224   4.099  1.00 16.46           N  
ATOM    583  CA  LYS A  86       9.592 108.866   2.958  1.00 17.17           C  
ATOM    584  C   LYS A  86      10.654 109.828   3.502  1.00 15.06           C  
ATOM    585  O   LYS A  86      10.605 110.273   4.651  1.00 15.58           O  
ATOM    586  CB  LYS A  86       8.577 109.632   2.123  1.00 18.48           C  
ATOM    587  CG  LYS A  86       7.494 108.755   1.492  1.00 19.72           C  
ATOM    588  CD  LYS A  86       6.493 109.571   0.697  1.00 27.61           C  
ATOM    589  CE  LYS A  86       5.413 108.671   0.082  1.00 40.71           C  
ATOM    590  NZ  LYS A  86       4.456 109.413  -0.808  1.00 46.86           N  
ATOM    591  N   ASN A  87      11.600 110.196   2.638  1.00 14.31           N  
ATOM    592  CA  ASN A  87      12.633 111.153   3.004  1.00 14.36           C  
ATOM    593  C   ASN A  87      12.029 112.386   3.647  1.00 15.58           C  
ATOM    594  O   ASN A  87      12.501 112.847   4.681  1.00 16.58           O  
ATOM    595  CB  ASN A  87      13.433 111.531   1.766  1.00 14.11           C  
ATOM    596  CG  ASN A  87      14.355 110.416   1.298  1.00 15.57           C  
ATOM    597  OD1 ASN A  87      14.915 109.684   2.098  1.00 16.47           O  
ATOM    598  ND2 ASN A  87      14.530 110.312  -0.019  1.00 16.62           N  
ATOM    599  N   GLU A  88      10.945 112.874   3.061  1.00 15.02           N  
ATOM    600  CA  GLU A  88      10.288 114.094   3.535  1.00 14.92           C  
ATOM    601  C   GLU A  88       9.504 113.971   4.850  1.00 15.00           C  
ATOM    602  O   GLU A  88       9.013 114.987   5.397  1.00 15.98           O  
ATOM    603  CB  GLU A  88       9.382 114.676   2.441  1.00 19.13           C  
ATOM    604  CG  GLU A  88       8.378 113.712   1.889  1.00 27.96           C  
ATOM    605  CD  GLU A  88       8.825 112.985   0.594  1.00 43.92           C  
ATOM    606  OE1 GLU A  88      10.010 112.531   0.423  1.00 22.91           O  
ATOM    607  OE2 GLU A  88       7.927 112.854  -0.267  1.00 52.01           O  
ATOM    608  N   GLU A  89       9.395 112.738   5.345  1.00 14.72           N  
ATOM    609  CA  GLU A  89       8.682 112.394   6.586  1.00 14.49           C  
ATOM    610  C   GLU A  89       9.608 112.080   7.749  1.00 15.09           C  
ATOM    611  O   GLU A  89       9.180 112.083   8.895  1.00 16.34           O  
ATOM    612  CB  GLU A  89       7.752 111.184   6.348  1.00 15.10           C  
ATOM    613  CG  GLU A  89       6.524 111.467   5.468  1.00 14.88           C  
ATOM    614  CD  GLU A  89       5.773 110.225   5.057  1.00 15.45           C  
ATOM    615  OE1 GLU A  89       6.417 109.160   4.943  1.00 17.63           O  
ATOM    616  OE2 GLU A  89       4.545 110.362   4.780  1.00 16.54           O  
ATOM    617  N   ILE A  90      10.873 111.768   7.462  1.00 14.93           N  
ATOM    618  CA  ILE A  90      11.764 111.235   8.507  1.00 14.99           C  
ATOM    619  C   ILE A  90      12.004 112.204   9.660  1.00 15.61           C  
ATOM    620  O   ILE A  90      11.884 111.820  10.834  1.00 15.19           O  
ATOM    621  CB  ILE A  90      13.098 110.715   7.913  1.00 14.92           C  
ATOM    622  CG1 ILE A  90      12.840 109.408   7.140  1.00 16.53           C  
ATOM    623  CG2 ILE A  90      14.170 110.513   9.029  1.00 16.39           C  
ATOM    624  CD1 ILE A  90      14.060 108.863   6.364  1.00 17.48           C  
ATOM    625  N   LEU A  91      12.291 113.468   9.366  1.00 15.08           N  
ATOM    626  CA  LEU A  91      12.538 114.424  10.457  1.00 15.58           C  
ATOM    627  C   LEU A  91      11.298 114.587  11.330  1.00 13.84           C  
ATOM    628  O   LEU A  91      11.401 114.684  12.561  1.00 15.55           O  
ATOM    629  CB  LEU A  91      12.990 115.780   9.934  1.00 15.80           C  
ATOM    630  CG  LEU A  91      14.385 115.812   9.309  1.00 18.66           C  
ATOM    631  CD1 LEU A  91      14.703 117.231   8.839  1.00 22.22           C  
ATOM    632  CD2 LEU A  91      15.465 115.300  10.280  1.00 18.97           C  
ATOM    633  N   ASN A  92      10.114 114.585  10.722  1.00 15.13           N  
ATOM    634  CA  ASN A  92       8.890 114.665  11.520  1.00 15.31           C  
ATOM    635  C   ASN A  92       8.737 113.436  12.418  1.00 15.00           C  
ATOM    636  O   ASN A  92       8.263 113.526  13.558  1.00 15.21           O  
ATOM    637  CB  ASN A  92       7.659 114.834  10.618  1.00 15.71           C  
ATOM    638  CG  ASN A  92       7.519 116.244  10.087  1.00 19.14           C  
ATOM    639  OD1 ASN A  92       8.100 117.197  10.640  1.00 17.83           O  
ATOM    640  ND2 ASN A  92       6.746 116.398   9.001  1.00 19.94           N  
ATOM    641  N   SER A  93       9.096 112.261  11.908  1.00 14.39           N  
ATOM    642  CA  SER A  93       8.975 111.064  12.743  1.00 15.51           C  
ATOM    643  C   SER A  93       9.906 111.168  13.941  1.00 15.34           C  
ATOM    644  O   SER A  93       9.532 110.813  15.075  1.00 15.73           O  
ATOM    645  CB  SER A  93       9.260 109.805  11.916  1.00 17.73           C  
ATOM    646  OG  SER A  93       8.865 108.643  12.641  1.00 18.10           O  
ATOM    647  N   LEU A  94      11.131 111.634  13.710  1.00 15.22           N  
ATOM    648  CA  LEU A  94      12.092 111.755  14.819  1.00 14.04           C  
ATOM    649  C   LEU A  94      11.624 112.795  15.830  1.00 14.43           C  
ATOM    650  O   LEU A  94      11.807 112.626  17.042  1.00 15.78           O  
ATOM    651  CB  LEU A  94      13.475 112.106  14.287  1.00 15.06           C  
ATOM    652  CG  LEU A  94      14.151 111.053  13.404  1.00 15.39           C  
ATOM    653  CD1 LEU A  94      15.402 111.651  12.716  1.00 17.02           C  
ATOM    654  CD2 LEU A  94      14.489 109.772  14.187  1.00 17.82           C  
ATOM    655  N   LYS A  95      11.038 113.888  15.345  1.00 15.57           N  
ATOM    656  CA  LYS A  95      10.644 115.013  16.208  1.00 15.10           C  
ATOM    657  C   LYS A  95       9.398 114.742  17.037  1.00 14.93           C  
ATOM    658  O   LYS A  95       9.295 115.181  18.202  1.00 16.77           O  
ATOM    659  CB  LYS A  95      10.425 116.266  15.349  1.00 16.19           C  
ATOM    660  CG  LYS A  95      10.133 117.540  16.121  1.00 19.68           C  
ATOM    661  CD  LYS A  95      10.199 118.735  15.193  1.00 20.68           C  
ATOM    662  CE  LYS A  95      10.009 120.035  15.916  1.00 36.09           C  
ATOM    663  NZ  LYS A  95      10.392 121.159  15.010  1.00 43.47           N  
ATOM    664  N   TYR A  96       8.429 114.052  16.420  1.00 15.94           N  
ATOM    665  CA  TYR A  96       7.102 113.908  17.013  1.00 15.49           C  
ATOM    666  C   TYR A  96       6.719 112.499  17.419  1.00 16.60           C  
ATOM    667  O   TYR A  96       5.736 112.343  18.148  1.00 17.30           O  
ATOM    668  CB  TYR A  96       6.042 114.426  16.041  1.00 18.31           C  
ATOM    669  CG  TYR A  96       6.159 115.885  15.727  1.00 18.36           C  
ATOM    670  CD1 TYR A  96       5.771 116.845  16.653  1.00 23.32           C  
ATOM    671  CD2 TYR A  96       6.646 116.308  14.504  1.00 17.06           C  
ATOM    672  CE1 TYR A  96       5.872 118.197  16.357  1.00 20.72           C  
ATOM    673  CE2 TYR A  96       6.737 117.658  14.189  1.00 20.09           C  
ATOM    674  CZ  TYR A  96       6.356 118.591  15.128  1.00 21.14           C  
ATOM    675  OH  TYR A  96       6.461 119.939  14.810  1.00 23.84           O  
ATOM    676  N   VAL A  97       7.444 111.492  16.930  1.00 15.25           N  
ATOM    677  CA  VAL A  97       7.105 110.082  17.232  1.00 14.69           C  
ATOM    678  C   VAL A  97       8.160 109.410  18.099  1.00 16.43           C  
ATOM    679  O   VAL A  97       7.902 109.107  19.268  1.00 17.87           O  
ATOM    680  CB  VAL A  97       6.829 109.263  15.957  1.00 15.98           C  
ATOM    681  CG1 VAL A  97       6.389 107.850  16.335  1.00 18.00           C  
ATOM    682  CG2 VAL A  97       5.782 109.978  15.083  1.00 16.91           C  
ATOM    683  N   ARG A  98       9.344 109.187  17.539  1.00 17.18           N  
ATOM    684  CA  ARG A  98      10.429 108.495  18.227  1.00 16.59           C  
ATOM    685  C   ARG A  98      11.758 109.055  17.695  1.00 14.43           C  
ATOM    686  O   ARG A  98      12.009 108.946  16.499  1.00 17.10           O  
ATOM    687  CB  ARG A  98      10.350 107.004  17.947  1.00 16.08           C  
ATOM    688  CG  ARG A  98      11.377 106.196  18.748  1.00 14.75           C  
ATOM    689  CD  ARG A  98      11.509 104.762  18.314  1.00 16.05           C  
ATOM    690  NE  ARG A  98      10.257 104.038  18.511  1.00 15.65           N  
ATOM    691  CZ  ARG A  98      10.134 102.736  18.264  1.00 16.36           C  
ATOM    692  NH1 ARG A  98      11.166 102.007  17.844  1.00 17.69           N  
ATOM    693  NH2 ARG A  98       8.961 102.158  18.474  1.00 19.86           N  
ATOM    694  N   PRO A  99      12.616 109.626  18.566  1.00 17.33           N  
ATOM    695  CA  PRO A  99      12.466 109.824  20.009  1.00 16.94           C  
ATOM    696  C   PRO A  99      11.270 110.673  20.404  1.00 19.00           C  
ATOM    697  O   PRO A  99      10.795 110.589  21.532  1.00 20.12           O  
ATOM    698  CB  PRO A  99      13.773 110.539  20.404  1.00 17.87           C  
ATOM    699  CG  PRO A  99      14.725 110.148  19.395  1.00 17.91           C  
ATOM    700  CD  PRO A  99      13.947 110.048  18.105  1.00 18.88           C  
ATOM    701  N   GLY A 100      10.790 111.498  19.486  1.00 15.60           N  
ATOM    702  CA  GLY A 100       9.722 112.427  19.816  1.00 17.22           C  
ATOM    703  C   GLY A 100      10.182 113.525  20.762  1.00 18.71           C  
ATOM    704  O   GLY A 100      11.381 113.746  20.971  1.00 17.89           O  
ATOM    705  N   GLY A 101       9.210 114.215  21.341  1.00 18.99           N  
ATOM    706  CA  GLY A 101       9.513 115.232  22.328  1.00 18.19           C  
ATOM    707  C   GLY A 101      10.287 116.414  21.773  1.00 18.67           C  
ATOM    708  O   GLY A 101      10.895 117.167  22.531  1.00 22.50           O  
ATOM    709  N   GLY A 102      10.265 116.619  20.460  1.00 15.62           N  
ATOM    710  CA  GLY A 102      10.942 117.746  19.832  1.00 14.71           C  
ATOM    711  C   GLY A 102      12.338 117.427  19.327  1.00 17.04           C  
ATOM    712  O   GLY A 102      13.038 118.310  18.858  1.00 18.39           O  
ATOM    713  N   PHE A 103      12.734 116.154  19.387  1.00 17.41           N  
ATOM    714  CA  PHE A 103      14.090 115.753  19.000  1.00 17.45           C  
ATOM    715  C   PHE A 103      14.442 116.145  17.562  1.00 19.42           C  
ATOM    716  O   PHE A 103      13.652 115.933  16.639  1.00 16.57           O  
ATOM    717  CB  PHE A 103      14.269 114.236  19.180  1.00 18.18           C  
ATOM    718  CG  PHE A 103      15.626 113.759  18.769  1.00 17.69           C  
ATOM    719  CD1 PHE A 103      16.680 113.765  19.670  1.00 19.19           C  
ATOM    720  CD2 PHE A 103      15.869 113.356  17.467  1.00 17.95           C  
ATOM    721  CE1 PHE A 103      17.937 113.374  19.282  1.00 18.87           C  
ATOM    722  CE2 PHE A 103      17.124 112.938  17.083  1.00 18.29           C  
ATOM    723  CZ  PHE A 103      18.157 112.971  17.985  1.00 18.47           C  
ATOM    724  N   GLU A 104      15.635 116.712  17.378  1.00 18.06           N  
ATOM    725  CA  GLU A 104      16.175 117.016  16.066  1.00 17.77           C  
ATOM    726  C   GLU A 104      17.619 116.516  16.008  1.00 16.96           C  
ATOM    727  O   GLU A 104      18.414 116.799  16.932  1.00 19.67           O  
ATOM    728  CB  GLU A 104      16.137 118.521  15.823  1.00 21.00           C  
ATOM    729  CG  GLU A 104      14.729 119.093  15.925  1.00 23.74           C  
ATOM    730  CD  GLU A 104      14.639 120.541  15.450  1.00 35.56           C  
ATOM    731  OE1 GLU A 104      15.404 121.371  15.975  1.00 42.09           O  
ATOM    732  OE2 GLU A 104      13.802 120.847  14.568  1.00 45.24           O  
ATOM    733  N   PRO A 105      17.970 115.787  14.937  1.00 16.71           N  
ATOM    734  CA  PRO A 105      19.376 115.442  14.765  1.00 17.06           C  
ATOM    735  C   PRO A 105      20.224 116.689  14.591  1.00 18.69           C  
ATOM    736  O   PRO A 105      19.766 117.650  13.971  1.00 18.94           O  
ATOM    737  CB  PRO A 105      19.416 114.617  13.467  1.00 19.38           C  
ATOM    738  CG  PRO A 105      18.030 114.411  13.070  1.00 26.57           C  
ATOM    739  CD  PRO A 105      17.124 115.291  13.838  1.00 19.56           C  
ATOM    740  N   ASN A 106      21.437 116.684  15.143  1.00 16.66           N  
ATOM    741  CA  ASN A 106      22.350 117.796  14.972  1.00 17.55           C  
ATOM    742  C   ASN A 106      23.486 117.476  13.991  1.00 17.48           C  
ATOM    743  O   ASN A 106      24.478 118.218  13.899  1.00 18.10           O  
ATOM    744  CB  ASN A 106      22.899 118.266  16.332  1.00 16.67           C  
ATOM    745  CG  ASN A 106      23.784 117.242  16.991  1.00 17.12           C  
ATOM    746  OD1 ASN A 106      24.149 116.247  16.379  1.00 18.76           O  
ATOM    747  ND2 ASN A 106      24.130 117.475  18.268  1.00 18.94           N  
ATOM    748  N   PHE A 107      23.313 116.393  13.233  1.00 16.52           N  
ATOM    749  CA  PHE A 107      24.301 115.913  12.289  1.00 16.72           C  
ATOM    750  C   PHE A 107      23.624 115.667  10.947  1.00 16.47           C  
ATOM    751  O   PHE A 107      22.385 115.652  10.846  1.00 18.81           O  
ATOM    752  CB  PHE A 107      24.978 114.650  12.829  1.00 18.64           C  
ATOM    753  CG  PHE A 107      24.014 113.538  13.148  1.00 16.88           C  
ATOM    754  CD1 PHE A 107      23.413 113.435  14.376  1.00 16.63           C  
ATOM    755  CD2 PHE A 107      23.676 112.616  12.164  1.00 17.23           C  
ATOM    756  CE1 PHE A 107      22.502 112.408  14.642  1.00 18.02           C  
ATOM    757  CE2 PHE A 107      22.767 111.620  12.406  1.00 17.16           C  
ATOM    758  CZ  PHE A 107      22.181 111.507  13.643  1.00 16.68           C  
ATOM    759  N   MET A 108      24.442 115.437   9.935  1.00 18.50           N  
ATOM    760  CA  MET A 108      23.949 115.287   8.597  1.00 18.78           C  
ATOM    761  C   MET A 108      23.256 113.939   8.366  1.00 16.28           C  
ATOM    762  O   MET A 108      23.851 112.882   8.607  1.00 17.03           O  
ATOM    763  CB  MET A 108      25.127 115.413   7.639  1.00 22.11           C  
ATOM    764  CG  MET A 108      24.785 115.134   6.212  1.00 27.95           C  
ATOM    765  SD  MET A 108      23.765 116.434   5.518  1.00 45.11           S  
ATOM    766  CE  MET A 108      24.969 117.745   5.330  1.00 50.94           C  
ATOM    767  N   LEU A 109      22.036 113.992   7.830  1.00 17.59           N  
ATOM    768  CA  LEU A 109      21.344 112.835   7.315  1.00 17.61           C  
ATOM    769  C   LEU A 109      21.258 112.920   5.805  1.00 16.33           C  
ATOM    770  O   LEU A 109      21.002 113.998   5.220  1.00 16.37           O  
ATOM    771  CB  LEU A 109      19.919 112.746   7.863  1.00 16.46           C  
ATOM    772  CG  LEU A 109      19.780 112.372   9.340  1.00 17.66           C  
ATOM    773  CD1 LEU A 109      18.306 112.466   9.715  1.00 22.02           C  
ATOM    774  CD2 LEU A 109      20.284 110.999   9.583  1.00 18.99           C  
ATOM    775  N   PHE A 110      21.407 111.763   5.176  1.00 15.89           N  
ATOM    776  CA  PHE A 110      21.279 111.652   3.744  1.00 15.69           C  
ATOM    777  C   PHE A 110      19.947 110.994   3.341  1.00 17.63           C  
ATOM    778  O   PHE A 110      19.184 110.510   4.180  1.00 16.77           O  
ATOM    779  CB  PHE A 110      22.481 110.887   3.206  1.00 16.95           C  
ATOM    780  CG  PHE A 110      23.780 111.599   3.433  1.00 16.93           C  
ATOM    781  CD1 PHE A 110      24.168 112.585   2.576  1.00 19.45           C  
ATOM    782  CD2 PHE A 110      24.585 111.297   4.495  1.00 20.04           C  
ATOM    783  CE1 PHE A 110      25.361 113.264   2.758  1.00 21.73           C  
ATOM    784  CE2 PHE A 110      25.784 111.976   4.692  1.00 22.37           C  
ATOM    785  CZ  PHE A 110      26.166 112.948   3.806  1.00 20.88           C  
ATOM    786  N   GLU A 111      19.662 110.993   2.042  1.00 16.30           N  
ATOM    787  CA  GLU A 111      18.476 110.329   1.507  1.00 16.20           C  
ATOM    788  C   GLU A 111      18.558 108.837   1.802  1.00 16.05           C  
ATOM    789  O   GLU A 111      19.644 108.265   1.883  1.00 16.00           O  
ATOM    790  CB  GLU A 111      18.351 110.555  -0.017  1.00 16.70           C  
ATOM    791  CG  GLU A 111      17.868 111.930  -0.405  1.00 19.34           C  
ATOM    792  CD  GLU A 111      17.582 112.057  -1.888  1.00 23.09           C  
ATOM    793  OE1 GLU A 111      17.984 111.170  -2.667  1.00 23.42           O  
ATOM    794  OE2 GLU A 111      16.954 113.064  -2.256  1.00 25.41           O  
ATOM    795  N   LYS A 112      17.398 108.207   1.942  1.00 15.22           N  
ATOM    796  CA  LYS A 112      17.293 106.765   2.143  0.50 14.20           C  
ATOM    798  C   LYS A 112      18.042 106.029   1.058  1.00 16.53           C  
ATOM    799  O   LYS A 112      17.971 106.403  -0.120  1.00 16.61           O  
ATOM    800  CB  LYS A 112      15.830 106.317   2.092  0.50 13.95           C  
ATOM    802  CG  LYS A 112      15.041 106.639   3.325  0.50 13.64           C  
ATOM    804  CD  LYS A 112      13.551 106.436   3.105  0.50 16.39           C  
ATOM    806  CE  LYS A 112      13.178 104.986   2.848  0.50 16.86           C  
ATOM    808  NZ  LYS A 112      11.696 104.843   2.729  0.50 17.42           N  
ATOM    810  N   CYS A 113      18.740 104.974   1.442  1.00 15.95           N  
ATOM    811  CA  CYS A 113      19.437 104.136   0.490  1.00 15.99           C  
ATOM    812  C   CYS A 113      19.472 102.705   0.989  1.00 17.59           C  
ATOM    813  O   CYS A 113      18.945 102.400   2.066  1.00 18.58           O  
ATOM    814  CB  CYS A 113      20.844 104.662   0.248  1.00 18.44           C  
ATOM    815  SG  CYS A 113      21.936 104.631   1.687  1.00 25.70           S  
ATOM    816  N   GLU A 114      20.012 101.826   0.154  1.00 16.27           N  
ATOM    817  CA  GLU A 114      20.294 100.457   0.529  1.00 16.02           C  
ATOM    818  C   GLU A 114      21.754 100.325   0.887  1.00 15.38           C  
ATOM    819  O   GLU A 114      22.617 100.989   0.284  1.00 16.76           O  
ATOM    820  CB  GLU A 114      19.882  99.533  -0.626  1.00 17.02           C  
ATOM    821  CG  GLU A 114      18.345  99.509  -0.784  1.00 17.38           C  
ATOM    822  CD  GLU A 114      17.805  98.560  -1.806  1.00 26.55           C  
ATOM    823  OE1 GLU A 114      18.537  98.159  -2.706  1.00 21.01           O  
ATOM    824  OE2 GLU A 114      16.597  98.269  -1.711  1.00 36.90           O  
ATOM    825  N   VAL A 115      22.033  99.467   1.878  1.00 14.19           N  
ATOM    826  CA  VAL A 115      23.401  99.177   2.279  1.00 14.17           C  
ATOM    827  C   VAL A 115      23.901  97.793   1.844  1.00 14.70           C  
ATOM    828  O   VAL A 115      25.117  97.605   1.730  1.00 15.19           O  
ATOM    829  CB  VAL A 115      23.601  99.398   3.800  1.00 15.93           C  
ATOM    830  CG1 VAL A 115      23.173 100.835   4.161  1.00 16.04           C  
ATOM    831  CG2 VAL A 115      22.844  98.385   4.648  1.00 16.42           C  
ATOM    832  N   ASN A 116      22.976  96.866   1.569  1.00 14.21           N  
ATOM    833  CA  ASN A 116      23.261  95.483   1.217  1.00 15.21           C  
ATOM    834  C   ASN A 116      22.648  95.199  -0.160  1.00 16.43           C  
ATOM    835  O   ASN A 116      21.678  95.847  -0.567  1.00 14.88           O  
ATOM    836  CB  ASN A 116      22.619  94.521   2.209  1.00 15.74           C  
ATOM    837  CG  ASN A 116      23.233  94.576   3.575  1.00 14.21           C  
ATOM    838  OD1 ASN A 116      24.380  94.983   3.718  1.00 14.38           O  
ATOM    839  ND2 ASN A 116      22.469  94.146   4.612  1.00 15.88           N  
ATOM    840  N   GLY A 117      23.173  94.196  -0.838  1.00 14.86           N  
ATOM    841  CA  GLY A 117      22.608  93.764  -2.100  1.00 14.92           C  
ATOM    842  C   GLY A 117      23.080  94.560  -3.313  1.00 15.67           C  
ATOM    843  O   GLY A 117      23.860  95.515  -3.180  1.00 15.46           O  
ATOM    844  N   ALA A 118      22.583  94.170  -4.479  1.00 15.21           N  
ATOM    845  CA  ALA A 118      23.058  94.757  -5.728  1.00 15.02           C  
ATOM    846  C   ALA A 118      22.738  96.227  -5.842  1.00 18.53           C  
ATOM    847  O   ALA A 118      23.409  96.933  -6.613  1.00 19.92           O  
ATOM    848  CB  ALA A 118      22.461  93.995  -6.911  1.00 17.86           C  
ATOM    849  N   GLY A 119      21.722  96.674  -5.116  1.00 15.87           N  
ATOM    850  CA  GLY A 119      21.293  98.078  -5.111  1.00 16.96           C  
ATOM    851  C   GLY A 119      21.986  98.959  -4.080  1.00 17.47           C  
ATOM    852  O   GLY A 119      21.641 100.135  -3.934  1.00 17.86           O  
ATOM    853  N   ALA A 120      22.940  98.396  -3.348  1.00 16.53           N  
ATOM    854  CA  ALA A 120      23.597  99.112  -2.275  1.00 15.91           C  
ATOM    855  C   ALA A 120      24.250 100.384  -2.774  1.00 15.87           C  
ATOM    856  O   ALA A 120      24.851 100.415  -3.860  1.00 16.29           O  
ATOM    857  CB  ALA A 120      24.668  98.254  -1.654  1.00 15.90           C  
ATOM    858  N   HIS A 121      24.152 101.436  -1.982  1.00 15.67           N  
ATOM    859  CA  HIS A 121      24.909 102.653  -2.253  1.00 16.16           C  
ATOM    860  C   HIS A 121      26.395 102.297  -2.309  1.00 15.23           C  
ATOM    861  O   HIS A 121      26.869 101.517  -1.477  1.00 16.31           O  
ATOM    862  CB  HIS A 121      24.636 103.654  -1.139  1.00 18.67           C  
ATOM    863  CG  HIS A 121      25.195 105.011  -1.421  1.00 18.72           C  
ATOM    864  ND1 HIS A 121      26.545 105.284  -1.357  1.00 17.77           N  
ATOM    865  CD2 HIS A 121      24.597 106.158  -1.829  1.00 20.47           C  
ATOM    866  CE1 HIS A 121      26.752 106.546  -1.704  1.00 21.26           C  
ATOM    867  NE2 HIS A 121      25.589 107.096  -2.011  1.00 20.27           N  
ATOM    868  N   PRO A 122      27.136 102.802  -3.291  1.00 15.05           N  
ATOM    869  CA  PRO A 122      28.547 102.421  -3.403  1.00 17.00           C  
ATOM    870  C   PRO A 122      29.421 102.657  -2.168  1.00 16.49           C  
ATOM    871  O   PRO A 122      30.394 101.927  -1.944  1.00 16.25           O  
ATOM    872  CB  PRO A 122      29.046 103.252  -4.586  1.00 20.37           C  
ATOM    873  CG  PRO A 122      27.930 104.082  -5.022  1.00 24.49           C  
ATOM    874  CD  PRO A 122      26.690 103.699  -4.357  1.00 16.47           C  
ATOM    875  N   LEU A 123      29.073 103.640  -1.345  1.00 15.69           N  
ATOM    876  CA  LEU A 123      29.818 103.893  -0.115  1.00 14.29           C  
ATOM    877  C   LEU A 123      29.732 102.685   0.809  1.00 13.79           C  
ATOM    878  O   LEU A 123      30.722 102.283   1.416  1.00 16.25           O  
ATOM    879  CB  LEU A 123      29.256 105.130   0.597  1.00 15.86           C  
ATOM    880  CG  LEU A 123      29.835 105.356   1.999  1.00 15.97           C  
ATOM    881  CD1 LEU A 123      31.328 105.618   1.974  1.00 17.04           C  
ATOM    882  CD2 LEU A 123      29.069 106.465   2.730  1.00 17.23           C  
ATOM    883  N   PHE A 124      28.548 102.066   0.876  1.00 15.30           N  
ATOM    884  CA  PHE A 124      28.386 100.917   1.767  1.00 14.81           C  
ATOM    885  C   PHE A 124      28.948  99.637   1.176  1.00 15.20           C  
ATOM    886  O   PHE A 124      29.499  98.811   1.922  1.00 15.71           O  
ATOM    887  CB  PHE A 124      26.938 100.754   2.224  1.00 17.23           C  
ATOM    888  CG  PHE A 124      26.581 101.729   3.302  1.00 16.35           C  
ATOM    889  CD1 PHE A 124      26.833 101.419   4.610  1.00 16.40           C  
ATOM    890  CD2 PHE A 124      26.107 102.996   3.003  1.00 18.22           C  
ATOM    891  CE1 PHE A 124      26.572 102.324   5.628  1.00 17.50           C  
ATOM    892  CE2 PHE A 124      25.858 103.923   4.009  1.00 17.28           C  
ATOM    893  CZ  PHE A 124      26.079 103.576   5.325  1.00 15.51           C  
ATOM    894  N   ALA A 125      28.866  99.485  -0.142  1.00 15.73           N  
ATOM    895  CA  ALA A 125      29.541  98.345  -0.773  1.00 15.24           C  
ATOM    896  C   ALA A 125      31.056  98.422  -0.451  1.00 17.91           C  
ATOM    897  O   ALA A 125      31.714  97.428  -0.129  1.00 18.94           O  
ATOM    898  CB  ALA A 125      29.303  98.342  -2.273  1.00 17.21           C  
ATOM    899  N   PHE A 126      31.594  99.639  -0.493  1.00 16.15           N  
ATOM    900  CA  PHE A 126      33.007  99.873  -0.197  1.00 14.55           C  
ATOM    901  C   PHE A 126      33.344  99.611   1.269  1.00 15.79           C  
ATOM    902  O   PHE A 126      34.314  98.897   1.576  1.00 16.50           O  
ATOM    903  CB  PHE A 126      33.383 101.311  -0.616  1.00 15.56           C  
ATOM    904  CG  PHE A 126      34.697 101.777  -0.054  1.00 15.46           C  
ATOM    905  CD1 PHE A 126      35.889 101.359  -0.602  1.00 17.81           C  
ATOM    906  CD2 PHE A 126      34.741 102.598   1.055  1.00 17.29           C  
ATOM    907  CE1 PHE A 126      37.092 101.744  -0.069  1.00 18.35           C  
ATOM    908  CE2 PHE A 126      35.955 102.986   1.585  1.00 17.82           C  
ATOM    909  CZ  PHE A 126      37.117 102.547   1.036  1.00 16.89           C  
ATOM    910  N   LEU A 127      32.558 100.179   2.183  1.00 15.38           N  
ATOM    911  CA  LEU A 127      32.818 100.018   3.597  1.00 16.33           C  
ATOM    912  C   LEU A 127      32.753  98.555   3.982  1.00 14.79           C  
ATOM    913  O   LEU A 127      33.563  98.091   4.771  1.00 15.50           O  
ATOM    914  CB  LEU A 127      31.818 100.813   4.439  1.00 16.58           C  
ATOM    915  CG  LEU A 127      31.962 102.344   4.389  1.00 16.31           C  
ATOM    916  CD1 LEU A 127      30.752 103.032   5.036  1.00 18.21           C  
ATOM    917  CD2 LEU A 127      33.238 102.757   5.117  1.00 17.30           C  
ATOM    918  N   ARG A 128      31.756  97.837   3.477  1.00 15.44           N  
ATOM    919  CA  ARG A 128      31.604  96.412   3.779  1.00 15.98           C  
ATOM    920  C   ARG A 128      32.802  95.568   3.340  1.00 16.33           C  
ATOM    921  O   ARG A 128      33.220  94.654   4.052  1.00 18.38           O  
ATOM    922  CB  ARG A 128      30.311  95.870   3.169  1.00 15.54           C  
ATOM    923  CG  ARG A 128      29.043  96.275   3.906  1.00 14.62           C  
ATOM    924  CD  ARG A 128      27.762  96.035   3.104  1.00 19.27           C  
ATOM    925  NE  ARG A 128      27.933  94.852   2.283  1.00 18.37           N  
ATOM    926  CZ  ARG A 128      27.612  94.746   1.001  1.00 16.20           C  
ATOM    927  NH1 ARG A 128      27.980  93.661   0.359  1.00 17.72           N  
ATOM    928  NH2 ARG A 128      26.885  95.654   0.367  1.00 17.04           N  
ATOM    929  N   GLU A 129      33.329  95.858   2.163  1.00 16.27           N  
ATOM    930  CA  GLU A 129      34.521  95.162   1.664  1.00 18.24           C  
ATOM    931  C   GLU A 129      35.776  95.544   2.445  1.00 17.16           C  
ATOM    932  O   GLU A 129      36.650  94.700   2.677  1.00 18.80           O  
ATOM    933  CB  GLU A 129      34.728  95.435   0.173  1.00 22.90           C  
ATOM    934  CG  GLU A 129      33.708  94.711  -0.673  1.00 42.15           C  
ATOM    935  CD  GLU A 129      33.976  94.839  -2.159  1.00 59.85           C  
ATOM    936  OE1 GLU A 129      33.507  95.827  -2.776  1.00 65.38           O  
ATOM    937  OE2 GLU A 129      34.656  93.941  -2.703  1.00 64.32           O  
ATOM    938  N   ALA A 130      35.874  96.810   2.853  1.00 16.78           N  
ATOM    939  CA  ALA A 130      37.059  97.296   3.575  1.00 16.88           C  
ATOM    940  C   ALA A 130      37.137  96.711   4.986  1.00 17.01           C  
ATOM    941  O   ALA A 130      38.236  96.397   5.495  1.00 18.52           O  
ATOM    942  CB  ALA A 130      37.043  98.816   3.635  1.00 18.10           C  
ATOM    943  N   LEU A 131      35.972  96.581   5.633  1.00 16.36           N  
ATOM    944  CA  LEU A 131      35.867  96.141   7.010  1.00 16.83           C  
ATOM    945  C   LEU A 131      34.818  95.034   7.038  1.00 16.54           C  
ATOM    946  O   LEU A 131      33.651  95.310   7.264  1.00 17.38           O  
ATOM    947  CB  LEU A 131      35.413  97.321   7.878  1.00 17.95           C  
ATOM    948  CG  LEU A 131      36.386  98.512   7.974  1.00 19.15           C  
ATOM    949  CD1 LEU A 131      35.676  99.729   8.584  1.00 18.85           C  
ATOM    950  CD2 LEU A 131      37.684  98.162   8.701  1.00 20.71           C  
ATOM    951  N   PRO A 132      35.211  93.796   6.705  1.00 16.39           N  
ATOM    952  CA  PRO A 132      34.215  92.792   6.356  1.00 16.04           C  
ATOM    953  C   PRO A 132      33.391  92.211   7.495  1.00 17.89           C  
ATOM    954  O   PRO A 132      32.434  91.464   7.251  1.00 17.62           O  
ATOM    955  CB  PRO A 132      35.031  91.680   5.680  1.00 20.28           C  
ATOM    956  CG  PRO A 132      36.395  92.129   5.619  1.00 22.17           C  
ATOM    957  CD  PRO A 132      36.584  93.336   6.434  1.00 19.97           C  
ATOM    958  N   ALA A 133      33.737  92.516   8.737  1.00 17.53           N  
ATOM    959  CA  ALA A 133      32.914  92.093   9.860  1.00 17.76           C  
ATOM    960  C   ALA A 133      33.131  93.038  11.034  1.00 17.09           C  
ATOM    961  O   ALA A 133      34.219  93.597  11.191  1.00 18.88           O  
ATOM    962  CB  ALA A 133      33.231  90.662  10.273  1.00 20.89           C  
ATOM    963  N   PRO A 134      32.074  93.267  11.820  1.00 16.61           N  
ATOM    964  CA  PRO A 134      32.237  94.118  13.000  1.00 16.36           C  
ATOM    965  C   PRO A 134      33.355  93.634  13.898  1.00 18.91           C  
ATOM    966  O   PRO A 134      33.518  92.431  14.112  1.00 18.96           O  
ATOM    967  CB  PRO A 134      30.906  93.996  13.699  1.00 17.36           C  
ATOM    968  CG  PRO A 134      29.938  93.734  12.577  1.00 19.99           C  
ATOM    969  CD  PRO A 134      30.675  92.838  11.655  1.00 19.03           C  
ATOM    970  N   SER A 135      34.116  94.577  14.444  1.00 17.45           N  
ATOM    971  CA  SER A 135      35.231  94.285  15.296  1.00 18.01           C  
ATOM    972  C   SER A 135      34.833  93.566  16.559  1.00 16.62           C  
ATOM    973  O   SER A 135      35.636  92.802  17.113  1.00 20.62           O  
ATOM    974  CB  SER A 135      35.924  95.602  15.674  1.00 19.91           C  
ATOM    975  OG  SER A 135      35.031  96.488  16.329  1.00 20.04           O  
ATOM    976  N   ASP A 136      33.612  93.817  17.034  1.00 16.62           N  
ATOM    977  CA  ASP A 136      33.107  93.234  18.292  1.00 17.16           C  
ATOM    978  C   ASP A 136      32.302  91.954  18.143  1.00 22.54           C  
ATOM    979  O   ASP A 136      32.034  91.282  19.122  1.00 24.71           O  
ATOM    980  CB  ASP A 136      32.256  94.252  19.048  1.00 16.45           C  
ATOM    981  CG  ASP A 136      31.021  94.695  18.276  1.00 17.25           C  
ATOM    982  OD1 ASP A 136      31.182  95.215  17.139  1.00 17.37           O  
ATOM    983  OD2 ASP A 136      29.916  94.559  18.839  1.00 18.38           O  
ATOM    984  N   ASP A 137      31.881  91.638  16.928  1.00 19.35           N  
ATOM    985  CA  ASP A 137      31.065  90.439  16.648  1.00 18.84           C  
ATOM    986  C   ASP A 137      31.289  90.057  15.195  1.00 19.01           C  
ATOM    987  O   ASP A 137      30.668  90.589  14.276  1.00 19.70           O  
ATOM    988  CB  ASP A 137      29.601  90.723  16.923  1.00 22.38           C  
ATOM    989  CG  ASP A 137      28.703  89.509  16.703  1.00 30.48           C  
ATOM    990  OD1 ASP A 137      29.172  88.486  16.170  1.00 23.16           O  
ATOM    991  OD2 ASP A 137      27.523  89.596  17.086  1.00 33.09           O  
ATOM    992  N   ALA A 138      32.235  89.166  15.000  1.00 18.81           N  
ATOM    993  CA  ALA A 138      32.625  88.718  13.680  1.00 19.43           C  
ATOM    994  C   ALA A 138      31.682  87.692  13.090  1.00 19.41           C  
ATOM    995  O   ALA A 138      31.844  87.336  11.921  1.00 19.77           O  
ATOM    996  CB  ALA A 138      34.002  88.087  13.780  1.00 23.76           C  
ATOM    997  N   THR A 139      30.705  87.207  13.870  1.00 18.05           N  
ATOM    998  CA  THR A 139      29.948  85.996  13.503  0.25 17.88           C  
ATOM   1001  C   THR A 139      28.470  86.238  13.178  1.00 18.80           C  
ATOM   1002  O   THR A 139      27.941  85.710  12.200  1.00 17.01           O  
ATOM   1003  CB  THR A 139      30.056  84.905  14.614  0.25 19.27           C  
ATOM   1006  OG1 THR A 139      29.018  83.933  14.461  0.25 22.72           O  
ATOM   1009  CG2 THR A 139      29.943  85.502  15.997  0.25 15.96           C  
ATOM   1012  N   ALA A 140      27.762  87.012  14.004  1.00 15.86           N  
ATOM   1013  CA  ALA A 140      26.318  87.107  13.838  1.00 17.58           C  
ATOM   1014  C   ALA A 140      25.913  87.887  12.615  1.00 19.46           C  
ATOM   1015  O   ALA A 140      26.415  88.973  12.394  1.00 21.11           O  
ATOM   1016  CB  ALA A 140      25.700  87.738  15.070  1.00 19.55           C  
ATOM   1017  N   LEU A 141      24.952  87.360  11.850  1.00 17.05           N  
ATOM   1018  CA  LEU A 141      24.399  88.089  10.711  1.00 17.16           C  
ATOM   1019  C   LEU A 141      22.899  88.358  10.879  1.00 16.96           C  
ATOM   1020  O   LEU A 141      22.460  89.491  10.687  1.00 19.85           O  
ATOM   1021  CB  LEU A 141      24.647  87.360   9.387  1.00 17.33           C  
ATOM   1022  CG  LEU A 141      24.191  88.078   8.102  1.00 19.26           C  
ATOM   1023  CD1 LEU A 141      24.755  89.501   7.950  1.00 19.96           C  
ATOM   1024  CD2 LEU A 141      24.601  87.219   6.905  1.00 19.62           C  
ATOM   1025  N   MET A 142      22.103  87.332  11.178  1.00 15.97           N  
ATOM   1026  CA  MET A 142      20.636  87.523  11.391  1.00 15.37           C  
ATOM   1027  C   MET A 142      20.108  86.346  12.150  1.00 15.44           C  
ATOM   1028  O   MET A 142      20.438  85.194  11.816  1.00 16.89           O  
ATOM   1029  CB  MET A 142      19.887  87.644  10.073  1.00 15.94           C  
ATOM   1030  CG  MET A 142      18.491  88.210  10.185  1.00 15.14           C  
ATOM   1031  SD  MET A 142      18.466  89.987  10.572  1.00 16.77           S  
ATOM   1032  CE  MET A 142      18.984  90.704   9.023  1.00 17.62           C  
ATOM   1033  N   THR A 143      19.290  86.556  13.183  1.00 16.15           N  
ATOM   1034  CA  THR A 143      18.714  85.419  13.882  1.00 16.07           C  
ATOM   1035  C   THR A 143      17.587  84.767  13.085  1.00 16.25           C  
ATOM   1036  O   THR A 143      17.544  83.540  12.872  1.00 19.60           O  
ATOM   1037  CB  THR A 143      18.214  85.833  15.245  1.00 18.53           C  
ATOM   1038  OG1 THR A 143      19.368  86.255  16.009  1.00 20.90           O  
ATOM   1039  CG2 THR A 143      17.517  84.668  15.934  1.00 19.30           C  
ATOM   1040  N   ASP A 144      16.667  85.609  12.616  1.00 16.64           N  
ATOM   1041  CA  ASP A 144      15.517  85.155  11.813  1.00 15.40           C  
ATOM   1042  C   ASP A 144      15.831  85.288  10.317  1.00 14.21           C  
ATOM   1043  O   ASP A 144      15.902  86.404   9.795  1.00 15.69           O  
ATOM   1044  CB  ASP A 144      14.297  86.019  12.164  1.00 15.50           C  
ATOM   1045  CG  ASP A 144      13.044  85.664  11.361  1.00 18.64           C  
ATOM   1046  OD1 ASP A 144      13.079  84.725  10.530  1.00 17.06           O  
ATOM   1047  OD2 ASP A 144      12.003  86.331  11.603  1.00 21.07           O  
ATOM   1048  N   PRO A 145      16.006  84.137   9.613  1.00 14.43           N  
ATOM   1049  CA  PRO A 145      16.425  84.225   8.215  1.00 13.72           C  
ATOM   1050  C   PRO A 145      15.395  84.935   7.333  1.00 13.72           C  
ATOM   1051  O   PRO A 145      15.724  85.400   6.231  1.00 16.16           O  
ATOM   1052  CB  PRO A 145      16.562  82.757   7.807  1.00 15.67           C  
ATOM   1053  CG  PRO A 145      15.642  82.058   8.674  1.00 14.42           C  
ATOM   1054  CD  PRO A 145      15.809  82.728   9.988  1.00 15.97           C  
ATOM   1055  N   LYS A 146      14.136  84.999   7.783  1.00 14.80           N  
ATOM   1056  CA  LYS A 146      13.116  85.668   6.976  1.00 15.21           C  
ATOM   1057  C   LYS A 146      13.371  87.159   6.872  1.00 14.81           C  
ATOM   1058  O   LYS A 146      12.754  87.818   6.020  1.00 15.71           O  
ATOM   1059  CB  LYS A 146      11.734  85.452   7.567  1.00 15.57           C  
ATOM   1060  CG  LYS A 146      11.347  83.994   7.648  1.00 16.56           C  
ATOM   1061  CD  LYS A 146       9.875  83.767   8.064  1.00 16.55           C  
ATOM   1062  CE  LYS A 146       9.546  84.302   9.416  1.00 18.16           C  
ATOM   1063  NZ  LYS A 146      10.386  83.710  10.475  1.00 19.69           N  
ATOM   1064  N   LEU A 147      14.225  87.696   7.731  1.00 14.17           N  
ATOM   1065  CA  LEU A 147      14.577  89.111   7.682  1.00 15.51           C  
ATOM   1066  C   LEU A 147      15.696  89.405   6.703  1.00 16.18           C  
ATOM   1067  O   LEU A 147      16.006  90.563   6.459  1.00 17.18           O  
ATOM   1068  CB  LEU A 147      14.931  89.645   9.070  1.00 14.51           C  
ATOM   1069  CG  LEU A 147      13.736  89.780   9.997  1.00 15.69           C  
ATOM   1070  CD1 LEU A 147      14.235  89.912  11.423  1.00 16.45           C  
ATOM   1071  CD2 LEU A 147      12.807  90.938   9.602  1.00 18.57           C  
ATOM   1072  N   ILE A 148      16.318  88.374   6.122  1.00 13.76           N  
ATOM   1073  CA  ILE A 148      17.297  88.603   5.031  1.00 14.29           C  
ATOM   1074  C   ILE A 148      16.531  88.582   3.718  1.00 15.25           C  
ATOM   1075  O   ILE A 148      16.120  87.531   3.239  1.00 15.38           O  
ATOM   1076  CB  ILE A 148      18.420  87.550   5.017  1.00 15.11           C  
ATOM   1077  CG1 ILE A 148      19.186  87.586   6.325  1.00 15.10           C  
ATOM   1078  CG2 ILE A 148      19.363  87.829   3.831  1.00 14.93           C  
ATOM   1079  CD1 ILE A 148      20.274  86.489   6.417  1.00 18.69           C  
ATOM   1080  N   THR A 149      16.259  89.763   3.169  1.00 16.18           N  
ATOM   1081  CA  THR A 149      15.402  89.899   2.003  1.00 14.18           C  
ATOM   1082  C   THR A 149      16.055  90.607   0.806  1.00 17.29           C  
ATOM   1083  O   THR A 149      15.412  90.793  -0.222  1.00 18.18           O  
ATOM   1084  CB  THR A 149      14.136  90.645   2.393  1.00 16.80           C  
ATOM   1085  OG1 THR A 149      14.504  91.920   2.959  1.00 21.90           O  
ATOM   1086  CG2 THR A 149      13.283  89.805   3.383  1.00 19.82           C  
ATOM   1087  N   TRP A 150      17.334  90.942   0.923  1.00 15.83           N  
ATOM   1088  CA  TRP A 150      18.062  91.600  -0.166  1.00 14.09           C  
ATOM   1089  C   TRP A 150      18.822  90.566  -0.951  1.00 14.24           C  
ATOM   1090  O   TRP A 150      18.915  89.394  -0.557  1.00 15.03           O  
ATOM   1091  CB  TRP A 150      19.021  92.650   0.405  1.00 15.77           C  
ATOM   1092  CG  TRP A 150      19.973  92.077   1.415  1.00 14.93           C  
ATOM   1093  CD1 TRP A 150      21.156  91.456   1.158  1.00 15.71           C  
ATOM   1094  CD2 TRP A 150      19.794  92.019   2.838  1.00 15.35           C  
ATOM   1095  NE1 TRP A 150      21.724  91.030   2.332  1.00 16.51           N  
ATOM   1096  CE2 TRP A 150      20.915  91.362   3.385  1.00 15.06           C  
ATOM   1097  CE3 TRP A 150      18.808  92.510   3.716  1.00 16.34           C  
ATOM   1098  CZ2 TRP A 150      21.062  91.148   4.782  1.00 15.40           C  
ATOM   1099  CZ3 TRP A 150      18.957  92.283   5.069  1.00 17.15           C  
ATOM   1100  CH2 TRP A 150      20.078  91.640   5.591  1.00 16.41           C  
ATOM   1101  N   SER A 151      19.375  90.989  -2.080  1.00 14.84           N  
ATOM   1102  CA  SER A 151      20.072  90.079  -2.979  0.50 15.79           C  
ATOM   1104  C   SER A 151      21.144  90.789  -3.777  1.00 15.58           C  
ATOM   1105  O   SER A 151      20.898  91.895  -4.282  1.00 14.77           O  
ATOM   1106  CB  SER A 151      19.078  89.454  -3.953  0.50 17.91           C  
ATOM   1108  OG  SER A 151      18.232  90.429  -4.562  0.50 18.41           O  
ATOM   1110  N   PRO A 152      22.326  90.174  -3.920  1.00 14.31           N  
ATOM   1111  CA  PRO A 152      22.764  88.934  -3.275  1.00 15.54           C  
ATOM   1112  C   PRO A 152      23.098  89.180  -1.832  1.00 15.82           C  
ATOM   1113  O   PRO A 152      23.173  90.346  -1.394  1.00 15.23           O  
ATOM   1114  CB  PRO A 152      24.038  88.554  -4.027  1.00 17.54           C  
ATOM   1115  CG  PRO A 152      24.452  89.725  -4.756  1.00 21.64           C  
ATOM   1116  CD  PRO A 152      23.329  90.723  -4.839  1.00 15.18           C  
ATOM   1117  N   VAL A 153      23.255  88.081  -1.092  1.00 14.46           N  
ATOM   1118  CA  VAL A 153      23.647  88.105   0.312  1.00 14.47           C  
ATOM   1119  C   VAL A 153      25.137  87.785   0.402  1.00 14.81           C  
ATOM   1120  O   VAL A 153      25.624  86.812  -0.186  1.00 14.62           O  
ATOM   1121  CB  VAL A 153      22.828  87.084   1.126  1.00 13.87           C  
ATOM   1122  CG1 VAL A 153      23.115  87.281   2.608  1.00 16.39           C  
ATOM   1123  CG2 VAL A 153      21.311  87.253   0.869  1.00 15.12           C  
ATOM   1124  N   CYS A 154      25.845  88.592   1.182  1.00 15.07           N  
ATOM   1125  CA  CYS A 154      27.289  88.492   1.339  1.00 14.55           C  
ATOM   1126  C   CYS A 154      27.671  88.376   2.796  1.00 14.81           C  
ATOM   1127  O   CYS A 154      26.972  88.862   3.693  1.00 15.66           O  
ATOM   1128  CB  CYS A 154      27.976  89.725   0.776  1.00 15.96           C  
ATOM   1129  SG  CYS A 154      27.763  89.904  -1.002  1.00 18.15           S  
ATOM   1130  N   ARG A 155      28.818  87.752   3.020  1.00 13.48           N  
ATOM   1131  CA  ARG A 155      29.297  87.536   4.372  1.00 14.22           C  
ATOM   1132  C   ARG A 155      29.554  88.851   5.115  1.00 14.56           C  
ATOM   1133  O   ARG A 155      29.552  88.853   6.348  1.00 16.15           O  
ATOM   1134  CB  ARG A 155      30.570  86.709   4.356  1.00 12.99           C  
ATOM   1135  CG  ARG A 155      30.409  85.337   3.731  1.00 14.71           C  
ATOM   1136  CD  ARG A 155      31.696  84.507   3.861  1.00 13.71           C  
ATOM   1137  NE  ARG A 155      31.576  83.250   3.117  1.00 13.49           N  
ATOM   1138  CZ  ARG A 155      30.962  82.172   3.583  1.00 13.24           C  
ATOM   1139  NH1 ARG A 155      30.475  82.149   4.826  1.00 14.40           N  
ATOM   1140  NH2 ARG A 155      30.809  81.101   2.804  1.00 13.79           N  
ATOM   1141  N   ASN A 156      29.762  89.934   4.379  1.00 15.01           N  
ATOM   1142  CA  ASN A 156      30.126  91.230   4.940  1.00 14.89           C  
ATOM   1143  C   ASN A 156      28.931  92.158   5.077  1.00 14.03           C  
ATOM   1144  O   ASN A 156      29.110  93.324   5.418  1.00 14.70           O  
ATOM   1145  CB  ASN A 156      31.213  91.879   4.057  1.00 14.56           C  
ATOM   1146  CG  ASN A 156      30.755  92.088   2.650  1.00 15.94           C  
ATOM   1147  OD1 ASN A 156      29.570  92.320   2.411  1.00 15.54           O  
ATOM   1148  ND2 ASN A 156      31.676  92.023   1.692  1.00 21.10           N  
ATOM   1149  N   ASP A 157      27.721  91.628   4.879  1.00 13.06           N  
ATOM   1150  CA  ASP A 157      26.527  92.446   4.914  1.00 14.38           C  
ATOM   1151  C   ASP A 157      26.278  93.122   6.263  1.00 14.96           C  
ATOM   1152  O   ASP A 157      26.623  92.598   7.317  1.00 14.25           O  
ATOM   1153  CB  ASP A 157      25.290  91.653   4.495  1.00 13.55           C  
ATOM   1154  CG  ASP A 157      25.235  91.371   3.006  1.00 15.11           C  
ATOM   1155  OD1 ASP A 157      25.999  91.984   2.239  1.00 16.01           O  
ATOM   1156  OD2 ASP A 157      24.394  90.513   2.614  1.00 16.33           O  
ATOM   1157  N   VAL A 158      25.673  94.294   6.237  1.00 14.54           N  
ATOM   1158  CA  VAL A 158      25.248  94.974   7.436  1.00 13.36           C  
ATOM   1159  C   VAL A 158      24.103  94.122   8.017  1.00 16.00           C  
ATOM   1160  O   VAL A 158      23.224  93.670   7.265  1.00 15.83           O  
ATOM   1161  CB  VAL A 158      24.759  96.405   7.105  1.00 15.25           C  
ATOM   1162  CG1 VAL A 158      24.022  97.030   8.303  1.00 15.42           C  
ATOM   1163  CG2 VAL A 158      25.949  97.269   6.648  1.00 15.65           C  
ATOM   1164  N   ALA A 159      24.129  93.864   9.322  1.00 14.61           N  
ATOM   1165  CA  ALA A 159      23.239  92.889   9.943  1.00 14.30           C  
ATOM   1166  C   ALA A 159      21.929  93.474  10.409  1.00 15.55           C  
ATOM   1167  O   ALA A 159      20.959  92.734  10.576  1.00 16.55           O  
ATOM   1168  CB  ALA A 159      23.931  92.268  11.149  1.00 14.48           C  
ATOM   1169  N   TRP A 160      21.919  94.774  10.725  1.00 13.90           N  
ATOM   1170  CA  TRP A 160      20.721  95.413  11.268  1.00 13.47           C  
ATOM   1171  C   TRP A 160      20.896  96.933  11.188  1.00 14.27           C  
ATOM   1172  O   TRP A 160      21.898  97.449  10.705  1.00 15.10           O  
ATOM   1173  CB  TRP A 160      20.429  94.945  12.699  1.00 14.43           C  
ATOM   1174  CG  TRP A 160      19.009  95.116  13.122  1.00 13.98           C  
ATOM   1175  CD1 TRP A 160      18.526  95.895  14.170  1.00 16.30           C  
ATOM   1176  CD2 TRP A 160      17.878  94.474  12.555  1.00 13.74           C  
ATOM   1177  NE1 TRP A 160      17.150  95.787  14.227  1.00 17.15           N  
ATOM   1178  CE2 TRP A 160      16.735  94.905  13.265  1.00 15.04           C  
ATOM   1179  CE3 TRP A 160      17.716  93.568  11.502  1.00 16.08           C  
ATOM   1180  CZ2 TRP A 160      15.448  94.476  12.928  1.00 15.84           C  
ATOM   1181  CZ3 TRP A 160      16.448  93.143  11.182  1.00 17.43           C  
ATOM   1182  CH2 TRP A 160      15.340  93.581  11.882  1.00 17.20           C  
ATOM   1183  N   ASN A 161      19.890  97.651  11.658  1.00 14.68           N  
ATOM   1184  CA  ASN A 161      19.993  99.083  11.817  1.00 15.56           C  
ATOM   1185  C   ASN A 161      21.143  99.440  12.748  1.00 15.63           C  
ATOM   1186  O   ASN A 161      21.409  98.718  13.712  1.00 15.20           O  
ATOM   1187  CB  ASN A 161      18.690  99.645  12.397  1.00 15.33           C  
ATOM   1188  CG  ASN A 161      17.491  99.228  11.582  1.00 17.64           C  
ATOM   1189  OD1 ASN A 161      17.388  99.503  10.397  1.00 15.69           O  
ATOM   1190  ND2 ASN A 161      16.599  98.496  12.221  1.00 24.26           N  
ATOM   1191  N   PHE A 162      21.801 100.545  12.469  1.00 14.00           N  
ATOM   1192  CA  PHE A 162      22.814 101.098  13.362  1.00 14.27           C  
ATOM   1193  C   PHE A 162      24.050 100.211  13.528  1.00 14.99           C  
ATOM   1194  O   PHE A 162      24.568 100.086  14.635  1.00 15.38           O  
ATOM   1195  CB  PHE A 162      22.235 101.520  14.736  1.00 14.90           C  
ATOM   1196  CG  PHE A 162      21.125 102.541  14.642  1.00 14.31           C  
ATOM   1197  CD1 PHE A 162      21.403 103.877  14.416  1.00 15.86           C  
ATOM   1198  CD2 PHE A 162      19.822 102.158  14.735  1.00 14.49           C  
ATOM   1199  CE1 PHE A 162      20.350 104.819  14.327  1.00 14.79           C  
ATOM   1200  CE2 PHE A 162      18.772 103.060  14.644  1.00 14.89           C  
ATOM   1201  CZ  PHE A 162      19.049 104.389  14.440  1.00 13.13           C  
ATOM   1202  N   GLU A 163      24.603  99.701  12.429  1.00 15.05           N  
ATOM   1203  CA  GLU A 163      26.018  99.398  12.449  1.00 14.15           C  
ATOM   1204  C   GLU A 163      26.774 100.727  12.332  1.00 15.04           C  
ATOM   1205  O   GLU A 163      26.205 101.758  11.911  1.00 15.87           O  
ATOM   1206  CB  GLU A 163      26.403  98.423  11.325  1.00 16.83           C  
ATOM   1207  CG  GLU A 163      26.078  96.964  11.693  1.00 16.24           C  
ATOM   1208  CD  GLU A 163      26.676  95.936  10.767  1.00 16.65           C  
ATOM   1209  OE1 GLU A 163      27.497  96.328   9.905  1.00 16.92           O  
ATOM   1210  OE2 GLU A 163      26.331  94.730  10.912  1.00 16.36           O  
ATOM   1211  N   LYS A 164      28.051 100.699  12.683  1.00 14.26           N  
ATOM   1212  CA  LYS A 164      28.871 101.913  12.737  1.00 14.69           C  
ATOM   1213  C   LYS A 164      30.216 101.673  12.057  1.00 14.58           C  
ATOM   1214  O   LYS A 164      30.813 100.614  12.215  1.00 15.33           O  
ATOM   1215  CB  LYS A 164      29.123 102.353  14.184  1.00 15.64           C  
ATOM   1216  CG  LYS A 164      27.863 102.612  14.971  1.00 16.20           C  
ATOM   1217  CD  LYS A 164      27.439 101.441  15.831  1.00 16.42           C  
ATOM   1218  CE  LYS A 164      26.171 101.751  16.630  1.00 15.99           C  
ATOM   1219  NZ  LYS A 164      25.560 100.494  17.188  1.00 16.38           N  
ATOM   1220  N   PHE A 165      30.638 102.659  11.267  1.00 14.91           N  
ATOM   1221  CA  PHE A 165      31.929 102.647  10.617  1.00 15.06           C  
ATOM   1222  C   PHE A 165      32.697 103.911  11.001  1.00 15.34           C  
ATOM   1223  O   PHE A 165      32.230 105.023  10.777  1.00 16.89           O  
ATOM   1224  CB  PHE A 165      31.743 102.565   9.107  1.00 15.48           C  
ATOM   1225  CG  PHE A 165      30.958 101.349   8.661  1.00 15.56           C  
ATOM   1226  CD1 PHE A 165      31.598 100.236   8.166  1.00 17.87           C  
ATOM   1227  CD2 PHE A 165      29.576 101.342   8.730  1.00 19.62           C  
ATOM   1228  CE1 PHE A 165      30.870  99.127   7.753  1.00 18.00           C  
ATOM   1229  CE2 PHE A 165      28.861 100.225   8.324  1.00 20.51           C  
ATOM   1230  CZ  PHE A 165      29.538  99.147   7.808  1.00 19.50           C  
ATOM   1231  N   LEU A 166      33.887 103.726  11.564  1.00 14.90           N  
ATOM   1232  CA  LEU A 166      34.772 104.812  11.970  1.00 14.89           C  
ATOM   1233  C   LEU A 166      35.823 104.964  10.883  1.00 16.55           C  
ATOM   1234  O   LEU A 166      36.504 103.987  10.517  1.00 17.03           O  
ATOM   1235  CB  LEU A 166      35.420 104.457  13.305  1.00 16.28           C  
ATOM   1236  CG  LEU A 166      36.374 105.483  13.885  1.00 17.33           C  
ATOM   1237  CD1 LEU A 166      35.647 106.806  14.108  1.00 20.60           C  
ATOM   1238  CD2 LEU A 166      36.964 104.956  15.203  1.00 17.45           C  
ATOM   1239  N   VAL A 167      35.945 106.185  10.372  1.00 14.90           N  
ATOM   1240  CA  VAL A 167      36.821 106.489   9.244  1.00 14.27           C  
ATOM   1241  C   VAL A 167      37.816 107.556   9.685  1.00 16.33           C  
ATOM   1242  O   VAL A 167      37.443 108.563  10.308  1.00 16.45           O  
ATOM   1243  CB  VAL A 167      36.016 107.012   8.041  1.00 15.34           C  
ATOM   1244  CG1 VAL A 167      36.946 107.298   6.842  1.00 16.42           C  
ATOM   1245  CG2 VAL A 167      34.896 106.038   7.649  1.00 16.52           C  
ATOM   1246  N   GLY A 168      39.087 107.346   9.353  1.00 16.80           N  
ATOM   1247  CA  GLY A 168      40.117 108.307   9.727  1.00 17.80           C  
ATOM   1248  C   GLY A 168      40.124 109.574   8.885  1.00 15.39           C  
ATOM   1249  O   GLY A 168      39.412 109.678   7.880  1.00 18.02           O  
ATOM   1250  N   PRO A 169      40.970 110.552   9.275  1.00 17.45           N  
ATOM   1251  CA  PRO A 169      41.037 111.856   8.632  1.00 16.88           C  
ATOM   1252  C   PRO A 169      41.671 111.858   7.245  1.00 19.46           C  
ATOM   1253  O   PRO A 169      41.688 112.918   6.597  1.00 20.10           O  
ATOM   1254  CB  PRO A 169      41.868 112.674   9.619  1.00 19.54           C  
ATOM   1255  CG  PRO A 169      42.760 111.670  10.253  1.00 19.18           C  
ATOM   1256  CD  PRO A 169      41.889 110.447  10.414  1.00 18.11           C  
ATOM   1257  N   ASP A 170      42.158 110.687   6.812  1.00 18.37           N  
ATOM   1258  CA  ASP A 170      42.625 110.421   5.440  1.00 23.02           C  
ATOM   1259  C   ASP A 170      41.616 109.631   4.582  1.00 20.88           C  
ATOM   1260  O   ASP A 170      41.924 109.227   3.447  1.00 21.43           O  
ATOM   1261  CB  ASP A 170      43.944 109.627   5.491  1.00 24.15           C  
ATOM   1262  CG  ASP A 170      43.869 108.355   6.369  1.00 36.63           C  
ATOM   1263  OD1 ASP A 170      42.832 108.038   7.059  1.00 23.62           O  
ATOM   1264  OD2 ASP A 170      44.913 107.659   6.371  1.00 42.67           O  
ATOM   1265  N   GLY A 171      40.429 109.382   5.122  1.00 17.67           N  
ATOM   1266  CA  GLY A 171      39.384 108.669   4.397  1.00 17.33           C  
ATOM   1267  C   GLY A 171      39.459 107.155   4.441  1.00 17.00           C  
ATOM   1268  O   GLY A 171      38.636 106.490   3.801  1.00 17.41           O  
ATOM   1269  N   VAL A 172      40.417 106.613   5.184  1.00 17.00           N  
ATOM   1270  CA  VAL A 172      40.583 105.167   5.315  1.00 17.73           C  
ATOM   1271  C   VAL A 172      39.642 104.615   6.397  1.00 18.89           C  
ATOM   1272  O   VAL A 172      39.668 105.079   7.536  1.00 18.91           O  
ATOM   1273  CB  VAL A 172      42.005 104.812   5.693  1.00 18.56           C  
ATOM   1274  CG1 VAL A 172      42.170 103.276   5.846  1.00 21.32           C  
ATOM   1275  CG2 VAL A 172      42.985 105.375   4.650  1.00 19.12           C  
ATOM   1276  N   PRO A 173      38.792 103.635   6.045  1.00 17.55           N  
ATOM   1277  CA  PRO A 173      37.978 103.005   7.088  1.00 18.32           C  
ATOM   1278  C   PRO A 173      38.839 102.297   8.099  1.00 18.87           C  
ATOM   1279  O   PRO A 173      39.731 101.530   7.715  1.00 21.22           O  
ATOM   1280  CB  PRO A 173      37.106 102.026   6.312  1.00 19.65           C  
ATOM   1281  CG  PRO A 173      37.127 102.547   4.882  1.00 19.87           C  
ATOM   1282  CD  PRO A 173      38.498 103.112   4.698  1.00 18.40           C  
ATOM   1283  N   LEU A 174      38.611 102.576   9.385  1.00 17.12           N  
ATOM   1284  CA  LEU A 174      39.451 102.030  10.441  1.00 18.80           C  
ATOM   1285  C   LEU A 174      38.807 100.911  11.248  1.00 18.11           C  
ATOM   1286  O   LEU A 174      39.489  99.946  11.566  1.00 17.82           O  
ATOM   1287  CB  LEU A 174      39.909 103.147  11.377  1.00 19.38           C  
ATOM   1288  CG  LEU A 174      40.796 104.155  10.627  1.00 26.50           C  
ATOM   1289  CD1 LEU A 174      41.025 105.380  11.499  1.00 31.77           C  
ATOM   1290  CD2 LEU A 174      42.124 103.526  10.169  1.00 28.81           C  
ATOM   1291  N   ARG A 175      37.514 101.016  11.569  1.00 16.06           N  
ATOM   1292  CA  ARG A 175      36.886 100.037  12.434  1.00 14.75           C  
ATOM   1293  C   ARG A 175      35.394 100.018  12.217  1.00 15.58           C  
ATOM   1294  O   ARG A 175      34.765 101.067  11.975  1.00 16.31           O  
ATOM   1295  CB  ARG A 175      37.200 100.326  13.910  1.00 17.00           C  
ATOM   1296  CG  ARG A 175      36.770  99.204  14.866  1.00 19.32           C  
ATOM   1297  CD  ARG A 175      37.482  99.263  16.214  1.00 18.66           C  
ATOM   1298  NE  ARG A 175      38.874  98.868  16.044  1.00 21.40           N  
ATOM   1299  CZ  ARG A 175      39.851  99.115  16.907  1.00 36.77           C  
ATOM   1300  NH1 ARG A 175      39.609  99.776  18.034  1.00 35.51           N  
ATOM   1301  NH2 ARG A 175      41.082  98.692  16.633  1.00 39.06           N  
ATOM   1302  N   ARG A 176      34.823  98.821  12.305  1.00 15.21           N  
ATOM   1303  CA  ARG A 176      33.388  98.614  12.166  1.00 13.94           C  
ATOM   1304  C   ARG A 176      32.869  98.095  13.490  1.00 14.13           C  
ATOM   1305  O   ARG A 176      33.555  97.328  14.159  1.00 15.62           O  
ATOM   1306  CB  ARG A 176      33.124  97.602  11.059  1.00 14.45           C  
ATOM   1307  CG  ARG A 176      31.688  97.287  10.740  1.00 14.60           C  
ATOM   1308  CD  ARG A 176      31.662  96.288   9.590  1.00 16.95           C  
ATOM   1309  NE  ARG A 176      30.296  95.868   9.257  1.00 15.48           N  
ATOM   1310  CZ  ARG A 176      30.008  95.050   8.254  1.00 15.46           C  
ATOM   1311  NH1 ARG A 176      30.965  94.619   7.431  1.00 15.64           N  
ATOM   1312  NH2 ARG A 176      28.744  94.724   8.028  1.00 15.96           N  
ATOM   1313  N   TYR A 177      31.657  98.490  13.849  1.00 14.65           N  
ATOM   1314  CA  TYR A 177      31.041  98.072  15.120  1.00 14.45           C  
ATOM   1315  C   TYR A 177      29.641  97.578  14.849  1.00 14.94           C  
ATOM   1316  O   TYR A 177      28.946  98.098  13.980  1.00 15.69           O  
ATOM   1317  CB  TYR A 177      30.993  99.245  16.113  1.00 13.61           C  
ATOM   1318  CG  TYR A 177      32.296  99.990  16.297  1.00 14.15           C  
ATOM   1319  CD1 TYR A 177      33.100  99.762  17.402  1.00 15.36           C  
ATOM   1320  CD2 TYR A 177      32.709 100.944  15.357  1.00 15.69           C  
ATOM   1321  CE1 TYR A 177      34.286 100.467  17.583  1.00 16.50           C  
ATOM   1322  CE2 TYR A 177      33.880 101.656  15.526  1.00 17.09           C  
ATOM   1323  CZ  TYR A 177      34.664 101.403  16.630  1.00 16.33           C  
ATOM   1324  OH  TYR A 177      35.832 102.112  16.832  1.00 18.18           O  
ATOM   1325  N   SER A 178      29.240  96.574  15.611  1.00 15.23           N  
ATOM   1326  CA  SER A 178      27.978  95.901  15.380  1.00 15.51           C  
ATOM   1327  C   SER A 178      26.788  96.700  15.832  1.00 14.30           C  
ATOM   1328  O   SER A 178      26.886  97.723  16.533  1.00 16.19           O  
ATOM   1329  CB  SER A 178      27.954  94.552  16.084  1.00 16.82           C  
ATOM   1330  OG  SER A 178      27.664  94.681  17.479  1.00 17.93           O  
ATOM   1331  N   ARG A 179      25.625  96.204  15.428  1.00 15.31           N  
ATOM   1332  CA  ARG A 179      24.354  96.771  15.850  1.00 15.01           C  
ATOM   1333  C   ARG A 179      24.172  96.894  17.364  1.00 16.45           C  
ATOM   1334  O   ARG A 179      23.395  97.722  17.825  1.00 18.31           O  
ATOM   1335  CB  ARG A 179      23.225  95.883  15.281  1.00 16.76           C  
ATOM   1336  CG  ARG A 179      23.279  94.436  15.801  1.00 19.50           C  
ATOM   1337  CD  ARG A 179      22.090  93.528  15.447  1.00 18.48           C  
ATOM   1338  NE  ARG A 179      20.885  93.945  16.123  1.00 20.29           N  
ATOM   1339  CZ  ARG A 179      19.735  93.280  16.084  1.00 24.73           C  
ATOM   1340  NH1 ARG A 179      19.609  92.215  15.311  1.00 24.53           N  
ATOM   1341  NH2 ARG A 179      18.701  93.717  16.784  1.00 28.06           N  
ATOM   1342  N   ARG A 180      24.874  96.056  18.119  1.00 15.42           N  
ATOM   1343  CA  ARG A 180      24.736  96.030  19.582  0.70 17.30           C  
ATOM   1345  C   ARG A 180      25.739  96.922  20.295  1.00 18.01           C  
ATOM   1346  O   ARG A 180      25.555  97.223  21.466  1.00 17.38           O  
ATOM   1347  CB  ARG A 180      24.858  94.598  20.104  0.70 19.01           C  
ATOM   1349  CG  ARG A 180      23.665  93.747  19.694  0.70 20.00           C  
ATOM   1351  CD  ARG A 180      23.812  92.271  20.025  0.70 23.36           C  
ATOM   1353  NE  ARG A 180      22.641  91.575  19.483  0.70 31.97           N  
ATOM   1355  CZ  ARG A 180      22.555  91.003  18.280  0.70 39.06           C  
ATOM   1357  NH1 ARG A 180      23.593  90.969  17.455  0.70 35.03           N  
ATOM   1359  NH2 ARG A 180      21.413  90.439  17.903  0.70 38.11           N  
ATOM   1361  N   PHE A 181      26.785  97.316  19.596  1.00 16.43           N  
ATOM   1362  CA  PHE A 181      27.870  98.116  20.198  1.00 15.00           C  
ATOM   1363  C   PHE A 181      27.415  99.586  20.249  1.00 16.68           C  
ATOM   1364  O   PHE A 181      27.245 100.242  19.220  1.00 17.38           O  
ATOM   1365  CB  PHE A 181      29.145  97.930  19.370  1.00 15.35           C  
ATOM   1366  CG  PHE A 181      30.371  98.467  20.029  1.00 15.38           C  
ATOM   1367  CD1 PHE A 181      31.232  97.630  20.691  1.00 15.74           C  
ATOM   1368  CD2 PHE A 181      30.650  99.829  20.007  1.00 15.51           C  
ATOM   1369  CE1 PHE A 181      32.363  98.123  21.333  1.00 15.48           C  
ATOM   1370  CE2 PHE A 181      31.786 100.322  20.621  1.00 16.08           C  
ATOM   1371  CZ  PHE A 181      32.630  99.463  21.300  1.00 14.66           C  
ATOM   1372  N   GLN A 182      27.208 100.122  21.441  1.00 17.35           N  
ATOM   1373  CA  GLN A 182      26.624 101.451  21.570  1.00 16.19           C  
ATOM   1374  C   GLN A 182      27.476 102.503  20.878  1.00 14.81           C  
ATOM   1375  O   GLN A 182      28.686 102.507  21.020  1.00 15.40           O  
ATOM   1376  CB  GLN A 182      26.580 101.866  23.025  1.00 19.90           C  
ATOM   1377  CG  GLN A 182      25.652 101.126  23.868  1.00 22.19           C  
ATOM   1378  CD  GLN A 182      25.502 101.858  25.166  1.00 25.32           C  
ATOM   1379  OE1 GLN A 182      24.515 102.557  25.366  1.00 19.93           O  
ATOM   1380  NE2 GLN A 182      26.542 101.787  26.026  1.00 26.59           N  
ATOM   1381  N   THR A 183      26.819 103.436  20.194  1.00 15.22           N  
ATOM   1382  CA  THR A 183      27.479 104.613  19.641  1.00 15.29           C  
ATOM   1383  C   THR A 183      28.400 105.306  20.656  1.00 15.01           C  
ATOM   1384  O   THR A 183      29.551 105.605  20.365  1.00 15.44           O  
ATOM   1385  CB  THR A 183      26.410 105.601  19.123  1.00 15.50           C  
ATOM   1386  OG1 THR A 183      25.753 105.017  17.983  1.00 16.08           O  
ATOM   1387  CG2 THR A 183      27.011 106.965  18.761  1.00 15.34           C  
ATOM   1388  N   ILE A 184      27.905 105.521  21.866  1.00 14.67           N  
ATOM   1389  CA  ILE A 184      28.703 106.249  22.861  1.00 16.05           C  
ATOM   1390  C   ILE A 184      29.953 105.481  23.277  1.00 16.75           C  
ATOM   1391  O   ILE A 184      30.943 106.086  23.687  1.00 17.48           O  
ATOM   1392  CB  ILE A 184      27.845 106.608  24.055  1.00 16.28           C  
ATOM   1393  CG1 ILE A 184      28.431 107.813  24.805  1.00 20.81           C  
ATOM   1394  CG2 ILE A 184      27.638 105.394  24.986  1.00 17.30           C  
ATOM   1395  CD1 ILE A 184      28.200 109.139  24.015  1.00 23.55           C  
ATOM   1396  N   ASP A 185      29.936 104.158  23.119  1.00 14.24           N  
ATOM   1397  CA  ASP A 185      31.116 103.336  23.437  1.00 15.08           C  
ATOM   1398  C   ASP A 185      32.218 103.401  22.372  1.00 17.22           C  
ATOM   1399  O   ASP A 185      33.303 102.820  22.559  1.00 16.38           O  
ATOM   1400  CB  ASP A 185      30.703 101.877  23.665  1.00 14.20           C  
ATOM   1401  CG  ASP A 185      29.983 101.658  24.994  1.00 16.96           C  
ATOM   1402  OD1 ASP A 185      30.145 102.502  25.893  1.00 17.68           O  
ATOM   1403  OD2 ASP A 185      29.280 100.629  25.117  1.00 17.17           O  
ATOM   1404  N   ILE A 186      31.960 104.111  21.272  1.00 14.59           N  
ATOM   1405  CA  ILE A 186      32.957 104.329  20.262  1.00 15.08           C  
ATOM   1406  C   ILE A 186      33.853 105.541  20.634  1.00 15.49           C  
ATOM   1407  O   ILE A 186      34.909 105.746  20.032  1.00 15.58           O  
ATOM   1408  CB  ILE A 186      32.274 104.533  18.872  1.00 14.61           C  
ATOM   1409  CG1 ILE A 186      31.424 103.322  18.534  1.00 15.12           C  
ATOM   1410  CG2 ILE A 186      33.314 104.729  17.751  1.00 14.38           C  
ATOM   1411  CD1 ILE A 186      30.565 103.488  17.254  1.00 15.56           C  
ATOM   1412  N   GLU A 187      33.446 106.331  21.624  1.00 16.27           N  
ATOM   1413  CA  GLU A 187      34.135 107.599  21.930  0.50 15.23           C  
ATOM   1415  C   GLU A 187      35.651 107.433  22.118  1.00 17.75           C  
ATOM   1416  O   GLU A 187      36.428 108.218  21.578  1.00 18.39           O  
ATOM   1417  CB  GLU A 187      33.482 108.291  23.135  0.50 17.21           C  
ATOM   1419  CG  GLU A 187      34.243 109.515  23.699  0.50 17.12           C  
ATOM   1421  CD  GLU A 187      35.318 109.163  24.734  0.50 23.24           C  
ATOM   1423  OE1 GLU A 187      35.189 108.123  25.424  0.50 20.98           O  
ATOM   1425  OE2 GLU A 187      36.296 109.941  24.872  0.50 29.03           O  
ATOM   1427  N   PRO A 188      36.088 106.429  22.904  1.00 16.96           N  
ATOM   1428  CA  PRO A 188      37.566 106.312  23.066  1.00 16.99           C  
ATOM   1429  C   PRO A 188      38.346 106.104  21.781  1.00 20.64           C  
ATOM   1430  O   PRO A 188      39.437 106.667  21.623  1.00 20.47           O  
ATOM   1431  CB  PRO A 188      37.715 105.103  23.998  1.00 16.39           C  
ATOM   1432  CG  PRO A 188      36.485 105.092  24.792  1.00 18.98           C  
ATOM   1433  CD  PRO A 188      35.406 105.451  23.764  1.00 18.38           C  
ATOM   1434  N   ASP A 189      37.808 105.324  20.848  1.00 19.19           N  
ATOM   1435  CA  ASP A 189      38.451 105.145  19.555  1.00 18.34           C  
ATOM   1436  C   ASP A 189      38.468 106.439  18.740  1.00 21.00           C  
ATOM   1437  O   ASP A 189      39.424 106.718  18.012  1.00 22.52           O  
ATOM   1438  CB  ASP A 189      37.746 104.037  18.751  1.00 17.81           C  
ATOM   1439  CG  ASP A 189      38.012 102.651  19.300  1.00 20.76           C  
ATOM   1440  OD1 ASP A 189      38.956 102.488  20.108  1.00 24.14           O  
ATOM   1441  OD2 ASP A 189      37.324 101.674  18.899  1.00 19.02           O  
ATOM   1442  N   ILE A 190      37.392 107.214  18.832  1.00 19.02           N  
ATOM   1443  CA  ILE A 190      37.317 108.498  18.156  1.00 19.60           C  
ATOM   1444  C   ILE A 190      38.336 109.482  18.756  1.00 20.60           C  
ATOM   1445  O   ILE A 190      39.072 110.162  18.031  1.00 20.83           O  
ATOM   1446  CB  ILE A 190      35.914 109.108  18.272  1.00 19.11           C  
ATOM   1447  CG1 ILE A 190      34.918 108.336  17.407  1.00 18.05           C  
ATOM   1448  CG2 ILE A 190      35.931 110.572  17.844  1.00 20.26           C  
ATOM   1449  CD1 ILE A 190      33.452 108.623  17.761  1.00 17.67           C  
ATOM   1450  N   GLU A 191      38.361 109.560  20.078  1.00 18.78           N  
ATOM   1451  CA  GLU A 191      39.298 110.441  20.776  1.00 17.32           C  
ATOM   1452  C   GLU A 191      40.734 110.156  20.364  1.00 21.70           C  
ATOM   1453  O   GLU A 191      41.529 111.088  20.193  1.00 23.31           O  
ATOM   1454  CB  GLU A 191      39.142 110.246  22.281  1.00 23.84           C  
ATOM   1455  CG  GLU A 191      40.065 111.089  23.140  1.00 26.00           C  
ATOM   1456  CD  GLU A 191      39.830 112.566  22.965  1.00 35.60           C  
ATOM   1457  OE1 GLU A 191      38.683 112.951  22.656  1.00 30.16           O  
ATOM   1458  OE2 GLU A 191      40.800 113.345  23.133  1.00 34.29           O  
ATOM   1459  N   ALA A 192      41.085 108.883  20.229  1.00 20.53           N  
ATOM   1460  CA  ALA A 192      42.457 108.512  19.826  1.00 20.19           C  
ATOM   1461  C   ALA A 192      42.828 109.085  18.455  1.00 26.07           C  
ATOM   1462  O   ALA A 192      43.968 109.461  18.217  1.00 27.76           O  
ATOM   1463  CB  ALA A 192      42.631 107.005  19.836  1.00 23.96           C  
ATOM   1464  N   LEU A 193      41.863 109.156  17.554  1.00 23.77           N  
ATOM   1465  CA  LEU A 193      42.093 109.698  16.213  1.00 24.71           C  
ATOM   1466  C   LEU A 193      42.093 111.211  16.198  1.00 29.89           C  
ATOM   1467  O   LEU A 193      42.802 111.826  15.400  1.00 30.00           O  
ATOM   1468  CB  LEU A 193      41.010 109.227  15.245  1.00 27.66           C  
ATOM   1469  CG  LEU A 193      40.989 107.749  14.918  1.00 26.67           C  
ATOM   1470  CD1 LEU A 193      39.793 107.465  14.024  1.00 22.30           C  
ATOM   1471  CD2 LEU A 193      42.312 107.333  14.247  1.00 27.07           C  
ATOM   1472  N   LEU A 194      41.272 111.813  17.050  1.00 28.69           N  
ATOM   1473  CA  LEU A 194      41.221 113.259  17.150  1.00 29.20           C  
ATOM   1474  C   LEU A 194      42.525 113.777  17.734  1.00 33.93           C  
ATOM   1475  O   LEU A 194      43.001 114.833  17.332  1.00 34.32           O  
ATOM   1476  CB  LEU A 194      40.048 113.701  18.015  1.00 28.21           C  
ATOM   1477  CG  LEU A 194      38.655 113.480  17.432  1.00 23.82           C  
ATOM   1478  CD1 LEU A 194      37.642 113.950  18.435  1.00 24.74           C  
ATOM   1479  CD2 LEU A 194      38.471 114.195  16.107  1.00 25.79           C  
ATOM   1480  N   SER A 195      43.085 113.017  18.673  1.00 37.68           N  
ATOM   1481  CA  SER A 195      44.341 113.347  19.335  1.00 43.62           C  
ATOM   1482  C   SER A 195      45.532 113.129  18.405  1.00 46.74           C  
ATOM   1483  O   SER A 195      45.808 112.001  17.985  1.00 50.59           O  
ATOM   1484  CB  SER A 195      44.503 112.475  20.580  1.00 43.18           C  
ATOM   1485  OG  SER A 195      43.387 112.615  21.439  1.00 49.55           O  
TER    1486      SER A 195                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
